// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S1537C5_nt  {
  int s1537c5f0[2];
  void  mf1537c5(); // _ZN10S1537C5_nt8mf1537c5Ev
};
//SIG(-1 S1537C5_nt) C1{ m Fi[2]}


void  S1537C5_nt ::mf1537c5(){}

//skip512 S1537C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C4_nt  {
  int s1537c4f0;
  __tsi64 s1537c4f1;
  void *s1537c4f2[4];
  int s1537c4f3[2];
  void *s1537c4f4;
  ::S1537C5_nt s1537c4f5;
  void *s1537c4f6[2];
  virtual  ~S1537C4_nt(); // _ZN10S1537C4_ntD1Ev
  virtual void  v7(); // _ZN10S1537C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1537C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1537C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1537C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1537C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1537C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1537C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1537C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1537C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1537C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1537C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1537C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1537C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1537C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1537C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1537C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1537C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1537C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1537C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1537C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1537C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1537C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1537C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1537C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1537C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1537C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1537C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1537C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1537C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1537C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1537C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1537C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1537C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1537C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1537C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1537C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1537C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1537C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1537C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1537C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1537C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1537C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1537C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1537C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1537C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1537C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1537C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1537C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1537C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1537C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1537C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1537C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1537C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1537C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1537C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1537C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1537C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1537C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1537C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1537C4_nt3v66Ev
  virtual void  v67(); // _ZN10S1537C4_nt3v67Ev
  virtual void  v68(); // _ZN10S1537C4_nt3v68Ev
  virtual void  v69(); // _ZN10S1537C4_nt3v69Ev
  virtual void  v70(); // _ZN10S1537C4_nt3v70Ev
  S1537C4_nt(); // tgen
};
//SIG(-1 S1537C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1537C4_nt ::~S1537C4_nt(){ note_dtor("S1537C4_nt", this);}
void  S1537C4_nt ::v7(){vfunc_called(this, "_ZN10S1537C4_nt2v7Ev");}
void  S1537C4_nt ::v8(){vfunc_called(this, "_ZN10S1537C4_nt2v8Ev");}
void  S1537C4_nt ::v9(){vfunc_called(this, "_ZN10S1537C4_nt2v9Ev");}
void  S1537C4_nt ::v10(){vfunc_called(this, "_ZN10S1537C4_nt3v10Ev");}
void  S1537C4_nt ::v11(){vfunc_called(this, "_ZN10S1537C4_nt3v11Ev");}
void  S1537C4_nt ::v12(){vfunc_called(this, "_ZN10S1537C4_nt3v12Ev");}
void  S1537C4_nt ::v13(){vfunc_called(this, "_ZN10S1537C4_nt3v13Ev");}
void  S1537C4_nt ::v14(){vfunc_called(this, "_ZN10S1537C4_nt3v14Ev");}
void  S1537C4_nt ::v15(){vfunc_called(this, "_ZN10S1537C4_nt3v15Ev");}
void  S1537C4_nt ::v16(){vfunc_called(this, "_ZN10S1537C4_nt3v16Ev");}
void  S1537C4_nt ::v17(){vfunc_called(this, "_ZN10S1537C4_nt3v17Ev");}
void  S1537C4_nt ::v18(){vfunc_called(this, "_ZN10S1537C4_nt3v18Ev");}
void  S1537C4_nt ::v19(){vfunc_called(this, "_ZN10S1537C4_nt3v19Ev");}
void  S1537C4_nt ::v20(){vfunc_called(this, "_ZN10S1537C4_nt3v20Ev");}
void  S1537C4_nt ::v21(){vfunc_called(this, "_ZN10S1537C4_nt3v21Ev");}
void  S1537C4_nt ::v22(){vfunc_called(this, "_ZN10S1537C4_nt3v22Ev");}
void  S1537C4_nt ::v23(){vfunc_called(this, "_ZN10S1537C4_nt3v23Ev");}
void  S1537C4_nt ::v24(){vfunc_called(this, "_ZN10S1537C4_nt3v24Ev");}
void  S1537C4_nt ::v25(){vfunc_called(this, "_ZN10S1537C4_nt3v25Ev");}
void  S1537C4_nt ::v26(){vfunc_called(this, "_ZN10S1537C4_nt3v26Ev");}
void  S1537C4_nt ::v27(){vfunc_called(this, "_ZN10S1537C4_nt3v27Ev");}
void  S1537C4_nt ::v28(){vfunc_called(this, "_ZN10S1537C4_nt3v28Ev");}
void  S1537C4_nt ::v29(){vfunc_called(this, "_ZN10S1537C4_nt3v29Ev");}
void  S1537C4_nt ::v30(){vfunc_called(this, "_ZN10S1537C4_nt3v30Ev");}
void  S1537C4_nt ::v31(){vfunc_called(this, "_ZN10S1537C4_nt3v31Ev");}
void  S1537C4_nt ::v32(){vfunc_called(this, "_ZN10S1537C4_nt3v32Ev");}
void  S1537C4_nt ::v33(){vfunc_called(this, "_ZN10S1537C4_nt3v33Ev");}
void  S1537C4_nt ::v34(){vfunc_called(this, "_ZN10S1537C4_nt3v34Ev");}
void  S1537C4_nt ::v35(){vfunc_called(this, "_ZN10S1537C4_nt3v35Ev");}
void  S1537C4_nt ::v36(){vfunc_called(this, "_ZN10S1537C4_nt3v36Ev");}
void  S1537C4_nt ::v37(){vfunc_called(this, "_ZN10S1537C4_nt3v37Ev");}
void  S1537C4_nt ::v38(){vfunc_called(this, "_ZN10S1537C4_nt3v38Ev");}
void  S1537C4_nt ::v39(){vfunc_called(this, "_ZN10S1537C4_nt3v39Ev");}
void  S1537C4_nt ::v40(){vfunc_called(this, "_ZN10S1537C4_nt3v40Ev");}
void  S1537C4_nt ::v41(){vfunc_called(this, "_ZN10S1537C4_nt3v41Ev");}
void  S1537C4_nt ::v42(){vfunc_called(this, "_ZN10S1537C4_nt3v42Ev");}
void  S1537C4_nt ::v43(){vfunc_called(this, "_ZN10S1537C4_nt3v43Ev");}
void  S1537C4_nt ::v44(){vfunc_called(this, "_ZN10S1537C4_nt3v44Ev");}
void  S1537C4_nt ::v45(){vfunc_called(this, "_ZN10S1537C4_nt3v45Ev");}
void  S1537C4_nt ::v46(){vfunc_called(this, "_ZN10S1537C4_nt3v46Ev");}
void  S1537C4_nt ::v47(){vfunc_called(this, "_ZN10S1537C4_nt3v47Ev");}
void  S1537C4_nt ::v48(){vfunc_called(this, "_ZN10S1537C4_nt3v48Ev");}
void  S1537C4_nt ::v49(){vfunc_called(this, "_ZN10S1537C4_nt3v49Ev");}
void  S1537C4_nt ::v50(){vfunc_called(this, "_ZN10S1537C4_nt3v50Ev");}
void  S1537C4_nt ::v51(){vfunc_called(this, "_ZN10S1537C4_nt3v51Ev");}
void  S1537C4_nt ::v52(){vfunc_called(this, "_ZN10S1537C4_nt3v52Ev");}
void  S1537C4_nt ::v53(){vfunc_called(this, "_ZN10S1537C4_nt3v53Ev");}
void  S1537C4_nt ::v54(){vfunc_called(this, "_ZN10S1537C4_nt3v54Ev");}
void  S1537C4_nt ::v55(){vfunc_called(this, "_ZN10S1537C4_nt3v55Ev");}
void  S1537C4_nt ::v56(){vfunc_called(this, "_ZN10S1537C4_nt3v56Ev");}
void  S1537C4_nt ::v57(){vfunc_called(this, "_ZN10S1537C4_nt3v57Ev");}
void  S1537C4_nt ::v58(){vfunc_called(this, "_ZN10S1537C4_nt3v58Ev");}
void  S1537C4_nt ::v59(){vfunc_called(this, "_ZN10S1537C4_nt3v59Ev");}
void  S1537C4_nt ::v60(){vfunc_called(this, "_ZN10S1537C4_nt3v60Ev");}
void  S1537C4_nt ::v61(){vfunc_called(this, "_ZN10S1537C4_nt3v61Ev");}
void  S1537C4_nt ::v62(){vfunc_called(this, "_ZN10S1537C4_nt3v62Ev");}
void  S1537C4_nt ::v63(){vfunc_called(this, "_ZN10S1537C4_nt3v63Ev");}
void  S1537C4_nt ::v64(){vfunc_called(this, "_ZN10S1537C4_nt3v64Ev");}
void  S1537C4_nt ::v65(){vfunc_called(this, "_ZN10S1537C4_nt3v65Ev");}
void  S1537C4_nt ::v66(){vfunc_called(this, "_ZN10S1537C4_nt3v66Ev");}
void  S1537C4_nt ::v67(){vfunc_called(this, "_ZN10S1537C4_nt3v67Ev");}
void  S1537C4_nt ::v68(){vfunc_called(this, "_ZN10S1537C4_nt3v68Ev");}
void  S1537C4_nt ::v69(){vfunc_called(this, "_ZN10S1537C4_nt3v69Ev");}
void  S1537C4_nt ::v70(){vfunc_called(this, "_ZN10S1537C4_nt3v70Ev");}
S1537C4_nt ::S1537C4_nt(){ note_ctor("S1537C4_nt", this);} // tgen

//skip512 S1537C4_nt

#else // __cplusplus

extern void _ZN10S1537C4_ntC1Ev();
extern void _ZN10S1537C4_ntD1Ev();
Name_Map name_map_S1537C4_nt[] = {
  NSPAIR(_ZN10S1537C4_ntC1Ev),
  NSPAIR(_ZN10S1537C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1537C4_nt[];
extern void _ZN10S1537C4_ntD1Ev();
extern void _ZN10S1537C4_ntD0Ev();
extern void _ZN10S1537C4_nt2v7Ev();
extern void _ZN10S1537C4_nt2v8Ev();
extern void _ZN10S1537C4_nt2v9Ev();
extern void _ZN10S1537C4_nt3v10Ev();
extern void _ZN10S1537C4_nt3v11Ev();
extern void _ZN10S1537C4_nt3v12Ev();
extern void _ZN10S1537C4_nt3v13Ev();
extern void _ZN10S1537C4_nt3v14Ev();
extern void _ZN10S1537C4_nt3v15Ev();
extern void _ZN10S1537C4_nt3v16Ev();
extern void _ZN10S1537C4_nt3v17Ev();
extern void _ZN10S1537C4_nt3v18Ev();
extern void _ZN10S1537C4_nt3v19Ev();
extern void _ZN10S1537C4_nt3v20Ev();
extern void _ZN10S1537C4_nt3v21Ev();
extern void _ZN10S1537C4_nt3v22Ev();
extern void _ZN10S1537C4_nt3v23Ev();
extern void _ZN10S1537C4_nt3v24Ev();
extern void _ZN10S1537C4_nt3v25Ev();
extern void _ZN10S1537C4_nt3v26Ev();
extern void _ZN10S1537C4_nt3v27Ev();
extern void _ZN10S1537C4_nt3v28Ev();
extern void _ZN10S1537C4_nt3v29Ev();
extern void _ZN10S1537C4_nt3v30Ev();
extern void _ZN10S1537C4_nt3v31Ev();
extern void _ZN10S1537C4_nt3v32Ev();
extern void _ZN10S1537C4_nt3v33Ev();
extern void _ZN10S1537C4_nt3v34Ev();
extern void _ZN10S1537C4_nt3v35Ev();
extern void _ZN10S1537C4_nt3v36Ev();
extern void _ZN10S1537C4_nt3v37Ev();
extern void _ZN10S1537C4_nt3v38Ev();
extern void _ZN10S1537C4_nt3v39Ev();
extern void _ZN10S1537C4_nt3v40Ev();
extern void _ZN10S1537C4_nt3v41Ev();
extern void _ZN10S1537C4_nt3v42Ev();
extern void _ZN10S1537C4_nt3v43Ev();
extern void _ZN10S1537C4_nt3v44Ev();
extern void _ZN10S1537C4_nt3v45Ev();
extern void _ZN10S1537C4_nt3v46Ev();
extern void _ZN10S1537C4_nt3v47Ev();
extern void _ZN10S1537C4_nt3v48Ev();
extern void _ZN10S1537C4_nt3v49Ev();
extern void _ZN10S1537C4_nt3v50Ev();
extern void _ZN10S1537C4_nt3v51Ev();
extern void _ZN10S1537C4_nt3v52Ev();
extern void _ZN10S1537C4_nt3v53Ev();
extern void _ZN10S1537C4_nt3v54Ev();
extern void _ZN10S1537C4_nt3v55Ev();
extern void _ZN10S1537C4_nt3v56Ev();
extern void _ZN10S1537C4_nt3v57Ev();
extern void _ZN10S1537C4_nt3v58Ev();
extern void _ZN10S1537C4_nt3v59Ev();
extern void _ZN10S1537C4_nt3v60Ev();
extern void _ZN10S1537C4_nt3v61Ev();
extern void _ZN10S1537C4_nt3v62Ev();
extern void _ZN10S1537C4_nt3v63Ev();
extern void _ZN10S1537C4_nt3v64Ev();
extern void _ZN10S1537C4_nt3v65Ev();
extern void _ZN10S1537C4_nt3v66Ev();
extern void _ZN10S1537C4_nt3v67Ev();
extern void _ZN10S1537C4_nt3v68Ev();
extern void _ZN10S1537C4_nt3v69Ev();
extern void _ZN10S1537C4_nt3v70Ev();
static  VTBL_ENTRY vtc_S1537C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1537C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1537C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v70Ev,
};
extern VTBL_ENTRY _ZTI10S1537C4_nt[];
VTBL_ENTRY *P__ZTI10S1537C4_nt = _ZTI10S1537C4_nt; 
extern  VTBL_ENTRY _ZTV10S1537C4_nt[];
Class_Descriptor cd_S1537C4_nt = {  "S1537C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1537C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1537C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1537C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C8_nt  {
  void *s1537c8f0;
  int s1537c8f1[2];
  void  mf1537c8(); // _ZN10S1537C8_nt8mf1537c8Ev
};
//SIG(-1 S1537C8_nt) C1{ m Fp Fi[2]}


void  S1537C8_nt ::mf1537c8(){}

//skip512 S1537C8_nt

#else // __cplusplus

Class_Descriptor cd_S1537C8_nt = {  "S1537C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C7_nt  : S1537C8_nt {
};
//SIG(-1 S1537C7_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1537C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1537C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1537C7_nt = {  "S1537C7_nt", // class name
  bases_S1537C7_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C6_nt  : S1537C7_nt {
};
//SIG(-1 S1537C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1537C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1537C7_nt;
static Base_Class bases_S1537C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1537C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C9_nt  {
  int s1537c9f0;
  void  mf1537c9(); // _ZN10S1537C9_nt8mf1537c9Ev
};
//SIG(-1 S1537C9_nt) C1{ m Fi}


void  S1537C9_nt ::mf1537c9(){}

//skip512 S1537C9_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S1537C9_nt[];
VTBL_ENTRY *P__ZTI10S1537C9_nt = _ZTI10S1537C9_nt; 
Class_Descriptor cd_S1537C9_nt = {  "S1537C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S1537C9_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C13  : S1537C8_nt {
};
//SIG(-1 S1537C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1537C13()
{
  extern Class_Descriptor cd_S1537C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1537C13, buf);
    S1537C13 &lv = *(new (buf) S1537C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1537C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1537C13)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1537C13");
    test_class_info(&lv, &cd_S1537C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1537C13(Test_S1537C13, "S1537C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1537C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1537C13 = {  "S1537C13", // class name
  bases_S1537C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C12  : S1537C13 {
};
//SIG(-1 S1537C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1537C12()
{
  extern Class_Descriptor cd_S1537C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1537C12, buf);
    S1537C12 &lv = *(new (buf) S1537C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1537C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1537C12)");
    check_base_class_offset(lv, (S1537C8_nt*)(S1537C13*), 0, "S1537C12");
    check_base_class_offset(lv, (S1537C13*), 0, "S1537C12");
    test_class_info(&lv, &cd_S1537C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1537C12(Test_S1537C12, "S1537C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1537C13;
static Base_Class bases_S1537C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1537C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1537C12 = {  "S1537C12", // class name
  bases_S1537C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C14_nt  {
  int s1537c14f0[3];
  void  mf1537c14(); // _ZN11S1537C14_nt9mf1537c14Ev
};
//SIG(-1 S1537C14_nt) C1{ m Fi[3]}


void  S1537C14_nt ::mf1537c14(){}

//skip512 S1537C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C19  : S1537C8_nt {
};
//SIG(-1 S1537C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1537C19()
{
  extern Class_Descriptor cd_S1537C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1537C19, buf);
    S1537C19 &lv = *(new (buf) S1537C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1537C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1537C19)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1537C19");
    test_class_info(&lv, &cd_S1537C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1537C19(Test_S1537C19, "S1537C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1537C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1537C19 = {  "S1537C19", // class name
  bases_S1537C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C18  : S1537C19 {
};
//SIG(-1 S1537C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1537C18()
{
  extern Class_Descriptor cd_S1537C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1537C18, buf);
    S1537C18 &lv = *(new (buf) S1537C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1537C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1537C18)");
    check_base_class_offset(lv, (S1537C8_nt*)(S1537C19*), 0, "S1537C18");
    check_base_class_offset(lv, (S1537C19*), 0, "S1537C18");
    test_class_info(&lv, &cd_S1537C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1537C18(Test_S1537C18, "S1537C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1537C19;
static Base_Class bases_S1537C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1537C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1537C18 = {  "S1537C18", // class name
  bases_S1537C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C3_nt  : S1537C4_nt {
  ::S1537C6_nt s1537c3f0;
  ::S1537C6_nt s1537c3f1;
  ::S1537C9_nt s1537c3f2;
  int s1537c3f3;
  char s1537c3f4[4];
  void *s1537c3f5[2];
  ::S1537C6_nt s1537c3f6;
  unsigned int s1537c3f7:1;
  unsigned int s1537c3f8:1;
  unsigned int s1537c3f9:1;
  unsigned int s1537c3f10:1;
  unsigned int s1537c3f11:1;
  unsigned int s1537c3f12:1;
  unsigned int s1537c3f13:1;
  unsigned int s1537c3f14:1;
  unsigned int s1537c3f15:1;
  unsigned int s1537c3f16:1;
  unsigned int s1537c3f17:1;
  unsigned int s1537c3f18:1;
  unsigned int s1537c3f19:1;
  unsigned int s1537c3f20:1;
  unsigned int s1537c3f21:1;
  unsigned int s1537c3f22:1;
  unsigned int s1537c3f23:1;
  unsigned int s1537c3f24:1;
  unsigned int s1537c3f25:1;
  unsigned int s1537c3f26:1;
  unsigned int s1537c3f27:1;
  unsigned int s1537c3f28:1;
  unsigned int s1537c3f29:1;
  unsigned int s1537c3f30:1;
  unsigned int s1537c3f31:1;
  unsigned int s1537c3f32:1;
  unsigned int s1537c3f33:1;
  unsigned int s1537c3f34:1;
  unsigned int s1537c3f35:1;
  unsigned int s1537c3f36:1;
  unsigned int s1537c3f37:1;
  unsigned int s1537c3f38:1;
  unsigned int s1537c3f39:1;
  unsigned int s1537c3f40:1;
  unsigned int s1537c3f41:1;
  unsigned int s1537c3f42:1;
  unsigned int s1537c3f43:1;
  unsigned int s1537c3f44:1;
  unsigned int s1537c3f45:1;
  unsigned int s1537c3f46:1;
  unsigned int s1537c3f47:1;
  unsigned int s1537c3f48:1;
  unsigned int s1537c3f49:1;
  unsigned int s1537c3f50:1;
  unsigned int s1537c3f51:1;
  unsigned int s1537c3f52:1;
  unsigned int s1537c3f53:1;
  unsigned int s1537c3f54:1;
  unsigned int s1537c3f55:1;
  unsigned int s1537c3f56:1;
  unsigned int s1537c3f57:1;
  unsigned int s1537c3f58:1;
  unsigned int s1537c3f59:1;
  unsigned int s1537c3f60:1;
  unsigned int s1537c3f61:1;
  unsigned int s1537c3f62:1;
  unsigned int s1537c3f63:1;
  unsigned int s1537c3f64:1;
  unsigned int s1537c3f65:1;
  unsigned int s1537c3f66:1;
  unsigned int s1537c3f67:1;
  unsigned int s1537c3f68:1;
  unsigned int s1537c3f69:1;
  unsigned int s1537c3f70:1;
  unsigned int s1537c3f71:1;
  unsigned int s1537c3f72:1;
  unsigned int s1537c3f73:1;
  unsigned int s1537c3f74:1;
  unsigned int s1537c3f75:1;
  unsigned int s1537c3f76:1;
  unsigned int s1537c3f77:1;
  unsigned int s1537c3f78:1;
  unsigned int s1537c3f79:1;
  unsigned int s1537c3f80:1;
  unsigned int s1537c3f81:1;
  unsigned int s1537c3f82:1;
  unsigned int s1537c3f83:1;
  int s1537c3f84[5];
  void *s1537c3f85[2];
  int s1537c3f86[3];
  ::S1537C5_nt s1537c3f87;
  ::S1537C5_nt s1537c3f88;
  ::S1537C5_nt s1537c3f89;
  ::S1537C12 s1537c3f90;
  ::S1537C12 s1537c3f91;
  int s1537c3f92;
  void *s1537c3f93[2];
  ::S1537C14_nt s1537c3f94;
  ::S1537C14_nt s1537c3f95;
  ::S1537C14_nt s1537c3f96;
  ::S1537C14_nt s1537c3f97;
  void *s1537c3f98;
  ::S1537C5_nt s1537c3f99;
  ::S1537C12 s1537c3f100;
  ::S1537C14_nt s1537c3f101;
  ::S1537C14_nt s1537c3f102;
  int s1537c3f103;
  ::S1537C14_nt s1537c3f104;
  ::S1537C14_nt s1537c3f105;
  void *s1537c3f106;
  int s1537c3f107;
  char s1537c3f108;
  ::S1537C14_nt s1537c3f109;
  ::S1537C14_nt s1537c3f110;
  void *s1537c3f111;
  int s1537c3f112;
  void *s1537c3f113;
  ::S1537C12 s1537c3f114;
  ::S1537C18 s1537c3f115;
  ::S1537C18 s1537c3f116;
  virtual  ~S1537C3_nt(); // _ZN10S1537C3_ntD1Ev
  virtual void  v71(); // _ZN10S1537C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1537C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1537C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1537C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1537C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1537C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1537C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1537C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1537C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1537C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1537C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1537C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1537C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1537C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1537C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1537C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1537C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1537C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1537C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1537C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1537C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1537C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1537C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1537C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1537C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1537C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1537C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1537C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1537C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1537C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1537C3_nt4v101Ev
  virtual void  v102(); // _ZN10S1537C3_nt4v102Ev
  virtual void  v103(); // _ZN10S1537C3_nt4v103Ev
  virtual void  v104(); // _ZN10S1537C3_nt4v104Ev
  virtual void  v105(); // _ZN10S1537C3_nt4v105Ev
  virtual void  v106(); // _ZN10S1537C3_nt4v106Ev
  virtual void  v107(); // _ZN10S1537C3_nt4v107Ev
  virtual void  v108(); // _ZN10S1537C3_nt4v108Ev
  virtual void  v109(); // _ZN10S1537C3_nt4v109Ev
  virtual void  v110(); // _ZN10S1537C3_nt4v110Ev
  virtual void  v111(); // _ZN10S1537C3_nt4v111Ev
  virtual void  v112(); // _ZN10S1537C3_nt4v112Ev
  virtual void  v113(); // _ZN10S1537C3_nt4v113Ev
  virtual void  v114(); // _ZN10S1537C3_nt4v114Ev
  virtual void  v115(); // _ZN10S1537C3_nt4v115Ev
  virtual void  v116(); // _ZN10S1537C3_nt4v116Ev
  virtual void  v117(); // _ZN10S1537C3_nt4v117Ev
  virtual void  v118(); // _ZN10S1537C3_nt4v118Ev
  virtual void  v119(); // _ZN10S1537C3_nt4v119Ev
  virtual void  v120(); // _ZN10S1537C3_nt4v120Ev
  virtual void  v121(); // _ZN10S1537C3_nt4v121Ev
  virtual void  v122(); // _ZN10S1537C3_nt4v122Ev
  virtual void  v123(); // _ZN10S1537C3_nt4v123Ev
  virtual void  v124(); // _ZN10S1537C3_nt4v124Ev
  virtual void  v125(); // _ZN10S1537C3_nt4v125Ev
  virtual void  v126(); // _ZN10S1537C3_nt4v126Ev
  virtual void  v127(); // _ZN10S1537C3_nt4v127Ev
  virtual void  v128(); // _ZN10S1537C3_nt4v128Ev
  virtual void  v129(); // _ZN10S1537C3_nt4v129Ev
  virtual void  v130(); // _ZN10S1537C3_nt4v130Ev
  virtual void  v131(); // _ZN10S1537C3_nt4v131Ev
  virtual void  v132(); // _ZN10S1537C3_nt4v132Ev
  virtual void  v133(); // _ZN10S1537C3_nt4v133Ev
  virtual void  v134(); // _ZN10S1537C3_nt4v134Ev
  virtual void  v135(); // _ZN10S1537C3_nt4v135Ev
  virtual void  v136(); // _ZN10S1537C3_nt4v136Ev
  virtual void  v137(); // _ZN10S1537C3_nt4v137Ev
  virtual void  v138(); // _ZN10S1537C3_nt4v138Ev
  virtual void  v139(); // _ZN10S1537C3_nt4v139Ev
  virtual void  v140(); // _ZN10S1537C3_nt4v140Ev
  virtual void  v141(); // _ZN10S1537C3_nt4v141Ev
  virtual void  v142(); // _ZN10S1537C3_nt4v142Ev
  virtual void  v143(); // _ZN10S1537C3_nt4v143Ev
  virtual void  v144(); // _ZN10S1537C3_nt4v144Ev
  virtual void  v145(); // _ZN10S1537C3_nt4v145Ev
  virtual void  v146(); // _ZN10S1537C3_nt4v146Ev
  virtual void  v147(); // _ZN10S1537C3_nt4v147Ev
  virtual void  v148(); // _ZN10S1537C3_nt4v148Ev
  virtual void  v149(); // _ZN10S1537C3_nt4v149Ev
  virtual void  v150(); // _ZN10S1537C3_nt4v150Ev
  virtual void  v151(); // _ZN10S1537C3_nt4v151Ev
  virtual void  v152(); // _ZN10S1537C3_nt4v152Ev
  virtual void  v153(); // _ZN10S1537C3_nt4v153Ev
  virtual void  v154(); // _ZN10S1537C3_nt4v154Ev
  virtual void  v155(); // _ZN10S1537C3_nt4v155Ev
  virtual void  v156(); // _ZN10S1537C3_nt4v156Ev
  virtual void  v157(); // _ZN10S1537C3_nt4v157Ev
  virtual void  v158(); // _ZN10S1537C3_nt4v158Ev
  virtual void  v159(); // _ZN10S1537C3_nt4v159Ev
  virtual void  v160(); // _ZN10S1537C3_nt4v160Ev
  virtual void  v161(); // _ZN10S1537C3_nt4v161Ev
  virtual void  v162(); // _ZN10S1537C3_nt4v162Ev
  virtual void  v163(); // _ZN10S1537C3_nt4v163Ev
  virtual void  v164(); // _ZN10S1537C3_nt4v164Ev
  virtual void  v165(); // _ZN10S1537C3_nt4v165Ev
  virtual void  v166(); // _ZN10S1537C3_nt4v166Ev
  virtual void  v167(); // _ZN10S1537C3_nt4v167Ev
  virtual void  v168(); // _ZN10S1537C3_nt4v168Ev
  virtual void  v169(); // _ZN10S1537C3_nt4v169Ev
  virtual void  v170(); // _ZN10S1537C3_nt4v170Ev
  virtual void  v171(); // _ZN10S1537C3_nt4v171Ev
  virtual void  v172(); // _ZN10S1537C3_nt4v172Ev
  virtual void  v173(); // _ZN10S1537C3_nt4v173Ev
  virtual void  v174(); // _ZN10S1537C3_nt4v174Ev
  virtual void  v175(); // _ZN10S1537C3_nt4v175Ev
  virtual void  v176(); // _ZN10S1537C3_nt4v176Ev
  virtual void  v177(); // _ZN10S1537C3_nt4v177Ev
  virtual void  v178(); // _ZN10S1537C3_nt4v178Ev
  virtual void  v179(); // _ZN10S1537C3_nt4v179Ev
  virtual void  v180(); // _ZN10S1537C3_nt4v180Ev
  virtual void  v181(); // _ZN10S1537C3_nt4v181Ev
  virtual void  v182(); // _ZN10S1537C3_nt4v182Ev
  virtual void  v183(); // _ZN10S1537C3_nt4v183Ev
  virtual void  v184(); // _ZN10S1537C3_nt4v184Ev
  virtual void  v185(); // _ZN10S1537C3_nt4v185Ev
  virtual void  v186(); // _ZN10S1537C3_nt4v186Ev
  virtual void  v187(); // _ZN10S1537C3_nt4v187Ev
  virtual void  v188(); // _ZN10S1537C3_nt4v188Ev
  virtual void  v189(); // _ZN10S1537C3_nt4v189Ev
  virtual void  v190(); // _ZN10S1537C3_nt4v190Ev
  virtual void  v191(); // _ZN10S1537C3_nt4v191Ev
  virtual void  v192(); // _ZN10S1537C3_nt4v192Ev
  virtual void  v193(); // _ZN10S1537C3_nt4v193Ev
  virtual void  v194(); // _ZN10S1537C3_nt4v194Ev
  virtual void  v195(); // _ZN10S1537C3_nt4v195Ev
  virtual void  v196(); // _ZN10S1537C3_nt4v196Ev
  virtual void  v197(); // _ZN10S1537C3_nt4v197Ev
  virtual void  v198(); // _ZN10S1537C3_nt4v198Ev
  virtual void  v199(); // _ZN10S1537C3_nt4v199Ev
  virtual void  v200(); // _ZN10S1537C3_nt4v200Ev
  virtual void  v201(); // _ZN10S1537C3_nt4v201Ev
  virtual void  v202(); // _ZN10S1537C3_nt4v202Ev
  virtual void  v203(); // _ZN10S1537C3_nt4v203Ev
  virtual void  v204(); // _ZN10S1537C3_nt4v204Ev
  virtual void  v205(); // _ZN10S1537C3_nt4v205Ev
  virtual void  v206(); // _ZN10S1537C3_nt4v206Ev
  virtual void  v207(); // _ZN10S1537C3_nt4v207Ev
  virtual void  v208(); // _ZN10S1537C3_nt4v208Ev
  virtual void  v209(); // _ZN10S1537C3_nt4v209Ev
  virtual void  v210(); // _ZN10S1537C3_nt4v210Ev
  virtual void  v211(); // _ZN10S1537C3_nt4v211Ev
  virtual void  v212(); // _ZN10S1537C3_nt4v212Ev
  virtual void  v213(); // _ZN10S1537C3_nt4v213Ev
  S1537C3_nt(); // tgen
};
//SIG(-1 S1537C3_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S1537C3_nt ::~S1537C3_nt(){ note_dtor("S1537C3_nt", this);}
void  S1537C3_nt ::v71(){vfunc_called(this, "_ZN10S1537C3_nt3v71Ev");}
void  S1537C3_nt ::v72(){vfunc_called(this, "_ZN10S1537C3_nt3v72Ev");}
void  S1537C3_nt ::v73(){vfunc_called(this, "_ZN10S1537C3_nt3v73Ev");}
void  S1537C3_nt ::v74(){vfunc_called(this, "_ZN10S1537C3_nt3v74Ev");}
void  S1537C3_nt ::v75(){vfunc_called(this, "_ZN10S1537C3_nt3v75Ev");}
void  S1537C3_nt ::v76(){vfunc_called(this, "_ZN10S1537C3_nt3v76Ev");}
void  S1537C3_nt ::v77(){vfunc_called(this, "_ZN10S1537C3_nt3v77Ev");}
void  S1537C3_nt ::v78(){vfunc_called(this, "_ZN10S1537C3_nt3v78Ev");}
void  S1537C3_nt ::v79(){vfunc_called(this, "_ZN10S1537C3_nt3v79Ev");}
void  S1537C3_nt ::v80(){vfunc_called(this, "_ZN10S1537C3_nt3v80Ev");}
void  S1537C3_nt ::v81(){vfunc_called(this, "_ZN10S1537C3_nt3v81Ev");}
void  S1537C3_nt ::v82(){vfunc_called(this, "_ZN10S1537C3_nt3v82Ev");}
void  S1537C3_nt ::v83(){vfunc_called(this, "_ZN10S1537C3_nt3v83Ev");}
void  S1537C3_nt ::v84(){vfunc_called(this, "_ZN10S1537C3_nt3v84Ev");}
void  S1537C3_nt ::v85(){vfunc_called(this, "_ZN10S1537C3_nt3v85Ev");}
void  S1537C3_nt ::v86(){vfunc_called(this, "_ZN10S1537C3_nt3v86Ev");}
void  S1537C3_nt ::v87(){vfunc_called(this, "_ZN10S1537C3_nt3v87Ev");}
void  S1537C3_nt ::v88(){vfunc_called(this, "_ZN10S1537C3_nt3v88Ev");}
void  S1537C3_nt ::v89(){vfunc_called(this, "_ZN10S1537C3_nt3v89Ev");}
void  S1537C3_nt ::v90(){vfunc_called(this, "_ZN10S1537C3_nt3v90Ev");}
void  S1537C3_nt ::v91(){vfunc_called(this, "_ZN10S1537C3_nt3v91Ev");}
void  S1537C3_nt ::v92(){vfunc_called(this, "_ZN10S1537C3_nt3v92Ev");}
void  S1537C3_nt ::v93(){vfunc_called(this, "_ZN10S1537C3_nt3v93Ev");}
void  S1537C3_nt ::v94(){vfunc_called(this, "_ZN10S1537C3_nt3v94Ev");}
void  S1537C3_nt ::v95(){vfunc_called(this, "_ZN10S1537C3_nt3v95Ev");}
void  S1537C3_nt ::v96(){vfunc_called(this, "_ZN10S1537C3_nt3v96Ev");}
void  S1537C3_nt ::v97(){vfunc_called(this, "_ZN10S1537C3_nt3v97Ev");}
void  S1537C3_nt ::v98(){vfunc_called(this, "_ZN10S1537C3_nt3v98Ev");}
void  S1537C3_nt ::v99(){vfunc_called(this, "_ZN10S1537C3_nt3v99Ev");}
void  S1537C3_nt ::v100(){vfunc_called(this, "_ZN10S1537C3_nt4v100Ev");}
void  S1537C3_nt ::v101(){vfunc_called(this, "_ZN10S1537C3_nt4v101Ev");}
void  S1537C3_nt ::v102(){vfunc_called(this, "_ZN10S1537C3_nt4v102Ev");}
void  S1537C3_nt ::v103(){vfunc_called(this, "_ZN10S1537C3_nt4v103Ev");}
void  S1537C3_nt ::v104(){vfunc_called(this, "_ZN10S1537C3_nt4v104Ev");}
void  S1537C3_nt ::v105(){vfunc_called(this, "_ZN10S1537C3_nt4v105Ev");}
void  S1537C3_nt ::v106(){vfunc_called(this, "_ZN10S1537C3_nt4v106Ev");}
void  S1537C3_nt ::v107(){vfunc_called(this, "_ZN10S1537C3_nt4v107Ev");}
void  S1537C3_nt ::v108(){vfunc_called(this, "_ZN10S1537C3_nt4v108Ev");}
void  S1537C3_nt ::v109(){vfunc_called(this, "_ZN10S1537C3_nt4v109Ev");}
void  S1537C3_nt ::v110(){vfunc_called(this, "_ZN10S1537C3_nt4v110Ev");}
void  S1537C3_nt ::v111(){vfunc_called(this, "_ZN10S1537C3_nt4v111Ev");}
void  S1537C3_nt ::v112(){vfunc_called(this, "_ZN10S1537C3_nt4v112Ev");}
void  S1537C3_nt ::v113(){vfunc_called(this, "_ZN10S1537C3_nt4v113Ev");}
void  S1537C3_nt ::v114(){vfunc_called(this, "_ZN10S1537C3_nt4v114Ev");}
void  S1537C3_nt ::v115(){vfunc_called(this, "_ZN10S1537C3_nt4v115Ev");}
void  S1537C3_nt ::v116(){vfunc_called(this, "_ZN10S1537C3_nt4v116Ev");}
void  S1537C3_nt ::v117(){vfunc_called(this, "_ZN10S1537C3_nt4v117Ev");}
void  S1537C3_nt ::v118(){vfunc_called(this, "_ZN10S1537C3_nt4v118Ev");}
void  S1537C3_nt ::v119(){vfunc_called(this, "_ZN10S1537C3_nt4v119Ev");}
void  S1537C3_nt ::v120(){vfunc_called(this, "_ZN10S1537C3_nt4v120Ev");}
void  S1537C3_nt ::v121(){vfunc_called(this, "_ZN10S1537C3_nt4v121Ev");}
void  S1537C3_nt ::v122(){vfunc_called(this, "_ZN10S1537C3_nt4v122Ev");}
void  S1537C3_nt ::v123(){vfunc_called(this, "_ZN10S1537C3_nt4v123Ev");}
void  S1537C3_nt ::v124(){vfunc_called(this, "_ZN10S1537C3_nt4v124Ev");}
void  S1537C3_nt ::v125(){vfunc_called(this, "_ZN10S1537C3_nt4v125Ev");}
void  S1537C3_nt ::v126(){vfunc_called(this, "_ZN10S1537C3_nt4v126Ev");}
void  S1537C3_nt ::v127(){vfunc_called(this, "_ZN10S1537C3_nt4v127Ev");}
void  S1537C3_nt ::v128(){vfunc_called(this, "_ZN10S1537C3_nt4v128Ev");}
void  S1537C3_nt ::v129(){vfunc_called(this, "_ZN10S1537C3_nt4v129Ev");}
void  S1537C3_nt ::v130(){vfunc_called(this, "_ZN10S1537C3_nt4v130Ev");}
void  S1537C3_nt ::v131(){vfunc_called(this, "_ZN10S1537C3_nt4v131Ev");}
void  S1537C3_nt ::v132(){vfunc_called(this, "_ZN10S1537C3_nt4v132Ev");}
void  S1537C3_nt ::v133(){vfunc_called(this, "_ZN10S1537C3_nt4v133Ev");}
void  S1537C3_nt ::v134(){vfunc_called(this, "_ZN10S1537C3_nt4v134Ev");}
void  S1537C3_nt ::v135(){vfunc_called(this, "_ZN10S1537C3_nt4v135Ev");}
void  S1537C3_nt ::v136(){vfunc_called(this, "_ZN10S1537C3_nt4v136Ev");}
void  S1537C3_nt ::v137(){vfunc_called(this, "_ZN10S1537C3_nt4v137Ev");}
void  S1537C3_nt ::v138(){vfunc_called(this, "_ZN10S1537C3_nt4v138Ev");}
void  S1537C3_nt ::v139(){vfunc_called(this, "_ZN10S1537C3_nt4v139Ev");}
void  S1537C3_nt ::v140(){vfunc_called(this, "_ZN10S1537C3_nt4v140Ev");}
void  S1537C3_nt ::v141(){vfunc_called(this, "_ZN10S1537C3_nt4v141Ev");}
void  S1537C3_nt ::v142(){vfunc_called(this, "_ZN10S1537C3_nt4v142Ev");}
void  S1537C3_nt ::v143(){vfunc_called(this, "_ZN10S1537C3_nt4v143Ev");}
void  S1537C3_nt ::v144(){vfunc_called(this, "_ZN10S1537C3_nt4v144Ev");}
void  S1537C3_nt ::v145(){vfunc_called(this, "_ZN10S1537C3_nt4v145Ev");}
void  S1537C3_nt ::v146(){vfunc_called(this, "_ZN10S1537C3_nt4v146Ev");}
void  S1537C3_nt ::v147(){vfunc_called(this, "_ZN10S1537C3_nt4v147Ev");}
void  S1537C3_nt ::v148(){vfunc_called(this, "_ZN10S1537C3_nt4v148Ev");}
void  S1537C3_nt ::v149(){vfunc_called(this, "_ZN10S1537C3_nt4v149Ev");}
void  S1537C3_nt ::v150(){vfunc_called(this, "_ZN10S1537C3_nt4v150Ev");}
void  S1537C3_nt ::v151(){vfunc_called(this, "_ZN10S1537C3_nt4v151Ev");}
void  S1537C3_nt ::v152(){vfunc_called(this, "_ZN10S1537C3_nt4v152Ev");}
void  S1537C3_nt ::v153(){vfunc_called(this, "_ZN10S1537C3_nt4v153Ev");}
void  S1537C3_nt ::v154(){vfunc_called(this, "_ZN10S1537C3_nt4v154Ev");}
void  S1537C3_nt ::v155(){vfunc_called(this, "_ZN10S1537C3_nt4v155Ev");}
void  S1537C3_nt ::v156(){vfunc_called(this, "_ZN10S1537C3_nt4v156Ev");}
void  S1537C3_nt ::v157(){vfunc_called(this, "_ZN10S1537C3_nt4v157Ev");}
void  S1537C3_nt ::v158(){vfunc_called(this, "_ZN10S1537C3_nt4v158Ev");}
void  S1537C3_nt ::v159(){vfunc_called(this, "_ZN10S1537C3_nt4v159Ev");}
void  S1537C3_nt ::v160(){vfunc_called(this, "_ZN10S1537C3_nt4v160Ev");}
void  S1537C3_nt ::v161(){vfunc_called(this, "_ZN10S1537C3_nt4v161Ev");}
void  S1537C3_nt ::v162(){vfunc_called(this, "_ZN10S1537C3_nt4v162Ev");}
void  S1537C3_nt ::v163(){vfunc_called(this, "_ZN10S1537C3_nt4v163Ev");}
void  S1537C3_nt ::v164(){vfunc_called(this, "_ZN10S1537C3_nt4v164Ev");}
void  S1537C3_nt ::v165(){vfunc_called(this, "_ZN10S1537C3_nt4v165Ev");}
void  S1537C3_nt ::v166(){vfunc_called(this, "_ZN10S1537C3_nt4v166Ev");}
void  S1537C3_nt ::v167(){vfunc_called(this, "_ZN10S1537C3_nt4v167Ev");}
void  S1537C3_nt ::v168(){vfunc_called(this, "_ZN10S1537C3_nt4v168Ev");}
void  S1537C3_nt ::v169(){vfunc_called(this, "_ZN10S1537C3_nt4v169Ev");}
void  S1537C3_nt ::v170(){vfunc_called(this, "_ZN10S1537C3_nt4v170Ev");}
void  S1537C3_nt ::v171(){vfunc_called(this, "_ZN10S1537C3_nt4v171Ev");}
void  S1537C3_nt ::v172(){vfunc_called(this, "_ZN10S1537C3_nt4v172Ev");}
void  S1537C3_nt ::v173(){vfunc_called(this, "_ZN10S1537C3_nt4v173Ev");}
void  S1537C3_nt ::v174(){vfunc_called(this, "_ZN10S1537C3_nt4v174Ev");}
void  S1537C3_nt ::v175(){vfunc_called(this, "_ZN10S1537C3_nt4v175Ev");}
void  S1537C3_nt ::v176(){vfunc_called(this, "_ZN10S1537C3_nt4v176Ev");}
void  S1537C3_nt ::v177(){vfunc_called(this, "_ZN10S1537C3_nt4v177Ev");}
void  S1537C3_nt ::v178(){vfunc_called(this, "_ZN10S1537C3_nt4v178Ev");}
void  S1537C3_nt ::v179(){vfunc_called(this, "_ZN10S1537C3_nt4v179Ev");}
void  S1537C3_nt ::v180(){vfunc_called(this, "_ZN10S1537C3_nt4v180Ev");}
void  S1537C3_nt ::v181(){vfunc_called(this, "_ZN10S1537C3_nt4v181Ev");}
void  S1537C3_nt ::v182(){vfunc_called(this, "_ZN10S1537C3_nt4v182Ev");}
void  S1537C3_nt ::v183(){vfunc_called(this, "_ZN10S1537C3_nt4v183Ev");}
void  S1537C3_nt ::v184(){vfunc_called(this, "_ZN10S1537C3_nt4v184Ev");}
void  S1537C3_nt ::v185(){vfunc_called(this, "_ZN10S1537C3_nt4v185Ev");}
void  S1537C3_nt ::v186(){vfunc_called(this, "_ZN10S1537C3_nt4v186Ev");}
void  S1537C3_nt ::v187(){vfunc_called(this, "_ZN10S1537C3_nt4v187Ev");}
void  S1537C3_nt ::v188(){vfunc_called(this, "_ZN10S1537C3_nt4v188Ev");}
void  S1537C3_nt ::v189(){vfunc_called(this, "_ZN10S1537C3_nt4v189Ev");}
void  S1537C3_nt ::v190(){vfunc_called(this, "_ZN10S1537C3_nt4v190Ev");}
void  S1537C3_nt ::v191(){vfunc_called(this, "_ZN10S1537C3_nt4v191Ev");}
void  S1537C3_nt ::v192(){vfunc_called(this, "_ZN10S1537C3_nt4v192Ev");}
void  S1537C3_nt ::v193(){vfunc_called(this, "_ZN10S1537C3_nt4v193Ev");}
void  S1537C3_nt ::v194(){vfunc_called(this, "_ZN10S1537C3_nt4v194Ev");}
void  S1537C3_nt ::v195(){vfunc_called(this, "_ZN10S1537C3_nt4v195Ev");}
void  S1537C3_nt ::v196(){vfunc_called(this, "_ZN10S1537C3_nt4v196Ev");}
void  S1537C3_nt ::v197(){vfunc_called(this, "_ZN10S1537C3_nt4v197Ev");}
void  S1537C3_nt ::v198(){vfunc_called(this, "_ZN10S1537C3_nt4v198Ev");}
void  S1537C3_nt ::v199(){vfunc_called(this, "_ZN10S1537C3_nt4v199Ev");}
void  S1537C3_nt ::v200(){vfunc_called(this, "_ZN10S1537C3_nt4v200Ev");}
void  S1537C3_nt ::v201(){vfunc_called(this, "_ZN10S1537C3_nt4v201Ev");}
void  S1537C3_nt ::v202(){vfunc_called(this, "_ZN10S1537C3_nt4v202Ev");}
void  S1537C3_nt ::v203(){vfunc_called(this, "_ZN10S1537C3_nt4v203Ev");}
void  S1537C3_nt ::v204(){vfunc_called(this, "_ZN10S1537C3_nt4v204Ev");}
void  S1537C3_nt ::v205(){vfunc_called(this, "_ZN10S1537C3_nt4v205Ev");}
void  S1537C3_nt ::v206(){vfunc_called(this, "_ZN10S1537C3_nt4v206Ev");}
void  S1537C3_nt ::v207(){vfunc_called(this, "_ZN10S1537C3_nt4v207Ev");}
void  S1537C3_nt ::v208(){vfunc_called(this, "_ZN10S1537C3_nt4v208Ev");}
void  S1537C3_nt ::v209(){vfunc_called(this, "_ZN10S1537C3_nt4v209Ev");}
void  S1537C3_nt ::v210(){vfunc_called(this, "_ZN10S1537C3_nt4v210Ev");}
void  S1537C3_nt ::v211(){vfunc_called(this, "_ZN10S1537C3_nt4v211Ev");}
void  S1537C3_nt ::v212(){vfunc_called(this, "_ZN10S1537C3_nt4v212Ev");}
void  S1537C3_nt ::v213(){vfunc_called(this, "_ZN10S1537C3_nt4v213Ev");}
S1537C3_nt ::S1537C3_nt(){ note_ctor("S1537C3_nt", this);} // tgen

//skip512 S1537C3_nt

#else // __cplusplus

extern void _ZN10S1537C3_ntC1Ev();
extern void _ZN10S1537C3_ntD1Ev();
Name_Map name_map_S1537C3_nt[] = {
  NSPAIR(_ZN10S1537C3_ntC1Ev),
  NSPAIR(_ZN10S1537C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1537C4_nt;
extern VTBL_ENTRY _ZTI10S1537C4_nt[];
extern  VTBL_ENTRY _ZTV10S1537C4_nt[];
static Base_Class bases_S1537C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1537C3_nt[];
extern void _ZN10S1537C3_ntD1Ev();
extern void _ZN10S1537C3_ntD0Ev();
extern void _ZN10S1537C4_nt2v7Ev();
extern void _ZN10S1537C4_nt2v8Ev();
extern void _ZN10S1537C4_nt2v9Ev();
extern void _ZN10S1537C4_nt3v10Ev();
extern void _ZN10S1537C4_nt3v11Ev();
extern void _ZN10S1537C4_nt3v12Ev();
extern void _ZN10S1537C4_nt3v13Ev();
extern void _ZN10S1537C4_nt3v14Ev();
extern void _ZN10S1537C4_nt3v15Ev();
extern void _ZN10S1537C4_nt3v16Ev();
extern void _ZN10S1537C4_nt3v17Ev();
extern void _ZN10S1537C4_nt3v18Ev();
extern void _ZN10S1537C4_nt3v19Ev();
extern void _ZN10S1537C4_nt3v20Ev();
extern void _ZN10S1537C4_nt3v21Ev();
extern void _ZN10S1537C4_nt3v22Ev();
extern void _ZN10S1537C4_nt3v23Ev();
extern void _ZN10S1537C4_nt3v24Ev();
extern void _ZN10S1537C4_nt3v25Ev();
extern void _ZN10S1537C4_nt3v26Ev();
extern void _ZN10S1537C4_nt3v27Ev();
extern void _ZN10S1537C4_nt3v28Ev();
extern void _ZN10S1537C4_nt3v29Ev();
extern void _ZN10S1537C4_nt3v30Ev();
extern void _ZN10S1537C4_nt3v31Ev();
extern void _ZN10S1537C4_nt3v32Ev();
extern void _ZN10S1537C4_nt3v33Ev();
extern void _ZN10S1537C4_nt3v34Ev();
extern void _ZN10S1537C4_nt3v35Ev();
extern void _ZN10S1537C4_nt3v36Ev();
extern void _ZN10S1537C4_nt3v37Ev();
extern void _ZN10S1537C4_nt3v38Ev();
extern void _ZN10S1537C4_nt3v39Ev();
extern void _ZN10S1537C4_nt3v40Ev();
extern void _ZN10S1537C4_nt3v41Ev();
extern void _ZN10S1537C4_nt3v42Ev();
extern void _ZN10S1537C4_nt3v43Ev();
extern void _ZN10S1537C4_nt3v44Ev();
extern void _ZN10S1537C4_nt3v45Ev();
extern void _ZN10S1537C4_nt3v46Ev();
extern void _ZN10S1537C4_nt3v47Ev();
extern void _ZN10S1537C4_nt3v48Ev();
extern void _ZN10S1537C4_nt3v49Ev();
extern void _ZN10S1537C4_nt3v50Ev();
extern void _ZN10S1537C4_nt3v51Ev();
extern void _ZN10S1537C4_nt3v52Ev();
extern void _ZN10S1537C4_nt3v53Ev();
extern void _ZN10S1537C4_nt3v54Ev();
extern void _ZN10S1537C4_nt3v55Ev();
extern void _ZN10S1537C4_nt3v56Ev();
extern void _ZN10S1537C4_nt3v57Ev();
extern void _ZN10S1537C4_nt3v58Ev();
extern void _ZN10S1537C4_nt3v59Ev();
extern void _ZN10S1537C4_nt3v60Ev();
extern void _ZN10S1537C4_nt3v61Ev();
extern void _ZN10S1537C4_nt3v62Ev();
extern void _ZN10S1537C4_nt3v63Ev();
extern void _ZN10S1537C4_nt3v64Ev();
extern void _ZN10S1537C4_nt3v65Ev();
extern void _ZN10S1537C4_nt3v66Ev();
extern void _ZN10S1537C4_nt3v67Ev();
extern void _ZN10S1537C4_nt3v68Ev();
extern void _ZN10S1537C4_nt3v69Ev();
extern void _ZN10S1537C4_nt3v70Ev();
extern void _ZN10S1537C3_nt3v71Ev();
extern void _ZN10S1537C3_nt3v72Ev();
extern void _ZN10S1537C3_nt3v73Ev();
extern void _ZN10S1537C3_nt3v74Ev();
extern void _ZN10S1537C3_nt3v75Ev();
extern void _ZN10S1537C3_nt3v76Ev();
extern void _ZN10S1537C3_nt3v77Ev();
extern void _ZN10S1537C3_nt3v78Ev();
extern void _ZN10S1537C3_nt3v79Ev();
extern void _ZN10S1537C3_nt3v80Ev();
extern void _ZN10S1537C3_nt3v81Ev();
extern void _ZN10S1537C3_nt3v82Ev();
extern void _ZN10S1537C3_nt3v83Ev();
extern void _ZN10S1537C3_nt3v84Ev();
extern void _ZN10S1537C3_nt3v85Ev();
extern void _ZN10S1537C3_nt3v86Ev();
extern void _ZN10S1537C3_nt3v87Ev();
extern void _ZN10S1537C3_nt3v88Ev();
extern void _ZN10S1537C3_nt3v89Ev();
extern void _ZN10S1537C3_nt3v90Ev();
extern void _ZN10S1537C3_nt3v91Ev();
extern void _ZN10S1537C3_nt3v92Ev();
extern void _ZN10S1537C3_nt3v93Ev();
extern void _ZN10S1537C3_nt3v94Ev();
extern void _ZN10S1537C3_nt3v95Ev();
extern void _ZN10S1537C3_nt3v96Ev();
extern void _ZN10S1537C3_nt3v97Ev();
extern void _ZN10S1537C3_nt3v98Ev();
extern void _ZN10S1537C3_nt3v99Ev();
extern void _ZN10S1537C3_nt4v100Ev();
extern void _ZN10S1537C3_nt4v101Ev();
extern void _ZN10S1537C3_nt4v102Ev();
extern void _ZN10S1537C3_nt4v103Ev();
extern void _ZN10S1537C3_nt4v104Ev();
extern void _ZN10S1537C3_nt4v105Ev();
extern void _ZN10S1537C3_nt4v106Ev();
extern void _ZN10S1537C3_nt4v107Ev();
extern void _ZN10S1537C3_nt4v108Ev();
extern void _ZN10S1537C3_nt4v109Ev();
extern void _ZN10S1537C3_nt4v110Ev();
extern void _ZN10S1537C3_nt4v111Ev();
extern void _ZN10S1537C3_nt4v112Ev();
extern void _ZN10S1537C3_nt4v113Ev();
extern void _ZN10S1537C3_nt4v114Ev();
extern void _ZN10S1537C3_nt4v115Ev();
extern void _ZN10S1537C3_nt4v116Ev();
extern void _ZN10S1537C3_nt4v117Ev();
extern void _ZN10S1537C3_nt4v118Ev();
extern void _ZN10S1537C3_nt4v119Ev();
extern void _ZN10S1537C3_nt4v120Ev();
extern void _ZN10S1537C3_nt4v121Ev();
extern void _ZN10S1537C3_nt4v122Ev();
extern void _ZN10S1537C3_nt4v123Ev();
extern void _ZN10S1537C3_nt4v124Ev();
extern void _ZN10S1537C3_nt4v125Ev();
extern void _ZN10S1537C3_nt4v126Ev();
extern void _ZN10S1537C3_nt4v127Ev();
extern void _ZN10S1537C3_nt4v128Ev();
extern void _ZN10S1537C3_nt4v129Ev();
extern void _ZN10S1537C3_nt4v130Ev();
extern void _ZN10S1537C3_nt4v131Ev();
extern void _ZN10S1537C3_nt4v132Ev();
extern void _ZN10S1537C3_nt4v133Ev();
extern void _ZN10S1537C3_nt4v134Ev();
extern void _ZN10S1537C3_nt4v135Ev();
extern void _ZN10S1537C3_nt4v136Ev();
extern void _ZN10S1537C3_nt4v137Ev();
extern void _ZN10S1537C3_nt4v138Ev();
extern void _ZN10S1537C3_nt4v139Ev();
extern void _ZN10S1537C3_nt4v140Ev();
extern void _ZN10S1537C3_nt4v141Ev();
extern void _ZN10S1537C3_nt4v142Ev();
extern void _ZN10S1537C3_nt4v143Ev();
extern void _ZN10S1537C3_nt4v144Ev();
extern void _ZN10S1537C3_nt4v145Ev();
extern void _ZN10S1537C3_nt4v146Ev();
extern void _ZN10S1537C3_nt4v147Ev();
extern void _ZN10S1537C3_nt4v148Ev();
extern void _ZN10S1537C3_nt4v149Ev();
extern void _ZN10S1537C3_nt4v150Ev();
extern void _ZN10S1537C3_nt4v151Ev();
extern void _ZN10S1537C3_nt4v152Ev();
extern void _ZN10S1537C3_nt4v153Ev();
extern void _ZN10S1537C3_nt4v154Ev();
extern void _ZN10S1537C3_nt4v155Ev();
extern void _ZN10S1537C3_nt4v156Ev();
extern void _ZN10S1537C3_nt4v157Ev();
extern void _ZN10S1537C3_nt4v158Ev();
extern void _ZN10S1537C3_nt4v159Ev();
extern void _ZN10S1537C3_nt4v160Ev();
extern void _ZN10S1537C3_nt4v161Ev();
extern void _ZN10S1537C3_nt4v162Ev();
extern void _ZN10S1537C3_nt4v163Ev();
extern void _ZN10S1537C3_nt4v164Ev();
extern void _ZN10S1537C3_nt4v165Ev();
extern void _ZN10S1537C3_nt4v166Ev();
extern void _ZN10S1537C3_nt4v167Ev();
extern void _ZN10S1537C3_nt4v168Ev();
extern void _ZN10S1537C3_nt4v169Ev();
extern void _ZN10S1537C3_nt4v170Ev();
extern void _ZN10S1537C3_nt4v171Ev();
extern void _ZN10S1537C3_nt4v172Ev();
extern void _ZN10S1537C3_nt4v173Ev();
extern void _ZN10S1537C3_nt4v174Ev();
extern void _ZN10S1537C3_nt4v175Ev();
extern void _ZN10S1537C3_nt4v176Ev();
extern void _ZN10S1537C3_nt4v177Ev();
extern void _ZN10S1537C3_nt4v178Ev();
extern void _ZN10S1537C3_nt4v179Ev();
extern void _ZN10S1537C3_nt4v180Ev();
extern void _ZN10S1537C3_nt4v181Ev();
extern void _ZN10S1537C3_nt4v182Ev();
extern void _ZN10S1537C3_nt4v183Ev();
extern void _ZN10S1537C3_nt4v184Ev();
extern void _ZN10S1537C3_nt4v185Ev();
extern void _ZN10S1537C3_nt4v186Ev();
extern void _ZN10S1537C3_nt4v187Ev();
extern void _ZN10S1537C3_nt4v188Ev();
extern void _ZN10S1537C3_nt4v189Ev();
extern void _ZN10S1537C3_nt4v190Ev();
extern void _ZN10S1537C3_nt4v191Ev();
extern void _ZN10S1537C3_nt4v192Ev();
extern void _ZN10S1537C3_nt4v193Ev();
extern void _ZN10S1537C3_nt4v194Ev();
extern void _ZN10S1537C3_nt4v195Ev();
extern void _ZN10S1537C3_nt4v196Ev();
extern void _ZN10S1537C3_nt4v197Ev();
extern void _ZN10S1537C3_nt4v198Ev();
extern void _ZN10S1537C3_nt4v199Ev();
extern void _ZN10S1537C3_nt4v200Ev();
extern void _ZN10S1537C3_nt4v201Ev();
extern void _ZN10S1537C3_nt4v202Ev();
extern void _ZN10S1537C3_nt4v203Ev();
extern void _ZN10S1537C3_nt4v204Ev();
extern void _ZN10S1537C3_nt4v205Ev();
extern void _ZN10S1537C3_nt4v206Ev();
extern void _ZN10S1537C3_nt4v207Ev();
extern void _ZN10S1537C3_nt4v208Ev();
extern void _ZN10S1537C3_nt4v209Ev();
extern void _ZN10S1537C3_nt4v210Ev();
extern void _ZN10S1537C3_nt4v211Ev();
extern void _ZN10S1537C3_nt4v212Ev();
extern void _ZN10S1537C3_nt4v213Ev();
static  VTBL_ENTRY vtc_S1537C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1537C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1537C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v213Ev,
};
extern VTBL_ENTRY _ZTI10S1537C3_nt[];
VTBL_ENTRY *P__ZTI10S1537C3_nt = _ZTI10S1537C3_nt; 
extern  VTBL_ENTRY _ZTV10S1537C3_nt[];
Class_Descriptor cd_S1537C3_nt = {  "S1537C3_nt", // class name
  bases_S1537C3_nt, 1,
  &(vtc_S1537C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1537C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1537C3_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C23  : S1537C8_nt {
};
//SIG(-1 S1537C23) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1537C23()
{
  extern Class_Descriptor cd_S1537C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1537C23, buf);
    S1537C23 &lv = *(new (buf) S1537C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1537C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1537C23)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1537C23");
    test_class_info(&lv, &cd_S1537C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1537C23(Test_S1537C23, "S1537C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1537C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1537C23 = {  "S1537C23", // class name
  bases_S1537C23, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C22  : S1537C23 {
};
//SIG(-1 S1537C22) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1537C22()
{
  extern Class_Descriptor cd_S1537C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1537C22, buf);
    S1537C22 &lv = *(new (buf) S1537C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1537C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1537C22)");
    check_base_class_offset(lv, (S1537C8_nt*)(S1537C23*), 0, "S1537C22");
    check_base_class_offset(lv, (S1537C23*), 0, "S1537C22");
    test_class_info(&lv, &cd_S1537C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1537C22(Test_S1537C22, "S1537C22", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1537C23;
static Base_Class bases_S1537C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1537C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1537C22 = {  "S1537C22", // class name
  bases_S1537C22, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C26  {
  ::S1537C14_nt s1537c26f0;
  ::S1537C14_nt s1537c26f1;
  void *s1537c26f2;
  unsigned int s1537c26f3:1;
};
//SIG(1 S1537C26) C1{ FC2{ m Fi[3]} FC2 Fp Fi:1}



static void Test_S1537C26()
{
  {
    init_simple_test("S1537C26");
    static S1537C26 lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(S1537C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1537C26)");
    check_field_offset(lv, s1537c26f0, 0, "S1537C26.s1537c26f0");
    check_field_offset(lv, s1537c26f1, 12, "S1537C26.s1537c26f1");
    check_field_offset(lv, s1537c26f2, 24, "S1537C26.s1537c26f2");
    set_bf_and_test(lv, s1537c26f3, ABISELECT(32,28), 0, 1, 1, "S1537C26");
  }
}
static Arrange_To_Call_Me vS1537C26(Test_S1537C26, "S1537C26", ABISELECT(40,32));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C2  : S1537C3_nt {
  void *s1537c2f0[4];
  ::S1537C5_nt s1537c2f1[3];
  char s1537c2f2[6];
  void *s1537c2f3[3];
  int s1537c2f4[3];
  ::S1537C22 s1537c2f5;
  int s1537c2f6[3];
  void *s1537c2f7;
  int s1537c2f8[6];
  ::S1537C5_nt s1537c2f9[3];
  ::S1537C5_nt s1537c2f10[3];
  ::S1537C5_nt s1537c2f11;
  void *s1537c2f12;
  unsigned int s1537c2f13:1;
  unsigned int s1537c2f14:1;
  ::S1537C14_nt s1537c2f15[3];
  ::S1537C22 s1537c2f16;
  void *s1537c2f17[3];
  int s1537c2f18[3];
  ::S1537C14_nt s1537c2f19[3];
  int s1537c2f20[3];
  ::S1537C5_nt s1537c2f21[3];
  void *s1537c2f22[3];
  int s1537c2f23[2];
  ::S1537C26 s1537c2f24[3];
  ::S1537C14_nt s1537c2f25[3];
  void *s1537c2f26;
  int s1537c2f27;
  virtual  ~S1537C2(); // _ZN7S1537C2D1Ev
  virtual void  v214(); // _ZN7S1537C24v214Ev
  virtual void  v215(); // _ZN7S1537C24v215Ev
  virtual void  v216(); // _ZN7S1537C24v216Ev
  virtual void  v217(); // _ZN7S1537C24v217Ev
  virtual void  v218(); // _ZN7S1537C24v218Ev
  virtual void  v219(); // _ZN7S1537C24v219Ev
  virtual void  v220(); // _ZN7S1537C24v220Ev
  virtual void  v221(); // _ZN7S1537C24v221Ev
  virtual void  v222(); // _ZN7S1537C24v222Ev
  virtual void  v223(); // _ZN7S1537C24v223Ev
  S1537C2(); // tgen
};
//SIG(-1 S1537C2) C1{ BC2{ BC3{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp[4] FC4[3] Fc[6] Fp[3] Fi[3] FC14{ BC15{ BC7}} Fi[3] Fp Fi[6] FC4[3] FC4[3] FC4 Fp Fi:1 Fi:1 FC11[3] FC14 Fp[3] Fi[3] FC11[3] Fi[3] FC4[3] Fp[3] Fi[2] FC16{ FC11 FC11 Fp Fi:1}[3] FC11[3] Fp Fi}


 S1537C2 ::~S1537C2(){ note_dtor("S1537C2", this);}
void  S1537C2 ::v214(){vfunc_called(this, "_ZN7S1537C24v214Ev");}
void  S1537C2 ::v215(){vfunc_called(this, "_ZN7S1537C24v215Ev");}
void  S1537C2 ::v216(){vfunc_called(this, "_ZN7S1537C24v216Ev");}
void  S1537C2 ::v217(){vfunc_called(this, "_ZN7S1537C24v217Ev");}
void  S1537C2 ::v218(){vfunc_called(this, "_ZN7S1537C24v218Ev");}
void  S1537C2 ::v219(){vfunc_called(this, "_ZN7S1537C24v219Ev");}
void  S1537C2 ::v220(){vfunc_called(this, "_ZN7S1537C24v220Ev");}
void  S1537C2 ::v221(){vfunc_called(this, "_ZN7S1537C24v221Ev");}
void  S1537C2 ::v222(){vfunc_called(this, "_ZN7S1537C24v222Ev");}
void  S1537C2 ::v223(){vfunc_called(this, "_ZN7S1537C24v223Ev");}
S1537C2 ::S1537C2(){ note_ctor("S1537C2", this);} // tgen

static void Test_S1537C2()
{
  extern Class_Descriptor cd_S1537C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(148,233)];
    init_test(&cd_S1537C2, buf);
    S1537C2 *dp, &lv = *(dp=new (buf) S1537C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1176,928), "sizeof(S1537C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1537C2)");
    check_base_class_offset(lv, (S1537C4_nt*)(S1537C3_nt*), 0, "S1537C2");
    check_base_class_offset(lv, (S1537C3_nt*), 0, "S1537C2");
    check_field_offset(lv, s1537c2f0, ABISELECT(568,436), "S1537C2.s1537c2f0");
    check_field_offset(lv, s1537c2f1, ABISELECT(600,452), "S1537C2.s1537c2f1");
    check_field_offset(lv, s1537c2f2, ABISELECT(624,476), "S1537C2.s1537c2f2");
    check_field_offset(lv, s1537c2f3, ABISELECT(632,484), "S1537C2.s1537c2f3");
    check_field_offset(lv, s1537c2f4, ABISELECT(656,496), "S1537C2.s1537c2f4");
    check_field_offset(lv, s1537c2f5, ABISELECT(672,508), "S1537C2.s1537c2f5");
    check_field_offset(lv, s1537c2f6, ABISELECT(688,520), "S1537C2.s1537c2f6");
    check_field_offset(lv, s1537c2f7, ABISELECT(704,532), "S1537C2.s1537c2f7");
    check_field_offset(lv, s1537c2f8, ABISELECT(712,536), "S1537C2.s1537c2f8");
    check_field_offset(lv, s1537c2f9, ABISELECT(736,560), "S1537C2.s1537c2f9");
    check_field_offset(lv, s1537c2f10, ABISELECT(760,584), "S1537C2.s1537c2f10");
    check_field_offset(lv, s1537c2f11, ABISELECT(784,608), "S1537C2.s1537c2f11");
    check_field_offset(lv, s1537c2f12, ABISELECT(792,616), "S1537C2.s1537c2f12");
    set_bf_and_test(lv, s1537c2f13, ABISELECT(800,620), 0, 1, 1, "S1537C2");
    set_bf_and_test(lv, s1537c2f14, ABISELECT(800,620), 1, 1, 1, "S1537C2");
    check_field_offset(lv, s1537c2f15, ABISELECT(804,624), "S1537C2.s1537c2f15");
    check_field_offset(lv, s1537c2f16, ABISELECT(840,660), "S1537C2.s1537c2f16");
    check_field_offset(lv, s1537c2f17, ABISELECT(856,672), "S1537C2.s1537c2f17");
    check_field_offset(lv, s1537c2f18, ABISELECT(880,684), "S1537C2.s1537c2f18");
    check_field_offset(lv, s1537c2f19, ABISELECT(892,696), "S1537C2.s1537c2f19");
    check_field_offset(lv, s1537c2f20, ABISELECT(928,732), "S1537C2.s1537c2f20");
    check_field_offset(lv, s1537c2f21, ABISELECT(940,744), "S1537C2.s1537c2f21");
    check_field_offset(lv, s1537c2f22, ABISELECT(968,768), "S1537C2.s1537c2f22");
    check_field_offset(lv, s1537c2f23, ABISELECT(992,780), "S1537C2.s1537c2f23");
    check_field_offset(lv, s1537c2f24, ABISELECT(1000,788), "S1537C2.s1537c2f24");
    check_field_offset(lv, s1537c2f25, ABISELECT(1120,884), "S1537C2.s1537c2f25");
    check_field_offset(lv, s1537c2f26, ABISELECT(1160,920), "S1537C2.s1537c2f26");
    check_field_offset(lv, s1537c2f27, ABISELECT(1168,924), "S1537C2.s1537c2f27");
    test_class_info(&lv, &cd_S1537C2);
    dp->~S1537C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1537C2(Test_S1537C2, "S1537C2", ABISELECT(1176,928));

#else // __cplusplus

extern void _ZN7S1537C2C1Ev();
extern void _ZN7S1537C2D1Ev();
Name_Map name_map_S1537C2[] = {
  NSPAIR(_ZN7S1537C2C1Ev),
  NSPAIR(_ZN7S1537C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1537C4_nt;
extern VTBL_ENTRY _ZTI10S1537C4_nt[];
extern  VTBL_ENTRY _ZTV10S1537C4_nt[];
extern Class_Descriptor cd_S1537C3_nt;
extern VTBL_ENTRY _ZTI10S1537C3_nt[];
extern  VTBL_ENTRY _ZTV10S1537C3_nt[];
static Base_Class bases_S1537C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1537C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1537C2[];
extern void _ZN7S1537C2D1Ev();
extern void _ZN7S1537C2D0Ev();
extern void _ZN10S1537C4_nt2v7Ev();
extern void _ZN10S1537C4_nt2v8Ev();
extern void _ZN10S1537C4_nt2v9Ev();
extern void _ZN10S1537C4_nt3v10Ev();
extern void _ZN10S1537C4_nt3v11Ev();
extern void _ZN10S1537C4_nt3v12Ev();
extern void _ZN10S1537C4_nt3v13Ev();
extern void _ZN10S1537C4_nt3v14Ev();
extern void _ZN10S1537C4_nt3v15Ev();
extern void _ZN10S1537C4_nt3v16Ev();
extern void _ZN10S1537C4_nt3v17Ev();
extern void _ZN10S1537C4_nt3v18Ev();
extern void _ZN10S1537C4_nt3v19Ev();
extern void _ZN10S1537C4_nt3v20Ev();
extern void _ZN10S1537C4_nt3v21Ev();
extern void _ZN10S1537C4_nt3v22Ev();
extern void _ZN10S1537C4_nt3v23Ev();
extern void _ZN10S1537C4_nt3v24Ev();
extern void _ZN10S1537C4_nt3v25Ev();
extern void _ZN10S1537C4_nt3v26Ev();
extern void _ZN10S1537C4_nt3v27Ev();
extern void _ZN10S1537C4_nt3v28Ev();
extern void _ZN10S1537C4_nt3v29Ev();
extern void _ZN10S1537C4_nt3v30Ev();
extern void _ZN10S1537C4_nt3v31Ev();
extern void _ZN10S1537C4_nt3v32Ev();
extern void _ZN10S1537C4_nt3v33Ev();
extern void _ZN10S1537C4_nt3v34Ev();
extern void _ZN10S1537C4_nt3v35Ev();
extern void _ZN10S1537C4_nt3v36Ev();
extern void _ZN10S1537C4_nt3v37Ev();
extern void _ZN10S1537C4_nt3v38Ev();
extern void _ZN10S1537C4_nt3v39Ev();
extern void _ZN10S1537C4_nt3v40Ev();
extern void _ZN10S1537C4_nt3v41Ev();
extern void _ZN10S1537C4_nt3v42Ev();
extern void _ZN10S1537C4_nt3v43Ev();
extern void _ZN10S1537C4_nt3v44Ev();
extern void _ZN10S1537C4_nt3v45Ev();
extern void _ZN10S1537C4_nt3v46Ev();
extern void _ZN10S1537C4_nt3v47Ev();
extern void _ZN10S1537C4_nt3v48Ev();
extern void _ZN10S1537C4_nt3v49Ev();
extern void _ZN10S1537C4_nt3v50Ev();
extern void _ZN10S1537C4_nt3v51Ev();
extern void _ZN10S1537C4_nt3v52Ev();
extern void _ZN10S1537C4_nt3v53Ev();
extern void _ZN10S1537C4_nt3v54Ev();
extern void _ZN10S1537C4_nt3v55Ev();
extern void _ZN10S1537C4_nt3v56Ev();
extern void _ZN10S1537C4_nt3v57Ev();
extern void _ZN10S1537C4_nt3v58Ev();
extern void _ZN10S1537C4_nt3v59Ev();
extern void _ZN10S1537C4_nt3v60Ev();
extern void _ZN10S1537C4_nt3v61Ev();
extern void _ZN10S1537C4_nt3v62Ev();
extern void _ZN10S1537C4_nt3v63Ev();
extern void _ZN10S1537C4_nt3v64Ev();
extern void _ZN10S1537C4_nt3v65Ev();
extern void _ZN10S1537C4_nt3v66Ev();
extern void _ZN10S1537C4_nt3v67Ev();
extern void _ZN10S1537C4_nt3v68Ev();
extern void _ZN10S1537C4_nt3v69Ev();
extern void _ZN10S1537C4_nt3v70Ev();
extern void _ZN10S1537C3_nt3v71Ev();
extern void _ZN10S1537C3_nt3v72Ev();
extern void _ZN10S1537C3_nt3v73Ev();
extern void _ZN10S1537C3_nt3v74Ev();
extern void _ZN10S1537C3_nt3v75Ev();
extern void _ZN10S1537C3_nt3v76Ev();
extern void _ZN10S1537C3_nt3v77Ev();
extern void _ZN10S1537C3_nt3v78Ev();
extern void _ZN10S1537C3_nt3v79Ev();
extern void _ZN10S1537C3_nt3v80Ev();
extern void _ZN10S1537C3_nt3v81Ev();
extern void _ZN10S1537C3_nt3v82Ev();
extern void _ZN10S1537C3_nt3v83Ev();
extern void _ZN10S1537C3_nt3v84Ev();
extern void _ZN10S1537C3_nt3v85Ev();
extern void _ZN10S1537C3_nt3v86Ev();
extern void _ZN10S1537C3_nt3v87Ev();
extern void _ZN10S1537C3_nt3v88Ev();
extern void _ZN10S1537C3_nt3v89Ev();
extern void _ZN10S1537C3_nt3v90Ev();
extern void _ZN10S1537C3_nt3v91Ev();
extern void _ZN10S1537C3_nt3v92Ev();
extern void _ZN10S1537C3_nt3v93Ev();
extern void _ZN10S1537C3_nt3v94Ev();
extern void _ZN10S1537C3_nt3v95Ev();
extern void _ZN10S1537C3_nt3v96Ev();
extern void _ZN10S1537C3_nt3v97Ev();
extern void _ZN10S1537C3_nt3v98Ev();
extern void _ZN10S1537C3_nt3v99Ev();
extern void _ZN10S1537C3_nt4v100Ev();
extern void _ZN10S1537C3_nt4v101Ev();
extern void _ZN10S1537C3_nt4v102Ev();
extern void _ZN10S1537C3_nt4v103Ev();
extern void _ZN10S1537C3_nt4v104Ev();
extern void _ZN10S1537C3_nt4v105Ev();
extern void _ZN10S1537C3_nt4v106Ev();
extern void _ZN10S1537C3_nt4v107Ev();
extern void _ZN10S1537C3_nt4v108Ev();
extern void _ZN10S1537C3_nt4v109Ev();
extern void _ZN10S1537C3_nt4v110Ev();
extern void _ZN10S1537C3_nt4v111Ev();
extern void _ZN10S1537C3_nt4v112Ev();
extern void _ZN10S1537C3_nt4v113Ev();
extern void _ZN10S1537C3_nt4v114Ev();
extern void _ZN10S1537C3_nt4v115Ev();
extern void _ZN10S1537C3_nt4v116Ev();
extern void _ZN10S1537C3_nt4v117Ev();
extern void _ZN10S1537C3_nt4v118Ev();
extern void _ZN10S1537C3_nt4v119Ev();
extern void _ZN10S1537C3_nt4v120Ev();
extern void _ZN10S1537C3_nt4v121Ev();
extern void _ZN10S1537C3_nt4v122Ev();
extern void _ZN10S1537C3_nt4v123Ev();
extern void _ZN10S1537C3_nt4v124Ev();
extern void _ZN10S1537C3_nt4v125Ev();
extern void _ZN10S1537C3_nt4v126Ev();
extern void _ZN10S1537C3_nt4v127Ev();
extern void _ZN10S1537C3_nt4v128Ev();
extern void _ZN10S1537C3_nt4v129Ev();
extern void _ZN10S1537C3_nt4v130Ev();
extern void _ZN10S1537C3_nt4v131Ev();
extern void _ZN10S1537C3_nt4v132Ev();
extern void _ZN10S1537C3_nt4v133Ev();
extern void _ZN10S1537C3_nt4v134Ev();
extern void _ZN10S1537C3_nt4v135Ev();
extern void _ZN10S1537C3_nt4v136Ev();
extern void _ZN10S1537C3_nt4v137Ev();
extern void _ZN10S1537C3_nt4v138Ev();
extern void _ZN10S1537C3_nt4v139Ev();
extern void _ZN10S1537C3_nt4v140Ev();
extern void _ZN10S1537C3_nt4v141Ev();
extern void _ZN10S1537C3_nt4v142Ev();
extern void _ZN10S1537C3_nt4v143Ev();
extern void _ZN10S1537C3_nt4v144Ev();
extern void _ZN10S1537C3_nt4v145Ev();
extern void _ZN10S1537C3_nt4v146Ev();
extern void _ZN10S1537C3_nt4v147Ev();
extern void _ZN10S1537C3_nt4v148Ev();
extern void _ZN10S1537C3_nt4v149Ev();
extern void _ZN10S1537C3_nt4v150Ev();
extern void _ZN10S1537C3_nt4v151Ev();
extern void _ZN10S1537C3_nt4v152Ev();
extern void _ZN10S1537C3_nt4v153Ev();
extern void _ZN10S1537C3_nt4v154Ev();
extern void _ZN10S1537C3_nt4v155Ev();
extern void _ZN10S1537C3_nt4v156Ev();
extern void _ZN10S1537C3_nt4v157Ev();
extern void _ZN10S1537C3_nt4v158Ev();
extern void _ZN10S1537C3_nt4v159Ev();
extern void _ZN10S1537C3_nt4v160Ev();
extern void _ZN10S1537C3_nt4v161Ev();
extern void _ZN10S1537C3_nt4v162Ev();
extern void _ZN10S1537C3_nt4v163Ev();
extern void _ZN10S1537C3_nt4v164Ev();
extern void _ZN10S1537C3_nt4v165Ev();
extern void _ZN10S1537C3_nt4v166Ev();
extern void _ZN10S1537C3_nt4v167Ev();
extern void _ZN10S1537C3_nt4v168Ev();
extern void _ZN10S1537C3_nt4v169Ev();
extern void _ZN10S1537C3_nt4v170Ev();
extern void _ZN10S1537C3_nt4v171Ev();
extern void _ZN10S1537C3_nt4v172Ev();
extern void _ZN10S1537C3_nt4v173Ev();
extern void _ZN10S1537C3_nt4v174Ev();
extern void _ZN10S1537C3_nt4v175Ev();
extern void _ZN10S1537C3_nt4v176Ev();
extern void _ZN10S1537C3_nt4v177Ev();
extern void _ZN10S1537C3_nt4v178Ev();
extern void _ZN10S1537C3_nt4v179Ev();
extern void _ZN10S1537C3_nt4v180Ev();
extern void _ZN10S1537C3_nt4v181Ev();
extern void _ZN10S1537C3_nt4v182Ev();
extern void _ZN10S1537C3_nt4v183Ev();
extern void _ZN10S1537C3_nt4v184Ev();
extern void _ZN10S1537C3_nt4v185Ev();
extern void _ZN10S1537C3_nt4v186Ev();
extern void _ZN10S1537C3_nt4v187Ev();
extern void _ZN10S1537C3_nt4v188Ev();
extern void _ZN10S1537C3_nt4v189Ev();
extern void _ZN10S1537C3_nt4v190Ev();
extern void _ZN10S1537C3_nt4v191Ev();
extern void _ZN10S1537C3_nt4v192Ev();
extern void _ZN10S1537C3_nt4v193Ev();
extern void _ZN10S1537C3_nt4v194Ev();
extern void _ZN10S1537C3_nt4v195Ev();
extern void _ZN10S1537C3_nt4v196Ev();
extern void _ZN10S1537C3_nt4v197Ev();
extern void _ZN10S1537C3_nt4v198Ev();
extern void _ZN10S1537C3_nt4v199Ev();
extern void _ZN10S1537C3_nt4v200Ev();
extern void _ZN10S1537C3_nt4v201Ev();
extern void _ZN10S1537C3_nt4v202Ev();
extern void _ZN10S1537C3_nt4v203Ev();
extern void _ZN10S1537C3_nt4v204Ev();
extern void _ZN10S1537C3_nt4v205Ev();
extern void _ZN10S1537C3_nt4v206Ev();
extern void _ZN10S1537C3_nt4v207Ev();
extern void _ZN10S1537C3_nt4v208Ev();
extern void _ZN10S1537C3_nt4v209Ev();
extern void _ZN10S1537C3_nt4v210Ev();
extern void _ZN10S1537C3_nt4v211Ev();
extern void _ZN10S1537C3_nt4v212Ev();
extern void _ZN10S1537C3_nt4v213Ev();
extern void _ZN7S1537C24v214Ev();
extern void _ZN7S1537C24v215Ev();
extern void _ZN7S1537C24v216Ev();
extern void _ZN7S1537C24v217Ev();
extern void _ZN7S1537C24v218Ev();
extern void _ZN7S1537C24v219Ev();
extern void _ZN7S1537C24v220Ev();
extern void _ZN7S1537C24v221Ev();
extern void _ZN7S1537C24v222Ev();
extern void _ZN7S1537C24v223Ev();
static  VTBL_ENTRY vtc_S1537C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1537C2[0]),
  (VTBL_ENTRY)&_ZN7S1537C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1537C2D0Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v214Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v215Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v216Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v217Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v218Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v219Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v220Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v221Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v222Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v223Ev,
};
extern VTBL_ENTRY _ZTI7S1537C2[];
extern  VTBL_ENTRY _ZTV7S1537C2[];
Class_Descriptor cd_S1537C2 = {  "S1537C2", // class name
  bases_S1537C2, 2,
  &(vtc_S1537C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1176,928), // object size
  NSPAIRA(_ZTI7S1537C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1537C2),221, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1537C1  : S1537C2 {
  unsigned int s1537c1f0:1;
  unsigned int s1537c1f1:1;
  ::S1537C5_nt s1537c1f2[3];
  void *s1537c1f3[10];
  ::S1537C5_nt s1537c1f4[3];
  ::S1537C5_nt s1537c1f5;
  int s1537c1f6;
  ::S1537C14_nt s1537c1f7;
  ::S1537C14_nt s1537c1f8[3];
  ::S1537C14_nt s1537c1f9;
  ::S1537C14_nt s1537c1f10;
  int s1537c1f11[2];
  ::S1537C5_nt s1537c1f12;
  ::S1537C5_nt s1537c1f13;
  virtual  ~S1537C1(); // _ZN7S1537C1D1Ev
  virtual void  v1(); // _ZN7S1537C12v1Ev
  virtual void  v2(); // _ZN7S1537C12v2Ev
  virtual void  v3(); // _ZN7S1537C12v3Ev
  virtual void  v4(); // _ZN7S1537C12v4Ev
  virtual void  v5(); // _ZN7S1537C12v5Ev
  virtual void  v6(); // _ZN7S1537C12v6Ev
  S1537C1(); // tgen
};
//SIG(1 S1537C1) C1{ BC2{ BC3{ BC4{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 Fp[4] FC5[3] Fc[6] Fp[3] Fi[3] FC15{ BC16{ BC8}} Fi[3] Fp Fi[6] FC5[3] FC5[3] FC5 Fp Fi:1 Fi:1 FC12[3] FC15 Fp[3] Fi[3] FC12[3] Fi[3] FC5[3] Fp[3] Fi[2] FC17{ FC12 FC12 Fp Fi:1}[3] FC12[3] Fp Fi} vd v1 v2 v3 v4 v5 v6 Fi:1 Fi:1 FC5[3] Fp[10] FC5[3] FC5 Fi FC12 FC12[3] FC12 FC12 Fi[2] FC5 FC5}


 S1537C1 ::~S1537C1(){ note_dtor("S1537C1", this);}
void  S1537C1 ::v1(){vfunc_called(this, "_ZN7S1537C12v1Ev");}
void  S1537C1 ::v2(){vfunc_called(this, "_ZN7S1537C12v2Ev");}
void  S1537C1 ::v3(){vfunc_called(this, "_ZN7S1537C12v3Ev");}
void  S1537C1 ::v4(){vfunc_called(this, "_ZN7S1537C12v4Ev");}
void  S1537C1 ::v5(){vfunc_called(this, "_ZN7S1537C12v5Ev");}
void  S1537C1 ::v6(){vfunc_called(this, "_ZN7S1537C12v6Ev");}
S1537C1 ::S1537C1(){ note_ctor("S1537C1", this);} // tgen

static void Test_S1537C1()
{
  extern Class_Descriptor cd_S1537C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(178,283)];
    init_test(&cd_S1537C1, buf);
    S1537C1 *dp, &lv = *(dp=new (buf) S1537C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1416,1128), "sizeof(S1537C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1537C1)");
    check_base_class_offset(lv, (S1537C4_nt*)(S1537C3_nt*)(S1537C2*), 0, "S1537C1");
    check_base_class_offset(lv, (S1537C3_nt*)(S1537C2*), 0, "S1537C1");
    check_base_class_offset(lv, (S1537C2*), 0, "S1537C1");
    set_bf_and_test(lv, s1537c1f0, ABISELECT(1172,928), 0, 1, 1, "S1537C1");
    set_bf_and_test(lv, s1537c1f1, ABISELECT(1172,928), 1, 1, 1, "S1537C1");
    check_field_offset(lv, s1537c1f2, ABISELECT(1176,932), "S1537C1.s1537c1f2");
    check_field_offset(lv, s1537c1f3, ABISELECT(1200,956), "S1537C1.s1537c1f3");
    check_field_offset(lv, s1537c1f4, ABISELECT(1280,996), "S1537C1.s1537c1f4");
    check_field_offset(lv, s1537c1f5, ABISELECT(1304,1020), "S1537C1.s1537c1f5");
    check_field_offset(lv, s1537c1f6, ABISELECT(1312,1028), "S1537C1.s1537c1f6");
    check_field_offset(lv, s1537c1f7, ABISELECT(1316,1032), "S1537C1.s1537c1f7");
    check_field_offset(lv, s1537c1f8, ABISELECT(1328,1044), "S1537C1.s1537c1f8");
    check_field_offset(lv, s1537c1f9, ABISELECT(1364,1080), "S1537C1.s1537c1f9");
    check_field_offset(lv, s1537c1f10, ABISELECT(1376,1092), "S1537C1.s1537c1f10");
    check_field_offset(lv, s1537c1f11, ABISELECT(1388,1104), "S1537C1.s1537c1f11");
    check_field_offset(lv, s1537c1f12, ABISELECT(1396,1112), "S1537C1.s1537c1f12");
    check_field_offset(lv, s1537c1f13, ABISELECT(1404,1120), "S1537C1.s1537c1f13");
    test_class_info(&lv, &cd_S1537C1);
    dp->~S1537C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1537C1(Test_S1537C1, "S1537C1", ABISELECT(1416,1128));

#else // __cplusplus

extern void _ZN7S1537C1C1Ev();
extern void _ZN7S1537C1D1Ev();
Name_Map name_map_S1537C1[] = {
  NSPAIR(_ZN7S1537C1C1Ev),
  NSPAIR(_ZN7S1537C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1537C4_nt;
extern VTBL_ENTRY _ZTI10S1537C4_nt[];
extern  VTBL_ENTRY _ZTV10S1537C4_nt[];
extern Class_Descriptor cd_S1537C3_nt;
extern VTBL_ENTRY _ZTI10S1537C3_nt[];
extern  VTBL_ENTRY _ZTV10S1537C3_nt[];
extern Class_Descriptor cd_S1537C2;
extern VTBL_ENTRY _ZTI7S1537C2[];
extern  VTBL_ENTRY _ZTV7S1537C2[];
static Base_Class bases_S1537C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1537C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1537C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1537C1[];
extern void _ZN7S1537C1D1Ev();
extern void _ZN7S1537C1D0Ev();
extern void _ZN10S1537C4_nt2v7Ev();
extern void _ZN10S1537C4_nt2v8Ev();
extern void _ZN10S1537C4_nt2v9Ev();
extern void _ZN10S1537C4_nt3v10Ev();
extern void _ZN10S1537C4_nt3v11Ev();
extern void _ZN10S1537C4_nt3v12Ev();
extern void _ZN10S1537C4_nt3v13Ev();
extern void _ZN10S1537C4_nt3v14Ev();
extern void _ZN10S1537C4_nt3v15Ev();
extern void _ZN10S1537C4_nt3v16Ev();
extern void _ZN10S1537C4_nt3v17Ev();
extern void _ZN10S1537C4_nt3v18Ev();
extern void _ZN10S1537C4_nt3v19Ev();
extern void _ZN10S1537C4_nt3v20Ev();
extern void _ZN10S1537C4_nt3v21Ev();
extern void _ZN10S1537C4_nt3v22Ev();
extern void _ZN10S1537C4_nt3v23Ev();
extern void _ZN10S1537C4_nt3v24Ev();
extern void _ZN10S1537C4_nt3v25Ev();
extern void _ZN10S1537C4_nt3v26Ev();
extern void _ZN10S1537C4_nt3v27Ev();
extern void _ZN10S1537C4_nt3v28Ev();
extern void _ZN10S1537C4_nt3v29Ev();
extern void _ZN10S1537C4_nt3v30Ev();
extern void _ZN10S1537C4_nt3v31Ev();
extern void _ZN10S1537C4_nt3v32Ev();
extern void _ZN10S1537C4_nt3v33Ev();
extern void _ZN10S1537C4_nt3v34Ev();
extern void _ZN10S1537C4_nt3v35Ev();
extern void _ZN10S1537C4_nt3v36Ev();
extern void _ZN10S1537C4_nt3v37Ev();
extern void _ZN10S1537C4_nt3v38Ev();
extern void _ZN10S1537C4_nt3v39Ev();
extern void _ZN10S1537C4_nt3v40Ev();
extern void _ZN10S1537C4_nt3v41Ev();
extern void _ZN10S1537C4_nt3v42Ev();
extern void _ZN10S1537C4_nt3v43Ev();
extern void _ZN10S1537C4_nt3v44Ev();
extern void _ZN10S1537C4_nt3v45Ev();
extern void _ZN10S1537C4_nt3v46Ev();
extern void _ZN10S1537C4_nt3v47Ev();
extern void _ZN10S1537C4_nt3v48Ev();
extern void _ZN10S1537C4_nt3v49Ev();
extern void _ZN10S1537C4_nt3v50Ev();
extern void _ZN10S1537C4_nt3v51Ev();
extern void _ZN10S1537C4_nt3v52Ev();
extern void _ZN10S1537C4_nt3v53Ev();
extern void _ZN10S1537C4_nt3v54Ev();
extern void _ZN10S1537C4_nt3v55Ev();
extern void _ZN10S1537C4_nt3v56Ev();
extern void _ZN10S1537C4_nt3v57Ev();
extern void _ZN10S1537C4_nt3v58Ev();
extern void _ZN10S1537C4_nt3v59Ev();
extern void _ZN10S1537C4_nt3v60Ev();
extern void _ZN10S1537C4_nt3v61Ev();
extern void _ZN10S1537C4_nt3v62Ev();
extern void _ZN10S1537C4_nt3v63Ev();
extern void _ZN10S1537C4_nt3v64Ev();
extern void _ZN10S1537C4_nt3v65Ev();
extern void _ZN10S1537C4_nt3v66Ev();
extern void _ZN10S1537C4_nt3v67Ev();
extern void _ZN10S1537C4_nt3v68Ev();
extern void _ZN10S1537C4_nt3v69Ev();
extern void _ZN10S1537C4_nt3v70Ev();
extern void _ZN10S1537C3_nt3v71Ev();
extern void _ZN10S1537C3_nt3v72Ev();
extern void _ZN10S1537C3_nt3v73Ev();
extern void _ZN10S1537C3_nt3v74Ev();
extern void _ZN10S1537C3_nt3v75Ev();
extern void _ZN10S1537C3_nt3v76Ev();
extern void _ZN10S1537C3_nt3v77Ev();
extern void _ZN10S1537C3_nt3v78Ev();
extern void _ZN10S1537C3_nt3v79Ev();
extern void _ZN10S1537C3_nt3v80Ev();
extern void _ZN10S1537C3_nt3v81Ev();
extern void _ZN10S1537C3_nt3v82Ev();
extern void _ZN10S1537C3_nt3v83Ev();
extern void _ZN10S1537C3_nt3v84Ev();
extern void _ZN10S1537C3_nt3v85Ev();
extern void _ZN10S1537C3_nt3v86Ev();
extern void _ZN10S1537C3_nt3v87Ev();
extern void _ZN10S1537C3_nt3v88Ev();
extern void _ZN10S1537C3_nt3v89Ev();
extern void _ZN10S1537C3_nt3v90Ev();
extern void _ZN10S1537C3_nt3v91Ev();
extern void _ZN10S1537C3_nt3v92Ev();
extern void _ZN10S1537C3_nt3v93Ev();
extern void _ZN10S1537C3_nt3v94Ev();
extern void _ZN10S1537C3_nt3v95Ev();
extern void _ZN10S1537C3_nt3v96Ev();
extern void _ZN10S1537C3_nt3v97Ev();
extern void _ZN10S1537C3_nt3v98Ev();
extern void _ZN10S1537C3_nt3v99Ev();
extern void _ZN10S1537C3_nt4v100Ev();
extern void _ZN10S1537C3_nt4v101Ev();
extern void _ZN10S1537C3_nt4v102Ev();
extern void _ZN10S1537C3_nt4v103Ev();
extern void _ZN10S1537C3_nt4v104Ev();
extern void _ZN10S1537C3_nt4v105Ev();
extern void _ZN10S1537C3_nt4v106Ev();
extern void _ZN10S1537C3_nt4v107Ev();
extern void _ZN10S1537C3_nt4v108Ev();
extern void _ZN10S1537C3_nt4v109Ev();
extern void _ZN10S1537C3_nt4v110Ev();
extern void _ZN10S1537C3_nt4v111Ev();
extern void _ZN10S1537C3_nt4v112Ev();
extern void _ZN10S1537C3_nt4v113Ev();
extern void _ZN10S1537C3_nt4v114Ev();
extern void _ZN10S1537C3_nt4v115Ev();
extern void _ZN10S1537C3_nt4v116Ev();
extern void _ZN10S1537C3_nt4v117Ev();
extern void _ZN10S1537C3_nt4v118Ev();
extern void _ZN10S1537C3_nt4v119Ev();
extern void _ZN10S1537C3_nt4v120Ev();
extern void _ZN10S1537C3_nt4v121Ev();
extern void _ZN10S1537C3_nt4v122Ev();
extern void _ZN10S1537C3_nt4v123Ev();
extern void _ZN10S1537C3_nt4v124Ev();
extern void _ZN10S1537C3_nt4v125Ev();
extern void _ZN10S1537C3_nt4v126Ev();
extern void _ZN10S1537C3_nt4v127Ev();
extern void _ZN10S1537C3_nt4v128Ev();
extern void _ZN10S1537C3_nt4v129Ev();
extern void _ZN10S1537C3_nt4v130Ev();
extern void _ZN10S1537C3_nt4v131Ev();
extern void _ZN10S1537C3_nt4v132Ev();
extern void _ZN10S1537C3_nt4v133Ev();
extern void _ZN10S1537C3_nt4v134Ev();
extern void _ZN10S1537C3_nt4v135Ev();
extern void _ZN10S1537C3_nt4v136Ev();
extern void _ZN10S1537C3_nt4v137Ev();
extern void _ZN10S1537C3_nt4v138Ev();
extern void _ZN10S1537C3_nt4v139Ev();
extern void _ZN10S1537C3_nt4v140Ev();
extern void _ZN10S1537C3_nt4v141Ev();
extern void _ZN10S1537C3_nt4v142Ev();
extern void _ZN10S1537C3_nt4v143Ev();
extern void _ZN10S1537C3_nt4v144Ev();
extern void _ZN10S1537C3_nt4v145Ev();
extern void _ZN10S1537C3_nt4v146Ev();
extern void _ZN10S1537C3_nt4v147Ev();
extern void _ZN10S1537C3_nt4v148Ev();
extern void _ZN10S1537C3_nt4v149Ev();
extern void _ZN10S1537C3_nt4v150Ev();
extern void _ZN10S1537C3_nt4v151Ev();
extern void _ZN10S1537C3_nt4v152Ev();
extern void _ZN10S1537C3_nt4v153Ev();
extern void _ZN10S1537C3_nt4v154Ev();
extern void _ZN10S1537C3_nt4v155Ev();
extern void _ZN10S1537C3_nt4v156Ev();
extern void _ZN10S1537C3_nt4v157Ev();
extern void _ZN10S1537C3_nt4v158Ev();
extern void _ZN10S1537C3_nt4v159Ev();
extern void _ZN10S1537C3_nt4v160Ev();
extern void _ZN10S1537C3_nt4v161Ev();
extern void _ZN10S1537C3_nt4v162Ev();
extern void _ZN10S1537C3_nt4v163Ev();
extern void _ZN10S1537C3_nt4v164Ev();
extern void _ZN10S1537C3_nt4v165Ev();
extern void _ZN10S1537C3_nt4v166Ev();
extern void _ZN10S1537C3_nt4v167Ev();
extern void _ZN10S1537C3_nt4v168Ev();
extern void _ZN10S1537C3_nt4v169Ev();
extern void _ZN10S1537C3_nt4v170Ev();
extern void _ZN10S1537C3_nt4v171Ev();
extern void _ZN10S1537C3_nt4v172Ev();
extern void _ZN10S1537C3_nt4v173Ev();
extern void _ZN10S1537C3_nt4v174Ev();
extern void _ZN10S1537C3_nt4v175Ev();
extern void _ZN10S1537C3_nt4v176Ev();
extern void _ZN10S1537C3_nt4v177Ev();
extern void _ZN10S1537C3_nt4v178Ev();
extern void _ZN10S1537C3_nt4v179Ev();
extern void _ZN10S1537C3_nt4v180Ev();
extern void _ZN10S1537C3_nt4v181Ev();
extern void _ZN10S1537C3_nt4v182Ev();
extern void _ZN10S1537C3_nt4v183Ev();
extern void _ZN10S1537C3_nt4v184Ev();
extern void _ZN10S1537C3_nt4v185Ev();
extern void _ZN10S1537C3_nt4v186Ev();
extern void _ZN10S1537C3_nt4v187Ev();
extern void _ZN10S1537C3_nt4v188Ev();
extern void _ZN10S1537C3_nt4v189Ev();
extern void _ZN10S1537C3_nt4v190Ev();
extern void _ZN10S1537C3_nt4v191Ev();
extern void _ZN10S1537C3_nt4v192Ev();
extern void _ZN10S1537C3_nt4v193Ev();
extern void _ZN10S1537C3_nt4v194Ev();
extern void _ZN10S1537C3_nt4v195Ev();
extern void _ZN10S1537C3_nt4v196Ev();
extern void _ZN10S1537C3_nt4v197Ev();
extern void _ZN10S1537C3_nt4v198Ev();
extern void _ZN10S1537C3_nt4v199Ev();
extern void _ZN10S1537C3_nt4v200Ev();
extern void _ZN10S1537C3_nt4v201Ev();
extern void _ZN10S1537C3_nt4v202Ev();
extern void _ZN10S1537C3_nt4v203Ev();
extern void _ZN10S1537C3_nt4v204Ev();
extern void _ZN10S1537C3_nt4v205Ev();
extern void _ZN10S1537C3_nt4v206Ev();
extern void _ZN10S1537C3_nt4v207Ev();
extern void _ZN10S1537C3_nt4v208Ev();
extern void _ZN10S1537C3_nt4v209Ev();
extern void _ZN10S1537C3_nt4v210Ev();
extern void _ZN10S1537C3_nt4v211Ev();
extern void _ZN10S1537C3_nt4v212Ev();
extern void _ZN10S1537C3_nt4v213Ev();
extern void _ZN7S1537C24v214Ev();
extern void _ZN7S1537C24v215Ev();
extern void _ZN7S1537C24v216Ev();
extern void _ZN7S1537C24v217Ev();
extern void _ZN7S1537C24v218Ev();
extern void _ZN7S1537C24v219Ev();
extern void _ZN7S1537C24v220Ev();
extern void _ZN7S1537C24v221Ev();
extern void _ZN7S1537C24v222Ev();
extern void _ZN7S1537C24v223Ev();
extern void _ZN7S1537C12v1Ev();
extern void _ZN7S1537C12v2Ev();
extern void _ZN7S1537C12v3Ev();
extern void _ZN7S1537C12v4Ev();
extern void _ZN7S1537C12v5Ev();
extern void _ZN7S1537C12v6Ev();
static  VTBL_ENTRY vtc_S1537C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1537C1[0]),
  (VTBL_ENTRY)&_ZN7S1537C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1537C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1537C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1537C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v214Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v215Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v216Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v217Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v218Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v219Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v220Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v221Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v222Ev,
  (VTBL_ENTRY)&_ZN7S1537C24v223Ev,
  (VTBL_ENTRY)&_ZN7S1537C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1537C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1537C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1537C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1537C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1537C12v6Ev,
};
extern VTBL_ENTRY _ZTI7S1537C1[];
extern  VTBL_ENTRY _ZTV7S1537C1[];
Class_Descriptor cd_S1537C1 = {  "S1537C1", // class name
  bases_S1537C1, 3,
  &(vtc_S1537C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1416,1128), // object size
  NSPAIRA(_ZTI7S1537C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1537C1),227, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C4  {
  int s1325c4f0;
  __tsi64 s1325c4f1;
  void *s1325c4f2[4];
  int s1325c4f3[2];
  void *s1325c4f4;
  ::S1537C5_nt s1325c4f5;
  void *s1325c4f6[2];
  virtual  ~S1325C4(); // _ZN7S1325C4D1Ev
  virtual void  v18(); // _ZN7S1325C43v18Ev
  virtual void  v19(); // _ZN7S1325C43v19Ev
  virtual void  v20(); // _ZN7S1325C43v20Ev
  virtual void  v21(); // _ZN7S1325C43v21Ev
  virtual void  v22(); // _ZN7S1325C43v22Ev
  virtual void  v23(); // _ZN7S1325C43v23Ev
  virtual void  v24(); // _ZN7S1325C43v24Ev
  virtual void  v25(); // _ZN7S1325C43v25Ev
  virtual void  v26(); // _ZN7S1325C43v26Ev
  virtual void  v27(); // _ZN7S1325C43v27Ev
  virtual void  v28(); // _ZN7S1325C43v28Ev
  virtual void  v29(); // _ZN7S1325C43v29Ev
  virtual void  v30(); // _ZN7S1325C43v30Ev
  virtual void  v31(); // _ZN7S1325C43v31Ev
  virtual void  v32(); // _ZN7S1325C43v32Ev
  virtual void  v33(); // _ZN7S1325C43v33Ev
  virtual void  v34(); // _ZN7S1325C43v34Ev
  virtual void  v35(); // _ZN7S1325C43v35Ev
  virtual void  v36(); // _ZN7S1325C43v36Ev
  virtual void  v37(); // _ZN7S1325C43v37Ev
  virtual void  v38(); // _ZN7S1325C43v38Ev
  virtual void  v39(); // _ZN7S1325C43v39Ev
  virtual void  v40(); // _ZN7S1325C43v40Ev
  virtual void  v41(); // _ZN7S1325C43v41Ev
  virtual void  v42(); // _ZN7S1325C43v42Ev
  virtual void  v43(); // _ZN7S1325C43v43Ev
  virtual void  v44(); // _ZN7S1325C43v44Ev
  virtual void  v45(); // _ZN7S1325C43v45Ev
  virtual void  v46(); // _ZN7S1325C43v46Ev
  virtual void  v47(); // _ZN7S1325C43v47Ev
  virtual void  v48(); // _ZN7S1325C43v48Ev
  virtual void  v49(); // _ZN7S1325C43v49Ev
  virtual void  v50(); // _ZN7S1325C43v50Ev
  virtual void  v51(); // _ZN7S1325C43v51Ev
  virtual void  v52(); // _ZN7S1325C43v52Ev
  virtual void  v53(); // _ZN7S1325C43v53Ev
  virtual void  v54(); // _ZN7S1325C43v54Ev
  virtual void  v55(); // _ZN7S1325C43v55Ev
  virtual void  v56(); // _ZN7S1325C43v56Ev
  virtual void  v57(); // _ZN7S1325C43v57Ev
  virtual void  v58(); // _ZN7S1325C43v58Ev
  virtual void  v59(); // _ZN7S1325C43v59Ev
  virtual void  v60(); // _ZN7S1325C43v60Ev
  virtual void  v61(); // _ZN7S1325C43v61Ev
  virtual void  v62(); // _ZN7S1325C43v62Ev
  virtual void  v63(); // _ZN7S1325C43v63Ev
  virtual void  v64(); // _ZN7S1325C43v64Ev
  virtual void  v65(); // _ZN7S1325C43v65Ev
  virtual void  v66(); // _ZN7S1325C43v66Ev
  virtual void  v67(); // _ZN7S1325C43v67Ev
  virtual void  v68(); // _ZN7S1325C43v68Ev
  virtual void  v69(); // _ZN7S1325C43v69Ev
  virtual void  v70(); // _ZN7S1325C43v70Ev
  virtual void  v71(); // _ZN7S1325C43v71Ev
  virtual void  v72(); // _ZN7S1325C43v72Ev
  virtual void  v73(); // _ZN7S1325C43v73Ev
  virtual void  v74(); // _ZN7S1325C43v74Ev
  virtual void  v75(); // _ZN7S1325C43v75Ev
  virtual void  v76(); // _ZN7S1325C43v76Ev
  virtual void  v77(); // _ZN7S1325C43v77Ev
  virtual void  v78(); // _ZN7S1325C43v78Ev
  virtual void  v79(); // _ZN7S1325C43v79Ev
  virtual void  v80(); // _ZN7S1325C43v80Ev
  virtual void  v81(); // _ZN7S1325C43v81Ev
  S1325C4(); // tgen
};
//SIG(-1 S1325C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1325C4 ::~S1325C4(){ note_dtor("S1325C4", this);}
void  S1325C4 ::v18(){vfunc_called(this, "_ZN7S1325C43v18Ev");}
void  S1325C4 ::v19(){vfunc_called(this, "_ZN7S1325C43v19Ev");}
void  S1325C4 ::v20(){vfunc_called(this, "_ZN7S1325C43v20Ev");}
void  S1325C4 ::v21(){vfunc_called(this, "_ZN7S1325C43v21Ev");}
void  S1325C4 ::v22(){vfunc_called(this, "_ZN7S1325C43v22Ev");}
void  S1325C4 ::v23(){vfunc_called(this, "_ZN7S1325C43v23Ev");}
void  S1325C4 ::v24(){vfunc_called(this, "_ZN7S1325C43v24Ev");}
void  S1325C4 ::v25(){vfunc_called(this, "_ZN7S1325C43v25Ev");}
void  S1325C4 ::v26(){vfunc_called(this, "_ZN7S1325C43v26Ev");}
void  S1325C4 ::v27(){vfunc_called(this, "_ZN7S1325C43v27Ev");}
void  S1325C4 ::v28(){vfunc_called(this, "_ZN7S1325C43v28Ev");}
void  S1325C4 ::v29(){vfunc_called(this, "_ZN7S1325C43v29Ev");}
void  S1325C4 ::v30(){vfunc_called(this, "_ZN7S1325C43v30Ev");}
void  S1325C4 ::v31(){vfunc_called(this, "_ZN7S1325C43v31Ev");}
void  S1325C4 ::v32(){vfunc_called(this, "_ZN7S1325C43v32Ev");}
void  S1325C4 ::v33(){vfunc_called(this, "_ZN7S1325C43v33Ev");}
void  S1325C4 ::v34(){vfunc_called(this, "_ZN7S1325C43v34Ev");}
void  S1325C4 ::v35(){vfunc_called(this, "_ZN7S1325C43v35Ev");}
void  S1325C4 ::v36(){vfunc_called(this, "_ZN7S1325C43v36Ev");}
void  S1325C4 ::v37(){vfunc_called(this, "_ZN7S1325C43v37Ev");}
void  S1325C4 ::v38(){vfunc_called(this, "_ZN7S1325C43v38Ev");}
void  S1325C4 ::v39(){vfunc_called(this, "_ZN7S1325C43v39Ev");}
void  S1325C4 ::v40(){vfunc_called(this, "_ZN7S1325C43v40Ev");}
void  S1325C4 ::v41(){vfunc_called(this, "_ZN7S1325C43v41Ev");}
void  S1325C4 ::v42(){vfunc_called(this, "_ZN7S1325C43v42Ev");}
void  S1325C4 ::v43(){vfunc_called(this, "_ZN7S1325C43v43Ev");}
void  S1325C4 ::v44(){vfunc_called(this, "_ZN7S1325C43v44Ev");}
void  S1325C4 ::v45(){vfunc_called(this, "_ZN7S1325C43v45Ev");}
void  S1325C4 ::v46(){vfunc_called(this, "_ZN7S1325C43v46Ev");}
void  S1325C4 ::v47(){vfunc_called(this, "_ZN7S1325C43v47Ev");}
void  S1325C4 ::v48(){vfunc_called(this, "_ZN7S1325C43v48Ev");}
void  S1325C4 ::v49(){vfunc_called(this, "_ZN7S1325C43v49Ev");}
void  S1325C4 ::v50(){vfunc_called(this, "_ZN7S1325C43v50Ev");}
void  S1325C4 ::v51(){vfunc_called(this, "_ZN7S1325C43v51Ev");}
void  S1325C4 ::v52(){vfunc_called(this, "_ZN7S1325C43v52Ev");}
void  S1325C4 ::v53(){vfunc_called(this, "_ZN7S1325C43v53Ev");}
void  S1325C4 ::v54(){vfunc_called(this, "_ZN7S1325C43v54Ev");}
void  S1325C4 ::v55(){vfunc_called(this, "_ZN7S1325C43v55Ev");}
void  S1325C4 ::v56(){vfunc_called(this, "_ZN7S1325C43v56Ev");}
void  S1325C4 ::v57(){vfunc_called(this, "_ZN7S1325C43v57Ev");}
void  S1325C4 ::v58(){vfunc_called(this, "_ZN7S1325C43v58Ev");}
void  S1325C4 ::v59(){vfunc_called(this, "_ZN7S1325C43v59Ev");}
void  S1325C4 ::v60(){vfunc_called(this, "_ZN7S1325C43v60Ev");}
void  S1325C4 ::v61(){vfunc_called(this, "_ZN7S1325C43v61Ev");}
void  S1325C4 ::v62(){vfunc_called(this, "_ZN7S1325C43v62Ev");}
void  S1325C4 ::v63(){vfunc_called(this, "_ZN7S1325C43v63Ev");}
void  S1325C4 ::v64(){vfunc_called(this, "_ZN7S1325C43v64Ev");}
void  S1325C4 ::v65(){vfunc_called(this, "_ZN7S1325C43v65Ev");}
void  S1325C4 ::v66(){vfunc_called(this, "_ZN7S1325C43v66Ev");}
void  S1325C4 ::v67(){vfunc_called(this, "_ZN7S1325C43v67Ev");}
void  S1325C4 ::v68(){vfunc_called(this, "_ZN7S1325C43v68Ev");}
void  S1325C4 ::v69(){vfunc_called(this, "_ZN7S1325C43v69Ev");}
void  S1325C4 ::v70(){vfunc_called(this, "_ZN7S1325C43v70Ev");}
void  S1325C4 ::v71(){vfunc_called(this, "_ZN7S1325C43v71Ev");}
void  S1325C4 ::v72(){vfunc_called(this, "_ZN7S1325C43v72Ev");}
void  S1325C4 ::v73(){vfunc_called(this, "_ZN7S1325C43v73Ev");}
void  S1325C4 ::v74(){vfunc_called(this, "_ZN7S1325C43v74Ev");}
void  S1325C4 ::v75(){vfunc_called(this, "_ZN7S1325C43v75Ev");}
void  S1325C4 ::v76(){vfunc_called(this, "_ZN7S1325C43v76Ev");}
void  S1325C4 ::v77(){vfunc_called(this, "_ZN7S1325C43v77Ev");}
void  S1325C4 ::v78(){vfunc_called(this, "_ZN7S1325C43v78Ev");}
void  S1325C4 ::v79(){vfunc_called(this, "_ZN7S1325C43v79Ev");}
void  S1325C4 ::v80(){vfunc_called(this, "_ZN7S1325C43v80Ev");}
void  S1325C4 ::v81(){vfunc_called(this, "_ZN7S1325C43v81Ev");}
S1325C4 ::S1325C4(){ note_ctor("S1325C4", this);} // tgen

static void Test_S1325C4()
{
  extern Class_Descriptor cd_S1325C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1325C4, buf);
    S1325C4 *dp, &lv = *(dp=new (buf) S1325C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1325C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C4)");
    check_field_offset(lv, s1325c4f0, ABISELECT(8,4), "S1325C4.s1325c4f0");
    check_field_offset(lv, s1325c4f1, ABISELECT(16,8), "S1325C4.s1325c4f1");
    check_field_offset(lv, s1325c4f2, ABISELECT(24,16), "S1325C4.s1325c4f2");
    check_field_offset(lv, s1325c4f3, ABISELECT(56,32), "S1325C4.s1325c4f3");
    check_field_offset(lv, s1325c4f4, ABISELECT(64,40), "S1325C4.s1325c4f4");
    check_field_offset(lv, s1325c4f5, ABISELECT(72,44), "S1325C4.s1325c4f5");
    check_field_offset(lv, s1325c4f6, ABISELECT(80,52), "S1325C4.s1325c4f6");
    test_class_info(&lv, &cd_S1325C4);
    dp->~S1325C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C4(Test_S1325C4, "S1325C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1325C4C1Ev();
extern void _ZN7S1325C4D1Ev();
Name_Map name_map_S1325C4[] = {
  NSPAIR(_ZN7S1325C4C1Ev),
  NSPAIR(_ZN7S1325C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1325C4[];
extern void _ZN7S1325C4D1Ev();
extern void _ZN7S1325C4D0Ev();
extern void _ZN7S1325C43v18Ev();
extern void _ZN7S1325C43v19Ev();
extern void _ZN7S1325C43v20Ev();
extern void _ZN7S1325C43v21Ev();
extern void _ZN7S1325C43v22Ev();
extern void _ZN7S1325C43v23Ev();
extern void _ZN7S1325C43v24Ev();
extern void _ZN7S1325C43v25Ev();
extern void _ZN7S1325C43v26Ev();
extern void _ZN7S1325C43v27Ev();
extern void _ZN7S1325C43v28Ev();
extern void _ZN7S1325C43v29Ev();
extern void _ZN7S1325C43v30Ev();
extern void _ZN7S1325C43v31Ev();
extern void _ZN7S1325C43v32Ev();
extern void _ZN7S1325C43v33Ev();
extern void _ZN7S1325C43v34Ev();
extern void _ZN7S1325C43v35Ev();
extern void _ZN7S1325C43v36Ev();
extern void _ZN7S1325C43v37Ev();
extern void _ZN7S1325C43v38Ev();
extern void _ZN7S1325C43v39Ev();
extern void _ZN7S1325C43v40Ev();
extern void _ZN7S1325C43v41Ev();
extern void _ZN7S1325C43v42Ev();
extern void _ZN7S1325C43v43Ev();
extern void _ZN7S1325C43v44Ev();
extern void _ZN7S1325C43v45Ev();
extern void _ZN7S1325C43v46Ev();
extern void _ZN7S1325C43v47Ev();
extern void _ZN7S1325C43v48Ev();
extern void _ZN7S1325C43v49Ev();
extern void _ZN7S1325C43v50Ev();
extern void _ZN7S1325C43v51Ev();
extern void _ZN7S1325C43v52Ev();
extern void _ZN7S1325C43v53Ev();
extern void _ZN7S1325C43v54Ev();
extern void _ZN7S1325C43v55Ev();
extern void _ZN7S1325C43v56Ev();
extern void _ZN7S1325C43v57Ev();
extern void _ZN7S1325C43v58Ev();
extern void _ZN7S1325C43v59Ev();
extern void _ZN7S1325C43v60Ev();
extern void _ZN7S1325C43v61Ev();
extern void _ZN7S1325C43v62Ev();
extern void _ZN7S1325C43v63Ev();
extern void _ZN7S1325C43v64Ev();
extern void _ZN7S1325C43v65Ev();
extern void _ZN7S1325C43v66Ev();
extern void _ZN7S1325C43v67Ev();
extern void _ZN7S1325C43v68Ev();
extern void _ZN7S1325C43v69Ev();
extern void _ZN7S1325C43v70Ev();
extern void _ZN7S1325C43v71Ev();
extern void _ZN7S1325C43v72Ev();
extern void _ZN7S1325C43v73Ev();
extern void _ZN7S1325C43v74Ev();
extern void _ZN7S1325C43v75Ev();
extern void _ZN7S1325C43v76Ev();
extern void _ZN7S1325C43v77Ev();
extern void _ZN7S1325C43v78Ev();
extern void _ZN7S1325C43v79Ev();
extern void _ZN7S1325C43v80Ev();
extern void _ZN7S1325C43v81Ev();
static  VTBL_ENTRY vtc_S1325C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1325C4[0]),
  (VTBL_ENTRY)&_ZN7S1325C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1325C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v81Ev,
};
extern VTBL_ENTRY _ZTI7S1325C4[];
extern  VTBL_ENTRY _ZTV7S1325C4[];
Class_Descriptor cd_S1325C4 = {  "S1325C4", // class name
  0,0,//no base classes
  &(vtc_S1325C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1325C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1325C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C6  {
  virtual void  v82(); // _ZN7S1325C63v82Ev
  ~S1325C6(); // tgen
  S1325C6(); // tgen
};
//SIG(-1 S1325C6) C1{ v1}


void  S1325C6 ::v82(){vfunc_called(this, "_ZN7S1325C63v82Ev");}
S1325C6 ::~S1325C6(){ note_dtor("S1325C6", this);} // tgen
S1325C6 ::S1325C6(){ note_ctor("S1325C6", this);} // tgen

static void Test_S1325C6()
{
  extern Class_Descriptor cd_S1325C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1325C6, buf);
    S1325C6 *dp, &lv = *(dp=new (buf) S1325C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1325C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C6)");
    test_class_info(&lv, &cd_S1325C6);
    dp->~S1325C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C6(Test_S1325C6, "S1325C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1325C6C1Ev();
extern void _ZN7S1325C6D1Ev();
Name_Map name_map_S1325C6[] = {
  NSPAIR(_ZN7S1325C6C1Ev),
  NSPAIR(_ZN7S1325C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1325C6[];
extern void _ZN7S1325C63v82Ev();
static  VTBL_ENTRY vtc_S1325C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1325C6[0]),
  (VTBL_ENTRY)&_ZN7S1325C63v82Ev,
};
extern VTBL_ENTRY _ZTI7S1325C6[];
extern  VTBL_ENTRY _ZTV7S1325C6[];
Class_Descriptor cd_S1325C6 = {  "S1325C6", // class name
  0,0,//no base classes
  &(vtc_S1325C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1325C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1325C6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C3  : S1325C4 , S1325C6 {
  virtual  ~S1325C3(); // _ZN7S1325C3D1Ev
  virtual void  v83(); // _ZN7S1325C33v83Ev
  virtual void  v84(); // _ZN7S1325C33v84Ev
  virtual void  v85(); // _ZN7S1325C33v85Ev
  virtual void  v86(); // _ZN7S1325C33v86Ev
  S1325C3(); // tgen
};
//SIG(-1 S1325C3) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v69} vd v1 v2 v3 v4}


 S1325C3 ::~S1325C3(){ note_dtor("S1325C3", this);}
void  S1325C3 ::v83(){vfunc_called(this, "_ZN7S1325C33v83Ev");}
void  S1325C3 ::v84(){vfunc_called(this, "_ZN7S1325C33v84Ev");}
void  S1325C3 ::v85(){vfunc_called(this, "_ZN7S1325C33v85Ev");}
void  S1325C3 ::v86(){vfunc_called(this, "_ZN7S1325C33v86Ev");}
S1325C3 ::S1325C3(){ note_ctor("S1325C3", this);} // tgen

static void Test_S1325C3()
{
  extern Class_Descriptor cd_S1325C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1325C3, buf);
    S1325C3 *dp, &lv = *(dp=new (buf) S1325C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1325C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C3)");
    check_base_class_offset(lv, (S1325C4*), 0, "S1325C3");
    check_base_class_offset(lv, (S1325C6*), ABISELECT(96,60), "S1325C3");
    test_class_info(&lv, &cd_S1325C3);
    dp->~S1325C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C3(Test_S1325C3, "S1325C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1325C3C1Ev();
extern void _ZN7S1325C3D1Ev();
Name_Map name_map_S1325C3[] = {
  NSPAIR(_ZN7S1325C3C1Ev),
  NSPAIR(_ZN7S1325C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1325C4;
extern VTBL_ENTRY _ZTI7S1325C4[];
extern  VTBL_ENTRY _ZTV7S1325C4[];
extern Class_Descriptor cd_S1325C6;
extern VTBL_ENTRY _ZTI7S1325C6[];
extern  VTBL_ENTRY _ZTV7S1325C6[];
static Base_Class bases_S1325C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1325C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1325C6,    ABISELECT(96,60), //bcp->offset
    72, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1325C3[];
extern void _ZN7S1325C3D1Ev();
extern void _ZN7S1325C3D0Ev();
extern void _ZN7S1325C43v18Ev();
extern void _ZN7S1325C43v19Ev();
extern void _ZN7S1325C43v20Ev();
extern void _ZN7S1325C43v21Ev();
extern void _ZN7S1325C43v22Ev();
extern void _ZN7S1325C43v23Ev();
extern void _ZN7S1325C43v24Ev();
extern void _ZN7S1325C43v25Ev();
extern void _ZN7S1325C43v26Ev();
extern void _ZN7S1325C43v27Ev();
extern void _ZN7S1325C43v28Ev();
extern void _ZN7S1325C43v29Ev();
extern void _ZN7S1325C43v30Ev();
extern void _ZN7S1325C43v31Ev();
extern void _ZN7S1325C43v32Ev();
extern void _ZN7S1325C43v33Ev();
extern void _ZN7S1325C43v34Ev();
extern void _ZN7S1325C43v35Ev();
extern void _ZN7S1325C43v36Ev();
extern void _ZN7S1325C43v37Ev();
extern void _ZN7S1325C43v38Ev();
extern void _ZN7S1325C43v39Ev();
extern void _ZN7S1325C43v40Ev();
extern void _ZN7S1325C43v41Ev();
extern void _ZN7S1325C43v42Ev();
extern void _ZN7S1325C43v43Ev();
extern void _ZN7S1325C43v44Ev();
extern void _ZN7S1325C43v45Ev();
extern void _ZN7S1325C43v46Ev();
extern void _ZN7S1325C43v47Ev();
extern void _ZN7S1325C43v48Ev();
extern void _ZN7S1325C43v49Ev();
extern void _ZN7S1325C43v50Ev();
extern void _ZN7S1325C43v51Ev();
extern void _ZN7S1325C43v52Ev();
extern void _ZN7S1325C43v53Ev();
extern void _ZN7S1325C43v54Ev();
extern void _ZN7S1325C43v55Ev();
extern void _ZN7S1325C43v56Ev();
extern void _ZN7S1325C43v57Ev();
extern void _ZN7S1325C43v58Ev();
extern void _ZN7S1325C43v59Ev();
extern void _ZN7S1325C43v60Ev();
extern void _ZN7S1325C43v61Ev();
extern void _ZN7S1325C43v62Ev();
extern void _ZN7S1325C43v63Ev();
extern void _ZN7S1325C43v64Ev();
extern void _ZN7S1325C43v65Ev();
extern void _ZN7S1325C43v66Ev();
extern void _ZN7S1325C43v67Ev();
extern void _ZN7S1325C43v68Ev();
extern void _ZN7S1325C43v69Ev();
extern void _ZN7S1325C43v70Ev();
extern void _ZN7S1325C43v71Ev();
extern void _ZN7S1325C43v72Ev();
extern void _ZN7S1325C43v73Ev();
extern void _ZN7S1325C43v74Ev();
extern void _ZN7S1325C43v75Ev();
extern void _ZN7S1325C43v76Ev();
extern void _ZN7S1325C43v77Ev();
extern void _ZN7S1325C43v78Ev();
extern void _ZN7S1325C43v79Ev();
extern void _ZN7S1325C43v80Ev();
extern void _ZN7S1325C43v81Ev();
extern void _ZN7S1325C33v83Ev();
extern void _ZN7S1325C33v84Ev();
extern void _ZN7S1325C33v85Ev();
extern void _ZN7S1325C33v86Ev();
extern void _ZN7S1325C63v82Ev();
static  VTBL_ENTRY vtc_S1325C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1325C3[0]),
  (VTBL_ENTRY)&_ZN7S1325C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1325C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v86Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1325C3[0]),
  (VTBL_ENTRY)&_ZN7S1325C63v82Ev,
};
extern VTBL_ENTRY _ZTI7S1325C3[];
extern  VTBL_ENTRY _ZTV7S1325C3[];
Class_Descriptor cd_S1325C3 = {  "S1325C3", // class name
  bases_S1325C3, 2,
  &(vtc_S1325C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1325C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1325C3),75, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C9  : S1537C8_nt {
};
//SIG(-1 S1325C9) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1325C9()
{
  extern Class_Descriptor cd_S1325C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1325C9, buf);
    S1325C9 &lv = *(new (buf) S1325C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1325C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C9)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1325C9");
    test_class_info(&lv, &cd_S1325C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C9(Test_S1325C9, "S1325C9", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1325C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1325C9 = {  "S1325C9", // class name
  bases_S1325C9, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C8  : S1325C9 {
};
//SIG(-1 S1325C8) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1325C8()
{
  extern Class_Descriptor cd_S1325C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1325C8, buf);
    S1325C8 &lv = *(new (buf) S1325C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1325C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C8)");
    check_base_class_offset(lv, (S1537C8_nt*)(S1325C9*), 0, "S1325C8");
    check_base_class_offset(lv, (S1325C9*), 0, "S1325C8");
    test_class_info(&lv, &cd_S1325C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C8(Test_S1325C8, "S1325C8", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1325C9;
static Base_Class bases_S1325C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1325C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1325C8 = {  "S1325C8", // class name
  bases_S1325C8, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C7_nt  : S1325C8 {
};
//SIG(-1 S1325C7_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S1325C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1325C9;
extern Class_Descriptor cd_S1325C8;
static Base_Class bases_S1325C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1325C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1325C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C14  : S1537C8_nt {
};
//SIG(-1 S1325C14) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1325C14()
{
  extern Class_Descriptor cd_S1325C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1325C14, buf);
    S1325C14 &lv = *(new (buf) S1325C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1325C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C14)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1325C14");
    test_class_info(&lv, &cd_S1325C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C14(Test_S1325C14, "S1325C14", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1325C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1325C14 = {  "S1325C14", // class name
  bases_S1325C14, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C18_nt  {
  void  mf1325c18(); // _ZN11S1325C18_nt9mf1325c18Ev
};
//SIG(-1 S1325C18_nt) C1{ m}


void  S1325C18_nt ::mf1325c18(){}

//skip512 S1325C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C2  : S1325C3 {
  void *s1325c2f0;
  ::S1325C7_nt s1325c2f1;
  void *s1325c2f2;
  ::S1325C7_nt s1325c2f3;
  void *s1325c2f4;
  ::S1325C7_nt s1325c2f5;
  void *s1325c2f6;
  ::S1325C7_nt s1325c2f7;
  ::S1537C22 s1325c2f8;
  ::S1537C18 s1325c2f9;
  void *s1325c2f10;
  ::S1325C7_nt s1325c2f11;
  void *s1325c2f12;
  ::S1325C7_nt s1325c2f13;
  void *s1325c2f14;
  ::S1325C7_nt s1325c2f15;
  void *s1325c2f16;
  ::S1325C7_nt s1325c2f17;
  void *s1325c2f18;
  ::S1325C7_nt s1325c2f19;
  void *s1325c2f20;
  ::S1325C7_nt s1325c2f21;
  void *s1325c2f22;
  ::S1325C7_nt s1325c2f23;
  void *s1325c2f24;
  ::S1325C7_nt s1325c2f25;
  void *s1325c2f26;
  ::S1325C7_nt s1325c2f27;
  void *s1325c2f28;
  ::S1325C7_nt s1325c2f29;
  void *s1325c2f30;
  ::S1325C7_nt s1325c2f31;
  void *s1325c2f32;
  ::S1325C7_nt s1325c2f33;
  void *s1325c2f34;
  ::S1325C7_nt s1325c2f35;
  void *s1325c2f36;
  ::S1325C7_nt s1325c2f37;
  ::S1537C12 s1325c2f38;
  ::S1537C12 s1325c2f39;
  unsigned int s1325c2f40:1;
  unsigned int s1325c2f41:1;
  unsigned int s1325c2f42:1;
  unsigned int s1325c2f43:1;
  unsigned int s1325c2f44:1;
  unsigned int s1325c2f45:1;
  unsigned int s1325c2f46:1;
  unsigned int s1325c2f47:1;
  unsigned int s1325c2f48:1;
  unsigned int s1325c2f49:1;
  unsigned int s1325c2f50:1;
  unsigned int s1325c2f51:1;
  unsigned int s1325c2f52:1;
  unsigned int s1325c2f53:1;
  unsigned int s1325c2f54:1;
  unsigned int s1325c2f55:1;
  unsigned int s1325c2f56:1;
  unsigned int s1325c2f57:1;
  unsigned int s1325c2f58:1;
  int s1325c2f59[6];
  void *s1325c2f60;
  ::S1325C7_nt s1325c2f61;
  void *s1325c2f62;
  ::S1325C7_nt s1325c2f63;
  void *s1325c2f64;
  ::S1325C7_nt s1325c2f65;
  int s1325c2f66[3];
  void *s1325c2f67;
  ::S1325C7_nt s1325c2f68;
  void *s1325c2f69;
  ::S1325C7_nt s1325c2f70;
  void *s1325c2f71;
  ::S1325C7_nt s1325c2f72;
  void *s1325c2f73;
  ::S1325C7_nt s1325c2f74;
  void *s1325c2f75;
  ::S1325C7_nt s1325c2f76;
  void *s1325c2f77;
  ::S1325C7_nt s1325c2f78;
  void *s1325c2f79;
  ::S1325C7_nt s1325c2f80;
  void *s1325c2f81;
  ::S1325C7_nt s1325c2f82;
  void *s1325c2f83;
  ::S1325C7_nt s1325c2f84;
  void *s1325c2f85;
  ::S1325C7_nt s1325c2f86;
  int s1325c2f87;
  void *s1325c2f88;
  ::S1537C23 s1325c2f89;
  void *s1325c2f90;
  ::S1325C14 s1325c2f91;
  int s1325c2f92[3];
  void *s1325c2f93[2];
  ::S1325C18_nt s1325c2f94;
  ::S1325C18_nt s1325c2f95;
  ::S1325C18_nt s1325c2f96;
  ::S1325C18_nt s1325c2f97;
  ::S1325C18_nt s1325c2f98;
  ::S1325C18_nt s1325c2f99;
  ::S1325C18_nt s1325c2f100;
  ::S1325C18_nt s1325c2f101;
  ::S1325C18_nt s1325c2f102;
  ::S1325C18_nt s1325c2f103;
  ::S1325C18_nt s1325c2f104;
  ::S1325C18_nt s1325c2f105;
  int s1325c2f106;
  ::S1325C7_nt s1325c2f107;
  char s1325c2f108;
  ::S1325C7_nt s1325c2f109;
  ::S1325C7_nt s1325c2f110;
  int s1325c2f111[12];
  void *s1325c2f112;
  ::S1325C7_nt s1325c2f113;
  int s1325c2f114;
  ::S1537C6_nt s1325c2f115;
  ::S1325C7_nt s1325c2f116;
  int s1325c2f117;
  virtual  ~S1325C2(); // _ZN7S1325C2D1Ev
  virtual void  v87(); // _ZN7S1325C23v87Ev
  virtual void  v88(); // _ZN7S1325C23v88Ev
  virtual void  v89(); // _ZN7S1325C23v89Ev
  virtual void  v90(); // _ZN7S1325C23v90Ev
  virtual void  v91(); // _ZN7S1325C23v91Ev
  virtual void  v92(); // _ZN7S1325C23v92Ev
  virtual void  v93(); // _ZN7S1325C23v93Ev
  virtual void  v94(); // _ZN7S1325C23v94Ev
  virtual void  v95(); // _ZN7S1325C23v95Ev
  virtual void  v96(); // _ZN7S1325C23v96Ev
  virtual void  v97(); // _ZN7S1325C23v97Ev
  virtual void  v98(); // _ZN7S1325C23v98Ev
  virtual void  v99(); // _ZN7S1325C23v99Ev
  virtual void  v100(); // _ZN7S1325C24v100Ev
  virtual void  v101(); // _ZN7S1325C24v101Ev
  virtual void  v102(); // _ZN7S1325C24v102Ev
  virtual void  v103(); // _ZN7S1325C24v103Ev
  virtual void  v104(); // _ZN7S1325C24v104Ev
  virtual void  v105(); // _ZN7S1325C24v105Ev
  virtual void  v106(); // _ZN7S1325C24v106Ev
  virtual void  v107(); // _ZN7S1325C24v107Ev
  virtual void  v108(); // _ZN7S1325C24v108Ev
  virtual void  v109(); // _ZN7S1325C24v109Ev
  virtual void  v110(); // _ZN7S1325C24v110Ev
  virtual void  v111(); // _ZN7S1325C24v111Ev
  virtual void  v112(); // _ZN7S1325C24v112Ev
  virtual void  v113(); // _ZN7S1325C24v113Ev
  virtual void  v114(); // _ZN7S1325C24v114Ev
  virtual void  v115(); // _ZN7S1325C24v115Ev
  virtual void  v116(); // _ZN7S1325C24v116Ev
  virtual void  v117(); // _ZN7S1325C24v117Ev
  virtual void  v118(); // _ZN7S1325C24v118Ev
  virtual void  v119(); // _ZN7S1325C24v119Ev
  virtual void  v120(); // _ZN7S1325C24v120Ev
  S1325C2(); // tgen
};
//SIG(-1 S1325C2) C1{ BC2{ BC3{ vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v99} vd v100 v101 v102 v103} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fp FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} Fp FC6 Fp FC6 Fp FC6 FC10{ BC11{ BC9}} FC12{ BC13{ BC9}} Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 FC14{ BC15{ BC9}} FC14 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] Fp FC6 Fp FC6 Fp FC6 Fi[3] Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fp FC6 Fi Fp FC11 Fp FC16{ BC9} Fi[3] Fp[2] FC17{ m} FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 FC17 Fi FC6 Fc FC6 FC6 Fi[12] Fp FC6 Fi FC18{ BC19{ BC9}} FC6 Fi}


 S1325C2 ::~S1325C2(){ note_dtor("S1325C2", this);}
void  S1325C2 ::v87(){vfunc_called(this, "_ZN7S1325C23v87Ev");}
void  S1325C2 ::v88(){vfunc_called(this, "_ZN7S1325C23v88Ev");}
void  S1325C2 ::v89(){vfunc_called(this, "_ZN7S1325C23v89Ev");}
void  S1325C2 ::v90(){vfunc_called(this, "_ZN7S1325C23v90Ev");}
void  S1325C2 ::v91(){vfunc_called(this, "_ZN7S1325C23v91Ev");}
void  S1325C2 ::v92(){vfunc_called(this, "_ZN7S1325C23v92Ev");}
void  S1325C2 ::v93(){vfunc_called(this, "_ZN7S1325C23v93Ev");}
void  S1325C2 ::v94(){vfunc_called(this, "_ZN7S1325C23v94Ev");}
void  S1325C2 ::v95(){vfunc_called(this, "_ZN7S1325C23v95Ev");}
void  S1325C2 ::v96(){vfunc_called(this, "_ZN7S1325C23v96Ev");}
void  S1325C2 ::v97(){vfunc_called(this, "_ZN7S1325C23v97Ev");}
void  S1325C2 ::v98(){vfunc_called(this, "_ZN7S1325C23v98Ev");}
void  S1325C2 ::v99(){vfunc_called(this, "_ZN7S1325C23v99Ev");}
void  S1325C2 ::v100(){vfunc_called(this, "_ZN7S1325C24v100Ev");}
void  S1325C2 ::v101(){vfunc_called(this, "_ZN7S1325C24v101Ev");}
void  S1325C2 ::v102(){vfunc_called(this, "_ZN7S1325C24v102Ev");}
void  S1325C2 ::v103(){vfunc_called(this, "_ZN7S1325C24v103Ev");}
void  S1325C2 ::v104(){vfunc_called(this, "_ZN7S1325C24v104Ev");}
void  S1325C2 ::v105(){vfunc_called(this, "_ZN7S1325C24v105Ev");}
void  S1325C2 ::v106(){vfunc_called(this, "_ZN7S1325C24v106Ev");}
void  S1325C2 ::v107(){vfunc_called(this, "_ZN7S1325C24v107Ev");}
void  S1325C2 ::v108(){vfunc_called(this, "_ZN7S1325C24v108Ev");}
void  S1325C2 ::v109(){vfunc_called(this, "_ZN7S1325C24v109Ev");}
void  S1325C2 ::v110(){vfunc_called(this, "_ZN7S1325C24v110Ev");}
void  S1325C2 ::v111(){vfunc_called(this, "_ZN7S1325C24v111Ev");}
void  S1325C2 ::v112(){vfunc_called(this, "_ZN7S1325C24v112Ev");}
void  S1325C2 ::v113(){vfunc_called(this, "_ZN7S1325C24v113Ev");}
void  S1325C2 ::v114(){vfunc_called(this, "_ZN7S1325C24v114Ev");}
void  S1325C2 ::v115(){vfunc_called(this, "_ZN7S1325C24v115Ev");}
void  S1325C2 ::v116(){vfunc_called(this, "_ZN7S1325C24v116Ev");}
void  S1325C2 ::v117(){vfunc_called(this, "_ZN7S1325C24v117Ev");}
void  S1325C2 ::v118(){vfunc_called(this, "_ZN7S1325C24v118Ev");}
void  S1325C2 ::v119(){vfunc_called(this, "_ZN7S1325C24v119Ev");}
void  S1325C2 ::v120(){vfunc_called(this, "_ZN7S1325C24v120Ev");}
S1325C2 ::S1325C2(){ note_ctor("S1325C2", this);} // tgen

static void Test_S1325C2()
{
  extern Class_Descriptor cd_S1325C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(156,215)];
    init_test(&cd_S1325C2, buf);
    S1325C2 *dp, &lv = *(dp=new (buf) S1325C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1240,856), "sizeof(S1325C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C2)");
    check_base_class_offset(lv, (S1325C4*)(S1325C3*), 0, "S1325C2");
    check_base_class_offset(lv, (S1325C6*)(S1325C3*), ABISELECT(96,60), "S1325C2");
    check_base_class_offset(lv, (S1325C3*), 0, "S1325C2");
    check_field_offset(lv, s1325c2f0, ABISELECT(104,64), "S1325C2.s1325c2f0");
    check_field_offset(lv, s1325c2f1, ABISELECT(112,68), "S1325C2.s1325c2f1");
    check_field_offset(lv, s1325c2f2, ABISELECT(128,80), "S1325C2.s1325c2f2");
    check_field_offset(lv, s1325c2f3, ABISELECT(136,84), "S1325C2.s1325c2f3");
    check_field_offset(lv, s1325c2f4, ABISELECT(152,96), "S1325C2.s1325c2f4");
    check_field_offset(lv, s1325c2f5, ABISELECT(160,100), "S1325C2.s1325c2f5");
    check_field_offset(lv, s1325c2f6, ABISELECT(176,112), "S1325C2.s1325c2f6");
    check_field_offset(lv, s1325c2f7, ABISELECT(184,116), "S1325C2.s1325c2f7");
    check_field_offset(lv, s1325c2f8, ABISELECT(200,128), "S1325C2.s1325c2f8");
    check_field_offset(lv, s1325c2f9, ABISELECT(216,140), "S1325C2.s1325c2f9");
    check_field_offset(lv, s1325c2f10, ABISELECT(232,152), "S1325C2.s1325c2f10");
    check_field_offset(lv, s1325c2f11, ABISELECT(240,156), "S1325C2.s1325c2f11");
    check_field_offset(lv, s1325c2f12, ABISELECT(256,168), "S1325C2.s1325c2f12");
    check_field_offset(lv, s1325c2f13, ABISELECT(264,172), "S1325C2.s1325c2f13");
    check_field_offset(lv, s1325c2f14, ABISELECT(280,184), "S1325C2.s1325c2f14");
    check_field_offset(lv, s1325c2f15, ABISELECT(288,188), "S1325C2.s1325c2f15");
    check_field_offset(lv, s1325c2f16, ABISELECT(304,200), "S1325C2.s1325c2f16");
    check_field_offset(lv, s1325c2f17, ABISELECT(312,204), "S1325C2.s1325c2f17");
    check_field_offset(lv, s1325c2f18, ABISELECT(328,216), "S1325C2.s1325c2f18");
    check_field_offset(lv, s1325c2f19, ABISELECT(336,220), "S1325C2.s1325c2f19");
    check_field_offset(lv, s1325c2f20, ABISELECT(352,232), "S1325C2.s1325c2f20");
    check_field_offset(lv, s1325c2f21, ABISELECT(360,236), "S1325C2.s1325c2f21");
    check_field_offset(lv, s1325c2f22, ABISELECT(376,248), "S1325C2.s1325c2f22");
    check_field_offset(lv, s1325c2f23, ABISELECT(384,252), "S1325C2.s1325c2f23");
    check_field_offset(lv, s1325c2f24, ABISELECT(400,264), "S1325C2.s1325c2f24");
    check_field_offset(lv, s1325c2f25, ABISELECT(408,268), "S1325C2.s1325c2f25");
    check_field_offset(lv, s1325c2f26, ABISELECT(424,280), "S1325C2.s1325c2f26");
    check_field_offset(lv, s1325c2f27, ABISELECT(432,284), "S1325C2.s1325c2f27");
    check_field_offset(lv, s1325c2f28, ABISELECT(448,296), "S1325C2.s1325c2f28");
    check_field_offset(lv, s1325c2f29, ABISELECT(456,300), "S1325C2.s1325c2f29");
    check_field_offset(lv, s1325c2f30, ABISELECT(472,312), "S1325C2.s1325c2f30");
    check_field_offset(lv, s1325c2f31, ABISELECT(480,316), "S1325C2.s1325c2f31");
    check_field_offset(lv, s1325c2f32, ABISELECT(496,328), "S1325C2.s1325c2f32");
    check_field_offset(lv, s1325c2f33, ABISELECT(504,332), "S1325C2.s1325c2f33");
    check_field_offset(lv, s1325c2f34, ABISELECT(520,344), "S1325C2.s1325c2f34");
    check_field_offset(lv, s1325c2f35, ABISELECT(528,348), "S1325C2.s1325c2f35");
    check_field_offset(lv, s1325c2f36, ABISELECT(544,360), "S1325C2.s1325c2f36");
    check_field_offset(lv, s1325c2f37, ABISELECT(552,364), "S1325C2.s1325c2f37");
    check_field_offset(lv, s1325c2f38, ABISELECT(568,376), "S1325C2.s1325c2f38");
    check_field_offset(lv, s1325c2f39, ABISELECT(584,388), "S1325C2.s1325c2f39");
    set_bf_and_test(lv, s1325c2f40, ABISELECT(600,400), 0, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f41, ABISELECT(600,400), 1, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f42, ABISELECT(600,400), 2, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f43, ABISELECT(600,400), 3, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f44, ABISELECT(600,400), 4, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f45, ABISELECT(600,400), 5, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f46, ABISELECT(600,400), 6, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f47, ABISELECT(600,400), 7, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f48, ABISELECT(601,401), 0, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f49, ABISELECT(601,401), 1, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f50, ABISELECT(601,401), 2, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f51, ABISELECT(601,401), 3, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f52, ABISELECT(601,401), 4, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f53, ABISELECT(601,401), 5, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f54, ABISELECT(601,401), 6, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f55, ABISELECT(601,401), 7, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f56, ABISELECT(602,402), 0, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f57, ABISELECT(602,402), 1, 1, 1, "S1325C2");
    set_bf_and_test(lv, s1325c2f58, ABISELECT(602,402), 2, 1, 1, "S1325C2");
    check_field_offset(lv, s1325c2f59, ABISELECT(604,404), "S1325C2.s1325c2f59");
    check_field_offset(lv, s1325c2f60, ABISELECT(632,428), "S1325C2.s1325c2f60");
    check_field_offset(lv, s1325c2f61, ABISELECT(640,432), "S1325C2.s1325c2f61");
    check_field_offset(lv, s1325c2f62, ABISELECT(656,444), "S1325C2.s1325c2f62");
    check_field_offset(lv, s1325c2f63, ABISELECT(664,448), "S1325C2.s1325c2f63");
    check_field_offset(lv, s1325c2f64, ABISELECT(680,460), "S1325C2.s1325c2f64");
    check_field_offset(lv, s1325c2f65, ABISELECT(688,464), "S1325C2.s1325c2f65");
    check_field_offset(lv, s1325c2f66, ABISELECT(704,476), "S1325C2.s1325c2f66");
    check_field_offset(lv, s1325c2f67, ABISELECT(720,488), "S1325C2.s1325c2f67");
    check_field_offset(lv, s1325c2f68, ABISELECT(728,492), "S1325C2.s1325c2f68");
    check_field_offset(lv, s1325c2f69, ABISELECT(744,504), "S1325C2.s1325c2f69");
    check_field_offset(lv, s1325c2f70, ABISELECT(752,508), "S1325C2.s1325c2f70");
    check_field_offset(lv, s1325c2f71, ABISELECT(768,520), "S1325C2.s1325c2f71");
    check_field_offset(lv, s1325c2f72, ABISELECT(776,524), "S1325C2.s1325c2f72");
    check_field_offset(lv, s1325c2f73, ABISELECT(792,536), "S1325C2.s1325c2f73");
    check_field_offset(lv, s1325c2f74, ABISELECT(800,540), "S1325C2.s1325c2f74");
    check_field_offset(lv, s1325c2f75, ABISELECT(816,552), "S1325C2.s1325c2f75");
    check_field_offset(lv, s1325c2f76, ABISELECT(824,556), "S1325C2.s1325c2f76");
    check_field_offset(lv, s1325c2f77, ABISELECT(840,568), "S1325C2.s1325c2f77");
    check_field_offset(lv, s1325c2f78, ABISELECT(848,572), "S1325C2.s1325c2f78");
    check_field_offset(lv, s1325c2f79, ABISELECT(864,584), "S1325C2.s1325c2f79");
    check_field_offset(lv, s1325c2f80, ABISELECT(872,588), "S1325C2.s1325c2f80");
    check_field_offset(lv, s1325c2f81, ABISELECT(888,600), "S1325C2.s1325c2f81");
    check_field_offset(lv, s1325c2f82, ABISELECT(896,604), "S1325C2.s1325c2f82");
    check_field_offset(lv, s1325c2f83, ABISELECT(912,616), "S1325C2.s1325c2f83");
    check_field_offset(lv, s1325c2f84, ABISELECT(920,620), "S1325C2.s1325c2f84");
    check_field_offset(lv, s1325c2f85, ABISELECT(936,632), "S1325C2.s1325c2f85");
    check_field_offset(lv, s1325c2f86, ABISELECT(944,636), "S1325C2.s1325c2f86");
    check_field_offset(lv, s1325c2f87, ABISELECT(960,648), "S1325C2.s1325c2f87");
    check_field_offset(lv, s1325c2f88, ABISELECT(968,652), "S1325C2.s1325c2f88");
    check_field_offset(lv, s1325c2f89, ABISELECT(976,656), "S1325C2.s1325c2f89");
    check_field_offset(lv, s1325c2f90, ABISELECT(992,668), "S1325C2.s1325c2f90");
    check_field_offset(lv, s1325c2f91, ABISELECT(1000,672), "S1325C2.s1325c2f91");
    check_field_offset(lv, s1325c2f92, ABISELECT(1016,684), "S1325C2.s1325c2f92");
    check_field_offset(lv, s1325c2f93, ABISELECT(1032,696), "S1325C2.s1325c2f93");
    check_field_offset(lv, s1325c2f94, ABISELECT(1048,704), "S1325C2.s1325c2f94");
    check_field_offset(lv, s1325c2f95, ABISELECT(1049,705), "S1325C2.s1325c2f95");
    check_field_offset(lv, s1325c2f96, ABISELECT(1050,706), "S1325C2.s1325c2f96");
    check_field_offset(lv, s1325c2f97, ABISELECT(1051,707), "S1325C2.s1325c2f97");
    check_field_offset(lv, s1325c2f98, ABISELECT(1052,708), "S1325C2.s1325c2f98");
    check_field_offset(lv, s1325c2f99, ABISELECT(1053,709), "S1325C2.s1325c2f99");
    check_field_offset(lv, s1325c2f100, ABISELECT(1054,710), "S1325C2.s1325c2f100");
    check_field_offset(lv, s1325c2f101, ABISELECT(1055,711), "S1325C2.s1325c2f101");
    check_field_offset(lv, s1325c2f102, ABISELECT(1056,712), "S1325C2.s1325c2f102");
    check_field_offset(lv, s1325c2f103, ABISELECT(1057,713), "S1325C2.s1325c2f103");
    check_field_offset(lv, s1325c2f104, ABISELECT(1058,714), "S1325C2.s1325c2f104");
    check_field_offset(lv, s1325c2f105, ABISELECT(1059,715), "S1325C2.s1325c2f105");
    check_field_offset(lv, s1325c2f106, ABISELECT(1060,716), "S1325C2.s1325c2f106");
    check_field_offset(lv, s1325c2f107, ABISELECT(1064,720), "S1325C2.s1325c2f107");
    check_field_offset(lv, s1325c2f108, ABISELECT(1080,732), "S1325C2.s1325c2f108");
    check_field_offset(lv, s1325c2f109, ABISELECT(1088,736), "S1325C2.s1325c2f109");
    check_field_offset(lv, s1325c2f110, ABISELECT(1104,748), "S1325C2.s1325c2f110");
    check_field_offset(lv, s1325c2f111, ABISELECT(1120,760), "S1325C2.s1325c2f111");
    check_field_offset(lv, s1325c2f112, ABISELECT(1168,808), "S1325C2.s1325c2f112");
    check_field_offset(lv, s1325c2f113, ABISELECT(1176,812), "S1325C2.s1325c2f113");
    check_field_offset(lv, s1325c2f114, ABISELECT(1192,824), "S1325C2.s1325c2f114");
    check_field_offset(lv, s1325c2f115, ABISELECT(1200,828), "S1325C2.s1325c2f115");
    check_field_offset(lv, s1325c2f116, ABISELECT(1216,840), "S1325C2.s1325c2f116");
    check_field_offset(lv, s1325c2f117, ABISELECT(1232,852), "S1325C2.s1325c2f117");
    test_class_info(&lv, &cd_S1325C2);
    dp->~S1325C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C2(Test_S1325C2, "S1325C2", ABISELECT(1240,856));

#else // __cplusplus

extern void _ZN7S1325C2C1Ev();
extern void _ZN7S1325C2D1Ev();
Name_Map name_map_S1325C2[] = {
  NSPAIR(_ZN7S1325C2C1Ev),
  NSPAIR(_ZN7S1325C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1325C4;
extern VTBL_ENTRY _ZTI7S1325C4[];
extern  VTBL_ENTRY _ZTV7S1325C4[];
extern Class_Descriptor cd_S1325C6;
extern VTBL_ENTRY _ZTI7S1325C6[];
extern  VTBL_ENTRY _ZTV7S1325C6[];
extern Class_Descriptor cd_S1325C3;
extern VTBL_ENTRY _ZTI7S1325C3[];
extern  VTBL_ENTRY _ZTV7S1325C3[];
static Base_Class bases_S1325C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1325C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1325C6,    ABISELECT(96,60), //bcp->offset
    106, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1325C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1325C2[];
extern void _ZN7S1325C2D1Ev();
extern void _ZN7S1325C2D0Ev();
extern void _ZN7S1325C43v18Ev();
extern void _ZN7S1325C43v19Ev();
extern void _ZN7S1325C43v20Ev();
extern void _ZN7S1325C43v21Ev();
extern void _ZN7S1325C43v22Ev();
extern void _ZN7S1325C43v23Ev();
extern void _ZN7S1325C43v24Ev();
extern void _ZN7S1325C43v25Ev();
extern void _ZN7S1325C43v26Ev();
extern void _ZN7S1325C43v27Ev();
extern void _ZN7S1325C43v28Ev();
extern void _ZN7S1325C43v29Ev();
extern void _ZN7S1325C43v30Ev();
extern void _ZN7S1325C43v31Ev();
extern void _ZN7S1325C43v32Ev();
extern void _ZN7S1325C43v33Ev();
extern void _ZN7S1325C43v34Ev();
extern void _ZN7S1325C43v35Ev();
extern void _ZN7S1325C43v36Ev();
extern void _ZN7S1325C43v37Ev();
extern void _ZN7S1325C43v38Ev();
extern void _ZN7S1325C43v39Ev();
extern void _ZN7S1325C43v40Ev();
extern void _ZN7S1325C43v41Ev();
extern void _ZN7S1325C43v42Ev();
extern void _ZN7S1325C43v43Ev();
extern void _ZN7S1325C43v44Ev();
extern void _ZN7S1325C43v45Ev();
extern void _ZN7S1325C43v46Ev();
extern void _ZN7S1325C43v47Ev();
extern void _ZN7S1325C43v48Ev();
extern void _ZN7S1325C43v49Ev();
extern void _ZN7S1325C43v50Ev();
extern void _ZN7S1325C43v51Ev();
extern void _ZN7S1325C43v52Ev();
extern void _ZN7S1325C43v53Ev();
extern void _ZN7S1325C43v54Ev();
extern void _ZN7S1325C43v55Ev();
extern void _ZN7S1325C43v56Ev();
extern void _ZN7S1325C43v57Ev();
extern void _ZN7S1325C43v58Ev();
extern void _ZN7S1325C43v59Ev();
extern void _ZN7S1325C43v60Ev();
extern void _ZN7S1325C43v61Ev();
extern void _ZN7S1325C43v62Ev();
extern void _ZN7S1325C43v63Ev();
extern void _ZN7S1325C43v64Ev();
extern void _ZN7S1325C43v65Ev();
extern void _ZN7S1325C43v66Ev();
extern void _ZN7S1325C43v67Ev();
extern void _ZN7S1325C43v68Ev();
extern void _ZN7S1325C43v69Ev();
extern void _ZN7S1325C43v70Ev();
extern void _ZN7S1325C43v71Ev();
extern void _ZN7S1325C43v72Ev();
extern void _ZN7S1325C43v73Ev();
extern void _ZN7S1325C43v74Ev();
extern void _ZN7S1325C43v75Ev();
extern void _ZN7S1325C43v76Ev();
extern void _ZN7S1325C43v77Ev();
extern void _ZN7S1325C43v78Ev();
extern void _ZN7S1325C43v79Ev();
extern void _ZN7S1325C43v80Ev();
extern void _ZN7S1325C43v81Ev();
extern void _ZN7S1325C33v83Ev();
extern void _ZN7S1325C33v84Ev();
extern void _ZN7S1325C33v85Ev();
extern void _ZN7S1325C33v86Ev();
extern void _ZN7S1325C23v87Ev();
extern void _ZN7S1325C23v88Ev();
extern void _ZN7S1325C23v89Ev();
extern void _ZN7S1325C23v90Ev();
extern void _ZN7S1325C23v91Ev();
extern void _ZN7S1325C23v92Ev();
extern void _ZN7S1325C23v93Ev();
extern void _ZN7S1325C23v94Ev();
extern void _ZN7S1325C23v95Ev();
extern void _ZN7S1325C23v96Ev();
extern void _ZN7S1325C23v97Ev();
extern void _ZN7S1325C23v98Ev();
extern void _ZN7S1325C23v99Ev();
extern void _ZN7S1325C24v100Ev();
extern void _ZN7S1325C24v101Ev();
extern void _ZN7S1325C24v102Ev();
extern void _ZN7S1325C24v103Ev();
extern void _ZN7S1325C24v104Ev();
extern void _ZN7S1325C24v105Ev();
extern void _ZN7S1325C24v106Ev();
extern void _ZN7S1325C24v107Ev();
extern void _ZN7S1325C24v108Ev();
extern void _ZN7S1325C24v109Ev();
extern void _ZN7S1325C24v110Ev();
extern void _ZN7S1325C24v111Ev();
extern void _ZN7S1325C24v112Ev();
extern void _ZN7S1325C24v113Ev();
extern void _ZN7S1325C24v114Ev();
extern void _ZN7S1325C24v115Ev();
extern void _ZN7S1325C24v116Ev();
extern void _ZN7S1325C24v117Ev();
extern void _ZN7S1325C24v118Ev();
extern void _ZN7S1325C24v119Ev();
extern void _ZN7S1325C24v120Ev();
extern void _ZN7S1325C63v82Ev();
static  VTBL_ENTRY vtc_S1325C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1325C2[0]),
  (VTBL_ENTRY)&_ZN7S1325C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1325C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v112Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v113Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v114Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v115Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v116Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v117Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v118Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v119Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v120Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1325C2[0]),
  (VTBL_ENTRY)&_ZN7S1325C63v82Ev,
};
extern VTBL_ENTRY _ZTI7S1325C2[];
extern  VTBL_ENTRY _ZTV7S1325C2[];
Class_Descriptor cd_S1325C2 = {  "S1325C2", // class name
  bases_S1325C2, 3,
  &(vtc_S1325C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1240,856), // object size
  NSPAIRA(_ZTI7S1325C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1325C2),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C21  {
  ::S1325C8 s1325c21f0;
  ::S1325C8 s1325c21f1;
  int s1325c21f2;
  ::S1325C8 s1325c21f3;
  ::S1325C14 s1325c21f4;
  ::S1325C8 s1325c21f5;
  int s1325c21f6;
  void  mf1325c21(); // _ZN8S1325C219mf1325c21Ev
};
//SIG(-1 S1325C21) C1{ m FC2{ BC3{ BC4{ m Fp Fi[2]}}} FC2 Fi FC2 FC5{ BC4} FC2 Fi}


void  S1325C21 ::mf1325c21(){}

static void Test_S1325C21()
{
  {
    init_simple_test("S1325C21");
    S1325C21 lv;
    check2(sizeof(lv), ABISELECT(96,68), "sizeof(S1325C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C21)");
    check_field_offset(lv, s1325c21f0, 0, "S1325C21.s1325c21f0");
    check_field_offset(lv, s1325c21f1, ABISELECT(16,12), "S1325C21.s1325c21f1");
    check_field_offset(lv, s1325c21f2, ABISELECT(32,24), "S1325C21.s1325c21f2");
    check_field_offset(lv, s1325c21f3, ABISELECT(40,28), "S1325C21.s1325c21f3");
    check_field_offset(lv, s1325c21f4, ABISELECT(56,40), "S1325C21.s1325c21f4");
    check_field_offset(lv, s1325c21f5, ABISELECT(72,52), "S1325C21.s1325c21f5");
    check_field_offset(lv, s1325c21f6, ABISELECT(88,64), "S1325C21.s1325c21f6");
  }
}
static Arrange_To_Call_Me vS1325C21(Test_S1325C21, "S1325C21", ABISELECT(96,68));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C23  : S1537C8_nt {
};
//SIG(-1 S1325C23) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1325C23()
{
  extern Class_Descriptor cd_S1325C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1325C23, buf);
    S1325C23 &lv = *(new (buf) S1325C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1325C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C23)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1325C23");
    test_class_info(&lv, &cd_S1325C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C23(Test_S1325C23, "S1325C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1325C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1325C23 = {  "S1325C23", // class name
  bases_S1325C23, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C22  : S1325C23 {
};
//SIG(-1 S1325C22) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1325C22()
{
  extern Class_Descriptor cd_S1325C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1325C22, buf);
    S1325C22 &lv = *(new (buf) S1325C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1325C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C22)");
    check_base_class_offset(lv, (S1537C8_nt*)(S1325C23*), 0, "S1325C22");
    check_base_class_offset(lv, (S1325C23*), 0, "S1325C22");
    test_class_info(&lv, &cd_S1325C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C22(Test_S1325C22, "S1325C22", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1325C23;
static Base_Class bases_S1325C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1325C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1325C22 = {  "S1325C22", // class name
  bases_S1325C22, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C27  : S1537C8_nt {
};
//SIG(-1 S1325C27) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1325C27()
{
  extern Class_Descriptor cd_S1325C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1325C27, buf);
    S1325C27 &lv = *(new (buf) S1325C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1325C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C27)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1325C27");
    test_class_info(&lv, &cd_S1325C27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C27(Test_S1325C27, "S1325C27", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1325C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1325C27 = {  "S1325C27", // class name
  bases_S1325C27, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C26  : S1325C27 {
};
//SIG(-1 S1325C26) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1325C26()
{
  extern Class_Descriptor cd_S1325C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1325C26, buf);
    S1325C26 &lv = *(new (buf) S1325C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1325C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C26)");
    check_base_class_offset(lv, (S1537C8_nt*)(S1325C27*), 0, "S1325C26");
    check_base_class_offset(lv, (S1325C27*), 0, "S1325C26");
    test_class_info(&lv, &cd_S1325C26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C26(Test_S1325C26, "S1325C26", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1325C27;
static Base_Class bases_S1325C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1325C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1325C26 = {  "S1325C26", // class name
  bases_S1325C26, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C31  : S1537C8_nt {
};
//SIG(-1 S1325C31) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1325C31()
{
  extern Class_Descriptor cd_S1325C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1325C31, buf);
    S1325C31 &lv = *(new (buf) S1325C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1325C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C31)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1325C31");
    test_class_info(&lv, &cd_S1325C31);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C31(Test_S1325C31, "S1325C31", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1325C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1325C31 = {  "S1325C31", // class name
  bases_S1325C31, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C30  : S1325C31 {
};
//SIG(-1 S1325C30) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1325C30()
{
  extern Class_Descriptor cd_S1325C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1325C30, buf);
    S1325C30 &lv = *(new (buf) S1325C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1325C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C30)");
    check_base_class_offset(lv, (S1537C8_nt*)(S1325C31*), 0, "S1325C30");
    check_base_class_offset(lv, (S1325C31*), 0, "S1325C30");
    test_class_info(&lv, &cd_S1325C30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C30(Test_S1325C30, "S1325C30", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1325C31;
static Base_Class bases_S1325C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1325C31,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1325C30 = {  "S1325C30", // class name
  bases_S1325C30, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1325C1  : S1325C2 {
  void *s1325c1f0;
  ::S1325C21 s1325c1f1;
  ::S1325C21 s1325c1f2;
  ::S1537C18 s1325c1f3;
  ::S1325C7_nt s1325c1f4;
  char s1325c1f5;
  void *s1325c1f6;
  ::S1325C22 s1325c1f7;
  ::S1325C22 s1325c1f8;
  ::S1325C7_nt s1325c1f9;
  unsigned int s1325c1f10:1;
  unsigned int s1325c1f11:1;
  unsigned int s1325c1f12:1;
  unsigned int s1325c1f13:1;
  unsigned int s1325c1f14:1;
  int s1325c1f15[2];
  ::S1325C26 s1325c1f16;
  ::S1325C26 s1325c1f17;
  ::S1325C30 s1325c1f18;
  virtual  ~S1325C1(); // _ZN7S1325C1D1Ev
  virtual void  v1(); // _ZN7S1325C12v1Ev
  virtual void  v2(); // _ZN7S1325C12v2Ev
  virtual void  v3(); // _ZN7S1325C12v3Ev
  virtual void  v4(); // _ZN7S1325C12v4Ev
  virtual void  v5(); // _ZN7S1325C12v5Ev
  virtual void  v6(); // _ZN7S1325C12v6Ev
  virtual void  v7(); // _ZN7S1325C12v7Ev
  virtual void  v8(); // _ZN7S1325C12v8Ev
  virtual void  v9(); // _ZN7S1325C12v9Ev
  virtual void  v10(); // _ZN7S1325C13v10Ev
  virtual void  v11(); // _ZN7S1325C13v11Ev
  virtual void  v12(); // _ZN7S1325C13v12Ev
  virtual void  v13(); // _ZN7S1325C13v13Ev
  virtual void  v14(); // _ZN7S1325C13v14Ev
  virtual void  v15(); // _ZN7S1325C13v15Ev
  virtual void  v16(); // _ZN7S1325C13v16Ev
  virtual void  v17(); // _ZN7S1325C13v17Ev
  S1325C1(); // tgen
};
//SIG(1 S1325C1) C1{ BC2{ BC3{ BC4{ vd v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v82} vd v83 v84 v85 v86} vd v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 Fp FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} Fp FC7 Fp FC7 Fp FC7 FC11{ BC12{ BC10}} FC13{ BC14{ BC10}} Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 FC15{ BC16{ BC10}} FC15 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] Fp FC7 Fp FC7 Fp FC7 Fi[3] Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fp FC7 Fi Fp FC12 Fp FC17{ BC10} Fi[3] Fp[2] FC18{ m} FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18 FC18 Fi FC7 Fc FC7 FC7 Fi[12] Fp FC7 Fi FC19{ BC20{ BC10}} FC7 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fp FC21{ m FC8 FC8 Fi FC8 FC17 FC8 Fi} FC21 FC13 FC7 Fc Fp FC22{ BC23{ BC10}} FC22 FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] FC24{ BC25{ BC10}} FC24 FC26{ BC27{ BC10}}}


 S1325C1 ::~S1325C1(){ note_dtor("S1325C1", this);}
void  S1325C1 ::v1(){vfunc_called(this, "_ZN7S1325C12v1Ev");}
void  S1325C1 ::v2(){vfunc_called(this, "_ZN7S1325C12v2Ev");}
void  S1325C1 ::v3(){vfunc_called(this, "_ZN7S1325C12v3Ev");}
void  S1325C1 ::v4(){vfunc_called(this, "_ZN7S1325C12v4Ev");}
void  S1325C1 ::v5(){vfunc_called(this, "_ZN7S1325C12v5Ev");}
void  S1325C1 ::v6(){vfunc_called(this, "_ZN7S1325C12v6Ev");}
void  S1325C1 ::v7(){vfunc_called(this, "_ZN7S1325C12v7Ev");}
void  S1325C1 ::v8(){vfunc_called(this, "_ZN7S1325C12v8Ev");}
void  S1325C1 ::v9(){vfunc_called(this, "_ZN7S1325C12v9Ev");}
void  S1325C1 ::v10(){vfunc_called(this, "_ZN7S1325C13v10Ev");}
void  S1325C1 ::v11(){vfunc_called(this, "_ZN7S1325C13v11Ev");}
void  S1325C1 ::v12(){vfunc_called(this, "_ZN7S1325C13v12Ev");}
void  S1325C1 ::v13(){vfunc_called(this, "_ZN7S1325C13v13Ev");}
void  S1325C1 ::v14(){vfunc_called(this, "_ZN7S1325C13v14Ev");}
void  S1325C1 ::v15(){vfunc_called(this, "_ZN7S1325C13v15Ev");}
void  S1325C1 ::v16(){vfunc_called(this, "_ZN7S1325C13v16Ev");}
void  S1325C1 ::v17(){vfunc_called(this, "_ZN7S1325C13v17Ev");}
S1325C1 ::S1325C1(){ note_ctor("S1325C1", this);} // tgen

static void Test_S1325C1()
{
  extern Class_Descriptor cd_S1325C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(201,279)];
    init_test(&cd_S1325C1, buf);
    S1325C1 *dp, &lv = *(dp=new (buf) S1325C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1600,1112), "sizeof(S1325C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1325C1)");
    check_base_class_offset(lv, (S1325C4*)(S1325C3*)(S1325C2*), 0, "S1325C1");
    check_base_class_offset(lv, (S1325C6*)(S1325C3*)(S1325C2*), ABISELECT(96,60), "S1325C1");
    check_base_class_offset(lv, (S1325C3*)(S1325C2*), 0, "S1325C1");
    check_base_class_offset(lv, (S1325C2*), 0, "S1325C1");
    check_field_offset(lv, s1325c1f0, ABISELECT(1240,856), "S1325C1.s1325c1f0");
    check_field_offset(lv, s1325c1f1, ABISELECT(1248,860), "S1325C1.s1325c1f1");
    check_field_offset(lv, s1325c1f2, ABISELECT(1344,928), "S1325C1.s1325c1f2");
    check_field_offset(lv, s1325c1f3, ABISELECT(1440,996), "S1325C1.s1325c1f3");
    check_field_offset(lv, s1325c1f4, ABISELECT(1456,1008), "S1325C1.s1325c1f4");
    check_field_offset(lv, s1325c1f5, ABISELECT(1472,1020), "S1325C1.s1325c1f5");
    check_field_offset(lv, s1325c1f6, ABISELECT(1480,1024), "S1325C1.s1325c1f6");
    check_field_offset(lv, s1325c1f7, ABISELECT(1488,1028), "S1325C1.s1325c1f7");
    check_field_offset(lv, s1325c1f8, ABISELECT(1504,1040), "S1325C1.s1325c1f8");
    check_field_offset(lv, s1325c1f9, ABISELECT(1520,1052), "S1325C1.s1325c1f9");
    set_bf_and_test(lv, s1325c1f10, ABISELECT(1536,1064), 0, 1, 1, "S1325C1");
    set_bf_and_test(lv, s1325c1f11, ABISELECT(1536,1064), 1, 1, 1, "S1325C1");
    set_bf_and_test(lv, s1325c1f12, ABISELECT(1536,1064), 2, 1, 1, "S1325C1");
    set_bf_and_test(lv, s1325c1f13, ABISELECT(1536,1064), 3, 1, 1, "S1325C1");
    set_bf_and_test(lv, s1325c1f14, ABISELECT(1536,1064), 4, 1, 1, "S1325C1");
    check_field_offset(lv, s1325c1f15, ABISELECT(1540,1068), "S1325C1.s1325c1f15");
    check_field_offset(lv, s1325c1f16, ABISELECT(1552,1076), "S1325C1.s1325c1f16");
    check_field_offset(lv, s1325c1f17, ABISELECT(1568,1088), "S1325C1.s1325c1f17");
    check_field_offset(lv, s1325c1f18, ABISELECT(1584,1100), "S1325C1.s1325c1f18");
    test_class_info(&lv, &cd_S1325C1);
    dp->~S1325C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1325C1(Test_S1325C1, "S1325C1", ABISELECT(1600,1112));

#else // __cplusplus

extern void _ZN7S1325C1C1Ev();
extern void _ZN7S1325C1D1Ev();
Name_Map name_map_S1325C1[] = {
  NSPAIR(_ZN7S1325C1C1Ev),
  NSPAIR(_ZN7S1325C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1325C4;
extern VTBL_ENTRY _ZTI7S1325C4[];
extern  VTBL_ENTRY _ZTV7S1325C4[];
extern Class_Descriptor cd_S1325C6;
extern VTBL_ENTRY _ZTI7S1325C6[];
extern  VTBL_ENTRY _ZTV7S1325C6[];
extern Class_Descriptor cd_S1325C3;
extern VTBL_ENTRY _ZTI7S1325C3[];
extern  VTBL_ENTRY _ZTV7S1325C3[];
extern Class_Descriptor cd_S1325C2;
extern VTBL_ENTRY _ZTI7S1325C2[];
extern  VTBL_ENTRY _ZTV7S1325C2[];
static Base_Class bases_S1325C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1325C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1325C6,    ABISELECT(96,60), //bcp->offset
    123, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1325C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1325C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1325C1[];
extern void _ZN7S1325C1D1Ev();
extern void _ZN7S1325C1D0Ev();
extern void _ZN7S1325C43v18Ev();
extern void _ZN7S1325C43v19Ev();
extern void _ZN7S1325C43v20Ev();
extern void _ZN7S1325C43v21Ev();
extern void _ZN7S1325C43v22Ev();
extern void _ZN7S1325C43v23Ev();
extern void _ZN7S1325C43v24Ev();
extern void _ZN7S1325C43v25Ev();
extern void _ZN7S1325C43v26Ev();
extern void _ZN7S1325C43v27Ev();
extern void _ZN7S1325C43v28Ev();
extern void _ZN7S1325C43v29Ev();
extern void _ZN7S1325C43v30Ev();
extern void _ZN7S1325C43v31Ev();
extern void _ZN7S1325C43v32Ev();
extern void _ZN7S1325C43v33Ev();
extern void _ZN7S1325C43v34Ev();
extern void _ZN7S1325C43v35Ev();
extern void _ZN7S1325C43v36Ev();
extern void _ZN7S1325C43v37Ev();
extern void _ZN7S1325C43v38Ev();
extern void _ZN7S1325C43v39Ev();
extern void _ZN7S1325C43v40Ev();
extern void _ZN7S1325C43v41Ev();
extern void _ZN7S1325C43v42Ev();
extern void _ZN7S1325C43v43Ev();
extern void _ZN7S1325C43v44Ev();
extern void _ZN7S1325C43v45Ev();
extern void _ZN7S1325C43v46Ev();
extern void _ZN7S1325C43v47Ev();
extern void _ZN7S1325C43v48Ev();
extern void _ZN7S1325C43v49Ev();
extern void _ZN7S1325C43v50Ev();
extern void _ZN7S1325C43v51Ev();
extern void _ZN7S1325C43v52Ev();
extern void _ZN7S1325C43v53Ev();
extern void _ZN7S1325C43v54Ev();
extern void _ZN7S1325C43v55Ev();
extern void _ZN7S1325C43v56Ev();
extern void _ZN7S1325C43v57Ev();
extern void _ZN7S1325C43v58Ev();
extern void _ZN7S1325C43v59Ev();
extern void _ZN7S1325C43v60Ev();
extern void _ZN7S1325C43v61Ev();
extern void _ZN7S1325C43v62Ev();
extern void _ZN7S1325C43v63Ev();
extern void _ZN7S1325C43v64Ev();
extern void _ZN7S1325C43v65Ev();
extern void _ZN7S1325C43v66Ev();
extern void _ZN7S1325C43v67Ev();
extern void _ZN7S1325C43v68Ev();
extern void _ZN7S1325C43v69Ev();
extern void _ZN7S1325C43v70Ev();
extern void _ZN7S1325C43v71Ev();
extern void _ZN7S1325C43v72Ev();
extern void _ZN7S1325C43v73Ev();
extern void _ZN7S1325C43v74Ev();
extern void _ZN7S1325C43v75Ev();
extern void _ZN7S1325C43v76Ev();
extern void _ZN7S1325C43v77Ev();
extern void _ZN7S1325C43v78Ev();
extern void _ZN7S1325C43v79Ev();
extern void _ZN7S1325C43v80Ev();
extern void _ZN7S1325C43v81Ev();
extern void _ZN7S1325C33v83Ev();
extern void _ZN7S1325C33v84Ev();
extern void _ZN7S1325C33v85Ev();
extern void _ZN7S1325C33v86Ev();
extern void _ZN7S1325C23v87Ev();
extern void _ZN7S1325C23v88Ev();
extern void _ZN7S1325C23v89Ev();
extern void _ZN7S1325C23v90Ev();
extern void _ZN7S1325C23v91Ev();
extern void _ZN7S1325C23v92Ev();
extern void _ZN7S1325C23v93Ev();
extern void _ZN7S1325C23v94Ev();
extern void _ZN7S1325C23v95Ev();
extern void _ZN7S1325C23v96Ev();
extern void _ZN7S1325C23v97Ev();
extern void _ZN7S1325C23v98Ev();
extern void _ZN7S1325C23v99Ev();
extern void _ZN7S1325C24v100Ev();
extern void _ZN7S1325C24v101Ev();
extern void _ZN7S1325C24v102Ev();
extern void _ZN7S1325C24v103Ev();
extern void _ZN7S1325C24v104Ev();
extern void _ZN7S1325C24v105Ev();
extern void _ZN7S1325C24v106Ev();
extern void _ZN7S1325C24v107Ev();
extern void _ZN7S1325C24v108Ev();
extern void _ZN7S1325C24v109Ev();
extern void _ZN7S1325C24v110Ev();
extern void _ZN7S1325C24v111Ev();
extern void _ZN7S1325C24v112Ev();
extern void _ZN7S1325C24v113Ev();
extern void _ZN7S1325C24v114Ev();
extern void _ZN7S1325C24v115Ev();
extern void _ZN7S1325C24v116Ev();
extern void _ZN7S1325C24v117Ev();
extern void _ZN7S1325C24v118Ev();
extern void _ZN7S1325C24v119Ev();
extern void _ZN7S1325C24v120Ev();
extern void _ZN7S1325C12v1Ev();
extern void _ZN7S1325C12v2Ev();
extern void _ZN7S1325C12v3Ev();
extern void _ZN7S1325C12v4Ev();
extern void _ZN7S1325C12v5Ev();
extern void _ZN7S1325C12v6Ev();
extern void _ZN7S1325C12v7Ev();
extern void _ZN7S1325C12v8Ev();
extern void _ZN7S1325C12v9Ev();
extern void _ZN7S1325C13v10Ev();
extern void _ZN7S1325C13v11Ev();
extern void _ZN7S1325C13v12Ev();
extern void _ZN7S1325C13v13Ev();
extern void _ZN7S1325C13v14Ev();
extern void _ZN7S1325C13v15Ev();
extern void _ZN7S1325C13v16Ev();
extern void _ZN7S1325C13v17Ev();
extern void _ZN7S1325C63v82Ev();
static  VTBL_ENTRY vtc_S1325C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1325C1[0]),
  (VTBL_ENTRY)&_ZN7S1325C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1325C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1325C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1325C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1325C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v112Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v113Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v114Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v115Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v116Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v117Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v118Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v119Ev,
  (VTBL_ENTRY)&_ZN7S1325C24v120Ev,
  (VTBL_ENTRY)&_ZN7S1325C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1325C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1325C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1325C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1325C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1325C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1325C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1325C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1325C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1325C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1325C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1325C13v12Ev,
  (VTBL_ENTRY)&_ZN7S1325C13v13Ev,
  (VTBL_ENTRY)&_ZN7S1325C13v14Ev,
  (VTBL_ENTRY)&_ZN7S1325C13v15Ev,
  (VTBL_ENTRY)&_ZN7S1325C13v16Ev,
  (VTBL_ENTRY)&_ZN7S1325C13v17Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1325C1[0]),
  (VTBL_ENTRY)&_ZN7S1325C63v82Ev,
};
extern VTBL_ENTRY _ZTI7S1325C1[];
extern  VTBL_ENTRY _ZTV7S1325C1[];
Class_Descriptor cd_S1325C1 = {  "S1325C1", // class name
  bases_S1325C1, 4,
  &(vtc_S1325C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1600,1112), // object size
  NSPAIRA(_ZTI7S1325C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1325C1),126, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C4  {
  int s1566c4f0;
  __tsi64 s1566c4f1;
  void *s1566c4f2[4];
  int s1566c4f3[2];
  void *s1566c4f4;
  ::S1537C5_nt s1566c4f5;
  void *s1566c4f6[2];
  virtual  ~S1566C4(); // _ZN7S1566C4D1Ev
  virtual void  v8(); // _ZN7S1566C42v8Ev
  virtual void  v9(); // _ZN7S1566C42v9Ev
  virtual void  v10(); // _ZN7S1566C43v10Ev
  virtual void  v11(); // _ZN7S1566C43v11Ev
  virtual void  v12(); // _ZN7S1566C43v12Ev
  virtual void  v13(); // _ZN7S1566C43v13Ev
  virtual void  v14(); // _ZN7S1566C43v14Ev
  virtual void  v15(); // _ZN7S1566C43v15Ev
  virtual void  v16(); // _ZN7S1566C43v16Ev
  virtual void  v17(); // _ZN7S1566C43v17Ev
  virtual void  v18(); // _ZN7S1566C43v18Ev
  virtual void  v19(); // _ZN7S1566C43v19Ev
  virtual void  v20(); // _ZN7S1566C43v20Ev
  virtual void  v21(); // _ZN7S1566C43v21Ev
  virtual void  v22(); // _ZN7S1566C43v22Ev
  virtual void  v23(); // _ZN7S1566C43v23Ev
  virtual void  v24(); // _ZN7S1566C43v24Ev
  virtual void  v25(); // _ZN7S1566C43v25Ev
  virtual void  v26(); // _ZN7S1566C43v26Ev
  virtual void  v27(); // _ZN7S1566C43v27Ev
  virtual void  v28(); // _ZN7S1566C43v28Ev
  virtual void  v29(); // _ZN7S1566C43v29Ev
  virtual void  v30(); // _ZN7S1566C43v30Ev
  virtual void  v31(); // _ZN7S1566C43v31Ev
  virtual void  v32(); // _ZN7S1566C43v32Ev
  virtual void  v33(); // _ZN7S1566C43v33Ev
  virtual void  v34(); // _ZN7S1566C43v34Ev
  virtual void  v35(); // _ZN7S1566C43v35Ev
  virtual void  v36(); // _ZN7S1566C43v36Ev
  virtual void  v37(); // _ZN7S1566C43v37Ev
  virtual void  v38(); // _ZN7S1566C43v38Ev
  virtual void  v39(); // _ZN7S1566C43v39Ev
  virtual void  v40(); // _ZN7S1566C43v40Ev
  virtual void  v41(); // _ZN7S1566C43v41Ev
  virtual void  v42(); // _ZN7S1566C43v42Ev
  virtual void  v43(); // _ZN7S1566C43v43Ev
  virtual void  v44(); // _ZN7S1566C43v44Ev
  virtual void  v45(); // _ZN7S1566C43v45Ev
  virtual void  v46(); // _ZN7S1566C43v46Ev
  virtual void  v47(); // _ZN7S1566C43v47Ev
  virtual void  v48(); // _ZN7S1566C43v48Ev
  virtual void  v49(); // _ZN7S1566C43v49Ev
  virtual void  v50(); // _ZN7S1566C43v50Ev
  virtual void  v51(); // _ZN7S1566C43v51Ev
  virtual void  v52(); // _ZN7S1566C43v52Ev
  virtual void  v53(); // _ZN7S1566C43v53Ev
  virtual void  v54(); // _ZN7S1566C43v54Ev
  virtual void  v55(); // _ZN7S1566C43v55Ev
  virtual void  v56(); // _ZN7S1566C43v56Ev
  virtual void  v57(); // _ZN7S1566C43v57Ev
  virtual void  v58(); // _ZN7S1566C43v58Ev
  virtual void  v59(); // _ZN7S1566C43v59Ev
  virtual void  v60(); // _ZN7S1566C43v60Ev
  virtual void  v61(); // _ZN7S1566C43v61Ev
  virtual void  v62(); // _ZN7S1566C43v62Ev
  virtual void  v63(); // _ZN7S1566C43v63Ev
  virtual void  v64(); // _ZN7S1566C43v64Ev
  virtual void  v65(); // _ZN7S1566C43v65Ev
  virtual void  v66(); // _ZN7S1566C43v66Ev
  virtual void  v67(); // _ZN7S1566C43v67Ev
  virtual void  v68(); // _ZN7S1566C43v68Ev
  virtual void  v69(); // _ZN7S1566C43v69Ev
  virtual void  v70(); // _ZN7S1566C43v70Ev
  virtual void  v71(); // _ZN7S1566C43v71Ev
  S1566C4(); // tgen
};
//SIG(-1 S1566C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1566C4 ::~S1566C4(){ note_dtor("S1566C4", this);}
void  S1566C4 ::v8(){vfunc_called(this, "_ZN7S1566C42v8Ev");}
void  S1566C4 ::v9(){vfunc_called(this, "_ZN7S1566C42v9Ev");}
void  S1566C4 ::v10(){vfunc_called(this, "_ZN7S1566C43v10Ev");}
void  S1566C4 ::v11(){vfunc_called(this, "_ZN7S1566C43v11Ev");}
void  S1566C4 ::v12(){vfunc_called(this, "_ZN7S1566C43v12Ev");}
void  S1566C4 ::v13(){vfunc_called(this, "_ZN7S1566C43v13Ev");}
void  S1566C4 ::v14(){vfunc_called(this, "_ZN7S1566C43v14Ev");}
void  S1566C4 ::v15(){vfunc_called(this, "_ZN7S1566C43v15Ev");}
void  S1566C4 ::v16(){vfunc_called(this, "_ZN7S1566C43v16Ev");}
void  S1566C4 ::v17(){vfunc_called(this, "_ZN7S1566C43v17Ev");}
void  S1566C4 ::v18(){vfunc_called(this, "_ZN7S1566C43v18Ev");}
void  S1566C4 ::v19(){vfunc_called(this, "_ZN7S1566C43v19Ev");}
void  S1566C4 ::v20(){vfunc_called(this, "_ZN7S1566C43v20Ev");}
void  S1566C4 ::v21(){vfunc_called(this, "_ZN7S1566C43v21Ev");}
void  S1566C4 ::v22(){vfunc_called(this, "_ZN7S1566C43v22Ev");}
void  S1566C4 ::v23(){vfunc_called(this, "_ZN7S1566C43v23Ev");}
void  S1566C4 ::v24(){vfunc_called(this, "_ZN7S1566C43v24Ev");}
void  S1566C4 ::v25(){vfunc_called(this, "_ZN7S1566C43v25Ev");}
void  S1566C4 ::v26(){vfunc_called(this, "_ZN7S1566C43v26Ev");}
void  S1566C4 ::v27(){vfunc_called(this, "_ZN7S1566C43v27Ev");}
void  S1566C4 ::v28(){vfunc_called(this, "_ZN7S1566C43v28Ev");}
void  S1566C4 ::v29(){vfunc_called(this, "_ZN7S1566C43v29Ev");}
void  S1566C4 ::v30(){vfunc_called(this, "_ZN7S1566C43v30Ev");}
void  S1566C4 ::v31(){vfunc_called(this, "_ZN7S1566C43v31Ev");}
void  S1566C4 ::v32(){vfunc_called(this, "_ZN7S1566C43v32Ev");}
void  S1566C4 ::v33(){vfunc_called(this, "_ZN7S1566C43v33Ev");}
void  S1566C4 ::v34(){vfunc_called(this, "_ZN7S1566C43v34Ev");}
void  S1566C4 ::v35(){vfunc_called(this, "_ZN7S1566C43v35Ev");}
void  S1566C4 ::v36(){vfunc_called(this, "_ZN7S1566C43v36Ev");}
void  S1566C4 ::v37(){vfunc_called(this, "_ZN7S1566C43v37Ev");}
void  S1566C4 ::v38(){vfunc_called(this, "_ZN7S1566C43v38Ev");}
void  S1566C4 ::v39(){vfunc_called(this, "_ZN7S1566C43v39Ev");}
void  S1566C4 ::v40(){vfunc_called(this, "_ZN7S1566C43v40Ev");}
void  S1566C4 ::v41(){vfunc_called(this, "_ZN7S1566C43v41Ev");}
void  S1566C4 ::v42(){vfunc_called(this, "_ZN7S1566C43v42Ev");}
void  S1566C4 ::v43(){vfunc_called(this, "_ZN7S1566C43v43Ev");}
void  S1566C4 ::v44(){vfunc_called(this, "_ZN7S1566C43v44Ev");}
void  S1566C4 ::v45(){vfunc_called(this, "_ZN7S1566C43v45Ev");}
void  S1566C4 ::v46(){vfunc_called(this, "_ZN7S1566C43v46Ev");}
void  S1566C4 ::v47(){vfunc_called(this, "_ZN7S1566C43v47Ev");}
void  S1566C4 ::v48(){vfunc_called(this, "_ZN7S1566C43v48Ev");}
void  S1566C4 ::v49(){vfunc_called(this, "_ZN7S1566C43v49Ev");}
void  S1566C4 ::v50(){vfunc_called(this, "_ZN7S1566C43v50Ev");}
void  S1566C4 ::v51(){vfunc_called(this, "_ZN7S1566C43v51Ev");}
void  S1566C4 ::v52(){vfunc_called(this, "_ZN7S1566C43v52Ev");}
void  S1566C4 ::v53(){vfunc_called(this, "_ZN7S1566C43v53Ev");}
void  S1566C4 ::v54(){vfunc_called(this, "_ZN7S1566C43v54Ev");}
void  S1566C4 ::v55(){vfunc_called(this, "_ZN7S1566C43v55Ev");}
void  S1566C4 ::v56(){vfunc_called(this, "_ZN7S1566C43v56Ev");}
void  S1566C4 ::v57(){vfunc_called(this, "_ZN7S1566C43v57Ev");}
void  S1566C4 ::v58(){vfunc_called(this, "_ZN7S1566C43v58Ev");}
void  S1566C4 ::v59(){vfunc_called(this, "_ZN7S1566C43v59Ev");}
void  S1566C4 ::v60(){vfunc_called(this, "_ZN7S1566C43v60Ev");}
void  S1566C4 ::v61(){vfunc_called(this, "_ZN7S1566C43v61Ev");}
void  S1566C4 ::v62(){vfunc_called(this, "_ZN7S1566C43v62Ev");}
void  S1566C4 ::v63(){vfunc_called(this, "_ZN7S1566C43v63Ev");}
void  S1566C4 ::v64(){vfunc_called(this, "_ZN7S1566C43v64Ev");}
void  S1566C4 ::v65(){vfunc_called(this, "_ZN7S1566C43v65Ev");}
void  S1566C4 ::v66(){vfunc_called(this, "_ZN7S1566C43v66Ev");}
void  S1566C4 ::v67(){vfunc_called(this, "_ZN7S1566C43v67Ev");}
void  S1566C4 ::v68(){vfunc_called(this, "_ZN7S1566C43v68Ev");}
void  S1566C4 ::v69(){vfunc_called(this, "_ZN7S1566C43v69Ev");}
void  S1566C4 ::v70(){vfunc_called(this, "_ZN7S1566C43v70Ev");}
void  S1566C4 ::v71(){vfunc_called(this, "_ZN7S1566C43v71Ev");}
S1566C4 ::S1566C4(){ note_ctor("S1566C4", this);} // tgen

static void Test_S1566C4()
{
  extern Class_Descriptor cd_S1566C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1566C4, buf);
    S1566C4 *dp, &lv = *(dp=new (buf) S1566C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1566C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C4)");
    check_field_offset(lv, s1566c4f0, ABISELECT(8,4), "S1566C4.s1566c4f0");
    check_field_offset(lv, s1566c4f1, ABISELECT(16,8), "S1566C4.s1566c4f1");
    check_field_offset(lv, s1566c4f2, ABISELECT(24,16), "S1566C4.s1566c4f2");
    check_field_offset(lv, s1566c4f3, ABISELECT(56,32), "S1566C4.s1566c4f3");
    check_field_offset(lv, s1566c4f4, ABISELECT(64,40), "S1566C4.s1566c4f4");
    check_field_offset(lv, s1566c4f5, ABISELECT(72,44), "S1566C4.s1566c4f5");
    check_field_offset(lv, s1566c4f6, ABISELECT(80,52), "S1566C4.s1566c4f6");
    test_class_info(&lv, &cd_S1566C4);
    dp->~S1566C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C4(Test_S1566C4, "S1566C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1566C4C1Ev();
extern void _ZN7S1566C4D1Ev();
Name_Map name_map_S1566C4[] = {
  NSPAIR(_ZN7S1566C4C1Ev),
  NSPAIR(_ZN7S1566C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1566C4[];
extern void _ZN7S1566C4D1Ev();
extern void _ZN7S1566C4D0Ev();
extern void _ZN7S1566C42v8Ev();
extern void _ZN7S1566C42v9Ev();
extern void _ZN7S1566C43v10Ev();
extern void _ZN7S1566C43v11Ev();
extern void _ZN7S1566C43v12Ev();
extern void _ZN7S1566C43v13Ev();
extern void _ZN7S1566C43v14Ev();
extern void _ZN7S1566C43v15Ev();
extern void _ZN7S1566C43v16Ev();
extern void _ZN7S1566C43v17Ev();
extern void _ZN7S1566C43v18Ev();
extern void _ZN7S1566C43v19Ev();
extern void _ZN7S1566C43v20Ev();
extern void _ZN7S1566C43v21Ev();
extern void _ZN7S1566C43v22Ev();
extern void _ZN7S1566C43v23Ev();
extern void _ZN7S1566C43v24Ev();
extern void _ZN7S1566C43v25Ev();
extern void _ZN7S1566C43v26Ev();
extern void _ZN7S1566C43v27Ev();
extern void _ZN7S1566C43v28Ev();
extern void _ZN7S1566C43v29Ev();
extern void _ZN7S1566C43v30Ev();
extern void _ZN7S1566C43v31Ev();
extern void _ZN7S1566C43v32Ev();
extern void _ZN7S1566C43v33Ev();
extern void _ZN7S1566C43v34Ev();
extern void _ZN7S1566C43v35Ev();
extern void _ZN7S1566C43v36Ev();
extern void _ZN7S1566C43v37Ev();
extern void _ZN7S1566C43v38Ev();
extern void _ZN7S1566C43v39Ev();
extern void _ZN7S1566C43v40Ev();
extern void _ZN7S1566C43v41Ev();
extern void _ZN7S1566C43v42Ev();
extern void _ZN7S1566C43v43Ev();
extern void _ZN7S1566C43v44Ev();
extern void _ZN7S1566C43v45Ev();
extern void _ZN7S1566C43v46Ev();
extern void _ZN7S1566C43v47Ev();
extern void _ZN7S1566C43v48Ev();
extern void _ZN7S1566C43v49Ev();
extern void _ZN7S1566C43v50Ev();
extern void _ZN7S1566C43v51Ev();
extern void _ZN7S1566C43v52Ev();
extern void _ZN7S1566C43v53Ev();
extern void _ZN7S1566C43v54Ev();
extern void _ZN7S1566C43v55Ev();
extern void _ZN7S1566C43v56Ev();
extern void _ZN7S1566C43v57Ev();
extern void _ZN7S1566C43v58Ev();
extern void _ZN7S1566C43v59Ev();
extern void _ZN7S1566C43v60Ev();
extern void _ZN7S1566C43v61Ev();
extern void _ZN7S1566C43v62Ev();
extern void _ZN7S1566C43v63Ev();
extern void _ZN7S1566C43v64Ev();
extern void _ZN7S1566C43v65Ev();
extern void _ZN7S1566C43v66Ev();
extern void _ZN7S1566C43v67Ev();
extern void _ZN7S1566C43v68Ev();
extern void _ZN7S1566C43v69Ev();
extern void _ZN7S1566C43v70Ev();
extern void _ZN7S1566C43v71Ev();
static  VTBL_ENTRY vtc_S1566C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1566C4[0]),
  (VTBL_ENTRY)&_ZN7S1566C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1566C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1566C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1566C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v71Ev,
};
extern VTBL_ENTRY _ZTI7S1566C4[];
extern  VTBL_ENTRY _ZTV7S1566C4[];
Class_Descriptor cd_S1566C4 = {  "S1566C4", // class name
  0,0,//no base classes
  &(vtc_S1566C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1566C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1566C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C6  {
  virtual void  v72(); // _ZN7S1566C63v72Ev
  ~S1566C6(); // tgen
  S1566C6(); // tgen
};
//SIG(-1 S1566C6) C1{ v1}


void  S1566C6 ::v72(){vfunc_called(this, "_ZN7S1566C63v72Ev");}
S1566C6 ::~S1566C6(){ note_dtor("S1566C6", this);} // tgen
S1566C6 ::S1566C6(){ note_ctor("S1566C6", this);} // tgen

static void Test_S1566C6()
{
  extern Class_Descriptor cd_S1566C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1566C6, buf);
    S1566C6 *dp, &lv = *(dp=new (buf) S1566C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1566C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C6)");
    test_class_info(&lv, &cd_S1566C6);
    dp->~S1566C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C6(Test_S1566C6, "S1566C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1566C6C1Ev();
extern void _ZN7S1566C6D1Ev();
Name_Map name_map_S1566C6[] = {
  NSPAIR(_ZN7S1566C6C1Ev),
  NSPAIR(_ZN7S1566C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1566C6[];
extern void _ZN7S1566C63v72Ev();
static  VTBL_ENTRY vtc_S1566C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1566C6[0]),
  (VTBL_ENTRY)&_ZN7S1566C63v72Ev,
};
extern VTBL_ENTRY _ZTI7S1566C6[];
extern  VTBL_ENTRY _ZTV7S1566C6[];
Class_Descriptor cd_S1566C6 = {  "S1566C6", // class name
  0,0,//no base classes
  &(vtc_S1566C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1566C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1566C6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C3  : S1566C4 , S1566C6 {
  void *s1566c3f0;
  int s1566c3f1[7];
  virtual  ~S1566C3(); // _ZN7S1566C3D1Ev
  virtual void  v73(); // _ZN7S1566C33v73Ev
  virtual void  v74(); // _ZN7S1566C33v74Ev
  virtual void  v75(); // _ZN7S1566C33v75Ev
  virtual void  v76(); // _ZN7S1566C33v76Ev
  S1566C3(); // tgen
};
//SIG(-1 S1566C3) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v69} vd v1 v2 v3 v4 Fp Fi[7]}


 S1566C3 ::~S1566C3(){ note_dtor("S1566C3", this);}
void  S1566C3 ::v73(){vfunc_called(this, "_ZN7S1566C33v73Ev");}
void  S1566C3 ::v74(){vfunc_called(this, "_ZN7S1566C33v74Ev");}
void  S1566C3 ::v75(){vfunc_called(this, "_ZN7S1566C33v75Ev");}
void  S1566C3 ::v76(){vfunc_called(this, "_ZN7S1566C33v76Ev");}
S1566C3 ::S1566C3(){ note_ctor("S1566C3", this);} // tgen

static void Test_S1566C3()
{
  extern Class_Descriptor cd_S1566C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,25)];
    init_test(&cd_S1566C3, buf);
    S1566C3 *dp, &lv = *(dp=new (buf) S1566C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,96), "sizeof(S1566C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C3)");
    check_base_class_offset(lv, (S1566C4*), 0, "S1566C3");
    check_base_class_offset(lv, (S1566C6*), ABISELECT(96,60), "S1566C3");
    check_field_offset(lv, s1566c3f0, ABISELECT(104,64), "S1566C3.s1566c3f0");
    check_field_offset(lv, s1566c3f1, ABISELECT(112,68), "S1566C3.s1566c3f1");
    test_class_info(&lv, &cd_S1566C3);
    dp->~S1566C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C3(Test_S1566C3, "S1566C3", ABISELECT(144,96));

#else // __cplusplus

extern void _ZN7S1566C3C1Ev();
extern void _ZN7S1566C3D1Ev();
Name_Map name_map_S1566C3[] = {
  NSPAIR(_ZN7S1566C3C1Ev),
  NSPAIR(_ZN7S1566C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1566C4;
extern VTBL_ENTRY _ZTI7S1566C4[];
extern  VTBL_ENTRY _ZTV7S1566C4[];
extern Class_Descriptor cd_S1566C6;
extern VTBL_ENTRY _ZTI7S1566C6[];
extern  VTBL_ENTRY _ZTV7S1566C6[];
static Base_Class bases_S1566C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1566C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1566C6,    ABISELECT(96,60), //bcp->offset
    72, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1566C3[];
extern void _ZN7S1566C3D1Ev();
extern void _ZN7S1566C3D0Ev();
extern void _ZN7S1566C42v8Ev();
extern void _ZN7S1566C42v9Ev();
extern void _ZN7S1566C43v10Ev();
extern void _ZN7S1566C43v11Ev();
extern void _ZN7S1566C43v12Ev();
extern void _ZN7S1566C43v13Ev();
extern void _ZN7S1566C43v14Ev();
extern void _ZN7S1566C43v15Ev();
extern void _ZN7S1566C43v16Ev();
extern void _ZN7S1566C43v17Ev();
extern void _ZN7S1566C43v18Ev();
extern void _ZN7S1566C43v19Ev();
extern void _ZN7S1566C43v20Ev();
extern void _ZN7S1566C43v21Ev();
extern void _ZN7S1566C43v22Ev();
extern void _ZN7S1566C43v23Ev();
extern void _ZN7S1566C43v24Ev();
extern void _ZN7S1566C43v25Ev();
extern void _ZN7S1566C43v26Ev();
extern void _ZN7S1566C43v27Ev();
extern void _ZN7S1566C43v28Ev();
extern void _ZN7S1566C43v29Ev();
extern void _ZN7S1566C43v30Ev();
extern void _ZN7S1566C43v31Ev();
extern void _ZN7S1566C43v32Ev();
extern void _ZN7S1566C43v33Ev();
extern void _ZN7S1566C43v34Ev();
extern void _ZN7S1566C43v35Ev();
extern void _ZN7S1566C43v36Ev();
extern void _ZN7S1566C43v37Ev();
extern void _ZN7S1566C43v38Ev();
extern void _ZN7S1566C43v39Ev();
extern void _ZN7S1566C43v40Ev();
extern void _ZN7S1566C43v41Ev();
extern void _ZN7S1566C43v42Ev();
extern void _ZN7S1566C43v43Ev();
extern void _ZN7S1566C43v44Ev();
extern void _ZN7S1566C43v45Ev();
extern void _ZN7S1566C43v46Ev();
extern void _ZN7S1566C43v47Ev();
extern void _ZN7S1566C43v48Ev();
extern void _ZN7S1566C43v49Ev();
extern void _ZN7S1566C43v50Ev();
extern void _ZN7S1566C43v51Ev();
extern void _ZN7S1566C43v52Ev();
extern void _ZN7S1566C43v53Ev();
extern void _ZN7S1566C43v54Ev();
extern void _ZN7S1566C43v55Ev();
extern void _ZN7S1566C43v56Ev();
extern void _ZN7S1566C43v57Ev();
extern void _ZN7S1566C43v58Ev();
extern void _ZN7S1566C43v59Ev();
extern void _ZN7S1566C43v60Ev();
extern void _ZN7S1566C43v61Ev();
extern void _ZN7S1566C43v62Ev();
extern void _ZN7S1566C43v63Ev();
extern void _ZN7S1566C43v64Ev();
extern void _ZN7S1566C43v65Ev();
extern void _ZN7S1566C43v66Ev();
extern void _ZN7S1566C43v67Ev();
extern void _ZN7S1566C43v68Ev();
extern void _ZN7S1566C43v69Ev();
extern void _ZN7S1566C43v70Ev();
extern void _ZN7S1566C43v71Ev();
extern void _ZN7S1566C33v73Ev();
extern void _ZN7S1566C33v74Ev();
extern void _ZN7S1566C33v75Ev();
extern void _ZN7S1566C33v76Ev();
extern void _ZN7S1566C63v72Ev();
static  VTBL_ENTRY vtc_S1566C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1566C3[0]),
  (VTBL_ENTRY)&_ZN7S1566C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1566C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1566C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1566C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v76Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1566C3[0]),
  (VTBL_ENTRY)&_ZN7S1566C63v72Ev,
};
extern VTBL_ENTRY _ZTI7S1566C3[];
extern  VTBL_ENTRY _ZTV7S1566C3[];
Class_Descriptor cd_S1566C3 = {  "S1566C3", // class name
  bases_S1566C3, 2,
  &(vtc_S1566C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,96), // object size
  NSPAIRA(_ZTI7S1566C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1566C3),75, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C7_nt  {
  virtual  ~S1566C7_nt(); // _ZN10S1566C7_ntD1Ev
  virtual void  v77(); // _ZN10S1566C7_nt3v77Ev
  virtual void  v78(); // _ZN10S1566C7_nt3v78Ev
  virtual void  v79(); // _ZN10S1566C7_nt3v79Ev
  S1566C7_nt(); // tgen
};
//SIG(-1 S1566C7_nt) C1{ vd v1 v2 v3}


 S1566C7_nt ::~S1566C7_nt(){ note_dtor("S1566C7_nt", this);}
void  S1566C7_nt ::v77(){vfunc_called(this, "_ZN10S1566C7_nt3v77Ev");}
void  S1566C7_nt ::v78(){vfunc_called(this, "_ZN10S1566C7_nt3v78Ev");}
void  S1566C7_nt ::v79(){vfunc_called(this, "_ZN10S1566C7_nt3v79Ev");}
S1566C7_nt ::S1566C7_nt(){ note_ctor("S1566C7_nt", this);} // tgen

//skip512 S1566C7_nt

#else // __cplusplus

extern void _ZN10S1566C7_ntC1Ev();
extern void _ZN10S1566C7_ntD1Ev();
Name_Map name_map_S1566C7_nt[] = {
  NSPAIR(_ZN10S1566C7_ntC1Ev),
  NSPAIR(_ZN10S1566C7_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1566C7_nt[];
extern void _ZN10S1566C7_ntD1Ev();
extern void _ZN10S1566C7_ntD0Ev();
extern void _ZN10S1566C7_nt3v77Ev();
extern void _ZN10S1566C7_nt3v78Ev();
extern void _ZN10S1566C7_nt3v79Ev();
static  VTBL_ENTRY vtc_S1566C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1566C7_nt[0]),
  (VTBL_ENTRY)&_ZN10S1566C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1566C7_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1566C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1566C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1566C7_nt3v79Ev,
};
extern VTBL_ENTRY _ZTI10S1566C7_nt[];
VTBL_ENTRY *P__ZTI10S1566C7_nt = _ZTI10S1566C7_nt; 
extern  VTBL_ENTRY _ZTV10S1566C7_nt[];
Class_Descriptor cd_S1566C7_nt = {  "S1566C7_nt", // class name
  0,0,//no base classes
  &(vtc_S1566C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S1566C7_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1566C7_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C10  : S1537C8_nt {
};
//SIG(-1 S1566C10) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1566C10()
{
  extern Class_Descriptor cd_S1566C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1566C10, buf);
    S1566C10 &lv = *(new (buf) S1566C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1566C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C10)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1566C10");
    test_class_info(&lv, &cd_S1566C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C10(Test_S1566C10, "S1566C10", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1566C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1566C10 = {  "S1566C10", // class name
  bases_S1566C10, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C9  : S1566C10 {
};
//SIG(-1 S1566C9) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1566C9()
{
  extern Class_Descriptor cd_S1566C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1566C9, buf);
    S1566C9 &lv = *(new (buf) S1566C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1566C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C9)");
    check_base_class_offset(lv, (S1537C8_nt*)(S1566C10*), 0, "S1566C9");
    check_base_class_offset(lv, (S1566C10*), 0, "S1566C9");
    test_class_info(&lv, &cd_S1566C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C9(Test_S1566C9, "S1566C9", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1566C10;
static Base_Class bases_S1566C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1566C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1566C9 = {  "S1566C9", // class name
  bases_S1566C9, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C14_nt  {
  int s1566c14f0[2];
  void  mf1566c14(); // _ZN11S1566C14_nt9mf1566c14Ev
};
//SIG(-1 S1566C14_nt) C1{ m Fi[2]}


void  S1566C14_nt ::mf1566c14(){}

//skip512 S1566C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C17  {
  int s1566c17f0[28];
  virtual  ~S1566C17(); // _ZN8S1566C17D1Ev
  virtual void  v105(); // _ZN8S1566C174v105Ev
  virtual void  v106(); // _ZN8S1566C174v106Ev
  virtual void  v107(); // _ZN8S1566C174v107Ev
  virtual void  v108(); // _ZN8S1566C174v108Ev
  virtual void  v109(); // _ZN8S1566C174v109Ev
  virtual void  v110(); // _ZN8S1566C174v110Ev
  virtual void  v111(); // _ZN8S1566C174v111Ev
  virtual void  v112(); // _ZN8S1566C174v112Ev
  virtual void  v113(); // _ZN8S1566C174v113Ev
  virtual void  v114(); // _ZN8S1566C174v114Ev
  virtual void  v115(); // _ZN8S1566C174v115Ev
  virtual void  v116(); // _ZN8S1566C174v116Ev
  virtual void  v117(); // _ZN8S1566C174v117Ev
  virtual void  v118(); // _ZN8S1566C174v118Ev
  virtual void  v119(); // _ZN8S1566C174v119Ev
  virtual void  v120(); // _ZN8S1566C174v120Ev
  virtual void  v121(); // _ZN8S1566C174v121Ev
  virtual void  v122(); // _ZN8S1566C174v122Ev
  virtual void  v123(); // _ZN8S1566C174v123Ev
  virtual void  v124(); // _ZN8S1566C174v124Ev
  virtual void  v125(); // _ZN8S1566C174v125Ev
  virtual void  v126(); // _ZN8S1566C174v126Ev
  virtual void  v127(); // _ZN8S1566C174v127Ev
  virtual void  v128(); // _ZN8S1566C174v128Ev
  virtual void  v129(); // _ZN8S1566C174v129Ev
  S1566C17(); // tgen
};
//SIG(-1 S1566C17) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fi[28]}


 S1566C17 ::~S1566C17(){ note_dtor("S1566C17", this);}
void  S1566C17 ::v105(){vfunc_called(this, "_ZN8S1566C174v105Ev");}
void  S1566C17 ::v106(){vfunc_called(this, "_ZN8S1566C174v106Ev");}
void  S1566C17 ::v107(){vfunc_called(this, "_ZN8S1566C174v107Ev");}
void  S1566C17 ::v108(){vfunc_called(this, "_ZN8S1566C174v108Ev");}
void  S1566C17 ::v109(){vfunc_called(this, "_ZN8S1566C174v109Ev");}
void  S1566C17 ::v110(){vfunc_called(this, "_ZN8S1566C174v110Ev");}
void  S1566C17 ::v111(){vfunc_called(this, "_ZN8S1566C174v111Ev");}
void  S1566C17 ::v112(){vfunc_called(this, "_ZN8S1566C174v112Ev");}
void  S1566C17 ::v113(){vfunc_called(this, "_ZN8S1566C174v113Ev");}
void  S1566C17 ::v114(){vfunc_called(this, "_ZN8S1566C174v114Ev");}
void  S1566C17 ::v115(){vfunc_called(this, "_ZN8S1566C174v115Ev");}
void  S1566C17 ::v116(){vfunc_called(this, "_ZN8S1566C174v116Ev");}
void  S1566C17 ::v117(){vfunc_called(this, "_ZN8S1566C174v117Ev");}
void  S1566C17 ::v118(){vfunc_called(this, "_ZN8S1566C174v118Ev");}
void  S1566C17 ::v119(){vfunc_called(this, "_ZN8S1566C174v119Ev");}
void  S1566C17 ::v120(){vfunc_called(this, "_ZN8S1566C174v120Ev");}
void  S1566C17 ::v121(){vfunc_called(this, "_ZN8S1566C174v121Ev");}
void  S1566C17 ::v122(){vfunc_called(this, "_ZN8S1566C174v122Ev");}
void  S1566C17 ::v123(){vfunc_called(this, "_ZN8S1566C174v123Ev");}
void  S1566C17 ::v124(){vfunc_called(this, "_ZN8S1566C174v124Ev");}
void  S1566C17 ::v125(){vfunc_called(this, "_ZN8S1566C174v125Ev");}
void  S1566C17 ::v126(){vfunc_called(this, "_ZN8S1566C174v126Ev");}
void  S1566C17 ::v127(){vfunc_called(this, "_ZN8S1566C174v127Ev");}
void  S1566C17 ::v128(){vfunc_called(this, "_ZN8S1566C174v128Ev");}
void  S1566C17 ::v129(){vfunc_called(this, "_ZN8S1566C174v129Ev");}
S1566C17 ::S1566C17(){ note_ctor("S1566C17", this);} // tgen

static void Test_S1566C17()
{
  extern Class_Descriptor cd_S1566C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,30)];
    init_test(&cd_S1566C17, buf);
    S1566C17 *dp, &lv = *(dp=new (buf) S1566C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,116), "sizeof(S1566C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C17)");
    check_field_offset(lv, s1566c17f0, ABISELECT(8,4), "S1566C17.s1566c17f0");
    test_class_info(&lv, &cd_S1566C17);
    dp->~S1566C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C17(Test_S1566C17, "S1566C17", ABISELECT(120,116));

#else // __cplusplus

extern void _ZN8S1566C17C1Ev();
extern void _ZN8S1566C17D1Ev();
Name_Map name_map_S1566C17[] = {
  NSPAIR(_ZN8S1566C17C1Ev),
  NSPAIR(_ZN8S1566C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1566C17[];
extern void _ZN8S1566C17D1Ev();
extern void _ZN8S1566C17D0Ev();
extern void _ZN8S1566C174v105Ev();
extern void _ZN8S1566C174v106Ev();
extern void _ZN8S1566C174v107Ev();
extern void _ZN8S1566C174v108Ev();
extern void _ZN8S1566C174v109Ev();
extern void _ZN8S1566C174v110Ev();
extern void _ZN8S1566C174v111Ev();
extern void _ZN8S1566C174v112Ev();
extern void _ZN8S1566C174v113Ev();
extern void _ZN8S1566C174v114Ev();
extern void _ZN8S1566C174v115Ev();
extern void _ZN8S1566C174v116Ev();
extern void _ZN8S1566C174v117Ev();
extern void _ZN8S1566C174v118Ev();
extern void _ZN8S1566C174v119Ev();
extern void _ZN8S1566C174v120Ev();
extern void _ZN8S1566C174v121Ev();
extern void _ZN8S1566C174v122Ev();
extern void _ZN8S1566C174v123Ev();
extern void _ZN8S1566C174v124Ev();
extern void _ZN8S1566C174v125Ev();
extern void _ZN8S1566C174v126Ev();
extern void _ZN8S1566C174v127Ev();
extern void _ZN8S1566C174v128Ev();
extern void _ZN8S1566C174v129Ev();
static  VTBL_ENTRY vtc_S1566C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1566C17[0]),
  (VTBL_ENTRY)&_ZN8S1566C17D1Ev,
  (VTBL_ENTRY)&_ZN8S1566C17D0Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v105Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v106Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v107Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v108Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v109Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v110Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v111Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v112Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v113Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v114Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v115Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v116Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v117Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v118Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v119Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v120Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v121Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v122Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v123Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v124Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v125Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v126Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v127Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v128Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v129Ev,
};
extern VTBL_ENTRY _ZTI8S1566C17[];
extern  VTBL_ENTRY _ZTV8S1566C17[];
Class_Descriptor cd_S1566C17 = {  "S1566C17", // class name
  0,0,//no base classes
  &(vtc_S1566C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,116), // object size
  NSPAIRA(_ZTI8S1566C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1566C17),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C16  : S1566C17 {
  ::S1537C23 s1566c16f0;
  int s1566c16f1[2];
  virtual void  v130(); // _ZN8S1566C164v130Ev
  virtual void  v131(); // _ZN8S1566C164v131Ev
  virtual void  v132(); // _ZN8S1566C164v132Ev
  ~S1566C16(); // tgen
  S1566C16(); // tgen
};
//SIG(-1 S1566C16) C1{ BC2{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fi[28]} v1 v2 v3 FC3{ BC4{ m Fp Fi[2]}} Fi[2]}


void  S1566C16 ::v130(){vfunc_called(this, "_ZN8S1566C164v130Ev");}
void  S1566C16 ::v131(){vfunc_called(this, "_ZN8S1566C164v131Ev");}
void  S1566C16 ::v132(){vfunc_called(this, "_ZN8S1566C164v132Ev");}
S1566C16 ::~S1566C16(){ note_dtor("S1566C16", this);} // tgen
S1566C16 ::S1566C16(){ note_ctor("S1566C16", this);} // tgen

static void Test_S1566C16()
{
  extern Class_Descriptor cd_S1566C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,35)];
    init_test(&cd_S1566C16, buf);
    S1566C16 *dp, &lv = *(dp=new (buf) S1566C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,136), "sizeof(S1566C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C16)");
    check_base_class_offset(lv, (S1566C17*), 0, "S1566C16");
    check_field_offset(lv, s1566c16f0, ABISELECT(120,116), "S1566C16.s1566c16f0");
    check_field_offset(lv, s1566c16f1, ABISELECT(136,128), "S1566C16.s1566c16f1");
    test_class_info(&lv, &cd_S1566C16);
    dp->~S1566C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C16(Test_S1566C16, "S1566C16", ABISELECT(144,136));

#else // __cplusplus

extern void _ZN8S1566C16C1Ev();
extern void _ZN8S1566C16D1Ev();
Name_Map name_map_S1566C16[] = {
  NSPAIR(_ZN8S1566C16C1Ev),
  NSPAIR(_ZN8S1566C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1566C17;
extern VTBL_ENTRY _ZTI8S1566C17[];
extern  VTBL_ENTRY _ZTV8S1566C17[];
static Base_Class bases_S1566C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1566C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1566C16[];
extern void _ZN8S1566C16D1Ev();
extern void _ZN8S1566C16D0Ev();
extern void _ZN8S1566C174v105Ev();
extern void _ZN8S1566C174v106Ev();
extern void _ZN8S1566C174v107Ev();
extern void _ZN8S1566C174v108Ev();
extern void _ZN8S1566C174v109Ev();
extern void _ZN8S1566C174v110Ev();
extern void _ZN8S1566C174v111Ev();
extern void _ZN8S1566C174v112Ev();
extern void _ZN8S1566C174v113Ev();
extern void _ZN8S1566C174v114Ev();
extern void _ZN8S1566C174v115Ev();
extern void _ZN8S1566C174v116Ev();
extern void _ZN8S1566C174v117Ev();
extern void _ZN8S1566C174v118Ev();
extern void _ZN8S1566C174v119Ev();
extern void _ZN8S1566C174v120Ev();
extern void _ZN8S1566C174v121Ev();
extern void _ZN8S1566C174v122Ev();
extern void _ZN8S1566C174v123Ev();
extern void _ZN8S1566C174v124Ev();
extern void _ZN8S1566C174v125Ev();
extern void _ZN8S1566C174v126Ev();
extern void _ZN8S1566C174v127Ev();
extern void _ZN8S1566C174v128Ev();
extern void _ZN8S1566C174v129Ev();
extern void _ZN8S1566C164v130Ev();
extern void _ZN8S1566C164v131Ev();
extern void _ZN8S1566C164v132Ev();
static  VTBL_ENTRY vtc_S1566C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1566C16[0]),
  (VTBL_ENTRY)&_ZN8S1566C16D1Ev,
  (VTBL_ENTRY)&_ZN8S1566C16D0Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v105Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v106Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v107Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v108Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v109Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v110Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v111Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v112Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v113Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v114Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v115Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v116Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v117Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v118Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v119Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v120Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v121Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v122Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v123Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v124Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v125Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v126Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v127Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v128Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v129Ev,
  (VTBL_ENTRY)&_ZN8S1566C164v130Ev,
  (VTBL_ENTRY)&_ZN8S1566C164v131Ev,
  (VTBL_ENTRY)&_ZN8S1566C164v132Ev,
};
extern VTBL_ENTRY _ZTI8S1566C16[];
extern  VTBL_ENTRY _ZTV8S1566C16[];
Class_Descriptor cd_S1566C16 = {  "S1566C16", // class name
  bases_S1566C16, 1,
  &(vtc_S1566C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,136), // object size
  NSPAIRA(_ZTI8S1566C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1566C16),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C15  : S1566C16 {
  void *s1566c15f0[2];
  __tsi64 s1566c15f1;
  int s1566c15f2[5];
  char s1566c15f3[3];
  virtual void  v103(); // _ZN8S1566C154v103Ev
  virtual void  v104(); // _ZN8S1566C154v104Ev
  ~S1566C15(); // tgen
  S1566C15(); // tgen
};
//SIG(-1 S1566C15) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fi[28]} v28 v29 v30 FC4{ BC5{ m Fp Fi[2]}} Fi[2]} v1 v2 Fp[2] FL Fi[5] Fc[3]}


void  S1566C15 ::v103(){vfunc_called(this, "_ZN8S1566C154v103Ev");}
void  S1566C15 ::v104(){vfunc_called(this, "_ZN8S1566C154v104Ev");}
S1566C15 ::~S1566C15(){ note_dtor("S1566C15", this);} // tgen
S1566C15 ::S1566C15(){ note_ctor("S1566C15", this);} // tgen

static void Test_S1566C15()
{
  extern Class_Descriptor cd_S1566C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,45)];
    init_test(&cd_S1566C15, buf);
    S1566C15 *dp, &lv = *(dp=new (buf) S1566C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,176), "sizeof(S1566C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C15)");
    check_base_class_offset(lv, (S1566C17*)(S1566C16*), 0, "S1566C15");
    check_base_class_offset(lv, (S1566C16*), 0, "S1566C15");
    check_field_offset(lv, s1566c15f0, ABISELECT(144,136), "S1566C15.s1566c15f0");
    check_field_offset(lv, s1566c15f1, ABISELECT(160,144), "S1566C15.s1566c15f1");
    check_field_offset(lv, s1566c15f2, ABISELECT(168,152), "S1566C15.s1566c15f2");
    check_field_offset(lv, s1566c15f3, ABISELECT(188,172), "S1566C15.s1566c15f3");
    test_class_info(&lv, &cd_S1566C15);
    dp->~S1566C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C15(Test_S1566C15, "S1566C15", ABISELECT(192,176));

#else // __cplusplus

extern void _ZN8S1566C15C1Ev();
extern void _ZN8S1566C15D1Ev();
Name_Map name_map_S1566C15[] = {
  NSPAIR(_ZN8S1566C15C1Ev),
  NSPAIR(_ZN8S1566C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1566C17;
extern VTBL_ENTRY _ZTI8S1566C17[];
extern  VTBL_ENTRY _ZTV8S1566C17[];
extern Class_Descriptor cd_S1566C16;
extern VTBL_ENTRY _ZTI8S1566C16[];
extern  VTBL_ENTRY _ZTV8S1566C16[];
static Base_Class bases_S1566C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1566C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1566C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1566C15[];
extern void _ZN8S1566C15D1Ev();
extern void _ZN8S1566C15D0Ev();
extern void _ZN8S1566C174v105Ev();
extern void _ZN8S1566C174v106Ev();
extern void _ZN8S1566C174v107Ev();
extern void _ZN8S1566C174v108Ev();
extern void _ZN8S1566C174v109Ev();
extern void _ZN8S1566C174v110Ev();
extern void _ZN8S1566C174v111Ev();
extern void _ZN8S1566C174v112Ev();
extern void _ZN8S1566C174v113Ev();
extern void _ZN8S1566C174v114Ev();
extern void _ZN8S1566C174v115Ev();
extern void _ZN8S1566C174v116Ev();
extern void _ZN8S1566C174v117Ev();
extern void _ZN8S1566C174v118Ev();
extern void _ZN8S1566C174v119Ev();
extern void _ZN8S1566C174v120Ev();
extern void _ZN8S1566C174v121Ev();
extern void _ZN8S1566C174v122Ev();
extern void _ZN8S1566C174v123Ev();
extern void _ZN8S1566C174v124Ev();
extern void _ZN8S1566C174v125Ev();
extern void _ZN8S1566C174v126Ev();
extern void _ZN8S1566C174v127Ev();
extern void _ZN8S1566C174v128Ev();
extern void _ZN8S1566C174v129Ev();
extern void _ZN8S1566C164v130Ev();
extern void _ZN8S1566C164v131Ev();
extern void _ZN8S1566C164v132Ev();
extern void _ZN8S1566C154v103Ev();
extern void _ZN8S1566C154v104Ev();
static  VTBL_ENTRY vtc_S1566C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1566C15[0]),
  (VTBL_ENTRY)&_ZN8S1566C15D1Ev,
  (VTBL_ENTRY)&_ZN8S1566C15D0Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v105Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v106Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v107Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v108Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v109Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v110Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v111Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v112Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v113Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v114Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v115Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v116Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v117Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v118Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v119Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v120Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v121Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v122Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v123Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v124Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v125Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v126Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v127Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v128Ev,
  (VTBL_ENTRY)&_ZN8S1566C174v129Ev,
  (VTBL_ENTRY)&_ZN8S1566C164v130Ev,
  (VTBL_ENTRY)&_ZN8S1566C164v131Ev,
  (VTBL_ENTRY)&_ZN8S1566C164v132Ev,
  (VTBL_ENTRY)&_ZN8S1566C154v103Ev,
  (VTBL_ENTRY)&_ZN8S1566C154v104Ev,
};
extern VTBL_ENTRY _ZTI8S1566C15[];
extern  VTBL_ENTRY _ZTV8S1566C15[];
Class_Descriptor cd_S1566C15 = {  "S1566C15", // class name
  bases_S1566C15, 2,
  &(vtc_S1566C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,176), // object size
  NSPAIRA(_ZTI8S1566C15),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1566C15),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C23_nt  {
  ::S1325C31 s1566c23f0;
  void *s1566c23f1;
  int s1566c23f2;
  void  mf1566c23(); // _ZN11S1566C23_nt9mf1566c23Ev
};
//SIG(-1 S1566C23_nt) C1{ m FC2{ BC3{ m Fp Fi[2]}} Fp Fi}


void  S1566C23_nt ::mf1566c23(){}

//skip512 S1566C23_nt

#else // __cplusplus

Class_Descriptor cd_S1566C23_nt = {  "S1566C23_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C22_nt  : S1566C23_nt {
};
//SIG(-1 S1566C22_nt) C1{ BC2{ m FC3{ BC4{ m Fp Fi[2]}} Fp Fi}}



//skip512 S1566C22_nt

#else // __cplusplus

extern Class_Descriptor cd_S1566C23_nt;
static Base_Class bases_S1566C22_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1566C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C29  : S1537C8_nt {
};
//SIG(-1 S1566C29) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1566C29()
{
  extern Class_Descriptor cd_S1566C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1566C29, buf);
    S1566C29 &lv = *(new (buf) S1566C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1566C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C29)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1566C29");
    test_class_info(&lv, &cd_S1566C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C29(Test_S1566C29, "S1566C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1566C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1566C29 = {  "S1566C29", // class name
  bases_S1566C29, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C30  {
  int s1566c30f0[5];
  void  mf1566c30(); // _ZN8S1566C309mf1566c30Ev
};
//SIG(-1 S1566C30) C1{ m Fi[5]}


void  S1566C30 ::mf1566c30(){}

static void Test_S1566C30()
{
  {
    init_simple_test("S1566C30");
    S1566C30 lv;
    check2(sizeof(lv), 20, "sizeof(S1566C30)");
    check2(__alignof__(lv), 4, "__alignof__(S1566C30)");
    check_field_offset(lv, s1566c30f0, 0, "S1566C30.s1566c30f0");
  }
}
static Arrange_To_Call_Me vS1566C30(Test_S1566C30, "S1566C30", 20);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C2  : S1566C3 , S1566C7_nt {
  void *s1566c2f0;
  int s1566c2f1;
  ::S1325C21 s1566c2f2;
  void *s1566c2f3;
  int s1566c2f4[6];
  ::S1566C9 s1566c2f5;
  ::S1566C9 s1566c2f6;
  int s1566c2f7[3];
  ::S1325C7_nt s1566c2f8;
  ::S1566C9 s1566c2f9;
  ::S1566C9 s1566c2f10;
  __tsi64 s1566c2f11[3];
  int s1566c2f12[2];
  ::S1566C14_nt s1566c2f13;
  ::S1566C14_nt s1566c2f14;
  int s1566c2f15[2];
  void *s1566c2f16;
  ::S1566C15 s1566c2f17;
  __tsi64 s1566c2f18;
  int s1566c2f19[6];
  __tsi64 s1566c2f20[4];
  int s1566c2f21;
  ::S1566C16 s1566c2f22;
  __tsi64 s1566c2f23[256];
  int s1566c2f24[259];
  void *s1566c2f25[1023];
  int s1566c2f26[3069];
  ::S1537C19 s1566c2f27;
  ::S1537C19 s1566c2f28;
  ::S1537C13 s1566c2f29;
  ::S1537C7_nt s1566c2f30;
  ::S1566C22_nt s1566c2f31;
  void *s1566c2f32;
  ::S1325C27 s1566c2f33;
  ::S1325C23 s1566c2f34;
  ::S1537C5_nt s1566c2f35;
  ::S1325C14 s1566c2f36;
  ::S1325C9 s1566c2f37;
  ::S1566C29 s1566c2f38;
  void *s1566c2f39[2];
  int s1566c2f40;
  ::S1566C30 s1566c2f41;
  ::S1566C29 s1566c2f42;
  virtual  ~S1566C2(); // _ZN7S1566C2D1Ev
  virtual void  v80(); // _ZN7S1566C23v80Ev
  virtual void  v81(); // _ZN7S1566C23v81Ev
  virtual void  v82(); // _ZN7S1566C23v82Ev
  virtual void  v83(); // _ZN7S1566C23v83Ev
  virtual void  v84(); // _ZN7S1566C23v84Ev
  virtual void  v85(); // _ZN7S1566C23v85Ev
  virtual void  v86(); // _ZN7S1566C23v86Ev
  virtual void  v87(); // _ZN7S1566C23v87Ev
  virtual void  v88(); // _ZN7S1566C23v88Ev
  virtual void  v89(); // _ZN7S1566C23v89Ev
  virtual void  v90(); // _ZN7S1566C23v90Ev
  virtual void  v91(); // _ZN7S1566C23v91Ev
  virtual void  v92(); // _ZN7S1566C23v92Ev
  virtual void  v93(); // _ZN7S1566C23v93Ev
  virtual void  v94(); // _ZN7S1566C23v94Ev
  virtual void  v95(); // _ZN7S1566C23v95Ev
  virtual void  v96(); // _ZN7S1566C23v96Ev
  virtual void  v97(); // _ZN7S1566C23v97Ev
  virtual void  v98(); // _ZN7S1566C23v98Ev
  virtual void  v99(); // _ZN7S1566C23v99Ev
  virtual void  v100(); // _ZN7S1566C24v100Ev
  virtual void  v101(); // _ZN7S1566C24v101Ev
  virtual void  v102(); // _ZN7S1566C24v102Ev
  S1566C2(); // tgen
};
//SIG(-1 S1566C2) C1{ BC2{ BC3{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v88} vd v89 v90 v91 v92 Fp Fi[7]} BC6{ vd v93 v94 v95} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC7{ m FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fi FC8 FC11{ BC10} FC8 Fi} Fp Fi[6] FC12{ BC13{ BC10}} FC12 Fi[3] FC14{ BC8} FC12 FC12 FL[3] Fi[2] FC15{ m Fi[2]} FC15 Fi[2] Fp FC16{ BC17{ BC18{ vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fi[28]} v123 v124 v125 FC19{ BC10} Fi[2]} v96 v97 Fp[2] FL Fi[5] Fc[3]} FL Fi[6] FL[4] Fi FC17 FL[256] Fi[259] Fp[1023] Fi[3069] FC20{ BC10} FC20 FC21{ BC10} FC22{ BC10} FC23{ BC24{ m FC25{ BC10} Fp Fi}} Fp FC26{ BC10} FC27{ BC10} FC4 FC11 FC9 FC28{ BC10} Fp[2] Fi FC29{ m Fi[5]} FC28}


 S1566C2 ::~S1566C2(){ note_dtor("S1566C2", this);}
void  S1566C2 ::v80(){vfunc_called(this, "_ZN7S1566C23v80Ev");}
void  S1566C2 ::v81(){vfunc_called(this, "_ZN7S1566C23v81Ev");}
void  S1566C2 ::v82(){vfunc_called(this, "_ZN7S1566C23v82Ev");}
void  S1566C2 ::v83(){vfunc_called(this, "_ZN7S1566C23v83Ev");}
void  S1566C2 ::v84(){vfunc_called(this, "_ZN7S1566C23v84Ev");}
void  S1566C2 ::v85(){vfunc_called(this, "_ZN7S1566C23v85Ev");}
void  S1566C2 ::v86(){vfunc_called(this, "_ZN7S1566C23v86Ev");}
void  S1566C2 ::v87(){vfunc_called(this, "_ZN7S1566C23v87Ev");}
void  S1566C2 ::v88(){vfunc_called(this, "_ZN7S1566C23v88Ev");}
void  S1566C2 ::v89(){vfunc_called(this, "_ZN7S1566C23v89Ev");}
void  S1566C2 ::v90(){vfunc_called(this, "_ZN7S1566C23v90Ev");}
void  S1566C2 ::v91(){vfunc_called(this, "_ZN7S1566C23v91Ev");}
void  S1566C2 ::v92(){vfunc_called(this, "_ZN7S1566C23v92Ev");}
void  S1566C2 ::v93(){vfunc_called(this, "_ZN7S1566C23v93Ev");}
void  S1566C2 ::v94(){vfunc_called(this, "_ZN7S1566C23v94Ev");}
void  S1566C2 ::v95(){vfunc_called(this, "_ZN7S1566C23v95Ev");}
void  S1566C2 ::v96(){vfunc_called(this, "_ZN7S1566C23v96Ev");}
void  S1566C2 ::v97(){vfunc_called(this, "_ZN7S1566C23v97Ev");}
void  S1566C2 ::v98(){vfunc_called(this, "_ZN7S1566C23v98Ev");}
void  S1566C2 ::v99(){vfunc_called(this, "_ZN7S1566C23v99Ev");}
void  S1566C2 ::v100(){vfunc_called(this, "_ZN7S1566C24v100Ev");}
void  S1566C2 ::v101(){vfunc_called(this, "_ZN7S1566C24v101Ev");}
void  S1566C2 ::v102(){vfunc_called(this, "_ZN7S1566C24v102Ev");}
S1566C2 ::S1566C2(){ note_ctor("S1566C2", this);} // tgen

static void Test_S1566C2()
{
  extern Class_Descriptor cd_S1566C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3084,5089)];
    init_test(&cd_S1566C2, buf);
    S1566C2 *dp, &lv = *(dp=new (buf) S1566C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24664,20352), "sizeof(S1566C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C2)");
    check_base_class_offset(lv, (S1566C4*)(S1566C3*), 0, "S1566C2");
    check_base_class_offset(lv, (S1566C6*)(S1566C3*), ABISELECT(96,60), "S1566C2");
    check_base_class_offset(lv, (S1566C3*), 0, "S1566C2");
    check_base_class_offset(lv, (S1566C7_nt*), ABISELECT(144,96), "S1566C2");
    check_field_offset(lv, s1566c2f0, ABISELECT(152,100), "S1566C2.s1566c2f0");
    check_field_offset(lv, s1566c2f1, ABISELECT(160,104), "S1566C2.s1566c2f1");
    check_field_offset(lv, s1566c2f2, ABISELECT(168,108), "S1566C2.s1566c2f2");
    check_field_offset(lv, s1566c2f3, ABISELECT(264,176), "S1566C2.s1566c2f3");
    check_field_offset(lv, s1566c2f4, ABISELECT(272,180), "S1566C2.s1566c2f4");
    check_field_offset(lv, s1566c2f5, ABISELECT(296,204), "S1566C2.s1566c2f5");
    check_field_offset(lv, s1566c2f6, ABISELECT(312,216), "S1566C2.s1566c2f6");
    check_field_offset(lv, s1566c2f7, ABISELECT(328,228), "S1566C2.s1566c2f7");
    check_field_offset(lv, s1566c2f8, ABISELECT(344,240), "S1566C2.s1566c2f8");
    check_field_offset(lv, s1566c2f9, ABISELECT(360,252), "S1566C2.s1566c2f9");
    check_field_offset(lv, s1566c2f10, ABISELECT(376,264), "S1566C2.s1566c2f10");
    check_field_offset(lv, s1566c2f11, ABISELECT(392,276), "S1566C2.s1566c2f11");
    check_field_offset(lv, s1566c2f12, ABISELECT(416,300), "S1566C2.s1566c2f12");
    check_field_offset(lv, s1566c2f13, ABISELECT(424,308), "S1566C2.s1566c2f13");
    check_field_offset(lv, s1566c2f14, ABISELECT(432,316), "S1566C2.s1566c2f14");
    check_field_offset(lv, s1566c2f15, ABISELECT(440,324), "S1566C2.s1566c2f15");
    check_field_offset(lv, s1566c2f16, ABISELECT(448,332), "S1566C2.s1566c2f16");
    check_field_offset(lv, s1566c2f17, ABISELECT(456,336), "S1566C2.s1566c2f17");
    check_field_offset(lv, s1566c2f18, ABISELECT(648,512), "S1566C2.s1566c2f18");
    check_field_offset(lv, s1566c2f19, ABISELECT(656,520), "S1566C2.s1566c2f19");
    check_field_offset(lv, s1566c2f20, ABISELECT(680,544), "S1566C2.s1566c2f20");
    check_field_offset(lv, s1566c2f21, ABISELECT(712,576), "S1566C2.s1566c2f21");
    check_field_offset(lv, s1566c2f22, ABISELECT(720,580), "S1566C2.s1566c2f22");
    check_field_offset(lv, s1566c2f23, ABISELECT(864,716), "S1566C2.s1566c2f23");
    check_field_offset(lv, s1566c2f24, ABISELECT(2912,2764), "S1566C2.s1566c2f24");
    check_field_offset(lv, s1566c2f25, ABISELECT(3952,3800), "S1566C2.s1566c2f25");
    check_field_offset(lv, s1566c2f26, ABISELECT(12136,7892), "S1566C2.s1566c2f26");
    check_field_offset(lv, s1566c2f27, ABISELECT(24416,20168), "S1566C2.s1566c2f27");
    check_field_offset(lv, s1566c2f28, ABISELECT(24432,20180), "S1566C2.s1566c2f28");
    check_field_offset(lv, s1566c2f29, ABISELECT(24448,20192), "S1566C2.s1566c2f29");
    check_field_offset(lv, s1566c2f30, ABISELECT(24464,20204), "S1566C2.s1566c2f30");
    check_field_offset(lv, s1566c2f31, ABISELECT(24480,20216), "S1566C2.s1566c2f31");
    check_field_offset(lv, s1566c2f32, ABISELECT(24512,20236), "S1566C2.s1566c2f32");
    check_field_offset(lv, s1566c2f33, ABISELECT(24520,20240), "S1566C2.s1566c2f33");
    check_field_offset(lv, s1566c2f34, ABISELECT(24536,20252), "S1566C2.s1566c2f34");
    check_field_offset(lv, s1566c2f35, ABISELECT(24552,20264), "S1566C2.s1566c2f35");
    check_field_offset(lv, s1566c2f36, ABISELECT(24560,20272), "S1566C2.s1566c2f36");
    check_field_offset(lv, s1566c2f37, ABISELECT(24576,20284), "S1566C2.s1566c2f37");
    check_field_offset(lv, s1566c2f38, ABISELECT(24592,20296), "S1566C2.s1566c2f38");
    check_field_offset(lv, s1566c2f39, ABISELECT(24608,20308), "S1566C2.s1566c2f39");
    check_field_offset(lv, s1566c2f40, ABISELECT(24624,20316), "S1566C2.s1566c2f40");
    check_field_offset(lv, s1566c2f41, ABISELECT(24628,20320), "S1566C2.s1566c2f41");
    check_field_offset(lv, s1566c2f42, ABISELECT(24648,20340), "S1566C2.s1566c2f42");
    test_class_info(&lv, &cd_S1566C2);
    dp->~S1566C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C2(Test_S1566C2, "S1566C2", ABISELECT(24664,20352));

#else // __cplusplus

extern void _ZN7S1566C2C1Ev();
extern void _ZN7S1566C2D1Ev();
Name_Map name_map_S1566C2[] = {
  NSPAIR(_ZN7S1566C2C1Ev),
  NSPAIR(_ZN7S1566C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1566C4;
extern VTBL_ENTRY _ZTI7S1566C4[];
extern  VTBL_ENTRY _ZTV7S1566C4[];
extern Class_Descriptor cd_S1566C6;
extern VTBL_ENTRY _ZTI7S1566C6[];
extern  VTBL_ENTRY _ZTV7S1566C6[];
extern Class_Descriptor cd_S1566C3;
extern VTBL_ENTRY _ZTI7S1566C3[];
extern  VTBL_ENTRY _ZTV7S1566C3[];
extern Class_Descriptor cd_S1566C7_nt;
extern VTBL_ENTRY _ZTI10S1566C7_nt[];
extern  VTBL_ENTRY _ZTV10S1566C7_nt[];
static Base_Class bases_S1566C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1566C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1566C6,    ABISELECT(96,60), //bcp->offset
    95, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1566C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1566C7_nt,    ABISELECT(144,96), //bcp->offset
    98, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1566C2[];
extern void _ZN7S1566C2D1Ev();
extern void _ZN7S1566C2D0Ev();
extern void _ZN7S1566C42v8Ev();
extern void _ZN7S1566C42v9Ev();
extern void _ZN7S1566C43v10Ev();
extern void _ZN7S1566C43v11Ev();
extern void _ZN7S1566C43v12Ev();
extern void _ZN7S1566C43v13Ev();
extern void _ZN7S1566C43v14Ev();
extern void _ZN7S1566C43v15Ev();
extern void _ZN7S1566C43v16Ev();
extern void _ZN7S1566C43v17Ev();
extern void _ZN7S1566C43v18Ev();
extern void _ZN7S1566C43v19Ev();
extern void _ZN7S1566C43v20Ev();
extern void _ZN7S1566C43v21Ev();
extern void _ZN7S1566C43v22Ev();
extern void _ZN7S1566C43v23Ev();
extern void _ZN7S1566C43v24Ev();
extern void _ZN7S1566C43v25Ev();
extern void _ZN7S1566C43v26Ev();
extern void _ZN7S1566C43v27Ev();
extern void _ZN7S1566C43v28Ev();
extern void _ZN7S1566C43v29Ev();
extern void _ZN7S1566C43v30Ev();
extern void _ZN7S1566C43v31Ev();
extern void _ZN7S1566C43v32Ev();
extern void _ZN7S1566C43v33Ev();
extern void _ZN7S1566C43v34Ev();
extern void _ZN7S1566C43v35Ev();
extern void _ZN7S1566C43v36Ev();
extern void _ZN7S1566C43v37Ev();
extern void _ZN7S1566C43v38Ev();
extern void _ZN7S1566C43v39Ev();
extern void _ZN7S1566C43v40Ev();
extern void _ZN7S1566C43v41Ev();
extern void _ZN7S1566C43v42Ev();
extern void _ZN7S1566C43v43Ev();
extern void _ZN7S1566C43v44Ev();
extern void _ZN7S1566C43v45Ev();
extern void _ZN7S1566C43v46Ev();
extern void _ZN7S1566C43v47Ev();
extern void _ZN7S1566C43v48Ev();
extern void _ZN7S1566C43v49Ev();
extern void _ZN7S1566C43v50Ev();
extern void _ZN7S1566C43v51Ev();
extern void _ZN7S1566C43v52Ev();
extern void _ZN7S1566C43v53Ev();
extern void _ZN7S1566C43v54Ev();
extern void _ZN7S1566C43v55Ev();
extern void _ZN7S1566C43v56Ev();
extern void _ZN7S1566C43v57Ev();
extern void _ZN7S1566C43v58Ev();
extern void _ZN7S1566C43v59Ev();
extern void _ZN7S1566C43v60Ev();
extern void _ZN7S1566C43v61Ev();
extern void _ZN7S1566C43v62Ev();
extern void _ZN7S1566C43v63Ev();
extern void _ZN7S1566C43v64Ev();
extern void _ZN7S1566C43v65Ev();
extern void _ZN7S1566C43v66Ev();
extern void _ZN7S1566C43v67Ev();
extern void _ZN7S1566C43v68Ev();
extern void _ZN7S1566C43v69Ev();
extern void _ZN7S1566C43v70Ev();
extern void _ZN7S1566C43v71Ev();
extern void _ZN7S1566C33v73Ev();
extern void _ZN7S1566C33v74Ev();
extern void _ZN7S1566C33v75Ev();
extern void _ZN7S1566C33v76Ev();
extern void _ZN7S1566C23v80Ev();
extern void _ZN7S1566C23v81Ev();
extern void _ZN7S1566C23v82Ev();
extern void _ZN7S1566C23v83Ev();
extern void _ZN7S1566C23v84Ev();
extern void _ZN7S1566C23v85Ev();
extern void _ZN7S1566C23v86Ev();
extern void _ZN7S1566C23v87Ev();
extern void _ZN7S1566C23v88Ev();
extern void _ZN7S1566C23v89Ev();
extern void _ZN7S1566C23v90Ev();
extern void _ZN7S1566C23v91Ev();
extern void _ZN7S1566C23v92Ev();
extern void _ZN7S1566C23v93Ev();
extern void _ZN7S1566C23v94Ev();
extern void _ZN7S1566C23v95Ev();
extern void _ZN7S1566C23v96Ev();
extern void _ZN7S1566C23v97Ev();
extern void _ZN7S1566C23v98Ev();
extern void _ZN7S1566C23v99Ev();
extern void _ZN7S1566C24v100Ev();
extern void _ZN7S1566C24v101Ev();
extern void _ZN7S1566C24v102Ev();
extern void _ZN7S1566C63v72Ev();
extern void ABISELECT(_ZThn144_N7S1566C2D1Ev,_ZThn96_N7S1566C2D1Ev)();
extern void ABISELECT(_ZThn144_N7S1566C2D0Ev,_ZThn96_N7S1566C2D0Ev)();
extern void _ZN10S1566C7_nt3v77Ev();
extern void _ZN10S1566C7_nt3v78Ev();
extern void _ZN10S1566C7_nt3v79Ev();
static  VTBL_ENTRY vtc_S1566C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1566C2[0]),
  (VTBL_ENTRY)&_ZN7S1566C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1566C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1566C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1566C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v80Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1566C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1566C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1566C24v102Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1566C2[0]),
  (VTBL_ENTRY)&_ZN7S1566C63v72Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI7S1566C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1566C2D1Ev,_ZThn96_N7S1566C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1566C2D0Ev,_ZThn96_N7S1566C2D0Ev),
  (VTBL_ENTRY)&_ZN10S1566C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1566C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1566C7_nt3v79Ev,
};
extern VTBL_ENTRY _ZTI7S1566C2[];
extern  VTBL_ENTRY _ZTV7S1566C2[];
Class_Descriptor cd_S1566C2 = {  "S1566C2", // class name
  bases_S1566C2, 4,
  &(vtc_S1566C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24664,20352), // object size
  NSPAIRA(_ZTI7S1566C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1566C2),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C34_nt  {
  int s1566c34f0;
};
//SIG(-1 S1566C34_nt) C1{ Fi}



//skip512 S1566C34_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S1566C34_nt[];
VTBL_ENTRY *P__ZTI11S1566C34_nt = _ZTI11S1566C34_nt; 
Class_Descriptor cd_S1566C34_nt = {  "S1566C34_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI11S1566C34_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C33  {
  char s1566c33f0[2];
  short s1566c33f1;
  ::S1566C34_nt s1566c33f2;
  char s1566c33f3[8];
};
//SIG(-1 S1566C33) C1{ Fc[2] Fs FC2{ Fi} Fc[8]}



static void Test_S1566C33()
{
  {
    init_simple_test("S1566C33");
    S1566C33 lv;
    check2(sizeof(lv), 16, "sizeof(S1566C33)");
    check2(__alignof__(lv), 4, "__alignof__(S1566C33)");
    check_field_offset(lv, s1566c33f0, 0, "S1566C33.s1566c33f0");
    check_field_offset(lv, s1566c33f1, 2, "S1566C33.s1566c33f1");
    check_field_offset(lv, s1566c33f2, 4, "S1566C33.s1566c33f2");
    check_field_offset(lv, s1566c33f3, 8, "S1566C33.s1566c33f3");
  }
}
static Arrange_To_Call_Me vS1566C33(Test_S1566C33, "S1566C33", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C32  {
  ::S1566C33 s1566c32f0;
  void  mf1566c32(); // _ZN8S1566C329mf1566c32Ev
};
//SIG(-1 S1566C32) C1{ m FC2{ Fc[2] Fs FC3{ Fi} Fc[8]}}


void  S1566C32 ::mf1566c32(){}

static void Test_S1566C32()
{
  {
    init_simple_test("S1566C32");
    S1566C32 lv;
    check2(sizeof(lv), 16, "sizeof(S1566C32)");
    check2(__alignof__(lv), 4, "__alignof__(S1566C32)");
    check_field_offset(lv, s1566c32f0, 0, "S1566C32.s1566c32f0");
  }
}
static Arrange_To_Call_Me vS1566C32(Test_S1566C32, "S1566C32", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1566C1  : S1566C2 {
  ::S1566C32 s1566c1f0;
  void *s1566c1f1;
  int s1566c1f2;
  void *s1566c1f3;
  virtual  ~S1566C1(); // _ZN7S1566C1D1Ev
  virtual void  v1(); // _ZN7S1566C12v1Ev
  virtual void  v2(); // _ZN7S1566C12v2Ev
  virtual void  v3(); // _ZN7S1566C12v3Ev
  virtual void  v4(); // _ZN7S1566C12v4Ev
  virtual void  v5(); // _ZN7S1566C12v5Ev
  virtual void  v6(); // _ZN7S1566C12v6Ev
  virtual void  v7(); // _ZN7S1566C12v7Ev
  S1566C1(); // tgen
};
//SIG(1 S1566C1) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v72} vd v73 v74 v75 v76 Fp Fi[7]} BC7{ vd v77 v78 v79} vd v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 Fp Fi FC8{ m FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 Fi FC9 FC12{ BC11} FC9 Fi} Fp Fi[6] FC13{ BC14{ BC11}} FC13 Fi[3] FC15{ BC9} FC13 FC13 FL[3] Fi[2] FC16{ m Fi[2]} FC16 Fi[2] Fp FC17{ BC18{ BC19{ vd v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 Fi[28]} v130 v131 v132 FC20{ BC11} Fi[2]} v103 v104 Fp[2] FL Fi[5] Fc[3]} FL Fi[6] FL[4] Fi FC18 FL[256] Fi[259] Fp[1023] Fi[3069] FC21{ BC11} FC21 FC22{ BC11} FC23{ BC11} FC24{ BC25{ m FC26{ BC11} Fp Fi}} Fp FC27{ BC11} FC28{ BC11} FC5 FC12 FC10 FC29{ BC11} Fp[2] Fi FC30{ m Fi[5]} FC29} vd v1 v2 v3 v4 v5 v6 v7 FC31{ m FC32{ Fc[2] Fs FC33{ Fi} Fc[8]}} Fp Fi Fp}


 S1566C1 ::~S1566C1(){ note_dtor("S1566C1", this);}
void  S1566C1 ::v1(){vfunc_called(this, "_ZN7S1566C12v1Ev");}
void  S1566C1 ::v2(){vfunc_called(this, "_ZN7S1566C12v2Ev");}
void  S1566C1 ::v3(){vfunc_called(this, "_ZN7S1566C12v3Ev");}
void  S1566C1 ::v4(){vfunc_called(this, "_ZN7S1566C12v4Ev");}
void  S1566C1 ::v5(){vfunc_called(this, "_ZN7S1566C12v5Ev");}
void  S1566C1 ::v6(){vfunc_called(this, "_ZN7S1566C12v6Ev");}
void  S1566C1 ::v7(){vfunc_called(this, "_ZN7S1566C12v7Ev");}
S1566C1 ::S1566C1(){ note_ctor("S1566C1", this);} // tgen

static void Test_S1566C1()
{
  extern Class_Descriptor cd_S1566C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3089,5096)];
    init_test(&cd_S1566C1, buf);
    S1566C1 *dp, &lv = *(dp=new (buf) S1566C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24704,20380), "sizeof(S1566C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1566C1)");
    check_base_class_offset(lv, (S1566C4*)(S1566C3*)(S1566C2*), 0, "S1566C1");
    check_base_class_offset(lv, (S1566C6*)(S1566C3*)(S1566C2*), ABISELECT(96,60), "S1566C1");
    check_base_class_offset(lv, (S1566C3*)(S1566C2*), 0, "S1566C1");
    check_base_class_offset(lv, (S1566C7_nt*)(S1566C2*), ABISELECT(144,96), "S1566C1");
    check_base_class_offset(lv, (S1566C2*), 0, "S1566C1");
    check_field_offset(lv, s1566c1f0, ABISELECT(24664,20352), "S1566C1.s1566c1f0");
    check_field_offset(lv, s1566c1f1, ABISELECT(24680,20368), "S1566C1.s1566c1f1");
    check_field_offset(lv, s1566c1f2, ABISELECT(24688,20372), "S1566C1.s1566c1f2");
    check_field_offset(lv, s1566c1f3, ABISELECT(24696,20376), "S1566C1.s1566c1f3");
    test_class_info(&lv, &cd_S1566C1);
    dp->~S1566C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1566C1(Test_S1566C1, "S1566C1", ABISELECT(24704,20380));

#else // __cplusplus

extern void _ZN7S1566C1C1Ev();
extern void _ZN7S1566C1D1Ev();
Name_Map name_map_S1566C1[] = {
  NSPAIR(_ZN7S1566C1C1Ev),
  NSPAIR(_ZN7S1566C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1566C4;
extern VTBL_ENTRY _ZTI7S1566C4[];
extern  VTBL_ENTRY _ZTV7S1566C4[];
extern Class_Descriptor cd_S1566C6;
extern VTBL_ENTRY _ZTI7S1566C6[];
extern  VTBL_ENTRY _ZTV7S1566C6[];
extern Class_Descriptor cd_S1566C3;
extern VTBL_ENTRY _ZTI7S1566C3[];
extern  VTBL_ENTRY _ZTV7S1566C3[];
extern Class_Descriptor cd_S1566C7_nt;
extern VTBL_ENTRY _ZTI10S1566C7_nt[];
extern  VTBL_ENTRY _ZTV10S1566C7_nt[];
extern Class_Descriptor cd_S1566C2;
extern VTBL_ENTRY _ZTI7S1566C2[];
extern  VTBL_ENTRY _ZTV7S1566C2[];
static Base_Class bases_S1566C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1566C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1566C6,    ABISELECT(96,60), //bcp->offset
    102, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1566C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1566C7_nt,    ABISELECT(144,96), //bcp->offset
    105, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1566C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1566C1[];
extern void _ZN7S1566C1D1Ev();
extern void _ZN7S1566C1D0Ev();
extern void _ZN7S1566C42v8Ev();
extern void _ZN7S1566C42v9Ev();
extern void _ZN7S1566C43v10Ev();
extern void _ZN7S1566C43v11Ev();
extern void _ZN7S1566C43v12Ev();
extern void _ZN7S1566C43v13Ev();
extern void _ZN7S1566C43v14Ev();
extern void _ZN7S1566C43v15Ev();
extern void _ZN7S1566C43v16Ev();
extern void _ZN7S1566C43v17Ev();
extern void _ZN7S1566C43v18Ev();
extern void _ZN7S1566C43v19Ev();
extern void _ZN7S1566C43v20Ev();
extern void _ZN7S1566C43v21Ev();
extern void _ZN7S1566C43v22Ev();
extern void _ZN7S1566C43v23Ev();
extern void _ZN7S1566C43v24Ev();
extern void _ZN7S1566C43v25Ev();
extern void _ZN7S1566C43v26Ev();
extern void _ZN7S1566C43v27Ev();
extern void _ZN7S1566C43v28Ev();
extern void _ZN7S1566C43v29Ev();
extern void _ZN7S1566C43v30Ev();
extern void _ZN7S1566C43v31Ev();
extern void _ZN7S1566C43v32Ev();
extern void _ZN7S1566C43v33Ev();
extern void _ZN7S1566C43v34Ev();
extern void _ZN7S1566C43v35Ev();
extern void _ZN7S1566C43v36Ev();
extern void _ZN7S1566C43v37Ev();
extern void _ZN7S1566C43v38Ev();
extern void _ZN7S1566C43v39Ev();
extern void _ZN7S1566C43v40Ev();
extern void _ZN7S1566C43v41Ev();
extern void _ZN7S1566C43v42Ev();
extern void _ZN7S1566C43v43Ev();
extern void _ZN7S1566C43v44Ev();
extern void _ZN7S1566C43v45Ev();
extern void _ZN7S1566C43v46Ev();
extern void _ZN7S1566C43v47Ev();
extern void _ZN7S1566C43v48Ev();
extern void _ZN7S1566C43v49Ev();
extern void _ZN7S1566C43v50Ev();
extern void _ZN7S1566C43v51Ev();
extern void _ZN7S1566C43v52Ev();
extern void _ZN7S1566C43v53Ev();
extern void _ZN7S1566C43v54Ev();
extern void _ZN7S1566C43v55Ev();
extern void _ZN7S1566C43v56Ev();
extern void _ZN7S1566C43v57Ev();
extern void _ZN7S1566C43v58Ev();
extern void _ZN7S1566C43v59Ev();
extern void _ZN7S1566C43v60Ev();
extern void _ZN7S1566C43v61Ev();
extern void _ZN7S1566C43v62Ev();
extern void _ZN7S1566C43v63Ev();
extern void _ZN7S1566C43v64Ev();
extern void _ZN7S1566C43v65Ev();
extern void _ZN7S1566C43v66Ev();
extern void _ZN7S1566C43v67Ev();
extern void _ZN7S1566C43v68Ev();
extern void _ZN7S1566C43v69Ev();
extern void _ZN7S1566C43v70Ev();
extern void _ZN7S1566C43v71Ev();
extern void _ZN7S1566C33v73Ev();
extern void _ZN7S1566C33v74Ev();
extern void _ZN7S1566C33v75Ev();
extern void _ZN7S1566C33v76Ev();
extern void _ZN7S1566C23v80Ev();
extern void _ZN7S1566C23v81Ev();
extern void _ZN7S1566C23v82Ev();
extern void _ZN7S1566C23v83Ev();
extern void _ZN7S1566C23v84Ev();
extern void _ZN7S1566C23v85Ev();
extern void _ZN7S1566C23v86Ev();
extern void _ZN7S1566C23v87Ev();
extern void _ZN7S1566C23v88Ev();
extern void _ZN7S1566C23v89Ev();
extern void _ZN7S1566C23v90Ev();
extern void _ZN7S1566C23v91Ev();
extern void _ZN7S1566C23v92Ev();
extern void _ZN7S1566C23v93Ev();
extern void _ZN7S1566C23v94Ev();
extern void _ZN7S1566C23v95Ev();
extern void _ZN7S1566C23v96Ev();
extern void _ZN7S1566C23v97Ev();
extern void _ZN7S1566C23v98Ev();
extern void _ZN7S1566C23v99Ev();
extern void _ZN7S1566C24v100Ev();
extern void _ZN7S1566C24v101Ev();
extern void _ZN7S1566C24v102Ev();
extern void _ZN7S1566C12v1Ev();
extern void _ZN7S1566C12v2Ev();
extern void _ZN7S1566C12v3Ev();
extern void _ZN7S1566C12v4Ev();
extern void _ZN7S1566C12v5Ev();
extern void _ZN7S1566C12v6Ev();
extern void _ZN7S1566C12v7Ev();
extern void _ZN7S1566C63v72Ev();
extern void ABISELECT(_ZThn144_N7S1566C1D1Ev,_ZThn96_N7S1566C1D1Ev)();
extern void ABISELECT(_ZThn144_N7S1566C1D0Ev,_ZThn96_N7S1566C1D0Ev)();
extern void _ZN10S1566C7_nt3v77Ev();
extern void _ZN10S1566C7_nt3v78Ev();
extern void _ZN10S1566C7_nt3v79Ev();
static  VTBL_ENTRY vtc_S1566C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1566C1[0]),
  (VTBL_ENTRY)&_ZN7S1566C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1566C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1566C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1566C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1566C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1566C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v80Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1566C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1566C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1566C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1566C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1566C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1566C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1566C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1566C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1566C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1566C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1566C12v7Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1566C1[0]),
  (VTBL_ENTRY)&_ZN7S1566C63v72Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI7S1566C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1566C1D1Ev,_ZThn96_N7S1566C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1566C1D0Ev,_ZThn96_N7S1566C1D0Ev),
  (VTBL_ENTRY)&_ZN10S1566C7_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1566C7_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1566C7_nt3v79Ev,
};
extern VTBL_ENTRY _ZTI7S1566C1[];
extern  VTBL_ENTRY _ZTV7S1566C1[];
Class_Descriptor cd_S1566C1 = {  "S1566C1", // class name
  bases_S1566C1, 5,
  &(vtc_S1566C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24704,20380), // object size
  NSPAIRA(_ZTI7S1566C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1566C1),112, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1319C4  {
  int s1319c4f0;
  __tsi64 s1319c4f1;
  void *s1319c4f2[4];
  int s1319c4f3[2];
  void *s1319c4f4;
  ::S1566C14_nt s1319c4f5;
  void *s1319c4f6[2];
  virtual  ~S1319C4(); // _ZN7S1319C4D1Ev
  virtual void  v16(); // _ZN7S1319C43v16Ev
  virtual void  v17(); // _ZN7S1319C43v17Ev
  virtual void  v18(); // _ZN7S1319C43v18Ev
  virtual void  v19(); // _ZN7S1319C43v19Ev
  virtual void  v20(); // _ZN7S1319C43v20Ev
  virtual void  v21(); // _ZN7S1319C43v21Ev
  virtual void  v22(); // _ZN7S1319C43v22Ev
  virtual void  v23(); // _ZN7S1319C43v23Ev
  virtual void  v24(); // _ZN7S1319C43v24Ev
  virtual void  v25(); // _ZN7S1319C43v25Ev
  virtual void  v26(); // _ZN7S1319C43v26Ev
  virtual void  v27(); // _ZN7S1319C43v27Ev
  virtual void  v28(); // _ZN7S1319C43v28Ev
  virtual void  v29(); // _ZN7S1319C43v29Ev
  virtual void  v30(); // _ZN7S1319C43v30Ev
  virtual void  v31(); // _ZN7S1319C43v31Ev
  virtual void  v32(); // _ZN7S1319C43v32Ev
  virtual void  v33(); // _ZN7S1319C43v33Ev
  virtual void  v34(); // _ZN7S1319C43v34Ev
  virtual void  v35(); // _ZN7S1319C43v35Ev
  virtual void  v36(); // _ZN7S1319C43v36Ev
  virtual void  v37(); // _ZN7S1319C43v37Ev
  virtual void  v38(); // _ZN7S1319C43v38Ev
  virtual void  v39(); // _ZN7S1319C43v39Ev
  virtual void  v40(); // _ZN7S1319C43v40Ev
  virtual void  v41(); // _ZN7S1319C43v41Ev
  virtual void  v42(); // _ZN7S1319C43v42Ev
  virtual void  v43(); // _ZN7S1319C43v43Ev
  virtual void  v44(); // _ZN7S1319C43v44Ev
  virtual void  v45(); // _ZN7S1319C43v45Ev
  virtual void  v46(); // _ZN7S1319C43v46Ev
  virtual void  v47(); // _ZN7S1319C43v47Ev
  virtual void  v48(); // _ZN7S1319C43v48Ev
  virtual void  v49(); // _ZN7S1319C43v49Ev
  virtual void  v50(); // _ZN7S1319C43v50Ev
  virtual void  v51(); // _ZN7S1319C43v51Ev
  virtual void  v52(); // _ZN7S1319C43v52Ev
  virtual void  v53(); // _ZN7S1319C43v53Ev
  virtual void  v54(); // _ZN7S1319C43v54Ev
  virtual void  v55(); // _ZN7S1319C43v55Ev
  virtual void  v56(); // _ZN7S1319C43v56Ev
  virtual void  v57(); // _ZN7S1319C43v57Ev
  virtual void  v58(); // _ZN7S1319C43v58Ev
  virtual void  v59(); // _ZN7S1319C43v59Ev
  virtual void  v60(); // _ZN7S1319C43v60Ev
  virtual void  v61(); // _ZN7S1319C43v61Ev
  virtual void  v62(); // _ZN7S1319C43v62Ev
  virtual void  v63(); // _ZN7S1319C43v63Ev
  virtual void  v64(); // _ZN7S1319C43v64Ev
  virtual void  v65(); // _ZN7S1319C43v65Ev
  virtual void  v66(); // _ZN7S1319C43v66Ev
  virtual void  v67(); // _ZN7S1319C43v67Ev
  virtual void  v68(); // _ZN7S1319C43v68Ev
  virtual void  v69(); // _ZN7S1319C43v69Ev
  virtual void  v70(); // _ZN7S1319C43v70Ev
  virtual void  v71(); // _ZN7S1319C43v71Ev
  virtual void  v72(); // _ZN7S1319C43v72Ev
  virtual void  v73(); // _ZN7S1319C43v73Ev
  virtual void  v74(); // _ZN7S1319C43v74Ev
  virtual void  v75(); // _ZN7S1319C43v75Ev
  virtual void  v76(); // _ZN7S1319C43v76Ev
  virtual void  v77(); // _ZN7S1319C43v77Ev
  virtual void  v78(); // _ZN7S1319C43v78Ev
  virtual void  v79(); // _ZN7S1319C43v79Ev
  S1319C4(); // tgen
};
//SIG(-1 S1319C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1319C4 ::~S1319C4(){ note_dtor("S1319C4", this);}
void  S1319C4 ::v16(){vfunc_called(this, "_ZN7S1319C43v16Ev");}
void  S1319C4 ::v17(){vfunc_called(this, "_ZN7S1319C43v17Ev");}
void  S1319C4 ::v18(){vfunc_called(this, "_ZN7S1319C43v18Ev");}
void  S1319C4 ::v19(){vfunc_called(this, "_ZN7S1319C43v19Ev");}
void  S1319C4 ::v20(){vfunc_called(this, "_ZN7S1319C43v20Ev");}
void  S1319C4 ::v21(){vfunc_called(this, "_ZN7S1319C43v21Ev");}
void  S1319C4 ::v22(){vfunc_called(this, "_ZN7S1319C43v22Ev");}
void  S1319C4 ::v23(){vfunc_called(this, "_ZN7S1319C43v23Ev");}
void  S1319C4 ::v24(){vfunc_called(this, "_ZN7S1319C43v24Ev");}
void  S1319C4 ::v25(){vfunc_called(this, "_ZN7S1319C43v25Ev");}
void  S1319C4 ::v26(){vfunc_called(this, "_ZN7S1319C43v26Ev");}
void  S1319C4 ::v27(){vfunc_called(this, "_ZN7S1319C43v27Ev");}
void  S1319C4 ::v28(){vfunc_called(this, "_ZN7S1319C43v28Ev");}
void  S1319C4 ::v29(){vfunc_called(this, "_ZN7S1319C43v29Ev");}
void  S1319C4 ::v30(){vfunc_called(this, "_ZN7S1319C43v30Ev");}
void  S1319C4 ::v31(){vfunc_called(this, "_ZN7S1319C43v31Ev");}
void  S1319C4 ::v32(){vfunc_called(this, "_ZN7S1319C43v32Ev");}
void  S1319C4 ::v33(){vfunc_called(this, "_ZN7S1319C43v33Ev");}
void  S1319C4 ::v34(){vfunc_called(this, "_ZN7S1319C43v34Ev");}
void  S1319C4 ::v35(){vfunc_called(this, "_ZN7S1319C43v35Ev");}
void  S1319C4 ::v36(){vfunc_called(this, "_ZN7S1319C43v36Ev");}
void  S1319C4 ::v37(){vfunc_called(this, "_ZN7S1319C43v37Ev");}
void  S1319C4 ::v38(){vfunc_called(this, "_ZN7S1319C43v38Ev");}
void  S1319C4 ::v39(){vfunc_called(this, "_ZN7S1319C43v39Ev");}
void  S1319C4 ::v40(){vfunc_called(this, "_ZN7S1319C43v40Ev");}
void  S1319C4 ::v41(){vfunc_called(this, "_ZN7S1319C43v41Ev");}
void  S1319C4 ::v42(){vfunc_called(this, "_ZN7S1319C43v42Ev");}
void  S1319C4 ::v43(){vfunc_called(this, "_ZN7S1319C43v43Ev");}
void  S1319C4 ::v44(){vfunc_called(this, "_ZN7S1319C43v44Ev");}
void  S1319C4 ::v45(){vfunc_called(this, "_ZN7S1319C43v45Ev");}
void  S1319C4 ::v46(){vfunc_called(this, "_ZN7S1319C43v46Ev");}
void  S1319C4 ::v47(){vfunc_called(this, "_ZN7S1319C43v47Ev");}
void  S1319C4 ::v48(){vfunc_called(this, "_ZN7S1319C43v48Ev");}
void  S1319C4 ::v49(){vfunc_called(this, "_ZN7S1319C43v49Ev");}
void  S1319C4 ::v50(){vfunc_called(this, "_ZN7S1319C43v50Ev");}
void  S1319C4 ::v51(){vfunc_called(this, "_ZN7S1319C43v51Ev");}
void  S1319C4 ::v52(){vfunc_called(this, "_ZN7S1319C43v52Ev");}
void  S1319C4 ::v53(){vfunc_called(this, "_ZN7S1319C43v53Ev");}
void  S1319C4 ::v54(){vfunc_called(this, "_ZN7S1319C43v54Ev");}
void  S1319C4 ::v55(){vfunc_called(this, "_ZN7S1319C43v55Ev");}
void  S1319C4 ::v56(){vfunc_called(this, "_ZN7S1319C43v56Ev");}
void  S1319C4 ::v57(){vfunc_called(this, "_ZN7S1319C43v57Ev");}
void  S1319C4 ::v58(){vfunc_called(this, "_ZN7S1319C43v58Ev");}
void  S1319C4 ::v59(){vfunc_called(this, "_ZN7S1319C43v59Ev");}
void  S1319C4 ::v60(){vfunc_called(this, "_ZN7S1319C43v60Ev");}
void  S1319C4 ::v61(){vfunc_called(this, "_ZN7S1319C43v61Ev");}
void  S1319C4 ::v62(){vfunc_called(this, "_ZN7S1319C43v62Ev");}
void  S1319C4 ::v63(){vfunc_called(this, "_ZN7S1319C43v63Ev");}
void  S1319C4 ::v64(){vfunc_called(this, "_ZN7S1319C43v64Ev");}
void  S1319C4 ::v65(){vfunc_called(this, "_ZN7S1319C43v65Ev");}
void  S1319C4 ::v66(){vfunc_called(this, "_ZN7S1319C43v66Ev");}
void  S1319C4 ::v67(){vfunc_called(this, "_ZN7S1319C43v67Ev");}
void  S1319C4 ::v68(){vfunc_called(this, "_ZN7S1319C43v68Ev");}
void  S1319C4 ::v69(){vfunc_called(this, "_ZN7S1319C43v69Ev");}
void  S1319C4 ::v70(){vfunc_called(this, "_ZN7S1319C43v70Ev");}
void  S1319C4 ::v71(){vfunc_called(this, "_ZN7S1319C43v71Ev");}
void  S1319C4 ::v72(){vfunc_called(this, "_ZN7S1319C43v72Ev");}
void  S1319C4 ::v73(){vfunc_called(this, "_ZN7S1319C43v73Ev");}
void  S1319C4 ::v74(){vfunc_called(this, "_ZN7S1319C43v74Ev");}
void  S1319C4 ::v75(){vfunc_called(this, "_ZN7S1319C43v75Ev");}
void  S1319C4 ::v76(){vfunc_called(this, "_ZN7S1319C43v76Ev");}
void  S1319C4 ::v77(){vfunc_called(this, "_ZN7S1319C43v77Ev");}
void  S1319C4 ::v78(){vfunc_called(this, "_ZN7S1319C43v78Ev");}
void  S1319C4 ::v79(){vfunc_called(this, "_ZN7S1319C43v79Ev");}
S1319C4 ::S1319C4(){ note_ctor("S1319C4", this);} // tgen

static void Test_S1319C4()
{
  extern Class_Descriptor cd_S1319C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1319C4, buf);
    S1319C4 *dp, &lv = *(dp=new (buf) S1319C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1319C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1319C4)");
    check_field_offset(lv, s1319c4f0, ABISELECT(8,4), "S1319C4.s1319c4f0");
    check_field_offset(lv, s1319c4f1, ABISELECT(16,8), "S1319C4.s1319c4f1");
    check_field_offset(lv, s1319c4f2, ABISELECT(24,16), "S1319C4.s1319c4f2");
    check_field_offset(lv, s1319c4f3, ABISELECT(56,32), "S1319C4.s1319c4f3");
    check_field_offset(lv, s1319c4f4, ABISELECT(64,40), "S1319C4.s1319c4f4");
    check_field_offset(lv, s1319c4f5, ABISELECT(72,44), "S1319C4.s1319c4f5");
    check_field_offset(lv, s1319c4f6, ABISELECT(80,52), "S1319C4.s1319c4f6");
    test_class_info(&lv, &cd_S1319C4);
    dp->~S1319C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1319C4(Test_S1319C4, "S1319C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1319C4C1Ev();
extern void _ZN7S1319C4D1Ev();
Name_Map name_map_S1319C4[] = {
  NSPAIR(_ZN7S1319C4C1Ev),
  NSPAIR(_ZN7S1319C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1319C4[];
extern void _ZN7S1319C4D1Ev();
extern void _ZN7S1319C4D0Ev();
extern void _ZN7S1319C43v16Ev();
extern void _ZN7S1319C43v17Ev();
extern void _ZN7S1319C43v18Ev();
extern void _ZN7S1319C43v19Ev();
extern void _ZN7S1319C43v20Ev();
extern void _ZN7S1319C43v21Ev();
extern void _ZN7S1319C43v22Ev();
extern void _ZN7S1319C43v23Ev();
extern void _ZN7S1319C43v24Ev();
extern void _ZN7S1319C43v25Ev();
extern void _ZN7S1319C43v26Ev();
extern void _ZN7S1319C43v27Ev();
extern void _ZN7S1319C43v28Ev();
extern void _ZN7S1319C43v29Ev();
extern void _ZN7S1319C43v30Ev();
extern void _ZN7S1319C43v31Ev();
extern void _ZN7S1319C43v32Ev();
extern void _ZN7S1319C43v33Ev();
extern void _ZN7S1319C43v34Ev();
extern void _ZN7S1319C43v35Ev();
extern void _ZN7S1319C43v36Ev();
extern void _ZN7S1319C43v37Ev();
extern void _ZN7S1319C43v38Ev();
extern void _ZN7S1319C43v39Ev();
extern void _ZN7S1319C43v40Ev();
extern void _ZN7S1319C43v41Ev();
extern void _ZN7S1319C43v42Ev();
extern void _ZN7S1319C43v43Ev();
extern void _ZN7S1319C43v44Ev();
extern void _ZN7S1319C43v45Ev();
extern void _ZN7S1319C43v46Ev();
extern void _ZN7S1319C43v47Ev();
extern void _ZN7S1319C43v48Ev();
extern void _ZN7S1319C43v49Ev();
extern void _ZN7S1319C43v50Ev();
extern void _ZN7S1319C43v51Ev();
extern void _ZN7S1319C43v52Ev();
extern void _ZN7S1319C43v53Ev();
extern void _ZN7S1319C43v54Ev();
extern void _ZN7S1319C43v55Ev();
extern void _ZN7S1319C43v56Ev();
extern void _ZN7S1319C43v57Ev();
extern void _ZN7S1319C43v58Ev();
extern void _ZN7S1319C43v59Ev();
extern void _ZN7S1319C43v60Ev();
extern void _ZN7S1319C43v61Ev();
extern void _ZN7S1319C43v62Ev();
extern void _ZN7S1319C43v63Ev();
extern void _ZN7S1319C43v64Ev();
extern void _ZN7S1319C43v65Ev();
extern void _ZN7S1319C43v66Ev();
extern void _ZN7S1319C43v67Ev();
extern void _ZN7S1319C43v68Ev();
extern void _ZN7S1319C43v69Ev();
extern void _ZN7S1319C43v70Ev();
extern void _ZN7S1319C43v71Ev();
extern void _ZN7S1319C43v72Ev();
extern void _ZN7S1319C43v73Ev();
extern void _ZN7S1319C43v74Ev();
extern void _ZN7S1319C43v75Ev();
extern void _ZN7S1319C43v76Ev();
extern void _ZN7S1319C43v77Ev();
extern void _ZN7S1319C43v78Ev();
extern void _ZN7S1319C43v79Ev();
static  VTBL_ENTRY vtc_S1319C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1319C4[0]),
  (VTBL_ENTRY)&_ZN7S1319C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1319C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v79Ev,
};
extern VTBL_ENTRY _ZTI7S1319C4[];
extern  VTBL_ENTRY _ZTV7S1319C4[];
Class_Descriptor cd_S1319C4 = {  "S1319C4", // class name
  0,0,//no base classes
  &(vtc_S1319C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1319C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1319C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1319C6  {
  virtual void  v80(); // _ZN7S1319C63v80Ev
  ~S1319C6(); // tgen
  S1319C6(); // tgen
};
//SIG(-1 S1319C6) C1{ v1}


void  S1319C6 ::v80(){vfunc_called(this, "_ZN7S1319C63v80Ev");}
S1319C6 ::~S1319C6(){ note_dtor("S1319C6", this);} // tgen
S1319C6 ::S1319C6(){ note_ctor("S1319C6", this);} // tgen

static void Test_S1319C6()
{
  extern Class_Descriptor cd_S1319C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1319C6, buf);
    S1319C6 *dp, &lv = *(dp=new (buf) S1319C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1319C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1319C6)");
    test_class_info(&lv, &cd_S1319C6);
    dp->~S1319C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1319C6(Test_S1319C6, "S1319C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1319C6C1Ev();
extern void _ZN7S1319C6D1Ev();
Name_Map name_map_S1319C6[] = {
  NSPAIR(_ZN7S1319C6C1Ev),
  NSPAIR(_ZN7S1319C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1319C6[];
extern void _ZN7S1319C63v80Ev();
static  VTBL_ENTRY vtc_S1319C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1319C6[0]),
  (VTBL_ENTRY)&_ZN7S1319C63v80Ev,
};
extern VTBL_ENTRY _ZTI7S1319C6[];
extern  VTBL_ENTRY _ZTV7S1319C6[];
Class_Descriptor cd_S1319C6 = {  "S1319C6", // class name
  0,0,//no base classes
  &(vtc_S1319C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1319C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1319C6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1319C3  : S1319C4 , S1319C6 {
  void *s1319c3f0;
  int s1319c3f1[7];
  virtual  ~S1319C3(); // _ZN7S1319C3D1Ev
  virtual void  v81(); // _ZN7S1319C33v81Ev
  virtual void  v82(); // _ZN7S1319C33v82Ev
  virtual void  v83(); // _ZN7S1319C33v83Ev
  virtual void  v84(); // _ZN7S1319C33v84Ev
  S1319C3(); // tgen
};
//SIG(-1 S1319C3) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v69} vd v1 v2 v3 v4 Fp Fi[7]}


 S1319C3 ::~S1319C3(){ note_dtor("S1319C3", this);}
void  S1319C3 ::v81(){vfunc_called(this, "_ZN7S1319C33v81Ev");}
void  S1319C3 ::v82(){vfunc_called(this, "_ZN7S1319C33v82Ev");}
void  S1319C3 ::v83(){vfunc_called(this, "_ZN7S1319C33v83Ev");}
void  S1319C3 ::v84(){vfunc_called(this, "_ZN7S1319C33v84Ev");}
S1319C3 ::S1319C3(){ note_ctor("S1319C3", this);} // tgen

static void Test_S1319C3()
{
  extern Class_Descriptor cd_S1319C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,25)];
    init_test(&cd_S1319C3, buf);
    S1319C3 *dp, &lv = *(dp=new (buf) S1319C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,96), "sizeof(S1319C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1319C3)");
    check_base_class_offset(lv, (S1319C4*), 0, "S1319C3");
    check_base_class_offset(lv, (S1319C6*), ABISELECT(96,60), "S1319C3");
    check_field_offset(lv, s1319c3f0, ABISELECT(104,64), "S1319C3.s1319c3f0");
    check_field_offset(lv, s1319c3f1, ABISELECT(112,68), "S1319C3.s1319c3f1");
    test_class_info(&lv, &cd_S1319C3);
    dp->~S1319C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1319C3(Test_S1319C3, "S1319C3", ABISELECT(144,96));

#else // __cplusplus

extern void _ZN7S1319C3C1Ev();
extern void _ZN7S1319C3D1Ev();
Name_Map name_map_S1319C3[] = {
  NSPAIR(_ZN7S1319C3C1Ev),
  NSPAIR(_ZN7S1319C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1319C4;
extern VTBL_ENTRY _ZTI7S1319C4[];
extern  VTBL_ENTRY _ZTV7S1319C4[];
extern Class_Descriptor cd_S1319C6;
extern VTBL_ENTRY _ZTI7S1319C6[];
extern  VTBL_ENTRY _ZTV7S1319C6[];
static Base_Class bases_S1319C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1319C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1319C6,    ABISELECT(96,60), //bcp->offset
    72, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1319C3[];
extern void _ZN7S1319C3D1Ev();
extern void _ZN7S1319C3D0Ev();
extern void _ZN7S1319C43v16Ev();
extern void _ZN7S1319C43v17Ev();
extern void _ZN7S1319C43v18Ev();
extern void _ZN7S1319C43v19Ev();
extern void _ZN7S1319C43v20Ev();
extern void _ZN7S1319C43v21Ev();
extern void _ZN7S1319C43v22Ev();
extern void _ZN7S1319C43v23Ev();
extern void _ZN7S1319C43v24Ev();
extern void _ZN7S1319C43v25Ev();
extern void _ZN7S1319C43v26Ev();
extern void _ZN7S1319C43v27Ev();
extern void _ZN7S1319C43v28Ev();
extern void _ZN7S1319C43v29Ev();
extern void _ZN7S1319C43v30Ev();
extern void _ZN7S1319C43v31Ev();
extern void _ZN7S1319C43v32Ev();
extern void _ZN7S1319C43v33Ev();
extern void _ZN7S1319C43v34Ev();
extern void _ZN7S1319C43v35Ev();
extern void _ZN7S1319C43v36Ev();
extern void _ZN7S1319C43v37Ev();
extern void _ZN7S1319C43v38Ev();
extern void _ZN7S1319C43v39Ev();
extern void _ZN7S1319C43v40Ev();
extern void _ZN7S1319C43v41Ev();
extern void _ZN7S1319C43v42Ev();
extern void _ZN7S1319C43v43Ev();
extern void _ZN7S1319C43v44Ev();
extern void _ZN7S1319C43v45Ev();
extern void _ZN7S1319C43v46Ev();
extern void _ZN7S1319C43v47Ev();
extern void _ZN7S1319C43v48Ev();
extern void _ZN7S1319C43v49Ev();
extern void _ZN7S1319C43v50Ev();
extern void _ZN7S1319C43v51Ev();
extern void _ZN7S1319C43v52Ev();
extern void _ZN7S1319C43v53Ev();
extern void _ZN7S1319C43v54Ev();
extern void _ZN7S1319C43v55Ev();
extern void _ZN7S1319C43v56Ev();
extern void _ZN7S1319C43v57Ev();
extern void _ZN7S1319C43v58Ev();
extern void _ZN7S1319C43v59Ev();
extern void _ZN7S1319C43v60Ev();
extern void _ZN7S1319C43v61Ev();
extern void _ZN7S1319C43v62Ev();
extern void _ZN7S1319C43v63Ev();
extern void _ZN7S1319C43v64Ev();
extern void _ZN7S1319C43v65Ev();
extern void _ZN7S1319C43v66Ev();
extern void _ZN7S1319C43v67Ev();
extern void _ZN7S1319C43v68Ev();
extern void _ZN7S1319C43v69Ev();
extern void _ZN7S1319C43v70Ev();
extern void _ZN7S1319C43v71Ev();
extern void _ZN7S1319C43v72Ev();
extern void _ZN7S1319C43v73Ev();
extern void _ZN7S1319C43v74Ev();
extern void _ZN7S1319C43v75Ev();
extern void _ZN7S1319C43v76Ev();
extern void _ZN7S1319C43v77Ev();
extern void _ZN7S1319C43v78Ev();
extern void _ZN7S1319C43v79Ev();
extern void _ZN7S1319C33v81Ev();
extern void _ZN7S1319C33v82Ev();
extern void _ZN7S1319C33v83Ev();
extern void _ZN7S1319C33v84Ev();
extern void _ZN7S1319C63v80Ev();
static  VTBL_ENTRY vtc_S1319C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1319C3[0]),
  (VTBL_ENTRY)&_ZN7S1319C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1319C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v84Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1319C3[0]),
  (VTBL_ENTRY)&_ZN7S1319C63v80Ev,
};
extern VTBL_ENTRY _ZTI7S1319C3[];
extern  VTBL_ENTRY _ZTV7S1319C3[];
Class_Descriptor cd_S1319C3 = {  "S1319C3", // class name
  bases_S1319C3, 2,
  &(vtc_S1319C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,96), // object size
  NSPAIRA(_ZTI7S1319C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1319C3),75, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1319C7  {
  virtual  ~S1319C7(); // _ZN7S1319C7D1Ev
  virtual void  v85(); // _ZN7S1319C73v85Ev
  virtual void  v86(); // _ZN7S1319C73v86Ev
  virtual void  v87(); // _ZN7S1319C73v87Ev
  S1319C7(); // tgen
};
//SIG(-1 S1319C7) C1{ vd v1 v2 v3}


 S1319C7 ::~S1319C7(){ note_dtor("S1319C7", this);}
void  S1319C7 ::v85(){vfunc_called(this, "_ZN7S1319C73v85Ev");}
void  S1319C7 ::v86(){vfunc_called(this, "_ZN7S1319C73v86Ev");}
void  S1319C7 ::v87(){vfunc_called(this, "_ZN7S1319C73v87Ev");}
S1319C7 ::S1319C7(){ note_ctor("S1319C7", this);} // tgen

static void Test_S1319C7()
{
  extern Class_Descriptor cd_S1319C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1319C7, buf);
    S1319C7 *dp, &lv = *(dp=new (buf) S1319C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1319C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1319C7)");
    test_class_info(&lv, &cd_S1319C7);
    dp->~S1319C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1319C7(Test_S1319C7, "S1319C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1319C7C1Ev();
extern void _ZN7S1319C7D1Ev();
Name_Map name_map_S1319C7[] = {
  NSPAIR(_ZN7S1319C7C1Ev),
  NSPAIR(_ZN7S1319C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1319C7[];
extern void _ZN7S1319C7D1Ev();
extern void _ZN7S1319C7D0Ev();
extern void _ZN7S1319C73v85Ev();
extern void _ZN7S1319C73v86Ev();
extern void _ZN7S1319C73v87Ev();
static  VTBL_ENTRY vtc_S1319C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1319C7[0]),
  (VTBL_ENTRY)&_ZN7S1319C7D1Ev,
  (VTBL_ENTRY)&_ZN7S1319C7D0Ev,
  (VTBL_ENTRY)&_ZN7S1319C73v85Ev,
  (VTBL_ENTRY)&_ZN7S1319C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1319C73v87Ev,
};
extern VTBL_ENTRY _ZTI7S1319C7[];
extern  VTBL_ENTRY _ZTV7S1319C7[];
Class_Descriptor cd_S1319C7 = {  "S1319C7", // class name
  0,0,//no base classes
  &(vtc_S1319C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1319C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1319C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1319C10  : S1537C8_nt {
};
//SIG(-1 S1319C10) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1319C10()
{
  extern Class_Descriptor cd_S1319C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1319C10, buf);
    S1319C10 &lv = *(new (buf) S1319C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1319C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1319C10)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1319C10");
    test_class_info(&lv, &cd_S1319C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1319C10(Test_S1319C10, "S1319C10", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1319C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1319C10 = {  "S1319C10", // class name
  bases_S1319C10, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1319C9  : S1319C10 {
};
//SIG(-1 S1319C9) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1319C9()
{
  extern Class_Descriptor cd_S1319C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1319C9, buf);
    S1319C9 &lv = *(new (buf) S1319C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1319C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1319C9)");
    check_base_class_offset(lv, (S1537C8_nt*)(S1319C10*), 0, "S1319C9");
    check_base_class_offset(lv, (S1319C10*), 0, "S1319C9");
    test_class_info(&lv, &cd_S1319C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1319C9(Test_S1319C9, "S1319C9", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1319C10;
static Base_Class bases_S1319C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1319C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1319C9 = {  "S1319C9", // class name
  bases_S1319C9, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1319C17  {
  int s1319c17f0[28];
  virtual  ~S1319C17(); // _ZN8S1319C17D1Ev
  virtual void  v113(); // _ZN8S1319C174v113Ev
  virtual void  v114(); // _ZN8S1319C174v114Ev
  virtual void  v115(); // _ZN8S1319C174v115Ev
  virtual void  v116(); // _ZN8S1319C174v116Ev
  virtual void  v117(); // _ZN8S1319C174v117Ev
  virtual void  v118(); // _ZN8S1319C174v118Ev
  virtual void  v119(); // _ZN8S1319C174v119Ev
  virtual void  v120(); // _ZN8S1319C174v120Ev
  virtual void  v121(); // _ZN8S1319C174v121Ev
  virtual void  v122(); // _ZN8S1319C174v122Ev
  virtual void  v123(); // _ZN8S1319C174v123Ev
  virtual void  v124(); // _ZN8S1319C174v124Ev
  virtual void  v125(); // _ZN8S1319C174v125Ev
  virtual void  v126(); // _ZN8S1319C174v126Ev
  virtual void  v127(); // _ZN8S1319C174v127Ev
  virtual void  v128(); // _ZN8S1319C174v128Ev
  virtual void  v129(); // _ZN8S1319C174v129Ev
  virtual void  v130(); // _ZN8S1319C174v130Ev
  virtual void  v131(); // _ZN8S1319C174v131Ev
  virtual void  v132(); // _ZN8S1319C174v132Ev
  virtual void  v133(); // _ZN8S1319C174v133Ev
  virtual void  v134(); // _ZN8S1319C174v134Ev
  virtual void  v135(); // _ZN8S1319C174v135Ev
  virtual void  v136(); // _ZN8S1319C174v136Ev
  virtual void  v137(); // _ZN8S1319C174v137Ev
  S1319C17(); // tgen
};
//SIG(-1 S1319C17) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fi[28]}


 S1319C17 ::~S1319C17(){ note_dtor("S1319C17", this);}
void  S1319C17 ::v113(){vfunc_called(this, "_ZN8S1319C174v113Ev");}
void  S1319C17 ::v114(){vfunc_called(this, "_ZN8S1319C174v114Ev");}
void  S1319C17 ::v115(){vfunc_called(this, "_ZN8S1319C174v115Ev");}
void  S1319C17 ::v116(){vfunc_called(this, "_ZN8S1319C174v116Ev");}
void  S1319C17 ::v117(){vfunc_called(this, "_ZN8S1319C174v117Ev");}
void  S1319C17 ::v118(){vfunc_called(this, "_ZN8S1319C174v118Ev");}
void  S1319C17 ::v119(){vfunc_called(this, "_ZN8S1319C174v119Ev");}
void  S1319C17 ::v120(){vfunc_called(this, "_ZN8S1319C174v120Ev");}
void  S1319C17 ::v121(){vfunc_called(this, "_ZN8S1319C174v121Ev");}
void  S1319C17 ::v122(){vfunc_called(this, "_ZN8S1319C174v122Ev");}
void  S1319C17 ::v123(){vfunc_called(this, "_ZN8S1319C174v123Ev");}
void  S1319C17 ::v124(){vfunc_called(this, "_ZN8S1319C174v124Ev");}
void  S1319C17 ::v125(){vfunc_called(this, "_ZN8S1319C174v125Ev");}
void  S1319C17 ::v126(){vfunc_called(this, "_ZN8S1319C174v126Ev");}
void  S1319C17 ::v127(){vfunc_called(this, "_ZN8S1319C174v127Ev");}
void  S1319C17 ::v128(){vfunc_called(this, "_ZN8S1319C174v128Ev");}
void  S1319C17 ::v129(){vfunc_called(this, "_ZN8S1319C174v129Ev");}
void  S1319C17 ::v130(){vfunc_called(this, "_ZN8S1319C174v130Ev");}
void  S1319C17 ::v131(){vfunc_called(this, "_ZN8S1319C174v131Ev");}
void  S1319C17 ::v132(){vfunc_called(this, "_ZN8S1319C174v132Ev");}
void  S1319C17 ::v133(){vfunc_called(this, "_ZN8S1319C174v133Ev");}
void  S1319C17 ::v134(){vfunc_called(this, "_ZN8S1319C174v134Ev");}
void  S1319C17 ::v135(){vfunc_called(this, "_ZN8S1319C174v135Ev");}
void  S1319C17 ::v136(){vfunc_called(this, "_ZN8S1319C174v136Ev");}
void  S1319C17 ::v137(){vfunc_called(this, "_ZN8S1319C174v137Ev");}
S1319C17 ::S1319C17(){ note_ctor("S1319C17", this);} // tgen

static void Test_S1319C17()
{
  extern Class_Descriptor cd_S1319C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,30)];
    init_test(&cd_S1319C17, buf);
    S1319C17 *dp, &lv = *(dp=new (buf) S1319C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,116), "sizeof(S1319C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1319C17)");
    check_field_offset(lv, s1319c17f0, ABISELECT(8,4), "S1319C17.s1319c17f0");
    test_class_info(&lv, &cd_S1319C17);
    dp->~S1319C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1319C17(Test_S1319C17, "S1319C17", ABISELECT(120,116));

#else // __cplusplus

extern void _ZN8S1319C17C1Ev();
extern void _ZN8S1319C17D1Ev();
Name_Map name_map_S1319C17[] = {
  NSPAIR(_ZN8S1319C17C1Ev),
  NSPAIR(_ZN8S1319C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1319C17[];
extern void _ZN8S1319C17D1Ev();
extern void _ZN8S1319C17D0Ev();
extern void _ZN8S1319C174v113Ev();
extern void _ZN8S1319C174v114Ev();
extern void _ZN8S1319C174v115Ev();
extern void _ZN8S1319C174v116Ev();
extern void _ZN8S1319C174v117Ev();
extern void _ZN8S1319C174v118Ev();
extern void _ZN8S1319C174v119Ev();
extern void _ZN8S1319C174v120Ev();
extern void _ZN8S1319C174v121Ev();
extern void _ZN8S1319C174v122Ev();
extern void _ZN8S1319C174v123Ev();
extern void _ZN8S1319C174v124Ev();
extern void _ZN8S1319C174v125Ev();
extern void _ZN8S1319C174v126Ev();
extern void _ZN8S1319C174v127Ev();
extern void _ZN8S1319C174v128Ev();
extern void _ZN8S1319C174v129Ev();
extern void _ZN8S1319C174v130Ev();
extern void _ZN8S1319C174v131Ev();
extern void _ZN8S1319C174v132Ev();
extern void _ZN8S1319C174v133Ev();
extern void _ZN8S1319C174v134Ev();
extern void _ZN8S1319C174v135Ev();
extern void _ZN8S1319C174v136Ev();
extern void _ZN8S1319C174v137Ev();
static  VTBL_ENTRY vtc_S1319C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1319C17[0]),
  (VTBL_ENTRY)&_ZN8S1319C17D1Ev,
  (VTBL_ENTRY)&_ZN8S1319C17D0Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v113Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v114Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v115Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v116Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v117Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v118Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v119Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v120Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v121Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v122Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v123Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v124Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v125Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v126Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v127Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v128Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v129Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v130Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v131Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v132Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v133Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v134Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v135Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v136Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v137Ev,
};
extern VTBL_ENTRY _ZTI8S1319C17[];
extern  VTBL_ENTRY _ZTV8S1319C17[];
Class_Descriptor cd_S1319C17 = {  "S1319C17", // class name
  0,0,//no base classes
  &(vtc_S1319C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,116), // object size
  NSPAIRA(_ZTI8S1319C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1319C17),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1319C16  : S1319C17 {
  ::S1566C29 s1319c16f0;
  int s1319c16f1[2];
  virtual void  v138(); // _ZN8S1319C164v138Ev
  virtual void  v139(); // _ZN8S1319C164v139Ev
  virtual void  v140(); // _ZN8S1319C164v140Ev
  ~S1319C16(); // tgen
  S1319C16(); // tgen
};
//SIG(-1 S1319C16) C1{ BC2{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fi[28]} v1 v2 v3 FC3{ BC4{ m Fp Fi[2]}} Fi[2]}


void  S1319C16 ::v138(){vfunc_called(this, "_ZN8S1319C164v138Ev");}
void  S1319C16 ::v139(){vfunc_called(this, "_ZN8S1319C164v139Ev");}
void  S1319C16 ::v140(){vfunc_called(this, "_ZN8S1319C164v140Ev");}
S1319C16 ::~S1319C16(){ note_dtor("S1319C16", this);} // tgen
S1319C16 ::S1319C16(){ note_ctor("S1319C16", this);} // tgen

static void Test_S1319C16()
{
  extern Class_Descriptor cd_S1319C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,35)];
    init_test(&cd_S1319C16, buf);
    S1319C16 *dp, &lv = *(dp=new (buf) S1319C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,136), "sizeof(S1319C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1319C16)");
    check_base_class_offset(lv, (S1319C17*), 0, "S1319C16");
    check_field_offset(lv, s1319c16f0, ABISELECT(120,116), "S1319C16.s1319c16f0");
    check_field_offset(lv, s1319c16f1, ABISELECT(136,128), "S1319C16.s1319c16f1");
    test_class_info(&lv, &cd_S1319C16);
    dp->~S1319C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1319C16(Test_S1319C16, "S1319C16", ABISELECT(144,136));

#else // __cplusplus

extern void _ZN8S1319C16C1Ev();
extern void _ZN8S1319C16D1Ev();
Name_Map name_map_S1319C16[] = {
  NSPAIR(_ZN8S1319C16C1Ev),
  NSPAIR(_ZN8S1319C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1319C17;
extern VTBL_ENTRY _ZTI8S1319C17[];
extern  VTBL_ENTRY _ZTV8S1319C17[];
static Base_Class bases_S1319C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1319C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1319C16[];
extern void _ZN8S1319C16D1Ev();
extern void _ZN8S1319C16D0Ev();
extern void _ZN8S1319C174v113Ev();
extern void _ZN8S1319C174v114Ev();
extern void _ZN8S1319C174v115Ev();
extern void _ZN8S1319C174v116Ev();
extern void _ZN8S1319C174v117Ev();
extern void _ZN8S1319C174v118Ev();
extern void _ZN8S1319C174v119Ev();
extern void _ZN8S1319C174v120Ev();
extern void _ZN8S1319C174v121Ev();
extern void _ZN8S1319C174v122Ev();
extern void _ZN8S1319C174v123Ev();
extern void _ZN8S1319C174v124Ev();
extern void _ZN8S1319C174v125Ev();
extern void _ZN8S1319C174v126Ev();
extern void _ZN8S1319C174v127Ev();
extern void _ZN8S1319C174v128Ev();
extern void _ZN8S1319C174v129Ev();
extern void _ZN8S1319C174v130Ev();
extern void _ZN8S1319C174v131Ev();
extern void _ZN8S1319C174v132Ev();
extern void _ZN8S1319C174v133Ev();
extern void _ZN8S1319C174v134Ev();
extern void _ZN8S1319C174v135Ev();
extern void _ZN8S1319C174v136Ev();
extern void _ZN8S1319C174v137Ev();
extern void _ZN8S1319C164v138Ev();
extern void _ZN8S1319C164v139Ev();
extern void _ZN8S1319C164v140Ev();
static  VTBL_ENTRY vtc_S1319C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1319C16[0]),
  (VTBL_ENTRY)&_ZN8S1319C16D1Ev,
  (VTBL_ENTRY)&_ZN8S1319C16D0Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v113Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v114Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v115Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v116Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v117Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v118Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v119Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v120Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v121Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v122Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v123Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v124Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v125Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v126Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v127Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v128Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v129Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v130Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v131Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v132Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v133Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v134Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v135Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v136Ev,
  (VTBL_ENTRY)&_ZN8S1319C174v137Ev,
  (VTBL_ENTRY)&_ZN8S1319C164v138Ev,
  (VTBL_ENTRY)&_ZN8S1319C164v139Ev,
  (VTBL_ENTRY)&_ZN8S1319C164v140Ev,
};
extern VTBL_ENTRY _ZTI8S1319C16[];
extern  VTBL_ENTRY _ZTV8S1319C16[];
Class_Descriptor cd_S1319C16 = {  "S1319C16", // class name
  bases_S1319C16, 1,
  &(vtc_S1319C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,136), // object size
  NSPAIRA(_ZTI8S1319C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1319C16),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1319C2  : S1319C3 , S1319C7 {
  void *s1319c2f0;
  int s1319c2f1;
  ::S1325C21 s1319c2f2;
  void *s1319c2f3;
  int s1319c2f4[6];
  ::S1319C9 s1319c2f5;
  ::S1319C9 s1319c2f6;
  int s1319c2f7[3];
  ::S1325C7_nt s1319c2f8;
  ::S1319C9 s1319c2f9;
  ::S1319C9 s1319c2f10;
  __tsi64 s1319c2f11[3];
  int s1319c2f12[2];
  ::S1537C5_nt s1319c2f13;
  ::S1537C5_nt s1319c2f14;
  int s1319c2f15[2];
  void *s1319c2f16;
  ::S1566C15 s1319c2f17;
  __tsi64 s1319c2f18;
  int s1319c2f19[6];
  __tsi64 s1319c2f20[4];
  int s1319c2f21;
  ::S1319C16 s1319c2f22;
  __tsi64 s1319c2f23[256];
  int s1319c2f24[259];
  void *s1319c2f25[1023];
  int s1319c2f26[3069];
  ::S1566C10 s1319c2f27;
  ::S1566C10 s1319c2f28;
  ::S1537C23 s1319c2f29;
  ::S1537C19 s1319c2f30;
  ::S1566C22_nt s1319c2f31;
  void *s1319c2f32;
  ::S1537C13 s1319c2f33;
  ::S1537C7_nt s1319c2f34;
  ::S1566C14_nt s1319c2f35;
  ::S1325C31 s1319c2f36;
  ::S1325C27 s1319c2f37;
  ::S1325C23 s1319c2f38;
  void *s1319c2f39[2];
  int s1319c2f40;
  ::S1566C30 s1319c2f41;
  ::S1325C14 s1319c2f42;
  virtual  ~S1319C2(); // _ZN7S1319C2D1Ev
  virtual void  v88(); // _ZN7S1319C23v88Ev
  virtual void  v89(); // _ZN7S1319C23v89Ev
  virtual void  v90(); // _ZN7S1319C23v90Ev
  virtual void  v91(); // _ZN7S1319C23v91Ev
  virtual void  v92(); // _ZN7S1319C23v92Ev
  virtual void  v93(); // _ZN7S1319C23v93Ev
  virtual void  v94(); // _ZN7S1319C23v94Ev
  virtual void  v95(); // _ZN7S1319C23v95Ev
  virtual void  v96(); // _ZN7S1319C23v96Ev
  virtual void  v97(); // _ZN7S1319C23v97Ev
  virtual void  v98(); // _ZN7S1319C23v98Ev
  virtual void  v99(); // _ZN7S1319C23v99Ev
  virtual void  v100(); // _ZN7S1319C24v100Ev
  virtual void  v101(); // _ZN7S1319C24v101Ev
  virtual void  v102(); // _ZN7S1319C24v102Ev
  virtual void  v103(); // _ZN7S1319C24v103Ev
  virtual void  v104(); // _ZN7S1319C24v104Ev
  virtual void  v105(); // _ZN7S1319C24v105Ev
  virtual void  v106(); // _ZN7S1319C24v106Ev
  virtual void  v107(); // _ZN7S1319C24v107Ev
  virtual void  v108(); // _ZN7S1319C24v108Ev
  virtual void  v109(); // _ZN7S1319C24v109Ev
  virtual void  v110(); // _ZN7S1319C24v110Ev
  S1319C2(); // tgen
};
//SIG(-1 S1319C2) C1{ BC2{ BC3{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v88} vd v89 v90 v91 v92 Fp Fi[7]} BC6{ vd v93 v94 v95} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC7{ m FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fi FC8 FC11{ BC10} FC8 Fi} Fp Fi[6] FC12{ BC13{ BC10}} FC12 Fi[3] FC14{ BC8} FC12 FC12 FL[3] Fi[2] FC15{ m Fi[2]} FC15 Fi[2] Fp FC16{ BC17{ BC18{ vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fi[28]} v123 v124 v125 FC19{ BC10} Fi[2]} v96 v97 Fp[2] FL Fi[5] Fc[3]} FL Fi[6] FL[4] Fi FC20{ BC21{ vd v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 Fi[28]} v126 v127 v128 FC22{ BC10} Fi[2]} FL[256] Fi[259] Fp[1023] Fi[3069] FC23{ BC10} FC23 FC19 FC24{ BC10} FC25{ BC26{ m FC27{ BC10} Fp Fi}} Fp FC28{ BC10} FC29{ BC10} FC4 FC27 FC30{ BC10} FC31{ BC10} Fp[2] Fi FC32{ m Fi[5]} FC11}


 S1319C2 ::~S1319C2(){ note_dtor("S1319C2", this);}
void  S1319C2 ::v88(){vfunc_called(this, "_ZN7S1319C23v88Ev");}
void  S1319C2 ::v89(){vfunc_called(this, "_ZN7S1319C23v89Ev");}
void  S1319C2 ::v90(){vfunc_called(this, "_ZN7S1319C23v90Ev");}
void  S1319C2 ::v91(){vfunc_called(this, "_ZN7S1319C23v91Ev");}
void  S1319C2 ::v92(){vfunc_called(this, "_ZN7S1319C23v92Ev");}
void  S1319C2 ::v93(){vfunc_called(this, "_ZN7S1319C23v93Ev");}
void  S1319C2 ::v94(){vfunc_called(this, "_ZN7S1319C23v94Ev");}
void  S1319C2 ::v95(){vfunc_called(this, "_ZN7S1319C23v95Ev");}
void  S1319C2 ::v96(){vfunc_called(this, "_ZN7S1319C23v96Ev");}
void  S1319C2 ::v97(){vfunc_called(this, "_ZN7S1319C23v97Ev");}
void  S1319C2 ::v98(){vfunc_called(this, "_ZN7S1319C23v98Ev");}
void  S1319C2 ::v99(){vfunc_called(this, "_ZN7S1319C23v99Ev");}
void  S1319C2 ::v100(){vfunc_called(this, "_ZN7S1319C24v100Ev");}
void  S1319C2 ::v101(){vfunc_called(this, "_ZN7S1319C24v101Ev");}
void  S1319C2 ::v102(){vfunc_called(this, "_ZN7S1319C24v102Ev");}
void  S1319C2 ::v103(){vfunc_called(this, "_ZN7S1319C24v103Ev");}
void  S1319C2 ::v104(){vfunc_called(this, "_ZN7S1319C24v104Ev");}
void  S1319C2 ::v105(){vfunc_called(this, "_ZN7S1319C24v105Ev");}
void  S1319C2 ::v106(){vfunc_called(this, "_ZN7S1319C24v106Ev");}
void  S1319C2 ::v107(){vfunc_called(this, "_ZN7S1319C24v107Ev");}
void  S1319C2 ::v108(){vfunc_called(this, "_ZN7S1319C24v108Ev");}
void  S1319C2 ::v109(){vfunc_called(this, "_ZN7S1319C24v109Ev");}
void  S1319C2 ::v110(){vfunc_called(this, "_ZN7S1319C24v110Ev");}
S1319C2 ::S1319C2(){ note_ctor("S1319C2", this);} // tgen

static void Test_S1319C2()
{
  extern Class_Descriptor cd_S1319C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3084,5089)];
    init_test(&cd_S1319C2, buf);
    S1319C2 *dp, &lv = *(dp=new (buf) S1319C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24664,20352), "sizeof(S1319C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1319C2)");
    check_base_class_offset(lv, (S1319C4*)(S1319C3*), 0, "S1319C2");
    check_base_class_offset(lv, (S1319C6*)(S1319C3*), ABISELECT(96,60), "S1319C2");
    check_base_class_offset(lv, (S1319C3*), 0, "S1319C2");
    check_base_class_offset(lv, (S1319C7*), ABISELECT(144,96), "S1319C2");
    check_field_offset(lv, s1319c2f0, ABISELECT(152,100), "S1319C2.s1319c2f0");
    check_field_offset(lv, s1319c2f1, ABISELECT(160,104), "S1319C2.s1319c2f1");
    check_field_offset(lv, s1319c2f2, ABISELECT(168,108), "S1319C2.s1319c2f2");
    check_field_offset(lv, s1319c2f3, ABISELECT(264,176), "S1319C2.s1319c2f3");
    check_field_offset(lv, s1319c2f4, ABISELECT(272,180), "S1319C2.s1319c2f4");
    check_field_offset(lv, s1319c2f5, ABISELECT(296,204), "S1319C2.s1319c2f5");
    check_field_offset(lv, s1319c2f6, ABISELECT(312,216), "S1319C2.s1319c2f6");
    check_field_offset(lv, s1319c2f7, ABISELECT(328,228), "S1319C2.s1319c2f7");
    check_field_offset(lv, s1319c2f8, ABISELECT(344,240), "S1319C2.s1319c2f8");
    check_field_offset(lv, s1319c2f9, ABISELECT(360,252), "S1319C2.s1319c2f9");
    check_field_offset(lv, s1319c2f10, ABISELECT(376,264), "S1319C2.s1319c2f10");
    check_field_offset(lv, s1319c2f11, ABISELECT(392,276), "S1319C2.s1319c2f11");
    check_field_offset(lv, s1319c2f12, ABISELECT(416,300), "S1319C2.s1319c2f12");
    check_field_offset(lv, s1319c2f13, ABISELECT(424,308), "S1319C2.s1319c2f13");
    check_field_offset(lv, s1319c2f14, ABISELECT(432,316), "S1319C2.s1319c2f14");
    check_field_offset(lv, s1319c2f15, ABISELECT(440,324), "S1319C2.s1319c2f15");
    check_field_offset(lv, s1319c2f16, ABISELECT(448,332), "S1319C2.s1319c2f16");
    check_field_offset(lv, s1319c2f17, ABISELECT(456,336), "S1319C2.s1319c2f17");
    check_field_offset(lv, s1319c2f18, ABISELECT(648,512), "S1319C2.s1319c2f18");
    check_field_offset(lv, s1319c2f19, ABISELECT(656,520), "S1319C2.s1319c2f19");
    check_field_offset(lv, s1319c2f20, ABISELECT(680,544), "S1319C2.s1319c2f20");
    check_field_offset(lv, s1319c2f21, ABISELECT(712,576), "S1319C2.s1319c2f21");
    check_field_offset(lv, s1319c2f22, ABISELECT(720,580), "S1319C2.s1319c2f22");
    check_field_offset(lv, s1319c2f23, ABISELECT(864,716), "S1319C2.s1319c2f23");
    check_field_offset(lv, s1319c2f24, ABISELECT(2912,2764), "S1319C2.s1319c2f24");
    check_field_offset(lv, s1319c2f25, ABISELECT(3952,3800), "S1319C2.s1319c2f25");
    check_field_offset(lv, s1319c2f26, ABISELECT(12136,7892), "S1319C2.s1319c2f26");
    check_field_offset(lv, s1319c2f27, ABISELECT(24416,20168), "S1319C2.s1319c2f27");
    check_field_offset(lv, s1319c2f28, ABISELECT(24432,20180), "S1319C2.s1319c2f28");
    check_field_offset(lv, s1319c2f29, ABISELECT(24448,20192), "S1319C2.s1319c2f29");
    check_field_offset(lv, s1319c2f30, ABISELECT(24464,20204), "S1319C2.s1319c2f30");
    check_field_offset(lv, s1319c2f31, ABISELECT(24480,20216), "S1319C2.s1319c2f31");
    check_field_offset(lv, s1319c2f32, ABISELECT(24512,20236), "S1319C2.s1319c2f32");
    check_field_offset(lv, s1319c2f33, ABISELECT(24520,20240), "S1319C2.s1319c2f33");
    check_field_offset(lv, s1319c2f34, ABISELECT(24536,20252), "S1319C2.s1319c2f34");
    check_field_offset(lv, s1319c2f35, ABISELECT(24552,20264), "S1319C2.s1319c2f35");
    check_field_offset(lv, s1319c2f36, ABISELECT(24560,20272), "S1319C2.s1319c2f36");
    check_field_offset(lv, s1319c2f37, ABISELECT(24576,20284), "S1319C2.s1319c2f37");
    check_field_offset(lv, s1319c2f38, ABISELECT(24592,20296), "S1319C2.s1319c2f38");
    check_field_offset(lv, s1319c2f39, ABISELECT(24608,20308), "S1319C2.s1319c2f39");
    check_field_offset(lv, s1319c2f40, ABISELECT(24624,20316), "S1319C2.s1319c2f40");
    check_field_offset(lv, s1319c2f41, ABISELECT(24628,20320), "S1319C2.s1319c2f41");
    check_field_offset(lv, s1319c2f42, ABISELECT(24648,20340), "S1319C2.s1319c2f42");
    test_class_info(&lv, &cd_S1319C2);
    dp->~S1319C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1319C2(Test_S1319C2, "S1319C2", ABISELECT(24664,20352));

#else // __cplusplus

extern void _ZN7S1319C2C1Ev();
extern void _ZN7S1319C2D1Ev();
Name_Map name_map_S1319C2[] = {
  NSPAIR(_ZN7S1319C2C1Ev),
  NSPAIR(_ZN7S1319C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1319C4;
extern VTBL_ENTRY _ZTI7S1319C4[];
extern  VTBL_ENTRY _ZTV7S1319C4[];
extern Class_Descriptor cd_S1319C6;
extern VTBL_ENTRY _ZTI7S1319C6[];
extern  VTBL_ENTRY _ZTV7S1319C6[];
extern Class_Descriptor cd_S1319C3;
extern VTBL_ENTRY _ZTI7S1319C3[];
extern  VTBL_ENTRY _ZTV7S1319C3[];
extern Class_Descriptor cd_S1319C7;
extern VTBL_ENTRY _ZTI7S1319C7[];
extern  VTBL_ENTRY _ZTV7S1319C7[];
static Base_Class bases_S1319C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1319C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1319C6,    ABISELECT(96,60), //bcp->offset
    95, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1319C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1319C7,    ABISELECT(144,96), //bcp->offset
    98, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1319C2[];
extern void _ZN7S1319C2D1Ev();
extern void _ZN7S1319C2D0Ev();
extern void _ZN7S1319C43v16Ev();
extern void _ZN7S1319C43v17Ev();
extern void _ZN7S1319C43v18Ev();
extern void _ZN7S1319C43v19Ev();
extern void _ZN7S1319C43v20Ev();
extern void _ZN7S1319C43v21Ev();
extern void _ZN7S1319C43v22Ev();
extern void _ZN7S1319C43v23Ev();
extern void _ZN7S1319C43v24Ev();
extern void _ZN7S1319C43v25Ev();
extern void _ZN7S1319C43v26Ev();
extern void _ZN7S1319C43v27Ev();
extern void _ZN7S1319C43v28Ev();
extern void _ZN7S1319C43v29Ev();
extern void _ZN7S1319C43v30Ev();
extern void _ZN7S1319C43v31Ev();
extern void _ZN7S1319C43v32Ev();
extern void _ZN7S1319C43v33Ev();
extern void _ZN7S1319C43v34Ev();
extern void _ZN7S1319C43v35Ev();
extern void _ZN7S1319C43v36Ev();
extern void _ZN7S1319C43v37Ev();
extern void _ZN7S1319C43v38Ev();
extern void _ZN7S1319C43v39Ev();
extern void _ZN7S1319C43v40Ev();
extern void _ZN7S1319C43v41Ev();
extern void _ZN7S1319C43v42Ev();
extern void _ZN7S1319C43v43Ev();
extern void _ZN7S1319C43v44Ev();
extern void _ZN7S1319C43v45Ev();
extern void _ZN7S1319C43v46Ev();
extern void _ZN7S1319C43v47Ev();
extern void _ZN7S1319C43v48Ev();
extern void _ZN7S1319C43v49Ev();
extern void _ZN7S1319C43v50Ev();
extern void _ZN7S1319C43v51Ev();
extern void _ZN7S1319C43v52Ev();
extern void _ZN7S1319C43v53Ev();
extern void _ZN7S1319C43v54Ev();
extern void _ZN7S1319C43v55Ev();
extern void _ZN7S1319C43v56Ev();
extern void _ZN7S1319C43v57Ev();
extern void _ZN7S1319C43v58Ev();
extern void _ZN7S1319C43v59Ev();
extern void _ZN7S1319C43v60Ev();
extern void _ZN7S1319C43v61Ev();
extern void _ZN7S1319C43v62Ev();
extern void _ZN7S1319C43v63Ev();
extern void _ZN7S1319C43v64Ev();
extern void _ZN7S1319C43v65Ev();
extern void _ZN7S1319C43v66Ev();
extern void _ZN7S1319C43v67Ev();
extern void _ZN7S1319C43v68Ev();
extern void _ZN7S1319C43v69Ev();
extern void _ZN7S1319C43v70Ev();
extern void _ZN7S1319C43v71Ev();
extern void _ZN7S1319C43v72Ev();
extern void _ZN7S1319C43v73Ev();
extern void _ZN7S1319C43v74Ev();
extern void _ZN7S1319C43v75Ev();
extern void _ZN7S1319C43v76Ev();
extern void _ZN7S1319C43v77Ev();
extern void _ZN7S1319C43v78Ev();
extern void _ZN7S1319C43v79Ev();
extern void _ZN7S1319C33v81Ev();
extern void _ZN7S1319C33v82Ev();
extern void _ZN7S1319C33v83Ev();
extern void _ZN7S1319C33v84Ev();
extern void _ZN7S1319C23v88Ev();
extern void _ZN7S1319C23v89Ev();
extern void _ZN7S1319C23v90Ev();
extern void _ZN7S1319C23v91Ev();
extern void _ZN7S1319C23v92Ev();
extern void _ZN7S1319C23v93Ev();
extern void _ZN7S1319C23v94Ev();
extern void _ZN7S1319C23v95Ev();
extern void _ZN7S1319C23v96Ev();
extern void _ZN7S1319C23v97Ev();
extern void _ZN7S1319C23v98Ev();
extern void _ZN7S1319C23v99Ev();
extern void _ZN7S1319C24v100Ev();
extern void _ZN7S1319C24v101Ev();
extern void _ZN7S1319C24v102Ev();
extern void _ZN7S1319C24v103Ev();
extern void _ZN7S1319C24v104Ev();
extern void _ZN7S1319C24v105Ev();
extern void _ZN7S1319C24v106Ev();
extern void _ZN7S1319C24v107Ev();
extern void _ZN7S1319C24v108Ev();
extern void _ZN7S1319C24v109Ev();
extern void _ZN7S1319C24v110Ev();
extern void _ZN7S1319C63v80Ev();
extern void ABISELECT(_ZThn144_N7S1319C2D1Ev,_ZThn96_N7S1319C2D1Ev)();
extern void ABISELECT(_ZThn144_N7S1319C2D0Ev,_ZThn96_N7S1319C2D0Ev)();
extern void _ZN7S1319C73v85Ev();
extern void _ZN7S1319C73v86Ev();
extern void _ZN7S1319C73v87Ev();
static  VTBL_ENTRY vtc_S1319C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1319C2[0]),
  (VTBL_ENTRY)&_ZN7S1319C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1319C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v110Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1319C2[0]),
  (VTBL_ENTRY)&_ZN7S1319C63v80Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI7S1319C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1319C2D1Ev,_ZThn96_N7S1319C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1319C2D0Ev,_ZThn96_N7S1319C2D0Ev),
  (VTBL_ENTRY)&_ZN7S1319C73v85Ev,
  (VTBL_ENTRY)&_ZN7S1319C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1319C73v87Ev,
};
extern VTBL_ENTRY _ZTI7S1319C2[];
extern  VTBL_ENTRY _ZTV7S1319C2[];
Class_Descriptor cd_S1319C2 = {  "S1319C2", // class name
  bases_S1319C2, 4,
  &(vtc_S1319C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24664,20352), // object size
  NSPAIRA(_ZTI7S1319C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1319C2),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1319C1  : S1319C2 {
  void *s1319c1f0;
  virtual  ~S1319C1(); // _ZN7S1319C1D1Ev
  virtual void  v1(); // _ZN7S1319C12v1Ev
  virtual void  v2(); // _ZN7S1319C12v2Ev
  virtual void  v3(); // _ZN7S1319C12v3Ev
  virtual void  v4(); // _ZN7S1319C12v4Ev
  virtual void  v5(); // _ZN7S1319C12v5Ev
  virtual void  v6(); // _ZN7S1319C12v6Ev
  virtual void  v7(); // _ZN7S1319C12v7Ev
  virtual void  v8(); // _ZN7S1319C12v8Ev
  virtual void  v9(); // _ZN7S1319C12v9Ev
  virtual void  v10(); // _ZN7S1319C13v10Ev
  virtual void  v11(); // _ZN7S1319C13v11Ev
  virtual void  v12(); // _ZN7S1319C13v12Ev
  virtual void  v13(); // _ZN7S1319C13v13Ev
  virtual void  v14(); // _ZN7S1319C13v14Ev
  virtual void  v15(); // _ZN7S1319C13v15Ev
  S1319C1(); // tgen
};
//SIG(1 S1319C1) C1{ BC2{ BC3{ BC4{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v80} vd v81 v82 v83 v84 Fp Fi[7]} BC7{ vd v85 v86 v87} vd v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fp Fi FC8{ m FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 Fi FC9 FC12{ BC11} FC9 Fi} Fp Fi[6] FC13{ BC14{ BC11}} FC13 Fi[3] FC15{ BC9} FC13 FC13 FL[3] Fi[2] FC16{ m Fi[2]} FC16 Fi[2] Fp FC17{ BC18{ BC19{ vd v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 Fi[28]} v138 v139 v140 FC20{ BC11} Fi[2]} v111 v112 Fp[2] FL Fi[5] Fc[3]} FL Fi[6] FL[4] Fi FC21{ BC22{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 Fi[28]} v141 v142 v143 FC23{ BC11} Fi[2]} FL[256] Fi[259] Fp[1023] Fi[3069] FC24{ BC11} FC24 FC20 FC25{ BC11} FC26{ BC27{ m FC28{ BC11} Fp Fi}} Fp FC29{ BC11} FC30{ BC11} FC5 FC28 FC31{ BC11} FC32{ BC11} Fp[2] Fi FC33{ m Fi[5]} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fp}


 S1319C1 ::~S1319C1(){ note_dtor("S1319C1", this);}
void  S1319C1 ::v1(){vfunc_called(this, "_ZN7S1319C12v1Ev");}
void  S1319C1 ::v2(){vfunc_called(this, "_ZN7S1319C12v2Ev");}
void  S1319C1 ::v3(){vfunc_called(this, "_ZN7S1319C12v3Ev");}
void  S1319C1 ::v4(){vfunc_called(this, "_ZN7S1319C12v4Ev");}
void  S1319C1 ::v5(){vfunc_called(this, "_ZN7S1319C12v5Ev");}
void  S1319C1 ::v6(){vfunc_called(this, "_ZN7S1319C12v6Ev");}
void  S1319C1 ::v7(){vfunc_called(this, "_ZN7S1319C12v7Ev");}
void  S1319C1 ::v8(){vfunc_called(this, "_ZN7S1319C12v8Ev");}
void  S1319C1 ::v9(){vfunc_called(this, "_ZN7S1319C12v9Ev");}
void  S1319C1 ::v10(){vfunc_called(this, "_ZN7S1319C13v10Ev");}
void  S1319C1 ::v11(){vfunc_called(this, "_ZN7S1319C13v11Ev");}
void  S1319C1 ::v12(){vfunc_called(this, "_ZN7S1319C13v12Ev");}
void  S1319C1 ::v13(){vfunc_called(this, "_ZN7S1319C13v13Ev");}
void  S1319C1 ::v14(){vfunc_called(this, "_ZN7S1319C13v14Ev");}
void  S1319C1 ::v15(){vfunc_called(this, "_ZN7S1319C13v15Ev");}
S1319C1 ::S1319C1(){ note_ctor("S1319C1", this);} // tgen

static void Test_S1319C1()
{
  extern Class_Descriptor cd_S1319C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3085,5090)];
    init_test(&cd_S1319C1, buf);
    S1319C1 *dp, &lv = *(dp=new (buf) S1319C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24672,20356), "sizeof(S1319C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1319C1)");
    check_base_class_offset(lv, (S1319C4*)(S1319C3*)(S1319C2*), 0, "S1319C1");
    check_base_class_offset(lv, (S1319C6*)(S1319C3*)(S1319C2*), ABISELECT(96,60), "S1319C1");
    check_base_class_offset(lv, (S1319C3*)(S1319C2*), 0, "S1319C1");
    check_base_class_offset(lv, (S1319C7*)(S1319C2*), ABISELECT(144,96), "S1319C1");
    check_base_class_offset(lv, (S1319C2*), 0, "S1319C1");
    check_field_offset(lv, s1319c1f0, ABISELECT(24664,20352), "S1319C1.s1319c1f0");
    test_class_info(&lv, &cd_S1319C1);
    dp->~S1319C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1319C1(Test_S1319C1, "S1319C1", ABISELECT(24672,20356));

#else // __cplusplus

extern void _ZN7S1319C1C1Ev();
extern void _ZN7S1319C1D1Ev();
Name_Map name_map_S1319C1[] = {
  NSPAIR(_ZN7S1319C1C1Ev),
  NSPAIR(_ZN7S1319C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1319C4;
extern VTBL_ENTRY _ZTI7S1319C4[];
extern  VTBL_ENTRY _ZTV7S1319C4[];
extern Class_Descriptor cd_S1319C6;
extern VTBL_ENTRY _ZTI7S1319C6[];
extern  VTBL_ENTRY _ZTV7S1319C6[];
extern Class_Descriptor cd_S1319C3;
extern VTBL_ENTRY _ZTI7S1319C3[];
extern  VTBL_ENTRY _ZTV7S1319C3[];
extern Class_Descriptor cd_S1319C7;
extern VTBL_ENTRY _ZTI7S1319C7[];
extern  VTBL_ENTRY _ZTV7S1319C7[];
extern Class_Descriptor cd_S1319C2;
extern VTBL_ENTRY _ZTI7S1319C2[];
extern  VTBL_ENTRY _ZTV7S1319C2[];
static Base_Class bases_S1319C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1319C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1319C6,    ABISELECT(96,60), //bcp->offset
    110, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1319C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1319C7,    ABISELECT(144,96), //bcp->offset
    113, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1319C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1319C1[];
extern void _ZN7S1319C1D1Ev();
extern void _ZN7S1319C1D0Ev();
extern void _ZN7S1319C43v16Ev();
extern void _ZN7S1319C43v17Ev();
extern void _ZN7S1319C43v18Ev();
extern void _ZN7S1319C43v19Ev();
extern void _ZN7S1319C43v20Ev();
extern void _ZN7S1319C43v21Ev();
extern void _ZN7S1319C43v22Ev();
extern void _ZN7S1319C43v23Ev();
extern void _ZN7S1319C43v24Ev();
extern void _ZN7S1319C43v25Ev();
extern void _ZN7S1319C43v26Ev();
extern void _ZN7S1319C43v27Ev();
extern void _ZN7S1319C43v28Ev();
extern void _ZN7S1319C43v29Ev();
extern void _ZN7S1319C43v30Ev();
extern void _ZN7S1319C43v31Ev();
extern void _ZN7S1319C43v32Ev();
extern void _ZN7S1319C43v33Ev();
extern void _ZN7S1319C43v34Ev();
extern void _ZN7S1319C43v35Ev();
extern void _ZN7S1319C43v36Ev();
extern void _ZN7S1319C43v37Ev();
extern void _ZN7S1319C43v38Ev();
extern void _ZN7S1319C43v39Ev();
extern void _ZN7S1319C43v40Ev();
extern void _ZN7S1319C43v41Ev();
extern void _ZN7S1319C43v42Ev();
extern void _ZN7S1319C43v43Ev();
extern void _ZN7S1319C43v44Ev();
extern void _ZN7S1319C43v45Ev();
extern void _ZN7S1319C43v46Ev();
extern void _ZN7S1319C43v47Ev();
extern void _ZN7S1319C43v48Ev();
extern void _ZN7S1319C43v49Ev();
extern void _ZN7S1319C43v50Ev();
extern void _ZN7S1319C43v51Ev();
extern void _ZN7S1319C43v52Ev();
extern void _ZN7S1319C43v53Ev();
extern void _ZN7S1319C43v54Ev();
extern void _ZN7S1319C43v55Ev();
extern void _ZN7S1319C43v56Ev();
extern void _ZN7S1319C43v57Ev();
extern void _ZN7S1319C43v58Ev();
extern void _ZN7S1319C43v59Ev();
extern void _ZN7S1319C43v60Ev();
extern void _ZN7S1319C43v61Ev();
extern void _ZN7S1319C43v62Ev();
extern void _ZN7S1319C43v63Ev();
extern void _ZN7S1319C43v64Ev();
extern void _ZN7S1319C43v65Ev();
extern void _ZN7S1319C43v66Ev();
extern void _ZN7S1319C43v67Ev();
extern void _ZN7S1319C43v68Ev();
extern void _ZN7S1319C43v69Ev();
extern void _ZN7S1319C43v70Ev();
extern void _ZN7S1319C43v71Ev();
extern void _ZN7S1319C43v72Ev();
extern void _ZN7S1319C43v73Ev();
extern void _ZN7S1319C43v74Ev();
extern void _ZN7S1319C43v75Ev();
extern void _ZN7S1319C43v76Ev();
extern void _ZN7S1319C43v77Ev();
extern void _ZN7S1319C43v78Ev();
extern void _ZN7S1319C43v79Ev();
extern void _ZN7S1319C33v81Ev();
extern void _ZN7S1319C33v82Ev();
extern void _ZN7S1319C33v83Ev();
extern void _ZN7S1319C33v84Ev();
extern void _ZN7S1319C23v88Ev();
extern void _ZN7S1319C23v89Ev();
extern void _ZN7S1319C23v90Ev();
extern void _ZN7S1319C23v91Ev();
extern void _ZN7S1319C23v92Ev();
extern void _ZN7S1319C23v93Ev();
extern void _ZN7S1319C23v94Ev();
extern void _ZN7S1319C23v95Ev();
extern void _ZN7S1319C23v96Ev();
extern void _ZN7S1319C23v97Ev();
extern void _ZN7S1319C23v98Ev();
extern void _ZN7S1319C23v99Ev();
extern void _ZN7S1319C24v100Ev();
extern void _ZN7S1319C24v101Ev();
extern void _ZN7S1319C24v102Ev();
extern void _ZN7S1319C24v103Ev();
extern void _ZN7S1319C24v104Ev();
extern void _ZN7S1319C24v105Ev();
extern void _ZN7S1319C24v106Ev();
extern void _ZN7S1319C24v107Ev();
extern void _ZN7S1319C24v108Ev();
extern void _ZN7S1319C24v109Ev();
extern void _ZN7S1319C24v110Ev();
extern void _ZN7S1319C12v1Ev();
extern void _ZN7S1319C12v2Ev();
extern void _ZN7S1319C12v3Ev();
extern void _ZN7S1319C12v4Ev();
extern void _ZN7S1319C12v5Ev();
extern void _ZN7S1319C12v6Ev();
extern void _ZN7S1319C12v7Ev();
extern void _ZN7S1319C12v8Ev();
extern void _ZN7S1319C12v9Ev();
extern void _ZN7S1319C13v10Ev();
extern void _ZN7S1319C13v11Ev();
extern void _ZN7S1319C13v12Ev();
extern void _ZN7S1319C13v13Ev();
extern void _ZN7S1319C13v14Ev();
extern void _ZN7S1319C13v15Ev();
extern void _ZN7S1319C63v80Ev();
extern void ABISELECT(_ZThn144_N7S1319C1D1Ev,_ZThn96_N7S1319C1D1Ev)();
extern void ABISELECT(_ZThn144_N7S1319C1D0Ev,_ZThn96_N7S1319C1D0Ev)();
extern void _ZN7S1319C73v85Ev();
extern void _ZN7S1319C73v86Ev();
extern void _ZN7S1319C73v87Ev();
static  VTBL_ENTRY vtc_S1319C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1319C1[0]),
  (VTBL_ENTRY)&_ZN7S1319C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1319C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1319C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1319C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1319C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1319C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1319C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1319C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1319C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1319C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1319C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1319C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1319C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1319C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1319C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1319C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1319C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1319C13v12Ev,
  (VTBL_ENTRY)&_ZN7S1319C13v13Ev,
  (VTBL_ENTRY)&_ZN7S1319C13v14Ev,
  (VTBL_ENTRY)&_ZN7S1319C13v15Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1319C1[0]),
  (VTBL_ENTRY)&_ZN7S1319C63v80Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI7S1319C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1319C1D1Ev,_ZThn96_N7S1319C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1319C1D0Ev,_ZThn96_N7S1319C1D0Ev),
  (VTBL_ENTRY)&_ZN7S1319C73v85Ev,
  (VTBL_ENTRY)&_ZN7S1319C73v86Ev,
  (VTBL_ENTRY)&_ZN7S1319C73v87Ev,
};
extern VTBL_ENTRY _ZTI7S1319C1[];
extern  VTBL_ENTRY _ZTV7S1319C1[];
Class_Descriptor cd_S1319C1 = {  "S1319C1", // class name
  bases_S1319C1, 5,
  &(vtc_S1319C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24672,20356), // object size
  NSPAIRA(_ZTI7S1319C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1319C1),120, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1284C4  {
  int s1284c4f0;
  __tsi64 s1284c4f1;
  void *s1284c4f2[4];
  int s1284c4f3[2];
  void *s1284c4f4;
  ::S1566C14_nt s1284c4f5;
  void *s1284c4f6[2];
  virtual  ~S1284C4(); // _ZN7S1284C4D1Ev
  virtual void  v10(); // _ZN7S1284C43v10Ev
  virtual void  v11(); // _ZN7S1284C43v11Ev
  virtual void  v12(); // _ZN7S1284C43v12Ev
  virtual void  v13(); // _ZN7S1284C43v13Ev
  virtual void  v14(); // _ZN7S1284C43v14Ev
  virtual void  v15(); // _ZN7S1284C43v15Ev
  virtual void  v16(); // _ZN7S1284C43v16Ev
  virtual void  v17(); // _ZN7S1284C43v17Ev
  virtual void  v18(); // _ZN7S1284C43v18Ev
  virtual void  v19(); // _ZN7S1284C43v19Ev
  virtual void  v20(); // _ZN7S1284C43v20Ev
  virtual void  v21(); // _ZN7S1284C43v21Ev
  virtual void  v22(); // _ZN7S1284C43v22Ev
  virtual void  v23(); // _ZN7S1284C43v23Ev
  virtual void  v24(); // _ZN7S1284C43v24Ev
  virtual void  v25(); // _ZN7S1284C43v25Ev
  virtual void  v26(); // _ZN7S1284C43v26Ev
  virtual void  v27(); // _ZN7S1284C43v27Ev
  virtual void  v28(); // _ZN7S1284C43v28Ev
  virtual void  v29(); // _ZN7S1284C43v29Ev
  virtual void  v30(); // _ZN7S1284C43v30Ev
  virtual void  v31(); // _ZN7S1284C43v31Ev
  virtual void  v32(); // _ZN7S1284C43v32Ev
  virtual void  v33(); // _ZN7S1284C43v33Ev
  virtual void  v34(); // _ZN7S1284C43v34Ev
  virtual void  v35(); // _ZN7S1284C43v35Ev
  virtual void  v36(); // _ZN7S1284C43v36Ev
  virtual void  v37(); // _ZN7S1284C43v37Ev
  virtual void  v38(); // _ZN7S1284C43v38Ev
  virtual void  v39(); // _ZN7S1284C43v39Ev
  virtual void  v40(); // _ZN7S1284C43v40Ev
  virtual void  v41(); // _ZN7S1284C43v41Ev
  virtual void  v42(); // _ZN7S1284C43v42Ev
  virtual void  v43(); // _ZN7S1284C43v43Ev
  virtual void  v44(); // _ZN7S1284C43v44Ev
  virtual void  v45(); // _ZN7S1284C43v45Ev
  virtual void  v46(); // _ZN7S1284C43v46Ev
  virtual void  v47(); // _ZN7S1284C43v47Ev
  virtual void  v48(); // _ZN7S1284C43v48Ev
  virtual void  v49(); // _ZN7S1284C43v49Ev
  virtual void  v50(); // _ZN7S1284C43v50Ev
  virtual void  v51(); // _ZN7S1284C43v51Ev
  virtual void  v52(); // _ZN7S1284C43v52Ev
  virtual void  v53(); // _ZN7S1284C43v53Ev
  virtual void  v54(); // _ZN7S1284C43v54Ev
  virtual void  v55(); // _ZN7S1284C43v55Ev
  virtual void  v56(); // _ZN7S1284C43v56Ev
  virtual void  v57(); // _ZN7S1284C43v57Ev
  virtual void  v58(); // _ZN7S1284C43v58Ev
  virtual void  v59(); // _ZN7S1284C43v59Ev
  virtual void  v60(); // _ZN7S1284C43v60Ev
  virtual void  v61(); // _ZN7S1284C43v61Ev
  virtual void  v62(); // _ZN7S1284C43v62Ev
  virtual void  v63(); // _ZN7S1284C43v63Ev
  virtual void  v64(); // _ZN7S1284C43v64Ev
  virtual void  v65(); // _ZN7S1284C43v65Ev
  virtual void  v66(); // _ZN7S1284C43v66Ev
  virtual void  v67(); // _ZN7S1284C43v67Ev
  virtual void  v68(); // _ZN7S1284C43v68Ev
  virtual void  v69(); // _ZN7S1284C43v69Ev
  virtual void  v70(); // _ZN7S1284C43v70Ev
  virtual void  v71(); // _ZN7S1284C43v71Ev
  virtual void  v72(); // _ZN7S1284C43v72Ev
  virtual void  v73(); // _ZN7S1284C43v73Ev
  S1284C4(); // tgen
};
//SIG(-1 S1284C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1284C4 ::~S1284C4(){ note_dtor("S1284C4", this);}
void  S1284C4 ::v10(){vfunc_called(this, "_ZN7S1284C43v10Ev");}
void  S1284C4 ::v11(){vfunc_called(this, "_ZN7S1284C43v11Ev");}
void  S1284C4 ::v12(){vfunc_called(this, "_ZN7S1284C43v12Ev");}
void  S1284C4 ::v13(){vfunc_called(this, "_ZN7S1284C43v13Ev");}
void  S1284C4 ::v14(){vfunc_called(this, "_ZN7S1284C43v14Ev");}
void  S1284C4 ::v15(){vfunc_called(this, "_ZN7S1284C43v15Ev");}
void  S1284C4 ::v16(){vfunc_called(this, "_ZN7S1284C43v16Ev");}
void  S1284C4 ::v17(){vfunc_called(this, "_ZN7S1284C43v17Ev");}
void  S1284C4 ::v18(){vfunc_called(this, "_ZN7S1284C43v18Ev");}
void  S1284C4 ::v19(){vfunc_called(this, "_ZN7S1284C43v19Ev");}
void  S1284C4 ::v20(){vfunc_called(this, "_ZN7S1284C43v20Ev");}
void  S1284C4 ::v21(){vfunc_called(this, "_ZN7S1284C43v21Ev");}
void  S1284C4 ::v22(){vfunc_called(this, "_ZN7S1284C43v22Ev");}
void  S1284C4 ::v23(){vfunc_called(this, "_ZN7S1284C43v23Ev");}
void  S1284C4 ::v24(){vfunc_called(this, "_ZN7S1284C43v24Ev");}
void  S1284C4 ::v25(){vfunc_called(this, "_ZN7S1284C43v25Ev");}
void  S1284C4 ::v26(){vfunc_called(this, "_ZN7S1284C43v26Ev");}
void  S1284C4 ::v27(){vfunc_called(this, "_ZN7S1284C43v27Ev");}
void  S1284C4 ::v28(){vfunc_called(this, "_ZN7S1284C43v28Ev");}
void  S1284C4 ::v29(){vfunc_called(this, "_ZN7S1284C43v29Ev");}
void  S1284C4 ::v30(){vfunc_called(this, "_ZN7S1284C43v30Ev");}
void  S1284C4 ::v31(){vfunc_called(this, "_ZN7S1284C43v31Ev");}
void  S1284C4 ::v32(){vfunc_called(this, "_ZN7S1284C43v32Ev");}
void  S1284C4 ::v33(){vfunc_called(this, "_ZN7S1284C43v33Ev");}
void  S1284C4 ::v34(){vfunc_called(this, "_ZN7S1284C43v34Ev");}
void  S1284C4 ::v35(){vfunc_called(this, "_ZN7S1284C43v35Ev");}
void  S1284C4 ::v36(){vfunc_called(this, "_ZN7S1284C43v36Ev");}
void  S1284C4 ::v37(){vfunc_called(this, "_ZN7S1284C43v37Ev");}
void  S1284C4 ::v38(){vfunc_called(this, "_ZN7S1284C43v38Ev");}
void  S1284C4 ::v39(){vfunc_called(this, "_ZN7S1284C43v39Ev");}
void  S1284C4 ::v40(){vfunc_called(this, "_ZN7S1284C43v40Ev");}
void  S1284C4 ::v41(){vfunc_called(this, "_ZN7S1284C43v41Ev");}
void  S1284C4 ::v42(){vfunc_called(this, "_ZN7S1284C43v42Ev");}
void  S1284C4 ::v43(){vfunc_called(this, "_ZN7S1284C43v43Ev");}
void  S1284C4 ::v44(){vfunc_called(this, "_ZN7S1284C43v44Ev");}
void  S1284C4 ::v45(){vfunc_called(this, "_ZN7S1284C43v45Ev");}
void  S1284C4 ::v46(){vfunc_called(this, "_ZN7S1284C43v46Ev");}
void  S1284C4 ::v47(){vfunc_called(this, "_ZN7S1284C43v47Ev");}
void  S1284C4 ::v48(){vfunc_called(this, "_ZN7S1284C43v48Ev");}
void  S1284C4 ::v49(){vfunc_called(this, "_ZN7S1284C43v49Ev");}
void  S1284C4 ::v50(){vfunc_called(this, "_ZN7S1284C43v50Ev");}
void  S1284C4 ::v51(){vfunc_called(this, "_ZN7S1284C43v51Ev");}
void  S1284C4 ::v52(){vfunc_called(this, "_ZN7S1284C43v52Ev");}
void  S1284C4 ::v53(){vfunc_called(this, "_ZN7S1284C43v53Ev");}
void  S1284C4 ::v54(){vfunc_called(this, "_ZN7S1284C43v54Ev");}
void  S1284C4 ::v55(){vfunc_called(this, "_ZN7S1284C43v55Ev");}
void  S1284C4 ::v56(){vfunc_called(this, "_ZN7S1284C43v56Ev");}
void  S1284C4 ::v57(){vfunc_called(this, "_ZN7S1284C43v57Ev");}
void  S1284C4 ::v58(){vfunc_called(this, "_ZN7S1284C43v58Ev");}
void  S1284C4 ::v59(){vfunc_called(this, "_ZN7S1284C43v59Ev");}
void  S1284C4 ::v60(){vfunc_called(this, "_ZN7S1284C43v60Ev");}
void  S1284C4 ::v61(){vfunc_called(this, "_ZN7S1284C43v61Ev");}
void  S1284C4 ::v62(){vfunc_called(this, "_ZN7S1284C43v62Ev");}
void  S1284C4 ::v63(){vfunc_called(this, "_ZN7S1284C43v63Ev");}
void  S1284C4 ::v64(){vfunc_called(this, "_ZN7S1284C43v64Ev");}
void  S1284C4 ::v65(){vfunc_called(this, "_ZN7S1284C43v65Ev");}
void  S1284C4 ::v66(){vfunc_called(this, "_ZN7S1284C43v66Ev");}
void  S1284C4 ::v67(){vfunc_called(this, "_ZN7S1284C43v67Ev");}
void  S1284C4 ::v68(){vfunc_called(this, "_ZN7S1284C43v68Ev");}
void  S1284C4 ::v69(){vfunc_called(this, "_ZN7S1284C43v69Ev");}
void  S1284C4 ::v70(){vfunc_called(this, "_ZN7S1284C43v70Ev");}
void  S1284C4 ::v71(){vfunc_called(this, "_ZN7S1284C43v71Ev");}
void  S1284C4 ::v72(){vfunc_called(this, "_ZN7S1284C43v72Ev");}
void  S1284C4 ::v73(){vfunc_called(this, "_ZN7S1284C43v73Ev");}
S1284C4 ::S1284C4(){ note_ctor("S1284C4", this);} // tgen

static void Test_S1284C4()
{
  extern Class_Descriptor cd_S1284C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1284C4, buf);
    S1284C4 *dp, &lv = *(dp=new (buf) S1284C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1284C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1284C4)");
    check_field_offset(lv, s1284c4f0, ABISELECT(8,4), "S1284C4.s1284c4f0");
    check_field_offset(lv, s1284c4f1, ABISELECT(16,8), "S1284C4.s1284c4f1");
    check_field_offset(lv, s1284c4f2, ABISELECT(24,16), "S1284C4.s1284c4f2");
    check_field_offset(lv, s1284c4f3, ABISELECT(56,32), "S1284C4.s1284c4f3");
    check_field_offset(lv, s1284c4f4, ABISELECT(64,40), "S1284C4.s1284c4f4");
    check_field_offset(lv, s1284c4f5, ABISELECT(72,44), "S1284C4.s1284c4f5");
    check_field_offset(lv, s1284c4f6, ABISELECT(80,52), "S1284C4.s1284c4f6");
    test_class_info(&lv, &cd_S1284C4);
    dp->~S1284C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1284C4(Test_S1284C4, "S1284C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1284C4C1Ev();
extern void _ZN7S1284C4D1Ev();
Name_Map name_map_S1284C4[] = {
  NSPAIR(_ZN7S1284C4C1Ev),
  NSPAIR(_ZN7S1284C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1284C4[];
extern void _ZN7S1284C4D1Ev();
extern void _ZN7S1284C4D0Ev();
extern void _ZN7S1284C43v10Ev();
extern void _ZN7S1284C43v11Ev();
extern void _ZN7S1284C43v12Ev();
extern void _ZN7S1284C43v13Ev();
extern void _ZN7S1284C43v14Ev();
extern void _ZN7S1284C43v15Ev();
extern void _ZN7S1284C43v16Ev();
extern void _ZN7S1284C43v17Ev();
extern void _ZN7S1284C43v18Ev();
extern void _ZN7S1284C43v19Ev();
extern void _ZN7S1284C43v20Ev();
extern void _ZN7S1284C43v21Ev();
extern void _ZN7S1284C43v22Ev();
extern void _ZN7S1284C43v23Ev();
extern void _ZN7S1284C43v24Ev();
extern void _ZN7S1284C43v25Ev();
extern void _ZN7S1284C43v26Ev();
extern void _ZN7S1284C43v27Ev();
extern void _ZN7S1284C43v28Ev();
extern void _ZN7S1284C43v29Ev();
extern void _ZN7S1284C43v30Ev();
extern void _ZN7S1284C43v31Ev();
extern void _ZN7S1284C43v32Ev();
extern void _ZN7S1284C43v33Ev();
extern void _ZN7S1284C43v34Ev();
extern void _ZN7S1284C43v35Ev();
extern void _ZN7S1284C43v36Ev();
extern void _ZN7S1284C43v37Ev();
extern void _ZN7S1284C43v38Ev();
extern void _ZN7S1284C43v39Ev();
extern void _ZN7S1284C43v40Ev();
extern void _ZN7S1284C43v41Ev();
extern void _ZN7S1284C43v42Ev();
extern void _ZN7S1284C43v43Ev();
extern void _ZN7S1284C43v44Ev();
extern void _ZN7S1284C43v45Ev();
extern void _ZN7S1284C43v46Ev();
extern void _ZN7S1284C43v47Ev();
extern void _ZN7S1284C43v48Ev();
extern void _ZN7S1284C43v49Ev();
extern void _ZN7S1284C43v50Ev();
extern void _ZN7S1284C43v51Ev();
extern void _ZN7S1284C43v52Ev();
extern void _ZN7S1284C43v53Ev();
extern void _ZN7S1284C43v54Ev();
extern void _ZN7S1284C43v55Ev();
extern void _ZN7S1284C43v56Ev();
extern void _ZN7S1284C43v57Ev();
extern void _ZN7S1284C43v58Ev();
extern void _ZN7S1284C43v59Ev();
extern void _ZN7S1284C43v60Ev();
extern void _ZN7S1284C43v61Ev();
extern void _ZN7S1284C43v62Ev();
extern void _ZN7S1284C43v63Ev();
extern void _ZN7S1284C43v64Ev();
extern void _ZN7S1284C43v65Ev();
extern void _ZN7S1284C43v66Ev();
extern void _ZN7S1284C43v67Ev();
extern void _ZN7S1284C43v68Ev();
extern void _ZN7S1284C43v69Ev();
extern void _ZN7S1284C43v70Ev();
extern void _ZN7S1284C43v71Ev();
extern void _ZN7S1284C43v72Ev();
extern void _ZN7S1284C43v73Ev();
static  VTBL_ENTRY vtc_S1284C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1284C4[0]),
  (VTBL_ENTRY)&_ZN7S1284C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1284C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v73Ev,
};
extern VTBL_ENTRY _ZTI7S1284C4[];
extern  VTBL_ENTRY _ZTV7S1284C4[];
Class_Descriptor cd_S1284C4 = {  "S1284C4", // class name
  0,0,//no base classes
  &(vtc_S1284C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1284C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1284C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1284C6  {
  virtual void  v74(); // _ZN7S1284C63v74Ev
  ~S1284C6(); // tgen
  S1284C6(); // tgen
};
//SIG(-1 S1284C6) C1{ v1}


void  S1284C6 ::v74(){vfunc_called(this, "_ZN7S1284C63v74Ev");}
S1284C6 ::~S1284C6(){ note_dtor("S1284C6", this);} // tgen
S1284C6 ::S1284C6(){ note_ctor("S1284C6", this);} // tgen

static void Test_S1284C6()
{
  extern Class_Descriptor cd_S1284C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1284C6, buf);
    S1284C6 *dp, &lv = *(dp=new (buf) S1284C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1284C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1284C6)");
    test_class_info(&lv, &cd_S1284C6);
    dp->~S1284C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1284C6(Test_S1284C6, "S1284C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1284C6C1Ev();
extern void _ZN7S1284C6D1Ev();
Name_Map name_map_S1284C6[] = {
  NSPAIR(_ZN7S1284C6C1Ev),
  NSPAIR(_ZN7S1284C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1284C6[];
extern void _ZN7S1284C63v74Ev();
static  VTBL_ENTRY vtc_S1284C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1284C6[0]),
  (VTBL_ENTRY)&_ZN7S1284C63v74Ev,
};
extern VTBL_ENTRY _ZTI7S1284C6[];
extern  VTBL_ENTRY _ZTV7S1284C6[];
Class_Descriptor cd_S1284C6 = {  "S1284C6", // class name
  0,0,//no base classes
  &(vtc_S1284C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1284C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1284C6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1284C3  : S1284C4 , S1284C6 {
  void *s1284c3f0;
  int s1284c3f1[7];
  virtual  ~S1284C3(); // _ZN7S1284C3D1Ev
  virtual void  v75(); // _ZN7S1284C33v75Ev
  virtual void  v76(); // _ZN7S1284C33v76Ev
  virtual void  v77(); // _ZN7S1284C33v77Ev
  virtual void  v78(); // _ZN7S1284C33v78Ev
  S1284C3(); // tgen
};
//SIG(-1 S1284C3) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v69} vd v1 v2 v3 v4 Fp Fi[7]}


 S1284C3 ::~S1284C3(){ note_dtor("S1284C3", this);}
void  S1284C3 ::v75(){vfunc_called(this, "_ZN7S1284C33v75Ev");}
void  S1284C3 ::v76(){vfunc_called(this, "_ZN7S1284C33v76Ev");}
void  S1284C3 ::v77(){vfunc_called(this, "_ZN7S1284C33v77Ev");}
void  S1284C3 ::v78(){vfunc_called(this, "_ZN7S1284C33v78Ev");}
S1284C3 ::S1284C3(){ note_ctor("S1284C3", this);} // tgen

static void Test_S1284C3()
{
  extern Class_Descriptor cd_S1284C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,25)];
    init_test(&cd_S1284C3, buf);
    S1284C3 *dp, &lv = *(dp=new (buf) S1284C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,96), "sizeof(S1284C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1284C3)");
    check_base_class_offset(lv, (S1284C4*), 0, "S1284C3");
    check_base_class_offset(lv, (S1284C6*), ABISELECT(96,60), "S1284C3");
    check_field_offset(lv, s1284c3f0, ABISELECT(104,64), "S1284C3.s1284c3f0");
    check_field_offset(lv, s1284c3f1, ABISELECT(112,68), "S1284C3.s1284c3f1");
    test_class_info(&lv, &cd_S1284C3);
    dp->~S1284C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1284C3(Test_S1284C3, "S1284C3", ABISELECT(144,96));

#else // __cplusplus

extern void _ZN7S1284C3C1Ev();
extern void _ZN7S1284C3D1Ev();
Name_Map name_map_S1284C3[] = {
  NSPAIR(_ZN7S1284C3C1Ev),
  NSPAIR(_ZN7S1284C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1284C4;
extern VTBL_ENTRY _ZTI7S1284C4[];
extern  VTBL_ENTRY _ZTV7S1284C4[];
extern Class_Descriptor cd_S1284C6;
extern VTBL_ENTRY _ZTI7S1284C6[];
extern  VTBL_ENTRY _ZTV7S1284C6[];
static Base_Class bases_S1284C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1284C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1284C6,    ABISELECT(96,60), //bcp->offset
    72, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1284C3[];
extern void _ZN7S1284C3D1Ev();
extern void _ZN7S1284C3D0Ev();
extern void _ZN7S1284C43v10Ev();
extern void _ZN7S1284C43v11Ev();
extern void _ZN7S1284C43v12Ev();
extern void _ZN7S1284C43v13Ev();
extern void _ZN7S1284C43v14Ev();
extern void _ZN7S1284C43v15Ev();
extern void _ZN7S1284C43v16Ev();
extern void _ZN7S1284C43v17Ev();
extern void _ZN7S1284C43v18Ev();
extern void _ZN7S1284C43v19Ev();
extern void _ZN7S1284C43v20Ev();
extern void _ZN7S1284C43v21Ev();
extern void _ZN7S1284C43v22Ev();
extern void _ZN7S1284C43v23Ev();
extern void _ZN7S1284C43v24Ev();
extern void _ZN7S1284C43v25Ev();
extern void _ZN7S1284C43v26Ev();
extern void _ZN7S1284C43v27Ev();
extern void _ZN7S1284C43v28Ev();
extern void _ZN7S1284C43v29Ev();
extern void _ZN7S1284C43v30Ev();
extern void _ZN7S1284C43v31Ev();
extern void _ZN7S1284C43v32Ev();
extern void _ZN7S1284C43v33Ev();
extern void _ZN7S1284C43v34Ev();
extern void _ZN7S1284C43v35Ev();
extern void _ZN7S1284C43v36Ev();
extern void _ZN7S1284C43v37Ev();
extern void _ZN7S1284C43v38Ev();
extern void _ZN7S1284C43v39Ev();
extern void _ZN7S1284C43v40Ev();
extern void _ZN7S1284C43v41Ev();
extern void _ZN7S1284C43v42Ev();
extern void _ZN7S1284C43v43Ev();
extern void _ZN7S1284C43v44Ev();
extern void _ZN7S1284C43v45Ev();
extern void _ZN7S1284C43v46Ev();
extern void _ZN7S1284C43v47Ev();
extern void _ZN7S1284C43v48Ev();
extern void _ZN7S1284C43v49Ev();
extern void _ZN7S1284C43v50Ev();
extern void _ZN7S1284C43v51Ev();
extern void _ZN7S1284C43v52Ev();
extern void _ZN7S1284C43v53Ev();
extern void _ZN7S1284C43v54Ev();
extern void _ZN7S1284C43v55Ev();
extern void _ZN7S1284C43v56Ev();
extern void _ZN7S1284C43v57Ev();
extern void _ZN7S1284C43v58Ev();
extern void _ZN7S1284C43v59Ev();
extern void _ZN7S1284C43v60Ev();
extern void _ZN7S1284C43v61Ev();
extern void _ZN7S1284C43v62Ev();
extern void _ZN7S1284C43v63Ev();
extern void _ZN7S1284C43v64Ev();
extern void _ZN7S1284C43v65Ev();
extern void _ZN7S1284C43v66Ev();
extern void _ZN7S1284C43v67Ev();
extern void _ZN7S1284C43v68Ev();
extern void _ZN7S1284C43v69Ev();
extern void _ZN7S1284C43v70Ev();
extern void _ZN7S1284C43v71Ev();
extern void _ZN7S1284C43v72Ev();
extern void _ZN7S1284C43v73Ev();
extern void _ZN7S1284C33v75Ev();
extern void _ZN7S1284C33v76Ev();
extern void _ZN7S1284C33v77Ev();
extern void _ZN7S1284C33v78Ev();
extern void _ZN7S1284C63v74Ev();
static  VTBL_ENTRY vtc_S1284C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1284C3[0]),
  (VTBL_ENTRY)&_ZN7S1284C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1284C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v78Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1284C3[0]),
  (VTBL_ENTRY)&_ZN7S1284C63v74Ev,
};
extern VTBL_ENTRY _ZTI7S1284C3[];
extern  VTBL_ENTRY _ZTV7S1284C3[];
Class_Descriptor cd_S1284C3 = {  "S1284C3", // class name
  bases_S1284C3, 2,
  &(vtc_S1284C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,96), // object size
  NSPAIRA(_ZTI7S1284C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1284C3),75, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1284C7  {
  virtual  ~S1284C7(); // _ZN7S1284C7D1Ev
  virtual void  v79(); // _ZN7S1284C73v79Ev
  virtual void  v80(); // _ZN7S1284C73v80Ev
  virtual void  v81(); // _ZN7S1284C73v81Ev
  S1284C7(); // tgen
};
//SIG(-1 S1284C7) C1{ vd v1 v2 v3}


 S1284C7 ::~S1284C7(){ note_dtor("S1284C7", this);}
void  S1284C7 ::v79(){vfunc_called(this, "_ZN7S1284C73v79Ev");}
void  S1284C7 ::v80(){vfunc_called(this, "_ZN7S1284C73v80Ev");}
void  S1284C7 ::v81(){vfunc_called(this, "_ZN7S1284C73v81Ev");}
S1284C7 ::S1284C7(){ note_ctor("S1284C7", this);} // tgen

static void Test_S1284C7()
{
  extern Class_Descriptor cd_S1284C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1284C7, buf);
    S1284C7 *dp, &lv = *(dp=new (buf) S1284C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1284C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1284C7)");
    test_class_info(&lv, &cd_S1284C7);
    dp->~S1284C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1284C7(Test_S1284C7, "S1284C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1284C7C1Ev();
extern void _ZN7S1284C7D1Ev();
Name_Map name_map_S1284C7[] = {
  NSPAIR(_ZN7S1284C7C1Ev),
  NSPAIR(_ZN7S1284C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1284C7[];
extern void _ZN7S1284C7D1Ev();
extern void _ZN7S1284C7D0Ev();
extern void _ZN7S1284C73v79Ev();
extern void _ZN7S1284C73v80Ev();
extern void _ZN7S1284C73v81Ev();
static  VTBL_ENTRY vtc_S1284C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1284C7[0]),
  (VTBL_ENTRY)&_ZN7S1284C7D1Ev,
  (VTBL_ENTRY)&_ZN7S1284C7D0Ev,
  (VTBL_ENTRY)&_ZN7S1284C73v79Ev,
  (VTBL_ENTRY)&_ZN7S1284C73v80Ev,
  (VTBL_ENTRY)&_ZN7S1284C73v81Ev,
};
extern VTBL_ENTRY _ZTI7S1284C7[];
extern  VTBL_ENTRY _ZTV7S1284C7[];
Class_Descriptor cd_S1284C7 = {  "S1284C7", // class name
  0,0,//no base classes
  &(vtc_S1284C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1284C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1284C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1284C10  : S1537C8_nt {
};
//SIG(-1 S1284C10) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1284C10()
{
  extern Class_Descriptor cd_S1284C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1284C10, buf);
    S1284C10 &lv = *(new (buf) S1284C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1284C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1284C10)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1284C10");
    test_class_info(&lv, &cd_S1284C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1284C10(Test_S1284C10, "S1284C10", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1284C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1284C10 = {  "S1284C10", // class name
  bases_S1284C10, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1284C9  : S1284C10 {
};
//SIG(-1 S1284C9) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1284C9()
{
  extern Class_Descriptor cd_S1284C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1284C9, buf);
    S1284C9 &lv = *(new (buf) S1284C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1284C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1284C9)");
    check_base_class_offset(lv, (S1537C8_nt*)(S1284C10*), 0, "S1284C9");
    check_base_class_offset(lv, (S1284C10*), 0, "S1284C9");
    test_class_info(&lv, &cd_S1284C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1284C9(Test_S1284C9, "S1284C9", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1284C10;
static Base_Class bases_S1284C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1284C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1284C9 = {  "S1284C9", // class name
  bases_S1284C9, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1284C17  {
  int s1284c17f0[28];
  virtual  ~S1284C17(); // _ZN8S1284C17D1Ev
  virtual void  v107(); // _ZN8S1284C174v107Ev
  virtual void  v108(); // _ZN8S1284C174v108Ev
  virtual void  v109(); // _ZN8S1284C174v109Ev
  virtual void  v110(); // _ZN8S1284C174v110Ev
  virtual void  v111(); // _ZN8S1284C174v111Ev
  virtual void  v112(); // _ZN8S1284C174v112Ev
  virtual void  v113(); // _ZN8S1284C174v113Ev
  virtual void  v114(); // _ZN8S1284C174v114Ev
  virtual void  v115(); // _ZN8S1284C174v115Ev
  virtual void  v116(); // _ZN8S1284C174v116Ev
  virtual void  v117(); // _ZN8S1284C174v117Ev
  virtual void  v118(); // _ZN8S1284C174v118Ev
  virtual void  v119(); // _ZN8S1284C174v119Ev
  virtual void  v120(); // _ZN8S1284C174v120Ev
  virtual void  v121(); // _ZN8S1284C174v121Ev
  virtual void  v122(); // _ZN8S1284C174v122Ev
  virtual void  v123(); // _ZN8S1284C174v123Ev
  virtual void  v124(); // _ZN8S1284C174v124Ev
  virtual void  v125(); // _ZN8S1284C174v125Ev
  virtual void  v126(); // _ZN8S1284C174v126Ev
  virtual void  v127(); // _ZN8S1284C174v127Ev
  virtual void  v128(); // _ZN8S1284C174v128Ev
  virtual void  v129(); // _ZN8S1284C174v129Ev
  virtual void  v130(); // _ZN8S1284C174v130Ev
  virtual void  v131(); // _ZN8S1284C174v131Ev
  S1284C17(); // tgen
};
//SIG(-1 S1284C17) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fi[28]}


 S1284C17 ::~S1284C17(){ note_dtor("S1284C17", this);}
void  S1284C17 ::v107(){vfunc_called(this, "_ZN8S1284C174v107Ev");}
void  S1284C17 ::v108(){vfunc_called(this, "_ZN8S1284C174v108Ev");}
void  S1284C17 ::v109(){vfunc_called(this, "_ZN8S1284C174v109Ev");}
void  S1284C17 ::v110(){vfunc_called(this, "_ZN8S1284C174v110Ev");}
void  S1284C17 ::v111(){vfunc_called(this, "_ZN8S1284C174v111Ev");}
void  S1284C17 ::v112(){vfunc_called(this, "_ZN8S1284C174v112Ev");}
void  S1284C17 ::v113(){vfunc_called(this, "_ZN8S1284C174v113Ev");}
void  S1284C17 ::v114(){vfunc_called(this, "_ZN8S1284C174v114Ev");}
void  S1284C17 ::v115(){vfunc_called(this, "_ZN8S1284C174v115Ev");}
void  S1284C17 ::v116(){vfunc_called(this, "_ZN8S1284C174v116Ev");}
void  S1284C17 ::v117(){vfunc_called(this, "_ZN8S1284C174v117Ev");}
void  S1284C17 ::v118(){vfunc_called(this, "_ZN8S1284C174v118Ev");}
void  S1284C17 ::v119(){vfunc_called(this, "_ZN8S1284C174v119Ev");}
void  S1284C17 ::v120(){vfunc_called(this, "_ZN8S1284C174v120Ev");}
void  S1284C17 ::v121(){vfunc_called(this, "_ZN8S1284C174v121Ev");}
void  S1284C17 ::v122(){vfunc_called(this, "_ZN8S1284C174v122Ev");}
void  S1284C17 ::v123(){vfunc_called(this, "_ZN8S1284C174v123Ev");}
void  S1284C17 ::v124(){vfunc_called(this, "_ZN8S1284C174v124Ev");}
void  S1284C17 ::v125(){vfunc_called(this, "_ZN8S1284C174v125Ev");}
void  S1284C17 ::v126(){vfunc_called(this, "_ZN8S1284C174v126Ev");}
void  S1284C17 ::v127(){vfunc_called(this, "_ZN8S1284C174v127Ev");}
void  S1284C17 ::v128(){vfunc_called(this, "_ZN8S1284C174v128Ev");}
void  S1284C17 ::v129(){vfunc_called(this, "_ZN8S1284C174v129Ev");}
void  S1284C17 ::v130(){vfunc_called(this, "_ZN8S1284C174v130Ev");}
void  S1284C17 ::v131(){vfunc_called(this, "_ZN8S1284C174v131Ev");}
S1284C17 ::S1284C17(){ note_ctor("S1284C17", this);} // tgen

static void Test_S1284C17()
{
  extern Class_Descriptor cd_S1284C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,30)];
    init_test(&cd_S1284C17, buf);
    S1284C17 *dp, &lv = *(dp=new (buf) S1284C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,116), "sizeof(S1284C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1284C17)");
    check_field_offset(lv, s1284c17f0, ABISELECT(8,4), "S1284C17.s1284c17f0");
    test_class_info(&lv, &cd_S1284C17);
    dp->~S1284C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1284C17(Test_S1284C17, "S1284C17", ABISELECT(120,116));

#else // __cplusplus

extern void _ZN8S1284C17C1Ev();
extern void _ZN8S1284C17D1Ev();
Name_Map name_map_S1284C17[] = {
  NSPAIR(_ZN8S1284C17C1Ev),
  NSPAIR(_ZN8S1284C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1284C17[];
extern void _ZN8S1284C17D1Ev();
extern void _ZN8S1284C17D0Ev();
extern void _ZN8S1284C174v107Ev();
extern void _ZN8S1284C174v108Ev();
extern void _ZN8S1284C174v109Ev();
extern void _ZN8S1284C174v110Ev();
extern void _ZN8S1284C174v111Ev();
extern void _ZN8S1284C174v112Ev();
extern void _ZN8S1284C174v113Ev();
extern void _ZN8S1284C174v114Ev();
extern void _ZN8S1284C174v115Ev();
extern void _ZN8S1284C174v116Ev();
extern void _ZN8S1284C174v117Ev();
extern void _ZN8S1284C174v118Ev();
extern void _ZN8S1284C174v119Ev();
extern void _ZN8S1284C174v120Ev();
extern void _ZN8S1284C174v121Ev();
extern void _ZN8S1284C174v122Ev();
extern void _ZN8S1284C174v123Ev();
extern void _ZN8S1284C174v124Ev();
extern void _ZN8S1284C174v125Ev();
extern void _ZN8S1284C174v126Ev();
extern void _ZN8S1284C174v127Ev();
extern void _ZN8S1284C174v128Ev();
extern void _ZN8S1284C174v129Ev();
extern void _ZN8S1284C174v130Ev();
extern void _ZN8S1284C174v131Ev();
static  VTBL_ENTRY vtc_S1284C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1284C17[0]),
  (VTBL_ENTRY)&_ZN8S1284C17D1Ev,
  (VTBL_ENTRY)&_ZN8S1284C17D0Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v107Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v108Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v109Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v110Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v111Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v112Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v113Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v114Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v115Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v116Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v117Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v118Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v119Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v120Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v121Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v122Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v123Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v124Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v125Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v126Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v127Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v128Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v129Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v130Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v131Ev,
};
extern VTBL_ENTRY _ZTI8S1284C17[];
extern  VTBL_ENTRY _ZTV8S1284C17[];
Class_Descriptor cd_S1284C17 = {  "S1284C17", // class name
  0,0,//no base classes
  &(vtc_S1284C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,116), // object size
  NSPAIRA(_ZTI8S1284C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1284C17),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1284C16  : S1284C17 {
  ::S1566C29 s1284c16f0;
  int s1284c16f1[2];
  virtual void  v132(); // _ZN8S1284C164v132Ev
  virtual void  v133(); // _ZN8S1284C164v133Ev
  virtual void  v134(); // _ZN8S1284C164v134Ev
  ~S1284C16(); // tgen
  S1284C16(); // tgen
};
//SIG(-1 S1284C16) C1{ BC2{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fi[28]} v1 v2 v3 FC3{ BC4{ m Fp Fi[2]}} Fi[2]}


void  S1284C16 ::v132(){vfunc_called(this, "_ZN8S1284C164v132Ev");}
void  S1284C16 ::v133(){vfunc_called(this, "_ZN8S1284C164v133Ev");}
void  S1284C16 ::v134(){vfunc_called(this, "_ZN8S1284C164v134Ev");}
S1284C16 ::~S1284C16(){ note_dtor("S1284C16", this);} // tgen
S1284C16 ::S1284C16(){ note_ctor("S1284C16", this);} // tgen

static void Test_S1284C16()
{
  extern Class_Descriptor cd_S1284C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,35)];
    init_test(&cd_S1284C16, buf);
    S1284C16 *dp, &lv = *(dp=new (buf) S1284C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,136), "sizeof(S1284C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1284C16)");
    check_base_class_offset(lv, (S1284C17*), 0, "S1284C16");
    check_field_offset(lv, s1284c16f0, ABISELECT(120,116), "S1284C16.s1284c16f0");
    check_field_offset(lv, s1284c16f1, ABISELECT(136,128), "S1284C16.s1284c16f1");
    test_class_info(&lv, &cd_S1284C16);
    dp->~S1284C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1284C16(Test_S1284C16, "S1284C16", ABISELECT(144,136));

#else // __cplusplus

extern void _ZN8S1284C16C1Ev();
extern void _ZN8S1284C16D1Ev();
Name_Map name_map_S1284C16[] = {
  NSPAIR(_ZN8S1284C16C1Ev),
  NSPAIR(_ZN8S1284C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1284C17;
extern VTBL_ENTRY _ZTI8S1284C17[];
extern  VTBL_ENTRY _ZTV8S1284C17[];
static Base_Class bases_S1284C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1284C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1284C16[];
extern void _ZN8S1284C16D1Ev();
extern void _ZN8S1284C16D0Ev();
extern void _ZN8S1284C174v107Ev();
extern void _ZN8S1284C174v108Ev();
extern void _ZN8S1284C174v109Ev();
extern void _ZN8S1284C174v110Ev();
extern void _ZN8S1284C174v111Ev();
extern void _ZN8S1284C174v112Ev();
extern void _ZN8S1284C174v113Ev();
extern void _ZN8S1284C174v114Ev();
extern void _ZN8S1284C174v115Ev();
extern void _ZN8S1284C174v116Ev();
extern void _ZN8S1284C174v117Ev();
extern void _ZN8S1284C174v118Ev();
extern void _ZN8S1284C174v119Ev();
extern void _ZN8S1284C174v120Ev();
extern void _ZN8S1284C174v121Ev();
extern void _ZN8S1284C174v122Ev();
extern void _ZN8S1284C174v123Ev();
extern void _ZN8S1284C174v124Ev();
extern void _ZN8S1284C174v125Ev();
extern void _ZN8S1284C174v126Ev();
extern void _ZN8S1284C174v127Ev();
extern void _ZN8S1284C174v128Ev();
extern void _ZN8S1284C174v129Ev();
extern void _ZN8S1284C174v130Ev();
extern void _ZN8S1284C174v131Ev();
extern void _ZN8S1284C164v132Ev();
extern void _ZN8S1284C164v133Ev();
extern void _ZN8S1284C164v134Ev();
static  VTBL_ENTRY vtc_S1284C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1284C16[0]),
  (VTBL_ENTRY)&_ZN8S1284C16D1Ev,
  (VTBL_ENTRY)&_ZN8S1284C16D0Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v107Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v108Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v109Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v110Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v111Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v112Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v113Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v114Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v115Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v116Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v117Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v118Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v119Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v120Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v121Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v122Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v123Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v124Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v125Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v126Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v127Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v128Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v129Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v130Ev,
  (VTBL_ENTRY)&_ZN8S1284C174v131Ev,
  (VTBL_ENTRY)&_ZN8S1284C164v132Ev,
  (VTBL_ENTRY)&_ZN8S1284C164v133Ev,
  (VTBL_ENTRY)&_ZN8S1284C164v134Ev,
};
extern VTBL_ENTRY _ZTI8S1284C16[];
extern  VTBL_ENTRY _ZTV8S1284C16[];
Class_Descriptor cd_S1284C16 = {  "S1284C16", // class name
  bases_S1284C16, 1,
  &(vtc_S1284C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,136), // object size
  NSPAIRA(_ZTI8S1284C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1284C16),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1284C2  : S1284C3 , S1284C7 {
  void *s1284c2f0;
  int s1284c2f1;
  ::S1325C21 s1284c2f2;
  void *s1284c2f3;
  int s1284c2f4[6];
  ::S1284C9 s1284c2f5;
  ::S1284C9 s1284c2f6;
  int s1284c2f7[3];
  ::S1325C7_nt s1284c2f8;
  ::S1284C9 s1284c2f9;
  ::S1284C9 s1284c2f10;
  __tsi64 s1284c2f11[3];
  int s1284c2f12[2];
  ::S1537C5_nt s1284c2f13;
  ::S1537C5_nt s1284c2f14;
  int s1284c2f15[2];
  void *s1284c2f16;
  ::S1566C15 s1284c2f17;
  __tsi64 s1284c2f18;
  int s1284c2f19[6];
  __tsi64 s1284c2f20[4];
  int s1284c2f21;
  ::S1284C16 s1284c2f22;
  __tsi64 s1284c2f23[256];
  int s1284c2f24[259];
  void *s1284c2f25[1023];
  int s1284c2f26[3069];
  ::S1566C10 s1284c2f27;
  ::S1566C10 s1284c2f28;
  ::S1537C23 s1284c2f29;
  ::S1537C19 s1284c2f30;
  ::S1566C22_nt s1284c2f31;
  void *s1284c2f32;
  ::S1537C13 s1284c2f33;
  ::S1537C7_nt s1284c2f34;
  ::S1566C14_nt s1284c2f35;
  ::S1325C31 s1284c2f36;
  ::S1325C27 s1284c2f37;
  ::S1325C23 s1284c2f38;
  void *s1284c2f39[2];
  int s1284c2f40;
  ::S1566C30 s1284c2f41;
  ::S1325C14 s1284c2f42;
  virtual  ~S1284C2(); // _ZN7S1284C2D1Ev
  virtual void  v82(); // _ZN7S1284C23v82Ev
  virtual void  v83(); // _ZN7S1284C23v83Ev
  virtual void  v84(); // _ZN7S1284C23v84Ev
  virtual void  v85(); // _ZN7S1284C23v85Ev
  virtual void  v86(); // _ZN7S1284C23v86Ev
  virtual void  v87(); // _ZN7S1284C23v87Ev
  virtual void  v88(); // _ZN7S1284C23v88Ev
  virtual void  v89(); // _ZN7S1284C23v89Ev
  virtual void  v90(); // _ZN7S1284C23v90Ev
  virtual void  v91(); // _ZN7S1284C23v91Ev
  virtual void  v92(); // _ZN7S1284C23v92Ev
  virtual void  v93(); // _ZN7S1284C23v93Ev
  virtual void  v94(); // _ZN7S1284C23v94Ev
  virtual void  v95(); // _ZN7S1284C23v95Ev
  virtual void  v96(); // _ZN7S1284C23v96Ev
  virtual void  v97(); // _ZN7S1284C23v97Ev
  virtual void  v98(); // _ZN7S1284C23v98Ev
  virtual void  v99(); // _ZN7S1284C23v99Ev
  virtual void  v100(); // _ZN7S1284C24v100Ev
  virtual void  v101(); // _ZN7S1284C24v101Ev
  virtual void  v102(); // _ZN7S1284C24v102Ev
  virtual void  v103(); // _ZN7S1284C24v103Ev
  virtual void  v104(); // _ZN7S1284C24v104Ev
  S1284C2(); // tgen
};
//SIG(-1 S1284C2) C1{ BC2{ BC3{ vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v88} vd v89 v90 v91 v92 Fp Fi[7]} BC6{ vd v93 v94 v95} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC7{ m FC8{ BC9{ BC10{ m Fp Fi[2]}}} FC8 Fi FC8 FC11{ BC10} FC8 Fi} Fp Fi[6] FC12{ BC13{ BC10}} FC12 Fi[3] FC14{ BC8} FC12 FC12 FL[3] Fi[2] FC15{ m Fi[2]} FC15 Fi[2] Fp FC16{ BC17{ BC18{ vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 Fi[28]} v123 v124 v125 FC19{ BC10} Fi[2]} v96 v97 Fp[2] FL Fi[5] Fc[3]} FL Fi[6] FL[4] Fi FC20{ BC21{ vd v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 Fi[28]} v126 v127 v128 FC22{ BC10} Fi[2]} FL[256] Fi[259] Fp[1023] Fi[3069] FC23{ BC10} FC23 FC19 FC24{ BC10} FC25{ BC26{ m FC27{ BC10} Fp Fi}} Fp FC28{ BC10} FC29{ BC10} FC4 FC27 FC30{ BC10} FC31{ BC10} Fp[2] Fi FC32{ m Fi[5]} FC11}


 S1284C2 ::~S1284C2(){ note_dtor("S1284C2", this);}
void  S1284C2 ::v82(){vfunc_called(this, "_ZN7S1284C23v82Ev");}
void  S1284C2 ::v83(){vfunc_called(this, "_ZN7S1284C23v83Ev");}
void  S1284C2 ::v84(){vfunc_called(this, "_ZN7S1284C23v84Ev");}
void  S1284C2 ::v85(){vfunc_called(this, "_ZN7S1284C23v85Ev");}
void  S1284C2 ::v86(){vfunc_called(this, "_ZN7S1284C23v86Ev");}
void  S1284C2 ::v87(){vfunc_called(this, "_ZN7S1284C23v87Ev");}
void  S1284C2 ::v88(){vfunc_called(this, "_ZN7S1284C23v88Ev");}
void  S1284C2 ::v89(){vfunc_called(this, "_ZN7S1284C23v89Ev");}
void  S1284C2 ::v90(){vfunc_called(this, "_ZN7S1284C23v90Ev");}
void  S1284C2 ::v91(){vfunc_called(this, "_ZN7S1284C23v91Ev");}
void  S1284C2 ::v92(){vfunc_called(this, "_ZN7S1284C23v92Ev");}
void  S1284C2 ::v93(){vfunc_called(this, "_ZN7S1284C23v93Ev");}
void  S1284C2 ::v94(){vfunc_called(this, "_ZN7S1284C23v94Ev");}
void  S1284C2 ::v95(){vfunc_called(this, "_ZN7S1284C23v95Ev");}
void  S1284C2 ::v96(){vfunc_called(this, "_ZN7S1284C23v96Ev");}
void  S1284C2 ::v97(){vfunc_called(this, "_ZN7S1284C23v97Ev");}
void  S1284C2 ::v98(){vfunc_called(this, "_ZN7S1284C23v98Ev");}
void  S1284C2 ::v99(){vfunc_called(this, "_ZN7S1284C23v99Ev");}
void  S1284C2 ::v100(){vfunc_called(this, "_ZN7S1284C24v100Ev");}
void  S1284C2 ::v101(){vfunc_called(this, "_ZN7S1284C24v101Ev");}
void  S1284C2 ::v102(){vfunc_called(this, "_ZN7S1284C24v102Ev");}
void  S1284C2 ::v103(){vfunc_called(this, "_ZN7S1284C24v103Ev");}
void  S1284C2 ::v104(){vfunc_called(this, "_ZN7S1284C24v104Ev");}
S1284C2 ::S1284C2(){ note_ctor("S1284C2", this);} // tgen

static void Test_S1284C2()
{
  extern Class_Descriptor cd_S1284C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3084,5089)];
    init_test(&cd_S1284C2, buf);
    S1284C2 *dp, &lv = *(dp=new (buf) S1284C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24664,20352), "sizeof(S1284C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1284C2)");
    check_base_class_offset(lv, (S1284C4*)(S1284C3*), 0, "S1284C2");
    check_base_class_offset(lv, (S1284C6*)(S1284C3*), ABISELECT(96,60), "S1284C2");
    check_base_class_offset(lv, (S1284C3*), 0, "S1284C2");
    check_base_class_offset(lv, (S1284C7*), ABISELECT(144,96), "S1284C2");
    check_field_offset(lv, s1284c2f0, ABISELECT(152,100), "S1284C2.s1284c2f0");
    check_field_offset(lv, s1284c2f1, ABISELECT(160,104), "S1284C2.s1284c2f1");
    check_field_offset(lv, s1284c2f2, ABISELECT(168,108), "S1284C2.s1284c2f2");
    check_field_offset(lv, s1284c2f3, ABISELECT(264,176), "S1284C2.s1284c2f3");
    check_field_offset(lv, s1284c2f4, ABISELECT(272,180), "S1284C2.s1284c2f4");
    check_field_offset(lv, s1284c2f5, ABISELECT(296,204), "S1284C2.s1284c2f5");
    check_field_offset(lv, s1284c2f6, ABISELECT(312,216), "S1284C2.s1284c2f6");
    check_field_offset(lv, s1284c2f7, ABISELECT(328,228), "S1284C2.s1284c2f7");
    check_field_offset(lv, s1284c2f8, ABISELECT(344,240), "S1284C2.s1284c2f8");
    check_field_offset(lv, s1284c2f9, ABISELECT(360,252), "S1284C2.s1284c2f9");
    check_field_offset(lv, s1284c2f10, ABISELECT(376,264), "S1284C2.s1284c2f10");
    check_field_offset(lv, s1284c2f11, ABISELECT(392,276), "S1284C2.s1284c2f11");
    check_field_offset(lv, s1284c2f12, ABISELECT(416,300), "S1284C2.s1284c2f12");
    check_field_offset(lv, s1284c2f13, ABISELECT(424,308), "S1284C2.s1284c2f13");
    check_field_offset(lv, s1284c2f14, ABISELECT(432,316), "S1284C2.s1284c2f14");
    check_field_offset(lv, s1284c2f15, ABISELECT(440,324), "S1284C2.s1284c2f15");
    check_field_offset(lv, s1284c2f16, ABISELECT(448,332), "S1284C2.s1284c2f16");
    check_field_offset(lv, s1284c2f17, ABISELECT(456,336), "S1284C2.s1284c2f17");
    check_field_offset(lv, s1284c2f18, ABISELECT(648,512), "S1284C2.s1284c2f18");
    check_field_offset(lv, s1284c2f19, ABISELECT(656,520), "S1284C2.s1284c2f19");
    check_field_offset(lv, s1284c2f20, ABISELECT(680,544), "S1284C2.s1284c2f20");
    check_field_offset(lv, s1284c2f21, ABISELECT(712,576), "S1284C2.s1284c2f21");
    check_field_offset(lv, s1284c2f22, ABISELECT(720,580), "S1284C2.s1284c2f22");
    check_field_offset(lv, s1284c2f23, ABISELECT(864,716), "S1284C2.s1284c2f23");
    check_field_offset(lv, s1284c2f24, ABISELECT(2912,2764), "S1284C2.s1284c2f24");
    check_field_offset(lv, s1284c2f25, ABISELECT(3952,3800), "S1284C2.s1284c2f25");
    check_field_offset(lv, s1284c2f26, ABISELECT(12136,7892), "S1284C2.s1284c2f26");
    check_field_offset(lv, s1284c2f27, ABISELECT(24416,20168), "S1284C2.s1284c2f27");
    check_field_offset(lv, s1284c2f28, ABISELECT(24432,20180), "S1284C2.s1284c2f28");
    check_field_offset(lv, s1284c2f29, ABISELECT(24448,20192), "S1284C2.s1284c2f29");
    check_field_offset(lv, s1284c2f30, ABISELECT(24464,20204), "S1284C2.s1284c2f30");
    check_field_offset(lv, s1284c2f31, ABISELECT(24480,20216), "S1284C2.s1284c2f31");
    check_field_offset(lv, s1284c2f32, ABISELECT(24512,20236), "S1284C2.s1284c2f32");
    check_field_offset(lv, s1284c2f33, ABISELECT(24520,20240), "S1284C2.s1284c2f33");
    check_field_offset(lv, s1284c2f34, ABISELECT(24536,20252), "S1284C2.s1284c2f34");
    check_field_offset(lv, s1284c2f35, ABISELECT(24552,20264), "S1284C2.s1284c2f35");
    check_field_offset(lv, s1284c2f36, ABISELECT(24560,20272), "S1284C2.s1284c2f36");
    check_field_offset(lv, s1284c2f37, ABISELECT(24576,20284), "S1284C2.s1284c2f37");
    check_field_offset(lv, s1284c2f38, ABISELECT(24592,20296), "S1284C2.s1284c2f38");
    check_field_offset(lv, s1284c2f39, ABISELECT(24608,20308), "S1284C2.s1284c2f39");
    check_field_offset(lv, s1284c2f40, ABISELECT(24624,20316), "S1284C2.s1284c2f40");
    check_field_offset(lv, s1284c2f41, ABISELECT(24628,20320), "S1284C2.s1284c2f41");
    check_field_offset(lv, s1284c2f42, ABISELECT(24648,20340), "S1284C2.s1284c2f42");
    test_class_info(&lv, &cd_S1284C2);
    dp->~S1284C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1284C2(Test_S1284C2, "S1284C2", ABISELECT(24664,20352));

#else // __cplusplus

extern void _ZN7S1284C2C1Ev();
extern void _ZN7S1284C2D1Ev();
Name_Map name_map_S1284C2[] = {
  NSPAIR(_ZN7S1284C2C1Ev),
  NSPAIR(_ZN7S1284C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1284C4;
extern VTBL_ENTRY _ZTI7S1284C4[];
extern  VTBL_ENTRY _ZTV7S1284C4[];
extern Class_Descriptor cd_S1284C6;
extern VTBL_ENTRY _ZTI7S1284C6[];
extern  VTBL_ENTRY _ZTV7S1284C6[];
extern Class_Descriptor cd_S1284C3;
extern VTBL_ENTRY _ZTI7S1284C3[];
extern  VTBL_ENTRY _ZTV7S1284C3[];
extern Class_Descriptor cd_S1284C7;
extern VTBL_ENTRY _ZTI7S1284C7[];
extern  VTBL_ENTRY _ZTV7S1284C7[];
static Base_Class bases_S1284C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1284C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1284C6,    ABISELECT(96,60), //bcp->offset
    95, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1284C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1284C7,    ABISELECT(144,96), //bcp->offset
    98, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1284C2[];
extern void _ZN7S1284C2D1Ev();
extern void _ZN7S1284C2D0Ev();
extern void _ZN7S1284C43v10Ev();
extern void _ZN7S1284C43v11Ev();
extern void _ZN7S1284C43v12Ev();
extern void _ZN7S1284C43v13Ev();
extern void _ZN7S1284C43v14Ev();
extern void _ZN7S1284C43v15Ev();
extern void _ZN7S1284C43v16Ev();
extern void _ZN7S1284C43v17Ev();
extern void _ZN7S1284C43v18Ev();
extern void _ZN7S1284C43v19Ev();
extern void _ZN7S1284C43v20Ev();
extern void _ZN7S1284C43v21Ev();
extern void _ZN7S1284C43v22Ev();
extern void _ZN7S1284C43v23Ev();
extern void _ZN7S1284C43v24Ev();
extern void _ZN7S1284C43v25Ev();
extern void _ZN7S1284C43v26Ev();
extern void _ZN7S1284C43v27Ev();
extern void _ZN7S1284C43v28Ev();
extern void _ZN7S1284C43v29Ev();
extern void _ZN7S1284C43v30Ev();
extern void _ZN7S1284C43v31Ev();
extern void _ZN7S1284C43v32Ev();
extern void _ZN7S1284C43v33Ev();
extern void _ZN7S1284C43v34Ev();
extern void _ZN7S1284C43v35Ev();
extern void _ZN7S1284C43v36Ev();
extern void _ZN7S1284C43v37Ev();
extern void _ZN7S1284C43v38Ev();
extern void _ZN7S1284C43v39Ev();
extern void _ZN7S1284C43v40Ev();
extern void _ZN7S1284C43v41Ev();
extern void _ZN7S1284C43v42Ev();
extern void _ZN7S1284C43v43Ev();
extern void _ZN7S1284C43v44Ev();
extern void _ZN7S1284C43v45Ev();
extern void _ZN7S1284C43v46Ev();
extern void _ZN7S1284C43v47Ev();
extern void _ZN7S1284C43v48Ev();
extern void _ZN7S1284C43v49Ev();
extern void _ZN7S1284C43v50Ev();
extern void _ZN7S1284C43v51Ev();
extern void _ZN7S1284C43v52Ev();
extern void _ZN7S1284C43v53Ev();
extern void _ZN7S1284C43v54Ev();
extern void _ZN7S1284C43v55Ev();
extern void _ZN7S1284C43v56Ev();
extern void _ZN7S1284C43v57Ev();
extern void _ZN7S1284C43v58Ev();
extern void _ZN7S1284C43v59Ev();
extern void _ZN7S1284C43v60Ev();
extern void _ZN7S1284C43v61Ev();
extern void _ZN7S1284C43v62Ev();
extern void _ZN7S1284C43v63Ev();
extern void _ZN7S1284C43v64Ev();
extern void _ZN7S1284C43v65Ev();
extern void _ZN7S1284C43v66Ev();
extern void _ZN7S1284C43v67Ev();
extern void _ZN7S1284C43v68Ev();
extern void _ZN7S1284C43v69Ev();
extern void _ZN7S1284C43v70Ev();
extern void _ZN7S1284C43v71Ev();
extern void _ZN7S1284C43v72Ev();
extern void _ZN7S1284C43v73Ev();
extern void _ZN7S1284C33v75Ev();
extern void _ZN7S1284C33v76Ev();
extern void _ZN7S1284C33v77Ev();
extern void _ZN7S1284C33v78Ev();
extern void _ZN7S1284C23v82Ev();
extern void _ZN7S1284C23v83Ev();
extern void _ZN7S1284C23v84Ev();
extern void _ZN7S1284C23v85Ev();
extern void _ZN7S1284C23v86Ev();
extern void _ZN7S1284C23v87Ev();
extern void _ZN7S1284C23v88Ev();
extern void _ZN7S1284C23v89Ev();
extern void _ZN7S1284C23v90Ev();
extern void _ZN7S1284C23v91Ev();
extern void _ZN7S1284C23v92Ev();
extern void _ZN7S1284C23v93Ev();
extern void _ZN7S1284C23v94Ev();
extern void _ZN7S1284C23v95Ev();
extern void _ZN7S1284C23v96Ev();
extern void _ZN7S1284C23v97Ev();
extern void _ZN7S1284C23v98Ev();
extern void _ZN7S1284C23v99Ev();
extern void _ZN7S1284C24v100Ev();
extern void _ZN7S1284C24v101Ev();
extern void _ZN7S1284C24v102Ev();
extern void _ZN7S1284C24v103Ev();
extern void _ZN7S1284C24v104Ev();
extern void _ZN7S1284C63v74Ev();
extern void ABISELECT(_ZThn144_N7S1284C2D1Ev,_ZThn96_N7S1284C2D1Ev)();
extern void ABISELECT(_ZThn144_N7S1284C2D0Ev,_ZThn96_N7S1284C2D0Ev)();
extern void _ZN7S1284C73v79Ev();
extern void _ZN7S1284C73v80Ev();
extern void _ZN7S1284C73v81Ev();
static  VTBL_ENTRY vtc_S1284C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1284C2[0]),
  (VTBL_ENTRY)&_ZN7S1284C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1284C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1284C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1284C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1284C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1284C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1284C24v104Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1284C2[0]),
  (VTBL_ENTRY)&_ZN7S1284C63v74Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI7S1284C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1284C2D1Ev,_ZThn96_N7S1284C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1284C2D0Ev,_ZThn96_N7S1284C2D0Ev),
  (VTBL_ENTRY)&_ZN7S1284C73v79Ev,
  (VTBL_ENTRY)&_ZN7S1284C73v80Ev,
  (VTBL_ENTRY)&_ZN7S1284C73v81Ev,
};
extern VTBL_ENTRY _ZTI7S1284C2[];
extern  VTBL_ENTRY _ZTV7S1284C2[];
Class_Descriptor cd_S1284C2 = {  "S1284C2", // class name
  bases_S1284C2, 4,
  &(vtc_S1284C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24664,20352), // object size
  NSPAIRA(_ZTI7S1284C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1284C2),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1284C1  : S1284C2 {
  virtual  ~S1284C1(); // _ZN7S1284C1D1Ev
  virtual void  v1(); // _ZN7S1284C12v1Ev
  virtual void  v2(); // _ZN7S1284C12v2Ev
  virtual void  v3(); // _ZN7S1284C12v3Ev
  virtual void  v4(); // _ZN7S1284C12v4Ev
  virtual void  v5(); // _ZN7S1284C12v5Ev
  virtual void  v6(); // _ZN7S1284C12v6Ev
  virtual void  v7(); // _ZN7S1284C12v7Ev
  virtual void  v8(); // _ZN7S1284C12v8Ev
  virtual void  v9(); // _ZN7S1284C12v9Ev
  S1284C1(); // tgen
};
//SIG(1 S1284C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v74} vd v75 v76 v77 v78 Fp Fi[7]} BC7{ vd v79 v80 v81} vd v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 Fp Fi FC8{ m FC9{ BC10{ BC11{ m Fp Fi[2]}}} FC9 Fi FC9 FC12{ BC11} FC9 Fi} Fp Fi[6] FC13{ BC14{ BC11}} FC13 Fi[3] FC15{ BC9} FC13 FC13 FL[3] Fi[2] FC16{ m Fi[2]} FC16 Fi[2] Fp FC17{ BC18{ BC19{ vd v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 Fi[28]} v132 v133 v134 FC20{ BC11} Fi[2]} v105 v106 Fp[2] FL Fi[5] Fc[3]} FL Fi[6] FL[4] Fi FC21{ BC22{ vd v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 Fi[28]} v135 v136 v137 FC23{ BC11} Fi[2]} FL[256] Fi[259] Fp[1023] Fi[3069] FC24{ BC11} FC24 FC20 FC25{ BC11} FC26{ BC27{ m FC28{ BC11} Fp Fi}} Fp FC29{ BC11} FC30{ BC11} FC5 FC28 FC31{ BC11} FC32{ BC11} Fp[2] Fi FC33{ m Fi[5]} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9}


 S1284C1 ::~S1284C1(){ note_dtor("S1284C1", this);}
void  S1284C1 ::v1(){vfunc_called(this, "_ZN7S1284C12v1Ev");}
void  S1284C1 ::v2(){vfunc_called(this, "_ZN7S1284C12v2Ev");}
void  S1284C1 ::v3(){vfunc_called(this, "_ZN7S1284C12v3Ev");}
void  S1284C1 ::v4(){vfunc_called(this, "_ZN7S1284C12v4Ev");}
void  S1284C1 ::v5(){vfunc_called(this, "_ZN7S1284C12v5Ev");}
void  S1284C1 ::v6(){vfunc_called(this, "_ZN7S1284C12v6Ev");}
void  S1284C1 ::v7(){vfunc_called(this, "_ZN7S1284C12v7Ev");}
void  S1284C1 ::v8(){vfunc_called(this, "_ZN7S1284C12v8Ev");}
void  S1284C1 ::v9(){vfunc_called(this, "_ZN7S1284C12v9Ev");}
S1284C1 ::S1284C1(){ note_ctor("S1284C1", this);} // tgen

static void Test_S1284C1()
{
  extern Class_Descriptor cd_S1284C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3084,5089)];
    init_test(&cd_S1284C1, buf);
    S1284C1 *dp, &lv = *(dp=new (buf) S1284C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24664,20352), "sizeof(S1284C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1284C1)");
    check_base_class_offset(lv, (S1284C4*)(S1284C3*)(S1284C2*), 0, "S1284C1");
    check_base_class_offset(lv, (S1284C6*)(S1284C3*)(S1284C2*), ABISELECT(96,60), "S1284C1");
    check_base_class_offset(lv, (S1284C3*)(S1284C2*), 0, "S1284C1");
    check_base_class_offset(lv, (S1284C7*)(S1284C2*), ABISELECT(144,96), "S1284C1");
    check_base_class_offset(lv, (S1284C2*), 0, "S1284C1");
    test_class_info(&lv, &cd_S1284C1);
    dp->~S1284C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1284C1(Test_S1284C1, "S1284C1", ABISELECT(24664,20352));

#else // __cplusplus

extern void _ZN7S1284C1C1Ev();
extern void _ZN7S1284C1D1Ev();
Name_Map name_map_S1284C1[] = {
  NSPAIR(_ZN7S1284C1C1Ev),
  NSPAIR(_ZN7S1284C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1284C4;
extern VTBL_ENTRY _ZTI7S1284C4[];
extern  VTBL_ENTRY _ZTV7S1284C4[];
extern Class_Descriptor cd_S1284C6;
extern VTBL_ENTRY _ZTI7S1284C6[];
extern  VTBL_ENTRY _ZTV7S1284C6[];
extern Class_Descriptor cd_S1284C3;
extern VTBL_ENTRY _ZTI7S1284C3[];
extern  VTBL_ENTRY _ZTV7S1284C3[];
extern Class_Descriptor cd_S1284C7;
extern VTBL_ENTRY _ZTI7S1284C7[];
extern  VTBL_ENTRY _ZTV7S1284C7[];
extern Class_Descriptor cd_S1284C2;
extern VTBL_ENTRY _ZTI7S1284C2[];
extern  VTBL_ENTRY _ZTV7S1284C2[];
static Base_Class bases_S1284C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1284C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1284C6,    ABISELECT(96,60), //bcp->offset
    104, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1284C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1284C7,    ABISELECT(144,96), //bcp->offset
    107, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1284C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1284C1[];
extern void _ZN7S1284C1D1Ev();
extern void _ZN7S1284C1D0Ev();
extern void _ZN7S1284C43v10Ev();
extern void _ZN7S1284C43v11Ev();
extern void _ZN7S1284C43v12Ev();
extern void _ZN7S1284C43v13Ev();
extern void _ZN7S1284C43v14Ev();
extern void _ZN7S1284C43v15Ev();
extern void _ZN7S1284C43v16Ev();
extern void _ZN7S1284C43v17Ev();
extern void _ZN7S1284C43v18Ev();
extern void _ZN7S1284C43v19Ev();
extern void _ZN7S1284C43v20Ev();
extern void _ZN7S1284C43v21Ev();
extern void _ZN7S1284C43v22Ev();
extern void _ZN7S1284C43v23Ev();
extern void _ZN7S1284C43v24Ev();
extern void _ZN7S1284C43v25Ev();
extern void _ZN7S1284C43v26Ev();
extern void _ZN7S1284C43v27Ev();
extern void _ZN7S1284C43v28Ev();
extern void _ZN7S1284C43v29Ev();
extern void _ZN7S1284C43v30Ev();
extern void _ZN7S1284C43v31Ev();
extern void _ZN7S1284C43v32Ev();
extern void _ZN7S1284C43v33Ev();
extern void _ZN7S1284C43v34Ev();
extern void _ZN7S1284C43v35Ev();
extern void _ZN7S1284C43v36Ev();
extern void _ZN7S1284C43v37Ev();
extern void _ZN7S1284C43v38Ev();
extern void _ZN7S1284C43v39Ev();
extern void _ZN7S1284C43v40Ev();
extern void _ZN7S1284C43v41Ev();
extern void _ZN7S1284C43v42Ev();
extern void _ZN7S1284C43v43Ev();
extern void _ZN7S1284C43v44Ev();
extern void _ZN7S1284C43v45Ev();
extern void _ZN7S1284C43v46Ev();
extern void _ZN7S1284C43v47Ev();
extern void _ZN7S1284C43v48Ev();
extern void _ZN7S1284C43v49Ev();
extern void _ZN7S1284C43v50Ev();
extern void _ZN7S1284C43v51Ev();
extern void _ZN7S1284C43v52Ev();
extern void _ZN7S1284C43v53Ev();
extern void _ZN7S1284C43v54Ev();
extern void _ZN7S1284C43v55Ev();
extern void _ZN7S1284C43v56Ev();
extern void _ZN7S1284C43v57Ev();
extern void _ZN7S1284C43v58Ev();
extern void _ZN7S1284C43v59Ev();
extern void _ZN7S1284C43v60Ev();
extern void _ZN7S1284C43v61Ev();
extern void _ZN7S1284C43v62Ev();
extern void _ZN7S1284C43v63Ev();
extern void _ZN7S1284C43v64Ev();
extern void _ZN7S1284C43v65Ev();
extern void _ZN7S1284C43v66Ev();
extern void _ZN7S1284C43v67Ev();
extern void _ZN7S1284C43v68Ev();
extern void _ZN7S1284C43v69Ev();
extern void _ZN7S1284C43v70Ev();
extern void _ZN7S1284C43v71Ev();
extern void _ZN7S1284C43v72Ev();
extern void _ZN7S1284C43v73Ev();
extern void _ZN7S1284C33v75Ev();
extern void _ZN7S1284C33v76Ev();
extern void _ZN7S1284C33v77Ev();
extern void _ZN7S1284C33v78Ev();
extern void _ZN7S1284C23v82Ev();
extern void _ZN7S1284C23v83Ev();
extern void _ZN7S1284C23v84Ev();
extern void _ZN7S1284C23v85Ev();
extern void _ZN7S1284C23v86Ev();
extern void _ZN7S1284C23v87Ev();
extern void _ZN7S1284C23v88Ev();
extern void _ZN7S1284C23v89Ev();
extern void _ZN7S1284C23v90Ev();
extern void _ZN7S1284C23v91Ev();
extern void _ZN7S1284C23v92Ev();
extern void _ZN7S1284C23v93Ev();
extern void _ZN7S1284C23v94Ev();
extern void _ZN7S1284C23v95Ev();
extern void _ZN7S1284C23v96Ev();
extern void _ZN7S1284C23v97Ev();
extern void _ZN7S1284C23v98Ev();
extern void _ZN7S1284C23v99Ev();
extern void _ZN7S1284C24v100Ev();
extern void _ZN7S1284C24v101Ev();
extern void _ZN7S1284C24v102Ev();
extern void _ZN7S1284C24v103Ev();
extern void _ZN7S1284C24v104Ev();
extern void _ZN7S1284C12v1Ev();
extern void _ZN7S1284C12v2Ev();
extern void _ZN7S1284C12v3Ev();
extern void _ZN7S1284C12v4Ev();
extern void _ZN7S1284C12v5Ev();
extern void _ZN7S1284C12v6Ev();
extern void _ZN7S1284C12v7Ev();
extern void _ZN7S1284C12v8Ev();
extern void _ZN7S1284C12v9Ev();
extern void _ZN7S1284C63v74Ev();
extern void ABISELECT(_ZThn144_N7S1284C1D1Ev,_ZThn96_N7S1284C1D1Ev)();
extern void ABISELECT(_ZThn144_N7S1284C1D0Ev,_ZThn96_N7S1284C1D0Ev)();
extern void _ZN7S1284C73v79Ev();
extern void _ZN7S1284C73v80Ev();
extern void _ZN7S1284C73v81Ev();
static  VTBL_ENTRY vtc_S1284C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1284C1[0]),
  (VTBL_ENTRY)&_ZN7S1284C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1284C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1284C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1284C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1284C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1284C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1284C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1284C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1284C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1284C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1284C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1284C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1284C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1284C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1284C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1284C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1284C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1284C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1284C12v9Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1284C1[0]),
  (VTBL_ENTRY)&_ZN7S1284C63v74Ev,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI7S1284C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1284C1D1Ev,_ZThn96_N7S1284C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N7S1284C1D0Ev,_ZThn96_N7S1284C1D0Ev),
  (VTBL_ENTRY)&_ZN7S1284C73v79Ev,
  (VTBL_ENTRY)&_ZN7S1284C73v80Ev,
  (VTBL_ENTRY)&_ZN7S1284C73v81Ev,
};
extern VTBL_ENTRY _ZTI7S1284C1[];
extern  VTBL_ENTRY _ZTV7S1284C1[];
Class_Descriptor cd_S1284C1 = {  "S1284C1", // class name
  bases_S1284C1, 5,
  &(vtc_S1284C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24664,20352), // object size
  NSPAIRA(_ZTI7S1284C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1284C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1307C4  {
  int s1307c4f0;
  __tsi64 s1307c4f1;
  void *s1307c4f2[4];
  int s1307c4f3[2];
  void *s1307c4f4;
  ::S1566C14_nt s1307c4f5;
  void *s1307c4f6[2];
  virtual  ~S1307C4(); // _ZN7S1307C4D1Ev
  virtual void  v12(); // _ZN7S1307C43v12Ev
  virtual void  v13(); // _ZN7S1307C43v13Ev
  virtual void  v14(); // _ZN7S1307C43v14Ev
  virtual void  v15(); // _ZN7S1307C43v15Ev
  virtual void  v16(); // _ZN7S1307C43v16Ev
  virtual void  v17(); // _ZN7S1307C43v17Ev
  virtual void  v18(); // _ZN7S1307C43v18Ev
  virtual void  v19(); // _ZN7S1307C43v19Ev
  virtual void  v20(); // _ZN7S1307C43v20Ev
  virtual void  v21(); // _ZN7S1307C43v21Ev
  virtual void  v22(); // _ZN7S1307C43v22Ev
  virtual void  v23(); // _ZN7S1307C43v23Ev
  virtual void  v24(); // _ZN7S1307C43v24Ev
  virtual void  v25(); // _ZN7S1307C43v25Ev
  virtual void  v26(); // _ZN7S1307C43v26Ev
  virtual void  v27(); // _ZN7S1307C43v27Ev
  virtual void  v28(); // _ZN7S1307C43v28Ev
  virtual void  v29(); // _ZN7S1307C43v29Ev
  virtual void  v30(); // _ZN7S1307C43v30Ev
  virtual void  v31(); // _ZN7S1307C43v31Ev
  virtual void  v32(); // _ZN7S1307C43v32Ev
  virtual void  v33(); // _ZN7S1307C43v33Ev
  virtual void  v34(); // _ZN7S1307C43v34Ev
  virtual void  v35(); // _ZN7S1307C43v35Ev
  virtual void  v36(); // _ZN7S1307C43v36Ev
  virtual void  v37(); // _ZN7S1307C43v37Ev
  virtual void  v38(); // _ZN7S1307C43v38Ev
  virtual void  v39(); // _ZN7S1307C43v39Ev
  virtual void  v40(); // _ZN7S1307C43v40Ev
  virtual void  v41(); // _ZN7S1307C43v41Ev
  virtual void  v42(); // _ZN7S1307C43v42Ev
  virtual void  v43(); // _ZN7S1307C43v43Ev
  virtual void  v44(); // _ZN7S1307C43v44Ev
  virtual void  v45(); // _ZN7S1307C43v45Ev
  virtual void  v46(); // _ZN7S1307C43v46Ev
  virtual void  v47(); // _ZN7S1307C43v47Ev
  virtual void  v48(); // _ZN7S1307C43v48Ev
  virtual void  v49(); // _ZN7S1307C43v49Ev
  virtual void  v50(); // _ZN7S1307C43v50Ev
  virtual void  v51(); // _ZN7S1307C43v51Ev
  virtual void  v52(); // _ZN7S1307C43v52Ev
  virtual void  v53(); // _ZN7S1307C43v53Ev
  virtual void  v54(); // _ZN7S1307C43v54Ev
  virtual void  v55(); // _ZN7S1307C43v55Ev
  virtual void  v56(); // _ZN7S1307C43v56Ev
  virtual void  v57(); // _ZN7S1307C43v57Ev
  virtual void  v58(); // _ZN7S1307C43v58Ev
  virtual void  v59(); // _ZN7S1307C43v59Ev
  virtual void  v60(); // _ZN7S1307C43v60Ev
  virtual void  v61(); // _ZN7S1307C43v61Ev
  virtual void  v62(); // _ZN7S1307C43v62Ev
  virtual void  v63(); // _ZN7S1307C43v63Ev
  virtual void  v64(); // _ZN7S1307C43v64Ev
  virtual void  v65(); // _ZN7S1307C43v65Ev
  virtual void  v66(); // _ZN7S1307C43v66Ev
  virtual void  v67(); // _ZN7S1307C43v67Ev
  virtual void  v68(); // _ZN7S1307C43v68Ev
  virtual void  v69(); // _ZN7S1307C43v69Ev
  virtual void  v70(); // _ZN7S1307C43v70Ev
  virtual void  v71(); // _ZN7S1307C43v71Ev
  virtual void  v72(); // _ZN7S1307C43v72Ev
  virtual void  v73(); // _ZN7S1307C43v73Ev
  virtual void  v74(); // _ZN7S1307C43v74Ev
  virtual void  v75(); // _ZN7S1307C43v75Ev
  S1307C4(); // tgen
};
//SIG(-1 S1307C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1307C4 ::~S1307C4(){ note_dtor("S1307C4", this);}
void  S1307C4 ::v12(){vfunc_called(this, "_ZN7S1307C43v12Ev");}
void  S1307C4 ::v13(){vfunc_called(this, "_ZN7S1307C43v13Ev");}
void  S1307C4 ::v14(){vfunc_called(this, "_ZN7S1307C43v14Ev");}
void  S1307C4 ::v15(){vfunc_called(this, "_ZN7S1307C43v15Ev");}
void  S1307C4 ::v16(){vfunc_called(this, "_ZN7S1307C43v16Ev");}
void  S1307C4 ::v17(){vfunc_called(this, "_ZN7S1307C43v17Ev");}
void  S1307C4 ::v18(){vfunc_called(this, "_ZN7S1307C43v18Ev");}
void  S1307C4 ::v19(){vfunc_called(this, "_ZN7S1307C43v19Ev");}
void  S1307C4 ::v20(){vfunc_called(this, "_ZN7S1307C43v20Ev");}
void  S1307C4 ::v21(){vfunc_called(this, "_ZN7S1307C43v21Ev");}
void  S1307C4 ::v22(){vfunc_called(this, "_ZN7S1307C43v22Ev");}
void  S1307C4 ::v23(){vfunc_called(this, "_ZN7S1307C43v23Ev");}
void  S1307C4 ::v24(){vfunc_called(this, "_ZN7S1307C43v24Ev");}
void  S1307C4 ::v25(){vfunc_called(this, "_ZN7S1307C43v25Ev");}
void  S1307C4 ::v26(){vfunc_called(this, "_ZN7S1307C43v26Ev");}
void  S1307C4 ::v27(){vfunc_called(this, "_ZN7S1307C43v27Ev");}
void  S1307C4 ::v28(){vfunc_called(this, "_ZN7S1307C43v28Ev");}
void  S1307C4 ::v29(){vfunc_called(this, "_ZN7S1307C43v29Ev");}
void  S1307C4 ::v30(){vfunc_called(this, "_ZN7S1307C43v30Ev");}
void  S1307C4 ::v31(){vfunc_called(this, "_ZN7S1307C43v31Ev");}
void  S1307C4 ::v32(){vfunc_called(this, "_ZN7S1307C43v32Ev");}
void  S1307C4 ::v33(){vfunc_called(this, "_ZN7S1307C43v33Ev");}
void  S1307C4 ::v34(){vfunc_called(this, "_ZN7S1307C43v34Ev");}
void  S1307C4 ::v35(){vfunc_called(this, "_ZN7S1307C43v35Ev");}
void  S1307C4 ::v36(){vfunc_called(this, "_ZN7S1307C43v36Ev");}
void  S1307C4 ::v37(){vfunc_called(this, "_ZN7S1307C43v37Ev");}
void  S1307C4 ::v38(){vfunc_called(this, "_ZN7S1307C43v38Ev");}
void  S1307C4 ::v39(){vfunc_called(this, "_ZN7S1307C43v39Ev");}
void  S1307C4 ::v40(){vfunc_called(this, "_ZN7S1307C43v40Ev");}
void  S1307C4 ::v41(){vfunc_called(this, "_ZN7S1307C43v41Ev");}
void  S1307C4 ::v42(){vfunc_called(this, "_ZN7S1307C43v42Ev");}
void  S1307C4 ::v43(){vfunc_called(this, "_ZN7S1307C43v43Ev");}
void  S1307C4 ::v44(){vfunc_called(this, "_ZN7S1307C43v44Ev");}
void  S1307C4 ::v45(){vfunc_called(this, "_ZN7S1307C43v45Ev");}
void  S1307C4 ::v46(){vfunc_called(this, "_ZN7S1307C43v46Ev");}
void  S1307C4 ::v47(){vfunc_called(this, "_ZN7S1307C43v47Ev");}
void  S1307C4 ::v48(){vfunc_called(this, "_ZN7S1307C43v48Ev");}
void  S1307C4 ::v49(){vfunc_called(this, "_ZN7S1307C43v49Ev");}
void  S1307C4 ::v50(){vfunc_called(this, "_ZN7S1307C43v50Ev");}
void  S1307C4 ::v51(){vfunc_called(this, "_ZN7S1307C43v51Ev");}
void  S1307C4 ::v52(){vfunc_called(this, "_ZN7S1307C43v52Ev");}
void  S1307C4 ::v53(){vfunc_called(this, "_ZN7S1307C43v53Ev");}
void  S1307C4 ::v54(){vfunc_called(this, "_ZN7S1307C43v54Ev");}
void  S1307C4 ::v55(){vfunc_called(this, "_ZN7S1307C43v55Ev");}
void  S1307C4 ::v56(){vfunc_called(this, "_ZN7S1307C43v56Ev");}
void  S1307C4 ::v57(){vfunc_called(this, "_ZN7S1307C43v57Ev");}
void  S1307C4 ::v58(){vfunc_called(this, "_ZN7S1307C43v58Ev");}
void  S1307C4 ::v59(){vfunc_called(this, "_ZN7S1307C43v59Ev");}
void  S1307C4 ::v60(){vfunc_called(this, "_ZN7S1307C43v60Ev");}
void  S1307C4 ::v61(){vfunc_called(this, "_ZN7S1307C43v61Ev");}
void  S1307C4 ::v62(){vfunc_called(this, "_ZN7S1307C43v62Ev");}
void  S1307C4 ::v63(){vfunc_called(this, "_ZN7S1307C43v63Ev");}
void  S1307C4 ::v64(){vfunc_called(this, "_ZN7S1307C43v64Ev");}
void  S1307C4 ::v65(){vfunc_called(this, "_ZN7S1307C43v65Ev");}
void  S1307C4 ::v66(){vfunc_called(this, "_ZN7S1307C43v66Ev");}
void  S1307C4 ::v67(){vfunc_called(this, "_ZN7S1307C43v67Ev");}
void  S1307C4 ::v68(){vfunc_called(this, "_ZN7S1307C43v68Ev");}
void  S1307C4 ::v69(){vfunc_called(this, "_ZN7S1307C43v69Ev");}
void  S1307C4 ::v70(){vfunc_called(this, "_ZN7S1307C43v70Ev");}
void  S1307C4 ::v71(){vfunc_called(this, "_ZN7S1307C43v71Ev");}
void  S1307C4 ::v72(){vfunc_called(this, "_ZN7S1307C43v72Ev");}
void  S1307C4 ::v73(){vfunc_called(this, "_ZN7S1307C43v73Ev");}
void  S1307C4 ::v74(){vfunc_called(this, "_ZN7S1307C43v74Ev");}
void  S1307C4 ::v75(){vfunc_called(this, "_ZN7S1307C43v75Ev");}
S1307C4 ::S1307C4(){ note_ctor("S1307C4", this);} // tgen

static void Test_S1307C4()
{
  extern Class_Descriptor cd_S1307C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1307C4, buf);
    S1307C4 *dp, &lv = *(dp=new (buf) S1307C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1307C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1307C4)");
    check_field_offset(lv, s1307c4f0, ABISELECT(8,4), "S1307C4.s1307c4f0");
    check_field_offset(lv, s1307c4f1, ABISELECT(16,8), "S1307C4.s1307c4f1");
    check_field_offset(lv, s1307c4f2, ABISELECT(24,16), "S1307C4.s1307c4f2");
    check_field_offset(lv, s1307c4f3, ABISELECT(56,32), "S1307C4.s1307c4f3");
    check_field_offset(lv, s1307c4f4, ABISELECT(64,40), "S1307C4.s1307c4f4");
    check_field_offset(lv, s1307c4f5, ABISELECT(72,44), "S1307C4.s1307c4f5");
    check_field_offset(lv, s1307c4f6, ABISELECT(80,52), "S1307C4.s1307c4f6");
    test_class_info(&lv, &cd_S1307C4);
    dp->~S1307C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1307C4(Test_S1307C4, "S1307C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1307C4C1Ev();
extern void _ZN7S1307C4D1Ev();
Name_Map name_map_S1307C4[] = {
  NSPAIR(_ZN7S1307C4C1Ev),
  NSPAIR(_ZN7S1307C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1307C4[];
extern void _ZN7S1307C4D1Ev();
extern void _ZN7S1307C4D0Ev();
extern void _ZN7S1307C43v12Ev();
extern void _ZN7S1307C43v13Ev();
extern void _ZN7S1307C43v14Ev();
extern void _ZN7S1307C43v15Ev();
extern void _ZN7S1307C43v16Ev();
extern void _ZN7S1307C43v17Ev();
extern void _ZN7S1307C43v18Ev();
extern void _ZN7S1307C43v19Ev();
extern void _ZN7S1307C43v20Ev();
extern void _ZN7S1307C43v21Ev();
extern void _ZN7S1307C43v22Ev();
extern void _ZN7S1307C43v23Ev();
extern void _ZN7S1307C43v24Ev();
extern void _ZN7S1307C43v25Ev();
extern void _ZN7S1307C43v26Ev();
extern void _ZN7S1307C43v27Ev();
extern void _ZN7S1307C43v28Ev();
extern void _ZN7S1307C43v29Ev();
extern void _ZN7S1307C43v30Ev();
extern void _ZN7S1307C43v31Ev();
extern void _ZN7S1307C43v32Ev();
extern void _ZN7S1307C43v33Ev();
extern void _ZN7S1307C43v34Ev();
extern void _ZN7S1307C43v35Ev();
extern void _ZN7S1307C43v36Ev();
extern void _ZN7S1307C43v37Ev();
extern void _ZN7S1307C43v38Ev();
extern void _ZN7S1307C43v39Ev();
extern void _ZN7S1307C43v40Ev();
extern void _ZN7S1307C43v41Ev();
extern void _ZN7S1307C43v42Ev();
extern void _ZN7S1307C43v43Ev();
extern void _ZN7S1307C43v44Ev();
extern void _ZN7S1307C43v45Ev();
extern void _ZN7S1307C43v46Ev();
extern void _ZN7S1307C43v47Ev();
extern void _ZN7S1307C43v48Ev();
extern void _ZN7S1307C43v49Ev();
extern void _ZN7S1307C43v50Ev();
extern void _ZN7S1307C43v51Ev();
extern void _ZN7S1307C43v52Ev();
extern void _ZN7S1307C43v53Ev();
extern void _ZN7S1307C43v54Ev();
extern void _ZN7S1307C43v55Ev();
extern void _ZN7S1307C43v56Ev();
extern void _ZN7S1307C43v57Ev();
extern void _ZN7S1307C43v58Ev();
extern void _ZN7S1307C43v59Ev();
extern void _ZN7S1307C43v60Ev();
extern void _ZN7S1307C43v61Ev();
extern void _ZN7S1307C43v62Ev();
extern void _ZN7S1307C43v63Ev();
extern void _ZN7S1307C43v64Ev();
extern void _ZN7S1307C43v65Ev();
extern void _ZN7S1307C43v66Ev();
extern void _ZN7S1307C43v67Ev();
extern void _ZN7S1307C43v68Ev();
extern void _ZN7S1307C43v69Ev();
extern void _ZN7S1307C43v70Ev();
extern void _ZN7S1307C43v71Ev();
extern void _ZN7S1307C43v72Ev();
extern void _ZN7S1307C43v73Ev();
extern void _ZN7S1307C43v74Ev();
extern void _ZN7S1307C43v75Ev();
static  VTBL_ENTRY vtc_S1307C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1307C4[0]),
  (VTBL_ENTRY)&_ZN7S1307C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1307C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v75Ev,
};
extern VTBL_ENTRY _ZTI7S1307C4[];
extern  VTBL_ENTRY _ZTV7S1307C4[];
Class_Descriptor cd_S1307C4 = {  "S1307C4", // class name
  0,0,//no base classes
  &(vtc_S1307C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1307C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1307C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1307C6  {
  virtual void  v76(); // _ZN7S1307C63v76Ev
  ~S1307C6(); // tgen
  S1307C6(); // tgen
};
//SIG(-1 S1307C6) C1{ v1}


void  S1307C6 ::v76(){vfunc_called(this, "_ZN7S1307C63v76Ev");}
S1307C6 ::~S1307C6(){ note_dtor("S1307C6", this);} // tgen
S1307C6 ::S1307C6(){ note_ctor("S1307C6", this);} // tgen

static void Test_S1307C6()
{
  extern Class_Descriptor cd_S1307C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1307C6, buf);
    S1307C6 *dp, &lv = *(dp=new (buf) S1307C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1307C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1307C6)");
    test_class_info(&lv, &cd_S1307C6);
    dp->~S1307C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1307C6(Test_S1307C6, "S1307C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1307C6C1Ev();
extern void _ZN7S1307C6D1Ev();
Name_Map name_map_S1307C6[] = {
  NSPAIR(_ZN7S1307C6C1Ev),
  NSPAIR(_ZN7S1307C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1307C6[];
extern void _ZN7S1307C63v76Ev();
static  VTBL_ENTRY vtc_S1307C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1307C6[0]),
  (VTBL_ENTRY)&_ZN7S1307C63v76Ev,
};
extern VTBL_ENTRY _ZTI7S1307C6[];
extern  VTBL_ENTRY _ZTV7S1307C6[];
Class_Descriptor cd_S1307C6 = {  "S1307C6", // class name
  0,0,//no base classes
  &(vtc_S1307C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1307C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1307C6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1307C3  : S1307C4 , S1307C6 {
  virtual  ~S1307C3(); // _ZN7S1307C3D1Ev
  virtual void  v77(); // _ZN7S1307C33v77Ev
  virtual void  v78(); // _ZN7S1307C33v78Ev
  virtual void  v79(); // _ZN7S1307C33v79Ev
  virtual void  v80(); // _ZN7S1307C33v80Ev
  S1307C3(); // tgen
};
//SIG(-1 S1307C3) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v69} vd v1 v2 v3 v4}


 S1307C3 ::~S1307C3(){ note_dtor("S1307C3", this);}
void  S1307C3 ::v77(){vfunc_called(this, "_ZN7S1307C33v77Ev");}
void  S1307C3 ::v78(){vfunc_called(this, "_ZN7S1307C33v78Ev");}
void  S1307C3 ::v79(){vfunc_called(this, "_ZN7S1307C33v79Ev");}
void  S1307C3 ::v80(){vfunc_called(this, "_ZN7S1307C33v80Ev");}
S1307C3 ::S1307C3(){ note_ctor("S1307C3", this);} // tgen

static void Test_S1307C3()
{
  extern Class_Descriptor cd_S1307C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1307C3, buf);
    S1307C3 *dp, &lv = *(dp=new (buf) S1307C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1307C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1307C3)");
    check_base_class_offset(lv, (S1307C4*), 0, "S1307C3");
    check_base_class_offset(lv, (S1307C6*), ABISELECT(96,60), "S1307C3");
    test_class_info(&lv, &cd_S1307C3);
    dp->~S1307C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1307C3(Test_S1307C3, "S1307C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1307C3C1Ev();
extern void _ZN7S1307C3D1Ev();
Name_Map name_map_S1307C3[] = {
  NSPAIR(_ZN7S1307C3C1Ev),
  NSPAIR(_ZN7S1307C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1307C4;
extern VTBL_ENTRY _ZTI7S1307C4[];
extern  VTBL_ENTRY _ZTV7S1307C4[];
extern Class_Descriptor cd_S1307C6;
extern VTBL_ENTRY _ZTI7S1307C6[];
extern  VTBL_ENTRY _ZTV7S1307C6[];
static Base_Class bases_S1307C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1307C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1307C6,    ABISELECT(96,60), //bcp->offset
    72, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1307C3[];
extern void _ZN7S1307C3D1Ev();
extern void _ZN7S1307C3D0Ev();
extern void _ZN7S1307C43v12Ev();
extern void _ZN7S1307C43v13Ev();
extern void _ZN7S1307C43v14Ev();
extern void _ZN7S1307C43v15Ev();
extern void _ZN7S1307C43v16Ev();
extern void _ZN7S1307C43v17Ev();
extern void _ZN7S1307C43v18Ev();
extern void _ZN7S1307C43v19Ev();
extern void _ZN7S1307C43v20Ev();
extern void _ZN7S1307C43v21Ev();
extern void _ZN7S1307C43v22Ev();
extern void _ZN7S1307C43v23Ev();
extern void _ZN7S1307C43v24Ev();
extern void _ZN7S1307C43v25Ev();
extern void _ZN7S1307C43v26Ev();
extern void _ZN7S1307C43v27Ev();
extern void _ZN7S1307C43v28Ev();
extern void _ZN7S1307C43v29Ev();
extern void _ZN7S1307C43v30Ev();
extern void _ZN7S1307C43v31Ev();
extern void _ZN7S1307C43v32Ev();
extern void _ZN7S1307C43v33Ev();
extern void _ZN7S1307C43v34Ev();
extern void _ZN7S1307C43v35Ev();
extern void _ZN7S1307C43v36Ev();
extern void _ZN7S1307C43v37Ev();
extern void _ZN7S1307C43v38Ev();
extern void _ZN7S1307C43v39Ev();
extern void _ZN7S1307C43v40Ev();
extern void _ZN7S1307C43v41Ev();
extern void _ZN7S1307C43v42Ev();
extern void _ZN7S1307C43v43Ev();
extern void _ZN7S1307C43v44Ev();
extern void _ZN7S1307C43v45Ev();
extern void _ZN7S1307C43v46Ev();
extern void _ZN7S1307C43v47Ev();
extern void _ZN7S1307C43v48Ev();
extern void _ZN7S1307C43v49Ev();
extern void _ZN7S1307C43v50Ev();
extern void _ZN7S1307C43v51Ev();
extern void _ZN7S1307C43v52Ev();
extern void _ZN7S1307C43v53Ev();
extern void _ZN7S1307C43v54Ev();
extern void _ZN7S1307C43v55Ev();
extern void _ZN7S1307C43v56Ev();
extern void _ZN7S1307C43v57Ev();
extern void _ZN7S1307C43v58Ev();
extern void _ZN7S1307C43v59Ev();
extern void _ZN7S1307C43v60Ev();
extern void _ZN7S1307C43v61Ev();
extern void _ZN7S1307C43v62Ev();
extern void _ZN7S1307C43v63Ev();
extern void _ZN7S1307C43v64Ev();
extern void _ZN7S1307C43v65Ev();
extern void _ZN7S1307C43v66Ev();
extern void _ZN7S1307C43v67Ev();
extern void _ZN7S1307C43v68Ev();
extern void _ZN7S1307C43v69Ev();
extern void _ZN7S1307C43v70Ev();
extern void _ZN7S1307C43v71Ev();
extern void _ZN7S1307C43v72Ev();
extern void _ZN7S1307C43v73Ev();
extern void _ZN7S1307C43v74Ev();
extern void _ZN7S1307C43v75Ev();
extern void _ZN7S1307C33v77Ev();
extern void _ZN7S1307C33v78Ev();
extern void _ZN7S1307C33v79Ev();
extern void _ZN7S1307C33v80Ev();
extern void _ZN7S1307C63v76Ev();
static  VTBL_ENTRY vtc_S1307C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1307C3[0]),
  (VTBL_ENTRY)&_ZN7S1307C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1307C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v80Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1307C3[0]),
  (VTBL_ENTRY)&_ZN7S1307C63v76Ev,
};
extern VTBL_ENTRY _ZTI7S1307C3[];
extern  VTBL_ENTRY _ZTV7S1307C3[];
Class_Descriptor cd_S1307C3 = {  "S1307C3", // class name
  bases_S1307C3, 2,
  &(vtc_S1307C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1307C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1307C3),75, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1307C12_nt  {
  void *s1307c12f0;
  int s1307c12f1[2];
  ::S1566C29 s1307c12f2;
  void *s1307c12f3;
  void  mf1307c12(); // _ZN11S1307C12_nt9mf1307c12Ev
};
//SIG(-1 S1307C12_nt) C1{ m Fp Fi[2] FC2{ BC3{ m Fp Fi[2]}} Fp}


void  S1307C12_nt ::mf1307c12(){}

//skip512 S1307C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1307C2  : S1307C3 {
  int s1307c2f0;
  unsigned int s1307c2f1:1;
  unsigned int s1307c2f2:1;
  unsigned int s1307c2f3:1;
  unsigned int s1307c2f4:1;
  ::S1566C9 s1307c2f5;
  ::S1537C22 s1307c2f6;
  ::S1537C22 s1307c2f7;
  ::S1307C12_nt s1307c2f8;
  ::S1537C18 s1307c2f9;
  __tsi64 s1307c2f10;
  ::S1566C22_nt s1307c2f11;
  ::S1537C12 s1307c2f12;
  ::S1537C12 s1307c2f13;
  ::S1537C12 s1307c2f14;
  ::S1537C12 s1307c2f15;
  ::S1537C6_nt s1307c2f16;
  void *s1307c2f17;
  char s1307c2f18;
  __tsi64 s1307c2f19[2];
  void *s1307c2f20;
  int s1307c2f21;
  virtual  ~S1307C2(); // _ZN7S1307C2D1Ev
  virtual void  v81(); // _ZN7S1307C23v81Ev
  virtual void  v82(); // _ZN7S1307C23v82Ev
  virtual void  v83(); // _ZN7S1307C23v83Ev
  virtual void  v84(); // _ZN7S1307C23v84Ev
  virtual void  v85(); // _ZN7S1307C23v85Ev
  virtual void  v86(); // _ZN7S1307C23v86Ev
  virtual void  v87(); // _ZN7S1307C23v87Ev
  virtual void  v88(); // _ZN7S1307C23v88Ev
  virtual void  v89(); // _ZN7S1307C23v89Ev
  virtual void  v90(); // _ZN7S1307C23v90Ev
  virtual void  v91(); // _ZN7S1307C23v91Ev
  virtual void  v92(); // _ZN7S1307C23v92Ev
  virtual void  v93(); // _ZN7S1307C23v93Ev
  virtual void  v94(); // _ZN7S1307C23v94Ev
  virtual void  v95(); // _ZN7S1307C23v95Ev
  S1307C2(); // tgen
};
//SIG(-1 S1307C2) C1{ BC2{ BC3{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v80} vd v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 Fi Fi:1 Fi:1 Fi:1 Fi:1 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC9{ BC10{ BC8}} FC9 FC11{ m Fp Fi[2] FC12{ BC8} Fp} FC13{ BC14{ BC8}} FL FC15{ BC16{ m FC17{ BC8} Fp Fi}} FC18{ BC19{ BC8}} FC18 FC18 FC18 FC20{ BC21{ BC8}} Fp Fc FL[2] Fp Fi}


 S1307C2 ::~S1307C2(){ note_dtor("S1307C2", this);}
void  S1307C2 ::v81(){vfunc_called(this, "_ZN7S1307C23v81Ev");}
void  S1307C2 ::v82(){vfunc_called(this, "_ZN7S1307C23v82Ev");}
void  S1307C2 ::v83(){vfunc_called(this, "_ZN7S1307C23v83Ev");}
void  S1307C2 ::v84(){vfunc_called(this, "_ZN7S1307C23v84Ev");}
void  S1307C2 ::v85(){vfunc_called(this, "_ZN7S1307C23v85Ev");}
void  S1307C2 ::v86(){vfunc_called(this, "_ZN7S1307C23v86Ev");}
void  S1307C2 ::v87(){vfunc_called(this, "_ZN7S1307C23v87Ev");}
void  S1307C2 ::v88(){vfunc_called(this, "_ZN7S1307C23v88Ev");}
void  S1307C2 ::v89(){vfunc_called(this, "_ZN7S1307C23v89Ev");}
void  S1307C2 ::v90(){vfunc_called(this, "_ZN7S1307C23v90Ev");}
void  S1307C2 ::v91(){vfunc_called(this, "_ZN7S1307C23v91Ev");}
void  S1307C2 ::v92(){vfunc_called(this, "_ZN7S1307C23v92Ev");}
void  S1307C2 ::v93(){vfunc_called(this, "_ZN7S1307C23v93Ev");}
void  S1307C2 ::v94(){vfunc_called(this, "_ZN7S1307C23v94Ev");}
void  S1307C2 ::v95(){vfunc_called(this, "_ZN7S1307C23v95Ev");}
S1307C2 ::S1307C2(){ note_ctor("S1307C2", this);} // tgen

static void Test_S1307C2()
{
  extern Class_Descriptor cd_S1307C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,68)];
    init_test(&cd_S1307C2, buf);
    S1307C2 *dp, &lv = *(dp=new (buf) S1307C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,268), "sizeof(S1307C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1307C2)");
    check_base_class_offset(lv, (S1307C4*)(S1307C3*), 0, "S1307C2");
    check_base_class_offset(lv, (S1307C6*)(S1307C3*), ABISELECT(96,60), "S1307C2");
    check_base_class_offset(lv, (S1307C3*), 0, "S1307C2");
    check_field_offset(lv, s1307c2f0, ABISELECT(104,64), "S1307C2.s1307c2f0");
    set_bf_and_test(lv, s1307c2f1, ABISELECT(108,68), 0, 1, 1, "S1307C2");
    set_bf_and_test(lv, s1307c2f2, ABISELECT(108,68), 1, 1, 1, "S1307C2");
    set_bf_and_test(lv, s1307c2f3, ABISELECT(108,68), 2, 1, 1, "S1307C2");
    set_bf_and_test(lv, s1307c2f4, ABISELECT(108,68), 3, 1, 1, "S1307C2");
    check_field_offset(lv, s1307c2f5, ABISELECT(112,72), "S1307C2.s1307c2f5");
    check_field_offset(lv, s1307c2f6, ABISELECT(128,84), "S1307C2.s1307c2f6");
    check_field_offset(lv, s1307c2f7, ABISELECT(144,96), "S1307C2.s1307c2f7");
    check_field_offset(lv, s1307c2f8, ABISELECT(160,108), "S1307C2.s1307c2f8");
    check_field_offset(lv, s1307c2f9, ABISELECT(200,136), "S1307C2.s1307c2f9");
    check_field_offset(lv, s1307c2f10, ABISELECT(216,148), "S1307C2.s1307c2f10");
    check_field_offset(lv, s1307c2f11, ABISELECT(224,156), "S1307C2.s1307c2f11");
    check_field_offset(lv, s1307c2f12, ABISELECT(256,176), "S1307C2.s1307c2f12");
    check_field_offset(lv, s1307c2f13, ABISELECT(272,188), "S1307C2.s1307c2f13");
    check_field_offset(lv, s1307c2f14, ABISELECT(288,200), "S1307C2.s1307c2f14");
    check_field_offset(lv, s1307c2f15, ABISELECT(304,212), "S1307C2.s1307c2f15");
    check_field_offset(lv, s1307c2f16, ABISELECT(320,224), "S1307C2.s1307c2f16");
    check_field_offset(lv, s1307c2f17, ABISELECT(336,236), "S1307C2.s1307c2f17");
    check_field_offset(lv, s1307c2f18, ABISELECT(344,240), "S1307C2.s1307c2f18");
    check_field_offset(lv, s1307c2f19, ABISELECT(352,244), "S1307C2.s1307c2f19");
    check_field_offset(lv, s1307c2f20, ABISELECT(368,260), "S1307C2.s1307c2f20");
    check_field_offset(lv, s1307c2f21, ABISELECT(376,264), "S1307C2.s1307c2f21");
    test_class_info(&lv, &cd_S1307C2);
    dp->~S1307C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1307C2(Test_S1307C2, "S1307C2", ABISELECT(384,268));

#else // __cplusplus

extern void _ZN7S1307C2C1Ev();
extern void _ZN7S1307C2D1Ev();
Name_Map name_map_S1307C2[] = {
  NSPAIR(_ZN7S1307C2C1Ev),
  NSPAIR(_ZN7S1307C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1307C4;
extern VTBL_ENTRY _ZTI7S1307C4[];
extern  VTBL_ENTRY _ZTV7S1307C4[];
extern Class_Descriptor cd_S1307C6;
extern VTBL_ENTRY _ZTI7S1307C6[];
extern  VTBL_ENTRY _ZTV7S1307C6[];
extern Class_Descriptor cd_S1307C3;
extern VTBL_ENTRY _ZTI7S1307C3[];
extern  VTBL_ENTRY _ZTV7S1307C3[];
static Base_Class bases_S1307C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1307C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1307C6,    ABISELECT(96,60), //bcp->offset
    87, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1307C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1307C2[];
extern void _ZN7S1307C2D1Ev();
extern void _ZN7S1307C2D0Ev();
extern void _ZN7S1307C43v12Ev();
extern void _ZN7S1307C43v13Ev();
extern void _ZN7S1307C43v14Ev();
extern void _ZN7S1307C43v15Ev();
extern void _ZN7S1307C43v16Ev();
extern void _ZN7S1307C43v17Ev();
extern void _ZN7S1307C43v18Ev();
extern void _ZN7S1307C43v19Ev();
extern void _ZN7S1307C43v20Ev();
extern void _ZN7S1307C43v21Ev();
extern void _ZN7S1307C43v22Ev();
extern void _ZN7S1307C43v23Ev();
extern void _ZN7S1307C43v24Ev();
extern void _ZN7S1307C43v25Ev();
extern void _ZN7S1307C43v26Ev();
extern void _ZN7S1307C43v27Ev();
extern void _ZN7S1307C43v28Ev();
extern void _ZN7S1307C43v29Ev();
extern void _ZN7S1307C43v30Ev();
extern void _ZN7S1307C43v31Ev();
extern void _ZN7S1307C43v32Ev();
extern void _ZN7S1307C43v33Ev();
extern void _ZN7S1307C43v34Ev();
extern void _ZN7S1307C43v35Ev();
extern void _ZN7S1307C43v36Ev();
extern void _ZN7S1307C43v37Ev();
extern void _ZN7S1307C43v38Ev();
extern void _ZN7S1307C43v39Ev();
extern void _ZN7S1307C43v40Ev();
extern void _ZN7S1307C43v41Ev();
extern void _ZN7S1307C43v42Ev();
extern void _ZN7S1307C43v43Ev();
extern void _ZN7S1307C43v44Ev();
extern void _ZN7S1307C43v45Ev();
extern void _ZN7S1307C43v46Ev();
extern void _ZN7S1307C43v47Ev();
extern void _ZN7S1307C43v48Ev();
extern void _ZN7S1307C43v49Ev();
extern void _ZN7S1307C43v50Ev();
extern void _ZN7S1307C43v51Ev();
extern void _ZN7S1307C43v52Ev();
extern void _ZN7S1307C43v53Ev();
extern void _ZN7S1307C43v54Ev();
extern void _ZN7S1307C43v55Ev();
extern void _ZN7S1307C43v56Ev();
extern void _ZN7S1307C43v57Ev();
extern void _ZN7S1307C43v58Ev();
extern void _ZN7S1307C43v59Ev();
extern void _ZN7S1307C43v60Ev();
extern void _ZN7S1307C43v61Ev();
extern void _ZN7S1307C43v62Ev();
extern void _ZN7S1307C43v63Ev();
extern void _ZN7S1307C43v64Ev();
extern void _ZN7S1307C43v65Ev();
extern void _ZN7S1307C43v66Ev();
extern void _ZN7S1307C43v67Ev();
extern void _ZN7S1307C43v68Ev();
extern void _ZN7S1307C43v69Ev();
extern void _ZN7S1307C43v70Ev();
extern void _ZN7S1307C43v71Ev();
extern void _ZN7S1307C43v72Ev();
extern void _ZN7S1307C43v73Ev();
extern void _ZN7S1307C43v74Ev();
extern void _ZN7S1307C43v75Ev();
extern void _ZN7S1307C33v77Ev();
extern void _ZN7S1307C33v78Ev();
extern void _ZN7S1307C33v79Ev();
extern void _ZN7S1307C33v80Ev();
extern void _ZN7S1307C23v81Ev();
extern void _ZN7S1307C23v82Ev();
extern void _ZN7S1307C23v83Ev();
extern void _ZN7S1307C23v84Ev();
extern void _ZN7S1307C23v85Ev();
extern void _ZN7S1307C23v86Ev();
extern void _ZN7S1307C23v87Ev();
extern void _ZN7S1307C23v88Ev();
extern void _ZN7S1307C23v89Ev();
extern void _ZN7S1307C23v90Ev();
extern void _ZN7S1307C23v91Ev();
extern void _ZN7S1307C23v92Ev();
extern void _ZN7S1307C23v93Ev();
extern void _ZN7S1307C23v94Ev();
extern void _ZN7S1307C23v95Ev();
extern void _ZN7S1307C63v76Ev();
static  VTBL_ENTRY vtc_S1307C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1307C2[0]),
  (VTBL_ENTRY)&_ZN7S1307C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1307C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v95Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1307C2[0]),
  (VTBL_ENTRY)&_ZN7S1307C63v76Ev,
};
extern VTBL_ENTRY _ZTI7S1307C2[];
extern  VTBL_ENTRY _ZTV7S1307C2[];
Class_Descriptor cd_S1307C2 = {  "S1307C2", // class name
  bases_S1307C2, 3,
  &(vtc_S1307C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,268), // object size
  NSPAIRA(_ZTI7S1307C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1307C2),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1307C26  {
  int s1307c26f0[2];
  __tsi64 s1307c26f1[2];
  int s1307c26f2[2];
};
//SIG(-1 S1307C26) C1{ Fi[2] FL[2] Fi[2]}



static void Test_S1307C26()
{
  {
    init_simple_test("S1307C26");
    S1307C26 lv;
    check2(sizeof(lv), 32, "sizeof(S1307C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1307C26)");
    check_field_offset(lv, s1307c26f0, 0, "S1307C26.s1307c26f0");
    check_field_offset(lv, s1307c26f1, 8, "S1307C26.s1307c26f1");
    check_field_offset(lv, s1307c26f2, 24, "S1307C26.s1307c26f2");
  }
}
static Arrange_To_Call_Me vS1307C26(Test_S1307C26, "S1307C26", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1307C1  : S1307C2 {
  ::S1566C10 s1307c1f0;
  ::S1307C12_nt s1307c1f1;
  int s1307c1f2[2];
  ::S1307C26 s1307c1f3;
  void *s1307c1f4;
  __tsi64 s1307c1f5;
  void *s1307c1f6[2];
  int s1307c1f7[3];
  virtual  ~S1307C1(); // _ZN7S1307C1D1Ev
  virtual void  v1(); // _ZN7S1307C12v1Ev
  virtual void  v2(); // _ZN7S1307C12v2Ev
  virtual void  v3(); // _ZN7S1307C12v3Ev
  virtual void  v4(); // _ZN7S1307C12v4Ev
  virtual void  v5(); // _ZN7S1307C12v5Ev
  virtual void  v6(); // _ZN7S1307C12v6Ev
  virtual void  v7(); // _ZN7S1307C12v7Ev
  virtual void  v8(); // _ZN7S1307C12v8Ev
  virtual void  v9(); // _ZN7S1307C12v9Ev
  virtual void  v10(); // _ZN7S1307C13v10Ev
  virtual void  v11(); // _ZN7S1307C13v11Ev
  S1307C1(); // tgen
};
//SIG(1 S1307C1) C1{ BC2{ BC3{ BC4{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v76} vd v77 v78 v79 v80} vd v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi Fi:1 Fi:1 Fi:1 Fi:1 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC10{ BC11{ BC9}} FC10 FC12{ m Fp Fi[2] FC13{ BC9} Fp} FC14{ BC15{ BC9}} FL FC16{ BC17{ m FC18{ BC9} Fp Fi}} FC19{ BC20{ BC9}} FC19 FC19 FC19 FC21{ BC22{ BC9}} Fp Fc FL[2] Fp Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 FC8 FC12 Fi[2] FC23{ Fi[2] FL[2] Fi[2]} Fp FL Fp[2] Fi[3]}


 S1307C1 ::~S1307C1(){ note_dtor("S1307C1", this);}
void  S1307C1 ::v1(){vfunc_called(this, "_ZN7S1307C12v1Ev");}
void  S1307C1 ::v2(){vfunc_called(this, "_ZN7S1307C12v2Ev");}
void  S1307C1 ::v3(){vfunc_called(this, "_ZN7S1307C12v3Ev");}
void  S1307C1 ::v4(){vfunc_called(this, "_ZN7S1307C12v4Ev");}
void  S1307C1 ::v5(){vfunc_called(this, "_ZN7S1307C12v5Ev");}
void  S1307C1 ::v6(){vfunc_called(this, "_ZN7S1307C12v6Ev");}
void  S1307C1 ::v7(){vfunc_called(this, "_ZN7S1307C12v7Ev");}
void  S1307C1 ::v8(){vfunc_called(this, "_ZN7S1307C12v8Ev");}
void  S1307C1 ::v9(){vfunc_called(this, "_ZN7S1307C12v9Ev");}
void  S1307C1 ::v10(){vfunc_called(this, "_ZN7S1307C13v10Ev");}
void  S1307C1 ::v11(){vfunc_called(this, "_ZN7S1307C13v11Ev");}
S1307C1 ::S1307C1(){ note_ctor("S1307C1", this);} // tgen

static void Test_S1307C1()
{
  extern Class_Descriptor cd_S1307C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(67,96)];
    init_test(&cd_S1307C1, buf);
    S1307C1 *dp, &lv = *(dp=new (buf) S1307C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(528,380), "sizeof(S1307C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1307C1)");
    check_base_class_offset(lv, (S1307C4*)(S1307C3*)(S1307C2*), 0, "S1307C1");
    check_base_class_offset(lv, (S1307C6*)(S1307C3*)(S1307C2*), ABISELECT(96,60), "S1307C1");
    check_base_class_offset(lv, (S1307C3*)(S1307C2*), 0, "S1307C1");
    check_base_class_offset(lv, (S1307C2*), 0, "S1307C1");
    check_field_offset(lv, s1307c1f0, ABISELECT(384,268), "S1307C1.s1307c1f0");
    check_field_offset(lv, s1307c1f1, ABISELECT(400,280), "S1307C1.s1307c1f1");
    check_field_offset(lv, s1307c1f2, ABISELECT(440,308), "S1307C1.s1307c1f2");
    check_field_offset(lv, s1307c1f3, ABISELECT(448,316), "S1307C1.s1307c1f3");
    check_field_offset(lv, s1307c1f4, ABISELECT(480,348), "S1307C1.s1307c1f4");
    check_field_offset(lv, s1307c1f5, ABISELECT(488,352), "S1307C1.s1307c1f5");
    check_field_offset(lv, s1307c1f6, ABISELECT(496,360), "S1307C1.s1307c1f6");
    check_field_offset(lv, s1307c1f7, ABISELECT(512,368), "S1307C1.s1307c1f7");
    test_class_info(&lv, &cd_S1307C1);
    dp->~S1307C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1307C1(Test_S1307C1, "S1307C1", ABISELECT(528,380));

#else // __cplusplus

extern void _ZN7S1307C1C1Ev();
extern void _ZN7S1307C1D1Ev();
Name_Map name_map_S1307C1[] = {
  NSPAIR(_ZN7S1307C1C1Ev),
  NSPAIR(_ZN7S1307C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1307C4;
extern VTBL_ENTRY _ZTI7S1307C4[];
extern  VTBL_ENTRY _ZTV7S1307C4[];
extern Class_Descriptor cd_S1307C6;
extern VTBL_ENTRY _ZTI7S1307C6[];
extern  VTBL_ENTRY _ZTV7S1307C6[];
extern Class_Descriptor cd_S1307C3;
extern VTBL_ENTRY _ZTI7S1307C3[];
extern  VTBL_ENTRY _ZTV7S1307C3[];
extern Class_Descriptor cd_S1307C2;
extern VTBL_ENTRY _ZTI7S1307C2[];
extern  VTBL_ENTRY _ZTV7S1307C2[];
static Base_Class bases_S1307C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1307C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1307C6,    ABISELECT(96,60), //bcp->offset
    98, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1307C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1307C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1307C1[];
extern void _ZN7S1307C1D1Ev();
extern void _ZN7S1307C1D0Ev();
extern void _ZN7S1307C43v12Ev();
extern void _ZN7S1307C43v13Ev();
extern void _ZN7S1307C43v14Ev();
extern void _ZN7S1307C43v15Ev();
extern void _ZN7S1307C43v16Ev();
extern void _ZN7S1307C43v17Ev();
extern void _ZN7S1307C43v18Ev();
extern void _ZN7S1307C43v19Ev();
extern void _ZN7S1307C43v20Ev();
extern void _ZN7S1307C43v21Ev();
extern void _ZN7S1307C43v22Ev();
extern void _ZN7S1307C43v23Ev();
extern void _ZN7S1307C43v24Ev();
extern void _ZN7S1307C43v25Ev();
extern void _ZN7S1307C43v26Ev();
extern void _ZN7S1307C43v27Ev();
extern void _ZN7S1307C43v28Ev();
extern void _ZN7S1307C43v29Ev();
extern void _ZN7S1307C43v30Ev();
extern void _ZN7S1307C43v31Ev();
extern void _ZN7S1307C43v32Ev();
extern void _ZN7S1307C43v33Ev();
extern void _ZN7S1307C43v34Ev();
extern void _ZN7S1307C43v35Ev();
extern void _ZN7S1307C43v36Ev();
extern void _ZN7S1307C43v37Ev();
extern void _ZN7S1307C43v38Ev();
extern void _ZN7S1307C43v39Ev();
extern void _ZN7S1307C43v40Ev();
extern void _ZN7S1307C43v41Ev();
extern void _ZN7S1307C43v42Ev();
extern void _ZN7S1307C43v43Ev();
extern void _ZN7S1307C43v44Ev();
extern void _ZN7S1307C43v45Ev();
extern void _ZN7S1307C43v46Ev();
extern void _ZN7S1307C43v47Ev();
extern void _ZN7S1307C43v48Ev();
extern void _ZN7S1307C43v49Ev();
extern void _ZN7S1307C43v50Ev();
extern void _ZN7S1307C43v51Ev();
extern void _ZN7S1307C43v52Ev();
extern void _ZN7S1307C43v53Ev();
extern void _ZN7S1307C43v54Ev();
extern void _ZN7S1307C43v55Ev();
extern void _ZN7S1307C43v56Ev();
extern void _ZN7S1307C43v57Ev();
extern void _ZN7S1307C43v58Ev();
extern void _ZN7S1307C43v59Ev();
extern void _ZN7S1307C43v60Ev();
extern void _ZN7S1307C43v61Ev();
extern void _ZN7S1307C43v62Ev();
extern void _ZN7S1307C43v63Ev();
extern void _ZN7S1307C43v64Ev();
extern void _ZN7S1307C43v65Ev();
extern void _ZN7S1307C43v66Ev();
extern void _ZN7S1307C43v67Ev();
extern void _ZN7S1307C43v68Ev();
extern void _ZN7S1307C43v69Ev();
extern void _ZN7S1307C43v70Ev();
extern void _ZN7S1307C43v71Ev();
extern void _ZN7S1307C43v72Ev();
extern void _ZN7S1307C43v73Ev();
extern void _ZN7S1307C43v74Ev();
extern void _ZN7S1307C43v75Ev();
extern void _ZN7S1307C33v77Ev();
extern void _ZN7S1307C33v78Ev();
extern void _ZN7S1307C33v79Ev();
extern void _ZN7S1307C33v80Ev();
extern void _ZN7S1307C23v81Ev();
extern void _ZN7S1307C23v82Ev();
extern void _ZN7S1307C23v83Ev();
extern void _ZN7S1307C23v84Ev();
extern void _ZN7S1307C23v85Ev();
extern void _ZN7S1307C23v86Ev();
extern void _ZN7S1307C23v87Ev();
extern void _ZN7S1307C23v88Ev();
extern void _ZN7S1307C23v89Ev();
extern void _ZN7S1307C23v90Ev();
extern void _ZN7S1307C23v91Ev();
extern void _ZN7S1307C23v92Ev();
extern void _ZN7S1307C23v93Ev();
extern void _ZN7S1307C23v94Ev();
extern void _ZN7S1307C23v95Ev();
extern void _ZN7S1307C12v1Ev();
extern void _ZN7S1307C12v2Ev();
extern void _ZN7S1307C12v3Ev();
extern void _ZN7S1307C12v4Ev();
extern void _ZN7S1307C12v5Ev();
extern void _ZN7S1307C12v6Ev();
extern void _ZN7S1307C12v7Ev();
extern void _ZN7S1307C12v8Ev();
extern void _ZN7S1307C12v9Ev();
extern void _ZN7S1307C13v10Ev();
extern void _ZN7S1307C13v11Ev();
extern void _ZN7S1307C63v76Ev();
static  VTBL_ENTRY vtc_S1307C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1307C1[0]),
  (VTBL_ENTRY)&_ZN7S1307C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1307C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1307C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1307C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1307C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1307C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1307C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1307C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1307C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1307C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1307C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1307C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1307C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1307C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1307C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1307C13v11Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1307C1[0]),
  (VTBL_ENTRY)&_ZN7S1307C63v76Ev,
};
extern VTBL_ENTRY _ZTI7S1307C1[];
extern  VTBL_ENTRY _ZTV7S1307C1[];
Class_Descriptor cd_S1307C1 = {  "S1307C1", // class name
  bases_S1307C1, 4,
  &(vtc_S1307C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(528,380), // object size
  NSPAIRA(_ZTI7S1307C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1307C1),101, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S544C5  {
  int s544c5f0;
  __tsi64 s544c5f1;
  void *s544c5f2[4];
  int s544c5f3[2];
  void *s544c5f4;
  ::S1566C14_nt s544c5f5;
  void *s544c5f6[2];
  virtual  ~S544C5(); // _ZN6S544C5D1Ev
  virtual void  v4(); // _ZN6S544C52v4Ev
  virtual void  v5(); // _ZN6S544C52v5Ev
  virtual void  v6(); // _ZN6S544C52v6Ev
  virtual void  v7(); // _ZN6S544C52v7Ev
  virtual void  v8(); // _ZN6S544C52v8Ev
  virtual void  v9(); // _ZN6S544C52v9Ev
  virtual void  v10(); // _ZN6S544C53v10Ev
  virtual void  v11(); // _ZN6S544C53v11Ev
  virtual void  v12(); // _ZN6S544C53v12Ev
  virtual void  v13(); // _ZN6S544C53v13Ev
  virtual void  v14(); // _ZN6S544C53v14Ev
  virtual void  v15(); // _ZN6S544C53v15Ev
  virtual void  v16(); // _ZN6S544C53v16Ev
  virtual void  v17(); // _ZN6S544C53v17Ev
  virtual void  v18(); // _ZN6S544C53v18Ev
  virtual void  v19(); // _ZN6S544C53v19Ev
  virtual void  v20(); // _ZN6S544C53v20Ev
  virtual void  v21(); // _ZN6S544C53v21Ev
  virtual void  v22(); // _ZN6S544C53v22Ev
  virtual void  v23(); // _ZN6S544C53v23Ev
  virtual void  v24(); // _ZN6S544C53v24Ev
  virtual void  v25(); // _ZN6S544C53v25Ev
  virtual void  v26(); // _ZN6S544C53v26Ev
  virtual void  v27(); // _ZN6S544C53v27Ev
  virtual void  v28(); // _ZN6S544C53v28Ev
  virtual void  v29(); // _ZN6S544C53v29Ev
  virtual void  v30(); // _ZN6S544C53v30Ev
  virtual void  v31(); // _ZN6S544C53v31Ev
  virtual void  v32(); // _ZN6S544C53v32Ev
  virtual void  v33(); // _ZN6S544C53v33Ev
  virtual void  v34(); // _ZN6S544C53v34Ev
  virtual void  v35(); // _ZN6S544C53v35Ev
  virtual void  v36(); // _ZN6S544C53v36Ev
  virtual void  v37(); // _ZN6S544C53v37Ev
  virtual void  v38(); // _ZN6S544C53v38Ev
  virtual void  v39(); // _ZN6S544C53v39Ev
  virtual void  v40(); // _ZN6S544C53v40Ev
  virtual void  v41(); // _ZN6S544C53v41Ev
  virtual void  v42(); // _ZN6S544C53v42Ev
  virtual void  v43(); // _ZN6S544C53v43Ev
  virtual void  v44(); // _ZN6S544C53v44Ev
  virtual void  v45(); // _ZN6S544C53v45Ev
  virtual void  v46(); // _ZN6S544C53v46Ev
  virtual void  v47(); // _ZN6S544C53v47Ev
  virtual void  v48(); // _ZN6S544C53v48Ev
  virtual void  v49(); // _ZN6S544C53v49Ev
  virtual void  v50(); // _ZN6S544C53v50Ev
  virtual void  v51(); // _ZN6S544C53v51Ev
  virtual void  v52(); // _ZN6S544C53v52Ev
  virtual void  v53(); // _ZN6S544C53v53Ev
  virtual void  v54(); // _ZN6S544C53v54Ev
  virtual void  v55(); // _ZN6S544C53v55Ev
  virtual void  v56(); // _ZN6S544C53v56Ev
  virtual void  v57(); // _ZN6S544C53v57Ev
  virtual void  v58(); // _ZN6S544C53v58Ev
  virtual void  v59(); // _ZN6S544C53v59Ev
  virtual void  v60(); // _ZN6S544C53v60Ev
  virtual void  v61(); // _ZN6S544C53v61Ev
  virtual void  v62(); // _ZN6S544C53v62Ev
  virtual void  v63(); // _ZN6S544C53v63Ev
  virtual void  v64(); // _ZN6S544C53v64Ev
  virtual void  v65(); // _ZN6S544C53v65Ev
  virtual void  v66(); // _ZN6S544C53v66Ev
  virtual void  v67(); // _ZN6S544C53v67Ev
  S544C5(); // tgen
};
//SIG(-1 S544C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S544C5 ::~S544C5(){ note_dtor("S544C5", this);}
void  S544C5 ::v4(){vfunc_called(this, "_ZN6S544C52v4Ev");}
void  S544C5 ::v5(){vfunc_called(this, "_ZN6S544C52v5Ev");}
void  S544C5 ::v6(){vfunc_called(this, "_ZN6S544C52v6Ev");}
void  S544C5 ::v7(){vfunc_called(this, "_ZN6S544C52v7Ev");}
void  S544C5 ::v8(){vfunc_called(this, "_ZN6S544C52v8Ev");}
void  S544C5 ::v9(){vfunc_called(this, "_ZN6S544C52v9Ev");}
void  S544C5 ::v10(){vfunc_called(this, "_ZN6S544C53v10Ev");}
void  S544C5 ::v11(){vfunc_called(this, "_ZN6S544C53v11Ev");}
void  S544C5 ::v12(){vfunc_called(this, "_ZN6S544C53v12Ev");}
void  S544C5 ::v13(){vfunc_called(this, "_ZN6S544C53v13Ev");}
void  S544C5 ::v14(){vfunc_called(this, "_ZN6S544C53v14Ev");}
void  S544C5 ::v15(){vfunc_called(this, "_ZN6S544C53v15Ev");}
void  S544C5 ::v16(){vfunc_called(this, "_ZN6S544C53v16Ev");}
void  S544C5 ::v17(){vfunc_called(this, "_ZN6S544C53v17Ev");}
void  S544C5 ::v18(){vfunc_called(this, "_ZN6S544C53v18Ev");}
void  S544C5 ::v19(){vfunc_called(this, "_ZN6S544C53v19Ev");}
void  S544C5 ::v20(){vfunc_called(this, "_ZN6S544C53v20Ev");}
void  S544C5 ::v21(){vfunc_called(this, "_ZN6S544C53v21Ev");}
void  S544C5 ::v22(){vfunc_called(this, "_ZN6S544C53v22Ev");}
void  S544C5 ::v23(){vfunc_called(this, "_ZN6S544C53v23Ev");}
void  S544C5 ::v24(){vfunc_called(this, "_ZN6S544C53v24Ev");}
void  S544C5 ::v25(){vfunc_called(this, "_ZN6S544C53v25Ev");}
void  S544C5 ::v26(){vfunc_called(this, "_ZN6S544C53v26Ev");}
void  S544C5 ::v27(){vfunc_called(this, "_ZN6S544C53v27Ev");}
void  S544C5 ::v28(){vfunc_called(this, "_ZN6S544C53v28Ev");}
void  S544C5 ::v29(){vfunc_called(this, "_ZN6S544C53v29Ev");}
void  S544C5 ::v30(){vfunc_called(this, "_ZN6S544C53v30Ev");}
void  S544C5 ::v31(){vfunc_called(this, "_ZN6S544C53v31Ev");}
void  S544C5 ::v32(){vfunc_called(this, "_ZN6S544C53v32Ev");}
void  S544C5 ::v33(){vfunc_called(this, "_ZN6S544C53v33Ev");}
void  S544C5 ::v34(){vfunc_called(this, "_ZN6S544C53v34Ev");}
void  S544C5 ::v35(){vfunc_called(this, "_ZN6S544C53v35Ev");}
void  S544C5 ::v36(){vfunc_called(this, "_ZN6S544C53v36Ev");}
void  S544C5 ::v37(){vfunc_called(this, "_ZN6S544C53v37Ev");}
void  S544C5 ::v38(){vfunc_called(this, "_ZN6S544C53v38Ev");}
void  S544C5 ::v39(){vfunc_called(this, "_ZN6S544C53v39Ev");}
void  S544C5 ::v40(){vfunc_called(this, "_ZN6S544C53v40Ev");}
void  S544C5 ::v41(){vfunc_called(this, "_ZN6S544C53v41Ev");}
void  S544C5 ::v42(){vfunc_called(this, "_ZN6S544C53v42Ev");}
void  S544C5 ::v43(){vfunc_called(this, "_ZN6S544C53v43Ev");}
void  S544C5 ::v44(){vfunc_called(this, "_ZN6S544C53v44Ev");}
void  S544C5 ::v45(){vfunc_called(this, "_ZN6S544C53v45Ev");}
void  S544C5 ::v46(){vfunc_called(this, "_ZN6S544C53v46Ev");}
void  S544C5 ::v47(){vfunc_called(this, "_ZN6S544C53v47Ev");}
void  S544C5 ::v48(){vfunc_called(this, "_ZN6S544C53v48Ev");}
void  S544C5 ::v49(){vfunc_called(this, "_ZN6S544C53v49Ev");}
void  S544C5 ::v50(){vfunc_called(this, "_ZN6S544C53v50Ev");}
void  S544C5 ::v51(){vfunc_called(this, "_ZN6S544C53v51Ev");}
void  S544C5 ::v52(){vfunc_called(this, "_ZN6S544C53v52Ev");}
void  S544C5 ::v53(){vfunc_called(this, "_ZN6S544C53v53Ev");}
void  S544C5 ::v54(){vfunc_called(this, "_ZN6S544C53v54Ev");}
void  S544C5 ::v55(){vfunc_called(this, "_ZN6S544C53v55Ev");}
void  S544C5 ::v56(){vfunc_called(this, "_ZN6S544C53v56Ev");}
void  S544C5 ::v57(){vfunc_called(this, "_ZN6S544C53v57Ev");}
void  S544C5 ::v58(){vfunc_called(this, "_ZN6S544C53v58Ev");}
void  S544C5 ::v59(){vfunc_called(this, "_ZN6S544C53v59Ev");}
void  S544C5 ::v60(){vfunc_called(this, "_ZN6S544C53v60Ev");}
void  S544C5 ::v61(){vfunc_called(this, "_ZN6S544C53v61Ev");}
void  S544C5 ::v62(){vfunc_called(this, "_ZN6S544C53v62Ev");}
void  S544C5 ::v63(){vfunc_called(this, "_ZN6S544C53v63Ev");}
void  S544C5 ::v64(){vfunc_called(this, "_ZN6S544C53v64Ev");}
void  S544C5 ::v65(){vfunc_called(this, "_ZN6S544C53v65Ev");}
void  S544C5 ::v66(){vfunc_called(this, "_ZN6S544C53v66Ev");}
void  S544C5 ::v67(){vfunc_called(this, "_ZN6S544C53v67Ev");}
S544C5 ::S544C5(){ note_ctor("S544C5", this);} // tgen

static void Test_S544C5()
{
  extern Class_Descriptor cd_S544C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S544C5, buf);
    S544C5 *dp, &lv = *(dp=new (buf) S544C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S544C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S544C5)");
    check_field_offset(lv, s544c5f0, ABISELECT(8,4), "S544C5.s544c5f0");
    check_field_offset(lv, s544c5f1, ABISELECT(16,8), "S544C5.s544c5f1");
    check_field_offset(lv, s544c5f2, ABISELECT(24,16), "S544C5.s544c5f2");
    check_field_offset(lv, s544c5f3, ABISELECT(56,32), "S544C5.s544c5f3");
    check_field_offset(lv, s544c5f4, ABISELECT(64,40), "S544C5.s544c5f4");
    check_field_offset(lv, s544c5f5, ABISELECT(72,44), "S544C5.s544c5f5");
    check_field_offset(lv, s544c5f6, ABISELECT(80,52), "S544C5.s544c5f6");
    test_class_info(&lv, &cd_S544C5);
    dp->~S544C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS544C5(Test_S544C5, "S544C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S544C5C1Ev();
extern void _ZN6S544C5D1Ev();
Name_Map name_map_S544C5[] = {
  NSPAIR(_ZN6S544C5C1Ev),
  NSPAIR(_ZN6S544C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S544C5[];
extern void _ZN6S544C5D1Ev();
extern void _ZN6S544C5D0Ev();
extern void _ZN6S544C52v4Ev();
extern void _ZN6S544C52v5Ev();
extern void _ZN6S544C52v6Ev();
extern void _ZN6S544C52v7Ev();
extern void _ZN6S544C52v8Ev();
extern void _ZN6S544C52v9Ev();
extern void _ZN6S544C53v10Ev();
extern void _ZN6S544C53v11Ev();
extern void _ZN6S544C53v12Ev();
extern void _ZN6S544C53v13Ev();
extern void _ZN6S544C53v14Ev();
extern void _ZN6S544C53v15Ev();
extern void _ZN6S544C53v16Ev();
extern void _ZN6S544C53v17Ev();
extern void _ZN6S544C53v18Ev();
extern void _ZN6S544C53v19Ev();
extern void _ZN6S544C53v20Ev();
extern void _ZN6S544C53v21Ev();
extern void _ZN6S544C53v22Ev();
extern void _ZN6S544C53v23Ev();
extern void _ZN6S544C53v24Ev();
extern void _ZN6S544C53v25Ev();
extern void _ZN6S544C53v26Ev();
extern void _ZN6S544C53v27Ev();
extern void _ZN6S544C53v28Ev();
extern void _ZN6S544C53v29Ev();
extern void _ZN6S544C53v30Ev();
extern void _ZN6S544C53v31Ev();
extern void _ZN6S544C53v32Ev();
extern void _ZN6S544C53v33Ev();
extern void _ZN6S544C53v34Ev();
extern void _ZN6S544C53v35Ev();
extern void _ZN6S544C53v36Ev();
extern void _ZN6S544C53v37Ev();
extern void _ZN6S544C53v38Ev();
extern void _ZN6S544C53v39Ev();
extern void _ZN6S544C53v40Ev();
extern void _ZN6S544C53v41Ev();
extern void _ZN6S544C53v42Ev();
extern void _ZN6S544C53v43Ev();
extern void _ZN6S544C53v44Ev();
extern void _ZN6S544C53v45Ev();
extern void _ZN6S544C53v46Ev();
extern void _ZN6S544C53v47Ev();
extern void _ZN6S544C53v48Ev();
extern void _ZN6S544C53v49Ev();
extern void _ZN6S544C53v50Ev();
extern void _ZN6S544C53v51Ev();
extern void _ZN6S544C53v52Ev();
extern void _ZN6S544C53v53Ev();
extern void _ZN6S544C53v54Ev();
extern void _ZN6S544C53v55Ev();
extern void _ZN6S544C53v56Ev();
extern void _ZN6S544C53v57Ev();
extern void _ZN6S544C53v58Ev();
extern void _ZN6S544C53v59Ev();
extern void _ZN6S544C53v60Ev();
extern void _ZN6S544C53v61Ev();
extern void _ZN6S544C53v62Ev();
extern void _ZN6S544C53v63Ev();
extern void _ZN6S544C53v64Ev();
extern void _ZN6S544C53v65Ev();
extern void _ZN6S544C53v66Ev();
extern void _ZN6S544C53v67Ev();
static  VTBL_ENTRY vtc_S544C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S544C5[0]),
  (VTBL_ENTRY)&_ZN6S544C5D1Ev,
  (VTBL_ENTRY)&_ZN6S544C5D0Ev,
  (VTBL_ENTRY)&_ZN6S544C52v4Ev,
  (VTBL_ENTRY)&_ZN6S544C52v5Ev,
  (VTBL_ENTRY)&_ZN6S544C52v6Ev,
  (VTBL_ENTRY)&_ZN6S544C52v7Ev,
  (VTBL_ENTRY)&_ZN6S544C52v8Ev,
  (VTBL_ENTRY)&_ZN6S544C52v9Ev,
  (VTBL_ENTRY)&_ZN6S544C53v10Ev,
  (VTBL_ENTRY)&_ZN6S544C53v11Ev,
  (VTBL_ENTRY)&_ZN6S544C53v12Ev,
  (VTBL_ENTRY)&_ZN6S544C53v13Ev,
  (VTBL_ENTRY)&_ZN6S544C53v14Ev,
  (VTBL_ENTRY)&_ZN6S544C53v15Ev,
  (VTBL_ENTRY)&_ZN6S544C53v16Ev,
  (VTBL_ENTRY)&_ZN6S544C53v17Ev,
  (VTBL_ENTRY)&_ZN6S544C53v18Ev,
  (VTBL_ENTRY)&_ZN6S544C53v19Ev,
  (VTBL_ENTRY)&_ZN6S544C53v20Ev,
  (VTBL_ENTRY)&_ZN6S544C53v21Ev,
  (VTBL_ENTRY)&_ZN6S544C53v22Ev,
  (VTBL_ENTRY)&_ZN6S544C53v23Ev,
  (VTBL_ENTRY)&_ZN6S544C53v24Ev,
  (VTBL_ENTRY)&_ZN6S544C53v25Ev,
  (VTBL_ENTRY)&_ZN6S544C53v26Ev,
  (VTBL_ENTRY)&_ZN6S544C53v27Ev,
  (VTBL_ENTRY)&_ZN6S544C53v28Ev,
  (VTBL_ENTRY)&_ZN6S544C53v29Ev,
  (VTBL_ENTRY)&_ZN6S544C53v30Ev,
  (VTBL_ENTRY)&_ZN6S544C53v31Ev,
  (VTBL_ENTRY)&_ZN6S544C53v32Ev,
  (VTBL_ENTRY)&_ZN6S544C53v33Ev,
  (VTBL_ENTRY)&_ZN6S544C53v34Ev,
  (VTBL_ENTRY)&_ZN6S544C53v35Ev,
  (VTBL_ENTRY)&_ZN6S544C53v36Ev,
  (VTBL_ENTRY)&_ZN6S544C53v37Ev,
  (VTBL_ENTRY)&_ZN6S544C53v38Ev,
  (VTBL_ENTRY)&_ZN6S544C53v39Ev,
  (VTBL_ENTRY)&_ZN6S544C53v40Ev,
  (VTBL_ENTRY)&_ZN6S544C53v41Ev,
  (VTBL_ENTRY)&_ZN6S544C53v42Ev,
  (VTBL_ENTRY)&_ZN6S544C53v43Ev,
  (VTBL_ENTRY)&_ZN6S544C53v44Ev,
  (VTBL_ENTRY)&_ZN6S544C53v45Ev,
  (VTBL_ENTRY)&_ZN6S544C53v46Ev,
  (VTBL_ENTRY)&_ZN6S544C53v47Ev,
  (VTBL_ENTRY)&_ZN6S544C53v48Ev,
  (VTBL_ENTRY)&_ZN6S544C53v49Ev,
  (VTBL_ENTRY)&_ZN6S544C53v50Ev,
  (VTBL_ENTRY)&_ZN6S544C53v51Ev,
  (VTBL_ENTRY)&_ZN6S544C53v52Ev,
  (VTBL_ENTRY)&_ZN6S544C53v53Ev,
  (VTBL_ENTRY)&_ZN6S544C53v54Ev,
  (VTBL_ENTRY)&_ZN6S544C53v55Ev,
  (VTBL_ENTRY)&_ZN6S544C53v56Ev,
  (VTBL_ENTRY)&_ZN6S544C53v57Ev,
  (VTBL_ENTRY)&_ZN6S544C53v58Ev,
  (VTBL_ENTRY)&_ZN6S544C53v59Ev,
  (VTBL_ENTRY)&_ZN6S544C53v60Ev,
  (VTBL_ENTRY)&_ZN6S544C53v61Ev,
  (VTBL_ENTRY)&_ZN6S544C53v62Ev,
  (VTBL_ENTRY)&_ZN6S544C53v63Ev,
  (VTBL_ENTRY)&_ZN6S544C53v64Ev,
  (VTBL_ENTRY)&_ZN6S544C53v65Ev,
  (VTBL_ENTRY)&_ZN6S544C53v66Ev,
  (VTBL_ENTRY)&_ZN6S544C53v67Ev,
};
extern VTBL_ENTRY _ZTI6S544C5[];
extern  VTBL_ENTRY _ZTV6S544C5[];
Class_Descriptor cd_S544C5 = {  "S544C5", // class name
  0,0,//no base classes
  &(vtc_S544C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S544C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S544C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S544C7  {
  virtual void  v68(); // _ZN6S544C73v68Ev
  ~S544C7(); // tgen
  S544C7(); // tgen
};
//SIG(-1 S544C7) C1{ v1}


void  S544C7 ::v68(){vfunc_called(this, "_ZN6S544C73v68Ev");}
S544C7 ::~S544C7(){ note_dtor("S544C7", this);} // tgen
S544C7 ::S544C7(){ note_ctor("S544C7", this);} // tgen

static void Test_S544C7()
{
  extern Class_Descriptor cd_S544C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S544C7, buf);
    S544C7 *dp, &lv = *(dp=new (buf) S544C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S544C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S544C7)");
    test_class_info(&lv, &cd_S544C7);
    dp->~S544C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS544C7(Test_S544C7, "S544C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S544C7C1Ev();
extern void _ZN6S544C7D1Ev();
Name_Map name_map_S544C7[] = {
  NSPAIR(_ZN6S544C7C1Ev),
  NSPAIR(_ZN6S544C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S544C7[];
extern void _ZN6S544C73v68Ev();
static  VTBL_ENTRY vtc_S544C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S544C7[0]),
  (VTBL_ENTRY)&_ZN6S544C73v68Ev,
};
extern VTBL_ENTRY _ZTI6S544C7[];
extern  VTBL_ENTRY _ZTV6S544C7[];
Class_Descriptor cd_S544C7 = {  "S544C7", // class name
  0,0,//no base classes
  &(vtc_S544C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S544C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S544C7),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S544C4  : S544C5 , S544C7 {
  virtual  ~S544C4(); // _ZN6S544C4D1Ev
  virtual void  v69(); // _ZN6S544C43v69Ev
  virtual void  v70(); // _ZN6S544C43v70Ev
  virtual void  v71(); // _ZN6S544C43v71Ev
  virtual void  v72(); // _ZN6S544C43v72Ev
  S544C4(); // tgen
};
//SIG(-1 S544C4) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v69} vd v1 v2 v3 v4}


 S544C4 ::~S544C4(){ note_dtor("S544C4", this);}
void  S544C4 ::v69(){vfunc_called(this, "_ZN6S544C43v69Ev");}
void  S544C4 ::v70(){vfunc_called(this, "_ZN6S544C43v70Ev");}
void  S544C4 ::v71(){vfunc_called(this, "_ZN6S544C43v71Ev");}
void  S544C4 ::v72(){vfunc_called(this, "_ZN6S544C43v72Ev");}
S544C4 ::S544C4(){ note_ctor("S544C4", this);} // tgen

static void Test_S544C4()
{
  extern Class_Descriptor cd_S544C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S544C4, buf);
    S544C4 *dp, &lv = *(dp=new (buf) S544C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S544C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S544C4)");
    check_base_class_offset(lv, (S544C5*), 0, "S544C4");
    check_base_class_offset(lv, (S544C7*), ABISELECT(96,60), "S544C4");
    test_class_info(&lv, &cd_S544C4);
    dp->~S544C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS544C4(Test_S544C4, "S544C4", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN6S544C4C1Ev();
extern void _ZN6S544C4D1Ev();
Name_Map name_map_S544C4[] = {
  NSPAIR(_ZN6S544C4C1Ev),
  NSPAIR(_ZN6S544C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S544C5;
extern VTBL_ENTRY _ZTI6S544C5[];
extern  VTBL_ENTRY _ZTV6S544C5[];
extern Class_Descriptor cd_S544C7;
extern VTBL_ENTRY _ZTI6S544C7[];
extern  VTBL_ENTRY _ZTV6S544C7[];
static Base_Class bases_S544C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S544C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S544C7,    ABISELECT(96,60), //bcp->offset
    72, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S544C4[];
extern void _ZN6S544C4D1Ev();
extern void _ZN6S544C4D0Ev();
extern void _ZN6S544C52v4Ev();
extern void _ZN6S544C52v5Ev();
extern void _ZN6S544C52v6Ev();
extern void _ZN6S544C52v7Ev();
extern void _ZN6S544C52v8Ev();
extern void _ZN6S544C52v9Ev();
extern void _ZN6S544C53v10Ev();
extern void _ZN6S544C53v11Ev();
extern void _ZN6S544C53v12Ev();
extern void _ZN6S544C53v13Ev();
extern void _ZN6S544C53v14Ev();
extern void _ZN6S544C53v15Ev();
extern void _ZN6S544C53v16Ev();
extern void _ZN6S544C53v17Ev();
extern void _ZN6S544C53v18Ev();
extern void _ZN6S544C53v19Ev();
extern void _ZN6S544C53v20Ev();
extern void _ZN6S544C53v21Ev();
extern void _ZN6S544C53v22Ev();
extern void _ZN6S544C53v23Ev();
extern void _ZN6S544C53v24Ev();
extern void _ZN6S544C53v25Ev();
extern void _ZN6S544C53v26Ev();
extern void _ZN6S544C53v27Ev();
extern void _ZN6S544C53v28Ev();
extern void _ZN6S544C53v29Ev();
extern void _ZN6S544C53v30Ev();
extern void _ZN6S544C53v31Ev();
extern void _ZN6S544C53v32Ev();
extern void _ZN6S544C53v33Ev();
extern void _ZN6S544C53v34Ev();
extern void _ZN6S544C53v35Ev();
extern void _ZN6S544C53v36Ev();
extern void _ZN6S544C53v37Ev();
extern void _ZN6S544C53v38Ev();
extern void _ZN6S544C53v39Ev();
extern void _ZN6S544C53v40Ev();
extern void _ZN6S544C53v41Ev();
extern void _ZN6S544C53v42Ev();
extern void _ZN6S544C53v43Ev();
extern void _ZN6S544C53v44Ev();
extern void _ZN6S544C53v45Ev();
extern void _ZN6S544C53v46Ev();
extern void _ZN6S544C53v47Ev();
extern void _ZN6S544C53v48Ev();
extern void _ZN6S544C53v49Ev();
extern void _ZN6S544C53v50Ev();
extern void _ZN6S544C53v51Ev();
extern void _ZN6S544C53v52Ev();
extern void _ZN6S544C53v53Ev();
extern void _ZN6S544C53v54Ev();
extern void _ZN6S544C53v55Ev();
extern void _ZN6S544C53v56Ev();
extern void _ZN6S544C53v57Ev();
extern void _ZN6S544C53v58Ev();
extern void _ZN6S544C53v59Ev();
extern void _ZN6S544C53v60Ev();
extern void _ZN6S544C53v61Ev();
extern void _ZN6S544C53v62Ev();
extern void _ZN6S544C53v63Ev();
extern void _ZN6S544C53v64Ev();
extern void _ZN6S544C53v65Ev();
extern void _ZN6S544C53v66Ev();
extern void _ZN6S544C53v67Ev();
extern void _ZN6S544C43v69Ev();
extern void _ZN6S544C43v70Ev();
extern void _ZN6S544C43v71Ev();
extern void _ZN6S544C43v72Ev();
extern void _ZN6S544C73v68Ev();
static  VTBL_ENTRY vtc_S544C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S544C4[0]),
  (VTBL_ENTRY)&_ZN6S544C4D1Ev,
  (VTBL_ENTRY)&_ZN6S544C4D0Ev,
  (VTBL_ENTRY)&_ZN6S544C52v4Ev,
  (VTBL_ENTRY)&_ZN6S544C52v5Ev,
  (VTBL_ENTRY)&_ZN6S544C52v6Ev,
  (VTBL_ENTRY)&_ZN6S544C52v7Ev,
  (VTBL_ENTRY)&_ZN6S544C52v8Ev,
  (VTBL_ENTRY)&_ZN6S544C52v9Ev,
  (VTBL_ENTRY)&_ZN6S544C53v10Ev,
  (VTBL_ENTRY)&_ZN6S544C53v11Ev,
  (VTBL_ENTRY)&_ZN6S544C53v12Ev,
  (VTBL_ENTRY)&_ZN6S544C53v13Ev,
  (VTBL_ENTRY)&_ZN6S544C53v14Ev,
  (VTBL_ENTRY)&_ZN6S544C53v15Ev,
  (VTBL_ENTRY)&_ZN6S544C53v16Ev,
  (VTBL_ENTRY)&_ZN6S544C53v17Ev,
  (VTBL_ENTRY)&_ZN6S544C53v18Ev,
  (VTBL_ENTRY)&_ZN6S544C53v19Ev,
  (VTBL_ENTRY)&_ZN6S544C53v20Ev,
  (VTBL_ENTRY)&_ZN6S544C53v21Ev,
  (VTBL_ENTRY)&_ZN6S544C53v22Ev,
  (VTBL_ENTRY)&_ZN6S544C53v23Ev,
  (VTBL_ENTRY)&_ZN6S544C53v24Ev,
  (VTBL_ENTRY)&_ZN6S544C53v25Ev,
  (VTBL_ENTRY)&_ZN6S544C53v26Ev,
  (VTBL_ENTRY)&_ZN6S544C53v27Ev,
  (VTBL_ENTRY)&_ZN6S544C53v28Ev,
  (VTBL_ENTRY)&_ZN6S544C53v29Ev,
  (VTBL_ENTRY)&_ZN6S544C53v30Ev,
  (VTBL_ENTRY)&_ZN6S544C53v31Ev,
  (VTBL_ENTRY)&_ZN6S544C53v32Ev,
  (VTBL_ENTRY)&_ZN6S544C53v33Ev,
  (VTBL_ENTRY)&_ZN6S544C53v34Ev,
  (VTBL_ENTRY)&_ZN6S544C53v35Ev,
  (VTBL_ENTRY)&_ZN6S544C53v36Ev,
  (VTBL_ENTRY)&_ZN6S544C53v37Ev,
  (VTBL_ENTRY)&_ZN6S544C53v38Ev,
  (VTBL_ENTRY)&_ZN6S544C53v39Ev,
  (VTBL_ENTRY)&_ZN6S544C53v40Ev,
  (VTBL_ENTRY)&_ZN6S544C53v41Ev,
  (VTBL_ENTRY)&_ZN6S544C53v42Ev,
  (VTBL_ENTRY)&_ZN6S544C53v43Ev,
  (VTBL_ENTRY)&_ZN6S544C53v44Ev,
  (VTBL_ENTRY)&_ZN6S544C53v45Ev,
  (VTBL_ENTRY)&_ZN6S544C53v46Ev,
  (VTBL_ENTRY)&_ZN6S544C53v47Ev,
  (VTBL_ENTRY)&_ZN6S544C53v48Ev,
  (VTBL_ENTRY)&_ZN6S544C53v49Ev,
  (VTBL_ENTRY)&_ZN6S544C53v50Ev,
  (VTBL_ENTRY)&_ZN6S544C53v51Ev,
  (VTBL_ENTRY)&_ZN6S544C53v52Ev,
  (VTBL_ENTRY)&_ZN6S544C53v53Ev,
  (VTBL_ENTRY)&_ZN6S544C53v54Ev,
  (VTBL_ENTRY)&_ZN6S544C53v55Ev,
  (VTBL_ENTRY)&_ZN6S544C53v56Ev,
  (VTBL_ENTRY)&_ZN6S544C53v57Ev,
  (VTBL_ENTRY)&_ZN6S544C53v58Ev,
  (VTBL_ENTRY)&_ZN6S544C53v59Ev,
  (VTBL_ENTRY)&_ZN6S544C53v60Ev,
  (VTBL_ENTRY)&_ZN6S544C53v61Ev,
  (VTBL_ENTRY)&_ZN6S544C53v62Ev,
  (VTBL_ENTRY)&_ZN6S544C53v63Ev,
  (VTBL_ENTRY)&_ZN6S544C53v64Ev,
  (VTBL_ENTRY)&_ZN6S544C53v65Ev,
  (VTBL_ENTRY)&_ZN6S544C53v66Ev,
  (VTBL_ENTRY)&_ZN6S544C53v67Ev,
  (VTBL_ENTRY)&_ZN6S544C43v69Ev,
  (VTBL_ENTRY)&_ZN6S544C43v70Ev,
  (VTBL_ENTRY)&_ZN6S544C43v71Ev,
  (VTBL_ENTRY)&_ZN6S544C43v72Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI6S544C4[0]),
  (VTBL_ENTRY)&_ZN6S544C73v68Ev,
};
extern VTBL_ENTRY _ZTI6S544C4[];
extern  VTBL_ENTRY _ZTV6S544C4[];
Class_Descriptor cd_S544C4 = {  "S544C4", // class name
  bases_S544C4, 2,
  &(vtc_S544C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI6S544C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S544C4),75, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S544C8  {
  virtual  ~S544C8(); // _ZN6S544C8D1Ev
  virtual void  v73(); // _ZN6S544C83v73Ev
  virtual void  v74(); // _ZN6S544C83v74Ev
  virtual void  v75(); // _ZN6S544C83v75Ev
  S544C8(); // tgen
};
//SIG(-1 S544C8) C1{ vd v1 v2 v3}


 S544C8 ::~S544C8(){ note_dtor("S544C8", this);}
void  S544C8 ::v73(){vfunc_called(this, "_ZN6S544C83v73Ev");}
void  S544C8 ::v74(){vfunc_called(this, "_ZN6S544C83v74Ev");}
void  S544C8 ::v75(){vfunc_called(this, "_ZN6S544C83v75Ev");}
S544C8 ::S544C8(){ note_ctor("S544C8", this);} // tgen

static void Test_S544C8()
{
  extern Class_Descriptor cd_S544C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S544C8, buf);
    S544C8 *dp, &lv = *(dp=new (buf) S544C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S544C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S544C8)");
    test_class_info(&lv, &cd_S544C8);
    dp->~S544C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS544C8(Test_S544C8, "S544C8", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S544C8C1Ev();
extern void _ZN6S544C8D1Ev();
Name_Map name_map_S544C8[] = {
  NSPAIR(_ZN6S544C8C1Ev),
  NSPAIR(_ZN6S544C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S544C8[];
extern void _ZN6S544C8D1Ev();
extern void _ZN6S544C8D0Ev();
extern void _ZN6S544C83v73Ev();
extern void _ZN6S544C83v74Ev();
extern void _ZN6S544C83v75Ev();
static  VTBL_ENTRY vtc_S544C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S544C8[0]),
  (VTBL_ENTRY)&_ZN6S544C8D1Ev,
  (VTBL_ENTRY)&_ZN6S544C8D0Ev,
  (VTBL_ENTRY)&_ZN6S544C83v73Ev,
  (VTBL_ENTRY)&_ZN6S544C83v74Ev,
  (VTBL_ENTRY)&_ZN6S544C83v75Ev,
};
extern VTBL_ENTRY _ZTI6S544C8[];
extern  VTBL_ENTRY _ZTV6S544C8[];
Class_Descriptor cd_S544C8 = {  "S544C8", // class name
  0,0,//no base classes
  &(vtc_S544C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S544C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S544C8),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S544C3  : S544C4 , S544C8 {
  ::S1566C29 s544c3f0;
  void *s544c3f1[3];
  __tsi64 s544c3f2;
  int s544c3f3[12];
  void *s544c3f4[2];
  int s544c3f5[3];
  ::S1566C10 s544c3f6;
  int s544c3f7[16];
  ::S1566C22_nt s544c3f8;
  __tsi64 s544c3f9;
  int s544c3f10;
  ::S1325C7_nt s544c3f11;
  void *s544c3f12;
  ::S1566C30 s544c3f13;
  virtual  ~S544C3(); // _ZN6S544C3D1Ev
  virtual void  v76(); // _ZN6S544C33v76Ev
  virtual void  v77(); // _ZN6S544C33v77Ev
  virtual void  v78(); // _ZN6S544C33v78Ev
  virtual void  v79(); // _ZN6S544C33v79Ev
  virtual void  v80(); // _ZN6S544C33v80Ev
  virtual void  v81(); // _ZN6S544C33v81Ev
  virtual void  v82(); // _ZN6S544C33v82Ev
  virtual void  v83(); // _ZN6S544C33v83Ev
  virtual void  v84(); // _ZN6S544C33v84Ev
  virtual void  v85(); // _ZN6S544C33v85Ev
  virtual void  v86(); // _ZN6S544C33v86Ev
  virtual void  v87(); // _ZN6S544C33v87Ev
  virtual void  v88(); // _ZN6S544C33v88Ev
  virtual void  v89(); // _ZN6S544C33v89Ev
  virtual void  v90(); // _ZN6S544C33v90Ev
  virtual void  v91(); // _ZN6S544C33v91Ev
  virtual void  v92(); // _ZN6S544C33v92Ev
  virtual void  v93(); // _ZN6S544C33v93Ev
  virtual void  v94(); // _ZN6S544C33v94Ev
  virtual void  v95(); // _ZN6S544C33v95Ev
  virtual void  v96(); // _ZN6S544C33v96Ev
  S544C3(); // tgen
};
//SIG(-1 S544C3) C1{ BC2{ BC3{ vd v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v86} vd v87 v88 v89 v90} BC6{ vd v91 v92 v93} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 FC7{ BC8{ m Fp Fi[2]}} Fp[3] FL Fi[12] Fp[2] Fi[3] FC9{ BC8} Fi[16] FC10{ BC11{ m FC12{ BC8} Fp Fi}} FL Fi FC13{ BC14{ BC15{ BC8}}} Fp FC16{ m Fi[5]}}


 S544C3 ::~S544C3(){ note_dtor("S544C3", this);}
void  S544C3 ::v76(){vfunc_called(this, "_ZN6S544C33v76Ev");}
void  S544C3 ::v77(){vfunc_called(this, "_ZN6S544C33v77Ev");}
void  S544C3 ::v78(){vfunc_called(this, "_ZN6S544C33v78Ev");}
void  S544C3 ::v79(){vfunc_called(this, "_ZN6S544C33v79Ev");}
void  S544C3 ::v80(){vfunc_called(this, "_ZN6S544C33v80Ev");}
void  S544C3 ::v81(){vfunc_called(this, "_ZN6S544C33v81Ev");}
void  S544C3 ::v82(){vfunc_called(this, "_ZN6S544C33v82Ev");}
void  S544C3 ::v83(){vfunc_called(this, "_ZN6S544C33v83Ev");}
void  S544C3 ::v84(){vfunc_called(this, "_ZN6S544C33v84Ev");}
void  S544C3 ::v85(){vfunc_called(this, "_ZN6S544C33v85Ev");}
void  S544C3 ::v86(){vfunc_called(this, "_ZN6S544C33v86Ev");}
void  S544C3 ::v87(){vfunc_called(this, "_ZN6S544C33v87Ev");}
void  S544C3 ::v88(){vfunc_called(this, "_ZN6S544C33v88Ev");}
void  S544C3 ::v89(){vfunc_called(this, "_ZN6S544C33v89Ev");}
void  S544C3 ::v90(){vfunc_called(this, "_ZN6S544C33v90Ev");}
void  S544C3 ::v91(){vfunc_called(this, "_ZN6S544C33v91Ev");}
void  S544C3 ::v92(){vfunc_called(this, "_ZN6S544C33v92Ev");}
void  S544C3 ::v93(){vfunc_called(this, "_ZN6S544C33v93Ev");}
void  S544C3 ::v94(){vfunc_called(this, "_ZN6S544C33v94Ev");}
void  S544C3 ::v95(){vfunc_called(this, "_ZN6S544C33v95Ev");}
void  S544C3 ::v96(){vfunc_called(this, "_ZN6S544C33v96Ev");}
S544C3 ::S544C3(){ note_ctor("S544C3", this);} // tgen

static void Test_S544C3()
{
  extern Class_Descriptor cd_S544C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(53,79)];
    init_test(&cd_S544C3, buf);
    S544C3 *dp, &lv = *(dp=new (buf) S544C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(416,312), "sizeof(S544C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S544C3)");
    check_base_class_offset(lv, (S544C5*)(S544C4*), 0, "S544C3");
    check_base_class_offset(lv, (S544C7*)(S544C4*), ABISELECT(96,60), "S544C3");
    check_base_class_offset(lv, (S544C4*), 0, "S544C3");
    check_base_class_offset(lv, (S544C8*), ABISELECT(104,64), "S544C3");
    check_field_offset(lv, s544c3f0, ABISELECT(112,68), "S544C3.s544c3f0");
    check_field_offset(lv, s544c3f1, ABISELECT(128,80), "S544C3.s544c3f1");
    check_field_offset(lv, s544c3f2, ABISELECT(152,92), "S544C3.s544c3f2");
    check_field_offset(lv, s544c3f3, ABISELECT(160,100), "S544C3.s544c3f3");
    check_field_offset(lv, s544c3f4, ABISELECT(208,148), "S544C3.s544c3f4");
    check_field_offset(lv, s544c3f5, ABISELECT(224,156), "S544C3.s544c3f5");
    check_field_offset(lv, s544c3f6, ABISELECT(240,168), "S544C3.s544c3f6");
    check_field_offset(lv, s544c3f7, ABISELECT(256,180), "S544C3.s544c3f7");
    check_field_offset(lv, s544c3f8, ABISELECT(320,244), "S544C3.s544c3f8");
    check_field_offset(lv, s544c3f9, ABISELECT(352,264), "S544C3.s544c3f9");
    check_field_offset(lv, s544c3f10, ABISELECT(360,272), "S544C3.s544c3f10");
    check_field_offset(lv, s544c3f11, ABISELECT(368,276), "S544C3.s544c3f11");
    check_field_offset(lv, s544c3f12, ABISELECT(384,288), "S544C3.s544c3f12");
    check_field_offset(lv, s544c3f13, ABISELECT(392,292), "S544C3.s544c3f13");
    test_class_info(&lv, &cd_S544C3);
    dp->~S544C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS544C3(Test_S544C3, "S544C3", ABISELECT(416,312));

#else // __cplusplus

extern void _ZN6S544C3C1Ev();
extern void _ZN6S544C3D1Ev();
Name_Map name_map_S544C3[] = {
  NSPAIR(_ZN6S544C3C1Ev),
  NSPAIR(_ZN6S544C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S544C5;
extern VTBL_ENTRY _ZTI6S544C5[];
extern  VTBL_ENTRY _ZTV6S544C5[];
extern Class_Descriptor cd_S544C7;
extern VTBL_ENTRY _ZTI6S544C7[];
extern  VTBL_ENTRY _ZTV6S544C7[];
extern Class_Descriptor cd_S544C4;
extern VTBL_ENTRY _ZTI6S544C4[];
extern  VTBL_ENTRY _ZTV6S544C4[];
extern Class_Descriptor cd_S544C8;
extern VTBL_ENTRY _ZTI6S544C8[];
extern  VTBL_ENTRY _ZTV6S544C8[];
static Base_Class bases_S544C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S544C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S544C7,    ABISELECT(96,60), //bcp->offset
    93, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S544C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S544C8,    ABISELECT(104,64), //bcp->offset
    96, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S544C3[];
extern void _ZN6S544C3D1Ev();
extern void _ZN6S544C3D0Ev();
extern void _ZN6S544C52v4Ev();
extern void _ZN6S544C52v5Ev();
extern void _ZN6S544C52v6Ev();
extern void _ZN6S544C52v7Ev();
extern void _ZN6S544C52v8Ev();
extern void _ZN6S544C52v9Ev();
extern void _ZN6S544C53v10Ev();
extern void _ZN6S544C53v11Ev();
extern void _ZN6S544C53v12Ev();
extern void _ZN6S544C53v13Ev();
extern void _ZN6S544C53v14Ev();
extern void _ZN6S544C53v15Ev();
extern void _ZN6S544C53v16Ev();
extern void _ZN6S544C53v17Ev();
extern void _ZN6S544C53v18Ev();
extern void _ZN6S544C53v19Ev();
extern void _ZN6S544C53v20Ev();
extern void _ZN6S544C53v21Ev();
extern void _ZN6S544C53v22Ev();
extern void _ZN6S544C53v23Ev();
extern void _ZN6S544C53v24Ev();
extern void _ZN6S544C53v25Ev();
extern void _ZN6S544C53v26Ev();
extern void _ZN6S544C53v27Ev();
extern void _ZN6S544C53v28Ev();
extern void _ZN6S544C53v29Ev();
extern void _ZN6S544C53v30Ev();
extern void _ZN6S544C53v31Ev();
extern void _ZN6S544C53v32Ev();
extern void _ZN6S544C53v33Ev();
extern void _ZN6S544C53v34Ev();
extern void _ZN6S544C53v35Ev();
extern void _ZN6S544C53v36Ev();
extern void _ZN6S544C53v37Ev();
extern void _ZN6S544C53v38Ev();
extern void _ZN6S544C53v39Ev();
extern void _ZN6S544C53v40Ev();
extern void _ZN6S544C53v41Ev();
extern void _ZN6S544C53v42Ev();
extern void _ZN6S544C53v43Ev();
extern void _ZN6S544C53v44Ev();
extern void _ZN6S544C53v45Ev();
extern void _ZN6S544C53v46Ev();
extern void _ZN6S544C53v47Ev();
extern void _ZN6S544C53v48Ev();
extern void _ZN6S544C53v49Ev();
extern void _ZN6S544C53v50Ev();
extern void _ZN6S544C53v51Ev();
extern void _ZN6S544C53v52Ev();
extern void _ZN6S544C53v53Ev();
extern void _ZN6S544C53v54Ev();
extern void _ZN6S544C53v55Ev();
extern void _ZN6S544C53v56Ev();
extern void _ZN6S544C53v57Ev();
extern void _ZN6S544C53v58Ev();
extern void _ZN6S544C53v59Ev();
extern void _ZN6S544C53v60Ev();
extern void _ZN6S544C53v61Ev();
extern void _ZN6S544C53v62Ev();
extern void _ZN6S544C53v63Ev();
extern void _ZN6S544C53v64Ev();
extern void _ZN6S544C53v65Ev();
extern void _ZN6S544C53v66Ev();
extern void _ZN6S544C53v67Ev();
extern void _ZN6S544C43v69Ev();
extern void _ZN6S544C43v70Ev();
extern void _ZN6S544C43v71Ev();
extern void _ZN6S544C43v72Ev();
extern void _ZN6S544C33v76Ev();
extern void _ZN6S544C33v77Ev();
extern void _ZN6S544C33v78Ev();
extern void _ZN6S544C33v79Ev();
extern void _ZN6S544C33v80Ev();
extern void _ZN6S544C33v81Ev();
extern void _ZN6S544C33v82Ev();
extern void _ZN6S544C33v83Ev();
extern void _ZN6S544C33v84Ev();
extern void _ZN6S544C33v85Ev();
extern void _ZN6S544C33v86Ev();
extern void _ZN6S544C33v87Ev();
extern void _ZN6S544C33v88Ev();
extern void _ZN6S544C33v89Ev();
extern void _ZN6S544C33v90Ev();
extern void _ZN6S544C33v91Ev();
extern void _ZN6S544C33v92Ev();
extern void _ZN6S544C33v93Ev();
extern void _ZN6S544C33v94Ev();
extern void _ZN6S544C33v95Ev();
extern void _ZN6S544C33v96Ev();
extern void _ZN6S544C73v68Ev();
extern void ABISELECT(_ZThn104_N6S544C3D1Ev,_ZThn64_N6S544C3D1Ev)();
extern void ABISELECT(_ZThn104_N6S544C3D0Ev,_ZThn64_N6S544C3D0Ev)();
extern void _ZN6S544C83v73Ev();
extern void _ZN6S544C83v74Ev();
extern void _ZN6S544C83v75Ev();
static  VTBL_ENTRY vtc_S544C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S544C3[0]),
  (VTBL_ENTRY)&_ZN6S544C3D1Ev,
  (VTBL_ENTRY)&_ZN6S544C3D0Ev,
  (VTBL_ENTRY)&_ZN6S544C52v4Ev,
  (VTBL_ENTRY)&_ZN6S544C52v5Ev,
  (VTBL_ENTRY)&_ZN6S544C52v6Ev,
  (VTBL_ENTRY)&_ZN6S544C52v7Ev,
  (VTBL_ENTRY)&_ZN6S544C52v8Ev,
  (VTBL_ENTRY)&_ZN6S544C52v9Ev,
  (VTBL_ENTRY)&_ZN6S544C53v10Ev,
  (VTBL_ENTRY)&_ZN6S544C53v11Ev,
  (VTBL_ENTRY)&_ZN6S544C53v12Ev,
  (VTBL_ENTRY)&_ZN6S544C53v13Ev,
  (VTBL_ENTRY)&_ZN6S544C53v14Ev,
  (VTBL_ENTRY)&_ZN6S544C53v15Ev,
  (VTBL_ENTRY)&_ZN6S544C53v16Ev,
  (VTBL_ENTRY)&_ZN6S544C53v17Ev,
  (VTBL_ENTRY)&_ZN6S544C53v18Ev,
  (VTBL_ENTRY)&_ZN6S544C53v19Ev,
  (VTBL_ENTRY)&_ZN6S544C53v20Ev,
  (VTBL_ENTRY)&_ZN6S544C53v21Ev,
  (VTBL_ENTRY)&_ZN6S544C53v22Ev,
  (VTBL_ENTRY)&_ZN6S544C53v23Ev,
  (VTBL_ENTRY)&_ZN6S544C53v24Ev,
  (VTBL_ENTRY)&_ZN6S544C53v25Ev,
  (VTBL_ENTRY)&_ZN6S544C53v26Ev,
  (VTBL_ENTRY)&_ZN6S544C53v27Ev,
  (VTBL_ENTRY)&_ZN6S544C53v28Ev,
  (VTBL_ENTRY)&_ZN6S544C53v29Ev,
  (VTBL_ENTRY)&_ZN6S544C53v30Ev,
  (VTBL_ENTRY)&_ZN6S544C53v31Ev,
  (VTBL_ENTRY)&_ZN6S544C53v32Ev,
  (VTBL_ENTRY)&_ZN6S544C53v33Ev,
  (VTBL_ENTRY)&_ZN6S544C53v34Ev,
  (VTBL_ENTRY)&_ZN6S544C53v35Ev,
  (VTBL_ENTRY)&_ZN6S544C53v36Ev,
  (VTBL_ENTRY)&_ZN6S544C53v37Ev,
  (VTBL_ENTRY)&_ZN6S544C53v38Ev,
  (VTBL_ENTRY)&_ZN6S544C53v39Ev,
  (VTBL_ENTRY)&_ZN6S544C53v40Ev,
  (VTBL_ENTRY)&_ZN6S544C53v41Ev,
  (VTBL_ENTRY)&_ZN6S544C53v42Ev,
  (VTBL_ENTRY)&_ZN6S544C53v43Ev,
  (VTBL_ENTRY)&_ZN6S544C53v44Ev,
  (VTBL_ENTRY)&_ZN6S544C53v45Ev,
  (VTBL_ENTRY)&_ZN6S544C53v46Ev,
  (VTBL_ENTRY)&_ZN6S544C53v47Ev,
  (VTBL_ENTRY)&_ZN6S544C53v48Ev,
  (VTBL_ENTRY)&_ZN6S544C53v49Ev,
  (VTBL_ENTRY)&_ZN6S544C53v50Ev,
  (VTBL_ENTRY)&_ZN6S544C53v51Ev,
  (VTBL_ENTRY)&_ZN6S544C53v52Ev,
  (VTBL_ENTRY)&_ZN6S544C53v53Ev,
  (VTBL_ENTRY)&_ZN6S544C53v54Ev,
  (VTBL_ENTRY)&_ZN6S544C53v55Ev,
  (VTBL_ENTRY)&_ZN6S544C53v56Ev,
  (VTBL_ENTRY)&_ZN6S544C53v57Ev,
  (VTBL_ENTRY)&_ZN6S544C53v58Ev,
  (VTBL_ENTRY)&_ZN6S544C53v59Ev,
  (VTBL_ENTRY)&_ZN6S544C53v60Ev,
  (VTBL_ENTRY)&_ZN6S544C53v61Ev,
  (VTBL_ENTRY)&_ZN6S544C53v62Ev,
  (VTBL_ENTRY)&_ZN6S544C53v63Ev,
  (VTBL_ENTRY)&_ZN6S544C53v64Ev,
  (VTBL_ENTRY)&_ZN6S544C53v65Ev,
  (VTBL_ENTRY)&_ZN6S544C53v66Ev,
  (VTBL_ENTRY)&_ZN6S544C53v67Ev,
  (VTBL_ENTRY)&_ZN6S544C43v69Ev,
  (VTBL_ENTRY)&_ZN6S544C43v70Ev,
  (VTBL_ENTRY)&_ZN6S544C43v71Ev,
  (VTBL_ENTRY)&_ZN6S544C43v72Ev,
  (VTBL_ENTRY)&_ZN6S544C33v76Ev,
  (VTBL_ENTRY)&_ZN6S544C33v77Ev,
  (VTBL_ENTRY)&_ZN6S544C33v78Ev,
  (VTBL_ENTRY)&_ZN6S544C33v79Ev,
  (VTBL_ENTRY)&_ZN6S544C33v80Ev,
  (VTBL_ENTRY)&_ZN6S544C33v81Ev,
  (VTBL_ENTRY)&_ZN6S544C33v82Ev,
  (VTBL_ENTRY)&_ZN6S544C33v83Ev,
  (VTBL_ENTRY)&_ZN6S544C33v84Ev,
  (VTBL_ENTRY)&_ZN6S544C33v85Ev,
  (VTBL_ENTRY)&_ZN6S544C33v86Ev,
  (VTBL_ENTRY)&_ZN6S544C33v87Ev,
  (VTBL_ENTRY)&_ZN6S544C33v88Ev,
  (VTBL_ENTRY)&_ZN6S544C33v89Ev,
  (VTBL_ENTRY)&_ZN6S544C33v90Ev,
  (VTBL_ENTRY)&_ZN6S544C33v91Ev,
  (VTBL_ENTRY)&_ZN6S544C33v92Ev,
  (VTBL_ENTRY)&_ZN6S544C33v93Ev,
  (VTBL_ENTRY)&_ZN6S544C33v94Ev,
  (VTBL_ENTRY)&_ZN6S544C33v95Ev,
  (VTBL_ENTRY)&_ZN6S544C33v96Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI6S544C3[0]),
  (VTBL_ENTRY)&_ZN6S544C73v68Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI6S544C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N6S544C3D1Ev,_ZThn64_N6S544C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N6S544C3D0Ev,_ZThn64_N6S544C3D0Ev),
  (VTBL_ENTRY)&_ZN6S544C83v73Ev,
  (VTBL_ENTRY)&_ZN6S544C83v74Ev,
  (VTBL_ENTRY)&_ZN6S544C83v75Ev,
};
extern VTBL_ENTRY _ZTI6S544C3[];
extern  VTBL_ENTRY _ZTV6S544C3[];
Class_Descriptor cd_S544C3 = {  "S544C3", // class name
  bases_S544C3, 4,
  &(vtc_S544C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(416,312), // object size
  NSPAIRA(_ZTI6S544C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S544C3),103, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S544C17  : S1537C8_nt {
};
//SIG(-1 S544C17) C1{ BC2{ m Fp Fi[2]}}



static void Test_S544C17()
{
  extern Class_Descriptor cd_S544C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S544C17, buf);
    S544C17 &lv = *(new (buf) S544C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S544C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S544C17)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S544C17");
    test_class_info(&lv, &cd_S544C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS544C17(Test_S544C17, "S544C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S544C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S544C17 = {  "S544C17", // class name
  bases_S544C17, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S544C16  : S544C17 {
};
//SIG(-1 S544C16) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S544C16()
{
  extern Class_Descriptor cd_S544C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S544C16, buf);
    S544C16 &lv = *(new (buf) S544C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S544C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S544C16)");
    check_base_class_offset(lv, (S1537C8_nt*)(S544C17*), 0, "S544C16");
    check_base_class_offset(lv, (S544C17*), 0, "S544C16");
    test_class_info(&lv, &cd_S544C16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS544C16(Test_S544C16, "S544C16", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S544C17;
static Base_Class bases_S544C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S544C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S544C16 = {  "S544C16", // class name
  bases_S544C16, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S544C2  : S544C3 {
  int s544c2f0[6];
  ::S544C16 s544c2f1;
  ::S1325C7_nt s544c2f2;
  void *s544c2f3;
  __tsi64 s544c2f4[2];
  int s544c2f5[2];
  ::S1325C21 s544c2f6;
  __tsi64 s544c2f7;
  int s544c2f8;
  virtual  ~S544C2(); // _ZN6S544C2D1Ev
  virtual void  v97(); // _ZN6S544C23v97Ev
  virtual void  v98(); // _ZN6S544C23v98Ev
  virtual void  v99(); // _ZN6S544C23v99Ev
  virtual void  v100(); // _ZN6S544C24v100Ev
  virtual void  v101(); // _ZN6S544C24v101Ev
  virtual void  v102(); // _ZN6S544C24v102Ev
  virtual void  v103(); // _ZN6S544C24v103Ev
  virtual void  v104(); // _ZN6S544C24v104Ev
  virtual void  v105(); // _ZN6S544C24v105Ev
  S544C2(); // tgen
};
//SIG(-1 S544C2) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v74} vd v75 v76 v77 v78} BC7{ vd v79 v80 v81} vd v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 FC8{ BC9{ m Fp Fi[2]}} Fp[3] FL Fi[12] Fp[2] Fi[3] FC10{ BC9} Fi[16] FC11{ BC12{ m FC13{ BC9} Fp Fi}} FL Fi FC14{ BC15{ BC16{ BC9}}} Fp FC17{ m Fi[5]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fi[6] FC18{ BC19{ BC9}} FC14 Fp FL[2] Fi[2] FC20{ m FC15 FC15 Fi FC15 FC21{ BC9} FC15 Fi} FL Fi}


 S544C2 ::~S544C2(){ note_dtor("S544C2", this);}
void  S544C2 ::v97(){vfunc_called(this, "_ZN6S544C23v97Ev");}
void  S544C2 ::v98(){vfunc_called(this, "_ZN6S544C23v98Ev");}
void  S544C2 ::v99(){vfunc_called(this, "_ZN6S544C23v99Ev");}
void  S544C2 ::v100(){vfunc_called(this, "_ZN6S544C24v100Ev");}
void  S544C2 ::v101(){vfunc_called(this, "_ZN6S544C24v101Ev");}
void  S544C2 ::v102(){vfunc_called(this, "_ZN6S544C24v102Ev");}
void  S544C2 ::v103(){vfunc_called(this, "_ZN6S544C24v103Ev");}
void  S544C2 ::v104(){vfunc_called(this, "_ZN6S544C24v104Ev");}
void  S544C2 ::v105(){vfunc_called(this, "_ZN6S544C24v105Ev");}
S544C2 ::S544C2(){ note_ctor("S544C2", this);} // tgen

static void Test_S544C2()
{
  extern Class_Descriptor cd_S544C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(78,118)];
    init_test(&cd_S544C2, buf);
    S544C2 *dp, &lv = *(dp=new (buf) S544C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(616,468), "sizeof(S544C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S544C2)");
    check_base_class_offset(lv, (S544C5*)(S544C4*)(S544C3*), 0, "S544C2");
    check_base_class_offset(lv, (S544C7*)(S544C4*)(S544C3*), ABISELECT(96,60), "S544C2");
    check_base_class_offset(lv, (S544C4*)(S544C3*), 0, "S544C2");
    check_base_class_offset(lv, (S544C8*)(S544C3*), ABISELECT(104,64), "S544C2");
    check_base_class_offset(lv, (S544C3*), 0, "S544C2");
    check_field_offset(lv, s544c2f0, ABISELECT(412,312), "S544C2.s544c2f0");
    check_field_offset(lv, s544c2f1, ABISELECT(440,336), "S544C2.s544c2f1");
    check_field_offset(lv, s544c2f2, ABISELECT(456,348), "S544C2.s544c2f2");
    check_field_offset(lv, s544c2f3, ABISELECT(472,360), "S544C2.s544c2f3");
    check_field_offset(lv, s544c2f4, ABISELECT(480,364), "S544C2.s544c2f4");
    check_field_offset(lv, s544c2f5, ABISELECT(496,380), "S544C2.s544c2f5");
    check_field_offset(lv, s544c2f6, ABISELECT(504,388), "S544C2.s544c2f6");
    check_field_offset(lv, s544c2f7, ABISELECT(600,456), "S544C2.s544c2f7");
    check_field_offset(lv, s544c2f8, ABISELECT(608,464), "S544C2.s544c2f8");
    test_class_info(&lv, &cd_S544C2);
    dp->~S544C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS544C2(Test_S544C2, "S544C2", ABISELECT(616,468));

#else // __cplusplus

extern void _ZN6S544C2C1Ev();
extern void _ZN6S544C2D1Ev();
Name_Map name_map_S544C2[] = {
  NSPAIR(_ZN6S544C2C1Ev),
  NSPAIR(_ZN6S544C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S544C5;
extern VTBL_ENTRY _ZTI6S544C5[];
extern  VTBL_ENTRY _ZTV6S544C5[];
extern Class_Descriptor cd_S544C7;
extern VTBL_ENTRY _ZTI6S544C7[];
extern  VTBL_ENTRY _ZTV6S544C7[];
extern Class_Descriptor cd_S544C4;
extern VTBL_ENTRY _ZTI6S544C4[];
extern  VTBL_ENTRY _ZTV6S544C4[];
extern Class_Descriptor cd_S544C8;
extern VTBL_ENTRY _ZTI6S544C8[];
extern  VTBL_ENTRY _ZTV6S544C8[];
extern Class_Descriptor cd_S544C3;
extern VTBL_ENTRY _ZTI6S544C3[];
extern  VTBL_ENTRY _ZTV6S544C3[];
static Base_Class bases_S544C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S544C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S544C7,    ABISELECT(96,60), //bcp->offset
    102, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S544C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S544C8,    ABISELECT(104,64), //bcp->offset
    105, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S544C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S544C2[];
extern void _ZN6S544C2D1Ev();
extern void _ZN6S544C2D0Ev();
extern void _ZN6S544C52v4Ev();
extern void _ZN6S544C52v5Ev();
extern void _ZN6S544C52v6Ev();
extern void _ZN6S544C52v7Ev();
extern void _ZN6S544C52v8Ev();
extern void _ZN6S544C52v9Ev();
extern void _ZN6S544C53v10Ev();
extern void _ZN6S544C53v11Ev();
extern void _ZN6S544C53v12Ev();
extern void _ZN6S544C53v13Ev();
extern void _ZN6S544C53v14Ev();
extern void _ZN6S544C53v15Ev();
extern void _ZN6S544C53v16Ev();
extern void _ZN6S544C53v17Ev();
extern void _ZN6S544C53v18Ev();
extern void _ZN6S544C53v19Ev();
extern void _ZN6S544C53v20Ev();
extern void _ZN6S544C53v21Ev();
extern void _ZN6S544C53v22Ev();
extern void _ZN6S544C53v23Ev();
extern void _ZN6S544C53v24Ev();
extern void _ZN6S544C53v25Ev();
extern void _ZN6S544C53v26Ev();
extern void _ZN6S544C53v27Ev();
extern void _ZN6S544C53v28Ev();
extern void _ZN6S544C53v29Ev();
extern void _ZN6S544C53v30Ev();
extern void _ZN6S544C53v31Ev();
extern void _ZN6S544C53v32Ev();
extern void _ZN6S544C53v33Ev();
extern void _ZN6S544C53v34Ev();
extern void _ZN6S544C53v35Ev();
extern void _ZN6S544C53v36Ev();
extern void _ZN6S544C53v37Ev();
extern void _ZN6S544C53v38Ev();
extern void _ZN6S544C53v39Ev();
extern void _ZN6S544C53v40Ev();
extern void _ZN6S544C53v41Ev();
extern void _ZN6S544C53v42Ev();
extern void _ZN6S544C53v43Ev();
extern void _ZN6S544C53v44Ev();
extern void _ZN6S544C53v45Ev();
extern void _ZN6S544C53v46Ev();
extern void _ZN6S544C53v47Ev();
extern void _ZN6S544C53v48Ev();
extern void _ZN6S544C53v49Ev();
extern void _ZN6S544C53v50Ev();
extern void _ZN6S544C53v51Ev();
extern void _ZN6S544C53v52Ev();
extern void _ZN6S544C53v53Ev();
extern void _ZN6S544C53v54Ev();
extern void _ZN6S544C53v55Ev();
extern void _ZN6S544C53v56Ev();
extern void _ZN6S544C53v57Ev();
extern void _ZN6S544C53v58Ev();
extern void _ZN6S544C53v59Ev();
extern void _ZN6S544C53v60Ev();
extern void _ZN6S544C53v61Ev();
extern void _ZN6S544C53v62Ev();
extern void _ZN6S544C53v63Ev();
extern void _ZN6S544C53v64Ev();
extern void _ZN6S544C53v65Ev();
extern void _ZN6S544C53v66Ev();
extern void _ZN6S544C53v67Ev();
extern void _ZN6S544C43v69Ev();
extern void _ZN6S544C43v70Ev();
extern void _ZN6S544C43v71Ev();
extern void _ZN6S544C43v72Ev();
extern void _ZN6S544C33v76Ev();
extern void _ZN6S544C33v77Ev();
extern void _ZN6S544C33v78Ev();
extern void _ZN6S544C33v79Ev();
extern void _ZN6S544C33v80Ev();
extern void _ZN6S544C33v81Ev();
extern void _ZN6S544C33v82Ev();
extern void _ZN6S544C33v83Ev();
extern void _ZN6S544C33v84Ev();
extern void _ZN6S544C33v85Ev();
extern void _ZN6S544C33v86Ev();
extern void _ZN6S544C33v87Ev();
extern void _ZN6S544C33v88Ev();
extern void _ZN6S544C33v89Ev();
extern void _ZN6S544C33v90Ev();
extern void _ZN6S544C33v91Ev();
extern void _ZN6S544C33v92Ev();
extern void _ZN6S544C33v93Ev();
extern void _ZN6S544C33v94Ev();
extern void _ZN6S544C33v95Ev();
extern void _ZN6S544C33v96Ev();
extern void _ZN6S544C23v97Ev();
extern void _ZN6S544C23v98Ev();
extern void _ZN6S544C23v99Ev();
extern void _ZN6S544C24v100Ev();
extern void _ZN6S544C24v101Ev();
extern void _ZN6S544C24v102Ev();
extern void _ZN6S544C24v103Ev();
extern void _ZN6S544C24v104Ev();
extern void _ZN6S544C24v105Ev();
extern void _ZN6S544C73v68Ev();
extern void ABISELECT(_ZThn104_N6S544C2D1Ev,_ZThn64_N6S544C2D1Ev)();
extern void ABISELECT(_ZThn104_N6S544C2D0Ev,_ZThn64_N6S544C2D0Ev)();
extern void _ZN6S544C83v73Ev();
extern void _ZN6S544C83v74Ev();
extern void _ZN6S544C83v75Ev();
static  VTBL_ENTRY vtc_S544C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S544C2[0]),
  (VTBL_ENTRY)&_ZN6S544C2D1Ev,
  (VTBL_ENTRY)&_ZN6S544C2D0Ev,
  (VTBL_ENTRY)&_ZN6S544C52v4Ev,
  (VTBL_ENTRY)&_ZN6S544C52v5Ev,
  (VTBL_ENTRY)&_ZN6S544C52v6Ev,
  (VTBL_ENTRY)&_ZN6S544C52v7Ev,
  (VTBL_ENTRY)&_ZN6S544C52v8Ev,
  (VTBL_ENTRY)&_ZN6S544C52v9Ev,
  (VTBL_ENTRY)&_ZN6S544C53v10Ev,
  (VTBL_ENTRY)&_ZN6S544C53v11Ev,
  (VTBL_ENTRY)&_ZN6S544C53v12Ev,
  (VTBL_ENTRY)&_ZN6S544C53v13Ev,
  (VTBL_ENTRY)&_ZN6S544C53v14Ev,
  (VTBL_ENTRY)&_ZN6S544C53v15Ev,
  (VTBL_ENTRY)&_ZN6S544C53v16Ev,
  (VTBL_ENTRY)&_ZN6S544C53v17Ev,
  (VTBL_ENTRY)&_ZN6S544C53v18Ev,
  (VTBL_ENTRY)&_ZN6S544C53v19Ev,
  (VTBL_ENTRY)&_ZN6S544C53v20Ev,
  (VTBL_ENTRY)&_ZN6S544C53v21Ev,
  (VTBL_ENTRY)&_ZN6S544C53v22Ev,
  (VTBL_ENTRY)&_ZN6S544C53v23Ev,
  (VTBL_ENTRY)&_ZN6S544C53v24Ev,
  (VTBL_ENTRY)&_ZN6S544C53v25Ev,
  (VTBL_ENTRY)&_ZN6S544C53v26Ev,
  (VTBL_ENTRY)&_ZN6S544C53v27Ev,
  (VTBL_ENTRY)&_ZN6S544C53v28Ev,
  (VTBL_ENTRY)&_ZN6S544C53v29Ev,
  (VTBL_ENTRY)&_ZN6S544C53v30Ev,
  (VTBL_ENTRY)&_ZN6S544C53v31Ev,
  (VTBL_ENTRY)&_ZN6S544C53v32Ev,
  (VTBL_ENTRY)&_ZN6S544C53v33Ev,
  (VTBL_ENTRY)&_ZN6S544C53v34Ev,
  (VTBL_ENTRY)&_ZN6S544C53v35Ev,
  (VTBL_ENTRY)&_ZN6S544C53v36Ev,
  (VTBL_ENTRY)&_ZN6S544C53v37Ev,
  (VTBL_ENTRY)&_ZN6S544C53v38Ev,
  (VTBL_ENTRY)&_ZN6S544C53v39Ev,
  (VTBL_ENTRY)&_ZN6S544C53v40Ev,
  (VTBL_ENTRY)&_ZN6S544C53v41Ev,
  (VTBL_ENTRY)&_ZN6S544C53v42Ev,
  (VTBL_ENTRY)&_ZN6S544C53v43Ev,
  (VTBL_ENTRY)&_ZN6S544C53v44Ev,
  (VTBL_ENTRY)&_ZN6S544C53v45Ev,
  (VTBL_ENTRY)&_ZN6S544C53v46Ev,
  (VTBL_ENTRY)&_ZN6S544C53v47Ev,
  (VTBL_ENTRY)&_ZN6S544C53v48Ev,
  (VTBL_ENTRY)&_ZN6S544C53v49Ev,
  (VTBL_ENTRY)&_ZN6S544C53v50Ev,
  (VTBL_ENTRY)&_ZN6S544C53v51Ev,
  (VTBL_ENTRY)&_ZN6S544C53v52Ev,
  (VTBL_ENTRY)&_ZN6S544C53v53Ev,
  (VTBL_ENTRY)&_ZN6S544C53v54Ev,
  (VTBL_ENTRY)&_ZN6S544C53v55Ev,
  (VTBL_ENTRY)&_ZN6S544C53v56Ev,
  (VTBL_ENTRY)&_ZN6S544C53v57Ev,
  (VTBL_ENTRY)&_ZN6S544C53v58Ev,
  (VTBL_ENTRY)&_ZN6S544C53v59Ev,
  (VTBL_ENTRY)&_ZN6S544C53v60Ev,
  (VTBL_ENTRY)&_ZN6S544C53v61Ev,
  (VTBL_ENTRY)&_ZN6S544C53v62Ev,
  (VTBL_ENTRY)&_ZN6S544C53v63Ev,
  (VTBL_ENTRY)&_ZN6S544C53v64Ev,
  (VTBL_ENTRY)&_ZN6S544C53v65Ev,
  (VTBL_ENTRY)&_ZN6S544C53v66Ev,
  (VTBL_ENTRY)&_ZN6S544C53v67Ev,
  (VTBL_ENTRY)&_ZN6S544C43v69Ev,
  (VTBL_ENTRY)&_ZN6S544C43v70Ev,
  (VTBL_ENTRY)&_ZN6S544C43v71Ev,
  (VTBL_ENTRY)&_ZN6S544C43v72Ev,
  (VTBL_ENTRY)&_ZN6S544C33v76Ev,
  (VTBL_ENTRY)&_ZN6S544C33v77Ev,
  (VTBL_ENTRY)&_ZN6S544C33v78Ev,
  (VTBL_ENTRY)&_ZN6S544C33v79Ev,
  (VTBL_ENTRY)&_ZN6S544C33v80Ev,
  (VTBL_ENTRY)&_ZN6S544C33v81Ev,
  (VTBL_ENTRY)&_ZN6S544C33v82Ev,
  (VTBL_ENTRY)&_ZN6S544C33v83Ev,
  (VTBL_ENTRY)&_ZN6S544C33v84Ev,
  (VTBL_ENTRY)&_ZN6S544C33v85Ev,
  (VTBL_ENTRY)&_ZN6S544C33v86Ev,
  (VTBL_ENTRY)&_ZN6S544C33v87Ev,
  (VTBL_ENTRY)&_ZN6S544C33v88Ev,
  (VTBL_ENTRY)&_ZN6S544C33v89Ev,
  (VTBL_ENTRY)&_ZN6S544C33v90Ev,
  (VTBL_ENTRY)&_ZN6S544C33v91Ev,
  (VTBL_ENTRY)&_ZN6S544C33v92Ev,
  (VTBL_ENTRY)&_ZN6S544C33v93Ev,
  (VTBL_ENTRY)&_ZN6S544C33v94Ev,
  (VTBL_ENTRY)&_ZN6S544C33v95Ev,
  (VTBL_ENTRY)&_ZN6S544C33v96Ev,
  (VTBL_ENTRY)&_ZN6S544C23v97Ev,
  (VTBL_ENTRY)&_ZN6S544C23v98Ev,
  (VTBL_ENTRY)&_ZN6S544C23v99Ev,
  (VTBL_ENTRY)&_ZN6S544C24v100Ev,
  (VTBL_ENTRY)&_ZN6S544C24v101Ev,
  (VTBL_ENTRY)&_ZN6S544C24v102Ev,
  (VTBL_ENTRY)&_ZN6S544C24v103Ev,
  (VTBL_ENTRY)&_ZN6S544C24v104Ev,
  (VTBL_ENTRY)&_ZN6S544C24v105Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI6S544C2[0]),
  (VTBL_ENTRY)&_ZN6S544C73v68Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI6S544C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N6S544C2D1Ev,_ZThn64_N6S544C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N6S544C2D0Ev,_ZThn64_N6S544C2D0Ev),
  (VTBL_ENTRY)&_ZN6S544C83v73Ev,
  (VTBL_ENTRY)&_ZN6S544C83v74Ev,
  (VTBL_ENTRY)&_ZN6S544C83v75Ev,
};
extern VTBL_ENTRY _ZTI6S544C2[];
extern  VTBL_ENTRY _ZTV6S544C2[];
Class_Descriptor cd_S544C2 = {  "S544C2", // class name
  bases_S544C2, 5,
  &(vtc_S544C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(616,468), // object size
  NSPAIRA(_ZTI6S544C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S544C2),112, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S544C1  : S544C2 {
  virtual  ~S544C1(); // _ZN6S544C1D1Ev
  virtual void  v1(); // _ZN6S544C12v1Ev
  virtual void  v2(); // _ZN6S544C12v2Ev
  virtual void  v3(); // _ZN6S544C12v3Ev
  S544C1(); // tgen
};
//SIG(1 S544C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} BC7{ v68} vd v69 v70 v71 v72} BC8{ vd v73 v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 FC9{ BC10{ m Fp Fi[2]}} Fp[3] FL Fi[12] Fp[2] Fi[3] FC11{ BC10} Fi[16] FC12{ BC13{ m FC14{ BC10} Fp Fi}} FL Fi FC15{ BC16{ BC17{ BC10}}} Fp FC18{ m Fi[5]}} vd v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[6] FC19{ BC20{ BC10}} FC15 Fp FL[2] Fi[2] FC21{ m FC16 FC16 Fi FC16 FC22{ BC10} FC16 Fi} FL Fi} vd v1 v2 v3}


 S544C1 ::~S544C1(){ note_dtor("S544C1", this);}
void  S544C1 ::v1(){vfunc_called(this, "_ZN6S544C12v1Ev");}
void  S544C1 ::v2(){vfunc_called(this, "_ZN6S544C12v2Ev");}
void  S544C1 ::v3(){vfunc_called(this, "_ZN6S544C12v3Ev");}
S544C1 ::S544C1(){ note_ctor("S544C1", this);} // tgen

static void Test_S544C1()
{
  extern Class_Descriptor cd_S544C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(78,118)];
    init_test(&cd_S544C1, buf);
    S544C1 *dp, &lv = *(dp=new (buf) S544C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(616,468), "sizeof(S544C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S544C1)");
    check_base_class_offset(lv, (S544C5*)(S544C4*)(S544C3*)(S544C2*), 0, "S544C1");
    check_base_class_offset(lv, (S544C7*)(S544C4*)(S544C3*)(S544C2*), ABISELECT(96,60), "S544C1");
    check_base_class_offset(lv, (S544C4*)(S544C3*)(S544C2*), 0, "S544C1");
    check_base_class_offset(lv, (S544C8*)(S544C3*)(S544C2*), ABISELECT(104,64), "S544C1");
    check_base_class_offset(lv, (S544C3*)(S544C2*), 0, "S544C1");
    check_base_class_offset(lv, (S544C2*), 0, "S544C1");
    test_class_info(&lv, &cd_S544C1);
    dp->~S544C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS544C1(Test_S544C1, "S544C1", ABISELECT(616,468));

#else // __cplusplus

extern void _ZN6S544C1C1Ev();
extern void _ZN6S544C1D1Ev();
Name_Map name_map_S544C1[] = {
  NSPAIR(_ZN6S544C1C1Ev),
  NSPAIR(_ZN6S544C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S544C5;
extern VTBL_ENTRY _ZTI6S544C5[];
extern  VTBL_ENTRY _ZTV6S544C5[];
extern Class_Descriptor cd_S544C7;
extern VTBL_ENTRY _ZTI6S544C7[];
extern  VTBL_ENTRY _ZTV6S544C7[];
extern Class_Descriptor cd_S544C4;
extern VTBL_ENTRY _ZTI6S544C4[];
extern  VTBL_ENTRY _ZTV6S544C4[];
extern Class_Descriptor cd_S544C8;
extern VTBL_ENTRY _ZTI6S544C8[];
extern  VTBL_ENTRY _ZTV6S544C8[];
extern Class_Descriptor cd_S544C3;
extern VTBL_ENTRY _ZTI6S544C3[];
extern  VTBL_ENTRY _ZTV6S544C3[];
extern Class_Descriptor cd_S544C2;
extern VTBL_ENTRY _ZTI6S544C2[];
extern  VTBL_ENTRY _ZTV6S544C2[];
static Base_Class bases_S544C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S544C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S544C7,    ABISELECT(96,60), //bcp->offset
    105, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S544C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S544C8,    ABISELECT(104,64), //bcp->offset
    108, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S544C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S544C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S544C1[];
extern void _ZN6S544C1D1Ev();
extern void _ZN6S544C1D0Ev();
extern void _ZN6S544C52v4Ev();
extern void _ZN6S544C52v5Ev();
extern void _ZN6S544C52v6Ev();
extern void _ZN6S544C52v7Ev();
extern void _ZN6S544C52v8Ev();
extern void _ZN6S544C52v9Ev();
extern void _ZN6S544C53v10Ev();
extern void _ZN6S544C53v11Ev();
extern void _ZN6S544C53v12Ev();
extern void _ZN6S544C53v13Ev();
extern void _ZN6S544C53v14Ev();
extern void _ZN6S544C53v15Ev();
extern void _ZN6S544C53v16Ev();
extern void _ZN6S544C53v17Ev();
extern void _ZN6S544C53v18Ev();
extern void _ZN6S544C53v19Ev();
extern void _ZN6S544C53v20Ev();
extern void _ZN6S544C53v21Ev();
extern void _ZN6S544C53v22Ev();
extern void _ZN6S544C53v23Ev();
extern void _ZN6S544C53v24Ev();
extern void _ZN6S544C53v25Ev();
extern void _ZN6S544C53v26Ev();
extern void _ZN6S544C53v27Ev();
extern void _ZN6S544C53v28Ev();
extern void _ZN6S544C53v29Ev();
extern void _ZN6S544C53v30Ev();
extern void _ZN6S544C53v31Ev();
extern void _ZN6S544C53v32Ev();
extern void _ZN6S544C53v33Ev();
extern void _ZN6S544C53v34Ev();
extern void _ZN6S544C53v35Ev();
extern void _ZN6S544C53v36Ev();
extern void _ZN6S544C53v37Ev();
extern void _ZN6S544C53v38Ev();
extern void _ZN6S544C53v39Ev();
extern void _ZN6S544C53v40Ev();
extern void _ZN6S544C53v41Ev();
extern void _ZN6S544C53v42Ev();
extern void _ZN6S544C53v43Ev();
extern void _ZN6S544C53v44Ev();
extern void _ZN6S544C53v45Ev();
extern void _ZN6S544C53v46Ev();
extern void _ZN6S544C53v47Ev();
extern void _ZN6S544C53v48Ev();
extern void _ZN6S544C53v49Ev();
extern void _ZN6S544C53v50Ev();
extern void _ZN6S544C53v51Ev();
extern void _ZN6S544C53v52Ev();
extern void _ZN6S544C53v53Ev();
extern void _ZN6S544C53v54Ev();
extern void _ZN6S544C53v55Ev();
extern void _ZN6S544C53v56Ev();
extern void _ZN6S544C53v57Ev();
extern void _ZN6S544C53v58Ev();
extern void _ZN6S544C53v59Ev();
extern void _ZN6S544C53v60Ev();
extern void _ZN6S544C53v61Ev();
extern void _ZN6S544C53v62Ev();
extern void _ZN6S544C53v63Ev();
extern void _ZN6S544C53v64Ev();
extern void _ZN6S544C53v65Ev();
extern void _ZN6S544C53v66Ev();
extern void _ZN6S544C53v67Ev();
extern void _ZN6S544C43v69Ev();
extern void _ZN6S544C43v70Ev();
extern void _ZN6S544C43v71Ev();
extern void _ZN6S544C43v72Ev();
extern void _ZN6S544C33v76Ev();
extern void _ZN6S544C33v77Ev();
extern void _ZN6S544C33v78Ev();
extern void _ZN6S544C33v79Ev();
extern void _ZN6S544C33v80Ev();
extern void _ZN6S544C33v81Ev();
extern void _ZN6S544C33v82Ev();
extern void _ZN6S544C33v83Ev();
extern void _ZN6S544C33v84Ev();
extern void _ZN6S544C33v85Ev();
extern void _ZN6S544C33v86Ev();
extern void _ZN6S544C33v87Ev();
extern void _ZN6S544C33v88Ev();
extern void _ZN6S544C33v89Ev();
extern void _ZN6S544C33v90Ev();
extern void _ZN6S544C33v91Ev();
extern void _ZN6S544C33v92Ev();
extern void _ZN6S544C33v93Ev();
extern void _ZN6S544C33v94Ev();
extern void _ZN6S544C33v95Ev();
extern void _ZN6S544C33v96Ev();
extern void _ZN6S544C23v97Ev();
extern void _ZN6S544C23v98Ev();
extern void _ZN6S544C23v99Ev();
extern void _ZN6S544C24v100Ev();
extern void _ZN6S544C24v101Ev();
extern void _ZN6S544C24v102Ev();
extern void _ZN6S544C24v103Ev();
extern void _ZN6S544C24v104Ev();
extern void _ZN6S544C24v105Ev();
extern void _ZN6S544C12v1Ev();
extern void _ZN6S544C12v2Ev();
extern void _ZN6S544C12v3Ev();
extern void _ZN6S544C73v68Ev();
extern void ABISELECT(_ZThn104_N6S544C1D1Ev,_ZThn64_N6S544C1D1Ev)();
extern void ABISELECT(_ZThn104_N6S544C1D0Ev,_ZThn64_N6S544C1D0Ev)();
extern void _ZN6S544C83v73Ev();
extern void _ZN6S544C83v74Ev();
extern void _ZN6S544C83v75Ev();
static  VTBL_ENTRY vtc_S544C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S544C1[0]),
  (VTBL_ENTRY)&_ZN6S544C1D1Ev,
  (VTBL_ENTRY)&_ZN6S544C1D0Ev,
  (VTBL_ENTRY)&_ZN6S544C52v4Ev,
  (VTBL_ENTRY)&_ZN6S544C52v5Ev,
  (VTBL_ENTRY)&_ZN6S544C52v6Ev,
  (VTBL_ENTRY)&_ZN6S544C52v7Ev,
  (VTBL_ENTRY)&_ZN6S544C52v8Ev,
  (VTBL_ENTRY)&_ZN6S544C52v9Ev,
  (VTBL_ENTRY)&_ZN6S544C53v10Ev,
  (VTBL_ENTRY)&_ZN6S544C53v11Ev,
  (VTBL_ENTRY)&_ZN6S544C53v12Ev,
  (VTBL_ENTRY)&_ZN6S544C53v13Ev,
  (VTBL_ENTRY)&_ZN6S544C53v14Ev,
  (VTBL_ENTRY)&_ZN6S544C53v15Ev,
  (VTBL_ENTRY)&_ZN6S544C53v16Ev,
  (VTBL_ENTRY)&_ZN6S544C53v17Ev,
  (VTBL_ENTRY)&_ZN6S544C53v18Ev,
  (VTBL_ENTRY)&_ZN6S544C53v19Ev,
  (VTBL_ENTRY)&_ZN6S544C53v20Ev,
  (VTBL_ENTRY)&_ZN6S544C53v21Ev,
  (VTBL_ENTRY)&_ZN6S544C53v22Ev,
  (VTBL_ENTRY)&_ZN6S544C53v23Ev,
  (VTBL_ENTRY)&_ZN6S544C53v24Ev,
  (VTBL_ENTRY)&_ZN6S544C53v25Ev,
  (VTBL_ENTRY)&_ZN6S544C53v26Ev,
  (VTBL_ENTRY)&_ZN6S544C53v27Ev,
  (VTBL_ENTRY)&_ZN6S544C53v28Ev,
  (VTBL_ENTRY)&_ZN6S544C53v29Ev,
  (VTBL_ENTRY)&_ZN6S544C53v30Ev,
  (VTBL_ENTRY)&_ZN6S544C53v31Ev,
  (VTBL_ENTRY)&_ZN6S544C53v32Ev,
  (VTBL_ENTRY)&_ZN6S544C53v33Ev,
  (VTBL_ENTRY)&_ZN6S544C53v34Ev,
  (VTBL_ENTRY)&_ZN6S544C53v35Ev,
  (VTBL_ENTRY)&_ZN6S544C53v36Ev,
  (VTBL_ENTRY)&_ZN6S544C53v37Ev,
  (VTBL_ENTRY)&_ZN6S544C53v38Ev,
  (VTBL_ENTRY)&_ZN6S544C53v39Ev,
  (VTBL_ENTRY)&_ZN6S544C53v40Ev,
  (VTBL_ENTRY)&_ZN6S544C53v41Ev,
  (VTBL_ENTRY)&_ZN6S544C53v42Ev,
  (VTBL_ENTRY)&_ZN6S544C53v43Ev,
  (VTBL_ENTRY)&_ZN6S544C53v44Ev,
  (VTBL_ENTRY)&_ZN6S544C53v45Ev,
  (VTBL_ENTRY)&_ZN6S544C53v46Ev,
  (VTBL_ENTRY)&_ZN6S544C53v47Ev,
  (VTBL_ENTRY)&_ZN6S544C53v48Ev,
  (VTBL_ENTRY)&_ZN6S544C53v49Ev,
  (VTBL_ENTRY)&_ZN6S544C53v50Ev,
  (VTBL_ENTRY)&_ZN6S544C53v51Ev,
  (VTBL_ENTRY)&_ZN6S544C53v52Ev,
  (VTBL_ENTRY)&_ZN6S544C53v53Ev,
  (VTBL_ENTRY)&_ZN6S544C53v54Ev,
  (VTBL_ENTRY)&_ZN6S544C53v55Ev,
  (VTBL_ENTRY)&_ZN6S544C53v56Ev,
  (VTBL_ENTRY)&_ZN6S544C53v57Ev,
  (VTBL_ENTRY)&_ZN6S544C53v58Ev,
  (VTBL_ENTRY)&_ZN6S544C53v59Ev,
  (VTBL_ENTRY)&_ZN6S544C53v60Ev,
  (VTBL_ENTRY)&_ZN6S544C53v61Ev,
  (VTBL_ENTRY)&_ZN6S544C53v62Ev,
  (VTBL_ENTRY)&_ZN6S544C53v63Ev,
  (VTBL_ENTRY)&_ZN6S544C53v64Ev,
  (VTBL_ENTRY)&_ZN6S544C53v65Ev,
  (VTBL_ENTRY)&_ZN6S544C53v66Ev,
  (VTBL_ENTRY)&_ZN6S544C53v67Ev,
  (VTBL_ENTRY)&_ZN6S544C43v69Ev,
  (VTBL_ENTRY)&_ZN6S544C43v70Ev,
  (VTBL_ENTRY)&_ZN6S544C43v71Ev,
  (VTBL_ENTRY)&_ZN6S544C43v72Ev,
  (VTBL_ENTRY)&_ZN6S544C33v76Ev,
  (VTBL_ENTRY)&_ZN6S544C33v77Ev,
  (VTBL_ENTRY)&_ZN6S544C33v78Ev,
  (VTBL_ENTRY)&_ZN6S544C33v79Ev,
  (VTBL_ENTRY)&_ZN6S544C33v80Ev,
  (VTBL_ENTRY)&_ZN6S544C33v81Ev,
  (VTBL_ENTRY)&_ZN6S544C33v82Ev,
  (VTBL_ENTRY)&_ZN6S544C33v83Ev,
  (VTBL_ENTRY)&_ZN6S544C33v84Ev,
  (VTBL_ENTRY)&_ZN6S544C33v85Ev,
  (VTBL_ENTRY)&_ZN6S544C33v86Ev,
  (VTBL_ENTRY)&_ZN6S544C33v87Ev,
  (VTBL_ENTRY)&_ZN6S544C33v88Ev,
  (VTBL_ENTRY)&_ZN6S544C33v89Ev,
  (VTBL_ENTRY)&_ZN6S544C33v90Ev,
  (VTBL_ENTRY)&_ZN6S544C33v91Ev,
  (VTBL_ENTRY)&_ZN6S544C33v92Ev,
  (VTBL_ENTRY)&_ZN6S544C33v93Ev,
  (VTBL_ENTRY)&_ZN6S544C33v94Ev,
  (VTBL_ENTRY)&_ZN6S544C33v95Ev,
  (VTBL_ENTRY)&_ZN6S544C33v96Ev,
  (VTBL_ENTRY)&_ZN6S544C23v97Ev,
  (VTBL_ENTRY)&_ZN6S544C23v98Ev,
  (VTBL_ENTRY)&_ZN6S544C23v99Ev,
  (VTBL_ENTRY)&_ZN6S544C24v100Ev,
  (VTBL_ENTRY)&_ZN6S544C24v101Ev,
  (VTBL_ENTRY)&_ZN6S544C24v102Ev,
  (VTBL_ENTRY)&_ZN6S544C24v103Ev,
  (VTBL_ENTRY)&_ZN6S544C24v104Ev,
  (VTBL_ENTRY)&_ZN6S544C24v105Ev,
  (VTBL_ENTRY)&_ZN6S544C12v1Ev,
  (VTBL_ENTRY)&_ZN6S544C12v2Ev,
  (VTBL_ENTRY)&_ZN6S544C12v3Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI6S544C1[0]),
  (VTBL_ENTRY)&_ZN6S544C73v68Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI6S544C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N6S544C1D1Ev,_ZThn64_N6S544C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N6S544C1D0Ev,_ZThn64_N6S544C1D0Ev),
  (VTBL_ENTRY)&_ZN6S544C83v73Ev,
  (VTBL_ENTRY)&_ZN6S544C83v74Ev,
  (VTBL_ENTRY)&_ZN6S544C83v75Ev,
};
extern VTBL_ENTRY _ZTI6S544C1[];
extern  VTBL_ENTRY _ZTV6S544C1[];
Class_Descriptor cd_S544C1 = {  "S544C1", // class name
  bases_S544C1, 6,
  &(vtc_S544C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(616,468), // object size
  NSPAIRA(_ZTI6S544C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S544C1),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1567C4  {
  int s1567c4f0;
  __tsi64 s1567c4f1;
  void *s1567c4f2[4];
  int s1567c4f3[2];
  void *s1567c4f4;
  ::S1566C14_nt s1567c4f5;
  void *s1567c4f6[2];
  virtual  ~S1567C4(); // _ZN7S1567C4D1Ev
  virtual void  v8(); // _ZN7S1567C42v8Ev
  virtual void  v9(); // _ZN7S1567C42v9Ev
  virtual void  v10(); // _ZN7S1567C43v10Ev
  virtual void  v11(); // _ZN7S1567C43v11Ev
  virtual void  v12(); // _ZN7S1567C43v12Ev
  virtual void  v13(); // _ZN7S1567C43v13Ev
  virtual void  v14(); // _ZN7S1567C43v14Ev
  virtual void  v15(); // _ZN7S1567C43v15Ev
  virtual void  v16(); // _ZN7S1567C43v16Ev
  virtual void  v17(); // _ZN7S1567C43v17Ev
  virtual void  v18(); // _ZN7S1567C43v18Ev
  virtual void  v19(); // _ZN7S1567C43v19Ev
  virtual void  v20(); // _ZN7S1567C43v20Ev
  virtual void  v21(); // _ZN7S1567C43v21Ev
  virtual void  v22(); // _ZN7S1567C43v22Ev
  virtual void  v23(); // _ZN7S1567C43v23Ev
  virtual void  v24(); // _ZN7S1567C43v24Ev
  virtual void  v25(); // _ZN7S1567C43v25Ev
  virtual void  v26(); // _ZN7S1567C43v26Ev
  virtual void  v27(); // _ZN7S1567C43v27Ev
  virtual void  v28(); // _ZN7S1567C43v28Ev
  virtual void  v29(); // _ZN7S1567C43v29Ev
  virtual void  v30(); // _ZN7S1567C43v30Ev
  virtual void  v31(); // _ZN7S1567C43v31Ev
  virtual void  v32(); // _ZN7S1567C43v32Ev
  virtual void  v33(); // _ZN7S1567C43v33Ev
  virtual void  v34(); // _ZN7S1567C43v34Ev
  virtual void  v35(); // _ZN7S1567C43v35Ev
  virtual void  v36(); // _ZN7S1567C43v36Ev
  virtual void  v37(); // _ZN7S1567C43v37Ev
  virtual void  v38(); // _ZN7S1567C43v38Ev
  virtual void  v39(); // _ZN7S1567C43v39Ev
  virtual void  v40(); // _ZN7S1567C43v40Ev
  virtual void  v41(); // _ZN7S1567C43v41Ev
  virtual void  v42(); // _ZN7S1567C43v42Ev
  virtual void  v43(); // _ZN7S1567C43v43Ev
  virtual void  v44(); // _ZN7S1567C43v44Ev
  virtual void  v45(); // _ZN7S1567C43v45Ev
  virtual void  v46(); // _ZN7S1567C43v46Ev
  virtual void  v47(); // _ZN7S1567C43v47Ev
  virtual void  v48(); // _ZN7S1567C43v48Ev
  virtual void  v49(); // _ZN7S1567C43v49Ev
  virtual void  v50(); // _ZN7S1567C43v50Ev
  virtual void  v51(); // _ZN7S1567C43v51Ev
  virtual void  v52(); // _ZN7S1567C43v52Ev
  virtual void  v53(); // _ZN7S1567C43v53Ev
  virtual void  v54(); // _ZN7S1567C43v54Ev
  virtual void  v55(); // _ZN7S1567C43v55Ev
  virtual void  v56(); // _ZN7S1567C43v56Ev
  virtual void  v57(); // _ZN7S1567C43v57Ev
  virtual void  v58(); // _ZN7S1567C43v58Ev
  virtual void  v59(); // _ZN7S1567C43v59Ev
  virtual void  v60(); // _ZN7S1567C43v60Ev
  virtual void  v61(); // _ZN7S1567C43v61Ev
  virtual void  v62(); // _ZN7S1567C43v62Ev
  virtual void  v63(); // _ZN7S1567C43v63Ev
  virtual void  v64(); // _ZN7S1567C43v64Ev
  virtual void  v65(); // _ZN7S1567C43v65Ev
  virtual void  v66(); // _ZN7S1567C43v66Ev
  virtual void  v67(); // _ZN7S1567C43v67Ev
  virtual void  v68(); // _ZN7S1567C43v68Ev
  virtual void  v69(); // _ZN7S1567C43v69Ev
  virtual void  v70(); // _ZN7S1567C43v70Ev
  virtual void  v71(); // _ZN7S1567C43v71Ev
  S1567C4(); // tgen
};
//SIG(-1 S1567C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1567C4 ::~S1567C4(){ note_dtor("S1567C4", this);}
void  S1567C4 ::v8(){vfunc_called(this, "_ZN7S1567C42v8Ev");}
void  S1567C4 ::v9(){vfunc_called(this, "_ZN7S1567C42v9Ev");}
void  S1567C4 ::v10(){vfunc_called(this, "_ZN7S1567C43v10Ev");}
void  S1567C4 ::v11(){vfunc_called(this, "_ZN7S1567C43v11Ev");}
void  S1567C4 ::v12(){vfunc_called(this, "_ZN7S1567C43v12Ev");}
void  S1567C4 ::v13(){vfunc_called(this, "_ZN7S1567C43v13Ev");}
void  S1567C4 ::v14(){vfunc_called(this, "_ZN7S1567C43v14Ev");}
void  S1567C4 ::v15(){vfunc_called(this, "_ZN7S1567C43v15Ev");}
void  S1567C4 ::v16(){vfunc_called(this, "_ZN7S1567C43v16Ev");}
void  S1567C4 ::v17(){vfunc_called(this, "_ZN7S1567C43v17Ev");}
void  S1567C4 ::v18(){vfunc_called(this, "_ZN7S1567C43v18Ev");}
void  S1567C4 ::v19(){vfunc_called(this, "_ZN7S1567C43v19Ev");}
void  S1567C4 ::v20(){vfunc_called(this, "_ZN7S1567C43v20Ev");}
void  S1567C4 ::v21(){vfunc_called(this, "_ZN7S1567C43v21Ev");}
void  S1567C4 ::v22(){vfunc_called(this, "_ZN7S1567C43v22Ev");}
void  S1567C4 ::v23(){vfunc_called(this, "_ZN7S1567C43v23Ev");}
void  S1567C4 ::v24(){vfunc_called(this, "_ZN7S1567C43v24Ev");}
void  S1567C4 ::v25(){vfunc_called(this, "_ZN7S1567C43v25Ev");}
void  S1567C4 ::v26(){vfunc_called(this, "_ZN7S1567C43v26Ev");}
void  S1567C4 ::v27(){vfunc_called(this, "_ZN7S1567C43v27Ev");}
void  S1567C4 ::v28(){vfunc_called(this, "_ZN7S1567C43v28Ev");}
void  S1567C4 ::v29(){vfunc_called(this, "_ZN7S1567C43v29Ev");}
void  S1567C4 ::v30(){vfunc_called(this, "_ZN7S1567C43v30Ev");}
void  S1567C4 ::v31(){vfunc_called(this, "_ZN7S1567C43v31Ev");}
void  S1567C4 ::v32(){vfunc_called(this, "_ZN7S1567C43v32Ev");}
void  S1567C4 ::v33(){vfunc_called(this, "_ZN7S1567C43v33Ev");}
void  S1567C4 ::v34(){vfunc_called(this, "_ZN7S1567C43v34Ev");}
void  S1567C4 ::v35(){vfunc_called(this, "_ZN7S1567C43v35Ev");}
void  S1567C4 ::v36(){vfunc_called(this, "_ZN7S1567C43v36Ev");}
void  S1567C4 ::v37(){vfunc_called(this, "_ZN7S1567C43v37Ev");}
void  S1567C4 ::v38(){vfunc_called(this, "_ZN7S1567C43v38Ev");}
void  S1567C4 ::v39(){vfunc_called(this, "_ZN7S1567C43v39Ev");}
void  S1567C4 ::v40(){vfunc_called(this, "_ZN7S1567C43v40Ev");}
void  S1567C4 ::v41(){vfunc_called(this, "_ZN7S1567C43v41Ev");}
void  S1567C4 ::v42(){vfunc_called(this, "_ZN7S1567C43v42Ev");}
void  S1567C4 ::v43(){vfunc_called(this, "_ZN7S1567C43v43Ev");}
void  S1567C4 ::v44(){vfunc_called(this, "_ZN7S1567C43v44Ev");}
void  S1567C4 ::v45(){vfunc_called(this, "_ZN7S1567C43v45Ev");}
void  S1567C4 ::v46(){vfunc_called(this, "_ZN7S1567C43v46Ev");}
void  S1567C4 ::v47(){vfunc_called(this, "_ZN7S1567C43v47Ev");}
void  S1567C4 ::v48(){vfunc_called(this, "_ZN7S1567C43v48Ev");}
void  S1567C4 ::v49(){vfunc_called(this, "_ZN7S1567C43v49Ev");}
void  S1567C4 ::v50(){vfunc_called(this, "_ZN7S1567C43v50Ev");}
void  S1567C4 ::v51(){vfunc_called(this, "_ZN7S1567C43v51Ev");}
void  S1567C4 ::v52(){vfunc_called(this, "_ZN7S1567C43v52Ev");}
void  S1567C4 ::v53(){vfunc_called(this, "_ZN7S1567C43v53Ev");}
void  S1567C4 ::v54(){vfunc_called(this, "_ZN7S1567C43v54Ev");}
void  S1567C4 ::v55(){vfunc_called(this, "_ZN7S1567C43v55Ev");}
void  S1567C4 ::v56(){vfunc_called(this, "_ZN7S1567C43v56Ev");}
void  S1567C4 ::v57(){vfunc_called(this, "_ZN7S1567C43v57Ev");}
void  S1567C4 ::v58(){vfunc_called(this, "_ZN7S1567C43v58Ev");}
void  S1567C4 ::v59(){vfunc_called(this, "_ZN7S1567C43v59Ev");}
void  S1567C4 ::v60(){vfunc_called(this, "_ZN7S1567C43v60Ev");}
void  S1567C4 ::v61(){vfunc_called(this, "_ZN7S1567C43v61Ev");}
void  S1567C4 ::v62(){vfunc_called(this, "_ZN7S1567C43v62Ev");}
void  S1567C4 ::v63(){vfunc_called(this, "_ZN7S1567C43v63Ev");}
void  S1567C4 ::v64(){vfunc_called(this, "_ZN7S1567C43v64Ev");}
void  S1567C4 ::v65(){vfunc_called(this, "_ZN7S1567C43v65Ev");}
void  S1567C4 ::v66(){vfunc_called(this, "_ZN7S1567C43v66Ev");}
void  S1567C4 ::v67(){vfunc_called(this, "_ZN7S1567C43v67Ev");}
void  S1567C4 ::v68(){vfunc_called(this, "_ZN7S1567C43v68Ev");}
void  S1567C4 ::v69(){vfunc_called(this, "_ZN7S1567C43v69Ev");}
void  S1567C4 ::v70(){vfunc_called(this, "_ZN7S1567C43v70Ev");}
void  S1567C4 ::v71(){vfunc_called(this, "_ZN7S1567C43v71Ev");}
S1567C4 ::S1567C4(){ note_ctor("S1567C4", this);} // tgen

static void Test_S1567C4()
{
  extern Class_Descriptor cd_S1567C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1567C4, buf);
    S1567C4 *dp, &lv = *(dp=new (buf) S1567C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1567C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1567C4)");
    check_field_offset(lv, s1567c4f0, ABISELECT(8,4), "S1567C4.s1567c4f0");
    check_field_offset(lv, s1567c4f1, ABISELECT(16,8), "S1567C4.s1567c4f1");
    check_field_offset(lv, s1567c4f2, ABISELECT(24,16), "S1567C4.s1567c4f2");
    check_field_offset(lv, s1567c4f3, ABISELECT(56,32), "S1567C4.s1567c4f3");
    check_field_offset(lv, s1567c4f4, ABISELECT(64,40), "S1567C4.s1567c4f4");
    check_field_offset(lv, s1567c4f5, ABISELECT(72,44), "S1567C4.s1567c4f5");
    check_field_offset(lv, s1567c4f6, ABISELECT(80,52), "S1567C4.s1567c4f6");
    test_class_info(&lv, &cd_S1567C4);
    dp->~S1567C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1567C4(Test_S1567C4, "S1567C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1567C4C1Ev();
extern void _ZN7S1567C4D1Ev();
Name_Map name_map_S1567C4[] = {
  NSPAIR(_ZN7S1567C4C1Ev),
  NSPAIR(_ZN7S1567C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1567C4[];
extern void _ZN7S1567C4D1Ev();
extern void _ZN7S1567C4D0Ev();
extern void _ZN7S1567C42v8Ev();
extern void _ZN7S1567C42v9Ev();
extern void _ZN7S1567C43v10Ev();
extern void _ZN7S1567C43v11Ev();
extern void _ZN7S1567C43v12Ev();
extern void _ZN7S1567C43v13Ev();
extern void _ZN7S1567C43v14Ev();
extern void _ZN7S1567C43v15Ev();
extern void _ZN7S1567C43v16Ev();
extern void _ZN7S1567C43v17Ev();
extern void _ZN7S1567C43v18Ev();
extern void _ZN7S1567C43v19Ev();
extern void _ZN7S1567C43v20Ev();
extern void _ZN7S1567C43v21Ev();
extern void _ZN7S1567C43v22Ev();
extern void _ZN7S1567C43v23Ev();
extern void _ZN7S1567C43v24Ev();
extern void _ZN7S1567C43v25Ev();
extern void _ZN7S1567C43v26Ev();
extern void _ZN7S1567C43v27Ev();
extern void _ZN7S1567C43v28Ev();
extern void _ZN7S1567C43v29Ev();
extern void _ZN7S1567C43v30Ev();
extern void _ZN7S1567C43v31Ev();
extern void _ZN7S1567C43v32Ev();
extern void _ZN7S1567C43v33Ev();
extern void _ZN7S1567C43v34Ev();
extern void _ZN7S1567C43v35Ev();
extern void _ZN7S1567C43v36Ev();
extern void _ZN7S1567C43v37Ev();
extern void _ZN7S1567C43v38Ev();
extern void _ZN7S1567C43v39Ev();
extern void _ZN7S1567C43v40Ev();
extern void _ZN7S1567C43v41Ev();
extern void _ZN7S1567C43v42Ev();
extern void _ZN7S1567C43v43Ev();
extern void _ZN7S1567C43v44Ev();
extern void _ZN7S1567C43v45Ev();
extern void _ZN7S1567C43v46Ev();
extern void _ZN7S1567C43v47Ev();
extern void _ZN7S1567C43v48Ev();
extern void _ZN7S1567C43v49Ev();
extern void _ZN7S1567C43v50Ev();
extern void _ZN7S1567C43v51Ev();
extern void _ZN7S1567C43v52Ev();
extern void _ZN7S1567C43v53Ev();
extern void _ZN7S1567C43v54Ev();
extern void _ZN7S1567C43v55Ev();
extern void _ZN7S1567C43v56Ev();
extern void _ZN7S1567C43v57Ev();
extern void _ZN7S1567C43v58Ev();
extern void _ZN7S1567C43v59Ev();
extern void _ZN7S1567C43v60Ev();
extern void _ZN7S1567C43v61Ev();
extern void _ZN7S1567C43v62Ev();
extern void _ZN7S1567C43v63Ev();
extern void _ZN7S1567C43v64Ev();
extern void _ZN7S1567C43v65Ev();
extern void _ZN7S1567C43v66Ev();
extern void _ZN7S1567C43v67Ev();
extern void _ZN7S1567C43v68Ev();
extern void _ZN7S1567C43v69Ev();
extern void _ZN7S1567C43v70Ev();
extern void _ZN7S1567C43v71Ev();
static  VTBL_ENTRY vtc_S1567C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1567C4[0]),
  (VTBL_ENTRY)&_ZN7S1567C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1567C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1567C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1567C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v71Ev,
};
extern VTBL_ENTRY _ZTI7S1567C4[];
extern  VTBL_ENTRY _ZTV7S1567C4[];
Class_Descriptor cd_S1567C4 = {  "S1567C4", // class name
  0,0,//no base classes
  &(vtc_S1567C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1567C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1567C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1567C6  {
  virtual void  v72(); // _ZN7S1567C63v72Ev
  ~S1567C6(); // tgen
  S1567C6(); // tgen
};
//SIG(-1 S1567C6) C1{ v1}


void  S1567C6 ::v72(){vfunc_called(this, "_ZN7S1567C63v72Ev");}
S1567C6 ::~S1567C6(){ note_dtor("S1567C6", this);} // tgen
S1567C6 ::S1567C6(){ note_ctor("S1567C6", this);} // tgen

static void Test_S1567C6()
{
  extern Class_Descriptor cd_S1567C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1567C6, buf);
    S1567C6 *dp, &lv = *(dp=new (buf) S1567C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1567C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1567C6)");
    test_class_info(&lv, &cd_S1567C6);
    dp->~S1567C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1567C6(Test_S1567C6, "S1567C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1567C6C1Ev();
extern void _ZN7S1567C6D1Ev();
Name_Map name_map_S1567C6[] = {
  NSPAIR(_ZN7S1567C6C1Ev),
  NSPAIR(_ZN7S1567C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1567C6[];
extern void _ZN7S1567C63v72Ev();
static  VTBL_ENTRY vtc_S1567C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1567C6[0]),
  (VTBL_ENTRY)&_ZN7S1567C63v72Ev,
};
extern VTBL_ENTRY _ZTI7S1567C6[];
extern  VTBL_ENTRY _ZTV7S1567C6[];
Class_Descriptor cd_S1567C6 = {  "S1567C6", // class name
  0,0,//no base classes
  &(vtc_S1567C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1567C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1567C6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1567C3  : S1567C4 , S1567C6 {
  virtual  ~S1567C3(); // _ZN7S1567C3D1Ev
  virtual void  v73(); // _ZN7S1567C33v73Ev
  virtual void  v74(); // _ZN7S1567C33v74Ev
  virtual void  v75(); // _ZN7S1567C33v75Ev
  virtual void  v76(); // _ZN7S1567C33v76Ev
  S1567C3(); // tgen
};
//SIG(-1 S1567C3) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v69} vd v1 v2 v3 v4}


 S1567C3 ::~S1567C3(){ note_dtor("S1567C3", this);}
void  S1567C3 ::v73(){vfunc_called(this, "_ZN7S1567C33v73Ev");}
void  S1567C3 ::v74(){vfunc_called(this, "_ZN7S1567C33v74Ev");}
void  S1567C3 ::v75(){vfunc_called(this, "_ZN7S1567C33v75Ev");}
void  S1567C3 ::v76(){vfunc_called(this, "_ZN7S1567C33v76Ev");}
S1567C3 ::S1567C3(){ note_ctor("S1567C3", this);} // tgen

static void Test_S1567C3()
{
  extern Class_Descriptor cd_S1567C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1567C3, buf);
    S1567C3 *dp, &lv = *(dp=new (buf) S1567C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1567C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1567C3)");
    check_base_class_offset(lv, (S1567C4*), 0, "S1567C3");
    check_base_class_offset(lv, (S1567C6*), ABISELECT(96,60), "S1567C3");
    test_class_info(&lv, &cd_S1567C3);
    dp->~S1567C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1567C3(Test_S1567C3, "S1567C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1567C3C1Ev();
extern void _ZN7S1567C3D1Ev();
Name_Map name_map_S1567C3[] = {
  NSPAIR(_ZN7S1567C3C1Ev),
  NSPAIR(_ZN7S1567C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1567C4;
extern VTBL_ENTRY _ZTI7S1567C4[];
extern  VTBL_ENTRY _ZTV7S1567C4[];
extern Class_Descriptor cd_S1567C6;
extern VTBL_ENTRY _ZTI7S1567C6[];
extern  VTBL_ENTRY _ZTV7S1567C6[];
static Base_Class bases_S1567C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1567C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1567C6,    ABISELECT(96,60), //bcp->offset
    72, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1567C3[];
extern void _ZN7S1567C3D1Ev();
extern void _ZN7S1567C3D0Ev();
extern void _ZN7S1567C42v8Ev();
extern void _ZN7S1567C42v9Ev();
extern void _ZN7S1567C43v10Ev();
extern void _ZN7S1567C43v11Ev();
extern void _ZN7S1567C43v12Ev();
extern void _ZN7S1567C43v13Ev();
extern void _ZN7S1567C43v14Ev();
extern void _ZN7S1567C43v15Ev();
extern void _ZN7S1567C43v16Ev();
extern void _ZN7S1567C43v17Ev();
extern void _ZN7S1567C43v18Ev();
extern void _ZN7S1567C43v19Ev();
extern void _ZN7S1567C43v20Ev();
extern void _ZN7S1567C43v21Ev();
extern void _ZN7S1567C43v22Ev();
extern void _ZN7S1567C43v23Ev();
extern void _ZN7S1567C43v24Ev();
extern void _ZN7S1567C43v25Ev();
extern void _ZN7S1567C43v26Ev();
extern void _ZN7S1567C43v27Ev();
extern void _ZN7S1567C43v28Ev();
extern void _ZN7S1567C43v29Ev();
extern void _ZN7S1567C43v30Ev();
extern void _ZN7S1567C43v31Ev();
extern void _ZN7S1567C43v32Ev();
extern void _ZN7S1567C43v33Ev();
extern void _ZN7S1567C43v34Ev();
extern void _ZN7S1567C43v35Ev();
extern void _ZN7S1567C43v36Ev();
extern void _ZN7S1567C43v37Ev();
extern void _ZN7S1567C43v38Ev();
extern void _ZN7S1567C43v39Ev();
extern void _ZN7S1567C43v40Ev();
extern void _ZN7S1567C43v41Ev();
extern void _ZN7S1567C43v42Ev();
extern void _ZN7S1567C43v43Ev();
extern void _ZN7S1567C43v44Ev();
extern void _ZN7S1567C43v45Ev();
extern void _ZN7S1567C43v46Ev();
extern void _ZN7S1567C43v47Ev();
extern void _ZN7S1567C43v48Ev();
extern void _ZN7S1567C43v49Ev();
extern void _ZN7S1567C43v50Ev();
extern void _ZN7S1567C43v51Ev();
extern void _ZN7S1567C43v52Ev();
extern void _ZN7S1567C43v53Ev();
extern void _ZN7S1567C43v54Ev();
extern void _ZN7S1567C43v55Ev();
extern void _ZN7S1567C43v56Ev();
extern void _ZN7S1567C43v57Ev();
extern void _ZN7S1567C43v58Ev();
extern void _ZN7S1567C43v59Ev();
extern void _ZN7S1567C43v60Ev();
extern void _ZN7S1567C43v61Ev();
extern void _ZN7S1567C43v62Ev();
extern void _ZN7S1567C43v63Ev();
extern void _ZN7S1567C43v64Ev();
extern void _ZN7S1567C43v65Ev();
extern void _ZN7S1567C43v66Ev();
extern void _ZN7S1567C43v67Ev();
extern void _ZN7S1567C43v68Ev();
extern void _ZN7S1567C43v69Ev();
extern void _ZN7S1567C43v70Ev();
extern void _ZN7S1567C43v71Ev();
extern void _ZN7S1567C33v73Ev();
extern void _ZN7S1567C33v74Ev();
extern void _ZN7S1567C33v75Ev();
extern void _ZN7S1567C33v76Ev();
extern void _ZN7S1567C63v72Ev();
static  VTBL_ENTRY vtc_S1567C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1567C3[0]),
  (VTBL_ENTRY)&_ZN7S1567C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1567C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1567C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1567C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v76Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1567C3[0]),
  (VTBL_ENTRY)&_ZN7S1567C63v72Ev,
};
extern VTBL_ENTRY _ZTI7S1567C3[];
extern  VTBL_ENTRY _ZTV7S1567C3[];
Class_Descriptor cd_S1567C3 = {  "S1567C3", // class name
  bases_S1567C3, 2,
  &(vtc_S1567C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1567C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1567C3),75, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1567C7  {
  virtual  ~S1567C7(); // _ZN7S1567C7D1Ev
  virtual void  v77(); // _ZN7S1567C73v77Ev
  virtual void  v78(); // _ZN7S1567C73v78Ev
  virtual void  v79(); // _ZN7S1567C73v79Ev
  S1567C7(); // tgen
};
//SIG(-1 S1567C7) C1{ vd v1 v2 v3}


 S1567C7 ::~S1567C7(){ note_dtor("S1567C7", this);}
void  S1567C7 ::v77(){vfunc_called(this, "_ZN7S1567C73v77Ev");}
void  S1567C7 ::v78(){vfunc_called(this, "_ZN7S1567C73v78Ev");}
void  S1567C7 ::v79(){vfunc_called(this, "_ZN7S1567C73v79Ev");}
S1567C7 ::S1567C7(){ note_ctor("S1567C7", this);} // tgen

static void Test_S1567C7()
{
  extern Class_Descriptor cd_S1567C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1567C7, buf);
    S1567C7 *dp, &lv = *(dp=new (buf) S1567C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1567C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1567C7)");
    test_class_info(&lv, &cd_S1567C7);
    dp->~S1567C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1567C7(Test_S1567C7, "S1567C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S1567C7C1Ev();
extern void _ZN7S1567C7D1Ev();
Name_Map name_map_S1567C7[] = {
  NSPAIR(_ZN7S1567C7C1Ev),
  NSPAIR(_ZN7S1567C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1567C7[];
extern void _ZN7S1567C7D1Ev();
extern void _ZN7S1567C7D0Ev();
extern void _ZN7S1567C73v77Ev();
extern void _ZN7S1567C73v78Ev();
extern void _ZN7S1567C73v79Ev();
static  VTBL_ENTRY vtc_S1567C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1567C7[0]),
  (VTBL_ENTRY)&_ZN7S1567C7D1Ev,
  (VTBL_ENTRY)&_ZN7S1567C7D0Ev,
  (VTBL_ENTRY)&_ZN7S1567C73v77Ev,
  (VTBL_ENTRY)&_ZN7S1567C73v78Ev,
  (VTBL_ENTRY)&_ZN7S1567C73v79Ev,
};
extern VTBL_ENTRY _ZTI7S1567C7[];
extern  VTBL_ENTRY _ZTV7S1567C7[];
Class_Descriptor cd_S1567C7 = {  "S1567C7", // class name
  0,0,//no base classes
  &(vtc_S1567C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S1567C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1567C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1567C2  : S1567C3 , S1567C7 {
  ::S1566C29 s1567c2f0;
  void *s1567c2f1[3];
  __tsi64 s1567c2f2;
  int s1567c2f3[12];
  void *s1567c2f4[2];
  int s1567c2f5[3];
  ::S1566C10 s1567c2f6;
  int s1567c2f7[16];
  ::S1566C22_nt s1567c2f8;
  __tsi64 s1567c2f9;
  int s1567c2f10;
  ::S1325C7_nt s1567c2f11;
  void *s1567c2f12;
  ::S1566C30 s1567c2f13;
  virtual  ~S1567C2(); // _ZN7S1567C2D1Ev
  virtual void  v80(); // _ZN7S1567C23v80Ev
  virtual void  v81(); // _ZN7S1567C23v81Ev
  virtual void  v82(); // _ZN7S1567C23v82Ev
  virtual void  v83(); // _ZN7S1567C23v83Ev
  virtual void  v84(); // _ZN7S1567C23v84Ev
  virtual void  v85(); // _ZN7S1567C23v85Ev
  virtual void  v86(); // _ZN7S1567C23v86Ev
  virtual void  v87(); // _ZN7S1567C23v87Ev
  virtual void  v88(); // _ZN7S1567C23v88Ev
  virtual void  v89(); // _ZN7S1567C23v89Ev
  virtual void  v90(); // _ZN7S1567C23v90Ev
  virtual void  v91(); // _ZN7S1567C23v91Ev
  virtual void  v92(); // _ZN7S1567C23v92Ev
  virtual void  v93(); // _ZN7S1567C23v93Ev
  virtual void  v94(); // _ZN7S1567C23v94Ev
  virtual void  v95(); // _ZN7S1567C23v95Ev
  virtual void  v96(); // _ZN7S1567C23v96Ev
  virtual void  v97(); // _ZN7S1567C23v97Ev
  virtual void  v98(); // _ZN7S1567C23v98Ev
  virtual void  v99(); // _ZN7S1567C23v99Ev
  virtual void  v100(); // _ZN7S1567C24v100Ev
  S1567C2(); // tgen
};
//SIG(-1 S1567C2) C1{ BC2{ BC3{ vd v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v86} vd v87 v88 v89 v90} BC6{ vd v91 v92 v93} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 FC7{ BC8{ m Fp Fi[2]}} Fp[3] FL Fi[12] Fp[2] Fi[3] FC9{ BC8} Fi[16] FC10{ BC11{ m FC12{ BC8} Fp Fi}} FL Fi FC13{ BC14{ BC15{ BC8}}} Fp FC16{ m Fi[5]}}


 S1567C2 ::~S1567C2(){ note_dtor("S1567C2", this);}
void  S1567C2 ::v80(){vfunc_called(this, "_ZN7S1567C23v80Ev");}
void  S1567C2 ::v81(){vfunc_called(this, "_ZN7S1567C23v81Ev");}
void  S1567C2 ::v82(){vfunc_called(this, "_ZN7S1567C23v82Ev");}
void  S1567C2 ::v83(){vfunc_called(this, "_ZN7S1567C23v83Ev");}
void  S1567C2 ::v84(){vfunc_called(this, "_ZN7S1567C23v84Ev");}
void  S1567C2 ::v85(){vfunc_called(this, "_ZN7S1567C23v85Ev");}
void  S1567C2 ::v86(){vfunc_called(this, "_ZN7S1567C23v86Ev");}
void  S1567C2 ::v87(){vfunc_called(this, "_ZN7S1567C23v87Ev");}
void  S1567C2 ::v88(){vfunc_called(this, "_ZN7S1567C23v88Ev");}
void  S1567C2 ::v89(){vfunc_called(this, "_ZN7S1567C23v89Ev");}
void  S1567C2 ::v90(){vfunc_called(this, "_ZN7S1567C23v90Ev");}
void  S1567C2 ::v91(){vfunc_called(this, "_ZN7S1567C23v91Ev");}
void  S1567C2 ::v92(){vfunc_called(this, "_ZN7S1567C23v92Ev");}
void  S1567C2 ::v93(){vfunc_called(this, "_ZN7S1567C23v93Ev");}
void  S1567C2 ::v94(){vfunc_called(this, "_ZN7S1567C23v94Ev");}
void  S1567C2 ::v95(){vfunc_called(this, "_ZN7S1567C23v95Ev");}
void  S1567C2 ::v96(){vfunc_called(this, "_ZN7S1567C23v96Ev");}
void  S1567C2 ::v97(){vfunc_called(this, "_ZN7S1567C23v97Ev");}
void  S1567C2 ::v98(){vfunc_called(this, "_ZN7S1567C23v98Ev");}
void  S1567C2 ::v99(){vfunc_called(this, "_ZN7S1567C23v99Ev");}
void  S1567C2 ::v100(){vfunc_called(this, "_ZN7S1567C24v100Ev");}
S1567C2 ::S1567C2(){ note_ctor("S1567C2", this);} // tgen

static void Test_S1567C2()
{
  extern Class_Descriptor cd_S1567C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(53,79)];
    init_test(&cd_S1567C2, buf);
    S1567C2 *dp, &lv = *(dp=new (buf) S1567C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(416,312), "sizeof(S1567C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1567C2)");
    check_base_class_offset(lv, (S1567C4*)(S1567C3*), 0, "S1567C2");
    check_base_class_offset(lv, (S1567C6*)(S1567C3*), ABISELECT(96,60), "S1567C2");
    check_base_class_offset(lv, (S1567C3*), 0, "S1567C2");
    check_base_class_offset(lv, (S1567C7*), ABISELECT(104,64), "S1567C2");
    check_field_offset(lv, s1567c2f0, ABISELECT(112,68), "S1567C2.s1567c2f0");
    check_field_offset(lv, s1567c2f1, ABISELECT(128,80), "S1567C2.s1567c2f1");
    check_field_offset(lv, s1567c2f2, ABISELECT(152,92), "S1567C2.s1567c2f2");
    check_field_offset(lv, s1567c2f3, ABISELECT(160,100), "S1567C2.s1567c2f3");
    check_field_offset(lv, s1567c2f4, ABISELECT(208,148), "S1567C2.s1567c2f4");
    check_field_offset(lv, s1567c2f5, ABISELECT(224,156), "S1567C2.s1567c2f5");
    check_field_offset(lv, s1567c2f6, ABISELECT(240,168), "S1567C2.s1567c2f6");
    check_field_offset(lv, s1567c2f7, ABISELECT(256,180), "S1567C2.s1567c2f7");
    check_field_offset(lv, s1567c2f8, ABISELECT(320,244), "S1567C2.s1567c2f8");
    check_field_offset(lv, s1567c2f9, ABISELECT(352,264), "S1567C2.s1567c2f9");
    check_field_offset(lv, s1567c2f10, ABISELECT(360,272), "S1567C2.s1567c2f10");
    check_field_offset(lv, s1567c2f11, ABISELECT(368,276), "S1567C2.s1567c2f11");
    check_field_offset(lv, s1567c2f12, ABISELECT(384,288), "S1567C2.s1567c2f12");
    check_field_offset(lv, s1567c2f13, ABISELECT(392,292), "S1567C2.s1567c2f13");
    test_class_info(&lv, &cd_S1567C2);
    dp->~S1567C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1567C2(Test_S1567C2, "S1567C2", ABISELECT(416,312));

#else // __cplusplus

extern void _ZN7S1567C2C1Ev();
extern void _ZN7S1567C2D1Ev();
Name_Map name_map_S1567C2[] = {
  NSPAIR(_ZN7S1567C2C1Ev),
  NSPAIR(_ZN7S1567C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1567C4;
extern VTBL_ENTRY _ZTI7S1567C4[];
extern  VTBL_ENTRY _ZTV7S1567C4[];
extern Class_Descriptor cd_S1567C6;
extern VTBL_ENTRY _ZTI7S1567C6[];
extern  VTBL_ENTRY _ZTV7S1567C6[];
extern Class_Descriptor cd_S1567C3;
extern VTBL_ENTRY _ZTI7S1567C3[];
extern  VTBL_ENTRY _ZTV7S1567C3[];
extern Class_Descriptor cd_S1567C7;
extern VTBL_ENTRY _ZTI7S1567C7[];
extern  VTBL_ENTRY _ZTV7S1567C7[];
static Base_Class bases_S1567C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1567C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1567C6,    ABISELECT(96,60), //bcp->offset
    93, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1567C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1567C7,    ABISELECT(104,64), //bcp->offset
    96, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1567C2[];
extern void _ZN7S1567C2D1Ev();
extern void _ZN7S1567C2D0Ev();
extern void _ZN7S1567C42v8Ev();
extern void _ZN7S1567C42v9Ev();
extern void _ZN7S1567C43v10Ev();
extern void _ZN7S1567C43v11Ev();
extern void _ZN7S1567C43v12Ev();
extern void _ZN7S1567C43v13Ev();
extern void _ZN7S1567C43v14Ev();
extern void _ZN7S1567C43v15Ev();
extern void _ZN7S1567C43v16Ev();
extern void _ZN7S1567C43v17Ev();
extern void _ZN7S1567C43v18Ev();
extern void _ZN7S1567C43v19Ev();
extern void _ZN7S1567C43v20Ev();
extern void _ZN7S1567C43v21Ev();
extern void _ZN7S1567C43v22Ev();
extern void _ZN7S1567C43v23Ev();
extern void _ZN7S1567C43v24Ev();
extern void _ZN7S1567C43v25Ev();
extern void _ZN7S1567C43v26Ev();
extern void _ZN7S1567C43v27Ev();
extern void _ZN7S1567C43v28Ev();
extern void _ZN7S1567C43v29Ev();
extern void _ZN7S1567C43v30Ev();
extern void _ZN7S1567C43v31Ev();
extern void _ZN7S1567C43v32Ev();
extern void _ZN7S1567C43v33Ev();
extern void _ZN7S1567C43v34Ev();
extern void _ZN7S1567C43v35Ev();
extern void _ZN7S1567C43v36Ev();
extern void _ZN7S1567C43v37Ev();
extern void _ZN7S1567C43v38Ev();
extern void _ZN7S1567C43v39Ev();
extern void _ZN7S1567C43v40Ev();
extern void _ZN7S1567C43v41Ev();
extern void _ZN7S1567C43v42Ev();
extern void _ZN7S1567C43v43Ev();
extern void _ZN7S1567C43v44Ev();
extern void _ZN7S1567C43v45Ev();
extern void _ZN7S1567C43v46Ev();
extern void _ZN7S1567C43v47Ev();
extern void _ZN7S1567C43v48Ev();
extern void _ZN7S1567C43v49Ev();
extern void _ZN7S1567C43v50Ev();
extern void _ZN7S1567C43v51Ev();
extern void _ZN7S1567C43v52Ev();
extern void _ZN7S1567C43v53Ev();
extern void _ZN7S1567C43v54Ev();
extern void _ZN7S1567C43v55Ev();
extern void _ZN7S1567C43v56Ev();
extern void _ZN7S1567C43v57Ev();
extern void _ZN7S1567C43v58Ev();
extern void _ZN7S1567C43v59Ev();
extern void _ZN7S1567C43v60Ev();
extern void _ZN7S1567C43v61Ev();
extern void _ZN7S1567C43v62Ev();
extern void _ZN7S1567C43v63Ev();
extern void _ZN7S1567C43v64Ev();
extern void _ZN7S1567C43v65Ev();
extern void _ZN7S1567C43v66Ev();
extern void _ZN7S1567C43v67Ev();
extern void _ZN7S1567C43v68Ev();
extern void _ZN7S1567C43v69Ev();
extern void _ZN7S1567C43v70Ev();
extern void _ZN7S1567C43v71Ev();
extern void _ZN7S1567C33v73Ev();
extern void _ZN7S1567C33v74Ev();
extern void _ZN7S1567C33v75Ev();
extern void _ZN7S1567C33v76Ev();
extern void _ZN7S1567C23v80Ev();
extern void _ZN7S1567C23v81Ev();
extern void _ZN7S1567C23v82Ev();
extern void _ZN7S1567C23v83Ev();
extern void _ZN7S1567C23v84Ev();
extern void _ZN7S1567C23v85Ev();
extern void _ZN7S1567C23v86Ev();
extern void _ZN7S1567C23v87Ev();
extern void _ZN7S1567C23v88Ev();
extern void _ZN7S1567C23v89Ev();
extern void _ZN7S1567C23v90Ev();
extern void _ZN7S1567C23v91Ev();
extern void _ZN7S1567C23v92Ev();
extern void _ZN7S1567C23v93Ev();
extern void _ZN7S1567C23v94Ev();
extern void _ZN7S1567C23v95Ev();
extern void _ZN7S1567C23v96Ev();
extern void _ZN7S1567C23v97Ev();
extern void _ZN7S1567C23v98Ev();
extern void _ZN7S1567C23v99Ev();
extern void _ZN7S1567C24v100Ev();
extern void _ZN7S1567C63v72Ev();
extern void ABISELECT(_ZThn104_N7S1567C2D1Ev,_ZThn64_N7S1567C2D1Ev)();
extern void ABISELECT(_ZThn104_N7S1567C2D0Ev,_ZThn64_N7S1567C2D0Ev)();
extern void _ZN7S1567C73v77Ev();
extern void _ZN7S1567C73v78Ev();
extern void _ZN7S1567C73v79Ev();
static  VTBL_ENTRY vtc_S1567C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1567C2[0]),
  (VTBL_ENTRY)&_ZN7S1567C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1567C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1567C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1567C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v80Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1567C24v100Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1567C2[0]),
  (VTBL_ENTRY)&_ZN7S1567C63v72Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1567C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N7S1567C2D1Ev,_ZThn64_N7S1567C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N7S1567C2D0Ev,_ZThn64_N7S1567C2D0Ev),
  (VTBL_ENTRY)&_ZN7S1567C73v77Ev,
  (VTBL_ENTRY)&_ZN7S1567C73v78Ev,
  (VTBL_ENTRY)&_ZN7S1567C73v79Ev,
};
extern VTBL_ENTRY _ZTI7S1567C2[];
extern  VTBL_ENTRY _ZTV7S1567C2[];
Class_Descriptor cd_S1567C2 = {  "S1567C2", // class name
  bases_S1567C2, 4,
  &(vtc_S1567C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(416,312), // object size
  NSPAIRA(_ZTI7S1567C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1567C2),103, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1567C1  : S1567C2 {
  int s1567c1f0[2];
  ::S1566C32 s1567c1f1;
  void *s1567c1f2;
  virtual  ~S1567C1(); // _ZN7S1567C1D1Ev
  virtual void  v1(); // _ZN7S1567C12v1Ev
  virtual void  v2(); // _ZN7S1567C12v2Ev
  virtual void  v3(); // _ZN7S1567C12v3Ev
  virtual void  v4(); // _ZN7S1567C12v4Ev
  virtual void  v5(); // _ZN7S1567C12v5Ev
  virtual void  v6(); // _ZN7S1567C12v6Ev
  virtual void  v7(); // _ZN7S1567C12v7Ev
  S1567C1(); // tgen
};
//SIG(1 S1567C1) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} BC6{ v72} vd v73 v74 v75 v76} BC7{ vd v77 v78 v79} vd v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 FC8{ BC9{ m Fp Fi[2]}} Fp[3] FL Fi[12] Fp[2] Fi[3] FC10{ BC9} Fi[16] FC11{ BC12{ m FC13{ BC9} Fp Fi}} FL Fi FC14{ BC15{ BC16{ BC9}}} Fp FC17{ m Fi[5]}} vd v1 v2 v3 v4 v5 v6 v7 Fi[2] FC18{ m FC19{ Fc[2] Fs FC20{ Fi} Fc[8]}} Fp}


 S1567C1 ::~S1567C1(){ note_dtor("S1567C1", this);}
void  S1567C1 ::v1(){vfunc_called(this, "_ZN7S1567C12v1Ev");}
void  S1567C1 ::v2(){vfunc_called(this, "_ZN7S1567C12v2Ev");}
void  S1567C1 ::v3(){vfunc_called(this, "_ZN7S1567C12v3Ev");}
void  S1567C1 ::v4(){vfunc_called(this, "_ZN7S1567C12v4Ev");}
void  S1567C1 ::v5(){vfunc_called(this, "_ZN7S1567C12v5Ev");}
void  S1567C1 ::v6(){vfunc_called(this, "_ZN7S1567C12v6Ev");}
void  S1567C1 ::v7(){vfunc_called(this, "_ZN7S1567C12v7Ev");}
S1567C1 ::S1567C1(){ note_ctor("S1567C1", this);} // tgen

static void Test_S1567C1()
{
  extern Class_Descriptor cd_S1567C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(57,86)];
    init_test(&cd_S1567C1, buf);
    S1567C1 *dp, &lv = *(dp=new (buf) S1567C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(448,340), "sizeof(S1567C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1567C1)");
    check_base_class_offset(lv, (S1567C4*)(S1567C3*)(S1567C2*), 0, "S1567C1");
    check_base_class_offset(lv, (S1567C6*)(S1567C3*)(S1567C2*), ABISELECT(96,60), "S1567C1");
    check_base_class_offset(lv, (S1567C3*)(S1567C2*), 0, "S1567C1");
    check_base_class_offset(lv, (S1567C7*)(S1567C2*), ABISELECT(104,64), "S1567C1");
    check_base_class_offset(lv, (S1567C2*), 0, "S1567C1");
    check_field_offset(lv, s1567c1f0, ABISELECT(412,312), "S1567C1.s1567c1f0");
    check_field_offset(lv, s1567c1f1, ABISELECT(420,320), "S1567C1.s1567c1f1");
    check_field_offset(lv, s1567c1f2, ABISELECT(440,336), "S1567C1.s1567c1f2");
    test_class_info(&lv, &cd_S1567C1);
    dp->~S1567C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1567C1(Test_S1567C1, "S1567C1", ABISELECT(448,340));

#else // __cplusplus

extern void _ZN7S1567C1C1Ev();
extern void _ZN7S1567C1D1Ev();
Name_Map name_map_S1567C1[] = {
  NSPAIR(_ZN7S1567C1C1Ev),
  NSPAIR(_ZN7S1567C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1567C4;
extern VTBL_ENTRY _ZTI7S1567C4[];
extern  VTBL_ENTRY _ZTV7S1567C4[];
extern Class_Descriptor cd_S1567C6;
extern VTBL_ENTRY _ZTI7S1567C6[];
extern  VTBL_ENTRY _ZTV7S1567C6[];
extern Class_Descriptor cd_S1567C3;
extern VTBL_ENTRY _ZTI7S1567C3[];
extern  VTBL_ENTRY _ZTV7S1567C3[];
extern Class_Descriptor cd_S1567C7;
extern VTBL_ENTRY _ZTI7S1567C7[];
extern  VTBL_ENTRY _ZTV7S1567C7[];
extern Class_Descriptor cd_S1567C2;
extern VTBL_ENTRY _ZTI7S1567C2[];
extern  VTBL_ENTRY _ZTV7S1567C2[];
static Base_Class bases_S1567C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1567C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1567C6,    ABISELECT(96,60), //bcp->offset
    100, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1567C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1567C7,    ABISELECT(104,64), //bcp->offset
    103, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1567C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1567C1[];
extern void _ZN7S1567C1D1Ev();
extern void _ZN7S1567C1D0Ev();
extern void _ZN7S1567C42v8Ev();
extern void _ZN7S1567C42v9Ev();
extern void _ZN7S1567C43v10Ev();
extern void _ZN7S1567C43v11Ev();
extern void _ZN7S1567C43v12Ev();
extern void _ZN7S1567C43v13Ev();
extern void _ZN7S1567C43v14Ev();
extern void _ZN7S1567C43v15Ev();
extern void _ZN7S1567C43v16Ev();
extern void _ZN7S1567C43v17Ev();
extern void _ZN7S1567C43v18Ev();
extern void _ZN7S1567C43v19Ev();
extern void _ZN7S1567C43v20Ev();
extern void _ZN7S1567C43v21Ev();
extern void _ZN7S1567C43v22Ev();
extern void _ZN7S1567C43v23Ev();
extern void _ZN7S1567C43v24Ev();
extern void _ZN7S1567C43v25Ev();
extern void _ZN7S1567C43v26Ev();
extern void _ZN7S1567C43v27Ev();
extern void _ZN7S1567C43v28Ev();
extern void _ZN7S1567C43v29Ev();
extern void _ZN7S1567C43v30Ev();
extern void _ZN7S1567C43v31Ev();
extern void _ZN7S1567C43v32Ev();
extern void _ZN7S1567C43v33Ev();
extern void _ZN7S1567C43v34Ev();
extern void _ZN7S1567C43v35Ev();
extern void _ZN7S1567C43v36Ev();
extern void _ZN7S1567C43v37Ev();
extern void _ZN7S1567C43v38Ev();
extern void _ZN7S1567C43v39Ev();
extern void _ZN7S1567C43v40Ev();
extern void _ZN7S1567C43v41Ev();
extern void _ZN7S1567C43v42Ev();
extern void _ZN7S1567C43v43Ev();
extern void _ZN7S1567C43v44Ev();
extern void _ZN7S1567C43v45Ev();
extern void _ZN7S1567C43v46Ev();
extern void _ZN7S1567C43v47Ev();
extern void _ZN7S1567C43v48Ev();
extern void _ZN7S1567C43v49Ev();
extern void _ZN7S1567C43v50Ev();
extern void _ZN7S1567C43v51Ev();
extern void _ZN7S1567C43v52Ev();
extern void _ZN7S1567C43v53Ev();
extern void _ZN7S1567C43v54Ev();
extern void _ZN7S1567C43v55Ev();
extern void _ZN7S1567C43v56Ev();
extern void _ZN7S1567C43v57Ev();
extern void _ZN7S1567C43v58Ev();
extern void _ZN7S1567C43v59Ev();
extern void _ZN7S1567C43v60Ev();
extern void _ZN7S1567C43v61Ev();
extern void _ZN7S1567C43v62Ev();
extern void _ZN7S1567C43v63Ev();
extern void _ZN7S1567C43v64Ev();
extern void _ZN7S1567C43v65Ev();
extern void _ZN7S1567C43v66Ev();
extern void _ZN7S1567C43v67Ev();
extern void _ZN7S1567C43v68Ev();
extern void _ZN7S1567C43v69Ev();
extern void _ZN7S1567C43v70Ev();
extern void _ZN7S1567C43v71Ev();
extern void _ZN7S1567C33v73Ev();
extern void _ZN7S1567C33v74Ev();
extern void _ZN7S1567C33v75Ev();
extern void _ZN7S1567C33v76Ev();
extern void _ZN7S1567C23v80Ev();
extern void _ZN7S1567C23v81Ev();
extern void _ZN7S1567C23v82Ev();
extern void _ZN7S1567C23v83Ev();
extern void _ZN7S1567C23v84Ev();
extern void _ZN7S1567C23v85Ev();
extern void _ZN7S1567C23v86Ev();
extern void _ZN7S1567C23v87Ev();
extern void _ZN7S1567C23v88Ev();
extern void _ZN7S1567C23v89Ev();
extern void _ZN7S1567C23v90Ev();
extern void _ZN7S1567C23v91Ev();
extern void _ZN7S1567C23v92Ev();
extern void _ZN7S1567C23v93Ev();
extern void _ZN7S1567C23v94Ev();
extern void _ZN7S1567C23v95Ev();
extern void _ZN7S1567C23v96Ev();
extern void _ZN7S1567C23v97Ev();
extern void _ZN7S1567C23v98Ev();
extern void _ZN7S1567C23v99Ev();
extern void _ZN7S1567C24v100Ev();
extern void _ZN7S1567C12v1Ev();
extern void _ZN7S1567C12v2Ev();
extern void _ZN7S1567C12v3Ev();
extern void _ZN7S1567C12v4Ev();
extern void _ZN7S1567C12v5Ev();
extern void _ZN7S1567C12v6Ev();
extern void _ZN7S1567C12v7Ev();
extern void _ZN7S1567C63v72Ev();
extern void ABISELECT(_ZThn104_N7S1567C1D1Ev,_ZThn64_N7S1567C1D1Ev)();
extern void ABISELECT(_ZThn104_N7S1567C1D0Ev,_ZThn64_N7S1567C1D0Ev)();
extern void _ZN7S1567C73v77Ev();
extern void _ZN7S1567C73v78Ev();
extern void _ZN7S1567C73v79Ev();
static  VTBL_ENTRY vtc_S1567C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1567C1[0]),
  (VTBL_ENTRY)&_ZN7S1567C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1567C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1567C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1567C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1567C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1567C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v80Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1567C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1567C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1567C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1567C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1567C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1567C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1567C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1567C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1567C12v7Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S1567C1[0]),
  (VTBL_ENTRY)&_ZN7S1567C63v72Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S1567C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N7S1567C1D1Ev,_ZThn64_N7S1567C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N7S1567C1D0Ev,_ZThn64_N7S1567C1D0Ev),
  (VTBL_ENTRY)&_ZN7S1567C73v77Ev,
  (VTBL_ENTRY)&_ZN7S1567C73v78Ev,
  (VTBL_ENTRY)&_ZN7S1567C73v79Ev,
};
extern VTBL_ENTRY _ZTI7S1567C1[];
extern  VTBL_ENTRY _ZTV7S1567C1[];
Class_Descriptor cd_S1567C1 = {  "S1567C1", // class name
  bases_S1567C1, 5,
  &(vtc_S1567C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(448,340), // object size
  NSPAIRA(_ZTI7S1567C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1567C1),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3010C3  {
  int s3010c3f0;
  __tsi64 s3010c3f1;
  void *s3010c3f2[4];
  int s3010c3f3[2];
  void *s3010c3f4;
  ::S1566C14_nt s3010c3f5;
  void *s3010c3f6[2];
  virtual  ~S3010C3(); // _ZN7S3010C3D1Ev
  virtual void  v10(); // _ZN7S3010C33v10Ev
  virtual void  v11(); // _ZN7S3010C33v11Ev
  virtual void  v12(); // _ZN7S3010C33v12Ev
  virtual void  v13(); // _ZN7S3010C33v13Ev
  virtual void  v14(); // _ZN7S3010C33v14Ev
  virtual void  v15(); // _ZN7S3010C33v15Ev
  virtual void  v16(); // _ZN7S3010C33v16Ev
  virtual void  v17(); // _ZN7S3010C33v17Ev
  virtual void  v18(); // _ZN7S3010C33v18Ev
  virtual void  v19(); // _ZN7S3010C33v19Ev
  virtual void  v20(); // _ZN7S3010C33v20Ev
  virtual void  v21(); // _ZN7S3010C33v21Ev
  virtual void  v22(); // _ZN7S3010C33v22Ev
  virtual void  v23(); // _ZN7S3010C33v23Ev
  virtual void  v24(); // _ZN7S3010C33v24Ev
  virtual void  v25(); // _ZN7S3010C33v25Ev
  virtual void  v26(); // _ZN7S3010C33v26Ev
  virtual void  v27(); // _ZN7S3010C33v27Ev
  virtual void  v28(); // _ZN7S3010C33v28Ev
  virtual void  v29(); // _ZN7S3010C33v29Ev
  virtual void  v30(); // _ZN7S3010C33v30Ev
  virtual void  v31(); // _ZN7S3010C33v31Ev
  virtual void  v32(); // _ZN7S3010C33v32Ev
  virtual void  v33(); // _ZN7S3010C33v33Ev
  virtual void  v34(); // _ZN7S3010C33v34Ev
  virtual void  v35(); // _ZN7S3010C33v35Ev
  virtual void  v36(); // _ZN7S3010C33v36Ev
  virtual void  v37(); // _ZN7S3010C33v37Ev
  virtual void  v38(); // _ZN7S3010C33v38Ev
  virtual void  v39(); // _ZN7S3010C33v39Ev
  virtual void  v40(); // _ZN7S3010C33v40Ev
  virtual void  v41(); // _ZN7S3010C33v41Ev
  virtual void  v42(); // _ZN7S3010C33v42Ev
  virtual void  v43(); // _ZN7S3010C33v43Ev
  virtual void  v44(); // _ZN7S3010C33v44Ev
  virtual void  v45(); // _ZN7S3010C33v45Ev
  virtual void  v46(); // _ZN7S3010C33v46Ev
  virtual void  v47(); // _ZN7S3010C33v47Ev
  virtual void  v48(); // _ZN7S3010C33v48Ev
  virtual void  v49(); // _ZN7S3010C33v49Ev
  virtual void  v50(); // _ZN7S3010C33v50Ev
  virtual void  v51(); // _ZN7S3010C33v51Ev
  virtual void  v52(); // _ZN7S3010C33v52Ev
  virtual void  v53(); // _ZN7S3010C33v53Ev
  virtual void  v54(); // _ZN7S3010C33v54Ev
  virtual void  v55(); // _ZN7S3010C33v55Ev
  virtual void  v56(); // _ZN7S3010C33v56Ev
  virtual void  v57(); // _ZN7S3010C33v57Ev
  virtual void  v58(); // _ZN7S3010C33v58Ev
  virtual void  v59(); // _ZN7S3010C33v59Ev
  virtual void  v60(); // _ZN7S3010C33v60Ev
  virtual void  v61(); // _ZN7S3010C33v61Ev
  virtual void  v62(); // _ZN7S3010C33v62Ev
  virtual void  v63(); // _ZN7S3010C33v63Ev
  virtual void  v64(); // _ZN7S3010C33v64Ev
  virtual void  v65(); // _ZN7S3010C33v65Ev
  virtual void  v66(); // _ZN7S3010C33v66Ev
  virtual void  v67(); // _ZN7S3010C33v67Ev
  virtual void  v68(); // _ZN7S3010C33v68Ev
  virtual void  v69(); // _ZN7S3010C33v69Ev
  virtual void  v70(); // _ZN7S3010C33v70Ev
  virtual void  v71(); // _ZN7S3010C33v71Ev
  virtual void  v72(); // _ZN7S3010C33v72Ev
  virtual void  v73(); // _ZN7S3010C33v73Ev
  S3010C3(); // tgen
};
//SIG(-1 S3010C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3010C3 ::~S3010C3(){ note_dtor("S3010C3", this);}
void  S3010C3 ::v10(){vfunc_called(this, "_ZN7S3010C33v10Ev");}
void  S3010C3 ::v11(){vfunc_called(this, "_ZN7S3010C33v11Ev");}
void  S3010C3 ::v12(){vfunc_called(this, "_ZN7S3010C33v12Ev");}
void  S3010C3 ::v13(){vfunc_called(this, "_ZN7S3010C33v13Ev");}
void  S3010C3 ::v14(){vfunc_called(this, "_ZN7S3010C33v14Ev");}
void  S3010C3 ::v15(){vfunc_called(this, "_ZN7S3010C33v15Ev");}
void  S3010C3 ::v16(){vfunc_called(this, "_ZN7S3010C33v16Ev");}
void  S3010C3 ::v17(){vfunc_called(this, "_ZN7S3010C33v17Ev");}
void  S3010C3 ::v18(){vfunc_called(this, "_ZN7S3010C33v18Ev");}
void  S3010C3 ::v19(){vfunc_called(this, "_ZN7S3010C33v19Ev");}
void  S3010C3 ::v20(){vfunc_called(this, "_ZN7S3010C33v20Ev");}
void  S3010C3 ::v21(){vfunc_called(this, "_ZN7S3010C33v21Ev");}
void  S3010C3 ::v22(){vfunc_called(this, "_ZN7S3010C33v22Ev");}
void  S3010C3 ::v23(){vfunc_called(this, "_ZN7S3010C33v23Ev");}
void  S3010C3 ::v24(){vfunc_called(this, "_ZN7S3010C33v24Ev");}
void  S3010C3 ::v25(){vfunc_called(this, "_ZN7S3010C33v25Ev");}
void  S3010C3 ::v26(){vfunc_called(this, "_ZN7S3010C33v26Ev");}
void  S3010C3 ::v27(){vfunc_called(this, "_ZN7S3010C33v27Ev");}
void  S3010C3 ::v28(){vfunc_called(this, "_ZN7S3010C33v28Ev");}
void  S3010C3 ::v29(){vfunc_called(this, "_ZN7S3010C33v29Ev");}
void  S3010C3 ::v30(){vfunc_called(this, "_ZN7S3010C33v30Ev");}
void  S3010C3 ::v31(){vfunc_called(this, "_ZN7S3010C33v31Ev");}
void  S3010C3 ::v32(){vfunc_called(this, "_ZN7S3010C33v32Ev");}
void  S3010C3 ::v33(){vfunc_called(this, "_ZN7S3010C33v33Ev");}
void  S3010C3 ::v34(){vfunc_called(this, "_ZN7S3010C33v34Ev");}
void  S3010C3 ::v35(){vfunc_called(this, "_ZN7S3010C33v35Ev");}
void  S3010C3 ::v36(){vfunc_called(this, "_ZN7S3010C33v36Ev");}
void  S3010C3 ::v37(){vfunc_called(this, "_ZN7S3010C33v37Ev");}
void  S3010C3 ::v38(){vfunc_called(this, "_ZN7S3010C33v38Ev");}
void  S3010C3 ::v39(){vfunc_called(this, "_ZN7S3010C33v39Ev");}
void  S3010C3 ::v40(){vfunc_called(this, "_ZN7S3010C33v40Ev");}
void  S3010C3 ::v41(){vfunc_called(this, "_ZN7S3010C33v41Ev");}
void  S3010C3 ::v42(){vfunc_called(this, "_ZN7S3010C33v42Ev");}
void  S3010C3 ::v43(){vfunc_called(this, "_ZN7S3010C33v43Ev");}
void  S3010C3 ::v44(){vfunc_called(this, "_ZN7S3010C33v44Ev");}
void  S3010C3 ::v45(){vfunc_called(this, "_ZN7S3010C33v45Ev");}
void  S3010C3 ::v46(){vfunc_called(this, "_ZN7S3010C33v46Ev");}
void  S3010C3 ::v47(){vfunc_called(this, "_ZN7S3010C33v47Ev");}
void  S3010C3 ::v48(){vfunc_called(this, "_ZN7S3010C33v48Ev");}
void  S3010C3 ::v49(){vfunc_called(this, "_ZN7S3010C33v49Ev");}
void  S3010C3 ::v50(){vfunc_called(this, "_ZN7S3010C33v50Ev");}
void  S3010C3 ::v51(){vfunc_called(this, "_ZN7S3010C33v51Ev");}
void  S3010C3 ::v52(){vfunc_called(this, "_ZN7S3010C33v52Ev");}
void  S3010C3 ::v53(){vfunc_called(this, "_ZN7S3010C33v53Ev");}
void  S3010C3 ::v54(){vfunc_called(this, "_ZN7S3010C33v54Ev");}
void  S3010C3 ::v55(){vfunc_called(this, "_ZN7S3010C33v55Ev");}
void  S3010C3 ::v56(){vfunc_called(this, "_ZN7S3010C33v56Ev");}
void  S3010C3 ::v57(){vfunc_called(this, "_ZN7S3010C33v57Ev");}
void  S3010C3 ::v58(){vfunc_called(this, "_ZN7S3010C33v58Ev");}
void  S3010C3 ::v59(){vfunc_called(this, "_ZN7S3010C33v59Ev");}
void  S3010C3 ::v60(){vfunc_called(this, "_ZN7S3010C33v60Ev");}
void  S3010C3 ::v61(){vfunc_called(this, "_ZN7S3010C33v61Ev");}
void  S3010C3 ::v62(){vfunc_called(this, "_ZN7S3010C33v62Ev");}
void  S3010C3 ::v63(){vfunc_called(this, "_ZN7S3010C33v63Ev");}
void  S3010C3 ::v64(){vfunc_called(this, "_ZN7S3010C33v64Ev");}
void  S3010C3 ::v65(){vfunc_called(this, "_ZN7S3010C33v65Ev");}
void  S3010C3 ::v66(){vfunc_called(this, "_ZN7S3010C33v66Ev");}
void  S3010C3 ::v67(){vfunc_called(this, "_ZN7S3010C33v67Ev");}
void  S3010C3 ::v68(){vfunc_called(this, "_ZN7S3010C33v68Ev");}
void  S3010C3 ::v69(){vfunc_called(this, "_ZN7S3010C33v69Ev");}
void  S3010C3 ::v70(){vfunc_called(this, "_ZN7S3010C33v70Ev");}
void  S3010C3 ::v71(){vfunc_called(this, "_ZN7S3010C33v71Ev");}
void  S3010C3 ::v72(){vfunc_called(this, "_ZN7S3010C33v72Ev");}
void  S3010C3 ::v73(){vfunc_called(this, "_ZN7S3010C33v73Ev");}
S3010C3 ::S3010C3(){ note_ctor("S3010C3", this);} // tgen

static void Test_S3010C3()
{
  extern Class_Descriptor cd_S3010C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S3010C3, buf);
    S3010C3 *dp, &lv = *(dp=new (buf) S3010C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S3010C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3010C3)");
    check_field_offset(lv, s3010c3f0, ABISELECT(8,4), "S3010C3.s3010c3f0");
    check_field_offset(lv, s3010c3f1, ABISELECT(16,8), "S3010C3.s3010c3f1");
    check_field_offset(lv, s3010c3f2, ABISELECT(24,16), "S3010C3.s3010c3f2");
    check_field_offset(lv, s3010c3f3, ABISELECT(56,32), "S3010C3.s3010c3f3");
    check_field_offset(lv, s3010c3f4, ABISELECT(64,40), "S3010C3.s3010c3f4");
    check_field_offset(lv, s3010c3f5, ABISELECT(72,44), "S3010C3.s3010c3f5");
    check_field_offset(lv, s3010c3f6, ABISELECT(80,52), "S3010C3.s3010c3f6");
    test_class_info(&lv, &cd_S3010C3);
    dp->~S3010C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3010C3(Test_S3010C3, "S3010C3", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S3010C3C1Ev();
extern void _ZN7S3010C3D1Ev();
Name_Map name_map_S3010C3[] = {
  NSPAIR(_ZN7S3010C3C1Ev),
  NSPAIR(_ZN7S3010C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3010C3[];
extern void _ZN7S3010C3D1Ev();
extern void _ZN7S3010C3D0Ev();
extern void _ZN7S3010C33v10Ev();
extern void _ZN7S3010C33v11Ev();
extern void _ZN7S3010C33v12Ev();
extern void _ZN7S3010C33v13Ev();
extern void _ZN7S3010C33v14Ev();
extern void _ZN7S3010C33v15Ev();
extern void _ZN7S3010C33v16Ev();
extern void _ZN7S3010C33v17Ev();
extern void _ZN7S3010C33v18Ev();
extern void _ZN7S3010C33v19Ev();
extern void _ZN7S3010C33v20Ev();
extern void _ZN7S3010C33v21Ev();
extern void _ZN7S3010C33v22Ev();
extern void _ZN7S3010C33v23Ev();
extern void _ZN7S3010C33v24Ev();
extern void _ZN7S3010C33v25Ev();
extern void _ZN7S3010C33v26Ev();
extern void _ZN7S3010C33v27Ev();
extern void _ZN7S3010C33v28Ev();
extern void _ZN7S3010C33v29Ev();
extern void _ZN7S3010C33v30Ev();
extern void _ZN7S3010C33v31Ev();
extern void _ZN7S3010C33v32Ev();
extern void _ZN7S3010C33v33Ev();
extern void _ZN7S3010C33v34Ev();
extern void _ZN7S3010C33v35Ev();
extern void _ZN7S3010C33v36Ev();
extern void _ZN7S3010C33v37Ev();
extern void _ZN7S3010C33v38Ev();
extern void _ZN7S3010C33v39Ev();
extern void _ZN7S3010C33v40Ev();
extern void _ZN7S3010C33v41Ev();
extern void _ZN7S3010C33v42Ev();
extern void _ZN7S3010C33v43Ev();
extern void _ZN7S3010C33v44Ev();
extern void _ZN7S3010C33v45Ev();
extern void _ZN7S3010C33v46Ev();
extern void _ZN7S3010C33v47Ev();
extern void _ZN7S3010C33v48Ev();
extern void _ZN7S3010C33v49Ev();
extern void _ZN7S3010C33v50Ev();
extern void _ZN7S3010C33v51Ev();
extern void _ZN7S3010C33v52Ev();
extern void _ZN7S3010C33v53Ev();
extern void _ZN7S3010C33v54Ev();
extern void _ZN7S3010C33v55Ev();
extern void _ZN7S3010C33v56Ev();
extern void _ZN7S3010C33v57Ev();
extern void _ZN7S3010C33v58Ev();
extern void _ZN7S3010C33v59Ev();
extern void _ZN7S3010C33v60Ev();
extern void _ZN7S3010C33v61Ev();
extern void _ZN7S3010C33v62Ev();
extern void _ZN7S3010C33v63Ev();
extern void _ZN7S3010C33v64Ev();
extern void _ZN7S3010C33v65Ev();
extern void _ZN7S3010C33v66Ev();
extern void _ZN7S3010C33v67Ev();
extern void _ZN7S3010C33v68Ev();
extern void _ZN7S3010C33v69Ev();
extern void _ZN7S3010C33v70Ev();
extern void _ZN7S3010C33v71Ev();
extern void _ZN7S3010C33v72Ev();
extern void _ZN7S3010C33v73Ev();
static  VTBL_ENTRY vtc_S3010C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3010C3[0]),
  (VTBL_ENTRY)&_ZN7S3010C3D1Ev,
  (VTBL_ENTRY)&_ZN7S3010C3D0Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v15Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v16Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v17Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v73Ev,
};
extern VTBL_ENTRY _ZTI7S3010C3[];
extern  VTBL_ENTRY _ZTV7S3010C3[];
Class_Descriptor cd_S3010C3 = {  "S3010C3", // class name
  0,0,//no base classes
  &(vtc_S3010C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S3010C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3010C3),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3010C5  {
  virtual void  v74(); // _ZN7S3010C53v74Ev
  ~S3010C5(); // tgen
  S3010C5(); // tgen
};
//SIG(-1 S3010C5) C1{ v1}


void  S3010C5 ::v74(){vfunc_called(this, "_ZN7S3010C53v74Ev");}
S3010C5 ::~S3010C5(){ note_dtor("S3010C5", this);} // tgen
S3010C5 ::S3010C5(){ note_ctor("S3010C5", this);} // tgen

static void Test_S3010C5()
{
  extern Class_Descriptor cd_S3010C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S3010C5, buf);
    S3010C5 *dp, &lv = *(dp=new (buf) S3010C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S3010C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3010C5)");
    test_class_info(&lv, &cd_S3010C5);
    dp->~S3010C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3010C5(Test_S3010C5, "S3010C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S3010C5C1Ev();
extern void _ZN7S3010C5D1Ev();
Name_Map name_map_S3010C5[] = {
  NSPAIR(_ZN7S3010C5C1Ev),
  NSPAIR(_ZN7S3010C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S3010C5[];
extern void _ZN7S3010C53v74Ev();
static  VTBL_ENTRY vtc_S3010C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3010C5[0]),
  (VTBL_ENTRY)&_ZN7S3010C53v74Ev,
};
extern VTBL_ENTRY _ZTI7S3010C5[];
extern  VTBL_ENTRY _ZTV7S3010C5[];
Class_Descriptor cd_S3010C5 = {  "S3010C5", // class name
  0,0,//no base classes
  &(vtc_S3010C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S3010C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S3010C5),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3010C2  : S3010C3 , S3010C5 {
  void *s3010c2f0;
  int s3010c2f1[7];
  virtual  ~S3010C2(); // _ZN7S3010C2D1Ev
  virtual void  v75(); // _ZN7S3010C23v75Ev
  virtual void  v76(); // _ZN7S3010C23v76Ev
  virtual void  v77(); // _ZN7S3010C23v77Ev
  virtual void  v78(); // _ZN7S3010C23v78Ev
  S3010C2(); // tgen
};
//SIG(-1 S3010C2) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} BC4{ v69} vd v1 v2 v3 v4 Fp Fi[7]}


 S3010C2 ::~S3010C2(){ note_dtor("S3010C2", this);}
void  S3010C2 ::v75(){vfunc_called(this, "_ZN7S3010C23v75Ev");}
void  S3010C2 ::v76(){vfunc_called(this, "_ZN7S3010C23v76Ev");}
void  S3010C2 ::v77(){vfunc_called(this, "_ZN7S3010C23v77Ev");}
void  S3010C2 ::v78(){vfunc_called(this, "_ZN7S3010C23v78Ev");}
S3010C2 ::S3010C2(){ note_ctor("S3010C2", this);} // tgen

static void Test_S3010C2()
{
  extern Class_Descriptor cd_S3010C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,25)];
    init_test(&cd_S3010C2, buf);
    S3010C2 *dp, &lv = *(dp=new (buf) S3010C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,96), "sizeof(S3010C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3010C2)");
    check_base_class_offset(lv, (S3010C3*), 0, "S3010C2");
    check_base_class_offset(lv, (S3010C5*), ABISELECT(96,60), "S3010C2");
    check_field_offset(lv, s3010c2f0, ABISELECT(104,64), "S3010C2.s3010c2f0");
    check_field_offset(lv, s3010c2f1, ABISELECT(112,68), "S3010C2.s3010c2f1");
    test_class_info(&lv, &cd_S3010C2);
    dp->~S3010C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3010C2(Test_S3010C2, "S3010C2", ABISELECT(144,96));

#else // __cplusplus

extern void _ZN7S3010C2C1Ev();
extern void _ZN7S3010C2D1Ev();
Name_Map name_map_S3010C2[] = {
  NSPAIR(_ZN7S3010C2C1Ev),
  NSPAIR(_ZN7S3010C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3010C3;
extern VTBL_ENTRY _ZTI7S3010C3[];
extern  VTBL_ENTRY _ZTV7S3010C3[];
extern Class_Descriptor cd_S3010C5;
extern VTBL_ENTRY _ZTI7S3010C5[];
extern  VTBL_ENTRY _ZTV7S3010C5[];
static Base_Class bases_S3010C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3010C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3010C5,    ABISELECT(96,60), //bcp->offset
    72, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3010C2[];
extern void _ZN7S3010C2D1Ev();
extern void _ZN7S3010C2D0Ev();
extern void _ZN7S3010C33v10Ev();
extern void _ZN7S3010C33v11Ev();
extern void _ZN7S3010C33v12Ev();
extern void _ZN7S3010C33v13Ev();
extern void _ZN7S3010C33v14Ev();
extern void _ZN7S3010C33v15Ev();
extern void _ZN7S3010C33v16Ev();
extern void _ZN7S3010C33v17Ev();
extern void _ZN7S3010C33v18Ev();
extern void _ZN7S3010C33v19Ev();
extern void _ZN7S3010C33v20Ev();
extern void _ZN7S3010C33v21Ev();
extern void _ZN7S3010C33v22Ev();
extern void _ZN7S3010C33v23Ev();
extern void _ZN7S3010C33v24Ev();
extern void _ZN7S3010C33v25Ev();
extern void _ZN7S3010C33v26Ev();
extern void _ZN7S3010C33v27Ev();
extern void _ZN7S3010C33v28Ev();
extern void _ZN7S3010C33v29Ev();
extern void _ZN7S3010C33v30Ev();
extern void _ZN7S3010C33v31Ev();
extern void _ZN7S3010C33v32Ev();
extern void _ZN7S3010C33v33Ev();
extern void _ZN7S3010C33v34Ev();
extern void _ZN7S3010C33v35Ev();
extern void _ZN7S3010C33v36Ev();
extern void _ZN7S3010C33v37Ev();
extern void _ZN7S3010C33v38Ev();
extern void _ZN7S3010C33v39Ev();
extern void _ZN7S3010C33v40Ev();
extern void _ZN7S3010C33v41Ev();
extern void _ZN7S3010C33v42Ev();
extern void _ZN7S3010C33v43Ev();
extern void _ZN7S3010C33v44Ev();
extern void _ZN7S3010C33v45Ev();
extern void _ZN7S3010C33v46Ev();
extern void _ZN7S3010C33v47Ev();
extern void _ZN7S3010C33v48Ev();
extern void _ZN7S3010C33v49Ev();
extern void _ZN7S3010C33v50Ev();
extern void _ZN7S3010C33v51Ev();
extern void _ZN7S3010C33v52Ev();
extern void _ZN7S3010C33v53Ev();
extern void _ZN7S3010C33v54Ev();
extern void _ZN7S3010C33v55Ev();
extern void _ZN7S3010C33v56Ev();
extern void _ZN7S3010C33v57Ev();
extern void _ZN7S3010C33v58Ev();
extern void _ZN7S3010C33v59Ev();
extern void _ZN7S3010C33v60Ev();
extern void _ZN7S3010C33v61Ev();
extern void _ZN7S3010C33v62Ev();
extern void _ZN7S3010C33v63Ev();
extern void _ZN7S3010C33v64Ev();
extern void _ZN7S3010C33v65Ev();
extern void _ZN7S3010C33v66Ev();
extern void _ZN7S3010C33v67Ev();
extern void _ZN7S3010C33v68Ev();
extern void _ZN7S3010C33v69Ev();
extern void _ZN7S3010C33v70Ev();
extern void _ZN7S3010C33v71Ev();
extern void _ZN7S3010C33v72Ev();
extern void _ZN7S3010C33v73Ev();
extern void _ZN7S3010C23v75Ev();
extern void _ZN7S3010C23v76Ev();
extern void _ZN7S3010C23v77Ev();
extern void _ZN7S3010C23v78Ev();
extern void _ZN7S3010C53v74Ev();
static  VTBL_ENTRY vtc_S3010C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3010C2[0]),
  (VTBL_ENTRY)&_ZN7S3010C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3010C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v15Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v16Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v17Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3010C23v75Ev,
  (VTBL_ENTRY)&_ZN7S3010C23v76Ev,
  (VTBL_ENTRY)&_ZN7S3010C23v77Ev,
  (VTBL_ENTRY)&_ZN7S3010C23v78Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S3010C2[0]),
  (VTBL_ENTRY)&_ZN7S3010C53v74Ev,
};
extern VTBL_ENTRY _ZTI7S3010C2[];
extern  VTBL_ENTRY _ZTV7S3010C2[];
Class_Descriptor cd_S3010C2 = {  "S3010C2", // class name
  bases_S3010C2, 2,
  &(vtc_S3010C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,96), // object size
  NSPAIRA(_ZTI7S3010C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S3010C2),75, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3010C10_nt  {
  void *s3010c10f0[2];
  void  mf3010c10(); // _ZN11S3010C10_nt9mf3010c10Ev
};
//SIG(-1 S3010C10_nt) C1{ m Fp[2]}


void  S3010C10_nt ::mf3010c10(){}

//skip512 S3010C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3010C13_nt  {
  unsigned int s3010c13f0:1;
  unsigned int s3010c13f1:1;
  unsigned int s3010c13f2:1;
  unsigned int s3010c13f3:1;
  int s3010c13f4[6];
  ::S1325C18_nt s3010c13f5;
  char s3010c13f6;
  int s3010c13f7[2];
  ::S1537C14_nt s3010c13f8;
  int s3010c13f9[3];
  unsigned int s3010c13f10:1;
  int s3010c13f11[4];
  ::S1537C14_nt s3010c13f12;
  ::S1537C14_nt s3010c13f13;
  ::S1537C14_nt s3010c13f14;
  int s3010c13f15;
  void  mf3010c13(); // _ZN11S3010C13_nt9mf3010c13Ev
};
//SIG(-1 S3010C13_nt) C1{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC2{ m} Fc Fi[2] FC3{ m Fi[3]} Fi[3] Fi:1 Fi[4] FC3 FC3 FC3 Fi}


void  S3010C13_nt ::mf3010c13(){}

//skip512 S3010C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3010C12  {
  ::S3010C13_nt s3010c12f0;
  void *s3010c12f1;
  int s3010c12f2[2];
};
//SIG(-1 S3010C12) C1{ FC2{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC3{ m} Fc Fi[2] FC4{ m Fi[3]} Fi[3] Fi:1 Fi[4] FC4 FC4 FC4 Fi} Fp Fi[2]}



static void Test_S3010C12()
{
  {
    init_simple_test("S3010C12");
    static S3010C12 lv;
    check2(sizeof(lv), ABISELECT(144,136), "sizeof(S3010C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3010C12)");
    check_field_offset(lv, s3010c12f0, 0, "S3010C12.s3010c12f0");
    check_field_offset(lv, s3010c12f1, ABISELECT(128,124), "S3010C12.s3010c12f1");
    check_field_offset(lv, s3010c12f2, ABISELECT(136,128), "S3010C12.s3010c12f2");
  }
}
static Arrange_To_Call_Me vS3010C12(Test_S3010C12, "S3010C12", ABISELECT(144,136));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3010C1  : S3010C2 {
  int s3010c1f0;
  void *s3010c1f1;
  ::S1537C5_nt s3010c1f2;
  ::S1537C5_nt s3010c1f3;
  void *s3010c1f4;
  ::S1566C9 s3010c1f5;
  void *s3010c1f6;
  ::S3010C10_nt s3010c1f7;
  ::S1537C14_nt s3010c1f8;
  ::S3010C12 s3010c1f9;
  unsigned int s3010c1f10:1;
  ::S3010C13_nt s3010c1f11;
  int s3010c1f12;
  unsigned int s3010c1f13:1;
  virtual  ~S3010C1(); // _ZN7S3010C1D1Ev
  virtual void  v1(); // _ZN7S3010C12v1Ev
  virtual void  v2(); // _ZN7S3010C12v2Ev
  virtual void  v3(); // _ZN7S3010C12v3Ev
  virtual void  v4(); // _ZN7S3010C12v4Ev
  virtual void  v5(); // _ZN7S3010C12v5Ev
  virtual void  v6(); // _ZN7S3010C12v6Ev
  virtual void  v7(); // _ZN7S3010C12v7Ev
  virtual void  v8(); // _ZN7S3010C12v8Ev
  virtual void  v9(); // _ZN7S3010C12v9Ev
  S3010C1(); // tgen
};
//SIG(1 S3010C1) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} BC5{ v74} vd v75 v76 v77 v78 Fp Fi[7]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fi Fp FC6{ m Fi[2]} FC6 Fp FC7{ BC8{ BC9{ m Fp Fi[2]}}} Fp FC10{ m Fp[2]} FC11{ m Fi[3]} FC12{ FC13{ m Fi:1 Fi:1 Fi:1 Fi:1 Fi[6] FC14{ m} Fc Fi[2] FC11 Fi[3] Fi:1 Fi[4] FC11 FC11 FC11 Fi} Fp Fi[2]} Fi:1 FC13 Fi Fi:1}


 S3010C1 ::~S3010C1(){ note_dtor("S3010C1", this);}
void  S3010C1 ::v1(){vfunc_called(this, "_ZN7S3010C12v1Ev");}
void  S3010C1 ::v2(){vfunc_called(this, "_ZN7S3010C12v2Ev");}
void  S3010C1 ::v3(){vfunc_called(this, "_ZN7S3010C12v3Ev");}
void  S3010C1 ::v4(){vfunc_called(this, "_ZN7S3010C12v4Ev");}
void  S3010C1 ::v5(){vfunc_called(this, "_ZN7S3010C12v5Ev");}
void  S3010C1 ::v6(){vfunc_called(this, "_ZN7S3010C12v6Ev");}
void  S3010C1 ::v7(){vfunc_called(this, "_ZN7S3010C12v7Ev");}
void  S3010C1 ::v8(){vfunc_called(this, "_ZN7S3010C12v8Ev");}
void  S3010C1 ::v9(){vfunc_called(this, "_ZN7S3010C12v9Ev");}
S3010C1 ::S3010C1(){ note_ctor("S3010C1", this);} // tgen

static void Test_S3010C1()
{
  extern Class_Descriptor cd_S3010C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(65,109)];
    init_test(&cd_S3010C1, buf);
    S3010C1 *dp, &lv = *(dp=new (buf) S3010C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(512,432), "sizeof(S3010C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3010C1)");
    check_base_class_offset(lv, (S3010C3*)(S3010C2*), 0, "S3010C1");
    check_base_class_offset(lv, (S3010C5*)(S3010C2*), ABISELECT(96,60), "S3010C1");
    check_base_class_offset(lv, (S3010C2*), 0, "S3010C1");
    check_field_offset(lv, s3010c1f0, ABISELECT(140,96), "S3010C1.s3010c1f0");
    check_field_offset(lv, s3010c1f1, ABISELECT(144,100), "S3010C1.s3010c1f1");
    check_field_offset(lv, s3010c1f2, ABISELECT(152,104), "S3010C1.s3010c1f2");
    check_field_offset(lv, s3010c1f3, ABISELECT(160,112), "S3010C1.s3010c1f3");
    check_field_offset(lv, s3010c1f4, ABISELECT(168,120), "S3010C1.s3010c1f4");
    check_field_offset(lv, s3010c1f5, ABISELECT(176,124), "S3010C1.s3010c1f5");
    check_field_offset(lv, s3010c1f6, ABISELECT(192,136), "S3010C1.s3010c1f6");
    check_field_offset(lv, s3010c1f7, ABISELECT(200,140), "S3010C1.s3010c1f7");
    check_field_offset(lv, s3010c1f8, ABISELECT(216,148), "S3010C1.s3010c1f8");
    check_field_offset(lv, s3010c1f9, ABISELECT(232,160), "S3010C1.s3010c1f9");
    set_bf_and_test(lv, s3010c1f10, ABISELECT(376,296), 0, 1, 1, "S3010C1");
    check_field_offset(lv, s3010c1f11, ABISELECT(380,300), "S3010C1.s3010c1f11");
    check_field_offset(lv, s3010c1f12, ABISELECT(504,424), "S3010C1.s3010c1f12");
    set_bf_and_test(lv, s3010c1f13, ABISELECT(508,428), 0, 1, 1, "S3010C1");
    test_class_info(&lv, &cd_S3010C1);
    dp->~S3010C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3010C1(Test_S3010C1, "S3010C1", ABISELECT(512,432));

#else // __cplusplus

extern void _ZN7S3010C1C1Ev();
extern void _ZN7S3010C1D1Ev();
Name_Map name_map_S3010C1[] = {
  NSPAIR(_ZN7S3010C1C1Ev),
  NSPAIR(_ZN7S3010C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3010C3;
extern VTBL_ENTRY _ZTI7S3010C3[];
extern  VTBL_ENTRY _ZTV7S3010C3[];
extern Class_Descriptor cd_S3010C5;
extern VTBL_ENTRY _ZTI7S3010C5[];
extern  VTBL_ENTRY _ZTV7S3010C5[];
extern Class_Descriptor cd_S3010C2;
extern VTBL_ENTRY _ZTI7S3010C2[];
extern  VTBL_ENTRY _ZTV7S3010C2[];
static Base_Class bases_S3010C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3010C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3010C5,    ABISELECT(96,60), //bcp->offset
    81, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S3010C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3010C1[];
extern void _ZN7S3010C1D1Ev();
extern void _ZN7S3010C1D0Ev();
extern void _ZN7S3010C33v10Ev();
extern void _ZN7S3010C33v11Ev();
extern void _ZN7S3010C33v12Ev();
extern void _ZN7S3010C33v13Ev();
extern void _ZN7S3010C33v14Ev();
extern void _ZN7S3010C33v15Ev();
extern void _ZN7S3010C33v16Ev();
extern void _ZN7S3010C33v17Ev();
extern void _ZN7S3010C33v18Ev();
extern void _ZN7S3010C33v19Ev();
extern void _ZN7S3010C33v20Ev();
extern void _ZN7S3010C33v21Ev();
extern void _ZN7S3010C33v22Ev();
extern void _ZN7S3010C33v23Ev();
extern void _ZN7S3010C33v24Ev();
extern void _ZN7S3010C33v25Ev();
extern void _ZN7S3010C33v26Ev();
extern void _ZN7S3010C33v27Ev();
extern void _ZN7S3010C33v28Ev();
extern void _ZN7S3010C33v29Ev();
extern void _ZN7S3010C33v30Ev();
extern void _ZN7S3010C33v31Ev();
extern void _ZN7S3010C33v32Ev();
extern void _ZN7S3010C33v33Ev();
extern void _ZN7S3010C33v34Ev();
extern void _ZN7S3010C33v35Ev();
extern void _ZN7S3010C33v36Ev();
extern void _ZN7S3010C33v37Ev();
extern void _ZN7S3010C33v38Ev();
extern void _ZN7S3010C33v39Ev();
extern void _ZN7S3010C33v40Ev();
extern void _ZN7S3010C33v41Ev();
extern void _ZN7S3010C33v42Ev();
extern void _ZN7S3010C33v43Ev();
extern void _ZN7S3010C33v44Ev();
extern void _ZN7S3010C33v45Ev();
extern void _ZN7S3010C33v46Ev();
extern void _ZN7S3010C33v47Ev();
extern void _ZN7S3010C33v48Ev();
extern void _ZN7S3010C33v49Ev();
extern void _ZN7S3010C33v50Ev();
extern void _ZN7S3010C33v51Ev();
extern void _ZN7S3010C33v52Ev();
extern void _ZN7S3010C33v53Ev();
extern void _ZN7S3010C33v54Ev();
extern void _ZN7S3010C33v55Ev();
extern void _ZN7S3010C33v56Ev();
extern void _ZN7S3010C33v57Ev();
extern void _ZN7S3010C33v58Ev();
extern void _ZN7S3010C33v59Ev();
extern void _ZN7S3010C33v60Ev();
extern void _ZN7S3010C33v61Ev();
extern void _ZN7S3010C33v62Ev();
extern void _ZN7S3010C33v63Ev();
extern void _ZN7S3010C33v64Ev();
extern void _ZN7S3010C33v65Ev();
extern void _ZN7S3010C33v66Ev();
extern void _ZN7S3010C33v67Ev();
extern void _ZN7S3010C33v68Ev();
extern void _ZN7S3010C33v69Ev();
extern void _ZN7S3010C33v70Ev();
extern void _ZN7S3010C33v71Ev();
extern void _ZN7S3010C33v72Ev();
extern void _ZN7S3010C33v73Ev();
extern void _ZN7S3010C23v75Ev();
extern void _ZN7S3010C23v76Ev();
extern void _ZN7S3010C23v77Ev();
extern void _ZN7S3010C23v78Ev();
extern void _ZN7S3010C12v1Ev();
extern void _ZN7S3010C12v2Ev();
extern void _ZN7S3010C12v3Ev();
extern void _ZN7S3010C12v4Ev();
extern void _ZN7S3010C12v5Ev();
extern void _ZN7S3010C12v6Ev();
extern void _ZN7S3010C12v7Ev();
extern void _ZN7S3010C12v8Ev();
extern void _ZN7S3010C12v9Ev();
extern void _ZN7S3010C53v74Ev();
static  VTBL_ENTRY vtc_S3010C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3010C1[0]),
  (VTBL_ENTRY)&_ZN7S3010C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3010C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v10Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v11Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v12Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v13Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v14Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v15Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v16Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v17Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v18Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v19Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v20Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v21Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v22Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v23Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v24Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v25Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v26Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v27Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v28Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v29Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v30Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v31Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v32Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v33Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v34Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v35Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v36Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v37Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v38Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v39Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v40Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v41Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v42Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v43Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v44Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v45Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v46Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v47Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v48Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v49Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v50Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v51Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v52Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v53Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v54Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v55Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v56Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v57Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v58Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v59Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v60Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v61Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v62Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v63Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v64Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v65Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v66Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v67Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v68Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v69Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v70Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v71Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v72Ev,
  (VTBL_ENTRY)&_ZN7S3010C33v73Ev,
  (VTBL_ENTRY)&_ZN7S3010C23v75Ev,
  (VTBL_ENTRY)&_ZN7S3010C23v76Ev,
  (VTBL_ENTRY)&_ZN7S3010C23v77Ev,
  (VTBL_ENTRY)&_ZN7S3010C23v78Ev,
  (VTBL_ENTRY)&_ZN7S3010C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3010C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3010C12v3Ev,
  (VTBL_ENTRY)&_ZN7S3010C12v4Ev,
  (VTBL_ENTRY)&_ZN7S3010C12v5Ev,
  (VTBL_ENTRY)&_ZN7S3010C12v6Ev,
  (VTBL_ENTRY)&_ZN7S3010C12v7Ev,
  (VTBL_ENTRY)&_ZN7S3010C12v8Ev,
  (VTBL_ENTRY)&_ZN7S3010C12v9Ev,
  ABISELECT(-96,-60),
  (VTBL_ENTRY)&(_ZTI7S3010C1[0]),
  (VTBL_ENTRY)&_ZN7S3010C53v74Ev,
};
extern VTBL_ENTRY _ZTI7S3010C1[];
extern  VTBL_ENTRY _ZTV7S3010C1[];
Class_Descriptor cd_S3010C1 = {  "S3010C1", // class name
  bases_S3010C1, 3,
  &(vtc_S3010C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(512,432), // object size
  NSPAIRA(_ZTI7S3010C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3010C1),84, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1316C4  {
  int s1316c4f0;
  __tsi64 s1316c4f1;
  void *s1316c4f2[4];
  int s1316c4f3[2];
  void *s1316c4f4;
  ::S1566C14_nt s1316c4f5;
  void *s1316c4f6[2];
  virtual  ~S1316C4(); // _ZN7S1316C4D1Ev
  virtual void  v15(); // _ZN7S1316C43v15Ev
  virtual void  v16(); // _ZN7S1316C43v16Ev
  virtual void  v17(); // _ZN7S1316C43v17Ev
  virtual void  v18(); // _ZN7S1316C43v18Ev
  virtual void  v19(); // _ZN7S1316C43v19Ev
  virtual void  v20(); // _ZN7S1316C43v20Ev
  virtual void  v21(); // _ZN7S1316C43v21Ev
  virtual void  v22(); // _ZN7S1316C43v22Ev
  virtual void  v23(); // _ZN7S1316C43v23Ev
  virtual void  v24(); // _ZN7S1316C43v24Ev
  virtual void  v25(); // _ZN7S1316C43v25Ev
  virtual void  v26(); // _ZN7S1316C43v26Ev
  virtual void  v27(); // _ZN7S1316C43v27Ev
  virtual void  v28(); // _ZN7S1316C43v28Ev
  virtual void  v29(); // _ZN7S1316C43v29Ev
  virtual void  v30(); // _ZN7S1316C43v30Ev
  virtual void  v31(); // _ZN7S1316C43v31Ev
  virtual void  v32(); // _ZN7S1316C43v32Ev
  virtual void  v33(); // _ZN7S1316C43v33Ev
  virtual void  v34(); // _ZN7S1316C43v34Ev
  virtual void  v35(); // _ZN7S1316C43v35Ev
  virtual void  v36(); // _ZN7S1316C43v36Ev
  virtual void  v37(); // _ZN7S1316C43v37Ev
  virtual void  v38(); // _ZN7S1316C43v38Ev
  virtual void  v39(); // _ZN7S1316C43v39Ev
  virtual void  v40(); // _ZN7S1316C43v40Ev
  virtual void  v41(); // _ZN7S1316C43v41Ev
  virtual void  v42(); // _ZN7S1316C43v42Ev
  virtual void  v43(); // _ZN7S1316C43v43Ev
  virtual void  v44(); // _ZN7S1316C43v44Ev
  virtual void  v45(); // _ZN7S1316C43v45Ev
  virtual void  v46(); // _ZN7S1316C43v46Ev
  virtual void  v47(); // _ZN7S1316C43v47Ev
  virtual void  v48(); // _ZN7S1316C43v48Ev
  virtual void  v49(); // _ZN7S1316C43v49Ev
  virtual void  v50(); // _ZN7S1316C43v50Ev
  virtual void  v51(); // _ZN7S1316C43v51Ev
  virtual void  v52(); // _ZN7S1316C43v52Ev
  virtual void  v53(); // _ZN7S1316C43v53Ev
  virtual void  v54(); // _ZN7S1316C43v54Ev
  virtual void  v55(); // _ZN7S1316C43v55Ev
  virtual void  v56(); // _ZN7S1316C43v56Ev
  virtual void  v57(); // _ZN7S1316C43v57Ev
  virtual void  v58(); // _ZN7S1316C43v58Ev
  virtual void  v59(); // _ZN7S1316C43v59Ev
  virtual void  v60(); // _ZN7S1316C43v60Ev
  virtual void  v61(); // _ZN7S1316C43v61Ev
  virtual void  v62(); // _ZN7S1316C43v62Ev
  virtual void  v63(); // _ZN7S1316C43v63Ev
  virtual void  v64(); // _ZN7S1316C43v64Ev
  virtual void  v65(); // _ZN7S1316C43v65Ev
  virtual void  v66(); // _ZN7S1316C43v66Ev
  virtual void  v67(); // _ZN7S1316C43v67Ev
  virtual void  v68(); // _ZN7S1316C43v68Ev
  virtual void  v69(); // _ZN7S1316C43v69Ev
  virtual void  v70(); // _ZN7S1316C43v70Ev
  virtual void  v71(); // _ZN7S1316C43v71Ev
  virtual void  v72(); // _ZN7S1316C43v72Ev
  virtual void  v73(); // _ZN7S1316C43v73Ev
  virtual void  v74(); // _ZN7S1316C43v74Ev
  virtual void  v75(); // _ZN7S1316C43v75Ev
  virtual void  v76(); // _ZN7S1316C43v76Ev
  virtual void  v77(); // _ZN7S1316C43v77Ev
  virtual void  v78(); // _ZN7S1316C43v78Ev
  S1316C4(); // tgen
};
//SIG(-1 S1316C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1316C4 ::~S1316C4(){ note_dtor("S1316C4", this);}
void  S1316C4 ::v15(){vfunc_called(this, "_ZN7S1316C43v15Ev");}
void  S1316C4 ::v16(){vfunc_called(this, "_ZN7S1316C43v16Ev");}
void  S1316C4 ::v17(){vfunc_called(this, "_ZN7S1316C43v17Ev");}
void  S1316C4 ::v18(){vfunc_called(this, "_ZN7S1316C43v18Ev");}
void  S1316C4 ::v19(){vfunc_called(this, "_ZN7S1316C43v19Ev");}
void  S1316C4 ::v20(){vfunc_called(this, "_ZN7S1316C43v20Ev");}
void  S1316C4 ::v21(){vfunc_called(this, "_ZN7S1316C43v21Ev");}
void  S1316C4 ::v22(){vfunc_called(this, "_ZN7S1316C43v22Ev");}
void  S1316C4 ::v23(){vfunc_called(this, "_ZN7S1316C43v23Ev");}
void  S1316C4 ::v24(){vfunc_called(this, "_ZN7S1316C43v24Ev");}
void  S1316C4 ::v25(){vfunc_called(this, "_ZN7S1316C43v25Ev");}
void  S1316C4 ::v26(){vfunc_called(this, "_ZN7S1316C43v26Ev");}
void  S1316C4 ::v27(){vfunc_called(this, "_ZN7S1316C43v27Ev");}
void  S1316C4 ::v28(){vfunc_called(this, "_ZN7S1316C43v28Ev");}
void  S1316C4 ::v29(){vfunc_called(this, "_ZN7S1316C43v29Ev");}
void  S1316C4 ::v30(){vfunc_called(this, "_ZN7S1316C43v30Ev");}
void  S1316C4 ::v31(){vfunc_called(this, "_ZN7S1316C43v31Ev");}
void  S1316C4 ::v32(){vfunc_called(this, "_ZN7S1316C43v32Ev");}
void  S1316C4 ::v33(){vfunc_called(this, "_ZN7S1316C43v33Ev");}
void  S1316C4 ::v34(){vfunc_called(this, "_ZN7S1316C43v34Ev");}
void  S1316C4 ::v35(){vfunc_called(this, "_ZN7S1316C43v35Ev");}
void  S1316C4 ::v36(){vfunc_called(this, "_ZN7S1316C43v36Ev");}
void  S1316C4 ::v37(){vfunc_called(this, "_ZN7S1316C43v37Ev");}
void  S1316C4 ::v38(){vfunc_called(this, "_ZN7S1316C43v38Ev");}
void  S1316C4 ::v39(){vfunc_called(this, "_ZN7S1316C43v39Ev");}
void  S1316C4 ::v40(){vfunc_called(this, "_ZN7S1316C43v40Ev");}
void  S1316C4 ::v41(){vfunc_called(this, "_ZN7S1316C43v41Ev");}
void  S1316C4 ::v42(){vfunc_called(this, "_ZN7S1316C43v42Ev");}
void  S1316C4 ::v43(){vfunc_called(this, "_ZN7S1316C43v43Ev");}
void  S1316C4 ::v44(){vfunc_called(this, "_ZN7S1316C43v44Ev");}
void  S1316C4 ::v45(){vfunc_called(this, "_ZN7S1316C43v45Ev");}
void  S1316C4 ::v46(){vfunc_called(this, "_ZN7S1316C43v46Ev");}
void  S1316C4 ::v47(){vfunc_called(this, "_ZN7S1316C43v47Ev");}
void  S1316C4 ::v48(){vfunc_called(this, "_ZN7S1316C43v48Ev");}
void  S1316C4 ::v49(){vfunc_called(this, "_ZN7S1316C43v49Ev");}
void  S1316C4 ::v50(){vfunc_called(this, "_ZN7S1316C43v50Ev");}
void  S1316C4 ::v51(){vfunc_called(this, "_ZN7S1316C43v51Ev");}
void  S1316C4 ::v52(){vfunc_called(this, "_ZN7S1316C43v52Ev");}
void  S1316C4 ::v53(){vfunc_called(this, "_ZN7S1316C43v53Ev");}
void  S1316C4 ::v54(){vfunc_called(this, "_ZN7S1316C43v54Ev");}
void  S1316C4 ::v55(){vfunc_called(this, "_ZN7S1316C43v55Ev");}
void  S1316C4 ::v56(){vfunc_called(this, "_ZN7S1316C43v56Ev");}
void  S1316C4 ::v57(){vfunc_called(this, "_ZN7S1316C43v57Ev");}
void  S1316C4 ::v58(){vfunc_called(this, "_ZN7S1316C43v58Ev");}
void  S1316C4 ::v59(){vfunc_called(this, "_ZN7S1316C43v59Ev");}
void  S1316C4 ::v60(){vfunc_called(this, "_ZN7S1316C43v60Ev");}
void  S1316C4 ::v61(){vfunc_called(this, "_ZN7S1316C43v61Ev");}
void  S1316C4 ::v62(){vfunc_called(this, "_ZN7S1316C43v62Ev");}
void  S1316C4 ::v63(){vfunc_called(this, "_ZN7S1316C43v63Ev");}
void  S1316C4 ::v64(){vfunc_called(this, "_ZN7S1316C43v64Ev");}
void  S1316C4 ::v65(){vfunc_called(this, "_ZN7S1316C43v65Ev");}
void  S1316C4 ::v66(){vfunc_called(this, "_ZN7S1316C43v66Ev");}
void  S1316C4 ::v67(){vfunc_called(this, "_ZN7S1316C43v67Ev");}
void  S1316C4 ::v68(){vfunc_called(this, "_ZN7S1316C43v68Ev");}
void  S1316C4 ::v69(){vfunc_called(this, "_ZN7S1316C43v69Ev");}
void  S1316C4 ::v70(){vfunc_called(this, "_ZN7S1316C43v70Ev");}
void  S1316C4 ::v71(){vfunc_called(this, "_ZN7S1316C43v71Ev");}
void  S1316C4 ::v72(){vfunc_called(this, "_ZN7S1316C43v72Ev");}
void  S1316C4 ::v73(){vfunc_called(this, "_ZN7S1316C43v73Ev");}
void  S1316C4 ::v74(){vfunc_called(this, "_ZN7S1316C43v74Ev");}
void  S1316C4 ::v75(){vfunc_called(this, "_ZN7S1316C43v75Ev");}
void  S1316C4 ::v76(){vfunc_called(this, "_ZN7S1316C43v76Ev");}
void  S1316C4 ::v77(){vfunc_called(this, "_ZN7S1316C43v77Ev");}
void  S1316C4 ::v78(){vfunc_called(this, "_ZN7S1316C43v78Ev");}
S1316C4 ::S1316C4(){ note_ctor("S1316C4", this);} // tgen

static void Test_S1316C4()
{
  extern Class_Descriptor cd_S1316C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1316C4, buf);
    S1316C4 *dp, &lv = *(dp=new (buf) S1316C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1316C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1316C4)");
    check_field_offset(lv, s1316c4f0, ABISELECT(8,4), "S1316C4.s1316c4f0");
    check_field_offset(lv, s1316c4f1, ABISELECT(16,8), "S1316C4.s1316c4f1");
    check_field_offset(lv, s1316c4f2, ABISELECT(24,16), "S1316C4.s1316c4f2");
    check_field_offset(lv, s1316c4f3, ABISELECT(56,32), "S1316C4.s1316c4f3");
    check_field_offset(lv, s1316c4f4, ABISELECT(64,40), "S1316C4.s1316c4f4");
    check_field_offset(lv, s1316c4f5, ABISELECT(72,44), "S1316C4.s1316c4f5");
    check_field_offset(lv, s1316c4f6, ABISELECT(80,52), "S1316C4.s1316c4f6");
    test_class_info(&lv, &cd_S1316C4);
    dp->~S1316C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1316C4(Test_S1316C4, "S1316C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1316C4C1Ev();
extern void _ZN7S1316C4D1Ev();
Name_Map name_map_S1316C4[] = {
  NSPAIR(_ZN7S1316C4C1Ev),
  NSPAIR(_ZN7S1316C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1316C4[];
extern void _ZN7S1316C4D1Ev();
extern void _ZN7S1316C4D0Ev();
extern void _ZN7S1316C43v15Ev();
extern void _ZN7S1316C43v16Ev();
extern void _ZN7S1316C43v17Ev();
extern void _ZN7S1316C43v18Ev();
extern void _ZN7S1316C43v19Ev();
extern void _ZN7S1316C43v20Ev();
extern void _ZN7S1316C43v21Ev();
extern void _ZN7S1316C43v22Ev();
extern void _ZN7S1316C43v23Ev();
extern void _ZN7S1316C43v24Ev();
extern void _ZN7S1316C43v25Ev();
extern void _ZN7S1316C43v26Ev();
extern void _ZN7S1316C43v27Ev();
extern void _ZN7S1316C43v28Ev();
extern void _ZN7S1316C43v29Ev();
extern void _ZN7S1316C43v30Ev();
extern void _ZN7S1316C43v31Ev();
extern void _ZN7S1316C43v32Ev();
extern void _ZN7S1316C43v33Ev();
extern void _ZN7S1316C43v34Ev();
extern void _ZN7S1316C43v35Ev();
extern void _ZN7S1316C43v36Ev();
extern void _ZN7S1316C43v37Ev();
extern void _ZN7S1316C43v38Ev();
extern void _ZN7S1316C43v39Ev();
extern void _ZN7S1316C43v40Ev();
extern void _ZN7S1316C43v41Ev();
extern void _ZN7S1316C43v42Ev();
extern void _ZN7S1316C43v43Ev();
extern void _ZN7S1316C43v44Ev();
extern void _ZN7S1316C43v45Ev();
extern void _ZN7S1316C43v46Ev();
extern void _ZN7S1316C43v47Ev();
extern void _ZN7S1316C43v48Ev();
extern void _ZN7S1316C43v49Ev();
extern void _ZN7S1316C43v50Ev();
extern void _ZN7S1316C43v51Ev();
extern void _ZN7S1316C43v52Ev();
extern void _ZN7S1316C43v53Ev();
extern void _ZN7S1316C43v54Ev();
extern void _ZN7S1316C43v55Ev();
extern void _ZN7S1316C43v56Ev();
extern void _ZN7S1316C43v57Ev();
extern void _ZN7S1316C43v58Ev();
extern void _ZN7S1316C43v59Ev();
extern void _ZN7S1316C43v60Ev();
extern void _ZN7S1316C43v61Ev();
extern void _ZN7S1316C43v62Ev();
extern void _ZN7S1316C43v63Ev();
extern void _ZN7S1316C43v64Ev();
extern void _ZN7S1316C43v65Ev();
extern void _ZN7S1316C43v66Ev();
extern void _ZN7S1316C43v67Ev();
extern void _ZN7S1316C43v68Ev();
extern void _ZN7S1316C43v69Ev();
extern void _ZN7S1316C43v70Ev();
extern void _ZN7S1316C43v71Ev();
extern void _ZN7S1316C43v72Ev();
extern void _ZN7S1316C43v73Ev();
extern void _ZN7S1316C43v74Ev();
extern void _ZN7S1316C43v75Ev();
extern void _ZN7S1316C43v76Ev();
extern void _ZN7S1316C43v77Ev();
extern void _ZN7S1316C43v78Ev();
static  VTBL_ENTRY vtc_S1316C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1316C4[0]),
  (VTBL_ENTRY)&_ZN7S1316C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1316C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v78Ev,
};
extern VTBL_ENTRY _ZTI7S1316C4[];
extern  VTBL_ENTRY _ZTV7S1316C4[];
Class_Descriptor cd_S1316C4 = {  "S1316C4", // class name
  0,0,//no base classes
  &(vtc_S1316C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1316C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1316C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1316C7  : S1537C8_nt {
};
//SIG(-1 S1316C7) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1316C7()
{
  extern Class_Descriptor cd_S1316C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1316C7, buf);
    S1316C7 &lv = *(new (buf) S1316C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1316C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1316C7)");
    check_base_class_offset(lv, (S1537C8_nt*), 0, "S1316C7");
    test_class_info(&lv, &cd_S1316C7);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1316C7(Test_S1316C7, "S1316C7", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
static Base_Class bases_S1316C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1316C7 = {  "S1316C7", // class name
  bases_S1316C7, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1316C6_nt  : S1316C7 {
  void *s1316c6f0;
};
//SIG(-1 S1316C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}} Fp}



//skip512 S1316C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1537C8_nt;
extern Class_Descriptor cd_S1316C7;
static Base_Class bases_S1316C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1537C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1316C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1316C3_nt  : S1316C4 {
  ::S1316C6_nt s1316c3f0;
  ::S1325C21 s1316c3f1;
  virtual  ~S1316C3_nt(); // _ZN10S1316C3_ntD1Ev
  virtual void  v79(); // _ZN10S1316C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1316C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1316C3_nt3v81Ev
  S1316C3_nt(); // tgen
};
//SIG(-1 S1316C3_nt) C1{ BC2{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 FC4{ BC5{ BC6{ m Fp Fi[2]}} Fp} FC7{ m FC8{ BC9{ BC6}} FC8 Fi FC8 FC10{ BC6} FC8 Fi}}


 S1316C3_nt ::~S1316C3_nt(){ note_dtor("S1316C3_nt", this);}
void  S1316C3_nt ::v79(){vfunc_called(this, "_ZN10S1316C3_nt3v79Ev");}
void  S1316C3_nt ::v80(){vfunc_called(this, "_ZN10S1316C3_nt3v80Ev");}
void  S1316C3_nt ::v81(){vfunc_called(this, "_ZN10S1316C3_nt3v81Ev");}
S1316C3_nt ::S1316C3_nt(){ note_ctor("S1316C3_nt", this);} // tgen

//skip512 S1316C3_nt

#else // __cplusplus

extern void _ZN10S1316C3_ntC1Ev();
extern void _ZN10S1316C3_ntD1Ev();
Name_Map name_map_S1316C3_nt[] = {
  NSPAIR(_ZN10S1316C3_ntC1Ev),
  NSPAIR(_ZN10S1316C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1316C4;
extern VTBL_ENTRY _ZTI7S1316C4[];
extern  VTBL_ENTRY _ZTV7S1316C4[];
static Base_Class bases_S1316C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1316C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1316C3_nt[];
extern void _ZN10S1316C3_ntD1Ev();
extern void _ZN10S1316C3_ntD0Ev();
extern void _ZN7S1316C43v15Ev();
extern void _ZN7S1316C43v16Ev();
extern void _ZN7S1316C43v17Ev();
extern void _ZN7S1316C43v18Ev();
extern void _ZN7S1316C43v19Ev();
extern void _ZN7S1316C43v20Ev();
extern void _ZN7S1316C43v21Ev();
extern void _ZN7S1316C43v22Ev();
extern void _ZN7S1316C43v23Ev();
extern void _ZN7S1316C43v24Ev();
extern void _ZN7S1316C43v25Ev();
extern void _ZN7S1316C43v26Ev();
extern void _ZN7S1316C43v27Ev();
extern void _ZN7S1316C43v28Ev();
extern void _ZN7S1316C43v29Ev();
extern void _ZN7S1316C43v30Ev();
extern void _ZN7S1316C43v31Ev();
extern void _ZN7S1316C43v32Ev();
extern void _ZN7S1316C43v33Ev();
extern void _ZN7S1316C43v34Ev();
extern void _ZN7S1316C43v35Ev();
extern void _ZN7S1316C43v36Ev();
extern void _ZN7S1316C43v37Ev();
extern void _ZN7S1316C43v38Ev();
extern void _ZN7S1316C43v39Ev();
extern void _ZN7S1316C43v40Ev();
extern void _ZN7S1316C43v41Ev();
extern void _ZN7S1316C43v42Ev();
extern void _ZN7S1316C43v43Ev();
extern void _ZN7S1316C43v44Ev();
extern void _ZN7S1316C43v45Ev();
extern void _ZN7S1316C43v46Ev();
extern void _ZN7S1316C43v47Ev();
extern void _ZN7S1316C43v48Ev();
extern void _ZN7S1316C43v49Ev();
extern void _ZN7S1316C43v50Ev();
extern void _ZN7S1316C43v51Ev();
extern void _ZN7S1316C43v52Ev();
extern void _ZN7S1316C43v53Ev();
extern void _ZN7S1316C43v54Ev();
extern void _ZN7S1316C43v55Ev();
extern void _ZN7S1316C43v56Ev();
extern void _ZN7S1316C43v57Ev();
extern void _ZN7S1316C43v58Ev();
extern void _ZN7S1316C43v59Ev();
extern void _ZN7S1316C43v60Ev();
extern void _ZN7S1316C43v61Ev();
extern void _ZN7S1316C43v62Ev();
extern void _ZN7S1316C43v63Ev();
extern void _ZN7S1316C43v64Ev();
extern void _ZN7S1316C43v65Ev();
extern void _ZN7S1316C43v66Ev();
extern void _ZN7S1316C43v67Ev();
extern void _ZN7S1316C43v68Ev();
extern void _ZN7S1316C43v69Ev();
extern void _ZN7S1316C43v70Ev();
extern void _ZN7S1316C43v71Ev();
extern void _ZN7S1316C43v72Ev();
extern void _ZN7S1316C43v73Ev();
extern void _ZN7S1316C43v74Ev();
extern void _ZN7S1316C43v75Ev();
extern void _ZN7S1316C43v76Ev();
extern void _ZN7S1316C43v77Ev();
extern void _ZN7S1316C43v78Ev();
extern void _ZN10S1316C3_nt3v79Ev();
extern void _ZN10S1316C3_nt3v80Ev();
extern void _ZN10S1316C3_nt3v81Ev();
static  VTBL_ENTRY vtc_S1316C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1316C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1316C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1316C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v78Ev,
  (VTBL_ENTRY)&_ZN10S1316C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1316C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1316C3_nt3v81Ev,
};
extern VTBL_ENTRY _ZTI10S1316C3_nt[];
VTBL_ENTRY *P__ZTI10S1316C3_nt = _ZTI10S1316C3_nt; 
extern  VTBL_ENTRY _ZTV10S1316C3_nt[];
Class_Descriptor cd_S1316C3_nt = {  "S1316C3_nt", // class name
  bases_S1316C3_nt, 1,
  &(vtc_S1316C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,144), // object size
  NSPAIRA(_ZTI10S1316C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1316C3_nt),71, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1316C13_nt  {
  virtual void  v82(); // _ZN11S1316C13_nt3v82Ev
  virtual void  v83(); // _ZN11S1316C13_nt3v83Ev
  virtual void  v84(); // _ZN11S1316C13_nt3v84Ev
  virtual void  v85(); // _ZN11S1316C13_nt3v85Ev
  virtual void  v86(); // _ZN11S1316C13_nt3v86Ev
  virtual void  v87(); // _ZN11S1316C13_nt3v87Ev
  virtual void  v88(); // _ZN11S1316C13_nt3v88Ev
  virtual void  v89(); // _ZN11S1316C13_nt3v89Ev
  ~S1316C13_nt(); // tgen
  S1316C13_nt(); // tgen
};
//SIG(-1 S1316C13_nt) C1{ v1 v2 v3 v4 v5 v6 v7 v8}


void  S1316C13_nt ::v82(){vfunc_called(this, "_ZN11S1316C13_nt3v82Ev");}
void  S1316C13_nt ::v83(){vfunc_called(this, "_ZN11S1316C13_nt3v83Ev");}
void  S1316C13_nt ::v84(){vfunc_called(this, "_ZN11S1316C13_nt3v84Ev");}
void  S1316C13_nt ::v85(){vfunc_called(this, "_ZN11S1316C13_nt3v85Ev");}
void  S1316C13_nt ::v86(){vfunc_called(this, "_ZN11S1316C13_nt3v86Ev");}
void  S1316C13_nt ::v87(){vfunc_called(this, "_ZN11S1316C13_nt3v87Ev");}
void  S1316C13_nt ::v88(){vfunc_called(this, "_ZN11S1316C13_nt3v88Ev");}
void  S1316C13_nt ::v89(){vfunc_called(this, "_ZN11S1316C13_nt3v89Ev");}
S1316C13_nt ::~S1316C13_nt(){ note_dtor("S1316C13_nt", this);} // tgen
S1316C13_nt ::S1316C13_nt(){ note_ctor("S1316C13_nt", this);} // tgen

//skip512 S1316C13_nt

#else // __cplusplus

extern void _ZN11S1316C13_ntC1Ev();
extern void _ZN11S1316C13_ntD1Ev();
Name_Map name_map_S1316C13_nt[] = {
  NSPAIR(_ZN11S1316C13_ntC1Ev),
  NSPAIR(_ZN11S1316C13_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S1316C13_nt[];
extern void _ZN11S1316C13_nt3v82Ev();
extern void _ZN11S1316C13_nt3v83Ev();
extern void _ZN11S1316C13_nt3v84Ev();
extern void _ZN11S1316C13_nt3v85Ev();
extern void _ZN11S1316C13_nt3v86Ev();
extern void _ZN11S1316C13_nt3v87Ev();
extern void _ZN11S1316C13_nt3v88Ev();
extern void _ZN11S1316C13_nt3v89Ev();
static  VTBL_ENTRY vtc_S1316C13_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S1316C13_nt[0]),
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v82Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v83Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v84Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v85Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v86Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v87Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v88Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v89Ev,
};
extern VTBL_ENTRY _ZTI11S1316C13_nt[];
VTBL_ENTRY *P__ZTI11S1316C13_nt = _ZTI11S1316C13_nt; 
extern  VTBL_ENTRY _ZTV11S1316C13_nt[];
Class_Descriptor cd_S1316C13_nt = {  "S1316C13_nt", // class name
  0,0,//no base classes
  &(vtc_S1316C13_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S1316C13_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S1316C13_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1316C2  : S1316C3_nt , S1316C13_nt {
  void *s1316c2f0[2];
  int s1316c2f1[3];
  ::S1566C9 s1316c2f2;
  ::S1566C29 s1316c2f3;
  virtual  ~S1316C2(); // _ZN7S1316C2D1Ev
  virtual void  v90(); // _ZN7S1316C23v90Ev
  virtual void  v91(); // _ZN7S1316C23v91Ev
  virtual void  v92(); // _ZN7S1316C23v92Ev
  virtual void  v93(); // _ZN7S1316C23v93Ev
  virtual void  v94(); // _ZN7S1316C23v94Ev
  virtual void  v95(); // _ZN7S1316C23v95Ev
  virtual void  v96(); // _ZN7S1316C23v96Ev
  virtual void  v97(); // _ZN7S1316C23v97Ev
  virtual void  v98(); // _ZN7S1316C23v98Ev
  S1316C2(); // tgen
};
//SIG(-1 S1316C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v74 v75 v76 FC5{ BC6{ BC7{ m Fp Fi[2]}} Fp} FC8{ m FC9{ BC10{ BC7}} FC9 Fi FC9 FC11{ BC7} FC9 Fi}} BC12{ v77 v78 v79 v80 v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp[2] Fi[3] FC13{ BC14{ BC7}} FC15{ BC7}}


 S1316C2 ::~S1316C2(){ note_dtor("S1316C2", this);}
void  S1316C2 ::v90(){vfunc_called(this, "_ZN7S1316C23v90Ev");}
void  S1316C2 ::v91(){vfunc_called(this, "_ZN7S1316C23v91Ev");}
void  S1316C2 ::v92(){vfunc_called(this, "_ZN7S1316C23v92Ev");}
void  S1316C2 ::v93(){vfunc_called(this, "_ZN7S1316C23v93Ev");}
void  S1316C2 ::v94(){vfunc_called(this, "_ZN7S1316C23v94Ev");}
void  S1316C2 ::v95(){vfunc_called(this, "_ZN7S1316C23v95Ev");}
void  S1316C2 ::v96(){vfunc_called(this, "_ZN7S1316C23v96Ev");}
void  S1316C2 ::v97(){vfunc_called(this, "_ZN7S1316C23v97Ev");}
void  S1316C2 ::v98(){vfunc_called(this, "_ZN7S1316C23v98Ev");}
S1316C2 ::S1316C2(){ note_ctor("S1316C2", this);} // tgen

static void Test_S1316C2()
{
  extern Class_Descriptor cd_S1316C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,49)];
    init_test(&cd_S1316C2, buf);
    S1316C2 *dp, &lv = *(dp=new (buf) S1316C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,192), "sizeof(S1316C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1316C2)");
    check_base_class_offset(lv, (S1316C4*)(S1316C3_nt*), 0, "S1316C2");
    check_base_class_offset(lv, (S1316C3_nt*), 0, "S1316C2");
    check_base_class_offset(lv, (S1316C13_nt*), ABISELECT(216,144), "S1316C2");
    check_field_offset(lv, s1316c2f0, ABISELECT(224,148), "S1316C2.s1316c2f0");
    check_field_offset(lv, s1316c2f1, ABISELECT(240,156), "S1316C2.s1316c2f1");
    check_field_offset(lv, s1316c2f2, ABISELECT(256,168), "S1316C2.s1316c2f2");
    check_field_offset(lv, s1316c2f3, ABISELECT(272,180), "S1316C2.s1316c2f3");
    test_class_info(&lv, &cd_S1316C2);
    dp->~S1316C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1316C2(Test_S1316C2, "S1316C2", ABISELECT(288,192));

#else // __cplusplus

extern void _ZN7S1316C2C1Ev();
extern void _ZN7S1316C2D1Ev();
Name_Map name_map_S1316C2[] = {
  NSPAIR(_ZN7S1316C2C1Ev),
  NSPAIR(_ZN7S1316C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1316C4;
extern VTBL_ENTRY _ZTI7S1316C4[];
extern  VTBL_ENTRY _ZTV7S1316C4[];
extern Class_Descriptor cd_S1316C3_nt;
extern VTBL_ENTRY _ZTI10S1316C3_nt[];
extern  VTBL_ENTRY _ZTV10S1316C3_nt[];
extern Class_Descriptor cd_S1316C13_nt;
extern VTBL_ENTRY _ZTI11S1316C13_nt[];
extern  VTBL_ENTRY _ZTV11S1316C13_nt[];
static Base_Class bases_S1316C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1316C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1316C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1316C13_nt,    ABISELECT(216,144), //bcp->offset
    80, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1316C2[];
extern void _ZN7S1316C2D1Ev();
extern void _ZN7S1316C2D0Ev();
extern void _ZN7S1316C43v15Ev();
extern void _ZN7S1316C43v16Ev();
extern void _ZN7S1316C43v17Ev();
extern void _ZN7S1316C43v18Ev();
extern void _ZN7S1316C43v19Ev();
extern void _ZN7S1316C43v20Ev();
extern void _ZN7S1316C43v21Ev();
extern void _ZN7S1316C43v22Ev();
extern void _ZN7S1316C43v23Ev();
extern void _ZN7S1316C43v24Ev();
extern void _ZN7S1316C43v25Ev();
extern void _ZN7S1316C43v26Ev();
extern void _ZN7S1316C43v27Ev();
extern void _ZN7S1316C43v28Ev();
extern void _ZN7S1316C43v29Ev();
extern void _ZN7S1316C43v30Ev();
extern void _ZN7S1316C43v31Ev();
extern void _ZN7S1316C43v32Ev();
extern void _ZN7S1316C43v33Ev();
extern void _ZN7S1316C43v34Ev();
extern void _ZN7S1316C43v35Ev();
extern void _ZN7S1316C43v36Ev();
extern void _ZN7S1316C43v37Ev();
extern void _ZN7S1316C43v38Ev();
extern void _ZN7S1316C43v39Ev();
extern void _ZN7S1316C43v40Ev();
extern void _ZN7S1316C43v41Ev();
extern void _ZN7S1316C43v42Ev();
extern void _ZN7S1316C43v43Ev();
extern void _ZN7S1316C43v44Ev();
extern void _ZN7S1316C43v45Ev();
extern void _ZN7S1316C43v46Ev();
extern void _ZN7S1316C43v47Ev();
extern void _ZN7S1316C43v48Ev();
extern void _ZN7S1316C43v49Ev();
extern void _ZN7S1316C43v50Ev();
extern void _ZN7S1316C43v51Ev();
extern void _ZN7S1316C43v52Ev();
extern void _ZN7S1316C43v53Ev();
extern void _ZN7S1316C43v54Ev();
extern void _ZN7S1316C43v55Ev();
extern void _ZN7S1316C43v56Ev();
extern void _ZN7S1316C43v57Ev();
extern void _ZN7S1316C43v58Ev();
extern void _ZN7S1316C43v59Ev();
extern void _ZN7S1316C43v60Ev();
extern void _ZN7S1316C43v61Ev();
extern void _ZN7S1316C43v62Ev();
extern void _ZN7S1316C43v63Ev();
extern void _ZN7S1316C43v64Ev();
extern void _ZN7S1316C43v65Ev();
extern void _ZN7S1316C43v66Ev();
extern void _ZN7S1316C43v67Ev();
extern void _ZN7S1316C43v68Ev();
extern void _ZN7S1316C43v69Ev();
extern void _ZN7S1316C43v70Ev();
extern void _ZN7S1316C43v71Ev();
extern void _ZN7S1316C43v72Ev();
extern void _ZN7S1316C43v73Ev();
extern void _ZN7S1316C43v74Ev();
extern void _ZN7S1316C43v75Ev();
extern void _ZN7S1316C43v76Ev();
extern void _ZN7S1316C43v77Ev();
extern void _ZN7S1316C43v78Ev();
extern void _ZN10S1316C3_nt3v79Ev();
extern void _ZN10S1316C3_nt3v80Ev();
extern void _ZN10S1316C3_nt3v81Ev();
extern void _ZN7S1316C23v90Ev();
extern void _ZN7S1316C23v91Ev();
extern void _ZN7S1316C23v92Ev();
extern void _ZN7S1316C23v93Ev();
extern void _ZN7S1316C23v94Ev();
extern void _ZN7S1316C23v95Ev();
extern void _ZN7S1316C23v96Ev();
extern void _ZN7S1316C23v97Ev();
extern void _ZN7S1316C23v98Ev();
extern void _ZN11S1316C13_nt3v82Ev();
extern void _ZN11S1316C13_nt3v83Ev();
extern void _ZN11S1316C13_nt3v84Ev();
extern void _ZN11S1316C13_nt3v85Ev();
extern void _ZN11S1316C13_nt3v86Ev();
extern void _ZN11S1316C13_nt3v87Ev();
extern void _ZN11S1316C13_nt3v88Ev();
extern void _ZN11S1316C13_nt3v89Ev();
static  VTBL_ENTRY vtc_S1316C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1316C2[0]),
  (VTBL_ENTRY)&_ZN7S1316C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1316C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v78Ev,
  (VTBL_ENTRY)&_ZN10S1316C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1316C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1316C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v98Ev,
  ABISELECT(-216,-144),
  (VTBL_ENTRY)&(_ZTI7S1316C2[0]),
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v82Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v83Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v84Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v85Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v86Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v87Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v88Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v89Ev,
};
extern VTBL_ENTRY _ZTI7S1316C2[];
extern  VTBL_ENTRY _ZTV7S1316C2[];
Class_Descriptor cd_S1316C2 = {  "S1316C2", // class name
  bases_S1316C2, 3,
  &(vtc_S1316C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,192), // object size
  NSPAIRA(_ZTI7S1316C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1316C2),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1316C1  : S1316C2 {
  virtual  ~S1316C1(); // _ZN7S1316C1D1Ev
  virtual void  v1(); // _ZN7S1316C12v1Ev
  virtual void  v2(); // _ZN7S1316C12v2Ev
  virtual void  v3(); // _ZN7S1316C12v3Ev
  virtual void  v4(); // _ZN7S1316C12v4Ev
  virtual void  v5(); // _ZN7S1316C12v5Ev
  virtual void  v6(); // _ZN7S1316C12v6Ev
  virtual void  v7(); // _ZN7S1316C12v7Ev
  virtual void  v8(); // _ZN7S1316C12v8Ev
  virtual void  v9(); // _ZN7S1316C12v9Ev
  virtual void  v10(); // _ZN7S1316C13v10Ev
  virtual void  v11(); // _ZN7S1316C13v11Ev
  virtual void  v12(); // _ZN7S1316C13v12Ev
  virtual void  v13(); // _ZN7S1316C13v13Ev
  virtual void  v14(); // _ZN7S1316C13v14Ev
  S1316C1(); // tgen
};
//SIG(1 S1316C1) C1{ BC2{ BC3{ BC4{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v79 v80 v81 FC6{ BC7{ BC8{ m Fp Fi[2]}} Fp} FC9{ m FC10{ BC11{ BC8}} FC10 Fi FC10 FC12{ BC8} FC10 Fi}} BC13{ v82 v83 v84 v85 v86 v87 v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 Fp[2] Fi[3] FC14{ BC15{ BC8}} FC16{ BC8}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14}


 S1316C1 ::~S1316C1(){ note_dtor("S1316C1", this);}
void  S1316C1 ::v1(){vfunc_called(this, "_ZN7S1316C12v1Ev");}
void  S1316C1 ::v2(){vfunc_called(this, "_ZN7S1316C12v2Ev");}
void  S1316C1 ::v3(){vfunc_called(this, "_ZN7S1316C12v3Ev");}
void  S1316C1 ::v4(){vfunc_called(this, "_ZN7S1316C12v4Ev");}
void  S1316C1 ::v5(){vfunc_called(this, "_ZN7S1316C12v5Ev");}
void  S1316C1 ::v6(){vfunc_called(this, "_ZN7S1316C12v6Ev");}
void  S1316C1 ::v7(){vfunc_called(this, "_ZN7S1316C12v7Ev");}
void  S1316C1 ::v8(){vfunc_called(this, "_ZN7S1316C12v8Ev");}
void  S1316C1 ::v9(){vfunc_called(this, "_ZN7S1316C12v9Ev");}
void  S1316C1 ::v10(){vfunc_called(this, "_ZN7S1316C13v10Ev");}
void  S1316C1 ::v11(){vfunc_called(this, "_ZN7S1316C13v11Ev");}
void  S1316C1 ::v12(){vfunc_called(this, "_ZN7S1316C13v12Ev");}
void  S1316C1 ::v13(){vfunc_called(this, "_ZN7S1316C13v13Ev");}
void  S1316C1 ::v14(){vfunc_called(this, "_ZN7S1316C13v14Ev");}
S1316C1 ::S1316C1(){ note_ctor("S1316C1", this);} // tgen

static void Test_S1316C1()
{
  extern Class_Descriptor cd_S1316C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,49)];
    init_test(&cd_S1316C1, buf);
    S1316C1 *dp, &lv = *(dp=new (buf) S1316C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,192), "sizeof(S1316C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1316C1)");
    check_base_class_offset(lv, (S1316C4*)(S1316C3_nt*)(S1316C2*), 0, "S1316C1");
    check_base_class_offset(lv, (S1316C3_nt*)(S1316C2*), 0, "S1316C1");
    check_base_class_offset(lv, (S1316C13_nt*)(S1316C2*), ABISELECT(216,144), "S1316C1");
    check_base_class_offset(lv, (S1316C2*), 0, "S1316C1");
    test_class_info(&lv, &cd_S1316C1);
    dp->~S1316C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1316C1(Test_S1316C1, "S1316C1", ABISELECT(288,192));

#else // __cplusplus

extern void _ZN7S1316C1C1Ev();
extern void _ZN7S1316C1D1Ev();
Name_Map name_map_S1316C1[] = {
  NSPAIR(_ZN7S1316C1C1Ev),
  NSPAIR(_ZN7S1316C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1316C4;
extern VTBL_ENTRY _ZTI7S1316C4[];
extern  VTBL_ENTRY _ZTV7S1316C4[];
extern Class_Descriptor cd_S1316C3_nt;
extern VTBL_ENTRY _ZTI10S1316C3_nt[];
extern  VTBL_ENTRY _ZTV10S1316C3_nt[];
extern Class_Descriptor cd_S1316C13_nt;
extern VTBL_ENTRY _ZTI11S1316C13_nt[];
extern  VTBL_ENTRY _ZTV11S1316C13_nt[];
extern Class_Descriptor cd_S1316C2;
extern VTBL_ENTRY _ZTI7S1316C2[];
extern  VTBL_ENTRY _ZTV7S1316C2[];
static Base_Class bases_S1316C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1316C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1316C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1316C13_nt,    ABISELECT(216,144), //bcp->offset
    94, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1316C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1316C1[];
extern void _ZN7S1316C1D1Ev();
extern void _ZN7S1316C1D0Ev();
extern void _ZN7S1316C43v15Ev();
extern void _ZN7S1316C43v16Ev();
extern void _ZN7S1316C43v17Ev();
extern void _ZN7S1316C43v18Ev();
extern void _ZN7S1316C43v19Ev();
extern void _ZN7S1316C43v20Ev();
extern void _ZN7S1316C43v21Ev();
extern void _ZN7S1316C43v22Ev();
extern void _ZN7S1316C43v23Ev();
extern void _ZN7S1316C43v24Ev();
extern void _ZN7S1316C43v25Ev();
extern void _ZN7S1316C43v26Ev();
extern void _ZN7S1316C43v27Ev();
extern void _ZN7S1316C43v28Ev();
extern void _ZN7S1316C43v29Ev();
extern void _ZN7S1316C43v30Ev();
extern void _ZN7S1316C43v31Ev();
extern void _ZN7S1316C43v32Ev();
extern void _ZN7S1316C43v33Ev();
extern void _ZN7S1316C43v34Ev();
extern void _ZN7S1316C43v35Ev();
extern void _ZN7S1316C43v36Ev();
extern void _ZN7S1316C43v37Ev();
extern void _ZN7S1316C43v38Ev();
extern void _ZN7S1316C43v39Ev();
extern void _ZN7S1316C43v40Ev();
extern void _ZN7S1316C43v41Ev();
extern void _ZN7S1316C43v42Ev();
extern void _ZN7S1316C43v43Ev();
extern void _ZN7S1316C43v44Ev();
extern void _ZN7S1316C43v45Ev();
extern void _ZN7S1316C43v46Ev();
extern void _ZN7S1316C43v47Ev();
extern void _ZN7S1316C43v48Ev();
extern void _ZN7S1316C43v49Ev();
extern void _ZN7S1316C43v50Ev();
extern void _ZN7S1316C43v51Ev();
extern void _ZN7S1316C43v52Ev();
extern void _ZN7S1316C43v53Ev();
extern void _ZN7S1316C43v54Ev();
extern void _ZN7S1316C43v55Ev();
extern void _ZN7S1316C43v56Ev();
extern void _ZN7S1316C43v57Ev();
extern void _ZN7S1316C43v58Ev();
extern void _ZN7S1316C43v59Ev();
extern void _ZN7S1316C43v60Ev();
extern void _ZN7S1316C43v61Ev();
extern void _ZN7S1316C43v62Ev();
extern void _ZN7S1316C43v63Ev();
extern void _ZN7S1316C43v64Ev();
extern void _ZN7S1316C43v65Ev();
extern void _ZN7S1316C43v66Ev();
extern void _ZN7S1316C43v67Ev();
extern void _ZN7S1316C43v68Ev();
extern void _ZN7S1316C43v69Ev();
extern void _ZN7S1316C43v70Ev();
extern void _ZN7S1316C43v71Ev();
extern void _ZN7S1316C43v72Ev();
extern void _ZN7S1316C43v73Ev();
extern void _ZN7S1316C43v74Ev();
extern void _ZN7S1316C43v75Ev();
extern void _ZN7S1316C43v76Ev();
extern void _ZN7S1316C43v77Ev();
extern void _ZN7S1316C43v78Ev();
extern void _ZN10S1316C3_nt3v79Ev();
extern void _ZN10S1316C3_nt3v80Ev();
extern void _ZN10S1316C3_nt3v81Ev();
extern void _ZN7S1316C23v90Ev();
extern void _ZN7S1316C23v91Ev();
extern void _ZN7S1316C23v92Ev();
extern void _ZN7S1316C23v93Ev();
extern void _ZN7S1316C23v94Ev();
extern void _ZN7S1316C23v95Ev();
extern void _ZN7S1316C23v96Ev();
extern void _ZN7S1316C23v97Ev();
extern void _ZN7S1316C23v98Ev();
extern void _ZN7S1316C12v1Ev();
extern void _ZN7S1316C12v2Ev();
extern void _ZN7S1316C12v3Ev();
extern void _ZN7S1316C12v4Ev();
extern void _ZN7S1316C12v5Ev();
extern void _ZN7S1316C12v6Ev();
extern void _ZN7S1316C12v7Ev();
extern void _ZN7S1316C12v8Ev();
extern void _ZN7S1316C12v9Ev();
extern void _ZN7S1316C13v10Ev();
extern void _ZN7S1316C13v11Ev();
extern void _ZN7S1316C13v12Ev();
extern void _ZN7S1316C13v13Ev();
extern void _ZN7S1316C13v14Ev();
extern void _ZN11S1316C13_nt3v82Ev();
extern void _ZN11S1316C13_nt3v83Ev();
extern void _ZN11S1316C13_nt3v84Ev();
extern void _ZN11S1316C13_nt3v85Ev();
extern void _ZN11S1316C13_nt3v86Ev();
extern void _ZN11S1316C13_nt3v87Ev();
extern void _ZN11S1316C13_nt3v88Ev();
extern void _ZN11S1316C13_nt3v89Ev();
static  VTBL_ENTRY vtc_S1316C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1316C1[0]),
  (VTBL_ENTRY)&_ZN7S1316C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1316C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1316C43v78Ev,
  (VTBL_ENTRY)&_ZN10S1316C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1316C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1316C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1316C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1316C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1316C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1316C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1316C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1316C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1316C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1316C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1316C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1316C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1316C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1316C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1316C13v12Ev,
  (VTBL_ENTRY)&_ZN7S1316C13v13Ev,
  (VTBL_ENTRY)&_ZN7S1316C13v14Ev,
  ABISELECT(-216,-144),
  (VTBL_ENTRY)&(_ZTI7S1316C1[0]),
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v82Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v83Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v84Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v85Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v86Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v87Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v88Ev,
  (VTBL_ENTRY)&_ZN11S1316C13_nt3v89Ev,
};
extern VTBL_ENTRY _ZTI7S1316C1[];
extern  VTBL_ENTRY _ZTV7S1316C1[];
Class_Descriptor cd_S1316C1 = {  "S1316C1", // class name
  bases_S1316C1, 4,
  &(vtc_S1316C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,192), // object size
  NSPAIRA(_ZTI7S1316C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1316C1),104, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1314C4  {
  int s1314c4f0;
  __tsi64 s1314c4f1;
  void *s1314c4f2[4];
  int s1314c4f3[2];
  void *s1314c4f4;
  ::S1566C14_nt s1314c4f5;
  void *s1314c4f6[2];
  virtual  ~S1314C4(); // _ZN7S1314C4D1Ev
  virtual void  v14(); // _ZN7S1314C43v14Ev
  virtual void  v15(); // _ZN7S1314C43v15Ev
  virtual void  v16(); // _ZN7S1314C43v16Ev
  virtual void  v17(); // _ZN7S1314C43v17Ev
  virtual void  v18(); // _ZN7S1314C43v18Ev
  virtual void  v19(); // _ZN7S1314C43v19Ev
  virtual void  v20(); // _ZN7S1314C43v20Ev
  virtual void  v21(); // _ZN7S1314C43v21Ev
  virtual void  v22(); // _ZN7S1314C43v22Ev
  virtual void  v23(); // _ZN7S1314C43v23Ev
  virtual void  v24(); // _ZN7S1314C43v24Ev
  virtual void  v25(); // _ZN7S1314C43v25Ev
  virtual void  v26(); // _ZN7S1314C43v26Ev
  virtual void  v27(); // _ZN7S1314C43v27Ev
  virtual void  v28(); // _ZN7S1314C43v28Ev
  virtual void  v29(); // _ZN7S1314C43v29Ev
  virtual void  v30(); // _ZN7S1314C43v30Ev
  virtual void  v31(); // _ZN7S1314C43v31Ev
  virtual void  v32(); // _ZN7S1314C43v32Ev
  virtual void  v33(); // _ZN7S1314C43v33Ev
  virtual void  v34(); // _ZN7S1314C43v34Ev
  virtual void  v35(); // _ZN7S1314C43v35Ev
  virtual void  v36(); // _ZN7S1314C43v36Ev
  virtual void  v37(); // _ZN7S1314C43v37Ev
  virtual void  v38(); // _ZN7S1314C43v38Ev
  virtual void  v39(); // _ZN7S1314C43v39Ev
  virtual void  v40(); // _ZN7S1314C43v40Ev
  virtual void  v41(); // _ZN7S1314C43v41Ev
  virtual void  v42(); // _ZN7S1314C43v42Ev
  virtual void  v43(); // _ZN7S1314C43v43Ev
  virtual void  v44(); // _ZN7S1314C43v44Ev
  virtual void  v45(); // _ZN7S1314C43v45Ev
  virtual void  v46(); // _ZN7S1314C43v46Ev
  virtual void  v47(); // _ZN7S1314C43v47Ev
  virtual void  v48(); // _ZN7S1314C43v48Ev
  virtual void  v49(); // _ZN7S1314C43v49Ev
  virtual void  v50(); // _ZN7S1314C43v50Ev
  virtual void  v51(); // _ZN7S1314C43v51Ev
  virtual void  v52(); // _ZN7S1314C43v52Ev
  virtual void  v53(); // _ZN7S1314C43v53Ev
  virtual void  v54(); // _ZN7S1314C43v54Ev
  virtual void  v55(); // _ZN7S1314C43v55Ev
  virtual void  v56(); // _ZN7S1314C43v56Ev
  virtual void  v57(); // _ZN7S1314C43v57Ev
  virtual void  v58(); // _ZN7S1314C43v58Ev
  virtual void  v59(); // _ZN7S1314C43v59Ev
  virtual void  v60(); // _ZN7S1314C43v60Ev
  virtual void  v61(); // _ZN7S1314C43v61Ev
  virtual void  v62(); // _ZN7S1314C43v62Ev
  virtual void  v63(); // _ZN7S1314C43v63Ev
  virtual void  v64(); // _ZN7S1314C43v64Ev
  virtual void  v65(); // _ZN7S1314C43v65Ev
  virtual void  v66(); // _ZN7S1314C43v66Ev
  virtual void  v67(); // _ZN7S1314C43v67Ev
  virtual void  v68(); // _ZN7S1314C43v68Ev
  virtual void  v69(); // _ZN7S1314C43v69Ev
  virtual void  v70(); // _ZN7S1314C43v70Ev
  virtual void  v71(); // _ZN7S1314C43v71Ev
  virtual void  v72(); // _ZN7S1314C43v72Ev
  virtual void  v73(); // _ZN7S1314C43v73Ev
  virtual void  v74(); // _ZN7S1314C43v74Ev
  virtual void  v75(); // _ZN7S1314C43v75Ev
  virtual void  v76(); // _ZN7S1314C43v76Ev
  virtual void  v77(); // _ZN7S1314C43v77Ev
  S1314C4(); // tgen
};
//SIG(-1 S1314C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1314C4 ::~S1314C4(){ note_dtor("S1314C4", this);}
void  S1314C4 ::v14(){vfunc_called(this, "_ZN7S1314C43v14Ev");}
void  S1314C4 ::v15(){vfunc_called(this, "_ZN7S1314C43v15Ev");}
void  S1314C4 ::v16(){vfunc_called(this, "_ZN7S1314C43v16Ev");}
void  S1314C4 ::v17(){vfunc_called(this, "_ZN7S1314C43v17Ev");}
void  S1314C4 ::v18(){vfunc_called(this, "_ZN7S1314C43v18Ev");}
void  S1314C4 ::v19(){vfunc_called(this, "_ZN7S1314C43v19Ev");}
void  S1314C4 ::v20(){vfunc_called(this, "_ZN7S1314C43v20Ev");}
void  S1314C4 ::v21(){vfunc_called(this, "_ZN7S1314C43v21Ev");}
void  S1314C4 ::v22(){vfunc_called(this, "_ZN7S1314C43v22Ev");}
void  S1314C4 ::v23(){vfunc_called(this, "_ZN7S1314C43v23Ev");}
void  S1314C4 ::v24(){vfunc_called(this, "_ZN7S1314C43v24Ev");}
void  S1314C4 ::v25(){vfunc_called(this, "_ZN7S1314C43v25Ev");}
void  S1314C4 ::v26(){vfunc_called(this, "_ZN7S1314C43v26Ev");}
void  S1314C4 ::v27(){vfunc_called(this, "_ZN7S1314C43v27Ev");}
void  S1314C4 ::v28(){vfunc_called(this, "_ZN7S1314C43v28Ev");}
void  S1314C4 ::v29(){vfunc_called(this, "_ZN7S1314C43v29Ev");}
void  S1314C4 ::v30(){vfunc_called(this, "_ZN7S1314C43v30Ev");}
void  S1314C4 ::v31(){vfunc_called(this, "_ZN7S1314C43v31Ev");}
void  S1314C4 ::v32(){vfunc_called(this, "_ZN7S1314C43v32Ev");}
void  S1314C4 ::v33(){vfunc_called(this, "_ZN7S1314C43v33Ev");}
void  S1314C4 ::v34(){vfunc_called(this, "_ZN7S1314C43v34Ev");}
void  S1314C4 ::v35(){vfunc_called(this, "_ZN7S1314C43v35Ev");}
void  S1314C4 ::v36(){vfunc_called(this, "_ZN7S1314C43v36Ev");}
void  S1314C4 ::v37(){vfunc_called(this, "_ZN7S1314C43v37Ev");}
void  S1314C4 ::v38(){vfunc_called(this, "_ZN7S1314C43v38Ev");}
void  S1314C4 ::v39(){vfunc_called(this, "_ZN7S1314C43v39Ev");}
void  S1314C4 ::v40(){vfunc_called(this, "_ZN7S1314C43v40Ev");}
void  S1314C4 ::v41(){vfunc_called(this, "_ZN7S1314C43v41Ev");}
void  S1314C4 ::v42(){vfunc_called(this, "_ZN7S1314C43v42Ev");}
void  S1314C4 ::v43(){vfunc_called(this, "_ZN7S1314C43v43Ev");}
void  S1314C4 ::v44(){vfunc_called(this, "_ZN7S1314C43v44Ev");}
void  S1314C4 ::v45(){vfunc_called(this, "_ZN7S1314C43v45Ev");}
void  S1314C4 ::v46(){vfunc_called(this, "_ZN7S1314C43v46Ev");}
void  S1314C4 ::v47(){vfunc_called(this, "_ZN7S1314C43v47Ev");}
void  S1314C4 ::v48(){vfunc_called(this, "_ZN7S1314C43v48Ev");}
void  S1314C4 ::v49(){vfunc_called(this, "_ZN7S1314C43v49Ev");}
void  S1314C4 ::v50(){vfunc_called(this, "_ZN7S1314C43v50Ev");}
void  S1314C4 ::v51(){vfunc_called(this, "_ZN7S1314C43v51Ev");}
void  S1314C4 ::v52(){vfunc_called(this, "_ZN7S1314C43v52Ev");}
void  S1314C4 ::v53(){vfunc_called(this, "_ZN7S1314C43v53Ev");}
void  S1314C4 ::v54(){vfunc_called(this, "_ZN7S1314C43v54Ev");}
void  S1314C4 ::v55(){vfunc_called(this, "_ZN7S1314C43v55Ev");}
void  S1314C4 ::v56(){vfunc_called(this, "_ZN7S1314C43v56Ev");}
void  S1314C4 ::v57(){vfunc_called(this, "_ZN7S1314C43v57Ev");}
void  S1314C4 ::v58(){vfunc_called(this, "_ZN7S1314C43v58Ev");}
void  S1314C4 ::v59(){vfunc_called(this, "_ZN7S1314C43v59Ev");}
void  S1314C4 ::v60(){vfunc_called(this, "_ZN7S1314C43v60Ev");}
void  S1314C4 ::v61(){vfunc_called(this, "_ZN7S1314C43v61Ev");}
void  S1314C4 ::v62(){vfunc_called(this, "_ZN7S1314C43v62Ev");}
void  S1314C4 ::v63(){vfunc_called(this, "_ZN7S1314C43v63Ev");}
void  S1314C4 ::v64(){vfunc_called(this, "_ZN7S1314C43v64Ev");}
void  S1314C4 ::v65(){vfunc_called(this, "_ZN7S1314C43v65Ev");}
void  S1314C4 ::v66(){vfunc_called(this, "_ZN7S1314C43v66Ev");}
void  S1314C4 ::v67(){vfunc_called(this, "_ZN7S1314C43v67Ev");}
void  S1314C4 ::v68(){vfunc_called(this, "_ZN7S1314C43v68Ev");}
void  S1314C4 ::v69(){vfunc_called(this, "_ZN7S1314C43v69Ev");}
void  S1314C4 ::v70(){vfunc_called(this, "_ZN7S1314C43v70Ev");}
void  S1314C4 ::v71(){vfunc_called(this, "_ZN7S1314C43v71Ev");}
void  S1314C4 ::v72(){vfunc_called(this, "_ZN7S1314C43v72Ev");}
void  S1314C4 ::v73(){vfunc_called(this, "_ZN7S1314C43v73Ev");}
void  S1314C4 ::v74(){vfunc_called(this, "_ZN7S1314C43v74Ev");}
void  S1314C4 ::v75(){vfunc_called(this, "_ZN7S1314C43v75Ev");}
void  S1314C4 ::v76(){vfunc_called(this, "_ZN7S1314C43v76Ev");}
void  S1314C4 ::v77(){vfunc_called(this, "_ZN7S1314C43v77Ev");}
S1314C4 ::S1314C4(){ note_ctor("S1314C4", this);} // tgen

static void Test_S1314C4()
{
  extern Class_Descriptor cd_S1314C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1314C4, buf);
    S1314C4 *dp, &lv = *(dp=new (buf) S1314C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1314C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1314C4)");
    check_field_offset(lv, s1314c4f0, ABISELECT(8,4), "S1314C4.s1314c4f0");
    check_field_offset(lv, s1314c4f1, ABISELECT(16,8), "S1314C4.s1314c4f1");
    check_field_offset(lv, s1314c4f2, ABISELECT(24,16), "S1314C4.s1314c4f2");
    check_field_offset(lv, s1314c4f3, ABISELECT(56,32), "S1314C4.s1314c4f3");
    check_field_offset(lv, s1314c4f4, ABISELECT(64,40), "S1314C4.s1314c4f4");
    check_field_offset(lv, s1314c4f5, ABISELECT(72,44), "S1314C4.s1314c4f5");
    check_field_offset(lv, s1314c4f6, ABISELECT(80,52), "S1314C4.s1314c4f6");
    test_class_info(&lv, &cd_S1314C4);
    dp->~S1314C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1314C4(Test_S1314C4, "S1314C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1314C4C1Ev();
extern void _ZN7S1314C4D1Ev();
Name_Map name_map_S1314C4[] = {
  NSPAIR(_ZN7S1314C4C1Ev),
  NSPAIR(_ZN7S1314C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1314C4[];
extern void _ZN7S1314C4D1Ev();
extern void _ZN7S1314C4D0Ev();
extern void _ZN7S1314C43v14Ev();
extern void _ZN7S1314C43v15Ev();
extern void _ZN7S1314C43v16Ev();
extern void _ZN7S1314C43v17Ev();
extern void _ZN7S1314C43v18Ev();
extern void _ZN7S1314C43v19Ev();
extern void _ZN7S1314C43v20Ev();
extern void _ZN7S1314C43v21Ev();
extern void _ZN7S1314C43v22Ev();
extern void _ZN7S1314C43v23Ev();
extern void _ZN7S1314C43v24Ev();
extern void _ZN7S1314C43v25Ev();
extern void _ZN7S1314C43v26Ev();
extern void _ZN7S1314C43v27Ev();
extern void _ZN7S1314C43v28Ev();
extern void _ZN7S1314C43v29Ev();
extern void _ZN7S1314C43v30Ev();
extern void _ZN7S1314C43v31Ev();
extern void _ZN7S1314C43v32Ev();
extern void _ZN7S1314C43v33Ev();
extern void _ZN7S1314C43v34Ev();
extern void _ZN7S1314C43v35Ev();
extern void _ZN7S1314C43v36Ev();
extern void _ZN7S1314C43v37Ev();
extern void _ZN7S1314C43v38Ev();
extern void _ZN7S1314C43v39Ev();
extern void _ZN7S1314C43v40Ev();
extern void _ZN7S1314C43v41Ev();
extern void _ZN7S1314C43v42Ev();
extern void _ZN7S1314C43v43Ev();
extern void _ZN7S1314C43v44Ev();
extern void _ZN7S1314C43v45Ev();
extern void _ZN7S1314C43v46Ev();
extern void _ZN7S1314C43v47Ev();
extern void _ZN7S1314C43v48Ev();
extern void _ZN7S1314C43v49Ev();
extern void _ZN7S1314C43v50Ev();
extern void _ZN7S1314C43v51Ev();
extern void _ZN7S1314C43v52Ev();
extern void _ZN7S1314C43v53Ev();
extern void _ZN7S1314C43v54Ev();
extern void _ZN7S1314C43v55Ev();
extern void _ZN7S1314C43v56Ev();
extern void _ZN7S1314C43v57Ev();
extern void _ZN7S1314C43v58Ev();
extern void _ZN7S1314C43v59Ev();
extern void _ZN7S1314C43v60Ev();
extern void _ZN7S1314C43v61Ev();
extern void _ZN7S1314C43v62Ev();
extern void _ZN7S1314C43v63Ev();
extern void _ZN7S1314C43v64Ev();
extern void _ZN7S1314C43v65Ev();
extern void _ZN7S1314C43v66Ev();
extern void _ZN7S1314C43v67Ev();
extern void _ZN7S1314C43v68Ev();
extern void _ZN7S1314C43v69Ev();
extern void _ZN7S1314C43v70Ev();
extern void _ZN7S1314C43v71Ev();
extern void _ZN7S1314C43v72Ev();
extern void _ZN7S1314C43v73Ev();
extern void _ZN7S1314C43v74Ev();
extern void _ZN7S1314C43v75Ev();
extern void _ZN7S1314C43v76Ev();
extern void _ZN7S1314C43v77Ev();
static  VTBL_ENTRY vtc_S1314C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1314C4[0]),
  (VTBL_ENTRY)&_ZN7S1314C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1314C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v77Ev,
};
extern VTBL_ENTRY _ZTI7S1314C4[];
extern  VTBL_ENTRY _ZTV7S1314C4[];
Class_Descriptor cd_S1314C4 = {  "S1314C4", // class name
  0,0,//no base classes
  &(vtc_S1314C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1314C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1314C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1314C3  : S1314C4 {
  ::S1316C6_nt s1314c3f0;
  ::S1325C21 s1314c3f1;
  virtual  ~S1314C3(); // _ZN7S1314C3D1Ev
  virtual void  v78(); // _ZN7S1314C33v78Ev
  virtual void  v79(); // _ZN7S1314C33v79Ev
  virtual void  v80(); // _ZN7S1314C33v80Ev
  S1314C3(); // tgen
};
//SIG(-1 S1314C3) C1{ BC2{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 FC4{ BC5{ BC6{ m Fp Fi[2]}} Fp} FC7{ m FC8{ BC9{ BC6}} FC8 Fi FC8 FC10{ BC6} FC8 Fi}}


 S1314C3 ::~S1314C3(){ note_dtor("S1314C3", this);}
void  S1314C3 ::v78(){vfunc_called(this, "_ZN7S1314C33v78Ev");}
void  S1314C3 ::v79(){vfunc_called(this, "_ZN7S1314C33v79Ev");}
void  S1314C3 ::v80(){vfunc_called(this, "_ZN7S1314C33v80Ev");}
S1314C3 ::S1314C3(){ note_ctor("S1314C3", this);} // tgen

static void Test_S1314C3()
{
  extern Class_Descriptor cd_S1314C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,37)];
    init_test(&cd_S1314C3, buf);
    S1314C3 *dp, &lv = *(dp=new (buf) S1314C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,144), "sizeof(S1314C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1314C3)");
    check_base_class_offset(lv, (S1314C4*), 0, "S1314C3");
    check_field_offset(lv, s1314c3f0, ABISELECT(96,60), "S1314C3.s1314c3f0");
    check_field_offset(lv, s1314c3f1, ABISELECT(120,76), "S1314C3.s1314c3f1");
    test_class_info(&lv, &cd_S1314C3);
    dp->~S1314C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1314C3(Test_S1314C3, "S1314C3", ABISELECT(216,144));

#else // __cplusplus

extern void _ZN7S1314C3C1Ev();
extern void _ZN7S1314C3D1Ev();
Name_Map name_map_S1314C3[] = {
  NSPAIR(_ZN7S1314C3C1Ev),
  NSPAIR(_ZN7S1314C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1314C4;
extern VTBL_ENTRY _ZTI7S1314C4[];
extern  VTBL_ENTRY _ZTV7S1314C4[];
static Base_Class bases_S1314C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1314C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1314C3[];
extern void _ZN7S1314C3D1Ev();
extern void _ZN7S1314C3D0Ev();
extern void _ZN7S1314C43v14Ev();
extern void _ZN7S1314C43v15Ev();
extern void _ZN7S1314C43v16Ev();
extern void _ZN7S1314C43v17Ev();
extern void _ZN7S1314C43v18Ev();
extern void _ZN7S1314C43v19Ev();
extern void _ZN7S1314C43v20Ev();
extern void _ZN7S1314C43v21Ev();
extern void _ZN7S1314C43v22Ev();
extern void _ZN7S1314C43v23Ev();
extern void _ZN7S1314C43v24Ev();
extern void _ZN7S1314C43v25Ev();
extern void _ZN7S1314C43v26Ev();
extern void _ZN7S1314C43v27Ev();
extern void _ZN7S1314C43v28Ev();
extern void _ZN7S1314C43v29Ev();
extern void _ZN7S1314C43v30Ev();
extern void _ZN7S1314C43v31Ev();
extern void _ZN7S1314C43v32Ev();
extern void _ZN7S1314C43v33Ev();
extern void _ZN7S1314C43v34Ev();
extern void _ZN7S1314C43v35Ev();
extern void _ZN7S1314C43v36Ev();
extern void _ZN7S1314C43v37Ev();
extern void _ZN7S1314C43v38Ev();
extern void _ZN7S1314C43v39Ev();
extern void _ZN7S1314C43v40Ev();
extern void _ZN7S1314C43v41Ev();
extern void _ZN7S1314C43v42Ev();
extern void _ZN7S1314C43v43Ev();
extern void _ZN7S1314C43v44Ev();
extern void _ZN7S1314C43v45Ev();
extern void _ZN7S1314C43v46Ev();
extern void _ZN7S1314C43v47Ev();
extern void _ZN7S1314C43v48Ev();
extern void _ZN7S1314C43v49Ev();
extern void _ZN7S1314C43v50Ev();
extern void _ZN7S1314C43v51Ev();
extern void _ZN7S1314C43v52Ev();
extern void _ZN7S1314C43v53Ev();
extern void _ZN7S1314C43v54Ev();
extern void _ZN7S1314C43v55Ev();
extern void _ZN7S1314C43v56Ev();
extern void _ZN7S1314C43v57Ev();
extern void _ZN7S1314C43v58Ev();
extern void _ZN7S1314C43v59Ev();
extern void _ZN7S1314C43v60Ev();
extern void _ZN7S1314C43v61Ev();
extern void _ZN7S1314C43v62Ev();
extern void _ZN7S1314C43v63Ev();
extern void _ZN7S1314C43v64Ev();
extern void _ZN7S1314C43v65Ev();
extern void _ZN7S1314C43v66Ev();
extern void _ZN7S1314C43v67Ev();
extern void _ZN7S1314C43v68Ev();
extern void _ZN7S1314C43v69Ev();
extern void _ZN7S1314C43v70Ev();
extern void _ZN7S1314C43v71Ev();
extern void _ZN7S1314C43v72Ev();
extern void _ZN7S1314C43v73Ev();
extern void _ZN7S1314C43v74Ev();
extern void _ZN7S1314C43v75Ev();
extern void _ZN7S1314C43v76Ev();
extern void _ZN7S1314C43v77Ev();
extern void _ZN7S1314C33v78Ev();
extern void _ZN7S1314C33v79Ev();
extern void _ZN7S1314C33v80Ev();
static  VTBL_ENTRY vtc_S1314C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1314C3[0]),
  (VTBL_ENTRY)&_ZN7S1314C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1314C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1314C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1314C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1314C33v80Ev,
};
extern VTBL_ENTRY _ZTI7S1314C3[];
extern  VTBL_ENTRY _ZTV7S1314C3[];
Class_Descriptor cd_S1314C3 = {  "S1314C3", // class name
  bases_S1314C3, 1,
  &(vtc_S1314C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,144), // object size
  NSPAIRA(_ZTI7S1314C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1314C3),71, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1314C13  {
  virtual void  v81(); // _ZN8S1314C133v81Ev
  virtual void  v82(); // _ZN8S1314C133v82Ev
  virtual void  v83(); // _ZN8S1314C133v83Ev
  virtual void  v84(); // _ZN8S1314C133v84Ev
  virtual void  v85(); // _ZN8S1314C133v85Ev
  virtual void  v86(); // _ZN8S1314C133v86Ev
  virtual void  v87(); // _ZN8S1314C133v87Ev
  virtual void  v88(); // _ZN8S1314C133v88Ev
  ~S1314C13(); // tgen
  S1314C13(); // tgen
};
//SIG(-1 S1314C13) C1{ v1 v2 v3 v4 v5 v6 v7 v8}


void  S1314C13 ::v81(){vfunc_called(this, "_ZN8S1314C133v81Ev");}
void  S1314C13 ::v82(){vfunc_called(this, "_ZN8S1314C133v82Ev");}
void  S1314C13 ::v83(){vfunc_called(this, "_ZN8S1314C133v83Ev");}
void  S1314C13 ::v84(){vfunc_called(this, "_ZN8S1314C133v84Ev");}
void  S1314C13 ::v85(){vfunc_called(this, "_ZN8S1314C133v85Ev");}
void  S1314C13 ::v86(){vfunc_called(this, "_ZN8S1314C133v86Ev");}
void  S1314C13 ::v87(){vfunc_called(this, "_ZN8S1314C133v87Ev");}
void  S1314C13 ::v88(){vfunc_called(this, "_ZN8S1314C133v88Ev");}
S1314C13 ::~S1314C13(){ note_dtor("S1314C13", this);} // tgen
S1314C13 ::S1314C13(){ note_ctor("S1314C13", this);} // tgen

static void Test_S1314C13()
{
  extern Class_Descriptor cd_S1314C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1314C13, buf);
    S1314C13 *dp, &lv = *(dp=new (buf) S1314C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1314C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1314C13)");
    test_class_info(&lv, &cd_S1314C13);
    dp->~S1314C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1314C13(Test_S1314C13, "S1314C13", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S1314C13C1Ev();
extern void _ZN8S1314C13D1Ev();
Name_Map name_map_S1314C13[] = {
  NSPAIR(_ZN8S1314C13C1Ev),
  NSPAIR(_ZN8S1314C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1314C13[];
extern void _ZN8S1314C133v81Ev();
extern void _ZN8S1314C133v82Ev();
extern void _ZN8S1314C133v83Ev();
extern void _ZN8S1314C133v84Ev();
extern void _ZN8S1314C133v85Ev();
extern void _ZN8S1314C133v86Ev();
extern void _ZN8S1314C133v87Ev();
extern void _ZN8S1314C133v88Ev();
static  VTBL_ENTRY vtc_S1314C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1314C13[0]),
  (VTBL_ENTRY)&_ZN8S1314C133v81Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v82Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v83Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v84Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v85Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v86Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v87Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v88Ev,
};
extern VTBL_ENTRY _ZTI8S1314C13[];
extern  VTBL_ENTRY _ZTV8S1314C13[];
Class_Descriptor cd_S1314C13 = {  "S1314C13", // class name
  0,0,//no base classes
  &(vtc_S1314C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S1314C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1314C13),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1314C2  : S1314C3 , S1314C13 {
  void *s1314c2f0[2];
  int s1314c2f1[3];
  ::S1566C9 s1314c2f2;
  ::S1566C29 s1314c2f3;
  virtual  ~S1314C2(); // _ZN7S1314C2D1Ev
  virtual void  v89(); // _ZN7S1314C23v89Ev
  virtual void  v90(); // _ZN7S1314C23v90Ev
  virtual void  v91(); // _ZN7S1314C23v91Ev
  virtual void  v92(); // _ZN7S1314C23v92Ev
  virtual void  v93(); // _ZN7S1314C23v93Ev
  virtual void  v94(); // _ZN7S1314C23v94Ev
  virtual void  v95(); // _ZN7S1314C23v95Ev
  virtual void  v96(); // _ZN7S1314C23v96Ev
  virtual void  v97(); // _ZN7S1314C23v97Ev
  S1314C2(); // tgen
};
//SIG(-1 S1314C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v74 v75 v76 FC5{ BC6{ BC7{ m Fp Fi[2]}} Fp} FC8{ m FC9{ BC10{ BC7}} FC9 Fi FC9 FC11{ BC7} FC9 Fi}} BC12{ v77 v78 v79 v80 v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp[2] Fi[3] FC13{ BC14{ BC7}} FC15{ BC7}}


 S1314C2 ::~S1314C2(){ note_dtor("S1314C2", this);}
void  S1314C2 ::v89(){vfunc_called(this, "_ZN7S1314C23v89Ev");}
void  S1314C2 ::v90(){vfunc_called(this, "_ZN7S1314C23v90Ev");}
void  S1314C2 ::v91(){vfunc_called(this, "_ZN7S1314C23v91Ev");}
void  S1314C2 ::v92(){vfunc_called(this, "_ZN7S1314C23v92Ev");}
void  S1314C2 ::v93(){vfunc_called(this, "_ZN7S1314C23v93Ev");}
void  S1314C2 ::v94(){vfunc_called(this, "_ZN7S1314C23v94Ev");}
void  S1314C2 ::v95(){vfunc_called(this, "_ZN7S1314C23v95Ev");}
void  S1314C2 ::v96(){vfunc_called(this, "_ZN7S1314C23v96Ev");}
void  S1314C2 ::v97(){vfunc_called(this, "_ZN7S1314C23v97Ev");}
S1314C2 ::S1314C2(){ note_ctor("S1314C2", this);} // tgen

static void Test_S1314C2()
{
  extern Class_Descriptor cd_S1314C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,49)];
    init_test(&cd_S1314C2, buf);
    S1314C2 *dp, &lv = *(dp=new (buf) S1314C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,192), "sizeof(S1314C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1314C2)");
    check_base_class_offset(lv, (S1314C4*)(S1314C3*), 0, "S1314C2");
    check_base_class_offset(lv, (S1314C3*), 0, "S1314C2");
    check_base_class_offset(lv, (S1314C13*), ABISELECT(216,144), "S1314C2");
    check_field_offset(lv, s1314c2f0, ABISELECT(224,148), "S1314C2.s1314c2f0");
    check_field_offset(lv, s1314c2f1, ABISELECT(240,156), "S1314C2.s1314c2f1");
    check_field_offset(lv, s1314c2f2, ABISELECT(256,168), "S1314C2.s1314c2f2");
    check_field_offset(lv, s1314c2f3, ABISELECT(272,180), "S1314C2.s1314c2f3");
    test_class_info(&lv, &cd_S1314C2);
    dp->~S1314C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1314C2(Test_S1314C2, "S1314C2", ABISELECT(288,192));

#else // __cplusplus

extern void _ZN7S1314C2C1Ev();
extern void _ZN7S1314C2D1Ev();
Name_Map name_map_S1314C2[] = {
  NSPAIR(_ZN7S1314C2C1Ev),
  NSPAIR(_ZN7S1314C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1314C4;
extern VTBL_ENTRY _ZTI7S1314C4[];
extern  VTBL_ENTRY _ZTV7S1314C4[];
extern Class_Descriptor cd_S1314C3;
extern VTBL_ENTRY _ZTI7S1314C3[];
extern  VTBL_ENTRY _ZTV7S1314C3[];
extern Class_Descriptor cd_S1314C13;
extern VTBL_ENTRY _ZTI8S1314C13[];
extern  VTBL_ENTRY _ZTV8S1314C13[];
static Base_Class bases_S1314C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1314C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1314C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1314C13,    ABISELECT(216,144), //bcp->offset
    80, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1314C2[];
extern void _ZN7S1314C2D1Ev();
extern void _ZN7S1314C2D0Ev();
extern void _ZN7S1314C43v14Ev();
extern void _ZN7S1314C43v15Ev();
extern void _ZN7S1314C43v16Ev();
extern void _ZN7S1314C43v17Ev();
extern void _ZN7S1314C43v18Ev();
extern void _ZN7S1314C43v19Ev();
extern void _ZN7S1314C43v20Ev();
extern void _ZN7S1314C43v21Ev();
extern void _ZN7S1314C43v22Ev();
extern void _ZN7S1314C43v23Ev();
extern void _ZN7S1314C43v24Ev();
extern void _ZN7S1314C43v25Ev();
extern void _ZN7S1314C43v26Ev();
extern void _ZN7S1314C43v27Ev();
extern void _ZN7S1314C43v28Ev();
extern void _ZN7S1314C43v29Ev();
extern void _ZN7S1314C43v30Ev();
extern void _ZN7S1314C43v31Ev();
extern void _ZN7S1314C43v32Ev();
extern void _ZN7S1314C43v33Ev();
extern void _ZN7S1314C43v34Ev();
extern void _ZN7S1314C43v35Ev();
extern void _ZN7S1314C43v36Ev();
extern void _ZN7S1314C43v37Ev();
extern void _ZN7S1314C43v38Ev();
extern void _ZN7S1314C43v39Ev();
extern void _ZN7S1314C43v40Ev();
extern void _ZN7S1314C43v41Ev();
extern void _ZN7S1314C43v42Ev();
extern void _ZN7S1314C43v43Ev();
extern void _ZN7S1314C43v44Ev();
extern void _ZN7S1314C43v45Ev();
extern void _ZN7S1314C43v46Ev();
extern void _ZN7S1314C43v47Ev();
extern void _ZN7S1314C43v48Ev();
extern void _ZN7S1314C43v49Ev();
extern void _ZN7S1314C43v50Ev();
extern void _ZN7S1314C43v51Ev();
extern void _ZN7S1314C43v52Ev();
extern void _ZN7S1314C43v53Ev();
extern void _ZN7S1314C43v54Ev();
extern void _ZN7S1314C43v55Ev();
extern void _ZN7S1314C43v56Ev();
extern void _ZN7S1314C43v57Ev();
extern void _ZN7S1314C43v58Ev();
extern void _ZN7S1314C43v59Ev();
extern void _ZN7S1314C43v60Ev();
extern void _ZN7S1314C43v61Ev();
extern void _ZN7S1314C43v62Ev();
extern void _ZN7S1314C43v63Ev();
extern void _ZN7S1314C43v64Ev();
extern void _ZN7S1314C43v65Ev();
extern void _ZN7S1314C43v66Ev();
extern void _ZN7S1314C43v67Ev();
extern void _ZN7S1314C43v68Ev();
extern void _ZN7S1314C43v69Ev();
extern void _ZN7S1314C43v70Ev();
extern void _ZN7S1314C43v71Ev();
extern void _ZN7S1314C43v72Ev();
extern void _ZN7S1314C43v73Ev();
extern void _ZN7S1314C43v74Ev();
extern void _ZN7S1314C43v75Ev();
extern void _ZN7S1314C43v76Ev();
extern void _ZN7S1314C43v77Ev();
extern void _ZN7S1314C33v78Ev();
extern void _ZN7S1314C33v79Ev();
extern void _ZN7S1314C33v80Ev();
extern void _ZN7S1314C23v89Ev();
extern void _ZN7S1314C23v90Ev();
extern void _ZN7S1314C23v91Ev();
extern void _ZN7S1314C23v92Ev();
extern void _ZN7S1314C23v93Ev();
extern void _ZN7S1314C23v94Ev();
extern void _ZN7S1314C23v95Ev();
extern void _ZN7S1314C23v96Ev();
extern void _ZN7S1314C23v97Ev();
extern void _ZN8S1314C133v81Ev();
extern void _ZN8S1314C133v82Ev();
extern void _ZN8S1314C133v83Ev();
extern void _ZN8S1314C133v84Ev();
extern void _ZN8S1314C133v85Ev();
extern void _ZN8S1314C133v86Ev();
extern void _ZN8S1314C133v87Ev();
extern void _ZN8S1314C133v88Ev();
static  VTBL_ENTRY vtc_S1314C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1314C2[0]),
  (VTBL_ENTRY)&_ZN7S1314C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1314C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1314C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1314C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1314C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v97Ev,
  ABISELECT(-216,-144),
  (VTBL_ENTRY)&(_ZTI7S1314C2[0]),
  (VTBL_ENTRY)&_ZN8S1314C133v81Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v82Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v83Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v84Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v85Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v86Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v87Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v88Ev,
};
extern VTBL_ENTRY _ZTI7S1314C2[];
extern  VTBL_ENTRY _ZTV7S1314C2[];
Class_Descriptor cd_S1314C2 = {  "S1314C2", // class name
  bases_S1314C2, 3,
  &(vtc_S1314C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,192), // object size
  NSPAIRA(_ZTI7S1314C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1314C2),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1314C1  : S1314C2 {
  virtual  ~S1314C1(); // _ZN7S1314C1D1Ev
  virtual void  v1(); // _ZN7S1314C12v1Ev
  virtual void  v2(); // _ZN7S1314C12v2Ev
  virtual void  v3(); // _ZN7S1314C12v3Ev
  virtual void  v4(); // _ZN7S1314C12v4Ev
  virtual void  v5(); // _ZN7S1314C12v5Ev
  virtual void  v6(); // _ZN7S1314C12v6Ev
  virtual void  v7(); // _ZN7S1314C12v7Ev
  virtual void  v8(); // _ZN7S1314C12v8Ev
  virtual void  v9(); // _ZN7S1314C12v9Ev
  virtual void  v10(); // _ZN7S1314C13v10Ev
  virtual void  v11(); // _ZN7S1314C13v11Ev
  virtual void  v12(); // _ZN7S1314C13v12Ev
  virtual void  v13(); // _ZN7S1314C13v13Ev
  S1314C1(); // tgen
};
//SIG(1 S1314C1) C1{ BC2{ BC3{ BC4{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v78 v79 v80 FC6{ BC7{ BC8{ m Fp Fi[2]}} Fp} FC9{ m FC10{ BC11{ BC8}} FC10 Fi FC10 FC12{ BC8} FC10 Fi}} BC13{ v81 v82 v83 v84 v85 v86 v87 v88} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 Fp[2] Fi[3] FC14{ BC15{ BC8}} FC16{ BC8}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13}


 S1314C1 ::~S1314C1(){ note_dtor("S1314C1", this);}
void  S1314C1 ::v1(){vfunc_called(this, "_ZN7S1314C12v1Ev");}
void  S1314C1 ::v2(){vfunc_called(this, "_ZN7S1314C12v2Ev");}
void  S1314C1 ::v3(){vfunc_called(this, "_ZN7S1314C12v3Ev");}
void  S1314C1 ::v4(){vfunc_called(this, "_ZN7S1314C12v4Ev");}
void  S1314C1 ::v5(){vfunc_called(this, "_ZN7S1314C12v5Ev");}
void  S1314C1 ::v6(){vfunc_called(this, "_ZN7S1314C12v6Ev");}
void  S1314C1 ::v7(){vfunc_called(this, "_ZN7S1314C12v7Ev");}
void  S1314C1 ::v8(){vfunc_called(this, "_ZN7S1314C12v8Ev");}
void  S1314C1 ::v9(){vfunc_called(this, "_ZN7S1314C12v9Ev");}
void  S1314C1 ::v10(){vfunc_called(this, "_ZN7S1314C13v10Ev");}
void  S1314C1 ::v11(){vfunc_called(this, "_ZN7S1314C13v11Ev");}
void  S1314C1 ::v12(){vfunc_called(this, "_ZN7S1314C13v12Ev");}
void  S1314C1 ::v13(){vfunc_called(this, "_ZN7S1314C13v13Ev");}
S1314C1 ::S1314C1(){ note_ctor("S1314C1", this);} // tgen

static void Test_S1314C1()
{
  extern Class_Descriptor cd_S1314C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,49)];
    init_test(&cd_S1314C1, buf);
    S1314C1 *dp, &lv = *(dp=new (buf) S1314C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,192), "sizeof(S1314C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1314C1)");
    check_base_class_offset(lv, (S1314C4*)(S1314C3*)(S1314C2*), 0, "S1314C1");
    check_base_class_offset(lv, (S1314C3*)(S1314C2*), 0, "S1314C1");
    check_base_class_offset(lv, (S1314C13*)(S1314C2*), ABISELECT(216,144), "S1314C1");
    check_base_class_offset(lv, (S1314C2*), 0, "S1314C1");
    test_class_info(&lv, &cd_S1314C1);
    dp->~S1314C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1314C1(Test_S1314C1, "S1314C1", ABISELECT(288,192));

#else // __cplusplus

extern void _ZN7S1314C1C1Ev();
extern void _ZN7S1314C1D1Ev();
Name_Map name_map_S1314C1[] = {
  NSPAIR(_ZN7S1314C1C1Ev),
  NSPAIR(_ZN7S1314C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1314C4;
extern VTBL_ENTRY _ZTI7S1314C4[];
extern  VTBL_ENTRY _ZTV7S1314C4[];
extern Class_Descriptor cd_S1314C3;
extern VTBL_ENTRY _ZTI7S1314C3[];
extern  VTBL_ENTRY _ZTV7S1314C3[];
extern Class_Descriptor cd_S1314C13;
extern VTBL_ENTRY _ZTI8S1314C13[];
extern  VTBL_ENTRY _ZTV8S1314C13[];
extern Class_Descriptor cd_S1314C2;
extern VTBL_ENTRY _ZTI7S1314C2[];
extern  VTBL_ENTRY _ZTV7S1314C2[];
static Base_Class bases_S1314C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1314C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1314C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1314C13,    ABISELECT(216,144), //bcp->offset
    93, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1314C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1314C1[];
extern void _ZN7S1314C1D1Ev();
extern void _ZN7S1314C1D0Ev();
extern void _ZN7S1314C43v14Ev();
extern void _ZN7S1314C43v15Ev();
extern void _ZN7S1314C43v16Ev();
extern void _ZN7S1314C43v17Ev();
extern void _ZN7S1314C43v18Ev();
extern void _ZN7S1314C43v19Ev();
extern void _ZN7S1314C43v20Ev();
extern void _ZN7S1314C43v21Ev();
extern void _ZN7S1314C43v22Ev();
extern void _ZN7S1314C43v23Ev();
extern void _ZN7S1314C43v24Ev();
extern void _ZN7S1314C43v25Ev();
extern void _ZN7S1314C43v26Ev();
extern void _ZN7S1314C43v27Ev();
extern void _ZN7S1314C43v28Ev();
extern void _ZN7S1314C43v29Ev();
extern void _ZN7S1314C43v30Ev();
extern void _ZN7S1314C43v31Ev();
extern void _ZN7S1314C43v32Ev();
extern void _ZN7S1314C43v33Ev();
extern void _ZN7S1314C43v34Ev();
extern void _ZN7S1314C43v35Ev();
extern void _ZN7S1314C43v36Ev();
extern void _ZN7S1314C43v37Ev();
extern void _ZN7S1314C43v38Ev();
extern void _ZN7S1314C43v39Ev();
extern void _ZN7S1314C43v40Ev();
extern void _ZN7S1314C43v41Ev();
extern void _ZN7S1314C43v42Ev();
extern void _ZN7S1314C43v43Ev();
extern void _ZN7S1314C43v44Ev();
extern void _ZN7S1314C43v45Ev();
extern void _ZN7S1314C43v46Ev();
extern void _ZN7S1314C43v47Ev();
extern void _ZN7S1314C43v48Ev();
extern void _ZN7S1314C43v49Ev();
extern void _ZN7S1314C43v50Ev();
extern void _ZN7S1314C43v51Ev();
extern void _ZN7S1314C43v52Ev();
extern void _ZN7S1314C43v53Ev();
extern void _ZN7S1314C43v54Ev();
extern void _ZN7S1314C43v55Ev();
extern void _ZN7S1314C43v56Ev();
extern void _ZN7S1314C43v57Ev();
extern void _ZN7S1314C43v58Ev();
extern void _ZN7S1314C43v59Ev();
extern void _ZN7S1314C43v60Ev();
extern void _ZN7S1314C43v61Ev();
extern void _ZN7S1314C43v62Ev();
extern void _ZN7S1314C43v63Ev();
extern void _ZN7S1314C43v64Ev();
extern void _ZN7S1314C43v65Ev();
extern void _ZN7S1314C43v66Ev();
extern void _ZN7S1314C43v67Ev();
extern void _ZN7S1314C43v68Ev();
extern void _ZN7S1314C43v69Ev();
extern void _ZN7S1314C43v70Ev();
extern void _ZN7S1314C43v71Ev();
extern void _ZN7S1314C43v72Ev();
extern void _ZN7S1314C43v73Ev();
extern void _ZN7S1314C43v74Ev();
extern void _ZN7S1314C43v75Ev();
extern void _ZN7S1314C43v76Ev();
extern void _ZN7S1314C43v77Ev();
extern void _ZN7S1314C33v78Ev();
extern void _ZN7S1314C33v79Ev();
extern void _ZN7S1314C33v80Ev();
extern void _ZN7S1314C23v89Ev();
extern void _ZN7S1314C23v90Ev();
extern void _ZN7S1314C23v91Ev();
extern void _ZN7S1314C23v92Ev();
extern void _ZN7S1314C23v93Ev();
extern void _ZN7S1314C23v94Ev();
extern void _ZN7S1314C23v95Ev();
extern void _ZN7S1314C23v96Ev();
extern void _ZN7S1314C23v97Ev();
extern void _ZN7S1314C12v1Ev();
extern void _ZN7S1314C12v2Ev();
extern void _ZN7S1314C12v3Ev();
extern void _ZN7S1314C12v4Ev();
extern void _ZN7S1314C12v5Ev();
extern void _ZN7S1314C12v6Ev();
extern void _ZN7S1314C12v7Ev();
extern void _ZN7S1314C12v8Ev();
extern void _ZN7S1314C12v9Ev();
extern void _ZN7S1314C13v10Ev();
extern void _ZN7S1314C13v11Ev();
extern void _ZN7S1314C13v12Ev();
extern void _ZN7S1314C13v13Ev();
extern void _ZN8S1314C133v81Ev();
extern void _ZN8S1314C133v82Ev();
extern void _ZN8S1314C133v83Ev();
extern void _ZN8S1314C133v84Ev();
extern void _ZN8S1314C133v85Ev();
extern void _ZN8S1314C133v86Ev();
extern void _ZN8S1314C133v87Ev();
extern void _ZN8S1314C133v88Ev();
static  VTBL_ENTRY vtc_S1314C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1314C1[0]),
  (VTBL_ENTRY)&_ZN7S1314C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1314C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1314C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1314C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1314C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1314C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1314C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1314C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1314C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1314C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1314C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1314C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1314C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1314C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1314C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1314C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1314C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1314C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1314C13v12Ev,
  (VTBL_ENTRY)&_ZN7S1314C13v13Ev,
  ABISELECT(-216,-144),
  (VTBL_ENTRY)&(_ZTI7S1314C1[0]),
  (VTBL_ENTRY)&_ZN8S1314C133v81Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v82Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v83Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v84Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v85Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v86Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v87Ev,
  (VTBL_ENTRY)&_ZN8S1314C133v88Ev,
};
extern VTBL_ENTRY _ZTI7S1314C1[];
extern  VTBL_ENTRY _ZTV7S1314C1[];
Class_Descriptor cd_S1314C1 = {  "S1314C1", // class name
  bases_S1314C1, 4,
  &(vtc_S1314C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,192), // object size
  NSPAIRA(_ZTI7S1314C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1314C1),103, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C6_nt  {
  virtual  ~S19426C6_nt(); // _ZN11S19426C6_ntD1Ev
  virtual void  v7(); // _ZN11S19426C6_nt2v7Ev
  S19426C6_nt(); // tgen
};
//SIG(-1 S19426C6_nt) C1{ vd v1}


 S19426C6_nt ::~S19426C6_nt(){ note_dtor("S19426C6_nt", this);}
void  S19426C6_nt ::v7(){vfunc_called(this, "_ZN11S19426C6_nt2v7Ev");}
S19426C6_nt ::S19426C6_nt(){ note_ctor("S19426C6_nt", this);} // tgen

//skip512 S19426C6_nt

#else // __cplusplus

extern void _ZN11S19426C6_ntC1Ev();
extern void _ZN11S19426C6_ntD1Ev();
Name_Map name_map_S19426C6_nt[] = {
  NSPAIR(_ZN11S19426C6_ntC1Ev),
  NSPAIR(_ZN11S19426C6_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern void _ZN11S19426C6_ntD1Ev();
extern void _ZN11S19426C6_ntD0Ev();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY vtc_S19426C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S19426C6_nt[0]),
  (VTBL_ENTRY)&_ZN11S19426C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S19426C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
VTBL_ENTRY *P__ZTI11S19426C6_nt = _ZTI11S19426C6_nt; 
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
Class_Descriptor cd_S19426C6_nt = {  "S19426C6_nt", // class name
  0,0,//no base classes
  &(vtc_S19426C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S19426C6_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S19426C6_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C5_nt  : S19426C6_nt {
  virtual  ~S19426C5_nt(); // _ZN11S19426C5_ntD1Ev
  virtual void  v8(); // _ZN11S19426C5_nt2v8Ev
  S19426C5_nt(); // tgen
};
//SIG(-1 S19426C5_nt) C1{ BC2{ vd v2} vd v1}


 S19426C5_nt ::~S19426C5_nt(){ note_dtor("S19426C5_nt", this);}
void  S19426C5_nt ::v8(){vfunc_called(this, "_ZN11S19426C5_nt2v8Ev");}
S19426C5_nt ::S19426C5_nt(){ note_ctor("S19426C5_nt", this);} // tgen

//skip512 S19426C5_nt

#else // __cplusplus

extern void _ZN11S19426C5_ntC1Ev();
extern void _ZN11S19426C5_ntD1Ev();
Name_Map name_map_S19426C5_nt[] = {
  NSPAIR(_ZN11S19426C5_ntC1Ev),
  NSPAIR(_ZN11S19426C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
static Base_Class bases_S19426C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern void _ZN11S19426C5_ntD1Ev();
extern void _ZN11S19426C5_ntD0Ev();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
static  VTBL_ENTRY vtc_S19426C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S19426C5_nt[0]),
  (VTBL_ENTRY)&_ZN11S19426C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
};
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
VTBL_ENTRY *P__ZTI11S19426C5_nt = _ZTI11S19426C5_nt; 
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
Class_Descriptor cd_S19426C5_nt = {  "S19426C5_nt", // class name
  bases_S19426C5_nt, 1,
  &(vtc_S19426C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S19426C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV11S19426C5_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C4  : S19426C5_nt , S19426C6_nt {
  virtual  ~S19426C4(); // _ZN8S19426C4D1Ev
  virtual void  v9(); // _ZN8S19426C42v9Ev
  virtual void  v10(); // _ZN8S19426C43v10Ev
  S19426C4(); // tgen
};
//SIG(-1 S19426C4) C1{ BC2{ BC3{ vd v3} vd v4} BC3 vd v1 v2}


 S19426C4 ::~S19426C4(){ note_dtor("S19426C4", this);}
void  S19426C4 ::v9(){vfunc_called(this, "_ZN8S19426C42v9Ev");}
void  S19426C4 ::v10(){vfunc_called(this, "_ZN8S19426C43v10Ev");}
S19426C4 ::S19426C4(){ note_ctor("S19426C4", this);} // tgen

static void Test_S19426C4()
{
  extern Class_Descriptor cd_S19426C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S19426C4, buf);
    S19426C4 *dp, &lv = *(dp=new (buf) S19426C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S19426C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C4)");
    check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*), 0, "S19426C4");
    check_base_class_offset(lv, (S19426C5_nt*), 0, "S19426C4");
    /*is_ambiguous_... S19426C4::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*), ABISELECT(8,4), "S19426C4");
    test_class_info(&lv, &cd_S19426C4);
    dp->~S19426C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C4(Test_S19426C4, "S19426C4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S19426C4C1Ev();
extern void _ZN8S19426C4D1Ev();
Name_Map name_map_S19426C4[] = {
  NSPAIR(_ZN8S19426C4C1Ev),
  NSPAIR(_ZN8S19426C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
static Base_Class bases_S19426C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19426C6_nt,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19426C4[];
extern void _ZN8S19426C4D1Ev();
extern void _ZN8S19426C4D0Ev();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void ABISELECT(_ZThn8_N8S19426C4D1Ev,_ZThn4_N8S19426C4D1Ev)();
extern void ABISELECT(_ZThn8_N8S19426C4D0Ev,_ZThn4_N8S19426C4D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY vtc_S19426C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C4[0]),
  (VTBL_ENTRY)&_ZN8S19426C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19426C4D0Ev,
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S19426C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S19426C4D1Ev,_ZThn4_N8S19426C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S19426C4D0Ev,_ZThn4_N8S19426C4D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
Class_Descriptor cd_S19426C4 = {  "S19426C4", // class name
  bases_S19426C4, 3,
  &(vtc_S19426C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S19426C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19426C4),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C3  : virtual S19426C4 , virtual S19426C5_nt {
  int s19426c3f0;
  char s19426c3f1;
  int s19426c3f2;
  virtual  ~S19426C3(); // _ZN8S19426C3D2Ev
  virtual void  v11(); // _ZN8S19426C33v11Ev
  virtual void  v12(); // _ZN8S19426C33v12Ev
  virtual void  v13(); // _ZN8S19426C33v13Ev
  virtual void  v14(); // _ZN8S19426C33v14Ev
  virtual void  v15(); // _ZN8S19426C33v15Ev
  virtual void  v16(); // _ZN8S19426C33v16Ev
  S19426C3(); // tgen
};
//SIG(-1 S19426C3) C1{ VBC2{ BC3{ BC4{ vd v7} vd v8} BC4 vd v9 v10} VBC3 vd v1 v2 v3 v4 v5 v6 Fi Fc Fi}


 S19426C3 ::~S19426C3(){ note_dtor("S19426C3", this);}
void  S19426C3 ::v11(){vfunc_called(this, "_ZN8S19426C33v11Ev");}
void  S19426C3 ::v12(){vfunc_called(this, "_ZN8S19426C33v12Ev");}
void  S19426C3 ::v13(){vfunc_called(this, "_ZN8S19426C33v13Ev");}
void  S19426C3 ::v14(){vfunc_called(this, "_ZN8S19426C33v14Ev");}
void  S19426C3 ::v15(){vfunc_called(this, "_ZN8S19426C33v15Ev");}
void  S19426C3 ::v16(){vfunc_called(this, "_ZN8S19426C33v16Ev");}
S19426C3 ::S19426C3(){ note_ctor("S19426C3", this);} // tgen

static void Test_S19426C3()
{
  extern Class_Descriptor cd_S19426C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S19426C3, buf);
    S19426C3 *dp, &lv = *(dp=new (buf) S19426C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S19426C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C3)");
    check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), ABISELECT(24,16), "S19426C3");
    check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), ABISELECT(24,16), "S19426C3");
    /*is_ambiguous_... S19426C4::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(32,20), "S19426C3");
    check_base_class_offset(lv, (S19426C4*), ABISELECT(24,16), "S19426C3");
    /*is_ambiguous_... S19426C3::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*), 0, "S19426C3");
    /*is_ambiguous_... S19426C3::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*), 0, "S19426C3");
    check_field_offset(lv, s19426c3f0, ABISELECT(8,4), "S19426C3.s19426c3f0");
    check_field_offset(lv, s19426c3f1, ABISELECT(12,8), "S19426C3.s19426c3f1");
    check_field_offset(lv, s19426c3f2, ABISELECT(16,12), "S19426C3.s19426c3f2");
    test_class_info(&lv, &cd_S19426C3);
    dp->~S19426C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C3(Test_S19426C3, "S19426C3", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN8S19426C3C1Ev();
extern void _ZN8S19426C3D2Ev();
Name_Map name_map_S19426C3[] = {
  NSPAIR(_ZN8S19426C3C1Ev),
  NSPAIR(_ZN8S19426C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
static Base_Class bases_S19426C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(32,20), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(24,16), //bcp->offset
    17, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19426C3[];
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void _ZN8S19426C3D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN8S19426C3D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZThn24_N8S19426C3D1Ev,_ZThn16_N8S19426C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void ABISELECT(_ZThn24_N8S19426C3D0Ev,_ZThn16_N8S19426C3D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY vtc_S19426C3[] = {
  0,
  ABISELECT(24,16),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern VTBL_ENTRY _ZTV8S19426C3[];
static  VTT_ENTRY vtt_S19426C3[] = {
  {&(_ZTV8S19426C3[7]),  7,35},
  {&(_ZTV8S19426C3[24]),  24,35},
  {&(_ZTV8S19426C3[32]),  32,35},
  {&(_ZTV8S19426C3[7]),  7,35},
};
extern VTBL_ENTRY _ZTI8S19426C3[];
extern  VTBL_ENTRY _ZTV8S19426C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C3[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S19426C3D0Ev,_ZThn16_N8S19426C3D0Ev),
  (VTBL_ENTRY)_ZN8S19426C3D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S19426C3D1Ev,_ZThn16_N8S19426C3D1Ev),
  (VTBL_ENTRY)_ZN8S19426C3D1Ev,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19426C3 = {  "S19426C3", // class name
  bases_S19426C3, 6,
  &(vtc_S19426C3[0]), // expected_vtbl_contents
  &(vtt_S19426C3[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S19426C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19426C3),35, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19426C3),4, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C7  : virtual S19426C4 {
  int s19426c7f0[2];
  void *s19426c7f1;
  virtual void  v17(); // _ZN8S19426C73v17Ev
  virtual void  v18(); // _ZN8S19426C73v18Ev
  virtual void  v19(); // _ZN8S19426C73v19Ev
  virtual void  v20(); // _ZN8S19426C73v20Ev
  ~S19426C7(); // tgen
  S19426C7(); // tgen
};
//SIG(-1 S19426C7) C1{ VBC2{ BC3{ BC4{ vd v5} vd v6} BC4 vd v7 v8} v1 v2 v3 v4 Fi[2] Fp}


void  S19426C7 ::v17(){vfunc_called(this, "_ZN8S19426C73v17Ev");}
void  S19426C7 ::v18(){vfunc_called(this, "_ZN8S19426C73v18Ev");}
void  S19426C7 ::v19(){vfunc_called(this, "_ZN8S19426C73v19Ev");}
void  S19426C7 ::v20(){vfunc_called(this, "_ZN8S19426C73v20Ev");}
S19426C7 ::~S19426C7(){ note_dtor("S19426C7", this);} // tgen
S19426C7 ::S19426C7(){ note_ctor("S19426C7", this);} // tgen

static void Test_S19426C7()
{
  extern Class_Descriptor cd_S19426C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S19426C7, buf);
    S19426C7 *dp, &lv = *(dp=new (buf) S19426C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S19426C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C7)");
    check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), ABISELECT(24,16), "S19426C7");
    check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), ABISELECT(24,16), "S19426C7");
    /*is_ambiguous_... S19426C4::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(32,20), "S19426C7");
    check_base_class_offset(lv, (S19426C4*), ABISELECT(24,16), "S19426C7");
    check_field_offset(lv, s19426c7f0, ABISELECT(8,4), "S19426C7.s19426c7f0");
    check_field_offset(lv, s19426c7f1, ABISELECT(16,12), "S19426C7.s19426c7f1");
    test_class_info(&lv, &cd_S19426C7);
    dp->~S19426C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C7(Test_S19426C7, "S19426C7", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN8S19426C7C1Ev();
extern void _ZN8S19426C7D1Ev();
Name_Map name_map_S19426C7[] = {
  NSPAIR(_ZN8S19426C7C1Ev),
  NSPAIR(_ZN8S19426C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
static Base_Class bases_S19426C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(32,20), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(24,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19426C7[];
extern void _ZN8S19426C73v17Ev();
extern void _ZN8S19426C73v18Ev();
extern void _ZN8S19426C73v19Ev();
extern void _ZN8S19426C73v20Ev();
extern void _ZN8S19426C7D1Ev();
extern void _ZN8S19426C7D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S19426C7D1Ev,_ZTv0_n12_N8S19426C7D1Ev)();
extern void ABISELECT(_ZThn24_N8S19426C7D1Ev,_ZThn16_N8S19426C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C7D0Ev,_ZTv0_n12_N8S19426C7D0Ev)();
extern void ABISELECT(_ZThn24_N8S19426C7D0Ev,_ZThn16_N8S19426C7D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void ABISELECT(_ZTvn8_n24_N8S19426C7D1Ev,_ZTvn4_n12_N8S19426C7D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C7D0Ev,_ZTvn4_n12_N8S19426C7D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY vtc_S19426C7[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C7[0]),
  (VTBL_ENTRY)&_ZN8S19426C73v17Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v18Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v19Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v20Ev,
  (VTBL_ENTRY)&_ZN8S19426C7D1Ev,
  (VTBL_ENTRY)&_ZN8S19426C7D0Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S19426C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C7D1Ev,_ZTv0_n12_N8S19426C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C7D0Ev,_ZTv0_n12_N8S19426C7D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S19426C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C7D1Ev,_ZTvn4_n12_N8S19426C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C7D0Ev,_ZTvn4_n12_N8S19426C7D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern VTBL_ENTRY _ZTV8S19426C7[];
static  VTT_ENTRY vtt_S19426C7[] = {
  {&(_ZTV8S19426C7[3]),  3,27},
  {&(_ZTV8S19426C7[16]),  16,27},
  {&(_ZTV8S19426C7[24]),  24,27},
};
extern VTBL_ENTRY _ZTI8S19426C7[];
extern  VTBL_ENTRY _ZTV8S19426C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C7[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C7D0Ev,_ZTv0_n12_N8S19426C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S19426C7D0Ev,_ZThn16_N8S19426C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C7D1Ev,_ZTv0_n12_N8S19426C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S19426C7D1Ev,_ZThn16_N8S19426C7D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19426C7 = {  "S19426C7", // class name
  bases_S19426C7, 4,
  &(vtc_S19426C7[0]), // expected_vtbl_contents
  &(vtt_S19426C7[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S19426C7),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S19426C7),27, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19426C7),3, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S19426C9_nt  {
  void  mf19426c9(); // _ZN11S19426C9_nt9mf19426c9Ev
};
//SIG(1 S19426C9_nt) U1{ m}

#endif // __cplusplus
#ifdef __cplusplus

struct  S19426C8  : S19426C4 , S19426C3 , S19426C6_nt {
  ::S19426C9_nt s19426c8f0;
  virtual void  v21(); // _ZN8S19426C83v21Ev
  virtual void  v22(); // _ZN8S19426C83v22Ev
  ~S19426C8(); // tgen
  S19426C8(); // tgen
};
//SIG(-1 S19426C8) C1{ BC2{ BC3{ BC4{ vd v3} vd v4} BC4 vd v5 v6} BC5{ VBC2 VBC3 vd v7 v8 v9 v10 v11 v12 Fi Fc Fi} BC4 v1 v2 FU6{ m}}


void  S19426C8 ::v21(){vfunc_called(this, "_ZN8S19426C83v21Ev");}
void  S19426C8 ::v22(){vfunc_called(this, "_ZN8S19426C83v22Ev");}
S19426C8 ::~S19426C8(){ note_dtor("S19426C8", this);} // tgen
S19426C8 ::S19426C8(){ note_ctor("S19426C8", this);} // tgen

static void Test_S19426C8()
{
  extern Class_Descriptor cd_S19426C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S19426C8, buf);
    S19426C8 *dp, &lv = *(dp=new (buf) S19426C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S19426C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C8)");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), 0, "S19426C8");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), 0, "S19426C8");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(8,4), "S19426C8");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C4*), 0, "S19426C8");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), ABISELECT(56,32), "S19426C8");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), ABISELECT(56,32), "S19426C8");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(64,36), "S19426C8");
    check_base_class_offset(lv, (S19426C4*)(S19426C3*), ABISELECT(56,32), "S19426C8");
    /*is_ambiguous_... S19426C8::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*), ABISELECT(16,8), "S19426C8");
    /*is_ambiguous_... S19426C3::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C3*), ABISELECT(16,8), "S19426C8");
    check_base_class_offset(lv, (S19426C3*), ABISELECT(16,8), "S19426C8");
    /*is_ambiguous_... S19426C8::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*), ABISELECT(40,24), "S19426C8");
    check_field_offset(lv, s19426c8f0, ABISELECT(48,28), "S19426C8.s19426c8f0");
    test_class_info(&lv, &cd_S19426C8);
    dp->~S19426C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C8(Test_S19426C8, "S19426C8", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN8S19426C8C1Ev();
extern void _ZN8S19426C8D1Ev();
Name_Map name_map_S19426C8[] = {
  NSPAIR(_ZN8S19426C8C1Ev),
  NSPAIR(_ZN8S19426C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C3;
extern VTBL_ENTRY _ZTI8S19426C3[];
extern  VTBL_ENTRY _ZTV8S19426C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C3[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
static Base_Class bases_S19426C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(8,4), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19426C6_nt,    ABISELECT(56,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(56,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(64,36), //bcp->offset
    52, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(56,32), //bcp->offset
    39, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S19426C6_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S19426C3,    ABISELECT(16,8), //bcp->offset
    17, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19426C6_nt,    ABISELECT(40,24), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19426C8[];
extern void _ZN8S19426C8D1Ev();
extern void _ZN8S19426C8D0Ev();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN8S19426C83v21Ev();
extern void _ZN8S19426C83v22Ev();
extern void ABISELECT(_ZThn8_N8S19426C8D1Ev,_ZThn4_N8S19426C8D1Ev)();
extern void ABISELECT(_ZThn8_N8S19426C8D0Ev,_ZThn4_N8S19426C8D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev)();
extern void ABISELECT(_ZThn16_N8S19426C8D1Ev,_ZThn8_N8S19426C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev)();
extern void ABISELECT(_ZThn16_N8S19426C8D0Ev,_ZThn8_N8S19426C8D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
extern void ABISELECT(_ZThn40_N8S19426C8D1Ev,_ZThn24_N8S19426C8D1Ev)();
extern void ABISELECT(_ZThn40_N8S19426C8D0Ev,_ZThn24_N8S19426C8D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev)();
extern void ABISELECT(_ZThn56_N8S19426C8D1Ev,_ZThn32_N8S19426C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev)();
extern void ABISELECT(_ZThn56_N8S19426C8D0Ev,_ZThn32_N8S19426C8D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void ABISELECT(_ZTvn8_n24_N8S19426C8D1Ev,_ZTvn4_n12_N8S19426C8D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C8D0Ev,_ZTvn4_n12_N8S19426C8D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY vtc_S19426C8[] = {
  ABISELECT(16,8),
  ABISELECT(56,32),
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&_ZN8S19426C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19426C8D0Ev,
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19426C83v21Ev,
  (VTBL_ENTRY)&_ZN8S19426C83v22Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S19426C8D1Ev,_ZThn4_N8S19426C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S19426C8D0Ev,_ZThn4_N8S19426C8D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  0,
  ABISELECT(40,24),
  0,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S19426C8D1Ev,_ZThn24_N8S19426C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S19426C8D0Ev,_ZThn24_N8S19426C8D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C8D1Ev,_ZTvn4_n12_N8S19426C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C8D0Ev,_ZTvn4_n12_N8S19426C8D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern VTBL_ENTRY _ZTV8S19426C8[];
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void _ZN8S19426C3D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN8S19426C3D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__8S19426C8[] = {
  0,
  ABISELECT(40,24),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZThn40_N8S19426C3D1Ev,_ZThn24_N8S19426C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void ABISELECT(_ZThn40_N8S19426C3D0Ev,_ZThn24_N8S19426C3D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__8S19426C3__8S19426C8[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__8S19426C8[] = {
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
static  VTT_ENTRY vtt_S19426C8[] = {
  {&(_ZTV8S19426C8[4]),  4,57},
  {&(_tg__ZTV8S19426C3__8S19426C8[7]),  7,17},
  {&(_tg__ZTV8S19426C4__8S19426C3__8S19426C8[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__8S19426C8[2]),  2,5},
  {&(_tg__ZTV8S19426C3__8S19426C8[7]),  7,17},
  {&(_ZTV8S19426C8[24]),  24,57},
  {&(_ZTV8S19426C8[46]),  46,57},
  {&(_ZTV8S19426C8[54]),  54,57},
  {&(_ZTV8S19426C8[24]),  24,57},
};
extern VTBL_ENTRY _ZTI8S19426C8[];
extern  VTBL_ENTRY _ZTV8S19426C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C8[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S19426C3D0Ev,_ZThn24_N8S19426C3D0Ev),
  (VTBL_ENTRY)_ZN8S19426C3D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S19426C3D1Ev,_ZThn24_N8S19426C3D1Ev),
  (VTBL_ENTRY)_ZN8S19426C3D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S19426C8D0Ev,_ZThn32_N8S19426C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19426C8D0Ev,_ZThn8_N8S19426C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S19426C8D1Ev,_ZThn32_N8S19426C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19426C8D1Ev,_ZThn8_N8S19426C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19426C8 = {  "S19426C8", // class name
  bases_S19426C8, 12,
  &(vtc_S19426C8[0]), // expected_vtbl_contents
  &(vtt_S19426C8[0]), // expected_vtt_contents
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI8S19426C8),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S19426C8),57, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19426C8),9, //virtual table table var
  12, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C2  : S19426C3 , S19426C7 , virtual S19426C8 {
  virtual void  v23(); // _ZN8S19426C23v23Ev
  ~S19426C2(); // tgen
  S19426C2(); // tgen
};
//SIG(-1 S19426C2) C1{ BC2{ VBC3{ BC4{ BC5{ vd v2} vd v3} BC5 vd v4 v5} VBC4 vd v6 v7 v8 v9 v10 v11 Fi Fc Fi} BC6{ VBC3 v12 v13 v14 v15 Fi[2] Fp} VBC7{ BC3 BC2 BC5 v16 v17 FU8{ m}} v1}


void  S19426C2 ::v23(){vfunc_called(this, "_ZN8S19426C23v23Ev");}
S19426C2 ::~S19426C2(){ note_dtor("S19426C2", this);} // tgen
S19426C2 ::S19426C2(){ note_ctor("S19426C2", this);} // tgen

static void Test_S19426C2()
{
  extern Class_Descriptor cd_S19426C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,19)];
    init_test(&cd_S19426C2, buf);
    S19426C2 *dp, &lv = *(dp=new (buf) S19426C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,72), "sizeof(S19426C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C2)");
    /*is_ambiguous_... S19426C2::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), ABISELECT(48,32), "S19426C2");
    /*is_ambiguous_... S19426C2::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), ABISELECT(48,32), "S19426C2");
    /*is_ambiguous_... S19426C2::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(56,36), "S19426C2");
    /*is_ambiguous_... S19426C2::S19426C3 */ AMB_check_base_class_offset(lv, (S19426C4*)(S19426C3*), ABISELECT(48,32), "S19426C2");
    check_base_class_offset(lv, (S19426C4*)(S19426C7*), ABISELECT(48,32), "S19426C2");
    check_base_class_offset(lv, (S19426C4*)(S19426C3*)(S19426C8*), ABISELECT(48,32), "S19426C2");
    /*is_ambiguous_... S19426C2::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*), 0, "S19426C2");
    /*is_ambiguous_... S19426C2::S19426C3 */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C3*), 0, "S19426C2");
    /*is_ambiguous_... S19426C3::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C3*)(S19426C8*), 0, "S19426C2");
    /*is_ambiguous_... S19426C2::S19426C3 */ AMB_check_base_class_offset(lv, (S19426C3*), 0, "S19426C2");
    check_base_class_offset(lv, (S19426C7*), ABISELECT(24,16), "S19426C2");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*)(S19426C8*), ABISELECT(64,40), "S19426C2");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*)(S19426C8*), ABISELECT(64,40), "S19426C2");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*)(S19426C8*), ABISELECT(72,44), "S19426C2");
    /*is_ambiguous_... S19426C8::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C4*)(S19426C8*), ABISELECT(64,40), "S19426C2");
    check_base_class_offset(lv, (S19426C3*)(S19426C8*), ABISELECT(80,48), "S19426C2");
    /*is_ambiguous_... S19426C8::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C8*), ABISELECT(104,64), "S19426C2");
    check_base_class_offset(lv, (S19426C8*), ABISELECT(64,40), "S19426C2");
    test_class_info(&lv, &cd_S19426C2);
    dp->~S19426C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C2(Test_S19426C2, "S19426C2", ABISELECT(120,72));

#else // __cplusplus

extern void _ZN8S19426C2C1Ev();
extern void _ZN8S19426C2D1Ev();
Name_Map name_map_S19426C2[] = {
  NSPAIR(_ZN8S19426C2C1Ev),
  NSPAIR(_ZN8S19426C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C3;
extern VTBL_ENTRY _ZTI8S19426C3[];
extern  VTBL_ENTRY _ZTV8S19426C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C3[];
extern Class_Descriptor cd_S19426C7;
extern VTBL_ENTRY _ZTI8S19426C7[];
extern  VTBL_ENTRY _ZTV8S19426C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C7[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C3;
extern VTBL_ENTRY _ZTI8S19426C3[];
extern  VTBL_ENTRY _ZTV8S19426C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C3[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C8;
extern VTBL_ENTRY _ZTI8S19426C8[];
extern  VTBL_ENTRY _ZTV8S19426C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C8[];
static Base_Class bases_S19426C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(48,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(56,36), //bcp->offset
    41, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(48,32), //bcp->offset
    28, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19426C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S19426C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19426C7,    ABISELECT(24,16), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19426C6_nt,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(72,44), //bcp->offset
    71, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19426C3,    ABISELECT(80,48), //bcp->offset
    76, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(104,64), //bcp->offset
    93, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S19426C8,    ABISELECT(64,40), //bcp->offset
    46, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19426C2[];
extern void ABISELECT(_ZTv0_n24_N8S19426C2D1Ev,_ZTv0_n12_N8S19426C2D1Ev)();
extern void _ZN8S19426C2D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C2D0Ev,_ZTv0_n12_N8S19426C2D0Ev)();
extern void _ZN8S19426C2D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
extern void _ZN8S19426C23v23Ev();
extern void _ZN8S19426C73v17Ev();
extern void _ZN8S19426C73v18Ev();
extern void _ZN8S19426C73v19Ev();
extern void _ZN8S19426C73v20Ev();
extern void ABISELECT(_ZThn24_N8S19426C2D1Ev,_ZThn16_N8S19426C2D1Ev)();
extern void ABISELECT(_ZThn24_N8S19426C2D0Ev,_ZThn16_N8S19426C2D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19426C2D1Ev,_ZTv0_n12_N8S19426C2D1Ev)();
extern void ABISELECT(_ZThn48_N8S19426C2D1Ev,_ZThn32_N8S19426C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C2D0Ev,_ZTv0_n12_N8S19426C2D0Ev)();
extern void ABISELECT(_ZThn48_N8S19426C2D0Ev,_ZThn32_N8S19426C2D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void ABISELECT(_ZTvn8_n24_N8S19426C2D1Ev,_ZTvn4_n12_N8S19426C2D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C2D0Ev,_ZTvn4_n12_N8S19426C2D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n40_N8S19426C2D1Ev,_ZTv0_n20_N8S19426C2D1Ev)();
extern void ABISELECT(_ZThn64_N8S19426C2D1Ev,_ZThn40_N8S19426C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19426C2D0Ev,_ZTv0_n20_N8S19426C2D0Ev)();
extern void ABISELECT(_ZThn64_N8S19426C2D0Ev,_ZThn40_N8S19426C2D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN8S19426C83v21Ev();
extern void _ZN8S19426C83v22Ev();
extern void ABISELECT(_ZTvn8_n40_N8S19426C2D1Ev,_ZTvn4_n20_N8S19426C2D1Ev)();
extern void ABISELECT(_ZTvn8_n40_N8S19426C2D0Ev,_ZTvn4_n20_N8S19426C2D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N8S19426C2D1Ev,_ZTv0_n12_N8S19426C2D1Ev)();
extern void ABISELECT(_ZThn80_N8S19426C2D1Ev,_ZThn48_N8S19426C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C2D0Ev,_ZTv0_n12_N8S19426C2D0Ev)();
extern void ABISELECT(_ZThn80_N8S19426C2D0Ev,_ZThn48_N8S19426C2D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
extern void ABISELECT(_ZTvn40_n40_N8S19426C2D1Ev,_ZTvn24_n20_N8S19426C2D1Ev)();
extern void ABISELECT(_ZTvn40_n40_N8S19426C2D0Ev,_ZTvn24_n20_N8S19426C2D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY vtc_S19426C2[] = {
  ABISELECT(64,40),
  0,
  ABISELECT(48,32),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C2D1Ev,_ZTv0_n12_N8S19426C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C2D0Ev,_ZTv0_n12_N8S19426C2D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
  (VTBL_ENTRY)&_ZN8S19426C23v23Ev,
  ABISELECT(24,16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S19426C2[0]),
  (VTBL_ENTRY)&_ZN8S19426C73v17Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v18Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v19Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v20Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S19426C2D1Ev,_ZThn16_N8S19426C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S19426C2D0Ev,_ZThn16_N8S19426C2D0Ev),
  0,
  0,
  0,
  0,
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8S19426C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C2D1Ev,_ZTv0_n12_N8S19426C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C2D0Ev,_ZTv0_n12_N8S19426C2D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8S19426C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C2D1Ev,_ZTvn4_n12_N8S19426C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C2D0Ev,_ZTvn4_n12_N8S19426C2D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  ABISELECT(16,8),
  ABISELECT(16,8),
  ABISELECT(16,8),
  ABISELECT(16,8),
  ABISELECT(16,8),
  ABISELECT(16,8),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  ABISELECT(-16,-8),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI8S19426C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19426C2D1Ev,_ZTv0_n20_N8S19426C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19426C2D0Ev,_ZTv0_n20_N8S19426C2D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19426C83v21Ev,
  (VTBL_ENTRY)&_ZN8S19426C83v22Ev,
  ABISELECT(-72,-44),
  (VTBL_ENTRY)&(_ZTI8S19426C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n40_N8S19426C2D1Ev,_ZTvn4_n20_N8S19426C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n40_N8S19426C2D0Ev,_ZTvn4_n20_N8S19426C2D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  ABISELECT(-80,-48),
  ABISELECT(-32,-16),
  ABISELECT(-80,-48),
  ABISELECT(-80,-48),
  ABISELECT(-80,-48),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI8S19426C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C2D1Ev,_ZTv0_n12_N8S19426C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C2D0Ev,_ZTv0_n12_N8S19426C2D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI8S19426C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n40_N8S19426C2D1Ev,_ZTvn24_n20_N8S19426C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n40_N8S19426C2D0Ev,_ZTvn24_n20_N8S19426C2D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern VTBL_ENTRY _ZTV8S19426C2[];
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void _ZN8S19426C3D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN8S19426C3D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__8S19426C2[] = {
  0,
  ABISELECT(48,32),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZThn48_N8S19426C3D1Ev,_ZThn32_N8S19426C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void ABISELECT(_ZThn48_N8S19426C3D0Ev,_ZThn32_N8S19426C3D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__8S19426C3__8S19426C2[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__8S19426C2[] = {
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void _ZN8S19426C73v17Ev();
extern void _ZN8S19426C73v18Ev();
extern void _ZN8S19426C73v19Ev();
extern void _ZN8S19426C73v20Ev();
extern void _ZN8S19426C7D1Ev();
extern void _ZN8S19426C7D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C7__8S19426C2[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C7[0]),
  (VTBL_ENTRY)&_ZN8S19426C73v17Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v18Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v19Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v20Ev,
  (VTBL_ENTRY)&_ZN8S19426C7D1Ev,
  (VTBL_ENTRY)&_ZN8S19426C7D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C7D1Ev,_ZTv0_n12_N8S19426C7D1Ev)();
extern void ABISELECT(_ZThn24_N8S19426C7D1Ev,_ZThn16_N8S19426C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C7D0Ev,_ZTv0_n12_N8S19426C7D0Ev)();
extern void ABISELECT(_ZThn24_N8S19426C7D0Ev,_ZThn16_N8S19426C7D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__8S19426C7__8S19426C2[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S19426C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C7D1Ev,_ZTv0_n12_N8S19426C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C7D0Ev,_ZTv0_n12_N8S19426C7D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N8S19426C7D1Ev,_ZTvn4_n12_N8S19426C7D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C7D0Ev,_ZTvn4_n12_N8S19426C7D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C7__8S19426C2[] = {
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S19426C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C7D1Ev,_ZTvn4_n12_N8S19426C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C7D0Ev,_ZTvn4_n12_N8S19426C7D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void _ZN8S19426C8D1Ev();
extern void _ZN8S19426C8D0Ev();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN8S19426C83v21Ev();
extern void _ZN8S19426C83v22Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C8__8S19426C2[] = {
  ABISELECT(-64,-40),
  ABISELECT(-16,-8),
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&_ZN8S19426C8D1Ev,
  (VTBL_ENTRY)&_ZN8S19426C8D0Ev,
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19426C83v21Ev,
  (VTBL_ENTRY)&_ZN8S19426C83v22Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void _ZN8S19426C3D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN8S19426C3D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C38S19426C8__A1__8S19426C2[] = {
  ABISELECT(-80,-48),
  ABISELECT(-32,-16),
  ABISELECT(-80,-48),
  ABISELECT(-80,-48),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__8S19426C38S19426C8__A1__8S19426C2[] = {
  0,
  0,
  0,
  0,
  ABISELECT(32,16),
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C38S19426C8__A1__8S19426C2[] = {
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C5_nt__A1__8S19426C38S19426C8__A1__8S19426C2[] = {
  0,
  0,
  ABISELECT(80,48),
  ABISELECT(80,48),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev)();
extern void ABISELECT(_ZThn16_N8S19426C8D1Ev,_ZThn8_N8S19426C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev)();
extern void ABISELECT(_ZThn16_N8S19426C8D0Ev,_ZThn8_N8S19426C8D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__8S19426C8__8S19426C2[] = {
  ABISELECT(-80,-48),
  ABISELECT(-32,-16),
  ABISELECT(-80,-48),
  ABISELECT(-80,-48),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__A1__8S19426C8__8S19426C2[] = {
  0,
  0,
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N8S19426C8D1Ev,_ZTvn4_n12_N8S19426C8D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C8D0Ev,_ZTvn4_n12_N8S19426C8D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A3__8S19426C8__8S19426C2[] = {
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C8D1Ev,_ZTvn4_n12_N8S19426C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C8D0Ev,_ZTvn4_n12_N8S19426C8D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C5_nt__A2__8S19426C8__8S19426C2[] = {
  0,
  0,
  ABISELECT(64,40),
  ABISELECT(64,40),
  (VTBL_ENTRY)&(_ZTI8S19426C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
};
static  VTT_ENTRY vtt_S19426C2[] = {
  {&(_ZTV8S19426C2[8]),  8,98},
  {&(_tg__ZTV8S19426C3__8S19426C2[7]),  7,17},
  {&(_tg__ZTV8S19426C4__8S19426C3__8S19426C2[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__8S19426C2[2]),  2,5},
  {&(_tg__ZTV8S19426C3__8S19426C2[7]),  7,17},
  {&(_tg__ZTV8S19426C7__8S19426C2[3]),  3,9},
  {&(_tg__ZTV8S19426C4__8S19426C7__8S19426C2[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C7__8S19426C2[2]),  2,5},
  {&(_ZTV8S19426C2[35]),  35,98},
  {&(_ZTV8S19426C2[43]),  43,98},
  {&(_ZTV8S19426C2[8]),  8,98},
  {&(_ZTV8S19426C2[22]),  22,98},
  {&(_ZTV8S19426C2[63]),  63,98},
  {&(_ZTV8S19426C2[73]),  73,98},
  {&(_ZTV8S19426C2[83]),  83,98},
  {&(_ZTV8S19426C2[95]),  95,98},
  {&(_tg__ZTV8S19426C8__8S19426C2[4]),  4,12},
  {&(_tg__ZTV8S19426C38S19426C8__A1__8S19426C2[7]),  7,17},
  {&(_tg__ZTV8S19426C4__8S19426C38S19426C8__A1__8S19426C2[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C38S19426C8__A1__8S19426C2[2]),  2,5},
  {&(_tg__ZTV11S19426C5_nt__A1__8S19426C38S19426C8__A1__8S19426C2[5]),  5,9},
  {&(_tg__ZTV8S19426C3__8S19426C8__8S19426C2[7]),  7,17},
  {&(_tg__ZTV8S19426C4__A1__8S19426C8__8S19426C2[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A3__8S19426C8__8S19426C2[2]),  2,5},
  {&(_tg__ZTV11S19426C5_nt__A2__8S19426C8__8S19426C2[5]),  5,9},
};
extern VTBL_ENTRY _ZTI8S19426C2[];
extern  VTBL_ENTRY _ZTV8S19426C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C2[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C8D0Ev,_ZTv0_n12_N8S19426C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19426C8D0Ev,_ZThn8_N8S19426C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C8D1Ev,_ZTv0_n12_N8S19426C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S19426C8D1Ev,_ZThn8_N8S19426C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C7D0Ev,_ZTv0_n12_N8S19426C7D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S19426C7D0Ev,_ZThn16_N8S19426C7D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C7D1Ev,_ZTv0_n12_N8S19426C7D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S19426C7D1Ev,_ZThn16_N8S19426C7D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev), // 
  (VTBL_ENTRY)_ZN8S19426C3D0Ev,
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19426C3D0Ev,_ZThn32_N8S19426C3D0Ev),
  (VTBL_ENTRY)_ZN8S19426C3D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev), // 
  (VTBL_ENTRY)_ZN8S19426C3D1Ev,
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19426C3D1Ev,_ZThn32_N8S19426C3D1Ev),
  (VTBL_ENTRY)_ZN8S19426C3D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19426C2D0Ev,_ZTv0_n20_N8S19426C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S19426C2D0Ev,_ZThn40_N8S19426C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19426C2D1Ev,_ZTv0_n20_N8S19426C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S19426C2D1Ev,_ZThn40_N8S19426C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C2D0Ev,_ZTv0_n12_N8S19426C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S19426C2D0Ev,_ZThn48_N8S19426C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19426C2D0Ev,_ZThn32_N8S19426C2D0Ev),
  (VTBL_ENTRY)_ZN8S19426C2D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C2D1Ev,_ZTv0_n12_N8S19426C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S19426C2D1Ev,_ZThn48_N8S19426C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S19426C2D1Ev,_ZThn32_N8S19426C2D1Ev),
  (VTBL_ENTRY)_ZN8S19426C2D1Ev,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19426C2 = {  "S19426C2", // class name
  bases_S19426C2, 15,
  &(vtc_S19426C2[0]), // expected_vtbl_contents
  &(vtt_S19426C2[0]), // expected_vtt_contents
  ABISELECT(120,72), // object size
  NSPAIRA(_ZTI8S19426C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S19426C2),98, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19426C2),25, //virtual table table var
  15, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C11  {
  virtual void  v24(); // _ZN9S19426C113v24Ev
  virtual void  v25(); // _ZN9S19426C113v25Ev
  virtual void  v26(); // _ZN9S19426C113v26Ev
  virtual void  v27(); // _ZN9S19426C113v27Ev
  virtual void  v28(); // _ZN9S19426C113v28Ev
  virtual void  v29(); // _ZN9S19426C113v29Ev
  virtual void  v30(); // _ZN9S19426C113v30Ev
  virtual void  v31(); // _ZN9S19426C113v31Ev
  ~S19426C11(); // tgen
  S19426C11(); // tgen
};
//SIG(-1 S19426C11) C1{ v1 v2 v3 v4 v5 v6 v7 v8}


void  S19426C11 ::v24(){vfunc_called(this, "_ZN9S19426C113v24Ev");}
void  S19426C11 ::v25(){vfunc_called(this, "_ZN9S19426C113v25Ev");}
void  S19426C11 ::v26(){vfunc_called(this, "_ZN9S19426C113v26Ev");}
void  S19426C11 ::v27(){vfunc_called(this, "_ZN9S19426C113v27Ev");}
void  S19426C11 ::v28(){vfunc_called(this, "_ZN9S19426C113v28Ev");}
void  S19426C11 ::v29(){vfunc_called(this, "_ZN9S19426C113v29Ev");}
void  S19426C11 ::v30(){vfunc_called(this, "_ZN9S19426C113v30Ev");}
void  S19426C11 ::v31(){vfunc_called(this, "_ZN9S19426C113v31Ev");}
S19426C11 ::~S19426C11(){ note_dtor("S19426C11", this);} // tgen
S19426C11 ::S19426C11(){ note_ctor("S19426C11", this);} // tgen

static void Test_S19426C11()
{
  extern Class_Descriptor cd_S19426C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S19426C11, buf);
    S19426C11 *dp, &lv = *(dp=new (buf) S19426C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S19426C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C11)");
    test_class_info(&lv, &cd_S19426C11);
    dp->~S19426C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C11(Test_S19426C11, "S19426C11", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S19426C11C1Ev();
extern void _ZN9S19426C11D1Ev();
Name_Map name_map_S19426C11[] = {
  NSPAIR(_ZN9S19426C11C1Ev),
  NSPAIR(_ZN9S19426C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S19426C11[];
extern void _ZN9S19426C113v24Ev();
extern void _ZN9S19426C113v25Ev();
extern void _ZN9S19426C113v26Ev();
extern void _ZN9S19426C113v27Ev();
extern void _ZN9S19426C113v28Ev();
extern void _ZN9S19426C113v29Ev();
extern void _ZN9S19426C113v30Ev();
extern void _ZN9S19426C113v31Ev();
static  VTBL_ENTRY vtc_S19426C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C11[0]),
  (VTBL_ENTRY)&_ZN9S19426C113v24Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v25Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v26Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v27Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v28Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v29Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v30Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v31Ev,
};
extern VTBL_ENTRY _ZTI9S19426C11[];
extern  VTBL_ENTRY _ZTV9S19426C11[];
Class_Descriptor cd_S19426C11 = {  "S19426C11", // class name
  0,0,//no base classes
  &(vtc_S19426C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S19426C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S19426C11),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C10  : virtual S19426C11 {
  virtual  ~S19426C10(); // _ZN9S19426C10D2Ev
  virtual void  v32(); // _ZN9S19426C103v32Ev
  virtual void  v33(); // _ZN9S19426C103v33Ev
  virtual void  v34(); // _ZN9S19426C103v34Ev
  virtual void  v35(); // _ZN9S19426C103v35Ev
  virtual void  v36(); // _ZN9S19426C103v36Ev
  virtual void  v37(); // _ZN9S19426C103v37Ev
  virtual void  v38(); // _ZN9S19426C103v38Ev
  virtual void  v39(); // _ZN9S19426C103v39Ev
  virtual void  v40(); // _ZN9S19426C103v40Ev
  virtual void  v41(); // _ZN9S19426C103v41Ev
  S19426C10(); // tgen
};
//SIG(-1 S19426C10) C1{ VBC2{ v11 v12 v13 v14 v15 v16 v17 v18} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10}


 S19426C10 ::~S19426C10(){ note_dtor("S19426C10", this);}
void  S19426C10 ::v32(){vfunc_called(this, "_ZN9S19426C103v32Ev");}
void  S19426C10 ::v33(){vfunc_called(this, "_ZN9S19426C103v33Ev");}
void  S19426C10 ::v34(){vfunc_called(this, "_ZN9S19426C103v34Ev");}
void  S19426C10 ::v35(){vfunc_called(this, "_ZN9S19426C103v35Ev");}
void  S19426C10 ::v36(){vfunc_called(this, "_ZN9S19426C103v36Ev");}
void  S19426C10 ::v37(){vfunc_called(this, "_ZN9S19426C103v37Ev");}
void  S19426C10 ::v38(){vfunc_called(this, "_ZN9S19426C103v38Ev");}
void  S19426C10 ::v39(){vfunc_called(this, "_ZN9S19426C103v39Ev");}
void  S19426C10 ::v40(){vfunc_called(this, "_ZN9S19426C103v40Ev");}
void  S19426C10 ::v41(){vfunc_called(this, "_ZN9S19426C103v41Ev");}
S19426C10 ::S19426C10(){ note_ctor("S19426C10", this);} // tgen

static void Test_S19426C10()
{
  extern Class_Descriptor cd_S19426C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S19426C10, buf);
    S19426C10 *dp, &lv = *(dp=new (buf) S19426C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S19426C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C10)");
    check_base_class_offset(lv, (S19426C11*), 0, "S19426C10");
    test_class_info(&lv, &cd_S19426C10);
    dp->~S19426C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C10(Test_S19426C10, "S19426C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S19426C10C1Ev();
extern void _ZN9S19426C10D2Ev();
Name_Map name_map_S19426C10[] = {
  NSPAIR(_ZN9S19426C10C1Ev),
  NSPAIR(_ZN9S19426C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C11;
extern VTBL_ENTRY _ZTI9S19426C11[];
extern  VTBL_ENTRY _ZTV9S19426C11[];
static Base_Class bases_S19426C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19426C10[];
extern void _ZN9S19426C113v24Ev();
extern void _ZN9S19426C113v25Ev();
extern void _ZN9S19426C113v26Ev();
extern void _ZN9S19426C113v27Ev();
extern void _ZN9S19426C113v28Ev();
extern void _ZN9S19426C113v29Ev();
extern void _ZN9S19426C113v30Ev();
extern void _ZN9S19426C113v31Ev();
extern void _ZN9S19426C10D1Ev();
extern void _ZN9S19426C10D0Ev();
extern void _ZN9S19426C103v32Ev();
extern void _ZN9S19426C103v33Ev();
extern void _ZN9S19426C103v34Ev();
extern void _ZN9S19426C103v35Ev();
extern void _ZN9S19426C103v36Ev();
extern void _ZN9S19426C103v37Ev();
extern void _ZN9S19426C103v38Ev();
extern void _ZN9S19426C103v39Ev();
extern void _ZN9S19426C103v40Ev();
extern void _ZN9S19426C103v41Ev();
static  VTBL_ENTRY vtc_S19426C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C10[0]),
  (VTBL_ENTRY)&_ZN9S19426C113v24Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v25Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v26Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v27Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v28Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v29Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v30Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v31Ev,
  (VTBL_ENTRY)&_ZN9S19426C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19426C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19426C103v32Ev,
  (VTBL_ENTRY)&_ZN9S19426C103v33Ev,
  (VTBL_ENTRY)&_ZN9S19426C103v34Ev,
  (VTBL_ENTRY)&_ZN9S19426C103v35Ev,
  (VTBL_ENTRY)&_ZN9S19426C103v36Ev,
  (VTBL_ENTRY)&_ZN9S19426C103v37Ev,
  (VTBL_ENTRY)&_ZN9S19426C103v38Ev,
  (VTBL_ENTRY)&_ZN9S19426C103v39Ev,
  (VTBL_ENTRY)&_ZN9S19426C103v40Ev,
  (VTBL_ENTRY)&_ZN9S19426C103v41Ev,
};
extern VTBL_ENTRY _ZTV9S19426C10[];
static  VTT_ENTRY vtt_S19426C10[] = {
  {&(_ZTV9S19426C10[11]),  11,31},
  {&(_ZTV9S19426C10[11]),  11,31},
};
extern VTBL_ENTRY _ZTI9S19426C10[];
extern  VTBL_ENTRY _ZTV9S19426C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C10[];
Class_Descriptor cd_S19426C10 = {  "S19426C10", // class name
  bases_S19426C10, 1,
  &(vtc_S19426C10[0]), // expected_vtbl_contents
  &(vtt_S19426C10[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S19426C10),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S19426C10),31, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19426C10),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C14  : S19426C4 {
  ::S19426C4 s19426c14f0;
  ::S19426C6_nt s19426c14f1;
  virtual  ~S19426C14(); // _ZN9S19426C14D1Ev
  virtual void  v42(); // _ZN9S19426C143v42Ev
  virtual void  v43(); // _ZN9S19426C143v43Ev
  virtual void  v44(); // _ZN9S19426C143v44Ev
  virtual void  v45(); // _ZN9S19426C143v45Ev
  virtual void  v46(); // _ZN9S19426C143v46Ev
  S19426C14(); // tgen
};
//SIG(-1 S19426C14) C1{ BC2{ BC3{ BC4{ vd v6} vd v7} BC4 vd v8 v9} vd v1 v2 v3 v4 v5 FC2 FC4}


 S19426C14 ::~S19426C14(){ note_dtor("S19426C14", this);}
void  S19426C14 ::v42(){vfunc_called(this, "_ZN9S19426C143v42Ev");}
void  S19426C14 ::v43(){vfunc_called(this, "_ZN9S19426C143v43Ev");}
void  S19426C14 ::v44(){vfunc_called(this, "_ZN9S19426C143v44Ev");}
void  S19426C14 ::v45(){vfunc_called(this, "_ZN9S19426C143v45Ev");}
void  S19426C14 ::v46(){vfunc_called(this, "_ZN9S19426C143v46Ev");}
S19426C14 ::S19426C14(){ note_ctor("S19426C14", this);} // tgen

static void Test_S19426C14()
{
  extern Class_Descriptor cd_S19426C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S19426C14, buf);
    S19426C14 *dp, &lv = *(dp=new (buf) S19426C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S19426C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C14)");
    check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), 0, "S19426C14");
    check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), 0, "S19426C14");
    /*is_ambiguous_... S19426C4::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(8,4), "S19426C14");
    check_base_class_offset(lv, (S19426C4*), 0, "S19426C14");
    check_field_offset(lv, s19426c14f0, ABISELECT(16,8), "S19426C14.s19426c14f0");
    check_field_offset(lv, s19426c14f1, ABISELECT(32,16), "S19426C14.s19426c14f1");
    test_class_info(&lv, &cd_S19426C14);
    dp->~S19426C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C14(Test_S19426C14, "S19426C14", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN9S19426C14C1Ev();
extern void _ZN9S19426C14D1Ev();
Name_Map name_map_S19426C14[] = {
  NSPAIR(_ZN9S19426C14C1Ev),
  NSPAIR(_ZN9S19426C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
static Base_Class bases_S19426C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(8,4), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19426C14[];
extern void _ZN9S19426C14D1Ev();
extern void _ZN9S19426C14D0Ev();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
extern void ABISELECT(_ZThn8_N9S19426C14D1Ev,_ZThn4_N9S19426C14D1Ev)();
extern void ABISELECT(_ZThn8_N9S19426C14D0Ev,_ZThn4_N9S19426C14D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY vtc_S19426C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C14[0]),
  (VTBL_ENTRY)&_ZN9S19426C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19426C14D0Ev,
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19426C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S19426C14D1Ev,_ZThn4_N9S19426C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S19426C14D0Ev,_ZThn4_N9S19426C14D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern VTBL_ENTRY _ZTI9S19426C14[];
extern  VTBL_ENTRY _ZTV9S19426C14[];
Class_Descriptor cd_S19426C14 = {  "S19426C14", // class name
  bases_S19426C14, 4,
  &(vtc_S19426C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI9S19426C14),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S19426C14),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C13  : virtual S19426C5_nt , virtual S19426C14 , virtual S19426C3 , S19426C6_nt {
  short s19426c13f0;
  virtual  ~S19426C13(); // _ZN9S19426C13D2Ev
  virtual void  v47(); // _ZN9S19426C133v47Ev
  virtual void  v48(); // _ZN9S19426C133v48Ev
  virtual void  v49(); // _ZN9S19426C133v49Ev
  virtual void  v50(); // _ZN9S19426C133v50Ev
  virtual void  v51(); // _ZN9S19426C133v51Ev
  virtual void  v52(); // _ZN9S19426C133v52Ev
  virtual void  v53(); // _ZN9S19426C133v53Ev
  virtual void  v54(); // _ZN9S19426C133v54Ev
  virtual void  v55(); // _ZN9S19426C133v55Ev
  S19426C13(); // tgen
};
//SIG(-1 S19426C13) C1{ VBC2{ BC3{ vd v10} vd v11} VBC4{ BC5{ BC2 BC3 vd v12 v13} vd v14 v15 v16 v17 v18 FC5 FC3} VBC6{ VBC5 VBC2 vd v19 v20 v21 v22 v23 v24 Fi Fc Fi} BC3 vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fs}


 S19426C13 ::~S19426C13(){ note_dtor("S19426C13", this);}
void  S19426C13 ::v47(){vfunc_called(this, "_ZN9S19426C133v47Ev");}
void  S19426C13 ::v48(){vfunc_called(this, "_ZN9S19426C133v48Ev");}
void  S19426C13 ::v49(){vfunc_called(this, "_ZN9S19426C133v49Ev");}
void  S19426C13 ::v50(){vfunc_called(this, "_ZN9S19426C133v50Ev");}
void  S19426C13 ::v51(){vfunc_called(this, "_ZN9S19426C133v51Ev");}
void  S19426C13 ::v52(){vfunc_called(this, "_ZN9S19426C133v52Ev");}
void  S19426C13 ::v53(){vfunc_called(this, "_ZN9S19426C133v53Ev");}
void  S19426C13 ::v54(){vfunc_called(this, "_ZN9S19426C133v54Ev");}
void  S19426C13 ::v55(){vfunc_called(this, "_ZN9S19426C133v55Ev");}
S19426C13 ::S19426C13(){ note_ctor("S19426C13", this);} // tgen

static void Test_S19426C13()
{
  extern Class_Descriptor cd_S19426C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,14)];
    init_test(&cd_S19426C13, buf);
    S19426C13 *dp, &lv = *(dp=new (buf) S19426C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,52), "sizeof(S19426C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C13)");
    /*is_ambiguous_... S19426C13::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*), ABISELECT(56,28), "S19426C13");
    /*is_ambiguous_... S19426C13::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*), ABISELECT(56,28), "S19426C13");
    /*is_ambiguous_... S19426C3::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C3*), ABISELECT(56,28), "S19426C13");
    check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*)(S19426C14*), ABISELECT(16,8), "S19426C13");
    check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*)(S19426C14*), ABISELECT(16,8), "S19426C13");
    /*is_ambiguous_... S19426C4::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*)(S19426C14*), ABISELECT(24,12), "S19426C13");
    check_base_class_offset(lv, (S19426C4*)(S19426C14*), ABISELECT(16,8), "S19426C13");
    check_base_class_offset(lv, (S19426C14*), ABISELECT(16,8), "S19426C13");
    /*is_ambiguous_... S19426C13::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), ABISELECT(80,44), "S19426C13");
    /*is_ambiguous_... S19426C13::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), ABISELECT(80,44), "S19426C13");
    /*is_ambiguous_... S19426C13::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(88,48), "S19426C13");
    check_base_class_offset(lv, (S19426C4*)(S19426C3*), ABISELECT(80,44), "S19426C13");
    check_base_class_offset(lv, (S19426C3*), ABISELECT(56,28), "S19426C13");
    /*is_ambiguous_... S19426C13::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*), 0, "S19426C13");
    check_field_offset(lv, s19426c13f0, ABISELECT(8,4), "S19426C13.s19426c13f0");
    test_class_info(&lv, &cd_S19426C13);
    dp->~S19426C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C13(Test_S19426C13, "S19426C13", ABISELECT(96,52));

#else // __cplusplus

extern void _ZN9S19426C13C1Ev();
extern void _ZN9S19426C13D2Ev();
Name_Map name_map_S19426C13[] = {
  NSPAIR(_ZN9S19426C13C1Ev),
  NSPAIR(_ZN9S19426C13D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C14;
extern VTBL_ENTRY _ZTI9S19426C14[];
extern  VTBL_ENTRY _ZTV9S19426C14[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C3;
extern VTBL_ENTRY _ZTI8S19426C3[];
extern  VTBL_ENTRY _ZTV8S19426C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C3[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
static Base_Class bases_S19426C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(24,12), //bcp->offset
    41, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19426C14,    ABISELECT(16,8), //bcp->offset
    18, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(88,48), //bcp->offset
    82, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(80,44), //bcp->offset
    69, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19426C3,    ABISELECT(56,28), //bcp->offset
    46, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19426C13[];
extern void _ZN9S19426C13D1Ev();
extern void _ZN9S19426C13D0Ev();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN9S19426C133v47Ev();
extern void _ZN9S19426C133v48Ev();
extern void _ZN9S19426C133v49Ev();
extern void _ZN9S19426C133v50Ev();
extern void _ZN9S19426C133v51Ev();
extern void _ZN9S19426C133v52Ev();
extern void _ZN9S19426C133v53Ev();
extern void _ZN9S19426C133v54Ev();
extern void _ZN9S19426C133v55Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev)();
extern void ABISELECT(_ZThn16_N9S19426C13D1Ev,_ZThn8_N9S19426C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev)();
extern void ABISELECT(_ZThn16_N9S19426C13D0Ev,_ZThn8_N9S19426C13D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
extern void ABISELECT(_ZTvn8_n24_N9S19426C13D1Ev,_ZTvn4_n12_N9S19426C13D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C13D0Ev,_ZTvn4_n12_N9S19426C13D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev)();
extern void ABISELECT(_ZThn56_N9S19426C13D1Ev,_ZThn28_N9S19426C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev)();
extern void ABISELECT(_ZThn56_N9S19426C13D0Ev,_ZThn28_N9S19426C13D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev)();
extern void ABISELECT(_ZThn80_N9S19426C13D1Ev,_ZThn44_N9S19426C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev)();
extern void ABISELECT(_ZThn80_N9S19426C13D0Ev,_ZThn44_N9S19426C13D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void ABISELECT(_ZTvn8_n24_N9S19426C13D1Ev,_ZTvn4_n12_N9S19426C13D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C13D0Ev,_ZTvn4_n12_N9S19426C13D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY vtc_S19426C13[] = {
  ABISELECT(80,44),
  ABISELECT(56,28),
  ABISELECT(16,8),
  ABISELECT(56,28),
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&_ZN9S19426C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19426C13D0Ev,
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v47Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v48Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v49Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v50Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v51Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v52Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v53Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v54Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v55Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C13D1Ev,_ZTvn4_n12_N9S19426C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C13D0Ev,_ZTvn4_n12_N9S19426C13D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,16),
  0,
  0,
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C13D1Ev,_ZTvn4_n12_N9S19426C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C13D0Ev,_ZTvn4_n12_N9S19426C13D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern VTBL_ENTRY _ZTV9S19426C13[];
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void _ZN8S19426C3D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN8S19426C3D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__9S19426C13[] = {
  0,
  ABISELECT(24,16),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZThn24_N8S19426C3D1Ev,_ZThn16_N8S19426C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void ABISELECT(_ZThn24_N8S19426C3D0Ev,_ZThn16_N8S19426C3D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__8S19426C3__9S19426C13[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__9S19426C13[] = {
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
static  VTT_ENTRY vtt_S19426C13[] = {
  {&(_ZTV9S19426C13[6]),  6,87},
  {&(_ZTV9S19426C13[59]),  59,87},
  {&(_ZTV9S19426C13[30]),  30,87},
  {&(_ZTV9S19426C13[43]),  43,87},
  {&(_ZTV9S19426C13[59]),  59,87},
  {&(_ZTV9S19426C13[76]),  76,87},
  {&(_ZTV9S19426C13[84]),  84,87},
  {&(_tg__ZTV8S19426C3__9S19426C13[7]),  7,17},
  {&(_tg__ZTV8S19426C4__8S19426C3__9S19426C13[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__9S19426C13[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9S19426C13[7]),  7,17},
};
extern VTBL_ENTRY _ZTI9S19426C13[];
extern  VTBL_ENTRY _ZTV9S19426C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C13[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S19426C3D0Ev,_ZThn16_N8S19426C3D0Ev),
  (VTBL_ENTRY)_ZN8S19426C3D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S19426C3D1Ev,_ZThn16_N8S19426C3D1Ev),
  (VTBL_ENTRY)_ZN8S19426C3D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19426C13D0Ev,_ZThn44_N9S19426C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S19426C13D0Ev,_ZThn28_N9S19426C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19426C13D0Ev,_ZThn8_N9S19426C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19426C13D1Ev,_ZThn44_N9S19426C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S19426C13D1Ev,_ZThn28_N9S19426C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19426C13D1Ev,_ZThn8_N9S19426C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19426C13 = {  "S19426C13", // class name
  bases_S19426C13, 13,
  &(vtc_S19426C13[0]), // expected_vtbl_contents
  &(vtt_S19426C13[0]), // expected_vtt_contents
  ABISELECT(96,52), // object size
  NSPAIRA(_ZTI9S19426C13),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19426C13),87, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19426C13),11, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C16  {
  int s19426c16f0;
  virtual  ~S19426C16(); // _ZN9S19426C16D1Ev
  virtual void  v56(); // _ZN9S19426C163v56Ev
  virtual void  v57(); // _ZN9S19426C163v57Ev
  virtual void  v58(); // _ZN9S19426C163v58Ev
  virtual void  v59(); // _ZN9S19426C163v59Ev
  virtual void  v60(); // _ZN9S19426C163v60Ev
  virtual void  v61(); // _ZN9S19426C163v61Ev
  S19426C16(); // tgen
};
//SIG(-1 S19426C16) C1{ vd v1 v2 v3 v4 v5 v6 Fi}


 S19426C16 ::~S19426C16(){ note_dtor("S19426C16", this);}
void  S19426C16 ::v56(){vfunc_called(this, "_ZN9S19426C163v56Ev");}
void  S19426C16 ::v57(){vfunc_called(this, "_ZN9S19426C163v57Ev");}
void  S19426C16 ::v58(){vfunc_called(this, "_ZN9S19426C163v58Ev");}
void  S19426C16 ::v59(){vfunc_called(this, "_ZN9S19426C163v59Ev");}
void  S19426C16 ::v60(){vfunc_called(this, "_ZN9S19426C163v60Ev");}
void  S19426C16 ::v61(){vfunc_called(this, "_ZN9S19426C163v61Ev");}
S19426C16 ::S19426C16(){ note_ctor("S19426C16", this);} // tgen

static void Test_S19426C16()
{
  extern Class_Descriptor cd_S19426C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S19426C16, buf);
    S19426C16 *dp, &lv = *(dp=new (buf) S19426C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S19426C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C16)");
    check_field_offset(lv, s19426c16f0, ABISELECT(8,4), "S19426C16.s19426c16f0");
    test_class_info(&lv, &cd_S19426C16);
    dp->~S19426C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C16(Test_S19426C16, "S19426C16", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN9S19426C16C1Ev();
extern void _ZN9S19426C16D1Ev();
Name_Map name_map_S19426C16[] = {
  NSPAIR(_ZN9S19426C16C1Ev),
  NSPAIR(_ZN9S19426C16D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S19426C16[];
extern void _ZN9S19426C16D1Ev();
extern void _ZN9S19426C16D0Ev();
extern void _ZN9S19426C163v56Ev();
extern void _ZN9S19426C163v57Ev();
extern void _ZN9S19426C163v58Ev();
extern void _ZN9S19426C163v59Ev();
extern void _ZN9S19426C163v60Ev();
extern void _ZN9S19426C163v61Ev();
static  VTBL_ENTRY vtc_S19426C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C16[0]),
  (VTBL_ENTRY)&_ZN9S19426C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19426C16D0Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v56Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v57Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v58Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v59Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v60Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v61Ev,
};
extern VTBL_ENTRY _ZTI9S19426C16[];
extern  VTBL_ENTRY _ZTV9S19426C16[];
Class_Descriptor cd_S19426C16 = {  "S19426C16", // class name
  0,0,//no base classes
  &(vtc_S19426C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S19426C16),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S19426C16),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C17  : virtual S19426C4 , virtual S19426C5_nt , virtual S19426C14 , virtual S19426C3 , virtual S19426C6_nt {
  virtual void  v62(); // _ZN9S19426C173v62Ev
  virtual void  v63(); // _ZN9S19426C173v63Ev
  virtual void  v64(); // _ZN9S19426C173v64Ev
  ~S19426C17(); // tgen
  S19426C17(); // tgen
};
//SIG(-1 S19426C17) C1{ VBC2{ BC3{ BC4{ vd v4} vd v5} BC4 vd v6 v7} VBC3 VBC5{ BC2 vd v8 v9 v10 v11 v12 FC2 FC4} VBC6{ VBC2 VBC3 vd v13 v14 v15 v16 v17 v18 Fi Fc Fi} VBC4 v1 v2 v3}


void  S19426C17 ::v62(){vfunc_called(this, "_ZN9S19426C173v62Ev");}
void  S19426C17 ::v63(){vfunc_called(this, "_ZN9S19426C173v63Ev");}
void  S19426C17 ::v64(){vfunc_called(this, "_ZN9S19426C173v64Ev");}
S19426C17 ::~S19426C17(){ note_dtor("S19426C17", this);} // tgen
S19426C17 ::S19426C17(){ note_ctor("S19426C17", this);} // tgen

static void Test_S19426C17()
{
  extern Class_Descriptor cd_S19426C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,13)];
    init_test(&cd_S19426C17, buf);
    S19426C17 *dp, &lv = *(dp=new (buf) S19426C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,48), "sizeof(S19426C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C17)");
    /*is_ambiguous_... S19426C17::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), ABISELECT(8,4), "S19426C17");
    /*is_ambiguous_... S19426C17::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), ABISELECT(8,4), "S19426C17");
    /*is_ambiguous_... S19426C17::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(16,8), "S19426C17");
    /*is_ambiguous_... S19426C17::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C4*), ABISELECT(8,4), "S19426C17");
    check_base_class_offset(lv, (S19426C4*)(S19426C3*), ABISELECT(8,4), "S19426C17");
    /*is_ambiguous_... S19426C17::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*), ABISELECT(64,32), "S19426C17");
    /*is_ambiguous_... S19426C17::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*), ABISELECT(64,32), "S19426C17");
    /*is_ambiguous_... S19426C3::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C3*), ABISELECT(64,32), "S19426C17");
    check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*)(S19426C14*), ABISELECT(24,12), "S19426C17");
    check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*)(S19426C14*), ABISELECT(24,12), "S19426C17");
    /*is_ambiguous_... S19426C4::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*)(S19426C14*), ABISELECT(32,16), "S19426C17");
    check_base_class_offset(lv, (S19426C4*)(S19426C14*), ABISELECT(24,12), "S19426C17");
    check_base_class_offset(lv, (S19426C14*), ABISELECT(24,12), "S19426C17");
    check_base_class_offset(lv, (S19426C3*), ABISELECT(64,32), "S19426C17");
    /*is_ambiguous_... S19426C17::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*), 0, "S19426C17");
    test_class_info(&lv, &cd_S19426C17);
    dp->~S19426C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C17(Test_S19426C17, "S19426C17", ABISELECT(88,48));

#else // __cplusplus

extern void _ZN9S19426C17C1Ev();
extern void _ZN9S19426C17D1Ev();
Name_Map name_map_S19426C17[] = {
  NSPAIR(_ZN9S19426C17C1Ev),
  NSPAIR(_ZN9S19426C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C14;
extern VTBL_ENTRY _ZTI9S19426C14[];
extern  VTBL_ENTRY _ZTV9S19426C14[];
extern Class_Descriptor cd_S19426C3;
extern VTBL_ENTRY _ZTI8S19426C3[];
extern  VTBL_ENTRY _ZTV8S19426C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C3[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
static Base_Class bases_S19426C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(16,8), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(8,4), //bcp->offset
    15, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(32,16), //bcp->offset
    56, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19426C14,    ABISELECT(24,12), //bcp->offset
    33, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C3,    ABISELECT(64,32), //bcp->offset
    61, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19426C17[];
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void _ZN9S19426C17D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void _ZN9S19426C17D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN9S19426C173v62Ev();
extern void _ZN9S19426C173v63Ev();
extern void _ZN9S19426C173v64Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZThn8_N9S19426C17D1Ev,_ZThn4_N9S19426C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void ABISELECT(_ZThn8_N9S19426C17D0Ev,_ZThn4_N9S19426C17D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZThn24_N9S19426C17D1Ev,_ZThn12_N9S19426C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void ABISELECT(_ZThn24_N9S19426C17D0Ev,_ZThn12_N9S19426C17D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZThn64_N9S19426C17D1Ev,_ZThn32_N9S19426C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void ABISELECT(_ZThn64_N9S19426C17D0Ev,_ZThn32_N9S19426C17D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY vtc_S19426C17[] = {
  0,
  ABISELECT(64,32),
  ABISELECT(24,12),
  ABISELECT(64,32),
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v62Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v63Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v64Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-28),
  0,
  0,
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern VTBL_ENTRY _ZTV9S19426C17[];
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void _ZN8S19426C3D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN8S19426C3D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__9S19426C17[] = {
  0,
  ABISELECT(-56,-28),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__8S19426C3__9S19426C17[] = {
  0,
  0,
  0,
  0,
  ABISELECT(56,28),
  ABISELECT(56,28),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__9S19426C17[] = {
  ABISELECT(48,24),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
static  VTT_ENTRY vtt_S19426C17[] = {
  {&(_ZTV9S19426C17[9]),  9,84},
  {&(_ZTV9S19426C17[22]),  22,84},
  {&(_ZTV9S19426C17[30]),  30,84},
  {&(_ZTV9S19426C17[74]),  74,84},
  {&(_ZTV9S19426C17[45]),  45,84},
  {&(_ZTV9S19426C17[58]),  58,84},
  {&(_ZTV9S19426C17[74]),  74,84},
  {&(_ZTV9S19426C17[9]),  9,84},
  {&(_tg__ZTV8S19426C3__9S19426C17[7]),  7,17},
  {&(_tg__ZTV8S19426C4__8S19426C3__9S19426C17[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__9S19426C17[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9S19426C17[7]),  7,17},
};
extern VTBL_ENTRY _ZTI9S19426C17[];
extern  VTBL_ENTRY _ZTV9S19426C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C17[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev), // 
  (VTBL_ENTRY)_ZN8S19426C3D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev), // 
  (VTBL_ENTRY)_ZN8S19426C3D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S19426C17D0Ev,_ZThn32_N9S19426C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19426C17D0Ev,_ZThn12_N9S19426C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19426C17D0Ev,_ZThn4_N9S19426C17D0Ev),
  (VTBL_ENTRY)_ZN9S19426C17D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S19426C17D1Ev,_ZThn32_N9S19426C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S19426C17D1Ev,_ZThn12_N9S19426C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19426C17D1Ev,_ZThn4_N9S19426C17D1Ev),
  (VTBL_ENTRY)_ZN9S19426C17D1Ev,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19426C17 = {  "S19426C17", // class name
  bases_S19426C17, 13,
  &(vtc_S19426C17[0]), // expected_vtbl_contents
  &(vtt_S19426C17[0]), // expected_vtt_contents
  ABISELECT(88,48), // object size
  NSPAIRA(_ZTI9S19426C17),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19426C17),84, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19426C17),12, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C18  : virtual S19426C14 , virtual S19426C11 , virtual S19426C6_nt {
  virtual  ~S19426C18(); // _ZN9S19426C18D2Ev
  virtual void  v65(); // _ZN9S19426C183v65Ev
  S19426C18(); // tgen
};
//SIG(-1 S19426C18) C1{ VBC2{ BC3{ BC4{ BC5{ vd v2} vd v3} BC5 vd v4 v5} vd v6 v7 v8 v9 v10 FC3 FC5} VBC6{ v11 v12 v13 v14 v15 v16 v17 v18} VBC5 vd v1}


 S19426C18 ::~S19426C18(){ note_dtor("S19426C18", this);}
void  S19426C18 ::v65(){vfunc_called(this, "_ZN9S19426C183v65Ev");}
S19426C18 ::S19426C18(){ note_ctor("S19426C18", this);} // tgen

static void Test_S19426C18()
{
  extern Class_Descriptor cd_S19426C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[8];
    init_test(&cd_S19426C18, buf);
    S19426C18 *dp, &lv = *(dp=new (buf) S19426C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,28), "sizeof(S19426C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C18)");
    check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*)(S19426C14*), ABISELECT(8,4), "S19426C18");
    check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*)(S19426C14*), ABISELECT(8,4), "S19426C18");
    /*is_ambiguous_... S19426C4::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*)(S19426C14*), ABISELECT(16,8), "S19426C18");
    check_base_class_offset(lv, (S19426C4*)(S19426C14*), ABISELECT(8,4), "S19426C18");
    check_base_class_offset(lv, (S19426C14*), ABISELECT(8,4), "S19426C18");
    check_base_class_offset(lv, (S19426C11*), 0, "S19426C18");
    /*is_ambiguous_... S19426C18::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*), ABISELECT(48,24), "S19426C18");
    test_class_info(&lv, &cd_S19426C18);
    dp->~S19426C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C18(Test_S19426C18, "S19426C18", ABISELECT(56,28));

#else // __cplusplus

extern void _ZN9S19426C18C1Ev();
extern void _ZN9S19426C18D2Ev();
Name_Map name_map_S19426C18[] = {
  NSPAIR(_ZN9S19426C18C1Ev),
  NSPAIR(_ZN9S19426C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C14;
extern VTBL_ENTRY _ZTI9S19426C14[];
extern  VTBL_ENTRY _ZTV9S19426C14[];
extern Class_Descriptor cd_S19426C11;
extern VTBL_ENTRY _ZTI9S19426C11[];
extern  VTBL_ENTRY _ZTV9S19426C11[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
static Base_Class bases_S19426C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(16,8), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19426C14,    ABISELECT(8,4), //bcp->offset
    24, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    ABISELECT(48,24), //bcp->offset
    52, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19426C18[];
extern void _ZN9S19426C113v24Ev();
extern void _ZN9S19426C113v25Ev();
extern void _ZN9S19426C113v26Ev();
extern void _ZN9S19426C113v27Ev();
extern void _ZN9S19426C113v28Ev();
extern void _ZN9S19426C113v29Ev();
extern void _ZN9S19426C113v30Ev();
extern void _ZN9S19426C113v31Ev();
extern void _ZN9S19426C18D1Ev();
extern void _ZN9S19426C18D0Ev();
extern void _ZN9S19426C183v65Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev)();
extern void ABISELECT(_ZThn8_N9S19426C18D1Ev,_ZThn4_N9S19426C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev)();
extern void ABISELECT(_ZThn8_N9S19426C18D0Ev,_ZThn4_N9S19426C18D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
extern void ABISELECT(_ZTvn8_n24_N9S19426C18D1Ev,_ZTvn4_n12_N9S19426C18D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C18D0Ev,_ZTvn4_n12_N9S19426C18D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev)();
extern void ABISELECT(_ZThn48_N9S19426C18D1Ev,_ZThn24_N9S19426C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev)();
extern void ABISELECT(_ZThn48_N9S19426C18D0Ev,_ZThn24_N9S19426C18D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY vtc_S19426C18[] = {
  ABISELECT(48,24),
  0,
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&_ZN9S19426C113v24Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v25Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v26Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v27Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v28Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v29Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v30Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v31Ev,
  (VTBL_ENTRY)&_ZN9S19426C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19426C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19426C183v65Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C18D1Ev,_ZTvn4_n12_N9S19426C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C18D0Ev,_ZTvn4_n12_N9S19426C18D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  0,
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern VTBL_ENTRY _ZTV9S19426C18[];
static  VTT_ENTRY vtt_S19426C18[] = {
  {&(_ZTV9S19426C18[13]),  13,59},
  {&(_ZTV9S19426C18[36]),  36,59},
  {&(_ZTV9S19426C18[49]),  49,59},
  {&(_ZTV9S19426C18[13]),  13,59},
  {&(_ZTV9S19426C18[56]),  56,59},
};
extern VTBL_ENTRY _ZTI9S19426C18[];
extern  VTBL_ENTRY _ZTV9S19426C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C18[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19426C18D0Ev,_ZThn24_N9S19426C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19426C18D0Ev,_ZThn4_N9S19426C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19426C18D1Ev,_ZThn24_N9S19426C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S19426C18D1Ev,_ZThn4_N9S19426C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19426C18 = {  "S19426C18", // class name
  bases_S19426C18, 7,
  &(vtc_S19426C18[0]), // expected_vtbl_contents
  &(vtt_S19426C18[0]), // expected_vtt_contents
  ABISELECT(56,28), // object size
  NSPAIRA(_ZTI9S19426C18),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19426C18),59, //virtual function table var
  13, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19426C18),5, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C15  : virtual S19426C16 , virtual S19426C4 , S19426C17 , S19426C18 {
  void *s19426c15f0;
  int s19426c15f1;
  char s19426c15f2;
  virtual void  v66(); // _ZN9S19426C153v66Ev
  virtual void  v67(); // _ZN9S19426C153v67Ev
  ~S19426C15(); // tgen
  S19426C15(); // tgen
};
//SIG(-1 S19426C15) C1{ VBC2{ vd v3 v4 v5 v6 v7 v8 Fi} VBC3{ BC4{ BC5{ vd v9} vd v10} BC5 vd v11 v12} BC6{ VBC3 VBC4 VBC7{ BC3 vd v13 v14 v15 v16 v17 FC3 FC5} VBC8{ VBC3 VBC4 vd v18 v19 v20 v21 v22 v23 Fi Fc Fi} VBC5 v24 v25 v26} BC9{ VBC7 VBC10{ v27 v28 v29 v30 v31 v32 v33 v34} VBC5 vd v35} v1 v2 Fp Fi Fc}


void  S19426C15 ::v66(){vfunc_called(this, "_ZN9S19426C153v66Ev");}
void  S19426C15 ::v67(){vfunc_called(this, "_ZN9S19426C153v67Ev");}
S19426C15 ::~S19426C15(){ note_dtor("S19426C15", this);} // tgen
S19426C15 ::S19426C15(){ note_ctor("S19426C15", this);} // tgen

static void Test_S19426C15()
{
  extern Class_Descriptor cd_S19426C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,19)];
    init_test(&cd_S19426C15, buf);
    S19426C15 *dp, &lv = *(dp=new (buf) S19426C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,72), "sizeof(S19426C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C15)");
    check_base_class_offset(lv, (S19426C16*), ABISELECT(32,20), "S19426C15");
    /*is_ambiguous_... S19426C15::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), ABISELECT(48,28), "S19426C15");
    /*is_ambiguous_... S19426C15::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), ABISELECT(48,28), "S19426C15");
    /*is_ambiguous_... S19426C15::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(56,32), "S19426C15");
    /*is_ambiguous_... S19426C15::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C4*), ABISELECT(48,28), "S19426C15");
    /*is_ambiguous_... S19426C17::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C4*)(S19426C17*), ABISELECT(48,28), "S19426C15");
    check_base_class_offset(lv, (S19426C4*)(S19426C3*), ABISELECT(48,28), "S19426C15");
    /*is_ambiguous_... S19426C15::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*), ABISELECT(104,56), "S19426C15");
    /*is_ambiguous_... S19426C17::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C17*), ABISELECT(104,56), "S19426C15");
    /*is_ambiguous_... S19426C3::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C3*), ABISELECT(104,56), "S19426C15");
    check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*)(S19426C14*), ABISELECT(64,36), "S19426C15");
    check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*)(S19426C14*), ABISELECT(64,36), "S19426C15");
    /*is_ambiguous_... S19426C4::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*)(S19426C14*), ABISELECT(72,40), "S19426C15");
    check_base_class_offset(lv, (S19426C4*)(S19426C14*), ABISELECT(64,36), "S19426C15");
    check_base_class_offset(lv, (S19426C14*)(S19426C17*), ABISELECT(64,36), "S19426C15");
    check_base_class_offset(lv, (S19426C14*)(S19426C18*), ABISELECT(64,36), "S19426C15");
    check_base_class_offset(lv, (S19426C3*)(S19426C17*), ABISELECT(104,56), "S19426C15");
    /*is_ambiguous_... S19426C17::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C17*), 0, "S19426C15");
    /*is_ambiguous_... S19426C18::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C18*), 0, "S19426C15");
    check_base_class_offset(lv, (S19426C17*), 0, "S19426C15");
    check_base_class_offset(lv, (S19426C11*)(S19426C18*), ABISELECT(8,4), "S19426C15");
    check_base_class_offset(lv, (S19426C18*), ABISELECT(8,4), "S19426C15");
    check_field_offset(lv, s19426c15f0, ABISELECT(16,8), "S19426C15.s19426c15f0");
    check_field_offset(lv, s19426c15f1, ABISELECT(24,12), "S19426C15.s19426c15f1");
    check_field_offset(lv, s19426c15f2, ABISELECT(28,16), "S19426C15.s19426c15f2");
    test_class_info(&lv, &cd_S19426C15);
    dp->~S19426C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C15(Test_S19426C15, "S19426C15", ABISELECT(128,72));

#else // __cplusplus

extern void _ZN9S19426C15C1Ev();
extern void _ZN9S19426C15D1Ev();
Name_Map name_map_S19426C15[] = {
  NSPAIR(_ZN9S19426C15C1Ev),
  NSPAIR(_ZN9S19426C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C16;
extern VTBL_ENTRY _ZTI9S19426C16[];
extern  VTBL_ENTRY _ZTV9S19426C16[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C14;
extern VTBL_ENTRY _ZTI9S19426C14[];
extern  VTBL_ENTRY _ZTV9S19426C14[];
extern Class_Descriptor cd_S19426C3;
extern VTBL_ENTRY _ZTI8S19426C3[];
extern  VTBL_ENTRY _ZTV8S19426C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C3[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C17;
extern VTBL_ENTRY _ZTI9S19426C17[];
extern  VTBL_ENTRY _ZTV9S19426C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C17[];
extern Class_Descriptor cd_S19426C11;
extern VTBL_ENTRY _ZTI9S19426C11[];
extern  VTBL_ENTRY _ZTV9S19426C11[];
extern Class_Descriptor cd_S19426C18;
extern VTBL_ENTRY _ZTI9S19426C18[];
extern  VTBL_ENTRY _ZTV9S19426C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C18[];
static Base_Class bases_S19426C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C16,    ABISELECT(32,20), //bcp->offset
    43, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(56,32), //bcp->offset
    73, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(48,28), //bcp->offset
    60, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    ABISELECT(104,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(104,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S19426C6_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(72,40), //bcp->offset
    101, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19426C14,    ABISELECT(64,36), //bcp->offset
    78, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19426C3,    ABISELECT(104,56), //bcp->offset
    106, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19426C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S19426C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19426C11,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S19426C18,    ABISELECT(8,4), //bcp->offset
    19, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19426C15[];
extern void ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev)();
extern void _ZN9S19426C15D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev)();
extern void _ZN9S19426C15D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN9S19426C173v62Ev();
extern void _ZN9S19426C173v63Ev();
extern void _ZN9S19426C173v64Ev();
extern void _ZN9S19426C153v66Ev();
extern void _ZN9S19426C153v67Ev();
extern void _ZN9S19426C113v24Ev();
extern void _ZN9S19426C113v25Ev();
extern void _ZN9S19426C113v26Ev();
extern void _ZN9S19426C113v27Ev();
extern void _ZN9S19426C113v28Ev();
extern void _ZN9S19426C113v29Ev();
extern void _ZN9S19426C113v30Ev();
extern void _ZN9S19426C113v31Ev();
extern void ABISELECT(_ZThn8_N9S19426C15D1Ev,_ZThn4_N9S19426C15D1Ev)();
extern void ABISELECT(_ZThn8_N9S19426C15D0Ev,_ZThn4_N9S19426C15D0Ev)();
extern void _ZN9S19426C183v65Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZThn32_N9S19426C15D1Ev,_ZThn20_N9S19426C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev)();
extern void ABISELECT(_ZThn32_N9S19426C15D0Ev,_ZThn20_N9S19426C15D0Ev)() __attribute__((weak));
extern void _ZN9S19426C163v56Ev();
extern void _ZN9S19426C163v57Ev();
extern void _ZN9S19426C163v58Ev();
extern void _ZN9S19426C163v59Ev();
extern void _ZN9S19426C163v60Ev();
extern void _ZN9S19426C163v61Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZThn48_N9S19426C15D1Ev,_ZThn28_N9S19426C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev)();
extern void ABISELECT(_ZThn48_N9S19426C15D0Ev,_ZThn28_N9S19426C15D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void ABISELECT(_ZTvn8_n24_N9S19426C15D1Ev,_ZTvn4_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C15D0Ev,_ZTvn4_n12_N9S19426C15D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZThn64_N9S19426C15D1Ev,_ZThn36_N9S19426C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev)();
extern void ABISELECT(_ZThn64_N9S19426C15D0Ev,_ZThn36_N9S19426C15D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
extern void ABISELECT(_ZTvn8_n24_N9S19426C15D1Ev,_ZTvn4_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C15D0Ev,_ZTvn4_n12_N9S19426C15D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZThn104_N9S19426C15D1Ev,_ZThn56_N9S19426C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev)();
extern void ABISELECT(_ZThn104_N9S19426C15D0Ev,_ZThn56_N9S19426C15D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY vtc_S19426C15[] = {
  ABISELECT(8,4),
  ABISELECT(32,20),
  0,
  ABISELECT(104,56),
  ABISELECT(64,36),
  ABISELECT(104,56),
  ABISELECT(48,28),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v62Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v63Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v64Ev,
  (VTBL_ENTRY)&_ZN9S19426C153v66Ev,
  (VTBL_ENTRY)&_ZN9S19426C153v67Ev,
  ABISELECT(-8,-4),
  0,
  ABISELECT(56,32),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&_ZN9S19426C113v24Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v25Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v26Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v27Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v28Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v29Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v30Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v31Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S19426C15D1Ev,_ZThn4_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S19426C15D0Ev,_ZThn4_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19426C183v65Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19426C163v56Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v57Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v58Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v59Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v60Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v61Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C15D1Ev,_ZTvn4_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C15D0Ev,_ZTvn4_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C15D1Ev,_ZTvn4_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C15D0Ev,_ZTvn4_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-28),
  0,
  0,
  ABISELECT(-104,-56),
  ABISELECT(-104,-56),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern VTBL_ENTRY _ZTV9S19426C15[];
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void _ZN9S19426C17D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void _ZN9S19426C17D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN9S19426C173v62Ev();
extern void _ZN9S19426C173v63Ev();
extern void _ZN9S19426C173v64Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C17__9S19426C15[] = {
  0,
  ABISELECT(104,56),
  ABISELECT(64,36),
  ABISELECT(104,56),
  ABISELECT(48,28),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v62Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v63Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v64Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZThn48_N9S19426C17D1Ev,_ZThn28_N9S19426C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void ABISELECT(_ZThn48_N9S19426C17D0Ev,_ZThn28_N9S19426C17D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__9S19426C17__9S19426C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__9S19426C17__9S19426C15[] = {
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZThn104_N9S19426C17D1Ev,_ZThn56_N9S19426C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void ABISELECT(_ZThn104_N9S19426C17D0Ev,_ZThn56_N9S19426C17D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__9S19426C17__9S19426C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-28),
  0,
  0,
  ABISELECT(-104,-56),
  ABISELECT(-104,-56),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZThn64_N9S19426C17D1Ev,_ZThn36_N9S19426C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void ABISELECT(_ZThn64_N9S19426C17D0Ev,_ZThn36_N9S19426C17D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C14__9S19426C17__9S19426C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
};
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C49S19426C14__A4__9S19426C17__9S19426C15[] = {
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void _ZN9S19426C113v24Ev();
extern void _ZN9S19426C113v25Ev();
extern void _ZN9S19426C113v26Ev();
extern void _ZN9S19426C113v27Ev();
extern void _ZN9S19426C113v28Ev();
extern void _ZN9S19426C113v29Ev();
extern void _ZN9S19426C113v30Ev();
extern void _ZN9S19426C113v31Ev();
extern void _ZN9S19426C18D1Ev();
extern void _ZN9S19426C18D0Ev();
extern void _ZN9S19426C183v65Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C18__9S19426C15[] = {
  ABISELECT(-8,-4),
  0,
  ABISELECT(56,32),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&_ZN9S19426C113v24Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v25Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v26Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v27Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v28Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v29Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v30Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v31Ev,
  (VTBL_ENTRY)&_ZN9S19426C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19426C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19426C183v65Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev)();
extern void ABISELECT(_ZThn56_N9S19426C18D1Ev,_ZThn32_N9S19426C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev)();
extern void ABISELECT(_ZThn56_N9S19426C18D0Ev,_ZThn32_N9S19426C18D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C14__9S19426C18__9S19426C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
};
extern void ABISELECT(_ZTvn8_n24_N9S19426C18D1Ev,_ZTvn4_n12_N9S19426C18D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C18D0Ev,_ZTvn4_n12_N9S19426C18D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C49S19426C14__A1__9S19426C18__9S19426C15[] = {
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C18D1Ev,_ZTvn4_n12_N9S19426C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C18D0Ev,_ZTvn4_n12_N9S19426C18D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt__A2__9S19426C18__9S19426C15[] = {
  0,
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void _ZN8S19426C3D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN8S19426C3D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__9S19426C15[] = {
  0,
  ABISELECT(-56,-28),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__8S19426C3__9S19426C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(56,28),
  ABISELECT(56,28),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__9S19426C15[] = {
  ABISELECT(48,24),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
static  VTT_ENTRY vtt_S19426C15[] = {
  {&(_ZTV9S19426C15[11]),  11,129},
  {&(_tg__ZTV9S19426C17__9S19426C15[9]),  9,15},
  {&(_tg__ZTV8S19426C4__9S19426C17__9S19426C15[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__9S19426C17__9S19426C15[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9S19426C17__9S19426C15[13]),  13,23},
  {&(_tg__ZTV9S19426C14__9S19426C17__9S19426C15[12]),  12,23},
  {&(_tg__ZTV11S19426C6_nt8S19426C49S19426C14__A4__9S19426C17__9S19426C15[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9S19426C17__9S19426C15[13]),  13,23},
  {&(_tg__ZTV9S19426C17__9S19426C15[9]),  9,15},
  {&(_tg__ZTV9S19426C18__9S19426C15[13]),  13,24},
  {&(_tg__ZTV9S19426C14__9S19426C18__9S19426C15[12]),  12,23},
  {&(_tg__ZTV11S19426C6_nt8S19426C49S19426C14__A1__9S19426C18__9S19426C15[2]),  2,5},
  {&(_tg__ZTV9S19426C18__9S19426C15[13]),  13,24},
  {&(_tg__ZTV11S19426C6_nt__A2__9S19426C18__9S19426C15[4]),  4,7},
  {&(_ZTV9S19426C15[52]),  52,129},
  {&(_ZTV9S19426C15[67]),  67,129},
  {&(_ZTV9S19426C15[75]),  75,129},
  {&(_ZTV9S19426C15[119]),  119,129},
  {&(_ZTV9S19426C15[90]),  90,129},
  {&(_ZTV9S19426C15[103]),  103,129},
  {&(_ZTV9S19426C15[119]),  119,129},
  {&(_ZTV9S19426C15[11]),  11,129},
  {&(_ZTV9S19426C15[32]),  32,129},
  {&(_ZTV9S19426C15[32]),  32,129},
  {&(_tg__ZTV8S19426C3__9S19426C15[7]),  7,17},
  {&(_tg__ZTV8S19426C4__8S19426C3__9S19426C15[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__9S19426C15[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9S19426C15[7]),  7,17},
};
extern VTBL_ENTRY _ZTI9S19426C15[];
extern  VTBL_ENTRY _ZTV9S19426C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C15[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev), // 
  (VTBL_ENTRY)_ZN8S19426C3D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev), // 
  (VTBL_ENTRY)_ZN8S19426C3D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S19426C18D0Ev,_ZThn32_N9S19426C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N9S19426C18D1Ev,_ZThn32_N9S19426C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S19426C17D0Ev,_ZThn36_N9S19426C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn104_N9S19426C17D0Ev,_ZThn56_N9S19426C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19426C17D0Ev,_ZThn28_N9S19426C17D0Ev),
  (VTBL_ENTRY)_ZN9S19426C17D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S19426C17D1Ev,_ZThn36_N9S19426C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn104_N9S19426C17D1Ev,_ZThn56_N9S19426C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19426C17D1Ev,_ZThn28_N9S19426C17D1Ev),
  (VTBL_ENTRY)_ZN9S19426C17D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N9S19426C15D0Ev,_ZThn56_N9S19426C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S19426C15D0Ev,_ZThn36_N9S19426C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19426C15D0Ev,_ZThn28_N9S19426C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19426C15D0Ev,_ZThn20_N9S19426C15D0Ev),
  (VTBL_ENTRY)_ZN9S19426C15D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N9S19426C15D1Ev,_ZThn56_N9S19426C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S19426C15D1Ev,_ZThn36_N9S19426C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S19426C15D1Ev,_ZThn28_N9S19426C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S19426C15D1Ev,_ZThn20_N9S19426C15D1Ev),
  (VTBL_ENTRY)_ZN9S19426C15D1Ev,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19426C15 = {  "S19426C15", // class name
  bases_S19426C15, 17,
  &(vtc_S19426C15[0]), // expected_vtbl_contents
  &(vtt_S19426C15[0]), // expected_vtt_contents
  ABISELECT(128,72), // object size
  NSPAIRA(_ZTI9S19426C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19426C15),129, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19426C15),28, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19426C12  : virtual S19426C13 , S19426C7 , virtual S19426C15 , S19426C4 {
  int s19426c12f0;
  void *s19426c12f1;
  virtual  ~S19426C12(); // _ZN9S19426C12D2Ev
  S19426C12(); // tgen
};
//SIG(-1 S19426C12) C1{ VBC2{ VBC3{ BC4{ vd v1} vd v2} VBC5{ BC6{ BC3 BC4 vd v3 v4} vd v5 v6 v7 v8 v9 FC6 FC4} VBC7{ VBC6 VBC3 vd v10 v11 v12 v13 v14 v15 Fi Fc Fi} BC4 vd v16 v17 v18 v19 v20 v21 v22 v23 v24 Fs} BC8{ VBC6 v25 v26 v27 v28 Fi[2] Fp} VBC9{ VBC10{ vd v29 v30 v31 v32 v33 v34 Fi} VBC6 BC11{ VBC6 VBC3 VBC5 VBC7 VBC4 v35 v36 v37} BC12{ VBC5 VBC13{ v38 v39 v40 v41 v42 v43 v44 v45} VBC4 vd v46} v47 v48 Fp Fi Fc} BC6 vd Fi Fp}


 S19426C12 ::~S19426C12(){ note_dtor("S19426C12", this);}
S19426C12 ::S19426C12(){ note_ctor("S19426C12", this);} // tgen

static void Test_S19426C12()
{
  extern Class_Descriptor cd_S19426C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,29)];
    init_test(&cd_S19426C12, buf);
    S19426C12 *dp, &lv = *(dp=new (buf) S19426C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,112), "sizeof(S19426C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19426C12)");
    /*is_ambiguous_... S19426C12::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*), ABISELECT(112,60), "S19426C12");
    /*is_ambiguous_... S19426C13::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C13*), ABISELECT(112,60), "S19426C12");
    /*is_ambiguous_... S19426C3::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C3*), ABISELECT(112,60), "S19426C12");
    /*is_ambiguous_... S19426C17::S19426C5_nt */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C17*)(S19426C15*), ABISELECT(112,60), "S19426C12");
    check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*)(S19426C14*), ABISELECT(72,40), "S19426C12");
    check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*)(S19426C14*), ABISELECT(72,40), "S19426C12");
    /*is_ambiguous_... S19426C4::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*)(S19426C14*), ABISELECT(80,44), "S19426C12");
    check_base_class_offset(lv, (S19426C4*)(S19426C14*), ABISELECT(72,40), "S19426C12");
    check_base_class_offset(lv, (S19426C14*)(S19426C13*), ABISELECT(72,40), "S19426C12");
    check_base_class_offset(lv, (S19426C14*)(S19426C17*)(S19426C15*), ABISELECT(72,40), "S19426C12");
    check_base_class_offset(lv, (S19426C14*)(S19426C18*)(S19426C15*), ABISELECT(72,40), "S19426C12");
    /*is_ambiguous_... S19426C12::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), ABISELECT(136,76), "S19426C12");
    /*is_ambiguous_... S19426C12::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), ABISELECT(136,76), "S19426C12");
    /*is_ambiguous_... S19426C12::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(144,80), "S19426C12");
    check_base_class_offset(lv, (S19426C4*)(S19426C3*), ABISELECT(136,76), "S19426C12");
    check_base_class_offset(lv, (S19426C4*)(S19426C7*), ABISELECT(136,76), "S19426C12");
    /*is_ambiguous_... S19426C15::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C4*)(S19426C15*), ABISELECT(136,76), "S19426C12");
    /*is_ambiguous_... S19426C17::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C4*)(S19426C17*)(S19426C15*), ABISELECT(136,76), "S19426C12");
    check_base_class_offset(lv, (S19426C3*)(S19426C13*), ABISELECT(112,60), "S19426C12");
    check_base_class_offset(lv, (S19426C3*)(S19426C17*)(S19426C15*), ABISELECT(112,60), "S19426C12");
    /*is_ambiguous_... S19426C13::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C13*), ABISELECT(56,32), "S19426C12");
    check_base_class_offset(lv, (S19426C13*), ABISELECT(56,32), "S19426C12");
    check_base_class_offset(lv, (S19426C7*), 0, "S19426C12");
    check_base_class_offset(lv, (S19426C16*)(S19426C15*), ABISELECT(184,104), "S19426C12");
    /*is_ambiguous_... S19426C17::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C17*)(S19426C15*), ABISELECT(152,84), "S19426C12");
    /*is_ambiguous_... S19426C18::S19426C6_nt */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C18*)(S19426C15*), ABISELECT(152,84), "S19426C12");
    check_base_class_offset(lv, (S19426C17*)(S19426C15*), ABISELECT(152,84), "S19426C12");
    check_base_class_offset(lv, (S19426C11*)(S19426C18*)(S19426C15*), ABISELECT(160,88), "S19426C12");
    check_base_class_offset(lv, (S19426C18*)(S19426C15*), ABISELECT(160,88), "S19426C12");
    check_base_class_offset(lv, (S19426C15*), ABISELECT(152,84), "S19426C12");
    /*is_ambiguous_... S19426C12::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C5_nt*)(S19426C4*), ABISELECT(24,16), "S19426C12");
    /*is_ambiguous_... S19426C12::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C5_nt*)(S19426C4*), ABISELECT(24,16), "S19426C12");
    /*is_ambiguous_... S19426C12::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C6_nt*)(S19426C4*), ABISELECT(32,20), "S19426C12");
    /*is_ambiguous_... S19426C12::S19426C4 */ AMB_check_base_class_offset(lv, (S19426C4*), ABISELECT(24,16), "S19426C12");
    check_field_offset(lv, s19426c12f0, ABISELECT(40,24), "S19426C12.s19426c12f0");
    check_field_offset(lv, s19426c12f1, ABISELECT(48,28), "S19426C12.s19426c12f1");
    test_class_info(&lv, &cd_S19426C12);
    dp->~S19426C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19426C12(Test_S19426C12, "S19426C12", ABISELECT(200,112));

#else // __cplusplus

extern void _ZN9S19426C12C1Ev();
extern void _ZN9S19426C12D2Ev();
Name_Map name_map_S19426C12[] = {
  NSPAIR(_ZN9S19426C12C1Ev),
  NSPAIR(_ZN9S19426C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C14;
extern VTBL_ENTRY _ZTI9S19426C14[];
extern  VTBL_ENTRY _ZTV9S19426C14[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
extern Class_Descriptor cd_S19426C3;
extern VTBL_ENTRY _ZTI8S19426C3[];
extern  VTBL_ENTRY _ZTV8S19426C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C3[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C13;
extern VTBL_ENTRY _ZTI9S19426C13[];
extern  VTBL_ENTRY _ZTV9S19426C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C13[];
extern Class_Descriptor cd_S19426C7;
extern VTBL_ENTRY _ZTI8S19426C7[];
extern  VTBL_ENTRY _ZTV8S19426C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19426C7[];
extern Class_Descriptor cd_S19426C16;
extern VTBL_ENTRY _ZTI9S19426C16[];
extern  VTBL_ENTRY _ZTV9S19426C16[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C17;
extern VTBL_ENTRY _ZTI9S19426C17[];
extern  VTBL_ENTRY _ZTV9S19426C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C17[];
extern Class_Descriptor cd_S19426C11;
extern VTBL_ENTRY _ZTI9S19426C11[];
extern  VTBL_ENTRY _ZTV9S19426C11[];
extern Class_Descriptor cd_S19426C18;
extern VTBL_ENTRY _ZTI9S19426C18[];
extern  VTBL_ENTRY _ZTV9S19426C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C18[];
extern Class_Descriptor cd_S19426C15;
extern VTBL_ENTRY _ZTI9S19426C15[];
extern  VTBL_ENTRY _ZTV9S19426C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19426C15[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C5_nt;
extern VTBL_ENTRY _ZTI11S19426C5_nt[];
extern  VTBL_ENTRY _ZTV11S19426C5_nt[];
extern Class_Descriptor cd_S19426C6_nt;
extern VTBL_ENTRY _ZTI11S19426C6_nt[];
extern  VTBL_ENTRY _ZTV11S19426C6_nt[];
extern Class_Descriptor cd_S19426C4;
extern VTBL_ENTRY _ZTI8S19426C4[];
extern  VTBL_ENTRY _ZTV8S19426C4[];
static Base_Class bases_S19426C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19426C6_nt,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19426C6_nt,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(80,44), //bcp->offset
    82, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19426C14,    ABISELECT(72,40), //bcp->offset
    59, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19426C6_nt,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(144,80), //bcp->offset
    123, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(136,76), //bcp->offset
    110, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19426C3,    ABISELECT(112,60), //bcp->offset
    87, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19426C6_nt,    ABISELECT(56,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19426C13,    ABISELECT(56,32), //bcp->offset
    30, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19426C16,    ABISELECT(184,104), //bcp->offset
    177, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 1},
  {&cd_S19426C6_nt,    ABISELECT(152,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S19426C17,    ABISELECT(152,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19426C11,    ABISELECT(160,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S19426C18,    ABISELECT(160,88), //bcp->offset
    153, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19426C15,    ABISELECT(152,84), //bcp->offset
    128, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19426C6_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19426C5_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19426C6_nt,    ABISELECT(32,20), //bcp->offset
    25, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19426C4,    ABISELECT(24,16), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19426C12[];
extern void _ZN8S19426C73v17Ev();
extern void _ZN8S19426C73v18Ev();
extern void _ZN8S19426C73v19Ev();
extern void _ZN8S19426C73v20Ev();
extern void _ZN9S19426C12D1Ev();
extern void _ZN9S19426C12D0Ev();
extern void ABISELECT(_ZThn24_N9S19426C12D1Ev,_ZThn16_N9S19426C12D1Ev)();
extern void ABISELECT(_ZThn24_N9S19426C12D0Ev,_ZThn16_N9S19426C12D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void ABISELECT(_ZThn32_N9S19426C12D1Ev,_ZThn20_N9S19426C12D1Ev)();
extern void ABISELECT(_ZThn32_N9S19426C12D0Ev,_ZThn20_N9S19426C12D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n56_N9S19426C12D1Ev,_ZTv0_n28_N9S19426C12D1Ev)();
extern void ABISELECT(_ZThn56_N9S19426C12D1Ev,_ZThn32_N9S19426C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19426C12D0Ev,_ZTv0_n28_N9S19426C12D0Ev)();
extern void ABISELECT(_ZThn56_N9S19426C12D0Ev,_ZThn32_N9S19426C12D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN9S19426C133v47Ev();
extern void _ZN9S19426C133v48Ev();
extern void _ZN9S19426C133v49Ev();
extern void _ZN9S19426C133v50Ev();
extern void _ZN9S19426C133v51Ev();
extern void _ZN9S19426C133v52Ev();
extern void _ZN9S19426C133v53Ev();
extern void _ZN9S19426C133v54Ev();
extern void _ZN9S19426C133v55Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C12D1Ev,_ZTv0_n12_N9S19426C12D1Ev)();
extern void ABISELECT(_ZThn72_N9S19426C12D1Ev,_ZThn40_N9S19426C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C12D0Ev,_ZTv0_n12_N9S19426C12D0Ev)();
extern void ABISELECT(_ZThn72_N9S19426C12D0Ev,_ZThn40_N9S19426C12D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
extern void ABISELECT(_ZTvn8_n24_N9S19426C12D1Ev,_ZTvn4_n12_N9S19426C12D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C12D0Ev,_ZTvn4_n12_N9S19426C12D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C12D1Ev,_ZTv0_n12_N9S19426C12D1Ev)();
extern void ABISELECT(_ZThn112_N9S19426C12D1Ev,_ZThn60_N9S19426C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C12D0Ev,_ZTv0_n12_N9S19426C12D0Ev)();
extern void ABISELECT(_ZThn112_N9S19426C12D0Ev,_ZThn60_N9S19426C12D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C12D1Ev,_ZTv0_n12_N9S19426C12D1Ev)();
extern void ABISELECT(_ZThn136_N9S19426C12D1Ev,_ZThn76_N9S19426C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C12D0Ev,_ZTv0_n12_N9S19426C12D0Ev)();
extern void ABISELECT(_ZThn136_N9S19426C12D0Ev,_ZThn76_N9S19426C12D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void ABISELECT(_ZTvn8_n24_N9S19426C12D1Ev,_ZTvn4_n12_N9S19426C12D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C12D0Ev,_ZTvn4_n12_N9S19426C12D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C12D1Ev,_ZTv0_n12_N9S19426C12D1Ev)();
extern void ABISELECT(_ZThn152_N9S19426C12D1Ev,_ZThn84_N9S19426C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C12D0Ev,_ZTv0_n12_N9S19426C12D0Ev)();
extern void ABISELECT(_ZThn152_N9S19426C12D0Ev,_ZThn84_N9S19426C12D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN9S19426C173v62Ev();
extern void _ZN9S19426C173v63Ev();
extern void _ZN9S19426C173v64Ev();
extern void _ZN9S19426C153v66Ev();
extern void _ZN9S19426C153v67Ev();
extern void _ZN9S19426C113v24Ev();
extern void _ZN9S19426C113v25Ev();
extern void _ZN9S19426C113v26Ev();
extern void _ZN9S19426C113v27Ev();
extern void _ZN9S19426C113v28Ev();
extern void _ZN9S19426C113v29Ev();
extern void _ZN9S19426C113v30Ev();
extern void _ZN9S19426C113v31Ev();
extern void ABISELECT(_ZTvn8_n24_N9S19426C12D1Ev,_ZTvn4_n12_N9S19426C12D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C12D0Ev,_ZTvn4_n12_N9S19426C12D0Ev)();
extern void _ZN9S19426C183v65Ev();
extern void ABISELECT(_ZTv0_n24_N9S19426C12D1Ev,_ZTv0_n12_N9S19426C12D1Ev)();
extern void ABISELECT(_ZThn184_N9S19426C12D1Ev,_ZThn104_N9S19426C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C12D0Ev,_ZTv0_n12_N9S19426C12D0Ev)();
extern void ABISELECT(_ZThn184_N9S19426C12D0Ev,_ZThn104_N9S19426C12D0Ev)() __attribute__((weak));
extern void _ZN9S19426C163v56Ev();
extern void _ZN9S19426C163v57Ev();
extern void _ZN9S19426C163v58Ev();
extern void _ZN9S19426C163v59Ev();
extern void _ZN9S19426C163v60Ev();
extern void _ZN9S19426C163v61Ev();
static  VTBL_ENTRY vtc_S19426C12[] = {
  ABISELECT(160,88),
  ABISELECT(152,84),
  ABISELECT(184,104),
  ABISELECT(152,84),
  ABISELECT(112,60),
  ABISELECT(72,40),
  ABISELECT(112,60),
  ABISELECT(56,32),
  ABISELECT(136,76),
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&_ZN8S19426C73v17Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v18Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v19Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v20Ev,
  (VTBL_ENTRY)&_ZN9S19426C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19426C12D0Ev,
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N9S19426C12D1Ev,_ZThn16_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N9S19426C12D0Ev,_ZThn16_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19426C12D1Ev,_ZThn20_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19426C12D0Ev,_ZThn20_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-32),
  ABISELECT(80,44),
  ABISELECT(56,28),
  ABISELECT(16,8),
  ABISELECT(56,28),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19426C12D1Ev,_ZTv0_n28_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19426C12D0Ev,_ZTv0_n28_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v47Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v48Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v49Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v50Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v51Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v52Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v53Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v54Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v55Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C12D1Ev,_ZTv0_n12_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C12D0Ev,_ZTv0_n12_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C12D1Ev,_ZTvn4_n12_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C12D0Ev,_ZTvn4_n12_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,16),
  0,
  0,
  ABISELECT(-112,-60),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C12D1Ev,_ZTv0_n12_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C12D0Ev,_ZTv0_n12_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-136,-76),
  ABISELECT(-136,-76),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C12D1Ev,_ZTv0_n12_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C12D0Ev,_ZTv0_n12_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C12D1Ev,_ZTvn4_n12_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C12D0Ev,_ZTvn4_n12_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  0,
  ABISELECT(8,4),
  ABISELECT(32,20),
  0,
  ABISELECT(-40,-24),
  ABISELECT(-80,-44),
  ABISELECT(-40,-24),
  ABISELECT(-16,-8),
  0,
  ABISELECT(-152,-84),
  ABISELECT(-152,-84),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C12D1Ev,_ZTv0_n12_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C12D0Ev,_ZTv0_n12_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v62Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v63Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v64Ev,
  (VTBL_ENTRY)&_ZN9S19426C153v66Ev,
  (VTBL_ENTRY)&_ZN9S19426C153v67Ev,
  ABISELECT(-8,-4),
  0,
  ABISELECT(-88,-48),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-160,-88),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&_ZN9S19426C113v24Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v25Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v26Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v27Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v28Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v29Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v30Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v31Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C12D1Ev,_ZTvn4_n12_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C12D0Ev,_ZTvn4_n12_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19426C183v65Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-184,-104),
  ABISELECT(-184,-104),
  (VTBL_ENTRY)&(_ZTI9S19426C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C12D1Ev,_ZTv0_n12_N9S19426C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C12D0Ev,_ZTv0_n12_N9S19426C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19426C163v56Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v57Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v58Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v59Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v60Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v61Ev,
};
extern VTBL_ENTRY _ZTV9S19426C12[];
extern void _ZN8S19426C73v17Ev();
extern void _ZN8S19426C73v18Ev();
extern void _ZN8S19426C73v19Ev();
extern void _ZN8S19426C73v20Ev();
extern void _ZN8S19426C7D1Ev();
extern void _ZN8S19426C7D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C7__9S19426C12[] = {
  ABISELECT(136,76),
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C7[0]),
  (VTBL_ENTRY)&_ZN8S19426C73v17Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v18Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v19Ev,
  (VTBL_ENTRY)&_ZN8S19426C73v20Ev,
  (VTBL_ENTRY)&_ZN8S19426C7D1Ev,
  (VTBL_ENTRY)&_ZN8S19426C7D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C7D1Ev,_ZTv0_n12_N8S19426C7D1Ev)();
extern void ABISELECT(_ZThn136_N8S19426C7D1Ev,_ZThn76_N8S19426C7D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C7D0Ev,_ZTv0_n12_N8S19426C7D0Ev)();
extern void ABISELECT(_ZThn136_N8S19426C7D0Ev,_ZThn76_N8S19426C7D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__8S19426C7__9S19426C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-136,-76),
  ABISELECT(-136,-76),
  (VTBL_ENTRY)&(_ZTI8S19426C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C7D1Ev,_ZTv0_n12_N8S19426C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C7D0Ev,_ZTv0_n12_N8S19426C7D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N8S19426C7D1Ev,_ZTvn4_n12_N8S19426C7D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C7D0Ev,_ZTvn4_n12_N8S19426C7D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C7__9S19426C12[] = {
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI8S19426C7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C7D1Ev,_ZTvn4_n12_N8S19426C7D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C7D0Ev,_ZTvn4_n12_N8S19426C7D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void _ZN9S19426C13D1Ev();
extern void _ZN9S19426C13D0Ev();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN9S19426C133v47Ev();
extern void _ZN9S19426C133v48Ev();
extern void _ZN9S19426C133v49Ev();
extern void _ZN9S19426C133v50Ev();
extern void _ZN9S19426C133v51Ev();
extern void _ZN9S19426C133v52Ev();
extern void _ZN9S19426C133v53Ev();
extern void _ZN9S19426C133v54Ev();
extern void _ZN9S19426C133v55Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C13__9S19426C12[] = {
  ABISELECT(80,44),
  ABISELECT(56,28),
  ABISELECT(16,8),
  ABISELECT(56,28),
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&_ZN9S19426C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19426C13D0Ev,
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v47Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v48Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v49Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v50Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v51Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v52Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v53Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v54Ev,
  (VTBL_ENTRY)&_ZN9S19426C133v55Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev)();
extern void ABISELECT(_ZThn56_N9S19426C13D1Ev,_ZThn28_N9S19426C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev)();
extern void ABISELECT(_ZThn56_N9S19426C13D0Ev,_ZThn28_N9S19426C13D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__9S19426C13__9S19426C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,16),
  0,
  0,
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev)();
extern void ABISELECT(_ZThn16_N9S19426C13D1Ev,_ZThn8_N9S19426C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev)();
extern void ABISELECT(_ZThn16_N9S19426C13D0Ev,_ZThn8_N9S19426C13D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C14__9S19426C13__9S19426C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
};
extern void ABISELECT(_ZTvn8_n24_N9S19426C13D1Ev,_ZTvn4_n12_N9S19426C13D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C13D0Ev,_ZTvn4_n12_N9S19426C13D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C49S19426C14__A2__9S19426C13__9S19426C12[] = {
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C13D1Ev,_ZTvn4_n12_N9S19426C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C13D0Ev,_ZTvn4_n12_N9S19426C13D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev)();
extern void ABISELECT(_ZThn80_N9S19426C13D1Ev,_ZThn44_N9S19426C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev)();
extern void ABISELECT(_ZThn80_N9S19426C13D0Ev,_ZThn44_N9S19426C13D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__A1__9S19426C13__9S19426C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D1Ev,_ZTv0_n12_N9S19426C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C13D0Ev,_ZTv0_n12_N9S19426C13D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N9S19426C13D1Ev,_ZTvn4_n12_N9S19426C13D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C13D0Ev,_ZTvn4_n12_N9S19426C13D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A4__9S19426C13__9S19426C12[] = {
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI9S19426C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C13D1Ev,_ZTvn4_n12_N9S19426C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C13D0Ev,_ZTvn4_n12_N9S19426C13D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void _ZN8S19426C3D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void _ZN8S19426C3D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__9S19426C12[] = {
  0,
  ABISELECT(24,16),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZThn24_N8S19426C3D1Ev,_ZThn16_N8S19426C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev)();
extern void ABISELECT(_ZThn24_N8S19426C3D0Ev,_ZThn16_N8S19426C3D0Ev)() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__8S19426C3__9S19426C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D1Ev,_ZTv0_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19426C3D0Ev,_ZTv0_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__9S19426C12[] = {
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S19426C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D1Ev,_ZTvn4_n12_N8S19426C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N8S19426C3D0Ev,_ZTvn4_n12_N8S19426C3D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev)();
extern void _ZN9S19426C15D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev)();
extern void _ZN9S19426C15D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN9S19426C173v62Ev();
extern void _ZN9S19426C173v63Ev();
extern void _ZN9S19426C173v64Ev();
extern void _ZN9S19426C153v66Ev();
extern void _ZN9S19426C153v67Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C15__9S19426C12[] = {
  ABISELECT(8,4),
  ABISELECT(32,20),
  0,
  ABISELECT(-40,-24),
  ABISELECT(-80,-44),
  ABISELECT(-40,-24),
  ABISELECT(-16,-8),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v62Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v63Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v64Ev,
  (VTBL_ENTRY)&_ZN9S19426C153v66Ev,
  (VTBL_ENTRY)&_ZN9S19426C153v67Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void _ZN9S19426C17D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void _ZN9S19426C17D0Ev() __attribute__((weak));
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN9S19426C173v62Ev();
extern void _ZN9S19426C173v63Ev();
extern void _ZN9S19426C173v64Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C179S19426C15__9S19426C12[] = {
  0,
  ABISELECT(-40,-24),
  ABISELECT(-80,-44),
  ABISELECT(-40,-24),
  ABISELECT(-16,-8),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v62Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v63Ev,
  (VTBL_ENTRY)&_ZN9S19426C173v64Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__9S19426C179S19426C15__9S19426C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__9S19426C179S19426C15__9S19426C12[] = {
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__9S19426C179S19426C15__9S19426C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,16),
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C14__9S19426C179S19426C15__9S19426C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,44),
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D1Ev,_ZTv0_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C17D0Ev,_ZTv0_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
};
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C49S19426C14__A4__9S19426C179S19426C15__9S19426C12[] = {
  ABISELECT(72,40),
  (VTBL_ENTRY)&(_ZTI9S19426C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D1Ev,_ZTvn4_n12_N9S19426C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C17D0Ev,_ZTvn4_n12_N9S19426C17D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void _ZN9S19426C113v24Ev();
extern void _ZN9S19426C113v25Ev();
extern void _ZN9S19426C113v26Ev();
extern void _ZN9S19426C113v27Ev();
extern void _ZN9S19426C113v28Ev();
extern void _ZN9S19426C113v29Ev();
extern void _ZN9S19426C113v30Ev();
extern void _ZN9S19426C113v31Ev();
extern void _ZN9S19426C18D1Ev();
extern void _ZN9S19426C18D0Ev();
extern void _ZN9S19426C183v65Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C189S19426C15__9S19426C12[] = {
  ABISELECT(-8,-4),
  0,
  ABISELECT(-88,-48),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&_ZN9S19426C113v24Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v25Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v26Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v27Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v28Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v29Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v30Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v31Ev,
  (VTBL_ENTRY)&_ZN9S19426C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19426C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19426C183v65Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C14__9S19426C189S19426C15__9S19426C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(88,48),
  ABISELECT(88,48),
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
};
extern void ABISELECT(_ZTvn8_n24_N9S19426C18D1Ev,_ZTvn4_n12_N9S19426C18D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C18D0Ev,_ZTvn4_n12_N9S19426C18D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C49S19426C14__A1__9S19426C189S19426C15__9S19426C12[] = {
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C18D1Ev,_ZTvn4_n12_N9S19426C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C18D0Ev,_ZTvn4_n12_N9S19426C18D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt__A2__9S19426C189S19426C15__9S19426C12[] = {
  0,
  ABISELECT(8,4),
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI9S19426C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D1Ev,_ZTv0_n12_N9S19426C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C18D0Ev,_ZTv0_n12_N9S19426C18D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZThn32_N9S19426C15D1Ev,_ZThn20_N9S19426C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev)();
extern void ABISELECT(_ZThn32_N9S19426C15D0Ev,_ZThn20_N9S19426C15D0Ev)() __attribute__((weak));
extern void _ZN9S19426C163v56Ev();
extern void _ZN9S19426C163v57Ev();
extern void _ZN9S19426C163v58Ev();
extern void _ZN9S19426C163v59Ev();
extern void _ZN9S19426C163v60Ev();
extern void _ZN9S19426C163v61Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C16__9S19426C15__9S19426C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19426C163v56Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v57Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v58Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v59Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v60Ev,
  (VTBL_ENTRY)&_ZN9S19426C163v61Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C4__9S19426C15__9S19426C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(16,8),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
};
extern void ABISELECT(_ZTvn8_n24_N9S19426C15D1Ev,_ZTvn4_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C15D0Ev,_ZTvn4_n12_N9S19426C15D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C4__A1__9S19426C15__9S19426C12[] = {
  ABISELECT(8,4),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C15D1Ev,_ZTvn4_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C15D0Ev,_ZTvn4_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C33v11Ev();
extern void _ZN8S19426C33v12Ev();
extern void _ZN8S19426C33v13Ev();
extern void _ZN8S19426C33v14Ev();
extern void _ZN8S19426C33v15Ev();
extern void _ZN8S19426C33v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19426C3__9S19426C15__9S19426C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,16),
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v11Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v12Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v13Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v14Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v15Ev,
  (VTBL_ENTRY)&_ZN8S19426C33v16Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
extern void _ZN11S19426C5_nt2v8Ev();
extern void _ZN8S19426C42v9Ev();
extern void _ZN8S19426C43v10Ev();
extern void _ZN9S19426C143v42Ev();
extern void _ZN9S19426C143v43Ev();
extern void _ZN9S19426C143v44Ev();
extern void _ZN9S19426C143v45Ev();
extern void _ZN9S19426C143v46Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C14__9S19426C15__9S19426C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,44),
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D1Ev,_ZTv0_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19426C15D0Ev,_ZTv0_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN11S19426C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN8S19426C42v9Ev,
  (VTBL_ENTRY)&_ZN8S19426C43v10Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v42Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v43Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v44Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v45Ev,
  (VTBL_ENTRY)&_ZN9S19426C143v46Ev,
};
extern void ABISELECT(_ZTvn8_n24_N9S19426C15D1Ev,_ZTvn4_n12_N9S19426C15D1Ev)();
extern void ABISELECT(_ZTvn8_n24_N9S19426C15D0Ev,_ZTvn4_n12_N9S19426C15D0Ev)();
extern void _ZN11S19426C6_nt2v7Ev();
static  VTBL_ENTRY _tg__ZTV11S19426C6_nt8S19426C49S19426C14__A4__9S19426C15__9S19426C12[] = {
  ABISELECT(72,40),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C15D1Ev,_ZTvn4_n12_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n24_N9S19426C15D0Ev,_ZTvn4_n12_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN11S19426C6_nt2v7Ev,
};
extern void _ZN9S19426C113v24Ev();
extern void _ZN9S19426C113v25Ev();
extern void _ZN9S19426C113v26Ev();
extern void _ZN9S19426C113v27Ev();
extern void _ZN9S19426C113v28Ev();
extern void _ZN9S19426C113v29Ev();
extern void _ZN9S19426C113v30Ev();
extern void _ZN9S19426C113v31Ev();
extern void ABISELECT(_ZThn8_N9S19426C15D1Ev,_ZThn4_N9S19426C15D1Ev)();
extern void ABISELECT(_ZThn8_N9S19426C15D0Ev,_ZThn4_N9S19426C15D0Ev)();
extern void _ZN9S19426C183v65Ev();
static  VTBL_ENTRY _tg__ZTV9S19426C18__9S19426C15__9S19426C12[] = {
  ABISELECT(-8,-4),
  0,
  ABISELECT(-88,-48),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S19426C15[0]),
  (VTBL_ENTRY)&_ZN9S19426C113v24Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v25Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v26Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v27Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v28Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v29Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v30Ev,
  (VTBL_ENTRY)&_ZN9S19426C113v31Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S19426C15D1Ev,_ZThn4_N9S19426C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S19426C15D0Ev,_ZThn4_N9S19426C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19426C183v65Ev,
};
static  VTT_ENTRY vtt_S19426C12[] = {
  {&(_ZTV9S19426C12[11]),  11,194},
  {&(_tg__ZTV8S19426C7__9S19426C12[3]),  3,9},
  {&(_tg__ZTV8S19426C4__8S19426C7__9S19426C12[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C7__9S19426C12[2]),  2,5},
  {&(_ZTV9S19426C12[47]),  47,194},
  {&(_ZTV9S19426C12[100]),  100,194},
  {&(_ZTV9S19426C12[71]),  71,194},
  {&(_ZTV9S19426C12[84]),  84,194},
  {&(_ZTV9S19426C12[100]),  100,194},
  {&(_ZTV9S19426C12[117]),  117,194},
  {&(_ZTV9S19426C12[125]),  125,194},
  {&(_ZTV9S19426C12[145]),  145,194},
  {&(_ZTV9S19426C12[186]),  186,194},
  {&(_ZTV9S19426C12[145]),  145,194},
  {&(_ZTV9S19426C12[166]),  166,194},
  {&(_ZTV9S19426C12[166]),  166,194},
  {&(_tg__ZTV9S19426C13__9S19426C12[6]),  6,18},
  {&(_tg__ZTV8S19426C3__9S19426C13__9S19426C12[13]),  13,23},
  {&(_tg__ZTV9S19426C14__9S19426C13__9S19426C12[12]),  12,23},
  {&(_tg__ZTV11S19426C6_nt8S19426C49S19426C14__A2__9S19426C13__9S19426C12[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9S19426C13__9S19426C12[13]),  13,23},
  {&(_tg__ZTV8S19426C4__A1__9S19426C13__9S19426C12[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A4__9S19426C13__9S19426C12[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9S19426C12[7]),  7,17},
  {&(_tg__ZTV8S19426C4__8S19426C3__9S19426C12[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__8S19426C3__9S19426C12[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9S19426C12[7]),  7,17},
  {&(_tg__ZTV9S19426C15__9S19426C12[11]),  11,19},
  {&(_tg__ZTV9S19426C179S19426C15__9S19426C12[9]),  9,15},
  {&(_tg__ZTV8S19426C4__9S19426C179S19426C15__9S19426C12[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__9S19426C179S19426C15__9S19426C12[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9S19426C179S19426C15__9S19426C12[13]),  13,23},
  {&(_tg__ZTV9S19426C14__9S19426C179S19426C15__9S19426C12[12]),  12,23},
  {&(_tg__ZTV11S19426C6_nt8S19426C49S19426C14__A4__9S19426C179S19426C15__9S19426C12[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9S19426C179S19426C15__9S19426C12[13]),  13,23},
  {&(_tg__ZTV9S19426C179S19426C15__9S19426C12[9]),  9,15},
  {&(_tg__ZTV9S19426C189S19426C15__9S19426C12[13]),  13,24},
  {&(_tg__ZTV9S19426C14__9S19426C189S19426C15__9S19426C12[12]),  12,23},
  {&(_tg__ZTV11S19426C6_nt8S19426C49S19426C14__A1__9S19426C189S19426C15__9S19426C12[2]),  2,5},
  {&(_tg__ZTV9S19426C189S19426C15__9S19426C12[13]),  13,24},
  {&(_tg__ZTV11S19426C6_nt__A2__9S19426C189S19426C15__9S19426C12[4]),  4,7},
  {&(_tg__ZTV9S19426C16__9S19426C15__9S19426C12[9]),  9,17},
  {&(_tg__ZTV8S19426C4__9S19426C15__9S19426C12[7]),  7,13},
  {&(_tg__ZTV11S19426C6_nt8S19426C4__A1__9S19426C15__9S19426C12[2]),  2,5},
  {&(_tg__ZTV8S19426C3__9