// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S21925C3_nt  {
  long s21925c3f0[4];
};
//SIG(-1 S21925C3_nt) C1{ Fl[4]}



//skip512 S21925C3_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C2_nt  {
  ::S21925C3_nt s21925c2f0;
  void  mf21925c2(); // _ZN11S21925C2_nt9mf21925c2Ev
};
//SIG(-1 S21925C2_nt) C1{ m FC2{ Fl[4]}}


void  S21925C2_nt ::mf21925c2(){}

//skip512 S21925C2_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C5_nt  {
  int s21925c5f0[4];
};
//SIG(-1 S21925C5_nt) C1{ Fi[4]}



//skip512 S21925C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C4_nt  {
  void *s21925c4f0;
  ::S21925C5_nt s21925c4f1;
  void  mf21925c4(); // _ZN11S21925C4_nt9mf21925c4Ev
};
//SIG(-1 S21925C4_nt) C1{ m Fp FC2{ Fi[4]}}


void  S21925C4_nt ::mf21925c4(){}

//skip512 S21925C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C6  {
  void *s21925c6f0[2];
  int s21925c6f1;
  void  mf21925c6(); // _ZN8S21925C69mf21925c6Ev
  virtual  ~S21925C6(); // _ZN8S21925C6D1Ev
  S21925C6(); // tgen
};
//SIG(-1 S21925C6) C1{ vd m Fp[2] Fi}


void  S21925C6 ::mf21925c6(){}
 S21925C6 ::~S21925C6(){ note_dtor("S21925C6", this);}
S21925C6 ::S21925C6(){ note_ctor("S21925C6", this);} // tgen

static void Test_S21925C6()
{
  extern Class_Descriptor cd_S21925C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S21925C6, buf);
    S21925C6 *dp, &lv = *(dp=new (buf) S21925C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S21925C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C6)");
    check_field_offset(lv, s21925c6f0, ABISELECT(8,4), "S21925C6.s21925c6f0");
    check_field_offset(lv, s21925c6f1, ABISELECT(24,12), "S21925C6.s21925c6f1");
    test_class_info(&lv, &cd_S21925C6);
    dp->~S21925C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C6(Test_S21925C6, "S21925C6", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN8S21925C6C1Ev();
extern void _ZN8S21925C6D1Ev();
Name_Map name_map_S21925C6[] = {
  NSPAIR(_ZN8S21925C6C1Ev),
  NSPAIR(_ZN8S21925C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S21925C6[];
extern void _ZN8S21925C6D1Ev();
extern void _ZN8S21925C6D0Ev();
static  VTBL_ENTRY vtc_S21925C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21925C6[0]),
  (VTBL_ENTRY)&_ZN8S21925C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21925C6D0Ev,
};
extern VTBL_ENTRY _ZTI8S21925C6[];
extern  VTBL_ENTRY _ZTV8S21925C6[];
Class_Descriptor cd_S21925C6 = {  "S21925C6", // class name
  0,0,//no base classes
  &(vtc_S21925C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI8S21925C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S21925C6),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C8  {
  virtual void  v33(); // _ZN8S21925C83v33Ev
  virtual void  v34(); // _ZN8S21925C83v34Ev
  virtual void  v35(); // _ZN8S21925C83v35Ev
  virtual void  v36(); // _ZN8S21925C83v36Ev
  virtual void  v37(); // _ZN8S21925C83v37Ev
  virtual void  v38(); // _ZN8S21925C83v38Ev
  virtual void  v39(); // _ZN8S21925C83v39Ev
  ~S21925C8(); // tgen
  S21925C8(); // tgen
};
//SIG(-1 S21925C8) C1{ v1 v2 v3 v4 v5 v6 v7}


void  S21925C8 ::v33(){vfunc_called(this, "_ZN8S21925C83v33Ev");}
void  S21925C8 ::v34(){vfunc_called(this, "_ZN8S21925C83v34Ev");}
void  S21925C8 ::v35(){vfunc_called(this, "_ZN8S21925C83v35Ev");}
void  S21925C8 ::v36(){vfunc_called(this, "_ZN8S21925C83v36Ev");}
void  S21925C8 ::v37(){vfunc_called(this, "_ZN8S21925C83v37Ev");}
void  S21925C8 ::v38(){vfunc_called(this, "_ZN8S21925C83v38Ev");}
void  S21925C8 ::v39(){vfunc_called(this, "_ZN8S21925C83v39Ev");}
S21925C8 ::~S21925C8(){ note_dtor("S21925C8", this);} // tgen
S21925C8 ::S21925C8(){ note_ctor("S21925C8", this);} // tgen

static void Test_S21925C8()
{
  extern Class_Descriptor cd_S21925C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S21925C8, buf);
    S21925C8 *dp, &lv = *(dp=new (buf) S21925C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S21925C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C8)");
    test_class_info(&lv, &cd_S21925C8);
    dp->~S21925C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C8(Test_S21925C8, "S21925C8", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S21925C8C1Ev();
extern void _ZN8S21925C8D1Ev();
Name_Map name_map_S21925C8[] = {
  NSPAIR(_ZN8S21925C8C1Ev),
  NSPAIR(_ZN8S21925C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S21925C8[];
extern void _ZN8S21925C83v33Ev();
extern void _ZN8S21925C83v34Ev();
extern void _ZN8S21925C83v35Ev();
extern void _ZN8S21925C83v36Ev();
extern void _ZN8S21925C83v37Ev();
extern void _ZN8S21925C83v38Ev();
extern void _ZN8S21925C83v39Ev();
static  VTBL_ENTRY vtc_S21925C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21925C8[0]),
  (VTBL_ENTRY)&_ZN8S21925C83v33Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v34Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v35Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v36Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v37Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v38Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v39Ev,
};
extern VTBL_ENTRY _ZTI8S21925C8[];
extern  VTBL_ENTRY _ZTV8S21925C8[];
Class_Descriptor cd_S21925C8 = {  "S21925C8", // class name
  0,0,//no base classes
  &(vtc_S21925C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S21925C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S21925C8),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C9  {
  void *s21925c9f0[3];
  void  mf21925c9(); // _ZN8S21925C99mf21925c9Ev
};
//SIG(-1 S21925C9) C1{ m Fp[3]}


void  S21925C9 ::mf21925c9(){}

static void Test_S21925C9()
{
  {
    init_simple_test("S21925C9");
    S21925C9 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21925C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C9)");
    check_field_offset(lv, s21925c9f0, 0, "S21925C9.s21925c9f0");
  }
}
static Arrange_To_Call_Me vS21925C9(Test_S21925C9, "S21925C9", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C12  {
  void *s21925c12f0;
  int s21925c12f1;
  virtual  ~S21925C12(); // _ZN9S21925C12D1Ev
  virtual void  v51(); // _ZN9S21925C123v51Ev
  virtual void  v52(); // _ZN9S21925C123v52Ev
  virtual void  v53(); // _ZN9S21925C123v53Ev
  virtual void  v54(); // _ZN9S21925C123v54Ev
  virtual void  v55(); // _ZN9S21925C123v55Ev
  virtual void  v56(); // _ZN9S21925C123v56Ev
  virtual void  v57(); // _ZN9S21925C123v57Ev
  virtual void  v58(); // _ZN9S21925C123v58Ev
  virtual void  v59(); // _ZN9S21925C123v59Ev
  virtual void  v60(); // _ZN9S21925C123v60Ev
  virtual void  v61(); // _ZN9S21925C123v61Ev
  virtual void  v62(); // _ZN9S21925C123v62Ev
  virtual void  v63(); // _ZN9S21925C123v63Ev
  virtual void  v64(); // _ZN9S21925C123v64Ev
  virtual void  v65(); // _ZN9S21925C123v65Ev
  virtual void  v66(); // _ZN9S21925C123v66Ev
  virtual void  v67(); // _ZN9S21925C123v67Ev
  virtual void  v68(); // _ZN9S21925C123v68Ev
  virtual void  v69(); // _ZN9S21925C123v69Ev
  virtual void  v70(); // _ZN9S21925C123v70Ev
  virtual void  v71(); // _ZN9S21925C123v71Ev
  virtual void  v72(); // _ZN9S21925C123v72Ev
  virtual void  v73(); // _ZN9S21925C123v73Ev
  virtual void  v74(); // _ZN9S21925C123v74Ev
  virtual void  v75(); // _ZN9S21925C123v75Ev
  virtual void  v76(); // _ZN9S21925C123v76Ev
  virtual void  v77(); // _ZN9S21925C123v77Ev
  S21925C12(); // tgen
};
//SIG(-1 S21925C12) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp Fi}


 S21925C12 ::~S21925C12(){ note_dtor("S21925C12", this);}
void  S21925C12 ::v51(){vfunc_called(this, "_ZN9S21925C123v51Ev");}
void  S21925C12 ::v52(){vfunc_called(this, "_ZN9S21925C123v52Ev");}
void  S21925C12 ::v53(){vfunc_called(this, "_ZN9S21925C123v53Ev");}
void  S21925C12 ::v54(){vfunc_called(this, "_ZN9S21925C123v54Ev");}
void  S21925C12 ::v55(){vfunc_called(this, "_ZN9S21925C123v55Ev");}
void  S21925C12 ::v56(){vfunc_called(this, "_ZN9S21925C123v56Ev");}
void  S21925C12 ::v57(){vfunc_called(this, "_ZN9S21925C123v57Ev");}
void  S21925C12 ::v58(){vfunc_called(this, "_ZN9S21925C123v58Ev");}
void  S21925C12 ::v59(){vfunc_called(this, "_ZN9S21925C123v59Ev");}
void  S21925C12 ::v60(){vfunc_called(this, "_ZN9S21925C123v60Ev");}
void  S21925C12 ::v61(){vfunc_called(this, "_ZN9S21925C123v61Ev");}
void  S21925C12 ::v62(){vfunc_called(this, "_ZN9S21925C123v62Ev");}
void  S21925C12 ::v63(){vfunc_called(this, "_ZN9S21925C123v63Ev");}
void  S21925C12 ::v64(){vfunc_called(this, "_ZN9S21925C123v64Ev");}
void  S21925C12 ::v65(){vfunc_called(this, "_ZN9S21925C123v65Ev");}
void  S21925C12 ::v66(){vfunc_called(this, "_ZN9S21925C123v66Ev");}
void  S21925C12 ::v67(){vfunc_called(this, "_ZN9S21925C123v67Ev");}
void  S21925C12 ::v68(){vfunc_called(this, "_ZN9S21925C123v68Ev");}
void  S21925C12 ::v69(){vfunc_called(this, "_ZN9S21925C123v69Ev");}
void  S21925C12 ::v70(){vfunc_called(this, "_ZN9S21925C123v70Ev");}
void  S21925C12 ::v71(){vfunc_called(this, "_ZN9S21925C123v71Ev");}
void  S21925C12 ::v72(){vfunc_called(this, "_ZN9S21925C123v72Ev");}
void  S21925C12 ::v73(){vfunc_called(this, "_ZN9S21925C123v73Ev");}
void  S21925C12 ::v74(){vfunc_called(this, "_ZN9S21925C123v74Ev");}
void  S21925C12 ::v75(){vfunc_called(this, "_ZN9S21925C123v75Ev");}
void  S21925C12 ::v76(){vfunc_called(this, "_ZN9S21925C123v76Ev");}
void  S21925C12 ::v77(){vfunc_called(this, "_ZN9S21925C123v77Ev");}
S21925C12 ::S21925C12(){ note_ctor("S21925C12", this);} // tgen

static void Test_S21925C12()
{
  extern Class_Descriptor cd_S21925C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S21925C12, buf);
    S21925C12 *dp, &lv = *(dp=new (buf) S21925C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21925C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C12)");
    check_field_offset(lv, s21925c12f0, ABISELECT(8,4), "S21925C12.s21925c12f0");
    check_field_offset(lv, s21925c12f1, ABISELECT(16,8), "S21925C12.s21925c12f1");
    test_class_info(&lv, &cd_S21925C12);
    dp->~S21925C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C12(Test_S21925C12, "S21925C12", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S21925C12C1Ev();
extern void _ZN9S21925C12D1Ev();
Name_Map name_map_S21925C12[] = {
  NSPAIR(_ZN9S21925C12C1Ev),
  NSPAIR(_ZN9S21925C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21925C12[];
extern void _ZN9S21925C12D1Ev();
extern void _ZN9S21925C12D0Ev();
extern void _ZN9S21925C123v51Ev();
extern void _ZN9S21925C123v52Ev();
extern void _ZN9S21925C123v53Ev();
extern void _ZN9S21925C123v54Ev();
extern void _ZN9S21925C123v55Ev();
extern void _ZN9S21925C123v56Ev();
extern void _ZN9S21925C123v57Ev();
extern void _ZN9S21925C123v58Ev();
extern void _ZN9S21925C123v59Ev();
extern void _ZN9S21925C123v60Ev();
extern void _ZN9S21925C123v61Ev();
extern void _ZN9S21925C123v62Ev();
extern void _ZN9S21925C123v63Ev();
extern void _ZN9S21925C123v64Ev();
extern void _ZN9S21925C123v65Ev();
extern void _ZN9S21925C123v66Ev();
extern void _ZN9S21925C123v67Ev();
extern void _ZN9S21925C123v68Ev();
extern void _ZN9S21925C123v69Ev();
extern void _ZN9S21925C123v70Ev();
extern void _ZN9S21925C123v71Ev();
extern void _ZN9S21925C123v72Ev();
extern void _ZN9S21925C123v73Ev();
extern void _ZN9S21925C123v74Ev();
extern void _ZN9S21925C123v75Ev();
extern void _ZN9S21925C123v76Ev();
extern void _ZN9S21925C123v77Ev();
static  VTBL_ENTRY vtc_S21925C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C12[0]),
  (VTBL_ENTRY)&_ZN9S21925C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C12D0Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v51Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v52Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v53Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v54Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v55Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v56Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v57Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v58Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v59Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v60Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v61Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v62Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v63Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v64Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v65Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v66Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v67Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v68Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v69Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v70Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v71Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v72Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v73Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v74Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v75Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v76Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v77Ev,
};
extern VTBL_ENTRY _ZTI9S21925C12[];
extern  VTBL_ENTRY _ZTV9S21925C12[];
Class_Descriptor cd_S21925C12 = {  "S21925C12", // class name
  0,0,//no base classes
  &(vtc_S21925C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S21925C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21925C12),31, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C11  : S21925C12 {
  virtual  ~S21925C11(); // _ZN9S21925C11D1Ev
  virtual void  v47(); // _ZN9S21925C113v47Ev
  virtual void  v48(); // _ZN9S21925C113v48Ev
  virtual void  v49(); // _ZN9S21925C113v49Ev
  virtual void  v50(); // _ZN9S21925C113v50Ev
  S21925C11(); // tgen
};
//SIG(-1 S21925C11) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 Fp Fi} vd v1 v2 v3 v4}


 S21925C11 ::~S21925C11(){ note_dtor("S21925C11", this);}
void  S21925C11 ::v47(){vfunc_called(this, "_ZN9S21925C113v47Ev");}
void  S21925C11 ::v48(){vfunc_called(this, "_ZN9S21925C113v48Ev");}
void  S21925C11 ::v49(){vfunc_called(this, "_ZN9S21925C113v49Ev");}
void  S21925C11 ::v50(){vfunc_called(this, "_ZN9S21925C113v50Ev");}
S21925C11 ::S21925C11(){ note_ctor("S21925C11", this);} // tgen

static void Test_S21925C11()
{
  extern Class_Descriptor cd_S21925C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S21925C11, buf);
    S21925C11 *dp, &lv = *(dp=new (buf) S21925C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21925C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C11)");
    check_base_class_offset(lv, (S21925C12*), 0, "S21925C11");
    test_class_info(&lv, &cd_S21925C11);
    dp->~S21925C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C11(Test_S21925C11, "S21925C11", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S21925C11C1Ev();
extern void _ZN9S21925C11D1Ev();
Name_Map name_map_S21925C11[] = {
  NSPAIR(_ZN9S21925C11C1Ev),
  NSPAIR(_ZN9S21925C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21925C12;
extern VTBL_ENTRY _ZTI9S21925C12[];
extern  VTBL_ENTRY _ZTV9S21925C12[];
static Base_Class bases_S21925C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21925C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21925C11[];
extern void _ZN9S21925C11D1Ev();
extern void _ZN9S21925C11D0Ev();
extern void _ZN9S21925C123v51Ev();
extern void _ZN9S21925C123v52Ev();
extern void _ZN9S21925C123v53Ev();
extern void _ZN9S21925C123v54Ev();
extern void _ZN9S21925C123v55Ev();
extern void _ZN9S21925C123v56Ev();
extern void _ZN9S21925C123v57Ev();
extern void _ZN9S21925C123v58Ev();
extern void _ZN9S21925C123v59Ev();
extern void _ZN9S21925C123v60Ev();
extern void _ZN9S21925C123v61Ev();
extern void _ZN9S21925C123v62Ev();
extern void _ZN9S21925C123v63Ev();
extern void _ZN9S21925C123v64Ev();
extern void _ZN9S21925C123v65Ev();
extern void _ZN9S21925C123v66Ev();
extern void _ZN9S21925C123v67Ev();
extern void _ZN9S21925C123v68Ev();
extern void _ZN9S21925C123v69Ev();
extern void _ZN9S21925C123v70Ev();
extern void _ZN9S21925C123v71Ev();
extern void _ZN9S21925C123v72Ev();
extern void _ZN9S21925C123v73Ev();
extern void _ZN9S21925C123v74Ev();
extern void _ZN9S21925C123v75Ev();
extern void _ZN9S21925C123v76Ev();
extern void _ZN9S21925C123v77Ev();
extern void _ZN9S21925C113v47Ev();
extern void _ZN9S21925C113v48Ev();
extern void _ZN9S21925C113v49Ev();
extern void _ZN9S21925C113v50Ev();
static  VTBL_ENTRY vtc_S21925C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C11[0]),
  (VTBL_ENTRY)&_ZN9S21925C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C11D0Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v51Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v52Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v53Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v54Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v55Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v56Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v57Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v58Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v59Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v60Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v61Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v62Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v63Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v64Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v65Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v66Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v67Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v68Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v69Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v70Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v71Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v72Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v73Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v74Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v75Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v76Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v77Ev,
  (VTBL_ENTRY)&_ZN9S21925C113v47Ev,
  (VTBL_ENTRY)&_ZN9S21925C113v48Ev,
  (VTBL_ENTRY)&_ZN9S21925C113v49Ev,
  (VTBL_ENTRY)&_ZN9S21925C113v50Ev,
};
extern VTBL_ENTRY _ZTI9S21925C11[];
extern  VTBL_ENTRY _ZTV9S21925C11[];
Class_Descriptor cd_S21925C11 = {  "S21925C11", // class name
  bases_S21925C11, 1,
  &(vtc_S21925C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S21925C11),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S21925C11),35, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C13  : S21925C12 {
  virtual  ~S21925C13(); // _ZN9S21925C13D1Ev
  virtual void  v78(); // _ZN9S21925C133v78Ev
  virtual void  v79(); // _ZN9S21925C133v79Ev
  virtual void  v80(); // _ZN9S21925C133v80Ev
  virtual void  v81(); // _ZN9S21925C133v81Ev
  virtual void  v82(); // _ZN9S21925C133v82Ev
  virtual void  v83(); // _ZN9S21925C133v83Ev
  virtual void  v84(); // _ZN9S21925C133v84Ev
  virtual void  v85(); // _ZN9S21925C133v85Ev
  virtual void  v86(); // _ZN9S21925C133v86Ev
  virtual void  v87(); // _ZN9S21925C133v87Ev
  virtual void  v88(); // _ZN9S21925C133v88Ev
  virtual void  v89(); // _ZN9S21925C133v89Ev
  virtual void  v90(); // _ZN9S21925C133v90Ev
  virtual void  v91(); // _ZN9S21925C133v91Ev
  virtual void  v92(); // _ZN9S21925C133v92Ev
  virtual void  v93(); // _ZN9S21925C133v93Ev
  virtual void  v94(); // _ZN9S21925C133v94Ev
  S21925C13(); // tgen
};
//SIG(-1 S21925C13) C1{ BC2{ vd v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17}


 S21925C13 ::~S21925C13(){ note_dtor("S21925C13", this);}
void  S21925C13 ::v78(){vfunc_called(this, "_ZN9S21925C133v78Ev");}
void  S21925C13 ::v79(){vfunc_called(this, "_ZN9S21925C133v79Ev");}
void  S21925C13 ::v80(){vfunc_called(this, "_ZN9S21925C133v80Ev");}
void  S21925C13 ::v81(){vfunc_called(this, "_ZN9S21925C133v81Ev");}
void  S21925C13 ::v82(){vfunc_called(this, "_ZN9S21925C133v82Ev");}
void  S21925C13 ::v83(){vfunc_called(this, "_ZN9S21925C133v83Ev");}
void  S21925C13 ::v84(){vfunc_called(this, "_ZN9S21925C133v84Ev");}
void  S21925C13 ::v85(){vfunc_called(this, "_ZN9S21925C133v85Ev");}
void  S21925C13 ::v86(){vfunc_called(this, "_ZN9S21925C133v86Ev");}
void  S21925C13 ::v87(){vfunc_called(this, "_ZN9S21925C133v87Ev");}
void  S21925C13 ::v88(){vfunc_called(this, "_ZN9S21925C133v88Ev");}
void  S21925C13 ::v89(){vfunc_called(this, "_ZN9S21925C133v89Ev");}
void  S21925C13 ::v90(){vfunc_called(this, "_ZN9S21925C133v90Ev");}
void  S21925C13 ::v91(){vfunc_called(this, "_ZN9S21925C133v91Ev");}
void  S21925C13 ::v92(){vfunc_called(this, "_ZN9S21925C133v92Ev");}
void  S21925C13 ::v93(){vfunc_called(this, "_ZN9S21925C133v93Ev");}
void  S21925C13 ::v94(){vfunc_called(this, "_ZN9S21925C133v94Ev");}
S21925C13 ::S21925C13(){ note_ctor("S21925C13", this);} // tgen

static void Test_S21925C13()
{
  extern Class_Descriptor cd_S21925C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S21925C13, buf);
    S21925C13 *dp, &lv = *(dp=new (buf) S21925C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21925C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C13)");
    check_base_class_offset(lv, (S21925C12*), 0, "S21925C13");
    test_class_info(&lv, &cd_S21925C13);
    dp->~S21925C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C13(Test_S21925C13, "S21925C13", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S21925C13C1Ev();
extern void _ZN9S21925C13D1Ev();
Name_Map name_map_S21925C13[] = {
  NSPAIR(_ZN9S21925C13C1Ev),
  NSPAIR(_ZN9S21925C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21925C12;
extern VTBL_ENTRY _ZTI9S21925C12[];
extern  VTBL_ENTRY _ZTV9S21925C12[];
static Base_Class bases_S21925C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21925C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21925C13[];
extern void _ZN9S21925C13D1Ev();
extern void _ZN9S21925C13D0Ev();
extern void _ZN9S21925C123v51Ev();
extern void _ZN9S21925C123v52Ev();
extern void _ZN9S21925C123v53Ev();
extern void _ZN9S21925C123v54Ev();
extern void _ZN9S21925C123v55Ev();
extern void _ZN9S21925C123v56Ev();
extern void _ZN9S21925C123v57Ev();
extern void _ZN9S21925C123v58Ev();
extern void _ZN9S21925C123v59Ev();
extern void _ZN9S21925C123v60Ev();
extern void _ZN9S21925C123v61Ev();
extern void _ZN9S21925C123v62Ev();
extern void _ZN9S21925C123v63Ev();
extern void _ZN9S21925C123v64Ev();
extern void _ZN9S21925C123v65Ev();
extern void _ZN9S21925C123v66Ev();
extern void _ZN9S21925C123v67Ev();
extern void _ZN9S21925C123v68Ev();
extern void _ZN9S21925C123v69Ev();
extern void _ZN9S21925C123v70Ev();
extern void _ZN9S21925C123v71Ev();
extern void _ZN9S21925C123v72Ev();
extern void _ZN9S21925C123v73Ev();
extern void _ZN9S21925C123v74Ev();
extern void _ZN9S21925C123v75Ev();
extern void _ZN9S21925C123v76Ev();
extern void _ZN9S21925C123v77Ev();
extern void _ZN9S21925C133v78Ev();
extern void _ZN9S21925C133v79Ev();
extern void _ZN9S21925C133v80Ev();
extern void _ZN9S21925C133v81Ev();
extern void _ZN9S21925C133v82Ev();
extern void _ZN9S21925C133v83Ev();
extern void _ZN9S21925C133v84Ev();
extern void _ZN9S21925C133v85Ev();
extern void _ZN9S21925C133v86Ev();
extern void _ZN9S21925C133v87Ev();
extern void _ZN9S21925C133v88Ev();
extern void _ZN9S21925C133v89Ev();
extern void _ZN9S21925C133v90Ev();
extern void _ZN9S21925C133v91Ev();
extern void _ZN9S21925C133v92Ev();
extern void _ZN9S21925C133v93Ev();
extern void _ZN9S21925C133v94Ev();
static  VTBL_ENTRY vtc_S21925C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C13[0]),
  (VTBL_ENTRY)&_ZN9S21925C13D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C13D0Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v51Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v52Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v53Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v54Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v55Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v56Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v57Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v58Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v59Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v60Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v61Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v62Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v63Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v64Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v65Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v66Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v67Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v68Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v69Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v70Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v71Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v72Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v73Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v74Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v75Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v76Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v77Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v78Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v79Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v80Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v81Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v82Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v83Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v84Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v85Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v86Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v87Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v88Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v89Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v90Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v91Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v92Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v93Ev,
  (VTBL_ENTRY)&_ZN9S21925C133v94Ev,
};
extern VTBL_ENTRY _ZTI9S21925C13[];
extern  VTBL_ENTRY _ZTV9S21925C13[];
Class_Descriptor cd_S21925C13 = {  "S21925C13", // class name
  bases_S21925C13, 1,
  &(vtc_S21925C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S21925C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S21925C13),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C14  : S21925C12 {
  virtual  ~S21925C14(); // _ZN9S21925C14D1Ev
  virtual void  v95(); // _ZN9S21925C143v95Ev
  virtual void  v96(); // _ZN9S21925C143v96Ev
  virtual void  v97(); // _ZN9S21925C143v97Ev
  virtual void  v98(); // _ZN9S21925C143v98Ev
  virtual void  v99(); // _ZN9S21925C143v99Ev
  virtual void  v100(); // _ZN9S21925C144v100Ev
  virtual void  v101(); // _ZN9S21925C144v101Ev
  virtual void  v102(); // _ZN9S21925C144v102Ev
  virtual void  v103(); // _ZN9S21925C144v103Ev
  virtual void  v104(); // _ZN9S21925C144v104Ev
  virtual void  v105(); // _ZN9S21925C144v105Ev
  virtual void  v106(); // _ZN9S21925C144v106Ev
  virtual void  v107(); // _ZN9S21925C144v107Ev
  virtual void  v108(); // _ZN9S21925C144v108Ev
  virtual void  v109(); // _ZN9S21925C144v109Ev
  virtual void  v110(); // _ZN9S21925C144v110Ev
  virtual void  v111(); // _ZN9S21925C144v111Ev
  virtual void  v112(); // _ZN9S21925C144v112Ev
  S21925C14(); // tgen
};
//SIG(-1 S21925C14) C1{ BC2{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 Fp Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18}


 S21925C14 ::~S21925C14(){ note_dtor("S21925C14", this);}
void  S21925C14 ::v95(){vfunc_called(this, "_ZN9S21925C143v95Ev");}
void  S21925C14 ::v96(){vfunc_called(this, "_ZN9S21925C143v96Ev");}
void  S21925C14 ::v97(){vfunc_called(this, "_ZN9S21925C143v97Ev");}
void  S21925C14 ::v98(){vfunc_called(this, "_ZN9S21925C143v98Ev");}
void  S21925C14 ::v99(){vfunc_called(this, "_ZN9S21925C143v99Ev");}
void  S21925C14 ::v100(){vfunc_called(this, "_ZN9S21925C144v100Ev");}
void  S21925C14 ::v101(){vfunc_called(this, "_ZN9S21925C144v101Ev");}
void  S21925C14 ::v102(){vfunc_called(this, "_ZN9S21925C144v102Ev");}
void  S21925C14 ::v103(){vfunc_called(this, "_ZN9S21925C144v103Ev");}
void  S21925C14 ::v104(){vfunc_called(this, "_ZN9S21925C144v104Ev");}
void  S21925C14 ::v105(){vfunc_called(this, "_ZN9S21925C144v105Ev");}
void  S21925C14 ::v106(){vfunc_called(this, "_ZN9S21925C144v106Ev");}
void  S21925C14 ::v107(){vfunc_called(this, "_ZN9S21925C144v107Ev");}
void  S21925C14 ::v108(){vfunc_called(this, "_ZN9S21925C144v108Ev");}
void  S21925C14 ::v109(){vfunc_called(this, "_ZN9S21925C144v109Ev");}
void  S21925C14 ::v110(){vfunc_called(this, "_ZN9S21925C144v110Ev");}
void  S21925C14 ::v111(){vfunc_called(this, "_ZN9S21925C144v111Ev");}
void  S21925C14 ::v112(){vfunc_called(this, "_ZN9S21925C144v112Ev");}
S21925C14 ::S21925C14(){ note_ctor("S21925C14", this);} // tgen

static void Test_S21925C14()
{
  extern Class_Descriptor cd_S21925C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S21925C14, buf);
    S21925C14 *dp, &lv = *(dp=new (buf) S21925C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21925C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C14)");
    check_base_class_offset(lv, (S21925C12*), 0, "S21925C14");
    test_class_info(&lv, &cd_S21925C14);
    dp->~S21925C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C14(Test_S21925C14, "S21925C14", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S21925C14C1Ev();
extern void _ZN9S21925C14D1Ev();
Name_Map name_map_S21925C14[] = {
  NSPAIR(_ZN9S21925C14C1Ev),
  NSPAIR(_ZN9S21925C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21925C12;
extern VTBL_ENTRY _ZTI9S21925C12[];
extern  VTBL_ENTRY _ZTV9S21925C12[];
static Base_Class bases_S21925C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21925C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21925C14[];
extern void _ZN9S21925C14D1Ev();
extern void _ZN9S21925C14D0Ev();
extern void _ZN9S21925C123v51Ev();
extern void _ZN9S21925C123v52Ev();
extern void _ZN9S21925C123v53Ev();
extern void _ZN9S21925C123v54Ev();
extern void _ZN9S21925C123v55Ev();
extern void _ZN9S21925C123v56Ev();
extern void _ZN9S21925C123v57Ev();
extern void _ZN9S21925C123v58Ev();
extern void _ZN9S21925C123v59Ev();
extern void _ZN9S21925C123v60Ev();
extern void _ZN9S21925C123v61Ev();
extern void _ZN9S21925C123v62Ev();
extern void _ZN9S21925C123v63Ev();
extern void _ZN9S21925C123v64Ev();
extern void _ZN9S21925C123v65Ev();
extern void _ZN9S21925C123v66Ev();
extern void _ZN9S21925C123v67Ev();
extern void _ZN9S21925C123v68Ev();
extern void _ZN9S21925C123v69Ev();
extern void _ZN9S21925C123v70Ev();
extern void _ZN9S21925C123v71Ev();
extern void _ZN9S21925C123v72Ev();
extern void _ZN9S21925C123v73Ev();
extern void _ZN9S21925C123v74Ev();
extern void _ZN9S21925C123v75Ev();
extern void _ZN9S21925C123v76Ev();
extern void _ZN9S21925C123v77Ev();
extern void _ZN9S21925C143v95Ev();
extern void _ZN9S21925C143v96Ev();
extern void _ZN9S21925C143v97Ev();
extern void _ZN9S21925C143v98Ev();
extern void _ZN9S21925C143v99Ev();
extern void _ZN9S21925C144v100Ev();
extern void _ZN9S21925C144v101Ev();
extern void _ZN9S21925C144v102Ev();
extern void _ZN9S21925C144v103Ev();
extern void _ZN9S21925C144v104Ev();
extern void _ZN9S21925C144v105Ev();
extern void _ZN9S21925C144v106Ev();
extern void _ZN9S21925C144v107Ev();
extern void _ZN9S21925C144v108Ev();
extern void _ZN9S21925C144v109Ev();
extern void _ZN9S21925C144v110Ev();
extern void _ZN9S21925C144v111Ev();
extern void _ZN9S21925C144v112Ev();
static  VTBL_ENTRY vtc_S21925C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C14[0]),
  (VTBL_ENTRY)&_ZN9S21925C14D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C14D0Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v51Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v52Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v53Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v54Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v55Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v56Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v57Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v58Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v59Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v60Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v61Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v62Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v63Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v64Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v65Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v66Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v67Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v68Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v69Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v70Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v71Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v72Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v73Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v74Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v75Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v76Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v77Ev,
  (VTBL_ENTRY)&_ZN9S21925C143v95Ev,
  (VTBL_ENTRY)&_ZN9S21925C143v96Ev,
  (VTBL_ENTRY)&_ZN9S21925C143v97Ev,
  (VTBL_ENTRY)&_ZN9S21925C143v98Ev,
  (VTBL_ENTRY)&_ZN9S21925C143v99Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v100Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v101Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v102Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v103Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v104Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v105Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v106Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v107Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v108Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v109Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v110Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v111Ev,
  (VTBL_ENTRY)&_ZN9S21925C144v112Ev,
};
extern VTBL_ENTRY _ZTI9S21925C14[];
extern  VTBL_ENTRY _ZTV9S21925C14[];
Class_Descriptor cd_S21925C14 = {  "S21925C14", // class name
  bases_S21925C14, 1,
  &(vtc_S21925C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S21925C14),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S21925C14),49, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C15  : S21925C12 {
  virtual  ~S21925C15(); // _ZN9S21925C15D1Ev
  virtual void  v113(); // _ZN9S21925C154v113Ev
  virtual void  v114(); // _ZN9S21925C154v114Ev
  virtual void  v115(); // _ZN9S21925C154v115Ev
  virtual void  v116(); // _ZN9S21925C154v116Ev
  virtual void  v117(); // _ZN9S21925C154v117Ev
  virtual void  v118(); // _ZN9S21925C154v118Ev
  virtual void  v119(); // _ZN9S21925C154v119Ev
  virtual void  v120(); // _ZN9S21925C154v120Ev
  virtual void  v121(); // _ZN9S21925C154v121Ev
  virtual void  v122(); // _ZN9S21925C154v122Ev
  virtual void  v123(); // _ZN9S21925C154v123Ev
  virtual void  v124(); // _ZN9S21925C154v124Ev
  virtual void  v125(); // _ZN9S21925C154v125Ev
  virtual void  v126(); // _ZN9S21925C154v126Ev
  virtual void  v127(); // _ZN9S21925C154v127Ev
  virtual void  v128(); // _ZN9S21925C154v128Ev
  virtual void  v129(); // _ZN9S21925C154v129Ev
  virtual void  v130(); // _ZN9S21925C154v130Ev
  virtual void  v131(); // _ZN9S21925C154v131Ev
  virtual void  v132(); // _ZN9S21925C154v132Ev
  virtual void  v133(); // _ZN9S21925C154v133Ev
  S21925C15(); // tgen
};
//SIG(-1 S21925C15) C1{ BC2{ vd v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 Fp Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21}


 S21925C15 ::~S21925C15(){ note_dtor("S21925C15", this);}
void  S21925C15 ::v113(){vfunc_called(this, "_ZN9S21925C154v113Ev");}
void  S21925C15 ::v114(){vfunc_called(this, "_ZN9S21925C154v114Ev");}
void  S21925C15 ::v115(){vfunc_called(this, "_ZN9S21925C154v115Ev");}
void  S21925C15 ::v116(){vfunc_called(this, "_ZN9S21925C154v116Ev");}
void  S21925C15 ::v117(){vfunc_called(this, "_ZN9S21925C154v117Ev");}
void  S21925C15 ::v118(){vfunc_called(this, "_ZN9S21925C154v118Ev");}
void  S21925C15 ::v119(){vfunc_called(this, "_ZN9S21925C154v119Ev");}
void  S21925C15 ::v120(){vfunc_called(this, "_ZN9S21925C154v120Ev");}
void  S21925C15 ::v121(){vfunc_called(this, "_ZN9S21925C154v121Ev");}
void  S21925C15 ::v122(){vfunc_called(this, "_ZN9S21925C154v122Ev");}
void  S21925C15 ::v123(){vfunc_called(this, "_ZN9S21925C154v123Ev");}
void  S21925C15 ::v124(){vfunc_called(this, "_ZN9S21925C154v124Ev");}
void  S21925C15 ::v125(){vfunc_called(this, "_ZN9S21925C154v125Ev");}
void  S21925C15 ::v126(){vfunc_called(this, "_ZN9S21925C154v126Ev");}
void  S21925C15 ::v127(){vfunc_called(this, "_ZN9S21925C154v127Ev");}
void  S21925C15 ::v128(){vfunc_called(this, "_ZN9S21925C154v128Ev");}
void  S21925C15 ::v129(){vfunc_called(this, "_ZN9S21925C154v129Ev");}
void  S21925C15 ::v130(){vfunc_called(this, "_ZN9S21925C154v130Ev");}
void  S21925C15 ::v131(){vfunc_called(this, "_ZN9S21925C154v131Ev");}
void  S21925C15 ::v132(){vfunc_called(this, "_ZN9S21925C154v132Ev");}
void  S21925C15 ::v133(){vfunc_called(this, "_ZN9S21925C154v133Ev");}
S21925C15 ::S21925C15(){ note_ctor("S21925C15", this);} // tgen

static void Test_S21925C15()
{
  extern Class_Descriptor cd_S21925C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S21925C15, buf);
    S21925C15 *dp, &lv = *(dp=new (buf) S21925C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21925C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C15)");
    check_base_class_offset(lv, (S21925C12*), 0, "S21925C15");
    test_class_info(&lv, &cd_S21925C15);
    dp->~S21925C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C15(Test_S21925C15, "S21925C15", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S21925C15C1Ev();
extern void _ZN9S21925C15D1Ev();
Name_Map name_map_S21925C15[] = {
  NSPAIR(_ZN9S21925C15C1Ev),
  NSPAIR(_ZN9S21925C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21925C12;
extern VTBL_ENTRY _ZTI9S21925C12[];
extern  VTBL_ENTRY _ZTV9S21925C12[];
static Base_Class bases_S21925C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21925C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21925C15[];
extern void _ZN9S21925C15D1Ev();
extern void _ZN9S21925C15D0Ev();
extern void _ZN9S21925C123v51Ev();
extern void _ZN9S21925C123v52Ev();
extern void _ZN9S21925C123v53Ev();
extern void _ZN9S21925C123v54Ev();
extern void _ZN9S21925C123v55Ev();
extern void _ZN9S21925C123v56Ev();
extern void _ZN9S21925C123v57Ev();
extern void _ZN9S21925C123v58Ev();
extern void _ZN9S21925C123v59Ev();
extern void _ZN9S21925C123v60Ev();
extern void _ZN9S21925C123v61Ev();
extern void _ZN9S21925C123v62Ev();
extern void _ZN9S21925C123v63Ev();
extern void _ZN9S21925C123v64Ev();
extern void _ZN9S21925C123v65Ev();
extern void _ZN9S21925C123v66Ev();
extern void _ZN9S21925C123v67Ev();
extern void _ZN9S21925C123v68Ev();
extern void _ZN9S21925C123v69Ev();
extern void _ZN9S21925C123v70Ev();
extern void _ZN9S21925C123v71Ev();
extern void _ZN9S21925C123v72Ev();
extern void _ZN9S21925C123v73Ev();
extern void _ZN9S21925C123v74Ev();
extern void _ZN9S21925C123v75Ev();
extern void _ZN9S21925C123v76Ev();
extern void _ZN9S21925C123v77Ev();
extern void _ZN9S21925C154v113Ev();
extern void _ZN9S21925C154v114Ev();
extern void _ZN9S21925C154v115Ev();
extern void _ZN9S21925C154v116Ev();
extern void _ZN9S21925C154v117Ev();
extern void _ZN9S21925C154v118Ev();
extern void _ZN9S21925C154v119Ev();
extern void _ZN9S21925C154v120Ev();
extern void _ZN9S21925C154v121Ev();
extern void _ZN9S21925C154v122Ev();
extern void _ZN9S21925C154v123Ev();
extern void _ZN9S21925C154v124Ev();
extern void _ZN9S21925C154v125Ev();
extern void _ZN9S21925C154v126Ev();
extern void _ZN9S21925C154v127Ev();
extern void _ZN9S21925C154v128Ev();
extern void _ZN9S21925C154v129Ev();
extern void _ZN9S21925C154v130Ev();
extern void _ZN9S21925C154v131Ev();
extern void _ZN9S21925C154v132Ev();
extern void _ZN9S21925C154v133Ev();
static  VTBL_ENTRY vtc_S21925C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C15[0]),
  (VTBL_ENTRY)&_ZN9S21925C15D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C15D0Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v51Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v52Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v53Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v54Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v55Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v56Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v57Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v58Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v59Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v60Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v61Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v62Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v63Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v64Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v65Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v66Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v67Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v68Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v69Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v70Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v71Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v72Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v73Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v74Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v75Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v76Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v77Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v113Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v114Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v115Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v116Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v117Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v118Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v119Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v120Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v121Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v122Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v123Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v124Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v125Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v126Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v127Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v128Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v129Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v130Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v131Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v132Ev,
  (VTBL_ENTRY)&_ZN9S21925C154v133Ev,
};
extern VTBL_ENTRY _ZTI9S21925C15[];
extern  VTBL_ENTRY _ZTV9S21925C15[];
Class_Descriptor cd_S21925C15 = {  "S21925C15", // class name
  bases_S21925C15, 1,
  &(vtc_S21925C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S21925C15),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S21925C15),52, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C16  : S21925C12 {
  virtual  ~S21925C16(); // _ZN9S21925C16D1Ev
  virtual void  v134(); // _ZN9S21925C164v134Ev
  virtual void  v135(); // _ZN9S21925C164v135Ev
  virtual void  v136(); // _ZN9S21925C164v136Ev
  virtual void  v137(); // _ZN9S21925C164v137Ev
  virtual void  v138(); // _ZN9S21925C164v138Ev
  virtual void  v139(); // _ZN9S21925C164v139Ev
  virtual void  v140(); // _ZN9S21925C164v140Ev
  virtual void  v141(); // _ZN9S21925C164v141Ev
  virtual void  v142(); // _ZN9S21925C164v142Ev
  virtual void  v143(); // _ZN9S21925C164v143Ev
  virtual void  v144(); // _ZN9S21925C164v144Ev
  virtual void  v145(); // _ZN9S21925C164v145Ev
  virtual void  v146(); // _ZN9S21925C164v146Ev
  virtual void  v147(); // _ZN9S21925C164v147Ev
  virtual void  v148(); // _ZN9S21925C164v148Ev
  virtual void  v149(); // _ZN9S21925C164v149Ev
  virtual void  v150(); // _ZN9S21925C164v150Ev
  virtual void  v151(); // _ZN9S21925C164v151Ev
  virtual void  v152(); // _ZN9S21925C164v152Ev
  virtual void  v153(); // _ZN9S21925C164v153Ev
  virtual void  v154(); // _ZN9S21925C164v154Ev
  virtual void  v155(); // _ZN9S21925C164v155Ev
  S21925C16(); // tgen
};
//SIG(-1 S21925C16) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 Fp Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22}


 S21925C16 ::~S21925C16(){ note_dtor("S21925C16", this);}
void  S21925C16 ::v134(){vfunc_called(this, "_ZN9S21925C164v134Ev");}
void  S21925C16 ::v135(){vfunc_called(this, "_ZN9S21925C164v135Ev");}
void  S21925C16 ::v136(){vfunc_called(this, "_ZN9S21925C164v136Ev");}
void  S21925C16 ::v137(){vfunc_called(this, "_ZN9S21925C164v137Ev");}
void  S21925C16 ::v138(){vfunc_called(this, "_ZN9S21925C164v138Ev");}
void  S21925C16 ::v139(){vfunc_called(this, "_ZN9S21925C164v139Ev");}
void  S21925C16 ::v140(){vfunc_called(this, "_ZN9S21925C164v140Ev");}
void  S21925C16 ::v141(){vfunc_called(this, "_ZN9S21925C164v141Ev");}
void  S21925C16 ::v142(){vfunc_called(this, "_ZN9S21925C164v142Ev");}
void  S21925C16 ::v143(){vfunc_called(this, "_ZN9S21925C164v143Ev");}
void  S21925C16 ::v144(){vfunc_called(this, "_ZN9S21925C164v144Ev");}
void  S21925C16 ::v145(){vfunc_called(this, "_ZN9S21925C164v145Ev");}
void  S21925C16 ::v146(){vfunc_called(this, "_ZN9S21925C164v146Ev");}
void  S21925C16 ::v147(){vfunc_called(this, "_ZN9S21925C164v147Ev");}
void  S21925C16 ::v148(){vfunc_called(this, "_ZN9S21925C164v148Ev");}
void  S21925C16 ::v149(){vfunc_called(this, "_ZN9S21925C164v149Ev");}
void  S21925C16 ::v150(){vfunc_called(this, "_ZN9S21925C164v150Ev");}
void  S21925C16 ::v151(){vfunc_called(this, "_ZN9S21925C164v151Ev");}
void  S21925C16 ::v152(){vfunc_called(this, "_ZN9S21925C164v152Ev");}
void  S21925C16 ::v153(){vfunc_called(this, "_ZN9S21925C164v153Ev");}
void  S21925C16 ::v154(){vfunc_called(this, "_ZN9S21925C164v154Ev");}
void  S21925C16 ::v155(){vfunc_called(this, "_ZN9S21925C164v155Ev");}
S21925C16 ::S21925C16(){ note_ctor("S21925C16", this);} // tgen

static void Test_S21925C16()
{
  extern Class_Descriptor cd_S21925C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S21925C16, buf);
    S21925C16 *dp, &lv = *(dp=new (buf) S21925C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21925C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C16)");
    check_base_class_offset(lv, (S21925C12*), 0, "S21925C16");
    test_class_info(&lv, &cd_S21925C16);
    dp->~S21925C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C16(Test_S21925C16, "S21925C16", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S21925C16C1Ev();
extern void _ZN9S21925C16D1Ev();
Name_Map name_map_S21925C16[] = {
  NSPAIR(_ZN9S21925C16C1Ev),
  NSPAIR(_ZN9S21925C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21925C12;
extern VTBL_ENTRY _ZTI9S21925C12[];
extern  VTBL_ENTRY _ZTV9S21925C12[];
static Base_Class bases_S21925C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21925C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21925C16[];
extern void _ZN9S21925C16D1Ev();
extern void _ZN9S21925C16D0Ev();
extern void _ZN9S21925C123v51Ev();
extern void _ZN9S21925C123v52Ev();
extern void _ZN9S21925C123v53Ev();
extern void _ZN9S21925C123v54Ev();
extern void _ZN9S21925C123v55Ev();
extern void _ZN9S21925C123v56Ev();
extern void _ZN9S21925C123v57Ev();
extern void _ZN9S21925C123v58Ev();
extern void _ZN9S21925C123v59Ev();
extern void _ZN9S21925C123v60Ev();
extern void _ZN9S21925C123v61Ev();
extern void _ZN9S21925C123v62Ev();
extern void _ZN9S21925C123v63Ev();
extern void _ZN9S21925C123v64Ev();
extern void _ZN9S21925C123v65Ev();
extern void _ZN9S21925C123v66Ev();
extern void _ZN9S21925C123v67Ev();
extern void _ZN9S21925C123v68Ev();
extern void _ZN9S21925C123v69Ev();
extern void _ZN9S21925C123v70Ev();
extern void _ZN9S21925C123v71Ev();
extern void _ZN9S21925C123v72Ev();
extern void _ZN9S21925C123v73Ev();
extern void _ZN9S21925C123v74Ev();
extern void _ZN9S21925C123v75Ev();
extern void _ZN9S21925C123v76Ev();
extern void _ZN9S21925C123v77Ev();
extern void _ZN9S21925C164v134Ev();
extern void _ZN9S21925C164v135Ev();
extern void _ZN9S21925C164v136Ev();
extern void _ZN9S21925C164v137Ev();
extern void _ZN9S21925C164v138Ev();
extern void _ZN9S21925C164v139Ev();
extern void _ZN9S21925C164v140Ev();
extern void _ZN9S21925C164v141Ev();
extern void _ZN9S21925C164v142Ev();
extern void _ZN9S21925C164v143Ev();
extern void _ZN9S21925C164v144Ev();
extern void _ZN9S21925C164v145Ev();
extern void _ZN9S21925C164v146Ev();
extern void _ZN9S21925C164v147Ev();
extern void _ZN9S21925C164v148Ev();
extern void _ZN9S21925C164v149Ev();
extern void _ZN9S21925C164v150Ev();
extern void _ZN9S21925C164v151Ev();
extern void _ZN9S21925C164v152Ev();
extern void _ZN9S21925C164v153Ev();
extern void _ZN9S21925C164v154Ev();
extern void _ZN9S21925C164v155Ev();
static  VTBL_ENTRY vtc_S21925C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C16[0]),
  (VTBL_ENTRY)&_ZN9S21925C16D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C16D0Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v51Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v52Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v53Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v54Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v55Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v56Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v57Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v58Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v59Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v60Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v61Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v62Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v63Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v64Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v65Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v66Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v67Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v68Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v69Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v70Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v71Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v72Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v73Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v74Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v75Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v76Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v77Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v134Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v135Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v136Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v137Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v138Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v139Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v140Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v141Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v142Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v143Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v144Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v145Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v146Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v147Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v148Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v149Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v150Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v151Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v152Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v153Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v154Ev,
  (VTBL_ENTRY)&_ZN9S21925C164v155Ev,
};
extern VTBL_ENTRY _ZTI9S21925C16[];
extern  VTBL_ENTRY _ZTV9S21925C16[];
Class_Descriptor cd_S21925C16 = {  "S21925C16", // class name
  bases_S21925C16, 1,
  &(vtc_S21925C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S21925C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S21925C16),53, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C19  : S21925C12 {
  virtual  ~S21925C19(); // _ZN9S21925C19D1Ev
  virtual void  v195(); // _ZN9S21925C194v195Ev
  virtual void  v196(); // _ZN9S21925C194v196Ev
  virtual void  v197(); // _ZN9S21925C194v197Ev
  virtual void  v198(); // _ZN9S21925C194v198Ev
  virtual void  v199(); // _ZN9S21925C194v199Ev
  virtual void  v200(); // _ZN9S21925C194v200Ev
  S21925C19(); // tgen
};
//SIG(-1 S21925C19) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp Fi} vd v1 v2 v3 v4 v5 v6}


 S21925C19 ::~S21925C19(){ note_dtor("S21925C19", this);}
void  S21925C19 ::v195(){vfunc_called(this, "_ZN9S21925C194v195Ev");}
void  S21925C19 ::v196(){vfunc_called(this, "_ZN9S21925C194v196Ev");}
void  S21925C19 ::v197(){vfunc_called(this, "_ZN9S21925C194v197Ev");}
void  S21925C19 ::v198(){vfunc_called(this, "_ZN9S21925C194v198Ev");}
void  S21925C19 ::v199(){vfunc_called(this, "_ZN9S21925C194v199Ev");}
void  S21925C19 ::v200(){vfunc_called(this, "_ZN9S21925C194v200Ev");}
S21925C19 ::S21925C19(){ note_ctor("S21925C19", this);} // tgen

static void Test_S21925C19()
{
  extern Class_Descriptor cd_S21925C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S21925C19, buf);
    S21925C19 *dp, &lv = *(dp=new (buf) S21925C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21925C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C19)");
    check_base_class_offset(lv, (S21925C12*), 0, "S21925C19");
    test_class_info(&lv, &cd_S21925C19);
    dp->~S21925C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C19(Test_S21925C19, "S21925C19", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S21925C19C1Ev();
extern void _ZN9S21925C19D1Ev();
Name_Map name_map_S21925C19[] = {
  NSPAIR(_ZN9S21925C19C1Ev),
  NSPAIR(_ZN9S21925C19D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21925C12;
extern VTBL_ENTRY _ZTI9S21925C12[];
extern  VTBL_ENTRY _ZTV9S21925C12[];
static Base_Class bases_S21925C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21925C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21925C19[];
extern void _ZN9S21925C19D1Ev();
extern void _ZN9S21925C19D0Ev();
extern void _ZN9S21925C123v51Ev();
extern void _ZN9S21925C123v52Ev();
extern void _ZN9S21925C123v53Ev();
extern void _ZN9S21925C123v54Ev();
extern void _ZN9S21925C123v55Ev();
extern void _ZN9S21925C123v56Ev();
extern void _ZN9S21925C123v57Ev();
extern void _ZN9S21925C123v58Ev();
extern void _ZN9S21925C123v59Ev();
extern void _ZN9S21925C123v60Ev();
extern void _ZN9S21925C123v61Ev();
extern void _ZN9S21925C123v62Ev();
extern void _ZN9S21925C123v63Ev();
extern void _ZN9S21925C123v64Ev();
extern void _ZN9S21925C123v65Ev();
extern void _ZN9S21925C123v66Ev();
extern void _ZN9S21925C123v67Ev();
extern void _ZN9S21925C123v68Ev();
extern void _ZN9S21925C123v69Ev();
extern void _ZN9S21925C123v70Ev();
extern void _ZN9S21925C123v71Ev();
extern void _ZN9S21925C123v72Ev();
extern void _ZN9S21925C123v73Ev();
extern void _ZN9S21925C123v74Ev();
extern void _ZN9S21925C123v75Ev();
extern void _ZN9S21925C123v76Ev();
extern void _ZN9S21925C123v77Ev();
extern void _ZN9S21925C194v195Ev();
extern void _ZN9S21925C194v196Ev();
extern void _ZN9S21925C194v197Ev();
extern void _ZN9S21925C194v198Ev();
extern void _ZN9S21925C194v199Ev();
extern void _ZN9S21925C194v200Ev();
static  VTBL_ENTRY vtc_S21925C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C19[0]),
  (VTBL_ENTRY)&_ZN9S21925C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C19D0Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v51Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v52Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v53Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v54Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v55Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v56Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v57Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v58Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v59Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v60Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v61Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v62Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v63Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v64Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v65Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v66Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v67Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v68Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v69Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v70Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v71Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v72Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v73Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v74Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v75Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v76Ev,
  (VTBL_ENTRY)&_ZN9S21925C123v77Ev,
  (VTBL_ENTRY)&_ZN9S21925C194v195Ev,
  (VTBL_ENTRY)&_ZN9S21925C194v196Ev,
  (VTBL_ENTRY)&_ZN9S21925C194v197Ev,
  (VTBL_ENTRY)&_ZN9S21925C194v198Ev,
  (VTBL_ENTRY)&_ZN9S21925C194v199Ev,
  (VTBL_ENTRY)&_ZN9S21925C194v200Ev,
};
extern VTBL_ENTRY _ZTI9S21925C19[];
extern  VTBL_ENTRY _ZTV9S21925C19[];
Class_Descriptor cd_S21925C19 = {  "S21925C19", // class name
  bases_S21925C19, 1,
  &(vtc_S21925C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S21925C19),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S21925C19),37, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C21  {
  int s21925c21f0[2];
  __tsi64 s21925c21f1[3];
  char s21925c21f2[2048];
  int s21925c21f3[6];
  __tsi64 s21925c21f4;
  int s21925c21f5[4];
  void *s21925c21f6[2];
  char s21925c21f7;
  void  mf21925c21(); // _ZN9S21925C2110mf21925c21Ev
  virtual  ~S21925C21(); // _ZN9S21925C21D1Ev
  S21925C21(); // tgen
};
//SIG(-1 S21925C21) C1{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc}


void  S21925C21 ::mf21925c21(){}
 S21925C21 ::~S21925C21(){ note_dtor("S21925C21", this);}
S21925C21 ::S21925C21(){ note_ctor("S21925C21", this);} // tgen

static void Test_S21925C21()
{
  extern Class_Descriptor cd_S21925C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(271,537)];
    init_test(&cd_S21925C21, buf);
    S21925C21 *dp, &lv = *(dp=new (buf) S21925C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2160,2144), "sizeof(S21925C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C21)");
    check_field_offset(lv, s21925c21f0, ABISELECT(8,4), "S21925C21.s21925c21f0");
    check_field_offset(lv, s21925c21f1, ABISELECT(16,12), "S21925C21.s21925c21f1");
    check_field_offset(lv, s21925c21f2, ABISELECT(40,36), "S21925C21.s21925c21f2");
    check_field_offset(lv, s21925c21f3, ABISELECT(2088,2084), "S21925C21.s21925c21f3");
    check_field_offset(lv, s21925c21f4, ABISELECT(2112,2108), "S21925C21.s21925c21f4");
    check_field_offset(lv, s21925c21f5, ABISELECT(2120,2116), "S21925C21.s21925c21f5");
    check_field_offset(lv, s21925c21f6, ABISELECT(2136,2132), "S21925C21.s21925c21f6");
    check_field_offset(lv, s21925c21f7, ABISELECT(2152,2140), "S21925C21.s21925c21f7");
    test_class_info(&lv, &cd_S21925C21);
    dp->~S21925C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C21(Test_S21925C21, "S21925C21", ABISELECT(2160,2144));

#else // __cplusplus

extern void _ZN9S21925C21C1Ev();
extern void _ZN9S21925C21D1Ev();
Name_Map name_map_S21925C21[] = {
  NSPAIR(_ZN9S21925C21C1Ev),
  NSPAIR(_ZN9S21925C21D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21925C21[];
extern void _ZN9S21925C21D1Ev();
extern void _ZN9S21925C21D0Ev();
static  VTBL_ENTRY vtc_S21925C21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C21[0]),
  (VTBL_ENTRY)&_ZN9S21925C21D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C21D0Ev,
};
extern VTBL_ENTRY _ZTI9S21925C21[];
extern  VTBL_ENTRY _ZTV9S21925C21[];
Class_Descriptor cd_S21925C21 = {  "S21925C21", // class name
  0,0,//no base classes
  &(vtc_S21925C21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2160,2144), // object size
  NSPAIRA(_ZTI9S21925C21),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21925C21),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C20  {
  char s21925c20f0[6];
  void *s21925c20f1;
  int s21925c20f2[2];
  ::S21925C21 s21925c20f3;
  int s21925c20f4[2];
  void  mf21925c20(); // _ZN9S21925C2010mf21925c20Ev
};
//SIG(-1 S21925C20) C1{ m Fc[6] Fp Fi[2] FC2{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc} Fi[2]}


void  S21925C20 ::mf21925c20(){}

static void Test_S21925C20()
{
  {
    init_simple_test("S21925C20");
    S21925C20 lv;
    check2(sizeof(lv), ABISELECT(2192,2172), "sizeof(S21925C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C20)");
    check_field_offset(lv, s21925c20f0, 0, "S21925C20.s21925c20f0");
    check_field_offset(lv, s21925c20f1, 8, "S21925C20.s21925c20f1");
    check_field_offset(lv, s21925c20f2, ABISELECT(16,12), "S21925C20.s21925c20f2");
    check_field_offset(lv, s21925c20f3, ABISELECT(24,20), "S21925C20.s21925c20f3");
    check_field_offset(lv, s21925c20f4, ABISELECT(2184,2164), "S21925C20.s21925c20f4");
  }
}
static Arrange_To_Call_Me vS21925C20(Test_S21925C20, "S21925C20", ABISELECT(2192,2172));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C22_nt  {
  int s21925c22f0[3];
  void  mf21925c22(); // _ZN12S21925C22_nt10mf21925c22Ev
};
//SIG(-1 S21925C22_nt) C1{ m Fi[3]}


void  S21925C22_nt ::mf21925c22(){}

//skip512 S21925C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C23_nt  {
  char s21925c23f0;
  void  mf21925c23(); // _ZN12S21925C23_nt10mf21925c23Ev
};
//SIG(-1 S21925C23_nt) C1{ m Fc}


void  S21925C23_nt ::mf21925c23(){}

//skip512 S21925C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C25  {
  int s21925c25f0[2];
  __tsi64 s21925c25f1;
  int s21925c25f2[4];
  void  mf21925c25(); // _ZN9S21925C2510mf21925c25Ev
  virtual  ~S21925C25(); // _ZN9S21925C25D1Ev
  S21925C25(); // tgen
};
//SIG(-1 S21925C25) C1{ vd m Fi[2] FL Fi[4]}


void  S21925C25 ::mf21925c25(){}
 S21925C25 ::~S21925C25(){ note_dtor("S21925C25", this);}
S21925C25 ::S21925C25(){ note_ctor("S21925C25", this);} // tgen

static void Test_S21925C25()
{
  extern Class_Descriptor cd_S21925C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,10)];
    init_test(&cd_S21925C25, buf);
    S21925C25 *dp, &lv = *(dp=new (buf) S21925C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,36), "sizeof(S21925C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C25)");
    check_field_offset(lv, s21925c25f0, ABISELECT(8,4), "S21925C25.s21925c25f0");
    check_field_offset(lv, s21925c25f1, ABISELECT(16,12), "S21925C25.s21925c25f1");
    check_field_offset(lv, s21925c25f2, ABISELECT(24,20), "S21925C25.s21925c25f2");
    test_class_info(&lv, &cd_S21925C25);
    dp->~S21925C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C25(Test_S21925C25, "S21925C25", ABISELECT(40,36));

#else // __cplusplus

extern void _ZN9S21925C25C1Ev();
extern void _ZN9S21925C25D1Ev();
Name_Map name_map_S21925C25[] = {
  NSPAIR(_ZN9S21925C25C1Ev),
  NSPAIR(_ZN9S21925C25D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21925C25[];
extern void _ZN9S21925C25D1Ev();
extern void _ZN9S21925C25D0Ev();
static  VTBL_ENTRY vtc_S21925C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C25[0]),
  (VTBL_ENTRY)&_ZN9S21925C25D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C25D0Ev,
};
extern VTBL_ENTRY _ZTI9S21925C25[];
extern  VTBL_ENTRY _ZTV9S21925C25[];
Class_Descriptor cd_S21925C25 = {  "S21925C25", // class name
  0,0,//no base classes
  &(vtc_S21925C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,36), // object size
  NSPAIRA(_ZTI9S21925C25),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21925C25),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C24  {
  void *s21925c24f0;
  int s21925c24f1[3];
  ::S21925C21 s21925c24f2;
  ::S21925C25 s21925c24f3;
  int s21925c24f4[6];
  ::S21925C5_nt s21925c24f5;
  int s21925c24f6[4];
  void  mf21925c24(); // _ZN9S21925C2410mf21925c24Ev
};
//SIG(-1 S21925C24) C1{ m Fp Fi[3] FC2{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc} FC3{ vd m Fi[2] FL Fi[4]} Fi[6] FC4{ Fi[4]} Fi[4]}


void  S21925C24 ::mf21925c24(){}

static void Test_S21925C24()
{
  {
    init_simple_test("S21925C24");
    S21925C24 lv;
    check2(sizeof(lv), ABISELECT(2280,2252), "sizeof(S21925C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C24)");
    check_field_offset(lv, s21925c24f0, 0, "S21925C24.s21925c24f0");
    check_field_offset(lv, s21925c24f1, ABISELECT(8,4), "S21925C24.s21925c24f1");
    check_field_offset(lv, s21925c24f2, ABISELECT(24,16), "S21925C24.s21925c24f2");
    check_field_offset(lv, s21925c24f3, ABISELECT(2184,2160), "S21925C24.s21925c24f3");
    check_field_offset(lv, s21925c24f4, ABISELECT(2224,2196), "S21925C24.s21925c24f4");
    check_field_offset(lv, s21925c24f5, ABISELECT(2248,2220), "S21925C24.s21925c24f5");
    check_field_offset(lv, s21925c24f6, ABISELECT(2264,2236), "S21925C24.s21925c24f6");
  }
}
static Arrange_To_Call_Me vS21925C24(Test_S21925C24, "S21925C24", ABISELECT(2280,2252));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C10  : S21925C8 {
  void *s21925c10f0;
  ::S21925C11 s21925c10f1;
  ::S21925C13 s21925c10f2;
  ::S21925C14 s21925c10f3;
  ::S21925C15 s21925c10f4;
  ::S21925C16 s21925c10f5;
  ::S21925C15 s21925c10f6;
  ::S21925C14 s21925c10f7;
  ::S21925C19 s21925c10f8;
  void *s21925c10f9[4];
  ::S21925C20 s21925c10f10;
  ::S21925C22_nt s21925c10f11;
  ::S21925C23_nt s21925c10f12;
  ::S21925C24 s21925c10f13;
  void *s21925c10f14;
  int s21925c10f15[3];
  virtual  ~S21925C10(); // _ZN9S21925C10D1Ev
  virtual void  v40(); // _ZN9S21925C103v40Ev
  virtual void  v41(); // _ZN9S21925C103v41Ev
  virtual void  v42(); // _ZN9S21925C103v42Ev
  virtual void  v43(); // _ZN9S21925C103v43Ev
  virtual void  v44(); // _ZN9S21925C103v44Ev
  virtual void  v45(); // _ZN9S21925C103v45Ev
  virtual void  v46(); // _ZN9S21925C103v46Ev
  S21925C10(); // tgen
};
//SIG(-1 S21925C10) C1{ BC2{ v8 v9 v10 v11 v12 v13 v14} vd v1 v2 v3 v4 v5 v6 v7 Fp FC3{ BC4{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 Fp Fi} vd v15 v16 v17 v18} FC5{ BC4 vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62} FC6{ BC4 vd v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80} FC7{ BC4 vd v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101} FC8{ BC4 vd v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123} FC7 FC6 FC9{ BC4 vd v124 v125 v126 v127 v128 v129} Fp[4] FC10{ m Fc[6] Fp Fi[2] FC11{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc} Fi[2]} FC12{ m Fi[3]} FC13{ m Fc} FC14{ m Fp Fi[3] FC11 FC15{ vd m Fi[2] FL Fi[4]} Fi[6] FC16{ Fi[4]} Fi[4]} Fp Fi[3]}


 S21925C10 ::~S21925C10(){ note_dtor("S21925C10", this);}
void  S21925C10 ::v40(){vfunc_called(this, "_ZN9S21925C103v40Ev");}
void  S21925C10 ::v41(){vfunc_called(this, "_ZN9S21925C103v41Ev");}
void  S21925C10 ::v42(){vfunc_called(this, "_ZN9S21925C103v42Ev");}
void  S21925C10 ::v43(){vfunc_called(this, "_ZN9S21925C103v43Ev");}
void  S21925C10 ::v44(){vfunc_called(this, "_ZN9S21925C103v44Ev");}
void  S21925C10 ::v45(){vfunc_called(this, "_ZN9S21925C103v45Ev");}
void  S21925C10 ::v46(){vfunc_called(this, "_ZN9S21925C103v46Ev");}
S21925C10 ::S21925C10(){ note_ctor("S21925C10", this);} // tgen

static void Test_S21925C10()
{
  extern Class_Descriptor cd_S21925C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(595,1145)];
    init_test(&cd_S21925C10, buf);
    S21925C10 *dp, &lv = *(dp=new (buf) S21925C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4752,4576), "sizeof(S21925C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C10)");
    check_base_class_offset(lv, (S21925C8*), 0, "S21925C10");
    check_field_offset(lv, s21925c10f0, ABISELECT(8,4), "S21925C10.s21925c10f0");
    check_field_offset(lv, s21925c10f1, ABISELECT(16,8), "S21925C10.s21925c10f1");
    check_field_offset(lv, s21925c10f2, ABISELECT(40,20), "S21925C10.s21925c10f2");
    check_field_offset(lv, s21925c10f3, ABISELECT(64,32), "S21925C10.s21925c10f3");
    check_field_offset(lv, s21925c10f4, ABISELECT(88,44), "S21925C10.s21925c10f4");
    check_field_offset(lv, s21925c10f5, ABISELECT(112,56), "S21925C10.s21925c10f5");
    check_field_offset(lv, s21925c10f6, ABISELECT(136,68), "S21925C10.s21925c10f6");
    check_field_offset(lv, s21925c10f7, ABISELECT(160,80), "S21925C10.s21925c10f7");
    check_field_offset(lv, s21925c10f8, ABISELECT(184,92), "S21925C10.s21925c10f8");
    check_field_offset(lv, s21925c10f9, ABISELECT(208,104), "S21925C10.s21925c10f9");
    check_field_offset(lv, s21925c10f10, ABISELECT(240,120), "S21925C10.s21925c10f10");
    check_field_offset(lv, s21925c10f11, ABISELECT(2432,2292), "S21925C10.s21925c10f11");
    check_field_offset(lv, s21925c10f12, ABISELECT(2444,2304), "S21925C10.s21925c10f12");
    check_field_offset(lv, s21925c10f13, ABISELECT(2448,2308), "S21925C10.s21925c10f13");
    check_field_offset(lv, s21925c10f14, ABISELECT(4728,4560), "S21925C10.s21925c10f14");
    check_field_offset(lv, s21925c10f15, ABISELECT(4736,4564), "S21925C10.s21925c10f15");
    test_class_info(&lv, &cd_S21925C10);
    dp->~S21925C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C10(Test_S21925C10, "S21925C10", ABISELECT(4752,4576));

#else // __cplusplus

extern void _ZN9S21925C10C1Ev();
extern void _ZN9S21925C10D1Ev();
Name_Map name_map_S21925C10[] = {
  NSPAIR(_ZN9S21925C10C1Ev),
  NSPAIR(_ZN9S21925C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21925C8;
extern VTBL_ENTRY _ZTI8S21925C8[];
extern  VTBL_ENTRY _ZTV8S21925C8[];
static Base_Class bases_S21925C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21925C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21925C10[];
extern void _ZN8S21925C83v33Ev();
extern void _ZN8S21925C83v34Ev();
extern void _ZN8S21925C83v35Ev();
extern void _ZN8S21925C83v36Ev();
extern void _ZN8S21925C83v37Ev();
extern void _ZN8S21925C83v38Ev();
extern void _ZN8S21925C83v39Ev();
extern void _ZN9S21925C10D1Ev();
extern void _ZN9S21925C10D0Ev();
extern void _ZN9S21925C103v40Ev();
extern void _ZN9S21925C103v41Ev();
extern void _ZN9S21925C103v42Ev();
extern void _ZN9S21925C103v43Ev();
extern void _ZN9S21925C103v44Ev();
extern void _ZN9S21925C103v45Ev();
extern void _ZN9S21925C103v46Ev();
static  VTBL_ENTRY vtc_S21925C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C10[0]),
  (VTBL_ENTRY)&_ZN8S21925C83v33Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v34Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v35Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v36Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v37Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v38Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v39Ev,
  (VTBL_ENTRY)&_ZN9S21925C10D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C10D0Ev,
  (VTBL_ENTRY)&_ZN9S21925C103v40Ev,
  (VTBL_ENTRY)&_ZN9S21925C103v41Ev,
  (VTBL_ENTRY)&_ZN9S21925C103v42Ev,
  (VTBL_ENTRY)&_ZN9S21925C103v43Ev,
  (VTBL_ENTRY)&_ZN9S21925C103v44Ev,
  (VTBL_ENTRY)&_ZN9S21925C103v45Ev,
  (VTBL_ENTRY)&_ZN9S21925C103v46Ev,
};
extern VTBL_ENTRY _ZTI9S21925C10[];
extern  VTBL_ENTRY _ZTV9S21925C10[];
Class_Descriptor cd_S21925C10 = {  "S21925C10", // class name
  bases_S21925C10, 1,
  &(vtc_S21925C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(4752,4576), // object size
  NSPAIRA(_ZTI9S21925C10),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S21925C10),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C27  {
  void *s21925c27f0;
  int s21925c27f1;
  void *s21925c27f2[9];
  int s21925c27f3;
  void  mf21925c27(); // _ZN9S21925C2710mf21925c27Ev
  virtual  ~S21925C27(); // _ZN9S21925C27D1Ev
  S21925C27(); // tgen
};
//SIG(-1 S21925C27) C1{ vd m Fp Fi Fp[9] Fi}


void  S21925C27 ::mf21925c27(){}
 S21925C27 ::~S21925C27(){ note_dtor("S21925C27", this);}
S21925C27 ::S21925C27(){ note_ctor("S21925C27", this);} // tgen

static void Test_S21925C27()
{
  extern Class_Descriptor cd_S21925C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[14];
    init_test(&cd_S21925C27, buf);
    S21925C27 *dp, &lv = *(dp=new (buf) S21925C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,52), "sizeof(S21925C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C27)");
    check_field_offset(lv, s21925c27f0, ABISELECT(8,4), "S21925C27.s21925c27f0");
    check_field_offset(lv, s21925c27f1, ABISELECT(16,8), "S21925C27.s21925c27f1");
    check_field_offset(lv, s21925c27f2, ABISELECT(24,12), "S21925C27.s21925c27f2");
    check_field_offset(lv, s21925c27f3, ABISELECT(96,48), "S21925C27.s21925c27f3");
    test_class_info(&lv, &cd_S21925C27);
    dp->~S21925C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C27(Test_S21925C27, "S21925C27", ABISELECT(104,52));

#else // __cplusplus

extern void _ZN9S21925C27C1Ev();
extern void _ZN9S21925C27D1Ev();
Name_Map name_map_S21925C27[] = {
  NSPAIR(_ZN9S21925C27C1Ev),
  NSPAIR(_ZN9S21925C27D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21925C27[];
extern void _ZN9S21925C27D1Ev();
extern void _ZN9S21925C27D0Ev();
static  VTBL_ENTRY vtc_S21925C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C27[0]),
  (VTBL_ENTRY)&_ZN9S21925C27D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C27D0Ev,
};
extern VTBL_ENTRY _ZTI9S21925C27[];
extern  VTBL_ENTRY _ZTV9S21925C27[];
Class_Descriptor cd_S21925C27 = {  "S21925C27", // class name
  0,0,//no base classes
  &(vtc_S21925C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,52), // object size
  NSPAIRA(_ZTI9S21925C27),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21925C27),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C28  {
  __tsi64 s21925c28f0[2];
  int s21925c28f1[6];
};
//SIG(-1 S21925C28) C1{ FL[2] Fi[6]}



static void Test_S21925C28()
{
  {
    init_simple_test("S21925C28");
    S21925C28 lv;
    check2(sizeof(lv), 40, "sizeof(S21925C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C28)");
    check_field_offset(lv, s21925c28f0, 0, "S21925C28.s21925c28f0");
    check_field_offset(lv, s21925c28f1, 16, "S21925C28.s21925c28f1");
  }
}
static Arrange_To_Call_Me vS21925C28(Test_S21925C28, "S21925C28", 40);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C7  : S21925C8 {
  int s21925c7f0[2];
  void *s21925c7f1;
  ::S21925C9 s21925c7f2;
  ::S21925C10 s21925c7f3;
  ::S21925C27 s21925c7f4;
  ::S21925C28 s21925c7f5;
  virtual  ~S21925C7(); // _ZN8S21925C7D1Ev
  virtual void  v2(); // _ZN8S21925C72v2Ev
  virtual void  v3(); // _ZN8S21925C72v3Ev
  virtual void  v4(); // _ZN8S21925C72v4Ev
  virtual void  v5(); // _ZN8S21925C72v5Ev
  virtual void  v6(); // _ZN8S21925C72v6Ev
  virtual void  v7(); // _ZN8S21925C72v7Ev
  virtual void  v8(); // _ZN8S21925C72v8Ev
  virtual void  v9(); // _ZN8S21925C72v9Ev
  virtual void  v10(); // _ZN8S21925C73v10Ev
  virtual void  v11(); // _ZN8S21925C73v11Ev
  virtual void  v12(); // _ZN8S21925C73v12Ev
  virtual void  v13(); // _ZN8S21925C73v13Ev
  virtual void  v14(); // _ZN8S21925C73v14Ev
  virtual void  v15(); // _ZN8S21925C73v15Ev
  virtual void  v16(); // _ZN8S21925C73v16Ev
  virtual void  v17(); // _ZN8S21925C73v17Ev
  virtual void  v18(); // _ZN8S21925C73v18Ev
  virtual void  v19(); // _ZN8S21925C73v19Ev
  virtual void  v20(); // _ZN8S21925C73v20Ev
  virtual void  v21(); // _ZN8S21925C73v21Ev
  virtual void  v22(); // _ZN8S21925C73v22Ev
  virtual void  v23(); // _ZN8S21925C73v23Ev
  virtual void  v24(); // _ZN8S21925C73v24Ev
  virtual void  v25(); // _ZN8S21925C73v25Ev
  virtual void  v26(); // _ZN8S21925C73v26Ev
  virtual void  v27(); // _ZN8S21925C73v27Ev
  virtual void  v28(); // _ZN8S21925C73v28Ev
  virtual void  v29(); // _ZN8S21925C73v29Ev
  virtual void  v30(); // _ZN8S21925C73v30Ev
  virtual void  v31(); // _ZN8S21925C73v31Ev
  virtual void  v32(); // _ZN8S21925C73v32Ev
  S21925C7(); // tgen
};
//SIG(-1 S21925C7) C1{ BC2{ v32 v33 v34 v35 v36 v37 v38} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 Fi[2] Fp FC3{ m Fp[3]} FC4{ BC2 vd v39 v40 v41 v42 v43 v44 v45 Fp FC5{ BC6{ vd v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fp Fi} vd v46 v47 v48 v49} FC7{ BC6 vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93} FC8{ BC6 vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111} FC9{ BC6 vd v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132} FC10{ BC6 vd v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154} FC9 FC8 FC11{ BC6 vd v155 v156 v157 v158 v159 v160} Fp[4] FC12{ m Fc[6] Fp Fi[2] FC13{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc} Fi[2]} FC14{ m Fi[3]} FC15{ m Fc} FC16{ m Fp Fi[3] FC13 FC17{ vd m Fi[2] FL Fi[4]} Fi[6] FC18{ Fi[4]} Fi[4]} Fp Fi[3]} FC19{ vd m Fp Fi Fp[9] Fi} FC20{ FL[2] Fi[6]}}


 S21925C7 ::~S21925C7(){ note_dtor("S21925C7", this);}
void  S21925C7 ::v2(){vfunc_called(this, "_ZN8S21925C72v2Ev");}
void  S21925C7 ::v3(){vfunc_called(this, "_ZN8S21925C72v3Ev");}
void  S21925C7 ::v4(){vfunc_called(this, "_ZN8S21925C72v4Ev");}
void  S21925C7 ::v5(){vfunc_called(this, "_ZN8S21925C72v5Ev");}
void  S21925C7 ::v6(){vfunc_called(this, "_ZN8S21925C72v6Ev");}
void  S21925C7 ::v7(){vfunc_called(this, "_ZN8S21925C72v7Ev");}
void  S21925C7 ::v8(){vfunc_called(this, "_ZN8S21925C72v8Ev");}
void  S21925C7 ::v9(){vfunc_called(this, "_ZN8S21925C72v9Ev");}
void  S21925C7 ::v10(){vfunc_called(this, "_ZN8S21925C73v10Ev");}
void  S21925C7 ::v11(){vfunc_called(this, "_ZN8S21925C73v11Ev");}
void  S21925C7 ::v12(){vfunc_called(this, "_ZN8S21925C73v12Ev");}
void  S21925C7 ::v13(){vfunc_called(this, "_ZN8S21925C73v13Ev");}
void  S21925C7 ::v14(){vfunc_called(this, "_ZN8S21925C73v14Ev");}
void  S21925C7 ::v15(){vfunc_called(this, "_ZN8S21925C73v15Ev");}
void  S21925C7 ::v16(){vfunc_called(this, "_ZN8S21925C73v16Ev");}
void  S21925C7 ::v17(){vfunc_called(this, "_ZN8S21925C73v17Ev");}
void  S21925C7 ::v18(){vfunc_called(this, "_ZN8S21925C73v18Ev");}
void  S21925C7 ::v19(){vfunc_called(this, "_ZN8S21925C73v19Ev");}
void  S21925C7 ::v20(){vfunc_called(this, "_ZN8S21925C73v20Ev");}
void  S21925C7 ::v21(){vfunc_called(this, "_ZN8S21925C73v21Ev");}
void  S21925C7 ::v22(){vfunc_called(this, "_ZN8S21925C73v22Ev");}
void  S21925C7 ::v23(){vfunc_called(this, "_ZN8S21925C73v23Ev");}
void  S21925C7 ::v24(){vfunc_called(this, "_ZN8S21925C73v24Ev");}
void  S21925C7 ::v25(){vfunc_called(this, "_ZN8S21925C73v25Ev");}
void  S21925C7 ::v26(){vfunc_called(this, "_ZN8S21925C73v26Ev");}
void  S21925C7 ::v27(){vfunc_called(this, "_ZN8S21925C73v27Ev");}
void  S21925C7 ::v28(){vfunc_called(this, "_ZN8S21925C73v28Ev");}
void  S21925C7 ::v29(){vfunc_called(this, "_ZN8S21925C73v29Ev");}
void  S21925C7 ::v30(){vfunc_called(this, "_ZN8S21925C73v30Ev");}
void  S21925C7 ::v31(){vfunc_called(this, "_ZN8S21925C73v31Ev");}
void  S21925C7 ::v32(){vfunc_called(this, "_ZN8S21925C73v32Ev");}
S21925C7 ::S21925C7(){ note_ctor("S21925C7", this);} // tgen

static void Test_S21925C7()
{
  extern Class_Descriptor cd_S21925C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(619,1175)];
    init_test(&cd_S21925C7, buf);
    S21925C7 *dp, &lv = *(dp=new (buf) S21925C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4944,4696), "sizeof(S21925C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C7)");
    check_base_class_offset(lv, (S21925C8*), 0, "S21925C7");
    check_field_offset(lv, s21925c7f0, ABISELECT(8,4), "S21925C7.s21925c7f0");
    check_field_offset(lv, s21925c7f1, ABISELECT(16,12), "S21925C7.s21925c7f1");
    check_field_offset(lv, s21925c7f2, ABISELECT(24,16), "S21925C7.s21925c7f2");
    check_field_offset(lv, s21925c7f3, ABISELECT(48,28), "S21925C7.s21925c7f3");
    check_field_offset(lv, s21925c7f4, ABISELECT(4800,4604), "S21925C7.s21925c7f4");
    check_field_offset(lv, s21925c7f5, ABISELECT(4904,4656), "S21925C7.s21925c7f5");
    test_class_info(&lv, &cd_S21925C7);
    dp->~S21925C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C7(Test_S21925C7, "S21925C7", ABISELECT(4944,4696));

#else // __cplusplus

extern void _ZN8S21925C7C1Ev();
extern void _ZN8S21925C7D1Ev();
Name_Map name_map_S21925C7[] = {
  NSPAIR(_ZN8S21925C7C1Ev),
  NSPAIR(_ZN8S21925C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21925C8;
extern VTBL_ENTRY _ZTI8S21925C8[];
extern  VTBL_ENTRY _ZTV8S21925C8[];
static Base_Class bases_S21925C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21925C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S21925C7[];
extern void _ZN8S21925C83v33Ev();
extern void _ZN8S21925C83v34Ev();
extern void _ZN8S21925C83v35Ev();
extern void _ZN8S21925C83v36Ev();
extern void _ZN8S21925C83v37Ev();
extern void _ZN8S21925C83v38Ev();
extern void _ZN8S21925C83v39Ev();
extern void _ZN8S21925C7D1Ev();
extern void _ZN8S21925C7D0Ev();
extern void _ZN8S21925C72v2Ev();
extern void _ZN8S21925C72v3Ev();
extern void _ZN8S21925C72v4Ev();
extern void _ZN8S21925C72v5Ev();
extern void _ZN8S21925C72v6Ev();
extern void _ZN8S21925C72v7Ev();
extern void _ZN8S21925C72v8Ev();
extern void _ZN8S21925C72v9Ev();
extern void _ZN8S21925C73v10Ev();
extern void _ZN8S21925C73v11Ev();
extern void _ZN8S21925C73v12Ev();
extern void _ZN8S21925C73v13Ev();
extern void _ZN8S21925C73v14Ev();
extern void _ZN8S21925C73v15Ev();
extern void _ZN8S21925C73v16Ev();
extern void _ZN8S21925C73v17Ev();
extern void _ZN8S21925C73v18Ev();
extern void _ZN8S21925C73v19Ev();
extern void _ZN8S21925C73v20Ev();
extern void _ZN8S21925C73v21Ev();
extern void _ZN8S21925C73v22Ev();
extern void _ZN8S21925C73v23Ev();
extern void _ZN8S21925C73v24Ev();
extern void _ZN8S21925C73v25Ev();
extern void _ZN8S21925C73v26Ev();
extern void _ZN8S21925C73v27Ev();
extern void _ZN8S21925C73v28Ev();
extern void _ZN8S21925C73v29Ev();
extern void _ZN8S21925C73v30Ev();
extern void _ZN8S21925C73v31Ev();
extern void _ZN8S21925C73v32Ev();
static  VTBL_ENTRY vtc_S21925C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21925C7[0]),
  (VTBL_ENTRY)&_ZN8S21925C83v33Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v34Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v35Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v36Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v37Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v38Ev,
  (VTBL_ENTRY)&_ZN8S21925C83v39Ev,
  (VTBL_ENTRY)&_ZN8S21925C7D1Ev,
  (VTBL_ENTRY)&_ZN8S21925C7D0Ev,
  (VTBL_ENTRY)&_ZN8S21925C72v2Ev,
  (VTBL_ENTRY)&_ZN8S21925C72v3Ev,
  (VTBL_ENTRY)&_ZN8S21925C72v4Ev,
  (VTBL_ENTRY)&_ZN8S21925C72v5Ev,
  (VTBL_ENTRY)&_ZN8S21925C72v6Ev,
  (VTBL_ENTRY)&_ZN8S21925C72v7Ev,
  (VTBL_ENTRY)&_ZN8S21925C72v8Ev,
  (VTBL_ENTRY)&_ZN8S21925C72v9Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v10Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v11Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v12Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v13Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v14Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v15Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v16Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v17Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v18Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v19Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v20Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v21Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v22Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v23Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v24Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v25Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v26Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v27Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v28Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v29Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v30Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v31Ev,
  (VTBL_ENTRY)&_ZN8S21925C73v32Ev,
};
extern VTBL_ENTRY _ZTI8S21925C7[];
extern  VTBL_ENTRY _ZTV8S21925C7[];
Class_Descriptor cd_S21925C7 = {  "S21925C7", // class name
  bases_S21925C7, 1,
  &(vtc_S21925C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(4944,4696), // object size
  NSPAIRA(_ZTI8S21925C7),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S21925C7),42, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C30_nt  {
  void *s21925c30f0[3];
};
//SIG(-1 S21925C30_nt) C1{ Fp[3]}



//skip512 S21925C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C35_nt  {
  void  mf21925c35(); // _ZN12S21925C35_nt10mf21925c35Ev
};
//SIG(-1 S21925C35_nt) C1{ m}


void  S21925C35_nt ::mf21925c35(){}

//skip512 S21925C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C34_nt  {
  void *s21925c34f0;
  int s21925c34f1;
  ::S21925C35_nt s21925c34f2;
  ::S21925C35_nt s21925c34f3;
  void  mf21925c34(); // _ZN12S21925C34_nt10mf21925c34Ev
};
//SIG(-1 S21925C34_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S21925C34_nt ::mf21925c34(){}

//skip512 S21925C34_nt

#else // __cplusplus

Class_Descriptor cd_S21925C34_nt = {  "S21925C34_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C33_nt  : S21925C34_nt {
};
//SIG(-1 S21925C33_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S21925C33_nt

#else // __cplusplus

extern Class_Descriptor cd_S21925C34_nt;
static Base_Class bases_S21925C33_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21925C34_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C42  {
  void  mf21925c42(); // _ZN9S21925C4210mf21925c42Ev
};
//SIG(-1 S21925C42) C1{ m}


void  S21925C42 ::mf21925c42(){}

static void Test_S21925C42()
{
  {
    init_simple_test("S21925C42");
    S21925C42 lv;
    check2(sizeof(lv), 1, "sizeof(S21925C42)");
    check2(__alignof__(lv), 1, "__alignof__(S21925C42)");
  }
}
static Arrange_To_Call_Me vS21925C42(Test_S21925C42, "S21925C42", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C41  {
  void *s21925c41f0;
  int s21925c41f1;
  ::S21925C42 s21925c41f2;
  ::S21925C42 s21925c41f3;
  void  mf21925c41(); // _ZN9S21925C4110mf21925c41Ev
};
//SIG(-1 S21925C41) C1{ m Fp Fi FC2{ m} FC2}


void  S21925C41 ::mf21925c41(){}

static void Test_S21925C41()
{
  {
    init_simple_test("S21925C41");
    S21925C41 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S21925C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C41)");
    check_field_offset(lv, s21925c41f0, 0, "S21925C41.s21925c41f0");
    check_field_offset(lv, s21925c41f1, ABISELECT(8,4), "S21925C41.s21925c41f1");
    check_field_offset(lv, s21925c41f2, ABISELECT(12,8), "S21925C41.s21925c41f2");
    check_field_offset(lv, s21925c41f3, ABISELECT(13,9), "S21925C41.s21925c41f3");
  }
}
static Arrange_To_Call_Me vS21925C41(Test_S21925C41, "S21925C41", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S21925C41 = {  "S21925C41", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C44_nt  {
  void *s21925c44f0[2];
  void  mf21925c44(); // _ZN12S21925C44_nt10mf21925c44Ev
};
//SIG(-1 S21925C44_nt) C1{ m Fp[2]}


void  S21925C44_nt ::mf21925c44(){}

//skip512 S21925C44_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C32  {
  char s21925c32f0;
  void *s21925c32f1;
  int s21925c32f2[4];
  char s21925c32f3[2];
  ::S21925C33_nt s21925c32f4;
  ::S21925C33_nt s21925c32f5;
  ::S21925C41 s21925c32f6;
  void *s21925c32f7;
  char s21925c32f8[2];
  int s21925c32f9[2];
  ::S21925C44_nt s21925c32f10;
  ::S21925C2_nt s21925c32f11;
  ::S21925C4_nt s21925c32f12;
  ::S21925C2_nt s21925c32f13;
  void  mf21925c32(); // _ZN9S21925C3210mf21925c32Ev
  virtual  ~S21925C32(); // _ZN9S21925C32D1Ev
  S21925C32(); // tgen
};
//SIG(-1 S21925C32) C1{ vd m Fc Fp Fi[4] Fc[2] FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC2 FC5{ m Fp Fi FC6{ m} FC6} Fp Fc[2] Fi[2] FC7{ m Fp[2]} FC8{ m FC9{ Fl[4]}} FC10{ m Fp FC11{ Fi[4]}} FC8}


void  S21925C32 ::mf21925c32(){}
 S21925C32 ::~S21925C32(){ note_dtor("S21925C32", this);}
S21925C32 ::S21925C32(){ note_ctor("S21925C32", this);} // tgen

static void Test_S21925C32()
{
  extern Class_Descriptor cd_S21925C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,37)];
    init_test(&cd_S21925C32, buf);
    S21925C32 *dp, &lv = *(dp=new (buf) S21925C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,144), "sizeof(S21925C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C32)");
    check_field_offset(lv, s21925c32f0, ABISELECT(8,4), "S21925C32.s21925c32f0");
    check_field_offset(lv, s21925c32f1, ABISELECT(16,8), "S21925C32.s21925c32f1");
    check_field_offset(lv, s21925c32f2, ABISELECT(24,12), "S21925C32.s21925c32f2");
    check_field_offset(lv, s21925c32f3, ABISELECT(40,28), "S21925C32.s21925c32f3");
    check_field_offset(lv, s21925c32f4, ABISELECT(48,32), "S21925C32.s21925c32f4");
    check_field_offset(lv, s21925c32f5, ABISELECT(64,44), "S21925C32.s21925c32f5");
    check_field_offset(lv, s21925c32f6, ABISELECT(80,56), "S21925C32.s21925c32f6");
    check_field_offset(lv, s21925c32f7, ABISELECT(96,68), "S21925C32.s21925c32f7");
    check_field_offset(lv, s21925c32f8, ABISELECT(104,72), "S21925C32.s21925c32f8");
    check_field_offset(lv, s21925c32f9, ABISELECT(108,76), "S21925C32.s21925c32f9");
    check_field_offset(lv, s21925c32f10, ABISELECT(120,84), "S21925C32.s21925c32f10");
    check_field_offset(lv, s21925c32f11, ABISELECT(136,92), "S21925C32.s21925c32f11");
    check_field_offset(lv, s21925c32f12, ABISELECT(168,108), "S21925C32.s21925c32f12");
    check_field_offset(lv, s21925c32f13, ABISELECT(192,128), "S21925C32.s21925c32f13");
    test_class_info(&lv, &cd_S21925C32);
    dp->~S21925C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C32(Test_S21925C32, "S21925C32", ABISELECT(224,144));

#else // __cplusplus

extern void _ZN9S21925C32C1Ev();
extern void _ZN9S21925C32D1Ev();
Name_Map name_map_S21925C32[] = {
  NSPAIR(_ZN9S21925C32C1Ev),
  NSPAIR(_ZN9S21925C32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21925C32[];
extern void _ZN9S21925C32D1Ev();
extern void _ZN9S21925C32D0Ev();
static  VTBL_ENTRY vtc_S21925C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C32[0]),
  (VTBL_ENTRY)&_ZN9S21925C32D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C32D0Ev,
};
extern VTBL_ENTRY _ZTI9S21925C32[];
extern  VTBL_ENTRY _ZTV9S21925C32[];
Class_Descriptor cd_S21925C32 = {  "S21925C32", // class name
  0,0,//no base classes
  &(vtc_S21925C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,144), // object size
  NSPAIRA(_ZTI9S21925C32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21925C32),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C31  {
  ::S21925C32 s21925c31f0;
  ::S21925C2_nt s21925c31f1;
  char s21925c31f2;
  virtual  ~S21925C31(); // _ZN9S21925C31D1Ev
  virtual void  v201(); // _ZN9S21925C314v201Ev
  virtual void  v202(); // _ZN9S21925C314v202Ev
  virtual void  v203(); // _ZN9S21925C314v203Ev
  virtual void  v204(); // _ZN9S21925C314v204Ev
  S21925C31(); // tgen
};
//SIG(-1 S21925C31) C1{ vd v1 v2 v3 v4 FC2{ vd m Fc Fp Fi[4] Fc[2] FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC3 FC6{ m Fp Fi FC7{ m} FC7} Fp Fc[2] Fi[2] FC8{ m Fp[2]} FC9{ m FC10{ Fl[4]}} FC11{ m Fp FC12{ Fi[4]}} FC9} FC9 Fc}


 S21925C31 ::~S21925C31(){ note_dtor("S21925C31", this);}
void  S21925C31 ::v201(){vfunc_called(this, "_ZN9S21925C314v201Ev");}
void  S21925C31 ::v202(){vfunc_called(this, "_ZN9S21925C314v202Ev");}
void  S21925C31 ::v203(){vfunc_called(this, "_ZN9S21925C314v203Ev");}
void  S21925C31 ::v204(){vfunc_called(this, "_ZN9S21925C314v204Ev");}
S21925C31 ::S21925C31(){ note_ctor("S21925C31", this);} // tgen

static void Test_S21925C31()
{
  extern Class_Descriptor cd_S21925C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,43)];
    init_test(&cd_S21925C31, buf);
    S21925C31 *dp, &lv = *(dp=new (buf) S21925C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,168), "sizeof(S21925C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C31)");
    check_field_offset(lv, s21925c31f0, ABISELECT(8,4), "S21925C31.s21925c31f0");
    check_field_offset(lv, s21925c31f1, ABISELECT(232,148), "S21925C31.s21925c31f1");
    check_field_offset(lv, s21925c31f2, ABISELECT(264,164), "S21925C31.s21925c31f2");
    test_class_info(&lv, &cd_S21925C31);
    dp->~S21925C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C31(Test_S21925C31, "S21925C31", ABISELECT(272,168));

#else // __cplusplus

extern void _ZN9S21925C31C1Ev();
extern void _ZN9S21925C31D1Ev();
Name_Map name_map_S21925C31[] = {
  NSPAIR(_ZN9S21925C31C1Ev),
  NSPAIR(_ZN9S21925C31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21925C31[];
extern void _ZN9S21925C31D1Ev();
extern void _ZN9S21925C31D0Ev();
extern void _ZN9S21925C314v201Ev();
extern void _ZN9S21925C314v202Ev();
extern void _ZN9S21925C314v203Ev();
extern void _ZN9S21925C314v204Ev();
static  VTBL_ENTRY vtc_S21925C31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C31[0]),
  (VTBL_ENTRY)&_ZN9S21925C31D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C31D0Ev,
  (VTBL_ENTRY)&_ZN9S21925C314v201Ev,
  (VTBL_ENTRY)&_ZN9S21925C314v202Ev,
  (VTBL_ENTRY)&_ZN9S21925C314v203Ev,
  (VTBL_ENTRY)&_ZN9S21925C314v204Ev,
};
extern VTBL_ENTRY _ZTI9S21925C31[];
extern  VTBL_ENTRY _ZTV9S21925C31[];
Class_Descriptor cd_S21925C31 = {  "S21925C31", // class name
  0,0,//no base classes
  &(vtc_S21925C31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,168), // object size
  NSPAIRA(_ZTI9S21925C31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21925C31),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C47  {
  int s21925c47f0;
  char s21925c47f1;
  __tsi64 s21925c47f2;
  int s21925c47f3;
  void  mf21925c47(); // _ZN9S21925C4710mf21925c47Ev
};
//SIG(1 S21925C47) C1{ m Fi Fc FL Fi}


void  S21925C47 ::mf21925c47(){}

static void Test_S21925C47()
{
  {
    init_simple_test("S21925C47");
    S21925C47 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S21925C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C47)");
    check_field_offset(lv, s21925c47f0, 0, "S21925C47.s21925c47f0");
    check_field_offset(lv, s21925c47f1, 4, "S21925C47.s21925c47f1");
    check_field_offset(lv, s21925c47f2, 8, "S21925C47.s21925c47f2");
    check_field_offset(lv, s21925c47f3, 16, "S21925C47.s21925c47f3");
  }
}
static Arrange_To_Call_Me vS21925C47(Test_S21925C47, "S21925C47", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C46  {
  ::S21925C47 s21925c46f0[5];
  virtual  ~S21925C46(); // _ZN9S21925C46D1Ev
  virtual void  v205(); // _ZN9S21925C464v205Ev
  virtual void  v206(); // _ZN9S21925C464v206Ev
  virtual void  v207(); // _ZN9S21925C464v207Ev
  virtual void  v208(); // _ZN9S21925C464v208Ev
  virtual void  v209(); // _ZN9S21925C464v209Ev
  S21925C46(); // tgen
};
//SIG(-1 S21925C46) C1{ vd v1 v2 v3 v4 v5 FC2{ m Fi Fc FL Fi}[5]}


 S21925C46 ::~S21925C46(){ note_dtor("S21925C46", this);}
void  S21925C46 ::v205(){vfunc_called(this, "_ZN9S21925C464v205Ev");}
void  S21925C46 ::v206(){vfunc_called(this, "_ZN9S21925C464v206Ev");}
void  S21925C46 ::v207(){vfunc_called(this, "_ZN9S21925C464v207Ev");}
void  S21925C46 ::v208(){vfunc_called(this, "_ZN9S21925C464v208Ev");}
void  S21925C46 ::v209(){vfunc_called(this, "_ZN9S21925C464v209Ev");}
S21925C46 ::S21925C46(){ note_ctor("S21925C46", this);} // tgen

static void Test_S21925C46()
{
  extern Class_Descriptor cd_S21925C46;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,27)];
    init_test(&cd_S21925C46, buf);
    S21925C46 *dp, &lv = *(dp=new (buf) S21925C46());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,104), "sizeof(S21925C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C46)");
    check_field_offset(lv, s21925c46f0, ABISELECT(8,4), "S21925C46.s21925c46f0");
    test_class_info(&lv, &cd_S21925C46);
    dp->~S21925C46();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C46(Test_S21925C46, "S21925C46", ABISELECT(128,104));

#else // __cplusplus

extern void _ZN9S21925C46C1Ev();
extern void _ZN9S21925C46D1Ev();
Name_Map name_map_S21925C46[] = {
  NSPAIR(_ZN9S21925C46C1Ev),
  NSPAIR(_ZN9S21925C46D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21925C46[];
extern void _ZN9S21925C46D1Ev();
extern void _ZN9S21925C46D0Ev();
extern void _ZN9S21925C464v205Ev();
extern void _ZN9S21925C464v206Ev();
extern void _ZN9S21925C464v207Ev();
extern void _ZN9S21925C464v208Ev();
extern void _ZN9S21925C464v209Ev();
static  VTBL_ENTRY vtc_S21925C46[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C46[0]),
  (VTBL_ENTRY)&_ZN9S21925C46D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C46D0Ev,
  (VTBL_ENTRY)&_ZN9S21925C464v205Ev,
  (VTBL_ENTRY)&_ZN9S21925C464v206Ev,
  (VTBL_ENTRY)&_ZN9S21925C464v207Ev,
  (VTBL_ENTRY)&_ZN9S21925C464v208Ev,
  (VTBL_ENTRY)&_ZN9S21925C464v209Ev,
};
extern VTBL_ENTRY _ZTI9S21925C46[];
extern  VTBL_ENTRY _ZTV9S21925C46[];
Class_Descriptor cd_S21925C46 = {  "S21925C46", // class name
  0,0,//no base classes
  &(vtc_S21925C46[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,104), // object size
  NSPAIRA(_ZTI9S21925C46),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21925C46),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C29  {
  int s21925c29f0[3];
  void *s21925c29f1;
  ::S21925C30_nt s21925c29f2;
  void *s21925c29f3;
  int s21925c29f4[2];
  void *s21925c29f5;
  ::S21925C31 s21925c29f6;
  ::S21925C46 s21925c29f7;
  void  mf21925c29(); // _ZN9S21925C2910mf21925c29Ev
  virtual  ~S21925C29(); // _ZN9S21925C29D1Ev
  S21925C29(); // tgen
};
//SIG(-1 S21925C29) C1{ vd m Fi[3] Fp FC2{ Fp[3]} Fp Fi[2] Fp FC3{ vd v1 v2 v3 v4 FC4{ vd m Fc Fp Fi[4] Fc[2] FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC5 FC8{ m Fp Fi FC9{ m} FC9} Fp Fc[2] Fi[2] FC10{ m Fp[2]} FC11{ m FC12{ Fl[4]}} FC13{ m Fp FC14{ Fi[4]}} FC11} FC11 Fc} FC15{ vd v5 v6 v7 v8 v9 FC16{ m Fi Fc FL Fi}[5]}}


void  S21925C29 ::mf21925c29(){}
 S21925C29 ::~S21925C29(){ note_dtor("S21925C29", this);}
S21925C29 ::S21925C29(){ note_ctor("S21925C29", this);} // tgen

static void Test_S21925C29()
{
  extern Class_Descriptor cd_S21925C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(61,81)];
    init_test(&cd_S21925C29, buf);
    S21925C29 *dp, &lv = *(dp=new (buf) S21925C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(480,320), "sizeof(S21925C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C29)");
    check_field_offset(lv, s21925c29f0, ABISELECT(8,4), "S21925C29.s21925c29f0");
    check_field_offset(lv, s21925c29f1, ABISELECT(24,16), "S21925C29.s21925c29f1");
    check_field_offset(lv, s21925c29f2, ABISELECT(32,20), "S21925C29.s21925c29f2");
    check_field_offset(lv, s21925c29f3, ABISELECT(56,32), "S21925C29.s21925c29f3");
    check_field_offset(lv, s21925c29f4, ABISELECT(64,36), "S21925C29.s21925c29f4");
    check_field_offset(lv, s21925c29f5, ABISELECT(72,44), "S21925C29.s21925c29f5");
    check_field_offset(lv, s21925c29f6, ABISELECT(80,48), "S21925C29.s21925c29f6");
    check_field_offset(lv, s21925c29f7, ABISELECT(352,216), "S21925C29.s21925c29f7");
    test_class_info(&lv, &cd_S21925C29);
    dp->~S21925C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C29(Test_S21925C29, "S21925C29", ABISELECT(480,320));

#else // __cplusplus

extern void _ZN9S21925C29C1Ev();
extern void _ZN9S21925C29D1Ev();
Name_Map name_map_S21925C29[] = {
  NSPAIR(_ZN9S21925C29C1Ev),
  NSPAIR(_ZN9S21925C29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21925C29[];
extern void _ZN9S21925C29D1Ev();
extern void _ZN9S21925C29D0Ev();
static  VTBL_ENTRY vtc_S21925C29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21925C29[0]),
  (VTBL_ENTRY)&_ZN9S21925C29D1Ev,
  (VTBL_ENTRY)&_ZN9S21925C29D0Ev,
};
extern VTBL_ENTRY _ZTI9S21925C29[];
extern  VTBL_ENTRY _ZTV9S21925C29[];
Class_Descriptor cd_S21925C29 = {  "S21925C29", // class name
  0,0,//no base classes
  &(vtc_S21925C29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(480,320), // object size
  NSPAIRA(_ZTI9S21925C29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21925C29),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C49_nt  {
  void *s21925c49f0[4];
  void  mf21925c49(); // _ZN12S21925C49_nt10mf21925c49Ev
};
//SIG(-1 S21925C49_nt) C1{ m Fp[4]}


void  S21925C49_nt ::mf21925c49(){}

//skip512 S21925C49_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C52_nt  {
  int s21925c52f0[4];
  void  mf21925c52(); // _ZN12S21925C52_nt10mf21925c52Ev
};
//SIG(-1 S21925C52_nt) C1{ m Fi[4]}


void  S21925C52_nt ::mf21925c52(){}

//skip512 S21925C52_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C50  {
  char s21925c50f0;
  int s21925c50f1;
  ::S21925C22_nt s21925c50f2;
  int s21925c50f3[2];
  ::S21925C52_nt s21925c50f4;
  int s21925c50f5;
  void  mf21925c50(); // _ZN9S21925C5010mf21925c50Ev
};
//SIG(-1 S21925C50) C1{ m Fc Fi FC2{ m Fi[3]} Fi[2] FC3{ m Fi[4]} Fi}


void  S21925C50 ::mf21925c50(){}

static void Test_S21925C50()
{
  {
    init_simple_test("S21925C50");
    S21925C50 lv;
    check2(sizeof(lv), 48, "sizeof(S21925C50)");
    check2(__alignof__(lv), 4, "__alignof__(S21925C50)");
    check_field_offset(lv, s21925c50f0, 0, "S21925C50.s21925c50f0");
    check_field_offset(lv, s21925c50f1, 4, "S21925C50.s21925c50f1");
    check_field_offset(lv, s21925c50f2, 8, "S21925C50.s21925c50f2");
    check_field_offset(lv, s21925c50f3, 20, "S21925C50.s21925c50f3");
    check_field_offset(lv, s21925c50f4, 28, "S21925C50.s21925c50f4");
    check_field_offset(lv, s21925c50f5, 44, "S21925C50.s21925c50f5");
  }
}
static Arrange_To_Call_Me vS21925C50(Test_S21925C50, "S21925C50", 48);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C53  {
  int s21925c53f0[5];
  void *s21925c53f1;
  void  mf21925c53(); // _ZN9S21925C5310mf21925c53Ev
};
//SIG(-1 S21925C53) C1{ m Fi[5] Fp}


void  S21925C53 ::mf21925c53(){}

static void Test_S21925C53()
{
  {
    init_simple_test("S21925C53");
    S21925C53 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S21925C53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C53)");
    check_field_offset(lv, s21925c53f0, 0, "S21925C53.s21925c53f0");
    check_field_offset(lv, s21925c53f1, ABISELECT(24,20), "S21925C53.s21925c53f1");
  }
}
static Arrange_To_Call_Me vS21925C53(Test_S21925C53, "S21925C53", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C48  {
  ::S21925C49_nt s21925c48f0;
  int s21925c48f1;
  char s21925c48f2;
  int s21925c48f3[3];
  char s21925c48f4[2];
  int s21925c48f5;
  ::S21925C50 s21925c48f6;
  int s21925c48f7;
  void *s21925c48f8[3];
  int s21925c48f9;
  void *s21925c48f10;
  int s21925c48f11[2];
  void *s21925c48f12[2];
  int s21925c48f13;
  void *s21925c48f14[2];
  int s21925c48f15[3];
  void *s21925c48f16[2];
  int s21925c48f17[8];
  char s21925c48f18;
  ::S21925C53 s21925c48f19;
  void  mf21925c48(); // _ZN9S21925C4810mf21925c48Ev
};
//SIG(-1 S21925C48) C1{ m FC2{ m Fp[4]} Fi Fc Fi[3] Fc[2] Fi FC3{ m Fc Fi FC4{ m Fi[3]} Fi[2] FC5{ m Fi[4]} Fi} Fi Fp[3] Fi Fp Fi[2] Fp[2] Fi Fp[2] Fi[3] Fp[2] Fi[8] Fc FC6{ m Fi[5] Fp}}


void  S21925C48 ::mf21925c48(){}

static void Test_S21925C48()
{
  {
    init_simple_test("S21925C48");
    S21925C48 lv;
    check2(sizeof(lv), ABISELECT(304,224), "sizeof(S21925C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C48)");
    check_field_offset(lv, s21925c48f0, 0, "S21925C48.s21925c48f0");
    check_field_offset(lv, s21925c48f1, ABISELECT(32,16), "S21925C48.s21925c48f1");
    check_field_offset(lv, s21925c48f2, ABISELECT(36,20), "S21925C48.s21925c48f2");
    check_field_offset(lv, s21925c48f3, ABISELECT(40,24), "S21925C48.s21925c48f3");
    check_field_offset(lv, s21925c48f4, ABISELECT(52,36), "S21925C48.s21925c48f4");
    check_field_offset(lv, s21925c48f5, ABISELECT(56,40), "S21925C48.s21925c48f5");
    check_field_offset(lv, s21925c48f6, ABISELECT(60,44), "S21925C48.s21925c48f6");
    check_field_offset(lv, s21925c48f7, ABISELECT(108,92), "S21925C48.s21925c48f7");
    check_field_offset(lv, s21925c48f8, ABISELECT(112,96), "S21925C48.s21925c48f8");
    check_field_offset(lv, s21925c48f9, ABISELECT(136,108), "S21925C48.s21925c48f9");
    check_field_offset(lv, s21925c48f10, ABISELECT(144,112), "S21925C48.s21925c48f10");
    check_field_offset(lv, s21925c48f11, ABISELECT(152,116), "S21925C48.s21925c48f11");
    check_field_offset(lv, s21925c48f12, ABISELECT(160,124), "S21925C48.s21925c48f12");
    check_field_offset(lv, s21925c48f13, ABISELECT(176,132), "S21925C48.s21925c48f13");
    check_field_offset(lv, s21925c48f14, ABISELECT(184,136), "S21925C48.s21925c48f14");
    check_field_offset(lv, s21925c48f15, ABISELECT(200,144), "S21925C48.s21925c48f15");
    check_field_offset(lv, s21925c48f16, ABISELECT(216,156), "S21925C48.s21925c48f16");
    check_field_offset(lv, s21925c48f17, ABISELECT(232,164), "S21925C48.s21925c48f17");
    check_field_offset(lv, s21925c48f18, ABISELECT(264,196), "S21925C48.s21925c48f18");
    check_field_offset(lv, s21925c48f19, ABISELECT(272,200), "S21925C48.s21925c48f19");
  }
}
static Arrange_To_Call_Me vS21925C48(Test_S21925C48, "S21925C48", ABISELECT(304,224));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C54  {
  char s21925c54f0[4];
  int s21925c54f1;
  char s21925c54f2;
  int s21925c54f3;
  short s21925c54f4;
  int s21925c54f5[4];
  __tsi64 s21925c54f6[3];
  int s21925c54f7[8];
  ::S21925C5_nt s21925c54f8;
  int s21925c54f9[2];
};
//SIG(-1 S21925C54) C1{ Fc[4] Fi Fc Fi Fs Fi[4] FL[3] Fi[8] FC2{ Fi[4]} Fi[2]}



static void Test_S21925C54()
{
  {
    init_simple_test("S21925C54");
    S21925C54 lv;
    check2(sizeof(lv), ABISELECT(120,116), "sizeof(S21925C54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C54)");
    check_field_offset(lv, s21925c54f0, 0, "S21925C54.s21925c54f0");
    check_field_offset(lv, s21925c54f1, 4, "S21925C54.s21925c54f1");
    check_field_offset(lv, s21925c54f2, 8, "S21925C54.s21925c54f2");
    check_field_offset(lv, s21925c54f3, 12, "S21925C54.s21925c54f3");
    check_field_offset(lv, s21925c54f4, 16, "S21925C54.s21925c54f4");
    check_field_offset(lv, s21925c54f5, 20, "S21925C54.s21925c54f5");
    check_field_offset(lv, s21925c54f6, ABISELECT(40,36), "S21925C54.s21925c54f6");
    check_field_offset(lv, s21925c54f7, ABISELECT(64,60), "S21925C54.s21925c54f7");
    check_field_offset(lv, s21925c54f8, ABISELECT(96,92), "S21925C54.s21925c54f8");
    check_field_offset(lv, s21925c54f9, ABISELECT(112,108), "S21925C54.s21925c54f9");
  }
}
static Arrange_To_Call_Me vS21925C54(Test_S21925C54, "S21925C54", ABISELECT(120,116));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C56  {
  char s21925c56f0[8];
  int s21925c56f1[2];
  char s21925c56f2[3];
  void  mf21925c56(); // _ZN9S21925C5610mf21925c56Ev
};
//SIG(-1 S21925C56) C1{ m Fc[8] Fi[2] Fc[3]}


void  S21925C56 ::mf21925c56(){}

static void Test_S21925C56()
{
  {
    init_simple_test("S21925C56");
    S21925C56 lv;
    check2(sizeof(lv), 20, "sizeof(S21925C56)");
    check2(__alignof__(lv), 4, "__alignof__(S21925C56)");
    check_field_offset(lv, s21925c56f0, 0, "S21925C56.s21925c56f0");
    check_field_offset(lv, s21925c56f1, 8, "S21925C56.s21925c56f1");
    check_field_offset(lv, s21925c56f2, 16, "S21925C56.s21925c56f2");
  }
}
static Arrange_To_Call_Me vS21925C56(Test_S21925C56, "S21925C56", 20);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C55  {
  char s21925c55f0[3];
  int s21925c55f1;
  char s21925c55f2[3];
  ::S21925C56 s21925c55f3;
  ::S21925C56 s21925c55f4;
  ::S21925C56 s21925c55f5;
};
//SIG(-1 S21925C55) C1{ Fc[3] Fi Fc[3] FC2{ m Fc[8] Fi[2] Fc[3]} FC2 FC2}



static void Test_S21925C55()
{
  {
    init_simple_test("S21925C55");
    S21925C55 lv;
    check2(sizeof(lv), 72, "sizeof(S21925C55)");
    check2(__alignof__(lv), 4, "__alignof__(S21925C55)");
    check_field_offset(lv, s21925c55f0, 0, "S21925C55.s21925c55f0");
    check_field_offset(lv, s21925c55f1, 4, "S21925C55.s21925c55f1");
    check_field_offset(lv, s21925c55f2, 8, "S21925C55.s21925c55f2");
    check_field_offset(lv, s21925c55f3, 12, "S21925C55.s21925c55f3");
    check_field_offset(lv, s21925c55f4, 32, "S21925C55.s21925c55f4");
    check_field_offset(lv, s21925c55f5, 52, "S21925C55.s21925c55f5");
  }
}
static Arrange_To_Call_Me vS21925C55(Test_S21925C55, "S21925C55", 72);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C57  {
  void *s21925c57f0;
  char s21925c57f1;
  long s21925c57f2;
  void  mf21925c57(); // _ZN9S21925C5710mf21925c57Ev
};
//SIG(-1 S21925C57) C1{ m Fp Fc Fl}


void  S21925C57 ::mf21925c57(){}

static void Test_S21925C57()
{
  {
    init_simple_test("S21925C57");
    S21925C57 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S21925C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C57)");
    check_field_offset(lv, s21925c57f0, 0, "S21925C57.s21925c57f0");
    check_field_offset(lv, s21925c57f1, ABISELECT(8,4), "S21925C57.s21925c57f1");
    check_field_offset(lv, s21925c57f2, ABISELECT(16,8), "S21925C57.s21925c57f2");
  }
}
static Arrange_To_Call_Me vS21925C57(Test_S21925C57, "S21925C57", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21925C1  {
  void *s21925c1f0;
  int s21925c1f1[3];
  ::S21925C2_nt s21925c1f2;
  ::S21925C2_nt s21925c1f3;
  ::S21925C4_nt s21925c1f4;
  ::S21925C6 s21925c1f5;
  void *s21925c1f6[2];
  int s21925c1f7;
  void *s21925c1f8;
  int s21925c1f9;
  void *s21925c1f10[3];
  ::S21925C7 s21925c1f11;
  ::S21925C29 s21925c1f12;
  void *s21925c1f13;
  char s21925c1f14;
  void *s21925c1f15;
  char s21925c1f16;
  void *s21925c1f17;
  char s21925c1f18;
  void *s21925c1f19;
  char s21925c1f20;
  ::S21925C48 s21925c1f21;
  int s21925c1f22;
  ::S21925C54 s21925c1f23;
  ::S21925C54 s21925c1f24[8];
  ::S21925C54 s21925c1f25[2];
  ::S21925C55 s21925c1f26;
  char s21925c1f27;
  int s21925c1f28;
  char s21925c1f29;
  void *s21925c1f30;
  char s21925c1f31[2];
  ::S21925C57 s21925c1f32;
  char s21925c1f33;
  virtual  ~S21925C1(); // _ZN8S21925C1D1Ev
  virtual void  v1(); // _ZN8S21925C12v1Ev
  S21925C1(); // tgen
};
//SIG(1 S21925C1) C1{ vd v1 Fp Fi[3] FC2{ m FC3{ Fl[4]}} FC2 FC4{ m Fp FC5{ Fi[4]}} FC6{ vd m Fp[2] Fi} Fp[2] Fi Fp Fi Fp[3] FC7{ BC8{ v33 v34 v35 v36 v37 v38 v39} vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fi[2] Fp FC9{ m Fp[3]} FC10{ BC8 vd v40 v41 v42 v43 v44 v45 v46 Fp FC11{ BC12{ vd v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 Fp Fi} vd v47 v48 v49 v50} FC13{ BC12 vd v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94} FC14{ BC12 vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112} FC15{ BC12 vd v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133} FC16{ BC12 vd v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155} FC15 FC14 FC17{ BC12 vd v156 v157 v158 v159 v160 v161} Fp[4] FC18{ m Fc[6] Fp Fi[2] FC19{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc} Fi[2]} FC20{ m Fi[3]} FC21{ m Fc} FC22{ m Fp Fi[3] FC19 FC23{ vd m Fi[2] FL Fi[4]} Fi[6] FC5 Fi[4]} Fp Fi[3]} FC24{ vd m Fp Fi Fp[9] Fi} FC25{ FL[2] Fi[6]}} FC26{ vd m Fi[3] Fp FC27{ Fp[3]} Fp Fi[2] Fp FC28{ vd v162 v163 v164 v165 FC29{ vd m Fc Fp Fi[4] Fc[2] FC30{ BC31{ m Fp Fi FC32{ m} FC32}} FC30 FC33{ m Fp Fi FC34{ m} FC34} Fp Fc[2] Fi[2] FC35{ m Fp[2]} FC2 FC4 FC2} FC2 Fc} FC36{ vd v166 v167 v168 v169 v170 FC37{ m Fi Fc FL Fi}[5]}} Fp Fc Fp Fc Fp Fc Fp Fc FC38{ m FC39{ m Fp[4]} Fi Fc Fi[3] Fc[2] Fi FC40{ m Fc Fi FC20 Fi[2] FC41{ m Fi[4]} Fi} Fi Fp[3] Fi Fp Fi[2] Fp[2] Fi Fp[2] Fi[3] Fp[2] Fi[8] Fc FC42{ m Fi[5] Fp}} Fi FC43{ Fc[4] Fi Fc Fi Fs Fi[4] FL[3] Fi[8] FC5 Fi[2]} FC43[8] FC43[2] FC44{ Fc[3] Fi Fc[3] FC45{ m Fc[8] Fi[2] Fc[3]} FC45 FC45} Fc Fi Fc Fp Fc[2] FC46{ m Fp Fc Fl} Fc}


 S21925C1 ::~S21925C1(){ note_dtor("S21925C1", this);}
void  S21925C1 ::v1(){vfunc_called(this, "_ZN8S21925C12v1Ev");}
S21925C1 ::S21925C1(){ note_ctor("S21925C1", this);} // tgen

static void Test_S21925C1()
{
  extern Class_Descriptor cd_S21925C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(935,1696)];
    init_test(&cd_S21925C1, buf);
    S21925C1 *dp, &lv = *(dp=new (buf) S21925C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7472,6780), "sizeof(S21925C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21925C1)");
    check_field_offset(lv, s21925c1f0, ABISELECT(8,4), "S21925C1.s21925c1f0");
    check_field_offset(lv, s21925c1f1, ABISELECT(16,8), "S21925C1.s21925c1f1");
    check_field_offset(lv, s21925c1f2, ABISELECT(32,20), "S21925C1.s21925c1f2");
    check_field_offset(lv, s21925c1f3, ABISELECT(64,36), "S21925C1.s21925c1f3");
    check_field_offset(lv, s21925c1f4, ABISELECT(96,52), "S21925C1.s21925c1f4");
    check_field_offset(lv, s21925c1f5, ABISELECT(120,72), "S21925C1.s21925c1f5");
    check_field_offset(lv, s21925c1f6, ABISELECT(152,88), "S21925C1.s21925c1f6");
    check_field_offset(lv, s21925c1f7, ABISELECT(168,96), "S21925C1.s21925c1f7");
    check_field_offset(lv, s21925c1f8, ABISELECT(176,100), "S21925C1.s21925c1f8");
    check_field_offset(lv, s21925c1f9, ABISELECT(184,104), "S21925C1.s21925c1f9");
    check_field_offset(lv, s21925c1f10, ABISELECT(192,108), "S21925C1.s21925c1f10");
    check_field_offset(lv, s21925c1f11, ABISELECT(216,120), "S21925C1.s21925c1f11");
    check_field_offset(lv, s21925c1f12, ABISELECT(5160,4816), "S21925C1.s21925c1f12");
    check_field_offset(lv, s21925c1f13, ABISELECT(5640,5136), "S21925C1.s21925c1f13");
    check_field_offset(lv, s21925c1f14, ABISELECT(5648,5140), "S21925C1.s21925c1f14");
    check_field_offset(lv, s21925c1f15, ABISELECT(5656,5144), "S21925C1.s21925c1f15");
    check_field_offset(lv, s21925c1f16, ABISELECT(5664,5148), "S21925C1.s21925c1f16");
    check_field_offset(lv, s21925c1f17, ABISELECT(5672,5152), "S21925C1.s21925c1f17");
    check_field_offset(lv, s21925c1f18, ABISELECT(5680,5156), "S21925C1.s21925c1f18");
    check_field_offset(lv, s21925c1f19, ABISELECT(5688,5160), "S21925C1.s21925c1f19");
    check_field_offset(lv, s21925c1f20, ABISELECT(5696,5164), "S21925C1.s21925c1f20");
    check_field_offset(lv, s21925c1f21, ABISELECT(5704,5168), "S21925C1.s21925c1f21");
    check_field_offset(lv, s21925c1f22, ABISELECT(6008,5392), "S21925C1.s21925c1f22");
    check_field_offset(lv, s21925c1f23, ABISELECT(6016,5396), "S21925C1.s21925c1f23");
    check_field_offset(lv, s21925c1f24, ABISELECT(6136,5512), "S21925C1.s21925c1f24");
    check_field_offset(lv, s21925c1f25, ABISELECT(7096,6440), "S21925C1.s21925c1f25");
    check_field_offset(lv, s21925c1f26, ABISELECT(7336,6672), "S21925C1.s21925c1f26");
    check_field_offset(lv, s21925c1f27, ABISELECT(7408,6744), "S21925C1.s21925c1f27");
    check_field_offset(lv, s21925c1f28, ABISELECT(7412,6748), "S21925C1.s21925c1f28");
    check_field_offset(lv, s21925c1f29, ABISELECT(7416,6752), "S21925C1.s21925c1f29");
    check_field_offset(lv, s21925c1f30, ABISELECT(7424,6756), "S21925C1.s21925c1f30");
    check_field_offset(lv, s21925c1f31, ABISELECT(7432,6760), "S21925C1.s21925c1f31");
    check_field_offset(lv, s21925c1f32, ABISELECT(7440,6764), "S21925C1.s21925c1f32");
    check_field_offset(lv, s21925c1f33, ABISELECT(7464,6776), "S21925C1.s21925c1f33");
    test_class_info(&lv, &cd_S21925C1);
    dp->~S21925C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21925C1(Test_S21925C1, "S21925C1", ABISELECT(7472,6780));

#else // __cplusplus

extern void _ZN8S21925C1C1Ev();
extern void _ZN8S21925C1D1Ev();
Name_Map name_map_S21925C1[] = {
  NSPAIR(_ZN8S21925C1C1Ev),
  NSPAIR(_ZN8S21925C1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S21925C1[];
extern void _ZN8S21925C1D1Ev();
extern void _ZN8S21925C1D0Ev();
extern void _ZN8S21925C12v1Ev();
static  VTBL_ENTRY vtc_S21925C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21925C1[0]),
  (VTBL_ENTRY)&_ZN8S21925C1D1Ev,
  (VTBL_ENTRY)&_ZN8S21925C1D0Ev,
  (VTBL_ENTRY)&_ZN8S21925C12v1Ev,
};
extern VTBL_ENTRY _ZTI8S21925C1[];
extern  VTBL_ENTRY _ZTV8S21925C1[];
Class_Descriptor cd_S21925C1 = {  "S21925C1", // class name
  0,0,//no base classes
  &(vtc_S21925C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7472,6780), // object size
  NSPAIRA(_ZTI8S21925C1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S21925C1),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21926C3_nt  {
  __tsi64 s21926c3f0[4];
};
//SIG(-1 S21926C3_nt) C1{ FL[4]}



//skip512 S21926C3_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21926C2_nt  {
  ::S21926C3_nt s21926c2f0;
  void  mf21926c2(); // _ZN11S21926C2_nt9mf21926c2Ev
};
//SIG(-1 S21926C2_nt) C1{ m FC2{ FL[4]}}


void  S21926C2_nt ::mf21926c2(){}

//skip512 S21926C2_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21926C37  : S21925C41 {
};
//SIG(-1 S21926C37) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



static void Test_S21926C37()
{
  extern Class_Descriptor cd_S21926C37;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S21926C37, buf);
    S21926C37 &lv = *(new (buf) S21926C37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S21926C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21926C37)");
    check_base_class_offset(lv, (S21925C41*), 0, "S21926C37");
    test_class_info(&lv, &cd_S21926C37);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21926C37(Test_S21926C37, "S21926C37", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S21925C41;
static Base_Class bases_S21926C37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21925C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S21926C37 = {  "S21926C37", // class name
  bases_S21926C37, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21926C32  {
  char s21926c32f0;
  void *s21926c32f1;
  int s21926c32f2[4];
  char s21926c32f3[2];
  ::S21925C33_nt s21926c32f4;
  ::S21926C37 s21926c32f5;
  ::S21925C34_nt s21926c32f6;
  void *s21926c32f7;
  char s21926c32f8[2];
  int s21926c32f9[2];
  ::S21925C44_nt s21926c32f10;
  ::S21926C2_nt s21926c32f11;
  ::S21925C4_nt s21926c32f12;
  ::S21926C2_nt s21926c32f13;
  void  mf21926c32(); // _ZN9S21926C3210mf21926c32Ev
  virtual  ~S21926C32(); // _ZN9S21926C32D1Ev
  S21926C32(); // tgen
};
//SIG(-1 S21926C32) C1{ vd m Fc Fp Fi[4] Fc[2] FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC3 Fp Fc[2] Fi[2] FC8{ m Fp[2]} FC9{ m FC10{ FL[4]}} FC11{ m Fp FC12{ Fi[4]}} FC9}


void  S21926C32 ::mf21926c32(){}
 S21926C32 ::~S21926C32(){ note_dtor("S21926C32", this);}
S21926C32 ::S21926C32(){ note_ctor("S21926C32", this);} // tgen

static void Test_S21926C32()
{
  extern Class_Descriptor cd_S21926C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,45)];
    init_test(&cd_S21926C32, buf);
    S21926C32 *dp, &lv = *(dp=new (buf) S21926C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,176), "sizeof(S21926C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21926C32)");
    check_field_offset(lv, s21926c32f0, ABISELECT(8,4), "S21926C32.s21926c32f0");
    check_field_offset(lv, s21926c32f1, ABISELECT(16,8), "S21926C32.s21926c32f1");
    check_field_offset(lv, s21926c32f2, ABISELECT(24,12), "S21926C32.s21926c32f2");
    check_field_offset(lv, s21926c32f3, ABISELECT(40,28), "S21926C32.s21926c32f3");
    check_field_offset(lv, s21926c32f4, ABISELECT(48,32), "S21926C32.s21926c32f4");
    check_field_offset(lv, s21926c32f5, ABISELECT(64,44), "S21926C32.s21926c32f5");
    check_field_offset(lv, s21926c32f6, ABISELECT(80,56), "S21926C32.s21926c32f6");
    check_field_offset(lv, s21926c32f7, ABISELECT(96,68), "S21926C32.s21926c32f7");
    check_field_offset(lv, s21926c32f8, ABISELECT(104,72), "S21926C32.s21926c32f8");
    check_field_offset(lv, s21926c32f9, ABISELECT(108,76), "S21926C32.s21926c32f9");
    check_field_offset(lv, s21926c32f10, ABISELECT(120,84), "S21926C32.s21926c32f10");
    check_field_offset(lv, s21926c32f11, ABISELECT(136,92), "S21926C32.s21926c32f11");
    check_field_offset(lv, s21926c32f12, ABISELECT(168,124), "S21926C32.s21926c32f12");
    check_field_offset(lv, s21926c32f13, ABISELECT(192,144), "S21926C32.s21926c32f13");
    test_class_info(&lv, &cd_S21926C32);
    dp->~S21926C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21926C32(Test_S21926C32, "S21926C32", ABISELECT(224,176));

#else // __cplusplus

extern void _ZN9S21926C32C1Ev();
extern void _ZN9S21926C32D1Ev();
Name_Map name_map_S21926C32[] = {
  NSPAIR(_ZN9S21926C32C1Ev),
  NSPAIR(_ZN9S21926C32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21926C32[];
extern void _ZN9S21926C32D1Ev();
extern void _ZN9S21926C32D0Ev();
static  VTBL_ENTRY vtc_S21926C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21926C32[0]),
  (VTBL_ENTRY)&_ZN9S21926C32D1Ev,
  (VTBL_ENTRY)&_ZN9S21926C32D0Ev,
};
extern VTBL_ENTRY _ZTI9S21926C32[];
extern  VTBL_ENTRY _ZTV9S21926C32[];
Class_Descriptor cd_S21926C32 = {  "S21926C32", // class name
  0,0,//no base classes
  &(vtc_S21926C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,176), // object size
  NSPAIRA(_ZTI9S21926C32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21926C32),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21926C31  {
  ::S21926C32 s21926c31f0;
  ::S21926C2_nt s21926c31f1;
  char s21926c31f2;
  virtual  ~S21926C31(); // _ZN9S21926C31D1Ev
  virtual void  v201(); // _ZN9S21926C314v201Ev
  virtual void  v202(); // _ZN9S21926C314v202Ev
  virtual void  v203(); // _ZN9S21926C314v203Ev
  virtual void  v204(); // _ZN9S21926C314v204Ev
  S21926C31(); // tgen
};
//SIG(-1 S21926C31) C1{ vd v1 v2 v3 v4 FC2{ vd m Fc Fp Fi[4] Fc[2] FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC6{ BC7{ m Fp Fi FC8{ m} FC8}} FC4 Fp Fc[2] Fi[2] FC9{ m Fp[2]} FC10{ m FC11{ FL[4]}} FC12{ m Fp FC13{ Fi[4]}} FC10} FC10 Fc}


 S21926C31 ::~S21926C31(){ note_dtor("S21926C31", this);}
void  S21926C31 ::v201(){vfunc_called(this, "_ZN9S21926C314v201Ev");}
void  S21926C31 ::v202(){vfunc_called(this, "_ZN9S21926C314v202Ev");}
void  S21926C31 ::v203(){vfunc_called(this, "_ZN9S21926C314v203Ev");}
void  S21926C31 ::v204(){vfunc_called(this, "_ZN9S21926C314v204Ev");}
S21926C31 ::S21926C31(){ note_ctor("S21926C31", this);} // tgen

static void Test_S21926C31()
{
  extern Class_Descriptor cd_S21926C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,55)];
    init_test(&cd_S21926C31, buf);
    S21926C31 *dp, &lv = *(dp=new (buf) S21926C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,216), "sizeof(S21926C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21926C31)");
    check_field_offset(lv, s21926c31f0, ABISELECT(8,4), "S21926C31.s21926c31f0");
    check_field_offset(lv, s21926c31f1, ABISELECT(232,180), "S21926C31.s21926c31f1");
    check_field_offset(lv, s21926c31f2, ABISELECT(264,212), "S21926C31.s21926c31f2");
    test_class_info(&lv, &cd_S21926C31);
    dp->~S21926C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21926C31(Test_S21926C31, "S21926C31", ABISELECT(272,216));

#else // __cplusplus

extern void _ZN9S21926C31C1Ev();
extern void _ZN9S21926C31D1Ev();
Name_Map name_map_S21926C31[] = {
  NSPAIR(_ZN9S21926C31C1Ev),
  NSPAIR(_ZN9S21926C31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21926C31[];
extern void _ZN9S21926C31D1Ev();
extern void _ZN9S21926C31D0Ev();
extern void _ZN9S21926C314v201Ev();
extern void _ZN9S21926C314v202Ev();
extern void _ZN9S21926C314v203Ev();
extern void _ZN9S21926C314v204Ev();
static  VTBL_ENTRY vtc_S21926C31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21926C31[0]),
  (VTBL_ENTRY)&_ZN9S21926C31D1Ev,
  (VTBL_ENTRY)&_ZN9S21926C31D0Ev,
  (VTBL_ENTRY)&_ZN9S21926C314v201Ev,
  (VTBL_ENTRY)&_ZN9S21926C314v202Ev,
  (VTBL_ENTRY)&_ZN9S21926C314v203Ev,
  (VTBL_ENTRY)&_ZN9S21926C314v204Ev,
};
extern VTBL_ENTRY _ZTI9S21926C31[];
extern  VTBL_ENTRY _ZTV9S21926C31[];
Class_Descriptor cd_S21926C31 = {  "S21926C31", // class name
  0,0,//no base classes
  &(vtc_S21926C31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,216), // object size
  NSPAIRA(_ZTI9S21926C31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21926C31),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21926C29  {
  int s21926c29f0[3];
  void *s21926c29f1;
  ::S21925C30_nt s21926c29f2;
  void *s21926c29f3;
  int s21926c29f4[2];
  void *s21926c29f5;
  ::S21926C31 s21926c29f6;
  ::S21925C46 s21926c29f7;
  void  mf21926c29(); // _ZN9S21926C2910mf21926c29Ev
  virtual  ~S21926C29(); // _ZN9S21926C29D1Ev
  S21926C29(); // tgen
};
//SIG(-1 S21926C29) C1{ vd m Fi[3] Fp FC2{ Fp[3]} Fp Fi[2] Fp FC3{ vd v1 v2 v3 v4 FC4{ vd m Fc Fp Fi[4] Fc[2] FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ BC9{ m Fp Fi FC10{ m} FC10}} FC6 Fp Fc[2] Fi[2] FC11{ m Fp[2]} FC12{ m FC13{ FL[4]}} FC14{ m Fp FC15{ Fi[4]}} FC12} FC12 Fc} FC16{ vd v5 v6 v7 v8 v9 FC17{ m Fi Fc FL Fi}[5]}}


void  S21926C29 ::mf21926c29(){}
 S21926C29 ::~S21926C29(){ note_dtor("S21926C29", this);}
S21926C29 ::S21926C29(){ note_ctor("S21926C29", this);} // tgen

static void Test_S21926C29()
{
  extern Class_Descriptor cd_S21926C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(61,93)];
    init_test(&cd_S21926C29, buf);
    S21926C29 *dp, &lv = *(dp=new (buf) S21926C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(480,368), "sizeof(S21926C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21926C29)");
    check_field_offset(lv, s21926c29f0, ABISELECT(8,4), "S21926C29.s21926c29f0");
    check_field_offset(lv, s21926c29f1, ABISELECT(24,16), "S21926C29.s21926c29f1");
    check_field_offset(lv, s21926c29f2, ABISELECT(32,20), "S21926C29.s21926c29f2");
    check_field_offset(lv, s21926c29f3, ABISELECT(56,32), "S21926C29.s21926c29f3");
    check_field_offset(lv, s21926c29f4, ABISELECT(64,36), "S21926C29.s21926c29f4");
    check_field_offset(lv, s21926c29f5, ABISELECT(72,44), "S21926C29.s21926c29f5");
    check_field_offset(lv, s21926c29f6, ABISELECT(80,48), "S21926C29.s21926c29f6");
    check_field_offset(lv, s21926c29f7, ABISELECT(352,264), "S21926C29.s21926c29f7");
    test_class_info(&lv, &cd_S21926C29);
    dp->~S21926C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21926C29(Test_S21926C29, "S21926C29", ABISELECT(480,368));

#else // __cplusplus

extern void _ZN9S21926C29C1Ev();
extern void _ZN9S21926C29D1Ev();
Name_Map name_map_S21926C29[] = {
  NSPAIR(_ZN9S21926C29C1Ev),
  NSPAIR(_ZN9S21926C29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21926C29[];
extern void _ZN9S21926C29D1Ev();
extern void _ZN9S21926C29D0Ev();
static  VTBL_ENTRY vtc_S21926C29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21926C29[0]),
  (VTBL_ENTRY)&_ZN9S21926C29D1Ev,
  (VTBL_ENTRY)&_ZN9S21926C29D0Ev,
};
extern VTBL_ENTRY _ZTI9S21926C29[];
extern  VTBL_ENTRY _ZTV9S21926C29[];
Class_Descriptor cd_S21926C29 = {  "S21926C29", // class name
  0,0,//no base classes
  &(vtc_S21926C29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(480,368), // object size
  NSPAIRA(_ZTI9S21926C29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21926C29),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21926C57  {
  void *s21926c57f0;
  char s21926c57f1;
  __tsi64 s21926c57f2;
  void  mf21926c57(); // _ZN9S21926C5710mf21926c57Ev
};
//SIG(-1 S21926C57) C1{ m Fp Fc FL}


void  S21926C57 ::mf21926c57(){}

static void Test_S21926C57()
{
  {
    init_simple_test("S21926C57");
    S21926C57 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S21926C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21926C57)");
    check_field_offset(lv, s21926c57f0, 0, "S21926C57.s21926c57f0");
    check_field_offset(lv, s21926c57f1, ABISELECT(8,4), "S21926C57.s21926c57f1");
    check_field_offset(lv, s21926c57f2, ABISELECT(16,8), "S21926C57.s21926c57f2");
  }
}
static Arrange_To_Call_Me vS21926C57(Test_S21926C57, "S21926C57", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21926C1  {
  void *s21926c1f0;
  int s21926c1f1[3];
  ::S21926C2_nt s21926c1f2;
  ::S21926C2_nt s21926c1f3;
  ::S21925C4_nt s21926c1f4;
  ::S21925C6 s21926c1f5;
  void *s21926c1f6[2];
  int s21926c1f7;
  void *s21926c1f8;
  int s21926c1f9;
  void *s21926c1f10[3];
  ::S21925C7 s21926c1f11;
  ::S21926C29 s21926c1f12;
  void *s21926c1f13;
  char s21926c1f14;
  void *s21926c1f15;
  char s21926c1f16;
  void *s21926c1f17;
  char s21926c1f18;
  void *s21926c1f19;
  char s21926c1f20;
  ::S21925C48 s21926c1f21;
  int s21926c1f22;
  ::S21925C54 s21926c1f23;
  ::S21925C54 s21926c1f24[8];
  ::S21925C54 s21926c1f25[2];
  ::S21925C55 s21926c1f26;
  char s21926c1f27;
  int s21926c1f28;
  char s21926c1f29;
  void *s21926c1f30;
  char s21926c1f31[2];
  ::S21926C57 s21926c1f32;
  char s21926c1f33;
  virtual  ~S21926C1(); // _ZN8S21926C1D1Ev
  virtual void  v1(); // _ZN8S21926C12v1Ev
  S21926C1(); // tgen
};
//SIG(1 S21926C1) C1{ vd v1 Fp Fi[3] FC2{ m FC3{ FL[4]}} FC2 FC4{ m Fp FC5{ Fi[4]}} FC6{ vd m Fp[2] Fi} Fp[2] Fi Fp Fi Fp[3] FC7{ BC8{ v33 v34 v35 v36 v37 v38 v39} vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fi[2] Fp FC9{ m Fp[3]} FC10{ BC8 vd v40 v41 v42 v43 v44 v45 v46 Fp FC11{ BC12{ vd v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 Fp Fi} vd v47 v48 v49 v50} FC13{ BC12 vd v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94} FC14{ BC12 vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112} FC15{ BC12 vd v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133} FC16{ BC12 vd v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155} FC15 FC14 FC17{ BC12 vd v156 v157 v158 v159 v160 v161} Fp[4] FC18{ m Fc[6] Fp Fi[2] FC19{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc} Fi[2]} FC20{ m Fi[3]} FC21{ m Fc} FC22{ m Fp Fi[3] FC19 FC23{ vd m Fi[2] FL Fi[4]} Fi[6] FC5 Fi[4]} Fp Fi[3]} FC24{ vd m Fp Fi Fp[9] Fi} FC25{ FL[2] Fi[6]}} FC26{ vd m Fi[3] Fp FC27{ Fp[3]} Fp Fi[2] Fp FC28{ vd v162 v163 v164 v165 FC29{ vd m Fc Fp Fi[4] Fc[2] FC30{ BC31{ m Fp Fi FC32{ m} FC32}} FC33{ BC34{ m Fp Fi FC35{ m} FC35}} FC31 Fp Fc[2] Fi[2] FC36{ m Fp[2]} FC2 FC4 FC2} FC2 Fc} FC37{ vd v166 v167 v168 v169 v170 FC38{ m Fi Fc FL Fi}[5]}} Fp Fc Fp Fc Fp Fc Fp Fc FC39{ m FC40{ m Fp[4]} Fi Fc Fi[3] Fc[2] Fi FC41{ m Fc Fi FC20 Fi[2] FC42{ m Fi[4]} Fi} Fi Fp[3] Fi Fp Fi[2] Fp[2] Fi Fp[2] Fi[3] Fp[2] Fi[8] Fc FC43{ m Fi[5] Fp}} Fi FC44{ Fc[4] Fi Fc Fi Fs Fi[4] FL[3] Fi[8] FC5 Fi[2]} FC44[8] FC44[2] FC45{ Fc[3] Fi Fc[3] FC46{ m Fc[8] Fi[2] Fc[3]} FC46 FC46} Fc Fi Fc Fp Fc[2] FC47{ m Fp Fc FL} Fc}


 S21926C1 ::~S21926C1(){ note_dtor("S21926C1", this);}
void  S21926C1 ::v1(){vfunc_called(this, "_ZN8S21926C12v1Ev");}
S21926C1 ::S21926C1(){ note_ctor("S21926C1", this);} // tgen

static void Test_S21926C1()
{
  extern Class_Descriptor cd_S21926C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(935,1717)];
    init_test(&cd_S21926C1, buf);
    S21926C1 *dp, &lv = *(dp=new (buf) S21926C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7472,6864), "sizeof(S21926C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21926C1)");
    check_field_offset(lv, s21926c1f0, ABISELECT(8,4), "S21926C1.s21926c1f0");
    check_field_offset(lv, s21926c1f1, ABISELECT(16,8), "S21926C1.s21926c1f1");
    check_field_offset(lv, s21926c1f2, ABISELECT(32,20), "S21926C1.s21926c1f2");
    check_field_offset(lv, s21926c1f3, ABISELECT(64,52), "S21926C1.s21926c1f3");
    check_field_offset(lv, s21926c1f4, ABISELECT(96,84), "S21926C1.s21926c1f4");
    check_field_offset(lv, s21926c1f5, ABISELECT(120,104), "S21926C1.s21926c1f5");
    check_field_offset(lv, s21926c1f6, ABISELECT(152,120), "S21926C1.s21926c1f6");
    check_field_offset(lv, s21926c1f7, ABISELECT(168,128), "S21926C1.s21926c1f7");
    check_field_offset(lv, s21926c1f8, ABISELECT(176,132), "S21926C1.s21926c1f8");
    check_field_offset(lv, s21926c1f9, ABISELECT(184,136), "S21926C1.s21926c1f9");
    check_field_offset(lv, s21926c1f10, ABISELECT(192,140), "S21926C1.s21926c1f10");
    check_field_offset(lv, s21926c1f11, ABISELECT(216,152), "S21926C1.s21926c1f11");
    check_field_offset(lv, s21926c1f12, ABISELECT(5160,4848), "S21926C1.s21926c1f12");
    check_field_offset(lv, s21926c1f13, ABISELECT(5640,5216), "S21926C1.s21926c1f13");
    check_field_offset(lv, s21926c1f14, ABISELECT(5648,5220), "S21926C1.s21926c1f14");
    check_field_offset(lv, s21926c1f15, ABISELECT(5656,5224), "S21926C1.s21926c1f15");
    check_field_offset(lv, s21926c1f16, ABISELECT(5664,5228), "S21926C1.s21926c1f16");
    check_field_offset(lv, s21926c1f17, ABISELECT(5672,5232), "S21926C1.s21926c1f17");
    check_field_offset(lv, s21926c1f18, ABISELECT(5680,5236), "S21926C1.s21926c1f18");
    check_field_offset(lv, s21926c1f19, ABISELECT(5688,5240), "S21926C1.s21926c1f19");
    check_field_offset(lv, s21926c1f20, ABISELECT(5696,5244), "S21926C1.s21926c1f20");
    check_field_offset(lv, s21926c1f21, ABISELECT(5704,5248), "S21926C1.s21926c1f21");
    check_field_offset(lv, s21926c1f22, ABISELECT(6008,5472), "S21926C1.s21926c1f22");
    check_field_offset(lv, s21926c1f23, ABISELECT(6016,5476), "S21926C1.s21926c1f23");
    check_field_offset(lv, s21926c1f24, ABISELECT(6136,5592), "S21926C1.s21926c1f24");
    check_field_offset(lv, s21926c1f25, ABISELECT(7096,6520), "S21926C1.s21926c1f25");
    check_field_offset(lv, s21926c1f26, ABISELECT(7336,6752), "S21926C1.s21926c1f26");
    check_field_offset(lv, s21926c1f27, ABISELECT(7408,6824), "S21926C1.s21926c1f27");
    check_field_offset(lv, s21926c1f28, ABISELECT(7412,6828), "S21926C1.s21926c1f28");
    check_field_offset(lv, s21926c1f29, ABISELECT(7416,6832), "S21926C1.s21926c1f29");
    check_field_offset(lv, s21926c1f30, ABISELECT(7424,6836), "S21926C1.s21926c1f30");
    check_field_offset(lv, s21926c1f31, ABISELECT(7432,6840), "S21926C1.s21926c1f31");
    check_field_offset(lv, s21926c1f32, ABISELECT(7440,6844), "S21926C1.s21926c1f32");
    check_field_offset(lv, s21926c1f33, ABISELECT(7464,6860), "S21926C1.s21926c1f33");
    test_class_info(&lv, &cd_S21926C1);
    dp->~S21926C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21926C1(Test_S21926C1, "S21926C1", ABISELECT(7472,6864));

#else // __cplusplus

extern void _ZN8S21926C1C1Ev();
extern void _ZN8S21926C1D1Ev();
Name_Map name_map_S21926C1[] = {
  NSPAIR(_ZN8S21926C1C1Ev),
  NSPAIR(_ZN8S21926C1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S21926C1[];
extern void _ZN8S21926C1D1Ev();
extern void _ZN8S21926C1D0Ev();
extern void _ZN8S21926C12v1Ev();
static  VTBL_ENTRY vtc_S21926C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21926C1[0]),
  (VTBL_ENTRY)&_ZN8S21926C1D1Ev,
  (VTBL_ENTRY)&_ZN8S21926C1D0Ev,
  (VTBL_ENTRY)&_ZN8S21926C12v1Ev,
};
extern VTBL_ENTRY _ZTI8S21926C1[];
extern  VTBL_ENTRY _ZTV8S21926C1[];
Class_Descriptor cd_S21926C1 = {  "S21926C1", // class name
  0,0,//no base classes
  &(vtc_S21926C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7472,6864), // object size
  NSPAIRA(_ZTI8S21926C1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S21926C1),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21927C2_nt  {
  __tsi64 s21927c2f0[4];
  void  mf21927c2(); // _ZN11S21927C2_nt9mf21927c2Ev
};
//SIG(-1 S21927C2_nt) C1{ m FL[4]}


void  S21927C2_nt ::mf21927c2(){}

//skip512 S21927C2_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21927C31  {
  char s21927c31f0;
  void *s21927c31f1;
  int s21927c31f2[4];
  char s21927c31f3[2];
  ::S21926C37 s21927c31f4;
  ::S21925C33_nt s21927c31f5;
  ::S21925C41 s21927c31f6;
  void *s21927c31f7;
  char s21927c31f8[2];
  int s21927c31f9[2];
  ::S21925C44_nt s21927c31f10;
  ::S21927C2_nt s21927c31f11;
  ::S21925C4_nt s21927c31f12;
  ::S21927C2_nt s21927c31f13;
  void  mf21927c31(); // _ZN9S21927C3110mf21927c31Ev
  virtual  ~S21927C31(); // _ZN9S21927C31D1Ev
  S21927C31(); // tgen
};
//SIG(-1 S21927C31) C1{ vd m Fc Fp Fi[4] Fc[2] FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC3 Fp Fc[2] Fi[2] FC8{ m Fp[2]} FC9{ m FL[4]} FC10{ m Fp FC11{ Fi[4]}} FC9}


void  S21927C31 ::mf21927c31(){}
 S21927C31 ::~S21927C31(){ note_dtor("S21927C31", this);}
S21927C31 ::S21927C31(){ note_ctor("S21927C31", this);} // tgen

static void Test_S21927C31()
{
  extern Class_Descriptor cd_S21927C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,45)];
    init_test(&cd_S21927C31, buf);
    S21927C31 *dp, &lv = *(dp=new (buf) S21927C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,176), "sizeof(S21927C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21927C31)");
    check_field_offset(lv, s21927c31f0, ABISELECT(8,4), "S21927C31.s21927c31f0");
    check_field_offset(lv, s21927c31f1, ABISELECT(16,8), "S21927C31.s21927c31f1");
    check_field_offset(lv, s21927c31f2, ABISELECT(24,12), "S21927C31.s21927c31f2");
    check_field_offset(lv, s21927c31f3, ABISELECT(40,28), "S21927C31.s21927c31f3");
    check_field_offset(lv, s21927c31f4, ABISELECT(48,32), "S21927C31.s21927c31f4");
    check_field_offset(lv, s21927c31f5, ABISELECT(64,44), "S21927C31.s21927c31f5");
    check_field_offset(lv, s21927c31f6, ABISELECT(80,56), "S21927C31.s21927c31f6");
    check_field_offset(lv, s21927c31f7, ABISELECT(96,68), "S21927C31.s21927c31f7");
    check_field_offset(lv, s21927c31f8, ABISELECT(104,72), "S21927C31.s21927c31f8");
    check_field_offset(lv, s21927c31f9, ABISELECT(108,76), "S21927C31.s21927c31f9");
    check_field_offset(lv, s21927c31f10, ABISELECT(120,84), "S21927C31.s21927c31f10");
    check_field_offset(lv, s21927c31f11, ABISELECT(136,92), "S21927C31.s21927c31f11");
    check_field_offset(lv, s21927c31f12, ABISELECT(168,124), "S21927C31.s21927c31f12");
    check_field_offset(lv, s21927c31f13, ABISELECT(192,144), "S21927C31.s21927c31f13");
    test_class_info(&lv, &cd_S21927C31);
    dp->~S21927C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21927C31(Test_S21927C31, "S21927C31", ABISELECT(224,176));

#else // __cplusplus

extern void _ZN9S21927C31C1Ev();
extern void _ZN9S21927C31D1Ev();
Name_Map name_map_S21927C31[] = {
  NSPAIR(_ZN9S21927C31C1Ev),
  NSPAIR(_ZN9S21927C31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21927C31[];
extern void _ZN9S21927C31D1Ev();
extern void _ZN9S21927C31D0Ev();
static  VTBL_ENTRY vtc_S21927C31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21927C31[0]),
  (VTBL_ENTRY)&_ZN9S21927C31D1Ev,
  (VTBL_ENTRY)&_ZN9S21927C31D0Ev,
};
extern VTBL_ENTRY _ZTI9S21927C31[];
extern  VTBL_ENTRY _ZTV9S21927C31[];
Class_Descriptor cd_S21927C31 = {  "S21927C31", // class name
  0,0,//no base classes
  &(vtc_S21927C31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,176), // object size
  NSPAIRA(_ZTI9S21927C31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21927C31),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21927C30  {
  ::S21927C31 s21927c30f0;
  ::S21927C2_nt s21927c30f1;
  char s21927c30f2;
  virtual  ~S21927C30(); // _ZN9S21927C30D1Ev
  virtual void  v201(); // _ZN9S21927C304v201Ev
  virtual void  v202(); // _ZN9S21927C304v202Ev
  virtual void  v203(); // _ZN9S21927C304v203Ev
  virtual void  v204(); // _ZN9S21927C304v204Ev
  S21927C30(); // tgen
};
//SIG(-1 S21927C30) C1{ vd v1 v2 v3 v4 FC2{ vd m Fc Fp Fi[4] Fc[2] FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC6{ BC7{ m Fp Fi FC8{ m} FC8}} FC4 Fp Fc[2] Fi[2] FC9{ m Fp[2]} FC10{ m FL[4]} FC11{ m Fp FC12{ Fi[4]}} FC10} FC10 Fc}


 S21927C30 ::~S21927C30(){ note_dtor("S21927C30", this);}
void  S21927C30 ::v201(){vfunc_called(this, "_ZN9S21927C304v201Ev");}
void  S21927C30 ::v202(){vfunc_called(this, "_ZN9S21927C304v202Ev");}
void  S21927C30 ::v203(){vfunc_called(this, "_ZN9S21927C304v203Ev");}
void  S21927C30 ::v204(){vfunc_called(this, "_ZN9S21927C304v204Ev");}
S21927C30 ::S21927C30(){ note_ctor("S21927C30", this);} // tgen

static void Test_S21927C30()
{
  extern Class_Descriptor cd_S21927C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,55)];
    init_test(&cd_S21927C30, buf);
    S21927C30 *dp, &lv = *(dp=new (buf) S21927C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,216), "sizeof(S21927C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21927C30)");
    check_field_offset(lv, s21927c30f0, ABISELECT(8,4), "S21927C30.s21927c30f0");
    check_field_offset(lv, s21927c30f1, ABISELECT(232,180), "S21927C30.s21927c30f1");
    check_field_offset(lv, s21927c30f2, ABISELECT(264,212), "S21927C30.s21927c30f2");
    test_class_info(&lv, &cd_S21927C30);
    dp->~S21927C30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21927C30(Test_S21927C30, "S21927C30", ABISELECT(272,216));

#else // __cplusplus

extern void _ZN9S21927C30C1Ev();
extern void _ZN9S21927C30D1Ev();
Name_Map name_map_S21927C30[] = {
  NSPAIR(_ZN9S21927C30C1Ev),
  NSPAIR(_ZN9S21927C30D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21927C30[];
extern void _ZN9S21927C30D1Ev();
extern void _ZN9S21927C30D0Ev();
extern void _ZN9S21927C304v201Ev();
extern void _ZN9S21927C304v202Ev();
extern void _ZN9S21927C304v203Ev();
extern void _ZN9S21927C304v204Ev();
static  VTBL_ENTRY vtc_S21927C30[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21927C30[0]),
  (VTBL_ENTRY)&_ZN9S21927C30D1Ev,
  (VTBL_ENTRY)&_ZN9S21927C30D0Ev,
  (VTBL_ENTRY)&_ZN9S21927C304v201Ev,
  (VTBL_ENTRY)&_ZN9S21927C304v202Ev,
  (VTBL_ENTRY)&_ZN9S21927C304v203Ev,
  (VTBL_ENTRY)&_ZN9S21927C304v204Ev,
};
extern VTBL_ENTRY _ZTI9S21927C30[];
extern  VTBL_ENTRY _ZTV9S21927C30[];
Class_Descriptor cd_S21927C30 = {  "S21927C30", // class name
  0,0,//no base classes
  &(vtc_S21927C30[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,216), // object size
  NSPAIRA(_ZTI9S21927C30),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21927C30),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21927C28  {
  int s21927c28f0[3];
  void *s21927c28f1;
  ::S21925C30_nt s21927c28f2;
  void *s21927c28f3;
  int s21927c28f4[2];
  void *s21927c28f5;
  ::S21927C30 s21927c28f6;
  ::S21925C46 s21927c28f7;
  void  mf21927c28(); // _ZN9S21927C2810mf21927c28Ev
  virtual  ~S21927C28(); // _ZN9S21927C28D1Ev
  S21927C28(); // tgen
};
//SIG(-1 S21927C28) C1{ vd m Fi[3] Fp FC2{ Fp[3]} Fp Fi[2] Fp FC3{ vd v1 v2 v3 v4 FC4{ vd m Fc Fp Fi[4] Fc[2] FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC8{ BC9{ m Fp Fi FC10{ m} FC10}} FC6 Fp Fc[2] Fi[2] FC11{ m Fp[2]} FC12{ m FL[4]} FC13{ m Fp FC14{ Fi[4]}} FC12} FC12 Fc} FC15{ vd v5 v6 v7 v8 v9 FC16{ m Fi Fc FL Fi}[5]}}


void  S21927C28 ::mf21927c28(){}
 S21927C28 ::~S21927C28(){ note_dtor("S21927C28", this);}
S21927C28 ::S21927C28(){ note_ctor("S21927C28", this);} // tgen

static void Test_S21927C28()
{
  extern Class_Descriptor cd_S21927C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(61,93)];
    init_test(&cd_S21927C28, buf);
    S21927C28 *dp, &lv = *(dp=new (buf) S21927C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(480,368), "sizeof(S21927C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21927C28)");
    check_field_offset(lv, s21927c28f0, ABISELECT(8,4), "S21927C28.s21927c28f0");
    check_field_offset(lv, s21927c28f1, ABISELECT(24,16), "S21927C28.s21927c28f1");
    check_field_offset(lv, s21927c28f2, ABISELECT(32,20), "S21927C28.s21927c28f2");
    check_field_offset(lv, s21927c28f3, ABISELECT(56,32), "S21927C28.s21927c28f3");
    check_field_offset(lv, s21927c28f4, ABISELECT(64,36), "S21927C28.s21927c28f4");
    check_field_offset(lv, s21927c28f5, ABISELECT(72,44), "S21927C28.s21927c28f5");
    check_field_offset(lv, s21927c28f6, ABISELECT(80,48), "S21927C28.s21927c28f6");
    check_field_offset(lv, s21927c28f7, ABISELECT(352,264), "S21927C28.s21927c28f7");
    test_class_info(&lv, &cd_S21927C28);
    dp->~S21927C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21927C28(Test_S21927C28, "S21927C28", ABISELECT(480,368));

#else // __cplusplus

extern void _ZN9S21927C28C1Ev();
extern void _ZN9S21927C28D1Ev();
Name_Map name_map_S21927C28[] = {
  NSPAIR(_ZN9S21927C28C1Ev),
  NSPAIR(_ZN9S21927C28D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S21927C28[];
extern void _ZN9S21927C28D1Ev();
extern void _ZN9S21927C28D0Ev();
static  VTBL_ENTRY vtc_S21927C28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21927C28[0]),
  (VTBL_ENTRY)&_ZN9S21927C28D1Ev,
  (VTBL_ENTRY)&_ZN9S21927C28D0Ev,
};
extern VTBL_ENTRY _ZTI9S21927C28[];
extern  VTBL_ENTRY _ZTV9S21927C28[];
Class_Descriptor cd_S21927C28 = {  "S21927C28", // class name
  0,0,//no base classes
  &(vtc_S21927C28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(480,368), // object size
  NSPAIRA(_ZTI9S21927C28),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S21927C28),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21927C1  {
  void *s21927c1f0;
  int s21927c1f1[3];
  ::S21927C2_nt s21927c1f2;
  ::S21927C2_nt s21927c1f3;
  ::S21925C4_nt s21927c1f4;
  ::S21925C6 s21927c1f5;
  void *s21927c1f6[2];
  int s21927c1f7;
  void *s21927c1f8;
  int s21927c1f9;
  void *s21927c1f10[3];
  ::S21925C7 s21927c1f11;
  ::S21927C28 s21927c1f12;
  void *s21927c1f13;
  char s21927c1f14;
  void *s21927c1f15;
  char s21927c1f16;
  void *s21927c1f17;
  char s21927c1f18;
  void *s21927c1f19;
  char s21927c1f20;
  ::S21925C48 s21927c1f21;
  int s21927c1f22;
  ::S21925C54 s21927c1f23;
  ::S21925C54 s21927c1f24[8];
  ::S21925C54 s21927c1f25[2];
  ::S21925C55 s21927c1f26;
  char s21927c1f27;
  int s21927c1f28;
  char s21927c1f29;
  void *s21927c1f30;
  char s21927c1f31[2];
  ::S21926C57 s21927c1f32;
  char s21927c1f33;
  virtual  ~S21927C1(); // _ZN8S21927C1D1Ev
  virtual void  v1(); // _ZN8S21927C12v1Ev
  S21927C1(); // tgen
};
//SIG(1 S21927C1) C1{ vd v1 Fp Fi[3] FC2{ m FL[4]} FC2 FC3{ m Fp FC4{ Fi[4]}} FC5{ vd m Fp[2] Fi} Fp[2] Fi Fp Fi Fp[3] FC6{ BC7{ v33 v34 v35 v36 v37 v38 v39} vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fi[2] Fp FC8{ m Fp[3]} FC9{ BC7 vd v40 v41 v42 v43 v44 v45 v46 Fp FC10{ BC11{ vd v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 Fp Fi} vd v47 v48 v49 v50} FC12{ BC11 vd v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94} FC13{ BC11 vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112} FC14{ BC11 vd v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133} FC15{ BC11 vd v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155} FC14 FC13 FC16{ BC11 vd v156 v157 v158 v159 v160 v161} Fp[4] FC17{ m Fc[6] Fp Fi[2] FC18{ vd m Fi[2] FL[3] Fc[2048] Fi[6] FL Fi[4] Fp[2] Fc} Fi[2]} FC19{ m Fi[3]} FC20{ m Fc} FC21{ m Fp Fi[3] FC18 FC22{ vd m Fi[2] FL Fi[4]} Fi[6] FC4 Fi[4]} Fp Fi[3]} FC23{ vd m Fp Fi Fp[9] Fi} FC24{ FL[2] Fi[6]}} FC25{ vd m Fi[3] Fp FC26{ Fp[3]} Fp Fi[2] Fp FC27{ vd v162 v163 v164 v165 FC28{ vd m Fc Fp Fi[4] Fc[2] FC29{ BC30{ m Fp Fi FC31{ m} FC31}} FC32{ BC33{ m Fp Fi FC34{ m} FC34}} FC30 Fp Fc[2] Fi[2] FC35{ m Fp[2]} FC2 FC3 FC2} FC2 Fc} FC36{ vd v166 v167 v168 v169 v170 FC37{ m Fi Fc FL Fi}[5]}} Fp Fc Fp Fc Fp Fc Fp Fc FC38{ m FC39{ m Fp[4]} Fi Fc Fi[3] Fc[2] Fi FC40{ m Fc Fi FC19 Fi[2] FC41{ m Fi[4]} Fi} Fi Fp[3] Fi Fp Fi[2] Fp[2] Fi Fp[2] Fi[3] Fp[2] Fi[8] Fc FC42{ m Fi[5] Fp}} Fi FC43{ Fc[4] Fi Fc Fi Fs Fi[4] FL[3] Fi[8] FC4 Fi[2]} FC43[8] FC43[2] FC44{ Fc[3] Fi Fc[3] FC45{ m Fc[8] Fi[2] Fc[3]} FC45 FC45} Fc Fi Fc Fp Fc[2] FC46{ m Fp Fc FL} Fc}


 S21927C1 ::~S21927C1(){ note_dtor("S21927C1", this);}
void  S21927C1 ::v1(){vfunc_called(this, "_ZN8S21927C12v1Ev");}
S21927C1 ::S21927C1(){ note_ctor("S21927C1", this);} // tgen

static void Test_S21927C1()
{
  extern Class_Descriptor cd_S21927C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(935,1717)];
    init_test(&cd_S21927C1, buf);
    S21927C1 *dp, &lv = *(dp=new (buf) S21927C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7472,6864), "sizeof(S21927C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21927C1)");
    check_field_offset(lv, s21927c1f0, ABISELECT(8,4), "S21927C1.s21927c1f0");
    check_field_offset(lv, s21927c1f1, ABISELECT(16,8), "S21927C1.s21927c1f1");
    check_field_offset(lv, s21927c1f2, ABISELECT(32,20), "S21927C1.s21927c1f2");
    check_field_offset(lv, s21927c1f3, ABISELECT(64,52), "S21927C1.s21927c1f3");
    check_field_offset(lv, s21927c1f4, ABISELECT(96,84), "S21927C1.s21927c1f4");
    check_field_offset(lv, s21927c1f5, ABISELECT(120,104), "S21927C1.s21927c1f5");
    check_field_offset(lv, s21927c1f6, ABISELECT(152,120), "S21927C1.s21927c1f6");
    check_field_offset(lv, s21927c1f7, ABISELECT(168,128), "S21927C1.s21927c1f7");
    check_field_offset(lv, s21927c1f8, ABISELECT(176,132), "S21927C1.s21927c1f8");
    check_field_offset(lv, s21927c1f9, ABISELECT(184,136), "S21927C1.s21927c1f9");
    check_field_offset(lv, s21927c1f10, ABISELECT(192,140), "S21927C1.s21927c1f10");
    check_field_offset(lv, s21927c1f11, ABISELECT(216,152), "S21927C1.s21927c1f11");
    check_field_offset(lv, s21927c1f12, ABISELECT(5160,4848), "S21927C1.s21927c1f12");
    check_field_offset(lv, s21927c1f13, ABISELECT(5640,5216), "S21927C1.s21927c1f13");
    check_field_offset(lv, s21927c1f14, ABISELECT(5648,5220), "S21927C1.s21927c1f14");
    check_field_offset(lv, s21927c1f15, ABISELECT(5656,5224), "S21927C1.s21927c1f15");
    check_field_offset(lv, s21927c1f16, ABISELECT(5664,5228), "S21927C1.s21927c1f16");
    check_field_offset(lv, s21927c1f17, ABISELECT(5672,5232), "S21927C1.s21927c1f17");
    check_field_offset(lv, s21927c1f18, ABISELECT(5680,5236), "S21927C1.s21927c1f18");
    check_field_offset(lv, s21927c1f19, ABISELECT(5688,5240), "S21927C1.s21927c1f19");
    check_field_offset(lv, s21927c1f20, ABISELECT(5696,5244), "S21927C1.s21927c1f20");
    check_field_offset(lv, s21927c1f21, ABISELECT(5704,5248), "S21927C1.s21927c1f21");
    check_field_offset(lv, s21927c1f22, ABISELECT(6008,5472), "S21927C1.s21927c1f22");
    check_field_offset(lv, s21927c1f23, ABISELECT(6016,5476), "S21927C1.s21927c1f23");
    check_field_offset(lv, s21927c1f24, ABISELECT(6136,5592), "S21927C1.s21927c1f24");
    check_field_offset(lv, s21927c1f25, ABISELECT(7096,6520), "S21927C1.s21927c1f25");
    check_field_offset(lv, s21927c1f26, ABISELECT(7336,6752), "S21927C1.s21927c1f26");
    check_field_offset(lv, s21927c1f27, ABISELECT(7408,6824), "S21927C1.s21927c1f27");
    check_field_offset(lv, s21927c1f28, ABISELECT(7412,6828), "S21927C1.s21927c1f28");
    check_field_offset(lv, s21927c1f29, ABISELECT(7416,6832), "S21927C1.s21927c1f29");
    check_field_offset(lv, s21927c1f30, ABISELECT(7424,6836), "S21927C1.s21927c1f30");
    check_field_offset(lv, s21927c1f31, ABISELECT(7432,6840), "S21927C1.s21927c1f31");
    check_field_offset(lv, s21927c1f32, ABISELECT(7440,6844), "S21927C1.s21927c1f32");
    check_field_offset(lv, s21927c1f33, ABISELECT(7464,6860), "S21927C1.s21927c1f33");
    test_class_info(&lv, &cd_S21927C1);
    dp->~S21927C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21927C1(Test_S21927C1, "S21927C1", ABISELECT(7472,6864));

#else // __cplusplus

extern void _ZN8S21927C1C1Ev();
extern void _ZN8S21927C1D1Ev();
Name_Map name_map_S21927C1[] = {
  NSPAIR(_ZN8S21927C1C1Ev),
  NSPAIR(_ZN8S21927C1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S21927C1[];
extern void _ZN8S21927C1D1Ev();
extern void _ZN8S21927C1D0Ev();
extern void _ZN8S21927C12v1Ev();
static  VTBL_ENTRY vtc_S21927C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21927C1[0]),
  (VTBL_ENTRY)&_ZN8S21927C1D1Ev,
  (VTBL_ENTRY)&_ZN8S21927C1D0Ev,
  (VTBL_ENTRY)&_ZN8S21927C12v1Ev,
};
extern VTBL_ENTRY _ZTI8S21927C1[];
extern  VTBL_ENTRY _ZTV8S21927C1[];
Class_Descriptor cd_S21927C1 = {  "S21927C1", // class name
  0,0,//no base classes
  &(vtc_S21927C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(7472,6864), // object size
  NSPAIRA(_ZTI8S21927C1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S21927C1),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C6_nt  {
  int s473c6f0[2];
  void  mf473c6(); // _ZN9S473C6_nt7mf473c6Ev
};
//SIG(-1 S473C6_nt) C1{ m Fi[2]}


void  S473C6_nt ::mf473c6(){}

//skip512 S473C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C5_nt  {
  int s473c5f0;
  __tsi64 s473c5f1;
  void *s473c5f2[4];
  int s473c5f3[2];
  void *s473c5f4;
  ::S473C6_nt s473c5f5;
  void *s473c5f6[2];
  virtual  ~S473C5_nt(); // _ZN9S473C5_ntD1Ev
  virtual void  v10(); // _ZN9S473C5_nt3v10Ev
  virtual void  v11(); // _ZN9S473C5_nt3v11Ev
  virtual void  v12(); // _ZN9S473C5_nt3v12Ev
  virtual void  v13(); // _ZN9S473C5_nt3v13Ev
  virtual void  v14(); // _ZN9S473C5_nt3v14Ev
  virtual void  v15(); // _ZN9S473C5_nt3v15Ev
  virtual void  v16(); // _ZN9S473C5_nt3v16Ev
  virtual void  v17(); // _ZN9S473C5_nt3v17Ev
  virtual void  v18(); // _ZN9S473C5_nt3v18Ev
  virtual void  v19(); // _ZN9S473C5_nt3v19Ev
  virtual void  v20(); // _ZN9S473C5_nt3v20Ev
  virtual void  v21(); // _ZN9S473C5_nt3v21Ev
  virtual void  v22(); // _ZN9S473C5_nt3v22Ev
  virtual void  v23(); // _ZN9S473C5_nt3v23Ev
  virtual void  v24(); // _ZN9S473C5_nt3v24Ev
  virtual void  v25(); // _ZN9S473C5_nt3v25Ev
  virtual void  v26(); // _ZN9S473C5_nt3v26Ev
  virtual void  v27(); // _ZN9S473C5_nt3v27Ev
  virtual void  v28(); // _ZN9S473C5_nt3v28Ev
  virtual void  v29(); // _ZN9S473C5_nt3v29Ev
  virtual void  v30(); // _ZN9S473C5_nt3v30Ev
  virtual void  v31(); // _ZN9S473C5_nt3v31Ev
  virtual void  v32(); // _ZN9S473C5_nt3v32Ev
  virtual void  v33(); // _ZN9S473C5_nt3v33Ev
  virtual void  v34(); // _ZN9S473C5_nt3v34Ev
  virtual void  v35(); // _ZN9S473C5_nt3v35Ev
  virtual void  v36(); // _ZN9S473C5_nt3v36Ev
  virtual void  v37(); // _ZN9S473C5_nt3v37Ev
  virtual void  v38(); // _ZN9S473C5_nt3v38Ev
  virtual void  v39(); // _ZN9S473C5_nt3v39Ev
  virtual void  v40(); // _ZN9S473C5_nt3v40Ev
  virtual void  v41(); // _ZN9S473C5_nt3v41Ev
  virtual void  v42(); // _ZN9S473C5_nt3v42Ev
  virtual void  v43(); // _ZN9S473C5_nt3v43Ev
  virtual void  v44(); // _ZN9S473C5_nt3v44Ev
  virtual void  v45(); // _ZN9S473C5_nt3v45Ev
  virtual void  v46(); // _ZN9S473C5_nt3v46Ev
  virtual void  v47(); // _ZN9S473C5_nt3v47Ev
  virtual void  v48(); // _ZN9S473C5_nt3v48Ev
  virtual void  v49(); // _ZN9S473C5_nt3v49Ev
  virtual void  v50(); // _ZN9S473C5_nt3v50Ev
  virtual void  v51(); // _ZN9S473C5_nt3v51Ev
  virtual void  v52(); // _ZN9S473C5_nt3v52Ev
  virtual void  v53(); // _ZN9S473C5_nt3v53Ev
  virtual void  v54(); // _ZN9S473C5_nt3v54Ev
  virtual void  v55(); // _ZN9S473C5_nt3v55Ev
  virtual void  v56(); // _ZN9S473C5_nt3v56Ev
  virtual void  v57(); // _ZN9S473C5_nt3v57Ev
  virtual void  v58(); // _ZN9S473C5_nt3v58Ev
  virtual void  v59(); // _ZN9S473C5_nt3v59Ev
  virtual void  v60(); // _ZN9S473C5_nt3v60Ev
  virtual void  v61(); // _ZN9S473C5_nt3v61Ev
  virtual void  v62(); // _ZN9S473C5_nt3v62Ev
  virtual void  v63(); // _ZN9S473C5_nt3v63Ev
  virtual void  v64(); // _ZN9S473C5_nt3v64Ev
  virtual void  v65(); // _ZN9S473C5_nt3v65Ev
  virtual void  v66(); // _ZN9S473C5_nt3v66Ev
  virtual void  v67(); // _ZN9S473C5_nt3v67Ev
  virtual void  v68(); // _ZN9S473C5_nt3v68Ev
  virtual void  v69(); // _ZN9S473C5_nt3v69Ev
  virtual void  v70(); // _ZN9S473C5_nt3v70Ev
  virtual void  v71(); // _ZN9S473C5_nt3v71Ev
  virtual void  v72(); // _ZN9S473C5_nt3v72Ev
  virtual void  v73(); // _ZN9S473C5_nt3v73Ev
  S473C5_nt(); // tgen
};
//SIG(-1 S473C5_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S473C5_nt ::~S473C5_nt(){ note_dtor("S473C5_nt", this);}
void  S473C5_nt ::v10(){vfunc_called(this, "_ZN9S473C5_nt3v10Ev");}
void  S473C5_nt ::v11(){vfunc_called(this, "_ZN9S473C5_nt3v11Ev");}
void  S473C5_nt ::v12(){vfunc_called(this, "_ZN9S473C5_nt3v12Ev");}
void  S473C5_nt ::v13(){vfunc_called(this, "_ZN9S473C5_nt3v13Ev");}
void  S473C5_nt ::v14(){vfunc_called(this, "_ZN9S473C5_nt3v14Ev");}
void  S473C5_nt ::v15(){vfunc_called(this, "_ZN9S473C5_nt3v15Ev");}
void  S473C5_nt ::v16(){vfunc_called(this, "_ZN9S473C5_nt3v16Ev");}
void  S473C5_nt ::v17(){vfunc_called(this, "_ZN9S473C5_nt3v17Ev");}
void  S473C5_nt ::v18(){vfunc_called(this, "_ZN9S473C5_nt3v18Ev");}
void  S473C5_nt ::v19(){vfunc_called(this, "_ZN9S473C5_nt3v19Ev");}
void  S473C5_nt ::v20(){vfunc_called(this, "_ZN9S473C5_nt3v20Ev");}
void  S473C5_nt ::v21(){vfunc_called(this, "_ZN9S473C5_nt3v21Ev");}
void  S473C5_nt ::v22(){vfunc_called(this, "_ZN9S473C5_nt3v22Ev");}
void  S473C5_nt ::v23(){vfunc_called(this, "_ZN9S473C5_nt3v23Ev");}
void  S473C5_nt ::v24(){vfunc_called(this, "_ZN9S473C5_nt3v24Ev");}
void  S473C5_nt ::v25(){vfunc_called(this, "_ZN9S473C5_nt3v25Ev");}
void  S473C5_nt ::v26(){vfunc_called(this, "_ZN9S473C5_nt3v26Ev");}
void  S473C5_nt ::v27(){vfunc_called(this, "_ZN9S473C5_nt3v27Ev");}
void  S473C5_nt ::v28(){vfunc_called(this, "_ZN9S473C5_nt3v28Ev");}
void  S473C5_nt ::v29(){vfunc_called(this, "_ZN9S473C5_nt3v29Ev");}
void  S473C5_nt ::v30(){vfunc_called(this, "_ZN9S473C5_nt3v30Ev");}
void  S473C5_nt ::v31(){vfunc_called(this, "_ZN9S473C5_nt3v31Ev");}
void  S473C5_nt ::v32(){vfunc_called(this, "_ZN9S473C5_nt3v32Ev");}
void  S473C5_nt ::v33(){vfunc_called(this, "_ZN9S473C5_nt3v33Ev");}
void  S473C5_nt ::v34(){vfunc_called(this, "_ZN9S473C5_nt3v34Ev");}
void  S473C5_nt ::v35(){vfunc_called(this, "_ZN9S473C5_nt3v35Ev");}
void  S473C5_nt ::v36(){vfunc_called(this, "_ZN9S473C5_nt3v36Ev");}
void  S473C5_nt ::v37(){vfunc_called(this, "_ZN9S473C5_nt3v37Ev");}
void  S473C5_nt ::v38(){vfunc_called(this, "_ZN9S473C5_nt3v38Ev");}
void  S473C5_nt ::v39(){vfunc_called(this, "_ZN9S473C5_nt3v39Ev");}
void  S473C5_nt ::v40(){vfunc_called(this, "_ZN9S473C5_nt3v40Ev");}
void  S473C5_nt ::v41(){vfunc_called(this, "_ZN9S473C5_nt3v41Ev");}
void  S473C5_nt ::v42(){vfunc_called(this, "_ZN9S473C5_nt3v42Ev");}
void  S473C5_nt ::v43(){vfunc_called(this, "_ZN9S473C5_nt3v43Ev");}
void  S473C5_nt ::v44(){vfunc_called(this, "_ZN9S473C5_nt3v44Ev");}
void  S473C5_nt ::v45(){vfunc_called(this, "_ZN9S473C5_nt3v45Ev");}
void  S473C5_nt ::v46(){vfunc_called(this, "_ZN9S473C5_nt3v46Ev");}
void  S473C5_nt ::v47(){vfunc_called(this, "_ZN9S473C5_nt3v47Ev");}
void  S473C5_nt ::v48(){vfunc_called(this, "_ZN9S473C5_nt3v48Ev");}
void  S473C5_nt ::v49(){vfunc_called(this, "_ZN9S473C5_nt3v49Ev");}
void  S473C5_nt ::v50(){vfunc_called(this, "_ZN9S473C5_nt3v50Ev");}
void  S473C5_nt ::v51(){vfunc_called(this, "_ZN9S473C5_nt3v51Ev");}
void  S473C5_nt ::v52(){vfunc_called(this, "_ZN9S473C5_nt3v52Ev");}
void  S473C5_nt ::v53(){vfunc_called(this, "_ZN9S473C5_nt3v53Ev");}
void  S473C5_nt ::v54(){vfunc_called(this, "_ZN9S473C5_nt3v54Ev");}
void  S473C5_nt ::v55(){vfunc_called(this, "_ZN9S473C5_nt3v55Ev");}
void  S473C5_nt ::v56(){vfunc_called(this, "_ZN9S473C5_nt3v56Ev");}
void  S473C5_nt ::v57(){vfunc_called(this, "_ZN9S473C5_nt3v57Ev");}
void  S473C5_nt ::v58(){vfunc_called(this, "_ZN9S473C5_nt3v58Ev");}
void  S473C5_nt ::v59(){vfunc_called(this, "_ZN9S473C5_nt3v59Ev");}
void  S473C5_nt ::v60(){vfunc_called(this, "_ZN9S473C5_nt3v60Ev");}
void  S473C5_nt ::v61(){vfunc_called(this, "_ZN9S473C5_nt3v61Ev");}
void  S473C5_nt ::v62(){vfunc_called(this, "_ZN9S473C5_nt3v62Ev");}
void  S473C5_nt ::v63(){vfunc_called(this, "_ZN9S473C5_nt3v63Ev");}
void  S473C5_nt ::v64(){vfunc_called(this, "_ZN9S473C5_nt3v64Ev");}
void  S473C5_nt ::v65(){vfunc_called(this, "_ZN9S473C5_nt3v65Ev");}
void  S473C5_nt ::v66(){vfunc_called(this, "_ZN9S473C5_nt3v66Ev");}
void  S473C5_nt ::v67(){vfunc_called(this, "_ZN9S473C5_nt3v67Ev");}
void  S473C5_nt ::v68(){vfunc_called(this, "_ZN9S473C5_nt3v68Ev");}
void  S473C5_nt ::v69(){vfunc_called(this, "_ZN9S473C5_nt3v69Ev");}
void  S473C5_nt ::v70(){vfunc_called(this, "_ZN9S473C5_nt3v70Ev");}
void  S473C5_nt ::v71(){vfunc_called(this, "_ZN9S473C5_nt3v71Ev");}
void  S473C5_nt ::v72(){vfunc_called(this, "_ZN9S473C5_nt3v72Ev");}
void  S473C5_nt ::v73(){vfunc_called(this, "_ZN9S473C5_nt3v73Ev");}
S473C5_nt ::S473C5_nt(){ note_ctor("S473C5_nt", this);} // tgen

//skip512 S473C5_nt

#else // __cplusplus

extern void _ZN9S473C5_ntC1Ev();
extern void _ZN9S473C5_ntD1Ev();
Name_Map name_map_S473C5_nt[] = {
  NSPAIR(_ZN9S473C5_ntC1Ev),
  NSPAIR(_ZN9S473C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S473C5_nt[];
extern void _ZN9S473C5_ntD1Ev();
extern void _ZN9S473C5_ntD0Ev();
extern void _ZN9S473C5_nt3v10Ev();
extern void _ZN9S473C5_nt3v11Ev();
extern void _ZN9S473C5_nt3v12Ev();
extern void _ZN9S473C5_nt3v13Ev();
extern void _ZN9S473C5_nt3v14Ev();
extern void _ZN9S473C5_nt3v15Ev();
extern void _ZN9S473C5_nt3v16Ev();
extern void _ZN9S473C5_nt3v17Ev();
extern void _ZN9S473C5_nt3v18Ev();
extern void _ZN9S473C5_nt3v19Ev();
extern void _ZN9S473C5_nt3v20Ev();
extern void _ZN9S473C5_nt3v21Ev();
extern void _ZN9S473C5_nt3v22Ev();
extern void _ZN9S473C5_nt3v23Ev();
extern void _ZN9S473C5_nt3v24Ev();
extern void _ZN9S473C5_nt3v25Ev();
extern void _ZN9S473C5_nt3v26Ev();
extern void _ZN9S473C5_nt3v27Ev();
extern void _ZN9S473C5_nt3v28Ev();
extern void _ZN9S473C5_nt3v29Ev();
extern void _ZN9S473C5_nt3v30Ev();
extern void _ZN9S473C5_nt3v31Ev();
extern void _ZN9S473C5_nt3v32Ev();
extern void _ZN9S473C5_nt3v33Ev();
extern void _ZN9S473C5_nt3v34Ev();
extern void _ZN9S473C5_nt3v35Ev();
extern void _ZN9S473C5_nt3v36Ev();
extern void _ZN9S473C5_nt3v37Ev();
extern void _ZN9S473C5_nt3v38Ev();
extern void _ZN9S473C5_nt3v39Ev();
extern void _ZN9S473C5_nt3v40Ev();
extern void _ZN9S473C5_nt3v41Ev();
extern void _ZN9S473C5_nt3v42Ev();
extern void _ZN9S473C5_nt3v43Ev();
extern void _ZN9S473C5_nt3v44Ev();
extern void _ZN9S473C5_nt3v45Ev();
extern void _ZN9S473C5_nt3v46Ev();
extern void _ZN9S473C5_nt3v47Ev();
extern void _ZN9S473C5_nt3v48Ev();
extern void _ZN9S473C5_nt3v49Ev();
extern void _ZN9S473C5_nt3v50Ev();
extern void _ZN9S473C5_nt3v51Ev();
extern void _ZN9S473C5_nt3v52Ev();
extern void _ZN9S473C5_nt3v53Ev();
extern void _ZN9S473C5_nt3v54Ev();
extern void _ZN9S473C5_nt3v55Ev();
extern void _ZN9S473C5_nt3v56Ev();
extern void _ZN9S473C5_nt3v57Ev();
extern void _ZN9S473C5_nt3v58Ev();
extern void _ZN9S473C5_nt3v59Ev();
extern void _ZN9S473C5_nt3v60Ev();
extern void _ZN9S473C5_nt3v61Ev();
extern void _ZN9S473C5_nt3v62Ev();
extern void _ZN9S473C5_nt3v63Ev();
extern void _ZN9S473C5_nt3v64Ev();
extern void _ZN9S473C5_nt3v65Ev();
extern void _ZN9S473C5_nt3v66Ev();
extern void _ZN9S473C5_nt3v67Ev();
extern void _ZN9S473C5_nt3v68Ev();
extern void _ZN9S473C5_nt3v69Ev();
extern void _ZN9S473C5_nt3v70Ev();
extern void _ZN9S473C5_nt3v71Ev();
extern void _ZN9S473C5_nt3v72Ev();
extern void _ZN9S473C5_nt3v73Ev();
static  VTBL_ENTRY vtc_S473C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S473C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S473C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S473C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v73Ev,
};
extern VTBL_ENTRY _ZTI9S473C5_nt[];
VTBL_ENTRY *P__ZTI9S473C5_nt = _ZTI9S473C5_nt; 
extern  VTBL_ENTRY _ZTV9S473C5_nt[];
Class_Descriptor cd_S473C5_nt = {  "S473C5_nt", // class name
  0,0,//no base classes
  &(vtc_S473C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S473C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S473C5_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C10_nt  {
  void *s473c10f0;
  int s473c10f1[2];
  void  mf473c10(); // _ZN10S473C10_nt8mf473c10Ev
};
//SIG(-1 S473C10_nt) C1{ m Fp Fi[2]}


void  S473C10_nt ::mf473c10(){}

//skip512 S473C10_nt

#else // __cplusplus

Class_Descriptor cd_S473C10_nt = {  "S473C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C9_nt  : S473C10_nt {
};
//SIG(-1 S473C9_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S473C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S473C10_nt;
static Base_Class bases_S473C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S473C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S473C9_nt = {  "S473C9_nt", // class name
  bases_S473C9_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C8_nt  : S473C9_nt {
};
//SIG(-1 S473C8_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S473C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S473C10_nt;
extern Class_Descriptor cd_S473C9_nt;
static Base_Class bases_S473C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S473C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S473C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S473C8_nt = {  "S473C8_nt", // class name
  bases_S473C8_nt, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C7_nt  : S473C8_nt {
};
//SIG(-1 S473C7_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S473C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S473C10_nt;
extern Class_Descriptor cd_S473C9_nt;
extern Class_Descriptor cd_S473C8_nt;
static Base_Class bases_S473C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S473C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S473C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S473C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C4_nt  : S473C5_nt {
  int s473c4f0[2];
  void *s473c4f1;
  int s473c4f2[2];
  ::S473C7_nt s473c4f3;
  ::S473C7_nt s473c4f4;
  ::S21925C42 s473c4f5;
  ::S473C7_nt s473c4f6;
  unsigned int s473c4f7:1;
  unsigned int s473c4f8:1;
  unsigned int s473c4f9:1;
  unsigned int s473c4f10:1;
  unsigned int s473c4f11:1;
  int s473c4f12[2];
  virtual  ~S473C4_nt(); // _ZN9S473C4_ntD1Ev
  virtual void  v74(); // _ZN9S473C4_nt3v74Ev
  virtual void  v75(); // _ZN9S473C4_nt3v75Ev
  virtual void  v76(); // _ZN9S473C4_nt3v76Ev
  virtual void  v77(); // _ZN9S473C4_nt3v77Ev
  virtual void  v78(); // _ZN9S473C4_nt3v78Ev
  virtual void  v79(); // _ZN9S473C4_nt3v79Ev
  virtual void  v80(); // _ZN9S473C4_nt3v80Ev
  virtual void  v81(); // _ZN9S473C4_nt3v81Ev
  virtual void  v82(); // _ZN9S473C4_nt3v82Ev
  virtual void  v83(); // _ZN9S473C4_nt3v83Ev
  virtual void  v84(); // _ZN9S473C4_nt3v84Ev
  virtual void  v85(); // _ZN9S473C4_nt3v85Ev
  virtual void  v86(); // _ZN9S473C4_nt3v86Ev
  virtual void  v87(); // _ZN9S473C4_nt3v87Ev
  virtual void  v88(); // _ZN9S473C4_nt3v88Ev
  virtual void  v89(); // _ZN9S473C4_nt3v89Ev
  virtual void  v90(); // _ZN9S473C4_nt3v90Ev
  virtual void  v91(); // _ZN9S473C4_nt3v91Ev
  virtual void  v92(); // _ZN9S473C4_nt3v92Ev
  virtual void  v93(); // _ZN9S473C4_nt3v93Ev
  virtual void  v94(); // _ZN9S473C4_nt3v94Ev
  virtual void  v95(); // _ZN9S473C4_nt3v95Ev
  S473C4_nt(); // tgen
};
//SIG(-1 S473C4_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S473C4_nt ::~S473C4_nt(){ note_dtor("S473C4_nt", this);}
void  S473C4_nt ::v74(){vfunc_called(this, "_ZN9S473C4_nt3v74Ev");}
void  S473C4_nt ::v75(){vfunc_called(this, "_ZN9S473C4_nt3v75Ev");}
void  S473C4_nt ::v76(){vfunc_called(this, "_ZN9S473C4_nt3v76Ev");}
void  S473C4_nt ::v77(){vfunc_called(this, "_ZN9S473C4_nt3v77Ev");}
void  S473C4_nt ::v78(){vfunc_called(this, "_ZN9S473C4_nt3v78Ev");}
void  S473C4_nt ::v79(){vfunc_called(this, "_ZN9S473C4_nt3v79Ev");}
void  S473C4_nt ::v80(){vfunc_called(this, "_ZN9S473C4_nt3v80Ev");}
void  S473C4_nt ::v81(){vfunc_called(this, "_ZN9S473C4_nt3v81Ev");}
void  S473C4_nt ::v82(){vfunc_called(this, "_ZN9S473C4_nt3v82Ev");}
void  S473C4_nt ::v83(){vfunc_called(this, "_ZN9S473C4_nt3v83Ev");}
void  S473C4_nt ::v84(){vfunc_called(this, "_ZN9S473C4_nt3v84Ev");}
void  S473C4_nt ::v85(){vfunc_called(this, "_ZN9S473C4_nt3v85Ev");}
void  S473C4_nt ::v86(){vfunc_called(this, "_ZN9S473C4_nt3v86Ev");}
void  S473C4_nt ::v87(){vfunc_called(this, "_ZN9S473C4_nt3v87Ev");}
void  S473C4_nt ::v88(){vfunc_called(this, "_ZN9S473C4_nt3v88Ev");}
void  S473C4_nt ::v89(){vfunc_called(this, "_ZN9S473C4_nt3v89Ev");}
void  S473C4_nt ::v90(){vfunc_called(this, "_ZN9S473C4_nt3v90Ev");}
void  S473C4_nt ::v91(){vfunc_called(this, "_ZN9S473C4_nt3v91Ev");}
void  S473C4_nt ::v92(){vfunc_called(this, "_ZN9S473C4_nt3v92Ev");}
void  S473C4_nt ::v93(){vfunc_called(this, "_ZN9S473C4_nt3v93Ev");}
void  S473C4_nt ::v94(){vfunc_called(this, "_ZN9S473C4_nt3v94Ev");}
void  S473C4_nt ::v95(){vfunc_called(this, "_ZN9S473C4_nt3v95Ev");}
S473C4_nt ::S473C4_nt(){ note_ctor("S473C4_nt", this);} // tgen

//skip512 S473C4_nt

#else // __cplusplus

extern void _ZN9S473C4_ntC1Ev();
extern void _ZN9S473C4_ntD1Ev();
Name_Map name_map_S473C4_nt[] = {
  NSPAIR(_ZN9S473C4_ntC1Ev),
  NSPAIR(_ZN9S473C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S473C5_nt;
extern VTBL_ENTRY _ZTI9S473C5_nt[];
extern  VTBL_ENTRY _ZTV9S473C5_nt[];
static Base_Class bases_S473C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S473C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S473C4_nt[];
extern void _ZN9S473C4_ntD1Ev();
extern void _ZN9S473C4_ntD0Ev();
extern void _ZN9S473C5_nt3v10Ev();
extern void _ZN9S473C5_nt3v11Ev();
extern void _ZN9S473C5_nt3v12Ev();
extern void _ZN9S473C5_nt3v13Ev();
extern void _ZN9S473C5_nt3v14Ev();
extern void _ZN9S473C5_nt3v15Ev();
extern void _ZN9S473C5_nt3v16Ev();
extern void _ZN9S473C5_nt3v17Ev();
extern void _ZN9S473C5_nt3v18Ev();
extern void _ZN9S473C5_nt3v19Ev();
extern void _ZN9S473C5_nt3v20Ev();
extern void _ZN9S473C5_nt3v21Ev();
extern void _ZN9S473C5_nt3v22Ev();
extern void _ZN9S473C5_nt3v23Ev();
extern void _ZN9S473C5_nt3v24Ev();
extern void _ZN9S473C5_nt3v25Ev();
extern void _ZN9S473C5_nt3v26Ev();
extern void _ZN9S473C5_nt3v27Ev();
extern void _ZN9S473C5_nt3v28Ev();
extern void _ZN9S473C5_nt3v29Ev();
extern void _ZN9S473C5_nt3v30Ev();
extern void _ZN9S473C5_nt3v31Ev();
extern void _ZN9S473C5_nt3v32Ev();
extern void _ZN9S473C5_nt3v33Ev();
extern void _ZN9S473C5_nt3v34Ev();
extern void _ZN9S473C5_nt3v35Ev();
extern void _ZN9S473C5_nt3v36Ev();
extern void _ZN9S473C5_nt3v37Ev();
extern void _ZN9S473C5_nt3v38Ev();
extern void _ZN9S473C5_nt3v39Ev();
extern void _ZN9S473C5_nt3v40Ev();
extern void _ZN9S473C5_nt3v41Ev();
extern void _ZN9S473C5_nt3v42Ev();
extern void _ZN9S473C5_nt3v43Ev();
extern void _ZN9S473C5_nt3v44Ev();
extern void _ZN9S473C5_nt3v45Ev();
extern void _ZN9S473C5_nt3v46Ev();
extern void _ZN9S473C5_nt3v47Ev();
extern void _ZN9S473C5_nt3v48Ev();
extern void _ZN9S473C5_nt3v49Ev();
extern void _ZN9S473C5_nt3v50Ev();
extern void _ZN9S473C5_nt3v51Ev();
extern void _ZN9S473C5_nt3v52Ev();
extern void _ZN9S473C5_nt3v53Ev();
extern void _ZN9S473C5_nt3v54Ev();
extern void _ZN9S473C5_nt3v55Ev();
extern void _ZN9S473C5_nt3v56Ev();
extern void _ZN9S473C5_nt3v57Ev();
extern void _ZN9S473C5_nt3v58Ev();
extern void _ZN9S473C5_nt3v59Ev();
extern void _ZN9S473C5_nt3v60Ev();
extern void _ZN9S473C5_nt3v61Ev();
extern void _ZN9S473C5_nt3v62Ev();
extern void _ZN9S473C5_nt3v63Ev();
extern void _ZN9S473C5_nt3v64Ev();
extern void _ZN9S473C5_nt3v65Ev();
extern void _ZN9S473C5_nt3v66Ev();
extern void _ZN9S473C5_nt3v67Ev();
extern void _ZN9S473C5_nt3v68Ev();
extern void _ZN9S473C5_nt3v69Ev();
extern void _ZN9S473C5_nt3v70Ev();
extern void _ZN9S473C5_nt3v71Ev();
extern void _ZN9S473C5_nt3v72Ev();
extern void _ZN9S473C5_nt3v73Ev();
extern void _ZN9S473C4_nt3v74Ev();
extern void _ZN9S473C4_nt3v75Ev();
extern void _ZN9S473C4_nt3v76Ev();
extern void _ZN9S473C4_nt3v77Ev();
extern void _ZN9S473C4_nt3v78Ev();
extern void _ZN9S473C4_nt3v79Ev();
extern void _ZN9S473C4_nt3v80Ev();
extern void _ZN9S473C4_nt3v81Ev();
extern void _ZN9S473C4_nt3v82Ev();
extern void _ZN9S473C4_nt3v83Ev();
extern void _ZN9S473C4_nt3v84Ev();
extern void _ZN9S473C4_nt3v85Ev();
extern void _ZN9S473C4_nt3v86Ev();
extern void _ZN9S473C4_nt3v87Ev();
extern void _ZN9S473C4_nt3v88Ev();
extern void _ZN9S473C4_nt3v89Ev();
extern void _ZN9S473C4_nt3v90Ev();
extern void _ZN9S473C4_nt3v91Ev();
extern void _ZN9S473C4_nt3v92Ev();
extern void _ZN9S473C4_nt3v93Ev();
extern void _ZN9S473C4_nt3v94Ev();
extern void _ZN9S473C4_nt3v95Ev();
static  VTBL_ENTRY vtc_S473C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S473C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S473C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S473C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v95Ev,
};
extern VTBL_ENTRY _ZTI9S473C4_nt[];
VTBL_ENTRY *P__ZTI9S473C4_nt = _ZTI9S473C4_nt; 
extern  VTBL_ENTRY _ZTV9S473C4_nt[];
Class_Descriptor cd_S473C4_nt = {  "S473C4_nt", // class name
  bases_S473C4_nt, 1,
  &(vtc_S473C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S473C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S473C4_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C3  : S473C4_nt {
  ::S473C6_nt s473c3f0;
  virtual  ~S473C3(); // _ZN6S473C3D1Ev
  virtual void  v96(); // _ZN6S473C33v96Ev
  virtual void  v97(); // _ZN6S473C33v97Ev
  virtual void  v98(); // _ZN6S473C33v98Ev
  virtual void  v99(); // _ZN6S473C33v99Ev
  virtual void  v100(); // _ZN6S473C34v100Ev
  virtual void  v101(); // _ZN6S473C34v101Ev
  virtual void  v102(); // _ZN6S473C34v102Ev
  virtual void  v103(); // _ZN6S473C34v103Ev
  virtual void  v104(); // _ZN6S473C34v104Ev
  virtual void  v105(); // _ZN6S473C34v105Ev
  virtual void  v106(); // _ZN6S473C34v106Ev
  virtual void  v107(); // _ZN6S473C34v107Ev
  virtual void  v108(); // _ZN6S473C34v108Ev
  virtual void  v109(); // _ZN6S473C34v109Ev
  virtual void  v110(); // _ZN6S473C34v110Ev
  virtual void  v111(); // _ZN6S473C34v111Ev
  virtual void  v112(); // _ZN6S473C34v112Ev
  virtual void  v113(); // _ZN6S473C34v113Ev
  virtual void  v114(); // _ZN6S473C34v114Ev
  S473C3(); // tgen
};
//SIG(-1 S473C3) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S473C3 ::~S473C3(){ note_dtor("S473C3", this);}
void  S473C3 ::v96(){vfunc_called(this, "_ZN6S473C33v96Ev");}
void  S473C3 ::v97(){vfunc_called(this, "_ZN6S473C33v97Ev");}
void  S473C3 ::v98(){vfunc_called(this, "_ZN6S473C33v98Ev");}
void  S473C3 ::v99(){vfunc_called(this, "_ZN6S473C33v99Ev");}
void  S473C3 ::v100(){vfunc_called(this, "_ZN6S473C34v100Ev");}
void  S473C3 ::v101(){vfunc_called(this, "_ZN6S473C34v101Ev");}
void  S473C3 ::v102(){vfunc_called(this, "_ZN6S473C34v102Ev");}
void  S473C3 ::v103(){vfunc_called(this, "_ZN6S473C34v103Ev");}
void  S473C3 ::v104(){vfunc_called(this, "_ZN6S473C34v104Ev");}
void  S473C3 ::v105(){vfunc_called(this, "_ZN6S473C34v105Ev");}
void  S473C3 ::v106(){vfunc_called(this, "_ZN6S473C34v106Ev");}
void  S473C3 ::v107(){vfunc_called(this, "_ZN6S473C34v107Ev");}
void  S473C3 ::v108(){vfunc_called(this, "_ZN6S473C34v108Ev");}
void  S473C3 ::v109(){vfunc_called(this, "_ZN6S473C34v109Ev");}
void  S473C3 ::v110(){vfunc_called(this, "_ZN6S473C34v110Ev");}
void  S473C3 ::v111(){vfunc_called(this, "_ZN6S473C34v111Ev");}
void  S473C3 ::v112(){vfunc_called(this, "_ZN6S473C34v112Ev");}
void  S473C3 ::v113(){vfunc_called(this, "_ZN6S473C34v113Ev");}
void  S473C3 ::v114(){vfunc_called(this, "_ZN6S473C34v114Ev");}
S473C3 ::S473C3(){ note_ctor("S473C3", this);} // tgen

static void Test_S473C3()
{
  extern Class_Descriptor cd_S473C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S473C3, buf);
    S473C3 *dp, &lv = *(dp=new (buf) S473C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S473C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S473C3)");
    check_base_class_offset(lv, (S473C5_nt*)(S473C4_nt*), 0, "S473C3");
    check_base_class_offset(lv, (S473C4_nt*), 0, "S473C3");
    check_field_offset(lv, s473c3f0, ABISELECT(188,132), "S473C3.s473c3f0");
    test_class_info(&lv, &cd_S473C3);
    dp->~S473C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS473C3(Test_S473C3, "S473C3", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S473C3C1Ev();
extern void _ZN6S473C3D1Ev();
Name_Map name_map_S473C3[] = {
  NSPAIR(_ZN6S473C3C1Ev),
  NSPAIR(_ZN6S473C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S473C5_nt;
extern VTBL_ENTRY _ZTI9S473C5_nt[];
extern  VTBL_ENTRY _ZTV9S473C5_nt[];
extern Class_Descriptor cd_S473C4_nt;
extern VTBL_ENTRY _ZTI9S473C4_nt[];
extern  VTBL_ENTRY _ZTV9S473C4_nt[];
static Base_Class bases_S473C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S473C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S473C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S473C3[];
extern void _ZN6S473C3D1Ev();
extern void _ZN6S473C3D0Ev();
extern void _ZN9S473C5_nt3v10Ev();
extern void _ZN9S473C5_nt3v11Ev();
extern void _ZN9S473C5_nt3v12Ev();
extern void _ZN9S473C5_nt3v13Ev();
extern void _ZN9S473C5_nt3v14Ev();
extern void _ZN9S473C5_nt3v15Ev();
extern void _ZN9S473C5_nt3v16Ev();
extern void _ZN9S473C5_nt3v17Ev();
extern void _ZN9S473C5_nt3v18Ev();
extern void _ZN9S473C5_nt3v19Ev();
extern void _ZN9S473C5_nt3v20Ev();
extern void _ZN9S473C5_nt3v21Ev();
extern void _ZN9S473C5_nt3v22Ev();
extern void _ZN9S473C5_nt3v23Ev();
extern void _ZN9S473C5_nt3v24Ev();
extern void _ZN9S473C5_nt3v25Ev();
extern void _ZN9S473C5_nt3v26Ev();
extern void _ZN9S473C5_nt3v27Ev();
extern void _ZN9S473C5_nt3v28Ev();
extern void _ZN9S473C5_nt3v29Ev();
extern void _ZN9S473C5_nt3v30Ev();
extern void _ZN9S473C5_nt3v31Ev();
extern void _ZN9S473C5_nt3v32Ev();
extern void _ZN9S473C5_nt3v33Ev();
extern void _ZN9S473C5_nt3v34Ev();
extern void _ZN9S473C5_nt3v35Ev();
extern void _ZN9S473C5_nt3v36Ev();
extern void _ZN9S473C5_nt3v37Ev();
extern void _ZN9S473C5_nt3v38Ev();
extern void _ZN9S473C5_nt3v39Ev();
extern void _ZN9S473C5_nt3v40Ev();
extern void _ZN9S473C5_nt3v41Ev();
extern void _ZN9S473C5_nt3v42Ev();
extern void _ZN9S473C5_nt3v43Ev();
extern void _ZN9S473C5_nt3v44Ev();
extern void _ZN9S473C5_nt3v45Ev();
extern void _ZN9S473C5_nt3v46Ev();
extern void _ZN9S473C5_nt3v47Ev();
extern void _ZN9S473C5_nt3v48Ev();
extern void _ZN9S473C5_nt3v49Ev();
extern void _ZN9S473C5_nt3v50Ev();
extern void _ZN9S473C5_nt3v51Ev();
extern void _ZN9S473C5_nt3v52Ev();
extern void _ZN9S473C5_nt3v53Ev();
extern void _ZN9S473C5_nt3v54Ev();
extern void _ZN9S473C5_nt3v55Ev();
extern void _ZN9S473C5_nt3v56Ev();
extern void _ZN9S473C5_nt3v57Ev();
extern void _ZN9S473C5_nt3v58Ev();
extern void _ZN9S473C5_nt3v59Ev();
extern void _ZN9S473C5_nt3v60Ev();
extern void _ZN9S473C5_nt3v61Ev();
extern void _ZN9S473C5_nt3v62Ev();
extern void _ZN9S473C5_nt3v63Ev();
extern void _ZN9S473C5_nt3v64Ev();
extern void _ZN9S473C5_nt3v65Ev();
extern void _ZN9S473C5_nt3v66Ev();
extern void _ZN9S473C5_nt3v67Ev();
extern void _ZN9S473C5_nt3v68Ev();
extern void _ZN9S473C5_nt3v69Ev();
extern void _ZN9S473C5_nt3v70Ev();
extern void _ZN9S473C5_nt3v71Ev();
extern void _ZN9S473C5_nt3v72Ev();
extern void _ZN9S473C5_nt3v73Ev();
extern void _ZN9S473C4_nt3v74Ev();
extern void _ZN9S473C4_nt3v75Ev();
extern void _ZN9S473C4_nt3v76Ev();
extern void _ZN9S473C4_nt3v77Ev();
extern void _ZN9S473C4_nt3v78Ev();
extern void _ZN9S473C4_nt3v79Ev();
extern void _ZN9S473C4_nt3v80Ev();
extern void _ZN9S473C4_nt3v81Ev();
extern void _ZN9S473C4_nt3v82Ev();
extern void _ZN9S473C4_nt3v83Ev();
extern void _ZN9S473C4_nt3v84Ev();
extern void _ZN9S473C4_nt3v85Ev();
extern void _ZN9S473C4_nt3v86Ev();
extern void _ZN9S473C4_nt3v87Ev();
extern void _ZN9S473C4_nt3v88Ev();
extern void _ZN9S473C4_nt3v89Ev();
extern void _ZN9S473C4_nt3v90Ev();
extern void _ZN9S473C4_nt3v91Ev();
extern void _ZN9S473C4_nt3v92Ev();
extern void _ZN9S473C4_nt3v93Ev();
extern void _ZN9S473C4_nt3v94Ev();
extern void _ZN9S473C4_nt3v95Ev();
extern void _ZN6S473C33v96Ev();
extern void _ZN6S473C33v97Ev();
extern void _ZN6S473C33v98Ev();
extern void _ZN6S473C33v99Ev();
extern void _ZN6S473C34v100Ev();
extern void _ZN6S473C34v101Ev();
extern void _ZN6S473C34v102Ev();
extern void _ZN6S473C34v103Ev();
extern void _ZN6S473C34v104Ev();
extern void _ZN6S473C34v105Ev();
extern void _ZN6S473C34v106Ev();
extern void _ZN6S473C34v107Ev();
extern void _ZN6S473C34v108Ev();
extern void _ZN6S473C34v109Ev();
extern void _ZN6S473C34v110Ev();
extern void _ZN6S473C34v111Ev();
extern void _ZN6S473C34v112Ev();
extern void _ZN6S473C34v113Ev();
extern void _ZN6S473C34v114Ev();
static  VTBL_ENTRY vtc_S473C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S473C3[0]),
  (VTBL_ENTRY)&_ZN6S473C3D1Ev,
  (VTBL_ENTRY)&_ZN6S473C3D0Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN6S473C33v96Ev,
  (VTBL_ENTRY)&_ZN6S473C33v97Ev,
  (VTBL_ENTRY)&_ZN6S473C33v98Ev,
  (VTBL_ENTRY)&_ZN6S473C33v99Ev,
  (VTBL_ENTRY)&_ZN6S473C34v100Ev,
  (VTBL_ENTRY)&_ZN6S473C34v101Ev,
  (VTBL_ENTRY)&_ZN6S473C34v102Ev,
  (VTBL_ENTRY)&_ZN6S473C34v103Ev,
  (VTBL_ENTRY)&_ZN6S473C34v104Ev,
  (VTBL_ENTRY)&_ZN6S473C34v105Ev,
  (VTBL_ENTRY)&_ZN6S473C34v106Ev,
  (VTBL_ENTRY)&_ZN6S473C34v107Ev,
  (VTBL_ENTRY)&_ZN6S473C34v108Ev,
  (VTBL_ENTRY)&_ZN6S473C34v109Ev,
  (VTBL_ENTRY)&_ZN6S473C34v110Ev,
  (VTBL_ENTRY)&_ZN6S473C34v111Ev,
  (VTBL_ENTRY)&_ZN6S473C34v112Ev,
  (VTBL_ENTRY)&_ZN6S473C34v113Ev,
  (VTBL_ENTRY)&_ZN6S473C34v114Ev,
};
extern VTBL_ENTRY _ZTI6S473C3[];
extern  VTBL_ENTRY _ZTV6S473C3[];
Class_Descriptor cd_S473C3 = {  "S473C3", // class name
  bases_S473C3, 2,
  &(vtc_S473C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S473C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S473C3),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C2  : S473C3 {
  void *s473c2f0;
  virtual  ~S473C2(); // _ZN6S473C2D1Ev
  virtual void  v115(); // _ZN6S473C24v115Ev
  virtual void  v116(); // _ZN6S473C24v116Ev
  virtual void  v117(); // _ZN6S473C24v117Ev
  virtual void  v118(); // _ZN6S473C24v118Ev
  virtual void  v119(); // _ZN6S473C24v119Ev
  virtual void  v120(); // _ZN6S473C24v120Ev
  virtual void  v121(); // _ZN6S473C24v121Ev
  virtual void  v122(); // _ZN6S473C24v122Ev
  virtual void  v123(); // _ZN6S473C24v123Ev
  S473C2(); // tgen
};
//SIG(-1 S473C2) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 FC5} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp}


 S473C2 ::~S473C2(){ note_dtor("S473C2", this);}
void  S473C2 ::v115(){vfunc_called(this, "_ZN6S473C24v115Ev");}
void  S473C2 ::v116(){vfunc_called(this, "_ZN6S473C24v116Ev");}
void  S473C2 ::v117(){vfunc_called(this, "_ZN6S473C24v117Ev");}
void  S473C2 ::v118(){vfunc_called(this, "_ZN6S473C24v118Ev");}
void  S473C2 ::v119(){vfunc_called(this, "_ZN6S473C24v119Ev");}
void  S473C2 ::v120(){vfunc_called(this, "_ZN6S473C24v120Ev");}
void  S473C2 ::v121(){vfunc_called(this, "_ZN6S473C24v121Ev");}
void  S473C2 ::v122(){vfunc_called(this, "_ZN6S473C24v122Ev");}
void  S473C2 ::v123(){vfunc_called(this, "_ZN6S473C24v123Ev");}
S473C2 ::S473C2(){ note_ctor("S473C2", this);} // tgen

static void Test_S473C2()
{
  extern Class_Descriptor cd_S473C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,37)];
    init_test(&cd_S473C2, buf);
    S473C2 *dp, &lv = *(dp=new (buf) S473C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,144), "sizeof(S473C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S473C2)");
    check_base_class_offset(lv, (S473C5_nt*)(S473C4_nt*)(S473C3*), 0, "S473C2");
    check_base_class_offset(lv, (S473C4_nt*)(S473C3*), 0, "S473C2");
    check_base_class_offset(lv, (S473C3*), 0, "S473C2");
    check_field_offset(lv, s473c2f0, ABISELECT(200,140), "S473C2.s473c2f0");
    test_class_info(&lv, &cd_S473C2);
    dp->~S473C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS473C2(Test_S473C2, "S473C2", ABISELECT(208,144));

#else // __cplusplus

extern void _ZN6S473C2C1Ev();
extern void _ZN6S473C2D1Ev();
Name_Map name_map_S473C2[] = {
  NSPAIR(_ZN6S473C2C1Ev),
  NSPAIR(_ZN6S473C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S473C5_nt;
extern VTBL_ENTRY _ZTI9S473C5_nt[];
extern  VTBL_ENTRY _ZTV9S473C5_nt[];
extern Class_Descriptor cd_S473C4_nt;
extern VTBL_ENTRY _ZTI9S473C4_nt[];
extern  VTBL_ENTRY _ZTV9S473C4_nt[];
extern Class_Descriptor cd_S473C3;
extern VTBL_ENTRY _ZTI6S473C3[];
extern  VTBL_ENTRY _ZTV6S473C3[];
static Base_Class bases_S473C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S473C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S473C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S473C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S473C2[];
extern void _ZN6S473C2D1Ev();
extern void _ZN6S473C2D0Ev();
extern void _ZN9S473C5_nt3v10Ev();
extern void _ZN9S473C5_nt3v11Ev();
extern void _ZN9S473C5_nt3v12Ev();
extern void _ZN9S473C5_nt3v13Ev();
extern void _ZN9S473C5_nt3v14Ev();
extern void _ZN9S473C5_nt3v15Ev();
extern void _ZN9S473C5_nt3v16Ev();
extern void _ZN9S473C5_nt3v17Ev();
extern void _ZN9S473C5_nt3v18Ev();
extern void _ZN9S473C5_nt3v19Ev();
extern void _ZN9S473C5_nt3v20Ev();
extern void _ZN9S473C5_nt3v21Ev();
extern void _ZN9S473C5_nt3v22Ev();
extern void _ZN9S473C5_nt3v23Ev();
extern void _ZN9S473C5_nt3v24Ev();
extern void _ZN9S473C5_nt3v25Ev();
extern void _ZN9S473C5_nt3v26Ev();
extern void _ZN9S473C5_nt3v27Ev();
extern void _ZN9S473C5_nt3v28Ev();
extern void _ZN9S473C5_nt3v29Ev();
extern void _ZN9S473C5_nt3v30Ev();
extern void _ZN9S473C5_nt3v31Ev();
extern void _ZN9S473C5_nt3v32Ev();
extern void _ZN9S473C5_nt3v33Ev();
extern void _ZN9S473C5_nt3v34Ev();
extern void _ZN9S473C5_nt3v35Ev();
extern void _ZN9S473C5_nt3v36Ev();
extern void _ZN9S473C5_nt3v37Ev();
extern void _ZN9S473C5_nt3v38Ev();
extern void _ZN9S473C5_nt3v39Ev();
extern void _ZN9S473C5_nt3v40Ev();
extern void _ZN9S473C5_nt3v41Ev();
extern void _ZN9S473C5_nt3v42Ev();
extern void _ZN9S473C5_nt3v43Ev();
extern void _ZN9S473C5_nt3v44Ev();
extern void _ZN9S473C5_nt3v45Ev();
extern void _ZN9S473C5_nt3v46Ev();
extern void _ZN9S473C5_nt3v47Ev();
extern void _ZN9S473C5_nt3v48Ev();
extern void _ZN9S473C5_nt3v49Ev();
extern void _ZN9S473C5_nt3v50Ev();
extern void _ZN9S473C5_nt3v51Ev();
extern void _ZN9S473C5_nt3v52Ev();
extern void _ZN9S473C5_nt3v53Ev();
extern void _ZN9S473C5_nt3v54Ev();
extern void _ZN9S473C5_nt3v55Ev();
extern void _ZN9S473C5_nt3v56Ev();
extern void _ZN9S473C5_nt3v57Ev();
extern void _ZN9S473C5_nt3v58Ev();
extern void _ZN9S473C5_nt3v59Ev();
extern void _ZN9S473C5_nt3v60Ev();
extern void _ZN9S473C5_nt3v61Ev();
extern void _ZN9S473C5_nt3v62Ev();
extern void _ZN9S473C5_nt3v63Ev();
extern void _ZN9S473C5_nt3v64Ev();
extern void _ZN9S473C5_nt3v65Ev();
extern void _ZN9S473C5_nt3v66Ev();
extern void _ZN9S473C5_nt3v67Ev();
extern void _ZN9S473C5_nt3v68Ev();
extern void _ZN9S473C5_nt3v69Ev();
extern void _ZN9S473C5_nt3v70Ev();
extern void _ZN9S473C5_nt3v71Ev();
extern void _ZN9S473C5_nt3v72Ev();
extern void _ZN9S473C5_nt3v73Ev();
extern void _ZN9S473C4_nt3v74Ev();
extern void _ZN9S473C4_nt3v75Ev();
extern void _ZN9S473C4_nt3v76Ev();
extern void _ZN9S473C4_nt3v77Ev();
extern void _ZN9S473C4_nt3v78Ev();
extern void _ZN9S473C4_nt3v79Ev();
extern void _ZN9S473C4_nt3v80Ev();
extern void _ZN9S473C4_nt3v81Ev();
extern void _ZN9S473C4_nt3v82Ev();
extern void _ZN9S473C4_nt3v83Ev();
extern void _ZN9S473C4_nt3v84Ev();
extern void _ZN9S473C4_nt3v85Ev();
extern void _ZN9S473C4_nt3v86Ev();
extern void _ZN9S473C4_nt3v87Ev();
extern void _ZN9S473C4_nt3v88Ev();
extern void _ZN9S473C4_nt3v89Ev();
extern void _ZN9S473C4_nt3v90Ev();
extern void _ZN9S473C4_nt3v91Ev();
extern void _ZN9S473C4_nt3v92Ev();
extern void _ZN9S473C4_nt3v93Ev();
extern void _ZN9S473C4_nt3v94Ev();
extern void _ZN9S473C4_nt3v95Ev();
extern void _ZN6S473C33v96Ev();
extern void _ZN6S473C33v97Ev();
extern void _ZN6S473C33v98Ev();
extern void _ZN6S473C33v99Ev();
extern void _ZN6S473C34v100Ev();
extern void _ZN6S473C34v101Ev();
extern void _ZN6S473C34v102Ev();
extern void _ZN6S473C34v103Ev();
extern void _ZN6S473C34v104Ev();
extern void _ZN6S473C34v105Ev();
extern void _ZN6S473C34v106Ev();
extern void _ZN6S473C34v107Ev();
extern void _ZN6S473C34v108Ev();
extern void _ZN6S473C34v109Ev();
extern void _ZN6S473C34v110Ev();
extern void _ZN6S473C34v111Ev();
extern void _ZN6S473C34v112Ev();
extern void _ZN6S473C34v113Ev();
extern void _ZN6S473C34v114Ev();
extern void _ZN6S473C24v115Ev();
extern void _ZN6S473C24v116Ev();
extern void _ZN6S473C24v117Ev();
extern void _ZN6S473C24v118Ev();
extern void _ZN6S473C24v119Ev();
extern void _ZN6S473C24v120Ev();
extern void _ZN6S473C24v121Ev();
extern void _ZN6S473C24v122Ev();
extern void _ZN6S473C24v123Ev();
static  VTBL_ENTRY vtc_S473C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S473C2[0]),
  (VTBL_ENTRY)&_ZN6S473C2D1Ev,
  (VTBL_ENTRY)&_ZN6S473C2D0Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN6S473C33v96Ev,
  (VTBL_ENTRY)&_ZN6S473C33v97Ev,
  (VTBL_ENTRY)&_ZN6S473C33v98Ev,
  (VTBL_ENTRY)&_ZN6S473C33v99Ev,
  (VTBL_ENTRY)&_ZN6S473C34v100Ev,
  (VTBL_ENTRY)&_ZN6S473C34v101Ev,
  (VTBL_ENTRY)&_ZN6S473C34v102Ev,
  (VTBL_ENTRY)&_ZN6S473C34v103Ev,
  (VTBL_ENTRY)&_ZN6S473C34v104Ev,
  (VTBL_ENTRY)&_ZN6S473C34v105Ev,
  (VTBL_ENTRY)&_ZN6S473C34v106Ev,
  (VTBL_ENTRY)&_ZN6S473C34v107Ev,
  (VTBL_ENTRY)&_ZN6S473C34v108Ev,
  (VTBL_ENTRY)&_ZN6S473C34v109Ev,
  (VTBL_ENTRY)&_ZN6S473C34v110Ev,
  (VTBL_ENTRY)&_ZN6S473C34v111Ev,
  (VTBL_ENTRY)&_ZN6S473C34v112Ev,
  (VTBL_ENTRY)&_ZN6S473C34v113Ev,
  (VTBL_ENTRY)&_ZN6S473C34v114Ev,
  (VTBL_ENTRY)&_ZN6S473C24v115Ev,
  (VTBL_ENTRY)&_ZN6S473C24v116Ev,
  (VTBL_ENTRY)&_ZN6S473C24v117Ev,
  (VTBL_ENTRY)&_ZN6S473C24v118Ev,
  (VTBL_ENTRY)&_ZN6S473C24v119Ev,
  (VTBL_ENTRY)&_ZN6S473C24v120Ev,
  (VTBL_ENTRY)&_ZN6S473C24v121Ev,
  (VTBL_ENTRY)&_ZN6S473C24v122Ev,
  (VTBL_ENTRY)&_ZN6S473C24v123Ev,
};
extern VTBL_ENTRY _ZTI6S473C2[];
extern  VTBL_ENTRY _ZTV6S473C2[];
Class_Descriptor cd_S473C2 = {  "S473C2", // class name
  bases_S473C2, 3,
  &(vtc_S473C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,144), // object size
  NSPAIRA(_ZTI6S473C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S473C2),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C13_nt  {
  int s473c13f0[5];
};
//SIG(-1 S473C13_nt) C1{ Fi[5]}



//skip512 S473C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C12_nt  {
  ::S473C13_nt s473c12f0;
  ::S473C6_nt s473c12f1;
  void *s473c12f2;
  unsigned int s473c12f3:1;
};
//SIG(-1 S473C12_nt) C1{ FC2{ Fi[5]} FC3{ m Fi[2]} Fp Fi:1}



//skip512 S473C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S473C1  : S473C2 {
  ::S473C12_nt s473c1f0;
  virtual  ~S473C1(); // _ZN6S473C1D1Ev
  virtual void  v1(); // _ZN6S473C12v1Ev
  virtual void  v2(); // _ZN6S473C12v2Ev
  virtual void  v3(); // _ZN6S473C12v3Ev
  virtual void  v4(); // _ZN6S473C12v4Ev
  virtual void  v5(); // _ZN6S473C12v5Ev
  virtual void  v6(); // _ZN6S473C12v6Ev
  virtual void  v7(); // _ZN6S473C12v7Ev
  virtual void  v8(); // _ZN6S473C12v8Ev
  virtual void  v9(); // _ZN6S473C12v9Ev
  S473C1(); // tgen
};
//SIG(1 S473C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 FC6} vd v115 v116 v117 v118 v119 v120 v121 v122 v123 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC12{ FC13{ Fi[5]} FC6 Fp Fi:1}}


 S473C1 ::~S473C1(){ note_dtor("S473C1", this);}
void  S473C1 ::v1(){vfunc_called(this, "_ZN6S473C12v1Ev");}
void  S473C1 ::v2(){vfunc_called(this, "_ZN6S473C12v2Ev");}
void  S473C1 ::v3(){vfunc_called(this, "_ZN6S473C12v3Ev");}
void  S473C1 ::v4(){vfunc_called(this, "_ZN6S473C12v4Ev");}
void  S473C1 ::v5(){vfunc_called(this, "_ZN6S473C12v5Ev");}
void  S473C1 ::v6(){vfunc_called(this, "_ZN6S473C12v6Ev");}
void  S473C1 ::v7(){vfunc_called(this, "_ZN6S473C12v7Ev");}
void  S473C1 ::v8(){vfunc_called(this, "_ZN6S473C12v8Ev");}
void  S473C1 ::v9(){vfunc_called(this, "_ZN6S473C12v9Ev");}
S473C1 ::S473C1(){ note_ctor("S473C1", this);} // tgen

static void Test_S473C1()
{
  extern Class_Descriptor cd_S473C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,46)];
    init_test(&cd_S473C1, buf);
    S473C1 *dp, &lv = *(dp=new (buf) S473C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,180), "sizeof(S473C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S473C1)");
    check_base_class_offset(lv, (S473C5_nt*)(S473C4_nt*)(S473C3*)(S473C2*), 0, "S473C1");
    check_base_class_offset(lv, (S473C4_nt*)(S473C3*)(S473C2*), 0, "S473C1");
    check_base_class_offset(lv, (S473C3*)(S473C2*), 0, "S473C1");
    check_base_class_offset(lv, (S473C2*), 0, "S473C1");
    check_field_offset(lv, s473c1f0, ABISELECT(208,144), "S473C1.s473c1f0");
    test_class_info(&lv, &cd_S473C1);
    dp->~S473C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS473C1(Test_S473C1, "S473C1", ABISELECT(256,180));

#else // __cplusplus

extern void _ZN6S473C1C1Ev();
extern void _ZN6S473C1D1Ev();
Name_Map name_map_S473C1[] = {
  NSPAIR(_ZN6S473C1C1Ev),
  NSPAIR(_ZN6S473C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S473C5_nt;
extern VTBL_ENTRY _ZTI9S473C5_nt[];
extern  VTBL_ENTRY _ZTV9S473C5_nt[];
extern Class_Descriptor cd_S473C4_nt;
extern VTBL_ENTRY _ZTI9S473C4_nt[];
extern  VTBL_ENTRY _ZTV9S473C4_nt[];
extern Class_Descriptor cd_S473C3;
extern VTBL_ENTRY _ZTI6S473C3[];
extern  VTBL_ENTRY _ZTV6S473C3[];
extern Class_Descriptor cd_S473C2;
extern VTBL_ENTRY _ZTI6S473C2[];
extern  VTBL_ENTRY _ZTV6S473C2[];
static Base_Class bases_S473C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S473C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S473C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S473C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S473C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S473C1[];
extern void _ZN6S473C1D1Ev();
extern void _ZN6S473C1D0Ev();
extern void _ZN9S473C5_nt3v10Ev();
extern void _ZN9S473C5_nt3v11Ev();
extern void _ZN9S473C5_nt3v12Ev();
extern void _ZN9S473C5_nt3v13Ev();
extern void _ZN9S473C5_nt3v14Ev();
extern void _ZN9S473C5_nt3v15Ev();
extern void _ZN9S473C5_nt3v16Ev();
extern void _ZN9S473C5_nt3v17Ev();
extern void _ZN9S473C5_nt3v18Ev();
extern void _ZN9S473C5_nt3v19Ev();
extern void _ZN9S473C5_nt3v20Ev();
extern void _ZN9S473C5_nt3v21Ev();
extern void _ZN9S473C5_nt3v22Ev();
extern void _ZN9S473C5_nt3v23Ev();
extern void _ZN9S473C5_nt3v24Ev();
extern void _ZN9S473C5_nt3v25Ev();
extern void _ZN9S473C5_nt3v26Ev();
extern void _ZN9S473C5_nt3v27Ev();
extern void _ZN9S473C5_nt3v28Ev();
extern void _ZN9S473C5_nt3v29Ev();
extern void _ZN9S473C5_nt3v30Ev();
extern void _ZN9S473C5_nt3v31Ev();
extern void _ZN9S473C5_nt3v32Ev();
extern void _ZN9S473C5_nt3v33Ev();
extern void _ZN9S473C5_nt3v34Ev();
extern void _ZN9S473C5_nt3v35Ev();
extern void _ZN9S473C5_nt3v36Ev();
extern void _ZN9S473C5_nt3v37Ev();
extern void _ZN9S473C5_nt3v38Ev();
extern void _ZN9S473C5_nt3v39Ev();
extern void _ZN9S473C5_nt3v40Ev();
extern void _ZN9S473C5_nt3v41Ev();
extern void _ZN9S473C5_nt3v42Ev();
extern void _ZN9S473C5_nt3v43Ev();
extern void _ZN9S473C5_nt3v44Ev();
extern void _ZN9S473C5_nt3v45Ev();
extern void _ZN9S473C5_nt3v46Ev();
extern void _ZN9S473C5_nt3v47Ev();
extern void _ZN9S473C5_nt3v48Ev();
extern void _ZN9S473C5_nt3v49Ev();
extern void _ZN9S473C5_nt3v50Ev();
extern void _ZN9S473C5_nt3v51Ev();
extern void _ZN9S473C5_nt3v52Ev();
extern void _ZN9S473C5_nt3v53Ev();
extern void _ZN9S473C5_nt3v54Ev();
extern void _ZN9S473C5_nt3v55Ev();
extern void _ZN9S473C5_nt3v56Ev();
extern void _ZN9S473C5_nt3v57Ev();
extern void _ZN9S473C5_nt3v58Ev();
extern void _ZN9S473C5_nt3v59Ev();
extern void _ZN9S473C5_nt3v60Ev();
extern void _ZN9S473C5_nt3v61Ev();
extern void _ZN9S473C5_nt3v62Ev();
extern void _ZN9S473C5_nt3v63Ev();
extern void _ZN9S473C5_nt3v64Ev();
extern void _ZN9S473C5_nt3v65Ev();
extern void _ZN9S473C5_nt3v66Ev();
extern void _ZN9S473C5_nt3v67Ev();
extern void _ZN9S473C5_nt3v68Ev();
extern void _ZN9S473C5_nt3v69Ev();
extern void _ZN9S473C5_nt3v70Ev();
extern void _ZN9S473C5_nt3v71Ev();
extern void _ZN9S473C5_nt3v72Ev();
extern void _ZN9S473C5_nt3v73Ev();
extern void _ZN9S473C4_nt3v74Ev();
extern void _ZN9S473C4_nt3v75Ev();
extern void _ZN9S473C4_nt3v76Ev();
extern void _ZN9S473C4_nt3v77Ev();
extern void _ZN9S473C4_nt3v78Ev();
extern void _ZN9S473C4_nt3v79Ev();
extern void _ZN9S473C4_nt3v80Ev();
extern void _ZN9S473C4_nt3v81Ev();
extern void _ZN9S473C4_nt3v82Ev();
extern void _ZN9S473C4_nt3v83Ev();
extern void _ZN9S473C4_nt3v84Ev();
extern void _ZN9S473C4_nt3v85Ev();
extern void _ZN9S473C4_nt3v86Ev();
extern void _ZN9S473C4_nt3v87Ev();
extern void _ZN9S473C4_nt3v88Ev();
extern void _ZN9S473C4_nt3v89Ev();
extern void _ZN9S473C4_nt3v90Ev();
extern void _ZN9S473C4_nt3v91Ev();
extern void _ZN9S473C4_nt3v92Ev();
extern void _ZN9S473C4_nt3v93Ev();
extern void _ZN9S473C4_nt3v94Ev();
extern void _ZN9S473C4_nt3v95Ev();
extern void _ZN6S473C33v96Ev();
extern void _ZN6S473C33v97Ev();
extern void _ZN6S473C33v98Ev();
extern void _ZN6S473C33v99Ev();
extern void _ZN6S473C34v100Ev();
extern void _ZN6S473C34v101Ev();
extern void _ZN6S473C34v102Ev();
extern void _ZN6S473C34v103Ev();
extern void _ZN6S473C34v104Ev();
extern void _ZN6S473C34v105Ev();
extern void _ZN6S473C34v106Ev();
extern void _ZN6S473C34v107Ev();
extern void _ZN6S473C34v108Ev();
extern void _ZN6S473C34v109Ev();
extern void _ZN6S473C34v110Ev();
extern void _ZN6S473C34v111Ev();
extern void _ZN6S473C34v112Ev();
extern void _ZN6S473C34v113Ev();
extern void _ZN6S473C34v114Ev();
extern void _ZN6S473C24v115Ev();
extern void _ZN6S473C24v116Ev();
extern void _ZN6S473C24v117Ev();
extern void _ZN6S473C24v118Ev();
extern void _ZN6S473C24v119Ev();
extern void _ZN6S473C24v120Ev();
extern void _ZN6S473C24v121Ev();
extern void _ZN6S473C24v122Ev();
extern void _ZN6S473C24v123Ev();
extern void _ZN6S473C12v1Ev();
extern void _ZN6S473C12v2Ev();
extern void _ZN6S473C12v3Ev();
extern void _ZN6S473C12v4Ev();
extern void _ZN6S473C12v5Ev();
extern void _ZN6S473C12v6Ev();
extern void _ZN6S473C12v7Ev();
extern void _ZN6S473C12v8Ev();
extern void _ZN6S473C12v9Ev();
static  VTBL_ENTRY vtc_S473C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S473C1[0]),
  (VTBL_ENTRY)&_ZN6S473C1D1Ev,
  (VTBL_ENTRY)&_ZN6S473C1D0Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S473C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S473C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN6S473C33v96Ev,
  (VTBL_ENTRY)&_ZN6S473C33v97Ev,
  (VTBL_ENTRY)&_ZN6S473C33v98Ev,
  (VTBL_ENTRY)&_ZN6S473C33v99Ev,
  (VTBL_ENTRY)&_ZN6S473C34v100Ev,
  (VTBL_ENTRY)&_ZN6S473C34v101Ev,
  (VTBL_ENTRY)&_ZN6S473C34v102Ev,
  (VTBL_ENTRY)&_ZN6S473C34v103Ev,
  (VTBL_ENTRY)&_ZN6S473C34v104Ev,
  (VTBL_ENTRY)&_ZN6S473C34v105Ev,
  (VTBL_ENTRY)&_ZN6S473C34v106Ev,
  (VTBL_ENTRY)&_ZN6S473C34v107Ev,
  (VTBL_ENTRY)&_ZN6S473C34v108Ev,
  (VTBL_ENTRY)&_ZN6S473C34v109Ev,
  (VTBL_ENTRY)&_ZN6S473C34v110Ev,
  (VTBL_ENTRY)&_ZN6S473C34v111Ev,
  (VTBL_ENTRY)&_ZN6S473C34v112Ev,
  (VTBL_ENTRY)&_ZN6S473C34v113Ev,
  (VTBL_ENTRY)&_ZN6S473C34v114Ev,
  (VTBL_ENTRY)&_ZN6S473C24v115Ev,
  (VTBL_ENTRY)&_ZN6S473C24v116Ev,
  (VTBL_ENTRY)&_ZN6S473C24v117Ev,
  (VTBL_ENTRY)&_ZN6S473C24v118Ev,
  (VTBL_ENTRY)&_ZN6S473C24v119Ev,
  (VTBL_ENTRY)&_ZN6S473C24v120Ev,
  (VTBL_ENTRY)&_ZN6S473C24v121Ev,
  (VTBL_ENTRY)&_ZN6S473C24v122Ev,
  (VTBL_ENTRY)&_ZN6S473C24v123Ev,
  (VTBL_ENTRY)&_ZN6S473C12v1Ev,
  (VTBL_ENTRY)&_ZN6S473C12v2Ev,
  (VTBL_ENTRY)&_ZN6S473C12v3Ev,
  (VTBL_ENTRY)&_ZN6S473C12v4Ev,
  (VTBL_ENTRY)&_ZN6S473C12v5Ev,
  (VTBL_ENTRY)&_ZN6S473C12v6Ev,
  (VTBL_ENTRY)&_ZN6S473C12v7Ev,
  (VTBL_ENTRY)&_ZN6S473C12v8Ev,
  (VTBL_ENTRY)&_ZN6S473C12v9Ev,
};
extern VTBL_ENTRY _ZTI6S473C1[];
extern  VTBL_ENTRY _ZTV6S473C1[];
Class_Descriptor cd_S473C1 = {  "S473C1", // class name
  bases_S473C1, 4,
  &(vtc_S473C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,180), // object size
  NSPAIRA(_ZTI6S473C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S473C1),127, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S672C5  {
  int s672c5f0;
  __tsi64 s672c5f1;
  void *s672c5f2[4];
  int s672c5f3[2];
  void *s672c5f4;
  ::S473C6_nt s672c5f5;
  void *s672c5f6[2];
  virtual  ~S672C5(); // _ZN6S672C5D1Ev
  virtual void  v6(); // _ZN6S672C52v6Ev
  virtual void  v7(); // _ZN6S672C52v7Ev
  virtual void  v8(); // _ZN6S672C52v8Ev
  virtual void  v9(); // _ZN6S672C52v9Ev
  virtual void  v10(); // _ZN6S672C53v10Ev
  virtual void  v11(); // _ZN6S672C53v11Ev
  virtual void  v12(); // _ZN6S672C53v12Ev
  virtual void  v13(); // _ZN6S672C53v13Ev
  virtual void  v14(); // _ZN6S672C53v14Ev
  virtual void  v15(); // _ZN6S672C53v15Ev
  virtual void  v16(); // _ZN6S672C53v16Ev
  virtual void  v17(); // _ZN6S672C53v17Ev
  virtual void  v18(); // _ZN6S672C53v18Ev
  virtual void  v19(); // _ZN6S672C53v19Ev
  virtual void  v20(); // _ZN6S672C53v20Ev
  virtual void  v21(); // _ZN6S672C53v21Ev
  virtual void  v22(); // _ZN6S672C53v22Ev
  virtual void  v23(); // _ZN6S672C53v23Ev
  virtual void  v24(); // _ZN6S672C53v24Ev
  virtual void  v25(); // _ZN6S672C53v25Ev
  virtual void  v26(); // _ZN6S672C53v26Ev
  virtual void  v27(); // _ZN6S672C53v27Ev
  virtual void  v28(); // _ZN6S672C53v28Ev
  virtual void  v29(); // _ZN6S672C53v29Ev
  virtual void  v30(); // _ZN6S672C53v30Ev
  virtual void  v31(); // _ZN6S672C53v31Ev
  virtual void  v32(); // _ZN6S672C53v32Ev
  virtual void  v33(); // _ZN6S672C53v33Ev
  virtual void  v34(); // _ZN6S672C53v34Ev
  virtual void  v35(); // _ZN6S672C53v35Ev
  virtual void  v36(); // _ZN6S672C53v36Ev
  virtual void  v37(); // _ZN6S672C53v37Ev
  virtual void  v38(); // _ZN6S672C53v38Ev
  virtual void  v39(); // _ZN6S672C53v39Ev
  virtual void  v40(); // _ZN6S672C53v40Ev
  virtual void  v41(); // _ZN6S672C53v41Ev
  virtual void  v42(); // _ZN6S672C53v42Ev
  virtual void  v43(); // _ZN6S672C53v43Ev
  virtual void  v44(); // _ZN6S672C53v44Ev
  virtual void  v45(); // _ZN6S672C53v45Ev
  virtual void  v46(); // _ZN6S672C53v46Ev
  virtual void  v47(); // _ZN6S672C53v47Ev
  virtual void  v48(); // _ZN6S672C53v48Ev
  virtual void  v49(); // _ZN6S672C53v49Ev
  virtual void  v50(); // _ZN6S672C53v50Ev
  virtual void  v51(); // _ZN6S672C53v51Ev
  virtual void  v52(); // _ZN6S672C53v52Ev
  virtual void  v53(); // _ZN6S672C53v53Ev
  virtual void  v54(); // _ZN6S672C53v54Ev
  virtual void  v55(); // _ZN6S672C53v55Ev
  virtual void  v56(); // _ZN6S672C53v56Ev
  virtual void  v57(); // _ZN6S672C53v57Ev
  virtual void  v58(); // _ZN6S672C53v58Ev
  virtual void  v59(); // _ZN6S672C53v59Ev
  virtual void  v60(); // _ZN6S672C53v60Ev
  virtual void  v61(); // _ZN6S672C53v61Ev
  virtual void  v62(); // _ZN6S672C53v62Ev
  virtual void  v63(); // _ZN6S672C53v63Ev
  virtual void  v64(); // _ZN6S672C53v64Ev
  virtual void  v65(); // _ZN6S672C53v65Ev
  virtual void  v66(); // _ZN6S672C53v66Ev
  virtual void  v67(); // _ZN6S672C53v67Ev
  virtual void  v68(); // _ZN6S672C53v68Ev
  virtual void  v69(); // _ZN6S672C53v69Ev
  S672C5(); // tgen
};
//SIG(-1 S672C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S672C5 ::~S672C5(){ note_dtor("S672C5", this);}
void  S672C5 ::v6(){vfunc_called(this, "_ZN6S672C52v6Ev");}
void  S672C5 ::v7(){vfunc_called(this, "_ZN6S672C52v7Ev");}
void  S672C5 ::v8(){vfunc_called(this, "_ZN6S672C52v8Ev");}
void  S672C5 ::v9(){vfunc_called(this, "_ZN6S672C52v9Ev");}
void  S672C5 ::v10(){vfunc_called(this, "_ZN6S672C53v10Ev");}
void  S672C5 ::v11(){vfunc_called(this, "_ZN6S672C53v11Ev");}
void  S672C5 ::v12(){vfunc_called(this, "_ZN6S672C53v12Ev");}
void  S672C5 ::v13(){vfunc_called(this, "_ZN6S672C53v13Ev");}
void  S672C5 ::v14(){vfunc_called(this, "_ZN6S672C53v14Ev");}
void  S672C5 ::v15(){vfunc_called(this, "_ZN6S672C53v15Ev");}
void  S672C5 ::v16(){vfunc_called(this, "_ZN6S672C53v16Ev");}
void  S672C5 ::v17(){vfunc_called(this, "_ZN6S672C53v17Ev");}
void  S672C5 ::v18(){vfunc_called(this, "_ZN6S672C53v18Ev");}
void  S672C5 ::v19(){vfunc_called(this, "_ZN6S672C53v19Ev");}
void  S672C5 ::v20(){vfunc_called(this, "_ZN6S672C53v20Ev");}
void  S672C5 ::v21(){vfunc_called(this, "_ZN6S672C53v21Ev");}
void  S672C5 ::v22(){vfunc_called(this, "_ZN6S672C53v22Ev");}
void  S672C5 ::v23(){vfunc_called(this, "_ZN6S672C53v23Ev");}
void  S672C5 ::v24(){vfunc_called(this, "_ZN6S672C53v24Ev");}
void  S672C5 ::v25(){vfunc_called(this, "_ZN6S672C53v25Ev");}
void  S672C5 ::v26(){vfunc_called(this, "_ZN6S672C53v26Ev");}
void  S672C5 ::v27(){vfunc_called(this, "_ZN6S672C53v27Ev");}
void  S672C5 ::v28(){vfunc_called(this, "_ZN6S672C53v28Ev");}
void  S672C5 ::v29(){vfunc_called(this, "_ZN6S672C53v29Ev");}
void  S672C5 ::v30(){vfunc_called(this, "_ZN6S672C53v30Ev");}
void  S672C5 ::v31(){vfunc_called(this, "_ZN6S672C53v31Ev");}
void  S672C5 ::v32(){vfunc_called(this, "_ZN6S672C53v32Ev");}
void  S672C5 ::v33(){vfunc_called(this, "_ZN6S672C53v33Ev");}
void  S672C5 ::v34(){vfunc_called(this, "_ZN6S672C53v34Ev");}
void  S672C5 ::v35(){vfunc_called(this, "_ZN6S672C53v35Ev");}
void  S672C5 ::v36(){vfunc_called(this, "_ZN6S672C53v36Ev");}
void  S672C5 ::v37(){vfunc_called(this, "_ZN6S672C53v37Ev");}
void  S672C5 ::v38(){vfunc_called(this, "_ZN6S672C53v38Ev");}
void  S672C5 ::v39(){vfunc_called(this, "_ZN6S672C53v39Ev");}
void  S672C5 ::v40(){vfunc_called(this, "_ZN6S672C53v40Ev");}
void  S672C5 ::v41(){vfunc_called(this, "_ZN6S672C53v41Ev");}
void  S672C5 ::v42(){vfunc_called(this, "_ZN6S672C53v42Ev");}
void  S672C5 ::v43(){vfunc_called(this, "_ZN6S672C53v43Ev");}
void  S672C5 ::v44(){vfunc_called(this, "_ZN6S672C53v44Ev");}
void  S672C5 ::v45(){vfunc_called(this, "_ZN6S672C53v45Ev");}
void  S672C5 ::v46(){vfunc_called(this, "_ZN6S672C53v46Ev");}
void  S672C5 ::v47(){vfunc_called(this, "_ZN6S672C53v47Ev");}
void  S672C5 ::v48(){vfunc_called(this, "_ZN6S672C53v48Ev");}
void  S672C5 ::v49(){vfunc_called(this, "_ZN6S672C53v49Ev");}
void  S672C5 ::v50(){vfunc_called(this, "_ZN6S672C53v50Ev");}
void  S672C5 ::v51(){vfunc_called(this, "_ZN6S672C53v51Ev");}
void  S672C5 ::v52(){vfunc_called(this, "_ZN6S672C53v52Ev");}
void  S672C5 ::v53(){vfunc_called(this, "_ZN6S672C53v53Ev");}
void  S672C5 ::v54(){vfunc_called(this, "_ZN6S672C53v54Ev");}
void  S672C5 ::v55(){vfunc_called(this, "_ZN6S672C53v55Ev");}
void  S672C5 ::v56(){vfunc_called(this, "_ZN6S672C53v56Ev");}
void  S672C5 ::v57(){vfunc_called(this, "_ZN6S672C53v57Ev");}
void  S672C5 ::v58(){vfunc_called(this, "_ZN6S672C53v58Ev");}
void  S672C5 ::v59(){vfunc_called(this, "_ZN6S672C53v59Ev");}
void  S672C5 ::v60(){vfunc_called(this, "_ZN6S672C53v60Ev");}
void  S672C5 ::v61(){vfunc_called(this, "_ZN6S672C53v61Ev");}
void  S672C5 ::v62(){vfunc_called(this, "_ZN6S672C53v62Ev");}
void  S672C5 ::v63(){vfunc_called(this, "_ZN6S672C53v63Ev");}
void  S672C5 ::v64(){vfunc_called(this, "_ZN6S672C53v64Ev");}
void  S672C5 ::v65(){vfunc_called(this, "_ZN6S672C53v65Ev");}
void  S672C5 ::v66(){vfunc_called(this, "_ZN6S672C53v66Ev");}
void  S672C5 ::v67(){vfunc_called(this, "_ZN6S672C53v67Ev");}
void  S672C5 ::v68(){vfunc_called(this, "_ZN6S672C53v68Ev");}
void  S672C5 ::v69(){vfunc_called(this, "_ZN6S672C53v69Ev");}
S672C5 ::S672C5(){ note_ctor("S672C5", this);} // tgen

static void Test_S672C5()
{
  extern Class_Descriptor cd_S672C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S672C5, buf);
    S672C5 *dp, &lv = *(dp=new (buf) S672C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S672C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S672C5)");
    check_field_offset(lv, s672c5f0, ABISELECT(8,4), "S672C5.s672c5f0");
    check_field_offset(lv, s672c5f1, ABISELECT(16,8), "S672C5.s672c5f1");
    check_field_offset(lv, s672c5f2, ABISELECT(24,16), "S672C5.s672c5f2");
    check_field_offset(lv, s672c5f3, ABISELECT(56,32), "S672C5.s672c5f3");
    check_field_offset(lv, s672c5f4, ABISELECT(64,40), "S672C5.s672c5f4");
    check_field_offset(lv, s672c5f5, ABISELECT(72,44), "S672C5.s672c5f5");
    check_field_offset(lv, s672c5f6, ABISELECT(80,52), "S672C5.s672c5f6");
    test_class_info(&lv, &cd_S672C5);
    dp->~S672C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS672C5(Test_S672C5, "S672C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S672C5C1Ev();
extern void _ZN6S672C5D1Ev();
Name_Map name_map_S672C5[] = {
  NSPAIR(_ZN6S672C5C1Ev),
  NSPAIR(_ZN6S672C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S672C5[];
extern void _ZN6S672C5D1Ev();
extern void _ZN6S672C5D0Ev();
extern void _ZN6S672C52v6Ev();
extern void _ZN6S672C52v7Ev();
extern void _ZN6S672C52v8Ev();
extern void _ZN6S672C52v9Ev();
extern void _ZN6S672C53v10Ev();
extern void _ZN6S672C53v11Ev();
extern void _ZN6S672C53v12Ev();
extern void _ZN6S672C53v13Ev();
extern void _ZN6S672C53v14Ev();
extern void _ZN6S672C53v15Ev();
extern void _ZN6S672C53v16Ev();
extern void _ZN6S672C53v17Ev();
extern void _ZN6S672C53v18Ev();
extern void _ZN6S672C53v19Ev();
extern void _ZN6S672C53v20Ev();
extern void _ZN6S672C53v21Ev();
extern void _ZN6S672C53v22Ev();
extern void _ZN6S672C53v23Ev();
extern void _ZN6S672C53v24Ev();
extern void _ZN6S672C53v25Ev();
extern void _ZN6S672C53v26Ev();
extern void _ZN6S672C53v27Ev();
extern void _ZN6S672C53v28Ev();
extern void _ZN6S672C53v29Ev();
extern void _ZN6S672C53v30Ev();
extern void _ZN6S672C53v31Ev();
extern void _ZN6S672C53v32Ev();
extern void _ZN6S672C53v33Ev();
extern void _ZN6S672C53v34Ev();
extern void _ZN6S672C53v35Ev();
extern void _ZN6S672C53v36Ev();
extern void _ZN6S672C53v37Ev();
extern void _ZN6S672C53v38Ev();
extern void _ZN6S672C53v39Ev();
extern void _ZN6S672C53v40Ev();
extern void _ZN6S672C53v41Ev();
extern void _ZN6S672C53v42Ev();
extern void _ZN6S672C53v43Ev();
extern void _ZN6S672C53v44Ev();
extern void _ZN6S672C53v45Ev();
extern void _ZN6S672C53v46Ev();
extern void _ZN6S672C53v47Ev();
extern void _ZN6S672C53v48Ev();
extern void _ZN6S672C53v49Ev();
extern void _ZN6S672C53v50Ev();
extern void _ZN6S672C53v51Ev();
extern void _ZN6S672C53v52Ev();
extern void _ZN6S672C53v53Ev();
extern void _ZN6S672C53v54Ev();
extern void _ZN6S672C53v55Ev();
extern void _ZN6S672C53v56Ev();
extern void _ZN6S672C53v57Ev();
extern void _ZN6S672C53v58Ev();
extern void _ZN6S672C53v59Ev();
extern void _ZN6S672C53v60Ev();
extern void _ZN6S672C53v61Ev();
extern void _ZN6S672C53v62Ev();
extern void _ZN6S672C53v63Ev();
extern void _ZN6S672C53v64Ev();
extern void _ZN6S672C53v65Ev();
extern void _ZN6S672C53v66Ev();
extern void _ZN6S672C53v67Ev();
extern void _ZN6S672C53v68Ev();
extern void _ZN6S672C53v69Ev();
static  VTBL_ENTRY vtc_S672C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S672C5[0]),
  (VTBL_ENTRY)&_ZN6S672C5D1Ev,
  (VTBL_ENTRY)&_ZN6S672C5D0Ev,
  (VTBL_ENTRY)&_ZN6S672C52v6Ev,
  (VTBL_ENTRY)&_ZN6S672C52v7Ev,
  (VTBL_ENTRY)&_ZN6S672C52v8Ev,
  (VTBL_ENTRY)&_ZN6S672C52v9Ev,
  (VTBL_ENTRY)&_ZN6S672C53v10Ev,
  (VTBL_ENTRY)&_ZN6S672C53v11Ev,
  (VTBL_ENTRY)&_ZN6S672C53v12Ev,
  (VTBL_ENTRY)&_ZN6S672C53v13Ev,
  (VTBL_ENTRY)&_ZN6S672C53v14Ev,
  (VTBL_ENTRY)&_ZN6S672C53v15Ev,
  (VTBL_ENTRY)&_ZN6S672C53v16Ev,
  (VTBL_ENTRY)&_ZN6S672C53v17Ev,
  (VTBL_ENTRY)&_ZN6S672C53v18Ev,
  (VTBL_ENTRY)&_ZN6S672C53v19Ev,
  (VTBL_ENTRY)&_ZN6S672C53v20Ev,
  (VTBL_ENTRY)&_ZN6S672C53v21Ev,
  (VTBL_ENTRY)&_ZN6S672C53v22Ev,
  (VTBL_ENTRY)&_ZN6S672C53v23Ev,
  (VTBL_ENTRY)&_ZN6S672C53v24Ev,
  (VTBL_ENTRY)&_ZN6S672C53v25Ev,
  (VTBL_ENTRY)&_ZN6S672C53v26Ev,
  (VTBL_ENTRY)&_ZN6S672C53v27Ev,
  (VTBL_ENTRY)&_ZN6S672C53v28Ev,
  (VTBL_ENTRY)&_ZN6S672C53v29Ev,
  (VTBL_ENTRY)&_ZN6S672C53v30Ev,
  (VTBL_ENTRY)&_ZN6S672C53v31Ev,
  (VTBL_ENTRY)&_ZN6S672C53v32Ev,
  (VTBL_ENTRY)&_ZN6S672C53v33Ev,
  (VTBL_ENTRY)&_ZN6S672C53v34Ev,
  (VTBL_ENTRY)&_ZN6S672C53v35Ev,
  (VTBL_ENTRY)&_ZN6S672C53v36Ev,
  (VTBL_ENTRY)&_ZN6S672C53v37Ev,
  (VTBL_ENTRY)&_ZN6S672C53v38Ev,
  (VTBL_ENTRY)&_ZN6S672C53v39Ev,
  (VTBL_ENTRY)&_ZN6S672C53v40Ev,
  (VTBL_ENTRY)&_ZN6S672C53v41Ev,
  (VTBL_ENTRY)&_ZN6S672C53v42Ev,
  (VTBL_ENTRY)&_ZN6S672C53v43Ev,
  (VTBL_ENTRY)&_ZN6S672C53v44Ev,
  (VTBL_ENTRY)&_ZN6S672C53v45Ev,
  (VTBL_ENTRY)&_ZN6S672C53v46Ev,
  (VTBL_ENTRY)&_ZN6S672C53v47Ev,
  (VTBL_ENTRY)&_ZN6S672C53v48Ev,
  (VTBL_ENTRY)&_ZN6S672C53v49Ev,
  (VTBL_ENTRY)&_ZN6S672C53v50Ev,
  (VTBL_ENTRY)&_ZN6S672C53v51Ev,
  (VTBL_ENTRY)&_ZN6S672C53v52Ev,
  (VTBL_ENTRY)&_ZN6S672C53v53Ev,
  (VTBL_ENTRY)&_ZN6S672C53v54Ev,
  (VTBL_ENTRY)&_ZN6S672C53v55Ev,
  (VTBL_ENTRY)&_ZN6S672C53v56Ev,
  (VTBL_ENTRY)&_ZN6S672C53v57Ev,
  (VTBL_ENTRY)&_ZN6S672C53v58Ev,
  (VTBL_ENTRY)&_ZN6S672C53v59Ev,
  (VTBL_ENTRY)&_ZN6S672C53v60Ev,
  (VTBL_ENTRY)&_ZN6S672C53v61Ev,
  (VTBL_ENTRY)&_ZN6S672C53v62Ev,
  (VTBL_ENTRY)&_ZN6S672C53v63Ev,
  (VTBL_ENTRY)&_ZN6S672C53v64Ev,
  (VTBL_ENTRY)&_ZN6S672C53v65Ev,
  (VTBL_ENTRY)&_ZN6S672C53v66Ev,
  (VTBL_ENTRY)&_ZN6S672C53v67Ev,
  (VTBL_ENTRY)&_ZN6S672C53v68Ev,
  (VTBL_ENTRY)&_ZN6S672C53v69Ev,
};
extern VTBL_ENTRY _ZTI6S672C5[];
extern  VTBL_ENTRY _ZTV6S672C5[];
Class_Descriptor cd_S672C5 = {  "S672C5", // class name
  0,0,//no base classes
  &(vtc_S672C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S672C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S672C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S672C4  : S672C5 {
  int s672c4f0[2];
  void *s672c4f1;
  int s672c4f2[2];
  ::S473C7_nt s672c4f3;
  ::S473C7_nt s672c4f4;
  ::S21925C42 s672c4f5;
  ::S473C7_nt s672c4f6;
  unsigned int s672c4f7:1;
  unsigned int s672c4f8:1;
  unsigned int s672c4f9:1;
  unsigned int s672c4f10:1;
  unsigned int s672c4f11:1;
  int s672c4f12[2];
  virtual  ~S672C4(); // _ZN6S672C4D1Ev
  virtual void  v70(); // _ZN6S672C43v70Ev
  virtual void  v71(); // _ZN6S672C43v71Ev
  virtual void  v72(); // _ZN6S672C43v72Ev
  virtual void  v73(); // _ZN6S672C43v73Ev
  virtual void  v74(); // _ZN6S672C43v74Ev
  virtual void  v75(); // _ZN6S672C43v75Ev
  virtual void  v76(); // _ZN6S672C43v76Ev
  virtual void  v77(); // _ZN6S672C43v77Ev
  virtual void  v78(); // _ZN6S672C43v78Ev
  virtual void  v79(); // _ZN6S672C43v79Ev
  virtual void  v80(); // _ZN6S672C43v80Ev
  virtual void  v81(); // _ZN6S672C43v81Ev
  virtual void  v82(); // _ZN6S672C43v82Ev
  virtual void  v83(); // _ZN6S672C43v83Ev
  virtual void  v84(); // _ZN6S672C43v84Ev
  virtual void  v85(); // _ZN6S672C43v85Ev
  virtual void  v86(); // _ZN6S672C43v86Ev
  virtual void  v87(); // _ZN6S672C43v87Ev
  virtual void  v88(); // _ZN6S672C43v88Ev
  virtual void  v89(); // _ZN6S672C43v89Ev
  virtual void  v90(); // _ZN6S672C43v90Ev
  virtual void  v91(); // _ZN6S672C43v91Ev
  S672C4(); // tgen
};
//SIG(-1 S672C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S672C4 ::~S672C4(){ note_dtor("S672C4", this);}
void  S672C4 ::v70(){vfunc_called(this, "_ZN6S672C43v70Ev");}
void  S672C4 ::v71(){vfunc_called(this, "_ZN6S672C43v71Ev");}
void  S672C4 ::v72(){vfunc_called(this, "_ZN6S672C43v72Ev");}
void  S672C4 ::v73(){vfunc_called(this, "_ZN6S672C43v73Ev");}
void  S672C4 ::v74(){vfunc_called(this, "_ZN6S672C43v74Ev");}
void  S672C4 ::v75(){vfunc_called(this, "_ZN6S672C43v75Ev");}
void  S672C4 ::v76(){vfunc_called(this, "_ZN6S672C43v76Ev");}
void  S672C4 ::v77(){vfunc_called(this, "_ZN6S672C43v77Ev");}
void  S672C4 ::v78(){vfunc_called(this, "_ZN6S672C43v78Ev");}
void  S672C4 ::v79(){vfunc_called(this, "_ZN6S672C43v79Ev");}
void  S672C4 ::v80(){vfunc_called(this, "_ZN6S672C43v80Ev");}
void  S672C4 ::v81(){vfunc_called(this, "_ZN6S672C43v81Ev");}
void  S672C4 ::v82(){vfunc_called(this, "_ZN6S672C43v82Ev");}
void  S672C4 ::v83(){vfunc_called(this, "_ZN6S672C43v83Ev");}
void  S672C4 ::v84(){vfunc_called(this, "_ZN6S672C43v84Ev");}
void  S672C4 ::v85(){vfunc_called(this, "_ZN6S672C43v85Ev");}
void  S672C4 ::v86(){vfunc_called(this, "_ZN6S672C43v86Ev");}
void  S672C4 ::v87(){vfunc_called(this, "_ZN6S672C43v87Ev");}
void  S672C4 ::v88(){vfunc_called(this, "_ZN6S672C43v88Ev");}
void  S672C4 ::v89(){vfunc_called(this, "_ZN6S672C43v89Ev");}
void  S672C4 ::v90(){vfunc_called(this, "_ZN6S672C43v90Ev");}
void  S672C4 ::v91(){vfunc_called(this, "_ZN6S672C43v91Ev");}
S672C4 ::S672C4(){ note_ctor("S672C4", this);} // tgen

static void Test_S672C4()
{
  extern Class_Descriptor cd_S672C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S672C4, buf);
    S672C4 *dp, &lv = *(dp=new (buf) S672C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S672C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S672C4)");
    check_base_class_offset(lv, (S672C5*), 0, "S672C4");
    check_field_offset(lv, s672c4f0, ABISELECT(96,60), "S672C4.s672c4f0");
    check_field_offset(lv, s672c4f1, ABISELECT(104,68), "S672C4.s672c4f1");
    check_field_offset(lv, s672c4f2, ABISELECT(112,72), "S672C4.s672c4f2");
    check_field_offset(lv, s672c4f3, ABISELECT(120,80), "S672C4.s672c4f3");
    check_field_offset(lv, s672c4f4, ABISELECT(136,92), "S672C4.s672c4f4");
    check_field_offset(lv, s672c4f5, ABISELECT(152,104), "S672C4.s672c4f5");
    check_field_offset(lv, s672c4f6, ABISELECT(160,108), "S672C4.s672c4f6");
    set_bf_and_test(lv, s672c4f7, ABISELECT(176,120), 0, 1, 1, "S672C4");
    set_bf_and_test(lv, s672c4f8, ABISELECT(176,120), 1, 1, 1, "S672C4");
    set_bf_and_test(lv, s672c4f9, ABISELECT(176,120), 2, 1, 1, "S672C4");
    set_bf_and_test(lv, s672c4f10, ABISELECT(176,120), 3, 1, 1, "S672C4");
    set_bf_and_test(lv, s672c4f11, ABISELECT(176,120), 4, 1, 1, "S672C4");
    check_field_offset(lv, s672c4f12, ABISELECT(180,124), "S672C4.s672c4f12");
    test_class_info(&lv, &cd_S672C4);
    dp->~S672C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS672C4(Test_S672C4, "S672C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S672C4C1Ev();
extern void _ZN6S672C4D1Ev();
Name_Map name_map_S672C4[] = {
  NSPAIR(_ZN6S672C4C1Ev),
  NSPAIR(_ZN6S672C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S672C5;
extern VTBL_ENTRY _ZTI6S672C5[];
extern  VTBL_ENTRY _ZTV6S672C5[];
static Base_Class bases_S672C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S672C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S672C4[];
extern void _ZN6S672C4D1Ev();
extern void _ZN6S672C4D0Ev();
extern void _ZN6S672C52v6Ev();
extern void _ZN6S672C52v7Ev();
extern void _ZN6S672C52v8Ev();
extern void _ZN6S672C52v9Ev();
extern void _ZN6S672C53v10Ev();
extern void _ZN6S672C53v11Ev();
extern void _ZN6S672C53v12Ev();
extern void _ZN6S672C53v13Ev();
extern void _ZN6S672C53v14Ev();
extern void _ZN6S672C53v15Ev();
extern void _ZN6S672C53v16Ev();
extern void _ZN6S672C53v17Ev();
extern void _ZN6S672C53v18Ev();
extern void _ZN6S672C53v19Ev();
extern void _ZN6S672C53v20Ev();
extern void _ZN6S672C53v21Ev();
extern void _ZN6S672C53v22Ev();
extern void _ZN6S672C53v23Ev();
extern void _ZN6S672C53v24Ev();
extern void _ZN6S672C53v25Ev();
extern void _ZN6S672C53v26Ev();
extern void _ZN6S672C53v27Ev();
extern void _ZN6S672C53v28Ev();
extern void _ZN6S672C53v29Ev();
extern void _ZN6S672C53v30Ev();
extern void _ZN6S672C53v31Ev();
extern void _ZN6S672C53v32Ev();
extern void _ZN6S672C53v33Ev();
extern void _ZN6S672C53v34Ev();
extern void _ZN6S672C53v35Ev();
extern void _ZN6S672C53v36Ev();
extern void _ZN6S672C53v37Ev();
extern void _ZN6S672C53v38Ev();
extern void _ZN6S672C53v39Ev();
extern void _ZN6S672C53v40Ev();
extern void _ZN6S672C53v41Ev();
extern void _ZN6S672C53v42Ev();
extern void _ZN6S672C53v43Ev();
extern void _ZN6S672C53v44Ev();
extern void _ZN6S672C53v45Ev();
extern void _ZN6S672C53v46Ev();
extern void _ZN6S672C53v47Ev();
extern void _ZN6S672C53v48Ev();
extern void _ZN6S672C53v49Ev();
extern void _ZN6S672C53v50Ev();
extern void _ZN6S672C53v51Ev();
extern void _ZN6S672C53v52Ev();
extern void _ZN6S672C53v53Ev();
extern void _ZN6S672C53v54Ev();
extern void _ZN6S672C53v55Ev();
extern void _ZN6S672C53v56Ev();
extern void _ZN6S672C53v57Ev();
extern void _ZN6S672C53v58Ev();
extern void _ZN6S672C53v59Ev();
extern void _ZN6S672C53v60Ev();
extern void _ZN6S672C53v61Ev();
extern void _ZN6S672C53v62Ev();
extern void _ZN6S672C53v63Ev();
extern void _ZN6S672C53v64Ev();
extern void _ZN6S672C53v65Ev();
extern void _ZN6S672C53v66Ev();
extern void _ZN6S672C53v67Ev();
extern void _ZN6S672C53v68Ev();
extern void _ZN6S672C53v69Ev();
extern void _ZN6S672C43v70Ev();
extern void _ZN6S672C43v71Ev();
extern void _ZN6S672C43v72Ev();
extern void _ZN6S672C43v73Ev();
extern void _ZN6S672C43v74Ev();
extern void _ZN6S672C43v75Ev();
extern void _ZN6S672C43v76Ev();
extern void _ZN6S672C43v77Ev();
extern void _ZN6S672C43v78Ev();
extern void _ZN6S672C43v79Ev();
extern void _ZN6S672C43v80Ev();
extern void _ZN6S672C43v81Ev();
extern void _ZN6S672C43v82Ev();
extern void _ZN6S672C43v83Ev();
extern void _ZN6S672C43v84Ev();
extern void _ZN6S672C43v85Ev();
extern void _ZN6S672C43v86Ev();
extern void _ZN6S672C43v87Ev();
extern void _ZN6S672C43v88Ev();
extern void _ZN6S672C43v89Ev();
extern void _ZN6S672C43v90Ev();
extern void _ZN6S672C43v91Ev();
static  VTBL_ENTRY vtc_S672C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S672C4[0]),
  (VTBL_ENTRY)&_ZN6S672C4D1Ev,
  (VTBL_ENTRY)&_ZN6S672C4D0Ev,
  (VTBL_ENTRY)&_ZN6S672C52v6Ev,
  (VTBL_ENTRY)&_ZN6S672C52v7Ev,
  (VTBL_ENTRY)&_ZN6S672C52v8Ev,
  (VTBL_ENTRY)&_ZN6S672C52v9Ev,
  (VTBL_ENTRY)&_ZN6S672C53v10Ev,
  (VTBL_ENTRY)&_ZN6S672C53v11Ev,
  (VTBL_ENTRY)&_ZN6S672C53v12Ev,
  (VTBL_ENTRY)&_ZN6S672C53v13Ev,
  (VTBL_ENTRY)&_ZN6S672C53v14Ev,
  (VTBL_ENTRY)&_ZN6S672C53v15Ev,
  (VTBL_ENTRY)&_ZN6S672C53v16Ev,
  (VTBL_ENTRY)&_ZN6S672C53v17Ev,
  (VTBL_ENTRY)&_ZN6S672C53v18Ev,
  (VTBL_ENTRY)&_ZN6S672C53v19Ev,
  (VTBL_ENTRY)&_ZN6S672C53v20Ev,
  (VTBL_ENTRY)&_ZN6S672C53v21Ev,
  (VTBL_ENTRY)&_ZN6S672C53v22Ev,
  (VTBL_ENTRY)&_ZN6S672C53v23Ev,
  (VTBL_ENTRY)&_ZN6S672C53v24Ev,
  (VTBL_ENTRY)&_ZN6S672C53v25Ev,
  (VTBL_ENTRY)&_ZN6S672C53v26Ev,
  (VTBL_ENTRY)&_ZN6S672C53v27Ev,
  (VTBL_ENTRY)&_ZN6S672C53v28Ev,
  (VTBL_ENTRY)&_ZN6S672C53v29Ev,
  (VTBL_ENTRY)&_ZN6S672C53v30Ev,
  (VTBL_ENTRY)&_ZN6S672C53v31Ev,
  (VTBL_ENTRY)&_ZN6S672C53v32Ev,
  (VTBL_ENTRY)&_ZN6S672C53v33Ev,
  (VTBL_ENTRY)&_ZN6S672C53v34Ev,
  (VTBL_ENTRY)&_ZN6S672C53v35Ev,
  (VTBL_ENTRY)&_ZN6S672C53v36Ev,
  (VTBL_ENTRY)&_ZN6S672C53v37Ev,
  (VTBL_ENTRY)&_ZN6S672C53v38Ev,
  (VTBL_ENTRY)&_ZN6S672C53v39Ev,
  (VTBL_ENTRY)&_ZN6S672C53v40Ev,
  (VTBL_ENTRY)&_ZN6S672C53v41Ev,
  (VTBL_ENTRY)&_ZN6S672C53v42Ev,
  (VTBL_ENTRY)&_ZN6S672C53v43Ev,
  (VTBL_ENTRY)&_ZN6S672C53v44Ev,
  (VTBL_ENTRY)&_ZN6S672C53v45Ev,
  (VTBL_ENTRY)&_ZN6S672C53v46Ev,
  (VTBL_ENTRY)&_ZN6S672C53v47Ev,
  (VTBL_ENTRY)&_ZN6S672C53v48Ev,
  (VTBL_ENTRY)&_ZN6S672C53v49Ev,
  (VTBL_ENTRY)&_ZN6S672C53v50Ev,
  (VTBL_ENTRY)&_ZN6S672C53v51Ev,
  (VTBL_ENTRY)&_ZN6S672C53v52Ev,
  (VTBL_ENTRY)&_ZN6S672C53v53Ev,
  (VTBL_ENTRY)&_ZN6S672C53v54Ev,
  (VTBL_ENTRY)&_ZN6S672C53v55Ev,
  (VTBL_ENTRY)&_ZN6S672C53v56Ev,
  (VTBL_ENTRY)&_ZN6S672C53v57Ev,
  (VTBL_ENTRY)&_ZN6S672C53v58Ev,
  (VTBL_ENTRY)&_ZN6S672C53v59Ev,
  (VTBL_ENTRY)&_ZN6S672C53v60Ev,
  (VTBL_ENTRY)&_ZN6S672C53v61Ev,
  (VTBL_ENTRY)&_ZN6S672C53v62Ev,
  (VTBL_ENTRY)&_ZN6S672C53v63Ev,
  (VTBL_ENTRY)&_ZN6S672C53v64Ev,
  (VTBL_ENTRY)&_ZN6S672C53v65Ev,
  (VTBL_ENTRY)&_ZN6S672C53v66Ev,
  (VTBL_ENTRY)&_ZN6S672C53v67Ev,
  (VTBL_ENTRY)&_ZN6S672C53v68Ev,
  (VTBL_ENTRY)&_ZN6S672C53v69Ev,
  (VTBL_ENTRY)&_ZN6S672C43v70Ev,
  (VTBL_ENTRY)&_ZN6S672C43v71Ev,
  (VTBL_ENTRY)&_ZN6S672C43v72Ev,
  (VTBL_ENTRY)&_ZN6S672C43v73Ev,
  (VTBL_ENTRY)&_ZN6S672C43v74Ev,
  (VTBL_ENTRY)&_ZN6S672C43v75Ev,
  (VTBL_ENTRY)&_ZN6S672C43v76Ev,
  (VTBL_ENTRY)&_ZN6S672C43v77Ev,
  (VTBL_ENTRY)&_ZN6S672C43v78Ev,
  (VTBL_ENTRY)&_ZN6S672C43v79Ev,
  (VTBL_ENTRY)&_ZN6S672C43v80Ev,
  (VTBL_ENTRY)&_ZN6S672C43v81Ev,
  (VTBL_ENTRY)&_ZN6S672C43v82Ev,
  (VTBL_ENTRY)&_ZN6S672C43v83Ev,
  (VTBL_ENTRY)&_ZN6S672C43v84Ev,
  (VTBL_ENTRY)&_ZN6S672C43v85Ev,
  (VTBL_ENTRY)&_ZN6S672C43v86Ev,
  (VTBL_ENTRY)&_ZN6S672C43v87Ev,
  (VTBL_ENTRY)&_ZN6S672C43v88Ev,
  (VTBL_ENTRY)&_ZN6S672C43v89Ev,
  (VTBL_ENTRY)&_ZN6S672C43v90Ev,
  (VTBL_ENTRY)&_ZN6S672C43v91Ev,
};
extern VTBL_ENTRY _ZTI6S672C4[];
extern  VTBL_ENTRY _ZTV6S672C4[];
Class_Descriptor cd_S672C4 = {  "S672C4", // class name
  bases_S672C4, 1,
  &(vtc_S672C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S672C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S672C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S672C3  : S672C4 {
  ::S473C6_nt s672c3f0;
  virtual  ~S672C3(); // _ZN6S672C3D1Ev
  virtual void  v92(); // _ZN6S672C33v92Ev
  virtual void  v93(); // _ZN6S672C33v93Ev
  virtual void  v94(); // _ZN6S672C33v94Ev
  virtual void  v95(); // _ZN6S672C33v95Ev
  virtual void  v96(); // _ZN6S672C33v96Ev
  virtual void  v97(); // _ZN6S672C33v97Ev
  virtual void  v98(); // _ZN6S672C33v98Ev
  virtual void  v99(); // _ZN6S672C33v99Ev
  virtual void  v100(); // _ZN6S672C34v100Ev
  virtual void  v101(); // _ZN6S672C34v101Ev
  virtual void  v102(); // _ZN6S672C34v102Ev
  virtual void  v103(); // _ZN6S672C34v103Ev
  virtual void  v104(); // _ZN6S672C34v104Ev
  virtual void  v105(); // _ZN6S672C34v105Ev
  virtual void  v106(); // _ZN6S672C34v106Ev
  virtual void  v107(); // _ZN6S672C34v107Ev
  virtual void  v108(); // _ZN6S672C34v108Ev
  virtual void  v109(); // _ZN6S672C34v109Ev
  virtual void  v110(); // _ZN6S672C34v110Ev
  S672C3(); // tgen
};
//SIG(-1 S672C3) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S672C3 ::~S672C3(){ note_dtor("S672C3", this);}
void  S672C3 ::v92(){vfunc_called(this, "_ZN6S672C33v92Ev");}
void  S672C3 ::v93(){vfunc_called(this, "_ZN6S672C33v93Ev");}
void  S672C3 ::v94(){vfunc_called(this, "_ZN6S672C33v94Ev");}
void  S672C3 ::v95(){vfunc_called(this, "_ZN6S672C33v95Ev");}
void  S672C3 ::v96(){vfunc_called(this, "_ZN6S672C33v96Ev");}
void  S672C3 ::v97(){vfunc_called(this, "_ZN6S672C33v97Ev");}
void  S672C3 ::v98(){vfunc_called(this, "_ZN6S672C33v98Ev");}
void  S672C3 ::v99(){vfunc_called(this, "_ZN6S672C33v99Ev");}
void  S672C3 ::v100(){vfunc_called(this, "_ZN6S672C34v100Ev");}
void  S672C3 ::v101(){vfunc_called(this, "_ZN6S672C34v101Ev");}
void  S672C3 ::v102(){vfunc_called(this, "_ZN6S672C34v102Ev");}
void  S672C3 ::v103(){vfunc_called(this, "_ZN6S672C34v103Ev");}
void  S672C3 ::v104(){vfunc_called(this, "_ZN6S672C34v104Ev");}
void  S672C3 ::v105(){vfunc_called(this, "_ZN6S672C34v105Ev");}
void  S672C3 ::v106(){vfunc_called(this, "_ZN6S672C34v106Ev");}
void  S672C3 ::v107(){vfunc_called(this, "_ZN6S672C34v107Ev");}
void  S672C3 ::v108(){vfunc_called(this, "_ZN6S672C34v108Ev");}
void  S672C3 ::v109(){vfunc_called(this, "_ZN6S672C34v109Ev");}
void  S672C3 ::v110(){vfunc_called(this, "_ZN6S672C34v110Ev");}
S672C3 ::S672C3(){ note_ctor("S672C3", this);} // tgen

static void Test_S672C3()
{
  extern Class_Descriptor cd_S672C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S672C3, buf);
    S672C3 *dp, &lv = *(dp=new (buf) S672C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S672C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S672C3)");
    check_base_class_offset(lv, (S672C5*)(S672C4*), 0, "S672C3");
    check_base_class_offset(lv, (S672C4*), 0, "S672C3");
    check_field_offset(lv, s672c3f0, ABISELECT(188,132), "S672C3.s672c3f0");
    test_class_info(&lv, &cd_S672C3);
    dp->~S672C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS672C3(Test_S672C3, "S672C3", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S672C3C1Ev();
extern void _ZN6S672C3D1Ev();
Name_Map name_map_S672C3[] = {
  NSPAIR(_ZN6S672C3C1Ev),
  NSPAIR(_ZN6S672C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S672C5;
extern VTBL_ENTRY _ZTI6S672C5[];
extern  VTBL_ENTRY _ZTV6S672C5[];
extern Class_Descriptor cd_S672C4;
extern VTBL_ENTRY _ZTI6S672C4[];
extern  VTBL_ENTRY _ZTV6S672C4[];
static Base_Class bases_S672C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S672C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S672C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S672C3[];
extern void _ZN6S672C3D1Ev();
extern void _ZN6S672C3D0Ev();
extern void _ZN6S672C52v6Ev();
extern void _ZN6S672C52v7Ev();
extern void _ZN6S672C52v8Ev();
extern void _ZN6S672C52v9Ev();
extern void _ZN6S672C53v10Ev();
extern void _ZN6S672C53v11Ev();
extern void _ZN6S672C53v12Ev();
extern void _ZN6S672C53v13Ev();
extern void _ZN6S672C53v14Ev();
extern void _ZN6S672C53v15Ev();
extern void _ZN6S672C53v16Ev();
extern void _ZN6S672C53v17Ev();
extern void _ZN6S672C53v18Ev();
extern void _ZN6S672C53v19Ev();
extern void _ZN6S672C53v20Ev();
extern void _ZN6S672C53v21Ev();
extern void _ZN6S672C53v22Ev();
extern void _ZN6S672C53v23Ev();
extern void _ZN6S672C53v24Ev();
extern void _ZN6S672C53v25Ev();
extern void _ZN6S672C53v26Ev();
extern void _ZN6S672C53v27Ev();
extern void _ZN6S672C53v28Ev();
extern void _ZN6S672C53v29Ev();
extern void _ZN6S672C53v30Ev();
extern void _ZN6S672C53v31Ev();
extern void _ZN6S672C53v32Ev();
extern void _ZN6S672C53v33Ev();
extern void _ZN6S672C53v34Ev();
extern void _ZN6S672C53v35Ev();
extern void _ZN6S672C53v36Ev();
extern void _ZN6S672C53v37Ev();
extern void _ZN6S672C53v38Ev();
extern void _ZN6S672C53v39Ev();
extern void _ZN6S672C53v40Ev();
extern void _ZN6S672C53v41Ev();
extern void _ZN6S672C53v42Ev();
extern void _ZN6S672C53v43Ev();
extern void _ZN6S672C53v44Ev();
extern void _ZN6S672C53v45Ev();
extern void _ZN6S672C53v46Ev();
extern void _ZN6S672C53v47Ev();
extern void _ZN6S672C53v48Ev();
extern void _ZN6S672C53v49Ev();
extern void _ZN6S672C53v50Ev();
extern void _ZN6S672C53v51Ev();
extern void _ZN6S672C53v52Ev();
extern void _ZN6S672C53v53Ev();
extern void _ZN6S672C53v54Ev();
extern void _ZN6S672C53v55Ev();
extern void _ZN6S672C53v56Ev();
extern void _ZN6S672C53v57Ev();
extern void _ZN6S672C53v58Ev();
extern void _ZN6S672C53v59Ev();
extern void _ZN6S672C53v60Ev();
extern void _ZN6S672C53v61Ev();
extern void _ZN6S672C53v62Ev();
extern void _ZN6S672C53v63Ev();
extern void _ZN6S672C53v64Ev();
extern void _ZN6S672C53v65Ev();
extern void _ZN6S672C53v66Ev();
extern void _ZN6S672C53v67Ev();
extern void _ZN6S672C53v68Ev();
extern void _ZN6S672C53v69Ev();
extern void _ZN6S672C43v70Ev();
extern void _ZN6S672C43v71Ev();
extern void _ZN6S672C43v72Ev();
extern void _ZN6S672C43v73Ev();
extern void _ZN6S672C43v74Ev();
extern void _ZN6S672C43v75Ev();
extern void _ZN6S672C43v76Ev();
extern void _ZN6S672C43v77Ev();
extern void _ZN6S672C43v78Ev();
extern void _ZN6S672C43v79Ev();
extern void _ZN6S672C43v80Ev();
extern void _ZN6S672C43v81Ev();
extern void _ZN6S672C43v82Ev();
extern void _ZN6S672C43v83Ev();
extern void _ZN6S672C43v84Ev();
extern void _ZN6S672C43v85Ev();
extern void _ZN6S672C43v86Ev();
extern void _ZN6S672C43v87Ev();
extern void _ZN6S672C43v88Ev();
extern void _ZN6S672C43v89Ev();
extern void _ZN6S672C43v90Ev();
extern void _ZN6S672C43v91Ev();
extern void _ZN6S672C33v92Ev();
extern void _ZN6S672C33v93Ev();
extern void _ZN6S672C33v94Ev();
extern void _ZN6S672C33v95Ev();
extern void _ZN6S672C33v96Ev();
extern void _ZN6S672C33v97Ev();
extern void _ZN6S672C33v98Ev();
extern void _ZN6S672C33v99Ev();
extern void _ZN6S672C34v100Ev();
extern void _ZN6S672C34v101Ev();
extern void _ZN6S672C34v102Ev();
extern void _ZN6S672C34v103Ev();
extern void _ZN6S672C34v104Ev();
extern void _ZN6S672C34v105Ev();
extern void _ZN6S672C34v106Ev();
extern void _ZN6S672C34v107Ev();
extern void _ZN6S672C34v108Ev();
extern void _ZN6S672C34v109Ev();
extern void _ZN6S672C34v110Ev();
static  VTBL_ENTRY vtc_S672C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S672C3[0]),
  (VTBL_ENTRY)&_ZN6S672C3D1Ev,
  (VTBL_ENTRY)&_ZN6S672C3D0Ev,
  (VTBL_ENTRY)&_ZN6S672C52v6Ev,
  (VTBL_ENTRY)&_ZN6S672C52v7Ev,
  (VTBL_ENTRY)&_ZN6S672C52v8Ev,
  (VTBL_ENTRY)&_ZN6S672C52v9Ev,
  (VTBL_ENTRY)&_ZN6S672C53v10Ev,
  (VTBL_ENTRY)&_ZN6S672C53v11Ev,
  (VTBL_ENTRY)&_ZN6S672C53v12Ev,
  (VTBL_ENTRY)&_ZN6S672C53v13Ev,
  (VTBL_ENTRY)&_ZN6S672C53v14Ev,
  (VTBL_ENTRY)&_ZN6S672C53v15Ev,
  (VTBL_ENTRY)&_ZN6S672C53v16Ev,
  (VTBL_ENTRY)&_ZN6S672C53v17Ev,
  (VTBL_ENTRY)&_ZN6S672C53v18Ev,
  (VTBL_ENTRY)&_ZN6S672C53v19Ev,
  (VTBL_ENTRY)&_ZN6S672C53v20Ev,
  (VTBL_ENTRY)&_ZN6S672C53v21Ev,
  (VTBL_ENTRY)&_ZN6S672C53v22Ev,
  (VTBL_ENTRY)&_ZN6S672C53v23Ev,
  (VTBL_ENTRY)&_ZN6S672C53v24Ev,
  (VTBL_ENTRY)&_ZN6S672C53v25Ev,
  (VTBL_ENTRY)&_ZN6S672C53v26Ev,
  (VTBL_ENTRY)&_ZN6S672C53v27Ev,
  (VTBL_ENTRY)&_ZN6S672C53v28Ev,
  (VTBL_ENTRY)&_ZN6S672C53v29Ev,
  (VTBL_ENTRY)&_ZN6S672C53v30Ev,
  (VTBL_ENTRY)&_ZN6S672C53v31Ev,
  (VTBL_ENTRY)&_ZN6S672C53v32Ev,
  (VTBL_ENTRY)&_ZN6S672C53v33Ev,
  (VTBL_ENTRY)&_ZN6S672C53v34Ev,
  (VTBL_ENTRY)&_ZN6S672C53v35Ev,
  (VTBL_ENTRY)&_ZN6S672C53v36Ev,
  (VTBL_ENTRY)&_ZN6S672C53v37Ev,
  (VTBL_ENTRY)&_ZN6S672C53v38Ev,
  (VTBL_ENTRY)&_ZN6S672C53v39Ev,
  (VTBL_ENTRY)&_ZN6S672C53v40Ev,
  (VTBL_ENTRY)&_ZN6S672C53v41Ev,
  (VTBL_ENTRY)&_ZN6S672C53v42Ev,
  (VTBL_ENTRY)&_ZN6S672C53v43Ev,
  (VTBL_ENTRY)&_ZN6S672C53v44Ev,
  (VTBL_ENTRY)&_ZN6S672C53v45Ev,
  (VTBL_ENTRY)&_ZN6S672C53v46Ev,
  (VTBL_ENTRY)&_ZN6S672C53v47Ev,
  (VTBL_ENTRY)&_ZN6S672C53v48Ev,
  (VTBL_ENTRY)&_ZN6S672C53v49Ev,
  (VTBL_ENTRY)&_ZN6S672C53v50Ev,
  (VTBL_ENTRY)&_ZN6S672C53v51Ev,
  (VTBL_ENTRY)&_ZN6S672C53v52Ev,
  (VTBL_ENTRY)&_ZN6S672C53v53Ev,
  (VTBL_ENTRY)&_ZN6S672C53v54Ev,
  (VTBL_ENTRY)&_ZN6S672C53v55Ev,
  (VTBL_ENTRY)&_ZN6S672C53v56Ev,
  (VTBL_ENTRY)&_ZN6S672C53v57Ev,
  (VTBL_ENTRY)&_ZN6S672C53v58Ev,
  (VTBL_ENTRY)&_ZN6S672C53v59Ev,
  (VTBL_ENTRY)&_ZN6S672C53v60Ev,
  (VTBL_ENTRY)&_ZN6S672C53v61Ev,
  (VTBL_ENTRY)&_ZN6S672C53v62Ev,
  (VTBL_ENTRY)&_ZN6S672C53v63Ev,
  (VTBL_ENTRY)&_ZN6S672C53v64Ev,
  (VTBL_ENTRY)&_ZN6S672C53v65Ev,
  (VTBL_ENTRY)&_ZN6S672C53v66Ev,
  (VTBL_ENTRY)&_ZN6S672C53v67Ev,
  (VTBL_ENTRY)&_ZN6S672C53v68Ev,
  (VTBL_ENTRY)&_ZN6S672C53v69Ev,
  (VTBL_ENTRY)&_ZN6S672C43v70Ev,
  (VTBL_ENTRY)&_ZN6S672C43v71Ev,
  (VTBL_ENTRY)&_ZN6S672C43v72Ev,
  (VTBL_ENTRY)&_ZN6S672C43v73Ev,
  (VTBL_ENTRY)&_ZN6S672C43v74Ev,
  (VTBL_ENTRY)&_ZN6S672C43v75Ev,
  (VTBL_ENTRY)&_ZN6S672C43v76Ev,
  (VTBL_ENTRY)&_ZN6S672C43v77Ev,
  (VTBL_ENTRY)&_ZN6S672C43v78Ev,
  (VTBL_ENTRY)&_ZN6S672C43v79Ev,
  (VTBL_ENTRY)&_ZN6S672C43v80Ev,
  (VTBL_ENTRY)&_ZN6S672C43v81Ev,
  (VTBL_ENTRY)&_ZN6S672C43v82Ev,
  (VTBL_ENTRY)&_ZN6S672C43v83Ev,
  (VTBL_ENTRY)&_ZN6S672C43v84Ev,
  (VTBL_ENTRY)&_ZN6S672C43v85Ev,
  (VTBL_ENTRY)&_ZN6S672C43v86Ev,
  (VTBL_ENTRY)&_ZN6S672C43v87Ev,
  (VTBL_ENTRY)&_ZN6S672C43v88Ev,
  (VTBL_ENTRY)&_ZN6S672C43v89Ev,
  (VTBL_ENTRY)&_ZN6S672C43v90Ev,
  (VTBL_ENTRY)&_ZN6S672C43v91Ev,
  (VTBL_ENTRY)&_ZN6S672C33v92Ev,
  (VTBL_ENTRY)&_ZN6S672C33v93Ev,
  (VTBL_ENTRY)&_ZN6S672C33v94Ev,
  (VTBL_ENTRY)&_ZN6S672C33v95Ev,
  (VTBL_ENTRY)&_ZN6S672C33v96Ev,
  (VTBL_ENTRY)&_ZN6S672C33v97Ev,
  (VTBL_ENTRY)&_ZN6S672C33v98Ev,
  (VTBL_ENTRY)&_ZN6S672C33v99Ev,
  (VTBL_ENTRY)&_ZN6S672C34v100Ev,
  (VTBL_ENTRY)&_ZN6S672C34v101Ev,
  (VTBL_ENTRY)&_ZN6S672C34v102Ev,
  (VTBL_ENTRY)&_ZN6S672C34v103Ev,
  (VTBL_ENTRY)&_ZN6S672C34v104Ev,
  (VTBL_ENTRY)&_ZN6S672C34v105Ev,
  (VTBL_ENTRY)&_ZN6S672C34v106Ev,
  (VTBL_ENTRY)&_ZN6S672C34v107Ev,
  (VTBL_ENTRY)&_ZN6S672C34v108Ev,
  (VTBL_ENTRY)&_ZN6S672C34v109Ev,
  (VTBL_ENTRY)&_ZN6S672C34v110Ev,
};
extern VTBL_ENTRY _ZTI6S672C3[];
extern  VTBL_ENTRY _ZTV6S672C3[];
Class_Descriptor cd_S672C3 = {  "S672C3", // class name
  bases_S672C3, 2,
  &(vtc_S672C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S672C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S672C3),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S672C2  : S672C3 {
  void *s672c2f0;
  virtual  ~S672C2(); // _ZN6S672C2D1Ev
  virtual void  v111(); // _ZN6S672C24v111Ev
  virtual void  v112(); // _ZN6S672C24v112Ev
  virtual void  v113(); // _ZN6S672C24v113Ev
  virtual void  v114(); // _ZN6S672C24v114Ev
  virtual void  v115(); // _ZN6S672C24v115Ev
  virtual void  v116(); // _ZN6S672C24v116Ev
  virtual void  v117(); // _ZN6S672C24v117Ev
  virtual void  v118(); // _ZN6S672C24v118Ev
  virtual void  v119(); // _ZN6S672C24v119Ev
  S672C2(); // tgen
};
//SIG(-1 S672C2) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 FC5} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp}


 S672C2 ::~S672C2(){ note_dtor("S672C2", this);}
void  S672C2 ::v111(){vfunc_called(this, "_ZN6S672C24v111Ev");}
void  S672C2 ::v112(){vfunc_called(this, "_ZN6S672C24v112Ev");}
void  S672C2 ::v113(){vfunc_called(this, "_ZN6S672C24v113Ev");}
void  S672C2 ::v114(){vfunc_called(this, "_ZN6S672C24v114Ev");}
void  S672C2 ::v115(){vfunc_called(this, "_ZN6S672C24v115Ev");}
void  S672C2 ::v116(){vfunc_called(this, "_ZN6S672C24v116Ev");}
void  S672C2 ::v117(){vfunc_called(this, "_ZN6S672C24v117Ev");}
void  S672C2 ::v118(){vfunc_called(this, "_ZN6S672C24v118Ev");}
void  S672C2 ::v119(){vfunc_called(this, "_ZN6S672C24v119Ev");}
S672C2 ::S672C2(){ note_ctor("S672C2", this);} // tgen

static void Test_S672C2()
{
  extern Class_Descriptor cd_S672C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,37)];
    init_test(&cd_S672C2, buf);
    S672C2 *dp, &lv = *(dp=new (buf) S672C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,144), "sizeof(S672C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S672C2)");
    check_base_class_offset(lv, (S672C5*)(S672C4*)(S672C3*), 0, "S672C2");
    check_base_class_offset(lv, (S672C4*)(S672C3*), 0, "S672C2");
    check_base_class_offset(lv, (S672C3*), 0, "S672C2");
    check_field_offset(lv, s672c2f0, ABISELECT(200,140), "S672C2.s672c2f0");
    test_class_info(&lv, &cd_S672C2);
    dp->~S672C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS672C2(Test_S672C2, "S672C2", ABISELECT(208,144));

#else // __cplusplus

extern void _ZN6S672C2C1Ev();
extern void _ZN6S672C2D1Ev();
Name_Map name_map_S672C2[] = {
  NSPAIR(_ZN6S672C2C1Ev),
  NSPAIR(_ZN6S672C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S672C5;
extern VTBL_ENTRY _ZTI6S672C5[];
extern  VTBL_ENTRY _ZTV6S672C5[];
extern Class_Descriptor cd_S672C4;
extern VTBL_ENTRY _ZTI6S672C4[];
extern  VTBL_ENTRY _ZTV6S672C4[];
extern Class_Descriptor cd_S672C3;
extern VTBL_ENTRY _ZTI6S672C3[];
extern  VTBL_ENTRY _ZTV6S672C3[];
static Base_Class bases_S672C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S672C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S672C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S672C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S672C2[];
extern void _ZN6S672C2D1Ev();
extern void _ZN6S672C2D0Ev();
extern void _ZN6S672C52v6Ev();
extern void _ZN6S672C52v7Ev();
extern void _ZN6S672C52v8Ev();
extern void _ZN6S672C52v9Ev();
extern void _ZN6S672C53v10Ev();
extern void _ZN6S672C53v11Ev();
extern void _ZN6S672C53v12Ev();
extern void _ZN6S672C53v13Ev();
extern void _ZN6S672C53v14Ev();
extern void _ZN6S672C53v15Ev();
extern void _ZN6S672C53v16Ev();
extern void _ZN6S672C53v17Ev();
extern void _ZN6S672C53v18Ev();
extern void _ZN6S672C53v19Ev();
extern void _ZN6S672C53v20Ev();
extern void _ZN6S672C53v21Ev();
extern void _ZN6S672C53v22Ev();
extern void _ZN6S672C53v23Ev();
extern void _ZN6S672C53v24Ev();
extern void _ZN6S672C53v25Ev();
extern void _ZN6S672C53v26Ev();
extern void _ZN6S672C53v27Ev();
extern void _ZN6S672C53v28Ev();
extern void _ZN6S672C53v29Ev();
extern void _ZN6S672C53v30Ev();
extern void _ZN6S672C53v31Ev();
extern void _ZN6S672C53v32Ev();
extern void _ZN6S672C53v33Ev();
extern void _ZN6S672C53v34Ev();
extern void _ZN6S672C53v35Ev();
extern void _ZN6S672C53v36Ev();
extern void _ZN6S672C53v37Ev();
extern void _ZN6S672C53v38Ev();
extern void _ZN6S672C53v39Ev();
extern void _ZN6S672C53v40Ev();
extern void _ZN6S672C53v41Ev();
extern void _ZN6S672C53v42Ev();
extern void _ZN6S672C53v43Ev();
extern void _ZN6S672C53v44Ev();
extern void _ZN6S672C53v45Ev();
extern void _ZN6S672C53v46Ev();
extern void _ZN6S672C53v47Ev();
extern void _ZN6S672C53v48Ev();
extern void _ZN6S672C53v49Ev();
extern void _ZN6S672C53v50Ev();
extern void _ZN6S672C53v51Ev();
extern void _ZN6S672C53v52Ev();
extern void _ZN6S672C53v53Ev();
extern void _ZN6S672C53v54Ev();
extern void _ZN6S672C53v55Ev();
extern void _ZN6S672C53v56Ev();
extern void _ZN6S672C53v57Ev();
extern void _ZN6S672C53v58Ev();
extern void _ZN6S672C53v59Ev();
extern void _ZN6S672C53v60Ev();
extern void _ZN6S672C53v61Ev();
extern void _ZN6S672C53v62Ev();
extern void _ZN6S672C53v63Ev();
extern void _ZN6S672C53v64Ev();
extern void _ZN6S672C53v65Ev();
extern void _ZN6S672C53v66Ev();
extern void _ZN6S672C53v67Ev();
extern void _ZN6S672C53v68Ev();
extern void _ZN6S672C53v69Ev();
extern void _ZN6S672C43v70Ev();
extern void _ZN6S672C43v71Ev();
extern void _ZN6S672C43v72Ev();
extern void _ZN6S672C43v73Ev();
extern void _ZN6S672C43v74Ev();
extern void _ZN6S672C43v75Ev();
extern void _ZN6S672C43v76Ev();
extern void _ZN6S672C43v77Ev();
extern void _ZN6S672C43v78Ev();
extern void _ZN6S672C43v79Ev();
extern void _ZN6S672C43v80Ev();
extern void _ZN6S672C43v81Ev();
extern void _ZN6S672C43v82Ev();
extern void _ZN6S672C43v83Ev();
extern void _ZN6S672C43v84Ev();
extern void _ZN6S672C43v85Ev();
extern void _ZN6S672C43v86Ev();
extern void _ZN6S672C43v87Ev();
extern void _ZN6S672C43v88Ev();
extern void _ZN6S672C43v89Ev();
extern void _ZN6S672C43v90Ev();
extern void _ZN6S672C43v91Ev();
extern void _ZN6S672C33v92Ev();
extern void _ZN6S672C33v93Ev();
extern void _ZN6S672C33v94Ev();
extern void _ZN6S672C33v95Ev();
extern void _ZN6S672C33v96Ev();
extern void _ZN6S672C33v97Ev();
extern void _ZN6S672C33v98Ev();
extern void _ZN6S672C33v99Ev();
extern void _ZN6S672C34v100Ev();
extern void _ZN6S672C34v101Ev();
extern void _ZN6S672C34v102Ev();
extern void _ZN6S672C34v103Ev();
extern void _ZN6S672C34v104Ev();
extern void _ZN6S672C34v105Ev();
extern void _ZN6S672C34v106Ev();
extern void _ZN6S672C34v107Ev();
extern void _ZN6S672C34v108Ev();
extern void _ZN6S672C34v109Ev();
extern void _ZN6S672C34v110Ev();
extern void _ZN6S672C24v111Ev();
extern void _ZN6S672C24v112Ev();
extern void _ZN6S672C24v113Ev();
extern void _ZN6S672C24v114Ev();
extern void _ZN6S672C24v115Ev();
extern void _ZN6S672C24v116Ev();
extern void _ZN6S672C24v117Ev();
extern void _ZN6S672C24v118Ev();
extern void _ZN6S672C24v119Ev();
static  VTBL_ENTRY vtc_S672C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S672C2[0]),
  (VTBL_ENTRY)&_ZN6S672C2D1Ev,
  (VTBL_ENTRY)&_ZN6S672C2D0Ev,
  (VTBL_ENTRY)&_ZN6S672C52v6Ev,
  (VTBL_ENTRY)&_ZN6S672C52v7Ev,
  (VTBL_ENTRY)&_ZN6S672C52v8Ev,
  (VTBL_ENTRY)&_ZN6S672C52v9Ev,
  (VTBL_ENTRY)&_ZN6S672C53v10Ev,
  (VTBL_ENTRY)&_ZN6S672C53v11Ev,
  (VTBL_ENTRY)&_ZN6S672C53v12Ev,
  (VTBL_ENTRY)&_ZN6S672C53v13Ev,
  (VTBL_ENTRY)&_ZN6S672C53v14Ev,
  (VTBL_ENTRY)&_ZN6S672C53v15Ev,
  (VTBL_ENTRY)&_ZN6S672C53v16Ev,
  (VTBL_ENTRY)&_ZN6S672C53v17Ev,
  (VTBL_ENTRY)&_ZN6S672C53v18Ev,
  (VTBL_ENTRY)&_ZN6S672C53v19Ev,
  (VTBL_ENTRY)&_ZN6S672C53v20Ev,
  (VTBL_ENTRY)&_ZN6S672C53v21Ev,
  (VTBL_ENTRY)&_ZN6S672C53v22Ev,
  (VTBL_ENTRY)&_ZN6S672C53v23Ev,
  (VTBL_ENTRY)&_ZN6S672C53v24Ev,
  (VTBL_ENTRY)&_ZN6S672C53v25Ev,
  (VTBL_ENTRY)&_ZN6S672C53v26Ev,
  (VTBL_ENTRY)&_ZN6S672C53v27Ev,
  (VTBL_ENTRY)&_ZN6S672C53v28Ev,
  (VTBL_ENTRY)&_ZN6S672C53v29Ev,
  (VTBL_ENTRY)&_ZN6S672C53v30Ev,
  (VTBL_ENTRY)&_ZN6S672C53v31Ev,
  (VTBL_ENTRY)&_ZN6S672C53v32Ev,
  (VTBL_ENTRY)&_ZN6S672C53v33Ev,
  (VTBL_ENTRY)&_ZN6S672C53v34Ev,
  (VTBL_ENTRY)&_ZN6S672C53v35Ev,
  (VTBL_ENTRY)&_ZN6S672C53v36Ev,
  (VTBL_ENTRY)&_ZN6S672C53v37Ev,
  (VTBL_ENTRY)&_ZN6S672C53v38Ev,
  (VTBL_ENTRY)&_ZN6S672C53v39Ev,
  (VTBL_ENTRY)&_ZN6S672C53v40Ev,
  (VTBL_ENTRY)&_ZN6S672C53v41Ev,
  (VTBL_ENTRY)&_ZN6S672C53v42Ev,
  (VTBL_ENTRY)&_ZN6S672C53v43Ev,
  (VTBL_ENTRY)&_ZN6S672C53v44Ev,
  (VTBL_ENTRY)&_ZN6S672C53v45Ev,
  (VTBL_ENTRY)&_ZN6S672C53v46Ev,
  (VTBL_ENTRY)&_ZN6S672C53v47Ev,
  (VTBL_ENTRY)&_ZN6S672C53v48Ev,
  (VTBL_ENTRY)&_ZN6S672C53v49Ev,
  (VTBL_ENTRY)&_ZN6S672C53v50Ev,
  (VTBL_ENTRY)&_ZN6S672C53v51Ev,
  (VTBL_ENTRY)&_ZN6S672C53v52Ev,
  (VTBL_ENTRY)&_ZN6S672C53v53Ev,
  (VTBL_ENTRY)&_ZN6S672C53v54Ev,
  (VTBL_ENTRY)&_ZN6S672C53v55Ev,
  (VTBL_ENTRY)&_ZN6S672C53v56Ev,
  (VTBL_ENTRY)&_ZN6S672C53v57Ev,
  (VTBL_ENTRY)&_ZN6S672C53v58Ev,
  (VTBL_ENTRY)&_ZN6S672C53v59Ev,
  (VTBL_ENTRY)&_ZN6S672C53v60Ev,
  (VTBL_ENTRY)&_ZN6S672C53v61Ev,
  (VTBL_ENTRY)&_ZN6S672C53v62Ev,
  (VTBL_ENTRY)&_ZN6S672C53v63Ev,
  (VTBL_ENTRY)&_ZN6S672C53v64Ev,
  (VTBL_ENTRY)&_ZN6S672C53v65Ev,
  (VTBL_ENTRY)&_ZN6S672C53v66Ev,
  (VTBL_ENTRY)&_ZN6S672C53v67Ev,
  (VTBL_ENTRY)&_ZN6S672C53v68Ev,
  (VTBL_ENTRY)&_ZN6S672C53v69Ev,
  (VTBL_ENTRY)&_ZN6S672C43v70Ev,
  (VTBL_ENTRY)&_ZN6S672C43v71Ev,
  (VTBL_ENTRY)&_ZN6S672C43v72Ev,
  (VTBL_ENTRY)&_ZN6S672C43v73Ev,
  (VTBL_ENTRY)&_ZN6S672C43v74Ev,
  (VTBL_ENTRY)&_ZN6S672C43v75Ev,
  (VTBL_ENTRY)&_ZN6S672C43v76Ev,
  (VTBL_ENTRY)&_ZN6S672C43v77Ev,
  (VTBL_ENTRY)&_ZN6S672C43v78Ev,
  (VTBL_ENTRY)&_ZN6S672C43v79Ev,
  (VTBL_ENTRY)&_ZN6S672C43v80Ev,
  (VTBL_ENTRY)&_ZN6S672C43v81Ev,
  (VTBL_ENTRY)&_ZN6S672C43v82Ev,
  (VTBL_ENTRY)&_ZN6S672C43v83Ev,
  (VTBL_ENTRY)&_ZN6S672C43v84Ev,
  (VTBL_ENTRY)&_ZN6S672C43v85Ev,
  (VTBL_ENTRY)&_ZN6S672C43v86Ev,
  (VTBL_ENTRY)&_ZN6S672C43v87Ev,
  (VTBL_ENTRY)&_ZN6S672C43v88Ev,
  (VTBL_ENTRY)&_ZN6S672C43v89Ev,
  (VTBL_ENTRY)&_ZN6S672C43v90Ev,
  (VTBL_ENTRY)&_ZN6S672C43v91Ev,
  (VTBL_ENTRY)&_ZN6S672C33v92Ev,
  (VTBL_ENTRY)&_ZN6S672C33v93Ev,
  (VTBL_ENTRY)&_ZN6S672C33v94Ev,
  (VTBL_ENTRY)&_ZN6S672C33v95Ev,
  (VTBL_ENTRY)&_ZN6S672C33v96Ev,
  (VTBL_ENTRY)&_ZN6S672C33v97Ev,
  (VTBL_ENTRY)&_ZN6S672C33v98Ev,
  (VTBL_ENTRY)&_ZN6S672C33v99Ev,
  (VTBL_ENTRY)&_ZN6S672C34v100Ev,
  (VTBL_ENTRY)&_ZN6S672C34v101Ev,
  (VTBL_ENTRY)&_ZN6S672C34v102Ev,
  (VTBL_ENTRY)&_ZN6S672C34v103Ev,
  (VTBL_ENTRY)&_ZN6S672C34v104Ev,
  (VTBL_ENTRY)&_ZN6S672C34v105Ev,
  (VTBL_ENTRY)&_ZN6S672C34v106Ev,
  (VTBL_ENTRY)&_ZN6S672C34v107Ev,
  (VTBL_ENTRY)&_ZN6S672C34v108Ev,
  (VTBL_ENTRY)&_ZN6S672C34v109Ev,
  (VTBL_ENTRY)&_ZN6S672C34v110Ev,
  (VTBL_ENTRY)&_ZN6S672C24v111Ev,
  (VTBL_ENTRY)&_ZN6S672C24v112Ev,
  (VTBL_ENTRY)&_ZN6S672C24v113Ev,
  (VTBL_ENTRY)&_ZN6S672C24v114Ev,
  (VTBL_ENTRY)&_ZN6S672C24v115Ev,
  (VTBL_ENTRY)&_ZN6S672C24v116Ev,
  (VTBL_ENTRY)&_ZN6S672C24v117Ev,
  (VTBL_ENTRY)&_ZN6S672C24v118Ev,
  (VTBL_ENTRY)&_ZN6S672C24v119Ev,
};
extern VTBL_ENTRY _ZTI6S672C2[];
extern  VTBL_ENTRY _ZTV6S672C2[];
Class_Descriptor cd_S672C2 = {  "S672C2", // class name
  bases_S672C2, 3,
  &(vtc_S672C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,144), // object size
  NSPAIRA(_ZTI6S672C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S672C2),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S672C15  : S473C10_nt {
};
//SIG(-1 S672C15) C1{ BC2{ m Fp Fi[2]}}



static void Test_S672C15()
{
  extern Class_Descriptor cd_S672C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S672C15, buf);
    S672C15 &lv = *(new (buf) S672C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S672C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S672C15)");
    check_base_class_offset(lv, (S473C10_nt*), 0, "S672C15");
    test_class_info(&lv, &cd_S672C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS672C15(Test_S672C15, "S672C15", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S473C10_nt;
static Base_Class bases_S672C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S473C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S672C15 = {  "S672C15", // class name
  bases_S672C15, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S672C14_nt  : S672C15 {
};
//SIG(-1 S672C14_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S672C14_nt

#else // __cplusplus

extern Class_Descriptor cd_S473C10_nt;
extern Class_Descriptor cd_S672C15;
static Base_Class bases_S672C14_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S473C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S672C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S672C1  : S672C2 {
  int s672c1f0;
  ::S473C8_nt s672c1f1;
  ::S672C14_nt s672c1f2;
  unsigned int s672c1f3:1;
  virtual  ~S672C1(); // _ZN6S672C1D1Ev
  virtual void  v1(); // _ZN6S672C12v1Ev
  virtual void  v2(); // _ZN6S672C12v2Ev
  virtual void  v3(); // _ZN6S672C12v3Ev
  virtual void  v4(); // _ZN6S672C12v4Ev
  virtual void  v5(); // _ZN6S672C12v5Ev
  S672C1(); // tgen
};
//SIG(1 S672C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC6} vd v111 v112 v113 v114 v115 v116 v117 v118 v119 Fp} vd v1 v2 v3 v4 v5 Fi FC8 FC12{ BC13{ BC10}} Fi:1}


 S672C1 ::~S672C1(){ note_dtor("S672C1", this);}
void  S672C1 ::v1(){vfunc_called(this, "_ZN6S672C12v1Ev");}
void  S672C1 ::v2(){vfunc_called(this, "_ZN6S672C12v2Ev");}
void  S672C1 ::v3(){vfunc_called(this, "_ZN6S672C12v3Ev");}
void  S672C1 ::v4(){vfunc_called(this, "_ZN6S672C12v4Ev");}
void  S672C1 ::v5(){vfunc_called(this, "_ZN6S672C12v5Ev");}
S672C1 ::S672C1(){ note_ctor("S672C1", this);} // tgen

static void Test_S672C1()
{
  extern Class_Descriptor cd_S672C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,45)];
    init_test(&cd_S672C1, buf);
    S672C1 *dp, &lv = *(dp=new (buf) S672C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,176), "sizeof(S672C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S672C1)");
    check_base_class_offset(lv, (S672C5*)(S672C4*)(S672C3*)(S672C2*), 0, "S672C1");
    check_base_class_offset(lv, (S672C4*)(S672C3*)(S672C2*), 0, "S672C1");
    check_base_class_offset(lv, (S672C3*)(S672C2*), 0, "S672C1");
    check_base_class_offset(lv, (S672C2*), 0, "S672C1");
    check_field_offset(lv, s672c1f0, ABISELECT(208,144), "S672C1.s672c1f0");
    check_field_offset(lv, s672c1f1, ABISELECT(216,148), "S672C1.s672c1f1");
    check_field_offset(lv, s672c1f2, ABISELECT(232,160), "S672C1.s672c1f2");
    set_bf_and_test(lv, s672c1f3, ABISELECT(248,172), 0, 1, 1, "S672C1");
    test_class_info(&lv, &cd_S672C1);
    dp->~S672C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS672C1(Test_S672C1, "S672C1", ABISELECT(256,176));

#else // __cplusplus

extern void _ZN6S672C1C1Ev();
extern void _ZN6S672C1D1Ev();
Name_Map name_map_S672C1[] = {
  NSPAIR(_ZN6S672C1C1Ev),
  NSPAIR(_ZN6S672C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S672C5;
extern VTBL_ENTRY _ZTI6S672C5[];
extern  VTBL_ENTRY _ZTV6S672C5[];
extern Class_Descriptor cd_S672C4;
extern VTBL_ENTRY _ZTI6S672C4[];
extern  VTBL_ENTRY _ZTV6S672C4[];
extern Class_Descriptor cd_S672C3;
extern VTBL_ENTRY _ZTI6S672C3[];
extern  VTBL_ENTRY _ZTV6S672C3[];
extern Class_Descriptor cd_S672C2;
extern VTBL_ENTRY _ZTI6S672C2[];
extern  VTBL_ENTRY _ZTV6S672C2[];
static Base_Class bases_S672C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S672C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S672C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S672C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S672C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S672C1[];
extern void _ZN6S672C1D1Ev();
extern void _ZN6S672C1D0Ev();
extern void _ZN6S672C52v6Ev();
extern void _ZN6S672C52v7Ev();
extern void _ZN6S672C52v8Ev();
extern void _ZN6S672C52v9Ev();
extern void _ZN6S672C53v10Ev();
extern void _ZN6S672C53v11Ev();
extern void _ZN6S672C53v12Ev();
extern void _ZN6S672C53v13Ev();
extern void _ZN6S672C53v14Ev();
extern void _ZN6S672C53v15Ev();
extern void _ZN6S672C53v16Ev();
extern void _ZN6S672C53v17Ev();
extern void _ZN6S672C53v18Ev();
extern void _ZN6S672C53v19Ev();
extern void _ZN6S672C53v20Ev();
extern void _ZN6S672C53v21Ev();
extern void _ZN6S672C53v22Ev();
extern void _ZN6S672C53v23Ev();
extern void _ZN6S672C53v24Ev();
extern void _ZN6S672C53v25Ev();
extern void _ZN6S672C53v26Ev();
extern void _ZN6S672C53v27Ev();
extern void _ZN6S672C53v28Ev();
extern void _ZN6S672C53v29Ev();
extern void _ZN6S672C53v30Ev();
extern void _ZN6S672C53v31Ev();
extern void _ZN6S672C53v32Ev();
extern void _ZN6S672C53v33Ev();
extern void _ZN6S672C53v34Ev();
extern void _ZN6S672C53v35Ev();
extern void _ZN6S672C53v36Ev();
extern void _ZN6S672C53v37Ev();
extern void _ZN6S672C53v38Ev();
extern void _ZN6S672C53v39Ev();
extern void _ZN6S672C53v40Ev();
extern void _ZN6S672C53v41Ev();
extern void _ZN6S672C53v42Ev();
extern void _ZN6S672C53v43Ev();
extern void _ZN6S672C53v44Ev();
extern void _ZN6S672C53v45Ev();
extern void _ZN6S672C53v46Ev();
extern void _ZN6S672C53v47Ev();
extern void _ZN6S672C53v48Ev();
extern void _ZN6S672C53v49Ev();
extern void _ZN6S672C53v50Ev();
extern void _ZN6S672C53v51Ev();
extern void _ZN6S672C53v52Ev();
extern void _ZN6S672C53v53Ev();
extern void _ZN6S672C53v54Ev();
extern void _ZN6S672C53v55Ev();
extern void _ZN6S672C53v56Ev();
extern void _ZN6S672C53v57Ev();
extern void _ZN6S672C53v58Ev();
extern void _ZN6S672C53v59Ev();
extern void _ZN6S672C53v60Ev();
extern void _ZN6S672C53v61Ev();
extern void _ZN6S672C53v62Ev();
extern void _ZN6S672C53v63Ev();
extern void _ZN6S672C53v64Ev();
extern void _ZN6S672C53v65Ev();
extern void _ZN6S672C53v66Ev();
extern void _ZN6S672C53v67Ev();
extern void _ZN6S672C53v68Ev();
extern void _ZN6S672C53v69Ev();
extern void _ZN6S672C43v70Ev();
extern void _ZN6S672C43v71Ev();
extern void _ZN6S672C43v72Ev();
extern void _ZN6S672C43v73Ev();
extern void _ZN6S672C43v74Ev();
extern void _ZN6S672C43v75Ev();
extern void _ZN6S672C43v76Ev();
extern void _ZN6S672C43v77Ev();
extern void _ZN6S672C43v78Ev();
extern void _ZN6S672C43v79Ev();
extern void _ZN6S672C43v80Ev();
extern void _ZN6S672C43v81Ev();
extern void _ZN6S672C43v82Ev();
extern void _ZN6S672C43v83Ev();
extern void _ZN6S672C43v84Ev();
extern void _ZN6S672C43v85Ev();
extern void _ZN6S672C43v86Ev();
extern void _ZN6S672C43v87Ev();
extern void _ZN6S672C43v88Ev();
extern void _ZN6S672C43v89Ev();
extern void _ZN6S672C43v90Ev();
extern void _ZN6S672C43v91Ev();
extern void _ZN6S672C33v92Ev();
extern void _ZN6S672C33v93Ev();
extern void _ZN6S672C33v94Ev();
extern void _ZN6S672C33v95Ev();
extern void _ZN6S672C33v96Ev();
extern void _ZN6S672C33v97Ev();
extern void _ZN6S672C33v98Ev();
extern void _ZN6S672C33v99Ev();
extern void _ZN6S672C34v100Ev();
extern void _ZN6S672C34v101Ev();
extern void _ZN6S672C34v102Ev();
extern void _ZN6S672C34v103Ev();
extern void _ZN6S672C34v104Ev();
extern void _ZN6S672C34v105Ev();
extern void _ZN6S672C34v106Ev();
extern void _ZN6S672C34v107Ev();
extern void _ZN6S672C34v108Ev();
extern void _ZN6S672C34v109Ev();
extern void _ZN6S672C34v110Ev();
extern void _ZN6S672C24v111Ev();
extern void _ZN6S672C24v112Ev();
extern void _ZN6S672C24v113Ev();
extern void _ZN6S672C24v114Ev();
extern void _ZN6S672C24v115Ev();
extern void _ZN6S672C24v116Ev();
extern void _ZN6S672C24v117Ev();
extern void _ZN6S672C24v118Ev();
extern void _ZN6S672C24v119Ev();
extern void _ZN6S672C12v1Ev();
extern void _ZN6S672C12v2Ev();
extern void _ZN6S672C12v3Ev();
extern void _ZN6S672C12v4Ev();
extern void _ZN6S672C12v5Ev();
static  VTBL_ENTRY vtc_S672C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S672C1[0]),
  (VTBL_ENTRY)&_ZN6S672C1D1Ev,
  (VTBL_ENTRY)&_ZN6S672C1D0Ev,
  (VTBL_ENTRY)&_ZN6S672C52v6Ev,
  (VTBL_ENTRY)&_ZN6S672C52v7Ev,
  (VTBL_ENTRY)&_ZN6S672C52v8Ev,
  (VTBL_ENTRY)&_ZN6S672C52v9Ev,
  (VTBL_ENTRY)&_ZN6S672C53v10Ev,
  (VTBL_ENTRY)&_ZN6S672C53v11Ev,
  (VTBL_ENTRY)&_ZN6S672C53v12Ev,
  (VTBL_ENTRY)&_ZN6S672C53v13Ev,
  (VTBL_ENTRY)&_ZN6S672C53v14Ev,
  (VTBL_ENTRY)&_ZN6S672C53v15Ev,
  (VTBL_ENTRY)&_ZN6S672C53v16Ev,
  (VTBL_ENTRY)&_ZN6S672C53v17Ev,
  (VTBL_ENTRY)&_ZN6S672C53v18Ev,
  (VTBL_ENTRY)&_ZN6S672C53v19Ev,
  (VTBL_ENTRY)&_ZN6S672C53v20Ev,
  (VTBL_ENTRY)&_ZN6S672C53v21Ev,
  (VTBL_ENTRY)&_ZN6S672C53v22Ev,
  (VTBL_ENTRY)&_ZN6S672C53v23Ev,
  (VTBL_ENTRY)&_ZN6S672C53v24Ev,
  (VTBL_ENTRY)&_ZN6S672C53v25Ev,
  (VTBL_ENTRY)&_ZN6S672C53v26Ev,
  (VTBL_ENTRY)&_ZN6S672C53v27Ev,
  (VTBL_ENTRY)&_ZN6S672C53v28Ev,
  (VTBL_ENTRY)&_ZN6S672C53v29Ev,
  (VTBL_ENTRY)&_ZN6S672C53v30Ev,
  (VTBL_ENTRY)&_ZN6S672C53v31Ev,
  (VTBL_ENTRY)&_ZN6S672C53v32Ev,
  (VTBL_ENTRY)&_ZN6S672C53v33Ev,
  (VTBL_ENTRY)&_ZN6S672C53v34Ev,
  (VTBL_ENTRY)&_ZN6S672C53v35Ev,
  (VTBL_ENTRY)&_ZN6S672C53v36Ev,
  (VTBL_ENTRY)&_ZN6S672C53v37Ev,
  (VTBL_ENTRY)&_ZN6S672C53v38Ev,
  (VTBL_ENTRY)&_ZN6S672C53v39Ev,
  (VTBL_ENTRY)&_ZN6S672C53v40Ev,
  (VTBL_ENTRY)&_ZN6S672C53v41Ev,
  (VTBL_ENTRY)&_ZN6S672C53v42Ev,
  (VTBL_ENTRY)&_ZN6S672C53v43Ev,
  (VTBL_ENTRY)&_ZN6S672C53v44Ev,
  (VTBL_ENTRY)&_ZN6S672C53v45Ev,
  (VTBL_ENTRY)&_ZN6S672C53v46Ev,
  (VTBL_ENTRY)&_ZN6S672C53v47Ev,
  (VTBL_ENTRY)&_ZN6S672C53v48Ev,
  (VTBL_ENTRY)&_ZN6S672C53v49Ev,
  (VTBL_ENTRY)&_ZN6S672C53v50Ev,
  (VTBL_ENTRY)&_ZN6S672C53v51Ev,
  (VTBL_ENTRY)&_ZN6S672C53v52Ev,
  (VTBL_ENTRY)&_ZN6S672C53v53Ev,
  (VTBL_ENTRY)&_ZN6S672C53v54Ev,
  (VTBL_ENTRY)&_ZN6S672C53v55Ev,
  (VTBL_ENTRY)&_ZN6S672C53v56Ev,
  (VTBL_ENTRY)&_ZN6S672C53v57Ev,
  (VTBL_ENTRY)&_ZN6S672C53v58Ev,
  (VTBL_ENTRY)&_ZN6S672C53v59Ev,
  (VTBL_ENTRY)&_ZN6S672C53v60Ev,
  (VTBL_ENTRY)&_ZN6S672C53v61Ev,
  (VTBL_ENTRY)&_ZN6S672C53v62Ev,
  (VTBL_ENTRY)&_ZN6S672C53v63Ev,
  (VTBL_ENTRY)&_ZN6S672C53v64Ev,
  (VTBL_ENTRY)&_ZN6S672C53v65Ev,
  (VTBL_ENTRY)&_ZN6S672C53v66Ev,
  (VTBL_ENTRY)&_ZN6S672C53v67Ev,
  (VTBL_ENTRY)&_ZN6S672C53v68Ev,
  (VTBL_ENTRY)&_ZN6S672C53v69Ev,
  (VTBL_ENTRY)&_ZN6S672C43v70Ev,
  (VTBL_ENTRY)&_ZN6S672C43v71Ev,
  (VTBL_ENTRY)&_ZN6S672C43v72Ev,
  (VTBL_ENTRY)&_ZN6S672C43v73Ev,
  (VTBL_ENTRY)&_ZN6S672C43v74Ev,
  (VTBL_ENTRY)&_ZN6S672C43v75Ev,
  (VTBL_ENTRY)&_ZN6S672C43v76Ev,
  (VTBL_ENTRY)&_ZN6S672C43v77Ev,
  (VTBL_ENTRY)&_ZN6S672C43v78Ev,
  (VTBL_ENTRY)&_ZN6S672C43v79Ev,
  (VTBL_ENTRY)&_ZN6S672C43v80Ev,
  (VTBL_ENTRY)&_ZN6S672C43v81Ev,
  (VTBL_ENTRY)&_ZN6S672C43v82Ev,
  (VTBL_ENTRY)&_ZN6S672C43v83Ev,
  (VTBL_ENTRY)&_ZN6S672C43v84Ev,
  (VTBL_ENTRY)&_ZN6S672C43v85Ev,
  (VTBL_ENTRY)&_ZN6S672C43v86Ev,
  (VTBL_ENTRY)&_ZN6S672C43v87Ev,
  (VTBL_ENTRY)&_ZN6S672C43v88Ev,
  (VTBL_ENTRY)&_ZN6S672C43v89Ev,
  (VTBL_ENTRY)&_ZN6S672C43v90Ev,
  (VTBL_ENTRY)&_ZN6S672C43v91Ev,
  (VTBL_ENTRY)&_ZN6S672C33v92Ev,
  (VTBL_ENTRY)&_ZN6S672C33v93Ev,
  (VTBL_ENTRY)&_ZN6S672C33v94Ev,
  (VTBL_ENTRY)&_ZN6S672C33v95Ev,
  (VTBL_ENTRY)&_ZN6S672C33v96Ev,
  (VTBL_ENTRY)&_ZN6S672C33v97Ev,
  (VTBL_ENTRY)&_ZN6S672C33v98Ev,
  (VTBL_ENTRY)&_ZN6S672C33v99Ev,
  (VTBL_ENTRY)&_ZN6S672C34v100Ev,
  (VTBL_ENTRY)&_ZN6S672C34v101Ev,
  (VTBL_ENTRY)&_ZN6S672C34v102Ev,
  (VTBL_ENTRY)&_ZN6S672C34v103Ev,
  (VTBL_ENTRY)&_ZN6S672C34v104Ev,
  (VTBL_ENTRY)&_ZN6S672C34v105Ev,
  (VTBL_ENTRY)&_ZN6S672C34v106Ev,
  (VTBL_ENTRY)&_ZN6S672C34v107Ev,
  (VTBL_ENTRY)&_ZN6S672C34v108Ev,
  (VTBL_ENTRY)&_ZN6S672C34v109Ev,
  (VTBL_ENTRY)&_ZN6S672C34v110Ev,
  (VTBL_ENTRY)&_ZN6S672C24v111Ev,
  (VTBL_ENTRY)&_ZN6S672C24v112Ev,
  (VTBL_ENTRY)&_ZN6S672C24v113Ev,
  (VTBL_ENTRY)&_ZN6S672C24v114Ev,
  (VTBL_ENTRY)&_ZN6S672C24v115Ev,
  (VTBL_ENTRY)&_ZN6S672C24v116Ev,
  (VTBL_ENTRY)&_ZN6S672C24v117Ev,
  (VTBL_ENTRY)&_ZN6S672C24v118Ev,
  (VTBL_ENTRY)&_ZN6S672C24v119Ev,
  (VTBL_ENTRY)&_ZN6S672C12v1Ev,
  (VTBL_ENTRY)&_ZN6S672C12v2Ev,
  (VTBL_ENTRY)&_ZN6S672C12v3Ev,
  (VTBL_ENTRY)&_ZN6S672C12v4Ev,
  (VTBL_ENTRY)&_ZN6S672C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S672C1[];
extern  VTBL_ENTRY _ZTV6S672C1[];
Class_Descriptor cd_S672C1 = {  "S672C1", // class name
  bases_S672C1, 4,
  &(vtc_S672C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,176), // object size
  NSPAIRA(_ZTI6S672C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S672C1),123, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S472C5  {
  int s472c5f0;
  __tsi64 s472c5f1;
  void *s472c5f2[4];
  int s472c5f3[2];
  void *s472c5f4;
  ::S473C6_nt s472c5f5;
  void *s472c5f6[2];
  virtual  ~S472C5(); // _ZN6S472C5D1Ev
  virtual void  v10(); // _ZN6S472C53v10Ev
  virtual void  v11(); // _ZN6S472C53v11Ev
  virtual void  v12(); // _ZN6S472C53v12Ev
  virtual void  v13(); // _ZN6S472C53v13Ev
  virtual void  v14(); // _ZN6S472C53v14Ev
  virtual void  v15(); // _ZN6S472C53v15Ev
  virtual void  v16(); // _ZN6S472C53v16Ev
  virtual void  v17(); // _ZN6S472C53v17Ev
  virtual void  v18(); // _ZN6S472C53v18Ev
  virtual void  v19(); // _ZN6S472C53v19Ev
  virtual void  v20(); // _ZN6S472C53v20Ev
  virtual void  v21(); // _ZN6S472C53v21Ev
  virtual void  v22(); // _ZN6S472C53v22Ev
  virtual void  v23(); // _ZN6S472C53v23Ev
  virtual void  v24(); // _ZN6S472C53v24Ev
  virtual void  v25(); // _ZN6S472C53v25Ev
  virtual void  v26(); // _ZN6S472C53v26Ev
  virtual void  v27(); // _ZN6S472C53v27Ev
  virtual void  v28(); // _ZN6S472C53v28Ev
  virtual void  v29(); // _ZN6S472C53v29Ev
  virtual void  v30(); // _ZN6S472C53v30Ev
  virtual void  v31(); // _ZN6S472C53v31Ev
  virtual void  v32(); // _ZN6S472C53v32Ev
  virtual void  v33(); // _ZN6S472C53v33Ev
  virtual void  v34(); // _ZN6S472C53v34Ev
  virtual void  v35(); // _ZN6S472C53v35Ev
  virtual void  v36(); // _ZN6S472C53v36Ev
  virtual void  v37(); // _ZN6S472C53v37Ev
  virtual void  v38(); // _ZN6S472C53v38Ev
  virtual void  v39(); // _ZN6S472C53v39Ev
  virtual void  v40(); // _ZN6S472C53v40Ev
  virtual void  v41(); // _ZN6S472C53v41Ev
  virtual void  v42(); // _ZN6S472C53v42Ev
  virtual void  v43(); // _ZN6S472C53v43Ev
  virtual void  v44(); // _ZN6S472C53v44Ev
  virtual void  v45(); // _ZN6S472C53v45Ev
  virtual void  v46(); // _ZN6S472C53v46Ev
  virtual void  v47(); // _ZN6S472C53v47Ev
  virtual void  v48(); // _ZN6S472C53v48Ev
  virtual void  v49(); // _ZN6S472C53v49Ev
  virtual void  v50(); // _ZN6S472C53v50Ev
  virtual void  v51(); // _ZN6S472C53v51Ev
  virtual void  v52(); // _ZN6S472C53v52Ev
  virtual void  v53(); // _ZN6S472C53v53Ev
  virtual void  v54(); // _ZN6S472C53v54Ev
  virtual void  v55(); // _ZN6S472C53v55Ev
  virtual void  v56(); // _ZN6S472C53v56Ev
  virtual void  v57(); // _ZN6S472C53v57Ev
  virtual void  v58(); // _ZN6S472C53v58Ev
  virtual void  v59(); // _ZN6S472C53v59Ev
  virtual void  v60(); // _ZN6S472C53v60Ev
  virtual void  v61(); // _ZN6S472C53v61Ev
  virtual void  v62(); // _ZN6S472C53v62Ev
  virtual void  v63(); // _ZN6S472C53v63Ev
  virtual void  v64(); // _ZN6S472C53v64Ev
  virtual void  v65(); // _ZN6S472C53v65Ev
  virtual void  v66(); // _ZN6S472C53v66Ev
  virtual void  v67(); // _ZN6S472C53v67Ev
  virtual void  v68(); // _ZN6S472C53v68Ev
  virtual void  v69(); // _ZN6S472C53v69Ev
  virtual void  v70(); // _ZN6S472C53v70Ev
  virtual void  v71(); // _ZN6S472C53v71Ev
  virtual void  v72(); // _ZN6S472C53v72Ev
  virtual void  v73(); // _ZN6S472C53v73Ev
  S472C5(); // tgen
};
//SIG(-1 S472C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S472C5 ::~S472C5(){ note_dtor("S472C5", this);}
void  S472C5 ::v10(){vfunc_called(this, "_ZN6S472C53v10Ev");}
void  S472C5 ::v11(){vfunc_called(this, "_ZN6S472C53v11Ev");}
void  S472C5 ::v12(){vfunc_called(this, "_ZN6S472C53v12Ev");}
void  S472C5 ::v13(){vfunc_called(this, "_ZN6S472C53v13Ev");}
void  S472C5 ::v14(){vfunc_called(this, "_ZN6S472C53v14Ev");}
void  S472C5 ::v15(){vfunc_called(this, "_ZN6S472C53v15Ev");}
void  S472C5 ::v16(){vfunc_called(this, "_ZN6S472C53v16Ev");}
void  S472C5 ::v17(){vfunc_called(this, "_ZN6S472C53v17Ev");}
void  S472C5 ::v18(){vfunc_called(this, "_ZN6S472C53v18Ev");}
void  S472C5 ::v19(){vfunc_called(this, "_ZN6S472C53v19Ev");}
void  S472C5 ::v20(){vfunc_called(this, "_ZN6S472C53v20Ev");}
void  S472C5 ::v21(){vfunc_called(this, "_ZN6S472C53v21Ev");}
void  S472C5 ::v22(){vfunc_called(this, "_ZN6S472C53v22Ev");}
void  S472C5 ::v23(){vfunc_called(this, "_ZN6S472C53v23Ev");}
void  S472C5 ::v24(){vfunc_called(this, "_ZN6S472C53v24Ev");}
void  S472C5 ::v25(){vfunc_called(this, "_ZN6S472C53v25Ev");}
void  S472C5 ::v26(){vfunc_called(this, "_ZN6S472C53v26Ev");}
void  S472C5 ::v27(){vfunc_called(this, "_ZN6S472C53v27Ev");}
void  S472C5 ::v28(){vfunc_called(this, "_ZN6S472C53v28Ev");}
void  S472C5 ::v29(){vfunc_called(this, "_ZN6S472C53v29Ev");}
void  S472C5 ::v30(){vfunc_called(this, "_ZN6S472C53v30Ev");}
void  S472C5 ::v31(){vfunc_called(this, "_ZN6S472C53v31Ev");}
void  S472C5 ::v32(){vfunc_called(this, "_ZN6S472C53v32Ev");}
void  S472C5 ::v33(){vfunc_called(this, "_ZN6S472C53v33Ev");}
void  S472C5 ::v34(){vfunc_called(this, "_ZN6S472C53v34Ev");}
void  S472C5 ::v35(){vfunc_called(this, "_ZN6S472C53v35Ev");}
void  S472C5 ::v36(){vfunc_called(this, "_ZN6S472C53v36Ev");}
void  S472C5 ::v37(){vfunc_called(this, "_ZN6S472C53v37Ev");}
void  S472C5 ::v38(){vfunc_called(this, "_ZN6S472C53v38Ev");}
void  S472C5 ::v39(){vfunc_called(this, "_ZN6S472C53v39Ev");}
void  S472C5 ::v40(){vfunc_called(this, "_ZN6S472C53v40Ev");}
void  S472C5 ::v41(){vfunc_called(this, "_ZN6S472C53v41Ev");}
void  S472C5 ::v42(){vfunc_called(this, "_ZN6S472C53v42Ev");}
void  S472C5 ::v43(){vfunc_called(this, "_ZN6S472C53v43Ev");}
void  S472C5 ::v44(){vfunc_called(this, "_ZN6S472C53v44Ev");}
void  S472C5 ::v45(){vfunc_called(this, "_ZN6S472C53v45Ev");}
void  S472C5 ::v46(){vfunc_called(this, "_ZN6S472C53v46Ev");}
void  S472C5 ::v47(){vfunc_called(this, "_ZN6S472C53v47Ev");}
void  S472C5 ::v48(){vfunc_called(this, "_ZN6S472C53v48Ev");}
void  S472C5 ::v49(){vfunc_called(this, "_ZN6S472C53v49Ev");}
void  S472C5 ::v50(){vfunc_called(this, "_ZN6S472C53v50Ev");}
void  S472C5 ::v51(){vfunc_called(this, "_ZN6S472C53v51Ev");}
void  S472C5 ::v52(){vfunc_called(this, "_ZN6S472C53v52Ev");}
void  S472C5 ::v53(){vfunc_called(this, "_ZN6S472C53v53Ev");}
void  S472C5 ::v54(){vfunc_called(this, "_ZN6S472C53v54Ev");}
void  S472C5 ::v55(){vfunc_called(this, "_ZN6S472C53v55Ev");}
void  S472C5 ::v56(){vfunc_called(this, "_ZN6S472C53v56Ev");}
void  S472C5 ::v57(){vfunc_called(this, "_ZN6S472C53v57Ev");}
void  S472C5 ::v58(){vfunc_called(this, "_ZN6S472C53v58Ev");}
void  S472C5 ::v59(){vfunc_called(this, "_ZN6S472C53v59Ev");}
void  S472C5 ::v60(){vfunc_called(this, "_ZN6S472C53v60Ev");}
void  S472C5 ::v61(){vfunc_called(this, "_ZN6S472C53v61Ev");}
void  S472C5 ::v62(){vfunc_called(this, "_ZN6S472C53v62Ev");}
void  S472C5 ::v63(){vfunc_called(this, "_ZN6S472C53v63Ev");}
void  S472C5 ::v64(){vfunc_called(this, "_ZN6S472C53v64Ev");}
void  S472C5 ::v65(){vfunc_called(this, "_ZN6S472C53v65Ev");}
void  S472C5 ::v66(){vfunc_called(this, "_ZN6S472C53v66Ev");}
void  S472C5 ::v67(){vfunc_called(this, "_ZN6S472C53v67Ev");}
void  S472C5 ::v68(){vfunc_called(this, "_ZN6S472C53v68Ev");}
void  S472C5 ::v69(){vfunc_called(this, "_ZN6S472C53v69Ev");}
void  S472C5 ::v70(){vfunc_called(this, "_ZN6S472C53v70Ev");}
void  S472C5 ::v71(){vfunc_called(this, "_ZN6S472C53v71Ev");}
void  S472C5 ::v72(){vfunc_called(this, "_ZN6S472C53v72Ev");}
void  S472C5 ::v73(){vfunc_called(this, "_ZN6S472C53v73Ev");}
S472C5 ::S472C5(){ note_ctor("S472C5", this);} // tgen

static void Test_S472C5()
{
  extern Class_Descriptor cd_S472C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S472C5, buf);
    S472C5 *dp, &lv = *(dp=new (buf) S472C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S472C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S472C5)");
    check_field_offset(lv, s472c5f0, ABISELECT(8,4), "S472C5.s472c5f0");
    check_field_offset(lv, s472c5f1, ABISELECT(16,8), "S472C5.s472c5f1");
    check_field_offset(lv, s472c5f2, ABISELECT(24,16), "S472C5.s472c5f2");
    check_field_offset(lv, s472c5f3, ABISELECT(56,32), "S472C5.s472c5f3");
    check_field_offset(lv, s472c5f4, ABISELECT(64,40), "S472C5.s472c5f4");
    check_field_offset(lv, s472c5f5, ABISELECT(72,44), "S472C5.s472c5f5");
    check_field_offset(lv, s472c5f6, ABISELECT(80,52), "S472C5.s472c5f6");
    test_class_info(&lv, &cd_S472C5);
    dp->~S472C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS472C5(Test_S472C5, "S472C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S472C5C1Ev();
extern void _ZN6S472C5D1Ev();
Name_Map name_map_S472C5[] = {
  NSPAIR(_ZN6S472C5C1Ev),
  NSPAIR(_ZN6S472C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S472C5[];
extern void _ZN6S472C5D1Ev();
extern void _ZN6S472C5D0Ev();
extern void _ZN6S472C53v10Ev();
extern void _ZN6S472C53v11Ev();
extern void _ZN6S472C53v12Ev();
extern void _ZN6S472C53v13Ev();
extern void _ZN6S472C53v14Ev();
extern void _ZN6S472C53v15Ev();
extern void _ZN6S472C53v16Ev();
extern void _ZN6S472C53v17Ev();
extern void _ZN6S472C53v18Ev();
extern void _ZN6S472C53v19Ev();
extern void _ZN6S472C53v20Ev();
extern void _ZN6S472C53v21Ev();
extern void _ZN6S472C53v22Ev();
extern void _ZN6S472C53v23Ev();
extern void _ZN6S472C53v24Ev();
extern void _ZN6S472C53v25Ev();
extern void _ZN6S472C53v26Ev();
extern void _ZN6S472C53v27Ev();
extern void _ZN6S472C53v28Ev();
extern void _ZN6S472C53v29Ev();
extern void _ZN6S472C53v30Ev();
extern void _ZN6S472C53v31Ev();
extern void _ZN6S472C53v32Ev();
extern void _ZN6S472C53v33Ev();
extern void _ZN6S472C53v34Ev();
extern void _ZN6S472C53v35Ev();
extern void _ZN6S472C53v36Ev();
extern void _ZN6S472C53v37Ev();
extern void _ZN6S472C53v38Ev();
extern void _ZN6S472C53v39Ev();
extern void _ZN6S472C53v40Ev();
extern void _ZN6S472C53v41Ev();
extern void _ZN6S472C53v42Ev();
extern void _ZN6S472C53v43Ev();
extern void _ZN6S472C53v44Ev();
extern void _ZN6S472C53v45Ev();
extern void _ZN6S472C53v46Ev();
extern void _ZN6S472C53v47Ev();
extern void _ZN6S472C53v48Ev();
extern void _ZN6S472C53v49Ev();
extern void _ZN6S472C53v50Ev();
extern void _ZN6S472C53v51Ev();
extern void _ZN6S472C53v52Ev();
extern void _ZN6S472C53v53Ev();
extern void _ZN6S472C53v54Ev();
extern void _ZN6S472C53v55Ev();
extern void _ZN6S472C53v56Ev();
extern void _ZN6S472C53v57Ev();
extern void _ZN6S472C53v58Ev();
extern void _ZN6S472C53v59Ev();
extern void _ZN6S472C53v60Ev();
extern void _ZN6S472C53v61Ev();
extern void _ZN6S472C53v62Ev();
extern void _ZN6S472C53v63Ev();
extern void _ZN6S472C53v64Ev();
extern void _ZN6S472C53v65Ev();
extern void _ZN6S472C53v66Ev();
extern void _ZN6S472C53v67Ev();
extern void _ZN6S472C53v68Ev();
extern void _ZN6S472C53v69Ev();
extern void _ZN6S472C53v70Ev();
extern void _ZN6S472C53v71Ev();
extern void _ZN6S472C53v72Ev();
extern void _ZN6S472C53v73Ev();
static  VTBL_ENTRY vtc_S472C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S472C5[0]),
  (VTBL_ENTRY)&_ZN6S472C5D1Ev,
  (VTBL_ENTRY)&_ZN6S472C5D0Ev,
  (VTBL_ENTRY)&_ZN6S472C53v10Ev,
  (VTBL_ENTRY)&_ZN6S472C53v11Ev,
  (VTBL_ENTRY)&_ZN6S472C53v12Ev,
  (VTBL_ENTRY)&_ZN6S472C53v13Ev,
  (VTBL_ENTRY)&_ZN6S472C53v14Ev,
  (VTBL_ENTRY)&_ZN6S472C53v15Ev,
  (VTBL_ENTRY)&_ZN6S472C53v16Ev,
  (VTBL_ENTRY)&_ZN6S472C53v17Ev,
  (VTBL_ENTRY)&_ZN6S472C53v18Ev,
  (VTBL_ENTRY)&_ZN6S472C53v19Ev,
  (VTBL_ENTRY)&_ZN6S472C53v20Ev,
  (VTBL_ENTRY)&_ZN6S472C53v21Ev,
  (VTBL_ENTRY)&_ZN6S472C53v22Ev,
  (VTBL_ENTRY)&_ZN6S472C53v23Ev,
  (VTBL_ENTRY)&_ZN6S472C53v24Ev,
  (VTBL_ENTRY)&_ZN6S472C53v25Ev,
  (VTBL_ENTRY)&_ZN6S472C53v26Ev,
  (VTBL_ENTRY)&_ZN6S472C53v27Ev,
  (VTBL_ENTRY)&_ZN6S472C53v28Ev,
  (VTBL_ENTRY)&_ZN6S472C53v29Ev,
  (VTBL_ENTRY)&_ZN6S472C53v30Ev,
  (VTBL_ENTRY)&_ZN6S472C53v31Ev,
  (VTBL_ENTRY)&_ZN6S472C53v32Ev,
  (VTBL_ENTRY)&_ZN6S472C53v33Ev,
  (VTBL_ENTRY)&_ZN6S472C53v34Ev,
  (VTBL_ENTRY)&_ZN6S472C53v35Ev,
  (VTBL_ENTRY)&_ZN6S472C53v36Ev,
  (VTBL_ENTRY)&_ZN6S472C53v37Ev,
  (VTBL_ENTRY)&_ZN6S472C53v38Ev,
  (VTBL_ENTRY)&_ZN6S472C53v39Ev,
  (VTBL_ENTRY)&_ZN6S472C53v40Ev,
  (VTBL_ENTRY)&_ZN6S472C53v41Ev,
  (VTBL_ENTRY)&_ZN6S472C53v42Ev,
  (VTBL_ENTRY)&_ZN6S472C53v43Ev,
  (VTBL_ENTRY)&_ZN6S472C53v44Ev,
  (VTBL_ENTRY)&_ZN6S472C53v45Ev,
  (VTBL_ENTRY)&_ZN6S472C53v46Ev,
  (VTBL_ENTRY)&_ZN6S472C53v47Ev,
  (VTBL_ENTRY)&_ZN6S472C53v48Ev,
  (VTBL_ENTRY)&_ZN6S472C53v49Ev,
  (VTBL_ENTRY)&_ZN6S472C53v50Ev,
  (VTBL_ENTRY)&_ZN6S472C53v51Ev,
  (VTBL_ENTRY)&_ZN6S472C53v52Ev,
  (VTBL_ENTRY)&_ZN6S472C53v53Ev,
  (VTBL_ENTRY)&_ZN6S472C53v54Ev,
  (VTBL_ENTRY)&_ZN6S472C53v55Ev,
  (VTBL_ENTRY)&_ZN6S472C53v56Ev,
  (VTBL_ENTRY)&_ZN6S472C53v57Ev,
  (VTBL_ENTRY)&_ZN6S472C53v58Ev,
  (VTBL_ENTRY)&_ZN6S472C53v59Ev,
  (VTBL_ENTRY)&_ZN6S472C53v60Ev,
  (VTBL_ENTRY)&_ZN6S472C53v61Ev,
  (VTBL_ENTRY)&_ZN6S472C53v62Ev,
  (VTBL_ENTRY)&_ZN6S472C53v63Ev,
  (VTBL_ENTRY)&_ZN6S472C53v64Ev,
  (VTBL_ENTRY)&_ZN6S472C53v65Ev,
  (VTBL_ENTRY)&_ZN6S472C53v66Ev,
  (VTBL_ENTRY)&_ZN6S472C53v67Ev,
  (VTBL_ENTRY)&_ZN6S472C53v68Ev,
  (VTBL_ENTRY)&_ZN6S472C53v69Ev,
  (VTBL_ENTRY)&_ZN6S472C53v70Ev,
  (VTBL_ENTRY)&_ZN6S472C53v71Ev,
  (VTBL_ENTRY)&_ZN6S472C53v72Ev,
  (VTBL_ENTRY)&_ZN6S472C53v73Ev,
};
extern VTBL_ENTRY _ZTI6S472C5[];
extern  VTBL_ENTRY _ZTV6S472C5[];
Class_Descriptor cd_S472C5 = {  "S472C5", // class name
  0,0,//no base classes
  &(vtc_S472C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S472C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S472C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S472C4  : S472C5 {
  int s472c4f0[2];
  void *s472c4f1;
  int s472c4f2[2];
  ::S473C7_nt s472c4f3;
  ::S473C7_nt s472c4f4;
  ::S21925C42 s472c4f5;
  ::S473C7_nt s472c4f6;
  unsigned int s472c4f7:1;
  unsigned int s472c4f8:1;
  unsigned int s472c4f9:1;
  unsigned int s472c4f10:1;
  unsigned int s472c4f11:1;
  int s472c4f12[2];
  virtual  ~S472C4(); // _ZN6S472C4D1Ev
  virtual void  v74(); // _ZN6S472C43v74Ev
  virtual void  v75(); // _ZN6S472C43v75Ev
  virtual void  v76(); // _ZN6S472C43v76Ev
  virtual void  v77(); // _ZN6S472C43v77Ev
  virtual void  v78(); // _ZN6S472C43v78Ev
  virtual void  v79(); // _ZN6S472C43v79Ev
  virtual void  v80(); // _ZN6S472C43v80Ev
  virtual void  v81(); // _ZN6S472C43v81Ev
  virtual void  v82(); // _ZN6S472C43v82Ev
  virtual void  v83(); // _ZN6S472C43v83Ev
  virtual void  v84(); // _ZN6S472C43v84Ev
  virtual void  v85(); // _ZN6S472C43v85Ev
  virtual void  v86(); // _ZN6S472C43v86Ev
  virtual void  v87(); // _ZN6S472C43v87Ev
  virtual void  v88(); // _ZN6S472C43v88Ev
  virtual void  v89(); // _ZN6S472C43v89Ev
  virtual void  v90(); // _ZN6S472C43v90Ev
  virtual void  v91(); // _ZN6S472C43v91Ev
  virtual void  v92(); // _ZN6S472C43v92Ev
  virtual void  v93(); // _ZN6S472C43v93Ev
  virtual void  v94(); // _ZN6S472C43v94Ev
  virtual void  v95(); // _ZN6S472C43v95Ev
  S472C4(); // tgen
};
//SIG(-1 S472C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S472C4 ::~S472C4(){ note_dtor("S472C4", this);}
void  S472C4 ::v74(){vfunc_called(this, "_ZN6S472C43v74Ev");}
void  S472C4 ::v75(){vfunc_called(this, "_ZN6S472C43v75Ev");}
void  S472C4 ::v76(){vfunc_called(this, "_ZN6S472C43v76Ev");}
void  S472C4 ::v77(){vfunc_called(this, "_ZN6S472C43v77Ev");}
void  S472C4 ::v78(){vfunc_called(this, "_ZN6S472C43v78Ev");}
void  S472C4 ::v79(){vfunc_called(this, "_ZN6S472C43v79Ev");}
void  S472C4 ::v80(){vfunc_called(this, "_ZN6S472C43v80Ev");}
void  S472C4 ::v81(){vfunc_called(this, "_ZN6S472C43v81Ev");}
void  S472C4 ::v82(){vfunc_called(this, "_ZN6S472C43v82Ev");}
void  S472C4 ::v83(){vfunc_called(this, "_ZN6S472C43v83Ev");}
void  S472C4 ::v84(){vfunc_called(this, "_ZN6S472C43v84Ev");}
void  S472C4 ::v85(){vfunc_called(this, "_ZN6S472C43v85Ev");}
void  S472C4 ::v86(){vfunc_called(this, "_ZN6S472C43v86Ev");}
void  S472C4 ::v87(){vfunc_called(this, "_ZN6S472C43v87Ev");}
void  S472C4 ::v88(){vfunc_called(this, "_ZN6S472C43v88Ev");}
void  S472C4 ::v89(){vfunc_called(this, "_ZN6S472C43v89Ev");}
void  S472C4 ::v90(){vfunc_called(this, "_ZN6S472C43v90Ev");}
void  S472C4 ::v91(){vfunc_called(this, "_ZN6S472C43v91Ev");}
void  S472C4 ::v92(){vfunc_called(this, "_ZN6S472C43v92Ev");}
void  S472C4 ::v93(){vfunc_called(this, "_ZN6S472C43v93Ev");}
void  S472C4 ::v94(){vfunc_called(this, "_ZN6S472C43v94Ev");}
void  S472C4 ::v95(){vfunc_called(this, "_ZN6S472C43v95Ev");}
S472C4 ::S472C4(){ note_ctor("S472C4", this);} // tgen

static void Test_S472C4()
{
  extern Class_Descriptor cd_S472C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S472C4, buf);
    S472C4 *dp, &lv = *(dp=new (buf) S472C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S472C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S472C4)");
    check_base_class_offset(lv, (S472C5*), 0, "S472C4");
    check_field_offset(lv, s472c4f0, ABISELECT(96,60), "S472C4.s472c4f0");
    check_field_offset(lv, s472c4f1, ABISELECT(104,68), "S472C4.s472c4f1");
    check_field_offset(lv, s472c4f2, ABISELECT(112,72), "S472C4.s472c4f2");
    check_field_offset(lv, s472c4f3, ABISELECT(120,80), "S472C4.s472c4f3");
    check_field_offset(lv, s472c4f4, ABISELECT(136,92), "S472C4.s472c4f4");
    check_field_offset(lv, s472c4f5, ABISELECT(152,104), "S472C4.s472c4f5");
    check_field_offset(lv, s472c4f6, ABISELECT(160,108), "S472C4.s472c4f6");
    set_bf_and_test(lv, s472c4f7, ABISELECT(176,120), 0, 1, 1, "S472C4");
    set_bf_and_test(lv, s472c4f8, ABISELECT(176,120), 1, 1, 1, "S472C4");
    set_bf_and_test(lv, s472c4f9, ABISELECT(176,120), 2, 1, 1, "S472C4");
    set_bf_and_test(lv, s472c4f10, ABISELECT(176,120), 3, 1, 1, "S472C4");
    set_bf_and_test(lv, s472c4f11, ABISELECT(176,120), 4, 1, 1, "S472C4");
    check_field_offset(lv, s472c4f12, ABISELECT(180,124), "S472C4.s472c4f12");
    test_class_info(&lv, &cd_S472C4);
    dp->~S472C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS472C4(Test_S472C4, "S472C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S472C4C1Ev();
extern void _ZN6S472C4D1Ev();
Name_Map name_map_S472C4[] = {
  NSPAIR(_ZN6S472C4C1Ev),
  NSPAIR(_ZN6S472C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S472C5;
extern VTBL_ENTRY _ZTI6S472C5[];
extern  VTBL_ENTRY _ZTV6S472C5[];
static Base_Class bases_S472C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S472C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S472C4[];
extern void _ZN6S472C4D1Ev();
extern void _ZN6S472C4D0Ev();
extern void _ZN6S472C53v10Ev();
extern void _ZN6S472C53v11Ev();
extern void _ZN6S472C53v12Ev();
extern void _ZN6S472C53v13Ev();
extern void _ZN6S472C53v14Ev();
extern void _ZN6S472C53v15Ev();
extern void _ZN6S472C53v16Ev();
extern void _ZN6S472C53v17Ev();
extern void _ZN6S472C53v18Ev();
extern void _ZN6S472C53v19Ev();
extern void _ZN6S472C53v20Ev();
extern void _ZN6S472C53v21Ev();
extern void _ZN6S472C53v22Ev();
extern void _ZN6S472C53v23Ev();
extern void _ZN6S472C53v24Ev();
extern void _ZN6S472C53v25Ev();
extern void _ZN6S472C53v26Ev();
extern void _ZN6S472C53v27Ev();
extern void _ZN6S472C53v28Ev();
extern void _ZN6S472C53v29Ev();
extern void _ZN6S472C53v30Ev();
extern void _ZN6S472C53v31Ev();
extern void _ZN6S472C53v32Ev();
extern void _ZN6S472C53v33Ev();
extern void _ZN6S472C53v34Ev();
extern void _ZN6S472C53v35Ev();
extern void _ZN6S472C53v36Ev();
extern void _ZN6S472C53v37Ev();
extern void _ZN6S472C53v38Ev();
extern void _ZN6S472C53v39Ev();
extern void _ZN6S472C53v40Ev();
extern void _ZN6S472C53v41Ev();
extern void _ZN6S472C53v42Ev();
extern void _ZN6S472C53v43Ev();
extern void _ZN6S472C53v44Ev();
extern void _ZN6S472C53v45Ev();
extern void _ZN6S472C53v46Ev();
extern void _ZN6S472C53v47Ev();
extern void _ZN6S472C53v48Ev();
extern void _ZN6S472C53v49Ev();
extern void _ZN6S472C53v50Ev();
extern void _ZN6S472C53v51Ev();
extern void _ZN6S472C53v52Ev();
extern void _ZN6S472C53v53Ev();
extern void _ZN6S472C53v54Ev();
extern void _ZN6S472C53v55Ev();
extern void _ZN6S472C53v56Ev();
extern void _ZN6S472C53v57Ev();
extern void _ZN6S472C53v58Ev();
extern void _ZN6S472C53v59Ev();
extern void _ZN6S472C53v60Ev();
extern void _ZN6S472C53v61Ev();
extern void _ZN6S472C53v62Ev();
extern void _ZN6S472C53v63Ev();
extern void _ZN6S472C53v64Ev();
extern void _ZN6S472C53v65Ev();
extern void _ZN6S472C53v66Ev();
extern void _ZN6S472C53v67Ev();
extern void _ZN6S472C53v68Ev();
extern void _ZN6S472C53v69Ev();
extern void _ZN6S472C53v70Ev();
extern void _ZN6S472C53v71Ev();
extern void _ZN6S472C53v72Ev();
extern void _ZN6S472C53v73Ev();
extern void _ZN6S472C43v74Ev();
extern void _ZN6S472C43v75Ev();
extern void _ZN6S472C43v76Ev();
extern void _ZN6S472C43v77Ev();
extern void _ZN6S472C43v78Ev();
extern void _ZN6S472C43v79Ev();
extern void _ZN6S472C43v80Ev();
extern void _ZN6S472C43v81Ev();
extern void _ZN6S472C43v82Ev();
extern void _ZN6S472C43v83Ev();
extern void _ZN6S472C43v84Ev();
extern void _ZN6S472C43v85Ev();
extern void _ZN6S472C43v86Ev();
extern void _ZN6S472C43v87Ev();
extern void _ZN6S472C43v88Ev();
extern void _ZN6S472C43v89Ev();
extern void _ZN6S472C43v90Ev();
extern void _ZN6S472C43v91Ev();
extern void _ZN6S472C43v92Ev();
extern void _ZN6S472C43v93Ev();
extern void _ZN6S472C43v94Ev();
extern void _ZN6S472C43v95Ev();
static  VTBL_ENTRY vtc_S472C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S472C4[0]),
  (VTBL_ENTRY)&_ZN6S472C4D1Ev,
  (VTBL_ENTRY)&_ZN6S472C4D0Ev,
  (VTBL_ENTRY)&_ZN6S472C53v10Ev,
  (VTBL_ENTRY)&_ZN6S472C53v11Ev,
  (VTBL_ENTRY)&_ZN6S472C53v12Ev,
  (VTBL_ENTRY)&_ZN6S472C53v13Ev,
  (VTBL_ENTRY)&_ZN6S472C53v14Ev,
  (VTBL_ENTRY)&_ZN6S472C53v15Ev,
  (VTBL_ENTRY)&_ZN6S472C53v16Ev,
  (VTBL_ENTRY)&_ZN6S472C53v17Ev,
  (VTBL_ENTRY)&_ZN6S472C53v18Ev,
  (VTBL_ENTRY)&_ZN6S472C53v19Ev,
  (VTBL_ENTRY)&_ZN6S472C53v20Ev,
  (VTBL_ENTRY)&_ZN6S472C53v21Ev,
  (VTBL_ENTRY)&_ZN6S472C53v22Ev,
  (VTBL_ENTRY)&_ZN6S472C53v23Ev,
  (VTBL_ENTRY)&_ZN6S472C53v24Ev,
  (VTBL_ENTRY)&_ZN6S472C53v25Ev,
  (VTBL_ENTRY)&_ZN6S472C53v26Ev,
  (VTBL_ENTRY)&_ZN6S472C53v27Ev,
  (VTBL_ENTRY)&_ZN6S472C53v28Ev,
  (VTBL_ENTRY)&_ZN6S472C53v29Ev,
  (VTBL_ENTRY)&_ZN6S472C53v30Ev,
  (VTBL_ENTRY)&_ZN6S472C53v31Ev,
  (VTBL_ENTRY)&_ZN6S472C53v32Ev,
  (VTBL_ENTRY)&_ZN6S472C53v33Ev,
  (VTBL_ENTRY)&_ZN6S472C53v34Ev,
  (VTBL_ENTRY)&_ZN6S472C53v35Ev,
  (VTBL_ENTRY)&_ZN6S472C53v36Ev,
  (VTBL_ENTRY)&_ZN6S472C53v37Ev,
  (VTBL_ENTRY)&_ZN6S472C53v38Ev,
  (VTBL_ENTRY)&_ZN6S472C53v39Ev,
  (VTBL_ENTRY)&_ZN6S472C53v40Ev,
  (VTBL_ENTRY)&_ZN6S472C53v41Ev,
  (VTBL_ENTRY)&_ZN6S472C53v42Ev,
  (VTBL_ENTRY)&_ZN6S472C53v43Ev,
  (VTBL_ENTRY)&_ZN6S472C53v44Ev,
  (VTBL_ENTRY)&_ZN6S472C53v45Ev,
  (VTBL_ENTRY)&_ZN6S472C53v46Ev,
  (VTBL_ENTRY)&_ZN6S472C53v47Ev,
  (VTBL_ENTRY)&_ZN6S472C53v48Ev,
  (VTBL_ENTRY)&_ZN6S472C53v49Ev,
  (VTBL_ENTRY)&_ZN6S472C53v50Ev,
  (VTBL_ENTRY)&_ZN6S472C53v51Ev,
  (VTBL_ENTRY)&_ZN6S472C53v52Ev,
  (VTBL_ENTRY)&_ZN6S472C53v53Ev,
  (VTBL_ENTRY)&_ZN6S472C53v54Ev,
  (VTBL_ENTRY)&_ZN6S472C53v55Ev,
  (VTBL_ENTRY)&_ZN6S472C53v56Ev,
  (VTBL_ENTRY)&_ZN6S472C53v57Ev,
  (VTBL_ENTRY)&_ZN6S472C53v58Ev,
  (VTBL_ENTRY)&_ZN6S472C53v59Ev,
  (VTBL_ENTRY)&_ZN6S472C53v60Ev,
  (VTBL_ENTRY)&_ZN6S472C53v61Ev,
  (VTBL_ENTRY)&_ZN6S472C53v62Ev,
  (VTBL_ENTRY)&_ZN6S472C53v63Ev,
  (VTBL_ENTRY)&_ZN6S472C53v64Ev,
  (VTBL_ENTRY)&_ZN6S472C53v65Ev,
  (VTBL_ENTRY)&_ZN6S472C53v66Ev,
  (VTBL_ENTRY)&_ZN6S472C53v67Ev,
  (VTBL_ENTRY)&_ZN6S472C53v68Ev,
  (VTBL_ENTRY)&_ZN6S472C53v69Ev,
  (VTBL_ENTRY)&_ZN6S472C53v70Ev,
  (VTBL_ENTRY)&_ZN6S472C53v71Ev,
  (VTBL_ENTRY)&_ZN6S472C53v72Ev,
  (VTBL_ENTRY)&_ZN6S472C53v73Ev,
  (VTBL_ENTRY)&_ZN6S472C43v74Ev,
  (VTBL_ENTRY)&_ZN6S472C43v75Ev,
  (VTBL_ENTRY)&_ZN6S472C43v76Ev,
  (VTBL_ENTRY)&_ZN6S472C43v77Ev,
  (VTBL_ENTRY)&_ZN6S472C43v78Ev,
  (VTBL_ENTRY)&_ZN6S472C43v79Ev,
  (VTBL_ENTRY)&_ZN6S472C43v80Ev,
  (VTBL_ENTRY)&_ZN6S472C43v81Ev,
  (VTBL_ENTRY)&_ZN6S472C43v82Ev,
  (VTBL_ENTRY)&_ZN6S472C43v83Ev,
  (VTBL_ENTRY)&_ZN6S472C43v84Ev,
  (VTBL_ENTRY)&_ZN6S472C43v85Ev,
  (VTBL_ENTRY)&_ZN6S472C43v86Ev,
  (VTBL_ENTRY)&_ZN6S472C43v87Ev,
  (VTBL_ENTRY)&_ZN6S472C43v88Ev,
  (VTBL_ENTRY)&_ZN6S472C43v89Ev,
  (VTBL_ENTRY)&_ZN6S472C43v90Ev,
  (VTBL_ENTRY)&_ZN6S472C43v91Ev,
  (VTBL_ENTRY)&_ZN6S472C43v92Ev,
  (VTBL_ENTRY)&_ZN6S472C43v93Ev,
  (VTBL_ENTRY)&_ZN6S472C43v94Ev,
  (VTBL_ENTRY)&_ZN6S472C43v95Ev,
};
extern VTBL_ENTRY _ZTI6S472C4[];
extern  VTBL_ENTRY _ZTV6S472C4[];
Class_Descriptor cd_S472C4 = {  "S472C4", // class name
  bases_S472C4, 1,
  &(vtc_S472C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S472C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S472C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S472C3  : S472C4 {
  ::S473C6_nt s472c3f0;
  virtual  ~S472C3(); // _ZN6S472C3D1Ev
  virtual void  v96(); // _ZN6S472C33v96Ev
  virtual void  v97(); // _ZN6S472C33v97Ev
  virtual void  v98(); // _ZN6S472C33v98Ev
  virtual void  v99(); // _ZN6S472C33v99Ev
  virtual void  v100(); // _ZN6S472C34v100Ev
  virtual void  v101(); // _ZN6S472C34v101Ev
  virtual void  v102(); // _ZN6S472C34v102Ev
  virtual void  v103(); // _ZN6S472C34v103Ev
  virtual void  v104(); // _ZN6S472C34v104Ev
  virtual void  v105(); // _ZN6S472C34v105Ev
  virtual void  v106(); // _ZN6S472C34v106Ev
  virtual void  v107(); // _ZN6S472C34v107Ev
  virtual void  v108(); // _ZN6S472C34v108Ev
  virtual void  v109(); // _ZN6S472C34v109Ev
  virtual void  v110(); // _ZN6S472C34v110Ev
  virtual void  v111(); // _ZN6S472C34v111Ev
  virtual void  v112(); // _ZN6S472C34v112Ev
  virtual void  v113(); // _ZN6S472C34v113Ev
  virtual void  v114(); // _ZN6S472C34v114Ev
  S472C3(); // tgen
};
//SIG(-1 S472C3) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S472C3 ::~S472C3(){ note_dtor("S472C3", this);}
void  S472C3 ::v96(){vfunc_called(this, "_ZN6S472C33v96Ev");}
void  S472C3 ::v97(){vfunc_called(this, "_ZN6S472C33v97Ev");}
void  S472C3 ::v98(){vfunc_called(this, "_ZN6S472C33v98Ev");}
void  S472C3 ::v99(){vfunc_called(this, "_ZN6S472C33v99Ev");}
void  S472C3 ::v100(){vfunc_called(this, "_ZN6S472C34v100Ev");}
void  S472C3 ::v101(){vfunc_called(this, "_ZN6S472C34v101Ev");}
void  S472C3 ::v102(){vfunc_called(this, "_ZN6S472C34v102Ev");}
void  S472C3 ::v103(){vfunc_called(this, "_ZN6S472C34v103Ev");}
void  S472C3 ::v104(){vfunc_called(this, "_ZN6S472C34v104Ev");}
void  S472C3 ::v105(){vfunc_called(this, "_ZN6S472C34v105Ev");}
void  S472C3 ::v106(){vfunc_called(this, "_ZN6S472C34v106Ev");}
void  S472C3 ::v107(){vfunc_called(this, "_ZN6S472C34v107Ev");}
void  S472C3 ::v108(){vfunc_called(this, "_ZN6S472C34v108Ev");}
void  S472C3 ::v109(){vfunc_called(this, "_ZN6S472C34v109Ev");}
void  S472C3 ::v110(){vfunc_called(this, "_ZN6S472C34v110Ev");}
void  S472C3 ::v111(){vfunc_called(this, "_ZN6S472C34v111Ev");}
void  S472C3 ::v112(){vfunc_called(this, "_ZN6S472C34v112Ev");}
void  S472C3 ::v113(){vfunc_called(this, "_ZN6S472C34v113Ev");}
void  S472C3 ::v114(){vfunc_called(this, "_ZN6S472C34v114Ev");}
S472C3 ::S472C3(){ note_ctor("S472C3", this);} // tgen

static void Test_S472C3()
{
  extern Class_Descriptor cd_S472C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S472C3, buf);
    S472C3 *dp, &lv = *(dp=new (buf) S472C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S472C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S472C3)");
    check_base_class_offset(lv, (S472C5*)(S472C4*), 0, "S472C3");
    check_base_class_offset(lv, (S472C4*), 0, "S472C3");
    check_field_offset(lv, s472c3f0, ABISELECT(188,132), "S472C3.s472c3f0");
    test_class_info(&lv, &cd_S472C3);
    dp->~S472C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS472C3(Test_S472C3, "S472C3", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S472C3C1Ev();
extern void _ZN6S472C3D1Ev();
Name_Map name_map_S472C3[] = {
  NSPAIR(_ZN6S472C3C1Ev),
  NSPAIR(_ZN6S472C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S472C5;
extern VTBL_ENTRY _ZTI6S472C5[];
extern  VTBL_ENTRY _ZTV6S472C5[];
extern Class_Descriptor cd_S472C4;
extern VTBL_ENTRY _ZTI6S472C4[];
extern  VTBL_ENTRY _ZTV6S472C4[];
static Base_Class bases_S472C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S472C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S472C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S472C3[];
extern void _ZN6S472C3D1Ev();
extern void _ZN6S472C3D0Ev();
extern void _ZN6S472C53v10Ev();
extern void _ZN6S472C53v11Ev();
extern void _ZN6S472C53v12Ev();
extern void _ZN6S472C53v13Ev();
extern void _ZN6S472C53v14Ev();
extern void _ZN6S472C53v15Ev();
extern void _ZN6S472C53v16Ev();
extern void _ZN6S472C53v17Ev();
extern void _ZN6S472C53v18Ev();
extern void _ZN6S472C53v19Ev();
extern void _ZN6S472C53v20Ev();
extern void _ZN6S472C53v21Ev();
extern void _ZN6S472C53v22Ev();
extern void _ZN6S472C53v23Ev();
extern void _ZN6S472C53v24Ev();
extern void _ZN6S472C53v25Ev();
extern void _ZN6S472C53v26Ev();
extern void _ZN6S472C53v27Ev();
extern void _ZN6S472C53v28Ev();
extern void _ZN6S472C53v29Ev();
extern void _ZN6S472C53v30Ev();
extern void _ZN6S472C53v31Ev();
extern void _ZN6S472C53v32Ev();
extern void _ZN6S472C53v33Ev();
extern void _ZN6S472C53v34Ev();
extern void _ZN6S472C53v35Ev();
extern void _ZN6S472C53v36Ev();
extern void _ZN6S472C53v37Ev();
extern void _ZN6S472C53v38Ev();
extern void _ZN6S472C53v39Ev();
extern void _ZN6S472C53v40Ev();
extern void _ZN6S472C53v41Ev();
extern void _ZN6S472C53v42Ev();
extern void _ZN6S472C53v43Ev();
extern void _ZN6S472C53v44Ev();
extern void _ZN6S472C53v45Ev();
extern void _ZN6S472C53v46Ev();
extern void _ZN6S472C53v47Ev();
extern void _ZN6S472C53v48Ev();
extern void _ZN6S472C53v49Ev();
extern void _ZN6S472C53v50Ev();
extern void _ZN6S472C53v51Ev();
extern void _ZN6S472C53v52Ev();
extern void _ZN6S472C53v53Ev();
extern void _ZN6S472C53v54Ev();
extern void _ZN6S472C53v55Ev();
extern void _ZN6S472C53v56Ev();
extern void _ZN6S472C53v57Ev();
extern void _ZN6S472C53v58Ev();
extern void _ZN6S472C53v59Ev();
extern void _ZN6S472C53v60Ev();
extern void _ZN6S472C53v61Ev();
extern void _ZN6S472C53v62Ev();
extern void _ZN6S472C53v63Ev();
extern void _ZN6S472C53v64Ev();
extern void _ZN6S472C53v65Ev();
extern void _ZN6S472C53v66Ev();
extern void _ZN6S472C53v67Ev();
extern void _ZN6S472C53v68Ev();
extern void _ZN6S472C53v69Ev();
extern void _ZN6S472C53v70Ev();
extern void _ZN6S472C53v71Ev();
extern void _ZN6S472C53v72Ev();
extern void _ZN6S472C53v73Ev();
extern void _ZN6S472C43v74Ev();
extern void _ZN6S472C43v75Ev();
extern void _ZN6S472C43v76Ev();
extern void _ZN6S472C43v77Ev();
extern void _ZN6S472C43v78Ev();
extern void _ZN6S472C43v79Ev();
extern void _ZN6S472C43v80Ev();
extern void _ZN6S472C43v81Ev();
extern void _ZN6S472C43v82Ev();
extern void _ZN6S472C43v83Ev();
extern void _ZN6S472C43v84Ev();
extern void _ZN6S472C43v85Ev();
extern void _ZN6S472C43v86Ev();
extern void _ZN6S472C43v87Ev();
extern void _ZN6S472C43v88Ev();
extern void _ZN6S472C43v89Ev();
extern void _ZN6S472C43v90Ev();
extern void _ZN6S472C43v91Ev();
extern void _ZN6S472C43v92Ev();
extern void _ZN6S472C43v93Ev();
extern void _ZN6S472C43v94Ev();
extern void _ZN6S472C43v95Ev();
extern void _ZN6S472C33v96Ev();
extern void _ZN6S472C33v97Ev();
extern void _ZN6S472C33v98Ev();
extern void _ZN6S472C33v99Ev();
extern void _ZN6S472C34v100Ev();
extern void _ZN6S472C34v101Ev();
extern void _ZN6S472C34v102Ev();
extern void _ZN6S472C34v103Ev();
extern void _ZN6S472C34v104Ev();
extern void _ZN6S472C34v105Ev();
extern void _ZN6S472C34v106Ev();
extern void _ZN6S472C34v107Ev();
extern void _ZN6S472C34v108Ev();
extern void _ZN6S472C34v109Ev();
extern void _ZN6S472C34v110Ev();
extern void _ZN6S472C34v111Ev();
extern void _ZN6S472C34v112Ev();
extern void _ZN6S472C34v113Ev();
extern void _ZN6S472C34v114Ev();
static  VTBL_ENTRY vtc_S472C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S472C3[0]),
  (VTBL_ENTRY)&_ZN6S472C3D1Ev,
  (VTBL_ENTRY)&_ZN6S472C3D0Ev,
  (VTBL_ENTRY)&_ZN6S472C53v10Ev,
  (VTBL_ENTRY)&_ZN6S472C53v11Ev,
  (VTBL_ENTRY)&_ZN6S472C53v12Ev,
  (VTBL_ENTRY)&_ZN6S472C53v13Ev,
  (VTBL_ENTRY)&_ZN6S472C53v14Ev,
  (VTBL_ENTRY)&_ZN6S472C53v15Ev,
  (VTBL_ENTRY)&_ZN6S472C53v16Ev,
  (VTBL_ENTRY)&_ZN6S472C53v17Ev,
  (VTBL_ENTRY)&_ZN6S472C53v18Ev,
  (VTBL_ENTRY)&_ZN6S472C53v19Ev,
  (VTBL_ENTRY)&_ZN6S472C53v20Ev,
  (VTBL_ENTRY)&_ZN6S472C53v21Ev,
  (VTBL_ENTRY)&_ZN6S472C53v22Ev,
  (VTBL_ENTRY)&_ZN6S472C53v23Ev,
  (VTBL_ENTRY)&_ZN6S472C53v24Ev,
  (VTBL_ENTRY)&_ZN6S472C53v25Ev,
  (VTBL_ENTRY)&_ZN6S472C53v26Ev,
  (VTBL_ENTRY)&_ZN6S472C53v27Ev,
  (VTBL_ENTRY)&_ZN6S472C53v28Ev,
  (VTBL_ENTRY)&_ZN6S472C53v29Ev,
  (VTBL_ENTRY)&_ZN6S472C53v30Ev,
  (VTBL_ENTRY)&_ZN6S472C53v31Ev,
  (VTBL_ENTRY)&_ZN6S472C53v32Ev,
  (VTBL_ENTRY)&_ZN6S472C53v33Ev,
  (VTBL_ENTRY)&_ZN6S472C53v34Ev,
  (VTBL_ENTRY)&_ZN6S472C53v35Ev,
  (VTBL_ENTRY)&_ZN6S472C53v36Ev,
  (VTBL_ENTRY)&_ZN6S472C53v37Ev,
  (VTBL_ENTRY)&_ZN6S472C53v38Ev,
  (VTBL_ENTRY)&_ZN6S472C53v39Ev,
  (VTBL_ENTRY)&_ZN6S472C53v40Ev,
  (VTBL_ENTRY)&_ZN6S472C53v41Ev,
  (VTBL_ENTRY)&_ZN6S472C53v42Ev,
  (VTBL_ENTRY)&_ZN6S472C53v43Ev,
  (VTBL_ENTRY)&_ZN6S472C53v44Ev,
  (VTBL_ENTRY)&_ZN6S472C53v45Ev,
  (VTBL_ENTRY)&_ZN6S472C53v46Ev,
  (VTBL_ENTRY)&_ZN6S472C53v47Ev,
  (VTBL_ENTRY)&_ZN6S472C53v48Ev,
  (VTBL_ENTRY)&_ZN6S472C53v49Ev,
  (VTBL_ENTRY)&_ZN6S472C53v50Ev,
  (VTBL_ENTRY)&_ZN6S472C53v51Ev,
  (VTBL_ENTRY)&_ZN6S472C53v52Ev,
  (VTBL_ENTRY)&_ZN6S472C53v53Ev,
  (VTBL_ENTRY)&_ZN6S472C53v54Ev,
  (VTBL_ENTRY)&_ZN6S472C53v55Ev,
  (VTBL_ENTRY)&_ZN6S472C53v56Ev,
  (VTBL_ENTRY)&_ZN6S472C53v57Ev,
  (VTBL_ENTRY)&_ZN6S472C53v58Ev,
  (VTBL_ENTRY)&_ZN6S472C53v59Ev,
  (VTBL_ENTRY)&_ZN6S472C53v60Ev,
  (VTBL_ENTRY)&_ZN6S472C53v61Ev,
  (VTBL_ENTRY)&_ZN6S472C53v62Ev,
  (VTBL_ENTRY)&_ZN6S472C53v63Ev,
  (VTBL_ENTRY)&_ZN6S472C53v64Ev,
  (VTBL_ENTRY)&_ZN6S472C53v65Ev,
  (VTBL_ENTRY)&_ZN6S472C53v66Ev,
  (VTBL_ENTRY)&_ZN6S472C53v67Ev,
  (VTBL_ENTRY)&_ZN6S472C53v68Ev,
  (VTBL_ENTRY)&_ZN6S472C53v69Ev,
  (VTBL_ENTRY)&_ZN6S472C53v70Ev,
  (VTBL_ENTRY)&_ZN6S472C53v71Ev,
  (VTBL_ENTRY)&_ZN6S472C53v72Ev,
  (VTBL_ENTRY)&_ZN6S472C53v73Ev,
  (VTBL_ENTRY)&_ZN6S472C43v74Ev,
  (VTBL_ENTRY)&_ZN6S472C43v75Ev,
  (VTBL_ENTRY)&_ZN6S472C43v76Ev,
  (VTBL_ENTRY)&_ZN6S472C43v77Ev,
  (VTBL_ENTRY)&_ZN6S472C43v78Ev,
  (VTBL_ENTRY)&_ZN6S472C43v79Ev,
  (VTBL_ENTRY)&_ZN6S472C43v80Ev,
  (VTBL_ENTRY)&_ZN6S472C43v81Ev,
  (VTBL_ENTRY)&_ZN6S472C43v82Ev,
  (VTBL_ENTRY)&_ZN6S472C43v83Ev,
  (VTBL_ENTRY)&_ZN6S472C43v84Ev,
  (VTBL_ENTRY)&_ZN6S472C43v85Ev,
  (VTBL_ENTRY)&_ZN6S472C43v86Ev,
  (VTBL_ENTRY)&_ZN6S472C43v87Ev,
  (VTBL_ENTRY)&_ZN6S472C43v88Ev,
  (VTBL_ENTRY)&_ZN6S472C43v89Ev,
  (VTBL_ENTRY)&_ZN6S472C43v90Ev,
  (VTBL_ENTRY)&_ZN6S472C43v91Ev,
  (VTBL_ENTRY)&_ZN6S472C43v92Ev,
  (VTBL_ENTRY)&_ZN6S472C43v93Ev,
  (VTBL_ENTRY)&_ZN6S472C43v94Ev,
  (VTBL_ENTRY)&_ZN6S472C43v95Ev,
  (VTBL_ENTRY)&_ZN6S472C33v96Ev,
  (VTBL_ENTRY)&_ZN6S472C33v97Ev,
  (VTBL_ENTRY)&_ZN6S472C33v98Ev,
  (VTBL_ENTRY)&_ZN6S472C33v99Ev,
  (VTBL_ENTRY)&_ZN6S472C34v100Ev,
  (VTBL_ENTRY)&_ZN6S472C34v101Ev,
  (VTBL_ENTRY)&_ZN6S472C34v102Ev,
  (VTBL_ENTRY)&_ZN6S472C34v103Ev,
  (VTBL_ENTRY)&_ZN6S472C34v104Ev,
  (VTBL_ENTRY)&_ZN6S472C34v105Ev,
  (VTBL_ENTRY)&_ZN6S472C34v106Ev,
  (VTBL_ENTRY)&_ZN6S472C34v107Ev,
  (VTBL_ENTRY)&_ZN6S472C34v108Ev,
  (VTBL_ENTRY)&_ZN6S472C34v109Ev,
  (VTBL_ENTRY)&_ZN6S472C34v110Ev,
  (VTBL_ENTRY)&_ZN6S472C34v111Ev,
  (VTBL_ENTRY)&_ZN6S472C34v112Ev,
  (VTBL_ENTRY)&_ZN6S472C34v113Ev,
  (VTBL_ENTRY)&_ZN6S472C34v114Ev,
};
extern VTBL_ENTRY _ZTI6S472C3[];
extern  VTBL_ENTRY _ZTV6S472C3[];
Class_Descriptor cd_S472C3 = {  "S472C3", // class name
  bases_S472C3, 2,
  &(vtc_S472C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S472C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S472C3),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S472C2  : S472C3 {
  void *s472c2f0;
  virtual  ~S472C2(); // _ZN6S472C2D1Ev
  virtual void  v115(); // _ZN6S472C24v115Ev
  virtual void  v116(); // _ZN6S472C24v116Ev
  virtual void  v117(); // _ZN6S472C24v117Ev
  virtual void  v118(); // _ZN6S472C24v118Ev
  virtual void  v119(); // _ZN6S472C24v119Ev
  virtual void  v120(); // _ZN6S472C24v120Ev
  virtual void  v121(); // _ZN6S472C24v121Ev
  virtual void  v122(); // _ZN6S472C24v122Ev
  virtual void  v123(); // _ZN6S472C24v123Ev
  S472C2(); // tgen
};
//SIG(-1 S472C2) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 FC5} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp}


 S472C2 ::~S472C2(){ note_dtor("S472C2", this);}
void  S472C2 ::v115(){vfunc_called(this, "_ZN6S472C24v115Ev");}
void  S472C2 ::v116(){vfunc_called(this, "_ZN6S472C24v116Ev");}
void  S472C2 ::v117(){vfunc_called(this, "_ZN6S472C24v117Ev");}
void  S472C2 ::v118(){vfunc_called(this, "_ZN6S472C24v118Ev");}
void  S472C2 ::v119(){vfunc_called(this, "_ZN6S472C24v119Ev");}
void  S472C2 ::v120(){vfunc_called(this, "_ZN6S472C24v120Ev");}
void  S472C2 ::v121(){vfunc_called(this, "_ZN6S472C24v121Ev");}
void  S472C2 ::v122(){vfunc_called(this, "_ZN6S472C24v122Ev");}
void  S472C2 ::v123(){vfunc_called(this, "_ZN6S472C24v123Ev");}
S472C2 ::S472C2(){ note_ctor("S472C2", this);} // tgen

static void Test_S472C2()
{
  extern Class_Descriptor cd_S472C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,37)];
    init_test(&cd_S472C2, buf);
    S472C2 *dp, &lv = *(dp=new (buf) S472C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,144), "sizeof(S472C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S472C2)");
    check_base_class_offset(lv, (S472C5*)(S472C4*)(S472C3*), 0, "S472C2");
    check_base_class_offset(lv, (S472C4*)(S472C3*), 0, "S472C2");
    check_base_class_offset(lv, (S472C3*), 0, "S472C2");
    check_field_offset(lv, s472c2f0, ABISELECT(200,140), "S472C2.s472c2f0");
    test_class_info(&lv, &cd_S472C2);
    dp->~S472C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS472C2(Test_S472C2, "S472C2", ABISELECT(208,144));

#else // __cplusplus

extern void _ZN6S472C2C1Ev();
extern void _ZN6S472C2D1Ev();
Name_Map name_map_S472C2[] = {
  NSPAIR(_ZN6S472C2C1Ev),
  NSPAIR(_ZN6S472C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S472C5;
extern VTBL_ENTRY _ZTI6S472C5[];
extern  VTBL_ENTRY _ZTV6S472C5[];
extern Class_Descriptor cd_S472C4;
extern VTBL_ENTRY _ZTI6S472C4[];
extern  VTBL_ENTRY _ZTV6S472C4[];
extern Class_Descriptor cd_S472C3;
extern VTBL_ENTRY _ZTI6S472C3[];
extern  VTBL_ENTRY _ZTV6S472C3[];
static Base_Class bases_S472C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S472C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S472C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S472C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S472C2[];
extern void _ZN6S472C2D1Ev();
extern void _ZN6S472C2D0Ev();
extern void _ZN6S472C53v10Ev();
extern void _ZN6S472C53v11Ev();
extern void _ZN6S472C53v12Ev();
extern void _ZN6S472C53v13Ev();
extern void _ZN6S472C53v14Ev();
extern void _ZN6S472C53v15Ev();
extern void _ZN6S472C53v16Ev();
extern void _ZN6S472C53v17Ev();
extern void _ZN6S472C53v18Ev();
extern void _ZN6S472C53v19Ev();
extern void _ZN6S472C53v20Ev();
extern void _ZN6S472C53v21Ev();
extern void _ZN6S472C53v22Ev();
extern void _ZN6S472C53v23Ev();
extern void _ZN6S472C53v24Ev();
extern void _ZN6S472C53v25Ev();
extern void _ZN6S472C53v26Ev();
extern void _ZN6S472C53v27Ev();
extern void _ZN6S472C53v28Ev();
extern void _ZN6S472C53v29Ev();
extern void _ZN6S472C53v30Ev();
extern void _ZN6S472C53v31Ev();
extern void _ZN6S472C53v32Ev();
extern void _ZN6S472C53v33Ev();
extern void _ZN6S472C53v34Ev();
extern void _ZN6S472C53v35Ev();
extern void _ZN6S472C53v36Ev();
extern void _ZN6S472C53v37Ev();
extern void _ZN6S472C53v38Ev();
extern void _ZN6S472C53v39Ev();
extern void _ZN6S472C53v40Ev();
extern void _ZN6S472C53v41Ev();
extern void _ZN6S472C53v42Ev();
extern void _ZN6S472C53v43Ev();
extern void _ZN6S472C53v44Ev();
extern void _ZN6S472C53v45Ev();
extern void _ZN6S472C53v46Ev();
extern void _ZN6S472C53v47Ev();
extern void _ZN6S472C53v48Ev();
extern void _ZN6S472C53v49Ev();
extern void _ZN6S472C53v50Ev();
extern void _ZN6S472C53v51Ev();
extern void _ZN6S472C53v52Ev();
extern void _ZN6S472C53v53Ev();
extern void _ZN6S472C53v54Ev();
extern void _ZN6S472C53v55Ev();
extern void _ZN6S472C53v56Ev();
extern void _ZN6S472C53v57Ev();
extern void _ZN6S472C53v58Ev();
extern void _ZN6S472C53v59Ev();
extern void _ZN6S472C53v60Ev();
extern void _ZN6S472C53v61Ev();
extern void _ZN6S472C53v62Ev();
extern void _ZN6S472C53v63Ev();
extern void _ZN6S472C53v64Ev();
extern void _ZN6S472C53v65Ev();
extern void _ZN6S472C53v66Ev();
extern void _ZN6S472C53v67Ev();
extern void _ZN6S472C53v68Ev();
extern void _ZN6S472C53v69Ev();
extern void _ZN6S472C53v70Ev();
extern void _ZN6S472C53v71Ev();
extern void _ZN6S472C53v72Ev();
extern void _ZN6S472C53v73Ev();
extern void _ZN6S472C43v74Ev();
extern void _ZN6S472C43v75Ev();
extern void _ZN6S472C43v76Ev();
extern void _ZN6S472C43v77Ev();
extern void _ZN6S472C43v78Ev();
extern void _ZN6S472C43v79Ev();
extern void _ZN6S472C43v80Ev();
extern void _ZN6S472C43v81Ev();
extern void _ZN6S472C43v82Ev();
extern void _ZN6S472C43v83Ev();
extern void _ZN6S472C43v84Ev();
extern void _ZN6S472C43v85Ev();
extern void _ZN6S472C43v86Ev();
extern void _ZN6S472C43v87Ev();
extern void _ZN6S472C43v88Ev();
extern void _ZN6S472C43v89Ev();
extern void _ZN6S472C43v90Ev();
extern void _ZN6S472C43v91Ev();
extern void _ZN6S472C43v92Ev();
extern void _ZN6S472C43v93Ev();
extern void _ZN6S472C43v94Ev();
extern void _ZN6S472C43v95Ev();
extern void _ZN6S472C33v96Ev();
extern void _ZN6S472C33v97Ev();
extern void _ZN6S472C33v98Ev();
extern void _ZN6S472C33v99Ev();
extern void _ZN6S472C34v100Ev();
extern void _ZN6S472C34v101Ev();
extern void _ZN6S472C34v102Ev();
extern void _ZN6S472C34v103Ev();
extern void _ZN6S472C34v104Ev();
extern void _ZN6S472C34v105Ev();
extern void _ZN6S472C34v106Ev();
extern void _ZN6S472C34v107Ev();
extern void _ZN6S472C34v108Ev();
extern void _ZN6S472C34v109Ev();
extern void _ZN6S472C34v110Ev();
extern void _ZN6S472C34v111Ev();
extern void _ZN6S472C34v112Ev();
extern void _ZN6S472C34v113Ev();
extern void _ZN6S472C34v114Ev();
extern void _ZN6S472C24v115Ev();
extern void _ZN6S472C24v116Ev();
extern void _ZN6S472C24v117Ev();
extern void _ZN6S472C24v118Ev();
extern void _ZN6S472C24v119Ev();
extern void _ZN6S472C24v120Ev();
extern void _ZN6S472C24v121Ev();
extern void _ZN6S472C24v122Ev();
extern void _ZN6S472C24v123Ev();
static  VTBL_ENTRY vtc_S472C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S472C2[0]),
  (VTBL_ENTRY)&_ZN6S472C2D1Ev,
  (VTBL_ENTRY)&_ZN6S472C2D0Ev,
  (VTBL_ENTRY)&_ZN6S472C53v10Ev,
  (VTBL_ENTRY)&_ZN6S472C53v11Ev,
  (VTBL_ENTRY)&_ZN6S472C53v12Ev,
  (VTBL_ENTRY)&_ZN6S472C53v13Ev,
  (VTBL_ENTRY)&_ZN6S472C53v14Ev,
  (VTBL_ENTRY)&_ZN6S472C53v15Ev,
  (VTBL_ENTRY)&_ZN6S472C53v16Ev,
  (VTBL_ENTRY)&_ZN6S472C53v17Ev,
  (VTBL_ENTRY)&_ZN6S472C53v18Ev,
  (VTBL_ENTRY)&_ZN6S472C53v19Ev,
  (VTBL_ENTRY)&_ZN6S472C53v20Ev,
  (VTBL_ENTRY)&_ZN6S472C53v21Ev,
  (VTBL_ENTRY)&_ZN6S472C53v22Ev,
  (VTBL_ENTRY)&_ZN6S472C53v23Ev,
  (VTBL_ENTRY)&_ZN6S472C53v24Ev,
  (VTBL_ENTRY)&_ZN6S472C53v25Ev,
  (VTBL_ENTRY)&_ZN6S472C53v26Ev,
  (VTBL_ENTRY)&_ZN6S472C53v27Ev,
  (VTBL_ENTRY)&_ZN6S472C53v28Ev,
  (VTBL_ENTRY)&_ZN6S472C53v29Ev,
  (VTBL_ENTRY)&_ZN6S472C53v30Ev,
  (VTBL_ENTRY)&_ZN6S472C53v31Ev,
  (VTBL_ENTRY)&_ZN6S472C53v32Ev,
  (VTBL_ENTRY)&_ZN6S472C53v33Ev,
  (VTBL_ENTRY)&_ZN6S472C53v34Ev,
  (VTBL_ENTRY)&_ZN6S472C53v35Ev,
  (VTBL_ENTRY)&_ZN6S472C53v36Ev,
  (VTBL_ENTRY)&_ZN6S472C53v37Ev,
  (VTBL_ENTRY)&_ZN6S472C53v38Ev,
  (VTBL_ENTRY)&_ZN6S472C53v39Ev,
  (VTBL_ENTRY)&_ZN6S472C53v40Ev,
  (VTBL_ENTRY)&_ZN6S472C53v41Ev,
  (VTBL_ENTRY)&_ZN6S472C53v42Ev,
  (VTBL_ENTRY)&_ZN6S472C53v43Ev,
  (VTBL_ENTRY)&_ZN6S472C53v44Ev,
  (VTBL_ENTRY)&_ZN6S472C53v45Ev,
  (VTBL_ENTRY)&_ZN6S472C53v46Ev,
  (VTBL_ENTRY)&_ZN6S472C53v47Ev,
  (VTBL_ENTRY)&_ZN6S472C53v48Ev,
  (VTBL_ENTRY)&_ZN6S472C53v49Ev,
  (VTBL_ENTRY)&_ZN6S472C53v50Ev,
  (VTBL_ENTRY)&_ZN6S472C53v51Ev,
  (VTBL_ENTRY)&_ZN6S472C53v52Ev,
  (VTBL_ENTRY)&_ZN6S472C53v53Ev,
  (VTBL_ENTRY)&_ZN6S472C53v54Ev,
  (VTBL_ENTRY)&_ZN6S472C53v55Ev,
  (VTBL_ENTRY)&_ZN6S472C53v56Ev,
  (VTBL_ENTRY)&_ZN6S472C53v57Ev,
  (VTBL_ENTRY)&_ZN6S472C53v58Ev,
  (VTBL_ENTRY)&_ZN6S472C53v59Ev,
  (VTBL_ENTRY)&_ZN6S472C53v60Ev,
  (VTBL_ENTRY)&_ZN6S472C53v61Ev,
  (VTBL_ENTRY)&_ZN6S472C53v62Ev,
  (VTBL_ENTRY)&_ZN6S472C53v63Ev,
  (VTBL_ENTRY)&_ZN6S472C53v64Ev,
  (VTBL_ENTRY)&_ZN6S472C53v65Ev,
  (VTBL_ENTRY)&_ZN6S472C53v66Ev,
  (VTBL_ENTRY)&_ZN6S472C53v67Ev,
  (VTBL_ENTRY)&_ZN6S472C53v68Ev,
  (VTBL_ENTRY)&_ZN6S472C53v69Ev,
  (VTBL_ENTRY)&_ZN6S472C53v70Ev,
  (VTBL_ENTRY)&_ZN6S472C53v71Ev,
  (VTBL_ENTRY)&_ZN6S472C53v72Ev,
  (VTBL_ENTRY)&_ZN6S472C53v73Ev,
  (VTBL_ENTRY)&_ZN6S472C43v74Ev,
  (VTBL_ENTRY)&_ZN6S472C43v75Ev,
  (VTBL_ENTRY)&_ZN6S472C43v76Ev,
  (VTBL_ENTRY)&_ZN6S472C43v77Ev,
  (VTBL_ENTRY)&_ZN6S472C43v78Ev,
  (VTBL_ENTRY)&_ZN6S472C43v79Ev,
  (VTBL_ENTRY)&_ZN6S472C43v80Ev,
  (VTBL_ENTRY)&_ZN6S472C43v81Ev,
  (VTBL_ENTRY)&_ZN6S472C43v82Ev,
  (VTBL_ENTRY)&_ZN6S472C43v83Ev,
  (VTBL_ENTRY)&_ZN6S472C43v84Ev,
  (VTBL_ENTRY)&_ZN6S472C43v85Ev,
  (VTBL_ENTRY)&_ZN6S472C43v86Ev,
  (VTBL_ENTRY)&_ZN6S472C43v87Ev,
  (VTBL_ENTRY)&_ZN6S472C43v88Ev,
  (VTBL_ENTRY)&_ZN6S472C43v89Ev,
  (VTBL_ENTRY)&_ZN6S472C43v90Ev,
  (VTBL_ENTRY)&_ZN6S472C43v91Ev,
  (VTBL_ENTRY)&_ZN6S472C43v92Ev,
  (VTBL_ENTRY)&_ZN6S472C43v93Ev,
  (VTBL_ENTRY)&_ZN6S472C43v94Ev,
  (VTBL_ENTRY)&_ZN6S472C43v95Ev,
  (VTBL_ENTRY)&_ZN6S472C33v96Ev,
  (VTBL_ENTRY)&_ZN6S472C33v97Ev,
  (VTBL_ENTRY)&_ZN6S472C33v98Ev,
  (VTBL_ENTRY)&_ZN6S472C33v99Ev,
  (VTBL_ENTRY)&_ZN6S472C34v100Ev,
  (VTBL_ENTRY)&_ZN6S472C34v101Ev,
  (VTBL_ENTRY)&_ZN6S472C34v102Ev,
  (VTBL_ENTRY)&_ZN6S472C34v103Ev,
  (VTBL_ENTRY)&_ZN6S472C34v104Ev,
  (VTBL_ENTRY)&_ZN6S472C34v105Ev,
  (VTBL_ENTRY)&_ZN6S472C34v106Ev,
  (VTBL_ENTRY)&_ZN6S472C34v107Ev,
  (VTBL_ENTRY)&_ZN6S472C34v108Ev,
  (VTBL_ENTRY)&_ZN6S472C34v109Ev,
  (VTBL_ENTRY)&_ZN6S472C34v110Ev,
  (VTBL_ENTRY)&_ZN6S472C34v111Ev,
  (VTBL_ENTRY)&_ZN6S472C34v112Ev,
  (VTBL_ENTRY)&_ZN6S472C34v113Ev,
  (VTBL_ENTRY)&_ZN6S472C34v114Ev,
  (VTBL_ENTRY)&_ZN6S472C24v115Ev,
  (VTBL_ENTRY)&_ZN6S472C24v116Ev,
  (VTBL_ENTRY)&_ZN6S472C24v117Ev,
  (VTBL_ENTRY)&_ZN6S472C24v118Ev,
  (VTBL_ENTRY)&_ZN6S472C24v119Ev,
  (VTBL_ENTRY)&_ZN6S472C24v120Ev,
  (VTBL_ENTRY)&_ZN6S472C24v121Ev,
  (VTBL_ENTRY)&_ZN6S472C24v122Ev,
  (VTBL_ENTRY)&_ZN6S472C24v123Ev,
};
extern VTBL_ENTRY _ZTI6S472C2[];
extern  VTBL_ENTRY _ZTV6S472C2[];
Class_Descriptor cd_S472C2 = {  "S472C2", // class name
  bases_S472C2, 3,
  &(vtc_S472C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,144), // object size
  NSPAIRA(_ZTI6S472C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S472C2),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S472C1  : S472C2 {
  ::S672C14_nt s472c1f0;
  virtual  ~S472C1(); // _ZN6S472C1D1Ev
  virtual void  v1(); // _ZN6S472C12v1Ev
  virtual void  v2(); // _ZN6S472C12v2Ev
  virtual void  v3(); // _ZN6S472C12v3Ev
  virtual void  v4(); // _ZN6S472C12v4Ev
  virtual void  v5(); // _ZN6S472C12v5Ev
  virtual void  v6(); // _ZN6S472C12v6Ev
  virtual void  v7(); // _ZN6S472C12v7Ev
  virtual void  v8(); // _ZN6S472C12v8Ev
  virtual void  v9(); // _ZN6S472C12v9Ev
  S472C1(); // tgen
};
//SIG(1 S472C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 FC6} vd v115 v116 v117 v118 v119 v120 v121 v122 v123 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC12{ BC13{ BC10}}}


 S472C1 ::~S472C1(){ note_dtor("S472C1", this);}
void  S472C1 ::v1(){vfunc_called(this, "_ZN6S472C12v1Ev");}
void  S472C1 ::v2(){vfunc_called(this, "_ZN6S472C12v2Ev");}
void  S472C1 ::v3(){vfunc_called(this, "_ZN6S472C12v3Ev");}
void  S472C1 ::v4(){vfunc_called(this, "_ZN6S472C12v4Ev");}
void  S472C1 ::v5(){vfunc_called(this, "_ZN6S472C12v5Ev");}
void  S472C1 ::v6(){vfunc_called(this, "_ZN6S472C12v6Ev");}
void  S472C1 ::v7(){vfunc_called(this, "_ZN6S472C12v7Ev");}
void  S472C1 ::v8(){vfunc_called(this, "_ZN6S472C12v8Ev");}
void  S472C1 ::v9(){vfunc_called(this, "_ZN6S472C12v9Ev");}
S472C1 ::S472C1(){ note_ctor("S472C1", this);} // tgen

static void Test_S472C1()
{
  extern Class_Descriptor cd_S472C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,40)];
    init_test(&cd_S472C1, buf);
    S472C1 *dp, &lv = *(dp=new (buf) S472C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,156), "sizeof(S472C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S472C1)");
    check_base_class_offset(lv, (S472C5*)(S472C4*)(S472C3*)(S472C2*), 0, "S472C1");
    check_base_class_offset(lv, (S472C4*)(S472C3*)(S472C2*), 0, "S472C1");
    check_base_class_offset(lv, (S472C3*)(S472C2*), 0, "S472C1");
    check_base_class_offset(lv, (S472C2*), 0, "S472C1");
    check_field_offset(lv, s472c1f0, ABISELECT(208,144), "S472C1.s472c1f0");
    test_class_info(&lv, &cd_S472C1);
    dp->~S472C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS472C1(Test_S472C1, "S472C1", ABISELECT(224,156));

#else // __cplusplus

extern void _ZN6S472C1C1Ev();
extern void _ZN6S472C1D1Ev();
Name_Map name_map_S472C1[] = {
  NSPAIR(_ZN6S472C1C1Ev),
  NSPAIR(_ZN6S472C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S472C5;
extern VTBL_ENTRY _ZTI6S472C5[];
extern  VTBL_ENTRY _ZTV6S472C5[];
extern Class_Descriptor cd_S472C4;
extern VTBL_ENTRY _ZTI6S472C4[];
extern  VTBL_ENTRY _ZTV6S472C4[];
extern Class_Descriptor cd_S472C3;
extern VTBL_ENTRY _ZTI6S472C3[];
extern  VTBL_ENTRY _ZTV6S472C3[];
extern Class_Descriptor cd_S472C2;
extern VTBL_ENTRY _ZTI6S472C2[];
extern  VTBL_ENTRY _ZTV6S472C2[];
static Base_Class bases_S472C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S472C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S472C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S472C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S472C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S472C1[];
extern void _ZN6S472C1D1Ev();
extern void _ZN6S472C1D0Ev();
extern void _ZN6S472C53v10Ev();
extern void _ZN6S472C53v11Ev();
extern void _ZN6S472C53v12Ev();
extern void _ZN6S472C53v13Ev();
extern void _ZN6S472C53v14Ev();
extern void _ZN6S472C53v15Ev();
extern void _ZN6S472C53v16Ev();
extern void _ZN6S472C53v17Ev();
extern void _ZN6S472C53v18Ev();
extern void _ZN6S472C53v19Ev();
extern void _ZN6S472C53v20Ev();
extern void _ZN6S472C53v21Ev();
extern void _ZN6S472C53v22Ev();
extern void _ZN6S472C53v23Ev();
extern void _ZN6S472C53v24Ev();
extern void _ZN6S472C53v25Ev();
extern void _ZN6S472C53v26Ev();
extern void _ZN6S472C53v27Ev();
extern void _ZN6S472C53v28Ev();
extern void _ZN6S472C53v29Ev();
extern void _ZN6S472C53v30Ev();
extern void _ZN6S472C53v31Ev();
extern void _ZN6S472C53v32Ev();
extern void _ZN6S472C53v33Ev();
extern void _ZN6S472C53v34Ev();
extern void _ZN6S472C53v35Ev();
extern void _ZN6S472C53v36Ev();
extern void _ZN6S472C53v37Ev();
extern void _ZN6S472C53v38Ev();
extern void _ZN6S472C53v39Ev();
extern void _ZN6S472C53v40Ev();
extern void _ZN6S472C53v41Ev();
extern void _ZN6S472C53v42Ev();
extern void _ZN6S472C53v43Ev();
extern void _ZN6S472C53v44Ev();
extern void _ZN6S472C53v45Ev();
extern void _ZN6S472C53v46Ev();
extern void _ZN6S472C53v47Ev();
extern void _ZN6S472C53v48Ev();
extern void _ZN6S472C53v49Ev();
extern void _ZN6S472C53v50Ev();
extern void _ZN6S472C53v51Ev();
extern void _ZN6S472C53v52Ev();
extern void _ZN6S472C53v53Ev();
extern void _ZN6S472C53v54Ev();
extern void _ZN6S472C53v55Ev();
extern void _ZN6S472C53v56Ev();
extern void _ZN6S472C53v57Ev();
extern void _ZN6S472C53v58Ev();
extern void _ZN6S472C53v59Ev();
extern void _ZN6S472C53v60Ev();
extern void _ZN6S472C53v61Ev();
extern void _ZN6S472C53v62Ev();
extern void _ZN6S472C53v63Ev();
extern void _ZN6S472C53v64Ev();
extern void _ZN6S472C53v65Ev();
extern void _ZN6S472C53v66Ev();
extern void _ZN6S472C53v67Ev();
extern void _ZN6S472C53v68Ev();
extern void _ZN6S472C53v69Ev();
extern void _ZN6S472C53v70Ev();
extern void _ZN6S472C53v71Ev();
extern void _ZN6S472C53v72Ev();
extern void _ZN6S472C53v73Ev();
extern void _ZN6S472C43v74Ev();
extern void _ZN6S472C43v75Ev();
extern void _ZN6S472C43v76Ev();
extern void _ZN6S472C43v77Ev();
extern void _ZN6S472C43v78Ev();
extern void _ZN6S472C43v79Ev();
extern void _ZN6S472C43v80Ev();
extern void _ZN6S472C43v81Ev();
extern void _ZN6S472C43v82Ev();
extern void _ZN6S472C43v83Ev();
extern void _ZN6S472C43v84Ev();
extern void _ZN6S472C43v85Ev();
extern void _ZN6S472C43v86Ev();
extern void _ZN6S472C43v87Ev();
extern void _ZN6S472C43v88Ev();
extern void _ZN6S472C43v89Ev();
extern void _ZN6S472C43v90Ev();
extern void _ZN6S472C43v91Ev();
extern void _ZN6S472C43v92Ev();
extern void _ZN6S472C43v93Ev();
extern void _ZN6S472C43v94Ev();
extern void _ZN6S472C43v95Ev();
extern void _ZN6S472C33v96Ev();
extern void _ZN6S472C33v97Ev();
extern void _ZN6S472C33v98Ev();
extern void _ZN6S472C33v99Ev();
extern void _ZN6S472C34v100Ev();
extern void _ZN6S472C34v101Ev();
extern void _ZN6S472C34v102Ev();
extern void _ZN6S472C34v103Ev();
extern void _ZN6S472C34v104Ev();
extern void _ZN6S472C34v105Ev();
extern void _ZN6S472C34v106Ev();
extern void _ZN6S472C34v107Ev();
extern void _ZN6S472C34v108Ev();
extern void _ZN6S472C34v109Ev();
extern void _ZN6S472C34v110Ev();
extern void _ZN6S472C34v111Ev();
extern void _ZN6S472C34v112Ev();
extern void _ZN6S472C34v113Ev();
extern void _ZN6S472C34v114Ev();
extern void _ZN6S472C24v115Ev();
extern void _ZN6S472C24v116Ev();
extern void _ZN6S472C24v117Ev();
extern void _ZN6S472C24v118Ev();
extern void _ZN6S472C24v119Ev();
extern void _ZN6S472C24v120Ev();
extern void _ZN6S472C24v121Ev();
extern void _ZN6S472C24v122Ev();
extern void _ZN6S472C24v123Ev();
extern void _ZN6S472C12v1Ev();
extern void _ZN6S472C12v2Ev();
extern void _ZN6S472C12v3Ev();
extern void _ZN6S472C12v4Ev();
extern void _ZN6S472C12v5Ev();
extern void _ZN6S472C12v6Ev();
extern void _ZN6S472C12v7Ev();
extern void _ZN6S472C12v8Ev();
extern void _ZN6S472C12v9Ev();
static  VTBL_ENTRY vtc_S472C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S472C1[0]),
  (VTBL_ENTRY)&_ZN6S472C1D1Ev,
  (VTBL_ENTRY)&_ZN6S472C1D0Ev,
  (VTBL_ENTRY)&_ZN6S472C53v10Ev,
  (VTBL_ENTRY)&_ZN6S472C53v11Ev,
  (VTBL_ENTRY)&_ZN6S472C53v12Ev,
  (VTBL_ENTRY)&_ZN6S472C53v13Ev,
  (VTBL_ENTRY)&_ZN6S472C53v14Ev,
  (VTBL_ENTRY)&_ZN6S472C53v15Ev,
  (VTBL_ENTRY)&_ZN6S472C53v16Ev,
  (VTBL_ENTRY)&_ZN6S472C53v17Ev,
  (VTBL_ENTRY)&_ZN6S472C53v18Ev,
  (VTBL_ENTRY)&_ZN6S472C53v19Ev,
  (VTBL_ENTRY)&_ZN6S472C53v20Ev,
  (VTBL_ENTRY)&_ZN6S472C53v21Ev,
  (VTBL_ENTRY)&_ZN6S472C53v22Ev,
  (VTBL_ENTRY)&_ZN6S472C53v23Ev,
  (VTBL_ENTRY)&_ZN6S472C53v24Ev,
  (VTBL_ENTRY)&_ZN6S472C53v25Ev,
  (VTBL_ENTRY)&_ZN6S472C53v26Ev,
  (VTBL_ENTRY)&_ZN6S472C53v27Ev,
  (VTBL_ENTRY)&_ZN6S472C53v28Ev,
  (VTBL_ENTRY)&_ZN6S472C53v29Ev,
  (VTBL_ENTRY)&_ZN6S472C53v30Ev,
  (VTBL_ENTRY)&_ZN6S472C53v31Ev,
  (VTBL_ENTRY)&_ZN6S472C53v32Ev,
  (VTBL_ENTRY)&_ZN6S472C53v33Ev,
  (VTBL_ENTRY)&_ZN6S472C53v34Ev,
  (VTBL_ENTRY)&_ZN6S472C53v35Ev,
  (VTBL_ENTRY)&_ZN6S472C53v36Ev,
  (VTBL_ENTRY)&_ZN6S472C53v37Ev,
  (VTBL_ENTRY)&_ZN6S472C53v38Ev,
  (VTBL_ENTRY)&_ZN6S472C53v39Ev,
  (VTBL_ENTRY)&_ZN6S472C53v40Ev,
  (VTBL_ENTRY)&_ZN6S472C53v41Ev,
  (VTBL_ENTRY)&_ZN6S472C53v42Ev,
  (VTBL_ENTRY)&_ZN6S472C53v43Ev,
  (VTBL_ENTRY)&_ZN6S472C53v44Ev,
  (VTBL_ENTRY)&_ZN6S472C53v45Ev,
  (VTBL_ENTRY)&_ZN6S472C53v46Ev,
  (VTBL_ENTRY)&_ZN6S472C53v47Ev,
  (VTBL_ENTRY)&_ZN6S472C53v48Ev,
  (VTBL_ENTRY)&_ZN6S472C53v49Ev,
  (VTBL_ENTRY)&_ZN6S472C53v50Ev,
  (VTBL_ENTRY)&_ZN6S472C53v51Ev,
  (VTBL_ENTRY)&_ZN6S472C53v52Ev,
  (VTBL_ENTRY)&_ZN6S472C53v53Ev,
  (VTBL_ENTRY)&_ZN6S472C53v54Ev,
  (VTBL_ENTRY)&_ZN6S472C53v55Ev,
  (VTBL_ENTRY)&_ZN6S472C53v56Ev,
  (VTBL_ENTRY)&_ZN6S472C53v57Ev,
  (VTBL_ENTRY)&_ZN6S472C53v58Ev,
  (VTBL_ENTRY)&_ZN6S472C53v59Ev,
  (VTBL_ENTRY)&_ZN6S472C53v60Ev,
  (VTBL_ENTRY)&_ZN6S472C53v61Ev,
  (VTBL_ENTRY)&_ZN6S472C53v62Ev,
  (VTBL_ENTRY)&_ZN6S472C53v63Ev,
  (VTBL_ENTRY)&_ZN6S472C53v64Ev,
  (VTBL_ENTRY)&_ZN6S472C53v65Ev,
  (VTBL_ENTRY)&_ZN6S472C53v66Ev,
  (VTBL_ENTRY)&_ZN6S472C53v67Ev,
  (VTBL_ENTRY)&_ZN6S472C53v68Ev,
  (VTBL_ENTRY)&_ZN6S472C53v69Ev,
  (VTBL_ENTRY)&_ZN6S472C53v70Ev,
  (VTBL_ENTRY)&_ZN6S472C53v71Ev,
  (VTBL_ENTRY)&_ZN6S472C53v72Ev,
  (VTBL_ENTRY)&_ZN6S472C53v73Ev,
  (VTBL_ENTRY)&_ZN6S472C43v74Ev,
  (VTBL_ENTRY)&_ZN6S472C43v75Ev,
  (VTBL_ENTRY)&_ZN6S472C43v76Ev,
  (VTBL_ENTRY)&_ZN6S472C43v77Ev,
  (VTBL_ENTRY)&_ZN6S472C43v78Ev,
  (VTBL_ENTRY)&_ZN6S472C43v79Ev,
  (VTBL_ENTRY)&_ZN6S472C43v80Ev,
  (VTBL_ENTRY)&_ZN6S472C43v81Ev,
  (VTBL_ENTRY)&_ZN6S472C43v82Ev,
  (VTBL_ENTRY)&_ZN6S472C43v83Ev,
  (VTBL_ENTRY)&_ZN6S472C43v84Ev,
  (VTBL_ENTRY)&_ZN6S472C43v85Ev,
  (VTBL_ENTRY)&_ZN6S472C43v86Ev,
  (VTBL_ENTRY)&_ZN6S472C43v87Ev,
  (VTBL_ENTRY)&_ZN6S472C43v88Ev,
  (VTBL_ENTRY)&_ZN6S472C43v89Ev,
  (VTBL_ENTRY)&_ZN6S472C43v90Ev,
  (VTBL_ENTRY)&_ZN6S472C43v91Ev,
  (VTBL_ENTRY)&_ZN6S472C43v92Ev,
  (VTBL_ENTRY)&_ZN6S472C43v93Ev,
  (VTBL_ENTRY)&_ZN6S472C43v94Ev,
  (VTBL_ENTRY)&_ZN6S472C43v95Ev,
  (VTBL_ENTRY)&_ZN6S472C33v96Ev,
  (VTBL_ENTRY)&_ZN6S472C33v97Ev,
  (VTBL_ENTRY)&_ZN6S472C33v98Ev,
  (VTBL_ENTRY)&_ZN6S472C33v99Ev,
  (VTBL_ENTRY)&_ZN6S472C34v100Ev,
  (VTBL_ENTRY)&_ZN6S472C34v101Ev,
  (VTBL_ENTRY)&_ZN6S472C34v102Ev,
  (VTBL_ENTRY)&_ZN6S472C34v103Ev,
  (VTBL_ENTRY)&_ZN6S472C34v104Ev,
  (VTBL_ENTRY)&_ZN6S472C34v105Ev,
  (VTBL_ENTRY)&_ZN6S472C34v106Ev,
  (VTBL_ENTRY)&_ZN6S472C34v107Ev,
  (VTBL_ENTRY)&_ZN6S472C34v108Ev,
  (VTBL_ENTRY)&_ZN6S472C34v109Ev,
  (VTBL_ENTRY)&_ZN6S472C34v110Ev,
  (VTBL_ENTRY)&_ZN6S472C34v111Ev,
  (VTBL_ENTRY)&_ZN6S472C34v112Ev,
  (VTBL_ENTRY)&_ZN6S472C34v113Ev,
  (VTBL_ENTRY)&_ZN6S472C34v114Ev,
  (VTBL_ENTRY)&_ZN6S472C24v115Ev,
  (VTBL_ENTRY)&_ZN6S472C24v116Ev,
  (VTBL_ENTRY)&_ZN6S472C24v117Ev,
  (VTBL_ENTRY)&_ZN6S472C24v118Ev,
  (VTBL_ENTRY)&_ZN6S472C24v119Ev,
  (VTBL_ENTRY)&_ZN6S472C24v120Ev,
  (VTBL_ENTRY)&_ZN6S472C24v121Ev,
  (VTBL_ENTRY)&_ZN6S472C24v122Ev,
  (VTBL_ENTRY)&_ZN6S472C24v123Ev,
  (VTBL_ENTRY)&_ZN6S472C12v1Ev,
  (VTBL_ENTRY)&_ZN6S472C12v2Ev,
  (VTBL_ENTRY)&_ZN6S472C12v3Ev,
  (VTBL_ENTRY)&_ZN6S472C12v4Ev,
  (VTBL_ENTRY)&_ZN6S472C12v5Ev,
  (VTBL_ENTRY)&_ZN6S472C12v6Ev,
  (VTBL_ENTRY)&_ZN6S472C12v7Ev,
  (VTBL_ENTRY)&_ZN6S472C12v8Ev,
  (VTBL_ENTRY)&_ZN6S472C12v9Ev,
};
extern VTBL_ENTRY _ZTI6S472C1[];
extern  VTBL_ENTRY _ZTV6S472C1[];
Class_Descriptor cd_S472C1 = {  "S472C1", // class name
  bases_S472C1, 4,
  &(vtc_S472C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,156), // object size
  NSPAIRA(_ZTI6S472C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S472C1),127, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S707C5  {
  int s707c5f0;
  __tsi64 s707c5f1;
  void *s707c5f2[4];
  int s707c5f3[2];
  void *s707c5f4;
  ::S473C6_nt s707c5f5;
  void *s707c5f6[2];
  virtual  ~S707C5(); // _ZN6S707C5D1Ev
  virtual void  v9(); // _ZN6S707C52v9Ev
  virtual void  v10(); // _ZN6S707C53v10Ev
  virtual void  v11(); // _ZN6S707C53v11Ev
  virtual void  v12(); // _ZN6S707C53v12Ev
  virtual void  v13(); // _ZN6S707C53v13Ev
  virtual void  v14(); // _ZN6S707C53v14Ev
  virtual void  v15(); // _ZN6S707C53v15Ev
  virtual void  v16(); // _ZN6S707C53v16Ev
  virtual void  v17(); // _ZN6S707C53v17Ev
  virtual void  v18(); // _ZN6S707C53v18Ev
  virtual void  v19(); // _ZN6S707C53v19Ev
  virtual void  v20(); // _ZN6S707C53v20Ev
  virtual void  v21(); // _ZN6S707C53v21Ev
  virtual void  v22(); // _ZN6S707C53v22Ev
  virtual void  v23(); // _ZN6S707C53v23Ev
  virtual void  v24(); // _ZN6S707C53v24Ev
  virtual void  v25(); // _ZN6S707C53v25Ev
  virtual void  v26(); // _ZN6S707C53v26Ev
  virtual void  v27(); // _ZN6S707C53v27Ev
  virtual void  v28(); // _ZN6S707C53v28Ev
  virtual void  v29(); // _ZN6S707C53v29Ev
  virtual void  v30(); // _ZN6S707C53v30Ev
  virtual void  v31(); // _ZN6S707C53v31Ev
  virtual void  v32(); // _ZN6S707C53v32Ev
  virtual void  v33(); // _ZN6S707C53v33Ev
  virtual void  v34(); // _ZN6S707C53v34Ev
  virtual void  v35(); // _ZN6S707C53v35Ev
  virtual void  v36(); // _ZN6S707C53v36Ev
  virtual void  v37(); // _ZN6S707C53v37Ev
  virtual void  v38(); // _ZN6S707C53v38Ev
  virtual void  v39(); // _ZN6S707C53v39Ev
  virtual void  v40(); // _ZN6S707C53v40Ev
  virtual void  v41(); // _ZN6S707C53v41Ev
  virtual void  v42(); // _ZN6S707C53v42Ev
  virtual void  v43(); // _ZN6S707C53v43Ev
  virtual void  v44(); // _ZN6S707C53v44Ev
  virtual void  v45(); // _ZN6S707C53v45Ev
  virtual void  v46(); // _ZN6S707C53v46Ev
  virtual void  v47(); // _ZN6S707C53v47Ev
  virtual void  v48(); // _ZN6S707C53v48Ev
  virtual void  v49(); // _ZN6S707C53v49Ev
  virtual void  v50(); // _ZN6S707C53v50Ev
  virtual void  v51(); // _ZN6S707C53v51Ev
  virtual void  v52(); // _ZN6S707C53v52Ev
  virtual void  v53(); // _ZN6S707C53v53Ev
  virtual void  v54(); // _ZN6S707C53v54Ev
  virtual void  v55(); // _ZN6S707C53v55Ev
  virtual void  v56(); // _ZN6S707C53v56Ev
  virtual void  v57(); // _ZN6S707C53v57Ev
  virtual void  v58(); // _ZN6S707C53v58Ev
  virtual void  v59(); // _ZN6S707C53v59Ev
  virtual void  v60(); // _ZN6S707C53v60Ev
  virtual void  v61(); // _ZN6S707C53v61Ev
  virtual void  v62(); // _ZN6S707C53v62Ev
  virtual void  v63(); // _ZN6S707C53v63Ev
  virtual void  v64(); // _ZN6S707C53v64Ev
  virtual void  v65(); // _ZN6S707C53v65Ev
  virtual void  v66(); // _ZN6S707C53v66Ev
  virtual void  v67(); // _ZN6S707C53v67Ev
  virtual void  v68(); // _ZN6S707C53v68Ev
  virtual void  v69(); // _ZN6S707C53v69Ev
  virtual void  v70(); // _ZN6S707C53v70Ev
  virtual void  v71(); // _ZN6S707C53v71Ev
  virtual void  v72(); // _ZN6S707C53v72Ev
  S707C5(); // tgen
};
//SIG(-1 S707C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S707C5 ::~S707C5(){ note_dtor("S707C5", this);}
void  S707C5 ::v9(){vfunc_called(this, "_ZN6S707C52v9Ev");}
void  S707C5 ::v10(){vfunc_called(this, "_ZN6S707C53v10Ev");}
void  S707C5 ::v11(){vfunc_called(this, "_ZN6S707C53v11Ev");}
void  S707C5 ::v12(){vfunc_called(this, "_ZN6S707C53v12Ev");}
void  S707C5 ::v13(){vfunc_called(this, "_ZN6S707C53v13Ev");}
void  S707C5 ::v14(){vfunc_called(this, "_ZN6S707C53v14Ev");}
void  S707C5 ::v15(){vfunc_called(this, "_ZN6S707C53v15Ev");}
void  S707C5 ::v16(){vfunc_called(this, "_ZN6S707C53v16Ev");}
void  S707C5 ::v17(){vfunc_called(this, "_ZN6S707C53v17Ev");}
void  S707C5 ::v18(){vfunc_called(this, "_ZN6S707C53v18Ev");}
void  S707C5 ::v19(){vfunc_called(this, "_ZN6S707C53v19Ev");}
void  S707C5 ::v20(){vfunc_called(this, "_ZN6S707C53v20Ev");}
void  S707C5 ::v21(){vfunc_called(this, "_ZN6S707C53v21Ev");}
void  S707C5 ::v22(){vfunc_called(this, "_ZN6S707C53v22Ev");}
void  S707C5 ::v23(){vfunc_called(this, "_ZN6S707C53v23Ev");}
void  S707C5 ::v24(){vfunc_called(this, "_ZN6S707C53v24Ev");}
void  S707C5 ::v25(){vfunc_called(this, "_ZN6S707C53v25Ev");}
void  S707C5 ::v26(){vfunc_called(this, "_ZN6S707C53v26Ev");}
void  S707C5 ::v27(){vfunc_called(this, "_ZN6S707C53v27Ev");}
void  S707C5 ::v28(){vfunc_called(this, "_ZN6S707C53v28Ev");}
void  S707C5 ::v29(){vfunc_called(this, "_ZN6S707C53v29Ev");}
void  S707C5 ::v30(){vfunc_called(this, "_ZN6S707C53v30Ev");}
void  S707C5 ::v31(){vfunc_called(this, "_ZN6S707C53v31Ev");}
void  S707C5 ::v32(){vfunc_called(this, "_ZN6S707C53v32Ev");}
void  S707C5 ::v33(){vfunc_called(this, "_ZN6S707C53v33Ev");}
void  S707C5 ::v34(){vfunc_called(this, "_ZN6S707C53v34Ev");}
void  S707C5 ::v35(){vfunc_called(this, "_ZN6S707C53v35Ev");}
void  S707C5 ::v36(){vfunc_called(this, "_ZN6S707C53v36Ev");}
void  S707C5 ::v37(){vfunc_called(this, "_ZN6S707C53v37Ev");}
void  S707C5 ::v38(){vfunc_called(this, "_ZN6S707C53v38Ev");}
void  S707C5 ::v39(){vfunc_called(this, "_ZN6S707C53v39Ev");}
void  S707C5 ::v40(){vfunc_called(this, "_ZN6S707C53v40Ev");}
void  S707C5 ::v41(){vfunc_called(this, "_ZN6S707C53v41Ev");}
void  S707C5 ::v42(){vfunc_called(this, "_ZN6S707C53v42Ev");}
void  S707C5 ::v43(){vfunc_called(this, "_ZN6S707C53v43Ev");}
void  S707C5 ::v44(){vfunc_called(this, "_ZN6S707C53v44Ev");}
void  S707C5 ::v45(){vfunc_called(this, "_ZN6S707C53v45Ev");}
void  S707C5 ::v46(){vfunc_called(this, "_ZN6S707C53v46Ev");}
void  S707C5 ::v47(){vfunc_called(this, "_ZN6S707C53v47Ev");}
void  S707C5 ::v48(){vfunc_called(this, "_ZN6S707C53v48Ev");}
void  S707C5 ::v49(){vfunc_called(this, "_ZN6S707C53v49Ev");}
void  S707C5 ::v50(){vfunc_called(this, "_ZN6S707C53v50Ev");}
void  S707C5 ::v51(){vfunc_called(this, "_ZN6S707C53v51Ev");}
void  S707C5 ::v52(){vfunc_called(this, "_ZN6S707C53v52Ev");}
void  S707C5 ::v53(){vfunc_called(this, "_ZN6S707C53v53Ev");}
void  S707C5 ::v54(){vfunc_called(this, "_ZN6S707C53v54Ev");}
void  S707C5 ::v55(){vfunc_called(this, "_ZN6S707C53v55Ev");}
void  S707C5 ::v56(){vfunc_called(this, "_ZN6S707C53v56Ev");}
void  S707C5 ::v57(){vfunc_called(this, "_ZN6S707C53v57Ev");}
void  S707C5 ::v58(){vfunc_called(this, "_ZN6S707C53v58Ev");}
void  S707C5 ::v59(){vfunc_called(this, "_ZN6S707C53v59Ev");}
void  S707C5 ::v60(){vfunc_called(this, "_ZN6S707C53v60Ev");}
void  S707C5 ::v61(){vfunc_called(this, "_ZN6S707C53v61Ev");}
void  S707C5 ::v62(){vfunc_called(this, "_ZN6S707C53v62Ev");}
void  S707C5 ::v63(){vfunc_called(this, "_ZN6S707C53v63Ev");}
void  S707C5 ::v64(){vfunc_called(this, "_ZN6S707C53v64Ev");}
void  S707C5 ::v65(){vfunc_called(this, "_ZN6S707C53v65Ev");}
void  S707C5 ::v66(){vfunc_called(this, "_ZN6S707C53v66Ev");}
void  S707C5 ::v67(){vfunc_called(this, "_ZN6S707C53v67Ev");}
void  S707C5 ::v68(){vfunc_called(this, "_ZN6S707C53v68Ev");}
void  S707C5 ::v69(){vfunc_called(this, "_ZN6S707C53v69Ev");}
void  S707C5 ::v70(){vfunc_called(this, "_ZN6S707C53v70Ev");}
void  S707C5 ::v71(){vfunc_called(this, "_ZN6S707C53v71Ev");}
void  S707C5 ::v72(){vfunc_called(this, "_ZN6S707C53v72Ev");}
S707C5 ::S707C5(){ note_ctor("S707C5", this);} // tgen

static void Test_S707C5()
{
  extern Class_Descriptor cd_S707C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S707C5, buf);
    S707C5 *dp, &lv = *(dp=new (buf) S707C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S707C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S707C5)");
    check_field_offset(lv, s707c5f0, ABISELECT(8,4), "S707C5.s707c5f0");
    check_field_offset(lv, s707c5f1, ABISELECT(16,8), "S707C5.s707c5f1");
    check_field_offset(lv, s707c5f2, ABISELECT(24,16), "S707C5.s707c5f2");
    check_field_offset(lv, s707c5f3, ABISELECT(56,32), "S707C5.s707c5f3");
    check_field_offset(lv, s707c5f4, ABISELECT(64,40), "S707C5.s707c5f4");
    check_field_offset(lv, s707c5f5, ABISELECT(72,44), "S707C5.s707c5f5");
    check_field_offset(lv, s707c5f6, ABISELECT(80,52), "S707C5.s707c5f6");
    test_class_info(&lv, &cd_S707C5);
    dp->~S707C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS707C5(Test_S707C5, "S707C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S707C5C1Ev();
extern void _ZN6S707C5D1Ev();
Name_Map name_map_S707C5[] = {
  NSPAIR(_ZN6S707C5C1Ev),
  NSPAIR(_ZN6S707C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S707C5[];
extern void _ZN6S707C5D1Ev();
extern void _ZN6S707C5D0Ev();
extern void _ZN6S707C52v9Ev();
extern void _ZN6S707C53v10Ev();
extern void _ZN6S707C53v11Ev();
extern void _ZN6S707C53v12Ev();
extern void _ZN6S707C53v13Ev();
extern void _ZN6S707C53v14Ev();
extern void _ZN6S707C53v15Ev();
extern void _ZN6S707C53v16Ev();
extern void _ZN6S707C53v17Ev();
extern void _ZN6S707C53v18Ev();
extern void _ZN6S707C53v19Ev();
extern void _ZN6S707C53v20Ev();
extern void _ZN6S707C53v21Ev();
extern void _ZN6S707C53v22Ev();
extern void _ZN6S707C53v23Ev();
extern void _ZN6S707C53v24Ev();
extern void _ZN6S707C53v25Ev();
extern void _ZN6S707C53v26Ev();
extern void _ZN6S707C53v27Ev();
extern void _ZN6S707C53v28Ev();
extern void _ZN6S707C53v29Ev();
extern void _ZN6S707C53v30Ev();
extern void _ZN6S707C53v31Ev();
extern void _ZN6S707C53v32Ev();
extern void _ZN6S707C53v33Ev();
extern void _ZN6S707C53v34Ev();
extern void _ZN6S707C53v35Ev();
extern void _ZN6S707C53v36Ev();
extern void _ZN6S707C53v37Ev();
extern void _ZN6S707C53v38Ev();
extern void _ZN6S707C53v39Ev();
extern void _ZN6S707C53v40Ev();
extern void _ZN6S707C53v41Ev();
extern void _ZN6S707C53v42Ev();
extern void _ZN6S707C53v43Ev();
extern void _ZN6S707C53v44Ev();
extern void _ZN6S707C53v45Ev();
extern void _ZN6S707C53v46Ev();
extern void _ZN6S707C53v47Ev();
extern void _ZN6S707C53v48Ev();
extern void _ZN6S707C53v49Ev();
extern void _ZN6S707C53v50Ev();
extern void _ZN6S707C53v51Ev();
extern void _ZN6S707C53v52Ev();
extern void _ZN6S707C53v53Ev();
extern void _ZN6S707C53v54Ev();
extern void _ZN6S707C53v55Ev();
extern void _ZN6S707C53v56Ev();
extern void _ZN6S707C53v57Ev();
extern void _ZN6S707C53v58Ev();
extern void _ZN6S707C53v59Ev();
extern void _ZN6S707C53v60Ev();
extern void _ZN6S707C53v61Ev();
extern void _ZN6S707C53v62Ev();
extern void _ZN6S707C53v63Ev();
extern void _ZN6S707C53v64Ev();
extern void _ZN6S707C53v65Ev();
extern void _ZN6S707C53v66Ev();
extern void _ZN6S707C53v67Ev();
extern void _ZN6S707C53v68Ev();
extern void _ZN6S707C53v69Ev();
extern void _ZN6S707C53v70Ev();
extern void _ZN6S707C53v71Ev();
extern void _ZN6S707C53v72Ev();
static  VTBL_ENTRY vtc_S707C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S707C5[0]),
  (VTBL_ENTRY)&_ZN6S707C5D1Ev,
  (VTBL_ENTRY)&_ZN6S707C5D0Ev,
  (VTBL_ENTRY)&_ZN6S707C52v9Ev,
  (VTBL_ENTRY)&_ZN6S707C53v10Ev,
  (VTBL_ENTRY)&_ZN6S707C53v11Ev,
  (VTBL_ENTRY)&_ZN6S707C53v12Ev,
  (VTBL_ENTRY)&_ZN6S707C53v13Ev,
  (VTBL_ENTRY)&_ZN6S707C53v14Ev,
  (VTBL_ENTRY)&_ZN6S707C53v15Ev,
  (VTBL_ENTRY)&_ZN6S707C53v16Ev,
  (VTBL_ENTRY)&_ZN6S707C53v17Ev,
  (VTBL_ENTRY)&_ZN6S707C53v18Ev,
  (VTBL_ENTRY)&_ZN6S707C53v19Ev,
  (VTBL_ENTRY)&_ZN6S707C53v20Ev,
  (VTBL_ENTRY)&_ZN6S707C53v21Ev,
  (VTBL_ENTRY)&_ZN6S707C53v22Ev,
  (VTBL_ENTRY)&_ZN6S707C53v23Ev,
  (VTBL_ENTRY)&_ZN6S707C53v24Ev,
  (VTBL_ENTRY)&_ZN6S707C53v25Ev,
  (VTBL_ENTRY)&_ZN6S707C53v26Ev,
  (VTBL_ENTRY)&_ZN6S707C53v27Ev,
  (VTBL_ENTRY)&_ZN6S707C53v28Ev,
  (VTBL_ENTRY)&_ZN6S707C53v29Ev,
  (VTBL_ENTRY)&_ZN6S707C53v30Ev,
  (VTBL_ENTRY)&_ZN6S707C53v31Ev,
  (VTBL_ENTRY)&_ZN6S707C53v32Ev,
  (VTBL_ENTRY)&_ZN6S707C53v33Ev,
  (VTBL_ENTRY)&_ZN6S707C53v34Ev,
  (VTBL_ENTRY)&_ZN6S707C53v35Ev,
  (VTBL_ENTRY)&_ZN6S707C53v36Ev,
  (VTBL_ENTRY)&_ZN6S707C53v37Ev,
  (VTBL_ENTRY)&_ZN6S707C53v38Ev,
  (VTBL_ENTRY)&_ZN6S707C53v39Ev,
  (VTBL_ENTRY)&_ZN6S707C53v40Ev,
  (VTBL_ENTRY)&_ZN6S707C53v41Ev,
  (VTBL_ENTRY)&_ZN6S707C53v42Ev,
  (VTBL_ENTRY)&_ZN6S707C53v43Ev,
  (VTBL_ENTRY)&_ZN6S707C53v44Ev,
  (VTBL_ENTRY)&_ZN6S707C53v45Ev,
  (VTBL_ENTRY)&_ZN6S707C53v46Ev,
  (VTBL_ENTRY)&_ZN6S707C53v47Ev,
  (VTBL_ENTRY)&_ZN6S707C53v48Ev,
  (VTBL_ENTRY)&_ZN6S707C53v49Ev,
  (VTBL_ENTRY)&_ZN6S707C53v50Ev,
  (VTBL_ENTRY)&_ZN6S707C53v51Ev,
  (VTBL_ENTRY)&_ZN6S707C53v52Ev,
  (VTBL_ENTRY)&_ZN6S707C53v53Ev,
  (VTBL_ENTRY)&_ZN6S707C53v54Ev,
  (VTBL_ENTRY)&_ZN6S707C53v55Ev,
  (VTBL_ENTRY)&_ZN6S707C53v56Ev,
  (VTBL_ENTRY)&_ZN6S707C53v57Ev,
  (VTBL_ENTRY)&_ZN6S707C53v58Ev,
  (VTBL_ENTRY)&_ZN6S707C53v59Ev,
  (VTBL_ENTRY)&_ZN6S707C53v60Ev,
  (VTBL_ENTRY)&_ZN6S707C53v61Ev,
  (VTBL_ENTRY)&_ZN6S707C53v62Ev,
  (VTBL_ENTRY)&_ZN6S707C53v63Ev,
  (VTBL_ENTRY)&_ZN6S707C53v64Ev,
  (VTBL_ENTRY)&_ZN6S707C53v65Ev,
  (VTBL_ENTRY)&_ZN6S707C53v66Ev,
  (VTBL_ENTRY)&_ZN6S707C53v67Ev,
  (VTBL_ENTRY)&_ZN6S707C53v68Ev,
  (VTBL_ENTRY)&_ZN6S707C53v69Ev,
  (VTBL_ENTRY)&_ZN6S707C53v70Ev,
  (VTBL_ENTRY)&_ZN6S707C53v71Ev,
  (VTBL_ENTRY)&_ZN6S707C53v72Ev,
};
extern VTBL_ENTRY _ZTI6S707C5[];
extern  VTBL_ENTRY _ZTV6S707C5[];
Class_Descriptor cd_S707C5 = {  "S707C5", // class name
  0,0,//no base classes
  &(vtc_S707C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S707C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S707C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S707C4  : S707C5 {
  int s707c4f0[2];
  void *s707c4f1;
  int s707c4f2[2];
  ::S473C7_nt s707c4f3;
  ::S473C7_nt s707c4f4;
  ::S21925C42 s707c4f5;
  ::S473C7_nt s707c4f6;
  unsigned int s707c4f7:1;
  unsigned int s707c4f8:1;
  unsigned int s707c4f9:1;
  unsigned int s707c4f10:1;
  unsigned int s707c4f11:1;
  int s707c4f12[2];
  virtual  ~S707C4(); // _ZN6S707C4D1Ev
  virtual void  v73(); // _ZN6S707C43v73Ev
  virtual void  v74(); // _ZN6S707C43v74Ev
  virtual void  v75(); // _ZN6S707C43v75Ev
  virtual void  v76(); // _ZN6S707C43v76Ev
  virtual void  v77(); // _ZN6S707C43v77Ev
  virtual void  v78(); // _ZN6S707C43v78Ev
  virtual void  v79(); // _ZN6S707C43v79Ev
  virtual void  v80(); // _ZN6S707C43v80Ev
  virtual void  v81(); // _ZN6S707C43v81Ev
  virtual void  v82(); // _ZN6S707C43v82Ev
  virtual void  v83(); // _ZN6S707C43v83Ev
  virtual void  v84(); // _ZN6S707C43v84Ev
  virtual void  v85(); // _ZN6S707C43v85Ev
  virtual void  v86(); // _ZN6S707C43v86Ev
  virtual void  v87(); // _ZN6S707C43v87Ev
  virtual void  v88(); // _ZN6S707C43v88Ev
  virtual void  v89(); // _ZN6S707C43v89Ev
  virtual void  v90(); // _ZN6S707C43v90Ev
  virtual void  v91(); // _ZN6S707C43v91Ev
  virtual void  v92(); // _ZN6S707C43v92Ev
  virtual void  v93(); // _ZN6S707C43v93Ev
  virtual void  v94(); // _ZN6S707C43v94Ev
  S707C4(); // tgen
};
//SIG(-1 S707C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S707C4 ::~S707C4(){ note_dtor("S707C4", this);}
void  S707C4 ::v73(){vfunc_called(this, "_ZN6S707C43v73Ev");}
void  S707C4 ::v74(){vfunc_called(this, "_ZN6S707C43v74Ev");}
void  S707C4 ::v75(){vfunc_called(this, "_ZN6S707C43v75Ev");}
void  S707C4 ::v76(){vfunc_called(this, "_ZN6S707C43v76Ev");}
void  S707C4 ::v77(){vfunc_called(this, "_ZN6S707C43v77Ev");}
void  S707C4 ::v78(){vfunc_called(this, "_ZN6S707C43v78Ev");}
void  S707C4 ::v79(){vfunc_called(this, "_ZN6S707C43v79Ev");}
void  S707C4 ::v80(){vfunc_called(this, "_ZN6S707C43v80Ev");}
void  S707C4 ::v81(){vfunc_called(this, "_ZN6S707C43v81Ev");}
void  S707C4 ::v82(){vfunc_called(this, "_ZN6S707C43v82Ev");}
void  S707C4 ::v83(){vfunc_called(this, "_ZN6S707C43v83Ev");}
void  S707C4 ::v84(){vfunc_called(this, "_ZN6S707C43v84Ev");}
void  S707C4 ::v85(){vfunc_called(this, "_ZN6S707C43v85Ev");}
void  S707C4 ::v86(){vfunc_called(this, "_ZN6S707C43v86Ev");}
void  S707C4 ::v87(){vfunc_called(this, "_ZN6S707C43v87Ev");}
void  S707C4 ::v88(){vfunc_called(this, "_ZN6S707C43v88Ev");}
void  S707C4 ::v89(){vfunc_called(this, "_ZN6S707C43v89Ev");}
void  S707C4 ::v90(){vfunc_called(this, "_ZN6S707C43v90Ev");}
void  S707C4 ::v91(){vfunc_called(this, "_ZN6S707C43v91Ev");}
void  S707C4 ::v92(){vfunc_called(this, "_ZN6S707C43v92Ev");}
void  S707C4 ::v93(){vfunc_called(this, "_ZN6S707C43v93Ev");}
void  S707C4 ::v94(){vfunc_called(this, "_ZN6S707C43v94Ev");}
S707C4 ::S707C4(){ note_ctor("S707C4", this);} // tgen

static void Test_S707C4()
{
  extern Class_Descriptor cd_S707C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S707C4, buf);
    S707C4 *dp, &lv = *(dp=new (buf) S707C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S707C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S707C4)");
    check_base_class_offset(lv, (S707C5*), 0, "S707C4");
    check_field_offset(lv, s707c4f0, ABISELECT(96,60), "S707C4.s707c4f0");
    check_field_offset(lv, s707c4f1, ABISELECT(104,68), "S707C4.s707c4f1");
    check_field_offset(lv, s707c4f2, ABISELECT(112,72), "S707C4.s707c4f2");
    check_field_offset(lv, s707c4f3, ABISELECT(120,80), "S707C4.s707c4f3");
    check_field_offset(lv, s707c4f4, ABISELECT(136,92), "S707C4.s707c4f4");
    check_field_offset(lv, s707c4f5, ABISELECT(152,104), "S707C4.s707c4f5");
    check_field_offset(lv, s707c4f6, ABISELECT(160,108), "S707C4.s707c4f6");
    set_bf_and_test(lv, s707c4f7, ABISELECT(176,120), 0, 1, 1, "S707C4");
    set_bf_and_test(lv, s707c4f8, ABISELECT(176,120), 1, 1, 1, "S707C4");
    set_bf_and_test(lv, s707c4f9, ABISELECT(176,120), 2, 1, 1, "S707C4");
    set_bf_and_test(lv, s707c4f10, ABISELECT(176,120), 3, 1, 1, "S707C4");
    set_bf_and_test(lv, s707c4f11, ABISELECT(176,120), 4, 1, 1, "S707C4");
    check_field_offset(lv, s707c4f12, ABISELECT(180,124), "S707C4.s707c4f12");
    test_class_info(&lv, &cd_S707C4);
    dp->~S707C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS707C4(Test_S707C4, "S707C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S707C4C1Ev();
extern void _ZN6S707C4D1Ev();
Name_Map name_map_S707C4[] = {
  NSPAIR(_ZN6S707C4C1Ev),
  NSPAIR(_ZN6S707C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S707C5;
extern VTBL_ENTRY _ZTI6S707C5[];
extern  VTBL_ENTRY _ZTV6S707C5[];
static Base_Class bases_S707C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S707C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S707C4[];
extern void _ZN6S707C4D1Ev();
extern void _ZN6S707C4D0Ev();
extern void _ZN6S707C52v9Ev();
extern void _ZN6S707C53v10Ev();
extern void _ZN6S707C53v11Ev();
extern void _ZN6S707C53v12Ev();
extern void _ZN6S707C53v13Ev();
extern void _ZN6S707C53v14Ev();
extern void _ZN6S707C53v15Ev();
extern void _ZN6S707C53v16Ev();
extern void _ZN6S707C53v17Ev();
extern void _ZN6S707C53v18Ev();
extern void _ZN6S707C53v19Ev();
extern void _ZN6S707C53v20Ev();
extern void _ZN6S707C53v21Ev();
extern void _ZN6S707C53v22Ev();
extern void _ZN6S707C53v23Ev();
extern void _ZN6S707C53v24Ev();
extern void _ZN6S707C53v25Ev();
extern void _ZN6S707C53v26Ev();
extern void _ZN6S707C53v27Ev();
extern void _ZN6S707C53v28Ev();
extern void _ZN6S707C53v29Ev();
extern void _ZN6S707C53v30Ev();
extern void _ZN6S707C53v31Ev();
extern void _ZN6S707C53v32Ev();
extern void _ZN6S707C53v33Ev();
extern void _ZN6S707C53v34Ev();
extern void _ZN6S707C53v35Ev();
extern void _ZN6S707C53v36Ev();
extern void _ZN6S707C53v37Ev();
extern void _ZN6S707C53v38Ev();
extern void _ZN6S707C53v39Ev();
extern void _ZN6S707C53v40Ev();
extern void _ZN6S707C53v41Ev();
extern void _ZN6S707C53v42Ev();
extern void _ZN6S707C53v43Ev();
extern void _ZN6S707C53v44Ev();
extern void _ZN6S707C53v45Ev();
extern void _ZN6S707C53v46Ev();
extern void _ZN6S707C53v47Ev();
extern void _ZN6S707C53v48Ev();
extern void _ZN6S707C53v49Ev();
extern void _ZN6S707C53v50Ev();
extern void _ZN6S707C53v51Ev();
extern void _ZN6S707C53v52Ev();
extern void _ZN6S707C53v53Ev();
extern void _ZN6S707C53v54Ev();
extern void _ZN6S707C53v55Ev();
extern void _ZN6S707C53v56Ev();
extern void _ZN6S707C53v57Ev();
extern void _ZN6S707C53v58Ev();
extern void _ZN6S707C53v59Ev();
extern void _ZN6S707C53v60Ev();
extern void _ZN6S707C53v61Ev();
extern void _ZN6S707C53v62Ev();
extern void _ZN6S707C53v63Ev();
extern void _ZN6S707C53v64Ev();
extern void _ZN6S707C53v65Ev();
extern void _ZN6S707C53v66Ev();
extern void _ZN6S707C53v67Ev();
extern void _ZN6S707C53v68Ev();
extern void _ZN6S707C53v69Ev();
extern void _ZN6S707C53v70Ev();
extern void _ZN6S707C53v71Ev();
extern void _ZN6S707C53v72Ev();
extern void _ZN6S707C43v73Ev();
extern void _ZN6S707C43v74Ev();
extern void _ZN6S707C43v75Ev();
extern void _ZN6S707C43v76Ev();
extern void _ZN6S707C43v77Ev();
extern void _ZN6S707C43v78Ev();
extern void _ZN6S707C43v79Ev();
extern void _ZN6S707C43v80Ev();
extern void _ZN6S707C43v81Ev();
extern void _ZN6S707C43v82Ev();
extern void _ZN6S707C43v83Ev();
extern void _ZN6S707C43v84Ev();
extern void _ZN6S707C43v85Ev();
extern void _ZN6S707C43v86Ev();
extern void _ZN6S707C43v87Ev();
extern void _ZN6S707C43v88Ev();
extern void _ZN6S707C43v89Ev();
extern void _ZN6S707C43v90Ev();
extern void _ZN6S707C43v91Ev();
extern void _ZN6S707C43v92Ev();
extern void _ZN6S707C43v93Ev();
extern void _ZN6S707C43v94Ev();
static  VTBL_ENTRY vtc_S707C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S707C4[0]),
  (VTBL_ENTRY)&_ZN6S707C4D1Ev,
  (VTBL_ENTRY)&_ZN6S707C4D0Ev,
  (VTBL_ENTRY)&_ZN6S707C52v9Ev,
  (VTBL_ENTRY)&_ZN6S707C53v10Ev,
  (VTBL_ENTRY)&_ZN6S707C53v11Ev,
  (VTBL_ENTRY)&_ZN6S707C53v12Ev,
  (VTBL_ENTRY)&_ZN6S707C53v13Ev,
  (VTBL_ENTRY)&_ZN6S707C53v14Ev,
  (VTBL_ENTRY)&_ZN6S707C53v15Ev,
  (VTBL_ENTRY)&_ZN6S707C53v16Ev,
  (VTBL_ENTRY)&_ZN6S707C53v17Ev,
  (VTBL_ENTRY)&_ZN6S707C53v18Ev,
  (VTBL_ENTRY)&_ZN6S707C53v19Ev,
  (VTBL_ENTRY)&_ZN6S707C53v20Ev,
  (VTBL_ENTRY)&_ZN6S707C53v21Ev,
  (VTBL_ENTRY)&_ZN6S707C53v22Ev,
  (VTBL_ENTRY)&_ZN6S707C53v23Ev,
  (VTBL_ENTRY)&_ZN6S707C53v24Ev,
  (VTBL_ENTRY)&_ZN6S707C53v25Ev,
  (VTBL_ENTRY)&_ZN6S707C53v26Ev,
  (VTBL_ENTRY)&_ZN6S707C53v27Ev,
  (VTBL_ENTRY)&_ZN6S707C53v28Ev,
  (VTBL_ENTRY)&_ZN6S707C53v29Ev,
  (VTBL_ENTRY)&_ZN6S707C53v30Ev,
  (VTBL_ENTRY)&_ZN6S707C53v31Ev,
  (VTBL_ENTRY)&_ZN6S707C53v32Ev,
  (VTBL_ENTRY)&_ZN6S707C53v33Ev,
  (VTBL_ENTRY)&_ZN6S707C53v34Ev,
  (VTBL_ENTRY)&_ZN6S707C53v35Ev,
  (VTBL_ENTRY)&_ZN6S707C53v36Ev,
  (VTBL_ENTRY)&_ZN6S707C53v37Ev,
  (VTBL_ENTRY)&_ZN6S707C53v38Ev,
  (VTBL_ENTRY)&_ZN6S707C53v39Ev,
  (VTBL_ENTRY)&_ZN6S707C53v40Ev,
  (VTBL_ENTRY)&_ZN6S707C53v41Ev,
  (VTBL_ENTRY)&_ZN6S707C53v42Ev,
  (VTBL_ENTRY)&_ZN6S707C53v43Ev,
  (VTBL_ENTRY)&_ZN6S707C53v44Ev,
  (VTBL_ENTRY)&_ZN6S707C53v45Ev,
  (VTBL_ENTRY)&_ZN6S707C53v46Ev,
  (VTBL_ENTRY)&_ZN6S707C53v47Ev,
  (VTBL_ENTRY)&_ZN6S707C53v48Ev,
  (VTBL_ENTRY)&_ZN6S707C53v49Ev,
  (VTBL_ENTRY)&_ZN6S707C53v50Ev,
  (VTBL_ENTRY)&_ZN6S707C53v51Ev,
  (VTBL_ENTRY)&_ZN6S707C53v52Ev,
  (VTBL_ENTRY)&_ZN6S707C53v53Ev,
  (VTBL_ENTRY)&_ZN6S707C53v54Ev,
  (VTBL_ENTRY)&_ZN6S707C53v55Ev,
  (VTBL_ENTRY)&_ZN6S707C53v56Ev,
  (VTBL_ENTRY)&_ZN6S707C53v57Ev,
  (VTBL_ENTRY)&_ZN6S707C53v58Ev,
  (VTBL_ENTRY)&_ZN6S707C53v59Ev,
  (VTBL_ENTRY)&_ZN6S707C53v60Ev,
  (VTBL_ENTRY)&_ZN6S707C53v61Ev,
  (VTBL_ENTRY)&_ZN6S707C53v62Ev,
  (VTBL_ENTRY)&_ZN6S707C53v63Ev,
  (VTBL_ENTRY)&_ZN6S707C53v64Ev,
  (VTBL_ENTRY)&_ZN6S707C53v65Ev,
  (VTBL_ENTRY)&_ZN6S707C53v66Ev,
  (VTBL_ENTRY)&_ZN6S707C53v67Ev,
  (VTBL_ENTRY)&_ZN6S707C53v68Ev,
  (VTBL_ENTRY)&_ZN6S707C53v69Ev,
  (VTBL_ENTRY)&_ZN6S707C53v70Ev,
  (VTBL_ENTRY)&_ZN6S707C53v71Ev,
  (VTBL_ENTRY)&_ZN6S707C53v72Ev,
  (VTBL_ENTRY)&_ZN6S707C43v73Ev,
  (VTBL_ENTRY)&_ZN6S707C43v74Ev,
  (VTBL_ENTRY)&_ZN6S707C43v75Ev,
  (VTBL_ENTRY)&_ZN6S707C43v76Ev,
  (VTBL_ENTRY)&_ZN6S707C43v77Ev,
  (VTBL_ENTRY)&_ZN6S707C43v78Ev,
  (VTBL_ENTRY)&_ZN6S707C43v79Ev,
  (VTBL_ENTRY)&_ZN6S707C43v80Ev,
  (VTBL_ENTRY)&_ZN6S707C43v81Ev,
  (VTBL_ENTRY)&_ZN6S707C43v82Ev,
  (VTBL_ENTRY)&_ZN6S707C43v83Ev,
  (VTBL_ENTRY)&_ZN6S707C43v84Ev,
  (VTBL_ENTRY)&_ZN6S707C43v85Ev,
  (VTBL_ENTRY)&_ZN6S707C43v86Ev,
  (VTBL_ENTRY)&_ZN6S707C43v87Ev,
  (VTBL_ENTRY)&_ZN6S707C43v88Ev,
  (VTBL_ENTRY)&_ZN6S707C43v89Ev,
  (VTBL_ENTRY)&_ZN6S707C43v90Ev,
  (VTBL_ENTRY)&_ZN6S707C43v91Ev,
  (VTBL_ENTRY)&_ZN6S707C43v92Ev,
  (VTBL_ENTRY)&_ZN6S707C43v93Ev,
  (VTBL_ENTRY)&_ZN6S707C43v94Ev,
};
extern VTBL_ENTRY _ZTI6S707C4[];
extern  VTBL_ENTRY _ZTV6S707C4[];
Class_Descriptor cd_S707C4 = {  "S707C4", // class name
  bases_S707C4, 1,
  &(vtc_S707C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S707C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S707C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S707C3  : S707C4 {
  ::S473C6_nt s707c3f0;
  virtual  ~S707C3(); // _ZN6S707C3D1Ev
  virtual void  v95(); // _ZN6S707C33v95Ev
  virtual void  v96(); // _ZN6S707C33v96Ev
  virtual void  v97(); // _ZN6S707C33v97Ev
  virtual void  v98(); // _ZN6S707C33v98Ev
  virtual void  v99(); // _ZN6S707C33v99Ev
  virtual void  v100(); // _ZN6S707C34v100Ev
  virtual void  v101(); // _ZN6S707C34v101Ev
  virtual void  v102(); // _ZN6S707C34v102Ev
  virtual void  v103(); // _ZN6S707C34v103Ev
  virtual void  v104(); // _ZN6S707C34v104Ev
  virtual void  v105(); // _ZN6S707C34v105Ev
  virtual void  v106(); // _ZN6S707C34v106Ev
  virtual void  v107(); // _ZN6S707C34v107Ev
  virtual void  v108(); // _ZN6S707C34v108Ev
  virtual void  v109(); // _ZN6S707C34v109Ev
  virtual void  v110(); // _ZN6S707C34v110Ev
  virtual void  v111(); // _ZN6S707C34v111Ev
  virtual void  v112(); // _ZN6S707C34v112Ev
  virtual void  v113(); // _ZN6S707C34v113Ev
  S707C3(); // tgen
};
//SIG(-1 S707C3) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S707C3 ::~S707C3(){ note_dtor("S707C3", this);}
void  S707C3 ::v95(){vfunc_called(this, "_ZN6S707C33v95Ev");}
void  S707C3 ::v96(){vfunc_called(this, "_ZN6S707C33v96Ev");}
void  S707C3 ::v97(){vfunc_called(this, "_ZN6S707C33v97Ev");}
void  S707C3 ::v98(){vfunc_called(this, "_ZN6S707C33v98Ev");}
void  S707C3 ::v99(){vfunc_called(this, "_ZN6S707C33v99Ev");}
void  S707C3 ::v100(){vfunc_called(this, "_ZN6S707C34v100Ev");}
void  S707C3 ::v101(){vfunc_called(this, "_ZN6S707C34v101Ev");}
void  S707C3 ::v102(){vfunc_called(this, "_ZN6S707C34v102Ev");}
void  S707C3 ::v103(){vfunc_called(this, "_ZN6S707C34v103Ev");}
void  S707C3 ::v104(){vfunc_called(this, "_ZN6S707C34v104Ev");}
void  S707C3 ::v105(){vfunc_called(this, "_ZN6S707C34v105Ev");}
void  S707C3 ::v106(){vfunc_called(this, "_ZN6S707C34v106Ev");}
void  S707C3 ::v107(){vfunc_called(this, "_ZN6S707C34v107Ev");}
void  S707C3 ::v108(){vfunc_called(this, "_ZN6S707C34v108Ev");}
void  S707C3 ::v109(){vfunc_called(this, "_ZN6S707C34v109Ev");}
void  S707C3 ::v110(){vfunc_called(this, "_ZN6S707C34v110Ev");}
void  S707C3 ::v111(){vfunc_called(this, "_ZN6S707C34v111Ev");}
void  S707C3 ::v112(){vfunc_called(this, "_ZN6S707C34v112Ev");}
void  S707C3 ::v113(){vfunc_called(this, "_ZN6S707C34v113Ev");}
S707C3 ::S707C3(){ note_ctor("S707C3", this);} // tgen

static void Test_S707C3()
{
  extern Class_Descriptor cd_S707C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S707C3, buf);
    S707C3 *dp, &lv = *(dp=new (buf) S707C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S707C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S707C3)");
    check_base_class_offset(lv, (S707C5*)(S707C4*), 0, "S707C3");
    check_base_class_offset(lv, (S707C4*), 0, "S707C3");
    check_field_offset(lv, s707c3f0, ABISELECT(188,132), "S707C3.s707c3f0");
    test_class_info(&lv, &cd_S707C3);
    dp->~S707C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS707C3(Test_S707C3, "S707C3", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S707C3C1Ev();
extern void _ZN6S707C3D1Ev();
Name_Map name_map_S707C3[] = {
  NSPAIR(_ZN6S707C3C1Ev),
  NSPAIR(_ZN6S707C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S707C5;
extern VTBL_ENTRY _ZTI6S707C5[];
extern  VTBL_ENTRY _ZTV6S707C5[];
extern Class_Descriptor cd_S707C4;
extern VTBL_ENTRY _ZTI6S707C4[];
extern  VTBL_ENTRY _ZTV6S707C4[];
static Base_Class bases_S707C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S707C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S707C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S707C3[];
extern void _ZN6S707C3D1Ev();
extern void _ZN6S707C3D0Ev();
extern void _ZN6S707C52v9Ev();
extern void _ZN6S707C53v10Ev();
extern void _ZN6S707C53v11Ev();
extern void _ZN6S707C53v12Ev();
extern void _ZN6S707C53v13Ev();
extern void _ZN6S707C53v14Ev();
extern void _ZN6S707C53v15Ev();
extern void _ZN6S707C53v16Ev();
extern void _ZN6S707C53v17Ev();
extern void _ZN6S707C53v18Ev();
extern void _ZN6S707C53v19Ev();
extern void _ZN6S707C53v20Ev();
extern void _ZN6S707C53v21Ev();
extern void _ZN6S707C53v22Ev();
extern void _ZN6S707C53v23Ev();
extern void _ZN6S707C53v24Ev();
extern void _ZN6S707C53v25Ev();
extern void _ZN6S707C53v26Ev();
extern void _ZN6S707C53v27Ev();
extern void _ZN6S707C53v28Ev();
extern void _ZN6S707C53v29Ev();
extern void _ZN6S707C53v30Ev();
extern void _ZN6S707C53v31Ev();
extern void _ZN6S707C53v32Ev();
extern void _ZN6S707C53v33Ev();
extern void _ZN6S707C53v34Ev();
extern void _ZN6S707C53v35Ev();
extern void _ZN6S707C53v36Ev();
extern void _ZN6S707C53v37Ev();
extern void _ZN6S707C53v38Ev();
extern void _ZN6S707C53v39Ev();
extern void _ZN6S707C53v40Ev();
extern void _ZN6S707C53v41Ev();
extern void _ZN6S707C53v42Ev();
extern void _ZN6S707C53v43Ev();
extern void _ZN6S707C53v44Ev();
extern void _ZN6S707C53v45Ev();
extern void _ZN6S707C53v46Ev();
extern void _ZN6S707C53v47Ev();
extern void _ZN6S707C53v48Ev();
extern void _ZN6S707C53v49Ev();
extern void _ZN6S707C53v50Ev();
extern void _ZN6S707C53v51Ev();
extern void _ZN6S707C53v52Ev();
extern void _ZN6S707C53v53Ev();
extern void _ZN6S707C53v54Ev();
extern void _ZN6S707C53v55Ev();
extern void _ZN6S707C53v56Ev();
extern void _ZN6S707C53v57Ev();
extern void _ZN6S707C53v58Ev();
extern void _ZN6S707C53v59Ev();
extern void _ZN6S707C53v60Ev();
extern void _ZN6S707C53v61Ev();
extern void _ZN6S707C53v62Ev();
extern void _ZN6S707C53v63Ev();
extern void _ZN6S707C53v64Ev();
extern void _ZN6S707C53v65Ev();
extern void _ZN6S707C53v66Ev();
extern void _ZN6S707C53v67Ev();
extern void _ZN6S707C53v68Ev();
extern void _ZN6S707C53v69Ev();
extern void _ZN6S707C53v70Ev();
extern void _ZN6S707C53v71Ev();
extern void _ZN6S707C53v72Ev();
extern void _ZN6S707C43v73Ev();
extern void _ZN6S707C43v74Ev();
extern void _ZN6S707C43v75Ev();
extern void _ZN6S707C43v76Ev();
extern void _ZN6S707C43v77Ev();
extern void _ZN6S707C43v78Ev();
extern void _ZN6S707C43v79Ev();
extern void _ZN6S707C43v80Ev();
extern void _ZN6S707C43v81Ev();
extern void _ZN6S707C43v82Ev();
extern void _ZN6S707C43v83Ev();
extern void _ZN6S707C43v84Ev();
extern void _ZN6S707C43v85Ev();
extern void _ZN6S707C43v86Ev();
extern void _ZN6S707C43v87Ev();
extern void _ZN6S707C43v88Ev();
extern void _ZN6S707C43v89Ev();
extern void _ZN6S707C43v90Ev();
extern void _ZN6S707C43v91Ev();
extern void _ZN6S707C43v92Ev();
extern void _ZN6S707C43v93Ev();
extern void _ZN6S707C43v94Ev();
extern void _ZN6S707C33v95Ev();
extern void _ZN6S707C33v96Ev();
extern void _ZN6S707C33v97Ev();
extern void _ZN6S707C33v98Ev();
extern void _ZN6S707C33v99Ev();
extern void _ZN6S707C34v100Ev();
extern void _ZN6S707C34v101Ev();
extern void _ZN6S707C34v102Ev();
extern void _ZN6S707C34v103Ev();
extern void _ZN6S707C34v104Ev();
extern void _ZN6S707C34v105Ev();
extern void _ZN6S707C34v106Ev();
extern void _ZN6S707C34v107Ev();
extern void _ZN6S707C34v108Ev();
extern void _ZN6S707C34v109Ev();
extern void _ZN6S707C34v110Ev();
extern void _ZN6S707C34v111Ev();
extern void _ZN6S707C34v112Ev();
extern void _ZN6S707C34v113Ev();
static  VTBL_ENTRY vtc_S707C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S707C3[0]),
  (VTBL_ENTRY)&_ZN6S707C3D1Ev,
  (VTBL_ENTRY)&_ZN6S707C3D0Ev,
  (VTBL_ENTRY)&_ZN6S707C52v9Ev,
  (VTBL_ENTRY)&_ZN6S707C53v10Ev,
  (VTBL_ENTRY)&_ZN6S707C53v11Ev,
  (VTBL_ENTRY)&_ZN6S707C53v12Ev,
  (VTBL_ENTRY)&_ZN6S707C53v13Ev,
  (VTBL_ENTRY)&_ZN6S707C53v14Ev,
  (VTBL_ENTRY)&_ZN6S707C53v15Ev,
  (VTBL_ENTRY)&_ZN6S707C53v16Ev,
  (VTBL_ENTRY)&_ZN6S707C53v17Ev,
  (VTBL_ENTRY)&_ZN6S707C53v18Ev,
  (VTBL_ENTRY)&_ZN6S707C53v19Ev,
  (VTBL_ENTRY)&_ZN6S707C53v20Ev,
  (VTBL_ENTRY)&_ZN6S707C53v21Ev,
  (VTBL_ENTRY)&_ZN6S707C53v22Ev,
  (VTBL_ENTRY)&_ZN6S707C53v23Ev,
  (VTBL_ENTRY)&_ZN6S707C53v24Ev,
  (VTBL_ENTRY)&_ZN6S707C53v25Ev,
  (VTBL_ENTRY)&_ZN6S707C53v26Ev,
  (VTBL_ENTRY)&_ZN6S707C53v27Ev,
  (VTBL_ENTRY)&_ZN6S707C53v28Ev,
  (VTBL_ENTRY)&_ZN6S707C53v29Ev,
  (VTBL_ENTRY)&_ZN6S707C53v30Ev,
  (VTBL_ENTRY)&_ZN6S707C53v31Ev,
  (VTBL_ENTRY)&_ZN6S707C53v32Ev,
  (VTBL_ENTRY)&_ZN6S707C53v33Ev,
  (VTBL_ENTRY)&_ZN6S707C53v34Ev,
  (VTBL_ENTRY)&_ZN6S707C53v35Ev,
  (VTBL_ENTRY)&_ZN6S707C53v36Ev,
  (VTBL_ENTRY)&_ZN6S707C53v37Ev,
  (VTBL_ENTRY)&_ZN6S707C53v38Ev,
  (VTBL_ENTRY)&_ZN6S707C53v39Ev,
  (VTBL_ENTRY)&_ZN6S707C53v40Ev,
  (VTBL_ENTRY)&_ZN6S707C53v41Ev,
  (VTBL_ENTRY)&_ZN6S707C53v42Ev,
  (VTBL_ENTRY)&_ZN6S707C53v43Ev,
  (VTBL_ENTRY)&_ZN6S707C53v44Ev,
  (VTBL_ENTRY)&_ZN6S707C53v45Ev,
  (VTBL_ENTRY)&_ZN6S707C53v46Ev,
  (VTBL_ENTRY)&_ZN6S707C53v47Ev,
  (VTBL_ENTRY)&_ZN6S707C53v48Ev,
  (VTBL_ENTRY)&_ZN6S707C53v49Ev,
  (VTBL_ENTRY)&_ZN6S707C53v50Ev,
  (VTBL_ENTRY)&_ZN6S707C53v51Ev,
  (VTBL_ENTRY)&_ZN6S707C53v52Ev,
  (VTBL_ENTRY)&_ZN6S707C53v53Ev,
  (VTBL_ENTRY)&_ZN6S707C53v54Ev,
  (VTBL_ENTRY)&_ZN6S707C53v55Ev,
  (VTBL_ENTRY)&_ZN6S707C53v56Ev,
  (VTBL_ENTRY)&_ZN6S707C53v57Ev,
  (VTBL_ENTRY)&_ZN6S707C53v58Ev,
  (VTBL_ENTRY)&_ZN6S707C53v59Ev,
  (VTBL_ENTRY)&_ZN6S707C53v60Ev,
  (VTBL_ENTRY)&_ZN6S707C53v61Ev,
  (VTBL_ENTRY)&_ZN6S707C53v62Ev,
  (VTBL_ENTRY)&_ZN6S707C53v63Ev,
  (VTBL_ENTRY)&_ZN6S707C53v64Ev,
  (VTBL_ENTRY)&_ZN6S707C53v65Ev,
  (VTBL_ENTRY)&_ZN6S707C53v66Ev,
  (VTBL_ENTRY)&_ZN6S707C53v67Ev,
  (VTBL_ENTRY)&_ZN6S707C53v68Ev,
  (VTBL_ENTRY)&_ZN6S707C53v69Ev,
  (VTBL_ENTRY)&_ZN6S707C53v70Ev,
  (VTBL_ENTRY)&_ZN6S707C53v71Ev,
  (VTBL_ENTRY)&_ZN6S707C53v72Ev,
  (VTBL_ENTRY)&_ZN6S707C43v73Ev,
  (VTBL_ENTRY)&_ZN6S707C43v74Ev,
  (VTBL_ENTRY)&_ZN6S707C43v75Ev,
  (VTBL_ENTRY)&_ZN6S707C43v76Ev,
  (VTBL_ENTRY)&_ZN6S707C43v77Ev,
  (VTBL_ENTRY)&_ZN6S707C43v78Ev,
  (VTBL_ENTRY)&_ZN6S707C43v79Ev,
  (VTBL_ENTRY)&_ZN6S707C43v80Ev,
  (VTBL_ENTRY)&_ZN6S707C43v81Ev,
  (VTBL_ENTRY)&_ZN6S707C43v82Ev,
  (VTBL_ENTRY)&_ZN6S707C43v83Ev,
  (VTBL_ENTRY)&_ZN6S707C43v84Ev,
  (VTBL_ENTRY)&_ZN6S707C43v85Ev,
  (VTBL_ENTRY)&_ZN6S707C43v86Ev,
  (VTBL_ENTRY)&_ZN6S707C43v87Ev,
  (VTBL_ENTRY)&_ZN6S707C43v88Ev,
  (VTBL_ENTRY)&_ZN6S707C43v89Ev,
  (VTBL_ENTRY)&_ZN6S707C43v90Ev,
  (VTBL_ENTRY)&_ZN6S707C43v91Ev,
  (VTBL_ENTRY)&_ZN6S707C43v92Ev,
  (VTBL_ENTRY)&_ZN6S707C43v93Ev,
  (VTBL_ENTRY)&_ZN6S707C43v94Ev,
  (VTBL_ENTRY)&_ZN6S707C33v95Ev,
  (VTBL_ENTRY)&_ZN6S707C33v96Ev,
  (VTBL_ENTRY)&_ZN6S707C33v97Ev,
  (VTBL_ENTRY)&_ZN6S707C33v98Ev,
  (VTBL_ENTRY)&_ZN6S707C33v99Ev,
  (VTBL_ENTRY)&_ZN6S707C34v100Ev,
  (VTBL_ENTRY)&_ZN6S707C34v101Ev,
  (VTBL_ENTRY)&_ZN6S707C34v102Ev,
  (VTBL_ENTRY)&_ZN6S707C34v103Ev,
  (VTBL_ENTRY)&_ZN6S707C34v104Ev,
  (VTBL_ENTRY)&_ZN6S707C34v105Ev,
  (VTBL_ENTRY)&_ZN6S707C34v106Ev,
  (VTBL_ENTRY)&_ZN6S707C34v107Ev,
  (VTBL_ENTRY)&_ZN6S707C34v108Ev,
  (VTBL_ENTRY)&_ZN6S707C34v109Ev,
  (VTBL_ENTRY)&_ZN6S707C34v110Ev,
  (VTBL_ENTRY)&_ZN6S707C34v111Ev,
  (VTBL_ENTRY)&_ZN6S707C34v112Ev,
  (VTBL_ENTRY)&_ZN6S707C34v113Ev,
};
extern VTBL_ENTRY _ZTI6S707C3[];
extern  VTBL_ENTRY _ZTV6S707C3[];
Class_Descriptor cd_S707C3 = {  "S707C3", // class name
  bases_S707C3, 2,
  &(vtc_S707C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S707C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S707C3),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S707C2  : S707C3 {
  void *s707c2f0;
  virtual  ~S707C2(); // _ZN6S707C2D1Ev
  virtual void  v114(); // _ZN6S707C24v114Ev
  virtual void  v115(); // _ZN6S707C24v115Ev
  virtual void  v116(); // _ZN6S707C24v116Ev
  virtual void  v117(); // _ZN6S707C24v117Ev
  virtual void  v118(); // _ZN6S707C24v118Ev
  virtual void  v119(); // _ZN6S707C24v119Ev
  virtual void  v120(); // _ZN6S707C24v120Ev
  virtual void  v121(); // _ZN6S707C24v121Ev
  virtual void  v122(); // _ZN6S707C24v122Ev
  S707C2(); // tgen
};
//SIG(-1 S707C2) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 FC5} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp}


 S707C2 ::~S707C2(){ note_dtor("S707C2", this);}
void  S707C2 ::v114(){vfunc_called(this, "_ZN6S707C24v114Ev");}
void  S707C2 ::v115(){vfunc_called(this, "_ZN6S707C24v115Ev");}
void  S707C2 ::v116(){vfunc_called(this, "_ZN6S707C24v116Ev");}
void  S707C2 ::v117(){vfunc_called(this, "_ZN6S707C24v117Ev");}
void  S707C2 ::v118(){vfunc_called(this, "_ZN6S707C24v118Ev");}
void  S707C2 ::v119(){vfunc_called(this, "_ZN6S707C24v119Ev");}
void  S707C2 ::v120(){vfunc_called(this, "_ZN6S707C24v120Ev");}
void  S707C2 ::v121(){vfunc_called(this, "_ZN6S707C24v121Ev");}
void  S707C2 ::v122(){vfunc_called(this, "_ZN6S707C24v122Ev");}
S707C2 ::S707C2(){ note_ctor("S707C2", this);} // tgen

static void Test_S707C2()
{
  extern Class_Descriptor cd_S707C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,37)];
    init_test(&cd_S707C2, buf);
    S707C2 *dp, &lv = *(dp=new (buf) S707C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,144), "sizeof(S707C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S707C2)");
    check_base_class_offset(lv, (S707C5*)(S707C4*)(S707C3*), 0, "S707C2");
    check_base_class_offset(lv, (S707C4*)(S707C3*), 0, "S707C2");
    check_base_class_offset(lv, (S707C3*), 0, "S707C2");
    check_field_offset(lv, s707c2f0, ABISELECT(200,140), "S707C2.s707c2f0");
    test_class_info(&lv, &cd_S707C2);
    dp->~S707C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS707C2(Test_S707C2, "S707C2", ABISELECT(208,144));

#else // __cplusplus

extern void _ZN6S707C2C1Ev();
extern void _ZN6S707C2D1Ev();
Name_Map name_map_S707C2[] = {
  NSPAIR(_ZN6S707C2C1Ev),
  NSPAIR(_ZN6S707C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S707C5;
extern VTBL_ENTRY _ZTI6S707C5[];
extern  VTBL_ENTRY _ZTV6S707C5[];
extern Class_Descriptor cd_S707C4;
extern VTBL_ENTRY _ZTI6S707C4[];
extern  VTBL_ENTRY _ZTV6S707C4[];
extern Class_Descriptor cd_S707C3;
extern VTBL_ENTRY _ZTI6S707C3[];
extern  VTBL_ENTRY _ZTV6S707C3[];
static Base_Class bases_S707C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S707C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S707C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S707C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S707C2[];
extern void _ZN6S707C2D1Ev();
extern void _ZN6S707C2D0Ev();
extern void _ZN6S707C52v9Ev();
extern void _ZN6S707C53v10Ev();
extern void _ZN6S707C53v11Ev();
extern void _ZN6S707C53v12Ev();
extern void _ZN6S707C53v13Ev();
extern void _ZN6S707C53v14Ev();
extern void _ZN6S707C53v15Ev();
extern void _ZN6S707C53v16Ev();
extern void _ZN6S707C53v17Ev();
extern void _ZN6S707C53v18Ev();
extern void _ZN6S707C53v19Ev();
extern void _ZN6S707C53v20Ev();
extern void _ZN6S707C53v21Ev();
extern void _ZN6S707C53v22Ev();
extern void _ZN6S707C53v23Ev();
extern void _ZN6S707C53v24Ev();
extern void _ZN6S707C53v25Ev();
extern void _ZN6S707C53v26Ev();
extern void _ZN6S707C53v27Ev();
extern void _ZN6S707C53v28Ev();
extern void _ZN6S707C53v29Ev();
extern void _ZN6S707C53v30Ev();
extern void _ZN6S707C53v31Ev();
extern void _ZN6S707C53v32Ev();
extern void _ZN6S707C53v33Ev();
extern void _ZN6S707C53v34Ev();
extern void _ZN6S707C53v35Ev();
extern void _ZN6S707C53v36Ev();
extern void _ZN6S707C53v37Ev();
extern void _ZN6S707C53v38Ev();
extern void _ZN6S707C53v39Ev();
extern void _ZN6S707C53v40Ev();
extern void _ZN6S707C53v41Ev();
extern void _ZN6S707C53v42Ev();
extern void _ZN6S707C53v43Ev();
extern void _ZN6S707C53v44Ev();
extern void _ZN6S707C53v45Ev();
extern void _ZN6S707C53v46Ev();
extern void _ZN6S707C53v47Ev();
extern void _ZN6S707C53v48Ev();
extern void _ZN6S707C53v49Ev();
extern void _ZN6S707C53v50Ev();
extern void _ZN6S707C53v51Ev();
extern void _ZN6S707C53v52Ev();
extern void _ZN6S707C53v53Ev();
extern void _ZN6S707C53v54Ev();
extern void _ZN6S707C53v55Ev();
extern void _ZN6S707C53v56Ev();
extern void _ZN6S707C53v57Ev();
extern void _ZN6S707C53v58Ev();
extern void _ZN6S707C53v59Ev();
extern void _ZN6S707C53v60Ev();
extern void _ZN6S707C53v61Ev();
extern void _ZN6S707C53v62Ev();
extern void _ZN6S707C53v63Ev();
extern void _ZN6S707C53v64Ev();
extern void _ZN6S707C53v65Ev();
extern void _ZN6S707C53v66Ev();
extern void _ZN6S707C53v67Ev();
extern void _ZN6S707C53v68Ev();
extern void _ZN6S707C53v69Ev();
extern void _ZN6S707C53v70Ev();
extern void _ZN6S707C53v71Ev();
extern void _ZN6S707C53v72Ev();
extern void _ZN6S707C43v73Ev();
extern void _ZN6S707C43v74Ev();
extern void _ZN6S707C43v75Ev();
extern void _ZN6S707C43v76Ev();
extern void _ZN6S707C43v77Ev();
extern void _ZN6S707C43v78Ev();
extern void _ZN6S707C43v79Ev();
extern void _ZN6S707C43v80Ev();
extern void _ZN6S707C43v81Ev();
extern void _ZN6S707C43v82Ev();
extern void _ZN6S707C43v83Ev();
extern void _ZN6S707C43v84Ev();
extern void _ZN6S707C43v85Ev();
extern void _ZN6S707C43v86Ev();
extern void _ZN6S707C43v87Ev();
extern void _ZN6S707C43v88Ev();
extern void _ZN6S707C43v89Ev();
extern void _ZN6S707C43v90Ev();
extern void _ZN6S707C43v91Ev();
extern void _ZN6S707C43v92Ev();
extern void _ZN6S707C43v93Ev();
extern void _ZN6S707C43v94Ev();
extern void _ZN6S707C33v95Ev();
extern void _ZN6S707C33v96Ev();
extern void _ZN6S707C33v97Ev();
extern void _ZN6S707C33v98Ev();
extern void _ZN6S707C33v99Ev();
extern void _ZN6S707C34v100Ev();
extern void _ZN6S707C34v101Ev();
extern void _ZN6S707C34v102Ev();
extern void _ZN6S707C34v103Ev();
extern void _ZN6S707C34v104Ev();
extern void _ZN6S707C34v105Ev();
extern void _ZN6S707C34v106Ev();
extern void _ZN6S707C34v107Ev();
extern void _ZN6S707C34v108Ev();
extern void _ZN6S707C34v109Ev();
extern void _ZN6S707C34v110Ev();
extern void _ZN6S707C34v111Ev();
extern void _ZN6S707C34v112Ev();
extern void _ZN6S707C34v113Ev();
extern void _ZN6S707C24v114Ev();
extern void _ZN6S707C24v115Ev();
extern void _ZN6S707C24v116Ev();
extern void _ZN6S707C24v117Ev();
extern void _ZN6S707C24v118Ev();
extern void _ZN6S707C24v119Ev();
extern void _ZN6S707C24v120Ev();
extern void _ZN6S707C24v121Ev();
extern void _ZN6S707C24v122Ev();
static  VTBL_ENTRY vtc_S707C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S707C2[0]),
  (VTBL_ENTRY)&_ZN6S707C2D1Ev,
  (VTBL_ENTRY)&_ZN6S707C2D0Ev,
  (VTBL_ENTRY)&_ZN6S707C52v9Ev,
  (VTBL_ENTRY)&_ZN6S707C53v10Ev,
  (VTBL_ENTRY)&_ZN6S707C53v11Ev,
  (VTBL_ENTRY)&_ZN6S707C53v12Ev,
  (VTBL_ENTRY)&_ZN6S707C53v13Ev,
  (VTBL_ENTRY)&_ZN6S707C53v14Ev,
  (VTBL_ENTRY)&_ZN6S707C53v15Ev,
  (VTBL_ENTRY)&_ZN6S707C53v16Ev,
  (VTBL_ENTRY)&_ZN6S707C53v17Ev,
  (VTBL_ENTRY)&_ZN6S707C53v18Ev,
  (VTBL_ENTRY)&_ZN6S707C53v19Ev,
  (VTBL_ENTRY)&_ZN6S707C53v20Ev,
  (VTBL_ENTRY)&_ZN6S707C53v21Ev,
  (VTBL_ENTRY)&_ZN6S707C53v22Ev,
  (VTBL_ENTRY)&_ZN6S707C53v23Ev,
  (VTBL_ENTRY)&_ZN6S707C53v24Ev,
  (VTBL_ENTRY)&_ZN6S707C53v25Ev,
  (VTBL_ENTRY)&_ZN6S707C53v26Ev,
  (VTBL_ENTRY)&_ZN6S707C53v27Ev,
  (VTBL_ENTRY)&_ZN6S707C53v28Ev,
  (VTBL_ENTRY)&_ZN6S707C53v29Ev,
  (VTBL_ENTRY)&_ZN6S707C53v30Ev,
  (VTBL_ENTRY)&_ZN6S707C53v31Ev,
  (VTBL_ENTRY)&_ZN6S707C53v32Ev,
  (VTBL_ENTRY)&_ZN6S707C53v33Ev,
  (VTBL_ENTRY)&_ZN6S707C53v34Ev,
  (VTBL_ENTRY)&_ZN6S707C53v35Ev,
  (VTBL_ENTRY)&_ZN6S707C53v36Ev,
  (VTBL_ENTRY)&_ZN6S707C53v37Ev,
  (VTBL_ENTRY)&_ZN6S707C53v38Ev,
  (VTBL_ENTRY)&_ZN6S707C53v39Ev,
  (VTBL_ENTRY)&_ZN6S707C53v40Ev,
  (VTBL_ENTRY)&_ZN6S707C53v41Ev,
  (VTBL_ENTRY)&_ZN6S707C53v42Ev,
  (VTBL_ENTRY)&_ZN6S707C53v43Ev,
  (VTBL_ENTRY)&_ZN6S707C53v44Ev,
  (VTBL_ENTRY)&_ZN6S707C53v45Ev,
  (VTBL_ENTRY)&_ZN6S707C53v46Ev,
  (VTBL_ENTRY)&_ZN6S707C53v47Ev,
  (VTBL_ENTRY)&_ZN6S707C53v48Ev,
  (VTBL_ENTRY)&_ZN6S707C53v49Ev,
  (VTBL_ENTRY)&_ZN6S707C53v50Ev,
  (VTBL_ENTRY)&_ZN6S707C53v51Ev,
  (VTBL_ENTRY)&_ZN6S707C53v52Ev,
  (VTBL_ENTRY)&_ZN6S707C53v53Ev,
  (VTBL_ENTRY)&_ZN6S707C53v54Ev,
  (VTBL_ENTRY)&_ZN6S707C53v55Ev,
  (VTBL_ENTRY)&_ZN6S707C53v56Ev,
  (VTBL_ENTRY)&_ZN6S707C53v57Ev,
  (VTBL_ENTRY)&_ZN6S707C53v58Ev,
  (VTBL_ENTRY)&_ZN6S707C53v59Ev,
  (VTBL_ENTRY)&_ZN6S707C53v60Ev,
  (VTBL_ENTRY)&_ZN6S707C53v61Ev,
  (VTBL_ENTRY)&_ZN6S707C53v62Ev,
  (VTBL_ENTRY)&_ZN6S707C53v63Ev,
  (VTBL_ENTRY)&_ZN6S707C53v64Ev,
  (VTBL_ENTRY)&_ZN6S707C53v65Ev,
  (VTBL_ENTRY)&_ZN6S707C53v66Ev,
  (VTBL_ENTRY)&_ZN6S707C53v67Ev,
  (VTBL_ENTRY)&_ZN6S707C53v68Ev,
  (VTBL_ENTRY)&_ZN6S707C53v69Ev,
  (VTBL_ENTRY)&_ZN6S707C53v70Ev,
  (VTBL_ENTRY)&_ZN6S707C53v71Ev,
  (VTBL_ENTRY)&_ZN6S707C53v72Ev,
  (VTBL_ENTRY)&_ZN6S707C43v73Ev,
  (VTBL_ENTRY)&_ZN6S707C43v74Ev,
  (VTBL_ENTRY)&_ZN6S707C43v75Ev,
  (VTBL_ENTRY)&_ZN6S707C43v76Ev,
  (VTBL_ENTRY)&_ZN6S707C43v77Ev,
  (VTBL_ENTRY)&_ZN6S707C43v78Ev,
  (VTBL_ENTRY)&_ZN6S707C43v79Ev,
  (VTBL_ENTRY)&_ZN6S707C43v80Ev,
  (VTBL_ENTRY)&_ZN6S707C43v81Ev,
  (VTBL_ENTRY)&_ZN6S707C43v82Ev,
  (VTBL_ENTRY)&_ZN6S707C43v83Ev,
  (VTBL_ENTRY)&_ZN6S707C43v84Ev,
  (VTBL_ENTRY)&_ZN6S707C43v85Ev,
  (VTBL_ENTRY)&_ZN6S707C43v86Ev,
  (VTBL_ENTRY)&_ZN6S707C43v87Ev,
  (VTBL_ENTRY)&_ZN6S707C43v88Ev,
  (VTBL_ENTRY)&_ZN6S707C43v89Ev,
  (VTBL_ENTRY)&_ZN6S707C43v90Ev,
  (VTBL_ENTRY)&_ZN6S707C43v91Ev,
  (VTBL_ENTRY)&_ZN6S707C43v92Ev,
  (VTBL_ENTRY)&_ZN6S707C43v93Ev,
  (VTBL_ENTRY)&_ZN6S707C43v94Ev,
  (VTBL_ENTRY)&_ZN6S707C33v95Ev,
  (VTBL_ENTRY)&_ZN6S707C33v96Ev,
  (VTBL_ENTRY)&_ZN6S707C33v97Ev,
  (VTBL_ENTRY)&_ZN6S707C33v98Ev,
  (VTBL_ENTRY)&_ZN6S707C33v99Ev,
  (VTBL_ENTRY)&_ZN6S707C34v100Ev,
  (VTBL_ENTRY)&_ZN6S707C34v101Ev,
  (VTBL_ENTRY)&_ZN6S707C34v102Ev,
  (VTBL_ENTRY)&_ZN6S707C34v103Ev,
  (VTBL_ENTRY)&_ZN6S707C34v104Ev,
  (VTBL_ENTRY)&_ZN6S707C34v105Ev,
  (VTBL_ENTRY)&_ZN6S707C34v106Ev,
  (VTBL_ENTRY)&_ZN6S707C34v107Ev,
  (VTBL_ENTRY)&_ZN6S707C34v108Ev,
  (VTBL_ENTRY)&_ZN6S707C34v109Ev,
  (VTBL_ENTRY)&_ZN6S707C34v110Ev,
  (VTBL_ENTRY)&_ZN6S707C34v111Ev,
  (VTBL_ENTRY)&_ZN6S707C34v112Ev,
  (VTBL_ENTRY)&_ZN6S707C34v113Ev,
  (VTBL_ENTRY)&_ZN6S707C24v114Ev,
  (VTBL_ENTRY)&_ZN6S707C24v115Ev,
  (VTBL_ENTRY)&_ZN6S707C24v116Ev,
  (VTBL_ENTRY)&_ZN6S707C24v117Ev,
  (VTBL_ENTRY)&_ZN6S707C24v118Ev,
  (VTBL_ENTRY)&_ZN6S707C24v119Ev,
  (VTBL_ENTRY)&_ZN6S707C24v120Ev,
  (VTBL_ENTRY)&_ZN6S707C24v121Ev,
  (VTBL_ENTRY)&_ZN6S707C24v122Ev,
};
extern VTBL_ENTRY _ZTI6S707C2[];
extern  VTBL_ENTRY _ZTV6S707C2[];
Class_Descriptor cd_S707C2 = {  "S707C2", // class name
  bases_S707C2, 3,
  &(vtc_S707C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,144), // object size
  NSPAIRA(_ZTI6S707C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S707C2),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S707C1  : S707C2 {
  ::S672C14_nt s707c1f0;
  virtual  ~S707C1(); // _ZN6S707C1D1Ev
  virtual void  v1(); // _ZN6S707C12v1Ev
  virtual void  v2(); // _ZN6S707C12v2Ev
  virtual void  v3(); // _ZN6S707C12v3Ev
  virtual void  v4(); // _ZN6S707C12v4Ev
  virtual void  v5(); // _ZN6S707C12v5Ev
  virtual void  v6(); // _ZN6S707C12v6Ev
  virtual void  v7(); // _ZN6S707C12v7Ev
  virtual void  v8(); // _ZN6S707C12v8Ev
  S707C1(); // tgen
};
//SIG(1 S707C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 FC6} vd v114 v115 v116 v117 v118 v119 v120 v121 v122 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 FC12{ BC13{ BC10}}}


 S707C1 ::~S707C1(){ note_dtor("S707C1", this);}
void  S707C1 ::v1(){vfunc_called(this, "_ZN6S707C12v1Ev");}
void  S707C1 ::v2(){vfunc_called(this, "_ZN6S707C12v2Ev");}
void  S707C1 ::v3(){vfunc_called(this, "_ZN6S707C12v3Ev");}
void  S707C1 ::v4(){vfunc_called(this, "_ZN6S707C12v4Ev");}
void  S707C1 ::v5(){vfunc_called(this, "_ZN6S707C12v5Ev");}
void  S707C1 ::v6(){vfunc_called(this, "_ZN6S707C12v6Ev");}
void  S707C1 ::v7(){vfunc_called(this, "_ZN6S707C12v7Ev");}
void  S707C1 ::v8(){vfunc_called(this, "_ZN6S707C12v8Ev");}
S707C1 ::S707C1(){ note_ctor("S707C1", this);} // tgen

static void Test_S707C1()
{
  extern Class_Descriptor cd_S707C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,40)];
    init_test(&cd_S707C1, buf);
    S707C1 *dp, &lv = *(dp=new (buf) S707C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,156), "sizeof(S707C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S707C1)");
    check_base_class_offset(lv, (S707C5*)(S707C4*)(S707C3*)(S707C2*), 0, "S707C1");
    check_base_class_offset(lv, (S707C4*)(S707C3*)(S707C2*), 0, "S707C1");
    check_base_class_offset(lv, (S707C3*)(S707C2*), 0, "S707C1");
    check_base_class_offset(lv, (S707C2*), 0, "S707C1");
    check_field_offset(lv, s707c1f0, ABISELECT(208,144), "S707C1.s707c1f0");
    test_class_info(&lv, &cd_S707C1);
    dp->~S707C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS707C1(Test_S707C1, "S707C1", ABISELECT(224,156));

#else // __cplusplus

extern void _ZN6S707C1C1Ev();
extern void _ZN6S707C1D1Ev();
Name_Map name_map_S707C1[] = {
  NSPAIR(_ZN6S707C1C1Ev),
  NSPAIR(_ZN6S707C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S707C5;
extern VTBL_ENTRY _ZTI6S707C5[];
extern  VTBL_ENTRY _ZTV6S707C5[];
extern Class_Descriptor cd_S707C4;
extern VTBL_ENTRY _ZTI6S707C4[];
extern  VTBL_ENTRY _ZTV6S707C4[];
extern Class_Descriptor cd_S707C3;
extern VTBL_ENTRY _ZTI6S707C3[];
extern  VTBL_ENTRY _ZTV6S707C3[];
extern Class_Descriptor cd_S707C2;
extern VTBL_ENTRY _ZTI6S707C2[];
extern  VTBL_ENTRY _ZTV6S707C2[];
static Base_Class bases_S707C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S707C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S707C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S707C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S707C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S707C1[];
extern void _ZN6S707C1D1Ev();
extern void _ZN6S707C1D0Ev();
extern void _ZN6S707C52v9Ev();
extern void _ZN6S707C53v10Ev();
extern void _ZN6S707C53v11Ev();
extern void _ZN6S707C53v12Ev();
extern void _ZN6S707C53v13Ev();
extern void _ZN6S707C53v14Ev();
extern void _ZN6S707C53v15Ev();
extern void _ZN6S707C53v16Ev();
extern void _ZN6S707C53v17Ev();
extern void _ZN6S707C53v18Ev();
extern void _ZN6S707C53v19Ev();
extern void _ZN6S707C53v20Ev();
extern void _ZN6S707C53v21Ev();
extern void _ZN6S707C53v22Ev();
extern void _ZN6S707C53v23Ev();
extern void _ZN6S707C53v24Ev();
extern void _ZN6S707C53v25Ev();
extern void _ZN6S707C53v26Ev();
extern void _ZN6S707C53v27Ev();
extern void _ZN6S707C53v28Ev();
extern void _ZN6S707C53v29Ev();
extern void _ZN6S707C53v30Ev();
extern void _ZN6S707C53v31Ev();
extern void _ZN6S707C53v32Ev();
extern void _ZN6S707C53v33Ev();
extern void _ZN6S707C53v34Ev();
extern void _ZN6S707C53v35Ev();
extern void _ZN6S707C53v36Ev();
extern void _ZN6S707C53v37Ev();
extern void _ZN6S707C53v38Ev();
extern void _ZN6S707C53v39Ev();
extern void _ZN6S707C53v40Ev();
extern void _ZN6S707C53v41Ev();
extern void _ZN6S707C53v42Ev();
extern void _ZN6S707C53v43Ev();
extern void _ZN6S707C53v44Ev();
extern void _ZN6S707C53v45Ev();
extern void _ZN6S707C53v46Ev();
extern void _ZN6S707C53v47Ev();
extern void _ZN6S707C53v48Ev();
extern void _ZN6S707C53v49Ev();
extern void _ZN6S707C53v50Ev();
extern void _ZN6S707C53v51Ev();
extern void _ZN6S707C53v52Ev();
extern void _ZN6S707C53v53Ev();
extern void _ZN6S707C53v54Ev();
extern void _ZN6S707C53v55Ev();
extern void _ZN6S707C53v56Ev();
extern void _ZN6S707C53v57Ev();
extern void _ZN6S707C53v58Ev();
extern void _ZN6S707C53v59Ev();
extern void _ZN6S707C53v60Ev();
extern void _ZN6S707C53v61Ev();
extern void _ZN6S707C53v62Ev();
extern void _ZN6S707C53v63Ev();
extern void _ZN6S707C53v64Ev();
extern void _ZN6S707C53v65Ev();
extern void _ZN6S707C53v66Ev();
extern void _ZN6S707C53v67Ev();
extern void _ZN6S707C53v68Ev();
extern void _ZN6S707C53v69Ev();
extern void _ZN6S707C53v70Ev();
extern void _ZN6S707C53v71Ev();
extern void _ZN6S707C53v72Ev();
extern void _ZN6S707C43v73Ev();
extern void _ZN6S707C43v74Ev();
extern void _ZN6S707C43v75Ev();
extern void _ZN6S707C43v76Ev();
extern void _ZN6S707C43v77Ev();
extern void _ZN6S707C43v78Ev();
extern void _ZN6S707C43v79Ev();
extern void _ZN6S707C43v80Ev();
extern void _ZN6S707C43v81Ev();
extern void _ZN6S707C43v82Ev();
extern void _ZN6S707C43v83Ev();
extern void _ZN6S707C43v84Ev();
extern void _ZN6S707C43v85Ev();
extern void _ZN6S707C43v86Ev();
extern void _ZN6S707C43v87Ev();
extern void _ZN6S707C43v88Ev();
extern void _ZN6S707C43v89Ev();
extern void _ZN6S707C43v90Ev();
extern void _ZN6S707C43v91Ev();
extern void _ZN6S707C43v92Ev();
extern void _ZN6S707C43v93Ev();
extern void _ZN6S707C43v94Ev();
extern void _ZN6S707C33v95Ev();
extern void _ZN6S707C33v96Ev();
extern void _ZN6S707C33v97Ev();
extern void _ZN6S707C33v98Ev();
extern void _ZN6S707C33v99Ev();
extern void _ZN6S707C34v100Ev();
extern void _ZN6S707C34v101Ev();
extern void _ZN6S707C34v102Ev();
extern void _ZN6S707C34v103Ev();
extern void _ZN6S707C34v104Ev();
extern void _ZN6S707C34v105Ev();
extern void _ZN6S707C34v106Ev();
extern void _ZN6S707C34v107Ev();
extern void _ZN6S707C34v108Ev();
extern void _ZN6S707C34v109Ev();
extern void _ZN6S707C34v110Ev();
extern void _ZN6S707C34v111Ev();
extern void _ZN6S707C34v112Ev();
extern void _ZN6S707C34v113Ev();
extern void _ZN6S707C24v114Ev();
extern void _ZN6S707C24v115Ev();
extern void _ZN6S707C24v116Ev();
extern void _ZN6S707C24v117Ev();
extern void _ZN6S707C24v118Ev();
extern void _ZN6S707C24v119Ev();
extern void _ZN6S707C24v120Ev();
extern void _ZN6S707C24v121Ev();
extern void _ZN6S707C24v122Ev();
extern void _ZN6S707C12v1Ev();
extern void _ZN6S707C12v2Ev();
extern void _ZN6S707C12v3Ev();
extern void _ZN6S707C12v4Ev();
extern void _ZN6S707C12v5Ev();
extern void _ZN6S707C12v6Ev();
extern void _ZN6S707C12v7Ev();
extern void _ZN6S707C12v8Ev();
static  VTBL_ENTRY vtc_S707C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S707C1[0]),
  (VTBL_ENTRY)&_ZN6S707C1D1Ev,
  (VTBL_ENTRY)&_ZN6S707C1D0Ev,
  (VTBL_ENTRY)&_ZN6S707C52v9Ev,
  (VTBL_ENTRY)&_ZN6S707C53v10Ev,
  (VTBL_ENTRY)&_ZN6S707C53v11Ev,
  (VTBL_ENTRY)&_ZN6S707C53v12Ev,
  (VTBL_ENTRY)&_ZN6S707C53v13Ev,
  (VTBL_ENTRY)&_ZN6S707C53v14Ev,
  (VTBL_ENTRY)&_ZN6S707C53v15Ev,
  (VTBL_ENTRY)&_ZN6S707C53v16Ev,
  (VTBL_ENTRY)&_ZN6S707C53v17Ev,
  (VTBL_ENTRY)&_ZN6S707C53v18Ev,
  (VTBL_ENTRY)&_ZN6S707C53v19Ev,
  (VTBL_ENTRY)&_ZN6S707C53v20Ev,
  (VTBL_ENTRY)&_ZN6S707C53v21Ev,
  (VTBL_ENTRY)&_ZN6S707C53v22Ev,
  (VTBL_ENTRY)&_ZN6S707C53v23Ev,
  (VTBL_ENTRY)&_ZN6S707C53v24Ev,
  (VTBL_ENTRY)&_ZN6S707C53v25Ev,
  (VTBL_ENTRY)&_ZN6S707C53v26Ev,
  (VTBL_ENTRY)&_ZN6S707C53v27Ev,
  (VTBL_ENTRY)&_ZN6S707C53v28Ev,
  (VTBL_ENTRY)&_ZN6S707C53v29Ev,
  (VTBL_ENTRY)&_ZN6S707C53v30Ev,
  (VTBL_ENTRY)&_ZN6S707C53v31Ev,
  (VTBL_ENTRY)&_ZN6S707C53v32Ev,
  (VTBL_ENTRY)&_ZN6S707C53v33Ev,
  (VTBL_ENTRY)&_ZN6S707C53v34Ev,
  (VTBL_ENTRY)&_ZN6S707C53v35Ev,
  (VTBL_ENTRY)&_ZN6S707C53v36Ev,
  (VTBL_ENTRY)&_ZN6S707C53v37Ev,
  (VTBL_ENTRY)&_ZN6S707C53v38Ev,
  (VTBL_ENTRY)&_ZN6S707C53v39Ev,
  (VTBL_ENTRY)&_ZN6S707C53v40Ev,
  (VTBL_ENTRY)&_ZN6S707C53v41Ev,
  (VTBL_ENTRY)&_ZN6S707C53v42Ev,
  (VTBL_ENTRY)&_ZN6S707C53v43Ev,
  (VTBL_ENTRY)&_ZN6S707C53v44Ev,
  (VTBL_ENTRY)&_ZN6S707C53v45Ev,
  (VTBL_ENTRY)&_ZN6S707C53v46Ev,
  (VTBL_ENTRY)&_ZN6S707C53v47Ev,
  (VTBL_ENTRY)&_ZN6S707C53v48Ev,
  (VTBL_ENTRY)&_ZN6S707C53v49Ev,
  (VTBL_ENTRY)&_ZN6S707C53v50Ev,
  (VTBL_ENTRY)&_ZN6S707C53v51Ev,
  (VTBL_ENTRY)&_ZN6S707C53v52Ev,
  (VTBL_ENTRY)&_ZN6S707C53v53Ev,
  (VTBL_ENTRY)&_ZN6S707C53v54Ev,
  (VTBL_ENTRY)&_ZN6S707C53v55Ev,
  (VTBL_ENTRY)&_ZN6S707C53v56Ev,
  (VTBL_ENTRY)&_ZN6S707C53v57Ev,
  (VTBL_ENTRY)&_ZN6S707C53v58Ev,
  (VTBL_ENTRY)&_ZN6S707C53v59Ev,
  (VTBL_ENTRY)&_ZN6S707C53v60Ev,
  (VTBL_ENTRY)&_ZN6S707C53v61Ev,
  (VTBL_ENTRY)&_ZN6S707C53v62Ev,
  (VTBL_ENTRY)&_ZN6S707C53v63Ev,
  (VTBL_ENTRY)&_ZN6S707C53v64Ev,
  (VTBL_ENTRY)&_ZN6S707C53v65Ev,
  (VTBL_ENTRY)&_ZN6S707C53v66Ev,
  (VTBL_ENTRY)&_ZN6S707C53v67Ev,
  (VTBL_ENTRY)&_ZN6S707C53v68Ev,
  (VTBL_ENTRY)&_ZN6S707C53v69Ev,
  (VTBL_ENTRY)&_ZN6S707C53v70Ev,
  (VTBL_ENTRY)&_ZN6S707C53v71Ev,
  (VTBL_ENTRY)&_ZN6S707C53v72Ev,
  (VTBL_ENTRY)&_ZN6S707C43v73Ev,
  (VTBL_ENTRY)&_ZN6S707C43v74Ev,
  (VTBL_ENTRY)&_ZN6S707C43v75Ev,
  (VTBL_ENTRY)&_ZN6S707C43v76Ev,
  (VTBL_ENTRY)&_ZN6S707C43v77Ev,
  (VTBL_ENTRY)&_ZN6S707C43v78Ev,
  (VTBL_ENTRY)&_ZN6S707C43v79Ev,
  (VTBL_ENTRY)&_ZN6S707C43v80Ev,
  (VTBL_ENTRY)&_ZN6S707C43v81Ev,
  (VTBL_ENTRY)&_ZN6S707C43v82Ev,
  (VTBL_ENTRY)&_ZN6S707C43v83Ev,
  (VTBL_ENTRY)&_ZN6S707C43v84Ev,
  (VTBL_ENTRY)&_ZN6S707C43v85Ev,
  (VTBL_ENTRY)&_ZN6S707C43v86Ev,
  (VTBL_ENTRY)&_ZN6S707C43v87Ev,
  (VTBL_ENTRY)&_ZN6S707C43v88Ev,
  (VTBL_ENTRY)&_ZN6S707C43v89Ev,
  (VTBL_ENTRY)&_ZN6S707C43v90Ev,
  (VTBL_ENTRY)&_ZN6S707C43v91Ev,
  (VTBL_ENTRY)&_ZN6S707C43v92Ev,
  (VTBL_ENTRY)&_ZN6S707C43v93Ev,
  (VTBL_ENTRY)&_ZN6S707C43v94Ev,
  (VTBL_ENTRY)&_ZN6S707C33v95Ev,
  (VTBL_ENTRY)&_ZN6S707C33v96Ev,
  (VTBL_ENTRY)&_ZN6S707C33v97Ev,
  (VTBL_ENTRY)&_ZN6S707C33v98Ev,
  (VTBL_ENTRY)&_ZN6S707C33v99Ev,
  (VTBL_ENTRY)&_ZN6S707C34v100Ev,
  (VTBL_ENTRY)&_ZN6S707C34v101Ev,
  (VTBL_ENTRY)&_ZN6S707C34v102Ev,
  (VTBL_ENTRY)&_ZN6S707C34v103Ev,
  (VTBL_ENTRY)&_ZN6S707C34v104Ev,
  (VTBL_ENTRY)&_ZN6S707C34v105Ev,
  (VTBL_ENTRY)&_ZN6S707C34v106Ev,
  (VTBL_ENTRY)&_ZN6S707C34v107Ev,
  (VTBL_ENTRY)&_ZN6S707C34v108Ev,
  (VTBL_ENTRY)&_ZN6S707C34v109Ev,
  (VTBL_ENTRY)&_ZN6S707C34v110Ev,
  (VTBL_ENTRY)&_ZN6S707C34v111Ev,
  (VTBL_ENTRY)&_ZN6S707C34v112Ev,
  (VTBL_ENTRY)&_ZN6S707C34v113Ev,
  (VTBL_ENTRY)&_ZN6S707C24v114Ev,
  (VTBL_ENTRY)&_ZN6S707C24v115Ev,
  (VTBL_ENTRY)&_ZN6S707C24v116Ev,
  (VTBL_ENTRY)&_ZN6S707C24v117Ev,
  (VTBL_ENTRY)&_ZN6S707C24v118Ev,
  (VTBL_ENTRY)&_ZN6S707C24v119Ev,
  (VTBL_ENTRY)&_ZN6S707C24v120Ev,
  (VTBL_ENTRY)&_ZN6S707C24v121Ev,
  (VTBL_ENTRY)&_ZN6S707C24v122Ev,
  (VTBL_ENTRY)&_ZN6S707C12v1Ev,
  (VTBL_ENTRY)&_ZN6S707C12v2Ev,
  (VTBL_ENTRY)&_ZN6S707C12v3Ev,
  (VTBL_ENTRY)&_ZN6S707C12v4Ev,
  (VTBL_ENTRY)&_ZN6S707C12v5Ev,
  (VTBL_ENTRY)&_ZN6S707C12v6Ev,
  (VTBL_ENTRY)&_ZN6S707C12v7Ev,
  (VTBL_ENTRY)&_ZN6S707C12v8Ev,
};
extern VTBL_ENTRY _ZTI6S707C1[];
extern  VTBL_ENTRY _ZTV6S707C1[];
Class_Descriptor cd_S707C1 = {  "S707C1", // class name
  bases_S707C1, 4,
  &(vtc_S707C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,156), // object size
  NSPAIRA(_ZTI6S707C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S707C1),126, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S671C5  {
  int s671c5f0;
  __tsi64 s671c5f1;
  void *s671c5f2[4];
  int s671c5f3[2];
  void *s671c5f4;
  ::S473C6_nt s671c5f5;
  void *s671c5f6[2];
  virtual  ~S671C5(); // _ZN6S671C5D1Ev
  virtual void  v6(); // _ZN6S671C52v6Ev
  virtual void  v7(); // _ZN6S671C52v7Ev
  virtual void  v8(); // _ZN6S671C52v8Ev
  virtual void  v9(); // _ZN6S671C52v9Ev
  virtual void  v10(); // _ZN6S671C53v10Ev
  virtual void  v11(); // _ZN6S671C53v11Ev
  virtual void  v12(); // _ZN6S671C53v12Ev
  virtual void  v13(); // _ZN6S671C53v13Ev
  virtual void  v14(); // _ZN6S671C53v14Ev
  virtual void  v15(); // _ZN6S671C53v15Ev
  virtual void  v16(); // _ZN6S671C53v16Ev
  virtual void  v17(); // _ZN6S671C53v17Ev
  virtual void  v18(); // _ZN6S671C53v18Ev
  virtual void  v19(); // _ZN6S671C53v19Ev
  virtual void  v20(); // _ZN6S671C53v20Ev
  virtual void  v21(); // _ZN6S671C53v21Ev
  virtual void  v22(); // _ZN6S671C53v22Ev
  virtual void  v23(); // _ZN6S671C53v23Ev
  virtual void  v24(); // _ZN6S671C53v24Ev
  virtual void  v25(); // _ZN6S671C53v25Ev
  virtual void  v26(); // _ZN6S671C53v26Ev
  virtual void  v27(); // _ZN6S671C53v27Ev
  virtual void  v28(); // _ZN6S671C53v28Ev
  virtual void  v29(); // _ZN6S671C53v29Ev
  virtual void  v30(); // _ZN6S671C53v30Ev
  virtual void  v31(); // _ZN6S671C53v31Ev
  virtual void  v32(); // _ZN6S671C53v32Ev
  virtual void  v33(); // _ZN6S671C53v33Ev
  virtual void  v34(); // _ZN6S671C53v34Ev
  virtual void  v35(); // _ZN6S671C53v35Ev
  virtual void  v36(); // _ZN6S671C53v36Ev
  virtual void  v37(); // _ZN6S671C53v37Ev
  virtual void  v38(); // _ZN6S671C53v38Ev
  virtual void  v39(); // _ZN6S671C53v39Ev
  virtual void  v40(); // _ZN6S671C53v40Ev
  virtual void  v41(); // _ZN6S671C53v41Ev
  virtual void  v42(); // _ZN6S671C53v42Ev
  virtual void  v43(); // _ZN6S671C53v43Ev
  virtual void  v44(); // _ZN6S671C53v44Ev
  virtual void  v45(); // _ZN6S671C53v45Ev
  virtual void  v46(); // _ZN6S671C53v46Ev
  virtual void  v47(); // _ZN6S671C53v47Ev
  virtual void  v48(); // _ZN6S671C53v48Ev
  virtual void  v49(); // _ZN6S671C53v49Ev
  virtual void  v50(); // _ZN6S671C53v50Ev
  virtual void  v51(); // _ZN6S671C53v51Ev
  virtual void  v52(); // _ZN6S671C53v52Ev
  virtual void  v53(); // _ZN6S671C53v53Ev
  virtual void  v54(); // _ZN6S671C53v54Ev
  virtual void  v55(); // _ZN6S671C53v55Ev
  virtual void  v56(); // _ZN6S671C53v56Ev
  virtual void  v57(); // _ZN6S671C53v57Ev
  virtual void  v58(); // _ZN6S671C53v58Ev
  virtual void  v59(); // _ZN6S671C53v59Ev
  virtual void  v60(); // _ZN6S671C53v60Ev
  virtual void  v61(); // _ZN6S671C53v61Ev
  virtual void  v62(); // _ZN6S671C53v62Ev
  virtual void  v63(); // _ZN6S671C53v63Ev
  virtual void  v64(); // _ZN6S671C53v64Ev
  virtual void  v65(); // _ZN6S671C53v65Ev
  virtual void  v66(); // _ZN6S671C53v66Ev
  virtual void  v67(); // _ZN6S671C53v67Ev
  virtual void  v68(); // _ZN6S671C53v68Ev
  virtual void  v69(); // _ZN6S671C53v69Ev
  S671C5(); // tgen
};
//SIG(-1 S671C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S671C5 ::~S671C5(){ note_dtor("S671C5", this);}
void  S671C5 ::v6(){vfunc_called(this, "_ZN6S671C52v6Ev");}
void  S671C5 ::v7(){vfunc_called(this, "_ZN6S671C52v7Ev");}
void  S671C5 ::v8(){vfunc_called(this, "_ZN6S671C52v8Ev");}
void  S671C5 ::v9(){vfunc_called(this, "_ZN6S671C52v9Ev");}
void  S671C5 ::v10(){vfunc_called(this, "_ZN6S671C53v10Ev");}
void  S671C5 ::v11(){vfunc_called(this, "_ZN6S671C53v11Ev");}
void  S671C5 ::v12(){vfunc_called(this, "_ZN6S671C53v12Ev");}
void  S671C5 ::v13(){vfunc_called(this, "_ZN6S671C53v13Ev");}
void  S671C5 ::v14(){vfunc_called(this, "_ZN6S671C53v14Ev");}
void  S671C5 ::v15(){vfunc_called(this, "_ZN6S671C53v15Ev");}
void  S671C5 ::v16(){vfunc_called(this, "_ZN6S671C53v16Ev");}
void  S671C5 ::v17(){vfunc_called(this, "_ZN6S671C53v17Ev");}
void  S671C5 ::v18(){vfunc_called(this, "_ZN6S671C53v18Ev");}
void  S671C5 ::v19(){vfunc_called(this, "_ZN6S671C53v19Ev");}
void  S671C5 ::v20(){vfunc_called(this, "_ZN6S671C53v20Ev");}
void  S671C5 ::v21(){vfunc_called(this, "_ZN6S671C53v21Ev");}
void  S671C5 ::v22(){vfunc_called(this, "_ZN6S671C53v22Ev");}
void  S671C5 ::v23(){vfunc_called(this, "_ZN6S671C53v23Ev");}
void  S671C5 ::v24(){vfunc_called(this, "_ZN6S671C53v24Ev");}
void  S671C5 ::v25(){vfunc_called(this, "_ZN6S671C53v25Ev");}
void  S671C5 ::v26(){vfunc_called(this, "_ZN6S671C53v26Ev");}
void  S671C5 ::v27(){vfunc_called(this, "_ZN6S671C53v27Ev");}
void  S671C5 ::v28(){vfunc_called(this, "_ZN6S671C53v28Ev");}
void  S671C5 ::v29(){vfunc_called(this, "_ZN6S671C53v29Ev");}
void  S671C5 ::v30(){vfunc_called(this, "_ZN6S671C53v30Ev");}
void  S671C5 ::v31(){vfunc_called(this, "_ZN6S671C53v31Ev");}
void  S671C5 ::v32(){vfunc_called(this, "_ZN6S671C53v32Ev");}
void  S671C5 ::v33(){vfunc_called(this, "_ZN6S671C53v33Ev");}
void  S671C5 ::v34(){vfunc_called(this, "_ZN6S671C53v34Ev");}
void  S671C5 ::v35(){vfunc_called(this, "_ZN6S671C53v35Ev");}
void  S671C5 ::v36(){vfunc_called(this, "_ZN6S671C53v36Ev");}
void  S671C5 ::v37(){vfunc_called(this, "_ZN6S671C53v37Ev");}
void  S671C5 ::v38(){vfunc_called(this, "_ZN6S671C53v38Ev");}
void  S671C5 ::v39(){vfunc_called(this, "_ZN6S671C53v39Ev");}
void  S671C5 ::v40(){vfunc_called(this, "_ZN6S671C53v40Ev");}
void  S671C5 ::v41(){vfunc_called(this, "_ZN6S671C53v41Ev");}
void  S671C5 ::v42(){vfunc_called(this, "_ZN6S671C53v42Ev");}
void  S671C5 ::v43(){vfunc_called(this, "_ZN6S671C53v43Ev");}
void  S671C5 ::v44(){vfunc_called(this, "_ZN6S671C53v44Ev");}
void  S671C5 ::v45(){vfunc_called(this, "_ZN6S671C53v45Ev");}
void  S671C5 ::v46(){vfunc_called(this, "_ZN6S671C53v46Ev");}
void  S671C5 ::v47(){vfunc_called(this, "_ZN6S671C53v47Ev");}
void  S671C5 ::v48(){vfunc_called(this, "_ZN6S671C53v48Ev");}
void  S671C5 ::v49(){vfunc_called(this, "_ZN6S671C53v49Ev");}
void  S671C5 ::v50(){vfunc_called(this, "_ZN6S671C53v50Ev");}
void  S671C5 ::v51(){vfunc_called(this, "_ZN6S671C53v51Ev");}
void  S671C5 ::v52(){vfunc_called(this, "_ZN6S671C53v52Ev");}
void  S671C5 ::v53(){vfunc_called(this, "_ZN6S671C53v53Ev");}
void  S671C5 ::v54(){vfunc_called(this, "_ZN6S671C53v54Ev");}
void  S671C5 ::v55(){vfunc_called(this, "_ZN6S671C53v55Ev");}
void  S671C5 ::v56(){vfunc_called(this, "_ZN6S671C53v56Ev");}
void  S671C5 ::v57(){vfunc_called(this, "_ZN6S671C53v57Ev");}
void  S671C5 ::v58(){vfunc_called(this, "_ZN6S671C53v58Ev");}
void  S671C5 ::v59(){vfunc_called(this, "_ZN6S671C53v59Ev");}
void  S671C5 ::v60(){vfunc_called(this, "_ZN6S671C53v60Ev");}
void  S671C5 ::v61(){vfunc_called(this, "_ZN6S671C53v61Ev");}
void  S671C5 ::v62(){vfunc_called(this, "_ZN6S671C53v62Ev");}
void  S671C5 ::v63(){vfunc_called(this, "_ZN6S671C53v63Ev");}
void  S671C5 ::v64(){vfunc_called(this, "_ZN6S671C53v64Ev");}
void  S671C5 ::v65(){vfunc_called(this, "_ZN6S671C53v65Ev");}
void  S671C5 ::v66(){vfunc_called(this, "_ZN6S671C53v66Ev");}
void  S671C5 ::v67(){vfunc_called(this, "_ZN6S671C53v67Ev");}
void  S671C5 ::v68(){vfunc_called(this, "_ZN6S671C53v68Ev");}
void  S671C5 ::v69(){vfunc_called(this, "_ZN6S671C53v69Ev");}
S671C5 ::S671C5(){ note_ctor("S671C5", this);} // tgen

static void Test_S671C5()
{
  extern Class_Descriptor cd_S671C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S671C5, buf);
    S671C5 *dp, &lv = *(dp=new (buf) S671C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S671C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S671C5)");
    check_field_offset(lv, s671c5f0, ABISELECT(8,4), "S671C5.s671c5f0");
    check_field_offset(lv, s671c5f1, ABISELECT(16,8), "S671C5.s671c5f1");
    check_field_offset(lv, s671c5f2, ABISELECT(24,16), "S671C5.s671c5f2");
    check_field_offset(lv, s671c5f3, ABISELECT(56,32), "S671C5.s671c5f3");
    check_field_offset(lv, s671c5f4, ABISELECT(64,40), "S671C5.s671c5f4");
    check_field_offset(lv, s671c5f5, ABISELECT(72,44), "S671C5.s671c5f5");
    check_field_offset(lv, s671c5f6, ABISELECT(80,52), "S671C5.s671c5f6");
    test_class_info(&lv, &cd_S671C5);
    dp->~S671C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS671C5(Test_S671C5, "S671C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S671C5C1Ev();
extern void _ZN6S671C5D1Ev();
Name_Map name_map_S671C5[] = {
  NSPAIR(_ZN6S671C5C1Ev),
  NSPAIR(_ZN6S671C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S671C5[];
extern void _ZN6S671C5D1Ev();
extern void _ZN6S671C5D0Ev();
extern void _ZN6S671C52v6Ev();
extern void _ZN6S671C52v7Ev();
extern void _ZN6S671C52v8Ev();
extern void _ZN6S671C52v9Ev();
extern void _ZN6S671C53v10Ev();
extern void _ZN6S671C53v11Ev();
extern void _ZN6S671C53v12Ev();
extern void _ZN6S671C53v13Ev();
extern void _ZN6S671C53v14Ev();
extern void _ZN6S671C53v15Ev();
extern void _ZN6S671C53v16Ev();
extern void _ZN6S671C53v17Ev();
extern void _ZN6S671C53v18Ev();
extern void _ZN6S671C53v19Ev();
extern void _ZN6S671C53v20Ev();
extern void _ZN6S671C53v21Ev();
extern void _ZN6S671C53v22Ev();
extern void _ZN6S671C53v23Ev();
extern void _ZN6S671C53v24Ev();
extern void _ZN6S671C53v25Ev();
extern void _ZN6S671C53v26Ev();
extern void _ZN6S671C53v27Ev();
extern void _ZN6S671C53v28Ev();
extern void _ZN6S671C53v29Ev();
extern void _ZN6S671C53v30Ev();
extern void _ZN6S671C53v31Ev();
extern void _ZN6S671C53v32Ev();
extern void _ZN6S671C53v33Ev();
extern void _ZN6S671C53v34Ev();
extern void _ZN6S671C53v35Ev();
extern void _ZN6S671C53v36Ev();
extern void _ZN6S671C53v37Ev();
extern void _ZN6S671C53v38Ev();
extern void _ZN6S671C53v39Ev();
extern void _ZN6S671C53v40Ev();
extern void _ZN6S671C53v41Ev();
extern void _ZN6S671C53v42Ev();
extern void _ZN6S671C53v43Ev();
extern void _ZN6S671C53v44Ev();
extern void _ZN6S671C53v45Ev();
extern void _ZN6S671C53v46Ev();
extern void _ZN6S671C53v47Ev();
extern void _ZN6S671C53v48Ev();
extern void _ZN6S671C53v49Ev();
extern void _ZN6S671C53v50Ev();
extern void _ZN6S671C53v51Ev();
extern void _ZN6S671C53v52Ev();
extern void _ZN6S671C53v53Ev();
extern void _ZN6S671C53v54Ev();
extern void _ZN6S671C53v55Ev();
extern void _ZN6S671C53v56Ev();
extern void _ZN6S671C53v57Ev();
extern void _ZN6S671C53v58Ev();
extern void _ZN6S671C53v59Ev();
extern void _ZN6S671C53v60Ev();
extern void _ZN6S671C53v61Ev();
extern void _ZN6S671C53v62Ev();
extern void _ZN6S671C53v63Ev();
extern void _ZN6S671C53v64Ev();
extern void _ZN6S671C53v65Ev();
extern void _ZN6S671C53v66Ev();
extern void _ZN6S671C53v67Ev();
extern void _ZN6S671C53v68Ev();
extern void _ZN6S671C53v69Ev();
static  VTBL_ENTRY vtc_S671C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S671C5[0]),
  (VTBL_ENTRY)&_ZN6S671C5D1Ev,
  (VTBL_ENTRY)&_ZN6S671C5D0Ev,
  (VTBL_ENTRY)&_ZN6S671C52v6Ev,
  (VTBL_ENTRY)&_ZN6S671C52v7Ev,
  (VTBL_ENTRY)&_ZN6S671C52v8Ev,
  (VTBL_ENTRY)&_ZN6S671C52v9Ev,
  (VTBL_ENTRY)&_ZN6S671C53v10Ev,
  (VTBL_ENTRY)&_ZN6S671C53v11Ev,
  (VTBL_ENTRY)&_ZN6S671C53v12Ev,
  (VTBL_ENTRY)&_ZN6S671C53v13Ev,
  (VTBL_ENTRY)&_ZN6S671C53v14Ev,
  (VTBL_ENTRY)&_ZN6S671C53v15Ev,
  (VTBL_ENTRY)&_ZN6S671C53v16Ev,
  (VTBL_ENTRY)&_ZN6S671C53v17Ev,
  (VTBL_ENTRY)&_ZN6S671C53v18Ev,
  (VTBL_ENTRY)&_ZN6S671C53v19Ev,
  (VTBL_ENTRY)&_ZN6S671C53v20Ev,
  (VTBL_ENTRY)&_ZN6S671C53v21Ev,
  (VTBL_ENTRY)&_ZN6S671C53v22Ev,
  (VTBL_ENTRY)&_ZN6S671C53v23Ev,
  (VTBL_ENTRY)&_ZN6S671C53v24Ev,
  (VTBL_ENTRY)&_ZN6S671C53v25Ev,
  (VTBL_ENTRY)&_ZN6S671C53v26Ev,
  (VTBL_ENTRY)&_ZN6S671C53v27Ev,
  (VTBL_ENTRY)&_ZN6S671C53v28Ev,
  (VTBL_ENTRY)&_ZN6S671C53v29Ev,
  (VTBL_ENTRY)&_ZN6S671C53v30Ev,
  (VTBL_ENTRY)&_ZN6S671C53v31Ev,
  (VTBL_ENTRY)&_ZN6S671C53v32Ev,
  (VTBL_ENTRY)&_ZN6S671C53v33Ev,
  (VTBL_ENTRY)&_ZN6S671C53v34Ev,
  (VTBL_ENTRY)&_ZN6S671C53v35Ev,
  (VTBL_ENTRY)&_ZN6S671C53v36Ev,
  (VTBL_ENTRY)&_ZN6S671C53v37Ev,
  (VTBL_ENTRY)&_ZN6S671C53v38Ev,
  (VTBL_ENTRY)&_ZN6S671C53v39Ev,
  (VTBL_ENTRY)&_ZN6S671C53v40Ev,
  (VTBL_ENTRY)&_ZN6S671C53v41Ev,
  (VTBL_ENTRY)&_ZN6S671C53v42Ev,
  (VTBL_ENTRY)&_ZN6S671C53v43Ev,
  (VTBL_ENTRY)&_ZN6S671C53v44Ev,
  (VTBL_ENTRY)&_ZN6S671C53v45Ev,
  (VTBL_ENTRY)&_ZN6S671C53v46Ev,
  (VTBL_ENTRY)&_ZN6S671C53v47Ev,
  (VTBL_ENTRY)&_ZN6S671C53v48Ev,
  (VTBL_ENTRY)&_ZN6S671C53v49Ev,
  (VTBL_ENTRY)&_ZN6S671C53v50Ev,
  (VTBL_ENTRY)&_ZN6S671C53v51Ev,
  (VTBL_ENTRY)&_ZN6S671C53v52Ev,
  (VTBL_ENTRY)&_ZN6S671C53v53Ev,
  (VTBL_ENTRY)&_ZN6S671C53v54Ev,
  (VTBL_ENTRY)&_ZN6S671C53v55Ev,
  (VTBL_ENTRY)&_ZN6S671C53v56Ev,
  (VTBL_ENTRY)&_ZN6S671C53v57Ev,
  (VTBL_ENTRY)&_ZN6S671C53v58Ev,
  (VTBL_ENTRY)&_ZN6S671C53v59Ev,
  (VTBL_ENTRY)&_ZN6S671C53v60Ev,
  (VTBL_ENTRY)&_ZN6S671C53v61Ev,
  (VTBL_ENTRY)&_ZN6S671C53v62Ev,
  (VTBL_ENTRY)&_ZN6S671C53v63Ev,
  (VTBL_ENTRY)&_ZN6S671C53v64Ev,
  (VTBL_ENTRY)&_ZN6S671C53v65Ev,
  (VTBL_ENTRY)&_ZN6S671C53v66Ev,
  (VTBL_ENTRY)&_ZN6S671C53v67Ev,
  (VTBL_ENTRY)&_ZN6S671C53v68Ev,
  (VTBL_ENTRY)&_ZN6S671C53v69Ev,
};
extern VTBL_ENTRY _ZTI6S671C5[];
extern  VTBL_ENTRY _ZTV6S671C5[];
Class_Descriptor cd_S671C5 = {  "S671C5", // class name
  0,0,//no base classes
  &(vtc_S671C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S671C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S671C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S671C4  : S671C5 {
  int s671c4f0[2];
  void *s671c4f1;
  int s671c4f2[2];
  ::S473C7_nt s671c4f3;
  ::S473C7_nt s671c4f4;
  ::S21925C42 s671c4f5;
  ::S473C7_nt s671c4f6;
  unsigned int s671c4f7:1;
  unsigned int s671c4f8:1;
  unsigned int s671c4f9:1;
  unsigned int s671c4f10:1;
  unsigned int s671c4f11:1;
  int s671c4f12[2];
  virtual  ~S671C4(); // _ZN6S671C4D1Ev
  virtual void  v70(); // _ZN6S671C43v70Ev
  virtual void  v71(); // _ZN6S671C43v71Ev
  virtual void  v72(); // _ZN6S671C43v72Ev
  virtual void  v73(); // _ZN6S671C43v73Ev
  virtual void  v74(); // _ZN6S671C43v74Ev
  virtual void  v75(); // _ZN6S671C43v75Ev
  virtual void  v76(); // _ZN6S671C43v76Ev
  virtual void  v77(); // _ZN6S671C43v77Ev
  virtual void  v78(); // _ZN6S671C43v78Ev
  virtual void  v79(); // _ZN6S671C43v79Ev
  virtual void  v80(); // _ZN6S671C43v80Ev
  virtual void  v81(); // _ZN6S671C43v81Ev
  virtual void  v82(); // _ZN6S671C43v82Ev
  virtual void  v83(); // _ZN6S671C43v83Ev
  virtual void  v84(); // _ZN6S671C43v84Ev
  virtual void  v85(); // _ZN6S671C43v85Ev
  virtual void  v86(); // _ZN6S671C43v86Ev
  virtual void  v87(); // _ZN6S671C43v87Ev
  virtual void  v88(); // _ZN6S671C43v88Ev
  virtual void  v89(); // _ZN6S671C43v89Ev
  virtual void  v90(); // _ZN6S671C43v90Ev
  virtual void  v91(); // _ZN6S671C43v91Ev
  S671C4(); // tgen
};
//SIG(-1 S671C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S671C4 ::~S671C4(){ note_dtor("S671C4", this);}
void  S671C4 ::v70(){vfunc_called(this, "_ZN6S671C43v70Ev");}
void  S671C4 ::v71(){vfunc_called(this, "_ZN6S671C43v71Ev");}
void  S671C4 ::v72(){vfunc_called(this, "_ZN6S671C43v72Ev");}
void  S671C4 ::v73(){vfunc_called(this, "_ZN6S671C43v73Ev");}
void  S671C4 ::v74(){vfunc_called(this, "_ZN6S671C43v74Ev");}
void  S671C4 ::v75(){vfunc_called(this, "_ZN6S671C43v75Ev");}
void  S671C4 ::v76(){vfunc_called(this, "_ZN6S671C43v76Ev");}
void  S671C4 ::v77(){vfunc_called(this, "_ZN6S671C43v77Ev");}
void  S671C4 ::v78(){vfunc_called(this, "_ZN6S671C43v78Ev");}
void  S671C4 ::v79(){vfunc_called(this, "_ZN6S671C43v79Ev");}
void  S671C4 ::v80(){vfunc_called(this, "_ZN6S671C43v80Ev");}
void  S671C4 ::v81(){vfunc_called(this, "_ZN6S671C43v81Ev");}
void  S671C4 ::v82(){vfunc_called(this, "_ZN6S671C43v82Ev");}
void  S671C4 ::v83(){vfunc_called(this, "_ZN6S671C43v83Ev");}
void  S671C4 ::v84(){vfunc_called(this, "_ZN6S671C43v84Ev");}
void  S671C4 ::v85(){vfunc_called(this, "_ZN6S671C43v85Ev");}
void  S671C4 ::v86(){vfunc_called(this, "_ZN6S671C43v86Ev");}
void  S671C4 ::v87(){vfunc_called(this, "_ZN6S671C43v87Ev");}
void  S671C4 ::v88(){vfunc_called(this, "_ZN6S671C43v88Ev");}
void  S671C4 ::v89(){vfunc_called(this, "_ZN6S671C43v89Ev");}
void  S671C4 ::v90(){vfunc_called(this, "_ZN6S671C43v90Ev");}
void  S671C4 ::v91(){vfunc_called(this, "_ZN6S671C43v91Ev");}
S671C4 ::S671C4(){ note_ctor("S671C4", this);} // tgen

static void Test_S671C4()
{
  extern Class_Descriptor cd_S671C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S671C4, buf);
    S671C4 *dp, &lv = *(dp=new (buf) S671C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S671C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S671C4)");
    check_base_class_offset(lv, (S671C5*), 0, "S671C4");
    check_field_offset(lv, s671c4f0, ABISELECT(96,60), "S671C4.s671c4f0");
    check_field_offset(lv, s671c4f1, ABISELECT(104,68), "S671C4.s671c4f1");
    check_field_offset(lv, s671c4f2, ABISELECT(112,72), "S671C4.s671c4f2");
    check_field_offset(lv, s671c4f3, ABISELECT(120,80), "S671C4.s671c4f3");
    check_field_offset(lv, s671c4f4, ABISELECT(136,92), "S671C4.s671c4f4");
    check_field_offset(lv, s671c4f5, ABISELECT(152,104), "S671C4.s671c4f5");
    check_field_offset(lv, s671c4f6, ABISELECT(160,108), "S671C4.s671c4f6");
    set_bf_and_test(lv, s671c4f7, ABISELECT(176,120), 0, 1, 1, "S671C4");
    set_bf_and_test(lv, s671c4f8, ABISELECT(176,120), 1, 1, 1, "S671C4");
    set_bf_and_test(lv, s671c4f9, ABISELECT(176,120), 2, 1, 1, "S671C4");
    set_bf_and_test(lv, s671c4f10, ABISELECT(176,120), 3, 1, 1, "S671C4");
    set_bf_and_test(lv, s671c4f11, ABISELECT(176,120), 4, 1, 1, "S671C4");
    check_field_offset(lv, s671c4f12, ABISELECT(180,124), "S671C4.s671c4f12");
    test_class_info(&lv, &cd_S671C4);
    dp->~S671C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS671C4(Test_S671C4, "S671C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S671C4C1Ev();
extern void _ZN6S671C4D1Ev();
Name_Map name_map_S671C4[] = {
  NSPAIR(_ZN6S671C4C1Ev),
  NSPAIR(_ZN6S671C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S671C5;
extern VTBL_ENTRY _ZTI6S671C5[];
extern  VTBL_ENTRY _ZTV6S671C5[];
static Base_Class bases_S671C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S671C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S671C4[];
extern void _ZN6S671C4D1Ev();
extern void _ZN6S671C4D0Ev();
extern void _ZN6S671C52v6Ev();
extern void _ZN6S671C52v7Ev();
extern void _ZN6S671C52v8Ev();
extern void _ZN6S671C52v9Ev();
extern void _ZN6S671C53v10Ev();
extern void _ZN6S671C53v11Ev();
extern void _ZN6S671C53v12Ev();
extern void _ZN6S671C53v13Ev();
extern void _ZN6S671C53v14Ev();
extern void _ZN6S671C53v15Ev();
extern void _ZN6S671C53v16Ev();
extern void _ZN6S671C53v17Ev();
extern void _ZN6S671C53v18Ev();
extern void _ZN6S671C53v19Ev();
extern void _ZN6S671C53v20Ev();
extern void _ZN6S671C53v21Ev();
extern void _ZN6S671C53v22Ev();
extern void _ZN6S671C53v23Ev();
extern void _ZN6S671C53v24Ev();
extern void _ZN6S671C53v25Ev();
extern void _ZN6S671C53v26Ev();
extern void _ZN6S671C53v27Ev();
extern void _ZN6S671C53v28Ev();
extern void _ZN6S671C53v29Ev();
extern void _ZN6S671C53v30Ev();
extern void _ZN6S671C53v31Ev();
extern void _ZN6S671C53v32Ev();
extern void _ZN6S671C53v33Ev();
extern void _ZN6S671C53v34Ev();
extern void _ZN6S671C53v35Ev();
extern void _ZN6S671C53v36Ev();
extern void _ZN6S671C53v37Ev();
extern void _ZN6S671C53v38Ev();
extern void _ZN6S671C53v39Ev();
extern void _ZN6S671C53v40Ev();
extern void _ZN6S671C53v41Ev();
extern void _ZN6S671C53v42Ev();
extern void _ZN6S671C53v43Ev();
extern void _ZN6S671C53v44Ev();
extern void _ZN6S671C53v45Ev();
extern void _ZN6S671C53v46Ev();
extern void _ZN6S671C53v47Ev();
extern void _ZN6S671C53v48Ev();
extern void _ZN6S671C53v49Ev();
extern void _ZN6S671C53v50Ev();
extern void _ZN6S671C53v51Ev();
extern void _ZN6S671C53v52Ev();
extern void _ZN6S671C53v53Ev();
extern void _ZN6S671C53v54Ev();
extern void _ZN6S671C53v55Ev();
extern void _ZN6S671C53v56Ev();
extern void _ZN6S671C53v57Ev();
extern void _ZN6S671C53v58Ev();
extern void _ZN6S671C53v59Ev();
extern void _ZN6S671C53v60Ev();
extern void _ZN6S671C53v61Ev();
extern void _ZN6S671C53v62Ev();
extern void _ZN6S671C53v63Ev();
extern void _ZN6S671C53v64Ev();
extern void _ZN6S671C53v65Ev();
extern void _ZN6S671C53v66Ev();
extern void _ZN6S671C53v67Ev();
extern void _ZN6S671C53v68Ev();
extern void _ZN6S671C53v69Ev();
extern void _ZN6S671C43v70Ev();
extern void _ZN6S671C43v71Ev();
extern void _ZN6S671C43v72Ev();
extern void _ZN6S671C43v73Ev();
extern void _ZN6S671C43v74Ev();
extern void _ZN6S671C43v75Ev();
extern void _ZN6S671C43v76Ev();
extern void _ZN6S671C43v77Ev();
extern void _ZN6S671C43v78Ev();
extern void _ZN6S671C43v79Ev();
extern void _ZN6S671C43v80Ev();
extern void _ZN6S671C43v81Ev();
extern void _ZN6S671C43v82Ev();
extern void _ZN6S671C43v83Ev();
extern void _ZN6S671C43v84Ev();
extern void _ZN6S671C43v85Ev();
extern void _ZN6S671C43v86Ev();
extern void _ZN6S671C43v87Ev();
extern void _ZN6S671C43v88Ev();
extern void _ZN6S671C43v89Ev();
extern void _ZN6S671C43v90Ev();
extern void _ZN6S671C43v91Ev();
static  VTBL_ENTRY vtc_S671C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S671C4[0]),
  (VTBL_ENTRY)&_ZN6S671C4D1Ev,
  (VTBL_ENTRY)&_ZN6S671C4D0Ev,
  (VTBL_ENTRY)&_ZN6S671C52v6Ev,
  (VTBL_ENTRY)&_ZN6S671C52v7Ev,
  (VTBL_ENTRY)&_ZN6S671C52v8Ev,
  (VTBL_ENTRY)&_ZN6S671C52v9Ev,
  (VTBL_ENTRY)&_ZN6S671C53v10Ev,
  (VTBL_ENTRY)&_ZN6S671C53v11Ev,
  (VTBL_ENTRY)&_ZN6S671C53v12Ev,
  (VTBL_ENTRY)&_ZN6S671C53v13Ev,
  (VTBL_ENTRY)&_ZN6S671C53v14Ev,
  (VTBL_ENTRY)&_ZN6S671C53v15Ev,
  (VTBL_ENTRY)&_ZN6S671C53v16Ev,
  (VTBL_ENTRY)&_ZN6S671C53v17Ev,
  (VTBL_ENTRY)&_ZN6S671C53v18Ev,
  (VTBL_ENTRY)&_ZN6S671C53v19Ev,
  (VTBL_ENTRY)&_ZN6S671C53v20Ev,
  (VTBL_ENTRY)&_ZN6S671C53v21Ev,
  (VTBL_ENTRY)&_ZN6S671C53v22Ev,
  (VTBL_ENTRY)&_ZN6S671C53v23Ev,
  (VTBL_ENTRY)&_ZN6S671C53v24Ev,
  (VTBL_ENTRY)&_ZN6S671C53v25Ev,
  (VTBL_ENTRY)&_ZN6S671C53v26Ev,
  (VTBL_ENTRY)&_ZN6S671C53v27Ev,
  (VTBL_ENTRY)&_ZN6S671C53v28Ev,
  (VTBL_ENTRY)&_ZN6S671C53v29Ev,
  (VTBL_ENTRY)&_ZN6S671C53v30Ev,
  (VTBL_ENTRY)&_ZN6S671C53v31Ev,
  (VTBL_ENTRY)&_ZN6S671C53v32Ev,
  (VTBL_ENTRY)&_ZN6S671C53v33Ev,
  (VTBL_ENTRY)&_ZN6S671C53v34Ev,
  (VTBL_ENTRY)&_ZN6S671C53v35Ev,
  (VTBL_ENTRY)&_ZN6S671C53v36Ev,
  (VTBL_ENTRY)&_ZN6S671C53v37Ev,
  (VTBL_ENTRY)&_ZN6S671C53v38Ev,
  (VTBL_ENTRY)&_ZN6S671C53v39Ev,
  (VTBL_ENTRY)&_ZN6S671C53v40Ev,
  (VTBL_ENTRY)&_ZN6S671C53v41Ev,
  (VTBL_ENTRY)&_ZN6S671C53v42Ev,
  (VTBL_ENTRY)&_ZN6S671C53v43Ev,
  (VTBL_ENTRY)&_ZN6S671C53v44Ev,
  (VTBL_ENTRY)&_ZN6S671C53v45Ev,
  (VTBL_ENTRY)&_ZN6S671C53v46Ev,
  (VTBL_ENTRY)&_ZN6S671C53v47Ev,
  (VTBL_ENTRY)&_ZN6S671C53v48Ev,
  (VTBL_ENTRY)&_ZN6S671C53v49Ev,
  (VTBL_ENTRY)&_ZN6S671C53v50Ev,
  (VTBL_ENTRY)&_ZN6S671C53v51Ev,
  (VTBL_ENTRY)&_ZN6S671C53v52Ev,
  (VTBL_ENTRY)&_ZN6S671C53v53Ev,
  (VTBL_ENTRY)&_ZN6S671C53v54Ev,
  (VTBL_ENTRY)&_ZN6S671C53v55Ev,
  (VTBL_ENTRY)&_ZN6S671C53v56Ev,
  (VTBL_ENTRY)&_ZN6S671C53v57Ev,
  (VTBL_ENTRY)&_ZN6S671C53v58Ev,
  (VTBL_ENTRY)&_ZN6S671C53v59Ev,
  (VTBL_ENTRY)&_ZN6S671C53v60Ev,
  (VTBL_ENTRY)&_ZN6S671C53v61Ev,
  (VTBL_ENTRY)&_ZN6S671C53v62Ev,
  (VTBL_ENTRY)&_ZN6S671C53v63Ev,
  (VTBL_ENTRY)&_ZN6S671C53v64Ev,
  (VTBL_ENTRY)&_ZN6S671C53v65Ev,
  (VTBL_ENTRY)&_ZN6S671C53v66Ev,
  (VTBL_ENTRY)&_ZN6S671C53v67Ev,
  (VTBL_ENTRY)&_ZN6S671C53v68Ev,
  (VTBL_ENTRY)&_ZN6S671C53v69Ev,
  (VTBL_ENTRY)&_ZN6S671C43v70Ev,
  (VTBL_ENTRY)&_ZN6S671C43v71Ev,
  (VTBL_ENTRY)&_ZN6S671C43v72Ev,
  (VTBL_ENTRY)&_ZN6S671C43v73Ev,
  (VTBL_ENTRY)&_ZN6S671C43v74Ev,
  (VTBL_ENTRY)&_ZN6S671C43v75Ev,
  (VTBL_ENTRY)&_ZN6S671C43v76Ev,
  (VTBL_ENTRY)&_ZN6S671C43v77Ev,
  (VTBL_ENTRY)&_ZN6S671C43v78Ev,
  (VTBL_ENTRY)&_ZN6S671C43v79Ev,
  (VTBL_ENTRY)&_ZN6S671C43v80Ev,
  (VTBL_ENTRY)&_ZN6S671C43v81Ev,
  (VTBL_ENTRY)&_ZN6S671C43v82Ev,
  (VTBL_ENTRY)&_ZN6S671C43v83Ev,
  (VTBL_ENTRY)&_ZN6S671C43v84Ev,
  (VTBL_ENTRY)&_ZN6S671C43v85Ev,
  (VTBL_ENTRY)&_ZN6S671C43v86Ev,
  (VTBL_ENTRY)&_ZN6S671C43v87Ev,
  (VTBL_ENTRY)&_ZN6S671C43v88Ev,
  (VTBL_ENTRY)&_ZN6S671C43v89Ev,
  (VTBL_ENTRY)&_ZN6S671C43v90Ev,
  (VTBL_ENTRY)&_ZN6S671C43v91Ev,
};
extern VTBL_ENTRY _ZTI6S671C4[];
extern  VTBL_ENTRY _ZTV6S671C4[];
Class_Descriptor cd_S671C4 = {  "S671C4", // class name
  bases_S671C4, 1,
  &(vtc_S671C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S671C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S671C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S671C3  : S671C4 {
  ::S473C6_nt s671c3f0;
  virtual  ~S671C3(); // _ZN6S671C3D1Ev
  virtual void  v92(); // _ZN6S671C33v92Ev
  virtual void  v93(); // _ZN6S671C33v93Ev
  virtual void  v94(); // _ZN6S671C33v94Ev
  virtual void  v95(); // _ZN6S671C33v95Ev
  virtual void  v96(); // _ZN6S671C33v96Ev
  virtual void  v97(); // _ZN6S671C33v97Ev
  virtual void  v98(); // _ZN6S671C33v98Ev
  virtual void  v99(); // _ZN6S671C33v99Ev
  virtual void  v100(); // _ZN6S671C34v100Ev
  virtual void  v101(); // _ZN6S671C34v101Ev
  virtual void  v102(); // _ZN6S671C34v102Ev
  virtual void  v103(); // _ZN6S671C34v103Ev
  virtual void  v104(); // _ZN6S671C34v104Ev
  virtual void  v105(); // _ZN6S671C34v105Ev
  virtual void  v106(); // _ZN6S671C34v106Ev
  virtual void  v107(); // _ZN6S671C34v107Ev
  virtual void  v108(); // _ZN6S671C34v108Ev
  virtual void  v109(); // _ZN6S671C34v109Ev
  virtual void  v110(); // _ZN6S671C34v110Ev
  S671C3(); // tgen
};
//SIG(-1 S671C3) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S671C3 ::~S671C3(){ note_dtor("S671C3", this);}
void  S671C3 ::v92(){vfunc_called(this, "_ZN6S671C33v92Ev");}
void  S671C3 ::v93(){vfunc_called(this, "_ZN6S671C33v93Ev");}
void  S671C3 ::v94(){vfunc_called(this, "_ZN6S671C33v94Ev");}
void  S671C3 ::v95(){vfunc_called(this, "_ZN6S671C33v95Ev");}
void  S671C3 ::v96(){vfunc_called(this, "_ZN6S671C33v96Ev");}
void  S671C3 ::v97(){vfunc_called(this, "_ZN6S671C33v97Ev");}
void  S671C3 ::v98(){vfunc_called(this, "_ZN6S671C33v98Ev");}
void  S671C3 ::v99(){vfunc_called(this, "_ZN6S671C33v99Ev");}
void  S671C3 ::v100(){vfunc_called(this, "_ZN6S671C34v100Ev");}
void  S671C3 ::v101(){vfunc_called(this, "_ZN6S671C34v101Ev");}
void  S671C3 ::v102(){vfunc_called(this, "_ZN6S671C34v102Ev");}
void  S671C3 ::v103(){vfunc_called(this, "_ZN6S671C34v103Ev");}
void  S671C3 ::v104(){vfunc_called(this, "_ZN6S671C34v104Ev");}
void  S671C3 ::v105(){vfunc_called(this, "_ZN6S671C34v105Ev");}
void  S671C3 ::v106(){vfunc_called(this, "_ZN6S671C34v106Ev");}
void  S671C3 ::v107(){vfunc_called(this, "_ZN6S671C34v107Ev");}
void  S671C3 ::v108(){vfunc_called(this, "_ZN6S671C34v108Ev");}
void  S671C3 ::v109(){vfunc_called(this, "_ZN6S671C34v109Ev");}
void  S671C3 ::v110(){vfunc_called(this, "_ZN6S671C34v110Ev");}
S671C3 ::S671C3(){ note_ctor("S671C3", this);} // tgen

static void Test_S671C3()
{
  extern Class_Descriptor cd_S671C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S671C3, buf);
    S671C3 *dp, &lv = *(dp=new (buf) S671C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S671C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S671C3)");
    check_base_class_offset(lv, (S671C5*)(S671C4*), 0, "S671C3");
    check_base_class_offset(lv, (S671C4*), 0, "S671C3");
    check_field_offset(lv, s671c3f0, ABISELECT(188,132), "S671C3.s671c3f0");
    test_class_info(&lv, &cd_S671C3);
    dp->~S671C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS671C3(Test_S671C3, "S671C3", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S671C3C1Ev();
extern void _ZN6S671C3D1Ev();
Name_Map name_map_S671C3[] = {
  NSPAIR(_ZN6S671C3C1Ev),
  NSPAIR(_ZN6S671C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S671C5;
extern VTBL_ENTRY _ZTI6S671C5[];
extern  VTBL_ENTRY _ZTV6S671C5[];
extern Class_Descriptor cd_S671C4;
extern VTBL_ENTRY _ZTI6S671C4[];
extern  VTBL_ENTRY _ZTV6S671C4[];
static Base_Class bases_S671C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S671C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S671C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S671C3[];
extern void _ZN6S671C3D1Ev();
extern void _ZN6S671C3D0Ev();
extern void _ZN6S671C52v6Ev();
extern void _ZN6S671C52v7Ev();
extern void _ZN6S671C52v8Ev();
extern void _ZN6S671C52v9Ev();
extern void _ZN6S671C53v10Ev();
extern void _ZN6S671C53v11Ev();
extern void _ZN6S671C53v12Ev();
extern void _ZN6S671C53v13Ev();
extern void _ZN6S671C53v14Ev();
extern void _ZN6S671C53v15Ev();
extern void _ZN6S671C53v16Ev();
extern void _ZN6S671C53v17Ev();
extern void _ZN6S671C53v18Ev();
extern void _ZN6S671C53v19Ev();
extern void _ZN6S671C53v20Ev();
extern void _ZN6S671C53v21Ev();
extern void _ZN6S671C53v22Ev();
extern void _ZN6S671C53v23Ev();
extern void _ZN6S671C53v24Ev();
extern void _ZN6S671C53v25Ev();
extern void _ZN6S671C53v26Ev();
extern void _ZN6S671C53v27Ev();
extern void _ZN6S671C53v28Ev();
extern void _ZN6S671C53v29Ev();
extern void _ZN6S671C53v30Ev();
extern void _ZN6S671C53v31Ev();
extern void _ZN6S671C53v32Ev();
extern void _ZN6S671C53v33Ev();
extern void _ZN6S671C53v34Ev();
extern void _ZN6S671C53v35Ev();
extern void _ZN6S671C53v36Ev();
extern void _ZN6S671C53v37Ev();
extern void _ZN6S671C53v38Ev();
extern void _ZN6S671C53v39Ev();
extern void _ZN6S671C53v40Ev();
extern void _ZN6S671C53v41Ev();
extern void _ZN6S671C53v42Ev();
extern void _ZN6S671C53v43Ev();
extern void _ZN6S671C53v44Ev();
extern void _ZN6S671C53v45Ev();
extern void _ZN6S671C53v46Ev();
extern void _ZN6S671C53v47Ev();
extern void _ZN6S671C53v48Ev();
extern void _ZN6S671C53v49Ev();
extern void _ZN6S671C53v50Ev();
extern void _ZN6S671C53v51Ev();
extern void _ZN6S671C53v52Ev();
extern void _ZN6S671C53v53Ev();
extern void _ZN6S671C53v54Ev();
extern void _ZN6S671C53v55Ev();
extern void _ZN6S671C53v56Ev();
extern void _ZN6S671C53v57Ev();
extern void _ZN6S671C53v58Ev();
extern void _ZN6S671C53v59Ev();
extern void _ZN6S671C53v60Ev();
extern void _ZN6S671C53v61Ev();
extern void _ZN6S671C53v62Ev();
extern void _ZN6S671C53v63Ev();
extern void _ZN6S671C53v64Ev();
extern void _ZN6S671C53v65Ev();
extern void _ZN6S671C53v66Ev();
extern void _ZN6S671C53v67Ev();
extern void _ZN6S671C53v68Ev();
extern void _ZN6S671C53v69Ev();
extern void _ZN6S671C43v70Ev();
extern void _ZN6S671C43v71Ev();
extern void _ZN6S671C43v72Ev();
extern void _ZN6S671C43v73Ev();
extern void _ZN6S671C43v74Ev();
extern void _ZN6S671C43v75Ev();
extern void _ZN6S671C43v76Ev();
extern void _ZN6S671C43v77Ev();
extern void _ZN6S671C43v78Ev();
extern void _ZN6S671C43v79Ev();
extern void _ZN6S671C43v80Ev();
extern void _ZN6S671C43v81Ev();
extern void _ZN6S671C43v82Ev();
extern void _ZN6S671C43v83Ev();
extern void _ZN6S671C43v84Ev();
extern void _ZN6S671C43v85Ev();
extern void _ZN6S671C43v86Ev();
extern void _ZN6S671C43v87Ev();
extern void _ZN6S671C43v88Ev();
extern void _ZN6S671C43v89Ev();
extern void _ZN6S671C43v90Ev();
extern void _ZN6S671C43v91Ev();
extern void _ZN6S671C33v92Ev();
extern void _ZN6S671C33v93Ev();
extern void _ZN6S671C33v94Ev();
extern void _ZN6S671C33v95Ev();
extern void _ZN6S671C33v96Ev();
extern void _ZN6S671C33v97Ev();
extern void _ZN6S671C33v98Ev();
extern void _ZN6S671C33v99Ev();
extern void _ZN6S671C34v100Ev();
extern void _ZN6S671C34v101Ev();
extern void _ZN6S671C34v102Ev();
extern void _ZN6S671C34v103Ev();
extern void _ZN6S671C34v104Ev();
extern void _ZN6S671C34v105Ev();
extern void _ZN6S671C34v106Ev();
extern void _ZN6S671C34v107Ev();
extern void _ZN6S671C34v108Ev();
extern void _ZN6S671C34v109Ev();
extern void _ZN6S671C34v110Ev();
static  VTBL_ENTRY vtc_S671C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S671C3[0]),
  (VTBL_ENTRY)&_ZN6S671C3D1Ev,
  (VTBL_ENTRY)&_ZN6S671C3D0Ev,
  (VTBL_ENTRY)&_ZN6S671C52v6Ev,
  (VTBL_ENTRY)&_ZN6S671C52v7Ev,
  (VTBL_ENTRY)&_ZN6S671C52v8Ev,
  (VTBL_ENTRY)&_ZN6S671C52v9Ev,
  (VTBL_ENTRY)&_ZN6S671C53v10Ev,
  (VTBL_ENTRY)&_ZN6S671C53v11Ev,
  (VTBL_ENTRY)&_ZN6S671C53v12Ev,
  (VTBL_ENTRY)&_ZN6S671C53v13Ev,
  (VTBL_ENTRY)&_ZN6S671C53v14Ev,
  (VTBL_ENTRY)&_ZN6S671C53v15Ev,
  (VTBL_ENTRY)&_ZN6S671C53v16Ev,
  (VTBL_ENTRY)&_ZN6S671C53v17Ev,
  (VTBL_ENTRY)&_ZN6S671C53v18Ev,
  (VTBL_ENTRY)&_ZN6S671C53v19Ev,
  (VTBL_ENTRY)&_ZN6S671C53v20Ev,
  (VTBL_ENTRY)&_ZN6S671C53v21Ev,
  (VTBL_ENTRY)&_ZN6S671C53v22Ev,
  (VTBL_ENTRY)&_ZN6S671C53v23Ev,
  (VTBL_ENTRY)&_ZN6S671C53v24Ev,
  (VTBL_ENTRY)&_ZN6S671C53v25Ev,
  (VTBL_ENTRY)&_ZN6S671C53v26Ev,
  (VTBL_ENTRY)&_ZN6S671C53v27Ev,
  (VTBL_ENTRY)&_ZN6S671C53v28Ev,
  (VTBL_ENTRY)&_ZN6S671C53v29Ev,
  (VTBL_ENTRY)&_ZN6S671C53v30Ev,
  (VTBL_ENTRY)&_ZN6S671C53v31Ev,
  (VTBL_ENTRY)&_ZN6S671C53v32Ev,
  (VTBL_ENTRY)&_ZN6S671C53v33Ev,
  (VTBL_ENTRY)&_ZN6S671C53v34Ev,
  (VTBL_ENTRY)&_ZN6S671C53v35Ev,
  (VTBL_ENTRY)&_ZN6S671C53v36Ev,
  (VTBL_ENTRY)&_ZN6S671C53v37Ev,
  (VTBL_ENTRY)&_ZN6S671C53v38Ev,
  (VTBL_ENTRY)&_ZN6S671C53v39Ev,
  (VTBL_ENTRY)&_ZN6S671C53v40Ev,
  (VTBL_ENTRY)&_ZN6S671C53v41Ev,
  (VTBL_ENTRY)&_ZN6S671C53v42Ev,
  (VTBL_ENTRY)&_ZN6S671C53v43Ev,
  (VTBL_ENTRY)&_ZN6S671C53v44Ev,
  (VTBL_ENTRY)&_ZN6S671C53v45Ev,
  (VTBL_ENTRY)&_ZN6S671C53v46Ev,
  (VTBL_ENTRY)&_ZN6S671C53v47Ev,
  (VTBL_ENTRY)&_ZN6S671C53v48Ev,
  (VTBL_ENTRY)&_ZN6S671C53v49Ev,
  (VTBL_ENTRY)&_ZN6S671C53v50Ev,
  (VTBL_ENTRY)&_ZN6S671C53v51Ev,
  (VTBL_ENTRY)&_ZN6S671C53v52Ev,
  (VTBL_ENTRY)&_ZN6S671C53v53Ev,
  (VTBL_ENTRY)&_ZN6S671C53v54Ev,
  (VTBL_ENTRY)&_ZN6S671C53v55Ev,
  (VTBL_ENTRY)&_ZN6S671C53v56Ev,
  (VTBL_ENTRY)&_ZN6S671C53v57Ev,
  (VTBL_ENTRY)&_ZN6S671C53v58Ev,
  (VTBL_ENTRY)&_ZN6S671C53v59Ev,
  (VTBL_ENTRY)&_ZN6S671C53v60Ev,
  (VTBL_ENTRY)&_ZN6S671C53v61Ev,
  (VTBL_ENTRY)&_ZN6S671C53v62Ev,
  (VTBL_ENTRY)&_ZN6S671C53v63Ev,
  (VTBL_ENTRY)&_ZN6S671C53v64Ev,
  (VTBL_ENTRY)&_ZN6S671C53v65Ev,
  (VTBL_ENTRY)&_ZN6S671C53v66Ev,
  (VTBL_ENTRY)&_ZN6S671C53v67Ev,
  (VTBL_ENTRY)&_ZN6S671C53v68Ev,
  (VTBL_ENTRY)&_ZN6S671C53v69Ev,
  (VTBL_ENTRY)&_ZN6S671C43v70Ev,
  (VTBL_ENTRY)&_ZN6S671C43v71Ev,
  (VTBL_ENTRY)&_ZN6S671C43v72Ev,
  (VTBL_ENTRY)&_ZN6S671C43v73Ev,
  (VTBL_ENTRY)&_ZN6S671C43v74Ev,
  (VTBL_ENTRY)&_ZN6S671C43v75Ev,
  (VTBL_ENTRY)&_ZN6S671C43v76Ev,
  (VTBL_ENTRY)&_ZN6S671C43v77Ev,
  (VTBL_ENTRY)&_ZN6S671C43v78Ev,
  (VTBL_ENTRY)&_ZN6S671C43v79Ev,
  (VTBL_ENTRY)&_ZN6S671C43v80Ev,
  (VTBL_ENTRY)&_ZN6S671C43v81Ev,
  (VTBL_ENTRY)&_ZN6S671C43v82Ev,
  (VTBL_ENTRY)&_ZN6S671C43v83Ev,
  (VTBL_ENTRY)&_ZN6S671C43v84Ev,
  (VTBL_ENTRY)&_ZN6S671C43v85Ev,
  (VTBL_ENTRY)&_ZN6S671C43v86Ev,
  (VTBL_ENTRY)&_ZN6S671C43v87Ev,
  (VTBL_ENTRY)&_ZN6S671C43v88Ev,
  (VTBL_ENTRY)&_ZN6S671C43v89Ev,
  (VTBL_ENTRY)&_ZN6S671C43v90Ev,
  (VTBL_ENTRY)&_ZN6S671C43v91Ev,
  (VTBL_ENTRY)&_ZN6S671C33v92Ev,
  (VTBL_ENTRY)&_ZN6S671C33v93Ev,
  (VTBL_ENTRY)&_ZN6S671C33v94Ev,
  (VTBL_ENTRY)&_ZN6S671C33v95Ev,
  (VTBL_ENTRY)&_ZN6S671C33v96Ev,
  (VTBL_ENTRY)&_ZN6S671C33v97Ev,
  (VTBL_ENTRY)&_ZN6S671C33v98Ev,
  (VTBL_ENTRY)&_ZN6S671C33v99Ev,
  (VTBL_ENTRY)&_ZN6S671C34v100Ev,
  (VTBL_ENTRY)&_ZN6S671C34v101Ev,
  (VTBL_ENTRY)&_ZN6S671C34v102Ev,
  (VTBL_ENTRY)&_ZN6S671C34v103Ev,
  (VTBL_ENTRY)&_ZN6S671C34v104Ev,
  (VTBL_ENTRY)&_ZN6S671C34v105Ev,
  (VTBL_ENTRY)&_ZN6S671C34v106Ev,
  (VTBL_ENTRY)&_ZN6S671C34v107Ev,
  (VTBL_ENTRY)&_ZN6S671C34v108Ev,
  (VTBL_ENTRY)&_ZN6S671C34v109Ev,
  (VTBL_ENTRY)&_ZN6S671C34v110Ev,
};
extern VTBL_ENTRY _ZTI6S671C3[];
extern  VTBL_ENTRY _ZTV6S671C3[];
Class_Descriptor cd_S671C3 = {  "S671C3", // class name
  bases_S671C3, 2,
  &(vtc_S671C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S671C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S671C3),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S671C2  : S671C3 {
  void *s671c2f0;
  virtual  ~S671C2(); // _ZN6S671C2D1Ev
  virtual void  v111(); // _ZN6S671C24v111Ev
  virtual void  v112(); // _ZN6S671C24v112Ev
  virtual void  v113(); // _ZN6S671C24v113Ev
  virtual void  v114(); // _ZN6S671C24v114Ev
  virtual void  v115(); // _ZN6S671C24v115Ev
  virtual void  v116(); // _ZN6S671C24v116Ev
  virtual void  v117(); // _ZN6S671C24v117Ev
  virtual void  v118(); // _ZN6S671C24v118Ev
  virtual void  v119(); // _ZN6S671C24v119Ev
  S671C2(); // tgen
};
//SIG(-1 S671C2) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 FC5} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp}


 S671C2 ::~S671C2(){ note_dtor("S671C2", this);}
void  S671C2 ::v111(){vfunc_called(this, "_ZN6S671C24v111Ev");}
void  S671C2 ::v112(){vfunc_called(this, "_ZN6S671C24v112Ev");}
void  S671C2 ::v113(){vfunc_called(this, "_ZN6S671C24v113Ev");}
void  S671C2 ::v114(){vfunc_called(this, "_ZN6S671C24v114Ev");}
void  S671C2 ::v115(){vfunc_called(this, "_ZN6S671C24v115Ev");}
void  S671C2 ::v116(){vfunc_called(this, "_ZN6S671C24v116Ev");}
void  S671C2 ::v117(){vfunc_called(this, "_ZN6S671C24v117Ev");}
void  S671C2 ::v118(){vfunc_called(this, "_ZN6S671C24v118Ev");}
void  S671C2 ::v119(){vfunc_called(this, "_ZN6S671C24v119Ev");}
S671C2 ::S671C2(){ note_ctor("S671C2", this);} // tgen

static void Test_S671C2()
{
  extern Class_Descriptor cd_S671C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,37)];
    init_test(&cd_S671C2, buf);
    S671C2 *dp, &lv = *(dp=new (buf) S671C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,144), "sizeof(S671C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S671C2)");
    check_base_class_offset(lv, (S671C5*)(S671C4*)(S671C3*), 0, "S671C2");
    check_base_class_offset(lv, (S671C4*)(S671C3*), 0, "S671C2");
    check_base_class_offset(lv, (S671C3*), 0, "S671C2");
    check_field_offset(lv, s671c2f0, ABISELECT(200,140), "S671C2.s671c2f0");
    test_class_info(&lv, &cd_S671C2);
    dp->~S671C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS671C2(Test_S671C2, "S671C2", ABISELECT(208,144));

#else // __cplusplus

extern void _ZN6S671C2C1Ev();
extern void _ZN6S671C2D1Ev();
Name_Map name_map_S671C2[] = {
  NSPAIR(_ZN6S671C2C1Ev),
  NSPAIR(_ZN6S671C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S671C5;
extern VTBL_ENTRY _ZTI6S671C5[];
extern  VTBL_ENTRY _ZTV6S671C5[];
extern Class_Descriptor cd_S671C4;
extern VTBL_ENTRY _ZTI6S671C4[];
extern  VTBL_ENTRY _ZTV6S671C4[];
extern Class_Descriptor cd_S671C3;
extern VTBL_ENTRY _ZTI6S671C3[];
extern  VTBL_ENTRY _ZTV6S671C3[];
static Base_Class bases_S671C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S671C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S671C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S671C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S671C2[];
extern void _ZN6S671C2D1Ev();
extern void _ZN6S671C2D0Ev();
extern void _ZN6S671C52v6Ev();
extern void _ZN6S671C52v7Ev();
extern void _ZN6S671C52v8Ev();
extern void _ZN6S671C52v9Ev();
extern void _ZN6S671C53v10Ev();
extern void _ZN6S671C53v11Ev();
extern void _ZN6S671C53v12Ev();
extern void _ZN6S671C53v13Ev();
extern void _ZN6S671C53v14Ev();
extern void _ZN6S671C53v15Ev();
extern void _ZN6S671C53v16Ev();
extern void _ZN6S671C53v17Ev();
extern void _ZN6S671C53v18Ev();
extern void _ZN6S671C53v19Ev();
extern void _ZN6S671C53v20Ev();
extern void _ZN6S671C53v21Ev();
extern void _ZN6S671C53v22Ev();
extern void _ZN6S671C53v23Ev();
extern void _ZN6S671C53v24Ev();
extern void _ZN6S671C53v25Ev();
extern void _ZN6S671C53v26Ev();
extern void _ZN6S671C53v27Ev();
extern void _ZN6S671C53v28Ev();
extern void _ZN6S671C53v29Ev();
extern void _ZN6S671C53v30Ev();
extern void _ZN6S671C53v31Ev();
extern void _ZN6S671C53v32Ev();
extern void _ZN6S671C53v33Ev();
extern void _ZN6S671C53v34Ev();
extern void _ZN6S671C53v35Ev();
extern void _ZN6S671C53v36Ev();
extern void _ZN6S671C53v37Ev();
extern void _ZN6S671C53v38Ev();
extern void _ZN6S671C53v39Ev();
extern void _ZN6S671C53v40Ev();
extern void _ZN6S671C53v41Ev();
extern void _ZN6S671C53v42Ev();
extern void _ZN6S671C53v43Ev();
extern void _ZN6S671C53v44Ev();
extern void _ZN6S671C53v45Ev();
extern void _ZN6S671C53v46Ev();
extern void _ZN6S671C53v47Ev();
extern void _ZN6S671C53v48Ev();
extern void _ZN6S671C53v49Ev();
extern void _ZN6S671C53v50Ev();
extern void _ZN6S671C53v51Ev();
extern void _ZN6S671C53v52Ev();
extern void _ZN6S671C53v53Ev();
extern void _ZN6S671C53v54Ev();
extern void _ZN6S671C53v55Ev();
extern void _ZN6S671C53v56Ev();
extern void _ZN6S671C53v57Ev();
extern void _ZN6S671C53v58Ev();
extern void _ZN6S671C53v59Ev();
extern void _ZN6S671C53v60Ev();
extern void _ZN6S671C53v61Ev();
extern void _ZN6S671C53v62Ev();
extern void _ZN6S671C53v63Ev();
extern void _ZN6S671C53v64Ev();
extern void _ZN6S671C53v65Ev();
extern void _ZN6S671C53v66Ev();
extern void _ZN6S671C53v67Ev();
extern void _ZN6S671C53v68Ev();
extern void _ZN6S671C53v69Ev();
extern void _ZN6S671C43v70Ev();
extern void _ZN6S671C43v71Ev();
extern void _ZN6S671C43v72Ev();
extern void _ZN6S671C43v73Ev();
extern void _ZN6S671C43v74Ev();
extern void _ZN6S671C43v75Ev();
extern void _ZN6S671C43v76Ev();
extern void _ZN6S671C43v77Ev();
extern void _ZN6S671C43v78Ev();
extern void _ZN6S671C43v79Ev();
extern void _ZN6S671C43v80Ev();
extern void _ZN6S671C43v81Ev();
extern void _ZN6S671C43v82Ev();
extern void _ZN6S671C43v83Ev();
extern void _ZN6S671C43v84Ev();
extern void _ZN6S671C43v85Ev();
extern void _ZN6S671C43v86Ev();
extern void _ZN6S671C43v87Ev();
extern void _ZN6S671C43v88Ev();
extern void _ZN6S671C43v89Ev();
extern void _ZN6S671C43v90Ev();
extern void _ZN6S671C43v91Ev();
extern void _ZN6S671C33v92Ev();
extern void _ZN6S671C33v93Ev();
extern void _ZN6S671C33v94Ev();
extern void _ZN6S671C33v95Ev();
extern void _ZN6S671C33v96Ev();
extern void _ZN6S671C33v97Ev();
extern void _ZN6S671C33v98Ev();
extern void _ZN6S671C33v99Ev();
extern void _ZN6S671C34v100Ev();
extern void _ZN6S671C34v101Ev();
extern void _ZN6S671C34v102Ev();
extern void _ZN6S671C34v103Ev();
extern void _ZN6S671C34v104Ev();
extern void _ZN6S671C34v105Ev();
extern void _ZN6S671C34v106Ev();
extern void _ZN6S671C34v107Ev();
extern void _ZN6S671C34v108Ev();
extern void _ZN6S671C34v109Ev();
extern void _ZN6S671C34v110Ev();
extern void _ZN6S671C24v111Ev();
extern void _ZN6S671C24v112Ev();
extern void _ZN6S671C24v113Ev();
extern void _ZN6S671C24v114Ev();
extern void _ZN6S671C24v115Ev();
extern void _ZN6S671C24v116Ev();
extern void _ZN6S671C24v117Ev();
extern void _ZN6S671C24v118Ev();
extern void _ZN6S671C24v119Ev();
static  VTBL_ENTRY vtc_S671C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S671C2[0]),
  (VTBL_ENTRY)&_ZN6S671C2D1Ev,
  (VTBL_ENTRY)&_ZN6S671C2D0Ev,
  (VTBL_ENTRY)&_ZN6S671C52v6Ev,
  (VTBL_ENTRY)&_ZN6S671C52v7Ev,
  (VTBL_ENTRY)&_ZN6S671C52v8Ev,
  (VTBL_ENTRY)&_ZN6S671C52v9Ev,
  (VTBL_ENTRY)&_ZN6S671C53v10Ev,
  (VTBL_ENTRY)&_ZN6S671C53v11Ev,
  (VTBL_ENTRY)&_ZN6S671C53v12Ev,
  (VTBL_ENTRY)&_ZN6S671C53v13Ev,
  (VTBL_ENTRY)&_ZN6S671C53v14Ev,
  (VTBL_ENTRY)&_ZN6S671C53v15Ev,
  (VTBL_ENTRY)&_ZN6S671C53v16Ev,
  (VTBL_ENTRY)&_ZN6S671C53v17Ev,
  (VTBL_ENTRY)&_ZN6S671C53v18Ev,
  (VTBL_ENTRY)&_ZN6S671C53v19Ev,
  (VTBL_ENTRY)&_ZN6S671C53v20Ev,
  (VTBL_ENTRY)&_ZN6S671C53v21Ev,
  (VTBL_ENTRY)&_ZN6S671C53v22Ev,
  (VTBL_ENTRY)&_ZN6S671C53v23Ev,
  (VTBL_ENTRY)&_ZN6S671C53v24Ev,
  (VTBL_ENTRY)&_ZN6S671C53v25Ev,
  (VTBL_ENTRY)&_ZN6S671C53v26Ev,
  (VTBL_ENTRY)&_ZN6S671C53v27Ev,
  (VTBL_ENTRY)&_ZN6S671C53v28Ev,
  (VTBL_ENTRY)&_ZN6S671C53v29Ev,
  (VTBL_ENTRY)&_ZN6S671C53v30Ev,
  (VTBL_ENTRY)&_ZN6S671C53v31Ev,
  (VTBL_ENTRY)&_ZN6S671C53v32Ev,
  (VTBL_ENTRY)&_ZN6S671C53v33Ev,
  (VTBL_ENTRY)&_ZN6S671C53v34Ev,
  (VTBL_ENTRY)&_ZN6S671C53v35Ev,
  (VTBL_ENTRY)&_ZN6S671C53v36Ev,
  (VTBL_ENTRY)&_ZN6S671C53v37Ev,
  (VTBL_ENTRY)&_ZN6S671C53v38Ev,
  (VTBL_ENTRY)&_ZN6S671C53v39Ev,
  (VTBL_ENTRY)&_ZN6S671C53v40Ev,
  (VTBL_ENTRY)&_ZN6S671C53v41Ev,
  (VTBL_ENTRY)&_ZN6S671C53v42Ev,
  (VTBL_ENTRY)&_ZN6S671C53v43Ev,
  (VTBL_ENTRY)&_ZN6S671C53v44Ev,
  (VTBL_ENTRY)&_ZN6S671C53v45Ev,
  (VTBL_ENTRY)&_ZN6S671C53v46Ev,
  (VTBL_ENTRY)&_ZN6S671C53v47Ev,
  (VTBL_ENTRY)&_ZN6S671C53v48Ev,
  (VTBL_ENTRY)&_ZN6S671C53v49Ev,
  (VTBL_ENTRY)&_ZN6S671C53v50Ev,
  (VTBL_ENTRY)&_ZN6S671C53v51Ev,
  (VTBL_ENTRY)&_ZN6S671C53v52Ev,
  (VTBL_ENTRY)&_ZN6S671C53v53Ev,
  (VTBL_ENTRY)&_ZN6S671C53v54Ev,
  (VTBL_ENTRY)&_ZN6S671C53v55Ev,
  (VTBL_ENTRY)&_ZN6S671C53v56Ev,
  (VTBL_ENTRY)&_ZN6S671C53v57Ev,
  (VTBL_ENTRY)&_ZN6S671C53v58Ev,
  (VTBL_ENTRY)&_ZN6S671C53v59Ev,
  (VTBL_ENTRY)&_ZN6S671C53v60Ev,
  (VTBL_ENTRY)&_ZN6S671C53v61Ev,
  (VTBL_ENTRY)&_ZN6S671C53v62Ev,
  (VTBL_ENTRY)&_ZN6S671C53v63Ev,
  (VTBL_ENTRY)&_ZN6S671C53v64Ev,
  (VTBL_ENTRY)&_ZN6S671C53v65Ev,
  (VTBL_ENTRY)&_ZN6S671C53v66Ev,
  (VTBL_ENTRY)&_ZN6S671C53v67Ev,
  (VTBL_ENTRY)&_ZN6S671C53v68Ev,
  (VTBL_ENTRY)&_ZN6S671C53v69Ev,
  (VTBL_ENTRY)&_ZN6S671C43v70Ev,
  (VTBL_ENTRY)&_ZN6S671C43v71Ev,
  (VTBL_ENTRY)&_ZN6S671C43v72Ev,
  (VTBL_ENTRY)&_ZN6S671C43v73Ev,
  (VTBL_ENTRY)&_ZN6S671C43v74Ev,
  (VTBL_ENTRY)&_ZN6S671C43v75Ev,
  (VTBL_ENTRY)&_ZN6S671C43v76Ev,
  (VTBL_ENTRY)&_ZN6S671C43v77Ev,
  (VTBL_ENTRY)&_ZN6S671C43v78Ev,
  (VTBL_ENTRY)&_ZN6S671C43v79Ev,
  (VTBL_ENTRY)&_ZN6S671C43v80Ev,
  (VTBL_ENTRY)&_ZN6S671C43v81Ev,
  (VTBL_ENTRY)&_ZN6S671C43v82Ev,
  (VTBL_ENTRY)&_ZN6S671C43v83Ev,
  (VTBL_ENTRY)&_ZN6S671C43v84Ev,
  (VTBL_ENTRY)&_ZN6S671C43v85Ev,
  (VTBL_ENTRY)&_ZN6S671C43v86Ev,
  (VTBL_ENTRY)&_ZN6S671C43v87Ev,
  (VTBL_ENTRY)&_ZN6S671C43v88Ev,
  (VTBL_ENTRY)&_ZN6S671C43v89Ev,
  (VTBL_ENTRY)&_ZN6S671C43v90Ev,
  (VTBL_ENTRY)&_ZN6S671C43v91Ev,
  (VTBL_ENTRY)&_ZN6S671C33v92Ev,
  (VTBL_ENTRY)&_ZN6S671C33v93Ev,
  (VTBL_ENTRY)&_ZN6S671C33v94Ev,
  (VTBL_ENTRY)&_ZN6S671C33v95Ev,
  (VTBL_ENTRY)&_ZN6S671C33v96Ev,
  (VTBL_ENTRY)&_ZN6S671C33v97Ev,
  (VTBL_ENTRY)&_ZN6S671C33v98Ev,
  (VTBL_ENTRY)&_ZN6S671C33v99Ev,
  (VTBL_ENTRY)&_ZN6S671C34v100Ev,
  (VTBL_ENTRY)&_ZN6S671C34v101Ev,
  (VTBL_ENTRY)&_ZN6S671C34v102Ev,
  (VTBL_ENTRY)&_ZN6S671C34v103Ev,
  (VTBL_ENTRY)&_ZN6S671C34v104Ev,
  (VTBL_ENTRY)&_ZN6S671C34v105Ev,
  (VTBL_ENTRY)&_ZN6S671C34v106Ev,
  (VTBL_ENTRY)&_ZN6S671C34v107Ev,
  (VTBL_ENTRY)&_ZN6S671C34v108Ev,
  (VTBL_ENTRY)&_ZN6S671C34v109Ev,
  (VTBL_ENTRY)&_ZN6S671C34v110Ev,
  (VTBL_ENTRY)&_ZN6S671C24v111Ev,
  (VTBL_ENTRY)&_ZN6S671C24v112Ev,
  (VTBL_ENTRY)&_ZN6S671C24v113Ev,
  (VTBL_ENTRY)&_ZN6S671C24v114Ev,
  (VTBL_ENTRY)&_ZN6S671C24v115Ev,
  (VTBL_ENTRY)&_ZN6S671C24v116Ev,
  (VTBL_ENTRY)&_ZN6S671C24v117Ev,
  (VTBL_ENTRY)&_ZN6S671C24v118Ev,
  (VTBL_ENTRY)&_ZN6S671C24v119Ev,
};
extern VTBL_ENTRY _ZTI6S671C2[];
extern  VTBL_ENTRY _ZTV6S671C2[];
Class_Descriptor cd_S671C2 = {  "S671C2", // class name
  bases_S671C2, 3,
  &(vtc_S671C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,144), // object size
  NSPAIRA(_ZTI6S671C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S671C2),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S671C1  : S671C2 {
  ::S672C14_nt s671c1f0;
  unsigned int s671c1f1:1;
  int s671c1f2;
  virtual  ~S671C1(); // _ZN6S671C1D1Ev
  virtual void  v1(); // _ZN6S671C12v1Ev
  virtual void  v2(); // _ZN6S671C12v2Ev
  virtual void  v3(); // _ZN6S671C12v3Ev
  virtual void  v4(); // _ZN6S671C12v4Ev
  virtual void  v5(); // _ZN6S671C12v5Ev
  S671C1(); // tgen
};
//SIG(1 S671C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC6} vd v111 v112 v113 v114 v115 v116 v117 v118 v119 Fp} vd v1 v2 v3 v4 v5 FC12{ BC13{ BC10}} Fi:1 Fi}


 S671C1 ::~S671C1(){ note_dtor("S671C1", this);}
void  S671C1 ::v1(){vfunc_called(this, "_ZN6S671C12v1Ev");}
void  S671C1 ::v2(){vfunc_called(this, "_ZN6S671C12v2Ev");}
void  S671C1 ::v3(){vfunc_called(this, "_ZN6S671C12v3Ev");}
void  S671C1 ::v4(){vfunc_called(this, "_ZN6S671C12v4Ev");}
void  S671C1 ::v5(){vfunc_called(this, "_ZN6S671C12v5Ev");}
S671C1 ::S671C1(){ note_ctor("S671C1", this);} // tgen

static void Test_S671C1()
{
  extern Class_Descriptor cd_S671C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,42)];
    init_test(&cd_S671C1, buf);
    S671C1 *dp, &lv = *(dp=new (buf) S671C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,164), "sizeof(S671C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S671C1)");
    check_base_class_offset(lv, (S671C5*)(S671C4*)(S671C3*)(S671C2*), 0, "S671C1");
    check_base_class_offset(lv, (S671C4*)(S671C3*)(S671C2*), 0, "S671C1");
    check_base_class_offset(lv, (S671C3*)(S671C2*), 0, "S671C1");
    check_base_class_offset(lv, (S671C2*), 0, "S671C1");
    check_field_offset(lv, s671c1f0, ABISELECT(208,144), "S671C1.s671c1f0");
    set_bf_and_test(lv, s671c1f1, ABISELECT(224,156), 0, 1, 1, "S671C1");
    check_field_offset(lv, s671c1f2, ABISELECT(228,160), "S671C1.s671c1f2");
    test_class_info(&lv, &cd_S671C1);
    dp->~S671C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS671C1(Test_S671C1, "S671C1", ABISELECT(232,164));

#else // __cplusplus

extern void _ZN6S671C1C1Ev();
extern void _ZN6S671C1D1Ev();
Name_Map name_map_S671C1[] = {
  NSPAIR(_ZN6S671C1C1Ev),
  NSPAIR(_ZN6S671C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S671C5;
extern VTBL_ENTRY _ZTI6S671C5[];
extern  VTBL_ENTRY _ZTV6S671C5[];
extern Class_Descriptor cd_S671C4;
extern VTBL_ENTRY _ZTI6S671C4[];
extern  VTBL_ENTRY _ZTV6S671C4[];
extern Class_Descriptor cd_S671C3;
extern VTBL_ENTRY _ZTI6S671C3[];
extern  VTBL_ENTRY _ZTV6S671C3[];
extern Class_Descriptor cd_S671C2;
extern VTBL_ENTRY _ZTI6S671C2[];
extern  VTBL_ENTRY _ZTV6S671C2[];
static Base_Class bases_S671C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S671C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S671C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S671C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S671C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S671C1[];
extern void _ZN6S671C1D1Ev();
extern void _ZN6S671C1D0Ev();
extern void _ZN6S671C52v6Ev();
extern void _ZN6S671C52v7Ev();
extern void _ZN6S671C52v8Ev();
extern void _ZN6S671C52v9Ev();
extern void _ZN6S671C53v10Ev();
extern void _ZN6S671C53v11Ev();
extern void _ZN6S671C53v12Ev();
extern void _ZN6S671C53v13Ev();
extern void _ZN6S671C53v14Ev();
extern void _ZN6S671C53v15Ev();
extern void _ZN6S671C53v16Ev();
extern void _ZN6S671C53v17Ev();
extern void _ZN6S671C53v18Ev();
extern void _ZN6S671C53v19Ev();
extern void _ZN6S671C53v20Ev();
extern void _ZN6S671C53v21Ev();
extern void _ZN6S671C53v22Ev();
extern void _ZN6S671C53v23Ev();
extern void _ZN6S671C53v24Ev();
extern void _ZN6S671C53v25Ev();
extern void _ZN6S671C53v26Ev();
extern void _ZN6S671C53v27Ev();
extern void _ZN6S671C53v28Ev();
extern void _ZN6S671C53v29Ev();
extern void _ZN6S671C53v30Ev();
extern void _ZN6S671C53v31Ev();
extern void _ZN6S671C53v32Ev();
extern void _ZN6S671C53v33Ev();
extern void _ZN6S671C53v34Ev();
extern void _ZN6S671C53v35Ev();
extern void _ZN6S671C53v36Ev();
extern void _ZN6S671C53v37Ev();
extern void _ZN6S671C53v38Ev();
extern void _ZN6S671C53v39Ev();
extern void _ZN6S671C53v40Ev();
extern void _ZN6S671C53v41Ev();
extern void _ZN6S671C53v42Ev();
extern void _ZN6S671C53v43Ev();
extern void _ZN6S671C53v44Ev();
extern void _ZN6S671C53v45Ev();
extern void _ZN6S671C53v46Ev();
extern void _ZN6S671C53v47Ev();
extern void _ZN6S671C53v48Ev();
extern void _ZN6S671C53v49Ev();
extern void _ZN6S671C53v50Ev();
extern void _ZN6S671C53v51Ev();
extern void _ZN6S671C53v52Ev();
extern void _ZN6S671C53v53Ev();
extern void _ZN6S671C53v54Ev();
extern void _ZN6S671C53v55Ev();
extern void _ZN6S671C53v56Ev();
extern void _ZN6S671C53v57Ev();
extern void _ZN6S671C53v58Ev();
extern void _ZN6S671C53v59Ev();
extern void _ZN6S671C53v60Ev();
extern void _ZN6S671C53v61Ev();
extern void _ZN6S671C53v62Ev();
extern void _ZN6S671C53v63Ev();
extern void _ZN6S671C53v64Ev();
extern void _ZN6S671C53v65Ev();
extern void _ZN6S671C53v66Ev();
extern void _ZN6S671C53v67Ev();
extern void _ZN6S671C53v68Ev();
extern void _ZN6S671C53v69Ev();
extern void _ZN6S671C43v70Ev();
extern void _ZN6S671C43v71Ev();
extern void _ZN6S671C43v72Ev();
extern void _ZN6S671C43v73Ev();
extern void _ZN6S671C43v74Ev();
extern void _ZN6S671C43v75Ev();
extern void _ZN6S671C43v76Ev();
extern void _ZN6S671C43v77Ev();
extern void _ZN6S671C43v78Ev();
extern void _ZN6S671C43v79Ev();
extern void _ZN6S671C43v80Ev();
extern void _ZN6S671C43v81Ev();
extern void _ZN6S671C43v82Ev();
extern void _ZN6S671C43v83Ev();
extern void _ZN6S671C43v84Ev();
extern void _ZN6S671C43v85Ev();
extern void _ZN6S671C43v86Ev();
extern void _ZN6S671C43v87Ev();
extern void _ZN6S671C43v88Ev();
extern void _ZN6S671C43v89Ev();
extern void _ZN6S671C43v90Ev();
extern void _ZN6S671C43v91Ev();
extern void _ZN6S671C33v92Ev();
extern void _ZN6S671C33v93Ev();
extern void _ZN6S671C33v94Ev();
extern void _ZN6S671C33v95Ev();
extern void _ZN6S671C33v96Ev();
extern void _ZN6S671C33v97Ev();
extern void _ZN6S671C33v98Ev();
extern void _ZN6S671C33v99Ev();
extern void _ZN6S671C34v100Ev();
extern void _ZN6S671C34v101Ev();
extern void _ZN6S671C34v102Ev();
extern void _ZN6S671C34v103Ev();
extern void _ZN6S671C34v104Ev();
extern void _ZN6S671C34v105Ev();
extern void _ZN6S671C34v106Ev();
extern void _ZN6S671C34v107Ev();
extern void _ZN6S671C34v108Ev();
extern void _ZN6S671C34v109Ev();
extern void _ZN6S671C34v110Ev();
extern void _ZN6S671C24v111Ev();
extern void _ZN6S671C24v112Ev();
extern void _ZN6S671C24v113Ev();
extern void _ZN6S671C24v114Ev();
extern void _ZN6S671C24v115Ev();
extern void _ZN6S671C24v116Ev();
extern void _ZN6S671C24v117Ev();
extern void _ZN6S671C24v118Ev();
extern void _ZN6S671C24v119Ev();
extern void _ZN6S671C12v1Ev();
extern void _ZN6S671C12v2Ev();
extern void _ZN6S671C12v3Ev();
extern void _ZN6S671C12v4Ev();
extern void _ZN6S671C12v5Ev();
static  VTBL_ENTRY vtc_S671C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S671C1[0]),
  (VTBL_ENTRY)&_ZN6S671C1D1Ev,
  (VTBL_ENTRY)&_ZN6S671C1D0Ev,
  (VTBL_ENTRY)&_ZN6S671C52v6Ev,
  (VTBL_ENTRY)&_ZN6S671C52v7Ev,
  (VTBL_ENTRY)&_ZN6S671C52v8Ev,
  (VTBL_ENTRY)&_ZN6S671C52v9Ev,
  (VTBL_ENTRY)&_ZN6S671C53v10Ev,
  (VTBL_ENTRY)&_ZN6S671C53v11Ev,
  (VTBL_ENTRY)&_ZN6S671C53v12Ev,
  (VTBL_ENTRY)&_ZN6S671C53v13Ev,
  (VTBL_ENTRY)&_ZN6S671C53v14Ev,
  (VTBL_ENTRY)&_ZN6S671C53v15Ev,
  (VTBL_ENTRY)&_ZN6S671C53v16Ev,
  (VTBL_ENTRY)&_ZN6S671C53v17Ev,
  (VTBL_ENTRY)&_ZN6S671C53v18Ev,
  (VTBL_ENTRY)&_ZN6S671C53v19Ev,
  (VTBL_ENTRY)&_ZN6S671C53v20Ev,
  (VTBL_ENTRY)&_ZN6S671C53v21Ev,
  (VTBL_ENTRY)&_ZN6S671C53v22Ev,
  (VTBL_ENTRY)&_ZN6S671C53v23Ev,
  (VTBL_ENTRY)&_ZN6S671C53v24Ev,
  (VTBL_ENTRY)&_ZN6S671C53v25Ev,
  (VTBL_ENTRY)&_ZN6S671C53v26Ev,
  (VTBL_ENTRY)&_ZN6S671C53v27Ev,
  (VTBL_ENTRY)&_ZN6S671C53v28Ev,
  (VTBL_ENTRY)&_ZN6S671C53v29Ev,
  (VTBL_ENTRY)&_ZN6S671C53v30Ev,
  (VTBL_ENTRY)&_ZN6S671C53v31Ev,
  (VTBL_ENTRY)&_ZN6S671C53v32Ev,
  (VTBL_ENTRY)&_ZN6S671C53v33Ev,
  (VTBL_ENTRY)&_ZN6S671C53v34Ev,
  (VTBL_ENTRY)&_ZN6S671C53v35Ev,
  (VTBL_ENTRY)&_ZN6S671C53v36Ev,
  (VTBL_ENTRY)&_ZN6S671C53v37Ev,
  (VTBL_ENTRY)&_ZN6S671C53v38Ev,
  (VTBL_ENTRY)&_ZN6S671C53v39Ev,
  (VTBL_ENTRY)&_ZN6S671C53v40Ev,
  (VTBL_ENTRY)&_ZN6S671C53v41Ev,
  (VTBL_ENTRY)&_ZN6S671C53v42Ev,
  (VTBL_ENTRY)&_ZN6S671C53v43Ev,
  (VTBL_ENTRY)&_ZN6S671C53v44Ev,
  (VTBL_ENTRY)&_ZN6S671C53v45Ev,
  (VTBL_ENTRY)&_ZN6S671C53v46Ev,
  (VTBL_ENTRY)&_ZN6S671C53v47Ev,
  (VTBL_ENTRY)&_ZN6S671C53v48Ev,
  (VTBL_ENTRY)&_ZN6S671C53v49Ev,
  (VTBL_ENTRY)&_ZN6S671C53v50Ev,
  (VTBL_ENTRY)&_ZN6S671C53v51Ev,
  (VTBL_ENTRY)&_ZN6S671C53v52Ev,
  (VTBL_ENTRY)&_ZN6S671C53v53Ev,
  (VTBL_ENTRY)&_ZN6S671C53v54Ev,
  (VTBL_ENTRY)&_ZN6S671C53v55Ev,
  (VTBL_ENTRY)&_ZN6S671C53v56Ev,
  (VTBL_ENTRY)&_ZN6S671C53v57Ev,
  (VTBL_ENTRY)&_ZN6S671C53v58Ev,
  (VTBL_ENTRY)&_ZN6S671C53v59Ev,
  (VTBL_ENTRY)&_ZN6S671C53v60Ev,
  (VTBL_ENTRY)&_ZN6S671C53v61Ev,
  (VTBL_ENTRY)&_ZN6S671C53v62Ev,
  (VTBL_ENTRY)&_ZN6S671C53v63Ev,
  (VTBL_ENTRY)&_ZN6S671C53v64Ev,
  (VTBL_ENTRY)&_ZN6S671C53v65Ev,
  (VTBL_ENTRY)&_ZN6S671C53v66Ev,
  (VTBL_ENTRY)&_ZN6S671C53v67Ev,
  (VTBL_ENTRY)&_ZN6S671C53v68Ev,
  (VTBL_ENTRY)&_ZN6S671C53v69Ev,
  (VTBL_ENTRY)&_ZN6S671C43v70Ev,
  (VTBL_ENTRY)&_ZN6S671C43v71Ev,
  (VTBL_ENTRY)&_ZN6S671C43v72Ev,
  (VTBL_ENTRY)&_ZN6S671C43v73Ev,
  (VTBL_ENTRY)&_ZN6S671C43v74Ev,
  (VTBL_ENTRY)&_ZN6S671C43v75Ev,
  (VTBL_ENTRY)&_ZN6S671C43v76Ev,
  (VTBL_ENTRY)&_ZN6S671C43v77Ev,
  (VTBL_ENTRY)&_ZN6S671C43v78Ev,
  (VTBL_ENTRY)&_ZN6S671C43v79Ev,
  (VTBL_ENTRY)&_ZN6S671C43v80Ev,
  (VTBL_ENTRY)&_ZN6S671C43v81Ev,
  (VTBL_ENTRY)&_ZN6S671C43v82Ev,
  (VTBL_ENTRY)&_ZN6S671C43v83Ev,
  (VTBL_ENTRY)&_ZN6S671C43v84Ev,
  (VTBL_ENTRY)&_ZN6S671C43v85Ev,
  (VTBL_ENTRY)&_ZN6S671C43v86Ev,
  (VTBL_ENTRY)&_ZN6S671C43v87Ev,
  (VTBL_ENTRY)&_ZN6S671C43v88Ev,
  (VTBL_ENTRY)&_ZN6S671C43v89Ev,
  (VTBL_ENTRY)&_ZN6S671C43v90Ev,
  (VTBL_ENTRY)&_ZN6S671C43v91Ev,
  (VTBL_ENTRY)&_ZN6S671C33v92Ev,
  (VTBL_ENTRY)&_ZN6S671C33v93Ev,
  (VTBL_ENTRY)&_ZN6S671C33v94Ev,
  (VTBL_ENTRY)&_ZN6S671C33v95Ev,
  (VTBL_ENTRY)&_ZN6S671C33v96Ev,
  (VTBL_ENTRY)&_ZN6S671C33v97Ev,
  (VTBL_ENTRY)&_ZN6S671C33v98Ev,
  (VTBL_ENTRY)&_ZN6S671C33v99Ev,
  (VTBL_ENTRY)&_ZN6S671C34v100Ev,
  (VTBL_ENTRY)&_ZN6S671C34v101Ev,
  (VTBL_ENTRY)&_ZN6S671C34v102Ev,
  (VTBL_ENTRY)&_ZN6S671C34v103Ev,
  (VTBL_ENTRY)&_ZN6S671C34v104Ev,
  (VTBL_ENTRY)&_ZN6S671C34v105Ev,
  (VTBL_ENTRY)&_ZN6S671C34v106Ev,
  (VTBL_ENTRY)&_ZN6S671C34v107Ev,
  (VTBL_ENTRY)&_ZN6S671C34v108Ev,
  (VTBL_ENTRY)&_ZN6S671C34v109Ev,
  (VTBL_ENTRY)&_ZN6S671C34v110Ev,
  (VTBL_ENTRY)&_ZN6S671C24v111Ev,
  (VTBL_ENTRY)&_ZN6S671C24v112Ev,
  (VTBL_ENTRY)&_ZN6S671C24v113Ev,
  (VTBL_ENTRY)&_ZN6S671C24v114Ev,
  (VTBL_ENTRY)&_ZN6S671C24v115Ev,
  (VTBL_ENTRY)&_ZN6S671C24v116Ev,
  (VTBL_ENTRY)&_ZN6S671C24v117Ev,
  (VTBL_ENTRY)&_ZN6S671C24v118Ev,
  (VTBL_ENTRY)&_ZN6S671C24v119Ev,
  (VTBL_ENTRY)&_ZN6S671C12v1Ev,
  (VTBL_ENTRY)&_ZN6S671C12v2Ev,
  (VTBL_ENTRY)&_ZN6S671C12v3Ev,
  (VTBL_ENTRY)&_ZN6S671C12v4Ev,
  (VTBL_ENTRY)&_ZN6S671C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S671C1[];
extern  VTBL_ENTRY _ZTV6S671C1[];
Class_Descriptor cd_S671C1 = {  "S671C1", // class name
  bases_S671C1, 4,
  &(vtc_S671C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,164), // object size
  NSPAIRA(_ZTI6S671C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S671C1),123, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1312C4  {
  int s1312c4f0;
  __tsi64 s1312c4f1;
  void *s1312c4f2[4];
  int s1312c4f3[2];
  void *s1312c4f4;
  ::S473C6_nt s1312c4f5;
  void *s1312c4f6[2];
  virtual  ~S1312C4(); // _ZN7S1312C4D1Ev
  virtual void  v13(); // _ZN7S1312C43v13Ev
  virtual void  v14(); // _ZN7S1312C43v14Ev
  virtual void  v15(); // _ZN7S1312C43v15Ev
  virtual void  v16(); // _ZN7S1312C43v16Ev
  virtual void  v17(); // _ZN7S1312C43v17Ev
  virtual void  v18(); // _ZN7S1312C43v18Ev
  virtual void  v19(); // _ZN7S1312C43v19Ev
  virtual void  v20(); // _ZN7S1312C43v20Ev
  virtual void  v21(); // _ZN7S1312C43v21Ev
  virtual void  v22(); // _ZN7S1312C43v22Ev
  virtual void  v23(); // _ZN7S1312C43v23Ev
  virtual void  v24(); // _ZN7S1312C43v24Ev
  virtual void  v25(); // _ZN7S1312C43v25Ev
  virtual void  v26(); // _ZN7S1312C43v26Ev
  virtual void  v27(); // _ZN7S1312C43v27Ev
  virtual void  v28(); // _ZN7S1312C43v28Ev
  virtual void  v29(); // _ZN7S1312C43v29Ev
  virtual void  v30(); // _ZN7S1312C43v30Ev
  virtual void  v31(); // _ZN7S1312C43v31Ev
  virtual void  v32(); // _ZN7S1312C43v32Ev
  virtual void  v33(); // _ZN7S1312C43v33Ev
  virtual void  v34(); // _ZN7S1312C43v34Ev
  virtual void  v35(); // _ZN7S1312C43v35Ev
  virtual void  v36(); // _ZN7S1312C43v36Ev
  virtual void  v37(); // _ZN7S1312C43v37Ev
  virtual void  v38(); // _ZN7S1312C43v38Ev
  virtual void  v39(); // _ZN7S1312C43v39Ev
  virtual void  v40(); // _ZN7S1312C43v40Ev
  virtual void  v41(); // _ZN7S1312C43v41Ev
  virtual void  v42(); // _ZN7S1312C43v42Ev
  virtual void  v43(); // _ZN7S1312C43v43Ev
  virtual void  v44(); // _ZN7S1312C43v44Ev
  virtual void  v45(); // _ZN7S1312C43v45Ev
  virtual void  v46(); // _ZN7S1312C43v46Ev
  virtual void  v47(); // _ZN7S1312C43v47Ev
  virtual void  v48(); // _ZN7S1312C43v48Ev
  virtual void  v49(); // _ZN7S1312C43v49Ev
  virtual void  v50(); // _ZN7S1312C43v50Ev
  virtual void  v51(); // _ZN7S1312C43v51Ev
  virtual void  v52(); // _ZN7S1312C43v52Ev
  virtual void  v53(); // _ZN7S1312C43v53Ev
  virtual void  v54(); // _ZN7S1312C43v54Ev
  virtual void  v55(); // _ZN7S1312C43v55Ev
  virtual void  v56(); // _ZN7S1312C43v56Ev
  virtual void  v57(); // _ZN7S1312C43v57Ev
  virtual void  v58(); // _ZN7S1312C43v58Ev
  virtual void  v59(); // _ZN7S1312C43v59Ev
  virtual void  v60(); // _ZN7S1312C43v60Ev
  virtual void  v61(); // _ZN7S1312C43v61Ev
  virtual void  v62(); // _ZN7S1312C43v62Ev
  virtual void  v63(); // _ZN7S1312C43v63Ev
  virtual void  v64(); // _ZN7S1312C43v64Ev
  virtual void  v65(); // _ZN7S1312C43v65Ev
  virtual void  v66(); // _ZN7S1312C43v66Ev
  virtual void  v67(); // _ZN7S1312C43v67Ev
  virtual void  v68(); // _ZN7S1312C43v68Ev
  virtual void  v69(); // _ZN7S1312C43v69Ev
  virtual void  v70(); // _ZN7S1312C43v70Ev
  virtual void  v71(); // _ZN7S1312C43v71Ev
  virtual void  v72(); // _ZN7S1312C43v72Ev
  virtual void  v73(); // _ZN7S1312C43v73Ev
  virtual void  v74(); // _ZN7S1312C43v74Ev
  virtual void  v75(); // _ZN7S1312C43v75Ev
  virtual void  v76(); // _ZN7S1312C43v76Ev
  S1312C4(); // tgen
};
//SIG(-1 S1312C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1312C4 ::~S1312C4(){ note_dtor("S1312C4", this);}
void  S1312C4 ::v13(){vfunc_called(this, "_ZN7S1312C43v13Ev");}
void  S1312C4 ::v14(){vfunc_called(this, "_ZN7S1312C43v14Ev");}
void  S1312C4 ::v15(){vfunc_called(this, "_ZN7S1312C43v15Ev");}
void  S1312C4 ::v16(){vfunc_called(this, "_ZN7S1312C43v16Ev");}
void  S1312C4 ::v17(){vfunc_called(this, "_ZN7S1312C43v17Ev");}
void  S1312C4 ::v18(){vfunc_called(this, "_ZN7S1312C43v18Ev");}
void  S1312C4 ::v19(){vfunc_called(this, "_ZN7S1312C43v19Ev");}
void  S1312C4 ::v20(){vfunc_called(this, "_ZN7S1312C43v20Ev");}
void  S1312C4 ::v21(){vfunc_called(this, "_ZN7S1312C43v21Ev");}
void  S1312C4 ::v22(){vfunc_called(this, "_ZN7S1312C43v22Ev");}
void  S1312C4 ::v23(){vfunc_called(this, "_ZN7S1312C43v23Ev");}
void  S1312C4 ::v24(){vfunc_called(this, "_ZN7S1312C43v24Ev");}
void  S1312C4 ::v25(){vfunc_called(this, "_ZN7S1312C43v25Ev");}
void  S1312C4 ::v26(){vfunc_called(this, "_ZN7S1312C43v26Ev");}
void  S1312C4 ::v27(){vfunc_called(this, "_ZN7S1312C43v27Ev");}
void  S1312C4 ::v28(){vfunc_called(this, "_ZN7S1312C43v28Ev");}
void  S1312C4 ::v29(){vfunc_called(this, "_ZN7S1312C43v29Ev");}
void  S1312C4 ::v30(){vfunc_called(this, "_ZN7S1312C43v30Ev");}
void  S1312C4 ::v31(){vfunc_called(this, "_ZN7S1312C43v31Ev");}
void  S1312C4 ::v32(){vfunc_called(this, "_ZN7S1312C43v32Ev");}
void  S1312C4 ::v33(){vfunc_called(this, "_ZN7S1312C43v33Ev");}
void  S1312C4 ::v34(){vfunc_called(this, "_ZN7S1312C43v34Ev");}
void  S1312C4 ::v35(){vfunc_called(this, "_ZN7S1312C43v35Ev");}
void  S1312C4 ::v36(){vfunc_called(this, "_ZN7S1312C43v36Ev");}
void  S1312C4 ::v37(){vfunc_called(this, "_ZN7S1312C43v37Ev");}
void  S1312C4 ::v38(){vfunc_called(this, "_ZN7S1312C43v38Ev");}
void  S1312C4 ::v39(){vfunc_called(this, "_ZN7S1312C43v39Ev");}
void  S1312C4 ::v40(){vfunc_called(this, "_ZN7S1312C43v40Ev");}
void  S1312C4 ::v41(){vfunc_called(this, "_ZN7S1312C43v41Ev");}
void  S1312C4 ::v42(){vfunc_called(this, "_ZN7S1312C43v42Ev");}
void  S1312C4 ::v43(){vfunc_called(this, "_ZN7S1312C43v43Ev");}
void  S1312C4 ::v44(){vfunc_called(this, "_ZN7S1312C43v44Ev");}
void  S1312C4 ::v45(){vfunc_called(this, "_ZN7S1312C43v45Ev");}
void  S1312C4 ::v46(){vfunc_called(this, "_ZN7S1312C43v46Ev");}
void  S1312C4 ::v47(){vfunc_called(this, "_ZN7S1312C43v47Ev");}
void  S1312C4 ::v48(){vfunc_called(this, "_ZN7S1312C43v48Ev");}
void  S1312C4 ::v49(){vfunc_called(this, "_ZN7S1312C43v49Ev");}
void  S1312C4 ::v50(){vfunc_called(this, "_ZN7S1312C43v50Ev");}
void  S1312C4 ::v51(){vfunc_called(this, "_ZN7S1312C43v51Ev");}
void  S1312C4 ::v52(){vfunc_called(this, "_ZN7S1312C43v52Ev");}
void  S1312C4 ::v53(){vfunc_called(this, "_ZN7S1312C43v53Ev");}
void  S1312C4 ::v54(){vfunc_called(this, "_ZN7S1312C43v54Ev");}
void  S1312C4 ::v55(){vfunc_called(this, "_ZN7S1312C43v55Ev");}
void  S1312C4 ::v56(){vfunc_called(this, "_ZN7S1312C43v56Ev");}
void  S1312C4 ::v57(){vfunc_called(this, "_ZN7S1312C43v57Ev");}
void  S1312C4 ::v58(){vfunc_called(this, "_ZN7S1312C43v58Ev");}
void  S1312C4 ::v59(){vfunc_called(this, "_ZN7S1312C43v59Ev");}
void  S1312C4 ::v60(){vfunc_called(this, "_ZN7S1312C43v60Ev");}
void  S1312C4 ::v61(){vfunc_called(this, "_ZN7S1312C43v61Ev");}
void  S1312C4 ::v62(){vfunc_called(this, "_ZN7S1312C43v62Ev");}
void  S1312C4 ::v63(){vfunc_called(this, "_ZN7S1312C43v63Ev");}
void  S1312C4 ::v64(){vfunc_called(this, "_ZN7S1312C43v64Ev");}
void  S1312C4 ::v65(){vfunc_called(this, "_ZN7S1312C43v65Ev");}
void  S1312C4 ::v66(){vfunc_called(this, "_ZN7S1312C43v66Ev");}
void  S1312C4 ::v67(){vfunc_called(this, "_ZN7S1312C43v67Ev");}
void  S1312C4 ::v68(){vfunc_called(this, "_ZN7S1312C43v68Ev");}
void  S1312C4 ::v69(){vfunc_called(this, "_ZN7S1312C43v69Ev");}
void  S1312C4 ::v70(){vfunc_called(this, "_ZN7S1312C43v70Ev");}
void  S1312C4 ::v71(){vfunc_called(this, "_ZN7S1312C43v71Ev");}
void  S1312C4 ::v72(){vfunc_called(this, "_ZN7S1312C43v72Ev");}
void  S1312C4 ::v73(){vfunc_called(this, "_ZN7S1312C43v73Ev");}
void  S1312C4 ::v74(){vfunc_called(this, "_ZN7S1312C43v74Ev");}
void  S1312C4 ::v75(){vfunc_called(this, "_ZN7S1312C43v75Ev");}
void  S1312C4 ::v76(){vfunc_called(this, "_ZN7S1312C43v76Ev");}
S1312C4 ::S1312C4(){ note_ctor("S1312C4", this);} // tgen

static void Test_S1312C4()
{
  extern Class_Descriptor cd_S1312C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1312C4, buf);
    S1312C4 *dp, &lv = *(dp=new (buf) S1312C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1312C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1312C4)");
    check_field_offset(lv, s1312c4f0, ABISELECT(8,4), "S1312C4.s1312c4f0");
    check_field_offset(lv, s1312c4f1, ABISELECT(16,8), "S1312C4.s1312c4f1");
    check_field_offset(lv, s1312c4f2, ABISELECT(24,16), "S1312C4.s1312c4f2");
    check_field_offset(lv, s1312c4f3, ABISELECT(56,32), "S1312C4.s1312c4f3");
    check_field_offset(lv, s1312c4f4, ABISELECT(64,40), "S1312C4.s1312c4f4");
    check_field_offset(lv, s1312c4f5, ABISELECT(72,44), "S1312C4.s1312c4f5");
    check_field_offset(lv, s1312c4f6, ABISELECT(80,52), "S1312C4.s1312c4f6");
    test_class_info(&lv, &cd_S1312C4);
    dp->~S1312C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1312C4(Test_S1312C4, "S1312C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1312C4C1Ev();
extern void _ZN7S1312C4D1Ev();
Name_Map name_map_S1312C4[] = {
  NSPAIR(_ZN7S1312C4C1Ev),
  NSPAIR(_ZN7S1312C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1312C4[];
extern void _ZN7S1312C4D1Ev();
extern void _ZN7S1312C4D0Ev();
extern void _ZN7S1312C43v13Ev();
extern void _ZN7S1312C43v14Ev();
extern void _ZN7S1312C43v15Ev();
extern void _ZN7S1312C43v16Ev();
extern void _ZN7S1312C43v17Ev();
extern void _ZN7S1312C43v18Ev();
extern void _ZN7S1312C43v19Ev();
extern void _ZN7S1312C43v20Ev();
extern void _ZN7S1312C43v21Ev();
extern void _ZN7S1312C43v22Ev();
extern void _ZN7S1312C43v23Ev();
extern void _ZN7S1312C43v24Ev();
extern void _ZN7S1312C43v25Ev();
extern void _ZN7S1312C43v26Ev();
extern void _ZN7S1312C43v27Ev();
extern void _ZN7S1312C43v28Ev();
extern void _ZN7S1312C43v29Ev();
extern void _ZN7S1312C43v30Ev();
extern void _ZN7S1312C43v31Ev();
extern void _ZN7S1312C43v32Ev();
extern void _ZN7S1312C43v33Ev();
extern void _ZN7S1312C43v34Ev();
extern void _ZN7S1312C43v35Ev();
extern void _ZN7S1312C43v36Ev();
extern void _ZN7S1312C43v37Ev();
extern void _ZN7S1312C43v38Ev();
extern void _ZN7S1312C43v39Ev();
extern void _ZN7S1312C43v40Ev();
extern void _ZN7S1312C43v41Ev();
extern void _ZN7S1312C43v42Ev();
extern void _ZN7S1312C43v43Ev();
extern void _ZN7S1312C43v44Ev();
extern void _ZN7S1312C43v45Ev();
extern void _ZN7S1312C43v46Ev();
extern void _ZN7S1312C43v47Ev();
extern void _ZN7S1312C43v48Ev();
extern void _ZN7S1312C43v49Ev();
extern void _ZN7S1312C43v50Ev();
extern void _ZN7S1312C43v51Ev();
extern void _ZN7S1312C43v52Ev();
extern void _ZN7S1312C43v53Ev();
extern void _ZN7S1312C43v54Ev();
extern void _ZN7S1312C43v55Ev();
extern void _ZN7S1312C43v56Ev();
extern void _ZN7S1312C43v57Ev();
extern void _ZN7S1312C43v58Ev();
extern void _ZN7S1312C43v59Ev();
extern void _ZN7S1312C43v60Ev();
extern void _ZN7S1312C43v61Ev();
extern void _ZN7S1312C43v62Ev();
extern void _ZN7S1312C43v63Ev();
extern void _ZN7S1312C43v64Ev();
extern void _ZN7S1312C43v65Ev();
extern void _ZN7S1312C43v66Ev();
extern void _ZN7S1312C43v67Ev();
extern void _ZN7S1312C43v68Ev();
extern void _ZN7S1312C43v69Ev();
extern void _ZN7S1312C43v70Ev();
extern void _ZN7S1312C43v71Ev();
extern void _ZN7S1312C43v72Ev();
extern void _ZN7S1312C43v73Ev();
extern void _ZN7S1312C43v74Ev();
extern void _ZN7S1312C43v75Ev();
extern void _ZN7S1312C43v76Ev();
static  VTBL_ENTRY vtc_S1312C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1312C4[0]),
  (VTBL_ENTRY)&_ZN7S1312C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1312C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v76Ev,
};
extern VTBL_ENTRY _ZTI7S1312C4[];
extern  VTBL_ENTRY _ZTV7S1312C4[];
Class_Descriptor cd_S1312C4 = {  "S1312C4", // class name
  0,0,//no base classes
  &(vtc_S1312C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1312C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1312C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1312C3  : S1312C4 {
  int s1312c3f0[2];
  void *s1312c3f1;
  int s1312c3f2[2];
  ::S473C7_nt s1312c3f3;
  ::S473C7_nt s1312c3f4;
  ::S21925C42 s1312c3f5;
  ::S473C7_nt s1312c3f6;
  unsigned int s1312c3f7:1;
  unsigned int s1312c3f8:1;
  unsigned int s1312c3f9:1;
  unsigned int s1312c3f10:1;
  unsigned int s1312c3f11:1;
  int s1312c3f12[2];
  virtual  ~S1312C3(); // _ZN7S1312C3D1Ev
  virtual void  v77(); // _ZN7S1312C33v77Ev
  virtual void  v78(); // _ZN7S1312C33v78Ev
  virtual void  v79(); // _ZN7S1312C33v79Ev
  virtual void  v80(); // _ZN7S1312C33v80Ev
  virtual void  v81(); // _ZN7S1312C33v81Ev
  virtual void  v82(); // _ZN7S1312C33v82Ev
  virtual void  v83(); // _ZN7S1312C33v83Ev
  virtual void  v84(); // _ZN7S1312C33v84Ev
  virtual void  v85(); // _ZN7S1312C33v85Ev
  virtual void  v86(); // _ZN7S1312C33v86Ev
  virtual void  v87(); // _ZN7S1312C33v87Ev
  virtual void  v88(); // _ZN7S1312C33v88Ev
  virtual void  v89(); // _ZN7S1312C33v89Ev
  virtual void  v90(); // _ZN7S1312C33v90Ev
  virtual void  v91(); // _ZN7S1312C33v91Ev
  virtual void  v92(); // _ZN7S1312C33v92Ev
  virtual void  v93(); // _ZN7S1312C33v93Ev
  virtual void  v94(); // _ZN7S1312C33v94Ev
  virtual void  v95(); // _ZN7S1312C33v95Ev
  virtual void  v96(); // _ZN7S1312C33v96Ev
  virtual void  v97(); // _ZN7S1312C33v97Ev
  virtual void  v98(); // _ZN7S1312C33v98Ev
  S1312C3(); // tgen
};
//SIG(-1 S1312C3) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S1312C3 ::~S1312C3(){ note_dtor("S1312C3", this);}
void  S1312C3 ::v77(){vfunc_called(this, "_ZN7S1312C33v77Ev");}
void  S1312C3 ::v78(){vfunc_called(this, "_ZN7S1312C33v78Ev");}
void  S1312C3 ::v79(){vfunc_called(this, "_ZN7S1312C33v79Ev");}
void  S1312C3 ::v80(){vfunc_called(this, "_ZN7S1312C33v80Ev");}
void  S1312C3 ::v81(){vfunc_called(this, "_ZN7S1312C33v81Ev");}
void  S1312C3 ::v82(){vfunc_called(this, "_ZN7S1312C33v82Ev");}
void  S1312C3 ::v83(){vfunc_called(this, "_ZN7S1312C33v83Ev");}
void  S1312C3 ::v84(){vfunc_called(this, "_ZN7S1312C33v84Ev");}
void  S1312C3 ::v85(){vfunc_called(this, "_ZN7S1312C33v85Ev");}
void  S1312C3 ::v86(){vfunc_called(this, "_ZN7S1312C33v86Ev");}
void  S1312C3 ::v87(){vfunc_called(this, "_ZN7S1312C33v87Ev");}
void  S1312C3 ::v88(){vfunc_called(this, "_ZN7S1312C33v88Ev");}
void  S1312C3 ::v89(){vfunc_called(this, "_ZN7S1312C33v89Ev");}
void  S1312C3 ::v90(){vfunc_called(this, "_ZN7S1312C33v90Ev");}
void  S1312C3 ::v91(){vfunc_called(this, "_ZN7S1312C33v91Ev");}
void  S1312C3 ::v92(){vfunc_called(this, "_ZN7S1312C33v92Ev");}
void  S1312C3 ::v93(){vfunc_called(this, "_ZN7S1312C33v93Ev");}
void  S1312C3 ::v94(){vfunc_called(this, "_ZN7S1312C33v94Ev");}
void  S1312C3 ::v95(){vfunc_called(this, "_ZN7S1312C33v95Ev");}
void  S1312C3 ::v96(){vfunc_called(this, "_ZN7S1312C33v96Ev");}
void  S1312C3 ::v97(){vfunc_called(this, "_ZN7S1312C33v97Ev");}
void  S1312C3 ::v98(){vfunc_called(this, "_ZN7S1312C33v98Ev");}
S1312C3 ::S1312C3(){ note_ctor("S1312C3", this);} // tgen

static void Test_S1312C3()
{
  extern Class_Descriptor cd_S1312C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S1312C3, buf);
    S1312C3 *dp, &lv = *(dp=new (buf) S1312C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S1312C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1312C3)");
    check_base_class_offset(lv, (S1312C4*), 0, "S1312C3");
    check_field_offset(lv, s1312c3f0, ABISELECT(96,60), "S1312C3.s1312c3f0");
    check_field_offset(lv, s1312c3f1, ABISELECT(104,68), "S1312C3.s1312c3f1");
    check_field_offset(lv, s1312c3f2, ABISELECT(112,72), "S1312C3.s1312c3f2");
    check_field_offset(lv, s1312c3f3, ABISELECT(120,80), "S1312C3.s1312c3f3");
    check_field_offset(lv, s1312c3f4, ABISELECT(136,92), "S1312C3.s1312c3f4");
    check_field_offset(lv, s1312c3f5, ABISELECT(152,104), "S1312C3.s1312c3f5");
    check_field_offset(lv, s1312c3f6, ABISELECT(160,108), "S1312C3.s1312c3f6");
    set_bf_and_test(lv, s1312c3f7, ABISELECT(176,120), 0, 1, 1, "S1312C3");
    set_bf_and_test(lv, s1312c3f8, ABISELECT(176,120), 1, 1, 1, "S1312C3");
    set_bf_and_test(lv, s1312c3f9, ABISELECT(176,120), 2, 1, 1, "S1312C3");
    set_bf_and_test(lv, s1312c3f10, ABISELECT(176,120), 3, 1, 1, "S1312C3");
    set_bf_and_test(lv, s1312c3f11, ABISELECT(176,120), 4, 1, 1, "S1312C3");
    check_field_offset(lv, s1312c3f12, ABISELECT(180,124), "S1312C3.s1312c3f12");
    test_class_info(&lv, &cd_S1312C3);
    dp->~S1312C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1312C3(Test_S1312C3, "S1312C3", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN7S1312C3C1Ev();
extern void _ZN7S1312C3D1Ev();
Name_Map name_map_S1312C3[] = {
  NSPAIR(_ZN7S1312C3C1Ev),
  NSPAIR(_ZN7S1312C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1312C4;
extern VTBL_ENTRY _ZTI7S1312C4[];
extern  VTBL_ENTRY _ZTV7S1312C4[];
static Base_Class bases_S1312C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1312C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1312C3[];
extern void _ZN7S1312C3D1Ev();
extern void _ZN7S1312C3D0Ev();
extern void _ZN7S1312C43v13Ev();
extern void _ZN7S1312C43v14Ev();
extern void _ZN7S1312C43v15Ev();
extern void _ZN7S1312C43v16Ev();
extern void _ZN7S1312C43v17Ev();
extern void _ZN7S1312C43v18Ev();
extern void _ZN7S1312C43v19Ev();
extern void _ZN7S1312C43v20Ev();
extern void _ZN7S1312C43v21Ev();
extern void _ZN7S1312C43v22Ev();
extern void _ZN7S1312C43v23Ev();
extern void _ZN7S1312C43v24Ev();
extern void _ZN7S1312C43v25Ev();
extern void _ZN7S1312C43v26Ev();
extern void _ZN7S1312C43v27Ev();
extern void _ZN7S1312C43v28Ev();
extern void _ZN7S1312C43v29Ev();
extern void _ZN7S1312C43v30Ev();
extern void _ZN7S1312C43v31Ev();
extern void _ZN7S1312C43v32Ev();
extern void _ZN7S1312C43v33Ev();
extern void _ZN7S1312C43v34Ev();
extern void _ZN7S1312C43v35Ev();
extern void _ZN7S1312C43v36Ev();
extern void _ZN7S1312C43v37Ev();
extern void _ZN7S1312C43v38Ev();
extern void _ZN7S1312C43v39Ev();
extern void _ZN7S1312C43v40Ev();
extern void _ZN7S1312C43v41Ev();
extern void _ZN7S1312C43v42Ev();
extern void _ZN7S1312C43v43Ev();
extern void _ZN7S1312C43v44Ev();
extern void _ZN7S1312C43v45Ev();
extern void _ZN7S1312C43v46Ev();
extern void _ZN7S1312C43v47Ev();
extern void _ZN7S1312C43v48Ev();
extern void _ZN7S1312C43v49Ev();
extern void _ZN7S1312C43v50Ev();
extern void _ZN7S1312C43v51Ev();
extern void _ZN7S1312C43v52Ev();
extern void _ZN7S1312C43v53Ev();
extern void _ZN7S1312C43v54Ev();
extern void _ZN7S1312C43v55Ev();
extern void _ZN7S1312C43v56Ev();
extern void _ZN7S1312C43v57Ev();
extern void _ZN7S1312C43v58Ev();
extern void _ZN7S1312C43v59Ev();
extern void _ZN7S1312C43v60Ev();
extern void _ZN7S1312C43v61Ev();
extern void _ZN7S1312C43v62Ev();
extern void _ZN7S1312C43v63Ev();
extern void _ZN7S1312C43v64Ev();
extern void _ZN7S1312C43v65Ev();
extern void _ZN7S1312C43v66Ev();
extern void _ZN7S1312C43v67Ev();
extern void _ZN7S1312C43v68Ev();
extern void _ZN7S1312C43v69Ev();
extern void _ZN7S1312C43v70Ev();
extern void _ZN7S1312C43v71Ev();
extern void _ZN7S1312C43v72Ev();
extern void _ZN7S1312C43v73Ev();
extern void _ZN7S1312C43v74Ev();
extern void _ZN7S1312C43v75Ev();
extern void _ZN7S1312C43v76Ev();
extern void _ZN7S1312C33v77Ev();
extern void _ZN7S1312C33v78Ev();
extern void _ZN7S1312C33v79Ev();
extern void _ZN7S1312C33v80Ev();
extern void _ZN7S1312C33v81Ev();
extern void _ZN7S1312C33v82Ev();
extern void _ZN7S1312C33v83Ev();
extern void _ZN7S1312C33v84Ev();
extern void _ZN7S1312C33v85Ev();
extern void _ZN7S1312C33v86Ev();
extern void _ZN7S1312C33v87Ev();
extern void _ZN7S1312C33v88Ev();
extern void _ZN7S1312C33v89Ev();
extern void _ZN7S1312C33v90Ev();
extern void _ZN7S1312C33v91Ev();
extern void _ZN7S1312C33v92Ev();
extern void _ZN7S1312C33v93Ev();
extern void _ZN7S1312C33v94Ev();
extern void _ZN7S1312C33v95Ev();
extern void _ZN7S1312C33v96Ev();
extern void _ZN7S1312C33v97Ev();
extern void _ZN7S1312C33v98Ev();
static  VTBL_ENTRY vtc_S1312C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1312C3[0]),
  (VTBL_ENTRY)&_ZN7S1312C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1312C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v98Ev,
};
extern VTBL_ENTRY _ZTI7S1312C3[];
extern  VTBL_ENTRY _ZTV7S1312C3[];
Class_Descriptor cd_S1312C3 = {  "S1312C3", // class name
  bases_S1312C3, 1,
  &(vtc_S1312C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI7S1312C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1312C3),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1312C2  : S1312C3 {
  ::S473C6_nt s1312c2f0;
  virtual  ~S1312C2(); // _ZN7S1312C2D1Ev
  virtual void  v99(); // _ZN7S1312C23v99Ev
  virtual void  v100(); // _ZN7S1312C24v100Ev
  virtual void  v101(); // _ZN7S1312C24v101Ev
  virtual void  v102(); // _ZN7S1312C24v102Ev
  virtual void  v103(); // _ZN7S1312C24v103Ev
  virtual void  v104(); // _ZN7S1312C24v104Ev
  virtual void  v105(); // _ZN7S1312C24v105Ev
  virtual void  v106(); // _ZN7S1312C24v106Ev
  virtual void  v107(); // _ZN7S1312C24v107Ev
  virtual void  v108(); // _ZN7S1312C24v108Ev
  virtual void  v109(); // _ZN7S1312C24v109Ev
  virtual void  v110(); // _ZN7S1312C24v110Ev
  virtual void  v111(); // _ZN7S1312C24v111Ev
  virtual void  v112(); // _ZN7S1312C24v112Ev
  virtual void  v113(); // _ZN7S1312C24v113Ev
  virtual void  v114(); // _ZN7S1312C24v114Ev
  virtual void  v115(); // _ZN7S1312C24v115Ev
  virtual void  v116(); // _ZN7S1312C24v116Ev
  virtual void  v117(); // _ZN7S1312C24v117Ev
  S1312C2(); // tgen
};
//SIG(-1 S1312C2) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S1312C2 ::~S1312C2(){ note_dtor("S1312C2", this);}
void  S1312C2 ::v99(){vfunc_called(this, "_ZN7S1312C23v99Ev");}
void  S1312C2 ::v100(){vfunc_called(this, "_ZN7S1312C24v100Ev");}
void  S1312C2 ::v101(){vfunc_called(this, "_ZN7S1312C24v101Ev");}
void  S1312C2 ::v102(){vfunc_called(this, "_ZN7S1312C24v102Ev");}
void  S1312C2 ::v103(){vfunc_called(this, "_ZN7S1312C24v103Ev");}
void  S1312C2 ::v104(){vfunc_called(this, "_ZN7S1312C24v104Ev");}
void  S1312C2 ::v105(){vfunc_called(this, "_ZN7S1312C24v105Ev");}
void  S1312C2 ::v106(){vfunc_called(this, "_ZN7S1312C24v106Ev");}
void  S1312C2 ::v107(){vfunc_called(this, "_ZN7S1312C24v107Ev");}
void  S1312C2 ::v108(){vfunc_called(this, "_ZN7S1312C24v108Ev");}
void  S1312C2 ::v109(){vfunc_called(this, "_ZN7S1312C24v109Ev");}
void  S1312C2 ::v110(){vfunc_called(this, "_ZN7S1312C24v110Ev");}
void  S1312C2 ::v111(){vfunc_called(this, "_ZN7S1312C24v111Ev");}
void  S1312C2 ::v112(){vfunc_called(this, "_ZN7S1312C24v112Ev");}
void  S1312C2 ::v113(){vfunc_called(this, "_ZN7S1312C24v113Ev");}
void  S1312C2 ::v114(){vfunc_called(this, "_ZN7S1312C24v114Ev");}
void  S1312C2 ::v115(){vfunc_called(this, "_ZN7S1312C24v115Ev");}
void  S1312C2 ::v116(){vfunc_called(this, "_ZN7S1312C24v116Ev");}
void  S1312C2 ::v117(){vfunc_called(this, "_ZN7S1312C24v117Ev");}
S1312C2 ::S1312C2(){ note_ctor("S1312C2", this);} // tgen

static void Test_S1312C2()
{
  extern Class_Descriptor cd_S1312C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S1312C2, buf);
    S1312C2 *dp, &lv = *(dp=new (buf) S1312C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S1312C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1312C2)");
    check_base_class_offset(lv, (S1312C4*)(S1312C3*), 0, "S1312C2");
    check_base_class_offset(lv, (S1312C3*), 0, "S1312C2");
    check_field_offset(lv, s1312c2f0, ABISELECT(188,132), "S1312C2.s1312c2f0");
    test_class_info(&lv, &cd_S1312C2);
    dp->~S1312C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1312C2(Test_S1312C2, "S1312C2", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN7S1312C2C1Ev();
extern void _ZN7S1312C2D1Ev();
Name_Map name_map_S1312C2[] = {
  NSPAIR(_ZN7S1312C2C1Ev),
  NSPAIR(_ZN7S1312C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1312C4;
extern VTBL_ENTRY _ZTI7S1312C4[];
extern  VTBL_ENTRY _ZTV7S1312C4[];
extern Class_Descriptor cd_S1312C3;
extern VTBL_ENTRY _ZTI7S1312C3[];
extern  VTBL_ENTRY _ZTV7S1312C3[];
static Base_Class bases_S1312C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1312C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1312C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1312C2[];
extern void _ZN7S1312C2D1Ev();
extern void _ZN7S1312C2D0Ev();
extern void _ZN7S1312C43v13Ev();
extern void _ZN7S1312C43v14Ev();
extern void _ZN7S1312C43v15Ev();
extern void _ZN7S1312C43v16Ev();
extern void _ZN7S1312C43v17Ev();
extern void _ZN7S1312C43v18Ev();
extern void _ZN7S1312C43v19Ev();
extern void _ZN7S1312C43v20Ev();
extern void _ZN7S1312C43v21Ev();
extern void _ZN7S1312C43v22Ev();
extern void _ZN7S1312C43v23Ev();
extern void _ZN7S1312C43v24Ev();
extern void _ZN7S1312C43v25Ev();
extern void _ZN7S1312C43v26Ev();
extern void _ZN7S1312C43v27Ev();
extern void _ZN7S1312C43v28Ev();
extern void _ZN7S1312C43v29Ev();
extern void _ZN7S1312C43v30Ev();
extern void _ZN7S1312C43v31Ev();
extern void _ZN7S1312C43v32Ev();
extern void _ZN7S1312C43v33Ev();
extern void _ZN7S1312C43v34Ev();
extern void _ZN7S1312C43v35Ev();
extern void _ZN7S1312C43v36Ev();
extern void _ZN7S1312C43v37Ev();
extern void _ZN7S1312C43v38Ev();
extern void _ZN7S1312C43v39Ev();
extern void _ZN7S1312C43v40Ev();
extern void _ZN7S1312C43v41Ev();
extern void _ZN7S1312C43v42Ev();
extern void _ZN7S1312C43v43Ev();
extern void _ZN7S1312C43v44Ev();
extern void _ZN7S1312C43v45Ev();
extern void _ZN7S1312C43v46Ev();
extern void _ZN7S1312C43v47Ev();
extern void _ZN7S1312C43v48Ev();
extern void _ZN7S1312C43v49Ev();
extern void _ZN7S1312C43v50Ev();
extern void _ZN7S1312C43v51Ev();
extern void _ZN7S1312C43v52Ev();
extern void _ZN7S1312C43v53Ev();
extern void _ZN7S1312C43v54Ev();
extern void _ZN7S1312C43v55Ev();
extern void _ZN7S1312C43v56Ev();
extern void _ZN7S1312C43v57Ev();
extern void _ZN7S1312C43v58Ev();
extern void _ZN7S1312C43v59Ev();
extern void _ZN7S1312C43v60Ev();
extern void _ZN7S1312C43v61Ev();
extern void _ZN7S1312C43v62Ev();
extern void _ZN7S1312C43v63Ev();
extern void _ZN7S1312C43v64Ev();
extern void _ZN7S1312C43v65Ev();
extern void _ZN7S1312C43v66Ev();
extern void _ZN7S1312C43v67Ev();
extern void _ZN7S1312C43v68Ev();
extern void _ZN7S1312C43v69Ev();
extern void _ZN7S1312C43v70Ev();
extern void _ZN7S1312C43v71Ev();
extern void _ZN7S1312C43v72Ev();
extern void _ZN7S1312C43v73Ev();
extern void _ZN7S1312C43v74Ev();
extern void _ZN7S1312C43v75Ev();
extern void _ZN7S1312C43v76Ev();
extern void _ZN7S1312C33v77Ev();
extern void _ZN7S1312C33v78Ev();
extern void _ZN7S1312C33v79Ev();
extern void _ZN7S1312C33v80Ev();
extern void _ZN7S1312C33v81Ev();
extern void _ZN7S1312C33v82Ev();
extern void _ZN7S1312C33v83Ev();
extern void _ZN7S1312C33v84Ev();
extern void _ZN7S1312C33v85Ev();
extern void _ZN7S1312C33v86Ev();
extern void _ZN7S1312C33v87Ev();
extern void _ZN7S1312C33v88Ev();
extern void _ZN7S1312C33v89Ev();
extern void _ZN7S1312C33v90Ev();
extern void _ZN7S1312C33v91Ev();
extern void _ZN7S1312C33v92Ev();
extern void _ZN7S1312C33v93Ev();
extern void _ZN7S1312C33v94Ev();
extern void _ZN7S1312C33v95Ev();
extern void _ZN7S1312C33v96Ev();
extern void _ZN7S1312C33v97Ev();
extern void _ZN7S1312C33v98Ev();
extern void _ZN7S1312C23v99Ev();
extern void _ZN7S1312C24v100Ev();
extern void _ZN7S1312C24v101Ev();
extern void _ZN7S1312C24v102Ev();
extern void _ZN7S1312C24v103Ev();
extern void _ZN7S1312C24v104Ev();
extern void _ZN7S1312C24v105Ev();
extern void _ZN7S1312C24v106Ev();
extern void _ZN7S1312C24v107Ev();
extern void _ZN7S1312C24v108Ev();
extern void _ZN7S1312C24v109Ev();
extern void _ZN7S1312C24v110Ev();
extern void _ZN7S1312C24v111Ev();
extern void _ZN7S1312C24v112Ev();
extern void _ZN7S1312C24v113Ev();
extern void _ZN7S1312C24v114Ev();
extern void _ZN7S1312C24v115Ev();
extern void _ZN7S1312C24v116Ev();
extern void _ZN7S1312C24v117Ev();
static  VTBL_ENTRY vtc_S1312C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1312C2[0]),
  (VTBL_ENTRY)&_ZN7S1312C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1312C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1312C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v112Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v113Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v114Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v115Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v116Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v117Ev,
};
extern VTBL_ENTRY _ZTI7S1312C2[];
extern  VTBL_ENTRY _ZTV7S1312C2[];
Class_Descriptor cd_S1312C2 = {  "S1312C2", // class name
  bases_S1312C2, 2,
  &(vtc_S1312C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI7S1312C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1312C2),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1312C1  : S1312C2 {
  ::S672C14_nt s1312c1f0;
  int s1312c1f1[3];
  ::S473C7_nt s1312c1f2;
  void *s1312c1f3;
  virtual  ~S1312C1(); // _ZN7S1312C1D1Ev
  virtual void  v1(); // _ZN7S1312C12v1Ev
  virtual void  v2(); // _ZN7S1312C12v2Ev
  virtual void  v3(); // _ZN7S1312C12v3Ev
  virtual void  v4(); // _ZN7S1312C12v4Ev
  virtual void  v5(); // _ZN7S1312C12v5Ev
  virtual void  v6(); // _ZN7S1312C12v6Ev
  virtual void  v7(); // _ZN7S1312C12v7Ev
  virtual void  v8(); // _ZN7S1312C12v8Ev
  virtual void  v9(); // _ZN7S1312C12v9Ev
  virtual void  v10(); // _ZN7S1312C13v10Ev
  virtual void  v11(); // _ZN7S1312C13v11Ev
  virtual void  v12(); // _ZN7S1312C13v12Ev
  S1312C1(); // tgen
};
//SIG(1 S1312C1) C1{ BC2{ BC3{ BC4{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 FC5} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 FC11{ BC12{ BC9}} Fi[3] FC6 Fp}


 S1312C1 ::~S1312C1(){ note_dtor("S1312C1", this);}
void  S1312C1 ::v1(){vfunc_called(this, "_ZN7S1312C12v1Ev");}
void  S1312C1 ::v2(){vfunc_called(this, "_ZN7S1312C12v2Ev");}
void  S1312C1 ::v3(){vfunc_called(this, "_ZN7S1312C12v3Ev");}
void  S1312C1 ::v4(){vfunc_called(this, "_ZN7S1312C12v4Ev");}
void  S1312C1 ::v5(){vfunc_called(this, "_ZN7S1312C12v5Ev");}
void  S1312C1 ::v6(){vfunc_called(this, "_ZN7S1312C12v6Ev");}
void  S1312C1 ::v7(){vfunc_called(this, "_ZN7S1312C12v7Ev");}
void  S1312C1 ::v8(){vfunc_called(this, "_ZN7S1312C12v8Ev");}
void  S1312C1 ::v9(){vfunc_called(this, "_ZN7S1312C12v9Ev");}
void  S1312C1 ::v10(){vfunc_called(this, "_ZN7S1312C13v10Ev");}
void  S1312C1 ::v11(){vfunc_called(this, "_ZN7S1312C13v11Ev");}
void  S1312C1 ::v12(){vfunc_called(this, "_ZN7S1312C13v12Ev");}
S1312C1 ::S1312C1(){ note_ctor("S1312C1", this);} // tgen

static void Test_S1312C1()
{
  extern Class_Descriptor cd_S1312C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,46)];
    init_test(&cd_S1312C1, buf);
    S1312C1 *dp, &lv = *(dp=new (buf) S1312C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,180), "sizeof(S1312C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1312C1)");
    check_base_class_offset(lv, (S1312C4*)(S1312C3*)(S1312C2*), 0, "S1312C1");
    check_base_class_offset(lv, (S1312C3*)(S1312C2*), 0, "S1312C1");
    check_base_class_offset(lv, (S1312C2*), 0, "S1312C1");
    check_field_offset(lv, s1312c1f0, ABISELECT(200,140), "S1312C1.s1312c1f0");
    check_field_offset(lv, s1312c1f1, ABISELECT(216,152), "S1312C1.s1312c1f1");
    check_field_offset(lv, s1312c1f2, ABISELECT(232,164), "S1312C1.s1312c1f2");
    check_field_offset(lv, s1312c1f3, ABISELECT(248,176), "S1312C1.s1312c1f3");
    test_class_info(&lv, &cd_S1312C1);
    dp->~S1312C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1312C1(Test_S1312C1, "S1312C1", ABISELECT(256,180));

#else // __cplusplus

extern void _ZN7S1312C1C1Ev();
extern void _ZN7S1312C1D1Ev();
Name_Map name_map_S1312C1[] = {
  NSPAIR(_ZN7S1312C1C1Ev),
  NSPAIR(_ZN7S1312C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1312C4;
extern VTBL_ENTRY _ZTI7S1312C4[];
extern  VTBL_ENTRY _ZTV7S1312C4[];
extern Class_Descriptor cd_S1312C3;
extern VTBL_ENTRY _ZTI7S1312C3[];
extern  VTBL_ENTRY _ZTV7S1312C3[];
extern Class_Descriptor cd_S1312C2;
extern VTBL_ENTRY _ZTI7S1312C2[];
extern  VTBL_ENTRY _ZTV7S1312C2[];
static Base_Class bases_S1312C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1312C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1312C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1312C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1312C1[];
extern void _ZN7S1312C1D1Ev();
extern void _ZN7S1312C1D0Ev();
extern void _ZN7S1312C43v13Ev();
extern void _ZN7S1312C43v14Ev();
extern void _ZN7S1312C43v15Ev();
extern void _ZN7S1312C43v16Ev();
extern void _ZN7S1312C43v17Ev();
extern void _ZN7S1312C43v18Ev();
extern void _ZN7S1312C43v19Ev();
extern void _ZN7S1312C43v20Ev();
extern void _ZN7S1312C43v21Ev();
extern void _ZN7S1312C43v22Ev();
extern void _ZN7S1312C43v23Ev();
extern void _ZN7S1312C43v24Ev();
extern void _ZN7S1312C43v25Ev();
extern void _ZN7S1312C43v26Ev();
extern void _ZN7S1312C43v27Ev();
extern void _ZN7S1312C43v28Ev();
extern void _ZN7S1312C43v29Ev();
extern void _ZN7S1312C43v30Ev();
extern void _ZN7S1312C43v31Ev();
extern void _ZN7S1312C43v32Ev();
extern void _ZN7S1312C43v33Ev();
extern void _ZN7S1312C43v34Ev();
extern void _ZN7S1312C43v35Ev();
extern void _ZN7S1312C43v36Ev();
extern void _ZN7S1312C43v37Ev();
extern void _ZN7S1312C43v38Ev();
extern void _ZN7S1312C43v39Ev();
extern void _ZN7S1312C43v40Ev();
extern void _ZN7S1312C43v41Ev();
extern void _ZN7S1312C43v42Ev();
extern void _ZN7S1312C43v43Ev();
extern void _ZN7S1312C43v44Ev();
extern void _ZN7S1312C43v45Ev();
extern void _ZN7S1312C43v46Ev();
extern void _ZN7S1312C43v47Ev();
extern void _ZN7S1312C43v48Ev();
extern void _ZN7S1312C43v49Ev();
extern void _ZN7S1312C43v50Ev();
extern void _ZN7S1312C43v51Ev();
extern void _ZN7S1312C43v52Ev();
extern void _ZN7S1312C43v53Ev();
extern void _ZN7S1312C43v54Ev();
extern void _ZN7S1312C43v55Ev();
extern void _ZN7S1312C43v56Ev();
extern void _ZN7S1312C43v57Ev();
extern void _ZN7S1312C43v58Ev();
extern void _ZN7S1312C43v59Ev();
extern void _ZN7S1312C43v60Ev();
extern void _ZN7S1312C43v61Ev();
extern void _ZN7S1312C43v62Ev();
extern void _ZN7S1312C43v63Ev();
extern void _ZN7S1312C43v64Ev();
extern void _ZN7S1312C43v65Ev();
extern void _ZN7S1312C43v66Ev();
extern void _ZN7S1312C43v67Ev();
extern void _ZN7S1312C43v68Ev();
extern void _ZN7S1312C43v69Ev();
extern void _ZN7S1312C43v70Ev();
extern void _ZN7S1312C43v71Ev();
extern void _ZN7S1312C43v72Ev();
extern void _ZN7S1312C43v73Ev();
extern void _ZN7S1312C43v74Ev();
extern void _ZN7S1312C43v75Ev();
extern void _ZN7S1312C43v76Ev();
extern void _ZN7S1312C33v77Ev();
extern void _ZN7S1312C33v78Ev();
extern void _ZN7S1312C33v79Ev();
extern void _ZN7S1312C33v80Ev();
extern void _ZN7S1312C33v81Ev();
extern void _ZN7S1312C33v82Ev();
extern void _ZN7S1312C33v83Ev();
extern void _ZN7S1312C33v84Ev();
extern void _ZN7S1312C33v85Ev();
extern void _ZN7S1312C33v86Ev();
extern void _ZN7S1312C33v87Ev();
extern void _ZN7S1312C33v88Ev();
extern void _ZN7S1312C33v89Ev();
extern void _ZN7S1312C33v90Ev();
extern void _ZN7S1312C33v91Ev();
extern void _ZN7S1312C33v92Ev();
extern void _ZN7S1312C33v93Ev();
extern void _ZN7S1312C33v94Ev();
extern void _ZN7S1312C33v95Ev();
extern void _ZN7S1312C33v96Ev();
extern void _ZN7S1312C33v97Ev();
extern void _ZN7S1312C33v98Ev();
extern void _ZN7S1312C23v99Ev();
extern void _ZN7S1312C24v100Ev();
extern void _ZN7S1312C24v101Ev();
extern void _ZN7S1312C24v102Ev();
extern void _ZN7S1312C24v103Ev();
extern void _ZN7S1312C24v104Ev();
extern void _ZN7S1312C24v105Ev();
extern void _ZN7S1312C24v106Ev();
extern void _ZN7S1312C24v107Ev();
extern void _ZN7S1312C24v108Ev();
extern void _ZN7S1312C24v109Ev();
extern void _ZN7S1312C24v110Ev();
extern void _ZN7S1312C24v111Ev();
extern void _ZN7S1312C24v112Ev();
extern void _ZN7S1312C24v113Ev();
extern void _ZN7S1312C24v114Ev();
extern void _ZN7S1312C24v115Ev();
extern void _ZN7S1312C24v116Ev();
extern void _ZN7S1312C24v117Ev();
extern void _ZN7S1312C12v1Ev();
extern void _ZN7S1312C12v2Ev();
extern void _ZN7S1312C12v3Ev();
extern void _ZN7S1312C12v4Ev();
extern void _ZN7S1312C12v5Ev();
extern void _ZN7S1312C12v6Ev();
extern void _ZN7S1312C12v7Ev();
extern void _ZN7S1312C12v8Ev();
extern void _ZN7S1312C12v9Ev();
extern void _ZN7S1312C13v10Ev();
extern void _ZN7S1312C13v11Ev();
extern void _ZN7S1312C13v12Ev();
static  VTBL_ENTRY vtc_S1312C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1312C1[0]),
  (VTBL_ENTRY)&_ZN7S1312C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1312C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1312C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1312C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1312C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v112Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v113Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v114Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v115Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v116Ev,
  (VTBL_ENTRY)&_ZN7S1312C24v117Ev,
  (VTBL_ENTRY)&_ZN7S1312C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1312C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1312C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1312C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1312C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1312C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1312C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1312C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1312C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1312C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1312C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1312C13v12Ev,
};
extern VTBL_ENTRY _ZTI7S1312C1[];
extern  VTBL_ENTRY _ZTV7S1312C1[];
Class_Descriptor cd_S1312C1 = {  "S1312C1", // class name
  bases_S1312C1, 3,
  &(vtc_S1312C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,180), // object size
  NSPAIRA(_ZTI7S1312C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1312C1),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S639C5  {
  int s639c5f0;
  __tsi64 s639c5f1;
  void *s639c5f2[4];
  int s639c5f3[2];
  void *s639c5f4;
  ::S473C6_nt s639c5f5;
  void *s639c5f6[2];
  virtual  ~S639C5(); // _ZN6S639C5D1Ev
  virtual void  v5(); // _ZN6S639C52v5Ev
  virtual void  v6(); // _ZN6S639C52v6Ev
  virtual void  v7(); // _ZN6S639C52v7Ev
  virtual void  v8(); // _ZN6S639C52v8Ev
  virtual void  v9(); // _ZN6S639C52v9Ev
  virtual void  v10(); // _ZN6S639C53v10Ev
  virtual void  v11(); // _ZN6S639C53v11Ev
  virtual void  v12(); // _ZN6S639C53v12Ev
  virtual void  v13(); // _ZN6S639C53v13Ev
  virtual void  v14(); // _ZN6S639C53v14Ev
  virtual void  v15(); // _ZN6S639C53v15Ev
  virtual void  v16(); // _ZN6S639C53v16Ev
  virtual void  v17(); // _ZN6S639C53v17Ev
  virtual void  v18(); // _ZN6S639C53v18Ev
  virtual void  v19(); // _ZN6S639C53v19Ev
  virtual void  v20(); // _ZN6S639C53v20Ev
  virtual void  v21(); // _ZN6S639C53v21Ev
  virtual void  v22(); // _ZN6S639C53v22Ev
  virtual void  v23(); // _ZN6S639C53v23Ev
  virtual void  v24(); // _ZN6S639C53v24Ev
  virtual void  v25(); // _ZN6S639C53v25Ev
  virtual void  v26(); // _ZN6S639C53v26Ev
  virtual void  v27(); // _ZN6S639C53v27Ev
  virtual void  v28(); // _ZN6S639C53v28Ev
  virtual void  v29(); // _ZN6S639C53v29Ev
  virtual void  v30(); // _ZN6S639C53v30Ev
  virtual void  v31(); // _ZN6S639C53v31Ev
  virtual void  v32(); // _ZN6S639C53v32Ev
  virtual void  v33(); // _ZN6S639C53v33Ev
  virtual void  v34(); // _ZN6S639C53v34Ev
  virtual void  v35(); // _ZN6S639C53v35Ev
  virtual void  v36(); // _ZN6S639C53v36Ev
  virtual void  v37(); // _ZN6S639C53v37Ev
  virtual void  v38(); // _ZN6S639C53v38Ev
  virtual void  v39(); // _ZN6S639C53v39Ev
  virtual void  v40(); // _ZN6S639C53v40Ev
  virtual void  v41(); // _ZN6S639C53v41Ev
  virtual void  v42(); // _ZN6S639C53v42Ev
  virtual void  v43(); // _ZN6S639C53v43Ev
  virtual void  v44(); // _ZN6S639C53v44Ev
  virtual void  v45(); // _ZN6S639C53v45Ev
  virtual void  v46(); // _ZN6S639C53v46Ev
  virtual void  v47(); // _ZN6S639C53v47Ev
  virtual void  v48(); // _ZN6S639C53v48Ev
  virtual void  v49(); // _ZN6S639C53v49Ev
  virtual void  v50(); // _ZN6S639C53v50Ev
  virtual void  v51(); // _ZN6S639C53v51Ev
  virtual void  v52(); // _ZN6S639C53v52Ev
  virtual void  v53(); // _ZN6S639C53v53Ev
  virtual void  v54(); // _ZN6S639C53v54Ev
  virtual void  v55(); // _ZN6S639C53v55Ev
  virtual void  v56(); // _ZN6S639C53v56Ev
  virtual void  v57(); // _ZN6S639C53v57Ev
  virtual void  v58(); // _ZN6S639C53v58Ev
  virtual void  v59(); // _ZN6S639C53v59Ev
  virtual void  v60(); // _ZN6S639C53v60Ev
  virtual void  v61(); // _ZN6S639C53v61Ev
  virtual void  v62(); // _ZN6S639C53v62Ev
  virtual void  v63(); // _ZN6S639C53v63Ev
  virtual void  v64(); // _ZN6S639C53v64Ev
  virtual void  v65(); // _ZN6S639C53v65Ev
  virtual void  v66(); // _ZN6S639C53v66Ev
  virtual void  v67(); // _ZN6S639C53v67Ev
  virtual void  v68(); // _ZN6S639C53v68Ev
  S639C5(); // tgen
};
//SIG(-1 S639C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S639C5 ::~S639C5(){ note_dtor("S639C5", this);}
void  S639C5 ::v5(){vfunc_called(this, "_ZN6S639C52v5Ev");}
void  S639C5 ::v6(){vfunc_called(this, "_ZN6S639C52v6Ev");}
void  S639C5 ::v7(){vfunc_called(this, "_ZN6S639C52v7Ev");}
void  S639C5 ::v8(){vfunc_called(this, "_ZN6S639C52v8Ev");}
void  S639C5 ::v9(){vfunc_called(this, "_ZN6S639C52v9Ev");}
void  S639C5 ::v10(){vfunc_called(this, "_ZN6S639C53v10Ev");}
void  S639C5 ::v11(){vfunc_called(this, "_ZN6S639C53v11Ev");}
void  S639C5 ::v12(){vfunc_called(this, "_ZN6S639C53v12Ev");}
void  S639C5 ::v13(){vfunc_called(this, "_ZN6S639C53v13Ev");}
void  S639C5 ::v14(){vfunc_called(this, "_ZN6S639C53v14Ev");}
void  S639C5 ::v15(){vfunc_called(this, "_ZN6S639C53v15Ev");}
void  S639C5 ::v16(){vfunc_called(this, "_ZN6S639C53v16Ev");}
void  S639C5 ::v17(){vfunc_called(this, "_ZN6S639C53v17Ev");}
void  S639C5 ::v18(){vfunc_called(this, "_ZN6S639C53v18Ev");}
void  S639C5 ::v19(){vfunc_called(this, "_ZN6S639C53v19Ev");}
void  S639C5 ::v20(){vfunc_called(this, "_ZN6S639C53v20Ev");}
void  S639C5 ::v21(){vfunc_called(this, "_ZN6S639C53v21Ev");}
void  S639C5 ::v22(){vfunc_called(this, "_ZN6S639C53v22Ev");}
void  S639C5 ::v23(){vfunc_called(this, "_ZN6S639C53v23Ev");}
void  S639C5 ::v24(){vfunc_called(this, "_ZN6S639C53v24Ev");}
void  S639C5 ::v25(){vfunc_called(this, "_ZN6S639C53v25Ev");}
void  S639C5 ::v26(){vfunc_called(this, "_ZN6S639C53v26Ev");}
void  S639C5 ::v27(){vfunc_called(this, "_ZN6S639C53v27Ev");}
void  S639C5 ::v28(){vfunc_called(this, "_ZN6S639C53v28Ev");}
void  S639C5 ::v29(){vfunc_called(this, "_ZN6S639C53v29Ev");}
void  S639C5 ::v30(){vfunc_called(this, "_ZN6S639C53v30Ev");}
void  S639C5 ::v31(){vfunc_called(this, "_ZN6S639C53v31Ev");}
void  S639C5 ::v32(){vfunc_called(this, "_ZN6S639C53v32Ev");}
void  S639C5 ::v33(){vfunc_called(this, "_ZN6S639C53v33Ev");}
void  S639C5 ::v34(){vfunc_called(this, "_ZN6S639C53v34Ev");}
void  S639C5 ::v35(){vfunc_called(this, "_ZN6S639C53v35Ev");}
void  S639C5 ::v36(){vfunc_called(this, "_ZN6S639C53v36Ev");}
void  S639C5 ::v37(){vfunc_called(this, "_ZN6S639C53v37Ev");}
void  S639C5 ::v38(){vfunc_called(this, "_ZN6S639C53v38Ev");}
void  S639C5 ::v39(){vfunc_called(this, "_ZN6S639C53v39Ev");}
void  S639C5 ::v40(){vfunc_called(this, "_ZN6S639C53v40Ev");}
void  S639C5 ::v41(){vfunc_called(this, "_ZN6S639C53v41Ev");}
void  S639C5 ::v42(){vfunc_called(this, "_ZN6S639C53v42Ev");}
void  S639C5 ::v43(){vfunc_called(this, "_ZN6S639C53v43Ev");}
void  S639C5 ::v44(){vfunc_called(this, "_ZN6S639C53v44Ev");}
void  S639C5 ::v45(){vfunc_called(this, "_ZN6S639C53v45Ev");}
void  S639C5 ::v46(){vfunc_called(this, "_ZN6S639C53v46Ev");}
void  S639C5 ::v47(){vfunc_called(this, "_ZN6S639C53v47Ev");}
void  S639C5 ::v48(){vfunc_called(this, "_ZN6S639C53v48Ev");}
void  S639C5 ::v49(){vfunc_called(this, "_ZN6S639C53v49Ev");}
void  S639C5 ::v50(){vfunc_called(this, "_ZN6S639C53v50Ev");}
void  S639C5 ::v51(){vfunc_called(this, "_ZN6S639C53v51Ev");}
void  S639C5 ::v52(){vfunc_called(this, "_ZN6S639C53v52Ev");}
void  S639C5 ::v53(){vfunc_called(this, "_ZN6S639C53v53Ev");}
void  S639C5 ::v54(){vfunc_called(this, "_ZN6S639C53v54Ev");}
void  S639C5 ::v55(){vfunc_called(this, "_ZN6S639C53v55Ev");}
void  S639C5 ::v56(){vfunc_called(this, "_ZN6S639C53v56Ev");}
void  S639C5 ::v57(){vfunc_called(this, "_ZN6S639C53v57Ev");}
void  S639C5 ::v58(){vfunc_called(this, "_ZN6S639C53v58Ev");}
void  S639C5 ::v59(){vfunc_called(this, "_ZN6S639C53v59Ev");}
void  S639C5 ::v60(){vfunc_called(this, "_ZN6S639C53v60Ev");}
void  S639C5 ::v61(){vfunc_called(this, "_ZN6S639C53v61Ev");}
void  S639C5 ::v62(){vfunc_called(this, "_ZN6S639C53v62Ev");}
void  S639C5 ::v63(){vfunc_called(this, "_ZN6S639C53v63Ev");}
void  S639C5 ::v64(){vfunc_called(this, "_ZN6S639C53v64Ev");}
void  S639C5 ::v65(){vfunc_called(this, "_ZN6S639C53v65Ev");}
void  S639C5 ::v66(){vfunc_called(this, "_ZN6S639C53v66Ev");}
void  S639C5 ::v67(){vfunc_called(this, "_ZN6S639C53v67Ev");}
void  S639C5 ::v68(){vfunc_called(this, "_ZN6S639C53v68Ev");}
S639C5 ::S639C5(){ note_ctor("S639C5", this);} // tgen

static void Test_S639C5()
{
  extern Class_Descriptor cd_S639C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S639C5, buf);
    S639C5 *dp, &lv = *(dp=new (buf) S639C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S639C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S639C5)");
    check_field_offset(lv, s639c5f0, ABISELECT(8,4), "S639C5.s639c5f0");
    check_field_offset(lv, s639c5f1, ABISELECT(16,8), "S639C5.s639c5f1");
    check_field_offset(lv, s639c5f2, ABISELECT(24,16), "S639C5.s639c5f2");
    check_field_offset(lv, s639c5f3, ABISELECT(56,32), "S639C5.s639c5f3");
    check_field_offset(lv, s639c5f4, ABISELECT(64,40), "S639C5.s639c5f4");
    check_field_offset(lv, s639c5f5, ABISELECT(72,44), "S639C5.s639c5f5");
    check_field_offset(lv, s639c5f6, ABISELECT(80,52), "S639C5.s639c5f6");
    test_class_info(&lv, &cd_S639C5);
    dp->~S639C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS639C5(Test_S639C5, "S639C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S639C5C1Ev();
extern void _ZN6S639C5D1Ev();
Name_Map name_map_S639C5[] = {
  NSPAIR(_ZN6S639C5C1Ev),
  NSPAIR(_ZN6S639C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S639C5[];
extern void _ZN6S639C5D1Ev();
extern void _ZN6S639C5D0Ev();
extern void _ZN6S639C52v5Ev();
extern void _ZN6S639C52v6Ev();
extern void _ZN6S639C52v7Ev();
extern void _ZN6S639C52v8Ev();
extern void _ZN6S639C52v9Ev();
extern void _ZN6S639C53v10Ev();
extern void _ZN6S639C53v11Ev();
extern void _ZN6S639C53v12Ev();
extern void _ZN6S639C53v13Ev();
extern void _ZN6S639C53v14Ev();
extern void _ZN6S639C53v15Ev();
extern void _ZN6S639C53v16Ev();
extern void _ZN6S639C53v17Ev();
extern void _ZN6S639C53v18Ev();
extern void _ZN6S639C53v19Ev();
extern void _ZN6S639C53v20Ev();
extern void _ZN6S639C53v21Ev();
extern void _ZN6S639C53v22Ev();
extern void _ZN6S639C53v23Ev();
extern void _ZN6S639C53v24Ev();
extern void _ZN6S639C53v25Ev();
extern void _ZN6S639C53v26Ev();
extern void _ZN6S639C53v27Ev();
extern void _ZN6S639C53v28Ev();
extern void _ZN6S639C53v29Ev();
extern void _ZN6S639C53v30Ev();
extern void _ZN6S639C53v31Ev();
extern void _ZN6S639C53v32Ev();
extern void _ZN6S639C53v33Ev();
extern void _ZN6S639C53v34Ev();
extern void _ZN6S639C53v35Ev();
extern void _ZN6S639C53v36Ev();
extern void _ZN6S639C53v37Ev();
extern void _ZN6S639C53v38Ev();
extern void _ZN6S639C53v39Ev();
extern void _ZN6S639C53v40Ev();
extern void _ZN6S639C53v41Ev();
extern void _ZN6S639C53v42Ev();
extern void _ZN6S639C53v43Ev();
extern void _ZN6S639C53v44Ev();
extern void _ZN6S639C53v45Ev();
extern void _ZN6S639C53v46Ev();
extern void _ZN6S639C53v47Ev();
extern void _ZN6S639C53v48Ev();
extern void _ZN6S639C53v49Ev();
extern void _ZN6S639C53v50Ev();
extern void _ZN6S639C53v51Ev();
extern void _ZN6S639C53v52Ev();
extern void _ZN6S639C53v53Ev();
extern void _ZN6S639C53v54Ev();
extern void _ZN6S639C53v55Ev();
extern void _ZN6S639C53v56Ev();
extern void _ZN6S639C53v57Ev();
extern void _ZN6S639C53v58Ev();
extern void _ZN6S639C53v59Ev();
extern void _ZN6S639C53v60Ev();
extern void _ZN6S639C53v61Ev();
extern void _ZN6S639C53v62Ev();
extern void _ZN6S639C53v63Ev();
extern void _ZN6S639C53v64Ev();
extern void _ZN6S639C53v65Ev();
extern void _ZN6S639C53v66Ev();
extern void _ZN6S639C53v67Ev();
extern void _ZN6S639C53v68Ev();
static  VTBL_ENTRY vtc_S639C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S639C5[0]),
  (VTBL_ENTRY)&_ZN6S639C5D1Ev,
  (VTBL_ENTRY)&_ZN6S639C5D0Ev,
  (VTBL_ENTRY)&_ZN6S639C52v5Ev,
  (VTBL_ENTRY)&_ZN6S639C52v6Ev,
  (VTBL_ENTRY)&_ZN6S639C52v7Ev,
  (VTBL_ENTRY)&_ZN6S639C52v8Ev,
  (VTBL_ENTRY)&_ZN6S639C52v9Ev,
  (VTBL_ENTRY)&_ZN6S639C53v10Ev,
  (VTBL_ENTRY)&_ZN6S639C53v11Ev,
  (VTBL_ENTRY)&_ZN6S639C53v12Ev,
  (VTBL_ENTRY)&_ZN6S639C53v13Ev,
  (VTBL_ENTRY)&_ZN6S639C53v14Ev,
  (VTBL_ENTRY)&_ZN6S639C53v15Ev,
  (VTBL_ENTRY)&_ZN6S639C53v16Ev,
  (VTBL_ENTRY)&_ZN6S639C53v17Ev,
  (VTBL_ENTRY)&_ZN6S639C53v18Ev,
  (VTBL_ENTRY)&_ZN6S639C53v19Ev,
  (VTBL_ENTRY)&_ZN6S639C53v20Ev,
  (VTBL_ENTRY)&_ZN6S639C53v21Ev,
  (VTBL_ENTRY)&_ZN6S639C53v22Ev,
  (VTBL_ENTRY)&_ZN6S639C53v23Ev,
  (VTBL_ENTRY)&_ZN6S639C53v24Ev,
  (VTBL_ENTRY)&_ZN6S639C53v25Ev,
  (VTBL_ENTRY)&_ZN6S639C53v26Ev,
  (VTBL_ENTRY)&_ZN6S639C53v27Ev,
  (VTBL_ENTRY)&_ZN6S639C53v28Ev,
  (VTBL_ENTRY)&_ZN6S639C53v29Ev,
  (VTBL_ENTRY)&_ZN6S639C53v30Ev,
  (VTBL_ENTRY)&_ZN6S639C53v31Ev,
  (VTBL_ENTRY)&_ZN6S639C53v32Ev,
  (VTBL_ENTRY)&_ZN6S639C53v33Ev,
  (VTBL_ENTRY)&_ZN6S639C53v34Ev,
  (VTBL_ENTRY)&_ZN6S639C53v35Ev,
  (VTBL_ENTRY)&_ZN6S639C53v36Ev,
  (VTBL_ENTRY)&_ZN6S639C53v37Ev,
  (VTBL_ENTRY)&_ZN6S639C53v38Ev,
  (VTBL_ENTRY)&_ZN6S639C53v39Ev,
  (VTBL_ENTRY)&_ZN6S639C53v40Ev,
  (VTBL_ENTRY)&_ZN6S639C53v41Ev,
  (VTBL_ENTRY)&_ZN6S639C53v42Ev,
  (VTBL_ENTRY)&_ZN6S639C53v43Ev,
  (VTBL_ENTRY)&_ZN6S639C53v44Ev,
  (VTBL_ENTRY)&_ZN6S639C53v45Ev,
  (VTBL_ENTRY)&_ZN6S639C53v46Ev,
  (VTBL_ENTRY)&_ZN6S639C53v47Ev,
  (VTBL_ENTRY)&_ZN6S639C53v48Ev,
  (VTBL_ENTRY)&_ZN6S639C53v49Ev,
  (VTBL_ENTRY)&_ZN6S639C53v50Ev,
  (VTBL_ENTRY)&_ZN6S639C53v51Ev,
  (VTBL_ENTRY)&_ZN6S639C53v52Ev,
  (VTBL_ENTRY)&_ZN6S639C53v53Ev,
  (VTBL_ENTRY)&_ZN6S639C53v54Ev,
  (VTBL_ENTRY)&_ZN6S639C53v55Ev,
  (VTBL_ENTRY)&_ZN6S639C53v56Ev,
  (VTBL_ENTRY)&_ZN6S639C53v57Ev,
  (VTBL_ENTRY)&_ZN6S639C53v58Ev,
  (VTBL_ENTRY)&_ZN6S639C53v59Ev,
  (VTBL_ENTRY)&_ZN6S639C53v60Ev,
  (VTBL_ENTRY)&_ZN6S639C53v61Ev,
  (VTBL_ENTRY)&_ZN6S639C53v62Ev,
  (VTBL_ENTRY)&_ZN6S639C53v63Ev,
  (VTBL_ENTRY)&_ZN6S639C53v64Ev,
  (VTBL_ENTRY)&_ZN6S639C53v65Ev,
  (VTBL_ENTRY)&_ZN6S639C53v66Ev,
  (VTBL_ENTRY)&_ZN6S639C53v67Ev,
  (VTBL_ENTRY)&_ZN6S639C53v68Ev,
};
extern VTBL_ENTRY _ZTI6S639C5[];
extern  VTBL_ENTRY _ZTV6S639C5[];
Class_Descriptor cd_S639C5 = {  "S639C5", // class name
  0,0,//no base classes
  &(vtc_S639C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S639C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S639C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S639C4  : S639C5 {
  int s639c4f0[2];
  void *s639c4f1;
  int s639c4f2[2];
  ::S473C7_nt s639c4f3;
  ::S473C7_nt s639c4f4;
  ::S21925C42 s639c4f5;
  ::S473C7_nt s639c4f6;
  unsigned int s639c4f7:1;
  unsigned int s639c4f8:1;
  unsigned int s639c4f9:1;
  unsigned int s639c4f10:1;
  unsigned int s639c4f11:1;
  int s639c4f12[2];
  virtual  ~S639C4(); // _ZN6S639C4D1Ev
  virtual void  v69(); // _ZN6S639C43v69Ev
  virtual void  v70(); // _ZN6S639C43v70Ev
  virtual void  v71(); // _ZN6S639C43v71Ev
  virtual void  v72(); // _ZN6S639C43v72Ev
  virtual void  v73(); // _ZN6S639C43v73Ev
  virtual void  v74(); // _ZN6S639C43v74Ev
  virtual void  v75(); // _ZN6S639C43v75Ev
  virtual void  v76(); // _ZN6S639C43v76Ev
  virtual void  v77(); // _ZN6S639C43v77Ev
  virtual void  v78(); // _ZN6S639C43v78Ev
  virtual void  v79(); // _ZN6S639C43v79Ev
  virtual void  v80(); // _ZN6S639C43v80Ev
  virtual void  v81(); // _ZN6S639C43v81Ev
  virtual void  v82(); // _ZN6S639C43v82Ev
  virtual void  v83(); // _ZN6S639C43v83Ev
  virtual void  v84(); // _ZN6S639C43v84Ev
  virtual void  v85(); // _ZN6S639C43v85Ev
  virtual void  v86(); // _ZN6S639C43v86Ev
  virtual void  v87(); // _ZN6S639C43v87Ev
  virtual void  v88(); // _ZN6S639C43v88Ev
  virtual void  v89(); // _ZN6S639C43v89Ev
  virtual void  v90(); // _ZN6S639C43v90Ev
  S639C4(); // tgen
};
//SIG(-1 S639C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S639C4 ::~S639C4(){ note_dtor("S639C4", this);}
void  S639C4 ::v69(){vfunc_called(this, "_ZN6S639C43v69Ev");}
void  S639C4 ::v70(){vfunc_called(this, "_ZN6S639C43v70Ev");}
void  S639C4 ::v71(){vfunc_called(this, "_ZN6S639C43v71Ev");}
void  S639C4 ::v72(){vfunc_called(this, "_ZN6S639C43v72Ev");}
void  S639C4 ::v73(){vfunc_called(this, "_ZN6S639C43v73Ev");}
void  S639C4 ::v74(){vfunc_called(this, "_ZN6S639C43v74Ev");}
void  S639C4 ::v75(){vfunc_called(this, "_ZN6S639C43v75Ev");}
void  S639C4 ::v76(){vfunc_called(this, "_ZN6S639C43v76Ev");}
void  S639C4 ::v77(){vfunc_called(this, "_ZN6S639C43v77Ev");}
void  S639C4 ::v78(){vfunc_called(this, "_ZN6S639C43v78Ev");}
void  S639C4 ::v79(){vfunc_called(this, "_ZN6S639C43v79Ev");}
void  S639C4 ::v80(){vfunc_called(this, "_ZN6S639C43v80Ev");}
void  S639C4 ::v81(){vfunc_called(this, "_ZN6S639C43v81Ev");}
void  S639C4 ::v82(){vfunc_called(this, "_ZN6S639C43v82Ev");}
void  S639C4 ::v83(){vfunc_called(this, "_ZN6S639C43v83Ev");}
void  S639C4 ::v84(){vfunc_called(this, "_ZN6S639C43v84Ev");}
void  S639C4 ::v85(){vfunc_called(this, "_ZN6S639C43v85Ev");}
void  S639C4 ::v86(){vfunc_called(this, "_ZN6S639C43v86Ev");}
void  S639C4 ::v87(){vfunc_called(this, "_ZN6S639C43v87Ev");}
void  S639C4 ::v88(){vfunc_called(this, "_ZN6S639C43v88Ev");}
void  S639C4 ::v89(){vfunc_called(this, "_ZN6S639C43v89Ev");}
void  S639C4 ::v90(){vfunc_called(this, "_ZN6S639C43v90Ev");}
S639C4 ::S639C4(){ note_ctor("S639C4", this);} // tgen

static void Test_S639C4()
{
  extern Class_Descriptor cd_S639C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S639C4, buf);
    S639C4 *dp, &lv = *(dp=new (buf) S639C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S639C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S639C4)");
    check_base_class_offset(lv, (S639C5*), 0, "S639C4");
    check_field_offset(lv, s639c4f0, ABISELECT(96,60), "S639C4.s639c4f0");
    check_field_offset(lv, s639c4f1, ABISELECT(104,68), "S639C4.s639c4f1");
    check_field_offset(lv, s639c4f2, ABISELECT(112,72), "S639C4.s639c4f2");
    check_field_offset(lv, s639c4f3, ABISELECT(120,80), "S639C4.s639c4f3");
    check_field_offset(lv, s639c4f4, ABISELECT(136,92), "S639C4.s639c4f4");
    check_field_offset(lv, s639c4f5, ABISELECT(152,104), "S639C4.s639c4f5");
    check_field_offset(lv, s639c4f6, ABISELECT(160,108), "S639C4.s639c4f6");
    set_bf_and_test(lv, s639c4f7, ABISELECT(176,120), 0, 1, 1, "S639C4");
    set_bf_and_test(lv, s639c4f8, ABISELECT(176,120), 1, 1, 1, "S639C4");
    set_bf_and_test(lv, s639c4f9, ABISELECT(176,120), 2, 1, 1, "S639C4");
    set_bf_and_test(lv, s639c4f10, ABISELECT(176,120), 3, 1, 1, "S639C4");
    set_bf_and_test(lv, s639c4f11, ABISELECT(176,120), 4, 1, 1, "S639C4");
    check_field_offset(lv, s639c4f12, ABISELECT(180,124), "S639C4.s639c4f12");
    test_class_info(&lv, &cd_S639C4);
    dp->~S639C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS639C4(Test_S639C4, "S639C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S639C4C1Ev();
extern void _ZN6S639C4D1Ev();
Name_Map name_map_S639C4[] = {
  NSPAIR(_ZN6S639C4C1Ev),
  NSPAIR(_ZN6S639C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S639C5;
extern VTBL_ENTRY _ZTI6S639C5[];
extern  VTBL_ENTRY _ZTV6S639C5[];
static Base_Class bases_S639C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S639C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S639C4[];
extern void _ZN6S639C4D1Ev();
extern void _ZN6S639C4D0Ev();
extern void _ZN6S639C52v5Ev();
extern void _ZN6S639C52v6Ev();
extern void _ZN6S639C52v7Ev();
extern void _ZN6S639C52v8Ev();
extern void _ZN6S639C52v9Ev();
extern void _ZN6S639C53v10Ev();
extern void _ZN6S639C53v11Ev();
extern void _ZN6S639C53v12Ev();
extern void _ZN6S639C53v13Ev();
extern void _ZN6S639C53v14Ev();
extern void _ZN6S639C53v15Ev();
extern void _ZN6S639C53v16Ev();
extern void _ZN6S639C53v17Ev();
extern void _ZN6S639C53v18Ev();
extern void _ZN6S639C53v19Ev();
extern void _ZN6S639C53v20Ev();
extern void _ZN6S639C53v21Ev();
extern void _ZN6S639C53v22Ev();
extern void _ZN6S639C53v23Ev();
extern void _ZN6S639C53v24Ev();
extern void _ZN6S639C53v25Ev();
extern void _ZN6S639C53v26Ev();
extern void _ZN6S639C53v27Ev();
extern void _ZN6S639C53v28Ev();
extern void _ZN6S639C53v29Ev();
extern void _ZN6S639C53v30Ev();
extern void _ZN6S639C53v31Ev();
extern void _ZN6S639C53v32Ev();
extern void _ZN6S639C53v33Ev();
extern void _ZN6S639C53v34Ev();
extern void _ZN6S639C53v35Ev();
extern void _ZN6S639C53v36Ev();
extern void _ZN6S639C53v37Ev();
extern void _ZN6S639C53v38Ev();
extern void _ZN6S639C53v39Ev();
extern void _ZN6S639C53v40Ev();
extern void _ZN6S639C53v41Ev();
extern void _ZN6S639C53v42Ev();
extern void _ZN6S639C53v43Ev();
extern void _ZN6S639C53v44Ev();
extern void _ZN6S639C53v45Ev();
extern void _ZN6S639C53v46Ev();
extern void _ZN6S639C53v47Ev();
extern void _ZN6S639C53v48Ev();
extern void _ZN6S639C53v49Ev();
extern void _ZN6S639C53v50Ev();
extern void _ZN6S639C53v51Ev();
extern void _ZN6S639C53v52Ev();
extern void _ZN6S639C53v53Ev();
extern void _ZN6S639C53v54Ev();
extern void _ZN6S639C53v55Ev();
extern void _ZN6S639C53v56Ev();
extern void _ZN6S639C53v57Ev();
extern void _ZN6S639C53v58Ev();
extern void _ZN6S639C53v59Ev();
extern void _ZN6S639C53v60Ev();
extern void _ZN6S639C53v61Ev();
extern void _ZN6S639C53v62Ev();
extern void _ZN6S639C53v63Ev();
extern void _ZN6S639C53v64Ev();
extern void _ZN6S639C53v65Ev();
extern void _ZN6S639C53v66Ev();
extern void _ZN6S639C53v67Ev();
extern void _ZN6S639C53v68Ev();
extern void _ZN6S639C43v69Ev();
extern void _ZN6S639C43v70Ev();
extern void _ZN6S639C43v71Ev();
extern void _ZN6S639C43v72Ev();
extern void _ZN6S639C43v73Ev();
extern void _ZN6S639C43v74Ev();
extern void _ZN6S639C43v75Ev();
extern void _ZN6S639C43v76Ev();
extern void _ZN6S639C43v77Ev();
extern void _ZN6S639C43v78Ev();
extern void _ZN6S639C43v79Ev();
extern void _ZN6S639C43v80Ev();
extern void _ZN6S639C43v81Ev();
extern void _ZN6S639C43v82Ev();
extern void _ZN6S639C43v83Ev();
extern void _ZN6S639C43v84Ev();
extern void _ZN6S639C43v85Ev();
extern void _ZN6S639C43v86Ev();
extern void _ZN6S639C43v87Ev();
extern void _ZN6S639C43v88Ev();
extern void _ZN6S639C43v89Ev();
extern void _ZN6S639C43v90Ev();
static  VTBL_ENTRY vtc_S639C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S639C4[0]),
  (VTBL_ENTRY)&_ZN6S639C4D1Ev,
  (VTBL_ENTRY)&_ZN6S639C4D0Ev,
  (VTBL_ENTRY)&_ZN6S639C52v5Ev,
  (VTBL_ENTRY)&_ZN6S639C52v6Ev,
  (VTBL_ENTRY)&_ZN6S639C52v7Ev,
  (VTBL_ENTRY)&_ZN6S639C52v8Ev,
  (VTBL_ENTRY)&_ZN6S639C52v9Ev,
  (VTBL_ENTRY)&_ZN6S639C53v10Ev,
  (VTBL_ENTRY)&_ZN6S639C53v11Ev,
  (VTBL_ENTRY)&_ZN6S639C53v12Ev,
  (VTBL_ENTRY)&_ZN6S639C53v13Ev,
  (VTBL_ENTRY)&_ZN6S639C53v14Ev,
  (VTBL_ENTRY)&_ZN6S639C53v15Ev,
  (VTBL_ENTRY)&_ZN6S639C53v16Ev,
  (VTBL_ENTRY)&_ZN6S639C53v17Ev,
  (VTBL_ENTRY)&_ZN6S639C53v18Ev,
  (VTBL_ENTRY)&_ZN6S639C53v19Ev,
  (VTBL_ENTRY)&_ZN6S639C53v20Ev,
  (VTBL_ENTRY)&_ZN6S639C53v21Ev,
  (VTBL_ENTRY)&_ZN6S639C53v22Ev,
  (VTBL_ENTRY)&_ZN6S639C53v23Ev,
  (VTBL_ENTRY)&_ZN6S639C53v24Ev,
  (VTBL_ENTRY)&_ZN6S639C53v25Ev,
  (VTBL_ENTRY)&_ZN6S639C53v26Ev,
  (VTBL_ENTRY)&_ZN6S639C53v27Ev,
  (VTBL_ENTRY)&_ZN6S639C53v28Ev,
  (VTBL_ENTRY)&_ZN6S639C53v29Ev,
  (VTBL_ENTRY)&_ZN6S639C53v30Ev,
  (VTBL_ENTRY)&_ZN6S639C53v31Ev,
  (VTBL_ENTRY)&_ZN6S639C53v32Ev,
  (VTBL_ENTRY)&_ZN6S639C53v33Ev,
  (VTBL_ENTRY)&_ZN6S639C53v34Ev,
  (VTBL_ENTRY)&_ZN6S639C53v35Ev,
  (VTBL_ENTRY)&_ZN6S639C53v36Ev,
  (VTBL_ENTRY)&_ZN6S639C53v37Ev,
  (VTBL_ENTRY)&_ZN6S639C53v38Ev,
  (VTBL_ENTRY)&_ZN6S639C53v39Ev,
  (VTBL_ENTRY)&_ZN6S639C53v40Ev,
  (VTBL_ENTRY)&_ZN6S639C53v41Ev,
  (VTBL_ENTRY)&_ZN6S639C53v42Ev,
  (VTBL_ENTRY)&_ZN6S639C53v43Ev,
  (VTBL_ENTRY)&_ZN6S639C53v44Ev,
  (VTBL_ENTRY)&_ZN6S639C53v45Ev,
  (VTBL_ENTRY)&_ZN6S639C53v46Ev,
  (VTBL_ENTRY)&_ZN6S639C53v47Ev,
  (VTBL_ENTRY)&_ZN6S639C53v48Ev,
  (VTBL_ENTRY)&_ZN6S639C53v49Ev,
  (VTBL_ENTRY)&_ZN6S639C53v50Ev,
  (VTBL_ENTRY)&_ZN6S639C53v51Ev,
  (VTBL_ENTRY)&_ZN6S639C53v52Ev,
  (VTBL_ENTRY)&_ZN6S639C53v53Ev,
  (VTBL_ENTRY)&_ZN6S639C53v54Ev,
  (VTBL_ENTRY)&_ZN6S639C53v55Ev,
  (VTBL_ENTRY)&_ZN6S639C53v56Ev,
  (VTBL_ENTRY)&_ZN6S639C53v57Ev,
  (VTBL_ENTRY)&_ZN6S639C53v58Ev,
  (VTBL_ENTRY)&_ZN6S639C53v59Ev,
  (VTBL_ENTRY)&_ZN6S639C53v60Ev,
  (VTBL_ENTRY)&_ZN6S639C53v61Ev,
  (VTBL_ENTRY)&_ZN6S639C53v62Ev,
  (VTBL_ENTRY)&_ZN6S639C53v63Ev,
  (VTBL_ENTRY)&_ZN6S639C53v64Ev,
  (VTBL_ENTRY)&_ZN6S639C53v65Ev,
  (VTBL_ENTRY)&_ZN6S639C53v66Ev,
  (VTBL_ENTRY)&_ZN6S639C53v67Ev,
  (VTBL_ENTRY)&_ZN6S639C53v68Ev,
  (VTBL_ENTRY)&_ZN6S639C43v69Ev,
  (VTBL_ENTRY)&_ZN6S639C43v70Ev,
  (VTBL_ENTRY)&_ZN6S639C43v71Ev,
  (VTBL_ENTRY)&_ZN6S639C43v72Ev,
  (VTBL_ENTRY)&_ZN6S639C43v73Ev,
  (VTBL_ENTRY)&_ZN6S639C43v74Ev,
  (VTBL_ENTRY)&_ZN6S639C43v75Ev,
  (VTBL_ENTRY)&_ZN6S639C43v76Ev,
  (VTBL_ENTRY)&_ZN6S639C43v77Ev,
  (VTBL_ENTRY)&_ZN6S639C43v78Ev,
  (VTBL_ENTRY)&_ZN6S639C43v79Ev,
  (VTBL_ENTRY)&_ZN6S639C43v80Ev,
  (VTBL_ENTRY)&_ZN6S639C43v81Ev,
  (VTBL_ENTRY)&_ZN6S639C43v82Ev,
  (VTBL_ENTRY)&_ZN6S639C43v83Ev,
  (VTBL_ENTRY)&_ZN6S639C43v84Ev,
  (VTBL_ENTRY)&_ZN6S639C43v85Ev,
  (VTBL_ENTRY)&_ZN6S639C43v86Ev,
  (VTBL_ENTRY)&_ZN6S639C43v87Ev,
  (VTBL_ENTRY)&_ZN6S639C43v88Ev,
  (VTBL_ENTRY)&_ZN6S639C43v89Ev,
  (VTBL_ENTRY)&_ZN6S639C43v90Ev,
};
extern VTBL_ENTRY _ZTI6S639C4[];
extern  VTBL_ENTRY _ZTV6S639C4[];
Class_Descriptor cd_S639C4 = {  "S639C4", // class name
  bases_S639C4, 1,
  &(vtc_S639C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S639C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S639C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S639C3  : S639C4 {
  ::S473C6_nt s639c3f0;
  virtual  ~S639C3(); // _ZN6S639C3D1Ev
  virtual void  v91(); // _ZN6S639C33v91Ev
  virtual void  v92(); // _ZN6S639C33v92Ev
  virtual void  v93(); // _ZN6S639C33v93Ev
  virtual void  v94(); // _ZN6S639C33v94Ev
  virtual void  v95(); // _ZN6S639C33v95Ev
  virtual void  v96(); // _ZN6S639C33v96Ev
  virtual void  v97(); // _ZN6S639C33v97Ev
  virtual void  v98(); // _ZN6S639C33v98Ev
  virtual void  v99(); // _ZN6S639C33v99Ev
  virtual void  v100(); // _ZN6S639C34v100Ev
  virtual void  v101(); // _ZN6S639C34v101Ev
  virtual void  v102(); // _ZN6S639C34v102Ev
  virtual void  v103(); // _ZN6S639C34v103Ev
  virtual void  v104(); // _ZN6S639C34v104Ev
  virtual void  v105(); // _ZN6S639C34v105Ev
  virtual void  v106(); // _ZN6S639C34v106Ev
  virtual void  v107(); // _ZN6S639C34v107Ev
  virtual void  v108(); // _ZN6S639C34v108Ev
  virtual void  v109(); // _ZN6S639C34v109Ev
  S639C3(); // tgen
};
//SIG(-1 S639C3) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S639C3 ::~S639C3(){ note_dtor("S639C3", this);}
void  S639C3 ::v91(){vfunc_called(this, "_ZN6S639C33v91Ev");}
void  S639C3 ::v92(){vfunc_called(this, "_ZN6S639C33v92Ev");}
void  S639C3 ::v93(){vfunc_called(this, "_ZN6S639C33v93Ev");}
void  S639C3 ::v94(){vfunc_called(this, "_ZN6S639C33v94Ev");}
void  S639C3 ::v95(){vfunc_called(this, "_ZN6S639C33v95Ev");}
void  S639C3 ::v96(){vfunc_called(this, "_ZN6S639C33v96Ev");}
void  S639C3 ::v97(){vfunc_called(this, "_ZN6S639C33v97Ev");}
void  S639C3 ::v98(){vfunc_called(this, "_ZN6S639C33v98Ev");}
void  S639C3 ::v99(){vfunc_called(this, "_ZN6S639C33v99Ev");}
void  S639C3 ::v100(){vfunc_called(this, "_ZN6S639C34v100Ev");}
void  S639C3 ::v101(){vfunc_called(this, "_ZN6S639C34v101Ev");}
void  S639C3 ::v102(){vfunc_called(this, "_ZN6S639C34v102Ev");}
void  S639C3 ::v103(){vfunc_called(this, "_ZN6S639C34v103Ev");}
void  S639C3 ::v104(){vfunc_called(this, "_ZN6S639C34v104Ev");}
void  S639C3 ::v105(){vfunc_called(this, "_ZN6S639C34v105Ev");}
void  S639C3 ::v106(){vfunc_called(this, "_ZN6S639C34v106Ev");}
void  S639C3 ::v107(){vfunc_called(this, "_ZN6S639C34v107Ev");}
void  S639C3 ::v108(){vfunc_called(this, "_ZN6S639C34v108Ev");}
void  S639C3 ::v109(){vfunc_called(this, "_ZN6S639C34v109Ev");}
S639C3 ::S639C3(){ note_ctor("S639C3", this);} // tgen

static void Test_S639C3()
{
  extern Class_Descriptor cd_S639C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S639C3, buf);
    S639C3 *dp, &lv = *(dp=new (buf) S639C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S639C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S639C3)");
    check_base_class_offset(lv, (S639C5*)(S639C4*), 0, "S639C3");
    check_base_class_offset(lv, (S639C4*), 0, "S639C3");
    check_field_offset(lv, s639c3f0, ABISELECT(188,132), "S639C3.s639c3f0");
    test_class_info(&lv, &cd_S639C3);
    dp->~S639C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS639C3(Test_S639C3, "S639C3", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S639C3C1Ev();
extern void _ZN6S639C3D1Ev();
Name_Map name_map_S639C3[] = {
  NSPAIR(_ZN6S639C3C1Ev),
  NSPAIR(_ZN6S639C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S639C5;
extern VTBL_ENTRY _ZTI6S639C5[];
extern  VTBL_ENTRY _ZTV6S639C5[];
extern Class_Descriptor cd_S639C4;
extern VTBL_ENTRY _ZTI6S639C4[];
extern  VTBL_ENTRY _ZTV6S639C4[];
static Base_Class bases_S639C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S639C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S639C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S639C3[];
extern void _ZN6S639C3D1Ev();
extern void _ZN6S639C3D0Ev();
extern void _ZN6S639C52v5Ev();
extern void _ZN6S639C52v6Ev();
extern void _ZN6S639C52v7Ev();
extern void _ZN6S639C52v8Ev();
extern void _ZN6S639C52v9Ev();
extern void _ZN6S639C53v10Ev();
extern void _ZN6S639C53v11Ev();
extern void _ZN6S639C53v12Ev();
extern void _ZN6S639C53v13Ev();
extern void _ZN6S639C53v14Ev();
extern void _ZN6S639C53v15Ev();
extern void _ZN6S639C53v16Ev();
extern void _ZN6S639C53v17Ev();
extern void _ZN6S639C53v18Ev();
extern void _ZN6S639C53v19Ev();
extern void _ZN6S639C53v20Ev();
extern void _ZN6S639C53v21Ev();
extern void _ZN6S639C53v22Ev();
extern void _ZN6S639C53v23Ev();
extern void _ZN6S639C53v24Ev();
extern void _ZN6S639C53v25Ev();
extern void _ZN6S639C53v26Ev();
extern void _ZN6S639C53v27Ev();
extern void _ZN6S639C53v28Ev();
extern void _ZN6S639C53v29Ev();
extern void _ZN6S639C53v30Ev();
extern void _ZN6S639C53v31Ev();
extern void _ZN6S639C53v32Ev();
extern void _ZN6S639C53v33Ev();
extern void _ZN6S639C53v34Ev();
extern void _ZN6S639C53v35Ev();
extern void _ZN6S639C53v36Ev();
extern void _ZN6S639C53v37Ev();
extern void _ZN6S639C53v38Ev();
extern void _ZN6S639C53v39Ev();
extern void _ZN6S639C53v40Ev();
extern void _ZN6S639C53v41Ev();
extern void _ZN6S639C53v42Ev();
extern void _ZN6S639C53v43Ev();
extern void _ZN6S639C53v44Ev();
extern void _ZN6S639C53v45Ev();
extern void _ZN6S639C53v46Ev();
extern void _ZN6S639C53v47Ev();
extern void _ZN6S639C53v48Ev();
extern void _ZN6S639C53v49Ev();
extern void _ZN6S639C53v50Ev();
extern void _ZN6S639C53v51Ev();
extern void _ZN6S639C53v52Ev();
extern void _ZN6S639C53v53Ev();
extern void _ZN6S639C53v54Ev();
extern void _ZN6S639C53v55Ev();
extern void _ZN6S639C53v56Ev();
extern void _ZN6S639C53v57Ev();
extern void _ZN6S639C53v58Ev();
extern void _ZN6S639C53v59Ev();
extern void _ZN6S639C53v60Ev();
extern void _ZN6S639C53v61Ev();
extern void _ZN6S639C53v62Ev();
extern void _ZN6S639C53v63Ev();
extern void _ZN6S639C53v64Ev();
extern void _ZN6S639C53v65Ev();
extern void _ZN6S639C53v66Ev();
extern void _ZN6S639C53v67Ev();
extern void _ZN6S639C53v68Ev();
extern void _ZN6S639C43v69Ev();
extern void _ZN6S639C43v70Ev();
extern void _ZN6S639C43v71Ev();
extern void _ZN6S639C43v72Ev();
extern void _ZN6S639C43v73Ev();
extern void _ZN6S639C43v74Ev();
extern void _ZN6S639C43v75Ev();
extern void _ZN6S639C43v76Ev();
extern void _ZN6S639C43v77Ev();
extern void _ZN6S639C43v78Ev();
extern void _ZN6S639C43v79Ev();
extern void _ZN6S639C43v80Ev();
extern void _ZN6S639C43v81Ev();
extern void _ZN6S639C43v82Ev();
extern void _ZN6S639C43v83Ev();
extern void _ZN6S639C43v84Ev();
extern void _ZN6S639C43v85Ev();
extern void _ZN6S639C43v86Ev();
extern void _ZN6S639C43v87Ev();
extern void _ZN6S639C43v88Ev();
extern void _ZN6S639C43v89Ev();
extern void _ZN6S639C43v90Ev();
extern void _ZN6S639C33v91Ev();
extern void _ZN6S639C33v92Ev();
extern void _ZN6S639C33v93Ev();
extern void _ZN6S639C33v94Ev();
extern void _ZN6S639C33v95Ev();
extern void _ZN6S639C33v96Ev();
extern void _ZN6S639C33v97Ev();
extern void _ZN6S639C33v98Ev();
extern void _ZN6S639C33v99Ev();
extern void _ZN6S639C34v100Ev();
extern void _ZN6S639C34v101Ev();
extern void _ZN6S639C34v102Ev();
extern void _ZN6S639C34v103Ev();
extern void _ZN6S639C34v104Ev();
extern void _ZN6S639C34v105Ev();
extern void _ZN6S639C34v106Ev();
extern void _ZN6S639C34v107Ev();
extern void _ZN6S639C34v108Ev();
extern void _ZN6S639C34v109Ev();
static  VTBL_ENTRY vtc_S639C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S639C3[0]),
  (VTBL_ENTRY)&_ZN6S639C3D1Ev,
  (VTBL_ENTRY)&_ZN6S639C3D0Ev,
  (VTBL_ENTRY)&_ZN6S639C52v5Ev,
  (VTBL_ENTRY)&_ZN6S639C52v6Ev,
  (VTBL_ENTRY)&_ZN6S639C52v7Ev,
  (VTBL_ENTRY)&_ZN6S639C52v8Ev,
  (VTBL_ENTRY)&_ZN6S639C52v9Ev,
  (VTBL_ENTRY)&_ZN6S639C53v10Ev,
  (VTBL_ENTRY)&_ZN6S639C53v11Ev,
  (VTBL_ENTRY)&_ZN6S639C53v12Ev,
  (VTBL_ENTRY)&_ZN6S639C53v13Ev,
  (VTBL_ENTRY)&_ZN6S639C53v14Ev,
  (VTBL_ENTRY)&_ZN6S639C53v15Ev,
  (VTBL_ENTRY)&_ZN6S639C53v16Ev,
  (VTBL_ENTRY)&_ZN6S639C53v17Ev,
  (VTBL_ENTRY)&_ZN6S639C53v18Ev,
  (VTBL_ENTRY)&_ZN6S639C53v19Ev,
  (VTBL_ENTRY)&_ZN6S639C53v20Ev,
  (VTBL_ENTRY)&_ZN6S639C53v21Ev,
  (VTBL_ENTRY)&_ZN6S639C53v22Ev,
  (VTBL_ENTRY)&_ZN6S639C53v23Ev,
  (VTBL_ENTRY)&_ZN6S639C53v24Ev,
  (VTBL_ENTRY)&_ZN6S639C53v25Ev,
  (VTBL_ENTRY)&_ZN6S639C53v26Ev,
  (VTBL_ENTRY)&_ZN6S639C53v27Ev,
  (VTBL_ENTRY)&_ZN6S639C53v28Ev,
  (VTBL_ENTRY)&_ZN6S639C53v29Ev,
  (VTBL_ENTRY)&_ZN6S639C53v30Ev,
  (VTBL_ENTRY)&_ZN6S639C53v31Ev,
  (VTBL_ENTRY)&_ZN6S639C53v32Ev,
  (VTBL_ENTRY)&_ZN6S639C53v33Ev,
  (VTBL_ENTRY)&_ZN6S639C53v34Ev,
  (VTBL_ENTRY)&_ZN6S639C53v35Ev,
  (VTBL_ENTRY)&_ZN6S639C53v36Ev,
  (VTBL_ENTRY)&_ZN6S639C53v37Ev,
  (VTBL_ENTRY)&_ZN6S639C53v38Ev,
  (VTBL_ENTRY)&_ZN6S639C53v39Ev,
  (VTBL_ENTRY)&_ZN6S639C53v40Ev,
  (VTBL_ENTRY)&_ZN6S639C53v41Ev,
  (VTBL_ENTRY)&_ZN6S639C53v42Ev,
  (VTBL_ENTRY)&_ZN6S639C53v43Ev,
  (VTBL_ENTRY)&_ZN6S639C53v44Ev,
  (VTBL_ENTRY)&_ZN6S639C53v45Ev,
  (VTBL_ENTRY)&_ZN6S639C53v46Ev,
  (VTBL_ENTRY)&_ZN6S639C53v47Ev,
  (VTBL_ENTRY)&_ZN6S639C53v48Ev,
  (VTBL_ENTRY)&_ZN6S639C53v49Ev,
  (VTBL_ENTRY)&_ZN6S639C53v50Ev,
  (VTBL_ENTRY)&_ZN6S639C53v51Ev,
  (VTBL_ENTRY)&_ZN6S639C53v52Ev,
  (VTBL_ENTRY)&_ZN6S639C53v53Ev,
  (VTBL_ENTRY)&_ZN6S639C53v54Ev,
  (VTBL_ENTRY)&_ZN6S639C53v55Ev,
  (VTBL_ENTRY)&_ZN6S639C53v56Ev,
  (VTBL_ENTRY)&_ZN6S639C53v57Ev,
  (VTBL_ENTRY)&_ZN6S639C53v58Ev,
  (VTBL_ENTRY)&_ZN6S639C53v59Ev,
  (VTBL_ENTRY)&_ZN6S639C53v60Ev,
  (VTBL_ENTRY)&_ZN6S639C53v61Ev,
  (VTBL_ENTRY)&_ZN6S639C53v62Ev,
  (VTBL_ENTRY)&_ZN6S639C53v63Ev,
  (VTBL_ENTRY)&_ZN6S639C53v64Ev,
  (VTBL_ENTRY)&_ZN6S639C53v65Ev,
  (VTBL_ENTRY)&_ZN6S639C53v66Ev,
  (VTBL_ENTRY)&_ZN6S639C53v67Ev,
  (VTBL_ENTRY)&_ZN6S639C53v68Ev,
  (VTBL_ENTRY)&_ZN6S639C43v69Ev,
  (VTBL_ENTRY)&_ZN6S639C43v70Ev,
  (VTBL_ENTRY)&_ZN6S639C43v71Ev,
  (VTBL_ENTRY)&_ZN6S639C43v72Ev,
  (VTBL_ENTRY)&_ZN6S639C43v73Ev,
  (VTBL_ENTRY)&_ZN6S639C43v74Ev,
  (VTBL_ENTRY)&_ZN6S639C43v75Ev,
  (VTBL_ENTRY)&_ZN6S639C43v76Ev,
  (VTBL_ENTRY)&_ZN6S639C43v77Ev,
  (VTBL_ENTRY)&_ZN6S639C43v78Ev,
  (VTBL_ENTRY)&_ZN6S639C43v79Ev,
  (VTBL_ENTRY)&_ZN6S639C43v80Ev,
  (VTBL_ENTRY)&_ZN6S639C43v81Ev,
  (VTBL_ENTRY)&_ZN6S639C43v82Ev,
  (VTBL_ENTRY)&_ZN6S639C43v83Ev,
  (VTBL_ENTRY)&_ZN6S639C43v84Ev,
  (VTBL_ENTRY)&_ZN6S639C43v85Ev,
  (VTBL_ENTRY)&_ZN6S639C43v86Ev,
  (VTBL_ENTRY)&_ZN6S639C43v87Ev,
  (VTBL_ENTRY)&_ZN6S639C43v88Ev,
  (VTBL_ENTRY)&_ZN6S639C43v89Ev,
  (VTBL_ENTRY)&_ZN6S639C43v90Ev,
  (VTBL_ENTRY)&_ZN6S639C33v91Ev,
  (VTBL_ENTRY)&_ZN6S639C33v92Ev,
  (VTBL_ENTRY)&_ZN6S639C33v93Ev,
  (VTBL_ENTRY)&_ZN6S639C33v94Ev,
  (VTBL_ENTRY)&_ZN6S639C33v95Ev,
  (VTBL_ENTRY)&_ZN6S639C33v96Ev,
  (VTBL_ENTRY)&_ZN6S639C33v97Ev,
  (VTBL_ENTRY)&_ZN6S639C33v98Ev,
  (VTBL_ENTRY)&_ZN6S639C33v99Ev,
  (VTBL_ENTRY)&_ZN6S639C34v100Ev,
  (VTBL_ENTRY)&_ZN6S639C34v101Ev,
  (VTBL_ENTRY)&_ZN6S639C34v102Ev,
  (VTBL_ENTRY)&_ZN6S639C34v103Ev,
  (VTBL_ENTRY)&_ZN6S639C34v104Ev,
  (VTBL_ENTRY)&_ZN6S639C34v105Ev,
  (VTBL_ENTRY)&_ZN6S639C34v106Ev,
  (VTBL_ENTRY)&_ZN6S639C34v107Ev,
  (VTBL_ENTRY)&_ZN6S639C34v108Ev,
  (VTBL_ENTRY)&_ZN6S639C34v109Ev,
};
extern VTBL_ENTRY _ZTI6S639C3[];
extern  VTBL_ENTRY _ZTV6S639C3[];
Class_Descriptor cd_S639C3 = {  "S639C3", // class name
  bases_S639C3, 2,
  &(vtc_S639C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S639C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S639C3),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S639C2  : S639C3 {
  void *s639c2f0;
  virtual  ~S639C2(); // _ZN6S639C2D1Ev
  virtual void  v110(); // _ZN6S639C24v110Ev
  virtual void  v111(); // _ZN6S639C24v111Ev
  virtual void  v112(); // _ZN6S639C24v112Ev
  virtual void  v113(); // _ZN6S639C24v113Ev
  virtual void  v114(); // _ZN6S639C24v114Ev
  virtual void  v115(); // _ZN6S639C24v115Ev
  virtual void  v116(); // _ZN6S639C24v116Ev
  virtual void  v117(); // _ZN6S639C24v117Ev
  virtual void  v118(); // _ZN6S639C24v118Ev
  S639C2(); // tgen
};
//SIG(-1 S639C2) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 FC5} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp}


 S639C2 ::~S639C2(){ note_dtor("S639C2", this);}
void  S639C2 ::v110(){vfunc_called(this, "_ZN6S639C24v110Ev");}
void  S639C2 ::v111(){vfunc_called(this, "_ZN6S639C24v111Ev");}
void  S639C2 ::v112(){vfunc_called(this, "_ZN6S639C24v112Ev");}
void  S639C2 ::v113(){vfunc_called(this, "_ZN6S639C24v113Ev");}
void  S639C2 ::v114(){vfunc_called(this, "_ZN6S639C24v114Ev");}
void  S639C2 ::v115(){vfunc_called(this, "_ZN6S639C24v115Ev");}
void  S639C2 ::v116(){vfunc_called(this, "_ZN6S639C24v116Ev");}
void  S639C2 ::v117(){vfunc_called(this, "_ZN6S639C24v117Ev");}
void  S639C2 ::v118(){vfunc_called(this, "_ZN6S639C24v118Ev");}
S639C2 ::S639C2(){ note_ctor("S639C2", this);} // tgen

static void Test_S639C2()
{
  extern Class_Descriptor cd_S639C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,37)];
    init_test(&cd_S639C2, buf);
    S639C2 *dp, &lv = *(dp=new (buf) S639C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,144), "sizeof(S639C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S639C2)");
    check_base_class_offset(lv, (S639C5*)(S639C4*)(S639C3*), 0, "S639C2");
    check_base_class_offset(lv, (S639C4*)(S639C3*), 0, "S639C2");
    check_base_class_offset(lv, (S639C3*), 0, "S639C2");
    check_field_offset(lv, s639c2f0, ABISELECT(200,140), "S639C2.s639c2f0");
    test_class_info(&lv, &cd_S639C2);
    dp->~S639C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS639C2(Test_S639C2, "S639C2", ABISELECT(208,144));

#else // __cplusplus

extern void _ZN6S639C2C1Ev();
extern void _ZN6S639C2D1Ev();
Name_Map name_map_S639C2[] = {
  NSPAIR(_ZN6S639C2C1Ev),
  NSPAIR(_ZN6S639C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S639C5;
extern VTBL_ENTRY _ZTI6S639C5[];
extern  VTBL_ENTRY _ZTV6S639C5[];
extern Class_Descriptor cd_S639C4;
extern VTBL_ENTRY _ZTI6S639C4[];
extern  VTBL_ENTRY _ZTV6S639C4[];
extern Class_Descriptor cd_S639C3;
extern VTBL_ENTRY _ZTI6S639C3[];
extern  VTBL_ENTRY _ZTV6S639C3[];
static Base_Class bases_S639C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S639C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S639C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S639C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S639C2[];
extern void _ZN6S639C2D1Ev();
extern void _ZN6S639C2D0Ev();
extern void _ZN6S639C52v5Ev();
extern void _ZN6S639C52v6Ev();
extern void _ZN6S639C52v7Ev();
extern void _ZN6S639C52v8Ev();
extern void _ZN6S639C52v9Ev();
extern void _ZN6S639C53v10Ev();
extern void _ZN6S639C53v11Ev();
extern void _ZN6S639C53v12Ev();
extern void _ZN6S639C53v13Ev();
extern void _ZN6S639C53v14Ev();
extern void _ZN6S639C53v15Ev();
extern void _ZN6S639C53v16Ev();
extern void _ZN6S639C53v17Ev();
extern void _ZN6S639C53v18Ev();
extern void _ZN6S639C53v19Ev();
extern void _ZN6S639C53v20Ev();
extern void _ZN6S639C53v21Ev();
extern void _ZN6S639C53v22Ev();
extern void _ZN6S639C53v23Ev();
extern void _ZN6S639C53v24Ev();
extern void _ZN6S639C53v25Ev();
extern void _ZN6S639C53v26Ev();
extern void _ZN6S639C53v27Ev();
extern void _ZN6S639C53v28Ev();
extern void _ZN6S639C53v29Ev();
extern void _ZN6S639C53v30Ev();
extern void _ZN6S639C53v31Ev();
extern void _ZN6S639C53v32Ev();
extern void _ZN6S639C53v33Ev();
extern void _ZN6S639C53v34Ev();
extern void _ZN6S639C53v35Ev();
extern void _ZN6S639C53v36Ev();
extern void _ZN6S639C53v37Ev();
extern void _ZN6S639C53v38Ev();
extern void _ZN6S639C53v39Ev();
extern void _ZN6S639C53v40Ev();
extern void _ZN6S639C53v41Ev();
extern void _ZN6S639C53v42Ev();
extern void _ZN6S639C53v43Ev();
extern void _ZN6S639C53v44Ev();
extern void _ZN6S639C53v45Ev();
extern void _ZN6S639C53v46Ev();
extern void _ZN6S639C53v47Ev();
extern void _ZN6S639C53v48Ev();
extern void _ZN6S639C53v49Ev();
extern void _ZN6S639C53v50Ev();
extern void _ZN6S639C53v51Ev();
extern void _ZN6S639C53v52Ev();
extern void _ZN6S639C53v53Ev();
extern void _ZN6S639C53v54Ev();
extern void _ZN6S639C53v55Ev();
extern void _ZN6S639C53v56Ev();
extern void _ZN6S639C53v57Ev();
extern void _ZN6S639C53v58Ev();
extern void _ZN6S639C53v59Ev();
extern void _ZN6S639C53v60Ev();
extern void _ZN6S639C53v61Ev();
extern void _ZN6S639C53v62Ev();
extern void _ZN6S639C53v63Ev();
extern void _ZN6S639C53v64Ev();
extern void _ZN6S639C53v65Ev();
extern void _ZN6S639C53v66Ev();
extern void _ZN6S639C53v67Ev();
extern void _ZN6S639C53v68Ev();
extern void _ZN6S639C43v69Ev();
extern void _ZN6S639C43v70Ev();
extern void _ZN6S639C43v71Ev();
extern void _ZN6S639C43v72Ev();
extern void _ZN6S639C43v73Ev();
extern void _ZN6S639C43v74Ev();
extern void _ZN6S639C43v75Ev();
extern void _ZN6S639C43v76Ev();
extern void _ZN6S639C43v77Ev();
extern void _ZN6S639C43v78Ev();
extern void _ZN6S639C43v79Ev();
extern void _ZN6S639C43v80Ev();
extern void _ZN6S639C43v81Ev();
extern void _ZN6S639C43v82Ev();
extern void _ZN6S639C43v83Ev();
extern void _ZN6S639C43v84Ev();
extern void _ZN6S639C43v85Ev();
extern void _ZN6S639C43v86Ev();
extern void _ZN6S639C43v87Ev();
extern void _ZN6S639C43v88Ev();
extern void _ZN6S639C43v89Ev();
extern void _ZN6S639C43v90Ev();
extern void _ZN6S639C33v91Ev();
extern void _ZN6S639C33v92Ev();
extern void _ZN6S639C33v93Ev();
extern void _ZN6S639C33v94Ev();
extern void _ZN6S639C33v95Ev();
extern void _ZN6S639C33v96Ev();
extern void _ZN6S639C33v97Ev();
extern void _ZN6S639C33v98Ev();
extern void _ZN6S639C33v99Ev();
extern void _ZN6S639C34v100Ev();
extern void _ZN6S639C34v101Ev();
extern void _ZN6S639C34v102Ev();
extern void _ZN6S639C34v103Ev();
extern void _ZN6S639C34v104Ev();
extern void _ZN6S639C34v105Ev();
extern void _ZN6S639C34v106Ev();
extern void _ZN6S639C34v107Ev();
extern void _ZN6S639C34v108Ev();
extern void _ZN6S639C34v109Ev();
extern void _ZN6S639C24v110Ev();
extern void _ZN6S639C24v111Ev();
extern void _ZN6S639C24v112Ev();
extern void _ZN6S639C24v113Ev();
extern void _ZN6S639C24v114Ev();
extern void _ZN6S639C24v115Ev();
extern void _ZN6S639C24v116Ev();
extern void _ZN6S639C24v117Ev();
extern void _ZN6S639C24v118Ev();
static  VTBL_ENTRY vtc_S639C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S639C2[0]),
  (VTBL_ENTRY)&_ZN6S639C2D1Ev,
  (VTBL_ENTRY)&_ZN6S639C2D0Ev,
  (VTBL_ENTRY)&_ZN6S639C52v5Ev,
  (VTBL_ENTRY)&_ZN6S639C52v6Ev,
  (VTBL_ENTRY)&_ZN6S639C52v7Ev,
  (VTBL_ENTRY)&_ZN6S639C52v8Ev,
  (VTBL_ENTRY)&_ZN6S639C52v9Ev,
  (VTBL_ENTRY)&_ZN6S639C53v10Ev,
  (VTBL_ENTRY)&_ZN6S639C53v11Ev,
  (VTBL_ENTRY)&_ZN6S639C53v12Ev,
  (VTBL_ENTRY)&_ZN6S639C53v13Ev,
  (VTBL_ENTRY)&_ZN6S639C53v14Ev,
  (VTBL_ENTRY)&_ZN6S639C53v15Ev,
  (VTBL_ENTRY)&_ZN6S639C53v16Ev,
  (VTBL_ENTRY)&_ZN6S639C53v17Ev,
  (VTBL_ENTRY)&_ZN6S639C53v18Ev,
  (VTBL_ENTRY)&_ZN6S639C53v19Ev,
  (VTBL_ENTRY)&_ZN6S639C53v20Ev,
  (VTBL_ENTRY)&_ZN6S639C53v21Ev,
  (VTBL_ENTRY)&_ZN6S639C53v22Ev,
  (VTBL_ENTRY)&_ZN6S639C53v23Ev,
  (VTBL_ENTRY)&_ZN6S639C53v24Ev,
  (VTBL_ENTRY)&_ZN6S639C53v25Ev,
  (VTBL_ENTRY)&_ZN6S639C53v26Ev,
  (VTBL_ENTRY)&_ZN6S639C53v27Ev,
  (VTBL_ENTRY)&_ZN6S639C53v28Ev,
  (VTBL_ENTRY)&_ZN6S639C53v29Ev,
  (VTBL_ENTRY)&_ZN6S639C53v30Ev,
  (VTBL_ENTRY)&_ZN6S639C53v31Ev,
  (VTBL_ENTRY)&_ZN6S639C53v32Ev,
  (VTBL_ENTRY)&_ZN6S639C53v33Ev,
  (VTBL_ENTRY)&_ZN6S639C53v34Ev,
  (VTBL_ENTRY)&_ZN6S639C53v35Ev,
  (VTBL_ENTRY)&_ZN6S639C53v36Ev,
  (VTBL_ENTRY)&_ZN6S639C53v37Ev,
  (VTBL_ENTRY)&_ZN6S639C53v38Ev,
  (VTBL_ENTRY)&_ZN6S639C53v39Ev,
  (VTBL_ENTRY)&_ZN6S639C53v40Ev,
  (VTBL_ENTRY)&_ZN6S639C53v41Ev,
  (VTBL_ENTRY)&_ZN6S639C53v42Ev,
  (VTBL_ENTRY)&_ZN6S639C53v43Ev,
  (VTBL_ENTRY)&_ZN6S639C53v44Ev,
  (VTBL_ENTRY)&_ZN6S639C53v45Ev,
  (VTBL_ENTRY)&_ZN6S639C53v46Ev,
  (VTBL_ENTRY)&_ZN6S639C53v47Ev,
  (VTBL_ENTRY)&_ZN6S639C53v48Ev,
  (VTBL_ENTRY)&_ZN6S639C53v49Ev,
  (VTBL_ENTRY)&_ZN6S639C53v50Ev,
  (VTBL_ENTRY)&_ZN6S639C53v51Ev,
  (VTBL_ENTRY)&_ZN6S639C53v52Ev,
  (VTBL_ENTRY)&_ZN6S639C53v53Ev,
  (VTBL_ENTRY)&_ZN6S639C53v54Ev,
  (VTBL_ENTRY)&_ZN6S639C53v55Ev,
  (VTBL_ENTRY)&_ZN6S639C53v56Ev,
  (VTBL_ENTRY)&_ZN6S639C53v57Ev,
  (VTBL_ENTRY)&_ZN6S639C53v58Ev,
  (VTBL_ENTRY)&_ZN6S639C53v59Ev,
  (VTBL_ENTRY)&_ZN6S639C53v60Ev,
  (VTBL_ENTRY)&_ZN6S639C53v61Ev,
  (VTBL_ENTRY)&_ZN6S639C53v62Ev,
  (VTBL_ENTRY)&_ZN6S639C53v63Ev,
  (VTBL_ENTRY)&_ZN6S639C53v64Ev,
  (VTBL_ENTRY)&_ZN6S639C53v65Ev,
  (VTBL_ENTRY)&_ZN6S639C53v66Ev,
  (VTBL_ENTRY)&_ZN6S639C53v67Ev,
  (VTBL_ENTRY)&_ZN6S639C53v68Ev,
  (VTBL_ENTRY)&_ZN6S639C43v69Ev,
  (VTBL_ENTRY)&_ZN6S639C43v70Ev,
  (VTBL_ENTRY)&_ZN6S639C43v71Ev,
  (VTBL_ENTRY)&_ZN6S639C43v72Ev,
  (VTBL_ENTRY)&_ZN6S639C43v73Ev,
  (VTBL_ENTRY)&_ZN6S639C43v74Ev,
  (VTBL_ENTRY)&_ZN6S639C43v75Ev,
  (VTBL_ENTRY)&_ZN6S639C43v76Ev,
  (VTBL_ENTRY)&_ZN6S639C43v77Ev,
  (VTBL_ENTRY)&_ZN6S639C43v78Ev,
  (VTBL_ENTRY)&_ZN6S639C43v79Ev,
  (VTBL_ENTRY)&_ZN6S639C43v80Ev,
  (VTBL_ENTRY)&_ZN6S639C43v81Ev,
  (VTBL_ENTRY)&_ZN6S639C43v82Ev,
  (VTBL_ENTRY)&_ZN6S639C43v83Ev,
  (VTBL_ENTRY)&_ZN6S639C43v84Ev,
  (VTBL_ENTRY)&_ZN6S639C43v85Ev,
  (VTBL_ENTRY)&_ZN6S639C43v86Ev,
  (VTBL_ENTRY)&_ZN6S639C43v87Ev,
  (VTBL_ENTRY)&_ZN6S639C43v88Ev,
  (VTBL_ENTRY)&_ZN6S639C43v89Ev,
  (VTBL_ENTRY)&_ZN6S639C43v90Ev,
  (VTBL_ENTRY)&_ZN6S639C33v91Ev,
  (VTBL_ENTRY)&_ZN6S639C33v92Ev,
  (VTBL_ENTRY)&_ZN6S639C33v93Ev,
  (VTBL_ENTRY)&_ZN6S639C33v94Ev,
  (VTBL_ENTRY)&_ZN6S639C33v95Ev,
  (VTBL_ENTRY)&_ZN6S639C33v96Ev,
  (VTBL_ENTRY)&_ZN6S639C33v97Ev,
  (VTBL_ENTRY)&_ZN6S639C33v98Ev,
  (VTBL_ENTRY)&_ZN6S639C33v99Ev,
  (VTBL_ENTRY)&_ZN6S639C34v100Ev,
  (VTBL_ENTRY)&_ZN6S639C34v101Ev,
  (VTBL_ENTRY)&_ZN6S639C34v102Ev,
  (VTBL_ENTRY)&_ZN6S639C34v103Ev,
  (VTBL_ENTRY)&_ZN6S639C34v104Ev,
  (VTBL_ENTRY)&_ZN6S639C34v105Ev,
  (VTBL_ENTRY)&_ZN6S639C34v106Ev,
  (VTBL_ENTRY)&_ZN6S639C34v107Ev,
  (VTBL_ENTRY)&_ZN6S639C34v108Ev,
  (VTBL_ENTRY)&_ZN6S639C34v109Ev,
  (VTBL_ENTRY)&_ZN6S639C24v110Ev,
  (VTBL_ENTRY)&_ZN6S639C24v111Ev,
  (VTBL_ENTRY)&_ZN6S639C24v112Ev,
  (VTBL_ENTRY)&_ZN6S639C24v113Ev,
  (VTBL_ENTRY)&_ZN6S639C24v114Ev,
  (VTBL_ENTRY)&_ZN6S639C24v115Ev,
  (VTBL_ENTRY)&_ZN6S639C24v116Ev,
  (VTBL_ENTRY)&_ZN6S639C24v117Ev,
  (VTBL_ENTRY)&_ZN6S639C24v118Ev,
};
extern VTBL_ENTRY _ZTI6S639C2[];
extern  VTBL_ENTRY _ZTV6S639C2[];
Class_Descriptor cd_S639C2 = {  "S639C2", // class name
  bases_S639C2, 3,
  &(vtc_S639C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,144), // object size
  NSPAIRA(_ZTI6S639C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S639C2),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S639C1  : S639C2 {
  ::S473C7_nt s639c1f0;
  virtual  ~S639C1(); // _ZN6S639C1D1Ev
  virtual void  v1(); // _ZN6S639C12v1Ev
  virtual void  v2(); // _ZN6S639C12v2Ev
  virtual void  v3(); // _ZN6S639C12v3Ev
  virtual void  v4(); // _ZN6S639C12v4Ev
  S639C1(); // tgen
};
//SIG(1 S639C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 FC6} vd v110 v111 v112 v113 v114 v115 v116 v117 v118 Fp} vd v1 v2 v3 v4 FC7}


 S639C1 ::~S639C1(){ note_dtor("S639C1", this);}
void  S639C1 ::v1(){vfunc_called(this, "_ZN6S639C12v1Ev");}
void  S639C1 ::v2(){vfunc_called(this, "_ZN6S639C12v2Ev");}
void  S639C1 ::v3(){vfunc_called(this, "_ZN6S639C12v3Ev");}
void  S639C1 ::v4(){vfunc_called(this, "_ZN6S639C12v4Ev");}
S639C1 ::S639C1(){ note_ctor("S639C1", this);} // tgen

static void Test_S639C1()
{
  extern Class_Descriptor cd_S639C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,40)];
    init_test(&cd_S639C1, buf);
    S639C1 *dp, &lv = *(dp=new (buf) S639C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,156), "sizeof(S639C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S639C1)");
    check_base_class_offset(lv, (S639C5*)(S639C4*)(S639C3*)(S639C2*), 0, "S639C1");
    check_base_class_offset(lv, (S639C4*)(S639C3*)(S639C2*), 0, "S639C1");
    check_base_class_offset(lv, (S639C3*)(S639C2*), 0, "S639C1");
    check_base_class_offset(lv, (S639C2*), 0, "S639C1");
    check_field_offset(lv, s639c1f0, ABISELECT(208,144), "S639C1.s639c1f0");
    test_class_info(&lv, &cd_S639C1);
    dp->~S639C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS639C1(Test_S639C1, "S639C1", ABISELECT(224,156));

#else // __cplusplus

extern void _ZN6S639C1C1Ev();
extern void _ZN6S639C1D1Ev();
Name_Map name_map_S639C1[] = {
  NSPAIR(_ZN6S639C1C1Ev),
  NSPAIR(_ZN6S639C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S639C5;
extern VTBL_ENTRY _ZTI6S639C5[];
extern  VTBL_ENTRY _ZTV6S639C5[];
extern Class_Descriptor cd_S639C4;
extern VTBL_ENTRY _ZTI6S639C4[];
extern  VTBL_ENTRY _ZTV6S639C4[];
extern Class_Descriptor cd_S639C3;
extern VTBL_ENTRY _ZTI6S639C3[];
extern  VTBL_ENTRY _ZTV6S639C3[];
extern Class_Descriptor cd_S639C2;
extern VTBL_ENTRY _ZTI6S639C2[];
extern  VTBL_ENTRY _ZTV6S639C2[];
static Base_Class bases_S639C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S639C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S639C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S639C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S639C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S639C1[];
extern void _ZN6S639C1D1Ev();
extern void _ZN6S639C1D0Ev();
extern void _ZN6S639C52v5Ev();
extern void _ZN6S639C52v6Ev();
extern void _ZN6S639C52v7Ev();
extern void _ZN6S639C52v8Ev();
extern void _ZN6S639C52v9Ev();
extern void _ZN6S639C53v10Ev();
extern void _ZN6S639C53v11Ev();
extern void _ZN6S639C53v12Ev();
extern void _ZN6S639C53v13Ev();
extern void _ZN6S639C53v14Ev();
extern void _ZN6S639C53v15Ev();
extern void _ZN6S639C53v16Ev();
extern void _ZN6S639C53v17Ev();
extern void _ZN6S639C53v18Ev();
extern void _ZN6S639C53v19Ev();
extern void _ZN6S639C53v20Ev();
extern void _ZN6S639C53v21Ev();
extern void _ZN6S639C53v22Ev();
extern void _ZN6S639C53v23Ev();
extern void _ZN6S639C53v24Ev();
extern void _ZN6S639C53v25Ev();
extern void _ZN6S639C53v26Ev();
extern void _ZN6S639C53v27Ev();
extern void _ZN6S639C53v28Ev();
extern void _ZN6S639C53v29Ev();
extern void _ZN6S639C53v30Ev();
extern void _ZN6S639C53v31Ev();
extern void _ZN6S639C53v32Ev();
extern void _ZN6S639C53v33Ev();
extern void _ZN6S639C53v34Ev();
extern void _ZN6S639C53v35Ev();
extern void _ZN6S639C53v36Ev();
extern void _ZN6S639C53v37Ev();
extern void _ZN6S639C53v38Ev();
extern void _ZN6S639C53v39Ev();
extern void _ZN6S639C53v40Ev();
extern void _ZN6S639C53v41Ev();
extern void _ZN6S639C53v42Ev();
extern void _ZN6S639C53v43Ev();
extern void _ZN6S639C53v44Ev();
extern void _ZN6S639C53v45Ev();
extern void _ZN6S639C53v46Ev();
extern void _ZN6S639C53v47Ev();
extern void _ZN6S639C53v48Ev();
extern void _ZN6S639C53v49Ev();
extern void _ZN6S639C53v50Ev();
extern void _ZN6S639C53v51Ev();
extern void _ZN6S639C53v52Ev();
extern void _ZN6S639C53v53Ev();
extern void _ZN6S639C53v54Ev();
extern void _ZN6S639C53v55Ev();
extern void _ZN6S639C53v56Ev();
extern void _ZN6S639C53v57Ev();
extern void _ZN6S639C53v58Ev();
extern void _ZN6S639C53v59Ev();
extern void _ZN6S639C53v60Ev();
extern void _ZN6S639C53v61Ev();
extern void _ZN6S639C53v62Ev();
extern void _ZN6S639C53v63Ev();
extern void _ZN6S639C53v64Ev();
extern void _ZN6S639C53v65Ev();
extern void _ZN6S639C53v66Ev();
extern void _ZN6S639C53v67Ev();
extern void _ZN6S639C53v68Ev();
extern void _ZN6S639C43v69Ev();
extern void _ZN6S639C43v70Ev();
extern void _ZN6S639C43v71Ev();
extern void _ZN6S639C43v72Ev();
extern void _ZN6S639C43v73Ev();
extern void _ZN6S639C43v74Ev();
extern void _ZN6S639C43v75Ev();
extern void _ZN6S639C43v76Ev();
extern void _ZN6S639C43v77Ev();
extern void _ZN6S639C43v78Ev();
extern void _ZN6S639C43v79Ev();
extern void _ZN6S639C43v80Ev();
extern void _ZN6S639C43v81Ev();
extern void _ZN6S639C43v82Ev();
extern void _ZN6S639C43v83Ev();
extern void _ZN6S639C43v84Ev();
extern void _ZN6S639C43v85Ev();
extern void _ZN6S639C43v86Ev();
extern void _ZN6S639C43v87Ev();
extern void _ZN6S639C43v88Ev();
extern void _ZN6S639C43v89Ev();
extern void _ZN6S639C43v90Ev();
extern void _ZN6S639C33v91Ev();
extern void _ZN6S639C33v92Ev();
extern void _ZN6S639C33v93Ev();
extern void _ZN6S639C33v94Ev();
extern void _ZN6S639C33v95Ev();
extern void _ZN6S639C33v96Ev();
extern void _ZN6S639C33v97Ev();
extern void _ZN6S639C33v98Ev();
extern void _ZN6S639C33v99Ev();
extern void _ZN6S639C34v100Ev();
extern void _ZN6S639C34v101Ev();
extern void _ZN6S639C34v102Ev();
extern void _ZN6S639C34v103Ev();
extern void _ZN6S639C34v104Ev();
extern void _ZN6S639C34v105Ev();
extern void _ZN6S639C34v106Ev();
extern void _ZN6S639C34v107Ev();
extern void _ZN6S639C34v108Ev();
extern void _ZN6S639C34v109Ev();
extern void _ZN6S639C24v110Ev();
extern void _ZN6S639C24v111Ev();
extern void _ZN6S639C24v112Ev();
extern void _ZN6S639C24v113Ev();
extern void _ZN6S639C24v114Ev();
extern void _ZN6S639C24v115Ev();
extern void _ZN6S639C24v116Ev();
extern void _ZN6S639C24v117Ev();
extern void _ZN6S639C24v118Ev();
extern void _ZN6S639C12v1Ev();
extern void _ZN6S639C12v2Ev();
extern void _ZN6S639C12v3Ev();
extern void _ZN6S639C12v4Ev();
static  VTBL_ENTRY vtc_S639C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S639C1[0]),
  (VTBL_ENTRY)&_ZN6S639C1D1Ev,
  (VTBL_ENTRY)&_ZN6S639C1D0Ev,
  (VTBL_ENTRY)&_ZN6S639C52v5Ev,
  (VTBL_ENTRY)&_ZN6S639C52v6Ev,
  (VTBL_ENTRY)&_ZN6S639C52v7Ev,
  (VTBL_ENTRY)&_ZN6S639C52v8Ev,
  (VTBL_ENTRY)&_ZN6S639C52v9Ev,
  (VTBL_ENTRY)&_ZN6S639C53v10Ev,
  (VTBL_ENTRY)&_ZN6S639C53v11Ev,
  (VTBL_ENTRY)&_ZN6S639C53v12Ev,
  (VTBL_ENTRY)&_ZN6S639C53v13Ev,
  (VTBL_ENTRY)&_ZN6S639C53v14Ev,
  (VTBL_ENTRY)&_ZN6S639C53v15Ev,
  (VTBL_ENTRY)&_ZN6S639C53v16Ev,
  (VTBL_ENTRY)&_ZN6S639C53v17Ev,
  (VTBL_ENTRY)&_ZN6S639C53v18Ev,
  (VTBL_ENTRY)&_ZN6S639C53v19Ev,
  (VTBL_ENTRY)&_ZN6S639C53v20Ev,
  (VTBL_ENTRY)&_ZN6S639C53v21Ev,
  (VTBL_ENTRY)&_ZN6S639C53v22Ev,
  (VTBL_ENTRY)&_ZN6S639C53v23Ev,
  (VTBL_ENTRY)&_ZN6S639C53v24Ev,
  (VTBL_ENTRY)&_ZN6S639C53v25Ev,
  (VTBL_ENTRY)&_ZN6S639C53v26Ev,
  (VTBL_ENTRY)&_ZN6S639C53v27Ev,
  (VTBL_ENTRY)&_ZN6S639C53v28Ev,
  (VTBL_ENTRY)&_ZN6S639C53v29Ev,
  (VTBL_ENTRY)&_ZN6S639C53v30Ev,
  (VTBL_ENTRY)&_ZN6S639C53v31Ev,
  (VTBL_ENTRY)&_ZN6S639C53v32Ev,
  (VTBL_ENTRY)&_ZN6S639C53v33Ev,
  (VTBL_ENTRY)&_ZN6S639C53v34Ev,
  (VTBL_ENTRY)&_ZN6S639C53v35Ev,
  (VTBL_ENTRY)&_ZN6S639C53v36Ev,
  (VTBL_ENTRY)&_ZN6S639C53v37Ev,
  (VTBL_ENTRY)&_ZN6S639C53v38Ev,
  (VTBL_ENTRY)&_ZN6S639C53v39Ev,
  (VTBL_ENTRY)&_ZN6S639C53v40Ev,
  (VTBL_ENTRY)&_ZN6S639C53v41Ev,
  (VTBL_ENTRY)&_ZN6S639C53v42Ev,
  (VTBL_ENTRY)&_ZN6S639C53v43Ev,
  (VTBL_ENTRY)&_ZN6S639C53v44Ev,
  (VTBL_ENTRY)&_ZN6S639C53v45Ev,
  (VTBL_ENTRY)&_ZN6S639C53v46Ev,
  (VTBL_ENTRY)&_ZN6S639C53v47Ev,
  (VTBL_ENTRY)&_ZN6S639C53v48Ev,
  (VTBL_ENTRY)&_ZN6S639C53v49Ev,
  (VTBL_ENTRY)&_ZN6S639C53v50Ev,
  (VTBL_ENTRY)&_ZN6S639C53v51Ev,
  (VTBL_ENTRY)&_ZN6S639C53v52Ev,
  (VTBL_ENTRY)&_ZN6S639C53v53Ev,
  (VTBL_ENTRY)&_ZN6S639C53v54Ev,
  (VTBL_ENTRY)&_ZN6S639C53v55Ev,
  (VTBL_ENTRY)&_ZN6S639C53v56Ev,
  (VTBL_ENTRY)&_ZN6S639C53v57Ev,
  (VTBL_ENTRY)&_ZN6S639C53v58Ev,
  (VTBL_ENTRY)&_ZN6S639C53v59Ev,
  (VTBL_ENTRY)&_ZN6S639C53v60Ev,
  (VTBL_ENTRY)&_ZN6S639C53v61Ev,
  (VTBL_ENTRY)&_ZN6S639C53v62Ev,
  (VTBL_ENTRY)&_ZN6S639C53v63Ev,
  (VTBL_ENTRY)&_ZN6S639C53v64Ev,
  (VTBL_ENTRY)&_ZN6S639C53v65Ev,
  (VTBL_ENTRY)&_ZN6S639C53v66Ev,
  (VTBL_ENTRY)&_ZN6S639C53v67Ev,
  (VTBL_ENTRY)&_ZN6S639C53v68Ev,
  (VTBL_ENTRY)&_ZN6S639C43v69Ev,
  (VTBL_ENTRY)&_ZN6S639C43v70Ev,
  (VTBL_ENTRY)&_ZN6S639C43v71Ev,
  (VTBL_ENTRY)&_ZN6S639C43v72Ev,
  (VTBL_ENTRY)&_ZN6S639C43v73Ev,
  (VTBL_ENTRY)&_ZN6S639C43v74Ev,
  (VTBL_ENTRY)&_ZN6S639C43v75Ev,
  (VTBL_ENTRY)&_ZN6S639C43v76Ev,
  (VTBL_ENTRY)&_ZN6S639C43v77Ev,
  (VTBL_ENTRY)&_ZN6S639C43v78Ev,
  (VTBL_ENTRY)&_ZN6S639C43v79Ev,
  (VTBL_ENTRY)&_ZN6S639C43v80Ev,
  (VTBL_ENTRY)&_ZN6S639C43v81Ev,
  (VTBL_ENTRY)&_ZN6S639C43v82Ev,
  (VTBL_ENTRY)&_ZN6S639C43v83Ev,
  (VTBL_ENTRY)&_ZN6S639C43v84Ev,
  (VTBL_ENTRY)&_ZN6S639C43v85Ev,
  (VTBL_ENTRY)&_ZN6S639C43v86Ev,
  (VTBL_ENTRY)&_ZN6S639C43v87Ev,
  (VTBL_ENTRY)&_ZN6S639C43v88Ev,
  (VTBL_ENTRY)&_ZN6S639C43v89Ev,
  (VTBL_ENTRY)&_ZN6S639C43v90Ev,
  (VTBL_ENTRY)&_ZN6S639C33v91Ev,
  (VTBL_ENTRY)&_ZN6S639C33v92Ev,
  (VTBL_ENTRY)&_ZN6S639C33v93Ev,
  (VTBL_ENTRY)&_ZN6S639C33v94Ev,
  (VTBL_ENTRY)&_ZN6S639C33v95Ev,
  (VTBL_ENTRY)&_ZN6S639C33v96Ev,
  (VTBL_ENTRY)&_ZN6S639C33v97Ev,
  (VTBL_ENTRY)&_ZN6S639C33v98Ev,
  (VTBL_ENTRY)&_ZN6S639C33v99Ev,
  (VTBL_ENTRY)&_ZN6S639C34v100Ev,
  (VTBL_ENTRY)&_ZN6S639C34v101Ev,
  (VTBL_ENTRY)&_ZN6S639C34v102Ev,
  (VTBL_ENTRY)&_ZN6S639C34v103Ev,
  (VTBL_ENTRY)&_ZN6S639C34v104Ev,
  (VTBL_ENTRY)&_ZN6S639C34v105Ev,
  (VTBL_ENTRY)&_ZN6S639C34v106Ev,
  (VTBL_ENTRY)&_ZN6S639C34v107Ev,
  (VTBL_ENTRY)&_ZN6S639C34v108Ev,
  (VTBL_ENTRY)&_ZN6S639C34v109Ev,
  (VTBL_ENTRY)&_ZN6S639C24v110Ev,
  (VTBL_ENTRY)&_ZN6S639C24v111Ev,
  (VTBL_ENTRY)&_ZN6S639C24v112Ev,
  (VTBL_ENTRY)&_ZN6S639C24v113Ev,
  (VTBL_ENTRY)&_ZN6S639C24v114Ev,
  (VTBL_ENTRY)&_ZN6S639C24v115Ev,
  (VTBL_ENTRY)&_ZN6S639C24v116Ev,
  (VTBL_ENTRY)&_ZN6S639C24v117Ev,
  (VTBL_ENTRY)&_ZN6S639C24v118Ev,
  (VTBL_ENTRY)&_ZN6S639C12v1Ev,
  (VTBL_ENTRY)&_ZN6S639C12v2Ev,
  (VTBL_ENTRY)&_ZN6S639C12v3Ev,
  (VTBL_ENTRY)&_ZN6S639C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S639C1[];
extern  VTBL_ENTRY _ZTV6S639C1[];
Class_Descriptor cd_S639C1 = {  "S639C1", // class name
  bases_S639C1, 4,
  &(vtc_S639C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,156), // object size
  NSPAIRA(_ZTI6S639C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S639C1),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S670C5  {
  int s670c5f0;
  __tsi64 s670c5f1;
  void *s670c5f2[4];
  int s670c5f3[2];
  void *s670c5f4;
  ::S473C6_nt s670c5f5;
  void *s670c5f6[2];
  virtual  ~S670C5(); // _ZN6S670C5D1Ev
  virtual void  v6(); // _ZN6S670C52v6Ev
  virtual void  v7(); // _ZN6S670C52v7Ev
  virtual void  v8(); // _ZN6S670C52v8Ev
  virtual void  v9(); // _ZN6S670C52v9Ev
  virtual void  v10(); // _ZN6S670C53v10Ev
  virtual void  v11(); // _ZN6S670C53v11Ev
  virtual void  v12(); // _ZN6S670C53v12Ev
  virtual void  v13(); // _ZN6S670C53v13Ev
  virtual void  v14(); // _ZN6S670C53v14Ev
  virtual void  v15(); // _ZN6S670C53v15Ev
  virtual void  v16(); // _ZN6S670C53v16Ev
  virtual void  v17(); // _ZN6S670C53v17Ev
  virtual void  v18(); // _ZN6S670C53v18Ev
  virtual void  v19(); // _ZN6S670C53v19Ev
  virtual void  v20(); // _ZN6S670C53v20Ev
  virtual void  v21(); // _ZN6S670C53v21Ev
  virtual void  v22(); // _ZN6S670C53v22Ev
  virtual void  v23(); // _ZN6S670C53v23Ev
  virtual void  v24(); // _ZN6S670C53v24Ev
  virtual void  v25(); // _ZN6S670C53v25Ev
  virtual void  v26(); // _ZN6S670C53v26Ev
  virtual void  v27(); // _ZN6S670C53v27Ev
  virtual void  v28(); // _ZN6S670C53v28Ev
  virtual void  v29(); // _ZN6S670C53v29Ev
  virtual void  v30(); // _ZN6S670C53v30Ev
  virtual void  v31(); // _ZN6S670C53v31Ev
  virtual void  v32(); // _ZN6S670C53v32Ev
  virtual void  v33(); // _ZN6S670C53v33Ev
  virtual void  v34(); // _ZN6S670C53v34Ev
  virtual void  v35(); // _ZN6S670C53v35Ev
  virtual void  v36(); // _ZN6S670C53v36Ev
  virtual void  v37(); // _ZN6S670C53v37Ev
  virtual void  v38(); // _ZN6S670C53v38Ev
  virtual void  v39(); // _ZN6S670C53v39Ev
  virtual void  v40(); // _ZN6S670C53v40Ev
  virtual void  v41(); // _ZN6S670C53v41Ev
  virtual void  v42(); // _ZN6S670C53v42Ev
  virtual void  v43(); // _ZN6S670C53v43Ev
  virtual void  v44(); // _ZN6S670C53v44Ev
  virtual void  v45(); // _ZN6S670C53v45Ev
  virtual void  v46(); // _ZN6S670C53v46Ev
  virtual void  v47(); // _ZN6S670C53v47Ev
  virtual void  v48(); // _ZN6S670C53v48Ev
  virtual void  v49(); // _ZN6S670C53v49Ev
  virtual void  v50(); // _ZN6S670C53v50Ev
  virtual void  v51(); // _ZN6S670C53v51Ev
  virtual void  v52(); // _ZN6S670C53v52Ev
  virtual void  v53(); // _ZN6S670C53v53Ev
  virtual void  v54(); // _ZN6S670C53v54Ev
  virtual void  v55(); // _ZN6S670C53v55Ev
  virtual void  v56(); // _ZN6S670C53v56Ev
  virtual void  v57(); // _ZN6S670C53v57Ev
  virtual void  v58(); // _ZN6S670C53v58Ev
  virtual void  v59(); // _ZN6S670C53v59Ev
  virtual void  v60(); // _ZN6S670C53v60Ev
  virtual void  v61(); // _ZN6S670C53v61Ev
  virtual void  v62(); // _ZN6S670C53v62Ev
  virtual void  v63(); // _ZN6S670C53v63Ev
  virtual void  v64(); // _ZN6S670C53v64Ev
  virtual void  v65(); // _ZN6S670C53v65Ev
  virtual void  v66(); // _ZN6S670C53v66Ev
  virtual void  v67(); // _ZN6S670C53v67Ev
  virtual void  v68(); // _ZN6S670C53v68Ev
  virtual void  v69(); // _ZN6S670C53v69Ev
  S670C5(); // tgen
};
//SIG(-1 S670C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S670C5 ::~S670C5(){ note_dtor("S670C5", this);}
void  S670C5 ::v6(){vfunc_called(this, "_ZN6S670C52v6Ev");}
void  S670C5 ::v7(){vfunc_called(this, "_ZN6S670C52v7Ev");}
void  S670C5 ::v8(){vfunc_called(this, "_ZN6S670C52v8Ev");}
void  S670C5 ::v9(){vfunc_called(this, "_ZN6S670C52v9Ev");}
void  S670C5 ::v10(){vfunc_called(this, "_ZN6S670C53v10Ev");}
void  S670C5 ::v11(){vfunc_called(this, "_ZN6S670C53v11Ev");}
void  S670C5 ::v12(){vfunc_called(this, "_ZN6S670C53v12Ev");}
void  S670C5 ::v13(){vfunc_called(this, "_ZN6S670C53v13Ev");}
void  S670C5 ::v14(){vfunc_called(this, "_ZN6S670C53v14Ev");}
void  S670C5 ::v15(){vfunc_called(this, "_ZN6S670C53v15Ev");}
void  S670C5 ::v16(){vfunc_called(this, "_ZN6S670C53v16Ev");}
void  S670C5 ::v17(){vfunc_called(this, "_ZN6S670C53v17Ev");}
void  S670C5 ::v18(){vfunc_called(this, "_ZN6S670C53v18Ev");}
void  S670C5 ::v19(){vfunc_called(this, "_ZN6S670C53v19Ev");}
void  S670C5 ::v20(){vfunc_called(this, "_ZN6S670C53v20Ev");}
void  S670C5 ::v21(){vfunc_called(this, "_ZN6S670C53v21Ev");}
void  S670C5 ::v22(){vfunc_called(this, "_ZN6S670C53v22Ev");}
void  S670C5 ::v23(){vfunc_called(this, "_ZN6S670C53v23Ev");}
void  S670C5 ::v24(){vfunc_called(this, "_ZN6S670C53v24Ev");}
void  S670C5 ::v25(){vfunc_called(this, "_ZN6S670C53v25Ev");}
void  S670C5 ::v26(){vfunc_called(this, "_ZN6S670C53v26Ev");}
void  S670C5 ::v27(){vfunc_called(this, "_ZN6S670C53v27Ev");}
void  S670C5 ::v28(){vfunc_called(this, "_ZN6S670C53v28Ev");}
void  S670C5 ::v29(){vfunc_called(this, "_ZN6S670C53v29Ev");}
void  S670C5 ::v30(){vfunc_called(this, "_ZN6S670C53v30Ev");}
void  S670C5 ::v31(){vfunc_called(this, "_ZN6S670C53v31Ev");}
void  S670C5 ::v32(){vfunc_called(this, "_ZN6S670C53v32Ev");}
void  S670C5 ::v33(){vfunc_called(this, "_ZN6S670C53v33Ev");}
void  S670C5 ::v34(){vfunc_called(this, "_ZN6S670C53v34Ev");}
void  S670C5 ::v35(){vfunc_called(this, "_ZN6S670C53v35Ev");}
void  S670C5 ::v36(){vfunc_called(this, "_ZN6S670C53v36Ev");}
void  S670C5 ::v37(){vfunc_called(this, "_ZN6S670C53v37Ev");}
void  S670C5 ::v38(){vfunc_called(this, "_ZN6S670C53v38Ev");}
void  S670C5 ::v39(){vfunc_called(this, "_ZN6S670C53v39Ev");}
void  S670C5 ::v40(){vfunc_called(this, "_ZN6S670C53v40Ev");}
void  S670C5 ::v41(){vfunc_called(this, "_ZN6S670C53v41Ev");}
void  S670C5 ::v42(){vfunc_called(this, "_ZN6S670C53v42Ev");}
void  S670C5 ::v43(){vfunc_called(this, "_ZN6S670C53v43Ev");}
void  S670C5 ::v44(){vfunc_called(this, "_ZN6S670C53v44Ev");}
void  S670C5 ::v45(){vfunc_called(this, "_ZN6S670C53v45Ev");}
void  S670C5 ::v46(){vfunc_called(this, "_ZN6S670C53v46Ev");}
void  S670C5 ::v47(){vfunc_called(this, "_ZN6S670C53v47Ev");}
void  S670C5 ::v48(){vfunc_called(this, "_ZN6S670C53v48Ev");}
void  S670C5 ::v49(){vfunc_called(this, "_ZN6S670C53v49Ev");}
void  S670C5 ::v50(){vfunc_called(this, "_ZN6S670C53v50Ev");}
void  S670C5 ::v51(){vfunc_called(this, "_ZN6S670C53v51Ev");}
void  S670C5 ::v52(){vfunc_called(this, "_ZN6S670C53v52Ev");}
void  S670C5 ::v53(){vfunc_called(this, "_ZN6S670C53v53Ev");}
void  S670C5 ::v54(){vfunc_called(this, "_ZN6S670C53v54Ev");}
void  S670C5 ::v55(){vfunc_called(this, "_ZN6S670C53v55Ev");}
void  S670C5 ::v56(){vfunc_called(this, "_ZN6S670C53v56Ev");}
void  S670C5 ::v57(){vfunc_called(this, "_ZN6S670C53v57Ev");}
void  S670C5 ::v58(){vfunc_called(this, "_ZN6S670C53v58Ev");}
void  S670C5 ::v59(){vfunc_called(this, "_ZN6S670C53v59Ev");}
void  S670C5 ::v60(){vfunc_called(this, "_ZN6S670C53v60Ev");}
void  S670C5 ::v61(){vfunc_called(this, "_ZN6S670C53v61Ev");}
void  S670C5 ::v62(){vfunc_called(this, "_ZN6S670C53v62Ev");}
void  S670C5 ::v63(){vfunc_called(this, "_ZN6S670C53v63Ev");}
void  S670C5 ::v64(){vfunc_called(this, "_ZN6S670C53v64Ev");}
void  S670C5 ::v65(){vfunc_called(this, "_ZN6S670C53v65Ev");}
void  S670C5 ::v66(){vfunc_called(this, "_ZN6S670C53v66Ev");}
void  S670C5 ::v67(){vfunc_called(this, "_ZN6S670C53v67Ev");}
void  S670C5 ::v68(){vfunc_called(this, "_ZN6S670C53v68Ev");}
void  S670C5 ::v69(){vfunc_called(this, "_ZN6S670C53v69Ev");}
S670C5 ::S670C5(){ note_ctor("S670C5", this);} // tgen

static void Test_S670C5()
{
  extern Class_Descriptor cd_S670C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S670C5, buf);
    S670C5 *dp, &lv = *(dp=new (buf) S670C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S670C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S670C5)");
    check_field_offset(lv, s670c5f0, ABISELECT(8,4), "S670C5.s670c5f0");
    check_field_offset(lv, s670c5f1, ABISELECT(16,8), "S670C5.s670c5f1");
    check_field_offset(lv, s670c5f2, ABISELECT(24,16), "S670C5.s670c5f2");
    check_field_offset(lv, s670c5f3, ABISELECT(56,32), "S670C5.s670c5f3");
    check_field_offset(lv, s670c5f4, ABISELECT(64,40), "S670C5.s670c5f4");
    check_field_offset(lv, s670c5f5, ABISELECT(72,44), "S670C5.s670c5f5");
    check_field_offset(lv, s670c5f6, ABISELECT(80,52), "S670C5.s670c5f6");
    test_class_info(&lv, &cd_S670C5);
    dp->~S670C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS670C5(Test_S670C5, "S670C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S670C5C1Ev();
extern void _ZN6S670C5D1Ev();
Name_Map name_map_S670C5[] = {
  NSPAIR(_ZN6S670C5C1Ev),
  NSPAIR(_ZN6S670C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S670C5[];
extern void _ZN6S670C5D1Ev();
extern void _ZN6S670C5D0Ev();
extern void _ZN6S670C52v6Ev();
extern void _ZN6S670C52v7Ev();
extern void _ZN6S670C52v8Ev();
extern void _ZN6S670C52v9Ev();
extern void _ZN6S670C53v10Ev();
extern void _ZN6S670C53v11Ev();
extern void _ZN6S670C53v12Ev();
extern void _ZN6S670C53v13Ev();
extern void _ZN6S670C53v14Ev();
extern void _ZN6S670C53v15Ev();
extern void _ZN6S670C53v16Ev();
extern void _ZN6S670C53v17Ev();
extern void _ZN6S670C53v18Ev();
extern void _ZN6S670C53v19Ev();
extern void _ZN6S670C53v20Ev();
extern void _ZN6S670C53v21Ev();
extern void _ZN6S670C53v22Ev();
extern void _ZN6S670C53v23Ev();
extern void _ZN6S670C53v24Ev();
extern void _ZN6S670C53v25Ev();
extern void _ZN6S670C53v26Ev();
extern void _ZN6S670C53v27Ev();
extern void _ZN6S670C53v28Ev();
extern void _ZN6S670C53v29Ev();
extern void _ZN6S670C53v30Ev();
extern void _ZN6S670C53v31Ev();
extern void _ZN6S670C53v32Ev();
extern void _ZN6S670C53v33Ev();
extern void _ZN6S670C53v34Ev();
extern void _ZN6S670C53v35Ev();
extern void _ZN6S670C53v36Ev();
extern void _ZN6S670C53v37Ev();
extern void _ZN6S670C53v38Ev();
extern void _ZN6S670C53v39Ev();
extern void _ZN6S670C53v40Ev();
extern void _ZN6S670C53v41Ev();
extern void _ZN6S670C53v42Ev();
extern void _ZN6S670C53v43Ev();
extern void _ZN6S670C53v44Ev();
extern void _ZN6S670C53v45Ev();
extern void _ZN6S670C53v46Ev();
extern void _ZN6S670C53v47Ev();
extern void _ZN6S670C53v48Ev();
extern void _ZN6S670C53v49Ev();
extern void _ZN6S670C53v50Ev();
extern void _ZN6S670C53v51Ev();
extern void _ZN6S670C53v52Ev();
extern void _ZN6S670C53v53Ev();
extern void _ZN6S670C53v54Ev();
extern void _ZN6S670C53v55Ev();
extern void _ZN6S670C53v56Ev();
extern void _ZN6S670C53v57Ev();
extern void _ZN6S670C53v58Ev();
extern void _ZN6S670C53v59Ev();
extern void _ZN6S670C53v60Ev();
extern void _ZN6S670C53v61Ev();
extern void _ZN6S670C53v62Ev();
extern void _ZN6S670C53v63Ev();
extern void _ZN6S670C53v64Ev();
extern void _ZN6S670C53v65Ev();
extern void _ZN6S670C53v66Ev();
extern void _ZN6S670C53v67Ev();
extern void _ZN6S670C53v68Ev();
extern void _ZN6S670C53v69Ev();
static  VTBL_ENTRY vtc_S670C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S670C5[0]),
  (VTBL_ENTRY)&_ZN6S670C5D1Ev,
  (VTBL_ENTRY)&_ZN6S670C5D0Ev,
  (VTBL_ENTRY)&_ZN6S670C52v6Ev,
  (VTBL_ENTRY)&_ZN6S670C52v7Ev,
  (VTBL_ENTRY)&_ZN6S670C52v8Ev,
  (VTBL_ENTRY)&_ZN6S670C52v9Ev,
  (VTBL_ENTRY)&_ZN6S670C53v10Ev,
  (VTBL_ENTRY)&_ZN6S670C53v11Ev,
  (VTBL_ENTRY)&_ZN6S670C53v12Ev,
  (VTBL_ENTRY)&_ZN6S670C53v13Ev,
  (VTBL_ENTRY)&_ZN6S670C53v14Ev,
  (VTBL_ENTRY)&_ZN6S670C53v15Ev,
  (VTBL_ENTRY)&_ZN6S670C53v16Ev,
  (VTBL_ENTRY)&_ZN6S670C53v17Ev,
  (VTBL_ENTRY)&_ZN6S670C53v18Ev,
  (VTBL_ENTRY)&_ZN6S670C53v19Ev,
  (VTBL_ENTRY)&_ZN6S670C53v20Ev,
  (VTBL_ENTRY)&_ZN6S670C53v21Ev,
  (VTBL_ENTRY)&_ZN6S670C53v22Ev,
  (VTBL_ENTRY)&_ZN6S670C53v23Ev,
  (VTBL_ENTRY)&_ZN6S670C53v24Ev,
  (VTBL_ENTRY)&_ZN6S670C53v25Ev,
  (VTBL_ENTRY)&_ZN6S670C53v26Ev,
  (VTBL_ENTRY)&_ZN6S670C53v27Ev,
  (VTBL_ENTRY)&_ZN6S670C53v28Ev,
  (VTBL_ENTRY)&_ZN6S670C53v29Ev,
  (VTBL_ENTRY)&_ZN6S670C53v30Ev,
  (VTBL_ENTRY)&_ZN6S670C53v31Ev,
  (VTBL_ENTRY)&_ZN6S670C53v32Ev,
  (VTBL_ENTRY)&_ZN6S670C53v33Ev,
  (VTBL_ENTRY)&_ZN6S670C53v34Ev,
  (VTBL_ENTRY)&_ZN6S670C53v35Ev,
  (VTBL_ENTRY)&_ZN6S670C53v36Ev,
  (VTBL_ENTRY)&_ZN6S670C53v37Ev,
  (VTBL_ENTRY)&_ZN6S670C53v38Ev,
  (VTBL_ENTRY)&_ZN6S670C53v39Ev,
  (VTBL_ENTRY)&_ZN6S670C53v40Ev,
  (VTBL_ENTRY)&_ZN6S670C53v41Ev,
  (VTBL_ENTRY)&_ZN6S670C53v42Ev,
  (VTBL_ENTRY)&_ZN6S670C53v43Ev,
  (VTBL_ENTRY)&_ZN6S670C53v44Ev,
  (VTBL_ENTRY)&_ZN6S670C53v45Ev,
  (VTBL_ENTRY)&_ZN6S670C53v46Ev,
  (VTBL_ENTRY)&_ZN6S670C53v47Ev,
  (VTBL_ENTRY)&_ZN6S670C53v48Ev,
  (VTBL_ENTRY)&_ZN6S670C53v49Ev,
  (VTBL_ENTRY)&_ZN6S670C53v50Ev,
  (VTBL_ENTRY)&_ZN6S670C53v51Ev,
  (VTBL_ENTRY)&_ZN6S670C53v52Ev,
  (VTBL_ENTRY)&_ZN6S670C53v53Ev,
  (VTBL_ENTRY)&_ZN6S670C53v54Ev,
  (VTBL_ENTRY)&_ZN6S670C53v55Ev,
  (VTBL_ENTRY)&_ZN6S670C53v56Ev,
  (VTBL_ENTRY)&_ZN6S670C53v57Ev,
  (VTBL_ENTRY)&_ZN6S670C53v58Ev,
  (VTBL_ENTRY)&_ZN6S670C53v59Ev,
  (VTBL_ENTRY)&_ZN6S670C53v60Ev,
  (VTBL_ENTRY)&_ZN6S670C53v61Ev,
  (VTBL_ENTRY)&_ZN6S670C53v62Ev,
  (VTBL_ENTRY)&_ZN6S670C53v63Ev,
  (VTBL_ENTRY)&_ZN6S670C53v64Ev,
  (VTBL_ENTRY)&_ZN6S670C53v65Ev,
  (VTBL_ENTRY)&_ZN6S670C53v66Ev,
  (VTBL_ENTRY)&_ZN6S670C53v67Ev,
  (VTBL_ENTRY)&_ZN6S670C53v68Ev,
  (VTBL_ENTRY)&_ZN6S670C53v69Ev,
};
extern VTBL_ENTRY _ZTI6S670C5[];
extern  VTBL_ENTRY _ZTV6S670C5[];
Class_Descriptor cd_S670C5 = {  "S670C5", // class name
  0,0,//no base classes
  &(vtc_S670C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S670C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S670C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S670C4  : S670C5 {
  int s670c4f0[2];
  void *s670c4f1;
  int s670c4f2[2];
  ::S473C7_nt s670c4f3;
  ::S473C7_nt s670c4f4;
  ::S21925C42 s670c4f5;
  ::S473C7_nt s670c4f6;
  unsigned int s670c4f7:1;
  unsigned int s670c4f8:1;
  unsigned int s670c4f9:1;
  unsigned int s670c4f10:1;
  unsigned int s670c4f11:1;
  int s670c4f12[2];
  virtual  ~S670C4(); // _ZN6S670C4D1Ev
  virtual void  v70(); // _ZN6S670C43v70Ev
  virtual void  v71(); // _ZN6S670C43v71Ev
  virtual void  v72(); // _ZN6S670C43v72Ev
  virtual void  v73(); // _ZN6S670C43v73Ev
  virtual void  v74(); // _ZN6S670C43v74Ev
  virtual void  v75(); // _ZN6S670C43v75Ev
  virtual void  v76(); // _ZN6S670C43v76Ev
  virtual void  v77(); // _ZN6S670C43v77Ev
  virtual void  v78(); // _ZN6S670C43v78Ev
  virtual void  v79(); // _ZN6S670C43v79Ev
  virtual void  v80(); // _ZN6S670C43v80Ev
  virtual void  v81(); // _ZN6S670C43v81Ev
  virtual void  v82(); // _ZN6S670C43v82Ev
  virtual void  v83(); // _ZN6S670C43v83Ev
  virtual void  v84(); // _ZN6S670C43v84Ev
  virtual void  v85(); // _ZN6S670C43v85Ev
  virtual void  v86(); // _ZN6S670C43v86Ev
  virtual void  v87(); // _ZN6S670C43v87Ev
  virtual void  v88(); // _ZN6S670C43v88Ev
  virtual void  v89(); // _ZN6S670C43v89Ev
  virtual void  v90(); // _ZN6S670C43v90Ev
  virtual void  v91(); // _ZN6S670C43v91Ev
  S670C4(); // tgen
};
//SIG(-1 S670C4) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S670C4 ::~S670C4(){ note_dtor("S670C4", this);}
void  S670C4 ::v70(){vfunc_called(this, "_ZN6S670C43v70Ev");}
void  S670C4 ::v71(){vfunc_called(this, "_ZN6S670C43v71Ev");}
void  S670C4 ::v72(){vfunc_called(this, "_ZN6S670C43v72Ev");}
void  S670C4 ::v73(){vfunc_called(this, "_ZN6S670C43v73Ev");}
void  S670C4 ::v74(){vfunc_called(this, "_ZN6S670C43v74Ev");}
void  S670C4 ::v75(){vfunc_called(this, "_ZN6S670C43v75Ev");}
void  S670C4 ::v76(){vfunc_called(this, "_ZN6S670C43v76Ev");}
void  S670C4 ::v77(){vfunc_called(this, "_ZN6S670C43v77Ev");}
void  S670C4 ::v78(){vfunc_called(this, "_ZN6S670C43v78Ev");}
void  S670C4 ::v79(){vfunc_called(this, "_ZN6S670C43v79Ev");}
void  S670C4 ::v80(){vfunc_called(this, "_ZN6S670C43v80Ev");}
void  S670C4 ::v81(){vfunc_called(this, "_ZN6S670C43v81Ev");}
void  S670C4 ::v82(){vfunc_called(this, "_ZN6S670C43v82Ev");}
void  S670C4 ::v83(){vfunc_called(this, "_ZN6S670C43v83Ev");}
void  S670C4 ::v84(){vfunc_called(this, "_ZN6S670C43v84Ev");}
void  S670C4 ::v85(){vfunc_called(this, "_ZN6S670C43v85Ev");}
void  S670C4 ::v86(){vfunc_called(this, "_ZN6S670C43v86Ev");}
void  S670C4 ::v87(){vfunc_called(this, "_ZN6S670C43v87Ev");}
void  S670C4 ::v88(){vfunc_called(this, "_ZN6S670C43v88Ev");}
void  S670C4 ::v89(){vfunc_called(this, "_ZN6S670C43v89Ev");}
void  S670C4 ::v90(){vfunc_called(this, "_ZN6S670C43v90Ev");}
void  S670C4 ::v91(){vfunc_called(this, "_ZN6S670C43v91Ev");}
S670C4 ::S670C4(){ note_ctor("S670C4", this);} // tgen

static void Test_S670C4()
{
  extern Class_Descriptor cd_S670C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S670C4, buf);
    S670C4 *dp, &lv = *(dp=new (buf) S670C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S670C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S670C4)");
    check_base_class_offset(lv, (S670C5*), 0, "S670C4");
    check_field_offset(lv, s670c4f0, ABISELECT(96,60), "S670C4.s670c4f0");
    check_field_offset(lv, s670c4f1, ABISELECT(104,68), "S670C4.s670c4f1");
    check_field_offset(lv, s670c4f2, ABISELECT(112,72), "S670C4.s670c4f2");
    check_field_offset(lv, s670c4f3, ABISELECT(120,80), "S670C4.s670c4f3");
    check_field_offset(lv, s670c4f4, ABISELECT(136,92), "S670C4.s670c4f4");
    check_field_offset(lv, s670c4f5, ABISELECT(152,104), "S670C4.s670c4f5");
    check_field_offset(lv, s670c4f6, ABISELECT(160,108), "S670C4.s670c4f6");
    set_bf_and_test(lv, s670c4f7, ABISELECT(176,120), 0, 1, 1, "S670C4");
    set_bf_and_test(lv, s670c4f8, ABISELECT(176,120), 1, 1, 1, "S670C4");
    set_bf_and_test(lv, s670c4f9, ABISELECT(176,120), 2, 1, 1, "S670C4");
    set_bf_and_test(lv, s670c4f10, ABISELECT(176,120), 3, 1, 1, "S670C4");
    set_bf_and_test(lv, s670c4f11, ABISELECT(176,120), 4, 1, 1, "S670C4");
    check_field_offset(lv, s670c4f12, ABISELECT(180,124), "S670C4.s670c4f12");
    test_class_info(&lv, &cd_S670C4);
    dp->~S670C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS670C4(Test_S670C4, "S670C4", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S670C4C1Ev();
extern void _ZN6S670C4D1Ev();
Name_Map name_map_S670C4[] = {
  NSPAIR(_ZN6S670C4C1Ev),
  NSPAIR(_ZN6S670C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S670C5;
extern VTBL_ENTRY _ZTI6S670C5[];
extern  VTBL_ENTRY _ZTV6S670C5[];
static Base_Class bases_S670C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S670C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S670C4[];
extern void _ZN6S670C4D1Ev();
extern void _ZN6S670C4D0Ev();
extern void _ZN6S670C52v6Ev();
extern void _ZN6S670C52v7Ev();
extern void _ZN6S670C52v8Ev();
extern void _ZN6S670C52v9Ev();
extern void _ZN6S670C53v10Ev();
extern void _ZN6S670C53v11Ev();
extern void _ZN6S670C53v12Ev();
extern void _ZN6S670C53v13Ev();
extern void _ZN6S670C53v14Ev();
extern void _ZN6S670C53v15Ev();
extern void _ZN6S670C53v16Ev();
extern void _ZN6S670C53v17Ev();
extern void _ZN6S670C53v18Ev();
extern void _ZN6S670C53v19Ev();
extern void _ZN6S670C53v20Ev();
extern void _ZN6S670C53v21Ev();
extern void _ZN6S670C53v22Ev();
extern void _ZN6S670C53v23Ev();
extern void _ZN6S670C53v24Ev();
extern void _ZN6S670C53v25Ev();
extern void _ZN6S670C53v26Ev();
extern void _ZN6S670C53v27Ev();
extern void _ZN6S670C53v28Ev();
extern void _ZN6S670C53v29Ev();
extern void _ZN6S670C53v30Ev();
extern void _ZN6S670C53v31Ev();
extern void _ZN6S670C53v32Ev();
extern void _ZN6S670C53v33Ev();
extern void _ZN6S670C53v34Ev();
extern void _ZN6S670C53v35Ev();
extern void _ZN6S670C53v36Ev();
extern void _ZN6S670C53v37Ev();
extern void _ZN6S670C53v38Ev();
extern void _ZN6S670C53v39Ev();
extern void _ZN6S670C53v40Ev();
extern void _ZN6S670C53v41Ev();
extern void _ZN6S670C53v42Ev();
extern void _ZN6S670C53v43Ev();
extern void _ZN6S670C53v44Ev();
extern void _ZN6S670C53v45Ev();
extern void _ZN6S670C53v46Ev();
extern void _ZN6S670C53v47Ev();
extern void _ZN6S670C53v48Ev();
extern void _ZN6S670C53v49Ev();
extern void _ZN6S670C53v50Ev();
extern void _ZN6S670C53v51Ev();
extern void _ZN6S670C53v52Ev();
extern void _ZN6S670C53v53Ev();
extern void _ZN6S670C53v54Ev();
extern void _ZN6S670C53v55Ev();
extern void _ZN6S670C53v56Ev();
extern void _ZN6S670C53v57Ev();
extern void _ZN6S670C53v58Ev();
extern void _ZN6S670C53v59Ev();
extern void _ZN6S670C53v60Ev();
extern void _ZN6S670C53v61Ev();
extern void _ZN6S670C53v62Ev();
extern void _ZN6S670C53v63Ev();
extern void _ZN6S670C53v64Ev();
extern void _ZN6S670C53v65Ev();
extern void _ZN6S670C53v66Ev();
extern void _ZN6S670C53v67Ev();
extern void _ZN6S670C53v68Ev();
extern void _ZN6S670C53v69Ev();
extern void _ZN6S670C43v70Ev();
extern void _ZN6S670C43v71Ev();
extern void _ZN6S670C43v72Ev();
extern void _ZN6S670C43v73Ev();
extern void _ZN6S670C43v74Ev();
extern void _ZN6S670C43v75Ev();
extern void _ZN6S670C43v76Ev();
extern void _ZN6S670C43v77Ev();
extern void _ZN6S670C43v78Ev();
extern void _ZN6S670C43v79Ev();
extern void _ZN6S670C43v80Ev();
extern void _ZN6S670C43v81Ev();
extern void _ZN6S670C43v82Ev();
extern void _ZN6S670C43v83Ev();
extern void _ZN6S670C43v84Ev();
extern void _ZN6S670C43v85Ev();
extern void _ZN6S670C43v86Ev();
extern void _ZN6S670C43v87Ev();
extern void _ZN6S670C43v88Ev();
extern void _ZN6S670C43v89Ev();
extern void _ZN6S670C43v90Ev();
extern void _ZN6S670C43v91Ev();
static  VTBL_ENTRY vtc_S670C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S670C4[0]),
  (VTBL_ENTRY)&_ZN6S670C4D1Ev,
  (VTBL_ENTRY)&_ZN6S670C4D0Ev,
  (VTBL_ENTRY)&_ZN6S670C52v6Ev,
  (VTBL_ENTRY)&_ZN6S670C52v7Ev,
  (VTBL_ENTRY)&_ZN6S670C52v8Ev,
  (VTBL_ENTRY)&_ZN6S670C52v9Ev,
  (VTBL_ENTRY)&_ZN6S670C53v10Ev,
  (VTBL_ENTRY)&_ZN6S670C53v11Ev,
  (VTBL_ENTRY)&_ZN6S670C53v12Ev,
  (VTBL_ENTRY)&_ZN6S670C53v13Ev,
  (VTBL_ENTRY)&_ZN6S670C53v14Ev,
  (VTBL_ENTRY)&_ZN6S670C53v15Ev,
  (VTBL_ENTRY)&_ZN6S670C53v16Ev,
  (VTBL_ENTRY)&_ZN6S670C53v17Ev,
  (VTBL_ENTRY)&_ZN6S670C53v18Ev,
  (VTBL_ENTRY)&_ZN6S670C53v19Ev,
  (VTBL_ENTRY)&_ZN6S670C53v20Ev,
  (VTBL_ENTRY)&_ZN6S670C53v21Ev,
  (VTBL_ENTRY)&_ZN6S670C53v22Ev,
  (VTBL_ENTRY)&_ZN6S670C53v23Ev,
  (VTBL_ENTRY)&_ZN6S670C53v24Ev,
  (VTBL_ENTRY)&_ZN6S670C53v25Ev,
  (VTBL_ENTRY)&_ZN6S670C53v26Ev,
  (VTBL_ENTRY)&_ZN6S670C53v27Ev,
  (VTBL_ENTRY)&_ZN6S670C53v28Ev,
  (VTBL_ENTRY)&_ZN6S670C53v29Ev,
  (VTBL_ENTRY)&_ZN6S670C53v30Ev,
  (VTBL_ENTRY)&_ZN6S670C53v31Ev,
  (VTBL_ENTRY)&_ZN6S670C53v32Ev,
  (VTBL_ENTRY)&_ZN6S670C53v33Ev,
  (VTBL_ENTRY)&_ZN6S670C53v34Ev,
  (VTBL_ENTRY)&_ZN6S670C53v35Ev,
  (VTBL_ENTRY)&_ZN6S670C53v36Ev,
  (VTBL_ENTRY)&_ZN6S670C53v37Ev,
  (VTBL_ENTRY)&_ZN6S670C53v38Ev,
  (VTBL_ENTRY)&_ZN6S670C53v39Ev,
  (VTBL_ENTRY)&_ZN6S670C53v40Ev,
  (VTBL_ENTRY)&_ZN6S670C53v41Ev,
  (VTBL_ENTRY)&_ZN6S670C53v42Ev,
  (VTBL_ENTRY)&_ZN6S670C53v43Ev,
  (VTBL_ENTRY)&_ZN6S670C53v44Ev,
  (VTBL_ENTRY)&_ZN6S670C53v45Ev,
  (VTBL_ENTRY)&_ZN6S670C53v46Ev,
  (VTBL_ENTRY)&_ZN6S670C53v47Ev,
  (VTBL_ENTRY)&_ZN6S670C53v48Ev,
  (VTBL_ENTRY)&_ZN6S670C53v49Ev,
  (VTBL_ENTRY)&_ZN6S670C53v50Ev,
  (VTBL_ENTRY)&_ZN6S670C53v51Ev,
  (VTBL_ENTRY)&_ZN6S670C53v52Ev,
  (VTBL_ENTRY)&_ZN6S670C53v53Ev,
  (VTBL_ENTRY)&_ZN6S670C53v54Ev,
  (VTBL_ENTRY)&_ZN6S670C53v55Ev,
  (VTBL_ENTRY)&_ZN6S670C53v56Ev,
  (VTBL_ENTRY)&_ZN6S670C53v57Ev,
  (VTBL_ENTRY)&_ZN6S670C53v58Ev,
  (VTBL_ENTRY)&_ZN6S670C53v59Ev,
  (VTBL_ENTRY)&_ZN6S670C53v60Ev,
  (VTBL_ENTRY)&_ZN6S670C53v61Ev,
  (VTBL_ENTRY)&_ZN6S670C53v62Ev,
  (VTBL_ENTRY)&_ZN6S670C53v63Ev,
  (VTBL_ENTRY)&_ZN6S670C53v64Ev,
  (VTBL_ENTRY)&_ZN6S670C53v65Ev,
  (VTBL_ENTRY)&_ZN6S670C53v66Ev,
  (VTBL_ENTRY)&_ZN6S670C53v67Ev,
  (VTBL_ENTRY)&_ZN6S670C53v68Ev,
  (VTBL_ENTRY)&_ZN6S670C53v69Ev,
  (VTBL_ENTRY)&_ZN6S670C43v70Ev,
  (VTBL_ENTRY)&_ZN6S670C43v71Ev,
  (VTBL_ENTRY)&_ZN6S670C43v72Ev,
  (VTBL_ENTRY)&_ZN6S670C43v73Ev,
  (VTBL_ENTRY)&_ZN6S670C43v74Ev,
  (VTBL_ENTRY)&_ZN6S670C43v75Ev,
  (VTBL_ENTRY)&_ZN6S670C43v76Ev,
  (VTBL_ENTRY)&_ZN6S670C43v77Ev,
  (VTBL_ENTRY)&_ZN6S670C43v78Ev,
  (VTBL_ENTRY)&_ZN6S670C43v79Ev,
  (VTBL_ENTRY)&_ZN6S670C43v80Ev,
  (VTBL_ENTRY)&_ZN6S670C43v81Ev,
  (VTBL_ENTRY)&_ZN6S670C43v82Ev,
  (VTBL_ENTRY)&_ZN6S670C43v83Ev,
  (VTBL_ENTRY)&_ZN6S670C43v84Ev,
  (VTBL_ENTRY)&_ZN6S670C43v85Ev,
  (VTBL_ENTRY)&_ZN6S670C43v86Ev,
  (VTBL_ENTRY)&_ZN6S670C43v87Ev,
  (VTBL_ENTRY)&_ZN6S670C43v88Ev,
  (VTBL_ENTRY)&_ZN6S670C43v89Ev,
  (VTBL_ENTRY)&_ZN6S670C43v90Ev,
  (VTBL_ENTRY)&_ZN6S670C43v91Ev,
};
extern VTBL_ENTRY _ZTI6S670C4[];
extern  VTBL_ENTRY _ZTV6S670C4[];
Class_Descriptor cd_S670C4 = {  "S670C4", // class name
  bases_S670C4, 1,
  &(vtc_S670C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S670C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S670C4),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S670C3  : S670C4 {
  ::S473C6_nt s670c3f0;
  virtual  ~S670C3(); // _ZN6S670C3D1Ev
  virtual void  v92(); // _ZN6S670C33v92Ev
  virtual void  v93(); // _ZN6S670C33v93Ev
  virtual void  v94(); // _ZN6S670C33v94Ev
  virtual void  v95(); // _ZN6S670C33v95Ev
  virtual void  v96(); // _ZN6S670C33v96Ev
  virtual void  v97(); // _ZN6S670C33v97Ev
  virtual void  v98(); // _ZN6S670C33v98Ev
  virtual void  v99(); // _ZN6S670C33v99Ev
  virtual void  v100(); // _ZN6S670C34v100Ev
  virtual void  v101(); // _ZN6S670C34v101Ev
  virtual void  v102(); // _ZN6S670C34v102Ev
  virtual void  v103(); // _ZN6S670C34v103Ev
  virtual void  v104(); // _ZN6S670C34v104Ev
  virtual void  v105(); // _ZN6S670C34v105Ev
  virtual void  v106(); // _ZN6S670C34v106Ev
  virtual void  v107(); // _ZN6S670C34v107Ev
  virtual void  v108(); // _ZN6S670C34v108Ev
  virtual void  v109(); // _ZN6S670C34v109Ev
  virtual void  v110(); // _ZN6S670C34v110Ev
  S670C3(); // tgen
};
//SIG(-1 S670C3) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S670C3 ::~S670C3(){ note_dtor("S670C3", this);}
void  S670C3 ::v92(){vfunc_called(this, "_ZN6S670C33v92Ev");}
void  S670C3 ::v93(){vfunc_called(this, "_ZN6S670C33v93Ev");}
void  S670C3 ::v94(){vfunc_called(this, "_ZN6S670C33v94Ev");}
void  S670C3 ::v95(){vfunc_called(this, "_ZN6S670C33v95Ev");}
void  S670C3 ::v96(){vfunc_called(this, "_ZN6S670C33v96Ev");}
void  S670C3 ::v97(){vfunc_called(this, "_ZN6S670C33v97Ev");}
void  S670C3 ::v98(){vfunc_called(this, "_ZN6S670C33v98Ev");}
void  S670C3 ::v99(){vfunc_called(this, "_ZN6S670C33v99Ev");}
void  S670C3 ::v100(){vfunc_called(this, "_ZN6S670C34v100Ev");}
void  S670C3 ::v101(){vfunc_called(this, "_ZN6S670C34v101Ev");}
void  S670C3 ::v102(){vfunc_called(this, "_ZN6S670C34v102Ev");}
void  S670C3 ::v103(){vfunc_called(this, "_ZN6S670C34v103Ev");}
void  S670C3 ::v104(){vfunc_called(this, "_ZN6S670C34v104Ev");}
void  S670C3 ::v105(){vfunc_called(this, "_ZN6S670C34v105Ev");}
void  S670C3 ::v106(){vfunc_called(this, "_ZN6S670C34v106Ev");}
void  S670C3 ::v107(){vfunc_called(this, "_ZN6S670C34v107Ev");}
void  S670C3 ::v108(){vfunc_called(this, "_ZN6S670C34v108Ev");}
void  S670C3 ::v109(){vfunc_called(this, "_ZN6S670C34v109Ev");}
void  S670C3 ::v110(){vfunc_called(this, "_ZN6S670C34v110Ev");}
S670C3 ::S670C3(){ note_ctor("S670C3", this);} // tgen

static void Test_S670C3()
{
  extern Class_Descriptor cd_S670C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S670C3, buf);
    S670C3 *dp, &lv = *(dp=new (buf) S670C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S670C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S670C3)");
    check_base_class_offset(lv, (S670C5*)(S670C4*), 0, "S670C3");
    check_base_class_offset(lv, (S670C4*), 0, "S670C3");
    check_field_offset(lv, s670c3f0, ABISELECT(188,132), "S670C3.s670c3f0");
    test_class_info(&lv, &cd_S670C3);
    dp->~S670C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS670C3(Test_S670C3, "S670C3", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S670C3C1Ev();
extern void _ZN6S670C3D1Ev();
Name_Map name_map_S670C3[] = {
  NSPAIR(_ZN6S670C3C1Ev),
  NSPAIR(_ZN6S670C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S670C5;
extern VTBL_ENTRY _ZTI6S670C5[];
extern  VTBL_ENTRY _ZTV6S670C5[];
extern Class_Descriptor cd_S670C4;
extern VTBL_ENTRY _ZTI6S670C4[];
extern  VTBL_ENTRY _ZTV6S670C4[];
static Base_Class bases_S670C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S670C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S670C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S670C3[];
extern void _ZN6S670C3D1Ev();
extern void _ZN6S670C3D0Ev();
extern void _ZN6S670C52v6Ev();
extern void _ZN6S670C52v7Ev();
extern void _ZN6S670C52v8Ev();
extern void _ZN6S670C52v9Ev();
extern void _ZN6S670C53v10Ev();
extern void _ZN6S670C53v11Ev();
extern void _ZN6S670C53v12Ev();
extern void _ZN6S670C53v13Ev();
extern void _ZN6S670C53v14Ev();
extern void _ZN6S670C53v15Ev();
extern void _ZN6S670C53v16Ev();
extern void _ZN6S670C53v17Ev();
extern void _ZN6S670C53v18Ev();
extern void _ZN6S670C53v19Ev();
extern void _ZN6S670C53v20Ev();
extern void _ZN6S670C53v21Ev();
extern void _ZN6S670C53v22Ev();
extern void _ZN6S670C53v23Ev();
extern void _ZN6S670C53v24Ev();
extern void _ZN6S670C53v25Ev();
extern void _ZN6S670C53v26Ev();
extern void _ZN6S670C53v27Ev();
extern void _ZN6S670C53v28Ev();
extern void _ZN6S670C53v29Ev();
extern void _ZN6S670C53v30Ev();
extern void _ZN6S670C53v31Ev();
extern void _ZN6S670C53v32Ev();
extern void _ZN6S670C53v33Ev();
extern void _ZN6S670C53v34Ev();
extern void _ZN6S670C53v35Ev();
extern void _ZN6S670C53v36Ev();
extern void _ZN6S670C53v37Ev();
extern void _ZN6S670C53v38Ev();
extern void _ZN6S670C53v39Ev();
extern void _ZN6S670C53v40Ev();
extern void _ZN6S670C53v41Ev();
extern void _ZN6S670C53v42Ev();
extern void _ZN6S670C53v43Ev();
extern void _ZN6S670C53v44Ev();
extern void _ZN6S670C53v45Ev();
extern void _ZN6S670C53v46Ev();
extern void _ZN6S670C53v47Ev();
extern void _ZN6S670C53v48Ev();
extern void _ZN6S670C53v49Ev();
extern void _ZN6S670C53v50Ev();
extern void _ZN6S670C53v51Ev();
extern void _ZN6S670C53v52Ev();
extern void _ZN6S670C53v53Ev();
extern void _ZN6S670C53v54Ev();
extern void _ZN6S670C53v55Ev();
extern void _ZN6S670C53v56Ev();
extern void _ZN6S670C53v57Ev();
extern void _ZN6S670C53v58Ev();
extern void _ZN6S670C53v59Ev();
extern void _ZN6S670C53v60Ev();
extern void _ZN6S670C53v61Ev();
extern void _ZN6S670C53v62Ev();
extern void _ZN6S670C53v63Ev();
extern void _ZN6S670C53v64Ev();
extern void _ZN6S670C53v65Ev();
extern void _ZN6S670C53v66Ev();
extern void _ZN6S670C53v67Ev();
extern void _ZN6S670C53v68Ev();
extern void _ZN6S670C53v69Ev();
extern void _ZN6S670C43v70Ev();
extern void _ZN6S670C43v71Ev();
extern void _ZN6S670C43v72Ev();
extern void _ZN6S670C43v73Ev();
extern void _ZN6S670C43v74Ev();
extern void _ZN6S670C43v75Ev();
extern void _ZN6S670C43v76Ev();
extern void _ZN6S670C43v77Ev();
extern void _ZN6S670C43v78Ev();
extern void _ZN6S670C43v79Ev();
extern void _ZN6S670C43v80Ev();
extern void _ZN6S670C43v81Ev();
extern void _ZN6S670C43v82Ev();
extern void _ZN6S670C43v83Ev();
extern void _ZN6S670C43v84Ev();
extern void _ZN6S670C43v85Ev();
extern void _ZN6S670C43v86Ev();
extern void _ZN6S670C43v87Ev();
extern void _ZN6S670C43v88Ev();
extern void _ZN6S670C43v89Ev();
extern void _ZN6S670C43v90Ev();
extern void _ZN6S670C43v91Ev();
extern void _ZN6S670C33v92Ev();
extern void _ZN6S670C33v93Ev();
extern void _ZN6S670C33v94Ev();
extern void _ZN6S670C33v95Ev();
extern void _ZN6S670C33v96Ev();
extern void _ZN6S670C33v97Ev();
extern void _ZN6S670C33v98Ev();
extern void _ZN6S670C33v99Ev();
extern void _ZN6S670C34v100Ev();
extern void _ZN6S670C34v101Ev();
extern void _ZN6S670C34v102Ev();
extern void _ZN6S670C34v103Ev();
extern void _ZN6S670C34v104Ev();
extern void _ZN6S670C34v105Ev();
extern void _ZN6S670C34v106Ev();
extern void _ZN6S670C34v107Ev();
extern void _ZN6S670C34v108Ev();
extern void _ZN6S670C34v109Ev();
extern void _ZN6S670C34v110Ev();
static  VTBL_ENTRY vtc_S670C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S670C3[0]),
  (VTBL_ENTRY)&_ZN6S670C3D1Ev,
  (VTBL_ENTRY)&_ZN6S670C3D0Ev,
  (VTBL_ENTRY)&_ZN6S670C52v6Ev,
  (VTBL_ENTRY)&_ZN6S670C52v7Ev,
  (VTBL_ENTRY)&_ZN6S670C52v8Ev,
  (VTBL_ENTRY)&_ZN6S670C52v9Ev,
  (VTBL_ENTRY)&_ZN6S670C53v10Ev,
  (VTBL_ENTRY)&_ZN6S670C53v11Ev,
  (VTBL_ENTRY)&_ZN6S670C53v12Ev,
  (VTBL_ENTRY)&_ZN6S670C53v13Ev,
  (VTBL_ENTRY)&_ZN6S670C53v14Ev,
  (VTBL_ENTRY)&_ZN6S670C53v15Ev,
  (VTBL_ENTRY)&_ZN6S670C53v16Ev,
  (VTBL_ENTRY)&_ZN6S670C53v17Ev,
  (VTBL_ENTRY)&_ZN6S670C53v18Ev,
  (VTBL_ENTRY)&_ZN6S670C53v19Ev,
  (VTBL_ENTRY)&_ZN6S670C53v20Ev,
  (VTBL_ENTRY)&_ZN6S670C53v21Ev,
  (VTBL_ENTRY)&_ZN6S670C53v22Ev,
  (VTBL_ENTRY)&_ZN6S670C53v23Ev,
  (VTBL_ENTRY)&_ZN6S670C53v24Ev,
  (VTBL_ENTRY)&_ZN6S670C53v25Ev,
  (VTBL_ENTRY)&_ZN6S670C53v26Ev,
  (VTBL_ENTRY)&_ZN6S670C53v27Ev,
  (VTBL_ENTRY)&_ZN6S670C53v28Ev,
  (VTBL_ENTRY)&_ZN6S670C53v29Ev,
  (VTBL_ENTRY)&_ZN6S670C53v30Ev,
  (VTBL_ENTRY)&_ZN6S670C53v31Ev,
  (VTBL_ENTRY)&_ZN6S670C53v32Ev,
  (VTBL_ENTRY)&_ZN6S670C53v33Ev,
  (VTBL_ENTRY)&_ZN6S670C53v34Ev,
  (VTBL_ENTRY)&_ZN6S670C53v35Ev,
  (VTBL_ENTRY)&_ZN6S670C53v36Ev,
  (VTBL_ENTRY)&_ZN6S670C53v37Ev,
  (VTBL_ENTRY)&_ZN6S670C53v38Ev,
  (VTBL_ENTRY)&_ZN6S670C53v39Ev,
  (VTBL_ENTRY)&_ZN6S670C53v40Ev,
  (VTBL_ENTRY)&_ZN6S670C53v41Ev,
  (VTBL_ENTRY)&_ZN6S670C53v42Ev,
  (VTBL_ENTRY)&_ZN6S670C53v43Ev,
  (VTBL_ENTRY)&_ZN6S670C53v44Ev,
  (VTBL_ENTRY)&_ZN6S670C53v45Ev,
  (VTBL_ENTRY)&_ZN6S670C53v46Ev,
  (VTBL_ENTRY)&_ZN6S670C53v47Ev,
  (VTBL_ENTRY)&_ZN6S670C53v48Ev,
  (VTBL_ENTRY)&_ZN6S670C53v49Ev,
  (VTBL_ENTRY)&_ZN6S670C53v50Ev,
  (VTBL_ENTRY)&_ZN6S670C53v51Ev,
  (VTBL_ENTRY)&_ZN6S670C53v52Ev,
  (VTBL_ENTRY)&_ZN6S670C53v53Ev,
  (VTBL_ENTRY)&_ZN6S670C53v54Ev,
  (VTBL_ENTRY)&_ZN6S670C53v55Ev,
  (VTBL_ENTRY)&_ZN6S670C53v56Ev,
  (VTBL_ENTRY)&_ZN6S670C53v57Ev,
  (VTBL_ENTRY)&_ZN6S670C53v58Ev,
  (VTBL_ENTRY)&_ZN6S670C53v59Ev,
  (VTBL_ENTRY)&_ZN6S670C53v60Ev,
  (VTBL_ENTRY)&_ZN6S670C53v61Ev,
  (VTBL_ENTRY)&_ZN6S670C53v62Ev,
  (VTBL_ENTRY)&_ZN6S670C53v63Ev,
  (VTBL_ENTRY)&_ZN6S670C53v64Ev,
  (VTBL_ENTRY)&_ZN6S670C53v65Ev,
  (VTBL_ENTRY)&_ZN6S670C53v66Ev,
  (VTBL_ENTRY)&_ZN6S670C53v67Ev,
  (VTBL_ENTRY)&_ZN6S670C53v68Ev,
  (VTBL_ENTRY)&_ZN6S670C53v69Ev,
  (VTBL_ENTRY)&_ZN6S670C43v70Ev,
  (VTBL_ENTRY)&_ZN6S670C43v71Ev,
  (VTBL_ENTRY)&_ZN6S670C43v72Ev,
  (VTBL_ENTRY)&_ZN6S670C43v73Ev,
  (VTBL_ENTRY)&_ZN6S670C43v74Ev,
  (VTBL_ENTRY)&_ZN6S670C43v75Ev,
  (VTBL_ENTRY)&_ZN6S670C43v76Ev,
  (VTBL_ENTRY)&_ZN6S670C43v77Ev,
  (VTBL_ENTRY)&_ZN6S670C43v78Ev,
  (VTBL_ENTRY)&_ZN6S670C43v79Ev,
  (VTBL_ENTRY)&_ZN6S670C43v80Ev,
  (VTBL_ENTRY)&_ZN6S670C43v81Ev,
  (VTBL_ENTRY)&_ZN6S670C43v82Ev,
  (VTBL_ENTRY)&_ZN6S670C43v83Ev,
  (VTBL_ENTRY)&_ZN6S670C43v84Ev,
  (VTBL_ENTRY)&_ZN6S670C43v85Ev,
  (VTBL_ENTRY)&_ZN6S670C43v86Ev,
  (VTBL_ENTRY)&_ZN6S670C43v87Ev,
  (VTBL_ENTRY)&_ZN6S670C43v88Ev,
  (VTBL_ENTRY)&_ZN6S670C43v89Ev,
  (VTBL_ENTRY)&_ZN6S670C43v90Ev,
  (VTBL_ENTRY)&_ZN6S670C43v91Ev,
  (VTBL_ENTRY)&_ZN6S670C33v92Ev,
  (VTBL_ENTRY)&_ZN6S670C33v93Ev,
  (VTBL_ENTRY)&_ZN6S670C33v94Ev,
  (VTBL_ENTRY)&_ZN6S670C33v95Ev,
  (VTBL_ENTRY)&_ZN6S670C33v96Ev,
  (VTBL_ENTRY)&_ZN6S670C33v97Ev,
  (VTBL_ENTRY)&_ZN6S670C33v98Ev,
  (VTBL_ENTRY)&_ZN6S670C33v99Ev,
  (VTBL_ENTRY)&_ZN6S670C34v100Ev,
  (VTBL_ENTRY)&_ZN6S670C34v101Ev,
  (VTBL_ENTRY)&_ZN6S670C34v102Ev,
  (VTBL_ENTRY)&_ZN6S670C34v103Ev,
  (VTBL_ENTRY)&_ZN6S670C34v104Ev,
  (VTBL_ENTRY)&_ZN6S670C34v105Ev,
  (VTBL_ENTRY)&_ZN6S670C34v106Ev,
  (VTBL_ENTRY)&_ZN6S670C34v107Ev,
  (VTBL_ENTRY)&_ZN6S670C34v108Ev,
  (VTBL_ENTRY)&_ZN6S670C34v109Ev,
  (VTBL_ENTRY)&_ZN6S670C34v110Ev,
};
extern VTBL_ENTRY _ZTI6S670C3[];
extern  VTBL_ENTRY _ZTV6S670C3[];
Class_Descriptor cd_S670C3 = {  "S670C3", // class name
  bases_S670C3, 2,
  &(vtc_S670C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S670C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S670C3),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S670C2  : S670C3 {
  int s670c2f0;
  virtual  ~S670C2(); // _ZN6S670C2D1Ev
  virtual void  v111(); // _ZN6S670C24v111Ev
  virtual void  v112(); // _ZN6S670C24v112Ev
  virtual void  v113(); // _ZN6S670C24v113Ev
  virtual void  v114(); // _ZN6S670C24v114Ev
  virtual void  v115(); // _ZN6S670C24v115Ev
  virtual void  v116(); // _ZN6S670C24v116Ev
  virtual void  v117(); // _ZN6S670C24v117Ev
  S670C2(); // tgen
};
//SIG(-1 S670C2) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 FC5} vd v1 v2 v3 v4 v5 v6 v7 Fi}


 S670C2 ::~S670C2(){ note_dtor("S670C2", this);}
void  S670C2 ::v111(){vfunc_called(this, "_ZN6S670C24v111Ev");}
void  S670C2 ::v112(){vfunc_called(this, "_ZN6S670C24v112Ev");}
void  S670C2 ::v113(){vfunc_called(this, "_ZN6S670C24v113Ev");}
void  S670C2 ::v114(){vfunc_called(this, "_ZN6S670C24v114Ev");}
void  S670C2 ::v115(){vfunc_called(this, "_ZN6S670C24v115Ev");}
void  S670C2 ::v116(){vfunc_called(this, "_ZN6S670C24v116Ev");}
void  S670C2 ::v117(){vfunc_called(this, "_ZN6S670C24v117Ev");}
S670C2 ::S670C2(){ note_ctor("S670C2", this);} // tgen

static void Test_S670C2()
{
  extern Class_Descriptor cd_S670C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,37)];
    init_test(&cd_S670C2, buf);
    S670C2 *dp, &lv = *(dp=new (buf) S670C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,144), "sizeof(S670C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S670C2)");
    check_base_class_offset(lv, (S670C5*)(S670C4*)(S670C3*), 0, "S670C2");
    check_base_class_offset(lv, (S670C4*)(S670C3*), 0, "S670C2");
    check_base_class_offset(lv, (S670C3*), 0, "S670C2");
    check_field_offset(lv, s670c2f0, ABISELECT(196,140), "S670C2.s670c2f0");
    test_class_info(&lv, &cd_S670C2);
    dp->~S670C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS670C2(Test_S670C2, "S670C2", ABISELECT(200,144));

#else // __cplusplus

extern void _ZN6S670C2C1Ev();
extern void _ZN6S670C2D1Ev();
Name_Map name_map_S670C2[] = {
  NSPAIR(_ZN6S670C2C1Ev),
  NSPAIR(_ZN6S670C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S670C5;
extern VTBL_ENTRY _ZTI6S670C5[];
extern  VTBL_ENTRY _ZTV6S670C5[];
extern Class_Descriptor cd_S670C4;
extern VTBL_ENTRY _ZTI6S670C4[];
extern  VTBL_ENTRY _ZTV6S670C4[];
extern Class_Descriptor cd_S670C3;
extern VTBL_ENTRY _ZTI6S670C3[];
extern  VTBL_ENTRY _ZTV6S670C3[];
static Base_Class bases_S670C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S670C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S670C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S670C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S670C2[];
extern void _ZN6S670C2D1Ev();
extern void _ZN6S670C2D0Ev();
extern void _ZN6S670C52v6Ev();
extern void _ZN6S670C52v7Ev();
extern void _ZN6S670C52v8Ev();
extern void _ZN6S670C52v9Ev();
extern void _ZN6S670C53v10Ev();
extern void _ZN6S670C53v11Ev();
extern void _ZN6S670C53v12Ev();
extern void _ZN6S670C53v13Ev();
extern void _ZN6S670C53v14Ev();
extern void _ZN6S670C53v15Ev();
extern void _ZN6S670C53v16Ev();
extern void _ZN6S670C53v17Ev();
extern void _ZN6S670C53v18Ev();
extern void _ZN6S670C53v19Ev();
extern void _ZN6S670C53v20Ev();
extern void _ZN6S670C53v21Ev();
extern void _ZN6S670C53v22Ev();
extern void _ZN6S670C53v23Ev();
extern void _ZN6S670C53v24Ev();
extern void _ZN6S670C53v25Ev();
extern void _ZN6S670C53v26Ev();
extern void _ZN6S670C53v27Ev();
extern void _ZN6S670C53v28Ev();
extern void _ZN6S670C53v29Ev();
extern void _ZN6S670C53v30Ev();
extern void _ZN6S670C53v31Ev();
extern void _ZN6S670C53v32Ev();
extern void _ZN6S670C53v33Ev();
extern void _ZN6S670C53v34Ev();
extern void _ZN6S670C53v35Ev();
extern void _ZN6S670C53v36Ev();
extern void _ZN6S670C53v37Ev();
extern void _ZN6S670C53v38Ev();
extern void _ZN6S670C53v39Ev();
extern void _ZN6S670C53v40Ev();
extern void _ZN6S670C53v41Ev();
extern void _ZN6S670C53v42Ev();
extern void _ZN6S670C53v43Ev();
extern void _ZN6S670C53v44Ev();
extern void _ZN6S670C53v45Ev();
extern void _ZN6S670C53v46Ev();
extern void _ZN6S670C53v47Ev();
extern void _ZN6S670C53v48Ev();
extern void _ZN6S670C53v49Ev();
extern void _ZN6S670C53v50Ev();
extern void _ZN6S670C53v51Ev();
extern void _ZN6S670C53v52Ev();
extern void _ZN6S670C53v53Ev();
extern void _ZN6S670C53v54Ev();
extern void _ZN6S670C53v55Ev();
extern void _ZN6S670C53v56Ev();
extern void _ZN6S670C53v57Ev();
extern void _ZN6S670C53v58Ev();
extern void _ZN6S670C53v59Ev();
extern void _ZN6S670C53v60Ev();
extern void _ZN6S670C53v61Ev();
extern void _ZN6S670C53v62Ev();
extern void _ZN6S670C53v63Ev();
extern void _ZN6S670C53v64Ev();
extern void _ZN6S670C53v65Ev();
extern void _ZN6S670C53v66Ev();
extern void _ZN6S670C53v67Ev();
extern void _ZN6S670C53v68Ev();
extern void _ZN6S670C53v69Ev();
extern void _ZN6S670C43v70Ev();
extern void _ZN6S670C43v71Ev();
extern void _ZN6S670C43v72Ev();
extern void _ZN6S670C43v73Ev();
extern void _ZN6S670C43v74Ev();
extern void _ZN6S670C43v75Ev();
extern void _ZN6S670C43v76Ev();
extern void _ZN6S670C43v77Ev();
extern void _ZN6S670C43v78Ev();
extern void _ZN6S670C43v79Ev();
extern void _ZN6S670C43v80Ev();
extern void _ZN6S670C43v81Ev();
extern void _ZN6S670C43v82Ev();
extern void _ZN6S670C43v83Ev();
extern void _ZN6S670C43v84Ev();
extern void _ZN6S670C43v85Ev();
extern void _ZN6S670C43v86Ev();
extern void _ZN6S670C43v87Ev();
extern void _ZN6S670C43v88Ev();
extern void _ZN6S670C43v89Ev();
extern void _ZN6S670C43v90Ev();
extern void _ZN6S670C43v91Ev();
extern void _ZN6S670C33v92Ev();
extern void _ZN6S670C33v93Ev();
extern void _ZN6S670C33v94Ev();
extern void _ZN6S670C33v95Ev();
extern void _ZN6S670C33v96Ev();
extern void _ZN6S670C33v97Ev();
extern void _ZN6S670C33v98Ev();
extern void _ZN6S670C33v99Ev();
extern void _ZN6S670C34v100Ev();
extern void _ZN6S670C34v101Ev();
extern void _ZN6S670C34v102Ev();
extern void _ZN6S670C34v103Ev();
extern void _ZN6S670C34v104Ev();
extern void _ZN6S670C34v105Ev();
extern void _ZN6S670C34v106Ev();
extern void _ZN6S670C34v107Ev();
extern void _ZN6S670C34v108Ev();
extern void _ZN6S670C34v109Ev();
extern void _ZN6S670C34v110Ev();
extern void _ZN6S670C24v111Ev();
extern void _ZN6S670C24v112Ev();
extern void _ZN6S670C24v113Ev();
extern void _ZN6S670C24v114Ev();
extern void _ZN6S670C24v115Ev();
extern void _ZN6S670C24v116Ev();
extern void _ZN6S670C24v117Ev();
static  VTBL_ENTRY vtc_S670C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S670C2[0]),
  (VTBL_ENTRY)&_ZN6S670C2D1Ev,
  (VTBL_ENTRY)&_ZN6S670C2D0Ev,
  (VTBL_ENTRY)&_ZN6S670C52v6Ev,
  (VTBL_ENTRY)&_ZN6S670C52v7Ev,
  (VTBL_ENTRY)&_ZN6S670C52v8Ev,
  (VTBL_ENTRY)&_ZN6S670C52v9Ev,
  (VTBL_ENTRY)&_ZN6S670C53v10Ev,
  (VTBL_ENTRY)&_ZN6S670C53v11Ev,
  (VTBL_ENTRY)&_ZN6S670C53v12Ev,
  (VTBL_ENTRY)&_ZN6S670C53v13Ev,
  (VTBL_ENTRY)&_ZN6S670C53v14Ev,
  (VTBL_ENTRY)&_ZN6S670C53v15Ev,
  (VTBL_ENTRY)&_ZN6S670C53v16Ev,
  (VTBL_ENTRY)&_ZN6S670C53v17Ev,
  (VTBL_ENTRY)&_ZN6S670C53v18Ev,
  (VTBL_ENTRY)&_ZN6S670C53v19Ev,
  (VTBL_ENTRY)&_ZN6S670C53v20Ev,
  (VTBL_ENTRY)&_ZN6S670C53v21Ev,
  (VTBL_ENTRY)&_ZN6S670C53v22Ev,
  (VTBL_ENTRY)&_ZN6S670C53v23Ev,
  (VTBL_ENTRY)&_ZN6S670C53v24Ev,
  (VTBL_ENTRY)&_ZN6S670C53v25Ev,
  (VTBL_ENTRY)&_ZN6S670C53v26Ev,
  (VTBL_ENTRY)&_ZN6S670C53v27Ev,
  (VTBL_ENTRY)&_ZN6S670C53v28Ev,
  (VTBL_ENTRY)&_ZN6S670C53v29Ev,
  (VTBL_ENTRY)&_ZN6S670C53v30Ev,
  (VTBL_ENTRY)&_ZN6S670C53v31Ev,
  (VTBL_ENTRY)&_ZN6S670C53v32Ev,
  (VTBL_ENTRY)&_ZN6S670C53v33Ev,
  (VTBL_ENTRY)&_ZN6S670C53v34Ev,
  (VTBL_ENTRY)&_ZN6S670C53v35Ev,
  (VTBL_ENTRY)&_ZN6S670C53v36Ev,
  (VTBL_ENTRY)&_ZN6S670C53v37Ev,
  (VTBL_ENTRY)&_ZN6S670C53v38Ev,
  (VTBL_ENTRY)&_ZN6S670C53v39Ev,
  (VTBL_ENTRY)&_ZN6S670C53v40Ev,
  (VTBL_ENTRY)&_ZN6S670C53v41Ev,
  (VTBL_ENTRY)&_ZN6S670C53v42Ev,
  (VTBL_ENTRY)&_ZN6S670C53v43Ev,
  (VTBL_ENTRY)&_ZN6S670C53v44Ev,
  (VTBL_ENTRY)&_ZN6S670C53v45Ev,
  (VTBL_ENTRY)&_ZN6S670C53v46Ev,
  (VTBL_ENTRY)&_ZN6S670C53v47Ev,
  (VTBL_ENTRY)&_ZN6S670C53v48Ev,
  (VTBL_ENTRY)&_ZN6S670C53v49Ev,
  (VTBL_ENTRY)&_ZN6S670C53v50Ev,
  (VTBL_ENTRY)&_ZN6S670C53v51Ev,
  (VTBL_ENTRY)&_ZN6S670C53v52Ev,
  (VTBL_ENTRY)&_ZN6S670C53v53Ev,
  (VTBL_ENTRY)&_ZN6S670C53v54Ev,
  (VTBL_ENTRY)&_ZN6S670C53v55Ev,
  (VTBL_ENTRY)&_ZN6S670C53v56Ev,
  (VTBL_ENTRY)&_ZN6S670C53v57Ev,
  (VTBL_ENTRY)&_ZN6S670C53v58Ev,
  (VTBL_ENTRY)&_ZN6S670C53v59Ev,
  (VTBL_ENTRY)&_ZN6S670C53v60Ev,
  (VTBL_ENTRY)&_ZN6S670C53v61Ev,
  (VTBL_ENTRY)&_ZN6S670C53v62Ev,
  (VTBL_ENTRY)&_ZN6S670C53v63Ev,
  (VTBL_ENTRY)&_ZN6S670C53v64Ev,
  (VTBL_ENTRY)&_ZN6S670C53v65Ev,
  (VTBL_ENTRY)&_ZN6S670C53v66Ev,
  (VTBL_ENTRY)&_ZN6S670C53v67Ev,
  (VTBL_ENTRY)&_ZN6S670C53v68Ev,
  (VTBL_ENTRY)&_ZN6S670C53v69Ev,
  (VTBL_ENTRY)&_ZN6S670C43v70Ev,
  (VTBL_ENTRY)&_ZN6S670C43v71Ev,
  (VTBL_ENTRY)&_ZN6S670C43v72Ev,
  (VTBL_ENTRY)&_ZN6S670C43v73Ev,
  (VTBL_ENTRY)&_ZN6S670C43v74Ev,
  (VTBL_ENTRY)&_ZN6S670C43v75Ev,
  (VTBL_ENTRY)&_ZN6S670C43v76Ev,
  (VTBL_ENTRY)&_ZN6S670C43v77Ev,
  (VTBL_ENTRY)&_ZN6S670C43v78Ev,
  (VTBL_ENTRY)&_ZN6S670C43v79Ev,
  (VTBL_ENTRY)&_ZN6S670C43v80Ev,
  (VTBL_ENTRY)&_ZN6S670C43v81Ev,
  (VTBL_ENTRY)&_ZN6S670C43v82Ev,
  (VTBL_ENTRY)&_ZN6S670C43v83Ev,
  (VTBL_ENTRY)&_ZN6S670C43v84Ev,
  (VTBL_ENTRY)&_ZN6S670C43v85Ev,
  (VTBL_ENTRY)&_ZN6S670C43v86Ev,
  (VTBL_ENTRY)&_ZN6S670C43v87Ev,
  (VTBL_ENTRY)&_ZN6S670C43v88Ev,
  (VTBL_ENTRY)&_ZN6S670C43v89Ev,
  (VTBL_ENTRY)&_ZN6S670C43v90Ev,
  (VTBL_ENTRY)&_ZN6S670C43v91Ev,
  (VTBL_ENTRY)&_ZN6S670C33v92Ev,
  (VTBL_ENTRY)&_ZN6S670C33v93Ev,
  (VTBL_ENTRY)&_ZN6S670C33v94Ev,
  (VTBL_ENTRY)&_ZN6S670C33v95Ev,
  (VTBL_ENTRY)&_ZN6S670C33v96Ev,
  (VTBL_ENTRY)&_ZN6S670C33v97Ev,
  (VTBL_ENTRY)&_ZN6S670C33v98Ev,
  (VTBL_ENTRY)&_ZN6S670C33v99Ev,
  (VTBL_ENTRY)&_ZN6S670C34v100Ev,
  (VTBL_ENTRY)&_ZN6S670C34v101Ev,
  (VTBL_ENTRY)&_ZN6S670C34v102Ev,
  (VTBL_ENTRY)&_ZN6S670C34v103Ev,
  (VTBL_ENTRY)&_ZN6S670C34v104Ev,
  (VTBL_ENTRY)&_ZN6S670C34v105Ev,
  (VTBL_ENTRY)&_ZN6S670C34v106Ev,
  (VTBL_ENTRY)&_ZN6S670C34v107Ev,
  (VTBL_ENTRY)&_ZN6S670C34v108Ev,
  (VTBL_ENTRY)&_ZN6S670C34v109Ev,
  (VTBL_ENTRY)&_ZN6S670C34v110Ev,
  (VTBL_ENTRY)&_ZN6S670C24v111Ev,
  (VTBL_ENTRY)&_ZN6S670C24v112Ev,
  (VTBL_ENTRY)&_ZN6S670C24v113Ev,
  (VTBL_ENTRY)&_ZN6S670C24v114Ev,
  (VTBL_ENTRY)&_ZN6S670C24v115Ev,
  (VTBL_ENTRY)&_ZN6S670C24v116Ev,
  (VTBL_ENTRY)&_ZN6S670C24v117Ev,
};
extern VTBL_ENTRY _ZTI6S670C2[];
extern  VTBL_ENTRY _ZTV6S670C2[];
Class_Descriptor cd_S670C2 = {  "S670C2", // class name
  bases_S670C2, 3,
  &(vtc_S670C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,144), // object size
  NSPAIRA(_ZTI6S670C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S670C2),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S670C1  : S670C2 {
  int s670c1f0[2];
  virtual  ~S670C1(); // _ZN6S670C1D1Ev
  virtual void  v1(); // _ZN6S670C12v1Ev
  virtual void  v2(); // _ZN6S670C12v2Ev
  virtual void  v3(); // _ZN6S670C12v3Ev
  virtual void  v4(); // _ZN6S670C12v4Ev
  virtual void  v5(); // _ZN6S670C12v5Ev
  S670C1(); // tgen
};
//SIG(1 S670C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC6} vd v111 v112 v113 v114 v115 v116 v117 Fi} vd v1 v2 v3 v4 v5 Fi[2]}


 S670C1 ::~S670C1(){ note_dtor("S670C1", this);}
void  S670C1 ::v1(){vfunc_called(this, "_ZN6S670C12v1Ev");}
void  S670C1 ::v2(){vfunc_called(this, "_ZN6S670C12v2Ev");}
void  S670C1 ::v3(){vfunc_called(this, "_ZN6S670C12v3Ev");}
void  S670C1 ::v4(){vfunc_called(this, "_ZN6S670C12v4Ev");}
void  S670C1 ::v5(){vfunc_called(this, "_ZN6S670C12v5Ev");}
S670C1 ::S670C1(){ note_ctor("S670C1", this);} // tgen

static void Test_S670C1()
{
  extern Class_Descriptor cd_S670C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,39)];
    init_test(&cd_S670C1, buf);
    S670C1 *dp, &lv = *(dp=new (buf) S670C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,152), "sizeof(S670C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S670C1)");
    check_base_class_offset(lv, (S670C5*)(S670C4*)(S670C3*)(S670C2*), 0, "S670C1");
    check_base_class_offset(lv, (S670C4*)(S670C3*)(S670C2*), 0, "S670C1");
    check_base_class_offset(lv, (S670C3*)(S670C2*), 0, "S670C1");
    check_base_class_offset(lv, (S670C2*), 0, "S670C1");
    check_field_offset(lv, s670c1f0, ABISELECT(200,144), "S670C1.s670c1f0");
    test_class_info(&lv, &cd_S670C1);
    dp->~S670C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS670C1(Test_S670C1, "S670C1", ABISELECT(208,152));

#else // __cplusplus

extern void _ZN6S670C1C1Ev();
extern void _ZN6S670C1D1Ev();
Name_Map name_map_S670C1[] = {
  NSPAIR(_ZN6S670C1C1Ev),
  NSPAIR(_ZN6S670C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S670C5;
extern VTBL_ENTRY _ZTI6S670C5[];
extern  VTBL_ENTRY _ZTV6S670C5[];
extern Class_Descriptor cd_S670C4;
extern VTBL_ENTRY _ZTI6S670C4[];
extern  VTBL_ENTRY _ZTV6S670C4[];
extern Class_Descriptor cd_S670C3;
extern VTBL_ENTRY _ZTI6S670C3[];
extern  VTBL_ENTRY _ZTV6S670C3[];
extern Class_Descriptor cd_S670C2;
extern VTBL_ENTRY _ZTI6S670C2[];
extern  VTBL_ENTRY _ZTV6S670C2[];
static Base_Class bases_S670C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S670C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S670C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S670C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S670C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S670C1[];
extern void _ZN6S670C1D1Ev();
extern void _ZN6S670C1D0Ev();
extern void _ZN6S670C52v6Ev();
extern void _ZN6S670C52v7Ev();
extern void _ZN6S670C52v8Ev();
extern void _ZN6S670C52v9Ev();
extern void _ZN6S670C53v10Ev();
extern void _ZN6S670C53v11Ev();
extern void _ZN6S670C53v12Ev();
extern void _ZN6S670C53v13Ev();
extern void _ZN6S670C53v14Ev();
extern void _ZN6S670C53v15Ev();
extern void _ZN6S670C53v16Ev();
extern void _ZN6S670C53v17Ev();
extern void _ZN6S670C53v18Ev();
extern void _ZN6S670C53v19Ev();
extern void _ZN6S670C53v20Ev();
extern void _ZN6S670C53v21Ev();
extern void _ZN6S670C53v22Ev();
extern void _ZN6S670C53v23Ev();
extern void _ZN6S670C53v24Ev();
extern void _ZN6S670C53v25Ev();
extern void _ZN6S670C53v26Ev();
extern void _ZN6S670C53v27Ev();
extern void _ZN6S670C53v28Ev();
extern void _ZN6S670C53v29Ev();
extern void _ZN6S670C53v30Ev();
extern void _ZN6S670C53v31Ev();
extern void _ZN6S670C53v32Ev();
extern void _ZN6S670C53v33Ev();
extern void _ZN6S670C53v34Ev();
extern void _ZN6S670C53v35Ev();
extern void _ZN6S670C53v36Ev();
extern void _ZN6S670C53v37Ev();
extern void _ZN6S670C53v38Ev();
extern void _ZN6S670C53v39Ev();
extern void _ZN6S670C53v40Ev();
extern void _ZN6S670C53v41Ev();
extern void _ZN6S670C53v42Ev();
extern void _ZN6S670C53v43Ev();
extern void _ZN6S670C53v44Ev();
extern void _ZN6S670C53v45Ev();
extern void _ZN6S670C53v46Ev();
extern void _ZN6S670C53v47Ev();
extern void _ZN6S670C53v48Ev();
extern void _ZN6S670C53v49Ev();
extern void _ZN6S670C53v50Ev();
extern void _ZN6S670C53v51Ev();
extern void _ZN6S670C53v52Ev();
extern void _ZN6S670C53v53Ev();
extern void _ZN6S670C53v54Ev();
extern void _ZN6S670C53v55Ev();
extern void _ZN6S670C53v56Ev();
extern void _ZN6S670C53v57Ev();
extern void _ZN6S670C53v58Ev();
extern void _ZN6S670C53v59Ev();
extern void _ZN6S670C53v60Ev();
extern void _ZN6S670C53v61Ev();
extern void _ZN6S670C53v62Ev();
extern void _ZN6S670C53v63Ev();
extern void _ZN6S670C53v64Ev();
extern void _ZN6S670C53v65Ev();
extern void _ZN6S670C53v66Ev();
extern void _ZN6S670C53v67Ev();
extern void _ZN6S670C53v68Ev();
extern void _ZN6S670C53v69Ev();
extern void _ZN6S670C43v70Ev();
extern void _ZN6S670C43v71Ev();
extern void _ZN6S670C43v72Ev();
extern void _ZN6S670C43v73Ev();
extern void _ZN6S670C43v74Ev();
extern void _ZN6S670C43v75Ev();
extern void _ZN6S670C43v76Ev();
extern void _ZN6S670C43v77Ev();
extern void _ZN6S670C43v78Ev();
extern void _ZN6S670C43v79Ev();
extern void _ZN6S670C43v80Ev();
extern void _ZN6S670C43v81Ev();
extern void _ZN6S670C43v82Ev();
extern void _ZN6S670C43v83Ev();
extern void _ZN6S670C43v84Ev();
extern void _ZN6S670C43v85Ev();
extern void _ZN6S670C43v86Ev();
extern void _ZN6S670C43v87Ev();
extern void _ZN6S670C43v88Ev();
extern void _ZN6S670C43v89Ev();
extern void _ZN6S670C43v90Ev();
extern void _ZN6S670C43v91Ev();
extern void _ZN6S670C33v92Ev();
extern void _ZN6S670C33v93Ev();
extern void _ZN6S670C33v94Ev();
extern void _ZN6S670C33v95Ev();
extern void _ZN6S670C33v96Ev();
extern void _ZN6S670C33v97Ev();
extern void _ZN6S670C33v98Ev();
extern void _ZN6S670C33v99Ev();
extern void _ZN6S670C34v100Ev();
extern void _ZN6S670C34v101Ev();
extern void _ZN6S670C34v102Ev();
extern void _ZN6S670C34v103Ev();
extern void _ZN6S670C34v104Ev();
extern void _ZN6S670C34v105Ev();
extern void _ZN6S670C34v106Ev();
extern void _ZN6S670C34v107Ev();
extern void _ZN6S670C34v108Ev();
extern void _ZN6S670C34v109Ev();
extern void _ZN6S670C34v110Ev();
extern void _ZN6S670C24v111Ev();
extern void _ZN6S670C24v112Ev();
extern void _ZN6S670C24v113Ev();
extern void _ZN6S670C24v114Ev();
extern void _ZN6S670C24v115Ev();
extern void _ZN6S670C24v116Ev();
extern void _ZN6S670C24v117Ev();
extern void _ZN6S670C12v1Ev();
extern void _ZN6S670C12v2Ev();
extern void _ZN6S670C12v3Ev();
extern void _ZN6S670C12v4Ev();
extern void _ZN6S670C12v5Ev();
static  VTBL_ENTRY vtc_S670C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S670C1[0]),
  (VTBL_ENTRY)&_ZN6S670C1D1Ev,
  (VTBL_ENTRY)&_ZN6S670C1D0Ev,
  (VTBL_ENTRY)&_ZN6S670C52v6Ev,
  (VTBL_ENTRY)&_ZN6S670C52v7Ev,
  (VTBL_ENTRY)&_ZN6S670C52v8Ev,
  (VTBL_ENTRY)&_ZN6S670C52v9Ev,
  (VTBL_ENTRY)&_ZN6S670C53v10Ev,
  (VTBL_ENTRY)&_ZN6S670C53v11Ev,
  (VTBL_ENTRY)&_ZN6S670C53v12Ev,
  (VTBL_ENTRY)&_ZN6S670C53v13Ev,
  (VTBL_ENTRY)&_ZN6S670C53v14Ev,
  (VTBL_ENTRY)&_ZN6S670C53v15Ev,
  (VTBL_ENTRY)&_ZN6S670C53v16Ev,
  (VTBL_ENTRY)&_ZN6S670C53v17Ev,
  (VTBL_ENTRY)&_ZN6S670C53v18Ev,
  (VTBL_ENTRY)&_ZN6S670C53v19Ev,
  (VTBL_ENTRY)&_ZN6S670C53v20Ev,
  (VTBL_ENTRY)&_ZN6S670C53v21Ev,
  (VTBL_ENTRY)&_ZN6S670C53v22Ev,
  (VTBL_ENTRY)&_ZN6S670C53v23Ev,
  (VTBL_ENTRY)&_ZN6S670C53v24Ev,
  (VTBL_ENTRY)&_ZN6S670C53v25Ev,
  (VTBL_ENTRY)&_ZN6S670C53v26Ev,
  (VTBL_ENTRY)&_ZN6S670C53v27Ev,
  (VTBL_ENTRY)&_ZN6S670C53v28Ev,
  (VTBL_ENTRY)&_ZN6S670C53v29Ev,
  (VTBL_ENTRY)&_ZN6S670C53v30Ev,
  (VTBL_ENTRY)&_ZN6S670C53v31Ev,
  (VTBL_ENTRY)&_ZN6S670C53v32Ev,
  (VTBL_ENTRY)&_ZN6S670C53v33Ev,
  (VTBL_ENTRY)&_ZN6S670C53v34Ev,
  (VTBL_ENTRY)&_ZN6S670C53v35Ev,
  (VTBL_ENTRY)&_ZN6S670C53v36Ev,
  (VTBL_ENTRY)&_ZN6S670C53v37Ev,
  (VTBL_ENTRY)&_ZN6S670C53v38Ev,
  (VTBL_ENTRY)&_ZN6S670C53v39Ev,
  (VTBL_ENTRY)&_ZN6S670C53v40Ev,
  (VTBL_ENTRY)&_ZN6S670C53v41Ev,
  (VTBL_ENTRY)&_ZN6S670C53v42Ev,
  (VTBL_ENTRY)&_ZN6S670C53v43Ev,
  (VTBL_ENTRY)&_ZN6S670C53v44Ev,
  (VTBL_ENTRY)&_ZN6S670C53v45Ev,
  (VTBL_ENTRY)&_ZN6S670C53v46Ev,
  (VTBL_ENTRY)&_ZN6S670C53v47Ev,
  (VTBL_ENTRY)&_ZN6S670C53v48Ev,
  (VTBL_ENTRY)&_ZN6S670C53v49Ev,
  (VTBL_ENTRY)&_ZN6S670C53v50Ev,
  (VTBL_ENTRY)&_ZN6S670C53v51Ev,
  (VTBL_ENTRY)&_ZN6S670C53v52Ev,
  (VTBL_ENTRY)&_ZN6S670C53v53Ev,
  (VTBL_ENTRY)&_ZN6S670C53v54Ev,
  (VTBL_ENTRY)&_ZN6S670C53v55Ev,
  (VTBL_ENTRY)&_ZN6S670C53v56Ev,
  (VTBL_ENTRY)&_ZN6S670C53v57Ev,
  (VTBL_ENTRY)&_ZN6S670C53v58Ev,
  (VTBL_ENTRY)&_ZN6S670C53v59Ev,
  (VTBL_ENTRY)&_ZN6S670C53v60Ev,
  (VTBL_ENTRY)&_ZN6S670C53v61Ev,
  (VTBL_ENTRY)&_ZN6S670C53v62Ev,
  (VTBL_ENTRY)&_ZN6S670C53v63Ev,
  (VTBL_ENTRY)&_ZN6S670C53v64Ev,
  (VTBL_ENTRY)&_ZN6S670C53v65Ev,
  (VTBL_ENTRY)&_ZN6S670C53v66Ev,
  (VTBL_ENTRY)&_ZN6S670C53v67Ev,
  (VTBL_ENTRY)&_ZN6S670C53v68Ev,
  (VTBL_ENTRY)&_ZN6S670C53v69Ev,
  (VTBL_ENTRY)&_ZN6S670C43v70Ev,
  (VTBL_ENTRY)&_ZN6S670C43v71Ev,
  (VTBL_ENTRY)&_ZN6S670C43v72Ev,
  (VTBL_ENTRY)&_ZN6S670C43v73Ev,
  (VTBL_ENTRY)&_ZN6S670C43v74Ev,
  (VTBL_ENTRY)&_ZN6S670C43v75Ev,
  (VTBL_ENTRY)&_ZN6S670C43v76Ev,
  (VTBL_ENTRY)&_ZN6S670C43v77Ev,
  (VTBL_ENTRY)&_ZN6S670C43v78Ev,
  (VTBL_ENTRY)&_ZN6S670C43v79Ev,
  (VTBL_ENTRY)&_ZN6S670C43v80Ev,
  (VTBL_ENTRY)&_ZN6S670C43v81Ev,
  (VTBL_ENTRY)&_ZN6S670C43v82Ev,
  (VTBL_ENTRY)&_ZN6S670C43v83Ev,
  (VTBL_ENTRY)&_ZN6S670C43v84Ev,
  (VTBL_ENTRY)&_ZN6S670C43v85Ev,
  (VTBL_ENTRY)&_ZN6S670C43v86Ev,
  (VTBL_ENTRY)&_ZN6S670C43v87Ev,
  (VTBL_ENTRY)&_ZN6S670C43v88Ev,
  (VTBL_ENTRY)&_ZN6S670C43v89Ev,
  (VTBL_ENTRY)&_ZN6S670C43v90Ev,
  (VTBL_ENTRY)&_ZN6S670C43v91Ev,
  (VTBL_ENTRY)&_ZN6S670C33v92Ev,
  (VTBL_ENTRY)&_ZN6S670C33v93Ev,
  (VTBL_ENTRY)&_ZN6S670C33v94Ev,
  (VTBL_ENTRY)&_ZN6S670C33v95Ev,
  (VTBL_ENTRY)&_ZN6S670C33v96Ev,
  (VTBL_ENTRY)&_ZN6S670C33v97Ev,
  (VTBL_ENTRY)&_ZN6S670C33v98Ev,
  (VTBL_ENTRY)&_ZN6S670C33v99Ev,
  (VTBL_ENTRY)&_ZN6S670C34v100Ev,
  (VTBL_ENTRY)&_ZN6S670C34v101Ev,
  (VTBL_ENTRY)&_ZN6S670C34v102Ev,
  (VTBL_ENTRY)&_ZN6S670C34v103Ev,
  (VTBL_ENTRY)&_ZN6S670C34v104Ev,
  (VTBL_ENTRY)&_ZN6S670C34v105Ev,
  (VTBL_ENTRY)&_ZN6S670C34v106Ev,
  (VTBL_ENTRY)&_ZN6S670C34v107Ev,
  (VTBL_ENTRY)&_ZN6S670C34v108Ev,
  (VTBL_ENTRY)&_ZN6S670C34v109Ev,
  (VTBL_ENTRY)&_ZN6S670C34v110Ev,
  (VTBL_ENTRY)&_ZN6S670C24v111Ev,
  (VTBL_ENTRY)&_ZN6S670C24v112Ev,
  (VTBL_ENTRY)&_ZN6S670C24v113Ev,
  (VTBL_ENTRY)&_ZN6S670C24v114Ev,
  (VTBL_ENTRY)&_ZN6S670C24v115Ev,
  (VTBL_ENTRY)&_ZN6S670C24v116Ev,
  (VTBL_ENTRY)&_ZN6S670C24v117Ev,
  (VTBL_ENTRY)&_ZN6S670C12v1Ev,
  (VTBL_ENTRY)&_ZN6S670C12v2Ev,
  (VTBL_ENTRY)&_ZN6S670C12v3Ev,
  (VTBL_ENTRY)&_ZN6S670C12v4Ev,
  (VTBL_ENTRY)&_ZN6S670C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S670C1[];
extern  VTBL_ENTRY _ZTV6S670C1[];
Class_Descriptor cd_S670C1 = {  "S670C1", // class name
  bases_S670C1, 4,
  &(vtc_S670C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,152), // object size
  NSPAIRA(_ZTI6S670C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S670C1),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1437C4  {
  int s1437c4f0;
  __tsi64 s1437c4f1;
  void *s1437c4f2[4];
  int s1437c4f3[2];
  void *s1437c4f4;
  ::S473C6_nt s1437c4f5;
  void *s1437c4f6[2];
  virtual  ~S1437C4(); // _ZN7S1437C4D1Ev
  virtual void  v4(); // _ZN7S1437C42v4Ev
  virtual void  v5(); // _ZN7S1437C42v5Ev
  virtual void  v6(); // _ZN7S1437C42v6Ev
  virtual void  v7(); // _ZN7S1437C42v7Ev
  virtual void  v8(); // _ZN7S1437C42v8Ev
  virtual void  v9(); // _ZN7S1437C42v9Ev
  virtual void  v10(); // _ZN7S1437C43v10Ev
  virtual void  v11(); // _ZN7S1437C43v11Ev
  virtual void  v12(); // _ZN7S1437C43v12Ev
  virtual void  v13(); // _ZN7S1437C43v13Ev
  virtual void  v14(); // _ZN7S1437C43v14Ev
  virtual void  v15(); // _ZN7S1437C43v15Ev
  virtual void  v16(); // _ZN7S1437C43v16Ev
  virtual void  v17(); // _ZN7S1437C43v17Ev
  virtual void  v18(); // _ZN7S1437C43v18Ev
  virtual void  v19(); // _ZN7S1437C43v19Ev
  virtual void  v20(); // _ZN7S1437C43v20Ev
  virtual void  v21(); // _ZN7S1437C43v21Ev
  virtual void  v22(); // _ZN7S1437C43v22Ev
  virtual void  v23(); // _ZN7S1437C43v23Ev
  virtual void  v24(); // _ZN7S1437C43v24Ev
  virtual void  v25(); // _ZN7S1437C43v25Ev
  virtual void  v26(); // _ZN7S1437C43v26Ev
  virtual void  v27(); // _ZN7S1437C43v27Ev
  virtual void  v28(); // _ZN7S1437C43v28Ev
  virtual void  v29(); // _ZN7S1437C43v29Ev
  virtual void  v30(); // _ZN7S1437C43v30Ev
  virtual void  v31(); // _ZN7S1437C43v31Ev
  virtual void  v32(); // _ZN7S1437C43v32Ev
  virtual void  v33(); // _ZN7S1437C43v33Ev
  virtual void  v34(); // _ZN7S1437C43v34Ev
  virtual void  v35(); // _ZN7S1437C43v35Ev
  virtual void  v36(); // _ZN7S1437C43v36Ev
  virtual void  v37(); // _ZN7S1437C43v37Ev
  virtual void  v38(); // _ZN7S1437C43v38Ev
  virtual void  v39(); // _ZN7S1437C43v39Ev
  virtual void  v40(); // _ZN7S1437C43v40Ev
  virtual void  v41(); // _ZN7S1437C43v41Ev
  virtual void  v42(); // _ZN7S1437C43v42Ev
  virtual void  v43(); // _ZN7S1437C43v43Ev
  virtual void  v44(); // _ZN7S1437C43v44Ev
  virtual void  v45(); // _ZN7S1437C43v45Ev
  virtual void  v46(); // _ZN7S1437C43v46Ev
  virtual void  v47(); // _ZN7S1437C43v47Ev
  virtual void  v48(); // _ZN7S1437C43v48Ev
  virtual void  v49(); // _ZN7S1437C43v49Ev
  virtual void  v50(); // _ZN7S1437C43v50Ev
  virtual void  v51(); // _ZN7S1437C43v51Ev
  virtual void  v52(); // _ZN7S1437C43v52Ev
  virtual void  v53(); // _ZN7S1437C43v53Ev
  virtual void  v54(); // _ZN7S1437C43v54Ev
  virtual void  v55(); // _ZN7S1437C43v55Ev
  virtual void  v56(); // _ZN7S1437C43v56Ev
  virtual void  v57(); // _ZN7S1437C43v57Ev
  virtual void  v58(); // _ZN7S1437C43v58Ev
  virtual void  v59(); // _ZN7S1437C43v59Ev
  virtual void  v60(); // _ZN7S1437C43v60Ev
  virtual void  v61(); // _ZN7S1437C43v61Ev
  virtual void  v62(); // _ZN7S1437C43v62Ev
  virtual void  v63(); // _ZN7S1437C43v63Ev
  virtual void  v64(); // _ZN7S1437C43v64Ev
  virtual void  v65(); // _ZN7S1437C43v65Ev
  virtual void  v66(); // _ZN7S1437C43v66Ev
  virtual void  v67(); // _ZN7S1437C43v67Ev
  S1437C4(); // tgen
};
//SIG(-1 S1437C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1437C4 ::~S1437C4(){ note_dtor("S1437C4", this);}
void  S1437C4 ::v4(){vfunc_called(this, "_ZN7S1437C42v4Ev");}
void  S1437C4 ::v5(){vfunc_called(this, "_ZN7S1437C42v5Ev");}
void  S1437C4 ::v6(){vfunc_called(this, "_ZN7S1437C42v6Ev");}
void  S1437C4 ::v7(){vfunc_called(this, "_ZN7S1437C42v7Ev");}
void  S1437C4 ::v8(){vfunc_called(this, "_ZN7S1437C42v8Ev");}
void  S1437C4 ::v9(){vfunc_called(this, "_ZN7S1437C42v9Ev");}
void  S1437C4 ::v10(){vfunc_called(this, "_ZN7S1437C43v10Ev");}
void  S1437C4 ::v11(){vfunc_called(this, "_ZN7S1437C43v11Ev");}
void  S1437C4 ::v12(){vfunc_called(this, "_ZN7S1437C43v12Ev");}
void  S1437C4 ::v13(){vfunc_called(this, "_ZN7S1437C43v13Ev");}
void  S1437C4 ::v14(){vfunc_called(this, "_ZN7S1437C43v14Ev");}
void  S1437C4 ::v15(){vfunc_called(this, "_ZN7S1437C43v15Ev");}
void  S1437C4 ::v16(){vfunc_called(this, "_ZN7S1437C43v16Ev");}
void  S1437C4 ::v17(){vfunc_called(this, "_ZN7S1437C43v17Ev");}
void  S1437C4 ::v18(){vfunc_called(this, "_ZN7S1437C43v18Ev");}
void  S1437C4 ::v19(){vfunc_called(this, "_ZN7S1437C43v19Ev");}
void  S1437C4 ::v20(){vfunc_called(this, "_ZN7S1437C43v20Ev");}
void  S1437C4 ::v21(){vfunc_called(this, "_ZN7S1437C43v21Ev");}
void  S1437C4 ::v22(){vfunc_called(this, "_ZN7S1437C43v22Ev");}
void  S1437C4 ::v23(){vfunc_called(this, "_ZN7S1437C43v23Ev");}
void  S1437C4 ::v24(){vfunc_called(this, "_ZN7S1437C43v24Ev");}
void  S1437C4 ::v25(){vfunc_called(this, "_ZN7S1437C43v25Ev");}
void  S1437C4 ::v26(){vfunc_called(this, "_ZN7S1437C43v26Ev");}
void  S1437C4 ::v27(){vfunc_called(this, "_ZN7S1437C43v27Ev");}
void  S1437C4 ::v28(){vfunc_called(this, "_ZN7S1437C43v28Ev");}
void  S1437C4 ::v29(){vfunc_called(this, "_ZN7S1437C43v29Ev");}
void  S1437C4 ::v30(){vfunc_called(this, "_ZN7S1437C43v30Ev");}
void  S1437C4 ::v31(){vfunc_called(this, "_ZN7S1437C43v31Ev");}
void  S1437C4 ::v32(){vfunc_called(this, "_ZN7S1437C43v32Ev");}
void  S1437C4 ::v33(){vfunc_called(this, "_ZN7S1437C43v33Ev");}
void  S1437C4 ::v34(){vfunc_called(this, "_ZN7S1437C43v34Ev");}
void  S1437C4 ::v35(){vfunc_called(this, "_ZN7S1437C43v35Ev");}
void  S1437C4 ::v36(){vfunc_called(this, "_ZN7S1437C43v36Ev");}
void  S1437C4 ::v37(){vfunc_called(this, "_ZN7S1437C43v37Ev");}
void  S1437C4 ::v38(){vfunc_called(this, "_ZN7S1437C43v38Ev");}
void  S1437C4 ::v39(){vfunc_called(this, "_ZN7S1437C43v39Ev");}
void  S1437C4 ::v40(){vfunc_called(this, "_ZN7S1437C43v40Ev");}
void  S1437C4 ::v41(){vfunc_called(this, "_ZN7S1437C43v41Ev");}
void  S1437C4 ::v42(){vfunc_called(this, "_ZN7S1437C43v42Ev");}
void  S1437C4 ::v43(){vfunc_called(this, "_ZN7S1437C43v43Ev");}
void  S1437C4 ::v44(){vfunc_called(this, "_ZN7S1437C43v44Ev");}
void  S1437C4 ::v45(){vfunc_called(this, "_ZN7S1437C43v45Ev");}
void  S1437C4 ::v46(){vfunc_called(this, "_ZN7S1437C43v46Ev");}
void  S1437C4 ::v47(){vfunc_called(this, "_ZN7S1437C43v47Ev");}
void  S1437C4 ::v48(){vfunc_called(this, "_ZN7S1437C43v48Ev");}
void  S1437C4 ::v49(){vfunc_called(this, "_ZN7S1437C43v49Ev");}
void  S1437C4 ::v50(){vfunc_called(this, "_ZN7S1437C43v50Ev");}
void  S1437C4 ::v51(){vfunc_called(this, "_ZN7S1437C43v51Ev");}
void  S1437C4 ::v52(){vfunc_called(this, "_ZN7S1437C43v52Ev");}
void  S1437C4 ::v53(){vfunc_called(this, "_ZN7S1437C43v53Ev");}
void  S1437C4 ::v54(){vfunc_called(this, "_ZN7S1437C43v54Ev");}
void  S1437C4 ::v55(){vfunc_called(this, "_ZN7S1437C43v55Ev");}
void  S1437C4 ::v56(){vfunc_called(this, "_ZN7S1437C43v56Ev");}
void  S1437C4 ::v57(){vfunc_called(this, "_ZN7S1437C43v57Ev");}
void  S1437C4 ::v58(){vfunc_called(this, "_ZN7S1437C43v58Ev");}
void  S1437C4 ::v59(){vfunc_called(this, "_ZN7S1437C43v59Ev");}
void  S1437C4 ::v60(){vfunc_called(this, "_ZN7S1437C43v60Ev");}
void  S1437C4 ::v61(){vfunc_called(this, "_ZN7S1437C43v61Ev");}
void  S1437C4 ::v62(){vfunc_called(this, "_ZN7S1437C43v62Ev");}
void  S1437C4 ::v63(){vfunc_called(this, "_ZN7S1437C43v63Ev");}
void  S1437C4 ::v64(){vfunc_called(this, "_ZN7S1437C43v64Ev");}
void  S1437C4 ::v65(){vfunc_called(this, "_ZN7S1437C43v65Ev");}
void  S1437C4 ::v66(){vfunc_called(this, "_ZN7S1437C43v66Ev");}
void  S1437C4 ::v67(){vfunc_called(this, "_ZN7S1437C43v67Ev");}
S1437C4 ::S1437C4(){ note_ctor("S1437C4", this);} // tgen

static void Test_S1437C4()
{
  extern Class_Descriptor cd_S1437C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1437C4, buf);
    S1437C4 *dp, &lv = *(dp=new (buf) S1437C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1437C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1437C4)");
    check_field_offset(lv, s1437c4f0, ABISELECT(8,4), "S1437C4.s1437c4f0");
    check_field_offset(lv, s1437c4f1, ABISELECT(16,8), "S1437C4.s1437c4f1");
    check_field_offset(lv, s1437c4f2, ABISELECT(24,16), "S1437C4.s1437c4f2");
    check_field_offset(lv, s1437c4f3, ABISELECT(56,32), "S1437C4.s1437c4f3");
    check_field_offset(lv, s1437c4f4, ABISELECT(64,40), "S1437C4.s1437c4f4");
    check_field_offset(lv, s1437c4f5, ABISELECT(72,44), "S1437C4.s1437c4f5");
    check_field_offset(lv, s1437c4f6, ABISELECT(80,52), "S1437C4.s1437c4f6");
    test_class_info(&lv, &cd_S1437C4);
    dp->~S1437C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1437C4(Test_S1437C4, "S1437C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1437C4C1Ev();
extern void _ZN7S1437C4D1Ev();
Name_Map name_map_S1437C4[] = {
  NSPAIR(_ZN7S1437C4C1Ev),
  NSPAIR(_ZN7S1437C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1437C4[];
extern void _ZN7S1437C4D1Ev();
extern void _ZN7S1437C4D0Ev();
extern void _ZN7S1437C42v4Ev();
extern void _ZN7S1437C42v5Ev();
extern void _ZN7S1437C42v6Ev();
extern void _ZN7S1437C42v7Ev();
extern void _ZN7S1437C42v8Ev();
extern void _ZN7S1437C42v9Ev();
extern void _ZN7S1437C43v10Ev();
extern void _ZN7S1437C43v11Ev();
extern void _ZN7S1437C43v12Ev();
extern void _ZN7S1437C43v13Ev();
extern void _ZN7S1437C43v14Ev();
extern void _ZN7S1437C43v15Ev();
extern void _ZN7S1437C43v16Ev();
extern void _ZN7S1437C43v17Ev();
extern void _ZN7S1437C43v18Ev();
extern void _ZN7S1437C43v19Ev();
extern void _ZN7S1437C43v20Ev();
extern void _ZN7S1437C43v21Ev();
extern void _ZN7S1437C43v22Ev();
extern void _ZN7S1437C43v23Ev();
extern void _ZN7S1437C43v24Ev();
extern void _ZN7S1437C43v25Ev();
extern void _ZN7S1437C43v26Ev();
extern void _ZN7S1437C43v27Ev();
extern void _ZN7S1437C43v28Ev();
extern void _ZN7S1437C43v29Ev();
extern void _ZN7S1437C43v30Ev();
extern void _ZN7S1437C43v31Ev();
extern void _ZN7S1437C43v32Ev();
extern void _ZN7S1437C43v33Ev();
extern void _ZN7S1437C43v34Ev();
extern void _ZN7S1437C43v35Ev();
extern void _ZN7S1437C43v36Ev();
extern void _ZN7S1437C43v37Ev();
extern void _ZN7S1437C43v38Ev();
extern void _ZN7S1437C43v39Ev();
extern void _ZN7S1437C43v40Ev();
extern void _ZN7S1437C43v41Ev();
extern void _ZN7S1437C43v42Ev();
extern void _ZN7S1437C43v43Ev();
extern void _ZN7S1437C43v44Ev();
extern void _ZN7S1437C43v45Ev();
extern void _ZN7S1437C43v46Ev();
extern void _ZN7S1437C43v47Ev();
extern void _ZN7S1437C43v48Ev();
extern void _ZN7S1437C43v49Ev();
extern void _ZN7S1437C43v50Ev();
extern void _ZN7S1437C43v51Ev();
extern void _ZN7S1437C43v52Ev();
extern void _ZN7S1437C43v53Ev();
extern void _ZN7S1437C43v54Ev();
extern void _ZN7S1437C43v55Ev();
extern void _ZN7S1437C43v56Ev();
extern void _ZN7S1437C43v57Ev();
extern void _ZN7S1437C43v58Ev();
extern void _ZN7S1437C43v59Ev();
extern void _ZN7S1437C43v60Ev();
extern void _ZN7S1437C43v61Ev();
extern void _ZN7S1437C43v62Ev();
extern void _ZN7S1437C43v63Ev();
extern void _ZN7S1437C43v64Ev();
extern void _ZN7S1437C43v65Ev();
extern void _ZN7S1437C43v66Ev();
extern void _ZN7S1437C43v67Ev();
static  VTBL_ENTRY vtc_S1437C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1437C4[0]),
  (VTBL_ENTRY)&_ZN7S1437C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1437C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v67Ev,
};
extern VTBL_ENTRY _ZTI7S1437C4[];
extern  VTBL_ENTRY _ZTV7S1437C4[];
Class_Descriptor cd_S1437C4 = {  "S1437C4", // class name
  0,0,//no base classes
  &(vtc_S1437C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1437C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1437C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1437C3  : S1437C4 {
  int s1437c3f0[2];
  void *s1437c3f1;
  int s1437c3f2[2];
  ::S473C7_nt s1437c3f3;
  ::S473C7_nt s1437c3f4;
  ::S21925C42 s1437c3f5;
  ::S473C7_nt s1437c3f6;
  unsigned int s1437c3f7:1;
  unsigned int s1437c3f8:1;
  unsigned int s1437c3f9:1;
  unsigned int s1437c3f10:1;
  unsigned int s1437c3f11:1;
  int s1437c3f12[2];
  virtual  ~S1437C3(); // _ZN7S1437C3D1Ev
  virtual void  v68(); // _ZN7S1437C33v68Ev
  virtual void  v69(); // _ZN7S1437C33v69Ev
  virtual void  v70(); // _ZN7S1437C33v70Ev
  virtual void  v71(); // _ZN7S1437C33v71Ev
  virtual void  v72(); // _ZN7S1437C33v72Ev
  virtual void  v73(); // _ZN7S1437C33v73Ev
  virtual void  v74(); // _ZN7S1437C33v74Ev
  virtual void  v75(); // _ZN7S1437C33v75Ev
  virtual void  v76(); // _ZN7S1437C33v76Ev
  virtual void  v77(); // _ZN7S1437C33v77Ev
  virtual void  v78(); // _ZN7S1437C33v78Ev
  virtual void  v79(); // _ZN7S1437C33v79Ev
  virtual void  v80(); // _ZN7S1437C33v80Ev
  virtual void  v81(); // _ZN7S1437C33v81Ev
  virtual void  v82(); // _ZN7S1437C33v82Ev
  virtual void  v83(); // _ZN7S1437C33v83Ev
  virtual void  v84(); // _ZN7S1437C33v84Ev
  virtual void  v85(); // _ZN7S1437C33v85Ev
  virtual void  v86(); // _ZN7S1437C33v86Ev
  virtual void  v87(); // _ZN7S1437C33v87Ev
  virtual void  v88(); // _ZN7S1437C33v88Ev
  virtual void  v89(); // _ZN7S1437C33v89Ev
  S1437C3(); // tgen
};
//SIG(-1 S1437C3) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S1437C3 ::~S1437C3(){ note_dtor("S1437C3", this);}
void  S1437C3 ::v68(){vfunc_called(this, "_ZN7S1437C33v68Ev");}
void  S1437C3 ::v69(){vfunc_called(this, "_ZN7S1437C33v69Ev");}
void  S1437C3 ::v70(){vfunc_called(this, "_ZN7S1437C33v70Ev");}
void  S1437C3 ::v71(){vfunc_called(this, "_ZN7S1437C33v71Ev");}
void  S1437C3 ::v72(){vfunc_called(this, "_ZN7S1437C33v72Ev");}
void  S1437C3 ::v73(){vfunc_called(this, "_ZN7S1437C33v73Ev");}
void  S1437C3 ::v74(){vfunc_called(this, "_ZN7S1437C33v74Ev");}
void  S1437C3 ::v75(){vfunc_called(this, "_ZN7S1437C33v75Ev");}
void  S1437C3 ::v76(){vfunc_called(this, "_ZN7S1437C33v76Ev");}
void  S1437C3 ::v77(){vfunc_called(this, "_ZN7S1437C33v77Ev");}
void  S1437C3 ::v78(){vfunc_called(this, "_ZN7S1437C33v78Ev");}
void  S1437C3 ::v79(){vfunc_called(this, "_ZN7S1437C33v79Ev");}
void  S1437C3 ::v80(){vfunc_called(this, "_ZN7S1437C33v80Ev");}
void  S1437C3 ::v81(){vfunc_called(this, "_ZN7S1437C33v81Ev");}
void  S1437C3 ::v82(){vfunc_called(this, "_ZN7S1437C33v82Ev");}
void  S1437C3 ::v83(){vfunc_called(this, "_ZN7S1437C33v83Ev");}
void  S1437C3 ::v84(){vfunc_called(this, "_ZN7S1437C33v84Ev");}
void  S1437C3 ::v85(){vfunc_called(this, "_ZN7S1437C33v85Ev");}
void  S1437C3 ::v86(){vfunc_called(this, "_ZN7S1437C33v86Ev");}
void  S1437C3 ::v87(){vfunc_called(this, "_ZN7S1437C33v87Ev");}
void  S1437C3 ::v88(){vfunc_called(this, "_ZN7S1437C33v88Ev");}
void  S1437C3 ::v89(){vfunc_called(this, "_ZN7S1437C33v89Ev");}
S1437C3 ::S1437C3(){ note_ctor("S1437C3", this);} // tgen

static void Test_S1437C3()
{
  extern Class_Descriptor cd_S1437C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S1437C3, buf);
    S1437C3 *dp, &lv = *(dp=new (buf) S1437C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S1437C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1437C3)");
    check_base_class_offset(lv, (S1437C4*), 0, "S1437C3");
    check_field_offset(lv, s1437c3f0, ABISELECT(96,60), "S1437C3.s1437c3f0");
    check_field_offset(lv, s1437c3f1, ABISELECT(104,68), "S1437C3.s1437c3f1");
    check_field_offset(lv, s1437c3f2, ABISELECT(112,72), "S1437C3.s1437c3f2");
    check_field_offset(lv, s1437c3f3, ABISELECT(120,80), "S1437C3.s1437c3f3");
    check_field_offset(lv, s1437c3f4, ABISELECT(136,92), "S1437C3.s1437c3f4");
    check_field_offset(lv, s1437c3f5, ABISELECT(152,104), "S1437C3.s1437c3f5");
    check_field_offset(lv, s1437c3f6, ABISELECT(160,108), "S1437C3.s1437c3f6");
    set_bf_and_test(lv, s1437c3f7, ABISELECT(176,120), 0, 1, 1, "S1437C3");
    set_bf_and_test(lv, s1437c3f8, ABISELECT(176,120), 1, 1, 1, "S1437C3");
    set_bf_and_test(lv, s1437c3f9, ABISELECT(176,120), 2, 1, 1, "S1437C3");
    set_bf_and_test(lv, s1437c3f10, ABISELECT(176,120), 3, 1, 1, "S1437C3");
    set_bf_and_test(lv, s1437c3f11, ABISELECT(176,120), 4, 1, 1, "S1437C3");
    check_field_offset(lv, s1437c3f12, ABISELECT(180,124), "S1437C3.s1437c3f12");
    test_class_info(&lv, &cd_S1437C3);
    dp->~S1437C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1437C3(Test_S1437C3, "S1437C3", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN7S1437C3C1Ev();
extern void _ZN7S1437C3D1Ev();
Name_Map name_map_S1437C3[] = {
  NSPAIR(_ZN7S1437C3C1Ev),
  NSPAIR(_ZN7S1437C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1437C4;
extern VTBL_ENTRY _ZTI7S1437C4[];
extern  VTBL_ENTRY _ZTV7S1437C4[];
static Base_Class bases_S1437C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1437C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1437C3[];
extern void _ZN7S1437C3D1Ev();
extern void _ZN7S1437C3D0Ev();
extern void _ZN7S1437C42v4Ev();
extern void _ZN7S1437C42v5Ev();
extern void _ZN7S1437C42v6Ev();
extern void _ZN7S1437C42v7Ev();
extern void _ZN7S1437C42v8Ev();
extern void _ZN7S1437C42v9Ev();
extern void _ZN7S1437C43v10Ev();
extern void _ZN7S1437C43v11Ev();
extern void _ZN7S1437C43v12Ev();
extern void _ZN7S1437C43v13Ev();
extern void _ZN7S1437C43v14Ev();
extern void _ZN7S1437C43v15Ev();
extern void _ZN7S1437C43v16Ev();
extern void _ZN7S1437C43v17Ev();
extern void _ZN7S1437C43v18Ev();
extern void _ZN7S1437C43v19Ev();
extern void _ZN7S1437C43v20Ev();
extern void _ZN7S1437C43v21Ev();
extern void _ZN7S1437C43v22Ev();
extern void _ZN7S1437C43v23Ev();
extern void _ZN7S1437C43v24Ev();
extern void _ZN7S1437C43v25Ev();
extern void _ZN7S1437C43v26Ev();
extern void _ZN7S1437C43v27Ev();
extern void _ZN7S1437C43v28Ev();
extern void _ZN7S1437C43v29Ev();
extern void _ZN7S1437C43v30Ev();
extern void _ZN7S1437C43v31Ev();
extern void _ZN7S1437C43v32Ev();
extern void _ZN7S1437C43v33Ev();
extern void _ZN7S1437C43v34Ev();
extern void _ZN7S1437C43v35Ev();
extern void _ZN7S1437C43v36Ev();
extern void _ZN7S1437C43v37Ev();
extern void _ZN7S1437C43v38Ev();
extern void _ZN7S1437C43v39Ev();
extern void _ZN7S1437C43v40Ev();
extern void _ZN7S1437C43v41Ev();
extern void _ZN7S1437C43v42Ev();
extern void _ZN7S1437C43v43Ev();
extern void _ZN7S1437C43v44Ev();
extern void _ZN7S1437C43v45Ev();
extern void _ZN7S1437C43v46Ev();
extern void _ZN7S1437C43v47Ev();
extern void _ZN7S1437C43v48Ev();
extern void _ZN7S1437C43v49Ev();
extern void _ZN7S1437C43v50Ev();
extern void _ZN7S1437C43v51Ev();
extern void _ZN7S1437C43v52Ev();
extern void _ZN7S1437C43v53Ev();
extern void _ZN7S1437C43v54Ev();
extern void _ZN7S1437C43v55Ev();
extern void _ZN7S1437C43v56Ev();
extern void _ZN7S1437C43v57Ev();
extern void _ZN7S1437C43v58Ev();
extern void _ZN7S1437C43v59Ev();
extern void _ZN7S1437C43v60Ev();
extern void _ZN7S1437C43v61Ev();
extern void _ZN7S1437C43v62Ev();
extern void _ZN7S1437C43v63Ev();
extern void _ZN7S1437C43v64Ev();
extern void _ZN7S1437C43v65Ev();
extern void _ZN7S1437C43v66Ev();
extern void _ZN7S1437C43v67Ev();
extern void _ZN7S1437C33v68Ev();
extern void _ZN7S1437C33v69Ev();
extern void _ZN7S1437C33v70Ev();
extern void _ZN7S1437C33v71Ev();
extern void _ZN7S1437C33v72Ev();
extern void _ZN7S1437C33v73Ev();
extern void _ZN7S1437C33v74Ev();
extern void _ZN7S1437C33v75Ev();
extern void _ZN7S1437C33v76Ev();
extern void _ZN7S1437C33v77Ev();
extern void _ZN7S1437C33v78Ev();
extern void _ZN7S1437C33v79Ev();
extern void _ZN7S1437C33v80Ev();
extern void _ZN7S1437C33v81Ev();
extern void _ZN7S1437C33v82Ev();
extern void _ZN7S1437C33v83Ev();
extern void _ZN7S1437C33v84Ev();
extern void _ZN7S1437C33v85Ev();
extern void _ZN7S1437C33v86Ev();
extern void _ZN7S1437C33v87Ev();
extern void _ZN7S1437C33v88Ev();
extern void _ZN7S1437C33v89Ev();
static  VTBL_ENTRY vtc_S1437C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1437C3[0]),
  (VTBL_ENTRY)&_ZN7S1437C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1437C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v89Ev,
};
extern VTBL_ENTRY _ZTI7S1437C3[];
extern  VTBL_ENTRY _ZTV7S1437C3[];
Class_Descriptor cd_S1437C3 = {  "S1437C3", // class name
  bases_S1437C3, 1,
  &(vtc_S1437C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI7S1437C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1437C3),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1437C2  : S1437C3 {
  ::S473C6_nt s1437c2f0;
  virtual  ~S1437C2(); // _ZN7S1437C2D1Ev
  virtual void  v90(); // _ZN7S1437C23v90Ev
  virtual void  v91(); // _ZN7S1437C23v91Ev
  virtual void  v92(); // _ZN7S1437C23v92Ev
  virtual void  v93(); // _ZN7S1437C23v93Ev
  virtual void  v94(); // _ZN7S1437C23v94Ev
  virtual void  v95(); // _ZN7S1437C23v95Ev
  virtual void  v96(); // _ZN7S1437C23v96Ev
  virtual void  v97(); // _ZN7S1437C23v97Ev
  virtual void  v98(); // _ZN7S1437C23v98Ev
  virtual void  v99(); // _ZN7S1437C23v99Ev
  virtual void  v100(); // _ZN7S1437C24v100Ev
  virtual void  v101(); // _ZN7S1437C24v101Ev
  virtual void  v102(); // _ZN7S1437C24v102Ev
  virtual void  v103(); // _ZN7S1437C24v103Ev
  virtual void  v104(); // _ZN7S1437C24v104Ev
  virtual void  v105(); // _ZN7S1437C24v105Ev
  virtual void  v106(); // _ZN7S1437C24v106Ev
  virtual void  v107(); // _ZN7S1437C24v107Ev
  virtual void  v108(); // _ZN7S1437C24v108Ev
  S1437C2(); // tgen
};
//SIG(-1 S1437C2) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S1437C2 ::~S1437C2(){ note_dtor("S1437C2", this);}
void  S1437C2 ::v90(){vfunc_called(this, "_ZN7S1437C23v90Ev");}
void  S1437C2 ::v91(){vfunc_called(this, "_ZN7S1437C23v91Ev");}
void  S1437C2 ::v92(){vfunc_called(this, "_ZN7S1437C23v92Ev");}
void  S1437C2 ::v93(){vfunc_called(this, "_ZN7S1437C23v93Ev");}
void  S1437C2 ::v94(){vfunc_called(this, "_ZN7S1437C23v94Ev");}
void  S1437C2 ::v95(){vfunc_called(this, "_ZN7S1437C23v95Ev");}
void  S1437C2 ::v96(){vfunc_called(this, "_ZN7S1437C23v96Ev");}
void  S1437C2 ::v97(){vfunc_called(this, "_ZN7S1437C23v97Ev");}
void  S1437C2 ::v98(){vfunc_called(this, "_ZN7S1437C23v98Ev");}
void  S1437C2 ::v99(){vfunc_called(this, "_ZN7S1437C23v99Ev");}
void  S1437C2 ::v100(){vfunc_called(this, "_ZN7S1437C24v100Ev");}
void  S1437C2 ::v101(){vfunc_called(this, "_ZN7S1437C24v101Ev");}
void  S1437C2 ::v102(){vfunc_called(this, "_ZN7S1437C24v102Ev");}
void  S1437C2 ::v103(){vfunc_called(this, "_ZN7S1437C24v103Ev");}
void  S1437C2 ::v104(){vfunc_called(this, "_ZN7S1437C24v104Ev");}
void  S1437C2 ::v105(){vfunc_called(this, "_ZN7S1437C24v105Ev");}
void  S1437C2 ::v106(){vfunc_called(this, "_ZN7S1437C24v106Ev");}
void  S1437C2 ::v107(){vfunc_called(this, "_ZN7S1437C24v107Ev");}
void  S1437C2 ::v108(){vfunc_called(this, "_ZN7S1437C24v108Ev");}
S1437C2 ::S1437C2(){ note_ctor("S1437C2", this);} // tgen

static void Test_S1437C2()
{
  extern Class_Descriptor cd_S1437C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S1437C2, buf);
    S1437C2 *dp, &lv = *(dp=new (buf) S1437C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S1437C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1437C2)");
    check_base_class_offset(lv, (S1437C4*)(S1437C3*), 0, "S1437C2");
    check_base_class_offset(lv, (S1437C3*), 0, "S1437C2");
    check_field_offset(lv, s1437c2f0, ABISELECT(188,132), "S1437C2.s1437c2f0");
    test_class_info(&lv, &cd_S1437C2);
    dp->~S1437C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1437C2(Test_S1437C2, "S1437C2", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN7S1437C2C1Ev();
extern void _ZN7S1437C2D1Ev();
Name_Map name_map_S1437C2[] = {
  NSPAIR(_ZN7S1437C2C1Ev),
  NSPAIR(_ZN7S1437C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1437C4;
extern VTBL_ENTRY _ZTI7S1437C4[];
extern  VTBL_ENTRY _ZTV7S1437C4[];
extern Class_Descriptor cd_S1437C3;
extern VTBL_ENTRY _ZTI7S1437C3[];
extern  VTBL_ENTRY _ZTV7S1437C3[];
static Base_Class bases_S1437C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1437C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1437C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1437C2[];
extern void _ZN7S1437C2D1Ev();
extern void _ZN7S1437C2D0Ev();
extern void _ZN7S1437C42v4Ev();
extern void _ZN7S1437C42v5Ev();
extern void _ZN7S1437C42v6Ev();
extern void _ZN7S1437C42v7Ev();
extern void _ZN7S1437C42v8Ev();
extern void _ZN7S1437C42v9Ev();
extern void _ZN7S1437C43v10Ev();
extern void _ZN7S1437C43v11Ev();
extern void _ZN7S1437C43v12Ev();
extern void _ZN7S1437C43v13Ev();
extern void _ZN7S1437C43v14Ev();
extern void _ZN7S1437C43v15Ev();
extern void _ZN7S1437C43v16Ev();
extern void _ZN7S1437C43v17Ev();
extern void _ZN7S1437C43v18Ev();
extern void _ZN7S1437C43v19Ev();
extern void _ZN7S1437C43v20Ev();
extern void _ZN7S1437C43v21Ev();
extern void _ZN7S1437C43v22Ev();
extern void _ZN7S1437C43v23Ev();
extern void _ZN7S1437C43v24Ev();
extern void _ZN7S1437C43v25Ev();
extern void _ZN7S1437C43v26Ev();
extern void _ZN7S1437C43v27Ev();
extern void _ZN7S1437C43v28Ev();
extern void _ZN7S1437C43v29Ev();
extern void _ZN7S1437C43v30Ev();
extern void _ZN7S1437C43v31Ev();
extern void _ZN7S1437C43v32Ev();
extern void _ZN7S1437C43v33Ev();
extern void _ZN7S1437C43v34Ev();
extern void _ZN7S1437C43v35Ev();
extern void _ZN7S1437C43v36Ev();
extern void _ZN7S1437C43v37Ev();
extern void _ZN7S1437C43v38Ev();
extern void _ZN7S1437C43v39Ev();
extern void _ZN7S1437C43v40Ev();
extern void _ZN7S1437C43v41Ev();
extern void _ZN7S1437C43v42Ev();
extern void _ZN7S1437C43v43Ev();
extern void _ZN7S1437C43v44Ev();
extern void _ZN7S1437C43v45Ev();
extern void _ZN7S1437C43v46Ev();
extern void _ZN7S1437C43v47Ev();
extern void _ZN7S1437C43v48Ev();
extern void _ZN7S1437C43v49Ev();
extern void _ZN7S1437C43v50Ev();
extern void _ZN7S1437C43v51Ev();
extern void _ZN7S1437C43v52Ev();
extern void _ZN7S1437C43v53Ev();
extern void _ZN7S1437C43v54Ev();
extern void _ZN7S1437C43v55Ev();
extern void _ZN7S1437C43v56Ev();
extern void _ZN7S1437C43v57Ev();
extern void _ZN7S1437C43v58Ev();
extern void _ZN7S1437C43v59Ev();
extern void _ZN7S1437C43v60Ev();
extern void _ZN7S1437C43v61Ev();
extern void _ZN7S1437C43v62Ev();
extern void _ZN7S1437C43v63Ev();
extern void _ZN7S1437C43v64Ev();
extern void _ZN7S1437C43v65Ev();
extern void _ZN7S1437C43v66Ev();
extern void _ZN7S1437C43v67Ev();
extern void _ZN7S1437C33v68Ev();
extern void _ZN7S1437C33v69Ev();
extern void _ZN7S1437C33v70Ev();
extern void _ZN7S1437C33v71Ev();
extern void _ZN7S1437C33v72Ev();
extern void _ZN7S1437C33v73Ev();
extern void _ZN7S1437C33v74Ev();
extern void _ZN7S1437C33v75Ev();
extern void _ZN7S1437C33v76Ev();
extern void _ZN7S1437C33v77Ev();
extern void _ZN7S1437C33v78Ev();
extern void _ZN7S1437C33v79Ev();
extern void _ZN7S1437C33v80Ev();
extern void _ZN7S1437C33v81Ev();
extern void _ZN7S1437C33v82Ev();
extern void _ZN7S1437C33v83Ev();
extern void _ZN7S1437C33v84Ev();
extern void _ZN7S1437C33v85Ev();
extern void _ZN7S1437C33v86Ev();
extern void _ZN7S1437C33v87Ev();
extern void _ZN7S1437C33v88Ev();
extern void _ZN7S1437C33v89Ev();
extern void _ZN7S1437C23v90Ev();
extern void _ZN7S1437C23v91Ev();
extern void _ZN7S1437C23v92Ev();
extern void _ZN7S1437C23v93Ev();
extern void _ZN7S1437C23v94Ev();
extern void _ZN7S1437C23v95Ev();
extern void _ZN7S1437C23v96Ev();
extern void _ZN7S1437C23v97Ev();
extern void _ZN7S1437C23v98Ev();
extern void _ZN7S1437C23v99Ev();
extern void _ZN7S1437C24v100Ev();
extern void _ZN7S1437C24v101Ev();
extern void _ZN7S1437C24v102Ev();
extern void _ZN7S1437C24v103Ev();
extern void _ZN7S1437C24v104Ev();
extern void _ZN7S1437C24v105Ev();
extern void _ZN7S1437C24v106Ev();
extern void _ZN7S1437C24v107Ev();
extern void _ZN7S1437C24v108Ev();
static  VTBL_ENTRY vtc_S1437C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1437C2[0]),
  (VTBL_ENTRY)&_ZN7S1437C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1437C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v108Ev,
};
extern VTBL_ENTRY _ZTI7S1437C2[];
extern  VTBL_ENTRY _ZTV7S1437C2[];
Class_Descriptor cd_S1437C2 = {  "S1437C2", // class name
  bases_S1437C2, 2,
  &(vtc_S1437C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI7S1437C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1437C2),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1437C1  : S1437C2 {
  int s1437c1f0[2];
  ::S672C14_nt s1437c1f1;
  void *s1437c1f2;
  ::S473C8_nt s1437c1f3;
  void *s1437c1f4;
  ::S473C8_nt s1437c1f5;
  int s1437c1f6[2];
  virtual  ~S1437C1(); // _ZN7S1437C1D1Ev
  virtual void  v1(); // _ZN7S1437C12v1Ev
  virtual void  v2(); // _ZN7S1437C12v2Ev
  virtual void  v3(); // _ZN7S1437C12v3Ev
  S1437C1(); // tgen
};
//SIG(1 S1437C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 FC5} vd v1 v2 v3 Fi[2] FC11{ BC12{ BC9}} Fp FC7 Fp FC7 Fi[2]}


 S1437C1 ::~S1437C1(){ note_dtor("S1437C1", this);}
void  S1437C1 ::v1(){vfunc_called(this, "_ZN7S1437C12v1Ev");}
void  S1437C1 ::v2(){vfunc_called(this, "_ZN7S1437C12v2Ev");}
void  S1437C1 ::v3(){vfunc_called(this, "_ZN7S1437C12v3Ev");}
S1437C1 ::S1437C1(){ note_ctor("S1437C1", this);} // tgen

static void Test_S1437C1()
{
  extern Class_Descriptor cd_S1437C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,51)];
    init_test(&cd_S1437C1, buf);
    S1437C1 *dp, &lv = *(dp=new (buf) S1437C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,200), "sizeof(S1437C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1437C1)");
    check_base_class_offset(lv, (S1437C4*)(S1437C3*)(S1437C2*), 0, "S1437C1");
    check_base_class_offset(lv, (S1437C3*)(S1437C2*), 0, "S1437C1");
    check_base_class_offset(lv, (S1437C2*), 0, "S1437C1");
    check_field_offset(lv, s1437c1f0, ABISELECT(196,140), "S1437C1.s1437c1f0");
    check_field_offset(lv, s1437c1f1, ABISELECT(208,148), "S1437C1.s1437c1f1");
    check_field_offset(lv, s1437c1f2, ABISELECT(224,160), "S1437C1.s1437c1f2");
    check_field_offset(lv, s1437c1f3, ABISELECT(232,164), "S1437C1.s1437c1f3");
    check_field_offset(lv, s1437c1f4, ABISELECT(248,176), "S1437C1.s1437c1f4");
    check_field_offset(lv, s1437c1f5, ABISELECT(256,180), "S1437C1.s1437c1f5");
    check_field_offset(lv, s1437c1f6, ABISELECT(272,192), "S1437C1.s1437c1f6");
    test_class_info(&lv, &cd_S1437C1);
    dp->~S1437C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1437C1(Test_S1437C1, "S1437C1", ABISELECT(280,200));

#else // __cplusplus

extern void _ZN7S1437C1C1Ev();
extern void _ZN7S1437C1D1Ev();
Name_Map name_map_S1437C1[] = {
  NSPAIR(_ZN7S1437C1C1Ev),
  NSPAIR(_ZN7S1437C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1437C4;
extern VTBL_ENTRY _ZTI7S1437C4[];
extern  VTBL_ENTRY _ZTV7S1437C4[];
extern Class_Descriptor cd_S1437C3;
extern VTBL_ENTRY _ZTI7S1437C3[];
extern  VTBL_ENTRY _ZTV7S1437C3[];
extern Class_Descriptor cd_S1437C2;
extern VTBL_ENTRY _ZTI7S1437C2[];
extern  VTBL_ENTRY _ZTV7S1437C2[];
static Base_Class bases_S1437C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1437C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1437C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1437C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1437C1[];
extern void _ZN7S1437C1D1Ev();
extern void _ZN7S1437C1D0Ev();
extern void _ZN7S1437C42v4Ev();
extern void _ZN7S1437C42v5Ev();
extern void _ZN7S1437C42v6Ev();
extern void _ZN7S1437C42v7Ev();
extern void _ZN7S1437C42v8Ev();
extern void _ZN7S1437C42v9Ev();
extern void _ZN7S1437C43v10Ev();
extern void _ZN7S1437C43v11Ev();
extern void _ZN7S1437C43v12Ev();
extern void _ZN7S1437C43v13Ev();
extern void _ZN7S1437C43v14Ev();
extern void _ZN7S1437C43v15Ev();
extern void _ZN7S1437C43v16Ev();
extern void _ZN7S1437C43v17Ev();
extern void _ZN7S1437C43v18Ev();
extern void _ZN7S1437C43v19Ev();
extern void _ZN7S1437C43v20Ev();
extern void _ZN7S1437C43v21Ev();
extern void _ZN7S1437C43v22Ev();
extern void _ZN7S1437C43v23Ev();
extern void _ZN7S1437C43v24Ev();
extern void _ZN7S1437C43v25Ev();
extern void _ZN7S1437C43v26Ev();
extern void _ZN7S1437C43v27Ev();
extern void _ZN7S1437C43v28Ev();
extern void _ZN7S1437C43v29Ev();
extern void _ZN7S1437C43v30Ev();
extern void _ZN7S1437C43v31Ev();
extern void _ZN7S1437C43v32Ev();
extern void _ZN7S1437C43v33Ev();
extern void _ZN7S1437C43v34Ev();
extern void _ZN7S1437C43v35Ev();
extern void _ZN7S1437C43v36Ev();
extern void _ZN7S1437C43v37Ev();
extern void _ZN7S1437C43v38Ev();
extern void _ZN7S1437C43v39Ev();
extern void _ZN7S1437C43v40Ev();
extern void _ZN7S1437C43v41Ev();
extern void _ZN7S1437C43v42Ev();
extern void _ZN7S1437C43v43Ev();
extern void _ZN7S1437C43v44Ev();
extern void _ZN7S1437C43v45Ev();
extern void _ZN7S1437C43v46Ev();
extern void _ZN7S1437C43v47Ev();
extern void _ZN7S1437C43v48Ev();
extern void _ZN7S1437C43v49Ev();
extern void _ZN7S1437C43v50Ev();
extern void _ZN7S1437C43v51Ev();
extern void _ZN7S1437C43v52Ev();
extern void _ZN7S1437C43v53Ev();
extern void _ZN7S1437C43v54Ev();
extern void _ZN7S1437C43v55Ev();
extern void _ZN7S1437C43v56Ev();
extern void _ZN7S1437C43v57Ev();
extern void _ZN7S1437C43v58Ev();
extern void _ZN7S1437C43v59Ev();
extern void _ZN7S1437C43v60Ev();
extern void _ZN7S1437C43v61Ev();
extern void _ZN7S1437C43v62Ev();
extern void _ZN7S1437C43v63Ev();
extern void _ZN7S1437C43v64Ev();
extern void _ZN7S1437C43v65Ev();
extern void _ZN7S1437C43v66Ev();
extern void _ZN7S1437C43v67Ev();
extern void _ZN7S1437C33v68Ev();
extern void _ZN7S1437C33v69Ev();
extern void _ZN7S1437C33v70Ev();
extern void _ZN7S1437C33v71Ev();
extern void _ZN7S1437C33v72Ev();
extern void _ZN7S1437C33v73Ev();
extern void _ZN7S1437C33v74Ev();
extern void _ZN7S1437C33v75Ev();
extern void _ZN7S1437C33v76Ev();
extern void _ZN7S1437C33v77Ev();
extern void _ZN7S1437C33v78Ev();
extern void _ZN7S1437C33v79Ev();
extern void _ZN7S1437C33v80Ev();
extern void _ZN7S1437C33v81Ev();
extern void _ZN7S1437C33v82Ev();
extern void _ZN7S1437C33v83Ev();
extern void _ZN7S1437C33v84Ev();
extern void _ZN7S1437C33v85Ev();
extern void _ZN7S1437C33v86Ev();
extern void _ZN7S1437C33v87Ev();
extern void _ZN7S1437C33v88Ev();
extern void _ZN7S1437C33v89Ev();
extern void _ZN7S1437C23v90Ev();
extern void _ZN7S1437C23v91Ev();
extern void _ZN7S1437C23v92Ev();
extern void _ZN7S1437C23v93Ev();
extern void _ZN7S1437C23v94Ev();
extern void _ZN7S1437C23v95Ev();
extern void _ZN7S1437C23v96Ev();
extern void _ZN7S1437C23v97Ev();
extern void _ZN7S1437C23v98Ev();
extern void _ZN7S1437C23v99Ev();
extern void _ZN7S1437C24v100Ev();
extern void _ZN7S1437C24v101Ev();
extern void _ZN7S1437C24v102Ev();
extern void _ZN7S1437C24v103Ev();
extern void _ZN7S1437C24v104Ev();
extern void _ZN7S1437C24v105Ev();
extern void _ZN7S1437C24v106Ev();
extern void _ZN7S1437C24v107Ev();
extern void _ZN7S1437C24v108Ev();
extern void _ZN7S1437C12v1Ev();
extern void _ZN7S1437C12v2Ev();
extern void _ZN7S1437C12v3Ev();
static  VTBL_ENTRY vtc_S1437C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1437C1[0]),
  (VTBL_ENTRY)&_ZN7S1437C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1437C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1437C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1437C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1437C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1437C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1437C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1437C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1437C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1437C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S1437C1[];
extern  VTBL_ENTRY _ZTV7S1437C1[];
Class_Descriptor cd_S1437C1 = {  "S1437C1", // class name
  bases_S1437C1, 3,
  &(vtc_S1437C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,200), // object size
  NSPAIRA(_ZTI7S1437C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1437C1),112, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1579C4  {
  int s1579c4f0;
  __tsi64 s1579c4f1;
  void *s1579c4f2[4];
  int s1579c4f3[2];
  void *s1579c4f4;
  ::S473C6_nt s1579c4f5;
  void *s1579c4f6[2];
  virtual  ~S1579C4(); // _ZN7S1579C4D1Ev
  virtual void  v8(); // _ZN7S1579C42v8Ev
  virtual void  v9(); // _ZN7S1579C42v9Ev
  virtual void  v10(); // _ZN7S1579C43v10Ev
  virtual void  v11(); // _ZN7S1579C43v11Ev
  virtual void  v12(); // _ZN7S1579C43v12Ev
  virtual void  v13(); // _ZN7S1579C43v13Ev
  virtual void  v14(); // _ZN7S1579C43v14Ev
  virtual void  v15(); // _ZN7S1579C43v15Ev
  virtual void  v16(); // _ZN7S1579C43v16Ev
  virtual void  v17(); // _ZN7S1579C43v17Ev
  virtual void  v18(); // _ZN7S1579C43v18Ev
  virtual void  v19(); // _ZN7S1579C43v19Ev
  virtual void  v20(); // _ZN7S1579C43v20Ev
  virtual void  v21(); // _ZN7S1579C43v21Ev
  virtual void  v22(); // _ZN7S1579C43v22Ev
  virtual void  v23(); // _ZN7S1579C43v23Ev
  virtual void  v24(); // _ZN7S1579C43v24Ev
  virtual void  v25(); // _ZN7S1579C43v25Ev
  virtual void  v26(); // _ZN7S1579C43v26Ev
  virtual void  v27(); // _ZN7S1579C43v27Ev
  virtual void  v28(); // _ZN7S1579C43v28Ev
  virtual void  v29(); // _ZN7S1579C43v29Ev
  virtual void  v30(); // _ZN7S1579C43v30Ev
  virtual void  v31(); // _ZN7S1579C43v31Ev
  virtual void  v32(); // _ZN7S1579C43v32Ev
  virtual void  v33(); // _ZN7S1579C43v33Ev
  virtual void  v34(); // _ZN7S1579C43v34Ev
  virtual void  v35(); // _ZN7S1579C43v35Ev
  virtual void  v36(); // _ZN7S1579C43v36Ev
  virtual void  v37(); // _ZN7S1579C43v37Ev
  virtual void  v38(); // _ZN7S1579C43v38Ev
  virtual void  v39(); // _ZN7S1579C43v39Ev
  virtual void  v40(); // _ZN7S1579C43v40Ev
  virtual void  v41(); // _ZN7S1579C43v41Ev
  virtual void  v42(); // _ZN7S1579C43v42Ev
  virtual void  v43(); // _ZN7S1579C43v43Ev
  virtual void  v44(); // _ZN7S1579C43v44Ev
  virtual void  v45(); // _ZN7S1579C43v45Ev
  virtual void  v46(); // _ZN7S1579C43v46Ev
  virtual void  v47(); // _ZN7S1579C43v47Ev
  virtual void  v48(); // _ZN7S1579C43v48Ev
  virtual void  v49(); // _ZN7S1579C43v49Ev
  virtual void  v50(); // _ZN7S1579C43v50Ev
  virtual void  v51(); // _ZN7S1579C43v51Ev
  virtual void  v52(); // _ZN7S1579C43v52Ev
  virtual void  v53(); // _ZN7S1579C43v53Ev
  virtual void  v54(); // _ZN7S1579C43v54Ev
  virtual void  v55(); // _ZN7S1579C43v55Ev
  virtual void  v56(); // _ZN7S1579C43v56Ev
  virtual void  v57(); // _ZN7S1579C43v57Ev
  virtual void  v58(); // _ZN7S1579C43v58Ev
  virtual void  v59(); // _ZN7S1579C43v59Ev
  virtual void  v60(); // _ZN7S1579C43v60Ev
  virtual void  v61(); // _ZN7S1579C43v61Ev
  virtual void  v62(); // _ZN7S1579C43v62Ev
  virtual void  v63(); // _ZN7S1579C43v63Ev
  virtual void  v64(); // _ZN7S1579C43v64Ev
  virtual void  v65(); // _ZN7S1579C43v65Ev
  virtual void  v66(); // _ZN7S1579C43v66Ev
  virtual void  v67(); // _ZN7S1579C43v67Ev
  virtual void  v68(); // _ZN7S1579C43v68Ev
  virtual void  v69(); // _ZN7S1579C43v69Ev
  virtual void  v70(); // _ZN7S1579C43v70Ev
  virtual void  v71(); // _ZN7S1579C43v71Ev
  S1579C4(); // tgen
};
//SIG(-1 S1579C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1579C4 ::~S1579C4(){ note_dtor("S1579C4", this);}
void  S1579C4 ::v8(){vfunc_called(this, "_ZN7S1579C42v8Ev");}
void  S1579C4 ::v9(){vfunc_called(this, "_ZN7S1579C42v9Ev");}
void  S1579C4 ::v10(){vfunc_called(this, "_ZN7S1579C43v10Ev");}
void  S1579C4 ::v11(){vfunc_called(this, "_ZN7S1579C43v11Ev");}
void  S1579C4 ::v12(){vfunc_called(this, "_ZN7S1579C43v12Ev");}
void  S1579C4 ::v13(){vfunc_called(this, "_ZN7S1579C43v13Ev");}
void  S1579C4 ::v14(){vfunc_called(this, "_ZN7S1579C43v14Ev");}
void  S1579C4 ::v15(){vfunc_called(this, "_ZN7S1579C43v15Ev");}
void  S1579C4 ::v16(){vfunc_called(this, "_ZN7S1579C43v16Ev");}
void  S1579C4 ::v17(){vfunc_called(this, "_ZN7S1579C43v17Ev");}
void  S1579C4 ::v18(){vfunc_called(this, "_ZN7S1579C43v18Ev");}
void  S1579C4 ::v19(){vfunc_called(this, "_ZN7S1579C43v19Ev");}
void  S1579C4 ::v20(){vfunc_called(this, "_ZN7S1579C43v20Ev");}
void  S1579C4 ::v21(){vfunc_called(this, "_ZN7S1579C43v21Ev");}
void  S1579C4 ::v22(){vfunc_called(this, "_ZN7S1579C43v22Ev");}
void  S1579C4 ::v23(){vfunc_called(this, "_ZN7S1579C43v23Ev");}
void  S1579C4 ::v24(){vfunc_called(this, "_ZN7S1579C43v24Ev");}
void  S1579C4 ::v25(){vfunc_called(this, "_ZN7S1579C43v25Ev");}
void  S1579C4 ::v26(){vfunc_called(this, "_ZN7S1579C43v26Ev");}
void  S1579C4 ::v27(){vfunc_called(this, "_ZN7S1579C43v27Ev");}
void  S1579C4 ::v28(){vfunc_called(this, "_ZN7S1579C43v28Ev");}
void  S1579C4 ::v29(){vfunc_called(this, "_ZN7S1579C43v29Ev");}
void  S1579C4 ::v30(){vfunc_called(this, "_ZN7S1579C43v30Ev");}
void  S1579C4 ::v31(){vfunc_called(this, "_ZN7S1579C43v31Ev");}
void  S1579C4 ::v32(){vfunc_called(this, "_ZN7S1579C43v32Ev");}
void  S1579C4 ::v33(){vfunc_called(this, "_ZN7S1579C43v33Ev");}
void  S1579C4 ::v34(){vfunc_called(this, "_ZN7S1579C43v34Ev");}
void  S1579C4 ::v35(){vfunc_called(this, "_ZN7S1579C43v35Ev");}
void  S1579C4 ::v36(){vfunc_called(this, "_ZN7S1579C43v36Ev");}
void  S1579C4 ::v37(){vfunc_called(this, "_ZN7S1579C43v37Ev");}
void  S1579C4 ::v38(){vfunc_called(this, "_ZN7S1579C43v38Ev");}
void  S1579C4 ::v39(){vfunc_called(this, "_ZN7S1579C43v39Ev");}
void  S1579C4 ::v40(){vfunc_called(this, "_ZN7S1579C43v40Ev");}
void  S1579C4 ::v41(){vfunc_called(this, "_ZN7S1579C43v41Ev");}
void  S1579C4 ::v42(){vfunc_called(this, "_ZN7S1579C43v42Ev");}
void  S1579C4 ::v43(){vfunc_called(this, "_ZN7S1579C43v43Ev");}
void  S1579C4 ::v44(){vfunc_called(this, "_ZN7S1579C43v44Ev");}
void  S1579C4 ::v45(){vfunc_called(this, "_ZN7S1579C43v45Ev");}
void  S1579C4 ::v46(){vfunc_called(this, "_ZN7S1579C43v46Ev");}
void  S1579C4 ::v47(){vfunc_called(this, "_ZN7S1579C43v47Ev");}
void  S1579C4 ::v48(){vfunc_called(this, "_ZN7S1579C43v48Ev");}
void  S1579C4 ::v49(){vfunc_called(this, "_ZN7S1579C43v49Ev");}
void  S1579C4 ::v50(){vfunc_called(this, "_ZN7S1579C43v50Ev");}
void  S1579C4 ::v51(){vfunc_called(this, "_ZN7S1579C43v51Ev");}
void  S1579C4 ::v52(){vfunc_called(this, "_ZN7S1579C43v52Ev");}
void  S1579C4 ::v53(){vfunc_called(this, "_ZN7S1579C43v53Ev");}
void  S1579C4 ::v54(){vfunc_called(this, "_ZN7S1579C43v54Ev");}
void  S1579C4 ::v55(){vfunc_called(this, "_ZN7S1579C43v55Ev");}
void  S1579C4 ::v56(){vfunc_called(this, "_ZN7S1579C43v56Ev");}
void  S1579C4 ::v57(){vfunc_called(this, "_ZN7S1579C43v57Ev");}
void  S1579C4 ::v58(){vfunc_called(this, "_ZN7S1579C43v58Ev");}
void  S1579C4 ::v59(){vfunc_called(this, "_ZN7S1579C43v59Ev");}
void  S1579C4 ::v60(){vfunc_called(this, "_ZN7S1579C43v60Ev");}
void  S1579C4 ::v61(){vfunc_called(this, "_ZN7S1579C43v61Ev");}
void  S1579C4 ::v62(){vfunc_called(this, "_ZN7S1579C43v62Ev");}
void  S1579C4 ::v63(){vfunc_called(this, "_ZN7S1579C43v63Ev");}
void  S1579C4 ::v64(){vfunc_called(this, "_ZN7S1579C43v64Ev");}
void  S1579C4 ::v65(){vfunc_called(this, "_ZN7S1579C43v65Ev");}
void  S1579C4 ::v66(){vfunc_called(this, "_ZN7S1579C43v66Ev");}
void  S1579C4 ::v67(){vfunc_called(this, "_ZN7S1579C43v67Ev");}
void  S1579C4 ::v68(){vfunc_called(this, "_ZN7S1579C43v68Ev");}
void  S1579C4 ::v69(){vfunc_called(this, "_ZN7S1579C43v69Ev");}
void  S1579C4 ::v70(){vfunc_called(this, "_ZN7S1579C43v70Ev");}
void  S1579C4 ::v71(){vfunc_called(this, "_ZN7S1579C43v71Ev");}
S1579C4 ::S1579C4(){ note_ctor("S1579C4", this);} // tgen

static void Test_S1579C4()
{
  extern Class_Descriptor cd_S1579C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1579C4, buf);
    S1579C4 *dp, &lv = *(dp=new (buf) S1579C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1579C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1579C4)");
    check_field_offset(lv, s1579c4f0, ABISELECT(8,4), "S1579C4.s1579c4f0");
    check_field_offset(lv, s1579c4f1, ABISELECT(16,8), "S1579C4.s1579c4f1");
    check_field_offset(lv, s1579c4f2, ABISELECT(24,16), "S1579C4.s1579c4f2");
    check_field_offset(lv, s1579c4f3, ABISELECT(56,32), "S1579C4.s1579c4f3");
    check_field_offset(lv, s1579c4f4, ABISELECT(64,40), "S1579C4.s1579c4f4");
    check_field_offset(lv, s1579c4f5, ABISELECT(72,44), "S1579C4.s1579c4f5");
    check_field_offset(lv, s1579c4f6, ABISELECT(80,52), "S1579C4.s1579c4f6");
    test_class_info(&lv, &cd_S1579C4);
    dp->~S1579C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1579C4(Test_S1579C4, "S1579C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1579C4C1Ev();
extern void _ZN7S1579C4D1Ev();
Name_Map name_map_S1579C4[] = {
  NSPAIR(_ZN7S1579C4C1Ev),
  NSPAIR(_ZN7S1579C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1579C4[];
extern void _ZN7S1579C4D1Ev();
extern void _ZN7S1579C4D0Ev();
extern void _ZN7S1579C42v8Ev();
extern void _ZN7S1579C42v9Ev();
extern void _ZN7S1579C43v10Ev();
extern void _ZN7S1579C43v11Ev();
extern void _ZN7S1579C43v12Ev();
extern void _ZN7S1579C43v13Ev();
extern void _ZN7S1579C43v14Ev();
extern void _ZN7S1579C43v15Ev();
extern void _ZN7S1579C43v16Ev();
extern void _ZN7S1579C43v17Ev();
extern void _ZN7S1579C43v18Ev();
extern void _ZN7S1579C43v19Ev();
extern void _ZN7S1579C43v20Ev();
extern void _ZN7S1579C43v21Ev();
extern void _ZN7S1579C43v22Ev();
extern void _ZN7S1579C43v23Ev();
extern void _ZN7S1579C43v24Ev();
extern void _ZN7S1579C43v25Ev();
extern void _ZN7S1579C43v26Ev();
extern void _ZN7S1579C43v27Ev();
extern void _ZN7S1579C43v28Ev();
extern void _ZN7S1579C43v29Ev();
extern void _ZN7S1579C43v30Ev();
extern void _ZN7S1579C43v31Ev();
extern void _ZN7S1579C43v32Ev();
extern void _ZN7S1579C43v33Ev();
extern void _ZN7S1579C43v34Ev();
extern void _ZN7S1579C43v35Ev();
extern void _ZN7S1579C43v36Ev();
extern void _ZN7S1579C43v37Ev();
extern void _ZN7S1579C43v38Ev();
extern void _ZN7S1579C43v39Ev();
extern void _ZN7S1579C43v40Ev();
extern void _ZN7S1579C43v41Ev();
extern void _ZN7S1579C43v42Ev();
extern void _ZN7S1579C43v43Ev();
extern void _ZN7S1579C43v44Ev();
extern void _ZN7S1579C43v45Ev();
extern void _ZN7S1579C43v46Ev();
extern void _ZN7S1579C43v47Ev();
extern void _ZN7S1579C43v48Ev();
extern void _ZN7S1579C43v49Ev();
extern void _ZN7S1579C43v50Ev();
extern void _ZN7S1579C43v51Ev();
extern void _ZN7S1579C43v52Ev();
extern void _ZN7S1579C43v53Ev();
extern void _ZN7S1579C43v54Ev();
extern void _ZN7S1579C43v55Ev();
extern void _ZN7S1579C43v56Ev();
extern void _ZN7S1579C43v57Ev();
extern void _ZN7S1579C43v58Ev();
extern void _ZN7S1579C43v59Ev();
extern void _ZN7S1579C43v60Ev();
extern void _ZN7S1579C43v61Ev();
extern void _ZN7S1579C43v62Ev();
extern void _ZN7S1579C43v63Ev();
extern void _ZN7S1579C43v64Ev();
extern void _ZN7S1579C43v65Ev();
extern void _ZN7S1579C43v66Ev();
extern void _ZN7S1579C43v67Ev();
extern void _ZN7S1579C43v68Ev();
extern void _ZN7S1579C43v69Ev();
extern void _ZN7S1579C43v70Ev();
extern void _ZN7S1579C43v71Ev();
static  VTBL_ENTRY vtc_S1579C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1579C4[0]),
  (VTBL_ENTRY)&_ZN7S1579C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1579C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1579C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1579C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v71Ev,
};
extern VTBL_ENTRY _ZTI7S1579C4[];
extern  VTBL_ENTRY _ZTV7S1579C4[];
Class_Descriptor cd_S1579C4 = {  "S1579C4", // class name
  0,0,//no base classes
  &(vtc_S1579C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1579C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1579C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1579C3  : S1579C4 {
  int s1579c3f0[2];
  void *s1579c3f1;
  int s1579c3f2[2];
  ::S473C7_nt s1579c3f3;
  ::S473C7_nt s1579c3f4;
  ::S21925C42 s1579c3f5;
  ::S473C7_nt s1579c3f6;
  unsigned int s1579c3f7:1;
  unsigned int s1579c3f8:1;
  unsigned int s1579c3f9:1;
  unsigned int s1579c3f10:1;
  unsigned int s1579c3f11:1;
  int s1579c3f12[2];
  virtual  ~S1579C3(); // _ZN7S1579C3D1Ev
  virtual void  v72(); // _ZN7S1579C33v72Ev
  virtual void  v73(); // _ZN7S1579C33v73Ev
  virtual void  v74(); // _ZN7S1579C33v74Ev
  virtual void  v75(); // _ZN7S1579C33v75Ev
  virtual void  v76(); // _ZN7S1579C33v76Ev
  virtual void  v77(); // _ZN7S1579C33v77Ev
  virtual void  v78(); // _ZN7S1579C33v78Ev
  virtual void  v79(); // _ZN7S1579C33v79Ev
  virtual void  v80(); // _ZN7S1579C33v80Ev
  virtual void  v81(); // _ZN7S1579C33v81Ev
  virtual void  v82(); // _ZN7S1579C33v82Ev
  virtual void  v83(); // _ZN7S1579C33v83Ev
  virtual void  v84(); // _ZN7S1579C33v84Ev
  virtual void  v85(); // _ZN7S1579C33v85Ev
  virtual void  v86(); // _ZN7S1579C33v86Ev
  virtual void  v87(); // _ZN7S1579C33v87Ev
  virtual void  v88(); // _ZN7S1579C33v88Ev
  virtual void  v89(); // _ZN7S1579C33v89Ev
  virtual void  v90(); // _ZN7S1579C33v90Ev
  virtual void  v91(); // _ZN7S1579C33v91Ev
  virtual void  v92(); // _ZN7S1579C33v92Ev
  virtual void  v93(); // _ZN7S1579C33v93Ev
  S1579C3(); // tgen
};
//SIG(-1 S1579C3) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S1579C3 ::~S1579C3(){ note_dtor("S1579C3", this);}
void  S1579C3 ::v72(){vfunc_called(this, "_ZN7S1579C33v72Ev");}
void  S1579C3 ::v73(){vfunc_called(this, "_ZN7S1579C33v73Ev");}
void  S1579C3 ::v74(){vfunc_called(this, "_ZN7S1579C33v74Ev");}
void  S1579C3 ::v75(){vfunc_called(this, "_ZN7S1579C33v75Ev");}
void  S1579C3 ::v76(){vfunc_called(this, "_ZN7S1579C33v76Ev");}
void  S1579C3 ::v77(){vfunc_called(this, "_ZN7S1579C33v77Ev");}
void  S1579C3 ::v78(){vfunc_called(this, "_ZN7S1579C33v78Ev");}
void  S1579C3 ::v79(){vfunc_called(this, "_ZN7S1579C33v79Ev");}
void  S1579C3 ::v80(){vfunc_called(this, "_ZN7S1579C33v80Ev");}
void  S1579C3 ::v81(){vfunc_called(this, "_ZN7S1579C33v81Ev");}
void  S1579C3 ::v82(){vfunc_called(this, "_ZN7S1579C33v82Ev");}
void  S1579C3 ::v83(){vfunc_called(this, "_ZN7S1579C33v83Ev");}
void  S1579C3 ::v84(){vfunc_called(this, "_ZN7S1579C33v84Ev");}
void  S1579C3 ::v85(){vfunc_called(this, "_ZN7S1579C33v85Ev");}
void  S1579C3 ::v86(){vfunc_called(this, "_ZN7S1579C33v86Ev");}
void  S1579C3 ::v87(){vfunc_called(this, "_ZN7S1579C33v87Ev");}
void  S1579C3 ::v88(){vfunc_called(this, "_ZN7S1579C33v88Ev");}
void  S1579C3 ::v89(){vfunc_called(this, "_ZN7S1579C33v89Ev");}
void  S1579C3 ::v90(){vfunc_called(this, "_ZN7S1579C33v90Ev");}
void  S1579C3 ::v91(){vfunc_called(this, "_ZN7S1579C33v91Ev");}
void  S1579C3 ::v92(){vfunc_called(this, "_ZN7S1579C33v92Ev");}
void  S1579C3 ::v93(){vfunc_called(this, "_ZN7S1579C33v93Ev");}
S1579C3 ::S1579C3(){ note_ctor("S1579C3", this);} // tgen

static void Test_S1579C3()
{
  extern Class_Descriptor cd_S1579C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S1579C3, buf);
    S1579C3 *dp, &lv = *(dp=new (buf) S1579C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S1579C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1579C3)");
    check_base_class_offset(lv, (S1579C4*), 0, "S1579C3");
    check_field_offset(lv, s1579c3f0, ABISELECT(96,60), "S1579C3.s1579c3f0");
    check_field_offset(lv, s1579c3f1, ABISELECT(104,68), "S1579C3.s1579c3f1");
    check_field_offset(lv, s1579c3f2, ABISELECT(112,72), "S1579C3.s1579c3f2");
    check_field_offset(lv, s1579c3f3, ABISELECT(120,80), "S1579C3.s1579c3f3");
    check_field_offset(lv, s1579c3f4, ABISELECT(136,92), "S1579C3.s1579c3f4");
    check_field_offset(lv, s1579c3f5, ABISELECT(152,104), "S1579C3.s1579c3f5");
    check_field_offset(lv, s1579c3f6, ABISELECT(160,108), "S1579C3.s1579c3f6");
    set_bf_and_test(lv, s1579c3f7, ABISELECT(176,120), 0, 1, 1, "S1579C3");
    set_bf_and_test(lv, s1579c3f8, ABISELECT(176,120), 1, 1, 1, "S1579C3");
    set_bf_and_test(lv, s1579c3f9, ABISELECT(176,120), 2, 1, 1, "S1579C3");
    set_bf_and_test(lv, s1579c3f10, ABISELECT(176,120), 3, 1, 1, "S1579C3");
    set_bf_and_test(lv, s1579c3f11, ABISELECT(176,120), 4, 1, 1, "S1579C3");
    check_field_offset(lv, s1579c3f12, ABISELECT(180,124), "S1579C3.s1579c3f12");
    test_class_info(&lv, &cd_S1579C3);
    dp->~S1579C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1579C3(Test_S1579C3, "S1579C3", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN7S1579C3C1Ev();
extern void _ZN7S1579C3D1Ev();
Name_Map name_map_S1579C3[] = {
  NSPAIR(_ZN7S1579C3C1Ev),
  NSPAIR(_ZN7S1579C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1579C4;
extern VTBL_ENTRY _ZTI7S1579C4[];
extern  VTBL_ENTRY _ZTV7S1579C4[];
static Base_Class bases_S1579C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1579C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1579C3[];
extern void _ZN7S1579C3D1Ev();
extern void _ZN7S1579C3D0Ev();
extern void _ZN7S1579C42v8Ev();
extern void _ZN7S1579C42v9Ev();
extern void _ZN7S1579C43v10Ev();
extern void _ZN7S1579C43v11Ev();
extern void _ZN7S1579C43v12Ev();
extern void _ZN7S1579C43v13Ev();
extern void _ZN7S1579C43v14Ev();
extern void _ZN7S1579C43v15Ev();
extern void _ZN7S1579C43v16Ev();
extern void _ZN7S1579C43v17Ev();
extern void _ZN7S1579C43v18Ev();
extern void _ZN7S1579C43v19Ev();
extern void _ZN7S1579C43v20Ev();
extern void _ZN7S1579C43v21Ev();
extern void _ZN7S1579C43v22Ev();
extern void _ZN7S1579C43v23Ev();
extern void _ZN7S1579C43v24Ev();
extern void _ZN7S1579C43v25Ev();
extern void _ZN7S1579C43v26Ev();
extern void _ZN7S1579C43v27Ev();
extern void _ZN7S1579C43v28Ev();
extern void _ZN7S1579C43v29Ev();
extern void _ZN7S1579C43v30Ev();
extern void _ZN7S1579C43v31Ev();
extern void _ZN7S1579C43v32Ev();
extern void _ZN7S1579C43v33Ev();
extern void _ZN7S1579C43v34Ev();
extern void _ZN7S1579C43v35Ev();
extern void _ZN7S1579C43v36Ev();
extern void _ZN7S1579C43v37Ev();
extern void _ZN7S1579C43v38Ev();
extern void _ZN7S1579C43v39Ev();
extern void _ZN7S1579C43v40Ev();
extern void _ZN7S1579C43v41Ev();
extern void _ZN7S1579C43v42Ev();
extern void _ZN7S1579C43v43Ev();
extern void _ZN7S1579C43v44Ev();
extern void _ZN7S1579C43v45Ev();
extern void _ZN7S1579C43v46Ev();
extern void _ZN7S1579C43v47Ev();
extern void _ZN7S1579C43v48Ev();
extern void _ZN7S1579C43v49Ev();
extern void _ZN7S1579C43v50Ev();
extern void _ZN7S1579C43v51Ev();
extern void _ZN7S1579C43v52Ev();
extern void _ZN7S1579C43v53Ev();
extern void _ZN7S1579C43v54Ev();
extern void _ZN7S1579C43v55Ev();
extern void _ZN7S1579C43v56Ev();
extern void _ZN7S1579C43v57Ev();
extern void _ZN7S1579C43v58Ev();
extern void _ZN7S1579C43v59Ev();
extern void _ZN7S1579C43v60Ev();
extern void _ZN7S1579C43v61Ev();
extern void _ZN7S1579C43v62Ev();
extern void _ZN7S1579C43v63Ev();
extern void _ZN7S1579C43v64Ev();
extern void _ZN7S1579C43v65Ev();
extern void _ZN7S1579C43v66Ev();
extern void _ZN7S1579C43v67Ev();
extern void _ZN7S1579C43v68Ev();
extern void _ZN7S1579C43v69Ev();
extern void _ZN7S1579C43v70Ev();
extern void _ZN7S1579C43v71Ev();
extern void _ZN7S1579C33v72Ev();
extern void _ZN7S1579C33v73Ev();
extern void _ZN7S1579C33v74Ev();
extern void _ZN7S1579C33v75Ev();
extern void _ZN7S1579C33v76Ev();
extern void _ZN7S1579C33v77Ev();
extern void _ZN7S1579C33v78Ev();
extern void _ZN7S1579C33v79Ev();
extern void _ZN7S1579C33v80Ev();
extern void _ZN7S1579C33v81Ev();
extern void _ZN7S1579C33v82Ev();
extern void _ZN7S1579C33v83Ev();
extern void _ZN7S1579C33v84Ev();
extern void _ZN7S1579C33v85Ev();
extern void _ZN7S1579C33v86Ev();
extern void _ZN7S1579C33v87Ev();
extern void _ZN7S1579C33v88Ev();
extern void _ZN7S1579C33v89Ev();
extern void _ZN7S1579C33v90Ev();
extern void _ZN7S1579C33v91Ev();
extern void _ZN7S1579C33v92Ev();
extern void _ZN7S1579C33v93Ev();
static  VTBL_ENTRY vtc_S1579C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1579C3[0]),
  (VTBL_ENTRY)&_ZN7S1579C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1579C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1579C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1579C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v93Ev,
};
extern VTBL_ENTRY _ZTI7S1579C3[];
extern  VTBL_ENTRY _ZTV7S1579C3[];
Class_Descriptor cd_S1579C3 = {  "S1579C3", // class name
  bases_S1579C3, 1,
  &(vtc_S1579C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI7S1579C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1579C3),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1579C2  : S1579C3 {
  ::S473C6_nt s1579c2f0;
  virtual  ~S1579C2(); // _ZN7S1579C2D1Ev
  virtual void  v94(); // _ZN7S1579C23v94Ev
  virtual void  v95(); // _ZN7S1579C23v95Ev
  virtual void  v96(); // _ZN7S1579C23v96Ev
  virtual void  v97(); // _ZN7S1579C23v97Ev
  virtual void  v98(); // _ZN7S1579C23v98Ev
  virtual void  v99(); // _ZN7S1579C23v99Ev
  virtual void  v100(); // _ZN7S1579C24v100Ev
  virtual void  v101(); // _ZN7S1579C24v101Ev
  virtual void  v102(); // _ZN7S1579C24v102Ev
  virtual void  v103(); // _ZN7S1579C24v103Ev
  virtual void  v104(); // _ZN7S1579C24v104Ev
  virtual void  v105(); // _ZN7S1579C24v105Ev
  virtual void  v106(); // _ZN7S1579C24v106Ev
  virtual void  v107(); // _ZN7S1579C24v107Ev
  virtual void  v108(); // _ZN7S1579C24v108Ev
  virtual void  v109(); // _ZN7S1579C24v109Ev
  virtual void  v110(); // _ZN7S1579C24v110Ev
  virtual void  v111(); // _ZN7S1579C24v111Ev
  virtual void  v112(); // _ZN7S1579C24v112Ev
  S1579C2(); // tgen
};
//SIG(-1 S1579C2) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S1579C2 ::~S1579C2(){ note_dtor("S1579C2", this);}
void  S1579C2 ::v94(){vfunc_called(this, "_ZN7S1579C23v94Ev");}
void  S1579C2 ::v95(){vfunc_called(this, "_ZN7S1579C23v95Ev");}
void  S1579C2 ::v96(){vfunc_called(this, "_ZN7S1579C23v96Ev");}
void  S1579C2 ::v97(){vfunc_called(this, "_ZN7S1579C23v97Ev");}
void  S1579C2 ::v98(){vfunc_called(this, "_ZN7S1579C23v98Ev");}
void  S1579C2 ::v99(){vfunc_called(this, "_ZN7S1579C23v99Ev");}
void  S1579C2 ::v100(){vfunc_called(this, "_ZN7S1579C24v100Ev");}
void  S1579C2 ::v101(){vfunc_called(this, "_ZN7S1579C24v101Ev");}
void  S1579C2 ::v102(){vfunc_called(this, "_ZN7S1579C24v102Ev");}
void  S1579C2 ::v103(){vfunc_called(this, "_ZN7S1579C24v103Ev");}
void  S1579C2 ::v104(){vfunc_called(this, "_ZN7S1579C24v104Ev");}
void  S1579C2 ::v105(){vfunc_called(this, "_ZN7S1579C24v105Ev");}
void  S1579C2 ::v106(){vfunc_called(this, "_ZN7S1579C24v106Ev");}
void  S1579C2 ::v107(){vfunc_called(this, "_ZN7S1579C24v107Ev");}
void  S1579C2 ::v108(){vfunc_called(this, "_ZN7S1579C24v108Ev");}
void  S1579C2 ::v109(){vfunc_called(this, "_ZN7S1579C24v109Ev");}
void  S1579C2 ::v110(){vfunc_called(this, "_ZN7S1579C24v110Ev");}
void  S1579C2 ::v111(){vfunc_called(this, "_ZN7S1579C24v111Ev");}
void  S1579C2 ::v112(){vfunc_called(this, "_ZN7S1579C24v112Ev");}
S1579C2 ::S1579C2(){ note_ctor("S1579C2", this);} // tgen

static void Test_S1579C2()
{
  extern Class_Descriptor cd_S1579C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S1579C2, buf);
    S1579C2 *dp, &lv = *(dp=new (buf) S1579C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S1579C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1579C2)");
    check_base_class_offset(lv, (S1579C4*)(S1579C3*), 0, "S1579C2");
    check_base_class_offset(lv, (S1579C3*), 0, "S1579C2");
    check_field_offset(lv, s1579c2f0, ABISELECT(188,132), "S1579C2.s1579c2f0");
    test_class_info(&lv, &cd_S1579C2);
    dp->~S1579C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1579C2(Test_S1579C2, "S1579C2", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN7S1579C2C1Ev();
extern void _ZN7S1579C2D1Ev();
Name_Map name_map_S1579C2[] = {
  NSPAIR(_ZN7S1579C2C1Ev),
  NSPAIR(_ZN7S1579C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1579C4;
extern VTBL_ENTRY _ZTI7S1579C4[];
extern  VTBL_ENTRY _ZTV7S1579C4[];
extern Class_Descriptor cd_S1579C3;
extern VTBL_ENTRY _ZTI7S1579C3[];
extern  VTBL_ENTRY _ZTV7S1579C3[];
static Base_Class bases_S1579C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1579C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1579C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1579C2[];
extern void _ZN7S1579C2D1Ev();
extern void _ZN7S1579C2D0Ev();
extern void _ZN7S1579C42v8Ev();
extern void _ZN7S1579C42v9Ev();
extern void _ZN7S1579C43v10Ev();
extern void _ZN7S1579C43v11Ev();
extern void _ZN7S1579C43v12Ev();
extern void _ZN7S1579C43v13Ev();
extern void _ZN7S1579C43v14Ev();
extern void _ZN7S1579C43v15Ev();
extern void _ZN7S1579C43v16Ev();
extern void _ZN7S1579C43v17Ev();
extern void _ZN7S1579C43v18Ev();
extern void _ZN7S1579C43v19Ev();
extern void _ZN7S1579C43v20Ev();
extern void _ZN7S1579C43v21Ev();
extern void _ZN7S1579C43v22Ev();
extern void _ZN7S1579C43v23Ev();
extern void _ZN7S1579C43v24Ev();
extern void _ZN7S1579C43v25Ev();
extern void _ZN7S1579C43v26Ev();
extern void _ZN7S1579C43v27Ev();
extern void _ZN7S1579C43v28Ev();
extern void _ZN7S1579C43v29Ev();
extern void _ZN7S1579C43v30Ev();
extern void _ZN7S1579C43v31Ev();
extern void _ZN7S1579C43v32Ev();
extern void _ZN7S1579C43v33Ev();
extern void _ZN7S1579C43v34Ev();
extern void _ZN7S1579C43v35Ev();
extern void _ZN7S1579C43v36Ev();
extern void _ZN7S1579C43v37Ev();
extern void _ZN7S1579C43v38Ev();
extern void _ZN7S1579C43v39Ev();
extern void _ZN7S1579C43v40Ev();
extern void _ZN7S1579C43v41Ev();
extern void _ZN7S1579C43v42Ev();
extern void _ZN7S1579C43v43Ev();
extern void _ZN7S1579C43v44Ev();
extern void _ZN7S1579C43v45Ev();
extern void _ZN7S1579C43v46Ev();
extern void _ZN7S1579C43v47Ev();
extern void _ZN7S1579C43v48Ev();
extern void _ZN7S1579C43v49Ev();
extern void _ZN7S1579C43v50Ev();
extern void _ZN7S1579C43v51Ev();
extern void _ZN7S1579C43v52Ev();
extern void _ZN7S1579C43v53Ev();
extern void _ZN7S1579C43v54Ev();
extern void _ZN7S1579C43v55Ev();
extern void _ZN7S1579C43v56Ev();
extern void _ZN7S1579C43v57Ev();
extern void _ZN7S1579C43v58Ev();
extern void _ZN7S1579C43v59Ev();
extern void _ZN7S1579C43v60Ev();
extern void _ZN7S1579C43v61Ev();
extern void _ZN7S1579C43v62Ev();
extern void _ZN7S1579C43v63Ev();
extern void _ZN7S1579C43v64Ev();
extern void _ZN7S1579C43v65Ev();
extern void _ZN7S1579C43v66Ev();
extern void _ZN7S1579C43v67Ev();
extern void _ZN7S1579C43v68Ev();
extern void _ZN7S1579C43v69Ev();
extern void _ZN7S1579C43v70Ev();
extern void _ZN7S1579C43v71Ev();
extern void _ZN7S1579C33v72Ev();
extern void _ZN7S1579C33v73Ev();
extern void _ZN7S1579C33v74Ev();
extern void _ZN7S1579C33v75Ev();
extern void _ZN7S1579C33v76Ev();
extern void _ZN7S1579C33v77Ev();
extern void _ZN7S1579C33v78Ev();
extern void _ZN7S1579C33v79Ev();
extern void _ZN7S1579C33v80Ev();
extern void _ZN7S1579C33v81Ev();
extern void _ZN7S1579C33v82Ev();
extern void _ZN7S1579C33v83Ev();
extern void _ZN7S1579C33v84Ev();
extern void _ZN7S1579C33v85Ev();
extern void _ZN7S1579C33v86Ev();
extern void _ZN7S1579C33v87Ev();
extern void _ZN7S1579C33v88Ev();
extern void _ZN7S1579C33v89Ev();
extern void _ZN7S1579C33v90Ev();
extern void _ZN7S1579C33v91Ev();
extern void _ZN7S1579C33v92Ev();
extern void _ZN7S1579C33v93Ev();
extern void _ZN7S1579C23v94Ev();
extern void _ZN7S1579C23v95Ev();
extern void _ZN7S1579C23v96Ev();
extern void _ZN7S1579C23v97Ev();
extern void _ZN7S1579C23v98Ev();
extern void _ZN7S1579C23v99Ev();
extern void _ZN7S1579C24v100Ev();
extern void _ZN7S1579C24v101Ev();
extern void _ZN7S1579C24v102Ev();
extern void _ZN7S1579C24v103Ev();
extern void _ZN7S1579C24v104Ev();
extern void _ZN7S1579C24v105Ev();
extern void _ZN7S1579C24v106Ev();
extern void _ZN7S1579C24v107Ev();
extern void _ZN7S1579C24v108Ev();
extern void _ZN7S1579C24v109Ev();
extern void _ZN7S1579C24v110Ev();
extern void _ZN7S1579C24v111Ev();
extern void _ZN7S1579C24v112Ev();
static  VTBL_ENTRY vtc_S1579C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1579C2[0]),
  (VTBL_ENTRY)&_ZN7S1579C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1579C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1579C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1579C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v112Ev,
};
extern VTBL_ENTRY _ZTI7S1579C2[];
extern  VTBL_ENTRY _ZTV7S1579C2[];
Class_Descriptor cd_S1579C2 = {  "S1579C2", // class name
  bases_S1579C2, 2,
  &(vtc_S1579C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI7S1579C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1579C2),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1579C11_nt  {
  int s1579c11f0[4];
  unsigned int s1579c11f1:1;
  void  mf1579c11(); // _ZN11S1579C11_nt9mf1579c11Ev
};
//SIG(-1 S1579C11_nt) C1{ m Fi[4] Fi:1}


void  S1579C11_nt ::mf1579c11(){}

//skip512 S1579C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1579C1  : S1579C2 {
  ::S1579C11_nt s1579c1f0;
  virtual  ~S1579C1(); // _ZN7S1579C1D1Ev
  virtual void  v1(); // _ZN7S1579C12v1Ev
  virtual void  v2(); // _ZN7S1579C12v2Ev
  virtual void  v3(); // _ZN7S1579C12v3Ev
  virtual void  v4(); // _ZN7S1579C12v4Ev
  virtual void  v5(); // _ZN7S1579C12v5Ev
  virtual void  v6(); // _ZN7S1579C12v6Ev
  virtual void  v7(); // _ZN7S1579C12v7Ev
  S1579C1(); // tgen
};
//SIG(1 S1579C1) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 FC5} vd v1 v2 v3 v4 v5 v6 v7 FC11{ m Fi[4] Fi:1}}


 S1579C1 ::~S1579C1(){ note_dtor("S1579C1", this);}
void  S1579C1 ::v1(){vfunc_called(this, "_ZN7S1579C12v1Ev");}
void  S1579C1 ::v2(){vfunc_called(this, "_ZN7S1579C12v2Ev");}
void  S1579C1 ::v3(){vfunc_called(this, "_ZN7S1579C12v3Ev");}
void  S1579C1 ::v4(){vfunc_called(this, "_ZN7S1579C12v4Ev");}
void  S1579C1 ::v5(){vfunc_called(this, "_ZN7S1579C12v5Ev");}
void  S1579C1 ::v6(){vfunc_called(this, "_ZN7S1579C12v6Ev");}
void  S1579C1 ::v7(){vfunc_called(this, "_ZN7S1579C12v7Ev");}
S1579C1 ::S1579C1(){ note_ctor("S1579C1", this);} // tgen

static void Test_S1579C1()
{
  extern Class_Descriptor cd_S1579C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,41)];
    init_test(&cd_S1579C1, buf);
    S1579C1 *dp, &lv = *(dp=new (buf) S1579C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,160), "sizeof(S1579C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1579C1)");
    check_base_class_offset(lv, (S1579C4*)(S1579C3*)(S1579C2*), 0, "S1579C1");
    check_base_class_offset(lv, (S1579C3*)(S1579C2*), 0, "S1579C1");
    check_base_class_offset(lv, (S1579C2*), 0, "S1579C1");
    check_field_offset(lv, s1579c1f0, ABISELECT(196,140), "S1579C1.s1579c1f0");
    test_class_info(&lv, &cd_S1579C1);
    dp->~S1579C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1579C1(Test_S1579C1, "S1579C1", ABISELECT(216,160));

#else // __cplusplus

extern void _ZN7S1579C1C1Ev();
extern void _ZN7S1579C1D1Ev();
Name_Map name_map_S1579C1[] = {
  NSPAIR(_ZN7S1579C1C1Ev),
  NSPAIR(_ZN7S1579C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1579C4;
extern VTBL_ENTRY _ZTI7S1579C4[];
extern  VTBL_ENTRY _ZTV7S1579C4[];
extern Class_Descriptor cd_S1579C3;
extern VTBL_ENTRY _ZTI7S1579C3[];
extern  VTBL_ENTRY _ZTV7S1579C3[];
extern Class_Descriptor cd_S1579C2;
extern VTBL_ENTRY _ZTI7S1579C2[];
extern  VTBL_ENTRY _ZTV7S1579C2[];
static Base_Class bases_S1579C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1579C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1579C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1579C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1579C1[];
extern void _ZN7S1579C1D1Ev();
extern void _ZN7S1579C1D0Ev();
extern void _ZN7S1579C42v8Ev();
extern void _ZN7S1579C42v9Ev();
extern void _ZN7S1579C43v10Ev();
extern void _ZN7S1579C43v11Ev();
extern void _ZN7S1579C43v12Ev();
extern void _ZN7S1579C43v13Ev();
extern void _ZN7S1579C43v14Ev();
extern void _ZN7S1579C43v15Ev();
extern void _ZN7S1579C43v16Ev();
extern void _ZN7S1579C43v17Ev();
extern void _ZN7S1579C43v18Ev();
extern void _ZN7S1579C43v19Ev();
extern void _ZN7S1579C43v20Ev();
extern void _ZN7S1579C43v21Ev();
extern void _ZN7S1579C43v22Ev();
extern void _ZN7S1579C43v23Ev();
extern void _ZN7S1579C43v24Ev();
extern void _ZN7S1579C43v25Ev();
extern void _ZN7S1579C43v26Ev();
extern void _ZN7S1579C43v27Ev();
extern void _ZN7S1579C43v28Ev();
extern void _ZN7S1579C43v29Ev();
extern void _ZN7S1579C43v30Ev();
extern void _ZN7S1579C43v31Ev();
extern void _ZN7S1579C43v32Ev();
extern void _ZN7S1579C43v33Ev();
extern void _ZN7S1579C43v34Ev();
extern void _ZN7S1579C43v35Ev();
extern void _ZN7S1579C43v36Ev();
extern void _ZN7S1579C43v37Ev();
extern void _ZN7S1579C43v38Ev();
extern void _ZN7S1579C43v39Ev();
extern void _ZN7S1579C43v40Ev();
extern void _ZN7S1579C43v41Ev();
extern void _ZN7S1579C43v42Ev();
extern void _ZN7S1579C43v43Ev();
extern void _ZN7S1579C43v44Ev();
extern void _ZN7S1579C43v45Ev();
extern void _ZN7S1579C43v46Ev();
extern void _ZN7S1579C43v47Ev();
extern void _ZN7S1579C43v48Ev();
extern void _ZN7S1579C43v49Ev();
extern void _ZN7S1579C43v50Ev();
extern void _ZN7S1579C43v51Ev();
extern void _ZN7S1579C43v52Ev();
extern void _ZN7S1579C43v53Ev();
extern void _ZN7S1579C43v54Ev();
extern void _ZN7S1579C43v55Ev();
extern void _ZN7S1579C43v56Ev();
extern void _ZN7S1579C43v57Ev();
extern void _ZN7S1579C43v58Ev();
extern void _ZN7S1579C43v59Ev();
extern void _ZN7S1579C43v60Ev();
extern void _ZN7S1579C43v61Ev();
extern void _ZN7S1579C43v62Ev();
extern void _ZN7S1579C43v63Ev();
extern void _ZN7S1579C43v64Ev();
extern void _ZN7S1579C43v65Ev();
extern void _ZN7S1579C43v66Ev();
extern void _ZN7S1579C43v67Ev();
extern void _ZN7S1579C43v68Ev();
extern void _ZN7S1579C43v69Ev();
extern void _ZN7S1579C43v70Ev();
extern void _ZN7S1579C43v71Ev();
extern void _ZN7S1579C33v72Ev();
extern void _ZN7S1579C33v73Ev();
extern void _ZN7S1579C33v74Ev();
extern void _ZN7S1579C33v75Ev();
extern void _ZN7S1579C33v76Ev();
extern void _ZN7S1579C33v77Ev();
extern void _ZN7S1579C33v78Ev();
extern void _ZN7S1579C33v79Ev();
extern void _ZN7S1579C33v80Ev();
extern void _ZN7S1579C33v81Ev();
extern void _ZN7S1579C33v82Ev();
extern void _ZN7S1579C33v83Ev();
extern void _ZN7S1579C33v84Ev();
extern void _ZN7S1579C33v85Ev();
extern void _ZN7S1579C33v86Ev();
extern void _ZN7S1579C33v87Ev();
extern void _ZN7S1579C33v88Ev();
extern void _ZN7S1579C33v89Ev();
extern void _ZN7S1579C33v90Ev();
extern void _ZN7S1579C33v91Ev();
extern void _ZN7S1579C33v92Ev();
extern void _ZN7S1579C33v93Ev();
extern void _ZN7S1579C23v94Ev();
extern void _ZN7S1579C23v95Ev();
extern void _ZN7S1579C23v96Ev();
extern void _ZN7S1579C23v97Ev();
extern void _ZN7S1579C23v98Ev();
extern void _ZN7S1579C23v99Ev();
extern void _ZN7S1579C24v100Ev();
extern void _ZN7S1579C24v101Ev();
extern void _ZN7S1579C24v102Ev();
extern void _ZN7S1579C24v103Ev();
extern void _ZN7S1579C24v104Ev();
extern void _ZN7S1579C24v105Ev();
extern void _ZN7S1579C24v106Ev();
extern void _ZN7S1579C24v107Ev();
extern void _ZN7S1579C24v108Ev();
extern void _ZN7S1579C24v109Ev();
extern void _ZN7S1579C24v110Ev();
extern void _ZN7S1579C24v111Ev();
extern void _ZN7S1579C24v112Ev();
extern void _ZN7S1579C12v1Ev();
extern void _ZN7S1579C12v2Ev();
extern void _ZN7S1579C12v3Ev();
extern void _ZN7S1579C12v4Ev();
extern void _ZN7S1579C12v5Ev();
extern void _ZN7S1579C12v6Ev();
extern void _ZN7S1579C12v7Ev();
static  VTBL_ENTRY vtc_S1579C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1579C1[0]),
  (VTBL_ENTRY)&_ZN7S1579C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1579C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1579C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1579C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1579C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1579C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1579C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1579C24v112Ev,
  (VTBL_ENTRY)&_ZN7S1579C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1579C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1579C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1579C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1579C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1579C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1579C12v7Ev,
};
extern VTBL_ENTRY _ZTI7S1579C1[];
extern  VTBL_ENTRY _ZTV7S1579C1[];
Class_Descriptor cd_S1579C1 = {  "S1579C1", // class name
  bases_S1579C1, 3,
  &(vtc_S1579C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,160), // object size
  NSPAIRA(_ZTI7S1579C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1579C1),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1605C4  {
  int s1605c4f0;
  __tsi64 s1605c4f1;
  void *s1605c4f2[4];
  int s1605c4f3[2];
  void *s1605c4f4;
  ::S473C6_nt s1605c4f5;
  void *s1605c4f6[2];
  virtual  ~S1605C4(); // _ZN7S1605C4D1Ev
  virtual void  v9(); // _ZN7S1605C42v9Ev
  virtual void  v10(); // _ZN7S1605C43v10Ev
  virtual void  v11(); // _ZN7S1605C43v11Ev
  virtual void  v12(); // _ZN7S1605C43v12Ev
  virtual void  v13(); // _ZN7S1605C43v13Ev
  virtual void  v14(); // _ZN7S1605C43v14Ev
  virtual void  v15(); // _ZN7S1605C43v15Ev
  virtual void  v16(); // _ZN7S1605C43v16Ev
  virtual void  v17(); // _ZN7S1605C43v17Ev
  virtual void  v18(); // _ZN7S1605C43v18Ev
  virtual void  v19(); // _ZN7S1605C43v19Ev
  virtual void  v20(); // _ZN7S1605C43v20Ev
  virtual void  v21(); // _ZN7S1605C43v21Ev
  virtual void  v22(); // _ZN7S1605C43v22Ev
  virtual void  v23(); // _ZN7S1605C43v23Ev
  virtual void  v24(); // _ZN7S1605C43v24Ev
  virtual void  v25(); // _ZN7S1605C43v25Ev
  virtual void  v26(); // _ZN7S1605C43v26Ev
  virtual void  v27(); // _ZN7S1605C43v27Ev
  virtual void  v28(); // _ZN7S1605C43v28Ev
  virtual void  v29(); // _ZN7S1605C43v29Ev
  virtual void  v30(); // _ZN7S1605C43v30Ev
  virtual void  v31(); // _ZN7S1605C43v31Ev
  virtual void  v32(); // _ZN7S1605C43v32Ev
  virtual void  v33(); // _ZN7S1605C43v33Ev
  virtual void  v34(); // _ZN7S1605C43v34Ev
  virtual void  v35(); // _ZN7S1605C43v35Ev
  virtual void  v36(); // _ZN7S1605C43v36Ev
  virtual void  v37(); // _ZN7S1605C43v37Ev
  virtual void  v38(); // _ZN7S1605C43v38Ev
  virtual void  v39(); // _ZN7S1605C43v39Ev
  virtual void  v40(); // _ZN7S1605C43v40Ev
  virtual void  v41(); // _ZN7S1605C43v41Ev
  virtual void  v42(); // _ZN7S1605C43v42Ev
  virtual void  v43(); // _ZN7S1605C43v43Ev
  virtual void  v44(); // _ZN7S1605C43v44Ev
  virtual void  v45(); // _ZN7S1605C43v45Ev
  virtual void  v46(); // _ZN7S1605C43v46Ev
  virtual void  v47(); // _ZN7S1605C43v47Ev
  virtual void  v48(); // _ZN7S1605C43v48Ev
  virtual void  v49(); // _ZN7S1605C43v49Ev
  virtual void  v50(); // _ZN7S1605C43v50Ev
  virtual void  v51(); // _ZN7S1605C43v51Ev
  virtual void  v52(); // _ZN7S1605C43v52Ev
  virtual void  v53(); // _ZN7S1605C43v53Ev
  virtual void  v54(); // _ZN7S1605C43v54Ev
  virtual void  v55(); // _ZN7S1605C43v55Ev
  virtual void  v56(); // _ZN7S1605C43v56Ev
  virtual void  v57(); // _ZN7S1605C43v57Ev
  virtual void  v58(); // _ZN7S1605C43v58Ev
  virtual void  v59(); // _ZN7S1605C43v59Ev
  virtual void  v60(); // _ZN7S1605C43v60Ev
  virtual void  v61(); // _ZN7S1605C43v61Ev
  virtual void  v62(); // _ZN7S1605C43v62Ev
  virtual void  v63(); // _ZN7S1605C43v63Ev
  virtual void  v64(); // _ZN7S1605C43v64Ev
  virtual void  v65(); // _ZN7S1605C43v65Ev
  virtual void  v66(); // _ZN7S1605C43v66Ev
  virtual void  v67(); // _ZN7S1605C43v67Ev
  virtual void  v68(); // _ZN7S1605C43v68Ev
  virtual void  v69(); // _ZN7S1605C43v69Ev
  virtual void  v70(); // _ZN7S1605C43v70Ev
  virtual void  v71(); // _ZN7S1605C43v71Ev
  virtual void  v72(); // _ZN7S1605C43v72Ev
  S1605C4(); // tgen
};
//SIG(-1 S1605C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1605C4 ::~S1605C4(){ note_dtor("S1605C4", this);}
void  S1605C4 ::v9(){vfunc_called(this, "_ZN7S1605C42v9Ev");}
void  S1605C4 ::v10(){vfunc_called(this, "_ZN7S1605C43v10Ev");}
void  S1605C4 ::v11(){vfunc_called(this, "_ZN7S1605C43v11Ev");}
void  S1605C4 ::v12(){vfunc_called(this, "_ZN7S1605C43v12Ev");}
void  S1605C4 ::v13(){vfunc_called(this, "_ZN7S1605C43v13Ev");}
void  S1605C4 ::v14(){vfunc_called(this, "_ZN7S1605C43v14Ev");}
void  S1605C4 ::v15(){vfunc_called(this, "_ZN7S1605C43v15Ev");}
void  S1605C4 ::v16(){vfunc_called(this, "_ZN7S1605C43v16Ev");}
void  S1605C4 ::v17(){vfunc_called(this, "_ZN7S1605C43v17Ev");}
void  S1605C4 ::v18(){vfunc_called(this, "_ZN7S1605C43v18Ev");}
void  S1605C4 ::v19(){vfunc_called(this, "_ZN7S1605C43v19Ev");}
void  S1605C4 ::v20(){vfunc_called(this, "_ZN7S1605C43v20Ev");}
void  S1605C4 ::v21(){vfunc_called(this, "_ZN7S1605C43v21Ev");}
void  S1605C4 ::v22(){vfunc_called(this, "_ZN7S1605C43v22Ev");}
void  S1605C4 ::v23(){vfunc_called(this, "_ZN7S1605C43v23Ev");}
void  S1605C4 ::v24(){vfunc_called(this, "_ZN7S1605C43v24Ev");}
void  S1605C4 ::v25(){vfunc_called(this, "_ZN7S1605C43v25Ev");}
void  S1605C4 ::v26(){vfunc_called(this, "_ZN7S1605C43v26Ev");}
void  S1605C4 ::v27(){vfunc_called(this, "_ZN7S1605C43v27Ev");}
void  S1605C4 ::v28(){vfunc_called(this, "_ZN7S1605C43v28Ev");}
void  S1605C4 ::v29(){vfunc_called(this, "_ZN7S1605C43v29Ev");}
void  S1605C4 ::v30(){vfunc_called(this, "_ZN7S1605C43v30Ev");}
void  S1605C4 ::v31(){vfunc_called(this, "_ZN7S1605C43v31Ev");}
void  S1605C4 ::v32(){vfunc_called(this, "_ZN7S1605C43v32Ev");}
void  S1605C4 ::v33(){vfunc_called(this, "_ZN7S1605C43v33Ev");}
void  S1605C4 ::v34(){vfunc_called(this, "_ZN7S1605C43v34Ev");}
void  S1605C4 ::v35(){vfunc_called(this, "_ZN7S1605C43v35Ev");}
void  S1605C4 ::v36(){vfunc_called(this, "_ZN7S1605C43v36Ev");}
void  S1605C4 ::v37(){vfunc_called(this, "_ZN7S1605C43v37Ev");}
void  S1605C4 ::v38(){vfunc_called(this, "_ZN7S1605C43v38Ev");}
void  S1605C4 ::v39(){vfunc_called(this, "_ZN7S1605C43v39Ev");}
void  S1605C4 ::v40(){vfunc_called(this, "_ZN7S1605C43v40Ev");}
void  S1605C4 ::v41(){vfunc_called(this, "_ZN7S1605C43v41Ev");}
void  S1605C4 ::v42(){vfunc_called(this, "_ZN7S1605C43v42Ev");}
void  S1605C4 ::v43(){vfunc_called(this, "_ZN7S1605C43v43Ev");}
void  S1605C4 ::v44(){vfunc_called(this, "_ZN7S1605C43v44Ev");}
void  S1605C4 ::v45(){vfunc_called(this, "_ZN7S1605C43v45Ev");}
void  S1605C4 ::v46(){vfunc_called(this, "_ZN7S1605C43v46Ev");}
void  S1605C4 ::v47(){vfunc_called(this, "_ZN7S1605C43v47Ev");}
void  S1605C4 ::v48(){vfunc_called(this, "_ZN7S1605C43v48Ev");}
void  S1605C4 ::v49(){vfunc_called(this, "_ZN7S1605C43v49Ev");}
void  S1605C4 ::v50(){vfunc_called(this, "_ZN7S1605C43v50Ev");}
void  S1605C4 ::v51(){vfunc_called(this, "_ZN7S1605C43v51Ev");}
void  S1605C4 ::v52(){vfunc_called(this, "_ZN7S1605C43v52Ev");}
void  S1605C4 ::v53(){vfunc_called(this, "_ZN7S1605C43v53Ev");}
void  S1605C4 ::v54(){vfunc_called(this, "_ZN7S1605C43v54Ev");}
void  S1605C4 ::v55(){vfunc_called(this, "_ZN7S1605C43v55Ev");}
void  S1605C4 ::v56(){vfunc_called(this, "_ZN7S1605C43v56Ev");}
void  S1605C4 ::v57(){vfunc_called(this, "_ZN7S1605C43v57Ev");}
void  S1605C4 ::v58(){vfunc_called(this, "_ZN7S1605C43v58Ev");}
void  S1605C4 ::v59(){vfunc_called(this, "_ZN7S1605C43v59Ev");}
void  S1605C4 ::v60(){vfunc_called(this, "_ZN7S1605C43v60Ev");}
void  S1605C4 ::v61(){vfunc_called(this, "_ZN7S1605C43v61Ev");}
void  S1605C4 ::v62(){vfunc_called(this, "_ZN7S1605C43v62Ev");}
void  S1605C4 ::v63(){vfunc_called(this, "_ZN7S1605C43v63Ev");}
void  S1605C4 ::v64(){vfunc_called(this, "_ZN7S1605C43v64Ev");}
void  S1605C4 ::v65(){vfunc_called(this, "_ZN7S1605C43v65Ev");}
void  S1605C4 ::v66(){vfunc_called(this, "_ZN7S1605C43v66Ev");}
void  S1605C4 ::v67(){vfunc_called(this, "_ZN7S1605C43v67Ev");}
void  S1605C4 ::v68(){vfunc_called(this, "_ZN7S1605C43v68Ev");}
void  S1605C4 ::v69(){vfunc_called(this, "_ZN7S1605C43v69Ev");}
void  S1605C4 ::v70(){vfunc_called(this, "_ZN7S1605C43v70Ev");}
void  S1605C4 ::v71(){vfunc_called(this, "_ZN7S1605C43v71Ev");}
void  S1605C4 ::v72(){vfunc_called(this, "_ZN7S1605C43v72Ev");}
S1605C4 ::S1605C4(){ note_ctor("S1605C4", this);} // tgen

static void Test_S1605C4()
{
  extern Class_Descriptor cd_S1605C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1605C4, buf);
    S1605C4 *dp, &lv = *(dp=new (buf) S1605C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1605C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1605C4)");
    check_field_offset(lv, s1605c4f0, ABISELECT(8,4), "S1605C4.s1605c4f0");
    check_field_offset(lv, s1605c4f1, ABISELECT(16,8), "S1605C4.s1605c4f1");
    check_field_offset(lv, s1605c4f2, ABISELECT(24,16), "S1605C4.s1605c4f2");
    check_field_offset(lv, s1605c4f3, ABISELECT(56,32), "S1605C4.s1605c4f3");
    check_field_offset(lv, s1605c4f4, ABISELECT(64,40), "S1605C4.s1605c4f4");
    check_field_offset(lv, s1605c4f5, ABISELECT(72,44), "S1605C4.s1605c4f5");
    check_field_offset(lv, s1605c4f6, ABISELECT(80,52), "S1605C4.s1605c4f6");
    test_class_info(&lv, &cd_S1605C4);
    dp->~S1605C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1605C4(Test_S1605C4, "S1605C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1605C4C1Ev();
extern void _ZN7S1605C4D1Ev();
Name_Map name_map_S1605C4[] = {
  NSPAIR(_ZN7S1605C4C1Ev),
  NSPAIR(_ZN7S1605C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1605C4[];
extern void _ZN7S1605C4D1Ev();
extern void _ZN7S1605C4D0Ev();
extern void _ZN7S1605C42v9Ev();
extern void _ZN7S1605C43v10Ev();
extern void _ZN7S1605C43v11Ev();
extern void _ZN7S1605C43v12Ev();
extern void _ZN7S1605C43v13Ev();
extern void _ZN7S1605C43v14Ev();
extern void _ZN7S1605C43v15Ev();
extern void _ZN7S1605C43v16Ev();
extern void _ZN7S1605C43v17Ev();
extern void _ZN7S1605C43v18Ev();
extern void _ZN7S1605C43v19Ev();
extern void _ZN7S1605C43v20Ev();
extern void _ZN7S1605C43v21Ev();
extern void _ZN7S1605C43v22Ev();
extern void _ZN7S1605C43v23Ev();
extern void _ZN7S1605C43v24Ev();
extern void _ZN7S1605C43v25Ev();
extern void _ZN7S1605C43v26Ev();
extern void _ZN7S1605C43v27Ev();
extern void _ZN7S1605C43v28Ev();
extern void _ZN7S1605C43v29Ev();
extern void _ZN7S1605C43v30Ev();
extern void _ZN7S1605C43v31Ev();
extern void _ZN7S1605C43v32Ev();
extern void _ZN7S1605C43v33Ev();
extern void _ZN7S1605C43v34Ev();
extern void _ZN7S1605C43v35Ev();
extern void _ZN7S1605C43v36Ev();
extern void _ZN7S1605C43v37Ev();
extern void _ZN7S1605C43v38Ev();
extern void _ZN7S1605C43v39Ev();
extern void _ZN7S1605C43v40Ev();
extern void _ZN7S1605C43v41Ev();
extern void _ZN7S1605C43v42Ev();
extern void _ZN7S1605C43v43Ev();
extern void _ZN7S1605C43v44Ev();
extern void _ZN7S1605C43v45Ev();
extern void _ZN7S1605C43v46Ev();
extern void _ZN7S1605C43v47Ev();
extern void _ZN7S1605C43v48Ev();
extern void _ZN7S1605C43v49Ev();
extern void _ZN7S1605C43v50Ev();
extern void _ZN7S1605C43v51Ev();
extern void _ZN7S1605C43v52Ev();
extern void _ZN7S1605C43v53Ev();
extern void _ZN7S1605C43v54Ev();
extern void _ZN7S1605C43v55Ev();
extern void _ZN7S1605C43v56Ev();
extern void _ZN7S1605C43v57Ev();
extern void _ZN7S1605C43v58Ev();
extern void _ZN7S1605C43v59Ev();
extern void _ZN7S1605C43v60Ev();
extern void _ZN7S1605C43v61Ev();
extern void _ZN7S1605C43v62Ev();
extern void _ZN7S1605C43v63Ev();
extern void _ZN7S1605C43v64Ev();
extern void _ZN7S1605C43v65Ev();
extern void _ZN7S1605C43v66Ev();
extern void _ZN7S1605C43v67Ev();
extern void _ZN7S1605C43v68Ev();
extern void _ZN7S1605C43v69Ev();
extern void _ZN7S1605C43v70Ev();
extern void _ZN7S1605C43v71Ev();
extern void _ZN7S1605C43v72Ev();
static  VTBL_ENTRY vtc_S1605C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1605C4[0]),
  (VTBL_ENTRY)&_ZN7S1605C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1605C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1605C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v72Ev,
};
extern VTBL_ENTRY _ZTI7S1605C4[];
extern  VTBL_ENTRY _ZTV7S1605C4[];
Class_Descriptor cd_S1605C4 = {  "S1605C4", // class name
  0,0,//no base classes
  &(vtc_S1605C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1605C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1605C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1605C3  : S1605C4 {
  int s1605c3f0[2];
  void *s1605c3f1;
  int s1605c3f2[2];
  ::S473C7_nt s1605c3f3;
  ::S473C7_nt s1605c3f4;
  ::S21925C42 s1605c3f5;
  ::S473C7_nt s1605c3f6;
  unsigned int s1605c3f7:1;
  unsigned int s1605c3f8:1;
  unsigned int s1605c3f9:1;
  unsigned int s1605c3f10:1;
  unsigned int s1605c3f11:1;
  int s1605c3f12[2];
  virtual  ~S1605C3(); // _ZN7S1605C3D1Ev
  virtual void  v73(); // _ZN7S1605C33v73Ev
  virtual void  v74(); // _ZN7S1605C33v74Ev
  virtual void  v75(); // _ZN7S1605C33v75Ev
  virtual void  v76(); // _ZN7S1605C33v76Ev
  virtual void  v77(); // _ZN7S1605C33v77Ev
  virtual void  v78(); // _ZN7S1605C33v78Ev
  virtual void  v79(); // _ZN7S1605C33v79Ev
  virtual void  v80(); // _ZN7S1605C33v80Ev
  virtual void  v81(); // _ZN7S1605C33v81Ev
  virtual void  v82(); // _ZN7S1605C33v82Ev
  virtual void  v83(); // _ZN7S1605C33v83Ev
  virtual void  v84(); // _ZN7S1605C33v84Ev
  virtual void  v85(); // _ZN7S1605C33v85Ev
  virtual void  v86(); // _ZN7S1605C33v86Ev
  virtual void  v87(); // _ZN7S1605C33v87Ev
  virtual void  v88(); // _ZN7S1605C33v88Ev
  virtual void  v89(); // _ZN7S1605C33v89Ev
  virtual void  v90(); // _ZN7S1605C33v90Ev
  virtual void  v91(); // _ZN7S1605C33v91Ev
  virtual void  v92(); // _ZN7S1605C33v92Ev
  virtual void  v93(); // _ZN7S1605C33v93Ev
  virtual void  v94(); // _ZN7S1605C33v94Ev
  S1605C3(); // tgen
};
//SIG(-1 S1605C3) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S1605C3 ::~S1605C3(){ note_dtor("S1605C3", this);}
void  S1605C3 ::v73(){vfunc_called(this, "_ZN7S1605C33v73Ev");}
void  S1605C3 ::v74(){vfunc_called(this, "_ZN7S1605C33v74Ev");}
void  S1605C3 ::v75(){vfunc_called(this, "_ZN7S1605C33v75Ev");}
void  S1605C3 ::v76(){vfunc_called(this, "_ZN7S1605C33v76Ev");}
void  S1605C3 ::v77(){vfunc_called(this, "_ZN7S1605C33v77Ev");}
void  S1605C3 ::v78(){vfunc_called(this, "_ZN7S1605C33v78Ev");}
void  S1605C3 ::v79(){vfunc_called(this, "_ZN7S1605C33v79Ev");}
void  S1605C3 ::v80(){vfunc_called(this, "_ZN7S1605C33v80Ev");}
void  S1605C3 ::v81(){vfunc_called(this, "_ZN7S1605C33v81Ev");}
void  S1605C3 ::v82(){vfunc_called(this, "_ZN7S1605C33v82Ev");}
void  S1605C3 ::v83(){vfunc_called(this, "_ZN7S1605C33v83Ev");}
void  S1605C3 ::v84(){vfunc_called(this, "_ZN7S1605C33v84Ev");}
void  S1605C3 ::v85(){vfunc_called(this, "_ZN7S1605C33v85Ev");}
void  S1605C3 ::v86(){vfunc_called(this, "_ZN7S1605C33v86Ev");}
void  S1605C3 ::v87(){vfunc_called(this, "_ZN7S1605C33v87Ev");}
void  S1605C3 ::v88(){vfunc_called(this, "_ZN7S1605C33v88Ev");}
void  S1605C3 ::v89(){vfunc_called(this, "_ZN7S1605C33v89Ev");}
void  S1605C3 ::v90(){vfunc_called(this, "_ZN7S1605C33v90Ev");}
void  S1605C3 ::v91(){vfunc_called(this, "_ZN7S1605C33v91Ev");}
void  S1605C3 ::v92(){vfunc_called(this, "_ZN7S1605C33v92Ev");}
void  S1605C3 ::v93(){vfunc_called(this, "_ZN7S1605C33v93Ev");}
void  S1605C3 ::v94(){vfunc_called(this, "_ZN7S1605C33v94Ev");}
S1605C3 ::S1605C3(){ note_ctor("S1605C3", this);} // tgen

static void Test_S1605C3()
{
  extern Class_Descriptor cd_S1605C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S1605C3, buf);
    S1605C3 *dp, &lv = *(dp=new (buf) S1605C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S1605C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1605C3)");
    check_base_class_offset(lv, (S1605C4*), 0, "S1605C3");
    check_field_offset(lv, s1605c3f0, ABISELECT(96,60), "S1605C3.s1605c3f0");
    check_field_offset(lv, s1605c3f1, ABISELECT(104,68), "S1605C3.s1605c3f1");
    check_field_offset(lv, s1605c3f2, ABISELECT(112,72), "S1605C3.s1605c3f2");
    check_field_offset(lv, s1605c3f3, ABISELECT(120,80), "S1605C3.s1605c3f3");
    check_field_offset(lv, s1605c3f4, ABISELECT(136,92), "S1605C3.s1605c3f4");
    check_field_offset(lv, s1605c3f5, ABISELECT(152,104), "S1605C3.s1605c3f5");
    check_field_offset(lv, s1605c3f6, ABISELECT(160,108), "S1605C3.s1605c3f6");
    set_bf_and_test(lv, s1605c3f7, ABISELECT(176,120), 0, 1, 1, "S1605C3");
    set_bf_and_test(lv, s1605c3f8, ABISELECT(176,120), 1, 1, 1, "S1605C3");
    set_bf_and_test(lv, s1605c3f9, ABISELECT(176,120), 2, 1, 1, "S1605C3");
    set_bf_and_test(lv, s1605c3f10, ABISELECT(176,120), 3, 1, 1, "S1605C3");
    set_bf_and_test(lv, s1605c3f11, ABISELECT(176,120), 4, 1, 1, "S1605C3");
    check_field_offset(lv, s1605c3f12, ABISELECT(180,124), "S1605C3.s1605c3f12");
    test_class_info(&lv, &cd_S1605C3);
    dp->~S1605C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1605C3(Test_S1605C3, "S1605C3", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN7S1605C3C1Ev();
extern void _ZN7S1605C3D1Ev();
Name_Map name_map_S1605C3[] = {
  NSPAIR(_ZN7S1605C3C1Ev),
  NSPAIR(_ZN7S1605C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1605C4;
extern VTBL_ENTRY _ZTI7S1605C4[];
extern  VTBL_ENTRY _ZTV7S1605C4[];
static Base_Class bases_S1605C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1605C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1605C3[];
extern void _ZN7S1605C3D1Ev();
extern void _ZN7S1605C3D0Ev();
extern void _ZN7S1605C42v9Ev();
extern void _ZN7S1605C43v10Ev();
extern void _ZN7S1605C43v11Ev();
extern void _ZN7S1605C43v12Ev();
extern void _ZN7S1605C43v13Ev();
extern void _ZN7S1605C43v14Ev();
extern void _ZN7S1605C43v15Ev();
extern void _ZN7S1605C43v16Ev();
extern void _ZN7S1605C43v17Ev();
extern void _ZN7S1605C43v18Ev();
extern void _ZN7S1605C43v19Ev();
extern void _ZN7S1605C43v20Ev();
extern void _ZN7S1605C43v21Ev();
extern void _ZN7S1605C43v22Ev();
extern void _ZN7S1605C43v23Ev();
extern void _ZN7S1605C43v24Ev();
extern void _ZN7S1605C43v25Ev();
extern void _ZN7S1605C43v26Ev();
extern void _ZN7S1605C43v27Ev();
extern void _ZN7S1605C43v28Ev();
extern void _ZN7S1605C43v29Ev();
extern void _ZN7S1605C43v30Ev();
extern void _ZN7S1605C43v31Ev();
extern void _ZN7S1605C43v32Ev();
extern void _ZN7S1605C43v33Ev();
extern void _ZN7S1605C43v34Ev();
extern void _ZN7S1605C43v35Ev();
extern void _ZN7S1605C43v36Ev();
extern void _ZN7S1605C43v37Ev();
extern void _ZN7S1605C43v38Ev();
extern void _ZN7S1605C43v39Ev();
extern void _ZN7S1605C43v40Ev();
extern void _ZN7S1605C43v41Ev();
extern void _ZN7S1605C43v42Ev();
extern void _ZN7S1605C43v43Ev();
extern void _ZN7S1605C43v44Ev();
extern void _ZN7S1605C43v45Ev();
extern void _ZN7S1605C43v46Ev();
extern void _ZN7S1605C43v47Ev();
extern void _ZN7S1605C43v48Ev();
extern void _ZN7S1605C43v49Ev();
extern void _ZN7S1605C43v50Ev();
extern void _ZN7S1605C43v51Ev();
extern void _ZN7S1605C43v52Ev();
extern void _ZN7S1605C43v53Ev();
extern void _ZN7S1605C43v54Ev();
extern void _ZN7S1605C43v55Ev();
extern void _ZN7S1605C43v56Ev();
extern void _ZN7S1605C43v57Ev();
extern void _ZN7S1605C43v58Ev();
extern void _ZN7S1605C43v59Ev();
extern void _ZN7S1605C43v60Ev();
extern void _ZN7S1605C43v61Ev();
extern void _ZN7S1605C43v62Ev();
extern void _ZN7S1605C43v63Ev();
extern void _ZN7S1605C43v64Ev();
extern void _ZN7S1605C43v65Ev();
extern void _ZN7S1605C43v66Ev();
extern void _ZN7S1605C43v67Ev();
extern void _ZN7S1605C43v68Ev();
extern void _ZN7S1605C43v69Ev();
extern void _ZN7S1605C43v70Ev();
extern void _ZN7S1605C43v71Ev();
extern void _ZN7S1605C43v72Ev();
extern void _ZN7S1605C33v73Ev();
extern void _ZN7S1605C33v74Ev();
extern void _ZN7S1605C33v75Ev();
extern void _ZN7S1605C33v76Ev();
extern void _ZN7S1605C33v77Ev();
extern void _ZN7S1605C33v78Ev();
extern void _ZN7S1605C33v79Ev();
extern void _ZN7S1605C33v80Ev();
extern void _ZN7S1605C33v81Ev();
extern void _ZN7S1605C33v82Ev();
extern void _ZN7S1605C33v83Ev();
extern void _ZN7S1605C33v84Ev();
extern void _ZN7S1605C33v85Ev();
extern void _ZN7S1605C33v86Ev();
extern void _ZN7S1605C33v87Ev();
extern void _ZN7S1605C33v88Ev();
extern void _ZN7S1605C33v89Ev();
extern void _ZN7S1605C33v90Ev();
extern void _ZN7S1605C33v91Ev();
extern void _ZN7S1605C33v92Ev();
extern void _ZN7S1605C33v93Ev();
extern void _ZN7S1605C33v94Ev();
static  VTBL_ENTRY vtc_S1605C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1605C3[0]),
  (VTBL_ENTRY)&_ZN7S1605C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1605C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1605C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v94Ev,
};
extern VTBL_ENTRY _ZTI7S1605C3[];
extern  VTBL_ENTRY _ZTV7S1605C3[];
Class_Descriptor cd_S1605C3 = {  "S1605C3", // class name
  bases_S1605C3, 1,
  &(vtc_S1605C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI7S1605C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1605C3),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1605C2  : S1605C3 {
  ::S473C6_nt s1605c2f0;
  virtual  ~S1605C2(); // _ZN7S1605C2D1Ev
  virtual void  v95(); // _ZN7S1605C23v95Ev
  virtual void  v96(); // _ZN7S1605C23v96Ev
  virtual void  v97(); // _ZN7S1605C23v97Ev
  virtual void  v98(); // _ZN7S1605C23v98Ev
  virtual void  v99(); // _ZN7S1605C23v99Ev
  virtual void  v100(); // _ZN7S1605C24v100Ev
  virtual void  v101(); // _ZN7S1605C24v101Ev
  virtual void  v102(); // _ZN7S1605C24v102Ev
  virtual void  v103(); // _ZN7S1605C24v103Ev
  virtual void  v104(); // _ZN7S1605C24v104Ev
  virtual void  v105(); // _ZN7S1605C24v105Ev
  virtual void  v106(); // _ZN7S1605C24v106Ev
  virtual void  v107(); // _ZN7S1605C24v107Ev
  virtual void  v108(); // _ZN7S1605C24v108Ev
  virtual void  v109(); // _ZN7S1605C24v109Ev
  virtual void  v110(); // _ZN7S1605C24v110Ev
  virtual void  v111(); // _ZN7S1605C24v111Ev
  virtual void  v112(); // _ZN7S1605C24v112Ev
  virtual void  v113(); // _ZN7S1605C24v113Ev
  S1605C2(); // tgen
};
//SIG(-1 S1605C2) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S1605C2 ::~S1605C2(){ note_dtor("S1605C2", this);}
void  S1605C2 ::v95(){vfunc_called(this, "_ZN7S1605C23v95Ev");}
void  S1605C2 ::v96(){vfunc_called(this, "_ZN7S1605C23v96Ev");}
void  S1605C2 ::v97(){vfunc_called(this, "_ZN7S1605C23v97Ev");}
void  S1605C2 ::v98(){vfunc_called(this, "_ZN7S1605C23v98Ev");}
void  S1605C2 ::v99(){vfunc_called(this, "_ZN7S1605C23v99Ev");}
void  S1605C2 ::v100(){vfunc_called(this, "_ZN7S1605C24v100Ev");}
void  S1605C2 ::v101(){vfunc_called(this, "_ZN7S1605C24v101Ev");}
void  S1605C2 ::v102(){vfunc_called(this, "_ZN7S1605C24v102Ev");}
void  S1605C2 ::v103(){vfunc_called(this, "_ZN7S1605C24v103Ev");}
void  S1605C2 ::v104(){vfunc_called(this, "_ZN7S1605C24v104Ev");}
void  S1605C2 ::v105(){vfunc_called(this, "_ZN7S1605C24v105Ev");}
void  S1605C2 ::v106(){vfunc_called(this, "_ZN7S1605C24v106Ev");}
void  S1605C2 ::v107(){vfunc_called(this, "_ZN7S1605C24v107Ev");}
void  S1605C2 ::v108(){vfunc_called(this, "_ZN7S1605C24v108Ev");}
void  S1605C2 ::v109(){vfunc_called(this, "_ZN7S1605C24v109Ev");}
void  S1605C2 ::v110(){vfunc_called(this, "_ZN7S1605C24v110Ev");}
void  S1605C2 ::v111(){vfunc_called(this, "_ZN7S1605C24v111Ev");}
void  S1605C2 ::v112(){vfunc_called(this, "_ZN7S1605C24v112Ev");}
void  S1605C2 ::v113(){vfunc_called(this, "_ZN7S1605C24v113Ev");}
S1605C2 ::S1605C2(){ note_ctor("S1605C2", this);} // tgen

static void Test_S1605C2()
{
  extern Class_Descriptor cd_S1605C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S1605C2, buf);
    S1605C2 *dp, &lv = *(dp=new (buf) S1605C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S1605C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1605C2)");
    check_base_class_offset(lv, (S1605C4*)(S1605C3*), 0, "S1605C2");
    check_base_class_offset(lv, (S1605C3*), 0, "S1605C2");
    check_field_offset(lv, s1605c2f0, ABISELECT(188,132), "S1605C2.s1605c2f0");
    test_class_info(&lv, &cd_S1605C2);
    dp->~S1605C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1605C2(Test_S1605C2, "S1605C2", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN7S1605C2C1Ev();
extern void _ZN7S1605C2D1Ev();
Name_Map name_map_S1605C2[] = {
  NSPAIR(_ZN7S1605C2C1Ev),
  NSPAIR(_ZN7S1605C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1605C4;
extern VTBL_ENTRY _ZTI7S1605C4[];
extern  VTBL_ENTRY _ZTV7S1605C4[];
extern Class_Descriptor cd_S1605C3;
extern VTBL_ENTRY _ZTI7S1605C3[];
extern  VTBL_ENTRY _ZTV7S1605C3[];
static Base_Class bases_S1605C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1605C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1605C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1605C2[];
extern void _ZN7S1605C2D1Ev();
extern void _ZN7S1605C2D0Ev();
extern void _ZN7S1605C42v9Ev();
extern void _ZN7S1605C43v10Ev();
extern void _ZN7S1605C43v11Ev();
extern void _ZN7S1605C43v12Ev();
extern void _ZN7S1605C43v13Ev();
extern void _ZN7S1605C43v14Ev();
extern void _ZN7S1605C43v15Ev();
extern void _ZN7S1605C43v16Ev();
extern void _ZN7S1605C43v17Ev();
extern void _ZN7S1605C43v18Ev();
extern void _ZN7S1605C43v19Ev();
extern void _ZN7S1605C43v20Ev();
extern void _ZN7S1605C43v21Ev();
extern void _ZN7S1605C43v22Ev();
extern void _ZN7S1605C43v23Ev();
extern void _ZN7S1605C43v24Ev();
extern void _ZN7S1605C43v25Ev();
extern void _ZN7S1605C43v26Ev();
extern void _ZN7S1605C43v27Ev();
extern void _ZN7S1605C43v28Ev();
extern void _ZN7S1605C43v29Ev();
extern void _ZN7S1605C43v30Ev();
extern void _ZN7S1605C43v31Ev();
extern void _ZN7S1605C43v32Ev();
extern void _ZN7S1605C43v33Ev();
extern void _ZN7S1605C43v34Ev();
extern void _ZN7S1605C43v35Ev();
extern void _ZN7S1605C43v36Ev();
extern void _ZN7S1605C43v37Ev();
extern void _ZN7S1605C43v38Ev();
extern void _ZN7S1605C43v39Ev();
extern void _ZN7S1605C43v40Ev();
extern void _ZN7S1605C43v41Ev();
extern void _ZN7S1605C43v42Ev();
extern void _ZN7S1605C43v43Ev();
extern void _ZN7S1605C43v44Ev();
extern void _ZN7S1605C43v45Ev();
extern void _ZN7S1605C43v46Ev();
extern void _ZN7S1605C43v47Ev();
extern void _ZN7S1605C43v48Ev();
extern void _ZN7S1605C43v49Ev();
extern void _ZN7S1605C43v50Ev();
extern void _ZN7S1605C43v51Ev();
extern void _ZN7S1605C43v52Ev();
extern void _ZN7S1605C43v53Ev();
extern void _ZN7S1605C43v54Ev();
extern void _ZN7S1605C43v55Ev();
extern void _ZN7S1605C43v56Ev();
extern void _ZN7S1605C43v57Ev();
extern void _ZN7S1605C43v58Ev();
extern void _ZN7S1605C43v59Ev();
extern void _ZN7S1605C43v60Ev();
extern void _ZN7S1605C43v61Ev();
extern void _ZN7S1605C43v62Ev();
extern void _ZN7S1605C43v63Ev();
extern void _ZN7S1605C43v64Ev();
extern void _ZN7S1605C43v65Ev();
extern void _ZN7S1605C43v66Ev();
extern void _ZN7S1605C43v67Ev();
extern void _ZN7S1605C43v68Ev();
extern void _ZN7S1605C43v69Ev();
extern void _ZN7S1605C43v70Ev();
extern void _ZN7S1605C43v71Ev();
extern void _ZN7S1605C43v72Ev();
extern void _ZN7S1605C33v73Ev();
extern void _ZN7S1605C33v74Ev();
extern void _ZN7S1605C33v75Ev();
extern void _ZN7S1605C33v76Ev();
extern void _ZN7S1605C33v77Ev();
extern void _ZN7S1605C33v78Ev();
extern void _ZN7S1605C33v79Ev();
extern void _ZN7S1605C33v80Ev();
extern void _ZN7S1605C33v81Ev();
extern void _ZN7S1605C33v82Ev();
extern void _ZN7S1605C33v83Ev();
extern void _ZN7S1605C33v84Ev();
extern void _ZN7S1605C33v85Ev();
extern void _ZN7S1605C33v86Ev();
extern void _ZN7S1605C33v87Ev();
extern void _ZN7S1605C33v88Ev();
extern void _ZN7S1605C33v89Ev();
extern void _ZN7S1605C33v90Ev();
extern void _ZN7S1605C33v91Ev();
extern void _ZN7S1605C33v92Ev();
extern void _ZN7S1605C33v93Ev();
extern void _ZN7S1605C33v94Ev();
extern void _ZN7S1605C23v95Ev();
extern void _ZN7S1605C23v96Ev();
extern void _ZN7S1605C23v97Ev();
extern void _ZN7S1605C23v98Ev();
extern void _ZN7S1605C23v99Ev();
extern void _ZN7S1605C24v100Ev();
extern void _ZN7S1605C24v101Ev();
extern void _ZN7S1605C24v102Ev();
extern void _ZN7S1605C24v103Ev();
extern void _ZN7S1605C24v104Ev();
extern void _ZN7S1605C24v105Ev();
extern void _ZN7S1605C24v106Ev();
extern void _ZN7S1605C24v107Ev();
extern void _ZN7S1605C24v108Ev();
extern void _ZN7S1605C24v109Ev();
extern void _ZN7S1605C24v110Ev();
extern void _ZN7S1605C24v111Ev();
extern void _ZN7S1605C24v112Ev();
extern void _ZN7S1605C24v113Ev();
static  VTBL_ENTRY vtc_S1605C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1605C2[0]),
  (VTBL_ENTRY)&_ZN7S1605C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1605C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1605C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1605C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1605C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1605C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1605C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1605C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v112Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v113Ev,
};
extern VTBL_ENTRY _ZTI7S1605C2[];
extern  VTBL_ENTRY _ZTV7S1605C2[];
Class_Descriptor cd_S1605C2 = {  "S1605C2", // class name
  bases_S1605C2, 2,
  &(vtc_S1605C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI7S1605C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1605C2),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1605C1  : S1605C2 {
  void *s1605c1f0;
  ::S473C6_nt s1605c1f1;
  unsigned int s1605c1f2:1;
  virtual  ~S1605C1(); // _ZN7S1605C1D1Ev
  virtual void  v1(); // _ZN7S1605C12v1Ev
  virtual void  v2(); // _ZN7S1605C12v2Ev
  virtual void  v3(); // _ZN7S1605C12v3Ev
  virtual void  v4(); // _ZN7S1605C12v4Ev
  virtual void  v5(); // _ZN7S1605C12v5Ev
  virtual void  v6(); // _ZN7S1605C12v6Ev
  virtual void  v7(); // _ZN7S1605C12v7Ev
  virtual void  v8(); // _ZN7S1605C12v8Ev
  S1605C1(); // tgen
};
//SIG(1 S1605C1) C1{ BC2{ BC3{ BC4{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 FC5} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp FC5 Fi:1}


 S1605C1 ::~S1605C1(){ note_dtor("S1605C1", this);}
void  S1605C1 ::v1(){vfunc_called(this, "_ZN7S1605C12v1Ev");}
void  S1605C1 ::v2(){vfunc_called(this, "_ZN7S1605C12v2Ev");}
void  S1605C1 ::v3(){vfunc_called(this, "_ZN7S1605C12v3Ev");}
void  S1605C1 ::v4(){vfunc_called(this, "_ZN7S1605C12v4Ev");}
void  S1605C1 ::v5(){vfunc_called(this, "_ZN7S1605C12v5Ev");}
void  S1605C1 ::v6(){vfunc_called(this, "_ZN7S1605C12v6Ev");}
void  S1605C1 ::v7(){vfunc_called(this, "_ZN7S1605C12v7Ev");}
void  S1605C1 ::v8(){vfunc_called(this, "_ZN7S1605C12v8Ev");}
S1605C1 ::S1605C1(){ note_ctor("S1605C1", this);} // tgen

static void Test_S1605C1()
{
  extern Class_Descriptor cd_S1605C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,40)];
    init_test(&cd_S1605C1, buf);
    S1605C1 *dp, &lv = *(dp=new (buf) S1605C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,156), "sizeof(S1605C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1605C1)");
    check_base_class_offset(lv, (S1605C4*)(S1605C3*)(S1605C2*), 0, "S1605C1");
    check_base_class_offset(lv, (S1605C3*)(S1605C2*), 0, "S1605C1");
    check_base_class_offset(lv, (S1605C2*), 0, "S1605C1");
    check_field_offset(lv, s1605c1f0, ABISELECT(200,140), "S1605C1.s1605c1f0");
    check_field_offset(lv, s1605c1f1, ABISELECT(208,144), "S1605C1.s1605c1f1");
    set_bf_and_test(lv, s1605c1f2, ABISELECT(216,152), 0, 1, 1, "S1605C1");
    test_class_info(&lv, &cd_S1605C1);
    dp->~S1605C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1605C1(Test_S1605C1, "S1605C1", ABISELECT(224,156));

#else // __cplusplus

extern void _ZN7S1605C1C1Ev();
extern void _ZN7S1605C1D1Ev();
Name_Map name_map_S1605C1[] = {
  NSPAIR(_ZN7S1605C1C1Ev),
  NSPAIR(_ZN7S1605C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1605C4;
extern VTBL_ENTRY _ZTI7S1605C4[];
extern  VTBL_ENTRY _ZTV7S1605C4[];
extern Class_Descriptor cd_S1605C3;
extern VTBL_ENTRY _ZTI7S1605C3[];
extern  VTBL_ENTRY _ZTV7S1605C3[];
extern Class_Descriptor cd_S1605C2;
extern VTBL_ENTRY _ZTI7S1605C2[];
extern  VTBL_ENTRY _ZTV7S1605C2[];
static Base_Class bases_S1605C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1605C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1605C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1605C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1605C1[];
extern void _ZN7S1605C1D1Ev();
extern void _ZN7S1605C1D0Ev();
extern void _ZN7S1605C42v9Ev();
extern void _ZN7S1605C43v10Ev();
extern void _ZN7S1605C43v11Ev();
extern void _ZN7S1605C43v12Ev();
extern void _ZN7S1605C43v13Ev();
extern void _ZN7S1605C43v14Ev();
extern void _ZN7S1605C43v15Ev();
extern void _ZN7S1605C43v16Ev();
extern void _ZN7S1605C43v17Ev();
extern void _ZN7S1605C43v18Ev();
extern void _ZN7S1605C43v19Ev();
extern void _ZN7S1605C43v20Ev();
extern void _ZN7S1605C43v21Ev();
extern void _ZN7S1605C43v22Ev();
extern void _ZN7S1605C43v23Ev();
extern void _ZN7S1605C43v24Ev();
extern void _ZN7S1605C43v25Ev();
extern void _ZN7S1605C43v26Ev();
extern void _ZN7S1605C43v27Ev();
extern void _ZN7S1605C43v28Ev();
extern void _ZN7S1605C43v29Ev();
extern void _ZN7S1605C43v30Ev();
extern void _ZN7S1605C43v31Ev();
extern void _ZN7S1605C43v32Ev();
extern void _ZN7S1605C43v33Ev();
extern void _ZN7S1605C43v34Ev();
extern void _ZN7S1605C43v35Ev();
extern void _ZN7S1605C43v36Ev();
extern void _ZN7S1605C43v37Ev();
extern void _ZN7S1605C43v38Ev();
extern void _ZN7S1605C43v39Ev();
extern void _ZN7S1605C43v40Ev();
extern void _ZN7S1605C43v41Ev();
extern void _ZN7S1605C43v42Ev();
extern void _ZN7S1605C43v43Ev();
extern void _ZN7S1605C43v44Ev();
extern void _ZN7S1605C43v45Ev();
extern void _ZN7S1605C43v46Ev();
extern void _ZN7S1605C43v47Ev();
extern void _ZN7S1605C43v48Ev();
extern void _ZN7S1605C43v49Ev();
extern void _ZN7S1605C43v50Ev();
extern void _ZN7S1605C43v51Ev();
extern void _ZN7S1605C43v52Ev();
extern void _ZN7S1605C43v53Ev();
extern void _ZN7S1605C43v54Ev();
extern void _ZN7S1605C43v55Ev();
extern void _ZN7S1605C43v56Ev();
extern void _ZN7S1605C43v57Ev();
extern void _ZN7S1605C43v58Ev();
extern void _ZN7S1605C43v59Ev();
extern void _ZN7S1605C43v60Ev();
extern void _ZN7S1605C43v61Ev();
extern void _ZN7S1605C43v62Ev();
extern void _ZN7S1605C43v63Ev();
extern void _ZN7S1605C43v64Ev();
extern void _ZN7S1605C43v65Ev();
extern void _ZN7S1605C43v66Ev();
extern void _ZN7S1605C43v67Ev();
extern void _ZN7S1605C43v68Ev();
extern void _ZN7S1605C43v69Ev();
extern void _ZN7S1605C43v70Ev();
extern void _ZN7S1605C43v71Ev();
extern void _ZN7S1605C43v72Ev();
extern void _ZN7S1605C33v73Ev();
extern void _ZN7S1605C33v74Ev();
extern void _ZN7S1605C33v75Ev();
extern void _ZN7S1605C33v76Ev();
extern void _ZN7S1605C33v77Ev();
extern void _ZN7S1605C33v78Ev();
extern void _ZN7S1605C33v79Ev();
extern void _ZN7S1605C33v80Ev();
extern void _ZN7S1605C33v81Ev();
extern void _ZN7S1605C33v82Ev();
extern void _ZN7S1605C33v83Ev();
extern void _ZN7S1605C33v84Ev();
extern void _ZN7S1605C33v85Ev();
extern void _ZN7S1605C33v86Ev();
extern void _ZN7S1605C33v87Ev();
extern void _ZN7S1605C33v88Ev();
extern void _ZN7S1605C33v89Ev();
extern void _ZN7S1605C33v90Ev();
extern void _ZN7S1605C33v91Ev();
extern void _ZN7S1605C33v92Ev();
extern void _ZN7S1605C33v93Ev();
extern void _ZN7S1605C33v94Ev();
extern void _ZN7S1605C23v95Ev();
extern void _ZN7S1605C23v96Ev();
extern void _ZN7S1605C23v97Ev();
extern void _ZN7S1605C23v98Ev();
extern void _ZN7S1605C23v99Ev();
extern void _ZN7S1605C24v100Ev();
extern void _ZN7S1605C24v101Ev();
extern void _ZN7S1605C24v102Ev();
extern void _ZN7S1605C24v103Ev();
extern void _ZN7S1605C24v104Ev();
extern void _ZN7S1605C24v105Ev();
extern void _ZN7S1605C24v106Ev();
extern void _ZN7S1605C24v107Ev();
extern void _ZN7S1605C24v108Ev();
extern void _ZN7S1605C24v109Ev();
extern void _ZN7S1605C24v110Ev();
extern void _ZN7S1605C24v111Ev();
extern void _ZN7S1605C24v112Ev();
extern void _ZN7S1605C24v113Ev();
extern void _ZN7S1605C12v1Ev();
extern void _ZN7S1605C12v2Ev();
extern void _ZN7S1605C12v3Ev();
extern void _ZN7S1605C12v4Ev();
extern void _ZN7S1605C12v5Ev();
extern void _ZN7S1605C12v6Ev();
extern void _ZN7S1605C12v7Ev();
extern void _ZN7S1605C12v8Ev();
static  VTBL_ENTRY vtc_S1605C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1605C1[0]),
  (VTBL_ENTRY)&_ZN7S1605C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1605C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1605C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1605C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1605C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1605C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1605C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1605C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1605C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1605C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v112Ev,
  (VTBL_ENTRY)&_ZN7S1605C24v113Ev,
  (VTBL_ENTRY)&_ZN7S1605C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1605C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1605C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1605C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1605C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1605C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1605C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1605C12v8Ev,
};
extern VTBL_ENTRY _ZTI7S1605C1[];
extern  VTBL_ENTRY _ZTV7S1605C1[];
Class_Descriptor cd_S1605C1 = {  "S1605C1", // class name
  bases_S1605C1, 3,
  &(vtc_S1605C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,156), // object size
  NSPAIRA(_ZTI7S1605C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1605C1),117, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1580C4  {
  int s1580c4f0;
  __tsi64 s1580c4f1;
  void *s1580c4f2[4];
  int s1580c4f3[2];
  void *s1580c4f4;
  ::S473C6_nt s1580c4f5;
  void *s1580c4f6[2];
  virtual  ~S1580C4(); // _ZN7S1580C4D1Ev
  virtual void  v8(); // _ZN7S1580C42v8Ev
  virtual void  v9(); // _ZN7S1580C42v9Ev
  virtual void  v10(); // _ZN7S1580C43v10Ev
  virtual void  v11(); // _ZN7S1580C43v11Ev
  virtual void  v12(); // _ZN7S1580C43v12Ev
  virtual void  v13(); // _ZN7S1580C43v13Ev
  virtual void  v14(); // _ZN7S1580C43v14Ev
  virtual void  v15(); // _ZN7S1580C43v15Ev
  virtual void  v16(); // _ZN7S1580C43v16Ev
  virtual void  v17(); // _ZN7S1580C43v17Ev
  virtual void  v18(); // _ZN7S1580C43v18Ev
  virtual void  v19(); // _ZN7S1580C43v19Ev
  virtual void  v20(); // _ZN7S1580C43v20Ev
  virtual void  v21(); // _ZN7S1580C43v21Ev
  virtual void  v22(); // _ZN7S1580C43v22Ev
  virtual void  v23(); // _ZN7S1580C43v23Ev
  virtual void  v24(); // _ZN7S1580C43v24Ev
  virtual void  v25(); // _ZN7S1580C43v25Ev
  virtual void  v26(); // _ZN7S1580C43v26Ev
  virtual void  v27(); // _ZN7S1580C43v27Ev
  virtual void  v28(); // _ZN7S1580C43v28Ev
  virtual void  v29(); // _ZN7S1580C43v29Ev
  virtual void  v30(); // _ZN7S1580C43v30Ev
  virtual void  v31(); // _ZN7S1580C43v31Ev
  virtual void  v32(); // _ZN7S1580C43v32Ev
  virtual void  v33(); // _ZN7S1580C43v33Ev
  virtual void  v34(); // _ZN7S1580C43v34Ev
  virtual void  v35(); // _ZN7S1580C43v35Ev
  virtual void  v36(); // _ZN7S1580C43v36Ev
  virtual void  v37(); // _ZN7S1580C43v37Ev
  virtual void  v38(); // _ZN7S1580C43v38Ev
  virtual void  v39(); // _ZN7S1580C43v39Ev
  virtual void  v40(); // _ZN7S1580C43v40Ev
  virtual void  v41(); // _ZN7S1580C43v41Ev
  virtual void  v42(); // _ZN7S1580C43v42Ev
  virtual void  v43(); // _ZN7S1580C43v43Ev
  virtual void  v44(); // _ZN7S1580C43v44Ev
  virtual void  v45(); // _ZN7S1580C43v45Ev
  virtual void  v46(); // _ZN7S1580C43v46Ev
  virtual void  v47(); // _ZN7S1580C43v47Ev
  virtual void  v48(); // _ZN7S1580C43v48Ev
  virtual void  v49(); // _ZN7S1580C43v49Ev
  virtual void  v50(); // _ZN7S1580C43v50Ev
  virtual void  v51(); // _ZN7S1580C43v51Ev
  virtual void  v52(); // _ZN7S1580C43v52Ev
  virtual void  v53(); // _ZN7S1580C43v53Ev
  virtual void  v54(); // _ZN7S1580C43v54Ev
  virtual void  v55(); // _ZN7S1580C43v55Ev
  virtual void  v56(); // _ZN7S1580C43v56Ev
  virtual void  v57(); // _ZN7S1580C43v57Ev
  virtual void  v58(); // _ZN7S1580C43v58Ev
  virtual void  v59(); // _ZN7S1580C43v59Ev
  virtual void  v60(); // _ZN7S1580C43v60Ev
  virtual void  v61(); // _ZN7S1580C43v61Ev
  virtual void  v62(); // _ZN7S1580C43v62Ev
  virtual void  v63(); // _ZN7S1580C43v63Ev
  virtual void  v64(); // _ZN7S1580C43v64Ev
  virtual void  v65(); // _ZN7S1580C43v65Ev
  virtual void  v66(); // _ZN7S1580C43v66Ev
  virtual void  v67(); // _ZN7S1580C43v67Ev
  virtual void  v68(); // _ZN7S1580C43v68Ev
  virtual void  v69(); // _ZN7S1580C43v69Ev
  virtual void  v70(); // _ZN7S1580C43v70Ev
  virtual void  v71(); // _ZN7S1580C43v71Ev
  S1580C4(); // tgen
};
//SIG(-1 S1580C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1580C4 ::~S1580C4(){ note_dtor("S1580C4", this);}
void  S1580C4 ::v8(){vfunc_called(this, "_ZN7S1580C42v8Ev");}
void  S1580C4 ::v9(){vfunc_called(this, "_ZN7S1580C42v9Ev");}
void  S1580C4 ::v10(){vfunc_called(this, "_ZN7S1580C43v10Ev");}
void  S1580C4 ::v11(){vfunc_called(this, "_ZN7S1580C43v11Ev");}
void  S1580C4 ::v12(){vfunc_called(this, "_ZN7S1580C43v12Ev");}
void  S1580C4 ::v13(){vfunc_called(this, "_ZN7S1580C43v13Ev");}
void  S1580C4 ::v14(){vfunc_called(this, "_ZN7S1580C43v14Ev");}
void  S1580C4 ::v15(){vfunc_called(this, "_ZN7S1580C43v15Ev");}
void  S1580C4 ::v16(){vfunc_called(this, "_ZN7S1580C43v16Ev");}
void  S1580C4 ::v17(){vfunc_called(this, "_ZN7S1580C43v17Ev");}
void  S1580C4 ::v18(){vfunc_called(this, "_ZN7S1580C43v18Ev");}
void  S1580C4 ::v19(){vfunc_called(this, "_ZN7S1580C43v19Ev");}
void  S1580C4 ::v20(){vfunc_called(this, "_ZN7S1580C43v20Ev");}
void  S1580C4 ::v21(){vfunc_called(this, "_ZN7S1580C43v21Ev");}
void  S1580C4 ::v22(){vfunc_called(this, "_ZN7S1580C43v22Ev");}
void  S1580C4 ::v23(){vfunc_called(this, "_ZN7S1580C43v23Ev");}
void  S1580C4 ::v24(){vfunc_called(this, "_ZN7S1580C43v24Ev");}
void  S1580C4 ::v25(){vfunc_called(this, "_ZN7S1580C43v25Ev");}
void  S1580C4 ::v26(){vfunc_called(this, "_ZN7S1580C43v26Ev");}
void  S1580C4 ::v27(){vfunc_called(this, "_ZN7S1580C43v27Ev");}
void  S1580C4 ::v28(){vfunc_called(this, "_ZN7S1580C43v28Ev");}
void  S1580C4 ::v29(){vfunc_called(this, "_ZN7S1580C43v29Ev");}
void  S1580C4 ::v30(){vfunc_called(this, "_ZN7S1580C43v30Ev");}
void  S1580C4 ::v31(){vfunc_called(this, "_ZN7S1580C43v31Ev");}
void  S1580C4 ::v32(){vfunc_called(this, "_ZN7S1580C43v32Ev");}
void  S1580C4 ::v33(){vfunc_called(this, "_ZN7S1580C43v33Ev");}
void  S1580C4 ::v34(){vfunc_called(this, "_ZN7S1580C43v34Ev");}
void  S1580C4 ::v35(){vfunc_called(this, "_ZN7S1580C43v35Ev");}
void  S1580C4 ::v36(){vfunc_called(this, "_ZN7S1580C43v36Ev");}
void  S1580C4 ::v37(){vfunc_called(this, "_ZN7S1580C43v37Ev");}
void  S1580C4 ::v38(){vfunc_called(this, "_ZN7S1580C43v38Ev");}
void  S1580C4 ::v39(){vfunc_called(this, "_ZN7S1580C43v39Ev");}
void  S1580C4 ::v40(){vfunc_called(this, "_ZN7S1580C43v40Ev");}
void  S1580C4 ::v41(){vfunc_called(this, "_ZN7S1580C43v41Ev");}
void  S1580C4 ::v42(){vfunc_called(this, "_ZN7S1580C43v42Ev");}
void  S1580C4 ::v43(){vfunc_called(this, "_ZN7S1580C43v43Ev");}
void  S1580C4 ::v44(){vfunc_called(this, "_ZN7S1580C43v44Ev");}
void  S1580C4 ::v45(){vfunc_called(this, "_ZN7S1580C43v45Ev");}
void  S1580C4 ::v46(){vfunc_called(this, "_ZN7S1580C43v46Ev");}
void  S1580C4 ::v47(){vfunc_called(this, "_ZN7S1580C43v47Ev");}
void  S1580C4 ::v48(){vfunc_called(this, "_ZN7S1580C43v48Ev");}
void  S1580C4 ::v49(){vfunc_called(this, "_ZN7S1580C43v49Ev");}
void  S1580C4 ::v50(){vfunc_called(this, "_ZN7S1580C43v50Ev");}
void  S1580C4 ::v51(){vfunc_called(this, "_ZN7S1580C43v51Ev");}
void  S1580C4 ::v52(){vfunc_called(this, "_ZN7S1580C43v52Ev");}
void  S1580C4 ::v53(){vfunc_called(this, "_ZN7S1580C43v53Ev");}
void  S1580C4 ::v54(){vfunc_called(this, "_ZN7S1580C43v54Ev");}
void  S1580C4 ::v55(){vfunc_called(this, "_ZN7S1580C43v55Ev");}
void  S1580C4 ::v56(){vfunc_called(this, "_ZN7S1580C43v56Ev");}
void  S1580C4 ::v57(){vfunc_called(this, "_ZN7S1580C43v57Ev");}
void  S1580C4 ::v58(){vfunc_called(this, "_ZN7S1580C43v58Ev");}
void  S1580C4 ::v59(){vfunc_called(this, "_ZN7S1580C43v59Ev");}
void  S1580C4 ::v60(){vfunc_called(this, "_ZN7S1580C43v60Ev");}
void  S1580C4 ::v61(){vfunc_called(this, "_ZN7S1580C43v61Ev");}
void  S1580C4 ::v62(){vfunc_called(this, "_ZN7S1580C43v62Ev");}
void  S1580C4 ::v63(){vfunc_called(this, "_ZN7S1580C43v63Ev");}
void  S1580C4 ::v64(){vfunc_called(this, "_ZN7S1580C43v64Ev");}
void  S1580C4 ::v65(){vfunc_called(this, "_ZN7S1580C43v65Ev");}
void  S1580C4 ::v66(){vfunc_called(this, "_ZN7S1580C43v66Ev");}
void  S1580C4 ::v67(){vfunc_called(this, "_ZN7S1580C43v67Ev");}
void  S1580C4 ::v68(){vfunc_called(this, "_ZN7S1580C43v68Ev");}
void  S1580C4 ::v69(){vfunc_called(this, "_ZN7S1580C43v69Ev");}
void  S1580C4 ::v70(){vfunc_called(this, "_ZN7S1580C43v70Ev");}
void  S1580C4 ::v71(){vfunc_called(this, "_ZN7S1580C43v71Ev");}
S1580C4 ::S1580C4(){ note_ctor("S1580C4", this);} // tgen

static void Test_S1580C4()
{
  extern Class_Descriptor cd_S1580C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1580C4, buf);
    S1580C4 *dp, &lv = *(dp=new (buf) S1580C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1580C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1580C4)");
    check_field_offset(lv, s1580c4f0, ABISELECT(8,4), "S1580C4.s1580c4f0");
    check_field_offset(lv, s1580c4f1, ABISELECT(16,8), "S1580C4.s1580c4f1");
    check_field_offset(lv, s1580c4f2, ABISELECT(24,16), "S1580C4.s1580c4f2");
    check_field_offset(lv, s1580c4f3, ABISELECT(56,32), "S1580C4.s1580c4f3");
    check_field_offset(lv, s1580c4f4, ABISELECT(64,40), "S1580C4.s1580c4f4");
    check_field_offset(lv, s1580c4f5, ABISELECT(72,44), "S1580C4.s1580c4f5");
    check_field_offset(lv, s1580c4f6, ABISELECT(80,52), "S1580C4.s1580c4f6");
    test_class_info(&lv, &cd_S1580C4);
    dp->~S1580C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1580C4(Test_S1580C4, "S1580C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1580C4C1Ev();
extern void _ZN7S1580C4D1Ev();
Name_Map name_map_S1580C4[] = {
  NSPAIR(_ZN7S1580C4C1Ev),
  NSPAIR(_ZN7S1580C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1580C4[];
extern void _ZN7S1580C4D1Ev();
extern void _ZN7S1580C4D0Ev();
extern void _ZN7S1580C42v8Ev();
extern void _ZN7S1580C42v9Ev();
extern void _ZN7S1580C43v10Ev();
extern void _ZN7S1580C43v11Ev();
extern void _ZN7S1580C43v12Ev();
extern void _ZN7S1580C43v13Ev();
extern void _ZN7S1580C43v14Ev();
extern void _ZN7S1580C43v15Ev();
extern void _ZN7S1580C43v16Ev();
extern void _ZN7S1580C43v17Ev();
extern void _ZN7S1580C43v18Ev();
extern void _ZN7S1580C43v19Ev();
extern void _ZN7S1580C43v20Ev();
extern void _ZN7S1580C43v21Ev();
extern void _ZN7S1580C43v22Ev();
extern void _ZN7S1580C43v23Ev();
extern void _ZN7S1580C43v24Ev();
extern void _ZN7S1580C43v25Ev();
extern void _ZN7S1580C43v26Ev();
extern void _ZN7S1580C43v27Ev();
extern void _ZN7S1580C43v28Ev();
extern void _ZN7S1580C43v29Ev();
extern void _ZN7S1580C43v30Ev();
extern void _ZN7S1580C43v31Ev();
extern void _ZN7S1580C43v32Ev();
extern void _ZN7S1580C43v33Ev();
extern void _ZN7S1580C43v34Ev();
extern void _ZN7S1580C43v35Ev();
extern void _ZN7S1580C43v36Ev();
extern void _ZN7S1580C43v37Ev();
extern void _ZN7S1580C43v38Ev();
extern void _ZN7S1580C43v39Ev();
extern void _ZN7S1580C43v40Ev();
extern void _ZN7S1580C43v41Ev();
extern void _ZN7S1580C43v42Ev();
extern void _ZN7S1580C43v43Ev();
extern void _ZN7S1580C43v44Ev();
extern void _ZN7S1580C43v45Ev();
extern void _ZN7S1580C43v46Ev();
extern void _ZN7S1580C43v47Ev();
extern void _ZN7S1580C43v48Ev();
extern void _ZN7S1580C43v49Ev();
extern void _ZN7S1580C43v50Ev();
extern void _ZN7S1580C43v51Ev();
extern void _ZN7S1580C43v52Ev();
extern void _ZN7S1580C43v53Ev();
extern void _ZN7S1580C43v54Ev();
extern void _ZN7S1580C43v55Ev();
extern void _ZN7S1580C43v56Ev();
extern void _ZN7S1580C43v57Ev();
extern void _ZN7S1580C43v58Ev();
extern void _ZN7S1580C43v59Ev();
extern void _ZN7S1580C43v60Ev();
extern void _ZN7S1580C43v61Ev();
extern void _ZN7S1580C43v62Ev();
extern void _ZN7S1580C43v63Ev();
extern void _ZN7S1580C43v64Ev();
extern void _ZN7S1580C43v65Ev();
extern void _ZN7S1580C43v66Ev();
extern void _ZN7S1580C43v67Ev();
extern void _ZN7S1580C43v68Ev();
extern void _ZN7S1580C43v69Ev();
extern void _ZN7S1580C43v70Ev();
extern void _ZN7S1580C43v71Ev();
static  VTBL_ENTRY vtc_S1580C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1580C4[0]),
  (VTBL_ENTRY)&_ZN7S1580C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1580C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1580C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1580C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v71Ev,
};
extern VTBL_ENTRY _ZTI7S1580C4[];
extern  VTBL_ENTRY _ZTV7S1580C4[];
Class_Descriptor cd_S1580C4 = {  "S1580C4", // class name
  0,0,//no base classes
  &(vtc_S1580C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1580C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1580C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1580C3  : S1580C4 {
  int s1580c3f0[2];
  void *s1580c3f1;
  int s1580c3f2[2];
  ::S473C7_nt s1580c3f3;
  ::S473C7_nt s1580c3f4;
  ::S21925C42 s1580c3f5;
  ::S473C7_nt s1580c3f6;
  unsigned int s1580c3f7:1;
  unsigned int s1580c3f8:1;
  unsigned int s1580c3f9:1;
  unsigned int s1580c3f10:1;
  unsigned int s1580c3f11:1;
  int s1580c3f12[2];
  virtual  ~S1580C3(); // _ZN7S1580C3D1Ev
  virtual void  v72(); // _ZN7S1580C33v72Ev
  virtual void  v73(); // _ZN7S1580C33v73Ev
  virtual void  v74(); // _ZN7S1580C33v74Ev
  virtual void  v75(); // _ZN7S1580C33v75Ev
  virtual void  v76(); // _ZN7S1580C33v76Ev
  virtual void  v77(); // _ZN7S1580C33v77Ev
  virtual void  v78(); // _ZN7S1580C33v78Ev
  virtual void  v79(); // _ZN7S1580C33v79Ev
  virtual void  v80(); // _ZN7S1580C33v80Ev
  virtual void  v81(); // _ZN7S1580C33v81Ev
  virtual void  v82(); // _ZN7S1580C33v82Ev
  virtual void  v83(); // _ZN7S1580C33v83Ev
  virtual void  v84(); // _ZN7S1580C33v84Ev
  virtual void  v85(); // _ZN7S1580C33v85Ev
  virtual void  v86(); // _ZN7S1580C33v86Ev
  virtual void  v87(); // _ZN7S1580C33v87Ev
  virtual void  v88(); // _ZN7S1580C33v88Ev
  virtual void  v89(); // _ZN7S1580C33v89Ev
  virtual void  v90(); // _ZN7S1580C33v90Ev
  virtual void  v91(); // _ZN7S1580C33v91Ev
  virtual void  v92(); // _ZN7S1580C33v92Ev
  virtual void  v93(); // _ZN7S1580C33v93Ev
  S1580C3(); // tgen
};
//SIG(-1 S1580C3) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S1580C3 ::~S1580C3(){ note_dtor("S1580C3", this);}
void  S1580C3 ::v72(){vfunc_called(this, "_ZN7S1580C33v72Ev");}
void  S1580C3 ::v73(){vfunc_called(this, "_ZN7S1580C33v73Ev");}
void  S1580C3 ::v74(){vfunc_called(this, "_ZN7S1580C33v74Ev");}
void  S1580C3 ::v75(){vfunc_called(this, "_ZN7S1580C33v75Ev");}
void  S1580C3 ::v76(){vfunc_called(this, "_ZN7S1580C33v76Ev");}
void  S1580C3 ::v77(){vfunc_called(this, "_ZN7S1580C33v77Ev");}
void  S1580C3 ::v78(){vfunc_called(this, "_ZN7S1580C33v78Ev");}
void  S1580C3 ::v79(){vfunc_called(this, "_ZN7S1580C33v79Ev");}
void  S1580C3 ::v80(){vfunc_called(this, "_ZN7S1580C33v80Ev");}
void  S1580C3 ::v81(){vfunc_called(this, "_ZN7S1580C33v81Ev");}
void  S1580C3 ::v82(){vfunc_called(this, "_ZN7S1580C33v82Ev");}
void  S1580C3 ::v83(){vfunc_called(this, "_ZN7S1580C33v83Ev");}
void  S1580C3 ::v84(){vfunc_called(this, "_ZN7S1580C33v84Ev");}
void  S1580C3 ::v85(){vfunc_called(this, "_ZN7S1580C33v85Ev");}
void  S1580C3 ::v86(){vfunc_called(this, "_ZN7S1580C33v86Ev");}
void  S1580C3 ::v87(){vfunc_called(this, "_ZN7S1580C33v87Ev");}
void  S1580C3 ::v88(){vfunc_called(this, "_ZN7S1580C33v88Ev");}
void  S1580C3 ::v89(){vfunc_called(this, "_ZN7S1580C33v89Ev");}
void  S1580C3 ::v90(){vfunc_called(this, "_ZN7S1580C33v90Ev");}
void  S1580C3 ::v91(){vfunc_called(this, "_ZN7S1580C33v91Ev");}
void  S1580C3 ::v92(){vfunc_called(this, "_ZN7S1580C33v92Ev");}
void  S1580C3 ::v93(){vfunc_called(this, "_ZN7S1580C33v93Ev");}
S1580C3 ::S1580C3(){ note_ctor("S1580C3", this);} // tgen

static void Test_S1580C3()
{
  extern Class_Descriptor cd_S1580C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S1580C3, buf);
    S1580C3 *dp, &lv = *(dp=new (buf) S1580C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S1580C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1580C3)");
    check_base_class_offset(lv, (S1580C4*), 0, "S1580C3");
    check_field_offset(lv, s1580c3f0, ABISELECT(96,60), "S1580C3.s1580c3f0");
    check_field_offset(lv, s1580c3f1, ABISELECT(104,68), "S1580C3.s1580c3f1");
    check_field_offset(lv, s1580c3f2, ABISELECT(112,72), "S1580C3.s1580c3f2");
    check_field_offset(lv, s1580c3f3, ABISELECT(120,80), "S1580C3.s1580c3f3");
    check_field_offset(lv, s1580c3f4, ABISELECT(136,92), "S1580C3.s1580c3f4");
    check_field_offset(lv, s1580c3f5, ABISELECT(152,104), "S1580C3.s1580c3f5");
    check_field_offset(lv, s1580c3f6, ABISELECT(160,108), "S1580C3.s1580c3f6");
    set_bf_and_test(lv, s1580c3f7, ABISELECT(176,120), 0, 1, 1, "S1580C3");
    set_bf_and_test(lv, s1580c3f8, ABISELECT(176,120), 1, 1, 1, "S1580C3");
    set_bf_and_test(lv, s1580c3f9, ABISELECT(176,120), 2, 1, 1, "S1580C3");
    set_bf_and_test(lv, s1580c3f10, ABISELECT(176,120), 3, 1, 1, "S1580C3");
    set_bf_and_test(lv, s1580c3f11, ABISELECT(176,120), 4, 1, 1, "S1580C3");
    check_field_offset(lv, s1580c3f12, ABISELECT(180,124), "S1580C3.s1580c3f12");
    test_class_info(&lv, &cd_S1580C3);
    dp->~S1580C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1580C3(Test_S1580C3, "S1580C3", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN7S1580C3C1Ev();
extern void _ZN7S1580C3D1Ev();
Name_Map name_map_S1580C3[] = {
  NSPAIR(_ZN7S1580C3C1Ev),
  NSPAIR(_ZN7S1580C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1580C4;
extern VTBL_ENTRY _ZTI7S1580C4[];
extern  VTBL_ENTRY _ZTV7S1580C4[];
static Base_Class bases_S1580C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1580C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1580C3[];
extern void _ZN7S1580C3D1Ev();
extern void _ZN7S1580C3D0Ev();
extern void _ZN7S1580C42v8Ev();
extern void _ZN7S1580C42v9Ev();
extern void _ZN7S1580C43v10Ev();
extern void _ZN7S1580C43v11Ev();
extern void _ZN7S1580C43v12Ev();
extern void _ZN7S1580C43v13Ev();
extern void _ZN7S1580C43v14Ev();
extern void _ZN7S1580C43v15Ev();
extern void _ZN7S1580C43v16Ev();
extern void _ZN7S1580C43v17Ev();
extern void _ZN7S1580C43v18Ev();
extern void _ZN7S1580C43v19Ev();
extern void _ZN7S1580C43v20Ev();
extern void _ZN7S1580C43v21Ev();
extern void _ZN7S1580C43v22Ev();
extern void _ZN7S1580C43v23Ev();
extern void _ZN7S1580C43v24Ev();
extern void _ZN7S1580C43v25Ev();
extern void _ZN7S1580C43v26Ev();
extern void _ZN7S1580C43v27Ev();
extern void _ZN7S1580C43v28Ev();
extern void _ZN7S1580C43v29Ev();
extern void _ZN7S1580C43v30Ev();
extern void _ZN7S1580C43v31Ev();
extern void _ZN7S1580C43v32Ev();
extern void _ZN7S1580C43v33Ev();
extern void _ZN7S1580C43v34Ev();
extern void _ZN7S1580C43v35Ev();
extern void _ZN7S1580C43v36Ev();
extern void _ZN7S1580C43v37Ev();
extern void _ZN7S1580C43v38Ev();
extern void _ZN7S1580C43v39Ev();
extern void _ZN7S1580C43v40Ev();
extern void _ZN7S1580C43v41Ev();
extern void _ZN7S1580C43v42Ev();
extern void _ZN7S1580C43v43Ev();
extern void _ZN7S1580C43v44Ev();
extern void _ZN7S1580C43v45Ev();
extern void _ZN7S1580C43v46Ev();
extern void _ZN7S1580C43v47Ev();
extern void _ZN7S1580C43v48Ev();
extern void _ZN7S1580C43v49Ev();
extern void _ZN7S1580C43v50Ev();
extern void _ZN7S1580C43v51Ev();
extern void _ZN7S1580C43v52Ev();
extern void _ZN7S1580C43v53Ev();
extern void _ZN7S1580C43v54Ev();
extern void _ZN7S1580C43v55Ev();
extern void _ZN7S1580C43v56Ev();
extern void _ZN7S1580C43v57Ev();
extern void _ZN7S1580C43v58Ev();
extern void _ZN7S1580C43v59Ev();
extern void _ZN7S1580C43v60Ev();
extern void _ZN7S1580C43v61Ev();
extern void _ZN7S1580C43v62Ev();
extern void _ZN7S1580C43v63Ev();
extern void _ZN7S1580C43v64Ev();
extern void _ZN7S1580C43v65Ev();
extern void _ZN7S1580C43v66Ev();
extern void _ZN7S1580C43v67Ev();
extern void _ZN7S1580C43v68Ev();
extern void _ZN7S1580C43v69Ev();
extern void _ZN7S1580C43v70Ev();
extern void _ZN7S1580C43v71Ev();
extern void _ZN7S1580C33v72Ev();
extern void _ZN7S1580C33v73Ev();
extern void _ZN7S1580C33v74Ev();
extern void _ZN7S1580C33v75Ev();
extern void _ZN7S1580C33v76Ev();
extern void _ZN7S1580C33v77Ev();
extern void _ZN7S1580C33v78Ev();
extern void _ZN7S1580C33v79Ev();
extern void _ZN7S1580C33v80Ev();
extern void _ZN7S1580C33v81Ev();
extern void _ZN7S1580C33v82Ev();
extern void _ZN7S1580C33v83Ev();
extern void _ZN7S1580C33v84Ev();
extern void _ZN7S1580C33v85Ev();
extern void _ZN7S1580C33v86Ev();
extern void _ZN7S1580C33v87Ev();
extern void _ZN7S1580C33v88Ev();
extern void _ZN7S1580C33v89Ev();
extern void _ZN7S1580C33v90Ev();
extern void _ZN7S1580C33v91Ev();
extern void _ZN7S1580C33v92Ev();
extern void _ZN7S1580C33v93Ev();
static  VTBL_ENTRY vtc_S1580C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1580C3[0]),
  (VTBL_ENTRY)&_ZN7S1580C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1580C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1580C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1580C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v93Ev,
};
extern VTBL_ENTRY _ZTI7S1580C3[];
extern  VTBL_ENTRY _ZTV7S1580C3[];
Class_Descriptor cd_S1580C3 = {  "S1580C3", // class name
  bases_S1580C3, 1,
  &(vtc_S1580C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI7S1580C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1580C3),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1580C2  : S1580C3 {
  ::S473C6_nt s1580c2f0;
  virtual  ~S1580C2(); // _ZN7S1580C2D1Ev
  virtual void  v94(); // _ZN7S1580C23v94Ev
  virtual void  v95(); // _ZN7S1580C23v95Ev
  virtual void  v96(); // _ZN7S1580C23v96Ev
  virtual void  v97(); // _ZN7S1580C23v97Ev
  virtual void  v98(); // _ZN7S1580C23v98Ev
  virtual void  v99(); // _ZN7S1580C23v99Ev
  virtual void  v100(); // _ZN7S1580C24v100Ev
  virtual void  v101(); // _ZN7S1580C24v101Ev
  virtual void  v102(); // _ZN7S1580C24v102Ev
  virtual void  v103(); // _ZN7S1580C24v103Ev
  virtual void  v104(); // _ZN7S1580C24v104Ev
  virtual void  v105(); // _ZN7S1580C24v105Ev
  virtual void  v106(); // _ZN7S1580C24v106Ev
  virtual void  v107(); // _ZN7S1580C24v107Ev
  virtual void  v108(); // _ZN7S1580C24v108Ev
  virtual void  v109(); // _ZN7S1580C24v109Ev
  virtual void  v110(); // _ZN7S1580C24v110Ev
  virtual void  v111(); // _ZN7S1580C24v111Ev
  virtual void  v112(); // _ZN7S1580C24v112Ev
  S1580C2(); // tgen
};
//SIG(-1 S1580C2) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S1580C2 ::~S1580C2(){ note_dtor("S1580C2", this);}
void  S1580C2 ::v94(){vfunc_called(this, "_ZN7S1580C23v94Ev");}
void  S1580C2 ::v95(){vfunc_called(this, "_ZN7S1580C23v95Ev");}
void  S1580C2 ::v96(){vfunc_called(this, "_ZN7S1580C23v96Ev");}
void  S1580C2 ::v97(){vfunc_called(this, "_ZN7S1580C23v97Ev");}
void  S1580C2 ::v98(){vfunc_called(this, "_ZN7S1580C23v98Ev");}
void  S1580C2 ::v99(){vfunc_called(this, "_ZN7S1580C23v99Ev");}
void  S1580C2 ::v100(){vfunc_called(this, "_ZN7S1580C24v100Ev");}
void  S1580C2 ::v101(){vfunc_called(this, "_ZN7S1580C24v101Ev");}
void  S1580C2 ::v102(){vfunc_called(this, "_ZN7S1580C24v102Ev");}
void  S1580C2 ::v103(){vfunc_called(this, "_ZN7S1580C24v103Ev");}
void  S1580C2 ::v104(){vfunc_called(this, "_ZN7S1580C24v104Ev");}
void  S1580C2 ::v105(){vfunc_called(this, "_ZN7S1580C24v105Ev");}
void  S1580C2 ::v106(){vfunc_called(this, "_ZN7S1580C24v106Ev");}
void  S1580C2 ::v107(){vfunc_called(this, "_ZN7S1580C24v107Ev");}
void  S1580C2 ::v108(){vfunc_called(this, "_ZN7S1580C24v108Ev");}
void  S1580C2 ::v109(){vfunc_called(this, "_ZN7S1580C24v109Ev");}
void  S1580C2 ::v110(){vfunc_called(this, "_ZN7S1580C24v110Ev");}
void  S1580C2 ::v111(){vfunc_called(this, "_ZN7S1580C24v111Ev");}
void  S1580C2 ::v112(){vfunc_called(this, "_ZN7S1580C24v112Ev");}
S1580C2 ::S1580C2(){ note_ctor("S1580C2", this);} // tgen

static void Test_S1580C2()
{
  extern Class_Descriptor cd_S1580C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S1580C2, buf);
    S1580C2 *dp, &lv = *(dp=new (buf) S1580C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S1580C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1580C2)");
    check_base_class_offset(lv, (S1580C4*)(S1580C3*), 0, "S1580C2");
    check_base_class_offset(lv, (S1580C3*), 0, "S1580C2");
    check_field_offset(lv, s1580c2f0, ABISELECT(188,132), "S1580C2.s1580c2f0");
    test_class_info(&lv, &cd_S1580C2);
    dp->~S1580C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1580C2(Test_S1580C2, "S1580C2", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN7S1580C2C1Ev();
extern void _ZN7S1580C2D1Ev();
Name_Map name_map_S1580C2[] = {
  NSPAIR(_ZN7S1580C2C1Ev),
  NSPAIR(_ZN7S1580C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1580C4;
extern VTBL_ENTRY _ZTI7S1580C4[];
extern  VTBL_ENTRY _ZTV7S1580C4[];
extern Class_Descriptor cd_S1580C3;
extern VTBL_ENTRY _ZTI7S1580C3[];
extern  VTBL_ENTRY _ZTV7S1580C3[];
static Base_Class bases_S1580C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1580C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1580C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1580C2[];
extern void _ZN7S1580C2D1Ev();
extern void _ZN7S1580C2D0Ev();
extern void _ZN7S1580C42v8Ev();
extern void _ZN7S1580C42v9Ev();
extern void _ZN7S1580C43v10Ev();
extern void _ZN7S1580C43v11Ev();
extern void _ZN7S1580C43v12Ev();
extern void _ZN7S1580C43v13Ev();
extern void _ZN7S1580C43v14Ev();
extern void _ZN7S1580C43v15Ev();
extern void _ZN7S1580C43v16Ev();
extern void _ZN7S1580C43v17Ev();
extern void _ZN7S1580C43v18Ev();
extern void _ZN7S1580C43v19Ev();
extern void _ZN7S1580C43v20Ev();
extern void _ZN7S1580C43v21Ev();
extern void _ZN7S1580C43v22Ev();
extern void _ZN7S1580C43v23Ev();
extern void _ZN7S1580C43v24Ev();
extern void _ZN7S1580C43v25Ev();
extern void _ZN7S1580C43v26Ev();
extern void _ZN7S1580C43v27Ev();
extern void _ZN7S1580C43v28Ev();
extern void _ZN7S1580C43v29Ev();
extern void _ZN7S1580C43v30Ev();
extern void _ZN7S1580C43v31Ev();
extern void _ZN7S1580C43v32Ev();
extern void _ZN7S1580C43v33Ev();
extern void _ZN7S1580C43v34Ev();
extern void _ZN7S1580C43v35Ev();
extern void _ZN7S1580C43v36Ev();
extern void _ZN7S1580C43v37Ev();
extern void _ZN7S1580C43v38Ev();
extern void _ZN7S1580C43v39Ev();
extern void _ZN7S1580C43v40Ev();
extern void _ZN7S1580C43v41Ev();
extern void _ZN7S1580C43v42Ev();
extern void _ZN7S1580C43v43Ev();
extern void _ZN7S1580C43v44Ev();
extern void _ZN7S1580C43v45Ev();
extern void _ZN7S1580C43v46Ev();
extern void _ZN7S1580C43v47Ev();
extern void _ZN7S1580C43v48Ev();
extern void _ZN7S1580C43v49Ev();
extern void _ZN7S1580C43v50Ev();
extern void _ZN7S1580C43v51Ev();
extern void _ZN7S1580C43v52Ev();
extern void _ZN7S1580C43v53Ev();
extern void _ZN7S1580C43v54Ev();
extern void _ZN7S1580C43v55Ev();
extern void _ZN7S1580C43v56Ev();
extern void _ZN7S1580C43v57Ev();
extern void _ZN7S1580C43v58Ev();
extern void _ZN7S1580C43v59Ev();
extern void _ZN7S1580C43v60Ev();
extern void _ZN7S1580C43v61Ev();
extern void _ZN7S1580C43v62Ev();
extern void _ZN7S1580C43v63Ev();
extern void _ZN7S1580C43v64Ev();
extern void _ZN7S1580C43v65Ev();
extern void _ZN7S1580C43v66Ev();
extern void _ZN7S1580C43v67Ev();
extern void _ZN7S1580C43v68Ev();
extern void _ZN7S1580C43v69Ev();
extern void _ZN7S1580C43v70Ev();
extern void _ZN7S1580C43v71Ev();
extern void _ZN7S1580C33v72Ev();
extern void _ZN7S1580C33v73Ev();
extern void _ZN7S1580C33v74Ev();
extern void _ZN7S1580C33v75Ev();
extern void _ZN7S1580C33v76Ev();
extern void _ZN7S1580C33v77Ev();
extern void _ZN7S1580C33v78Ev();
extern void _ZN7S1580C33v79Ev();
extern void _ZN7S1580C33v80Ev();
extern void _ZN7S1580C33v81Ev();
extern void _ZN7S1580C33v82Ev();
extern void _ZN7S1580C33v83Ev();
extern void _ZN7S1580C33v84Ev();
extern void _ZN7S1580C33v85Ev();
extern void _ZN7S1580C33v86Ev();
extern void _ZN7S1580C33v87Ev();
extern void _ZN7S1580C33v88Ev();
extern void _ZN7S1580C33v89Ev();
extern void _ZN7S1580C33v90Ev();
extern void _ZN7S1580C33v91Ev();
extern void _ZN7S1580C33v92Ev();
extern void _ZN7S1580C33v93Ev();
extern void _ZN7S1580C23v94Ev();
extern void _ZN7S1580C23v95Ev();
extern void _ZN7S1580C23v96Ev();
extern void _ZN7S1580C23v97Ev();
extern void _ZN7S1580C23v98Ev();
extern void _ZN7S1580C23v99Ev();
extern void _ZN7S1580C24v100Ev();
extern void _ZN7S1580C24v101Ev();
extern void _ZN7S1580C24v102Ev();
extern void _ZN7S1580C24v103Ev();
extern void _ZN7S1580C24v104Ev();
extern void _ZN7S1580C24v105Ev();
extern void _ZN7S1580C24v106Ev();
extern void _ZN7S1580C24v107Ev();
extern void _ZN7S1580C24v108Ev();
extern void _ZN7S1580C24v109Ev();
extern void _ZN7S1580C24v110Ev();
extern void _ZN7S1580C24v111Ev();
extern void _ZN7S1580C24v112Ev();
static  VTBL_ENTRY vtc_S1580C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1580C2[0]),
  (VTBL_ENTRY)&_ZN7S1580C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1580C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1580C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1580C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v112Ev,
};
extern VTBL_ENTRY _ZTI7S1580C2[];
extern  VTBL_ENTRY _ZTV7S1580C2[];
Class_Descriptor cd_S1580C2 = {  "S1580C2", // class name
  bases_S1580C2, 2,
  &(vtc_S1580C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI7S1580C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1580C2),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1580C1  : S1580C2 {
  ::S473C6_nt s1580c1f0;
  virtual  ~S1580C1(); // _ZN7S1580C1D1Ev
  virtual void  v1(); // _ZN7S1580C12v1Ev
  virtual void  v2(); // _ZN7S1580C12v2Ev
  virtual void  v3(); // _ZN7S1580C12v3Ev
  virtual void  v4(); // _ZN7S1580C12v4Ev
  virtual void  v5(); // _ZN7S1580C12v5Ev
  virtual void  v6(); // _ZN7S1580C12v6Ev
  virtual void  v7(); // _ZN7S1580C12v7Ev
  S1580C1(); // tgen
};
//SIG(1 S1580C1) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 FC5} vd v1 v2 v3 v4 v5 v6 v7 FC5}


 S1580C1 ::~S1580C1(){ note_dtor("S1580C1", this);}
void  S1580C1 ::v1(){vfunc_called(this, "_ZN7S1580C12v1Ev");}
void  S1580C1 ::v2(){vfunc_called(this, "_ZN7S1580C12v2Ev");}
void  S1580C1 ::v3(){vfunc_called(this, "_ZN7S1580C12v3Ev");}
void  S1580C1 ::v4(){vfunc_called(this, "_ZN7S1580C12v4Ev");}
void  S1580C1 ::v5(){vfunc_called(this, "_ZN7S1580C12v5Ev");}
void  S1580C1 ::v6(){vfunc_called(this, "_ZN7S1580C12v6Ev");}
void  S1580C1 ::v7(){vfunc_called(this, "_ZN7S1580C12v7Ev");}
S1580C1 ::S1580C1(){ note_ctor("S1580C1", this);} // tgen

static void Test_S1580C1()
{
  extern Class_Descriptor cd_S1580C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,38)];
    init_test(&cd_S1580C1, buf);
    S1580C1 *dp, &lv = *(dp=new (buf) S1580C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,148), "sizeof(S1580C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1580C1)");
    check_base_class_offset(lv, (S1580C4*)(S1580C3*)(S1580C2*), 0, "S1580C1");
    check_base_class_offset(lv, (S1580C3*)(S1580C2*), 0, "S1580C1");
    check_base_class_offset(lv, (S1580C2*), 0, "S1580C1");
    check_field_offset(lv, s1580c1f0, ABISELECT(196,140), "S1580C1.s1580c1f0");
    test_class_info(&lv, &cd_S1580C1);
    dp->~S1580C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1580C1(Test_S1580C1, "S1580C1", ABISELECT(208,148));

#else // __cplusplus

extern void _ZN7S1580C1C1Ev();
extern void _ZN7S1580C1D1Ev();
Name_Map name_map_S1580C1[] = {
  NSPAIR(_ZN7S1580C1C1Ev),
  NSPAIR(_ZN7S1580C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1580C4;
extern VTBL_ENTRY _ZTI7S1580C4[];
extern  VTBL_ENTRY _ZTV7S1580C4[];
extern Class_Descriptor cd_S1580C3;
extern VTBL_ENTRY _ZTI7S1580C3[];
extern  VTBL_ENTRY _ZTV7S1580C3[];
extern Class_Descriptor cd_S1580C2;
extern VTBL_ENTRY _ZTI7S1580C2[];
extern  VTBL_ENTRY _ZTV7S1580C2[];
static Base_Class bases_S1580C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1580C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1580C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1580C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1580C1[];
extern void _ZN7S1580C1D1Ev();
extern void _ZN7S1580C1D0Ev();
extern void _ZN7S1580C42v8Ev();
extern void _ZN7S1580C42v9Ev();
extern void _ZN7S1580C43v10Ev();
extern void _ZN7S1580C43v11Ev();
extern void _ZN7S1580C43v12Ev();
extern void _ZN7S1580C43v13Ev();
extern void _ZN7S1580C43v14Ev();
extern void _ZN7S1580C43v15Ev();
extern void _ZN7S1580C43v16Ev();
extern void _ZN7S1580C43v17Ev();
extern void _ZN7S1580C43v18Ev();
extern void _ZN7S1580C43v19Ev();
extern void _ZN7S1580C43v20Ev();
extern void _ZN7S1580C43v21Ev();
extern void _ZN7S1580C43v22Ev();
extern void _ZN7S1580C43v23Ev();
extern void _ZN7S1580C43v24Ev();
extern void _ZN7S1580C43v25Ev();
extern void _ZN7S1580C43v26Ev();
extern void _ZN7S1580C43v27Ev();
extern void _ZN7S1580C43v28Ev();
extern void _ZN7S1580C43v29Ev();
extern void _ZN7S1580C43v30Ev();
extern void _ZN7S1580C43v31Ev();
extern void _ZN7S1580C43v32Ev();
extern void _ZN7S1580C43v33Ev();
extern void _ZN7S1580C43v34Ev();
extern void _ZN7S1580C43v35Ev();
extern void _ZN7S1580C43v36Ev();
extern void _ZN7S1580C43v37Ev();
extern void _ZN7S1580C43v38Ev();
extern void _ZN7S1580C43v39Ev();
extern void _ZN7S1580C43v40Ev();
extern void _ZN7S1580C43v41Ev();
extern void _ZN7S1580C43v42Ev();
extern void _ZN7S1580C43v43Ev();
extern void _ZN7S1580C43v44Ev();
extern void _ZN7S1580C43v45Ev();
extern void _ZN7S1580C43v46Ev();
extern void _ZN7S1580C43v47Ev();
extern void _ZN7S1580C43v48Ev();
extern void _ZN7S1580C43v49Ev();
extern void _ZN7S1580C43v50Ev();
extern void _ZN7S1580C43v51Ev();
extern void _ZN7S1580C43v52Ev();
extern void _ZN7S1580C43v53Ev();
extern void _ZN7S1580C43v54Ev();
extern void _ZN7S1580C43v55Ev();
extern void _ZN7S1580C43v56Ev();
extern void _ZN7S1580C43v57Ev();
extern void _ZN7S1580C43v58Ev();
extern void _ZN7S1580C43v59Ev();
extern void _ZN7S1580C43v60Ev();
extern void _ZN7S1580C43v61Ev();
extern void _ZN7S1580C43v62Ev();
extern void _ZN7S1580C43v63Ev();
extern void _ZN7S1580C43v64Ev();
extern void _ZN7S1580C43v65Ev();
extern void _ZN7S1580C43v66Ev();
extern void _ZN7S1580C43v67Ev();
extern void _ZN7S1580C43v68Ev();
extern void _ZN7S1580C43v69Ev();
extern void _ZN7S1580C43v70Ev();
extern void _ZN7S1580C43v71Ev();
extern void _ZN7S1580C33v72Ev();
extern void _ZN7S1580C33v73Ev();
extern void _ZN7S1580C33v74Ev();
extern void _ZN7S1580C33v75Ev();
extern void _ZN7S1580C33v76Ev();
extern void _ZN7S1580C33v77Ev();
extern void _ZN7S1580C33v78Ev();
extern void _ZN7S1580C33v79Ev();
extern void _ZN7S1580C33v80Ev();
extern void _ZN7S1580C33v81Ev();
extern void _ZN7S1580C33v82Ev();
extern void _ZN7S1580C33v83Ev();
extern void _ZN7S1580C33v84Ev();
extern void _ZN7S1580C33v85Ev();
extern void _ZN7S1580C33v86Ev();
extern void _ZN7S1580C33v87Ev();
extern void _ZN7S1580C33v88Ev();
extern void _ZN7S1580C33v89Ev();
extern void _ZN7S1580C33v90Ev();
extern void _ZN7S1580C33v91Ev();
extern void _ZN7S1580C33v92Ev();
extern void _ZN7S1580C33v93Ev();
extern void _ZN7S1580C23v94Ev();
extern void _ZN7S1580C23v95Ev();
extern void _ZN7S1580C23v96Ev();
extern void _ZN7S1580C23v97Ev();
extern void _ZN7S1580C23v98Ev();
extern void _ZN7S1580C23v99Ev();
extern void _ZN7S1580C24v100Ev();
extern void _ZN7S1580C24v101Ev();
extern void _ZN7S1580C24v102Ev();
extern void _ZN7S1580C24v103Ev();
extern void _ZN7S1580C24v104Ev();
extern void _ZN7S1580C24v105Ev();
extern void _ZN7S1580C24v106Ev();
extern void _ZN7S1580C24v107Ev();
extern void _ZN7S1580C24v108Ev();
extern void _ZN7S1580C24v109Ev();
extern void _ZN7S1580C24v110Ev();
extern void _ZN7S1580C24v111Ev();
extern void _ZN7S1580C24v112Ev();
extern void _ZN7S1580C12v1Ev();
extern void _ZN7S1580C12v2Ev();
extern void _ZN7S1580C12v3Ev();
extern void _ZN7S1580C12v4Ev();
extern void _ZN7S1580C12v5Ev();
extern void _ZN7S1580C12v6Ev();
extern void _ZN7S1580C12v7Ev();
static  VTBL_ENTRY vtc_S1580C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1580C1[0]),
  (VTBL_ENTRY)&_ZN7S1580C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1580C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1580C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1580C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1580C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1580C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1580C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1580C24v112Ev,
  (VTBL_ENTRY)&_ZN7S1580C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1580C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1580C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1580C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1580C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1580C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1580C12v7Ev,
};
extern VTBL_ENTRY _ZTI7S1580C1[];
extern  VTBL_ENTRY _ZTV7S1580C1[];
Class_Descriptor cd_S1580C1 = {  "S1580C1", // class name
  bases_S1580C1, 3,
  &(vtc_S1580C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(208,148), // object size
  NSPAIRA(_ZTI7S1580C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1580C1),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1581C4  {
  int s1581c4f0;
  __tsi64 s1581c4f1;
  void *s1581c4f2[4];
  int s1581c4f3[2];
  void *s1581c4f4;
  ::S473C6_nt s1581c4f5;
  void *s1581c4f6[2];
  virtual  ~S1581C4(); // _ZN7S1581C4D1Ev
  virtual void  v8(); // _ZN7S1581C42v8Ev
  virtual void  v9(); // _ZN7S1581C42v9Ev
  virtual void  v10(); // _ZN7S1581C43v10Ev
  virtual void  v11(); // _ZN7S1581C43v11Ev
  virtual void  v12(); // _ZN7S1581C43v12Ev
  virtual void  v13(); // _ZN7S1581C43v13Ev
  virtual void  v14(); // _ZN7S1581C43v14Ev
  virtual void  v15(); // _ZN7S1581C43v15Ev
  virtual void  v16(); // _ZN7S1581C43v16Ev
  virtual void  v17(); // _ZN7S1581C43v17Ev
  virtual void  v18(); // _ZN7S1581C43v18Ev
  virtual void  v19(); // _ZN7S1581C43v19Ev
  virtual void  v20(); // _ZN7S1581C43v20Ev
  virtual void  v21(); // _ZN7S1581C43v21Ev
  virtual void  v22(); // _ZN7S1581C43v22Ev
  virtual void  v23(); // _ZN7S1581C43v23Ev
  virtual void  v24(); // _ZN7S1581C43v24Ev
  virtual void  v25(); // _ZN7S1581C43v25Ev
  virtual void  v26(); // _ZN7S1581C43v26Ev
  virtual void  v27(); // _ZN7S1581C43v27Ev
  virtual void  v28(); // _ZN7S1581C43v28Ev
  virtual void  v29(); // _ZN7S1581C43v29Ev
  virtual void  v30(); // _ZN7S1581C43v30Ev
  virtual void  v31(); // _ZN7S1581C43v31Ev
  virtual void  v32(); // _ZN7S1581C43v32Ev
  virtual void  v33(); // _ZN7S1581C43v33Ev
  virtual void  v34(); // _ZN7S1581C43v34Ev
  virtual void  v35(); // _ZN7S1581C43v35Ev
  virtual void  v36(); // _ZN7S1581C43v36Ev
  virtual void  v37(); // _ZN7S1581C43v37Ev
  virtual void  v38(); // _ZN7S1581C43v38Ev
  virtual void  v39(); // _ZN7S1581C43v39Ev
  virtual void  v40(); // _ZN7S1581C43v40Ev
  virtual void  v41(); // _ZN7S1581C43v41Ev
  virtual void  v42(); // _ZN7S1581C43v42Ev
  virtual void  v43(); // _ZN7S1581C43v43Ev
  virtual void  v44(); // _ZN7S1581C43v44Ev
  virtual void  v45(); // _ZN7S1581C43v45Ev
  virtual void  v46(); // _ZN7S1581C43v46Ev
  virtual void  v47(); // _ZN7S1581C43v47Ev
  virtual void  v48(); // _ZN7S1581C43v48Ev
  virtual void  v49(); // _ZN7S1581C43v49Ev
  virtual void  v50(); // _ZN7S1581C43v50Ev
  virtual void  v51(); // _ZN7S1581C43v51Ev
  virtual void  v52(); // _ZN7S1581C43v52Ev
  virtual void  v53(); // _ZN7S1581C43v53Ev
  virtual void  v54(); // _ZN7S1581C43v54Ev
  virtual void  v55(); // _ZN7S1581C43v55Ev
  virtual void  v56(); // _ZN7S1581C43v56Ev
  virtual void  v57(); // _ZN7S1581C43v57Ev
  virtual void  v58(); // _ZN7S1581C43v58Ev
  virtual void  v59(); // _ZN7S1581C43v59Ev
  virtual void  v60(); // _ZN7S1581C43v60Ev
  virtual void  v61(); // _ZN7S1581C43v61Ev
  virtual void  v62(); // _ZN7S1581C43v62Ev
  virtual void  v63(); // _ZN7S1581C43v63Ev
  virtual void  v64(); // _ZN7S1581C43v64Ev
  virtual void  v65(); // _ZN7S1581C43v65Ev
  virtual void  v66(); // _ZN7S1581C43v66Ev
  virtual void  v67(); // _ZN7S1581C43v67Ev
  virtual void  v68(); // _ZN7S1581C43v68Ev
  virtual void  v69(); // _ZN7S1581C43v69Ev
  virtual void  v70(); // _ZN7S1581C43v70Ev
  virtual void  v71(); // _ZN7S1581C43v71Ev
  S1581C4(); // tgen
};
//SIG(-1 S1581C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1581C4 ::~S1581C4(){ note_dtor("S1581C4", this);}
void  S1581C4 ::v8(){vfunc_called(this, "_ZN7S1581C42v8Ev");}
void  S1581C4 ::v9(){vfunc_called(this, "_ZN7S1581C42v9Ev");}
void  S1581C4 ::v10(){vfunc_called(this, "_ZN7S1581C43v10Ev");}
void  S1581C4 ::v11(){vfunc_called(this, "_ZN7S1581C43v11Ev");}
void  S1581C4 ::v12(){vfunc_called(this, "_ZN7S1581C43v12Ev");}
void  S1581C4 ::v13(){vfunc_called(this, "_ZN7S1581C43v13Ev");}
void  S1581C4 ::v14(){vfunc_called(this, "_ZN7S1581C43v14Ev");}
void  S1581C4 ::v15(){vfunc_called(this, "_ZN7S1581C43v15Ev");}
void  S1581C4 ::v16(){vfunc_called(this, "_ZN7S1581C43v16Ev");}
void  S1581C4 ::v17(){vfunc_called(this, "_ZN7S1581C43v17Ev");}
void  S1581C4 ::v18(){vfunc_called(this, "_ZN7S1581C43v18Ev");}
void  S1581C4 ::v19(){vfunc_called(this, "_ZN7S1581C43v19Ev");}
void  S1581C4 ::v20(){vfunc_called(this, "_ZN7S1581C43v20Ev");}
void  S1581C4 ::v21(){vfunc_called(this, "_ZN7S1581C43v21Ev");}
void  S1581C4 ::v22(){vfunc_called(this, "_ZN7S1581C43v22Ev");}
void  S1581C4 ::v23(){vfunc_called(this, "_ZN7S1581C43v23Ev");}
void  S1581C4 ::v24(){vfunc_called(this, "_ZN7S1581C43v24Ev");}
void  S1581C4 ::v25(){vfunc_called(this, "_ZN7S1581C43v25Ev");}
void  S1581C4 ::v26(){vfunc_called(this, "_ZN7S1581C43v26Ev");}
void  S1581C4 ::v27(){vfunc_called(this, "_ZN7S1581C43v27Ev");}
void  S1581C4 ::v28(){vfunc_called(this, "_ZN7S1581C43v28Ev");}
void  S1581C4 ::v29(){vfunc_called(this, "_ZN7S1581C43v29Ev");}
void  S1581C4 ::v30(){vfunc_called(this, "_ZN7S1581C43v30Ev");}
void  S1581C4 ::v31(){vfunc_called(this, "_ZN7S1581C43v31Ev");}
void  S1581C4 ::v32(){vfunc_called(this, "_ZN7S1581C43v32Ev");}
void  S1581C4 ::v33(){vfunc_called(this, "_ZN7S1581C43v33Ev");}
void  S1581C4 ::v34(){vfunc_called(this, "_ZN7S1581C43v34Ev");}
void  S1581C4 ::v35(){vfunc_called(this, "_ZN7S1581C43v35Ev");}
void  S1581C4 ::v36(){vfunc_called(this, "_ZN7S1581C43v36Ev");}
void  S1581C4 ::v37(){vfunc_called(this, "_ZN7S1581C43v37Ev");}
void  S1581C4 ::v38(){vfunc_called(this, "_ZN7S1581C43v38Ev");}
void  S1581C4 ::v39(){vfunc_called(this, "_ZN7S1581C43v39Ev");}
void  S1581C4 ::v40(){vfunc_called(this, "_ZN7S1581C43v40Ev");}
void  S1581C4 ::v41(){vfunc_called(this, "_ZN7S1581C43v41Ev");}
void  S1581C4 ::v42(){vfunc_called(this, "_ZN7S1581C43v42Ev");}
void  S1581C4 ::v43(){vfunc_called(this, "_ZN7S1581C43v43Ev");}
void  S1581C4 ::v44(){vfunc_called(this, "_ZN7S1581C43v44Ev");}
void  S1581C4 ::v45(){vfunc_called(this, "_ZN7S1581C43v45Ev");}
void  S1581C4 ::v46(){vfunc_called(this, "_ZN7S1581C43v46Ev");}
void  S1581C4 ::v47(){vfunc_called(this, "_ZN7S1581C43v47Ev");}
void  S1581C4 ::v48(){vfunc_called(this, "_ZN7S1581C43v48Ev");}
void  S1581C4 ::v49(){vfunc_called(this, "_ZN7S1581C43v49Ev");}
void  S1581C4 ::v50(){vfunc_called(this, "_ZN7S1581C43v50Ev");}
void  S1581C4 ::v51(){vfunc_called(this, "_ZN7S1581C43v51Ev");}
void  S1581C4 ::v52(){vfunc_called(this, "_ZN7S1581C43v52Ev");}
void  S1581C4 ::v53(){vfunc_called(this, "_ZN7S1581C43v53Ev");}
void  S1581C4 ::v54(){vfunc_called(this, "_ZN7S1581C43v54Ev");}
void  S1581C4 ::v55(){vfunc_called(this, "_ZN7S1581C43v55Ev");}
void  S1581C4 ::v56(){vfunc_called(this, "_ZN7S1581C43v56Ev");}
void  S1581C4 ::v57(){vfunc_called(this, "_ZN7S1581C43v57Ev");}
void  S1581C4 ::v58(){vfunc_called(this, "_ZN7S1581C43v58Ev");}
void  S1581C4 ::v59(){vfunc_called(this, "_ZN7S1581C43v59Ev");}
void  S1581C4 ::v60(){vfunc_called(this, "_ZN7S1581C43v60Ev");}
void  S1581C4 ::v61(){vfunc_called(this, "_ZN7S1581C43v61Ev");}
void  S1581C4 ::v62(){vfunc_called(this, "_ZN7S1581C43v62Ev");}
void  S1581C4 ::v63(){vfunc_called(this, "_ZN7S1581C43v63Ev");}
void  S1581C4 ::v64(){vfunc_called(this, "_ZN7S1581C43v64Ev");}
void  S1581C4 ::v65(){vfunc_called(this, "_ZN7S1581C43v65Ev");}
void  S1581C4 ::v66(){vfunc_called(this, "_ZN7S1581C43v66Ev");}
void  S1581C4 ::v67(){vfunc_called(this, "_ZN7S1581C43v67Ev");}
void  S1581C4 ::v68(){vfunc_called(this, "_ZN7S1581C43v68Ev");}
void  S1581C4 ::v69(){vfunc_called(this, "_ZN7S1581C43v69Ev");}
void  S1581C4 ::v70(){vfunc_called(this, "_ZN7S1581C43v70Ev");}
void  S1581C4 ::v71(){vfunc_called(this, "_ZN7S1581C43v71Ev");}
S1581C4 ::S1581C4(){ note_ctor("S1581C4", this);} // tgen

static void Test_S1581C4()
{
  extern Class_Descriptor cd_S1581C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1581C4, buf);
    S1581C4 *dp, &lv = *(dp=new (buf) S1581C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1581C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1581C4)");
    check_field_offset(lv, s1581c4f0, ABISELECT(8,4), "S1581C4.s1581c4f0");
    check_field_offset(lv, s1581c4f1, ABISELECT(16,8), "S1581C4.s1581c4f1");
    check_field_offset(lv, s1581c4f2, ABISELECT(24,16), "S1581C4.s1581c4f2");
    check_field_offset(lv, s1581c4f3, ABISELECT(56,32), "S1581C4.s1581c4f3");
    check_field_offset(lv, s1581c4f4, ABISELECT(64,40), "S1581C4.s1581c4f4");
    check_field_offset(lv, s1581c4f5, ABISELECT(72,44), "S1581C4.s1581c4f5");
    check_field_offset(lv, s1581c4f6, ABISELECT(80,52), "S1581C4.s1581c4f6");
    test_class_info(&lv, &cd_S1581C4);
    dp->~S1581C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1581C4(Test_S1581C4, "S1581C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1581C4C1Ev();
extern void _ZN7S1581C4D1Ev();
Name_Map name_map_S1581C4[] = {
  NSPAIR(_ZN7S1581C4C1Ev),
  NSPAIR(_ZN7S1581C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1581C4[];
extern void _ZN7S1581C4D1Ev();
extern void _ZN7S1581C4D0Ev();
extern void _ZN7S1581C42v8Ev();
extern void _ZN7S1581C42v9Ev();
extern void _ZN7S1581C43v10Ev();
extern void _ZN7S1581C43v11Ev();
extern void _ZN7S1581C43v12Ev();
extern void _ZN7S1581C43v13Ev();
extern void _ZN7S1581C43v14Ev();
extern void _ZN7S1581C43v15Ev();
extern void _ZN7S1581C43v16Ev();
extern void _ZN7S1581C43v17Ev();
extern void _ZN7S1581C43v18Ev();
extern void _ZN7S1581C43v19Ev();
extern void _ZN7S1581C43v20Ev();
extern void _ZN7S1581C43v21Ev();
extern void _ZN7S1581C43v22Ev();
extern void _ZN7S1581C43v23Ev();
extern void _ZN7S1581C43v24Ev();
extern void _ZN7S1581C43v25Ev();
extern void _ZN7S1581C43v26Ev();
extern void _ZN7S1581C43v27Ev();
extern void _ZN7S1581C43v28Ev();
extern void _ZN7S1581C43v29Ev();
extern void _ZN7S1581C43v30Ev();
extern void _ZN7S1581C43v31Ev();
extern void _ZN7S1581C43v32Ev();
extern void _ZN7S1581C43v33Ev();
extern void _ZN7S1581C43v34Ev();
extern void _ZN7S1581C43v35Ev();
extern void _ZN7S1581C43v36Ev();
extern void _ZN7S1581C43v37Ev();
extern void _ZN7S1581C43v38Ev();
extern void _ZN7S1581C43v39Ev();
extern void _ZN7S1581C43v40Ev();
extern void _ZN7S1581C43v41Ev();
extern void _ZN7S1581C43v42Ev();
extern void _ZN7S1581C43v43Ev();
extern void _ZN7S1581C43v44Ev();
extern void _ZN7S1581C43v45Ev();
extern void _ZN7S1581C43v46Ev();
extern void _ZN7S1581C43v47Ev();
extern void _ZN7S1581C43v48Ev();
extern void _ZN7S1581C43v49Ev();
extern void _ZN7S1581C43v50Ev();
extern void _ZN7S1581C43v51Ev();
extern void _ZN7S1581C43v52Ev();
extern void _ZN7S1581C43v53Ev();
extern void _ZN7S1581C43v54Ev();
extern void _ZN7S1581C43v55Ev();
extern void _ZN7S1581C43v56Ev();
extern void _ZN7S1581C43v57Ev();
extern void _ZN7S1581C43v58Ev();
extern void _ZN7S1581C43v59Ev();
extern void _ZN7S1581C43v60Ev();
extern void _ZN7S1581C43v61Ev();
extern void _ZN7S1581C43v62Ev();
extern void _ZN7S1581C43v63Ev();
extern void _ZN7S1581C43v64Ev();
extern void _ZN7S1581C43v65Ev();
extern void _ZN7S1581C43v66Ev();
extern void _ZN7S1581C43v67Ev();
extern void _ZN7S1581C43v68Ev();
extern void _ZN7S1581C43v69Ev();
extern void _ZN7S1581C43v70Ev();
extern void _ZN7S1581C43v71Ev();
static  VTBL_ENTRY vtc_S1581C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1581C4[0]),
  (VTBL_ENTRY)&_ZN7S1581C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1581C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1581C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1581C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v71Ev,
};
extern VTBL_ENTRY _ZTI7S1581C4[];
extern  VTBL_ENTRY _ZTV7S1581C4[];
Class_Descriptor cd_S1581C4 = {  "S1581C4", // class name
  0,0,//no base classes
  &(vtc_S1581C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1581C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1581C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1581C3  : S1581C4 {
  int s1581c3f0[2];
  void *s1581c3f1;
  int s1581c3f2[2];
  ::S473C7_nt s1581c3f3;
  ::S473C7_nt s1581c3f4;
  ::S21925C42 s1581c3f5;
  ::S473C7_nt s1581c3f6;
  unsigned int s1581c3f7:1;
  unsigned int s1581c3f8:1;
  unsigned int s1581c3f9:1;
  unsigned int s1581c3f10:1;
  unsigned int s1581c3f11:1;
  int s1581c3f12[2];
  virtual  ~S1581C3(); // _ZN7S1581C3D1Ev
  virtual void  v72(); // _ZN7S1581C33v72Ev
  virtual void  v73(); // _ZN7S1581C33v73Ev
  virtual void  v74(); // _ZN7S1581C33v74Ev
  virtual void  v75(); // _ZN7S1581C33v75Ev
  virtual void  v76(); // _ZN7S1581C33v76Ev
  virtual void  v77(); // _ZN7S1581C33v77Ev
  virtual void  v78(); // _ZN7S1581C33v78Ev
  virtual void  v79(); // _ZN7S1581C33v79Ev
  virtual void  v80(); // _ZN7S1581C33v80Ev
  virtual void  v81(); // _ZN7S1581C33v81Ev
  virtual void  v82(); // _ZN7S1581C33v82Ev
  virtual void  v83(); // _ZN7S1581C33v83Ev
  virtual void  v84(); // _ZN7S1581C33v84Ev
  virtual void  v85(); // _ZN7S1581C33v85Ev
  virtual void  v86(); // _ZN7S1581C33v86Ev
  virtual void  v87(); // _ZN7S1581C33v87Ev
  virtual void  v88(); // _ZN7S1581C33v88Ev
  virtual void  v89(); // _ZN7S1581C33v89Ev
  virtual void  v90(); // _ZN7S1581C33v90Ev
  virtual void  v91(); // _ZN7S1581C33v91Ev
  virtual void  v92(); // _ZN7S1581C33v92Ev
  virtual void  v93(); // _ZN7S1581C33v93Ev
  S1581C3(); // tgen
};
//SIG(-1 S1581C3) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S1581C3 ::~S1581C3(){ note_dtor("S1581C3", this);}
void  S1581C3 ::v72(){vfunc_called(this, "_ZN7S1581C33v72Ev");}
void  S1581C3 ::v73(){vfunc_called(this, "_ZN7S1581C33v73Ev");}
void  S1581C3 ::v74(){vfunc_called(this, "_ZN7S1581C33v74Ev");}
void  S1581C3 ::v75(){vfunc_called(this, "_ZN7S1581C33v75Ev");}
void  S1581C3 ::v76(){vfunc_called(this, "_ZN7S1581C33v76Ev");}
void  S1581C3 ::v77(){vfunc_called(this, "_ZN7S1581C33v77Ev");}
void  S1581C3 ::v78(){vfunc_called(this, "_ZN7S1581C33v78Ev");}
void  S1581C3 ::v79(){vfunc_called(this, "_ZN7S1581C33v79Ev");}
void  S1581C3 ::v80(){vfunc_called(this, "_ZN7S1581C33v80Ev");}
void  S1581C3 ::v81(){vfunc_called(this, "_ZN7S1581C33v81Ev");}
void  S1581C3 ::v82(){vfunc_called(this, "_ZN7S1581C33v82Ev");}
void  S1581C3 ::v83(){vfunc_called(this, "_ZN7S1581C33v83Ev");}
void  S1581C3 ::v84(){vfunc_called(this, "_ZN7S1581C33v84Ev");}
void  S1581C3 ::v85(){vfunc_called(this, "_ZN7S1581C33v85Ev");}
void  S1581C3 ::v86(){vfunc_called(this, "_ZN7S1581C33v86Ev");}
void  S1581C3 ::v87(){vfunc_called(this, "_ZN7S1581C33v87Ev");}
void  S1581C3 ::v88(){vfunc_called(this, "_ZN7S1581C33v88Ev");}
void  S1581C3 ::v89(){vfunc_called(this, "_ZN7S1581C33v89Ev");}
void  S1581C3 ::v90(){vfunc_called(this, "_ZN7S1581C33v90Ev");}
void  S1581C3 ::v91(){vfunc_called(this, "_ZN7S1581C33v91Ev");}
void  S1581C3 ::v92(){vfunc_called(this, "_ZN7S1581C33v92Ev");}
void  S1581C3 ::v93(){vfunc_called(this, "_ZN7S1581C33v93Ev");}
S1581C3 ::S1581C3(){ note_ctor("S1581C3", this);} // tgen

static void Test_S1581C3()
{
  extern Class_Descriptor cd_S1581C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S1581C3, buf);
    S1581C3 *dp, &lv = *(dp=new (buf) S1581C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S1581C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1581C3)");
    check_base_class_offset(lv, (S1581C4*), 0, "S1581C3");
    check_field_offset(lv, s1581c3f0, ABISELECT(96,60), "S1581C3.s1581c3f0");
    check_field_offset(lv, s1581c3f1, ABISELECT(104,68), "S1581C3.s1581c3f1");
    check_field_offset(lv, s1581c3f2, ABISELECT(112,72), "S1581C3.s1581c3f2");
    check_field_offset(lv, s1581c3f3, ABISELECT(120,80), "S1581C3.s1581c3f3");
    check_field_offset(lv, s1581c3f4, ABISELECT(136,92), "S1581C3.s1581c3f4");
    check_field_offset(lv, s1581c3f5, ABISELECT(152,104), "S1581C3.s1581c3f5");
    check_field_offset(lv, s1581c3f6, ABISELECT(160,108), "S1581C3.s1581c3f6");
    set_bf_and_test(lv, s1581c3f7, ABISELECT(176,120), 0, 1, 1, "S1581C3");
    set_bf_and_test(lv, s1581c3f8, ABISELECT(176,120), 1, 1, 1, "S1581C3");
    set_bf_and_test(lv, s1581c3f9, ABISELECT(176,120), 2, 1, 1, "S1581C3");
    set_bf_and_test(lv, s1581c3f10, ABISELECT(176,120), 3, 1, 1, "S1581C3");
    set_bf_and_test(lv, s1581c3f11, ABISELECT(176,120), 4, 1, 1, "S1581C3");
    check_field_offset(lv, s1581c3f12, ABISELECT(180,124), "S1581C3.s1581c3f12");
    test_class_info(&lv, &cd_S1581C3);
    dp->~S1581C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1581C3(Test_S1581C3, "S1581C3", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN7S1581C3C1Ev();
extern void _ZN7S1581C3D1Ev();
Name_Map name_map_S1581C3[] = {
  NSPAIR(_ZN7S1581C3C1Ev),
  NSPAIR(_ZN7S1581C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1581C4;
extern VTBL_ENTRY _ZTI7S1581C4[];
extern  VTBL_ENTRY _ZTV7S1581C4[];
static Base_Class bases_S1581C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1581C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1581C3[];
extern void _ZN7S1581C3D1Ev();
extern void _ZN7S1581C3D0Ev();
extern void _ZN7S1581C42v8Ev();
extern void _ZN7S1581C42v9Ev();
extern void _ZN7S1581C43v10Ev();
extern void _ZN7S1581C43v11Ev();
extern void _ZN7S1581C43v12Ev();
extern void _ZN7S1581C43v13Ev();
extern void _ZN7S1581C43v14Ev();
extern void _ZN7S1581C43v15Ev();
extern void _ZN7S1581C43v16Ev();
extern void _ZN7S1581C43v17Ev();
extern void _ZN7S1581C43v18Ev();
extern void _ZN7S1581C43v19Ev();
extern void _ZN7S1581C43v20Ev();
extern void _ZN7S1581C43v21Ev();
extern void _ZN7S1581C43v22Ev();
extern void _ZN7S1581C43v23Ev();
extern void _ZN7S1581C43v24Ev();
extern void _ZN7S1581C43v25Ev();
extern void _ZN7S1581C43v26Ev();
extern void _ZN7S1581C43v27Ev();
extern void _ZN7S1581C43v28Ev();
extern void _ZN7S1581C43v29Ev();
extern void _ZN7S1581C43v30Ev();
extern void _ZN7S1581C43v31Ev();
extern void _ZN7S1581C43v32Ev();
extern void _ZN7S1581C43v33Ev();
extern void _ZN7S1581C43v34Ev();
extern void _ZN7S1581C43v35Ev();
extern void _ZN7S1581C43v36Ev();
extern void _ZN7S1581C43v37Ev();
extern void _ZN7S1581C43v38Ev();
extern void _ZN7S1581C43v39Ev();
extern void _ZN7S1581C43v40Ev();
extern void _ZN7S1581C43v41Ev();
extern void _ZN7S1581C43v42Ev();
extern void _ZN7S1581C43v43Ev();
extern void _ZN7S1581C43v44Ev();
extern void _ZN7S1581C43v45Ev();
extern void _ZN7S1581C43v46Ev();
extern void _ZN7S1581C43v47Ev();
extern void _ZN7S1581C43v48Ev();
extern void _ZN7S1581C43v49Ev();
extern void _ZN7S1581C43v50Ev();
extern void _ZN7S1581C43v51Ev();
extern void _ZN7S1581C43v52Ev();
extern void _ZN7S1581C43v53Ev();
extern void _ZN7S1581C43v54Ev();
extern void _ZN7S1581C43v55Ev();
extern void _ZN7S1581C43v56Ev();
extern void _ZN7S1581C43v57Ev();
extern void _ZN7S1581C43v58Ev();
extern void _ZN7S1581C43v59Ev();
extern void _ZN7S1581C43v60Ev();
extern void _ZN7S1581C43v61Ev();
extern void _ZN7S1581C43v62Ev();
extern void _ZN7S1581C43v63Ev();
extern void _ZN7S1581C43v64Ev();
extern void _ZN7S1581C43v65Ev();
extern void _ZN7S1581C43v66Ev();
extern void _ZN7S1581C43v67Ev();
extern void _ZN7S1581C43v68Ev();
extern void _ZN7S1581C43v69Ev();
extern void _ZN7S1581C43v70Ev();
extern void _ZN7S1581C43v71Ev();
extern void _ZN7S1581C33v72Ev();
extern void _ZN7S1581C33v73Ev();
extern void _ZN7S1581C33v74Ev();
extern void _ZN7S1581C33v75Ev();
extern void _ZN7S1581C33v76Ev();
extern void _ZN7S1581C33v77Ev();
extern void _ZN7S1581C33v78Ev();
extern void _ZN7S1581C33v79Ev();
extern void _ZN7S1581C33v80Ev();
extern void _ZN7S1581C33v81Ev();
extern void _ZN7S1581C33v82Ev();
extern void _ZN7S1581C33v83Ev();
extern void _ZN7S1581C33v84Ev();
extern void _ZN7S1581C33v85Ev();
extern void _ZN7S1581C33v86Ev();
extern void _ZN7S1581C33v87Ev();
extern void _ZN7S1581C33v88Ev();
extern void _ZN7S1581C33v89Ev();
extern void _ZN7S1581C33v90Ev();
extern void _ZN7S1581C33v91Ev();
extern void _ZN7S1581C33v92Ev();
extern void _ZN7S1581C33v93Ev();
static  VTBL_ENTRY vtc_S1581C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1581C3[0]),
  (VTBL_ENTRY)&_ZN7S1581C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1581C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1581C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1581C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v93Ev,
};
extern VTBL_ENTRY _ZTI7S1581C3[];
extern  VTBL_ENTRY _ZTV7S1581C3[];
Class_Descriptor cd_S1581C3 = {  "S1581C3", // class name
  bases_S1581C3, 1,
  &(vtc_S1581C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI7S1581C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1581C3),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1581C2  : S1581C3 {
  ::S473C6_nt s1581c2f0;
  virtual  ~S1581C2(); // _ZN7S1581C2D1Ev
  virtual void  v94(); // _ZN7S1581C23v94Ev
  virtual void  v95(); // _ZN7S1581C23v95Ev
  virtual void  v96(); // _ZN7S1581C23v96Ev
  virtual void  v97(); // _ZN7S1581C23v97Ev
  virtual void  v98(); // _ZN7S1581C23v98Ev
  virtual void  v99(); // _ZN7S1581C23v99Ev
  virtual void  v100(); // _ZN7S1581C24v100Ev
  virtual void  v101(); // _ZN7S1581C24v101Ev
  virtual void  v102(); // _ZN7S1581C24v102Ev
  virtual void  v103(); // _ZN7S1581C24v103Ev
  virtual void  v104(); // _ZN7S1581C24v104Ev
  virtual void  v105(); // _ZN7S1581C24v105Ev
  virtual void  v106(); // _ZN7S1581C24v106Ev
  virtual void  v107(); // _ZN7S1581C24v107Ev
  virtual void  v108(); // _ZN7S1581C24v108Ev
  virtual void  v109(); // _ZN7S1581C24v109Ev
  virtual void  v110(); // _ZN7S1581C24v110Ev
  virtual void  v111(); // _ZN7S1581C24v111Ev
  virtual void  v112(); // _ZN7S1581C24v112Ev
  S1581C2(); // tgen
};
//SIG(-1 S1581C2) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S1581C2 ::~S1581C2(){ note_dtor("S1581C2", this);}
void  S1581C2 ::v94(){vfunc_called(this, "_ZN7S1581C23v94Ev");}
void  S1581C2 ::v95(){vfunc_called(this, "_ZN7S1581C23v95Ev");}
void  S1581C2 ::v96(){vfunc_called(this, "_ZN7S1581C23v96Ev");}
void  S1581C2 ::v97(){vfunc_called(this, "_ZN7S1581C23v97Ev");}
void  S1581C2 ::v98(){vfunc_called(this, "_ZN7S1581C23v98Ev");}
void  S1581C2 ::v99(){vfunc_called(this, "_ZN7S1581C23v99Ev");}
void  S1581C2 ::v100(){vfunc_called(this, "_ZN7S1581C24v100Ev");}
void  S1581C2 ::v101(){vfunc_called(this, "_ZN7S1581C24v101Ev");}
void  S1581C2 ::v102(){vfunc_called(this, "_ZN7S1581C24v102Ev");}
void  S1581C2 ::v103(){vfunc_called(this, "_ZN7S1581C24v103Ev");}
void  S1581C2 ::v104(){vfunc_called(this, "_ZN7S1581C24v104Ev");}
void  S1581C2 ::v105(){vfunc_called(this, "_ZN7S1581C24v105Ev");}
void  S1581C2 ::v106(){vfunc_called(this, "_ZN7S1581C24v106Ev");}
void  S1581C2 ::v107(){vfunc_called(this, "_ZN7S1581C24v107Ev");}
void  S1581C2 ::v108(){vfunc_called(this, "_ZN7S1581C24v108Ev");}
void  S1581C2 ::v109(){vfunc_called(this, "_ZN7S1581C24v109Ev");}
void  S1581C2 ::v110(){vfunc_called(this, "_ZN7S1581C24v110Ev");}
void  S1581C2 ::v111(){vfunc_called(this, "_ZN7S1581C24v111Ev");}
void  S1581C2 ::v112(){vfunc_called(this, "_ZN7S1581C24v112Ev");}
S1581C2 ::S1581C2(){ note_ctor("S1581C2", this);} // tgen

static void Test_S1581C2()
{
  extern Class_Descriptor cd_S1581C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S1581C2, buf);
    S1581C2 *dp, &lv = *(dp=new (buf) S1581C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S1581C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1581C2)");
    check_base_class_offset(lv, (S1581C4*)(S1581C3*), 0, "S1581C2");
    check_base_class_offset(lv, (S1581C3*), 0, "S1581C2");
    check_field_offset(lv, s1581c2f0, ABISELECT(188,132), "S1581C2.s1581c2f0");
    test_class_info(&lv, &cd_S1581C2);
    dp->~S1581C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1581C2(Test_S1581C2, "S1581C2", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN7S1581C2C1Ev();
extern void _ZN7S1581C2D1Ev();
Name_Map name_map_S1581C2[] = {
  NSPAIR(_ZN7S1581C2C1Ev),
  NSPAIR(_ZN7S1581C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1581C4;
extern VTBL_ENTRY _ZTI7S1581C4[];
extern  VTBL_ENTRY _ZTV7S1581C4[];
extern Class_Descriptor cd_S1581C3;
extern VTBL_ENTRY _ZTI7S1581C3[];
extern  VTBL_ENTRY _ZTV7S1581C3[];
static Base_Class bases_S1581C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1581C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1581C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1581C2[];
extern void _ZN7S1581C2D1Ev();
extern void _ZN7S1581C2D0Ev();
extern void _ZN7S1581C42v8Ev();
extern void _ZN7S1581C42v9Ev();
extern void _ZN7S1581C43v10Ev();
extern void _ZN7S1581C43v11Ev();
extern void _ZN7S1581C43v12Ev();
extern void _ZN7S1581C43v13Ev();
extern void _ZN7S1581C43v14Ev();
extern void _ZN7S1581C43v15Ev();
extern void _ZN7S1581C43v16Ev();
extern void _ZN7S1581C43v17Ev();
extern void _ZN7S1581C43v18Ev();
extern void _ZN7S1581C43v19Ev();
extern void _ZN7S1581C43v20Ev();
extern void _ZN7S1581C43v21Ev();
extern void _ZN7S1581C43v22Ev();
extern void _ZN7S1581C43v23Ev();
extern void _ZN7S1581C43v24Ev();
extern void _ZN7S1581C43v25Ev();
extern void _ZN7S1581C43v26Ev();
extern void _ZN7S1581C43v27Ev();
extern void _ZN7S1581C43v28Ev();
extern void _ZN7S1581C43v29Ev();
extern void _ZN7S1581C43v30Ev();
extern void _ZN7S1581C43v31Ev();
extern void _ZN7S1581C43v32Ev();
extern void _ZN7S1581C43v33Ev();
extern void _ZN7S1581C43v34Ev();
extern void _ZN7S1581C43v35Ev();
extern void _ZN7S1581C43v36Ev();
extern void _ZN7S1581C43v37Ev();
extern void _ZN7S1581C43v38Ev();
extern void _ZN7S1581C43v39Ev();
extern void _ZN7S1581C43v40Ev();
extern void _ZN7S1581C43v41Ev();
extern void _ZN7S1581C43v42Ev();
extern void _ZN7S1581C43v43Ev();
extern void _ZN7S1581C43v44Ev();
extern void _ZN7S1581C43v45Ev();
extern void _ZN7S1581C43v46Ev();
extern void _ZN7S1581C43v47Ev();
extern void _ZN7S1581C43v48Ev();
extern void _ZN7S1581C43v49Ev();
extern void _ZN7S1581C43v50Ev();
extern void _ZN7S1581C43v51Ev();
extern void _ZN7S1581C43v52Ev();
extern void _ZN7S1581C43v53Ev();
extern void _ZN7S1581C43v54Ev();
extern void _ZN7S1581C43v55Ev();
extern void _ZN7S1581C43v56Ev();
extern void _ZN7S1581C43v57Ev();
extern void _ZN7S1581C43v58Ev();
extern void _ZN7S1581C43v59Ev();
extern void _ZN7S1581C43v60Ev();
extern void _ZN7S1581C43v61Ev();
extern void _ZN7S1581C43v62Ev();
extern void _ZN7S1581C43v63Ev();
extern void _ZN7S1581C43v64Ev();
extern void _ZN7S1581C43v65Ev();
extern void _ZN7S1581C43v66Ev();
extern void _ZN7S1581C43v67Ev();
extern void _ZN7S1581C43v68Ev();
extern void _ZN7S1581C43v69Ev();
extern void _ZN7S1581C43v70Ev();
extern void _ZN7S1581C43v71Ev();
extern void _ZN7S1581C33v72Ev();
extern void _ZN7S1581C33v73Ev();
extern void _ZN7S1581C33v74Ev();
extern void _ZN7S1581C33v75Ev();
extern void _ZN7S1581C33v76Ev();
extern void _ZN7S1581C33v77Ev();
extern void _ZN7S1581C33v78Ev();
extern void _ZN7S1581C33v79Ev();
extern void _ZN7S1581C33v80Ev();
extern void _ZN7S1581C33v81Ev();
extern void _ZN7S1581C33v82Ev();
extern void _ZN7S1581C33v83Ev();
extern void _ZN7S1581C33v84Ev();
extern void _ZN7S1581C33v85Ev();
extern void _ZN7S1581C33v86Ev();
extern void _ZN7S1581C33v87Ev();
extern void _ZN7S1581C33v88Ev();
extern void _ZN7S1581C33v89Ev();
extern void _ZN7S1581C33v90Ev();
extern void _ZN7S1581C33v91Ev();
extern void _ZN7S1581C33v92Ev();
extern void _ZN7S1581C33v93Ev();
extern void _ZN7S1581C23v94Ev();
extern void _ZN7S1581C23v95Ev();
extern void _ZN7S1581C23v96Ev();
extern void _ZN7S1581C23v97Ev();
extern void _ZN7S1581C23v98Ev();
extern void _ZN7S1581C23v99Ev();
extern void _ZN7S1581C24v100Ev();
extern void _ZN7S1581C24v101Ev();
extern void _ZN7S1581C24v102Ev();
extern void _ZN7S1581C24v103Ev();
extern void _ZN7S1581C24v104Ev();
extern void _ZN7S1581C24v105Ev();
extern void _ZN7S1581C24v106Ev();
extern void _ZN7S1581C24v107Ev();
extern void _ZN7S1581C24v108Ev();
extern void _ZN7S1581C24v109Ev();
extern void _ZN7S1581C24v110Ev();
extern void _ZN7S1581C24v111Ev();
extern void _ZN7S1581C24v112Ev();
static  VTBL_ENTRY vtc_S1581C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1581C2[0]),
  (VTBL_ENTRY)&_ZN7S1581C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1581C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1581C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1581C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v112Ev,
};
extern VTBL_ENTRY _ZTI7S1581C2[];
extern  VTBL_ENTRY _ZTV7S1581C2[];
Class_Descriptor cd_S1581C2 = {  "S1581C2", // class name
  bases_S1581C2, 2,
  &(vtc_S1581C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI7S1581C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1581C2),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1581C1  : S1581C2 {
  ::S473C7_nt s1581c1f0;
  virtual  ~S1581C1(); // _ZN7S1581C1D1Ev
  virtual void  v1(); // _ZN7S1581C12v1Ev
  virtual void  v2(); // _ZN7S1581C12v2Ev
  virtual void  v3(); // _ZN7S1581C12v3Ev
  virtual void  v4(); // _ZN7S1581C12v4Ev
  virtual void  v5(); // _ZN7S1581C12v5Ev
  virtual void  v6(); // _ZN7S1581C12v6Ev
  virtual void  v7(); // _ZN7S1581C12v7Ev
  S1581C1(); // tgen
};
//SIG(1 S1581C1) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 FC5} vd v1 v2 v3 v4 v5 v6 v7 FC6}


 S1581C1 ::~S1581C1(){ note_dtor("S1581C1", this);}
void  S1581C1 ::v1(){vfunc_called(this, "_ZN7S1581C12v1Ev");}
void  S1581C1 ::v2(){vfunc_called(this, "_ZN7S1581C12v2Ev");}
void  S1581C1 ::v3(){vfunc_called(this, "_ZN7S1581C12v3Ev");}
void  S1581C1 ::v4(){vfunc_called(this, "_ZN7S1581C12v4Ev");}
void  S1581C1 ::v5(){vfunc_called(this, "_ZN7S1581C12v5Ev");}
void  S1581C1 ::v6(){vfunc_called(this, "_ZN7S1581C12v6Ev");}
void  S1581C1 ::v7(){vfunc_called(this, "_ZN7S1581C12v7Ev");}
S1581C1 ::S1581C1(){ note_ctor("S1581C1", this);} // tgen

static void Test_S1581C1()
{
  extern Class_Descriptor cd_S1581C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(28,39)];
    init_test(&cd_S1581C1, buf);
    S1581C1 *dp, &lv = *(dp=new (buf) S1581C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(216,152), "sizeof(S1581C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1581C1)");
    check_base_class_offset(lv, (S1581C4*)(S1581C3*)(S1581C2*), 0, "S1581C1");
    check_base_class_offset(lv, (S1581C3*)(S1581C2*), 0, "S1581C1");
    check_base_class_offset(lv, (S1581C2*), 0, "S1581C1");
    check_field_offset(lv, s1581c1f0, ABISELECT(200,140), "S1581C1.s1581c1f0");
    test_class_info(&lv, &cd_S1581C1);
    dp->~S1581C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1581C1(Test_S1581C1, "S1581C1", ABISELECT(216,152));

#else // __cplusplus

extern void _ZN7S1581C1C1Ev();
extern void _ZN7S1581C1D1Ev();
Name_Map name_map_S1581C1[] = {
  NSPAIR(_ZN7S1581C1C1Ev),
  NSPAIR(_ZN7S1581C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1581C4;
extern VTBL_ENTRY _ZTI7S1581C4[];
extern  VTBL_ENTRY _ZTV7S1581C4[];
extern Class_Descriptor cd_S1581C3;
extern VTBL_ENTRY _ZTI7S1581C3[];
extern  VTBL_ENTRY _ZTV7S1581C3[];
extern Class_Descriptor cd_S1581C2;
extern VTBL_ENTRY _ZTI7S1581C2[];
extern  VTBL_ENTRY _ZTV7S1581C2[];
static Base_Class bases_S1581C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1581C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1581C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1581C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1581C1[];
extern void _ZN7S1581C1D1Ev();
extern void _ZN7S1581C1D0Ev();
extern void _ZN7S1581C42v8Ev();
extern void _ZN7S1581C42v9Ev();
extern void _ZN7S1581C43v10Ev();
extern void _ZN7S1581C43v11Ev();
extern void _ZN7S1581C43v12Ev();
extern void _ZN7S1581C43v13Ev();
extern void _ZN7S1581C43v14Ev();
extern void _ZN7S1581C43v15Ev();
extern void _ZN7S1581C43v16Ev();
extern void _ZN7S1581C43v17Ev();
extern void _ZN7S1581C43v18Ev();
extern void _ZN7S1581C43v19Ev();
extern void _ZN7S1581C43v20Ev();
extern void _ZN7S1581C43v21Ev();
extern void _ZN7S1581C43v22Ev();
extern void _ZN7S1581C43v23Ev();
extern void _ZN7S1581C43v24Ev();
extern void _ZN7S1581C43v25Ev();
extern void _ZN7S1581C43v26Ev();
extern void _ZN7S1581C43v27Ev();
extern void _ZN7S1581C43v28Ev();
extern void _ZN7S1581C43v29Ev();
extern void _ZN7S1581C43v30Ev();
extern void _ZN7S1581C43v31Ev();
extern void _ZN7S1581C43v32Ev();
extern void _ZN7S1581C43v33Ev();
extern void _ZN7S1581C43v34Ev();
extern void _ZN7S1581C43v35Ev();
extern void _ZN7S1581C43v36Ev();
extern void _ZN7S1581C43v37Ev();
extern void _ZN7S1581C43v38Ev();
extern void _ZN7S1581C43v39Ev();
extern void _ZN7S1581C43v40Ev();
extern void _ZN7S1581C43v41Ev();
extern void _ZN7S1581C43v42Ev();
extern void _ZN7S1581C43v43Ev();
extern void _ZN7S1581C43v44Ev();
extern void _ZN7S1581C43v45Ev();
extern void _ZN7S1581C43v46Ev();
extern void _ZN7S1581C43v47Ev();
extern void _ZN7S1581C43v48Ev();
extern void _ZN7S1581C43v49Ev();
extern void _ZN7S1581C43v50Ev();
extern void _ZN7S1581C43v51Ev();
extern void _ZN7S1581C43v52Ev();
extern void _ZN7S1581C43v53Ev();
extern void _ZN7S1581C43v54Ev();
extern void _ZN7S1581C43v55Ev();
extern void _ZN7S1581C43v56Ev();
extern void _ZN7S1581C43v57Ev();
extern void _ZN7S1581C43v58Ev();
extern void _ZN7S1581C43v59Ev();
extern void _ZN7S1581C43v60Ev();
extern void _ZN7S1581C43v61Ev();
extern void _ZN7S1581C43v62Ev();
extern void _ZN7S1581C43v63Ev();
extern void _ZN7S1581C43v64Ev();
extern void _ZN7S1581C43v65Ev();
extern void _ZN7S1581C43v66Ev();
extern void _ZN7S1581C43v67Ev();
extern void _ZN7S1581C43v68Ev();
extern void _ZN7S1581C43v69Ev();
extern void _ZN7S1581C43v70Ev();
extern void _ZN7S1581C43v71Ev();
extern void _ZN7S1581C33v72Ev();
extern void _ZN7S1581C33v73Ev();
extern void _ZN7S1581C33v74Ev();
extern void _ZN7S1581C33v75Ev();
extern void _ZN7S1581C33v76Ev();
extern void _ZN7S1581C33v77Ev();
extern void _ZN7S1581C33v78Ev();
extern void _ZN7S1581C33v79Ev();
extern void _ZN7S1581C33v80Ev();
extern void _ZN7S1581C33v81Ev();
extern void _ZN7S1581C33v82Ev();
extern void _ZN7S1581C33v83Ev();
extern void _ZN7S1581C33v84Ev();
extern void _ZN7S1581C33v85Ev();
extern void _ZN7S1581C33v86Ev();
extern void _ZN7S1581C33v87Ev();
extern void _ZN7S1581C33v88Ev();
extern void _ZN7S1581C33v89Ev();
extern void _ZN7S1581C33v90Ev();
extern void _ZN7S1581C33v91Ev();
extern void _ZN7S1581C33v92Ev();
extern void _ZN7S1581C33v93Ev();
extern void _ZN7S1581C23v94Ev();
extern void _ZN7S1581C23v95Ev();
extern void _ZN7S1581C23v96Ev();
extern void _ZN7S1581C23v97Ev();
extern void _ZN7S1581C23v98Ev();
extern void _ZN7S1581C23v99Ev();
extern void _ZN7S1581C24v100Ev();
extern void _ZN7S1581C24v101Ev();
extern void _ZN7S1581C24v102Ev();
extern void _ZN7S1581C24v103Ev();
extern void _ZN7S1581C24v104Ev();
extern void _ZN7S1581C24v105Ev();
extern void _ZN7S1581C24v106Ev();
extern void _ZN7S1581C24v107Ev();
extern void _ZN7S1581C24v108Ev();
extern void _ZN7S1581C24v109Ev();
extern void _ZN7S1581C24v110Ev();
extern void _ZN7S1581C24v111Ev();
extern void _ZN7S1581C24v112Ev();
extern void _ZN7S1581C12v1Ev();
extern void _ZN7S1581C12v2Ev();
extern void _ZN7S1581C12v3Ev();
extern void _ZN7S1581C12v4Ev();
extern void _ZN7S1581C12v5Ev();
extern void _ZN7S1581C12v6Ev();
extern void _ZN7S1581C12v7Ev();
static  VTBL_ENTRY vtc_S1581C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1581C1[0]),
  (VTBL_ENTRY)&_ZN7S1581C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1581C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1581C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1581C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1581C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1581C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1581C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1581C24v112Ev,
  (VTBL_ENTRY)&_ZN7S1581C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1581C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1581C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1581C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1581C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1581C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1581C12v7Ev,
};
extern VTBL_ENTRY _ZTI7S1581C1[];
extern  VTBL_ENTRY _ZTV7S1581C1[];
Class_Descriptor cd_S1581C1 = {  "S1581C1", // class name
  bases_S1581C1, 3,
  &(vtc_S1581C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(216,152), // object size
  NSPAIRA(_ZTI7S1581C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1581C1),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1552C4  {
  int s1552c4f0;
  __tsi64 s1552c4f1;
  void *s1552c4f2[4];
  int s1552c4f3[2];
  void *s1552c4f4;
  ::S473C6_nt s1552c4f5;
  void *s1552c4f6[2];
  virtual  ~S1552C4(); // _ZN7S1552C4D1Ev
  virtual void  v7(); // _ZN7S1552C42v7Ev
  virtual void  v8(); // _ZN7S1552C42v8Ev
  virtual void  v9(); // _ZN7S1552C42v9Ev
  virtual void  v10(); // _ZN7S1552C43v10Ev
  virtual void  v11(); // _ZN7S1552C43v11Ev
  virtual void  v12(); // _ZN7S1552C43v12Ev
  virtual void  v13(); // _ZN7S1552C43v13Ev
  virtual void  v14(); // _ZN7S1552C43v14Ev
  virtual void  v15(); // _ZN7S1552C43v15Ev
  virtual void  v16(); // _ZN7S1552C43v16Ev
  virtual void  v17(); // _ZN7S1552C43v17Ev
  virtual void  v18(); // _ZN7S1552C43v18Ev
  virtual void  v19(); // _ZN7S1552C43v19Ev
  virtual void  v20(); // _ZN7S1552C43v20Ev
  virtual void  v21(); // _ZN7S1552C43v21Ev
  virtual void  v22(); // _ZN7S1552C43v22Ev
  virtual void  v23(); // _ZN7S1552C43v23Ev
  virtual void  v24(); // _ZN7S1552C43v24Ev
  virtual void  v25(); // _ZN7S1552C43v25Ev
  virtual void  v26(); // _ZN7S1552C43v26Ev
  virtual void  v27(); // _ZN7S1552C43v27Ev
  virtual void  v28(); // _ZN7S1552C43v28Ev
  virtual void  v29(); // _ZN7S1552C43v29Ev
  virtual void  v30(); // _ZN7S1552C43v30Ev
  virtual void  v31(); // _ZN7S1552C43v31Ev
  virtual void  v32(); // _ZN7S1552C43v32Ev
  virtual void  v33(); // _ZN7S1552C43v33Ev
  virtual void  v34(); // _ZN7S1552C43v34Ev
  virtual void  v35(); // _ZN7S1552C43v35Ev
  virtual void  v36(); // _ZN7S1552C43v36Ev
  virtual void  v37(); // _ZN7S1552C43v37Ev
  virtual void  v38(); // _ZN7S1552C43v38Ev
  virtual void  v39(); // _ZN7S1552C43v39Ev
  virtual void  v40(); // _ZN7S1552C43v40Ev
  virtual void  v41(); // _ZN7S1552C43v41Ev
  virtual void  v42(); // _ZN7S1552C43v42Ev
  virtual void  v43(); // _ZN7S1552C43v43Ev
  virtual void  v44(); // _ZN7S1552C43v44Ev
  virtual void  v45(); // _ZN7S1552C43v45Ev
  virtual void  v46(); // _ZN7S1552C43v46Ev
  virtual void  v47(); // _ZN7S1552C43v47Ev
  virtual void  v48(); // _ZN7S1552C43v48Ev
  virtual void  v49(); // _ZN7S1552C43v49Ev
  virtual void  v50(); // _ZN7S1552C43v50Ev
  virtual void  v51(); // _ZN7S1552C43v51Ev
  virtual void  v52(); // _ZN7S1552C43v52Ev
  virtual void  v53(); // _ZN7S1552C43v53Ev
  virtual void  v54(); // _ZN7S1552C43v54Ev
  virtual void  v55(); // _ZN7S1552C43v55Ev
  virtual void  v56(); // _ZN7S1552C43v56Ev
  virtual void  v57(); // _ZN7S1552C43v57Ev
  virtual void  v58(); // _ZN7S1552C43v58Ev
  virtual void  v59(); // _ZN7S1552C43v59Ev
  virtual void  v60(); // _ZN7S1552C43v60Ev
  virtual void  v61(); // _ZN7S1552C43v61Ev
  virtual void  v62(); // _ZN7S1552C43v62Ev
  virtual void  v63(); // _ZN7S1552C43v63Ev
  virtual void  v64(); // _ZN7S1552C43v64Ev
  virtual void  v65(); // _ZN7S1552C43v65Ev
  virtual void  v66(); // _ZN7S1552C43v66Ev
  virtual void  v67(); // _ZN7S1552C43v67Ev
  virtual void  v68(); // _ZN7S1552C43v68Ev
  virtual void  v69(); // _ZN7S1552C43v69Ev
  virtual void  v70(); // _ZN7S1552C43v70Ev
  S1552C4(); // tgen
};
//SIG(-1 S1552C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1552C4 ::~S1552C4(){ note_dtor("S1552C4", this);}
void  S1552C4 ::v7(){vfunc_called(this, "_ZN7S1552C42v7Ev");}
void  S1552C4 ::v8(){vfunc_called(this, "_ZN7S1552C42v8Ev");}
void  S1552C4 ::v9(){vfunc_called(this, "_ZN7S1552C42v9Ev");}
void  S1552C4 ::v10(){vfunc_called(this, "_ZN7S1552C43v10Ev");}
void  S1552C4 ::v11(){vfunc_called(this, "_ZN7S1552C43v11Ev");}
void  S1552C4 ::v12(){vfunc_called(this, "_ZN7S1552C43v12Ev");}
void  S1552C4 ::v13(){vfunc_called(this, "_ZN7S1552C43v13Ev");}
void  S1552C4 ::v14(){vfunc_called(this, "_ZN7S1552C43v14Ev");}
void  S1552C4 ::v15(){vfunc_called(this, "_ZN7S1552C43v15Ev");}
void  S1552C4 ::v16(){vfunc_called(this, "_ZN7S1552C43v16Ev");}
void  S1552C4 ::v17(){vfunc_called(this, "_ZN7S1552C43v17Ev");}
void  S1552C4 ::v18(){vfunc_called(this, "_ZN7S1552C43v18Ev");}
void  S1552C4 ::v19(){vfunc_called(this, "_ZN7S1552C43v19Ev");}
void  S1552C4 ::v20(){vfunc_called(this, "_ZN7S1552C43v20Ev");}
void  S1552C4 ::v21(){vfunc_called(this, "_ZN7S1552C43v21Ev");}
void  S1552C4 ::v22(){vfunc_called(this, "_ZN7S1552C43v22Ev");}
void  S1552C4 ::v23(){vfunc_called(this, "_ZN7S1552C43v23Ev");}
void  S1552C4 ::v24(){vfunc_called(this, "_ZN7S1552C43v24Ev");}
void  S1552C4 ::v25(){vfunc_called(this, "_ZN7S1552C43v25Ev");}
void  S1552C4 ::v26(){vfunc_called(this, "_ZN7S1552C43v26Ev");}
void  S1552C4 ::v27(){vfunc_called(this, "_ZN7S1552C43v27Ev");}
void  S1552C4 ::v28(){vfunc_called(this, "_ZN7S1552C43v28Ev");}
void  S1552C4 ::v29(){vfunc_called(this, "_ZN7S1552C43v29Ev");}
void  S1552C4 ::v30(){vfunc_called(this, "_ZN7S1552C43v30Ev");}
void  S1552C4 ::v31(){vfunc_called(this, "_ZN7S1552C43v31Ev");}
void  S1552C4 ::v32(){vfunc_called(this, "_ZN7S1552C43v32Ev");}
void  S1552C4 ::v33(){vfunc_called(this, "_ZN7S1552C43v33Ev");}
void  S1552C4 ::v34(){vfunc_called(this, "_ZN7S1552C43v34Ev");}
void  S1552C4 ::v35(){vfunc_called(this, "_ZN7S1552C43v35Ev");}
void  S1552C4 ::v36(){vfunc_called(this, "_ZN7S1552C43v36Ev");}
void  S1552C4 ::v37(){vfunc_called(this, "_ZN7S1552C43v37Ev");}
void  S1552C4 ::v38(){vfunc_called(this, "_ZN7S1552C43v38Ev");}
void  S1552C4 ::v39(){vfunc_called(this, "_ZN7S1552C43v39Ev");}
void  S1552C4 ::v40(){vfunc_called(this, "_ZN7S1552C43v40Ev");}
void  S1552C4 ::v41(){vfunc_called(this, "_ZN7S1552C43v41Ev");}
void  S1552C4 ::v42(){vfunc_called(this, "_ZN7S1552C43v42Ev");}
void  S1552C4 ::v43(){vfunc_called(this, "_ZN7S1552C43v43Ev");}
void  S1552C4 ::v44(){vfunc_called(this, "_ZN7S1552C43v44Ev");}
void  S1552C4 ::v45(){vfunc_called(this, "_ZN7S1552C43v45Ev");}
void  S1552C4 ::v46(){vfunc_called(this, "_ZN7S1552C43v46Ev");}
void  S1552C4 ::v47(){vfunc_called(this, "_ZN7S1552C43v47Ev");}
void  S1552C4 ::v48(){vfunc_called(this, "_ZN7S1552C43v48Ev");}
void  S1552C4 ::v49(){vfunc_called(this, "_ZN7S1552C43v49Ev");}
void  S1552C4 ::v50(){vfunc_called(this, "_ZN7S1552C43v50Ev");}
void  S1552C4 ::v51(){vfunc_called(this, "_ZN7S1552C43v51Ev");}
void  S1552C4 ::v52(){vfunc_called(this, "_ZN7S1552C43v52Ev");}
void  S1552C4 ::v53(){vfunc_called(this, "_ZN7S1552C43v53Ev");}
void  S1552C4 ::v54(){vfunc_called(this, "_ZN7S1552C43v54Ev");}
void  S1552C4 ::v55(){vfunc_called(this, "_ZN7S1552C43v55Ev");}
void  S1552C4 ::v56(){vfunc_called(this, "_ZN7S1552C43v56Ev");}
void  S1552C4 ::v57(){vfunc_called(this, "_ZN7S1552C43v57Ev");}
void  S1552C4 ::v58(){vfunc_called(this, "_ZN7S1552C43v58Ev");}
void  S1552C4 ::v59(){vfunc_called(this, "_ZN7S1552C43v59Ev");}
void  S1552C4 ::v60(){vfunc_called(this, "_ZN7S1552C43v60Ev");}
void  S1552C4 ::v61(){vfunc_called(this, "_ZN7S1552C43v61Ev");}
void  S1552C4 ::v62(){vfunc_called(this, "_ZN7S1552C43v62Ev");}
void  S1552C4 ::v63(){vfunc_called(this, "_ZN7S1552C43v63Ev");}
void  S1552C4 ::v64(){vfunc_called(this, "_ZN7S1552C43v64Ev");}
void  S1552C4 ::v65(){vfunc_called(this, "_ZN7S1552C43v65Ev");}
void  S1552C4 ::v66(){vfunc_called(this, "_ZN7S1552C43v66Ev");}
void  S1552C4 ::v67(){vfunc_called(this, "_ZN7S1552C43v67Ev");}
void  S1552C4 ::v68(){vfunc_called(this, "_ZN7S1552C43v68Ev");}
void  S1552C4 ::v69(){vfunc_called(this, "_ZN7S1552C43v69Ev");}
void  S1552C4 ::v70(){vfunc_called(this, "_ZN7S1552C43v70Ev");}
S1552C4 ::S1552C4(){ note_ctor("S1552C4", this);} // tgen

static void Test_S1552C4()
{
  extern Class_Descriptor cd_S1552C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1552C4, buf);
    S1552C4 *dp, &lv = *(dp=new (buf) S1552C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1552C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1552C4)");
    check_field_offset(lv, s1552c4f0, ABISELECT(8,4), "S1552C4.s1552c4f0");
    check_field_offset(lv, s1552c4f1, ABISELECT(16,8), "S1552C4.s1552c4f1");
    check_field_offset(lv, s1552c4f2, ABISELECT(24,16), "S1552C4.s1552c4f2");
    check_field_offset(lv, s1552c4f3, ABISELECT(56,32), "S1552C4.s1552c4f3");
    check_field_offset(lv, s1552c4f4, ABISELECT(64,40), "S1552C4.s1552c4f4");
    check_field_offset(lv, s1552c4f5, ABISELECT(72,44), "S1552C4.s1552c4f5");
    check_field_offset(lv, s1552c4f6, ABISELECT(80,52), "S1552C4.s1552c4f6");
    test_class_info(&lv, &cd_S1552C4);
    dp->~S1552C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1552C4(Test_S1552C4, "S1552C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1552C4C1Ev();
extern void _ZN7S1552C4D1Ev();
Name_Map name_map_S1552C4[] = {
  NSPAIR(_ZN7S1552C4C1Ev),
  NSPAIR(_ZN7S1552C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1552C4[];
extern void _ZN7S1552C4D1Ev();
extern void _ZN7S1552C4D0Ev();
extern void _ZN7S1552C42v7Ev();
extern void _ZN7S1552C42v8Ev();
extern void _ZN7S1552C42v9Ev();
extern void _ZN7S1552C43v10Ev();
extern void _ZN7S1552C43v11Ev();
extern void _ZN7S1552C43v12Ev();
extern void _ZN7S1552C43v13Ev();
extern void _ZN7S1552C43v14Ev();
extern void _ZN7S1552C43v15Ev();
extern void _ZN7S1552C43v16Ev();
extern void _ZN7S1552C43v17Ev();
extern void _ZN7S1552C43v18Ev();
extern void _ZN7S1552C43v19Ev();
extern void _ZN7S1552C43v20Ev();
extern void _ZN7S1552C43v21Ev();
extern void _ZN7S1552C43v22Ev();
extern void _ZN7S1552C43v23Ev();
extern void _ZN7S1552C43v24Ev();
extern void _ZN7S1552C43v25Ev();
extern void _ZN7S1552C43v26Ev();
extern void _ZN7S1552C43v27Ev();
extern void _ZN7S1552C43v28Ev();
extern void _ZN7S1552C43v29Ev();
extern void _ZN7S1552C43v30Ev();
extern void _ZN7S1552C43v31Ev();
extern void _ZN7S1552C43v32Ev();
extern void _ZN7S1552C43v33Ev();
extern void _ZN7S1552C43v34Ev();
extern void _ZN7S1552C43v35Ev();
extern void _ZN7S1552C43v36Ev();
extern void _ZN7S1552C43v37Ev();
extern void _ZN7S1552C43v38Ev();
extern void _ZN7S1552C43v39Ev();
extern void _ZN7S1552C43v40Ev();
extern void _ZN7S1552C43v41Ev();
extern void _ZN7S1552C43v42Ev();
extern void _ZN7S1552C43v43Ev();
extern void _ZN7S1552C43v44Ev();
extern void _ZN7S1552C43v45Ev();
extern void _ZN7S1552C43v46Ev();
extern void _ZN7S1552C43v47Ev();
extern void _ZN7S1552C43v48Ev();
extern void _ZN7S1552C43v49Ev();
extern void _ZN7S1552C43v50Ev();
extern void _ZN7S1552C43v51Ev();
extern void _ZN7S1552C43v52Ev();
extern void _ZN7S1552C43v53Ev();
extern void _ZN7S1552C43v54Ev();
extern void _ZN7S1552C43v55Ev();
extern void _ZN7S1552C43v56Ev();
extern void _ZN7S1552C43v57Ev();
extern void _ZN7S1552C43v58Ev();
extern void _ZN7S1552C43v59Ev();
extern void _ZN7S1552C43v60Ev();
extern void _ZN7S1552C43v61Ev();
extern void _ZN7S1552C43v62Ev();
extern void _ZN7S1552C43v63Ev();
extern void _ZN7S1552C43v64Ev();
extern void _ZN7S1552C43v65Ev();
extern void _ZN7S1552C43v66Ev();
extern void _ZN7S1552C43v67Ev();
extern void _ZN7S1552C43v68Ev();
extern void _ZN7S1552C43v69Ev();
extern void _ZN7S1552C43v70Ev();
static  VTBL_ENTRY vtc_S1552C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1552C4[0]),
  (VTBL_ENTRY)&_ZN7S1552C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1552C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v70Ev,
};
extern VTBL_ENTRY _ZTI7S1552C4[];
extern  VTBL_ENTRY _ZTV7S1552C4[];
Class_Descriptor cd_S1552C4 = {  "S1552C4", // class name
  0,0,//no base classes
  &(vtc_S1552C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1552C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1552C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1552C3  : S1552C4 {
  int s1552c3f0[2];
  void *s1552c3f1;
  int s1552c3f2[2];
  ::S473C7_nt s1552c3f3;
  ::S473C7_nt s1552c3f4;
  ::S21925C42 s1552c3f5;
  ::S473C7_nt s1552c3f6;
  unsigned int s1552c3f7:1;
  unsigned int s1552c3f8:1;
  unsigned int s1552c3f9:1;
  unsigned int s1552c3f10:1;
  unsigned int s1552c3f11:1;
  int s1552c3f12[2];
  virtual  ~S1552C3(); // _ZN7S1552C3D1Ev
  virtual void  v71(); // _ZN7S1552C33v71Ev
  virtual void  v72(); // _ZN7S1552C33v72Ev
  virtual void  v73(); // _ZN7S1552C33v73Ev
  virtual void  v74(); // _ZN7S1552C33v74Ev
  virtual void  v75(); // _ZN7S1552C33v75Ev
  virtual void  v76(); // _ZN7S1552C33v76Ev
  virtual void  v77(); // _ZN7S1552C33v77Ev
  virtual void  v78(); // _ZN7S1552C33v78Ev
  virtual void  v79(); // _ZN7S1552C33v79Ev
  virtual void  v80(); // _ZN7S1552C33v80Ev
  virtual void  v81(); // _ZN7S1552C33v81Ev
  virtual void  v82(); // _ZN7S1552C33v82Ev
  virtual void  v83(); // _ZN7S1552C33v83Ev
  virtual void  v84(); // _ZN7S1552C33v84Ev
  virtual void  v85(); // _ZN7S1552C33v85Ev
  virtual void  v86(); // _ZN7S1552C33v86Ev
  virtual void  v87(); // _ZN7S1552C33v87Ev
  virtual void  v88(); // _ZN7S1552C33v88Ev
  virtual void  v89(); // _ZN7S1552C33v89Ev
  virtual void  v90(); // _ZN7S1552C33v90Ev
  virtual void  v91(); // _ZN7S1552C33v91Ev
  virtual void  v92(); // _ZN7S1552C33v92Ev
  S1552C3(); // tgen
};
//SIG(-1 S1552C3) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S1552C3 ::~S1552C3(){ note_dtor("S1552C3", this);}
void  S1552C3 ::v71(){vfunc_called(this, "_ZN7S1552C33v71Ev");}
void  S1552C3 ::v72(){vfunc_called(this, "_ZN7S1552C33v72Ev");}
void  S1552C3 ::v73(){vfunc_called(this, "_ZN7S1552C33v73Ev");}
void  S1552C3 ::v74(){vfunc_called(this, "_ZN7S1552C33v74Ev");}
void  S1552C3 ::v75(){vfunc_called(this, "_ZN7S1552C33v75Ev");}
void  S1552C3 ::v76(){vfunc_called(this, "_ZN7S1552C33v76Ev");}
void  S1552C3 ::v77(){vfunc_called(this, "_ZN7S1552C33v77Ev");}
void  S1552C3 ::v78(){vfunc_called(this, "_ZN7S1552C33v78Ev");}
void  S1552C3 ::v79(){vfunc_called(this, "_ZN7S1552C33v79Ev");}
void  S1552C3 ::v80(){vfunc_called(this, "_ZN7S1552C33v80Ev");}
void  S1552C3 ::v81(){vfunc_called(this, "_ZN7S1552C33v81Ev");}
void  S1552C3 ::v82(){vfunc_called(this, "_ZN7S1552C33v82Ev");}
void  S1552C3 ::v83(){vfunc_called(this, "_ZN7S1552C33v83Ev");}
void  S1552C3 ::v84(){vfunc_called(this, "_ZN7S1552C33v84Ev");}
void  S1552C3 ::v85(){vfunc_called(this, "_ZN7S1552C33v85Ev");}
void  S1552C3 ::v86(){vfunc_called(this, "_ZN7S1552C33v86Ev");}
void  S1552C3 ::v87(){vfunc_called(this, "_ZN7S1552C33v87Ev");}
void  S1552C3 ::v88(){vfunc_called(this, "_ZN7S1552C33v88Ev");}
void  S1552C3 ::v89(){vfunc_called(this, "_ZN7S1552C33v89Ev");}
void  S1552C3 ::v90(){vfunc_called(this, "_ZN7S1552C33v90Ev");}
void  S1552C3 ::v91(){vfunc_called(this, "_ZN7S1552C33v91Ev");}
void  S1552C3 ::v92(){vfunc_called(this, "_ZN7S1552C33v92Ev");}
S1552C3 ::S1552C3(){ note_ctor("S1552C3", this);} // tgen

static void Test_S1552C3()
{
  extern Class_Descriptor cd_S1552C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S1552C3, buf);
    S1552C3 *dp, &lv = *(dp=new (buf) S1552C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S1552C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1552C3)");
    check_base_class_offset(lv, (S1552C4*), 0, "S1552C3");
    check_field_offset(lv, s1552c3f0, ABISELECT(96,60), "S1552C3.s1552c3f0");
    check_field_offset(lv, s1552c3f1, ABISELECT(104,68), "S1552C3.s1552c3f1");
    check_field_offset(lv, s1552c3f2, ABISELECT(112,72), "S1552C3.s1552c3f2");
    check_field_offset(lv, s1552c3f3, ABISELECT(120,80), "S1552C3.s1552c3f3");
    check_field_offset(lv, s1552c3f4, ABISELECT(136,92), "S1552C3.s1552c3f4");
    check_field_offset(lv, s1552c3f5, ABISELECT(152,104), "S1552C3.s1552c3f5");
    check_field_offset(lv, s1552c3f6, ABISELECT(160,108), "S1552C3.s1552c3f6");
    set_bf_and_test(lv, s1552c3f7, ABISELECT(176,120), 0, 1, 1, "S1552C3");
    set_bf_and_test(lv, s1552c3f8, ABISELECT(176,120), 1, 1, 1, "S1552C3");
    set_bf_and_test(lv, s1552c3f9, ABISELECT(176,120), 2, 1, 1, "S1552C3");
    set_bf_and_test(lv, s1552c3f10, ABISELECT(176,120), 3, 1, 1, "S1552C3");
    set_bf_and_test(lv, s1552c3f11, ABISELECT(176,120), 4, 1, 1, "S1552C3");
    check_field_offset(lv, s1552c3f12, ABISELECT(180,124), "S1552C3.s1552c3f12");
    test_class_info(&lv, &cd_S1552C3);
    dp->~S1552C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1552C3(Test_S1552C3, "S1552C3", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN7S1552C3C1Ev();
extern void _ZN7S1552C3D1Ev();
Name_Map name_map_S1552C3[] = {
  NSPAIR(_ZN7S1552C3C1Ev),
  NSPAIR(_ZN7S1552C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1552C4;
extern VTBL_ENTRY _ZTI7S1552C4[];
extern  VTBL_ENTRY _ZTV7S1552C4[];
static Base_Class bases_S1552C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1552C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1552C3[];
extern void _ZN7S1552C3D1Ev();
extern void _ZN7S1552C3D0Ev();
extern void _ZN7S1552C42v7Ev();
extern void _ZN7S1552C42v8Ev();
extern void _ZN7S1552C42v9Ev();
extern void _ZN7S1552C43v10Ev();
extern void _ZN7S1552C43v11Ev();
extern void _ZN7S1552C43v12Ev();
extern void _ZN7S1552C43v13Ev();
extern void _ZN7S1552C43v14Ev();
extern void _ZN7S1552C43v15Ev();
extern void _ZN7S1552C43v16Ev();
extern void _ZN7S1552C43v17Ev();
extern void _ZN7S1552C43v18Ev();
extern void _ZN7S1552C43v19Ev();
extern void _ZN7S1552C43v20Ev();
extern void _ZN7S1552C43v21Ev();
extern void _ZN7S1552C43v22Ev();
extern void _ZN7S1552C43v23Ev();
extern void _ZN7S1552C43v24Ev();
extern void _ZN7S1552C43v25Ev();
extern void _ZN7S1552C43v26Ev();
extern void _ZN7S1552C43v27Ev();
extern void _ZN7S1552C43v28Ev();
extern void _ZN7S1552C43v29Ev();
extern void _ZN7S1552C43v30Ev();
extern void _ZN7S1552C43v31Ev();
extern void _ZN7S1552C43v32Ev();
extern void _ZN7S1552C43v33Ev();
extern void _ZN7S1552C43v34Ev();
extern void _ZN7S1552C43v35Ev();
extern void _ZN7S1552C43v36Ev();
extern void _ZN7S1552C43v37Ev();
extern void _ZN7S1552C43v38Ev();
extern void _ZN7S1552C43v39Ev();
extern void _ZN7S1552C43v40Ev();
extern void _ZN7S1552C43v41Ev();
extern void _ZN7S1552C43v42Ev();
extern void _ZN7S1552C43v43Ev();
extern void _ZN7S1552C43v44Ev();
extern void _ZN7S1552C43v45Ev();
extern void _ZN7S1552C43v46Ev();
extern void _ZN7S1552C43v47Ev();
extern void _ZN7S1552C43v48Ev();
extern void _ZN7S1552C43v49Ev();
extern void _ZN7S1552C43v50Ev();
extern void _ZN7S1552C43v51Ev();
extern void _ZN7S1552C43v52Ev();
extern void _ZN7S1552C43v53Ev();
extern void _ZN7S1552C43v54Ev();
extern void _ZN7S1552C43v55Ev();
extern void _ZN7S1552C43v56Ev();
extern void _ZN7S1552C43v57Ev();
extern void _ZN7S1552C43v58Ev();
extern void _ZN7S1552C43v59Ev();
extern void _ZN7S1552C43v60Ev();
extern void _ZN7S1552C43v61Ev();
extern void _ZN7S1552C43v62Ev();
extern void _ZN7S1552C43v63Ev();
extern void _ZN7S1552C43v64Ev();
extern void _ZN7S1552C43v65Ev();
extern void _ZN7S1552C43v66Ev();
extern void _ZN7S1552C43v67Ev();
extern void _ZN7S1552C43v68Ev();
extern void _ZN7S1552C43v69Ev();
extern void _ZN7S1552C43v70Ev();
extern void _ZN7S1552C33v71Ev();
extern void _ZN7S1552C33v72Ev();
extern void _ZN7S1552C33v73Ev();
extern void _ZN7S1552C33v74Ev();
extern void _ZN7S1552C33v75Ev();
extern void _ZN7S1552C33v76Ev();
extern void _ZN7S1552C33v77Ev();
extern void _ZN7S1552C33v78Ev();
extern void _ZN7S1552C33v79Ev();
extern void _ZN7S1552C33v80Ev();
extern void _ZN7S1552C33v81Ev();
extern void _ZN7S1552C33v82Ev();
extern void _ZN7S1552C33v83Ev();
extern void _ZN7S1552C33v84Ev();
extern void _ZN7S1552C33v85Ev();
extern void _ZN7S1552C33v86Ev();
extern void _ZN7S1552C33v87Ev();
extern void _ZN7S1552C33v88Ev();
extern void _ZN7S1552C33v89Ev();
extern void _ZN7S1552C33v90Ev();
extern void _ZN7S1552C33v91Ev();
extern void _ZN7S1552C33v92Ev();
static  VTBL_ENTRY vtc_S1552C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1552C3[0]),
  (VTBL_ENTRY)&_ZN7S1552C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1552C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v92Ev,
};
extern VTBL_ENTRY _ZTI7S1552C3[];
extern  VTBL_ENTRY _ZTV7S1552C3[];
Class_Descriptor cd_S1552C3 = {  "S1552C3", // class name
  bases_S1552C3, 1,
  &(vtc_S1552C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI7S1552C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1552C3),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1552C2  : S1552C3 {
  ::S473C6_nt s1552c2f0;
  virtual  ~S1552C2(); // _ZN7S1552C2D1Ev
  virtual void  v93(); // _ZN7S1552C23v93Ev
  virtual void  v94(); // _ZN7S1552C23v94Ev
  virtual void  v95(); // _ZN7S1552C23v95Ev
  virtual void  v96(); // _ZN7S1552C23v96Ev
  virtual void  v97(); // _ZN7S1552C23v97Ev
  virtual void  v98(); // _ZN7S1552C23v98Ev
  virtual void  v99(); // _ZN7S1552C23v99Ev
  virtual void  v100(); // _ZN7S1552C24v100Ev
  virtual void  v101(); // _ZN7S1552C24v101Ev
  virtual void  v102(); // _ZN7S1552C24v102Ev
  virtual void  v103(); // _ZN7S1552C24v103Ev
  virtual void  v104(); // _ZN7S1552C24v104Ev
  virtual void  v105(); // _ZN7S1552C24v105Ev
  virtual void  v106(); // _ZN7S1552C24v106Ev
  virtual void  v107(); // _ZN7S1552C24v107Ev
  virtual void  v108(); // _ZN7S1552C24v108Ev
  virtual void  v109(); // _ZN7S1552C24v109Ev
  virtual void  v110(); // _ZN7S1552C24v110Ev
  virtual void  v111(); // _ZN7S1552C24v111Ev
  S1552C2(); // tgen
};
//SIG(-1 S1552C2) C1{ BC2{ BC3{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 FC4}


 S1552C2 ::~S1552C2(){ note_dtor("S1552C2", this);}
void  S1552C2 ::v93(){vfunc_called(this, "_ZN7S1552C23v93Ev");}
void  S1552C2 ::v94(){vfunc_called(this, "_ZN7S1552C23v94Ev");}
void  S1552C2 ::v95(){vfunc_called(this, "_ZN7S1552C23v95Ev");}
void  S1552C2 ::v96(){vfunc_called(this, "_ZN7S1552C23v96Ev");}
void  S1552C2 ::v97(){vfunc_called(this, "_ZN7S1552C23v97Ev");}
void  S1552C2 ::v98(){vfunc_called(this, "_ZN7S1552C23v98Ev");}
void  S1552C2 ::v99(){vfunc_called(this, "_ZN7S1552C23v99Ev");}
void  S1552C2 ::v100(){vfunc_called(this, "_ZN7S1552C24v100Ev");}
void  S1552C2 ::v101(){vfunc_called(this, "_ZN7S1552C24v101Ev");}
void  S1552C2 ::v102(){vfunc_called(this, "_ZN7S1552C24v102Ev");}
void  S1552C2 ::v103(){vfunc_called(this, "_ZN7S1552C24v103Ev");}
void  S1552C2 ::v104(){vfunc_called(this, "_ZN7S1552C24v104Ev");}
void  S1552C2 ::v105(){vfunc_called(this, "_ZN7S1552C24v105Ev");}
void  S1552C2 ::v106(){vfunc_called(this, "_ZN7S1552C24v106Ev");}
void  S1552C2 ::v107(){vfunc_called(this, "_ZN7S1552C24v107Ev");}
void  S1552C2 ::v108(){vfunc_called(this, "_ZN7S1552C24v108Ev");}
void  S1552C2 ::v109(){vfunc_called(this, "_ZN7S1552C24v109Ev");}
void  S1552C2 ::v110(){vfunc_called(this, "_ZN7S1552C24v110Ev");}
void  S1552C2 ::v111(){vfunc_called(this, "_ZN7S1552C24v111Ev");}
S1552C2 ::S1552C2(){ note_ctor("S1552C2", this);} // tgen

static void Test_S1552C2()
{
  extern Class_Descriptor cd_S1552C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S1552C2, buf);
    S1552C2 *dp, &lv = *(dp=new (buf) S1552C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S1552C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1552C2)");
    check_base_class_offset(lv, (S1552C4*)(S1552C3*), 0, "S1552C2");
    check_base_class_offset(lv, (S1552C3*), 0, "S1552C2");
    check_field_offset(lv, s1552c2f0, ABISELECT(188,132), "S1552C2.s1552c2f0");
    test_class_info(&lv, &cd_S1552C2);
    dp->~S1552C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1552C2(Test_S1552C2, "S1552C2", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN7S1552C2C1Ev();
extern void _ZN7S1552C2D1Ev();
Name_Map name_map_S1552C2[] = {
  NSPAIR(_ZN7S1552C2C1Ev),
  NSPAIR(_ZN7S1552C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1552C4;
extern VTBL_ENTRY _ZTI7S1552C4[];
extern  VTBL_ENTRY _ZTV7S1552C4[];
extern Class_Descriptor cd_S1552C3;
extern VTBL_ENTRY _ZTI7S1552C3[];
extern  VTBL_ENTRY _ZTV7S1552C3[];
static Base_Class bases_S1552C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1552C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1552C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1552C2[];
extern void _ZN7S1552C2D1Ev();
extern void _ZN7S1552C2D0Ev();
extern void _ZN7S1552C42v7Ev();
extern void _ZN7S1552C42v8Ev();
extern void _ZN7S1552C42v9Ev();
extern void _ZN7S1552C43v10Ev();
extern void _ZN7S1552C43v11Ev();
extern void _ZN7S1552C43v12Ev();
extern void _ZN7S1552C43v13Ev();
extern void _ZN7S1552C43v14Ev();
extern void _ZN7S1552C43v15Ev();
extern void _ZN7S1552C43v16Ev();
extern void _ZN7S1552C43v17Ev();
extern void _ZN7S1552C43v18Ev();
extern void _ZN7S1552C43v19Ev();
extern void _ZN7S1552C43v20Ev();
extern void _ZN7S1552C43v21Ev();
extern void _ZN7S1552C43v22Ev();
extern void _ZN7S1552C43v23Ev();
extern void _ZN7S1552C43v24Ev();
extern void _ZN7S1552C43v25Ev();
extern void _ZN7S1552C43v26Ev();
extern void _ZN7S1552C43v27Ev();
extern void _ZN7S1552C43v28Ev();
extern void _ZN7S1552C43v29Ev();
extern void _ZN7S1552C43v30Ev();
extern void _ZN7S1552C43v31Ev();
extern void _ZN7S1552C43v32Ev();
extern void _ZN7S1552C43v33Ev();
extern void _ZN7S1552C43v34Ev();
extern void _ZN7S1552C43v35Ev();
extern void _ZN7S1552C43v36Ev();
extern void _ZN7S1552C43v37Ev();
extern void _ZN7S1552C43v38Ev();
extern void _ZN7S1552C43v39Ev();
extern void _ZN7S1552C43v40Ev();
extern void _ZN7S1552C43v41Ev();
extern void _ZN7S1552C43v42Ev();
extern void _ZN7S1552C43v43Ev();
extern void _ZN7S1552C43v44Ev();
extern void _ZN7S1552C43v45Ev();
extern void _ZN7S1552C43v46Ev();
extern void _ZN7S1552C43v47Ev();
extern void _ZN7S1552C43v48Ev();
extern void _ZN7S1552C43v49Ev();
extern void _ZN7S1552C43v50Ev();
extern void _ZN7S1552C43v51Ev();
extern void _ZN7S1552C43v52Ev();
extern void _ZN7S1552C43v53Ev();
extern void _ZN7S1552C43v54Ev();
extern void _ZN7S1552C43v55Ev();
extern void _ZN7S1552C43v56Ev();
extern void _ZN7S1552C43v57Ev();
extern void _ZN7S1552C43v58Ev();
extern void _ZN7S1552C43v59Ev();
extern void _ZN7S1552C43v60Ev();
extern void _ZN7S1552C43v61Ev();
extern void _ZN7S1552C43v62Ev();
extern void _ZN7S1552C43v63Ev();
extern void _ZN7S1552C43v64Ev();
extern void _ZN7S1552C43v65Ev();
extern void _ZN7S1552C43v66Ev();
extern void _ZN7S1552C43v67Ev();
extern void _ZN7S1552C43v68Ev();
extern void _ZN7S1552C43v69Ev();
extern void _ZN7S1552C43v70Ev();
extern void _ZN7S1552C33v71Ev();
extern void _ZN7S1552C33v72Ev();
extern void _ZN7S1552C33v73Ev();
extern void _ZN7S1552C33v74Ev();
extern void _ZN7S1552C33v75Ev();
extern void _ZN7S1552C33v76Ev();
extern void _ZN7S1552C33v77Ev();
extern void _ZN7S1552C33v78Ev();
extern void _ZN7S1552C33v79Ev();
extern void _ZN7S1552C33v80Ev();
extern void _ZN7S1552C33v81Ev();
extern void _ZN7S1552C33v82Ev();
extern void _ZN7S1552C33v83Ev();
extern void _ZN7S1552C33v84Ev();
extern void _ZN7S1552C33v85Ev();
extern void _ZN7S1552C33v86Ev();
extern void _ZN7S1552C33v87Ev();
extern void _ZN7S1552C33v88Ev();
extern void _ZN7S1552C33v89Ev();
extern void _ZN7S1552C33v90Ev();
extern void _ZN7S1552C33v91Ev();
extern void _ZN7S1552C33v92Ev();
extern void _ZN7S1552C23v93Ev();
extern void _ZN7S1552C23v94Ev();
extern void _ZN7S1552C23v95Ev();
extern void _ZN7S1552C23v96Ev();
extern void _ZN7S1552C23v97Ev();
extern void _ZN7S1552C23v98Ev();
extern void _ZN7S1552C23v99Ev();
extern void _ZN7S1552C24v100Ev();
extern void _ZN7S1552C24v101Ev();
extern void _ZN7S1552C24v102Ev();
extern void _ZN7S1552C24v103Ev();
extern void _ZN7S1552C24v104Ev();
extern void _ZN7S1552C24v105Ev();
extern void _ZN7S1552C24v106Ev();
extern void _ZN7S1552C24v107Ev();
extern void _ZN7S1552C24v108Ev();
extern void _ZN7S1552C24v109Ev();
extern void _ZN7S1552C24v110Ev();
extern void _ZN7S1552C24v111Ev();
static  VTBL_ENTRY vtc_S1552C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1552C2[0]),
  (VTBL_ENTRY)&_ZN7S1552C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1552C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v111Ev,
};
extern VTBL_ENTRY _ZTI7S1552C2[];
extern  VTBL_ENTRY _ZTV7S1552C2[];
Class_Descriptor cd_S1552C2 = {  "S1552C2", // class name
  bases_S1552C2, 2,
  &(vtc_S1552C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI7S1552C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1552C2),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1552C1  : S1552C2 {
  void *s1552c1f0;
  ::S473C7_nt s1552c1f1;
  virtual  ~S1552C1(); // _ZN7S1552C1D1Ev
  virtual void  v1(); // _ZN7S1552C12v1Ev
  virtual void  v2(); // _ZN7S1552C12v2Ev
  virtual void  v3(); // _ZN7S1552C12v3Ev
  virtual void  v4(); // _ZN7S1552C12v4Ev
  virtual void  v5(); // _ZN7S1552C12v5Ev
  virtual void  v6(); // _ZN7S1552C12v6Ev
  S1552C1(); // tgen
};
//SIG(1 S1552C1) C1{ BC2{ BC3{ BC4{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 FC5} vd v1 v2 v3 v4 v5 v6 Fp FC6}


 S1552C1 ::~S1552C1(){ note_dtor("S1552C1", this);}
void  S1552C1 ::v1(){vfunc_called(this, "_ZN7S1552C12v1Ev");}
void  S1552C1 ::v2(){vfunc_called(this, "_ZN7S1552C12v2Ev");}
void  S1552C1 ::v3(){vfunc_called(this, "_ZN7S1552C12v3Ev");}
void  S1552C1 ::v4(){vfunc_called(this, "_ZN7S1552C12v4Ev");}
void  S1552C1 ::v5(){vfunc_called(this, "_ZN7S1552C12v5Ev");}
void  S1552C1 ::v6(){vfunc_called(this, "_ZN7S1552C12v6Ev");}
S1552C1 ::S1552C1(){ note_ctor("S1552C1", this);} // tgen

static void Test_S1552C1()
{
  extern Class_Descriptor cd_S1552C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,40)];
    init_test(&cd_S1552C1, buf);
    S1552C1 *dp, &lv = *(dp=new (buf) S1552C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,156), "sizeof(S1552C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1552C1)");
    check_base_class_offset(lv, (S1552C4*)(S1552C3*)(S1552C2*), 0, "S1552C1");
    check_base_class_offset(lv, (S1552C3*)(S1552C2*), 0, "S1552C1");
    check_base_class_offset(lv, (S1552C2*), 0, "S1552C1");
    check_field_offset(lv, s1552c1f0, ABISELECT(200,140), "S1552C1.s1552c1f0");
    check_field_offset(lv, s1552c1f1, ABISELECT(208,144), "S1552C1.s1552c1f1");
    test_class_info(&lv, &cd_S1552C1);
    dp->~S1552C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1552C1(Test_S1552C1, "S1552C1", ABISELECT(224,156));

#else // __cplusplus

extern void _ZN7S1552C1C1Ev();
extern void _ZN7S1552C1D1Ev();
Name_Map name_map_S1552C1[] = {
  NSPAIR(_ZN7S1552C1C1Ev),
  NSPAIR(_ZN7S1552C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1552C4;
extern VTBL_ENTRY _ZTI7S1552C4[];
extern  VTBL_ENTRY _ZTV7S1552C4[];
extern Class_Descriptor cd_S1552C3;
extern VTBL_ENTRY _ZTI7S1552C3[];
extern  VTBL_ENTRY _ZTV7S1552C3[];
extern Class_Descriptor cd_S1552C2;
extern VTBL_ENTRY _ZTI7S1552C2[];
extern  VTBL_ENTRY _ZTV7S1552C2[];
static Base_Class bases_S1552C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1552C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1552C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1552C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1552C1[];
extern void _ZN7S1552C1D1Ev();
extern void _ZN7S1552C1D0Ev();
extern void _ZN7S1552C42v7Ev();
extern void _ZN7S1552C42v8Ev();
extern void _ZN7S1552C42v9Ev();
extern void _ZN7S1552C43v10Ev();
extern void _ZN7S1552C43v11Ev();
extern void _ZN7S1552C43v12Ev();
extern void _ZN7S1552C43v13Ev();
extern void _ZN7S1552C43v14Ev();
extern void _ZN7S1552C43v15Ev();
extern void _ZN7S1552C43v16Ev();
extern void _ZN7S1552C43v17Ev();
extern void _ZN7S1552C43v18Ev();
extern void _ZN7S1552C43v19Ev();
extern void _ZN7S1552C43v20Ev();
extern void _ZN7S1552C43v21Ev();
extern void _ZN7S1552C43v22Ev();
extern void _ZN7S1552C43v23Ev();
extern void _ZN7S1552C43v24Ev();
extern void _ZN7S1552C43v25Ev();
extern void _ZN7S1552C43v26Ev();
extern void _ZN7S1552C43v27Ev();
extern void _ZN7S1552C43v28Ev();
extern void _ZN7S1552C43v29Ev();
extern void _ZN7S1552C43v30Ev();
extern void _ZN7S1552C43v31Ev();
extern void _ZN7S1552C43v32Ev();
extern void _ZN7S1552C43v33Ev();
extern void _ZN7S1552C43v34Ev();
extern void _ZN7S1552C43v35Ev();
extern void _ZN7S1552C43v36Ev();
extern void _ZN7S1552C43v37Ev();
extern void _ZN7S1552C43v38Ev();
extern void _ZN7S1552C43v39Ev();
extern void _ZN7S1552C43v40Ev();
extern void _ZN7S1552C43v41Ev();
extern void _ZN7S1552C43v42Ev();
extern void _ZN7S1552C43v43Ev();
extern void _ZN7S1552C43v44Ev();
extern void _ZN7S1552C43v45Ev();
extern void _ZN7S1552C43v46Ev();
extern void _ZN7S1552C43v47Ev();
extern void _ZN7S1552C43v48Ev();
extern void _ZN7S1552C43v49Ev();
extern void _ZN7S1552C43v50Ev();
extern void _ZN7S1552C43v51Ev();
extern void _ZN7S1552C43v52Ev();
extern void _ZN7S1552C43v53Ev();
extern void _ZN7S1552C43v54Ev();
extern void _ZN7S1552C43v55Ev();
extern void _ZN7S1552C43v56Ev();
extern void _ZN7S1552C43v57Ev();
extern void _ZN7S1552C43v58Ev();
extern void _ZN7S1552C43v59Ev();
extern void _ZN7S1552C43v60Ev();
extern void _ZN7S1552C43v61Ev();
extern void _ZN7S1552C43v62Ev();
extern void _ZN7S1552C43v63Ev();
extern void _ZN7S1552C43v64Ev();
extern void _ZN7S1552C43v65Ev();
extern void _ZN7S1552C43v66Ev();
extern void _ZN7S1552C43v67Ev();
extern void _ZN7S1552C43v68Ev();
extern void _ZN7S1552C43v69Ev();
extern void _ZN7S1552C43v70Ev();
extern void _ZN7S1552C33v71Ev();
extern void _ZN7S1552C33v72Ev();
extern void _ZN7S1552C33v73Ev();
extern void _ZN7S1552C33v74Ev();
extern void _ZN7S1552C33v75Ev();
extern void _ZN7S1552C33v76Ev();
extern void _ZN7S1552C33v77Ev();
extern void _ZN7S1552C33v78Ev();
extern void _ZN7S1552C33v79Ev();
extern void _ZN7S1552C33v80Ev();
extern void _ZN7S1552C33v81Ev();
extern void _ZN7S1552C33v82Ev();
extern void _ZN7S1552C33v83Ev();
extern void _ZN7S1552C33v84Ev();
extern void _ZN7S1552C33v85Ev();
extern void _ZN7S1552C33v86Ev();
extern void _ZN7S1552C33v87Ev();
extern void _ZN7S1552C33v88Ev();
extern void _ZN7S1552C33v89Ev();
extern void _ZN7S1552C33v90Ev();
extern void _ZN7S1552C33v91Ev();
extern void _ZN7S1552C33v92Ev();
extern void _ZN7S1552C23v93Ev();
extern void _ZN7S1552C23v94Ev();
extern void _ZN7S1552C23v95Ev();
extern void _ZN7S1552C23v96Ev();
extern void _ZN7S1552C23v97Ev();
extern void _ZN7S1552C23v98Ev();
extern void _ZN7S1552C23v99Ev();
extern void _ZN7S1552C24v100Ev();
extern void _ZN7S1552C24v101Ev();
extern void _ZN7S1552C24v102Ev();
extern void _ZN7S1552C24v103Ev();
extern void _ZN7S1552C24v104Ev();
extern void _ZN7S1552C24v105Ev();
extern void _ZN7S1552C24v106Ev();
extern void _ZN7S1552C24v107Ev();
extern void _ZN7S1552C24v108Ev();
extern void _ZN7S1552C24v109Ev();
extern void _ZN7S1552C24v110Ev();
extern void _ZN7S1552C24v111Ev();
extern void _ZN7S1552C12v1Ev();
extern void _ZN7S1552C12v2Ev();
extern void _ZN7S1552C12v3Ev();
extern void _ZN7S1552C12v4Ev();
extern void _ZN7S1552C12v5Ev();
extern void _ZN7S1552C12v6Ev();
static  VTBL_ENTRY vtc_S1552C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1552C1[0]),
  (VTBL_ENTRY)&_ZN7S1552C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1552C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1552C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1552C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1552C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1552C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v110Ev,
  (VTBL_ENTRY)&_ZN7S1552C24v111Ev,
  (VTBL_ENTRY)&_ZN7S1552C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1552C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1552C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1552C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1552C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1552C12v6Ev,
};
extern VTBL_ENTRY _ZTI7S1552C1[];
extern  VTBL_ENTRY _ZTV7S1552C1[];
Class_Descriptor cd_S1552C1 = {  "S1552C1", // class name
  bases_S1552C1, 3,
  &(vtc_S1552C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,156), // object size
  NSPAIRA(_ZTI7S1552C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1552C1),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1473C4  {
  int s1473c4f0;
  __tsi64 s1473c4f1;
  void *s1473c4f2[4];
  int s1473c4f3[2];
  void *s1473c4f4;
  ::S473C6_nt s1473c4f5;
  void *s1473c4f6[2];
  virtual  ~S1473C4(); // _ZN7S1473C4D1Ev
  virtual void  v5(); // _ZN7S1473C42v5Ev
  virtual void  v6(); // _ZN7S1473C42v6Ev
  virtual void  v7(); // _ZN7S1473C42v7Ev
  virtual void  v8(); // _ZN7S1473C42v8Ev
  virtual void  v9(); // _ZN7S1473C42v9Ev
  virtual void  v10(); // _ZN7S1473C43v10Ev
  virtual void  v11(); // _ZN7S1473C43v11Ev
  virtual void  v12(); // _ZN7S1473C43v12Ev
  virtual void  v13(); // _ZN7S1473C43v13Ev
  virtual void  v14(); // _ZN7S1473C43v14Ev
  virtual void  v15(); // _ZN7S1473C43v15Ev
  virtual void  v16(); // _ZN7S1473C43v16Ev
  virtual void  v17(); // _ZN7S1473C43v17Ev
  virtual void  v18(); // _ZN7S1473C43v18Ev
  virtual void  v19(); // _ZN7S1473C43v19Ev
  virtual void  v20(); // _ZN7S1473C43v20Ev
  virtual void  v21(); // _ZN7S1473C43v21Ev
  virtual void  v22(); // _ZN7S1473C43v22Ev
  virtual void  v23(); // _ZN7S1473C43v23Ev
  virtual void  v24(); // _ZN7S1473C43v24Ev
  virtual void  v25(); // _ZN7S1473C43v25Ev
  virtual void  v26(); // _ZN7S1473C43v26Ev
  virtual void  v27(); // _ZN7S1473C43v27Ev
  virtual void  v28(); // _ZN7S1473C43v28Ev
  virtual void  v29(); // _ZN7S1473C43v29Ev
  virtual void  v30(); // _ZN7S1473C43v30Ev
  virtual void  v31(); // _ZN7S1473C43v31Ev
  virtual void  v32(); // _ZN7S1473C43v32Ev
  virtual void  v33(); // _ZN7S1473C43v33Ev
  virtual void  v34(); // _ZN7S1473C43v34Ev
  virtual void  v35(); // _ZN7S1473C43v35Ev
  virtual void  v36(); // _ZN7S1473C43v36Ev
  virtual void  v37(); // _ZN7S1473C43v37Ev
  virtual void  v38(); // _ZN7S1473C43v38Ev
  virtual void  v39(); // _ZN7S1473C43v39Ev
  virtual void  v40(); // _ZN7S1473C43v40Ev
  virtual void  v41(); // _ZN7S1473C43v41Ev
  virtual void  v42(); // _ZN7S1473C43v42Ev
  virtual void  v43(); // _ZN7S1473C43v43Ev
  virtual void  v44(); // _ZN7S1473C43v44Ev
  virtual void  v45(); // _ZN7S1473C43v45Ev
  virtual void  v46(); // _ZN7S1473C43v46Ev
  virtual void  v47(); // _ZN7S1473C43v47Ev
  virtual void  v48(); // _ZN7S1473C43v48Ev
  virtual void  v49(); // _ZN7S1473C43v49Ev
  virtual void  v50(); // _ZN7S1473C43v50Ev
  virtual void  v51(); // _ZN7S1473C43v51Ev
  virtual void  v52(); // _ZN7S1473C43v52Ev
  virtual void  v53(); // _ZN7S1473C43v53Ev
  virtual void  v54(); // _ZN7S1473C43v54Ev
  virtual void  v55(); // _ZN7S1473C43v55Ev
  virtual void  v56(); // _ZN7S1473C43v56Ev
  virtual void  v57(); // _ZN7S1473C43v57Ev
  virtual void  v58(); // _ZN7S1473C43v58Ev
  virtual void  v59(); // _ZN7S1473C43v59Ev
  virtual void  v60(); // _ZN7S1473C43v60Ev
  virtual void  v61(); // _ZN7S1473C43v61Ev
  virtual void  v62(); // _ZN7S1473C43v62Ev
  virtual void  v63(); // _ZN7S1473C43v63Ev
  virtual void  v64(); // _ZN7S1473C43v64Ev
  virtual void  v65(); // _ZN7S1473C43v65Ev
  virtual void  v66(); // _ZN7S1473C43v66Ev
  virtual void  v67(); // _ZN7S1473C43v67Ev
  virtual void  v68(); // _ZN7S1473C43v68Ev
  S1473C4(); // tgen
};
//SIG(-1 S1473C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1473C4 ::~S1473C4(){ note_dtor("S1473C4", this);}
void  S1473C4 ::v5(){vfunc_called(this, "_ZN7S1473C42v5Ev");}
void  S1473C4 ::v6(){vfunc_called(this, "_ZN7S1473C42v6Ev");}
void  S1473C4 ::v7(){vfunc_called(this, "_ZN7S1473C42v7Ev");}
void  S1473C4 ::v8(){vfunc_called(this, "_ZN7S1473C42v8Ev");}
void  S1473C4 ::v9(){vfunc_called(this, "_ZN7S1473C42v9Ev");}
void  S1473C4 ::v10(){vfunc_called(this, "_ZN7S1473C43v10Ev");}
void  S1473C4 ::v11(){vfunc_called(this, "_ZN7S1473C43v11Ev");}
void  S1473C4 ::v12(){vfunc_called(this, "_ZN7S1473C43v12Ev");}
void  S1473C4 ::v13(){vfunc_called(this, "_ZN7S1473C43v13Ev");}
void  S1473C4 ::v14(){vfunc_called(this, "_ZN7S1473C43v14Ev");}
void  S1473C4 ::v15(){vfunc_called(this, "_ZN7S1473C43v15Ev");}
void  S1473C4 ::v16(){vfunc_called(this, "_ZN7S1473C43v16Ev");}
void  S1473C4 ::v17(){vfunc_called(this, "_ZN7S1473C43v17Ev");}
void  S1473C4 ::v18(){vfunc_called(this, "_ZN7S1473C43v18Ev");}
void  S1473C4 ::v19(){vfunc_called(this, "_ZN7S1473C43v19Ev");}
void  S1473C4 ::v20(){vfunc_called(this, "_ZN7S1473C43v20Ev");}
void  S1473C4 ::v21(){vfunc_called(this, "_ZN7S1473C43v21Ev");}
void  S1473C4 ::v22(){vfunc_called(this, "_ZN7S1473C43v22Ev");}
void  S1473C4 ::v23(){vfunc_called(this, "_ZN7S1473C43v23Ev");}
void  S1473C4 ::v24(){vfunc_called(this, "_ZN7S1473C43v24Ev");}
void  S1473C4 ::v25(){vfunc_called(this, "_ZN7S1473C43v25Ev");}
void  S1473C4 ::v26(){vfunc_called(this, "_ZN7S1473C43v26Ev");}
void  S1473C4 ::v27(){vfunc_called(this, "_ZN7S1473C43v27Ev");}
void  S1473C4 ::v28(){vfunc_called(this, "_ZN7S1473C43v28Ev");}
void  S1473C4 ::v29(){vfunc_called(this, "_ZN7S1473C43v29Ev");}
void  S1473C4 ::v30(){vfunc_called(this, "_ZN7S1473C43v30Ev");}
void  S1473C4 ::v31(){vfunc_called(this, "_ZN7S1473C43v31Ev");}
void  S1473C4 ::v32(){vfunc_called(this, "_ZN7S1473C43v32Ev");}
void  S1473C4 ::v33(){vfunc_called(this, "_ZN7S1473C43v33Ev");}
void  S1473C4 ::v34(){vfunc_called(this, "_ZN7S1473C43v34Ev");}
void  S1473C4 ::v35(){vfunc_called(this, "_ZN7S1473C43v35Ev");}
void  S1473C4 ::v36(){vfunc_called(this, "_ZN7S1473C43v36Ev");}
void  S1473C4 ::v37(){vfunc_called(this, "_ZN7S1473C43v37Ev");}
void  S1473C4 ::v38(){vfunc_called(this, "_ZN7S1473C43v38Ev");}
void  S1473C4 ::v39(){vfunc_called(this, "_ZN7S1473C43v39Ev");}
void  S1473C4 ::v40(){vfunc_called(this, "_ZN7S1473C43v40Ev");}
void  S1473C4 ::v41(){vfunc_called(this, "_ZN7S1473C43v41Ev");}
void  S1473C4 ::v42(){vfunc_called(this, "_ZN7S1473C43v42Ev");}
void  S1473C4 ::v43(){vfunc_called(this, "_ZN7S1473C43v43Ev");}
void  S1473C4 ::v44(){vfunc_called(this, "_ZN7S1473C43v44Ev");}
void  S1473C4 ::v45(){vfunc_called(this, "_ZN7S1473C43v45Ev");}
void  S1473C4 ::v46(){vfunc_called(this, "_ZN7S1473C43v46Ev");}
void  S1473C4 ::v47(){vfunc_called(this, "_ZN7S1473C43v47Ev");}
void  S1473C4 ::v48(){vfunc_called(this, "_ZN7S1473C43v48Ev");}
void  S1473C4 ::v49(){vfunc_called(this, "_ZN7S1473C43v49Ev");}
void  S1473C4 ::v50(){vfunc_called(this, "_ZN7S1473C43v50Ev");}
void  S1473C4 ::v51(){vfunc_called(this, "_ZN7S1473C43v51Ev");}
void  S1473C4 ::v52(){vfunc_called(this, "_ZN7S1473C43v52Ev");}
void  S1473C4 ::v53(){vfunc_called(this, "_ZN7S1473C43v53Ev");}
void  S1473C4 ::v54(){vfunc_called(this, "_ZN7S1473C43v54Ev");}
void  S1473C4 ::v55(){vfunc_called(this, "_ZN7S1473C43v55Ev");}
void  S1473C4 ::v56(){vfunc_called(this, "_ZN7S1473C43v56Ev");}
void  S1473C4 ::v57(){vfunc_called(this, "_ZN7S1473C43v57Ev");}
void  S1473C4 ::v58(){vfunc_called(this, "_ZN7S1473C43v58Ev");}
void  S1473C4 ::v59(){vfunc_called(this, "_ZN7S1473C43v59Ev");}
void  S1473C4 ::v60(){vfunc_called(this, "_ZN7S1473C43v60Ev");}
void  S1473C4 ::v61(){vfunc_called(this, "_ZN7S1473C43v61Ev");}
void  S1473C4 ::v62(){vfunc_called(this, "_ZN7S1473C43v62Ev");}
void  S1473C4 ::v63(){vfunc_called(this, "_ZN7S1473C43v63Ev");}
void  S1473C4 ::v64(){vfunc_called(this, "_ZN7S1473C43v64Ev");}
void  S1473C4 ::v65(){vfunc_called(this, "_ZN7S1473C43v65Ev");}
void  S1473C4 ::v66(){vfunc_called(this, "_ZN7S1473C43v66Ev");}
void  S1473C4 ::v67(){vfunc_called(this, "_ZN7S1473C43v67Ev");}
void  S1473C4 ::v68(){vfunc_called(this, "_ZN7S1473C43v68Ev");}
S1473C4 ::S1473C4(){ note_ctor("S1473C4", this);} // tgen

static void Test_S1473C4()
{
  extern Class_Descriptor cd_S1473C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1473C4, buf);
    S1473C4 *dp, &lv = *(dp=new (buf) S1473C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1473C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1473C4)");
    check_field_offset(lv, s1473c4f0, ABISELECT(8,4), "S1473C4.s1473c4f0");
    check_field_offset(lv, s1473c4f1, ABISELECT(16,8), "S1473C4.s1473c4f1");
    check_field_offset(lv, s1473c4f2, ABISELECT(24,16), "S1473C4.s1473c4f2");
    check_field_offset(lv, s1473c4f3, ABISELECT(56,32), "S1473C4.s1473c4f3");
    check_field_offset(lv, s1473c4f4, ABISELECT(64,40), "S1473C4.s1473c4f4");
    check_field_offset(lv, s1473c4f5, ABISELECT(72,44), "S1473C4.s1473c4f5");
    check_field_offset(lv, s1473c4f6, ABISELECT(80,52), "S1473C4.s1473c4f6");
    test_class_info(&lv, &cd_S1473C4);
    dp->~S1473C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1473C4(Test_S1473C4, "S1473C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1473C4C1Ev();
extern void _ZN7S1473C4D1Ev();
Name_Map name_map_S1473C4[] = {
  NSPAIR(_ZN7S1473C4C1Ev),
  NSPAIR(_ZN7S1473C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1473C4[];
extern void _ZN7S1473C4D1Ev();
extern void _ZN7S1473C4D0Ev();
extern void _ZN7S1473C42v5Ev();
extern void _ZN7S1473C42v6Ev();
extern void _ZN7S1473C42v7Ev();
extern void _ZN7S1473C42v8Ev();
extern void _ZN7S1473C42v9Ev();
extern void _ZN7S1473C43v10Ev();
extern void _ZN7S1473C43v11Ev();
extern void _ZN7S1473C43v12Ev();
extern void _ZN7S1473C43v13Ev();
extern void _ZN7S1473C43v14Ev();
extern void _ZN7S1473C43v15Ev();
extern void _ZN7S1473C43v16Ev();
extern void _ZN7S1473C43v17Ev();
extern void _ZN7S1473C43v18Ev();
extern void _ZN7S1473C43v19Ev();
extern void _ZN7S1473C43v20Ev();
extern void _ZN7S1473C43v21Ev();
extern void _ZN7S1473C43v22Ev();
extern void _ZN7S1473C43v23Ev();
extern void _ZN7S1473C43v24Ev();
extern void _ZN7S1473C43v25Ev();
extern void _ZN7S1473C43v26Ev();
extern void _ZN7S1473C43v27Ev();
extern void _ZN7S1473C43v28Ev();
extern void _ZN7S1473C43v29Ev();
extern void _ZN7S1473C43v30Ev();
extern void _ZN7S1473C43v31Ev();
extern void _ZN7S1473C43v32Ev();
extern void _ZN7S1473C43v33Ev();
extern void _ZN7S1473C43v34Ev();
extern void _ZN7S1473C43v35Ev();
extern void _ZN7S1473C43v36Ev();
extern void _ZN7S1473C43v37Ev();
extern void _ZN7S1473C43v38Ev();
extern void _ZN7S1473C43v39Ev();
extern void _ZN7S1473C43v40Ev();
extern void _ZN7S1473C43v41Ev();
extern void _ZN7S1473C43v42Ev();
extern void _ZN7S1473C43v43Ev();
extern void _ZN7S1473C43v44Ev();
extern void _ZN7S1473C43v45Ev();
extern void _ZN7S1473C43v46Ev();
extern void _ZN7S1473C43v47Ev();
extern void _ZN7S1473C43v48Ev();
extern void _ZN7S1473C43v49Ev();
extern void _ZN7S1473C43v50Ev();
extern void _ZN7S1473C43v51Ev();
extern void _ZN7S1473C43v52Ev();
extern void _ZN7S1473C43v53Ev();
extern void _ZN7S1473C43v54Ev();
extern void _ZN7S1473C43v55Ev();
extern void _ZN7S1473C43v56Ev();
extern void _ZN7S1473C43v57Ev();
extern void _ZN7S1473C43v58Ev();
extern void _ZN7S1473C43v59Ev();
extern void _ZN7S1473C43v60Ev();
extern void _ZN7S1473C43v61Ev();
extern void _ZN7S1473C43v62Ev();
extern void _ZN7S1473C43v63Ev();
extern void _ZN7S1473C43v64Ev();
extern void _ZN7S1473C43v65Ev();
extern void _ZN7S1473C43v66Ev();
extern void _ZN7S1473C43v67Ev();
extern void _ZN7S1473C43v68Ev();
static  VTBL_ENTRY vtc_S1473C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1473C4[0]),
  (VTBL_ENTRY)&_ZN7S1473C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1473C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1473C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1473C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1473C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1473C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1473C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1473C43v68Ev,
};
extern VTBL_ENTRY _ZTI7S1473C4[];
extern  VTBL_ENTRY _ZTV7S1473C4[];
Class_Descriptor cd_S1473C4 = {  "S1473C4", // class name
  0,0,//no base classes
  &(vtc_S1473C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1473C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1473C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1473C3  : S1473C4 {
  int s1473c3f0[2];
  void *s1473c3f1;
  int s1473c3f2[2];
  ::S473C7_nt s1473c3f3;
  ::S473C7_nt s1473c3f4;
  ::S21925C42 s1473c3f5;
  ::S473C7_nt s1473c3f6;
  unsigned int s1473c3f7:1;
  unsigned int s1473c3f8:1;
  unsigned int s1473c3f9:1;
  unsigned int s1473c3f10:1;
  unsigned int s1473c3f11:1;
  int s1473c3f12[2];
  virtual  ~S1473C3(); // _ZN7S1473C3D1Ev
  virtual void  v69(); // _ZN7S1473C33v69Ev
  virtual void  v70(); // _ZN7S1473C33v70Ev
  virtual void  v71(); // _ZN7S1473C33v71Ev
  virtual void  v72(); // _ZN7S1473C33v72Ev
  virtual void  v73(); // _ZN7S1473C33v73Ev
  virtual void  v74(); // _ZN7S1473C33v74Ev
  virtual void  v75(); // _ZN7S1473C33v75Ev
  virtual void  v76(); // _ZN7S1473C33v76Ev
  virtual void  v77(); // _ZN7S1473C33v77Ev
  virtual void  v78(); // _ZN7S1473C33v78Ev
  virtual void  v79(); // _ZN7S1473C33v79Ev
  virtual void  v80(); // _ZN7S1473C33v80Ev
  virtual void  v81(); // _ZN7S1473C33v81Ev
  virtual void  v82(); // _ZN7S1473C33v82Ev
  virtual void  v83(); // _ZN7S1473C33v83Ev
  virtual void  v84(); // _ZN7S1473C33v84Ev
  virtual void  v85(); // _ZN7S1473C33v85Ev
  virtual void  v86(); // _ZN7S1473C33v86Ev
  virtual void  v87(); // _ZN7S1473C33v87Ev
  virtual void  v88(); // _ZN7S1473C33v88Ev
  virtual void  v89(); // _ZN7S1473C33v89Ev
  virtual void  v90(); // _ZN7S1473C33v90Ev
  S1473C3(); // tgen
};
//SIG(-1 S1473C3) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S1473C3 ::~S1473C3(){ note_dtor("S1473C3", this);}
void  S1473C3 ::v69(){vfunc_called(this, "_ZN7S1473C33v69Ev");}
void  S1473C3 ::v70(){vfunc_called(this, "_ZN7S1473C33v70Ev");}
void  S1473C3 ::v71(){vfunc_called(this, "_ZN7S1473C33v71Ev");}
void  S1473C3 ::v72(){vfunc_called(this, "_ZN7S1473C33v72Ev");}
void  S1473C3 ::v73(){vfunc_called(this, "_ZN7S1473C33v73Ev");}
void  S1473C3 ::v74(){vfunc_called(this, "_ZN7S1473C33v74Ev");}
void  S1473C3 ::v75(){vfunc_called(this, "_ZN7S1473C33v75Ev");}
void  S1473C3 ::v76(){vfunc_called(this, "_ZN7S1473C33v76Ev");}
void  S1473C3 ::v77(){vfunc_called(this, "_ZN7S1473C33v77Ev");}
void  S1473C3 ::v78(){vfunc_called(this, "_ZN7S1473C33v78Ev");}
void  S1473C3 ::v79(){vfunc_called(this, "_ZN7S1473C33v79Ev");}
void  S1473C3 ::v80(){vfunc_called(this, "_ZN7S1473C33v80Ev");}
void  S1473C3 ::v81(){vfunc_called(this, "_ZN7S1473C33v81Ev");}
void  S1473C3 ::v82(){vfunc_called(this, "_ZN7S1473C33v82Ev");}
void  S1473C3 ::v83(){vfunc_called(this, "_ZN7S1473C33v83Ev");}
void  S1473C3 ::v84(){vfunc_called(this, "_ZN7S1473C33v84Ev");}
void  S1473C3 ::v85(){vfunc_called(this, "_ZN7S1473C33v85Ev");}
void  S1473C3 ::v86(){vfunc_called(this, "_ZN7S1473C33v86Ev");}
void  S1473C3 ::v87(){vfunc_called(this, "_ZN7S1473C33v87Ev");}
void  S1473C3 ::v88(){vfunc_called(this, "_ZN7S1473C33v88Ev");}
void  S1473C3 ::v89(){vfunc_called(this, "_ZN7S1473C33v89Ev");}
void  S1473C3 ::v90(){vfunc_calle