// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S1407C5_nt  {
  int s1407c5f0[2];
  void  mf1407c5(); // _ZN10S1407C5_nt8mf1407c5Ev
};
//SIG(-1 S1407C5_nt) C1{ m Fi[2]}


void  S1407C5_nt ::mf1407c5(){}

//skip512 S1407C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C4_nt  {
  int s1407c4f0;
  __tsi64 s1407c4f1;
  void *s1407c4f2[4];
  int s1407c4f3[2];
  void *s1407c4f4;
  ::S1407C5_nt s1407c4f5;
  void *s1407c4f6[2];
  virtual  ~S1407C4_nt(); // _ZN10S1407C4_ntD1Ev
  virtual void  v4(); // _ZN10S1407C4_nt2v4Ev
  virtual void  v5(); // _ZN10S1407C4_nt2v5Ev
  virtual void  v6(); // _ZN10S1407C4_nt2v6Ev
  virtual void  v7(); // _ZN10S1407C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1407C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1407C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1407C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1407C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1407C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1407C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1407C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1407C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1407C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1407C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1407C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1407C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1407C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1407C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1407C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1407C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1407C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1407C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1407C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1407C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1407C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1407C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1407C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1407C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1407C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1407C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1407C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1407C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1407C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1407C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1407C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1407C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1407C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1407C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1407C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1407C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1407C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1407C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1407C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1407C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1407C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1407C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1407C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1407C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1407C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1407C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1407C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1407C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1407C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1407C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1407C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1407C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1407C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1407C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1407C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1407C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1407C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1407C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1407C4_nt3v66Ev
  virtual void  v67(); // _ZN10S1407C4_nt3v67Ev
  S1407C4_nt(); // tgen
};
//SIG(-1 S1407C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1407C4_nt ::~S1407C4_nt(){ note_dtor("S1407C4_nt", this);}
void  S1407C4_nt ::v4(){vfunc_called(this, "_ZN10S1407C4_nt2v4Ev");}
void  S1407C4_nt ::v5(){vfunc_called(this, "_ZN10S1407C4_nt2v5Ev");}
void  S1407C4_nt ::v6(){vfunc_called(this, "_ZN10S1407C4_nt2v6Ev");}
void  S1407C4_nt ::v7(){vfunc_called(this, "_ZN10S1407C4_nt2v7Ev");}
void  S1407C4_nt ::v8(){vfunc_called(this, "_ZN10S1407C4_nt2v8Ev");}
void  S1407C4_nt ::v9(){vfunc_called(this, "_ZN10S1407C4_nt2v9Ev");}
void  S1407C4_nt ::v10(){vfunc_called(this, "_ZN10S1407C4_nt3v10Ev");}
void  S1407C4_nt ::v11(){vfunc_called(this, "_ZN10S1407C4_nt3v11Ev");}
void  S1407C4_nt ::v12(){vfunc_called(this, "_ZN10S1407C4_nt3v12Ev");}
void  S1407C4_nt ::v13(){vfunc_called(this, "_ZN10S1407C4_nt3v13Ev");}
void  S1407C4_nt ::v14(){vfunc_called(this, "_ZN10S1407C4_nt3v14Ev");}
void  S1407C4_nt ::v15(){vfunc_called(this, "_ZN10S1407C4_nt3v15Ev");}
void  S1407C4_nt ::v16(){vfunc_called(this, "_ZN10S1407C4_nt3v16Ev");}
void  S1407C4_nt ::v17(){vfunc_called(this, "_ZN10S1407C4_nt3v17Ev");}
void  S1407C4_nt ::v18(){vfunc_called(this, "_ZN10S1407C4_nt3v18Ev");}
void  S1407C4_nt ::v19(){vfunc_called(this, "_ZN10S1407C4_nt3v19Ev");}
void  S1407C4_nt ::v20(){vfunc_called(this, "_ZN10S1407C4_nt3v20Ev");}
void  S1407C4_nt ::v21(){vfunc_called(this, "_ZN10S1407C4_nt3v21Ev");}
void  S1407C4_nt ::v22(){vfunc_called(this, "_ZN10S1407C4_nt3v22Ev");}
void  S1407C4_nt ::v23(){vfunc_called(this, "_ZN10S1407C4_nt3v23Ev");}
void  S1407C4_nt ::v24(){vfunc_called(this, "_ZN10S1407C4_nt3v24Ev");}
void  S1407C4_nt ::v25(){vfunc_called(this, "_ZN10S1407C4_nt3v25Ev");}
void  S1407C4_nt ::v26(){vfunc_called(this, "_ZN10S1407C4_nt3v26Ev");}
void  S1407C4_nt ::v27(){vfunc_called(this, "_ZN10S1407C4_nt3v27Ev");}
void  S1407C4_nt ::v28(){vfunc_called(this, "_ZN10S1407C4_nt3v28Ev");}
void  S1407C4_nt ::v29(){vfunc_called(this, "_ZN10S1407C4_nt3v29Ev");}
void  S1407C4_nt ::v30(){vfunc_called(this, "_ZN10S1407C4_nt3v30Ev");}
void  S1407C4_nt ::v31(){vfunc_called(this, "_ZN10S1407C4_nt3v31Ev");}
void  S1407C4_nt ::v32(){vfunc_called(this, "_ZN10S1407C4_nt3v32Ev");}
void  S1407C4_nt ::v33(){vfunc_called(this, "_ZN10S1407C4_nt3v33Ev");}
void  S1407C4_nt ::v34(){vfunc_called(this, "_ZN10S1407C4_nt3v34Ev");}
void  S1407C4_nt ::v35(){vfunc_called(this, "_ZN10S1407C4_nt3v35Ev");}
void  S1407C4_nt ::v36(){vfunc_called(this, "_ZN10S1407C4_nt3v36Ev");}
void  S1407C4_nt ::v37(){vfunc_called(this, "_ZN10S1407C4_nt3v37Ev");}
void  S1407C4_nt ::v38(){vfunc_called(this, "_ZN10S1407C4_nt3v38Ev");}
void  S1407C4_nt ::v39(){vfunc_called(this, "_ZN10S1407C4_nt3v39Ev");}
void  S1407C4_nt ::v40(){vfunc_called(this, "_ZN10S1407C4_nt3v40Ev");}
void  S1407C4_nt ::v41(){vfunc_called(this, "_ZN10S1407C4_nt3v41Ev");}
void  S1407C4_nt ::v42(){vfunc_called(this, "_ZN10S1407C4_nt3v42Ev");}
void  S1407C4_nt ::v43(){vfunc_called(this, "_ZN10S1407C4_nt3v43Ev");}
void  S1407C4_nt ::v44(){vfunc_called(this, "_ZN10S1407C4_nt3v44Ev");}
void  S1407C4_nt ::v45(){vfunc_called(this, "_ZN10S1407C4_nt3v45Ev");}
void  S1407C4_nt ::v46(){vfunc_called(this, "_ZN10S1407C4_nt3v46Ev");}
void  S1407C4_nt ::v47(){vfunc_called(this, "_ZN10S1407C4_nt3v47Ev");}
void  S1407C4_nt ::v48(){vfunc_called(this, "_ZN10S1407C4_nt3v48Ev");}
void  S1407C4_nt ::v49(){vfunc_called(this, "_ZN10S1407C4_nt3v49Ev");}
void  S1407C4_nt ::v50(){vfunc_called(this, "_ZN10S1407C4_nt3v50Ev");}
void  S1407C4_nt ::v51(){vfunc_called(this, "_ZN10S1407C4_nt3v51Ev");}
void  S1407C4_nt ::v52(){vfunc_called(this, "_ZN10S1407C4_nt3v52Ev");}
void  S1407C4_nt ::v53(){vfunc_called(this, "_ZN10S1407C4_nt3v53Ev");}
void  S1407C4_nt ::v54(){vfunc_called(this, "_ZN10S1407C4_nt3v54Ev");}
void  S1407C4_nt ::v55(){vfunc_called(this, "_ZN10S1407C4_nt3v55Ev");}
void  S1407C4_nt ::v56(){vfunc_called(this, "_ZN10S1407C4_nt3v56Ev");}
void  S1407C4_nt ::v57(){vfunc_called(this, "_ZN10S1407C4_nt3v57Ev");}
void  S1407C4_nt ::v58(){vfunc_called(this, "_ZN10S1407C4_nt3v58Ev");}
void  S1407C4_nt ::v59(){vfunc_called(this, "_ZN10S1407C4_nt3v59Ev");}
void  S1407C4_nt ::v60(){vfunc_called(this, "_ZN10S1407C4_nt3v60Ev");}
void  S1407C4_nt ::v61(){vfunc_called(this, "_ZN10S1407C4_nt3v61Ev");}
void  S1407C4_nt ::v62(){vfunc_called(this, "_ZN10S1407C4_nt3v62Ev");}
void  S1407C4_nt ::v63(){vfunc_called(this, "_ZN10S1407C4_nt3v63Ev");}
void  S1407C4_nt ::v64(){vfunc_called(this, "_ZN10S1407C4_nt3v64Ev");}
void  S1407C4_nt ::v65(){vfunc_called(this, "_ZN10S1407C4_nt3v65Ev");}
void  S1407C4_nt ::v66(){vfunc_called(this, "_ZN10S1407C4_nt3v66Ev");}
void  S1407C4_nt ::v67(){vfunc_called(this, "_ZN10S1407C4_nt3v67Ev");}
S1407C4_nt ::S1407C4_nt(){ note_ctor("S1407C4_nt", this);} // tgen

//skip512 S1407C4_nt

#else // __cplusplus

extern void _ZN10S1407C4_ntC1Ev();
extern void _ZN10S1407C4_ntD1Ev();
Name_Map name_map_S1407C4_nt[] = {
  NSPAIR(_ZN10S1407C4_ntC1Ev),
  NSPAIR(_ZN10S1407C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1407C4_nt[];
extern void _ZN10S1407C4_ntD1Ev();
extern void _ZN10S1407C4_ntD0Ev();
extern void _ZN10S1407C4_nt2v4Ev();
extern void _ZN10S1407C4_nt2v5Ev();
extern void _ZN10S1407C4_nt2v6Ev();
extern void _ZN10S1407C4_nt2v7Ev();
extern void _ZN10S1407C4_nt2v8Ev();
extern void _ZN10S1407C4_nt2v9Ev();
extern void _ZN10S1407C4_nt3v10Ev();
extern void _ZN10S1407C4_nt3v11Ev();
extern void _ZN10S1407C4_nt3v12Ev();
extern void _ZN10S1407C4_nt3v13Ev();
extern void _ZN10S1407C4_nt3v14Ev();
extern void _ZN10S1407C4_nt3v15Ev();
extern void _ZN10S1407C4_nt3v16Ev();
extern void _ZN10S1407C4_nt3v17Ev();
extern void _ZN10S1407C4_nt3v18Ev();
extern void _ZN10S1407C4_nt3v19Ev();
extern void _ZN10S1407C4_nt3v20Ev();
extern void _ZN10S1407C4_nt3v21Ev();
extern void _ZN10S1407C4_nt3v22Ev();
extern void _ZN10S1407C4_nt3v23Ev();
extern void _ZN10S1407C4_nt3v24Ev();
extern void _ZN10S1407C4_nt3v25Ev();
extern void _ZN10S1407C4_nt3v26Ev();
extern void _ZN10S1407C4_nt3v27Ev();
extern void _ZN10S1407C4_nt3v28Ev();
extern void _ZN10S1407C4_nt3v29Ev();
extern void _ZN10S1407C4_nt3v30Ev();
extern void _ZN10S1407C4_nt3v31Ev();
extern void _ZN10S1407C4_nt3v32Ev();
extern void _ZN10S1407C4_nt3v33Ev();
extern void _ZN10S1407C4_nt3v34Ev();
extern void _ZN10S1407C4_nt3v35Ev();
extern void _ZN10S1407C4_nt3v36Ev();
extern void _ZN10S1407C4_nt3v37Ev();
extern void _ZN10S1407C4_nt3v38Ev();
extern void _ZN10S1407C4_nt3v39Ev();
extern void _ZN10S1407C4_nt3v40Ev();
extern void _ZN10S1407C4_nt3v41Ev();
extern void _ZN10S1407C4_nt3v42Ev();
extern void _ZN10S1407C4_nt3v43Ev();
extern void _ZN10S1407C4_nt3v44Ev();
extern void _ZN10S1407C4_nt3v45Ev();
extern void _ZN10S1407C4_nt3v46Ev();
extern void _ZN10S1407C4_nt3v47Ev();
extern void _ZN10S1407C4_nt3v48Ev();
extern void _ZN10S1407C4_nt3v49Ev();
extern void _ZN10S1407C4_nt3v50Ev();
extern void _ZN10S1407C4_nt3v51Ev();
extern void _ZN10S1407C4_nt3v52Ev();
extern void _ZN10S1407C4_nt3v53Ev();
extern void _ZN10S1407C4_nt3v54Ev();
extern void _ZN10S1407C4_nt3v55Ev();
extern void _ZN10S1407C4_nt3v56Ev();
extern void _ZN10S1407C4_nt3v57Ev();
extern void _ZN10S1407C4_nt3v58Ev();
extern void _ZN10S1407C4_nt3v59Ev();
extern void _ZN10S1407C4_nt3v60Ev();
extern void _ZN10S1407C4_nt3v61Ev();
extern void _ZN10S1407C4_nt3v62Ev();
extern void _ZN10S1407C4_nt3v63Ev();
extern void _ZN10S1407C4_nt3v64Ev();
extern void _ZN10S1407C4_nt3v65Ev();
extern void _ZN10S1407C4_nt3v66Ev();
extern void _ZN10S1407C4_nt3v67Ev();
static  VTBL_ENTRY vtc_S1407C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1407C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1407C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI10S1407C4_nt[];
VTBL_ENTRY *P__ZTI10S1407C4_nt = _ZTI10S1407C4_nt; 
extern  VTBL_ENTRY _ZTV10S1407C4_nt[];
Class_Descriptor cd_S1407C4_nt = {  "S1407C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1407C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1407C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1407C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C8_nt  {
  void *s1407c8f0;
  int s1407c8f1[2];
  void  mf1407c8(); // _ZN10S1407C8_nt8mf1407c8Ev
};
//SIG(-1 S1407C8_nt) C1{ m Fp Fi[2]}


void  S1407C8_nt ::mf1407c8(){}

//skip512 S1407C8_nt

#else // __cplusplus

Class_Descriptor cd_S1407C8_nt = {  "S1407C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C7_nt  : S1407C8_nt {
};
//SIG(-1 S1407C7_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1407C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1407C8_nt;
static Base_Class bases_S1407C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1407C7_nt = {  "S1407C7_nt", // class name
  bases_S1407C7_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C6_nt  : S1407C7_nt {
};
//SIG(-1 S1407C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1407C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1407C8_nt;
extern Class_Descriptor cd_S1407C7_nt;
static Base_Class bases_S1407C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1407C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C9_nt  {
  int s1407c9f0;
  void  mf1407c9(); // _ZN10S1407C9_nt8mf1407c9Ev
};
//SIG(-1 S1407C9_nt) C1{ m Fi}


void  S1407C9_nt ::mf1407c9(){}

//skip512 S1407C9_nt

#else // __cplusplus

Class_Descriptor cd_S1407C9_nt = {  "S1407C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C13  : S1407C8_nt {
};
//SIG(-1 S1407C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1407C13()
{
  extern Class_Descriptor cd_S1407C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1407C13, buf);
    S1407C13 &lv = *(new (buf) S1407C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1407C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1407C13)");
    check_base_class_offset(lv, (S1407C8_nt*), 0, "S1407C13");
    test_class_info(&lv, &cd_S1407C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1407C13(Test_S1407C13, "S1407C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1407C8_nt;
static Base_Class bases_S1407C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1407C13 = {  "S1407C13", // class name
  bases_S1407C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C12  : S1407C13 {
};
//SIG(-1 S1407C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1407C12()
{
  extern Class_Descriptor cd_S1407C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1407C12, buf);
    S1407C12 &lv = *(new (buf) S1407C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1407C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1407C12)");
    check_base_class_offset(lv, (S1407C8_nt*)(S1407C13*), 0, "S1407C12");
    check_base_class_offset(lv, (S1407C13*), 0, "S1407C12");
    test_class_info(&lv, &cd_S1407C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1407C12(Test_S1407C12, "S1407C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1407C8_nt;
extern Class_Descriptor cd_S1407C13;
static Base_Class bases_S1407C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1407C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1407C12 = {  "S1407C12", // class name
  bases_S1407C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C14_nt  {
  int s1407c14f0[3];
  void  mf1407c14(); // _ZN11S1407C14_nt9mf1407c14Ev
};
//SIG(-1 S1407C14_nt) C1{ m Fi[3]}


void  S1407C14_nt ::mf1407c14(){}

//skip512 S1407C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C19  : S1407C8_nt {
};
//SIG(-1 S1407C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1407C19()
{
  extern Class_Descriptor cd_S1407C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1407C19, buf);
    S1407C19 &lv = *(new (buf) S1407C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1407C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1407C19)");
    check_base_class_offset(lv, (S1407C8_nt*), 0, "S1407C19");
    test_class_info(&lv, &cd_S1407C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1407C19(Test_S1407C19, "S1407C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1407C8_nt;
static Base_Class bases_S1407C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1407C19 = {  "S1407C19", // class name
  bases_S1407C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C18  : S1407C19 {
};
//SIG(-1 S1407C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1407C18()
{
  extern Class_Descriptor cd_S1407C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1407C18, buf);
    S1407C18 &lv = *(new (buf) S1407C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1407C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1407C18)");
    check_base_class_offset(lv, (S1407C8_nt*)(S1407C19*), 0, "S1407C18");
    check_base_class_offset(lv, (S1407C19*), 0, "S1407C18");
    test_class_info(&lv, &cd_S1407C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1407C18(Test_S1407C18, "S1407C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1407C8_nt;
extern Class_Descriptor cd_S1407C19;
static Base_Class bases_S1407C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1407C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1407C18 = {  "S1407C18", // class name
  bases_S1407C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C3_nt  : S1407C4_nt {
  ::S1407C6_nt s1407c3f0;
  ::S1407C6_nt s1407c3f1;
  ::S1407C9_nt s1407c3f2;
  int s1407c3f3;
  char s1407c3f4[4];
  void *s1407c3f5[2];
  ::S1407C6_nt s1407c3f6;
  unsigned int s1407c3f7:1;
  unsigned int s1407c3f8:1;
  unsigned int s1407c3f9:1;
  unsigned int s1407c3f10:1;
  unsigned int s1407c3f11:1;
  unsigned int s1407c3f12:1;
  unsigned int s1407c3f13:1;
  unsigned int s1407c3f14:1;
  unsigned int s1407c3f15:1;
  unsigned int s1407c3f16:1;
  unsigned int s1407c3f17:1;
  unsigned int s1407c3f18:1;
  unsigned int s1407c3f19:1;
  unsigned int s1407c3f20:1;
  unsigned int s1407c3f21:1;
  unsigned int s1407c3f22:1;
  unsigned int s1407c3f23:1;
  unsigned int s1407c3f24:1;
  unsigned int s1407c3f25:1;
  unsigned int s1407c3f26:1;
  unsigned int s1407c3f27:1;
  unsigned int s1407c3f28:1;
  unsigned int s1407c3f29:1;
  unsigned int s1407c3f30:1;
  unsigned int s1407c3f31:1;
  unsigned int s1407c3f32:1;
  unsigned int s1407c3f33:1;
  unsigned int s1407c3f34:1;
  unsigned int s1407c3f35:1;
  unsigned int s1407c3f36:1;
  unsigned int s1407c3f37:1;
  unsigned int s1407c3f38:1;
  unsigned int s1407c3f39:1;
  unsigned int s1407c3f40:1;
  unsigned int s1407c3f41:1;
  unsigned int s1407c3f42:1;
  unsigned int s1407c3f43:1;
  unsigned int s1407c3f44:1;
  unsigned int s1407c3f45:1;
  unsigned int s1407c3f46:1;
  unsigned int s1407c3f47:1;
  unsigned int s1407c3f48:1;
  unsigned int s1407c3f49:1;
  unsigned int s1407c3f50:1;
  unsigned int s1407c3f51:1;
  unsigned int s1407c3f52:1;
  unsigned int s1407c3f53:1;
  unsigned int s1407c3f54:1;
  unsigned int s1407c3f55:1;
  unsigned int s1407c3f56:1;
  unsigned int s1407c3f57:1;
  unsigned int s1407c3f58:1;
  unsigned int s1407c3f59:1;
  unsigned int s1407c3f60:1;
  unsigned int s1407c3f61:1;
  unsigned int s1407c3f62:1;
  unsigned int s1407c3f63:1;
  unsigned int s1407c3f64:1;
  unsigned int s1407c3f65:1;
  unsigned int s1407c3f66:1;
  unsigned int s1407c3f67:1;
  unsigned int s1407c3f68:1;
  unsigned int s1407c3f69:1;
  unsigned int s1407c3f70:1;
  unsigned int s1407c3f71:1;
  unsigned int s1407c3f72:1;
  unsigned int s1407c3f73:1;
  unsigned int s1407c3f74:1;
  unsigned int s1407c3f75:1;
  unsigned int s1407c3f76:1;
  unsigned int s1407c3f77:1;
  unsigned int s1407c3f78:1;
  unsigned int s1407c3f79:1;
  unsigned int s1407c3f80:1;
  unsigned int s1407c3f81:1;
  unsigned int s1407c3f82:1;
  unsigned int s1407c3f83:1;
  int s1407c3f84[5];
  void *s1407c3f85[2];
  int s1407c3f86[3];
  ::S1407C5_nt s1407c3f87;
  ::S1407C5_nt s1407c3f88;
  ::S1407C5_nt s1407c3f89;
  ::S1407C12 s1407c3f90;
  ::S1407C12 s1407c3f91;
  int s1407c3f92;
  void *s1407c3f93[2];
  ::S1407C14_nt s1407c3f94;
  ::S1407C14_nt s1407c3f95;
  ::S1407C14_nt s1407c3f96;
  ::S1407C14_nt s1407c3f97;
  void *s1407c3f98;
  ::S1407C5_nt s1407c3f99;
  ::S1407C12 s1407c3f100;
  ::S1407C14_nt s1407c3f101;
  ::S1407C14_nt s1407c3f102;
  int s1407c3f103;
  ::S1407C14_nt s1407c3f104;
  ::S1407C14_nt s1407c3f105;
  void *s1407c3f106;
  int s1407c3f107;
  char s1407c3f108;
  ::S1407C14_nt s1407c3f109;
  ::S1407C14_nt s1407c3f110;
  void *s1407c3f111;
  int s1407c3f112;
  void *s1407c3f113;
  ::S1407C12 s1407c3f114;
  ::S1407C18 s1407c3f115;
  ::S1407C18 s1407c3f116;
  virtual  ~S1407C3_nt(); // _ZN10S1407C3_ntD1Ev
  virtual void  v68(); // _ZN10S1407C3_nt3v68Ev
  virtual void  v69(); // _ZN10S1407C3_nt3v69Ev
  virtual void  v70(); // _ZN10S1407C3_nt3v70Ev
  virtual void  v71(); // _ZN10S1407C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1407C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1407C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1407C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1407C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1407C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1407C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1407C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1407C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1407C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1407C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1407C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1407C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1407C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1407C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1407C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1407C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1407C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1407C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1407C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1407C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1407C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1407C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1407C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1407C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1407C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1407C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1407C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1407C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1407C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1407C3_nt4v101Ev
  virtual void  v102(); // _ZN10S1407C3_nt4v102Ev
  virtual void  v103(); // _ZN10S1407C3_nt4v103Ev
  virtual void  v104(); // _ZN10S1407C3_nt4v104Ev
  virtual void  v105(); // _ZN10S1407C3_nt4v105Ev
  virtual void  v106(); // _ZN10S1407C3_nt4v106Ev
  virtual void  v107(); // _ZN10S1407C3_nt4v107Ev
  virtual void  v108(); // _ZN10S1407C3_nt4v108Ev
  virtual void  v109(); // _ZN10S1407C3_nt4v109Ev
  virtual void  v110(); // _ZN10S1407C3_nt4v110Ev
  virtual void  v111(); // _ZN10S1407C3_nt4v111Ev
  virtual void  v112(); // _ZN10S1407C3_nt4v112Ev
  virtual void  v113(); // _ZN10S1407C3_nt4v113Ev
  virtual void  v114(); // _ZN10S1407C3_nt4v114Ev
  virtual void  v115(); // _ZN10S1407C3_nt4v115Ev
  virtual void  v116(); // _ZN10S1407C3_nt4v116Ev
  virtual void  v117(); // _ZN10S1407C3_nt4v117Ev
  virtual void  v118(); // _ZN10S1407C3_nt4v118Ev
  virtual void  v119(); // _ZN10S1407C3_nt4v119Ev
  virtual void  v120(); // _ZN10S1407C3_nt4v120Ev
  virtual void  v121(); // _ZN10S1407C3_nt4v121Ev
  virtual void  v122(); // _ZN10S1407C3_nt4v122Ev
  virtual void  v123(); // _ZN10S1407C3_nt4v123Ev
  virtual void  v124(); // _ZN10S1407C3_nt4v124Ev
  virtual void  v125(); // _ZN10S1407C3_nt4v125Ev
  virtual void  v126(); // _ZN10S1407C3_nt4v126Ev
  virtual void  v127(); // _ZN10S1407C3_nt4v127Ev
  virtual void  v128(); // _ZN10S1407C3_nt4v128Ev
  virtual void  v129(); // _ZN10S1407C3_nt4v129Ev
  virtual void  v130(); // _ZN10S1407C3_nt4v130Ev
  virtual void  v131(); // _ZN10S1407C3_nt4v131Ev
  virtual void  v132(); // _ZN10S1407C3_nt4v132Ev
  virtual void  v133(); // _ZN10S1407C3_nt4v133Ev
  virtual void  v134(); // _ZN10S1407C3_nt4v134Ev
  virtual void  v135(); // _ZN10S1407C3_nt4v135Ev
  virtual void  v136(); // _ZN10S1407C3_nt4v136Ev
  virtual void  v137(); // _ZN10S1407C3_nt4v137Ev
  virtual void  v138(); // _ZN10S1407C3_nt4v138Ev
  virtual void  v139(); // _ZN10S1407C3_nt4v139Ev
  virtual void  v140(); // _ZN10S1407C3_nt4v140Ev
  virtual void  v141(); // _ZN10S1407C3_nt4v141Ev
  virtual void  v142(); // _ZN10S1407C3_nt4v142Ev
  virtual void  v143(); // _ZN10S1407C3_nt4v143Ev
  virtual void  v144(); // _ZN10S1407C3_nt4v144Ev
  virtual void  v145(); // _ZN10S1407C3_nt4v145Ev
  virtual void  v146(); // _ZN10S1407C3_nt4v146Ev
  virtual void  v147(); // _ZN10S1407C3_nt4v147Ev
  virtual void  v148(); // _ZN10S1407C3_nt4v148Ev
  virtual void  v149(); // _ZN10S1407C3_nt4v149Ev
  virtual void  v150(); // _ZN10S1407C3_nt4v150Ev
  virtual void  v151(); // _ZN10S1407C3_nt4v151Ev
  virtual void  v152(); // _ZN10S1407C3_nt4v152Ev
  virtual void  v153(); // _ZN10S1407C3_nt4v153Ev
  virtual void  v154(); // _ZN10S1407C3_nt4v154Ev
  virtual void  v155(); // _ZN10S1407C3_nt4v155Ev
  virtual void  v156(); // _ZN10S1407C3_nt4v156Ev
  virtual void  v157(); // _ZN10S1407C3_nt4v157Ev
  virtual void  v158(); // _ZN10S1407C3_nt4v158Ev
  virtual void  v159(); // _ZN10S1407C3_nt4v159Ev
  virtual void  v160(); // _ZN10S1407C3_nt4v160Ev
  virtual void  v161(); // _ZN10S1407C3_nt4v161Ev
  virtual void  v162(); // _ZN10S1407C3_nt4v162Ev
  virtual void  v163(); // _ZN10S1407C3_nt4v163Ev
  virtual void  v164(); // _ZN10S1407C3_nt4v164Ev
  virtual void  v165(); // _ZN10S1407C3_nt4v165Ev
  virtual void  v166(); // _ZN10S1407C3_nt4v166Ev
  virtual void  v167(); // _ZN10S1407C3_nt4v167Ev
  virtual void  v168(); // _ZN10S1407C3_nt4v168Ev
  virtual void  v169(); // _ZN10S1407C3_nt4v169Ev
  virtual void  v170(); // _ZN10S1407C3_nt4v170Ev
  virtual void  v171(); // _ZN10S1407C3_nt4v171Ev
  virtual void  v172(); // _ZN10S1407C3_nt4v172Ev
  virtual void  v173(); // _ZN10S1407C3_nt4v173Ev
  virtual void  v174(); // _ZN10S1407C3_nt4v174Ev
  virtual void  v175(); // _ZN10S1407C3_nt4v175Ev
  virtual void  v176(); // _ZN10S1407C3_nt4v176Ev
  virtual void  v177(); // _ZN10S1407C3_nt4v177Ev
  virtual void  v178(); // _ZN10S1407C3_nt4v178Ev
  virtual void  v179(); // _ZN10S1407C3_nt4v179Ev
  virtual void  v180(); // _ZN10S1407C3_nt4v180Ev
  virtual void  v181(); // _ZN10S1407C3_nt4v181Ev
  virtual void  v182(); // _ZN10S1407C3_nt4v182Ev
  virtual void  v183(); // _ZN10S1407C3_nt4v183Ev
  virtual void  v184(); // _ZN10S1407C3_nt4v184Ev
  virtual void  v185(); // _ZN10S1407C3_nt4v185Ev
  virtual void  v186(); // _ZN10S1407C3_nt4v186Ev
  virtual void  v187(); // _ZN10S1407C3_nt4v187Ev
  virtual void  v188(); // _ZN10S1407C3_nt4v188Ev
  virtual void  v189(); // _ZN10S1407C3_nt4v189Ev
  virtual void  v190(); // _ZN10S1407C3_nt4v190Ev
  virtual void  v191(); // _ZN10S1407C3_nt4v191Ev
  virtual void  v192(); // _ZN10S1407C3_nt4v192Ev
  virtual void  v193(); // _ZN10S1407C3_nt4v193Ev
  virtual void  v194(); // _ZN10S1407C3_nt4v194Ev
  virtual void  v195(); // _ZN10S1407C3_nt4v195Ev
  virtual void  v196(); // _ZN10S1407C3_nt4v196Ev
  virtual void  v197(); // _ZN10S1407C3_nt4v197Ev
  virtual void  v198(); // _ZN10S1407C3_nt4v198Ev
  virtual void  v199(); // _ZN10S1407C3_nt4v199Ev
  virtual void  v200(); // _ZN10S1407C3_nt4v200Ev
  virtual void  v201(); // _ZN10S1407C3_nt4v201Ev
  virtual void  v202(); // _ZN10S1407C3_nt4v202Ev
  virtual void  v203(); // _ZN10S1407C3_nt4v203Ev
  virtual void  v204(); // _ZN10S1407C3_nt4v204Ev
  virtual void  v205(); // _ZN10S1407C3_nt4v205Ev
  virtual void  v206(); // _ZN10S1407C3_nt4v206Ev
  virtual void  v207(); // _ZN10S1407C3_nt4v207Ev
  virtual void  v208(); // _ZN10S1407C3_nt4v208Ev
  virtual void  v209(); // _ZN10S1407C3_nt4v209Ev
  virtual void  v210(); // _ZN10S1407C3_nt4v210Ev
  S1407C3_nt(); // tgen
};
//SIG(-1 S1407C3_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S1407C3_nt ::~S1407C3_nt(){ note_dtor("S1407C3_nt", this);}
void  S1407C3_nt ::v68(){vfunc_called(this, "_ZN10S1407C3_nt3v68Ev");}
void  S1407C3_nt ::v69(){vfunc_called(this, "_ZN10S1407C3_nt3v69Ev");}
void  S1407C3_nt ::v70(){vfunc_called(this, "_ZN10S1407C3_nt3v70Ev");}
void  S1407C3_nt ::v71(){vfunc_called(this, "_ZN10S1407C3_nt3v71Ev");}
void  S1407C3_nt ::v72(){vfunc_called(this, "_ZN10S1407C3_nt3v72Ev");}
void  S1407C3_nt ::v73(){vfunc_called(this, "_ZN10S1407C3_nt3v73Ev");}
void  S1407C3_nt ::v74(){vfunc_called(this, "_ZN10S1407C3_nt3v74Ev");}
void  S1407C3_nt ::v75(){vfunc_called(this, "_ZN10S1407C3_nt3v75Ev");}
void  S1407C3_nt ::v76(){vfunc_called(this, "_ZN10S1407C3_nt3v76Ev");}
void  S1407C3_nt ::v77(){vfunc_called(this, "_ZN10S1407C3_nt3v77Ev");}
void  S1407C3_nt ::v78(){vfunc_called(this, "_ZN10S1407C3_nt3v78Ev");}
void  S1407C3_nt ::v79(){vfunc_called(this, "_ZN10S1407C3_nt3v79Ev");}
void  S1407C3_nt ::v80(){vfunc_called(this, "_ZN10S1407C3_nt3v80Ev");}
void  S1407C3_nt ::v81(){vfunc_called(this, "_ZN10S1407C3_nt3v81Ev");}
void  S1407C3_nt ::v82(){vfunc_called(this, "_ZN10S1407C3_nt3v82Ev");}
void  S1407C3_nt ::v83(){vfunc_called(this, "_ZN10S1407C3_nt3v83Ev");}
void  S1407C3_nt ::v84(){vfunc_called(this, "_ZN10S1407C3_nt3v84Ev");}
void  S1407C3_nt ::v85(){vfunc_called(this, "_ZN10S1407C3_nt3v85Ev");}
void  S1407C3_nt ::v86(){vfunc_called(this, "_ZN10S1407C3_nt3v86Ev");}
void  S1407C3_nt ::v87(){vfunc_called(this, "_ZN10S1407C3_nt3v87Ev");}
void  S1407C3_nt ::v88(){vfunc_called(this, "_ZN10S1407C3_nt3v88Ev");}
void  S1407C3_nt ::v89(){vfunc_called(this, "_ZN10S1407C3_nt3v89Ev");}
void  S1407C3_nt ::v90(){vfunc_called(this, "_ZN10S1407C3_nt3v90Ev");}
void  S1407C3_nt ::v91(){vfunc_called(this, "_ZN10S1407C3_nt3v91Ev");}
void  S1407C3_nt ::v92(){vfunc_called(this, "_ZN10S1407C3_nt3v92Ev");}
void  S1407C3_nt ::v93(){vfunc_called(this, "_ZN10S1407C3_nt3v93Ev");}
void  S1407C3_nt ::v94(){vfunc_called(this, "_ZN10S1407C3_nt3v94Ev");}
void  S1407C3_nt ::v95(){vfunc_called(this, "_ZN10S1407C3_nt3v95Ev");}
void  S1407C3_nt ::v96(){vfunc_called(this, "_ZN10S1407C3_nt3v96Ev");}
void  S1407C3_nt ::v97(){vfunc_called(this, "_ZN10S1407C3_nt3v97Ev");}
void  S1407C3_nt ::v98(){vfunc_called(this, "_ZN10S1407C3_nt3v98Ev");}
void  S1407C3_nt ::v99(){vfunc_called(this, "_ZN10S1407C3_nt3v99Ev");}
void  S1407C3_nt ::v100(){vfunc_called(this, "_ZN10S1407C3_nt4v100Ev");}
void  S1407C3_nt ::v101(){vfunc_called(this, "_ZN10S1407C3_nt4v101Ev");}
void  S1407C3_nt ::v102(){vfunc_called(this, "_ZN10S1407C3_nt4v102Ev");}
void  S1407C3_nt ::v103(){vfunc_called(this, "_ZN10S1407C3_nt4v103Ev");}
void  S1407C3_nt ::v104(){vfunc_called(this, "_ZN10S1407C3_nt4v104Ev");}
void  S1407C3_nt ::v105(){vfunc_called(this, "_ZN10S1407C3_nt4v105Ev");}
void  S1407C3_nt ::v106(){vfunc_called(this, "_ZN10S1407C3_nt4v106Ev");}
void  S1407C3_nt ::v107(){vfunc_called(this, "_ZN10S1407C3_nt4v107Ev");}
void  S1407C3_nt ::v108(){vfunc_called(this, "_ZN10S1407C3_nt4v108Ev");}
void  S1407C3_nt ::v109(){vfunc_called(this, "_ZN10S1407C3_nt4v109Ev");}
void  S1407C3_nt ::v110(){vfunc_called(this, "_ZN10S1407C3_nt4v110Ev");}
void  S1407C3_nt ::v111(){vfunc_called(this, "_ZN10S1407C3_nt4v111Ev");}
void  S1407C3_nt ::v112(){vfunc_called(this, "_ZN10S1407C3_nt4v112Ev");}
void  S1407C3_nt ::v113(){vfunc_called(this, "_ZN10S1407C3_nt4v113Ev");}
void  S1407C3_nt ::v114(){vfunc_called(this, "_ZN10S1407C3_nt4v114Ev");}
void  S1407C3_nt ::v115(){vfunc_called(this, "_ZN10S1407C3_nt4v115Ev");}
void  S1407C3_nt ::v116(){vfunc_called(this, "_ZN10S1407C3_nt4v116Ev");}
void  S1407C3_nt ::v117(){vfunc_called(this, "_ZN10S1407C3_nt4v117Ev");}
void  S1407C3_nt ::v118(){vfunc_called(this, "_ZN10S1407C3_nt4v118Ev");}
void  S1407C3_nt ::v119(){vfunc_called(this, "_ZN10S1407C3_nt4v119Ev");}
void  S1407C3_nt ::v120(){vfunc_called(this, "_ZN10S1407C3_nt4v120Ev");}
void  S1407C3_nt ::v121(){vfunc_called(this, "_ZN10S1407C3_nt4v121Ev");}
void  S1407C3_nt ::v122(){vfunc_called(this, "_ZN10S1407C3_nt4v122Ev");}
void  S1407C3_nt ::v123(){vfunc_called(this, "_ZN10S1407C3_nt4v123Ev");}
void  S1407C3_nt ::v124(){vfunc_called(this, "_ZN10S1407C3_nt4v124Ev");}
void  S1407C3_nt ::v125(){vfunc_called(this, "_ZN10S1407C3_nt4v125Ev");}
void  S1407C3_nt ::v126(){vfunc_called(this, "_ZN10S1407C3_nt4v126Ev");}
void  S1407C3_nt ::v127(){vfunc_called(this, "_ZN10S1407C3_nt4v127Ev");}
void  S1407C3_nt ::v128(){vfunc_called(this, "_ZN10S1407C3_nt4v128Ev");}
void  S1407C3_nt ::v129(){vfunc_called(this, "_ZN10S1407C3_nt4v129Ev");}
void  S1407C3_nt ::v130(){vfunc_called(this, "_ZN10S1407C3_nt4v130Ev");}
void  S1407C3_nt ::v131(){vfunc_called(this, "_ZN10S1407C3_nt4v131Ev");}
void  S1407C3_nt ::v132(){vfunc_called(this, "_ZN10S1407C3_nt4v132Ev");}
void  S1407C3_nt ::v133(){vfunc_called(this, "_ZN10S1407C3_nt4v133Ev");}
void  S1407C3_nt ::v134(){vfunc_called(this, "_ZN10S1407C3_nt4v134Ev");}
void  S1407C3_nt ::v135(){vfunc_called(this, "_ZN10S1407C3_nt4v135Ev");}
void  S1407C3_nt ::v136(){vfunc_called(this, "_ZN10S1407C3_nt4v136Ev");}
void  S1407C3_nt ::v137(){vfunc_called(this, "_ZN10S1407C3_nt4v137Ev");}
void  S1407C3_nt ::v138(){vfunc_called(this, "_ZN10S1407C3_nt4v138Ev");}
void  S1407C3_nt ::v139(){vfunc_called(this, "_ZN10S1407C3_nt4v139Ev");}
void  S1407C3_nt ::v140(){vfunc_called(this, "_ZN10S1407C3_nt4v140Ev");}
void  S1407C3_nt ::v141(){vfunc_called(this, "_ZN10S1407C3_nt4v141Ev");}
void  S1407C3_nt ::v142(){vfunc_called(this, "_ZN10S1407C3_nt4v142Ev");}
void  S1407C3_nt ::v143(){vfunc_called(this, "_ZN10S1407C3_nt4v143Ev");}
void  S1407C3_nt ::v144(){vfunc_called(this, "_ZN10S1407C3_nt4v144Ev");}
void  S1407C3_nt ::v145(){vfunc_called(this, "_ZN10S1407C3_nt4v145Ev");}
void  S1407C3_nt ::v146(){vfunc_called(this, "_ZN10S1407C3_nt4v146Ev");}
void  S1407C3_nt ::v147(){vfunc_called(this, "_ZN10S1407C3_nt4v147Ev");}
void  S1407C3_nt ::v148(){vfunc_called(this, "_ZN10S1407C3_nt4v148Ev");}
void  S1407C3_nt ::v149(){vfunc_called(this, "_ZN10S1407C3_nt4v149Ev");}
void  S1407C3_nt ::v150(){vfunc_called(this, "_ZN10S1407C3_nt4v150Ev");}
void  S1407C3_nt ::v151(){vfunc_called(this, "_ZN10S1407C3_nt4v151Ev");}
void  S1407C3_nt ::v152(){vfunc_called(this, "_ZN10S1407C3_nt4v152Ev");}
void  S1407C3_nt ::v153(){vfunc_called(this, "_ZN10S1407C3_nt4v153Ev");}
void  S1407C3_nt ::v154(){vfunc_called(this, "_ZN10S1407C3_nt4v154Ev");}
void  S1407C3_nt ::v155(){vfunc_called(this, "_ZN10S1407C3_nt4v155Ev");}
void  S1407C3_nt ::v156(){vfunc_called(this, "_ZN10S1407C3_nt4v156Ev");}
void  S1407C3_nt ::v157(){vfunc_called(this, "_ZN10S1407C3_nt4v157Ev");}
void  S1407C3_nt ::v158(){vfunc_called(this, "_ZN10S1407C3_nt4v158Ev");}
void  S1407C3_nt ::v159(){vfunc_called(this, "_ZN10S1407C3_nt4v159Ev");}
void  S1407C3_nt ::v160(){vfunc_called(this, "_ZN10S1407C3_nt4v160Ev");}
void  S1407C3_nt ::v161(){vfunc_called(this, "_ZN10S1407C3_nt4v161Ev");}
void  S1407C3_nt ::v162(){vfunc_called(this, "_ZN10S1407C3_nt4v162Ev");}
void  S1407C3_nt ::v163(){vfunc_called(this, "_ZN10S1407C3_nt4v163Ev");}
void  S1407C3_nt ::v164(){vfunc_called(this, "_ZN10S1407C3_nt4v164Ev");}
void  S1407C3_nt ::v165(){vfunc_called(this, "_ZN10S1407C3_nt4v165Ev");}
void  S1407C3_nt ::v166(){vfunc_called(this, "_ZN10S1407C3_nt4v166Ev");}
void  S1407C3_nt ::v167(){vfunc_called(this, "_ZN10S1407C3_nt4v167Ev");}
void  S1407C3_nt ::v168(){vfunc_called(this, "_ZN10S1407C3_nt4v168Ev");}
void  S1407C3_nt ::v169(){vfunc_called(this, "_ZN10S1407C3_nt4v169Ev");}
void  S1407C3_nt ::v170(){vfunc_called(this, "_ZN10S1407C3_nt4v170Ev");}
void  S1407C3_nt ::v171(){vfunc_called(this, "_ZN10S1407C3_nt4v171Ev");}
void  S1407C3_nt ::v172(){vfunc_called(this, "_ZN10S1407C3_nt4v172Ev");}
void  S1407C3_nt ::v173(){vfunc_called(this, "_ZN10S1407C3_nt4v173Ev");}
void  S1407C3_nt ::v174(){vfunc_called(this, "_ZN10S1407C3_nt4v174Ev");}
void  S1407C3_nt ::v175(){vfunc_called(this, "_ZN10S1407C3_nt4v175Ev");}
void  S1407C3_nt ::v176(){vfunc_called(this, "_ZN10S1407C3_nt4v176Ev");}
void  S1407C3_nt ::v177(){vfunc_called(this, "_ZN10S1407C3_nt4v177Ev");}
void  S1407C3_nt ::v178(){vfunc_called(this, "_ZN10S1407C3_nt4v178Ev");}
void  S1407C3_nt ::v179(){vfunc_called(this, "_ZN10S1407C3_nt4v179Ev");}
void  S1407C3_nt ::v180(){vfunc_called(this, "_ZN10S1407C3_nt4v180Ev");}
void  S1407C3_nt ::v181(){vfunc_called(this, "_ZN10S1407C3_nt4v181Ev");}
void  S1407C3_nt ::v182(){vfunc_called(this, "_ZN10S1407C3_nt4v182Ev");}
void  S1407C3_nt ::v183(){vfunc_called(this, "_ZN10S1407C3_nt4v183Ev");}
void  S1407C3_nt ::v184(){vfunc_called(this, "_ZN10S1407C3_nt4v184Ev");}
void  S1407C3_nt ::v185(){vfunc_called(this, "_ZN10S1407C3_nt4v185Ev");}
void  S1407C3_nt ::v186(){vfunc_called(this, "_ZN10S1407C3_nt4v186Ev");}
void  S1407C3_nt ::v187(){vfunc_called(this, "_ZN10S1407C3_nt4v187Ev");}
void  S1407C3_nt ::v188(){vfunc_called(this, "_ZN10S1407C3_nt4v188Ev");}
void  S1407C3_nt ::v189(){vfunc_called(this, "_ZN10S1407C3_nt4v189Ev");}
void  S1407C3_nt ::v190(){vfunc_called(this, "_ZN10S1407C3_nt4v190Ev");}
void  S1407C3_nt ::v191(){vfunc_called(this, "_ZN10S1407C3_nt4v191Ev");}
void  S1407C3_nt ::v192(){vfunc_called(this, "_ZN10S1407C3_nt4v192Ev");}
void  S1407C3_nt ::v193(){vfunc_called(this, "_ZN10S1407C3_nt4v193Ev");}
void  S1407C3_nt ::v194(){vfunc_called(this, "_ZN10S1407C3_nt4v194Ev");}
void  S1407C3_nt ::v195(){vfunc_called(this, "_ZN10S1407C3_nt4v195Ev");}
void  S1407C3_nt ::v196(){vfunc_called(this, "_ZN10S1407C3_nt4v196Ev");}
void  S1407C3_nt ::v197(){vfunc_called(this, "_ZN10S1407C3_nt4v197Ev");}
void  S1407C3_nt ::v198(){vfunc_called(this, "_ZN10S1407C3_nt4v198Ev");}
void  S1407C3_nt ::v199(){vfunc_called(this, "_ZN10S1407C3_nt4v199Ev");}
void  S1407C3_nt ::v200(){vfunc_called(this, "_ZN10S1407C3_nt4v200Ev");}
void  S1407C3_nt ::v201(){vfunc_called(this, "_ZN10S1407C3_nt4v201Ev");}
void  S1407C3_nt ::v202(){vfunc_called(this, "_ZN10S1407C3_nt4v202Ev");}
void  S1407C3_nt ::v203(){vfunc_called(this, "_ZN10S1407C3_nt4v203Ev");}
void  S1407C3_nt ::v204(){vfunc_called(this, "_ZN10S1407C3_nt4v204Ev");}
void  S1407C3_nt ::v205(){vfunc_called(this, "_ZN10S1407C3_nt4v205Ev");}
void  S1407C3_nt ::v206(){vfunc_called(this, "_ZN10S1407C3_nt4v206Ev");}
void  S1407C3_nt ::v207(){vfunc_called(this, "_ZN10S1407C3_nt4v207Ev");}
void  S1407C3_nt ::v208(){vfunc_called(this, "_ZN10S1407C3_nt4v208Ev");}
void  S1407C3_nt ::v209(){vfunc_called(this, "_ZN10S1407C3_nt4v209Ev");}
void  S1407C3_nt ::v210(){vfunc_called(this, "_ZN10S1407C3_nt4v210Ev");}
S1407C3_nt ::S1407C3_nt(){ note_ctor("S1407C3_nt", this);} // tgen

//skip512 S1407C3_nt

#else // __cplusplus

extern void _ZN10S1407C3_ntC1Ev();
extern void _ZN10S1407C3_ntD1Ev();
Name_Map name_map_S1407C3_nt[] = {
  NSPAIR(_ZN10S1407C3_ntC1Ev),
  NSPAIR(_ZN10S1407C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1407C4_nt;
extern VTBL_ENTRY _ZTI10S1407C4_nt[];
extern  VTBL_ENTRY _ZTV10S1407C4_nt[];
static Base_Class bases_S1407C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1407C3_nt[];
extern void _ZN10S1407C3_ntD1Ev();
extern void _ZN10S1407C3_ntD0Ev();
extern void _ZN10S1407C4_nt2v4Ev();
extern void _ZN10S1407C4_nt2v5Ev();
extern void _ZN10S1407C4_nt2v6Ev();
extern void _ZN10S1407C4_nt2v7Ev();
extern void _ZN10S1407C4_nt2v8Ev();
extern void _ZN10S1407C4_nt2v9Ev();
extern void _ZN10S1407C4_nt3v10Ev();
extern void _ZN10S1407C4_nt3v11Ev();
extern void _ZN10S1407C4_nt3v12Ev();
extern void _ZN10S1407C4_nt3v13Ev();
extern void _ZN10S1407C4_nt3v14Ev();
extern void _ZN10S1407C4_nt3v15Ev();
extern void _ZN10S1407C4_nt3v16Ev();
extern void _ZN10S1407C4_nt3v17Ev();
extern void _ZN10S1407C4_nt3v18Ev();
extern void _ZN10S1407C4_nt3v19Ev();
extern void _ZN10S1407C4_nt3v20Ev();
extern void _ZN10S1407C4_nt3v21Ev();
extern void _ZN10S1407C4_nt3v22Ev();
extern void _ZN10S1407C4_nt3v23Ev();
extern void _ZN10S1407C4_nt3v24Ev();
extern void _ZN10S1407C4_nt3v25Ev();
extern void _ZN10S1407C4_nt3v26Ev();
extern void _ZN10S1407C4_nt3v27Ev();
extern void _ZN10S1407C4_nt3v28Ev();
extern void _ZN10S1407C4_nt3v29Ev();
extern void _ZN10S1407C4_nt3v30Ev();
extern void _ZN10S1407C4_nt3v31Ev();
extern void _ZN10S1407C4_nt3v32Ev();
extern void _ZN10S1407C4_nt3v33Ev();
extern void _ZN10S1407C4_nt3v34Ev();
extern void _ZN10S1407C4_nt3v35Ev();
extern void _ZN10S1407C4_nt3v36Ev();
extern void _ZN10S1407C4_nt3v37Ev();
extern void _ZN10S1407C4_nt3v38Ev();
extern void _ZN10S1407C4_nt3v39Ev();
extern void _ZN10S1407C4_nt3v40Ev();
extern void _ZN10S1407C4_nt3v41Ev();
extern void _ZN10S1407C4_nt3v42Ev();
extern void _ZN10S1407C4_nt3v43Ev();
extern void _ZN10S1407C4_nt3v44Ev();
extern void _ZN10S1407C4_nt3v45Ev();
extern void _ZN10S1407C4_nt3v46Ev();
extern void _ZN10S1407C4_nt3v47Ev();
extern void _ZN10S1407C4_nt3v48Ev();
extern void _ZN10S1407C4_nt3v49Ev();
extern void _ZN10S1407C4_nt3v50Ev();
extern void _ZN10S1407C4_nt3v51Ev();
extern void _ZN10S1407C4_nt3v52Ev();
extern void _ZN10S1407C4_nt3v53Ev();
extern void _ZN10S1407C4_nt3v54Ev();
extern void _ZN10S1407C4_nt3v55Ev();
extern void _ZN10S1407C4_nt3v56Ev();
extern void _ZN10S1407C4_nt3v57Ev();
extern void _ZN10S1407C4_nt3v58Ev();
extern void _ZN10S1407C4_nt3v59Ev();
extern void _ZN10S1407C4_nt3v60Ev();
extern void _ZN10S1407C4_nt3v61Ev();
extern void _ZN10S1407C4_nt3v62Ev();
extern void _ZN10S1407C4_nt3v63Ev();
extern void _ZN10S1407C4_nt3v64Ev();
extern void _ZN10S1407C4_nt3v65Ev();
extern void _ZN10S1407C4_nt3v66Ev();
extern void _ZN10S1407C4_nt3v67Ev();
extern void _ZN10S1407C3_nt3v68Ev();
extern void _ZN10S1407C3_nt3v69Ev();
extern void _ZN10S1407C3_nt3v70Ev();
extern void _ZN10S1407C3_nt3v71Ev();
extern void _ZN10S1407C3_nt3v72Ev();
extern void _ZN10S1407C3_nt3v73Ev();
extern void _ZN10S1407C3_nt3v74Ev();
extern void _ZN10S1407C3_nt3v75Ev();
extern void _ZN10S1407C3_nt3v76Ev();
extern void _ZN10S1407C3_nt3v77Ev();
extern void _ZN10S1407C3_nt3v78Ev();
extern void _ZN10S1407C3_nt3v79Ev();
extern void _ZN10S1407C3_nt3v80Ev();
extern void _ZN10S1407C3_nt3v81Ev();
extern void _ZN10S1407C3_nt3v82Ev();
extern void _ZN10S1407C3_nt3v83Ev();
extern void _ZN10S1407C3_nt3v84Ev();
extern void _ZN10S1407C3_nt3v85Ev();
extern void _ZN10S1407C3_nt3v86Ev();
extern void _ZN10S1407C3_nt3v87Ev();
extern void _ZN10S1407C3_nt3v88Ev();
extern void _ZN10S1407C3_nt3v89Ev();
extern void _ZN10S1407C3_nt3v90Ev();
extern void _ZN10S1407C3_nt3v91Ev();
extern void _ZN10S1407C3_nt3v92Ev();
extern void _ZN10S1407C3_nt3v93Ev();
extern void _ZN10S1407C3_nt3v94Ev();
extern void _ZN10S1407C3_nt3v95Ev();
extern void _ZN10S1407C3_nt3v96Ev();
extern void _ZN10S1407C3_nt3v97Ev();
extern void _ZN10S1407C3_nt3v98Ev();
extern void _ZN10S1407C3_nt3v99Ev();
extern void _ZN10S1407C3_nt4v100Ev();
extern void _ZN10S1407C3_nt4v101Ev();
extern void _ZN10S1407C3_nt4v102Ev();
extern void _ZN10S1407C3_nt4v103Ev();
extern void _ZN10S1407C3_nt4v104Ev();
extern void _ZN10S1407C3_nt4v105Ev();
extern void _ZN10S1407C3_nt4v106Ev();
extern void _ZN10S1407C3_nt4v107Ev();
extern void _ZN10S1407C3_nt4v108Ev();
extern void _ZN10S1407C3_nt4v109Ev();
extern void _ZN10S1407C3_nt4v110Ev();
extern void _ZN10S1407C3_nt4v111Ev();
extern void _ZN10S1407C3_nt4v112Ev();
extern void _ZN10S1407C3_nt4v113Ev();
extern void _ZN10S1407C3_nt4v114Ev();
extern void _ZN10S1407C3_nt4v115Ev();
extern void _ZN10S1407C3_nt4v116Ev();
extern void _ZN10S1407C3_nt4v117Ev();
extern void _ZN10S1407C3_nt4v118Ev();
extern void _ZN10S1407C3_nt4v119Ev();
extern void _ZN10S1407C3_nt4v120Ev();
extern void _ZN10S1407C3_nt4v121Ev();
extern void _ZN10S1407C3_nt4v122Ev();
extern void _ZN10S1407C3_nt4v123Ev();
extern void _ZN10S1407C3_nt4v124Ev();
extern void _ZN10S1407C3_nt4v125Ev();
extern void _ZN10S1407C3_nt4v126Ev();
extern void _ZN10S1407C3_nt4v127Ev();
extern void _ZN10S1407C3_nt4v128Ev();
extern void _ZN10S1407C3_nt4v129Ev();
extern void _ZN10S1407C3_nt4v130Ev();
extern void _ZN10S1407C3_nt4v131Ev();
extern void _ZN10S1407C3_nt4v132Ev();
extern void _ZN10S1407C3_nt4v133Ev();
extern void _ZN10S1407C3_nt4v134Ev();
extern void _ZN10S1407C3_nt4v135Ev();
extern void _ZN10S1407C3_nt4v136Ev();
extern void _ZN10S1407C3_nt4v137Ev();
extern void _ZN10S1407C3_nt4v138Ev();
extern void _ZN10S1407C3_nt4v139Ev();
extern void _ZN10S1407C3_nt4v140Ev();
extern void _ZN10S1407C3_nt4v141Ev();
extern void _ZN10S1407C3_nt4v142Ev();
extern void _ZN10S1407C3_nt4v143Ev();
extern void _ZN10S1407C3_nt4v144Ev();
extern void _ZN10S1407C3_nt4v145Ev();
extern void _ZN10S1407C3_nt4v146Ev();
extern void _ZN10S1407C3_nt4v147Ev();
extern void _ZN10S1407C3_nt4v148Ev();
extern void _ZN10S1407C3_nt4v149Ev();
extern void _ZN10S1407C3_nt4v150Ev();
extern void _ZN10S1407C3_nt4v151Ev();
extern void _ZN10S1407C3_nt4v152Ev();
extern void _ZN10S1407C3_nt4v153Ev();
extern void _ZN10S1407C3_nt4v154Ev();
extern void _ZN10S1407C3_nt4v155Ev();
extern void _ZN10S1407C3_nt4v156Ev();
extern void _ZN10S1407C3_nt4v157Ev();
extern void _ZN10S1407C3_nt4v158Ev();
extern void _ZN10S1407C3_nt4v159Ev();
extern void _ZN10S1407C3_nt4v160Ev();
extern void _ZN10S1407C3_nt4v161Ev();
extern void _ZN10S1407C3_nt4v162Ev();
extern void _ZN10S1407C3_nt4v163Ev();
extern void _ZN10S1407C3_nt4v164Ev();
extern void _ZN10S1407C3_nt4v165Ev();
extern void _ZN10S1407C3_nt4v166Ev();
extern void _ZN10S1407C3_nt4v167Ev();
extern void _ZN10S1407C3_nt4v168Ev();
extern void _ZN10S1407C3_nt4v169Ev();
extern void _ZN10S1407C3_nt4v170Ev();
extern void _ZN10S1407C3_nt4v171Ev();
extern void _ZN10S1407C3_nt4v172Ev();
extern void _ZN10S1407C3_nt4v173Ev();
extern void _ZN10S1407C3_nt4v174Ev();
extern void _ZN10S1407C3_nt4v175Ev();
extern void _ZN10S1407C3_nt4v176Ev();
extern void _ZN10S1407C3_nt4v177Ev();
extern void _ZN10S1407C3_nt4v178Ev();
extern void _ZN10S1407C3_nt4v179Ev();
extern void _ZN10S1407C3_nt4v180Ev();
extern void _ZN10S1407C3_nt4v181Ev();
extern void _ZN10S1407C3_nt4v182Ev();
extern void _ZN10S1407C3_nt4v183Ev();
extern void _ZN10S1407C3_nt4v184Ev();
extern void _ZN10S1407C3_nt4v185Ev();
extern void _ZN10S1407C3_nt4v186Ev();
extern void _ZN10S1407C3_nt4v187Ev();
extern void _ZN10S1407C3_nt4v188Ev();
extern void _ZN10S1407C3_nt4v189Ev();
extern void _ZN10S1407C3_nt4v190Ev();
extern void _ZN10S1407C3_nt4v191Ev();
extern void _ZN10S1407C3_nt4v192Ev();
extern void _ZN10S1407C3_nt4v193Ev();
extern void _ZN10S1407C3_nt4v194Ev();
extern void _ZN10S1407C3_nt4v195Ev();
extern void _ZN10S1407C3_nt4v196Ev();
extern void _ZN10S1407C3_nt4v197Ev();
extern void _ZN10S1407C3_nt4v198Ev();
extern void _ZN10S1407C3_nt4v199Ev();
extern void _ZN10S1407C3_nt4v200Ev();
extern void _ZN10S1407C3_nt4v201Ev();
extern void _ZN10S1407C3_nt4v202Ev();
extern void _ZN10S1407C3_nt4v203Ev();
extern void _ZN10S1407C3_nt4v204Ev();
extern void _ZN10S1407C3_nt4v205Ev();
extern void _ZN10S1407C3_nt4v206Ev();
extern void _ZN10S1407C3_nt4v207Ev();
extern void _ZN10S1407C3_nt4v208Ev();
extern void _ZN10S1407C3_nt4v209Ev();
extern void _ZN10S1407C3_nt4v210Ev();
static  VTBL_ENTRY vtc_S1407C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1407C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1407C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v210Ev,
};
extern VTBL_ENTRY _ZTI10S1407C3_nt[];
VTBL_ENTRY *P__ZTI10S1407C3_nt = _ZTI10S1407C3_nt; 
extern  VTBL_ENTRY _ZTV10S1407C3_nt[];
Class_Descriptor cd_S1407C3_nt = {  "S1407C3_nt", // class name
  bases_S1407C3_nt, 1,
  &(vtc_S1407C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1407C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1407C3_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C23_nt  {
  ::S1407C14_nt s1407c23f0;
  ::S1407C14_nt s1407c23f1;
  char s1407c23f2;
  void  mf1407c23(); // _ZN11S1407C23_nt9mf1407c23Ev
};
//SIG(-1 S1407C23_nt) C1{ m FC2{ m Fi[3]} FC2 Fc}


void  S1407C23_nt ::mf1407c23(){}

//skip512 S1407C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C22_nt  {
  ::S1407C23_nt s1407c22f0;
  ::S1407C14_nt s1407c22f1;
  void *s1407c22f2[2];
  char s1407c22f3;
  void  mf1407c22(); // _ZN11S1407C22_nt9mf1407c22Ev
};
//SIG(-1 S1407C22_nt) C1{ m FC2{ m FC3{ m Fi[3]} FC3 Fc} FC3 Fp[2] Fc}


void  S1407C22_nt ::mf1407c22(){}

//skip512 S1407C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C25  : S1407C8_nt {
};
//SIG(-1 S1407C25) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1407C25()
{
  extern Class_Descriptor cd_S1407C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1407C25, buf);
    S1407C25 &lv = *(new (buf) S1407C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1407C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1407C25)");
    check_base_class_offset(lv, (S1407C8_nt*), 0, "S1407C25");
    test_class_info(&lv, &cd_S1407C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1407C25(Test_S1407C25, "S1407C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1407C8_nt;
static Base_Class bases_S1407C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1407C25 = {  "S1407C25", // class name
  bases_S1407C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C24  : S1407C25 {
};
//SIG(-1 S1407C24) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1407C24()
{
  extern Class_Descriptor cd_S1407C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1407C24, buf);
    S1407C24 &lv = *(new (buf) S1407C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1407C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1407C24)");
    check_base_class_offset(lv, (S1407C8_nt*)(S1407C25*), 0, "S1407C24");
    check_base_class_offset(lv, (S1407C25*), 0, "S1407C24");
    test_class_info(&lv, &cd_S1407C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1407C24(Test_S1407C24, "S1407C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1407C8_nt;
extern Class_Descriptor cd_S1407C25;
static Base_Class bases_S1407C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1407C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1407C24 = {  "S1407C24", // class name
  bases_S1407C24, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C29  : S1407C8_nt {
};
//SIG(-1 S1407C29) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1407C29()
{
  extern Class_Descriptor cd_S1407C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1407C29, buf);
    S1407C29 &lv = *(new (buf) S1407C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1407C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1407C29)");
    check_base_class_offset(lv, (S1407C8_nt*), 0, "S1407C29");
    test_class_info(&lv, &cd_S1407C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1407C29(Test_S1407C29, "S1407C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1407C8_nt;
static Base_Class bases_S1407C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1407C29 = {  "S1407C29", // class name
  bases_S1407C29, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C28  : S1407C29 {
};
//SIG(-1 S1407C28) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1407C28()
{
  extern Class_Descriptor cd_S1407C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1407C28, buf);
    S1407C28 &lv = *(new (buf) S1407C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1407C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1407C28)");
    check_base_class_offset(lv, (S1407C8_nt*)(S1407C29*), 0, "S1407C28");
    check_base_class_offset(lv, (S1407C29*), 0, "S1407C28");
    test_class_info(&lv, &cd_S1407C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1407C28(Test_S1407C28, "S1407C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1407C8_nt;
extern Class_Descriptor cd_S1407C29;
static Base_Class bases_S1407C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1407C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1407C28 = {  "S1407C28", // class name
  bases_S1407C28, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C31_nt  {
  int s1407c31f0[4];
  void  mf1407c31(); // _ZN11S1407C31_nt9mf1407c31Ev
};
//SIG(-1 S1407C31_nt) C1{ m Fi[4]}


void  S1407C31_nt ::mf1407c31(){}

//skip512 S1407C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C2_nt  : S1407C3_nt {
  unsigned int s1407c2f0:1;
  unsigned int s1407c2f1:1;
  unsigned int s1407c2f2:1;
  unsigned int s1407c2f3:1;
  unsigned int s1407c2f4:1;
  ::S1407C22_nt s1407c2f5;
  unsigned int s1407c2f6:1;
  unsigned int s1407c2f7:1;
  unsigned int s1407c2f8:1;
  unsigned int s1407c2f9:1;
  unsigned int s1407c2f10:1;
  unsigned int s1407c2f11:1;
  unsigned int s1407c2f12:1;
  unsigned int s1407c2f13:1;
  unsigned int s1407c2f14:1;
  unsigned int s1407c2f15:1;
  unsigned int s1407c2f16:1;
  unsigned int s1407c2f17:1;
  unsigned int s1407c2f18:1;
  unsigned int s1407c2f19:1;
  unsigned int s1407c2f20:1;
  unsigned int s1407c2f21:1;
  unsigned int s1407c2f22:1;
  unsigned int s1407c2f23:1;
  unsigned int s1407c2f24:1;
  unsigned int s1407c2f25:1;
  unsigned int s1407c2f26:1;
  unsigned int s1407c2f27:1;
  unsigned int s1407c2f28:1;
  unsigned int s1407c2f29:1;
  unsigned int s1407c2f30:1;
  ::S1407C24 s1407c2f31;
  ::S1407C24 s1407c2f32;
  ::S1407C24 s1407c2f33;
  ::S1407C28 s1407c2f34;
  int s1407c2f35[2];
  void *s1407c2f36[4];
  int s1407c2f37[5];
  void *s1407c2f38;
  int s1407c2f39[2];
  void *s1407c2f40[2];
  int s1407c2f41;
  ::S1407C5_nt s1407c2f42;
  ::S1407C31_nt s1407c2f43;
  void *s1407c2f44[2];
  int s1407c2f45;
  void *s1407c2f46;
  int s1407c2f47;
  virtual  ~S1407C2_nt(); // _ZN10S1407C2_ntD1Ev
  virtual void  v211(); // _ZN10S1407C2_nt4v211Ev
  virtual void  v212(); // _ZN10S1407C2_nt4v212Ev
  virtual void  v213(); // _ZN10S1407C2_nt4v213Ev
  virtual void  v214(); // _ZN10S1407C2_nt4v214Ev
  virtual void  v215(); // _ZN10S1407C2_nt4v215Ev
  virtual void  v216(); // _ZN10S1407C2_nt4v216Ev
  virtual void  v217(); // _ZN10S1407C2_nt4v217Ev
  virtual void  v218(); // _ZN10S1407C2_nt4v218Ev
  virtual void  v219(); // _ZN10S1407C2_nt4v219Ev
  virtual void  v220(); // _ZN10S1407C2_nt4v220Ev
  virtual void  v221(); // _ZN10S1407C2_nt4v221Ev
  virtual void  v222(); // _ZN10S1407C2_nt4v222Ev
  virtual void  v223(); // _ZN10S1407C2_nt4v223Ev
  virtual void  v224(); // _ZN10S1407C2_nt4v224Ev
  virtual void  v225(); // _ZN10S1407C2_nt4v225Ev
  virtual void  v226(); // _ZN10S1407C2_nt4v226Ev
  virtual void  v227(); // _ZN10S1407C2_nt4v227Ev
  virtual void  v228(); // _ZN10S1407C2_nt4v228Ev
  virtual void  v229(); // _ZN10S1407C2_nt4v229Ev
  virtual void  v230(); // _ZN10S1407C2_nt4v230Ev
  virtual void  v231(); // _ZN10S1407C2_nt4v231Ev
  virtual void  v232(); // _ZN10S1407C2_nt4v232Ev
  virtual void  v233(); // _ZN10S1407C2_nt4v233Ev
  virtual void  v234(); // _ZN10S1407C2_nt4v234Ev
  virtual void  v235(); // _ZN10S1407C2_nt4v235Ev
  virtual void  v236(); // _ZN10S1407C2_nt4v236Ev
  virtual void  v237(); // _ZN10S1407C2_nt4v237Ev
  virtual void  v238(); // _ZN10S1407C2_nt4v238Ev
  virtual void  v239(); // _ZN10S1407C2_nt4v239Ev
  virtual void  v240(); // _ZN10S1407C2_nt4v240Ev
  virtual void  v241(); // _ZN10S1407C2_nt4v241Ev
  virtual void  v242(); // _ZN10S1407C2_nt4v242Ev
  virtual void  v243(); // _ZN10S1407C2_nt4v243Ev
  virtual void  v244(); // _ZN10S1407C2_nt4v244Ev
  virtual void  v245(); // _ZN10S1407C2_nt4v245Ev
  virtual void  v246(); // _ZN10S1407C2_nt4v246Ev
  virtual void  v247(); // _ZN10S1407C2_nt4v247Ev
  S1407C2_nt(); // tgen
};
//SIG(-1 S1407C2_nt) C1{ BC2{ BC3{ vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ m FC15{ m FC11 FC11 Fc} FC11 Fp[2] Fc} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC17{ BC7}} FC16 FC16 FC18{ BC19{ BC7}} Fi[2] Fp[4] Fi[5] Fp Fi[2] Fp[2] Fi FC4 FC20{ m Fi[4]} Fp[2] Fi Fp Fi}


 S1407C2_nt ::~S1407C2_nt(){ note_dtor("S1407C2_nt", this);}
void  S1407C2_nt ::v211(){vfunc_called(this, "_ZN10S1407C2_nt4v211Ev");}
void  S1407C2_nt ::v212(){vfunc_called(this, "_ZN10S1407C2_nt4v212Ev");}
void  S1407C2_nt ::v213(){vfunc_called(this, "_ZN10S1407C2_nt4v213Ev");}
void  S1407C2_nt ::v214(){vfunc_called(this, "_ZN10S1407C2_nt4v214Ev");}
void  S1407C2_nt ::v215(){vfunc_called(this, "_ZN10S1407C2_nt4v215Ev");}
void  S1407C2_nt ::v216(){vfunc_called(this, "_ZN10S1407C2_nt4v216Ev");}
void  S1407C2_nt ::v217(){vfunc_called(this, "_ZN10S1407C2_nt4v217Ev");}
void  S1407C2_nt ::v218(){vfunc_called(this, "_ZN10S1407C2_nt4v218Ev");}
void  S1407C2_nt ::v219(){vfunc_called(this, "_ZN10S1407C2_nt4v219Ev");}
void  S1407C2_nt ::v220(){vfunc_called(this, "_ZN10S1407C2_nt4v220Ev");}
void  S1407C2_nt ::v221(){vfunc_called(this, "_ZN10S1407C2_nt4v221Ev");}
void  S1407C2_nt ::v222(){vfunc_called(this, "_ZN10S1407C2_nt4v222Ev");}
void  S1407C2_nt ::v223(){vfunc_called(this, "_ZN10S1407C2_nt4v223Ev");}
void  S1407C2_nt ::v224(){vfunc_called(this, "_ZN10S1407C2_nt4v224Ev");}
void  S1407C2_nt ::v225(){vfunc_called(this, "_ZN10S1407C2_nt4v225Ev");}
void  S1407C2_nt ::v226(){vfunc_called(this, "_ZN10S1407C2_nt4v226Ev");}
void  S1407C2_nt ::v227(){vfunc_called(this, "_ZN10S1407C2_nt4v227Ev");}
void  S1407C2_nt ::v228(){vfunc_called(this, "_ZN10S1407C2_nt4v228Ev");}
void  S1407C2_nt ::v229(){vfunc_called(this, "_ZN10S1407C2_nt4v229Ev");}
void  S1407C2_nt ::v230(){vfunc_called(this, "_ZN10S1407C2_nt4v230Ev");}
void  S1407C2_nt ::v231(){vfunc_called(this, "_ZN10S1407C2_nt4v231Ev");}
void  S1407C2_nt ::v232(){vfunc_called(this, "_ZN10S1407C2_nt4v232Ev");}
void  S1407C2_nt ::v233(){vfunc_called(this, "_ZN10S1407C2_nt4v233Ev");}
void  S1407C2_nt ::v234(){vfunc_called(this, "_ZN10S1407C2_nt4v234Ev");}
void  S1407C2_nt ::v235(){vfunc_called(this, "_ZN10S1407C2_nt4v235Ev");}
void  S1407C2_nt ::v236(){vfunc_called(this, "_ZN10S1407C2_nt4v236Ev");}
void  S1407C2_nt ::v237(){vfunc_called(this, "_ZN10S1407C2_nt4v237Ev");}
void  S1407C2_nt ::v238(){vfunc_called(this, "_ZN10S1407C2_nt4v238Ev");}
void  S1407C2_nt ::v239(){vfunc_called(this, "_ZN10S1407C2_nt4v239Ev");}
void  S1407C2_nt ::v240(){vfunc_called(this, "_ZN10S1407C2_nt4v240Ev");}
void  S1407C2_nt ::v241(){vfunc_called(this, "_ZN10S1407C2_nt4v241Ev");}
void  S1407C2_nt ::v242(){vfunc_called(this, "_ZN10S1407C2_nt4v242Ev");}
void  S1407C2_nt ::v243(){vfunc_called(this, "_ZN10S1407C2_nt4v243Ev");}
void  S1407C2_nt ::v244(){vfunc_called(this, "_ZN10S1407C2_nt4v244Ev");}
void  S1407C2_nt ::v245(){vfunc_called(this, "_ZN10S1407C2_nt4v245Ev");}
void  S1407C2_nt ::v246(){vfunc_called(this, "_ZN10S1407C2_nt4v246Ev");}
void  S1407C2_nt ::v247(){vfunc_called(this, "_ZN10S1407C2_nt4v247Ev");}
S1407C2_nt ::S1407C2_nt(){ note_ctor("S1407C2_nt", this);} // tgen

//skip512 S1407C2_nt

#else // __cplusplus

extern void _ZN10S1407C2_ntC1Ev();
extern void _ZN10S1407C2_ntD1Ev();
Name_Map name_map_S1407C2_nt[] = {
  NSPAIR(_ZN10S1407C2_ntC1Ev),
  NSPAIR(_ZN10S1407C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1407C4_nt;
extern VTBL_ENTRY _ZTI10S1407C4_nt[];
extern  VTBL_ENTRY _ZTV10S1407C4_nt[];
extern Class_Descriptor cd_S1407C3_nt;
extern VTBL_ENTRY _ZTI10S1407C3_nt[];
extern  VTBL_ENTRY _ZTV10S1407C3_nt[];
static Base_Class bases_S1407C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1407C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1407C2_nt[];
extern void _ZN10S1407C2_ntD1Ev();
extern void _ZN10S1407C2_ntD0Ev();
extern void _ZN10S1407C4_nt2v4Ev();
extern void _ZN10S1407C4_nt2v5Ev();
extern void _ZN10S1407C4_nt2v6Ev();
extern void _ZN10S1407C4_nt2v7Ev();
extern void _ZN10S1407C4_nt2v8Ev();
extern void _ZN10S1407C4_nt2v9Ev();
extern void _ZN10S1407C4_nt3v10Ev();
extern void _ZN10S1407C4_nt3v11Ev();
extern void _ZN10S1407C4_nt3v12Ev();
extern void _ZN10S1407C4_nt3v13Ev();
extern void _ZN10S1407C4_nt3v14Ev();
extern void _ZN10S1407C4_nt3v15Ev();
extern void _ZN10S1407C4_nt3v16Ev();
extern void _ZN10S1407C4_nt3v17Ev();
extern void _ZN10S1407C4_nt3v18Ev();
extern void _ZN10S1407C4_nt3v19Ev();
extern void _ZN10S1407C4_nt3v20Ev();
extern void _ZN10S1407C4_nt3v21Ev();
extern void _ZN10S1407C4_nt3v22Ev();
extern void _ZN10S1407C4_nt3v23Ev();
extern void _ZN10S1407C4_nt3v24Ev();
extern void _ZN10S1407C4_nt3v25Ev();
extern void _ZN10S1407C4_nt3v26Ev();
extern void _ZN10S1407C4_nt3v27Ev();
extern void _ZN10S1407C4_nt3v28Ev();
extern void _ZN10S1407C4_nt3v29Ev();
extern void _ZN10S1407C4_nt3v30Ev();
extern void _ZN10S1407C4_nt3v31Ev();
extern void _ZN10S1407C4_nt3v32Ev();
extern void _ZN10S1407C4_nt3v33Ev();
extern void _ZN10S1407C4_nt3v34Ev();
extern void _ZN10S1407C4_nt3v35Ev();
extern void _ZN10S1407C4_nt3v36Ev();
extern void _ZN10S1407C4_nt3v37Ev();
extern void _ZN10S1407C4_nt3v38Ev();
extern void _ZN10S1407C4_nt3v39Ev();
extern void _ZN10S1407C4_nt3v40Ev();
extern void _ZN10S1407C4_nt3v41Ev();
extern void _ZN10S1407C4_nt3v42Ev();
extern void _ZN10S1407C4_nt3v43Ev();
extern void _ZN10S1407C4_nt3v44Ev();
extern void _ZN10S1407C4_nt3v45Ev();
extern void _ZN10S1407C4_nt3v46Ev();
extern void _ZN10S1407C4_nt3v47Ev();
extern void _ZN10S1407C4_nt3v48Ev();
extern void _ZN10S1407C4_nt3v49Ev();
extern void _ZN10S1407C4_nt3v50Ev();
extern void _ZN10S1407C4_nt3v51Ev();
extern void _ZN10S1407C4_nt3v52Ev();
extern void _ZN10S1407C4_nt3v53Ev();
extern void _ZN10S1407C4_nt3v54Ev();
extern void _ZN10S1407C4_nt3v55Ev();
extern void _ZN10S1407C4_nt3v56Ev();
extern void _ZN10S1407C4_nt3v57Ev();
extern void _ZN10S1407C4_nt3v58Ev();
extern void _ZN10S1407C4_nt3v59Ev();
extern void _ZN10S1407C4_nt3v60Ev();
extern void _ZN10S1407C4_nt3v61Ev();
extern void _ZN10S1407C4_nt3v62Ev();
extern void _ZN10S1407C4_nt3v63Ev();
extern void _ZN10S1407C4_nt3v64Ev();
extern void _ZN10S1407C4_nt3v65Ev();
extern void _ZN10S1407C4_nt3v66Ev();
extern void _ZN10S1407C4_nt3v67Ev();
extern void _ZN10S1407C3_nt3v68Ev();
extern void _ZN10S1407C3_nt3v69Ev();
extern void _ZN10S1407C3_nt3v70Ev();
extern void _ZN10S1407C3_nt3v71Ev();
extern void _ZN10S1407C3_nt3v72Ev();
extern void _ZN10S1407C3_nt3v73Ev();
extern void _ZN10S1407C3_nt3v74Ev();
extern void _ZN10S1407C3_nt3v75Ev();
extern void _ZN10S1407C3_nt3v76Ev();
extern void _ZN10S1407C3_nt3v77Ev();
extern void _ZN10S1407C3_nt3v78Ev();
extern void _ZN10S1407C3_nt3v79Ev();
extern void _ZN10S1407C3_nt3v80Ev();
extern void _ZN10S1407C3_nt3v81Ev();
extern void _ZN10S1407C3_nt3v82Ev();
extern void _ZN10S1407C3_nt3v83Ev();
extern void _ZN10S1407C3_nt3v84Ev();
extern void _ZN10S1407C3_nt3v85Ev();
extern void _ZN10S1407C3_nt3v86Ev();
extern void _ZN10S1407C3_nt3v87Ev();
extern void _ZN10S1407C3_nt3v88Ev();
extern void _ZN10S1407C3_nt3v89Ev();
extern void _ZN10S1407C3_nt3v90Ev();
extern void _ZN10S1407C3_nt3v91Ev();
extern void _ZN10S1407C3_nt3v92Ev();
extern void _ZN10S1407C3_nt3v93Ev();
extern void _ZN10S1407C3_nt3v94Ev();
extern void _ZN10S1407C3_nt3v95Ev();
extern void _ZN10S1407C3_nt3v96Ev();
extern void _ZN10S1407C3_nt3v97Ev();
extern void _ZN10S1407C3_nt3v98Ev();
extern void _ZN10S1407C3_nt3v99Ev();
extern void _ZN10S1407C3_nt4v100Ev();
extern void _ZN10S1407C3_nt4v101Ev();
extern void _ZN10S1407C3_nt4v102Ev();
extern void _ZN10S1407C3_nt4v103Ev();
extern void _ZN10S1407C3_nt4v104Ev();
extern void _ZN10S1407C3_nt4v105Ev();
extern void _ZN10S1407C3_nt4v106Ev();
extern void _ZN10S1407C3_nt4v107Ev();
extern void _ZN10S1407C3_nt4v108Ev();
extern void _ZN10S1407C3_nt4v109Ev();
extern void _ZN10S1407C3_nt4v110Ev();
extern void _ZN10S1407C3_nt4v111Ev();
extern void _ZN10S1407C3_nt4v112Ev();
extern void _ZN10S1407C3_nt4v113Ev();
extern void _ZN10S1407C3_nt4v114Ev();
extern void _ZN10S1407C3_nt4v115Ev();
extern void _ZN10S1407C3_nt4v116Ev();
extern void _ZN10S1407C3_nt4v117Ev();
extern void _ZN10S1407C3_nt4v118Ev();
extern void _ZN10S1407C3_nt4v119Ev();
extern void _ZN10S1407C3_nt4v120Ev();
extern void _ZN10S1407C3_nt4v121Ev();
extern void _ZN10S1407C3_nt4v122Ev();
extern void _ZN10S1407C3_nt4v123Ev();
extern void _ZN10S1407C3_nt4v124Ev();
extern void _ZN10S1407C3_nt4v125Ev();
extern void _ZN10S1407C3_nt4v126Ev();
extern void _ZN10S1407C3_nt4v127Ev();
extern void _ZN10S1407C3_nt4v128Ev();
extern void _ZN10S1407C3_nt4v129Ev();
extern void _ZN10S1407C3_nt4v130Ev();
extern void _ZN10S1407C3_nt4v131Ev();
extern void _ZN10S1407C3_nt4v132Ev();
extern void _ZN10S1407C3_nt4v133Ev();
extern void _ZN10S1407C3_nt4v134Ev();
extern void _ZN10S1407C3_nt4v135Ev();
extern void _ZN10S1407C3_nt4v136Ev();
extern void _ZN10S1407C3_nt4v137Ev();
extern void _ZN10S1407C3_nt4v138Ev();
extern void _ZN10S1407C3_nt4v139Ev();
extern void _ZN10S1407C3_nt4v140Ev();
extern void _ZN10S1407C3_nt4v141Ev();
extern void _ZN10S1407C3_nt4v142Ev();
extern void _ZN10S1407C3_nt4v143Ev();
extern void _ZN10S1407C3_nt4v144Ev();
extern void _ZN10S1407C3_nt4v145Ev();
extern void _ZN10S1407C3_nt4v146Ev();
extern void _ZN10S1407C3_nt4v147Ev();
extern void _ZN10S1407C3_nt4v148Ev();
extern void _ZN10S1407C3_nt4v149Ev();
extern void _ZN10S1407C3_nt4v150Ev();
extern void _ZN10S1407C3_nt4v151Ev();
extern void _ZN10S1407C3_nt4v152Ev();
extern void _ZN10S1407C3_nt4v153Ev();
extern void _ZN10S1407C3_nt4v154Ev();
extern void _ZN10S1407C3_nt4v155Ev();
extern void _ZN10S1407C3_nt4v156Ev();
extern void _ZN10S1407C3_nt4v157Ev();
extern void _ZN10S1407C3_nt4v158Ev();
extern void _ZN10S1407C3_nt4v159Ev();
extern void _ZN10S1407C3_nt4v160Ev();
extern void _ZN10S1407C3_nt4v161Ev();
extern void _ZN10S1407C3_nt4v162Ev();
extern void _ZN10S1407C3_nt4v163Ev();
extern void _ZN10S1407C3_nt4v164Ev();
extern void _ZN10S1407C3_nt4v165Ev();
extern void _ZN10S1407C3_nt4v166Ev();
extern void _ZN10S1407C3_nt4v167Ev();
extern void _ZN10S1407C3_nt4v168Ev();
extern void _ZN10S1407C3_nt4v169Ev();
extern void _ZN10S1407C3_nt4v170Ev();
extern void _ZN10S1407C3_nt4v171Ev();
extern void _ZN10S1407C3_nt4v172Ev();
extern void _ZN10S1407C3_nt4v173Ev();
extern void _ZN10S1407C3_nt4v174Ev();
extern void _ZN10S1407C3_nt4v175Ev();
extern void _ZN10S1407C3_nt4v176Ev();
extern void _ZN10S1407C3_nt4v177Ev();
extern void _ZN10S1407C3_nt4v178Ev();
extern void _ZN10S1407C3_nt4v179Ev();
extern void _ZN10S1407C3_nt4v180Ev();
extern void _ZN10S1407C3_nt4v181Ev();
extern void _ZN10S1407C3_nt4v182Ev();
extern void _ZN10S1407C3_nt4v183Ev();
extern void _ZN10S1407C3_nt4v184Ev();
extern void _ZN10S1407C3_nt4v185Ev();
extern void _ZN10S1407C3_nt4v186Ev();
extern void _ZN10S1407C3_nt4v187Ev();
extern void _ZN10S1407C3_nt4v188Ev();
extern void _ZN10S1407C3_nt4v189Ev();
extern void _ZN10S1407C3_nt4v190Ev();
extern void _ZN10S1407C3_nt4v191Ev();
extern void _ZN10S1407C3_nt4v192Ev();
extern void _ZN10S1407C3_nt4v193Ev();
extern void _ZN10S1407C3_nt4v194Ev();
extern void _ZN10S1407C3_nt4v195Ev();
extern void _ZN10S1407C3_nt4v196Ev();
extern void _ZN10S1407C3_nt4v197Ev();
extern void _ZN10S1407C3_nt4v198Ev();
extern void _ZN10S1407C3_nt4v199Ev();
extern void _ZN10S1407C3_nt4v200Ev();
extern void _ZN10S1407C3_nt4v201Ev();
extern void _ZN10S1407C3_nt4v202Ev();
extern void _ZN10S1407C3_nt4v203Ev();
extern void _ZN10S1407C3_nt4v204Ev();
extern void _ZN10S1407C3_nt4v205Ev();
extern void _ZN10S1407C3_nt4v206Ev();
extern void _ZN10S1407C3_nt4v207Ev();
extern void _ZN10S1407C3_nt4v208Ev();
extern void _ZN10S1407C3_nt4v209Ev();
extern void _ZN10S1407C3_nt4v210Ev();
extern void _ZN10S1407C2_nt4v211Ev();
extern void _ZN10S1407C2_nt4v212Ev();
extern void _ZN10S1407C2_nt4v213Ev();
extern void _ZN10S1407C2_nt4v214Ev();
extern void _ZN10S1407C2_nt4v215Ev();
extern void _ZN10S1407C2_nt4v216Ev();
extern void _ZN10S1407C2_nt4v217Ev();
extern void _ZN10S1407C2_nt4v218Ev();
extern void _ZN10S1407C2_nt4v219Ev();
extern void _ZN10S1407C2_nt4v220Ev();
extern void _ZN10S1407C2_nt4v221Ev();
extern void _ZN10S1407C2_nt4v222Ev();
extern void _ZN10S1407C2_nt4v223Ev();
extern void _ZN10S1407C2_nt4v224Ev();
extern void _ZN10S1407C2_nt4v225Ev();
extern void _ZN10S1407C2_nt4v226Ev();
extern void _ZN10S1407C2_nt4v227Ev();
extern void _ZN10S1407C2_nt4v228Ev();
extern void _ZN10S1407C2_nt4v229Ev();
extern void _ZN10S1407C2_nt4v230Ev();
extern void _ZN10S1407C2_nt4v231Ev();
extern void _ZN10S1407C2_nt4v232Ev();
extern void _ZN10S1407C2_nt4v233Ev();
extern void _ZN10S1407C2_nt4v234Ev();
extern void _ZN10S1407C2_nt4v235Ev();
extern void _ZN10S1407C2_nt4v236Ev();
extern void _ZN10S1407C2_nt4v237Ev();
extern void _ZN10S1407C2_nt4v238Ev();
extern void _ZN10S1407C2_nt4v239Ev();
extern void _ZN10S1407C2_nt4v240Ev();
extern void _ZN10S1407C2_nt4v241Ev();
extern void _ZN10S1407C2_nt4v242Ev();
extern void _ZN10S1407C2_nt4v243Ev();
extern void _ZN10S1407C2_nt4v244Ev();
extern void _ZN10S1407C2_nt4v245Ev();
extern void _ZN10S1407C2_nt4v246Ev();
extern void _ZN10S1407C2_nt4v247Ev();
static  VTBL_ENTRY vtc_S1407C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1407C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1407C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v237Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v238Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v239Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v240Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v241Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v242Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v243Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v244Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v245Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v246Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v247Ev,
};
extern VTBL_ENTRY _ZTI10S1407C2_nt[];
VTBL_ENTRY *P__ZTI10S1407C2_nt = _ZTI10S1407C2_nt; 
extern  VTBL_ENTRY _ZTV10S1407C2_nt[];
Class_Descriptor cd_S1407C2_nt = {  "S1407C2_nt", // class name
  bases_S1407C2_nt, 2,
  &(vtc_S1407C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(880,656), // object size
  NSPAIRA(_ZTI10S1407C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1407C2_nt),248, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1407C1  : S1407C2_nt {
  void *s1407c1f0;
  virtual  ~S1407C1(); // _ZN7S1407C1D1Ev
  virtual void  v1(); // _ZN7S1407C12v1Ev
  virtual void  v2(); // _ZN7S1407C12v2Ev
  virtual void  v3(); // _ZN7S1407C12v3Ev
  S1407C1(); // tgen
};
//SIG(1 S1407C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ m FC16{ m FC12 FC12 Fc} FC12 Fp[2] Fc} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC17{ BC18{ BC8}} FC17 FC17 FC19{ BC20{ BC8}} Fi[2] Fp[4] Fi[5] Fp Fi[2] Fp[2] Fi FC5 FC21{ m Fi[4]} Fp[2] Fi Fp Fi} vd v1 v2 v3 Fp}


 S1407C1 ::~S1407C1(){ note_dtor("S1407C1", this);}
void  S1407C1 ::v1(){vfunc_called(this, "_ZN7S1407C12v1Ev");}
void  S1407C1 ::v2(){vfunc_called(this, "_ZN7S1407C12v2Ev");}
void  S1407C1 ::v3(){vfunc_called(this, "_ZN7S1407C12v3Ev");}
S1407C1 ::S1407C1(){ note_ctor("S1407C1", this);} // tgen

static void Test_S1407C1()
{
  extern Class_Descriptor cd_S1407C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(112,166)];
    init_test(&cd_S1407C1, buf);
    S1407C1 *dp, &lv = *(dp=new (buf) S1407C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(888,660), "sizeof(S1407C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1407C1)");
    check_base_class_offset(lv, (S1407C4_nt*)(S1407C3_nt*)(S1407C2_nt*), 0, "S1407C1");
    check_base_class_offset(lv, (S1407C3_nt*)(S1407C2_nt*), 0, "S1407C1");
    check_base_class_offset(lv, (S1407C2_nt*), 0, "S1407C1");
    check_field_offset(lv, s1407c1f0, ABISELECT(880,656), "S1407C1.s1407c1f0");
    test_class_info(&lv, &cd_S1407C1);
    dp->~S1407C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1407C1(Test_S1407C1, "S1407C1", ABISELECT(888,660));

#else // __cplusplus

extern void _ZN7S1407C1C1Ev();
extern void _ZN7S1407C1D1Ev();
Name_Map name_map_S1407C1[] = {
  NSPAIR(_ZN7S1407C1C1Ev),
  NSPAIR(_ZN7S1407C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1407C4_nt;
extern VTBL_ENTRY _ZTI10S1407C4_nt[];
extern  VTBL_ENTRY _ZTV10S1407C4_nt[];
extern Class_Descriptor cd_S1407C3_nt;
extern VTBL_ENTRY _ZTI10S1407C3_nt[];
extern  VTBL_ENTRY _ZTV10S1407C3_nt[];
extern Class_Descriptor cd_S1407C2_nt;
extern VTBL_ENTRY _ZTI10S1407C2_nt[];
extern  VTBL_ENTRY _ZTV10S1407C2_nt[];
static Base_Class bases_S1407C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1407C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1407C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1407C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1407C1[];
extern void _ZN7S1407C1D1Ev();
extern void _ZN7S1407C1D0Ev();
extern void _ZN10S1407C4_nt2v4Ev();
extern void _ZN10S1407C4_nt2v5Ev();
extern void _ZN10S1407C4_nt2v6Ev();
extern void _ZN10S1407C4_nt2v7Ev();
extern void _ZN10S1407C4_nt2v8Ev();
extern void _ZN10S1407C4_nt2v9Ev();
extern void _ZN10S1407C4_nt3v10Ev();
extern void _ZN10S1407C4_nt3v11Ev();
extern void _ZN10S1407C4_nt3v12Ev();
extern void _ZN10S1407C4_nt3v13Ev();
extern void _ZN10S1407C4_nt3v14Ev();
extern void _ZN10S1407C4_nt3v15Ev();
extern void _ZN10S1407C4_nt3v16Ev();
extern void _ZN10S1407C4_nt3v17Ev();
extern void _ZN10S1407C4_nt3v18Ev();
extern void _ZN10S1407C4_nt3v19Ev();
extern void _ZN10S1407C4_nt3v20Ev();
extern void _ZN10S1407C4_nt3v21Ev();
extern void _ZN10S1407C4_nt3v22Ev();
extern void _ZN10S1407C4_nt3v23Ev();
extern void _ZN10S1407C4_nt3v24Ev();
extern void _ZN10S1407C4_nt3v25Ev();
extern void _ZN10S1407C4_nt3v26Ev();
extern void _ZN10S1407C4_nt3v27Ev();
extern void _ZN10S1407C4_nt3v28Ev();
extern void _ZN10S1407C4_nt3v29Ev();
extern void _ZN10S1407C4_nt3v30Ev();
extern void _ZN10S1407C4_nt3v31Ev();
extern void _ZN10S1407C4_nt3v32Ev();
extern void _ZN10S1407C4_nt3v33Ev();
extern void _ZN10S1407C4_nt3v34Ev();
extern void _ZN10S1407C4_nt3v35Ev();
extern void _ZN10S1407C4_nt3v36Ev();
extern void _ZN10S1407C4_nt3v37Ev();
extern void _ZN10S1407C4_nt3v38Ev();
extern void _ZN10S1407C4_nt3v39Ev();
extern void _ZN10S1407C4_nt3v40Ev();
extern void _ZN10S1407C4_nt3v41Ev();
extern void _ZN10S1407C4_nt3v42Ev();
extern void _ZN10S1407C4_nt3v43Ev();
extern void _ZN10S1407C4_nt3v44Ev();
extern void _ZN10S1407C4_nt3v45Ev();
extern void _ZN10S1407C4_nt3v46Ev();
extern void _ZN10S1407C4_nt3v47Ev();
extern void _ZN10S1407C4_nt3v48Ev();
extern void _ZN10S1407C4_nt3v49Ev();
extern void _ZN10S1407C4_nt3v50Ev();
extern void _ZN10S1407C4_nt3v51Ev();
extern void _ZN10S1407C4_nt3v52Ev();
extern void _ZN10S1407C4_nt3v53Ev();
extern void _ZN10S1407C4_nt3v54Ev();
extern void _ZN10S1407C4_nt3v55Ev();
extern void _ZN10S1407C4_nt3v56Ev();
extern void _ZN10S1407C4_nt3v57Ev();
extern void _ZN10S1407C4_nt3v58Ev();
extern void _ZN10S1407C4_nt3v59Ev();
extern void _ZN10S1407C4_nt3v60Ev();
extern void _ZN10S1407C4_nt3v61Ev();
extern void _ZN10S1407C4_nt3v62Ev();
extern void _ZN10S1407C4_nt3v63Ev();
extern void _ZN10S1407C4_nt3v64Ev();
extern void _ZN10S1407C4_nt3v65Ev();
extern void _ZN10S1407C4_nt3v66Ev();
extern void _ZN10S1407C4_nt3v67Ev();
extern void _ZN10S1407C3_nt3v68Ev();
extern void _ZN10S1407C3_nt3v69Ev();
extern void _ZN10S1407C3_nt3v70Ev();
extern void _ZN10S1407C3_nt3v71Ev();
extern void _ZN10S1407C3_nt3v72Ev();
extern void _ZN10S1407C3_nt3v73Ev();
extern void _ZN10S1407C3_nt3v74Ev();
extern void _ZN10S1407C3_nt3v75Ev();
extern void _ZN10S1407C3_nt3v76Ev();
extern void _ZN10S1407C3_nt3v77Ev();
extern void _ZN10S1407C3_nt3v78Ev();
extern void _ZN10S1407C3_nt3v79Ev();
extern void _ZN10S1407C3_nt3v80Ev();
extern void _ZN10S1407C3_nt3v81Ev();
extern void _ZN10S1407C3_nt3v82Ev();
extern void _ZN10S1407C3_nt3v83Ev();
extern void _ZN10S1407C3_nt3v84Ev();
extern void _ZN10S1407C3_nt3v85Ev();
extern void _ZN10S1407C3_nt3v86Ev();
extern void _ZN10S1407C3_nt3v87Ev();
extern void _ZN10S1407C3_nt3v88Ev();
extern void _ZN10S1407C3_nt3v89Ev();
extern void _ZN10S1407C3_nt3v90Ev();
extern void _ZN10S1407C3_nt3v91Ev();
extern void _ZN10S1407C3_nt3v92Ev();
extern void _ZN10S1407C3_nt3v93Ev();
extern void _ZN10S1407C3_nt3v94Ev();
extern void _ZN10S1407C3_nt3v95Ev();
extern void _ZN10S1407C3_nt3v96Ev();
extern void _ZN10S1407C3_nt3v97Ev();
extern void _ZN10S1407C3_nt3v98Ev();
extern void _ZN10S1407C3_nt3v99Ev();
extern void _ZN10S1407C3_nt4v100Ev();
extern void _ZN10S1407C3_nt4v101Ev();
extern void _ZN10S1407C3_nt4v102Ev();
extern void _ZN10S1407C3_nt4v103Ev();
extern void _ZN10S1407C3_nt4v104Ev();
extern void _ZN10S1407C3_nt4v105Ev();
extern void _ZN10S1407C3_nt4v106Ev();
extern void _ZN10S1407C3_nt4v107Ev();
extern void _ZN10S1407C3_nt4v108Ev();
extern void _ZN10S1407C3_nt4v109Ev();
extern void _ZN10S1407C3_nt4v110Ev();
extern void _ZN10S1407C3_nt4v111Ev();
extern void _ZN10S1407C3_nt4v112Ev();
extern void _ZN10S1407C3_nt4v113Ev();
extern void _ZN10S1407C3_nt4v114Ev();
extern void _ZN10S1407C3_nt4v115Ev();
extern void _ZN10S1407C3_nt4v116Ev();
extern void _ZN10S1407C3_nt4v117Ev();
extern void _ZN10S1407C3_nt4v118Ev();
extern void _ZN10S1407C3_nt4v119Ev();
extern void _ZN10S1407C3_nt4v120Ev();
extern void _ZN10S1407C3_nt4v121Ev();
extern void _ZN10S1407C3_nt4v122Ev();
extern void _ZN10S1407C3_nt4v123Ev();
extern void _ZN10S1407C3_nt4v124Ev();
extern void _ZN10S1407C3_nt4v125Ev();
extern void _ZN10S1407C3_nt4v126Ev();
extern void _ZN10S1407C3_nt4v127Ev();
extern void _ZN10S1407C3_nt4v128Ev();
extern void _ZN10S1407C3_nt4v129Ev();
extern void _ZN10S1407C3_nt4v130Ev();
extern void _ZN10S1407C3_nt4v131Ev();
extern void _ZN10S1407C3_nt4v132Ev();
extern void _ZN10S1407C3_nt4v133Ev();
extern void _ZN10S1407C3_nt4v134Ev();
extern void _ZN10S1407C3_nt4v135Ev();
extern void _ZN10S1407C3_nt4v136Ev();
extern void _ZN10S1407C3_nt4v137Ev();
extern void _ZN10S1407C3_nt4v138Ev();
extern void _ZN10S1407C3_nt4v139Ev();
extern void _ZN10S1407C3_nt4v140Ev();
extern void _ZN10S1407C3_nt4v141Ev();
extern void _ZN10S1407C3_nt4v142Ev();
extern void _ZN10S1407C3_nt4v143Ev();
extern void _ZN10S1407C3_nt4v144Ev();
extern void _ZN10S1407C3_nt4v145Ev();
extern void _ZN10S1407C3_nt4v146Ev();
extern void _ZN10S1407C3_nt4v147Ev();
extern void _ZN10S1407C3_nt4v148Ev();
extern void _ZN10S1407C3_nt4v149Ev();
extern void _ZN10S1407C3_nt4v150Ev();
extern void _ZN10S1407C3_nt4v151Ev();
extern void _ZN10S1407C3_nt4v152Ev();
extern void _ZN10S1407C3_nt4v153Ev();
extern void _ZN10S1407C3_nt4v154Ev();
extern void _ZN10S1407C3_nt4v155Ev();
extern void _ZN10S1407C3_nt4v156Ev();
extern void _ZN10S1407C3_nt4v157Ev();
extern void _ZN10S1407C3_nt4v158Ev();
extern void _ZN10S1407C3_nt4v159Ev();
extern void _ZN10S1407C3_nt4v160Ev();
extern void _ZN10S1407C3_nt4v161Ev();
extern void _ZN10S1407C3_nt4v162Ev();
extern void _ZN10S1407C3_nt4v163Ev();
extern void _ZN10S1407C3_nt4v164Ev();
extern void _ZN10S1407C3_nt4v165Ev();
extern void _ZN10S1407C3_nt4v166Ev();
extern void _ZN10S1407C3_nt4v167Ev();
extern void _ZN10S1407C3_nt4v168Ev();
extern void _ZN10S1407C3_nt4v169Ev();
extern void _ZN10S1407C3_nt4v170Ev();
extern void _ZN10S1407C3_nt4v171Ev();
extern void _ZN10S1407C3_nt4v172Ev();
extern void _ZN10S1407C3_nt4v173Ev();
extern void _ZN10S1407C3_nt4v174Ev();
extern void _ZN10S1407C3_nt4v175Ev();
extern void _ZN10S1407C3_nt4v176Ev();
extern void _ZN10S1407C3_nt4v177Ev();
extern void _ZN10S1407C3_nt4v178Ev();
extern void _ZN10S1407C3_nt4v179Ev();
extern void _ZN10S1407C3_nt4v180Ev();
extern void _ZN10S1407C3_nt4v181Ev();
extern void _ZN10S1407C3_nt4v182Ev();
extern void _ZN10S1407C3_nt4v183Ev();
extern void _ZN10S1407C3_nt4v184Ev();
extern void _ZN10S1407C3_nt4v185Ev();
extern void _ZN10S1407C3_nt4v186Ev();
extern void _ZN10S1407C3_nt4v187Ev();
extern void _ZN10S1407C3_nt4v188Ev();
extern void _ZN10S1407C3_nt4v189Ev();
extern void _ZN10S1407C3_nt4v190Ev();
extern void _ZN10S1407C3_nt4v191Ev();
extern void _ZN10S1407C3_nt4v192Ev();
extern void _ZN10S1407C3_nt4v193Ev();
extern void _ZN10S1407C3_nt4v194Ev();
extern void _ZN10S1407C3_nt4v195Ev();
extern void _ZN10S1407C3_nt4v196Ev();
extern void _ZN10S1407C3_nt4v197Ev();
extern void _ZN10S1407C3_nt4v198Ev();
extern void _ZN10S1407C3_nt4v199Ev();
extern void _ZN10S1407C3_nt4v200Ev();
extern void _ZN10S1407C3_nt4v201Ev();
extern void _ZN10S1407C3_nt4v202Ev();
extern void _ZN10S1407C3_nt4v203Ev();
extern void _ZN10S1407C3_nt4v204Ev();
extern void _ZN10S1407C3_nt4v205Ev();
extern void _ZN10S1407C3_nt4v206Ev();
extern void _ZN10S1407C3_nt4v207Ev();
extern void _ZN10S1407C3_nt4v208Ev();
extern void _ZN10S1407C3_nt4v209Ev();
extern void _ZN10S1407C3_nt4v210Ev();
extern void _ZN10S1407C2_nt4v211Ev();
extern void _ZN10S1407C2_nt4v212Ev();
extern void _ZN10S1407C2_nt4v213Ev();
extern void _ZN10S1407C2_nt4v214Ev();
extern void _ZN10S1407C2_nt4v215Ev();
extern void _ZN10S1407C2_nt4v216Ev();
extern void _ZN10S1407C2_nt4v217Ev();
extern void _ZN10S1407C2_nt4v218Ev();
extern void _ZN10S1407C2_nt4v219Ev();
extern void _ZN10S1407C2_nt4v220Ev();
extern void _ZN10S1407C2_nt4v221Ev();
extern void _ZN10S1407C2_nt4v222Ev();
extern void _ZN10S1407C2_nt4v223Ev();
extern void _ZN10S1407C2_nt4v224Ev();
extern void _ZN10S1407C2_nt4v225Ev();
extern void _ZN10S1407C2_nt4v226Ev();
extern void _ZN10S1407C2_nt4v227Ev();
extern void _ZN10S1407C2_nt4v228Ev();
extern void _ZN10S1407C2_nt4v229Ev();
extern void _ZN10S1407C2_nt4v230Ev();
extern void _ZN10S1407C2_nt4v231Ev();
extern void _ZN10S1407C2_nt4v232Ev();
extern void _ZN10S1407C2_nt4v233Ev();
extern void _ZN10S1407C2_nt4v234Ev();
extern void _ZN10S1407C2_nt4v235Ev();
extern void _ZN10S1407C2_nt4v236Ev();
extern void _ZN10S1407C2_nt4v237Ev();
extern void _ZN10S1407C2_nt4v238Ev();
extern void _ZN10S1407C2_nt4v239Ev();
extern void _ZN10S1407C2_nt4v240Ev();
extern void _ZN10S1407C2_nt4v241Ev();
extern void _ZN10S1407C2_nt4v242Ev();
extern void _ZN10S1407C2_nt4v243Ev();
extern void _ZN10S1407C2_nt4v244Ev();
extern void _ZN10S1407C2_nt4v245Ev();
extern void _ZN10S1407C2_nt4v246Ev();
extern void _ZN10S1407C2_nt4v247Ev();
extern void _ZN7S1407C12v1Ev();
extern void _ZN7S1407C12v2Ev();
extern void _ZN7S1407C12v3Ev();
static  VTBL_ENTRY vtc_S1407C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1407C1[0]),
  (VTBL_ENTRY)&_ZN7S1407C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1407C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1407C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1407C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v237Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v238Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v239Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v240Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v241Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v242Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v243Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v244Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v245Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v246Ev,
  (VTBL_ENTRY)&_ZN10S1407C2_nt4v247Ev,
  (VTBL_ENTRY)&_ZN7S1407C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1407C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1407C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S1407C1[];
extern  VTBL_ENTRY _ZTV7S1407C1[];
Class_Descriptor cd_S1407C1 = {  "S1407C1", // class name
  bases_S1407C1, 3,
  &(vtc_S1407C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(888,660), // object size
  NSPAIRA(_ZTI7S1407C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1407C1),251, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C2  {
  virtual  ~S10183C2(); // _ZN8S10183C2D1Ev
  virtual void  v79(); // _ZN8S10183C23v79Ev
  virtual void  v80(); // _ZN8S10183C23v80Ev
  virtual void  v81(); // _ZN8S10183C23v81Ev
  virtual void  v82(); // _ZN8S10183C23v82Ev
  virtual void  v83(); // _ZN8S10183C23v83Ev
  virtual void  v84(); // _ZN8S10183C23v84Ev
  virtual void  v85(); // _ZN8S10183C23v85Ev
  virtual void  v86(); // _ZN8S10183C23v86Ev
  virtual void  v87(); // _ZN8S10183C23v87Ev
  virtual void  v88(); // _ZN8S10183C23v88Ev
  virtual void  v89(); // _ZN8S10183C23v89Ev
  virtual void  v90(); // _ZN8S10183C23v90Ev
  virtual void  v91(); // _ZN8S10183C23v91Ev
  virtual void  v92(); // _ZN8S10183C23v92Ev
  virtual void  v93(); // _ZN8S10183C23v93Ev
  virtual void  v94(); // _ZN8S10183C23v94Ev
  virtual void  v95(); // _ZN8S10183C23v95Ev
  virtual void  v96(); // _ZN8S10183C23v96Ev
  virtual void  v97(); // _ZN8S10183C23v97Ev
  virtual void  v98(); // _ZN8S10183C23v98Ev
  virtual void  v99(); // _ZN8S10183C23v99Ev
  virtual void  v100(); // _ZN8S10183C24v100Ev
  virtual void  v101(); // _ZN8S10183C24v101Ev
  virtual void  v102(); // _ZN8S10183C24v102Ev
  virtual void  v103(); // _ZN8S10183C24v103Ev
  virtual void  v104(); // _ZN8S10183C24v104Ev
  virtual void  v105(); // _ZN8S10183C24v105Ev
  virtual void  v106(); // _ZN8S10183C24v106Ev
  virtual void  v107(); // _ZN8S10183C24v107Ev
  virtual void  v108(); // _ZN8S10183C24v108Ev
  virtual void  v109(); // _ZN8S10183C24v109Ev
  virtual void  v110(); // _ZN8S10183C24v110Ev
  virtual void  v111(); // _ZN8S10183C24v111Ev
  virtual void  v112(); // _ZN8S10183C24v112Ev
  virtual void  v113(); // _ZN8S10183C24v113Ev
  virtual void  v114(); // _ZN8S10183C24v114Ev
  virtual void  v115(); // _ZN8S10183C24v115Ev
  virtual void  v116(); // _ZN8S10183C24v116Ev
  virtual void  v117(); // _ZN8S10183C24v117Ev
  virtual void  v118(); // _ZN8S10183C24v118Ev
  virtual void  v119(); // _ZN8S10183C24v119Ev
  virtual void  v120(); // _ZN8S10183C24v120Ev
  virtual void  v121(); // _ZN8S10183C24v121Ev
  virtual void  v122(); // _ZN8S10183C24v122Ev
  virtual void  v123(); // _ZN8S10183C24v123Ev
  virtual void  v124(); // _ZN8S10183C24v124Ev
  virtual void  v125(); // _ZN8S10183C24v125Ev
  virtual void  v126(); // _ZN8S10183C24v126Ev
  virtual void  v127(); // _ZN8S10183C24v127Ev
  virtual void  v128(); // _ZN8S10183C24v128Ev
  virtual void  v129(); // _ZN8S10183C24v129Ev
  virtual void  v130(); // _ZN8S10183C24v130Ev
  virtual void  v131(); // _ZN8S10183C24v131Ev
  virtual void  v132(); // _ZN8S10183C24v132Ev
  virtual void  v133(); // _ZN8S10183C24v133Ev
  virtual void  v134(); // _ZN8S10183C24v134Ev
  virtual void  v135(); // _ZN8S10183C24v135Ev
  virtual void  v136(); // _ZN8S10183C24v136Ev
  virtual void  v137(); // _ZN8S10183C24v137Ev
  virtual void  v138(); // _ZN8S10183C24v138Ev
  virtual void  v139(); // _ZN8S10183C24v139Ev
  virtual void  v140(); // _ZN8S10183C24v140Ev
  virtual void  v141(); // _ZN8S10183C24v141Ev
  virtual void  v142(); // _ZN8S10183C24v142Ev
  virtual void  v143(); // _ZN8S10183C24v143Ev
  virtual void  v144(); // _ZN8S10183C24v144Ev
  virtual void  v145(); // _ZN8S10183C24v145Ev
  virtual void  v146(); // _ZN8S10183C24v146Ev
  virtual void  v147(); // _ZN8S10183C24v147Ev
  virtual void  v148(); // _ZN8S10183C24v148Ev
  virtual void  v149(); // _ZN8S10183C24v149Ev
  virtual void  v150(); // _ZN8S10183C24v150Ev
  virtual void  v151(); // _ZN8S10183C24v151Ev
  virtual void  v152(); // _ZN8S10183C24v152Ev
  virtual void  v153(); // _ZN8S10183C24v153Ev
  virtual void  v154(); // _ZN8S10183C24v154Ev
  virtual void  v155(); // _ZN8S10183C24v155Ev
  virtual void  v156(); // _ZN8S10183C24v156Ev
  S10183C2(); // tgen
};
//SIG(-1 S10183C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78}


 S10183C2 ::~S10183C2(){ note_dtor("S10183C2", this);}
void  S10183C2 ::v79(){vfunc_called(this, "_ZN8S10183C23v79Ev");}
void  S10183C2 ::v80(){vfunc_called(this, "_ZN8S10183C23v80Ev");}
void  S10183C2 ::v81(){vfunc_called(this, "_ZN8S10183C23v81Ev");}
void  S10183C2 ::v82(){vfunc_called(this, "_ZN8S10183C23v82Ev");}
void  S10183C2 ::v83(){vfunc_called(this, "_ZN8S10183C23v83Ev");}
void  S10183C2 ::v84(){vfunc_called(this, "_ZN8S10183C23v84Ev");}
void  S10183C2 ::v85(){vfunc_called(this, "_ZN8S10183C23v85Ev");}
void  S10183C2 ::v86(){vfunc_called(this, "_ZN8S10183C23v86Ev");}
void  S10183C2 ::v87(){vfunc_called(this, "_ZN8S10183C23v87Ev");}
void  S10183C2 ::v88(){vfunc_called(this, "_ZN8S10183C23v88Ev");}
void  S10183C2 ::v89(){vfunc_called(this, "_ZN8S10183C23v89Ev");}
void  S10183C2 ::v90(){vfunc_called(this, "_ZN8S10183C23v90Ev");}
void  S10183C2 ::v91(){vfunc_called(this, "_ZN8S10183C23v91Ev");}
void  S10183C2 ::v92(){vfunc_called(this, "_ZN8S10183C23v92Ev");}
void  S10183C2 ::v93(){vfunc_called(this, "_ZN8S10183C23v93Ev");}
void  S10183C2 ::v94(){vfunc_called(this, "_ZN8S10183C23v94Ev");}
void  S10183C2 ::v95(){vfunc_called(this, "_ZN8S10183C23v95Ev");}
void  S10183C2 ::v96(){vfunc_called(this, "_ZN8S10183C23v96Ev");}
void  S10183C2 ::v97(){vfunc_called(this, "_ZN8S10183C23v97Ev");}
void  S10183C2 ::v98(){vfunc_called(this, "_ZN8S10183C23v98Ev");}
void  S10183C2 ::v99(){vfunc_called(this, "_ZN8S10183C23v99Ev");}
void  S10183C2 ::v100(){vfunc_called(this, "_ZN8S10183C24v100Ev");}
void  S10183C2 ::v101(){vfunc_called(this, "_ZN8S10183C24v101Ev");}
void  S10183C2 ::v102(){vfunc_called(this, "_ZN8S10183C24v102Ev");}
void  S10183C2 ::v103(){vfunc_called(this, "_ZN8S10183C24v103Ev");}
void  S10183C2 ::v104(){vfunc_called(this, "_ZN8S10183C24v104Ev");}
void  S10183C2 ::v105(){vfunc_called(this, "_ZN8S10183C24v105Ev");}
void  S10183C2 ::v106(){vfunc_called(this, "_ZN8S10183C24v106Ev");}
void  S10183C2 ::v107(){vfunc_called(this, "_ZN8S10183C24v107Ev");}
void  S10183C2 ::v108(){vfunc_called(this, "_ZN8S10183C24v108Ev");}
void  S10183C2 ::v109(){vfunc_called(this, "_ZN8S10183C24v109Ev");}
void  S10183C2 ::v110(){vfunc_called(this, "_ZN8S10183C24v110Ev");}
void  S10183C2 ::v111(){vfunc_called(this, "_ZN8S10183C24v111Ev");}
void  S10183C2 ::v112(){vfunc_called(this, "_ZN8S10183C24v112Ev");}
void  S10183C2 ::v113(){vfunc_called(this, "_ZN8S10183C24v113Ev");}
void  S10183C2 ::v114(){vfunc_called(this, "_ZN8S10183C24v114Ev");}
void  S10183C2 ::v115(){vfunc_called(this, "_ZN8S10183C24v115Ev");}
void  S10183C2 ::v116(){vfunc_called(this, "_ZN8S10183C24v116Ev");}
void  S10183C2 ::v117(){vfunc_called(this, "_ZN8S10183C24v117Ev");}
void  S10183C2 ::v118(){vfunc_called(this, "_ZN8S10183C24v118Ev");}
void  S10183C2 ::v119(){vfunc_called(this, "_ZN8S10183C24v119Ev");}
void  S10183C2 ::v120(){vfunc_called(this, "_ZN8S10183C24v120Ev");}
void  S10183C2 ::v121(){vfunc_called(this, "_ZN8S10183C24v121Ev");}
void  S10183C2 ::v122(){vfunc_called(this, "_ZN8S10183C24v122Ev");}
void  S10183C2 ::v123(){vfunc_called(this, "_ZN8S10183C24v123Ev");}
void  S10183C2 ::v124(){vfunc_called(this, "_ZN8S10183C24v124Ev");}
void  S10183C2 ::v125(){vfunc_called(this, "_ZN8S10183C24v125Ev");}
void  S10183C2 ::v126(){vfunc_called(this, "_ZN8S10183C24v126Ev");}
void  S10183C2 ::v127(){vfunc_called(this, "_ZN8S10183C24v127Ev");}
void  S10183C2 ::v128(){vfunc_called(this, "_ZN8S10183C24v128Ev");}
void  S10183C2 ::v129(){vfunc_called(this, "_ZN8S10183C24v129Ev");}
void  S10183C2 ::v130(){vfunc_called(this, "_ZN8S10183C24v130Ev");}
void  S10183C2 ::v131(){vfunc_called(this, "_ZN8S10183C24v131Ev");}
void  S10183C2 ::v132(){vfunc_called(this, "_ZN8S10183C24v132Ev");}
void  S10183C2 ::v133(){vfunc_called(this, "_ZN8S10183C24v133Ev");}
void  S10183C2 ::v134(){vfunc_called(this, "_ZN8S10183C24v134Ev");}
void  S10183C2 ::v135(){vfunc_called(this, "_ZN8S10183C24v135Ev");}
void  S10183C2 ::v136(){vfunc_called(this, "_ZN8S10183C24v136Ev");}
void  S10183C2 ::v137(){vfunc_called(this, "_ZN8S10183C24v137Ev");}
void  S10183C2 ::v138(){vfunc_called(this, "_ZN8S10183C24v138Ev");}
void  S10183C2 ::v139(){vfunc_called(this, "_ZN8S10183C24v139Ev");}
void  S10183C2 ::v140(){vfunc_called(this, "_ZN8S10183C24v140Ev");}
void  S10183C2 ::v141(){vfunc_called(this, "_ZN8S10183C24v141Ev");}
void  S10183C2 ::v142(){vfunc_called(this, "_ZN8S10183C24v142Ev");}
void  S10183C2 ::v143(){vfunc_called(this, "_ZN8S10183C24v143Ev");}
void  S10183C2 ::v144(){vfunc_called(this, "_ZN8S10183C24v144Ev");}
void  S10183C2 ::v145(){vfunc_called(this, "_ZN8S10183C24v145Ev");}
void  S10183C2 ::v146(){vfunc_called(this, "_ZN8S10183C24v146Ev");}
void  S10183C2 ::v147(){vfunc_called(this, "_ZN8S10183C24v147Ev");}
void  S10183C2 ::v148(){vfunc_called(this, "_ZN8S10183C24v148Ev");}
void  S10183C2 ::v149(){vfunc_called(this, "_ZN8S10183C24v149Ev");}
void  S10183C2 ::v150(){vfunc_called(this, "_ZN8S10183C24v150Ev");}
void  S10183C2 ::v151(){vfunc_called(this, "_ZN8S10183C24v151Ev");}
void  S10183C2 ::v152(){vfunc_called(this, "_ZN8S10183C24v152Ev");}
void  S10183C2 ::v153(){vfunc_called(this, "_ZN8S10183C24v153Ev");}
void  S10183C2 ::v154(){vfunc_called(this, "_ZN8S10183C24v154Ev");}
void  S10183C2 ::v155(){vfunc_called(this, "_ZN8S10183C24v155Ev");}
void  S10183C2 ::v156(){vfunc_called(this, "_ZN8S10183C24v156Ev");}
S10183C2 ::S10183C2(){ note_ctor("S10183C2", this);} // tgen

static void Test_S10183C2()
{
  extern Class_Descriptor cd_S10183C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10183C2, buf);
    S10183C2 *dp, &lv = *(dp=new (buf) S10183C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10183C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10183C2)");
    test_class_info(&lv, &cd_S10183C2);
    dp->~S10183C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10183C2(Test_S10183C2, "S10183C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10183C2C1Ev();
extern void _ZN8S10183C2D1Ev();
Name_Map name_map_S10183C2[] = {
  NSPAIR(_ZN8S10183C2C1Ev),
  NSPAIR(_ZN8S10183C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10183C2[];
extern void _ZN8S10183C2D1Ev();
extern void _ZN8S10183C2D0Ev();
extern void _ZN8S10183C23v79Ev();
extern void _ZN8S10183C23v80Ev();
extern void _ZN8S10183C23v81Ev();
extern void _ZN8S10183C23v82Ev();
extern void _ZN8S10183C23v83Ev();
extern void _ZN8S10183C23v84Ev();
extern void _ZN8S10183C23v85Ev();
extern void _ZN8S10183C23v86Ev();
extern void _ZN8S10183C23v87Ev();
extern void _ZN8S10183C23v88Ev();
extern void _ZN8S10183C23v89Ev();
extern void _ZN8S10183C23v90Ev();
extern void _ZN8S10183C23v91Ev();
extern void _ZN8S10183C23v92Ev();
extern void _ZN8S10183C23v93Ev();
extern void _ZN8S10183C23v94Ev();
extern void _ZN8S10183C23v95Ev();
extern void _ZN8S10183C23v96Ev();
extern void _ZN8S10183C23v97Ev();
extern void _ZN8S10183C23v98Ev();
extern void _ZN8S10183C23v99Ev();
extern void _ZN8S10183C24v100Ev();
extern void _ZN8S10183C24v101Ev();
extern void _ZN8S10183C24v102Ev();
extern void _ZN8S10183C24v103Ev();
extern void _ZN8S10183C24v104Ev();
extern void _ZN8S10183C24v105Ev();
extern void _ZN8S10183C24v106Ev();
extern void _ZN8S10183C24v107Ev();
extern void _ZN8S10183C24v108Ev();
extern void _ZN8S10183C24v109Ev();
extern void _ZN8S10183C24v110Ev();
extern void _ZN8S10183C24v111Ev();
extern void _ZN8S10183C24v112Ev();
extern void _ZN8S10183C24v113Ev();
extern void _ZN8S10183C24v114Ev();
extern void _ZN8S10183C24v115Ev();
extern void _ZN8S10183C24v116Ev();
extern void _ZN8S10183C24v117Ev();
extern void _ZN8S10183C24v118Ev();
extern void _ZN8S10183C24v119Ev();
extern void _ZN8S10183C24v120Ev();
extern void _ZN8S10183C24v121Ev();
extern void _ZN8S10183C24v122Ev();
extern void _ZN8S10183C24v123Ev();
extern void _ZN8S10183C24v124Ev();
extern void _ZN8S10183C24v125Ev();
extern void _ZN8S10183C24v126Ev();
extern void _ZN8S10183C24v127Ev();
extern void _ZN8S10183C24v128Ev();
extern void _ZN8S10183C24v129Ev();
extern void _ZN8S10183C24v130Ev();
extern void _ZN8S10183C24v131Ev();
extern void _ZN8S10183C24v132Ev();
extern void _ZN8S10183C24v133Ev();
extern void _ZN8S10183C24v134Ev();
extern void _ZN8S10183C24v135Ev();
extern void _ZN8S10183C24v136Ev();
extern void _ZN8S10183C24v137Ev();
extern void _ZN8S10183C24v138Ev();
extern void _ZN8S10183C24v139Ev();
extern void _ZN8S10183C24v140Ev();
extern void _ZN8S10183C24v141Ev();
extern void _ZN8S10183C24v142Ev();
extern void _ZN8S10183C24v143Ev();
extern void _ZN8S10183C24v144Ev();
extern void _ZN8S10183C24v145Ev();
extern void _ZN8S10183C24v146Ev();
extern void _ZN8S10183C24v147Ev();
extern void _ZN8S10183C24v148Ev();
extern void _ZN8S10183C24v149Ev();
extern void _ZN8S10183C24v150Ev();
extern void _ZN8S10183C24v151Ev();
extern void _ZN8S10183C24v152Ev();
extern void _ZN8S10183C24v153Ev();
extern void _ZN8S10183C24v154Ev();
extern void _ZN8S10183C24v155Ev();
extern void _ZN8S10183C24v156Ev();
static  VTBL_ENTRY vtc_S10183C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10183C2[0]),
  (VTBL_ENTRY)&_ZN8S10183C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10183C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v79Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v80Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v81Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v82Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v83Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v84Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v85Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v86Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v87Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v88Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v89Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v90Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v91Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v92Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v93Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v94Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v95Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v96Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v97Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v112Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v113Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v114Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v115Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v116Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v117Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v118Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v119Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v120Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v121Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v122Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v123Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v124Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v125Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v126Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v127Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v128Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v129Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v130Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v131Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v132Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v133Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v134Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v135Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v136Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v137Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v138Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v139Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v140Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v141Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v142Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v143Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v144Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v145Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v146Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v147Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v148Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v149Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v150Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v151Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v152Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v153Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v154Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v155Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v156Ev,
};
extern VTBL_ENTRY _ZTI8S10183C2[];
extern  VTBL_ENTRY _ZTV8S10183C2[];
Class_Descriptor cd_S10183C2 = {  "S10183C2", // class name
  0,0,//no base classes
  &(vtc_S10183C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10183C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10183C2),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C4_nt  {
  virtual  ~S10183C4_nt(); // _ZN11S10183C4_ntD1Ev
  virtual void  v157(); // _ZN11S10183C4_nt4v157Ev
  virtual void  v158(); // _ZN11S10183C4_nt4v158Ev
  virtual void  v159(); // _ZN11S10183C4_nt4v159Ev
  S10183C4_nt(); // tgen
};
//SIG(-1 S10183C4_nt) C1{ vd v1 v2 v3}


 S10183C4_nt ::~S10183C4_nt(){ note_dtor("S10183C4_nt", this);}
void  S10183C4_nt ::v157(){vfunc_called(this, "_ZN11S10183C4_nt4v157Ev");}
void  S10183C4_nt ::v158(){vfunc_called(this, "_ZN11S10183C4_nt4v158Ev");}
void  S10183C4_nt ::v159(){vfunc_called(this, "_ZN11S10183C4_nt4v159Ev");}
S10183C4_nt ::S10183C4_nt(){ note_ctor("S10183C4_nt", this);} // tgen

//skip512 S10183C4_nt

#else // __cplusplus

extern void _ZN11S10183C4_ntC1Ev();
extern void _ZN11S10183C4_ntD1Ev();
Name_Map name_map_S10183C4_nt[] = {
  NSPAIR(_ZN11S10183C4_ntC1Ev),
  NSPAIR(_ZN11S10183C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S10183C4_nt[];
extern void _ZN11S10183C4_ntD1Ev();
extern void _ZN11S10183C4_ntD0Ev();
extern void _ZN11S10183C4_nt4v157Ev();
extern void _ZN11S10183C4_nt4v158Ev();
extern void _ZN11S10183C4_nt4v159Ev();
static  VTBL_ENTRY vtc_S10183C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10183C4_nt[0]),
  (VTBL_ENTRY)&_ZN11S10183C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10183C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S10183C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN11S10183C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN11S10183C4_nt4v159Ev,
};
extern VTBL_ENTRY _ZTI11S10183C4_nt[];
VTBL_ENTRY *P__ZTI11S10183C4_nt = _ZTI11S10183C4_nt; 
extern  VTBL_ENTRY _ZTV11S10183C4_nt[];
Class_Descriptor cd_S10183C4_nt = {  "S10183C4_nt", // class name
  0,0,//no base classes
  &(vtc_S10183C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S10183C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S10183C4_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C6_nt  {
  void  mf10183c6(); // _ZN11S10183C6_nt9mf10183c6Ev
};
//SIG(-1 S10183C6_nt) C1{ m}


void  S10183C6_nt ::mf10183c6(){}

//skip512 S10183C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C5_nt  {
  void *s10183c5f0;
  int s10183c5f1[2];
  ::S10183C6_nt s10183c5f2;
  void  mf10183c5(); // _ZN11S10183C5_nt9mf10183c5Ev
};
//SIG(-1 S10183C5_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S10183C5_nt ::mf10183c5(){}

//skip512 S10183C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C8_nt  {
  long s10183c8f0[4];
};
//SIG(-1 S10183C8_nt) C1{ Fl[4]}



//skip512 S10183C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C7_nt  {
  ::S10183C8_nt s10183c7f0;
  void  mf10183c7(); // _ZN11S10183C7_nt9mf10183c7Ev
};
//SIG(-1 S10183C7_nt) C1{ m FC2{ Fl[4]}}


void  S10183C7_nt ::mf10183c7(){}

//skip512 S10183C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C3_nt  : S10183C4_nt {
  ::S10183C5_nt s10183c3f0;
  ::S10183C7_nt s10183c3f1;
  char s10183c3f2;
  virtual  ~S10183C3_nt(); // _ZN11S10183C3_ntD1Ev
  virtual void  v160(); // _ZN11S10183C3_nt4v160Ev
  virtual void  v161(); // _ZN11S10183C3_nt4v161Ev
  virtual void  v162(); // _ZN11S10183C3_nt4v162Ev
  S10183C3_nt(); // tgen
};
//SIG(-1 S10183C3_nt) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ Fl[4]}} Fc}


 S10183C3_nt ::~S10183C3_nt(){ note_dtor("S10183C3_nt", this);}
void  S10183C3_nt ::v160(){vfunc_called(this, "_ZN11S10183C3_nt4v160Ev");}
void  S10183C3_nt ::v161(){vfunc_called(this, "_ZN11S10183C3_nt4v161Ev");}
void  S10183C3_nt ::v162(){vfunc_called(this, "_ZN11S10183C3_nt4v162Ev");}
S10183C3_nt ::S10183C3_nt(){ note_ctor("S10183C3_nt", this);} // tgen

//skip512 S10183C3_nt

#else // __cplusplus

extern void _ZN11S10183C3_ntC1Ev();
extern void _ZN11S10183C3_ntD1Ev();
Name_Map name_map_S10183C3_nt[] = {
  NSPAIR(_ZN11S10183C3_ntC1Ev),
  NSPAIR(_ZN11S10183C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10183C4_nt;
extern VTBL_ENTRY _ZTI11S10183C4_nt[];
extern  VTBL_ENTRY _ZTV11S10183C4_nt[];
static Base_Class bases_S10183C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10183C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S10183C3_nt[];
extern void _ZN11S10183C3_ntD1Ev();
extern void _ZN11S10183C3_ntD0Ev();
extern void _ZN11S10183C4_nt4v157Ev();
extern void _ZN11S10183C4_nt4v158Ev();
extern void _ZN11S10183C4_nt4v159Ev();
extern void _ZN11S10183C3_nt4v160Ev();
extern void _ZN11S10183C3_nt4v161Ev();
extern void _ZN11S10183C3_nt4v162Ev();
static  VTBL_ENTRY vtc_S10183C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10183C3_nt[0]),
  (VTBL_ENTRY)&_ZN11S10183C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10183C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S10183C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN11S10183C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN11S10183C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN11S10183C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN11S10183C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN11S10183C3_nt4v162Ev,
};
extern VTBL_ENTRY _ZTI11S10183C3_nt[];
VTBL_ENTRY *P__ZTI11S10183C3_nt = _ZTI11S10183C3_nt; 
extern  VTBL_ENTRY _ZTV11S10183C3_nt[];
Class_Descriptor cd_S10183C3_nt = {  "S10183C3_nt", // class name
  bases_S10183C3_nt, 1,
  &(vtc_S10183C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI11S10183C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV11S10183C3_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C12  {
  void  mf10183c12(); // _ZN9S10183C1210mf10183c12Ev
};
//SIG(-1 S10183C12) C1{ m}


void  S10183C12 ::mf10183c12(){}

static void Test_S10183C12()
{
  {
    init_simple_test("S10183C12");
    S10183C12 lv;
    check2(sizeof(lv), 1, "sizeof(S10183C12)");
    check2(__alignof__(lv), 1, "__alignof__(S10183C12)");
  }
}
static Arrange_To_Call_Me vS10183C12(Test_S10183C12, "S10183C12", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C10_nt  {
  void *s10183c10f0;
  int s10183c10f1;
  ::S10183C6_nt s10183c10f2;
  ::S10183C12 s10183c10f3;
  void  mf10183c10(); // _ZN12S10183C10_nt10mf10183c10Ev
};
//SIG(-1 S10183C10_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S10183C10_nt ::mf10183c10(){}

//skip512 S10183C10_nt

#else // __cplusplus

Class_Descriptor cd_S10183C10_nt = {  "S10183C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C9_nt  : S10183C10_nt {
};
//SIG(-1 S10183C9_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S10183C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S10183C10_nt;
static Base_Class bases_S10183C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10183C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C14_nt  {
  virtual  ~S10183C14_nt(); // _ZN12S10183C14_ntD1Ev
  virtual void  v165(); // _ZN12S10183C14_nt4v165Ev
  virtual void  v166(); // _ZN12S10183C14_nt4v166Ev
  S10183C14_nt(); // tgen
};
//SIG(-1 S10183C14_nt) C1{ vd v1 v2}


 S10183C14_nt ::~S10183C14_nt(){ note_dtor("S10183C14_nt", this);}
void  S10183C14_nt ::v165(){vfunc_called(this, "_ZN12S10183C14_nt4v165Ev");}
void  S10183C14_nt ::v166(){vfunc_called(this, "_ZN12S10183C14_nt4v166Ev");}
S10183C14_nt ::S10183C14_nt(){ note_ctor("S10183C14_nt", this);} // tgen

//skip512 S10183C14_nt

#else // __cplusplus

extern void _ZN12S10183C14_ntC1Ev();
extern void _ZN12S10183C14_ntD1Ev();
Name_Map name_map_S10183C14_nt[] = {
  NSPAIR(_ZN12S10183C14_ntC1Ev),
  NSPAIR(_ZN12S10183C14_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S10183C14_nt[];
extern void _ZN12S10183C14_ntD1Ev();
extern void _ZN12S10183C14_ntD0Ev();
extern void _ZN12S10183C14_nt4v165Ev();
extern void _ZN12S10183C14_nt4v166Ev();
static  VTBL_ENTRY vtc_S10183C14_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10183C14_nt[0]),
  (VTBL_ENTRY)&_ZN12S10183C14_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_nt4v165Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_nt4v166Ev,
};
extern VTBL_ENTRY _ZTI12S10183C14_nt[];
VTBL_ENTRY *P__ZTI12S10183C14_nt = _ZTI12S10183C14_nt; 
extern  VTBL_ENTRY _ZTV12S10183C14_nt[];
Class_Descriptor cd_S10183C14_nt = {  "S10183C14_nt", // class name
  0,0,//no base classes
  &(vtc_S10183C14_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S10183C14_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S10183C14_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C15_nt  {
  void *s10183c15f0;
  int s10183c15f1;
  ::S10183C12 s10183c15f2;
  void  mf10183c15(); // _ZN12S10183C15_nt10mf10183c15Ev
};
//SIG(-1 S10183C15_nt) C1{ m Fp Fi FC2{ m}}


void  S10183C15_nt ::mf10183c15(){}

//skip512 S10183C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C13  : S10183C14_nt {
  ::S10183C15_nt s10183c13f0;
  ::S10183C15_nt s10183c13f1;
  int s10183c13f2;
  virtual  ~S10183C13(); // _ZN9S10183C13D1Ev
  virtual void  v163(); // _ZN9S10183C134v163Ev
  virtual void  v164(); // _ZN9S10183C134v164Ev
  S10183C13(); // tgen
};
//SIG(-1 S10183C13) C1{ BC2{ vd v3 v4} vd v1 v2 FC3{ m Fp Fi FC4{ m}} FC3 Fi}


 S10183C13 ::~S10183C13(){ note_dtor("S10183C13", this);}
void  S10183C13 ::v163(){vfunc_called(this, "_ZN9S10183C134v163Ev");}
void  S10183C13 ::v164(){vfunc_called(this, "_ZN9S10183C134v164Ev");}
S10183C13 ::S10183C13(){ note_ctor("S10183C13", this);} // tgen

static void Test_S10183C13()
{
  extern Class_Descriptor cd_S10183C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S10183C13, buf);
    S10183C13 *dp, &lv = *(dp=new (buf) S10183C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S10183C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10183C13)");
    check_base_class_offset(lv, (S10183C14_nt*), 0, "S10183C13");
    check_field_offset(lv, s10183c13f0, ABISELECT(8,4), "S10183C13.s10183c13f0");
    check_field_offset(lv, s10183c13f1, ABISELECT(24,16), "S10183C13.s10183c13f1");
    check_field_offset(lv, s10183c13f2, ABISELECT(40,28), "S10183C13.s10183c13f2");
    test_class_info(&lv, &cd_S10183C13);
    dp->~S10183C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10183C13(Test_S10183C13, "S10183C13", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN9S10183C13C1Ev();
extern void _ZN9S10183C13D1Ev();
Name_Map name_map_S10183C13[] = {
  NSPAIR(_ZN9S10183C13C1Ev),
  NSPAIR(_ZN9S10183C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10183C14_nt;
extern VTBL_ENTRY _ZTI12S10183C14_nt[];
extern  VTBL_ENTRY _ZTV12S10183C14_nt[];
static Base_Class bases_S10183C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10183C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10183C13[];
extern void _ZN9S10183C13D1Ev();
extern void _ZN9S10183C13D0Ev();
extern void _ZN12S10183C14_nt4v165Ev();
extern void _ZN12S10183C14_nt4v166Ev();
extern void _ZN9S10183C134v163Ev();
extern void _ZN9S10183C134v164Ev();
static  VTBL_ENTRY vtc_S10183C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10183C13[0]),
  (VTBL_ENTRY)&_ZN9S10183C13D1Ev,
  (VTBL_ENTRY)&_ZN9S10183C13D0Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_nt4v165Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S10183C134v163Ev,
  (VTBL_ENTRY)&_ZN9S10183C134v164Ev,
};
extern VTBL_ENTRY _ZTI9S10183C13[];
extern  VTBL_ENTRY _ZTV9S10183C13[];
Class_Descriptor cd_S10183C13 = {  "S10183C13", // class name
  bases_S10183C13, 1,
  &(vtc_S10183C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI9S10183C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10183C13),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C18  : S10183C14_nt {
  ::S10183C15_nt s10183c18f0;
  virtual  ~S10183C18(); // _ZN9S10183C18D1Ev
  virtual void  v169(); // _ZN9S10183C184v169Ev
  virtual void  v170(); // _ZN9S10183C184v170Ev
  S10183C18(); // tgen
};
//SIG(-1 S10183C18) C1{ BC2{ vd v3 v4} vd v1 v2 FC3{ m Fp Fi FC4{ m}}}


 S10183C18 ::~S10183C18(){ note_dtor("S10183C18", this);}
void  S10183C18 ::v169(){vfunc_called(this, "_ZN9S10183C184v169Ev");}
void  S10183C18 ::v170(){vfunc_called(this, "_ZN9S10183C184v170Ev");}
S10183C18 ::S10183C18(){ note_ctor("S10183C18", this);} // tgen

static void Test_S10183C18()
{
  extern Class_Descriptor cd_S10183C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S10183C18, buf);
    S10183C18 *dp, &lv = *(dp=new (buf) S10183C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10183C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10183C18)");
    check_base_class_offset(lv, (S10183C14_nt*), 0, "S10183C18");
    check_field_offset(lv, s10183c18f0, ABISELECT(8,4), "S10183C18.s10183c18f0");
    test_class_info(&lv, &cd_S10183C18);
    dp->~S10183C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10183C18(Test_S10183C18, "S10183C18", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN9S10183C18C1Ev();
extern void _ZN9S10183C18D1Ev();
Name_Map name_map_S10183C18[] = {
  NSPAIR(_ZN9S10183C18C1Ev),
  NSPAIR(_ZN9S10183C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10183C14_nt;
extern VTBL_ENTRY _ZTI12S10183C14_nt[];
extern  VTBL_ENTRY _ZTV12S10183C14_nt[];
static Base_Class bases_S10183C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10183C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10183C18[];
extern void _ZN9S10183C18D1Ev();
extern void _ZN9S10183C18D0Ev();
extern void _ZN12S10183C14_nt4v165Ev();
extern void _ZN12S10183C14_nt4v166Ev();
extern void _ZN9S10183C184v169Ev();
extern void _ZN9S10183C184v170Ev();
static  VTBL_ENTRY vtc_S10183C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10183C18[0]),
  (VTBL_ENTRY)&_ZN9S10183C18D1Ev,
  (VTBL_ENTRY)&_ZN9S10183C18D0Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_nt4v165Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S10183C184v169Ev,
  (VTBL_ENTRY)&_ZN9S10183C184v170Ev,
};
extern VTBL_ENTRY _ZTI9S10183C18[];
extern  VTBL_ENTRY _ZTV9S10183C18[];
Class_Descriptor cd_S10183C18 = {  "S10183C18", // class name
  bases_S10183C18, 1,
  &(vtc_S10183C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI9S10183C18),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10183C18),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C21  {
  void  mf10183c21(); // _ZN9S10183C2110mf10183c21Ev
};
//SIG(-1 S10183C21) C1{ m}


void  S10183C21 ::mf10183c21(){}

static void Test_S10183C21()
{
  {
    init_simple_test("S10183C21");
    S10183C21 lv;
    check2(sizeof(lv), 1, "sizeof(S10183C21)");
    check2(__alignof__(lv), 1, "__alignof__(S10183C21)");
  }
}
static Arrange_To_Call_Me vS10183C21(Test_S10183C21, "S10183C21", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C20  {
  void *s10183c20f0;
  int s10183c20f1[2];
  ::S10183C21 s10183c20f2;
  void  mf10183c20(); // _ZN9S10183C2010mf10183c20Ev
};
//SIG(-1 S10183C20) C1{ m Fp Fi[2] FC2{ m}}


void  S10183C20 ::mf10183c20(){}

static void Test_S10183C20()
{
  {
    init_simple_test("S10183C20");
    S10183C20 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S10183C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10183C20)");
    check_field_offset(lv, s10183c20f0, 0, "S10183C20.s10183c20f0");
    check_field_offset(lv, s10183c20f1, ABISELECT(8,4), "S10183C20.s10183c20f1");
    check_field_offset(lv, s10183c20f2, ABISELECT(16,12), "S10183C20.s10183c20f2");
  }
}
static Arrange_To_Call_Me vS10183C20(Test_S10183C20, "S10183C20", ABISELECT(24,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S10183C20[];
VTBL_ENTRY *P__ZTI9S10183C20 = _ZTI9S10183C20; 
Class_Descriptor cd_S10183C20 = {  "S10183C20", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI9S10183C20),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C19_nt  : S10183C20 , S10183C14_nt {
  virtual  ~S10183C19_nt(); // _ZN12S10183C19_ntD1Ev
  virtual void  v171(); // _ZN12S10183C19_nt4v171Ev
  virtual void  v172(); // _ZN12S10183C19_nt4v172Ev
  S10183C19_nt(); // tgen
};
//SIG(-1 S10183C19_nt) C1{ BC2{ m Fp Fi[2] FC3{ m}} BC4{ vd v3 v4} vd v1 v2}


 S10183C19_nt ::~S10183C19_nt(){ note_dtor("S10183C19_nt", this);}
void  S10183C19_nt ::v171(){vfunc_called(this, "_ZN12S10183C19_nt4v171Ev");}
void  S10183C19_nt ::v172(){vfunc_called(this, "_ZN12S10183C19_nt4v172Ev");}
S10183C19_nt ::S10183C19_nt(){ note_ctor("S10183C19_nt", this);} // tgen

//skip512 S10183C19_nt

#else // __cplusplus

extern void _ZN12S10183C19_ntC1Ev();
extern void _ZN12S10183C19_ntD1Ev();
Name_Map name_map_S10183C19_nt[] = {
  NSPAIR(_ZN12S10183C19_ntC1Ev),
  NSPAIR(_ZN12S10183C19_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10183C20;
extern VTBL_ENTRY _ZTI9S10183C20[];
extern Class_Descriptor cd_S10183C14_nt;
extern VTBL_ENTRY _ZTI12S10183C14_nt[];
extern  VTBL_ENTRY _ZTV12S10183C14_nt[];
static Base_Class bases_S10183C19_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10183C20,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10183C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S10183C19_nt[];
extern void _ZN12S10183C19_ntD1Ev();
extern void _ZN12S10183C19_ntD0Ev();
extern void _ZN12S10183C14_nt4v165Ev();
extern void _ZN12S10183C14_nt4v166Ev();
extern void _ZN12S10183C19_nt4v171Ev();
extern void _ZN12S10183C19_nt4v172Ev();
static  VTBL_ENTRY vtc_S10183C19_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10183C19_nt[0]),
  (VTBL_ENTRY)&_ZN12S10183C19_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10183C19_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_nt4v165Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_nt4v166Ev,
  (VTBL_ENTRY)&_ZN12S10183C19_nt4v171Ev,
  (VTBL_ENTRY)&_ZN12S10183C19_nt4v172Ev,
};
extern VTBL_ENTRY _ZTI12S10183C19_nt[];
VTBL_ENTRY *P__ZTI12S10183C19_nt = _ZTI12S10183C19_nt; 
extern  VTBL_ENTRY _ZTV12S10183C19_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C23_nt  {
  short s10183c23f0[6];
  int s10183c23f1[2];
  char s10183c23f2;
  short s10183c23f3;
  void  mf10183c23(); // _ZN12S10183C23_nt10mf10183c23Ev
};
//SIG(-1 S10183C23_nt) C1{ m Fs[6] Fi[2] Fc Fs}


void  S10183C23_nt ::mf10183c23(){}

//skip512 S10183C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C22  {
  ::S10183C23_nt s10183c22f0;
  void  mf10183c22(); // _ZN9S10183C2210mf10183c22Ev
  virtual  ~S10183C22(); // _ZN9S10183C22D1Ev
  S10183C22(); // tgen
};
//SIG(-1 S10183C22) C1{ vd m FC2{ m Fs[6] Fi[2] Fc Fs}}


void  S10183C22 ::mf10183c22(){}
 S10183C22 ::~S10183C22(){ note_dtor("S10183C22", this);}
S10183C22 ::S10183C22(){ note_ctor("S10183C22", this);} // tgen

static void Test_S10183C22()
{
  extern Class_Descriptor cd_S10183C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,8)];
    init_test(&cd_S10183C22, buf);
    S10183C22 *dp, &lv = *(dp=new (buf) S10183C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(S10183C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10183C22)");
    check_field_offset(lv, s10183c22f0, ABISELECT(8,4), "S10183C22.s10183c22f0");
    test_class_info(&lv, &cd_S10183C22);
    dp->~S10183C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10183C22(Test_S10183C22, "S10183C22", ABISELECT(32,28));

#else // __cplusplus

extern void _ZN9S10183C22C1Ev();
extern void _ZN9S10183C22D1Ev();
Name_Map name_map_S10183C22[] = {
  NSPAIR(_ZN9S10183C22C1Ev),
  NSPAIR(_ZN9S10183C22D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10183C22[];
extern void _ZN9S10183C22D1Ev();
extern void _ZN9S10183C22D0Ev();
static  VTBL_ENTRY vtc_S10183C22[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10183C22[0]),
  (VTBL_ENTRY)&_ZN9S10183C22D1Ev,
  (VTBL_ENTRY)&_ZN9S10183C22D0Ev,
};
extern VTBL_ENTRY _ZTI9S10183C22[];
extern  VTBL_ENTRY _ZTV9S10183C22[];
Class_Descriptor cd_S10183C22 = {  "S10183C22", // class name
  0,0,//no base classes
  &(vtc_S10183C22[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,28), // object size
  NSPAIRA(_ZTI9S10183C22),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10183C22),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C17  : S10183C14_nt {
  ::S10183C18 s10183c17f0;
  ::S10183C13 s10183c17f1;
  ::S10183C19_nt s10183c17f2;
  ::S10183C22 s10183c17f3;
  ::S10183C15_nt s10183c17f4;
  ::S10183C15_nt s10183c17f5;
  char s10183c17f6[2];
  int s10183c17f7;
  ::S10183C15_nt s10183c17f8;
  ::S10183C15_nt s10183c17f9;
  ::S10183C15_nt s10183c17f10;
  ::S10183C15_nt s10183c17f11;
  ::S10183C15_nt s10183c17f12;
  int s10183c17f13[3];
  void *s10183c17f14;
  ::S10183C15_nt s10183c17f15;
  ::S10183C22 s10183c17f16;
  ::S10183C15_nt s10183c17f17;
  int s10183c17f18;
  virtual  ~S10183C17(); // _ZN9S10183C17D1Ev
  virtual void  v167(); // _ZN9S10183C174v167Ev
  virtual void  v168(); // _ZN9S10183C174v168Ev
  S10183C17(); // tgen
};
//SIG(-1 S10183C17) C1{ BC2{ vd v3 v4} vd v1 v2 FC3{ BC2 vd v5 v6 FC4{ m Fp Fi FC5{ m}}} FC6{ BC2 vd v7 v8 FC4 FC4 Fi} FC7{ BC8{ m Fp Fi[2] FC9{ m}} BC2 vd v9 v10} FC10{ vd m FC11{ m Fs[6] Fi[2] Fc Fs}} FC4 FC4 Fc[2] Fi FC4 FC4 FC4 FC4 FC4 Fi[3] Fp FC4 FC10 FC4 Fi}


 S10183C17 ::~S10183C17(){ note_dtor("S10183C17", this);}
void  S10183C17 ::v167(){vfunc_called(this, "_ZN9S10183C174v167Ev");}
void  S10183C17 ::v168(){vfunc_called(this, "_ZN9S10183C174v168Ev");}
S10183C17 ::S10183C17(){ note_ctor("S10183C17", this);} // tgen

static void Test_S10183C17()
{
  extern Class_Descriptor cd_S10183C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,67)];
    init_test(&cd_S10183C17, buf);
    S10183C17 *dp, &lv = *(dp=new (buf) S10183C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,264), "sizeof(S10183C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10183C17)");
    check_base_class_offset(lv, (S10183C14_nt*), 0, "S10183C17");
    check_field_offset(lv, s10183c17f0, ABISELECT(8,4), "S10183C17.s10183c17f0");
    check_field_offset(lv, s10183c17f1, ABISELECT(32,20), "S10183C17.s10183c17f1");
    check_field_offset(lv, s10183c17f2, ABISELECT(80,52), "S10183C17.s10183c17f2");
    check_field_offset(lv, s10183c17f3, ABISELECT(112,72), "S10183C17.s10183c17f3");
    check_field_offset(lv, s10183c17f4, ABISELECT(144,100), "S10183C17.s10183c17f4");
    check_field_offset(lv, s10183c17f5, ABISELECT(160,112), "S10183C17.s10183c17f5");
    check_field_offset(lv, s10183c17f6, ABISELECT(176,124), "S10183C17.s10183c17f6");
    check_field_offset(lv, s10183c17f7, ABISELECT(180,128), "S10183C17.s10183c17f7");
    check_field_offset(lv, s10183c17f8, ABISELECT(184,132), "S10183C17.s10183c17f8");
    check_field_offset(lv, s10183c17f9, ABISELECT(200,144), "S10183C17.s10183c17f9");
    check_field_offset(lv, s10183c17f10, ABISELECT(216,156), "S10183C17.s10183c17f10");
    check_field_offset(lv, s10183c17f11, ABISELECT(232,168), "S10183C17.s10183c17f11");
    check_field_offset(lv, s10183c17f12, ABISELECT(248,180), "S10183C17.s10183c17f12");
    check_field_offset(lv, s10183c17f13, ABISELECT(264,192), "S10183C17.s10183c17f13");
    check_field_offset(lv, s10183c17f14, ABISELECT(280,204), "S10183C17.s10183c17f14");
    check_field_offset(lv, s10183c17f15, ABISELECT(288,208), "S10183C17.s10183c17f15");
    check_field_offset(lv, s10183c17f16, ABISELECT(304,220), "S10183C17.s10183c17f16");
    check_field_offset(lv, s10183c17f17, ABISELECT(336,248), "S10183C17.s10183c17f17");
    check_field_offset(lv, s10183c17f18, ABISELECT(352,260), "S10183C17.s10183c17f18");
    test_class_info(&lv, &cd_S10183C17);
    dp->~S10183C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10183C17(Test_S10183C17, "S10183C17", ABISELECT(360,264));

#else // __cplusplus

extern void _ZN9S10183C17C1Ev();
extern void _ZN9S10183C17D1Ev();
Name_Map name_map_S10183C17[] = {
  NSPAIR(_ZN9S10183C17C1Ev),
  NSPAIR(_ZN9S10183C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10183C14_nt;
extern VTBL_ENTRY _ZTI12S10183C14_nt[];
extern  VTBL_ENTRY _ZTV12S10183C14_nt[];
static Base_Class bases_S10183C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10183C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10183C17[];
extern void _ZN9S10183C17D1Ev();
extern void _ZN9S10183C17D0Ev();
extern void _ZN12S10183C14_nt4v165Ev();
extern void _ZN12S10183C14_nt4v166Ev();
extern void _ZN9S10183C174v167Ev();
extern void _ZN9S10183C174v168Ev();
static  VTBL_ENTRY vtc_S10183C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10183C17[0]),
  (VTBL_ENTRY)&_ZN9S10183C17D1Ev,
  (VTBL_ENTRY)&_ZN9S10183C17D0Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_nt4v165Ev,
  (VTBL_ENTRY)&_ZN12S10183C14_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S10183C174v167Ev,
  (VTBL_ENTRY)&_ZN9S10183C174v168Ev,
};
extern VTBL_ENTRY _ZTI9S10183C17[];
extern  VTBL_ENTRY _ZTV9S10183C17[];
Class_Descriptor cd_S10183C17 = {  "S10183C17", // class name
  bases_S10183C17, 1,
  &(vtc_S10183C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,264), // object size
  NSPAIRA(_ZTI9S10183C17),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10183C17),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C27  {
  char s10183c27f0[72];
};
//SIG(-1 S10183C27) C1{ Fc[72]}



static void Test_S10183C27()
{
  {
    init_simple_test("S10183C27");
    S10183C27 lv;
    check2(sizeof(lv), 72, "sizeof(S10183C27)");
    check2(__alignof__(lv), 1, "__alignof__(S10183C27)");
    check_field_offset(lv, s10183c27f0, 0, "S10183C27.s10183c27f0");
  }
}
static Arrange_To_Call_Me vS10183C27(Test_S10183C27, "S10183C27", 72);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C28  {
  short s10183c28f0[6];
  int s10183c28f1;
};
//SIG(-1 S10183C28) C1{ Fs[6] Fi}



static void Test_S10183C28()
{
  {
    init_simple_test("S10183C28");
    S10183C28 lv;
    check2(sizeof(lv), 16, "sizeof(S10183C28)");
    check2(__alignof__(lv), 4, "__alignof__(S10183C28)");
    check_field_offset(lv, s10183c28f0, 0, "S10183C28.s10183c28f0");
    check_field_offset(lv, s10183c28f1, 12, "S10183C28.s10183c28f1");
  }
}
static Arrange_To_Call_Me vS10183C28(Test_S10183C28, "S10183C28", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C30_nt  {
  char s10183c30f0[20];
};
//SIG(-1 S10183C30_nt) C1{ Fc[20]}



//skip512 S10183C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C29_nt  {
  ::S10183C30_nt s10183c29f0;
  char s10183c29f1[16];
};
//SIG(-1 S10183C29_nt) C1{ FC2{ Fc[20]} Fc[16]}



//skip512 S10183C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C26  {
  ::S10183C27 s10183c26f0;
  ::S10183C28 s10183c26f1;
  ::S10183C29_nt s10183c26f2;
  char s10183c26f3[128];
  ::S10183C28 s10183c26f4;
  short s10183c26f5;
  char s10183c26f6[30];
};
//SIG(-1 S10183C26) C1{ FC2{ Fc[72]} FC3{ Fs[6] Fi} FC4{ FC5{ Fc[20]} Fc[16]} Fc[128] FC3 Fs Fc[30]}



static void Test_S10183C26()
{
  {
    init_simple_test("S10183C26");
    S10183C26 lv;
    check2(sizeof(lv), 300, "sizeof(S10183C26)");
    check2(__alignof__(lv), 4, "__alignof__(S10183C26)");
    check_field_offset(lv, s10183c26f0, 0, "S10183C26.s10183c26f0");
    check_field_offset(lv, s10183c26f1, 72, "S10183C26.s10183c26f1");
    check_field_offset(lv, s10183c26f2, 88, "S10183C26.s10183c26f2");
    check_field_offset(lv, s10183c26f3, 124, "S10183C26.s10183c26f3");
    check_field_offset(lv, s10183c26f4, 252, "S10183C26.s10183c26f4");
    check_field_offset(lv, s10183c26f5, 268, "S10183C26.s10183c26f5");
    check_field_offset(lv, s10183c26f6, 270, "S10183C26.s10183c26f6");
  }
}
static Arrange_To_Call_Me vS10183C26(Test_S10183C26, "S10183C26", 300);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C32_nt  {
  void *s10183c32f0[3];
  char s10183c32f1[60];
  int s10183c32f2;
};
//SIG(-1 S10183C32_nt) C1{ Fp[3] Fc[60] Fi}



//skip512 S10183C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C31  {
  int s10183c31f0;
  ::S10183C32_nt s10183c31f1;
  int s10183c31f2[3];
  void *s10183c31f3[5];
  char s10183c31f4[28];
};
//SIG(-1 S10183C31) C1{ Fi FC2{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]}



static void Test_S10183C31()
{
  {
    init_simple_test("S10183C31");
    S10183C31 lv;
    check2(sizeof(lv), ABISELECT(184,140), "sizeof(S10183C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10183C31)");
    check_field_offset(lv, s10183c31f0, 0, "S10183C31.s10183c31f0");
    check_field_offset(lv, s10183c31f1, ABISELECT(8,4), "S10183C31.s10183c31f1");
    check_field_offset(lv, s10183c31f2, ABISELECT(96,80), "S10183C31.s10183c31f2");
    check_field_offset(lv, s10183c31f3, ABISELECT(112,92), "S10183C31.s10183c31f3");
    check_field_offset(lv, s10183c31f4, ABISELECT(152,112), "S10183C31.s10183c31f4");
  }
}
static Arrange_To_Call_Me vS10183C31(Test_S10183C31, "S10183C31", ABISELECT(184,140));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10183C1  : S10183C2 , S10183C3_nt {
  void *s10183c1f0;
  ::S10183C9_nt s10183c1f1;
  void *s10183c1f2;
  ::S10183C13 s10183c1f3;
  ::S10183C17 s10183c1f4;
  int s10183c1f5[2];
  ::S10183C15_nt s10183c1f6;
  ::S10183C17 s10183c1f7;
  int s10183c1f8[2];
  ::S10183C26 s10183c1f9;
  int s10183c1f10[6];
  ::S10183C13 s10183c1f11;
  ::S10183C31 s10183c1f12;
  int s10183c1f13[2];
  ::S10183C29_nt s10183c1f14[16];
  ::S10183C15_nt s10183c1f15;
  char s10183c1f16[128];
  virtual  ~S10183C1(); // _ZN8S10183C1D1Ev
  virtual void  v1(); // _ZN8S10183C12v1Ev
  virtual void  v2(); // _ZN8S10183C12v2Ev
  virtual void  v3(); // _ZN8S10183C12v3Ev
  virtual void  v4(); // _ZN8S10183C12v4Ev
  virtual void  v5(); // _ZN8S10183C12v5Ev
  virtual void  v6(); // _ZN8S10183C12v6Ev
  virtual void  v7(); // _ZN8S10183C12v7Ev
  virtual void  v8(); // _ZN8S10183C12v8Ev
  virtual void  v9(); // _ZN8S10183C12v9Ev
  virtual void  v10(); // _ZN8S10183C13v10Ev
  virtual void  v11(); // _ZN8S10183C13v11Ev
  virtual void  v12(); // _ZN8S10183C13v12Ev
  virtual void  v13(); // _ZN8S10183C13v13Ev
  virtual void  v14(); // _ZN8S10183C13v14Ev
  virtual void  v15(); // _ZN8S10183C13v15Ev
  virtual void  v16(); // _ZN8S10183C13v16Ev
  virtual void  v17(); // _ZN8S10183C13v17Ev
  virtual void  v18(); // _ZN8S10183C13v18Ev
  virtual void  v19(); // _ZN8S10183C13v19Ev
  virtual void  v20(); // _ZN8S10183C13v20Ev
  virtual void  v21(); // _ZN8S10183C13v21Ev
  virtual void  v22(); // _ZN8S10183C13v22Ev
  virtual void  v23(); // _ZN8S10183C13v23Ev
  virtual void  v24(); // _ZN8S10183C13v24Ev
  virtual void  v25(); // _ZN8S10183C13v25Ev
  virtual void  v26(); // _ZN8S10183C13v26Ev
  virtual void  v27(); // _ZN8S10183C13v27Ev
  virtual void  v28(); // _ZN8S10183C13v28Ev
  virtual void  v29(); // _ZN8S10183C13v29Ev
  virtual void  v30(); // _ZN8S10183C13v30Ev
  virtual void  v31(); // _ZN8S10183C13v31Ev
  virtual void  v32(); // _ZN8S10183C13v32Ev
  virtual void  v33(); // _ZN8S10183C13v33Ev
  virtual void  v34(); // _ZN8S10183C13v34Ev
  virtual void  v35(); // _ZN8S10183C13v35Ev
  virtual void  v36(); // _ZN8S10183C13v36Ev
  virtual void  v37(); // _ZN8S10183C13v37Ev
  virtual void  v38(); // _ZN8S10183C13v38Ev
  virtual void  v39(); // _ZN8S10183C13v39Ev
  virtual void  v40(); // _ZN8S10183C13v40Ev
  virtual void  v41(); // _ZN8S10183C13v41Ev
  virtual void  v42(); // _ZN8S10183C13v42Ev
  virtual void  v43(); // _ZN8S10183C13v43Ev
  virtual void  v44(); // _ZN8S10183C13v44Ev
  virtual void  v45(); // _ZN8S10183C13v45Ev
  virtual void  v46(); // _ZN8S10183C13v46Ev
  virtual void  v47(); // _ZN8S10183C13v47Ev
  virtual void  v48(); // _ZN8S10183C13v48Ev
  virtual void  v49(); // _ZN8S10183C13v49Ev
  virtual void  v50(); // _ZN8S10183C13v50Ev
  virtual void  v51(); // _ZN8S10183C13v51Ev
  virtual void  v52(); // _ZN8S10183C13v52Ev
  virtual void  v53(); // _ZN8S10183C13v53Ev
  virtual void  v54(); // _ZN8S10183C13v54Ev
  virtual void  v55(); // _ZN8S10183C13v55Ev
  virtual void  v56(); // _ZN8S10183C13v56Ev
  virtual void  v57(); // _ZN8S10183C13v57Ev
  virtual void  v58(); // _ZN8S10183C13v58Ev
  virtual void  v59(); // _ZN8S10183C13v59Ev
  virtual void  v60(); // _ZN8S10183C13v60Ev
  virtual void  v61(); // _ZN8S10183C13v61Ev
  virtual void  v62(); // _ZN8S10183C13v62Ev
  virtual void  v63(); // _ZN8S10183C13v63Ev
  virtual void  v64(); // _ZN8S10183C13v64Ev
  virtual void  v65(); // _ZN8S10183C13v65Ev
  virtual void  v66(); // _ZN8S10183C13v66Ev
  virtual void  v67(); // _ZN8S10183C13v67Ev
  virtual void  v68(); // _ZN8S10183C13v68Ev
  virtual void  v69(); // _ZN8S10183C13v69Ev
  virtual void  v70(); // _ZN8S10183C13v70Ev
  virtual void  v71(); // _ZN8S10183C13v71Ev
  virtual void  v72(); // _ZN8S10183C13v72Ev
  virtual void  v73(); // _ZN8S10183C13v73Ev
  virtual void  v74(); // _ZN8S10183C13v74Ev
  virtual void  v75(); // _ZN8S10183C13v75Ev
  virtual void  v76(); // _ZN8S10183C13v76Ev
  virtual void  v77(); // _ZN8S10183C13v77Ev
  virtual void  v78(); // _ZN8S10183C13v78Ev
  S10183C1(); // tgen
};
//SIG(1 S10183C1) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156} BC3{ BC4{ vd v157 v158 v159} vd v160 v161 v162 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FC8{ Fl[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fp FC9{ BC10{ m Fp Fi FC6 FC11{ m}}} Fp FC12{ BC13{ vd v165 v166} vd v163 v164 FC14{ m Fp Fi FC11} FC14 Fi} FC15{ BC13 vd v167 v168 FC16{ BC13 vd v169 v170 FC14} FC12 FC17{ BC18{ m Fp Fi[2] FC19{ m}} BC13 vd v171 v172} FC20{ vd m FC21{ m Fs[6] Fi[2] Fc Fs}} FC14 FC14 Fc[2] Fi FC14 FC14 FC14 FC14 FC14 Fi[3] Fp FC14 FC20 FC14 Fi} Fi[2] FC14 FC15 Fi[2] FC22{ FC23{ Fc[72]} FC24{ Fs[6] Fi} FC25{ FC26{ Fc[20]} Fc[16]} Fc[128] FC24 Fs Fc[30]} Fi[6] FC12 FC27{ Fi FC28{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]} Fi[2] FC25[16] FC14 Fc[128]}


 S10183C1 ::~S10183C1(){ note_dtor("S10183C1", this);}
void  S10183C1 ::v1(){vfunc_called(this, "_ZN8S10183C12v1Ev");}
void  S10183C1 ::v2(){vfunc_called(this, "_ZN8S10183C12v2Ev");}
void  S10183C1 ::v3(){vfunc_called(this, "_ZN8S10183C12v3Ev");}
void  S10183C1 ::v4(){vfunc_called(this, "_ZN8S10183C12v4Ev");}
void  S10183C1 ::v5(){vfunc_called(this, "_ZN8S10183C12v5Ev");}
void  S10183C1 ::v6(){vfunc_called(this, "_ZN8S10183C12v6Ev");}
void  S10183C1 ::v7(){vfunc_called(this, "_ZN8S10183C12v7Ev");}
void  S10183C1 ::v8(){vfunc_called(this, "_ZN8S10183C12v8Ev");}
void  S10183C1 ::v9(){vfunc_called(this, "_ZN8S10183C12v9Ev");}
void  S10183C1 ::v10(){vfunc_called(this, "_ZN8S10183C13v10Ev");}
void  S10183C1 ::v11(){vfunc_called(this, "_ZN8S10183C13v11Ev");}
void  S10183C1 ::v12(){vfunc_called(this, "_ZN8S10183C13v12Ev");}
void  S10183C1 ::v13(){vfunc_called(this, "_ZN8S10183C13v13Ev");}
void  S10183C1 ::v14(){vfunc_called(this, "_ZN8S10183C13v14Ev");}
void  S10183C1 ::v15(){vfunc_called(this, "_ZN8S10183C13v15Ev");}
void  S10183C1 ::v16(){vfunc_called(this, "_ZN8S10183C13v16Ev");}
void  S10183C1 ::v17(){vfunc_called(this, "_ZN8S10183C13v17Ev");}
void  S10183C1 ::v18(){vfunc_called(this, "_ZN8S10183C13v18Ev");}
void  S10183C1 ::v19(){vfunc_called(this, "_ZN8S10183C13v19Ev");}
void  S10183C1 ::v20(){vfunc_called(this, "_ZN8S10183C13v20Ev");}
void  S10183C1 ::v21(){vfunc_called(this, "_ZN8S10183C13v21Ev");}
void  S10183C1 ::v22(){vfunc_called(this, "_ZN8S10183C13v22Ev");}
void  S10183C1 ::v23(){vfunc_called(this, "_ZN8S10183C13v23Ev");}
void  S10183C1 ::v24(){vfunc_called(this, "_ZN8S10183C13v24Ev");}
void  S10183C1 ::v25(){vfunc_called(this, "_ZN8S10183C13v25Ev");}
void  S10183C1 ::v26(){vfunc_called(this, "_ZN8S10183C13v26Ev");}
void  S10183C1 ::v27(){vfunc_called(this, "_ZN8S10183C13v27Ev");}
void  S10183C1 ::v28(){vfunc_called(this, "_ZN8S10183C13v28Ev");}
void  S10183C1 ::v29(){vfunc_called(this, "_ZN8S10183C13v29Ev");}
void  S10183C1 ::v30(){vfunc_called(this, "_ZN8S10183C13v30Ev");}
void  S10183C1 ::v31(){vfunc_called(this, "_ZN8S10183C13v31Ev");}
void  S10183C1 ::v32(){vfunc_called(this, "_ZN8S10183C13v32Ev");}
void  S10183C1 ::v33(){vfunc_called(this, "_ZN8S10183C13v33Ev");}
void  S10183C1 ::v34(){vfunc_called(this, "_ZN8S10183C13v34Ev");}
void  S10183C1 ::v35(){vfunc_called(this, "_ZN8S10183C13v35Ev");}
void  S10183C1 ::v36(){vfunc_called(this, "_ZN8S10183C13v36Ev");}
void  S10183C1 ::v37(){vfunc_called(this, "_ZN8S10183C13v37Ev");}
void  S10183C1 ::v38(){vfunc_called(this, "_ZN8S10183C13v38Ev");}
void  S10183C1 ::v39(){vfunc_called(this, "_ZN8S10183C13v39Ev");}
void  S10183C1 ::v40(){vfunc_called(this, "_ZN8S10183C13v40Ev");}
void  S10183C1 ::v41(){vfunc_called(this, "_ZN8S10183C13v41Ev");}
void  S10183C1 ::v42(){vfunc_called(this, "_ZN8S10183C13v42Ev");}
void  S10183C1 ::v43(){vfunc_called(this, "_ZN8S10183C13v43Ev");}
void  S10183C1 ::v44(){vfunc_called(this, "_ZN8S10183C13v44Ev");}
void  S10183C1 ::v45(){vfunc_called(this, "_ZN8S10183C13v45Ev");}
void  S10183C1 ::v46(){vfunc_called(this, "_ZN8S10183C13v46Ev");}
void  S10183C1 ::v47(){vfunc_called(this, "_ZN8S10183C13v47Ev");}
void  S10183C1 ::v48(){vfunc_called(this, "_ZN8S10183C13v48Ev");}
void  S10183C1 ::v49(){vfunc_called(this, "_ZN8S10183C13v49Ev");}
void  S10183C1 ::v50(){vfunc_called(this, "_ZN8S10183C13v50Ev");}
void  S10183C1 ::v51(){vfunc_called(this, "_ZN8S10183C13v51Ev");}
void  S10183C1 ::v52(){vfunc_called(this, "_ZN8S10183C13v52Ev");}
void  S10183C1 ::v53(){vfunc_called(this, "_ZN8S10183C13v53Ev");}
void  S10183C1 ::v54(){vfunc_called(this, "_ZN8S10183C13v54Ev");}
void  S10183C1 ::v55(){vfunc_called(this, "_ZN8S10183C13v55Ev");}
void  S10183C1 ::v56(){vfunc_called(this, "_ZN8S10183C13v56Ev");}
void  S10183C1 ::v57(){vfunc_called(this, "_ZN8S10183C13v57Ev");}
void  S10183C1 ::v58(){vfunc_called(this, "_ZN8S10183C13v58Ev");}
void  S10183C1 ::v59(){vfunc_called(this, "_ZN8S10183C13v59Ev");}
void  S10183C1 ::v60(){vfunc_called(this, "_ZN8S10183C13v60Ev");}
void  S10183C1 ::v61(){vfunc_called(this, "_ZN8S10183C13v61Ev");}
void  S10183C1 ::v62(){vfunc_called(this, "_ZN8S10183C13v62Ev");}
void  S10183C1 ::v63(){vfunc_called(this, "_ZN8S10183C13v63Ev");}
void  S10183C1 ::v64(){vfunc_called(this, "_ZN8S10183C13v64Ev");}
void  S10183C1 ::v65(){vfunc_called(this, "_ZN8S10183C13v65Ev");}
void  S10183C1 ::v66(){vfunc_called(this, "_ZN8S10183C13v66Ev");}
void  S10183C1 ::v67(){vfunc_called(this, "_ZN8S10183C13v67Ev");}
void  S10183C1 ::v68(){vfunc_called(this, "_ZN8S10183C13v68Ev");}
void  S10183C1 ::v69(){vfunc_called(this, "_ZN8S10183C13v69Ev");}
void  S10183C1 ::v70(){vfunc_called(this, "_ZN8S10183C13v70Ev");}
void  S10183C1 ::v71(){vfunc_called(this, "_ZN8S10183C13v71Ev");}
void  S10183C1 ::v72(){vfunc_called(this, "_ZN8S10183C13v72Ev");}
void  S10183C1 ::v73(){vfunc_called(this, "_ZN8S10183C13v73Ev");}
void  S10183C1 ::v74(){vfunc_called(this, "_ZN8S10183C13v74Ev");}
void  S10183C1 ::v75(){vfunc_called(this, "_ZN8S10183C13v75Ev");}
void  S10183C1 ::v76(){vfunc_called(this, "_ZN8S10183C13v76Ev");}
void  S10183C1 ::v77(){vfunc_called(this, "_ZN8S10183C13v77Ev");}
void  S10183C1 ::v78(){vfunc_called(this, "_ZN8S10183C13v78Ev");}
S10183C1 ::S10183C1(){ note_ctor("S10183C1", this);} // tgen

static void Test_S10183C1()
{
  extern Class_Descriptor cd_S10183C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(276,469)];
    init_test(&cd_S10183C1, buf);
    S10183C1 *dp, &lv = *(dp=new (buf) S10183C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2200,1872), "sizeof(S10183C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10183C1)");
    check_base_class_offset(lv, (S10183C2*), 0, "S10183C1");
    check_base_class_offset(lv, (S10183C4_nt*)(S10183C3_nt*), ABISELECT(8,4), "S10183C1");
    check_base_class_offset(lv, (S10183C3_nt*), ABISELECT(8,4), "S10183C1");
    check_field_offset(lv, s10183c1f0, ABISELECT(80,44), "S10183C1.s10183c1f0");
    check_field_offset(lv, s10183c1f1, ABISELECT(88,48), "S10183C1.s10183c1f1");
    check_field_offset(lv, s10183c1f2, ABISELECT(104,60), "S10183C1.s10183c1f2");
    check_field_offset(lv, s10183c1f3, ABISELECT(112,64), "S10183C1.s10183c1f3");
    check_field_offset(lv, s10183c1f4, ABISELECT(160,96), "S10183C1.s10183c1f4");
    check_field_offset(lv, s10183c1f5, ABISELECT(520,360), "S10183C1.s10183c1f5");
    check_field_offset(lv, s10183c1f6, ABISELECT(528,368), "S10183C1.s10183c1f6");
    check_field_offset(lv, s10183c1f7, ABISELECT(544,380), "S10183C1.s10183c1f7");
    check_field_offset(lv, s10183c1f8, ABISELECT(904,644), "S10183C1.s10183c1f8");
    check_field_offset(lv, s10183c1f9, ABISELECT(912,652), "S10183C1.s10183c1f9");
    check_field_offset(lv, s10183c1f10, ABISELECT(1212,952), "S10183C1.s10183c1f10");
    check_field_offset(lv, s10183c1f11, ABISELECT(1240,976), "S10183C1.s10183c1f11");
    check_field_offset(lv, s10183c1f12, ABISELECT(1288,1008), "S10183C1.s10183c1f12");
    check_field_offset(lv, s10183c1f13, ABISELECT(1472,1148), "S10183C1.s10183c1f13");
    check_field_offset(lv, s10183c1f14, ABISELECT(1480,1156), "S10183C1.s10183c1f14");
    check_field_offset(lv, s10183c1f15, ABISELECT(2056,1732), "S10183C1.s10183c1f15");
    check_field_offset(lv, s10183c1f16, ABISELECT(2072,1744), "S10183C1.s10183c1f16");
    test_class_info(&lv, &cd_S10183C1);
    dp->~S10183C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10183C1(Test_S10183C1, "S10183C1", ABISELECT(2200,1872));

#else // __cplusplus

extern void _ZN8S10183C1C1Ev();
extern void _ZN8S10183C1D1Ev();
Name_Map name_map_S10183C1[] = {
  NSPAIR(_ZN8S10183C1C1Ev),
  NSPAIR(_ZN8S10183C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10183C2;
extern VTBL_ENTRY _ZTI8S10183C2[];
extern  VTBL_ENTRY _ZTV8S10183C2[];
extern Class_Descriptor cd_S10183C4_nt;
extern VTBL_ENTRY _ZTI11S10183C4_nt[];
extern  VTBL_ENTRY _ZTV11S10183C4_nt[];
extern Class_Descriptor cd_S10183C3_nt;
extern VTBL_ENTRY _ZTI11S10183C3_nt[];
extern  VTBL_ENTRY _ZTV11S10183C3_nt[];
static Base_Class bases_S10183C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10183C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10183C4_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10183C3_nt,    ABISELECT(8,4), //bcp->offset
    160, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10183C1[];
extern void _ZN8S10183C1D1Ev();
extern void _ZN8S10183C1D0Ev();
extern void _ZN8S10183C23v79Ev();
extern void _ZN8S10183C23v80Ev();
extern void _ZN8S10183C23v81Ev();
extern void _ZN8S10183C23v82Ev();
extern void _ZN8S10183C23v83Ev();
extern void _ZN8S10183C23v84Ev();
extern void _ZN8S10183C23v85Ev();
extern void _ZN8S10183C23v86Ev();
extern void _ZN8S10183C23v87Ev();
extern void _ZN8S10183C23v88Ev();
extern void _ZN8S10183C23v89Ev();
extern void _ZN8S10183C23v90Ev();
extern void _ZN8S10183C23v91Ev();
extern void _ZN8S10183C23v92Ev();
extern void _ZN8S10183C23v93Ev();
extern void _ZN8S10183C23v94Ev();
extern void _ZN8S10183C23v95Ev();
extern void _ZN8S10183C23v96Ev();
extern void _ZN8S10183C23v97Ev();
extern void _ZN8S10183C23v98Ev();
extern void _ZN8S10183C23v99Ev();
extern void _ZN8S10183C24v100Ev();
extern void _ZN8S10183C24v101Ev();
extern void _ZN8S10183C24v102Ev();
extern void _ZN8S10183C24v103Ev();
extern void _ZN8S10183C24v104Ev();
extern void _ZN8S10183C24v105Ev();
extern void _ZN8S10183C24v106Ev();
extern void _ZN8S10183C24v107Ev();
extern void _ZN8S10183C24v108Ev();
extern void _ZN8S10183C24v109Ev();
extern void _ZN8S10183C24v110Ev();
extern void _ZN8S10183C24v111Ev();
extern void _ZN8S10183C24v112Ev();
extern void _ZN8S10183C24v113Ev();
extern void _ZN8S10183C24v114Ev();
extern void _ZN8S10183C24v115Ev();
extern void _ZN8S10183C24v116Ev();
extern void _ZN8S10183C24v117Ev();
extern void _ZN8S10183C24v118Ev();
extern void _ZN8S10183C24v119Ev();
extern void _ZN8S10183C24v120Ev();
extern void _ZN8S10183C24v121Ev();
extern void _ZN8S10183C24v122Ev();
extern void _ZN8S10183C24v123Ev();
extern void _ZN8S10183C24v124Ev();
extern void _ZN8S10183C24v125Ev();
extern void _ZN8S10183C24v126Ev();
extern void _ZN8S10183C24v127Ev();
extern void _ZN8S10183C24v128Ev();
extern void _ZN8S10183C24v129Ev();
extern void _ZN8S10183C24v130Ev();
extern void _ZN8S10183C24v131Ev();
extern void _ZN8S10183C24v132Ev();
extern void _ZN8S10183C24v133Ev();
extern void _ZN8S10183C24v134Ev();
extern void _ZN8S10183C24v135Ev();
extern void _ZN8S10183C24v136Ev();
extern void _ZN8S10183C24v137Ev();
extern void _ZN8S10183C24v138Ev();
extern void _ZN8S10183C24v139Ev();
extern void _ZN8S10183C24v140Ev();
extern void _ZN8S10183C24v141Ev();
extern void _ZN8S10183C24v142Ev();
extern void _ZN8S10183C24v143Ev();
extern void _ZN8S10183C24v144Ev();
extern void _ZN8S10183C24v145Ev();
extern void _ZN8S10183C24v146Ev();
extern void _ZN8S10183C24v147Ev();
extern void _ZN8S10183C24v148Ev();
extern void _ZN8S10183C24v149Ev();
extern void _ZN8S10183C24v150Ev();
extern void _ZN8S10183C24v151Ev();
extern void _ZN8S10183C24v152Ev();
extern void _ZN8S10183C24v153Ev();
extern void _ZN8S10183C24v154Ev();
extern void _ZN8S10183C24v155Ev();
extern void _ZN8S10183C24v156Ev();
extern void _ZN8S10183C12v1Ev();
extern void _ZN8S10183C12v2Ev();
extern void _ZN8S10183C12v3Ev();
extern void _ZN8S10183C12v4Ev();
extern void _ZN8S10183C12v5Ev();
extern void _ZN8S10183C12v6Ev();
extern void _ZN8S10183C12v7Ev();
extern void _ZN8S10183C12v8Ev();
extern void _ZN8S10183C12v9Ev();
extern void _ZN8S10183C13v10Ev();
extern void _ZN8S10183C13v11Ev();
extern void _ZN8S10183C13v12Ev();
extern void _ZN8S10183C13v13Ev();
extern void _ZN8S10183C13v14Ev();
extern void _ZN8S10183C13v15Ev();
extern void _ZN8S10183C13v16Ev();
extern void _ZN8S10183C13v17Ev();
extern void _ZN8S10183C13v18Ev();
extern void _ZN8S10183C13v19Ev();
extern void _ZN8S10183C13v20Ev();
extern void _ZN8S10183C13v21Ev();
extern void _ZN8S10183C13v22Ev();
extern void _ZN8S10183C13v23Ev();
extern void _ZN8S10183C13v24Ev();
extern void _ZN8S10183C13v25Ev();
extern void _ZN8S10183C13v26Ev();
extern void _ZN8S10183C13v27Ev();
extern void _ZN8S10183C13v28Ev();
extern void _ZN8S10183C13v29Ev();
extern void _ZN8S10183C13v30Ev();
extern void _ZN8S10183C13v31Ev();
extern void _ZN8S10183C13v32Ev();
extern void _ZN8S10183C13v33Ev();
extern void _ZN8S10183C13v34Ev();
extern void _ZN8S10183C13v35Ev();
extern void _ZN8S10183C13v36Ev();
extern void _ZN8S10183C13v37Ev();
extern void _ZN8S10183C13v38Ev();
extern void _ZN8S10183C13v39Ev();
extern void _ZN8S10183C13v40Ev();
extern void _ZN8S10183C13v41Ev();
extern void _ZN8S10183C13v42Ev();
extern void _ZN8S10183C13v43Ev();
extern void _ZN8S10183C13v44Ev();
extern void _ZN8S10183C13v45Ev();
extern void _ZN8S10183C13v46Ev();
extern void _ZN8S10183C13v47Ev();
extern void _ZN8S10183C13v48Ev();
extern void _ZN8S10183C13v49Ev();
extern void _ZN8S10183C13v50Ev();
extern void _ZN8S10183C13v51Ev();
extern void _ZN8S10183C13v52Ev();
extern void _ZN8S10183C13v53Ev();
extern void _ZN8S10183C13v54Ev();
extern void _ZN8S10183C13v55Ev();
extern void _ZN8S10183C13v56Ev();
extern void _ZN8S10183C13v57Ev();
extern void _ZN8S10183C13v58Ev();
extern void _ZN8S10183C13v59Ev();
extern void _ZN8S10183C13v60Ev();
extern void _ZN8S10183C13v61Ev();
extern void _ZN8S10183C13v62Ev();
extern void _ZN8S10183C13v63Ev();
extern void _ZN8S10183C13v64Ev();
extern void _ZN8S10183C13v65Ev();
extern void _ZN8S10183C13v66Ev();
extern void _ZN8S10183C13v67Ev();
extern void _ZN8S10183C13v68Ev();
extern void _ZN8S10183C13v69Ev();
extern void _ZN8S10183C13v70Ev();
extern void _ZN8S10183C13v71Ev();
extern void _ZN8S10183C13v72Ev();
extern void _ZN8S10183C13v73Ev();
extern void _ZN8S10183C13v74Ev();
extern void _ZN8S10183C13v75Ev();
extern void _ZN8S10183C13v76Ev();
extern void _ZN8S10183C13v77Ev();
extern void _ZN8S10183C13v78Ev();
extern void ABISELECT(_ZThn8_N8S10183C1D1Ev,_ZThn4_N8S10183C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10183C1D0Ev,_ZThn4_N8S10183C1D0Ev)();
extern void _ZN11S10183C4_nt4v157Ev();
extern void _ZN11S10183C4_nt4v158Ev();
extern void _ZN11S10183C4_nt4v159Ev();
extern void _ZN11S10183C3_nt4v160Ev();
extern void _ZN11S10183C3_nt4v161Ev();
extern void _ZN11S10183C3_nt4v162Ev();
static  VTBL_ENTRY vtc_S10183C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10183C1[0]),
  (VTBL_ENTRY)&_ZN8S10183C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10183C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v79Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v80Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v81Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v82Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v83Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v84Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v85Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v86Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v87Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v88Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v89Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v90Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v91Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v92Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v93Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v94Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v95Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v96Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v97Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10183C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v112Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v113Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v114Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v115Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v116Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v117Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v118Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v119Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v120Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v121Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v122Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v123Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v124Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v125Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v126Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v127Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v128Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v129Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v130Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v131Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v132Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v133Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v134Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v135Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v136Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v137Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v138Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v139Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v140Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v141Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v142Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v143Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v144Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v145Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v146Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v147Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v148Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v149Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v150Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v151Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v152Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v153Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v154Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v155Ev,
  (VTBL_ENTRY)&_ZN8S10183C24v156Ev,
  (VTBL_ENTRY)&_ZN8S10183C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10183C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10183C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10183C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10183C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10183C12v6Ev,
  (VTBL_ENTRY)&_ZN8S10183C12v7Ev,
  (VTBL_ENTRY)&_ZN8S10183C12v8Ev,
  (VTBL_ENTRY)&_ZN8S10183C12v9Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v10Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v11Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v12Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v13Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v14Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v15Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v16Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v17Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v18Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v19Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v20Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v21Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v22Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v23Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v24Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v25Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v26Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v27Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v28Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v29Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v30Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v31Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v32Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v33Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v34Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v35Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v36Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v37Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v38Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v39Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v40Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v41Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v42Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v43Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v44Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v45Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v46Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v47Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v48Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v49Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v50Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v51Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v52Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v53Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v54Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v55Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v56Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v57Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v58Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v59Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v60Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v61Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v62Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v63Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v64Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v65Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v66Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v67Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v68Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v69Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v70Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v71Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v72Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v73Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v74Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v75Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v76Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v77Ev,
  (VTBL_ENTRY)&_ZN8S10183C13v78Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10183C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10183C1D1Ev,_ZThn4_N8S10183C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10183C1D0Ev,_ZThn4_N8S10183C1D0Ev),
  (VTBL_ENTRY)&_ZN11S10183C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN11S10183C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN11S10183C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN11S10183C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN11S10183C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN11S10183C3_nt4v162Ev,
};
extern VTBL_ENTRY _ZTI8S10183C1[];
extern  VTBL_ENTRY _ZTV8S10183C1[];
Class_Descriptor cd_S10183C1 = {  "S10183C1", // class name
  bases_S10183C1, 3,
  &(vtc_S10183C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2200,1872), // object size
  NSPAIRA(_ZTI8S10183C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10183C1),170, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10184C2  {
  virtual  ~S10184C2(); // _ZN8S10184C2D1Ev
  virtual void  v79(); // _ZN8S10184C23v79Ev
  virtual void  v80(); // _ZN8S10184C23v80Ev
  virtual void  v81(); // _ZN8S10184C23v81Ev
  virtual void  v82(); // _ZN8S10184C23v82Ev
  virtual void  v83(); // _ZN8S10184C23v83Ev
  virtual void  v84(); // _ZN8S10184C23v84Ev
  virtual void  v85(); // _ZN8S10184C23v85Ev
  virtual void  v86(); // _ZN8S10184C23v86Ev
  virtual void  v87(); // _ZN8S10184C23v87Ev
  virtual void  v88(); // _ZN8S10184C23v88Ev
  virtual void  v89(); // _ZN8S10184C23v89Ev
  virtual void  v90(); // _ZN8S10184C23v90Ev
  virtual void  v91(); // _ZN8S10184C23v91Ev
  virtual void  v92(); // _ZN8S10184C23v92Ev
  virtual void  v93(); // _ZN8S10184C23v93Ev
  virtual void  v94(); // _ZN8S10184C23v94Ev
  virtual void  v95(); // _ZN8S10184C23v95Ev
  virtual void  v96(); // _ZN8S10184C23v96Ev
  virtual void  v97(); // _ZN8S10184C23v97Ev
  virtual void  v98(); // _ZN8S10184C23v98Ev
  virtual void  v99(); // _ZN8S10184C23v99Ev
  virtual void  v100(); // _ZN8S10184C24v100Ev
  virtual void  v101(); // _ZN8S10184C24v101Ev
  virtual void  v102(); // _ZN8S10184C24v102Ev
  virtual void  v103(); // _ZN8S10184C24v103Ev
  virtual void  v104(); // _ZN8S10184C24v104Ev
  virtual void  v105(); // _ZN8S10184C24v105Ev
  virtual void  v106(); // _ZN8S10184C24v106Ev
  virtual void  v107(); // _ZN8S10184C24v107Ev
  virtual void  v108(); // _ZN8S10184C24v108Ev
  virtual void  v109(); // _ZN8S10184C24v109Ev
  virtual void  v110(); // _ZN8S10184C24v110Ev
  virtual void  v111(); // _ZN8S10184C24v111Ev
  virtual void  v112(); // _ZN8S10184C24v112Ev
  virtual void  v113(); // _ZN8S10184C24v113Ev
  virtual void  v114(); // _ZN8S10184C24v114Ev
  virtual void  v115(); // _ZN8S10184C24v115Ev
  virtual void  v116(); // _ZN8S10184C24v116Ev
  virtual void  v117(); // _ZN8S10184C24v117Ev
  virtual void  v118(); // _ZN8S10184C24v118Ev
  virtual void  v119(); // _ZN8S10184C24v119Ev
  virtual void  v120(); // _ZN8S10184C24v120Ev
  virtual void  v121(); // _ZN8S10184C24v121Ev
  virtual void  v122(); // _ZN8S10184C24v122Ev
  virtual void  v123(); // _ZN8S10184C24v123Ev
  virtual void  v124(); // _ZN8S10184C24v124Ev
  virtual void  v125(); // _ZN8S10184C24v125Ev
  virtual void  v126(); // _ZN8S10184C24v126Ev
  virtual void  v127(); // _ZN8S10184C24v127Ev
  virtual void  v128(); // _ZN8S10184C24v128Ev
  virtual void  v129(); // _ZN8S10184C24v129Ev
  virtual void  v130(); // _ZN8S10184C24v130Ev
  virtual void  v131(); // _ZN8S10184C24v131Ev
  virtual void  v132(); // _ZN8S10184C24v132Ev
  virtual void  v133(); // _ZN8S10184C24v133Ev
  virtual void  v134(); // _ZN8S10184C24v134Ev
  virtual void  v135(); // _ZN8S10184C24v135Ev
  virtual void  v136(); // _ZN8S10184C24v136Ev
  virtual void  v137(); // _ZN8S10184C24v137Ev
  virtual void  v138(); // _ZN8S10184C24v138Ev
  virtual void  v139(); // _ZN8S10184C24v139Ev
  virtual void  v140(); // _ZN8S10184C24v140Ev
  virtual void  v141(); // _ZN8S10184C24v141Ev
  virtual void  v142(); // _ZN8S10184C24v142Ev
  virtual void  v143(); // _ZN8S10184C24v143Ev
  virtual void  v144(); // _ZN8S10184C24v144Ev
  virtual void  v145(); // _ZN8S10184C24v145Ev
  virtual void  v146(); // _ZN8S10184C24v146Ev
  virtual void  v147(); // _ZN8S10184C24v147Ev
  virtual void  v148(); // _ZN8S10184C24v148Ev
  virtual void  v149(); // _ZN8S10184C24v149Ev
  virtual void  v150(); // _ZN8S10184C24v150Ev
  virtual void  v151(); // _ZN8S10184C24v151Ev
  virtual void  v152(); // _ZN8S10184C24v152Ev
  virtual void  v153(); // _ZN8S10184C24v153Ev
  virtual void  v154(); // _ZN8S10184C24v154Ev
  virtual void  v155(); // _ZN8S10184C24v155Ev
  virtual void  v156(); // _ZN8S10184C24v156Ev
  S10184C2(); // tgen
};
//SIG(-1 S10184C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78}


 S10184C2 ::~S10184C2(){ note_dtor("S10184C2", this);}
void  S10184C2 ::v79(){vfunc_called(this, "_ZN8S10184C23v79Ev");}
void  S10184C2 ::v80(){vfunc_called(this, "_ZN8S10184C23v80Ev");}
void  S10184C2 ::v81(){vfunc_called(this, "_ZN8S10184C23v81Ev");}
void  S10184C2 ::v82(){vfunc_called(this, "_ZN8S10184C23v82Ev");}
void  S10184C2 ::v83(){vfunc_called(this, "_ZN8S10184C23v83Ev");}
void  S10184C2 ::v84(){vfunc_called(this, "_ZN8S10184C23v84Ev");}
void  S10184C2 ::v85(){vfunc_called(this, "_ZN8S10184C23v85Ev");}
void  S10184C2 ::v86(){vfunc_called(this, "_ZN8S10184C23v86Ev");}
void  S10184C2 ::v87(){vfunc_called(this, "_ZN8S10184C23v87Ev");}
void  S10184C2 ::v88(){vfunc_called(this, "_ZN8S10184C23v88Ev");}
void  S10184C2 ::v89(){vfunc_called(this, "_ZN8S10184C23v89Ev");}
void  S10184C2 ::v90(){vfunc_called(this, "_ZN8S10184C23v90Ev");}
void  S10184C2 ::v91(){vfunc_called(this, "_ZN8S10184C23v91Ev");}
void  S10184C2 ::v92(){vfunc_called(this, "_ZN8S10184C23v92Ev");}
void  S10184C2 ::v93(){vfunc_called(this, "_ZN8S10184C23v93Ev");}
void  S10184C2 ::v94(){vfunc_called(this, "_ZN8S10184C23v94Ev");}
void  S10184C2 ::v95(){vfunc_called(this, "_ZN8S10184C23v95Ev");}
void  S10184C2 ::v96(){vfunc_called(this, "_ZN8S10184C23v96Ev");}
void  S10184C2 ::v97(){vfunc_called(this, "_ZN8S10184C23v97Ev");}
void  S10184C2 ::v98(){vfunc_called(this, "_ZN8S10184C23v98Ev");}
void  S10184C2 ::v99(){vfunc_called(this, "_ZN8S10184C23v99Ev");}
void  S10184C2 ::v100(){vfunc_called(this, "_ZN8S10184C24v100Ev");}
void  S10184C2 ::v101(){vfunc_called(this, "_ZN8S10184C24v101Ev");}
void  S10184C2 ::v102(){vfunc_called(this, "_ZN8S10184C24v102Ev");}
void  S10184C2 ::v103(){vfunc_called(this, "_ZN8S10184C24v103Ev");}
void  S10184C2 ::v104(){vfunc_called(this, "_ZN8S10184C24v104Ev");}
void  S10184C2 ::v105(){vfunc_called(this, "_ZN8S10184C24v105Ev");}
void  S10184C2 ::v106(){vfunc_called(this, "_ZN8S10184C24v106Ev");}
void  S10184C2 ::v107(){vfunc_called(this, "_ZN8S10184C24v107Ev");}
void  S10184C2 ::v108(){vfunc_called(this, "_ZN8S10184C24v108Ev");}
void  S10184C2 ::v109(){vfunc_called(this, "_ZN8S10184C24v109Ev");}
void  S10184C2 ::v110(){vfunc_called(this, "_ZN8S10184C24v110Ev");}
void  S10184C2 ::v111(){vfunc_called(this, "_ZN8S10184C24v111Ev");}
void  S10184C2 ::v112(){vfunc_called(this, "_ZN8S10184C24v112Ev");}
void  S10184C2 ::v113(){vfunc_called(this, "_ZN8S10184C24v113Ev");}
void  S10184C2 ::v114(){vfunc_called(this, "_ZN8S10184C24v114Ev");}
void  S10184C2 ::v115(){vfunc_called(this, "_ZN8S10184C24v115Ev");}
void  S10184C2 ::v116(){vfunc_called(this, "_ZN8S10184C24v116Ev");}
void  S10184C2 ::v117(){vfunc_called(this, "_ZN8S10184C24v117Ev");}
void  S10184C2 ::v118(){vfunc_called(this, "_ZN8S10184C24v118Ev");}
void  S10184C2 ::v119(){vfunc_called(this, "_ZN8S10184C24v119Ev");}
void  S10184C2 ::v120(){vfunc_called(this, "_ZN8S10184C24v120Ev");}
void  S10184C2 ::v121(){vfunc_called(this, "_ZN8S10184C24v121Ev");}
void  S10184C2 ::v122(){vfunc_called(this, "_ZN8S10184C24v122Ev");}
void  S10184C2 ::v123(){vfunc_called(this, "_ZN8S10184C24v123Ev");}
void  S10184C2 ::v124(){vfunc_called(this, "_ZN8S10184C24v124Ev");}
void  S10184C2 ::v125(){vfunc_called(this, "_ZN8S10184C24v125Ev");}
void  S10184C2 ::v126(){vfunc_called(this, "_ZN8S10184C24v126Ev");}
void  S10184C2 ::v127(){vfunc_called(this, "_ZN8S10184C24v127Ev");}
void  S10184C2 ::v128(){vfunc_called(this, "_ZN8S10184C24v128Ev");}
void  S10184C2 ::v129(){vfunc_called(this, "_ZN8S10184C24v129Ev");}
void  S10184C2 ::v130(){vfunc_called(this, "_ZN8S10184C24v130Ev");}
void  S10184C2 ::v131(){vfunc_called(this, "_ZN8S10184C24v131Ev");}
void  S10184C2 ::v132(){vfunc_called(this, "_ZN8S10184C24v132Ev");}
void  S10184C2 ::v133(){vfunc_called(this, "_ZN8S10184C24v133Ev");}
void  S10184C2 ::v134(){vfunc_called(this, "_ZN8S10184C24v134Ev");}
void  S10184C2 ::v135(){vfunc_called(this, "_ZN8S10184C24v135Ev");}
void  S10184C2 ::v136(){vfunc_called(this, "_ZN8S10184C24v136Ev");}
void  S10184C2 ::v137(){vfunc_called(this, "_ZN8S10184C24v137Ev");}
void  S10184C2 ::v138(){vfunc_called(this, "_ZN8S10184C24v138Ev");}
void  S10184C2 ::v139(){vfunc_called(this, "_ZN8S10184C24v139Ev");}
void  S10184C2 ::v140(){vfunc_called(this, "_ZN8S10184C24v140Ev");}
void  S10184C2 ::v141(){vfunc_called(this, "_ZN8S10184C24v141Ev");}
void  S10184C2 ::v142(){vfunc_called(this, "_ZN8S10184C24v142Ev");}
void  S10184C2 ::v143(){vfunc_called(this, "_ZN8S10184C24v143Ev");}
void  S10184C2 ::v144(){vfunc_called(this, "_ZN8S10184C24v144Ev");}
void  S10184C2 ::v145(){vfunc_called(this, "_ZN8S10184C24v145Ev");}
void  S10184C2 ::v146(){vfunc_called(this, "_ZN8S10184C24v146Ev");}
void  S10184C2 ::v147(){vfunc_called(this, "_ZN8S10184C24v147Ev");}
void  S10184C2 ::v148(){vfunc_called(this, "_ZN8S10184C24v148Ev");}
void  S10184C2 ::v149(){vfunc_called(this, "_ZN8S10184C24v149Ev");}
void  S10184C2 ::v150(){vfunc_called(this, "_ZN8S10184C24v150Ev");}
void  S10184C2 ::v151(){vfunc_called(this, "_ZN8S10184C24v151Ev");}
void  S10184C2 ::v152(){vfunc_called(this, "_ZN8S10184C24v152Ev");}
void  S10184C2 ::v153(){vfunc_called(this, "_ZN8S10184C24v153Ev");}
void  S10184C2 ::v154(){vfunc_called(this, "_ZN8S10184C24v154Ev");}
void  S10184C2 ::v155(){vfunc_called(this, "_ZN8S10184C24v155Ev");}
void  S10184C2 ::v156(){vfunc_called(this, "_ZN8S10184C24v156Ev");}
S10184C2 ::S10184C2(){ note_ctor("S10184C2", this);} // tgen

static void Test_S10184C2()
{
  extern Class_Descriptor cd_S10184C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10184C2, buf);
    S10184C2 *dp, &lv = *(dp=new (buf) S10184C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10184C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10184C2)");
    test_class_info(&lv, &cd_S10184C2);
    dp->~S10184C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10184C2(Test_S10184C2, "S10184C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10184C2C1Ev();
extern void _ZN8S10184C2D1Ev();
Name_Map name_map_S10184C2[] = {
  NSPAIR(_ZN8S10184C2C1Ev),
  NSPAIR(_ZN8S10184C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10184C2[];
extern void _ZN8S10184C2D1Ev();
extern void _ZN8S10184C2D0Ev();
extern void _ZN8S10184C23v79Ev();
extern void _ZN8S10184C23v80Ev();
extern void _ZN8S10184C23v81Ev();
extern void _ZN8S10184C23v82Ev();
extern void _ZN8S10184C23v83Ev();
extern void _ZN8S10184C23v84Ev();
extern void _ZN8S10184C23v85Ev();
extern void _ZN8S10184C23v86Ev();
extern void _ZN8S10184C23v87Ev();
extern void _ZN8S10184C23v88Ev();
extern void _ZN8S10184C23v89Ev();
extern void _ZN8S10184C23v90Ev();
extern void _ZN8S10184C23v91Ev();
extern void _ZN8S10184C23v92Ev();
extern void _ZN8S10184C23v93Ev();
extern void _ZN8S10184C23v94Ev();
extern void _ZN8S10184C23v95Ev();
extern void _ZN8S10184C23v96Ev();
extern void _ZN8S10184C23v97Ev();
extern void _ZN8S10184C23v98Ev();
extern void _ZN8S10184C23v99Ev();
extern void _ZN8S10184C24v100Ev();
extern void _ZN8S10184C24v101Ev();
extern void _ZN8S10184C24v102Ev();
extern void _ZN8S10184C24v103Ev();
extern void _ZN8S10184C24v104Ev();
extern void _ZN8S10184C24v105Ev();
extern void _ZN8S10184C24v106Ev();
extern void _ZN8S10184C24v107Ev();
extern void _ZN8S10184C24v108Ev();
extern void _ZN8S10184C24v109Ev();
extern void _ZN8S10184C24v110Ev();
extern void _ZN8S10184C24v111Ev();
extern void _ZN8S10184C24v112Ev();
extern void _ZN8S10184C24v113Ev();
extern void _ZN8S10184C24v114Ev();
extern void _ZN8S10184C24v115Ev();
extern void _ZN8S10184C24v116Ev();
extern void _ZN8S10184C24v117Ev();
extern void _ZN8S10184C24v118Ev();
extern void _ZN8S10184C24v119Ev();
extern void _ZN8S10184C24v120Ev();
extern void _ZN8S10184C24v121Ev();
extern void _ZN8S10184C24v122Ev();
extern void _ZN8S10184C24v123Ev();
extern void _ZN8S10184C24v124Ev();
extern void _ZN8S10184C24v125Ev();
extern void _ZN8S10184C24v126Ev();
extern void _ZN8S10184C24v127Ev();
extern void _ZN8S10184C24v128Ev();
extern void _ZN8S10184C24v129Ev();
extern void _ZN8S10184C24v130Ev();
extern void _ZN8S10184C24v131Ev();
extern void _ZN8S10184C24v132Ev();
extern void _ZN8S10184C24v133Ev();
extern void _ZN8S10184C24v134Ev();
extern void _ZN8S10184C24v135Ev();
extern void _ZN8S10184C24v136Ev();
extern void _ZN8S10184C24v137Ev();
extern void _ZN8S10184C24v138Ev();
extern void _ZN8S10184C24v139Ev();
extern void _ZN8S10184C24v140Ev();
extern void _ZN8S10184C24v141Ev();
extern void _ZN8S10184C24v142Ev();
extern void _ZN8S10184C24v143Ev();
extern void _ZN8S10184C24v144Ev();
extern void _ZN8S10184C24v145Ev();
extern void _ZN8S10184C24v146Ev();
extern void _ZN8S10184C24v147Ev();
extern void _ZN8S10184C24v148Ev();
extern void _ZN8S10184C24v149Ev();
extern void _ZN8S10184C24v150Ev();
extern void _ZN8S10184C24v151Ev();
extern void _ZN8S10184C24v152Ev();
extern void _ZN8S10184C24v153Ev();
extern void _ZN8S10184C24v154Ev();
extern void _ZN8S10184C24v155Ev();
extern void _ZN8S10184C24v156Ev();
static  VTBL_ENTRY vtc_S10184C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10184C2[0]),
  (VTBL_ENTRY)&_ZN8S10184C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10184C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v79Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v80Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v81Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v82Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v83Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v84Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v85Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v86Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v87Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v88Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v89Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v90Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v91Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v92Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v93Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v94Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v95Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v96Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v97Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v112Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v113Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v114Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v115Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v116Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v117Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v118Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v119Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v120Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v121Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v122Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v123Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v124Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v125Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v126Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v127Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v128Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v129Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v130Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v131Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v132Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v133Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v134Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v135Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v136Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v137Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v138Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v139Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v140Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v141Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v142Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v143Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v144Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v145Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v146Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v147Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v148Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v149Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v150Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v151Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v152Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v153Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v154Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v155Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v156Ev,
};
extern VTBL_ENTRY _ZTI8S10184C2[];
extern  VTBL_ENTRY _ZTV8S10184C2[];
Class_Descriptor cd_S10184C2 = {  "S10184C2", // class name
  0,0,//no base classes
  &(vtc_S10184C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10184C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10184C2),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10184C4  {
  virtual  ~S10184C4(); // _ZN8S10184C4D1Ev
  virtual void  v157(); // _ZN8S10184C44v157Ev
  virtual void  v158(); // _ZN8S10184C44v158Ev
  virtual void  v159(); // _ZN8S10184C44v159Ev
  S10184C4(); // tgen
};
//SIG(-1 S10184C4) C1{ vd v1 v2 v3}


 S10184C4 ::~S10184C4(){ note_dtor("S10184C4", this);}
void  S10184C4 ::v157(){vfunc_called(this, "_ZN8S10184C44v157Ev");}
void  S10184C4 ::v158(){vfunc_called(this, "_ZN8S10184C44v158Ev");}
void  S10184C4 ::v159(){vfunc_called(this, "_ZN8S10184C44v159Ev");}
S10184C4 ::S10184C4(){ note_ctor("S10184C4", this);} // tgen

static void Test_S10184C4()
{
  extern Class_Descriptor cd_S10184C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10184C4, buf);
    S10184C4 *dp, &lv = *(dp=new (buf) S10184C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10184C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10184C4)");
    test_class_info(&lv, &cd_S10184C4);
    dp->~S10184C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10184C4(Test_S10184C4, "S10184C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10184C4C1Ev();
extern void _ZN8S10184C4D1Ev();
Name_Map name_map_S10184C4[] = {
  NSPAIR(_ZN8S10184C4C1Ev),
  NSPAIR(_ZN8S10184C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10184C4[];
extern void _ZN8S10184C4D1Ev();
extern void _ZN8S10184C4D0Ev();
extern void _ZN8S10184C44v157Ev();
extern void _ZN8S10184C44v158Ev();
extern void _ZN8S10184C44v159Ev();
static  VTBL_ENTRY vtc_S10184C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10184C4[0]),
  (VTBL_ENTRY)&_ZN8S10184C4D1Ev,
  (VTBL_ENTRY)&_ZN8S10184C4D0Ev,
  (VTBL_ENTRY)&_ZN8S10184C44v157Ev,
  (VTBL_ENTRY)&_ZN8S10184C44v158Ev,
  (VTBL_ENTRY)&_ZN8S10184C44v159Ev,
};
extern VTBL_ENTRY _ZTI8S10184C4[];
extern  VTBL_ENTRY _ZTV8S10184C4[];
Class_Descriptor cd_S10184C4 = {  "S10184C4", // class name
  0,0,//no base classes
  &(vtc_S10184C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10184C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10184C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10184C8_nt  {
  __tsi64 s10184c8f0[4];
};
//SIG(-1 S10184C8_nt) C1{ FL[4]}



//skip512 S10184C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10184C7_nt  {
  ::S10184C8_nt s10184c7f0;
  void  mf10184c7(); // _ZN11S10184C7_nt9mf10184c7Ev
};
//SIG(-1 S10184C7_nt) C1{ m FC2{ FL[4]}}


void  S10184C7_nt ::mf10184c7(){}

//skip512 S10184C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10184C3_nt  : S10184C4 {
  ::S10183C20 s10184c3f0;
  ::S10184C7_nt s10184c3f1;
  char s10184c3f2;
  virtual  ~S10184C3_nt(); // _ZN11S10184C3_ntD1Ev
  virtual void  v160(); // _ZN11S10184C3_nt4v160Ev
  virtual void  v161(); // _ZN11S10184C3_nt4v161Ev
  virtual void  v162(); // _ZN11S10184C3_nt4v162Ev
  S10184C3_nt(); // tgen
};
//SIG(-1 S10184C3_nt) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ FL[4]}} Fc}


 S10184C3_nt ::~S10184C3_nt(){ note_dtor("S10184C3_nt", this);}
void  S10184C3_nt ::v160(){vfunc_called(this, "_ZN11S10184C3_nt4v160Ev");}
void  S10184C3_nt ::v161(){vfunc_called(this, "_ZN11S10184C3_nt4v161Ev");}
void  S10184C3_nt ::v162(){vfunc_called(this, "_ZN11S10184C3_nt4v162Ev");}
S10184C3_nt ::S10184C3_nt(){ note_ctor("S10184C3_nt", this);} // tgen

//skip512 S10184C3_nt

#else // __cplusplus

extern void _ZN11S10184C3_ntC1Ev();
extern void _ZN11S10184C3_ntD1Ev();
Name_Map name_map_S10184C3_nt[] = {
  NSPAIR(_ZN11S10184C3_ntC1Ev),
  NSPAIR(_ZN11S10184C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10184C4;
extern VTBL_ENTRY _ZTI8S10184C4[];
extern  VTBL_ENTRY _ZTV8S10184C4[];
static Base_Class bases_S10184C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10184C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S10184C3_nt[];
extern void _ZN11S10184C3_ntD1Ev();
extern void _ZN11S10184C3_ntD0Ev();
extern void _ZN8S10184C44v157Ev();
extern void _ZN8S10184C44v158Ev();
extern void _ZN8S10184C44v159Ev();
extern void _ZN11S10184C3_nt4v160Ev();
extern void _ZN11S10184C3_nt4v161Ev();
extern void _ZN11S10184C3_nt4v162Ev();
static  VTBL_ENTRY vtc_S10184C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10184C3_nt[0]),
  (VTBL_ENTRY)&_ZN11S10184C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10184C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S10184C44v157Ev,
  (VTBL_ENTRY)&_ZN8S10184C44v158Ev,
  (VTBL_ENTRY)&_ZN8S10184C44v159Ev,
  (VTBL_ENTRY)&_ZN11S10184C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN11S10184C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN11S10184C3_nt4v162Ev,
};
extern VTBL_ENTRY _ZTI11S10184C3_nt[];
VTBL_ENTRY *P__ZTI11S10184C3_nt = _ZTI11S10184C3_nt; 
extern  VTBL_ENTRY _ZTV11S10184C3_nt[];
Class_Descriptor cd_S10184C3_nt = {  "S10184C3_nt", // class name
  bases_S10184C3_nt, 1,
  &(vtc_S10184C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI11S10184C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV11S10184C3_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10184C1  : S10184C2 , S10184C3_nt {
  void *s10184c1f0;
  ::S10183C9_nt s10184c1f1;
  void *s10184c1f2;
  ::S10183C13 s10184c1f3;
  ::S10183C17 s10184c1f4;
  int s10184c1f5[2];
  ::S10183C15_nt s10184c1f6;
  ::S10183C17 s10184c1f7;
  int s10184c1f8[2];
  ::S10183C26 s10184c1f9;
  int s10184c1f10[6];
  ::S10183C13 s10184c1f11;
  ::S10183C31 s10184c1f12;
  int s10184c1f13[2];
  ::S10183C29_nt s10184c1f14[16];
  ::S10183C15_nt s10184c1f15;
  char s10184c1f16[128];
  virtual  ~S10184C1(); // _ZN8S10184C1D1Ev
  virtual void  v1(); // _ZN8S10184C12v1Ev
  virtual void  v2(); // _ZN8S10184C12v2Ev
  virtual void  v3(); // _ZN8S10184C12v3Ev
  virtual void  v4(); // _ZN8S10184C12v4Ev
  virtual void  v5(); // _ZN8S10184C12v5Ev
  virtual void  v6(); // _ZN8S10184C12v6Ev
  virtual void  v7(); // _ZN8S10184C12v7Ev
  virtual void  v8(); // _ZN8S10184C12v8Ev
  virtual void  v9(); // _ZN8S10184C12v9Ev
  virtual void  v10(); // _ZN8S10184C13v10Ev
  virtual void  v11(); // _ZN8S10184C13v11Ev
  virtual void  v12(); // _ZN8S10184C13v12Ev
  virtual void  v13(); // _ZN8S10184C13v13Ev
  virtual void  v14(); // _ZN8S10184C13v14Ev
  virtual void  v15(); // _ZN8S10184C13v15Ev
  virtual void  v16(); // _ZN8S10184C13v16Ev
  virtual void  v17(); // _ZN8S10184C13v17Ev
  virtual void  v18(); // _ZN8S10184C13v18Ev
  virtual void  v19(); // _ZN8S10184C13v19Ev
  virtual void  v20(); // _ZN8S10184C13v20Ev
  virtual void  v21(); // _ZN8S10184C13v21Ev
  virtual void  v22(); // _ZN8S10184C13v22Ev
  virtual void  v23(); // _ZN8S10184C13v23Ev
  virtual void  v24(); // _ZN8S10184C13v24Ev
  virtual void  v25(); // _ZN8S10184C13v25Ev
  virtual void  v26(); // _ZN8S10184C13v26Ev
  virtual void  v27(); // _ZN8S10184C13v27Ev
  virtual void  v28(); // _ZN8S10184C13v28Ev
  virtual void  v29(); // _ZN8S10184C13v29Ev
  virtual void  v30(); // _ZN8S10184C13v30Ev
  virtual void  v31(); // _ZN8S10184C13v31Ev
  virtual void  v32(); // _ZN8S10184C13v32Ev
  virtual void  v33(); // _ZN8S10184C13v33Ev
  virtual void  v34(); // _ZN8S10184C13v34Ev
  virtual void  v35(); // _ZN8S10184C13v35Ev
  virtual void  v36(); // _ZN8S10184C13v36Ev
  virtual void  v37(); // _ZN8S10184C13v37Ev
  virtual void  v38(); // _ZN8S10184C13v38Ev
  virtual void  v39(); // _ZN8S10184C13v39Ev
  virtual void  v40(); // _ZN8S10184C13v40Ev
  virtual void  v41(); // _ZN8S10184C13v41Ev
  virtual void  v42(); // _ZN8S10184C13v42Ev
  virtual void  v43(); // _ZN8S10184C13v43Ev
  virtual void  v44(); // _ZN8S10184C13v44Ev
  virtual void  v45(); // _ZN8S10184C13v45Ev
  virtual void  v46(); // _ZN8S10184C13v46Ev
  virtual void  v47(); // _ZN8S10184C13v47Ev
  virtual void  v48(); // _ZN8S10184C13v48Ev
  virtual void  v49(); // _ZN8S10184C13v49Ev
  virtual void  v50(); // _ZN8S10184C13v50Ev
  virtual void  v51(); // _ZN8S10184C13v51Ev
  virtual void  v52(); // _ZN8S10184C13v52Ev
  virtual void  v53(); // _ZN8S10184C13v53Ev
  virtual void  v54(); // _ZN8S10184C13v54Ev
  virtual void  v55(); // _ZN8S10184C13v55Ev
  virtual void  v56(); // _ZN8S10184C13v56Ev
  virtual void  v57(); // _ZN8S10184C13v57Ev
  virtual void  v58(); // _ZN8S10184C13v58Ev
  virtual void  v59(); // _ZN8S10184C13v59Ev
  virtual void  v60(); // _ZN8S10184C13v60Ev
  virtual void  v61(); // _ZN8S10184C13v61Ev
  virtual void  v62(); // _ZN8S10184C13v62Ev
  virtual void  v63(); // _ZN8S10184C13v63Ev
  virtual void  v64(); // _ZN8S10184C13v64Ev
  virtual void  v65(); // _ZN8S10184C13v65Ev
  virtual void  v66(); // _ZN8S10184C13v66Ev
  virtual void  v67(); // _ZN8S10184C13v67Ev
  virtual void  v68(); // _ZN8S10184C13v68Ev
  virtual void  v69(); // _ZN8S10184C13v69Ev
  virtual void  v70(); // _ZN8S10184C13v70Ev
  virtual void  v71(); // _ZN8S10184C13v71Ev
  virtual void  v72(); // _ZN8S10184C13v72Ev
  virtual void  v73(); // _ZN8S10184C13v73Ev
  virtual void  v74(); // _ZN8S10184C13v74Ev
  virtual void  v75(); // _ZN8S10184C13v75Ev
  virtual void  v76(); // _ZN8S10184C13v76Ev
  virtual void  v77(); // _ZN8S10184C13v77Ev
  virtual void  v78(); // _ZN8S10184C13v78Ev
  S10184C1(); // tgen
};
//SIG(1 S10184C1) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156} BC3{ BC4{ vd v157 v158 v159} vd v160 v161 v162 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FC8{ FL[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fp FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} Fp FC13{ BC14{ vd v165 v166} vd v163 v164 FC15{ m Fp Fi FC12} FC15 Fi} FC16{ BC14 vd v167 v168 FC17{ BC14 vd v169 v170 FC15} FC13 FC18{ BC5 BC14 vd v171 v172} FC19{ vd m FC20{ m Fs[6] Fi[2] Fc Fs}} FC15 FC15 Fc[2] Fi FC15 FC15 FC15 FC15 FC15 Fi[3] Fp FC15 FC19 FC15 Fi} Fi[2] FC15 FC16 Fi[2] FC21{ FC22{ Fc[72]} FC23{ Fs[6] Fi} FC24{ FC25{ Fc[20]} Fc[16]} Fc[128] FC23 Fs Fc[30]} Fi[6] FC13 FC26{ Fi FC27{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]} Fi[2] FC24[16] FC15 Fc[128]}


 S10184C1 ::~S10184C1(){ note_dtor("S10184C1", this);}
void  S10184C1 ::v1(){vfunc_called(this, "_ZN8S10184C12v1Ev");}
void  S10184C1 ::v2(){vfunc_called(this, "_ZN8S10184C12v2Ev");}
void  S10184C1 ::v3(){vfunc_called(this, "_ZN8S10184C12v3Ev");}
void  S10184C1 ::v4(){vfunc_called(this, "_ZN8S10184C12v4Ev");}
void  S10184C1 ::v5(){vfunc_called(this, "_ZN8S10184C12v5Ev");}
void  S10184C1 ::v6(){vfunc_called(this, "_ZN8S10184C12v6Ev");}
void  S10184C1 ::v7(){vfunc_called(this, "_ZN8S10184C12v7Ev");}
void  S10184C1 ::v8(){vfunc_called(this, "_ZN8S10184C12v8Ev");}
void  S10184C1 ::v9(){vfunc_called(this, "_ZN8S10184C12v9Ev");}
void  S10184C1 ::v10(){vfunc_called(this, "_ZN8S10184C13v10Ev");}
void  S10184C1 ::v11(){vfunc_called(this, "_ZN8S10184C13v11Ev");}
void  S10184C1 ::v12(){vfunc_called(this, "_ZN8S10184C13v12Ev");}
void  S10184C1 ::v13(){vfunc_called(this, "_ZN8S10184C13v13Ev");}
void  S10184C1 ::v14(){vfunc_called(this, "_ZN8S10184C13v14Ev");}
void  S10184C1 ::v15(){vfunc_called(this, "_ZN8S10184C13v15Ev");}
void  S10184C1 ::v16(){vfunc_called(this, "_ZN8S10184C13v16Ev");}
void  S10184C1 ::v17(){vfunc_called(this, "_ZN8S10184C13v17Ev");}
void  S10184C1 ::v18(){vfunc_called(this, "_ZN8S10184C13v18Ev");}
void  S10184C1 ::v19(){vfunc_called(this, "_ZN8S10184C13v19Ev");}
void  S10184C1 ::v20(){vfunc_called(this, "_ZN8S10184C13v20Ev");}
void  S10184C1 ::v21(){vfunc_called(this, "_ZN8S10184C13v21Ev");}
void  S10184C1 ::v22(){vfunc_called(this, "_ZN8S10184C13v22Ev");}
void  S10184C1 ::v23(){vfunc_called(this, "_ZN8S10184C13v23Ev");}
void  S10184C1 ::v24(){vfunc_called(this, "_ZN8S10184C13v24Ev");}
void  S10184C1 ::v25(){vfunc_called(this, "_ZN8S10184C13v25Ev");}
void  S10184C1 ::v26(){vfunc_called(this, "_ZN8S10184C13v26Ev");}
void  S10184C1 ::v27(){vfunc_called(this, "_ZN8S10184C13v27Ev");}
void  S10184C1 ::v28(){vfunc_called(this, "_ZN8S10184C13v28Ev");}
void  S10184C1 ::v29(){vfunc_called(this, "_ZN8S10184C13v29Ev");}
void  S10184C1 ::v30(){vfunc_called(this, "_ZN8S10184C13v30Ev");}
void  S10184C1 ::v31(){vfunc_called(this, "_ZN8S10184C13v31Ev");}
void  S10184C1 ::v32(){vfunc_called(this, "_ZN8S10184C13v32Ev");}
void  S10184C1 ::v33(){vfunc_called(this, "_ZN8S10184C13v33Ev");}
void  S10184C1 ::v34(){vfunc_called(this, "_ZN8S10184C13v34Ev");}
void  S10184C1 ::v35(){vfunc_called(this, "_ZN8S10184C13v35Ev");}
void  S10184C1 ::v36(){vfunc_called(this, "_ZN8S10184C13v36Ev");}
void  S10184C1 ::v37(){vfunc_called(this, "_ZN8S10184C13v37Ev");}
void  S10184C1 ::v38(){vfunc_called(this, "_ZN8S10184C13v38Ev");}
void  S10184C1 ::v39(){vfunc_called(this, "_ZN8S10184C13v39Ev");}
void  S10184C1 ::v40(){vfunc_called(this, "_ZN8S10184C13v40Ev");}
void  S10184C1 ::v41(){vfunc_called(this, "_ZN8S10184C13v41Ev");}
void  S10184C1 ::v42(){vfunc_called(this, "_ZN8S10184C13v42Ev");}
void  S10184C1 ::v43(){vfunc_called(this, "_ZN8S10184C13v43Ev");}
void  S10184C1 ::v44(){vfunc_called(this, "_ZN8S10184C13v44Ev");}
void  S10184C1 ::v45(){vfunc_called(this, "_ZN8S10184C13v45Ev");}
void  S10184C1 ::v46(){vfunc_called(this, "_ZN8S10184C13v46Ev");}
void  S10184C1 ::v47(){vfunc_called(this, "_ZN8S10184C13v47Ev");}
void  S10184C1 ::v48(){vfunc_called(this, "_ZN8S10184C13v48Ev");}
void  S10184C1 ::v49(){vfunc_called(this, "_ZN8S10184C13v49Ev");}
void  S10184C1 ::v50(){vfunc_called(this, "_ZN8S10184C13v50Ev");}
void  S10184C1 ::v51(){vfunc_called(this, "_ZN8S10184C13v51Ev");}
void  S10184C1 ::v52(){vfunc_called(this, "_ZN8S10184C13v52Ev");}
void  S10184C1 ::v53(){vfunc_called(this, "_ZN8S10184C13v53Ev");}
void  S10184C1 ::v54(){vfunc_called(this, "_ZN8S10184C13v54Ev");}
void  S10184C1 ::v55(){vfunc_called(this, "_ZN8S10184C13v55Ev");}
void  S10184C1 ::v56(){vfunc_called(this, "_ZN8S10184C13v56Ev");}
void  S10184C1 ::v57(){vfunc_called(this, "_ZN8S10184C13v57Ev");}
void  S10184C1 ::v58(){vfunc_called(this, "_ZN8S10184C13v58Ev");}
void  S10184C1 ::v59(){vfunc_called(this, "_ZN8S10184C13v59Ev");}
void  S10184C1 ::v60(){vfunc_called(this, "_ZN8S10184C13v60Ev");}
void  S10184C1 ::v61(){vfunc_called(this, "_ZN8S10184C13v61Ev");}
void  S10184C1 ::v62(){vfunc_called(this, "_ZN8S10184C13v62Ev");}
void  S10184C1 ::v63(){vfunc_called(this, "_ZN8S10184C13v63Ev");}
void  S10184C1 ::v64(){vfunc_called(this, "_ZN8S10184C13v64Ev");}
void  S10184C1 ::v65(){vfunc_called(this, "_ZN8S10184C13v65Ev");}
void  S10184C1 ::v66(){vfunc_called(this, "_ZN8S10184C13v66Ev");}
void  S10184C1 ::v67(){vfunc_called(this, "_ZN8S10184C13v67Ev");}
void  S10184C1 ::v68(){vfunc_called(this, "_ZN8S10184C13v68Ev");}
void  S10184C1 ::v69(){vfunc_called(this, "_ZN8S10184C13v69Ev");}
void  S10184C1 ::v70(){vfunc_called(this, "_ZN8S10184C13v70Ev");}
void  S10184C1 ::v71(){vfunc_called(this, "_ZN8S10184C13v71Ev");}
void  S10184C1 ::v72(){vfunc_called(this, "_ZN8S10184C13v72Ev");}
void  S10184C1 ::v73(){vfunc_called(this, "_ZN8S10184C13v73Ev");}
void  S10184C1 ::v74(){vfunc_called(this, "_ZN8S10184C13v74Ev");}
void  S10184C1 ::v75(){vfunc_called(this, "_ZN8S10184C13v75Ev");}
void  S10184C1 ::v76(){vfunc_called(this, "_ZN8S10184C13v76Ev");}
void  S10184C1 ::v77(){vfunc_called(this, "_ZN8S10184C13v77Ev");}
void  S10184C1 ::v78(){vfunc_called(this, "_ZN8S10184C13v78Ev");}
S10184C1 ::S10184C1(){ note_ctor("S10184C1", this);} // tgen

static void Test_S10184C1()
{
  extern Class_Descriptor cd_S10184C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(276,473)];
    init_test(&cd_S10184C1, buf);
    S10184C1 *dp, &lv = *(dp=new (buf) S10184C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2200,1888), "sizeof(S10184C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10184C1)");
    check_base_class_offset(lv, (S10184C2*), 0, "S10184C1");
    check_base_class_offset(lv, (S10184C4*)(S10184C3_nt*), ABISELECT(8,4), "S10184C1");
    check_base_class_offset(lv, (S10184C3_nt*), ABISELECT(8,4), "S10184C1");
    check_field_offset(lv, s10184c1f0, ABISELECT(80,60), "S10184C1.s10184c1f0");
    check_field_offset(lv, s10184c1f1, ABISELECT(88,64), "S10184C1.s10184c1f1");
    check_field_offset(lv, s10184c1f2, ABISELECT(104,76), "S10184C1.s10184c1f2");
    check_field_offset(lv, s10184c1f3, ABISELECT(112,80), "S10184C1.s10184c1f3");
    check_field_offset(lv, s10184c1f4, ABISELECT(160,112), "S10184C1.s10184c1f4");
    check_field_offset(lv, s10184c1f5, ABISELECT(520,376), "S10184C1.s10184c1f5");
    check_field_offset(lv, s10184c1f6, ABISELECT(528,384), "S10184C1.s10184c1f6");
    check_field_offset(lv, s10184c1f7, ABISELECT(544,396), "S10184C1.s10184c1f7");
    check_field_offset(lv, s10184c1f8, ABISELECT(904,660), "S10184C1.s10184c1f8");
    check_field_offset(lv, s10184c1f9, ABISELECT(912,668), "S10184C1.s10184c1f9");
    check_field_offset(lv, s10184c1f10, ABISELECT(1212,968), "S10184C1.s10184c1f10");
    check_field_offset(lv, s10184c1f11, ABISELECT(1240,992), "S10184C1.s10184c1f11");
    check_field_offset(lv, s10184c1f12, ABISELECT(1288,1024), "S10184C1.s10184c1f12");
    check_field_offset(lv, s10184c1f13, ABISELECT(1472,1164), "S10184C1.s10184c1f13");
    check_field_offset(lv, s10184c1f14, ABISELECT(1480,1172), "S10184C1.s10184c1f14");
    check_field_offset(lv, s10184c1f15, ABISELECT(2056,1748), "S10184C1.s10184c1f15");
    check_field_offset(lv, s10184c1f16, ABISELECT(2072,1760), "S10184C1.s10184c1f16");
    test_class_info(&lv, &cd_S10184C1);
    dp->~S10184C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10184C1(Test_S10184C1, "S10184C1", ABISELECT(2200,1888));

#else // __cplusplus

extern void _ZN8S10184C1C1Ev();
extern void _ZN8S10184C1D1Ev();
Name_Map name_map_S10184C1[] = {
  NSPAIR(_ZN8S10184C1C1Ev),
  NSPAIR(_ZN8S10184C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10184C2;
extern VTBL_ENTRY _ZTI8S10184C2[];
extern  VTBL_ENTRY _ZTV8S10184C2[];
extern Class_Descriptor cd_S10184C4;
extern VTBL_ENTRY _ZTI8S10184C4[];
extern  VTBL_ENTRY _ZTV8S10184C4[];
extern Class_Descriptor cd_S10184C3_nt;
extern VTBL_ENTRY _ZTI11S10184C3_nt[];
extern  VTBL_ENTRY _ZTV11S10184C3_nt[];
static Base_Class bases_S10184C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10184C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10184C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10184C3_nt,    ABISELECT(8,4), //bcp->offset
    160, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10184C1[];
extern void _ZN8S10184C1D1Ev();
extern void _ZN8S10184C1D0Ev();
extern void _ZN8S10184C23v79Ev();
extern void _ZN8S10184C23v80Ev();
extern void _ZN8S10184C23v81Ev();
extern void _ZN8S10184C23v82Ev();
extern void _ZN8S10184C23v83Ev();
extern void _ZN8S10184C23v84Ev();
extern void _ZN8S10184C23v85Ev();
extern void _ZN8S10184C23v86Ev();
extern void _ZN8S10184C23v87Ev();
extern void _ZN8S10184C23v88Ev();
extern void _ZN8S10184C23v89Ev();
extern void _ZN8S10184C23v90Ev();
extern void _ZN8S10184C23v91Ev();
extern void _ZN8S10184C23v92Ev();
extern void _ZN8S10184C23v93Ev();
extern void _ZN8S10184C23v94Ev();
extern void _ZN8S10184C23v95Ev();
extern void _ZN8S10184C23v96Ev();
extern void _ZN8S10184C23v97Ev();
extern void _ZN8S10184C23v98Ev();
extern void _ZN8S10184C23v99Ev();
extern void _ZN8S10184C24v100Ev();
extern void _ZN8S10184C24v101Ev();
extern void _ZN8S10184C24v102Ev();
extern void _ZN8S10184C24v103Ev();
extern void _ZN8S10184C24v104Ev();
extern void _ZN8S10184C24v105Ev();
extern void _ZN8S10184C24v106Ev();
extern void _ZN8S10184C24v107Ev();
extern void _ZN8S10184C24v108Ev();
extern void _ZN8S10184C24v109Ev();
extern void _ZN8S10184C24v110Ev();
extern void _ZN8S10184C24v111Ev();
extern void _ZN8S10184C24v112Ev();
extern void _ZN8S10184C24v113Ev();
extern void _ZN8S10184C24v114Ev();
extern void _ZN8S10184C24v115Ev();
extern void _ZN8S10184C24v116Ev();
extern void _ZN8S10184C24v117Ev();
extern void _ZN8S10184C24v118Ev();
extern void _ZN8S10184C24v119Ev();
extern void _ZN8S10184C24v120Ev();
extern void _ZN8S10184C24v121Ev();
extern void _ZN8S10184C24v122Ev();
extern void _ZN8S10184C24v123Ev();
extern void _ZN8S10184C24v124Ev();
extern void _ZN8S10184C24v125Ev();
extern void _ZN8S10184C24v126Ev();
extern void _ZN8S10184C24v127Ev();
extern void _ZN8S10184C24v128Ev();
extern void _ZN8S10184C24v129Ev();
extern void _ZN8S10184C24v130Ev();
extern void _ZN8S10184C24v131Ev();
extern void _ZN8S10184C24v132Ev();
extern void _ZN8S10184C24v133Ev();
extern void _ZN8S10184C24v134Ev();
extern void _ZN8S10184C24v135Ev();
extern void _ZN8S10184C24v136Ev();
extern void _ZN8S10184C24v137Ev();
extern void _ZN8S10184C24v138Ev();
extern void _ZN8S10184C24v139Ev();
extern void _ZN8S10184C24v140Ev();
extern void _ZN8S10184C24v141Ev();
extern void _ZN8S10184C24v142Ev();
extern void _ZN8S10184C24v143Ev();
extern void _ZN8S10184C24v144Ev();
extern void _ZN8S10184C24v145Ev();
extern void _ZN8S10184C24v146Ev();
extern void _ZN8S10184C24v147Ev();
extern void _ZN8S10184C24v148Ev();
extern void _ZN8S10184C24v149Ev();
extern void _ZN8S10184C24v150Ev();
extern void _ZN8S10184C24v151Ev();
extern void _ZN8S10184C24v152Ev();
extern void _ZN8S10184C24v153Ev();
extern void _ZN8S10184C24v154Ev();
extern void _ZN8S10184C24v155Ev();
extern void _ZN8S10184C24v156Ev();
extern void _ZN8S10184C12v1Ev();
extern void _ZN8S10184C12v2Ev();
extern void _ZN8S10184C12v3Ev();
extern void _ZN8S10184C12v4Ev();
extern void _ZN8S10184C12v5Ev();
extern void _ZN8S10184C12v6Ev();
extern void _ZN8S10184C12v7Ev();
extern void _ZN8S10184C12v8Ev();
extern void _ZN8S10184C12v9Ev();
extern void _ZN8S10184C13v10Ev();
extern void _ZN8S10184C13v11Ev();
extern void _ZN8S10184C13v12Ev();
extern void _ZN8S10184C13v13Ev();
extern void _ZN8S10184C13v14Ev();
extern void _ZN8S10184C13v15Ev();
extern void _ZN8S10184C13v16Ev();
extern void _ZN8S10184C13v17Ev();
extern void _ZN8S10184C13v18Ev();
extern void _ZN8S10184C13v19Ev();
extern void _ZN8S10184C13v20Ev();
extern void _ZN8S10184C13v21Ev();
extern void _ZN8S10184C13v22Ev();
extern void _ZN8S10184C13v23Ev();
extern void _ZN8S10184C13v24Ev();
extern void _ZN8S10184C13v25Ev();
extern void _ZN8S10184C13v26Ev();
extern void _ZN8S10184C13v27Ev();
extern void _ZN8S10184C13v28Ev();
extern void _ZN8S10184C13v29Ev();
extern void _ZN8S10184C13v30Ev();
extern void _ZN8S10184C13v31Ev();
extern void _ZN8S10184C13v32Ev();
extern void _ZN8S10184C13v33Ev();
extern void _ZN8S10184C13v34Ev();
extern void _ZN8S10184C13v35Ev();
extern void _ZN8S10184C13v36Ev();
extern void _ZN8S10184C13v37Ev();
extern void _ZN8S10184C13v38Ev();
extern void _ZN8S10184C13v39Ev();
extern void _ZN8S10184C13v40Ev();
extern void _ZN8S10184C13v41Ev();
extern void _ZN8S10184C13v42Ev();
extern void _ZN8S10184C13v43Ev();
extern void _ZN8S10184C13v44Ev();
extern void _ZN8S10184C13v45Ev();
extern void _ZN8S10184C13v46Ev();
extern void _ZN8S10184C13v47Ev();
extern void _ZN8S10184C13v48Ev();
extern void _ZN8S10184C13v49Ev();
extern void _ZN8S10184C13v50Ev();
extern void _ZN8S10184C13v51Ev();
extern void _ZN8S10184C13v52Ev();
extern void _ZN8S10184C13v53Ev();
extern void _ZN8S10184C13v54Ev();
extern void _ZN8S10184C13v55Ev();
extern void _ZN8S10184C13v56Ev();
extern void _ZN8S10184C13v57Ev();
extern void _ZN8S10184C13v58Ev();
extern void _ZN8S10184C13v59Ev();
extern void _ZN8S10184C13v60Ev();
extern void _ZN8S10184C13v61Ev();
extern void _ZN8S10184C13v62Ev();
extern void _ZN8S10184C13v63Ev();
extern void _ZN8S10184C13v64Ev();
extern void _ZN8S10184C13v65Ev();
extern void _ZN8S10184C13v66Ev();
extern void _ZN8S10184C13v67Ev();
extern void _ZN8S10184C13v68Ev();
extern void _ZN8S10184C13v69Ev();
extern void _ZN8S10184C13v70Ev();
extern void _ZN8S10184C13v71Ev();
extern void _ZN8S10184C13v72Ev();
extern void _ZN8S10184C13v73Ev();
extern void _ZN8S10184C13v74Ev();
extern void _ZN8S10184C13v75Ev();
extern void _ZN8S10184C13v76Ev();
extern void _ZN8S10184C13v77Ev();
extern void _ZN8S10184C13v78Ev();
extern void ABISELECT(_ZThn8_N8S10184C1D1Ev,_ZThn4_N8S10184C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10184C1D0Ev,_ZThn4_N8S10184C1D0Ev)();
extern void _ZN8S10184C44v157Ev();
extern void _ZN8S10184C44v158Ev();
extern void _ZN8S10184C44v159Ev();
extern void _ZN11S10184C3_nt4v160Ev();
extern void _ZN11S10184C3_nt4v161Ev();
extern void _ZN11S10184C3_nt4v162Ev();
static  VTBL_ENTRY vtc_S10184C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10184C1[0]),
  (VTBL_ENTRY)&_ZN8S10184C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10184C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v79Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v80Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v81Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v82Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v83Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v84Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v85Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v86Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v87Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v88Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v89Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v90Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v91Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v92Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v93Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v94Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v95Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v96Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v97Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10184C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v112Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v113Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v114Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v115Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v116Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v117Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v118Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v119Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v120Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v121Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v122Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v123Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v124Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v125Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v126Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v127Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v128Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v129Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v130Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v131Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v132Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v133Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v134Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v135Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v136Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v137Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v138Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v139Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v140Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v141Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v142Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v143Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v144Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v145Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v146Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v147Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v148Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v149Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v150Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v151Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v152Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v153Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v154Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v155Ev,
  (VTBL_ENTRY)&_ZN8S10184C24v156Ev,
  (VTBL_ENTRY)&_ZN8S10184C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10184C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10184C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10184C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10184C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10184C12v6Ev,
  (VTBL_ENTRY)&_ZN8S10184C12v7Ev,
  (VTBL_ENTRY)&_ZN8S10184C12v8Ev,
  (VTBL_ENTRY)&_ZN8S10184C12v9Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v10Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v11Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v12Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v13Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v14Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v15Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v16Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v17Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v18Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v19Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v20Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v21Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v22Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v23Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v24Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v25Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v26Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v27Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v28Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v29Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v30Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v31Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v32Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v33Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v34Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v35Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v36Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v37Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v38Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v39Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v40Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v41Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v42Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v43Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v44Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v45Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v46Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v47Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v48Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v49Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v50Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v51Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v52Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v53Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v54Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v55Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v56Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v57Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v58Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v59Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v60Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v61Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v62Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v63Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v64Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v65Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v66Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v67Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v68Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v69Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v70Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v71Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v72Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v73Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v74Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v75Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v76Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v77Ev,
  (VTBL_ENTRY)&_ZN8S10184C13v78Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10184C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10184C1D1Ev,_ZThn4_N8S10184C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10184C1D0Ev,_ZThn4_N8S10184C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10184C44v157Ev,
  (VTBL_ENTRY)&_ZN8S10184C44v158Ev,
  (VTBL_ENTRY)&_ZN8S10184C44v159Ev,
  (VTBL_ENTRY)&_ZN11S10184C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN11S10184C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN11S10184C3_nt4v162Ev,
};
extern VTBL_ENTRY _ZTI8S10184C1[];
extern  VTBL_ENTRY _ZTV8S10184C1[];
Class_Descriptor cd_S10184C1 = {  "S10184C1", // class name
  bases_S10184C1, 3,
  &(vtc_S10184C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2200,1888), // object size
  NSPAIRA(_ZTI8S10184C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10184C1),170, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10185C2  {
  virtual  ~S10185C2(); // _ZN8S10185C2D1Ev
  virtual void  v79(); // _ZN8S10185C23v79Ev
  virtual void  v80(); // _ZN8S10185C23v80Ev
  virtual void  v81(); // _ZN8S10185C23v81Ev
  virtual void  v82(); // _ZN8S10185C23v82Ev
  virtual void  v83(); // _ZN8S10185C23v83Ev
  virtual void  v84(); // _ZN8S10185C23v84Ev
  virtual void  v85(); // _ZN8S10185C23v85Ev
  virtual void  v86(); // _ZN8S10185C23v86Ev
  virtual void  v87(); // _ZN8S10185C23v87Ev
  virtual void  v88(); // _ZN8S10185C23v88Ev
  virtual void  v89(); // _ZN8S10185C23v89Ev
  virtual void  v90(); // _ZN8S10185C23v90Ev
  virtual void  v91(); // _ZN8S10185C23v91Ev
  virtual void  v92(); // _ZN8S10185C23v92Ev
  virtual void  v93(); // _ZN8S10185C23v93Ev
  virtual void  v94(); // _ZN8S10185C23v94Ev
  virtual void  v95(); // _ZN8S10185C23v95Ev
  virtual void  v96(); // _ZN8S10185C23v96Ev
  virtual void  v97(); // _ZN8S10185C23v97Ev
  virtual void  v98(); // _ZN8S10185C23v98Ev
  virtual void  v99(); // _ZN8S10185C23v99Ev
  virtual void  v100(); // _ZN8S10185C24v100Ev
  virtual void  v101(); // _ZN8S10185C24v101Ev
  virtual void  v102(); // _ZN8S10185C24v102Ev
  virtual void  v103(); // _ZN8S10185C24v103Ev
  virtual void  v104(); // _ZN8S10185C24v104Ev
  virtual void  v105(); // _ZN8S10185C24v105Ev
  virtual void  v106(); // _ZN8S10185C24v106Ev
  virtual void  v107(); // _ZN8S10185C24v107Ev
  virtual void  v108(); // _ZN8S10185C24v108Ev
  virtual void  v109(); // _ZN8S10185C24v109Ev
  virtual void  v110(); // _ZN8S10185C24v110Ev
  virtual void  v111(); // _ZN8S10185C24v111Ev
  virtual void  v112(); // _ZN8S10185C24v112Ev
  virtual void  v113(); // _ZN8S10185C24v113Ev
  virtual void  v114(); // _ZN8S10185C24v114Ev
  virtual void  v115(); // _ZN8S10185C24v115Ev
  virtual void  v116(); // _ZN8S10185C24v116Ev
  virtual void  v117(); // _ZN8S10185C24v117Ev
  virtual void  v118(); // _ZN8S10185C24v118Ev
  virtual void  v119(); // _ZN8S10185C24v119Ev
  virtual void  v120(); // _ZN8S10185C24v120Ev
  virtual void  v121(); // _ZN8S10185C24v121Ev
  virtual void  v122(); // _ZN8S10185C24v122Ev
  virtual void  v123(); // _ZN8S10185C24v123Ev
  virtual void  v124(); // _ZN8S10185C24v124Ev
  virtual void  v125(); // _ZN8S10185C24v125Ev
  virtual void  v126(); // _ZN8S10185C24v126Ev
  virtual void  v127(); // _ZN8S10185C24v127Ev
  virtual void  v128(); // _ZN8S10185C24v128Ev
  virtual void  v129(); // _ZN8S10185C24v129Ev
  virtual void  v130(); // _ZN8S10185C24v130Ev
  virtual void  v131(); // _ZN8S10185C24v131Ev
  virtual void  v132(); // _ZN8S10185C24v132Ev
  virtual void  v133(); // _ZN8S10185C24v133Ev
  virtual void  v134(); // _ZN8S10185C24v134Ev
  virtual void  v135(); // _ZN8S10185C24v135Ev
  virtual void  v136(); // _ZN8S10185C24v136Ev
  virtual void  v137(); // _ZN8S10185C24v137Ev
  virtual void  v138(); // _ZN8S10185C24v138Ev
  virtual void  v139(); // _ZN8S10185C24v139Ev
  virtual void  v140(); // _ZN8S10185C24v140Ev
  virtual void  v141(); // _ZN8S10185C24v141Ev
  virtual void  v142(); // _ZN8S10185C24v142Ev
  virtual void  v143(); // _ZN8S10185C24v143Ev
  virtual void  v144(); // _ZN8S10185C24v144Ev
  virtual void  v145(); // _ZN8S10185C24v145Ev
  virtual void  v146(); // _ZN8S10185C24v146Ev
  virtual void  v147(); // _ZN8S10185C24v147Ev
  virtual void  v148(); // _ZN8S10185C24v148Ev
  virtual void  v149(); // _ZN8S10185C24v149Ev
  virtual void  v150(); // _ZN8S10185C24v150Ev
  virtual void  v151(); // _ZN8S10185C24v151Ev
  virtual void  v152(); // _ZN8S10185C24v152Ev
  virtual void  v153(); // _ZN8S10185C24v153Ev
  virtual void  v154(); // _ZN8S10185C24v154Ev
  virtual void  v155(); // _ZN8S10185C24v155Ev
  virtual void  v156(); // _ZN8S10185C24v156Ev
  S10185C2(); // tgen
};
//SIG(-1 S10185C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78}


 S10185C2 ::~S10185C2(){ note_dtor("S10185C2", this);}
void  S10185C2 ::v79(){vfunc_called(this, "_ZN8S10185C23v79Ev");}
void  S10185C2 ::v80(){vfunc_called(this, "_ZN8S10185C23v80Ev");}
void  S10185C2 ::v81(){vfunc_called(this, "_ZN8S10185C23v81Ev");}
void  S10185C2 ::v82(){vfunc_called(this, "_ZN8S10185C23v82Ev");}
void  S10185C2 ::v83(){vfunc_called(this, "_ZN8S10185C23v83Ev");}
void  S10185C2 ::v84(){vfunc_called(this, "_ZN8S10185C23v84Ev");}
void  S10185C2 ::v85(){vfunc_called(this, "_ZN8S10185C23v85Ev");}
void  S10185C2 ::v86(){vfunc_called(this, "_ZN8S10185C23v86Ev");}
void  S10185C2 ::v87(){vfunc_called(this, "_ZN8S10185C23v87Ev");}
void  S10185C2 ::v88(){vfunc_called(this, "_ZN8S10185C23v88Ev");}
void  S10185C2 ::v89(){vfunc_called(this, "_ZN8S10185C23v89Ev");}
void  S10185C2 ::v90(){vfunc_called(this, "_ZN8S10185C23v90Ev");}
void  S10185C2 ::v91(){vfunc_called(this, "_ZN8S10185C23v91Ev");}
void  S10185C2 ::v92(){vfunc_called(this, "_ZN8S10185C23v92Ev");}
void  S10185C2 ::v93(){vfunc_called(this, "_ZN8S10185C23v93Ev");}
void  S10185C2 ::v94(){vfunc_called(this, "_ZN8S10185C23v94Ev");}
void  S10185C2 ::v95(){vfunc_called(this, "_ZN8S10185C23v95Ev");}
void  S10185C2 ::v96(){vfunc_called(this, "_ZN8S10185C23v96Ev");}
void  S10185C2 ::v97(){vfunc_called(this, "_ZN8S10185C23v97Ev");}
void  S10185C2 ::v98(){vfunc_called(this, "_ZN8S10185C23v98Ev");}
void  S10185C2 ::v99(){vfunc_called(this, "_ZN8S10185C23v99Ev");}
void  S10185C2 ::v100(){vfunc_called(this, "_ZN8S10185C24v100Ev");}
void  S10185C2 ::v101(){vfunc_called(this, "_ZN8S10185C24v101Ev");}
void  S10185C2 ::v102(){vfunc_called(this, "_ZN8S10185C24v102Ev");}
void  S10185C2 ::v103(){vfunc_called(this, "_ZN8S10185C24v103Ev");}
void  S10185C2 ::v104(){vfunc_called(this, "_ZN8S10185C24v104Ev");}
void  S10185C2 ::v105(){vfunc_called(this, "_ZN8S10185C24v105Ev");}
void  S10185C2 ::v106(){vfunc_called(this, "_ZN8S10185C24v106Ev");}
void  S10185C2 ::v107(){vfunc_called(this, "_ZN8S10185C24v107Ev");}
void  S10185C2 ::v108(){vfunc_called(this, "_ZN8S10185C24v108Ev");}
void  S10185C2 ::v109(){vfunc_called(this, "_ZN8S10185C24v109Ev");}
void  S10185C2 ::v110(){vfunc_called(this, "_ZN8S10185C24v110Ev");}
void  S10185C2 ::v111(){vfunc_called(this, "_ZN8S10185C24v111Ev");}
void  S10185C2 ::v112(){vfunc_called(this, "_ZN8S10185C24v112Ev");}
void  S10185C2 ::v113(){vfunc_called(this, "_ZN8S10185C24v113Ev");}
void  S10185C2 ::v114(){vfunc_called(this, "_ZN8S10185C24v114Ev");}
void  S10185C2 ::v115(){vfunc_called(this, "_ZN8S10185C24v115Ev");}
void  S10185C2 ::v116(){vfunc_called(this, "_ZN8S10185C24v116Ev");}
void  S10185C2 ::v117(){vfunc_called(this, "_ZN8S10185C24v117Ev");}
void  S10185C2 ::v118(){vfunc_called(this, "_ZN8S10185C24v118Ev");}
void  S10185C2 ::v119(){vfunc_called(this, "_ZN8S10185C24v119Ev");}
void  S10185C2 ::v120(){vfunc_called(this, "_ZN8S10185C24v120Ev");}
void  S10185C2 ::v121(){vfunc_called(this, "_ZN8S10185C24v121Ev");}
void  S10185C2 ::v122(){vfunc_called(this, "_ZN8S10185C24v122Ev");}
void  S10185C2 ::v123(){vfunc_called(this, "_ZN8S10185C24v123Ev");}
void  S10185C2 ::v124(){vfunc_called(this, "_ZN8S10185C24v124Ev");}
void  S10185C2 ::v125(){vfunc_called(this, "_ZN8S10185C24v125Ev");}
void  S10185C2 ::v126(){vfunc_called(this, "_ZN8S10185C24v126Ev");}
void  S10185C2 ::v127(){vfunc_called(this, "_ZN8S10185C24v127Ev");}
void  S10185C2 ::v128(){vfunc_called(this, "_ZN8S10185C24v128Ev");}
void  S10185C2 ::v129(){vfunc_called(this, "_ZN8S10185C24v129Ev");}
void  S10185C2 ::v130(){vfunc_called(this, "_ZN8S10185C24v130Ev");}
void  S10185C2 ::v131(){vfunc_called(this, "_ZN8S10185C24v131Ev");}
void  S10185C2 ::v132(){vfunc_called(this, "_ZN8S10185C24v132Ev");}
void  S10185C2 ::v133(){vfunc_called(this, "_ZN8S10185C24v133Ev");}
void  S10185C2 ::v134(){vfunc_called(this, "_ZN8S10185C24v134Ev");}
void  S10185C2 ::v135(){vfunc_called(this, "_ZN8S10185C24v135Ev");}
void  S10185C2 ::v136(){vfunc_called(this, "_ZN8S10185C24v136Ev");}
void  S10185C2 ::v137(){vfunc_called(this, "_ZN8S10185C24v137Ev");}
void  S10185C2 ::v138(){vfunc_called(this, "_ZN8S10185C24v138Ev");}
void  S10185C2 ::v139(){vfunc_called(this, "_ZN8S10185C24v139Ev");}
void  S10185C2 ::v140(){vfunc_called(this, "_ZN8S10185C24v140Ev");}
void  S10185C2 ::v141(){vfunc_called(this, "_ZN8S10185C24v141Ev");}
void  S10185C2 ::v142(){vfunc_called(this, "_ZN8S10185C24v142Ev");}
void  S10185C2 ::v143(){vfunc_called(this, "_ZN8S10185C24v143Ev");}
void  S10185C2 ::v144(){vfunc_called(this, "_ZN8S10185C24v144Ev");}
void  S10185C2 ::v145(){vfunc_called(this, "_ZN8S10185C24v145Ev");}
void  S10185C2 ::v146(){vfunc_called(this, "_ZN8S10185C24v146Ev");}
void  S10185C2 ::v147(){vfunc_called(this, "_ZN8S10185C24v147Ev");}
void  S10185C2 ::v148(){vfunc_called(this, "_ZN8S10185C24v148Ev");}
void  S10185C2 ::v149(){vfunc_called(this, "_ZN8S10185C24v149Ev");}
void  S10185C2 ::v150(){vfunc_called(this, "_ZN8S10185C24v150Ev");}
void  S10185C2 ::v151(){vfunc_called(this, "_ZN8S10185C24v151Ev");}
void  S10185C2 ::v152(){vfunc_called(this, "_ZN8S10185C24v152Ev");}
void  S10185C2 ::v153(){vfunc_called(this, "_ZN8S10185C24v153Ev");}
void  S10185C2 ::v154(){vfunc_called(this, "_ZN8S10185C24v154Ev");}
void  S10185C2 ::v155(){vfunc_called(this, "_ZN8S10185C24v155Ev");}
void  S10185C2 ::v156(){vfunc_called(this, "_ZN8S10185C24v156Ev");}
S10185C2 ::S10185C2(){ note_ctor("S10185C2", this);} // tgen

static void Test_S10185C2()
{
  extern Class_Descriptor cd_S10185C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10185C2, buf);
    S10185C2 *dp, &lv = *(dp=new (buf) S10185C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10185C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10185C2)");
    test_class_info(&lv, &cd_S10185C2);
    dp->~S10185C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10185C2(Test_S10185C2, "S10185C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10185C2C1Ev();
extern void _ZN8S10185C2D1Ev();
Name_Map name_map_S10185C2[] = {
  NSPAIR(_ZN8S10185C2C1Ev),
  NSPAIR(_ZN8S10185C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10185C2[];
extern void _ZN8S10185C2D1Ev();
extern void _ZN8S10185C2D0Ev();
extern void _ZN8S10185C23v79Ev();
extern void _ZN8S10185C23v80Ev();
extern void _ZN8S10185C23v81Ev();
extern void _ZN8S10185C23v82Ev();
extern void _ZN8S10185C23v83Ev();
extern void _ZN8S10185C23v84Ev();
extern void _ZN8S10185C23v85Ev();
extern void _ZN8S10185C23v86Ev();
extern void _ZN8S10185C23v87Ev();
extern void _ZN8S10185C23v88Ev();
extern void _ZN8S10185C23v89Ev();
extern void _ZN8S10185C23v90Ev();
extern void _ZN8S10185C23v91Ev();
extern void _ZN8S10185C23v92Ev();
extern void _ZN8S10185C23v93Ev();
extern void _ZN8S10185C23v94Ev();
extern void _ZN8S10185C23v95Ev();
extern void _ZN8S10185C23v96Ev();
extern void _ZN8S10185C23v97Ev();
extern void _ZN8S10185C23v98Ev();
extern void _ZN8S10185C23v99Ev();
extern void _ZN8S10185C24v100Ev();
extern void _ZN8S10185C24v101Ev();
extern void _ZN8S10185C24v102Ev();
extern void _ZN8S10185C24v103Ev();
extern void _ZN8S10185C24v104Ev();
extern void _ZN8S10185C24v105Ev();
extern void _ZN8S10185C24v106Ev();
extern void _ZN8S10185C24v107Ev();
extern void _ZN8S10185C24v108Ev();
extern void _ZN8S10185C24v109Ev();
extern void _ZN8S10185C24v110Ev();
extern void _ZN8S10185C24v111Ev();
extern void _ZN8S10185C24v112Ev();
extern void _ZN8S10185C24v113Ev();
extern void _ZN8S10185C24v114Ev();
extern void _ZN8S10185C24v115Ev();
extern void _ZN8S10185C24v116Ev();
extern void _ZN8S10185C24v117Ev();
extern void _ZN8S10185C24v118Ev();
extern void _ZN8S10185C24v119Ev();
extern void _ZN8S10185C24v120Ev();
extern void _ZN8S10185C24v121Ev();
extern void _ZN8S10185C24v122Ev();
extern void _ZN8S10185C24v123Ev();
extern void _ZN8S10185C24v124Ev();
extern void _ZN8S10185C24v125Ev();
extern void _ZN8S10185C24v126Ev();
extern void _ZN8S10185C24v127Ev();
extern void _ZN8S10185C24v128Ev();
extern void _ZN8S10185C24v129Ev();
extern void _ZN8S10185C24v130Ev();
extern void _ZN8S10185C24v131Ev();
extern void _ZN8S10185C24v132Ev();
extern void _ZN8S10185C24v133Ev();
extern void _ZN8S10185C24v134Ev();
extern void _ZN8S10185C24v135Ev();
extern void _ZN8S10185C24v136Ev();
extern void _ZN8S10185C24v137Ev();
extern void _ZN8S10185C24v138Ev();
extern void _ZN8S10185C24v139Ev();
extern void _ZN8S10185C24v140Ev();
extern void _ZN8S10185C24v141Ev();
extern void _ZN8S10185C24v142Ev();
extern void _ZN8S10185C24v143Ev();
extern void _ZN8S10185C24v144Ev();
extern void _ZN8S10185C24v145Ev();
extern void _ZN8S10185C24v146Ev();
extern void _ZN8S10185C24v147Ev();
extern void _ZN8S10185C24v148Ev();
extern void _ZN8S10185C24v149Ev();
extern void _ZN8S10185C24v150Ev();
extern void _ZN8S10185C24v151Ev();
extern void _ZN8S10185C24v152Ev();
extern void _ZN8S10185C24v153Ev();
extern void _ZN8S10185C24v154Ev();
extern void _ZN8S10185C24v155Ev();
extern void _ZN8S10185C24v156Ev();
static  VTBL_ENTRY vtc_S10185C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10185C2[0]),
  (VTBL_ENTRY)&_ZN8S10185C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10185C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v79Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v80Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v81Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v82Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v83Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v84Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v85Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v86Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v87Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v88Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v89Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v90Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v91Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v92Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v93Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v94Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v95Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v96Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v97Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v112Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v113Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v114Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v115Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v116Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v117Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v118Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v119Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v120Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v121Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v122Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v123Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v124Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v125Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v126Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v127Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v128Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v129Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v130Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v131Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v132Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v133Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v134Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v135Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v136Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v137Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v138Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v139Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v140Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v141Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v142Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v143Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v144Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v145Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v146Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v147Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v148Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v149Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v150Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v151Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v152Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v153Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v154Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v155Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v156Ev,
};
extern VTBL_ENTRY _ZTI8S10185C2[];
extern  VTBL_ENTRY _ZTV8S10185C2[];
Class_Descriptor cd_S10185C2 = {  "S10185C2", // class name
  0,0,//no base classes
  &(vtc_S10185C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10185C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10185C2),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10185C4  {
  virtual  ~S10185C4(); // _ZN8S10185C4D1Ev
  virtual void  v157(); // _ZN8S10185C44v157Ev
  virtual void  v158(); // _ZN8S10185C44v158Ev
  virtual void  v159(); // _ZN8S10185C44v159Ev
  S10185C4(); // tgen
};
//SIG(-1 S10185C4) C1{ vd v1 v2 v3}


 S10185C4 ::~S10185C4(){ note_dtor("S10185C4", this);}
void  S10185C4 ::v157(){vfunc_called(this, "_ZN8S10185C44v157Ev");}
void  S10185C4 ::v158(){vfunc_called(this, "_ZN8S10185C44v158Ev");}
void  S10185C4 ::v159(){vfunc_called(this, "_ZN8S10185C44v159Ev");}
S10185C4 ::S10185C4(){ note_ctor("S10185C4", this);} // tgen

static void Test_S10185C4()
{
  extern Class_Descriptor cd_S10185C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10185C4, buf);
    S10185C4 *dp, &lv = *(dp=new (buf) S10185C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10185C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10185C4)");
    test_class_info(&lv, &cd_S10185C4);
    dp->~S10185C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10185C4(Test_S10185C4, "S10185C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10185C4C1Ev();
extern void _ZN8S10185C4D1Ev();
Name_Map name_map_S10185C4[] = {
  NSPAIR(_ZN8S10185C4C1Ev),
  NSPAIR(_ZN8S10185C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10185C4[];
extern void _ZN8S10185C4D1Ev();
extern void _ZN8S10185C4D0Ev();
extern void _ZN8S10185C44v157Ev();
extern void _ZN8S10185C44v158Ev();
extern void _ZN8S10185C44v159Ev();
static  VTBL_ENTRY vtc_S10185C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10185C4[0]),
  (VTBL_ENTRY)&_ZN8S10185C4D1Ev,
  (VTBL_ENTRY)&_ZN8S10185C4D0Ev,
  (VTBL_ENTRY)&_ZN8S10185C44v157Ev,
  (VTBL_ENTRY)&_ZN8S10185C44v158Ev,
  (VTBL_ENTRY)&_ZN8S10185C44v159Ev,
};
extern VTBL_ENTRY _ZTI8S10185C4[];
extern  VTBL_ENTRY _ZTV8S10185C4[];
Class_Descriptor cd_S10185C4 = {  "S10185C4", // class name
  0,0,//no base classes
  &(vtc_S10185C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10185C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10185C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10185C7_nt  {
  __tsi64 s10185c7f0[4];
  void  mf10185c7(); // _ZN11S10185C7_nt9mf10185c7Ev
};
//SIG(-1 S10185C7_nt) C1{ m FL[4]}


void  S10185C7_nt ::mf10185c7(){}

//skip512 S10185C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10185C3_nt  : S10185C4 {
  ::S10183C20 s10185c3f0;
  ::S10185C7_nt s10185c3f1;
  char s10185c3f2;
  virtual  ~S10185C3_nt(); // _ZN11S10185C3_ntD1Ev
  virtual void  v160(); // _ZN11S10185C3_nt4v160Ev
  virtual void  v161(); // _ZN11S10185C3_nt4v161Ev
  virtual void  v162(); // _ZN11S10185C3_nt4v162Ev
  S10185C3_nt(); // tgen
};
//SIG(-1 S10185C3_nt) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FL[4]} Fc}


 S10185C3_nt ::~S10185C3_nt(){ note_dtor("S10185C3_nt", this);}
void  S10185C3_nt ::v160(){vfunc_called(this, "_ZN11S10185C3_nt4v160Ev");}
void  S10185C3_nt ::v161(){vfunc_called(this, "_ZN11S10185C3_nt4v161Ev");}
void  S10185C3_nt ::v162(){vfunc_called(this, "_ZN11S10185C3_nt4v162Ev");}
S10185C3_nt ::S10185C3_nt(){ note_ctor("S10185C3_nt", this);} // tgen

//skip512 S10185C3_nt

#else // __cplusplus

extern void _ZN11S10185C3_ntC1Ev();
extern void _ZN11S10185C3_ntD1Ev();
Name_Map name_map_S10185C3_nt[] = {
  NSPAIR(_ZN11S10185C3_ntC1Ev),
  NSPAIR(_ZN11S10185C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10185C4;
extern VTBL_ENTRY _ZTI8S10185C4[];
extern  VTBL_ENTRY _ZTV8S10185C4[];
static Base_Class bases_S10185C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10185C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S10185C3_nt[];
extern void _ZN11S10185C3_ntD1Ev();
extern void _ZN11S10185C3_ntD0Ev();
extern void _ZN8S10185C44v157Ev();
extern void _ZN8S10185C44v158Ev();
extern void _ZN8S10185C44v159Ev();
extern void _ZN11S10185C3_nt4v160Ev();
extern void _ZN11S10185C3_nt4v161Ev();
extern void _ZN11S10185C3_nt4v162Ev();
static  VTBL_ENTRY vtc_S10185C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10185C3_nt[0]),
  (VTBL_ENTRY)&_ZN11S10185C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10185C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S10185C44v157Ev,
  (VTBL_ENTRY)&_ZN8S10185C44v158Ev,
  (VTBL_ENTRY)&_ZN8S10185C44v159Ev,
  (VTBL_ENTRY)&_ZN11S10185C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN11S10185C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN11S10185C3_nt4v162Ev,
};
extern VTBL_ENTRY _ZTI11S10185C3_nt[];
VTBL_ENTRY *P__ZTI11S10185C3_nt = _ZTI11S10185C3_nt; 
extern  VTBL_ENTRY _ZTV11S10185C3_nt[];
Class_Descriptor cd_S10185C3_nt = {  "S10185C3_nt", // class name
  bases_S10185C3_nt, 1,
  &(vtc_S10185C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI11S10185C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV11S10185C3_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10185C1  : S10185C2 , S10185C3_nt {
  void *s10185c1f0;
  ::S10183C9_nt s10185c1f1;
  void *s10185c1f2;
  ::S10183C13 s10185c1f3;
  ::S10183C17 s10185c1f4;
  int s10185c1f5[2];
  ::S10183C15_nt s10185c1f6;
  ::S10183C17 s10185c1f7;
  int s10185c1f8[2];
  ::S10183C26 s10185c1f9;
  int s10185c1f10[6];
  ::S10183C13 s10185c1f11;
  ::S10183C31 s10185c1f12;
  int s10185c1f13[2];
  ::S10183C29_nt s10185c1f14[16];
  ::S10183C15_nt s10185c1f15;
  char s10185c1f16[128];
  virtual  ~S10185C1(); // _ZN8S10185C1D1Ev
  virtual void  v1(); // _ZN8S10185C12v1Ev
  virtual void  v2(); // _ZN8S10185C12v2Ev
  virtual void  v3(); // _ZN8S10185C12v3Ev
  virtual void  v4(); // _ZN8S10185C12v4Ev
  virtual void  v5(); // _ZN8S10185C12v5Ev
  virtual void  v6(); // _ZN8S10185C12v6Ev
  virtual void  v7(); // _ZN8S10185C12v7Ev
  virtual void  v8(); // _ZN8S10185C12v8Ev
  virtual void  v9(); // _ZN8S10185C12v9Ev
  virtual void  v10(); // _ZN8S10185C13v10Ev
  virtual void  v11(); // _ZN8S10185C13v11Ev
  virtual void  v12(); // _ZN8S10185C13v12Ev
  virtual void  v13(); // _ZN8S10185C13v13Ev
  virtual void  v14(); // _ZN8S10185C13v14Ev
  virtual void  v15(); // _ZN8S10185C13v15Ev
  virtual void  v16(); // _ZN8S10185C13v16Ev
  virtual void  v17(); // _ZN8S10185C13v17Ev
  virtual void  v18(); // _ZN8S10185C13v18Ev
  virtual void  v19(); // _ZN8S10185C13v19Ev
  virtual void  v20(); // _ZN8S10185C13v20Ev
  virtual void  v21(); // _ZN8S10185C13v21Ev
  virtual void  v22(); // _ZN8S10185C13v22Ev
  virtual void  v23(); // _ZN8S10185C13v23Ev
  virtual void  v24(); // _ZN8S10185C13v24Ev
  virtual void  v25(); // _ZN8S10185C13v25Ev
  virtual void  v26(); // _ZN8S10185C13v26Ev
  virtual void  v27(); // _ZN8S10185C13v27Ev
  virtual void  v28(); // _ZN8S10185C13v28Ev
  virtual void  v29(); // _ZN8S10185C13v29Ev
  virtual void  v30(); // _ZN8S10185C13v30Ev
  virtual void  v31(); // _ZN8S10185C13v31Ev
  virtual void  v32(); // _ZN8S10185C13v32Ev
  virtual void  v33(); // _ZN8S10185C13v33Ev
  virtual void  v34(); // _ZN8S10185C13v34Ev
  virtual void  v35(); // _ZN8S10185C13v35Ev
  virtual void  v36(); // _ZN8S10185C13v36Ev
  virtual void  v37(); // _ZN8S10185C13v37Ev
  virtual void  v38(); // _ZN8S10185C13v38Ev
  virtual void  v39(); // _ZN8S10185C13v39Ev
  virtual void  v40(); // _ZN8S10185C13v40Ev
  virtual void  v41(); // _ZN8S10185C13v41Ev
  virtual void  v42(); // _ZN8S10185C13v42Ev
  virtual void  v43(); // _ZN8S10185C13v43Ev
  virtual void  v44(); // _ZN8S10185C13v44Ev
  virtual void  v45(); // _ZN8S10185C13v45Ev
  virtual void  v46(); // _ZN8S10185C13v46Ev
  virtual void  v47(); // _ZN8S10185C13v47Ev
  virtual void  v48(); // _ZN8S10185C13v48Ev
  virtual void  v49(); // _ZN8S10185C13v49Ev
  virtual void  v50(); // _ZN8S10185C13v50Ev
  virtual void  v51(); // _ZN8S10185C13v51Ev
  virtual void  v52(); // _ZN8S10185C13v52Ev
  virtual void  v53(); // _ZN8S10185C13v53Ev
  virtual void  v54(); // _ZN8S10185C13v54Ev
  virtual void  v55(); // _ZN8S10185C13v55Ev
  virtual void  v56(); // _ZN8S10185C13v56Ev
  virtual void  v57(); // _ZN8S10185C13v57Ev
  virtual void  v58(); // _ZN8S10185C13v58Ev
  virtual void  v59(); // _ZN8S10185C13v59Ev
  virtual void  v60(); // _ZN8S10185C13v60Ev
  virtual void  v61(); // _ZN8S10185C13v61Ev
  virtual void  v62(); // _ZN8S10185C13v62Ev
  virtual void  v63(); // _ZN8S10185C13v63Ev
  virtual void  v64(); // _ZN8S10185C13v64Ev
  virtual void  v65(); // _ZN8S10185C13v65Ev
  virtual void  v66(); // _ZN8S10185C13v66Ev
  virtual void  v67(); // _ZN8S10185C13v67Ev
  virtual void  v68(); // _ZN8S10185C13v68Ev
  virtual void  v69(); // _ZN8S10185C13v69Ev
  virtual void  v70(); // _ZN8S10185C13v70Ev
  virtual void  v71(); // _ZN8S10185C13v71Ev
  virtual void  v72(); // _ZN8S10185C13v72Ev
  virtual void  v73(); // _ZN8S10185C13v73Ev
  virtual void  v74(); // _ZN8S10185C13v74Ev
  virtual void  v75(); // _ZN8S10185C13v75Ev
  virtual void  v76(); // _ZN8S10185C13v76Ev
  virtual void  v77(); // _ZN8S10185C13v77Ev
  virtual void  v78(); // _ZN8S10185C13v78Ev
  S10185C1(); // tgen
};
//SIG(1 S10185C1) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156} BC3{ BC4{ vd v157 v158 v159} vd v160 v161 v162 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FL[4]} Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fp FC8{ BC9{ m Fp Fi FC10{ m} FC11{ m}}} Fp FC12{ BC13{ vd v165 v166} vd v163 v164 FC14{ m Fp Fi FC11} FC14 Fi} FC15{ BC13 vd v167 v168 FC16{ BC13 vd v169 v170 FC14} FC12 FC17{ BC5 BC13 vd v171 v172} FC18{ vd m FC19{ m Fs[6] Fi[2] Fc Fs}} FC14 FC14 Fc[2] Fi FC14 FC14 FC14 FC14 FC14 Fi[3] Fp FC14 FC18 FC14 Fi} Fi[2] FC14 FC15 Fi[2] FC20{ FC21{ Fc[72]} FC22{ Fs[6] Fi} FC23{ FC24{ Fc[20]} Fc[16]} Fc[128] FC22 Fs Fc[30]} Fi[6] FC12 FC25{ Fi FC26{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]} Fi[2] FC23[16] FC14 Fc[128]}


 S10185C1 ::~S10185C1(){ note_dtor("S10185C1", this);}
void  S10185C1 ::v1(){vfunc_called(this, "_ZN8S10185C12v1Ev");}
void  S10185C1 ::v2(){vfunc_called(this, "_ZN8S10185C12v2Ev");}
void  S10185C1 ::v3(){vfunc_called(this, "_ZN8S10185C12v3Ev");}
void  S10185C1 ::v4(){vfunc_called(this, "_ZN8S10185C12v4Ev");}
void  S10185C1 ::v5(){vfunc_called(this, "_ZN8S10185C12v5Ev");}
void  S10185C1 ::v6(){vfunc_called(this, "_ZN8S10185C12v6Ev");}
void  S10185C1 ::v7(){vfunc_called(this, "_ZN8S10185C12v7Ev");}
void  S10185C1 ::v8(){vfunc_called(this, "_ZN8S10185C12v8Ev");}
void  S10185C1 ::v9(){vfunc_called(this, "_ZN8S10185C12v9Ev");}
void  S10185C1 ::v10(){vfunc_called(this, "_ZN8S10185C13v10Ev");}
void  S10185C1 ::v11(){vfunc_called(this, "_ZN8S10185C13v11Ev");}
void  S10185C1 ::v12(){vfunc_called(this, "_ZN8S10185C13v12Ev");}
void  S10185C1 ::v13(){vfunc_called(this, "_ZN8S10185C13v13Ev");}
void  S10185C1 ::v14(){vfunc_called(this, "_ZN8S10185C13v14Ev");}
void  S10185C1 ::v15(){vfunc_called(this, "_ZN8S10185C13v15Ev");}
void  S10185C1 ::v16(){vfunc_called(this, "_ZN8S10185C13v16Ev");}
void  S10185C1 ::v17(){vfunc_called(this, "_ZN8S10185C13v17Ev");}
void  S10185C1 ::v18(){vfunc_called(this, "_ZN8S10185C13v18Ev");}
void  S10185C1 ::v19(){vfunc_called(this, "_ZN8S10185C13v19Ev");}
void  S10185C1 ::v20(){vfunc_called(this, "_ZN8S10185C13v20Ev");}
void  S10185C1 ::v21(){vfunc_called(this, "_ZN8S10185C13v21Ev");}
void  S10185C1 ::v22(){vfunc_called(this, "_ZN8S10185C13v22Ev");}
void  S10185C1 ::v23(){vfunc_called(this, "_ZN8S10185C13v23Ev");}
void  S10185C1 ::v24(){vfunc_called(this, "_ZN8S10185C13v24Ev");}
void  S10185C1 ::v25(){vfunc_called(this, "_ZN8S10185C13v25Ev");}
void  S10185C1 ::v26(){vfunc_called(this, "_ZN8S10185C13v26Ev");}
void  S10185C1 ::v27(){vfunc_called(this, "_ZN8S10185C13v27Ev");}
void  S10185C1 ::v28(){vfunc_called(this, "_ZN8S10185C13v28Ev");}
void  S10185C1 ::v29(){vfunc_called(this, "_ZN8S10185C13v29Ev");}
void  S10185C1 ::v30(){vfunc_called(this, "_ZN8S10185C13v30Ev");}
void  S10185C1 ::v31(){vfunc_called(this, "_ZN8S10185C13v31Ev");}
void  S10185C1 ::v32(){vfunc_called(this, "_ZN8S10185C13v32Ev");}
void  S10185C1 ::v33(){vfunc_called(this, "_ZN8S10185C13v33Ev");}
void  S10185C1 ::v34(){vfunc_called(this, "_ZN8S10185C13v34Ev");}
void  S10185C1 ::v35(){vfunc_called(this, "_ZN8S10185C13v35Ev");}
void  S10185C1 ::v36(){vfunc_called(this, "_ZN8S10185C13v36Ev");}
void  S10185C1 ::v37(){vfunc_called(this, "_ZN8S10185C13v37Ev");}
void  S10185C1 ::v38(){vfunc_called(this, "_ZN8S10185C13v38Ev");}
void  S10185C1 ::v39(){vfunc_called(this, "_ZN8S10185C13v39Ev");}
void  S10185C1 ::v40(){vfunc_called(this, "_ZN8S10185C13v40Ev");}
void  S10185C1 ::v41(){vfunc_called(this, "_ZN8S10185C13v41Ev");}
void  S10185C1 ::v42(){vfunc_called(this, "_ZN8S10185C13v42Ev");}
void  S10185C1 ::v43(){vfunc_called(this, "_ZN8S10185C13v43Ev");}
void  S10185C1 ::v44(){vfunc_called(this, "_ZN8S10185C13v44Ev");}
void  S10185C1 ::v45(){vfunc_called(this, "_ZN8S10185C13v45Ev");}
void  S10185C1 ::v46(){vfunc_called(this, "_ZN8S10185C13v46Ev");}
void  S10185C1 ::v47(){vfunc_called(this, "_ZN8S10185C13v47Ev");}
void  S10185C1 ::v48(){vfunc_called(this, "_ZN8S10185C13v48Ev");}
void  S10185C1 ::v49(){vfunc_called(this, "_ZN8S10185C13v49Ev");}
void  S10185C1 ::v50(){vfunc_called(this, "_ZN8S10185C13v50Ev");}
void  S10185C1 ::v51(){vfunc_called(this, "_ZN8S10185C13v51Ev");}
void  S10185C1 ::v52(){vfunc_called(this, "_ZN8S10185C13v52Ev");}
void  S10185C1 ::v53(){vfunc_called(this, "_ZN8S10185C13v53Ev");}
void  S10185C1 ::v54(){vfunc_called(this, "_ZN8S10185C13v54Ev");}
void  S10185C1 ::v55(){vfunc_called(this, "_ZN8S10185C13v55Ev");}
void  S10185C1 ::v56(){vfunc_called(this, "_ZN8S10185C13v56Ev");}
void  S10185C1 ::v57(){vfunc_called(this, "_ZN8S10185C13v57Ev");}
void  S10185C1 ::v58(){vfunc_called(this, "_ZN8S10185C13v58Ev");}
void  S10185C1 ::v59(){vfunc_called(this, "_ZN8S10185C13v59Ev");}
void  S10185C1 ::v60(){vfunc_called(this, "_ZN8S10185C13v60Ev");}
void  S10185C1 ::v61(){vfunc_called(this, "_ZN8S10185C13v61Ev");}
void  S10185C1 ::v62(){vfunc_called(this, "_ZN8S10185C13v62Ev");}
void  S10185C1 ::v63(){vfunc_called(this, "_ZN8S10185C13v63Ev");}
void  S10185C1 ::v64(){vfunc_called(this, "_ZN8S10185C13v64Ev");}
void  S10185C1 ::v65(){vfunc_called(this, "_ZN8S10185C13v65Ev");}
void  S10185C1 ::v66(){vfunc_called(this, "_ZN8S10185C13v66Ev");}
void  S10185C1 ::v67(){vfunc_called(this, "_ZN8S10185C13v67Ev");}
void  S10185C1 ::v68(){vfunc_called(this, "_ZN8S10185C13v68Ev");}
void  S10185C1 ::v69(){vfunc_called(this, "_ZN8S10185C13v69Ev");}
void  S10185C1 ::v70(){vfunc_called(this, "_ZN8S10185C13v70Ev");}
void  S10185C1 ::v71(){vfunc_called(this, "_ZN8S10185C13v71Ev");}
void  S10185C1 ::v72(){vfunc_called(this, "_ZN8S10185C13v72Ev");}
void  S10185C1 ::v73(){vfunc_called(this, "_ZN8S10185C13v73Ev");}
void  S10185C1 ::v74(){vfunc_called(this, "_ZN8S10185C13v74Ev");}
void  S10185C1 ::v75(){vfunc_called(this, "_ZN8S10185C13v75Ev");}
void  S10185C1 ::v76(){vfunc_called(this, "_ZN8S10185C13v76Ev");}
void  S10185C1 ::v77(){vfunc_called(this, "_ZN8S10185C13v77Ev");}
void  S10185C1 ::v78(){vfunc_called(this, "_ZN8S10185C13v78Ev");}
S10185C1 ::S10185C1(){ note_ctor("S10185C1", this);} // tgen

static void Test_S10185C1()
{
  extern Class_Descriptor cd_S10185C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(276,473)];
    init_test(&cd_S10185C1, buf);
    S10185C1 *dp, &lv = *(dp=new (buf) S10185C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2200,1888), "sizeof(S10185C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10185C1)");
    check_base_class_offset(lv, (S10185C2*), 0, "S10185C1");
    check_base_class_offset(lv, (S10185C4*)(S10185C3_nt*), ABISELECT(8,4), "S10185C1");
    check_base_class_offset(lv, (S10185C3_nt*), ABISELECT(8,4), "S10185C1");
    check_field_offset(lv, s10185c1f0, ABISELECT(80,60), "S10185C1.s10185c1f0");
    check_field_offset(lv, s10185c1f1, ABISELECT(88,64), "S10185C1.s10185c1f1");
    check_field_offset(lv, s10185c1f2, ABISELECT(104,76), "S10185C1.s10185c1f2");
    check_field_offset(lv, s10185c1f3, ABISELECT(112,80), "S10185C1.s10185c1f3");
    check_field_offset(lv, s10185c1f4, ABISELECT(160,112), "S10185C1.s10185c1f4");
    check_field_offset(lv, s10185c1f5, ABISELECT(520,376), "S10185C1.s10185c1f5");
    check_field_offset(lv, s10185c1f6, ABISELECT(528,384), "S10185C1.s10185c1f6");
    check_field_offset(lv, s10185c1f7, ABISELECT(544,396), "S10185C1.s10185c1f7");
    check_field_offset(lv, s10185c1f8, ABISELECT(904,660), "S10185C1.s10185c1f8");
    check_field_offset(lv, s10185c1f9, ABISELECT(912,668), "S10185C1.s10185c1f9");
    check_field_offset(lv, s10185c1f10, ABISELECT(1212,968), "S10185C1.s10185c1f10");
    check_field_offset(lv, s10185c1f11, ABISELECT(1240,992), "S10185C1.s10185c1f11");
    check_field_offset(lv, s10185c1f12, ABISELECT(1288,1024), "S10185C1.s10185c1f12");
    check_field_offset(lv, s10185c1f13, ABISELECT(1472,1164), "S10185C1.s10185c1f13");
    check_field_offset(lv, s10185c1f14, ABISELECT(1480,1172), "S10185C1.s10185c1f14");
    check_field_offset(lv, s10185c1f15, ABISELECT(2056,1748), "S10185C1.s10185c1f15");
    check_field_offset(lv, s10185c1f16, ABISELECT(2072,1760), "S10185C1.s10185c1f16");
    test_class_info(&lv, &cd_S10185C1);
    dp->~S10185C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10185C1(Test_S10185C1, "S10185C1", ABISELECT(2200,1888));

#else // __cplusplus

extern void _ZN8S10185C1C1Ev();
extern void _ZN8S10185C1D1Ev();
Name_Map name_map_S10185C1[] = {
  NSPAIR(_ZN8S10185C1C1Ev),
  NSPAIR(_ZN8S10185C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10185C2;
extern VTBL_ENTRY _ZTI8S10185C2[];
extern  VTBL_ENTRY _ZTV8S10185C2[];
extern Class_Descriptor cd_S10185C4;
extern VTBL_ENTRY _ZTI8S10185C4[];
extern  VTBL_ENTRY _ZTV8S10185C4[];
extern Class_Descriptor cd_S10185C3_nt;
extern VTBL_ENTRY _ZTI11S10185C3_nt[];
extern  VTBL_ENTRY _ZTV11S10185C3_nt[];
static Base_Class bases_S10185C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10185C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10185C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S10185C3_nt,    ABISELECT(8,4), //bcp->offset
    160, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10185C1[];
extern void _ZN8S10185C1D1Ev();
extern void _ZN8S10185C1D0Ev();
extern void _ZN8S10185C23v79Ev();
extern void _ZN8S10185C23v80Ev();
extern void _ZN8S10185C23v81Ev();
extern void _ZN8S10185C23v82Ev();
extern void _ZN8S10185C23v83Ev();
extern void _ZN8S10185C23v84Ev();
extern void _ZN8S10185C23v85Ev();
extern void _ZN8S10185C23v86Ev();
extern void _ZN8S10185C23v87Ev();
extern void _ZN8S10185C23v88Ev();
extern void _ZN8S10185C23v89Ev();
extern void _ZN8S10185C23v90Ev();
extern void _ZN8S10185C23v91Ev();
extern void _ZN8S10185C23v92Ev();
extern void _ZN8S10185C23v93Ev();
extern void _ZN8S10185C23v94Ev();
extern void _ZN8S10185C23v95Ev();
extern void _ZN8S10185C23v96Ev();
extern void _ZN8S10185C23v97Ev();
extern void _ZN8S10185C23v98Ev();
extern void _ZN8S10185C23v99Ev();
extern void _ZN8S10185C24v100Ev();
extern void _ZN8S10185C24v101Ev();
extern void _ZN8S10185C24v102Ev();
extern void _ZN8S10185C24v103Ev();
extern void _ZN8S10185C24v104Ev();
extern void _ZN8S10185C24v105Ev();
extern void _ZN8S10185C24v106Ev();
extern void _ZN8S10185C24v107Ev();
extern void _ZN8S10185C24v108Ev();
extern void _ZN8S10185C24v109Ev();
extern void _ZN8S10185C24v110Ev();
extern void _ZN8S10185C24v111Ev();
extern void _ZN8S10185C24v112Ev();
extern void _ZN8S10185C24v113Ev();
extern void _ZN8S10185C24v114Ev();
extern void _ZN8S10185C24v115Ev();
extern void _ZN8S10185C24v116Ev();
extern void _ZN8S10185C24v117Ev();
extern void _ZN8S10185C24v118Ev();
extern void _ZN8S10185C24v119Ev();
extern void _ZN8S10185C24v120Ev();
extern void _ZN8S10185C24v121Ev();
extern void _ZN8S10185C24v122Ev();
extern void _ZN8S10185C24v123Ev();
extern void _ZN8S10185C24v124Ev();
extern void _ZN8S10185C24v125Ev();
extern void _ZN8S10185C24v126Ev();
extern void _ZN8S10185C24v127Ev();
extern void _ZN8S10185C24v128Ev();
extern void _ZN8S10185C24v129Ev();
extern void _ZN8S10185C24v130Ev();
extern void _ZN8S10185C24v131Ev();
extern void _ZN8S10185C24v132Ev();
extern void _ZN8S10185C24v133Ev();
extern void _ZN8S10185C24v134Ev();
extern void _ZN8S10185C24v135Ev();
extern void _ZN8S10185C24v136Ev();
extern void _ZN8S10185C24v137Ev();
extern void _ZN8S10185C24v138Ev();
extern void _ZN8S10185C24v139Ev();
extern void _ZN8S10185C24v140Ev();
extern void _ZN8S10185C24v141Ev();
extern void _ZN8S10185C24v142Ev();
extern void _ZN8S10185C24v143Ev();
extern void _ZN8S10185C24v144Ev();
extern void _ZN8S10185C24v145Ev();
extern void _ZN8S10185C24v146Ev();
extern void _ZN8S10185C24v147Ev();
extern void _ZN8S10185C24v148Ev();
extern void _ZN8S10185C24v149Ev();
extern void _ZN8S10185C24v150Ev();
extern void _ZN8S10185C24v151Ev();
extern void _ZN8S10185C24v152Ev();
extern void _ZN8S10185C24v153Ev();
extern void _ZN8S10185C24v154Ev();
extern void _ZN8S10185C24v155Ev();
extern void _ZN8S10185C24v156Ev();
extern void _ZN8S10185C12v1Ev();
extern void _ZN8S10185C12v2Ev();
extern void _ZN8S10185C12v3Ev();
extern void _ZN8S10185C12v4Ev();
extern void _ZN8S10185C12v5Ev();
extern void _ZN8S10185C12v6Ev();
extern void _ZN8S10185C12v7Ev();
extern void _ZN8S10185C12v8Ev();
extern void _ZN8S10185C12v9Ev();
extern void _ZN8S10185C13v10Ev();
extern void _ZN8S10185C13v11Ev();
extern void _ZN8S10185C13v12Ev();
extern void _ZN8S10185C13v13Ev();
extern void _ZN8S10185C13v14Ev();
extern void _ZN8S10185C13v15Ev();
extern void _ZN8S10185C13v16Ev();
extern void _ZN8S10185C13v17Ev();
extern void _ZN8S10185C13v18Ev();
extern void _ZN8S10185C13v19Ev();
extern void _ZN8S10185C13v20Ev();
extern void _ZN8S10185C13v21Ev();
extern void _ZN8S10185C13v22Ev();
extern void _ZN8S10185C13v23Ev();
extern void _ZN8S10185C13v24Ev();
extern void _ZN8S10185C13v25Ev();
extern void _ZN8S10185C13v26Ev();
extern void _ZN8S10185C13v27Ev();
extern void _ZN8S10185C13v28Ev();
extern void _ZN8S10185C13v29Ev();
extern void _ZN8S10185C13v30Ev();
extern void _ZN8S10185C13v31Ev();
extern void _ZN8S10185C13v32Ev();
extern void _ZN8S10185C13v33Ev();
extern void _ZN8S10185C13v34Ev();
extern void _ZN8S10185C13v35Ev();
extern void _ZN8S10185C13v36Ev();
extern void _ZN8S10185C13v37Ev();
extern void _ZN8S10185C13v38Ev();
extern void _ZN8S10185C13v39Ev();
extern void _ZN8S10185C13v40Ev();
extern void _ZN8S10185C13v41Ev();
extern void _ZN8S10185C13v42Ev();
extern void _ZN8S10185C13v43Ev();
extern void _ZN8S10185C13v44Ev();
extern void _ZN8S10185C13v45Ev();
extern void _ZN8S10185C13v46Ev();
extern void _ZN8S10185C13v47Ev();
extern void _ZN8S10185C13v48Ev();
extern void _ZN8S10185C13v49Ev();
extern void _ZN8S10185C13v50Ev();
extern void _ZN8S10185C13v51Ev();
extern void _ZN8S10185C13v52Ev();
extern void _ZN8S10185C13v53Ev();
extern void _ZN8S10185C13v54Ev();
extern void _ZN8S10185C13v55Ev();
extern void _ZN8S10185C13v56Ev();
extern void _ZN8S10185C13v57Ev();
extern void _ZN8S10185C13v58Ev();
extern void _ZN8S10185C13v59Ev();
extern void _ZN8S10185C13v60Ev();
extern void _ZN8S10185C13v61Ev();
extern void _ZN8S10185C13v62Ev();
extern void _ZN8S10185C13v63Ev();
extern void _ZN8S10185C13v64Ev();
extern void _ZN8S10185C13v65Ev();
extern void _ZN8S10185C13v66Ev();
extern void _ZN8S10185C13v67Ev();
extern void _ZN8S10185C13v68Ev();
extern void _ZN8S10185C13v69Ev();
extern void _ZN8S10185C13v70Ev();
extern void _ZN8S10185C13v71Ev();
extern void _ZN8S10185C13v72Ev();
extern void _ZN8S10185C13v73Ev();
extern void _ZN8S10185C13v74Ev();
extern void _ZN8S10185C13v75Ev();
extern void _ZN8S10185C13v76Ev();
extern void _ZN8S10185C13v77Ev();
extern void _ZN8S10185C13v78Ev();
extern void ABISELECT(_ZThn8_N8S10185C1D1Ev,_ZThn4_N8S10185C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10185C1D0Ev,_ZThn4_N8S10185C1D0Ev)();
extern void _ZN8S10185C44v157Ev();
extern void _ZN8S10185C44v158Ev();
extern void _ZN8S10185C44v159Ev();
extern void _ZN11S10185C3_nt4v160Ev();
extern void _ZN11S10185C3_nt4v161Ev();
extern void _ZN11S10185C3_nt4v162Ev();
static  VTBL_ENTRY vtc_S10185C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10185C1[0]),
  (VTBL_ENTRY)&_ZN8S10185C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10185C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v79Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v80Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v81Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v82Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v83Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v84Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v85Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v86Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v87Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v88Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v89Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v90Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v91Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v92Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v93Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v94Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v95Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v96Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v97Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10185C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v112Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v113Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v114Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v115Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v116Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v117Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v118Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v119Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v120Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v121Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v122Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v123Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v124Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v125Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v126Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v127Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v128Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v129Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v130Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v131Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v132Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v133Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v134Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v135Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v136Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v137Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v138Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v139Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v140Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v141Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v142Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v143Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v144Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v145Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v146Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v147Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v148Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v149Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v150Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v151Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v152Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v153Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v154Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v155Ev,
  (VTBL_ENTRY)&_ZN8S10185C24v156Ev,
  (VTBL_ENTRY)&_ZN8S10185C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10185C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10185C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10185C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10185C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10185C12v6Ev,
  (VTBL_ENTRY)&_ZN8S10185C12v7Ev,
  (VTBL_ENTRY)&_ZN8S10185C12v8Ev,
  (VTBL_ENTRY)&_ZN8S10185C12v9Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v10Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v11Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v12Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v13Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v14Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v15Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v16Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v17Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v18Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v19Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v20Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v21Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v22Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v23Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v24Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v25Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v26Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v27Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v28Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v29Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v30Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v31Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v32Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v33Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v34Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v35Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v36Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v37Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v38Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v39Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v40Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v41Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v42Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v43Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v44Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v45Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v46Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v47Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v48Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v49Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v50Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v51Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v52Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v53Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v54Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v55Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v56Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v57Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v58Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v59Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v60Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v61Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v62Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v63Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v64Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v65Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v66Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v67Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v68Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v69Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v70Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v71Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v72Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v73Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v74Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v75Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v76Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v77Ev,
  (VTBL_ENTRY)&_ZN8S10185C13v78Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10185C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10185C1D1Ev,_ZThn4_N8S10185C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10185C1D0Ev,_ZThn4_N8S10185C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10185C44v157Ev,
  (VTBL_ENTRY)&_ZN8S10185C44v158Ev,
  (VTBL_ENTRY)&_ZN8S10185C44v159Ev,
  (VTBL_ENTRY)&_ZN11S10185C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN11S10185C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN11S10185C3_nt4v162Ev,
};
extern VTBL_ENTRY _ZTI8S10185C1[];
extern  VTBL_ENTRY _ZTV8S10185C1[];
Class_Descriptor cd_S10185C1 = {  "S10185C1", // class name
  bases_S10185C1, 3,
  &(vtc_S10185C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2200,1888), // object size
  NSPAIRA(_ZTI8S10185C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S10185C1),170, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C2_nt  {
  virtual  ~S9125C2_nt(); // _ZN10S9125C2_ntD1Ev
  virtual void  v21(); // _ZN10S9125C2_nt3v21Ev
  S9125C2_nt(); // tgen
};
//SIG(-1 S9125C2_nt) C1{ vd v1}


 S9125C2_nt ::~S9125C2_nt(){ note_dtor("S9125C2_nt", this);}
void  S9125C2_nt ::v21(){vfunc_called(this, "_ZN10S9125C2_nt3v21Ev");}
S9125C2_nt ::S9125C2_nt(){ note_ctor("S9125C2_nt", this);} // tgen

//skip512 S9125C2_nt

#else // __cplusplus

extern void _ZN10S9125C2_ntC1Ev();
extern void _ZN10S9125C2_ntD1Ev();
Name_Map name_map_S9125C2_nt[] = {
  NSPAIR(_ZN10S9125C2_ntC1Ev),
  NSPAIR(_ZN10S9125C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S9125C2_nt[];
extern void _ZN10S9125C2_ntD1Ev();
extern void _ZN10S9125C2_ntD0Ev();
extern void _ZN10S9125C2_nt3v21Ev();
static  VTBL_ENTRY vtc_S9125C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9125C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S9125C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9125C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S9125C2_nt3v21Ev,
};
extern VTBL_ENTRY _ZTI10S9125C2_nt[];
VTBL_ENTRY *P__ZTI10S9125C2_nt = _ZTI10S9125C2_nt; 
extern  VTBL_ENTRY _ZTV10S9125C2_nt[];
Class_Descriptor cd_S9125C2_nt = {  "S9125C2_nt", // class name
  0,0,//no base classes
  &(vtc_S9125C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S9125C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S9125C2_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C5  {
  virtual  ~S9125C5(); // _ZN7S9125C5D1Ev
  virtual void  v22(); // _ZN7S9125C53v22Ev
  virtual void  v23(); // _ZN7S9125C53v23Ev
  virtual void  v24(); // _ZN7S9125C53v24Ev
  S9125C5(); // tgen
};
//SIG(-1 S9125C5) C1{ vd v1 v2 v3}


 S9125C5 ::~S9125C5(){ note_dtor("S9125C5", this);}
void  S9125C5 ::v22(){vfunc_called(this, "_ZN7S9125C53v22Ev");}
void  S9125C5 ::v23(){vfunc_called(this, "_ZN7S9125C53v23Ev");}
void  S9125C5 ::v24(){vfunc_called(this, "_ZN7S9125C53v24Ev");}
S9125C5 ::S9125C5(){ note_ctor("S9125C5", this);} // tgen

static void Test_S9125C5()
{
  extern Class_Descriptor cd_S9125C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9125C5, buf);
    S9125C5 *dp, &lv = *(dp=new (buf) S9125C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9125C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9125C5)");
    test_class_info(&lv, &cd_S9125C5);
    dp->~S9125C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9125C5(Test_S9125C5, "S9125C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9125C5C1Ev();
extern void _ZN7S9125C5D1Ev();
Name_Map name_map_S9125C5[] = {
  NSPAIR(_ZN7S9125C5C1Ev),
  NSPAIR(_ZN7S9125C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9125C5[];
extern void _ZN7S9125C5D1Ev();
extern void _ZN7S9125C5D0Ev();
extern void _ZN7S9125C53v22Ev();
extern void _ZN7S9125C53v23Ev();
extern void _ZN7S9125C53v24Ev();
static  VTBL_ENTRY vtc_S9125C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9125C5[0]),
  (VTBL_ENTRY)&_ZN7S9125C5D1Ev,
  (VTBL_ENTRY)&_ZN7S9125C5D0Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v24Ev,
};
extern VTBL_ENTRY _ZTI7S9125C5[];
extern  VTBL_ENTRY _ZTV7S9125C5[];
Class_Descriptor cd_S9125C5 = {  "S9125C5", // class name
  0,0,//no base classes
  &(vtc_S9125C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9125C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9125C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C4  : S9125C5 {
  ::S10183C20 s9125c4f0;
  ::S10183C7_nt s9125c4f1;
  char s9125c4f2;
  virtual  ~S9125C4(); // _ZN7S9125C4D1Ev
  virtual void  v25(); // _ZN7S9125C43v25Ev
  virtual void  v26(); // _ZN7S9125C43v26Ev
  virtual void  v27(); // _ZN7S9125C43v27Ev
  S9125C4(); // tgen
};
//SIG(-1 S9125C4) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ Fl[4]}} Fc}


 S9125C4 ::~S9125C4(){ note_dtor("S9125C4", this);}
void  S9125C4 ::v25(){vfunc_called(this, "_ZN7S9125C43v25Ev");}
void  S9125C4 ::v26(){vfunc_called(this, "_ZN7S9125C43v26Ev");}
void  S9125C4 ::v27(){vfunc_called(this, "_ZN7S9125C43v27Ev");}
S9125C4 ::S9125C4(){ note_ctor("S9125C4", this);} // tgen

static void Test_S9125C4()
{
  extern Class_Descriptor cd_S9125C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S9125C4, buf);
    S9125C4 *dp, &lv = *(dp=new (buf) S9125C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S9125C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9125C4)");
    check_base_class_offset(lv, (S9125C5*), 0, "S9125C4");
    check_field_offset(lv, s9125c4f0, ABISELECT(8,4), "S9125C4.s9125c4f0");
    check_field_offset(lv, s9125c4f1, ABISELECT(32,20), "S9125C4.s9125c4f1");
    check_field_offset(lv, s9125c4f2, ABISELECT(64,36), "S9125C4.s9125c4f2");
    test_class_info(&lv, &cd_S9125C4);
    dp->~S9125C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9125C4(Test_S9125C4, "S9125C4", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S9125C4C1Ev();
extern void _ZN7S9125C4D1Ev();
Name_Map name_map_S9125C4[] = {
  NSPAIR(_ZN7S9125C4C1Ev),
  NSPAIR(_ZN7S9125C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9125C5;
extern VTBL_ENTRY _ZTI7S9125C5[];
extern  VTBL_ENTRY _ZTV7S9125C5[];
static Base_Class bases_S9125C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9125C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9125C4[];
extern void _ZN7S9125C4D1Ev();
extern void _ZN7S9125C4D0Ev();
extern void _ZN7S9125C53v22Ev();
extern void _ZN7S9125C53v23Ev();
extern void _ZN7S9125C53v24Ev();
extern void _ZN7S9125C43v25Ev();
extern void _ZN7S9125C43v26Ev();
extern void _ZN7S9125C43v27Ev();
static  VTBL_ENTRY vtc_S9125C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9125C4[0]),
  (VTBL_ENTRY)&_ZN7S9125C4D1Ev,
  (VTBL_ENTRY)&_ZN7S9125C4D0Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v24Ev,
  (VTBL_ENTRY)&_ZN7S9125C43v25Ev,
  (VTBL_ENTRY)&_ZN7S9125C43v26Ev,
  (VTBL_ENTRY)&_ZN7S9125C43v27Ev,
};
extern VTBL_ENTRY _ZTI7S9125C4[];
extern  VTBL_ENTRY _ZTV7S9125C4[];
Class_Descriptor cd_S9125C4 = {  "S9125C4", // class name
  bases_S9125C4, 1,
  &(vtc_S9125C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S9125C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9125C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C3  : S9125C4 {
  virtual  ~S9125C3(); // _ZN7S9125C3D1Ev
  virtual void  v28(); // _ZN7S9125C33v28Ev
  virtual void  v29(); // _ZN7S9125C33v29Ev
  virtual void  v30(); // _ZN7S9125C33v30Ev
  virtual void  v31(); // _ZN7S9125C33v31Ev
  virtual void  v32(); // _ZN7S9125C33v32Ev
  virtual void  v33(); // _ZN7S9125C33v33Ev
  virtual void  v34(); // _ZN7S9125C33v34Ev
  virtual void  v35(); // _ZN7S9125C33v35Ev
  virtual void  v36(); // _ZN7S9125C33v36Ev
  virtual void  v37(); // _ZN7S9125C33v37Ev
  virtual void  v38(); // _ZN7S9125C33v38Ev
  virtual void  v39(); // _ZN7S9125C33v39Ev
  virtual void  v40(); // _ZN7S9125C33v40Ev
  virtual void  v41(); // _ZN7S9125C33v41Ev
  virtual void  v42(); // _ZN7S9125C33v42Ev
  virtual void  v43(); // _ZN7S9125C33v43Ev
  virtual void  v44(); // _ZN7S9125C33v44Ev
  virtual void  v45(); // _ZN7S9125C33v45Ev
  virtual void  v46(); // _ZN7S9125C33v46Ev
  S9125C3(); // tgen
};
//SIG(-1 S9125C3) C1{ BC2{ BC3{ vd v20 v21 v22} vd v23 v24 v25 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19}


 S9125C3 ::~S9125C3(){ note_dtor("S9125C3", this);}
void  S9125C3 ::v28(){vfunc_called(this, "_ZN7S9125C33v28Ev");}
void  S9125C3 ::v29(){vfunc_called(this, "_ZN7S9125C33v29Ev");}
void  S9125C3 ::v30(){vfunc_called(this, "_ZN7S9125C33v30Ev");}
void  S9125C3 ::v31(){vfunc_called(this, "_ZN7S9125C33v31Ev");}
void  S9125C3 ::v32(){vfunc_called(this, "_ZN7S9125C33v32Ev");}
void  S9125C3 ::v33(){vfunc_called(this, "_ZN7S9125C33v33Ev");}
void  S9125C3 ::v34(){vfunc_called(this, "_ZN7S9125C33v34Ev");}
void  S9125C3 ::v35(){vfunc_called(this, "_ZN7S9125C33v35Ev");}
void  S9125C3 ::v36(){vfunc_called(this, "_ZN7S9125C33v36Ev");}
void  S9125C3 ::v37(){vfunc_called(this, "_ZN7S9125C33v37Ev");}
void  S9125C3 ::v38(){vfunc_called(this, "_ZN7S9125C33v38Ev");}
void  S9125C3 ::v39(){vfunc_called(this, "_ZN7S9125C33v39Ev");}
void  S9125C3 ::v40(){vfunc_called(this, "_ZN7S9125C33v40Ev");}
void  S9125C3 ::v41(){vfunc_called(this, "_ZN7S9125C33v41Ev");}
void  S9125C3 ::v42(){vfunc_called(this, "_ZN7S9125C33v42Ev");}
void  S9125C3 ::v43(){vfunc_called(this, "_ZN7S9125C33v43Ev");}
void  S9125C3 ::v44(){vfunc_called(this, "_ZN7S9125C33v44Ev");}
void  S9125C3 ::v45(){vfunc_called(this, "_ZN7S9125C33v45Ev");}
void  S9125C3 ::v46(){vfunc_called(this, "_ZN7S9125C33v46Ev");}
S9125C3 ::S9125C3(){ note_ctor("S9125C3", this);} // tgen

static void Test_S9125C3()
{
  extern Class_Descriptor cd_S9125C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S9125C3, buf);
    S9125C3 *dp, &lv = *(dp=new (buf) S9125C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S9125C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9125C3)");
    check_base_class_offset(lv, (S9125C5*)(S9125C4*), 0, "S9125C3");
    check_base_class_offset(lv, (S9125C4*), 0, "S9125C3");
    test_class_info(&lv, &cd_S9125C3);
    dp->~S9125C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9125C3(Test_S9125C3, "S9125C3", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S9125C3C1Ev();
extern void _ZN7S9125C3D1Ev();
Name_Map name_map_S9125C3[] = {
  NSPAIR(_ZN7S9125C3C1Ev),
  NSPAIR(_ZN7S9125C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9125C5;
extern VTBL_ENTRY _ZTI7S9125C5[];
extern  VTBL_ENTRY _ZTV7S9125C5[];
extern Class_Descriptor cd_S9125C4;
extern VTBL_ENTRY _ZTI7S9125C4[];
extern  VTBL_ENTRY _ZTV7S9125C4[];
static Base_Class bases_S9125C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9125C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S9125C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9125C3[];
extern void _ZN7S9125C3D1Ev();
extern void _ZN7S9125C3D0Ev();
extern void _ZN7S9125C53v22Ev();
extern void _ZN7S9125C53v23Ev();
extern void _ZN7S9125C53v24Ev();
extern void _ZN7S9125C43v25Ev();
extern void _ZN7S9125C43v26Ev();
extern void _ZN7S9125C43v27Ev();
extern void _ZN7S9125C33v28Ev();
extern void _ZN7S9125C33v29Ev();
extern void _ZN7S9125C33v30Ev();
extern void _ZN7S9125C33v31Ev();
extern void _ZN7S9125C33v32Ev();
extern void _ZN7S9125C33v33Ev();
extern void _ZN7S9125C33v34Ev();
extern void _ZN7S9125C33v35Ev();
extern void _ZN7S9125C33v36Ev();
extern void _ZN7S9125C33v37Ev();
extern void _ZN7S9125C33v38Ev();
extern void _ZN7S9125C33v39Ev();
extern void _ZN7S9125C33v40Ev();
extern void _ZN7S9125C33v41Ev();
extern void _ZN7S9125C33v42Ev();
extern void _ZN7S9125C33v43Ev();
extern void _ZN7S9125C33v44Ev();
extern void _ZN7S9125C33v45Ev();
extern void _ZN7S9125C33v46Ev();
static  VTBL_ENTRY vtc_S9125C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9125C3[0]),
  (VTBL_ENTRY)&_ZN7S9125C3D1Ev,
  (VTBL_ENTRY)&_ZN7S9125C3D0Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v24Ev,
  (VTBL_ENTRY)&_ZN7S9125C43v25Ev,
  (VTBL_ENTRY)&_ZN7S9125C43v26Ev,
  (VTBL_ENTRY)&_ZN7S9125C43v27Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v28Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v29Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v30Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v31Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v32Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v33Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v34Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v35Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v36Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v37Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v38Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v39Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v40Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v41Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v42Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v43Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v44Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v45Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v46Ev,
};
extern VTBL_ENTRY _ZTI7S9125C3[];
extern  VTBL_ENTRY _ZTV7S9125C3[];
Class_Descriptor cd_S9125C3 = {  "S9125C3", // class name
  bases_S9125C3, 2,
  &(vtc_S9125C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S9125C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9125C3),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C12_nt  {
  char s9125c12f0[12];
};
//SIG(-1 S9125C12_nt) C1{ Fc[12]}



//skip512 S9125C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C16_nt  {
  int s9125c16f0[2];
};
//SIG(-1 S9125C16_nt) C1{ Fi[2]}



//skip512 S9125C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C17  {
  int s9125c17f0[3];
  char s9125c17f1[256];
};
//SIG(1 S9125C17) C1{ Fi[3] Fc[256]}



static void Test_S9125C17()
{
  {
    init_simple_test("S9125C17");
    S9125C17 lv;
    check2(sizeof(lv), 268, "sizeof(S9125C17)");
    check2(__alignof__(lv), 4, "__alignof__(S9125C17)");
    check_field_offset(lv, s9125c17f0, 0, "S9125C17.s9125c17f0");
    check_field_offset(lv, s9125c17f1, 12, "S9125C17.s9125c17f1");
  }
}
static Arrange_To_Call_Me vS9125C17(Test_S9125C17, "S9125C17", 268);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C15  {
  int s9125c15f0[2];
  ::S9125C16_nt s9125c15f1[10];
  ::S9125C17 s9125c15f2[10];
};
//SIG(-1 S9125C15) C1{ Fi[2] FC2{ Fi[2]}[10] FC3{ Fi[3] Fc[256]}[10]}



static void Test_S9125C15()
{
  {
    init_simple_test("S9125C15");
    S9125C15 lv;
    check2(sizeof(lv), 2768, "sizeof(S9125C15)");
    check2(__alignof__(lv), 4, "__alignof__(S9125C15)");
    check_field_offset(lv, s9125c15f0, 0, "S9125C15.s9125c15f0");
    check_field_offset(lv, s9125c15f1, 8, "S9125C15.s9125c15f1");
    check_field_offset(lv, s9125c15f2, 88, "S9125C15.s9125c15f2");
  }
}
static Arrange_To_Call_Me vS9125C15(Test_S9125C15, "S9125C15", 2768);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C35_nt  {
  void *s9125c35f0;
  int s9125c35f1[2];
  ::S10183C21 s9125c35f2;
  void  mf9125c35(); // _ZN11S9125C35_nt9mf9125c35Ev
};
//SIG(-1 S9125C35_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S9125C35_nt ::mf9125c35(){}

//skip512 S9125C35_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S9125C35_nt[];
VTBL_ENTRY *P__ZTI11S9125C35_nt = _ZTI11S9125C35_nt; 
Class_Descriptor cd_S9125C35_nt = {  "S9125C35_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI11S9125C35_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C21  {
  virtual  ~S9125C21(); // _ZN8S9125C21D1Ev
  virtual void  v49(); // _ZN8S9125C213v49Ev
  virtual void  v50(); // _ZN8S9125C213v50Ev
  S9125C21(); // tgen
};
//SIG(-1 S9125C21) C1{ vd v1 v2}


 S9125C21 ::~S9125C21(){ note_dtor("S9125C21", this);}
void  S9125C21 ::v49(){vfunc_called(this, "_ZN8S9125C213v49Ev");}
void  S9125C21 ::v50(){vfunc_called(this, "_ZN8S9125C213v50Ev");}
S9125C21 ::S9125C21(){ note_ctor("S9125C21", this);} // tgen

static void Test_S9125C21()
{
  extern Class_Descriptor cd_S9125C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9125C21, buf);
    S9125C21 *dp, &lv = *(dp=new (buf) S9125C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9125C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9125C21)");
    test_class_info(&lv, &cd_S9125C21);
    dp->~S9125C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9125C21(Test_S9125C21, "S9125C21", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9125C21C1Ev();
extern void _ZN8S9125C21D1Ev();
Name_Map name_map_S9125C21[] = {
  NSPAIR(_ZN8S9125C21C1Ev),
  NSPAIR(_ZN8S9125C21D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9125C21[];
extern void _ZN8S9125C21D1Ev();
extern void _ZN8S9125C21D0Ev();
extern void _ZN8S9125C213v49Ev();
extern void _ZN8S9125C213v50Ev();
static  VTBL_ENTRY vtc_S9125C21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9125C21[0]),
  (VTBL_ENTRY)&_ZN8S9125C21D1Ev,
  (VTBL_ENTRY)&_ZN8S9125C21D0Ev,
  (VTBL_ENTRY)&_ZN8S9125C213v49Ev,
  (VTBL_ENTRY)&_ZN8S9125C213v50Ev,
};
extern VTBL_ENTRY _ZTI8S9125C21[];
extern  VTBL_ENTRY _ZTV8S9125C21[];
Class_Descriptor cd_S9125C21 = {  "S9125C21", // class name
  0,0,//no base classes
  &(vtc_S9125C21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9125C21),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9125C21),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C34_nt  : S9125C35_nt , S9125C21 {
  virtual  ~S9125C34_nt(); // _ZN11S9125C34_ntD1Ev
  virtual void  v59(); // _ZN11S9125C34_nt3v59Ev
  virtual void  v60(); // _ZN11S9125C34_nt3v60Ev
  S9125C34_nt(); // tgen
};
//SIG(-1 S9125C34_nt) C1{ BC2{ m Fp Fi[2] FC3{ m}} BC4{ vd v3 v4} vd v1 v2}


 S9125C34_nt ::~S9125C34_nt(){ note_dtor("S9125C34_nt", this);}
void  S9125C34_nt ::v59(){vfunc_called(this, "_ZN11S9125C34_nt3v59Ev");}
void  S9125C34_nt ::v60(){vfunc_called(this, "_ZN11S9125C34_nt3v60Ev");}
S9125C34_nt ::S9125C34_nt(){ note_ctor("S9125C34_nt", this);} // tgen

//skip512 S9125C34_nt

#else // __cplusplus

extern void _ZN11S9125C34_ntC1Ev();
extern void _ZN11S9125C34_ntD1Ev();
Name_Map name_map_S9125C34_nt[] = {
  NSPAIR(_ZN11S9125C34_ntC1Ev),
  NSPAIR(_ZN11S9125C34_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9125C35_nt;
extern VTBL_ENTRY _ZTI11S9125C35_nt[];
extern Class_Descriptor cd_S9125C21;
extern VTBL_ENTRY _ZTI8S9125C21[];
extern  VTBL_ENTRY _ZTV8S9125C21[];
static Base_Class bases_S9125C34_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9125C35_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9125C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S9125C34_nt[];
extern void _ZN11S9125C34_ntD1Ev();
extern void _ZN11S9125C34_ntD0Ev();
extern void _ZN8S9125C213v49Ev();
extern void _ZN8S9125C213v50Ev();
extern void _ZN11S9125C34_nt3v59Ev();
extern void _ZN11S9125C34_nt3v60Ev();
static  VTBL_ENTRY vtc_S9125C34_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9125C34_nt[0]),
  (VTBL_ENTRY)&_ZN11S9125C34_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9125C34_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S9125C213v49Ev,
  (VTBL_ENTRY)&_ZN8S9125C213v50Ev,
  (VTBL_ENTRY)&_ZN11S9125C34_nt3v59Ev,
  (VTBL_ENTRY)&_ZN11S9125C34_nt3v60Ev,
};
extern VTBL_ENTRY _ZTI11S9125C34_nt[];
VTBL_ENTRY *P__ZTI11S9125C34_nt = _ZTI11S9125C34_nt; 
extern  VTBL_ENTRY _ZTV11S9125C34_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9125C1  : S9125C2_nt , S9125C3 {
  ::S10183C31 s9125c1f0;
  ::S9125C12_nt s9125c1f1;
  ::S10183C7_nt s9125c1f2;
  ::S10183C7_nt s9125c1f3;
  void *s9125c1f4;
  ::S10183C5_nt s9125c1f5;
  ::S9125C15 s9125c1f6;
  int s9125c1f7[2];
  ::S10183C19_nt s9125c1f8;
  ::S10183C17 s9125c1f9;
  ::S9125C34_nt s9125c1f10;
  int s9125c1f11[3];
  ::S10183C19_nt s9125c1f12;
  int s9125c1f13[2];
  ::S10183C17 s9125c1f14;
  ::S9125C34_nt s9125c1f15;
  void *s9125c1f16;
  char s9125c1f17[3];
  virtual  ~S9125C1(); // _ZN7S9125C1D1Ev
  virtual void  v1(); // _ZN7S9125C12v1Ev
  virtual void  v2(); // _ZN7S9125C12v2Ev
  virtual void  v3(); // _ZN7S9125C12v3Ev
  virtual void  v4(); // _ZN7S9125C12v4Ev
  virtual void  v5(); // _ZN7S9125C12v5Ev
  virtual void  v6(); // _ZN7S9125C12v6Ev
  virtual void  v7(); // _ZN7S9125C12v7Ev
  virtual void  v8(); // _ZN7S9125C12v8Ev
  virtual void  v9(); // _ZN7S9125C12v9Ev
  virtual void  v10(); // _ZN7S9125C13v10Ev
  virtual void  v11(); // _ZN7S9125C13v11Ev
  virtual void  v12(); // _ZN7S9125C13v12Ev
  virtual void  v13(); // _ZN7S9125C13v13Ev
  virtual void  v14(); // _ZN7S9125C13v14Ev
  virtual void  v15(); // _ZN7S9125C13v15Ev
  virtual void  v16(); // _ZN7S9125C13v16Ev
  virtual void  v17(); // _ZN7S9125C13v17Ev
  virtual void  v18(); // _ZN7S9125C13v18Ev
  virtual void  v19(); // _ZN7S9125C13v19Ev
  virtual void  v20(); // _ZN7S9125C13v20Ev
  S9125C1(); // tgen
};
//SIG(1 S9125C1) C1{ BC2{ vd v21} BC3{ BC4{ BC5{ vd v22 v23 v24} vd v25 v26 v27 FC6{ m Fp Fi[2] FC7{ m}} FC8{ m FC9{ Fl[4]}} Fc} vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 FC10{ Fi FC11{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]} FC12{ Fc[12]} FC8 FC8 Fp FC13{ m Fp Fi[2] FC14{ m}} FC15{ Fi[2] FC16{ Fi[2]}[10] FC17{ Fi[3] Fc[256]}[10]} Fi[2] FC18{ BC6 BC19{ vd v49 v50} vd v47 v48} FC20{ BC19 vd v51 v52 FC21{ BC19 vd v53 v54 FC22{ m Fp Fi FC23{ m}}} FC24{ BC19 vd v55 v56 FC22 FC22 Fi} FC18 FC25{ vd m FC26{ m Fs[6] Fi[2] Fc Fs}} FC22 FC22 Fc[2] Fi FC22 FC22 FC22 FC22 FC22 Fi[3] Fp FC22 FC25 FC22 Fi} FC27{ BC28{ m Fp Fi[2] FC7} BC29{ vd v59 v60} vd v57 v58} Fi[3] FC18 Fi[2] FC20 FC27 Fp Fc[3]}


 S9125C1 ::~S9125C1(){ note_dtor("S9125C1", this);}
void  S9125C1 ::v1(){vfunc_called(this, "_ZN7S9125C12v1Ev");}
void  S9125C1 ::v2(){vfunc_called(this, "_ZN7S9125C12v2Ev");}
void  S9125C1 ::v3(){vfunc_called(this, "_ZN7S9125C12v3Ev");}
void  S9125C1 ::v4(){vfunc_called(this, "_ZN7S9125C12v4Ev");}
void  S9125C1 ::v5(){vfunc_called(this, "_ZN7S9125C12v5Ev");}
void  S9125C1 ::v6(){vfunc_called(this, "_ZN7S9125C12v6Ev");}
void  S9125C1 ::v7(){vfunc_called(this, "_ZN7S9125C12v7Ev");}
void  S9125C1 ::v8(){vfunc_called(this, "_ZN7S9125C12v8Ev");}
void  S9125C1 ::v9(){vfunc_called(this, "_ZN7S9125C12v9Ev");}
void  S9125C1 ::v10(){vfunc_called(this, "_ZN7S9125C13v10Ev");}
void  S9125C1 ::v11(){vfunc_called(this, "_ZN7S9125C13v11Ev");}
void  S9125C1 ::v12(){vfunc_called(this, "_ZN7S9125C13v12Ev");}
void  S9125C1 ::v13(){vfunc_called(this, "_ZN7S9125C13v13Ev");}
void  S9125C1 ::v14(){vfunc_called(this, "_ZN7S9125C13v14Ev");}
void  S9125C1 ::v15(){vfunc_called(this, "_ZN7S9125C13v15Ev");}
void  S9125C1 ::v16(){vfunc_called(this, "_ZN7S9125C13v16Ev");}
void  S9125C1 ::v17(){vfunc_called(this, "_ZN7S9125C13v17Ev");}
void  S9125C1 ::v18(){vfunc_called(this, "_ZN7S9125C13v18Ev");}
void  S9125C1 ::v19(){vfunc_called(this, "_ZN7S9125C13v19Ev");}
void  S9125C1 ::v20(){vfunc_called(this, "_ZN7S9125C13v20Ev");}
S9125C1 ::S9125C1(){ note_ctor("S9125C1", this);} // tgen

static void Test_S9125C1()
{
  extern Class_Descriptor cd_S9125C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(506,916)];
    init_test(&cd_S9125C1, buf);
    S9125C1 *dp, &lv = *(dp=new (buf) S9125C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4040,3660), "sizeof(S9125C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9125C1)");
    check_base_class_offset(lv, (S9125C2_nt*), 0, "S9125C1");
    check_base_class_offset(lv, (S9125C5*)(S9125C4*)(S9125C3*), ABISELECT(8,4), "S9125C1");
    check_base_class_offset(lv, (S9125C4*)(S9125C3*), ABISELECT(8,4), "S9125C1");
    check_base_class_offset(lv, (S9125C3*), ABISELECT(8,4), "S9125C1");
    check_field_offset(lv, s9125c1f0, ABISELECT(80,44), "S9125C1.s9125c1f0");
    check_field_offset(lv, s9125c1f1, ABISELECT(264,184), "S9125C1.s9125c1f1");
    check_field_offset(lv, s9125c1f2, ABISELECT(280,196), "S9125C1.s9125c1f2");
    check_field_offset(lv, s9125c1f3, ABISELECT(312,212), "S9125C1.s9125c1f3");
    check_field_offset(lv, s9125c1f4, ABISELECT(344,228), "S9125C1.s9125c1f4");
    check_field_offset(lv, s9125c1f5, ABISELECT(352,232), "S9125C1.s9125c1f5");
    check_field_offset(lv, s9125c1f6, ABISELECT(376,248), "S9125C1.s9125c1f6");
    check_field_offset(lv, s9125c1f7, ABISELECT(3144,3016), "S9125C1.s9125c1f7");
    check_field_offset(lv, s9125c1f8, ABISELECT(3152,3024), "S9125C1.s9125c1f8");
    check_field_offset(lv, s9125c1f9, ABISELECT(3184,3044), "S9125C1.s9125c1f9");
    check_field_offset(lv, s9125c1f10, ABISELECT(3544,3308), "S9125C1.s9125c1f10");
    check_field_offset(lv, s9125c1f11, ABISELECT(3576,3328), "S9125C1.s9125c1f11");
    check_field_offset(lv, s9125c1f12, ABISELECT(3592,3340), "S9125C1.s9125c1f12");
    check_field_offset(lv, s9125c1f13, ABISELECT(3624,3360), "S9125C1.s9125c1f13");
    check_field_offset(lv, s9125c1f14, ABISELECT(3632,3368), "S9125C1.s9125c1f14");
    check_field_offset(lv, s9125c1f15, ABISELECT(3992,3632), "S9125C1.s9125c1f15");
    check_field_offset(lv, s9125c1f16, ABISELECT(4024,3652), "S9125C1.s9125c1f16");
    check_field_offset(lv, s9125c1f17, ABISELECT(4032,3656), "S9125C1.s9125c1f17");
    test_class_info(&lv, &cd_S9125C1);
    dp->~S9125C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9125C1(Test_S9125C1, "S9125C1", ABISELECT(4040,3660));

#else // __cplusplus

extern void _ZN7S9125C1C1Ev();
extern void _ZN7S9125C1D1Ev();
Name_Map name_map_S9125C1[] = {
  NSPAIR(_ZN7S9125C1C1Ev),
  NSPAIR(_ZN7S9125C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9125C2_nt;
extern VTBL_ENTRY _ZTI10S9125C2_nt[];
extern  VTBL_ENTRY _ZTV10S9125C2_nt[];
extern Class_Descriptor cd_S9125C5;
extern VTBL_ENTRY _ZTI7S9125C5[];
extern  VTBL_ENTRY _ZTV7S9125C5[];
extern Class_Descriptor cd_S9125C4;
extern VTBL_ENTRY _ZTI7S9125C4[];
extern  VTBL_ENTRY _ZTV7S9125C4[];
extern Class_Descriptor cd_S9125C3;
extern VTBL_ENTRY _ZTI7S9125C3[];
extern  VTBL_ENTRY _ZTV7S9125C3[];
static Base_Class bases_S9125C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9125C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9125C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S9125C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S9125C3,    ABISELECT(8,4), //bcp->offset
    25, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9125C1[];
extern void _ZN7S9125C1D1Ev();
extern void _ZN7S9125C1D0Ev();
extern void _ZN10S9125C2_nt3v21Ev();
extern void _ZN7S9125C12v1Ev();
extern void _ZN7S9125C12v2Ev();
extern void _ZN7S9125C12v3Ev();
extern void _ZN7S9125C12v4Ev();
extern void _ZN7S9125C12v5Ev();
extern void _ZN7S9125C12v6Ev();
extern void _ZN7S9125C12v7Ev();
extern void _ZN7S9125C12v8Ev();
extern void _ZN7S9125C12v9Ev();
extern void _ZN7S9125C13v10Ev();
extern void _ZN7S9125C13v11Ev();
extern void _ZN7S9125C13v12Ev();
extern void _ZN7S9125C13v13Ev();
extern void _ZN7S9125C13v14Ev();
extern void _ZN7S9125C13v15Ev();
extern void _ZN7S9125C13v16Ev();
extern void _ZN7S9125C13v17Ev();
extern void _ZN7S9125C13v18Ev();
extern void _ZN7S9125C13v19Ev();
extern void _ZN7S9125C13v20Ev();
extern void ABISELECT(_ZThn8_N7S9125C1D1Ev,_ZThn4_N7S9125C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9125C1D0Ev,_ZThn4_N7S9125C1D0Ev)();
extern void _ZN7S9125C53v22Ev();
extern void _ZN7S9125C53v23Ev();
extern void _ZN7S9125C53v24Ev();
extern void _ZN7S9125C43v25Ev();
extern void _ZN7S9125C43v26Ev();
extern void _ZN7S9125C43v27Ev();
extern void _ZN7S9125C33v28Ev();
extern void _ZN7S9125C33v29Ev();
extern void _ZN7S9125C33v30Ev();
extern void _ZN7S9125C33v31Ev();
extern void _ZN7S9125C33v32Ev();
extern void _ZN7S9125C33v33Ev();
extern void _ZN7S9125C33v34Ev();
extern void _ZN7S9125C33v35Ev();
extern void _ZN7S9125C33v36Ev();
extern void _ZN7S9125C33v37Ev();
extern void _ZN7S9125C33v38Ev();
extern void _ZN7S9125C33v39Ev();
extern void _ZN7S9125C33v40Ev();
extern void _ZN7S9125C33v41Ev();
extern void _ZN7S9125C33v42Ev();
extern void _ZN7S9125C33v43Ev();
extern void _ZN7S9125C33v44Ev();
extern void _ZN7S9125C33v45Ev();
extern void _ZN7S9125C33v46Ev();
static  VTBL_ENTRY vtc_S9125C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9125C1[0]),
  (VTBL_ENTRY)&_ZN7S9125C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9125C1D0Ev,
  (VTBL_ENTRY)&_ZN10S9125C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN7S9125C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9125C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9125C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9125C12v4Ev,
  (VTBL_ENTRY)&_ZN7S9125C12v5Ev,
  (VTBL_ENTRY)&_ZN7S9125C12v6Ev,
  (VTBL_ENTRY)&_ZN7S9125C12v7Ev,
  (VTBL_ENTRY)&_ZN7S9125C12v8Ev,
  (VTBL_ENTRY)&_ZN7S9125C12v9Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v10Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v11Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v12Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v13Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v14Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v15Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v16Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v17Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v18Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v19Ev,
  (VTBL_ENTRY)&_ZN7S9125C13v20Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9125C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9125C1D1Ev,_ZThn4_N7S9125C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9125C1D0Ev,_ZThn4_N7S9125C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9125C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9125C53v24Ev,
  (VTBL_ENTRY)&_ZN7S9125C43v25Ev,
  (VTBL_ENTRY)&_ZN7S9125C43v26Ev,
  (VTBL_ENTRY)&_ZN7S9125C43v27Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v28Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v29Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v30Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v31Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v32Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v33Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v34Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v35Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v36Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v37Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v38Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v39Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v40Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v41Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v42Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v43Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v44Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v45Ev,
  (VTBL_ENTRY)&_ZN7S9125C33v46Ev,
};
extern VTBL_ENTRY _ZTI7S9125C1[];
extern  VTBL_ENTRY _ZTV7S9125C1[];
Class_Descriptor cd_S9125C1 = {  "S9125C1", // class name
  bases_S9125C1, 4,
  &(vtc_S9125C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(4040,3660), // object size
  NSPAIRA(_ZTI7S9125C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9125C1),54, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9126C2  {
  virtual  ~S9126C2(); // _ZN7S9126C2D1Ev
  virtual void  v21(); // _ZN7S9126C23v21Ev
  S9126C2(); // tgen
};
//SIG(-1 S9126C2) C1{ vd v1}


 S9126C2 ::~S9126C2(){ note_dtor("S9126C2", this);}
void  S9126C2 ::v21(){vfunc_called(this, "_ZN7S9126C23v21Ev");}
S9126C2 ::S9126C2(){ note_ctor("S9126C2", this);} // tgen

static void Test_S9126C2()
{
  extern Class_Descriptor cd_S9126C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9126C2, buf);
    S9126C2 *dp, &lv = *(dp=new (buf) S9126C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9126C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9126C2)");
    test_class_info(&lv, &cd_S9126C2);
    dp->~S9126C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9126C2(Test_S9126C2, "S9126C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9126C2C1Ev();
extern void _ZN7S9126C2D1Ev();
Name_Map name_map_S9126C2[] = {
  NSPAIR(_ZN7S9126C2C1Ev),
  NSPAIR(_ZN7S9126C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9126C2[];
extern void _ZN7S9126C2D1Ev();
extern void _ZN7S9126C2D0Ev();
extern void _ZN7S9126C23v21Ev();
static  VTBL_ENTRY vtc_S9126C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9126C2[0]),
  (VTBL_ENTRY)&_ZN7S9126C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9126C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9126C23v21Ev,
};
extern VTBL_ENTRY _ZTI7S9126C2[];
extern  VTBL_ENTRY _ZTV7S9126C2[];
Class_Descriptor cd_S9126C2 = {  "S9126C2", // class name
  0,0,//no base classes
  &(vtc_S9126C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9126C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9126C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9126C5  {
  virtual  ~S9126C5(); // _ZN7S9126C5D1Ev
  virtual void  v22(); // _ZN7S9126C53v22Ev
  virtual void  v23(); // _ZN7S9126C53v23Ev
  virtual void  v24(); // _ZN7S9126C53v24Ev
  S9126C5(); // tgen
};
//SIG(-1 S9126C5) C1{ vd v1 v2 v3}


 S9126C5 ::~S9126C5(){ note_dtor("S9126C5", this);}
void  S9126C5 ::v22(){vfunc_called(this, "_ZN7S9126C53v22Ev");}
void  S9126C5 ::v23(){vfunc_called(this, "_ZN7S9126C53v23Ev");}
void  S9126C5 ::v24(){vfunc_called(this, "_ZN7S9126C53v24Ev");}
S9126C5 ::S9126C5(){ note_ctor("S9126C5", this);} // tgen

static void Test_S9126C5()
{
  extern Class_Descriptor cd_S9126C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9126C5, buf);
    S9126C5 *dp, &lv = *(dp=new (buf) S9126C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9126C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9126C5)");
    test_class_info(&lv, &cd_S9126C5);
    dp->~S9126C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9126C5(Test_S9126C5, "S9126C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9126C5C1Ev();
extern void _ZN7S9126C5D1Ev();
Name_Map name_map_S9126C5[] = {
  NSPAIR(_ZN7S9126C5C1Ev),
  NSPAIR(_ZN7S9126C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9126C5[];
extern void _ZN7S9126C5D1Ev();
extern void _ZN7S9126C5D0Ev();
extern void _ZN7S9126C53v22Ev();
extern void _ZN7S9126C53v23Ev();
extern void _ZN7S9126C53v24Ev();
static  VTBL_ENTRY vtc_S9126C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9126C5[0]),
  (VTBL_ENTRY)&_ZN7S9126C5D1Ev,
  (VTBL_ENTRY)&_ZN7S9126C5D0Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v24Ev,
};
extern VTBL_ENTRY _ZTI7S9126C5[];
extern  VTBL_ENTRY _ZTV7S9126C5[];
Class_Descriptor cd_S9126C5 = {  "S9126C5", // class name
  0,0,//no base classes
  &(vtc_S9126C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9126C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9126C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9126C4  : S9126C5 {
  ::S10183C20 s9126c4f0;
  ::S10184C7_nt s9126c4f1;
  char s9126c4f2;
  virtual  ~S9126C4(); // _ZN7S9126C4D1Ev
  virtual void  v25(); // _ZN7S9126C43v25Ev
  virtual void  v26(); // _ZN7S9126C43v26Ev
  virtual void  v27(); // _ZN7S9126C43v27Ev
  S9126C4(); // tgen
};
//SIG(-1 S9126C4) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ FL[4]}} Fc}


 S9126C4 ::~S9126C4(){ note_dtor("S9126C4", this);}
void  S9126C4 ::v25(){vfunc_called(this, "_ZN7S9126C43v25Ev");}
void  S9126C4 ::v26(){vfunc_called(this, "_ZN7S9126C43v26Ev");}
void  S9126C4 ::v27(){vfunc_called(this, "_ZN7S9126C43v27Ev");}
S9126C4 ::S9126C4(){ note_ctor("S9126C4", this);} // tgen

static void Test_S9126C4()
{
  extern Class_Descriptor cd_S9126C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S9126C4, buf);
    S9126C4 *dp, &lv = *(dp=new (buf) S9126C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S9126C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9126C4)");
    check_base_class_offset(lv, (S9126C5*), 0, "S9126C4");
    check_field_offset(lv, s9126c4f0, ABISELECT(8,4), "S9126C4.s9126c4f0");
    check_field_offset(lv, s9126c4f1, ABISELECT(32,20), "S9126C4.s9126c4f1");
    check_field_offset(lv, s9126c4f2, ABISELECT(64,52), "S9126C4.s9126c4f2");
    test_class_info(&lv, &cd_S9126C4);
    dp->~S9126C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9126C4(Test_S9126C4, "S9126C4", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S9126C4C1Ev();
extern void _ZN7S9126C4D1Ev();
Name_Map name_map_S9126C4[] = {
  NSPAIR(_ZN7S9126C4C1Ev),
  NSPAIR(_ZN7S9126C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9126C5;
extern VTBL_ENTRY _ZTI7S9126C5[];
extern  VTBL_ENTRY _ZTV7S9126C5[];
static Base_Class bases_S9126C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9126C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9126C4[];
extern void _ZN7S9126C4D1Ev();
extern void _ZN7S9126C4D0Ev();
extern void _ZN7S9126C53v22Ev();
extern void _ZN7S9126C53v23Ev();
extern void _ZN7S9126C53v24Ev();
extern void _ZN7S9126C43v25Ev();
extern void _ZN7S9126C43v26Ev();
extern void _ZN7S9126C43v27Ev();
static  VTBL_ENTRY vtc_S9126C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9126C4[0]),
  (VTBL_ENTRY)&_ZN7S9126C4D1Ev,
  (VTBL_ENTRY)&_ZN7S9126C4D0Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v24Ev,
  (VTBL_ENTRY)&_ZN7S9126C43v25Ev,
  (VTBL_ENTRY)&_ZN7S9126C43v26Ev,
  (VTBL_ENTRY)&_ZN7S9126C43v27Ev,
};
extern VTBL_ENTRY _ZTI7S9126C4[];
extern  VTBL_ENTRY _ZTV7S9126C4[];
Class_Descriptor cd_S9126C4 = {  "S9126C4", // class name
  bases_S9126C4, 1,
  &(vtc_S9126C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S9126C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9126C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9126C3  : S9126C4 {
  virtual  ~S9126C3(); // _ZN7S9126C3D1Ev
  virtual void  v28(); // _ZN7S9126C33v28Ev
  virtual void  v29(); // _ZN7S9126C33v29Ev
  virtual void  v30(); // _ZN7S9126C33v30Ev
  virtual void  v31(); // _ZN7S9126C33v31Ev
  virtual void  v32(); // _ZN7S9126C33v32Ev
  virtual void  v33(); // _ZN7S9126C33v33Ev
  virtual void  v34(); // _ZN7S9126C33v34Ev
  virtual void  v35(); // _ZN7S9126C33v35Ev
  virtual void  v36(); // _ZN7S9126C33v36Ev
  virtual void  v37(); // _ZN7S9126C33v37Ev
  virtual void  v38(); // _ZN7S9126C33v38Ev
  virtual void  v39(); // _ZN7S9126C33v39Ev
  virtual void  v40(); // _ZN7S9126C33v40Ev
  virtual void  v41(); // _ZN7S9126C33v41Ev
  virtual void  v42(); // _ZN7S9126C33v42Ev
  virtual void  v43(); // _ZN7S9126C33v43Ev
  virtual void  v44(); // _ZN7S9126C33v44Ev
  virtual void  v45(); // _ZN7S9126C33v45Ev
  virtual void  v46(); // _ZN7S9126C33v46Ev
  S9126C3(); // tgen
};
//SIG(-1 S9126C3) C1{ BC2{ BC3{ vd v20 v21 v22} vd v23 v24 v25 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19}


 S9126C3 ::~S9126C3(){ note_dtor("S9126C3", this);}
void  S9126C3 ::v28(){vfunc_called(this, "_ZN7S9126C33v28Ev");}
void  S9126C3 ::v29(){vfunc_called(this, "_ZN7S9126C33v29Ev");}
void  S9126C3 ::v30(){vfunc_called(this, "_ZN7S9126C33v30Ev");}
void  S9126C3 ::v31(){vfunc_called(this, "_ZN7S9126C33v31Ev");}
void  S9126C3 ::v32(){vfunc_called(this, "_ZN7S9126C33v32Ev");}
void  S9126C3 ::v33(){vfunc_called(this, "_ZN7S9126C33v33Ev");}
void  S9126C3 ::v34(){vfunc_called(this, "_ZN7S9126C33v34Ev");}
void  S9126C3 ::v35(){vfunc_called(this, "_ZN7S9126C33v35Ev");}
void  S9126C3 ::v36(){vfunc_called(this, "_ZN7S9126C33v36Ev");}
void  S9126C3 ::v37(){vfunc_called(this, "_ZN7S9126C33v37Ev");}
void  S9126C3 ::v38(){vfunc_called(this, "_ZN7S9126C33v38Ev");}
void  S9126C3 ::v39(){vfunc_called(this, "_ZN7S9126C33v39Ev");}
void  S9126C3 ::v40(){vfunc_called(this, "_ZN7S9126C33v40Ev");}
void  S9126C3 ::v41(){vfunc_called(this, "_ZN7S9126C33v41Ev");}
void  S9126C3 ::v42(){vfunc_called(this, "_ZN7S9126C33v42Ev");}
void  S9126C3 ::v43(){vfunc_called(this, "_ZN7S9126C33v43Ev");}
void  S9126C3 ::v44(){vfunc_called(this, "_ZN7S9126C33v44Ev");}
void  S9126C3 ::v45(){vfunc_called(this, "_ZN7S9126C33v45Ev");}
void  S9126C3 ::v46(){vfunc_called(this, "_ZN7S9126C33v46Ev");}
S9126C3 ::S9126C3(){ note_ctor("S9126C3", this);} // tgen

static void Test_S9126C3()
{
  extern Class_Descriptor cd_S9126C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S9126C3, buf);
    S9126C3 *dp, &lv = *(dp=new (buf) S9126C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S9126C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9126C3)");
    check_base_class_offset(lv, (S9126C5*)(S9126C4*), 0, "S9126C3");
    check_base_class_offset(lv, (S9126C4*), 0, "S9126C3");
    test_class_info(&lv, &cd_S9126C3);
    dp->~S9126C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9126C3(Test_S9126C3, "S9126C3", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S9126C3C1Ev();
extern void _ZN7S9126C3D1Ev();
Name_Map name_map_S9126C3[] = {
  NSPAIR(_ZN7S9126C3C1Ev),
  NSPAIR(_ZN7S9126C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9126C5;
extern VTBL_ENTRY _ZTI7S9126C5[];
extern  VTBL_ENTRY _ZTV7S9126C5[];
extern Class_Descriptor cd_S9126C4;
extern VTBL_ENTRY _ZTI7S9126C4[];
extern  VTBL_ENTRY _ZTV7S9126C4[];
static Base_Class bases_S9126C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9126C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S9126C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9126C3[];
extern void _ZN7S9126C3D1Ev();
extern void _ZN7S9126C3D0Ev();
extern void _ZN7S9126C53v22Ev();
extern void _ZN7S9126C53v23Ev();
extern void _ZN7S9126C53v24Ev();
extern void _ZN7S9126C43v25Ev();
extern void _ZN7S9126C43v26Ev();
extern void _ZN7S9126C43v27Ev();
extern void _ZN7S9126C33v28Ev();
extern void _ZN7S9126C33v29Ev();
extern void _ZN7S9126C33v30Ev();
extern void _ZN7S9126C33v31Ev();
extern void _ZN7S9126C33v32Ev();
extern void _ZN7S9126C33v33Ev();
extern void _ZN7S9126C33v34Ev();
extern void _ZN7S9126C33v35Ev();
extern void _ZN7S9126C33v36Ev();
extern void _ZN7S9126C33v37Ev();
extern void _ZN7S9126C33v38Ev();
extern void _ZN7S9126C33v39Ev();
extern void _ZN7S9126C33v40Ev();
extern void _ZN7S9126C33v41Ev();
extern void _ZN7S9126C33v42Ev();
extern void _ZN7S9126C33v43Ev();
extern void _ZN7S9126C33v44Ev();
extern void _ZN7S9126C33v45Ev();
extern void _ZN7S9126C33v46Ev();
static  VTBL_ENTRY vtc_S9126C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9126C3[0]),
  (VTBL_ENTRY)&_ZN7S9126C3D1Ev,
  (VTBL_ENTRY)&_ZN7S9126C3D0Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v24Ev,
  (VTBL_ENTRY)&_ZN7S9126C43v25Ev,
  (VTBL_ENTRY)&_ZN7S9126C43v26Ev,
  (VTBL_ENTRY)&_ZN7S9126C43v27Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v28Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v29Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v30Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v31Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v32Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v33Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v34Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v35Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v36Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v37Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v38Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v39Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v40Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v41Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v42Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v43Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v44Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v45Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v46Ev,
};
extern VTBL_ENTRY _ZTI7S9126C3[];
extern  VTBL_ENTRY _ZTV7S9126C3[];
Class_Descriptor cd_S9126C3 = {  "S9126C3", // class name
  bases_S9126C3, 2,
  &(vtc_S9126C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S9126C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9126C3),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9126C1  : S9126C2 , S9126C3 {
  ::S10183C31 s9126c1f0;
  ::S9125C12_nt s9126c1f1;
  ::S10184C7_nt s9126c1f2;
  ::S10184C7_nt s9126c1f3;
  void *s9126c1f4;
  ::S10183C5_nt s9126c1f5;
  ::S9125C15 s9126c1f6;
  int s9126c1f7[2];
  ::S10183C19_nt s9126c1f8;
  ::S10183C17 s9126c1f9;
  ::S9125C34_nt s9126c1f10;
  int s9126c1f11[3];
  ::S10183C19_nt s9126c1f12;
  int s9126c1f13[2];
  ::S10183C17 s9126c1f14;
  ::S9125C34_nt s9126c1f15;
  void *s9126c1f16;
  char s9126c1f17[3];
  virtual  ~S9126C1(); // _ZN7S9126C1D1Ev
  virtual void  v1(); // _ZN7S9126C12v1Ev
  virtual void  v2(); // _ZN7S9126C12v2Ev
  virtual void  v3(); // _ZN7S9126C12v3Ev
  virtual void  v4(); // _ZN7S9126C12v4Ev
  virtual void  v5(); // _ZN7S9126C12v5Ev
  virtual void  v6(); // _ZN7S9126C12v6Ev
  virtual void  v7(); // _ZN7S9126C12v7Ev
  virtual void  v8(); // _ZN7S9126C12v8Ev
  virtual void  v9(); // _ZN7S9126C12v9Ev
  virtual void  v10(); // _ZN7S9126C13v10Ev
  virtual void  v11(); // _ZN7S9126C13v11Ev
  virtual void  v12(); // _ZN7S9126C13v12Ev
  virtual void  v13(); // _ZN7S9126C13v13Ev
  virtual void  v14(); // _ZN7S9126C13v14Ev
  virtual void  v15(); // _ZN7S9126C13v15Ev
  virtual void  v16(); // _ZN7S9126C13v16Ev
  virtual void  v17(); // _ZN7S9126C13v17Ev
  virtual void  v18(); // _ZN7S9126C13v18Ev
  virtual void  v19(); // _ZN7S9126C13v19Ev
  virtual void  v20(); // _ZN7S9126C13v20Ev
  S9126C1(); // tgen
};
//SIG(1 S9126C1) C1{ BC2{ vd v21} BC3{ BC4{ BC5{ vd v22 v23 v24} vd v25 v26 v27 FC6{ m Fp Fi[2] FC7{ m}} FC8{ m FC9{ FL[4]}} Fc} vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 FC10{ Fi FC11{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]} FC12{ Fc[12]} FC8 FC8 Fp FC13{ m Fp Fi[2] FC14{ m}} FC15{ Fi[2] FC16{ Fi[2]}[10] FC17{ Fi[3] Fc[256]}[10]} Fi[2] FC18{ BC6 BC19{ vd v49 v50} vd v47 v48} FC20{ BC19 vd v51 v52 FC21{ BC19 vd v53 v54 FC22{ m Fp Fi FC23{ m}}} FC24{ BC19 vd v55 v56 FC22 FC22 Fi} FC18 FC25{ vd m FC26{ m Fs[6] Fi[2] Fc Fs}} FC22 FC22 Fc[2] Fi FC22 FC22 FC22 FC22 FC22 Fi[3] Fp FC22 FC25 FC22 Fi} FC27{ BC28{ m Fp Fi[2] FC7} BC29{ vd v59 v60} vd v57 v58} Fi[3] FC18 Fi[2] FC20 FC27 Fp Fc[3]}


 S9126C1 ::~S9126C1(){ note_dtor("S9126C1", this);}
void  S9126C1 ::v1(){vfunc_called(this, "_ZN7S9126C12v1Ev");}
void  S9126C1 ::v2(){vfunc_called(this, "_ZN7S9126C12v2Ev");}
void  S9126C1 ::v3(){vfunc_called(this, "_ZN7S9126C12v3Ev");}
void  S9126C1 ::v4(){vfunc_called(this, "_ZN7S9126C12v4Ev");}
void  S9126C1 ::v5(){vfunc_called(this, "_ZN7S9126C12v5Ev");}
void  S9126C1 ::v6(){vfunc_called(this, "_ZN7S9126C12v6Ev");}
void  S9126C1 ::v7(){vfunc_called(this, "_ZN7S9126C12v7Ev");}
void  S9126C1 ::v8(){vfunc_called(this, "_ZN7S9126C12v8Ev");}
void  S9126C1 ::v9(){vfunc_called(this, "_ZN7S9126C12v9Ev");}
void  S9126C1 ::v10(){vfunc_called(this, "_ZN7S9126C13v10Ev");}
void  S9126C1 ::v11(){vfunc_called(this, "_ZN7S9126C13v11Ev");}
void  S9126C1 ::v12(){vfunc_called(this, "_ZN7S9126C13v12Ev");}
void  S9126C1 ::v13(){vfunc_called(this, "_ZN7S9126C13v13Ev");}
void  S9126C1 ::v14(){vfunc_called(this, "_ZN7S9126C13v14Ev");}
void  S9126C1 ::v15(){vfunc_called(this, "_ZN7S9126C13v15Ev");}
void  S9126C1 ::v16(){vfunc_called(this, "_ZN7S9126C13v16Ev");}
void  S9126C1 ::v17(){vfunc_called(this, "_ZN7S9126C13v17Ev");}
void  S9126C1 ::v18(){vfunc_called(this, "_ZN7S9126C13v18Ev");}
void  S9126C1 ::v19(){vfunc_called(this, "_ZN7S9126C13v19Ev");}
void  S9126C1 ::v20(){vfunc_called(this, "_ZN7S9126C13v20Ev");}
S9126C1 ::S9126C1(){ note_ctor("S9126C1", this);} // tgen

static void Test_S9126C1()
{
  extern Class_Descriptor cd_S9126C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(506,928)];
    init_test(&cd_S9126C1, buf);
    S9126C1 *dp, &lv = *(dp=new (buf) S9126C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4040,3708), "sizeof(S9126C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9126C1)");
    check_base_class_offset(lv, (S9126C2*), 0, "S9126C1");
    check_base_class_offset(lv, (S9126C5*)(S9126C4*)(S9126C3*), ABISELECT(8,4), "S9126C1");
    check_base_class_offset(lv, (S9126C4*)(S9126C3*), ABISELECT(8,4), "S9126C1");
    check_base_class_offset(lv, (S9126C3*), ABISELECT(8,4), "S9126C1");
    check_field_offset(lv, s9126c1f0, ABISELECT(80,60), "S9126C1.s9126c1f0");
    check_field_offset(lv, s9126c1f1, ABISELECT(264,200), "S9126C1.s9126c1f1");
    check_field_offset(lv, s9126c1f2, ABISELECT(280,212), "S9126C1.s9126c1f2");
    check_field_offset(lv, s9126c1f3, ABISELECT(312,244), "S9126C1.s9126c1f3");
    check_field_offset(lv, s9126c1f4, ABISELECT(344,276), "S9126C1.s9126c1f4");
    check_field_offset(lv, s9126c1f5, ABISELECT(352,280), "S9126C1.s9126c1f5");
    check_field_offset(lv, s9126c1f6, ABISELECT(376,296), "S9126C1.s9126c1f6");
    check_field_offset(lv, s9126c1f7, ABISELECT(3144,3064), "S9126C1.s9126c1f7");
    check_field_offset(lv, s9126c1f8, ABISELECT(3152,3072), "S9126C1.s9126c1f8");
    check_field_offset(lv, s9126c1f9, ABISELECT(3184,3092), "S9126C1.s9126c1f9");
    check_field_offset(lv, s9126c1f10, ABISELECT(3544,3356), "S9126C1.s9126c1f10");
    check_field_offset(lv, s9126c1f11, ABISELECT(3576,3376), "S9126C1.s9126c1f11");
    check_field_offset(lv, s9126c1f12, ABISELECT(3592,3388), "S9126C1.s9126c1f12");
    check_field_offset(lv, s9126c1f13, ABISELECT(3624,3408), "S9126C1.s9126c1f13");
    check_field_offset(lv, s9126c1f14, ABISELECT(3632,3416), "S9126C1.s9126c1f14");
    check_field_offset(lv, s9126c1f15, ABISELECT(3992,3680), "S9126C1.s9126c1f15");
    check_field_offset(lv, s9126c1f16, ABISELECT(4024,3700), "S9126C1.s9126c1f16");
    check_field_offset(lv, s9126c1f17, ABISELECT(4032,3704), "S9126C1.s9126c1f17");
    test_class_info(&lv, &cd_S9126C1);
    dp->~S9126C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9126C1(Test_S9126C1, "S9126C1", ABISELECT(4040,3708));

#else // __cplusplus

extern void _ZN7S9126C1C1Ev();
extern void _ZN7S9126C1D1Ev();
Name_Map name_map_S9126C1[] = {
  NSPAIR(_ZN7S9126C1C1Ev),
  NSPAIR(_ZN7S9126C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9126C2;
extern VTBL_ENTRY _ZTI7S9126C2[];
extern  VTBL_ENTRY _ZTV7S9126C2[];
extern Class_Descriptor cd_S9126C5;
extern VTBL_ENTRY _ZTI7S9126C5[];
extern  VTBL_ENTRY _ZTV7S9126C5[];
extern Class_Descriptor cd_S9126C4;
extern VTBL_ENTRY _ZTI7S9126C4[];
extern  VTBL_ENTRY _ZTV7S9126C4[];
extern Class_Descriptor cd_S9126C3;
extern VTBL_ENTRY _ZTI7S9126C3[];
extern  VTBL_ENTRY _ZTV7S9126C3[];
static Base_Class bases_S9126C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9126C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9126C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S9126C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S9126C3,    ABISELECT(8,4), //bcp->offset
    25, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9126C1[];
extern void _ZN7S9126C1D1Ev();
extern void _ZN7S9126C1D0Ev();
extern void _ZN7S9126C23v21Ev();
extern void _ZN7S9126C12v1Ev();
extern void _ZN7S9126C12v2Ev();
extern void _ZN7S9126C12v3Ev();
extern void _ZN7S9126C12v4Ev();
extern void _ZN7S9126C12v5Ev();
extern void _ZN7S9126C12v6Ev();
extern void _ZN7S9126C12v7Ev();
extern void _ZN7S9126C12v8Ev();
extern void _ZN7S9126C12v9Ev();
extern void _ZN7S9126C13v10Ev();
extern void _ZN7S9126C13v11Ev();
extern void _ZN7S9126C13v12Ev();
extern void _ZN7S9126C13v13Ev();
extern void _ZN7S9126C13v14Ev();
extern void _ZN7S9126C13v15Ev();
extern void _ZN7S9126C13v16Ev();
extern void _ZN7S9126C13v17Ev();
extern void _ZN7S9126C13v18Ev();
extern void _ZN7S9126C13v19Ev();
extern void _ZN7S9126C13v20Ev();
extern void ABISELECT(_ZThn8_N7S9126C1D1Ev,_ZThn4_N7S9126C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9126C1D0Ev,_ZThn4_N7S9126C1D0Ev)();
extern void _ZN7S9126C53v22Ev();
extern void _ZN7S9126C53v23Ev();
extern void _ZN7S9126C53v24Ev();
extern void _ZN7S9126C43v25Ev();
extern void _ZN7S9126C43v26Ev();
extern void _ZN7S9126C43v27Ev();
extern void _ZN7S9126C33v28Ev();
extern void _ZN7S9126C33v29Ev();
extern void _ZN7S9126C33v30Ev();
extern void _ZN7S9126C33v31Ev();
extern void _ZN7S9126C33v32Ev();
extern void _ZN7S9126C33v33Ev();
extern void _ZN7S9126C33v34Ev();
extern void _ZN7S9126C33v35Ev();
extern void _ZN7S9126C33v36Ev();
extern void _ZN7S9126C33v37Ev();
extern void _ZN7S9126C33v38Ev();
extern void _ZN7S9126C33v39Ev();
extern void _ZN7S9126C33v40Ev();
extern void _ZN7S9126C33v41Ev();
extern void _ZN7S9126C33v42Ev();
extern void _ZN7S9126C33v43Ev();
extern void _ZN7S9126C33v44Ev();
extern void _ZN7S9126C33v45Ev();
extern void _ZN7S9126C33v46Ev();
static  VTBL_ENTRY vtc_S9126C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9126C1[0]),
  (VTBL_ENTRY)&_ZN7S9126C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9126C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9126C23v21Ev,
  (VTBL_ENTRY)&_ZN7S9126C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9126C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9126C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9126C12v4Ev,
  (VTBL_ENTRY)&_ZN7S9126C12v5Ev,
  (VTBL_ENTRY)&_ZN7S9126C12v6Ev,
  (VTBL_ENTRY)&_ZN7S9126C12v7Ev,
  (VTBL_ENTRY)&_ZN7S9126C12v8Ev,
  (VTBL_ENTRY)&_ZN7S9126C12v9Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v10Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v11Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v12Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v13Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v14Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v15Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v16Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v17Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v18Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v19Ev,
  (VTBL_ENTRY)&_ZN7S9126C13v20Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9126C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9126C1D1Ev,_ZThn4_N7S9126C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9126C1D0Ev,_ZThn4_N7S9126C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9126C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9126C53v24Ev,
  (VTBL_ENTRY)&_ZN7S9126C43v25Ev,
  (VTBL_ENTRY)&_ZN7S9126C43v26Ev,
  (VTBL_ENTRY)&_ZN7S9126C43v27Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v28Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v29Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v30Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v31Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v32Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v33Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v34Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v35Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v36Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v37Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v38Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v39Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v40Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v41Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v42Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v43Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v44Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v45Ev,
  (VTBL_ENTRY)&_ZN7S9126C33v46Ev,
};
extern VTBL_ENTRY _ZTI7S9126C1[];
extern  VTBL_ENTRY _ZTV7S9126C1[];
Class_Descriptor cd_S9126C1 = {  "S9126C1", // class name
  bases_S9126C1, 4,
  &(vtc_S9126C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(4040,3708), // object size
  NSPAIRA(_ZTI7S9126C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9126C1),54, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9127C2  {
  virtual  ~S9127C2(); // _ZN7S9127C2D1Ev
  virtual void  v21(); // _ZN7S9127C23v21Ev
  S9127C2(); // tgen
};
//SIG(-1 S9127C2) C1{ vd v1}


 S9127C2 ::~S9127C2(){ note_dtor("S9127C2", this);}
void  S9127C2 ::v21(){vfunc_called(this, "_ZN7S9127C23v21Ev");}
S9127C2 ::S9127C2(){ note_ctor("S9127C2", this);} // tgen

static void Test_S9127C2()
{
  extern Class_Descriptor cd_S9127C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9127C2, buf);
    S9127C2 *dp, &lv = *(dp=new (buf) S9127C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9127C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9127C2)");
    test_class_info(&lv, &cd_S9127C2);
    dp->~S9127C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9127C2(Test_S9127C2, "S9127C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9127C2C1Ev();
extern void _ZN7S9127C2D1Ev();
Name_Map name_map_S9127C2[] = {
  NSPAIR(_ZN7S9127C2C1Ev),
  NSPAIR(_ZN7S9127C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9127C2[];
extern void _ZN7S9127C2D1Ev();
extern void _ZN7S9127C2D0Ev();
extern void _ZN7S9127C23v21Ev();
static  VTBL_ENTRY vtc_S9127C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9127C2[0]),
  (VTBL_ENTRY)&_ZN7S9127C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9127C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9127C23v21Ev,
};
extern VTBL_ENTRY _ZTI7S9127C2[];
extern  VTBL_ENTRY _ZTV7S9127C2[];
Class_Descriptor cd_S9127C2 = {  "S9127C2", // class name
  0,0,//no base classes
  &(vtc_S9127C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9127C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9127C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9127C5  {
  virtual  ~S9127C5(); // _ZN7S9127C5D1Ev
  virtual void  v22(); // _ZN7S9127C53v22Ev
  virtual void  v23(); // _ZN7S9127C53v23Ev
  virtual void  v24(); // _ZN7S9127C53v24Ev
  S9127C5(); // tgen
};
//SIG(-1 S9127C5) C1{ vd v1 v2 v3}


 S9127C5 ::~S9127C5(){ note_dtor("S9127C5", this);}
void  S9127C5 ::v22(){vfunc_called(this, "_ZN7S9127C53v22Ev");}
void  S9127C5 ::v23(){vfunc_called(this, "_ZN7S9127C53v23Ev");}
void  S9127C5 ::v24(){vfunc_called(this, "_ZN7S9127C53v24Ev");}
S9127C5 ::S9127C5(){ note_ctor("S9127C5", this);} // tgen

static void Test_S9127C5()
{
  extern Class_Descriptor cd_S9127C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9127C5, buf);
    S9127C5 *dp, &lv = *(dp=new (buf) S9127C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9127C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9127C5)");
    test_class_info(&lv, &cd_S9127C5);
    dp->~S9127C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9127C5(Test_S9127C5, "S9127C5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9127C5C1Ev();
extern void _ZN7S9127C5D1Ev();
Name_Map name_map_S9127C5[] = {
  NSPAIR(_ZN7S9127C5C1Ev),
  NSPAIR(_ZN7S9127C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9127C5[];
extern void _ZN7S9127C5D1Ev();
extern void _ZN7S9127C5D0Ev();
extern void _ZN7S9127C53v22Ev();
extern void _ZN7S9127C53v23Ev();
extern void _ZN7S9127C53v24Ev();
static  VTBL_ENTRY vtc_S9127C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9127C5[0]),
  (VTBL_ENTRY)&_ZN7S9127C5D1Ev,
  (VTBL_ENTRY)&_ZN7S9127C5D0Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v24Ev,
};
extern VTBL_ENTRY _ZTI7S9127C5[];
extern  VTBL_ENTRY _ZTV7S9127C5[];
Class_Descriptor cd_S9127C5 = {  "S9127C5", // class name
  0,0,//no base classes
  &(vtc_S9127C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9127C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9127C5),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9127C4  : S9127C5 {
  ::S10183C20 s9127c4f0;
  ::S10185C7_nt s9127c4f1;
  char s9127c4f2;
  virtual  ~S9127C4(); // _ZN7S9127C4D1Ev
  virtual void  v25(); // _ZN7S9127C43v25Ev
  virtual void  v26(); // _ZN7S9127C43v26Ev
  virtual void  v27(); // _ZN7S9127C43v27Ev
  S9127C4(); // tgen
};
//SIG(-1 S9127C4) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FL[4]} Fc}


 S9127C4 ::~S9127C4(){ note_dtor("S9127C4", this);}
void  S9127C4 ::v25(){vfunc_called(this, "_ZN7S9127C43v25Ev");}
void  S9127C4 ::v26(){vfunc_called(this, "_ZN7S9127C43v26Ev");}
void  S9127C4 ::v27(){vfunc_called(this, "_ZN7S9127C43v27Ev");}
S9127C4 ::S9127C4(){ note_ctor("S9127C4", this);} // tgen

static void Test_S9127C4()
{
  extern Class_Descriptor cd_S9127C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S9127C4, buf);
    S9127C4 *dp, &lv = *(dp=new (buf) S9127C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S9127C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9127C4)");
    check_base_class_offset(lv, (S9127C5*), 0, "S9127C4");
    check_field_offset(lv, s9127c4f0, ABISELECT(8,4), "S9127C4.s9127c4f0");
    check_field_offset(lv, s9127c4f1, ABISELECT(32,20), "S9127C4.s9127c4f1");
    check_field_offset(lv, s9127c4f2, ABISELECT(64,52), "S9127C4.s9127c4f2");
    test_class_info(&lv, &cd_S9127C4);
    dp->~S9127C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9127C4(Test_S9127C4, "S9127C4", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S9127C4C1Ev();
extern void _ZN7S9127C4D1Ev();
Name_Map name_map_S9127C4[] = {
  NSPAIR(_ZN7S9127C4C1Ev),
  NSPAIR(_ZN7S9127C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9127C5;
extern VTBL_ENTRY _ZTI7S9127C5[];
extern  VTBL_ENTRY _ZTV7S9127C5[];
static Base_Class bases_S9127C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9127C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9127C4[];
extern void _ZN7S9127C4D1Ev();
extern void _ZN7S9127C4D0Ev();
extern void _ZN7S9127C53v22Ev();
extern void _ZN7S9127C53v23Ev();
extern void _ZN7S9127C53v24Ev();
extern void _ZN7S9127C43v25Ev();
extern void _ZN7S9127C43v26Ev();
extern void _ZN7S9127C43v27Ev();
static  VTBL_ENTRY vtc_S9127C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9127C4[0]),
  (VTBL_ENTRY)&_ZN7S9127C4D1Ev,
  (VTBL_ENTRY)&_ZN7S9127C4D0Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v24Ev,
  (VTBL_ENTRY)&_ZN7S9127C43v25Ev,
  (VTBL_ENTRY)&_ZN7S9127C43v26Ev,
  (VTBL_ENTRY)&_ZN7S9127C43v27Ev,
};
extern VTBL_ENTRY _ZTI7S9127C4[];
extern  VTBL_ENTRY _ZTV7S9127C4[];
Class_Descriptor cd_S9127C4 = {  "S9127C4", // class name
  bases_S9127C4, 1,
  &(vtc_S9127C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S9127C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9127C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9127C3  : S9127C4 {
  virtual  ~S9127C3(); // _ZN7S9127C3D1Ev
  virtual void  v28(); // _ZN7S9127C33v28Ev
  virtual void  v29(); // _ZN7S9127C33v29Ev
  virtual void  v30(); // _ZN7S9127C33v30Ev
  virtual void  v31(); // _ZN7S9127C33v31Ev
  virtual void  v32(); // _ZN7S9127C33v32Ev
  virtual void  v33(); // _ZN7S9127C33v33Ev
  virtual void  v34(); // _ZN7S9127C33v34Ev
  virtual void  v35(); // _ZN7S9127C33v35Ev
  virtual void  v36(); // _ZN7S9127C33v36Ev
  virtual void  v37(); // _ZN7S9127C33v37Ev
  virtual void  v38(); // _ZN7S9127C33v38Ev
  virtual void  v39(); // _ZN7S9127C33v39Ev
  virtual void  v40(); // _ZN7S9127C33v40Ev
  virtual void  v41(); // _ZN7S9127C33v41Ev
  virtual void  v42(); // _ZN7S9127C33v42Ev
  virtual void  v43(); // _ZN7S9127C33v43Ev
  virtual void  v44(); // _ZN7S9127C33v44Ev
  virtual void  v45(); // _ZN7S9127C33v45Ev
  virtual void  v46(); // _ZN7S9127C33v46Ev
  S9127C3(); // tgen
};
//SIG(-1 S9127C3) C1{ BC2{ BC3{ vd v20 v21 v22} vd v23 v24 v25 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FL[4]} Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19}


 S9127C3 ::~S9127C3(){ note_dtor("S9127C3", this);}
void  S9127C3 ::v28(){vfunc_called(this, "_ZN7S9127C33v28Ev");}
void  S9127C3 ::v29(){vfunc_called(this, "_ZN7S9127C33v29Ev");}
void  S9127C3 ::v30(){vfunc_called(this, "_ZN7S9127C33v30Ev");}
void  S9127C3 ::v31(){vfunc_called(this, "_ZN7S9127C33v31Ev");}
void  S9127C3 ::v32(){vfunc_called(this, "_ZN7S9127C33v32Ev");}
void  S9127C3 ::v33(){vfunc_called(this, "_ZN7S9127C33v33Ev");}
void  S9127C3 ::v34(){vfunc_called(this, "_ZN7S9127C33v34Ev");}
void  S9127C3 ::v35(){vfunc_called(this, "_ZN7S9127C33v35Ev");}
void  S9127C3 ::v36(){vfunc_called(this, "_ZN7S9127C33v36Ev");}
void  S9127C3 ::v37(){vfunc_called(this, "_ZN7S9127C33v37Ev");}
void  S9127C3 ::v38(){vfunc_called(this, "_ZN7S9127C33v38Ev");}
void  S9127C3 ::v39(){vfunc_called(this, "_ZN7S9127C33v39Ev");}
void  S9127C3 ::v40(){vfunc_called(this, "_ZN7S9127C33v40Ev");}
void  S9127C3 ::v41(){vfunc_called(this, "_ZN7S9127C33v41Ev");}
void  S9127C3 ::v42(){vfunc_called(this, "_ZN7S9127C33v42Ev");}
void  S9127C3 ::v43(){vfunc_called(this, "_ZN7S9127C33v43Ev");}
void  S9127C3 ::v44(){vfunc_called(this, "_ZN7S9127C33v44Ev");}
void  S9127C3 ::v45(){vfunc_called(this, "_ZN7S9127C33v45Ev");}
void  S9127C3 ::v46(){vfunc_called(this, "_ZN7S9127C33v46Ev");}
S9127C3 ::S9127C3(){ note_ctor("S9127C3", this);} // tgen

static void Test_S9127C3()
{
  extern Class_Descriptor cd_S9127C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S9127C3, buf);
    S9127C3 *dp, &lv = *(dp=new (buf) S9127C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S9127C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9127C3)");
    check_base_class_offset(lv, (S9127C5*)(S9127C4*), 0, "S9127C3");
    check_base_class_offset(lv, (S9127C4*), 0, "S9127C3");
    test_class_info(&lv, &cd_S9127C3);
    dp->~S9127C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9127C3(Test_S9127C3, "S9127C3", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S9127C3C1Ev();
extern void _ZN7S9127C3D1Ev();
Name_Map name_map_S9127C3[] = {
  NSPAIR(_ZN7S9127C3C1Ev),
  NSPAIR(_ZN7S9127C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9127C5;
extern VTBL_ENTRY _ZTI7S9127C5[];
extern  VTBL_ENTRY _ZTV7S9127C5[];
extern Class_Descriptor cd_S9127C4;
extern VTBL_ENTRY _ZTI7S9127C4[];
extern  VTBL_ENTRY _ZTV7S9127C4[];
static Base_Class bases_S9127C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9127C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S9127C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9127C3[];
extern void _ZN7S9127C3D1Ev();
extern void _ZN7S9127C3D0Ev();
extern void _ZN7S9127C53v22Ev();
extern void _ZN7S9127C53v23Ev();
extern void _ZN7S9127C53v24Ev();
extern void _ZN7S9127C43v25Ev();
extern void _ZN7S9127C43v26Ev();
extern void _ZN7S9127C43v27Ev();
extern void _ZN7S9127C33v28Ev();
extern void _ZN7S9127C33v29Ev();
extern void _ZN7S9127C33v30Ev();
extern void _ZN7S9127C33v31Ev();
extern void _ZN7S9127C33v32Ev();
extern void _ZN7S9127C33v33Ev();
extern void _ZN7S9127C33v34Ev();
extern void _ZN7S9127C33v35Ev();
extern void _ZN7S9127C33v36Ev();
extern void _ZN7S9127C33v37Ev();
extern void _ZN7S9127C33v38Ev();
extern void _ZN7S9127C33v39Ev();
extern void _ZN7S9127C33v40Ev();
extern void _ZN7S9127C33v41Ev();
extern void _ZN7S9127C33v42Ev();
extern void _ZN7S9127C33v43Ev();
extern void _ZN7S9127C33v44Ev();
extern void _ZN7S9127C33v45Ev();
extern void _ZN7S9127C33v46Ev();
static  VTBL_ENTRY vtc_S9127C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9127C3[0]),
  (VTBL_ENTRY)&_ZN7S9127C3D1Ev,
  (VTBL_ENTRY)&_ZN7S9127C3D0Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v24Ev,
  (VTBL_ENTRY)&_ZN7S9127C43v25Ev,
  (VTBL_ENTRY)&_ZN7S9127C43v26Ev,
  (VTBL_ENTRY)&_ZN7S9127C43v27Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v28Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v29Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v30Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v31Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v32Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v33Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v34Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v35Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v36Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v37Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v38Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v39Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v40Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v41Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v42Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v43Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v44Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v45Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v46Ev,
};
extern VTBL_ENTRY _ZTI7S9127C3[];
extern  VTBL_ENTRY _ZTV7S9127C3[];
Class_Descriptor cd_S9127C3 = {  "S9127C3", // class name
  bases_S9127C3, 2,
  &(vtc_S9127C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S9127C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9127C3),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9127C1  : S9127C2 , S9127C3 {
  ::S10183C31 s9127c1f0;
  ::S9125C12_nt s9127c1f1;
  ::S10185C7_nt s9127c1f2;
  ::S10185C7_nt s9127c1f3;
  void *s9127c1f4;
  ::S10183C5_nt s9127c1f5;
  ::S9125C15 s9127c1f6;
  int s9127c1f7[2];
  ::S10183C19_nt s9127c1f8;
  ::S10183C17 s9127c1f9;
  ::S9125C34_nt s9127c1f10;
  int s9127c1f11[3];
  ::S10183C19_nt s9127c1f12;
  int s9127c1f13[2];
  ::S10183C17 s9127c1f14;
  ::S9125C34_nt s9127c1f15;
  void *s9127c1f16;
  char s9127c1f17[3];
  virtual  ~S9127C1(); // _ZN7S9127C1D1Ev
  virtual void  v1(); // _ZN7S9127C12v1Ev
  virtual void  v2(); // _ZN7S9127C12v2Ev
  virtual void  v3(); // _ZN7S9127C12v3Ev
  virtual void  v4(); // _ZN7S9127C12v4Ev
  virtual void  v5(); // _ZN7S9127C12v5Ev
  virtual void  v6(); // _ZN7S9127C12v6Ev
  virtual void  v7(); // _ZN7S9127C12v7Ev
  virtual void  v8(); // _ZN7S9127C12v8Ev
  virtual void  v9(); // _ZN7S9127C12v9Ev
  virtual void  v10(); // _ZN7S9127C13v10Ev
  virtual void  v11(); // _ZN7S9127C13v11Ev
  virtual void  v12(); // _ZN7S9127C13v12Ev
  virtual void  v13(); // _ZN7S9127C13v13Ev
  virtual void  v14(); // _ZN7S9127C13v14Ev
  virtual void  v15(); // _ZN7S9127C13v15Ev
  virtual void  v16(); // _ZN7S9127C13v16Ev
  virtual void  v17(); // _ZN7S9127C13v17Ev
  virtual void  v18(); // _ZN7S9127C13v18Ev
  virtual void  v19(); // _ZN7S9127C13v19Ev
  virtual void  v20(); // _ZN7S9127C13v20Ev
  S9127C1(); // tgen
};
//SIG(1 S9127C1) C1{ BC2{ vd v21} BC3{ BC4{ BC5{ vd v22 v23 v24} vd v25 v26 v27 FC6{ m Fp Fi[2] FC7{ m}} FC8{ m FL[4]} Fc} vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 FC9{ Fi FC10{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]} FC11{ Fc[12]} FC8 FC8 Fp FC12{ m Fp Fi[2] FC13{ m}} FC14{ Fi[2] FC15{ Fi[2]}[10] FC16{ Fi[3] Fc[256]}[10]} Fi[2] FC17{ BC6 BC18{ vd v49 v50} vd v47 v48} FC19{ BC18 vd v51 v52 FC20{ BC18 vd v53 v54 FC21{ m Fp Fi FC22{ m}}} FC23{ BC18 vd v55 v56 FC21 FC21 Fi} FC17 FC24{ vd m FC25{ m Fs[6] Fi[2] Fc Fs}} FC21 FC21 Fc[2] Fi FC21 FC21 FC21 FC21 FC21 Fi[3] Fp FC21 FC24 FC21 Fi} FC26{ BC27{ m Fp Fi[2] FC7} BC28{ vd v59 v60} vd v57 v58} Fi[3] FC17 Fi[2] FC19 FC26 Fp Fc[3]}


 S9127C1 ::~S9127C1(){ note_dtor("S9127C1", this);}
void  S9127C1 ::v1(){vfunc_called(this, "_ZN7S9127C12v1Ev");}
void  S9127C1 ::v2(){vfunc_called(this, "_ZN7S9127C12v2Ev");}
void  S9127C1 ::v3(){vfunc_called(this, "_ZN7S9127C12v3Ev");}
void  S9127C1 ::v4(){vfunc_called(this, "_ZN7S9127C12v4Ev");}
void  S9127C1 ::v5(){vfunc_called(this, "_ZN7S9127C12v5Ev");}
void  S9127C1 ::v6(){vfunc_called(this, "_ZN7S9127C12v6Ev");}
void  S9127C1 ::v7(){vfunc_called(this, "_ZN7S9127C12v7Ev");}
void  S9127C1 ::v8(){vfunc_called(this, "_ZN7S9127C12v8Ev");}
void  S9127C1 ::v9(){vfunc_called(this, "_ZN7S9127C12v9Ev");}
void  S9127C1 ::v10(){vfunc_called(this, "_ZN7S9127C13v10Ev");}
void  S9127C1 ::v11(){vfunc_called(this, "_ZN7S9127C13v11Ev");}
void  S9127C1 ::v12(){vfunc_called(this, "_ZN7S9127C13v12Ev");}
void  S9127C1 ::v13(){vfunc_called(this, "_ZN7S9127C13v13Ev");}
void  S9127C1 ::v14(){vfunc_called(this, "_ZN7S9127C13v14Ev");}
void  S9127C1 ::v15(){vfunc_called(this, "_ZN7S9127C13v15Ev");}
void  S9127C1 ::v16(){vfunc_called(this, "_ZN7S9127C13v16Ev");}
void  S9127C1 ::v17(){vfunc_called(this, "_ZN7S9127C13v17Ev");}
void  S9127C1 ::v18(){vfunc_called(this, "_ZN7S9127C13v18Ev");}
void  S9127C1 ::v19(){vfunc_called(this, "_ZN7S9127C13v19Ev");}
void  S9127C1 ::v20(){vfunc_called(this, "_ZN7S9127C13v20Ev");}
S9127C1 ::S9127C1(){ note_ctor("S9127C1", this);} // tgen

static void Test_S9127C1()
{
  extern Class_Descriptor cd_S9127C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(506,928)];
    init_test(&cd_S9127C1, buf);
    S9127C1 *dp, &lv = *(dp=new (buf) S9127C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4040,3708), "sizeof(S9127C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9127C1)");
    check_base_class_offset(lv, (S9127C2*), 0, "S9127C1");
    check_base_class_offset(lv, (S9127C5*)(S9127C4*)(S9127C3*), ABISELECT(8,4), "S9127C1");
    check_base_class_offset(lv, (S9127C4*)(S9127C3*), ABISELECT(8,4), "S9127C1");
    check_base_class_offset(lv, (S9127C3*), ABISELECT(8,4), "S9127C1");
    check_field_offset(lv, s9127c1f0, ABISELECT(80,60), "S9127C1.s9127c1f0");
    check_field_offset(lv, s9127c1f1, ABISELECT(264,200), "S9127C1.s9127c1f1");
    check_field_offset(lv, s9127c1f2, ABISELECT(280,212), "S9127C1.s9127c1f2");
    check_field_offset(lv, s9127c1f3, ABISELECT(312,244), "S9127C1.s9127c1f3");
    check_field_offset(lv, s9127c1f4, ABISELECT(344,276), "S9127C1.s9127c1f4");
    check_field_offset(lv, s9127c1f5, ABISELECT(352,280), "S9127C1.s9127c1f5");
    check_field_offset(lv, s9127c1f6, ABISELECT(376,296), "S9127C1.s9127c1f6");
    check_field_offset(lv, s9127c1f7, ABISELECT(3144,3064), "S9127C1.s9127c1f7");
    check_field_offset(lv, s9127c1f8, ABISELECT(3152,3072), "S9127C1.s9127c1f8");
    check_field_offset(lv, s9127c1f9, ABISELECT(3184,3092), "S9127C1.s9127c1f9");
    check_field_offset(lv, s9127c1f10, ABISELECT(3544,3356), "S9127C1.s9127c1f10");
    check_field_offset(lv, s9127c1f11, ABISELECT(3576,3376), "S9127C1.s9127c1f11");
    check_field_offset(lv, s9127c1f12, ABISELECT(3592,3388), "S9127C1.s9127c1f12");
    check_field_offset(lv, s9127c1f13, ABISELECT(3624,3408), "S9127C1.s9127c1f13");
    check_field_offset(lv, s9127c1f14, ABISELECT(3632,3416), "S9127C1.s9127c1f14");
    check_field_offset(lv, s9127c1f15, ABISELECT(3992,3680), "S9127C1.s9127c1f15");
    check_field_offset(lv, s9127c1f16, ABISELECT(4024,3700), "S9127C1.s9127c1f16");
    check_field_offset(lv, s9127c1f17, ABISELECT(4032,3704), "S9127C1.s9127c1f17");
    test_class_info(&lv, &cd_S9127C1);
    dp->~S9127C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9127C1(Test_S9127C1, "S9127C1", ABISELECT(4040,3708));

#else // __cplusplus

extern void _ZN7S9127C1C1Ev();
extern void _ZN7S9127C1D1Ev();
Name_Map name_map_S9127C1[] = {
  NSPAIR(_ZN7S9127C1C1Ev),
  NSPAIR(_ZN7S9127C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9127C2;
extern VTBL_ENTRY _ZTI7S9127C2[];
extern  VTBL_ENTRY _ZTV7S9127C2[];
extern Class_Descriptor cd_S9127C5;
extern VTBL_ENTRY _ZTI7S9127C5[];
extern  VTBL_ENTRY _ZTV7S9127C5[];
extern Class_Descriptor cd_S9127C4;
extern VTBL_ENTRY _ZTI7S9127C4[];
extern  VTBL_ENTRY _ZTV7S9127C4[];
extern Class_Descriptor cd_S9127C3;
extern VTBL_ENTRY _ZTI7S9127C3[];
extern  VTBL_ENTRY _ZTV7S9127C3[];
static Base_Class bases_S9127C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9127C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9127C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S9127C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S9127C3,    ABISELECT(8,4), //bcp->offset
    25, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9127C1[];
extern void _ZN7S9127C1D1Ev();
extern void _ZN7S9127C1D0Ev();
extern void _ZN7S9127C23v21Ev();
extern void _ZN7S9127C12v1Ev();
extern void _ZN7S9127C12v2Ev();
extern void _ZN7S9127C12v3Ev();
extern void _ZN7S9127C12v4Ev();
extern void _ZN7S9127C12v5Ev();
extern void _ZN7S9127C12v6Ev();
extern void _ZN7S9127C12v7Ev();
extern void _ZN7S9127C12v8Ev();
extern void _ZN7S9127C12v9Ev();
extern void _ZN7S9127C13v10Ev();
extern void _ZN7S9127C13v11Ev();
extern void _ZN7S9127C13v12Ev();
extern void _ZN7S9127C13v13Ev();
extern void _ZN7S9127C13v14Ev();
extern void _ZN7S9127C13v15Ev();
extern void _ZN7S9127C13v16Ev();
extern void _ZN7S9127C13v17Ev();
extern void _ZN7S9127C13v18Ev();
extern void _ZN7S9127C13v19Ev();
extern void _ZN7S9127C13v20Ev();
extern void ABISELECT(_ZThn8_N7S9127C1D1Ev,_ZThn4_N7S9127C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9127C1D0Ev,_ZThn4_N7S9127C1D0Ev)();
extern void _ZN7S9127C53v22Ev();
extern void _ZN7S9127C53v23Ev();
extern void _ZN7S9127C53v24Ev();
extern void _ZN7S9127C43v25Ev();
extern void _ZN7S9127C43v26Ev();
extern void _ZN7S9127C43v27Ev();
extern void _ZN7S9127C33v28Ev();
extern void _ZN7S9127C33v29Ev();
extern void _ZN7S9127C33v30Ev();
extern void _ZN7S9127C33v31Ev();
extern void _ZN7S9127C33v32Ev();
extern void _ZN7S9127C33v33Ev();
extern void _ZN7S9127C33v34Ev();
extern void _ZN7S9127C33v35Ev();
extern void _ZN7S9127C33v36Ev();
extern void _ZN7S9127C33v37Ev();
extern void _ZN7S9127C33v38Ev();
extern void _ZN7S9127C33v39Ev();
extern void _ZN7S9127C33v40Ev();
extern void _ZN7S9127C33v41Ev();
extern void _ZN7S9127C33v42Ev();
extern void _ZN7S9127C33v43Ev();
extern void _ZN7S9127C33v44Ev();
extern void _ZN7S9127C33v45Ev();
extern void _ZN7S9127C33v46Ev();
static  VTBL_ENTRY vtc_S9127C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9127C1[0]),
  (VTBL_ENTRY)&_ZN7S9127C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9127C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9127C23v21Ev,
  (VTBL_ENTRY)&_ZN7S9127C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9127C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9127C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9127C12v4Ev,
  (VTBL_ENTRY)&_ZN7S9127C12v5Ev,
  (VTBL_ENTRY)&_ZN7S9127C12v6Ev,
  (VTBL_ENTRY)&_ZN7S9127C12v7Ev,
  (VTBL_ENTRY)&_ZN7S9127C12v8Ev,
  (VTBL_ENTRY)&_ZN7S9127C12v9Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v10Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v11Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v12Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v13Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v14Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v15Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v16Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v17Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v18Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v19Ev,
  (VTBL_ENTRY)&_ZN7S9127C13v20Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9127C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9127C1D1Ev,_ZThn4_N7S9127C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9127C1D0Ev,_ZThn4_N7S9127C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9127C53v22Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v23Ev,
  (VTBL_ENTRY)&_ZN7S9127C53v24Ev,
  (VTBL_ENTRY)&_ZN7S9127C43v25Ev,
  (VTBL_ENTRY)&_ZN7S9127C43v26Ev,
  (VTBL_ENTRY)&_ZN7S9127C43v27Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v28Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v29Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v30Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v31Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v32Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v33Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v34Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v35Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v36Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v37Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v38Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v39Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v40Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v41Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v42Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v43Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v44Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v45Ev,
  (VTBL_ENTRY)&_ZN7S9127C33v46Ev,
};
extern VTBL_ENTRY _ZTI7S9127C1[];
extern  VTBL_ENTRY _ZTV7S9127C1[];
Class_Descriptor cd_S9127C1 = {  "S9127C1", // class name
  bases_S9127C1, 4,
  &(vtc_S9127C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(4040,3708), // object size
  NSPAIRA(_ZTI7S9127C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9127C1),54, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C4  {
  ::S10183C15_nt s2348c4f0;
  int s2348c4f1[2];
  char s2348c4f2;
  virtual  ~S2348C4(); // _ZN7S2348C4D1Ev
  virtual void  v5(); // _ZN7S2348C42v5Ev
  virtual void  v6(); // _ZN7S2348C42v6Ev
  virtual void  v7(); // _ZN7S2348C42v7Ev
  S2348C4(); // tgen
};
//SIG(-1 S2348C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2348C4 ::~S2348C4(){ note_dtor("S2348C4", this);}
void  S2348C4 ::v5(){vfunc_called(this, "_ZN7S2348C42v5Ev");}
void  S2348C4 ::v6(){vfunc_called(this, "_ZN7S2348C42v6Ev");}
void  S2348C4 ::v7(){vfunc_called(this, "_ZN7S2348C42v7Ev");}
S2348C4 ::S2348C4(){ note_ctor("S2348C4", this);} // tgen

static void Test_S2348C4()
{
  extern Class_Descriptor cd_S2348C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2348C4, buf);
    S2348C4 *dp, &lv = *(dp=new (buf) S2348C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2348C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2348C4)");
    check_field_offset(lv, s2348c4f0, ABISELECT(8,4), "S2348C4.s2348c4f0");
    check_field_offset(lv, s2348c4f1, ABISELECT(24,16), "S2348C4.s2348c4f1");
    check_field_offset(lv, s2348c4f2, ABISELECT(32,24), "S2348C4.s2348c4f2");
    test_class_info(&lv, &cd_S2348C4);
    dp->~S2348C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2348C4(Test_S2348C4, "S2348C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2348C4C1Ev();
extern void _ZN7S2348C4D1Ev();
Name_Map name_map_S2348C4[] = {
  NSPAIR(_ZN7S2348C4C1Ev),
  NSPAIR(_ZN7S2348C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2348C4[];
extern void _ZN7S2348C4D1Ev();
extern void _ZN7S2348C4D0Ev();
extern void _ZN7S2348C42v5Ev();
extern void _ZN7S2348C42v6Ev();
extern void _ZN7S2348C42v7Ev();
static  VTBL_ENTRY vtc_S2348C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2348C4[0]),
  (VTBL_ENTRY)&_ZN7S2348C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2348C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v7Ev,
};
extern VTBL_ENTRY _ZTI7S2348C4[];
extern  VTBL_ENTRY _ZTV7S2348C4[];
Class_Descriptor cd_S2348C4 = {  "S2348C4", // class name
  0,0,//no base classes
  &(vtc_S2348C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2348C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2348C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C7  {
  virtual  ~S2348C7(); // _ZN7S2348C7D1Ev
  virtual void  v8(); // _ZN7S2348C72v8Ev
  virtual void  v9(); // _ZN7S2348C72v9Ev
  virtual void  v10(); // _ZN7S2348C73v10Ev
  S2348C7(); // tgen
};
//SIG(-1 S2348C7) C1{ vd v1 v2 v3}


 S2348C7 ::~S2348C7(){ note_dtor("S2348C7", this);}
void  S2348C7 ::v8(){vfunc_called(this, "_ZN7S2348C72v8Ev");}
void  S2348C7 ::v9(){vfunc_called(this, "_ZN7S2348C72v9Ev");}
void  S2348C7 ::v10(){vfunc_called(this, "_ZN7S2348C73v10Ev");}
S2348C7 ::S2348C7(){ note_ctor("S2348C7", this);} // tgen

static void Test_S2348C7()
{
  extern Class_Descriptor cd_S2348C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2348C7, buf);
    S2348C7 *dp, &lv = *(dp=new (buf) S2348C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2348C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2348C7)");
    test_class_info(&lv, &cd_S2348C7);
    dp->~S2348C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2348C7(Test_S2348C7, "S2348C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2348C7C1Ev();
extern void _ZN7S2348C7D1Ev();
Name_Map name_map_S2348C7[] = {
  NSPAIR(_ZN7S2348C7C1Ev),
  NSPAIR(_ZN7S2348C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2348C7[];
extern void _ZN7S2348C7D1Ev();
extern void _ZN7S2348C7D0Ev();
extern void _ZN7S2348C72v8Ev();
extern void _ZN7S2348C72v9Ev();
extern void _ZN7S2348C73v10Ev();
static  VTBL_ENTRY vtc_S2348C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2348C7[0]),
  (VTBL_ENTRY)&_ZN7S2348C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2348C7D0Ev,
  (VTBL_ENTRY)&_ZN7S2348C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2348C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2348C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2348C7[];
extern  VTBL_ENTRY _ZTV7S2348C7[];
Class_Descriptor cd_S2348C7 = {  "S2348C7", // class name
  0,0,//no base classes
  &(vtc_S2348C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2348C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2348C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C3  : S2348C4 , S2348C7 {
  void *s2348c3f0;
  char s2348c3f1;
  int s2348c3f2;
  virtual  ~S2348C3(); // _ZN7S2348C3D1Ev
  virtual void  v11(); // _ZN7S2348C33v11Ev
  virtual void  v12(); // _ZN7S2348C33v12Ev
  virtual void  v13(); // _ZN7S2348C33v13Ev
  virtual void  v14(); // _ZN7S2348C33v14Ev
  virtual void  v15(); // _ZN7S2348C33v15Ev
  virtual void  v16(); // _ZN7S2348C33v16Ev
  virtual void  v17(); // _ZN7S2348C33v17Ev
  virtual void  v18(); // _ZN7S2348C33v18Ev
  virtual void  v19(); // _ZN7S2348C33v19Ev
  virtual void  v20(); // _ZN7S2348C33v20Ev
  S2348C3(); // tgen
};
//SIG(-1 S2348C3) C1{ BC2{ vd v11 v12 v13 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ vd v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi}


 S2348C3 ::~S2348C3(){ note_dtor("S2348C3", this);}
void  S2348C3 ::v11(){vfunc_called(this, "_ZN7S2348C33v11Ev");}
void  S2348C3 ::v12(){vfunc_called(this, "_ZN7S2348C33v12Ev");}
void  S2348C3 ::v13(){vfunc_called(this, "_ZN7S2348C33v13Ev");}
void  S2348C3 ::v14(){vfunc_called(this, "_ZN7S2348C33v14Ev");}
void  S2348C3 ::v15(){vfunc_called(this, "_ZN7S2348C33v15Ev");}
void  S2348C3 ::v16(){vfunc_called(this, "_ZN7S2348C33v16Ev");}
void  S2348C3 ::v17(){vfunc_called(this, "_ZN7S2348C33v17Ev");}
void  S2348C3 ::v18(){vfunc_called(this, "_ZN7S2348C33v18Ev");}
void  S2348C3 ::v19(){vfunc_called(this, "_ZN7S2348C33v19Ev");}
void  S2348C3 ::v20(){vfunc_called(this, "_ZN7S2348C33v20Ev");}
S2348C3 ::S2348C3(){ note_ctor("S2348C3", this);} // tgen

static void Test_S2348C3()
{
  extern Class_Descriptor cd_S2348C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S2348C3, buf);
    S2348C3 *dp, &lv = *(dp=new (buf) S2348C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2348C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2348C3)");
    check_base_class_offset(lv, (S2348C4*), 0, "S2348C3");
    check_base_class_offset(lv, (S2348C7*), ABISELECT(40,28), "S2348C3");
    check_field_offset(lv, s2348c3f0, ABISELECT(48,32), "S2348C3.s2348c3f0");
    check_field_offset(lv, s2348c3f1, ABISELECT(56,36), "S2348C3.s2348c3f1");
    check_field_offset(lv, s2348c3f2, ABISELECT(60,40), "S2348C3.s2348c3f2");
    test_class_info(&lv, &cd_S2348C3);
    dp->~S2348C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2348C3(Test_S2348C3, "S2348C3", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN7S2348C3C1Ev();
extern void _ZN7S2348C3D1Ev();
Name_Map name_map_S2348C3[] = {
  NSPAIR(_ZN7S2348C3C1Ev),
  NSPAIR(_ZN7S2348C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2348C4;
extern VTBL_ENTRY _ZTI7S2348C4[];
extern  VTBL_ENTRY _ZTV7S2348C4[];
extern Class_Descriptor cd_S2348C7;
extern VTBL_ENTRY _ZTI7S2348C7[];
extern  VTBL_ENTRY _ZTV7S2348C7[];
static Base_Class bases_S2348C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2348C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2348C7,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2348C3[];
extern void _ZN7S2348C3D1Ev();
extern void _ZN7S2348C3D0Ev();
extern void _ZN7S2348C42v5Ev();
extern void _ZN7S2348C42v6Ev();
extern void _ZN7S2348C42v7Ev();
extern void _ZN7S2348C33v11Ev();
extern void _ZN7S2348C33v12Ev();
extern void _ZN7S2348C33v13Ev();
extern void _ZN7S2348C33v14Ev();
extern void _ZN7S2348C33v15Ev();
extern void _ZN7S2348C33v16Ev();
extern void _ZN7S2348C33v17Ev();
extern void _ZN7S2348C33v18Ev();
extern void _ZN7S2348C33v19Ev();
extern void _ZN7S2348C33v20Ev();
extern void ABISELECT(_ZThn40_N7S2348C3D1Ev,_ZThn28_N7S2348C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S2348C3D0Ev,_ZThn28_N7S2348C3D0Ev)();
extern void _ZN7S2348C72v8Ev();
extern void _ZN7S2348C72v9Ev();
extern void _ZN7S2348C73v10Ev();
static  VTBL_ENTRY vtc_S2348C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2348C3[0]),
  (VTBL_ENTRY)&_ZN7S2348C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2348C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v20Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2348C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2348C3D1Ev,_ZThn28_N7S2348C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2348C3D0Ev,_ZThn28_N7S2348C3D0Ev),
  (VTBL_ENTRY)&_ZN7S2348C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2348C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2348C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2348C3[];
extern  VTBL_ENTRY _ZTV7S2348C3[];
Class_Descriptor cd_S2348C3 = {  "S2348C3", // class name
  bases_S2348C3, 2,
  &(vtc_S2348C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI7S2348C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2348C3),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C10  {
  virtual  ~S2348C10(); // _ZN8S2348C10D1Ev
  virtual void  v21(); // _ZN8S2348C103v21Ev
  virtual void  v22(); // _ZN8S2348C103v22Ev
  virtual void  v23(); // _ZN8S2348C103v23Ev
  S2348C10(); // tgen
};
//SIG(-1 S2348C10) C1{ vd v1 v2 v3}


 S2348C10 ::~S2348C10(){ note_dtor("S2348C10", this);}
void  S2348C10 ::v21(){vfunc_called(this, "_ZN8S2348C103v21Ev");}
void  S2348C10 ::v22(){vfunc_called(this, "_ZN8S2348C103v22Ev");}
void  S2348C10 ::v23(){vfunc_called(this, "_ZN8S2348C103v23Ev");}
S2348C10 ::S2348C10(){ note_ctor("S2348C10", this);} // tgen

static void Test_S2348C10()
{
  extern Class_Descriptor cd_S2348C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2348C10, buf);
    S2348C10 *dp, &lv = *(dp=new (buf) S2348C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2348C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2348C10)");
    test_class_info(&lv, &cd_S2348C10);
    dp->~S2348C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2348C10(Test_S2348C10, "S2348C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2348C10C1Ev();
extern void _ZN8S2348C10D1Ev();
Name_Map name_map_S2348C10[] = {
  NSPAIR(_ZN8S2348C10C1Ev),
  NSPAIR(_ZN8S2348C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2348C10[];
extern void _ZN8S2348C10D1Ev();
extern void _ZN8S2348C10D0Ev();
extern void _ZN8S2348C103v21Ev();
extern void _ZN8S2348C103v22Ev();
extern void _ZN8S2348C103v23Ev();
static  VTBL_ENTRY vtc_S2348C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2348C10[0]),
  (VTBL_ENTRY)&_ZN8S2348C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2348C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v23Ev,
};
extern VTBL_ENTRY _ZTI8S2348C10[];
extern  VTBL_ENTRY _ZTV8S2348C10[];
Class_Descriptor cd_S2348C10 = {  "S2348C10", // class name
  0,0,//no base classes
  &(vtc_S2348C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2348C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2348C10),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C9  : S2348C10 {
  ::S10183C20 s2348c9f0;
  ::S10183C7_nt s2348c9f1;
  char s2348c9f2;
  virtual  ~S2348C9(); // _ZN7S2348C9D1Ev
  virtual void  v24(); // _ZN7S2348C93v24Ev
  virtual void  v25(); // _ZN7S2348C93v25Ev
  virtual void  v26(); // _ZN7S2348C93v26Ev
  S2348C9(); // tgen
};
//SIG(-1 S2348C9) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ Fl[4]}} Fc}


 S2348C9 ::~S2348C9(){ note_dtor("S2348C9", this);}
void  S2348C9 ::v24(){vfunc_called(this, "_ZN7S2348C93v24Ev");}
void  S2348C9 ::v25(){vfunc_called(this, "_ZN7S2348C93v25Ev");}
void  S2348C9 ::v26(){vfunc_called(this, "_ZN7S2348C93v26Ev");}
S2348C9 ::S2348C9(){ note_ctor("S2348C9", this);} // tgen

static void Test_S2348C9()
{
  extern Class_Descriptor cd_S2348C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2348C9, buf);
    S2348C9 *dp, &lv = *(dp=new (buf) S2348C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2348C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2348C9)");
    check_base_class_offset(lv, (S2348C10*), 0, "S2348C9");
    check_field_offset(lv, s2348c9f0, ABISELECT(8,4), "S2348C9.s2348c9f0");
    check_field_offset(lv, s2348c9f1, ABISELECT(32,20), "S2348C9.s2348c9f1");
    check_field_offset(lv, s2348c9f2, ABISELECT(64,36), "S2348C9.s2348c9f2");
    test_class_info(&lv, &cd_S2348C9);
    dp->~S2348C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2348C9(Test_S2348C9, "S2348C9", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2348C9C1Ev();
extern void _ZN7S2348C9D1Ev();
Name_Map name_map_S2348C9[] = {
  NSPAIR(_ZN7S2348C9C1Ev),
  NSPAIR(_ZN7S2348C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2348C10;
extern VTBL_ENTRY _ZTI8S2348C10[];
extern  VTBL_ENTRY _ZTV8S2348C10[];
static Base_Class bases_S2348C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2348C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2348C9[];
extern void _ZN7S2348C9D1Ev();
extern void _ZN7S2348C9D0Ev();
extern void _ZN8S2348C103v21Ev();
extern void _ZN8S2348C103v22Ev();
extern void _ZN8S2348C103v23Ev();
extern void _ZN7S2348C93v24Ev();
extern void _ZN7S2348C93v25Ev();
extern void _ZN7S2348C93v26Ev();
static  VTBL_ENTRY vtc_S2348C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2348C9[0]),
  (VTBL_ENTRY)&_ZN7S2348C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2348C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v26Ev,
};
extern VTBL_ENTRY _ZTI7S2348C9[];
extern  VTBL_ENTRY _ZTV7S2348C9[];
Class_Descriptor cd_S2348C9 = {  "S2348C9", // class name
  bases_S2348C9, 1,
  &(vtc_S2348C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2348C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2348C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C8  : S2348C9 {
  virtual  ~S2348C8(); // _ZN7S2348C8D1Ev
  virtual void  v27(); // _ZN7S2348C83v27Ev
  virtual void  v28(); // _ZN7S2348C83v28Ev
  virtual void  v29(); // _ZN7S2348C83v29Ev
  virtual void  v30(); // _ZN7S2348C83v30Ev
  S2348C8(); // tgen
};
//SIG(-1 S2348C8) C1{ BC2{ BC3{ vd v5 v6 v7} vd v8 v9 v10 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc} vd v1 v2 v3 v4}


 S2348C8 ::~S2348C8(){ note_dtor("S2348C8", this);}
void  S2348C8 ::v27(){vfunc_called(this, "_ZN7S2348C83v27Ev");}
void  S2348C8 ::v28(){vfunc_called(this, "_ZN7S2348C83v28Ev");}
void  S2348C8 ::v29(){vfunc_called(this, "_ZN7S2348C83v29Ev");}
void  S2348C8 ::v30(){vfunc_called(this, "_ZN7S2348C83v30Ev");}
S2348C8 ::S2348C8(){ note_ctor("S2348C8", this);} // tgen

static void Test_S2348C8()
{
  extern Class_Descriptor cd_S2348C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2348C8, buf);
    S2348C8 *dp, &lv = *(dp=new (buf) S2348C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2348C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2348C8)");
    check_base_class_offset(lv, (S2348C10*)(S2348C9*), 0, "S2348C8");
    check_base_class_offset(lv, (S2348C9*), 0, "S2348C8");
    test_class_info(&lv, &cd_S2348C8);
    dp->~S2348C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2348C8(Test_S2348C8, "S2348C8", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2348C8C1Ev();
extern void _ZN7S2348C8D1Ev();
Name_Map name_map_S2348C8[] = {
  NSPAIR(_ZN7S2348C8C1Ev),
  NSPAIR(_ZN7S2348C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2348C10;
extern VTBL_ENTRY _ZTI8S2348C10[];
extern  VTBL_ENTRY _ZTV8S2348C10[];
extern Class_Descriptor cd_S2348C9;
extern VTBL_ENTRY _ZTI7S2348C9[];
extern  VTBL_ENTRY _ZTV7S2348C9[];
static Base_Class bases_S2348C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2348C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2348C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2348C8[];
extern void _ZN7S2348C8D1Ev();
extern void _ZN7S2348C8D0Ev();
extern void _ZN8S2348C103v21Ev();
extern void _ZN8S2348C103v22Ev();
extern void _ZN8S2348C103v23Ev();
extern void _ZN7S2348C93v24Ev();
extern void _ZN7S2348C93v25Ev();
extern void _ZN7S2348C93v26Ev();
extern void _ZN7S2348C83v27Ev();
extern void _ZN7S2348C83v28Ev();
extern void _ZN7S2348C83v29Ev();
extern void _ZN7S2348C83v30Ev();
static  VTBL_ENTRY vtc_S2348C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2348C8[0]),
  (VTBL_ENTRY)&_ZN7S2348C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2348C8D0Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2348C8[];
extern  VTBL_ENTRY _ZTV7S2348C8[];
Class_Descriptor cd_S2348C8 = {  "S2348C8", // class name
  bases_S2348C8, 2,
  &(vtc_S2348C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2348C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2348C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C2  : S2348C3 , S2348C8 {
  int s2348c2f0[3];
  char s2348c2f1;
  ::S10183C9_nt s2348c2f2;
  virtual  ~S2348C2(); // _ZN7S2348C2D1Ev
  virtual void  v31(); // _ZN7S2348C23v31Ev
  virtual void  v32(); // _ZN7S2348C23v32Ev
  virtual void  v33(); // _ZN7S2348C23v33Ev
  virtual void  v34(); // _ZN7S2348C23v34Ev
  virtual void  v35(); // _ZN7S2348C23v35Ev
  virtual void  v36(); // _ZN7S2348C23v36Ev
  S2348C2(); // tgen
};
//SIG(-1 S2348C2) C1{ BC2{ BC3{ vd v7 v8 v9 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} BC6{ vd v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fc Fi} BC7{ BC8{ BC9{ vd v23 v24 v25} vd v26 v27 v28 FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FC13{ Fl[4]}} Fc} vd v29 v30 v31 v32} vd v1 v2 v3 v4 v5 v6 Fi[3] Fc FC14{ BC15{ m Fp Fi FC16{ m} FC5}}}


 S2348C2 ::~S2348C2(){ note_dtor("S2348C2", this);}
void  S2348C2 ::v31(){vfunc_called(this, "_ZN7S2348C23v31Ev");}
void  S2348C2 ::v32(){vfunc_called(this, "_ZN7S2348C23v32Ev");}
void  S2348C2 ::v33(){vfunc_called(this, "_ZN7S2348C23v33Ev");}
void  S2348C2 ::v34(){vfunc_called(this, "_ZN7S2348C23v34Ev");}
void  S2348C2 ::v35(){vfunc_called(this, "_ZN7S2348C23v35Ev");}
void  S2348C2 ::v36(){vfunc_called(this, "_ZN7S2348C23v36Ev");}
S2348C2 ::S2348C2(){ note_ctor("S2348C2", this);} // tgen

static void Test_S2348C2()
{
  extern Class_Descriptor cd_S2348C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,29)];
    init_test(&cd_S2348C2, buf);
    S2348C2 *dp, &lv = *(dp=new (buf) S2348C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,112), "sizeof(S2348C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2348C2)");
    check_base_class_offset(lv, (S2348C4*)(S2348C3*), 0, "S2348C2");
    check_base_class_offset(lv, (S2348C7*)(S2348C3*), ABISELECT(40,28), "S2348C2");
    check_base_class_offset(lv, (S2348C3*), 0, "S2348C2");
    check_base_class_offset(lv, (S2348C10*)(S2348C9*)(S2348C8*), ABISELECT(64,44), "S2348C2");
    check_base_class_offset(lv, (S2348C9*)(S2348C8*), ABISELECT(64,44), "S2348C2");
    check_base_class_offset(lv, (S2348C8*), ABISELECT(64,44), "S2348C2");
    check_field_offset(lv, s2348c2f0, ABISELECT(132,84), "S2348C2.s2348c2f0");
    check_field_offset(lv, s2348c2f1, ABISELECT(144,96), "S2348C2.s2348c2f1");
    check_field_offset(lv, s2348c2f2, ABISELECT(152,100), "S2348C2.s2348c2f2");
    test_class_info(&lv, &cd_S2348C2);
    dp->~S2348C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2348C2(Test_S2348C2, "S2348C2", ABISELECT(168,112));

#else // __cplusplus

extern void _ZN7S2348C2C1Ev();
extern void _ZN7S2348C2D1Ev();
Name_Map name_map_S2348C2[] = {
  NSPAIR(_ZN7S2348C2C1Ev),
  NSPAIR(_ZN7S2348C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2348C4;
extern VTBL_ENTRY _ZTI7S2348C4[];
extern  VTBL_ENTRY _ZTV7S2348C4[];
extern Class_Descriptor cd_S2348C7;
extern VTBL_ENTRY _ZTI7S2348C7[];
extern  VTBL_ENTRY _ZTV7S2348C7[];
extern Class_Descriptor cd_S2348C3;
extern VTBL_ENTRY _ZTI7S2348C3[];
extern  VTBL_ENTRY _ZTV7S2348C3[];
extern Class_Descriptor cd_S2348C10;
extern VTBL_ENTRY _ZTI8S2348C10[];
extern  VTBL_ENTRY _ZTV8S2348C10[];
extern Class_Descriptor cd_S2348C9;
extern VTBL_ENTRY _ZTI7S2348C9[];
extern  VTBL_ENTRY _ZTV7S2348C9[];
extern Class_Descriptor cd_S2348C8;
extern VTBL_ENTRY _ZTI7S2348C8[];
extern  VTBL_ENTRY _ZTV7S2348C8[];
static Base_Class bases_S2348C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2348C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2348C7,    ABISELECT(40,28), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2348C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2348C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2348C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2348C8,    ABISELECT(64,44), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2348C2[];
extern void _ZN7S2348C2D1Ev();
extern void _ZN7S2348C2D0Ev();
extern void _ZN7S2348C42v5Ev();
extern void _ZN7S2348C42v6Ev();
extern void _ZN7S2348C42v7Ev();
extern void _ZN7S2348C33v11Ev();
extern void _ZN7S2348C33v12Ev();
extern void _ZN7S2348C33v13Ev();
extern void _ZN7S2348C33v14Ev();
extern void _ZN7S2348C33v15Ev();
extern void _ZN7S2348C33v16Ev();
extern void _ZN7S2348C33v17Ev();
extern void _ZN7S2348C33v18Ev();
extern void _ZN7S2348C33v19Ev();
extern void _ZN7S2348C33v20Ev();
extern void _ZN7S2348C23v31Ev();
extern void _ZN7S2348C23v32Ev();
extern void _ZN7S2348C23v33Ev();
extern void _ZN7S2348C23v34Ev();
extern void _ZN7S2348C23v35Ev();
extern void _ZN7S2348C23v36Ev();
extern void ABISELECT(_ZThn40_N7S2348C2D1Ev,_ZThn28_N7S2348C2D1Ev)();
extern void ABISELECT(_ZThn40_N7S2348C2D0Ev,_ZThn28_N7S2348C2D0Ev)();
extern void _ZN7S2348C72v8Ev();
extern void _ZN7S2348C72v9Ev();
extern void _ZN7S2348C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2348C2D1Ev,_ZThn44_N7S2348C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S2348C2D0Ev,_ZThn44_N7S2348C2D0Ev)();
extern void _ZN8S2348C103v21Ev();
extern void _ZN8S2348C103v22Ev();
extern void _ZN8S2348C103v23Ev();
extern void _ZN7S2348C93v24Ev();
extern void _ZN7S2348C93v25Ev();
extern void _ZN7S2348C93v26Ev();
extern void _ZN7S2348C83v27Ev();
extern void _ZN7S2348C83v28Ev();
extern void _ZN7S2348C83v29Ev();
extern void _ZN7S2348C83v30Ev();
static  VTBL_ENTRY vtc_S2348C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2348C2[0]),
  (VTBL_ENTRY)&_ZN7S2348C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2348C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v36Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2348C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2348C2D1Ev,_ZThn28_N7S2348C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2348C2D0Ev,_ZThn28_N7S2348C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2348C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2348C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2348C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2348C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2348C2D1Ev,_ZThn44_N7S2348C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2348C2D0Ev,_ZThn44_N7S2348C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2348C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2348C2[];
extern  VTBL_ENTRY _ZTV7S2348C2[];
Class_Descriptor cd_S2348C2 = {  "S2348C2", // class name
  bases_S2348C2, 6,
  &(vtc_S2348C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,112), // object size
  NSPAIRA(_ZTI7S2348C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2348C2),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C19  {
  void *s2348c19f0;
  char s2348c19f1;
  virtual  ~S2348C19(); // _ZN8S2348C19D1Ev
  virtual void  v37(); // _ZN8S2348C193v37Ev
  virtual void  v38(); // _ZN8S2348C193v38Ev
  virtual void  v39(); // _ZN8S2348C193v39Ev
  virtual void  v40(); // _ZN8S2348C193v40Ev
  virtual void  v41(); // _ZN8S2348C193v41Ev
  virtual void  v42(); // _ZN8S2348C193v42Ev
  virtual void  v43(); // _ZN8S2348C193v43Ev
  S2348C19(); // tgen
};
//SIG(-1 S2348C19) C1{ vd v1 v2 v3 v4 v5 v6 v7 Fp Fc}


 S2348C19 ::~S2348C19(){ note_dtor("S2348C19", this);}
void  S2348C19 ::v37(){vfunc_called(this, "_ZN8S2348C193v37Ev");}
void  S2348C19 ::v38(){vfunc_called(this, "_ZN8S2348C193v38Ev");}
void  S2348C19 ::v39(){vfunc_called(this, "_ZN8S2348C193v39Ev");}
void  S2348C19 ::v40(){vfunc_called(this, "_ZN8S2348C193v40Ev");}
void  S2348C19 ::v41(){vfunc_called(this, "_ZN8S2348C193v41Ev");}
void  S2348C19 ::v42(){vfunc_called(this, "_ZN8S2348C193v42Ev");}
void  S2348C19 ::v43(){vfunc_called(this, "_ZN8S2348C193v43Ev");}
S2348C19 ::S2348C19(){ note_ctor("S2348C19", this);} // tgen

static void Test_S2348C19()
{
  extern Class_Descriptor cd_S2348C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S2348C19, buf);
    S2348C19 *dp, &lv = *(dp=new (buf) S2348C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S2348C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2348C19)");
    check_field_offset(lv, s2348c19f0, ABISELECT(8,4), "S2348C19.s2348c19f0");
    check_field_offset(lv, s2348c19f1, ABISELECT(16,8), "S2348C19.s2348c19f1");
    test_class_info(&lv, &cd_S2348C19);
    dp->~S2348C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2348C19(Test_S2348C19, "S2348C19", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S2348C19C1Ev();
extern void _ZN8S2348C19D1Ev();
Name_Map name_map_S2348C19[] = {
  NSPAIR(_ZN8S2348C19C1Ev),
  NSPAIR(_ZN8S2348C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2348C19[];
extern void _ZN8S2348C19D1Ev();
extern void _ZN8S2348C19D0Ev();
extern void _ZN8S2348C193v37Ev();
extern void _ZN8S2348C193v38Ev();
extern void _ZN8S2348C193v39Ev();
extern void _ZN8S2348C193v40Ev();
extern void _ZN8S2348C193v41Ev();
extern void _ZN8S2348C193v42Ev();
extern void _ZN8S2348C193v43Ev();
static  VTBL_ENTRY vtc_S2348C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2348C19[0]),
  (VTBL_ENTRY)&_ZN8S2348C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2348C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2348C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2348C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2348C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2348C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2348C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2348C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2348C193v43Ev,
};
extern VTBL_ENTRY _ZTI8S2348C19[];
extern  VTBL_ENTRY _ZTV8S2348C19[];
Class_Descriptor cd_S2348C19 = {  "S2348C19", // class name
  0,0,//no base classes
  &(vtc_S2348C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S2348C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2348C19),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C22_nt  {
  ::S10183C10_nt s2348c22f0;
  void  mf2348c22(); // _ZN11S2348C22_nt9mf2348c22Ev
};
//SIG(-1 S2348C22_nt) C1{ m FC2{ m Fp Fi FC3{ m} FC4{ m}}}


void  S2348C22_nt ::mf2348c22(){}

//skip512 S2348C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C21_nt  {
  ::S2348C22_nt s2348c21f0;
  void *s2348c21f1[3];
  char s2348c21f2;
  virtual  ~S2348C21_nt(); // _ZN11S2348C21_ntD1Ev
  virtual void  v45(); // _ZN11S2348C21_nt3v45Ev
  S2348C21_nt(); // tgen
};
//SIG(-1 S2348C21_nt) C1{ vd v1 FC2{ m FC3{ m Fp Fi FC4{ m} FC5{ m}}} Fp[3] Fc}


 S2348C21_nt ::~S2348C21_nt(){ note_dtor("S2348C21_nt", this);}
void  S2348C21_nt ::v45(){vfunc_called(this, "_ZN11S2348C21_nt3v45Ev");}
S2348C21_nt ::S2348C21_nt(){ note_ctor("S2348C21_nt", this);} // tgen

//skip512 S2348C21_nt

#else // __cplusplus

extern void _ZN11S2348C21_ntC1Ev();
extern void _ZN11S2348C21_ntD1Ev();
Name_Map name_map_S2348C21_nt[] = {
  NSPAIR(_ZN11S2348C21_ntC1Ev),
  NSPAIR(_ZN11S2348C21_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S2348C21_nt[];
extern void _ZN11S2348C21_ntD1Ev();
extern void _ZN11S2348C21_ntD0Ev();
extern void _ZN11S2348C21_nt3v45Ev();
static  VTBL_ENTRY vtc_S2348C21_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S2348C21_nt[0]),
  (VTBL_ENTRY)&_ZN11S2348C21_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S2348C21_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S2348C21_nt3v45Ev,
};
extern VTBL_ENTRY _ZTI11S2348C21_nt[];
VTBL_ENTRY *P__ZTI11S2348C21_nt = _ZTI11S2348C21_nt; 
extern  VTBL_ENTRY _ZTV11S2348C21_nt[];
Class_Descriptor cd_S2348C21_nt = {  "S2348C21_nt", // class name
  0,0,//no base classes
  &(vtc_S2348C21_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI11S2348C21_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S2348C21_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C20_nt  : S2348C21_nt {
  void *s2348c20f0;
  virtual void  v44(); // _ZN11S2348C20_nt3v44Ev
  ~S2348C20_nt(); // tgen
  S2348C20_nt(); // tgen
};
//SIG(-1 S2348C20_nt) C1{ BC2{ vd v2 FC3{ m FC4{ m Fp Fi FC5{ m} FC6{ m}}} Fp[3] Fc} v1 Fp}


void  S2348C20_nt ::v44(){vfunc_called(this, "_ZN11S2348C20_nt3v44Ev");}
S2348C20_nt ::~S2348C20_nt(){ note_dtor("S2348C20_nt", this);} // tgen
S2348C20_nt ::S2348C20_nt(){ note_ctor("S2348C20_nt", this);} // tgen

//skip512 S2348C20_nt

#else // __cplusplus

extern void _ZN11S2348C20_ntC1Ev();
extern void _ZN11S2348C20_ntD1Ev();
Name_Map name_map_S2348C20_nt[] = {
  NSPAIR(_ZN11S2348C20_ntC1Ev),
  NSPAIR(_ZN11S2348C20_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2348C21_nt;
extern VTBL_ENTRY _ZTI11S2348C21_nt[];
extern  VTBL_ENTRY _ZTV11S2348C21_nt[];
static Base_Class bases_S2348C20_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2348C21_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S2348C20_nt[];
extern void _ZN11S2348C20_ntD1Ev();
extern void _ZN11S2348C20_ntD0Ev();
extern void _ZN11S2348C21_nt3v45Ev();
extern void _ZN11S2348C20_nt3v44Ev();
static  VTBL_ENTRY vtc_S2348C20_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S2348C20_nt[0]),
  (VTBL_ENTRY)&_ZN11S2348C20_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S2348C20_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S2348C21_nt3v45Ev,
  (VTBL_ENTRY)&_ZN11S2348C20_nt3v44Ev,
};
extern VTBL_ENTRY _ZTI11S2348C20_nt[];
VTBL_ENTRY *P__ZTI11S2348C20_nt = _ZTI11S2348C20_nt; 
extern  VTBL_ENTRY _ZTV11S2348C20_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C37_nt  {
  void *s2348c37f0;
  int s2348c37f1;
  ::S10183C21 s2348c37f2;
  ::S10183C12 s2348c37f3;
  void  mf2348c37(); // _ZN11S2348C37_nt9mf2348c37Ev
};
//SIG(-1 S2348C37_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2348C37_nt ::mf2348c37(){}

//skip512 S2348C37_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2348C1  : S2348C2 {
  ::S2348C19 s2348c1f0;
  ::S2348C20_nt s2348c1f1;
  ::S10183C17 s2348c1f2;
  int s2348c1f3;
  ::S10183C15_nt s2348c1f4;
  ::S2348C37_nt s2348c1f5;
  virtual  ~S2348C1(); // _ZN7S2348C1D1Ev
  virtual void  v1(); // _ZN7S2348C12v1Ev
  virtual void  v2(); // _ZN7S2348C12v2Ev
  virtual void  v3(); // _ZN7S2348C12v3Ev
  virtual void  v4(); // _ZN7S2348C12v4Ev
  S2348C1(); // tgen
};
//SIG(1 S2348C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} BC7{ vd v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp Fc Fi} BC8{ BC9{ BC10{ vd v21 v22 v23} vd v24 v25 v26 FC11{ m Fp Fi[2] FC12{ m}} FC13{ m FC14{ Fl[4]}} Fc} vd v27 v28 v29 v30} vd v31 v32 v33 v34 v35 v36 Fi[3] Fc FC15{ BC16{ m Fp Fi FC17{ m} FC6}}} vd v1 v2 v3 v4 FC18{ vd v37 v38 v39 v40 v41 v42 v43 Fp Fc} FC19{ BC20{ vd v45 FC21{ m FC16} Fp[3] Fc} v44 Fp} FC22{ BC23{ vd v48 v49} vd v46 v47 FC24{ BC23 vd v50 v51 FC5} FC25{ BC23 vd v52 v53 FC5 FC5 Fi} FC26{ BC11 BC23 vd v54 v55} FC27{ vd m FC28{ m Fs[6] Fi[2] Fc Fs}} FC5 FC5 Fc[2] Fi FC5 FC5 FC5 FC5 FC5 Fi[3] Fp FC5 FC27 FC5 Fi} Fi FC5 FC29{ m Fp Fi FC12 FC6}}


 S2348C1 ::~S2348C1(){ note_dtor("S2348C1", this);}
void  S2348C1 ::v1(){vfunc_called(this, "_ZN7S2348C12v1Ev");}
void  S2348C1 ::v2(){vfunc_called(this, "_ZN7S2348C12v2Ev");}
void  S2348C1 ::v3(){vfunc_called(this, "_ZN7S2348C12v3Ev");}
void  S2348C1 ::v4(){vfunc_called(this, "_ZN7S2348C12v4Ev");}
S2348C1 ::S2348C1(){ note_ctor("S2348C1", this);} // tgen

static void Test_S2348C1()
{
  extern Class_Descriptor cd_S2348C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(83,114)];
    init_test(&cd_S2348C1, buf);
    S2348C1 *dp, &lv = *(dp=new (buf) S2348C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(656,452), "sizeof(S2348C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2348C1)");
    check_base_class_offset(lv, (S2348C4*)(S2348C3*)(S2348C2*), 0, "S2348C1");
    check_base_class_offset(lv, (S2348C7*)(S2348C3*)(S2348C2*), ABISELECT(40,28), "S2348C1");
    check_base_class_offset(lv, (S2348C3*)(S2348C2*), 0, "S2348C1");
    check_base_class_offset(lv, (S2348C10*)(S2348C9*)(S2348C8*)(S2348C2*), ABISELECT(64,44), "S2348C1");
    check_base_class_offset(lv, (S2348C9*)(S2348C8*)(S2348C2*), ABISELECT(64,44), "S2348C1");
    check_base_class_offset(lv, (S2348C8*)(S2348C2*), ABISELECT(64,44), "S2348C1");
    check_base_class_offset(lv, (S2348C2*), 0, "S2348C1");
    check_field_offset(lv, s2348c1f0, ABISELECT(168,112), "S2348C1.s2348c1f0");
    check_field_offset(lv, s2348c1f1, ABISELECT(192,124), "S2348C1.s2348c1f1");
    check_field_offset(lv, s2348c1f2, ABISELECT(256,160), "S2348C1.s2348c1f2");
    check_field_offset(lv, s2348c1f3, ABISELECT(616,424), "S2348C1.s2348c1f3");
    check_field_offset(lv, s2348c1f4, ABISELECT(624,428), "S2348C1.s2348c1f4");
    check_field_offset(lv, s2348c1f5, ABISELECT(640,440), "S2348C1.s2348c1f5");
    test_class_info(&lv, &cd_S2348C1);
    dp->~S2348C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2348C1(Test_S2348C1, "S2348C1", ABISELECT(656,452));

#else // __cplusplus

extern void _ZN7S2348C1C1Ev();
extern void _ZN7S2348C1D1Ev();
Name_Map name_map_S2348C1[] = {
  NSPAIR(_ZN7S2348C1C1Ev),
  NSPAIR(_ZN7S2348C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2348C4;
extern VTBL_ENTRY _ZTI7S2348C4[];
extern  VTBL_ENTRY _ZTV7S2348C4[];
extern Class_Descriptor cd_S2348C7;
extern VTBL_ENTRY _ZTI7S2348C7[];
extern  VTBL_ENTRY _ZTV7S2348C7[];
extern Class_Descriptor cd_S2348C3;
extern VTBL_ENTRY _ZTI7S2348C3[];
extern  VTBL_ENTRY _ZTV7S2348C3[];
extern Class_Descriptor cd_S2348C10;
extern VTBL_ENTRY _ZTI8S2348C10[];
extern  VTBL_ENTRY _ZTV8S2348C10[];
extern Class_Descriptor cd_S2348C9;
extern VTBL_ENTRY _ZTI7S2348C9[];
extern  VTBL_ENTRY _ZTV7S2348C9[];
extern Class_Descriptor cd_S2348C8;
extern VTBL_ENTRY _ZTI7S2348C8[];
extern  VTBL_ENTRY _ZTV7S2348C8[];
extern Class_Descriptor cd_S2348C2;
extern VTBL_ENTRY _ZTI7S2348C2[];
extern  VTBL_ENTRY _ZTV7S2348C2[];
static Base_Class bases_S2348C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2348C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2348C7,    ABISELECT(40,28), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2348C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2348C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2348C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2348C8,    ABISELECT(64,44), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2348C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2348C1[];
extern void _ZN7S2348C1D1Ev();
extern void _ZN7S2348C1D0Ev();
extern void _ZN7S2348C42v5Ev();
extern void _ZN7S2348C42v6Ev();
extern void _ZN7S2348C42v7Ev();
extern void _ZN7S2348C33v11Ev();
extern void _ZN7S2348C33v12Ev();
extern void _ZN7S2348C33v13Ev();
extern void _ZN7S2348C33v14Ev();
extern void _ZN7S2348C33v15Ev();
extern void _ZN7S2348C33v16Ev();
extern void _ZN7S2348C33v17Ev();
extern void _ZN7S2348C33v18Ev();
extern void _ZN7S2348C33v19Ev();
extern void _ZN7S2348C33v20Ev();
extern void _ZN7S2348C23v31Ev();
extern void _ZN7S2348C23v32Ev();
extern void _ZN7S2348C23v33Ev();
extern void _ZN7S2348C23v34Ev();
extern void _ZN7S2348C23v35Ev();
extern void _ZN7S2348C23v36Ev();
extern void _ZN7S2348C12v1Ev();
extern void _ZN7S2348C12v2Ev();
extern void _ZN7S2348C12v3Ev();
extern void _ZN7S2348C12v4Ev();
extern void ABISELECT(_ZThn40_N7S2348C1D1Ev,_ZThn28_N7S2348C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S2348C1D0Ev,_ZThn28_N7S2348C1D0Ev)();
extern void _ZN7S2348C72v8Ev();
extern void _ZN7S2348C72v9Ev();
extern void _ZN7S2348C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2348C1D1Ev,_ZThn44_N7S2348C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S2348C1D0Ev,_ZThn44_N7S2348C1D0Ev)();
extern void _ZN8S2348C103v21Ev();
extern void _ZN8S2348C103v22Ev();
extern void _ZN8S2348C103v23Ev();
extern void _ZN7S2348C93v24Ev();
extern void _ZN7S2348C93v25Ev();
extern void _ZN7S2348C93v26Ev();
extern void _ZN7S2348C83v27Ev();
extern void _ZN7S2348C83v28Ev();
extern void _ZN7S2348C83v29Ev();
extern void _ZN7S2348C83v30Ev();
static  VTBL_ENTRY vtc_S2348C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2348C1[0]),
  (VTBL_ENTRY)&_ZN7S2348C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2348C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2348C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2348C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2348C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2348C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2348C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2348C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2348C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2348C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2348C1D1Ev,_ZThn28_N7S2348C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2348C1D0Ev,_ZThn28_N7S2348C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2348C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2348C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2348C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2348C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2348C1D1Ev,_ZThn44_N7S2348C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2348C1D0Ev,_ZThn44_N7S2348C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2348C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2348C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2348C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2348C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2348C1[];
extern  VTBL_ENTRY _ZTV7S2348C1[];
Class_Descriptor cd_S2348C1 = {  "S2348C1", // class name
  bases_S2348C1, 7,
  &(vtc_S2348C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(656,452), // object size
  NSPAIRA(_ZTI7S2348C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2348C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2349C4  {
  ::S10183C15_nt s2349c4f0;
  int s2349c4f1[2];
  char s2349c4f2;
  virtual  ~S2349C4(); // _ZN7S2349C4D1Ev
  virtual void  v5(); // _ZN7S2349C42v5Ev
  virtual void  v6(); // _ZN7S2349C42v6Ev
  virtual void  v7(); // _ZN7S2349C42v7Ev
  S2349C4(); // tgen
};
//SIG(-1 S2349C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2349C4 ::~S2349C4(){ note_dtor("S2349C4", this);}
void  S2349C4 ::v5(){vfunc_called(this, "_ZN7S2349C42v5Ev");}
void  S2349C4 ::v6(){vfunc_called(this, "_ZN7S2349C42v6Ev");}
void  S2349C4 ::v7(){vfunc_called(this, "_ZN7S2349C42v7Ev");}
S2349C4 ::S2349C4(){ note_ctor("S2349C4", this);} // tgen

static void Test_S2349C4()
{
  extern Class_Descriptor cd_S2349C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2349C4, buf);
    S2349C4 *dp, &lv = *(dp=new (buf) S2349C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2349C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2349C4)");
    check_field_offset(lv, s2349c4f0, ABISELECT(8,4), "S2349C4.s2349c4f0");
    check_field_offset(lv, s2349c4f1, ABISELECT(24,16), "S2349C4.s2349c4f1");
    check_field_offset(lv, s2349c4f2, ABISELECT(32,24), "S2349C4.s2349c4f2");
    test_class_info(&lv, &cd_S2349C4);
    dp->~S2349C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2349C4(Test_S2349C4, "S2349C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2349C4C1Ev();
extern void _ZN7S2349C4D1Ev();
Name_Map name_map_S2349C4[] = {
  NSPAIR(_ZN7S2349C4C1Ev),
  NSPAIR(_ZN7S2349C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2349C4[];
extern void _ZN7S2349C4D1Ev();
extern void _ZN7S2349C4D0Ev();
extern void _ZN7S2349C42v5Ev();
extern void _ZN7S2349C42v6Ev();
extern void _ZN7S2349C42v7Ev();
static  VTBL_ENTRY vtc_S2349C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2349C4[0]),
  (VTBL_ENTRY)&_ZN7S2349C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2349C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v7Ev,
};
extern VTBL_ENTRY _ZTI7S2349C4[];
extern  VTBL_ENTRY _ZTV7S2349C4[];
Class_Descriptor cd_S2349C4 = {  "S2349C4", // class name
  0,0,//no base classes
  &(vtc_S2349C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2349C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2349C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2349C7  {
  virtual  ~S2349C7(); // _ZN7S2349C7D1Ev
  virtual void  v8(); // _ZN7S2349C72v8Ev
  virtual void  v9(); // _ZN7S2349C72v9Ev
  virtual void  v10(); // _ZN7S2349C73v10Ev
  S2349C7(); // tgen
};
//SIG(-1 S2349C7) C1{ vd v1 v2 v3}


 S2349C7 ::~S2349C7(){ note_dtor("S2349C7", this);}
void  S2349C7 ::v8(){vfunc_called(this, "_ZN7S2349C72v8Ev");}
void  S2349C7 ::v9(){vfunc_called(this, "_ZN7S2349C72v9Ev");}
void  S2349C7 ::v10(){vfunc_called(this, "_ZN7S2349C73v10Ev");}
S2349C7 ::S2349C7(){ note_ctor("S2349C7", this);} // tgen

static void Test_S2349C7()
{
  extern Class_Descriptor cd_S2349C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2349C7, buf);
    S2349C7 *dp, &lv = *(dp=new (buf) S2349C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2349C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2349C7)");
    test_class_info(&lv, &cd_S2349C7);
    dp->~S2349C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2349C7(Test_S2349C7, "S2349C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2349C7C1Ev();
extern void _ZN7S2349C7D1Ev();
Name_Map name_map_S2349C7[] = {
  NSPAIR(_ZN7S2349C7C1Ev),
  NSPAIR(_ZN7S2349C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2349C7[];
extern void _ZN7S2349C7D1Ev();
extern void _ZN7S2349C7D0Ev();
extern void _ZN7S2349C72v8Ev();
extern void _ZN7S2349C72v9Ev();
extern void _ZN7S2349C73v10Ev();
static  VTBL_ENTRY vtc_S2349C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2349C7[0]),
  (VTBL_ENTRY)&_ZN7S2349C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2349C7D0Ev,
  (VTBL_ENTRY)&_ZN7S2349C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2349C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2349C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2349C7[];
extern  VTBL_ENTRY _ZTV7S2349C7[];
Class_Descriptor cd_S2349C7 = {  "S2349C7", // class name
  0,0,//no base classes
  &(vtc_S2349C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2349C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2349C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2349C3  : S2349C4 , S2349C7 {
  void *s2349c3f0;
  char s2349c3f1;
  int s2349c3f2;
  virtual  ~S2349C3(); // _ZN7S2349C3D1Ev
  virtual void  v11(); // _ZN7S2349C33v11Ev
  virtual void  v12(); // _ZN7S2349C33v12Ev
  virtual void  v13(); // _ZN7S2349C33v13Ev
  virtual void  v14(); // _ZN7S2349C33v14Ev
  virtual void  v15(); // _ZN7S2349C33v15Ev
  virtual void  v16(); // _ZN7S2349C33v16Ev
  virtual void  v17(); // _ZN7S2349C33v17Ev
  virtual void  v18(); // _ZN7S2349C33v18Ev
  virtual void  v19(); // _ZN7S2349C33v19Ev
  virtual void  v20(); // _ZN7S2349C33v20Ev
  S2349C3(); // tgen
};
//SIG(-1 S2349C3) C1{ BC2{ vd v11 v12 v13 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ vd v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi}


 S2349C3 ::~S2349C3(){ note_dtor("S2349C3", this);}
void  S2349C3 ::v11(){vfunc_called(this, "_ZN7S2349C33v11Ev");}
void  S2349C3 ::v12(){vfunc_called(this, "_ZN7S2349C33v12Ev");}
void  S2349C3 ::v13(){vfunc_called(this, "_ZN7S2349C33v13Ev");}
void  S2349C3 ::v14(){vfunc_called(this, "_ZN7S2349C33v14Ev");}
void  S2349C3 ::v15(){vfunc_called(this, "_ZN7S2349C33v15Ev");}
void  S2349C3 ::v16(){vfunc_called(this, "_ZN7S2349C33v16Ev");}
void  S2349C3 ::v17(){vfunc_called(this, "_ZN7S2349C33v17Ev");}
void  S2349C3 ::v18(){vfunc_called(this, "_ZN7S2349C33v18Ev");}
void  S2349C3 ::v19(){vfunc_called(this, "_ZN7S2349C33v19Ev");}
void  S2349C3 ::v20(){vfunc_called(this, "_ZN7S2349C33v20Ev");}
S2349C3 ::S2349C3(){ note_ctor("S2349C3", this);} // tgen

static void Test_S2349C3()
{
  extern Class_Descriptor cd_S2349C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S2349C3, buf);
    S2349C3 *dp, &lv = *(dp=new (buf) S2349C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2349C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2349C3)");
    check_base_class_offset(lv, (S2349C4*), 0, "S2349C3");
    check_base_class_offset(lv, (S2349C7*), ABISELECT(40,28), "S2349C3");
    check_field_offset(lv, s2349c3f0, ABISELECT(48,32), "S2349C3.s2349c3f0");
    check_field_offset(lv, s2349c3f1, ABISELECT(56,36), "S2349C3.s2349c3f1");
    check_field_offset(lv, s2349c3f2, ABISELECT(60,40), "S2349C3.s2349c3f2");
    test_class_info(&lv, &cd_S2349C3);
    dp->~S2349C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2349C3(Test_S2349C3, "S2349C3", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN7S2349C3C1Ev();
extern void _ZN7S2349C3D1Ev();
Name_Map name_map_S2349C3[] = {
  NSPAIR(_ZN7S2349C3C1Ev),
  NSPAIR(_ZN7S2349C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2349C4;
extern VTBL_ENTRY _ZTI7S2349C4[];
extern  VTBL_ENTRY _ZTV7S2349C4[];
extern Class_Descriptor cd_S2349C7;
extern VTBL_ENTRY _ZTI7S2349C7[];
extern  VTBL_ENTRY _ZTV7S2349C7[];
static Base_Class bases_S2349C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2349C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2349C7,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2349C3[];
extern void _ZN7S2349C3D1Ev();
extern void _ZN7S2349C3D0Ev();
extern void _ZN7S2349C42v5Ev();
extern void _ZN7S2349C42v6Ev();
extern void _ZN7S2349C42v7Ev();
extern void _ZN7S2349C33v11Ev();
extern void _ZN7S2349C33v12Ev();
extern void _ZN7S2349C33v13Ev();
extern void _ZN7S2349C33v14Ev();
extern void _ZN7S2349C33v15Ev();
extern void _ZN7S2349C33v16Ev();
extern void _ZN7S2349C33v17Ev();
extern void _ZN7S2349C33v18Ev();
extern void _ZN7S2349C33v19Ev();
extern void _ZN7S2349C33v20Ev();
extern void ABISELECT(_ZThn40_N7S2349C3D1Ev,_ZThn28_N7S2349C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S2349C3D0Ev,_ZThn28_N7S2349C3D0Ev)();
extern void _ZN7S2349C72v8Ev();
extern void _ZN7S2349C72v9Ev();
extern void _ZN7S2349C73v10Ev();
static  VTBL_ENTRY vtc_S2349C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2349C3[0]),
  (VTBL_ENTRY)&_ZN7S2349C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2349C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v20Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2349C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2349C3D1Ev,_ZThn28_N7S2349C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2349C3D0Ev,_ZThn28_N7S2349C3D0Ev),
  (VTBL_ENTRY)&_ZN7S2349C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2349C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2349C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2349C3[];
extern  VTBL_ENTRY _ZTV7S2349C3[];
Class_Descriptor cd_S2349C3 = {  "S2349C3", // class name
  bases_S2349C3, 2,
  &(vtc_S2349C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI7S2349C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2349C3),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2349C10  {
  virtual  ~S2349C10(); // _ZN8S2349C10D1Ev
  virtual void  v21(); // _ZN8S2349C103v21Ev
  virtual void  v22(); // _ZN8S2349C103v22Ev
  virtual void  v23(); // _ZN8S2349C103v23Ev
  S2349C10(); // tgen
};
//SIG(-1 S2349C10) C1{ vd v1 v2 v3}


 S2349C10 ::~S2349C10(){ note_dtor("S2349C10", this);}
void  S2349C10 ::v21(){vfunc_called(this, "_ZN8S2349C103v21Ev");}
void  S2349C10 ::v22(){vfunc_called(this, "_ZN8S2349C103v22Ev");}
void  S2349C10 ::v23(){vfunc_called(this, "_ZN8S2349C103v23Ev");}
S2349C10 ::S2349C10(){ note_ctor("S2349C10", this);} // tgen

static void Test_S2349C10()
{
  extern Class_Descriptor cd_S2349C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2349C10, buf);
    S2349C10 *dp, &lv = *(dp=new (buf) S2349C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2349C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2349C10)");
    test_class_info(&lv, &cd_S2349C10);
    dp->~S2349C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2349C10(Test_S2349C10, "S2349C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2349C10C1Ev();
extern void _ZN8S2349C10D1Ev();
Name_Map name_map_S2349C10[] = {
  NSPAIR(_ZN8S2349C10C1Ev),
  NSPAIR(_ZN8S2349C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2349C10[];
extern void _ZN8S2349C10D1Ev();
extern void _ZN8S2349C10D0Ev();
extern void _ZN8S2349C103v21Ev();
extern void _ZN8S2349C103v22Ev();
extern void _ZN8S2349C103v23Ev();
static  VTBL_ENTRY vtc_S2349C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2349C10[0]),
  (VTBL_ENTRY)&_ZN8S2349C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2349C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v23Ev,
};
extern VTBL_ENTRY _ZTI8S2349C10[];
extern  VTBL_ENTRY _ZTV8S2349C10[];
Class_Descriptor cd_S2349C10 = {  "S2349C10", // class name
  0,0,//no base classes
  &(vtc_S2349C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2349C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2349C10),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2349C9  : S2349C10 {
  ::S10183C20 s2349c9f0;
  ::S10184C7_nt s2349c9f1;
  char s2349c9f2;
  virtual  ~S2349C9(); // _ZN7S2349C9D1Ev
  virtual void  v24(); // _ZN7S2349C93v24Ev
  virtual void  v25(); // _ZN7S2349C93v25Ev
  virtual void  v26(); // _ZN7S2349C93v26Ev
  S2349C9(); // tgen
};
//SIG(-1 S2349C9) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ FL[4]}} Fc}


 S2349C9 ::~S2349C9(){ note_dtor("S2349C9", this);}
void  S2349C9 ::v24(){vfunc_called(this, "_ZN7S2349C93v24Ev");}
void  S2349C9 ::v25(){vfunc_called(this, "_ZN7S2349C93v25Ev");}
void  S2349C9 ::v26(){vfunc_called(this, "_ZN7S2349C93v26Ev");}
S2349C9 ::S2349C9(){ note_ctor("S2349C9", this);} // tgen

static void Test_S2349C9()
{
  extern Class_Descriptor cd_S2349C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2349C9, buf);
    S2349C9 *dp, &lv = *(dp=new (buf) S2349C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2349C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2349C9)");
    check_base_class_offset(lv, (S2349C10*), 0, "S2349C9");
    check_field_offset(lv, s2349c9f0, ABISELECT(8,4), "S2349C9.s2349c9f0");
    check_field_offset(lv, s2349c9f1, ABISELECT(32,20), "S2349C9.s2349c9f1");
    check_field_offset(lv, s2349c9f2, ABISELECT(64,52), "S2349C9.s2349c9f2");
    test_class_info(&lv, &cd_S2349C9);
    dp->~S2349C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2349C9(Test_S2349C9, "S2349C9", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2349C9C1Ev();
extern void _ZN7S2349C9D1Ev();
Name_Map name_map_S2349C9[] = {
  NSPAIR(_ZN7S2349C9C1Ev),
  NSPAIR(_ZN7S2349C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2349C10;
extern VTBL_ENTRY _ZTI8S2349C10[];
extern  VTBL_ENTRY _ZTV8S2349C10[];
static Base_Class bases_S2349C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2349C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2349C9[];
extern void _ZN7S2349C9D1Ev();
extern void _ZN7S2349C9D0Ev();
extern void _ZN8S2349C103v21Ev();
extern void _ZN8S2349C103v22Ev();
extern void _ZN8S2349C103v23Ev();
extern void _ZN7S2349C93v24Ev();
extern void _ZN7S2349C93v25Ev();
extern void _ZN7S2349C93v26Ev();
static  VTBL_ENTRY vtc_S2349C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2349C9[0]),
  (VTBL_ENTRY)&_ZN7S2349C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2349C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v26Ev,
};
extern VTBL_ENTRY _ZTI7S2349C9[];
extern  VTBL_ENTRY _ZTV7S2349C9[];
Class_Descriptor cd_S2349C9 = {  "S2349C9", // class name
  bases_S2349C9, 1,
  &(vtc_S2349C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2349C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2349C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2349C8  : S2349C9 {
  virtual  ~S2349C8(); // _ZN7S2349C8D1Ev
  virtual void  v27(); // _ZN7S2349C83v27Ev
  virtual void  v28(); // _ZN7S2349C83v28Ev
  virtual void  v29(); // _ZN7S2349C83v29Ev
  virtual void  v30(); // _ZN7S2349C83v30Ev
  S2349C8(); // tgen
};
//SIG(-1 S2349C8) C1{ BC2{ BC3{ vd v5 v6 v7} vd v8 v9 v10 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc} vd v1 v2 v3 v4}


 S2349C8 ::~S2349C8(){ note_dtor("S2349C8", this);}
void  S2349C8 ::v27(){vfunc_called(this, "_ZN7S2349C83v27Ev");}
void  S2349C8 ::v28(){vfunc_called(this, "_ZN7S2349C83v28Ev");}
void  S2349C8 ::v29(){vfunc_called(this, "_ZN7S2349C83v29Ev");}
void  S2349C8 ::v30(){vfunc_called(this, "_ZN7S2349C83v30Ev");}
S2349C8 ::S2349C8(){ note_ctor("S2349C8", this);} // tgen

static void Test_S2349C8()
{
  extern Class_Descriptor cd_S2349C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2349C8, buf);
    S2349C8 *dp, &lv = *(dp=new (buf) S2349C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2349C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2349C8)");
    check_base_class_offset(lv, (S2349C10*)(S2349C9*), 0, "S2349C8");
    check_base_class_offset(lv, (S2349C9*), 0, "S2349C8");
    test_class_info(&lv, &cd_S2349C8);
    dp->~S2349C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2349C8(Test_S2349C8, "S2349C8", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2349C8C1Ev();
extern void _ZN7S2349C8D1Ev();
Name_Map name_map_S2349C8[] = {
  NSPAIR(_ZN7S2349C8C1Ev),
  NSPAIR(_ZN7S2349C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2349C10;
extern VTBL_ENTRY _ZTI8S2349C10[];
extern  VTBL_ENTRY _ZTV8S2349C10[];
extern Class_Descriptor cd_S2349C9;
extern VTBL_ENTRY _ZTI7S2349C9[];
extern  VTBL_ENTRY _ZTV7S2349C9[];
static Base_Class bases_S2349C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2349C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2349C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2349C8[];
extern void _ZN7S2349C8D1Ev();
extern void _ZN7S2349C8D0Ev();
extern void _ZN8S2349C103v21Ev();
extern void _ZN8S2349C103v22Ev();
extern void _ZN8S2349C103v23Ev();
extern void _ZN7S2349C93v24Ev();
extern void _ZN7S2349C93v25Ev();
extern void _ZN7S2349C93v26Ev();
extern void _ZN7S2349C83v27Ev();
extern void _ZN7S2349C83v28Ev();
extern void _ZN7S2349C83v29Ev();
extern void _ZN7S2349C83v30Ev();
static  VTBL_ENTRY vtc_S2349C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2349C8[0]),
  (VTBL_ENTRY)&_ZN7S2349C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2349C8D0Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2349C8[];
extern  VTBL_ENTRY _ZTV7S2349C8[];
Class_Descriptor cd_S2349C8 = {  "S2349C8", // class name
  bases_S2349C8, 2,
  &(vtc_S2349C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2349C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2349C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2349C2  : S2349C3 , S2349C8 {
  int s2349c2f0[3];
  char s2349c2f1;
  ::S10183C9_nt s2349c2f2;
  virtual  ~S2349C2(); // _ZN7S2349C2D1Ev
  virtual void  v31(); // _ZN7S2349C23v31Ev
  virtual void  v32(); // _ZN7S2349C23v32Ev
  virtual void  v33(); // _ZN7S2349C23v33Ev
  virtual void  v34(); // _ZN7S2349C23v34Ev
  virtual void  v35(); // _ZN7S2349C23v35Ev
  virtual void  v36(); // _ZN7S2349C23v36Ev
  S2349C2(); // tgen
};
//SIG(-1 S2349C2) C1{ BC2{ BC3{ vd v7 v8 v9 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} BC6{ vd v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fc Fi} BC7{ BC8{ BC9{ vd v23 v24 v25} vd v26 v27 v28 FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FC13{ FL[4]}} Fc} vd v29 v30 v31 v32} vd v1 v2 v3 v4 v5 v6 Fi[3] Fc FC14{ BC15{ m Fp Fi FC16{ m} FC5}}}


 S2349C2 ::~S2349C2(){ note_dtor("S2349C2", this);}
void  S2349C2 ::v31(){vfunc_called(this, "_ZN7S2349C23v31Ev");}
void  S2349C2 ::v32(){vfunc_called(this, "_ZN7S2349C23v32Ev");}
void  S2349C2 ::v33(){vfunc_called(this, "_ZN7S2349C23v33Ev");}
void  S2349C2 ::v34(){vfunc_called(this, "_ZN7S2349C23v34Ev");}
void  S2349C2 ::v35(){vfunc_called(this, "_ZN7S2349C23v35Ev");}
void  S2349C2 ::v36(){vfunc_called(this, "_ZN7S2349C23v36Ev");}
S2349C2 ::S2349C2(){ note_ctor("S2349C2", this);} // tgen

static void Test_S2349C2()
{
  extern Class_Descriptor cd_S2349C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,33)];
    init_test(&cd_S2349C2, buf);
    S2349C2 *dp, &lv = *(dp=new (buf) S2349C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,128), "sizeof(S2349C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2349C2)");
    check_base_class_offset(lv, (S2349C4*)(S2349C3*), 0, "S2349C2");
    check_base_class_offset(lv, (S2349C7*)(S2349C3*), ABISELECT(40,28), "S2349C2");
    check_base_class_offset(lv, (S2349C3*), 0, "S2349C2");
    check_base_class_offset(lv, (S2349C10*)(S2349C9*)(S2349C8*), ABISELECT(64,44), "S2349C2");
    check_base_class_offset(lv, (S2349C9*)(S2349C8*), ABISELECT(64,44), "S2349C2");
    check_base_class_offset(lv, (S2349C8*), ABISELECT(64,44), "S2349C2");
    check_field_offset(lv, s2349c2f0, ABISELECT(132,100), "S2349C2.s2349c2f0");
    check_field_offset(lv, s2349c2f1, ABISELECT(144,112), "S2349C2.s2349c2f1");
    check_field_offset(lv, s2349c2f2, ABISELECT(152,116), "S2349C2.s2349c2f2");
    test_class_info(&lv, &cd_S2349C2);
    dp->~S2349C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2349C2(Test_S2349C2, "S2349C2", ABISELECT(168,128));

#else // __cplusplus

extern void _ZN7S2349C2C1Ev();
extern void _ZN7S2349C2D1Ev();
Name_Map name_map_S2349C2[] = {
  NSPAIR(_ZN7S2349C2C1Ev),
  NSPAIR(_ZN7S2349C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2349C4;
extern VTBL_ENTRY _ZTI7S2349C4[];
extern  VTBL_ENTRY _ZTV7S2349C4[];
extern Class_Descriptor cd_S2349C7;
extern VTBL_ENTRY _ZTI7S2349C7[];
extern  VTBL_ENTRY _ZTV7S2349C7[];
extern Class_Descriptor cd_S2349C3;
extern VTBL_ENTRY _ZTI7S2349C3[];
extern  VTBL_ENTRY _ZTV7S2349C3[];
extern Class_Descriptor cd_S2349C10;
extern VTBL_ENTRY _ZTI8S2349C10[];
extern  VTBL_ENTRY _ZTV8S2349C10[];
extern Class_Descriptor cd_S2349C9;
extern VTBL_ENTRY _ZTI7S2349C9[];
extern  VTBL_ENTRY _ZTV7S2349C9[];
extern Class_Descriptor cd_S2349C8;
extern VTBL_ENTRY _ZTI7S2349C8[];
extern  VTBL_ENTRY _ZTV7S2349C8[];
static Base_Class bases_S2349C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2349C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2349C7,    ABISELECT(40,28), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2349C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2349C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2349C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2349C8,    ABISELECT(64,44), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2349C2[];
extern void _ZN7S2349C2D1Ev();
extern void _ZN7S2349C2D0Ev();
extern void _ZN7S2349C42v5Ev();
extern void _ZN7S2349C42v6Ev();
extern void _ZN7S2349C42v7Ev();
extern void _ZN7S2349C33v11Ev();
extern void _ZN7S2349C33v12Ev();
extern void _ZN7S2349C33v13Ev();
extern void _ZN7S2349C33v14Ev();
extern void _ZN7S2349C33v15Ev();
extern void _ZN7S2349C33v16Ev();
extern void _ZN7S2349C33v17Ev();
extern void _ZN7S2349C33v18Ev();
extern void _ZN7S2349C33v19Ev();
extern void _ZN7S2349C33v20Ev();
extern void _ZN7S2349C23v31Ev();
extern void _ZN7S2349C23v32Ev();
extern void _ZN7S2349C23v33Ev();
extern void _ZN7S2349C23v34Ev();
extern void _ZN7S2349C23v35Ev();
extern void _ZN7S2349C23v36Ev();
extern void ABISELECT(_ZThn40_N7S2349C2D1Ev,_ZThn28_N7S2349C2D1Ev)();
extern void ABISELECT(_ZThn40_N7S2349C2D0Ev,_ZThn28_N7S2349C2D0Ev)();
extern void _ZN7S2349C72v8Ev();
extern void _ZN7S2349C72v9Ev();
extern void _ZN7S2349C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2349C2D1Ev,_ZThn44_N7S2349C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S2349C2D0Ev,_ZThn44_N7S2349C2D0Ev)();
extern void _ZN8S2349C103v21Ev();
extern void _ZN8S2349C103v22Ev();
extern void _ZN8S2349C103v23Ev();
extern void _ZN7S2349C93v24Ev();
extern void _ZN7S2349C93v25Ev();
extern void _ZN7S2349C93v26Ev();
extern void _ZN7S2349C83v27Ev();
extern void _ZN7S2349C83v28Ev();
extern void _ZN7S2349C83v29Ev();
extern void _ZN7S2349C83v30Ev();
static  VTBL_ENTRY vtc_S2349C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2349C2[0]),
  (VTBL_ENTRY)&_ZN7S2349C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2349C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v36Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2349C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2349C2D1Ev,_ZThn28_N7S2349C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2349C2D0Ev,_ZThn28_N7S2349C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2349C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2349C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2349C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2349C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2349C2D1Ev,_ZThn44_N7S2349C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2349C2D0Ev,_ZThn44_N7S2349C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2349C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2349C2[];
extern  VTBL_ENTRY _ZTV7S2349C2[];
Class_Descriptor cd_S2349C2 = {  "S2349C2", // class name
  bases_S2349C2, 6,
  &(vtc_S2349C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,128), // object size
  NSPAIRA(_ZTI7S2349C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2349C2),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2349C1  : S2349C2 {
  ::S2348C19 s2349c1f0;
  ::S2348C20_nt s2349c1f1;
  ::S10183C17 s2349c1f2;
  int s2349c1f3;
  ::S10183C15_nt s2349c1f4;
  ::S10183C10_nt s2349c1f5;
  virtual  ~S2349C1(); // _ZN7S2349C1D1Ev
  virtual void  v1(); // _ZN7S2349C12v1Ev
  virtual void  v2(); // _ZN7S2349C12v2Ev
  virtual void  v3(); // _ZN7S2349C12v3Ev
  virtual void  v4(); // _ZN7S2349C12v4Ev
  S2349C1(); // tgen
};
//SIG(1 S2349C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} BC7{ vd v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp Fc Fi} BC8{ BC9{ BC10{ vd v21 v22 v23} vd v24 v25 v26 FC11{ m Fp Fi[2] FC12{ m}} FC13{ m FC14{ FL[4]}} Fc} vd v27 v28 v29 v30} vd v31 v32 v33 v34 v35 v36 Fi[3] Fc FC15{ BC16{ m Fp Fi FC17{ m} FC6}}} vd v1 v2 v3 v4 FC18{ vd v37 v38 v39 v40 v41 v42 v43 Fp Fc} FC19{ BC20{ vd v45 FC21{ m FC16} Fp[3] Fc} v44 Fp} FC22{ BC23{ vd v48 v49} vd v46 v47 FC24{ BC23 vd v50 v51 FC5} FC25{ BC23 vd v52 v53 FC5 FC5 Fi} FC26{ BC11 BC23 vd v54 v55} FC27{ vd m FC28{ m Fs[6] Fi[2] Fc Fs}} FC5 FC5 Fc[2] Fi FC5 FC5 FC5 FC5 FC5 Fi[3] Fp FC5 FC27 FC5 Fi} Fi FC5 FC16}


 S2349C1 ::~S2349C1(){ note_dtor("S2349C1", this);}
void  S2349C1 ::v1(){vfunc_called(this, "_ZN7S2349C12v1Ev");}
void  S2349C1 ::v2(){vfunc_called(this, "_ZN7S2349C12v2Ev");}
void  S2349C1 ::v3(){vfunc_called(this, "_ZN7S2349C12v3Ev");}
void  S2349C1 ::v4(){vfunc_called(this, "_ZN7S2349C12v4Ev");}
S2349C1 ::S2349C1(){ note_ctor("S2349C1", this);} // tgen

static void Test_S2349C1()
{
  extern Class_Descriptor cd_S2349C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(83,118)];
    init_test(&cd_S2349C1, buf);
    S2349C1 *dp, &lv = *(dp=new (buf) S2349C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(656,468), "sizeof(S2349C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2349C1)");
    check_base_class_offset(lv, (S2349C4*)(S2349C3*)(S2349C2*), 0, "S2349C1");
    check_base_class_offset(lv, (S2349C7*)(S2349C3*)(S2349C2*), ABISELECT(40,28), "S2349C1");
    check_base_class_offset(lv, (S2349C3*)(S2349C2*), 0, "S2349C1");
    check_base_class_offset(lv, (S2349C10*)(S2349C9*)(S2349C8*)(S2349C2*), ABISELECT(64,44), "S2349C1");
    check_base_class_offset(lv, (S2349C9*)(S2349C8*)(S2349C2*), ABISELECT(64,44), "S2349C1");
    check_base_class_offset(lv, (S2349C8*)(S2349C2*), ABISELECT(64,44), "S2349C1");
    check_base_class_offset(lv, (S2349C2*), 0, "S2349C1");
    check_field_offset(lv, s2349c1f0, ABISELECT(168,128), "S2349C1.s2349c1f0");
    check_field_offset(lv, s2349c1f1, ABISELECT(192,140), "S2349C1.s2349c1f1");
    check_field_offset(lv, s2349c1f2, ABISELECT(256,176), "S2349C1.s2349c1f2");
    check_field_offset(lv, s2349c1f3, ABISELECT(616,440), "S2349C1.s2349c1f3");
    check_field_offset(lv, s2349c1f4, ABISELECT(624,444), "S2349C1.s2349c1f4");
    check_field_offset(lv, s2349c1f5, ABISELECT(640,456), "S2349C1.s2349c1f5");
    test_class_info(&lv, &cd_S2349C1);
    dp->~S2349C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2349C1(Test_S2349C1, "S2349C1", ABISELECT(656,468));

#else // __cplusplus

extern void _ZN7S2349C1C1Ev();
extern void _ZN7S2349C1D1Ev();
Name_Map name_map_S2349C1[] = {
  NSPAIR(_ZN7S2349C1C1Ev),
  NSPAIR(_ZN7S2349C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2349C4;
extern VTBL_ENTRY _ZTI7S2349C4[];
extern  VTBL_ENTRY _ZTV7S2349C4[];
extern Class_Descriptor cd_S2349C7;
extern VTBL_ENTRY _ZTI7S2349C7[];
extern  VTBL_ENTRY _ZTV7S2349C7[];
extern Class_Descriptor cd_S2349C3;
extern VTBL_ENTRY _ZTI7S2349C3[];
extern  VTBL_ENTRY _ZTV7S2349C3[];
extern Class_Descriptor cd_S2349C10;
extern VTBL_ENTRY _ZTI8S2349C10[];
extern  VTBL_ENTRY _ZTV8S2349C10[];
extern Class_Descriptor cd_S2349C9;
extern VTBL_ENTRY _ZTI7S2349C9[];
extern  VTBL_ENTRY _ZTV7S2349C9[];
extern Class_Descriptor cd_S2349C8;
extern VTBL_ENTRY _ZTI7S2349C8[];
extern  VTBL_ENTRY _ZTV7S2349C8[];
extern Class_Descriptor cd_S2349C2;
extern VTBL_ENTRY _ZTI7S2349C2[];
extern  VTBL_ENTRY _ZTV7S2349C2[];
static Base_Class bases_S2349C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2349C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2349C7,    ABISELECT(40,28), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2349C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2349C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2349C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2349C8,    ABISELECT(64,44), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2349C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2349C1[];
extern void _ZN7S2349C1D1Ev();
extern void _ZN7S2349C1D0Ev();
extern void _ZN7S2349C42v5Ev();
extern void _ZN7S2349C42v6Ev();
extern void _ZN7S2349C42v7Ev();
extern void _ZN7S2349C33v11Ev();
extern void _ZN7S2349C33v12Ev();
extern void _ZN7S2349C33v13Ev();
extern void _ZN7S2349C33v14Ev();
extern void _ZN7S2349C33v15Ev();
extern void _ZN7S2349C33v16Ev();
extern void _ZN7S2349C33v17Ev();
extern void _ZN7S2349C33v18Ev();
extern void _ZN7S2349C33v19Ev();
extern void _ZN7S2349C33v20Ev();
extern void _ZN7S2349C23v31Ev();
extern void _ZN7S2349C23v32Ev();
extern void _ZN7S2349C23v33Ev();
extern void _ZN7S2349C23v34Ev();
extern void _ZN7S2349C23v35Ev();
extern void _ZN7S2349C23v36Ev();
extern void _ZN7S2349C12v1Ev();
extern void _ZN7S2349C12v2Ev();
extern void _ZN7S2349C12v3Ev();
extern void _ZN7S2349C12v4Ev();
extern void ABISELECT(_ZThn40_N7S2349C1D1Ev,_ZThn28_N7S2349C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S2349C1D0Ev,_ZThn28_N7S2349C1D0Ev)();
extern void _ZN7S2349C72v8Ev();
extern void _ZN7S2349C72v9Ev();
extern void _ZN7S2349C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2349C1D1Ev,_ZThn44_N7S2349C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S2349C1D0Ev,_ZThn44_N7S2349C1D0Ev)();
extern void _ZN8S2349C103v21Ev();
extern void _ZN8S2349C103v22Ev();
extern void _ZN8S2349C103v23Ev();
extern void _ZN7S2349C93v24Ev();
extern void _ZN7S2349C93v25Ev();
extern void _ZN7S2349C93v26Ev();
extern void _ZN7S2349C83v27Ev();
extern void _ZN7S2349C83v28Ev();
extern void _ZN7S2349C83v29Ev();
extern void _ZN7S2349C83v30Ev();
static  VTBL_ENTRY vtc_S2349C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2349C1[0]),
  (VTBL_ENTRY)&_ZN7S2349C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2349C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2349C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2349C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2349C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2349C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2349C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2349C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2349C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2349C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2349C1D1Ev,_ZThn28_N7S2349C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2349C1D0Ev,_ZThn28_N7S2349C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2349C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2349C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2349C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2349C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2349C1D1Ev,_ZThn44_N7S2349C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2349C1D0Ev,_ZThn44_N7S2349C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2349C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2349C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2349C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2349C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2349C1[];
extern  VTBL_ENTRY _ZTV7S2349C1[];
Class_Descriptor cd_S2349C1 = {  "S2349C1", // class name
  bases_S2349C1, 7,
  &(vtc_S2349C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(656,468), // object size
  NSPAIRA(_ZTI7S2349C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2349C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2364C4  {
  ::S10183C15_nt s2364c4f0;
  int s2364c4f1[2];
  char s2364c4f2;
  virtual  ~S2364C4(); // _ZN7S2364C4D1Ev
  virtual void  v5(); // _ZN7S2364C42v5Ev
  virtual void  v6(); // _ZN7S2364C42v6Ev
  virtual void  v7(); // _ZN7S2364C42v7Ev
  S2364C4(); // tgen
};
//SIG(-1 S2364C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2364C4 ::~S2364C4(){ note_dtor("S2364C4", this);}
void  S2364C4 ::v5(){vfunc_called(this, "_ZN7S2364C42v5Ev");}
void  S2364C4 ::v6(){vfunc_called(this, "_ZN7S2364C42v6Ev");}
void  S2364C4 ::v7(){vfunc_called(this, "_ZN7S2364C42v7Ev");}
S2364C4 ::S2364C4(){ note_ctor("S2364C4", this);} // tgen

static void Test_S2364C4()
{
  extern Class_Descriptor cd_S2364C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2364C4, buf);
    S2364C4 *dp, &lv = *(dp=new (buf) S2364C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2364C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2364C4)");
    check_field_offset(lv, s2364c4f0, ABISELECT(8,4), "S2364C4.s2364c4f0");
    check_field_offset(lv, s2364c4f1, ABISELECT(24,16), "S2364C4.s2364c4f1");
    check_field_offset(lv, s2364c4f2, ABISELECT(32,24), "S2364C4.s2364c4f2");
    test_class_info(&lv, &cd_S2364C4);
    dp->~S2364C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2364C4(Test_S2364C4, "S2364C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2364C4C1Ev();
extern void _ZN7S2364C4D1Ev();
Name_Map name_map_S2364C4[] = {
  NSPAIR(_ZN7S2364C4C1Ev),
  NSPAIR(_ZN7S2364C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2364C4[];
extern void _ZN7S2364C4D1Ev();
extern void _ZN7S2364C4D0Ev();
extern void _ZN7S2364C42v5Ev();
extern void _ZN7S2364C42v6Ev();
extern void _ZN7S2364C42v7Ev();
static  VTBL_ENTRY vtc_S2364C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2364C4[0]),
  (VTBL_ENTRY)&_ZN7S2364C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2364C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v7Ev,
};
extern VTBL_ENTRY _ZTI7S2364C4[];
extern  VTBL_ENTRY _ZTV7S2364C4[];
Class_Descriptor cd_S2364C4 = {  "S2364C4", // class name
  0,0,//no base classes
  &(vtc_S2364C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2364C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2364C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2364C7  {
  virtual  ~S2364C7(); // _ZN7S2364C7D1Ev
  virtual void  v8(); // _ZN7S2364C72v8Ev
  virtual void  v9(); // _ZN7S2364C72v9Ev
  virtual void  v10(); // _ZN7S2364C73v10Ev
  S2364C7(); // tgen
};
//SIG(-1 S2364C7) C1{ vd v1 v2 v3}


 S2364C7 ::~S2364C7(){ note_dtor("S2364C7", this);}
void  S2364C7 ::v8(){vfunc_called(this, "_ZN7S2364C72v8Ev");}
void  S2364C7 ::v9(){vfunc_called(this, "_ZN7S2364C72v9Ev");}
void  S2364C7 ::v10(){vfunc_called(this, "_ZN7S2364C73v10Ev");}
S2364C7 ::S2364C7(){ note_ctor("S2364C7", this);} // tgen

static void Test_S2364C7()
{
  extern Class_Descriptor cd_S2364C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2364C7, buf);
    S2364C7 *dp, &lv = *(dp=new (buf) S2364C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2364C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2364C7)");
    test_class_info(&lv, &cd_S2364C7);
    dp->~S2364C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2364C7(Test_S2364C7, "S2364C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2364C7C1Ev();
extern void _ZN7S2364C7D1Ev();
Name_Map name_map_S2364C7[] = {
  NSPAIR(_ZN7S2364C7C1Ev),
  NSPAIR(_ZN7S2364C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2364C7[];
extern void _ZN7S2364C7D1Ev();
extern void _ZN7S2364C7D0Ev();
extern void _ZN7S2364C72v8Ev();
extern void _ZN7S2364C72v9Ev();
extern void _ZN7S2364C73v10Ev();
static  VTBL_ENTRY vtc_S2364C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2364C7[0]),
  (VTBL_ENTRY)&_ZN7S2364C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2364C7D0Ev,
  (VTBL_ENTRY)&_ZN7S2364C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2364C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2364C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2364C7[];
extern  VTBL_ENTRY _ZTV7S2364C7[];
Class_Descriptor cd_S2364C7 = {  "S2364C7", // class name
  0,0,//no base classes
  &(vtc_S2364C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2364C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2364C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2364C3  : S2364C4 , S2364C7 {
  void *s2364c3f0;
  char s2364c3f1;
  int s2364c3f2;
  virtual  ~S2364C3(); // _ZN7S2364C3D1Ev
  virtual void  v11(); // _ZN7S2364C33v11Ev
  virtual void  v12(); // _ZN7S2364C33v12Ev
  virtual void  v13(); // _ZN7S2364C33v13Ev
  virtual void  v14(); // _ZN7S2364C33v14Ev
  virtual void  v15(); // _ZN7S2364C33v15Ev
  virtual void  v16(); // _ZN7S2364C33v16Ev
  virtual void  v17(); // _ZN7S2364C33v17Ev
  virtual void  v18(); // _ZN7S2364C33v18Ev
  virtual void  v19(); // _ZN7S2364C33v19Ev
  virtual void  v20(); // _ZN7S2364C33v20Ev
  S2364C3(); // tgen
};
//SIG(-1 S2364C3) C1{ BC2{ vd v11 v12 v13 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ vd v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi}


 S2364C3 ::~S2364C3(){ note_dtor("S2364C3", this);}
void  S2364C3 ::v11(){vfunc_called(this, "_ZN7S2364C33v11Ev");}
void  S2364C3 ::v12(){vfunc_called(this, "_ZN7S2364C33v12Ev");}
void  S2364C3 ::v13(){vfunc_called(this, "_ZN7S2364C33v13Ev");}
void  S2364C3 ::v14(){vfunc_called(this, "_ZN7S2364C33v14Ev");}
void  S2364C3 ::v15(){vfunc_called(this, "_ZN7S2364C33v15Ev");}
void  S2364C3 ::v16(){vfunc_called(this, "_ZN7S2364C33v16Ev");}
void  S2364C3 ::v17(){vfunc_called(this, "_ZN7S2364C33v17Ev");}
void  S2364C3 ::v18(){vfunc_called(this, "_ZN7S2364C33v18Ev");}
void  S2364C3 ::v19(){vfunc_called(this, "_ZN7S2364C33v19Ev");}
void  S2364C3 ::v20(){vfunc_called(this, "_ZN7S2364C33v20Ev");}
S2364C3 ::S2364C3(){ note_ctor("S2364C3", this);} // tgen

static void Test_S2364C3()
{
  extern Class_Descriptor cd_S2364C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S2364C3, buf);
    S2364C3 *dp, &lv = *(dp=new (buf) S2364C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2364C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2364C3)");
    check_base_class_offset(lv, (S2364C4*), 0, "S2364C3");
    check_base_class_offset(lv, (S2364C7*), ABISELECT(40,28), "S2364C3");
    check_field_offset(lv, s2364c3f0, ABISELECT(48,32), "S2364C3.s2364c3f0");
    check_field_offset(lv, s2364c3f1, ABISELECT(56,36), "S2364C3.s2364c3f1");
    check_field_offset(lv, s2364c3f2, ABISELECT(60,40), "S2364C3.s2364c3f2");
    test_class_info(&lv, &cd_S2364C3);
    dp->~S2364C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2364C3(Test_S2364C3, "S2364C3", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN7S2364C3C1Ev();
extern void _ZN7S2364C3D1Ev();
Name_Map name_map_S2364C3[] = {
  NSPAIR(_ZN7S2364C3C1Ev),
  NSPAIR(_ZN7S2364C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2364C4;
extern VTBL_ENTRY _ZTI7S2364C4[];
extern  VTBL_ENTRY _ZTV7S2364C4[];
extern Class_Descriptor cd_S2364C7;
extern VTBL_ENTRY _ZTI7S2364C7[];
extern  VTBL_ENTRY _ZTV7S2364C7[];
static Base_Class bases_S2364C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2364C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2364C7,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2364C3[];
extern void _ZN7S2364C3D1Ev();
extern void _ZN7S2364C3D0Ev();
extern void _ZN7S2364C42v5Ev();
extern void _ZN7S2364C42v6Ev();
extern void _ZN7S2364C42v7Ev();
extern void _ZN7S2364C33v11Ev();
extern void _ZN7S2364C33v12Ev();
extern void _ZN7S2364C33v13Ev();
extern void _ZN7S2364C33v14Ev();
extern void _ZN7S2364C33v15Ev();
extern void _ZN7S2364C33v16Ev();
extern void _ZN7S2364C33v17Ev();
extern void _ZN7S2364C33v18Ev();
extern void _ZN7S2364C33v19Ev();
extern void _ZN7S2364C33v20Ev();
extern void ABISELECT(_ZThn40_N7S2364C3D1Ev,_ZThn28_N7S2364C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S2364C3D0Ev,_ZThn28_N7S2364C3D0Ev)();
extern void _ZN7S2364C72v8Ev();
extern void _ZN7S2364C72v9Ev();
extern void _ZN7S2364C73v10Ev();
static  VTBL_ENTRY vtc_S2364C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2364C3[0]),
  (VTBL_ENTRY)&_ZN7S2364C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2364C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v20Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2364C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2364C3D1Ev,_ZThn28_N7S2364C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2364C3D0Ev,_ZThn28_N7S2364C3D0Ev),
  (VTBL_ENTRY)&_ZN7S2364C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2364C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2364C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2364C3[];
extern  VTBL_ENTRY _ZTV7S2364C3[];
Class_Descriptor cd_S2364C3 = {  "S2364C3", // class name
  bases_S2364C3, 2,
  &(vtc_S2364C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI7S2364C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2364C3),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2364C10  {
  virtual  ~S2364C10(); // _ZN8S2364C10D1Ev
  virtual void  v21(); // _ZN8S2364C103v21Ev
  virtual void  v22(); // _ZN8S2364C103v22Ev
  virtual void  v23(); // _ZN8S2364C103v23Ev
  S2364C10(); // tgen
};
//SIG(-1 S2364C10) C1{ vd v1 v2 v3}


 S2364C10 ::~S2364C10(){ note_dtor("S2364C10", this);}
void  S2364C10 ::v21(){vfunc_called(this, "_ZN8S2364C103v21Ev");}
void  S2364C10 ::v22(){vfunc_called(this, "_ZN8S2364C103v22Ev");}
void  S2364C10 ::v23(){vfunc_called(this, "_ZN8S2364C103v23Ev");}
S2364C10 ::S2364C10(){ note_ctor("S2364C10", this);} // tgen

static void Test_S2364C10()
{
  extern Class_Descriptor cd_S2364C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2364C10, buf);
    S2364C10 *dp, &lv = *(dp=new (buf) S2364C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2364C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2364C10)");
    test_class_info(&lv, &cd_S2364C10);
    dp->~S2364C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2364C10(Test_S2364C10, "S2364C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2364C10C1Ev();
extern void _ZN8S2364C10D1Ev();
Name_Map name_map_S2364C10[] = {
  NSPAIR(_ZN8S2364C10C1Ev),
  NSPAIR(_ZN8S2364C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2364C10[];
extern void _ZN8S2364C10D1Ev();
extern void _ZN8S2364C10D0Ev();
extern void _ZN8S2364C103v21Ev();
extern void _ZN8S2364C103v22Ev();
extern void _ZN8S2364C103v23Ev();
static  VTBL_ENTRY vtc_S2364C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2364C10[0]),
  (VTBL_ENTRY)&_ZN8S2364C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2364C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v23Ev,
};
extern VTBL_ENTRY _ZTI8S2364C10[];
extern  VTBL_ENTRY _ZTV8S2364C10[];
Class_Descriptor cd_S2364C10 = {  "S2364C10", // class name
  0,0,//no base classes
  &(vtc_S2364C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2364C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2364C10),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2364C9  : S2364C10 {
  ::S10183C20 s2364c9f0;
  ::S10185C7_nt s2364c9f1;
  char s2364c9f2;
  virtual  ~S2364C9(); // _ZN7S2364C9D1Ev
  virtual void  v24(); // _ZN7S2364C93v24Ev
  virtual void  v25(); // _ZN7S2364C93v25Ev
  virtual void  v26(); // _ZN7S2364C93v26Ev
  S2364C9(); // tgen
};
//SIG(-1 S2364C9) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FL[4]} Fc}


 S2364C9 ::~S2364C9(){ note_dtor("S2364C9", this);}
void  S2364C9 ::v24(){vfunc_called(this, "_ZN7S2364C93v24Ev");}
void  S2364C9 ::v25(){vfunc_called(this, "_ZN7S2364C93v25Ev");}
void  S2364C9 ::v26(){vfunc_called(this, "_ZN7S2364C93v26Ev");}
S2364C9 ::S2364C9(){ note_ctor("S2364C9", this);} // tgen

static void Test_S2364C9()
{
  extern Class_Descriptor cd_S2364C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2364C9, buf);
    S2364C9 *dp, &lv = *(dp=new (buf) S2364C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2364C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2364C9)");
    check_base_class_offset(lv, (S2364C10*), 0, "S2364C9");
    check_field_offset(lv, s2364c9f0, ABISELECT(8,4), "S2364C9.s2364c9f0");
    check_field_offset(lv, s2364c9f1, ABISELECT(32,20), "S2364C9.s2364c9f1");
    check_field_offset(lv, s2364c9f2, ABISELECT(64,52), "S2364C9.s2364c9f2");
    test_class_info(&lv, &cd_S2364C9);
    dp->~S2364C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2364C9(Test_S2364C9, "S2364C9", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2364C9C1Ev();
extern void _ZN7S2364C9D1Ev();
Name_Map name_map_S2364C9[] = {
  NSPAIR(_ZN7S2364C9C1Ev),
  NSPAIR(_ZN7S2364C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2364C10;
extern VTBL_ENTRY _ZTI8S2364C10[];
extern  VTBL_ENTRY _ZTV8S2364C10[];
static Base_Class bases_S2364C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2364C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2364C9[];
extern void _ZN7S2364C9D1Ev();
extern void _ZN7S2364C9D0Ev();
extern void _ZN8S2364C103v21Ev();
extern void _ZN8S2364C103v22Ev();
extern void _ZN8S2364C103v23Ev();
extern void _ZN7S2364C93v24Ev();
extern void _ZN7S2364C93v25Ev();
extern void _ZN7S2364C93v26Ev();
static  VTBL_ENTRY vtc_S2364C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2364C9[0]),
  (VTBL_ENTRY)&_ZN7S2364C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2364C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v26Ev,
};
extern VTBL_ENTRY _ZTI7S2364C9[];
extern  VTBL_ENTRY _ZTV7S2364C9[];
Class_Descriptor cd_S2364C9 = {  "S2364C9", // class name
  bases_S2364C9, 1,
  &(vtc_S2364C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2364C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2364C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2364C8  : S2364C9 {
  virtual  ~S2364C8(); // _ZN7S2364C8D1Ev
  virtual void  v27(); // _ZN7S2364C83v27Ev
  virtual void  v28(); // _ZN7S2364C83v28Ev
  virtual void  v29(); // _ZN7S2364C83v29Ev
  virtual void  v30(); // _ZN7S2364C83v30Ev
  S2364C8(); // tgen
};
//SIG(-1 S2364C8) C1{ BC2{ BC3{ vd v5 v6 v7} vd v8 v9 v10 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FL[4]} Fc} vd v1 v2 v3 v4}


 S2364C8 ::~S2364C8(){ note_dtor("S2364C8", this);}
void  S2364C8 ::v27(){vfunc_called(this, "_ZN7S2364C83v27Ev");}
void  S2364C8 ::v28(){vfunc_called(this, "_ZN7S2364C83v28Ev");}
void  S2364C8 ::v29(){vfunc_called(this, "_ZN7S2364C83v29Ev");}
void  S2364C8 ::v30(){vfunc_called(this, "_ZN7S2364C83v30Ev");}
S2364C8 ::S2364C8(){ note_ctor("S2364C8", this);} // tgen

static void Test_S2364C8()
{
  extern Class_Descriptor cd_S2364C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2364C8, buf);
    S2364C8 *dp, &lv = *(dp=new (buf) S2364C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2364C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2364C8)");
    check_base_class_offset(lv, (S2364C10*)(S2364C9*), 0, "S2364C8");
    check_base_class_offset(lv, (S2364C9*), 0, "S2364C8");
    test_class_info(&lv, &cd_S2364C8);
    dp->~S2364C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2364C8(Test_S2364C8, "S2364C8", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2364C8C1Ev();
extern void _ZN7S2364C8D1Ev();
Name_Map name_map_S2364C8[] = {
  NSPAIR(_ZN7S2364C8C1Ev),
  NSPAIR(_ZN7S2364C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2364C10;
extern VTBL_ENTRY _ZTI8S2364C10[];
extern  VTBL_ENTRY _ZTV8S2364C10[];
extern Class_Descriptor cd_S2364C9;
extern VTBL_ENTRY _ZTI7S2364C9[];
extern  VTBL_ENTRY _ZTV7S2364C9[];
static Base_Class bases_S2364C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2364C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2364C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2364C8[];
extern void _ZN7S2364C8D1Ev();
extern void _ZN7S2364C8D0Ev();
extern void _ZN8S2364C103v21Ev();
extern void _ZN8S2364C103v22Ev();
extern void _ZN8S2364C103v23Ev();
extern void _ZN7S2364C93v24Ev();
extern void _ZN7S2364C93v25Ev();
extern void _ZN7S2364C93v26Ev();
extern void _ZN7S2364C83v27Ev();
extern void _ZN7S2364C83v28Ev();
extern void _ZN7S2364C83v29Ev();
extern void _ZN7S2364C83v30Ev();
static  VTBL_ENTRY vtc_S2364C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2364C8[0]),
  (VTBL_ENTRY)&_ZN7S2364C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2364C8D0Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2364C8[];
extern  VTBL_ENTRY _ZTV7S2364C8[];
Class_Descriptor cd_S2364C8 = {  "S2364C8", // class name
  bases_S2364C8, 2,
  &(vtc_S2364C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2364C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2364C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2364C2  : S2364C3 , S2364C8 {
  int s2364c2f0[3];
  char s2364c2f1;
  ::S10183C9_nt s2364c2f2;
  virtual  ~S2364C2(); // _ZN7S2364C2D1Ev
  virtual void  v31(); // _ZN7S2364C23v31Ev
  virtual void  v32(); // _ZN7S2364C23v32Ev
  virtual void  v33(); // _ZN7S2364C23v33Ev
  virtual void  v34(); // _ZN7S2364C23v34Ev
  virtual void  v35(); // _ZN7S2364C23v35Ev
  virtual void  v36(); // _ZN7S2364C23v36Ev
  S2364C2(); // tgen
};
//SIG(-1 S2364C2) C1{ BC2{ BC3{ vd v7 v8 v9 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} BC6{ vd v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fc Fi} BC7{ BC8{ BC9{ vd v23 v24 v25} vd v26 v27 v28 FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FL[4]} Fc} vd v29 v30 v31 v32} vd v1 v2 v3 v4 v5 v6 Fi[3] Fc FC13{ BC14{ m Fp Fi FC15{ m} FC5}}}


 S2364C2 ::~S2364C2(){ note_dtor("S2364C2", this);}
void  S2364C2 ::v31(){vfunc_called(this, "_ZN7S2364C23v31Ev");}
void  S2364C2 ::v32(){vfunc_called(this, "_ZN7S2364C23v32Ev");}
void  S2364C2 ::v33(){vfunc_called(this, "_ZN7S2364C23v33Ev");}
void  S2364C2 ::v34(){vfunc_called(this, "_ZN7S2364C23v34Ev");}
void  S2364C2 ::v35(){vfunc_called(this, "_ZN7S2364C23v35Ev");}
void  S2364C2 ::v36(){vfunc_called(this, "_ZN7S2364C23v36Ev");}
S2364C2 ::S2364C2(){ note_ctor("S2364C2", this);} // tgen

static void Test_S2364C2()
{
  extern Class_Descriptor cd_S2364C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,33)];
    init_test(&cd_S2364C2, buf);
    S2364C2 *dp, &lv = *(dp=new (buf) S2364C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,128), "sizeof(S2364C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2364C2)");
    check_base_class_offset(lv, (S2364C4*)(S2364C3*), 0, "S2364C2");
    check_base_class_offset(lv, (S2364C7*)(S2364C3*), ABISELECT(40,28), "S2364C2");
    check_base_class_offset(lv, (S2364C3*), 0, "S2364C2");
    check_base_class_offset(lv, (S2364C10*)(S2364C9*)(S2364C8*), ABISELECT(64,44), "S2364C2");
    check_base_class_offset(lv, (S2364C9*)(S2364C8*), ABISELECT(64,44), "S2364C2");
    check_base_class_offset(lv, (S2364C8*), ABISELECT(64,44), "S2364C2");
    check_field_offset(lv, s2364c2f0, ABISELECT(132,100), "S2364C2.s2364c2f0");
    check_field_offset(lv, s2364c2f1, ABISELECT(144,112), "S2364C2.s2364c2f1");
    check_field_offset(lv, s2364c2f2, ABISELECT(152,116), "S2364C2.s2364c2f2");
    test_class_info(&lv, &cd_S2364C2);
    dp->~S2364C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2364C2(Test_S2364C2, "S2364C2", ABISELECT(168,128));

#else // __cplusplus

extern void _ZN7S2364C2C1Ev();
extern void _ZN7S2364C2D1Ev();
Name_Map name_map_S2364C2[] = {
  NSPAIR(_ZN7S2364C2C1Ev),
  NSPAIR(_ZN7S2364C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2364C4;
extern VTBL_ENTRY _ZTI7S2364C4[];
extern  VTBL_ENTRY _ZTV7S2364C4[];
extern Class_Descriptor cd_S2364C7;
extern VTBL_ENTRY _ZTI7S2364C7[];
extern  VTBL_ENTRY _ZTV7S2364C7[];
extern Class_Descriptor cd_S2364C3;
extern VTBL_ENTRY _ZTI7S2364C3[];
extern  VTBL_ENTRY _ZTV7S2364C3[];
extern Class_Descriptor cd_S2364C10;
extern VTBL_ENTRY _ZTI8S2364C10[];
extern  VTBL_ENTRY _ZTV8S2364C10[];
extern Class_Descriptor cd_S2364C9;
extern VTBL_ENTRY _ZTI7S2364C9[];
extern  VTBL_ENTRY _ZTV7S2364C9[];
extern Class_Descriptor cd_S2364C8;
extern VTBL_ENTRY _ZTI7S2364C8[];
extern  VTBL_ENTRY _ZTV7S2364C8[];
static Base_Class bases_S2364C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2364C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2364C7,    ABISELECT(40,28), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2364C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2364C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2364C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2364C8,    ABISELECT(64,44), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2364C2[];
extern void _ZN7S2364C2D1Ev();
extern void _ZN7S2364C2D0Ev();
extern void _ZN7S2364C42v5Ev();
extern void _ZN7S2364C42v6Ev();
extern void _ZN7S2364C42v7Ev();
extern void _ZN7S2364C33v11Ev();
extern void _ZN7S2364C33v12Ev();
extern void _ZN7S2364C33v13Ev();
extern void _ZN7S2364C33v14Ev();
extern void _ZN7S2364C33v15Ev();
extern void _ZN7S2364C33v16Ev();
extern void _ZN7S2364C33v17Ev();
extern void _ZN7S2364C33v18Ev();
extern void _ZN7S2364C33v19Ev();
extern void _ZN7S2364C33v20Ev();
extern void _ZN7S2364C23v31Ev();
extern void _ZN7S2364C23v32Ev();
extern void _ZN7S2364C23v33Ev();
extern void _ZN7S2364C23v34Ev();
extern void _ZN7S2364C23v35Ev();
extern void _ZN7S2364C23v36Ev();
extern void ABISELECT(_ZThn40_N7S2364C2D1Ev,_ZThn28_N7S2364C2D1Ev)();
extern void ABISELECT(_ZThn40_N7S2364C2D0Ev,_ZThn28_N7S2364C2D0Ev)();
extern void _ZN7S2364C72v8Ev();
extern void _ZN7S2364C72v9Ev();
extern void _ZN7S2364C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2364C2D1Ev,_ZThn44_N7S2364C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S2364C2D0Ev,_ZThn44_N7S2364C2D0Ev)();
extern void _ZN8S2364C103v21Ev();
extern void _ZN8S2364C103v22Ev();
extern void _ZN8S2364C103v23Ev();
extern void _ZN7S2364C93v24Ev();
extern void _ZN7S2364C93v25Ev();
extern void _ZN7S2364C93v26Ev();
extern void _ZN7S2364C83v27Ev();
extern void _ZN7S2364C83v28Ev();
extern void _ZN7S2364C83v29Ev();
extern void _ZN7S2364C83v30Ev();
static  VTBL_ENTRY vtc_S2364C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2364C2[0]),
  (VTBL_ENTRY)&_ZN7S2364C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2364C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v36Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2364C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2364C2D1Ev,_ZThn28_N7S2364C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2364C2D0Ev,_ZThn28_N7S2364C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2364C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2364C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2364C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2364C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2364C2D1Ev,_ZThn44_N7S2364C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2364C2D0Ev,_ZThn44_N7S2364C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2364C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2364C2[];
extern  VTBL_ENTRY _ZTV7S2364C2[];
Class_Descriptor cd_S2364C2 = {  "S2364C2", // class name
  bases_S2364C2, 6,
  &(vtc_S2364C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,128), // object size
  NSPAIRA(_ZTI7S2364C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2364C2),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2364C1  : S2364C2 {
  ::S2348C19 s2364c1f0;
  ::S2348C20_nt s2364c1f1;
  ::S10183C17 s2364c1f2;
  int s2364c1f3;
  ::S10183C15_nt s2364c1f4;
  ::S10183C10_nt s2364c1f5;
  virtual  ~S2364C1(); // _ZN7S2364C1D1Ev
  virtual void  v1(); // _ZN7S2364C12v1Ev
  virtual void  v2(); // _ZN7S2364C12v2Ev
  virtual void  v3(); // _ZN7S2364C12v3Ev
  virtual void  v4(); // _ZN7S2364C12v4Ev
  S2364C1(); // tgen
};
//SIG(1 S2364C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} BC7{ vd v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp Fc Fi} BC8{ BC9{ BC10{ vd v21 v22 v23} vd v24 v25 v26 FC11{ m Fp Fi[2] FC12{ m}} FC13{ m FL[4]} Fc} vd v27 v28 v29 v30} vd v31 v32 v33 v34 v35 v36 Fi[3] Fc FC14{ BC15{ m Fp Fi FC16{ m} FC6}}} vd v1 v2 v3 v4 FC17{ vd v37 v38 v39 v40 v41 v42 v43 Fp Fc} FC18{ BC19{ vd v45 FC20{ m FC15} Fp[3] Fc} v44 Fp} FC21{ BC22{ vd v48 v49} vd v46 v47 FC23{ BC22 vd v50 v51 FC5} FC24{ BC22 vd v52 v53 FC5 FC5 Fi} FC25{ BC11 BC22 vd v54 v55} FC26{ vd m FC27{ m Fs[6] Fi[2] Fc Fs}} FC5 FC5 Fc[2] Fi FC5 FC5 FC5 FC5 FC5 Fi[3] Fp FC5 FC26 FC5 Fi} Fi FC5 FC15}


 S2364C1 ::~S2364C1(){ note_dtor("S2364C1", this);}
void  S2364C1 ::v1(){vfunc_called(this, "_ZN7S2364C12v1Ev");}
void  S2364C1 ::v2(){vfunc_called(this, "_ZN7S2364C12v2Ev");}
void  S2364C1 ::v3(){vfunc_called(this, "_ZN7S2364C12v3Ev");}
void  S2364C1 ::v4(){vfunc_called(this, "_ZN7S2364C12v4Ev");}
S2364C1 ::S2364C1(){ note_ctor("S2364C1", this);} // tgen

static void Test_S2364C1()
{
  extern Class_Descriptor cd_S2364C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(83,118)];
    init_test(&cd_S2364C1, buf);
    S2364C1 *dp, &lv = *(dp=new (buf) S2364C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(656,468), "sizeof(S2364C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2364C1)");
    check_base_class_offset(lv, (S2364C4*)(S2364C3*)(S2364C2*), 0, "S2364C1");
    check_base_class_offset(lv, (S2364C7*)(S2364C3*)(S2364C2*), ABISELECT(40,28), "S2364C1");
    check_base_class_offset(lv, (S2364C3*)(S2364C2*), 0, "S2364C1");
    check_base_class_offset(lv, (S2364C10*)(S2364C9*)(S2364C8*)(S2364C2*), ABISELECT(64,44), "S2364C1");
    check_base_class_offset(lv, (S2364C9*)(S2364C8*)(S2364C2*), ABISELECT(64,44), "S2364C1");
    check_base_class_offset(lv, (S2364C8*)(S2364C2*), ABISELECT(64,44), "S2364C1");
    check_base_class_offset(lv, (S2364C2*), 0, "S2364C1");
    check_field_offset(lv, s2364c1f0, ABISELECT(168,128), "S2364C1.s2364c1f0");
    check_field_offset(lv, s2364c1f1, ABISELECT(192,140), "S2364C1.s2364c1f1");
    check_field_offset(lv, s2364c1f2, ABISELECT(256,176), "S2364C1.s2364c1f2");
    check_field_offset(lv, s2364c1f3, ABISELECT(616,440), "S2364C1.s2364c1f3");
    check_field_offset(lv, s2364c1f4, ABISELECT(624,444), "S2364C1.s2364c1f4");
    check_field_offset(lv, s2364c1f5, ABISELECT(640,456), "S2364C1.s2364c1f5");
    test_class_info(&lv, &cd_S2364C1);
    dp->~S2364C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2364C1(Test_S2364C1, "S2364C1", ABISELECT(656,468));

#else // __cplusplus

extern void _ZN7S2364C1C1Ev();
extern void _ZN7S2364C1D1Ev();
Name_Map name_map_S2364C1[] = {
  NSPAIR(_ZN7S2364C1C1Ev),
  NSPAIR(_ZN7S2364C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2364C4;
extern VTBL_ENTRY _ZTI7S2364C4[];
extern  VTBL_ENTRY _ZTV7S2364C4[];
extern Class_Descriptor cd_S2364C7;
extern VTBL_ENTRY _ZTI7S2364C7[];
extern  VTBL_ENTRY _ZTV7S2364C7[];
extern Class_Descriptor cd_S2364C3;
extern VTBL_ENTRY _ZTI7S2364C3[];
extern  VTBL_ENTRY _ZTV7S2364C3[];
extern Class_Descriptor cd_S2364C10;
extern VTBL_ENTRY _ZTI8S2364C10[];
extern  VTBL_ENTRY _ZTV8S2364C10[];
extern Class_Descriptor cd_S2364C9;
extern VTBL_ENTRY _ZTI7S2364C9[];
extern  VTBL_ENTRY _ZTV7S2364C9[];
extern Class_Descriptor cd_S2364C8;
extern VTBL_ENTRY _ZTI7S2364C8[];
extern  VTBL_ENTRY _ZTV7S2364C8[];
extern Class_Descriptor cd_S2364C2;
extern VTBL_ENTRY _ZTI7S2364C2[];
extern  VTBL_ENTRY _ZTV7S2364C2[];
static Base_Class bases_S2364C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2364C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2364C7,    ABISELECT(40,28), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2364C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2364C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2364C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2364C8,    ABISELECT(64,44), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2364C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2364C1[];
extern void _ZN7S2364C1D1Ev();
extern void _ZN7S2364C1D0Ev();
extern void _ZN7S2364C42v5Ev();
extern void _ZN7S2364C42v6Ev();
extern void _ZN7S2364C42v7Ev();
extern void _ZN7S2364C33v11Ev();
extern void _ZN7S2364C33v12Ev();
extern void _ZN7S2364C33v13Ev();
extern void _ZN7S2364C33v14Ev();
extern void _ZN7S2364C33v15Ev();
extern void _ZN7S2364C33v16Ev();
extern void _ZN7S2364C33v17Ev();
extern void _ZN7S2364C33v18Ev();
extern void _ZN7S2364C33v19Ev();
extern void _ZN7S2364C33v20Ev();
extern void _ZN7S2364C23v31Ev();
extern void _ZN7S2364C23v32Ev();
extern void _ZN7S2364C23v33Ev();
extern void _ZN7S2364C23v34Ev();
extern void _ZN7S2364C23v35Ev();
extern void _ZN7S2364C23v36Ev();
extern void _ZN7S2364C12v1Ev();
extern void _ZN7S2364C12v2Ev();
extern void _ZN7S2364C12v3Ev();
extern void _ZN7S2364C12v4Ev();
extern void ABISELECT(_ZThn40_N7S2364C1D1Ev,_ZThn28_N7S2364C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S2364C1D0Ev,_ZThn28_N7S2364C1D0Ev)();
extern void _ZN7S2364C72v8Ev();
extern void _ZN7S2364C72v9Ev();
extern void _ZN7S2364C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2364C1D1Ev,_ZThn44_N7S2364C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S2364C1D0Ev,_ZThn44_N7S2364C1D0Ev)();
extern void _ZN8S2364C103v21Ev();
extern void _ZN8S2364C103v22Ev();
extern void _ZN8S2364C103v23Ev();
extern void _ZN7S2364C93v24Ev();
extern void _ZN7S2364C93v25Ev();
extern void _ZN7S2364C93v26Ev();
extern void _ZN7S2364C83v27Ev();
extern void _ZN7S2364C83v28Ev();
extern void _ZN7S2364C83v29Ev();
extern void _ZN7S2364C83v30Ev();
static  VTBL_ENTRY vtc_S2364C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2364C1[0]),
  (VTBL_ENTRY)&_ZN7S2364C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2364C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2364C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2364C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2364C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2364C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2364C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2364C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2364C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2364C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2364C1D1Ev,_ZThn28_N7S2364C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2364C1D0Ev,_ZThn28_N7S2364C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2364C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2364C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2364C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2364C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2364C1D1Ev,_ZThn44_N7S2364C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2364C1D0Ev,_ZThn44_N7S2364C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2364C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2364C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2364C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2364C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2364C1[];
extern  VTBL_ENTRY _ZTV7S2364C1[];
Class_Descriptor cd_S2364C1 = {  "S2364C1", // class name
  bases_S2364C1, 7,
  &(vtc_S2364C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(656,468), // object size
  NSPAIRA(_ZTI7S2364C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2364C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2041C4  {
  virtual  ~S2041C4(); // _ZN7S2041C4D1Ev
  virtual void  v16(); // _ZN7S2041C43v16Ev
  virtual void  v17(); // _ZN7S2041C43v17Ev
  virtual void  v18(); // _ZN7S2041C43v18Ev
  S2041C4(); // tgen
};
//SIG(-1 S2041C4) C1{ vd v1 v2 v3}


 S2041C4 ::~S2041C4(){ note_dtor("S2041C4", this);}
void  S2041C4 ::v16(){vfunc_called(this, "_ZN7S2041C43v16Ev");}
void  S2041C4 ::v17(){vfunc_called(this, "_ZN7S2041C43v17Ev");}
void  S2041C4 ::v18(){vfunc_called(this, "_ZN7S2041C43v18Ev");}
S2041C4 ::S2041C4(){ note_ctor("S2041C4", this);} // tgen

static void Test_S2041C4()
{
  extern Class_Descriptor cd_S2041C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2041C4, buf);
    S2041C4 *dp, &lv = *(dp=new (buf) S2041C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2041C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2041C4)");
    test_class_info(&lv, &cd_S2041C4);
    dp->~S2041C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2041C4(Test_S2041C4, "S2041C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2041C4C1Ev();
extern void _ZN7S2041C4D1Ev();
Name_Map name_map_S2041C4[] = {
  NSPAIR(_ZN7S2041C4C1Ev),
  NSPAIR(_ZN7S2041C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2041C4[];
extern void _ZN7S2041C4D1Ev();
extern void _ZN7S2041C4D0Ev();
extern void _ZN7S2041C43v16Ev();
extern void _ZN7S2041C43v17Ev();
extern void _ZN7S2041C43v18Ev();
static  VTBL_ENTRY vtc_S2041C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2041C4[0]),
  (VTBL_ENTRY)&_ZN7S2041C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2041C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v18Ev,
};
extern VTBL_ENTRY _ZTI7S2041C4[];
extern  VTBL_ENTRY _ZTV7S2041C4[];
Class_Descriptor cd_S2041C4 = {  "S2041C4", // class name
  0,0,//no base classes
  &(vtc_S2041C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2041C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2041C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2041C3  : S2041C4 {
  virtual  ~S2041C3(); // _ZN7S2041C3D1Ev
  virtual void  v19(); // _ZN7S2041C33v19Ev
  virtual void  v20(); // _ZN7S2041C33v20Ev
  virtual void  v21(); // _ZN7S2041C33v21Ev
  S2041C3(); // tgen
};
//SIG(-1 S2041C3) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3}


 S2041C3 ::~S2041C3(){ note_dtor("S2041C3", this);}
void  S2041C3 ::v19(){vfunc_called(this, "_ZN7S2041C33v19Ev");}
void  S2041C3 ::v20(){vfunc_called(this, "_ZN7S2041C33v20Ev");}
void  S2041C3 ::v21(){vfunc_called(this, "_ZN7S2041C33v21Ev");}
S2041C3 ::S2041C3(){ note_ctor("S2041C3", this);} // tgen

static void Test_S2041C3()
{
  extern Class_Descriptor cd_S2041C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2041C3, buf);
    S2041C3 *dp, &lv = *(dp=new (buf) S2041C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2041C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2041C3)");
    check_base_class_offset(lv, (S2041C4*), 0, "S2041C3");
    test_class_info(&lv, &cd_S2041C3);
    dp->~S2041C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2041C3(Test_S2041C3, "S2041C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2041C3C1Ev();
extern void _ZN7S2041C3D1Ev();
Name_Map name_map_S2041C3[] = {
  NSPAIR(_ZN7S2041C3C1Ev),
  NSPAIR(_ZN7S2041C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2041C4;
extern VTBL_ENTRY _ZTI7S2041C4[];
extern  VTBL_ENTRY _ZTV7S2041C4[];
static Base_Class bases_S2041C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2041C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2041C3[];
extern void _ZN7S2041C3D1Ev();
extern void _ZN7S2041C3D0Ev();
extern void _ZN7S2041C43v16Ev();
extern void _ZN7S2041C43v17Ev();
extern void _ZN7S2041C43v18Ev();
extern void _ZN7S2041C33v19Ev();
extern void _ZN7S2041C33v20Ev();
extern void _ZN7S2041C33v21Ev();
static  VTBL_ENTRY vtc_S2041C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2041C3[0]),
  (VTBL_ENTRY)&_ZN7S2041C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2041C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2041C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2041C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2041C33v21Ev,
};
extern VTBL_ENTRY _ZTI7S2041C3[];
extern  VTBL_ENTRY _ZTV7S2041C3[];
Class_Descriptor cd_S2041C3 = {  "S2041C3", // class name
  bases_S2041C3, 1,
  &(vtc_S2041C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2041C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2041C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2041C2  : S2041C3 {
  ::S10183C20 s2041c2f0;
  ::S10183C7_nt s2041c2f1;
  char s2041c2f2;
  virtual  ~S2041C2(); // _ZN7S2041C2D1Ev
  virtual void  v22(); // _ZN7S2041C23v22Ev
  virtual void  v23(); // _ZN7S2041C23v23Ev
  virtual void  v24(); // _ZN7S2041C23v24Ev
  S2041C2(); // tgen
};
//SIG(-1 S2041C2) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc}


 S2041C2 ::~S2041C2(){ note_dtor("S2041C2", this);}
void  S2041C2 ::v22(){vfunc_called(this, "_ZN7S2041C23v22Ev");}
void  S2041C2 ::v23(){vfunc_called(this, "_ZN7S2041C23v23Ev");}
void  S2041C2 ::v24(){vfunc_called(this, "_ZN7S2041C23v24Ev");}
S2041C2 ::S2041C2(){ note_ctor("S2041C2", this);} // tgen

static void Test_S2041C2()
{
  extern Class_Descriptor cd_S2041C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2041C2, buf);
    S2041C2 *dp, &lv = *(dp=new (buf) S2041C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2041C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2041C2)");
    check_base_class_offset(lv, (S2041C4*)(S2041C3*), 0, "S2041C2");
    check_base_class_offset(lv, (S2041C3*), 0, "S2041C2");
    check_field_offset(lv, s2041c2f0, ABISELECT(8,4), "S2041C2.s2041c2f0");
    check_field_offset(lv, s2041c2f1, ABISELECT(32,20), "S2041C2.s2041c2f1");
    check_field_offset(lv, s2041c2f2, ABISELECT(64,36), "S2041C2.s2041c2f2");
    test_class_info(&lv, &cd_S2041C2);
    dp->~S2041C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2041C2(Test_S2041C2, "S2041C2", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2041C2C1Ev();
extern void _ZN7S2041C2D1Ev();
Name_Map name_map_S2041C2[] = {
  NSPAIR(_ZN7S2041C2C1Ev),
  NSPAIR(_ZN7S2041C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2041C4;
extern VTBL_ENTRY _ZTI7S2041C4[];
extern  VTBL_ENTRY _ZTV7S2041C4[];
extern Class_Descriptor cd_S2041C3;
extern VTBL_ENTRY _ZTI7S2041C3[];
extern  VTBL_ENTRY _ZTV7S2041C3[];
static Base_Class bases_S2041C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2041C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2041C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2041C2[];
extern void _ZN7S2041C2D1Ev();
extern void _ZN7S2041C2D0Ev();
extern void _ZN7S2041C43v16Ev();
extern void _ZN7S2041C43v17Ev();
extern void _ZN7S2041C43v18Ev();
extern void _ZN7S2041C33v19Ev();
extern void _ZN7S2041C33v20Ev();
extern void _ZN7S2041C33v21Ev();
extern void _ZN7S2041C23v22Ev();
extern void _ZN7S2041C23v23Ev();
extern void _ZN7S2041C23v24Ev();
static  VTBL_ENTRY vtc_S2041C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2041C2[0]),
  (VTBL_ENTRY)&_ZN7S2041C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2041C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2041C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2041C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2041C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2041C23v22Ev,
  (VTBL_ENTRY)&_ZN7S2041C23v23Ev,
  (VTBL_ENTRY)&_ZN7S2041C23v24Ev,
};
extern VTBL_ENTRY _ZTI7S2041C2[];
extern  VTBL_ENTRY _ZTV7S2041C2[];
Class_Descriptor cd_S2041C2 = {  "S2041C2", // class name
  bases_S2041C2, 2,
  &(vtc_S2041C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2041C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2041C2),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2041C10  {
  void *s2041c10f0[2];
  virtual  ~S2041C10(); // _ZN8S2041C10D1Ev
  virtual void  v25(); // _ZN8S2041C103v25Ev
  virtual void  v26(); // _ZN8S2041C103v26Ev
  virtual void  v27(); // _ZN8S2041C103v27Ev
  virtual void  v28(); // _ZN8S2041C103v28Ev
  virtual void  v29(); // _ZN8S2041C103v29Ev
  virtual void  v30(); // _ZN8S2041C103v30Ev
  virtual void  v31(); // _ZN8S2041C103v31Ev
  virtual void  v32(); // _ZN8S2041C103v32Ev
  virtual void  v33(); // _ZN8S2041C103v33Ev
  virtual void  v34(); // _ZN8S2041C103v34Ev
  virtual void  v35(); // _ZN8S2041C103v35Ev
  virtual void  v36(); // _ZN8S2041C103v36Ev
  virtual void  v37(); // _ZN8S2041C103v37Ev
  virtual void  v38(); // _ZN8S2041C103v38Ev
  S2041C10(); // tgen
};
//SIG(-1 S2041C10) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2]}


 S2041C10 ::~S2041C10(){ note_dtor("S2041C10", this);}
void  S2041C10 ::v25(){vfunc_called(this, "_ZN8S2041C103v25Ev");}
void  S2041C10 ::v26(){vfunc_called(this, "_ZN8S2041C103v26Ev");}
void  S2041C10 ::v27(){vfunc_called(this, "_ZN8S2041C103v27Ev");}
void  S2041C10 ::v28(){vfunc_called(this, "_ZN8S2041C103v28Ev");}
void  S2041C10 ::v29(){vfunc_called(this, "_ZN8S2041C103v29Ev");}
void  S2041C10 ::v30(){vfunc_called(this, "_ZN8S2041C103v30Ev");}
void  S2041C10 ::v31(){vfunc_called(this, "_ZN8S2041C103v31Ev");}
void  S2041C10 ::v32(){vfunc_called(this, "_ZN8S2041C103v32Ev");}
void  S2041C10 ::v33(){vfunc_called(this, "_ZN8S2041C103v33Ev");}
void  S2041C10 ::v34(){vfunc_called(this, "_ZN8S2041C103v34Ev");}
void  S2041C10 ::v35(){vfunc_called(this, "_ZN8S2041C103v35Ev");}
void  S2041C10 ::v36(){vfunc_called(this, "_ZN8S2041C103v36Ev");}
void  S2041C10 ::v37(){vfunc_called(this, "_ZN8S2041C103v37Ev");}
void  S2041C10 ::v38(){vfunc_called(this, "_ZN8S2041C103v38Ev");}
S2041C10 ::S2041C10(){ note_ctor("S2041C10", this);} // tgen

static void Test_S2041C10()
{
  extern Class_Descriptor cd_S2041C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S2041C10, buf);
    S2041C10 *dp, &lv = *(dp=new (buf) S2041C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S2041C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2041C10)");
    check_field_offset(lv, s2041c10f0, ABISELECT(8,4), "S2041C10.s2041c10f0");
    test_class_info(&lv, &cd_S2041C10);
    dp->~S2041C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2041C10(Test_S2041C10, "S2041C10", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S2041C10C1Ev();
extern void _ZN8S2041C10D1Ev();
Name_Map name_map_S2041C10[] = {
  NSPAIR(_ZN8S2041C10C1Ev),
  NSPAIR(_ZN8S2041C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2041C10[];
extern void _ZN8S2041C10D1Ev();
extern void _ZN8S2041C10D0Ev();
extern void _ZN8S2041C103v25Ev();
extern void _ZN8S2041C103v26Ev();
extern void _ZN8S2041C103v27Ev();
extern void _ZN8S2041C103v28Ev();
extern void _ZN8S2041C103v29Ev();
extern void _ZN8S2041C103v30Ev();
extern void _ZN8S2041C103v31Ev();
extern void _ZN8S2041C103v32Ev();
extern void _ZN8S2041C103v33Ev();
extern void _ZN8S2041C103v34Ev();
extern void _ZN8S2041C103v35Ev();
extern void _ZN8S2041C103v36Ev();
extern void _ZN8S2041C103v37Ev();
extern void _ZN8S2041C103v38Ev();
static  VTBL_ENTRY vtc_S2041C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2041C10[0]),
  (VTBL_ENTRY)&_ZN8S2041C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2041C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v33Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v34Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v35Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v36Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v37Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v38Ev,
};
extern VTBL_ENTRY _ZTI8S2041C10[];
extern  VTBL_ENTRY _ZTV8S2041C10[];
Class_Descriptor cd_S2041C10 = {  "S2041C10", // class name
  0,0,//no base classes
  &(vtc_S2041C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S2041C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2041C10),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2041C9  : S2041C10 {
  ::S10183C5_nt s2041c9f0;
  virtual  ~S2041C9(); // _ZN7S2041C9D1Ev
  virtual void  v39(); // _ZN7S2041C93v39Ev
  virtual void  v40(); // _ZN7S2041C93v40Ev
  virtual void  v41(); // _ZN7S2041C93v41Ev
  virtual void  v42(); // _ZN7S2041C93v42Ev
  virtual void  v43(); // _ZN7S2041C93v43Ev
  virtual void  v44(); // _ZN7S2041C93v44Ev
  virtual void  v45(); // _ZN7S2041C93v45Ev
  S2041C9(); // tgen
};
//SIG(-1 S2041C9) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m Fp Fi[2] FC4{ m}}}


 S2041C9 ::~S2041C9(){ note_dtor("S2041C9", this);}
void  S2041C9 ::v39(){vfunc_called(this, "_ZN7S2041C93v39Ev");}
void  S2041C9 ::v40(){vfunc_called(this, "_ZN7S2041C93v40Ev");}
void  S2041C9 ::v41(){vfunc_called(this, "_ZN7S2041C93v41Ev");}
void  S2041C9 ::v42(){vfunc_called(this, "_ZN7S2041C93v42Ev");}
void  S2041C9 ::v43(){vfunc_called(this, "_ZN7S2041C93v43Ev");}
void  S2041C9 ::v44(){vfunc_called(this, "_ZN7S2041C93v44Ev");}
void  S2041C9 ::v45(){vfunc_called(this, "_ZN7S2041C93v45Ev");}
S2041C9 ::S2041C9(){ note_ctor("S2041C9", this);} // tgen

static void Test_S2041C9()
{
  extern Class_Descriptor cd_S2041C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_S2041C9, buf);
    S2041C9 *dp, &lv = *(dp=new (buf) S2041C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S2041C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2041C9)");
    check_base_class_offset(lv, (S2041C10*), 0, "S2041C9");
    check_field_offset(lv, s2041c9f0, ABISELECT(24,12), "S2041C9.s2041c9f0");
    test_class_info(&lv, &cd_S2041C9);
    dp->~S2041C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2041C9(Test_S2041C9, "S2041C9", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN7S2041C9C1Ev();
extern void _ZN7S2041C9D1Ev();
Name_Map name_map_S2041C9[] = {
  NSPAIR(_ZN7S2041C9C1Ev),
  NSPAIR(_ZN7S2041C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2041C10;
extern VTBL_ENTRY _ZTI8S2041C10[];
extern  VTBL_ENTRY _ZTV8S2041C10[];
static Base_Class bases_S2041C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2041C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2041C9[];
extern void _ZN7S2041C9D1Ev();
extern void _ZN7S2041C9D0Ev();
extern void _ZN8S2041C103v25Ev();
extern void _ZN8S2041C103v26Ev();
extern void _ZN8S2041C103v27Ev();
extern void _ZN8S2041C103v28Ev();
extern void _ZN8S2041C103v29Ev();
extern void _ZN8S2041C103v30Ev();
extern void _ZN8S2041C103v31Ev();
extern void _ZN8S2041C103v32Ev();
extern void _ZN8S2041C103v33Ev();
extern void _ZN8S2041C103v34Ev();
extern void _ZN8S2041C103v35Ev();
extern void _ZN8S2041C103v36Ev();
extern void _ZN8S2041C103v37Ev();
extern void _ZN8S2041C103v38Ev();
extern void _ZN7S2041C93v39Ev();
extern void _ZN7S2041C93v40Ev();
extern void _ZN7S2041C93v41Ev();
extern void _ZN7S2041C93v42Ev();
extern void _ZN7S2041C93v43Ev();
extern void _ZN7S2041C93v44Ev();
extern void _ZN7S2041C93v45Ev();
static  VTBL_ENTRY vtc_S2041C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2041C9[0]),
  (VTBL_ENTRY)&_ZN7S2041C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2041C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v33Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v34Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v35Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v36Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v37Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v38Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v39Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v40Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v41Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v42Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v43Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v44Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v45Ev,
};
extern VTBL_ENTRY _ZTI7S2041C9[];
extern  VTBL_ENTRY _ZTV7S2041C9[];
Class_Descriptor cd_S2041C9 = {  "S2041C9", // class name
  bases_S2041C9, 1,
  &(vtc_S2041C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI7S2041C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2041C9),25, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2041C14  {
  virtual  ~S2041C14(); // _ZN8S2041C14D1Ev
  S2041C14(); // tgen
};
//SIG(-1 S2041C14) C1{ vd}


 S2041C14 ::~S2041C14(){ note_dtor("S2041C14", this);}
S2041C14 ::S2041C14(){ note_ctor("S2041C14", this);} // tgen

static void Test_S2041C14()
{
  extern Class_Descriptor cd_S2041C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2041C14, buf);
    S2041C14 *dp, &lv = *(dp=new (buf) S2041C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2041C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2041C14)");
    test_class_info(&lv, &cd_S2041C14);
    dp->~S2041C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2041C14(Test_S2041C14, "S2041C14", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2041C14C1Ev();
extern void _ZN8S2041C14D1Ev();
Name_Map name_map_S2041C14[] = {
  NSPAIR(_ZN8S2041C14C1Ev),
  NSPAIR(_ZN8S2041C14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2041C14[];
extern void _ZN8S2041C14D1Ev();
extern void _ZN8S2041C14D0Ev();
static  VTBL_ENTRY vtc_S2041C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2041C14[0]),
  (VTBL_ENTRY)&_ZN8S2041C14D1Ev,
  (VTBL_ENTRY)&_ZN8S2041C14D0Ev,
};
extern VTBL_ENTRY _ZTI8S2041C14[];
extern  VTBL_ENTRY _ZTV8S2041C14[];
Class_Descriptor cd_S2041C14 = {  "S2041C14", // class name
  0,0,//no base classes
  &(vtc_S2041C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2041C14),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2041C14),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2041C13  : S2041C14 {
  int s2041c13f0;
  ::S10183C13 s2041c13f1;
  ::S10183C17 s2041c13f2;
  ::S10183C31 s2041c13f3;
  ~S2041C13(); // tgen
  S2041C13(); // tgen
};
//SIG(-1 S2041C13) C1{ BC2{ vd} Fi FC3{ BC4{ vd v3 v4} vd v1 v2 FC5{ m Fp Fi FC6{ m}} FC5 Fi} FC7{ BC4 vd v5 v6 FC8{ BC4 vd v7 v8 FC5} FC3 FC9{ BC10{ m Fp Fi[2] FC11{ m}} BC4 vd v9 v10} FC12{ vd m FC13{ m Fs[6] Fi[2] Fc Fs}} FC5 FC5 Fc[2] Fi FC5 FC5 FC5 FC5 FC5 Fi[3] Fp FC5 FC12 FC5 Fi} FC14{ Fi FC15{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]}}


S2041C13 ::~S2041C13(){ note_dtor("S2041C13", this);} // tgen
S2041C13 ::S2041C13(){ note_ctor("S2041C13", this);} // tgen

static void Test_S2041C13()
{
  extern Class_Descriptor cd_S2041C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(77,112)];
    init_test(&cd_S2041C13, buf);
    S2041C13 *dp, &lv = *(dp=new (buf) S2041C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,444), "sizeof(S2041C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2041C13)");
    check_base_class_offset(lv, (S2041C14*), 0, "S2041C13");
    check_field_offset(lv, s2041c13f0, ABISELECT(8,4), "S2041C13.s2041c13f0");
    check_field_offset(lv, s2041c13f1, ABISELECT(16,8), "S2041C13.s2041c13f1");
    check_field_offset(lv, s2041c13f2, ABISELECT(64,40), "S2041C13.s2041c13f2");
    check_field_offset(lv, s2041c13f3, ABISELECT(424,304), "S2041C13.s2041c13f3");
    test_class_info(&lv, &cd_S2041C13);
    dp->~S2041C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2041C13(Test_S2041C13, "S2041C13", ABISELECT(608,444));

#else // __cplusplus

extern void _ZN8S2041C13C1Ev();
extern void _ZN8S2041C13D1Ev();
Name_Map name_map_S2041C13[] = {
  NSPAIR(_ZN8S2041C13C1Ev),
  NSPAIR(_ZN8S2041C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2041C14;
extern VTBL_ENTRY _ZTI8S2041C14[];
extern  VTBL_ENTRY _ZTV8S2041C14[];
static Base_Class bases_S2041C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2041C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2041C13[];
extern void _ZN8S2041C13D1Ev();
extern void _ZN8S2041C13D0Ev();
static  VTBL_ENTRY vtc_S2041C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2041C13[0]),
  (VTBL_ENTRY)&_ZN8S2041C13D1Ev,
  (VTBL_ENTRY)&_ZN8S2041C13D0Ev,
};
extern VTBL_ENTRY _ZTI8S2041C13[];
extern  VTBL_ENTRY _ZTV8S2041C13[];
Class_Descriptor cd_S2041C13 = {  "S2041C13", // class name
  bases_S2041C13, 1,
  &(vtc_S2041C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(608,444), // object size
  NSPAIRA(_ZTI8S2041C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S2041C13),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2041C31_nt  {
  __tsi64 s2041c31f0[2];
  void  mf2041c31(); // _ZN11S2041C31_nt9mf2041c31Ev
};
//SIG(-1 S2041C31_nt) C1{ m FL[2]}


void  S2041C31_nt ::mf2041c31(){}

//skip512 S2041C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2041C30_nt  {
  ::S2041C31_nt s2041c30f0;
  void  mf2041c30(); // _ZN11S2041C30_nt9mf2041c30Ev
};
//SIG(-1 S2041C30_nt) C1{ m FC2{ m FL[2]}}


void  S2041C30_nt ::mf2041c30(){}

//skip512 S2041C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2041C1  : S2041C2 , S2041C9 {
  ::S2041C13 s2041c1f0;
  ::S10183C19_nt s2041c1f1;
  int s2041c1f2;
  void *s2041c1f3;
  ::S2041C30_nt s2041c1f4;
  virtual  ~S2041C1(); // _ZN7S2041C1D1Ev
  virtual void  v1(); // _ZN7S2041C12v1Ev
  virtual void  v2(); // _ZN7S2041C12v2Ev
  virtual void  v3(); // _ZN7S2041C12v3Ev
  virtual void  v4(); // _ZN7S2041C12v4Ev
  virtual void  v5(); // _ZN7S2041C12v5Ev
  virtual void  v6(); // _ZN7S2041C12v6Ev
  virtual void  v7(); // _ZN7S2041C12v7Ev
  virtual void  v8(); // _ZN7S2041C12v8Ev
  virtual void  v9(); // _ZN7S2041C12v9Ev
  virtual void  v10(); // _ZN7S2041C13v10Ev
  virtual void  v11(); // _ZN7S2041C13v11Ev
  virtual void  v12(); // _ZN7S2041C13v12Ev
  virtual void  v13(); // _ZN7S2041C13v13Ev
  virtual void  v14(); // _ZN7S2041C13v14Ev
  virtual void  v15(); // _ZN7S2041C13v15Ev
  S2041C1(); // tgen
};
//SIG(1 S2041C1) C1{ BC2{ BC3{ BC4{ vd v16 v17 v18} vd v19 v20 v21} vd v22 v23 v24 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FC8{ Fl[4]}} Fc} BC9{ BC10{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 Fp[2]} vd v39 v40 v41 v42 v43 v44 v45 FC11{ m Fp Fi[2] FC12{ m}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC13{ BC14{ vd} Fi FC15{ BC16{ vd v48 v49} vd v46 v47 FC17{ m Fp Fi FC18{ m}} FC17 Fi} FC19{ BC16 vd v50 v51 FC20{ BC16 vd v52 v53 FC17} FC15 FC21{ BC5 BC16 vd v54 v55} FC22{ vd m FC23{ m Fs[6] Fi[2] Fc Fs}} FC17 FC17 Fc[2] Fi FC17 FC17 FC17 FC17 FC17 Fi[3] Fp FC17 FC22 FC17 Fi} FC24{ Fi FC25{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]}} FC21 Fi Fp FC26{ m FC27{ m FL[2]}}}


 S2041C1 ::~S2041C1(){ note_dtor("S2041C1", this);}
void  S2041C1 ::v1(){vfunc_called(this, "_ZN7S2041C12v1Ev");}
void  S2041C1 ::v2(){vfunc_called(this, "_ZN7S2041C12v2Ev");}
void  S2041C1 ::v3(){vfunc_called(this, "_ZN7S2041C12v3Ev");}
void  S2041C1 ::v4(){vfunc_called(this, "_ZN7S2041C12v4Ev");}
void  S2041C1 ::v5(){vfunc_called(this, "_ZN7S2041C12v5Ev");}
void  S2041C1 ::v6(){vfunc_called(this, "_ZN7S2041C12v6Ev");}
void  S2041C1 ::v7(){vfunc_called(this, "_ZN7S2041C12v7Ev");}
void  S2041C1 ::v8(){vfunc_called(this, "_ZN7S2041C12v8Ev");}
void  S2041C1 ::v9(){vfunc_called(this, "_ZN7S2041C12v9Ev");}
void  S2041C1 ::v10(){vfunc_called(this, "_ZN7S2041C13v10Ev");}
void  S2041C1 ::v11(){vfunc_called(this, "_ZN7S2041C13v11Ev");}
void  S2041C1 ::v12(){vfunc_called(this, "_ZN7S2041C13v12Ev");}
void  S2041C1 ::v13(){vfunc_called(this, "_ZN7S2041C13v13Ev");}
void  S2041C1 ::v14(){vfunc_called(this, "_ZN7S2041C13v14Ev");}
void  S2041C1 ::v15(){vfunc_called(this, "_ZN7S2041C13v15Ev");}
S2041C1 ::S2041C1(){ note_ctor("S2041C1", this);} // tgen

static void Test_S2041C1()
{
  extern Class_Descriptor cd_S2041C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(100,140)];
    init_test(&cd_S2041C1, buf);
    S2041C1 *dp, &lv = *(dp=new (buf) S2041C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(792,556), "sizeof(S2041C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2041C1)");
    check_base_class_offset(lv, (S2041C4*)(S2041C3*)(S2041C2*), 0, "S2041C1");
    check_base_class_offset(lv, (S2041C3*)(S2041C2*), 0, "S2041C1");
    check_base_class_offset(lv, (S2041C2*), 0, "S2041C1");
    check_base_class_offset(lv, (S2041C10*)(S2041C9*), ABISELECT(72,40), "S2041C1");
    check_base_class_offset(lv, (S2041C9*), ABISELECT(72,40), "S2041C1");
    check_field_offset(lv, s2041c1f0, ABISELECT(120,68), "S2041C1.s2041c1f0");
    check_field_offset(lv, s2041c1f1, ABISELECT(728,512), "S2041C1.s2041c1f1");
    check_field_offset(lv, s2041c1f2, ABISELECT(760,532), "S2041C1.s2041c1f2");
    check_field_offset(lv, s2041c1f3, ABISELECT(768,536), "S2041C1.s2041c1f3");
    check_field_offset(lv, s2041c1f4, ABISELECT(776,540), "S2041C1.s2041c1f4");
    test_class_info(&lv, &cd_S2041C1);
    dp->~S2041C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2041C1(Test_S2041C1, "S2041C1", ABISELECT(792,556));

#else // __cplusplus

extern void _ZN7S2041C1C1Ev();
extern void _ZN7S2041C1D1Ev();
Name_Map name_map_S2041C1[] = {
  NSPAIR(_ZN7S2041C1C1Ev),
  NSPAIR(_ZN7S2041C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2041C4;
extern VTBL_ENTRY _ZTI7S2041C4[];
extern  VTBL_ENTRY _ZTV7S2041C4[];
extern Class_Descriptor cd_S2041C3;
extern VTBL_ENTRY _ZTI7S2041C3[];
extern  VTBL_ENTRY _ZTV7S2041C3[];
extern Class_Descriptor cd_S2041C2;
extern VTBL_ENTRY _ZTI7S2041C2[];
extern  VTBL_ENTRY _ZTV7S2041C2[];
extern Class_Descriptor cd_S2041C10;
extern VTBL_ENTRY _ZTI8S2041C10[];
extern  VTBL_ENTRY _ZTV8S2041C10[];
extern Class_Descriptor cd_S2041C9;
extern VTBL_ENTRY _ZTI7S2041C9[];
extern  VTBL_ENTRY _ZTV7S2041C9[];
static Base_Class bases_S2041C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2041C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2041C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2041C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2041C10,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2041C9,    ABISELECT(72,40), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2041C1[];
extern void _ZN7S2041C1D1Ev();
extern void _ZN7S2041C1D0Ev();
extern void _ZN7S2041C43v16Ev();
extern void _ZN7S2041C43v17Ev();
extern void _ZN7S2041C43v18Ev();
extern void _ZN7S2041C33v19Ev();
extern void _ZN7S2041C33v20Ev();
extern void _ZN7S2041C33v21Ev();
extern void _ZN7S2041C23v22Ev();
extern void _ZN7S2041C23v23Ev();
extern void _ZN7S2041C23v24Ev();
extern void _ZN7S2041C12v1Ev();
extern void _ZN7S2041C12v2Ev();
extern void _ZN7S2041C12v3Ev();
extern void _ZN7S2041C12v4Ev();
extern void _ZN7S2041C12v5Ev();
extern void _ZN7S2041C12v6Ev();
extern void _ZN7S2041C12v7Ev();
extern void _ZN7S2041C12v8Ev();
extern void _ZN7S2041C12v9Ev();
extern void _ZN7S2041C13v10Ev();
extern void _ZN7S2041C13v11Ev();
extern void _ZN7S2041C13v12Ev();
extern void _ZN7S2041C13v13Ev();
extern void _ZN7S2041C13v14Ev();
extern void _ZN7S2041C13v15Ev();
extern void ABISELECT(_ZThn72_N7S2041C1D1Ev,_ZThn40_N7S2041C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2041C1D0Ev,_ZThn40_N7S2041C1D0Ev)();
extern void _ZN8S2041C103v25Ev();
extern void _ZN8S2041C103v26Ev();
extern void _ZN8S2041C103v27Ev();
extern void _ZN8S2041C103v28Ev();
extern void _ZN8S2041C103v29Ev();
extern void _ZN8S2041C103v30Ev();
extern void _ZN8S2041C103v31Ev();
extern void _ZN8S2041C103v32Ev();
extern void _ZN8S2041C103v33Ev();
extern void _ZN8S2041C103v34Ev();
extern void _ZN8S2041C103v35Ev();
extern void _ZN8S2041C103v36Ev();
extern void _ZN8S2041C103v37Ev();
extern void _ZN8S2041C103v38Ev();
extern void _ZN7S2041C93v39Ev();
extern void _ZN7S2041C93v40Ev();
extern void _ZN7S2041C93v41Ev();
extern void _ZN7S2041C93v42Ev();
extern void _ZN7S2041C93v43Ev();
extern void _ZN7S2041C93v44Ev();
extern void _ZN7S2041C93v45Ev();
static  VTBL_ENTRY vtc_S2041C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2041C1[0]),
  (VTBL_ENTRY)&_ZN7S2041C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2041C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2041C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2041C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2041C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2041C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2041C23v22Ev,
  (VTBL_ENTRY)&_ZN7S2041C23v23Ev,
  (VTBL_ENTRY)&_ZN7S2041C23v24Ev,
  (VTBL_ENTRY)&_ZN7S2041C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2041C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2041C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2041C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2041C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2041C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2041C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2041C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2041C12v9Ev,
  (VTBL_ENTRY)&_ZN7S2041C13v10Ev,
  (VTBL_ENTRY)&_ZN7S2041C13v11Ev,
  (VTBL_ENTRY)&_ZN7S2041C13v12Ev,
  (VTBL_ENTRY)&_ZN7S2041C13v13Ev,
  (VTBL_ENTRY)&_ZN7S2041C13v14Ev,
  (VTBL_ENTRY)&_ZN7S2041C13v15Ev,
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI7S2041C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2041C1D1Ev,_ZThn40_N7S2041C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2041C1D0Ev,_ZThn40_N7S2041C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2041C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v33Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v34Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v35Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v36Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v37Ev,
  (VTBL_ENTRY)&_ZN8S2041C103v38Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v39Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v40Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v41Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v42Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v43Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v44Ev,
  (VTBL_ENTRY)&_ZN7S2041C93v45Ev,
};
extern VTBL_ENTRY _ZTI7S2041C1[];
extern  VTBL_ENTRY _ZTV7S2041C1[];
Class_Descriptor cd_S2041C1 = {  "S2041C1", // class name
  bases_S2041C1, 5,
  &(vtc_S2041C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(792,556), // object size
  NSPAIRA(_ZTI7S2041C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2041C1),53, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2042C4  {
  virtual  ~S2042C4(); // _ZN7S2042C4D1Ev
  virtual void  v16(); // _ZN7S2042C43v16Ev
  virtual void  v17(); // _ZN7S2042C43v17Ev
  virtual void  v18(); // _ZN7S2042C43v18Ev
  S2042C4(); // tgen
};
//SIG(-1 S2042C4) C1{ vd v1 v2 v3}


 S2042C4 ::~S2042C4(){ note_dtor("S2042C4", this);}
void  S2042C4 ::v16(){vfunc_called(this, "_ZN7S2042C43v16Ev");}
void  S2042C4 ::v17(){vfunc_called(this, "_ZN7S2042C43v17Ev");}
void  S2042C4 ::v18(){vfunc_called(this, "_ZN7S2042C43v18Ev");}
S2042C4 ::S2042C4(){ note_ctor("S2042C4", this);} // tgen

static void Test_S2042C4()
{
  extern Class_Descriptor cd_S2042C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2042C4, buf);
    S2042C4 *dp, &lv = *(dp=new (buf) S2042C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2042C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2042C4)");
    test_class_info(&lv, &cd_S2042C4);
    dp->~S2042C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2042C4(Test_S2042C4, "S2042C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2042C4C1Ev();
extern void _ZN7S2042C4D1Ev();
Name_Map name_map_S2042C4[] = {
  NSPAIR(_ZN7S2042C4C1Ev),
  NSPAIR(_ZN7S2042C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2042C4[];
extern void _ZN7S2042C4D1Ev();
extern void _ZN7S2042C4D0Ev();
extern void _ZN7S2042C43v16Ev();
extern void _ZN7S2042C43v17Ev();
extern void _ZN7S2042C43v18Ev();
static  VTBL_ENTRY vtc_S2042C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2042C4[0]),
  (VTBL_ENTRY)&_ZN7S2042C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2042C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v18Ev,
};
extern VTBL_ENTRY _ZTI7S2042C4[];
extern  VTBL_ENTRY _ZTV7S2042C4[];
Class_Descriptor cd_S2042C4 = {  "S2042C4", // class name
  0,0,//no base classes
  &(vtc_S2042C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2042C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2042C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2042C3  : S2042C4 {
  virtual  ~S2042C3(); // _ZN7S2042C3D1Ev
  virtual void  v19(); // _ZN7S2042C33v19Ev
  virtual void  v20(); // _ZN7S2042C33v20Ev
  virtual void  v21(); // _ZN7S2042C33v21Ev
  S2042C3(); // tgen
};
//SIG(-1 S2042C3) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3}


 S2042C3 ::~S2042C3(){ note_dtor("S2042C3", this);}
void  S2042C3 ::v19(){vfunc_called(this, "_ZN7S2042C33v19Ev");}
void  S2042C3 ::v20(){vfunc_called(this, "_ZN7S2042C33v20Ev");}
void  S2042C3 ::v21(){vfunc_called(this, "_ZN7S2042C33v21Ev");}
S2042C3 ::S2042C3(){ note_ctor("S2042C3", this);} // tgen

static void Test_S2042C3()
{
  extern Class_Descriptor cd_S2042C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2042C3, buf);
    S2042C3 *dp, &lv = *(dp=new (buf) S2042C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2042C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2042C3)");
    check_base_class_offset(lv, (S2042C4*), 0, "S2042C3");
    test_class_info(&lv, &cd_S2042C3);
    dp->~S2042C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2042C3(Test_S2042C3, "S2042C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2042C3C1Ev();
extern void _ZN7S2042C3D1Ev();
Name_Map name_map_S2042C3[] = {
  NSPAIR(_ZN7S2042C3C1Ev),
  NSPAIR(_ZN7S2042C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2042C4;
extern VTBL_ENTRY _ZTI7S2042C4[];
extern  VTBL_ENTRY _ZTV7S2042C4[];
static Base_Class bases_S2042C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2042C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2042C3[];
extern void _ZN7S2042C3D1Ev();
extern void _ZN7S2042C3D0Ev();
extern void _ZN7S2042C43v16Ev();
extern void _ZN7S2042C43v17Ev();
extern void _ZN7S2042C43v18Ev();
extern void _ZN7S2042C33v19Ev();
extern void _ZN7S2042C33v20Ev();
extern void _ZN7S2042C33v21Ev();
static  VTBL_ENTRY vtc_S2042C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2042C3[0]),
  (VTBL_ENTRY)&_ZN7S2042C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2042C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2042C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2042C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2042C33v21Ev,
};
extern VTBL_ENTRY _ZTI7S2042C3[];
extern  VTBL_ENTRY _ZTV7S2042C3[];
Class_Descriptor cd_S2042C3 = {  "S2042C3", // class name
  bases_S2042C3, 1,
  &(vtc_S2042C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2042C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2042C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2042C2  : S2042C3 {
  ::S10183C20 s2042c2f0;
  ::S10184C7_nt s2042c2f1;
  char s2042c2f2;
  virtual  ~S2042C2(); // _ZN7S2042C2D1Ev
  virtual void  v22(); // _ZN7S2042C23v22Ev
  virtual void  v23(); // _ZN7S2042C23v23Ev
  virtual void  v24(); // _ZN7S2042C23v24Ev
  S2042C2(); // tgen
};
//SIG(-1 S2042C2) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc}


 S2042C2 ::~S2042C2(){ note_dtor("S2042C2", this);}
void  S2042C2 ::v22(){vfunc_called(this, "_ZN7S2042C23v22Ev");}
void  S2042C2 ::v23(){vfunc_called(this, "_ZN7S2042C23v23Ev");}
void  S2042C2 ::v24(){vfunc_called(this, "_ZN7S2042C23v24Ev");}
S2042C2 ::S2042C2(){ note_ctor("S2042C2", this);} // tgen

static void Test_S2042C2()
{
  extern Class_Descriptor cd_S2042C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2042C2, buf);
    S2042C2 *dp, &lv = *(dp=new (buf) S2042C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2042C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2042C2)");
    check_base_class_offset(lv, (S2042C4*)(S2042C3*), 0, "S2042C2");
    check_base_class_offset(lv, (S2042C3*), 0, "S2042C2");
    check_field_offset(lv, s2042c2f0, ABISELECT(8,4), "S2042C2.s2042c2f0");
    check_field_offset(lv, s2042c2f1, ABISELECT(32,20), "S2042C2.s2042c2f1");
    check_field_offset(lv, s2042c2f2, ABISELECT(64,52), "S2042C2.s2042c2f2");
    test_class_info(&lv, &cd_S2042C2);
    dp->~S2042C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2042C2(Test_S2042C2, "S2042C2", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2042C2C1Ev();
extern void _ZN7S2042C2D1Ev();
Name_Map name_map_S2042C2[] = {
  NSPAIR(_ZN7S2042C2C1Ev),
  NSPAIR(_ZN7S2042C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2042C4;
extern VTBL_ENTRY _ZTI7S2042C4[];
extern  VTBL_ENTRY _ZTV7S2042C4[];
extern Class_Descriptor cd_S2042C3;
extern VTBL_ENTRY _ZTI7S2042C3[];
extern  VTBL_ENTRY _ZTV7S2042C3[];
static Base_Class bases_S2042C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2042C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2042C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2042C2[];
extern void _ZN7S2042C2D1Ev();
extern void _ZN7S2042C2D0Ev();
extern void _ZN7S2042C43v16Ev();
extern void _ZN7S2042C43v17Ev();
extern void _ZN7S2042C43v18Ev();
extern void _ZN7S2042C33v19Ev();
extern void _ZN7S2042C33v20Ev();
extern void _ZN7S2042C33v21Ev();
extern void _ZN7S2042C23v22Ev();
extern void _ZN7S2042C23v23Ev();
extern void _ZN7S2042C23v24Ev();
static  VTBL_ENTRY vtc_S2042C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2042C2[0]),
  (VTBL_ENTRY)&_ZN7S2042C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2042C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2042C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2042C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2042C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2042C23v22Ev,
  (VTBL_ENTRY)&_ZN7S2042C23v23Ev,
  (VTBL_ENTRY)&_ZN7S2042C23v24Ev,
};
extern VTBL_ENTRY _ZTI7S2042C2[];
extern  VTBL_ENTRY _ZTV7S2042C2[];
Class_Descriptor cd_S2042C2 = {  "S2042C2", // class name
  bases_S2042C2, 2,
  &(vtc_S2042C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2042C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2042C2),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2042C10  {
  void *s2042c10f0[2];
  virtual  ~S2042C10(); // _ZN8S2042C10D1Ev
  virtual void  v25(); // _ZN8S2042C103v25Ev
  virtual void  v26(); // _ZN8S2042C103v26Ev
  virtual void  v27(); // _ZN8S2042C103v27Ev
  virtual void  v28(); // _ZN8S2042C103v28Ev
  virtual void  v29(); // _ZN8S2042C103v29Ev
  virtual void  v30(); // _ZN8S2042C103v30Ev
  virtual void  v31(); // _ZN8S2042C103v31Ev
  virtual void  v32(); // _ZN8S2042C103v32Ev
  virtual void  v33(); // _ZN8S2042C103v33Ev
  virtual void  v34(); // _ZN8S2042C103v34Ev
  virtual void  v35(); // _ZN8S2042C103v35Ev
  virtual void  v36(); // _ZN8S2042C103v36Ev
  virtual void  v37(); // _ZN8S2042C103v37Ev
  virtual void  v38(); // _ZN8S2042C103v38Ev
  S2042C10(); // tgen
};
//SIG(-1 S2042C10) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2]}


 S2042C10 ::~S2042C10(){ note_dtor("S2042C10", this);}
void  S2042C10 ::v25(){vfunc_called(this, "_ZN8S2042C103v25Ev");}
void  S2042C10 ::v26(){vfunc_called(this, "_ZN8S2042C103v26Ev");}
void  S2042C10 ::v27(){vfunc_called(this, "_ZN8S2042C103v27Ev");}
void  S2042C10 ::v28(){vfunc_called(this, "_ZN8S2042C103v28Ev");}
void  S2042C10 ::v29(){vfunc_called(this, "_ZN8S2042C103v29Ev");}
void  S2042C10 ::v30(){vfunc_called(this, "_ZN8S2042C103v30Ev");}
void  S2042C10 ::v31(){vfunc_called(this, "_ZN8S2042C103v31Ev");}
void  S2042C10 ::v32(){vfunc_called(this, "_ZN8S2042C103v32Ev");}
void  S2042C10 ::v33(){vfunc_called(this, "_ZN8S2042C103v33Ev");}
void  S2042C10 ::v34(){vfunc_called(this, "_ZN8S2042C103v34Ev");}
void  S2042C10 ::v35(){vfunc_called(this, "_ZN8S2042C103v35Ev");}
void  S2042C10 ::v36(){vfunc_called(this, "_ZN8S2042C103v36Ev");}
void  S2042C10 ::v37(){vfunc_called(this, "_ZN8S2042C103v37Ev");}
void  S2042C10 ::v38(){vfunc_called(this, "_ZN8S2042C103v38Ev");}
S2042C10 ::S2042C10(){ note_ctor("S2042C10", this);} // tgen

static void Test_S2042C10()
{
  extern Class_Descriptor cd_S2042C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S2042C10, buf);
    S2042C10 *dp, &lv = *(dp=new (buf) S2042C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S2042C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2042C10)");
    check_field_offset(lv, s2042c10f0, ABISELECT(8,4), "S2042C10.s2042c10f0");
    test_class_info(&lv, &cd_S2042C10);
    dp->~S2042C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2042C10(Test_S2042C10, "S2042C10", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S2042C10C1Ev();
extern void _ZN8S2042C10D1Ev();
Name_Map name_map_S2042C10[] = {
  NSPAIR(_ZN8S2042C10C1Ev),
  NSPAIR(_ZN8S2042C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2042C10[];
extern void _ZN8S2042C10D1Ev();
extern void _ZN8S2042C10D0Ev();
extern void _ZN8S2042C103v25Ev();
extern void _ZN8S2042C103v26Ev();
extern void _ZN8S2042C103v27Ev();
extern void _ZN8S2042C103v28Ev();
extern void _ZN8S2042C103v29Ev();
extern void _ZN8S2042C103v30Ev();
extern void _ZN8S2042C103v31Ev();
extern void _ZN8S2042C103v32Ev();
extern void _ZN8S2042C103v33Ev();
extern void _ZN8S2042C103v34Ev();
extern void _ZN8S2042C103v35Ev();
extern void _ZN8S2042C103v36Ev();
extern void _ZN8S2042C103v37Ev();
extern void _ZN8S2042C103v38Ev();
static  VTBL_ENTRY vtc_S2042C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2042C10[0]),
  (VTBL_ENTRY)&_ZN8S2042C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2042C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v33Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v34Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v35Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v36Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v37Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v38Ev,
};
extern VTBL_ENTRY _ZTI8S2042C10[];
extern  VTBL_ENTRY _ZTV8S2042C10[];
Class_Descriptor cd_S2042C10 = {  "S2042C10", // class name
  0,0,//no base classes
  &(vtc_S2042C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S2042C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2042C10),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2042C9  : S2042C10 {
  ::S10183C5_nt s2042c9f0;
  virtual  ~S2042C9(); // _ZN7S2042C9D1Ev
  virtual void  v39(); // _ZN7S2042C93v39Ev
  virtual void  v40(); // _ZN7S2042C93v40Ev
  virtual void  v41(); // _ZN7S2042C93v41Ev
  virtual void  v42(); // _ZN7S2042C93v42Ev
  virtual void  v43(); // _ZN7S2042C93v43Ev
  virtual void  v44(); // _ZN7S2042C93v44Ev
  virtual void  v45(); // _ZN7S2042C93v45Ev
  S2042C9(); // tgen
};
//SIG(-1 S2042C9) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m Fp Fi[2] FC4{ m}}}


 S2042C9 ::~S2042C9(){ note_dtor("S2042C9", this);}
void  S2042C9 ::v39(){vfunc_called(this, "_ZN7S2042C93v39Ev");}
void  S2042C9 ::v40(){vfunc_called(this, "_ZN7S2042C93v40Ev");}
void  S2042C9 ::v41(){vfunc_called(this, "_ZN7S2042C93v41Ev");}
void  S2042C9 ::v42(){vfunc_called(this, "_ZN7S2042C93v42Ev");}
void  S2042C9 ::v43(){vfunc_called(this, "_ZN7S2042C93v43Ev");}
void  S2042C9 ::v44(){vfunc_called(this, "_ZN7S2042C93v44Ev");}
void  S2042C9 ::v45(){vfunc_called(this, "_ZN7S2042C93v45Ev");}
S2042C9 ::S2042C9(){ note_ctor("S2042C9", this);} // tgen

static void Test_S2042C9()
{
  extern Class_Descriptor cd_S2042C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_S2042C9, buf);
    S2042C9 *dp, &lv = *(dp=new (buf) S2042C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S2042C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2042C9)");
    check_base_class_offset(lv, (S2042C10*), 0, "S2042C9");
    check_field_offset(lv, s2042c9f0, ABISELECT(24,12), "S2042C9.s2042c9f0");
    test_class_info(&lv, &cd_S2042C9);
    dp->~S2042C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2042C9(Test_S2042C9, "S2042C9", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN7S2042C9C1Ev();
extern void _ZN7S2042C9D1Ev();
Name_Map name_map_S2042C9[] = {
  NSPAIR(_ZN7S2042C9C1Ev),
  NSPAIR(_ZN7S2042C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2042C10;
extern VTBL_ENTRY _ZTI8S2042C10[];
extern  VTBL_ENTRY _ZTV8S2042C10[];
static Base_Class bases_S2042C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2042C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2042C9[];
extern void _ZN7S2042C9D1Ev();
extern void _ZN7S2042C9D0Ev();
extern void _ZN8S2042C103v25Ev();
extern void _ZN8S2042C103v26Ev();
extern void _ZN8S2042C103v27Ev();
extern void _ZN8S2042C103v28Ev();
extern void _ZN8S2042C103v29Ev();
extern void _ZN8S2042C103v30Ev();
extern void _ZN8S2042C103v31Ev();
extern void _ZN8S2042C103v32Ev();
extern void _ZN8S2042C103v33Ev();
extern void _ZN8S2042C103v34Ev();
extern void _ZN8S2042C103v35Ev();
extern void _ZN8S2042C103v36Ev();
extern void _ZN8S2042C103v37Ev();
extern void _ZN8S2042C103v38Ev();
extern void _ZN7S2042C93v39Ev();
extern void _ZN7S2042C93v40Ev();
extern void _ZN7S2042C93v41Ev();
extern void _ZN7S2042C93v42Ev();
extern void _ZN7S2042C93v43Ev();
extern void _ZN7S2042C93v44Ev();
extern void _ZN7S2042C93v45Ev();
static  VTBL_ENTRY vtc_S2042C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2042C9[0]),
  (VTBL_ENTRY)&_ZN7S2042C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2042C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v33Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v34Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v35Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v36Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v37Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v38Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v39Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v40Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v41Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v42Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v43Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v44Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v45Ev,
};
extern VTBL_ENTRY _ZTI7S2042C9[];
extern  VTBL_ENTRY _ZTV7S2042C9[];
Class_Descriptor cd_S2042C9 = {  "S2042C9", // class name
  bases_S2042C9, 1,
  &(vtc_S2042C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI7S2042C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2042C9),25, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2042C1  : S2042C2 , S2042C9 {
  ::S2041C13 s2042c1f0;
  ::S10183C19_nt s2042c1f1;
  int s2042c1f2;
  void *s2042c1f3;
  ::S2041C30_nt s2042c1f4;
  virtual  ~S2042C1(); // _ZN7S2042C1D1Ev
  virtual void  v1(); // _ZN7S2042C12v1Ev
  virtual void  v2(); // _ZN7S2042C12v2Ev
  virtual void  v3(); // _ZN7S2042C12v3Ev
  virtual void  v4(); // _ZN7S2042C12v4Ev
  virtual void  v5(); // _ZN7S2042C12v5Ev
  virtual void  v6(); // _ZN7S2042C12v6Ev
  virtual void  v7(); // _ZN7S2042C12v7Ev
  virtual void  v8(); // _ZN7S2042C12v8Ev
  virtual void  v9(); // _ZN7S2042C12v9Ev
  virtual void  v10(); // _ZN7S2042C13v10Ev
  virtual void  v11(); // _ZN7S2042C13v11Ev
  virtual void  v12(); // _ZN7S2042C13v12Ev
  virtual void  v13(); // _ZN7S2042C13v13Ev
  virtual void  v14(); // _ZN7S2042C13v14Ev
  virtual void  v15(); // _ZN7S2042C13v15Ev
  S2042C1(); // tgen
};
//SIG(1 S2042C1) C1{ BC2{ BC3{ BC4{ vd v16 v17 v18} vd v19 v20 v21} vd v22 v23 v24 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FC8{ FL[4]}} Fc} BC9{ BC10{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 Fp[2]} vd v39 v40 v41 v42 v43 v44 v45 FC11{ m Fp Fi[2] FC12{ m}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC13{ BC14{ vd} Fi FC15{ BC16{ vd v48 v49} vd v46 v47 FC17{ m Fp Fi FC18{ m}} FC17 Fi} FC19{ BC16 vd v50 v51 FC20{ BC16 vd v52 v53 FC17} FC15 FC21{ BC5 BC16 vd v54 v55} FC22{ vd m FC23{ m Fs[6] Fi[2] Fc Fs}} FC17 FC17 Fc[2] Fi FC17 FC17 FC17 FC17 FC17 Fi[3] Fp FC17 FC22 FC17 Fi} FC24{ Fi FC25{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]}} FC21 Fi Fp FC26{ m FC27{ m FL[2]}}}


 S2042C1 ::~S2042C1(){ note_dtor("S2042C1", this);}
void  S2042C1 ::v1(){vfunc_called(this, "_ZN7S2042C12v1Ev");}
void  S2042C1 ::v2(){vfunc_called(this, "_ZN7S2042C12v2Ev");}
void  S2042C1 ::v3(){vfunc_called(this, "_ZN7S2042C12v3Ev");}
void  S2042C1 ::v4(){vfunc_called(this, "_ZN7S2042C12v4Ev");}
void  S2042C1 ::v5(){vfunc_called(this, "_ZN7S2042C12v5Ev");}
void  S2042C1 ::v6(){vfunc_called(this, "_ZN7S2042C12v6Ev");}
void  S2042C1 ::v7(){vfunc_called(this, "_ZN7S2042C12v7Ev");}
void  S2042C1 ::v8(){vfunc_called(this, "_ZN7S2042C12v8Ev");}
void  S2042C1 ::v9(){vfunc_called(this, "_ZN7S2042C12v9Ev");}
void  S2042C1 ::v10(){vfunc_called(this, "_ZN7S2042C13v10Ev");}
void  S2042C1 ::v11(){vfunc_called(this, "_ZN7S2042C13v11Ev");}
void  S2042C1 ::v12(){vfunc_called(this, "_ZN7S2042C13v12Ev");}
void  S2042C1 ::v13(){vfunc_called(this, "_ZN7S2042C13v13Ev");}
void  S2042C1 ::v14(){vfunc_called(this, "_ZN7S2042C13v14Ev");}
void  S2042C1 ::v15(){vfunc_called(this, "_ZN7S2042C13v15Ev");}
S2042C1 ::S2042C1(){ note_ctor("S2042C1", this);} // tgen

static void Test_S2042C1()
{
  extern Class_Descriptor cd_S2042C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(100,144)];
    init_test(&cd_S2042C1, buf);
    S2042C1 *dp, &lv = *(dp=new (buf) S2042C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(792,572), "sizeof(S2042C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2042C1)");
    check_base_class_offset(lv, (S2042C4*)(S2042C3*)(S2042C2*), 0, "S2042C1");
    check_base_class_offset(lv, (S2042C3*)(S2042C2*), 0, "S2042C1");
    check_base_class_offset(lv, (S2042C2*), 0, "S2042C1");
    check_base_class_offset(lv, (S2042C10*)(S2042C9*), ABISELECT(72,56), "S2042C1");
    check_base_class_offset(lv, (S2042C9*), ABISELECT(72,56), "S2042C1");
    check_field_offset(lv, s2042c1f0, ABISELECT(120,84), "S2042C1.s2042c1f0");
    check_field_offset(lv, s2042c1f1, ABISELECT(728,528), "S2042C1.s2042c1f1");
    check_field_offset(lv, s2042c1f2, ABISELECT(760,548), "S2042C1.s2042c1f2");
    check_field_offset(lv, s2042c1f3, ABISELECT(768,552), "S2042C1.s2042c1f3");
    check_field_offset(lv, s2042c1f4, ABISELECT(776,556), "S2042C1.s2042c1f4");
    test_class_info(&lv, &cd_S2042C1);
    dp->~S2042C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2042C1(Test_S2042C1, "S2042C1", ABISELECT(792,572));

#else // __cplusplus

extern void _ZN7S2042C1C1Ev();
extern void _ZN7S2042C1D1Ev();
Name_Map name_map_S2042C1[] = {
  NSPAIR(_ZN7S2042C1C1Ev),
  NSPAIR(_ZN7S2042C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2042C4;
extern VTBL_ENTRY _ZTI7S2042C4[];
extern  VTBL_ENTRY _ZTV7S2042C4[];
extern Class_Descriptor cd_S2042C3;
extern VTBL_ENTRY _ZTI7S2042C3[];
extern  VTBL_ENTRY _ZTV7S2042C3[];
extern Class_Descriptor cd_S2042C2;
extern VTBL_ENTRY _ZTI7S2042C2[];
extern  VTBL_ENTRY _ZTV7S2042C2[];
extern Class_Descriptor cd_S2042C10;
extern VTBL_ENTRY _ZTI8S2042C10[];
extern  VTBL_ENTRY _ZTV8S2042C10[];
extern Class_Descriptor cd_S2042C9;
extern VTBL_ENTRY _ZTI7S2042C9[];
extern  VTBL_ENTRY _ZTV7S2042C9[];
static Base_Class bases_S2042C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2042C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2042C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2042C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2042C10,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2042C9,    ABISELECT(72,56), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2042C1[];
extern void _ZN7S2042C1D1Ev();
extern void _ZN7S2042C1D0Ev();
extern void _ZN7S2042C43v16Ev();
extern void _ZN7S2042C43v17Ev();
extern void _ZN7S2042C43v18Ev();
extern void _ZN7S2042C33v19Ev();
extern void _ZN7S2042C33v20Ev();
extern void _ZN7S2042C33v21Ev();
extern void _ZN7S2042C23v22Ev();
extern void _ZN7S2042C23v23Ev();
extern void _ZN7S2042C23v24Ev();
extern void _ZN7S2042C12v1Ev();
extern void _ZN7S2042C12v2Ev();
extern void _ZN7S2042C12v3Ev();
extern void _ZN7S2042C12v4Ev();
extern void _ZN7S2042C12v5Ev();
extern void _ZN7S2042C12v6Ev();
extern void _ZN7S2042C12v7Ev();
extern void _ZN7S2042C12v8Ev();
extern void _ZN7S2042C12v9Ev();
extern void _ZN7S2042C13v10Ev();
extern void _ZN7S2042C13v11Ev();
extern void _ZN7S2042C13v12Ev();
extern void _ZN7S2042C13v13Ev();
extern void _ZN7S2042C13v14Ev();
extern void _ZN7S2042C13v15Ev();
extern void ABISELECT(_ZThn72_N7S2042C1D1Ev,_ZThn56_N7S2042C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2042C1D0Ev,_ZThn56_N7S2042C1D0Ev)();
extern void _ZN8S2042C103v25Ev();
extern void _ZN8S2042C103v26Ev();
extern void _ZN8S2042C103v27Ev();
extern void _ZN8S2042C103v28Ev();
extern void _ZN8S2042C103v29Ev();
extern void _ZN8S2042C103v30Ev();
extern void _ZN8S2042C103v31Ev();
extern void _ZN8S2042C103v32Ev();
extern void _ZN8S2042C103v33Ev();
extern void _ZN8S2042C103v34Ev();
extern void _ZN8S2042C103v35Ev();
extern void _ZN8S2042C103v36Ev();
extern void _ZN8S2042C103v37Ev();
extern void _ZN8S2042C103v38Ev();
extern void _ZN7S2042C93v39Ev();
extern void _ZN7S2042C93v40Ev();
extern void _ZN7S2042C93v41Ev();
extern void _ZN7S2042C93v42Ev();
extern void _ZN7S2042C93v43Ev();
extern void _ZN7S2042C93v44Ev();
extern void _ZN7S2042C93v45Ev();
static  VTBL_ENTRY vtc_S2042C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2042C1[0]),
  (VTBL_ENTRY)&_ZN7S2042C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2042C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2042C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2042C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2042C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2042C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2042C23v22Ev,
  (VTBL_ENTRY)&_ZN7S2042C23v23Ev,
  (VTBL_ENTRY)&_ZN7S2042C23v24Ev,
  (VTBL_ENTRY)&_ZN7S2042C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2042C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2042C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2042C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2042C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2042C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2042C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2042C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2042C12v9Ev,
  (VTBL_ENTRY)&_ZN7S2042C13v10Ev,
  (VTBL_ENTRY)&_ZN7S2042C13v11Ev,
  (VTBL_ENTRY)&_ZN7S2042C13v12Ev,
  (VTBL_ENTRY)&_ZN7S2042C13v13Ev,
  (VTBL_ENTRY)&_ZN7S2042C13v14Ev,
  (VTBL_ENTRY)&_ZN7S2042C13v15Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S2042C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2042C1D1Ev,_ZThn56_N7S2042C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2042C1D0Ev,_ZThn56_N7S2042C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2042C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v33Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v34Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v35Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v36Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v37Ev,
  (VTBL_ENTRY)&_ZN8S2042C103v38Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v39Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v40Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v41Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v42Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v43Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v44Ev,
  (VTBL_ENTRY)&_ZN7S2042C93v45Ev,
};
extern VTBL_ENTRY _ZTI7S2042C1[];
extern  VTBL_ENTRY _ZTV7S2042C1[];
Class_Descriptor cd_S2042C1 = {  "S2042C1", // class name
  bases_S2042C1, 5,
  &(vtc_S2042C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(792,572), // object size
  NSPAIRA(_ZTI7S2042C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2042C1),53, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2043C4  {
  virtual  ~S2043C4(); // _ZN7S2043C4D1Ev
  virtual void  v16(); // _ZN7S2043C43v16Ev
  virtual void  v17(); // _ZN7S2043C43v17Ev
  virtual void  v18(); // _ZN7S2043C43v18Ev
  S2043C4(); // tgen
};
//SIG(-1 S2043C4) C1{ vd v1 v2 v3}


 S2043C4 ::~S2043C4(){ note_dtor("S2043C4", this);}
void  S2043C4 ::v16(){vfunc_called(this, "_ZN7S2043C43v16Ev");}
void  S2043C4 ::v17(){vfunc_called(this, "_ZN7S2043C43v17Ev");}
void  S2043C4 ::v18(){vfunc_called(this, "_ZN7S2043C43v18Ev");}
S2043C4 ::S2043C4(){ note_ctor("S2043C4", this);} // tgen

static void Test_S2043C4()
{
  extern Class_Descriptor cd_S2043C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2043C4, buf);
    S2043C4 *dp, &lv = *(dp=new (buf) S2043C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2043C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2043C4)");
    test_class_info(&lv, &cd_S2043C4);
    dp->~S2043C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2043C4(Test_S2043C4, "S2043C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2043C4C1Ev();
extern void _ZN7S2043C4D1Ev();
Name_Map name_map_S2043C4[] = {
  NSPAIR(_ZN7S2043C4C1Ev),
  NSPAIR(_ZN7S2043C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2043C4[];
extern void _ZN7S2043C4D1Ev();
extern void _ZN7S2043C4D0Ev();
extern void _ZN7S2043C43v16Ev();
extern void _ZN7S2043C43v17Ev();
extern void _ZN7S2043C43v18Ev();
static  VTBL_ENTRY vtc_S2043C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2043C4[0]),
  (VTBL_ENTRY)&_ZN7S2043C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2043C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v18Ev,
};
extern VTBL_ENTRY _ZTI7S2043C4[];
extern  VTBL_ENTRY _ZTV7S2043C4[];
Class_Descriptor cd_S2043C4 = {  "S2043C4", // class name
  0,0,//no base classes
  &(vtc_S2043C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2043C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2043C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2043C3  : S2043C4 {
  virtual  ~S2043C3(); // _ZN7S2043C3D1Ev
  virtual void  v19(); // _ZN7S2043C33v19Ev
  virtual void  v20(); // _ZN7S2043C33v20Ev
  virtual void  v21(); // _ZN7S2043C33v21Ev
  S2043C3(); // tgen
};
//SIG(-1 S2043C3) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3}


 S2043C3 ::~S2043C3(){ note_dtor("S2043C3", this);}
void  S2043C3 ::v19(){vfunc_called(this, "_ZN7S2043C33v19Ev");}
void  S2043C3 ::v20(){vfunc_called(this, "_ZN7S2043C33v20Ev");}
void  S2043C3 ::v21(){vfunc_called(this, "_ZN7S2043C33v21Ev");}
S2043C3 ::S2043C3(){ note_ctor("S2043C3", this);} // tgen

static void Test_S2043C3()
{
  extern Class_Descriptor cd_S2043C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2043C3, buf);
    S2043C3 *dp, &lv = *(dp=new (buf) S2043C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2043C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2043C3)");
    check_base_class_offset(lv, (S2043C4*), 0, "S2043C3");
    test_class_info(&lv, &cd_S2043C3);
    dp->~S2043C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2043C3(Test_S2043C3, "S2043C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2043C3C1Ev();
extern void _ZN7S2043C3D1Ev();
Name_Map name_map_S2043C3[] = {
  NSPAIR(_ZN7S2043C3C1Ev),
  NSPAIR(_ZN7S2043C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2043C4;
extern VTBL_ENTRY _ZTI7S2043C4[];
extern  VTBL_ENTRY _ZTV7S2043C4[];
static Base_Class bases_S2043C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2043C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2043C3[];
extern void _ZN7S2043C3D1Ev();
extern void _ZN7S2043C3D0Ev();
extern void _ZN7S2043C43v16Ev();
extern void _ZN7S2043C43v17Ev();
extern void _ZN7S2043C43v18Ev();
extern void _ZN7S2043C33v19Ev();
extern void _ZN7S2043C33v20Ev();
extern void _ZN7S2043C33v21Ev();
static  VTBL_ENTRY vtc_S2043C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2043C3[0]),
  (VTBL_ENTRY)&_ZN7S2043C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2043C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2043C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2043C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2043C33v21Ev,
};
extern VTBL_ENTRY _ZTI7S2043C3[];
extern  VTBL_ENTRY _ZTV7S2043C3[];
Class_Descriptor cd_S2043C3 = {  "S2043C3", // class name
  bases_S2043C3, 1,
  &(vtc_S2043C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2043C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2043C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2043C2  : S2043C3 {
  ::S10183C20 s2043c2f0;
  ::S10185C7_nt s2043c2f1;
  char s2043c2f2;
  virtual  ~S2043C2(); // _ZN7S2043C2D1Ev
  virtual void  v22(); // _ZN7S2043C23v22Ev
  virtual void  v23(); // _ZN7S2043C23v23Ev
  virtual void  v24(); // _ZN7S2043C23v24Ev
  S2043C2(); // tgen
};
//SIG(-1 S2043C2) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FL[4]} Fc}


 S2043C2 ::~S2043C2(){ note_dtor("S2043C2", this);}
void  S2043C2 ::v22(){vfunc_called(this, "_ZN7S2043C23v22Ev");}
void  S2043C2 ::v23(){vfunc_called(this, "_ZN7S2043C23v23Ev");}
void  S2043C2 ::v24(){vfunc_called(this, "_ZN7S2043C23v24Ev");}
S2043C2 ::S2043C2(){ note_ctor("S2043C2", this);} // tgen

static void Test_S2043C2()
{
  extern Class_Descriptor cd_S2043C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2043C2, buf);
    S2043C2 *dp, &lv = *(dp=new (buf) S2043C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2043C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2043C2)");
    check_base_class_offset(lv, (S2043C4*)(S2043C3*), 0, "S2043C2");
    check_base_class_offset(lv, (S2043C3*), 0, "S2043C2");
    check_field_offset(lv, s2043c2f0, ABISELECT(8,4), "S2043C2.s2043c2f0");
    check_field_offset(lv, s2043c2f1, ABISELECT(32,20), "S2043C2.s2043c2f1");
    check_field_offset(lv, s2043c2f2, ABISELECT(64,52), "S2043C2.s2043c2f2");
    test_class_info(&lv, &cd_S2043C2);
    dp->~S2043C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2043C2(Test_S2043C2, "S2043C2", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2043C2C1Ev();
extern void _ZN7S2043C2D1Ev();
Name_Map name_map_S2043C2[] = {
  NSPAIR(_ZN7S2043C2C1Ev),
  NSPAIR(_ZN7S2043C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2043C4;
extern VTBL_ENTRY _ZTI7S2043C4[];
extern  VTBL_ENTRY _ZTV7S2043C4[];
extern Class_Descriptor cd_S2043C3;
extern VTBL_ENTRY _ZTI7S2043C3[];
extern  VTBL_ENTRY _ZTV7S2043C3[];
static Base_Class bases_S2043C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2043C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2043C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2043C2[];
extern void _ZN7S2043C2D1Ev();
extern void _ZN7S2043C2D0Ev();
extern void _ZN7S2043C43v16Ev();
extern void _ZN7S2043C43v17Ev();
extern void _ZN7S2043C43v18Ev();
extern void _ZN7S2043C33v19Ev();
extern void _ZN7S2043C33v20Ev();
extern void _ZN7S2043C33v21Ev();
extern void _ZN7S2043C23v22Ev();
extern void _ZN7S2043C23v23Ev();
extern void _ZN7S2043C23v24Ev();
static  VTBL_ENTRY vtc_S2043C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2043C2[0]),
  (VTBL_ENTRY)&_ZN7S2043C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2043C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2043C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2043C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2043C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2043C23v22Ev,
  (VTBL_ENTRY)&_ZN7S2043C23v23Ev,
  (VTBL_ENTRY)&_ZN7S2043C23v24Ev,
};
extern VTBL_ENTRY _ZTI7S2043C2[];
extern  VTBL_ENTRY _ZTV7S2043C2[];
Class_Descriptor cd_S2043C2 = {  "S2043C2", // class name
  bases_S2043C2, 2,
  &(vtc_S2043C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2043C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2043C2),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2043C9  {
  void *s2043c9f0[2];
  virtual  ~S2043C9(); // _ZN7S2043C9D1Ev
  virtual void  v25(); // _ZN7S2043C93v25Ev
  virtual void  v26(); // _ZN7S2043C93v26Ev
  virtual void  v27(); // _ZN7S2043C93v27Ev
  virtual void  v28(); // _ZN7S2043C93v28Ev
  virtual void  v29(); // _ZN7S2043C93v29Ev
  virtual void  v30(); // _ZN7S2043C93v30Ev
  virtual void  v31(); // _ZN7S2043C93v31Ev
  virtual void  v32(); // _ZN7S2043C93v32Ev
  virtual void  v33(); // _ZN7S2043C93v33Ev
  virtual void  v34(); // _ZN7S2043C93v34Ev
  virtual void  v35(); // _ZN7S2043C93v35Ev
  virtual void  v36(); // _ZN7S2043C93v36Ev
  virtual void  v37(); // _ZN7S2043C93v37Ev
  virtual void  v38(); // _ZN7S2043C93v38Ev
  S2043C9(); // tgen
};
//SIG(-1 S2043C9) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2]}


 S2043C9 ::~S2043C9(){ note_dtor("S2043C9", this);}
void  S2043C9 ::v25(){vfunc_called(this, "_ZN7S2043C93v25Ev");}
void  S2043C9 ::v26(){vfunc_called(this, "_ZN7S2043C93v26Ev");}
void  S2043C9 ::v27(){vfunc_called(this, "_ZN7S2043C93v27Ev");}
void  S2043C9 ::v28(){vfunc_called(this, "_ZN7S2043C93v28Ev");}
void  S2043C9 ::v29(){vfunc_called(this, "_ZN7S2043C93v29Ev");}
void  S2043C9 ::v30(){vfunc_called(this, "_ZN7S2043C93v30Ev");}
void  S2043C9 ::v31(){vfunc_called(this, "_ZN7S2043C93v31Ev");}
void  S2043C9 ::v32(){vfunc_called(this, "_ZN7S2043C93v32Ev");}
void  S2043C9 ::v33(){vfunc_called(this, "_ZN7S2043C93v33Ev");}
void  S2043C9 ::v34(){vfunc_called(this, "_ZN7S2043C93v34Ev");}
void  S2043C9 ::v35(){vfunc_called(this, "_ZN7S2043C93v35Ev");}
void  S2043C9 ::v36(){vfunc_called(this, "_ZN7S2043C93v36Ev");}
void  S2043C9 ::v37(){vfunc_called(this, "_ZN7S2043C93v37Ev");}
void  S2043C9 ::v38(){vfunc_called(this, "_ZN7S2043C93v38Ev");}
S2043C9 ::S2043C9(){ note_ctor("S2043C9", this);} // tgen

static void Test_S2043C9()
{
  extern Class_Descriptor cd_S2043C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S2043C9, buf);
    S2043C9 *dp, &lv = *(dp=new (buf) S2043C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S2043C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2043C9)");
    check_field_offset(lv, s2043c9f0, ABISELECT(8,4), "S2043C9.s2043c9f0");
    test_class_info(&lv, &cd_S2043C9);
    dp->~S2043C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2043C9(Test_S2043C9, "S2043C9", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN7S2043C9C1Ev();
extern void _ZN7S2043C9D1Ev();
Name_Map name_map_S2043C9[] = {
  NSPAIR(_ZN7S2043C9C1Ev),
  NSPAIR(_ZN7S2043C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2043C9[];
extern void _ZN7S2043C9D1Ev();
extern void _ZN7S2043C9D0Ev();
extern void _ZN7S2043C93v25Ev();
extern void _ZN7S2043C93v26Ev();
extern void _ZN7S2043C93v27Ev();
extern void _ZN7S2043C93v28Ev();
extern void _ZN7S2043C93v29Ev();
extern void _ZN7S2043C93v30Ev();
extern void _ZN7S2043C93v31Ev();
extern void _ZN7S2043C93v32Ev();
extern void _ZN7S2043C93v33Ev();
extern void _ZN7S2043C93v34Ev();
extern void _ZN7S2043C93v35Ev();
extern void _ZN7S2043C93v36Ev();
extern void _ZN7S2043C93v37Ev();
extern void _ZN7S2043C93v38Ev();
static  VTBL_ENTRY vtc_S2043C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2043C9[0]),
  (VTBL_ENTRY)&_ZN7S2043C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2043C9D0Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v27Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v28Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v29Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v30Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v31Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v32Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v33Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v34Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v35Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v36Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v37Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v38Ev,
};
extern VTBL_ENTRY _ZTI7S2043C9[];
extern  VTBL_ENTRY _ZTV7S2043C9[];
Class_Descriptor cd_S2043C9 = {  "S2043C9", // class name
  0,0,//no base classes
  &(vtc_S2043C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI7S2043C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2043C9),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2043C8  : S2043C9 {
  ::S10183C5_nt s2043c8f0;
  virtual  ~S2043C8(); // _ZN7S2043C8D1Ev
  virtual void  v39(); // _ZN7S2043C83v39Ev
  virtual void  v40(); // _ZN7S2043C83v40Ev
  virtual void  v41(); // _ZN7S2043C83v41Ev
  virtual void  v42(); // _ZN7S2043C83v42Ev
  virtual void  v43(); // _ZN7S2043C83v43Ev
  virtual void  v44(); // _ZN7S2043C83v44Ev
  virtual void  v45(); // _ZN7S2043C83v45Ev
  S2043C8(); // tgen
};
//SIG(-1 S2043C8) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m Fp Fi[2] FC4{ m}}}


 S2043C8 ::~S2043C8(){ note_dtor("S2043C8", this);}
void  S2043C8 ::v39(){vfunc_called(this, "_ZN7S2043C83v39Ev");}
void  S2043C8 ::v40(){vfunc_called(this, "_ZN7S2043C83v40Ev");}
void  S2043C8 ::v41(){vfunc_called(this, "_ZN7S2043C83v41Ev");}
void  S2043C8 ::v42(){vfunc_called(this, "_ZN7S2043C83v42Ev");}
void  S2043C8 ::v43(){vfunc_called(this, "_ZN7S2043C83v43Ev");}
void  S2043C8 ::v44(){vfunc_called(this, "_ZN7S2043C83v44Ev");}
void  S2043C8 ::v45(){vfunc_called(this, "_ZN7S2043C83v45Ev");}
S2043C8 ::S2043C8(){ note_ctor("S2043C8", this);} // tgen

static void Test_S2043C8()
{
  extern Class_Descriptor cd_S2043C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_S2043C8, buf);
    S2043C8 *dp, &lv = *(dp=new (buf) S2043C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S2043C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2043C8)");
    check_base_class_offset(lv, (S2043C9*), 0, "S2043C8");
    check_field_offset(lv, s2043c8f0, ABISELECT(24,12), "S2043C8.s2043c8f0");
    test_class_info(&lv, &cd_S2043C8);
    dp->~S2043C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2043C8(Test_S2043C8, "S2043C8", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN7S2043C8C1Ev();
extern void _ZN7S2043C8D1Ev();
Name_Map name_map_S2043C8[] = {
  NSPAIR(_ZN7S2043C8C1Ev),
  NSPAIR(_ZN7S2043C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2043C9;
extern VTBL_ENTRY _ZTI7S2043C9[];
extern  VTBL_ENTRY _ZTV7S2043C9[];
static Base_Class bases_S2043C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2043C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2043C8[];
extern void _ZN7S2043C8D1Ev();
extern void _ZN7S2043C8D0Ev();
extern void _ZN7S2043C93v25Ev();
extern void _ZN7S2043C93v26Ev();
extern void _ZN7S2043C93v27Ev();
extern void _ZN7S2043C93v28Ev();
extern void _ZN7S2043C93v29Ev();
extern void _ZN7S2043C93v30Ev();
extern void _ZN7S2043C93v31Ev();
extern void _ZN7S2043C93v32Ev();
extern void _ZN7S2043C93v33Ev();
extern void _ZN7S2043C93v34Ev();
extern void _ZN7S2043C93v35Ev();
extern void _ZN7S2043C93v36Ev();
extern void _ZN7S2043C93v37Ev();
extern void _ZN7S2043C93v38Ev();
extern void _ZN7S2043C83v39Ev();
extern void _ZN7S2043C83v40Ev();
extern void _ZN7S2043C83v41Ev();
extern void _ZN7S2043C83v42Ev();
extern void _ZN7S2043C83v43Ev();
extern void _ZN7S2043C83v44Ev();
extern void _ZN7S2043C83v45Ev();
static  VTBL_ENTRY vtc_S2043C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2043C8[0]),
  (VTBL_ENTRY)&_ZN7S2043C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2043C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v27Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v28Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v29Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v30Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v31Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v32Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v33Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v34Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v35Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v36Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v37Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v38Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v39Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v40Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v41Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v42Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v43Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v44Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v45Ev,
};
extern VTBL_ENTRY _ZTI7S2043C8[];
extern  VTBL_ENTRY _ZTV7S2043C8[];
Class_Descriptor cd_S2043C8 = {  "S2043C8", // class name
  bases_S2043C8, 1,
  &(vtc_S2043C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI7S2043C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2043C8),25, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2043C1  : S2043C2 , S2043C8 {
  ::S2041C13 s2043c1f0;
  ::S10183C19_nt s2043c1f1;
  int s2043c1f2;
  void *s2043c1f3;
  ::S2041C30_nt s2043c1f4;
  virtual  ~S2043C1(); // _ZN7S2043C1D1Ev
  virtual void  v1(); // _ZN7S2043C12v1Ev
  virtual void  v2(); // _ZN7S2043C12v2Ev
  virtual void  v3(); // _ZN7S2043C12v3Ev
  virtual void  v4(); // _ZN7S2043C12v4Ev
  virtual void  v5(); // _ZN7S2043C12v5Ev
  virtual void  v6(); // _ZN7S2043C12v6Ev
  virtual void  v7(); // _ZN7S2043C12v7Ev
  virtual void  v8(); // _ZN7S2043C12v8Ev
  virtual void  v9(); // _ZN7S2043C12v9Ev
  virtual void  v10(); // _ZN7S2043C13v10Ev
  virtual void  v11(); // _ZN7S2043C13v11Ev
  virtual void  v12(); // _ZN7S2043C13v12Ev
  virtual void  v13(); // _ZN7S2043C13v13Ev
  virtual void  v14(); // _ZN7S2043C13v14Ev
  virtual void  v15(); // _ZN7S2043C13v15Ev
  S2043C1(); // tgen
};
//SIG(1 S2043C1) C1{ BC2{ BC3{ BC4{ vd v16 v17 v18} vd v19 v20 v21} vd v22 v23 v24 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FL[4]} Fc} BC8{ BC9{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 Fp[2]} vd v39 v40 v41 v42 v43 v44 v45 FC10{ m Fp Fi[2] FC11{ m}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC12{ BC13{ vd} Fi FC14{ BC15{ vd v48 v49} vd v46 v47 FC16{ m Fp Fi FC17{ m}} FC16 Fi} FC18{ BC15 vd v50 v51 FC19{ BC15 vd v52 v53 FC16} FC14 FC20{ BC5 BC15 vd v54 v55} FC21{ vd m FC22{ m Fs[6] Fi[2] Fc Fs}} FC16 FC16 Fc[2] Fi FC16 FC16 FC16 FC16 FC16 Fi[3] Fp FC16 FC21 FC16 Fi} FC23{ Fi FC24{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]}} FC20 Fi Fp FC25{ m FC26{ m FL[2]}}}


 S2043C1 ::~S2043C1(){ note_dtor("S2043C1", this);}
void  S2043C1 ::v1(){vfunc_called(this, "_ZN7S2043C12v1Ev");}
void  S2043C1 ::v2(){vfunc_called(this, "_ZN7S2043C12v2Ev");}
void  S2043C1 ::v3(){vfunc_called(this, "_ZN7S2043C12v3Ev");}
void  S2043C1 ::v4(){vfunc_called(this, "_ZN7S2043C12v4Ev");}
void  S2043C1 ::v5(){vfunc_called(this, "_ZN7S2043C12v5Ev");}
void  S2043C1 ::v6(){vfunc_called(this, "_ZN7S2043C12v6Ev");}
void  S2043C1 ::v7(){vfunc_called(this, "_ZN7S2043C12v7Ev");}
void  S2043C1 ::v8(){vfunc_called(this, "_ZN7S2043C12v8Ev");}
void  S2043C1 ::v9(){vfunc_called(this, "_ZN7S2043C12v9Ev");}
void  S2043C1 ::v10(){vfunc_called(this, "_ZN7S2043C13v10Ev");}
void  S2043C1 ::v11(){vfunc_called(this, "_ZN7S2043C13v11Ev");}
void  S2043C1 ::v12(){vfunc_called(this, "_ZN7S2043C13v12Ev");}
void  S2043C1 ::v13(){vfunc_called(this, "_ZN7S2043C13v13Ev");}
void  S2043C1 ::v14(){vfunc_called(this, "_ZN7S2043C13v14Ev");}
void  S2043C1 ::v15(){vfunc_called(this, "_ZN7S2043C13v15Ev");}
S2043C1 ::S2043C1(){ note_ctor("S2043C1", this);} // tgen

static void Test_S2043C1()
{
  extern Class_Descriptor cd_S2043C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(100,144)];
    init_test(&cd_S2043C1, buf);
    S2043C1 *dp, &lv = *(dp=new (buf) S2043C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(792,572), "sizeof(S2043C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2043C1)");
    check_base_class_offset(lv, (S2043C4*)(S2043C3*)(S2043C2*), 0, "S2043C1");
    check_base_class_offset(lv, (S2043C3*)(S2043C2*), 0, "S2043C1");
    check_base_class_offset(lv, (S2043C2*), 0, "S2043C1");
    check_base_class_offset(lv, (S2043C9*)(S2043C8*), ABISELECT(72,56), "S2043C1");
    check_base_class_offset(lv, (S2043C8*), ABISELECT(72,56), "S2043C1");
    check_field_offset(lv, s2043c1f0, ABISELECT(120,84), "S2043C1.s2043c1f0");
    check_field_offset(lv, s2043c1f1, ABISELECT(728,528), "S2043C1.s2043c1f1");
    check_field_offset(lv, s2043c1f2, ABISELECT(760,548), "S2043C1.s2043c1f2");
    check_field_offset(lv, s2043c1f3, ABISELECT(768,552), "S2043C1.s2043c1f3");
    check_field_offset(lv, s2043c1f4, ABISELECT(776,556), "S2043C1.s2043c1f4");
    test_class_info(&lv, &cd_S2043C1);
    dp->~S2043C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2043C1(Test_S2043C1, "S2043C1", ABISELECT(792,572));

#else // __cplusplus

extern void _ZN7S2043C1C1Ev();
extern void _ZN7S2043C1D1Ev();
Name_Map name_map_S2043C1[] = {
  NSPAIR(_ZN7S2043C1C1Ev),
  NSPAIR(_ZN7S2043C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2043C4;
extern VTBL_ENTRY _ZTI7S2043C4[];
extern  VTBL_ENTRY _ZTV7S2043C4[];
extern Class_Descriptor cd_S2043C3;
extern VTBL_ENTRY _ZTI7S2043C3[];
extern  VTBL_ENTRY _ZTV7S2043C3[];
extern Class_Descriptor cd_S2043C2;
extern VTBL_ENTRY _ZTI7S2043C2[];
extern  VTBL_ENTRY _ZTV7S2043C2[];
extern Class_Descriptor cd_S2043C9;
extern VTBL_ENTRY _ZTI7S2043C9[];
extern  VTBL_ENTRY _ZTV7S2043C9[];
extern Class_Descriptor cd_S2043C8;
extern VTBL_ENTRY _ZTI7S2043C8[];
extern  VTBL_ENTRY _ZTV7S2043C8[];
static Base_Class bases_S2043C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2043C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2043C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2043C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2043C9,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2043C8,    ABISELECT(72,56), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2043C1[];
extern void _ZN7S2043C1D1Ev();
extern void _ZN7S2043C1D0Ev();
extern void _ZN7S2043C43v16Ev();
extern void _ZN7S2043C43v17Ev();
extern void _ZN7S2043C43v18Ev();
extern void _ZN7S2043C33v19Ev();
extern void _ZN7S2043C33v20Ev();
extern void _ZN7S2043C33v21Ev();
extern void _ZN7S2043C23v22Ev();
extern void _ZN7S2043C23v23Ev();
extern void _ZN7S2043C23v24Ev();
extern void _ZN7S2043C12v1Ev();
extern void _ZN7S2043C12v2Ev();
extern void _ZN7S2043C12v3Ev();
extern void _ZN7S2043C12v4Ev();
extern void _ZN7S2043C12v5Ev();
extern void _ZN7S2043C12v6Ev();
extern void _ZN7S2043C12v7Ev();
extern void _ZN7S2043C12v8Ev();
extern void _ZN7S2043C12v9Ev();
extern void _ZN7S2043C13v10Ev();
extern void _ZN7S2043C13v11Ev();
extern void _ZN7S2043C13v12Ev();
extern void _ZN7S2043C13v13Ev();
extern void _ZN7S2043C13v14Ev();
extern void _ZN7S2043C13v15Ev();
extern void ABISELECT(_ZThn72_N7S2043C1D1Ev,_ZThn56_N7S2043C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2043C1D0Ev,_ZThn56_N7S2043C1D0Ev)();
extern void _ZN7S2043C93v25Ev();
extern void _ZN7S2043C93v26Ev();
extern void _ZN7S2043C93v27Ev();
extern void _ZN7S2043C93v28Ev();
extern void _ZN7S2043C93v29Ev();
extern void _ZN7S2043C93v30Ev();
extern void _ZN7S2043C93v31Ev();
extern void _ZN7S2043C93v32Ev();
extern void _ZN7S2043C93v33Ev();
extern void _ZN7S2043C93v34Ev();
extern void _ZN7S2043C93v35Ev();
extern void _ZN7S2043C93v36Ev();
extern void _ZN7S2043C93v37Ev();
extern void _ZN7S2043C93v38Ev();
extern void _ZN7S2043C83v39Ev();
extern void _ZN7S2043C83v40Ev();
extern void _ZN7S2043C83v41Ev();
extern void _ZN7S2043C83v42Ev();
extern void _ZN7S2043C83v43Ev();
extern void _ZN7S2043C83v44Ev();
extern void _ZN7S2043C83v45Ev();
static  VTBL_ENTRY vtc_S2043C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2043C1[0]),
  (VTBL_ENTRY)&_ZN7S2043C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2043C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2043C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2043C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2043C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2043C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2043C23v22Ev,
  (VTBL_ENTRY)&_ZN7S2043C23v23Ev,
  (VTBL_ENTRY)&_ZN7S2043C23v24Ev,
  (VTBL_ENTRY)&_ZN7S2043C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2043C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2043C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2043C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2043C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2043C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2043C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2043C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2043C12v9Ev,
  (VTBL_ENTRY)&_ZN7S2043C13v10Ev,
  (VTBL_ENTRY)&_ZN7S2043C13v11Ev,
  (VTBL_ENTRY)&_ZN7S2043C13v12Ev,
  (VTBL_ENTRY)&_ZN7S2043C13v13Ev,
  (VTBL_ENTRY)&_ZN7S2043C13v14Ev,
  (VTBL_ENTRY)&_ZN7S2043C13v15Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S2043C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2043C1D1Ev,_ZThn56_N7S2043C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2043C1D0Ev,_ZThn56_N7S2043C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2043C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v27Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v28Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v29Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v30Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v31Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v32Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v33Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v34Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v35Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v36Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v37Ev,
  (VTBL_ENTRY)&_ZN7S2043C93v38Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v39Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v40Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v41Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v42Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v43Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v44Ev,
  (VTBL_ENTRY)&_ZN7S2043C83v45Ev,
};
extern VTBL_ENTRY _ZTI7S2043C1[];
extern  VTBL_ENTRY _ZTV7S2043C1[];
Class_Descriptor cd_S2043C1 = {  "S2043C1", // class name
  bases_S2043C1, 5,
  &(vtc_S2043C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(792,572), // object size
  NSPAIRA(_ZTI7S2043C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2043C1),53, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2017C4  {
  virtual  ~S2017C4(); // _ZN7S2017C4D1Ev
  virtual void  v11(); // _ZN7S2017C43v11Ev
  virtual void  v12(); // _ZN7S2017C43v12Ev
  virtual void  v13(); // _ZN7S2017C43v13Ev
  S2017C4(); // tgen
};
//SIG(-1 S2017C4) C1{ vd v1 v2 v3}


 S2017C4 ::~S2017C4(){ note_dtor("S2017C4", this);}
void  S2017C4 ::v11(){vfunc_called(this, "_ZN7S2017C43v11Ev");}
void  S2017C4 ::v12(){vfunc_called(this, "_ZN7S2017C43v12Ev");}
void  S2017C4 ::v13(){vfunc_called(this, "_ZN7S2017C43v13Ev");}
S2017C4 ::S2017C4(){ note_ctor("S2017C4", this);} // tgen

static void Test_S2017C4()
{
  extern Class_Descriptor cd_S2017C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2017C4, buf);
    S2017C4 *dp, &lv = *(dp=new (buf) S2017C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2017C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2017C4)");
    test_class_info(&lv, &cd_S2017C4);
    dp->~S2017C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2017C4(Test_S2017C4, "S2017C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2017C4C1Ev();
extern void _ZN7S2017C4D1Ev();
Name_Map name_map_S2017C4[] = {
  NSPAIR(_ZN7S2017C4C1Ev),
  NSPAIR(_ZN7S2017C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2017C4[];
extern void _ZN7S2017C4D1Ev();
extern void _ZN7S2017C4D0Ev();
extern void _ZN7S2017C43v11Ev();
extern void _ZN7S2017C43v12Ev();
extern void _ZN7S2017C43v13Ev();
static  VTBL_ENTRY vtc_S2017C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2017C4[0]),
  (VTBL_ENTRY)&_ZN7S2017C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2017C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v13Ev,
};
extern VTBL_ENTRY _ZTI7S2017C4[];
extern  VTBL_ENTRY _ZTV7S2017C4[];
Class_Descriptor cd_S2017C4 = {  "S2017C4", // class name
  0,0,//no base classes
  &(vtc_S2017C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2017C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2017C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2017C3  : S2017C4 {
  virtual  ~S2017C3(); // _ZN7S2017C3D1Ev
  virtual void  v14(); // _ZN7S2017C33v14Ev
  virtual void  v15(); // _ZN7S2017C33v15Ev
  virtual void  v16(); // _ZN7S2017C33v16Ev
  S2017C3(); // tgen
};
//SIG(-1 S2017C3) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3}


 S2017C3 ::~S2017C3(){ note_dtor("S2017C3", this);}
void  S2017C3 ::v14(){vfunc_called(this, "_ZN7S2017C33v14Ev");}
void  S2017C3 ::v15(){vfunc_called(this, "_ZN7S2017C33v15Ev");}
void  S2017C3 ::v16(){vfunc_called(this, "_ZN7S2017C33v16Ev");}
S2017C3 ::S2017C3(){ note_ctor("S2017C3", this);} // tgen

static void Test_S2017C3()
{
  extern Class_Descriptor cd_S2017C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2017C3, buf);
    S2017C3 *dp, &lv = *(dp=new (buf) S2017C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2017C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2017C3)");
    check_base_class_offset(lv, (S2017C4*), 0, "S2017C3");
    test_class_info(&lv, &cd_S2017C3);
    dp->~S2017C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2017C3(Test_S2017C3, "S2017C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2017C3C1Ev();
extern void _ZN7S2017C3D1Ev();
Name_Map name_map_S2017C3[] = {
  NSPAIR(_ZN7S2017C3C1Ev),
  NSPAIR(_ZN7S2017C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2017C4;
extern VTBL_ENTRY _ZTI7S2017C4[];
extern  VTBL_ENTRY _ZTV7S2017C4[];
static Base_Class bases_S2017C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2017C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2017C3[];
extern void _ZN7S2017C3D1Ev();
extern void _ZN7S2017C3D0Ev();
extern void _ZN7S2017C43v11Ev();
extern void _ZN7S2017C43v12Ev();
extern void _ZN7S2017C43v13Ev();
extern void _ZN7S2017C33v14Ev();
extern void _ZN7S2017C33v15Ev();
extern void _ZN7S2017C33v16Ev();
static  VTBL_ENTRY vtc_S2017C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2017C3[0]),
  (VTBL_ENTRY)&_ZN7S2017C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2017C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2017C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2017C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2017C33v16Ev,
};
extern VTBL_ENTRY _ZTI7S2017C3[];
extern  VTBL_ENTRY _ZTV7S2017C3[];
Class_Descriptor cd_S2017C3 = {  "S2017C3", // class name
  bases_S2017C3, 1,
  &(vtc_S2017C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2017C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2017C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2017C2  : S2017C3 {
  ::S10183C20 s2017c2f0;
  ::S10184C7_nt s2017c2f1;
  char s2017c2f2;
  virtual  ~S2017C2(); // _ZN7S2017C2D1Ev
  virtual void  v17(); // _ZN7S2017C23v17Ev
  virtual void  v18(); // _ZN7S2017C23v18Ev
  virtual void  v19(); // _ZN7S2017C23v19Ev
  S2017C2(); // tgen
};
//SIG(-1 S2017C2) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc}


 S2017C2 ::~S2017C2(){ note_dtor("S2017C2", this);}
void  S2017C2 ::v17(){vfunc_called(this, "_ZN7S2017C23v17Ev");}
void  S2017C2 ::v18(){vfunc_called(this, "_ZN7S2017C23v18Ev");}
void  S2017C2 ::v19(){vfunc_called(this, "_ZN7S2017C23v19Ev");}
S2017C2 ::S2017C2(){ note_ctor("S2017C2", this);} // tgen

static void Test_S2017C2()
{
  extern Class_Descriptor cd_S2017C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2017C2, buf);
    S2017C2 *dp, &lv = *(dp=new (buf) S2017C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2017C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2017C2)");
    check_base_class_offset(lv, (S2017C4*)(S2017C3*), 0, "S2017C2");
    check_base_class_offset(lv, (S2017C3*), 0, "S2017C2");
    check_field_offset(lv, s2017c2f0, ABISELECT(8,4), "S2017C2.s2017c2f0");
    check_field_offset(lv, s2017c2f1, ABISELECT(32,20), "S2017C2.s2017c2f1");
    check_field_offset(lv, s2017c2f2, ABISELECT(64,52), "S2017C2.s2017c2f2");
    test_class_info(&lv, &cd_S2017C2);
    dp->~S2017C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2017C2(Test_S2017C2, "S2017C2", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2017C2C1Ev();
extern void _ZN7S2017C2D1Ev();
Name_Map name_map_S2017C2[] = {
  NSPAIR(_ZN7S2017C2C1Ev),
  NSPAIR(_ZN7S2017C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2017C4;
extern VTBL_ENTRY _ZTI7S2017C4[];
extern  VTBL_ENTRY _ZTV7S2017C4[];
extern Class_Descriptor cd_S2017C3;
extern VTBL_ENTRY _ZTI7S2017C3[];
extern  VTBL_ENTRY _ZTV7S2017C3[];
static Base_Class bases_S2017C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2017C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2017C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2017C2[];
extern void _ZN7S2017C2D1Ev();
extern void _ZN7S2017C2D0Ev();
extern void _ZN7S2017C43v11Ev();
extern void _ZN7S2017C43v12Ev();
extern void _ZN7S2017C43v13Ev();
extern void _ZN7S2017C33v14Ev();
extern void _ZN7S2017C33v15Ev();
extern void _ZN7S2017C33v16Ev();
extern void _ZN7S2017C23v17Ev();
extern void _ZN7S2017C23v18Ev();
extern void _ZN7S2017C23v19Ev();
static  VTBL_ENTRY vtc_S2017C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2017C2[0]),
  (VTBL_ENTRY)&_ZN7S2017C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2017C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2017C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2017C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2017C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2017C23v17Ev,
  (VTBL_ENTRY)&_ZN7S2017C23v18Ev,
  (VTBL_ENTRY)&_ZN7S2017C23v19Ev,
};
extern VTBL_ENTRY _ZTI7S2017C2[];
extern  VTBL_ENTRY _ZTV7S2017C2[];
Class_Descriptor cd_S2017C2 = {  "S2017C2", // class name
  bases_S2017C2, 2,
  &(vtc_S2017C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2017C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2017C2),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2017C10  {
  void *s2017c10f0[2];
  virtual  ~S2017C10(); // _ZN8S2017C10D1Ev
  virtual void  v20(); // _ZN8S2017C103v20Ev
  virtual void  v21(); // _ZN8S2017C103v21Ev
  virtual void  v22(); // _ZN8S2017C103v22Ev
  virtual void  v23(); // _ZN8S2017C103v23Ev
  virtual void  v24(); // _ZN8S2017C103v24Ev
  virtual void  v25(); // _ZN8S2017C103v25Ev
  virtual void  v26(); // _ZN8S2017C103v26Ev
  virtual void  v27(); // _ZN8S2017C103v27Ev
  virtual void  v28(); // _ZN8S2017C103v28Ev
  virtual void  v29(); // _ZN8S2017C103v29Ev
  virtual void  v30(); // _ZN8S2017C103v30Ev
  virtual void  v31(); // _ZN8S2017C103v31Ev
  virtual void  v32(); // _ZN8S2017C103v32Ev
  virtual void  v33(); // _ZN8S2017C103v33Ev
  S2017C10(); // tgen
};
//SIG(-1 S2017C10) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2]}


 S2017C10 ::~S2017C10(){ note_dtor("S2017C10", this);}
void  S2017C10 ::v20(){vfunc_called(this, "_ZN8S2017C103v20Ev");}
void  S2017C10 ::v21(){vfunc_called(this, "_ZN8S2017C103v21Ev");}
void  S2017C10 ::v22(){vfunc_called(this, "_ZN8S2017C103v22Ev");}
void  S2017C10 ::v23(){vfunc_called(this, "_ZN8S2017C103v23Ev");}
void  S2017C10 ::v24(){vfunc_called(this, "_ZN8S2017C103v24Ev");}
void  S2017C10 ::v25(){vfunc_called(this, "_ZN8S2017C103v25Ev");}
void  S2017C10 ::v26(){vfunc_called(this, "_ZN8S2017C103v26Ev");}
void  S2017C10 ::v27(){vfunc_called(this, "_ZN8S2017C103v27Ev");}
void  S2017C10 ::v28(){vfunc_called(this, "_ZN8S2017C103v28Ev");}
void  S2017C10 ::v29(){vfunc_called(this, "_ZN8S2017C103v29Ev");}
void  S2017C10 ::v30(){vfunc_called(this, "_ZN8S2017C103v30Ev");}
void  S2017C10 ::v31(){vfunc_called(this, "_ZN8S2017C103v31Ev");}
void  S2017C10 ::v32(){vfunc_called(this, "_ZN8S2017C103v32Ev");}
void  S2017C10 ::v33(){vfunc_called(this, "_ZN8S2017C103v33Ev");}
S2017C10 ::S2017C10(){ note_ctor("S2017C10", this);} // tgen

static void Test_S2017C10()
{
  extern Class_Descriptor cd_S2017C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S2017C10, buf);
    S2017C10 *dp, &lv = *(dp=new (buf) S2017C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S2017C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2017C10)");
    check_field_offset(lv, s2017c10f0, ABISELECT(8,4), "S2017C10.s2017c10f0");
    test_class_info(&lv, &cd_S2017C10);
    dp->~S2017C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2017C10(Test_S2017C10, "S2017C10", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S2017C10C1Ev();
extern void _ZN8S2017C10D1Ev();
Name_Map name_map_S2017C10[] = {
  NSPAIR(_ZN8S2017C10C1Ev),
  NSPAIR(_ZN8S2017C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2017C10[];
extern void _ZN8S2017C10D1Ev();
extern void _ZN8S2017C10D0Ev();
extern void _ZN8S2017C103v20Ev();
extern void _ZN8S2017C103v21Ev();
extern void _ZN8S2017C103v22Ev();
extern void _ZN8S2017C103v23Ev();
extern void _ZN8S2017C103v24Ev();
extern void _ZN8S2017C103v25Ev();
extern void _ZN8S2017C103v26Ev();
extern void _ZN8S2017C103v27Ev();
extern void _ZN8S2017C103v28Ev();
extern void _ZN8S2017C103v29Ev();
extern void _ZN8S2017C103v30Ev();
extern void _ZN8S2017C103v31Ev();
extern void _ZN8S2017C103v32Ev();
extern void _ZN8S2017C103v33Ev();
static  VTBL_ENTRY vtc_S2017C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2017C10[0]),
  (VTBL_ENTRY)&_ZN8S2017C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2017C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v20Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v23Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v24Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v33Ev,
};
extern VTBL_ENTRY _ZTI8S2017C10[];
extern  VTBL_ENTRY _ZTV8S2017C10[];
Class_Descriptor cd_S2017C10 = {  "S2017C10", // class name
  0,0,//no base classes
  &(vtc_S2017C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S2017C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2017C10),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2017C9  : S2017C10 {
  ::S10183C5_nt s2017c9f0;
  virtual  ~S2017C9(); // _ZN7S2017C9D1Ev
  virtual void  v34(); // _ZN7S2017C93v34Ev
  virtual void  v35(); // _ZN7S2017C93v35Ev
  virtual void  v36(); // _ZN7S2017C93v36Ev
  virtual void  v37(); // _ZN7S2017C93v37Ev
  virtual void  v38(); // _ZN7S2017C93v38Ev
  virtual void  v39(); // _ZN7S2017C93v39Ev
  virtual void  v40(); // _ZN7S2017C93v40Ev
  S2017C9(); // tgen
};
//SIG(-1 S2017C9) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m Fp Fi[2] FC4{ m}}}


 S2017C9 ::~S2017C9(){ note_dtor("S2017C9", this);}
void  S2017C9 ::v34(){vfunc_called(this, "_ZN7S2017C93v34Ev");}
void  S2017C9 ::v35(){vfunc_called(this, "_ZN7S2017C93v35Ev");}
void  S2017C9 ::v36(){vfunc_called(this, "_ZN7S2017C93v36Ev");}
void  S2017C9 ::v37(){vfunc_called(this, "_ZN7S2017C93v37Ev");}
void  S2017C9 ::v38(){vfunc_called(this, "_ZN7S2017C93v38Ev");}
void  S2017C9 ::v39(){vfunc_called(this, "_ZN7S2017C93v39Ev");}
void  S2017C9 ::v40(){vfunc_called(this, "_ZN7S2017C93v40Ev");}
S2017C9 ::S2017C9(){ note_ctor("S2017C9", this);} // tgen

static void Test_S2017C9()
{
  extern Class_Descriptor cd_S2017C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_S2017C9, buf);
    S2017C9 *dp, &lv = *(dp=new (buf) S2017C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S2017C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2017C9)");
    check_base_class_offset(lv, (S2017C10*), 0, "S2017C9");
    check_field_offset(lv, s2017c9f0, ABISELECT(24,12), "S2017C9.s2017c9f0");
    test_class_info(&lv, &cd_S2017C9);
    dp->~S2017C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2017C9(Test_S2017C9, "S2017C9", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN7S2017C9C1Ev();
extern void _ZN7S2017C9D1Ev();
Name_Map name_map_S2017C9[] = {
  NSPAIR(_ZN7S2017C9C1Ev),
  NSPAIR(_ZN7S2017C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2017C10;
extern VTBL_ENTRY _ZTI8S2017C10[];
extern  VTBL_ENTRY _ZTV8S2017C10[];
static Base_Class bases_S2017C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2017C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2017C9[];
extern void _ZN7S2017C9D1Ev();
extern void _ZN7S2017C9D0Ev();
extern void _ZN8S2017C103v20Ev();
extern void _ZN8S2017C103v21Ev();
extern void _ZN8S2017C103v22Ev();
extern void _ZN8S2017C103v23Ev();
extern void _ZN8S2017C103v24Ev();
extern void _ZN8S2017C103v25Ev();
extern void _ZN8S2017C103v26Ev();
extern void _ZN8S2017C103v27Ev();
extern void _ZN8S2017C103v28Ev();
extern void _ZN8S2017C103v29Ev();
extern void _ZN8S2017C103v30Ev();
extern void _ZN8S2017C103v31Ev();
extern void _ZN8S2017C103v32Ev();
extern void _ZN8S2017C103v33Ev();
extern void _ZN7S2017C93v34Ev();
extern void _ZN7S2017C93v35Ev();
extern void _ZN7S2017C93v36Ev();
extern void _ZN7S2017C93v37Ev();
extern void _ZN7S2017C93v38Ev();
extern void _ZN7S2017C93v39Ev();
extern void _ZN7S2017C93v40Ev();
static  VTBL_ENTRY vtc_S2017C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2017C9[0]),
  (VTBL_ENTRY)&_ZN7S2017C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2017C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v20Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v23Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v24Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v33Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v34Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v35Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v36Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v37Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v38Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v39Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v40Ev,
};
extern VTBL_ENTRY _ZTI7S2017C9[];
extern  VTBL_ENTRY _ZTV7S2017C9[];
Class_Descriptor cd_S2017C9 = {  "S2017C9", // class name
  bases_S2017C9, 1,
  &(vtc_S2017C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI7S2017C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2017C9),25, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2017C1  : S2017C2 , S2017C9 {
  ::S2041C13 s2017c1f0;
  ::S10184C7_nt s2017c1f1;
  ::S9125C35_nt s2017c1f2;
  virtual  ~S2017C1(); // _ZN7S2017C1D1Ev
  virtual void  v1(); // _ZN7S2017C12v1Ev
  virtual void  v2(); // _ZN7S2017C12v2Ev
  virtual void  v3(); // _ZN7S2017C12v3Ev
  virtual void  v4(); // _ZN7S2017C12v4Ev
  virtual void  v5(); // _ZN7S2017C12v5Ev
  virtual void  v6(); // _ZN7S2017C12v6Ev
  virtual void  v7(); // _ZN7S2017C12v7Ev
  virtual void  v8(); // _ZN7S2017C12v8Ev
  virtual void  v9(); // _ZN7S2017C12v9Ev
  virtual void  v10(); // _ZN7S2017C13v10Ev
  S2017C1(); // tgen
};
//SIG(1 S2017C1) C1{ BC2{ BC3{ BC4{ vd v11 v12 v13} vd v14 v15 v16} vd v17 v18 v19 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FC8{ FL[4]}} Fc} BC9{ BC10{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp[2]} vd v34 v35 v36 v37 v38 v39 v40 FC11{ m Fp Fi[2] FC12{ m}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 FC13{ BC14{ vd} Fi FC15{ BC16{ vd v43 v44} vd v41 v42 FC17{ m Fp Fi FC18{ m}} FC17 Fi} FC19{ BC16 vd v45 v46 FC20{ BC16 vd v47 v48 FC17} FC15 FC21{ BC5 BC16 vd v49 v50} FC22{ vd m FC23{ m Fs[6] Fi[2] Fc Fs}} FC17 FC17 Fc[2] Fi FC17 FC17 FC17 FC17 FC17 Fi[3] Fp FC17 FC22 FC17 Fi} FC24{ Fi FC25{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]}} FC7 FC26{ m Fp Fi[2] FC6}}


 S2017C1 ::~S2017C1(){ note_dtor("S2017C1", this);}
void  S2017C1 ::v1(){vfunc_called(this, "_ZN7S2017C12v1Ev");}
void  S2017C1 ::v2(){vfunc_called(this, "_ZN7S2017C12v2Ev");}
void  S2017C1 ::v3(){vfunc_called(this, "_ZN7S2017C12v3Ev");}
void  S2017C1 ::v4(){vfunc_called(this, "_ZN7S2017C12v4Ev");}
void  S2017C1 ::v5(){vfunc_called(this, "_ZN7S2017C12v5Ev");}
void  S2017C1 ::v6(){vfunc_called(this, "_ZN7S2017C12v6Ev");}
void  S2017C1 ::v7(){vfunc_called(this, "_ZN7S2017C12v7Ev");}
void  S2017C1 ::v8(){vfunc_called(this, "_ZN7S2017C12v8Ev");}
void  S2017C1 ::v9(){vfunc_called(this, "_ZN7S2017C12v9Ev");}
void  S2017C1 ::v10(){vfunc_called(this, "_ZN7S2017C13v10Ev");}
S2017C1 ::S2017C1(){ note_ctor("S2017C1", this);} // tgen

static void Test_S2017C1()
{
  extern Class_Descriptor cd_S2017C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(99,145)];
    init_test(&cd_S2017C1, buf);
    S2017C1 *dp, &lv = *(dp=new (buf) S2017C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(784,576), "sizeof(S2017C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2017C1)");
    check_base_class_offset(lv, (S2017C4*)(S2017C3*)(S2017C2*), 0, "S2017C1");
    check_base_class_offset(lv, (S2017C3*)(S2017C2*), 0, "S2017C1");
    check_base_class_offset(lv, (S2017C2*), 0, "S2017C1");
    check_base_class_offset(lv, (S2017C10*)(S2017C9*), ABISELECT(72,56), "S2017C1");
    check_base_class_offset(lv, (S2017C9*), ABISELECT(72,56), "S2017C1");
    check_field_offset(lv, s2017c1f0, ABISELECT(120,84), "S2017C1.s2017c1f0");
    check_field_offset(lv, s2017c1f1, ABISELECT(728,528), "S2017C1.s2017c1f1");
    check_field_offset(lv, s2017c1f2, ABISELECT(760,560), "S2017C1.s2017c1f2");
    test_class_info(&lv, &cd_S2017C1);
    dp->~S2017C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2017C1(Test_S2017C1, "S2017C1", ABISELECT(784,576));

#else // __cplusplus

extern void _ZN7S2017C1C1Ev();
extern void _ZN7S2017C1D1Ev();
Name_Map name_map_S2017C1[] = {
  NSPAIR(_ZN7S2017C1C1Ev),
  NSPAIR(_ZN7S2017C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2017C4;
extern VTBL_ENTRY _ZTI7S2017C4[];
extern  VTBL_ENTRY _ZTV7S2017C4[];
extern Class_Descriptor cd_S2017C3;
extern VTBL_ENTRY _ZTI7S2017C3[];
extern  VTBL_ENTRY _ZTV7S2017C3[];
extern Class_Descriptor cd_S2017C2;
extern VTBL_ENTRY _ZTI7S2017C2[];
extern  VTBL_ENTRY _ZTV7S2017C2[];
extern Class_Descriptor cd_S2017C10;
extern VTBL_ENTRY _ZTI8S2017C10[];
extern  VTBL_ENTRY _ZTV8S2017C10[];
extern Class_Descriptor cd_S2017C9;
extern VTBL_ENTRY _ZTI7S2017C9[];
extern  VTBL_ENTRY _ZTV7S2017C9[];
static Base_Class bases_S2017C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2017C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2017C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2017C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2017C10,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2017C9,    ABISELECT(72,56), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2017C1[];
extern void _ZN7S2017C1D1Ev();
extern void _ZN7S2017C1D0Ev();
extern void _ZN7S2017C43v11Ev();
extern void _ZN7S2017C43v12Ev();
extern void _ZN7S2017C43v13Ev();
extern void _ZN7S2017C33v14Ev();
extern void _ZN7S2017C33v15Ev();
extern void _ZN7S2017C33v16Ev();
extern void _ZN7S2017C23v17Ev();
extern void _ZN7S2017C23v18Ev();
extern void _ZN7S2017C23v19Ev();
extern void _ZN7S2017C12v1Ev();
extern void _ZN7S2017C12v2Ev();
extern void _ZN7S2017C12v3Ev();
extern void _ZN7S2017C12v4Ev();
extern void _ZN7S2017C12v5Ev();
extern void _ZN7S2017C12v6Ev();
extern void _ZN7S2017C12v7Ev();
extern void _ZN7S2017C12v8Ev();
extern void _ZN7S2017C12v9Ev();
extern void _ZN7S2017C13v10Ev();
extern void ABISELECT(_ZThn72_N7S2017C1D1Ev,_ZThn56_N7S2017C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2017C1D0Ev,_ZThn56_N7S2017C1D0Ev)();
extern void _ZN8S2017C103v20Ev();
extern void _ZN8S2017C103v21Ev();
extern void _ZN8S2017C103v22Ev();
extern void _ZN8S2017C103v23Ev();
extern void _ZN8S2017C103v24Ev();
extern void _ZN8S2017C103v25Ev();
extern void _ZN8S2017C103v26Ev();
extern void _ZN8S2017C103v27Ev();
extern void _ZN8S2017C103v28Ev();
extern void _ZN8S2017C103v29Ev();
extern void _ZN8S2017C103v30Ev();
extern void _ZN8S2017C103v31Ev();
extern void _ZN8S2017C103v32Ev();
extern void _ZN8S2017C103v33Ev();
extern void _ZN7S2017C93v34Ev();
extern void _ZN7S2017C93v35Ev();
extern void _ZN7S2017C93v36Ev();
extern void _ZN7S2017C93v37Ev();
extern void _ZN7S2017C93v38Ev();
extern void _ZN7S2017C93v39Ev();
extern void _ZN7S2017C93v40Ev();
static  VTBL_ENTRY vtc_S2017C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2017C1[0]),
  (VTBL_ENTRY)&_ZN7S2017C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2017C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2017C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2017C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2017C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2017C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2017C23v17Ev,
  (VTBL_ENTRY)&_ZN7S2017C23v18Ev,
  (VTBL_ENTRY)&_ZN7S2017C23v19Ev,
  (VTBL_ENTRY)&_ZN7S2017C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2017C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2017C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2017C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2017C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2017C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2017C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2017C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2017C12v9Ev,
  (VTBL_ENTRY)&_ZN7S2017C13v10Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S2017C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2017C1D1Ev,_ZThn56_N7S2017C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2017C1D0Ev,_ZThn56_N7S2017C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2017C103v20Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v23Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v24Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2017C103v33Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v34Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v35Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v36Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v37Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v38Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v39Ev,
  (VTBL_ENTRY)&_ZN7S2017C93v40Ev,
};
extern VTBL_ENTRY _ZTI7S2017C1[];
extern  VTBL_ENTRY _ZTV7S2017C1[];
Class_Descriptor cd_S2017C1 = {  "S2017C1", // class name
  bases_S2017C1, 5,
  &(vtc_S2017C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(784,576), // object size
  NSPAIRA(_ZTI7S2017C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2017C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2016C4  {
  virtual  ~S2016C4(); // _ZN7S2016C4D1Ev
  virtual void  v11(); // _ZN7S2016C43v11Ev
  virtual void  v12(); // _ZN7S2016C43v12Ev
  virtual void  v13(); // _ZN7S2016C43v13Ev
  S2016C4(); // tgen
};
//SIG(-1 S2016C4) C1{ vd v1 v2 v3}


 S2016C4 ::~S2016C4(){ note_dtor("S2016C4", this);}
void  S2016C4 ::v11(){vfunc_called(this, "_ZN7S2016C43v11Ev");}
void  S2016C4 ::v12(){vfunc_called(this, "_ZN7S2016C43v12Ev");}
void  S2016C4 ::v13(){vfunc_called(this, "_ZN7S2016C43v13Ev");}
S2016C4 ::S2016C4(){ note_ctor("S2016C4", this);} // tgen

static void Test_S2016C4()
{
  extern Class_Descriptor cd_S2016C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2016C4, buf);
    S2016C4 *dp, &lv = *(dp=new (buf) S2016C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2016C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2016C4)");
    test_class_info(&lv, &cd_S2016C4);
    dp->~S2016C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2016C4(Test_S2016C4, "S2016C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2016C4C1Ev();
extern void _ZN7S2016C4D1Ev();
Name_Map name_map_S2016C4[] = {
  NSPAIR(_ZN7S2016C4C1Ev),
  NSPAIR(_ZN7S2016C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2016C4[];
extern void _ZN7S2016C4D1Ev();
extern void _ZN7S2016C4D0Ev();
extern void _ZN7S2016C43v11Ev();
extern void _ZN7S2016C43v12Ev();
extern void _ZN7S2016C43v13Ev();
static  VTBL_ENTRY vtc_S2016C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2016C4[0]),
  (VTBL_ENTRY)&_ZN7S2016C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2016C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v13Ev,
};
extern VTBL_ENTRY _ZTI7S2016C4[];
extern  VTBL_ENTRY _ZTV7S2016C4[];
Class_Descriptor cd_S2016C4 = {  "S2016C4", // class name
  0,0,//no base classes
  &(vtc_S2016C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2016C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2016C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2016C3  : S2016C4 {
  virtual  ~S2016C3(); // _ZN7S2016C3D1Ev
  virtual void  v14(); // _ZN7S2016C33v14Ev
  virtual void  v15(); // _ZN7S2016C33v15Ev
  virtual void  v16(); // _ZN7S2016C33v16Ev
  S2016C3(); // tgen
};
//SIG(-1 S2016C3) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3}


 S2016C3 ::~S2016C3(){ note_dtor("S2016C3", this);}
void  S2016C3 ::v14(){vfunc_called(this, "_ZN7S2016C33v14Ev");}
void  S2016C3 ::v15(){vfunc_called(this, "_ZN7S2016C33v15Ev");}
void  S2016C3 ::v16(){vfunc_called(this, "_ZN7S2016C33v16Ev");}
S2016C3 ::S2016C3(){ note_ctor("S2016C3", this);} // tgen

static void Test_S2016C3()
{
  extern Class_Descriptor cd_S2016C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2016C3, buf);
    S2016C3 *dp, &lv = *(dp=new (buf) S2016C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2016C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2016C3)");
    check_base_class_offset(lv, (S2016C4*), 0, "S2016C3");
    test_class_info(&lv, &cd_S2016C3);
    dp->~S2016C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2016C3(Test_S2016C3, "S2016C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2016C3C1Ev();
extern void _ZN7S2016C3D1Ev();
Name_Map name_map_S2016C3[] = {
  NSPAIR(_ZN7S2016C3C1Ev),
  NSPAIR(_ZN7S2016C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2016C4;
extern VTBL_ENTRY _ZTI7S2016C4[];
extern  VTBL_ENTRY _ZTV7S2016C4[];
static Base_Class bases_S2016C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2016C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2016C3[];
extern void _ZN7S2016C3D1Ev();
extern void _ZN7S2016C3D0Ev();
extern void _ZN7S2016C43v11Ev();
extern void _ZN7S2016C43v12Ev();
extern void _ZN7S2016C43v13Ev();
extern void _ZN7S2016C33v14Ev();
extern void _ZN7S2016C33v15Ev();
extern void _ZN7S2016C33v16Ev();
static  VTBL_ENTRY vtc_S2016C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2016C3[0]),
  (VTBL_ENTRY)&_ZN7S2016C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2016C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2016C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2016C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2016C33v16Ev,
};
extern VTBL_ENTRY _ZTI7S2016C3[];
extern  VTBL_ENTRY _ZTV7S2016C3[];
Class_Descriptor cd_S2016C3 = {  "S2016C3", // class name
  bases_S2016C3, 1,
  &(vtc_S2016C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2016C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2016C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2016C2  : S2016C3 {
  ::S10183C20 s2016c2f0;
  ::S10183C7_nt s2016c2f1;
  char s2016c2f2;
  virtual  ~S2016C2(); // _ZN7S2016C2D1Ev
  virtual void  v17(); // _ZN7S2016C23v17Ev
  virtual void  v18(); // _ZN7S2016C23v18Ev
  virtual void  v19(); // _ZN7S2016C23v19Ev
  S2016C2(); // tgen
};
//SIG(-1 S2016C2) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc}


 S2016C2 ::~S2016C2(){ note_dtor("S2016C2", this);}
void  S2016C2 ::v17(){vfunc_called(this, "_ZN7S2016C23v17Ev");}
void  S2016C2 ::v18(){vfunc_called(this, "_ZN7S2016C23v18Ev");}
void  S2016C2 ::v19(){vfunc_called(this, "_ZN7S2016C23v19Ev");}
S2016C2 ::S2016C2(){ note_ctor("S2016C2", this);} // tgen

static void Test_S2016C2()
{
  extern Class_Descriptor cd_S2016C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2016C2, buf);
    S2016C2 *dp, &lv = *(dp=new (buf) S2016C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2016C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2016C2)");
    check_base_class_offset(lv, (S2016C4*)(S2016C3*), 0, "S2016C2");
    check_base_class_offset(lv, (S2016C3*), 0, "S2016C2");
    check_field_offset(lv, s2016c2f0, ABISELECT(8,4), "S2016C2.s2016c2f0");
    check_field_offset(lv, s2016c2f1, ABISELECT(32,20), "S2016C2.s2016c2f1");
    check_field_offset(lv, s2016c2f2, ABISELECT(64,36), "S2016C2.s2016c2f2");
    test_class_info(&lv, &cd_S2016C2);
    dp->~S2016C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2016C2(Test_S2016C2, "S2016C2", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2016C2C1Ev();
extern void _ZN7S2016C2D1Ev();
Name_Map name_map_S2016C2[] = {
  NSPAIR(_ZN7S2016C2C1Ev),
  NSPAIR(_ZN7S2016C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2016C4;
extern VTBL_ENTRY _ZTI7S2016C4[];
extern  VTBL_ENTRY _ZTV7S2016C4[];
extern Class_Descriptor cd_S2016C3;
extern VTBL_ENTRY _ZTI7S2016C3[];
extern  VTBL_ENTRY _ZTV7S2016C3[];
static Base_Class bases_S2016C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2016C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2016C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2016C2[];
extern void _ZN7S2016C2D1Ev();
extern void _ZN7S2016C2D0Ev();
extern void _ZN7S2016C43v11Ev();
extern void _ZN7S2016C43v12Ev();
extern void _ZN7S2016C43v13Ev();
extern void _ZN7S2016C33v14Ev();
extern void _ZN7S2016C33v15Ev();
extern void _ZN7S2016C33v16Ev();
extern void _ZN7S2016C23v17Ev();
extern void _ZN7S2016C23v18Ev();
extern void _ZN7S2016C23v19Ev();
static  VTBL_ENTRY vtc_S2016C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2016C2[0]),
  (VTBL_ENTRY)&_ZN7S2016C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2016C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2016C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2016C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2016C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2016C23v17Ev,
  (VTBL_ENTRY)&_ZN7S2016C23v18Ev,
  (VTBL_ENTRY)&_ZN7S2016C23v19Ev,
};
extern VTBL_ENTRY _ZTI7S2016C2[];
extern  VTBL_ENTRY _ZTV7S2016C2[];
Class_Descriptor cd_S2016C2 = {  "S2016C2", // class name
  bases_S2016C2, 2,
  &(vtc_S2016C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2016C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2016C2),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2016C10  {
  void *s2016c10f0[2];
  virtual  ~S2016C10(); // _ZN8S2016C10D1Ev
  virtual void  v20(); // _ZN8S2016C103v20Ev
  virtual void  v21(); // _ZN8S2016C103v21Ev
  virtual void  v22(); // _ZN8S2016C103v22Ev
  virtual void  v23(); // _ZN8S2016C103v23Ev
  virtual void  v24(); // _ZN8S2016C103v24Ev
  virtual void  v25(); // _ZN8S2016C103v25Ev
  virtual void  v26(); // _ZN8S2016C103v26Ev
  virtual void  v27(); // _ZN8S2016C103v27Ev
  virtual void  v28(); // _ZN8S2016C103v28Ev
  virtual void  v29(); // _ZN8S2016C103v29Ev
  virtual void  v30(); // _ZN8S2016C103v30Ev
  virtual void  v31(); // _ZN8S2016C103v31Ev
  virtual void  v32(); // _ZN8S2016C103v32Ev
  virtual void  v33(); // _ZN8S2016C103v33Ev
  S2016C10(); // tgen
};
//SIG(-1 S2016C10) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2]}


 S2016C10 ::~S2016C10(){ note_dtor("S2016C10", this);}
void  S2016C10 ::v20(){vfunc_called(this, "_ZN8S2016C103v20Ev");}
void  S2016C10 ::v21(){vfunc_called(this, "_ZN8S2016C103v21Ev");}
void  S2016C10 ::v22(){vfunc_called(this, "_ZN8S2016C103v22Ev");}
void  S2016C10 ::v23(){vfunc_called(this, "_ZN8S2016C103v23Ev");}
void  S2016C10 ::v24(){vfunc_called(this, "_ZN8S2016C103v24Ev");}
void  S2016C10 ::v25(){vfunc_called(this, "_ZN8S2016C103v25Ev");}
void  S2016C10 ::v26(){vfunc_called(this, "_ZN8S2016C103v26Ev");}
void  S2016C10 ::v27(){vfunc_called(this, "_ZN8S2016C103v27Ev");}
void  S2016C10 ::v28(){vfunc_called(this, "_ZN8S2016C103v28Ev");}
void  S2016C10 ::v29(){vfunc_called(this, "_ZN8S2016C103v29Ev");}
void  S2016C10 ::v30(){vfunc_called(this, "_ZN8S2016C103v30Ev");}
void  S2016C10 ::v31(){vfunc_called(this, "_ZN8S2016C103v31Ev");}
void  S2016C10 ::v32(){vfunc_called(this, "_ZN8S2016C103v32Ev");}
void  S2016C10 ::v33(){vfunc_called(this, "_ZN8S2016C103v33Ev");}
S2016C10 ::S2016C10(){ note_ctor("S2016C10", this);} // tgen

static void Test_S2016C10()
{
  extern Class_Descriptor cd_S2016C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S2016C10, buf);
    S2016C10 *dp, &lv = *(dp=new (buf) S2016C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S2016C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2016C10)");
    check_field_offset(lv, s2016c10f0, ABISELECT(8,4), "S2016C10.s2016c10f0");
    test_class_info(&lv, &cd_S2016C10);
    dp->~S2016C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2016C10(Test_S2016C10, "S2016C10", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S2016C10C1Ev();
extern void _ZN8S2016C10D1Ev();
Name_Map name_map_S2016C10[] = {
  NSPAIR(_ZN8S2016C10C1Ev),
  NSPAIR(_ZN8S2016C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2016C10[];
extern void _ZN8S2016C10D1Ev();
extern void _ZN8S2016C10D0Ev();
extern void _ZN8S2016C103v20Ev();
extern void _ZN8S2016C103v21Ev();
extern void _ZN8S2016C103v22Ev();
extern void _ZN8S2016C103v23Ev();
extern void _ZN8S2016C103v24Ev();
extern void _ZN8S2016C103v25Ev();
extern void _ZN8S2016C103v26Ev();
extern void _ZN8S2016C103v27Ev();
extern void _ZN8S2016C103v28Ev();
extern void _ZN8S2016C103v29Ev();
extern void _ZN8S2016C103v30Ev();
extern void _ZN8S2016C103v31Ev();
extern void _ZN8S2016C103v32Ev();
extern void _ZN8S2016C103v33Ev();
static  VTBL_ENTRY vtc_S2016C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2016C10[0]),
  (VTBL_ENTRY)&_ZN8S2016C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2016C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v20Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v23Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v24Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v33Ev,
};
extern VTBL_ENTRY _ZTI8S2016C10[];
extern  VTBL_ENTRY _ZTV8S2016C10[];
Class_Descriptor cd_S2016C10 = {  "S2016C10", // class name
  0,0,//no base classes
  &(vtc_S2016C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S2016C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2016C10),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2016C9  : S2016C10 {
  ::S10183C5_nt s2016c9f0;
  virtual  ~S2016C9(); // _ZN7S2016C9D1Ev
  virtual void  v34(); // _ZN7S2016C93v34Ev
  virtual void  v35(); // _ZN7S2016C93v35Ev
  virtual void  v36(); // _ZN7S2016C93v36Ev
  virtual void  v37(); // _ZN7S2016C93v37Ev
  virtual void  v38(); // _ZN7S2016C93v38Ev
  virtual void  v39(); // _ZN7S2016C93v39Ev
  virtual void  v40(); // _ZN7S2016C93v40Ev
  S2016C9(); // tgen
};
//SIG(-1 S2016C9) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m Fp Fi[2] FC4{ m}}}


 S2016C9 ::~S2016C9(){ note_dtor("S2016C9", this);}
void  S2016C9 ::v34(){vfunc_called(this, "_ZN7S2016C93v34Ev");}
void  S2016C9 ::v35(){vfunc_called(this, "_ZN7S2016C93v35Ev");}
void  S2016C9 ::v36(){vfunc_called(this, "_ZN7S2016C93v36Ev");}
void  S2016C9 ::v37(){vfunc_called(this, "_ZN7S2016C93v37Ev");}
void  S2016C9 ::v38(){vfunc_called(this, "_ZN7S2016C93v38Ev");}
void  S2016C9 ::v39(){vfunc_called(this, "_ZN7S2016C93v39Ev");}
void  S2016C9 ::v40(){vfunc_called(this, "_ZN7S2016C93v40Ev");}
S2016C9 ::S2016C9(){ note_ctor("S2016C9", this);} // tgen

static void Test_S2016C9()
{
  extern Class_Descriptor cd_S2016C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_S2016C9, buf);
    S2016C9 *dp, &lv = *(dp=new (buf) S2016C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S2016C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2016C9)");
    check_base_class_offset(lv, (S2016C10*), 0, "S2016C9");
    check_field_offset(lv, s2016c9f0, ABISELECT(24,12), "S2016C9.s2016c9f0");
    test_class_info(&lv, &cd_S2016C9);
    dp->~S2016C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2016C9(Test_S2016C9, "S2016C9", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN7S2016C9C1Ev();
extern void _ZN7S2016C9D1Ev();
Name_Map name_map_S2016C9[] = {
  NSPAIR(_ZN7S2016C9C1Ev),
  NSPAIR(_ZN7S2016C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2016C10;
extern VTBL_ENTRY _ZTI8S2016C10[];
extern  VTBL_ENTRY _ZTV8S2016C10[];
static Base_Class bases_S2016C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2016C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2016C9[];
extern void _ZN7S2016C9D1Ev();
extern void _ZN7S2016C9D0Ev();
extern void _ZN8S2016C103v20Ev();
extern void _ZN8S2016C103v21Ev();
extern void _ZN8S2016C103v22Ev();
extern void _ZN8S2016C103v23Ev();
extern void _ZN8S2016C103v24Ev();
extern void _ZN8S2016C103v25Ev();
extern void _ZN8S2016C103v26Ev();
extern void _ZN8S2016C103v27Ev();
extern void _ZN8S2016C103v28Ev();
extern void _ZN8S2016C103v29Ev();
extern void _ZN8S2016C103v30Ev();
extern void _ZN8S2016C103v31Ev();
extern void _ZN8S2016C103v32Ev();
extern void _ZN8S2016C103v33Ev();
extern void _ZN7S2016C93v34Ev();
extern void _ZN7S2016C93v35Ev();
extern void _ZN7S2016C93v36Ev();
extern void _ZN7S2016C93v37Ev();
extern void _ZN7S2016C93v38Ev();
extern void _ZN7S2016C93v39Ev();
extern void _ZN7S2016C93v40Ev();
static  VTBL_ENTRY vtc_S2016C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2016C9[0]),
  (VTBL_ENTRY)&_ZN7S2016C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2016C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v20Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v23Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v24Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v33Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v34Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v35Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v36Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v37Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v38Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v39Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v40Ev,
};
extern VTBL_ENTRY _ZTI7S2016C9[];
extern  VTBL_ENTRY _ZTV7S2016C9[];
Class_Descriptor cd_S2016C9 = {  "S2016C9", // class name
  bases_S2016C9, 1,
  &(vtc_S2016C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI7S2016C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2016C9),25, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2016C1  : S2016C2 , S2016C9 {
  ::S2041C13 s2016c1f0;
  ::S10183C7_nt s2016c1f1;
  ::S9125C35_nt s2016c1f2;
  virtual  ~S2016C1(); // _ZN7S2016C1D1Ev
  virtual void  v1(); // _ZN7S2016C12v1Ev
  virtual void  v2(); // _ZN7S2016C12v2Ev
  virtual void  v3(); // _ZN7S2016C12v3Ev
  virtual void  v4(); // _ZN7S2016C12v4Ev
  virtual void  v5(); // _ZN7S2016C12v5Ev
  virtual void  v6(); // _ZN7S2016C12v6Ev
  virtual void  v7(); // _ZN7S2016C12v7Ev
  virtual void  v8(); // _ZN7S2016C12v8Ev
  virtual void  v9(); // _ZN7S2016C12v9Ev
  virtual void  v10(); // _ZN7S2016C13v10Ev
  S2016C1(); // tgen
};
//SIG(1 S2016C1) C1{ BC2{ BC3{ BC4{ vd v11 v12 v13} vd v14 v15 v16} vd v17 v18 v19 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FC8{ Fl[4]}} Fc} BC9{ BC10{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp[2]} vd v34 v35 v36 v37 v38 v39 v40 FC11{ m Fp Fi[2] FC12{ m}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 FC13{ BC14{ vd} Fi FC15{ BC16{ vd v43 v44} vd v41 v42 FC17{ m Fp Fi FC18{ m}} FC17 Fi} FC19{ BC16 vd v45 v46 FC20{ BC16 vd v47 v48 FC17} FC15 FC21{ BC5 BC16 vd v49 v50} FC22{ vd m FC23{ m Fs[6] Fi[2] Fc Fs}} FC17 FC17 Fc[2] Fi FC17 FC17 FC17 FC17 FC17 Fi[3] Fp FC17 FC22 FC17 Fi} FC24{ Fi FC25{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]}} FC7 FC26{ m Fp Fi[2] FC6}}


 S2016C1 ::~S2016C1(){ note_dtor("S2016C1", this);}
void  S2016C1 ::v1(){vfunc_called(this, "_ZN7S2016C12v1Ev");}
void  S2016C1 ::v2(){vfunc_called(this, "_ZN7S2016C12v2Ev");}
void  S2016C1 ::v3(){vfunc_called(this, "_ZN7S2016C12v3Ev");}
void  S2016C1 ::v4(){vfunc_called(this, "_ZN7S2016C12v4Ev");}
void  S2016C1 ::v5(){vfunc_called(this, "_ZN7S2016C12v5Ev");}
void  S2016C1 ::v6(){vfunc_called(this, "_ZN7S2016C12v6Ev");}
void  S2016C1 ::v7(){vfunc_called(this, "_ZN7S2016C12v7Ev");}
void  S2016C1 ::v8(){vfunc_called(this, "_ZN7S2016C12v8Ev");}
void  S2016C1 ::v9(){vfunc_called(this, "_ZN7S2016C12v9Ev");}
void  S2016C1 ::v10(){vfunc_called(this, "_ZN7S2016C13v10Ev");}
S2016C1 ::S2016C1(){ note_ctor("S2016C1", this);} // tgen

static void Test_S2016C1()
{
  extern Class_Descriptor cd_S2016C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(99,137)];
    init_test(&cd_S2016C1, buf);
    S2016C1 *dp, &lv = *(dp=new (buf) S2016C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(784,544), "sizeof(S2016C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2016C1)");
    check_base_class_offset(lv, (S2016C4*)(S2016C3*)(S2016C2*), 0, "S2016C1");
    check_base_class_offset(lv, (S2016C3*)(S2016C2*), 0, "S2016C1");
    check_base_class_offset(lv, (S2016C2*), 0, "S2016C1");
    check_base_class_offset(lv, (S2016C10*)(S2016C9*), ABISELECT(72,40), "S2016C1");
    check_base_class_offset(lv, (S2016C9*), ABISELECT(72,40), "S2016C1");
    check_field_offset(lv, s2016c1f0, ABISELECT(120,68), "S2016C1.s2016c1f0");
    check_field_offset(lv, s2016c1f1, ABISELECT(728,512), "S2016C1.s2016c1f1");
    check_field_offset(lv, s2016c1f2, ABISELECT(760,528), "S2016C1.s2016c1f2");
    test_class_info(&lv, &cd_S2016C1);
    dp->~S2016C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2016C1(Test_S2016C1, "S2016C1", ABISELECT(784,544));

#else // __cplusplus

extern void _ZN7S2016C1C1Ev();
extern void _ZN7S2016C1D1Ev();
Name_Map name_map_S2016C1[] = {
  NSPAIR(_ZN7S2016C1C1Ev),
  NSPAIR(_ZN7S2016C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2016C4;
extern VTBL_ENTRY _ZTI7S2016C4[];
extern  VTBL_ENTRY _ZTV7S2016C4[];
extern Class_Descriptor cd_S2016C3;
extern VTBL_ENTRY _ZTI7S2016C3[];
extern  VTBL_ENTRY _ZTV7S2016C3[];
extern Class_Descriptor cd_S2016C2;
extern VTBL_ENTRY _ZTI7S2016C2[];
extern  VTBL_ENTRY _ZTV7S2016C2[];
extern Class_Descriptor cd_S2016C10;
extern VTBL_ENTRY _ZTI8S2016C10[];
extern  VTBL_ENTRY _ZTV8S2016C10[];
extern Class_Descriptor cd_S2016C9;
extern VTBL_ENTRY _ZTI7S2016C9[];
extern  VTBL_ENTRY _ZTV7S2016C9[];
static Base_Class bases_S2016C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2016C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2016C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2016C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2016C10,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2016C9,    ABISELECT(72,40), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2016C1[];
extern void _ZN7S2016C1D1Ev();
extern void _ZN7S2016C1D0Ev();
extern void _ZN7S2016C43v11Ev();
extern void _ZN7S2016C43v12Ev();
extern void _ZN7S2016C43v13Ev();
extern void _ZN7S2016C33v14Ev();
extern void _ZN7S2016C33v15Ev();
extern void _ZN7S2016C33v16Ev();
extern void _ZN7S2016C23v17Ev();
extern void _ZN7S2016C23v18Ev();
extern void _ZN7S2016C23v19Ev();
extern void _ZN7S2016C12v1Ev();
extern void _ZN7S2016C12v2Ev();
extern void _ZN7S2016C12v3Ev();
extern void _ZN7S2016C12v4Ev();
extern void _ZN7S2016C12v5Ev();
extern void _ZN7S2016C12v6Ev();
extern void _ZN7S2016C12v7Ev();
extern void _ZN7S2016C12v8Ev();
extern void _ZN7S2016C12v9Ev();
extern void _ZN7S2016C13v10Ev();
extern void ABISELECT(_ZThn72_N7S2016C1D1Ev,_ZThn40_N7S2016C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2016C1D0Ev,_ZThn40_N7S2016C1D0Ev)();
extern void _ZN8S2016C103v20Ev();
extern void _ZN8S2016C103v21Ev();
extern void _ZN8S2016C103v22Ev();
extern void _ZN8S2016C103v23Ev();
extern void _ZN8S2016C103v24Ev();
extern void _ZN8S2016C103v25Ev();
extern void _ZN8S2016C103v26Ev();
extern void _ZN8S2016C103v27Ev();
extern void _ZN8S2016C103v28Ev();
extern void _ZN8S2016C103v29Ev();
extern void _ZN8S2016C103v30Ev();
extern void _ZN8S2016C103v31Ev();
extern void _ZN8S2016C103v32Ev();
extern void _ZN8S2016C103v33Ev();
extern void _ZN7S2016C93v34Ev();
extern void _ZN7S2016C93v35Ev();
extern void _ZN7S2016C93v36Ev();
extern void _ZN7S2016C93v37Ev();
extern void _ZN7S2016C93v38Ev();
extern void _ZN7S2016C93v39Ev();
extern void _ZN7S2016C93v40Ev();
static  VTBL_ENTRY vtc_S2016C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2016C1[0]),
  (VTBL_ENTRY)&_ZN7S2016C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2016C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2016C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2016C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2016C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2016C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2016C23v17Ev,
  (VTBL_ENTRY)&_ZN7S2016C23v18Ev,
  (VTBL_ENTRY)&_ZN7S2016C23v19Ev,
  (VTBL_ENTRY)&_ZN7S2016C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2016C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2016C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2016C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2016C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2016C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2016C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2016C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2016C12v9Ev,
  (VTBL_ENTRY)&_ZN7S2016C13v10Ev,
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI7S2016C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2016C1D1Ev,_ZThn40_N7S2016C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2016C1D0Ev,_ZThn40_N7S2016C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2016C103v20Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v23Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v24Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v32Ev,
  (VTBL_ENTRY)&_ZN8S2016C103v33Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v34Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v35Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v36Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v37Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v38Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v39Ev,
  (VTBL_ENTRY)&_ZN7S2016C93v40Ev,
};
extern VTBL_ENTRY _ZTI7S2016C1[];
extern  VTBL_ENTRY _ZTV7S2016C1[];
Class_Descriptor cd_S2016C1 = {  "S2016C1", // class name
  bases_S2016C1, 5,
  &(vtc_S2016C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(784,544), // object size
  NSPAIRA(_ZTI7S2016C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2016C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2020C4  {
  virtual  ~S2020C4(); // _ZN7S2020C4D1Ev
  virtual void  v11(); // _ZN7S2020C43v11Ev
  virtual void  v12(); // _ZN7S2020C43v12Ev
  virtual void  v13(); // _ZN7S2020C43v13Ev
  S2020C4(); // tgen
};
//SIG(-1 S2020C4) C1{ vd v1 v2 v3}


 S2020C4 ::~S2020C4(){ note_dtor("S2020C4", this);}
void  S2020C4 ::v11(){vfunc_called(this, "_ZN7S2020C43v11Ev");}
void  S2020C4 ::v12(){vfunc_called(this, "_ZN7S2020C43v12Ev");}
void  S2020C4 ::v13(){vfunc_called(this, "_ZN7S2020C43v13Ev");}
S2020C4 ::S2020C4(){ note_ctor("S2020C4", this);} // tgen

static void Test_S2020C4()
{
  extern Class_Descriptor cd_S2020C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2020C4, buf);
    S2020C4 *dp, &lv = *(dp=new (buf) S2020C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2020C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2020C4)");
    test_class_info(&lv, &cd_S2020C4);
    dp->~S2020C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2020C4(Test_S2020C4, "S2020C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2020C4C1Ev();
extern void _ZN7S2020C4D1Ev();
Name_Map name_map_S2020C4[] = {
  NSPAIR(_ZN7S2020C4C1Ev),
  NSPAIR(_ZN7S2020C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2020C4[];
extern void _ZN7S2020C4D1Ev();
extern void _ZN7S2020C4D0Ev();
extern void _ZN7S2020C43v11Ev();
extern void _ZN7S2020C43v12Ev();
extern void _ZN7S2020C43v13Ev();
static  VTBL_ENTRY vtc_S2020C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2020C4[0]),
  (VTBL_ENTRY)&_ZN7S2020C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2020C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v13Ev,
};
extern VTBL_ENTRY _ZTI7S2020C4[];
extern  VTBL_ENTRY _ZTV7S2020C4[];
Class_Descriptor cd_S2020C4 = {  "S2020C4", // class name
  0,0,//no base classes
  &(vtc_S2020C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2020C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2020C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2020C3  : S2020C4 {
  virtual  ~S2020C3(); // _ZN7S2020C3D1Ev
  virtual void  v14(); // _ZN7S2020C33v14Ev
  virtual void  v15(); // _ZN7S2020C33v15Ev
  virtual void  v16(); // _ZN7S2020C33v16Ev
  S2020C3(); // tgen
};
//SIG(-1 S2020C3) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3}


 S2020C3 ::~S2020C3(){ note_dtor("S2020C3", this);}
void  S2020C3 ::v14(){vfunc_called(this, "_ZN7S2020C33v14Ev");}
void  S2020C3 ::v15(){vfunc_called(this, "_ZN7S2020C33v15Ev");}
void  S2020C3 ::v16(){vfunc_called(this, "_ZN7S2020C33v16Ev");}
S2020C3 ::S2020C3(){ note_ctor("S2020C3", this);} // tgen

static void Test_S2020C3()
{
  extern Class_Descriptor cd_S2020C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2020C3, buf);
    S2020C3 *dp, &lv = *(dp=new (buf) S2020C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2020C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2020C3)");
    check_base_class_offset(lv, (S2020C4*), 0, "S2020C3");
    test_class_info(&lv, &cd_S2020C3);
    dp->~S2020C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2020C3(Test_S2020C3, "S2020C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2020C3C1Ev();
extern void _ZN7S2020C3D1Ev();
Name_Map name_map_S2020C3[] = {
  NSPAIR(_ZN7S2020C3C1Ev),
  NSPAIR(_ZN7S2020C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2020C4;
extern VTBL_ENTRY _ZTI7S2020C4[];
extern  VTBL_ENTRY _ZTV7S2020C4[];
static Base_Class bases_S2020C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2020C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2020C3[];
extern void _ZN7S2020C3D1Ev();
extern void _ZN7S2020C3D0Ev();
extern void _ZN7S2020C43v11Ev();
extern void _ZN7S2020C43v12Ev();
extern void _ZN7S2020C43v13Ev();
extern void _ZN7S2020C33v14Ev();
extern void _ZN7S2020C33v15Ev();
extern void _ZN7S2020C33v16Ev();
static  VTBL_ENTRY vtc_S2020C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2020C3[0]),
  (VTBL_ENTRY)&_ZN7S2020C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2020C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2020C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2020C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2020C33v16Ev,
};
extern VTBL_ENTRY _ZTI7S2020C3[];
extern  VTBL_ENTRY _ZTV7S2020C3[];
Class_Descriptor cd_S2020C3 = {  "S2020C3", // class name
  bases_S2020C3, 1,
  &(vtc_S2020C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2020C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2020C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2020C2  : S2020C3 {
  ::S10183C20 s2020c2f0;
  ::S10185C7_nt s2020c2f1;
  char s2020c2f2;
  virtual  ~S2020C2(); // _ZN7S2020C2D1Ev
  virtual void  v17(); // _ZN7S2020C23v17Ev
  virtual void  v18(); // _ZN7S2020C23v18Ev
  virtual void  v19(); // _ZN7S2020C23v19Ev
  S2020C2(); // tgen
};
//SIG(-1 S2020C2) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FL[4]} Fc}


 S2020C2 ::~S2020C2(){ note_dtor("S2020C2", this);}
void  S2020C2 ::v17(){vfunc_called(this, "_ZN7S2020C23v17Ev");}
void  S2020C2 ::v18(){vfunc_called(this, "_ZN7S2020C23v18Ev");}
void  S2020C2 ::v19(){vfunc_called(this, "_ZN7S2020C23v19Ev");}
S2020C2 ::S2020C2(){ note_ctor("S2020C2", this);} // tgen

static void Test_S2020C2()
{
  extern Class_Descriptor cd_S2020C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2020C2, buf);
    S2020C2 *dp, &lv = *(dp=new (buf) S2020C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2020C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2020C2)");
    check_base_class_offset(lv, (S2020C4*)(S2020C3*), 0, "S2020C2");
    check_base_class_offset(lv, (S2020C3*), 0, "S2020C2");
    check_field_offset(lv, s2020c2f0, ABISELECT(8,4), "S2020C2.s2020c2f0");
    check_field_offset(lv, s2020c2f1, ABISELECT(32,20), "S2020C2.s2020c2f1");
    check_field_offset(lv, s2020c2f2, ABISELECT(64,52), "S2020C2.s2020c2f2");
    test_class_info(&lv, &cd_S2020C2);
    dp->~S2020C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2020C2(Test_S2020C2, "S2020C2", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2020C2C1Ev();
extern void _ZN7S2020C2D1Ev();
Name_Map name_map_S2020C2[] = {
  NSPAIR(_ZN7S2020C2C1Ev),
  NSPAIR(_ZN7S2020C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2020C4;
extern VTBL_ENTRY _ZTI7S2020C4[];
extern  VTBL_ENTRY _ZTV7S2020C4[];
extern Class_Descriptor cd_S2020C3;
extern VTBL_ENTRY _ZTI7S2020C3[];
extern  VTBL_ENTRY _ZTV7S2020C3[];
static Base_Class bases_S2020C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2020C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2020C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2020C2[];
extern void _ZN7S2020C2D1Ev();
extern void _ZN7S2020C2D0Ev();
extern void _ZN7S2020C43v11Ev();
extern void _ZN7S2020C43v12Ev();
extern void _ZN7S2020C43v13Ev();
extern void _ZN7S2020C33v14Ev();
extern void _ZN7S2020C33v15Ev();
extern void _ZN7S2020C33v16Ev();
extern void _ZN7S2020C23v17Ev();
extern void _ZN7S2020C23v18Ev();
extern void _ZN7S2020C23v19Ev();
static  VTBL_ENTRY vtc_S2020C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2020C2[0]),
  (VTBL_ENTRY)&_ZN7S2020C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2020C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2020C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2020C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2020C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2020C23v17Ev,
  (VTBL_ENTRY)&_ZN7S2020C23v18Ev,
  (VTBL_ENTRY)&_ZN7S2020C23v19Ev,
};
extern VTBL_ENTRY _ZTI7S2020C2[];
extern  VTBL_ENTRY _ZTV7S2020C2[];
Class_Descriptor cd_S2020C2 = {  "S2020C2", // class name
  bases_S2020C2, 2,
  &(vtc_S2020C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2020C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2020C2),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2020C9  {
  void *s2020c9f0[2];
  virtual  ~S2020C9(); // _ZN7S2020C9D1Ev
  virtual void  v20(); // _ZN7S2020C93v20Ev
  virtual void  v21(); // _ZN7S2020C93v21Ev
  virtual void  v22(); // _ZN7S2020C93v22Ev
  virtual void  v23(); // _ZN7S2020C93v23Ev
  virtual void  v24(); // _ZN7S2020C93v24Ev
  virtual void  v25(); // _ZN7S2020C93v25Ev
  virtual void  v26(); // _ZN7S2020C93v26Ev
  virtual void  v27(); // _ZN7S2020C93v27Ev
  virtual void  v28(); // _ZN7S2020C93v28Ev
  virtual void  v29(); // _ZN7S2020C93v29Ev
  virtual void  v30(); // _ZN7S2020C93v30Ev
  virtual void  v31(); // _ZN7S2020C93v31Ev
  virtual void  v32(); // _ZN7S2020C93v32Ev
  virtual void  v33(); // _ZN7S2020C93v33Ev
  S2020C9(); // tgen
};
//SIG(-1 S2020C9) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2]}


 S2020C9 ::~S2020C9(){ note_dtor("S2020C9", this);}
void  S2020C9 ::v20(){vfunc_called(this, "_ZN7S2020C93v20Ev");}
void  S2020C9 ::v21(){vfunc_called(this, "_ZN7S2020C93v21Ev");}
void  S2020C9 ::v22(){vfunc_called(this, "_ZN7S2020C93v22Ev");}
void  S2020C9 ::v23(){vfunc_called(this, "_ZN7S2020C93v23Ev");}
void  S2020C9 ::v24(){vfunc_called(this, "_ZN7S2020C93v24Ev");}
void  S2020C9 ::v25(){vfunc_called(this, "_ZN7S2020C93v25Ev");}
void  S2020C9 ::v26(){vfunc_called(this, "_ZN7S2020C93v26Ev");}
void  S2020C9 ::v27(){vfunc_called(this, "_ZN7S2020C93v27Ev");}
void  S2020C9 ::v28(){vfunc_called(this, "_ZN7S2020C93v28Ev");}
void  S2020C9 ::v29(){vfunc_called(this, "_ZN7S2020C93v29Ev");}
void  S2020C9 ::v30(){vfunc_called(this, "_ZN7S2020C93v30Ev");}
void  S2020C9 ::v31(){vfunc_called(this, "_ZN7S2020C93v31Ev");}
void  S2020C9 ::v32(){vfunc_called(this, "_ZN7S2020C93v32Ev");}
void  S2020C9 ::v33(){vfunc_called(this, "_ZN7S2020C93v33Ev");}
S2020C9 ::S2020C9(){ note_ctor("S2020C9", this);} // tgen

static void Test_S2020C9()
{
  extern Class_Descriptor cd_S2020C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S2020C9, buf);
    S2020C9 *dp, &lv = *(dp=new (buf) S2020C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S2020C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2020C9)");
    check_field_offset(lv, s2020c9f0, ABISELECT(8,4), "S2020C9.s2020c9f0");
    test_class_info(&lv, &cd_S2020C9);
    dp->~S2020C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2020C9(Test_S2020C9, "S2020C9", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN7S2020C9C1Ev();
extern void _ZN7S2020C9D1Ev();
Name_Map name_map_S2020C9[] = {
  NSPAIR(_ZN7S2020C9C1Ev),
  NSPAIR(_ZN7S2020C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2020C9[];
extern void _ZN7S2020C9D1Ev();
extern void _ZN7S2020C9D0Ev();
extern void _ZN7S2020C93v20Ev();
extern void _ZN7S2020C93v21Ev();
extern void _ZN7S2020C93v22Ev();
extern void _ZN7S2020C93v23Ev();
extern void _ZN7S2020C93v24Ev();
extern void _ZN7S2020C93v25Ev();
extern void _ZN7S2020C93v26Ev();
extern void _ZN7S2020C93v27Ev();
extern void _ZN7S2020C93v28Ev();
extern void _ZN7S2020C93v29Ev();
extern void _ZN7S2020C93v30Ev();
extern void _ZN7S2020C93v31Ev();
extern void _ZN7S2020C93v32Ev();
extern void _ZN7S2020C93v33Ev();
static  VTBL_ENTRY vtc_S2020C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2020C9[0]),
  (VTBL_ENTRY)&_ZN7S2020C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2020C9D0Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v20Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v21Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v22Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v23Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v27Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v28Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v29Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v30Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v31Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v32Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v33Ev,
};
extern VTBL_ENTRY _ZTI7S2020C9[];
extern  VTBL_ENTRY _ZTV7S2020C9[];
Class_Descriptor cd_S2020C9 = {  "S2020C9", // class name
  0,0,//no base classes
  &(vtc_S2020C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI7S2020C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2020C9),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2020C8  : S2020C9 {
  ::S10183C5_nt s2020c8f0;
  virtual  ~S2020C8(); // _ZN7S2020C8D1Ev
  virtual void  v34(); // _ZN7S2020C83v34Ev
  virtual void  v35(); // _ZN7S2020C83v35Ev
  virtual void  v36(); // _ZN7S2020C83v36Ev
  virtual void  v37(); // _ZN7S2020C83v37Ev
  virtual void  v38(); // _ZN7S2020C83v38Ev
  virtual void  v39(); // _ZN7S2020C83v39Ev
  virtual void  v40(); // _ZN7S2020C83v40Ev
  S2020C8(); // tgen
};
//SIG(-1 S2020C8) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m Fp Fi[2] FC4{ m}}}


 S2020C8 ::~S2020C8(){ note_dtor("S2020C8", this);}
void  S2020C8 ::v34(){vfunc_called(this, "_ZN7S2020C83v34Ev");}
void  S2020C8 ::v35(){vfunc_called(this, "_ZN7S2020C83v35Ev");}
void  S2020C8 ::v36(){vfunc_called(this, "_ZN7S2020C83v36Ev");}
void  S2020C8 ::v37(){vfunc_called(this, "_ZN7S2020C83v37Ev");}
void  S2020C8 ::v38(){vfunc_called(this, "_ZN7S2020C83v38Ev");}
void  S2020C8 ::v39(){vfunc_called(this, "_ZN7S2020C83v39Ev");}
void  S2020C8 ::v40(){vfunc_called(this, "_ZN7S2020C83v40Ev");}
S2020C8 ::S2020C8(){ note_ctor("S2020C8", this);} // tgen

static void Test_S2020C8()
{
  extern Class_Descriptor cd_S2020C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_S2020C8, buf);
    S2020C8 *dp, &lv = *(dp=new (buf) S2020C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S2020C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2020C8)");
    check_base_class_offset(lv, (S2020C9*), 0, "S2020C8");
    check_field_offset(lv, s2020c8f0, ABISELECT(24,12), "S2020C8.s2020c8f0");
    test_class_info(&lv, &cd_S2020C8);
    dp->~S2020C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2020C8(Test_S2020C8, "S2020C8", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN7S2020C8C1Ev();
extern void _ZN7S2020C8D1Ev();
Name_Map name_map_S2020C8[] = {
  NSPAIR(_ZN7S2020C8C1Ev),
  NSPAIR(_ZN7S2020C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2020C9;
extern VTBL_ENTRY _ZTI7S2020C9[];
extern  VTBL_ENTRY _ZTV7S2020C9[];
static Base_Class bases_S2020C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2020C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2020C8[];
extern void _ZN7S2020C8D1Ev();
extern void _ZN7S2020C8D0Ev();
extern void _ZN7S2020C93v20Ev();
extern void _ZN7S2020C93v21Ev();
extern void _ZN7S2020C93v22Ev();
extern void _ZN7S2020C93v23Ev();
extern void _ZN7S2020C93v24Ev();
extern void _ZN7S2020C93v25Ev();
extern void _ZN7S2020C93v26Ev();
extern void _ZN7S2020C93v27Ev();
extern void _ZN7S2020C93v28Ev();
extern void _ZN7S2020C93v29Ev();
extern void _ZN7S2020C93v30Ev();
extern void _ZN7S2020C93v31Ev();
extern void _ZN7S2020C93v32Ev();
extern void _ZN7S2020C93v33Ev();
extern void _ZN7S2020C83v34Ev();
extern void _ZN7S2020C83v35Ev();
extern void _ZN7S2020C83v36Ev();
extern void _ZN7S2020C83v37Ev();
extern void _ZN7S2020C83v38Ev();
extern void _ZN7S2020C83v39Ev();
extern void _ZN7S2020C83v40Ev();
static  VTBL_ENTRY vtc_S2020C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2020C8[0]),
  (VTBL_ENTRY)&_ZN7S2020C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2020C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v20Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v21Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v22Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v23Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v27Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v28Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v29Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v30Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v31Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v32Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v33Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v34Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v35Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v36Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v37Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v38Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v39Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v40Ev,
};
extern VTBL_ENTRY _ZTI7S2020C8[];
extern  VTBL_ENTRY _ZTV7S2020C8[];
Class_Descriptor cd_S2020C8 = {  "S2020C8", // class name
  bases_S2020C8, 1,
  &(vtc_S2020C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI7S2020C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2020C8),25, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2020C1  : S2020C2 , S2020C8 {
  ::S2041C13 s2020c1f0;
  ::S10185C7_nt s2020c1f1;
  ::S9125C35_nt s2020c1f2;
  virtual  ~S2020C1(); // _ZN7S2020C1D1Ev
  virtual void  v1(); // _ZN7S2020C12v1Ev
  virtual void  v2(); // _ZN7S2020C12v2Ev
  virtual void  v3(); // _ZN7S2020C12v3Ev
  virtual void  v4(); // _ZN7S2020C12v4Ev
  virtual void  v5(); // _ZN7S2020C12v5Ev
  virtual void  v6(); // _ZN7S2020C12v6Ev
  virtual void  v7(); // _ZN7S2020C12v7Ev
  virtual void  v8(); // _ZN7S2020C12v8Ev
  virtual void  v9(); // _ZN7S2020C12v9Ev
  virtual void  v10(); // _ZN7S2020C13v10Ev
  S2020C1(); // tgen
};
//SIG(1 S2020C1) C1{ BC2{ BC3{ BC4{ vd v11 v12 v13} vd v14 v15 v16} vd v17 v18 v19 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FL[4]} Fc} BC8{ BC9{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp[2]} vd v34 v35 v36 v37 v38 v39 v40 FC10{ m Fp Fi[2] FC11{ m}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 FC12{ BC13{ vd} Fi FC14{ BC15{ vd v43 v44} vd v41 v42 FC16{ m Fp Fi FC17{ m}} FC16 Fi} FC18{ BC15 vd v45 v46 FC19{ BC15 vd v47 v48 FC16} FC14 FC20{ BC5 BC15 vd v49 v50} FC21{ vd m FC22{ m Fs[6] Fi[2] Fc Fs}} FC16 FC16 Fc[2] Fi FC16 FC16 FC16 FC16 FC16 Fi[3] Fp FC16 FC21 FC16 Fi} FC23{ Fi FC24{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]}} FC7 FC25{ m Fp Fi[2] FC6}}


 S2020C1 ::~S2020C1(){ note_dtor("S2020C1", this);}
void  S2020C1 ::v1(){vfunc_called(this, "_ZN7S2020C12v1Ev");}
void  S2020C1 ::v2(){vfunc_called(this, "_ZN7S2020C12v2Ev");}
void  S2020C1 ::v3(){vfunc_called(this, "_ZN7S2020C12v3Ev");}
void  S2020C1 ::v4(){vfunc_called(this, "_ZN7S2020C12v4Ev");}
void  S2020C1 ::v5(){vfunc_called(this, "_ZN7S2020C12v5Ev");}
void  S2020C1 ::v6(){vfunc_called(this, "_ZN7S2020C12v6Ev");}
void  S2020C1 ::v7(){vfunc_called(this, "_ZN7S2020C12v7Ev");}
void  S2020C1 ::v8(){vfunc_called(this, "_ZN7S2020C12v8Ev");}
void  S2020C1 ::v9(){vfunc_called(this, "_ZN7S2020C12v9Ev");}
void  S2020C1 ::v10(){vfunc_called(this, "_ZN7S2020C13v10Ev");}
S2020C1 ::S2020C1(){ note_ctor("S2020C1", this);} // tgen

static void Test_S2020C1()
{
  extern Class_Descriptor cd_S2020C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(99,145)];
    init_test(&cd_S2020C1, buf);
    S2020C1 *dp, &lv = *(dp=new (buf) S2020C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(784,576), "sizeof(S2020C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2020C1)");
    check_base_class_offset(lv, (S2020C4*)(S2020C3*)(S2020C2*), 0, "S2020C1");
    check_base_class_offset(lv, (S2020C3*)(S2020C2*), 0, "S2020C1");
    check_base_class_offset(lv, (S2020C2*), 0, "S2020C1");
    check_base_class_offset(lv, (S2020C9*)(S2020C8*), ABISELECT(72,56), "S2020C1");
    check_base_class_offset(lv, (S2020C8*), ABISELECT(72,56), "S2020C1");
    check_field_offset(lv, s2020c1f0, ABISELECT(120,84), "S2020C1.s2020c1f0");
    check_field_offset(lv, s2020c1f1, ABISELECT(728,528), "S2020C1.s2020c1f1");
    check_field_offset(lv, s2020c1f2, ABISELECT(760,560), "S2020C1.s2020c1f2");
    test_class_info(&lv, &cd_S2020C1);
    dp->~S2020C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2020C1(Test_S2020C1, "S2020C1", ABISELECT(784,576));

#else // __cplusplus

extern void _ZN7S2020C1C1Ev();
extern void _ZN7S2020C1D1Ev();
Name_Map name_map_S2020C1[] = {
  NSPAIR(_ZN7S2020C1C1Ev),
  NSPAIR(_ZN7S2020C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2020C4;
extern VTBL_ENTRY _ZTI7S2020C4[];
extern  VTBL_ENTRY _ZTV7S2020C4[];
extern Class_Descriptor cd_S2020C3;
extern VTBL_ENTRY _ZTI7S2020C3[];
extern  VTBL_ENTRY _ZTV7S2020C3[];
extern Class_Descriptor cd_S2020C2;
extern VTBL_ENTRY _ZTI7S2020C2[];
extern  VTBL_ENTRY _ZTV7S2020C2[];
extern Class_Descriptor cd_S2020C9;
extern VTBL_ENTRY _ZTI7S2020C9[];
extern  VTBL_ENTRY _ZTV7S2020C9[];
extern Class_Descriptor cd_S2020C8;
extern VTBL_ENTRY _ZTI7S2020C8[];
extern  VTBL_ENTRY _ZTV7S2020C8[];
static Base_Class bases_S2020C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2020C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2020C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2020C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2020C9,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2020C8,    ABISELECT(72,56), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2020C1[];
extern void _ZN7S2020C1D1Ev();
extern void _ZN7S2020C1D0Ev();
extern void _ZN7S2020C43v11Ev();
extern void _ZN7S2020C43v12Ev();
extern void _ZN7S2020C43v13Ev();
extern void _ZN7S2020C33v14Ev();
extern void _ZN7S2020C33v15Ev();
extern void _ZN7S2020C33v16Ev();
extern void _ZN7S2020C23v17Ev();
extern void _ZN7S2020C23v18Ev();
extern void _ZN7S2020C23v19Ev();
extern void _ZN7S2020C12v1Ev();
extern void _ZN7S2020C12v2Ev();
extern void _ZN7S2020C12v3Ev();
extern void _ZN7S2020C12v4Ev();
extern void _ZN7S2020C12v5Ev();
extern void _ZN7S2020C12v6Ev();
extern void _ZN7S2020C12v7Ev();
extern void _ZN7S2020C12v8Ev();
extern void _ZN7S2020C12v9Ev();
extern void _ZN7S2020C13v10Ev();
extern void ABISELECT(_ZThn72_N7S2020C1D1Ev,_ZThn56_N7S2020C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2020C1D0Ev,_ZThn56_N7S2020C1D0Ev)();
extern void _ZN7S2020C93v20Ev();
extern void _ZN7S2020C93v21Ev();
extern void _ZN7S2020C93v22Ev();
extern void _ZN7S2020C93v23Ev();
extern void _ZN7S2020C93v24Ev();
extern void _ZN7S2020C93v25Ev();
extern void _ZN7S2020C93v26Ev();
extern void _ZN7S2020C93v27Ev();
extern void _ZN7S2020C93v28Ev();
extern void _ZN7S2020C93v29Ev();
extern void _ZN7S2020C93v30Ev();
extern void _ZN7S2020C93v31Ev();
extern void _ZN7S2020C93v32Ev();
extern void _ZN7S2020C93v33Ev();
extern void _ZN7S2020C83v34Ev();
extern void _ZN7S2020C83v35Ev();
extern void _ZN7S2020C83v36Ev();
extern void _ZN7S2020C83v37Ev();
extern void _ZN7S2020C83v38Ev();
extern void _ZN7S2020C83v39Ev();
extern void _ZN7S2020C83v40Ev();
static  VTBL_ENTRY vtc_S2020C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2020C1[0]),
  (VTBL_ENTRY)&_ZN7S2020C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2020C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2020C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2020C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2020C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2020C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2020C23v17Ev,
  (VTBL_ENTRY)&_ZN7S2020C23v18Ev,
  (VTBL_ENTRY)&_ZN7S2020C23v19Ev,
  (VTBL_ENTRY)&_ZN7S2020C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2020C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2020C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2020C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2020C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2020C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2020C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2020C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2020C12v9Ev,
  (VTBL_ENTRY)&_ZN7S2020C13v10Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S2020C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2020C1D1Ev,_ZThn56_N7S2020C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2020C1D0Ev,_ZThn56_N7S2020C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2020C93v20Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v21Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v22Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v23Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v27Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v28Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v29Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v30Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v31Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v32Ev,
  (VTBL_ENTRY)&_ZN7S2020C93v33Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v34Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v35Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v36Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v37Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v38Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v39Ev,
  (VTBL_ENTRY)&_ZN7S2020C83v40Ev,
};
extern VTBL_ENTRY _ZTI7S2020C1[];
extern  VTBL_ENTRY _ZTV7S2020C1[];
Class_Descriptor cd_S2020C1 = {  "S2020C1", // class name
  bases_S2020C1, 5,
  &(vtc_S2020C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(784,576), // object size
  NSPAIRA(_ZTI7S2020C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2020C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2012C4  {
  virtual  ~S2012C4(); // _ZN7S2012C4D1Ev
  virtual void  v10(); // _ZN7S2012C43v10Ev
  virtual void  v11(); // _ZN7S2012C43v11Ev
  virtual void  v12(); // _ZN7S2012C43v12Ev
  S2012C4(); // tgen
};
//SIG(-1 S2012C4) C1{ vd v1 v2 v3}


 S2012C4 ::~S2012C4(){ note_dtor("S2012C4", this);}
void  S2012C4 ::v10(){vfunc_called(this, "_ZN7S2012C43v10Ev");}
void  S2012C4 ::v11(){vfunc_called(this, "_ZN7S2012C43v11Ev");}
void  S2012C4 ::v12(){vfunc_called(this, "_ZN7S2012C43v12Ev");}
S2012C4 ::S2012C4(){ note_ctor("S2012C4", this);} // tgen

static void Test_S2012C4()
{
  extern Class_Descriptor cd_S2012C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2012C4, buf);
    S2012C4 *dp, &lv = *(dp=new (buf) S2012C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2012C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2012C4)");
    test_class_info(&lv, &cd_S2012C4);
    dp->~S2012C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2012C4(Test_S2012C4, "S2012C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2012C4C1Ev();
extern void _ZN7S2012C4D1Ev();
Name_Map name_map_S2012C4[] = {
  NSPAIR(_ZN7S2012C4C1Ev),
  NSPAIR(_ZN7S2012C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2012C4[];
extern void _ZN7S2012C4D1Ev();
extern void _ZN7S2012C4D0Ev();
extern void _ZN7S2012C43v10Ev();
extern void _ZN7S2012C43v11Ev();
extern void _ZN7S2012C43v12Ev();
static  VTBL_ENTRY vtc_S2012C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2012C4[0]),
  (VTBL_ENTRY)&_ZN7S2012C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2012C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v12Ev,
};
extern VTBL_ENTRY _ZTI7S2012C4[];
extern  VTBL_ENTRY _ZTV7S2012C4[];
Class_Descriptor cd_S2012C4 = {  "S2012C4", // class name
  0,0,//no base classes
  &(vtc_S2012C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2012C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2012C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2012C3  : S2012C4 {
  virtual  ~S2012C3(); // _ZN7S2012C3D1Ev
  virtual void  v13(); // _ZN7S2012C33v13Ev
  virtual void  v14(); // _ZN7S2012C33v14Ev
  virtual void  v15(); // _ZN7S2012C33v15Ev
  S2012C3(); // tgen
};
//SIG(-1 S2012C3) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3}


 S2012C3 ::~S2012C3(){ note_dtor("S2012C3", this);}
void  S2012C3 ::v13(){vfunc_called(this, "_ZN7S2012C33v13Ev");}
void  S2012C3 ::v14(){vfunc_called(this, "_ZN7S2012C33v14Ev");}
void  S2012C3 ::v15(){vfunc_called(this, "_ZN7S2012C33v15Ev");}
S2012C3 ::S2012C3(){ note_ctor("S2012C3", this);} // tgen

static void Test_S2012C3()
{
  extern Class_Descriptor cd_S2012C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2012C3, buf);
    S2012C3 *dp, &lv = *(dp=new (buf) S2012C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2012C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2012C3)");
    check_base_class_offset(lv, (S2012C4*), 0, "S2012C3");
    test_class_info(&lv, &cd_S2012C3);
    dp->~S2012C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2012C3(Test_S2012C3, "S2012C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2012C3C1Ev();
extern void _ZN7S2012C3D1Ev();
Name_Map name_map_S2012C3[] = {
  NSPAIR(_ZN7S2012C3C1Ev),
  NSPAIR(_ZN7S2012C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2012C4;
extern VTBL_ENTRY _ZTI7S2012C4[];
extern  VTBL_ENTRY _ZTV7S2012C4[];
static Base_Class bases_S2012C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2012C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2012C3[];
extern void _ZN7S2012C3D1Ev();
extern void _ZN7S2012C3D0Ev();
extern void _ZN7S2012C43v10Ev();
extern void _ZN7S2012C43v11Ev();
extern void _ZN7S2012C43v12Ev();
extern void _ZN7S2012C33v13Ev();
extern void _ZN7S2012C33v14Ev();
extern void _ZN7S2012C33v15Ev();
static  VTBL_ENTRY vtc_S2012C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2012C3[0]),
  (VTBL_ENTRY)&_ZN7S2012C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2012C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2012C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2012C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2012C33v15Ev,
};
extern VTBL_ENTRY _ZTI7S2012C3[];
extern  VTBL_ENTRY _ZTV7S2012C3[];
Class_Descriptor cd_S2012C3 = {  "S2012C3", // class name
  bases_S2012C3, 1,
  &(vtc_S2012C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2012C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2012C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2012C2  : S2012C3 {
  ::S10183C20 s2012c2f0;
  ::S10184C7_nt s2012c2f1;
  char s2012c2f2;
  virtual  ~S2012C2(); // _ZN7S2012C2D1Ev
  virtual void  v16(); // _ZN7S2012C23v16Ev
  virtual void  v17(); // _ZN7S2012C23v17Ev
  virtual void  v18(); // _ZN7S2012C23v18Ev
  S2012C2(); // tgen
};
//SIG(-1 S2012C2) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc}


 S2012C2 ::~S2012C2(){ note_dtor("S2012C2", this);}
void  S2012C2 ::v16(){vfunc_called(this, "_ZN7S2012C23v16Ev");}
void  S2012C2 ::v17(){vfunc_called(this, "_ZN7S2012C23v17Ev");}
void  S2012C2 ::v18(){vfunc_called(this, "_ZN7S2012C23v18Ev");}
S2012C2 ::S2012C2(){ note_ctor("S2012C2", this);} // tgen

static void Test_S2012C2()
{
  extern Class_Descriptor cd_S2012C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2012C2, buf);
    S2012C2 *dp, &lv = *(dp=new (buf) S2012C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2012C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2012C2)");
    check_base_class_offset(lv, (S2012C4*)(S2012C3*), 0, "S2012C2");
    check_base_class_offset(lv, (S2012C3*), 0, "S2012C2");
    check_field_offset(lv, s2012c2f0, ABISELECT(8,4), "S2012C2.s2012c2f0");
    check_field_offset(lv, s2012c2f1, ABISELECT(32,20), "S2012C2.s2012c2f1");
    check_field_offset(lv, s2012c2f2, ABISELECT(64,52), "S2012C2.s2012c2f2");
    test_class_info(&lv, &cd_S2012C2);
    dp->~S2012C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2012C2(Test_S2012C2, "S2012C2", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2012C2C1Ev();
extern void _ZN7S2012C2D1Ev();
Name_Map name_map_S2012C2[] = {
  NSPAIR(_ZN7S2012C2C1Ev),
  NSPAIR(_ZN7S2012C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2012C4;
extern VTBL_ENTRY _ZTI7S2012C4[];
extern  VTBL_ENTRY _ZTV7S2012C4[];
extern Class_Descriptor cd_S2012C3;
extern VTBL_ENTRY _ZTI7S2012C3[];
extern  VTBL_ENTRY _ZTV7S2012C3[];
static Base_Class bases_S2012C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2012C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2012C2[];
extern void _ZN7S2012C2D1Ev();
extern void _ZN7S2012C2D0Ev();
extern void _ZN7S2012C43v10Ev();
extern void _ZN7S2012C43v11Ev();
extern void _ZN7S2012C43v12Ev();
extern void _ZN7S2012C33v13Ev();
extern void _ZN7S2012C33v14Ev();
extern void _ZN7S2012C33v15Ev();
extern void _ZN7S2012C23v16Ev();
extern void _ZN7S2012C23v17Ev();
extern void _ZN7S2012C23v18Ev();
static  VTBL_ENTRY vtc_S2012C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2012C2[0]),
  (VTBL_ENTRY)&_ZN7S2012C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2012C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2012C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2012C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2012C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2012C23v16Ev,
  (VTBL_ENTRY)&_ZN7S2012C23v17Ev,
  (VTBL_ENTRY)&_ZN7S2012C23v18Ev,
};
extern VTBL_ENTRY _ZTI7S2012C2[];
extern  VTBL_ENTRY _ZTV7S2012C2[];
Class_Descriptor cd_S2012C2 = {  "S2012C2", // class name
  bases_S2012C2, 2,
  &(vtc_S2012C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2012C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2012C2),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2012C10  {
  void *s2012c10f0[2];
  virtual  ~S2012C10(); // _ZN8S2012C10D1Ev
  virtual void  v19(); // _ZN8S2012C103v19Ev
  virtual void  v20(); // _ZN8S2012C103v20Ev
  virtual void  v21(); // _ZN8S2012C103v21Ev
  virtual void  v22(); // _ZN8S2012C103v22Ev
  virtual void  v23(); // _ZN8S2012C103v23Ev
  virtual void  v24(); // _ZN8S2012C103v24Ev
  virtual void  v25(); // _ZN8S2012C103v25Ev
  virtual void  v26(); // _ZN8S2012C103v26Ev
  virtual void  v27(); // _ZN8S2012C103v27Ev
  virtual void  v28(); // _ZN8S2012C103v28Ev
  virtual void  v29(); // _ZN8S2012C103v29Ev
  virtual void  v30(); // _ZN8S2012C103v30Ev
  virtual void  v31(); // _ZN8S2012C103v31Ev
  virtual void  v32(); // _ZN8S2012C103v32Ev
  S2012C10(); // tgen
};
//SIG(-1 S2012C10) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp[2]}


 S2012C10 ::~S2012C10(){ note_dtor("S2012C10", this);}
void  S2012C10 ::v19(){vfunc_called(this, "_ZN8S2012C103v19Ev");}
void  S2012C10 ::v20(){vfunc_called(this, "_ZN8S2012C103v20Ev");}
void  S2012C10 ::v21(){vfunc_called(this, "_ZN8S2012C103v21Ev");}
void  S2012C10 ::v22(){vfunc_called(this, "_ZN8S2012C103v22Ev");}
void  S2012C10 ::v23(){vfunc_called(this, "_ZN8S2012C103v23Ev");}
void  S2012C10 ::v24(){vfunc_called(this, "_ZN8S2012C103v24Ev");}
void  S2012C10 ::v25(){vfunc_called(this, "_ZN8S2012C103v25Ev");}
void  S2012C10 ::v26(){vfunc_called(this, "_ZN8S2012C103v26Ev");}
void  S2012C10 ::v27(){vfunc_called(this, "_ZN8S2012C103v27Ev");}
void  S2012C10 ::v28(){vfunc_called(this, "_ZN8S2012C103v28Ev");}
void  S2012C10 ::v29(){vfunc_called(this, "_ZN8S2012C103v29Ev");}
void  S2012C10 ::v30(){vfunc_called(this, "_ZN8S2012C103v30Ev");}
void  S2012C10 ::v31(){vfunc_called(this, "_ZN8S2012C103v31Ev");}
void  S2012C10 ::v32(){vfunc_called(this, "_ZN8S2012C103v32Ev");}
S2012C10 ::S2012C10(){ note_ctor("S2012C10", this);} // tgen

static void Test_S2012C10()
{
  extern Class_Descriptor cd_S2012C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S2012C10, buf);
    S2012C10 *dp, &lv = *(dp=new (buf) S2012C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S2012C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2012C10)");
    check_field_offset(lv, s2012c10f0, ABISELECT(8,4), "S2012C10.s2012c10f0");
    test_class_info(&lv, &cd_S2012C10);
    dp->~S2012C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2012C10(Test_S2012C10, "S2012C10", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S2012C10C1Ev();
extern void _ZN8S2012C10D1Ev();
Name_Map name_map_S2012C10[] = {
  NSPAIR(_ZN8S2012C10C1Ev),
  NSPAIR(_ZN8S2012C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2012C10[];
extern void _ZN8S2012C10D1Ev();
extern void _ZN8S2012C10D0Ev();
extern void _ZN8S2012C103v19Ev();
extern void _ZN8S2012C103v20Ev();
extern void _ZN8S2012C103v21Ev();
extern void _ZN8S2012C103v22Ev();
extern void _ZN8S2012C103v23Ev();
extern void _ZN8S2012C103v24Ev();
extern void _ZN8S2012C103v25Ev();
extern void _ZN8S2012C103v26Ev();
extern void _ZN8S2012C103v27Ev();
extern void _ZN8S2012C103v28Ev();
extern void _ZN8S2012C103v29Ev();
extern void _ZN8S2012C103v30Ev();
extern void _ZN8S2012C103v31Ev();
extern void _ZN8S2012C103v32Ev();
static  VTBL_ENTRY vtc_S2012C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2012C10[0]),
  (VTBL_ENTRY)&_ZN8S2012C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2012C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v19Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v20Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v23Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v24Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v32Ev,
};
extern VTBL_ENTRY _ZTI8S2012C10[];
extern  VTBL_ENTRY _ZTV8S2012C10[];
Class_Descriptor cd_S2012C10 = {  "S2012C10", // class name
  0,0,//no base classes
  &(vtc_S2012C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S2012C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2012C10),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2012C9  : S2012C10 {
  ::S10183C5_nt s2012c9f0;
  virtual  ~S2012C9(); // _ZN7S2012C9D1Ev
  virtual void  v33(); // _ZN7S2012C93v33Ev
  virtual void  v34(); // _ZN7S2012C93v34Ev
  virtual void  v35(); // _ZN7S2012C93v35Ev
  virtual void  v36(); // _ZN7S2012C93v36Ev
  virtual void  v37(); // _ZN7S2012C93v37Ev
  virtual void  v38(); // _ZN7S2012C93v38Ev
  virtual void  v39(); // _ZN7S2012C93v39Ev
  S2012C9(); // tgen
};
//SIG(-1 S2012C9) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 FC3{ m Fp Fi[2] FC4{ m}}}


 S2012C9 ::~S2012C9(){ note_dtor("S2012C9", this);}
void  S2012C9 ::v33(){vfunc_called(this, "_ZN7S2012C93v33Ev");}
void  S2012C9 ::v34(){vfunc_called(this, "_ZN7S2012C93v34Ev");}
void  S2012C9 ::v35(){vfunc_called(this, "_ZN7S2012C93v35Ev");}
void  S2012C9 ::v36(){vfunc_called(this, "_ZN7S2012C93v36Ev");}
void  S2012C9 ::v37(){vfunc_called(this, "_ZN7S2012C93v37Ev");}
void  S2012C9 ::v38(){vfunc_called(this, "_ZN7S2012C93v38Ev");}
void  S2012C9 ::v39(){vfunc_called(this, "_ZN7S2012C93v39Ev");}
S2012C9 ::S2012C9(){ note_ctor("S2012C9", this);} // tgen

static void Test_S2012C9()
{
  extern Class_Descriptor cd_S2012C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_S2012C9, buf);
    S2012C9 *dp, &lv = *(dp=new (buf) S2012C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S2012C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2012C9)");
    check_base_class_offset(lv, (S2012C10*), 0, "S2012C9");
    check_field_offset(lv, s2012c9f0, ABISELECT(24,12), "S2012C9.s2012c9f0");
    test_class_info(&lv, &cd_S2012C9);
    dp->~S2012C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2012C9(Test_S2012C9, "S2012C9", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN7S2012C9C1Ev();
extern void _ZN7S2012C9D1Ev();
Name_Map name_map_S2012C9[] = {
  NSPAIR(_ZN7S2012C9C1Ev),
  NSPAIR(_ZN7S2012C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2012C10;
extern VTBL_ENTRY _ZTI8S2012C10[];
extern  VTBL_ENTRY _ZTV8S2012C10[];
static Base_Class bases_S2012C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2012C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2012C9[];
extern void _ZN7S2012C9D1Ev();
extern void _ZN7S2012C9D0Ev();
extern void _ZN8S2012C103v19Ev();
extern void _ZN8S2012C103v20Ev();
extern void _ZN8S2012C103v21Ev();
extern void _ZN8S2012C103v22Ev();
extern void _ZN8S2012C103v23Ev();
extern void _ZN8S2012C103v24Ev();
extern void _ZN8S2012C103v25Ev();
extern void _ZN8S2012C103v26Ev();
extern void _ZN8S2012C103v27Ev();
extern void _ZN8S2012C103v28Ev();
extern void _ZN8S2012C103v29Ev();
extern void _ZN8S2012C103v30Ev();
extern void _ZN8S2012C103v31Ev();
extern void _ZN8S2012C103v32Ev();
extern void _ZN7S2012C93v33Ev();
extern void _ZN7S2012C93v34Ev();
extern void _ZN7S2012C93v35Ev();
extern void _ZN7S2012C93v36Ev();
extern void _ZN7S2012C93v37Ev();
extern void _ZN7S2012C93v38Ev();
extern void _ZN7S2012C93v39Ev();
static  VTBL_ENTRY vtc_S2012C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2012C9[0]),
  (VTBL_ENTRY)&_ZN7S2012C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2012C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v19Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v20Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v23Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v24Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v32Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v33Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v34Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v35Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v36Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v37Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v38Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v39Ev,
};
extern VTBL_ENTRY _ZTI7S2012C9[];
extern  VTBL_ENTRY _ZTV7S2012C9[];
Class_Descriptor cd_S2012C9 = {  "S2012C9", // class name
  bases_S2012C9, 1,
  &(vtc_S2012C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI7S2012C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2012C9),25, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2012C1  : S2012C2 , S2012C9 {
  ::S2041C13 s2012c1f0;
  virtual  ~S2012C1(); // _ZN7S2012C1D1Ev
  virtual void  v1(); // _ZN7S2012C12v1Ev
  virtual void  v2(); // _ZN7S2012C12v2Ev
  virtual void  v3(); // _ZN7S2012C12v3Ev
  virtual void  v4(); // _ZN7S2012C12v4Ev
  virtual void  v5(); // _ZN7S2012C12v5Ev
  virtual void  v6(); // _ZN7S2012C12v6Ev
  virtual void  v7(); // _ZN7S2012C12v7Ev
  virtual void  v8(); // _ZN7S2012C12v8Ev
  virtual void  v9(); // _ZN7S2012C12v9Ev
  S2012C1(); // tgen
};
//SIG(1 S2012C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12} vd v13 v14 v15} vd v16 v17 v18 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FC8{ FL[4]}} Fc} BC9{ BC10{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp[2]} vd v33 v34 v35 v36 v37 v38 v39 FC11{ m Fp Fi[2] FC12{ m}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC13{ BC14{ vd} Fi FC15{ BC16{ vd v42 v43} vd v40 v41 FC17{ m Fp Fi FC18{ m}} FC17 Fi} FC19{ BC16 vd v44 v45 FC20{ BC16 vd v46 v47 FC17} FC15 FC21{ BC5 BC16 vd v48 v49} FC22{ vd m FC23{ m Fs[6] Fi[2] Fc Fs}} FC17 FC17 Fc[2] Fi FC17 FC17 FC17 FC17 FC17 Fi[3] Fp FC17 FC22 FC17 Fi} FC24{ Fi FC25{ Fp[3] Fc[60] Fi} Fi[3] Fp[5] Fc[28]}}}


 S2012C1 ::~S2012C1(){ note_dtor("S2012C1", this);}
void  S2012C1 ::v1(){vfunc_called(this, "_ZN7S2012C12v1Ev");}
void  S2012C1 ::v2(){vfunc_called(this, "_ZN7S2012C12v2Ev");}
void  S2012C1 ::v3(){vfunc_called(this, "_ZN7S2012C12v3Ev");}
void  S2012C1 ::v4(){vfunc_called(this, "_ZN7S2012C12v4Ev");}
void  S2012C1 ::v5(){vfunc_called(this, "_ZN7S2012C12v5Ev");}
void  S2012C1 ::v6(){vfunc_called(this, "_ZN7S2012C12v6Ev");}
void  S2012C1 ::v7(){vfunc_called(this, "_ZN7S2012C12v7Ev");}
void  S2012C1 ::v8(){vfunc_called(this, "_ZN7S2012C12v8Ev");}
void  S2012C1 ::v9(){vfunc_called(this, "_ZN7S2012C12v9Ev");}
S2012C1 ::S2012C1(){ note_ctor("S2012C1", this);} // tgen

static void Test_S2012C1()
{
  extern Class_Descriptor cd_S2012C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(92,133)];
    init_test(&cd_S2012C1, buf);
    S2012C1 *dp, &lv = *(dp=new (buf) S2012C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(728,528), "sizeof(S2012C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2012C1)");
    check_base_class_offset(lv, (S2012C4*)(S2012C3*)(S2012C2*), 0, "S2012C1");
    check_base_class_offset(lv, (S2012C3*)(S2012C2*), 0, "S2012C1");
    check_base_class_offset(lv, (S2012C2*), 0, "S2012C1");
    check_base_class_offset(lv, (S2012C10*)(S2012C9*), ABISELECT(72,56), "S2012C1");
    check_base_class_offset(lv, (S2012C9*), ABISELECT(72,56), "S2012C1");
    check_field_offset(lv, s2012c1f0, ABISELECT(120,84), "S2012C1.s2012c1f0");
    test_class_info(&lv, &cd_S2012C1);
    dp->~S2012C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2012C1(Test_S2012C1, "S2012C1", ABISELECT(728,528));

#else // __cplusplus

extern void _ZN7S2012C1C1Ev();
extern void _ZN7S2012C1D1Ev();
Name_Map name_map_S2012C1[] = {
  NSPAIR(_ZN7S2012C1C1Ev),
  NSPAIR(_ZN7S2012C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2012C4;
extern VTBL_ENTRY _ZTI7S2012C4[];
extern  VTBL_ENTRY _ZTV7S2012C4[];
extern Class_Descriptor cd_S2012C3;
extern VTBL_ENTRY _ZTI7S2012C3[];
extern  VTBL_ENTRY _ZTV7S2012C3[];
extern Class_Descriptor cd_S2012C2;
extern VTBL_ENTRY _ZTI7S2012C2[];
extern  VTBL_ENTRY _ZTV7S2012C2[];
extern Class_Descriptor cd_S2012C10;
extern VTBL_ENTRY _ZTI8S2012C10[];
extern  VTBL_ENTRY _ZTV8S2012C10[];
extern Class_Descriptor cd_S2012C9;
extern VTBL_ENTRY _ZTI7S2012C9[];
extern  VTBL_ENTRY _ZTV7S2012C9[];
static Base_Class bases_S2012C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2012C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2012C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2012C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2012C10,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2012C9,    ABISELECT(72,56), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2012C1[];
extern void _ZN7S2012C1D1Ev();
extern void _ZN7S2012C1D0Ev();
extern void _ZN7S2012C43v10Ev();
extern void _ZN7S2012C43v11Ev();
extern void _ZN7S2012C43v12Ev();
extern void _ZN7S2012C33v13Ev();
extern void _ZN7S2012C33v14Ev();
extern void _ZN7S2012C33v15Ev();
extern void _ZN7S2012C23v16Ev();
extern void _ZN7S2012C23v17Ev();
extern void _ZN7S2012C23v18Ev();
extern void _ZN7S2012C12v1Ev();
extern void _ZN7S2012C12v2Ev();
extern void _ZN7S2012C12v3Ev();
extern void _ZN7S2012C12v4Ev();
extern void _ZN7S2012C12v5Ev();
extern void _ZN7S2012C12v6Ev();
extern void _ZN7S2012C12v7Ev();
extern void _ZN7S2012C12v8Ev();
extern void _ZN7S2012C12v9Ev();
extern void ABISELECT(_ZThn72_N7S2012C1D1Ev,_ZThn56_N7S2012C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2012C1D0Ev,_ZThn56_N7S2012C1D0Ev)();
extern void _ZN8S2012C103v19Ev();
extern void _ZN8S2012C103v20Ev();
extern void _ZN8S2012C103v21Ev();
extern void _ZN8S2012C103v22Ev();
extern void _ZN8S2012C103v23Ev();
extern void _ZN8S2012C103v24Ev();
extern void _ZN8S2012C103v25Ev();
extern void _ZN8S2012C103v26Ev();
extern void _ZN8S2012C103v27Ev();
extern void _ZN8S2012C103v28Ev();
extern void _ZN8S2012C103v29Ev();
extern void _ZN8S2012C103v30Ev();
extern void _ZN8S2012C103v31Ev();
extern void _ZN8S2012C103v32Ev();
extern void _ZN7S2012C93v33Ev();
extern void _ZN7S2012C93v34Ev();
extern void _ZN7S2012C93v35Ev();
extern void _ZN7S2012C93v36Ev();
extern void _ZN7S2012C93v37Ev();
extern void _ZN7S2012C93v38Ev();
extern void _ZN7S2012C93v39Ev();
static  VTBL_ENTRY vtc_S2012C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2012C1[0]),
  (VTBL_ENTRY)&_ZN7S2012C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2012C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2012C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2012C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2012C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2012C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2012C23v16Ev,
  (VTBL_ENTRY)&_ZN7S2012C23v17Ev,
  (VTBL_ENTRY)&_ZN7S2012C23v18Ev,
  (VTBL_ENTRY)&_ZN7S2012C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2012C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2012C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2012C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2012C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2012C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2012C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2012C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2012C12v9Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S2012C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2012C1D1Ev,_ZThn56_N7S2012C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2012C1D0Ev,_ZThn56_N7S2012C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2012C103v19Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v20Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v23Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v24Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v25Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v26Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v27Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v28Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v29Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v30Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v31Ev,
  (VTBL_ENTRY)&_ZN8S2012C103v32Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v33Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v34Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v35Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v36Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v37Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v38Ev,
  (VTBL_ENTRY)&_ZN7S2012C93v39Ev,
};
extern VTBL_ENTRY _ZTI7S2012C1[];
extern  VTBL_ENTRY _ZTV7S2012C1[];
Class_Descriptor cd_S2012C1 = {  "S2012C1", // class name
  bases_S2012C1, 5,
  &(vtc_S2012C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(728,528), // object size
  NSPAIRA(_ZTI7S2012C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2012C1),47, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2331C4  {
  ::S10183C15_nt s2331c4f0;
  int s2331c4f1[2];
  char s2331c4f2;
  virtual  ~S2331C4(); // _ZN7S2331C4D1Ev
  virtual void  v5(); // _ZN7S2331C42v5Ev
  virtual void  v6(); // _ZN7S2331C42v6Ev
  virtual void  v7(); // _ZN7S2331C42v7Ev
  S2331C4(); // tgen
};
//SIG(-1 S2331C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2331C4 ::~S2331C4(){ note_dtor("S2331C4", this);}
void  S2331C4 ::v5(){vfunc_called(this, "_ZN7S2331C42v5Ev");}
void  S2331C4 ::v6(){vfunc_called(this, "_ZN7S2331C42v6Ev");}
void  S2331C4 ::v7(){vfunc_called(this, "_ZN7S2331C42v7Ev");}
S2331C4 ::S2331C4(){ note_ctor("S2331C4", this);} // tgen

static void Test_S2331C4()
{
  extern Class_Descriptor cd_S2331C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2331C4, buf);
    S2331C4 *dp, &lv = *(dp=new (buf) S2331C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2331C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2331C4)");
    check_field_offset(lv, s2331c4f0, ABISELECT(8,4), "S2331C4.s2331c4f0");
    check_field_offset(lv, s2331c4f1, ABISELECT(24,16), "S2331C4.s2331c4f1");
    check_field_offset(lv, s2331c4f2, ABISELECT(32,24), "S2331C4.s2331c4f2");
    test_class_info(&lv, &cd_S2331C4);
    dp->~S2331C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2331C4(Test_S2331C4, "S2331C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2331C4C1Ev();
extern void _ZN7S2331C4D1Ev();
Name_Map name_map_S2331C4[] = {
  NSPAIR(_ZN7S2331C4C1Ev),
  NSPAIR(_ZN7S2331C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2331C4[];
extern void _ZN7S2331C4D1Ev();
extern void _ZN7S2331C4D0Ev();
extern void _ZN7S2331C42v5Ev();
extern void _ZN7S2331C42v6Ev();
extern void _ZN7S2331C42v7Ev();
static  VTBL_ENTRY vtc_S2331C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2331C4[0]),
  (VTBL_ENTRY)&_ZN7S2331C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2331C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v7Ev,
};
extern VTBL_ENTRY _ZTI7S2331C4[];
extern  VTBL_ENTRY _ZTV7S2331C4[];
Class_Descriptor cd_S2331C4 = {  "S2331C4", // class name
  0,0,//no base classes
  &(vtc_S2331C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2331C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2331C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2331C7  {
  virtual  ~S2331C7(); // _ZN7S2331C7D1Ev
  virtual void  v8(); // _ZN7S2331C72v8Ev
  virtual void  v9(); // _ZN7S2331C72v9Ev
  virtual void  v10(); // _ZN7S2331C73v10Ev
  S2331C7(); // tgen
};
//SIG(-1 S2331C7) C1{ vd v1 v2 v3}


 S2331C7 ::~S2331C7(){ note_dtor("S2331C7", this);}
void  S2331C7 ::v8(){vfunc_called(this, "_ZN7S2331C72v8Ev");}
void  S2331C7 ::v9(){vfunc_called(this, "_ZN7S2331C72v9Ev");}
void  S2331C7 ::v10(){vfunc_called(this, "_ZN7S2331C73v10Ev");}
S2331C7 ::S2331C7(){ note_ctor("S2331C7", this);} // tgen

static void Test_S2331C7()
{
  extern Class_Descriptor cd_S2331C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2331C7, buf);
    S2331C7 *dp, &lv = *(dp=new (buf) S2331C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2331C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2331C7)");
    test_class_info(&lv, &cd_S2331C7);
    dp->~S2331C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2331C7(Test_S2331C7, "S2331C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2331C7C1Ev();
extern void _ZN7S2331C7D1Ev();
Name_Map name_map_S2331C7[] = {
  NSPAIR(_ZN7S2331C7C1Ev),
  NSPAIR(_ZN7S2331C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2331C7[];
extern void _ZN7S2331C7D1Ev();
extern void _ZN7S2331C7D0Ev();
extern void _ZN7S2331C72v8Ev();
extern void _ZN7S2331C72v9Ev();
extern void _ZN7S2331C73v10Ev();
static  VTBL_ENTRY vtc_S2331C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2331C7[0]),
  (VTBL_ENTRY)&_ZN7S2331C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2331C7D0Ev,
  (VTBL_ENTRY)&_ZN7S2331C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2331C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2331C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2331C7[];
extern  VTBL_ENTRY _ZTV7S2331C7[];
Class_Descriptor cd_S2331C7 = {  "S2331C7", // class name
  0,0,//no base classes
  &(vtc_S2331C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2331C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2331C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2331C3  : S2331C4 , S2331C7 {
  void *s2331c3f0;
  char s2331c3f1;
  int s2331c3f2;
  virtual  ~S2331C3(); // _ZN7S2331C3D1Ev
  virtual void  v11(); // _ZN7S2331C33v11Ev
  virtual void  v12(); // _ZN7S2331C33v12Ev
  virtual void  v13(); // _ZN7S2331C33v13Ev
  virtual void  v14(); // _ZN7S2331C33v14Ev
  virtual void  v15(); // _ZN7S2331C33v15Ev
  virtual void  v16(); // _ZN7S2331C33v16Ev
  virtual void  v17(); // _ZN7S2331C33v17Ev
  virtual void  v18(); // _ZN7S2331C33v18Ev
  virtual void  v19(); // _ZN7S2331C33v19Ev
  virtual void  v20(); // _ZN7S2331C33v20Ev
  S2331C3(); // tgen
};
//SIG(-1 S2331C3) C1{ BC2{ vd v11 v12 v13 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ vd v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi}


 S2331C3 ::~S2331C3(){ note_dtor("S2331C3", this);}
void  S2331C3 ::v11(){vfunc_called(this, "_ZN7S2331C33v11Ev");}
void  S2331C3 ::v12(){vfunc_called(this, "_ZN7S2331C33v12Ev");}
void  S2331C3 ::v13(){vfunc_called(this, "_ZN7S2331C33v13Ev");}
void  S2331C3 ::v14(){vfunc_called(this, "_ZN7S2331C33v14Ev");}
void  S2331C3 ::v15(){vfunc_called(this, "_ZN7S2331C33v15Ev");}
void  S2331C3 ::v16(){vfunc_called(this, "_ZN7S2331C33v16Ev");}
void  S2331C3 ::v17(){vfunc_called(this, "_ZN7S2331C33v17Ev");}
void  S2331C3 ::v18(){vfunc_called(this, "_ZN7S2331C33v18Ev");}
void  S2331C3 ::v19(){vfunc_called(this, "_ZN7S2331C33v19Ev");}
void  S2331C3 ::v20(){vfunc_called(this, "_ZN7S2331C33v20Ev");}
S2331C3 ::S2331C3(){ note_ctor("S2331C3", this);} // tgen

static void Test_S2331C3()
{
  extern Class_Descriptor cd_S2331C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S2331C3, buf);
    S2331C3 *dp, &lv = *(dp=new (buf) S2331C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2331C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2331C3)");
    check_base_class_offset(lv, (S2331C4*), 0, "S2331C3");
    check_base_class_offset(lv, (S2331C7*), ABISELECT(40,28), "S2331C3");
    check_field_offset(lv, s2331c3f0, ABISELECT(48,32), "S2331C3.s2331c3f0");
    check_field_offset(lv, s2331c3f1, ABISELECT(56,36), "S2331C3.s2331c3f1");
    check_field_offset(lv, s2331c3f2, ABISELECT(60,40), "S2331C3.s2331c3f2");
    test_class_info(&lv, &cd_S2331C3);
    dp->~S2331C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2331C3(Test_S2331C3, "S2331C3", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN7S2331C3C1Ev();
extern void _ZN7S2331C3D1Ev();
Name_Map name_map_S2331C3[] = {
  NSPAIR(_ZN7S2331C3C1Ev),
  NSPAIR(_ZN7S2331C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2331C4;
extern VTBL_ENTRY _ZTI7S2331C4[];
extern  VTBL_ENTRY _ZTV7S2331C4[];
extern Class_Descriptor cd_S2331C7;
extern VTBL_ENTRY _ZTI7S2331C7[];
extern  VTBL_ENTRY _ZTV7S2331C7[];
static Base_Class bases_S2331C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2331C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2331C7,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2331C3[];
extern void _ZN7S2331C3D1Ev();
extern void _ZN7S2331C3D0Ev();
extern void _ZN7S2331C42v5Ev();
extern void _ZN7S2331C42v6Ev();
extern void _ZN7S2331C42v7Ev();
extern void _ZN7S2331C33v11Ev();
extern void _ZN7S2331C33v12Ev();
extern void _ZN7S2331C33v13Ev();
extern void _ZN7S2331C33v14Ev();
extern void _ZN7S2331C33v15Ev();
extern void _ZN7S2331C33v16Ev();
extern void _ZN7S2331C33v17Ev();
extern void _ZN7S2331C33v18Ev();
extern void _ZN7S2331C33v19Ev();
extern void _ZN7S2331C33v20Ev();
extern void ABISELECT(_ZThn40_N7S2331C3D1Ev,_ZThn28_N7S2331C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S2331C3D0Ev,_ZThn28_N7S2331C3D0Ev)();
extern void _ZN7S2331C72v8Ev();
extern void _ZN7S2331C72v9Ev();
extern void _ZN7S2331C73v10Ev();
static  VTBL_ENTRY vtc_S2331C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2331C3[0]),
  (VTBL_ENTRY)&_ZN7S2331C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2331C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v20Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2331C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2331C3D1Ev,_ZThn28_N7S2331C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2331C3D0Ev,_ZThn28_N7S2331C3D0Ev),
  (VTBL_ENTRY)&_ZN7S2331C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2331C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2331C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2331C3[];
extern  VTBL_ENTRY _ZTV7S2331C3[];
Class_Descriptor cd_S2331C3 = {  "S2331C3", // class name
  bases_S2331C3, 2,
  &(vtc_S2331C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI7S2331C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2331C3),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2331C10  {
  virtual  ~S2331C10(); // _ZN8S2331C10D1Ev
  virtual void  v21(); // _ZN8S2331C103v21Ev
  virtual void  v22(); // _ZN8S2331C103v22Ev
  virtual void  v23(); // _ZN8S2331C103v23Ev
  S2331C10(); // tgen
};
//SIG(-1 S2331C10) C1{ vd v1 v2 v3}


 S2331C10 ::~S2331C10(){ note_dtor("S2331C10", this);}
void  S2331C10 ::v21(){vfunc_called(this, "_ZN8S2331C103v21Ev");}
void  S2331C10 ::v22(){vfunc_called(this, "_ZN8S2331C103v22Ev");}
void  S2331C10 ::v23(){vfunc_called(this, "_ZN8S2331C103v23Ev");}
S2331C10 ::S2331C10(){ note_ctor("S2331C10", this);} // tgen

static void Test_S2331C10()
{
  extern Class_Descriptor cd_S2331C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2331C10, buf);
    S2331C10 *dp, &lv = *(dp=new (buf) S2331C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2331C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2331C10)");
    test_class_info(&lv, &cd_S2331C10);
    dp->~S2331C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2331C10(Test_S2331C10, "S2331C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2331C10C1Ev();
extern void _ZN8S2331C10D1Ev();
Name_Map name_map_S2331C10[] = {
  NSPAIR(_ZN8S2331C10C1Ev),
  NSPAIR(_ZN8S2331C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2331C10[];
extern void _ZN8S2331C10D1Ev();
extern void _ZN8S2331C10D0Ev();
extern void _ZN8S2331C103v21Ev();
extern void _ZN8S2331C103v22Ev();
extern void _ZN8S2331C103v23Ev();
static  VTBL_ENTRY vtc_S2331C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2331C10[0]),
  (VTBL_ENTRY)&_ZN8S2331C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2331C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v23Ev,
};
extern VTBL_ENTRY _ZTI8S2331C10[];
extern  VTBL_ENTRY _ZTV8S2331C10[];
Class_Descriptor cd_S2331C10 = {  "S2331C10", // class name
  0,0,//no base classes
  &(vtc_S2331C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2331C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2331C10),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2331C9  : S2331C10 {
  ::S10183C20 s2331c9f0;
  ::S10184C7_nt s2331c9f1;
  char s2331c9f2;
  virtual  ~S2331C9(); // _ZN7S2331C9D1Ev
  virtual void  v24(); // _ZN7S2331C93v24Ev
  virtual void  v25(); // _ZN7S2331C93v25Ev
  virtual void  v26(); // _ZN7S2331C93v26Ev
  S2331C9(); // tgen
};
//SIG(-1 S2331C9) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ FL[4]}} Fc}


 S2331C9 ::~S2331C9(){ note_dtor("S2331C9", this);}
void  S2331C9 ::v24(){vfunc_called(this, "_ZN7S2331C93v24Ev");}
void  S2331C9 ::v25(){vfunc_called(this, "_ZN7S2331C93v25Ev");}
void  S2331C9 ::v26(){vfunc_called(this, "_ZN7S2331C93v26Ev");}
S2331C9 ::S2331C9(){ note_ctor("S2331C9", this);} // tgen

static void Test_S2331C9()
{
  extern Class_Descriptor cd_S2331C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2331C9, buf);
    S2331C9 *dp, &lv = *(dp=new (buf) S2331C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2331C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2331C9)");
    check_base_class_offset(lv, (S2331C10*), 0, "S2331C9");
    check_field_offset(lv, s2331c9f0, ABISELECT(8,4), "S2331C9.s2331c9f0");
    check_field_offset(lv, s2331c9f1, ABISELECT(32,20), "S2331C9.s2331c9f1");
    check_field_offset(lv, s2331c9f2, ABISELECT(64,52), "S2331C9.s2331c9f2");
    test_class_info(&lv, &cd_S2331C9);
    dp->~S2331C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2331C9(Test_S2331C9, "S2331C9", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2331C9C1Ev();
extern void _ZN7S2331C9D1Ev();
Name_Map name_map_S2331C9[] = {
  NSPAIR(_ZN7S2331C9C1Ev),
  NSPAIR(_ZN7S2331C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2331C10;
extern VTBL_ENTRY _ZTI8S2331C10[];
extern  VTBL_ENTRY _ZTV8S2331C10[];
static Base_Class bases_S2331C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2331C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2331C9[];
extern void _ZN7S2331C9D1Ev();
extern void _ZN7S2331C9D0Ev();
extern void _ZN8S2331C103v21Ev();
extern void _ZN8S2331C103v22Ev();
extern void _ZN8S2331C103v23Ev();
extern void _ZN7S2331C93v24Ev();
extern void _ZN7S2331C93v25Ev();
extern void _ZN7S2331C93v26Ev();
static  VTBL_ENTRY vtc_S2331C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2331C9[0]),
  (VTBL_ENTRY)&_ZN7S2331C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2331C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v26Ev,
};
extern VTBL_ENTRY _ZTI7S2331C9[];
extern  VTBL_ENTRY _ZTV7S2331C9[];
Class_Descriptor cd_S2331C9 = {  "S2331C9", // class name
  bases_S2331C9, 1,
  &(vtc_S2331C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2331C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2331C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2331C8  : S2331C9 {
  virtual  ~S2331C8(); // _ZN7S2331C8D1Ev
  virtual void  v27(); // _ZN7S2331C83v27Ev
  virtual void  v28(); // _ZN7S2331C83v28Ev
  virtual void  v29(); // _ZN7S2331C83v29Ev
  virtual void  v30(); // _ZN7S2331C83v30Ev
  S2331C8(); // tgen
};
//SIG(-1 S2331C8) C1{ BC2{ BC3{ vd v5 v6 v7} vd v8 v9 v10 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc} vd v1 v2 v3 v4}


 S2331C8 ::~S2331C8(){ note_dtor("S2331C8", this);}
void  S2331C8 ::v27(){vfunc_called(this, "_ZN7S2331C83v27Ev");}
void  S2331C8 ::v28(){vfunc_called(this, "_ZN7S2331C83v28Ev");}
void  S2331C8 ::v29(){vfunc_called(this, "_ZN7S2331C83v29Ev");}
void  S2331C8 ::v30(){vfunc_called(this, "_ZN7S2331C83v30Ev");}
S2331C8 ::S2331C8(){ note_ctor("S2331C8", this);} // tgen

static void Test_S2331C8()
{
  extern Class_Descriptor cd_S2331C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2331C8, buf);
    S2331C8 *dp, &lv = *(dp=new (buf) S2331C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2331C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2331C8)");
    check_base_class_offset(lv, (S2331C10*)(S2331C9*), 0, "S2331C8");
    check_base_class_offset(lv, (S2331C9*), 0, "S2331C8");
    test_class_info(&lv, &cd_S2331C8);
    dp->~S2331C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2331C8(Test_S2331C8, "S2331C8", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2331C8C1Ev();
extern void _ZN7S2331C8D1Ev();
Name_Map name_map_S2331C8[] = {
  NSPAIR(_ZN7S2331C8C1Ev),
  NSPAIR(_ZN7S2331C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2331C10;
extern VTBL_ENTRY _ZTI8S2331C10[];
extern  VTBL_ENTRY _ZTV8S2331C10[];
extern Class_Descriptor cd_S2331C9;
extern VTBL_ENTRY _ZTI7S2331C9[];
extern  VTBL_ENTRY _ZTV7S2331C9[];
static Base_Class bases_S2331C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2331C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2331C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2331C8[];
extern void _ZN7S2331C8D1Ev();
extern void _ZN7S2331C8D0Ev();
extern void _ZN8S2331C103v21Ev();
extern void _ZN8S2331C103v22Ev();
extern void _ZN8S2331C103v23Ev();
extern void _ZN7S2331C93v24Ev();
extern void _ZN7S2331C93v25Ev();
extern void _ZN7S2331C93v26Ev();
extern void _ZN7S2331C83v27Ev();
extern void _ZN7S2331C83v28Ev();
extern void _ZN7S2331C83v29Ev();
extern void _ZN7S2331C83v30Ev();
static  VTBL_ENTRY vtc_S2331C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2331C8[0]),
  (VTBL_ENTRY)&_ZN7S2331C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2331C8D0Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2331C8[];
extern  VTBL_ENTRY _ZTV7S2331C8[];
Class_Descriptor cd_S2331C8 = {  "S2331C8", // class name
  bases_S2331C8, 2,
  &(vtc_S2331C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2331C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2331C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2331C2  : S2331C3 , S2331C8 {
  int s2331c2f0[3];
  char s2331c2f1;
  ::S10183C9_nt s2331c2f2;
  virtual  ~S2331C2(); // _ZN7S2331C2D1Ev
  virtual void  v31(); // _ZN7S2331C23v31Ev
  virtual void  v32(); // _ZN7S2331C23v32Ev
  virtual void  v33(); // _ZN7S2331C23v33Ev
  virtual void  v34(); // _ZN7S2331C23v34Ev
  virtual void  v35(); // _ZN7S2331C23v35Ev
  virtual void  v36(); // _ZN7S2331C23v36Ev
  S2331C2(); // tgen
};
//SIG(-1 S2331C2) C1{ BC2{ BC3{ vd v7 v8 v9 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} BC6{ vd v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fc Fi} BC7{ BC8{ BC9{ vd v23 v24 v25} vd v26 v27 v28 FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FC13{ FL[4]}} Fc} vd v29 v30 v31 v32} vd v1 v2 v3 v4 v5 v6 Fi[3] Fc FC14{ BC15{ m Fp Fi FC16{ m} FC5}}}


 S2331C2 ::~S2331C2(){ note_dtor("S2331C2", this);}
void  S2331C2 ::v31(){vfunc_called(this, "_ZN7S2331C23v31Ev");}
void  S2331C2 ::v32(){vfunc_called(this, "_ZN7S2331C23v32Ev");}
void  S2331C2 ::v33(){vfunc_called(this, "_ZN7S2331C23v33Ev");}
void  S2331C2 ::v34(){vfunc_called(this, "_ZN7S2331C23v34Ev");}
void  S2331C2 ::v35(){vfunc_called(this, "_ZN7S2331C23v35Ev");}
void  S2331C2 ::v36(){vfunc_called(this, "_ZN7S2331C23v36Ev");}
S2331C2 ::S2331C2(){ note_ctor("S2331C2", this);} // tgen

static void Test_S2331C2()
{
  extern Class_Descriptor cd_S2331C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,33)];
    init_test(&cd_S2331C2, buf);
    S2331C2 *dp, &lv = *(dp=new (buf) S2331C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,128), "sizeof(S2331C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2331C2)");
    check_base_class_offset(lv, (S2331C4*)(S2331C3*), 0, "S2331C2");
    check_base_class_offset(lv, (S2331C7*)(S2331C3*), ABISELECT(40,28), "S2331C2");
    check_base_class_offset(lv, (S2331C3*), 0, "S2331C2");
    check_base_class_offset(lv, (S2331C10*)(S2331C9*)(S2331C8*), ABISELECT(64,44), "S2331C2");
    check_base_class_offset(lv, (S2331C9*)(S2331C8*), ABISELECT(64,44), "S2331C2");
    check_base_class_offset(lv, (S2331C8*), ABISELECT(64,44), "S2331C2");
    check_field_offset(lv, s2331c2f0, ABISELECT(132,100), "S2331C2.s2331c2f0");
    check_field_offset(lv, s2331c2f1, ABISELECT(144,112), "S2331C2.s2331c2f1");
    check_field_offset(lv, s2331c2f2, ABISELECT(152,116), "S2331C2.s2331c2f2");
    test_class_info(&lv, &cd_S2331C2);
    dp->~S2331C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2331C2(Test_S2331C2, "S2331C2", ABISELECT(168,128));

#else // __cplusplus

extern void _ZN7S2331C2C1Ev();
extern void _ZN7S2331C2D1Ev();
Name_Map name_map_S2331C2[] = {
  NSPAIR(_ZN7S2331C2C1Ev),
  NSPAIR(_ZN7S2331C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2331C4;
extern VTBL_ENTRY _ZTI7S2331C4[];
extern  VTBL_ENTRY _ZTV7S2331C4[];
extern Class_Descriptor cd_S2331C7;
extern VTBL_ENTRY _ZTI7S2331C7[];
extern  VTBL_ENTRY _ZTV7S2331C7[];
extern Class_Descriptor cd_S2331C3;
extern VTBL_ENTRY _ZTI7S2331C3[];
extern  VTBL_ENTRY _ZTV7S2331C3[];
extern Class_Descriptor cd_S2331C10;
extern VTBL_ENTRY _ZTI8S2331C10[];
extern  VTBL_ENTRY _ZTV8S2331C10[];
extern Class_Descriptor cd_S2331C9;
extern VTBL_ENTRY _ZTI7S2331C9[];
extern  VTBL_ENTRY _ZTV7S2331C9[];
extern Class_Descriptor cd_S2331C8;
extern VTBL_ENTRY _ZTI7S2331C8[];
extern  VTBL_ENTRY _ZTV7S2331C8[];
static Base_Class bases_S2331C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2331C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2331C7,    ABISELECT(40,28), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2331C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2331C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2331C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2331C8,    ABISELECT(64,44), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2331C2[];
extern void _ZN7S2331C2D1Ev();
extern void _ZN7S2331C2D0Ev();
extern void _ZN7S2331C42v5Ev();
extern void _ZN7S2331C42v6Ev();
extern void _ZN7S2331C42v7Ev();
extern void _ZN7S2331C33v11Ev();
extern void _ZN7S2331C33v12Ev();
extern void _ZN7S2331C33v13Ev();
extern void _ZN7S2331C33v14Ev();
extern void _ZN7S2331C33v15Ev();
extern void _ZN7S2331C33v16Ev();
extern void _ZN7S2331C33v17Ev();
extern void _ZN7S2331C33v18Ev();
extern void _ZN7S2331C33v19Ev();
extern void _ZN7S2331C33v20Ev();
extern void _ZN7S2331C23v31Ev();
extern void _ZN7S2331C23v32Ev();
extern void _ZN7S2331C23v33Ev();
extern void _ZN7S2331C23v34Ev();
extern void _ZN7S2331C23v35Ev();
extern void _ZN7S2331C23v36Ev();
extern void ABISELECT(_ZThn40_N7S2331C2D1Ev,_ZThn28_N7S2331C2D1Ev)();
extern void ABISELECT(_ZThn40_N7S2331C2D0Ev,_ZThn28_N7S2331C2D0Ev)();
extern void _ZN7S2331C72v8Ev();
extern void _ZN7S2331C72v9Ev();
extern void _ZN7S2331C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2331C2D1Ev,_ZThn44_N7S2331C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S2331C2D0Ev,_ZThn44_N7S2331C2D0Ev)();
extern void _ZN8S2331C103v21Ev();
extern void _ZN8S2331C103v22Ev();
extern void _ZN8S2331C103v23Ev();
extern void _ZN7S2331C93v24Ev();
extern void _ZN7S2331C93v25Ev();
extern void _ZN7S2331C93v26Ev();
extern void _ZN7S2331C83v27Ev();
extern void _ZN7S2331C83v28Ev();
extern void _ZN7S2331C83v29Ev();
extern void _ZN7S2331C83v30Ev();
static  VTBL_ENTRY vtc_S2331C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2331C2[0]),
  (VTBL_ENTRY)&_ZN7S2331C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2331C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v36Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2331C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2331C2D1Ev,_ZThn28_N7S2331C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2331C2D0Ev,_ZThn28_N7S2331C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2331C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2331C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2331C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2331C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2331C2D1Ev,_ZThn44_N7S2331C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2331C2D0Ev,_ZThn44_N7S2331C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2331C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2331C2[];
extern  VTBL_ENTRY _ZTV7S2331C2[];
Class_Descriptor cd_S2331C2 = {  "S2331C2", // class name
  bases_S2331C2, 6,
  &(vtc_S2331C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,128), // object size
  NSPAIRA(_ZTI7S2331C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2331C2),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2331C19  {
  void *s2331c19f0;
  virtual  ~S2331C19(); // _ZN8S2331C19D1Ev
  virtual void  v37(); // _ZN8S2331C193v37Ev
  virtual void  v38(); // _ZN8S2331C193v38Ev
  virtual void  v39(); // _ZN8S2331C193v39Ev
  virtual void  v40(); // _ZN8S2331C193v40Ev
  S2331C19(); // tgen
};
//SIG(-1 S2331C19) C1{ vd v1 v2 v3 v4 Fp}


 S2331C19 ::~S2331C19(){ note_dtor("S2331C19", this);}
void  S2331C19 ::v37(){vfunc_called(this, "_ZN8S2331C193v37Ev");}
void  S2331C19 ::v38(){vfunc_called(this, "_ZN8S2331C193v38Ev");}
void  S2331C19 ::v39(){vfunc_called(this, "_ZN8S2331C193v39Ev");}
void  S2331C19 ::v40(){vfunc_called(this, "_ZN8S2331C193v40Ev");}
S2331C19 ::S2331C19(){ note_ctor("S2331C19", this);} // tgen

static void Test_S2331C19()
{
  extern Class_Descriptor cd_S2331C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S2331C19, buf);
    S2331C19 *dp, &lv = *(dp=new (buf) S2331C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S2331C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2331C19)");
    check_field_offset(lv, s2331c19f0, ABISELECT(8,4), "S2331C19.s2331c19f0");
    test_class_info(&lv, &cd_S2331C19);
    dp->~S2331C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2331C19(Test_S2331C19, "S2331C19", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S2331C19C1Ev();
extern void _ZN8S2331C19D1Ev();
Name_Map name_map_S2331C19[] = {
  NSPAIR(_ZN8S2331C19C1Ev),
  NSPAIR(_ZN8S2331C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2331C19[];
extern void _ZN8S2331C19D1Ev();
extern void _ZN8S2331C19D0Ev();
extern void _ZN8S2331C193v37Ev();
extern void _ZN8S2331C193v38Ev();
extern void _ZN8S2331C193v39Ev();
extern void _ZN8S2331C193v40Ev();
static  VTBL_ENTRY vtc_S2331C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2331C19[0]),
  (VTBL_ENTRY)&_ZN8S2331C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2331C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2331C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2331C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2331C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2331C193v40Ev,
};
extern VTBL_ENTRY _ZTI8S2331C19[];
extern  VTBL_ENTRY _ZTV8S2331C19[];
Class_Descriptor cd_S2331C19 = {  "S2331C19", // class name
  0,0,//no base classes
  &(vtc_S2331C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S2331C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2331C19),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2331C1  : S2331C2 {
  ::S2331C19 s2331c1f0;
  ::S2348C20_nt s2331c1f1;
  int s2331c1f2[4];
  ::S9125C15 s2331c1f3;
  int s2331c1f4;
  void *s2331c1f5[2];
  ::S10183C19_nt s2331c1f6;
  virtual  ~S2331C1(); // _ZN7S2331C1D1Ev
  virtual void  v1(); // _ZN7S2331C12v1Ev
  virtual void  v2(); // _ZN7S2331C12v2Ev
  virtual void  v3(); // _ZN7S2331C12v3Ev
  virtual void  v4(); // _ZN7S2331C12v4Ev
  S2331C1(); // tgen
};
//SIG(1 S2331C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} BC7{ vd v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp Fc Fi} BC8{ BC9{ BC10{ vd v21 v22 v23} vd v24 v25 v26 FC11{ m Fp Fi[2] FC12{ m}} FC13{ m FC14{ FL[4]}} Fc} vd v27 v28 v29 v30} vd v31 v32 v33 v34 v35 v36 Fi[3] Fc FC15{ BC16{ m Fp Fi FC17{ m} FC6}}} vd v1 v2 v3 v4 FC18{ vd v37 v38 v39 v40 Fp} FC19{ BC20{ vd v42 FC21{ m FC16} Fp[3] Fc} v41 Fp} Fi[4] FC22{ Fi[2] FC23{ Fi[2]}[10] FC24{ Fi[3] Fc[256]}[10]} Fi Fp[2] FC25{ BC11 BC26{ vd v45 v46} vd v43 v44}}


 S2331C1 ::~S2331C1(){ note_dtor("S2331C1", this);}
void  S2331C1 ::v1(){vfunc_called(this, "_ZN7S2331C12v1Ev");}
void  S2331C1 ::v2(){vfunc_called(this, "_ZN7S2331C12v2Ev");}
void  S2331C1 ::v3(){vfunc_called(this, "_ZN7S2331C12v3Ev");}
void  S2331C1 ::v4(){vfunc_called(this, "_ZN7S2331C12v4Ev");}
S2331C1 ::S2331C1(){ note_ctor("S2331C1", this);} // tgen

static void Test_S2331C1()
{
  extern Class_Descriptor cd_S2331C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(387,748)];
    init_test(&cd_S2331C1, buf);
    S2331C1 *dp, &lv = *(dp=new (buf) S2331C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3088,2988), "sizeof(S2331C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2331C1)");
    check_base_class_offset(lv, (S2331C4*)(S2331C3*)(S2331C2*), 0, "S2331C1");
    check_base_class_offset(lv, (S2331C7*)(S2331C3*)(S2331C2*), ABISELECT(40,28), "S2331C1");
    check_base_class_offset(lv, (S2331C3*)(S2331C2*), 0, "S2331C1");
    check_base_class_offset(lv, (S2331C10*)(S2331C9*)(S2331C8*)(S2331C2*), ABISELECT(64,44), "S2331C1");
    check_base_class_offset(lv, (S2331C9*)(S2331C8*)(S2331C2*), ABISELECT(64,44), "S2331C1");
    check_base_class_offset(lv, (S2331C8*)(S2331C2*), ABISELECT(64,44), "S2331C1");
    check_base_class_offset(lv, (S2331C2*), 0, "S2331C1");
    check_field_offset(lv, s2331c1f0, ABISELECT(168,128), "S2331C1.s2331c1f0");
    check_field_offset(lv, s2331c1f1, ABISELECT(184,136), "S2331C1.s2331c1f1");
    check_field_offset(lv, s2331c1f2, ABISELECT(248,172), "S2331C1.s2331c1f2");
    check_field_offset(lv, s2331c1f3, ABISELECT(264,188), "S2331C1.s2331c1f3");
    check_field_offset(lv, s2331c1f4, ABISELECT(3032,2956), "S2331C1.s2331c1f4");
    check_field_offset(lv, s2331c1f5, ABISELECT(3040,2960), "S2331C1.s2331c1f5");
    check_field_offset(lv, s2331c1f6, ABISELECT(3056,2968), "S2331C1.s2331c1f6");
    test_class_info(&lv, &cd_S2331C1);
    dp->~S2331C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2331C1(Test_S2331C1, "S2331C1", ABISELECT(3088,2988));

#else // __cplusplus

extern void _ZN7S2331C1C1Ev();
extern void _ZN7S2331C1D1Ev();
Name_Map name_map_S2331C1[] = {
  NSPAIR(_ZN7S2331C1C1Ev),
  NSPAIR(_ZN7S2331C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2331C4;
extern VTBL_ENTRY _ZTI7S2331C4[];
extern  VTBL_ENTRY _ZTV7S2331C4[];
extern Class_Descriptor cd_S2331C7;
extern VTBL_ENTRY _ZTI7S2331C7[];
extern  VTBL_ENTRY _ZTV7S2331C7[];
extern Class_Descriptor cd_S2331C3;
extern VTBL_ENTRY _ZTI7S2331C3[];
extern  VTBL_ENTRY _ZTV7S2331C3[];
extern Class_Descriptor cd_S2331C10;
extern VTBL_ENTRY _ZTI8S2331C10[];
extern  VTBL_ENTRY _ZTV8S2331C10[];
extern Class_Descriptor cd_S2331C9;
extern VTBL_ENTRY _ZTI7S2331C9[];
extern  VTBL_ENTRY _ZTV7S2331C9[];
extern Class_Descriptor cd_S2331C8;
extern VTBL_ENTRY _ZTI7S2331C8[];
extern  VTBL_ENTRY _ZTV7S2331C8[];
extern Class_Descriptor cd_S2331C2;
extern VTBL_ENTRY _ZTI7S2331C2[];
extern  VTBL_ENTRY _ZTV7S2331C2[];
static Base_Class bases_S2331C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2331C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2331C7,    ABISELECT(40,28), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2331C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2331C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2331C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2331C8,    ABISELECT(64,44), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2331C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2331C1[];
extern void _ZN7S2331C1D1Ev();
extern void _ZN7S2331C1D0Ev();
extern void _ZN7S2331C42v5Ev();
extern void _ZN7S2331C42v6Ev();
extern void _ZN7S2331C42v7Ev();
extern void _ZN7S2331C33v11Ev();
extern void _ZN7S2331C33v12Ev();
extern void _ZN7S2331C33v13Ev();
extern void _ZN7S2331C33v14Ev();
extern void _ZN7S2331C33v15Ev();
extern void _ZN7S2331C33v16Ev();
extern void _ZN7S2331C33v17Ev();
extern void _ZN7S2331C33v18Ev();
extern void _ZN7S2331C33v19Ev();
extern void _ZN7S2331C33v20Ev();
extern void _ZN7S2331C23v31Ev();
extern void _ZN7S2331C23v32Ev();
extern void _ZN7S2331C23v33Ev();
extern void _ZN7S2331C23v34Ev();
extern void _ZN7S2331C23v35Ev();
extern void _ZN7S2331C23v36Ev();
extern void _ZN7S2331C12v1Ev();
extern void _ZN7S2331C12v2Ev();
extern void _ZN7S2331C12v3Ev();
extern void _ZN7S2331C12v4Ev();
extern void ABISELECT(_ZThn40_N7S2331C1D1Ev,_ZThn28_N7S2331C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S2331C1D0Ev,_ZThn28_N7S2331C1D0Ev)();
extern void _ZN7S2331C72v8Ev();
extern void _ZN7S2331C72v9Ev();
extern void _ZN7S2331C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2331C1D1Ev,_ZThn44_N7S2331C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S2331C1D0Ev,_ZThn44_N7S2331C1D0Ev)();
extern void _ZN8S2331C103v21Ev();
extern void _ZN8S2331C103v22Ev();
extern void _ZN8S2331C103v23Ev();
extern void _ZN7S2331C93v24Ev();
extern void _ZN7S2331C93v25Ev();
extern void _ZN7S2331C93v26Ev();
extern void _ZN7S2331C83v27Ev();
extern void _ZN7S2331C83v28Ev();
extern void _ZN7S2331C83v29Ev();
extern void _ZN7S2331C83v30Ev();
static  VTBL_ENTRY vtc_S2331C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2331C1[0]),
  (VTBL_ENTRY)&_ZN7S2331C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2331C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2331C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2331C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2331C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2331C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2331C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2331C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2331C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2331C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2331C1D1Ev,_ZThn28_N7S2331C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2331C1D0Ev,_ZThn28_N7S2331C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2331C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2331C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2331C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2331C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2331C1D1Ev,_ZThn44_N7S2331C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2331C1D0Ev,_ZThn44_N7S2331C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2331C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2331C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2331C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2331C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2331C1[];
extern  VTBL_ENTRY _ZTV7S2331C1[];
Class_Descriptor cd_S2331C1 = {  "S2331C1", // class name
  bases_S2331C1, 7,
  &(vtc_S2331C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(3088,2988), // object size
  NSPAIRA(_ZTI7S2331C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2331C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2330C4  {
  ::S10183C15_nt s2330c4f0;
  int s2330c4f1[2];
  char s2330c4f2;
  virtual  ~S2330C4(); // _ZN7S2330C4D1Ev
  virtual void  v5(); // _ZN7S2330C42v5Ev
  virtual void  v6(); // _ZN7S2330C42v6Ev
  virtual void  v7(); // _ZN7S2330C42v7Ev
  S2330C4(); // tgen
};
//SIG(-1 S2330C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2330C4 ::~S2330C4(){ note_dtor("S2330C4", this);}
void  S2330C4 ::v5(){vfunc_called(this, "_ZN7S2330C42v5Ev");}
void  S2330C4 ::v6(){vfunc_called(this, "_ZN7S2330C42v6Ev");}
void  S2330C4 ::v7(){vfunc_called(this, "_ZN7S2330C42v7Ev");}
S2330C4 ::S2330C4(){ note_ctor("S2330C4", this);} // tgen

static void Test_S2330C4()
{
  extern Class_Descriptor cd_S2330C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2330C4, buf);
    S2330C4 *dp, &lv = *(dp=new (buf) S2330C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2330C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2330C4)");
    check_field_offset(lv, s2330c4f0, ABISELECT(8,4), "S2330C4.s2330c4f0");
    check_field_offset(lv, s2330c4f1, ABISELECT(24,16), "S2330C4.s2330c4f1");
    check_field_offset(lv, s2330c4f2, ABISELECT(32,24), "S2330C4.s2330c4f2");
    test_class_info(&lv, &cd_S2330C4);
    dp->~S2330C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2330C4(Test_S2330C4, "S2330C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2330C4C1Ev();
extern void _ZN7S2330C4D1Ev();
Name_Map name_map_S2330C4[] = {
  NSPAIR(_ZN7S2330C4C1Ev),
  NSPAIR(_ZN7S2330C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2330C4[];
extern void _ZN7S2330C4D1Ev();
extern void _ZN7S2330C4D0Ev();
extern void _ZN7S2330C42v5Ev();
extern void _ZN7S2330C42v6Ev();
extern void _ZN7S2330C42v7Ev();
static  VTBL_ENTRY vtc_S2330C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2330C4[0]),
  (VTBL_ENTRY)&_ZN7S2330C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2330C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v7Ev,
};
extern VTBL_ENTRY _ZTI7S2330C4[];
extern  VTBL_ENTRY _ZTV7S2330C4[];
Class_Descriptor cd_S2330C4 = {  "S2330C4", // class name
  0,0,//no base classes
  &(vtc_S2330C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2330C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2330C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2330C7  {
  virtual  ~S2330C7(); // _ZN7S2330C7D1Ev
  virtual void  v8(); // _ZN7S2330C72v8Ev
  virtual void  v9(); // _ZN7S2330C72v9Ev
  virtual void  v10(); // _ZN7S2330C73v10Ev
  S2330C7(); // tgen
};
//SIG(-1 S2330C7) C1{ vd v1 v2 v3}


 S2330C7 ::~S2330C7(){ note_dtor("S2330C7", this);}
void  S2330C7 ::v8(){vfunc_called(this, "_ZN7S2330C72v8Ev");}
void  S2330C7 ::v9(){vfunc_called(this, "_ZN7S2330C72v9Ev");}
void  S2330C7 ::v10(){vfunc_called(this, "_ZN7S2330C73v10Ev");}
S2330C7 ::S2330C7(){ note_ctor("S2330C7", this);} // tgen

static void Test_S2330C7()
{
  extern Class_Descriptor cd_S2330C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2330C7, buf);
    S2330C7 *dp, &lv = *(dp=new (buf) S2330C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2330C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2330C7)");
    test_class_info(&lv, &cd_S2330C7);
    dp->~S2330C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2330C7(Test_S2330C7, "S2330C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2330C7C1Ev();
extern void _ZN7S2330C7D1Ev();
Name_Map name_map_S2330C7[] = {
  NSPAIR(_ZN7S2330C7C1Ev),
  NSPAIR(_ZN7S2330C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2330C7[];
extern void _ZN7S2330C7D1Ev();
extern void _ZN7S2330C7D0Ev();
extern void _ZN7S2330C72v8Ev();
extern void _ZN7S2330C72v9Ev();
extern void _ZN7S2330C73v10Ev();
static  VTBL_ENTRY vtc_S2330C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2330C7[0]),
  (VTBL_ENTRY)&_ZN7S2330C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2330C7D0Ev,
  (VTBL_ENTRY)&_ZN7S2330C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2330C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2330C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2330C7[];
extern  VTBL_ENTRY _ZTV7S2330C7[];
Class_Descriptor cd_S2330C7 = {  "S2330C7", // class name
  0,0,//no base classes
  &(vtc_S2330C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2330C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2330C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2330C3  : S2330C4 , S2330C7 {
  void *s2330c3f0;
  char s2330c3f1;
  int s2330c3f2;
  virtual  ~S2330C3(); // _ZN7S2330C3D1Ev
  virtual void  v11(); // _ZN7S2330C33v11Ev
  virtual void  v12(); // _ZN7S2330C33v12Ev
  virtual void  v13(); // _ZN7S2330C33v13Ev
  virtual void  v14(); // _ZN7S2330C33v14Ev
  virtual void  v15(); // _ZN7S2330C33v15Ev
  virtual void  v16(); // _ZN7S2330C33v16Ev
  virtual void  v17(); // _ZN7S2330C33v17Ev
  virtual void  v18(); // _ZN7S2330C33v18Ev
  virtual void  v19(); // _ZN7S2330C33v19Ev
  virtual void  v20(); // _ZN7S2330C33v20Ev
  S2330C3(); // tgen
};
//SIG(-1 S2330C3) C1{ BC2{ vd v11 v12 v13 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ vd v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi}


 S2330C3 ::~S2330C3(){ note_dtor("S2330C3", this);}
void  S2330C3 ::v11(){vfunc_called(this, "_ZN7S2330C33v11Ev");}
void  S2330C3 ::v12(){vfunc_called(this, "_ZN7S2330C33v12Ev");}
void  S2330C3 ::v13(){vfunc_called(this, "_ZN7S2330C33v13Ev");}
void  S2330C3 ::v14(){vfunc_called(this, "_ZN7S2330C33v14Ev");}
void  S2330C3 ::v15(){vfunc_called(this, "_ZN7S2330C33v15Ev");}
void  S2330C3 ::v16(){vfunc_called(this, "_ZN7S2330C33v16Ev");}
void  S2330C3 ::v17(){vfunc_called(this, "_ZN7S2330C33v17Ev");}
void  S2330C3 ::v18(){vfunc_called(this, "_ZN7S2330C33v18Ev");}
void  S2330C3 ::v19(){vfunc_called(this, "_ZN7S2330C33v19Ev");}
void  S2330C3 ::v20(){vfunc_called(this, "_ZN7S2330C33v20Ev");}
S2330C3 ::S2330C3(){ note_ctor("S2330C3", this);} // tgen

static void Test_S2330C3()
{
  extern Class_Descriptor cd_S2330C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S2330C3, buf);
    S2330C3 *dp, &lv = *(dp=new (buf) S2330C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2330C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2330C3)");
    check_base_class_offset(lv, (S2330C4*), 0, "S2330C3");
    check_base_class_offset(lv, (S2330C7*), ABISELECT(40,28), "S2330C3");
    check_field_offset(lv, s2330c3f0, ABISELECT(48,32), "S2330C3.s2330c3f0");
    check_field_offset(lv, s2330c3f1, ABISELECT(56,36), "S2330C3.s2330c3f1");
    check_field_offset(lv, s2330c3f2, ABISELECT(60,40), "S2330C3.s2330c3f2");
    test_class_info(&lv, &cd_S2330C3);
    dp->~S2330C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2330C3(Test_S2330C3, "S2330C3", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN7S2330C3C1Ev();
extern void _ZN7S2330C3D1Ev();
Name_Map name_map_S2330C3[] = {
  NSPAIR(_ZN7S2330C3C1Ev),
  NSPAIR(_ZN7S2330C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2330C4;
extern VTBL_ENTRY _ZTI7S2330C4[];
extern  VTBL_ENTRY _ZTV7S2330C4[];
extern Class_Descriptor cd_S2330C7;
extern VTBL_ENTRY _ZTI7S2330C7[];
extern  VTBL_ENTRY _ZTV7S2330C7[];
static Base_Class bases_S2330C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2330C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2330C7,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2330C3[];
extern void _ZN7S2330C3D1Ev();
extern void _ZN7S2330C3D0Ev();
extern void _ZN7S2330C42v5Ev();
extern void _ZN7S2330C42v6Ev();
extern void _ZN7S2330C42v7Ev();
extern void _ZN7S2330C33v11Ev();
extern void _ZN7S2330C33v12Ev();
extern void _ZN7S2330C33v13Ev();
extern void _ZN7S2330C33v14Ev();
extern void _ZN7S2330C33v15Ev();
extern void _ZN7S2330C33v16Ev();
extern void _ZN7S2330C33v17Ev();
extern void _ZN7S2330C33v18Ev();
extern void _ZN7S2330C33v19Ev();
extern void _ZN7S2330C33v20Ev();
extern void ABISELECT(_ZThn40_N7S2330C3D1Ev,_ZThn28_N7S2330C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S2330C3D0Ev,_ZThn28_N7S2330C3D0Ev)();
extern void _ZN7S2330C72v8Ev();
extern void _ZN7S2330C72v9Ev();
extern void _ZN7S2330C73v10Ev();
static  VTBL_ENTRY vtc_S2330C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2330C3[0]),
  (VTBL_ENTRY)&_ZN7S2330C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2330C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v20Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2330C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2330C3D1Ev,_ZThn28_N7S2330C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2330C3D0Ev,_ZThn28_N7S2330C3D0Ev),
  (VTBL_ENTRY)&_ZN7S2330C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2330C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2330C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2330C3[];
extern  VTBL_ENTRY _ZTV7S2330C3[];
Class_Descriptor cd_S2330C3 = {  "S2330C3", // class name
  bases_S2330C3, 2,
  &(vtc_S2330C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI7S2330C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2330C3),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2330C10  {
  virtual  ~S2330C10(); // _ZN8S2330C10D1Ev
  virtual void  v21(); // _ZN8S2330C103v21Ev
  virtual void  v22(); // _ZN8S2330C103v22Ev
  virtual void  v23(); // _ZN8S2330C103v23Ev
  S2330C10(); // tgen
};
//SIG(-1 S2330C10) C1{ vd v1 v2 v3}


 S2330C10 ::~S2330C10(){ note_dtor("S2330C10", this);}
void  S2330C10 ::v21(){vfunc_called(this, "_ZN8S2330C103v21Ev");}
void  S2330C10 ::v22(){vfunc_called(this, "_ZN8S2330C103v22Ev");}
void  S2330C10 ::v23(){vfunc_called(this, "_ZN8S2330C103v23Ev");}
S2330C10 ::S2330C10(){ note_ctor("S2330C10", this);} // tgen

static void Test_S2330C10()
{
  extern Class_Descriptor cd_S2330C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2330C10, buf);
    S2330C10 *dp, &lv = *(dp=new (buf) S2330C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2330C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2330C10)");
    test_class_info(&lv, &cd_S2330C10);
    dp->~S2330C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2330C10(Test_S2330C10, "S2330C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2330C10C1Ev();
extern void _ZN8S2330C10D1Ev();
Name_Map name_map_S2330C10[] = {
  NSPAIR(_ZN8S2330C10C1Ev),
  NSPAIR(_ZN8S2330C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2330C10[];
extern void _ZN8S2330C10D1Ev();
extern void _ZN8S2330C10D0Ev();
extern void _ZN8S2330C103v21Ev();
extern void _ZN8S2330C103v22Ev();
extern void _ZN8S2330C103v23Ev();
static  VTBL_ENTRY vtc_S2330C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2330C10[0]),
  (VTBL_ENTRY)&_ZN8S2330C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2330C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v23Ev,
};
extern VTBL_ENTRY _ZTI8S2330C10[];
extern  VTBL_ENTRY _ZTV8S2330C10[];
Class_Descriptor cd_S2330C10 = {  "S2330C10", // class name
  0,0,//no base classes
  &(vtc_S2330C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2330C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2330C10),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2330C9  : S2330C10 {
  ::S10183C20 s2330c9f0;
  ::S10183C7_nt s2330c9f1;
  char s2330c9f2;
  virtual  ~S2330C9(); // _ZN7S2330C9D1Ev
  virtual void  v24(); // _ZN7S2330C93v24Ev
  virtual void  v25(); // _ZN7S2330C93v25Ev
  virtual void  v26(); // _ZN7S2330C93v26Ev
  S2330C9(); // tgen
};
//SIG(-1 S2330C9) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ Fl[4]}} Fc}


 S2330C9 ::~S2330C9(){ note_dtor("S2330C9", this);}
void  S2330C9 ::v24(){vfunc_called(this, "_ZN7S2330C93v24Ev");}
void  S2330C9 ::v25(){vfunc_called(this, "_ZN7S2330C93v25Ev");}
void  S2330C9 ::v26(){vfunc_called(this, "_ZN7S2330C93v26Ev");}
S2330C9 ::S2330C9(){ note_ctor("S2330C9", this);} // tgen

static void Test_S2330C9()
{
  extern Class_Descriptor cd_S2330C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2330C9, buf);
    S2330C9 *dp, &lv = *(dp=new (buf) S2330C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2330C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2330C9)");
    check_base_class_offset(lv, (S2330C10*), 0, "S2330C9");
    check_field_offset(lv, s2330c9f0, ABISELECT(8,4), "S2330C9.s2330c9f0");
    check_field_offset(lv, s2330c9f1, ABISELECT(32,20), "S2330C9.s2330c9f1");
    check_field_offset(lv, s2330c9f2, ABISELECT(64,36), "S2330C9.s2330c9f2");
    test_class_info(&lv, &cd_S2330C9);
    dp->~S2330C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2330C9(Test_S2330C9, "S2330C9", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2330C9C1Ev();
extern void _ZN7S2330C9D1Ev();
Name_Map name_map_S2330C9[] = {
  NSPAIR(_ZN7S2330C9C1Ev),
  NSPAIR(_ZN7S2330C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2330C10;
extern VTBL_ENTRY _ZTI8S2330C10[];
extern  VTBL_ENTRY _ZTV8S2330C10[];
static Base_Class bases_S2330C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2330C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2330C9[];
extern void _ZN7S2330C9D1Ev();
extern void _ZN7S2330C9D0Ev();
extern void _ZN8S2330C103v21Ev();
extern void _ZN8S2330C103v22Ev();
extern void _ZN8S2330C103v23Ev();
extern void _ZN7S2330C93v24Ev();
extern void _ZN7S2330C93v25Ev();
extern void _ZN7S2330C93v26Ev();
static  VTBL_ENTRY vtc_S2330C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2330C9[0]),
  (VTBL_ENTRY)&_ZN7S2330C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2330C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v26Ev,
};
extern VTBL_ENTRY _ZTI7S2330C9[];
extern  VTBL_ENTRY _ZTV7S2330C9[];
Class_Descriptor cd_S2330C9 = {  "S2330C9", // class name
  bases_S2330C9, 1,
  &(vtc_S2330C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2330C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2330C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2330C8  : S2330C9 {
  virtual  ~S2330C8(); // _ZN7S2330C8D1Ev
  virtual void  v27(); // _ZN7S2330C83v27Ev
  virtual void  v28(); // _ZN7S2330C83v28Ev
  virtual void  v29(); // _ZN7S2330C83v29Ev
  virtual void  v30(); // _ZN7S2330C83v30Ev
  S2330C8(); // tgen
};
//SIG(-1 S2330C8) C1{ BC2{ BC3{ vd v5 v6 v7} vd v8 v9 v10 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc} vd v1 v2 v3 v4}


 S2330C8 ::~S2330C8(){ note_dtor("S2330C8", this);}
void  S2330C8 ::v27(){vfunc_called(this, "_ZN7S2330C83v27Ev");}
void  S2330C8 ::v28(){vfunc_called(this, "_ZN7S2330C83v28Ev");}
void  S2330C8 ::v29(){vfunc_called(this, "_ZN7S2330C83v29Ev");}
void  S2330C8 ::v30(){vfunc_called(this, "_ZN7S2330C83v30Ev");}
S2330C8 ::S2330C8(){ note_ctor("S2330C8", this);} // tgen

static void Test_S2330C8()
{
  extern Class_Descriptor cd_S2330C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2330C8, buf);
    S2330C8 *dp, &lv = *(dp=new (buf) S2330C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2330C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2330C8)");
    check_base_class_offset(lv, (S2330C10*)(S2330C9*), 0, "S2330C8");
    check_base_class_offset(lv, (S2330C9*), 0, "S2330C8");
    test_class_info(&lv, &cd_S2330C8);
    dp->~S2330C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2330C8(Test_S2330C8, "S2330C8", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2330C8C1Ev();
extern void _ZN7S2330C8D1Ev();
Name_Map name_map_S2330C8[] = {
  NSPAIR(_ZN7S2330C8C1Ev),
  NSPAIR(_ZN7S2330C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2330C10;
extern VTBL_ENTRY _ZTI8S2330C10[];
extern  VTBL_ENTRY _ZTV8S2330C10[];
extern Class_Descriptor cd_S2330C9;
extern VTBL_ENTRY _ZTI7S2330C9[];
extern  VTBL_ENTRY _ZTV7S2330C9[];
static Base_Class bases_S2330C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2330C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2330C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2330C8[];
extern void _ZN7S2330C8D1Ev();
extern void _ZN7S2330C8D0Ev();
extern void _ZN8S2330C103v21Ev();
extern void _ZN8S2330C103v22Ev();
extern void _ZN8S2330C103v23Ev();
extern void _ZN7S2330C93v24Ev();
extern void _ZN7S2330C93v25Ev();
extern void _ZN7S2330C93v26Ev();
extern void _ZN7S2330C83v27Ev();
extern void _ZN7S2330C83v28Ev();
extern void _ZN7S2330C83v29Ev();
extern void _ZN7S2330C83v30Ev();
static  VTBL_ENTRY vtc_S2330C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2330C8[0]),
  (VTBL_ENTRY)&_ZN7S2330C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2330C8D0Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2330C8[];
extern  VTBL_ENTRY _ZTV7S2330C8[];
Class_Descriptor cd_S2330C8 = {  "S2330C8", // class name
  bases_S2330C8, 2,
  &(vtc_S2330C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2330C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2330C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2330C2  : S2330C3 , S2330C8 {
  int s2330c2f0[3];
  char s2330c2f1;
  ::S10183C9_nt s2330c2f2;
  virtual  ~S2330C2(); // _ZN7S2330C2D1Ev
  virtual void  v31(); // _ZN7S2330C23v31Ev
  virtual void  v32(); // _ZN7S2330C23v32Ev
  virtual void  v33(); // _ZN7S2330C23v33Ev
  virtual void  v34(); // _ZN7S2330C23v34Ev
  virtual void  v35(); // _ZN7S2330C23v35Ev
  virtual void  v36(); // _ZN7S2330C23v36Ev
  S2330C2(); // tgen
};
//SIG(-1 S2330C2) C1{ BC2{ BC3{ vd v7 v8 v9 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} BC6{ vd v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fc Fi} BC7{ BC8{ BC9{ vd v23 v24 v25} vd v26 v27 v28 FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FC13{ Fl[4]}} Fc} vd v29 v30 v31 v32} vd v1 v2 v3 v4 v5 v6 Fi[3] Fc FC14{ BC15{ m Fp Fi FC16{ m} FC5}}}


 S2330C2 ::~S2330C2(){ note_dtor("S2330C2", this);}
void  S2330C2 ::v31(){vfunc_called(this, "_ZN7S2330C23v31Ev");}
void  S2330C2 ::v32(){vfunc_called(this, "_ZN7S2330C23v32Ev");}
void  S2330C2 ::v33(){vfunc_called(this, "_ZN7S2330C23v33Ev");}
void  S2330C2 ::v34(){vfunc_called(this, "_ZN7S2330C23v34Ev");}
void  S2330C2 ::v35(){vfunc_called(this, "_ZN7S2330C23v35Ev");}
void  S2330C2 ::v36(){vfunc_called(this, "_ZN7S2330C23v36Ev");}
S2330C2 ::S2330C2(){ note_ctor("S2330C2", this);} // tgen

static void Test_S2330C2()
{
  extern Class_Descriptor cd_S2330C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,29)];
    init_test(&cd_S2330C2, buf);
    S2330C2 *dp, &lv = *(dp=new (buf) S2330C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,112), "sizeof(S2330C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2330C2)");
    check_base_class_offset(lv, (S2330C4*)(S2330C3*), 0, "S2330C2");
    check_base_class_offset(lv, (S2330C7*)(S2330C3*), ABISELECT(40,28), "S2330C2");
    check_base_class_offset(lv, (S2330C3*), 0, "S2330C2");
    check_base_class_offset(lv, (S2330C10*)(S2330C9*)(S2330C8*), ABISELECT(64,44), "S2330C2");
    check_base_class_offset(lv, (S2330C9*)(S2330C8*), ABISELECT(64,44), "S2330C2");
    check_base_class_offset(lv, (S2330C8*), ABISELECT(64,44), "S2330C2");
    check_field_offset(lv, s2330c2f0, ABISELECT(132,84), "S2330C2.s2330c2f0");
    check_field_offset(lv, s2330c2f1, ABISELECT(144,96), "S2330C2.s2330c2f1");
    check_field_offset(lv, s2330c2f2, ABISELECT(152,100), "S2330C2.s2330c2f2");
    test_class_info(&lv, &cd_S2330C2);
    dp->~S2330C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2330C2(Test_S2330C2, "S2330C2", ABISELECT(168,112));

#else // __cplusplus

extern void _ZN7S2330C2C1Ev();
extern void _ZN7S2330C2D1Ev();
Name_Map name_map_S2330C2[] = {
  NSPAIR(_ZN7S2330C2C1Ev),
  NSPAIR(_ZN7S2330C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2330C4;
extern VTBL_ENTRY _ZTI7S2330C4[];
extern  VTBL_ENTRY _ZTV7S2330C4[];
extern Class_Descriptor cd_S2330C7;
extern VTBL_ENTRY _ZTI7S2330C7[];
extern  VTBL_ENTRY _ZTV7S2330C7[];
extern Class_Descriptor cd_S2330C3;
extern VTBL_ENTRY _ZTI7S2330C3[];
extern  VTBL_ENTRY _ZTV7S2330C3[];
extern Class_Descriptor cd_S2330C10;
extern VTBL_ENTRY _ZTI8S2330C10[];
extern  VTBL_ENTRY _ZTV8S2330C10[];
extern Class_Descriptor cd_S2330C9;
extern VTBL_ENTRY _ZTI7S2330C9[];
extern  VTBL_ENTRY _ZTV7S2330C9[];
extern Class_Descriptor cd_S2330C8;
extern VTBL_ENTRY _ZTI7S2330C8[];
extern  VTBL_ENTRY _ZTV7S2330C8[];
static Base_Class bases_S2330C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2330C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2330C7,    ABISELECT(40,28), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2330C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2330C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2330C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2330C8,    ABISELECT(64,44), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2330C2[];
extern void _ZN7S2330C2D1Ev();
extern void _ZN7S2330C2D0Ev();
extern void _ZN7S2330C42v5Ev();
extern void _ZN7S2330C42v6Ev();
extern void _ZN7S2330C42v7Ev();
extern void _ZN7S2330C33v11Ev();
extern void _ZN7S2330C33v12Ev();
extern void _ZN7S2330C33v13Ev();
extern void _ZN7S2330C33v14Ev();
extern void _ZN7S2330C33v15Ev();
extern void _ZN7S2330C33v16Ev();
extern void _ZN7S2330C33v17Ev();
extern void _ZN7S2330C33v18Ev();
extern void _ZN7S2330C33v19Ev();
extern void _ZN7S2330C33v20Ev();
extern void _ZN7S2330C23v31Ev();
extern void _ZN7S2330C23v32Ev();
extern void _ZN7S2330C23v33Ev();
extern void _ZN7S2330C23v34Ev();
extern void _ZN7S2330C23v35Ev();
extern void _ZN7S2330C23v36Ev();
extern void ABISELECT(_ZThn40_N7S2330C2D1Ev,_ZThn28_N7S2330C2D1Ev)();
extern void ABISELECT(_ZThn40_N7S2330C2D0Ev,_ZThn28_N7S2330C2D0Ev)();
extern void _ZN7S2330C72v8Ev();
extern void _ZN7S2330C72v9Ev();
extern void _ZN7S2330C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2330C2D1Ev,_ZThn44_N7S2330C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S2330C2D0Ev,_ZThn44_N7S2330C2D0Ev)();
extern void _ZN8S2330C103v21Ev();
extern void _ZN8S2330C103v22Ev();
extern void _ZN8S2330C103v23Ev();
extern void _ZN7S2330C93v24Ev();
extern void _ZN7S2330C93v25Ev();
extern void _ZN7S2330C93v26Ev();
extern void _ZN7S2330C83v27Ev();
extern void _ZN7S2330C83v28Ev();
extern void _ZN7S2330C83v29Ev();
extern void _ZN7S2330C83v30Ev();
static  VTBL_ENTRY vtc_S2330C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2330C2[0]),
  (VTBL_ENTRY)&_ZN7S2330C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2330C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v36Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2330C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2330C2D1Ev,_ZThn28_N7S2330C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2330C2D0Ev,_ZThn28_N7S2330C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2330C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2330C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2330C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2330C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2330C2D1Ev,_ZThn44_N7S2330C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2330C2D0Ev,_ZThn44_N7S2330C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2330C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2330C2[];
extern  VTBL_ENTRY _ZTV7S2330C2[];
Class_Descriptor cd_S2330C2 = {  "S2330C2", // class name
  bases_S2330C2, 6,
  &(vtc_S2330C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,112), // object size
  NSPAIRA(_ZTI7S2330C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2330C2),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2330C1  : S2330C2 {
  ::S2331C19 s2330c1f0;
  ::S2348C20_nt s2330c1f1;
  int s2330c1f2[4];
  ::S9125C15 s2330c1f3;
  int s2330c1f4;
  void *s2330c1f5[2];
  ::S10183C19_nt s2330c1f6;
  virtual  ~S2330C1(); // _ZN7S2330C1D1Ev
  virtual void  v1(); // _ZN7S2330C12v1Ev
  virtual void  v2(); // _ZN7S2330C12v2Ev
  virtual void  v3(); // _ZN7S2330C12v3Ev
  virtual void  v4(); // _ZN7S2330C12v4Ev
  S2330C1(); // tgen
};
//SIG(1 S2330C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} BC7{ vd v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp Fc Fi} BC8{ BC9{ BC10{ vd v21 v22 v23} vd v24 v25 v26 FC11{ m Fp Fi[2] FC12{ m}} FC13{ m FC14{ Fl[4]}} Fc} vd v27 v28 v29 v30} vd v31 v32 v33 v34 v35 v36 Fi[3] Fc FC15{ BC16{ m Fp Fi FC17{ m} FC6}}} vd v1 v2 v3 v4 FC18{ vd v37 v38 v39 v40 Fp} FC19{ BC20{ vd v42 FC21{ m FC16} Fp[3] Fc} v41 Fp} Fi[4] FC22{ Fi[2] FC23{ Fi[2]}[10] FC24{ Fi[3] Fc[256]}[10]} Fi Fp[2] FC25{ BC11 BC26{ vd v45 v46} vd v43 v44}}


 S2330C1 ::~S2330C1(){ note_dtor("S2330C1", this);}
void  S2330C1 ::v1(){vfunc_called(this, "_ZN7S2330C12v1Ev");}
void  S2330C1 ::v2(){vfunc_called(this, "_ZN7S2330C12v2Ev");}
void  S2330C1 ::v3(){vfunc_called(this, "_ZN7S2330C12v3Ev");}
void  S2330C1 ::v4(){vfunc_called(this, "_ZN7S2330C12v4Ev");}
S2330C1 ::S2330C1(){ note_ctor("S2330C1", this);} // tgen

static void Test_S2330C1()
{
  extern Class_Descriptor cd_S2330C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(387,744)];
    init_test(&cd_S2330C1, buf);
    S2330C1 *dp, &lv = *(dp=new (buf) S2330C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3088,2972), "sizeof(S2330C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2330C1)");
    check_base_class_offset(lv, (S2330C4*)(S2330C3*)(S2330C2*), 0, "S2330C1");
    check_base_class_offset(lv, (S2330C7*)(S2330C3*)(S2330C2*), ABISELECT(40,28), "S2330C1");
    check_base_class_offset(lv, (S2330C3*)(S2330C2*), 0, "S2330C1");
    check_base_class_offset(lv, (S2330C10*)(S2330C9*)(S2330C8*)(S2330C2*), ABISELECT(64,44), "S2330C1");
    check_base_class_offset(lv, (S2330C9*)(S2330C8*)(S2330C2*), ABISELECT(64,44), "S2330C1");
    check_base_class_offset(lv, (S2330C8*)(S2330C2*), ABISELECT(64,44), "S2330C1");
    check_base_class_offset(lv, (S2330C2*), 0, "S2330C1");
    check_field_offset(lv, s2330c1f0, ABISELECT(168,112), "S2330C1.s2330c1f0");
    check_field_offset(lv, s2330c1f1, ABISELECT(184,120), "S2330C1.s2330c1f1");
    check_field_offset(lv, s2330c1f2, ABISELECT(248,156), "S2330C1.s2330c1f2");
    check_field_offset(lv, s2330c1f3, ABISELECT(264,172), "S2330C1.s2330c1f3");
    check_field_offset(lv, s2330c1f4, ABISELECT(3032,2940), "S2330C1.s2330c1f4");
    check_field_offset(lv, s2330c1f5, ABISELECT(3040,2944), "S2330C1.s2330c1f5");
    check_field_offset(lv, s2330c1f6, ABISELECT(3056,2952), "S2330C1.s2330c1f6");
    test_class_info(&lv, &cd_S2330C1);
    dp->~S2330C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2330C1(Test_S2330C1, "S2330C1", ABISELECT(3088,2972));

#else // __cplusplus

extern void _ZN7S2330C1C1Ev();
extern void _ZN7S2330C1D1Ev();
Name_Map name_map_S2330C1[] = {
  NSPAIR(_ZN7S2330C1C1Ev),
  NSPAIR(_ZN7S2330C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2330C4;
extern VTBL_ENTRY _ZTI7S2330C4[];
extern  VTBL_ENTRY _ZTV7S2330C4[];
extern Class_Descriptor cd_S2330C7;
extern VTBL_ENTRY _ZTI7S2330C7[];
extern  VTBL_ENTRY _ZTV7S2330C7[];
extern Class_Descriptor cd_S2330C3;
extern VTBL_ENTRY _ZTI7S2330C3[];
extern  VTBL_ENTRY _ZTV7S2330C3[];
extern Class_Descriptor cd_S2330C10;
extern VTBL_ENTRY _ZTI8S2330C10[];
extern  VTBL_ENTRY _ZTV8S2330C10[];
extern Class_Descriptor cd_S2330C9;
extern VTBL_ENTRY _ZTI7S2330C9[];
extern  VTBL_ENTRY _ZTV7S2330C9[];
extern Class_Descriptor cd_S2330C8;
extern VTBL_ENTRY _ZTI7S2330C8[];
extern  VTBL_ENTRY _ZTV7S2330C8[];
extern Class_Descriptor cd_S2330C2;
extern VTBL_ENTRY _ZTI7S2330C2[];
extern  VTBL_ENTRY _ZTV7S2330C2[];
static Base_Class bases_S2330C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2330C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2330C7,    ABISELECT(40,28), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2330C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2330C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2330C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2330C8,    ABISELECT(64,44), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2330C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2330C1[];
extern void _ZN7S2330C1D1Ev();
extern void _ZN7S2330C1D0Ev();
extern void _ZN7S2330C42v5Ev();
extern void _ZN7S2330C42v6Ev();
extern void _ZN7S2330C42v7Ev();
extern void _ZN7S2330C33v11Ev();
extern void _ZN7S2330C33v12Ev();
extern void _ZN7S2330C33v13Ev();
extern void _ZN7S2330C33v14Ev();
extern void _ZN7S2330C33v15Ev();
extern void _ZN7S2330C33v16Ev();
extern void _ZN7S2330C33v17Ev();
extern void _ZN7S2330C33v18Ev();
extern void _ZN7S2330C33v19Ev();
extern void _ZN7S2330C33v20Ev();
extern void _ZN7S2330C23v31Ev();
extern void _ZN7S2330C23v32Ev();
extern void _ZN7S2330C23v33Ev();
extern void _ZN7S2330C23v34Ev();
extern void _ZN7S2330C23v35Ev();
extern void _ZN7S2330C23v36Ev();
extern void _ZN7S2330C12v1Ev();
extern void _ZN7S2330C12v2Ev();
extern void _ZN7S2330C12v3Ev();
extern void _ZN7S2330C12v4Ev();
extern void ABISELECT(_ZThn40_N7S2330C1D1Ev,_ZThn28_N7S2330C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S2330C1D0Ev,_ZThn28_N7S2330C1D0Ev)();
extern void _ZN7S2330C72v8Ev();
extern void _ZN7S2330C72v9Ev();
extern void _ZN7S2330C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2330C1D1Ev,_ZThn44_N7S2330C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S2330C1D0Ev,_ZThn44_N7S2330C1D0Ev)();
extern void _ZN8S2330C103v21Ev();
extern void _ZN8S2330C103v22Ev();
extern void _ZN8S2330C103v23Ev();
extern void _ZN7S2330C93v24Ev();
extern void _ZN7S2330C93v25Ev();
extern void _ZN7S2330C93v26Ev();
extern void _ZN7S2330C83v27Ev();
extern void _ZN7S2330C83v28Ev();
extern void _ZN7S2330C83v29Ev();
extern void _ZN7S2330C83v30Ev();
static  VTBL_ENTRY vtc_S2330C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2330C1[0]),
  (VTBL_ENTRY)&_ZN7S2330C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2330C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2330C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2330C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2330C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2330C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2330C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2330C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2330C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2330C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2330C1D1Ev,_ZThn28_N7S2330C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2330C1D0Ev,_ZThn28_N7S2330C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2330C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2330C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2330C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2330C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2330C1D1Ev,_ZThn44_N7S2330C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2330C1D0Ev,_ZThn44_N7S2330C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2330C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2330C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2330C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2330C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2330C1[];
extern  VTBL_ENTRY _ZTV7S2330C1[];
Class_Descriptor cd_S2330C1 = {  "S2330C1", // class name
  bases_S2330C1, 7,
  &(vtc_S2330C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(3088,2972), // object size
  NSPAIRA(_ZTI7S2330C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2330C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2337C4  {
  ::S10183C15_nt s2337c4f0;
  int s2337c4f1[2];
  char s2337c4f2;
  virtual  ~S2337C4(); // _ZN7S2337C4D1Ev
  virtual void  v5(); // _ZN7S2337C42v5Ev
  virtual void  v6(); // _ZN7S2337C42v6Ev
  virtual void  v7(); // _ZN7S2337C42v7Ev
  S2337C4(); // tgen
};
//SIG(-1 S2337C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2337C4 ::~S2337C4(){ note_dtor("S2337C4", this);}
void  S2337C4 ::v5(){vfunc_called(this, "_ZN7S2337C42v5Ev");}
void  S2337C4 ::v6(){vfunc_called(this, "_ZN7S2337C42v6Ev");}
void  S2337C4 ::v7(){vfunc_called(this, "_ZN7S2337C42v7Ev");}
S2337C4 ::S2337C4(){ note_ctor("S2337C4", this);} // tgen

static void Test_S2337C4()
{
  extern Class_Descriptor cd_S2337C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2337C4, buf);
    S2337C4 *dp, &lv = *(dp=new (buf) S2337C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2337C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2337C4)");
    check_field_offset(lv, s2337c4f0, ABISELECT(8,4), "S2337C4.s2337c4f0");
    check_field_offset(lv, s2337c4f1, ABISELECT(24,16), "S2337C4.s2337c4f1");
    check_field_offset(lv, s2337c4f2, ABISELECT(32,24), "S2337C4.s2337c4f2");
    test_class_info(&lv, &cd_S2337C4);
    dp->~S2337C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2337C4(Test_S2337C4, "S2337C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2337C4C1Ev();
extern void _ZN7S2337C4D1Ev();
Name_Map name_map_S2337C4[] = {
  NSPAIR(_ZN7S2337C4C1Ev),
  NSPAIR(_ZN7S2337C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2337C4[];
extern void _ZN7S2337C4D1Ev();
extern void _ZN7S2337C4D0Ev();
extern void _ZN7S2337C42v5Ev();
extern void _ZN7S2337C42v6Ev();
extern void _ZN7S2337C42v7Ev();
static  VTBL_ENTRY vtc_S2337C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2337C4[0]),
  (VTBL_ENTRY)&_ZN7S2337C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2337C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v7Ev,
};
extern VTBL_ENTRY _ZTI7S2337C4[];
extern  VTBL_ENTRY _ZTV7S2337C4[];
Class_Descriptor cd_S2337C4 = {  "S2337C4", // class name
  0,0,//no base classes
  &(vtc_S2337C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2337C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2337C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2337C7  {
  virtual  ~S2337C7(); // _ZN7S2337C7D1Ev
  virtual void  v8(); // _ZN7S2337C72v8Ev
  virtual void  v9(); // _ZN7S2337C72v9Ev
  virtual void  v10(); // _ZN7S2337C73v10Ev
  S2337C7(); // tgen
};
//SIG(-1 S2337C7) C1{ vd v1 v2 v3}


 S2337C7 ::~S2337C7(){ note_dtor("S2337C7", this);}
void  S2337C7 ::v8(){vfunc_called(this, "_ZN7S2337C72v8Ev");}
void  S2337C7 ::v9(){vfunc_called(this, "_ZN7S2337C72v9Ev");}
void  S2337C7 ::v10(){vfunc_called(this, "_ZN7S2337C73v10Ev");}
S2337C7 ::S2337C7(){ note_ctor("S2337C7", this);} // tgen

static void Test_S2337C7()
{
  extern Class_Descriptor cd_S2337C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2337C7, buf);
    S2337C7 *dp, &lv = *(dp=new (buf) S2337C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2337C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2337C7)");
    test_class_info(&lv, &cd_S2337C7);
    dp->~S2337C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2337C7(Test_S2337C7, "S2337C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2337C7C1Ev();
extern void _ZN7S2337C7D1Ev();
Name_Map name_map_S2337C7[] = {
  NSPAIR(_ZN7S2337C7C1Ev),
  NSPAIR(_ZN7S2337C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2337C7[];
extern void _ZN7S2337C7D1Ev();
extern void _ZN7S2337C7D0Ev();
extern void _ZN7S2337C72v8Ev();
extern void _ZN7S2337C72v9Ev();
extern void _ZN7S2337C73v10Ev();
static  VTBL_ENTRY vtc_S2337C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2337C7[0]),
  (VTBL_ENTRY)&_ZN7S2337C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2337C7D0Ev,
  (VTBL_ENTRY)&_ZN7S2337C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2337C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2337C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2337C7[];
extern  VTBL_ENTRY _ZTV7S2337C7[];
Class_Descriptor cd_S2337C7 = {  "S2337C7", // class name
  0,0,//no base classes
  &(vtc_S2337C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2337C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2337C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2337C3  : S2337C4 , S2337C7 {
  void *s2337c3f0;
  char s2337c3f1;
  int s2337c3f2;
  virtual  ~S2337C3(); // _ZN7S2337C3D1Ev
  virtual void  v11(); // _ZN7S2337C33v11Ev
  virtual void  v12(); // _ZN7S2337C33v12Ev
  virtual void  v13(); // _ZN7S2337C33v13Ev
  virtual void  v14(); // _ZN7S2337C33v14Ev
  virtual void  v15(); // _ZN7S2337C33v15Ev
  virtual void  v16(); // _ZN7S2337C33v16Ev
  virtual void  v17(); // _ZN7S2337C33v17Ev
  virtual void  v18(); // _ZN7S2337C33v18Ev
  virtual void  v19(); // _ZN7S2337C33v19Ev
  virtual void  v20(); // _ZN7S2337C33v20Ev
  S2337C3(); // tgen
};
//SIG(-1 S2337C3) C1{ BC2{ vd v11 v12 v13 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ vd v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi}


 S2337C3 ::~S2337C3(){ note_dtor("S2337C3", this);}
void  S2337C3 ::v11(){vfunc_called(this, "_ZN7S2337C33v11Ev");}
void  S2337C3 ::v12(){vfunc_called(this, "_ZN7S2337C33v12Ev");}
void  S2337C3 ::v13(){vfunc_called(this, "_ZN7S2337C33v13Ev");}
void  S2337C3 ::v14(){vfunc_called(this, "_ZN7S2337C33v14Ev");}
void  S2337C3 ::v15(){vfunc_called(this, "_ZN7S2337C33v15Ev");}
void  S2337C3 ::v16(){vfunc_called(this, "_ZN7S2337C33v16Ev");}
void  S2337C3 ::v17(){vfunc_called(this, "_ZN7S2337C33v17Ev");}
void  S2337C3 ::v18(){vfunc_called(this, "_ZN7S2337C33v18Ev");}
void  S2337C3 ::v19(){vfunc_called(this, "_ZN7S2337C33v19Ev");}
void  S2337C3 ::v20(){vfunc_called(this, "_ZN7S2337C33v20Ev");}
S2337C3 ::S2337C3(){ note_ctor("S2337C3", this);} // tgen

static void Test_S2337C3()
{
  extern Class_Descriptor cd_S2337C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S2337C3, buf);
    S2337C3 *dp, &lv = *(dp=new (buf) S2337C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2337C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2337C3)");
    check_base_class_offset(lv, (S2337C4*), 0, "S2337C3");
    check_base_class_offset(lv, (S2337C7*), ABISELECT(40,28), "S2337C3");
    check_field_offset(lv, s2337c3f0, ABISELECT(48,32), "S2337C3.s2337c3f0");
    check_field_offset(lv, s2337c3f1, ABISELECT(56,36), "S2337C3.s2337c3f1");
    check_field_offset(lv, s2337c3f2, ABISELECT(60,40), "S2337C3.s2337c3f2");
    test_class_info(&lv, &cd_S2337C3);
    dp->~S2337C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2337C3(Test_S2337C3, "S2337C3", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN7S2337C3C1Ev();
extern void _ZN7S2337C3D1Ev();
Name_Map name_map_S2337C3[] = {
  NSPAIR(_ZN7S2337C3C1Ev),
  NSPAIR(_ZN7S2337C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2337C4;
extern VTBL_ENTRY _ZTI7S2337C4[];
extern  VTBL_ENTRY _ZTV7S2337C4[];
extern Class_Descriptor cd_S2337C7;
extern VTBL_ENTRY _ZTI7S2337C7[];
extern  VTBL_ENTRY _ZTV7S2337C7[];
static Base_Class bases_S2337C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2337C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2337C7,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2337C3[];
extern void _ZN7S2337C3D1Ev();
extern void _ZN7S2337C3D0Ev();
extern void _ZN7S2337C42v5Ev();
extern void _ZN7S2337C42v6Ev();
extern void _ZN7S2337C42v7Ev();
extern void _ZN7S2337C33v11Ev();
extern void _ZN7S2337C33v12Ev();
extern void _ZN7S2337C33v13Ev();
extern void _ZN7S2337C33v14Ev();
extern void _ZN7S2337C33v15Ev();
extern void _ZN7S2337C33v16Ev();
extern void _ZN7S2337C33v17Ev();
extern void _ZN7S2337C33v18Ev();
extern void _ZN7S2337C33v19Ev();
extern void _ZN7S2337C33v20Ev();
extern void ABISELECT(_ZThn40_N7S2337C3D1Ev,_ZThn28_N7S2337C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S2337C3D0Ev,_ZThn28_N7S2337C3D0Ev)();
extern void _ZN7S2337C72v8Ev();
extern void _ZN7S2337C72v9Ev();
extern void _ZN7S2337C73v10Ev();
static  VTBL_ENTRY vtc_S2337C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2337C3[0]),
  (VTBL_ENTRY)&_ZN7S2337C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2337C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v20Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2337C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2337C3D1Ev,_ZThn28_N7S2337C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2337C3D0Ev,_ZThn28_N7S2337C3D0Ev),
  (VTBL_ENTRY)&_ZN7S2337C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2337C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2337C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2337C3[];
extern  VTBL_ENTRY _ZTV7S2337C3[];
Class_Descriptor cd_S2337C3 = {  "S2337C3", // class name
  bases_S2337C3, 2,
  &(vtc_S2337C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI7S2337C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2337C3),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2337C10  {
  virtual  ~S2337C10(); // _ZN8S2337C10D1Ev
  virtual void  v21(); // _ZN8S2337C103v21Ev
  virtual void  v22(); // _ZN8S2337C103v22Ev
  virtual void  v23(); // _ZN8S2337C103v23Ev
  S2337C10(); // tgen
};
//SIG(-1 S2337C10) C1{ vd v1 v2 v3}


 S2337C10 ::~S2337C10(){ note_dtor("S2337C10", this);}
void  S2337C10 ::v21(){vfunc_called(this, "_ZN8S2337C103v21Ev");}
void  S2337C10 ::v22(){vfunc_called(this, "_ZN8S2337C103v22Ev");}
void  S2337C10 ::v23(){vfunc_called(this, "_ZN8S2337C103v23Ev");}
S2337C10 ::S2337C10(){ note_ctor("S2337C10", this);} // tgen

static void Test_S2337C10()
{
  extern Class_Descriptor cd_S2337C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2337C10, buf);
    S2337C10 *dp, &lv = *(dp=new (buf) S2337C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2337C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2337C10)");
    test_class_info(&lv, &cd_S2337C10);
    dp->~S2337C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2337C10(Test_S2337C10, "S2337C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2337C10C1Ev();
extern void _ZN8S2337C10D1Ev();
Name_Map name_map_S2337C10[] = {
  NSPAIR(_ZN8S2337C10C1Ev),
  NSPAIR(_ZN8S2337C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2337C10[];
extern void _ZN8S2337C10D1Ev();
extern void _ZN8S2337C10D0Ev();
extern void _ZN8S2337C103v21Ev();
extern void _ZN8S2337C103v22Ev();
extern void _ZN8S2337C103v23Ev();
static  VTBL_ENTRY vtc_S2337C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2337C10[0]),
  (VTBL_ENTRY)&_ZN8S2337C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2337C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v23Ev,
};
extern VTBL_ENTRY _ZTI8S2337C10[];
extern  VTBL_ENTRY _ZTV8S2337C10[];
Class_Descriptor cd_S2337C10 = {  "S2337C10", // class name
  0,0,//no base classes
  &(vtc_S2337C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2337C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2337C10),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2337C9  : S2337C10 {
  ::S10183C20 s2337c9f0;
  ::S10184C7_nt s2337c9f1;
  char s2337c9f2;
  virtual  ~S2337C9(); // _ZN7S2337C9D1Ev
  virtual void  v24(); // _ZN7S2337C93v24Ev
  virtual void  v25(); // _ZN7S2337C93v25Ev
  virtual void  v26(); // _ZN7S2337C93v26Ev
  S2337C9(); // tgen
};
//SIG(-1 S2337C9) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ FL[4]}} Fc}


 S2337C9 ::~S2337C9(){ note_dtor("S2337C9", this);}
void  S2337C9 ::v24(){vfunc_called(this, "_ZN7S2337C93v24Ev");}
void  S2337C9 ::v25(){vfunc_called(this, "_ZN7S2337C93v25Ev");}
void  S2337C9 ::v26(){vfunc_called(this, "_ZN7S2337C93v26Ev");}
S2337C9 ::S2337C9(){ note_ctor("S2337C9", this);} // tgen

static void Test_S2337C9()
{
  extern Class_Descriptor cd_S2337C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2337C9, buf);
    S2337C9 *dp, &lv = *(dp=new (buf) S2337C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2337C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2337C9)");
    check_base_class_offset(lv, (S2337C10*), 0, "S2337C9");
    check_field_offset(lv, s2337c9f0, ABISELECT(8,4), "S2337C9.s2337c9f0");
    check_field_offset(lv, s2337c9f1, ABISELECT(32,20), "S2337C9.s2337c9f1");
    check_field_offset(lv, s2337c9f2, ABISELECT(64,52), "S2337C9.s2337c9f2");
    test_class_info(&lv, &cd_S2337C9);
    dp->~S2337C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2337C9(Test_S2337C9, "S2337C9", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2337C9C1Ev();
extern void _ZN7S2337C9D1Ev();
Name_Map name_map_S2337C9[] = {
  NSPAIR(_ZN7S2337C9C1Ev),
  NSPAIR(_ZN7S2337C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2337C10;
extern VTBL_ENTRY _ZTI8S2337C10[];
extern  VTBL_ENTRY _ZTV8S2337C10[];
static Base_Class bases_S2337C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2337C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2337C9[];
extern void _ZN7S2337C9D1Ev();
extern void _ZN7S2337C9D0Ev();
extern void _ZN8S2337C103v21Ev();
extern void _ZN8S2337C103v22Ev();
extern void _ZN8S2337C103v23Ev();
extern void _ZN7S2337C93v24Ev();
extern void _ZN7S2337C93v25Ev();
extern void _ZN7S2337C93v26Ev();
static  VTBL_ENTRY vtc_S2337C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2337C9[0]),
  (VTBL_ENTRY)&_ZN7S2337C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2337C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v26Ev,
};
extern VTBL_ENTRY _ZTI7S2337C9[];
extern  VTBL_ENTRY _ZTV7S2337C9[];
Class_Descriptor cd_S2337C9 = {  "S2337C9", // class name
  bases_S2337C9, 1,
  &(vtc_S2337C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2337C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2337C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2337C8  : S2337C9 {
  virtual  ~S2337C8(); // _ZN7S2337C8D1Ev
  virtual void  v27(); // _ZN7S2337C83v27Ev
  virtual void  v28(); // _ZN7S2337C83v28Ev
  virtual void  v29(); // _ZN7S2337C83v29Ev
  virtual void  v30(); // _ZN7S2337C83v30Ev
  S2337C8(); // tgen
};
//SIG(-1 S2337C8) C1{ BC2{ BC3{ vd v5 v6 v7} vd v8 v9 v10 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc} vd v1 v2 v3 v4}


 S2337C8 ::~S2337C8(){ note_dtor("S2337C8", this);}
void  S2337C8 ::v27(){vfunc_called(this, "_ZN7S2337C83v27Ev");}
void  S2337C8 ::v28(){vfunc_called(this, "_ZN7S2337C83v28Ev");}
void  S2337C8 ::v29(){vfunc_called(this, "_ZN7S2337C83v29Ev");}
void  S2337C8 ::v30(){vfunc_called(this, "_ZN7S2337C83v30Ev");}
S2337C8 ::S2337C8(){ note_ctor("S2337C8", this);} // tgen

static void Test_S2337C8()
{
  extern Class_Descriptor cd_S2337C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2337C8, buf);
    S2337C8 *dp, &lv = *(dp=new (buf) S2337C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2337C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2337C8)");
    check_base_class_offset(lv, (S2337C10*)(S2337C9*), 0, "S2337C8");
    check_base_class_offset(lv, (S2337C9*), 0, "S2337C8");
    test_class_info(&lv, &cd_S2337C8);
    dp->~S2337C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2337C8(Test_S2337C8, "S2337C8", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2337C8C1Ev();
extern void _ZN7S2337C8D1Ev();
Name_Map name_map_S2337C8[] = {
  NSPAIR(_ZN7S2337C8C1Ev),
  NSPAIR(_ZN7S2337C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2337C10;
extern VTBL_ENTRY _ZTI8S2337C10[];
extern  VTBL_ENTRY _ZTV8S2337C10[];
extern Class_Descriptor cd_S2337C9;
extern VTBL_ENTRY _ZTI7S2337C9[];
extern  VTBL_ENTRY _ZTV7S2337C9[];
static Base_Class bases_S2337C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2337C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2337C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2337C8[];
extern void _ZN7S2337C8D1Ev();
extern void _ZN7S2337C8D0Ev();
extern void _ZN8S2337C103v21Ev();
extern void _ZN8S2337C103v22Ev();
extern void _ZN8S2337C103v23Ev();
extern void _ZN7S2337C93v24Ev();
extern void _ZN7S2337C93v25Ev();
extern void _ZN7S2337C93v26Ev();
extern void _ZN7S2337C83v27Ev();
extern void _ZN7S2337C83v28Ev();
extern void _ZN7S2337C83v29Ev();
extern void _ZN7S2337C83v30Ev();
static  VTBL_ENTRY vtc_S2337C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2337C8[0]),
  (VTBL_ENTRY)&_ZN7S2337C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2337C8D0Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2337C8[];
extern  VTBL_ENTRY _ZTV7S2337C8[];
Class_Descriptor cd_S2337C8 = {  "S2337C8", // class name
  bases_S2337C8, 2,
  &(vtc_S2337C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2337C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2337C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2337C2  : S2337C3 , S2337C8 {
  int s2337c2f0[3];
  char s2337c2f1;
  ::S10183C9_nt s2337c2f2;
  virtual  ~S2337C2(); // _ZN7S2337C2D1Ev
  virtual void  v31(); // _ZN7S2337C23v31Ev
  virtual void  v32(); // _ZN7S2337C23v32Ev
  virtual void  v33(); // _ZN7S2337C23v33Ev
  virtual void  v34(); // _ZN7S2337C23v34Ev
  virtual void  v35(); // _ZN7S2337C23v35Ev
  virtual void  v36(); // _ZN7S2337C23v36Ev
  S2337C2(); // tgen
};
//SIG(-1 S2337C2) C1{ BC2{ BC3{ vd v7 v8 v9 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} BC6{ vd v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fc Fi} BC7{ BC8{ BC9{ vd v23 v24 v25} vd v26 v27 v28 FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FC13{ FL[4]}} Fc} vd v29 v30 v31 v32} vd v1 v2 v3 v4 v5 v6 Fi[3] Fc FC14{ BC15{ m Fp Fi FC16{ m} FC5}}}


 S2337C2 ::~S2337C2(){ note_dtor("S2337C2", this);}
void  S2337C2 ::v31(){vfunc_called(this, "_ZN7S2337C23v31Ev");}
void  S2337C2 ::v32(){vfunc_called(this, "_ZN7S2337C23v32Ev");}
void  S2337C2 ::v33(){vfunc_called(this, "_ZN7S2337C23v33Ev");}
void  S2337C2 ::v34(){vfunc_called(this, "_ZN7S2337C23v34Ev");}
void  S2337C2 ::v35(){vfunc_called(this, "_ZN7S2337C23v35Ev");}
void  S2337C2 ::v36(){vfunc_called(this, "_ZN7S2337C23v36Ev");}
S2337C2 ::S2337C2(){ note_ctor("S2337C2", this);} // tgen

static void Test_S2337C2()
{
  extern Class_Descriptor cd_S2337C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,33)];
    init_test(&cd_S2337C2, buf);
    S2337C2 *dp, &lv = *(dp=new (buf) S2337C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,128), "sizeof(S2337C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2337C2)");
    check_base_class_offset(lv, (S2337C4*)(S2337C3*), 0, "S2337C2");
    check_base_class_offset(lv, (S2337C7*)(S2337C3*), ABISELECT(40,28), "S2337C2");
    check_base_class_offset(lv, (S2337C3*), 0, "S2337C2");
    check_base_class_offset(lv, (S2337C10*)(S2337C9*)(S2337C8*), ABISELECT(64,44), "S2337C2");
    check_base_class_offset(lv, (S2337C9*)(S2337C8*), ABISELECT(64,44), "S2337C2");
    check_base_class_offset(lv, (S2337C8*), ABISELECT(64,44), "S2337C2");
    check_field_offset(lv, s2337c2f0, ABISELECT(132,100), "S2337C2.s2337c2f0");
    check_field_offset(lv, s2337c2f1, ABISELECT(144,112), "S2337C2.s2337c2f1");
    check_field_offset(lv, s2337c2f2, ABISELECT(152,116), "S2337C2.s2337c2f2");
    test_class_info(&lv, &cd_S2337C2);
    dp->~S2337C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2337C2(Test_S2337C2, "S2337C2", ABISELECT(168,128));

#else // __cplusplus

extern void _ZN7S2337C2C1Ev();
extern void _ZN7S2337C2D1Ev();
Name_Map name_map_S2337C2[] = {
  NSPAIR(_ZN7S2337C2C1Ev),
  NSPAIR(_ZN7S2337C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2337C4;
extern VTBL_ENTRY _ZTI7S2337C4[];
extern  VTBL_ENTRY _ZTV7S2337C4[];
extern Class_Descriptor cd_S2337C7;
extern VTBL_ENTRY _ZTI7S2337C7[];
extern  VTBL_ENTRY _ZTV7S2337C7[];
extern Class_Descriptor cd_S2337C3;
extern VTBL_ENTRY _ZTI7S2337C3[];
extern  VTBL_ENTRY _ZTV7S2337C3[];
extern Class_Descriptor cd_S2337C10;
extern VTBL_ENTRY _ZTI8S2337C10[];
extern  VTBL_ENTRY _ZTV8S2337C10[];
extern Class_Descriptor cd_S2337C9;
extern VTBL_ENTRY _ZTI7S2337C9[];
extern  VTBL_ENTRY _ZTV7S2337C9[];
extern Class_Descriptor cd_S2337C8;
extern VTBL_ENTRY _ZTI7S2337C8[];
extern  VTBL_ENTRY _ZTV7S2337C8[];
static Base_Class bases_S2337C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2337C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2337C7,    ABISELECT(40,28), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2337C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2337C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2337C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2337C8,    ABISELECT(64,44), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2337C2[];
extern void _ZN7S2337C2D1Ev();
extern void _ZN7S2337C2D0Ev();
extern void _ZN7S2337C42v5Ev();
extern void _ZN7S2337C42v6Ev();
extern void _ZN7S2337C42v7Ev();
extern void _ZN7S2337C33v11Ev();
extern void _ZN7S2337C33v12Ev();
extern void _ZN7S2337C33v13Ev();
extern void _ZN7S2337C33v14Ev();
extern void _ZN7S2337C33v15Ev();
extern void _ZN7S2337C33v16Ev();
extern void _ZN7S2337C33v17Ev();
extern void _ZN7S2337C33v18Ev();
extern void _ZN7S2337C33v19Ev();
extern void _ZN7S2337C33v20Ev();
extern void _ZN7S2337C23v31Ev();
extern void _ZN7S2337C23v32Ev();
extern void _ZN7S2337C23v33Ev();
extern void _ZN7S2337C23v34Ev();
extern void _ZN7S2337C23v35Ev();
extern void _ZN7S2337C23v36Ev();
extern void ABISELECT(_ZThn40_N7S2337C2D1Ev,_ZThn28_N7S2337C2D1Ev)();
extern void ABISELECT(_ZThn40_N7S2337C2D0Ev,_ZThn28_N7S2337C2D0Ev)();
extern void _ZN7S2337C72v8Ev();
extern void _ZN7S2337C72v9Ev();
extern void _ZN7S2337C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2337C2D1Ev,_ZThn44_N7S2337C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S2337C2D0Ev,_ZThn44_N7S2337C2D0Ev)();
extern void _ZN8S2337C103v21Ev();
extern void _ZN8S2337C103v22Ev();
extern void _ZN8S2337C103v23Ev();
extern void _ZN7S2337C93v24Ev();
extern void _ZN7S2337C93v25Ev();
extern void _ZN7S2337C93v26Ev();
extern void _ZN7S2337C83v27Ev();
extern void _ZN7S2337C83v28Ev();
extern void _ZN7S2337C83v29Ev();
extern void _ZN7S2337C83v30Ev();
static  VTBL_ENTRY vtc_S2337C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2337C2[0]),
  (VTBL_ENTRY)&_ZN7S2337C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2337C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v36Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2337C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2337C2D1Ev,_ZThn28_N7S2337C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2337C2D0Ev,_ZThn28_N7S2337C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2337C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2337C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2337C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2337C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2337C2D1Ev,_ZThn44_N7S2337C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2337C2D0Ev,_ZThn44_N7S2337C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2337C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2337C2[];
extern  VTBL_ENTRY _ZTV7S2337C2[];
Class_Descriptor cd_S2337C2 = {  "S2337C2", // class name
  bases_S2337C2, 6,
  &(vtc_S2337C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,128), // object size
  NSPAIRA(_ZTI7S2337C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2337C2),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2337C19_nt  {
  void *s2337c19f0;
  virtual  ~S2337C19_nt(); // _ZN11S2337C19_ntD1Ev
  virtual void  v37(); // _ZN11S2337C19_nt3v37Ev
  virtual void  v38(); // _ZN11S2337C19_nt3v38Ev
  virtual void  v39(); // _ZN11S2337C19_nt3v39Ev
  virtual void  v40(); // _ZN11S2337C19_nt3v40Ev
  virtual void  v41(); // _ZN11S2337C19_nt3v41Ev
  S2337C19_nt(); // tgen
};
//SIG(-1 S2337C19_nt) C1{ vd v1 v2 v3 v4 v5 Fp}


 S2337C19_nt ::~S2337C19_nt(){ note_dtor("S2337C19_nt", this);}
void  S2337C19_nt ::v37(){vfunc_called(this, "_ZN11S2337C19_nt3v37Ev");}
void  S2337C19_nt ::v38(){vfunc_called(this, "_ZN11S2337C19_nt3v38Ev");}
void  S2337C19_nt ::v39(){vfunc_called(this, "_ZN11S2337C19_nt3v39Ev");}
void  S2337C19_nt ::v40(){vfunc_called(this, "_ZN11S2337C19_nt3v40Ev");}
void  S2337C19_nt ::v41(){vfunc_called(this, "_ZN11S2337C19_nt3v41Ev");}
S2337C19_nt ::S2337C19_nt(){ note_ctor("S2337C19_nt", this);} // tgen

//skip512 S2337C19_nt

#else // __cplusplus

extern void _ZN11S2337C19_ntC1Ev();
extern void _ZN11S2337C19_ntD1Ev();
Name_Map name_map_S2337C19_nt[] = {
  NSPAIR(_ZN11S2337C19_ntC1Ev),
  NSPAIR(_ZN11S2337C19_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S2337C19_nt[];
extern void _ZN11S2337C19_ntD1Ev();
extern void _ZN11S2337C19_ntD0Ev();
extern void _ZN11S2337C19_nt3v37Ev();
extern void _ZN11S2337C19_nt3v38Ev();
extern void _ZN11S2337C19_nt3v39Ev();
extern void _ZN11S2337C19_nt3v40Ev();
extern void _ZN11S2337C19_nt3v41Ev();
static  VTBL_ENTRY vtc_S2337C19_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S2337C19_nt[0]),
  (VTBL_ENTRY)&_ZN11S2337C19_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S2337C19_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S2337C19_nt3v37Ev,
  (VTBL_ENTRY)&_ZN11S2337C19_nt3v38Ev,
  (VTBL_ENTRY)&_ZN11S2337C19_nt3v39Ev,
  (VTBL_ENTRY)&_ZN11S2337C19_nt3v40Ev,
  (VTBL_ENTRY)&_ZN11S2337C19_nt3v41Ev,
};
extern VTBL_ENTRY _ZTI11S2337C19_nt[];
VTBL_ENTRY *P__ZTI11S2337C19_nt = _ZTI11S2337C19_nt; 
extern  VTBL_ENTRY _ZTV11S2337C19_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2337C1  : S2337C2 {
  ::S2337C19_nt s2337c1f0;
  ::S2348C20_nt s2337c1f1;
  int s2337c1f2;
  char s2337c1f3;
  int s2337c1f4;
  ::S9125C15 s2337c1f5;
  void *s2337c1f6[2];
  virtual  ~S2337C1(); // _ZN7S2337C1D1Ev
  virtual void  v1(); // _ZN7S2337C12v1Ev
  virtual void  v2(); // _ZN7S2337C12v2Ev
  virtual void  v3(); // _ZN7S2337C12v3Ev
  virtual void  v4(); // _ZN7S2337C12v4Ev
  S2337C1(); // tgen
};
//SIG(1 S2337C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} BC7{ vd v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp Fc Fi} BC8{ BC9{ BC10{ vd v21 v22 v23} vd v24 v25 v26 FC11{ m Fp Fi[2] FC12{ m}} FC13{ m FC14{ FL[4]}} Fc} vd v27 v28 v29 v30} vd v31 v32 v33 v34 v35 v36 Fi[3] Fc FC15{ BC16{ m Fp Fi FC17{ m} FC6}}} vd v1 v2 v3 v4 FC18{ vd v37 v38 v39 v40 v41 Fp} FC19{ BC20{ vd v43 FC21{ m FC16} Fp[3] Fc} v42 Fp} Fi Fc Fi FC22{ Fi[2] FC23{ Fi[2]}[10] FC24{ Fi[3] Fc[256]}[10]} Fp[2]}


 S2337C1 ::~S2337C1(){ note_dtor("S2337C1", this);}
void  S2337C1 ::v1(){vfunc_called(this, "_ZN7S2337C12v1Ev");}
void  S2337C1 ::v2(){vfunc_called(this, "_ZN7S2337C12v2Ev");}
void  S2337C1 ::v3(){vfunc_called(this, "_ZN7S2337C12v3Ev");}
void  S2337C1 ::v4(){vfunc_called(this, "_ZN7S2337C12v4Ev");}
S2337C1 ::S2337C1(){ note_ctor("S2337C1", this);} // tgen

static void Test_S2337C1()
{
  extern Class_Descriptor cd_S2337C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(382,741)];
    init_test(&cd_S2337C1, buf);
    S2337C1 *dp, &lv = *(dp=new (buf) S2337C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3048,2960), "sizeof(S2337C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2337C1)");
    check_base_class_offset(lv, (S2337C4*)(S2337C3*)(S2337C2*), 0, "S2337C1");
    check_base_class_offset(lv, (S2337C7*)(S2337C3*)(S2337C2*), ABISELECT(40,28), "S2337C1");
    check_base_class_offset(lv, (S2337C3*)(S2337C2*), 0, "S2337C1");
    check_base_class_offset(lv, (S2337C10*)(S2337C9*)(S2337C8*)(S2337C2*), ABISELECT(64,44), "S2337C1");
    check_base_class_offset(lv, (S2337C9*)(S2337C8*)(S2337C2*), ABISELECT(64,44), "S2337C1");
    check_base_class_offset(lv, (S2337C8*)(S2337C2*), ABISELECT(64,44), "S2337C1");
    check_base_class_offset(lv, (S2337C2*), 0, "S2337C1");
    check_field_offset(lv, s2337c1f0, ABISELECT(168,128), "S2337C1.s2337c1f0");
    check_field_offset(lv, s2337c1f1, ABISELECT(184,136), "S2337C1.s2337c1f1");
    check_field_offset(lv, s2337c1f2, ABISELECT(248,172), "S2337C1.s2337c1f2");
    check_field_offset(lv, s2337c1f3, ABISELECT(252,176), "S2337C1.s2337c1f3");
    check_field_offset(lv, s2337c1f4, ABISELECT(256,180), "S2337C1.s2337c1f4");
    check_field_offset(lv, s2337c1f5, ABISELECT(260,184), "S2337C1.s2337c1f5");
    check_field_offset(lv, s2337c1f6, ABISELECT(3032,2952), "S2337C1.s2337c1f6");
    test_class_info(&lv, &cd_S2337C1);
    dp->~S2337C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2337C1(Test_S2337C1, "S2337C1", ABISELECT(3048,2960));

#else // __cplusplus

extern void _ZN7S2337C1C1Ev();
extern void _ZN7S2337C1D1Ev();
Name_Map name_map_S2337C1[] = {
  NSPAIR(_ZN7S2337C1C1Ev),
  NSPAIR(_ZN7S2337C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2337C4;
extern VTBL_ENTRY _ZTI7S2337C4[];
extern  VTBL_ENTRY _ZTV7S2337C4[];
extern Class_Descriptor cd_S2337C7;
extern VTBL_ENTRY _ZTI7S2337C7[];
extern  VTBL_ENTRY _ZTV7S2337C7[];
extern Class_Descriptor cd_S2337C3;
extern VTBL_ENTRY _ZTI7S2337C3[];
extern  VTBL_ENTRY _ZTV7S2337C3[];
extern Class_Descriptor cd_S2337C10;
extern VTBL_ENTRY _ZTI8S2337C10[];
extern  VTBL_ENTRY _ZTV8S2337C10[];
extern Class_Descriptor cd_S2337C9;
extern VTBL_ENTRY _ZTI7S2337C9[];
extern  VTBL_ENTRY _ZTV7S2337C9[];
extern Class_Descriptor cd_S2337C8;
extern VTBL_ENTRY _ZTI7S2337C8[];
extern  VTBL_ENTRY _ZTV7S2337C8[];
extern Class_Descriptor cd_S2337C2;
extern VTBL_ENTRY _ZTI7S2337C2[];
extern  VTBL_ENTRY _ZTV7S2337C2[];
static Base_Class bases_S2337C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2337C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2337C7,    ABISELECT(40,28), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2337C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2337C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2337C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2337C8,    ABISELECT(64,44), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2337C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2337C1[];
extern void _ZN7S2337C1D1Ev();
extern void _ZN7S2337C1D0Ev();
extern void _ZN7S2337C42v5Ev();
extern void _ZN7S2337C42v6Ev();
extern void _ZN7S2337C42v7Ev();
extern void _ZN7S2337C33v11Ev();
extern void _ZN7S2337C33v12Ev();
extern void _ZN7S2337C33v13Ev();
extern void _ZN7S2337C33v14Ev();
extern void _ZN7S2337C33v15Ev();
extern void _ZN7S2337C33v16Ev();
extern void _ZN7S2337C33v17Ev();
extern void _ZN7S2337C33v18Ev();
extern void _ZN7S2337C33v19Ev();
extern void _ZN7S2337C33v20Ev();
extern void _ZN7S2337C23v31Ev();
extern void _ZN7S2337C23v32Ev();
extern void _ZN7S2337C23v33Ev();
extern void _ZN7S2337C23v34Ev();
extern void _ZN7S2337C23v35Ev();
extern void _ZN7S2337C23v36Ev();
extern void _ZN7S2337C12v1Ev();
extern void _ZN7S2337C12v2Ev();
extern void _ZN7S2337C12v3Ev();
extern void _ZN7S2337C12v4Ev();
extern void ABISELECT(_ZThn40_N7S2337C1D1Ev,_ZThn28_N7S2337C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S2337C1D0Ev,_ZThn28_N7S2337C1D0Ev)();
extern void _ZN7S2337C72v8Ev();
extern void _ZN7S2337C72v9Ev();
extern void _ZN7S2337C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2337C1D1Ev,_ZThn44_N7S2337C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S2337C1D0Ev,_ZThn44_N7S2337C1D0Ev)();
extern void _ZN8S2337C103v21Ev();
extern void _ZN8S2337C103v22Ev();
extern void _ZN8S2337C103v23Ev();
extern void _ZN7S2337C93v24Ev();
extern void _ZN7S2337C93v25Ev();
extern void _ZN7S2337C93v26Ev();
extern void _ZN7S2337C83v27Ev();
extern void _ZN7S2337C83v28Ev();
extern void _ZN7S2337C83v29Ev();
extern void _ZN7S2337C83v30Ev();
static  VTBL_ENTRY vtc_S2337C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2337C1[0]),
  (VTBL_ENTRY)&_ZN7S2337C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2337C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2337C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2337C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2337C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2337C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2337C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2337C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2337C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2337C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2337C1D1Ev,_ZThn28_N7S2337C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2337C1D0Ev,_ZThn28_N7S2337C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2337C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2337C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2337C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2337C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2337C1D1Ev,_ZThn44_N7S2337C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2337C1D0Ev,_ZThn44_N7S2337C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2337C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2337C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2337C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2337C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2337C1[];
extern  VTBL_ENTRY _ZTV7S2337C1[];
Class_Descriptor cd_S2337C1 = {  "S2337C1", // class name
  bases_S2337C1, 7,
  &(vtc_S2337C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(3048,2960), // object size
  NSPAIRA(_ZTI7S2337C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2337C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2336C4  {
  ::S10183C15_nt s2336c4f0;
  int s2336c4f1[2];
  char s2336c4f2;
  virtual  ~S2336C4(); // _ZN7S2336C4D1Ev
  virtual void  v5(); // _ZN7S2336C42v5Ev
  virtual void  v6(); // _ZN7S2336C42v6Ev
  virtual void  v7(); // _ZN7S2336C42v7Ev
  S2336C4(); // tgen
};
//SIG(-1 S2336C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2336C4 ::~S2336C4(){ note_dtor("S2336C4", this);}
void  S2336C4 ::v5(){vfunc_called(this, "_ZN7S2336C42v5Ev");}
void  S2336C4 ::v6(){vfunc_called(this, "_ZN7S2336C42v6Ev");}
void  S2336C4 ::v7(){vfunc_called(this, "_ZN7S2336C42v7Ev");}
S2336C4 ::S2336C4(){ note_ctor("S2336C4", this);} // tgen

static void Test_S2336C4()
{
  extern Class_Descriptor cd_S2336C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2336C4, buf);
    S2336C4 *dp, &lv = *(dp=new (buf) S2336C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2336C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2336C4)");
    check_field_offset(lv, s2336c4f0, ABISELECT(8,4), "S2336C4.s2336c4f0");
    check_field_offset(lv, s2336c4f1, ABISELECT(24,16), "S2336C4.s2336c4f1");
    check_field_offset(lv, s2336c4f2, ABISELECT(32,24), "S2336C4.s2336c4f2");
    test_class_info(&lv, &cd_S2336C4);
    dp->~S2336C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2336C4(Test_S2336C4, "S2336C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2336C4C1Ev();
extern void _ZN7S2336C4D1Ev();
Name_Map name_map_S2336C4[] = {
  NSPAIR(_ZN7S2336C4C1Ev),
  NSPAIR(_ZN7S2336C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2336C4[];
extern void _ZN7S2336C4D1Ev();
extern void _ZN7S2336C4D0Ev();
extern void _ZN7S2336C42v5Ev();
extern void _ZN7S2336C42v6Ev();
extern void _ZN7S2336C42v7Ev();
static  VTBL_ENTRY vtc_S2336C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2336C4[0]),
  (VTBL_ENTRY)&_ZN7S2336C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2336C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v7Ev,
};
extern VTBL_ENTRY _ZTI7S2336C4[];
extern  VTBL_ENTRY _ZTV7S2336C4[];
Class_Descriptor cd_S2336C4 = {  "S2336C4", // class name
  0,0,//no base classes
  &(vtc_S2336C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2336C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2336C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2336C7  {
  virtual  ~S2336C7(); // _ZN7S2336C7D1Ev
  virtual void  v8(); // _ZN7S2336C72v8Ev
  virtual void  v9(); // _ZN7S2336C72v9Ev
  virtual void  v10(); // _ZN7S2336C73v10Ev
  S2336C7(); // tgen
};
//SIG(-1 S2336C7) C1{ vd v1 v2 v3}


 S2336C7 ::~S2336C7(){ note_dtor("S2336C7", this);}
void  S2336C7 ::v8(){vfunc_called(this, "_ZN7S2336C72v8Ev");}
void  S2336C7 ::v9(){vfunc_called(this, "_ZN7S2336C72v9Ev");}
void  S2336C7 ::v10(){vfunc_called(this, "_ZN7S2336C73v10Ev");}
S2336C7 ::S2336C7(){ note_ctor("S2336C7", this);} // tgen

static void Test_S2336C7()
{
  extern Class_Descriptor cd_S2336C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2336C7, buf);
    S2336C7 *dp, &lv = *(dp=new (buf) S2336C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2336C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2336C7)");
    test_class_info(&lv, &cd_S2336C7);
    dp->~S2336C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2336C7(Test_S2336C7, "S2336C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2336C7C1Ev();
extern void _ZN7S2336C7D1Ev();
Name_Map name_map_S2336C7[] = {
  NSPAIR(_ZN7S2336C7C1Ev),
  NSPAIR(_ZN7S2336C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2336C7[];
extern void _ZN7S2336C7D1Ev();
extern void _ZN7S2336C7D0Ev();
extern void _ZN7S2336C72v8Ev();
extern void _ZN7S2336C72v9Ev();
extern void _ZN7S2336C73v10Ev();
static  VTBL_ENTRY vtc_S2336C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2336C7[0]),
  (VTBL_ENTRY)&_ZN7S2336C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2336C7D0Ev,
  (VTBL_ENTRY)&_ZN7S2336C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2336C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2336C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2336C7[];
extern  VTBL_ENTRY _ZTV7S2336C7[];
Class_Descriptor cd_S2336C7 = {  "S2336C7", // class name
  0,0,//no base classes
  &(vtc_S2336C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2336C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2336C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2336C3  : S2336C4 , S2336C7 {
  void *s2336c3f0;
  char s2336c3f1;
  int s2336c3f2;
  virtual  ~S2336C3(); // _ZN7S2336C3D1Ev
  virtual void  v11(); // _ZN7S2336C33v11Ev
  virtual void  v12(); // _ZN7S2336C33v12Ev
  virtual void  v13(); // _ZN7S2336C33v13Ev
  virtual void  v14(); // _ZN7S2336C33v14Ev
  virtual void  v15(); // _ZN7S2336C33v15Ev
  virtual void  v16(); // _ZN7S2336C33v16Ev
  virtual void  v17(); // _ZN7S2336C33v17Ev
  virtual void  v18(); // _ZN7S2336C33v18Ev
  virtual void  v19(); // _ZN7S2336C33v19Ev
  virtual void  v20(); // _ZN7S2336C33v20Ev
  S2336C3(); // tgen
};
//SIG(-1 S2336C3) C1{ BC2{ vd v11 v12 v13 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ vd v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi}


 S2336C3 ::~S2336C3(){ note_dtor("S2336C3", this);}
void  S2336C3 ::v11(){vfunc_called(this, "_ZN7S2336C33v11Ev");}
void  S2336C3 ::v12(){vfunc_called(this, "_ZN7S2336C33v12Ev");}
void  S2336C3 ::v13(){vfunc_called(this, "_ZN7S2336C33v13Ev");}
void  S2336C3 ::v14(){vfunc_called(this, "_ZN7S2336C33v14Ev");}
void  S2336C3 ::v15(){vfunc_called(this, "_ZN7S2336C33v15Ev");}
void  S2336C3 ::v16(){vfunc_called(this, "_ZN7S2336C33v16Ev");}
void  S2336C3 ::v17(){vfunc_called(this, "_ZN7S2336C33v17Ev");}
void  S2336C3 ::v18(){vfunc_called(this, "_ZN7S2336C33v18Ev");}
void  S2336C3 ::v19(){vfunc_called(this, "_ZN7S2336C33v19Ev");}
void  S2336C3 ::v20(){vfunc_called(this, "_ZN7S2336C33v20Ev");}
S2336C3 ::S2336C3(){ note_ctor("S2336C3", this);} // tgen

static void Test_S2336C3()
{
  extern Class_Descriptor cd_S2336C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S2336C3, buf);
    S2336C3 *dp, &lv = *(dp=new (buf) S2336C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2336C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2336C3)");
    check_base_class_offset(lv, (S2336C4*), 0, "S2336C3");
    check_base_class_offset(lv, (S2336C7*), ABISELECT(40,28), "S2336C3");
    check_field_offset(lv, s2336c3f0, ABISELECT(48,32), "S2336C3.s2336c3f0");
    check_field_offset(lv, s2336c3f1, ABISELECT(56,36), "S2336C3.s2336c3f1");
    check_field_offset(lv, s2336c3f2, ABISELECT(60,40), "S2336C3.s2336c3f2");
    test_class_info(&lv, &cd_S2336C3);
    dp->~S2336C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2336C3(Test_S2336C3, "S2336C3", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN7S2336C3C1Ev();
extern void _ZN7S2336C3D1Ev();
Name_Map name_map_S2336C3[] = {
  NSPAIR(_ZN7S2336C3C1Ev),
  NSPAIR(_ZN7S2336C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2336C4;
extern VTBL_ENTRY _ZTI7S2336C4[];
extern  VTBL_ENTRY _ZTV7S2336C4[];
extern Class_Descriptor cd_S2336C7;
extern VTBL_ENTRY _ZTI7S2336C7[];
extern  VTBL_ENTRY _ZTV7S2336C7[];
static Base_Class bases_S2336C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2336C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2336C7,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2336C3[];
extern void _ZN7S2336C3D1Ev();
extern void _ZN7S2336C3D0Ev();
extern void _ZN7S2336C42v5Ev();
extern void _ZN7S2336C42v6Ev();
extern void _ZN7S2336C42v7Ev();
extern void _ZN7S2336C33v11Ev();
extern void _ZN7S2336C33v12Ev();
extern void _ZN7S2336C33v13Ev();
extern void _ZN7S2336C33v14Ev();
extern void _ZN7S2336C33v15Ev();
extern void _ZN7S2336C33v16Ev();
extern void _ZN7S2336C33v17Ev();
extern void _ZN7S2336C33v18Ev();
extern void _ZN7S2336C33v19Ev();
extern void _ZN7S2336C33v20Ev();
extern void ABISELECT(_ZThn40_N7S2336C3D1Ev,_ZThn28_N7S2336C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S2336C3D0Ev,_ZThn28_N7S2336C3D0Ev)();
extern void _ZN7S2336C72v8Ev();
extern void _ZN7S2336C72v9Ev();
extern void _ZN7S2336C73v10Ev();
static  VTBL_ENTRY vtc_S2336C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2336C3[0]),
  (VTBL_ENTRY)&_ZN7S2336C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2336C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v20Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2336C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2336C3D1Ev,_ZThn28_N7S2336C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2336C3D0Ev,_ZThn28_N7S2336C3D0Ev),
  (VTBL_ENTRY)&_ZN7S2336C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2336C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2336C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2336C3[];
extern  VTBL_ENTRY _ZTV7S2336C3[];
Class_Descriptor cd_S2336C3 = {  "S2336C3", // class name
  bases_S2336C3, 2,
  &(vtc_S2336C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI7S2336C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2336C3),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2336C10  {
  virtual  ~S2336C10(); // _ZN8S2336C10D1Ev
  virtual void  v21(); // _ZN8S2336C103v21Ev
  virtual void  v22(); // _ZN8S2336C103v22Ev
  virtual void  v23(); // _ZN8S2336C103v23Ev
  S2336C10(); // tgen
};
//SIG(-1 S2336C10) C1{ vd v1 v2 v3}


 S2336C10 ::~S2336C10(){ note_dtor("S2336C10", this);}
void  S2336C10 ::v21(){vfunc_called(this, "_ZN8S2336C103v21Ev");}
void  S2336C10 ::v22(){vfunc_called(this, "_ZN8S2336C103v22Ev");}
void  S2336C10 ::v23(){vfunc_called(this, "_ZN8S2336C103v23Ev");}
S2336C10 ::S2336C10(){ note_ctor("S2336C10", this);} // tgen

static void Test_S2336C10()
{
  extern Class_Descriptor cd_S2336C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2336C10, buf);
    S2336C10 *dp, &lv = *(dp=new (buf) S2336C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2336C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2336C10)");
    test_class_info(&lv, &cd_S2336C10);
    dp->~S2336C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2336C10(Test_S2336C10, "S2336C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2336C10C1Ev();
extern void _ZN8S2336C10D1Ev();
Name_Map name_map_S2336C10[] = {
  NSPAIR(_ZN8S2336C10C1Ev),
  NSPAIR(_ZN8S2336C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2336C10[];
extern void _ZN8S2336C10D1Ev();
extern void _ZN8S2336C10D0Ev();
extern void _ZN8S2336C103v21Ev();
extern void _ZN8S2336C103v22Ev();
extern void _ZN8S2336C103v23Ev();
static  VTBL_ENTRY vtc_S2336C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2336C10[0]),
  (VTBL_ENTRY)&_ZN8S2336C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2336C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v23Ev,
};
extern VTBL_ENTRY _ZTI8S2336C10[];
extern  VTBL_ENTRY _ZTV8S2336C10[];
Class_Descriptor cd_S2336C10 = {  "S2336C10", // class name
  0,0,//no base classes
  &(vtc_S2336C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2336C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2336C10),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2336C9  : S2336C10 {
  ::S10183C20 s2336c9f0;
  ::S10183C7_nt s2336c9f1;
  char s2336c9f2;
  virtual  ~S2336C9(); // _ZN7S2336C9D1Ev
  virtual void  v24(); // _ZN7S2336C93v24Ev
  virtual void  v25(); // _ZN7S2336C93v25Ev
  virtual void  v26(); // _ZN7S2336C93v26Ev
  S2336C9(); // tgen
};
//SIG(-1 S2336C9) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ Fl[4]}} Fc}


 S2336C9 ::~S2336C9(){ note_dtor("S2336C9", this);}
void  S2336C9 ::v24(){vfunc_called(this, "_ZN7S2336C93v24Ev");}
void  S2336C9 ::v25(){vfunc_called(this, "_ZN7S2336C93v25Ev");}
void  S2336C9 ::v26(){vfunc_called(this, "_ZN7S2336C93v26Ev");}
S2336C9 ::S2336C9(){ note_ctor("S2336C9", this);} // tgen

static void Test_S2336C9()
{
  extern Class_Descriptor cd_S2336C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2336C9, buf);
    S2336C9 *dp, &lv = *(dp=new (buf) S2336C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2336C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2336C9)");
    check_base_class_offset(lv, (S2336C10*), 0, "S2336C9");
    check_field_offset(lv, s2336c9f0, ABISELECT(8,4), "S2336C9.s2336c9f0");
    check_field_offset(lv, s2336c9f1, ABISELECT(32,20), "S2336C9.s2336c9f1");
    check_field_offset(lv, s2336c9f2, ABISELECT(64,36), "S2336C9.s2336c9f2");
    test_class_info(&lv, &cd_S2336C9);
    dp->~S2336C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2336C9(Test_S2336C9, "S2336C9", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2336C9C1Ev();
extern void _ZN7S2336C9D1Ev();
Name_Map name_map_S2336C9[] = {
  NSPAIR(_ZN7S2336C9C1Ev),
  NSPAIR(_ZN7S2336C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2336C10;
extern VTBL_ENTRY _ZTI8S2336C10[];
extern  VTBL_ENTRY _ZTV8S2336C10[];
static Base_Class bases_S2336C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2336C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2336C9[];
extern void _ZN7S2336C9D1Ev();
extern void _ZN7S2336C9D0Ev();
extern void _ZN8S2336C103v21Ev();
extern void _ZN8S2336C103v22Ev();
extern void _ZN8S2336C103v23Ev();
extern void _ZN7S2336C93v24Ev();
extern void _ZN7S2336C93v25Ev();
extern void _ZN7S2336C93v26Ev();
static  VTBL_ENTRY vtc_S2336C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2336C9[0]),
  (VTBL_ENTRY)&_ZN7S2336C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2336C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v26Ev,
};
extern VTBL_ENTRY _ZTI7S2336C9[];
extern  VTBL_ENTRY _ZTV7S2336C9[];
Class_Descriptor cd_S2336C9 = {  "S2336C9", // class name
  bases_S2336C9, 1,
  &(vtc_S2336C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2336C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2336C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2336C8  : S2336C9 {
  virtual  ~S2336C8(); // _ZN7S2336C8D1Ev
  virtual void  v27(); // _ZN7S2336C83v27Ev
  virtual void  v28(); // _ZN7S2336C83v28Ev
  virtual void  v29(); // _ZN7S2336C83v29Ev
  virtual void  v30(); // _ZN7S2336C83v30Ev
  S2336C8(); // tgen
};
//SIG(-1 S2336C8) C1{ BC2{ BC3{ vd v5 v6 v7} vd v8 v9 v10 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc} vd v1 v2 v3 v4}


 S2336C8 ::~S2336C8(){ note_dtor("S2336C8", this);}
void  S2336C8 ::v27(){vfunc_called(this, "_ZN7S2336C83v27Ev");}
void  S2336C8 ::v28(){vfunc_called(this, "_ZN7S2336C83v28Ev");}
void  S2336C8 ::v29(){vfunc_called(this, "_ZN7S2336C83v29Ev");}
void  S2336C8 ::v30(){vfunc_called(this, "_ZN7S2336C83v30Ev");}
S2336C8 ::S2336C8(){ note_ctor("S2336C8", this);} // tgen

static void Test_S2336C8()
{
  extern Class_Descriptor cd_S2336C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2336C8, buf);
    S2336C8 *dp, &lv = *(dp=new (buf) S2336C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2336C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2336C8)");
    check_base_class_offset(lv, (S2336C10*)(S2336C9*), 0, "S2336C8");
    check_base_class_offset(lv, (S2336C9*), 0, "S2336C8");
    test_class_info(&lv, &cd_S2336C8);
    dp->~S2336C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2336C8(Test_S2336C8, "S2336C8", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2336C8C1Ev();
extern void _ZN7S2336C8D1Ev();
Name_Map name_map_S2336C8[] = {
  NSPAIR(_ZN7S2336C8C1Ev),
  NSPAIR(_ZN7S2336C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2336C10;
extern VTBL_ENTRY _ZTI8S2336C10[];
extern  VTBL_ENTRY _ZTV8S2336C10[];
extern Class_Descriptor cd_S2336C9;
extern VTBL_ENTRY _ZTI7S2336C9[];
extern  VTBL_ENTRY _ZTV7S2336C9[];
static Base_Class bases_S2336C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2336C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2336C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2336C8[];
extern void _ZN7S2336C8D1Ev();
extern void _ZN7S2336C8D0Ev();
extern void _ZN8S2336C103v21Ev();
extern void _ZN8S2336C103v22Ev();
extern void _ZN8S2336C103v23Ev();
extern void _ZN7S2336C93v24Ev();
extern void _ZN7S2336C93v25Ev();
extern void _ZN7S2336C93v26Ev();
extern void _ZN7S2336C83v27Ev();
extern void _ZN7S2336C83v28Ev();
extern void _ZN7S2336C83v29Ev();
extern void _ZN7S2336C83v30Ev();
static  VTBL_ENTRY vtc_S2336C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2336C8[0]),
  (VTBL_ENTRY)&_ZN7S2336C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2336C8D0Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2336C8[];
extern  VTBL_ENTRY _ZTV7S2336C8[];
Class_Descriptor cd_S2336C8 = {  "S2336C8", // class name
  bases_S2336C8, 2,
  &(vtc_S2336C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2336C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2336C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2336C2  : S2336C3 , S2336C8 {
  int s2336c2f0[3];
  char s2336c2f1;
  ::S10183C9_nt s2336c2f2;
  virtual  ~S2336C2(); // _ZN7S2336C2D1Ev
  virtual void  v31(); // _ZN7S2336C23v31Ev
  virtual void  v32(); // _ZN7S2336C23v32Ev
  virtual void  v33(); // _ZN7S2336C23v33Ev
  virtual void  v34(); // _ZN7S2336C23v34Ev
  virtual void  v35(); // _ZN7S2336C23v35Ev
  virtual void  v36(); // _ZN7S2336C23v36Ev
  S2336C2(); // tgen
};
//SIG(-1 S2336C2) C1{ BC2{ BC3{ vd v7 v8 v9 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} BC6{ vd v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fc Fi} BC7{ BC8{ BC9{ vd v23 v24 v25} vd v26 v27 v28 FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FC13{ Fl[4]}} Fc} vd v29 v30 v31 v32} vd v1 v2 v3 v4 v5 v6 Fi[3] Fc FC14{ BC15{ m Fp Fi FC16{ m} FC5}}}


 S2336C2 ::~S2336C2(){ note_dtor("S2336C2", this);}
void  S2336C2 ::v31(){vfunc_called(this, "_ZN7S2336C23v31Ev");}
void  S2336C2 ::v32(){vfunc_called(this, "_ZN7S2336C23v32Ev");}
void  S2336C2 ::v33(){vfunc_called(this, "_ZN7S2336C23v33Ev");}
void  S2336C2 ::v34(){vfunc_called(this, "_ZN7S2336C23v34Ev");}
void  S2336C2 ::v35(){vfunc_called(this, "_ZN7S2336C23v35Ev");}
void  S2336C2 ::v36(){vfunc_called(this, "_ZN7S2336C23v36Ev");}
S2336C2 ::S2336C2(){ note_ctor("S2336C2", this);} // tgen

static void Test_S2336C2()
{
  extern Class_Descriptor cd_S2336C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,29)];
    init_test(&cd_S2336C2, buf);
    S2336C2 *dp, &lv = *(dp=new (buf) S2336C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,112), "sizeof(S2336C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2336C2)");
    check_base_class_offset(lv, (S2336C4*)(S2336C3*), 0, "S2336C2");
    check_base_class_offset(lv, (S2336C7*)(S2336C3*), ABISELECT(40,28), "S2336C2");
    check_base_class_offset(lv, (S2336C3*), 0, "S2336C2");
    check_base_class_offset(lv, (S2336C10*)(S2336C9*)(S2336C8*), ABISELECT(64,44), "S2336C2");
    check_base_class_offset(lv, (S2336C9*)(S2336C8*), ABISELECT(64,44), "S2336C2");
    check_base_class_offset(lv, (S2336C8*), ABISELECT(64,44), "S2336C2");
    check_field_offset(lv, s2336c2f0, ABISELECT(132,84), "S2336C2.s2336c2f0");
    check_field_offset(lv, s2336c2f1, ABISELECT(144,96), "S2336C2.s2336c2f1");
    check_field_offset(lv, s2336c2f2, ABISELECT(152,100), "S2336C2.s2336c2f2");
    test_class_info(&lv, &cd_S2336C2);
    dp->~S2336C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2336C2(Test_S2336C2, "S2336C2", ABISELECT(168,112));

#else // __cplusplus

extern void _ZN7S2336C2C1Ev();
extern void _ZN7S2336C2D1Ev();
Name_Map name_map_S2336C2[] = {
  NSPAIR(_ZN7S2336C2C1Ev),
  NSPAIR(_ZN7S2336C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2336C4;
extern VTBL_ENTRY _ZTI7S2336C4[];
extern  VTBL_ENTRY _ZTV7S2336C4[];
extern Class_Descriptor cd_S2336C7;
extern VTBL_ENTRY _ZTI7S2336C7[];
extern  VTBL_ENTRY _ZTV7S2336C7[];
extern Class_Descriptor cd_S2336C3;
extern VTBL_ENTRY _ZTI7S2336C3[];
extern  VTBL_ENTRY _ZTV7S2336C3[];
extern Class_Descriptor cd_S2336C10;
extern VTBL_ENTRY _ZTI8S2336C10[];
extern  VTBL_ENTRY _ZTV8S2336C10[];
extern Class_Descriptor cd_S2336C9;
extern VTBL_ENTRY _ZTI7S2336C9[];
extern  VTBL_ENTRY _ZTV7S2336C9[];
extern Class_Descriptor cd_S2336C8;
extern VTBL_ENTRY _ZTI7S2336C8[];
extern  VTBL_ENTRY _ZTV7S2336C8[];
static Base_Class bases_S2336C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2336C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2336C7,    ABISELECT(40,28), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2336C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2336C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2336C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2336C8,    ABISELECT(64,44), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2336C2[];
extern void _ZN7S2336C2D1Ev();
extern void _ZN7S2336C2D0Ev();
extern void _ZN7S2336C42v5Ev();
extern void _ZN7S2336C42v6Ev();
extern void _ZN7S2336C42v7Ev();
extern void _ZN7S2336C33v11Ev();
extern void _ZN7S2336C33v12Ev();
extern void _ZN7S2336C33v13Ev();
extern void _ZN7S2336C33v14Ev();
extern void _ZN7S2336C33v15Ev();
extern void _ZN7S2336C33v16Ev();
extern void _ZN7S2336C33v17Ev();
extern void _ZN7S2336C33v18Ev();
extern void _ZN7S2336C33v19Ev();
extern void _ZN7S2336C33v20Ev();
extern void _ZN7S2336C23v31Ev();
extern void _ZN7S2336C23v32Ev();
extern void _ZN7S2336C23v33Ev();
extern void _ZN7S2336C23v34Ev();
extern void _ZN7S2336C23v35Ev();
extern void _ZN7S2336C23v36Ev();
extern void ABISELECT(_ZThn40_N7S2336C2D1Ev,_ZThn28_N7S2336C2D1Ev)();
extern void ABISELECT(_ZThn40_N7S2336C2D0Ev,_ZThn28_N7S2336C2D0Ev)();
extern void _ZN7S2336C72v8Ev();
extern void _ZN7S2336C72v9Ev();
extern void _ZN7S2336C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2336C2D1Ev,_ZThn44_N7S2336C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S2336C2D0Ev,_ZThn44_N7S2336C2D0Ev)();
extern void _ZN8S2336C103v21Ev();
extern void _ZN8S2336C103v22Ev();
extern void _ZN8S2336C103v23Ev();
extern void _ZN7S2336C93v24Ev();
extern void _ZN7S2336C93v25Ev();
extern void _ZN7S2336C93v26Ev();
extern void _ZN7S2336C83v27Ev();
extern void _ZN7S2336C83v28Ev();
extern void _ZN7S2336C83v29Ev();
extern void _ZN7S2336C83v30Ev();
static  VTBL_ENTRY vtc_S2336C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2336C2[0]),
  (VTBL_ENTRY)&_ZN7S2336C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2336C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v36Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2336C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2336C2D1Ev,_ZThn28_N7S2336C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2336C2D0Ev,_ZThn28_N7S2336C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2336C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2336C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2336C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2336C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2336C2D1Ev,_ZThn44_N7S2336C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2336C2D0Ev,_ZThn44_N7S2336C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2336C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2336C2[];
extern  VTBL_ENTRY _ZTV7S2336C2[];
Class_Descriptor cd_S2336C2 = {  "S2336C2", // class name
  bases_S2336C2, 6,
  &(vtc_S2336C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,112), // object size
  NSPAIRA(_ZTI7S2336C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2336C2),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2336C1  : S2336C2 {
  ::S2337C19_nt s2336c1f0;
  ::S2348C20_nt s2336c1f1;
  int s2336c1f2;
  char s2336c1f3;
  int s2336c1f4;
  ::S9125C15 s2336c1f5;
  void *s2336c1f6[2];
  virtual  ~S2336C1(); // _ZN7S2336C1D1Ev
  virtual void  v1(); // _ZN7S2336C12v1Ev
  virtual void  v2(); // _ZN7S2336C12v2Ev
  virtual void  v3(); // _ZN7S2336C12v3Ev
  virtual void  v4(); // _ZN7S2336C12v4Ev
  S2336C1(); // tgen
};
//SIG(1 S2336C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} BC7{ vd v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp Fc Fi} BC8{ BC9{ BC10{ vd v21 v22 v23} vd v24 v25 v26 FC11{ m Fp Fi[2] FC12{ m}} FC13{ m FC14{ Fl[4]}} Fc} vd v27 v28 v29 v30} vd v31 v32 v33 v34 v35 v36 Fi[3] Fc FC15{ BC16{ m Fp Fi FC17{ m} FC6}}} vd v1 v2 v3 v4 FC18{ vd v37 v38 v39 v40 v41 Fp} FC19{ BC20{ vd v43 FC21{ m FC16} Fp[3] Fc} v42 Fp} Fi Fc Fi FC22{ Fi[2] FC23{ Fi[2]}[10] FC24{ Fi[3] Fc[256]}[10]} Fp[2]}


 S2336C1 ::~S2336C1(){ note_dtor("S2336C1", this);}
void  S2336C1 ::v1(){vfunc_called(this, "_ZN7S2336C12v1Ev");}
void  S2336C1 ::v2(){vfunc_called(this, "_ZN7S2336C12v2Ev");}
void  S2336C1 ::v3(){vfunc_called(this, "_ZN7S2336C12v3Ev");}
void  S2336C1 ::v4(){vfunc_called(this, "_ZN7S2336C12v4Ev");}
S2336C1 ::S2336C1(){ note_ctor("S2336C1", this);} // tgen

static void Test_S2336C1()
{
  extern Class_Descriptor cd_S2336C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(382,737)];
    init_test(&cd_S2336C1, buf);
    S2336C1 *dp, &lv = *(dp=new (buf) S2336C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3048,2944), "sizeof(S2336C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2336C1)");
    check_base_class_offset(lv, (S2336C4*)(S2336C3*)(S2336C2*), 0, "S2336C1");
    check_base_class_offset(lv, (S2336C7*)(S2336C3*)(S2336C2*), ABISELECT(40,28), "S2336C1");
    check_base_class_offset(lv, (S2336C3*)(S2336C2*), 0, "S2336C1");
    check_base_class_offset(lv, (S2336C10*)(S2336C9*)(S2336C8*)(S2336C2*), ABISELECT(64,44), "S2336C1");
    check_base_class_offset(lv, (S2336C9*)(S2336C8*)(S2336C2*), ABISELECT(64,44), "S2336C1");
    check_base_class_offset(lv, (S2336C8*)(S2336C2*), ABISELECT(64,44), "S2336C1");
    check_base_class_offset(lv, (S2336C2*), 0, "S2336C1");
    check_field_offset(lv, s2336c1f0, ABISELECT(168,112), "S2336C1.s2336c1f0");
    check_field_offset(lv, s2336c1f1, ABISELECT(184,120), "S2336C1.s2336c1f1");
    check_field_offset(lv, s2336c1f2, ABISELECT(248,156), "S2336C1.s2336c1f2");
    check_field_offset(lv, s2336c1f3, ABISELECT(252,160), "S2336C1.s2336c1f3");
    check_field_offset(lv, s2336c1f4, ABISELECT(256,164), "S2336C1.s2336c1f4");
    check_field_offset(lv, s2336c1f5, ABISELECT(260,168), "S2336C1.s2336c1f5");
    check_field_offset(lv, s2336c1f6, ABISELECT(3032,2936), "S2336C1.s2336c1f6");
    test_class_info(&lv, &cd_S2336C1);
    dp->~S2336C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2336C1(Test_S2336C1, "S2336C1", ABISELECT(3048,2944));

#else // __cplusplus

extern void _ZN7S2336C1C1Ev();
extern void _ZN7S2336C1D1Ev();
Name_Map name_map_S2336C1[] = {
  NSPAIR(_ZN7S2336C1C1Ev),
  NSPAIR(_ZN7S2336C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2336C4;
extern VTBL_ENTRY _ZTI7S2336C4[];
extern  VTBL_ENTRY _ZTV7S2336C4[];
extern Class_Descriptor cd_S2336C7;
extern VTBL_ENTRY _ZTI7S2336C7[];
extern  VTBL_ENTRY _ZTV7S2336C7[];
extern Class_Descriptor cd_S2336C3;
extern VTBL_ENTRY _ZTI7S2336C3[];
extern  VTBL_ENTRY _ZTV7S2336C3[];
extern Class_Descriptor cd_S2336C10;
extern VTBL_ENTRY _ZTI8S2336C10[];
extern  VTBL_ENTRY _ZTV8S2336C10[];
extern Class_Descriptor cd_S2336C9;
extern VTBL_ENTRY _ZTI7S2336C9[];
extern  VTBL_ENTRY _ZTV7S2336C9[];
extern Class_Descriptor cd_S2336C8;
extern VTBL_ENTRY _ZTI7S2336C8[];
extern  VTBL_ENTRY _ZTV7S2336C8[];
extern Class_Descriptor cd_S2336C2;
extern VTBL_ENTRY _ZTI7S2336C2[];
extern  VTBL_ENTRY _ZTV7S2336C2[];
static Base_Class bases_S2336C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2336C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2336C7,    ABISELECT(40,28), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2336C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2336C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2336C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2336C8,    ABISELECT(64,44), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2336C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2336C1[];
extern void _ZN7S2336C1D1Ev();
extern void _ZN7S2336C1D0Ev();
extern void _ZN7S2336C42v5Ev();
extern void _ZN7S2336C42v6Ev();
extern void _ZN7S2336C42v7Ev();
extern void _ZN7S2336C33v11Ev();
extern void _ZN7S2336C33v12Ev();
extern void _ZN7S2336C33v13Ev();
extern void _ZN7S2336C33v14Ev();
extern void _ZN7S2336C33v15Ev();
extern void _ZN7S2336C33v16Ev();
extern void _ZN7S2336C33v17Ev();
extern void _ZN7S2336C33v18Ev();
extern void _ZN7S2336C33v19Ev();
extern void _ZN7S2336C33v20Ev();
extern void _ZN7S2336C23v31Ev();
extern void _ZN7S2336C23v32Ev();
extern void _ZN7S2336C23v33Ev();
extern void _ZN7S2336C23v34Ev();
extern void _ZN7S2336C23v35Ev();
extern void _ZN7S2336C23v36Ev();
extern void _ZN7S2336C12v1Ev();
extern void _ZN7S2336C12v2Ev();
extern void _ZN7S2336C12v3Ev();
extern void _ZN7S2336C12v4Ev();
extern void ABISELECT(_ZThn40_N7S2336C1D1Ev,_ZThn28_N7S2336C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S2336C1D0Ev,_ZThn28_N7S2336C1D0Ev)();
extern void _ZN7S2336C72v8Ev();
extern void _ZN7S2336C72v9Ev();
extern void _ZN7S2336C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2336C1D1Ev,_ZThn44_N7S2336C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S2336C1D0Ev,_ZThn44_N7S2336C1D0Ev)();
extern void _ZN8S2336C103v21Ev();
extern void _ZN8S2336C103v22Ev();
extern void _ZN8S2336C103v23Ev();
extern void _ZN7S2336C93v24Ev();
extern void _ZN7S2336C93v25Ev();
extern void _ZN7S2336C93v26Ev();
extern void _ZN7S2336C83v27Ev();
extern void _ZN7S2336C83v28Ev();
extern void _ZN7S2336C83v29Ev();
extern void _ZN7S2336C83v30Ev();
static  VTBL_ENTRY vtc_S2336C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2336C1[0]),
  (VTBL_ENTRY)&_ZN7S2336C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2336C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2336C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2336C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2336C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2336C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2336C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2336C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2336C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2336C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2336C1D1Ev,_ZThn28_N7S2336C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2336C1D0Ev,_ZThn28_N7S2336C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2336C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2336C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2336C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2336C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2336C1D1Ev,_ZThn44_N7S2336C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2336C1D0Ev,_ZThn44_N7S2336C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2336C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2336C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2336C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2336C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2336C1[];
extern  VTBL_ENTRY _ZTV7S2336C1[];
Class_Descriptor cd_S2336C1 = {  "S2336C1", // class name
  bases_S2336C1, 7,
  &(vtc_S2336C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(3048,2944), // object size
  NSPAIRA(_ZTI7S2336C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2336C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2324C4  {
  ::S10183C15_nt s2324c4f0;
  int s2324c4f1[2];
  char s2324c4f2;
  virtual  ~S2324C4(); // _ZN7S2324C4D1Ev
  virtual void  v5(); // _ZN7S2324C42v5Ev
  virtual void  v6(); // _ZN7S2324C42v6Ev
  virtual void  v7(); // _ZN7S2324C42v7Ev
  S2324C4(); // tgen
};
//SIG(-1 S2324C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2324C4 ::~S2324C4(){ note_dtor("S2324C4", this);}
void  S2324C4 ::v5(){vfunc_called(this, "_ZN7S2324C42v5Ev");}
void  S2324C4 ::v6(){vfunc_called(this, "_ZN7S2324C42v6Ev");}
void  S2324C4 ::v7(){vfunc_called(this, "_ZN7S2324C42v7Ev");}
S2324C4 ::S2324C4(){ note_ctor("S2324C4", this);} // tgen

static void Test_S2324C4()
{
  extern Class_Descriptor cd_S2324C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2324C4, buf);
    S2324C4 *dp, &lv = *(dp=new (buf) S2324C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2324C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2324C4)");
    check_field_offset(lv, s2324c4f0, ABISELECT(8,4), "S2324C4.s2324c4f0");
    check_field_offset(lv, s2324c4f1, ABISELECT(24,16), "S2324C4.s2324c4f1");
    check_field_offset(lv, s2324c4f2, ABISELECT(32,24), "S2324C4.s2324c4f2");
    test_class_info(&lv, &cd_S2324C4);
    dp->~S2324C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2324C4(Test_S2324C4, "S2324C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2324C4C1Ev();
extern void _ZN7S2324C4D1Ev();
Name_Map name_map_S2324C4[] = {
  NSPAIR(_ZN7S2324C4C1Ev),
  NSPAIR(_ZN7S2324C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2324C4[];
extern void _ZN7S2324C4D1Ev();
extern void _ZN7S2324C4D0Ev();
extern void _ZN7S2324C42v5Ev();
extern void _ZN7S2324C42v6Ev();
extern void _ZN7S2324C42v7Ev();
static  VTBL_ENTRY vtc_S2324C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2324C4[0]),
  (VTBL_ENTRY)&_ZN7S2324C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2324C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v7Ev,
};
extern VTBL_ENTRY _ZTI7S2324C4[];
extern  VTBL_ENTRY _ZTV7S2324C4[];
Class_Descriptor cd_S2324C4 = {  "S2324C4", // class name
  0,0,//no base classes
  &(vtc_S2324C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2324C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2324C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2324C7  {
  virtual  ~S2324C7(); // _ZN7S2324C7D1Ev
  virtual void  v8(); // _ZN7S2324C72v8Ev
  virtual void  v9(); // _ZN7S2324C72v9Ev
  virtual void  v10(); // _ZN7S2324C73v10Ev
  S2324C7(); // tgen
};
//SIG(-1 S2324C7) C1{ vd v1 v2 v3}


 S2324C7 ::~S2324C7(){ note_dtor("S2324C7", this);}
void  S2324C7 ::v8(){vfunc_called(this, "_ZN7S2324C72v8Ev");}
void  S2324C7 ::v9(){vfunc_called(this, "_ZN7S2324C72v9Ev");}
void  S2324C7 ::v10(){vfunc_called(this, "_ZN7S2324C73v10Ev");}
S2324C7 ::S2324C7(){ note_ctor("S2324C7", this);} // tgen

static void Test_S2324C7()
{
  extern Class_Descriptor cd_S2324C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2324C7, buf);
    S2324C7 *dp, &lv = *(dp=new (buf) S2324C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2324C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2324C7)");
    test_class_info(&lv, &cd_S2324C7);
    dp->~S2324C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2324C7(Test_S2324C7, "S2324C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2324C7C1Ev();
extern void _ZN7S2324C7D1Ev();
Name_Map name_map_S2324C7[] = {
  NSPAIR(_ZN7S2324C7C1Ev),
  NSPAIR(_ZN7S2324C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2324C7[];
extern void _ZN7S2324C7D1Ev();
extern void _ZN7S2324C7D0Ev();
extern void _ZN7S2324C72v8Ev();
extern void _ZN7S2324C72v9Ev();
extern void _ZN7S2324C73v10Ev();
static  VTBL_ENTRY vtc_S2324C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2324C7[0]),
  (VTBL_ENTRY)&_ZN7S2324C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2324C7D0Ev,
  (VTBL_ENTRY)&_ZN7S2324C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2324C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2324C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2324C7[];
extern  VTBL_ENTRY _ZTV7S2324C7[];
Class_Descriptor cd_S2324C7 = {  "S2324C7", // class name
  0,0,//no base classes
  &(vtc_S2324C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2324C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2324C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2324C3  : S2324C4 , S2324C7 {
  void *s2324c3f0;
  char s2324c3f1;
  int s2324c3f2;
  virtual  ~S2324C3(); // _ZN7S2324C3D1Ev
  virtual void  v11(); // _ZN7S2324C33v11Ev
  virtual void  v12(); // _ZN7S2324C33v12Ev
  virtual void  v13(); // _ZN7S2324C33v13Ev
  virtual void  v14(); // _ZN7S2324C33v14Ev
  virtual void  v15(); // _ZN7S2324C33v15Ev
  virtual void  v16(); // _ZN7S2324C33v16Ev
  virtual void  v17(); // _ZN7S2324C33v17Ev
  virtual void  v18(); // _ZN7S2324C33v18Ev
  virtual void  v19(); // _ZN7S2324C33v19Ev
  virtual void  v20(); // _ZN7S2324C33v20Ev
  S2324C3(); // tgen
};
//SIG(-1 S2324C3) C1{ BC2{ vd v11 v12 v13 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ vd v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi}


 S2324C3 ::~S2324C3(){ note_dtor("S2324C3", this);}
void  S2324C3 ::v11(){vfunc_called(this, "_ZN7S2324C33v11Ev");}
void  S2324C3 ::v12(){vfunc_called(this, "_ZN7S2324C33v12Ev");}
void  S2324C3 ::v13(){vfunc_called(this, "_ZN7S2324C33v13Ev");}
void  S2324C3 ::v14(){vfunc_called(this, "_ZN7S2324C33v14Ev");}
void  S2324C3 ::v15(){vfunc_called(this, "_ZN7S2324C33v15Ev");}
void  S2324C3 ::v16(){vfunc_called(this, "_ZN7S2324C33v16Ev");}
void  S2324C3 ::v17(){vfunc_called(this, "_ZN7S2324C33v17Ev");}
void  S2324C3 ::v18(){vfunc_called(this, "_ZN7S2324C33v18Ev");}
void  S2324C3 ::v19(){vfunc_called(this, "_ZN7S2324C33v19Ev");}
void  S2324C3 ::v20(){vfunc_called(this, "_ZN7S2324C33v20Ev");}
S2324C3 ::S2324C3(){ note_ctor("S2324C3", this);} // tgen

static void Test_S2324C3()
{
  extern Class_Descriptor cd_S2324C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S2324C3, buf);
    S2324C3 *dp, &lv = *(dp=new (buf) S2324C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2324C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2324C3)");
    check_base_class_offset(lv, (S2324C4*), 0, "S2324C3");
    check_base_class_offset(lv, (S2324C7*), ABISELECT(40,28), "S2324C3");
    check_field_offset(lv, s2324c3f0, ABISELECT(48,32), "S2324C3.s2324c3f0");
    check_field_offset(lv, s2324c3f1, ABISELECT(56,36), "S2324C3.s2324c3f1");
    check_field_offset(lv, s2324c3f2, ABISELECT(60,40), "S2324C3.s2324c3f2");
    test_class_info(&lv, &cd_S2324C3);
    dp->~S2324C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2324C3(Test_S2324C3, "S2324C3", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN7S2324C3C1Ev();
extern void _ZN7S2324C3D1Ev();
Name_Map name_map_S2324C3[] = {
  NSPAIR(_ZN7S2324C3C1Ev),
  NSPAIR(_ZN7S2324C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2324C4;
extern VTBL_ENTRY _ZTI7S2324C4[];
extern  VTBL_ENTRY _ZTV7S2324C4[];
extern Class_Descriptor cd_S2324C7;
extern VTBL_ENTRY _ZTI7S2324C7[];
extern  VTBL_ENTRY _ZTV7S2324C7[];
static Base_Class bases_S2324C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2324C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2324C7,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2324C3[];
extern void _ZN7S2324C3D1Ev();
extern void _ZN7S2324C3D0Ev();
extern void _ZN7S2324C42v5Ev();
extern void _ZN7S2324C42v6Ev();
extern void _ZN7S2324C42v7Ev();
extern void _ZN7S2324C33v11Ev();
extern void _ZN7S2324C33v12Ev();
extern void _ZN7S2324C33v13Ev();
extern void _ZN7S2324C33v14Ev();
extern void _ZN7S2324C33v15Ev();
extern void _ZN7S2324C33v16Ev();
extern void _ZN7S2324C33v17Ev();
extern void _ZN7S2324C33v18Ev();
extern void _ZN7S2324C33v19Ev();
extern void _ZN7S2324C33v20Ev();
extern void ABISELECT(_ZThn40_N7S2324C3D1Ev,_ZThn28_N7S2324C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S2324C3D0Ev,_ZThn28_N7S2324C3D0Ev)();
extern void _ZN7S2324C72v8Ev();
extern void _ZN7S2324C72v9Ev();
extern void _ZN7S2324C73v10Ev();
static  VTBL_ENTRY vtc_S2324C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2324C3[0]),
  (VTBL_ENTRY)&_ZN7S2324C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2324C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v20Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2324C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2324C3D1Ev,_ZThn28_N7S2324C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2324C3D0Ev,_ZThn28_N7S2324C3D0Ev),
  (VTBL_ENTRY)&_ZN7S2324C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2324C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2324C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2324C3[];
extern  VTBL_ENTRY _ZTV7S2324C3[];
Class_Descriptor cd_S2324C3 = {  "S2324C3", // class name
  bases_S2324C3, 2,
  &(vtc_S2324C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI7S2324C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2324C3),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2324C10  {
  virtual  ~S2324C10(); // _ZN8S2324C10D1Ev
  virtual void  v21(); // _ZN8S2324C103v21Ev
  virtual void  v22(); // _ZN8S2324C103v22Ev
  virtual void  v23(); // _ZN8S2324C103v23Ev
  S2324C10(); // tgen
};
//SIG(-1 S2324C10) C1{ vd v1 v2 v3}


 S2324C10 ::~S2324C10(){ note_dtor("S2324C10", this);}
void  S2324C10 ::v21(){vfunc_called(this, "_ZN8S2324C103v21Ev");}
void  S2324C10 ::v22(){vfunc_called(this, "_ZN8S2324C103v22Ev");}
void  S2324C10 ::v23(){vfunc_called(this, "_ZN8S2324C103v23Ev");}
S2324C10 ::S2324C10(){ note_ctor("S2324C10", this);} // tgen

static void Test_S2324C10()
{
  extern Class_Descriptor cd_S2324C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2324C10, buf);
    S2324C10 *dp, &lv = *(dp=new (buf) S2324C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2324C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2324C10)");
    test_class_info(&lv, &cd_S2324C10);
    dp->~S2324C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2324C10(Test_S2324C10, "S2324C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2324C10C1Ev();
extern void _ZN8S2324C10D1Ev();
Name_Map name_map_S2324C10[] = {
  NSPAIR(_ZN8S2324C10C1Ev),
  NSPAIR(_ZN8S2324C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2324C10[];
extern void _ZN8S2324C10D1Ev();
extern void _ZN8S2324C10D0Ev();
extern void _ZN8S2324C103v21Ev();
extern void _ZN8S2324C103v22Ev();
extern void _ZN8S2324C103v23Ev();
static  VTBL_ENTRY vtc_S2324C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2324C10[0]),
  (VTBL_ENTRY)&_ZN8S2324C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2324C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v23Ev,
};
extern VTBL_ENTRY _ZTI8S2324C10[];
extern  VTBL_ENTRY _ZTV8S2324C10[];
Class_Descriptor cd_S2324C10 = {  "S2324C10", // class name
  0,0,//no base classes
  &(vtc_S2324C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2324C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2324C10),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2324C9  : S2324C10 {
  ::S10183C20 s2324c9f0;
  ::S10183C7_nt s2324c9f1;
  char s2324c9f2;
  virtual  ~S2324C9(); // _ZN7S2324C9D1Ev
  virtual void  v24(); // _ZN7S2324C93v24Ev
  virtual void  v25(); // _ZN7S2324C93v25Ev
  virtual void  v26(); // _ZN7S2324C93v26Ev
  S2324C9(); // tgen
};
//SIG(-1 S2324C9) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ Fl[4]}} Fc}


 S2324C9 ::~S2324C9(){ note_dtor("S2324C9", this);}
void  S2324C9 ::v24(){vfunc_called(this, "_ZN7S2324C93v24Ev");}
void  S2324C9 ::v25(){vfunc_called(this, "_ZN7S2324C93v25Ev");}
void  S2324C9 ::v26(){vfunc_called(this, "_ZN7S2324C93v26Ev");}
S2324C9 ::S2324C9(){ note_ctor("S2324C9", this);} // tgen

static void Test_S2324C9()
{
  extern Class_Descriptor cd_S2324C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2324C9, buf);
    S2324C9 *dp, &lv = *(dp=new (buf) S2324C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2324C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2324C9)");
    check_base_class_offset(lv, (S2324C10*), 0, "S2324C9");
    check_field_offset(lv, s2324c9f0, ABISELECT(8,4), "S2324C9.s2324c9f0");
    check_field_offset(lv, s2324c9f1, ABISELECT(32,20), "S2324C9.s2324c9f1");
    check_field_offset(lv, s2324c9f2, ABISELECT(64,36), "S2324C9.s2324c9f2");
    test_class_info(&lv, &cd_S2324C9);
    dp->~S2324C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2324C9(Test_S2324C9, "S2324C9", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2324C9C1Ev();
extern void _ZN7S2324C9D1Ev();
Name_Map name_map_S2324C9[] = {
  NSPAIR(_ZN7S2324C9C1Ev),
  NSPAIR(_ZN7S2324C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2324C10;
extern VTBL_ENTRY _ZTI8S2324C10[];
extern  VTBL_ENTRY _ZTV8S2324C10[];
static Base_Class bases_S2324C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2324C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2324C9[];
extern void _ZN7S2324C9D1Ev();
extern void _ZN7S2324C9D0Ev();
extern void _ZN8S2324C103v21Ev();
extern void _ZN8S2324C103v22Ev();
extern void _ZN8S2324C103v23Ev();
extern void _ZN7S2324C93v24Ev();
extern void _ZN7S2324C93v25Ev();
extern void _ZN7S2324C93v26Ev();
static  VTBL_ENTRY vtc_S2324C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2324C9[0]),
  (VTBL_ENTRY)&_ZN7S2324C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2324C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v26Ev,
};
extern VTBL_ENTRY _ZTI7S2324C9[];
extern  VTBL_ENTRY _ZTV7S2324C9[];
Class_Descriptor cd_S2324C9 = {  "S2324C9", // class name
  bases_S2324C9, 1,
  &(vtc_S2324C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2324C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2324C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2324C8  : S2324C9 {
  virtual  ~S2324C8(); // _ZN7S2324C8D1Ev
  virtual void  v27(); // _ZN7S2324C83v27Ev
  virtual void  v28(); // _ZN7S2324C83v28Ev
  virtual void  v29(); // _ZN7S2324C83v29Ev
  virtual void  v30(); // _ZN7S2324C83v30Ev
  S2324C8(); // tgen
};
//SIG(-1 S2324C8) C1{ BC2{ BC3{ vd v5 v6 v7} vd v8 v9 v10 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc} vd v1 v2 v3 v4}


 S2324C8 ::~S2324C8(){ note_dtor("S2324C8", this);}
void  S2324C8 ::v27(){vfunc_called(this, "_ZN7S2324C83v27Ev");}
void  S2324C8 ::v28(){vfunc_called(this, "_ZN7S2324C83v28Ev");}
void  S2324C8 ::v29(){vfunc_called(this, "_ZN7S2324C83v29Ev");}
void  S2324C8 ::v30(){vfunc_called(this, "_ZN7S2324C83v30Ev");}
S2324C8 ::S2324C8(){ note_ctor("S2324C8", this);} // tgen

static void Test_S2324C8()
{
  extern Class_Descriptor cd_S2324C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2324C8, buf);
    S2324C8 *dp, &lv = *(dp=new (buf) S2324C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2324C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2324C8)");
    check_base_class_offset(lv, (S2324C10*)(S2324C9*), 0, "S2324C8");
    check_base_class_offset(lv, (S2324C9*), 0, "S2324C8");
    test_class_info(&lv, &cd_S2324C8);
    dp->~S2324C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2324C8(Test_S2324C8, "S2324C8", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2324C8C1Ev();
extern void _ZN7S2324C8D1Ev();
Name_Map name_map_S2324C8[] = {
  NSPAIR(_ZN7S2324C8C1Ev),
  NSPAIR(_ZN7S2324C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2324C10;
extern VTBL_ENTRY _ZTI8S2324C10[];
extern  VTBL_ENTRY _ZTV8S2324C10[];
extern Class_Descriptor cd_S2324C9;
extern VTBL_ENTRY _ZTI7S2324C9[];
extern  VTBL_ENTRY _ZTV7S2324C9[];
static Base_Class bases_S2324C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2324C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2324C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2324C8[];
extern void _ZN7S2324C8D1Ev();
extern void _ZN7S2324C8D0Ev();
extern void _ZN8S2324C103v21Ev();
extern void _ZN8S2324C103v22Ev();
extern void _ZN8S2324C103v23Ev();
extern void _ZN7S2324C93v24Ev();
extern void _ZN7S2324C93v25Ev();
extern void _ZN7S2324C93v26Ev();
extern void _ZN7S2324C83v27Ev();
extern void _ZN7S2324C83v28Ev();
extern void _ZN7S2324C83v29Ev();
extern void _ZN7S2324C83v30Ev();
static  VTBL_ENTRY vtc_S2324C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2324C8[0]),
  (VTBL_ENTRY)&_ZN7S2324C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2324C8D0Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2324C8[];
extern  VTBL_ENTRY _ZTV7S2324C8[];
Class_Descriptor cd_S2324C8 = {  "S2324C8", // class name
  bases_S2324C8, 2,
  &(vtc_S2324C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2324C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2324C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2324C2  : S2324C3 , S2324C8 {
  int s2324c2f0[3];
  char s2324c2f1;
  ::S10183C9_nt s2324c2f2;
  virtual  ~S2324C2(); // _ZN7S2324C2D1Ev
  virtual void  v31(); // _ZN7S2324C23v31Ev
  virtual void  v32(); // _ZN7S2324C23v32Ev
  virtual void  v33(); // _ZN7S2324C23v33Ev
  virtual void  v34(); // _ZN7S2324C23v34Ev
  virtual void  v35(); // _ZN7S2324C23v35Ev
  virtual void  v36(); // _ZN7S2324C23v36Ev
  S2324C2(); // tgen
};
//SIG(-1 S2324C2) C1{ BC2{ BC3{ vd v7 v8 v9 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} BC6{ vd v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fc Fi} BC7{ BC8{ BC9{ vd v23 v24 v25} vd v26 v27 v28 FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FC13{ Fl[4]}} Fc} vd v29 v30 v31 v32} vd v1 v2 v3 v4 v5 v6 Fi[3] Fc FC14{ BC15{ m Fp Fi FC16{ m} FC5}}}


 S2324C2 ::~S2324C2(){ note_dtor("S2324C2", this);}
void  S2324C2 ::v31(){vfunc_called(this, "_ZN7S2324C23v31Ev");}
void  S2324C2 ::v32(){vfunc_called(this, "_ZN7S2324C23v32Ev");}
void  S2324C2 ::v33(){vfunc_called(this, "_ZN7S2324C23v33Ev");}
void  S2324C2 ::v34(){vfunc_called(this, "_ZN7S2324C23v34Ev");}
void  S2324C2 ::v35(){vfunc_called(this, "_ZN7S2324C23v35Ev");}
void  S2324C2 ::v36(){vfunc_called(this, "_ZN7S2324C23v36Ev");}
S2324C2 ::S2324C2(){ note_ctor("S2324C2", this);} // tgen

static void Test_S2324C2()
{
  extern Class_Descriptor cd_S2324C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,29)];
    init_test(&cd_S2324C2, buf);
    S2324C2 *dp, &lv = *(dp=new (buf) S2324C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,112), "sizeof(S2324C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2324C2)");
    check_base_class_offset(lv, (S2324C4*)(S2324C3*), 0, "S2324C2");
    check_base_class_offset(lv, (S2324C7*)(S2324C3*), ABISELECT(40,28), "S2324C2");
    check_base_class_offset(lv, (S2324C3*), 0, "S2324C2");
    check_base_class_offset(lv, (S2324C10*)(S2324C9*)(S2324C8*), ABISELECT(64,44), "S2324C2");
    check_base_class_offset(lv, (S2324C9*)(S2324C8*), ABISELECT(64,44), "S2324C2");
    check_base_class_offset(lv, (S2324C8*), ABISELECT(64,44), "S2324C2");
    check_field_offset(lv, s2324c2f0, ABISELECT(132,84), "S2324C2.s2324c2f0");
    check_field_offset(lv, s2324c2f1, ABISELECT(144,96), "S2324C2.s2324c2f1");
    check_field_offset(lv, s2324c2f2, ABISELECT(152,100), "S2324C2.s2324c2f2");
    test_class_info(&lv, &cd_S2324C2);
    dp->~S2324C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2324C2(Test_S2324C2, "S2324C2", ABISELECT(168,112));

#else // __cplusplus

extern void _ZN7S2324C2C1Ev();
extern void _ZN7S2324C2D1Ev();
Name_Map name_map_S2324C2[] = {
  NSPAIR(_ZN7S2324C2C1Ev),
  NSPAIR(_ZN7S2324C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2324C4;
extern VTBL_ENTRY _ZTI7S2324C4[];
extern  VTBL_ENTRY _ZTV7S2324C4[];
extern Class_Descriptor cd_S2324C7;
extern VTBL_ENTRY _ZTI7S2324C7[];
extern  VTBL_ENTRY _ZTV7S2324C7[];
extern Class_Descriptor cd_S2324C3;
extern VTBL_ENTRY _ZTI7S2324C3[];
extern  VTBL_ENTRY _ZTV7S2324C3[];
extern Class_Descriptor cd_S2324C10;
extern VTBL_ENTRY _ZTI8S2324C10[];
extern  VTBL_ENTRY _ZTV8S2324C10[];
extern Class_Descriptor cd_S2324C9;
extern VTBL_ENTRY _ZTI7S2324C9[];
extern  VTBL_ENTRY _ZTV7S2324C9[];
extern Class_Descriptor cd_S2324C8;
extern VTBL_ENTRY _ZTI7S2324C8[];
extern  VTBL_ENTRY _ZTV7S2324C8[];
static Base_Class bases_S2324C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2324C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2324C7,    ABISELECT(40,28), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2324C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2324C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2324C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2324C8,    ABISELECT(64,44), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2324C2[];
extern void _ZN7S2324C2D1Ev();
extern void _ZN7S2324C2D0Ev();
extern void _ZN7S2324C42v5Ev();
extern void _ZN7S2324C42v6Ev();
extern void _ZN7S2324C42v7Ev();
extern void _ZN7S2324C33v11Ev();
extern void _ZN7S2324C33v12Ev();
extern void _ZN7S2324C33v13Ev();
extern void _ZN7S2324C33v14Ev();
extern void _ZN7S2324C33v15Ev();
extern void _ZN7S2324C33v16Ev();
extern void _ZN7S2324C33v17Ev();
extern void _ZN7S2324C33v18Ev();
extern void _ZN7S2324C33v19Ev();
extern void _ZN7S2324C33v20Ev();
extern void _ZN7S2324C23v31Ev();
extern void _ZN7S2324C23v32Ev();
extern void _ZN7S2324C23v33Ev();
extern void _ZN7S2324C23v34Ev();
extern void _ZN7S2324C23v35Ev();
extern void _ZN7S2324C23v36Ev();
extern void ABISELECT(_ZThn40_N7S2324C2D1Ev,_ZThn28_N7S2324C2D1Ev)();
extern void ABISELECT(_ZThn40_N7S2324C2D0Ev,_ZThn28_N7S2324C2D0Ev)();
extern void _ZN7S2324C72v8Ev();
extern void _ZN7S2324C72v9Ev();
extern void _ZN7S2324C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2324C2D1Ev,_ZThn44_N7S2324C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S2324C2D0Ev,_ZThn44_N7S2324C2D0Ev)();
extern void _ZN8S2324C103v21Ev();
extern void _ZN8S2324C103v22Ev();
extern void _ZN8S2324C103v23Ev();
extern void _ZN7S2324C93v24Ev();
extern void _ZN7S2324C93v25Ev();
extern void _ZN7S2324C93v26Ev();
extern void _ZN7S2324C83v27Ev();
extern void _ZN7S2324C83v28Ev();
extern void _ZN7S2324C83v29Ev();
extern void _ZN7S2324C83v30Ev();
static  VTBL_ENTRY vtc_S2324C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2324C2[0]),
  (VTBL_ENTRY)&_ZN7S2324C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2324C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v36Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2324C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2324C2D1Ev,_ZThn28_N7S2324C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2324C2D0Ev,_ZThn28_N7S2324C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2324C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2324C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2324C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2324C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2324C2D1Ev,_ZThn44_N7S2324C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2324C2D0Ev,_ZThn44_N7S2324C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2324C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2324C2[];
extern  VTBL_ENTRY _ZTV7S2324C2[];
Class_Descriptor cd_S2324C2 = {  "S2324C2", // class name
  bases_S2324C2, 6,
  &(vtc_S2324C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,112), // object size
  NSPAIRA(_ZTI7S2324C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2324C2),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2324C1  : S2324C2 {
  ::S2331C19 s2324c1f0;
  ::S2348C20_nt s2324c1f1;
  int s2324c1f2[2];
  ::S9125C15 s2324c1f3;
  int s2324c1f4;
  void *s2324c1f5[2];
  virtual  ~S2324C1(); // _ZN7S2324C1D1Ev
  virtual void  v1(); // _ZN7S2324C12v1Ev
  virtual void  v2(); // _ZN7S2324C12v2Ev
  virtual void  v3(); // _ZN7S2324C12v3Ev
  virtual void  v4(); // _ZN7S2324C12v4Ev
  S2324C1(); // tgen
};
//SIG(1 S2324C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} BC7{ vd v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp Fc Fi} BC8{ BC9{ BC10{ vd v21 v22 v23} vd v24 v25 v26 FC11{ m Fp Fi[2] FC12{ m}} FC13{ m FC14{ Fl[4]}} Fc} vd v27 v28 v29 v30} vd v31 v32 v33 v34 v35 v36 Fi[3] Fc FC15{ BC16{ m Fp Fi FC17{ m} FC6}}} vd v1 v2 v3 v4 FC18{ vd v37 v38 v39 v40 Fp} FC19{ BC20{ vd v42 FC21{ m FC16} Fp[3] Fc} v41 Fp} Fi[2] FC22{ Fi[2] FC23{ Fi[2]}[10] FC24{ Fi[3] Fc[256]}[10]} Fi Fp[2]}


 S2324C1 ::~S2324C1(){ note_dtor("S2324C1", this);}
void  S2324C1 ::v1(){vfunc_called(this, "_ZN7S2324C12v1Ev");}
void  S2324C1 ::v2(){vfunc_called(this, "_ZN7S2324C12v2Ev");}
void  S2324C1 ::v3(){vfunc_called(this, "_ZN7S2324C12v3Ev");}
void  S2324C1 ::v4(){vfunc_called(this, "_ZN7S2324C12v4Ev");}
S2324C1 ::S2324C1(){ note_ctor("S2324C1", this);} // tgen

static void Test_S2324C1()
{
  extern Class_Descriptor cd_S2324C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(382,737)];
    init_test(&cd_S2324C1, buf);
    S2324C1 *dp, &lv = *(dp=new (buf) S2324C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3048,2944), "sizeof(S2324C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2324C1)");
    check_base_class_offset(lv, (S2324C4*)(S2324C3*)(S2324C2*), 0, "S2324C1");
    check_base_class_offset(lv, (S2324C7*)(S2324C3*)(S2324C2*), ABISELECT(40,28), "S2324C1");
    check_base_class_offset(lv, (S2324C3*)(S2324C2*), 0, "S2324C1");
    check_base_class_offset(lv, (S2324C10*)(S2324C9*)(S2324C8*)(S2324C2*), ABISELECT(64,44), "S2324C1");
    check_base_class_offset(lv, (S2324C9*)(S2324C8*)(S2324C2*), ABISELECT(64,44), "S2324C1");
    check_base_class_offset(lv, (S2324C8*)(S2324C2*), ABISELECT(64,44), "S2324C1");
    check_base_class_offset(lv, (S2324C2*), 0, "S2324C1");
    check_field_offset(lv, s2324c1f0, ABISELECT(168,112), "S2324C1.s2324c1f0");
    check_field_offset(lv, s2324c1f1, ABISELECT(184,120), "S2324C1.s2324c1f1");
    check_field_offset(lv, s2324c1f2, ABISELECT(248,156), "S2324C1.s2324c1f2");
    check_field_offset(lv, s2324c1f3, ABISELECT(256,164), "S2324C1.s2324c1f3");
    check_field_offset(lv, s2324c1f4, ABISELECT(3024,2932), "S2324C1.s2324c1f4");
    check_field_offset(lv, s2324c1f5, ABISELECT(3032,2936), "S2324C1.s2324c1f5");
    test_class_info(&lv, &cd_S2324C1);
    dp->~S2324C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2324C1(Test_S2324C1, "S2324C1", ABISELECT(3048,2944));

#else // __cplusplus

extern void _ZN7S2324C1C1Ev();
extern void _ZN7S2324C1D1Ev();
Name_Map name_map_S2324C1[] = {
  NSPAIR(_ZN7S2324C1C1Ev),
  NSPAIR(_ZN7S2324C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2324C4;
extern VTBL_ENTRY _ZTI7S2324C4[];
extern  VTBL_ENTRY _ZTV7S2324C4[];
extern Class_Descriptor cd_S2324C7;
extern VTBL_ENTRY _ZTI7S2324C7[];
extern  VTBL_ENTRY _ZTV7S2324C7[];
extern Class_Descriptor cd_S2324C3;
extern VTBL_ENTRY _ZTI7S2324C3[];
extern  VTBL_ENTRY _ZTV7S2324C3[];
extern Class_Descriptor cd_S2324C10;
extern VTBL_ENTRY _ZTI8S2324C10[];
extern  VTBL_ENTRY _ZTV8S2324C10[];
extern Class_Descriptor cd_S2324C9;
extern VTBL_ENTRY _ZTI7S2324C9[];
extern  VTBL_ENTRY _ZTV7S2324C9[];
extern Class_Descriptor cd_S2324C8;
extern VTBL_ENTRY _ZTI7S2324C8[];
extern  VTBL_ENTRY _ZTV7S2324C8[];
extern Class_Descriptor cd_S2324C2;
extern VTBL_ENTRY _ZTI7S2324C2[];
extern  VTBL_ENTRY _ZTV7S2324C2[];
static Base_Class bases_S2324C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2324C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2324C7,    ABISELECT(40,28), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2324C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2324C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2324C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2324C8,    ABISELECT(64,44), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2324C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2324C1[];
extern void _ZN7S2324C1D1Ev();
extern void _ZN7S2324C1D0Ev();
extern void _ZN7S2324C42v5Ev();
extern void _ZN7S2324C42v6Ev();
extern void _ZN7S2324C42v7Ev();
extern void _ZN7S2324C33v11Ev();
extern void _ZN7S2324C33v12Ev();
extern void _ZN7S2324C33v13Ev();
extern void _ZN7S2324C33v14Ev();
extern void _ZN7S2324C33v15Ev();
extern void _ZN7S2324C33v16Ev();
extern void _ZN7S2324C33v17Ev();
extern void _ZN7S2324C33v18Ev();
extern void _ZN7S2324C33v19Ev();
extern void _ZN7S2324C33v20Ev();
extern void _ZN7S2324C23v31Ev();
extern void _ZN7S2324C23v32Ev();
extern void _ZN7S2324C23v33Ev();
extern void _ZN7S2324C23v34Ev();
extern void _ZN7S2324C23v35Ev();
extern void _ZN7S2324C23v36Ev();
extern void _ZN7S2324C12v1Ev();
extern void _ZN7S2324C12v2Ev();
extern void _ZN7S2324C12v3Ev();
extern void _ZN7S2324C12v4Ev();
extern void ABISELECT(_ZThn40_N7S2324C1D1Ev,_ZThn28_N7S2324C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S2324C1D0Ev,_ZThn28_N7S2324C1D0Ev)();
extern void _ZN7S2324C72v8Ev();
extern void _ZN7S2324C72v9Ev();
extern void _ZN7S2324C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2324C1D1Ev,_ZThn44_N7S2324C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S2324C1D0Ev,_ZThn44_N7S2324C1D0Ev)();
extern void _ZN8S2324C103v21Ev();
extern void _ZN8S2324C103v22Ev();
extern void _ZN8S2324C103v23Ev();
extern void _ZN7S2324C93v24Ev();
extern void _ZN7S2324C93v25Ev();
extern void _ZN7S2324C93v26Ev();
extern void _ZN7S2324C83v27Ev();
extern void _ZN7S2324C83v28Ev();
extern void _ZN7S2324C83v29Ev();
extern void _ZN7S2324C83v30Ev();
static  VTBL_ENTRY vtc_S2324C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2324C1[0]),
  (VTBL_ENTRY)&_ZN7S2324C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2324C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2324C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2324C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2324C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2324C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2324C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2324C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2324C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2324C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2324C1D1Ev,_ZThn28_N7S2324C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2324C1D0Ev,_ZThn28_N7S2324C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2324C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2324C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2324C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2324C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2324C1D1Ev,_ZThn44_N7S2324C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2324C1D0Ev,_ZThn44_N7S2324C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2324C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2324C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2324C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2324C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2324C1[];
extern  VTBL_ENTRY _ZTV7S2324C1[];
Class_Descriptor cd_S2324C1 = {  "S2324C1", // class name
  bases_S2324C1, 7,
  &(vtc_S2324C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(3048,2944), // object size
  NSPAIRA(_ZTI7S2324C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2324C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2325C4  {
  ::S10183C15_nt s2325c4f0;
  int s2325c4f1[2];
  char s2325c4f2;
  virtual  ~S2325C4(); // _ZN7S2325C4D1Ev
  virtual void  v5(); // _ZN7S2325C42v5Ev
  virtual void  v6(); // _ZN7S2325C42v6Ev
  virtual void  v7(); // _ZN7S2325C42v7Ev
  S2325C4(); // tgen
};
//SIG(-1 S2325C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2325C4 ::~S2325C4(){ note_dtor("S2325C4", this);}
void  S2325C4 ::v5(){vfunc_called(this, "_ZN7S2325C42v5Ev");}
void  S2325C4 ::v6(){vfunc_called(this, "_ZN7S2325C42v6Ev");}
void  S2325C4 ::v7(){vfunc_called(this, "_ZN7S2325C42v7Ev");}
S2325C4 ::S2325C4(){ note_ctor("S2325C4", this);} // tgen

static void Test_S2325C4()
{
  extern Class_Descriptor cd_S2325C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2325C4, buf);
    S2325C4 *dp, &lv = *(dp=new (buf) S2325C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2325C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2325C4)");
    check_field_offset(lv, s2325c4f0, ABISELECT(8,4), "S2325C4.s2325c4f0");
    check_field_offset(lv, s2325c4f1, ABISELECT(24,16), "S2325C4.s2325c4f1");
    check_field_offset(lv, s2325c4f2, ABISELECT(32,24), "S2325C4.s2325c4f2");
    test_class_info(&lv, &cd_S2325C4);
    dp->~S2325C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2325C4(Test_S2325C4, "S2325C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2325C4C1Ev();
extern void _ZN7S2325C4D1Ev();
Name_Map name_map_S2325C4[] = {
  NSPAIR(_ZN7S2325C4C1Ev),
  NSPAIR(_ZN7S2325C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2325C4[];
extern void _ZN7S2325C4D1Ev();
extern void _ZN7S2325C4D0Ev();
extern void _ZN7S2325C42v5Ev();
extern void _ZN7S2325C42v6Ev();
extern void _ZN7S2325C42v7Ev();
static  VTBL_ENTRY vtc_S2325C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2325C4[0]),
  (VTBL_ENTRY)&_ZN7S2325C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2325C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v7Ev,
};
extern VTBL_ENTRY _ZTI7S2325C4[];
extern  VTBL_ENTRY _ZTV7S2325C4[];
Class_Descriptor cd_S2325C4 = {  "S2325C4", // class name
  0,0,//no base classes
  &(vtc_S2325C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2325C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2325C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2325C7  {
  virtual  ~S2325C7(); // _ZN7S2325C7D1Ev
  virtual void  v8(); // _ZN7S2325C72v8Ev
  virtual void  v9(); // _ZN7S2325C72v9Ev
  virtual void  v10(); // _ZN7S2325C73v10Ev
  S2325C7(); // tgen
};
//SIG(-1 S2325C7) C1{ vd v1 v2 v3}


 S2325C7 ::~S2325C7(){ note_dtor("S2325C7", this);}
void  S2325C7 ::v8(){vfunc_called(this, "_ZN7S2325C72v8Ev");}
void  S2325C7 ::v9(){vfunc_called(this, "_ZN7S2325C72v9Ev");}
void  S2325C7 ::v10(){vfunc_called(this, "_ZN7S2325C73v10Ev");}
S2325C7 ::S2325C7(){ note_ctor("S2325C7", this);} // tgen

static void Test_S2325C7()
{
  extern Class_Descriptor cd_S2325C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2325C7, buf);
    S2325C7 *dp, &lv = *(dp=new (buf) S2325C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2325C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2325C7)");
    test_class_info(&lv, &cd_S2325C7);
    dp->~S2325C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2325C7(Test_S2325C7, "S2325C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2325C7C1Ev();
extern void _ZN7S2325C7D1Ev();
Name_Map name_map_S2325C7[] = {
  NSPAIR(_ZN7S2325C7C1Ev),
  NSPAIR(_ZN7S2325C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2325C7[];
extern void _ZN7S2325C7D1Ev();
extern void _ZN7S2325C7D0Ev();
extern void _ZN7S2325C72v8Ev();
extern void _ZN7S2325C72v9Ev();
extern void _ZN7S2325C73v10Ev();
static  VTBL_ENTRY vtc_S2325C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2325C7[0]),
  (VTBL_ENTRY)&_ZN7S2325C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2325C7D0Ev,
  (VTBL_ENTRY)&_ZN7S2325C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2325C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2325C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2325C7[];
extern  VTBL_ENTRY _ZTV7S2325C7[];
Class_Descriptor cd_S2325C7 = {  "S2325C7", // class name
  0,0,//no base classes
  &(vtc_S2325C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2325C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2325C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2325C3  : S2325C4 , S2325C7 {
  void *s2325c3f0;
  char s2325c3f1;
  int s2325c3f2;
  virtual  ~S2325C3(); // _ZN7S2325C3D1Ev
  virtual void  v11(); // _ZN7S2325C33v11Ev
  virtual void  v12(); // _ZN7S2325C33v12Ev
  virtual void  v13(); // _ZN7S2325C33v13Ev
  virtual void  v14(); // _ZN7S2325C33v14Ev
  virtual void  v15(); // _ZN7S2325C33v15Ev
  virtual void  v16(); // _ZN7S2325C33v16Ev
  virtual void  v17(); // _ZN7S2325C33v17Ev
  virtual void  v18(); // _ZN7S2325C33v18Ev
  virtual void  v19(); // _ZN7S2325C33v19Ev
  virtual void  v20(); // _ZN7S2325C33v20Ev
  S2325C3(); // tgen
};
//SIG(-1 S2325C3) C1{ BC2{ vd v11 v12 v13 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ vd v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi}


 S2325C3 ::~S2325C3(){ note_dtor("S2325C3", this);}
void  S2325C3 ::v11(){vfunc_called(this, "_ZN7S2325C33v11Ev");}
void  S2325C3 ::v12(){vfunc_called(this, "_ZN7S2325C33v12Ev");}
void  S2325C3 ::v13(){vfunc_called(this, "_ZN7S2325C33v13Ev");}
void  S2325C3 ::v14(){vfunc_called(this, "_ZN7S2325C33v14Ev");}
void  S2325C3 ::v15(){vfunc_called(this, "_ZN7S2325C33v15Ev");}
void  S2325C3 ::v16(){vfunc_called(this, "_ZN7S2325C33v16Ev");}
void  S2325C3 ::v17(){vfunc_called(this, "_ZN7S2325C33v17Ev");}
void  S2325C3 ::v18(){vfunc_called(this, "_ZN7S2325C33v18Ev");}
void  S2325C3 ::v19(){vfunc_called(this, "_ZN7S2325C33v19Ev");}
void  S2325C3 ::v20(){vfunc_called(this, "_ZN7S2325C33v20Ev");}
S2325C3 ::S2325C3(){ note_ctor("S2325C3", this);} // tgen

static void Test_S2325C3()
{
  extern Class_Descriptor cd_S2325C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S2325C3, buf);
    S2325C3 *dp, &lv = *(dp=new (buf) S2325C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2325C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2325C3)");
    check_base_class_offset(lv, (S2325C4*), 0, "S2325C3");
    check_base_class_offset(lv, (S2325C7*), ABISELECT(40,28), "S2325C3");
    check_field_offset(lv, s2325c3f0, ABISELECT(48,32), "S2325C3.s2325c3f0");
    check_field_offset(lv, s2325c3f1, ABISELECT(56,36), "S2325C3.s2325c3f1");
    check_field_offset(lv, s2325c3f2, ABISELECT(60,40), "S2325C3.s2325c3f2");
    test_class_info(&lv, &cd_S2325C3);
    dp->~S2325C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2325C3(Test_S2325C3, "S2325C3", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN7S2325C3C1Ev();
extern void _ZN7S2325C3D1Ev();
Name_Map name_map_S2325C3[] = {
  NSPAIR(_ZN7S2325C3C1Ev),
  NSPAIR(_ZN7S2325C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2325C4;
extern VTBL_ENTRY _ZTI7S2325C4[];
extern  VTBL_ENTRY _ZTV7S2325C4[];
extern Class_Descriptor cd_S2325C7;
extern VTBL_ENTRY _ZTI7S2325C7[];
extern  VTBL_ENTRY _ZTV7S2325C7[];
static Base_Class bases_S2325C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2325C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2325C7,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2325C3[];
extern void _ZN7S2325C3D1Ev();
extern void _ZN7S2325C3D0Ev();
extern void _ZN7S2325C42v5Ev();
extern void _ZN7S2325C42v6Ev();
extern void _ZN7S2325C42v7Ev();
extern void _ZN7S2325C33v11Ev();
extern void _ZN7S2325C33v12Ev();
extern void _ZN7S2325C33v13Ev();
extern void _ZN7S2325C33v14Ev();
extern void _ZN7S2325C33v15Ev();
extern void _ZN7S2325C33v16Ev();
extern void _ZN7S2325C33v17Ev();
extern void _ZN7S2325C33v18Ev();
extern void _ZN7S2325C33v19Ev();
extern void _ZN7S2325C33v20Ev();
extern void ABISELECT(_ZThn40_N7S2325C3D1Ev,_ZThn28_N7S2325C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S2325C3D0Ev,_ZThn28_N7S2325C3D0Ev)();
extern void _ZN7S2325C72v8Ev();
extern void _ZN7S2325C72v9Ev();
extern void _ZN7S2325C73v10Ev();
static  VTBL_ENTRY vtc_S2325C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2325C3[0]),
  (VTBL_ENTRY)&_ZN7S2325C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2325C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v20Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2325C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2325C3D1Ev,_ZThn28_N7S2325C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2325C3D0Ev,_ZThn28_N7S2325C3D0Ev),
  (VTBL_ENTRY)&_ZN7S2325C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2325C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2325C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2325C3[];
extern  VTBL_ENTRY _ZTV7S2325C3[];
Class_Descriptor cd_S2325C3 = {  "S2325C3", // class name
  bases_S2325C3, 2,
  &(vtc_S2325C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI7S2325C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2325C3),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2325C10  {
  virtual  ~S2325C10(); // _ZN8S2325C10D1Ev
  virtual void  v21(); // _ZN8S2325C103v21Ev
  virtual void  v22(); // _ZN8S2325C103v22Ev
  virtual void  v23(); // _ZN8S2325C103v23Ev
  S2325C10(); // tgen
};
//SIG(-1 S2325C10) C1{ vd v1 v2 v3}


 S2325C10 ::~S2325C10(){ note_dtor("S2325C10", this);}
void  S2325C10 ::v21(){vfunc_called(this, "_ZN8S2325C103v21Ev");}
void  S2325C10 ::v22(){vfunc_called(this, "_ZN8S2325C103v22Ev");}
void  S2325C10 ::v23(){vfunc_called(this, "_ZN8S2325C103v23Ev");}
S2325C10 ::S2325C10(){ note_ctor("S2325C10", this);} // tgen

static void Test_S2325C10()
{
  extern Class_Descriptor cd_S2325C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2325C10, buf);
    S2325C10 *dp, &lv = *(dp=new (buf) S2325C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2325C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2325C10)");
    test_class_info(&lv, &cd_S2325C10);
    dp->~S2325C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2325C10(Test_S2325C10, "S2325C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2325C10C1Ev();
extern void _ZN8S2325C10D1Ev();
Name_Map name_map_S2325C10[] = {
  NSPAIR(_ZN8S2325C10C1Ev),
  NSPAIR(_ZN8S2325C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2325C10[];
extern void _ZN8S2325C10D1Ev();
extern void _ZN8S2325C10D0Ev();
extern void _ZN8S2325C103v21Ev();
extern void _ZN8S2325C103v22Ev();
extern void _ZN8S2325C103v23Ev();
static  VTBL_ENTRY vtc_S2325C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2325C10[0]),
  (VTBL_ENTRY)&_ZN8S2325C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2325C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v23Ev,
};
extern VTBL_ENTRY _ZTI8S2325C10[];
extern  VTBL_ENTRY _ZTV8S2325C10[];
Class_Descriptor cd_S2325C10 = {  "S2325C10", // class name
  0,0,//no base classes
  &(vtc_S2325C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2325C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2325C10),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2325C9  : S2325C10 {
  ::S10183C20 s2325c9f0;
  ::S10184C7_nt s2325c9f1;
  char s2325c9f2;
  virtual  ~S2325C9(); // _ZN7S2325C9D1Ev
  virtual void  v24(); // _ZN7S2325C93v24Ev
  virtual void  v25(); // _ZN7S2325C93v25Ev
  virtual void  v26(); // _ZN7S2325C93v26Ev
  S2325C9(); // tgen
};
//SIG(-1 S2325C9) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ FL[4]}} Fc}


 S2325C9 ::~S2325C9(){ note_dtor("S2325C9", this);}
void  S2325C9 ::v24(){vfunc_called(this, "_ZN7S2325C93v24Ev");}
void  S2325C9 ::v25(){vfunc_called(this, "_ZN7S2325C93v25Ev");}
void  S2325C9 ::v26(){vfunc_called(this, "_ZN7S2325C93v26Ev");}
S2325C9 ::S2325C9(){ note_ctor("S2325C9", this);} // tgen

static void Test_S2325C9()
{
  extern Class_Descriptor cd_S2325C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2325C9, buf);
    S2325C9 *dp, &lv = *(dp=new (buf) S2325C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2325C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2325C9)");
    check_base_class_offset(lv, (S2325C10*), 0, "S2325C9");
    check_field_offset(lv, s2325c9f0, ABISELECT(8,4), "S2325C9.s2325c9f0");
    check_field_offset(lv, s2325c9f1, ABISELECT(32,20), "S2325C9.s2325c9f1");
    check_field_offset(lv, s2325c9f2, ABISELECT(64,52), "S2325C9.s2325c9f2");
    test_class_info(&lv, &cd_S2325C9);
    dp->~S2325C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2325C9(Test_S2325C9, "S2325C9", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2325C9C1Ev();
extern void _ZN7S2325C9D1Ev();
Name_Map name_map_S2325C9[] = {
  NSPAIR(_ZN7S2325C9C1Ev),
  NSPAIR(_ZN7S2325C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2325C10;
extern VTBL_ENTRY _ZTI8S2325C10[];
extern  VTBL_ENTRY _ZTV8S2325C10[];
static Base_Class bases_S2325C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2325C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2325C9[];
extern void _ZN7S2325C9D1Ev();
extern void _ZN7S2325C9D0Ev();
extern void _ZN8S2325C103v21Ev();
extern void _ZN8S2325C103v22Ev();
extern void _ZN8S2325C103v23Ev();
extern void _ZN7S2325C93v24Ev();
extern void _ZN7S2325C93v25Ev();
extern void _ZN7S2325C93v26Ev();
static  VTBL_ENTRY vtc_S2325C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2325C9[0]),
  (VTBL_ENTRY)&_ZN7S2325C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2325C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v26Ev,
};
extern VTBL_ENTRY _ZTI7S2325C9[];
extern  VTBL_ENTRY _ZTV7S2325C9[];
Class_Descriptor cd_S2325C9 = {  "S2325C9", // class name
  bases_S2325C9, 1,
  &(vtc_S2325C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2325C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2325C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2325C8  : S2325C9 {
  virtual  ~S2325C8(); // _ZN7S2325C8D1Ev
  virtual void  v27(); // _ZN7S2325C83v27Ev
  virtual void  v28(); // _ZN7S2325C83v28Ev
  virtual void  v29(); // _ZN7S2325C83v29Ev
  virtual void  v30(); // _ZN7S2325C83v30Ev
  S2325C8(); // tgen
};
//SIG(-1 S2325C8) C1{ BC2{ BC3{ vd v5 v6 v7} vd v8 v9 v10 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc} vd v1 v2 v3 v4}


 S2325C8 ::~S2325C8(){ note_dtor("S2325C8", this);}
void  S2325C8 ::v27(){vfunc_called(this, "_ZN7S2325C83v27Ev");}
void  S2325C8 ::v28(){vfunc_called(this, "_ZN7S2325C83v28Ev");}
void  S2325C8 ::v29(){vfunc_called(this, "_ZN7S2325C83v29Ev");}
void  S2325C8 ::v30(){vfunc_called(this, "_ZN7S2325C83v30Ev");}
S2325C8 ::S2325C8(){ note_ctor("S2325C8", this);} // tgen

static void Test_S2325C8()
{
  extern Class_Descriptor cd_S2325C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2325C8, buf);
    S2325C8 *dp, &lv = *(dp=new (buf) S2325C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2325C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2325C8)");
    check_base_class_offset(lv, (S2325C10*)(S2325C9*), 0, "S2325C8");
    check_base_class_offset(lv, (S2325C9*), 0, "S2325C8");
    test_class_info(&lv, &cd_S2325C8);
    dp->~S2325C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2325C8(Test_S2325C8, "S2325C8", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2325C8C1Ev();
extern void _ZN7S2325C8D1Ev();
Name_Map name_map_S2325C8[] = {
  NSPAIR(_ZN7S2325C8C1Ev),
  NSPAIR(_ZN7S2325C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2325C10;
extern VTBL_ENTRY _ZTI8S2325C10[];
extern  VTBL_ENTRY _ZTV8S2325C10[];
extern Class_Descriptor cd_S2325C9;
extern VTBL_ENTRY _ZTI7S2325C9[];
extern  VTBL_ENTRY _ZTV7S2325C9[];
static Base_Class bases_S2325C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2325C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2325C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2325C8[];
extern void _ZN7S2325C8D1Ev();
extern void _ZN7S2325C8D0Ev();
extern void _ZN8S2325C103v21Ev();
extern void _ZN8S2325C103v22Ev();
extern void _ZN8S2325C103v23Ev();
extern void _ZN7S2325C93v24Ev();
extern void _ZN7S2325C93v25Ev();
extern void _ZN7S2325C93v26Ev();
extern void _ZN7S2325C83v27Ev();
extern void _ZN7S2325C83v28Ev();
extern void _ZN7S2325C83v29Ev();
extern void _ZN7S2325C83v30Ev();
static  VTBL_ENTRY vtc_S2325C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2325C8[0]),
  (VTBL_ENTRY)&_ZN7S2325C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2325C8D0Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2325C8[];
extern  VTBL_ENTRY _ZTV7S2325C8[];
Class_Descriptor cd_S2325C8 = {  "S2325C8", // class name
  bases_S2325C8, 2,
  &(vtc_S2325C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2325C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2325C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2325C2  : S2325C3 , S2325C8 {
  int s2325c2f0[3];
  char s2325c2f1;
  ::S10183C9_nt s2325c2f2;
  virtual  ~S2325C2(); // _ZN7S2325C2D1Ev
  virtual void  v31(); // _ZN7S2325C23v31Ev
  virtual void  v32(); // _ZN7S2325C23v32Ev
  virtual void  v33(); // _ZN7S2325C23v33Ev
  virtual void  v34(); // _ZN7S2325C23v34Ev
  virtual void  v35(); // _ZN7S2325C23v35Ev
  virtual void  v36(); // _ZN7S2325C23v36Ev
  S2325C2(); // tgen
};
//SIG(-1 S2325C2) C1{ BC2{ BC3{ vd v7 v8 v9 FC4{ m Fp Fi FC5{ m}} Fi[2] Fc} BC6{ vd v10 v11 v12} vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp Fc Fi} BC7{ BC8{ BC9{ vd v23 v24 v25} vd v26 v27 v28 FC10{ m Fp Fi[2] FC11{ m}} FC12{ m FC13{ FL[4]}} Fc} vd v29 v30 v31 v32} vd v1 v2 v3 v4 v5 v6 Fi[3] Fc FC14{ BC15{ m Fp Fi FC16{ m} FC5}}}


 S2325C2 ::~S2325C2(){ note_dtor("S2325C2", this);}
void  S2325C2 ::v31(){vfunc_called(this, "_ZN7S2325C23v31Ev");}
void  S2325C2 ::v32(){vfunc_called(this, "_ZN7S2325C23v32Ev");}
void  S2325C2 ::v33(){vfunc_called(this, "_ZN7S2325C23v33Ev");}
void  S2325C2 ::v34(){vfunc_called(this, "_ZN7S2325C23v34Ev");}
void  S2325C2 ::v35(){vfunc_called(this, "_ZN7S2325C23v35Ev");}
void  S2325C2 ::v36(){vfunc_called(this, "_ZN7S2325C23v36Ev");}
S2325C2 ::S2325C2(){ note_ctor("S2325C2", this);} // tgen

static void Test_S2325C2()
{
  extern Class_Descriptor cd_S2325C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(22,33)];
    init_test(&cd_S2325C2, buf);
    S2325C2 *dp, &lv = *(dp=new (buf) S2325C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(168,128), "sizeof(S2325C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2325C2)");
    check_base_class_offset(lv, (S2325C4*)(S2325C3*), 0, "S2325C2");
    check_base_class_offset(lv, (S2325C7*)(S2325C3*), ABISELECT(40,28), "S2325C2");
    check_base_class_offset(lv, (S2325C3*), 0, "S2325C2");
    check_base_class_offset(lv, (S2325C10*)(S2325C9*)(S2325C8*), ABISELECT(64,44), "S2325C2");
    check_base_class_offset(lv, (S2325C9*)(S2325C8*), ABISELECT(64,44), "S2325C2");
    check_base_class_offset(lv, (S2325C8*), ABISELECT(64,44), "S2325C2");
    check_field_offset(lv, s2325c2f0, ABISELECT(132,100), "S2325C2.s2325c2f0");
    check_field_offset(lv, s2325c2f1, ABISELECT(144,112), "S2325C2.s2325c2f1");
    check_field_offset(lv, s2325c2f2, ABISELECT(152,116), "S2325C2.s2325c2f2");
    test_class_info(&lv, &cd_S2325C2);
    dp->~S2325C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2325C2(Test_S2325C2, "S2325C2", ABISELECT(168,128));

#else // __cplusplus

extern void _ZN7S2325C2C1Ev();
extern void _ZN7S2325C2D1Ev();
Name_Map name_map_S2325C2[] = {
  NSPAIR(_ZN7S2325C2C1Ev),
  NSPAIR(_ZN7S2325C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2325C4;
extern VTBL_ENTRY _ZTI7S2325C4[];
extern  VTBL_ENTRY _ZTV7S2325C4[];
extern Class_Descriptor cd_S2325C7;
extern VTBL_ENTRY _ZTI7S2325C7[];
extern  VTBL_ENTRY _ZTV7S2325C7[];
extern Class_Descriptor cd_S2325C3;
extern VTBL_ENTRY _ZTI7S2325C3[];
extern  VTBL_ENTRY _ZTV7S2325C3[];
extern Class_Descriptor cd_S2325C10;
extern VTBL_ENTRY _ZTI8S2325C10[];
extern  VTBL_ENTRY _ZTV8S2325C10[];
extern Class_Descriptor cd_S2325C9;
extern VTBL_ENTRY _ZTI7S2325C9[];
extern  VTBL_ENTRY _ZTV7S2325C9[];
extern Class_Descriptor cd_S2325C8;
extern VTBL_ENTRY _ZTI7S2325C8[];
extern  VTBL_ENTRY _ZTV7S2325C8[];
static Base_Class bases_S2325C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2325C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2325C7,    ABISELECT(40,28), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2325C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2325C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2325C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2325C8,    ABISELECT(64,44), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2325C2[];
extern void _ZN7S2325C2D1Ev();
extern void _ZN7S2325C2D0Ev();
extern void _ZN7S2325C42v5Ev();
extern void _ZN7S2325C42v6Ev();
extern void _ZN7S2325C42v7Ev();
extern void _ZN7S2325C33v11Ev();
extern void _ZN7S2325C33v12Ev();
extern void _ZN7S2325C33v13Ev();
extern void _ZN7S2325C33v14Ev();
extern void _ZN7S2325C33v15Ev();
extern void _ZN7S2325C33v16Ev();
extern void _ZN7S2325C33v17Ev();
extern void _ZN7S2325C33v18Ev();
extern void _ZN7S2325C33v19Ev();
extern void _ZN7S2325C33v20Ev();
extern void _ZN7S2325C23v31Ev();
extern void _ZN7S2325C23v32Ev();
extern void _ZN7S2325C23v33Ev();
extern void _ZN7S2325C23v34Ev();
extern void _ZN7S2325C23v35Ev();
extern void _ZN7S2325C23v36Ev();
extern void ABISELECT(_ZThn40_N7S2325C2D1Ev,_ZThn28_N7S2325C2D1Ev)();
extern void ABISELECT(_ZThn40_N7S2325C2D0Ev,_ZThn28_N7S2325C2D0Ev)();
extern void _ZN7S2325C72v8Ev();
extern void _ZN7S2325C72v9Ev();
extern void _ZN7S2325C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2325C2D1Ev,_ZThn44_N7S2325C2D1Ev)();
extern void ABISELECT(_ZThn64_N7S2325C2D0Ev,_ZThn44_N7S2325C2D0Ev)();
extern void _ZN8S2325C103v21Ev();
extern void _ZN8S2325C103v22Ev();
extern void _ZN8S2325C103v23Ev();
extern void _ZN7S2325C93v24Ev();
extern void _ZN7S2325C93v25Ev();
extern void _ZN7S2325C93v26Ev();
extern void _ZN7S2325C83v27Ev();
extern void _ZN7S2325C83v28Ev();
extern void _ZN7S2325C83v29Ev();
extern void _ZN7S2325C83v30Ev();
static  VTBL_ENTRY vtc_S2325C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2325C2[0]),
  (VTBL_ENTRY)&_ZN7S2325C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2325C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v36Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2325C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2325C2D1Ev,_ZThn28_N7S2325C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2325C2D0Ev,_ZThn28_N7S2325C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2325C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2325C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2325C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2325C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2325C2D1Ev,_ZThn44_N7S2325C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2325C2D0Ev,_ZThn44_N7S2325C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2325C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2325C2[];
extern  VTBL_ENTRY _ZTV7S2325C2[];
Class_Descriptor cd_S2325C2 = {  "S2325C2", // class name
  bases_S2325C2, 6,
  &(vtc_S2325C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(168,128), // object size
  NSPAIRA(_ZTI7S2325C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2325C2),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2325C1  : S2325C2 {
  ::S2331C19 s2325c1f0;
  ::S2348C20_nt s2325c1f1;
  int s2325c1f2[2];
  ::S9125C15 s2325c1f3;
  int s2325c1f4;
  void *s2325c1f5[2];
  virtual  ~S2325C1(); // _ZN7S2325C1D1Ev
  virtual void  v1(); // _ZN7S2325C12v1Ev
  virtual void  v2(); // _ZN7S2325C12v2Ev
  virtual void  v3(); // _ZN7S2325C12v3Ev
  virtual void  v4(); // _ZN7S2325C12v4Ev
  S2325C1(); // tgen
};
//SIG(1 S2325C1) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 FC5{ m Fp Fi FC6{ m}} Fi[2] Fc} BC7{ vd v8 v9 v10} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp Fc Fi} BC8{ BC9{ BC10{ vd v21 v22 v23} vd v24 v25 v26 FC11{ m Fp Fi[2] FC12{ m}} FC13{ m FC14{ FL[4]}} Fc} vd v27 v28 v29 v30} vd v31 v32 v33 v34 v35 v36 Fi[3] Fc FC15{ BC16{ m Fp Fi FC17{ m} FC6}}} vd v1 v2 v3 v4 FC18{ vd v37 v38 v39 v40 Fp} FC19{ BC20{ vd v42 FC21{ m FC16} Fp[3] Fc} v41 Fp} Fi[2] FC22{ Fi[2] FC23{ Fi[2]}[10] FC24{ Fi[3] Fc[256]}[10]} Fi Fp[2]}


 S2325C1 ::~S2325C1(){ note_dtor("S2325C1", this);}
void  S2325C1 ::v1(){vfunc_called(this, "_ZN7S2325C12v1Ev");}
void  S2325C1 ::v2(){vfunc_called(this, "_ZN7S2325C12v2Ev");}
void  S2325C1 ::v3(){vfunc_called(this, "_ZN7S2325C12v3Ev");}
void  S2325C1 ::v4(){vfunc_called(this, "_ZN7S2325C12v4Ev");}
S2325C1 ::S2325C1(){ note_ctor("S2325C1", this);} // tgen

static void Test_S2325C1()
{
  extern Class_Descriptor cd_S2325C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(382,741)];
    init_test(&cd_S2325C1, buf);
    S2325C1 *dp, &lv = *(dp=new (buf) S2325C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3048,2960), "sizeof(S2325C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2325C1)");
    check_base_class_offset(lv, (S2325C4*)(S2325C3*)(S2325C2*), 0, "S2325C1");
    check_base_class_offset(lv, (S2325C7*)(S2325C3*)(S2325C2*), ABISELECT(40,28), "S2325C1");
    check_base_class_offset(lv, (S2325C3*)(S2325C2*), 0, "S2325C1");
    check_base_class_offset(lv, (S2325C10*)(S2325C9*)(S2325C8*)(S2325C2*), ABISELECT(64,44), "S2325C1");
    check_base_class_offset(lv, (S2325C9*)(S2325C8*)(S2325C2*), ABISELECT(64,44), "S2325C1");
    check_base_class_offset(lv, (S2325C8*)(S2325C2*), ABISELECT(64,44), "S2325C1");
    check_base_class_offset(lv, (S2325C2*), 0, "S2325C1");
    check_field_offset(lv, s2325c1f0, ABISELECT(168,128), "S2325C1.s2325c1f0");
    check_field_offset(lv, s2325c1f1, ABISELECT(184,136), "S2325C1.s2325c1f1");
    check_field_offset(lv, s2325c1f2, ABISELECT(248,172), "S2325C1.s2325c1f2");
    check_field_offset(lv, s2325c1f3, ABISELECT(256,180), "S2325C1.s2325c1f3");
    check_field_offset(lv, s2325c1f4, ABISELECT(3024,2948), "S2325C1.s2325c1f4");
    check_field_offset(lv, s2325c1f5, ABISELECT(3032,2952), "S2325C1.s2325c1f5");
    test_class_info(&lv, &cd_S2325C1);
    dp->~S2325C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2325C1(Test_S2325C1, "S2325C1", ABISELECT(3048,2960));

#else // __cplusplus

extern void _ZN7S2325C1C1Ev();
extern void _ZN7S2325C1D1Ev();
Name_Map name_map_S2325C1[] = {
  NSPAIR(_ZN7S2325C1C1Ev),
  NSPAIR(_ZN7S2325C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2325C4;
extern VTBL_ENTRY _ZTI7S2325C4[];
extern  VTBL_ENTRY _ZTV7S2325C4[];
extern Class_Descriptor cd_S2325C7;
extern VTBL_ENTRY _ZTI7S2325C7[];
extern  VTBL_ENTRY _ZTV7S2325C7[];
extern Class_Descriptor cd_S2325C3;
extern VTBL_ENTRY _ZTI7S2325C3[];
extern  VTBL_ENTRY _ZTV7S2325C3[];
extern Class_Descriptor cd_S2325C10;
extern VTBL_ENTRY _ZTI8S2325C10[];
extern  VTBL_ENTRY _ZTV8S2325C10[];
extern Class_Descriptor cd_S2325C9;
extern VTBL_ENTRY _ZTI7S2325C9[];
extern  VTBL_ENTRY _ZTV7S2325C9[];
extern Class_Descriptor cd_S2325C8;
extern VTBL_ENTRY _ZTI7S2325C8[];
extern  VTBL_ENTRY _ZTV7S2325C8[];
extern Class_Descriptor cd_S2325C2;
extern VTBL_ENTRY _ZTI7S2325C2[];
extern  VTBL_ENTRY _ZTV7S2325C2[];
static Base_Class bases_S2325C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2325C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2325C7,    ABISELECT(40,28), //bcp->offset
    27, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2325C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2325C10,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2325C9,    ABISELECT(64,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S2325C8,    ABISELECT(64,44), //bcp->offset
    34, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2325C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2325C1[];
extern void _ZN7S2325C1D1Ev();
extern void _ZN7S2325C1D0Ev();
extern void _ZN7S2325C42v5Ev();
extern void _ZN7S2325C42v6Ev();
extern void _ZN7S2325C42v7Ev();
extern void _ZN7S2325C33v11Ev();
extern void _ZN7S2325C33v12Ev();
extern void _ZN7S2325C33v13Ev();
extern void _ZN7S2325C33v14Ev();
extern void _ZN7S2325C33v15Ev();
extern void _ZN7S2325C33v16Ev();
extern void _ZN7S2325C33v17Ev();
extern void _ZN7S2325C33v18Ev();
extern void _ZN7S2325C33v19Ev();
extern void _ZN7S2325C33v20Ev();
extern void _ZN7S2325C23v31Ev();
extern void _ZN7S2325C23v32Ev();
extern void _ZN7S2325C23v33Ev();
extern void _ZN7S2325C23v34Ev();
extern void _ZN7S2325C23v35Ev();
extern void _ZN7S2325C23v36Ev();
extern void _ZN7S2325C12v1Ev();
extern void _ZN7S2325C12v2Ev();
extern void _ZN7S2325C12v3Ev();
extern void _ZN7S2325C12v4Ev();
extern void ABISELECT(_ZThn40_N7S2325C1D1Ev,_ZThn28_N7S2325C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S2325C1D0Ev,_ZThn28_N7S2325C1D0Ev)();
extern void _ZN7S2325C72v8Ev();
extern void _ZN7S2325C72v9Ev();
extern void _ZN7S2325C73v10Ev();
extern void ABISELECT(_ZThn64_N7S2325C1D1Ev,_ZThn44_N7S2325C1D1Ev)();
extern void ABISELECT(_ZThn64_N7S2325C1D0Ev,_ZThn44_N7S2325C1D0Ev)();
extern void _ZN8S2325C103v21Ev();
extern void _ZN8S2325C103v22Ev();
extern void _ZN8S2325C103v23Ev();
extern void _ZN7S2325C93v24Ev();
extern void _ZN7S2325C93v25Ev();
extern void _ZN7S2325C93v26Ev();
extern void _ZN7S2325C83v27Ev();
extern void _ZN7S2325C83v28Ev();
extern void _ZN7S2325C83v29Ev();
extern void _ZN7S2325C83v30Ev();
static  VTBL_ENTRY vtc_S2325C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2325C1[0]),
  (VTBL_ENTRY)&_ZN7S2325C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2325C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2325C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2325C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2325C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2325C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2325C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2325C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2325C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2325C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2325C1D1Ev,_ZThn28_N7S2325C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2325C1D0Ev,_ZThn28_N7S2325C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2325C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2325C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2325C73v10Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI7S2325C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2325C1D1Ev,_ZThn44_N7S2325C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N7S2325C1D0Ev,_ZThn44_N7S2325C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2325C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2325C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2325C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2325C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2325C1[];
extern  VTBL_ENTRY _ZTV7S2325C1[];
Class_Descriptor cd_S2325C1 = {  "S2325C1", // class name
  bases_S2325C1, 7,
  &(vtc_S2325C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(3048,2960), // object size
  NSPAIRA(_ZTI7S2325C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2325C1),48, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2351C4  {
  ::S10183C15_nt s2351c4f0;
  int s2351c4f1[2];
  char s2351c4f2;
  virtual  ~S2351C4(); // _ZN7S2351C4D1Ev
  virtual void  v5(); // _ZN7S2351C42v5Ev
  virtual void  v6(); // _ZN7S2351C42v6Ev
  virtual void  v7(); // _ZN7S2351C42v7Ev
  S2351C4(); // tgen
};
//SIG(-1 S2351C4) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S2351C4 ::~S2351C4(){ note_dtor("S2351C4", this);}
void  S2351C4 ::v5(){vfunc_called(this, "_ZN7S2351C42v5Ev");}
void  S2351C4 ::v6(){vfunc_called(this, "_ZN7S2351C42v6Ev");}
void  S2351C4 ::v7(){vfunc_called(this, "_ZN7S2351C42v7Ev");}
S2351C4 ::S2351C4(){ note_ctor("S2351C4", this);} // tgen

static void Test_S2351C4()
{
  extern Class_Descriptor cd_S2351C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S2351C4, buf);
    S2351C4 *dp, &lv = *(dp=new (buf) S2351C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S2351C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2351C4)");
    check_field_offset(lv, s2351c4f0, ABISELECT(8,4), "S2351C4.s2351c4f0");
    check_field_offset(lv, s2351c4f1, ABISELECT(24,16), "S2351C4.s2351c4f1");
    check_field_offset(lv, s2351c4f2, ABISELECT(32,24), "S2351C4.s2351c4f2");
    test_class_info(&lv, &cd_S2351C4);
    dp->~S2351C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2351C4(Test_S2351C4, "S2351C4", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S2351C4C1Ev();
extern void _ZN7S2351C4D1Ev();
Name_Map name_map_S2351C4[] = {
  NSPAIR(_ZN7S2351C4C1Ev),
  NSPAIR(_ZN7S2351C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2351C4[];
extern void _ZN7S2351C4D1Ev();
extern void _ZN7S2351C4D0Ev();
extern void _ZN7S2351C42v5Ev();
extern void _ZN7S2351C42v6Ev();
extern void _ZN7S2351C42v7Ev();
static  VTBL_ENTRY vtc_S2351C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2351C4[0]),
  (VTBL_ENTRY)&_ZN7S2351C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2351C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2351C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2351C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2351C42v7Ev,
};
extern VTBL_ENTRY _ZTI7S2351C4[];
extern  VTBL_ENTRY _ZTV7S2351C4[];
Class_Descriptor cd_S2351C4 = {  "S2351C4", // class name
  0,0,//no base classes
  &(vtc_S2351C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S2351C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2351C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2351C7  {
  virtual  ~S2351C7(); // _ZN7S2351C7D1Ev
  virtual void  v8(); // _ZN7S2351C72v8Ev
  virtual void  v9(); // _ZN7S2351C72v9Ev
  virtual void  v10(); // _ZN7S2351C73v10Ev
  S2351C7(); // tgen
};
//SIG(-1 S2351C7) C1{ vd v1 v2 v3}


 S2351C7 ::~S2351C7(){ note_dtor("S2351C7", this);}
void  S2351C7 ::v8(){vfunc_called(this, "_ZN7S2351C72v8Ev");}
void  S2351C7 ::v9(){vfunc_called(this, "_ZN7S2351C72v9Ev");}
void  S2351C7 ::v10(){vfunc_called(this, "_ZN7S2351C73v10Ev");}
S2351C7 ::S2351C7(){ note_ctor("S2351C7", this);} // tgen

static void Test_S2351C7()
{
  extern Class_Descriptor cd_S2351C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2351C7, buf);
    S2351C7 *dp, &lv = *(dp=new (buf) S2351C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2351C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2351C7)");
    test_class_info(&lv, &cd_S2351C7);
    dp->~S2351C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2351C7(Test_S2351C7, "S2351C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2351C7C1Ev();
extern void _ZN7S2351C7D1Ev();
Name_Map name_map_S2351C7[] = {
  NSPAIR(_ZN7S2351C7C1Ev),
  NSPAIR(_ZN7S2351C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2351C7[];
extern void _ZN7S2351C7D1Ev();
extern void _ZN7S2351C7D0Ev();
extern void _ZN7S2351C72v8Ev();
extern void _ZN7S2351C72v9Ev();
extern void _ZN7S2351C73v10Ev();
static  VTBL_ENTRY vtc_S2351C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2351C7[0]),
  (VTBL_ENTRY)&_ZN7S2351C7D1Ev,
  (VTBL_ENTRY)&_ZN7S2351C7D0Ev,
  (VTBL_ENTRY)&_ZN7S2351C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2351C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2351C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2351C7[];
extern  VTBL_ENTRY _ZTV7S2351C7[];
Class_Descriptor cd_S2351C7 = {  "S2351C7", // class name
  0,0,//no base classes
  &(vtc_S2351C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2351C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2351C7),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2351C3  : S2351C4 , S2351C7 {
  void *s2351c3f0;
  char s2351c3f1;
  int s2351c3f2;
  virtual  ~S2351C3(); // _ZN7S2351C3D1Ev
  virtual void  v11(); // _ZN7S2351C33v11Ev
  virtual void  v12(); // _ZN7S2351C33v12Ev
  virtual void  v13(); // _ZN7S2351C33v13Ev
  virtual void  v14(); // _ZN7S2351C33v14Ev
  virtual void  v15(); // _ZN7S2351C33v15Ev
  virtual void  v16(); // _ZN7S2351C33v16Ev
  virtual void  v17(); // _ZN7S2351C33v17Ev
  virtual void  v18(); // _ZN7S2351C33v18Ev
  virtual void  v19(); // _ZN7S2351C33v19Ev
  virtual void  v20(); // _ZN7S2351C33v20Ev
  S2351C3(); // tgen
};
//SIG(-1 S2351C3) C1{ BC2{ vd v11 v12 v13 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ vd v14 v15 v16} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi}


 S2351C3 ::~S2351C3(){ note_dtor("S2351C3", this);}
void  S2351C3 ::v11(){vfunc_called(this, "_ZN7S2351C33v11Ev");}
void  S2351C3 ::v12(){vfunc_called(this, "_ZN7S2351C33v12Ev");}
void  S2351C3 ::v13(){vfunc_called(this, "_ZN7S2351C33v13Ev");}
void  S2351C3 ::v14(){vfunc_called(this, "_ZN7S2351C33v14Ev");}
void  S2351C3 ::v15(){vfunc_called(this, "_ZN7S2351C33v15Ev");}
void  S2351C3 ::v16(){vfunc_called(this, "_ZN7S2351C33v16Ev");}
void  S2351C3 ::v17(){vfunc_called(this, "_ZN7S2351C33v17Ev");}
void  S2351C3 ::v18(){vfunc_called(this, "_ZN7S2351C33v18Ev");}
void  S2351C3 ::v19(){vfunc_called(this, "_ZN7S2351C33v19Ev");}
void  S2351C3 ::v20(){vfunc_called(this, "_ZN7S2351C33v20Ev");}
S2351C3 ::S2351C3(){ note_ctor("S2351C3", this);} // tgen

static void Test_S2351C3()
{
  extern Class_Descriptor cd_S2351C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,12)];
    init_test(&cd_S2351C3, buf);
    S2351C3 *dp, &lv = *(dp=new (buf) S2351C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,44), "sizeof(S2351C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2351C3)");
    check_base_class_offset(lv, (S2351C4*), 0, "S2351C3");
    check_base_class_offset(lv, (S2351C7*), ABISELECT(40,28), "S2351C3");
    check_field_offset(lv, s2351c3f0, ABISELECT(48,32), "S2351C3.s2351c3f0");
    check_field_offset(lv, s2351c3f1, ABISELECT(56,36), "S2351C3.s2351c3f1");
    check_field_offset(lv, s2351c3f2, ABISELECT(60,40), "S2351C3.s2351c3f2");
    test_class_info(&lv, &cd_S2351C3);
    dp->~S2351C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2351C3(Test_S2351C3, "S2351C3", ABISELECT(64,44));

#else // __cplusplus

extern void _ZN7S2351C3C1Ev();
extern void _ZN7S2351C3D1Ev();
Name_Map name_map_S2351C3[] = {
  NSPAIR(_ZN7S2351C3C1Ev),
  NSPAIR(_ZN7S2351C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2351C4;
extern VTBL_ENTRY _ZTI7S2351C4[];
extern  VTBL_ENTRY _ZTV7S2351C4[];
extern Class_Descriptor cd_S2351C7;
extern VTBL_ENTRY _ZTI7S2351C7[];
extern  VTBL_ENTRY _ZTV7S2351C7[];
static Base_Class bases_S2351C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2351C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2351C7,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2351C3[];
extern void _ZN7S2351C3D1Ev();
extern void _ZN7S2351C3D0Ev();
extern void _ZN7S2351C42v5Ev();
extern void _ZN7S2351C42v6Ev();
extern void _ZN7S2351C42v7Ev();
extern void _ZN7S2351C33v11Ev();
extern void _ZN7S2351C33v12Ev();
extern void _ZN7S2351C33v13Ev();
extern void _ZN7S2351C33v14Ev();
extern void _ZN7S2351C33v15Ev();
extern void _ZN7S2351C33v16Ev();
extern void _ZN7S2351C33v17Ev();
extern void _ZN7S2351C33v18Ev();
extern void _ZN7S2351C33v19Ev();
extern void _ZN7S2351C33v20Ev();
extern void ABISELECT(_ZThn40_N7S2351C3D1Ev,_ZThn28_N7S2351C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S2351C3D0Ev,_ZThn28_N7S2351C3D0Ev)();
extern void _ZN7S2351C72v8Ev();
extern void _ZN7S2351C72v9Ev();
extern void _ZN7S2351C73v10Ev();
static  VTBL_ENTRY vtc_S2351C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2351C3[0]),
  (VTBL_ENTRY)&_ZN7S2351C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2351C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2351C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2351C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2351C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2351C33v11Ev,
  (VTBL_ENTRY)&_ZN7S2351C33v12Ev,
  (VTBL_ENTRY)&_ZN7S2351C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2351C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2351C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2351C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2351C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2351C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2351C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2351C33v20Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S2351C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2351C3D1Ev,_ZThn28_N7S2351C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S2351C3D0Ev,_ZThn28_N7S2351C3D0Ev),
  (VTBL_ENTRY)&_ZN7S2351C72v8Ev,
  (VTBL_ENTRY)&_ZN7S2351C72v9Ev,
  (VTBL_ENTRY)&_ZN7S2351C73v10Ev,
};
extern VTBL_ENTRY _ZTI7S2351C3[];
extern  VTBL_ENTRY _ZTV7S2351C3[];
Class_Descriptor cd_S2351C3 = {  "S2351C3", // class name
  bases_S2351C3, 2,
  &(vtc_S2351C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,44), // object size
  NSPAIRA(_ZTI7S2351C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2351C3),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2351C10  {
  virtual  ~S2351C10(); // _ZN8S2351C10D1Ev
  virtual void  v21(); // _ZN8S2351C103v21Ev
  virtual void  v22(); // _ZN8S2351C103v22Ev
  virtual void  v23(); // _ZN8S2351C103v23Ev
  S2351C10(); // tgen
};
//SIG(-1 S2351C10) C1{ vd v1 v2 v3}


 S2351C10 ::~S2351C10(){ note_dtor("S2351C10", this);}
void  S2351C10 ::v21(){vfunc_called(this, "_ZN8S2351C103v21Ev");}
void  S2351C10 ::v22(){vfunc_called(this, "_ZN8S2351C103v22Ev");}
void  S2351C10 ::v23(){vfunc_called(this, "_ZN8S2351C103v23Ev");}
S2351C10 ::S2351C10(){ note_ctor("S2351C10", this);} // tgen

static void Test_S2351C10()
{
  extern Class_Descriptor cd_S2351C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2351C10, buf);
    S2351C10 *dp, &lv = *(dp=new (buf) S2351C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2351C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2351C10)");
    test_class_info(&lv, &cd_S2351C10);
    dp->~S2351C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2351C10(Test_S2351C10, "S2351C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2351C10C1Ev();
extern void _ZN8S2351C10D1Ev();
Name_Map name_map_S2351C10[] = {
  NSPAIR(_ZN8S2351C10C1Ev),
  NSPAIR(_ZN8S2351C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2351C10[];
extern void _ZN8S2351C10D1Ev();
extern void _ZN8S2351C10D0Ev();
extern void _ZN8S2351C103v21Ev();
extern void _ZN8S2351C103v22Ev();
extern void _ZN8S2351C103v23Ev();
static  VTBL_ENTRY vtc_S2351C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2351C10[0]),
  (VTBL_ENTRY)&_ZN8S2351C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2351C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2351C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2351C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2351C103v23Ev,
};
extern VTBL_ENTRY _ZTI8S2351C10[];
extern  VTBL_ENTRY _ZTV8S2351C10[];
Class_Descriptor cd_S2351C10 = {  "S2351C10", // class name
  0,0,//no base classes
  &(vtc_S2351C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2351C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2351C10),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2351C9  : S2351C10 {
  ::S10183C20 s2351c9f0;
  ::S10184C7_nt s2351c9f1;
  char s2351c9f2;
  virtual  ~S2351C9(); // _ZN7S2351C9D1Ev
  virtual void  v24(); // _ZN7S2351C93v24Ev
  virtual void  v25(); // _ZN7S2351C93v25Ev
  virtual void  v26(); // _ZN7S2351C93v26Ev
  S2351C9(); // tgen
};
//SIG(-1 S2351C9) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ FL[4]}} Fc}


 S2351C9 ::~S2351C9(){ note_dtor("S2351C9", this);}
void  S2351C9 ::v24(){vfunc_called(this, "_ZN7S2351C93v24Ev");}
void  S2351C9 ::v25(){vfunc_called(this, "_ZN7S2351C93v25Ev");}
void  S2351C9 ::v26(){vfunc_called(this, "_ZN7S2351C93v26Ev");}
S2351C9 ::S2351C9(){ note_ctor("S2351C9", this);} // tgen

static void Test_S2351C9()
{
  extern Class_Descriptor cd_S2351C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2351C9, buf);
    S2351C9 *dp, &lv = *(dp=new (buf) S2351C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2351C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2351C9)");
    check_base_class_offset(lv, (S2351C10*), 0, "S2351C9");
    check_field_offset(lv, s2351c9f0, ABISELECT(8,4), "S2351C9.s2351c9f0");
    check_field_offset(lv, s2351c9f1, ABISELECT(32,20), "S2351C9.s2351c9f1");
    check_field_offset(lv, s2351c9f2, ABISELECT(64,52), "S2351C9.s2351c9f2");
    test_class_info(&lv, &cd_S2351C9);
    dp->~S2351C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2351C9(Test_S2351C9, "S2351C9", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2351C9C1Ev();
extern void _ZN7S2351C9D1Ev();
Name_Map name_map_S2351C9[] = {
  NSPAIR(_ZN7S2351C9C1Ev),
  NSPAIR(_ZN7S2351C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2351C10;
extern VTBL_ENTRY _ZTI8S2351C10[];
extern  VTBL_ENTRY _ZTV8S2351C10[];
static Base_Class bases_S2351C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2351C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2351C9[];
extern void _ZN7S2351C9D1Ev();
extern void _ZN7S2351C9D0Ev();
extern void _ZN8S2351C103v21Ev();
extern void _ZN8S2351C103v22Ev();
extern void _ZN8S2351C103v23Ev();
extern void _ZN7S2351C93v24Ev();
extern void _ZN7S2351C93v25Ev();
extern void _ZN7S2351C93v26Ev();
static  VTBL_ENTRY vtc_S2351C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2351C9[0]),
  (VTBL_ENTRY)&_ZN7S2351C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2351C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2351C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2351C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2351C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2351C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2351C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2351C93v26Ev,
};
extern VTBL_ENTRY _ZTI7S2351C9[];
extern  VTBL_ENTRY _ZTV7S2351C9[];
Class_Descriptor cd_S2351C9 = {  "S2351C9", // class name
  bases_S2351C9, 1,
  &(vtc_S2351C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2351C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2351C9),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2351C8  : S2351C9 {
  virtual  ~S2351C8(); // _ZN7S2351C8D1Ev
  virtual void  v27(); // _ZN7S2351C83v27Ev
  virtual void  v28(); // _ZN7S2351C83v28Ev
  virtual void  v29(); // _ZN7S2351C83v29Ev
  virtual void  v30(); // _ZN7S2351C83v30Ev
  S2351C8(); // tgen
};
//SIG(-1 S2351C8) C1{ BC2{ BC3{ vd v5 v6 v7} vd v8 v9 v10 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc} vd v1 v2 v3 v4}


 S2351C8 ::~S2351C8(){ note_dtor("S2351C8", this);}
void  S2351C8 ::v27(){vfunc_called(this, "_ZN7S2351C83v27Ev");}
void  S2351C8 ::v28(){vfunc_called(this, "_ZN7S2351C83v28Ev");}
void  S2351C8 ::v29(){vfunc_called(this, "_ZN7S2351C83v29Ev");}
void  S2351C8 ::v30(){vfunc_called(this, "_ZN7S2351C83v30Ev");}
S2351C8 ::S2351C8(){ note_ctor("S2351C8", this);} // tgen

static void Test_S2351C8()
{
  extern Class_Descriptor cd_S2351C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2351C8, buf);
    S2351C8 *dp, &lv = *(dp=new (buf) S2351C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2351C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2351C8)");
    check_base_class_offset(lv, (S2351C10*)(S2351C9*), 0, "S2351C8");
    check_base_class_offset(lv, (S2351C9*), 0, "S2351C8");
    test_class_info(&lv, &cd_S2351C8);
    dp->~S2351C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2351C8(Test_S2351C8, "S2351C8", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2351C8C1Ev();
extern void _ZN7S2351C8D1Ev();
Name_Map name_map_S2351C8[] = {
  NSPAIR(_ZN7S2351C8C1Ev),
  NSPAIR(_ZN7S2351C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2351C10;
extern VTBL_ENTRY _ZTI8S2351C10[];
extern  VTBL_ENTRY _ZTV8S2351C10[];
extern Class_Descriptor cd_S2351C9;
extern VTBL_ENTRY _ZTI7S2351C9[];
extern  VTBL_ENTRY _ZTV7S2351C9[];
static Base_Class bases_S2351C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2351C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2351C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2351C8[];
extern void _ZN7S2351C8D1Ev();
extern void _ZN7S2351C8D0Ev();
extern void _ZN8S2351C103v21Ev();
extern void _ZN8S2351C103v22Ev();
extern void _ZN8S2351C103v23Ev();
extern void _ZN7S2351C93v24Ev();
extern void _ZN7S2351C93v25Ev();
extern void _ZN7S2351C93v26Ev();
extern void _ZN7S2351C83v27Ev();
extern void _ZN7S2351C83v28Ev();
extern void _ZN7S2351C83v29Ev();
extern void _ZN7S2351C83v30Ev();
static  VTBL_ENTRY vtc_S2351C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2351C8[0]),
  (VTBL_ENTRY)&_ZN7S2351C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2351C8D0Ev,
  (VTBL_ENTRY)&_ZN8S2351C103v21Ev,
  (VTBL_ENTRY)&_ZN8S2351C103v22Ev,
  (VTBL_ENTRY)&_ZN8S2351C103v23Ev,
  (VTBL_ENTRY)&_ZN7S2351C93v24Ev,
  (VTBL_ENTRY)&_ZN7S2351C93v25Ev,
  (VTBL_ENTRY)&_ZN7S2351C93v26Ev,
  (VTBL_ENTRY)&_ZN7S2351C83v27Ev,
  (VTBL_ENTRY)&_ZN7S2351C83v28Ev,
  (VTBL_ENTRY)&_ZN7S2351C83v29Ev,
  (VTBL_ENTRY)&_ZN7S2351C83v30Ev,
};
extern VTBL_ENTRY _ZTI7S2351C8[];
extern  VTBL_ENTRY _ZTV7S2351C8[];
Class_Descriptor cd_S2351C8 = {  "S2351C8", // class name
  bases_S2351C8, 2,
  &(vtc_S2351C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2351C8),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2351C8),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2351C2  : S2351C3 , S2351C8 {
  int s2351c2f0[3];
  char s2351c2f1;
  ::S10183C9_nt s2351c2f2;
  virtual  ~S2351C2(); // _ZN7S2351C2D1Ev
  virtual void  v31(); // _ZN7S2351C23v31Ev
  virtual void  v32(); // _ZN7S2351C23v32Ev
  virtual void  v33(); // _ZN7S2351C23v33Ev
  virtual void  v34(); // _ZN7S2351C23v34Ev
  virtual void  v35(); // _ZN7S2351C23v35Ev
  