// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S1406C5_nt  {
  int s1406c5f0[2];
  void  mf1406c5(); // _ZN10S1406C5_nt8mf1406c5Ev
};
//SIG(-1 S1406C5_nt) C1{ m Fi[2]}


void  S1406C5_nt ::mf1406c5(){}

//skip512 S1406C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C4_nt  {
  int s1406c4f0;
  __tsi64 s1406c4f1;
  void *s1406c4f2[4];
  int s1406c4f3[2];
  void *s1406c4f4;
  ::S1406C5_nt s1406c4f5;
  void *s1406c4f6[2];
  virtual  ~S1406C4_nt(); // _ZN10S1406C4_ntD1Ev
  virtual void  v4(); // _ZN10S1406C4_nt2v4Ev
  virtual void  v5(); // _ZN10S1406C4_nt2v5Ev
  virtual void  v6(); // _ZN10S1406C4_nt2v6Ev
  virtual void  v7(); // _ZN10S1406C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1406C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1406C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1406C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1406C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1406C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1406C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1406C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1406C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1406C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1406C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1406C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1406C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1406C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1406C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1406C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1406C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1406C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1406C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1406C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1406C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1406C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1406C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1406C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1406C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1406C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1406C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1406C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1406C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1406C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1406C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1406C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1406C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1406C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1406C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1406C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1406C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1406C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1406C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1406C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1406C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1406C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1406C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1406C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1406C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1406C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1406C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1406C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1406C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1406C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1406C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1406C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1406C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1406C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1406C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1406C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1406C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1406C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1406C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1406C4_nt3v66Ev
  virtual void  v67(); // _ZN10S1406C4_nt3v67Ev
  S1406C4_nt(); // tgen
};
//SIG(-1 S1406C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1406C4_nt ::~S1406C4_nt(){ note_dtor("S1406C4_nt", this);}
void  S1406C4_nt ::v4(){vfunc_called(this, "_ZN10S1406C4_nt2v4Ev");}
void  S1406C4_nt ::v5(){vfunc_called(this, "_ZN10S1406C4_nt2v5Ev");}
void  S1406C4_nt ::v6(){vfunc_called(this, "_ZN10S1406C4_nt2v6Ev");}
void  S1406C4_nt ::v7(){vfunc_called(this, "_ZN10S1406C4_nt2v7Ev");}
void  S1406C4_nt ::v8(){vfunc_called(this, "_ZN10S1406C4_nt2v8Ev");}
void  S1406C4_nt ::v9(){vfunc_called(this, "_ZN10S1406C4_nt2v9Ev");}
void  S1406C4_nt ::v10(){vfunc_called(this, "_ZN10S1406C4_nt3v10Ev");}
void  S1406C4_nt ::v11(){vfunc_called(this, "_ZN10S1406C4_nt3v11Ev");}
void  S1406C4_nt ::v12(){vfunc_called(this, "_ZN10S1406C4_nt3v12Ev");}
void  S1406C4_nt ::v13(){vfunc_called(this, "_ZN10S1406C4_nt3v13Ev");}
void  S1406C4_nt ::v14(){vfunc_called(this, "_ZN10S1406C4_nt3v14Ev");}
void  S1406C4_nt ::v15(){vfunc_called(this, "_ZN10S1406C4_nt3v15Ev");}
void  S1406C4_nt ::v16(){vfunc_called(this, "_ZN10S1406C4_nt3v16Ev");}
void  S1406C4_nt ::v17(){vfunc_called(this, "_ZN10S1406C4_nt3v17Ev");}
void  S1406C4_nt ::v18(){vfunc_called(this, "_ZN10S1406C4_nt3v18Ev");}
void  S1406C4_nt ::v19(){vfunc_called(this, "_ZN10S1406C4_nt3v19Ev");}
void  S1406C4_nt ::v20(){vfunc_called(this, "_ZN10S1406C4_nt3v20Ev");}
void  S1406C4_nt ::v21(){vfunc_called(this, "_ZN10S1406C4_nt3v21Ev");}
void  S1406C4_nt ::v22(){vfunc_called(this, "_ZN10S1406C4_nt3v22Ev");}
void  S1406C4_nt ::v23(){vfunc_called(this, "_ZN10S1406C4_nt3v23Ev");}
void  S1406C4_nt ::v24(){vfunc_called(this, "_ZN10S1406C4_nt3v24Ev");}
void  S1406C4_nt ::v25(){vfunc_called(this, "_ZN10S1406C4_nt3v25Ev");}
void  S1406C4_nt ::v26(){vfunc_called(this, "_ZN10S1406C4_nt3v26Ev");}
void  S1406C4_nt ::v27(){vfunc_called(this, "_ZN10S1406C4_nt3v27Ev");}
void  S1406C4_nt ::v28(){vfunc_called(this, "_ZN10S1406C4_nt3v28Ev");}
void  S1406C4_nt ::v29(){vfunc_called(this, "_ZN10S1406C4_nt3v29Ev");}
void  S1406C4_nt ::v30(){vfunc_called(this, "_ZN10S1406C4_nt3v30Ev");}
void  S1406C4_nt ::v31(){vfunc_called(this, "_ZN10S1406C4_nt3v31Ev");}
void  S1406C4_nt ::v32(){vfunc_called(this, "_ZN10S1406C4_nt3v32Ev");}
void  S1406C4_nt ::v33(){vfunc_called(this, "_ZN10S1406C4_nt3v33Ev");}
void  S1406C4_nt ::v34(){vfunc_called(this, "_ZN10S1406C4_nt3v34Ev");}
void  S1406C4_nt ::v35(){vfunc_called(this, "_ZN10S1406C4_nt3v35Ev");}
void  S1406C4_nt ::v36(){vfunc_called(this, "_ZN10S1406C4_nt3v36Ev");}
void  S1406C4_nt ::v37(){vfunc_called(this, "_ZN10S1406C4_nt3v37Ev");}
void  S1406C4_nt ::v38(){vfunc_called(this, "_ZN10S1406C4_nt3v38Ev");}
void  S1406C4_nt ::v39(){vfunc_called(this, "_ZN10S1406C4_nt3v39Ev");}
void  S1406C4_nt ::v40(){vfunc_called(this, "_ZN10S1406C4_nt3v40Ev");}
void  S1406C4_nt ::v41(){vfunc_called(this, "_ZN10S1406C4_nt3v41Ev");}
void  S1406C4_nt ::v42(){vfunc_called(this, "_ZN10S1406C4_nt3v42Ev");}
void  S1406C4_nt ::v43(){vfunc_called(this, "_ZN10S1406C4_nt3v43Ev");}
void  S1406C4_nt ::v44(){vfunc_called(this, "_ZN10S1406C4_nt3v44Ev");}
void  S1406C4_nt ::v45(){vfunc_called(this, "_ZN10S1406C4_nt3v45Ev");}
void  S1406C4_nt ::v46(){vfunc_called(this, "_ZN10S1406C4_nt3v46Ev");}
void  S1406C4_nt ::v47(){vfunc_called(this, "_ZN10S1406C4_nt3v47Ev");}
void  S1406C4_nt ::v48(){vfunc_called(this, "_ZN10S1406C4_nt3v48Ev");}
void  S1406C4_nt ::v49(){vfunc_called(this, "_ZN10S1406C4_nt3v49Ev");}
void  S1406C4_nt ::v50(){vfunc_called(this, "_ZN10S1406C4_nt3v50Ev");}
void  S1406C4_nt ::v51(){vfunc_called(this, "_ZN10S1406C4_nt3v51Ev");}
void  S1406C4_nt ::v52(){vfunc_called(this, "_ZN10S1406C4_nt3v52Ev");}
void  S1406C4_nt ::v53(){vfunc_called(this, "_ZN10S1406C4_nt3v53Ev");}
void  S1406C4_nt ::v54(){vfunc_called(this, "_ZN10S1406C4_nt3v54Ev");}
void  S1406C4_nt ::v55(){vfunc_called(this, "_ZN10S1406C4_nt3v55Ev");}
void  S1406C4_nt ::v56(){vfunc_called(this, "_ZN10S1406C4_nt3v56Ev");}
void  S1406C4_nt ::v57(){vfunc_called(this, "_ZN10S1406C4_nt3v57Ev");}
void  S1406C4_nt ::v58(){vfunc_called(this, "_ZN10S1406C4_nt3v58Ev");}
void  S1406C4_nt ::v59(){vfunc_called(this, "_ZN10S1406C4_nt3v59Ev");}
void  S1406C4_nt ::v60(){vfunc_called(this, "_ZN10S1406C4_nt3v60Ev");}
void  S1406C4_nt ::v61(){vfunc_called(this, "_ZN10S1406C4_nt3v61Ev");}
void  S1406C4_nt ::v62(){vfunc_called(this, "_ZN10S1406C4_nt3v62Ev");}
void  S1406C4_nt ::v63(){vfunc_called(this, "_ZN10S1406C4_nt3v63Ev");}
void  S1406C4_nt ::v64(){vfunc_called(this, "_ZN10S1406C4_nt3v64Ev");}
void  S1406C4_nt ::v65(){vfunc_called(this, "_ZN10S1406C4_nt3v65Ev");}
void  S1406C4_nt ::v66(){vfunc_called(this, "_ZN10S1406C4_nt3v66Ev");}
void  S1406C4_nt ::v67(){vfunc_called(this, "_ZN10S1406C4_nt3v67Ev");}
S1406C4_nt ::S1406C4_nt(){ note_ctor("S1406C4_nt", this);} // tgen

//skip512 S1406C4_nt

#else // __cplusplus

extern void _ZN10S1406C4_ntC1Ev();
extern void _ZN10S1406C4_ntD1Ev();
Name_Map name_map_S1406C4_nt[] = {
  NSPAIR(_ZN10S1406C4_ntC1Ev),
  NSPAIR(_ZN10S1406C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1406C4_nt[];
extern void _ZN10S1406C4_ntD1Ev();
extern void _ZN10S1406C4_ntD0Ev();
extern void _ZN10S1406C4_nt2v4Ev();
extern void _ZN10S1406C4_nt2v5Ev();
extern void _ZN10S1406C4_nt2v6Ev();
extern void _ZN10S1406C4_nt2v7Ev();
extern void _ZN10S1406C4_nt2v8Ev();
extern void _ZN10S1406C4_nt2v9Ev();
extern void _ZN10S1406C4_nt3v10Ev();
extern void _ZN10S1406C4_nt3v11Ev();
extern void _ZN10S1406C4_nt3v12Ev();
extern void _ZN10S1406C4_nt3v13Ev();
extern void _ZN10S1406C4_nt3v14Ev();
extern void _ZN10S1406C4_nt3v15Ev();
extern void _ZN10S1406C4_nt3v16Ev();
extern void _ZN10S1406C4_nt3v17Ev();
extern void _ZN10S1406C4_nt3v18Ev();
extern void _ZN10S1406C4_nt3v19Ev();
extern void _ZN10S1406C4_nt3v20Ev();
extern void _ZN10S1406C4_nt3v21Ev();
extern void _ZN10S1406C4_nt3v22Ev();
extern void _ZN10S1406C4_nt3v23Ev();
extern void _ZN10S1406C4_nt3v24Ev();
extern void _ZN10S1406C4_nt3v25Ev();
extern void _ZN10S1406C4_nt3v26Ev();
extern void _ZN10S1406C4_nt3v27Ev();
extern void _ZN10S1406C4_nt3v28Ev();
extern void _ZN10S1406C4_nt3v29Ev();
extern void _ZN10S1406C4_nt3v30Ev();
extern void _ZN10S1406C4_nt3v31Ev();
extern void _ZN10S1406C4_nt3v32Ev();
extern void _ZN10S1406C4_nt3v33Ev();
extern void _ZN10S1406C4_nt3v34Ev();
extern void _ZN10S1406C4_nt3v35Ev();
extern void _ZN10S1406C4_nt3v36Ev();
extern void _ZN10S1406C4_nt3v37Ev();
extern void _ZN10S1406C4_nt3v38Ev();
extern void _ZN10S1406C4_nt3v39Ev();
extern void _ZN10S1406C4_nt3v40Ev();
extern void _ZN10S1406C4_nt3v41Ev();
extern void _ZN10S1406C4_nt3v42Ev();
extern void _ZN10S1406C4_nt3v43Ev();
extern void _ZN10S1406C4_nt3v44Ev();
extern void _ZN10S1406C4_nt3v45Ev();
extern void _ZN10S1406C4_nt3v46Ev();
extern void _ZN10S1406C4_nt3v47Ev();
extern void _ZN10S1406C4_nt3v48Ev();
extern void _ZN10S1406C4_nt3v49Ev();
extern void _ZN10S1406C4_nt3v50Ev();
extern void _ZN10S1406C4_nt3v51Ev();
extern void _ZN10S1406C4_nt3v52Ev();
extern void _ZN10S1406C4_nt3v53Ev();
extern void _ZN10S1406C4_nt3v54Ev();
extern void _ZN10S1406C4_nt3v55Ev();
extern void _ZN10S1406C4_nt3v56Ev();
extern void _ZN10S1406C4_nt3v57Ev();
extern void _ZN10S1406C4_nt3v58Ev();
extern void _ZN10S1406C4_nt3v59Ev();
extern void _ZN10S1406C4_nt3v60Ev();
extern void _ZN10S1406C4_nt3v61Ev();
extern void _ZN10S1406C4_nt3v62Ev();
extern void _ZN10S1406C4_nt3v63Ev();
extern void _ZN10S1406C4_nt3v64Ev();
extern void _ZN10S1406C4_nt3v65Ev();
extern void _ZN10S1406C4_nt3v66Ev();
extern void _ZN10S1406C4_nt3v67Ev();
static  VTBL_ENTRY vtc_S1406C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1406C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1406C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI10S1406C4_nt[];
VTBL_ENTRY *P__ZTI10S1406C4_nt = _ZTI10S1406C4_nt; 
extern  VTBL_ENTRY _ZTV10S1406C4_nt[];
Class_Descriptor cd_S1406C4_nt = {  "S1406C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1406C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1406C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1406C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C8_nt  {
  void *s1406c8f0;
  int s1406c8f1[2];
  void  mf1406c8(); // _ZN10S1406C8_nt8mf1406c8Ev
};
//SIG(-1 S1406C8_nt) C1{ m Fp Fi[2]}


void  S1406C8_nt ::mf1406c8(){}

//skip512 S1406C8_nt

#else // __cplusplus

Class_Descriptor cd_S1406C8_nt = {  "S1406C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C7_nt  : S1406C8_nt {
};
//SIG(-1 S1406C7_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1406C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
static Base_Class bases_S1406C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1406C7_nt = {  "S1406C7_nt", // class name
  bases_S1406C7_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C6_nt  : S1406C7_nt {
};
//SIG(-1 S1406C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1406C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
extern Class_Descriptor cd_S1406C7_nt;
static Base_Class bases_S1406C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1406C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C9_nt  {
  int s1406c9f0;
  void  mf1406c9(); // _ZN10S1406C9_nt8mf1406c9Ev
};
//SIG(-1 S1406C9_nt) C1{ m Fi}


void  S1406C9_nt ::mf1406c9(){}

//skip512 S1406C9_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S1406C9_nt[];
VTBL_ENTRY *P__ZTI10S1406C9_nt = _ZTI10S1406C9_nt; 
Class_Descriptor cd_S1406C9_nt = {  "S1406C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S1406C9_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C13  : S1406C8_nt {
};
//SIG(-1 S1406C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1406C13()
{
  extern Class_Descriptor cd_S1406C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1406C13, buf);
    S1406C13 &lv = *(new (buf) S1406C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1406C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1406C13)");
    check_base_class_offset(lv, (S1406C8_nt*), 0, "S1406C13");
    test_class_info(&lv, &cd_S1406C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1406C13(Test_S1406C13, "S1406C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
static Base_Class bases_S1406C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1406C13 = {  "S1406C13", // class name
  bases_S1406C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C12  : S1406C13 {
};
//SIG(-1 S1406C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1406C12()
{
  extern Class_Descriptor cd_S1406C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1406C12, buf);
    S1406C12 &lv = *(new (buf) S1406C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1406C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1406C12)");
    check_base_class_offset(lv, (S1406C8_nt*)(S1406C13*), 0, "S1406C12");
    check_base_class_offset(lv, (S1406C13*), 0, "S1406C12");
    test_class_info(&lv, &cd_S1406C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1406C12(Test_S1406C12, "S1406C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
extern Class_Descriptor cd_S1406C13;
static Base_Class bases_S1406C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1406C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1406C12 = {  "S1406C12", // class name
  bases_S1406C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C14_nt  {
  int s1406c14f0[3];
  void  mf1406c14(); // _ZN11S1406C14_nt9mf1406c14Ev
};
//SIG(-1 S1406C14_nt) C1{ m Fi[3]}


void  S1406C14_nt ::mf1406c14(){}

//skip512 S1406C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C19  : S1406C8_nt {
};
//SIG(-1 S1406C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1406C19()
{
  extern Class_Descriptor cd_S1406C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1406C19, buf);
    S1406C19 &lv = *(new (buf) S1406C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1406C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1406C19)");
    check_base_class_offset(lv, (S1406C8_nt*), 0, "S1406C19");
    test_class_info(&lv, &cd_S1406C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1406C19(Test_S1406C19, "S1406C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
static Base_Class bases_S1406C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1406C19 = {  "S1406C19", // class name
  bases_S1406C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C18  : S1406C19 {
};
//SIG(-1 S1406C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1406C18()
{
  extern Class_Descriptor cd_S1406C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1406C18, buf);
    S1406C18 &lv = *(new (buf) S1406C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1406C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1406C18)");
    check_base_class_offset(lv, (S1406C8_nt*)(S1406C19*), 0, "S1406C18");
    check_base_class_offset(lv, (S1406C19*), 0, "S1406C18");
    test_class_info(&lv, &cd_S1406C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1406C18(Test_S1406C18, "S1406C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
extern Class_Descriptor cd_S1406C19;
static Base_Class bases_S1406C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1406C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1406C18 = {  "S1406C18", // class name
  bases_S1406C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C3_nt  : S1406C4_nt {
  ::S1406C6_nt s1406c3f0;
  ::S1406C6_nt s1406c3f1;
  ::S1406C9_nt s1406c3f2;
  int s1406c3f3;
  char s1406c3f4[4];
  void *s1406c3f5[2];
  ::S1406C6_nt s1406c3f6;
  unsigned int s1406c3f7:1;
  unsigned int s1406c3f8:1;
  unsigned int s1406c3f9:1;
  unsigned int s1406c3f10:1;
  unsigned int s1406c3f11:1;
  unsigned int s1406c3f12:1;
  unsigned int s1406c3f13:1;
  unsigned int s1406c3f14:1;
  unsigned int s1406c3f15:1;
  unsigned int s1406c3f16:1;
  unsigned int s1406c3f17:1;
  unsigned int s1406c3f18:1;
  unsigned int s1406c3f19:1;
  unsigned int s1406c3f20:1;
  unsigned int s1406c3f21:1;
  unsigned int s1406c3f22:1;
  unsigned int s1406c3f23:1;
  unsigned int s1406c3f24:1;
  unsigned int s1406c3f25:1;
  unsigned int s1406c3f26:1;
  unsigned int s1406c3f27:1;
  unsigned int s1406c3f28:1;
  unsigned int s1406c3f29:1;
  unsigned int s1406c3f30:1;
  unsigned int s1406c3f31:1;
  unsigned int s1406c3f32:1;
  unsigned int s1406c3f33:1;
  unsigned int s1406c3f34:1;
  unsigned int s1406c3f35:1;
  unsigned int s1406c3f36:1;
  unsigned int s1406c3f37:1;
  unsigned int s1406c3f38:1;
  unsigned int s1406c3f39:1;
  unsigned int s1406c3f40:1;
  unsigned int s1406c3f41:1;
  unsigned int s1406c3f42:1;
  unsigned int s1406c3f43:1;
  unsigned int s1406c3f44:1;
  unsigned int s1406c3f45:1;
  unsigned int s1406c3f46:1;
  unsigned int s1406c3f47:1;
  unsigned int s1406c3f48:1;
  unsigned int s1406c3f49:1;
  unsigned int s1406c3f50:1;
  unsigned int s1406c3f51:1;
  unsigned int s1406c3f52:1;
  unsigned int s1406c3f53:1;
  unsigned int s1406c3f54:1;
  unsigned int s1406c3f55:1;
  unsigned int s1406c3f56:1;
  unsigned int s1406c3f57:1;
  unsigned int s1406c3f58:1;
  unsigned int s1406c3f59:1;
  unsigned int s1406c3f60:1;
  unsigned int s1406c3f61:1;
  unsigned int s1406c3f62:1;
  unsigned int s1406c3f63:1;
  unsigned int s1406c3f64:1;
  unsigned int s1406c3f65:1;
  unsigned int s1406c3f66:1;
  unsigned int s1406c3f67:1;
  unsigned int s1406c3f68:1;
  unsigned int s1406c3f69:1;
  unsigned int s1406c3f70:1;
  unsigned int s1406c3f71:1;
  unsigned int s1406c3f72:1;
  unsigned int s1406c3f73:1;
  unsigned int s1406c3f74:1;
  unsigned int s1406c3f75:1;
  unsigned int s1406c3f76:1;
  unsigned int s1406c3f77:1;
  unsigned int s1406c3f78:1;
  unsigned int s1406c3f79:1;
  unsigned int s1406c3f80:1;
  unsigned int s1406c3f81:1;
  unsigned int s1406c3f82:1;
  unsigned int s1406c3f83:1;
  int s1406c3f84[5];
  void *s1406c3f85[2];
  int s1406c3f86[3];
  ::S1406C5_nt s1406c3f87;
  ::S1406C5_nt s1406c3f88;
  ::S1406C5_nt s1406c3f89;
  ::S1406C12 s1406c3f90;
  ::S1406C12 s1406c3f91;
  int s1406c3f92;
  void *s1406c3f93[2];
  ::S1406C14_nt s1406c3f94;
  ::S1406C14_nt s1406c3f95;
  ::S1406C14_nt s1406c3f96;
  ::S1406C14_nt s1406c3f97;
  void *s1406c3f98;
  ::S1406C5_nt s1406c3f99;
  ::S1406C12 s1406c3f100;
  ::S1406C14_nt s1406c3f101;
  ::S1406C14_nt s1406c3f102;
  int s1406c3f103;
  ::S1406C14_nt s1406c3f104;
  ::S1406C14_nt s1406c3f105;
  void *s1406c3f106;
  int s1406c3f107;
  char s1406c3f108;
  ::S1406C14_nt s1406c3f109;
  ::S1406C14_nt s1406c3f110;
  void *s1406c3f111;
  int s1406c3f112;
  void *s1406c3f113;
  ::S1406C12 s1406c3f114;
  ::S1406C18 s1406c3f115;
  ::S1406C18 s1406c3f116;
  virtual  ~S1406C3_nt(); // _ZN10S1406C3_ntD1Ev
  virtual void  v68(); // _ZN10S1406C3_nt3v68Ev
  virtual void  v69(); // _ZN10S1406C3_nt3v69Ev
  virtual void  v70(); // _ZN10S1406C3_nt3v70Ev
  virtual void  v71(); // _ZN10S1406C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1406C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1406C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1406C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1406C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1406C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1406C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1406C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1406C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1406C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1406C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1406C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1406C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1406C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1406C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1406C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1406C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1406C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1406C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1406C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1406C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1406C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1406C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1406C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1406C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1406C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1406C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1406C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1406C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1406C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1406C3_nt4v101Ev
  virtual void  v102(); // _ZN10S1406C3_nt4v102Ev
  virtual void  v103(); // _ZN10S1406C3_nt4v103Ev
  virtual void  v104(); // _ZN10S1406C3_nt4v104Ev
  virtual void  v105(); // _ZN10S1406C3_nt4v105Ev
  virtual void  v106(); // _ZN10S1406C3_nt4v106Ev
  virtual void  v107(); // _ZN10S1406C3_nt4v107Ev
  virtual void  v108(); // _ZN10S1406C3_nt4v108Ev
  virtual void  v109(); // _ZN10S1406C3_nt4v109Ev
  virtual void  v110(); // _ZN10S1406C3_nt4v110Ev
  virtual void  v111(); // _ZN10S1406C3_nt4v111Ev
  virtual void  v112(); // _ZN10S1406C3_nt4v112Ev
  virtual void  v113(); // _ZN10S1406C3_nt4v113Ev
  virtual void  v114(); // _ZN10S1406C3_nt4v114Ev
  virtual void  v115(); // _ZN10S1406C3_nt4v115Ev
  virtual void  v116(); // _ZN10S1406C3_nt4v116Ev
  virtual void  v117(); // _ZN10S1406C3_nt4v117Ev
  virtual void  v118(); // _ZN10S1406C3_nt4v118Ev
  virtual void  v119(); // _ZN10S1406C3_nt4v119Ev
  virtual void  v120(); // _ZN10S1406C3_nt4v120Ev
  virtual void  v121(); // _ZN10S1406C3_nt4v121Ev
  virtual void  v122(); // _ZN10S1406C3_nt4v122Ev
  virtual void  v123(); // _ZN10S1406C3_nt4v123Ev
  virtual void  v124(); // _ZN10S1406C3_nt4v124Ev
  virtual void  v125(); // _ZN10S1406C3_nt4v125Ev
  virtual void  v126(); // _ZN10S1406C3_nt4v126Ev
  virtual void  v127(); // _ZN10S1406C3_nt4v127Ev
  virtual void  v128(); // _ZN10S1406C3_nt4v128Ev
  virtual void  v129(); // _ZN10S1406C3_nt4v129Ev
  virtual void  v130(); // _ZN10S1406C3_nt4v130Ev
  virtual void  v131(); // _ZN10S1406C3_nt4v131Ev
  virtual void  v132(); // _ZN10S1406C3_nt4v132Ev
  virtual void  v133(); // _ZN10S1406C3_nt4v133Ev
  virtual void  v134(); // _ZN10S1406C3_nt4v134Ev
  virtual void  v135(); // _ZN10S1406C3_nt4v135Ev
  virtual void  v136(); // _ZN10S1406C3_nt4v136Ev
  virtual void  v137(); // _ZN10S1406C3_nt4v137Ev
  virtual void  v138(); // _ZN10S1406C3_nt4v138Ev
  virtual void  v139(); // _ZN10S1406C3_nt4v139Ev
  virtual void  v140(); // _ZN10S1406C3_nt4v140Ev
  virtual void  v141(); // _ZN10S1406C3_nt4v141Ev
  virtual void  v142(); // _ZN10S1406C3_nt4v142Ev
  virtual void  v143(); // _ZN10S1406C3_nt4v143Ev
  virtual void  v144(); // _ZN10S1406C3_nt4v144Ev
  virtual void  v145(); // _ZN10S1406C3_nt4v145Ev
  virtual void  v146(); // _ZN10S1406C3_nt4v146Ev
  virtual void  v147(); // _ZN10S1406C3_nt4v147Ev
  virtual void  v148(); // _ZN10S1406C3_nt4v148Ev
  virtual void  v149(); // _ZN10S1406C3_nt4v149Ev
  virtual void  v150(); // _ZN10S1406C3_nt4v150Ev
  virtual void  v151(); // _ZN10S1406C3_nt4v151Ev
  virtual void  v152(); // _ZN10S1406C3_nt4v152Ev
  virtual void  v153(); // _ZN10S1406C3_nt4v153Ev
  virtual void  v154(); // _ZN10S1406C3_nt4v154Ev
  virtual void  v155(); // _ZN10S1406C3_nt4v155Ev
  virtual void  v156(); // _ZN10S1406C3_nt4v156Ev
  virtual void  v157(); // _ZN10S1406C3_nt4v157Ev
  virtual void  v158(); // _ZN10S1406C3_nt4v158Ev
  virtual void  v159(); // _ZN10S1406C3_nt4v159Ev
  virtual void  v160(); // _ZN10S1406C3_nt4v160Ev
  virtual void  v161(); // _ZN10S1406C3_nt4v161Ev
  virtual void  v162(); // _ZN10S1406C3_nt4v162Ev
  virtual void  v163(); // _ZN10S1406C3_nt4v163Ev
  virtual void  v164(); // _ZN10S1406C3_nt4v164Ev
  virtual void  v165(); // _ZN10S1406C3_nt4v165Ev
  virtual void  v166(); // _ZN10S1406C3_nt4v166Ev
  virtual void  v167(); // _ZN10S1406C3_nt4v167Ev
  virtual void  v168(); // _ZN10S1406C3_nt4v168Ev
  virtual void  v169(); // _ZN10S1406C3_nt4v169Ev
  virtual void  v170(); // _ZN10S1406C3_nt4v170Ev
  virtual void  v171(); // _ZN10S1406C3_nt4v171Ev
  virtual void  v172(); // _ZN10S1406C3_nt4v172Ev
  virtual void  v173(); // _ZN10S1406C3_nt4v173Ev
  virtual void  v174(); // _ZN10S1406C3_nt4v174Ev
  virtual void  v175(); // _ZN10S1406C3_nt4v175Ev
  virtual void  v176(); // _ZN10S1406C3_nt4v176Ev
  virtual void  v177(); // _ZN10S1406C3_nt4v177Ev
  virtual void  v178(); // _ZN10S1406C3_nt4v178Ev
  virtual void  v179(); // _ZN10S1406C3_nt4v179Ev
  virtual void  v180(); // _ZN10S1406C3_nt4v180Ev
  virtual void  v181(); // _ZN10S1406C3_nt4v181Ev
  virtual void  v182(); // _ZN10S1406C3_nt4v182Ev
  virtual void  v183(); // _ZN10S1406C3_nt4v183Ev
  virtual void  v184(); // _ZN10S1406C3_nt4v184Ev
  virtual void  v185(); // _ZN10S1406C3_nt4v185Ev
  virtual void  v186(); // _ZN10S1406C3_nt4v186Ev
  virtual void  v187(); // _ZN10S1406C3_nt4v187Ev
  virtual void  v188(); // _ZN10S1406C3_nt4v188Ev
  virtual void  v189(); // _ZN10S1406C3_nt4v189Ev
  virtual void  v190(); // _ZN10S1406C3_nt4v190Ev
  virtual void  v191(); // _ZN10S1406C3_nt4v191Ev
  virtual void  v192(); // _ZN10S1406C3_nt4v192Ev
  virtual void  v193(); // _ZN10S1406C3_nt4v193Ev
  virtual void  v194(); // _ZN10S1406C3_nt4v194Ev
  virtual void  v195(); // _ZN10S1406C3_nt4v195Ev
  virtual void  v196(); // _ZN10S1406C3_nt4v196Ev
  virtual void  v197(); // _ZN10S1406C3_nt4v197Ev
  virtual void  v198(); // _ZN10S1406C3_nt4v198Ev
  virtual void  v199(); // _ZN10S1406C3_nt4v199Ev
  virtual void  v200(); // _ZN10S1406C3_nt4v200Ev
  virtual void  v201(); // _ZN10S1406C3_nt4v201Ev
  virtual void  v202(); // _ZN10S1406C3_nt4v202Ev
  virtual void  v203(); // _ZN10S1406C3_nt4v203Ev
  virtual void  v204(); // _ZN10S1406C3_nt4v204Ev
  virtual void  v205(); // _ZN10S1406C3_nt4v205Ev
  virtual void  v206(); // _ZN10S1406C3_nt4v206Ev
  virtual void  v207(); // _ZN10S1406C3_nt4v207Ev
  virtual void  v208(); // _ZN10S1406C3_nt4v208Ev
  virtual void  v209(); // _ZN10S1406C3_nt4v209Ev
  virtual void  v210(); // _ZN10S1406C3_nt4v210Ev
  S1406C3_nt(); // tgen
};
//SIG(-1 S1406C3_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S1406C3_nt ::~S1406C3_nt(){ note_dtor("S1406C3_nt", this);}
void  S1406C3_nt ::v68(){vfunc_called(this, "_ZN10S1406C3_nt3v68Ev");}
void  S1406C3_nt ::v69(){vfunc_called(this, "_ZN10S1406C3_nt3v69Ev");}
void  S1406C3_nt ::v70(){vfunc_called(this, "_ZN10S1406C3_nt3v70Ev");}
void  S1406C3_nt ::v71(){vfunc_called(this, "_ZN10S1406C3_nt3v71Ev");}
void  S1406C3_nt ::v72(){vfunc_called(this, "_ZN10S1406C3_nt3v72Ev");}
void  S1406C3_nt ::v73(){vfunc_called(this, "_ZN10S1406C3_nt3v73Ev");}
void  S1406C3_nt ::v74(){vfunc_called(this, "_ZN10S1406C3_nt3v74Ev");}
void  S1406C3_nt ::v75(){vfunc_called(this, "_ZN10S1406C3_nt3v75Ev");}
void  S1406C3_nt ::v76(){vfunc_called(this, "_ZN10S1406C3_nt3v76Ev");}
void  S1406C3_nt ::v77(){vfunc_called(this, "_ZN10S1406C3_nt3v77Ev");}
void  S1406C3_nt ::v78(){vfunc_called(this, "_ZN10S1406C3_nt3v78Ev");}
void  S1406C3_nt ::v79(){vfunc_called(this, "_ZN10S1406C3_nt3v79Ev");}
void  S1406C3_nt ::v80(){vfunc_called(this, "_ZN10S1406C3_nt3v80Ev");}
void  S1406C3_nt ::v81(){vfunc_called(this, "_ZN10S1406C3_nt3v81Ev");}
void  S1406C3_nt ::v82(){vfunc_called(this, "_ZN10S1406C3_nt3v82Ev");}
void  S1406C3_nt ::v83(){vfunc_called(this, "_ZN10S1406C3_nt3v83Ev");}
void  S1406C3_nt ::v84(){vfunc_called(this, "_ZN10S1406C3_nt3v84Ev");}
void  S1406C3_nt ::v85(){vfunc_called(this, "_ZN10S1406C3_nt3v85Ev");}
void  S1406C3_nt ::v86(){vfunc_called(this, "_ZN10S1406C3_nt3v86Ev");}
void  S1406C3_nt ::v87(){vfunc_called(this, "_ZN10S1406C3_nt3v87Ev");}
void  S1406C3_nt ::v88(){vfunc_called(this, "_ZN10S1406C3_nt3v88Ev");}
void  S1406C3_nt ::v89(){vfunc_called(this, "_ZN10S1406C3_nt3v89Ev");}
void  S1406C3_nt ::v90(){vfunc_called(this, "_ZN10S1406C3_nt3v90Ev");}
void  S1406C3_nt ::v91(){vfunc_called(this, "_ZN10S1406C3_nt3v91Ev");}
void  S1406C3_nt ::v92(){vfunc_called(this, "_ZN10S1406C3_nt3v92Ev");}
void  S1406C3_nt ::v93(){vfunc_called(this, "_ZN10S1406C3_nt3v93Ev");}
void  S1406C3_nt ::v94(){vfunc_called(this, "_ZN10S1406C3_nt3v94Ev");}
void  S1406C3_nt ::v95(){vfunc_called(this, "_ZN10S1406C3_nt3v95Ev");}
void  S1406C3_nt ::v96(){vfunc_called(this, "_ZN10S1406C3_nt3v96Ev");}
void  S1406C3_nt ::v97(){vfunc_called(this, "_ZN10S1406C3_nt3v97Ev");}
void  S1406C3_nt ::v98(){vfunc_called(this, "_ZN10S1406C3_nt3v98Ev");}
void  S1406C3_nt ::v99(){vfunc_called(this, "_ZN10S1406C3_nt3v99Ev");}
void  S1406C3_nt ::v100(){vfunc_called(this, "_ZN10S1406C3_nt4v100Ev");}
void  S1406C3_nt ::v101(){vfunc_called(this, "_ZN10S1406C3_nt4v101Ev");}
void  S1406C3_nt ::v102(){vfunc_called(this, "_ZN10S1406C3_nt4v102Ev");}
void  S1406C3_nt ::v103(){vfunc_called(this, "_ZN10S1406C3_nt4v103Ev");}
void  S1406C3_nt ::v104(){vfunc_called(this, "_ZN10S1406C3_nt4v104Ev");}
void  S1406C3_nt ::v105(){vfunc_called(this, "_ZN10S1406C3_nt4v105Ev");}
void  S1406C3_nt ::v106(){vfunc_called(this, "_ZN10S1406C3_nt4v106Ev");}
void  S1406C3_nt ::v107(){vfunc_called(this, "_ZN10S1406C3_nt4v107Ev");}
void  S1406C3_nt ::v108(){vfunc_called(this, "_ZN10S1406C3_nt4v108Ev");}
void  S1406C3_nt ::v109(){vfunc_called(this, "_ZN10S1406C3_nt4v109Ev");}
void  S1406C3_nt ::v110(){vfunc_called(this, "_ZN10S1406C3_nt4v110Ev");}
void  S1406C3_nt ::v111(){vfunc_called(this, "_ZN10S1406C3_nt4v111Ev");}
void  S1406C3_nt ::v112(){vfunc_called(this, "_ZN10S1406C3_nt4v112Ev");}
void  S1406C3_nt ::v113(){vfunc_called(this, "_ZN10S1406C3_nt4v113Ev");}
void  S1406C3_nt ::v114(){vfunc_called(this, "_ZN10S1406C3_nt4v114Ev");}
void  S1406C3_nt ::v115(){vfunc_called(this, "_ZN10S1406C3_nt4v115Ev");}
void  S1406C3_nt ::v116(){vfunc_called(this, "_ZN10S1406C3_nt4v116Ev");}
void  S1406C3_nt ::v117(){vfunc_called(this, "_ZN10S1406C3_nt4v117Ev");}
void  S1406C3_nt ::v118(){vfunc_called(this, "_ZN10S1406C3_nt4v118Ev");}
void  S1406C3_nt ::v119(){vfunc_called(this, "_ZN10S1406C3_nt4v119Ev");}
void  S1406C3_nt ::v120(){vfunc_called(this, "_ZN10S1406C3_nt4v120Ev");}
void  S1406C3_nt ::v121(){vfunc_called(this, "_ZN10S1406C3_nt4v121Ev");}
void  S1406C3_nt ::v122(){vfunc_called(this, "_ZN10S1406C3_nt4v122Ev");}
void  S1406C3_nt ::v123(){vfunc_called(this, "_ZN10S1406C3_nt4v123Ev");}
void  S1406C3_nt ::v124(){vfunc_called(this, "_ZN10S1406C3_nt4v124Ev");}
void  S1406C3_nt ::v125(){vfunc_called(this, "_ZN10S1406C3_nt4v125Ev");}
void  S1406C3_nt ::v126(){vfunc_called(this, "_ZN10S1406C3_nt4v126Ev");}
void  S1406C3_nt ::v127(){vfunc_called(this, "_ZN10S1406C3_nt4v127Ev");}
void  S1406C3_nt ::v128(){vfunc_called(this, "_ZN10S1406C3_nt4v128Ev");}
void  S1406C3_nt ::v129(){vfunc_called(this, "_ZN10S1406C3_nt4v129Ev");}
void  S1406C3_nt ::v130(){vfunc_called(this, "_ZN10S1406C3_nt4v130Ev");}
void  S1406C3_nt ::v131(){vfunc_called(this, "_ZN10S1406C3_nt4v131Ev");}
void  S1406C3_nt ::v132(){vfunc_called(this, "_ZN10S1406C3_nt4v132Ev");}
void  S1406C3_nt ::v133(){vfunc_called(this, "_ZN10S1406C3_nt4v133Ev");}
void  S1406C3_nt ::v134(){vfunc_called(this, "_ZN10S1406C3_nt4v134Ev");}
void  S1406C3_nt ::v135(){vfunc_called(this, "_ZN10S1406C3_nt4v135Ev");}
void  S1406C3_nt ::v136(){vfunc_called(this, "_ZN10S1406C3_nt4v136Ev");}
void  S1406C3_nt ::v137(){vfunc_called(this, "_ZN10S1406C3_nt4v137Ev");}
void  S1406C3_nt ::v138(){vfunc_called(this, "_ZN10S1406C3_nt4v138Ev");}
void  S1406C3_nt ::v139(){vfunc_called(this, "_ZN10S1406C3_nt4v139Ev");}
void  S1406C3_nt ::v140(){vfunc_called(this, "_ZN10S1406C3_nt4v140Ev");}
void  S1406C3_nt ::v141(){vfunc_called(this, "_ZN10S1406C3_nt4v141Ev");}
void  S1406C3_nt ::v142(){vfunc_called(this, "_ZN10S1406C3_nt4v142Ev");}
void  S1406C3_nt ::v143(){vfunc_called(this, "_ZN10S1406C3_nt4v143Ev");}
void  S1406C3_nt ::v144(){vfunc_called(this, "_ZN10S1406C3_nt4v144Ev");}
void  S1406C3_nt ::v145(){vfunc_called(this, "_ZN10S1406C3_nt4v145Ev");}
void  S1406C3_nt ::v146(){vfunc_called(this, "_ZN10S1406C3_nt4v146Ev");}
void  S1406C3_nt ::v147(){vfunc_called(this, "_ZN10S1406C3_nt4v147Ev");}
void  S1406C3_nt ::v148(){vfunc_called(this, "_ZN10S1406C3_nt4v148Ev");}
void  S1406C3_nt ::v149(){vfunc_called(this, "_ZN10S1406C3_nt4v149Ev");}
void  S1406C3_nt ::v150(){vfunc_called(this, "_ZN10S1406C3_nt4v150Ev");}
void  S1406C3_nt ::v151(){vfunc_called(this, "_ZN10S1406C3_nt4v151Ev");}
void  S1406C3_nt ::v152(){vfunc_called(this, "_ZN10S1406C3_nt4v152Ev");}
void  S1406C3_nt ::v153(){vfunc_called(this, "_ZN10S1406C3_nt4v153Ev");}
void  S1406C3_nt ::v154(){vfunc_called(this, "_ZN10S1406C3_nt4v154Ev");}
void  S1406C3_nt ::v155(){vfunc_called(this, "_ZN10S1406C3_nt4v155Ev");}
void  S1406C3_nt ::v156(){vfunc_called(this, "_ZN10S1406C3_nt4v156Ev");}
void  S1406C3_nt ::v157(){vfunc_called(this, "_ZN10S1406C3_nt4v157Ev");}
void  S1406C3_nt ::v158(){vfunc_called(this, "_ZN10S1406C3_nt4v158Ev");}
void  S1406C3_nt ::v159(){vfunc_called(this, "_ZN10S1406C3_nt4v159Ev");}
void  S1406C3_nt ::v160(){vfunc_called(this, "_ZN10S1406C3_nt4v160Ev");}
void  S1406C3_nt ::v161(){vfunc_called(this, "_ZN10S1406C3_nt4v161Ev");}
void  S1406C3_nt ::v162(){vfunc_called(this, "_ZN10S1406C3_nt4v162Ev");}
void  S1406C3_nt ::v163(){vfunc_called(this, "_ZN10S1406C3_nt4v163Ev");}
void  S1406C3_nt ::v164(){vfunc_called(this, "_ZN10S1406C3_nt4v164Ev");}
void  S1406C3_nt ::v165(){vfunc_called(this, "_ZN10S1406C3_nt4v165Ev");}
void  S1406C3_nt ::v166(){vfunc_called(this, "_ZN10S1406C3_nt4v166Ev");}
void  S1406C3_nt ::v167(){vfunc_called(this, "_ZN10S1406C3_nt4v167Ev");}
void  S1406C3_nt ::v168(){vfunc_called(this, "_ZN10S1406C3_nt4v168Ev");}
void  S1406C3_nt ::v169(){vfunc_called(this, "_ZN10S1406C3_nt4v169Ev");}
void  S1406C3_nt ::v170(){vfunc_called(this, "_ZN10S1406C3_nt4v170Ev");}
void  S1406C3_nt ::v171(){vfunc_called(this, "_ZN10S1406C3_nt4v171Ev");}
void  S1406C3_nt ::v172(){vfunc_called(this, "_ZN10S1406C3_nt4v172Ev");}
void  S1406C3_nt ::v173(){vfunc_called(this, "_ZN10S1406C3_nt4v173Ev");}
void  S1406C3_nt ::v174(){vfunc_called(this, "_ZN10S1406C3_nt4v174Ev");}
void  S1406C3_nt ::v175(){vfunc_called(this, "_ZN10S1406C3_nt4v175Ev");}
void  S1406C3_nt ::v176(){vfunc_called(this, "_ZN10S1406C3_nt4v176Ev");}
void  S1406C3_nt ::v177(){vfunc_called(this, "_ZN10S1406C3_nt4v177Ev");}
void  S1406C3_nt ::v178(){vfunc_called(this, "_ZN10S1406C3_nt4v178Ev");}
void  S1406C3_nt ::v179(){vfunc_called(this, "_ZN10S1406C3_nt4v179Ev");}
void  S1406C3_nt ::v180(){vfunc_called(this, "_ZN10S1406C3_nt4v180Ev");}
void  S1406C3_nt ::v181(){vfunc_called(this, "_ZN10S1406C3_nt4v181Ev");}
void  S1406C3_nt ::v182(){vfunc_called(this, "_ZN10S1406C3_nt4v182Ev");}
void  S1406C3_nt ::v183(){vfunc_called(this, "_ZN10S1406C3_nt4v183Ev");}
void  S1406C3_nt ::v184(){vfunc_called(this, "_ZN10S1406C3_nt4v184Ev");}
void  S1406C3_nt ::v185(){vfunc_called(this, "_ZN10S1406C3_nt4v185Ev");}
void  S1406C3_nt ::v186(){vfunc_called(this, "_ZN10S1406C3_nt4v186Ev");}
void  S1406C3_nt ::v187(){vfunc_called(this, "_ZN10S1406C3_nt4v187Ev");}
void  S1406C3_nt ::v188(){vfunc_called(this, "_ZN10S1406C3_nt4v188Ev");}
void  S1406C3_nt ::v189(){vfunc_called(this, "_ZN10S1406C3_nt4v189Ev");}
void  S1406C3_nt ::v190(){vfunc_called(this, "_ZN10S1406C3_nt4v190Ev");}
void  S1406C3_nt ::v191(){vfunc_called(this, "_ZN10S1406C3_nt4v191Ev");}
void  S1406C3_nt ::v192(){vfunc_called(this, "_ZN10S1406C3_nt4v192Ev");}
void  S1406C3_nt ::v193(){vfunc_called(this, "_ZN10S1406C3_nt4v193Ev");}
void  S1406C3_nt ::v194(){vfunc_called(this, "_ZN10S1406C3_nt4v194Ev");}
void  S1406C3_nt ::v195(){vfunc_called(this, "_ZN10S1406C3_nt4v195Ev");}
void  S1406C3_nt ::v196(){vfunc_called(this, "_ZN10S1406C3_nt4v196Ev");}
void  S1406C3_nt ::v197(){vfunc_called(this, "_ZN10S1406C3_nt4v197Ev");}
void  S1406C3_nt ::v198(){vfunc_called(this, "_ZN10S1406C3_nt4v198Ev");}
void  S1406C3_nt ::v199(){vfunc_called(this, "_ZN10S1406C3_nt4v199Ev");}
void  S1406C3_nt ::v200(){vfunc_called(this, "_ZN10S1406C3_nt4v200Ev");}
void  S1406C3_nt ::v201(){vfunc_called(this, "_ZN10S1406C3_nt4v201Ev");}
void  S1406C3_nt ::v202(){vfunc_called(this, "_ZN10S1406C3_nt4v202Ev");}
void  S1406C3_nt ::v203(){vfunc_called(this, "_ZN10S1406C3_nt4v203Ev");}
void  S1406C3_nt ::v204(){vfunc_called(this, "_ZN10S1406C3_nt4v204Ev");}
void  S1406C3_nt ::v205(){vfunc_called(this, "_ZN10S1406C3_nt4v205Ev");}
void  S1406C3_nt ::v206(){vfunc_called(this, "_ZN10S1406C3_nt4v206Ev");}
void  S1406C3_nt ::v207(){vfunc_called(this, "_ZN10S1406C3_nt4v207Ev");}
void  S1406C3_nt ::v208(){vfunc_called(this, "_ZN10S1406C3_nt4v208Ev");}
void  S1406C3_nt ::v209(){vfunc_called(this, "_ZN10S1406C3_nt4v209Ev");}
void  S1406C3_nt ::v210(){vfunc_called(this, "_ZN10S1406C3_nt4v210Ev");}
S1406C3_nt ::S1406C3_nt(){ note_ctor("S1406C3_nt", this);} // tgen

//skip512 S1406C3_nt

#else // __cplusplus

extern void _ZN10S1406C3_ntC1Ev();
extern void _ZN10S1406C3_ntD1Ev();
Name_Map name_map_S1406C3_nt[] = {
  NSPAIR(_ZN10S1406C3_ntC1Ev),
  NSPAIR(_ZN10S1406C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1406C4_nt;
extern VTBL_ENTRY _ZTI10S1406C4_nt[];
extern  VTBL_ENTRY _ZTV10S1406C4_nt[];
static Base_Class bases_S1406C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1406C3_nt[];
extern void _ZN10S1406C3_ntD1Ev();
extern void _ZN10S1406C3_ntD0Ev();
extern void _ZN10S1406C4_nt2v4Ev();
extern void _ZN10S1406C4_nt2v5Ev();
extern void _ZN10S1406C4_nt2v6Ev();
extern void _ZN10S1406C4_nt2v7Ev();
extern void _ZN10S1406C4_nt2v8Ev();
extern void _ZN10S1406C4_nt2v9Ev();
extern void _ZN10S1406C4_nt3v10Ev();
extern void _ZN10S1406C4_nt3v11Ev();
extern void _ZN10S1406C4_nt3v12Ev();
extern void _ZN10S1406C4_nt3v13Ev();
extern void _ZN10S1406C4_nt3v14Ev();
extern void _ZN10S1406C4_nt3v15Ev();
extern void _ZN10S1406C4_nt3v16Ev();
extern void _ZN10S1406C4_nt3v17Ev();
extern void _ZN10S1406C4_nt3v18Ev();
extern void _ZN10S1406C4_nt3v19Ev();
extern void _ZN10S1406C4_nt3v20Ev();
extern void _ZN10S1406C4_nt3v21Ev();
extern void _ZN10S1406C4_nt3v22Ev();
extern void _ZN10S1406C4_nt3v23Ev();
extern void _ZN10S1406C4_nt3v24Ev();
extern void _ZN10S1406C4_nt3v25Ev();
extern void _ZN10S1406C4_nt3v26Ev();
extern void _ZN10S1406C4_nt3v27Ev();
extern void _ZN10S1406C4_nt3v28Ev();
extern void _ZN10S1406C4_nt3v29Ev();
extern void _ZN10S1406C4_nt3v30Ev();
extern void _ZN10S1406C4_nt3v31Ev();
extern void _ZN10S1406C4_nt3v32Ev();
extern void _ZN10S1406C4_nt3v33Ev();
extern void _ZN10S1406C4_nt3v34Ev();
extern void _ZN10S1406C4_nt3v35Ev();
extern void _ZN10S1406C4_nt3v36Ev();
extern void _ZN10S1406C4_nt3v37Ev();
extern void _ZN10S1406C4_nt3v38Ev();
extern void _ZN10S1406C4_nt3v39Ev();
extern void _ZN10S1406C4_nt3v40Ev();
extern void _ZN10S1406C4_nt3v41Ev();
extern void _ZN10S1406C4_nt3v42Ev();
extern void _ZN10S1406C4_nt3v43Ev();
extern void _ZN10S1406C4_nt3v44Ev();
extern void _ZN10S1406C4_nt3v45Ev();
extern void _ZN10S1406C4_nt3v46Ev();
extern void _ZN10S1406C4_nt3v47Ev();
extern void _ZN10S1406C4_nt3v48Ev();
extern void _ZN10S1406C4_nt3v49Ev();
extern void _ZN10S1406C4_nt3v50Ev();
extern void _ZN10S1406C4_nt3v51Ev();
extern void _ZN10S1406C4_nt3v52Ev();
extern void _ZN10S1406C4_nt3v53Ev();
extern void _ZN10S1406C4_nt3v54Ev();
extern void _ZN10S1406C4_nt3v55Ev();
extern void _ZN10S1406C4_nt3v56Ev();
extern void _ZN10S1406C4_nt3v57Ev();
extern void _ZN10S1406C4_nt3v58Ev();
extern void _ZN10S1406C4_nt3v59Ev();
extern void _ZN10S1406C4_nt3v60Ev();
extern void _ZN10S1406C4_nt3v61Ev();
extern void _ZN10S1406C4_nt3v62Ev();
extern void _ZN10S1406C4_nt3v63Ev();
extern void _ZN10S1406C4_nt3v64Ev();
extern void _ZN10S1406C4_nt3v65Ev();
extern void _ZN10S1406C4_nt3v66Ev();
extern void _ZN10S1406C4_nt3v67Ev();
extern void _ZN10S1406C3_nt3v68Ev();
extern void _ZN10S1406C3_nt3v69Ev();
extern void _ZN10S1406C3_nt3v70Ev();
extern void _ZN10S1406C3_nt3v71Ev();
extern void _ZN10S1406C3_nt3v72Ev();
extern void _ZN10S1406C3_nt3v73Ev();
extern void _ZN10S1406C3_nt3v74Ev();
extern void _ZN10S1406C3_nt3v75Ev();
extern void _ZN10S1406C3_nt3v76Ev();
extern void _ZN10S1406C3_nt3v77Ev();
extern void _ZN10S1406C3_nt3v78Ev();
extern void _ZN10S1406C3_nt3v79Ev();
extern void _ZN10S1406C3_nt3v80Ev();
extern void _ZN10S1406C3_nt3v81Ev();
extern void _ZN10S1406C3_nt3v82Ev();
extern void _ZN10S1406C3_nt3v83Ev();
extern void _ZN10S1406C3_nt3v84Ev();
extern void _ZN10S1406C3_nt3v85Ev();
extern void _ZN10S1406C3_nt3v86Ev();
extern void _ZN10S1406C3_nt3v87Ev();
extern void _ZN10S1406C3_nt3v88Ev();
extern void _ZN10S1406C3_nt3v89Ev();
extern void _ZN10S1406C3_nt3v90Ev();
extern void _ZN10S1406C3_nt3v91Ev();
extern void _ZN10S1406C3_nt3v92Ev();
extern void _ZN10S1406C3_nt3v93Ev();
extern void _ZN10S1406C3_nt3v94Ev();
extern void _ZN10S1406C3_nt3v95Ev();
extern void _ZN10S1406C3_nt3v96Ev();
extern void _ZN10S1406C3_nt3v97Ev();
extern void _ZN10S1406C3_nt3v98Ev();
extern void _ZN10S1406C3_nt3v99Ev();
extern void _ZN10S1406C3_nt4v100Ev();
extern void _ZN10S1406C3_nt4v101Ev();
extern void _ZN10S1406C3_nt4v102Ev();
extern void _ZN10S1406C3_nt4v103Ev();
extern void _ZN10S1406C3_nt4v104Ev();
extern void _ZN10S1406C3_nt4v105Ev();
extern void _ZN10S1406C3_nt4v106Ev();
extern void _ZN10S1406C3_nt4v107Ev();
extern void _ZN10S1406C3_nt4v108Ev();
extern void _ZN10S1406C3_nt4v109Ev();
extern void _ZN10S1406C3_nt4v110Ev();
extern void _ZN10S1406C3_nt4v111Ev();
extern void _ZN10S1406C3_nt4v112Ev();
extern void _ZN10S1406C3_nt4v113Ev();
extern void _ZN10S1406C3_nt4v114Ev();
extern void _ZN10S1406C3_nt4v115Ev();
extern void _ZN10S1406C3_nt4v116Ev();
extern void _ZN10S1406C3_nt4v117Ev();
extern void _ZN10S1406C3_nt4v118Ev();
extern void _ZN10S1406C3_nt4v119Ev();
extern void _ZN10S1406C3_nt4v120Ev();
extern void _ZN10S1406C3_nt4v121Ev();
extern void _ZN10S1406C3_nt4v122Ev();
extern void _ZN10S1406C3_nt4v123Ev();
extern void _ZN10S1406C3_nt4v124Ev();
extern void _ZN10S1406C3_nt4v125Ev();
extern void _ZN10S1406C3_nt4v126Ev();
extern void _ZN10S1406C3_nt4v127Ev();
extern void _ZN10S1406C3_nt4v128Ev();
extern void _ZN10S1406C3_nt4v129Ev();
extern void _ZN10S1406C3_nt4v130Ev();
extern void _ZN10S1406C3_nt4v131Ev();
extern void _ZN10S1406C3_nt4v132Ev();
extern void _ZN10S1406C3_nt4v133Ev();
extern void _ZN10S1406C3_nt4v134Ev();
extern void _ZN10S1406C3_nt4v135Ev();
extern void _ZN10S1406C3_nt4v136Ev();
extern void _ZN10S1406C3_nt4v137Ev();
extern void _ZN10S1406C3_nt4v138Ev();
extern void _ZN10S1406C3_nt4v139Ev();
extern void _ZN10S1406C3_nt4v140Ev();
extern void _ZN10S1406C3_nt4v141Ev();
extern void _ZN10S1406C3_nt4v142Ev();
extern void _ZN10S1406C3_nt4v143Ev();
extern void _ZN10S1406C3_nt4v144Ev();
extern void _ZN10S1406C3_nt4v145Ev();
extern void _ZN10S1406C3_nt4v146Ev();
extern void _ZN10S1406C3_nt4v147Ev();
extern void _ZN10S1406C3_nt4v148Ev();
extern void _ZN10S1406C3_nt4v149Ev();
extern void _ZN10S1406C3_nt4v150Ev();
extern void _ZN10S1406C3_nt4v151Ev();
extern void _ZN10S1406C3_nt4v152Ev();
extern void _ZN10S1406C3_nt4v153Ev();
extern void _ZN10S1406C3_nt4v154Ev();
extern void _ZN10S1406C3_nt4v155Ev();
extern void _ZN10S1406C3_nt4v156Ev();
extern void _ZN10S1406C3_nt4v157Ev();
extern void _ZN10S1406C3_nt4v158Ev();
extern void _ZN10S1406C3_nt4v159Ev();
extern void _ZN10S1406C3_nt4v160Ev();
extern void _ZN10S1406C3_nt4v161Ev();
extern void _ZN10S1406C3_nt4v162Ev();
extern void _ZN10S1406C3_nt4v163Ev();
extern void _ZN10S1406C3_nt4v164Ev();
extern void _ZN10S1406C3_nt4v165Ev();
extern void _ZN10S1406C3_nt4v166Ev();
extern void _ZN10S1406C3_nt4v167Ev();
extern void _ZN10S1406C3_nt4v168Ev();
extern void _ZN10S1406C3_nt4v169Ev();
extern void _ZN10S1406C3_nt4v170Ev();
extern void _ZN10S1406C3_nt4v171Ev();
extern void _ZN10S1406C3_nt4v172Ev();
extern void _ZN10S1406C3_nt4v173Ev();
extern void _ZN10S1406C3_nt4v174Ev();
extern void _ZN10S1406C3_nt4v175Ev();
extern void _ZN10S1406C3_nt4v176Ev();
extern void _ZN10S1406C3_nt4v177Ev();
extern void _ZN10S1406C3_nt4v178Ev();
extern void _ZN10S1406C3_nt4v179Ev();
extern void _ZN10S1406C3_nt4v180Ev();
extern void _ZN10S1406C3_nt4v181Ev();
extern void _ZN10S1406C3_nt4v182Ev();
extern void _ZN10S1406C3_nt4v183Ev();
extern void _ZN10S1406C3_nt4v184Ev();
extern void _ZN10S1406C3_nt4v185Ev();
extern void _ZN10S1406C3_nt4v186Ev();
extern void _ZN10S1406C3_nt4v187Ev();
extern void _ZN10S1406C3_nt4v188Ev();
extern void _ZN10S1406C3_nt4v189Ev();
extern void _ZN10S1406C3_nt4v190Ev();
extern void _ZN10S1406C3_nt4v191Ev();
extern void _ZN10S1406C3_nt4v192Ev();
extern void _ZN10S1406C3_nt4v193Ev();
extern void _ZN10S1406C3_nt4v194Ev();
extern void _ZN10S1406C3_nt4v195Ev();
extern void _ZN10S1406C3_nt4v196Ev();
extern void _ZN10S1406C3_nt4v197Ev();
extern void _ZN10S1406C3_nt4v198Ev();
extern void _ZN10S1406C3_nt4v199Ev();
extern void _ZN10S1406C3_nt4v200Ev();
extern void _ZN10S1406C3_nt4v201Ev();
extern void _ZN10S1406C3_nt4v202Ev();
extern void _ZN10S1406C3_nt4v203Ev();
extern void _ZN10S1406C3_nt4v204Ev();
extern void _ZN10S1406C3_nt4v205Ev();
extern void _ZN10S1406C3_nt4v206Ev();
extern void _ZN10S1406C3_nt4v207Ev();
extern void _ZN10S1406C3_nt4v208Ev();
extern void _ZN10S1406C3_nt4v209Ev();
extern void _ZN10S1406C3_nt4v210Ev();
static  VTBL_ENTRY vtc_S1406C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1406C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1406C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v210Ev,
};
extern VTBL_ENTRY _ZTI10S1406C3_nt[];
VTBL_ENTRY *P__ZTI10S1406C3_nt = _ZTI10S1406C3_nt; 
extern  VTBL_ENTRY _ZTV10S1406C3_nt[];
Class_Descriptor cd_S1406C3_nt = {  "S1406C3_nt", // class name
  bases_S1406C3_nt, 1,
  &(vtc_S1406C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1406C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1406C3_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C23_nt  {
  ::S1406C14_nt s1406c23f0;
  ::S1406C14_nt s1406c23f1;
  char s1406c23f2;
  void  mf1406c23(); // _ZN11S1406C23_nt9mf1406c23Ev
};
//SIG(-1 S1406C23_nt) C1{ m FC2{ m Fi[3]} FC2 Fc}


void  S1406C23_nt ::mf1406c23(){}

//skip512 S1406C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C22_nt  {
  ::S1406C23_nt s1406c22f0;
  ::S1406C14_nt s1406c22f1;
  void *s1406c22f2[2];
  char s1406c22f3;
  void  mf1406c22(); // _ZN11S1406C22_nt9mf1406c22Ev
};
//SIG(-1 S1406C22_nt) C1{ m FC2{ m FC3{ m Fi[3]} FC3 Fc} FC3 Fp[2] Fc}


void  S1406C22_nt ::mf1406c22(){}

//skip512 S1406C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C25  : S1406C8_nt {
};
//SIG(-1 S1406C25) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1406C25()
{
  extern Class_Descriptor cd_S1406C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1406C25, buf);
    S1406C25 &lv = *(new (buf) S1406C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1406C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1406C25)");
    check_base_class_offset(lv, (S1406C8_nt*), 0, "S1406C25");
    test_class_info(&lv, &cd_S1406C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1406C25(Test_S1406C25, "S1406C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
static Base_Class bases_S1406C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1406C25 = {  "S1406C25", // class name
  bases_S1406C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C24  : S1406C25 {
};
//SIG(-1 S1406C24) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1406C24()
{
  extern Class_Descriptor cd_S1406C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1406C24, buf);
    S1406C24 &lv = *(new (buf) S1406C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1406C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1406C24)");
    check_base_class_offset(lv, (S1406C8_nt*)(S1406C25*), 0, "S1406C24");
    check_base_class_offset(lv, (S1406C25*), 0, "S1406C24");
    test_class_info(&lv, &cd_S1406C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1406C24(Test_S1406C24, "S1406C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
extern Class_Descriptor cd_S1406C25;
static Base_Class bases_S1406C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1406C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1406C24 = {  "S1406C24", // class name
  bases_S1406C24, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C29  : S1406C8_nt {
};
//SIG(-1 S1406C29) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1406C29()
{
  extern Class_Descriptor cd_S1406C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1406C29, buf);
    S1406C29 &lv = *(new (buf) S1406C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1406C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1406C29)");
    check_base_class_offset(lv, (S1406C8_nt*), 0, "S1406C29");
    test_class_info(&lv, &cd_S1406C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1406C29(Test_S1406C29, "S1406C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
static Base_Class bases_S1406C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1406C29 = {  "S1406C29", // class name
  bases_S1406C29, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C28  : S1406C29 {
};
//SIG(-1 S1406C28) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1406C28()
{
  extern Class_Descriptor cd_S1406C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1406C28, buf);
    S1406C28 &lv = *(new (buf) S1406C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1406C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1406C28)");
    check_base_class_offset(lv, (S1406C8_nt*)(S1406C29*), 0, "S1406C28");
    check_base_class_offset(lv, (S1406C29*), 0, "S1406C28");
    test_class_info(&lv, &cd_S1406C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1406C28(Test_S1406C28, "S1406C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
extern Class_Descriptor cd_S1406C29;
static Base_Class bases_S1406C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1406C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1406C28 = {  "S1406C28", // class name
  bases_S1406C28, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C31_nt  {
  int s1406c31f0[4];
  void  mf1406c31(); // _ZN11S1406C31_nt9mf1406c31Ev
};
//SIG(-1 S1406C31_nt) C1{ m Fi[4]}


void  S1406C31_nt ::mf1406c31(){}

//skip512 S1406C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C2_nt  : S1406C3_nt {
  unsigned int s1406c2f0:1;
  unsigned int s1406c2f1:1;
  unsigned int s1406c2f2:1;
  unsigned int s1406c2f3:1;
  unsigned int s1406c2f4:1;
  ::S1406C22_nt s1406c2f5;
  unsigned int s1406c2f6:1;
  unsigned int s1406c2f7:1;
  unsigned int s1406c2f8:1;
  unsigned int s1406c2f9:1;
  unsigned int s1406c2f10:1;
  unsigned int s1406c2f11:1;
  unsigned int s1406c2f12:1;
  unsigned int s1406c2f13:1;
  unsigned int s1406c2f14:1;
  unsigned int s1406c2f15:1;
  unsigned int s1406c2f16:1;
  unsigned int s1406c2f17:1;
  unsigned int s1406c2f18:1;
  unsigned int s1406c2f19:1;
  unsigned int s1406c2f20:1;
  unsigned int s1406c2f21:1;
  unsigned int s1406c2f22:1;
  unsigned int s1406c2f23:1;
  unsigned int s1406c2f24:1;
  unsigned int s1406c2f25:1;
  unsigned int s1406c2f26:1;
  unsigned int s1406c2f27:1;
  unsigned int s1406c2f28:1;
  unsigned int s1406c2f29:1;
  unsigned int s1406c2f30:1;
  ::S1406C24 s1406c2f31;
  ::S1406C24 s1406c2f32;
  ::S1406C24 s1406c2f33;
  ::S1406C28 s1406c2f34;
  int s1406c2f35[2];
  void *s1406c2f36[4];
  int s1406c2f37[5];
  void *s1406c2f38;
  int s1406c2f39[2];
  void *s1406c2f40[2];
  int s1406c2f41;
  ::S1406C5_nt s1406c2f42;
  ::S1406C31_nt s1406c2f43;
  void *s1406c2f44[2];
  int s1406c2f45;
  void *s1406c2f46;
  int s1406c2f47;
  virtual  ~S1406C2_nt(); // _ZN10S1406C2_ntD1Ev
  virtual void  v211(); // _ZN10S1406C2_nt4v211Ev
  virtual void  v212(); // _ZN10S1406C2_nt4v212Ev
  virtual void  v213(); // _ZN10S1406C2_nt4v213Ev
  virtual void  v214(); // _ZN10S1406C2_nt4v214Ev
  virtual void  v215(); // _ZN10S1406C2_nt4v215Ev
  virtual void  v216(); // _ZN10S1406C2_nt4v216Ev
  virtual void  v217(); // _ZN10S1406C2_nt4v217Ev
  virtual void  v218(); // _ZN10S1406C2_nt4v218Ev
  virtual void  v219(); // _ZN10S1406C2_nt4v219Ev
  virtual void  v220(); // _ZN10S1406C2_nt4v220Ev
  virtual void  v221(); // _ZN10S1406C2_nt4v221Ev
  virtual void  v222(); // _ZN10S1406C2_nt4v222Ev
  virtual void  v223(); // _ZN10S1406C2_nt4v223Ev
  virtual void  v224(); // _ZN10S1406C2_nt4v224Ev
  virtual void  v225(); // _ZN10S1406C2_nt4v225Ev
  virtual void  v226(); // _ZN10S1406C2_nt4v226Ev
  virtual void  v227(); // _ZN10S1406C2_nt4v227Ev
  virtual void  v228(); // _ZN10S1406C2_nt4v228Ev
  virtual void  v229(); // _ZN10S1406C2_nt4v229Ev
  virtual void  v230(); // _ZN10S1406C2_nt4v230Ev
  virtual void  v231(); // _ZN10S1406C2_nt4v231Ev
  virtual void  v232(); // _ZN10S1406C2_nt4v232Ev
  virtual void  v233(); // _ZN10S1406C2_nt4v233Ev
  virtual void  v234(); // _ZN10S1406C2_nt4v234Ev
  virtual void  v235(); // _ZN10S1406C2_nt4v235Ev
  virtual void  v236(); // _ZN10S1406C2_nt4v236Ev
  virtual void  v237(); // _ZN10S1406C2_nt4v237Ev
  virtual void  v238(); // _ZN10S1406C2_nt4v238Ev
  virtual void  v239(); // _ZN10S1406C2_nt4v239Ev
  virtual void  v240(); // _ZN10S1406C2_nt4v240Ev
  virtual void  v241(); // _ZN10S1406C2_nt4v241Ev
  virtual void  v242(); // _ZN10S1406C2_nt4v242Ev
  virtual void  v243(); // _ZN10S1406C2_nt4v243Ev
  virtual void  v244(); // _ZN10S1406C2_nt4v244Ev
  virtual void  v245(); // _ZN10S1406C2_nt4v245Ev
  virtual void  v246(); // _ZN10S1406C2_nt4v246Ev
  virtual void  v247(); // _ZN10S1406C2_nt4v247Ev
  S1406C2_nt(); // tgen
};
//SIG(-1 S1406C2_nt) C1{ BC2{ BC3{ vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ m FC15{ m FC11 FC11 Fc} FC11 Fp[2] Fc} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC17{ BC7}} FC16 FC16 FC18{ BC19{ BC7}} Fi[2] Fp[4] Fi[5] Fp Fi[2] Fp[2] Fi FC4 FC20{ m Fi[4]} Fp[2] Fi Fp Fi}


 S1406C2_nt ::~S1406C2_nt(){ note_dtor("S1406C2_nt", this);}
void  S1406C2_nt ::v211(){vfunc_called(this, "_ZN10S1406C2_nt4v211Ev");}
void  S1406C2_nt ::v212(){vfunc_called(this, "_ZN10S1406C2_nt4v212Ev");}
void  S1406C2_nt ::v213(){vfunc_called(this, "_ZN10S1406C2_nt4v213Ev");}
void  S1406C2_nt ::v214(){vfunc_called(this, "_ZN10S1406C2_nt4v214Ev");}
void  S1406C2_nt ::v215(){vfunc_called(this, "_ZN10S1406C2_nt4v215Ev");}
void  S1406C2_nt ::v216(){vfunc_called(this, "_ZN10S1406C2_nt4v216Ev");}
void  S1406C2_nt ::v217(){vfunc_called(this, "_ZN10S1406C2_nt4v217Ev");}
void  S1406C2_nt ::v218(){vfunc_called(this, "_ZN10S1406C2_nt4v218Ev");}
void  S1406C2_nt ::v219(){vfunc_called(this, "_ZN10S1406C2_nt4v219Ev");}
void  S1406C2_nt ::v220(){vfunc_called(this, "_ZN10S1406C2_nt4v220Ev");}
void  S1406C2_nt ::v221(){vfunc_called(this, "_ZN10S1406C2_nt4v221Ev");}
void  S1406C2_nt ::v222(){vfunc_called(this, "_ZN10S1406C2_nt4v222Ev");}
void  S1406C2_nt ::v223(){vfunc_called(this, "_ZN10S1406C2_nt4v223Ev");}
void  S1406C2_nt ::v224(){vfunc_called(this, "_ZN10S1406C2_nt4v224Ev");}
void  S1406C2_nt ::v225(){vfunc_called(this, "_ZN10S1406C2_nt4v225Ev");}
void  S1406C2_nt ::v226(){vfunc_called(this, "_ZN10S1406C2_nt4v226Ev");}
void  S1406C2_nt ::v227(){vfunc_called(this, "_ZN10S1406C2_nt4v227Ev");}
void  S1406C2_nt ::v228(){vfunc_called(this, "_ZN10S1406C2_nt4v228Ev");}
void  S1406C2_nt ::v229(){vfunc_called(this, "_ZN10S1406C2_nt4v229Ev");}
void  S1406C2_nt ::v230(){vfunc_called(this, "_ZN10S1406C2_nt4v230Ev");}
void  S1406C2_nt ::v231(){vfunc_called(this, "_ZN10S1406C2_nt4v231Ev");}
void  S1406C2_nt ::v232(){vfunc_called(this, "_ZN10S1406C2_nt4v232Ev");}
void  S1406C2_nt ::v233(){vfunc_called(this, "_ZN10S1406C2_nt4v233Ev");}
void  S1406C2_nt ::v234(){vfunc_called(this, "_ZN10S1406C2_nt4v234Ev");}
void  S1406C2_nt ::v235(){vfunc_called(this, "_ZN10S1406C2_nt4v235Ev");}
void  S1406C2_nt ::v236(){vfunc_called(this, "_ZN10S1406C2_nt4v236Ev");}
void  S1406C2_nt ::v237(){vfunc_called(this, "_ZN10S1406C2_nt4v237Ev");}
void  S1406C2_nt ::v238(){vfunc_called(this, "_ZN10S1406C2_nt4v238Ev");}
void  S1406C2_nt ::v239(){vfunc_called(this, "_ZN10S1406C2_nt4v239Ev");}
void  S1406C2_nt ::v240(){vfunc_called(this, "_ZN10S1406C2_nt4v240Ev");}
void  S1406C2_nt ::v241(){vfunc_called(this, "_ZN10S1406C2_nt4v241Ev");}
void  S1406C2_nt ::v242(){vfunc_called(this, "_ZN10S1406C2_nt4v242Ev");}
void  S1406C2_nt ::v243(){vfunc_called(this, "_ZN10S1406C2_nt4v243Ev");}
void  S1406C2_nt ::v244(){vfunc_called(this, "_ZN10S1406C2_nt4v244Ev");}
void  S1406C2_nt ::v245(){vfunc_called(this, "_ZN10S1406C2_nt4v245Ev");}
void  S1406C2_nt ::v246(){vfunc_called(this, "_ZN10S1406C2_nt4v246Ev");}
void  S1406C2_nt ::v247(){vfunc_called(this, "_ZN10S1406C2_nt4v247Ev");}
S1406C2_nt ::S1406C2_nt(){ note_ctor("S1406C2_nt", this);} // tgen

//skip512 S1406C2_nt

#else // __cplusplus

extern void _ZN10S1406C2_ntC1Ev();
extern void _ZN10S1406C2_ntD1Ev();
Name_Map name_map_S1406C2_nt[] = {
  NSPAIR(_ZN10S1406C2_ntC1Ev),
  NSPAIR(_ZN10S1406C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1406C4_nt;
extern VTBL_ENTRY _ZTI10S1406C4_nt[];
extern  VTBL_ENTRY _ZTV10S1406C4_nt[];
extern Class_Descriptor cd_S1406C3_nt;
extern VTBL_ENTRY _ZTI10S1406C3_nt[];
extern  VTBL_ENTRY _ZTV10S1406C3_nt[];
static Base_Class bases_S1406C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1406C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1406C2_nt[];
extern void _ZN10S1406C2_ntD1Ev();
extern void _ZN10S1406C2_ntD0Ev();
extern void _ZN10S1406C4_nt2v4Ev();
extern void _ZN10S1406C4_nt2v5Ev();
extern void _ZN10S1406C4_nt2v6Ev();
extern void _ZN10S1406C4_nt2v7Ev();
extern void _ZN10S1406C4_nt2v8Ev();
extern void _ZN10S1406C4_nt2v9Ev();
extern void _ZN10S1406C4_nt3v10Ev();
extern void _ZN10S1406C4_nt3v11Ev();
extern void _ZN10S1406C4_nt3v12Ev();
extern void _ZN10S1406C4_nt3v13Ev();
extern void _ZN10S1406C4_nt3v14Ev();
extern void _ZN10S1406C4_nt3v15Ev();
extern void _ZN10S1406C4_nt3v16Ev();
extern void _ZN10S1406C4_nt3v17Ev();
extern void _ZN10S1406C4_nt3v18Ev();
extern void _ZN10S1406C4_nt3v19Ev();
extern void _ZN10S1406C4_nt3v20Ev();
extern void _ZN10S1406C4_nt3v21Ev();
extern void _ZN10S1406C4_nt3v22Ev();
extern void _ZN10S1406C4_nt3v23Ev();
extern void _ZN10S1406C4_nt3v24Ev();
extern void _ZN10S1406C4_nt3v25Ev();
extern void _ZN10S1406C4_nt3v26Ev();
extern void _ZN10S1406C4_nt3v27Ev();
extern void _ZN10S1406C4_nt3v28Ev();
extern void _ZN10S1406C4_nt3v29Ev();
extern void _ZN10S1406C4_nt3v30Ev();
extern void _ZN10S1406C4_nt3v31Ev();
extern void _ZN10S1406C4_nt3v32Ev();
extern void _ZN10S1406C4_nt3v33Ev();
extern void _ZN10S1406C4_nt3v34Ev();
extern void _ZN10S1406C4_nt3v35Ev();
extern void _ZN10S1406C4_nt3v36Ev();
extern void _ZN10S1406C4_nt3v37Ev();
extern void _ZN10S1406C4_nt3v38Ev();
extern void _ZN10S1406C4_nt3v39Ev();
extern void _ZN10S1406C4_nt3v40Ev();
extern void _ZN10S1406C4_nt3v41Ev();
extern void _ZN10S1406C4_nt3v42Ev();
extern void _ZN10S1406C4_nt3v43Ev();
extern void _ZN10S1406C4_nt3v44Ev();
extern void _ZN10S1406C4_nt3v45Ev();
extern void _ZN10S1406C4_nt3v46Ev();
extern void _ZN10S1406C4_nt3v47Ev();
extern void _ZN10S1406C4_nt3v48Ev();
extern void _ZN10S1406C4_nt3v49Ev();
extern void _ZN10S1406C4_nt3v50Ev();
extern void _ZN10S1406C4_nt3v51Ev();
extern void _ZN10S1406C4_nt3v52Ev();
extern void _ZN10S1406C4_nt3v53Ev();
extern void _ZN10S1406C4_nt3v54Ev();
extern void _ZN10S1406C4_nt3v55Ev();
extern void _ZN10S1406C4_nt3v56Ev();
extern void _ZN10S1406C4_nt3v57Ev();
extern void _ZN10S1406C4_nt3v58Ev();
extern void _ZN10S1406C4_nt3v59Ev();
extern void _ZN10S1406C4_nt3v60Ev();
extern void _ZN10S1406C4_nt3v61Ev();
extern void _ZN10S1406C4_nt3v62Ev();
extern void _ZN10S1406C4_nt3v63Ev();
extern void _ZN10S1406C4_nt3v64Ev();
extern void _ZN10S1406C4_nt3v65Ev();
extern void _ZN10S1406C4_nt3v66Ev();
extern void _ZN10S1406C4_nt3v67Ev();
extern void _ZN10S1406C3_nt3v68Ev();
extern void _ZN10S1406C3_nt3v69Ev();
extern void _ZN10S1406C3_nt3v70Ev();
extern void _ZN10S1406C3_nt3v71Ev();
extern void _ZN10S1406C3_nt3v72Ev();
extern void _ZN10S1406C3_nt3v73Ev();
extern void _ZN10S1406C3_nt3v74Ev();
extern void _ZN10S1406C3_nt3v75Ev();
extern void _ZN10S1406C3_nt3v76Ev();
extern void _ZN10S1406C3_nt3v77Ev();
extern void _ZN10S1406C3_nt3v78Ev();
extern void _ZN10S1406C3_nt3v79Ev();
extern void _ZN10S1406C3_nt3v80Ev();
extern void _ZN10S1406C3_nt3v81Ev();
extern void _ZN10S1406C3_nt3v82Ev();
extern void _ZN10S1406C3_nt3v83Ev();
extern void _ZN10S1406C3_nt3v84Ev();
extern void _ZN10S1406C3_nt3v85Ev();
extern void _ZN10S1406C3_nt3v86Ev();
extern void _ZN10S1406C3_nt3v87Ev();
extern void _ZN10S1406C3_nt3v88Ev();
extern void _ZN10S1406C3_nt3v89Ev();
extern void _ZN10S1406C3_nt3v90Ev();
extern void _ZN10S1406C3_nt3v91Ev();
extern void _ZN10S1406C3_nt3v92Ev();
extern void _ZN10S1406C3_nt3v93Ev();
extern void _ZN10S1406C3_nt3v94Ev();
extern void _ZN10S1406C3_nt3v95Ev();
extern void _ZN10S1406C3_nt3v96Ev();
extern void _ZN10S1406C3_nt3v97Ev();
extern void _ZN10S1406C3_nt3v98Ev();
extern void _ZN10S1406C3_nt3v99Ev();
extern void _ZN10S1406C3_nt4v100Ev();
extern void _ZN10S1406C3_nt4v101Ev();
extern void _ZN10S1406C3_nt4v102Ev();
extern void _ZN10S1406C3_nt4v103Ev();
extern void _ZN10S1406C3_nt4v104Ev();
extern void _ZN10S1406C3_nt4v105Ev();
extern void _ZN10S1406C3_nt4v106Ev();
extern void _ZN10S1406C3_nt4v107Ev();
extern void _ZN10S1406C3_nt4v108Ev();
extern void _ZN10S1406C3_nt4v109Ev();
extern void _ZN10S1406C3_nt4v110Ev();
extern void _ZN10S1406C3_nt4v111Ev();
extern void _ZN10S1406C3_nt4v112Ev();
extern void _ZN10S1406C3_nt4v113Ev();
extern void _ZN10S1406C3_nt4v114Ev();
extern void _ZN10S1406C3_nt4v115Ev();
extern void _ZN10S1406C3_nt4v116Ev();
extern void _ZN10S1406C3_nt4v117Ev();
extern void _ZN10S1406C3_nt4v118Ev();
extern void _ZN10S1406C3_nt4v119Ev();
extern void _ZN10S1406C3_nt4v120Ev();
extern void _ZN10S1406C3_nt4v121Ev();
extern void _ZN10S1406C3_nt4v122Ev();
extern void _ZN10S1406C3_nt4v123Ev();
extern void _ZN10S1406C3_nt4v124Ev();
extern void _ZN10S1406C3_nt4v125Ev();
extern void _ZN10S1406C3_nt4v126Ev();
extern void _ZN10S1406C3_nt4v127Ev();
extern void _ZN10S1406C3_nt4v128Ev();
extern void _ZN10S1406C3_nt4v129Ev();
extern void _ZN10S1406C3_nt4v130Ev();
extern void _ZN10S1406C3_nt4v131Ev();
extern void _ZN10S1406C3_nt4v132Ev();
extern void _ZN10S1406C3_nt4v133Ev();
extern void _ZN10S1406C3_nt4v134Ev();
extern void _ZN10S1406C3_nt4v135Ev();
extern void _ZN10S1406C3_nt4v136Ev();
extern void _ZN10S1406C3_nt4v137Ev();
extern void _ZN10S1406C3_nt4v138Ev();
extern void _ZN10S1406C3_nt4v139Ev();
extern void _ZN10S1406C3_nt4v140Ev();
extern void _ZN10S1406C3_nt4v141Ev();
extern void _ZN10S1406C3_nt4v142Ev();
extern void _ZN10S1406C3_nt4v143Ev();
extern void _ZN10S1406C3_nt4v144Ev();
extern void _ZN10S1406C3_nt4v145Ev();
extern void _ZN10S1406C3_nt4v146Ev();
extern void _ZN10S1406C3_nt4v147Ev();
extern void _ZN10S1406C3_nt4v148Ev();
extern void _ZN10S1406C3_nt4v149Ev();
extern void _ZN10S1406C3_nt4v150Ev();
extern void _ZN10S1406C3_nt4v151Ev();
extern void _ZN10S1406C3_nt4v152Ev();
extern void _ZN10S1406C3_nt4v153Ev();
extern void _ZN10S1406C3_nt4v154Ev();
extern void _ZN10S1406C3_nt4v155Ev();
extern void _ZN10S1406C3_nt4v156Ev();
extern void _ZN10S1406C3_nt4v157Ev();
extern void _ZN10S1406C3_nt4v158Ev();
extern void _ZN10S1406C3_nt4v159Ev();
extern void _ZN10S1406C3_nt4v160Ev();
extern void _ZN10S1406C3_nt4v161Ev();
extern void _ZN10S1406C3_nt4v162Ev();
extern void _ZN10S1406C3_nt4v163Ev();
extern void _ZN10S1406C3_nt4v164Ev();
extern void _ZN10S1406C3_nt4v165Ev();
extern void _ZN10S1406C3_nt4v166Ev();
extern void _ZN10S1406C3_nt4v167Ev();
extern void _ZN10S1406C3_nt4v168Ev();
extern void _ZN10S1406C3_nt4v169Ev();
extern void _ZN10S1406C3_nt4v170Ev();
extern void _ZN10S1406C3_nt4v171Ev();
extern void _ZN10S1406C3_nt4v172Ev();
extern void _ZN10S1406C3_nt4v173Ev();
extern void _ZN10S1406C3_nt4v174Ev();
extern void _ZN10S1406C3_nt4v175Ev();
extern void _ZN10S1406C3_nt4v176Ev();
extern void _ZN10S1406C3_nt4v177Ev();
extern void _ZN10S1406C3_nt4v178Ev();
extern void _ZN10S1406C3_nt4v179Ev();
extern void _ZN10S1406C3_nt4v180Ev();
extern void _ZN10S1406C3_nt4v181Ev();
extern void _ZN10S1406C3_nt4v182Ev();
extern void _ZN10S1406C3_nt4v183Ev();
extern void _ZN10S1406C3_nt4v184Ev();
extern void _ZN10S1406C3_nt4v185Ev();
extern void _ZN10S1406C3_nt4v186Ev();
extern void _ZN10S1406C3_nt4v187Ev();
extern void _ZN10S1406C3_nt4v188Ev();
extern void _ZN10S1406C3_nt4v189Ev();
extern void _ZN10S1406C3_nt4v190Ev();
extern void _ZN10S1406C3_nt4v191Ev();
extern void _ZN10S1406C3_nt4v192Ev();
extern void _ZN10S1406C3_nt4v193Ev();
extern void _ZN10S1406C3_nt4v194Ev();
extern void _ZN10S1406C3_nt4v195Ev();
extern void _ZN10S1406C3_nt4v196Ev();
extern void _ZN10S1406C3_nt4v197Ev();
extern void _ZN10S1406C3_nt4v198Ev();
extern void _ZN10S1406C3_nt4v199Ev();
extern void _ZN10S1406C3_nt4v200Ev();
extern void _ZN10S1406C3_nt4v201Ev();
extern void _ZN10S1406C3_nt4v202Ev();
extern void _ZN10S1406C3_nt4v203Ev();
extern void _ZN10S1406C3_nt4v204Ev();
extern void _ZN10S1406C3_nt4v205Ev();
extern void _ZN10S1406C3_nt4v206Ev();
extern void _ZN10S1406C3_nt4v207Ev();
extern void _ZN10S1406C3_nt4v208Ev();
extern void _ZN10S1406C3_nt4v209Ev();
extern void _ZN10S1406C3_nt4v210Ev();
extern void _ZN10S1406C2_nt4v211Ev();
extern void _ZN10S1406C2_nt4v212Ev();
extern void _ZN10S1406C2_nt4v213Ev();
extern void _ZN10S1406C2_nt4v214Ev();
extern void _ZN10S1406C2_nt4v215Ev();
extern void _ZN10S1406C2_nt4v216Ev();
extern void _ZN10S1406C2_nt4v217Ev();
extern void _ZN10S1406C2_nt4v218Ev();
extern void _ZN10S1406C2_nt4v219Ev();
extern void _ZN10S1406C2_nt4v220Ev();
extern void _ZN10S1406C2_nt4v221Ev();
extern void _ZN10S1406C2_nt4v222Ev();
extern void _ZN10S1406C2_nt4v223Ev();
extern void _ZN10S1406C2_nt4v224Ev();
extern void _ZN10S1406C2_nt4v225Ev();
extern void _ZN10S1406C2_nt4v226Ev();
extern void _ZN10S1406C2_nt4v227Ev();
extern void _ZN10S1406C2_nt4v228Ev();
extern void _ZN10S1406C2_nt4v229Ev();
extern void _ZN10S1406C2_nt4v230Ev();
extern void _ZN10S1406C2_nt4v231Ev();
extern void _ZN10S1406C2_nt4v232Ev();
extern void _ZN10S1406C2_nt4v233Ev();
extern void _ZN10S1406C2_nt4v234Ev();
extern void _ZN10S1406C2_nt4v235Ev();
extern void _ZN10S1406C2_nt4v236Ev();
extern void _ZN10S1406C2_nt4v237Ev();
extern void _ZN10S1406C2_nt4v238Ev();
extern void _ZN10S1406C2_nt4v239Ev();
extern void _ZN10S1406C2_nt4v240Ev();
extern void _ZN10S1406C2_nt4v241Ev();
extern void _ZN10S1406C2_nt4v242Ev();
extern void _ZN10S1406C2_nt4v243Ev();
extern void _ZN10S1406C2_nt4v244Ev();
extern void _ZN10S1406C2_nt4v245Ev();
extern void _ZN10S1406C2_nt4v246Ev();
extern void _ZN10S1406C2_nt4v247Ev();
static  VTBL_ENTRY vtc_S1406C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1406C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1406C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v237Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v238Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v239Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v240Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v241Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v242Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v243Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v244Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v245Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v246Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v247Ev,
};
extern VTBL_ENTRY _ZTI10S1406C2_nt[];
VTBL_ENTRY *P__ZTI10S1406C2_nt = _ZTI10S1406C2_nt; 
extern  VTBL_ENTRY _ZTV10S1406C2_nt[];
Class_Descriptor cd_S1406C2_nt = {  "S1406C2_nt", // class name
  bases_S1406C2_nt, 2,
  &(vtc_S1406C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(880,656), // object size
  NSPAIRA(_ZTI10S1406C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1406C2_nt),248, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1406C1  : S1406C2_nt {
  void *s1406c1f0;
  unsigned int s1406c1f1:1;
  virtual  ~S1406C1(); // _ZN7S1406C1D1Ev
  virtual void  v1(); // _ZN7S1406C12v1Ev
  virtual void  v2(); // _ZN7S1406C12v2Ev
  virtual void  v3(); // _ZN7S1406C12v3Ev
  S1406C1(); // tgen
};
//SIG(1 S1406C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ m FC16{ m FC12 FC12 Fc} FC12 Fp[2] Fc} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC17{ BC18{ BC8}} FC17 FC17 FC19{ BC20{ BC8}} Fi[2] Fp[4] Fi[5] Fp Fi[2] Fp[2] Fi FC5 FC21{ m Fi[4]} Fp[2] Fi Fp Fi} vd v1 v2 v3 Fp Fi:1}


 S1406C1 ::~S1406C1(){ note_dtor("S1406C1", this);}
void  S1406C1 ::v1(){vfunc_called(this, "_ZN7S1406C12v1Ev");}
void  S1406C1 ::v2(){vfunc_called(this, "_ZN7S1406C12v2Ev");}
void  S1406C1 ::v3(){vfunc_called(this, "_ZN7S1406C12v3Ev");}
S1406C1 ::S1406C1(){ note_ctor("S1406C1", this);} // tgen

static void Test_S1406C1()
{
  extern Class_Descriptor cd_S1406C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(113,167)];
    init_test(&cd_S1406C1, buf);
    S1406C1 *dp, &lv = *(dp=new (buf) S1406C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(896,664), "sizeof(S1406C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1406C1)");
    check_base_class_offset(lv, (S1406C4_nt*)(S1406C3_nt*)(S1406C2_nt*), 0, "S1406C1");
    check_base_class_offset(lv, (S1406C3_nt*)(S1406C2_nt*), 0, "S1406C1");
    check_base_class_offset(lv, (S1406C2_nt*), 0, "S1406C1");
    check_field_offset(lv, s1406c1f0, ABISELECT(880,656), "S1406C1.s1406c1f0");
    set_bf_and_test(lv, s1406c1f1, ABISELECT(888,660), 0, 1, 1, "S1406C1");
    test_class_info(&lv, &cd_S1406C1);
    dp->~S1406C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1406C1(Test_S1406C1, "S1406C1", ABISELECT(896,664));

#else // __cplusplus

extern void _ZN7S1406C1C1Ev();
extern void _ZN7S1406C1D1Ev();
Name_Map name_map_S1406C1[] = {
  NSPAIR(_ZN7S1406C1C1Ev),
  NSPAIR(_ZN7S1406C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1406C4_nt;
extern VTBL_ENTRY _ZTI10S1406C4_nt[];
extern  VTBL_ENTRY _ZTV10S1406C4_nt[];
extern Class_Descriptor cd_S1406C3_nt;
extern VTBL_ENTRY _ZTI10S1406C3_nt[];
extern  VTBL_ENTRY _ZTV10S1406C3_nt[];
extern Class_Descriptor cd_S1406C2_nt;
extern VTBL_ENTRY _ZTI10S1406C2_nt[];
extern  VTBL_ENTRY _ZTV10S1406C2_nt[];
static Base_Class bases_S1406C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1406C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1406C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1406C1[];
extern void _ZN7S1406C1D1Ev();
extern void _ZN7S1406C1D0Ev();
extern void _ZN10S1406C4_nt2v4Ev();
extern void _ZN10S1406C4_nt2v5Ev();
extern void _ZN10S1406C4_nt2v6Ev();
extern void _ZN10S1406C4_nt2v7Ev();
extern void _ZN10S1406C4_nt2v8Ev();
extern void _ZN10S1406C4_nt2v9Ev();
extern void _ZN10S1406C4_nt3v10Ev();
extern void _ZN10S1406C4_nt3v11Ev();
extern void _ZN10S1406C4_nt3v12Ev();
extern void _ZN10S1406C4_nt3v13Ev();
extern void _ZN10S1406C4_nt3v14Ev();
extern void _ZN10S1406C4_nt3v15Ev();
extern void _ZN10S1406C4_nt3v16Ev();
extern void _ZN10S1406C4_nt3v17Ev();
extern void _ZN10S1406C4_nt3v18Ev();
extern void _ZN10S1406C4_nt3v19Ev();
extern void _ZN10S1406C4_nt3v20Ev();
extern void _ZN10S1406C4_nt3v21Ev();
extern void _ZN10S1406C4_nt3v22Ev();
extern void _ZN10S1406C4_nt3v23Ev();
extern void _ZN10S1406C4_nt3v24Ev();
extern void _ZN10S1406C4_nt3v25Ev();
extern void _ZN10S1406C4_nt3v26Ev();
extern void _ZN10S1406C4_nt3v27Ev();
extern void _ZN10S1406C4_nt3v28Ev();
extern void _ZN10S1406C4_nt3v29Ev();
extern void _ZN10S1406C4_nt3v30Ev();
extern void _ZN10S1406C4_nt3v31Ev();
extern void _ZN10S1406C4_nt3v32Ev();
extern void _ZN10S1406C4_nt3v33Ev();
extern void _ZN10S1406C4_nt3v34Ev();
extern void _ZN10S1406C4_nt3v35Ev();
extern void _ZN10S1406C4_nt3v36Ev();
extern void _ZN10S1406C4_nt3v37Ev();
extern void _ZN10S1406C4_nt3v38Ev();
extern void _ZN10S1406C4_nt3v39Ev();
extern void _ZN10S1406C4_nt3v40Ev();
extern void _ZN10S1406C4_nt3v41Ev();
extern void _ZN10S1406C4_nt3v42Ev();
extern void _ZN10S1406C4_nt3v43Ev();
extern void _ZN10S1406C4_nt3v44Ev();
extern void _ZN10S1406C4_nt3v45Ev();
extern void _ZN10S1406C4_nt3v46Ev();
extern void _ZN10S1406C4_nt3v47Ev();
extern void _ZN10S1406C4_nt3v48Ev();
extern void _ZN10S1406C4_nt3v49Ev();
extern void _ZN10S1406C4_nt3v50Ev();
extern void _ZN10S1406C4_nt3v51Ev();
extern void _ZN10S1406C4_nt3v52Ev();
extern void _ZN10S1406C4_nt3v53Ev();
extern void _ZN10S1406C4_nt3v54Ev();
extern void _ZN10S1406C4_nt3v55Ev();
extern void _ZN10S1406C4_nt3v56Ev();
extern void _ZN10S1406C4_nt3v57Ev();
extern void _ZN10S1406C4_nt3v58Ev();
extern void _ZN10S1406C4_nt3v59Ev();
extern void _ZN10S1406C4_nt3v60Ev();
extern void _ZN10S1406C4_nt3v61Ev();
extern void _ZN10S1406C4_nt3v62Ev();
extern void _ZN10S1406C4_nt3v63Ev();
extern void _ZN10S1406C4_nt3v64Ev();
extern void _ZN10S1406C4_nt3v65Ev();
extern void _ZN10S1406C4_nt3v66Ev();
extern void _ZN10S1406C4_nt3v67Ev();
extern void _ZN10S1406C3_nt3v68Ev();
extern void _ZN10S1406C3_nt3v69Ev();
extern void _ZN10S1406C3_nt3v70Ev();
extern void _ZN10S1406C3_nt3v71Ev();
extern void _ZN10S1406C3_nt3v72Ev();
extern void _ZN10S1406C3_nt3v73Ev();
extern void _ZN10S1406C3_nt3v74Ev();
extern void _ZN10S1406C3_nt3v75Ev();
extern void _ZN10S1406C3_nt3v76Ev();
extern void _ZN10S1406C3_nt3v77Ev();
extern void _ZN10S1406C3_nt3v78Ev();
extern void _ZN10S1406C3_nt3v79Ev();
extern void _ZN10S1406C3_nt3v80Ev();
extern void _ZN10S1406C3_nt3v81Ev();
extern void _ZN10S1406C3_nt3v82Ev();
extern void _ZN10S1406C3_nt3v83Ev();
extern void _ZN10S1406C3_nt3v84Ev();
extern void _ZN10S1406C3_nt3v85Ev();
extern void _ZN10S1406C3_nt3v86Ev();
extern void _ZN10S1406C3_nt3v87Ev();
extern void _ZN10S1406C3_nt3v88Ev();
extern void _ZN10S1406C3_nt3v89Ev();
extern void _ZN10S1406C3_nt3v90Ev();
extern void _ZN10S1406C3_nt3v91Ev();
extern void _ZN10S1406C3_nt3v92Ev();
extern void _ZN10S1406C3_nt3v93Ev();
extern void _ZN10S1406C3_nt3v94Ev();
extern void _ZN10S1406C3_nt3v95Ev();
extern void _ZN10S1406C3_nt3v96Ev();
extern void _ZN10S1406C3_nt3v97Ev();
extern void _ZN10S1406C3_nt3v98Ev();
extern void _ZN10S1406C3_nt3v99Ev();
extern void _ZN10S1406C3_nt4v100Ev();
extern void _ZN10S1406C3_nt4v101Ev();
extern void _ZN10S1406C3_nt4v102Ev();
extern void _ZN10S1406C3_nt4v103Ev();
extern void _ZN10S1406C3_nt4v104Ev();
extern void _ZN10S1406C3_nt4v105Ev();
extern void _ZN10S1406C3_nt4v106Ev();
extern void _ZN10S1406C3_nt4v107Ev();
extern void _ZN10S1406C3_nt4v108Ev();
extern void _ZN10S1406C3_nt4v109Ev();
extern void _ZN10S1406C3_nt4v110Ev();
extern void _ZN10S1406C3_nt4v111Ev();
extern void _ZN10S1406C3_nt4v112Ev();
extern void _ZN10S1406C3_nt4v113Ev();
extern void _ZN10S1406C3_nt4v114Ev();
extern void _ZN10S1406C3_nt4v115Ev();
extern void _ZN10S1406C3_nt4v116Ev();
extern void _ZN10S1406C3_nt4v117Ev();
extern void _ZN10S1406C3_nt4v118Ev();
extern void _ZN10S1406C3_nt4v119Ev();
extern void _ZN10S1406C3_nt4v120Ev();
extern void _ZN10S1406C3_nt4v121Ev();
extern void _ZN10S1406C3_nt4v122Ev();
extern void _ZN10S1406C3_nt4v123Ev();
extern void _ZN10S1406C3_nt4v124Ev();
extern void _ZN10S1406C3_nt4v125Ev();
extern void _ZN10S1406C3_nt4v126Ev();
extern void _ZN10S1406C3_nt4v127Ev();
extern void _ZN10S1406C3_nt4v128Ev();
extern void _ZN10S1406C3_nt4v129Ev();
extern void _ZN10S1406C3_nt4v130Ev();
extern void _ZN10S1406C3_nt4v131Ev();
extern void _ZN10S1406C3_nt4v132Ev();
extern void _ZN10S1406C3_nt4v133Ev();
extern void _ZN10S1406C3_nt4v134Ev();
extern void _ZN10S1406C3_nt4v135Ev();
extern void _ZN10S1406C3_nt4v136Ev();
extern void _ZN10S1406C3_nt4v137Ev();
extern void _ZN10S1406C3_nt4v138Ev();
extern void _ZN10S1406C3_nt4v139Ev();
extern void _ZN10S1406C3_nt4v140Ev();
extern void _ZN10S1406C3_nt4v141Ev();
extern void _ZN10S1406C3_nt4v142Ev();
extern void _ZN10S1406C3_nt4v143Ev();
extern void _ZN10S1406C3_nt4v144Ev();
extern void _ZN10S1406C3_nt4v145Ev();
extern void _ZN10S1406C3_nt4v146Ev();
extern void _ZN10S1406C3_nt4v147Ev();
extern void _ZN10S1406C3_nt4v148Ev();
extern void _ZN10S1406C3_nt4v149Ev();
extern void _ZN10S1406C3_nt4v150Ev();
extern void _ZN10S1406C3_nt4v151Ev();
extern void _ZN10S1406C3_nt4v152Ev();
extern void _ZN10S1406C3_nt4v153Ev();
extern void _ZN10S1406C3_nt4v154Ev();
extern void _ZN10S1406C3_nt4v155Ev();
extern void _ZN10S1406C3_nt4v156Ev();
extern void _ZN10S1406C3_nt4v157Ev();
extern void _ZN10S1406C3_nt4v158Ev();
extern void _ZN10S1406C3_nt4v159Ev();
extern void _ZN10S1406C3_nt4v160Ev();
extern void _ZN10S1406C3_nt4v161Ev();
extern void _ZN10S1406C3_nt4v162Ev();
extern void _ZN10S1406C3_nt4v163Ev();
extern void _ZN10S1406C3_nt4v164Ev();
extern void _ZN10S1406C3_nt4v165Ev();
extern void _ZN10S1406C3_nt4v166Ev();
extern void _ZN10S1406C3_nt4v167Ev();
extern void _ZN10S1406C3_nt4v168Ev();
extern void _ZN10S1406C3_nt4v169Ev();
extern void _ZN10S1406C3_nt4v170Ev();
extern void _ZN10S1406C3_nt4v171Ev();
extern void _ZN10S1406C3_nt4v172Ev();
extern void _ZN10S1406C3_nt4v173Ev();
extern void _ZN10S1406C3_nt4v174Ev();
extern void _ZN10S1406C3_nt4v175Ev();
extern void _ZN10S1406C3_nt4v176Ev();
extern void _ZN10S1406C3_nt4v177Ev();
extern void _ZN10S1406C3_nt4v178Ev();
extern void _ZN10S1406C3_nt4v179Ev();
extern void _ZN10S1406C3_nt4v180Ev();
extern void _ZN10S1406C3_nt4v181Ev();
extern void _ZN10S1406C3_nt4v182Ev();
extern void _ZN10S1406C3_nt4v183Ev();
extern void _ZN10S1406C3_nt4v184Ev();
extern void _ZN10S1406C3_nt4v185Ev();
extern void _ZN10S1406C3_nt4v186Ev();
extern void _ZN10S1406C3_nt4v187Ev();
extern void _ZN10S1406C3_nt4v188Ev();
extern void _ZN10S1406C3_nt4v189Ev();
extern void _ZN10S1406C3_nt4v190Ev();
extern void _ZN10S1406C3_nt4v191Ev();
extern void _ZN10S1406C3_nt4v192Ev();
extern void _ZN10S1406C3_nt4v193Ev();
extern void _ZN10S1406C3_nt4v194Ev();
extern void _ZN10S1406C3_nt4v195Ev();
extern void _ZN10S1406C3_nt4v196Ev();
extern void _ZN10S1406C3_nt4v197Ev();
extern void _ZN10S1406C3_nt4v198Ev();
extern void _ZN10S1406C3_nt4v199Ev();
extern void _ZN10S1406C3_nt4v200Ev();
extern void _ZN10S1406C3_nt4v201Ev();
extern void _ZN10S1406C3_nt4v202Ev();
extern void _ZN10S1406C3_nt4v203Ev();
extern void _ZN10S1406C3_nt4v204Ev();
extern void _ZN10S1406C3_nt4v205Ev();
extern void _ZN10S1406C3_nt4v206Ev();
extern void _ZN10S1406C3_nt4v207Ev();
extern void _ZN10S1406C3_nt4v208Ev();
extern void _ZN10S1406C3_nt4v209Ev();
extern void _ZN10S1406C3_nt4v210Ev();
extern void _ZN10S1406C2_nt4v211Ev();
extern void _ZN10S1406C2_nt4v212Ev();
extern void _ZN10S1406C2_nt4v213Ev();
extern void _ZN10S1406C2_nt4v214Ev();
extern void _ZN10S1406C2_nt4v215Ev();
extern void _ZN10S1406C2_nt4v216Ev();
extern void _ZN10S1406C2_nt4v217Ev();
extern void _ZN10S1406C2_nt4v218Ev();
extern void _ZN10S1406C2_nt4v219Ev();
extern void _ZN10S1406C2_nt4v220Ev();
extern void _ZN10S1406C2_nt4v221Ev();
extern void _ZN10S1406C2_nt4v222Ev();
extern void _ZN10S1406C2_nt4v223Ev();
extern void _ZN10S1406C2_nt4v224Ev();
extern void _ZN10S1406C2_nt4v225Ev();
extern void _ZN10S1406C2_nt4v226Ev();
extern void _ZN10S1406C2_nt4v227Ev();
extern void _ZN10S1406C2_nt4v228Ev();
extern void _ZN10S1406C2_nt4v229Ev();
extern void _ZN10S1406C2_nt4v230Ev();
extern void _ZN10S1406C2_nt4v231Ev();
extern void _ZN10S1406C2_nt4v232Ev();
extern void _ZN10S1406C2_nt4v233Ev();
extern void _ZN10S1406C2_nt4v234Ev();
extern void _ZN10S1406C2_nt4v235Ev();
extern void _ZN10S1406C2_nt4v236Ev();
extern void _ZN10S1406C2_nt4v237Ev();
extern void _ZN10S1406C2_nt4v238Ev();
extern void _ZN10S1406C2_nt4v239Ev();
extern void _ZN10S1406C2_nt4v240Ev();
extern void _ZN10S1406C2_nt4v241Ev();
extern void _ZN10S1406C2_nt4v242Ev();
extern void _ZN10S1406C2_nt4v243Ev();
extern void _ZN10S1406C2_nt4v244Ev();
extern void _ZN10S1406C2_nt4v245Ev();
extern void _ZN10S1406C2_nt4v246Ev();
extern void _ZN10S1406C2_nt4v247Ev();
extern void _ZN7S1406C12v1Ev();
extern void _ZN7S1406C12v2Ev();
extern void _ZN7S1406C12v3Ev();
static  VTBL_ENTRY vtc_S1406C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1406C1[0]),
  (VTBL_ENTRY)&_ZN7S1406C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1406C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1406C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1406C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v237Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v238Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v239Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v240Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v241Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v242Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v243Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v244Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v245Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v246Ev,
  (VTBL_ENTRY)&_ZN10S1406C2_nt4v247Ev,
  (VTBL_ENTRY)&_ZN7S1406C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1406C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1406C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S1406C1[];
extern  VTBL_ENTRY _ZTV7S1406C1[];
Class_Descriptor cd_S1406C1 = {  "S1406C1", // class name
  bases_S1406C1, 3,
  &(vtc_S1406C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(896,664), // object size
  NSPAIRA(_ZTI7S1406C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1406C1),251, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C2_nt  {
  void *s16380c2f0[2];
  void  mf16380c2(); // _ZN11S16380C2_nt9mf16380c2Ev
};
//SIG(-1 S16380C2_nt) C1{ m Fp[2]}


void  S16380C2_nt ::mf16380c2(){}

//skip512 S16380C2_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C4  {
  void *s16380c4f0[2];
  void  mf16380c4(); // _ZN8S16380C49mf16380c4Ev
};
//SIG(-1 S16380C4) C1{ m Fp[2]}


void  S16380C4 ::mf16380c4(){}

static void Test_S16380C4()
{
  {
    init_simple_test("S16380C4");
    S16380C4 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S16380C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C4)");
    check_field_offset(lv, s16380c4f0, 0, "S16380C4.s16380c4f0");
  }
}
static Arrange_To_Call_Me vS16380C4(Test_S16380C4, "S16380C4", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C6  {
  void *s16380c6f0[2];
  void  mf16380c6(); // _ZN8S16380C69mf16380c6Ev
};
//SIG(-1 S16380C6) C1{ m Fp[2]}


void  S16380C6 ::mf16380c6(){}

static void Test_S16380C6()
{
  {
    init_simple_test("S16380C6");
    S16380C6 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S16380C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C6)");
    check_field_offset(lv, s16380c6f0, 0, "S16380C6.s16380c6f0");
  }
}
static Arrange_To_Call_Me vS16380C6(Test_S16380C6, "S16380C6", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C8  {
  void *s16380c8f0[2];
  void  mf16380c8(); // _ZN8S16380C89mf16380c8Ev
};
//SIG(-1 S16380C8) C1{ m Fp[2]}


void  S16380C8 ::mf16380c8(){}

static void Test_S16380C8()
{
  {
    init_simple_test("S16380C8");
    S16380C8 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S16380C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C8)");
    check_field_offset(lv, s16380c8f0, 0, "S16380C8.s16380c8f0");
  }
}
static Arrange_To_Call_Me vS16380C8(Test_S16380C8, "S16380C8", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C11_nt  {
  void  mf16380c11(); // _ZN12S16380C11_nt10mf16380c11Ev
};
//SIG(-1 S16380C11_nt) C1{ m}


void  S16380C11_nt ::mf16380c11(){}

//skip512 S16380C11_nt

#else // __cplusplus

Class_Descriptor cd_S16380C11_nt = {  "S16380C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C10_nt  {
  void *s16380c10f0;
  int s16380c10f1;
  ::S16380C11_nt s16380c10f2;
  void  mf16380c10(); // _ZN12S16380C10_nt10mf16380c10Ev
};
//SIG(-1 S16380C10_nt) C1{ m Fp Fi FC2{ m}}


void  S16380C10_nt ::mf16380c10(){}

//skip512 S16380C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C13_nt  {
  void *s16380c13f0;
  int s16380c13f1[2];
  ::S16380C11_nt s16380c13f2;
  void  mf16380c13(); // _ZN12S16380C13_nt10mf16380c13Ev
};
//SIG(-1 S16380C13_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S16380C13_nt ::mf16380c13(){}

//skip512 S16380C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C12  {
  ::S16380C10_nt s16380c12f0;
  ::S16380C13_nt s16380c12f1;
  void  mf16380c12(); // _ZN9S16380C1210mf16380c12Ev
};
//SIG(-1 S16380C12) C1{ m FC2{ m Fp Fi FC3{ m}} FC4{ m Fp Fi[2] FC3}}


void  S16380C12 ::mf16380c12(){}

static void Test_S16380C12()
{
  {
    init_simple_test("S16380C12");
    S16380C12 lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S16380C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C12)");
    check_field_offset(lv, s16380c12f0, 0, "S16380C12.s16380c12f0");
    check_field_offset(lv, s16380c12f1, ABISELECT(16,12), "S16380C12.s16380c12f1");
  }
}
static Arrange_To_Call_Me vS16380C12(Test_S16380C12, "S16380C12", ABISELECT(40,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C15  {
  void *s16380c15f0[2];
  void  mf16380c15(); // _ZN9S16380C1510mf16380c15Ev
};
//SIG(-1 S16380C15) C1{ m Fp[2]}


void  S16380C15 ::mf16380c15(){}

static void Test_S16380C15()
{
  {
    init_simple_test("S16380C15");
    S16380C15 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S16380C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C15)");
    check_field_offset(lv, s16380c15f0, 0, "S16380C15.s16380c15f0");
  }
}
static Arrange_To_Call_Me vS16380C15(Test_S16380C15, "S16380C15", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C17  {
  void *s16380c17f0[2];
  void  mf16380c17(); // _ZN9S16380C1710mf16380c17Ev
};
//SIG(-1 S16380C17) C1{ m Fp[2]}


void  S16380C17 ::mf16380c17(){}

static void Test_S16380C17()
{
  {
    init_simple_test("S16380C17");
    S16380C17 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S16380C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C17)");
    check_field_offset(lv, s16380c17f0, 0, "S16380C17.s16380c17f0");
  }
}
static Arrange_To_Call_Me vS16380C17(Test_S16380C17, "S16380C17", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C19  {
  void *s16380c19f0[2];
  void  mf16380c19(); // _ZN9S16380C1910mf16380c19Ev
};
//SIG(-1 S16380C19) C1{ m Fp[2]}


void  S16380C19 ::mf16380c19(){}

static void Test_S16380C19()
{
  {
    init_simple_test("S16380C19");
    S16380C19 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S16380C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C19)");
    check_field_offset(lv, s16380c19f0, 0, "S16380C19.s16380c19f0");
  }
}
static Arrange_To_Call_Me vS16380C19(Test_S16380C19, "S16380C19", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C21  {
  void *s16380c21f0[2];
  void  mf16380c21(); // _ZN9S16380C2110mf16380c21Ev
};
//SIG(-1 S16380C21) C1{ m Fp[2]}


void  S16380C21 ::mf16380c21(){}

static void Test_S16380C21()
{
  {
    init_simple_test("S16380C21");
    S16380C21 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S16380C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C21)");
    check_field_offset(lv, s16380c21f0, 0, "S16380C21.s16380c21f0");
  }
}
static Arrange_To_Call_Me vS16380C21(Test_S16380C21, "S16380C21", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C24  {
  void *s16380c24f0[2];
  void  mf16380c24(); // _ZN9S16380C2410mf16380c24Ev
};
//SIG(-1 S16380C24) C1{ m Fp[2]}


void  S16380C24 ::mf16380c24(){}

static void Test_S16380C24()
{
  {
    init_simple_test("S16380C24");
    S16380C24 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S16380C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C24)");
    check_field_offset(lv, s16380c24f0, 0, "S16380C24.s16380c24f0");
  }
}
static Arrange_To_Call_Me vS16380C24(Test_S16380C24, "S16380C24", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C26_nt  {
  __tsi64 s16380c26f0;
  void  mf16380c26(); // _ZN12S16380C26_nt10mf16380c26Ev
};
//SIG(-1 S16380C26_nt) C1{ m FL}


void  S16380C26_nt ::mf16380c26(){}

//skip512 S16380C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C25_nt  {
  ::S16380C26_nt s16380c25f0;
  void  mf16380c25(); // _ZN12S16380C25_nt10mf16380c25Ev
};
//SIG(-1 S16380C25_nt) C1{ m FC2{ m FL}}


void  S16380C25_nt ::mf16380c25(){}

//skip512 S16380C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C30  {
  int s16380c30f0;
  char s16380c30f1;
  int s16380c30f2;
  char s16380c30f3[2];
  int s16380c30f4[5];
  void  mf16380c30(); // _ZN9S16380C3010mf16380c30Ev
};
//SIG(-1 S16380C30) C1{ m Fi Fc Fi Fc[2] Fi[5]}


void  S16380C30 ::mf16380c30(){}

static void Test_S16380C30()
{
  {
    init_simple_test("S16380C30");
    S16380C30 lv;
    check2(sizeof(lv), 36, "sizeof(S16380C30)");
    check2(__alignof__(lv), 4, "__alignof__(S16380C30)");
    check_field_offset(lv, s16380c30f0, 0, "S16380C30.s16380c30f0");
    check_field_offset(lv, s16380c30f1, 4, "S16380C30.s16380c30f1");
    check_field_offset(lv, s16380c30f2, 8, "S16380C30.s16380c30f2");
    check_field_offset(lv, s16380c30f3, 12, "S16380C30.s16380c30f3");
    check_field_offset(lv, s16380c30f4, 16, "S16380C30.s16380c30f4");
  }
}
static Arrange_To_Call_Me vS16380C30(Test_S16380C30, "S16380C30", 36);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C33_nt  {
  ::S16380C25_nt s16380c33f0;
  ::S16380C25_nt s16380c33f1;
  void  mf16380c33(); // _ZN12S16380C33_nt10mf16380c33Ev
};
//SIG(-1 S16380C33_nt) C1{ m FC2{ m FC3{ m FL}} FC2}


void  S16380C33_nt ::mf16380c33(){}

//skip512 S16380C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C32_nt  {
  ::S16380C33_nt s16380c32f0;
  ::S16380C33_nt s16380c32f1;
  void  mf16380c32(); // _ZN12S16380C32_nt10mf16380c32Ev
};
//SIG(-1 S16380C32_nt) C1{ m FC2{ m FC3{ m FC4{ m FL}} FC3} FC2}


void  S16380C32_nt ::mf16380c32(){}

//skip512 S16380C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C37_nt  {
  void *s16380c37f0[4];
  void  mf16380c37(); // _ZN12S16380C37_nt10mf16380c37Ev
};
//SIG(-1 S16380C37_nt) C1{ m Fp[4]}


void  S16380C37_nt ::mf16380c37(){}

//skip512 S16380C37_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C36_nt  {
  ::S16380C37_nt s16380c36f0;
  virtual  ~S16380C36_nt(); // _ZN12S16380C36_ntD1Ev
  virtual void  v7(); // _ZN12S16380C36_nt2v7Ev
  virtual void  v8(); // _ZN12S16380C36_nt2v8Ev
  virtual void  v9(); // _ZN12S16380C36_nt2v9Ev
  virtual void  v10(); // _ZN12S16380C36_nt3v10Ev
  virtual void  v11(); // _ZN12S16380C36_nt3v11Ev
  virtual void  v12(); // _ZN12S16380C36_nt3v12Ev
  S16380C36_nt(); // tgen
};
//SIG(-1 S16380C36_nt) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S16380C36_nt ::~S16380C36_nt(){ note_dtor("S16380C36_nt", this);}
void  S16380C36_nt ::v7(){vfunc_called(this, "_ZN12S16380C36_nt2v7Ev");}
void  S16380C36_nt ::v8(){vfunc_called(this, "_ZN12S16380C36_nt2v8Ev");}
void  S16380C36_nt ::v9(){vfunc_called(this, "_ZN12S16380C36_nt2v9Ev");}
void  S16380C36_nt ::v10(){vfunc_called(this, "_ZN12S16380C36_nt3v10Ev");}
void  S16380C36_nt ::v11(){vfunc_called(this, "_ZN12S16380C36_nt3v11Ev");}
void  S16380C36_nt ::v12(){vfunc_called(this, "_ZN12S16380C36_nt3v12Ev");}
S16380C36_nt ::S16380C36_nt(){ note_ctor("S16380C36_nt", this);} // tgen

//skip512 S16380C36_nt

#else // __cplusplus

extern void _ZN12S16380C36_ntC1Ev();
extern void _ZN12S16380C36_ntD1Ev();
Name_Map name_map_S16380C36_nt[] = {
  NSPAIR(_ZN12S16380C36_ntC1Ev),
  NSPAIR(_ZN12S16380C36_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S16380C36_nt[];
extern void _ZN12S16380C36_ntD1Ev();
extern void _ZN12S16380C36_ntD0Ev();
extern void _ZN12S16380C36_nt2v7Ev();
extern void _ZN12S16380C36_nt2v8Ev();
extern void _ZN12S16380C36_nt2v9Ev();
extern void _ZN12S16380C36_nt3v10Ev();
extern void _ZN12S16380C36_nt3v11Ev();
extern void _ZN12S16380C36_nt3v12Ev();
static  VTBL_ENTRY vtc_S16380C36_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S16380C36_nt[0]),
  (VTBL_ENTRY)&_ZN12S16380C36_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v12Ev,
};
extern VTBL_ENTRY _ZTI12S16380C36_nt[];
VTBL_ENTRY *P__ZTI12S16380C36_nt = _ZTI12S16380C36_nt; 
extern  VTBL_ENTRY _ZTV12S16380C36_nt[];
Class_Descriptor cd_S16380C36_nt = {  "S16380C36_nt", // class name
  0,0,//no base classes
  &(vtc_S16380C36_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI12S16380C36_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S16380C36_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C38_nt  {
};
//SIG(-1 S16380C38_nt) C1{}



//skip512 S16380C38_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S16380C38_nt[];
VTBL_ENTRY *P__ZTI12S16380C38_nt = _ZTI12S16380C38_nt; 
Class_Descriptor cd_S16380C38_nt = {  "S16380C38_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI12S16380C38_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C40_nt  {
  void *s16380c40f0;
  int s16380c40f1;
  void *s16380c40f2;
  int s16380c40f3[2];
  void  mf16380c40(); // _ZN12S16380C40_nt10mf16380c40Ev
};
//SIG(-1 S16380C40_nt) C1{ m Fp Fi Fp Fi[2]}


void  S16380C40_nt ::mf16380c40(){}

//skip512 S16380C40_nt

#else // __cplusplus

Class_Descriptor cd_S16380C40_nt = {  "S16380C40_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C42_nt  {
  void *s16380c42f0;
  void  mf16380c42(); // _ZN12S16380C42_nt10mf16380c42Ev
};
//SIG(-1 S16380C42_nt) C1{ m Fp}


void  S16380C42_nt ::mf16380c42(){}

//skip512 S16380C42_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C41_nt  {
  ::S16380C24 s16380c41f0;
  ::S16380C42_nt s16380c41f1;
  void  mf16380c41(); // _ZN12S16380C41_nt10mf16380c41Ev
};
//SIG(-1 S16380C41_nt) C1{ m FC2{ m Fp[2]} FC3{ m Fp}}


void  S16380C41_nt ::mf16380c41(){}

//skip512 S16380C41_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C39_nt  : S16380C40_nt {
  ::S16380C41_nt s16380c39f0;
};
//SIG(-1 S16380C39_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m Fp[2]} FC5{ m Fp}}}



//skip512 S16380C39_nt

#else // __cplusplus

extern Class_Descriptor cd_S16380C40_nt;
static Base_Class bases_S16380C39_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C40_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C43_nt  : S16380C40_nt {
  int s16380c43f0;
};
//SIG(-1 S16380C43_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} Fi}



//skip512 S16380C43_nt

#else // __cplusplus

extern Class_Descriptor cd_S16380C40_nt;
static Base_Class bases_S16380C43_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C40_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C35_nt  : S16380C36_nt , S16380C38_nt {
  ::S16380C39_nt s16380c35f0;
  ::S16380C43_nt s16380c35f1;
  virtual void  v1(); // _ZN12S16380C35_nt2v1Ev
  virtual void  v2(); // _ZN12S16380C35_nt2v2Ev
  virtual void  v3(); // _ZN12S16380C35_nt2v3Ev
  virtual void  v4(); // _ZN12S16380C35_nt2v4Ev
  virtual void  v5(); // _ZN12S16380C35_nt2v5Ev
  virtual void  v6(); // _ZN12S16380C35_nt2v6Ev
  ~S16380C35_nt(); // tgen
  S16380C35_nt(); // tgen
};
//SIG(-1 S16380C35_nt) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 Fi}}


void  S16380C35_nt ::v1(){vfunc_called(this, "_ZN12S16380C35_nt2v1Ev");}
void  S16380C35_nt ::v2(){vfunc_called(this, "_ZN12S16380C35_nt2v2Ev");}
void  S16380C35_nt ::v3(){vfunc_called(this, "_ZN12S16380C35_nt2v3Ev");}
void  S16380C35_nt ::v4(){vfunc_called(this, "_ZN12S16380C35_nt2v4Ev");}
void  S16380C35_nt ::v5(){vfunc_called(this, "_ZN12S16380C35_nt2v5Ev");}
void  S16380C35_nt ::v6(){vfunc_called(this, "_ZN12S16380C35_nt2v6Ev");}
S16380C35_nt ::~S16380C35_nt(){ note_dtor("S16380C35_nt", this);} // tgen
S16380C35_nt ::S16380C35_nt(){ note_ctor("S16380C35_nt", this);} // tgen

//skip512 S16380C35_nt

#else // __cplusplus

extern void _ZN12S16380C35_ntC1Ev();
extern void _ZN12S16380C35_ntD1Ev();
Name_Map name_map_S16380C35_nt[] = {
  NSPAIR(_ZN12S16380C35_ntC1Ev),
  NSPAIR(_ZN12S16380C35_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S16380C36_nt;
extern VTBL_ENTRY _ZTI12S16380C36_nt[];
extern  VTBL_ENTRY _ZTV12S16380C36_nt[];
extern Class_Descriptor cd_S16380C38_nt;
extern VTBL_ENTRY _ZTI12S16380C38_nt[];
static Base_Class bases_S16380C35_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C36_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S16380C38_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S16380C35_nt[];
extern void _ZN12S16380C35_ntD1Ev();
extern void _ZN12S16380C35_ntD0Ev();
extern void _ZN12S16380C36_nt2v7Ev();
extern void _ZN12S16380C36_nt2v8Ev();
extern void _ZN12S16380C36_nt2v9Ev();
extern void _ZN12S16380C36_nt3v10Ev();
extern void _ZN12S16380C36_nt3v11Ev();
extern void _ZN12S16380C36_nt3v12Ev();
extern void _ZN12S16380C35_nt2v1Ev();
extern void _ZN12S16380C35_nt2v2Ev();
extern void _ZN12S16380C35_nt2v3Ev();
extern void _ZN12S16380C35_nt2v4Ev();
extern void _ZN12S16380C35_nt2v5Ev();
extern void _ZN12S16380C35_nt2v6Ev();
static  VTBL_ENTRY vtc_S16380C35_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S16380C35_nt[0]),
  (VTBL_ENTRY)&_ZN12S16380C35_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S16380C35_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v12Ev,
  (VTBL_ENTRY)&_ZN12S16380C35_nt2v1Ev,
  (VTBL_ENTRY)&_ZN12S16380C35_nt2v2Ev,
  (VTBL_ENTRY)&_ZN12S16380C35_nt2v3Ev,
  (VTBL_ENTRY)&_ZN12S16380C35_nt2v4Ev,
  (VTBL_ENTRY)&_ZN12S16380C35_nt2v5Ev,
  (VTBL_ENTRY)&_ZN12S16380C35_nt2v6Ev,
};
extern VTBL_ENTRY _ZTI12S16380C35_nt[];
VTBL_ENTRY *P__ZTI12S16380C35_nt = _ZTI12S16380C35_nt; 
extern  VTBL_ENTRY _ZTV12S16380C35_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C46_nt  {
  virtual  ~S16380C46_nt(); // _ZN12S16380C46_ntD1Ev
  virtual void  v13(); // _ZN12S16380C46_nt3v13Ev
  S16380C46_nt(); // tgen
};
//SIG(-1 S16380C46_nt) C1{ vd v1}


 S16380C46_nt ::~S16380C46_nt(){ note_dtor("S16380C46_nt", this);}
void  S16380C46_nt ::v13(){vfunc_called(this, "_ZN12S16380C46_nt3v13Ev");}
S16380C46_nt ::S16380C46_nt(){ note_ctor("S16380C46_nt", this);} // tgen

//skip512 S16380C46_nt

#else // __cplusplus

extern void _ZN12S16380C46_ntC1Ev();
extern void _ZN12S16380C46_ntD1Ev();
Name_Map name_map_S16380C46_nt[] = {
  NSPAIR(_ZN12S16380C46_ntC1Ev),
  NSPAIR(_ZN12S16380C46_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S16380C46_nt[];
extern void _ZN12S16380C46_ntD1Ev();
extern void _ZN12S16380C46_ntD0Ev();
extern void _ZN12S16380C46_nt3v13Ev();
static  VTBL_ENTRY vtc_S16380C46_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S16380C46_nt[0]),
  (VTBL_ENTRY)&_ZN12S16380C46_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S16380C46_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S16380C46_nt3v13Ev,
};
extern VTBL_ENTRY _ZTI12S16380C46_nt[];
VTBL_ENTRY *P__ZTI12S16380C46_nt = _ZTI12S16380C46_nt; 
extern  VTBL_ENTRY _ZTV12S16380C46_nt[];
Class_Descriptor cd_S16380C46_nt = {  "S16380C46_nt", // class name
  0,0,//no base classes
  &(vtc_S16380C46_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S16380C46_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S16380C46_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C49  {
  void  mf16380c49(); // _ZN9S16380C4910mf16380c49Ev
};
//SIG(-1 S16380C49) C1{ m}


void  S16380C49 ::mf16380c49(){}

static void Test_S16380C49()
{
  {
    init_simple_test("S16380C49");
    S16380C49 lv;
    check2(sizeof(lv), 1, "sizeof(S16380C49)");
    check2(__alignof__(lv), 1, "__alignof__(S16380C49)");
  }
}
static Arrange_To_Call_Me vS16380C49(Test_S16380C49, "S16380C49", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S16380C49[];
VTBL_ENTRY *P__ZTI9S16380C49 = _ZTI9S16380C49; 
Class_Descriptor cd_S16380C49 = {  "S16380C49", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI9S16380C49),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C48  {
  void *s16380c48f0;
  int s16380c48f1[2];
  ::S16380C49 s16380c48f2;
  void  mf16380c48(); // _ZN9S16380C4810mf16380c48Ev
};
//SIG(-1 S16380C48) C1{ m Fp Fi[2] FC2{ m}}


void  S16380C48 ::mf16380c48(){}

static void Test_S16380C48()
{
  {
    init_simple_test("S16380C48");
    S16380C48 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S16380C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C48)");
    check_field_offset(lv, s16380c48f0, 0, "S16380C48.s16380c48f0");
    check_field_offset(lv, s16380c48f1, ABISELECT(8,4), "S16380C48.s16380c48f1");
    check_field_offset(lv, s16380c48f2, ABISELECT(16,12), "S16380C48.s16380c48f2");
  }
}
static Arrange_To_Call_Me vS16380C48(Test_S16380C48, "S16380C48", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C47_nt  {
  ::S16380C48 s16380c47f0;
  void  mf16380c47(); // _ZN12S16380C47_nt10mf16380c47Ev
};
//SIG(-1 S16380C47_nt) C1{ m FC2{ m Fp Fi[2] FC3{ m}}}


void  S16380C47_nt ::mf16380c47(){}

//skip512 S16380C47_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C45_nt  : S16380C46_nt {
  void *s16380c45f0[2];
  ::S16380C47_nt s16380c45f1;
  ::S16380C24 s16380c45f2;
  virtual  ~S16380C45_nt(); // _ZN12S16380C45_ntD1Ev
  virtual void  v14(); // _ZN12S16380C45_nt3v14Ev
  S16380C45_nt(); // tgen
};
//SIG(-1 S16380C45_nt) C1{ BC2{ vd v2} vd v1 Fp[2] FC3{ m FC4{ m Fp Fi[2] FC5{ m}}} FC6{ m Fp[2]}}


 S16380C45_nt ::~S16380C45_nt(){ note_dtor("S16380C45_nt", this);}
void  S16380C45_nt ::v14(){vfunc_called(this, "_ZN12S16380C45_nt3v14Ev");}
S16380C45_nt ::S16380C45_nt(){ note_ctor("S16380C45_nt", this);} // tgen

//skip512 S16380C45_nt

#else // __cplusplus

extern void _ZN12S16380C45_ntC1Ev();
extern void _ZN12S16380C45_ntD1Ev();
Name_Map name_map_S16380C45_nt[] = {
  NSPAIR(_ZN12S16380C45_ntC1Ev),
  NSPAIR(_ZN12S16380C45_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S16380C46_nt;
extern VTBL_ENTRY _ZTI12S16380C46_nt[];
extern  VTBL_ENTRY _ZTV12S16380C46_nt[];
static Base_Class bases_S16380C45_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C46_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S16380C45_nt[];
extern void _ZN12S16380C45_ntD1Ev();
extern void _ZN12S16380C45_ntD0Ev();
extern void _ZN12S16380C46_nt3v13Ev();
extern void _ZN12S16380C45_nt3v14Ev();
static  VTBL_ENTRY vtc_S16380C45_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S16380C45_nt[0]),
  (VTBL_ENTRY)&_ZN12S16380C45_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S16380C45_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S16380C46_nt3v13Ev,
  (VTBL_ENTRY)&_ZN12S16380C45_nt3v14Ev,
};
extern VTBL_ENTRY _ZTI12S16380C45_nt[];
VTBL_ENTRY *P__ZTI12S16380C45_nt = _ZTI12S16380C45_nt; 
extern  VTBL_ENTRY _ZTV12S16380C45_nt[];
Class_Descriptor cd_S16380C45_nt = {  "S16380C45_nt", // class name
  bases_S16380C45_nt, 1,
  &(vtc_S16380C45_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI12S16380C45_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV12S16380C45_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C52_nt  {
  char s16380c52f0;
  char s16380c52f1:4;
  char s16380c52f2:4;
  char s16380c52f3:4;
  char s16380c52f4:4;
  char s16380c52f5:4;
  char s16380c52f6:4;
};
//SIG(-1 S16380C52_nt) C1{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4}



//skip512 S16380C52_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C53  {
  void *s16380c53f0[2];
  void  mf16380c53(); // _ZN9S16380C5310mf16380c53Ev
};
//SIG(-1 S16380C53) C1{ m Fp[2]}


void  S16380C53 ::mf16380c53(){}

static void Test_S16380C53()
{
  {
    init_simple_test("S16380C53");
    S16380C53 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S16380C53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C53)");
    check_field_offset(lv, s16380c53f0, 0, "S16380C53.s16380c53f0");
  }
}
static Arrange_To_Call_Me vS16380C53(Test_S16380C53, "S16380C53", ABISELECT(16,8));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S16380C53[];
VTBL_ENTRY *P__ZTI9S16380C53 = _ZTI9S16380C53; 
Class_Descriptor cd_S16380C53 = {  "S16380C53", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S16380C53),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C51_nt  {
  void *s16380c51f0;
  int s16380c51f1;
  ::S16380C52_nt s16380c51f2;
  int s16380c51f3;
  ::S16380C53 s16380c51f4;
  void  mf16380c51(); // _ZN12S16380C51_nt10mf16380c51Ev
};
//SIG(-1 S16380C51_nt) C1{ m Fp Fi FC2{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC3{ m Fp[2]}}


void  S16380C51_nt ::mf16380c51(){}

//skip512 S16380C51_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C44_nt  : S16380C45_nt {
  ::S16380C51_nt s16380c44f0;
  virtual  ~S16380C44_nt(); // _ZN12S16380C44_ntD1Ev
  S16380C44_nt(); // tgen
};
//SIG(-1 S16380C44_nt) C1{ BC2{ BC3{ vd v1} vd v2 Fp[2] FC4{ m FC5{ m Fp Fi[2] FC6{ m}}} FC7{ m Fp[2]}} vd FC8{ m Fp Fi FC9{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC10{ m Fp[2]}}}


 S16380C44_nt ::~S16380C44_nt(){ note_dtor("S16380C44_nt", this);}
S16380C44_nt ::S16380C44_nt(){ note_ctor("S16380C44_nt", this);} // tgen

//skip512 S16380C44_nt

#else // __cplusplus

extern void _ZN12S16380C44_ntC1Ev();
extern void _ZN12S16380C44_ntD1Ev();
Name_Map name_map_S16380C44_nt[] = {
  NSPAIR(_ZN12S16380C44_ntC1Ev),
  NSPAIR(_ZN12S16380C44_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S16380C46_nt;
extern VTBL_ENTRY _ZTI12S16380C46_nt[];
extern  VTBL_ENTRY _ZTV12S16380C46_nt[];
extern Class_Descriptor cd_S16380C45_nt;
extern VTBL_ENTRY _ZTI12S16380C45_nt[];
extern  VTBL_ENTRY _ZTV12S16380C45_nt[];
static Base_Class bases_S16380C44_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C46_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S16380C45_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S16380C44_nt[];
extern void _ZN12S16380C44_ntD1Ev();
extern void _ZN12S16380C44_ntD0Ev();
extern void _ZN12S16380C46_nt3v13Ev();
extern void _ZN12S16380C45_nt3v14Ev();
static  VTBL_ENTRY vtc_S16380C44_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S16380C44_nt[0]),
  (VTBL_ENTRY)&_ZN12S16380C44_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S16380C44_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S16380C46_nt3v13Ev,
  (VTBL_ENTRY)&_ZN12S16380C45_nt3v14Ev,
};
extern VTBL_ENTRY _ZTI12S16380C44_nt[];
VTBL_ENTRY *P__ZTI12S16380C44_nt = _ZTI12S16380C44_nt; 
extern  VTBL_ENTRY _ZTV12S16380C44_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C34_nt  {
  ::S16380C35_nt s16380c34f0;
  ::S16380C44_nt s16380c34f1;
  void  mf16380c34(); // _ZN12S16380C34_nt10mf16380c34Ev
};
//SIG(-1 S16380C34_nt) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 Fi}} FC12{ BC13{ BC14{ vd v13} vd v14 Fp[2] FC15{ m FC16{ m Fp Fi[2] FC17{ m}}} FC9} vd FC18{ m Fp Fi FC19{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC20{ m Fp[2]}}}}


void  S16380C34_nt ::mf16380c34(){}

//skip512 S16380C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C55  : S16380C36_nt , S16380C38_nt {
  ::S16380C39_nt s16380c55f0;
  ::S16380C39_nt s16380c55f1;
  ::S16380C43_nt s16380c55f2;
  virtual void  v15(); // _ZN9S16380C553v15Ev
  virtual void  v16(); // _ZN9S16380C553v16Ev
  virtual void  v17(); // _ZN9S16380C553v17Ev
  virtual void  v18(); // _ZN9S16380C553v18Ev
  virtual void  v19(); // _ZN9S16380C553v19Ev
  virtual void  v20(); // _ZN9S16380C553v20Ev
  ~S16380C55(); // tgen
  S16380C55(); // tgen
};
//SIG(-1 S16380C55) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC5 FC10{ BC6 Fi}}


void  S16380C55 ::v15(){vfunc_called(this, "_ZN9S16380C553v15Ev");}
void  S16380C55 ::v16(){vfunc_called(this, "_ZN9S16380C553v16Ev");}
void  S16380C55 ::v17(){vfunc_called(this, "_ZN9S16380C553v17Ev");}
void  S16380C55 ::v18(){vfunc_called(this, "_ZN9S16380C553v18Ev");}
void  S16380C55 ::v19(){vfunc_called(this, "_ZN9S16380C553v19Ev");}
void  S16380C55 ::v20(){vfunc_called(this, "_ZN9S16380C553v20Ev");}
S16380C55 ::~S16380C55(){ note_dtor("S16380C55", this);} // tgen
S16380C55 ::S16380C55(){ note_ctor("S16380C55", this);} // tgen

static void Test_S16380C55()
{
  extern Class_Descriptor cd_S16380C55;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,28)];
    init_test(&cd_S16380C55, buf);
    S16380C55 *dp, &lv = *(dp=new (buf) S16380C55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,108), "sizeof(S16380C55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C55)");
    check_base_class_offset(lv, (S16380C36_nt*), 0, "S16380C55");
    check_base_class_offset(lv, (S16380C38_nt*), 0, "S16380C55");
    check_field_offset(lv, s16380c55f0, ABISELECT(40,20), "S16380C55.s16380c55f0");
    check_field_offset(lv, s16380c55f1, ABISELECT(96,52), "S16380C55.s16380c55f1");
    check_field_offset(lv, s16380c55f2, ABISELECT(152,84), "S16380C55.s16380c55f2");
    test_class_info(&lv, &cd_S16380C55);
    dp->~S16380C55();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16380C55(Test_S16380C55, "S16380C55", ABISELECT(192,108));

#else // __cplusplus

extern void _ZN9S16380C55C1Ev();
extern void _ZN9S16380C55D1Ev();
Name_Map name_map_S16380C55[] = {
  NSPAIR(_ZN9S16380C55C1Ev),
  NSPAIR(_ZN9S16380C55D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S16380C36_nt;
extern VTBL_ENTRY _ZTI12S16380C36_nt[];
extern  VTBL_ENTRY _ZTV12S16380C36_nt[];
extern Class_Descriptor cd_S16380C38_nt;
extern VTBL_ENTRY _ZTI12S16380C38_nt[];
static Base_Class bases_S16380C55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C36_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S16380C38_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S16380C55[];
extern void _ZN9S16380C55D1Ev();
extern void _ZN9S16380C55D0Ev();
extern void _ZN12S16380C36_nt2v7Ev();
extern void _ZN12S16380C36_nt2v8Ev();
extern void _ZN12S16380C36_nt2v9Ev();
extern void _ZN12S16380C36_nt3v10Ev();
extern void _ZN12S16380C36_nt3v11Ev();
extern void _ZN12S16380C36_nt3v12Ev();
extern void _ZN9S16380C553v15Ev();
extern void _ZN9S16380C553v16Ev();
extern void _ZN9S16380C553v17Ev();
extern void _ZN9S16380C553v18Ev();
extern void _ZN9S16380C553v19Ev();
extern void _ZN9S16380C553v20Ev();
static  VTBL_ENTRY vtc_S16380C55[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S16380C55[0]),
  (VTBL_ENTRY)&_ZN9S16380C55D1Ev,
  (VTBL_ENTRY)&_ZN9S16380C55D0Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S16380C553v15Ev,
  (VTBL_ENTRY)&_ZN9S16380C553v16Ev,
  (VTBL_ENTRY)&_ZN9S16380C553v17Ev,
  (VTBL_ENTRY)&_ZN9S16380C553v18Ev,
  (VTBL_ENTRY)&_ZN9S16380C553v19Ev,
  (VTBL_ENTRY)&_ZN9S16380C553v20Ev,
};
extern VTBL_ENTRY _ZTI9S16380C55[];
extern  VTBL_ENTRY _ZTV9S16380C55[];
Class_Descriptor cd_S16380C55 = {  "S16380C55", // class name
  bases_S16380C55, 2,
  &(vtc_S16380C55[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,108), // object size
  NSPAIRA(_ZTI9S16380C55),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S16380C55),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C54  {
  ::S16380C55 s16380c54f0;
  ::S16380C44_nt s16380c54f1;
  void  mf16380c54(); // _ZN9S16380C5410mf16380c54Ev
};
//SIG(-1 S16380C54) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC6 FC11{ BC7 Fi}} FC12{ BC13{ BC14{ vd v13} vd v14 Fp[2] FC15{ m FC16{ m Fp Fi[2] FC17{ m}}} FC9} vd FC18{ m Fp Fi FC19{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC20{ m Fp[2]}}}}


void  S16380C54 ::mf16380c54(){}

static void Test_S16380C54()
{
  {
    init_simple_test("S16380C54");
    static S16380C54 lv;
    check2(sizeof(lv), ABISELECT(296,168), "sizeof(S16380C54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C54)");
    check_field_offset(lv, s16380c54f0, 0, "S16380C54.s16380c54f0");
    check_field_offset(lv, s16380c54f1, ABISELECT(192,108), "S16380C54.s16380c54f1");
  }
}
static Arrange_To_Call_Me vS16380C54(Test_S16380C54, "S16380C54", ABISELECT(296,168));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C23  {
  ::S16380C24 s16380c23f0;
  ::S16380C21 s16380c23f1;
  ::S16380C25_nt s16380c23f2;
  ::S16380C10_nt s16380c23f3;
  ::S16380C24 s16380c23f4[3];
  ::S1406C8_nt s16380c23f5;
  ::S16380C13_nt s16380c23f6;
  ::S16380C30 s16380c23f7;
  char s16380c23f8[2];
  ::S1406C5_nt s16380c23f9;
  ::S1406C5_nt s16380c23f10;
  ::S1406C5_nt s16380c23f11;
  ::S16380C32_nt s16380c23f12;
  char s16380c23f13;
  ::S16380C34_nt s16380c23f14;
  ::S16380C54 s16380c23f15;
  void  mf16380c23(); // _ZN9S16380C2310mf16380c23Ev
};
//SIG(-1 S16380C23) C1{ m FC2{ m Fp[2]} FC3{ m Fp[2]} FC4{ m FC5{ m FL}} FC6{ m Fp Fi FC7{ m}} FC2[3] FC8{ m Fp Fi[2]} FC9{ m Fp Fi[2] FC7} FC10{ m Fi Fc Fi Fc[2] Fi[5]} Fc[2] FC11{ m Fi[2]} FC11 FC11 FC12{ m FC13{ m FC4 FC4} FC13} Fc FC14{ m FC15{ BC16{ vd v7 v8 v9 v10 v11 v12 FC17{ m Fp[4]}} BC18{} v1 v2 v3 v4 v5 v6 FC19{ BC20{ m Fp Fi Fp Fi[2]} FC21{ m FC2 FC22{ m Fp}}} FC23{ BC20 Fi}} FC24{ BC25{ BC26{ vd v13} vd v14 Fp[2] FC27{ m FC28{ m Fp Fi[2] FC29{ m}}} FC2} vd FC30{ m Fp Fi FC31{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC32{ m Fp[2]}}}} FC33{ m FC34{ BC16 BC18 v15 v16 v17 v18 v19 v20 FC19 FC19 FC23} FC24}}


void  S16380C23 ::mf16380c23(){}

static void Test_S16380C23()
{
  {
    init_simple_test("S16380C23");
    static S16380C23 lv;
    check2(sizeof(lv), ABISELECT(784,492), "sizeof(S16380C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C23)");
    check_field_offset(lv, s16380c23f0, 0, "S16380C23.s16380c23f0");
    check_field_offset(lv, s16380c23f1, ABISELECT(16,8), "S16380C23.s16380c23f1");
    check_field_offset(lv, s16380c23f2, ABISELECT(32,16), "S16380C23.s16380c23f2");
    check_field_offset(lv, s16380c23f3, ABISELECT(40,24), "S16380C23.s16380c23f3");
    check_field_offset(lv, s16380c23f4, ABISELECT(56,36), "S16380C23.s16380c23f4");
    check_field_offset(lv, s16380c23f5, ABISELECT(104,60), "S16380C23.s16380c23f5");
    check_field_offset(lv, s16380c23f6, ABISELECT(120,72), "S16380C23.s16380c23f6");
    check_field_offset(lv, s16380c23f7, ABISELECT(144,88), "S16380C23.s16380c23f7");
    check_field_offset(lv, s16380c23f8, ABISELECT(180,124), "S16380C23.s16380c23f8");
    check_field_offset(lv, s16380c23f9, ABISELECT(184,128), "S16380C23.s16380c23f9");
    check_field_offset(lv, s16380c23f10, ABISELECT(192,136), "S16380C23.s16380c23f10");
    check_field_offset(lv, s16380c23f11, ABISELECT(200,144), "S16380C23.s16380c23f11");
    check_field_offset(lv, s16380c23f12, ABISELECT(208,152), "S16380C23.s16380c23f12");
    check_field_offset(lv, s16380c23f13, ABISELECT(240,184), "S16380C23.s16380c23f13");
    check_field_offset(lv, s16380c23f14, ABISELECT(248,188), "S16380C23.s16380c23f14");
    check_field_offset(lv, s16380c23f15, ABISELECT(488,324), "S16380C23.s16380c23f15");
  }
}
static Arrange_To_Call_Me vS16380C23(Test_S16380C23, "S16380C23", ABISELECT(784,492));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C59_nt  : S16380C40_nt {
  ::S16380C25_nt s16380c59f0;
};
//SIG(-1 S16380C59_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FL}}}



//skip512 S16380C59_nt

#else // __cplusplus

extern Class_Descriptor cd_S16380C40_nt;
static Base_Class bases_S16380C59_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C40_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C62_nt  {
  __tsi64 s16380c62f0[2];
  void  mf16380c62(); // _ZN12S16380C62_nt10mf16380c62Ev
};
//SIG(-1 S16380C62_nt) C1{ m FL[2]}


void  S16380C62_nt ::mf16380c62(){}

//skip512 S16380C62_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C61_nt  {
  ::S16380C62_nt s16380c61f0;
  void  mf16380c61(); // _ZN12S16380C61_nt10mf16380c61Ev
};
//SIG(-1 S16380C61_nt) C1{ m FC2{ m FL[2]}}


void  S16380C61_nt ::mf16380c61(){}

//skip512 S16380C61_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C60_nt  : S16380C40_nt {
  ::S16380C61_nt s16380c60f0;
};
//SIG(-1 S16380C60_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FL[2]}}}



//skip512 S16380C60_nt

#else // __cplusplus

extern Class_Descriptor cd_S16380C40_nt;
static Base_Class bases_S16380C60_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C40_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C58  : S16380C36_nt , S16380C38_nt {
  ::S16380C39_nt s16380c58f0;
  ::S16380C59_nt s16380c58f1;
  ::S16380C60_nt s16380c58f2;
  ::S16380C60_nt s16380c58f3;
  virtual void  v21(); // _ZN9S16380C583v21Ev
  virtual void  v22(); // _ZN9S16380C583v22Ev
  virtual void  v23(); // _ZN9S16380C583v23Ev
  virtual void  v24(); // _ZN9S16380C583v24Ev
  virtual void  v25(); // _ZN9S16380C583v25Ev
  virtual void  v26(); // _ZN9S16380C583v26Ev
  ~S16380C58(); // tgen
  S16380C58(); // tgen
};
//SIG(-1 S16380C58) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}} FC13{ BC6 FC14{ m FC15{ m FL[2]}}} FC13}


void  S16380C58 ::v21(){vfunc_called(this, "_ZN9S16380C583v21Ev");}
void  S16380C58 ::v22(){vfunc_called(this, "_ZN9S16380C583v22Ev");}
void  S16380C58 ::v23(){vfunc_called(this, "_ZN9S16380C583v23Ev");}
void  S16380C58 ::v24(){vfunc_called(this, "_ZN9S16380C583v24Ev");}
void  S16380C58 ::v25(){vfunc_called(this, "_ZN9S16380C583v25Ev");}
void  S16380C58 ::v26(){vfunc_called(this, "_ZN9S16380C583v26Ev");}
S16380C58 ::~S16380C58(){ note_dtor("S16380C58", this);} // tgen
S16380C58 ::S16380C58(){ note_ctor("S16380C58", this);} // tgen

static void Test_S16380C58()
{
  extern Class_Descriptor cd_S16380C58;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(30,39)];
    init_test(&cd_S16380C58, buf);
    S16380C58 *dp, &lv = *(dp=new (buf) S16380C58());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(232,152), "sizeof(S16380C58)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C58)");
    check_base_class_offset(lv, (S16380C36_nt*), 0, "S16380C58");
    check_base_class_offset(lv, (S16380C38_nt*), 0, "S16380C58");
    check_field_offset(lv, s16380c58f0, ABISELECT(40,20), "S16380C58.s16380c58f0");
    check_field_offset(lv, s16380c58f1, ABISELECT(96,52), "S16380C58.s16380c58f1");
    check_field_offset(lv, s16380c58f2, ABISELECT(136,80), "S16380C58.s16380c58f2");
    check_field_offset(lv, s16380c58f3, ABISELECT(184,116), "S16380C58.s16380c58f3");
    test_class_info(&lv, &cd_S16380C58);
    dp->~S16380C58();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16380C58(Test_S16380C58, "S16380C58", ABISELECT(232,152));

#else // __cplusplus

extern void _ZN9S16380C58C1Ev();
extern void _ZN9S16380C58D1Ev();
Name_Map name_map_S16380C58[] = {
  NSPAIR(_ZN9S16380C58C1Ev),
  NSPAIR(_ZN9S16380C58D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S16380C36_nt;
extern VTBL_ENTRY _ZTI12S16380C36_nt[];
extern  VTBL_ENTRY _ZTV12S16380C36_nt[];
extern Class_Descriptor cd_S16380C38_nt;
extern VTBL_ENTRY _ZTI12S16380C38_nt[];
static Base_Class bases_S16380C58[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C36_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S16380C38_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S16380C58[];
extern void _ZN9S16380C58D1Ev();
extern void _ZN9S16380C58D0Ev();
extern void _ZN12S16380C36_nt2v7Ev();
extern void _ZN12S16380C36_nt2v8Ev();
extern void _ZN12S16380C36_nt2v9Ev();
extern void _ZN12S16380C36_nt3v10Ev();
extern void _ZN12S16380C36_nt3v11Ev();
extern void _ZN12S16380C36_nt3v12Ev();
extern void _ZN9S16380C583v21Ev();
extern void _ZN9S16380C583v22Ev();
extern void _ZN9S16380C583v23Ev();
extern void _ZN9S16380C583v24Ev();
extern void _ZN9S16380C583v25Ev();
extern void _ZN9S16380C583v26Ev();
static  VTBL_ENTRY vtc_S16380C58[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S16380C58[0]),
  (VTBL_ENTRY)&_ZN9S16380C58D1Ev,
  (VTBL_ENTRY)&_ZN9S16380C58D0Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S16380C583v21Ev,
  (VTBL_ENTRY)&_ZN9S16380C583v22Ev,
  (VTBL_ENTRY)&_ZN9S16380C583v23Ev,
  (VTBL_ENTRY)&_ZN9S16380C583v24Ev,
  (VTBL_ENTRY)&_ZN9S16380C583v25Ev,
  (VTBL_ENTRY)&_ZN9S16380C583v26Ev,
};
extern VTBL_ENTRY _ZTI9S16380C58[];
extern  VTBL_ENTRY _ZTV9S16380C58[];
Class_Descriptor cd_S16380C58 = {  "S16380C58", // class name
  bases_S16380C58, 2,
  &(vtc_S16380C58[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,152), // object size
  NSPAIRA(_ZTI9S16380C58),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S16380C58),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C57  {
  ::S16380C58 s16380c57f0;
  ::S16380C44_nt s16380c57f1;
  void  mf16380c57(); // _ZN9S16380C5710mf16380c57Ev
};
//SIG(-1 S16380C57) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}} FC14{ BC7 FC15{ m FC16{ m FL[2]}}} FC14} FC17{ BC18{ BC19{ vd v13} vd v14 Fp[2] FC20{ m FC21{ m Fp Fi[2] FC22{ m}}} FC9} vd FC23{ m Fp Fi FC24{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC25{ m Fp[2]}}}}


void  S16380C57 ::mf16380c57(){}

static void Test_S16380C57()
{
  {
    init_simple_test("S16380C57");
    static S16380C57 lv;
    check2(sizeof(lv), ABISELECT(336,212), "sizeof(S16380C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C57)");
    check_field_offset(lv, s16380c57f0, 0, "S16380C57.s16380c57f0");
    check_field_offset(lv, s16380c57f1, ABISELECT(232,152), "S16380C57.s16380c57f1");
  }
}
static Arrange_To_Call_Me vS16380C57(Test_S16380C57, "S16380C57", ABISELECT(336,212));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C64  : S16380C36_nt , S16380C38_nt {
  ::S16380C39_nt s16380c64f0;
  ::S16380C59_nt s16380c64f1;
  virtual void  v27(); // _ZN9S16380C643v27Ev
  virtual void  v28(); // _ZN9S16380C643v28Ev
  virtual void  v29(); // _ZN9S16380C643v29Ev
  virtual void  v30(); // _ZN9S16380C643v30Ev
  virtual void  v31(); // _ZN9S16380C643v31Ev
  virtual void  v32(); // _ZN9S16380C643v32Ev
  ~S16380C64(); // tgen
  S16380C64(); // tgen
};
//SIG(-1 S16380C64) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL}}}}


void  S16380C64 ::v27(){vfunc_called(this, "_ZN9S16380C643v27Ev");}
void  S16380C64 ::v28(){vfunc_called(this, "_ZN9S16380C643v28Ev");}
void  S16380C64 ::v29(){vfunc_called(this, "_ZN9S16380C643v29Ev");}
void  S16380C64 ::v30(){vfunc_called(this, "_ZN9S16380C643v30Ev");}
void  S16380C64 ::v31(){vfunc_called(this, "_ZN9S16380C643v31Ev");}
void  S16380C64 ::v32(){vfunc_called(this, "_ZN9S16380C643v32Ev");}
S16380C64 ::~S16380C64(){ note_dtor("S16380C64", this);} // tgen
S16380C64 ::S16380C64(){ note_ctor("S16380C64", this);} // tgen

static void Test_S16380C64()
{
  extern Class_Descriptor cd_S16380C64;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(18,21)];
    init_test(&cd_S16380C64, buf);
    S16380C64 *dp, &lv = *(dp=new (buf) S16380C64());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(136,80), "sizeof(S16380C64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C64)");
    check_base_class_offset(lv, (S16380C36_nt*), 0, "S16380C64");
    check_base_class_offset(lv, (S16380C38_nt*), 0, "S16380C64");
    check_field_offset(lv, s16380c64f0, ABISELECT(40,20), "S16380C64.s16380c64f0");
    check_field_offset(lv, s16380c64f1, ABISELECT(96,52), "S16380C64.s16380c64f1");
    test_class_info(&lv, &cd_S16380C64);
    dp->~S16380C64();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16380C64(Test_S16380C64, "S16380C64", ABISELECT(136,80));

#else // __cplusplus

extern void _ZN9S16380C64C1Ev();
extern void _ZN9S16380C64D1Ev();
Name_Map name_map_S16380C64[] = {
  NSPAIR(_ZN9S16380C64C1Ev),
  NSPAIR(_ZN9S16380C64D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S16380C36_nt;
extern VTBL_ENTRY _ZTI12S16380C36_nt[];
extern  VTBL_ENTRY _ZTV12S16380C36_nt[];
extern Class_Descriptor cd_S16380C38_nt;
extern VTBL_ENTRY _ZTI12S16380C38_nt[];
static Base_Class bases_S16380C64[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C36_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S16380C38_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S16380C64[];
extern void _ZN9S16380C64D1Ev();
extern void _ZN9S16380C64D0Ev();
extern void _ZN12S16380C36_nt2v7Ev();
extern void _ZN12S16380C36_nt2v8Ev();
extern void _ZN12S16380C36_nt2v9Ev();
extern void _ZN12S16380C36_nt3v10Ev();
extern void _ZN12S16380C36_nt3v11Ev();
extern void _ZN12S16380C36_nt3v12Ev();
extern void _ZN9S16380C643v27Ev();
extern void _ZN9S16380C643v28Ev();
extern void _ZN9S16380C643v29Ev();
extern void _ZN9S16380C643v30Ev();
extern void _ZN9S16380C643v31Ev();
extern void _ZN9S16380C643v32Ev();
static  VTBL_ENTRY vtc_S16380C64[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S16380C64[0]),
  (VTBL_ENTRY)&_ZN9S16380C64D1Ev,
  (VTBL_ENTRY)&_ZN9S16380C64D0Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S16380C643v27Ev,
  (VTBL_ENTRY)&_ZN9S16380C643v28Ev,
  (VTBL_ENTRY)&_ZN9S16380C643v29Ev,
  (VTBL_ENTRY)&_ZN9S16380C643v30Ev,
  (VTBL_ENTRY)&_ZN9S16380C643v31Ev,
  (VTBL_ENTRY)&_ZN9S16380C643v32Ev,
};
extern VTBL_ENTRY _ZTI9S16380C64[];
extern  VTBL_ENTRY _ZTV9S16380C64[];
Class_Descriptor cd_S16380C64 = {  "S16380C64", // class name
  bases_S16380C64, 2,
  &(vtc_S16380C64[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,80), // object size
  NSPAIRA(_ZTI9S16380C64),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S16380C64),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C63  {
  ::S16380C64 s16380c63f0;
  ::S16380C44_nt s16380c63f1;
  void  mf16380c63(); // _ZN9S16380C6310mf16380c63Ev
};
//SIG(-1 S16380C63) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL}}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC9} vd FC20{ m Fp Fi FC21{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC22{ m Fp[2]}}}}


void  S16380C63 ::mf16380c63(){}

static void Test_S16380C63()
{
  {
    init_simple_test("S16380C63");
    static S16380C63 lv;
    check2(sizeof(lv), ABISELECT(240,140), "sizeof(S16380C63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C63)");
    check_field_offset(lv, s16380c63f0, 0, "S16380C63.s16380c63f0");
    check_field_offset(lv, s16380c63f1, ABISELECT(136,80), "S16380C63.s16380c63f1");
  }
}
static Arrange_To_Call_Me vS16380C63(Test_S16380C63, "S16380C63", ABISELECT(240,140));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C66  : S16380C36_nt , S16380C38_nt {
  ::S16380C39_nt s16380c66f0;
  ::S16380C39_nt s16380c66f1;
  virtual void  v33(); // _ZN9S16380C663v33Ev
  virtual void  v34(); // _ZN9S16380C663v34Ev
  virtual void  v35(); // _ZN9S16380C663v35Ev
  virtual void  v36(); // _ZN9S16380C663v36Ev
  virtual void  v37(); // _ZN9S16380C663v37Ev
  virtual void  v38(); // _ZN9S16380C663v38Ev
  ~S16380C66(); // tgen
  S16380C66(); // tgen
};
//SIG(-1 S16380C66) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC5}


void  S16380C66 ::v33(){vfunc_called(this, "_ZN9S16380C663v33Ev");}
void  S16380C66 ::v34(){vfunc_called(this, "_ZN9S16380C663v34Ev");}
void  S16380C66 ::v35(){vfunc_called(this, "_ZN9S16380C663v35Ev");}
void  S16380C66 ::v36(){vfunc_called(this, "_ZN9S16380C663v36Ev");}
void  S16380C66 ::v37(){vfunc_called(this, "_ZN9S16380C663v37Ev");}
void  S16380C66 ::v38(){vfunc_called(this, "_ZN9S16380C663v38Ev");}
S16380C66 ::~S16380C66(){ note_dtor("S16380C66", this);} // tgen
S16380C66 ::S16380C66(){ note_ctor("S16380C66", this);} // tgen

static void Test_S16380C66()
{
  extern Class_Descriptor cd_S16380C66;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,22)];
    init_test(&cd_S16380C66, buf);
    S16380C66 *dp, &lv = *(dp=new (buf) S16380C66());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,84), "sizeof(S16380C66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C66)");
    check_base_class_offset(lv, (S16380C36_nt*), 0, "S16380C66");
    check_base_class_offset(lv, (S16380C38_nt*), 0, "S16380C66");
    check_field_offset(lv, s16380c66f0, ABISELECT(40,20), "S16380C66.s16380c66f0");
    check_field_offset(lv, s16380c66f1, ABISELECT(96,52), "S16380C66.s16380c66f1");
    test_class_info(&lv, &cd_S16380C66);
    dp->~S16380C66();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16380C66(Test_S16380C66, "S16380C66", ABISELECT(152,84));

#else // __cplusplus

extern void _ZN9S16380C66C1Ev();
extern void _ZN9S16380C66D1Ev();
Name_Map name_map_S16380C66[] = {
  NSPAIR(_ZN9S16380C66C1Ev),
  NSPAIR(_ZN9S16380C66D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S16380C36_nt;
extern VTBL_ENTRY _ZTI12S16380C36_nt[];
extern  VTBL_ENTRY _ZTV12S16380C36_nt[];
extern Class_Descriptor cd_S16380C38_nt;
extern VTBL_ENTRY _ZTI12S16380C38_nt[];
static Base_Class bases_S16380C66[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16380C36_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S16380C38_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S16380C66[];
extern void _ZN9S16380C66D1Ev();
extern void _ZN9S16380C66D0Ev();
extern void _ZN12S16380C36_nt2v7Ev();
extern void _ZN12S16380C36_nt2v8Ev();
extern void _ZN12S16380C36_nt2v9Ev();
extern void _ZN12S16380C36_nt3v10Ev();
extern void _ZN12S16380C36_nt3v11Ev();
extern void _ZN12S16380C36_nt3v12Ev();
extern void _ZN9S16380C663v33Ev();
extern void _ZN9S16380C663v34Ev();
extern void _ZN9S16380C663v35Ev();
extern void _ZN9S16380C663v36Ev();
extern void _ZN9S16380C663v37Ev();
extern void _ZN9S16380C663v38Ev();
static  VTBL_ENTRY vtc_S16380C66[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S16380C66[0]),
  (VTBL_ENTRY)&_ZN9S16380C66D1Ev,
  (VTBL_ENTRY)&_ZN9S16380C66D0Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v7Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v8Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt2v9Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v10Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v11Ev,
  (VTBL_ENTRY)&_ZN12S16380C36_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S16380C663v33Ev,
  (VTBL_ENTRY)&_ZN9S16380C663v34Ev,
  (VTBL_ENTRY)&_ZN9S16380C663v35Ev,
  (VTBL_ENTRY)&_ZN9S16380C663v36Ev,
  (VTBL_ENTRY)&_ZN9S16380C663v37Ev,
  (VTBL_ENTRY)&_ZN9S16380C663v38Ev,
};
extern VTBL_ENTRY _ZTI9S16380C66[];
extern  VTBL_ENTRY _ZTV9S16380C66[];
Class_Descriptor cd_S16380C66 = {  "S16380C66", // class name
  bases_S16380C66, 2,
  &(vtc_S16380C66[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,84), // object size
  NSPAIRA(_ZTI9S16380C66),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S16380C66),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C65  {
  ::S16380C66 s16380c65f0;
  ::S16380C44_nt s16380c65f1;
  void  mf16380c65(); // _ZN9S16380C6510mf16380c65Ev
};
//SIG(-1 S16380C65) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC6} FC11{ BC12{ BC13{ vd v13} vd v14 Fp[2] FC14{ m FC15{ m Fp Fi[2] FC16{ m}}} FC9} vd FC17{ m Fp Fi FC18{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC19{ m Fp[2]}}}}


void  S16380C65 ::mf16380c65(){}

static void Test_S16380C65()
{
  {
    init_simple_test("S16380C65");
    static S16380C65 lv;
    check2(sizeof(lv), ABISELECT(256,144), "sizeof(S16380C65)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C65)");
    check_field_offset(lv, s16380c65f0, 0, "S16380C65.s16380c65f0");
    check_field_offset(lv, s16380c65f1, ABISELECT(152,84), "S16380C65.s16380c65f1");
  }
}
static Arrange_To_Call_Me vS16380C65(Test_S16380C65, "S16380C65", ABISELECT(256,144));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C71_nt  {
  ::S16380C61_nt s16380c71f0;
  void  mf16380c71(); // _ZN12S16380C71_nt10mf16380c71Ev
};
//SIG(-1 S16380C71_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S16380C71_nt ::mf16380c71(){}

//skip512 S16380C71_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C70_nt  {
  ::S16380C61_nt s16380c70f0;
  ::S16380C71_nt s16380c70f1;
  void  mf16380c70(); // _ZN12S16380C70_nt10mf16380c70Ev
};
//SIG(-1 S16380C70_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC4{ m FC2}}


void  S16380C70_nt ::mf16380c70(){}

//skip512 S16380C70_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C75  {
  ::S16380C61_nt s16380c75f0;
  char s16380c75f1;
  void  mf16380c75(); // _ZN9S16380C7510mf16380c75Ev
};
//SIG(1 S16380C75) C1{ m FC2{ m FC3{ m FL[2]}} Fc}


void  S16380C75 ::mf16380c75(){}

static void Test_S16380C75()
{
  {
    init_simple_test("S16380C75");
    S16380C75 lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S16380C75)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C75)");
    check_field_offset(lv, s16380c75f0, 0, "S16380C75.s16380c75f0");
    check_field_offset(lv, s16380c75f1, 16, "S16380C75.s16380c75f1");
  }
}
static Arrange_To_Call_Me vS16380C75(Test_S16380C75, "S16380C75", ABISELECT(24,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C74  {
  ::S16380C75 s16380c74f0[2];
  void  mf16380c74(); // _ZN9S16380C7410mf16380c74Ev
};
//SIG(-1 S16380C74) C1{ m FC2{ m FC3{ m FC4{ m FL[2]}} Fc}[2]}


void  S16380C74 ::mf16380c74(){}

static void Test_S16380C74()
{
  {
    init_simple_test("S16380C74");
    S16380C74 lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S16380C74)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C74)");
    check_field_offset(lv, s16380c74f0, 0, "S16380C74.s16380c74f0");
  }
}
static Arrange_To_Call_Me vS16380C74(Test_S16380C74, "S16380C74", ABISELECT(48,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C69  {
  ::S16380C70_nt s16380c69f0;
  ::S16380C25_nt s16380c69f1;
  ::S16380C25_nt s16380c69f2;
  ::S16380C61_nt s16380c69f3;
  ::S16380C74 s16380c69f4;
  void  mf16380c69(); // _ZN9S16380C6910mf16380c69Ev
};
//SIG(-1 S16380C69) C1{ m FC2{ m FC3{ m FC4{ m FL[2]}} FC5{ m FC3}} FC6{ m FC7{ m FL}} FC6 FC3 FC8{ m FC9{ m FC3 Fc}[2]}}


void  S16380C69 ::mf16380c69(){}

static void Test_S16380C69()
{
  {
    init_simple_test("S16380C69");
    S16380C69 lv;
    check2(sizeof(lv), ABISELECT(112,104), "sizeof(S16380C69)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C69)");
    check_field_offset(lv, s16380c69f0, 0, "S16380C69.s16380c69f0");
    check_field_offset(lv, s16380c69f1, 32, "S16380C69.s16380c69f1");
    check_field_offset(lv, s16380c69f2, 40, "S16380C69.s16380c69f2");
    check_field_offset(lv, s16380c69f3, 48, "S16380C69.s16380c69f3");
    check_field_offset(lv, s16380c69f4, 64, "S16380C69.s16380c69f4");
  }
}
static Arrange_To_Call_Me vS16380C69(Test_S16380C69, "S16380C69", ABISELECT(112,104));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C68  {
  ::S16380C69 s16380c68f0;
  int s16380c68f1[2];
  void  mf16380c68(); // _ZN9S16380C6810mf16380c68Ev
};
//SIG(-1 S16380C68) C1{ m FC2{ m FC3{ m FC4{ m FC5{ m FL[2]}} FC6{ m FC4}} FC7{ m FC8{ m FL}} FC7 FC4 FC9{ m FC10{ m FC4 Fc}[2]}} Fi[2]}


void  S16380C68 ::mf16380c68(){}

static void Test_S16380C68()
{
  {
    init_simple_test("S16380C68");
    S16380C68 lv;
    check2(sizeof(lv), ABISELECT(120,112), "sizeof(S16380C68)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C68)");
    check_field_offset(lv, s16380c68f0, 0, "S16380C68.s16380c68f0");
    check_field_offset(lv, s16380c68f1, ABISELECT(112,104), "S16380C68.s16380c68f1");
  }
}
static Arrange_To_Call_Me vS16380C68(Test_S16380C68, "S16380C68", ABISELECT(120,112));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C67  {
  ::S16380C68 s16380c67f0;
  int s16380c67f1[2];
  char s16380c67f2;
  int s16380c67f3[4];
  void  mf16380c67(); // _ZN9S16380C6710mf16380c67Ev
};
//SIG(-1 S16380C67) C1{ m FC2{ m FC3{ m FC4{ m FC5{ m FC6{ m FL[2]}} FC7{ m FC5}} FC8{ m FC9{ m FL}} FC8 FC5 FC10{ m FC11{ m FC5 Fc}[2]}} Fi[2]} Fi[2] Fc Fi[4]}


void  S16380C67 ::mf16380c67(){}

static void Test_S16380C67()
{
  {
    init_simple_test("S16380C67");
    S16380C67 lv;
    check2(sizeof(lv), ABISELECT(152,140), "sizeof(S16380C67)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C67)");
    check_field_offset(lv, s16380c67f0, 0, "S16380C67.s16380c67f0");
    check_field_offset(lv, s16380c67f1, ABISELECT(120,112), "S16380C67.s16380c67f1");
    check_field_offset(lv, s16380c67f2, ABISELECT(128,120), "S16380C67.s16380c67f2");
    check_field_offset(lv, s16380c67f3, ABISELECT(132,124), "S16380C67.s16380c67f3");
  }
}
static Arrange_To_Call_Me vS16380C67(Test_S16380C67, "S16380C67", ABISELECT(152,140));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C56  {
  char s16380c56f0;
  ::S16380C57 s16380c56f1;
  ::S16380C63 s16380c56f2;
  ::S16380C65 s16380c56f3;
  ::S16380C24 s16380c56f4[3];
  ::S16380C25_nt s16380c56f5;
  char s16380c56f6;
  int s16380c56f7[2];
  ::S16380C67 s16380c56f8;
  ::S16380C21 s16380c56f9;
  void  mf16380c56(); // _ZN9S16380C5610mf16380c56Ev
};
//SIG(-1 S16380C56) C1{ m Fc FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m Fp[2]} FC11{ m Fp}}} FC12{ BC8 FC13{ m FC14{ m FL}}} FC15{ BC8 FC16{ m FC17{ m FL[2]}}} FC15} FC18{ BC19{ BC20{ vd v13} vd v14 Fp[2] FC21{ m FC22{ m Fp Fi[2] FC23{ m}}} FC10} vd FC24{ m Fp Fi FC25{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC26{ m Fp[2]}}}} FC27{ m FC28{ BC4 BC6 v15 v16 v17 v18 v19 v20 FC7 FC12} FC18} FC29{ m FC30{ BC4 BC6 v21 v22 v23 v24 v25 v26 FC7 FC7} FC18} FC10[3] FC13 Fc Fi[2] FC31{ m FC32{ m FC33{ m FC34{ m FC16 FC35{ m FC16}} FC13 FC13 FC16 FC36{ m FC37{ m FC16 Fc}[2]}} Fi[2]} Fi[2] Fc Fi[4]} FC38{ m Fp[2]}}


void  S16380C56 ::mf16380c56(){}

static void Test_S16380C56()
{
  {
    init_simple_test("S16380C56");
    static S16380C56 lv;
    check2(sizeof(lv), ABISELECT(1080,692), "sizeof(S16380C56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C56)");
    check_field_offset(lv, s16380c56f0, 0, "S16380C56.s16380c56f0");
    check_field_offset(lv, s16380c56f1, ABISELECT(8,4), "S16380C56.s16380c56f1");
    check_field_offset(lv, s16380c56f2, ABISELECT(344,216), "S16380C56.s16380c56f2");
    check_field_offset(lv, s16380c56f3, ABISELECT(584,356), "S16380C56.s16380c56f3");
    check_field_offset(lv, s16380c56f4, ABISELECT(840,500), "S16380C56.s16380c56f4");
    check_field_offset(lv, s16380c56f5, ABISELECT(888,524), "S16380C56.s16380c56f5");
    check_field_offset(lv, s16380c56f6, ABISELECT(896,532), "S16380C56.s16380c56f6");
    check_field_offset(lv, s16380c56f7, ABISELECT(900,536), "S16380C56.s16380c56f7");
    check_field_offset(lv, s16380c56f8, ABISELECT(912,544), "S16380C56.s16380c56f8");
    check_field_offset(lv, s16380c56f9, ABISELECT(1064,684), "S16380C56.s16380c56f9");
  }
}
static Arrange_To_Call_Me vS16380C56(Test_S16380C56, "S16380C56", ABISELECT(1080,692));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C77  {
  void *s16380c77f0;
  void  mf16380c77(); // _ZN9S16380C7710mf16380c77Ev
};
//SIG(-1 S16380C77) C1{ m Fp}


void  S16380C77 ::mf16380c77(){}

static void Test_S16380C77()
{
  {
    init_simple_test("S16380C77");
    S16380C77 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S16380C77)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C77)");
    check_field_offset(lv, s16380c77f0, 0, "S16380C77.s16380c77f0");
  }
}
static Arrange_To_Call_Me vS16380C77(Test_S16380C77, "S16380C77", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16380C1  {
  ::S16380C2_nt s16380c1f0;
  ::S16380C2_nt s16380c1f1;
  ::S16380C4 s16380c1f2;
  ::S16380C4 s16380c1f3;
  ::S16380C6 s16380c1f4;
  ::S16380C6 s16380c1f5;
  ::S16380C8 s16380c1f6;
  ::S16380C8 s16380c1f7;
  ::S16380C10_nt s16380c1f8;
  int s16380c1f9[2];
  ::S16380C12 s16380c1f10;
  ::S16380C15 s16380c1f11;
  ::S16380C15 s16380c1f12;
  ::S16380C17 s16380c1f13;
  ::S16380C17 s16380c1f14;
  ::S16380C19 s16380c1f15;
  ::S16380C19 s16380c1f16;
  ::S16380C19 s16380c1f17;
  ::S16380C21 s16380c1f18;
  ::S16380C21 s16380c1f19;
  ::S16380C23 s16380c1f20;
  int s16380c1f21;
  char s16380c1f22;
  ::S16380C56 s16380c1f23;
  char s16380c1f24;
  ::S16380C42_nt s16380c1f25;
  ::S16380C42_nt s16380c1f26;
  ::S16380C42_nt s16380c1f27;
  ::S16380C42_nt s16380c1f28;
  ::S16380C42_nt s16380c1f29;
  ::S16380C42_nt s16380c1f30;
  ::S16380C77 s16380c1f31;
  ::S16380C77 s16380c1f32;
  void  mf16380c1(); // _ZN8S16380C19mf16380c1Ev
};
//SIG(1 S16380C1) C1{ m FC2{ m Fp[2]} FC2 FC3{ m Fp[2]} FC3 FC4{ m Fp[2]} FC4 FC5{ m Fp[2]} FC5 FC6{ m Fp Fi FC7{ m}} Fi[2] FC8{ m FC6 FC9{ m Fp Fi[2] FC7}} FC10{ m Fp[2]} FC10 FC11{ m Fp[2]} FC11 FC12{ m Fp[2]} FC12 FC12 FC13{ m Fp[2]} FC13 FC14{ m FC15{ m Fp[2]} FC13 FC16{ m FC17{ m FL}} FC6 FC15[3] FC18{ m Fp Fi[2]} FC9 FC19{ m Fi Fc Fi Fc[2] Fi[5]} Fc[2] FC20{ m Fi[2]} FC20 FC20 FC21{ m FC22{ m FC16 FC16} FC22} Fc FC23{ m FC24{ BC25{ vd v7 v8 v9 v10 v11 v12 FC26{ m Fp[4]}} BC27{} v1 v2 v3 v4 v5 v6 FC28{ BC29{ m Fp Fi Fp Fi[2]} FC30{ m FC15 FC31{ m Fp}}} FC32{ BC29 Fi}} FC33{ BC34{ BC35{ vd v13} vd v14 Fp[2] FC36{ m FC37{ m Fp Fi[2] FC38{ m}}} FC15} vd FC39{ m Fp Fi FC40{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC41{ m Fp[2]}}}} FC42{ m FC43{ BC25 BC27 v15 v16 v17 v18 v19 v20 FC28 FC28 FC32} FC33}} Fi Fc FC44{ m Fc FC45{ m FC46{ BC25 BC27 v21 v22 v23 v24 v25 v26 FC28 FC47{ BC29 FC16} FC48{ BC29 FC49{ m FC50{ m FL[2]}}} FC48} FC33} FC51{ m FC52{ BC25 BC27 v27 v28 v29 v30 v31 v32 FC28 FC47} FC33} FC53{ m FC54{ BC25 BC27 v33 v34 v35 v36 v37 v38 FC28 FC28} FC33} FC15[3] FC16 Fc Fi[2] FC55{ m FC56{ m FC57{ m FC58{ m FC49 FC59{ m FC49}} FC16 FC16 FC49 FC60{ m FC61{ m FC49 Fc}[2]}} Fi[2]} Fi[2] Fc Fi[4]} FC13} Fc FC31 FC31 FC31 FC31 FC31 FC31 FC62{ m Fp} FC62}


void  S16380C1 ::mf16380c1(){}

static void Test_S16380C1()
{
  {
    init_simple_test("S16380C1");
    static S16380C1 lv;
    check2(sizeof(lv), ABISELECT(2280,1412), "sizeof(S16380C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16380C1)");
    check_field_offset(lv, s16380c1f0, 0, "S16380C1.s16380c1f0");
    check_field_offset(lv, s16380c1f1, ABISELECT(16,8), "S16380C1.s16380c1f1");
    check_field_offset(lv, s16380c1f2, ABISELECT(32,16), "S16380C1.s16380c1f2");
    check_field_offset(lv, s16380c1f3, ABISELECT(48,24), "S16380C1.s16380c1f3");
    check_field_offset(lv, s16380c1f4, ABISELECT(64,32), "S16380C1.s16380c1f4");
    check_field_offset(lv, s16380c1f5, ABISELECT(80,40), "S16380C1.s16380c1f5");
    check_field_offset(lv, s16380c1f6, ABISELECT(96,48), "S16380C1.s16380c1f6");
    check_field_offset(lv, s16380c1f7, ABISELECT(112,56), "S16380C1.s16380c1f7");
    check_field_offset(lv, s16380c1f8, ABISELECT(128,64), "S16380C1.s16380c1f8");
    check_field_offset(lv, s16380c1f9, ABISELECT(144,76), "S16380C1.s16380c1f9");
    check_field_offset(lv, s16380c1f10, ABISELECT(152,84), "S16380C1.s16380c1f10");
    check_field_offset(lv, s16380c1f11, ABISELECT(192,112), "S16380C1.s16380c1f11");
    check_field_offset(lv, s16380c1f12, ABISELECT(208,120), "S16380C1.s16380c1f12");
    check_field_offset(lv, s16380c1f13, ABISELECT(224,128), "S16380C1.s16380c1f13");
    check_field_offset(lv, s16380c1f14, ABISELECT(240,136), "S16380C1.s16380c1f14");
    check_field_offset(lv, s16380c1f15, ABISELECT(256,144), "S16380C1.s16380c1f15");
    check_field_offset(lv, s16380c1f16, ABISELECT(272,152), "S16380C1.s16380c1f16");
    check_field_offset(lv, s16380c1f17, ABISELECT(288,160), "S16380C1.s16380c1f17");
    check_field_offset(lv, s16380c1f18, ABISELECT(304,168), "S16380C1.s16380c1f18");
    check_field_offset(lv, s16380c1f19, ABISELECT(320,176), "S16380C1.s16380c1f19");
    check_field_offset(lv, s16380c1f20, ABISELECT(336,184), "S16380C1.s16380c1f20");
    check_field_offset(lv, s16380c1f21, ABISELECT(1120,676), "S16380C1.s16380c1f21");
    check_field_offset(lv, s16380c1f22, ABISELECT(1124,680), "S16380C1.s16380c1f22");
    check_field_offset(lv, s16380c1f23, ABISELECT(1128,684), "S16380C1.s16380c1f23");
    check_field_offset(lv, s16380c1f24, ABISELECT(2208,1376), "S16380C1.s16380c1f24");
    check_field_offset(lv, s16380c1f25, ABISELECT(2216,1380), "S16380C1.s16380c1f25");
    check_field_offset(lv, s16380c1f26, ABISELECT(2224,1384), "S16380C1.s16380c1f26");
    check_field_offset(lv, s16380c1f27, ABISELECT(2232,1388), "S16380C1.s16380c1f27");
    check_field_offset(lv, s16380c1f28, ABISELECT(2240,1392), "S16380C1.s16380c1f28");
    check_field_offset(lv, s16380c1f29, ABISELECT(2248,1396), "S16380C1.s16380c1f29");
    check_field_offset(lv, s16380c1f30, ABISELECT(2256,1400), "S16380C1.s16380c1f30");
    check_field_offset(lv, s16380c1f31, ABISELECT(2264,1404), "S16380C1.s16380c1f31");
    check_field_offset(lv, s16380c1f32, ABISELECT(2272,1408), "S16380C1.s16380c1f32");
  }
}
static Arrange_To_Call_Me vS16380C1(Test_S16380C1, "S16380C1", ABISELECT(2280,1412));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C6  {
  int s263c6f0;
  __tsi64 s263c6f1;
  void *s263c6f2[4];
  int s263c6f3[2];
  void *s263c6f4;
  ::S1406C5_nt s263c6f5;
  void *s263c6f6[2];
  virtual  ~S263C6(); // _ZN6S263C6D1Ev
  virtual void  v6(); // _ZN6S263C62v6Ev
  virtual void  v7(); // _ZN6S263C62v7Ev
  virtual void  v8(); // _ZN6S263C62v8Ev
  virtual void  v9(); // _ZN6S263C62v9Ev
  virtual void  v10(); // _ZN6S263C63v10Ev
  virtual void  v11(); // _ZN6S263C63v11Ev
  virtual void  v12(); // _ZN6S263C63v12Ev
  virtual void  v13(); // _ZN6S263C63v13Ev
  virtual void  v14(); // _ZN6S263C63v14Ev
  virtual void  v15(); // _ZN6S263C63v15Ev
  virtual void  v16(); // _ZN6S263C63v16Ev
  virtual void  v17(); // _ZN6S263C63v17Ev
  virtual void  v18(); // _ZN6S263C63v18Ev
  virtual void  v19(); // _ZN6S263C63v19Ev
  virtual void  v20(); // _ZN6S263C63v20Ev
  virtual void  v21(); // _ZN6S263C63v21Ev
  virtual void  v22(); // _ZN6S263C63v22Ev
  virtual void  v23(); // _ZN6S263C63v23Ev
  virtual void  v24(); // _ZN6S263C63v24Ev
  virtual void  v25(); // _ZN6S263C63v25Ev
  virtual void  v26(); // _ZN6S263C63v26Ev
  virtual void  v27(); // _ZN6S263C63v27Ev
  virtual void  v28(); // _ZN6S263C63v28Ev
  virtual void  v29(); // _ZN6S263C63v29Ev
  virtual void  v30(); // _ZN6S263C63v30Ev
  virtual void  v31(); // _ZN6S263C63v31Ev
  virtual void  v32(); // _ZN6S263C63v32Ev
  virtual void  v33(); // _ZN6S263C63v33Ev
  virtual void  v34(); // _ZN6S263C63v34Ev
  virtual void  v35(); // _ZN6S263C63v35Ev
  virtual void  v36(); // _ZN6S263C63v36Ev
  virtual void  v37(); // _ZN6S263C63v37Ev
  virtual void  v38(); // _ZN6S263C63v38Ev
  virtual void  v39(); // _ZN6S263C63v39Ev
  virtual void  v40(); // _ZN6S263C63v40Ev
  virtual void  v41(); // _ZN6S263C63v41Ev
  virtual void  v42(); // _ZN6S263C63v42Ev
  virtual void  v43(); // _ZN6S263C63v43Ev
  virtual void  v44(); // _ZN6S263C63v44Ev
  virtual void  v45(); // _ZN6S263C63v45Ev
  virtual void  v46(); // _ZN6S263C63v46Ev
  virtual void  v47(); // _ZN6S263C63v47Ev
  virtual void  v48(); // _ZN6S263C63v48Ev
  virtual void  v49(); // _ZN6S263C63v49Ev
  virtual void  v50(); // _ZN6S263C63v50Ev
  virtual void  v51(); // _ZN6S263C63v51Ev
  virtual void  v52(); // _ZN6S263C63v52Ev
  virtual void  v53(); // _ZN6S263C63v53Ev
  virtual void  v54(); // _ZN6S263C63v54Ev
  virtual void  v55(); // _ZN6S263C63v55Ev
  virtual void  v56(); // _ZN6S263C63v56Ev
  virtual void  v57(); // _ZN6S263C63v57Ev
  virtual void  v58(); // _ZN6S263C63v58Ev
  virtual void  v59(); // _ZN6S263C63v59Ev
  virtual void  v60(); // _ZN6S263C63v60Ev
  virtual void  v61(); // _ZN6S263C63v61Ev
  virtual void  v62(); // _ZN6S263C63v62Ev
  virtual void  v63(); // _ZN6S263C63v63Ev
  virtual void  v64(); // _ZN6S263C63v64Ev
  virtual void  v65(); // _ZN6S263C63v65Ev
  virtual void  v66(); // _ZN6S263C63v66Ev
  virtual void  v67(); // _ZN6S263C63v67Ev
  virtual void  v68(); // _ZN6S263C63v68Ev
  virtual void  v69(); // _ZN6S263C63v69Ev
  S263C6(); // tgen
};
//SIG(-1 S263C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S263C6 ::~S263C6(){ note_dtor("S263C6", this);}
void  S263C6 ::v6(){vfunc_called(this, "_ZN6S263C62v6Ev");}
void  S263C6 ::v7(){vfunc_called(this, "_ZN6S263C62v7Ev");}
void  S263C6 ::v8(){vfunc_called(this, "_ZN6S263C62v8Ev");}
void  S263C6 ::v9(){vfunc_called(this, "_ZN6S263C62v9Ev");}
void  S263C6 ::v10(){vfunc_called(this, "_ZN6S263C63v10Ev");}
void  S263C6 ::v11(){vfunc_called(this, "_ZN6S263C63v11Ev");}
void  S263C6 ::v12(){vfunc_called(this, "_ZN6S263C63v12Ev");}
void  S263C6 ::v13(){vfunc_called(this, "_ZN6S263C63v13Ev");}
void  S263C6 ::v14(){vfunc_called(this, "_ZN6S263C63v14Ev");}
void  S263C6 ::v15(){vfunc_called(this, "_ZN6S263C63v15Ev");}
void  S263C6 ::v16(){vfunc_called(this, "_ZN6S263C63v16Ev");}
void  S263C6 ::v17(){vfunc_called(this, "_ZN6S263C63v17Ev");}
void  S263C6 ::v18(){vfunc_called(this, "_ZN6S263C63v18Ev");}
void  S263C6 ::v19(){vfunc_called(this, "_ZN6S263C63v19Ev");}
void  S263C6 ::v20(){vfunc_called(this, "_ZN6S263C63v20Ev");}
void  S263C6 ::v21(){vfunc_called(this, "_ZN6S263C63v21Ev");}
void  S263C6 ::v22(){vfunc_called(this, "_ZN6S263C63v22Ev");}
void  S263C6 ::v23(){vfunc_called(this, "_ZN6S263C63v23Ev");}
void  S263C6 ::v24(){vfunc_called(this, "_ZN6S263C63v24Ev");}
void  S263C6 ::v25(){vfunc_called(this, "_ZN6S263C63v25Ev");}
void  S263C6 ::v26(){vfunc_called(this, "_ZN6S263C63v26Ev");}
void  S263C6 ::v27(){vfunc_called(this, "_ZN6S263C63v27Ev");}
void  S263C6 ::v28(){vfunc_called(this, "_ZN6S263C63v28Ev");}
void  S263C6 ::v29(){vfunc_called(this, "_ZN6S263C63v29Ev");}
void  S263C6 ::v30(){vfunc_called(this, "_ZN6S263C63v30Ev");}
void  S263C6 ::v31(){vfunc_called(this, "_ZN6S263C63v31Ev");}
void  S263C6 ::v32(){vfunc_called(this, "_ZN6S263C63v32Ev");}
void  S263C6 ::v33(){vfunc_called(this, "_ZN6S263C63v33Ev");}
void  S263C6 ::v34(){vfunc_called(this, "_ZN6S263C63v34Ev");}
void  S263C6 ::v35(){vfunc_called(this, "_ZN6S263C63v35Ev");}
void  S263C6 ::v36(){vfunc_called(this, "_ZN6S263C63v36Ev");}
void  S263C6 ::v37(){vfunc_called(this, "_ZN6S263C63v37Ev");}
void  S263C6 ::v38(){vfunc_called(this, "_ZN6S263C63v38Ev");}
void  S263C6 ::v39(){vfunc_called(this, "_ZN6S263C63v39Ev");}
void  S263C6 ::v40(){vfunc_called(this, "_ZN6S263C63v40Ev");}
void  S263C6 ::v41(){vfunc_called(this, "_ZN6S263C63v41Ev");}
void  S263C6 ::v42(){vfunc_called(this, "_ZN6S263C63v42Ev");}
void  S263C6 ::v43(){vfunc_called(this, "_ZN6S263C63v43Ev");}
void  S263C6 ::v44(){vfunc_called(this, "_ZN6S263C63v44Ev");}
void  S263C6 ::v45(){vfunc_called(this, "_ZN6S263C63v45Ev");}
void  S263C6 ::v46(){vfunc_called(this, "_ZN6S263C63v46Ev");}
void  S263C6 ::v47(){vfunc_called(this, "_ZN6S263C63v47Ev");}
void  S263C6 ::v48(){vfunc_called(this, "_ZN6S263C63v48Ev");}
void  S263C6 ::v49(){vfunc_called(this, "_ZN6S263C63v49Ev");}
void  S263C6 ::v50(){vfunc_called(this, "_ZN6S263C63v50Ev");}
void  S263C6 ::v51(){vfunc_called(this, "_ZN6S263C63v51Ev");}
void  S263C6 ::v52(){vfunc_called(this, "_ZN6S263C63v52Ev");}
void  S263C6 ::v53(){vfunc_called(this, "_ZN6S263C63v53Ev");}
void  S263C6 ::v54(){vfunc_called(this, "_ZN6S263C63v54Ev");}
void  S263C6 ::v55(){vfunc_called(this, "_ZN6S263C63v55Ev");}
void  S263C6 ::v56(){vfunc_called(this, "_ZN6S263C63v56Ev");}
void  S263C6 ::v57(){vfunc_called(this, "_ZN6S263C63v57Ev");}
void  S263C6 ::v58(){vfunc_called(this, "_ZN6S263C63v58Ev");}
void  S263C6 ::v59(){vfunc_called(this, "_ZN6S263C63v59Ev");}
void  S263C6 ::v60(){vfunc_called(this, "_ZN6S263C63v60Ev");}
void  S263C6 ::v61(){vfunc_called(this, "_ZN6S263C63v61Ev");}
void  S263C6 ::v62(){vfunc_called(this, "_ZN6S263C63v62Ev");}
void  S263C6 ::v63(){vfunc_called(this, "_ZN6S263C63v63Ev");}
void  S263C6 ::v64(){vfunc_called(this, "_ZN6S263C63v64Ev");}
void  S263C6 ::v65(){vfunc_called(this, "_ZN6S263C63v65Ev");}
void  S263C6 ::v66(){vfunc_called(this, "_ZN6S263C63v66Ev");}
void  S263C6 ::v67(){vfunc_called(this, "_ZN6S263C63v67Ev");}
void  S263C6 ::v68(){vfunc_called(this, "_ZN6S263C63v68Ev");}
void  S263C6 ::v69(){vfunc_called(this, "_ZN6S263C63v69Ev");}
S263C6 ::S263C6(){ note_ctor("S263C6", this);} // tgen

static void Test_S263C6()
{
  extern Class_Descriptor cd_S263C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S263C6, buf);
    S263C6 *dp, &lv = *(dp=new (buf) S263C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S263C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S263C6)");
    check_field_offset(lv, s263c6f0, ABISELECT(8,4), "S263C6.s263c6f0");
    check_field_offset(lv, s263c6f1, ABISELECT(16,8), "S263C6.s263c6f1");
    check_field_offset(lv, s263c6f2, ABISELECT(24,16), "S263C6.s263c6f2");
    check_field_offset(lv, s263c6f3, ABISELECT(56,32), "S263C6.s263c6f3");
    check_field_offset(lv, s263c6f4, ABISELECT(64,40), "S263C6.s263c6f4");
    check_field_offset(lv, s263c6f5, ABISELECT(72,44), "S263C6.s263c6f5");
    check_field_offset(lv, s263c6f6, ABISELECT(80,52), "S263C6.s263c6f6");
    test_class_info(&lv, &cd_S263C6);
    dp->~S263C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS263C6(Test_S263C6, "S263C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S263C6C1Ev();
extern void _ZN6S263C6D1Ev();
Name_Map name_map_S263C6[] = {
  NSPAIR(_ZN6S263C6C1Ev),
  NSPAIR(_ZN6S263C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S263C6[];
extern void _ZN6S263C6D1Ev();
extern void _ZN6S263C6D0Ev();
extern void _ZN6S263C62v6Ev();
extern void _ZN6S263C62v7Ev();
extern void _ZN6S263C62v8Ev();
extern void _ZN6S263C62v9Ev();
extern void _ZN6S263C63v10Ev();
extern void _ZN6S263C63v11Ev();
extern void _ZN6S263C63v12Ev();
extern void _ZN6S263C63v13Ev();
extern void _ZN6S263C63v14Ev();
extern void _ZN6S263C63v15Ev();
extern void _ZN6S263C63v16Ev();
extern void _ZN6S263C63v17Ev();
extern void _ZN6S263C63v18Ev();
extern void _ZN6S263C63v19Ev();
extern void _ZN6S263C63v20Ev();
extern void _ZN6S263C63v21Ev();
extern void _ZN6S263C63v22Ev();
extern void _ZN6S263C63v23Ev();
extern void _ZN6S263C63v24Ev();
extern void _ZN6S263C63v25Ev();
extern void _ZN6S263C63v26Ev();
extern void _ZN6S263C63v27Ev();
extern void _ZN6S263C63v28Ev();
extern void _ZN6S263C63v29Ev();
extern void _ZN6S263C63v30Ev();
extern void _ZN6S263C63v31Ev();
extern void _ZN6S263C63v32Ev();
extern void _ZN6S263C63v33Ev();
extern void _ZN6S263C63v34Ev();
extern void _ZN6S263C63v35Ev();
extern void _ZN6S263C63v36Ev();
extern void _ZN6S263C63v37Ev();
extern void _ZN6S263C63v38Ev();
extern void _ZN6S263C63v39Ev();
extern void _ZN6S263C63v40Ev();
extern void _ZN6S263C63v41Ev();
extern void _ZN6S263C63v42Ev();
extern void _ZN6S263C63v43Ev();
extern void _ZN6S263C63v44Ev();
extern void _ZN6S263C63v45Ev();
extern void _ZN6S263C63v46Ev();
extern void _ZN6S263C63v47Ev();
extern void _ZN6S263C63v48Ev();
extern void _ZN6S263C63v49Ev();
extern void _ZN6S263C63v50Ev();
extern void _ZN6S263C63v51Ev();
extern void _ZN6S263C63v52Ev();
extern void _ZN6S263C63v53Ev();
extern void _ZN6S263C63v54Ev();
extern void _ZN6S263C63v55Ev();
extern void _ZN6S263C63v56Ev();
extern void _ZN6S263C63v57Ev();
extern void _ZN6S263C63v58Ev();
extern void _ZN6S263C63v59Ev();
extern void _ZN6S263C63v60Ev();
extern void _ZN6S263C63v61Ev();
extern void _ZN6S263C63v62Ev();
extern void _ZN6S263C63v63Ev();
extern void _ZN6S263C63v64Ev();
extern void _ZN6S263C63v65Ev();
extern void _ZN6S263C63v66Ev();
extern void _ZN6S263C63v67Ev();
extern void _ZN6S263C63v68Ev();
extern void _ZN6S263C63v69Ev();
static  VTBL_ENTRY vtc_S263C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S263C6[0]),
  (VTBL_ENTRY)&_ZN6S263C6D1Ev,
  (VTBL_ENTRY)&_ZN6S263C6D0Ev,
  (VTBL_ENTRY)&_ZN6S263C62v6Ev,
  (VTBL_ENTRY)&_ZN6S263C62v7Ev,
  (VTBL_ENTRY)&_ZN6S263C62v8Ev,
  (VTBL_ENTRY)&_ZN6S263C62v9Ev,
  (VTBL_ENTRY)&_ZN6S263C63v10Ev,
  (VTBL_ENTRY)&_ZN6S263C63v11Ev,
  (VTBL_ENTRY)&_ZN6S263C63v12Ev,
  (VTBL_ENTRY)&_ZN6S263C63v13Ev,
  (VTBL_ENTRY)&_ZN6S263C63v14Ev,
  (VTBL_ENTRY)&_ZN6S263C63v15Ev,
  (VTBL_ENTRY)&_ZN6S263C63v16Ev,
  (VTBL_ENTRY)&_ZN6S263C63v17Ev,
  (VTBL_ENTRY)&_ZN6S263C63v18Ev,
  (VTBL_ENTRY)&_ZN6S263C63v19Ev,
  (VTBL_ENTRY)&_ZN6S263C63v20Ev,
  (VTBL_ENTRY)&_ZN6S263C63v21Ev,
  (VTBL_ENTRY)&_ZN6S263C63v22Ev,
  (VTBL_ENTRY)&_ZN6S263C63v23Ev,
  (VTBL_ENTRY)&_ZN6S263C63v24Ev,
  (VTBL_ENTRY)&_ZN6S263C63v25Ev,
  (VTBL_ENTRY)&_ZN6S263C63v26Ev,
  (VTBL_ENTRY)&_ZN6S263C63v27Ev,
  (VTBL_ENTRY)&_ZN6S263C63v28Ev,
  (VTBL_ENTRY)&_ZN6S263C63v29Ev,
  (VTBL_ENTRY)&_ZN6S263C63v30Ev,
  (VTBL_ENTRY)&_ZN6S263C63v31Ev,
  (VTBL_ENTRY)&_ZN6S263C63v32Ev,
  (VTBL_ENTRY)&_ZN6S263C63v33Ev,
  (VTBL_ENTRY)&_ZN6S263C63v34Ev,
  (VTBL_ENTRY)&_ZN6S263C63v35Ev,
  (VTBL_ENTRY)&_ZN6S263C63v36Ev,
  (VTBL_ENTRY)&_ZN6S263C63v37Ev,
  (VTBL_ENTRY)&_ZN6S263C63v38Ev,
  (VTBL_ENTRY)&_ZN6S263C63v39Ev,
  (VTBL_ENTRY)&_ZN6S263C63v40Ev,
  (VTBL_ENTRY)&_ZN6S263C63v41Ev,
  (VTBL_ENTRY)&_ZN6S263C63v42Ev,
  (VTBL_ENTRY)&_ZN6S263C63v43Ev,
  (VTBL_ENTRY)&_ZN6S263C63v44Ev,
  (VTBL_ENTRY)&_ZN6S263C63v45Ev,
  (VTBL_ENTRY)&_ZN6S263C63v46Ev,
  (VTBL_ENTRY)&_ZN6S263C63v47Ev,
  (VTBL_ENTRY)&_ZN6S263C63v48Ev,
  (VTBL_ENTRY)&_ZN6S263C63v49Ev,
  (VTBL_ENTRY)&_ZN6S263C63v50Ev,
  (VTBL_ENTRY)&_ZN6S263C63v51Ev,
  (VTBL_ENTRY)&_ZN6S263C63v52Ev,
  (VTBL_ENTRY)&_ZN6S263C63v53Ev,
  (VTBL_ENTRY)&_ZN6S263C63v54Ev,
  (VTBL_ENTRY)&_ZN6S263C63v55Ev,
  (VTBL_ENTRY)&_ZN6S263C63v56Ev,
  (VTBL_ENTRY)&_ZN6S263C63v57Ev,
  (VTBL_ENTRY)&_ZN6S263C63v58Ev,
  (VTBL_ENTRY)&_ZN6S263C63v59Ev,
  (VTBL_ENTRY)&_ZN6S263C63v60Ev,
  (VTBL_ENTRY)&_ZN6S263C63v61Ev,
  (VTBL_ENTRY)&_ZN6S263C63v62Ev,
  (VTBL_ENTRY)&_ZN6S263C63v63Ev,
  (VTBL_ENTRY)&_ZN6S263C63v64Ev,
  (VTBL_ENTRY)&_ZN6S263C63v65Ev,
  (VTBL_ENTRY)&_ZN6S263C63v66Ev,
  (VTBL_ENTRY)&_ZN6S263C63v67Ev,
  (VTBL_ENTRY)&_ZN6S263C63v68Ev,
  (VTBL_ENTRY)&_ZN6S263C63v69Ev,
};
extern VTBL_ENTRY _ZTI6S263C6[];
extern  VTBL_ENTRY _ZTV6S263C6[];
Class_Descriptor cd_S263C6 = {  "S263C6", // class name
  0,0,//no base classes
  &(vtc_S263C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S263C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S263C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C10  : S1406C8_nt {
};
//SIG(-1 S263C10) C1{ BC2{ m Fp Fi[2]}}



static void Test_S263C10()
{
  extern Class_Descriptor cd_S263C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S263C10, buf);
    S263C10 &lv = *(new (buf) S263C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S263C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S263C10)");
    check_base_class_offset(lv, (S1406C8_nt*), 0, "S263C10");
    test_class_info(&lv, &cd_S263C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS263C10(Test_S263C10, "S263C10", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
static Base_Class bases_S263C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S263C10 = {  "S263C10", // class name
  bases_S263C10, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C9  : S263C10 {
};
//SIG(-1 S263C9) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S263C9()
{
  extern Class_Descriptor cd_S263C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S263C9, buf);
    S263C9 &lv = *(new (buf) S263C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S263C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S263C9)");
    check_base_class_offset(lv, (S1406C8_nt*)(S263C10*), 0, "S263C9");
    check_base_class_offset(lv, (S263C10*), 0, "S263C9");
    test_class_info(&lv, &cd_S263C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS263C9(Test_S263C9, "S263C9", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
extern Class_Descriptor cd_S263C10;
static Base_Class bases_S263C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S263C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S263C9 = {  "S263C9", // class name
  bases_S263C9, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C8_nt  : S263C9 {
};
//SIG(-1 S263C8_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S263C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
extern Class_Descriptor cd_S263C10;
extern Class_Descriptor cd_S263C9;
static Base_Class bases_S263C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S263C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S263C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C5_nt  : S263C6 {
  int s263c5f0[2];
  void *s263c5f1;
  int s263c5f2[2];
  ::S263C8_nt s263c5f3;
  ::S263C8_nt s263c5f4;
  ::S16380C49 s263c5f5;
  ::S263C8_nt s263c5f6;
  unsigned int s263c5f7:1;
  unsigned int s263c5f8:1;
  unsigned int s263c5f9:1;
  unsigned int s263c5f10:1;
  unsigned int s263c5f11:1;
  int s263c5f12[2];
  virtual  ~S263C5_nt(); // _ZN9S263C5_ntD1Ev
  virtual void  v70(); // _ZN9S263C5_nt3v70Ev
  virtual void  v71(); // _ZN9S263C5_nt3v71Ev
  virtual void  v72(); // _ZN9S263C5_nt3v72Ev
  virtual void  v73(); // _ZN9S263C5_nt3v73Ev
  virtual void  v74(); // _ZN9S263C5_nt3v74Ev
  virtual void  v75(); // _ZN9S263C5_nt3v75Ev
  virtual void  v76(); // _ZN9S263C5_nt3v76Ev
  virtual void  v77(); // _ZN9S263C5_nt3v77Ev
  virtual void  v78(); // _ZN9S263C5_nt3v78Ev
  virtual void  v79(); // _ZN9S263C5_nt3v79Ev
  virtual void  v80(); // _ZN9S263C5_nt3v80Ev
  virtual void  v81(); // _ZN9S263C5_nt3v81Ev
  virtual void  v82(); // _ZN9S263C5_nt3v82Ev
  virtual void  v83(); // _ZN9S263C5_nt3v83Ev
  virtual void  v84(); // _ZN9S263C5_nt3v84Ev
  virtual void  v85(); // _ZN9S263C5_nt3v85Ev
  virtual void  v86(); // _ZN9S263C5_nt3v86Ev
  virtual void  v87(); // _ZN9S263C5_nt3v87Ev
  virtual void  v88(); // _ZN9S263C5_nt3v88Ev
  virtual void  v89(); // _ZN9S263C5_nt3v89Ev
  virtual void  v90(); // _ZN9S263C5_nt3v90Ev
  virtual void  v91(); // _ZN9S263C5_nt3v91Ev
  S263C5_nt(); // tgen
};
//SIG(-1 S263C5_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S263C5_nt ::~S263C5_nt(){ note_dtor("S263C5_nt", this);}
void  S263C5_nt ::v70(){vfunc_called(this, "_ZN9S263C5_nt3v70Ev");}
void  S263C5_nt ::v71(){vfunc_called(this, "_ZN9S263C5_nt3v71Ev");}
void  S263C5_nt ::v72(){vfunc_called(this, "_ZN9S263C5_nt3v72Ev");}
void  S263C5_nt ::v73(){vfunc_called(this, "_ZN9S263C5_nt3v73Ev");}
void  S263C5_nt ::v74(){vfunc_called(this, "_ZN9S263C5_nt3v74Ev");}
void  S263C5_nt ::v75(){vfunc_called(this, "_ZN9S263C5_nt3v75Ev");}
void  S263C5_nt ::v76(){vfunc_called(this, "_ZN9S263C5_nt3v76Ev");}
void  S263C5_nt ::v77(){vfunc_called(this, "_ZN9S263C5_nt3v77Ev");}
void  S263C5_nt ::v78(){vfunc_called(this, "_ZN9S263C5_nt3v78Ev");}
void  S263C5_nt ::v79(){vfunc_called(this, "_ZN9S263C5_nt3v79Ev");}
void  S263C5_nt ::v80(){vfunc_called(this, "_ZN9S263C5_nt3v80Ev");}
void  S263C5_nt ::v81(){vfunc_called(this, "_ZN9S263C5_nt3v81Ev");}
void  S263C5_nt ::v82(){vfunc_called(this, "_ZN9S263C5_nt3v82Ev");}
void  S263C5_nt ::v83(){vfunc_called(this, "_ZN9S263C5_nt3v83Ev");}
void  S263C5_nt ::v84(){vfunc_called(this, "_ZN9S263C5_nt3v84Ev");}
void  S263C5_nt ::v85(){vfunc_called(this, "_ZN9S263C5_nt3v85Ev");}
void  S263C5_nt ::v86(){vfunc_called(this, "_ZN9S263C5_nt3v86Ev");}
void  S263C5_nt ::v87(){vfunc_called(this, "_ZN9S263C5_nt3v87Ev");}
void  S263C5_nt ::v88(){vfunc_called(this, "_ZN9S263C5_nt3v88Ev");}
void  S263C5_nt ::v89(){vfunc_called(this, "_ZN9S263C5_nt3v89Ev");}
void  S263C5_nt ::v90(){vfunc_called(this, "_ZN9S263C5_nt3v90Ev");}
void  S263C5_nt ::v91(){vfunc_called(this, "_ZN9S263C5_nt3v91Ev");}
S263C5_nt ::S263C5_nt(){ note_ctor("S263C5_nt", this);} // tgen

//skip512 S263C5_nt

#else // __cplusplus

extern void _ZN9S263C5_ntC1Ev();
extern void _ZN9S263C5_ntD1Ev();
Name_Map name_map_S263C5_nt[] = {
  NSPAIR(_ZN9S263C5_ntC1Ev),
  NSPAIR(_ZN9S263C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S263C6;
extern VTBL_ENTRY _ZTI6S263C6[];
extern  VTBL_ENTRY _ZTV6S263C6[];
static Base_Class bases_S263C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S263C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S263C5_nt[];
extern void _ZN9S263C5_ntD1Ev();
extern void _ZN9S263C5_ntD0Ev();
extern void _ZN6S263C62v6Ev();
extern void _ZN6S263C62v7Ev();
extern void _ZN6S263C62v8Ev();
extern void _ZN6S263C62v9Ev();
extern void _ZN6S263C63v10Ev();
extern void _ZN6S263C63v11Ev();
extern void _ZN6S263C63v12Ev();
extern void _ZN6S263C63v13Ev();
extern void _ZN6S263C63v14Ev();
extern void _ZN6S263C63v15Ev();
extern void _ZN6S263C63v16Ev();
extern void _ZN6S263C63v17Ev();
extern void _ZN6S263C63v18Ev();
extern void _ZN6S263C63v19Ev();
extern void _ZN6S263C63v20Ev();
extern void _ZN6S263C63v21Ev();
extern void _ZN6S263C63v22Ev();
extern void _ZN6S263C63v23Ev();
extern void _ZN6S263C63v24Ev();
extern void _ZN6S263C63v25Ev();
extern void _ZN6S263C63v26Ev();
extern void _ZN6S263C63v27Ev();
extern void _ZN6S263C63v28Ev();
extern void _ZN6S263C63v29Ev();
extern void _ZN6S263C63v30Ev();
extern void _ZN6S263C63v31Ev();
extern void _ZN6S263C63v32Ev();
extern void _ZN6S263C63v33Ev();
extern void _ZN6S263C63v34Ev();
extern void _ZN6S263C63v35Ev();
extern void _ZN6S263C63v36Ev();
extern void _ZN6S263C63v37Ev();
extern void _ZN6S263C63v38Ev();
extern void _ZN6S263C63v39Ev();
extern void _ZN6S263C63v40Ev();
extern void _ZN6S263C63v41Ev();
extern void _ZN6S263C63v42Ev();
extern void _ZN6S263C63v43Ev();
extern void _ZN6S263C63v44Ev();
extern void _ZN6S263C63v45Ev();
extern void _ZN6S263C63v46Ev();
extern void _ZN6S263C63v47Ev();
extern void _ZN6S263C63v48Ev();
extern void _ZN6S263C63v49Ev();
extern void _ZN6S263C63v50Ev();
extern void _ZN6S263C63v51Ev();
extern void _ZN6S263C63v52Ev();
extern void _ZN6S263C63v53Ev();
extern void _ZN6S263C63v54Ev();
extern void _ZN6S263C63v55Ev();
extern void _ZN6S263C63v56Ev();
extern void _ZN6S263C63v57Ev();
extern void _ZN6S263C63v58Ev();
extern void _ZN6S263C63v59Ev();
extern void _ZN6S263C63v60Ev();
extern void _ZN6S263C63v61Ev();
extern void _ZN6S263C63v62Ev();
extern void _ZN6S263C63v63Ev();
extern void _ZN6S263C63v64Ev();
extern void _ZN6S263C63v65Ev();
extern void _ZN6S263C63v66Ev();
extern void _ZN6S263C63v67Ev();
extern void _ZN6S263C63v68Ev();
extern void _ZN6S263C63v69Ev();
extern void _ZN9S263C5_nt3v70Ev();
extern void _ZN9S263C5_nt3v71Ev();
extern void _ZN9S263C5_nt3v72Ev();
extern void _ZN9S263C5_nt3v73Ev();
extern void _ZN9S263C5_nt3v74Ev();
extern void _ZN9S263C5_nt3v75Ev();
extern void _ZN9S263C5_nt3v76Ev();
extern void _ZN9S263C5_nt3v77Ev();
extern void _ZN9S263C5_nt3v78Ev();
extern void _ZN9S263C5_nt3v79Ev();
extern void _ZN9S263C5_nt3v80Ev();
extern void _ZN9S263C5_nt3v81Ev();
extern void _ZN9S263C5_nt3v82Ev();
extern void _ZN9S263C5_nt3v83Ev();
extern void _ZN9S263C5_nt3v84Ev();
extern void _ZN9S263C5_nt3v85Ev();
extern void _ZN9S263C5_nt3v86Ev();
extern void _ZN9S263C5_nt3v87Ev();
extern void _ZN9S263C5_nt3v88Ev();
extern void _ZN9S263C5_nt3v89Ev();
extern void _ZN9S263C5_nt3v90Ev();
extern void _ZN9S263C5_nt3v91Ev();
static  VTBL_ENTRY vtc_S263C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S263C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S263C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S263C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S263C62v6Ev,
  (VTBL_ENTRY)&_ZN6S263C62v7Ev,
  (VTBL_ENTRY)&_ZN6S263C62v8Ev,
  (VTBL_ENTRY)&_ZN6S263C62v9Ev,
  (VTBL_ENTRY)&_ZN6S263C63v10Ev,
  (VTBL_ENTRY)&_ZN6S263C63v11Ev,
  (VTBL_ENTRY)&_ZN6S263C63v12Ev,
  (VTBL_ENTRY)&_ZN6S263C63v13Ev,
  (VTBL_ENTRY)&_ZN6S263C63v14Ev,
  (VTBL_ENTRY)&_ZN6S263C63v15Ev,
  (VTBL_ENTRY)&_ZN6S263C63v16Ev,
  (VTBL_ENTRY)&_ZN6S263C63v17Ev,
  (VTBL_ENTRY)&_ZN6S263C63v18Ev,
  (VTBL_ENTRY)&_ZN6S263C63v19Ev,
  (VTBL_ENTRY)&_ZN6S263C63v20Ev,
  (VTBL_ENTRY)&_ZN6S263C63v21Ev,
  (VTBL_ENTRY)&_ZN6S263C63v22Ev,
  (VTBL_ENTRY)&_ZN6S263C63v23Ev,
  (VTBL_ENTRY)&_ZN6S263C63v24Ev,
  (VTBL_ENTRY)&_ZN6S263C63v25Ev,
  (VTBL_ENTRY)&_ZN6S263C63v26Ev,
  (VTBL_ENTRY)&_ZN6S263C63v27Ev,
  (VTBL_ENTRY)&_ZN6S263C63v28Ev,
  (VTBL_ENTRY)&_ZN6S263C63v29Ev,
  (VTBL_ENTRY)&_ZN6S263C63v30Ev,
  (VTBL_ENTRY)&_ZN6S263C63v31Ev,
  (VTBL_ENTRY)&_ZN6S263C63v32Ev,
  (VTBL_ENTRY)&_ZN6S263C63v33Ev,
  (VTBL_ENTRY)&_ZN6S263C63v34Ev,
  (VTBL_ENTRY)&_ZN6S263C63v35Ev,
  (VTBL_ENTRY)&_ZN6S263C63v36Ev,
  (VTBL_ENTRY)&_ZN6S263C63v37Ev,
  (VTBL_ENTRY)&_ZN6S263C63v38Ev,
  (VTBL_ENTRY)&_ZN6S263C63v39Ev,
  (VTBL_ENTRY)&_ZN6S263C63v40Ev,
  (VTBL_ENTRY)&_ZN6S263C63v41Ev,
  (VTBL_ENTRY)&_ZN6S263C63v42Ev,
  (VTBL_ENTRY)&_ZN6S263C63v43Ev,
  (VTBL_ENTRY)&_ZN6S263C63v44Ev,
  (VTBL_ENTRY)&_ZN6S263C63v45Ev,
  (VTBL_ENTRY)&_ZN6S263C63v46Ev,
  (VTBL_ENTRY)&_ZN6S263C63v47Ev,
  (VTBL_ENTRY)&_ZN6S263C63v48Ev,
  (VTBL_ENTRY)&_ZN6S263C63v49Ev,
  (VTBL_ENTRY)&_ZN6S263C63v50Ev,
  (VTBL_ENTRY)&_ZN6S263C63v51Ev,
  (VTBL_ENTRY)&_ZN6S263C63v52Ev,
  (VTBL_ENTRY)&_ZN6S263C63v53Ev,
  (VTBL_ENTRY)&_ZN6S263C63v54Ev,
  (VTBL_ENTRY)&_ZN6S263C63v55Ev,
  (VTBL_ENTRY)&_ZN6S263C63v56Ev,
  (VTBL_ENTRY)&_ZN6S263C63v57Ev,
  (VTBL_ENTRY)&_ZN6S263C63v58Ev,
  (VTBL_ENTRY)&_ZN6S263C63v59Ev,
  (VTBL_ENTRY)&_ZN6S263C63v60Ev,
  (VTBL_ENTRY)&_ZN6S263C63v61Ev,
  (VTBL_ENTRY)&_ZN6S263C63v62Ev,
  (VTBL_ENTRY)&_ZN6S263C63v63Ev,
  (VTBL_ENTRY)&_ZN6S263C63v64Ev,
  (VTBL_ENTRY)&_ZN6S263C63v65Ev,
  (VTBL_ENTRY)&_ZN6S263C63v66Ev,
  (VTBL_ENTRY)&_ZN6S263C63v67Ev,
  (VTBL_ENTRY)&_ZN6S263C63v68Ev,
  (VTBL_ENTRY)&_ZN6S263C63v69Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v91Ev,
};
extern VTBL_ENTRY _ZTI9S263C5_nt[];
VTBL_ENTRY *P__ZTI9S263C5_nt = _ZTI9S263C5_nt; 
extern  VTBL_ENTRY _ZTV9S263C5_nt[];
Class_Descriptor cd_S263C5_nt = {  "S263C5_nt", // class name
  bases_S263C5_nt, 1,
  &(vtc_S263C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S263C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S263C5_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C4_nt  : S263C5_nt {
  unsigned int s263c4f0:1;
  unsigned int s263c4f1:1;
  unsigned int s263c4f2:1;
  ::S1406C28 s263c4f3;
  ::S1406C24 s263c4f4;
  ::S1406C18 s263c4f5;
  ::S1406C12 s263c4f6;
  int s263c4f7[3];
  virtual  ~S263C4_nt(); // _ZN9S263C4_ntD1Ev
  virtual void  v92(); // _ZN9S263C4_nt3v92Ev
  virtual void  v93(); // _ZN9S263C4_nt3v93Ev
  virtual void  v94(); // _ZN9S263C4_nt3v94Ev
  virtual void  v95(); // _ZN9S263C4_nt3v95Ev
  virtual void  v96(); // _ZN9S263C4_nt3v96Ev
  virtual void  v97(); // _ZN9S263C4_nt3v97Ev
  virtual void  v98(); // _ZN9S263C4_nt3v98Ev
  virtual void  v99(); // _ZN9S263C4_nt3v99Ev
  virtual void  v100(); // _ZN9S263C4_nt4v100Ev
  virtual void  v101(); // _ZN9S263C4_nt4v101Ev
  virtual void  v102(); // _ZN9S263C4_nt4v102Ev
  virtual void  v103(); // _ZN9S263C4_nt4v103Ev
  virtual void  v104(); // _ZN9S263C4_nt4v104Ev
  virtual void  v105(); // _ZN9S263C4_nt4v105Ev
  virtual void  v106(); // _ZN9S263C4_nt4v106Ev
  virtual void  v107(); // _ZN9S263C4_nt4v107Ev
  virtual void  v108(); // _ZN9S263C4_nt4v108Ev
  virtual void  v109(); // _ZN9S263C4_nt4v109Ev
  virtual void  v110(); // _ZN9S263C4_nt4v110Ev
  virtual void  v111(); // _ZN9S263C4_nt4v111Ev
  S263C4_nt(); // tgen
};
//SIG(-1 S263C4_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S263C4_nt ::~S263C4_nt(){ note_dtor("S263C4_nt", this);}
void  S263C4_nt ::v92(){vfunc_called(this, "_ZN9S263C4_nt3v92Ev");}
void  S263C4_nt ::v93(){vfunc_called(this, "_ZN9S263C4_nt3v93Ev");}
void  S263C4_nt ::v94(){vfunc_called(this, "_ZN9S263C4_nt3v94Ev");}
void  S263C4_nt ::v95(){vfunc_called(this, "_ZN9S263C4_nt3v95Ev");}
void  S263C4_nt ::v96(){vfunc_called(this, "_ZN9S263C4_nt3v96Ev");}
void  S263C4_nt ::v97(){vfunc_called(this, "_ZN9S263C4_nt3v97Ev");}
void  S263C4_nt ::v98(){vfunc_called(this, "_ZN9S263C4_nt3v98Ev");}
void  S263C4_nt ::v99(){vfunc_called(this, "_ZN9S263C4_nt3v99Ev");}
void  S263C4_nt ::v100(){vfunc_called(this, "_ZN9S263C4_nt4v100Ev");}
void  S263C4_nt ::v101(){vfunc_called(this, "_ZN9S263C4_nt4v101Ev");}
void  S263C4_nt ::v102(){vfunc_called(this, "_ZN9S263C4_nt4v102Ev");}
void  S263C4_nt ::v103(){vfunc_called(this, "_ZN9S263C4_nt4v103Ev");}
void  S263C4_nt ::v104(){vfunc_called(this, "_ZN9S263C4_nt4v104Ev");}
void  S263C4_nt ::v105(){vfunc_called(this, "_ZN9S263C4_nt4v105Ev");}
void  S263C4_nt ::v106(){vfunc_called(this, "_ZN9S263C4_nt4v106Ev");}
void  S263C4_nt ::v107(){vfunc_called(this, "_ZN9S263C4_nt4v107Ev");}
void  S263C4_nt ::v108(){vfunc_called(this, "_ZN9S263C4_nt4v108Ev");}
void  S263C4_nt ::v109(){vfunc_called(this, "_ZN9S263C4_nt4v109Ev");}
void  S263C4_nt ::v110(){vfunc_called(this, "_ZN9S263C4_nt4v110Ev");}
void  S263C4_nt ::v111(){vfunc_called(this, "_ZN9S263C4_nt4v111Ev");}
S263C4_nt ::S263C4_nt(){ note_ctor("S263C4_nt", this);} // tgen

//skip512 S263C4_nt

#else // __cplusplus

extern void _ZN9S263C4_ntC1Ev();
extern void _ZN9S263C4_ntD1Ev();
Name_Map name_map_S263C4_nt[] = {
  NSPAIR(_ZN9S263C4_ntC1Ev),
  NSPAIR(_ZN9S263C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S263C6;
extern VTBL_ENTRY _ZTI6S263C6[];
extern  VTBL_ENTRY _ZTV6S263C6[];
extern Class_Descriptor cd_S263C5_nt;
extern VTBL_ENTRY _ZTI9S263C5_nt[];
extern  VTBL_ENTRY _ZTV9S263C5_nt[];
static Base_Class bases_S263C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S263C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S263C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S263C4_nt[];
extern void _ZN9S263C4_ntD1Ev();
extern void _ZN9S263C4_ntD0Ev();
extern void _ZN6S263C62v6Ev();
extern void _ZN6S263C62v7Ev();
extern void _ZN6S263C62v8Ev();
extern void _ZN6S263C62v9Ev();
extern void _ZN6S263C63v10Ev();
extern void _ZN6S263C63v11Ev();
extern void _ZN6S263C63v12Ev();
extern void _ZN6S263C63v13Ev();
extern void _ZN6S263C63v14Ev();
extern void _ZN6S263C63v15Ev();
extern void _ZN6S263C63v16Ev();
extern void _ZN6S263C63v17Ev();
extern void _ZN6S263C63v18Ev();
extern void _ZN6S263C63v19Ev();
extern void _ZN6S263C63v20Ev();
extern void _ZN6S263C63v21Ev();
extern void _ZN6S263C63v22Ev();
extern void _ZN6S263C63v23Ev();
extern void _ZN6S263C63v24Ev();
extern void _ZN6S263C63v25Ev();
extern void _ZN6S263C63v26Ev();
extern void _ZN6S263C63v27Ev();
extern void _ZN6S263C63v28Ev();
extern void _ZN6S263C63v29Ev();
extern void _ZN6S263C63v30Ev();
extern void _ZN6S263C63v31Ev();
extern void _ZN6S263C63v32Ev();
extern void _ZN6S263C63v33Ev();
extern void _ZN6S263C63v34Ev();
extern void _ZN6S263C63v35Ev();
extern void _ZN6S263C63v36Ev();
extern void _ZN6S263C63v37Ev();
extern void _ZN6S263C63v38Ev();
extern void _ZN6S263C63v39Ev();
extern void _ZN6S263C63v40Ev();
extern void _ZN6S263C63v41Ev();
extern void _ZN6S263C63v42Ev();
extern void _ZN6S263C63v43Ev();
extern void _ZN6S263C63v44Ev();
extern void _ZN6S263C63v45Ev();
extern void _ZN6S263C63v46Ev();
extern void _ZN6S263C63v47Ev();
extern void _ZN6S263C63v48Ev();
extern void _ZN6S263C63v49Ev();
extern void _ZN6S263C63v50Ev();
extern void _ZN6S263C63v51Ev();
extern void _ZN6S263C63v52Ev();
extern void _ZN6S263C63v53Ev();
extern void _ZN6S263C63v54Ev();
extern void _ZN6S263C63v55Ev();
extern void _ZN6S263C63v56Ev();
extern void _ZN6S263C63v57Ev();
extern void _ZN6S263C63v58Ev();
extern void _ZN6S263C63v59Ev();
extern void _ZN6S263C63v60Ev();
extern void _ZN6S263C63v61Ev();
extern void _ZN6S263C63v62Ev();
extern void _ZN6S263C63v63Ev();
extern void _ZN6S263C63v64Ev();
extern void _ZN6S263C63v65Ev();
extern void _ZN6S263C63v66Ev();
extern void _ZN6S263C63v67Ev();
extern void _ZN6S263C63v68Ev();
extern void _ZN6S263C63v69Ev();
extern void _ZN9S263C5_nt3v70Ev();
extern void _ZN9S263C5_nt3v71Ev();
extern void _ZN9S263C5_nt3v72Ev();
extern void _ZN9S263C5_nt3v73Ev();
extern void _ZN9S263C5_nt3v74Ev();
extern void _ZN9S263C5_nt3v75Ev();
extern void _ZN9S263C5_nt3v76Ev();
extern void _ZN9S263C5_nt3v77Ev();
extern void _ZN9S263C5_nt3v78Ev();
extern void _ZN9S263C5_nt3v79Ev();
extern void _ZN9S263C5_nt3v80Ev();
extern void _ZN9S263C5_nt3v81Ev();
extern void _ZN9S263C5_nt3v82Ev();
extern void _ZN9S263C5_nt3v83Ev();
extern void _ZN9S263C5_nt3v84Ev();
extern void _ZN9S263C5_nt3v85Ev();
extern void _ZN9S263C5_nt3v86Ev();
extern void _ZN9S263C5_nt3v87Ev();
extern void _ZN9S263C5_nt3v88Ev();
extern void _ZN9S263C5_nt3v89Ev();
extern void _ZN9S263C5_nt3v90Ev();
extern void _ZN9S263C5_nt3v91Ev();
extern void _ZN9S263C4_nt3v92Ev();
extern void _ZN9S263C4_nt3v93Ev();
extern void _ZN9S263C4_nt3v94Ev();
extern void _ZN9S263C4_nt3v95Ev();
extern void _ZN9S263C4_nt3v96Ev();
extern void _ZN9S263C4_nt3v97Ev();
extern void _ZN9S263C4_nt3v98Ev();
extern void _ZN9S263C4_nt3v99Ev();
extern void _ZN9S263C4_nt4v100Ev();
extern void _ZN9S263C4_nt4v101Ev();
extern void _ZN9S263C4_nt4v102Ev();
extern void _ZN9S263C4_nt4v103Ev();
extern void _ZN9S263C4_nt4v104Ev();
extern void _ZN9S263C4_nt4v105Ev();
extern void _ZN9S263C4_nt4v106Ev();
extern void _ZN9S263C4_nt4v107Ev();
extern void _ZN9S263C4_nt4v108Ev();
extern void _ZN9S263C4_nt4v109Ev();
extern void _ZN9S263C4_nt4v110Ev();
extern void _ZN9S263C4_nt4v111Ev();
static  VTBL_ENTRY vtc_S263C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S263C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S263C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S263C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S263C62v6Ev,
  (VTBL_ENTRY)&_ZN6S263C62v7Ev,
  (VTBL_ENTRY)&_ZN6S263C62v8Ev,
  (VTBL_ENTRY)&_ZN6S263C62v9Ev,
  (VTBL_ENTRY)&_ZN6S263C63v10Ev,
  (VTBL_ENTRY)&_ZN6S263C63v11Ev,
  (VTBL_ENTRY)&_ZN6S263C63v12Ev,
  (VTBL_ENTRY)&_ZN6S263C63v13Ev,
  (VTBL_ENTRY)&_ZN6S263C63v14Ev,
  (VTBL_ENTRY)&_ZN6S263C63v15Ev,
  (VTBL_ENTRY)&_ZN6S263C63v16Ev,
  (VTBL_ENTRY)&_ZN6S263C63v17Ev,
  (VTBL_ENTRY)&_ZN6S263C63v18Ev,
  (VTBL_ENTRY)&_ZN6S263C63v19Ev,
  (VTBL_ENTRY)&_ZN6S263C63v20Ev,
  (VTBL_ENTRY)&_ZN6S263C63v21Ev,
  (VTBL_ENTRY)&_ZN6S263C63v22Ev,
  (VTBL_ENTRY)&_ZN6S263C63v23Ev,
  (VTBL_ENTRY)&_ZN6S263C63v24Ev,
  (VTBL_ENTRY)&_ZN6S263C63v25Ev,
  (VTBL_ENTRY)&_ZN6S263C63v26Ev,
  (VTBL_ENTRY)&_ZN6S263C63v27Ev,
  (VTBL_ENTRY)&_ZN6S263C63v28Ev,
  (VTBL_ENTRY)&_ZN6S263C63v29Ev,
  (VTBL_ENTRY)&_ZN6S263C63v30Ev,
  (VTBL_ENTRY)&_ZN6S263C63v31Ev,
  (VTBL_ENTRY)&_ZN6S263C63v32Ev,
  (VTBL_ENTRY)&_ZN6S263C63v33Ev,
  (VTBL_ENTRY)&_ZN6S263C63v34Ev,
  (VTBL_ENTRY)&_ZN6S263C63v35Ev,
  (VTBL_ENTRY)&_ZN6S263C63v36Ev,
  (VTBL_ENTRY)&_ZN6S263C63v37Ev,
  (VTBL_ENTRY)&_ZN6S263C63v38Ev,
  (VTBL_ENTRY)&_ZN6S263C63v39Ev,
  (VTBL_ENTRY)&_ZN6S263C63v40Ev,
  (VTBL_ENTRY)&_ZN6S263C63v41Ev,
  (VTBL_ENTRY)&_ZN6S263C63v42Ev,
  (VTBL_ENTRY)&_ZN6S263C63v43Ev,
  (VTBL_ENTRY)&_ZN6S263C63v44Ev,
  (VTBL_ENTRY)&_ZN6S263C63v45Ev,
  (VTBL_ENTRY)&_ZN6S263C63v46Ev,
  (VTBL_ENTRY)&_ZN6S263C63v47Ev,
  (VTBL_ENTRY)&_ZN6S263C63v48Ev,
  (VTBL_ENTRY)&_ZN6S263C63v49Ev,
  (VTBL_ENTRY)&_ZN6S263C63v50Ev,
  (VTBL_ENTRY)&_ZN6S263C63v51Ev,
  (VTBL_ENTRY)&_ZN6S263C63v52Ev,
  (VTBL_ENTRY)&_ZN6S263C63v53Ev,
  (VTBL_ENTRY)&_ZN6S263C63v54Ev,
  (VTBL_ENTRY)&_ZN6S263C63v55Ev,
  (VTBL_ENTRY)&_ZN6S263C63v56Ev,
  (VTBL_ENTRY)&_ZN6S263C63v57Ev,
  (VTBL_ENTRY)&_ZN6S263C63v58Ev,
  (VTBL_ENTRY)&_ZN6S263C63v59Ev,
  (VTBL_ENTRY)&_ZN6S263C63v60Ev,
  (VTBL_ENTRY)&_ZN6S263C63v61Ev,
  (VTBL_ENTRY)&_ZN6S263C63v62Ev,
  (VTBL_ENTRY)&_ZN6S263C63v63Ev,
  (VTBL_ENTRY)&_ZN6S263C63v64Ev,
  (VTBL_ENTRY)&_ZN6S263C63v65Ev,
  (VTBL_ENTRY)&_ZN6S263C63v66Ev,
  (VTBL_ENTRY)&_ZN6S263C63v67Ev,
  (VTBL_ENTRY)&_ZN6S263C63v68Ev,
  (VTBL_ENTRY)&_ZN6S263C63v69Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v111Ev,
};
extern VTBL_ENTRY _ZTI9S263C4_nt[];
VTBL_ENTRY *P__ZTI9S263C4_nt = _ZTI9S263C4_nt; 
extern  VTBL_ENTRY _ZTV9S263C4_nt[];
Class_Descriptor cd_S263C4_nt = {  "S263C4_nt", // class name
  bases_S263C4_nt, 2,
  &(vtc_S263C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S263C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S263C4_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C3_nt  : S263C4_nt {
  ::S1406C5_nt s263c3f0;
  unsigned int s263c3f1:1;
  ::S1406C6_nt s263c3f2;
  virtual  ~S263C3_nt(); // _ZN9S263C3_ntD1Ev
  virtual void  v112(); // _ZN9S263C3_nt4v112Ev
  virtual void  v113(); // _ZN9S263C3_nt4v113Ev
  virtual void  v114(); // _ZN9S263C3_nt4v114Ev
  virtual void  v115(); // _ZN9S263C3_nt4v115Ev
  S263C3_nt(); // tgen
};
//SIG(-1 S263C3_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S263C3_nt ::~S263C3_nt(){ note_dtor("S263C3_nt", this);}
void  S263C3_nt ::v112(){vfunc_called(this, "_ZN9S263C3_nt4v112Ev");}
void  S263C3_nt ::v113(){vfunc_called(this, "_ZN9S263C3_nt4v113Ev");}
void  S263C3_nt ::v114(){vfunc_called(this, "_ZN9S263C3_nt4v114Ev");}
void  S263C3_nt ::v115(){vfunc_called(this, "_ZN9S263C3_nt4v115Ev");}
S263C3_nt ::S263C3_nt(){ note_ctor("S263C3_nt", this);} // tgen

//skip512 S263C3_nt

#else // __cplusplus

extern void _ZN9S263C3_ntC1Ev();
extern void _ZN9S263C3_ntD1Ev();
Name_Map name_map_S263C3_nt[] = {
  NSPAIR(_ZN9S263C3_ntC1Ev),
  NSPAIR(_ZN9S263C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S263C6;
extern VTBL_ENTRY _ZTI6S263C6[];
extern  VTBL_ENTRY _ZTV6S263C6[];
extern Class_Descriptor cd_S263C5_nt;
extern VTBL_ENTRY _ZTI9S263C5_nt[];
extern  VTBL_ENTRY _ZTV9S263C5_nt[];
extern Class_Descriptor cd_S263C4_nt;
extern VTBL_ENTRY _ZTI9S263C4_nt[];
extern  VTBL_ENTRY _ZTV9S263C4_nt[];
static Base_Class bases_S263C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S263C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S263C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S263C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S263C3_nt[];
extern void _ZN9S263C3_ntD1Ev();
extern void _ZN9S263C3_ntD0Ev();
extern void _ZN6S263C62v6Ev();
extern void _ZN6S263C62v7Ev();
extern void _ZN6S263C62v8Ev();
extern void _ZN6S263C62v9Ev();
extern void _ZN6S263C63v10Ev();
extern void _ZN6S263C63v11Ev();
extern void _ZN6S263C63v12Ev();
extern void _ZN6S263C63v13Ev();
extern void _ZN6S263C63v14Ev();
extern void _ZN6S263C63v15Ev();
extern void _ZN6S263C63v16Ev();
extern void _ZN6S263C63v17Ev();
extern void _ZN6S263C63v18Ev();
extern void _ZN6S263C63v19Ev();
extern void _ZN6S263C63v20Ev();
extern void _ZN6S263C63v21Ev();
extern void _ZN6S263C63v22Ev();
extern void _ZN6S263C63v23Ev();
extern void _ZN6S263C63v24Ev();
extern void _ZN6S263C63v25Ev();
extern void _ZN6S263C63v26Ev();
extern void _ZN6S263C63v27Ev();
extern void _ZN6S263C63v28Ev();
extern void _ZN6S263C63v29Ev();
extern void _ZN6S263C63v30Ev();
extern void _ZN6S263C63v31Ev();
extern void _ZN6S263C63v32Ev();
extern void _ZN6S263C63v33Ev();
extern void _ZN6S263C63v34Ev();
extern void _ZN6S263C63v35Ev();
extern void _ZN6S263C63v36Ev();
extern void _ZN6S263C63v37Ev();
extern void _ZN6S263C63v38Ev();
extern void _ZN6S263C63v39Ev();
extern void _ZN6S263C63v40Ev();
extern void _ZN6S263C63v41Ev();
extern void _ZN6S263C63v42Ev();
extern void _ZN6S263C63v43Ev();
extern void _ZN6S263C63v44Ev();
extern void _ZN6S263C63v45Ev();
extern void _ZN6S263C63v46Ev();
extern void _ZN6S263C63v47Ev();
extern void _ZN6S263C63v48Ev();
extern void _ZN6S263C63v49Ev();
extern void _ZN6S263C63v50Ev();
extern void _ZN6S263C63v51Ev();
extern void _ZN6S263C63v52Ev();
extern void _ZN6S263C63v53Ev();
extern void _ZN6S263C63v54Ev();
extern void _ZN6S263C63v55Ev();
extern void _ZN6S263C63v56Ev();
extern void _ZN6S263C63v57Ev();
extern void _ZN6S263C63v58Ev();
extern void _ZN6S263C63v59Ev();
extern void _ZN6S263C63v60Ev();
extern void _ZN6S263C63v61Ev();
extern void _ZN6S263C63v62Ev();
extern void _ZN6S263C63v63Ev();
extern void _ZN6S263C63v64Ev();
extern void _ZN6S263C63v65Ev();
extern void _ZN6S263C63v66Ev();
extern void _ZN6S263C63v67Ev();
extern void _ZN6S263C63v68Ev();
extern void _ZN6S263C63v69Ev();
extern void _ZN9S263C5_nt3v70Ev();
extern void _ZN9S263C5_nt3v71Ev();
extern void _ZN9S263C5_nt3v72Ev();
extern void _ZN9S263C5_nt3v73Ev();
extern void _ZN9S263C5_nt3v74Ev();
extern void _ZN9S263C5_nt3v75Ev();
extern void _ZN9S263C5_nt3v76Ev();
extern void _ZN9S263C5_nt3v77Ev();
extern void _ZN9S263C5_nt3v78Ev();
extern void _ZN9S263C5_nt3v79Ev();
extern void _ZN9S263C5_nt3v80Ev();
extern void _ZN9S263C5_nt3v81Ev();
extern void _ZN9S263C5_nt3v82Ev();
extern void _ZN9S263C5_nt3v83Ev();
extern void _ZN9S263C5_nt3v84Ev();
extern void _ZN9S263C5_nt3v85Ev();
extern void _ZN9S263C5_nt3v86Ev();
extern void _ZN9S263C5_nt3v87Ev();
extern void _ZN9S263C5_nt3v88Ev();
extern void _ZN9S263C5_nt3v89Ev();
extern void _ZN9S263C5_nt3v90Ev();
extern void _ZN9S263C5_nt3v91Ev();
extern void _ZN9S263C4_nt3v92Ev();
extern void _ZN9S263C4_nt3v93Ev();
extern void _ZN9S263C4_nt3v94Ev();
extern void _ZN9S263C4_nt3v95Ev();
extern void _ZN9S263C4_nt3v96Ev();
extern void _ZN9S263C4_nt3v97Ev();
extern void _ZN9S263C4_nt3v98Ev();
extern void _ZN9S263C4_nt3v99Ev();
extern void _ZN9S263C4_nt4v100Ev();
extern void _ZN9S263C4_nt4v101Ev();
extern void _ZN9S263C4_nt4v102Ev();
extern void _ZN9S263C4_nt4v103Ev();
extern void _ZN9S263C4_nt4v104Ev();
extern void _ZN9S263C4_nt4v105Ev();
extern void _ZN9S263C4_nt4v106Ev();
extern void _ZN9S263C4_nt4v107Ev();
extern void _ZN9S263C4_nt4v108Ev();
extern void _ZN9S263C4_nt4v109Ev();
extern void _ZN9S263C4_nt4v110Ev();
extern void _ZN9S263C4_nt4v111Ev();
extern void _ZN9S263C3_nt4v112Ev();
extern void _ZN9S263C3_nt4v113Ev();
extern void _ZN9S263C3_nt4v114Ev();
extern void _ZN9S263C3_nt4v115Ev();
static  VTBL_ENTRY vtc_S263C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S263C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S263C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S263C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S263C62v6Ev,
  (VTBL_ENTRY)&_ZN6S263C62v7Ev,
  (VTBL_ENTRY)&_ZN6S263C62v8Ev,
  (VTBL_ENTRY)&_ZN6S263C62v9Ev,
  (VTBL_ENTRY)&_ZN6S263C63v10Ev,
  (VTBL_ENTRY)&_ZN6S263C63v11Ev,
  (VTBL_ENTRY)&_ZN6S263C63v12Ev,
  (VTBL_ENTRY)&_ZN6S263C63v13Ev,
  (VTBL_ENTRY)&_ZN6S263C63v14Ev,
  (VTBL_ENTRY)&_ZN6S263C63v15Ev,
  (VTBL_ENTRY)&_ZN6S263C63v16Ev,
  (VTBL_ENTRY)&_ZN6S263C63v17Ev,
  (VTBL_ENTRY)&_ZN6S263C63v18Ev,
  (VTBL_ENTRY)&_ZN6S263C63v19Ev,
  (VTBL_ENTRY)&_ZN6S263C63v20Ev,
  (VTBL_ENTRY)&_ZN6S263C63v21Ev,
  (VTBL_ENTRY)&_ZN6S263C63v22Ev,
  (VTBL_ENTRY)&_ZN6S263C63v23Ev,
  (VTBL_ENTRY)&_ZN6S263C63v24Ev,
  (VTBL_ENTRY)&_ZN6S263C63v25Ev,
  (VTBL_ENTRY)&_ZN6S263C63v26Ev,
  (VTBL_ENTRY)&_ZN6S263C63v27Ev,
  (VTBL_ENTRY)&_ZN6S263C63v28Ev,
  (VTBL_ENTRY)&_ZN6S263C63v29Ev,
  (VTBL_ENTRY)&_ZN6S263C63v30Ev,
  (VTBL_ENTRY)&_ZN6S263C63v31Ev,
  (VTBL_ENTRY)&_ZN6S263C63v32Ev,
  (VTBL_ENTRY)&_ZN6S263C63v33Ev,
  (VTBL_ENTRY)&_ZN6S263C63v34Ev,
  (VTBL_ENTRY)&_ZN6S263C63v35Ev,
  (VTBL_ENTRY)&_ZN6S263C63v36Ev,
  (VTBL_ENTRY)&_ZN6S263C63v37Ev,
  (VTBL_ENTRY)&_ZN6S263C63v38Ev,
  (VTBL_ENTRY)&_ZN6S263C63v39Ev,
  (VTBL_ENTRY)&_ZN6S263C63v40Ev,
  (VTBL_ENTRY)&_ZN6S263C63v41Ev,
  (VTBL_ENTRY)&_ZN6S263C63v42Ev,
  (VTBL_ENTRY)&_ZN6S263C63v43Ev,
  (VTBL_ENTRY)&_ZN6S263C63v44Ev,
  (VTBL_ENTRY)&_ZN6S263C63v45Ev,
  (VTBL_ENTRY)&_ZN6S263C63v46Ev,
  (VTBL_ENTRY)&_ZN6S263C63v47Ev,
  (VTBL_ENTRY)&_ZN6S263C63v48Ev,
  (VTBL_ENTRY)&_ZN6S263C63v49Ev,
  (VTBL_ENTRY)&_ZN6S263C63v50Ev,
  (VTBL_ENTRY)&_ZN6S263C63v51Ev,
  (VTBL_ENTRY)&_ZN6S263C63v52Ev,
  (VTBL_ENTRY)&_ZN6S263C63v53Ev,
  (VTBL_ENTRY)&_ZN6S263C63v54Ev,
  (VTBL_ENTRY)&_ZN6S263C63v55Ev,
  (VTBL_ENTRY)&_ZN6S263C63v56Ev,
  (VTBL_ENTRY)&_ZN6S263C63v57Ev,
  (VTBL_ENTRY)&_ZN6S263C63v58Ev,
  (VTBL_ENTRY)&_ZN6S263C63v59Ev,
  (VTBL_ENTRY)&_ZN6S263C63v60Ev,
  (VTBL_ENTRY)&_ZN6S263C63v61Ev,
  (VTBL_ENTRY)&_ZN6S263C63v62Ev,
  (VTBL_ENTRY)&_ZN6S263C63v63Ev,
  (VTBL_ENTRY)&_ZN6S263C63v64Ev,
  (VTBL_ENTRY)&_ZN6S263C63v65Ev,
  (VTBL_ENTRY)&_ZN6S263C63v66Ev,
  (VTBL_ENTRY)&_ZN6S263C63v67Ev,
  (VTBL_ENTRY)&_ZN6S263C63v68Ev,
  (VTBL_ENTRY)&_ZN6S263C63v69Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v115Ev,
};
extern VTBL_ENTRY _ZTI9S263C3_nt[];
VTBL_ENTRY *P__ZTI9S263C3_nt = _ZTI9S263C3_nt; 
extern  VTBL_ENTRY _ZTV9S263C3_nt[];
Class_Descriptor cd_S263C3_nt = {  "S263C3_nt", // class name
  bases_S263C3_nt, 3,
  &(vtc_S263C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S263C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S263C3_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C24  : S1406C8_nt {
};
//SIG(-1 S263C24) C1{ BC2{ m Fp Fi[2]}}



static void Test_S263C24()
{
  extern Class_Descriptor cd_S263C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S263C24, buf);
    S263C24 &lv = *(new (buf) S263C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S263C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S263C24)");
    check_base_class_offset(lv, (S1406C8_nt*), 0, "S263C24");
    test_class_info(&lv, &cd_S263C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS263C24(Test_S263C24, "S263C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
static Base_Class bases_S263C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S263C24 = {  "S263C24", // class name
  bases_S263C24, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C23  : S263C24 {
};
//SIG(-1 S263C23) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S263C23()
{
  extern Class_Descriptor cd_S263C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S263C23, buf);
    S263C23 &lv = *(new (buf) S263C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S263C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S263C23)");
    check_base_class_offset(lv, (S1406C8_nt*)(S263C24*), 0, "S263C23");
    check_base_class_offset(lv, (S263C24*), 0, "S263C23");
    test_class_info(&lv, &cd_S263C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS263C23(Test_S263C23, "S263C23", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1406C8_nt;
extern Class_Descriptor cd_S263C24;
static Base_Class bases_S263C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1406C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S263C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S263C23 = {  "S263C23", // class name
  bases_S263C23, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C2_nt  : S263C3_nt {
  ::S263C23 s263c2f0;
  unsigned int s263c2f1:1;
  virtual  ~S263C2_nt(); // _ZN9S263C2_ntD1Ev
  virtual void  v116(); // _ZN9S263C2_nt4v116Ev
  virtual void  v117(); // _ZN9S263C2_nt4v117Ev
  virtual void  v118(); // _ZN9S263C2_nt4v118Ev
  virtual void  v119(); // _ZN9S263C2_nt4v119Ev
  virtual void  v120(); // _ZN9S263C2_nt4v120Ev
  virtual void  v121(); // _ZN9S263C2_nt4v121Ev
  virtual void  v122(); // _ZN9S263C2_nt4v122Ev
  S263C2_nt(); // tgen
};
//SIG(-1 S263C2_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v114 v115 v116 v117 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 FC22{ BC23{ BC10}} Fi:1}


 S263C2_nt ::~S263C2_nt(){ note_dtor("S263C2_nt", this);}
void  S263C2_nt ::v116(){vfunc_called(this, "_ZN9S263C2_nt4v116Ev");}
void  S263C2_nt ::v117(){vfunc_called(this, "_ZN9S263C2_nt4v117Ev");}
void  S263C2_nt ::v118(){vfunc_called(this, "_ZN9S263C2_nt4v118Ev");}
void  S263C2_nt ::v119(){vfunc_called(this, "_ZN9S263C2_nt4v119Ev");}
void  S263C2_nt ::v120(){vfunc_called(this, "_ZN9S263C2_nt4v120Ev");}
void  S263C2_nt ::v121(){vfunc_called(this, "_ZN9S263C2_nt4v121Ev");}
void  S263C2_nt ::v122(){vfunc_called(this, "_ZN9S263C2_nt4v122Ev");}
S263C2_nt ::S263C2_nt(){ note_ctor("S263C2_nt", this);} // tgen

//skip512 S263C2_nt

#else // __cplusplus

extern void _ZN9S263C2_ntC1Ev();
extern void _ZN9S263C2_ntD1Ev();
Name_Map name_map_S263C2_nt[] = {
  NSPAIR(_ZN9S263C2_ntC1Ev),
  NSPAIR(_ZN9S263C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S263C6;
extern VTBL_ENTRY _ZTI6S263C6[];
extern  VTBL_ENTRY _ZTV6S263C6[];
extern Class_Descriptor cd_S263C5_nt;
extern VTBL_ENTRY _ZTI9S263C5_nt[];
extern  VTBL_ENTRY _ZTV9S263C5_nt[];
extern Class_Descriptor cd_S263C4_nt;
extern VTBL_ENTRY _ZTI9S263C4_nt[];
extern  VTBL_ENTRY _ZTV9S263C4_nt[];
extern Class_Descriptor cd_S263C3_nt;
extern VTBL_ENTRY _ZTI9S263C3_nt[];
extern  VTBL_ENTRY _ZTV9S263C3_nt[];
static Base_Class bases_S263C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S263C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S263C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S263C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S263C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S263C2_nt[];
extern void _ZN9S263C2_ntD1Ev();
extern void _ZN9S263C2_ntD0Ev();
extern void _ZN6S263C62v6Ev();
extern void _ZN6S263C62v7Ev();
extern void _ZN6S263C62v8Ev();
extern void _ZN6S263C62v9Ev();
extern void _ZN6S263C63v10Ev();
extern void _ZN6S263C63v11Ev();
extern void _ZN6S263C63v12Ev();
extern void _ZN6S263C63v13Ev();
extern void _ZN6S263C63v14Ev();
extern void _ZN6S263C63v15Ev();
extern void _ZN6S263C63v16Ev();
extern void _ZN6S263C63v17Ev();
extern void _ZN6S263C63v18Ev();
extern void _ZN6S263C63v19Ev();
extern void _ZN6S263C63v20Ev();
extern void _ZN6S263C63v21Ev();
extern void _ZN6S263C63v22Ev();
extern void _ZN6S263C63v23Ev();
extern void _ZN6S263C63v24Ev();
extern void _ZN6S263C63v25Ev();
extern void _ZN6S263C63v26Ev();
extern void _ZN6S263C63v27Ev();
extern void _ZN6S263C63v28Ev();
extern void _ZN6S263C63v29Ev();
extern void _ZN6S263C63v30Ev();
extern void _ZN6S263C63v31Ev();
extern void _ZN6S263C63v32Ev();
extern void _ZN6S263C63v33Ev();
extern void _ZN6S263C63v34Ev();
extern void _ZN6S263C63v35Ev();
extern void _ZN6S263C63v36Ev();
extern void _ZN6S263C63v37Ev();
extern void _ZN6S263C63v38Ev();
extern void _ZN6S263C63v39Ev();
extern void _ZN6S263C63v40Ev();
extern void _ZN6S263C63v41Ev();
extern void _ZN6S263C63v42Ev();
extern void _ZN6S263C63v43Ev();
extern void _ZN6S263C63v44Ev();
extern void _ZN6S263C63v45Ev();
extern void _ZN6S263C63v46Ev();
extern void _ZN6S263C63v47Ev();
extern void _ZN6S263C63v48Ev();
extern void _ZN6S263C63v49Ev();
extern void _ZN6S263C63v50Ev();
extern void _ZN6S263C63v51Ev();
extern void _ZN6S263C63v52Ev();
extern void _ZN6S263C63v53Ev();
extern void _ZN6S263C63v54Ev();
extern void _ZN6S263C63v55Ev();
extern void _ZN6S263C63v56Ev();
extern void _ZN6S263C63v57Ev();
extern void _ZN6S263C63v58Ev();
extern void _ZN6S263C63v59Ev();
extern void _ZN6S263C63v60Ev();
extern void _ZN6S263C63v61Ev();
extern void _ZN6S263C63v62Ev();
extern void _ZN6S263C63v63Ev();
extern void _ZN6S263C63v64Ev();
extern void _ZN6S263C63v65Ev();
extern void _ZN6S263C63v66Ev();
extern void _ZN6S263C63v67Ev();
extern void _ZN6S263C63v68Ev();
extern void _ZN6S263C63v69Ev();
extern void _ZN9S263C5_nt3v70Ev();
extern void _ZN9S263C5_nt3v71Ev();
extern void _ZN9S263C5_nt3v72Ev();
extern void _ZN9S263C5_nt3v73Ev();
extern void _ZN9S263C5_nt3v74Ev();
extern void _ZN9S263C5_nt3v75Ev();
extern void _ZN9S263C5_nt3v76Ev();
extern void _ZN9S263C5_nt3v77Ev();
extern void _ZN9S263C5_nt3v78Ev();
extern void _ZN9S263C5_nt3v79Ev();
extern void _ZN9S263C5_nt3v80Ev();
extern void _ZN9S263C5_nt3v81Ev();
extern void _ZN9S263C5_nt3v82Ev();
extern void _ZN9S263C5_nt3v83Ev();
extern void _ZN9S263C5_nt3v84Ev();
extern void _ZN9S263C5_nt3v85Ev();
extern void _ZN9S263C5_nt3v86Ev();
extern void _ZN9S263C5_nt3v87Ev();
extern void _ZN9S263C5_nt3v88Ev();
extern void _ZN9S263C5_nt3v89Ev();
extern void _ZN9S263C5_nt3v90Ev();
extern void _ZN9S263C5_nt3v91Ev();
extern void _ZN9S263C4_nt3v92Ev();
extern void _ZN9S263C4_nt3v93Ev();
extern void _ZN9S263C4_nt3v94Ev();
extern void _ZN9S263C4_nt3v95Ev();
extern void _ZN9S263C4_nt3v96Ev();
extern void _ZN9S263C4_nt3v97Ev();
extern void _ZN9S263C4_nt3v98Ev();
extern void _ZN9S263C4_nt3v99Ev();
extern void _ZN9S263C4_nt4v100Ev();
extern void _ZN9S263C4_nt4v101Ev();
extern void _ZN9S263C4_nt4v102Ev();
extern void _ZN9S263C4_nt4v103Ev();
extern void _ZN9S263C4_nt4v104Ev();
extern void _ZN9S263C4_nt4v105Ev();
extern void _ZN9S263C4_nt4v106Ev();
extern void _ZN9S263C4_nt4v107Ev();
extern void _ZN9S263C4_nt4v108Ev();
extern void _ZN9S263C4_nt4v109Ev();
extern void _ZN9S263C4_nt4v110Ev();
extern void _ZN9S263C4_nt4v111Ev();
extern void _ZN9S263C3_nt4v112Ev();
extern void _ZN9S263C3_nt4v113Ev();
extern void _ZN9S263C3_nt4v114Ev();
extern void _ZN9S263C3_nt4v115Ev();
extern void _ZN9S263C2_nt4v116Ev();
extern void _ZN9S263C2_nt4v117Ev();
extern void _ZN9S263C2_nt4v118Ev();
extern void _ZN9S263C2_nt4v119Ev();
extern void _ZN9S263C2_nt4v120Ev();
extern void _ZN9S263C2_nt4v121Ev();
extern void _ZN9S263C2_nt4v122Ev();
static  VTBL_ENTRY vtc_S263C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S263C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S263C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S263C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S263C62v6Ev,
  (VTBL_ENTRY)&_ZN6S263C62v7Ev,
  (VTBL_ENTRY)&_ZN6S263C62v8Ev,
  (VTBL_ENTRY)&_ZN6S263C62v9Ev,
  (VTBL_ENTRY)&_ZN6S263C63v10Ev,
  (VTBL_ENTRY)&_ZN6S263C63v11Ev,
  (VTBL_ENTRY)&_ZN6S263C63v12Ev,
  (VTBL_ENTRY)&_ZN6S263C63v13Ev,
  (VTBL_ENTRY)&_ZN6S263C63v14Ev,
  (VTBL_ENTRY)&_ZN6S263C63v15Ev,
  (VTBL_ENTRY)&_ZN6S263C63v16Ev,
  (VTBL_ENTRY)&_ZN6S263C63v17Ev,
  (VTBL_ENTRY)&_ZN6S263C63v18Ev,
  (VTBL_ENTRY)&_ZN6S263C63v19Ev,
  (VTBL_ENTRY)&_ZN6S263C63v20Ev,
  (VTBL_ENTRY)&_ZN6S263C63v21Ev,
  (VTBL_ENTRY)&_ZN6S263C63v22Ev,
  (VTBL_ENTRY)&_ZN6S263C63v23Ev,
  (VTBL_ENTRY)&_ZN6S263C63v24Ev,
  (VTBL_ENTRY)&_ZN6S263C63v25Ev,
  (VTBL_ENTRY)&_ZN6S263C63v26Ev,
  (VTBL_ENTRY)&_ZN6S263C63v27Ev,
  (VTBL_ENTRY)&_ZN6S263C63v28Ev,
  (VTBL_ENTRY)&_ZN6S263C63v29Ev,
  (VTBL_ENTRY)&_ZN6S263C63v30Ev,
  (VTBL_ENTRY)&_ZN6S263C63v31Ev,
  (VTBL_ENTRY)&_ZN6S263C63v32Ev,
  (VTBL_ENTRY)&_ZN6S263C63v33Ev,
  (VTBL_ENTRY)&_ZN6S263C63v34Ev,
  (VTBL_ENTRY)&_ZN6S263C63v35Ev,
  (VTBL_ENTRY)&_ZN6S263C63v36Ev,
  (VTBL_ENTRY)&_ZN6S263C63v37Ev,
  (VTBL_ENTRY)&_ZN6S263C63v38Ev,
  (VTBL_ENTRY)&_ZN6S263C63v39Ev,
  (VTBL_ENTRY)&_ZN6S263C63v40Ev,
  (VTBL_ENTRY)&_ZN6S263C63v41Ev,
  (VTBL_ENTRY)&_ZN6S263C63v42Ev,
  (VTBL_ENTRY)&_ZN6S263C63v43Ev,
  (VTBL_ENTRY)&_ZN6S263C63v44Ev,
  (VTBL_ENTRY)&_ZN6S263C63v45Ev,
  (VTBL_ENTRY)&_ZN6S263C63v46Ev,
  (VTBL_ENTRY)&_ZN6S263C63v47Ev,
  (VTBL_ENTRY)&_ZN6S263C63v48Ev,
  (VTBL_ENTRY)&_ZN6S263C63v49Ev,
  (VTBL_ENTRY)&_ZN6S263C63v50Ev,
  (VTBL_ENTRY)&_ZN6S263C63v51Ev,
  (VTBL_ENTRY)&_ZN6S263C63v52Ev,
  (VTBL_ENTRY)&_ZN6S263C63v53Ev,
  (VTBL_ENTRY)&_ZN6S263C63v54Ev,
  (VTBL_ENTRY)&_ZN6S263C63v55Ev,
  (VTBL_ENTRY)&_ZN6S263C63v56Ev,
  (VTBL_ENTRY)&_ZN6S263C63v57Ev,
  (VTBL_ENTRY)&_ZN6S263C63v58Ev,
  (VTBL_ENTRY)&_ZN6S263C63v59Ev,
  (VTBL_ENTRY)&_ZN6S263C63v60Ev,
  (VTBL_ENTRY)&_ZN6S263C63v61Ev,
  (VTBL_ENTRY)&_ZN6S263C63v62Ev,
  (VTBL_ENTRY)&_ZN6S263C63v63Ev,
  (VTBL_ENTRY)&_ZN6S263C63v64Ev,
  (VTBL_ENTRY)&_ZN6S263C63v65Ev,
  (VTBL_ENTRY)&_ZN6S263C63v66Ev,
  (VTBL_ENTRY)&_ZN6S263C63v67Ev,
  (VTBL_ENTRY)&_ZN6S263C63v68Ev,
  (VTBL_ENTRY)&_ZN6S263C63v69Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v122Ev,
};
extern VTBL_ENTRY _ZTI9S263C2_nt[];
VTBL_ENTRY *P__ZTI9S263C2_nt = _ZTI9S263C2_nt; 
extern  VTBL_ENTRY _ZTV9S263C2_nt[];
Class_Descriptor cd_S263C2_nt = {  "S263C2_nt", // class name
  bases_S263C2_nt, 4,
  &(vtc_S263C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,236), // object size
  NSPAIRA(_ZTI9S263C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S263C2_nt),121, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S263C1  : S263C2_nt {
  void *s263c1f0;
  unsigned int s263c1f1:1;
  unsigned int s263c1f2:1;
  int s263c1f3[4];
  unsigned int s263c1f4:1;
  int s263c1f5;
  virtual  ~S263C1(); // _ZN6S263C1D1Ev
  virtual void  v1(); // _ZN6S263C12v1Ev
  virtual void  v2(); // _ZN6S263C12v2Ev
  virtual void  v3(); // _ZN6S263C12v3Ev
  virtual void  v4(); // _ZN6S263C12v4Ev
  virtual void  v5(); // _ZN6S263C12v5Ev
  S263C1(); // tgen
};
//SIG(1 S263C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v112 v113 v114 v115 FC7 Fi:1 FC21{ BC22{ BC11}}} vd v116 v117 v118 v119 v120 v121 v122 FC23{ BC24{ BC11}} Fi:1} vd v1 v2 v3 v4 v5 Fp Fi:1 Fi:1 Fi[4] Fi:1 Fi}


 S263C1 ::~S263C1(){ note_dtor("S263C1", this);}
void  S263C1 ::v1(){vfunc_called(this, "_ZN6S263C12v1Ev");}
void  S263C1 ::v2(){vfunc_called(this, "_ZN6S263C12v2Ev");}
void  S263C1 ::v3(){vfunc_called(this, "_ZN6S263C12v3Ev");}
void  S263C1 ::v4(){vfunc_called(this, "_ZN6S263C12v4Ev");}
void  S263C1 ::v5(){vfunc_called(this, "_ZN6S263C12v5Ev");}
S263C1 ::S263C1(){ note_ctor("S263C1", this);} // tgen

static void Test_S263C1()
{
  extern Class_Descriptor cd_S263C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,68)];
    init_test(&cd_S263C1, buf);
    S263C1 *dp, &lv = *(dp=new (buf) S263C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,268), "sizeof(S263C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S263C1)");
    check_base_class_offset(lv, (S263C6*)(S263C5_nt*)(S263C4_nt*)(S263C3_nt*)(S263C2_nt*), 0, "S263C1");
    check_base_class_offset(lv, (S263C5_nt*)(S263C4_nt*)(S263C3_nt*)(S263C2_nt*), 0, "S263C1");
    check_base_class_offset(lv, (S263C4_nt*)(S263C3_nt*)(S263C2_nt*), 0, "S263C1");
    check_base_class_offset(lv, (S263C3_nt*)(S263C2_nt*), 0, "S263C1");
    check_base_class_offset(lv, (S263C2_nt*), 0, "S263C1");
    check_field_offset(lv, s263c1f0, ABISELECT(320,236), "S263C1.s263c1f0");
    set_bf_and_test(lv, s263c1f1, ABISELECT(328,240), 0, 1, 1, "S263C1");
    set_bf_and_test(lv, s263c1f2, ABISELECT(328,240), 1, 1, 1, "S263C1");
    check_field_offset(lv, s263c1f3, ABISELECT(332,244), "S263C1.s263c1f3");
    set_bf_and_test(lv, s263c1f4, ABISELECT(348,260), 0, 1, 1, "S263C1");
    check_field_offset(lv, s263c1f5, ABISELECT(352,264), "S263C1.s263c1f5");
    test_class_info(&lv, &cd_S263C1);
    dp->~S263C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS263C1(Test_S263C1, "S263C1", ABISELECT(360,268));

#else // __cplusplus

extern void _ZN6S263C1C1Ev();
extern void _ZN6S263C1D1Ev();
Name_Map name_map_S263C1[] = {
  NSPAIR(_ZN6S263C1C1Ev),
  NSPAIR(_ZN6S263C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S263C6;
extern VTBL_ENTRY _ZTI6S263C6[];
extern  VTBL_ENTRY _ZTV6S263C6[];
extern Class_Descriptor cd_S263C5_nt;
extern VTBL_ENTRY _ZTI9S263C5_nt[];
extern  VTBL_ENTRY _ZTV9S263C5_nt[];
extern Class_Descriptor cd_S263C4_nt;
extern VTBL_ENTRY _ZTI9S263C4_nt[];
extern  VTBL_ENTRY _ZTV9S263C4_nt[];
extern Class_Descriptor cd_S263C3_nt;
extern VTBL_ENTRY _ZTI9S263C3_nt[];
extern  VTBL_ENTRY _ZTV9S263C3_nt[];
extern Class_Descriptor cd_S263C2_nt;
extern VTBL_ENTRY _ZTI9S263C2_nt[];
extern  VTBL_ENTRY _ZTV9S263C2_nt[];
static Base_Class bases_S263C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S263C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S263C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S263C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S263C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S263C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S263C1[];
extern void _ZN6S263C1D1Ev();
extern void _ZN6S263C1D0Ev();
extern void _ZN6S263C62v6Ev();
extern void _ZN6S263C62v7Ev();
extern void _ZN6S263C62v8Ev();
extern void _ZN6S263C62v9Ev();
extern void _ZN6S263C63v10Ev();
extern void _ZN6S263C63v11Ev();
extern void _ZN6S263C63v12Ev();
extern void _ZN6S263C63v13Ev();
extern void _ZN6S263C63v14Ev();
extern void _ZN6S263C63v15Ev();
extern void _ZN6S263C63v16Ev();
extern void _ZN6S263C63v17Ev();
extern void _ZN6S263C63v18Ev();
extern void _ZN6S263C63v19Ev();
extern void _ZN6S263C63v20Ev();
extern void _ZN6S263C63v21Ev();
extern void _ZN6S263C63v22Ev();
extern void _ZN6S263C63v23Ev();
extern void _ZN6S263C63v24Ev();
extern void _ZN6S263C63v25Ev();
extern void _ZN6S263C63v26Ev();
extern void _ZN6S263C63v27Ev();
extern void _ZN6S263C63v28Ev();
extern void _ZN6S263C63v29Ev();
extern void _ZN6S263C63v30Ev();
extern void _ZN6S263C63v31Ev();
extern void _ZN6S263C63v32Ev();
extern void _ZN6S263C63v33Ev();
extern void _ZN6S263C63v34Ev();
extern void _ZN6S263C63v35Ev();
extern void _ZN6S263C63v36Ev();
extern void _ZN6S263C63v37Ev();
extern void _ZN6S263C63v38Ev();
extern void _ZN6S263C63v39Ev();
extern void _ZN6S263C63v40Ev();
extern void _ZN6S263C63v41Ev();
extern void _ZN6S263C63v42Ev();
extern void _ZN6S263C63v43Ev();
extern void _ZN6S263C63v44Ev();
extern void _ZN6S263C63v45Ev();
extern void _ZN6S263C63v46Ev();
extern void _ZN6S263C63v47Ev();
extern void _ZN6S263C63v48Ev();
extern void _ZN6S263C63v49Ev();
extern void _ZN6S263C63v50Ev();
extern void _ZN6S263C63v51Ev();
extern void _ZN6S263C63v52Ev();
extern void _ZN6S263C63v53Ev();
extern void _ZN6S263C63v54Ev();
extern void _ZN6S263C63v55Ev();
extern void _ZN6S263C63v56Ev();
extern void _ZN6S263C63v57Ev();
extern void _ZN6S263C63v58Ev();
extern void _ZN6S263C63v59Ev();
extern void _ZN6S263C63v60Ev();
extern void _ZN6S263C63v61Ev();
extern void _ZN6S263C63v62Ev();
extern void _ZN6S263C63v63Ev();
extern void _ZN6S263C63v64Ev();
extern void _ZN6S263C63v65Ev();
extern void _ZN6S263C63v66Ev();
extern void _ZN6S263C63v67Ev();
extern void _ZN6S263C63v68Ev();
extern void _ZN6S263C63v69Ev();
extern void _ZN9S263C5_nt3v70Ev();
extern void _ZN9S263C5_nt3v71Ev();
extern void _ZN9S263C5_nt3v72Ev();
extern void _ZN9S263C5_nt3v73Ev();
extern void _ZN9S263C5_nt3v74Ev();
extern void _ZN9S263C5_nt3v75Ev();
extern void _ZN9S263C5_nt3v76Ev();
extern void _ZN9S263C5_nt3v77Ev();
extern void _ZN9S263C5_nt3v78Ev();
extern void _ZN9S263C5_nt3v79Ev();
extern void _ZN9S263C5_nt3v80Ev();
extern void _ZN9S263C5_nt3v81Ev();
extern void _ZN9S263C5_nt3v82Ev();
extern void _ZN9S263C5_nt3v83Ev();
extern void _ZN9S263C5_nt3v84Ev();
extern void _ZN9S263C5_nt3v85Ev();
extern void _ZN9S263C5_nt3v86Ev();
extern void _ZN9S263C5_nt3v87Ev();
extern void _ZN9S263C5_nt3v88Ev();
extern void _ZN9S263C5_nt3v89Ev();
extern void _ZN9S263C5_nt3v90Ev();
extern void _ZN9S263C5_nt3v91Ev();
extern void _ZN9S263C4_nt3v92Ev();
extern void _ZN9S263C4_nt3v93Ev();
extern void _ZN9S263C4_nt3v94Ev();
extern void _ZN9S263C4_nt3v95Ev();
extern void _ZN9S263C4_nt3v96Ev();
extern void _ZN9S263C4_nt3v97Ev();
extern void _ZN9S263C4_nt3v98Ev();
extern void _ZN9S263C4_nt3v99Ev();
extern void _ZN9S263C4_nt4v100Ev();
extern void _ZN9S263C4_nt4v101Ev();
extern void _ZN9S263C4_nt4v102Ev();
extern void _ZN9S263C4_nt4v103Ev();
extern void _ZN9S263C4_nt4v104Ev();
extern void _ZN9S263C4_nt4v105Ev();
extern void _ZN9S263C4_nt4v106Ev();
extern void _ZN9S263C4_nt4v107Ev();
extern void _ZN9S263C4_nt4v108Ev();
extern void _ZN9S263C4_nt4v109Ev();
extern void _ZN9S263C4_nt4v110Ev();
extern void _ZN9S263C4_nt4v111Ev();
extern void _ZN9S263C3_nt4v112Ev();
extern void _ZN9S263C3_nt4v113Ev();
extern void _ZN9S263C3_nt4v114Ev();
extern void _ZN9S263C3_nt4v115Ev();
extern void _ZN9S263C2_nt4v116Ev();
extern void _ZN9S263C2_nt4v117Ev();
extern void _ZN9S263C2_nt4v118Ev();
extern void _ZN9S263C2_nt4v119Ev();
extern void _ZN9S263C2_nt4v120Ev();
extern void _ZN9S263C2_nt4v121Ev();
extern void _ZN9S263C2_nt4v122Ev();
extern void _ZN6S263C12v1Ev();
extern void _ZN6S263C12v2Ev();
extern void _ZN6S263C12v3Ev();
extern void _ZN6S263C12v4Ev();
extern void _ZN6S263C12v5Ev();
static  VTBL_ENTRY vtc_S263C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S263C1[0]),
  (VTBL_ENTRY)&_ZN6S263C1D1Ev,
  (VTBL_ENTRY)&_ZN6S263C1D0Ev,
  (VTBL_ENTRY)&_ZN6S263C62v6Ev,
  (VTBL_ENTRY)&_ZN6S263C62v7Ev,
  (VTBL_ENTRY)&_ZN6S263C62v8Ev,
  (VTBL_ENTRY)&_ZN6S263C62v9Ev,
  (VTBL_ENTRY)&_ZN6S263C63v10Ev,
  (VTBL_ENTRY)&_ZN6S263C63v11Ev,
  (VTBL_ENTRY)&_ZN6S263C63v12Ev,
  (VTBL_ENTRY)&_ZN6S263C63v13Ev,
  (VTBL_ENTRY)&_ZN6S263C63v14Ev,
  (VTBL_ENTRY)&_ZN6S263C63v15Ev,
  (VTBL_ENTRY)&_ZN6S263C63v16Ev,
  (VTBL_ENTRY)&_ZN6S263C63v17Ev,
  (VTBL_ENTRY)&_ZN6S263C63v18Ev,
  (VTBL_ENTRY)&_ZN6S263C63v19Ev,
  (VTBL_ENTRY)&_ZN6S263C63v20Ev,
  (VTBL_ENTRY)&_ZN6S263C63v21Ev,
  (VTBL_ENTRY)&_ZN6S263C63v22Ev,
  (VTBL_ENTRY)&_ZN6S263C63v23Ev,
  (VTBL_ENTRY)&_ZN6S263C63v24Ev,
  (VTBL_ENTRY)&_ZN6S263C63v25Ev,
  (VTBL_ENTRY)&_ZN6S263C63v26Ev,
  (VTBL_ENTRY)&_ZN6S263C63v27Ev,
  (VTBL_ENTRY)&_ZN6S263C63v28Ev,
  (VTBL_ENTRY)&_ZN6S263C63v29Ev,
  (VTBL_ENTRY)&_ZN6S263C63v30Ev,
  (VTBL_ENTRY)&_ZN6S263C63v31Ev,
  (VTBL_ENTRY)&_ZN6S263C63v32Ev,
  (VTBL_ENTRY)&_ZN6S263C63v33Ev,
  (VTBL_ENTRY)&_ZN6S263C63v34Ev,
  (VTBL_ENTRY)&_ZN6S263C63v35Ev,
  (VTBL_ENTRY)&_ZN6S263C63v36Ev,
  (VTBL_ENTRY)&_ZN6S263C63v37Ev,
  (VTBL_ENTRY)&_ZN6S263C63v38Ev,
  (VTBL_ENTRY)&_ZN6S263C63v39Ev,
  (VTBL_ENTRY)&_ZN6S263C63v40Ev,
  (VTBL_ENTRY)&_ZN6S263C63v41Ev,
  (VTBL_ENTRY)&_ZN6S263C63v42Ev,
  (VTBL_ENTRY)&_ZN6S263C63v43Ev,
  (VTBL_ENTRY)&_ZN6S263C63v44Ev,
  (VTBL_ENTRY)&_ZN6S263C63v45Ev,
  (VTBL_ENTRY)&_ZN6S263C63v46Ev,
  (VTBL_ENTRY)&_ZN6S263C63v47Ev,
  (VTBL_ENTRY)&_ZN6S263C63v48Ev,
  (VTBL_ENTRY)&_ZN6S263C63v49Ev,
  (VTBL_ENTRY)&_ZN6S263C63v50Ev,
  (VTBL_ENTRY)&_ZN6S263C63v51Ev,
  (VTBL_ENTRY)&_ZN6S263C63v52Ev,
  (VTBL_ENTRY)&_ZN6S263C63v53Ev,
  (VTBL_ENTRY)&_ZN6S263C63v54Ev,
  (VTBL_ENTRY)&_ZN6S263C63v55Ev,
  (VTBL_ENTRY)&_ZN6S263C63v56Ev,
  (VTBL_ENTRY)&_ZN6S263C63v57Ev,
  (VTBL_ENTRY)&_ZN6S263C63v58Ev,
  (VTBL_ENTRY)&_ZN6S263C63v59Ev,
  (VTBL_ENTRY)&_ZN6S263C63v60Ev,
  (VTBL_ENTRY)&_ZN6S263C63v61Ev,
  (VTBL_ENTRY)&_ZN6S263C63v62Ev,
  (VTBL_ENTRY)&_ZN6S263C63v63Ev,
  (VTBL_ENTRY)&_ZN6S263C63v64Ev,
  (VTBL_ENTRY)&_ZN6S263C63v65Ev,
  (VTBL_ENTRY)&_ZN6S263C63v66Ev,
  (VTBL_ENTRY)&_ZN6S263C63v67Ev,
  (VTBL_ENTRY)&_ZN6S263C63v68Ev,
  (VTBL_ENTRY)&_ZN6S263C63v69Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S263C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S263C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S263C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S263C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN6S263C12v1Ev,
  (VTBL_ENTRY)&_ZN6S263C12v2Ev,
  (VTBL_ENTRY)&_ZN6S263C12v3Ev,
  (VTBL_ENTRY)&_ZN6S263C12v4Ev,
  (VTBL_ENTRY)&_ZN6S263C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S263C1[];
extern  VTBL_ENTRY _ZTV6S263C1[];
Class_Descriptor cd_S263C1 = {  "S263C1", // class name
  bases_S263C1, 5,
  &(vtc_S263C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,268), // object size
  NSPAIRA(_ZTI6S263C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S263C1),126, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C4  {
  void *s19045c4f0;
  short s19045c4f1:16;
  virtual void  v10(); // _ZN8S19045C43v10Ev
  virtual void  v11(); // _ZN8S19045C43v11Ev
  virtual void  v12(); // _ZN8S19045C43v12Ev
  virtual void  v13(); // _ZN8S19045C43v13Ev
  virtual void  v14(); // _ZN8S19045C43v14Ev
  virtual void  v15(); // _ZN8S19045C43v15Ev
  virtual void  v16(); // _ZN8S19045C43v16Ev
  ~S19045C4(); // tgen
  S19045C4(); // tgen
};
//SIG(-1 S19045C4) C1{ v1 v2 v3 v4 v5 v6 v7 Fp Fs:16}


void  S19045C4 ::v10(){vfunc_called(this, "_ZN8S19045C43v10Ev");}
void  S19045C4 ::v11(){vfunc_called(this, "_ZN8S19045C43v11Ev");}
void  S19045C4 ::v12(){vfunc_called(this, "_ZN8S19045C43v12Ev");}
void  S19045C4 ::v13(){vfunc_called(this, "_ZN8S19045C43v13Ev");}
void  S19045C4 ::v14(){vfunc_called(this, "_ZN8S19045C43v14Ev");}
void  S19045C4 ::v15(){vfunc_called(this, "_ZN8S19045C43v15Ev");}
void  S19045C4 ::v16(){vfunc_called(this, "_ZN8S19045C43v16Ev");}
S19045C4 ::~S19045C4(){ note_dtor("S19045C4", this);} // tgen
S19045C4 ::S19045C4(){ note_ctor("S19045C4", this);} // tgen

static void Test_S19045C4()
{
  extern Class_Descriptor cd_S19045C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S19045C4, buf);
    S19045C4 *dp, &lv = *(dp=new (buf) S19045C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S19045C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19045C4)");
    check_field_offset(lv, s19045c4f0, ABISELECT(8,4), "S19045C4.s19045c4f0");
    set_bf_and_test(lv, s19045c4f1, ABISELECT(16,8), 0, 16, 1, "S19045C4");
    set_bf_and_test(lv, s19045c4f1, ABISELECT(16,8), 0, 16, hide_sll(1LL<<15), "S19045C4");
    test_class_info(&lv, &cd_S19045C4);
    dp->~S19045C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C4(Test_S19045C4, "S19045C4", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S19045C4C1Ev();
extern void _ZN8S19045C4D1Ev();
Name_Map name_map_S19045C4[] = {
  NSPAIR(_ZN8S19045C4C1Ev),
  NSPAIR(_ZN8S19045C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S19045C4[];
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY vtc_S19045C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C4[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
Class_Descriptor cd_S19045C4 = {  "S19045C4", // class name
  0,0,//no base classes
  &(vtc_S19045C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S19045C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S19045C4),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C3  : S19045C4 {
  short s19045c3f0;
  virtual void  v17(); // _ZN8S19045C33v17Ev
  virtual void  v18(); // _ZN8S19045C33v18Ev
  virtual void  v19(); // _ZN8S19045C33v19Ev
  virtual void  v20(); // _ZN8S19045C33v20Ev
  virtual void  v21(); // _ZN8S19045C33v21Ev
  virtual void  v22(); // _ZN8S19045C33v22Ev
  virtual void  v23(); // _ZN8S19045C33v23Ev
  ~S19045C3(); // tgen
  S19045C3(); // tgen
};
//SIG(-1 S19045C3) C1{ BC2{ v8 v9 v10 v11 v12 v13 v14 Fp Fs:16} v1 v2 v3 v4 v5 v6 v7 Fs}


void  S19045C3 ::v17(){vfunc_called(this, "_ZN8S19045C33v17Ev");}
void  S19045C3 ::v18(){vfunc_called(this, "_ZN8S19045C33v18Ev");}
void  S19045C3 ::v19(){vfunc_called(this, "_ZN8S19045C33v19Ev");}
void  S19045C3 ::v20(){vfunc_called(this, "_ZN8S19045C33v20Ev");}
void  S19045C3 ::v21(){vfunc_called(this, "_ZN8S19045C33v21Ev");}
void  S19045C3 ::v22(){vfunc_called(this, "_ZN8S19045C33v22Ev");}
void  S19045C3 ::v23(){vfunc_called(this, "_ZN8S19045C33v23Ev");}
S19045C3 ::~S19045C3(){ note_dtor("S19045C3", this);} // tgen
S19045C3 ::S19045C3(){ note_ctor("S19045C3", this);} // tgen

static void Test_S19045C3()
{
  extern Class_Descriptor cd_S19045C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S19045C3, buf);
    S19045C3 *dp, &lv = *(dp=new (buf) S19045C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S19045C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19045C3)");
    check_base_class_offset(lv, (S19045C4*), 0, "S19045C3");
    check_field_offset(lv, s19045c3f0, ABISELECT(18,10), "S19045C3.s19045c3f0");
    test_class_info(&lv, &cd_S19045C3);
    dp->~S19045C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C3(Test_S19045C3, "S19045C3", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S19045C3C1Ev();
extern void _ZN8S19045C3D1Ev();
Name_Map name_map_S19045C3[] = {
  NSPAIR(_ZN8S19045C3C1Ev),
  NSPAIR(_ZN8S19045C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
static Base_Class bases_S19045C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19045C3[];
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C33v17Ev();
extern void _ZN8S19045C33v18Ev();
extern void _ZN8S19045C33v19Ev();
extern void _ZN8S19045C33v20Ev();
extern void _ZN8S19045C33v21Ev();
extern void _ZN8S19045C33v22Ev();
extern void _ZN8S19045C33v23Ev();
static  VTBL_ENTRY vtc_S19045C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C3[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v17Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v18Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v19Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v20Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v21Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v22Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v23Ev,
};
extern VTBL_ENTRY _ZTI8S19045C3[];
extern  VTBL_ENTRY _ZTV8S19045C3[];
Class_Descriptor cd_S19045C3 = {  "S19045C3", // class name
  bases_S19045C3, 1,
  &(vtc_S19045C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S19045C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S19045C3),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C8  {
  __tsi64 s19045c8f0;
  long double s19045c8f1;
  virtual void  v24(); // _ZN8S19045C83v24Ev
  virtual void  v25(); // _ZN8S19045C83v25Ev
  virtual void  v26(); // _ZN8S19045C83v26Ev
  virtual void  v27(); // _ZN8S19045C83v27Ev
  virtual void  v28(); // _ZN8S19045C83v28Ev
  virtual void  v29(); // _ZN8S19045C83v29Ev
  virtual void  v30(); // _ZN8S19045C83v30Ev
  ~S19045C8(); // tgen
  S19045C8(); // tgen
};
//SIG(-1 S19045C8) C1{ v1 v2 v3 v4 v5 v6 v7 FL FD}


void  S19045C8 ::v24(){vfunc_called(this, "_ZN8S19045C83v24Ev");}
void  S19045C8 ::v25(){vfunc_called(this, "_ZN8S19045C83v25Ev");}
void  S19045C8 ::v26(){vfunc_called(this, "_ZN8S19045C83v26Ev");}
void  S19045C8 ::v27(){vfunc_called(this, "_ZN8S19045C83v27Ev");}
void  S19045C8 ::v28(){vfunc_called(this, "_ZN8S19045C83v28Ev");}
void  S19045C8 ::v29(){vfunc_called(this, "_ZN8S19045C83v29Ev");}
void  S19045C8 ::v30(){vfunc_called(this, "_ZN8S19045C83v30Ev");}
S19045C8 ::~S19045C8(){ note_dtor("S19045C8", this);} // tgen
S19045C8 ::S19045C8(){ note_ctor("S19045C8", this);} // tgen

static void Test_S19045C8()
{
  extern Class_Descriptor cd_S19045C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(3,7)];
    init_test(&cd_S19045C8, buf);
    S19045C8 *dp, &lv = *(dp=new (buf) S19045C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S19045C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C8)");
    check_field_offset(lv, s19045c8f0, ABISELECT(8,4), "S19045C8.s19045c8f0");
    check_field_offset(lv, s19045c8f1, ABISELECT(16,12), "S19045C8.s19045c8f1");
    test_class_info(&lv, &cd_S19045C8);
    dp->~S19045C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C8(Test_S19045C8, "S19045C8", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN8S19045C8C1Ev();
extern void _ZN8S19045C8D1Ev();
Name_Map name_map_S19045C8[] = {
  NSPAIR(_ZN8S19045C8C1Ev),
  NSPAIR(_ZN8S19045C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S19045C8[];
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY vtc_S19045C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C8[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
Class_Descriptor cd_S19045C8 = {  "S19045C8", // class name
  0,0,//no base classes
  &(vtc_S19045C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI8S19045C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S19045C8),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C7  : virtual S19045C8 {
  void *s19045c7f0;
  int s19045c7f1;
  virtual void  v31(); // _ZN8S19045C73v31Ev
  virtual void  v32(); // _ZN8S19045C73v32Ev
  virtual void  v33(); // _ZN8S19045C73v33Ev
  virtual void  v34(); // _ZN8S19045C73v34Ev
  virtual void  v35(); // _ZN8S19045C73v35Ev
  virtual void  v36(); // _ZN8S19045C73v36Ev
  virtual void  v37(); // _ZN8S19045C73v37Ev
  ~S19045C7(); // tgen
  S19045C7(); // tgen
};
//SIG(-1 S19045C7) C1{ VBC2{ v8 v9 v10 v11 v12 v13 v14 FL FD} v1 v2 v3 v4 v5 v6 v7 Fp Fi}


void  S19045C7 ::v31(){vfunc_called(this, "_ZN8S19045C73v31Ev");}
void  S19045C7 ::v32(){vfunc_called(this, "_ZN8S19045C73v32Ev");}
void  S19045C7 ::v33(){vfunc_called(this, "_ZN8S19045C73v33Ev");}
void  S19045C7 ::v34(){vfunc_called(this, "_ZN8S19045C73v34Ev");}
void  S19045C7 ::v35(){vfunc_called(this, "_ZN8S19045C73v35Ev");}
void  S19045C7 ::v36(){vfunc_called(this, "_ZN8S19045C73v36Ev");}
void  S19045C7 ::v37(){vfunc_called(this, "_ZN8S19045C73v37Ev");}
S19045C7 ::~S19045C7(){ note_dtor("S19045C7", this);} // tgen
S19045C7 ::S19045C7(){ note_ctor("S19045C7", this);} // tgen

static void Test_S19045C7()
{
  extern Class_Descriptor cd_S19045C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(5,10)];
    init_test(&cd_S19045C7, buf);
    S19045C7 *dp, &lv = *(dp=new (buf) S19045C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S19045C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C7)");
    check_base_class_offset(lv, (S19045C8*), ABISELECT(32,12), "S19045C7");
    check_field_offset(lv, s19045c7f0, ABISELECT(8,4), "S19045C7.s19045c7f0");
    check_field_offset(lv, s19045c7f1, ABISELECT(16,8), "S19045C7.s19045c7f1");
    test_class_info(&lv, &cd_S19045C7);
    dp->~S19045C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C7(Test_S19045C7, "S19045C7", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN8S19045C7C1Ev();
extern void _ZN8S19045C7D1Ev();
Name_Map name_map_S19045C7[] = {
  NSPAIR(_ZN8S19045C7C1Ev),
  NSPAIR(_ZN8S19045C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
static Base_Class bases_S19045C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C8,    ABISELECT(32,12), //bcp->offset
    10, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S19045C7[];
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY vtc_S19045C7[] = {
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern VTBL_ENTRY _ZTV8S19045C7[];
static  VTT_ENTRY vtt_S19045C7[] = {
  {&(_ZTV8S19045C7[3]),  3,26},
  {&(_ZTV8S19045C7[19]),  19,26},
};
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
Class_Descriptor cd_S19045C7 = {  "S19045C7", // class name
  bases_S19045C7, 1,
  &(vtc_S19045C7[0]), // expected_vtbl_contents
  &(vtt_S19045C7[0]), // expected_vtt_contents
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI8S19045C7),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S19045C7),26, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19045C7),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C6  : virtual S19045C4 , S19045C7 {
  virtual  ~S19045C6(); // _ZN8S19045C6D2Ev
  virtual void  v38(); // _ZN8S19045C63v38Ev
  virtual void  v39(); // _ZN8S19045C63v39Ev
  virtual void  v40(); // _ZN8S19045C63v40Ev
  virtual void  v41(); // _ZN8S19045C63v41Ev
  virtual void  v42(); // _ZN8S19045C63v42Ev
  S19045C6(); // tgen
};
//SIG(-1 S19045C6) C1{ VBC2{ v6 v7 v8 v9 v10 v11 v12 Fp Fs:16} BC3{ VBC4{ v13 v14 v15 v16 v17 v18 v19 FL FD} v20 v21 v22 v23 v24 v25 v26 Fp Fi} vd v1 v2 v3 v4 v5}


 S19045C6 ::~S19045C6(){ note_dtor("S19045C6", this);}
void  S19045C6 ::v38(){vfunc_called(this, "_ZN8S19045C63v38Ev");}
void  S19045C6 ::v39(){vfunc_called(this, "_ZN8S19045C63v39Ev");}
void  S19045C6 ::v40(){vfunc_called(this, "_ZN8S19045C63v40Ev");}
void  S19045C6 ::v41(){vfunc_called(this, "_ZN8S19045C63v41Ev");}
void  S19045C6 ::v42(){vfunc_called(this, "_ZN8S19045C63v42Ev");}
S19045C6 ::S19045C6(){ note_ctor("S19045C6", this);} // tgen

static void Test_S19045C6()
{
  extern Class_Descriptor cd_S19045C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(6,13)];
    init_test(&cd_S19045C6, buf);
    S19045C6 *dp, &lv = *(dp=new (buf) S19045C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S19045C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C6)");
    check_base_class_offset(lv, (S19045C4*), ABISELECT(24,12), "S19045C6");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(48,24), "S19045C6");
    check_base_class_offset(lv, (S19045C7*), 0, "S19045C6");
    test_class_info(&lv, &cd_S19045C6);
    dp->~S19045C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C6(Test_S19045C6, "S19045C6", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN8S19045C6C1Ev();
extern void _ZN8S19045C6D2Ev();
Name_Map name_map_S19045C6[] = {
  NSPAIR(_ZN8S19045C6C1Ev),
  NSPAIR(_ZN8S19045C6D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
static Base_Class bases_S19045C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C4,    ABISELECT(24,12), //bcp->offset
    18, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C8,    ABISELECT(48,24), //bcp->offset
    34, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19045C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19045C6[];
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C6D1Ev();
extern void _ZN8S19045C6D0Ev();
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY vtc_S19045C6[] = {
  ABISELECT(24,12),
  ABISELECT(48,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&_ZN8S19045C6D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C6D0Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern VTBL_ENTRY _ZTV8S19045C6[];
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__8S19045C6[] = {
  ABISELECT(48,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__8S19045C6[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
static  VTT_ENTRY vtt_S19045C6[] = {
  {&(_ZTV8S19045C6[4]),  4,50},
  {&(_tg__ZTV8S19045C7__8S19045C6[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__8S19045C6[9]),  9,16},
  {&(_ZTV8S19045C6[27]),  27,50},
  {&(_ZTV8S19045C6[43]),  43,50},
};
extern VTBL_ENTRY _ZTI8S19045C6[];
extern  VTBL_ENTRY _ZTV8S19045C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C6[];
Class_Descriptor cd_S19045C6 = {  "S19045C6", // class name
  bases_S19045C6, 3,
  &(vtc_S19045C6[0]), // expected_vtbl_contents
  &(vtt_S19045C6[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI8S19045C6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19045C6),50, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19045C6),5, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C11  : virtual S19045C8 , virtual S19045C4 {
  int s19045c11f0[4];
  virtual  ~S19045C11(); // _ZN9S19045C11D2Ev
  virtual void  v43(); // _ZN9S19045C113v43Ev
  virtual void  v44(); // _ZN9S19045C113v44Ev
  S19045C11(); // tgen
};
//SIG(-1 S19045C11) C1{ VBC2{ v3 v4 v5 v6 v7 v8 v9 FL FD} VBC3{ v10 v11 v12 v13 v14 v15 v16 Fp Fs:16} vd v1 v2 Fi[4]}


 S19045C11 ::~S19045C11(){ note_dtor("S19045C11", this);}
void  S19045C11 ::v43(){vfunc_called(this, "_ZN9S19045C113v43Ev");}
void  S19045C11 ::v44(){vfunc_called(this, "_ZN9S19045C113v44Ev");}
S19045C11 ::S19045C11(){ note_ctor("S19045C11", this);} // tgen

static void Test_S19045C11()
{
  extern Class_Descriptor cd_S19045C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(7,15)];
    init_test(&cd_S19045C11, buf);
    S19045C11 *dp, &lv = *(dp=new (buf) S19045C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,56), "sizeof(S19045C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C11)");
    check_base_class_offset(lv, (S19045C8*), ABISELECT(32,20), "S19045C11");
    check_base_class_offset(lv, (S19045C4*), ABISELECT(64,44), "S19045C11");
    check_field_offset(lv, s19045c11f0, ABISELECT(8,4), "S19045C11.s19045c11f0");
    test_class_info(&lv, &cd_S19045C11);
    dp->~S19045C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C11(Test_S19045C11, "S19045C11", ABISELECT(96,56));

#else // __cplusplus

extern void _ZN9S19045C11C1Ev();
extern void _ZN9S19045C11D2Ev();
Name_Map name_map_S19045C11[] = {
  NSPAIR(_ZN9S19045C11C1Ev),
  NSPAIR(_ZN9S19045C11D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
static Base_Class bases_S19045C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C8,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C4,    ABISELECT(64,44), //bcp->offset
    24, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19045C11[];
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY vtc_S19045C11[] = {
  ABISELECT(64,44),
  ABISELECT(32,20),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern VTBL_ENTRY _ZTV9S19045C11[];
static  VTT_ENTRY vtt_S19045C11[] = {
  {&(_ZTV9S19045C11[4]),  4,40},
  {&(_ZTV9S19045C11[17]),  17,40},
  {&(_ZTV9S19045C11[33]),  33,40},
};
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
Class_Descriptor cd_S19045C11 = {  "S19045C11", // class name
  bases_S19045C11, 2,
  &(vtc_S19045C11[0]), // expected_vtbl_contents
  &(vtt_S19045C11[0]), // expected_vtt_contents
  ABISELECT(96,56), // object size
  NSPAIRA(_ZTI9S19045C11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19045C11),40, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19045C11),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C10  : S19045C11 , S19045C8 , S19045C4 , virtual S19045C7 {
  __tsi64 s19045c10f0;
  virtual  ~S19045C10(); // _ZN9S19045C10D2Ev
  virtual void  v45(); // _ZN9S19045C103v45Ev
  virtual void  v46(); // _ZN9S19045C103v46Ev
  virtual void  v47(); // _ZN9S19045C103v47Ev
  virtual void  v48(); // _ZN9S19045C103v48Ev
  virtual void  v49(); // _ZN9S19045C103v49Ev
  virtual void  v50(); // _ZN9S19045C103v50Ev
  virtual void  v51(); // _ZN9S19045C103v51Ev
  virtual void  v52(); // _ZN9S19045C103v52Ev
  S19045C10(); // tgen
};
//SIG(-1 S19045C10) C1{ BC2{ VBC3{ v9 v10 v11 v12 v13 v14 v15 FL FD} VBC4{ v16 v17 v18 v19 v20 v21 v22 Fp Fs:16} vd v23 v24 Fi[4]} BC3 BC4 VBC5{ VBC3 v25 v26 v27 v28 v29 v30 v31 Fp Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 FL}


 S19045C10 ::~S19045C10(){ note_dtor("S19045C10", this);}
void  S19045C10 ::v45(){vfunc_called(this, "_ZN9S19045C103v45Ev");}
void  S19045C10 ::v46(){vfunc_called(this, "_ZN9S19045C103v46Ev");}
void  S19045C10 ::v47(){vfunc_called(this, "_ZN9S19045C103v47Ev");}
void  S19045C10 ::v48(){vfunc_called(this, "_ZN9S19045C103v48Ev");}
void  S19045C10 ::v49(){vfunc_called(this, "_ZN9S19045C103v49Ev");}
void  S19045C10 ::v50(){vfunc_called(this, "_ZN9S19045C103v50Ev");}
void  S19045C10 ::v51(){vfunc_called(this, "_ZN9S19045C103v51Ev");}
void  S19045C10 ::v52(){vfunc_called(this, "_ZN9S19045C103v52Ev");}
S19045C10 ::S19045C10(){ note_ctor("S19045C10", this);} // tgen

static void Test_S19045C10()
{
  extern Class_Descriptor cd_S19045C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(12,29)];
    init_test(&cd_S19045C10, buf);
    S19045C10 *dp, &lv = *(dp=new (buf) S19045C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,112), "sizeof(S19045C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C10)");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(96,64), "S19045C10");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(96,64), "S19045C10");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(128,88), "S19045C10");
    check_base_class_offset(lv, (S19045C11*), 0, "S19045C10");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*), ABISELECT(32,20), "S19045C10");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*), ABISELECT(64,44), "S19045C10");
    check_base_class_offset(lv, (S19045C7*), ABISELECT(152,100), "S19045C10");
    check_field_offset(lv, s19045c10f0, ABISELECT(88,56), "S19045C10.s19045c10f0");
    test_class_info(&lv, &cd_S19045C10);
    dp->~S19045C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C10(Test_S19045C10, "S19045C10", ABISELECT(176,112));

#else // __cplusplus

extern void _ZN9S19045C10C1Ev();
extern void _ZN9S19045C10D2Ev();
Name_Map name_map_S19045C10[] = {
  NSPAIR(_ZN9S19045C10C1Ev),
  NSPAIR(_ZN9S19045C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
static Base_Class bases_S19045C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C8,    ABISELECT(96,64), //bcp->offset
    35, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19045C4,    ABISELECT(128,88), //bcp->offset
    51, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19045C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C8,    ABISELECT(32,20), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C4,    ABISELECT(64,44), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C7,    ABISELECT(152,100), //bcp->offset
    67, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19045C10[];
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY vtc_S19045C10[] = {
  ABISELECT(152,100),
  ABISELECT(128,88),
  ABISELECT(96,64),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-96,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-36),
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern VTBL_ENTRY _ZTV9S19045C10[];
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C10[] = {
  ABISELECT(128,88),
  ABISELECT(96,64),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__9S19045C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-96,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__9S19045C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C10[] = {
  ABISELECT(-56,-36),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__9S19045C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(56,36),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
static  VTT_ENTRY vtt_S19045C10[] = {
  {&(_ZTV9S19045C10[5]),  5,84},
  {&(_tg__ZTV9S19045C11__9S19045C10[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__9S19045C10[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__9S19045C10[9]),  9,16},
  {&(_ZTV9S19045C10[44]),  44,84},
  {&(_ZTV9S19045C10[60]),  60,84},
  {&(_ZTV9S19045C10[77]),  77,84},
  {&(_tg__ZTV8S19045C7__9S19045C10[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__9S19045C10[9]),  9,16},
};
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
Class_Descriptor cd_S19045C10 = {  "S19045C10", // class name
  bases_S19045C10, 6,
  &(vtc_S19045C10[0]), // expected_vtbl_contents
  &(vtt_S19045C10[0]), // expected_vtt_contents
  ABISELECT(176,112), // object size
  NSPAIRA(_ZTI9S19045C10),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19045C10),84, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19045C10),9, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C12  : virtual S19045C7 , virtual S19045C11 {
  int s19045c12f0;
  virtual  ~S19045C12(); // _ZN9S19045C12D2Ev
  virtual void  v53(); // _ZN9S19045C123v53Ev
  virtual void  v54(); // _ZN9S19045C123v54Ev
  virtual void  v55(); // _ZN9S19045C123v55Ev
  virtual void  v56(); // _ZN9S19045C123v56Ev
  virtual void  v57(); // _ZN9S19045C123v57Ev
  virtual void  v58(); // _ZN9S19045C123v58Ev
  S19045C12(); // tgen
};
//SIG(-1 S19045C12) C1{ VBC2{ VBC3{ v7 v8 v9 v10 v11 v12 v13 FL FD} v14 v15 v16 v17 v18 v19 v20 Fp Fi} VBC4{ VBC3 VBC5{ v21 v22 v23 v24 v25 v26 v27 Fp Fs:16} vd v28 v29 Fi[4]} vd v1 v2 v3 v4 v5 v6 Fi}


 S19045C12 ::~S19045C12(){ note_dtor("S19045C12", this);}
void  S19045C12 ::v53(){vfunc_called(this, "_ZN9S19045C123v53Ev");}
void  S19045C12 ::v54(){vfunc_called(this, "_ZN9S19045C123v54Ev");}
void  S19045C12 ::v55(){vfunc_called(this, "_ZN9S19045C123v55Ev");}
void  S19045C12 ::v56(){vfunc_called(this, "_ZN9S19045C123v56Ev");}
void  S19045C12 ::v57(){vfunc_called(this, "_ZN9S19045C123v57Ev");}
void  S19045C12 ::v58(){vfunc_called(this, "_ZN9S19045C123v58Ev");}
S19045C12 ::S19045C12(){ note_ctor("S19045C12", this);} // tgen

static void Test_S19045C12()
{
  extern Class_Descriptor cd_S19045C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,20)];
    init_test(&cd_S19045C12, buf);
    S19045C12 *dp, &lv = *(dp=new (buf) S19045C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,76), "sizeof(S19045C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C12)");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(48,20), "S19045C12");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(48,20), "S19045C12");
    check_base_class_offset(lv, (S19045C7*), ABISELECT(16,8), "S19045C12");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(104,64), "S19045C12");
    check_base_class_offset(lv, (S19045C11*), ABISELECT(80,44), "S19045C12");
    check_field_offset(lv, s19045c12f0, ABISELECT(8,4), "S19045C12.s19045c12f0");
    test_class_info(&lv, &cd_S19045C12);
    dp->~S19045C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C12(Test_S19045C12, "S19045C12", ABISELECT(128,76));

#else // __cplusplus

extern void _ZN9S19045C12C1Ev();
extern void _ZN9S19045C12D2Ev();
Name_Map name_map_S19045C12[] = {
  NSPAIR(_ZN9S19045C12C1Ev),
  NSPAIR(_ZN9S19045C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
static Base_Class bases_S19045C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C8,    ABISELECT(48,20), //bcp->offset
    31, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S19045C7,    ABISELECT(16,8), //bcp->offset
    14, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C4,    ABISELECT(104,64), //bcp->offset
    58, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19045C11,    ABISELECT(80,44), //bcp->offset
    47, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19045C12[];
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZThn80_N9S19045C12D1Ev,_ZThn44_N9S19045C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void ABISELECT(_ZThn80_N9S19045C12D0Ev,_ZThn44_N9S19045C12D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY vtc_S19045C12[] = {
  ABISELECT(104,64),
  ABISELECT(80,44),
  ABISELECT(48,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  ABISELECT(-80,-44),
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern VTBL_ENTRY _ZTV9S19045C12[];
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C12[] = {
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__9S19045C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C12[] = {
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__9S19045C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,24),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__9S19045C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
static  VTT_ENTRY vtt_S19045C12[] = {
  {&(_ZTV9S19045C12[6]),  6,74},
  {&(_ZTV9S19045C12[24]),  24,74},
  {&(_ZTV9S19045C12[40]),  40,74},
  {&(_ZTV9S19045C12[54]),  54,74},
  {&(_ZTV9S19045C12[67]),  67,74},
  {&(_tg__ZTV8S19045C7__9S19045C12[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__9S19045C12[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C12[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__9S19045C12[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__9S19045C12[9]),  9,16},
};
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19045C12D0Ev,_ZThn44_N9S19045C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19045C12D1Ev,_ZThn44_N9S19045C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19045C12 = {  "S19045C12", // class name
  bases_S19045C12, 4,
  &(vtc_S19045C12[0]), // expected_vtbl_contents
  &(vtt_S19045C12[0]), // expected_vtt_contents
  ABISELECT(128,76), // object size
  NSPAIRA(_ZTI9S19045C12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19045C12),74, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19045C12),10, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C9  : S19045C8 , virtual S19045C4 , S19045C10 , S19045C12 , S19045C7 {
  virtual void  v59(); // _ZN8S19045C93v59Ev
  virtual void  v60(); // _ZN8S19045C93v60Ev
  virtual void  v61(); // _ZN8S19045C93v61Ev
  virtual void  v62(); // _ZN8S19045C93v62Ev
  virtual void  v63(); // _ZN8S19045C93v63Ev
  virtual void  v64(); // _ZN8S19045C93v64Ev
  virtual void  v65(); // _ZN8S19045C93v65Ev
  virtual void  v66(); // _ZN8S19045C93v66Ev
  virtual void  v67(); // _ZN8S19045C93v67Ev
  ~S19045C9(); // tgen
  S19045C9(); // tgen
};
//SIG(-1 S19045C9) C1{ BC2{ v10 v11 v12 v13 v14 v15 v16 FL FD} VBC3{ v17 v18 v19 v20 v21 v22 v23 Fp Fs:16} BC4{ BC5{ VBC2 VBC3 vd v24 v25 Fi[4]} BC2 BC3 VBC6{ VBC2 v26 v27 v28 v29 v30 v31 v32 Fp Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 FL} BC7{ VBC6 VBC5 vd v41 v42 v43 v44 v45 v46 Fi} BC6 v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S19045C9 ::v59(){vfunc_called(this, "_ZN8S19045C93v59Ev");}
void  S19045C9 ::v60(){vfunc_called(this, "_ZN8S19045C93v60Ev");}
void  S19045C9 ::v61(){vfunc_called(this, "_ZN8S19045C93v61Ev");}
void  S19045C9 ::v62(){vfunc_called(this, "_ZN8S19045C93v62Ev");}
void  S19045C9 ::v63(){vfunc_called(this, "_ZN8S19045C93v63Ev");}
void  S19045C9 ::v64(){vfunc_called(this, "_ZN8S19045C93v64Ev");}
void  S19045C9 ::v65(){vfunc_called(this, "_ZN8S19045C93v65Ev");}
void  S19045C9 ::v66(){vfunc_called(this, "_ZN8S19045C93v66Ev");}
void  S19045C9 ::v67(){vfunc_called(this, "_ZN8S19045C93v67Ev");}
S19045C9 ::~S19045C9(){ note_dtor("S19045C9", this);} // tgen
S19045C9 ::S19045C9(){ note_ctor("S19045C9", this);} // tgen

static void Test_S19045C9()
{
  extern Class_Descriptor cd_S19045C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(18,45)];
    init_test(&cd_S19045C9, buf);
    S19045C9 *dp, &lv = *(dp=new (buf) S19045C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,176), "sizeof(S19045C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C9)");
    /*is_ambiguous_... S19045C9::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*), 0, "S19045C9");
    /*is_ambiguous_... S19045C9::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*), ABISELECT(168,108), "S19045C9");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*), ABISELECT(168,108), "S19045C9");
    /*is_ambiguous_... S19045C9::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(168,108), "S19045C9");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*), ABISELECT(192,120), "S19045C9");
    /*is_ambiguous_... S19045C9::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(192,120), "S19045C9");
    /*is_ambiguous_... S19045C9::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(192,120), "S19045C9");
    /*is_ambiguous_... S19045C9::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(192,120), "S19045C9");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*), ABISELECT(32,24), "S19045C9");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*), ABISELECT(64,44), "S19045C9");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*), ABISELECT(96,68), "S19045C9");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*), ABISELECT(224,144), "S19045C9");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*), ABISELECT(224,144), "S19045C9");
    check_base_class_offset(lv, (S19045C10*), ABISELECT(32,24), "S19045C9");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*), ABISELECT(248,156), "S19045C9");
    check_base_class_offset(lv, (S19045C12*), ABISELECT(128,88), "S19045C9");
    /*is_ambiguous_... S19045C9::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C7*), ABISELECT(144,96), "S19045C9");
    test_class_info(&lv, &cd_S19045C9);
    dp->~S19045C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C9(Test_S19045C9, "S19045C9", ABISELECT(272,176));

#else // __cplusplus

extern void _ZN8S19045C9C1Ev();
extern void _ZN8S19045C9D1Ev();
Name_Map name_map_S19045C9[] = {
  NSPAIR(_ZN8S19045C9C1Ev),
  NSPAIR(_ZN8S19045C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
static Base_Class bases_S19045C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C4,    ABISELECT(168,108), //bcp->offset
    83, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C8,    ABISELECT(192,120), //bcp->offset
    99, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19045C11,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(64,44), //bcp->offset
    41, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(96,68), //bcp->offset
    50, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19045C7,    ABISELECT(224,144), //bcp->offset
    115, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S19045C10,    ABISELECT(32,24), //bcp->offset
    24, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C11,    ABISELECT(248,156), //bcp->offset
    132, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S19045C12,    ABISELECT(128,88), //bcp->offset
    59, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C7,    ABISELECT(144,96), //bcp->offset
    73, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19045C9[];
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void _ZN8S19045C9D1Ev();
extern void _ZN8S19045C9D0Ev();
extern void ABISELECT(_ZThn32_N8S19045C9D1Ev,_ZThn24_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C9D0Ev,_ZThn24_N8S19045C9D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void ABISELECT(_ZThn128_N8S19045C9D1Ev,_ZThn88_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn128_N8S19045C9D0Ev,_ZThn88_N8S19045C9D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn248_N8S19045C9D1Ev,_ZThn156_N8S19045C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev)();
extern void ABISELECT(_ZThn248_N8S19045C9D0Ev,_ZThn156_N8S19045C9D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY vtc_S19045C9[] = {
  ABISELECT(248,156),
  ABISELECT(224,144),
  ABISELECT(192,120),
  ABISELECT(168,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&_ZN8S19045C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C9D0Ev,
  ABISELECT(192,120),
  ABISELECT(136,84),
  ABISELECT(160,96),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C9D1Ev,_ZThn24_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C9D0Ev,_ZThn24_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-96,-68),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(40,20),
  ABISELECT(120,68),
  ABISELECT(64,32),
  ABISELECT(96,56),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C9D1Ev,_ZThn88_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C9D0Ev,_ZThn88_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  ABISELECT(48,24),
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-168,-108),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  ABISELECT(-248,-156),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-248,-156),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern VTBL_ENTRY _ZTV8S19045C9[];
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C10__8S19045C9[] = {
  ABISELECT(192,120),
  ABISELECT(136,84),
  ABISELECT(160,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C10__8S19045C9[] = {
  ABISELECT(136,84),
  ABISELECT(160,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C10__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C10__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-136,-84),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C10__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C10__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-136,-84),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C10__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__8S19045C9[] = {
  ABISELECT(40,20),
  ABISELECT(120,68),
  ABISELECT(64,32),
  ABISELECT(96,56),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C12__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C12__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZThn120_N9S19045C12D1Ev,_ZThn68_N9S19045C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void ABISELECT(_ZThn120_N9S19045C12D0Ev,_ZThn68_N9S19045C12D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C12__8S19045C9[] = {
  0,
  0,
  ABISELECT(-120,-68),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-120,-68),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C12__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A__8S19045C9[] = {
  ABISELECT(48,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__A__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__8S19045C9[] = {
  ABISELECT(-32,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,24),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C9[] = {
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__A1__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(56,36),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__A1__8S19045C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,48),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
static  VTT_ENTRY vtt_S19045C9[] = {
  {&(_ZTV8S19045C9[6]),  6,143},
  {&(_tg__ZTV9S19045C10__8S19045C9[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C10__8S19045C9[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C10__8S19045C9[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C10__8S19045C9[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C10__8S19045C9[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C10__8S19045C9[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C10__8S19045C9[10]),  10,17},
  {&(_tg__ZTV9S19045C12__8S19045C9[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C12__8S19045C9[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C12__8S19045C9[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C12__8S19045C9[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C12__8S19045C9[9]),  9,16},
  {&(_tg__ZTV8S19045C7__A__8S19045C9[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__A__8S19045C9[9]),  9,16},
  {&(_ZTV8S19045C9[92]),  92,143},
  {&(_ZTV8S19045C9[29]),  29,143},
  {&(_ZTV8S19045C9[108]),  108,143},
  {&(_ZTV8S19045C9[125]),  125,143},
  {&(_ZTV8S19045C9[65]),  65,143},
  {&(_ZTV8S19045C9[139]),  139,143},
  {&(_ZTV8S19045C9[76]),  76,143},
  {&(_tg__ZTV8S19045C7__8S19045C9[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__8S19045C9[9]),  9,16},
  {&(_tg__ZTV9S19045C11__A1__8S19045C9[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__A1__8S19045C9[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__A1__8S19045C9[9]),  9,16},
};
extern VTBL_ENTRY _ZTI8S19045C9[];
extern  VTBL_ENTRY _ZTV8S19045C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C9[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S19045C12D0Ev,_ZThn68_N9S19045C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S19045C12D1Ev,_ZThn68_N9S19045C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn248_N8S19045C9D0Ev,_ZThn156_N8S19045C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn248_N8S19045C9D1Ev,_ZThn156_N8S19045C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19045C9 = {  "S19045C9", // class name
  bases_S19045C9, 11,
  &(vtc_S19045C9[0]), // expected_vtbl_contents
  &(vtt_S19045C9[0]), // expected_vtt_contents
  ABISELECT(272,176), // object size
  NSPAIRA(_ZTI8S19045C9),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19045C9),143, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19045C9),27, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C5  : virtual S19045C6 , S19045C9 {
  virtual  ~S19045C5(); // _ZN8S19045C5D2Ev
  virtual void  v68(); // _ZN8S19045C53v68Ev
  virtual void  v69(); // _ZN8S19045C53v69Ev
  virtual void  v70(); // _ZN8S19045C53v70Ev
  virtual void  v71(); // _ZN8S19045C53v71Ev
  virtual void  v72(); // _ZN8S19045C53v72Ev
  virtual void  v73(); // _ZN8S19045C53v73Ev
  virtual void  v74(); // _ZN8S19045C53v74Ev
  virtual void  v75(); // _ZN8S19045C53v75Ev
  S19045C5(); // tgen
};
//SIG(-1 S19045C5) C1{ VBC2{ VBC3{ v9 v10 v11 v12 v13 v14 v15 Fp Fs:16} BC4{ VBC5{ v16 v17 v18 v19 v20 v21 v22 FL FD} v23 v24 v25 v26 v27 v28 v29 Fp Fi} vd v30 v31 v32 v33 v34} BC6{ BC5 VBC3 BC7{ BC8{ VBC5 VBC3 vd v35 v36 Fi[4]} BC5 BC3 VBC4 vd v37 v38 v39 v40 v41 v42 v43 v44 FL} BC9{ VBC4 VBC8 vd v45 v46 v47 v48 v49 v50 Fi} BC4 v51 v52 v53 v54 v55 v56 v57 v58 v59} vd v1 v2 v3 v4 v5 v6 v7 v8}


 S19045C5 ::~S19045C5(){ note_dtor("S19045C5", this);}
void  S19045C5 ::v68(){vfunc_called(this, "_ZN8S19045C53v68Ev");}
void  S19045C5 ::v69(){vfunc_called(this, "_ZN8S19045C53v69Ev");}
void  S19045C5 ::v70(){vfunc_called(this, "_ZN8S19045C53v70Ev");}
void  S19045C5 ::v71(){vfunc_called(this, "_ZN8S19045C53v71Ev");}
void  S19045C5 ::v72(){vfunc_called(this, "_ZN8S19045C53v72Ev");}
void  S19045C5 ::v73(){vfunc_called(this, "_ZN8S19045C53v73Ev");}
void  S19045C5 ::v74(){vfunc_called(this, "_ZN8S19045C53v74Ev");}
void  S19045C5 ::v75(){vfunc_called(this, "_ZN8S19045C53v75Ev");}
S19045C5 ::S19045C5(){ note_ctor("S19045C5", this);} // tgen

static void Test_S19045C5()
{
  extern Class_Descriptor cd_S19045C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(20,48)];
    init_test(&cd_S19045C5, buf);
    S19045C5 *dp, &lv = *(dp=new (buf) S19045C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,188), "sizeof(S19045C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C5)");
    check_base_class_offset(lv, (S19045C4*)(S19045C6*), ABISELECT(192,120), "S19045C5");
    /*is_ambiguous_... S19045C9::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C9*), ABISELECT(192,120), "S19045C5");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*)(S19045C9*), ABISELECT(192,120), "S19045C5");
    /*is_ambiguous_... S19045C5::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(192,120), "S19045C5");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*)(S19045C6*), ABISELECT(224,132), "S19045C5");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*)(S19045C9*), ABISELECT(224,132), "S19045C5");
    /*is_ambiguous_... S19045C5::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(224,132), "S19045C5");
    /*is_ambiguous_... S19045C5::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(224,132), "S19045C5");
    /*is_ambiguous_... S19045C9::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C7*)(S19045C9*), ABISELECT(224,132), "S19045C5");
    check_base_class_offset(lv, (S19045C7*)(S19045C6*), ABISELECT(168,108), "S19045C5");
    check_base_class_offset(lv, (S19045C6*), ABISELECT(168,108), "S19045C5");
    /*is_ambiguous_... S19045C9::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C9*), 0, "S19045C5");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*)(S19045C9*), ABISELECT(32,24), "S19045C5");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*)(S19045C9*), ABISELECT(64,44), "S19045C5");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*)(S19045C9*), ABISELECT(96,68), "S19045C5");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*)(S19045C9*), ABISELECT(256,156), "S19045C5");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*)(S19045C9*), ABISELECT(256,156), "S19045C5");
    check_base_class_offset(lv, (S19045C10*)(S19045C9*), ABISELECT(32,24), "S19045C5");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*)(S19045C9*), ABISELECT(280,168), "S19045C5");
    check_base_class_offset(lv, (S19045C12*)(S19045C9*), ABISELECT(128,88), "S19045C5");
    /*is_ambiguous_... S19045C9::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C7*)(S19045C9*), ABISELECT(144,96), "S19045C5");
    check_base_class_offset(lv, (S19045C9*), 0, "S19045C5");
    test_class_info(&lv, &cd_S19045C5);
    dp->~S19045C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C5(Test_S19045C5, "S19045C5", ABISELECT(304,188));

#else // __cplusplus

extern void _ZN8S19045C5C1Ev();
extern void _ZN8S19045C5D2Ev();
Name_Map name_map_S19045C5[] = {
  NSPAIR(_ZN8S19045C5C1Ev),
  NSPAIR(_ZN8S19045C5D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C6;
extern VTBL_ENTRY _ZTI8S19045C6[];
extern  VTBL_ENTRY _ZTV8S19045C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C6[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C9;
extern VTBL_ENTRY _ZTI8S19045C9[];
extern  VTBL_ENTRY _ZTV8S19045C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C9[];
static Base_Class bases_S19045C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C4,    ABISELECT(192,120), //bcp->offset
    123, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19045C8,    ABISELECT(224,132), //bcp->offset
    139, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19045C7,    ABISELECT(168,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19045C6,    ABISELECT(168,108), //bcp->offset
    92, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19045C11,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(64,44), //bcp->offset
    50, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(96,68), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19045C7,    ABISELECT(256,156), //bcp->offset
    155, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S19045C10,    ABISELECT(32,24), //bcp->offset
    33, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19045C11,    ABISELECT(280,168), //bcp->offset
    172, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19045C12,    ABISELECT(128,88), //bcp->offset
    68, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19045C7,    ABISELECT(144,96), //bcp->offset
    82, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19045C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19045C5[];
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void _ZN8S19045C5D1Ev();
extern void _ZN8S19045C5D0Ev();
extern void _ZN8S19045C53v68Ev();
extern void _ZN8S19045C53v69Ev();
extern void _ZN8S19045C53v70Ev();
extern void _ZN8S19045C53v71Ev();
extern void _ZN8S19045C53v72Ev();
extern void _ZN8S19045C53v73Ev();
extern void _ZN8S19045C53v74Ev();
extern void _ZN8S19045C53v75Ev();
extern void ABISELECT(_ZThn32_N8S19045C5D1Ev,_ZThn24_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C5D0Ev,_ZThn24_N8S19045C5D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void ABISELECT(_ZThn128_N8S19045C5D1Ev,_ZThn88_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn128_N8S19045C5D0Ev,_ZThn88_N8S19045C5D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn168_N8S19045C5D1Ev,_ZThn108_N8S19045C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev)();
extern void ABISELECT(_ZThn168_N8S19045C5D0Ev,_ZThn108_N8S19045C5D0Ev)() __attribute__((weak));
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn280_N8S19045C5D1Ev,_ZThn168_N8S19045C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev)();
extern void ABISELECT(_ZThn280_N8S19045C5D0Ev,_ZThn168_N8S19045C5D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY vtc_S19045C5[] = {
  ABISELECT(168,108),
  ABISELECT(280,168),
  ABISELECT(256,156),
  ABISELECT(224,132),
  ABISELECT(192,120),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&_ZN8S19045C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C5D0Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v68Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v69Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v70Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v71Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v72Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v73Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v74Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v75Ev,
  ABISELECT(224,132),
  ABISELECT(160,96),
  ABISELECT(192,108),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C5D1Ev,_ZThn24_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C5D0Ev,_ZThn24_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-96,-68),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(64,32),
  ABISELECT(152,80),
  ABISELECT(96,44),
  ABISELECT(128,68),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C5D1Ev,_ZThn88_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C5D0Ev,_ZThn88_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  ABISELECT(80,36),
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-168,-108),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  ABISELECT(56,24),
  ABISELECT(-168,-108),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-224,-132),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  ABISELECT(-280,-168),
  ABISELECT(-88,-48),
  ABISELECT(-56,-36),
  ABISELECT(-280,-168),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern VTBL_ENTRY _ZTV8S19045C5[];
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void _ZN8S19045C9D1Ev();
extern void _ZN8S19045C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C9__8S19045C5[] = {
  ABISELECT(280,168),
  ABISELECT(256,156),
  ABISELECT(224,132),
  ABISELECT(192,120),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&_ZN8S19045C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C9D0Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C108S19045C9__8S19045C5[] = {
  ABISELECT(224,132),
  ABISELECT(160,96),
  ABISELECT(192,108),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C108S19045C9__8S19045C5[] = {
  ABISELECT(160,96),
  ABISELECT(192,108),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C108S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-192,-108),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C108S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C108S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-192,-108),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C108S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C108S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-224,-132),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C128S19045C9__8S19045C5[] = {
  ABISELECT(64,32),
  ABISELECT(152,80),
  ABISELECT(96,44),
  ABISELECT(128,68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C128S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-128,-68),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C128S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZThn152_N9S19045C12D1Ev,_ZThn80_N9S19045C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void ABISELECT(_ZThn152_N9S19045C12D0Ev,_ZThn80_N9S19045C12D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C128S19045C9__8S19045C5[] = {
  0,
  0,
  ABISELECT(-152,-80),
  ABISELECT(-88,-48),
  ABISELECT(-56,-36),
  ABISELECT(-152,-80),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C128S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C9__A2__8S19045C5[] = {
  ABISELECT(80,36),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C78S19045C9__A2__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-80,-36),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__8S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void ABISELECT(_ZThn32_N8S19045C9D1Ev,_ZThn24_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C9D0Ev,_ZThn24_N8S19045C9D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C10__8S19045C9__8S19045C5[] = {
  ABISELECT(224,132),
  ABISELECT(160,96),
  ABISELECT(192,108),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C9D1Ev,_ZThn24_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C9D0Ev,_ZThn24_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__A1__8S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-224,-132),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__8S19045C9__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void ABISELECT(_ZThn128_N8S19045C9D1Ev,_ZThn88_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn128_N8S19045C9D0Ev,_ZThn88_N8S19045C9D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__8S19045C9__8S19045C5[] = {
  ABISELECT(64,32),
  ABISELECT(152,80),
  ABISELECT(96,44),
  ABISELECT(128,68),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C9D1Ev,_ZThn88_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C9D0Ev,_ZThn88_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn280_N8S19045C9D1Ev,_ZThn168_N8S19045C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev)();
extern void ABISELECT(_ZThn280_N8S19045C9D0Ev,_ZThn168_N8S19045C9D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C9__8S19045C5[] = {
  0,
  0,
  ABISELECT(-280,-168),
  ABISELECT(-88,-48),
  ABISELECT(-56,-36),
  ABISELECT(-280,-168),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A__8S19045C9__8S19045C5[] = {
  ABISELECT(80,36),
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C6D1Ev();
extern void _ZN8S19045C6D0Ev();
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C6__8S19045C5[] = {
  ABISELECT(24,12),
  ABISELECT(56,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&_ZN8S19045C6D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C6D0Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C6__8S19045C5[] = {
  ABISELECT(56,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C78S19045C6__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__8S19045C6__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C6__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A1__8S19045C5[] = {
  ABISELECT(-32,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__A1__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,24),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C5[] = {
  ABISELECT(-88,-48),
  ABISELECT(-56,-36),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__A1__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(56,36),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__A1__8S19045C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(88,48),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
static  VTT_ENTRY vtt_S19045C5[] = {
  {&(_ZTV8S19045C5[7]),  7,183},
  {&(_tg__ZTV8S19045C9__8S19045C5[6]),  6,24},
  {&(_tg__ZTV9S19045C108S19045C9__8S19045C5[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C108S19045C9__8S19045C5[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C108S19045C9__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C108S19045C9__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C108S19045C9__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C108S19045C9__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C108S19045C9__8S19045C5[10]),  10,17},
  {&(_tg__ZTV9S19045C128S19045C9__8S19045C5[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C128S19045C9__8S19045C5[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C128S19045C9__8S19045C5[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C128S19045C9__8S19045C5[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C128S19045C9__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C78S19045C9__A2__8S19045C5[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C78S19045C9__A2__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C4__8S19045C9__8S19045C5[9]),  9,16},
  {&(_tg__ZTV9S19045C10__8S19045C9__8S19045C5[5]),  5,17},
  {&(_tg__ZTV8S19045C8__A1__8S19045C9__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C7__8S19045C9__8S19045C5[10]),  10,17},
  {&(_tg__ZTV9S19045C12__8S19045C9__8S19045C5[6]),  6,14},
  {&(_tg__ZTV9S19045C11__A1__8S19045C9__8S19045C5[7]),  7,11},
  {&(_tg__ZTV8S19045C7__A__8S19045C9__8S19045C5[3]),  3,10},
  {&(_ZTV8S19045C5[109]),  109,183},
  {&(_ZTV8S19045C5[132]),  132,183},
  {&(_ZTV8S19045C5[148]),  148,183},
  {&(_ZTV8S19045C5[38]),  38,183},
  {&(_ZTV8S19045C5[165]),  165,183},
  {&(_ZTV8S19045C5[74]),  74,183},
  {&(_ZTV8S19045C5[179]),  179,183},
  {&(_ZTV8S19045C5[85]),  85,183},
  {&(_tg__ZTV8S19045C6__8S19045C5[4]),  4,18},
  {&(_tg__ZTV8S19045C78S19045C6__8S19045C5[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C78S19045C6__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C4__8S19045C6__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C8__8S19045C6__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C7__A1__8S19045C5[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__A1__8S19045C5[9]),  9,16},
  {&(_tg__ZTV9S19045C11__A1__8S19045C5[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__A1__8S19045C5[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__A1__8S19045C5[9]),  9,16},
};
extern VTBL_ENTRY _ZTI8S19045C5[];
extern  VTBL_ENTRY _ZTV8S19045C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C5[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn280_N8S19045C9D0Ev,_ZThn168_N8S19045C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn280_N8S19045C9D1Ev,_ZThn168_N8S19045C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn152_N9S19045C12D0Ev,_ZThn80_N9S19045C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn152_N9S19045C12D1Ev,_ZThn80_N9S19045C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn280_N8S19045C5D0Ev,_ZThn168_N8S19045C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn280_N8S19045C5D1Ev,_ZThn168_N8S19045C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S19045C5D0Ev,_ZThn108_N8S19045C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N8S19045C5D1Ev,_ZThn108_N8S19045C5D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19045C5 = {  "S19045C5", // class name
  bases_S19045C5, 14,
  &(vtc_S19045C5[0]), // expected_vtbl_contents
  &(vtt_S19045C5[0]), // expected_vtt_contents
  ABISELECT(304,188), // object size
  NSPAIRA(_ZTI8S19045C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19045C5),183, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19045C5),41, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C13  : virtual S19045C4 , virtual S19045C7 , S19045C10 , S19045C8 {
  virtual void  v76(); // _ZN9S19045C133v76Ev
  virtual void  v77(); // _ZN9S19045C133v77Ev
  virtual void  v78(); // _ZN9S19045C133v78Ev
  virtual void  v79(); // _ZN9S19045C133v79Ev
  ~S19045C13(); // tgen
  S19045C13(); // tgen
};
//SIG(-1 S19045C13) C1{ VBC2{ v5 v6 v7 v8 v9 v10 v11 Fp Fs:16} VBC3{ VBC4{ v12 v13 v14 v15 v16 v17 v18 FL FD} v19 v20 v21 v22 v23 v24 v25 Fp Fi} BC5{ BC6{ VBC4 VBC2 vd v26 v27 Fi[4]} BC4 BC2 VBC3 vd v28 v29 v30 v31 v32 v33 v34 v35 FL} BC4 v1 v2 v3 v4}


void  S19045C13 ::v76(){vfunc_called(this, "_ZN9S19045C133v76Ev");}
void  S19045C13 ::v77(){vfunc_called(this, "_ZN9S19045C133v77Ev");}
void  S19045C13 ::v78(){vfunc_called(this, "_ZN9S19045C133v78Ev");}
void  S19045C13 ::v79(){vfunc_called(this, "_ZN9S19045C133v79Ev");}
S19045C13 ::~S19045C13(){ note_dtor("S19045C13", this);} // tgen
S19045C13 ::S19045C13(){ note_ctor("S19045C13", this);} // tgen

static void Test_S19045C13()
{
  extern Class_Descriptor cd_S19045C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(14,35)];
    init_test(&cd_S19045C13, buf);
    S19045C13 *dp, &lv = *(dp=new (buf) S19045C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,136), "sizeof(S19045C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C13)");
    /*is_ambiguous_... S19045C13::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*), ABISELECT(128,88), "S19045C13");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*), ABISELECT(128,88), "S19045C13");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(176,112), "S19045C13");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*), ABISELECT(176,112), "S19045C13");
    check_base_class_offset(lv, (S19045C7*), ABISELECT(152,100), "S19045C13");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*), ABISELECT(152,100), "S19045C13");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*), 0, "S19045C13");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*), ABISELECT(32,20), "S19045C13");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*), ABISELECT(64,44), "S19045C13");
    check_base_class_offset(lv, (S19045C10*), 0, "S19045C13");
    /*is_ambiguous_... S19045C13::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*), ABISELECT(96,64), "S19045C13");
    test_class_info(&lv, &cd_S19045C13);
    dp->~S19045C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C13(Test_S19045C13, "S19045C13", ABISELECT(208,136));

#else // __cplusplus

extern void _ZN9S19045C13C1Ev();
extern void _ZN9S19045C13D1Ev();
Name_Map name_map_S19045C13[] = {
  NSPAIR(_ZN9S19045C13C1Ev),
  NSPAIR(_ZN9S19045C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
static Base_Class bases_S19045C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C4,    ABISELECT(128,88), //bcp->offset
    48, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C8,    ABISELECT(176,112), //bcp->offset
    81, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19045C7,    ABISELECT(152,100), //bcp->offset
    64, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(32,20), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(64,44), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19045C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C8,    ABISELECT(96,64), //bcp->offset
    39, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19045C13[];
extern void _ZN9S19045C13D1Ev();
extern void _ZN9S19045C13D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C133v76Ev();
extern void _ZN9S19045C133v77Ev();
extern void _ZN9S19045C133v78Ev();
extern void _ZN9S19045C133v79Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY vtc_S19045C13[] = {
  ABISELECT(152,100),
  ABISELECT(128,88),
  ABISELECT(176,112),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN9S19045C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C13D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v76Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v77Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v78Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v79Ev,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(-96,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-112),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern VTBL_ENTRY _ZTV9S19045C13[];
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C10__9S19045C13[] = {
  ABISELECT(152,100),
  ABISELECT(128,88),
  ABISELECT(176,112),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C10__9S19045C13[] = {
  ABISELECT(128,88),
  ABISELECT(176,112),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C10__9S19045C13[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-112),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C10__9S19045C13[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C10__9S19045C13[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-112),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C10__9S19045C13[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C10__9S19045C13[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  ABISELECT(-152,-100),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C13[] = {
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__9S19045C13[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
static  VTT_ENTRY vtt_S19045C13[] = {
  {&(_ZTV9S19045C13[5]),  5,97},
  {&(_tg__ZTV9S19045C10__9S19045C13[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C10__9S19045C13[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C10__9S19045C13[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C10__9S19045C13[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C10__9S19045C13[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C10__9S19045C13[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C10__9S19045C13[10]),  10,17},
  {&(_ZTV9S19045C13[57]),  57,97},
  {&(_ZTV9S19045C13[74]),  74,97},
  {&(_ZTV9S19045C13[90]),  90,97},
  {&(_tg__ZTV8S19045C7__9S19045C13[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__9S19045C13[9]),  9,16},
};
extern VTBL_ENTRY _ZTI9S19045C13[];
extern  VTBL_ENTRY _ZTV9S19045C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C13[];
Class_Descriptor cd_S19045C13 = {  "S19045C13", // class name
  bases_S19045C13, 8,
  &(vtc_S19045C13[0]), // expected_vtbl_contents
  &(vtt_S19045C13[0]), // expected_vtt_contents
  ABISELECT(208,136), // object size
  NSPAIRA(_ZTI9S19045C13),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19045C13),97, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19045C13),13, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C14  {
  int s19045c14f0[2];
  virtual void  v80(); // _ZN9S19045C143v80Ev
  virtual void  v81(); // _ZN9S19045C143v81Ev
  virtual void  v82(); // _ZN9S19045C143v82Ev
  virtual void  v83(); // _ZN9S19045C143v83Ev
  virtual void  v84(); // _ZN9S19045C143v84Ev
  virtual void  v85(); // _ZN9S19045C143v85Ev
  virtual void  v86(); // _ZN9S19045C143v86Ev
  ~S19045C14(); // tgen
  S19045C14(); // tgen
};
//SIG(-1 S19045C14) C1{ v1 v2 v3 v4 v5 v6 v7 Fi[2]}


void  S19045C14 ::v80(){vfunc_called(this, "_ZN9S19045C143v80Ev");}
void  S19045C14 ::v81(){vfunc_called(this, "_ZN9S19045C143v81Ev");}
void  S19045C14 ::v82(){vfunc_called(this, "_ZN9S19045C143v82Ev");}
void  S19045C14 ::v83(){vfunc_called(this, "_ZN9S19045C143v83Ev");}
void  S19045C14 ::v84(){vfunc_called(this, "_ZN9S19045C143v84Ev");}
void  S19045C14 ::v85(){vfunc_called(this, "_ZN9S19045C143v85Ev");}
void  S19045C14 ::v86(){vfunc_called(this, "_ZN9S19045C143v86Ev");}
S19045C14 ::~S19045C14(){ note_dtor("S19045C14", this);} // tgen
S19045C14 ::S19045C14(){ note_ctor("S19045C14", this);} // tgen

static void Test_S19045C14()
{
  extern Class_Descriptor cd_S19045C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S19045C14, buf);
    S19045C14 *dp, &lv = *(dp=new (buf) S19045C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S19045C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19045C14)");
    check_field_offset(lv, s19045c14f0, ABISELECT(8,4), "S19045C14.s19045c14f0");
    test_class_info(&lv, &cd_S19045C14);
    dp->~S19045C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C14(Test_S19045C14, "S19045C14", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN9S19045C14C1Ev();
extern void _ZN9S19045C14D1Ev();
Name_Map name_map_S19045C14[] = {
  NSPAIR(_ZN9S19045C14C1Ev),
  NSPAIR(_ZN9S19045C14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S19045C14[];
extern void _ZN9S19045C143v80Ev();
extern void _ZN9S19045C143v81Ev();
extern void _ZN9S19045C143v82Ev();
extern void _ZN9S19045C143v83Ev();
extern void _ZN9S19045C143v84Ev();
extern void _ZN9S19045C143v85Ev();
extern void _ZN9S19045C143v86Ev();
static  VTBL_ENTRY vtc_S19045C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C14[0]),
  (VTBL_ENTRY)&_ZN9S19045C143v80Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v81Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v82Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v83Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v84Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v85Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v86Ev,
};
extern VTBL_ENTRY _ZTI9S19045C14[];
extern  VTBL_ENTRY _ZTV9S19045C14[];
Class_Descriptor cd_S19045C14 = {  "S19045C14", // class name
  0,0,//no base classes
  &(vtc_S19045C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI9S19045C14),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S19045C14),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C2  : S19045C3 , S19045C5 , virtual S19045C13 , S19045C14 {
  ::S19045C3 s19045c2f0;
  long double s19045c2f1;
  virtual  ~S19045C2(); // _ZN8S19045C2D2Ev
  virtual void  v87(); // _ZN8S19045C23v87Ev
  virtual void  v88(); // _ZN8S19045C23v88Ev
  virtual void  v89(); // _ZN8S19045C23v89Ev
  virtual void  v90(); // _ZN8S19045C23v90Ev
  virtual void  v91(); // _ZN8S19045C23v91Ev
  virtual void  v92(); // _ZN8S19045C23v92Ev
  virtual void  v93(); // _ZN8S19045C23v93Ev
  virtual void  v94(); // _ZN8S19045C23v94Ev
  S19045C2(); // tgen
};
//SIG(-1 S19045C2) C1{ BC2{ BC3{ v9 v10 v11 v12 v13 v14 v15 Fp Fs:16} v16 v17 v18 v19 v20 v21 v22 Fs} BC4{ VBC5{ VBC3 BC6{ VBC7{ v23 v24 v25 v26 v27 v28 v29 FL FD} v30 v31 v32 v33 v34 v35 v36 Fp Fi} vd v37 v38 v39 v40 v41} BC8{ BC7 VBC3 BC9{ BC10{ VBC7 VBC3 vd v42 v43 Fi[4]} BC7 BC3 VBC6 vd v44 v45 v46 v47 v48 v49 v50 v51 FL} BC11{ VBC6 VBC10 vd v52 v53 v54 v55 v56 v57 Fi} BC6 v58 v59 v60 v61 v62 v63 v64 v65 v66} vd v67 v68 v69 v70 v71 v72 v73 v74} VBC12{ VBC3 VBC6 BC9 BC7 v75 v76 v77 v78} BC13{ v79 v80 v81 v82 v83 v84 v85 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 FC2 FD}


 S19045C2 ::~S19045C2(){ note_dtor("S19045C2", this);}
void  S19045C2 ::v87(){vfunc_called(this, "_ZN8S19045C23v87Ev");}
void  S19045C2 ::v88(){vfunc_called(this, "_ZN8S19045C23v88Ev");}
void  S19045C2 ::v89(){vfunc_called(this, "_ZN8S19045C23v89Ev");}
void  S19045C2 ::v90(){vfunc_called(this, "_ZN8S19045C23v90Ev");}
void  S19045C2 ::v91(){vfunc_called(this, "_ZN8S19045C23v91Ev");}
void  S19045C2 ::v92(){vfunc_called(this, "_ZN8S19045C23v92Ev");}
void  S19045C2 ::v93(){vfunc_called(this, "_ZN8S19045C23v93Ev");}
void  S19045C2 ::v94(){vfunc_called(this, "_ZN8S19045C23v94Ev");}
S19045C2 ::S19045C2(){ note_ctor("S19045C2", this);} // tgen

static void Test_S19045C2()
{
  extern Class_Descriptor cd_S19045C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(33,82)];
    init_test(&cd_S19045C2, buf);
    S19045C2 *dp, &lv = *(dp=new (buf) S19045C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(512,324), "sizeof(S19045C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C2)");
    check_base_class_offset(lv, (S19045C4*)(S19045C3*), 0, "S19045C2");
    check_base_class_offset(lv, (S19045C3*), 0, "S19045C2");
    check_base_class_offset(lv, (S19045C4*)(S19045C6*), ABISELECT(280,168), "S19045C2");
    /*is_ambiguous_... S19045C9::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C9*)(S19045C5*), ABISELECT(280,168), "S19045C2");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(280,168), "S19045C2");
    /*is_ambiguous_... S19045C2::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(280,168), "S19045C2");
    /*is_ambiguous_... S19045C13::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C13*), ABISELECT(280,168), "S19045C2");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*)(S19045C13*), ABISELECT(280,168), "S19045C2");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*)(S19045C6*), ABISELECT(304,180), "S19045C2");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(304,180), "S19045C2");
    /*is_ambiguous_... S19045C2::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(304,180), "S19045C2");
    /*is_ambiguous_... S19045C2::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(304,180), "S19045C2");
    /*is_ambiguous_... S19045C9::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C7*)(S19045C9*)(S19045C5*), ABISELECT(304,180), "S19045C2");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*)(S19045C13*), ABISELECT(304,180), "S19045C2");
    check_base_class_offset(lv, (S19045C7*)(S19045C6*), ABISELECT(256,156), "S19045C2");
    check_base_class_offset(lv, (S19045C6*)(S19045C5*), ABISELECT(256,156), "S19045C2");
    /*is_ambiguous_... S19045C9::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C9*)(S19045C5*), ABISELECT(32,12), "S19045C2");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(64,36), "S19045C2");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(96,56), "S19045C2");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(128,80), "S19045C2");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(336,204), "S19045C2");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*)(S19045C9*)(S19045C5*), ABISELECT(336,204), "S19045C2");
    check_base_class_offset(lv, (S19045C7*)(S19045C13*), ABISELECT(336,204), "S19045C2");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*)(S19045C13*), ABISELECT(336,204), "S19045C2");
    check_base_class_offset(lv, (S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(64,36), "S19045C2");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*)(S19045C9*)(S19045C5*), ABISELECT(360,216), "S19045C2");
    check_base_class_offset(lv, (S19045C12*)(S19045C9*)(S19045C5*), ABISELECT(160,100), "S19045C2");
    /*is_ambiguous_... S19045C9::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C7*)(S19045C9*)(S19045C5*), ABISELECT(176,108), "S19045C2");
    check_base_class_offset(lv, (S19045C9*)(S19045C5*), ABISELECT(32,12), "S19045C2");
    check_base_class_offset(lv, (S19045C5*), ABISELECT(32,12), "S19045C2");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*)(S19045C13*), ABISELECT(384,236), "S19045C2");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*)(S19045C13*), ABISELECT(416,256), "S19045C2");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*)(S19045C13*), ABISELECT(448,280), "S19045C2");
    check_base_class_offset(lv, (S19045C10*)(S19045C13*), ABISELECT(384,236), "S19045C2");
    /*is_ambiguous_... S19045C13::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C13*), ABISELECT(480,300), "S19045C2");
    check_base_class_offset(lv, (S19045C13*), ABISELECT(384,236), "S19045C2");
    check_base_class_offset(lv, (S19045C14*), ABISELECT(200,120), "S19045C2");
    check_field_offset(lv, s19045c2f0, ABISELECT(216,132), "S19045C2.s19045c2f0");
    check_field_offset(lv, s19045c2f1, ABISELECT(240,144), "S19045C2.s19045c2f1");
    test_class_info(&lv, &cd_S19045C2);
    dp->~S19045C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C2(Test_S19045C2, "S19045C2", ABISELECT(512,324));

#else // __cplusplus

extern void _ZN8S19045C2C1Ev();
extern void _ZN8S19045C2D2Ev();
Name_Map name_map_S19045C2[] = {
  NSPAIR(_ZN8S19045C2C1Ev),
  NSPAIR(_ZN8S19045C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C3;
extern VTBL_ENTRY _ZTI8S19045C3[];
extern  VTBL_ENTRY _ZTV8S19045C3[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C6;
extern VTBL_ENTRY _ZTI8S19045C6[];
extern  VTBL_ENTRY _ZTV8S19045C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C6[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C9;
extern VTBL_ENTRY _ZTI8S19045C9[];
extern  VTBL_ENTRY _ZTV8S19045C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C9[];
extern Class_Descriptor cd_S19045C5;
extern VTBL_ENTRY _ZTI8S19045C5[];
extern  VTBL_ENTRY _ZTV8S19045C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C5[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C13;
extern VTBL_ENTRY _ZTI9S19045C13[];
extern  VTBL_ENTRY _ZTV9S19045C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C13[];
extern Class_Descriptor cd_S19045C14;
extern VTBL_ENTRY _ZTI9S19045C14[];
extern  VTBL_ENTRY _ZTV9S19045C14[];
static Base_Class bases_S19045C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19045C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C4,    ABISELECT(280,168), //bcp->offset
    164, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S19045C8,    ABISELECT(304,180), //bcp->offset
    180, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C7,    ABISELECT(256,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19045C6,    ABISELECT(256,156), //bcp->offset
    133, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S19045C8,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19045C11,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(96,56), //bcp->offset
    82, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(128,80), //bcp->offset
    91, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19045C7,    ABISELECT(336,204), //bcp->offset
    196, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19045C10,    ABISELECT(64,36), //bcp->offset
    65, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19045C11,    ABISELECT(360,216), //bcp->offset
    213, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    53, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19045C12,    ABISELECT(160,100), //bcp->offset
    100, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19045C7,    ABISELECT(176,108), //bcp->offset
    114, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19045C9,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19045C5,    ABISELECT(32,12), //bcp->offset
    32, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C11,    ABISELECT(384,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(416,256), //bcp->offset
    274, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(448,280), //bcp->offset
    283, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19045C10,    ABISELECT(384,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(480,300), //bcp->offset
    292, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19045C13,    ABISELECT(384,236), //bcp->offset
    224, //bcp->virtual_function_table_offset
    34, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C14,    ABISELECT(200,120), //bcp->offset
    124, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19045C2[];
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C33v17Ev();
extern void _ZN8S19045C33v18Ev();
extern void _ZN8S19045C33v19Ev();
extern void _ZN8S19045C33v20Ev();
extern void _ZN8S19045C33v21Ev();
extern void _ZN8S19045C33v22Ev();
extern void _ZN8S19045C33v23Ev();
extern void _ZN8S19045C2D1Ev();
extern void _ZN8S19045C2D0Ev();
extern void _ZN8S19045C23v87Ev();
extern void _ZN8S19045C23v88Ev();
extern void _ZN8S19045C23v89Ev();
extern void _ZN8S19045C23v90Ev();
extern void _ZN8S19045C23v91Ev();
extern void _ZN8S19045C23v92Ev();
extern void _ZN8S19045C23v93Ev();
extern void _ZN8S19045C23v94Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void ABISELECT(_ZThn32_N8S19045C2D1Ev,_ZThn12_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C2D0Ev,_ZThn12_N8S19045C2D0Ev)();
extern void _ZN8S19045C53v68Ev();
extern void _ZN8S19045C53v69Ev();
extern void _ZN8S19045C53v70Ev();
extern void _ZN8S19045C53v71Ev();
extern void _ZN8S19045C53v72Ev();
extern void _ZN8S19045C53v73Ev();
extern void _ZN8S19045C53v74Ev();
extern void _ZN8S19045C53v75Ev();
extern void ABISELECT(_ZThn64_N8S19045C2D1Ev,_ZThn36_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn64_N8S19045C2D0Ev,_ZThn36_N8S19045C2D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void ABISELECT(_ZThn160_N8S19045C2D1Ev,_ZThn100_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn160_N8S19045C2D0Ev,_ZThn100_N8S19045C2D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN9S19045C143v80Ev();
extern void _ZN9S19045C143v81Ev();
extern void _ZN9S19045C143v82Ev();
extern void _ZN9S19045C143v83Ev();
extern void _ZN9S19045C143v84Ev();
extern void _ZN9S19045C143v85Ev();
extern void _ZN9S19045C143v86Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n96_N8S19045C2D1Ev,_ZTv0_n48_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn256_N8S19045C2D1Ev,_ZThn156_N8S19045C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S19045C2D0Ev,_ZTv0_n48_N8S19045C2D0Ev)();
extern void ABISELECT(_ZThn256_N8S19045C2D0Ev,_ZThn156_N8S19045C2D0Ev)() __attribute__((weak));
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n40_N8S19045C2D1Ev,_ZTv0_n20_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn360_N8S19045C2D1Ev,_ZThn216_N8S19045C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C2D0Ev,_ZTv0_n20_N8S19045C2D0Ev)();
extern void ABISELECT(_ZThn360_N8S19045C2D0Ev,_ZThn216_N8S19045C2D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void ABISELECT(_ZTv0_n48_N8S19045C2D1Ev,_ZTv0_n24_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn384_N8S19045C2D1Ev,_ZThn236_N8S19045C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19045C2D0Ev,_ZTv0_n24_N8S19045C2D0Ev)();
extern void ABISELECT(_ZThn384_N8S19045C2D0Ev,_ZThn236_N8S19045C2D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C133v76Ev();
extern void _ZN9S19045C133v77Ev();
extern void _ZN9S19045C133v78Ev();
extern void _ZN9S19045C133v79Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY vtc_S19045C2[] = {
  ABISELECT(384,236),
  ABISELECT(360,216),
  ABISELECT(336,204),
  ABISELECT(304,180),
  ABISELECT(280,168),
  ABISELECT(256,156),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v17Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v18Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v19Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v20Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v21Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v22Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v23Ev,
  (VTBL_ENTRY)&_ZN8S19045C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v87Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v88Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v89Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v90Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v91Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v92Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v93Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v94Ev,
  ABISELECT(224,144),
  ABISELECT(328,204),
  ABISELECT(304,192),
  ABISELECT(272,168),
  ABISELECT(248,156),
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C2D1Ev,_ZThn12_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C2D0Ev,_ZThn12_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C53v68Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v69Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v70Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v71Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v72Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v73Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v74Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v75Ev,
  ABISELECT(272,168),
  ABISELECT(216,132),
  ABISELECT(240,144),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S19045C2D1Ev,_ZThn36_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S19045C2D0Ev,_ZThn36_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-128,-80),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(120,68),
  ABISELECT(200,116),
  ABISELECT(144,80),
  ABISELECT(176,104),
  ABISELECT(-160,-100),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S19045C2D1Ev,_ZThn100_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S19045C2D0Ev,_ZThn100_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  ABISELECT(128,72),
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  ABISELECT(-200,-120),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN9S19045C143v80Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v81Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v82Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v83Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v84Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v85Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v86Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-256,-156),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  ABISELECT(48,24),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C2D1Ev,_ZTv0_n48_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C2D0Ev,_ZTv0_n48_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-280,-168),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-304,-180),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-336,-204),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  ABISELECT(-360,-216),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-360,-216),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C2D1Ev,_ZTv0_n20_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C2D0Ev,_ZTv0_n20_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  0,
  0,
  0,
  0,
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-384,-236),
  ABISELECT(-48,-32),
  ABISELECT(-104,-68),
  ABISELECT(-80,-56),
  ABISELECT(-384,-236),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19045C2D1Ev,_ZTv0_n24_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19045C2D0Ev,_ZTv0_n24_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v76Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v77Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v78Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v79Ev,
  ABISELECT(-416,-256),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-448,-280),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(-480,-300),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern VTBL_ENTRY _ZTV8S19045C2[];
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void _ZN8S19045C5D1Ev();
extern void _ZN8S19045C5D0Ev();
extern void _ZN8S19045C53v68Ev();
extern void _ZN8S19045C53v69Ev();
extern void _ZN8S19045C53v70Ev();
extern void _ZN8S19045C53v71Ev();
extern void _ZN8S19045C53v72Ev();
extern void _ZN8S19045C53v73Ev();
extern void _ZN8S19045C53v74Ev();
extern void _ZN8S19045C53v75Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C5__8S19045C2[] = {
  ABISELECT(224,144),
  ABISELECT(328,204),
  ABISELECT(304,192),
  ABISELECT(272,168),
  ABISELECT(248,156),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&_ZN8S19045C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C5D0Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v68Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v69Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v70Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v71Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v72Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v73Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v74Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v75Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void _ZN8S19045C9D1Ev();
extern void _ZN8S19045C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C98S19045C5__8S19045C2[] = {
  ABISELECT(328,204),
  ABISELECT(304,192),
  ABISELECT(272,168),
  ABISELECT(248,156),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&_ZN8S19045C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C9D0Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C108S19045C98S19045C5__8S19045C2[] = {
  ABISELECT(272,168),
  ABISELECT(216,132),
  ABISELECT(240,144),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C108S19045C98S19045C5__8S19045C2[] = {
  ABISELECT(216,132),
  ABISELECT(240,144),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C108S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-240,-144),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C108S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-216,-132),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C108S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-240,-144),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C108S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-216,-132),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C108S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-272,-168),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C128S19045C98S19045C5__8S19045C2[] = {
  ABISELECT(120,68),
  ABISELECT(200,116),
  ABISELECT(144,80),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C128S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C128S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZThn200_N9S19045C12D1Ev,_ZThn116_N9S19045C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void ABISELECT(_ZThn200_N9S19045C12D0Ev,_ZThn116_N9S19045C12D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C128S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  ABISELECT(-200,-116),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-200,-116),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C128S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-120,-68),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C98S19045C5__A2__8S19045C2[] = {
  ABISELECT(128,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C78S19045C98S19045C5__A2__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-128,-72),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__8S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-248,-156),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void ABISELECT(_ZThn32_N8S19045C9D1Ev,_ZThn24_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C9D0Ev,_ZThn24_N8S19045C9D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C10__8S19045C98S19045C5__8S19045C2[] = {
  ABISELECT(272,168),
  ABISELECT(216,132),
  ABISELECT(240,144),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C9D1Ev,_ZThn24_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C9D0Ev,_ZThn24_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__A1__8S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-272,-168),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__8S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-304,-192),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void ABISELECT(_ZThn128_N8S19045C9D1Ev,_ZThn88_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn128_N8S19045C9D0Ev,_ZThn88_N8S19045C9D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__8S19045C98S19045C5__8S19045C2[] = {
  ABISELECT(120,68),
  ABISELECT(200,116),
  ABISELECT(144,80),
  ABISELECT(176,104),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C9D1Ev,_ZThn88_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C9D0Ev,_ZThn88_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn328_N8S19045C9D1Ev,_ZThn204_N8S19045C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev)();
extern void ABISELECT(_ZThn328_N8S19045C9D0Ev,_ZThn204_N8S19045C9D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C98S19045C5__8S19045C2[] = {
  0,
  0,
  ABISELECT(-328,-204),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-328,-204),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A__8S19045C98S19045C5__8S19045C2[] = {
  ABISELECT(128,72),
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn224_N8S19045C5D1Ev,_ZThn144_N8S19045C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev)();
extern void ABISELECT(_ZThn224_N8S19045C5D0Ev,_ZThn144_N8S19045C5D0Ev)() __attribute__((weak));
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C6__8S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-224,-144),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  ABISELECT(48,24),
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__8S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-248,-156),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-272,-168),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZThn32_N8S19045C5D1Ev,_ZThn24_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C5D0Ev,_ZThn24_N8S19045C5D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C108S19045C9__8S19045C5__8S19045C2[] = {
  ABISELECT(272,168),
  ABISELECT(216,132),
  ABISELECT(240,144),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C5D1Ev,_ZThn24_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C5D0Ev,_ZThn24_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A1__8S19045C5__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-304,-192),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void ABISELECT(_ZThn128_N8S19045C5D1Ev,_ZThn88_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn128_N8S19045C5D0Ev,_ZThn88_N8S19045C5D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C128S19045C9__8S19045C5__8S19045C2[] = {
  ABISELECT(120,68),
  ABISELECT(200,116),
  ABISELECT(144,80),
  ABISELECT(176,104),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C5D1Ev,_ZThn88_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C5D0Ev,_ZThn88_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn328_N8S19045C5D1Ev,_ZThn204_N8S19045C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev)();
extern void ABISELECT(_ZThn328_N8S19045C5D0Ev,_ZThn204_N8S19045C5D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C5__8S19045C2[] = {
  0,
  0,
  ABISELECT(-328,-204),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-328,-204),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C9__A2__8S19045C5__8S19045C2[] = {
  ABISELECT(128,72),
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C6D1Ev();
extern void _ZN8S19045C6D0Ev();
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C6__8S19045C2[] = {
  ABISELECT(24,12),
  ABISELECT(48,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&_ZN8S19045C6D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C6D0Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C6__8S19045C2[] = {
  ABISELECT(48,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C78S19045C6__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__8S19045C6__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C6__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A1__8S19045C2[] = {
  ABISELECT(-32,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__A1__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,24),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C2[] = {
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__A1__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(56,36),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__A1__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,48),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN9S19045C13D1Ev();
extern void _ZN9S19045C13D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C133v76Ev();
extern void _ZN9S19045C133v77Ev();
extern void _ZN9S19045C133v78Ev();
extern void _ZN9S19045C133v79Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C13__8S19045C2[] = {
  ABISELECT(-48,-32),
  ABISELECT(-104,-68),
  ABISELECT(-80,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN9S19045C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C13D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v76Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v77Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v78Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v79Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C109S19045C13__A1__8S19045C2[] = {
  ABISELECT(-48,-32),
  ABISELECT(-104,-68),
  ABISELECT(-80,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C109S19045C13__A2__8S19045C2[] = {
  ABISELECT(-104,-68),
  ABISELECT(-80,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C109S19045C13__A2__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,56),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C109S19045C13__A2__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,68),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C109S19045C13__A1__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,56),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C109S19045C13__A1__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,68),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C109S19045C13__A1__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(48,32),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C13__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,68),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C13__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(48,32),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C13__8S19045C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,56),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
static  VTT_ENTRY vtt_S19045C2[] = {
  {&(_ZTV8S19045C2[8]),  8,301},
  {&(_tg__ZTV8S19045C5__8S19045C2[7]),  7,33},
  {&(_tg__ZTV8S19045C98S19045C5__8S19045C2[6]),  6,24},
  {&(_tg__ZTV9S19045C108S19045C98S19045C5__8S19045C2[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C108S19045C98S19045C5__8S19045C2[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C108S19045C98S19045C5__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C108S19045C98S19045C5__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C108S19045C98S19045C5__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C108S19045C98S19045C5__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C108S19045C98S19045C5__8S19045C2[10]),  10,17},
  {&(_tg__ZTV9S19045C128S19045C98S19045C5__8S19045C2[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C128S19045C98S19045C5__8S19045C2[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C128S19045C98S19045C5__8S19045C2[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C128S19045C98S19045C5__8S19045C2[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C128S19045C98S19045C5__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C78S19045C98S19045C5__A2__8S19045C2[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C78S19045C98S19045C5__A2__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C4__8S19045C98S19045C5__8S19045C2[9]),  9,16},
  {&(_tg__ZTV9S19045C10__8S19045C98S19045C5__8S19045C2[5]),  5,17},
  {&(_tg__ZTV8S19045C8__A1__8S19045C98S19045C5__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C7__8S19045C98S19045C5__8S19045C2[10]),  10,17},
  {&(_tg__ZTV9S19045C12__8S19045C98S19045C5__8S19045C2[6]),  6,14},
  {&(_tg__ZTV9S19045C11__A1__8S19045C98S19045C5__8S19045C2[7]),  7,11},
  {&(_tg__ZTV8S19045C7__A__8S19045C98S19045C5__8S19045C2[3]),  3,10},
  {&(_tg__ZTV8S19045C6__8S19045C5__8S19045C2[17]),  17,31},
  {&(_tg__ZTV8S19045C4__8S19045C5__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C8__8S19045C5__8S19045C2[9]),  9,16},
  {&(_tg__ZTV9S19045C108S19045C9__8S19045C5__8S19045C2[5]),  5,17},
  {&(_tg__ZTV8S19045C7__A1__8S19045C5__8S19045C2[10]),  10,17},
  {&(_tg__ZTV9S19045C128S19045C9__8S19045C5__8S19045C2[6]),  6,14},
  {&(_tg__ZTV9S19045C11__A1__8S19045C5__8S19045C2[7]),  7,11},
  {&(_tg__ZTV8S19045C78S19045C9__A2__8S19045C5__8S19045C2[3]),  3,10},
  {&(_ZTV8S19045C2[39]),  39,301},
  {&(_ZTV8S19045C2[150]),  150,301},
  {&(_ZTV8S19045C2[173]),  173,301},
  {&(_ZTV8S19045C2[189]),  189,301},
  {&(_ZTV8S19045C2[70]),  70,301},
  {&(_ZTV8S19045C2[206]),  206,301},
  {&(_ZTV8S19045C2[106]),  106,301},
  {&(_ZTV8S19045C2[220]),  220,301},
  {&(_ZTV8S19045C2[117]),  117,301},
  {&(_ZTV8S19045C2[258]),  258,301},
  {&(_ZTV8S19045C2[276]),  276,301},
  {&(_ZTV8S19045C2[285]),  285,301},
  {&(_ZTV8S19045C2[294]),  294,301},
  {&(_tg__ZTV8S19045C6__8S19045C2[4]),  4,18},
  {&(_tg__ZTV8S19045C78S19045C6__8S19045C2[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C78S19045C6__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C4__8S19045C6__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C8__8S19045C6__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C7__A1__8S19045C2[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__A1__8S19045C2[9]),  9,16},
  {&(_tg__ZTV9S19045C11__A1__8S19045C2[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__A1__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__A1__8S19045C2[9]),  9,16},
  {&(_tg__ZTV9S19045C13__8S19045C2[5]),  5,21},
  {&(_tg__ZTV9S19045C109S19045C13__A1__8S19045C2[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C109S19045C13__A2__8S19045C2[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C109S19045C13__A2__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C109S19045C13__A2__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C109S19045C13__A1__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C109S19045C13__A1__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C109S19045C13__A1__8S19045C2[10]),  10,17},
  {&(_tg__ZTV8S19045C4__9S19045C13__8S19045C2[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C13__8S19045C2[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C13__8S19045C2[9]),  9,16},
};
extern VTBL_ENTRY _ZTI8S19045C2[];
extern  VTBL_ENTRY _ZTV8S19045C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C2[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S19045C5D0Ev,_ZThn204_N8S19045C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S19045C5D1Ev,_ZThn204_N8S19045C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19045C5D0Ev,_ZThn144_N8S19045C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19045C5D1Ev,_ZThn144_N8S19045C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S19045C9D0Ev,_ZThn204_N8S19045C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S19045C9D1Ev,_ZThn204_N8S19045C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N9S19045C12D0Ev,_ZThn116_N9S19045C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N9S19045C12D1Ev,_ZThn116_N9S19045C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19045C2D0Ev,_ZTv0_n24_N8S19045C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19045C2D0Ev,_ZThn236_N8S19045C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19045C2D1Ev,_ZTv0_n24_N8S19045C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19045C2D1Ev,_ZThn236_N8S19045C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C2D0Ev,_ZTv0_n20_N8S19045C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S19045C2D0Ev,_ZThn216_N8S19045C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C2D1Ev,_ZTv0_n20_N8S19045C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S19045C2D1Ev,_ZThn216_N8S19045C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C2D0Ev,_ZTv0_n48_N8S19045C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N8S19045C2D0Ev,_ZThn156_N8S19045C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C2D1Ev,_ZTv0_n48_N8S19045C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N8S19045C2D1Ev,_ZThn156_N8S19045C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19045C2 = {  "S19045C2", // class name
  bases_S19045C2, 24,
  &(vtc_S19045C2[0]), // expected_vtbl_contents
  &(vtt_S19045C2[0]), // expected_vtt_contents
  ABISELECT(512,324), // object size
  NSPAIRA(_ZTI8S19045C2),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S19045C2),301, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19045C2),66, //virtual table table var
  24, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C17  : S19045C8 , S19045C12 {
  int s19045c17f0;
  ::S19045C11 s19045c17f1;
  virtual void  v95(); // _ZN9S19045C173v95Ev
  virtual void  v96(); // _ZN9S19045C173v96Ev
  virtual void  v97(); // _ZN9S19045C173v97Ev
  virtual void  v98(); // _ZN9S19045C173v98Ev
  ~S19045C17(); // tgen
  S19045C17(); // tgen
};
//SIG(-1 S19045C17) C1{ BC2{ v5 v6 v7 v8 v9 v10 v11 FL FD} BC3{ VBC4{ VBC2 v12 v13 v14 v15 v16 v17 v18 Fp Fi} VBC5{ VBC2 VBC6{ v19 v20 v21 v22 v23 v24 v25 Fp Fs:16} vd v26 v27 Fi[4]} vd v28 v29 v30 v31 v32 v33 Fi} v1 v2 v3 v4 Fi FC5}


void  S19045C17 ::v95(){vfunc_called(this, "_ZN9S19045C173v95Ev");}
void  S19045C17 ::v96(){vfunc_called(this, "_ZN9S19045C173v96Ev");}
void  S19045C17 ::v97(){vfunc_called(this, "_ZN9S19045C173v97Ev");}
void  S19045C17 ::v98(){vfunc_called(this, "_ZN9S19045C173v98Ev");}
S19045C17 ::~S19045C17(){ note_dtor("S19045C17", this);} // tgen
S19045C17 ::S19045C17(){ note_ctor("S19045C17", this);} // tgen

static void Test_S19045C17()
{
  extern Class_Descriptor cd_S19045C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(17,41)];
    init_test(&cd_S19045C17, buf);
    S19045C17 *dp, &lv = *(dp=new (buf) S19045C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,160), "sizeof(S19045C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C17)");
    /*is_ambiguous_... S19045C17::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*), 0, "S19045C17");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(176,104), "S19045C17");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(176,104), "S19045C17");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*), ABISELECT(144,92), "S19045C17");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(232,148), "S19045C17");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*), ABISELECT(208,128), "S19045C17");
    check_base_class_offset(lv, (S19045C12*), ABISELECT(32,24), "S19045C17");
    check_field_offset(lv, s19045c17f0, ABISELECT(44,32), "S19045C17.s19045c17f0");
    check_field_offset(lv, s19045c17f1, ABISELECT(48,36), "S19045C17.s19045c17f1");
    test_class_info(&lv, &cd_S19045C17);
    dp->~S19045C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C17(Test_S19045C17, "S19045C17", ABISELECT(256,160));

#else // __cplusplus

extern void _ZN9S19045C17C1Ev();
extern void _ZN9S19045C17D1Ev();
Name_Map name_map_S19045C17[] = {
  NSPAIR(_ZN9S19045C17C1Ev),
  NSPAIR(_ZN9S19045C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
static Base_Class bases_S19045C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C8,    ABISELECT(176,104), //bcp->offset
    50, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S19045C7,    ABISELECT(144,92), //bcp->offset
    33, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S19045C4,    ABISELECT(232,148), //bcp->offset
    77, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C11,    ABISELECT(208,128), //bcp->offset
    66, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S19045C12,    ABISELECT(32,24), //bcp->offset
    19, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19045C17[];
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void _ZN9S19045C17D1Ev();
extern void _ZN9S19045C17D0Ev();
extern void ABISELECT(_ZThn32_N9S19045C17D1Ev,_ZThn24_N9S19045C17D1Ev)();
extern void ABISELECT(_ZThn32_N9S19045C17D0Ev,_ZThn24_N9S19045C17D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev)();
extern void ABISELECT(_ZThn208_N9S19045C17D1Ev,_ZThn128_N9S19045C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev)();
extern void ABISELECT(_ZThn208_N9S19045C17D0Ev,_ZThn128_N9S19045C17D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY vtc_S19045C17[] = {
  ABISELECT(232,148),
  ABISELECT(208,128),
  ABISELECT(176,104),
  ABISELECT(144,92),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&_ZN9S19045C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C17D0Ev,
  ABISELECT(200,124),
  ABISELECT(176,104),
  ABISELECT(144,80),
  ABISELECT(112,68),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19045C17D1Ev,_ZThn24_N9S19045C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19045C17D0Ev,_ZThn24_N9S19045C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-144,-92),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  ABISELECT(-208,-128),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-232,-148),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern VTBL_ENTRY _ZTV9S19045C17[];
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__9S19045C17[] = {
  ABISELECT(200,124),
  ABISELECT(176,104),
  ABISELECT(144,80),
  ABISELECT(112,68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C12__9S19045C17[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C12__9S19045C17[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZThn176_N9S19045C12D1Ev,_ZThn104_N9S19045C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void ABISELECT(_ZThn176_N9S19045C12D0Ev,_ZThn104_N9S19045C12D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C12__9S19045C17[] = {
  0,
  0,
  ABISELECT(-176,-104),
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C12__9S19045C17[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-200,-124),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C17[] = {
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__9S19045C17[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C17[] = {
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__9S19045C17[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,24),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__9S19045C17[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
static  VTT_ENTRY vtt_S19045C17[] = {
  {&(_ZTV9S19045C17[6]),  6,93},
  {&(_tg__ZTV9S19045C12__9S19045C17[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C12__9S19045C17[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C12__9S19045C17[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C12__9S19045C17[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C12__9S19045C17[9]),  9,16},
  {&(_ZTV9S19045C17[25]),  25,93},
  {&(_ZTV9S19045C17[43]),  43,93},
  {&(_ZTV9S19045C17[59]),  59,93},
  {&(_ZTV9S19045C17[73]),  73,93},
  {&(_ZTV9S19045C17[86]),  86,93},
  {&(_tg__ZTV8S19045C7__9S19045C17[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__9S19045C17[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C17[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__9S19045C17[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__9S19045C17[9]),  9,16},
};
extern VTBL_ENTRY _ZTI9S19045C17[];
extern  VTBL_ENTRY _ZTV9S19045C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C17[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19045C12D0Ev,_ZThn104_N9S19045C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S19045C12D1Ev,_ZThn104_N9S19045C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19045C17D0Ev,_ZThn128_N9S19045C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19045C17D1Ev,_ZThn128_N9S19045C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19045C17 = {  "S19045C17", // class name
  bases_S19045C17, 6,
  &(vtc_S19045C17[0]), // expected_vtbl_contents
  &(vtt_S19045C17[0]), // expected_vtt_contents
  ABISELECT(256,160), // object size
  NSPAIRA(_ZTI9S19045C17),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19045C17),93, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19045C17),16, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C16  : virtual S19045C3 , virtual S19045C11 , virtual S19045C17 , S19045C10 {
  virtual void  v99(); // _ZN9S19045C163v99Ev
  virtual void  v100(); // _ZN9S19045C164v100Ev
  virtual void  v101(); // _ZN9S19045C164v101Ev
  virtual void  v102(); // _ZN9S19045C164v102Ev
  virtual void  v103(); // _ZN9S19045C164v103Ev
  virtual void  v104(); // _ZN9S19045C164v104Ev
  ~S19045C16(); // tgen
  S19045C16(); // tgen
};
//SIG(-1 S19045C16) C1{ VBC2{ BC3{ v7 v8 v9 v10 v11 v12 v13 Fp Fs:16} v14 v15 v16 v17 v18 v19 v20 Fs} VBC4{ VBC5{ v21 v22 v23 v24 v25 v26 v27 FL FD} VBC3 vd v28 v29 Fi[4]} VBC6{ BC5 BC7{ VBC8{ VBC5 v30 v31 v32 v33 v34 v35 v36 Fp Fi} VBC4 vd v37 v38 v39 v40 v41 v42 Fi} v43 v44 v45 v46 Fi FC4} BC9{ BC4 BC5 BC3 VBC8 vd v47 v48 v49 v50 v51 v52 v53 v54 FL} v1 v2 v3 v4 v5 v6}


void  S19045C16 ::v99(){vfunc_called(this, "_ZN9S19045C163v99Ev");}
void  S19045C16 ::v100(){vfunc_called(this, "_ZN9S19045C164v100Ev");}
void  S19045C16 ::v101(){vfunc_called(this, "_ZN9S19045C164v101Ev");}
void  S19045C16 ::v102(){vfunc_called(this, "_ZN9S19045C164v102Ev");}
void  S19045C16 ::v103(){vfunc_called(this, "_ZN9S19045C164v103Ev");}
void  S19045C16 ::v104(){vfunc_called(this, "_ZN9S19045C164v104Ev");}
S19045C16 ::~S19045C16(){ note_dtor("S19045C16", this);} // tgen
S19045C16 ::S19045C16(){ note_ctor("S19045C16", this);} // tgen

static void Test_S19045C16()
{
  extern Class_Descriptor cd_S19045C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(25,60)];
    init_test(&cd_S19045C16, buf);
    S19045C16 *dp, &lv = *(dp=new (buf) S19045C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,236), "sizeof(S19045C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C16)");
    check_base_class_offset(lv, (S19045C4*)(S19045C3*), ABISELECT(96,64), "S19045C16");
    check_base_class_offset(lv, (S19045C3*), ABISELECT(96,64), "S19045C16");
    /*is_ambiguous_... S19045C16::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(144,96), "S19045C16");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(144,96), "S19045C16");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*), ABISELECT(144,96), "S19045C16");
    /*is_ambiguous_... S19045C16::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(176,120), "S19045C16");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*), ABISELECT(176,120), "S19045C16");
    /*is_ambiguous_... S19045C16::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C11*), ABISELECT(120,76), "S19045C16");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*)(S19045C17*), ABISELECT(120,76), "S19045C16");
    /*is_ambiguous_... S19045C17::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C17*), ABISELECT(208,132), "S19045C16");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*)(S19045C17*), ABISELECT(352,224), "S19045C16");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*), ABISELECT(352,224), "S19045C16");
    check_base_class_offset(lv, (S19045C12*)(S19045C17*), ABISELECT(240,156), "S19045C16");
    check_base_class_offset(lv, (S19045C17*), ABISELECT(208,132), "S19045C16");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*), 0, "S19045C16");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*), ABISELECT(32,20), "S19045C16");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*), ABISELECT(64,44), "S19045C16");
    check_base_class_offset(lv, (S19045C10*), 0, "S19045C16");
    test_class_info(&lv, &cd_S19045C16);
    dp->~S19045C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C16(Test_S19045C16, "S19045C16", ABISELECT(384,236));

#else // __cplusplus

extern void _ZN9S19045C16C1Ev();
extern void _ZN9S19045C16D1Ev();
Name_Map name_map_S19045C16[] = {
  NSPAIR(_ZN9S19045C16C1Ev),
  NSPAIR(_ZN9S19045C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C3;
extern VTBL_ENTRY _ZTI8S19045C3[];
extern  VTBL_ENTRY _ZTV8S19045C3[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C17;
extern VTBL_ENTRY _ZTI9S19045C17[];
extern  VTBL_ENTRY _ZTV9S19045C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C17[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
static Base_Class bases_S19045C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C4,    ABISELECT(96,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19045C3,    ABISELECT(96,64), //bcp->offset
    44, //bcp->virtual_function_table_offset
    16, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C8,    ABISELECT(144,96), //bcp->offset
    85, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C4,    ABISELECT(176,120), //bcp->offset
    101, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C11,    ABISELECT(120,76), //bcp->offset
    74, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C8,    ABISELECT(208,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19045C7,    ABISELECT(352,224), //bcp->offset
    168, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S19045C12,    ABISELECT(240,156), //bcp->offset
    154, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19045C17,    ABISELECT(208,132), //bcp->offset
    117, //bcp->virtual_function_table_offset
    24, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(32,20), //bcp->offset
    26, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(64,44), //bcp->offset
    35, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19045C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19045C16[];
extern void _ZN9S19045C16D1Ev();
extern void _ZN9S19045C16D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C163v99Ev();
extern void _ZN9S19045C164v100Ev();
extern void _ZN9S19045C164v101Ev();
extern void _ZN9S19045C164v102Ev();
extern void _ZN9S19045C164v103Ev();
extern void _ZN9S19045C164v104Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C33v17Ev();
extern void _ZN8S19045C33v18Ev();
extern void _ZN8S19045C33v19Ev();
extern void _ZN8S19045C33v20Ev();
extern void _ZN8S19045C33v21Ev();
extern void _ZN8S19045C33v22Ev();
extern void _ZN8S19045C33v23Ev();
extern void ABISELECT(_ZTv0_n40_N9S19045C16D1Ev,_ZTv0_n20_N9S19045C16D1Ev)();
extern void ABISELECT(_ZThn120_N9S19045C16D1Ev,_ZThn76_N9S19045C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C16D0Ev,_ZTv0_n20_N9S19045C16D0Ev)();
extern void ABISELECT(_ZThn120_N9S19045C16D0Ev,_ZThn76_N9S19045C16D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void ABISELECT(_ZTv0_n144_N9S19045C16D1Ev,_ZTv0_n72_N9S19045C16D1Ev)();
extern void ABISELECT(_ZThn208_N9S19045C16D1Ev,_ZThn132_N9S19045C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n144_N9S19045C16D0Ev,_ZTv0_n72_N9S19045C16D0Ev)();
extern void ABISELECT(_ZThn208_N9S19045C16D0Ev,_ZThn132_N9S19045C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn32_n144_N9S19045C16D1Ev,_ZTvn24_n72_N9S19045C16D1Ev)();
extern void ABISELECT(_ZTvn32_n144_N9S19045C16D0Ev,_ZTvn24_n72_N9S19045C16D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY vtc_S19045C16[] = {
  ABISELECT(208,132),
  ABISELECT(120,76),
  ABISELECT(96,64),
  ABISELECT(352,224),
  ABISELECT(176,120),
  ABISELECT(144,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN9S19045C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C16D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C163v99Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v100Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v101Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v102Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v103Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v104Ev,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-96,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v17Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v18Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v19Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v20Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v21Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v22Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v23Ev,
  0,
  0,
  ABISELECT(-120,-76),
  ABISELECT(56,44),
  ABISELECT(24,20),
  ABISELECT(-120,-76),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C16D1Ev,_ZTv0_n20_N9S19045C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C16D0Ev,_ZTv0_n20_N9S19045C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(-208,-132),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  ABISELECT(-88,-56),
  ABISELECT(-64,-36),
  ABISELECT(144,92),
  ABISELECT(-208,-132),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C16D1Ev,_ZTv0_n72_N9S19045C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C16D0Ev,_ZTv0_n72_N9S19045C16D0Ev),
  ABISELECT(-64,-36),
  ABISELECT(-120,-80),
  ABISELECT(-96,-60),
  ABISELECT(112,68),
  ABISELECT(-240,-156),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C16D1Ev,_ZTvn24_n72_N9S19045C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C16D0Ev,_ZTvn24_n72_N9S19045C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(-352,-224),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern VTBL_ENTRY _ZTV9S19045C16[];
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C10__9S19045C16[] = {
  ABISELECT(352,224),
  ABISELECT(176,120),
  ABISELECT(144,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C10__A1__9S19045C16[] = {
  ABISELECT(176,120),
  ABISELECT(144,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C10__A1__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C10__A1__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C10__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C10__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C10__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(-352,-224),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C16[] = {
  ABISELECT(56,44),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void _ZN9S19045C17D1Ev();
extern void _ZN9S19045C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C17__9S19045C16[] = {
  ABISELECT(-32,-12),
  ABISELECT(-88,-56),
  ABISELECT(-64,-36),
  ABISELECT(144,92),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&_ZN9S19045C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C17D0Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C129S19045C17__9S19045C16[] = {
  ABISELECT(-64,-36),
  ABISELECT(-120,-80),
  ABISELECT(-96,-60),
  ABISELECT(112,68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C129S19045C17__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C129S19045C17__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(96,60),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C129S19045C17__9S19045C16[] = {
  0,
  0,
  ABISELECT(120,80),
  ABISELECT(56,44),
  ABISELECT(24,20),
  ABISELECT(120,80),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C129S19045C17__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(64,36),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void ABISELECT(_ZThn32_N9S19045C17D1Ev,_ZThn24_N9S19045C17D1Ev)();
extern void ABISELECT(_ZThn32_N9S19045C17D0Ev,_ZThn24_N9S19045C17D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__9S19045C17__9S19045C16[] = {
  ABISELECT(-64,-36),
  ABISELECT(-120,-80),
  ABISELECT(-96,-60),
  ABISELECT(112,68),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19045C17D1Ev,_ZThn24_N9S19045C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19045C17D0Ev,_ZThn24_N9S19045C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C17__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(-144,-92),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__A1__9S19045C17__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(64,36),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C17__9S19045C16[] = {
  0,
  0,
  ABISELECT(88,56),
  ABISELECT(56,44),
  ABISELECT(24,20),
  ABISELECT(88,56),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C17__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C16[] = {
  ABISELECT(-208,-128),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__9S19045C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(208,128),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
static  VTT_ENTRY vtt_S19045C16[] = {
  {&(_ZTV9S19045C16[8]),  8,185},
  {&(_tg__ZTV9S19045C10__9S19045C16[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C10__A1__9S19045C16[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C10__A1__9S19045C16[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C10__A1__9S19045C16[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C10__9S19045C16[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C10__9S19045C16[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C10__9S19045C16[10]),  10,17},
  {&(_ZTV9S19045C16[60]),  60,185},
  {&(_ZTV9S19045C16[81]),  81,185},
  {&(_ZTV9S19045C16[94]),  94,185},
  {&(_ZTV9S19045C16[110]),  110,185},
  {&(_ZTV9S19045C16[141]),  141,185},
  {&(_ZTV9S19045C16[160]),  160,185},
  {&(_ZTV9S19045C16[178]),  178,185},
  {&(_tg__ZTV9S19045C11__9S19045C16[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__9S19045C16[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__9S19045C16[9]),  9,16},
  {&(_tg__ZTV9S19045C17__9S19045C16[6]),  6,19},
  {&(_tg__ZTV9S19045C129S19045C17__9S19045C16[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C129S19045C17__9S19045C16[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C129S19045C17__9S19045C16[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C129S19045C17__9S19045C16[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C129S19045C17__9S19045C16[9]),  9,16},
  {&(_tg__ZTV9S19045C12__9S19045C17__9S19045C16[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C17__9S19045C16[10]),  10,17},
  {&(_tg__ZTV8S19045C8__A1__9S19045C17__9S19045C16[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C17__9S19045C16[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C17__9S19045C16[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C16[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__9S19045C16[9]),  9,16},
};
extern VTBL_ENTRY _ZTI9S19045C16[];
extern  VTBL_ENTRY _ZTV9S19045C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C16[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C16D0Ev,_ZTv0_n72_N9S19045C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19045C16D0Ev,_ZThn132_N9S19045C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C16D1Ev,_ZTv0_n72_N9S19045C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19045C16D1Ev,_ZThn132_N9S19045C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C16D0Ev,_ZTv0_n20_N9S19045C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S19045C16D0Ev,_ZThn76_N9S19045C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C16D1Ev,_ZTv0_n20_N9S19045C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S19045C16D1Ev,_ZThn76_N9S19045C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19045C16 = {  "S19045C16", // class name
  bases_S19045C16, 13,
  &(vtc_S19045C16[0]), // expected_vtbl_contents
  &(vtt_S19045C16[0]), // expected_vtt_contents
  ABISELECT(384,236), // object size
  NSPAIRA(_ZTI9S19045C16),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19045C16),185, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19045C16),31, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C15  : virtual S19045C3 , S19045C16 , virtual S19045C13 {
  virtual  ~S19045C15(); // _ZN9S19045C15D2Ev
  virtual void  v105(); // _ZN9S19045C154v105Ev
  virtual void  v106(); // _ZN9S19045C154v106Ev
  virtual void  v107(); // _ZN9S19045C154v107Ev
  virtual void  v108(); // _ZN9S19045C154v108Ev
  virtual void  v109(); // _ZN9S19045C154v109Ev
  S19045C15(); // tgen
};
//SIG(-1 S19045C15) C1{ VBC2{ BC3{ v6 v7 v8 v9 v10 v11 v12 Fp Fs:16} v13 v14 v15 v16 v17 v18 v19 Fs} BC4{ VBC2 VBC5{ VBC6{ v20 v21 v22 v23 v24 v25 v26 FL FD} VBC3 vd v27 v28 Fi[4]} VBC7{ BC6 BC8{ VBC9{ VBC6 v29 v30 v31 v32 v33 v34 v35 Fp Fi} VBC5 vd v36 v37 v38 v39 v40 v41 Fi} v42 v43 v44 v45 Fi FC5} BC10{ BC5 BC6 BC3 VBC9 vd v46 v47 v48 v49 v50 v51 v52 v53 FL} v54 v55 v56 v57 v58 v59} VBC11{ VBC3 VBC9 BC10 BC6 v60 v61 v62 v63} vd v1 v2 v3 v4 v5}


 S19045C15 ::~S19045C15(){ note_dtor("S19045C15", this);}
void  S19045C15 ::v105(){vfunc_called(this, "_ZN9S19045C154v105Ev");}
void  S19045C15 ::v106(){vfunc_called(this, "_ZN9S19045C154v106Ev");}
void  S19045C15 ::v107(){vfunc_called(this, "_ZN9S19045C154v107Ev");}
void  S19045C15 ::v108(){vfunc_called(this, "_ZN9S19045C154v108Ev");}
void  S19045C15 ::v109(){vfunc_called(this, "_ZN9S19045C154v109Ev");}
S19045C15 ::S19045C15(){ note_ctor("S19045C15", this);} // tgen

static void Test_S19045C15()
{
  extern Class_Descriptor cd_S19045C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(33,82)];
    init_test(&cd_S19045C15, buf);
    S19045C15 *dp, &lv = *(dp=new (buf) S19045C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(512,324), "sizeof(S19045C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C15)");
    check_base_class_offset(lv, (S19045C4*)(S19045C3*), ABISELECT(96,64), "S19045C15");
    check_base_class_offset(lv, (S19045C3*), ABISELECT(96,64), "S19045C15");
    check_base_class_offset(lv, (S19045C3*)(S19045C16*), ABISELECT(96,64), "S19045C15");
    /*is_ambiguous_... S19045C15::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(144,96), "S19045C15");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(144,96), "S19045C15");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*)(S19045C16*), ABISELECT(144,96), "S19045C15");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*)(S19045C13*), ABISELECT(144,96), "S19045C15");
    /*is_ambiguous_... S19045C15::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(176,120), "S19045C15");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*)(S19045C16*), ABISELECT(176,120), "S19045C15");
    /*is_ambiguous_... S19045C13::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C13*), ABISELECT(176,120), "S19045C15");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*)(S19045C13*), ABISELECT(176,120), "S19045C15");
    /*is_ambiguous_... S19045C16::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C11*)(S19045C16*), ABISELECT(120,76), "S19045C15");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*)(S19045C17*), ABISELECT(120,76), "S19045C15");
    /*is_ambiguous_... S19045C17::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C17*), ABISELECT(208,132), "S19045C15");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*)(S19045C17*), ABISELECT(352,224), "S19045C15");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*)(S19045C16*), ABISELECT(352,224), "S19045C15");
    check_base_class_offset(lv, (S19045C7*)(S19045C13*), ABISELECT(352,224), "S19045C15");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*)(S19045C13*), ABISELECT(352,224), "S19045C15");
    check_base_class_offset(lv, (S19045C12*)(S19045C17*), ABISELECT(240,156), "S19045C15");
    check_base_class_offset(lv, (S19045C17*)(S19045C16*), ABISELECT(208,132), "S19045C15");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*)(S19045C16*), 0, "S19045C15");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*)(S19045C16*), ABISELECT(32,20), "S19045C15");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*)(S19045C16*), ABISELECT(64,44), "S19045C15");
    check_base_class_offset(lv, (S19045C10*)(S19045C16*), 0, "S19045C15");
    check_base_class_offset(lv, (S19045C16*), 0, "S19045C15");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*)(S19045C13*), ABISELECT(384,236), "S19045C15");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*)(S19045C13*), ABISELECT(416,256), "S19045C15");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*)(S19045C13*), ABISELECT(448,280), "S19045C15");
    check_base_class_offset(lv, (S19045C10*)(S19045C13*), ABISELECT(384,236), "S19045C15");
    /*is_ambiguous_... S19045C13::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C13*), ABISELECT(480,300), "S19045C15");
    check_base_class_offset(lv, (S19045C13*), ABISELECT(384,236), "S19045C15");
    test_class_info(&lv, &cd_S19045C15);
    dp->~S19045C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C15(Test_S19045C15, "S19045C15", ABISELECT(512,324));

#else // __cplusplus

extern void _ZN9S19045C15C1Ev();
extern void _ZN9S19045C15D2Ev();
Name_Map name_map_S19045C15[] = {
  NSPAIR(_ZN9S19045C15C1Ev),
  NSPAIR(_ZN9S19045C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C3;
extern VTBL_ENTRY _ZTI8S19045C3[];
extern  VTBL_ENTRY _ZTV8S19045C3[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C17;
extern VTBL_ENTRY _ZTI9S19045C17[];
extern  VTBL_ENTRY _ZTV9S19045C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C17[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C16;
extern VTBL_ENTRY _ZTI9S19045C16[];
extern  VTBL_ENTRY _ZTV9S19045C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C16[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C13;
extern VTBL_ENTRY _ZTI9S19045C13[];
extern  VTBL_ENTRY _ZTV9S19045C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C13[];
static Base_Class bases_S19045C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C4,    ABISELECT(96,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19045C3,    ABISELECT(96,64), //bcp->offset
    50, //bcp->virtual_function_table_offset
    16, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C8,    ABISELECT(144,96), //bcp->offset
    91, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C4,    ABISELECT(176,120), //bcp->offset
    107, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C11,    ABISELECT(120,76), //bcp->offset
    80, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S19045C8,    ABISELECT(208,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19045C7,    ABISELECT(352,224), //bcp->offset
    174, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S19045C12,    ABISELECT(240,156), //bcp->offset
    160, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19045C17,    ABISELECT(208,132), //bcp->offset
    123, //bcp->virtual_function_table_offset
    24, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19045C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(32,20), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(64,44), //bcp->offset
    41, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19045C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19045C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C11,    ABISELECT(384,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(416,256), //bcp->offset
    241, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(448,280), //bcp->offset
    250, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19045C10,    ABISELECT(384,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(480,300), //bcp->offset
    259, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19045C13,    ABISELECT(384,236), //bcp->offset
    191, //bcp->virtual_function_table_offset
    34, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19045C15[];
extern void _ZN9S19045C15D1Ev();
extern void _ZN9S19045C15D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C163v99Ev();
extern void _ZN9S19045C164v100Ev();
extern void _ZN9S19045C164v101Ev();
extern void _ZN9S19045C164v102Ev();
extern void _ZN9S19045C164v103Ev();
extern void _ZN9S19045C164v104Ev();
extern void _ZN9S19045C154v105Ev();
extern void _ZN9S19045C154v106Ev();
extern void _ZN9S19045C154v107Ev();
extern void _ZN9S19045C154v108Ev();
extern void _ZN9S19045C154v109Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C33v17Ev();
extern void _ZN8S19045C33v18Ev();
extern void _ZN8S19045C33v19Ev();
extern void _ZN8S19045C33v20Ev();
extern void _ZN8S19045C33v21Ev();
extern void _ZN8S19045C33v22Ev();
extern void _ZN8S19045C33v23Ev();
extern void ABISELECT(_ZTv0_n40_N9S19045C15D1Ev,_ZTv0_n20_N9S19045C15D1Ev)();
extern void ABISELECT(_ZThn120_N9S19045C15D1Ev,_ZThn76_N9S19045C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C15D0Ev,_ZTv0_n20_N9S19045C15D0Ev)();
extern void ABISELECT(_ZThn120_N9S19045C15D0Ev,_ZThn76_N9S19045C15D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void ABISELECT(_ZTv0_n144_N9S19045C15D1Ev,_ZTv0_n72_N9S19045C15D1Ev)();
extern void ABISELECT(_ZThn208_N9S19045C15D1Ev,_ZThn132_N9S19045C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n144_N9S19045C15D0Ev,_ZTv0_n72_N9S19045C15D0Ev)();
extern void ABISELECT(_ZThn208_N9S19045C15D0Ev,_ZThn132_N9S19045C15D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn32_n144_N9S19045C15D1Ev,_ZTvn24_n72_N9S19045C15D1Ev)();
extern void ABISELECT(_ZTvn32_n144_N9S19045C15D0Ev,_ZTvn24_n72_N9S19045C15D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n48_N9S19045C15D1Ev,_ZTv0_n24_N9S19045C15D1Ev)();
extern void ABISELECT(_ZThn384_N9S19045C15D1Ev,_ZThn236_N9S19045C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19045C15D0Ev,_ZTv0_n24_N9S19045C15D0Ev)();
extern void ABISELECT(_ZThn384_N9S19045C15D0Ev,_ZThn236_N9S19045C15D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C133v76Ev();
extern void _ZN9S19045C133v77Ev();
extern void _ZN9S19045C133v78Ev();
extern void _ZN9S19045C133v79Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY vtc_S19045C15[] = {
  ABISELECT(384,236),
  ABISELECT(208,132),
  ABISELECT(120,76),
  ABISELECT(96,64),
  ABISELECT(352,224),
  ABISELECT(176,120),
  ABISELECT(144,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN9S19045C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C163v99Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v100Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v101Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v102Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v103Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v104Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v105Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v106Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v107Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v108Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v109Ev,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-96,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v17Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v18Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v19Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v20Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v21Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v22Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v23Ev,
  0,
  0,
  ABISELECT(-120,-76),
  ABISELECT(56,44),
  ABISELECT(24,20),
  ABISELECT(-120,-76),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C15D1Ev,_ZTv0_n20_N9S19045C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C15D0Ev,_ZTv0_n20_N9S19045C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(-208,-132),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  ABISELECT(-88,-56),
  ABISELECT(-64,-36),
  ABISELECT(144,92),
  ABISELECT(-208,-132),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C15D1Ev,_ZTv0_n72_N9S19045C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C15D0Ev,_ZTv0_n72_N9S19045C15D0Ev),
  ABISELECT(-64,-36),
  ABISELECT(-120,-80),
  ABISELECT(-96,-60),
  ABISELECT(112,68),
  ABISELECT(-240,-156),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C15D1Ev,_ZTvn24_n72_N9S19045C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C15D0Ev,_ZTvn24_n72_N9S19045C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(-352,-224),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  0,
  0,
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-384,-236),
  ABISELECT(-32,-12),
  ABISELECT(-208,-116),
  ABISELECT(-240,-140),
  ABISELECT(-384,-236),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19045C15D1Ev,_ZTv0_n24_N9S19045C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19045C15D0Ev,_ZTv0_n24_N9S19045C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v76Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v77Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v78Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v79Ev,
  ABISELECT(-416,-256),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-448,-280),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(-480,-300),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern VTBL_ENTRY _ZTV9S19045C15[];
extern void _ZN9S19045C16D1Ev();
extern void _ZN9S19045C16D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C163v99Ev();
extern void _ZN9S19045C164v100Ev();
extern void _ZN9S19045C164v101Ev();
extern void _ZN9S19045C164v102Ev();
extern void _ZN9S19045C164v103Ev();
extern void _ZN9S19045C164v104Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C16__9S19045C15[] = {
  ABISELECT(208,132),
  ABISELECT(120,76),
  ABISELECT(96,64),
  ABISELECT(352,224),
  ABISELECT(176,120),
  ABISELECT(144,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN9S19045C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C16D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C163v99Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v100Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v101Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v102Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v103Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v104Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C109S19045C16__9S19045C15[] = {
  ABISELECT(352,224),
  ABISELECT(176,120),
  ABISELECT(144,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C109S19045C16__A1__9S19045C15[] = {
  ABISELECT(176,120),
  ABISELECT(144,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C109S19045C16__A1__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C109S19045C16__A1__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C109S19045C16__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C109S19045C16__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C109S19045C16__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(-352,-224),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C33v17Ev();
extern void _ZN8S19045C33v18Ev();
extern void _ZN8S19045C33v19Ev();
extern void _ZN8S19045C33v20Ev();
extern void _ZN8S19045C33v21Ev();
extern void _ZN8S19045C33v22Ev();
extern void _ZN8S19045C33v23Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C3__9S19045C16__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-96,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v17Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v18Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v19Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v20Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v21Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v22Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v23Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C16D1Ev,_ZTv0_n20_N9S19045C16D1Ev)();
extern void ABISELECT(_ZThn120_N9S19045C16D1Ev,_ZThn76_N9S19045C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C16D0Ev,_ZTv0_n20_N9S19045C16D0Ev)();
extern void ABISELECT(_ZThn120_N9S19045C16D0Ev,_ZThn76_N9S19045C16D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C16__9S19045C15[] = {
  0,
  0,
  ABISELECT(-120,-76),
  ABISELECT(56,44),
  ABISELECT(24,20),
  ABISELECT(-120,-76),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C16D1Ev,_ZTv0_n20_N9S19045C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C16D0Ev,_ZTv0_n20_N9S19045C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C16__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__A1__9S19045C16__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-120),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void ABISELECT(_ZTv0_n144_N9S19045C16D1Ev,_ZTv0_n72_N9S19045C16D1Ev)();
extern void ABISELECT(_ZThn208_N9S19045C16D1Ev,_ZThn132_N9S19045C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n144_N9S19045C16D0Ev,_ZTv0_n72_N9S19045C16D0Ev)();
extern void ABISELECT(_ZThn208_N9S19045C16D0Ev,_ZThn132_N9S19045C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19045C17__9S19045C16__9S19045C15[] = {
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(-208,-132),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  ABISELECT(-88,-56),
  ABISELECT(-64,-36),
  ABISELECT(144,92),
  ABISELECT(-208,-132),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C16D1Ev,_ZTv0_n72_N9S19045C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C16D0Ev,_ZTv0_n72_N9S19045C16D0Ev),
};
extern void ABISELECT(_ZTvn32_n144_N9S19045C16D1Ev,_ZTvn24_n72_N9S19045C16D1Ev)();
extern void ABISELECT(_ZTvn32_n144_N9S19045C16D0Ev,_ZTvn24_n72_N9S19045C16D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C129S19045C17__9S19045C16__9S19045C15[] = {
  ABISELECT(-64,-36),
  ABISELECT(-120,-80),
  ABISELECT(-96,-60),
  ABISELECT(112,68),
  ABISELECT(-240,-156),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C16D1Ev,_ZTvn24_n72_N9S19045C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C16D0Ev,_ZTvn24_n72_N9S19045C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C16__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(-352,-224),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C15[] = {
  ABISELECT(56,44),
  ABISELECT(24,20),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void _ZN9S19045C17D1Ev();
extern void _ZN9S19045C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C17__9S19045C15[] = {
  ABISELECT(-32,-12),
  ABISELECT(-88,-56),
  ABISELECT(-64,-36),
  ABISELECT(144,92),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&_ZN9S19045C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C17D0Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C129S19045C17__9S19045C15[] = {
  ABISELECT(-64,-36),
  ABISELECT(-120,-80),
  ABISELECT(-96,-60),
  ABISELECT(112,68),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C129S19045C17__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C129S19045C17__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(96,60),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C129S19045C17__9S19045C15[] = {
  0,
  0,
  ABISELECT(120,80),
  ABISELECT(56,44),
  ABISELECT(24,20),
  ABISELECT(120,80),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C129S19045C17__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(64,36),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void ABISELECT(_ZThn32_N9S19045C17D1Ev,_ZThn24_N9S19045C17D1Ev)();
extern void ABISELECT(_ZThn32_N9S19045C17D0Ev,_ZThn24_N9S19045C17D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__9S19045C17__9S19045C15[] = {
  ABISELECT(-64,-36),
  ABISELECT(-120,-80),
  ABISELECT(-96,-60),
  ABISELECT(112,68),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19045C17D1Ev,_ZThn24_N9S19045C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19045C17D0Ev,_ZThn24_N9S19045C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C17__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(-144,-92),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__A1__9S19045C17__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(64,36),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C17__9S19045C15[] = {
  0,
  0,
  ABISELECT(88,56),
  ABISELECT(56,44),
  ABISELECT(24,20),
  ABISELECT(88,56),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C17__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C15[] = {
  ABISELECT(-208,-128),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(208,128),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN9S19045C13D1Ev();
extern void _ZN9S19045C13D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C133v76Ev();
extern void _ZN9S19045C133v77Ev();
extern void _ZN9S19045C133v78Ev();
extern void _ZN9S19045C133v79Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C13__9S19045C15[] = {
  ABISELECT(-32,-12),
  ABISELECT(-208,-116),
  ABISELECT(-240,-140),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN9S19045C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C13D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v76Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v77Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v78Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v79Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C109S19045C13__A1__9S19045C15[] = {
  ABISELECT(-32,-12),
  ABISELECT(-208,-116),
  ABISELECT(-240,-140),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C109S19045C13__A2__9S19045C15[] = {
  ABISELECT(-208,-116),
  ABISELECT(-240,-140),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C109S19045C13__A2__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(240,140),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C109S19045C13__A2__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(208,116),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C109S19045C13__A1__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(240,140),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C109S19045C13__A1__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(208,116),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C109S19045C13__A1__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C13__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(208,116),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C13__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-128),
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C13__9S19045C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(240,140),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
static  VTT_ENTRY vtt_S19045C15[] = {
  {&(_ZTV9S19045C15[9]),  9,268},
  {&(_tg__ZTV9S19045C16__9S19045C15[8]),  8,26},
  {&(_tg__ZTV9S19045C109S19045C16__9S19045C15[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C109S19045C16__A1__9S19045C15[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C109S19045C16__A1__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C109S19045C16__A1__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C109S19045C16__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C109S19045C16__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C109S19045C16__9S19045C15[10]),  10,17},
  {&(_tg__ZTV8S19045C3__9S19045C16__9S19045C15[16]),  16,30},
  {&(_tg__ZTV9S19045C11__9S19045C16__9S19045C15[7]),  7,11},
  {&(_tg__ZTV8S19045C8__9S19045C16__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C4__A1__9S19045C16__9S19045C15[9]),  9,16},
  {&(_tg__ZTV9S19045C17__9S19045C16__9S19045C15[24]),  24,37},
  {&(_tg__ZTV9S19045C129S19045C17__9S19045C16__9S19045C15[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C16__9S19045C15[10]),  10,17},
  {&(_ZTV9S19045C15[66]),  66,268},
  {&(_ZTV9S19045C15[87]),  87,268},
  {&(_ZTV9S19045C15[100]),  100,268},
  {&(_ZTV9S19045C15[116]),  116,268},
  {&(_ZTV9S19045C15[147]),  147,268},
  {&(_ZTV9S19045C15[166]),  166,268},
  {&(_ZTV9S19045C15[184]),  184,268},
  {&(_ZTV9S19045C15[225]),  225,268},
  {&(_ZTV9S19045C15[243]),  243,268},
  {&(_ZTV9S19045C15[252]),  252,268},
  {&(_ZTV9S19045C15[261]),  261,268},
  {&(_tg__ZTV9S19045C11__9S19045C15[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__9S19045C15[9]),  9,16},
  {&(_tg__ZTV9S19045C17__9S19045C15[6]),  6,19},
  {&(_tg__ZTV9S19045C129S19045C17__9S19045C15[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C129S19045C17__9S19045C15[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C129S19045C17__9S19045C15[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C129S19045C17__9S19045C15[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C129S19045C17__9S19045C15[9]),  9,16},
  {&(_tg__ZTV9S19045C12__9S19045C17__9S19045C15[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C17__9S19045C15[10]),  10,17},
  {&(_tg__ZTV8S19045C8__A1__9S19045C17__9S19045C15[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C17__9S19045C15[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C17__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C15[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__9S19045C15[9]),  9,16},
  {&(_tg__ZTV9S19045C13__9S19045C15[5]),  5,21},
  {&(_tg__ZTV9S19045C109S19045C13__A1__9S19045C15[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C109S19045C13__A2__9S19045C15[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C109S19045C13__A2__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C109S19045C13__A2__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C109S19045C13__A1__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C109S19045C13__A1__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C109S19045C13__A1__9S19045C15[10]),  10,17},
  {&(_tg__ZTV8S19045C4__9S19045C13__9S19045C15[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C13__9S19045C15[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C13__9S19045C15[9]),  9,16},
};
extern VTBL_ENTRY _ZTI9S19045C15[];
extern  VTBL_ENTRY _ZTV9S19045C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C15[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C16D0Ev,_ZTv0_n72_N9S19045C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19045C16D0Ev,_ZThn132_N9S19045C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C16D1Ev,_ZTv0_n72_N9S19045C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19045C16D1Ev,_ZThn132_N9S19045C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C16D0Ev,_ZTv0_n20_N9S19045C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S19045C16D0Ev,_ZThn76_N9S19045C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C16D1Ev,_ZTv0_n20_N9S19045C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S19045C16D1Ev,_ZThn76_N9S19045C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19045C15D0Ev,_ZTv0_n24_N9S19045C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N9S19045C15D0Ev,_ZThn236_N9S19045C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19045C15D1Ev,_ZTv0_n24_N9S19045C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N9S19045C15D1Ev,_ZThn236_N9S19045C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C15D0Ev,_ZTv0_n72_N9S19045C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19045C15D0Ev,_ZThn132_N9S19045C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C15D1Ev,_ZTv0_n72_N9S19045C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19045C15D1Ev,_ZThn132_N9S19045C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C15D0Ev,_ZTv0_n20_N9S19045C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S19045C15D0Ev,_ZThn76_N9S19045C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C15D1Ev,_ZTv0_n20_N9S19045C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S19045C15D1Ev,_ZThn76_N9S19045C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19045C15 = {  "S19045C15", // class name
  bases_S19045C15, 20,
  &(vtc_S19045C15[0]), // expected_vtbl_contents
  &(vtt_S19045C15[0]), // expected_vtt_contents
  ABISELECT(512,324), // object size
  NSPAIRA(_ZTI9S19045C15),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19045C15),268, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19045C15),54, //virtual table table var
  20, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C19  : S19045C12 {
  virtual  ~S19045C19(); // _ZN9S19045C19D2Ev
  virtual void  v110(); // _ZN9S19045C194v110Ev
  virtual void  v111(); // _ZN9S19045C194v111Ev
  virtual void  v112(); // _ZN9S19045C194v112Ev
  virtual void  v113(); // _ZN9S19045C194v113Ev
  S19045C19(); // tgen
};
//SIG(-1 S19045C19) C1{ BC2{ VBC3{ VBC4{ v5 v6 v7 v8 v9 v10 v11 FL FD} v12 v13 v14 v15 v16 v17 v18 Fp Fi} VBC5{ VBC4 VBC6{ v19 v20 v21 v22 v23 v24 v25 Fp Fs:16} vd v26 v27 Fi[4]} vd v28 v29 v30 v31 v32 v33 Fi} vd v1 v2 v3 v4}


 S19045C19 ::~S19045C19(){ note_dtor("S19045C19", this);}
void  S19045C19 ::v110(){vfunc_called(this, "_ZN9S19045C194v110Ev");}
void  S19045C19 ::v111(){vfunc_called(this, "_ZN9S19045C194v111Ev");}
void  S19045C19 ::v112(){vfunc_called(this, "_ZN9S19045C194v112Ev");}
void  S19045C19 ::v113(){vfunc_called(this, "_ZN9S19045C194v113Ev");}
S19045C19 ::S19045C19(){ note_ctor("S19045C19", this);} // tgen

static void Test_S19045C19()
{
  extern Class_Descriptor cd_S19045C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,20)];
    init_test(&cd_S19045C19, buf);
    S19045C19 *dp, &lv = *(dp=new (buf) S19045C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,76), "sizeof(S19045C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C19)");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(48,20), "S19045C19");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(48,20), "S19045C19");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*), ABISELECT(16,8), "S19045C19");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(104,64), "S19045C19");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*), ABISELECT(80,44), "S19045C19");
    check_base_class_offset(lv, (S19045C12*), 0, "S19045C19");
    test_class_info(&lv, &cd_S19045C19);
    dp->~S19045C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C19(Test_S19045C19, "S19045C19", ABISELECT(128,76));

#else // __cplusplus

extern void _ZN9S19045C19C1Ev();
extern void _ZN9S19045C19D2Ev();
Name_Map name_map_S19045C19[] = {
  NSPAIR(_ZN9S19045C19C1Ev),
  NSPAIR(_ZN9S19045C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
static Base_Class bases_S19045C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C8,    ABISELECT(48,20), //bcp->offset
    35, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S19045C7,    ABISELECT(16,8), //bcp->offset
    18, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C4,    ABISELECT(104,64), //bcp->offset
    62, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19045C11,    ABISELECT(80,44), //bcp->offset
    51, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19045C19[];
extern void _ZN9S19045C19D1Ev();
extern void _ZN9S19045C19D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN9S19045C194v110Ev();
extern void _ZN9S19045C194v111Ev();
extern void _ZN9S19045C194v112Ev();
extern void _ZN9S19045C194v113Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void ABISELECT(_ZTv0_n40_N9S19045C19D1Ev,_ZTv0_n20_N9S19045C19D1Ev)();
extern void ABISELECT(_ZThn80_N9S19045C19D1Ev,_ZThn44_N9S19045C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C19D0Ev,_ZTv0_n20_N9S19045C19D0Ev)();
extern void ABISELECT(_ZThn80_N9S19045C19D0Ev,_ZThn44_N9S19045C19D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY vtc_S19045C19[] = {
  ABISELECT(104,64),
  ABISELECT(80,44),
  ABISELECT(48,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN9S19045C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C19D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v110Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v111Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v112Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v113Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  ABISELECT(-80,-44),
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C19D1Ev,_ZTv0_n20_N9S19045C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C19D0Ev,_ZTv0_n20_N9S19045C19D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern VTBL_ENTRY _ZTV9S19045C19[];
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__9S19045C19[] = {
  ABISELECT(104,64),
  ABISELECT(80,44),
  ABISELECT(48,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C12__9S19045C19[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C12__9S19045C19[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZThn80_N9S19045C12D1Ev,_ZThn44_N9S19045C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void ABISELECT(_ZThn80_N9S19045C12D0Ev,_ZThn44_N9S19045C12D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C12__9S19045C19[] = {
  0,
  0,
  ABISELECT(-80,-44),
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C12__9S19045C19[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C19[] = {
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__9S19045C19[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C19[] = {
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__9S19045C19[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,24),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__9S19045C19[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
static  VTT_ENTRY vtt_S19045C19[] = {
  {&(_ZTV9S19045C19[6]),  6,78},
  {&(_tg__ZTV9S19045C12__9S19045C19[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C12__9S19045C19[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C12__9S19045C19[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C12__9S19045C19[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C12__9S19045C19[9]),  9,16},
  {&(_ZTV9S19045C19[28]),  28,78},
  {&(_ZTV9S19045C19[44]),  44,78},
  {&(_ZTV9S19045C19[58]),  58,78},
  {&(_ZTV9S19045C19[71]),  71,78},
  {&(_tg__ZTV8S19045C7__9S19045C19[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__9S19045C19[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C19[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__9S19045C19[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__9S19045C19[9]),  9,16},
};
extern VTBL_ENTRY _ZTI9S19045C19[];
extern  VTBL_ENTRY _ZTV9S19045C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C19[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19045C12D0Ev,_ZThn44_N9S19045C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19045C12D1Ev,_ZThn44_N9S19045C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C19D0Ev,_ZTv0_n20_N9S19045C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19045C19D0Ev,_ZThn44_N9S19045C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C19D1Ev,_ZTv0_n20_N9S19045C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19045C19D1Ev,_ZThn44_N9S19045C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19045C19 = {  "S19045C19", // class name
  bases_S19045C19, 5,
  &(vtc_S19045C19[0]), // expected_vtbl_contents
  &(vtt_S19045C19[0]), // expected_vtt_contents
  ABISELECT(128,76), // object size
  NSPAIRA(_ZTI9S19045C19),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S19045C19),78, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19045C19),15, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C18  : virtual S19045C19 , virtual S19045C10 , virtual S19045C17 {
  void *s19045c18f0;
  virtual  ~S19045C18(); // _ZN9S19045C18D2Ev
  virtual void  v114(); // _ZN9S19045C184v114Ev
  virtual void  v115(); // _ZN9S19045C184v115Ev
  virtual void  v116(); // _ZN9S19045C184v116Ev
  virtual void  v117(); // _ZN9S19045C184v117Ev
  virtual void  v118(); // _ZN9S19045C184v118Ev
  virtual void  v119(); // _ZN9S19045C184v119Ev
  S19045C18(); // tgen
};
//SIG(-1 S19045C18) C1{ VBC2{ BC3{ VBC4{ VBC5{ v7 v8 v9 v10 v11 v12 v13 FL FD} v14 v15 v16 v17 v18 v19 v20 Fp Fi} VBC6{ VBC5 VBC7{ v21 v22 v23 v24 v25 v26 v27 Fp Fs:16} vd v28 v29 Fi[4]} vd v30 v31 v32 v33 v34 v35 Fi} vd v36 v37 v38 v39} VBC8{ BC6 BC5 BC7 VBC4 vd v40 v41 v42 v43 v44 v45 v46 v47 FL} VBC9{ BC5 BC3 v48 v49 v50 v51 Fi FC6} vd v1 v2 v3 v4 v5 v6 Fp}


 S19045C18 ::~S19045C18(){ note_dtor("S19045C18", this);}
void  S19045C18 ::v114(){vfunc_called(this, "_ZN9S19045C184v114Ev");}
void  S19045C18 ::v115(){vfunc_called(this, "_ZN9S19045C184v115Ev");}
void  S19045C18 ::v116(){vfunc_called(this, "_ZN9S19045C184v116Ev");}
void  S19045C18 ::v117(){vfunc_called(this, "_ZN9S19045C184v117Ev");}
void  S19045C18 ::v118(){vfunc_called(this, "_ZN9S19045C184v118Ev");}
void  S19045C18 ::v119(){vfunc_called(this, "_ZN9S19045C184v119Ev");}
S19045C18 ::S19045C18(){ note_ctor("S19045C18", this);} // tgen

static void Test_S19045C18()
{
  extern Class_Descriptor cd_S19045C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(25,61)];
    init_test(&cd_S19045C18, buf);
    S19045C18 *dp, &lv = *(dp=new (buf) S19045C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,240), "sizeof(S19045C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C18)");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(64,28), "S19045C18");
    /*is_ambiguous_... S19045C18::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(64,28), "S19045C18");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*), ABISELECT(64,28), "S19045C18");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*)(S19045C19*), ABISELECT(32,16), "S19045C18");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*), ABISELECT(32,16), "S19045C18");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*)(S19045C17*), ABISELECT(32,16), "S19045C18");
    /*is_ambiguous_... S19045C18::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(120,72), "S19045C18");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*), ABISELECT(120,72), "S19045C18");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*)(S19045C19*), ABISELECT(96,52), "S19045C18");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*)(S19045C17*), ABISELECT(96,52), "S19045C18");
    check_base_class_offset(lv, (S19045C12*)(S19045C19*), ABISELECT(16,8), "S19045C18");
    check_base_class_offset(lv, (S19045C19*), ABISELECT(16,8), "S19045C18");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*), ABISELECT(144,84), "S19045C18");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*), ABISELECT(176,104), "S19045C18");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*), ABISELECT(208,128), "S19045C18");
    check_base_class_offset(lv, (S19045C10*), ABISELECT(144,84), "S19045C18");
    /*is_ambiguous_... S19045C17::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C17*), ABISELECT(240,148), "S19045C18");
    check_base_class_offset(lv, (S19045C12*)(S19045C17*), ABISELECT(272,172), "S19045C18");
    check_base_class_offset(lv, (S19045C17*), ABISELECT(240,148), "S19045C18");
    check_field_offset(lv, s19045c18f0, ABISELECT(8,4), "S19045C18.s19045c18f0");
    test_class_info(&lv, &cd_S19045C18);
    dp->~S19045C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C18(Test_S19045C18, "S19045C18", ABISELECT(384,240));

#else // __cplusplus

extern void _ZN9S19045C18C1Ev();
extern void _ZN9S19045C18D2Ev();
Name_Map name_map_S19045C18[] = {
  NSPAIR(_ZN9S19045C18C1Ev),
  NSPAIR(_ZN9S19045C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C19;
extern VTBL_ENTRY _ZTI9S19045C19[];
extern  VTBL_ENTRY _ZTV9S19045C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C19[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C17;
extern VTBL_ENTRY _ZTI9S19045C17[];
extern  VTBL_ENTRY _ZTV9S19045C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C17[];
static Base_Class bases_S19045C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C8,    ABISELECT(64,28), //bcp->offset
    63, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S19045C7,    ABISELECT(32,16), //bcp->offset
    46, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C4,    ABISELECT(120,72), //bcp->offset
    90, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S19045C11,    ABISELECT(96,52), //bcp->offset
    79, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C12,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19045C19,    ABISELECT(16,8), //bcp->offset
    17, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C11,    ABISELECT(144,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(176,104), //bcp->offset
    148, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(208,128), //bcp->offset
    157, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19045C10,    ABISELECT(144,84), //bcp->offset
    106, //bcp->virtual_function_table_offset
    30, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C8,    ABISELECT(240,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19045C12,    ABISELECT(272,172), //bcp->offset
    203, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19045C17,    ABISELECT(240,148), //bcp->offset
    166, //bcp->virtual_function_table_offset
    24, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19045C18[];
extern void _ZN9S19045C18D1Ev();
extern void _ZN9S19045C18D0Ev();
extern void _ZN9S19045C184v114Ev();
extern void _ZN9S19045C184v115Ev();
extern void _ZN9S19045C184v116Ev();
extern void _ZN9S19045C184v117Ev();
extern void _ZN9S19045C184v118Ev();
extern void _ZN9S19045C184v119Ev();
extern void ABISELECT(_ZTv0_n56_N9S19045C18D1Ev,_ZTv0_n28_N9S19045C18D1Ev)();
extern void ABISELECT(_ZThn16_N9S19045C18D1Ev,_ZThn8_N9S19045C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19045C18D0Ev,_ZTv0_n28_N9S19045C18D0Ev)();
extern void ABISELECT(_ZThn16_N9S19045C18D0Ev,_ZThn8_N9S19045C18D0Ev)() __attribute__((weak));
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN9S19045C194v110Ev();
extern void _ZN9S19045C194v111Ev();
extern void _ZN9S19045C194v112Ev();
extern void _ZN9S19045C194v113Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void ABISELECT(_ZTv0_n40_N9S19045C18D1Ev,_ZTv0_n20_N9S19045C18D1Ev)();
extern void ABISELECT(_ZThn96_N9S19045C18D1Ev,_ZThn52_N9S19045C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C18D0Ev,_ZTv0_n20_N9S19045C18D0Ev)();
extern void ABISELECT(_ZThn96_N9S19045C18D0Ev,_ZThn52_N9S19045C18D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void ABISELECT(_ZTv0_n48_N9S19045C18D1Ev,_ZTv0_n24_N9S19045C18D1Ev)();
extern void ABISELECT(_ZThn144_N9S19045C18D1Ev,_ZThn84_N9S19045C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19045C18D0Ev,_ZTv0_n24_N9S19045C18D0Ev)();
extern void ABISELECT(_ZThn144_N9S19045C18D0Ev,_ZThn84_N9S19045C18D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void ABISELECT(_ZTv0_n144_N9S19045C18D1Ev,_ZTv0_n72_N9S19045C18D1Ev)();
extern void ABISELECT(_ZThn240_N9S19045C18D1Ev,_ZThn148_N9S19045C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n144_N9S19045C18D0Ev,_ZTv0_n72_N9S19045C18D0Ev)();
extern void ABISELECT(_ZThn240_N9S19045C18D0Ev,_ZThn148_N9S19045C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn32_n144_N9S19045C18D1Ev,_ZTvn24_n72_N9S19045C18D1Ev)();
extern void ABISELECT(_ZTvn32_n144_N9S19045C18D0Ev,_ZTvn24_n72_N9S19045C18D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY vtc_S19045C18[] = {
  ABISELECT(240,148),
  ABISELECT(144,84),
  ABISELECT(120,72),
  ABISELECT(96,52),
  ABISELECT(64,28),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN9S19045C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v114Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v115Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v116Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v117Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v118Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v119Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-16,-8),
  ABISELECT(104,64),
  ABISELECT(80,44),
  ABISELECT(48,20),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19045C18D1Ev,_ZTv0_n28_N9S19045C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19045C18D0Ev,_ZTv0_n28_N9S19045C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v110Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v111Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v112Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v113Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-28),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  ABISELECT(-96,-52),
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C18D1Ev,_ZTv0_n20_N9S19045C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C18D0Ev,_ZTv0_n20_N9S19045C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-120,-72),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-84),
  ABISELECT(-112,-68),
  ABISELECT(-24,-12),
  ABISELECT(-80,-56),
  ABISELECT(-144,-84),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19045C18D1Ev,_ZTv0_n24_N9S19045C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19045C18D0Ev,_ZTv0_n24_N9S19045C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-208,-128),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(-240,-148),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-120,-76),
  ABISELECT(-144,-96),
  ABISELECT(-176,-120),
  ABISELECT(-208,-132),
  ABISELECT(-240,-148),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C18D1Ev,_ZTv0_n72_N9S19045C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C18D0Ev,_ZTv0_n72_N9S19045C18D0Ev),
  ABISELECT(-152,-100),
  ABISELECT(-176,-120),
  ABISELECT(-208,-144),
  ABISELECT(-240,-156),
  ABISELECT(-272,-172),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C18D1Ev,_ZTvn24_n72_N9S19045C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C18D0Ev,_ZTvn24_n72_N9S19045C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern VTBL_ENTRY _ZTV9S19045C18[];
extern void _ZN9S19045C19D1Ev();
extern void _ZN9S19045C19D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN9S19045C194v110Ev();
extern void _ZN9S19045C194v111Ev();
extern void _ZN9S19045C194v112Ev();
extern void _ZN9S19045C194v113Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C19__9S19045C18[] = {
  ABISELECT(104,64),
  ABISELECT(80,44),
  ABISELECT(48,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN9S19045C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C19D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v110Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v111Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v112Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v113Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C129S19045C19__9S19045C18[] = {
  ABISELECT(104,64),
  ABISELECT(80,44),
  ABISELECT(48,20),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C129S19045C19__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C129S19045C19__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZThn80_N9S19045C12D1Ev,_ZThn44_N9S19045C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void ABISELECT(_ZThn80_N9S19045C12D0Ev,_ZThn44_N9S19045C12D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C129S19045C19__9S19045C18[] = {
  0,
  0,
  ABISELECT(-80,-44),
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C129S19045C19__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C19__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C19__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C19D1Ev,_ZTv0_n20_N9S19045C19D1Ev)();
extern void ABISELECT(_ZThn80_N9S19045C19D1Ev,_ZThn44_N9S19045C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C19D0Ev,_ZTv0_n20_N9S19045C19D0Ev)();
extern void ABISELECT(_ZThn80_N9S19045C19D0Ev,_ZThn44_N9S19045C19D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C19__9S19045C18[] = {
  0,
  0,
  ABISELECT(-80,-44),
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C19D1Ev,_ZTv0_n20_N9S19045C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C19D0Ev,_ZTv0_n20_N9S19045C19D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C19__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C18[] = {
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C18[] = {
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,24),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-20),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C10__9S19045C18[] = {
  ABISELECT(-112,-68),
  ABISELECT(-24,-12),
  ABISELECT(-80,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C10__A1__9S19045C18[] = {
  ABISELECT(-24,-12),
  ABISELECT(-80,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C10__A1__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,56),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C10__A1__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C10__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,56),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C10__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C10__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(112,68),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void _ZN9S19045C17D1Ev();
extern void _ZN9S19045C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C17__9S19045C18[] = {
  ABISELECT(-120,-76),
  ABISELECT(-144,-96),
  ABISELECT(-176,-120),
  ABISELECT(-208,-132),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&_ZN9S19045C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C17D0Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C129S19045C17__A1__9S19045C18[] = {
  ABISELECT(-152,-100),
  ABISELECT(-176,-120),
  ABISELECT(-208,-144),
  ABISELECT(-240,-156),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C129S19045C17__A1__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(240,156),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C129S19045C17__A1__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(208,144),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C129S19045C17__A1__9S19045C18[] = {
  0,
  0,
  ABISELECT(176,120),
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  ABISELECT(176,120),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C129S19045C17__A1__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(152,100),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void ABISELECT(_ZThn32_N9S19045C17D1Ev,_ZThn24_N9S19045C17D1Ev)();
extern void ABISELECT(_ZThn32_N9S19045C17D0Ev,_ZThn24_N9S19045C17D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__9S19045C17__9S19045C18[] = {
  ABISELECT(-152,-100),
  ABISELECT(-176,-120),
  ABISELECT(-208,-144),
  ABISELECT(-240,-156),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19045C17D1Ev,_ZThn24_N9S19045C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19045C17D0Ev,_ZThn24_N9S19045C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C17__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  ABISELECT(208,132),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__A1__9S19045C17__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(176,120),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C17__9S19045C18[] = {
  0,
  0,
  ABISELECT(144,96),
  ABISELECT(24,20),
  ABISELECT(-32,-24),
  ABISELECT(144,96),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C17__9S19045C18[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(120,76),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
static  VTT_ENTRY vtt_S19045C18[] = {
  {&(_ZTV9S19045C18[9]),  9,217},
  {&(_ZTV9S19045C18[34]),  34,217},
  {&(_ZTV9S19045C18[56]),  56,217},
  {&(_ZTV9S19045C18[72]),  72,217},
  {&(_ZTV9S19045C18[86]),  86,217},
  {&(_ZTV9S19045C18[99]),  99,217},
  {&(_ZTV9S19045C18[136]),  136,217},
  {&(_ZTV9S19045C18[150]),  150,217},
  {&(_ZTV9S19045C18[159]),  159,217},
  {&(_ZTV9S19045C18[190]),  190,217},
  {&(_ZTV9S19045C18[209]),  209,217},
  {&(_tg__ZTV9S19045C19__9S19045C18[6]),  6,18},
  {&(_tg__ZTV9S19045C129S19045C19__9S19045C18[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C129S19045C19__9S19045C18[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C129S19045C19__9S19045C18[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C129S19045C19__9S19045C18[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C129S19045C19__9S19045C18[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C19__9S19045C18[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C19__9S19045C18[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C19__9S19045C18[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C19__9S19045C18[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C18[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__9S19045C18[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C18[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__9S19045C18[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__9S19045C18[9]),  9,16},
  {&(_tg__ZTV9S19045C10__9S19045C18[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C10__A1__9S19045C18[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C10__A1__9S19045C18[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C10__A1__9S19045C18[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C10__9S19045C18[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C10__9S19045C18[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C10__9S19045C18[10]),  10,17},
  {&(_tg__ZTV9S19045C17__9S19045C18[6]),  6,19},
  {&(_tg__ZTV9S19045C129S19045C17__A1__9S19045C18[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C129S19045C17__A1__9S19045C18[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C129S19045C17__A1__9S19045C18[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C129S19045C17__A1__9S19045C18[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C129S19045C17__A1__9S19045C18[9]),  9,16},
  {&(_tg__ZTV9S19045C12__9S19045C17__9S19045C18[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C17__9S19045C18[10]),  10,17},
  {&(_tg__ZTV8S19045C8__A1__9S19045C17__9S19045C18[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C17__9S19045C18[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C17__9S19045C18[9]),  9,16},
};
extern VTBL_ENTRY _ZTI9S19045C18[];
extern  VTBL_ENTRY _ZTV9S19045C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C18[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C19D0Ev,_ZTv0_n20_N9S19045C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19045C19D0Ev,_ZThn44_N9S19045C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C19D1Ev,_ZTv0_n20_N9S19045C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19045C19D1Ev,_ZThn44_N9S19045C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19045C12D0Ev,_ZThn44_N9S19045C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S19045C12D1Ev,_ZThn44_N9S19045C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C18D0Ev,_ZTv0_n72_N9S19045C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N9S19045C18D0Ev,_ZThn148_N9S19045C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C18D1Ev,_ZTv0_n72_N9S19045C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N9S19045C18D1Ev,_ZThn148_N9S19045C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19045C18D0Ev,_ZTv0_n24_N9S19045C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N9S19045C18D0Ev,_ZThn84_N9S19045C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19045C18D1Ev,_ZTv0_n24_N9S19045C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N9S19045C18D1Ev,_ZThn84_N9S19045C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C18D0Ev,_ZTv0_n20_N9S19045C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S19045C18D0Ev,_ZThn52_N9S19045C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C18D1Ev,_ZTv0_n20_N9S19045C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S19045C18D1Ev,_ZThn52_N9S19045C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19045C18D0Ev,_ZTv0_n28_N9S19045C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19045C18D0Ev,_ZThn8_N9S19045C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19045C18D1Ev,_ZTv0_n28_N9S19045C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S19045C18D1Ev,_ZThn8_N9S19045C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19045C18 = {  "S19045C18", // class name
  bases_S19045C18, 13,
  &(vtc_S19045C18[0]), // expected_vtbl_contents
  &(vtt_S19045C18[0]), // expected_vtt_contents
  ABISELECT(384,240), // object size
  NSPAIRA(_ZTI9S19045C18),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19045C18),217, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19045C18),44, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19045C1  : virtual S19045C2 , S19045C15 , S19045C11 , S19045C5 , S19045C18 {
  ::S19045C3 s19045c1f0[3];
  ::S19045C11 s19045c1f1;
  void *s19045c1f2;
  virtual void  v1(); // _ZN8S19045C12v1Ev
  virtual void  v2(); // _ZN8S19045C12v2Ev
  virtual void  v3(); // _ZN8S19045C12v3Ev
  virtual void  v4(); // _ZN8S19045C12v4Ev
  virtual void  v5(); // _ZN8S19045C12v5Ev
  virtual void  v6(); // _ZN8S19045C12v6Ev
  virtual void  v7(); // _ZN8S19045C12v7Ev
  virtual void  v8(); // _ZN8S19045C12v8Ev
  virtual void  v9(); // _ZN8S19045C12v9Ev
  ~S19045C1(); // tgen
  S19045C1(); // tgen
};
//SIG(1 S19045C1) C1{ VBC2{ BC3{ BC4{ v10 v11 v12 v13 v14 v15 v16 Fp Fs:16} v17 v18 v19 v20 v21 v22 v23 Fs} BC5{ VBC6{ VBC4 BC7{ VBC8{ v24 v25 v26 v27 v28 v29 v30 FL FD} v31 v32 v33 v34 v35 v36 v37 Fp Fi} vd v38 v39 v40 v41 v42} BC9{ BC8 VBC4 BC10{ BC11{ VBC8 VBC4 vd v43 v44 Fi[4]} BC8 BC4 VBC7 vd v45 v46 v47 v48 v49 v50 v51 v52 FL} BC12{ VBC7 VBC11 vd v53 v54 v55 v56 v57 v58 Fi} BC7 v59 v60 v61 v62 v63 v64 v65 v66 v67} vd v68 v69 v70 v71 v72 v73 v74 v75} VBC13{ VBC4 VBC7 BC10 BC8 v76 v77 v78 v79} BC14{ v80 v81 v82 v83 v84 v85 v86 Fi[2]} vd v87 v88 v89 v90 v91 v92 v93 v94 FC3 FD} BC15{ VBC3 BC16{ VBC3 VBC11 VBC17{ BC8 BC12 v95 v96 v97 v98 Fi FC11} BC10 v99 v100 v101 v102 v103 v104} VBC13 vd v105 v106 v107 v108 v109} BC11 BC5 BC18{ VBC19{ BC12 vd v110 v111 v112 v113} VBC10 VBC17 vd v114 v115 v116 v117 v118 v119 Fp} v1 v2 v3 v4 v5 v6 v7 v8 v9 FC3[3] FC11 Fp}


void  S19045C1 ::v1(){vfunc_called(this, "_ZN8S19045C12v1Ev");}
void  S19045C1 ::v2(){vfunc_called(this, "_ZN8S19045C12v2Ev");}
void  S19045C1 ::v3(){vfunc_called(this, "_ZN8S19045C12v3Ev");}
void  S19045C1 ::v4(){vfunc_called(this, "_ZN8S19045C12v4Ev");}
void  S19045C1 ::v5(){vfunc_called(this, "_ZN8S19045C12v5Ev");}
void  S19045C1 ::v6(){vfunc_called(this, "_ZN8S19045C12v6Ev");}
void  S19045C1 ::v7(){vfunc_called(this, "_ZN8S19045C12v7Ev");}
void  S19045C1 ::v8(){vfunc_called(this, "_ZN8S19045C12v8Ev");}
void  S19045C1 ::v9(){vfunc_called(this, "_ZN8S19045C12v9Ev");}
S19045C1 ::~S19045C1(){ note_dtor("S19045C1", this);} // tgen
S19045C1 ::S19045C1(){ note_ctor("S19045C1", this);} // tgen

static void Test_S19045C1()
{
  extern Class_Descriptor cd_S19045C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(82,200)];
    init_test(&cd_S19045C1, buf);
    S19045C1 *dp, &lv = *(dp=new (buf) S19045C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1296,796), "sizeof(S19045C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19045C1)");
    check_base_class_offset(lv, (S19045C4*)(S19045C3*)(S19045C2*), ABISELECT(496,296), "S19045C1");
    check_base_class_offset(lv, (S19045C3*)(S19045C2*), ABISELECT(496,296), "S19045C1");
    check_base_class_offset(lv, (S19045C4*)(S19045C6*), ABISELECT(776,464), "S19045C1");
    /*is_ambiguous_... S19045C9::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(776,464), "S19045C1");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(776,464), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(776,464), "S19045C1");
    /*is_ambiguous_... S19045C13::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C13*), ABISELECT(776,464), "S19045C1");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*)(S19045C13*), ABISELECT(776,464), "S19045C1");
    check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*)(S19045C16*)(S19045C15*), ABISELECT(776,464), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C11*), ABISELECT(776,464), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C9*)(S19045C5*), ABISELECT(776,464), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(776,464), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C10 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C11*)(S19045C10*), ABISELECT(776,464), "S19045C1");
    check_base_class_offset(lv, (S19045C8*)(S19045C7*)(S19045C6*), ABISELECT(800,476), "S19045C1");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(800,476), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C7*), ABISELECT(800,476), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(800,476), "S19045C1");
    /*is_ambiguous_... S19045C9::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C7*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(800,476), "S19045C1");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*)(S19045C13*), ABISELECT(800,476), "S19045C1");
    check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*)(S19045C16*)(S19045C15*), ABISELECT(800,476), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C11*), ABISELECT(800,476), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(800,476), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C7*)(S19045C9*)(S19045C5*), ABISELECT(800,476), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C10 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C11*)(S19045C10*), ABISELECT(800,476), "S19045C1");
    check_base_class_offset(lv, (S19045C7*)(S19045C6*), ABISELECT(752,452), "S19045C1");
    check_base_class_offset(lv, (S19045C6*)(S19045C5*)(S19045C2*), ABISELECT(752,452), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C6*)(S19045C5*), ABISELECT(752,452), "S19045C1");
    /*is_ambiguous_... S19045C9::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(528,308), "S19045C1");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(560,332), "S19045C1");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(592,352), "S19045C1");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(624,376), "S19045C1");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(832,500), "S19045C1");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(832,500), "S19045C1");
    check_base_class_offset(lv, (S19045C7*)(S19045C13*), ABISELECT(832,500), "S19045C1");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*)(S19045C13*), ABISELECT(832,500), "S19045C1");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*)(S19045C17*), ABISELECT(832,500), "S19045C1");
    check_base_class_offset(lv, (S19045C7*)(S19045C10*)(S19045C16*)(S19045C15*), ABISELECT(832,500), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C7*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(832,500), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C7*)(S19045C12*)(S19045C9*)(S19045C5*), ABISELECT(832,500), "S19045C1");
    check_base_class_offset(lv, (S19045C7*)(S19045C12*)(S19045C19*), ABISELECT(832,500), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C10 */ AMB_check_base_class_offset(lv, (S19045C7*)(S19045C10*), ABISELECT(832,500), "S19045C1");
    check_base_class_offset(lv, (S19045C10*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(560,332), "S19045C1");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(856,512), "S19045C1");
    /*is_ambiguous_... S19045C16::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C11*)(S19045C16*)(S19045C15*), ABISELECT(856,512), "S19045C1");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*)(S19045C17*), ABISELECT(856,512), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C11*)(S19045C12*)(S19045C9*)(S19045C5*), ABISELECT(856,512), "S19045C1");
    check_base_class_offset(lv, (S19045C11*)(S19045C12*)(S19045C19*), ABISELECT(856,512), "S19045C1");
    check_base_class_offset(lv, (S19045C12*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(656,396), "S19045C1");
    /*is_ambiguous_... S19045C9::S19045C7 */ AMB_check_base_class_offset(lv, (S19045C7*)(S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(672,404), "S19045C1");
    check_base_class_offset(lv, (S19045C9*)(S19045C5*)(S19045C2*), ABISELECT(528,308), "S19045C1");
    check_base_class_offset(lv, (S19045C5*)(S19045C2*), ABISELECT(528,308), "S19045C1");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*)(S19045C13*), ABISELECT(880,532), "S19045C1");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*)(S19045C13*), ABISELECT(912,552), "S19045C1");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*)(S19045C13*), ABISELECT(944,576), "S19045C1");
    check_base_class_offset(lv, (S19045C10*)(S19045C13*), ABISELECT(880,532), "S19045C1");
    /*is_ambiguous_... S19045C13::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C13*), ABISELECT(976,596), "S19045C1");
    check_base_class_offset(lv, (S19045C13*)(S19045C2*), ABISELECT(880,532), "S19045C1");
    check_base_class_offset(lv, (S19045C13*)(S19045C15*), ABISELECT(880,532), "S19045C1");
    check_base_class_offset(lv, (S19045C14*)(S19045C2*), ABISELECT(696,416), "S19045C1");
    check_base_class_offset(lv, (S19045C2*), ABISELECT(496,296), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C3 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C3*), ABISELECT(1008,620), "S19045C1");
    check_base_class_offset(lv, (S19045C3*)(S19045C15*), ABISELECT(1008,620), "S19045C1");
    check_base_class_offset(lv, (S19045C3*)(S19045C16*)(S19045C15*), ABISELECT(1008,620), "S19045C1");
    /*is_ambiguous_... S19045C17::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C17*), ABISELECT(1040,632), "S19045C1");
    check_base_class_offset(lv, (S19045C12*)(S19045C17*), ABISELECT(1072,656), "S19045C1");
    check_base_class_offset(lv, (S19045C17*)(S19045C16*)(S19045C15*), ABISELECT(1040,632), "S19045C1");
    check_base_class_offset(lv, (S19045C17*)(S19045C18*), ABISELECT(1040,632), "S19045C1");
    check_base_class_offset(lv, (S19045C11*)(S19045C10*)(S19045C16*)(S19045C15*), 0, "S19045C1");
    /*is_ambiguous_... S19045C10::S19045C8 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*)(S19045C16*)(S19045C15*), ABISELECT(32,20), "S19045C1");
    /*is_ambiguous_... S19045C10::S19045C4 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*)(S19045C16*)(S19045C15*), ABISELECT(64,44), "S19045C1");
    check_base_class_offset(lv, (S19045C10*)(S19045C16*)(S19045C15*), 0, "S19045C1");
    check_base_class_offset(lv, (S19045C16*)(S19045C15*), 0, "S19045C1");
    check_base_class_offset(lv, (S19045C15*), 0, "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C11 */ AMB_check_base_class_offset(lv, (S19045C11*), ABISELECT(96,64), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C9*)(S19045C5*), ABISELECT(128,84), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C11*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(160,108), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(192,128), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(224,152), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C10*)(S19045C9*)(S19045C5*), ABISELECT(160,108), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C12*)(S19045C9*)(S19045C5*), ABISELECT(256,172), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C7*)(S19045C9*)(S19045C5*), ABISELECT(272,180), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C9*)(S19045C5*), ABISELECT(128,84), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C5 */ AMB_check_base_class_offset(lv, (S19045C5*), ABISELECT(128,84), "S19045C1");
    check_base_class_offset(lv, (S19045C12*)(S19045C19*), ABISELECT(1184,724), "S19045C1");
    check_base_class_offset(lv, (S19045C19*)(S19045C18*), ABISELECT(1184,724), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C10 */ AMB_check_base_class_offset(lv, (S19045C11*)(S19045C10*), ABISELECT(1200,732), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C10 */ AMB_check_base_class_offset(lv, (S19045C8*)(S19045C10*), ABISELECT(1232,752), "S19045C1");
    /*is_ambiguous_... S19045C1::S19045C10 */ AMB_check_base_class_offset(lv, (S19045C4*)(S19045C10*), ABISELECT(1264,776), "S19045C1");
    check_base_class_offset(lv, (S19045C10*)(S19045C18*), ABISELECT(1200,732), "S19045C1");
    check_base_class_offset(lv, (S19045C18*), ABISELECT(296,192), "S19045C1");
    check_field_offset(lv, s19045c1f0, ABISELECT(312,200), "S19045C1.s19045c1f0");
    check_field_offset(lv, s19045c1f1, ABISELECT(384,236), "S19045C1.s19045c1f1");
    check_field_offset(lv, s19045c1f2, ABISELECT(480,292), "S19045C1.s19045c1f2");
    test_class_info(&lv, &cd_S19045C1);
    dp->~S19045C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19045C1(Test_S19045C1, "S19045C1", ABISELECT(1296,796));

#else // __cplusplus

extern void _ZN8S19045C1C1Ev();
extern void _ZN8S19045C1D1Ev();
Name_Map name_map_S19045C1[] = {
  NSPAIR(_ZN8S19045C1C1Ev),
  NSPAIR(_ZN8S19045C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C3;
extern VTBL_ENTRY _ZTI8S19045C3[];
extern  VTBL_ENTRY _ZTV8S19045C3[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C6;
extern VTBL_ENTRY _ZTI8S19045C6[];
extern  VTBL_ENTRY _ZTV8S19045C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C6[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C9;
extern VTBL_ENTRY _ZTI8S19045C9[];
extern  VTBL_ENTRY _ZTV8S19045C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C9[];
extern Class_Descriptor cd_S19045C5;
extern VTBL_ENTRY _ZTI8S19045C5[];
extern  VTBL_ENTRY _ZTV8S19045C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C5[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C13;
extern VTBL_ENTRY _ZTI9S19045C13[];
extern  VTBL_ENTRY _ZTV9S19045C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C13[];
extern Class_Descriptor cd_S19045C14;
extern VTBL_ENTRY _ZTI9S19045C14[];
extern  VTBL_ENTRY _ZTV9S19045C14[];
extern Class_Descriptor cd_S19045C2;
extern VTBL_ENTRY _ZTI8S19045C2[];
extern  VTBL_ENTRY _ZTV8S19045C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C2[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C3;
extern VTBL_ENTRY _ZTI8S19045C3[];
extern  VTBL_ENTRY _ZTV8S19045C3[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C17;
extern VTBL_ENTRY _ZTI9S19045C17[];
extern  VTBL_ENTRY _ZTV9S19045C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C17[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C16;
extern VTBL_ENTRY _ZTI9S19045C16[];
extern  VTBL_ENTRY _ZTV9S19045C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C16[];
extern Class_Descriptor cd_S19045C15;
extern VTBL_ENTRY _ZTI9S19045C15[];
extern  VTBL_ENTRY _ZTV9S19045C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C15[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C7;
extern VTBL_ENTRY _ZTI8S19045C7[];
extern  VTBL_ENTRY _ZTV8S19045C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C7[];
extern Class_Descriptor cd_S19045C9;
extern VTBL_ENTRY _ZTI8S19045C9[];
extern  VTBL_ENTRY _ZTV8S19045C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C9[];
extern Class_Descriptor cd_S19045C5;
extern VTBL_ENTRY _ZTI8S19045C5[];
extern  VTBL_ENTRY _ZTV8S19045C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C5[];
extern Class_Descriptor cd_S19045C12;
extern VTBL_ENTRY _ZTI9S19045C12[];
extern  VTBL_ENTRY _ZTV9S19045C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C12[];
extern Class_Descriptor cd_S19045C19;
extern VTBL_ENTRY _ZTI9S19045C19[];
extern  VTBL_ENTRY _ZTV9S19045C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C19[];
extern Class_Descriptor cd_S19045C11;
extern VTBL_ENTRY _ZTI9S19045C11[];
extern  VTBL_ENTRY _ZTV9S19045C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C11[];
extern Class_Descriptor cd_S19045C8;
extern VTBL_ENTRY _ZTI8S19045C8[];
extern  VTBL_ENTRY _ZTV8S19045C8[];
extern Class_Descriptor cd_S19045C4;
extern VTBL_ENTRY _ZTI8S19045C4[];
extern  VTBL_ENTRY _ZTV8S19045C4[];
extern Class_Descriptor cd_S19045C10;
extern VTBL_ENTRY _ZTI9S19045C10[];
extern  VTBL_ENTRY _ZTV9S19045C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C10[];
extern Class_Descriptor cd_S19045C18;
extern VTBL_ENTRY _ZTI9S19045C18[];
extern  VTBL_ENTRY _ZTV9S19045C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19045C18[];
static Base_Class bases_S19045C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19045C4,    ABISELECT(496,296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S19045C3,    ABISELECT(496,296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(776,464), //bcp->offset
    421, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    77, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S19045C8,    ABISELECT(800,476), //bcp->offset
    437, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    78, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S19045C7,    ABISELECT(752,452), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    150, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19045C6,    ABISELECT(752,452), //bcp->offset
    390, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    76, //bcp->index_in_construction_vtbl_array
    149, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S19045C8,    ABISELECT(528,308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19045C11,    ABISELECT(560,332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    108, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(592,352), //bcp->offset
    339, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    80, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(624,376), //bcp->offset
    348, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    81, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19045C7,    ABISELECT(832,500), //bcp->offset
    453, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    82, //bcp->index_in_construction_vtbl_array
    154, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19045C10,    ABISELECT(560,332), //bcp->offset
    322, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    79, //bcp->index_in_construction_vtbl_array
    107, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19045C11,    ABISELECT(856,512), //bcp->offset
    470, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    84, //bcp->index_in_construction_vtbl_array
    156, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S19045C12,    ABISELECT(656,396), //bcp->offset
    357, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    83, //bcp->index_in_construction_vtbl_array
    114, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19045C7,    ABISELECT(672,404), //bcp->offset
    371, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    85, //bcp->index_in_construction_vtbl_array
    119, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19045C9,    ABISELECT(528,308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    106, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19045C5,    ABISELECT(528,308), //bcp->offset
    289, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    75, //bcp->index_in_construction_vtbl_array
    105, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19045C11,    ABISELECT(880,532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    161, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(912,552), //bcp->offset
    531, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    87, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(944,576), //bcp->offset
    540, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    88, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19045C10,    ABISELECT(880,532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    160, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(976,596), //bcp->offset
    549, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    89, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19045C13,    ABISELECT(880,532), //bcp->offset
    481, //bcp->virtual_function_table_offset
    34, //num_negative_vtable_entries(t, bcp)
    86, //bcp->index_in_construction_vtbl_array
    159, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S19045C14,    ABISELECT(696,416), //bcp->offset
    381, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    90, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19045C2,    ABISELECT(496,296), //bcp->offset
    180, //bcp->virtual_function_table_offset
    85, //num_negative_vtable_entries(t, bcp)
    74, //bcp->index_in_construction_vtbl_array
    104, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19045C4,    ABISELECT(1008,620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S19045C3,    ABISELECT(1008,620), //bcp->offset
    558, //bcp->virtual_function_table_offset
    16, //num_negative_vtable_entries(t, bcp)
    91, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S19045C8,    ABISELECT(1040,632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19045C12,    ABISELECT(1072,656), //bcp->offset
    625, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    93, //bcp->index_in_construction_vtbl_array
    171, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19045C17,    ABISELECT(1040,632), //bcp->offset
    588, //bcp->virtual_function_table_offset
    24, //num_negative_vtable_entries(t, bcp)
    92, //bcp->index_in_construction_vtbl_array
    170, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S19045C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(32,20), //bcp->offset
    45, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(64,44), //bcp->offset
    54, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19045C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19045C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19045C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C11,    ABISELECT(96,64), //bcp->offset
    63, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    94, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C8,    ABISELECT(128,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19045C11,    ABISELECT(160,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(192,128), //bcp->offset
    121, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(224,152), //bcp->offset
    130, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S19045C10,    ABISELECT(160,108), //bcp->offset
    104, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    96, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19045C12,    ABISELECT(256,172), //bcp->offset
    139, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    97, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19045C7,    ABISELECT(272,180), //bcp->offset
    153, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    98, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    50, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19045C9,    ABISELECT(128,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    51, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S19045C5,    ABISELECT(128,84), //bcp->offset
    71, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    95, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    52, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19045C12,    ABISELECT(1184,724), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    182, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S19045C19,    ABISELECT(1184,724), //bcp->offset
    639, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    100, //bcp->index_in_construction_vtbl_array
    181, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    52, //immediately_derived
  0, 1},
  {&cd_S19045C11,    ABISELECT(1200,732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    192, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S19045C8,    ABISELECT(1232,752), //bcp->offset
    710, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    102, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S19045C4,    ABISELECT(1264,776), //bcp->offset
    719, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    103, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S19045C10,    ABISELECT(1200,732), //bcp->offset
    668, //bcp->virtual_function_table_offset
    30, //num_negative_vtable_entries(t, bcp)
    101, //bcp->index_in_construction_vtbl_array
    191, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    52, //immediately_derived
  0, 1},
  {&cd_S19045C18,    ABISELECT(296,192), //bcp->offset
    163, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    99, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    53, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19045C1[];
extern void _ZN8S19045C1D1Ev();
extern void _ZN8S19045C1D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C163v99Ev();
extern void _ZN9S19045C164v100Ev();
extern void _ZN9S19045C164v101Ev();
extern void _ZN9S19045C164v102Ev();
extern void _ZN9S19045C164v103Ev();
extern void _ZN9S19045C164v104Ev();
extern void _ZN9S19045C154v105Ev();
extern void _ZN9S19045C154v106Ev();
extern void _ZN9S19045C154v107Ev();
extern void _ZN9S19045C154v108Ev();
extern void _ZN9S19045C154v109Ev();
extern void _ZN8S19045C12v1Ev();
extern void _ZN8S19045C12v2Ev();
extern void _ZN8S19045C12v3Ev();
extern void _ZN8S19045C12v4Ev();
extern void _ZN8S19045C12v5Ev();
extern void _ZN8S19045C12v6Ev();
extern void _ZN8S19045C12v7Ev();
extern void _ZN8S19045C12v8Ev();
extern void _ZN8S19045C12v9Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void ABISELECT(_ZThn96_N8S19045C1D1Ev,_ZThn64_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn96_N8S19045C1D0Ev,_ZThn64_N8S19045C1D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void ABISELECT(_ZThn128_N8S19045C1D1Ev,_ZThn84_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn128_N8S19045C1D0Ev,_ZThn84_N8S19045C1D0Ev)();
extern void _ZN8S19045C53v68Ev();
extern void _ZN8S19045C53v69Ev();
extern void _ZN8S19045C53v70Ev();
extern void _ZN8S19045C53v71Ev();
extern void _ZN8S19045C53v72Ev();
extern void _ZN8S19045C53v73Ev();
extern void _ZN8S19045C53v74Ev();
extern void _ZN8S19045C53v75Ev();
extern void ABISELECT(_ZThn160_N8S19045C1D1Ev,_ZThn108_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn160_N8S19045C1D0Ev,_ZThn108_N8S19045C1D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void ABISELECT(_ZThn256_N8S19045C1D1Ev,_ZThn172_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn256_N8S19045C1D0Ev,_ZThn172_N8S19045C1D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZThn296_N8S19045C1D1Ev,_ZThn192_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn296_N8S19045C1D0Ev,_ZThn192_N8S19045C1D0Ev)();
extern void _ZN9S19045C184v114Ev();
extern void _ZN9S19045C184v115Ev();
extern void _ZN9S19045C184v116Ev();
extern void _ZN9S19045C184v117Ev();
extern void _ZN9S19045C184v118Ev();
extern void _ZN9S19045C184v119Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C33v17Ev();
extern void _ZN8S19045C33v18Ev();
extern void _ZN8S19045C33v19Ev();
extern void _ZN8S19045C33v20Ev();
extern void _ZN8S19045C33v21Ev();
extern void _ZN8S19045C33v22Ev();
extern void _ZN8S19045C33v23Ev();
extern void ABISELECT(_ZTv0_n184_N8S19045C1D1Ev,_ZTv0_n92_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn496_N8S19045C1D1Ev,_ZThn296_N8S19045C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n184_N8S19045C1D0Ev,_ZTv0_n92_N8S19045C1D0Ev)();
extern void ABISELECT(_ZThn496_N8S19045C1D0Ev,_ZThn296_N8S19045C1D0Ev)() __attribute__((weak));
extern void _ZN8S19045C23v87Ev();
extern void _ZN8S19045C23v88Ev();
extern void _ZN8S19045C23v89Ev();
extern void _ZN8S19045C23v90Ev();
extern void _ZN8S19045C23v91Ev();
extern void _ZN8S19045C23v92Ev();
extern void _ZN8S19045C23v93Ev();
extern void _ZN8S19045C23v94Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void ABISELECT(_ZTvn32_n184_N8S19045C1D1Ev,_ZTvn12_n92_N8S19045C1D1Ev)();
extern void ABISELECT(_ZTvn32_n184_N8S19045C1D0Ev,_ZTvn12_n92_N8S19045C1D0Ev)();
extern void _ZN8S19045C53v68Ev();
extern void _ZN8S19045C53v69Ev();
extern void _ZN8S19045C53v70Ev();
extern void _ZN8S19045C53v71Ev();
extern void _ZN8S19045C53v72Ev();
extern void _ZN8S19045C53v73Ev();
extern void _ZN8S19045C53v74Ev();
extern void _ZN8S19045C53v75Ev();
extern void ABISELECT(_ZTvn64_n184_N8S19045C1D1Ev,_ZTvn36_n92_N8S19045C1D1Ev)();
extern void ABISELECT(_ZTvn64_n184_N8S19045C1D0Ev,_ZTvn36_n92_N8S19045C1D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void ABISELECT(_ZTvn160_n184_N8S19045C1D1Ev,_ZTvn100_n92_N8S19045C1D1Ev)();
extern void ABISELECT(_ZTvn160_n184_N8S19045C1D0Ev,_ZTvn100_n92_N8S19045C1D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN9S19045C143v80Ev();
extern void _ZN9S19045C143v81Ev();
extern void _ZN9S19045C143v82Ev();
extern void _ZN9S19045C143v83Ev();
extern void _ZN9S19045C143v84Ev();
extern void _ZN9S19045C143v85Ev();
extern void _ZN9S19045C143v86Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n96_N8S19045C1D1Ev,_ZTv0_n48_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn752_N8S19045C1D1Ev,_ZThn452_N8S19045C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S19045C1D0Ev,_ZTv0_n48_N8S19045C1D0Ev)();
extern void ABISELECT(_ZThn752_N8S19045C1D0Ev,_ZThn452_N8S19045C1D0Ev)() __attribute__((weak));
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n40_N8S19045C1D1Ev,_ZTv0_n20_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn856_N8S19045C1D1Ev,_ZThn512_N8S19045C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C1D0Ev,_ZTv0_n20_N8S19045C1D0Ev)();
extern void ABISELECT(_ZThn856_N8S19045C1D0Ev,_ZThn512_N8S19045C1D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void ABISELECT(_ZTv0_n48_N8S19045C1D1Ev,_ZTv0_n24_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn880_N8S19045C1D1Ev,_ZThn532_N8S19045C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19045C1D0Ev,_ZTv0_n24_N8S19045C1D0Ev)();
extern void ABISELECT(_ZThn880_N8S19045C1D0Ev,_ZThn532_N8S19045C1D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C133v76Ev();
extern void _ZN9S19045C133v77Ev();
extern void _ZN9S19045C133v78Ev();
extern void _ZN9S19045C133v79Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C33v17Ev();
extern void _ZN8S19045C33v18Ev();
extern void _ZN8S19045C33v19Ev();
extern void _ZN8S19045C33v20Ev();
extern void _ZN8S19045C33v21Ev();
extern void _ZN8S19045C33v22Ev();
extern void _ZN8S19045C33v23Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void ABISELECT(_ZTv0_n144_N8S19045C1D1Ev,_ZTv0_n72_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn1040_N8S19045C1D1Ev,_ZThn632_N8S19045C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n144_N8S19045C1D0Ev,_ZTv0_n72_N8S19045C1D0Ev)();
extern void ABISELECT(_ZThn1040_N8S19045C1D0Ev,_ZThn632_N8S19045C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn32_n144_N8S19045C1D1Ev,_ZTvn24_n72_N8S19045C1D1Ev)();
extern void ABISELECT(_ZTvn32_n144_N8S19045C1D0Ev,_ZTvn24_n72_N8S19045C1D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void ABISELECT(_ZTv0_n56_N8S19045C1D1Ev,_ZTv0_n28_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn1184_N8S19045C1D1Ev,_ZThn724_N8S19045C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S19045C1D0Ev,_ZTv0_n28_N8S19045C1D0Ev)();
extern void ABISELECT(_ZThn1184_N8S19045C1D0Ev,_ZThn724_N8S19045C1D0Ev)() __attribute__((weak));
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN9S19045C194v110Ev();
extern void _ZN9S19045C194v111Ev();
extern void _ZN9S19045C194v112Ev();
extern void _ZN9S19045C194v113Ev();
extern void ABISELECT(_ZTv0_n48_N8S19045C1D1Ev,_ZTv0_n24_N8S19045C1D1Ev)();
extern void ABISELECT(_ZThn1200_N8S19045C1D1Ev,_ZThn732_N8S19045C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19045C1D0Ev,_ZTv0_n24_N8S19045C1D0Ev)();
extern void ABISELECT(_ZThn1200_N8S19045C1D0Ev,_ZThn732_N8S19045C1D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY vtc_S19045C1[] = {
  ABISELECT(1200,732),
  ABISELECT(1184,724),
  ABISELECT(752,452),
  ABISELECT(496,296),
  ABISELECT(880,532),
  ABISELECT(1040,632),
  ABISELECT(856,512),
  ABISELECT(1008,620),
  ABISELECT(832,500),
  ABISELECT(776,464),
  ABISELECT(800,476),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C1D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C1D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C163v99Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v100Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v101Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v102Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v103Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v104Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v105Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v106Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v107Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v108Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v109Ev,
  (VTBL_ENTRY)&_ZN8S19045C12v1Ev,
  (VTBL_ENTRY)&_ZN8S19045C12v2Ev,
  (VTBL_ENTRY)&_ZN8S19045C12v3Ev,
  (VTBL_ENTRY)&_ZN8S19045C12v4Ev,
  (VTBL_ENTRY)&_ZN8S19045C12v5Ev,
  (VTBL_ENTRY)&_ZN8S19045C12v6Ev,
  (VTBL_ENTRY)&_ZN8S19045C12v7Ev,
  (VTBL_ENTRY)&_ZN8S19045C12v8Ev,
  (VTBL_ENTRY)&_ZN8S19045C12v9Ev,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-64,-44),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(680,400),
  ABISELECT(704,412),
  ABISELECT(-96,-64),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S19045C1D1Ev,_ZThn64_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S19045C1D0Ev,_ZThn64_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  ABISELECT(624,368),
  ABISELECT(728,428),
  ABISELECT(704,416),
  ABISELECT(672,392),
  ABISELECT(648,380),
  ABISELECT(-128,-84),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C1D1Ev,_ZThn84_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C1D0Ev,_ZThn84_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C53v68Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v69Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v70Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v71Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v72Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v73Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v74Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v75Ev,
  ABISELECT(672,392),
  ABISELECT(616,356),
  ABISELECT(640,368),
  ABISELECT(-160,-108),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S19045C1D1Ev,_ZThn108_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S19045C1D0Ev,_ZThn108_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  ABISELECT(-192,-128),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-224,-152),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(520,292),
  ABISELECT(600,340),
  ABISELECT(544,304),
  ABISELECT(576,328),
  ABISELECT(-256,-172),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn256_N8S19045C1D1Ev,_ZThn172_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn256_N8S19045C1D0Ev,_ZThn172_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  ABISELECT(528,296),
  ABISELECT(-272,-180),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  ABISELECT(744,440),
  ABISELECT(904,540),
  ABISELECT(480,272),
  ABISELECT(560,320),
  ABISELECT(504,284),
  ABISELECT(536,308),
  ABISELECT(888,532),
  ABISELECT(-296,-192),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N8S19045C1D1Ev,_ZThn192_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn296_N8S19045C1D0Ev,_ZThn192_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C184v114Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v115Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v116Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v117Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v118Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v119Ev,
  ABISELECT(200,120),
  ABISELECT(200,120),
  ABISELECT(200,120),
  ABISELECT(200,120),
  ABISELECT(200,120),
  ABISELECT(200,120),
  ABISELECT(200,120),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(176,108),
  ABISELECT(176,108),
  ABISELECT(176,108),
  ABISELECT(176,108),
  ABISELECT(176,108),
  ABISELECT(176,108),
  ABISELECT(176,108),
  ABISELECT(160,100),
  ABISELECT(160,100),
  ABISELECT(160,100),
  ABISELECT(160,100),
  ABISELECT(160,100),
  ABISELECT(160,100),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  ABISELECT(32,12),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-496,-296),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(384,236),
  ABISELECT(360,216),
  ABISELECT(336,204),
  ABISELECT(304,180),
  ABISELECT(280,168),
  ABISELECT(256,156),
  ABISELECT(-496,-296),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v17Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v18Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v19Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v20Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v21Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v22Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v23Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n184_N8S19045C1D1Ev,_ZTv0_n92_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n184_N8S19045C1D0Ev,_ZTv0_n92_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C23v87Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v88Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v89Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v90Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v91Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v92Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v93Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v94Ev,
  ABISELECT(224,144),
  ABISELECT(328,204),
  ABISELECT(304,192),
  ABISELECT(272,168),
  ABISELECT(248,156),
  ABISELECT(-528,-308),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n184_N8S19045C1D1Ev,_ZTvn12_n92_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n184_N8S19045C1D0Ev,_ZTvn12_n92_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C53v68Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v69Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v70Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v71Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v72Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v73Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v74Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v75Ev,
  ABISELECT(272,168),
  ABISELECT(216,132),
  ABISELECT(240,144),
  ABISELECT(-560,-332),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n184_N8S19045C1D1Ev,_ZTvn36_n92_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n184_N8S19045C1D0Ev,_ZTvn36_n92_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  ABISELECT(-592,-352),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-624,-376),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(120,68),
  ABISELECT(200,116),
  ABISELECT(144,80),
  ABISELECT(176,104),
  ABISELECT(-656,-396),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n184_N8S19045C1D1Ev,_ZTvn100_n92_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n184_N8S19045C1D0Ev,_ZTvn100_n92_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  ABISELECT(128,72),
  ABISELECT(-672,-404),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  ABISELECT(-696,-416),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN9S19045C143v80Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v81Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v82Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v83Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v84Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v85Ev,
  (VTBL_ENTRY)&_ZN9S19045C143v86Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-752,-452),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  ABISELECT(48,24),
  ABISELECT(-752,-452),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C1D1Ev,_ZTv0_n48_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C1D0Ev,_ZTv0_n48_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-776,-464),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-800,-476),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-832,-500),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  0,
  0,
  ABISELECT(-856,-512),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-856,-512),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C1D1Ev,_ZTv0_n20_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C1D0Ev,_ZTv0_n20_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  0,
  0,
  0,
  0,
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-880,-532),
  ABISELECT(-48,-32),
  ABISELECT(-104,-68),
  ABISELECT(-80,-56),
  ABISELECT(-880,-532),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19045C1D1Ev,_ZTv0_n24_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19045C1D0Ev,_ZTv0_n24_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v76Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v77Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v78Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v79Ev,
  ABISELECT(-912,-552),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-944,-576),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  ABISELECT(-976,-596),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1008,-620),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v17Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v18Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v19Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v20Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v21Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v22Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v23Ev,
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(-1040,-632),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-264,-168),
  ABISELECT(-184,-120),
  ABISELECT(-240,-156),
  ABISELECT(-208,-132),
  ABISELECT(-1040,-632),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N8S19045C1D1Ev,_ZTv0_n72_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N8S19045C1D0Ev,_ZTv0_n72_N8S19045C1D0Ev),
  ABISELECT(-296,-192),
  ABISELECT(-216,-144),
  ABISELECT(-272,-180),
  ABISELECT(-240,-156),
  ABISELECT(-1072,-656),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N8S19045C1D1Ev,_ZTvn24_n72_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N8S19045C1D0Ev,_ZTvn24_n72_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1184,-724),
  ABISELECT(-408,-260),
  ABISELECT(-328,-212),
  ABISELECT(-384,-248),
  ABISELECT(-352,-224),
  ABISELECT(-1184,-724),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19045C1D1Ev,_ZTv0_n28_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S19045C1D0Ev,_ZTv0_n28_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v110Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v111Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v112Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v113Ev,
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1200,-732),
  ABISELECT(-368,-232),
  ABISELECT(-424,-268),
  ABISELECT(-400,-256),
  ABISELECT(-1200,-732),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19045C1D1Ev,_ZTv0_n24_N8S19045C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19045C1D0Ev,_ZTv0_n24_N8S19045C1D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  ABISELECT(-1232,-752),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  ABISELECT(-1264,-776),
  (VTBL_ENTRY)&(_ZTI8S19045C1[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern VTBL_ENTRY _ZTV8S19045C1[];
extern void _ZN9S19045C15D1Ev();
extern void _ZN9S19045C15D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C163v99Ev();
extern void _ZN9S19045C164v100Ev();
extern void _ZN9S19045C164v101Ev();
extern void _ZN9S19045C164v102Ev();
extern void _ZN9S19045C164v103Ev();
extern void _ZN9S19045C164v104Ev();
extern void _ZN9S19045C154v105Ev();
extern void _ZN9S19045C154v106Ev();
extern void _ZN9S19045C154v107Ev();
extern void _ZN9S19045C154v108Ev();
extern void _ZN9S19045C154v109Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C15__8S19045C1[] = {
  ABISELECT(880,532),
  ABISELECT(1040,632),
  ABISELECT(856,512),
  ABISELECT(1008,620),
  ABISELECT(832,500),
  ABISELECT(776,464),
  ABISELECT(800,476),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN9S19045C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C163v99Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v100Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v101Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v102Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v103Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v104Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v105Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v106Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v107Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v108Ev,
  (VTBL_ENTRY)&_ZN9S19045C154v109Ev,
};
extern void _ZN9S19045C16D1Ev();
extern void _ZN9S19045C16D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C163v99Ev();
extern void _ZN9S19045C164v100Ev();
extern void _ZN9S19045C164v101Ev();
extern void _ZN9S19045C164v102Ev();
extern void _ZN9S19045C164v103Ev();
extern void _ZN9S19045C164v104Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C169S19045C15__8S19045C1[] = {
  ABISELECT(1040,632),
  ABISELECT(856,512),
  ABISELECT(1008,620),
  ABISELECT(832,500),
  ABISELECT(776,464),
  ABISELECT(800,476),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN9S19045C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C16D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C163v99Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v100Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v101Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v102Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v103Ev,
  (VTBL_ENTRY)&_ZN9S19045C164v104Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C109S19045C169S19045C15__A2__8S19045C1[] = {
  ABISELECT(832,500),
  ABISELECT(776,464),
  ABISELECT(800,476),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C109S19045C169S19045C15__A3__8S19045C1[] = {
  ABISELECT(776,464),
  ABISELECT(800,476),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C109S19045C169S19045C15__A3__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-800,-476),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C109S19045C169S19045C15__A3__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-776,-464),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C109S19045C169S19045C15__A2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-800,-476),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C109S19045C169S19045C15__A2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-776,-464),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C109S19045C169S19045C15__A2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-832,-500),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C33v17Ev();
extern void _ZN8S19045C33v18Ev();
extern void _ZN8S19045C33v19Ev();
extern void _ZN8S19045C33v20Ev();
extern void _ZN8S19045C33v21Ev();
extern void _ZN8S19045C33v22Ev();
extern void _ZN8S19045C33v23Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C3__9S19045C169S19045C15__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1008,-620),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v17Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v18Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v19Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v20Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v21Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v22Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v23Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C16D1Ev,_ZTv0_n20_N9S19045C16D1Ev)();
extern void ABISELECT(_ZThn856_N9S19045C16D1Ev,_ZThn512_N9S19045C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C16D0Ev,_ZTv0_n20_N9S19045C16D0Ev)();
extern void ABISELECT(_ZThn856_N9S19045C16D0Ev,_ZThn512_N9S19045C16D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C169S19045C15__8S19045C1[] = {
  0,
  0,
  ABISELECT(-856,-512),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-856,-512),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C16D1Ev,_ZTv0_n20_N9S19045C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C16D0Ev,_ZTv0_n20_N9S19045C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C169S19045C15__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-800,-476),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__A1__9S19045C169S19045C15__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-776,-464),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void ABISELECT(_ZTv0_n144_N9S19045C16D1Ev,_ZTv0_n72_N9S19045C16D1Ev)();
extern void ABISELECT(_ZThn1040_N9S19045C16D1Ev,_ZThn632_N9S19045C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n144_N9S19045C16D0Ev,_ZTv0_n72_N9S19045C16D0Ev)();
extern void ABISELECT(_ZThn1040_N9S19045C16D0Ev,_ZThn632_N9S19045C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19045C17__9S19045C169S19045C15__8S19045C1[] = {
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(-1040,-632),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-264,-168),
  ABISELECT(-184,-120),
  ABISELECT(-240,-156),
  ABISELECT(-208,-132),
  ABISELECT(-1040,-632),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C16D1Ev,_ZTv0_n72_N9S19045C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C16D0Ev,_ZTv0_n72_N9S19045C16D0Ev),
};
extern void ABISELECT(_ZTvn32_n144_N9S19045C16D1Ev,_ZTvn24_n72_N9S19045C16D1Ev)();
extern void ABISELECT(_ZTvn32_n144_N9S19045C16D0Ev,_ZTvn24_n72_N9S19045C16D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C129S19045C17__9S19045C169S19045C15__8S19045C1[] = {
  ABISELECT(-296,-192),
  ABISELECT(-216,-144),
  ABISELECT(-272,-180),
  ABISELECT(-240,-156),
  ABISELECT(-1072,-656),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C16D1Ev,_ZTvn24_n72_N9S19045C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C16D0Ev,_ZTvn24_n72_N9S19045C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C169S19045C15__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-832,-500),
  (VTBL_ENTRY)&(_ZTI9S19045C16[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C33v17Ev();
extern void _ZN8S19045C33v18Ev();
extern void _ZN8S19045C33v19Ev();
extern void _ZN8S19045C33v20Ev();
extern void _ZN8S19045C33v21Ev();
extern void _ZN8S19045C33v22Ev();
extern void _ZN8S19045C33v23Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C3__9S19045C15__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-1008,-620),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v17Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v18Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v19Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v20Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v21Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v22Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v23Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C15D1Ev,_ZTv0_n20_N9S19045C15D1Ev)();
extern void ABISELECT(_ZThn856_N9S19045C15D1Ev,_ZThn512_N9S19045C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C15D0Ev,_ZTv0_n20_N9S19045C15D0Ev)();
extern void ABISELECT(_ZThn856_N9S19045C15D0Ev,_ZThn512_N9S19045C15D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C15__8S19045C1[] = {
  0,
  0,
  ABISELECT(-856,-512),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-856,-512),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C15D1Ev,_ZTv0_n20_N9S19045C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C15D0Ev,_ZTv0_n20_N9S19045C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C15__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-800,-476),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__A1__9S19045C15__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-776,-464),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void ABISELECT(_ZTv0_n144_N9S19045C15D1Ev,_ZTv0_n72_N9S19045C15D1Ev)();
extern void ABISELECT(_ZThn1040_N9S19045C15D1Ev,_ZThn632_N9S19045C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n144_N9S19045C15D0Ev,_ZTv0_n72_N9S19045C15D0Ev)();
extern void ABISELECT(_ZThn1040_N9S19045C15D0Ev,_ZThn632_N9S19045C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19045C17__9S19045C15__8S19045C1[] = {
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(-1040,-632),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-264,-168),
  ABISELECT(-184,-120),
  ABISELECT(-240,-156),
  ABISELECT(-208,-132),
  ABISELECT(-1040,-632),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C15D1Ev,_ZTv0_n72_N9S19045C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C15D0Ev,_ZTv0_n72_N9S19045C15D0Ev),
};
extern void ABISELECT(_ZTvn32_n144_N9S19045C15D1Ev,_ZTvn24_n72_N9S19045C15D1Ev)();
extern void ABISELECT(_ZTvn32_n144_N9S19045C15D0Ev,_ZTvn24_n72_N9S19045C15D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C129S19045C17__9S19045C15__8S19045C1[] = {
  ABISELECT(-296,-192),
  ABISELECT(-216,-144),
  ABISELECT(-272,-180),
  ABISELECT(-240,-156),
  ABISELECT(-1072,-656),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C15D1Ev,_ZTvn24_n72_N9S19045C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C15D0Ev,_ZTvn24_n72_N9S19045C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C15__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-832,-500),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void ABISELECT(_ZTv0_n48_N9S19045C15D1Ev,_ZTv0_n24_N9S19045C15D1Ev)();
extern void ABISELECT(_ZThn880_N9S19045C15D1Ev,_ZThn532_N9S19045C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19045C15D0Ev,_ZTv0_n24_N9S19045C15D0Ev)();
extern void ABISELECT(_ZThn880_N9S19045C15D0Ev,_ZThn532_N9S19045C15D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C133v76Ev();
extern void _ZN9S19045C133v77Ev();
extern void _ZN9S19045C133v78Ev();
extern void _ZN9S19045C133v79Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C13__9S19045C15__8S19045C1[] = {
  0,
  0,
  0,
  0,
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-880,-532),
  ABISELECT(-48,-32),
  ABISELECT(-104,-68),
  ABISELECT(-80,-56),
  ABISELECT(-880,-532),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19045C15D1Ev,_ZTv0_n24_N9S19045C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19045C15D0Ev,_ZTv0_n24_N9S19045C15D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v76Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v77Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v78Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v79Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C89S19045C109S19045C13__A3__9S19045C15__8S19045C1[] = {
  ABISELECT(-912,-552),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C49S19045C109S19045C13__A3__9S19045C15__8S19045C1[] = {
  ABISELECT(-944,-576),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C89S19045C13__A4__9S19045C15__8S19045C1[] = {
  ABISELECT(-976,-596),
  (VTBL_ENTRY)&(_ZTI9S19045C15[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A__8S19045C1[] = {
  ABISELECT(680,400),
  ABISELECT(704,412),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__A__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-704,-412),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__A__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-680,-400),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void _ZN8S19045C5D1Ev();
extern void _ZN8S19045C5D0Ev();
extern void _ZN8S19045C53v68Ev();
extern void _ZN8S19045C53v69Ev();
extern void _ZN8S19045C53v70Ev();
extern void _ZN8S19045C53v71Ev();
extern void _ZN8S19045C53v72Ev();
extern void _ZN8S19045C53v73Ev();
extern void _ZN8S19045C53v74Ev();
extern void _ZN8S19045C53v75Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C5__A1__8S19045C1[] = {
  ABISELECT(624,368),
  ABISELECT(728,428),
  ABISELECT(704,416),
  ABISELECT(672,392),
  ABISELECT(648,380),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&_ZN8S19045C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C5D0Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v68Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v69Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v70Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v71Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v72Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v73Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v74Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v75Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void _ZN8S19045C9D1Ev();
extern void _ZN8S19045C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C98S19045C5__A1__8S19045C1[] = {
  ABISELECT(728,428),
  ABISELECT(704,416),
  ABISELECT(672,392),
  ABISELECT(648,380),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&_ZN8S19045C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C9D0Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C108S19045C98S19045C5__A3__8S19045C1[] = {
  ABISELECT(672,392),
  ABISELECT(616,356),
  ABISELECT(640,368),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C108S19045C98S19045C5__A5__8S19045C1[] = {
  ABISELECT(616,356),
  ABISELECT(640,368),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C108S19045C98S19045C5__A5__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-640,-368),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C108S19045C98S19045C5__A5__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-616,-356),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C108S19045C98S19045C5__A3__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-640,-368),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C108S19045C98S19045C5__A3__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-616,-356),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C108S19045C98S19045C5__A3__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-672,-392),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C128S19045C98S19045C5__A2__8S19045C1[] = {
  ABISELECT(520,292),
  ABISELECT(600,340),
  ABISELECT(544,304),
  ABISELECT(576,328),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C128S19045C98S19045C5__A2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-576,-328),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C128S19045C98S19045C5__A2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-544,-304),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZThn600_N9S19045C12D1Ev,_ZThn340_N9S19045C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void ABISELECT(_ZThn600_N9S19045C12D0Ev,_ZThn340_N9S19045C12D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C128S19045C98S19045C5__A2__8S19045C1[] = {
  0,
  0,
  ABISELECT(-600,-340),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-600,-340),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C128S19045C98S19045C5__A2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-520,-292),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C98S19045C5__A3__8S19045C1[] = {
  ABISELECT(528,296),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C78S19045C98S19045C5__A3__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-528,-296),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__8S19045C98S19045C5__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-648,-380),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void ABISELECT(_ZThn32_N8S19045C9D1Ev,_ZThn24_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C9D0Ev,_ZThn24_N8S19045C9D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C10__8S19045C98S19045C5__A1__8S19045C1[] = {
  ABISELECT(672,392),
  ABISELECT(616,356),
  ABISELECT(640,368),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C9D1Ev,_ZThn24_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C9D0Ev,_ZThn24_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__A1__8S19045C98S19045C5__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-672,-392),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__8S19045C98S19045C5__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-704,-416),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void ABISELECT(_ZThn128_N8S19045C9D1Ev,_ZThn88_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn128_N8S19045C9D0Ev,_ZThn88_N8S19045C9D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__8S19045C98S19045C5__A1__8S19045C1[] = {
  ABISELECT(520,292),
  ABISELECT(600,340),
  ABISELECT(544,304),
  ABISELECT(576,328),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C9D1Ev,_ZThn88_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C9D0Ev,_ZThn88_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn728_N8S19045C9D1Ev,_ZThn428_N8S19045C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev)();
extern void ABISELECT(_ZThn728_N8S19045C9D0Ev,_ZThn428_N8S19045C9D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C98S19045C5__A1__8S19045C1[] = {
  0,
  0,
  ABISELECT(-728,-428),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-728,-428),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A__8S19045C98S19045C5__A1__8S19045C1[] = {
  ABISELECT(528,296),
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn624_N8S19045C5D1Ev,_ZThn368_N8S19045C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev)();
extern void ABISELECT(_ZThn624_N8S19045C5D0Ev,_ZThn368_N8S19045C5D0Ev)() __attribute__((weak));
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C6__8S19045C5__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-624,-368),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  ABISELECT(48,24),
  ABISELECT(-624,-368),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__8S19045C5__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-648,-380),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C5__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-672,-392),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZThn32_N8S19045C5D1Ev,_ZThn24_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C5D0Ev,_ZThn24_N8S19045C5D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C108S19045C9__8S19045C5__A1__8S19045C1[] = {
  ABISELECT(672,392),
  ABISELECT(616,356),
  ABISELECT(640,368),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C5D1Ev,_ZThn24_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C5D0Ev,_ZThn24_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A1__8S19045C5__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-704,-416),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void ABISELECT(_ZThn128_N8S19045C5D1Ev,_ZThn88_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn128_N8S19045C5D0Ev,_ZThn88_N8S19045C5D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C128S19045C9__8S19045C5__A1__8S19045C1[] = {
  ABISELECT(520,292),
  ABISELECT(600,340),
  ABISELECT(544,304),
  ABISELECT(576,328),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C5D1Ev,_ZThn88_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C5D0Ev,_ZThn88_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn728_N8S19045C5D1Ev,_ZThn428_N8S19045C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev)();
extern void ABISELECT(_ZThn728_N8S19045C5D0Ev,_ZThn428_N8S19045C5D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C5__A1__8S19045C1[] = {
  0,
  0,
  ABISELECT(-728,-428),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-728,-428),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C9__A2__8S19045C5__A1__8S19045C1[] = {
  ABISELECT(528,296),
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN9S19045C18D1Ev();
extern void _ZN9S19045C18D0Ev();
extern void _ZN9S19045C184v114Ev();
extern void _ZN9S19045C184v115Ev();
extern void _ZN9S19045C184v116Ev();
extern void _ZN9S19045C184v117Ev();
extern void _ZN9S19045C184v118Ev();
extern void _ZN9S19045C184v119Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C18__8S19045C1[] = {
  ABISELECT(744,440),
  ABISELECT(904,540),
  ABISELECT(480,272),
  ABISELECT(560,320),
  ABISELECT(504,284),
  ABISELECT(536,308),
  ABISELECT(888,532),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN9S19045C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v114Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v115Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v116Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v117Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v118Ev,
  (VTBL_ENTRY)&_ZN9S19045C184v119Ev,
};
extern void ABISELECT(_ZTv0_n56_N9S19045C18D1Ev,_ZTv0_n28_N9S19045C18D1Ev)();
extern void ABISELECT(_ZThn888_N9S19045C18D1Ev,_ZThn532_N9S19045C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S19045C18D0Ev,_ZTv0_n28_N9S19045C18D0Ev)();
extern void ABISELECT(_ZThn888_N9S19045C18D0Ev,_ZThn532_N9S19045C18D0Ev)() __attribute__((weak));
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN9S19045C194v110Ev();
extern void _ZN9S19045C194v111Ev();
extern void _ZN9S19045C194v112Ev();
extern void _ZN9S19045C194v113Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C19__9S19045C18__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-888,-532),
  ABISELECT(-408,-260),
  ABISELECT(-328,-212),
  ABISELECT(-384,-248),
  ABISELECT(-352,-224),
  ABISELECT(-888,-532),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19045C18D1Ev,_ZTv0_n28_N9S19045C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S19045C18D0Ev,_ZTv0_n28_N9S19045C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v110Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v111Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v112Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v113Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C18__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-536,-308),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C18__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-504,-284),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C18D1Ev,_ZTv0_n20_N9S19045C18D1Ev)();
extern void ABISELECT(_ZThn560_N9S19045C18D1Ev,_ZThn320_N9S19045C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C18D0Ev,_ZTv0_n20_N9S19045C18D0Ev)();
extern void ABISELECT(_ZThn560_N9S19045C18D0Ev,_ZThn320_N9S19045C18D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C18__8S19045C1[] = {
  0,
  0,
  ABISELECT(-560,-320),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-560,-320),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C18D1Ev,_ZTv0_n20_N9S19045C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C18D0Ev,_ZTv0_n20_N9S19045C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C18__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-480,-272),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void ABISELECT(_ZTv0_n48_N9S19045C18D1Ev,_ZTv0_n24_N9S19045C18D1Ev)();
extern void ABISELECT(_ZThn904_N9S19045C18D1Ev,_ZThn540_N9S19045C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19045C18D0Ev,_ZTv0_n24_N9S19045C18D0Ev)();
extern void ABISELECT(_ZThn904_N9S19045C18D0Ev,_ZThn540_N9S19045C18D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C10__9S19045C18__8S19045C1[] = {
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-904,-540),
  ABISELECT(-368,-232),
  ABISELECT(-424,-268),
  ABISELECT(-400,-256),
  ABISELECT(-904,-540),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19045C18D1Ev,_ZTv0_n24_N9S19045C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19045C18D0Ev,_ZTv0_n24_N9S19045C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C89S19045C10__A1__9S19045C18__8S19045C1[] = {
  ABISELECT(-936,-560),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C49S19045C10__A1__9S19045C18__8S19045C1[] = {
  ABISELECT(-968,-584),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void ABISELECT(_ZTv0_n144_N9S19045C18D1Ev,_ZTv0_n72_N9S19045C18D1Ev)();
extern void ABISELECT(_ZThn744_N9S19045C18D1Ev,_ZThn440_N9S19045C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n144_N9S19045C18D0Ev,_ZTv0_n72_N9S19045C18D0Ev)();
extern void ABISELECT(_ZThn744_N9S19045C18D0Ev,_ZThn440_N9S19045C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19045C17__9S19045C18__8S19045C1[] = {
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(32,24),
  ABISELECT(-744,-440),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-264,-168),
  ABISELECT(-184,-120),
  ABISELECT(-240,-156),
  ABISELECT(-208,-132),
  ABISELECT(-744,-440),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C18D1Ev,_ZTv0_n72_N9S19045C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n144_N9S19045C18D0Ev,_ZTv0_n72_N9S19045C18D0Ev),
};
extern void ABISELECT(_ZTvn32_n144_N9S19045C18D1Ev,_ZTvn24_n72_N9S19045C18D1Ev)();
extern void ABISELECT(_ZTvn32_n144_N9S19045C18D0Ev,_ZTvn24_n72_N9S19045C18D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C129S19045C17__A1__9S19045C18__8S19045C1[] = {
  ABISELECT(-296,-192),
  ABISELECT(-216,-144),
  ABISELECT(-272,-180),
  ABISELECT(-240,-156),
  ABISELECT(-776,-464),
  (VTBL_ENTRY)&(_ZTI9S19045C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C18D1Ev,_ZTvn24_n72_N9S19045C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n144_N9S19045C18D0Ev,_ZTvn24_n72_N9S19045C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
extern void _ZN8S19045C33v17Ev();
extern void _ZN8S19045C33v18Ev();
extern void _ZN8S19045C33v19Ev();
extern void _ZN8S19045C33v20Ev();
extern void _ZN8S19045C33v21Ev();
extern void _ZN8S19045C33v22Ev();
extern void _ZN8S19045C33v23Ev();
extern void _ZN8S19045C2D1Ev();
extern void _ZN8S19045C2D0Ev();
extern void _ZN8S19045C23v87Ev();
extern void _ZN8S19045C23v88Ev();
extern void _ZN8S19045C23v89Ev();
extern void _ZN8S19045C23v90Ev();
extern void _ZN8S19045C23v91Ev();
extern void _ZN8S19045C23v92Ev();
extern void _ZN8S19045C23v93Ev();
extern void _ZN8S19045C23v94Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C2__8S19045C1[] = {
  ABISELECT(384,236),
  ABISELECT(360,216),
  ABISELECT(336,204),
  ABISELECT(304,180),
  ABISELECT(280,168),
  ABISELECT(256,156),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v17Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v18Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v19Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v20Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v21Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v22Ev,
  (VTBL_ENTRY)&_ZN8S19045C33v23Ev,
  (VTBL_ENTRY)&_ZN8S19045C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v87Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v88Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v89Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v90Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v91Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v92Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v93Ev,
  (VTBL_ENTRY)&_ZN8S19045C23v94Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void _ZN8S19045C5D1Ev();
extern void _ZN8S19045C5D0Ev();
extern void _ZN8S19045C53v68Ev();
extern void _ZN8S19045C53v69Ev();
extern void _ZN8S19045C53v70Ev();
extern void _ZN8S19045C53v71Ev();
extern void _ZN8S19045C53v72Ev();
extern void _ZN8S19045C53v73Ev();
extern void _ZN8S19045C53v74Ev();
extern void _ZN8S19045C53v75Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(224,144),
  ABISELECT(328,204),
  ABISELECT(304,192),
  ABISELECT(272,168),
  ABISELECT(248,156),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&_ZN8S19045C5D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C5D0Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v68Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v69Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v70Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v71Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v72Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v73Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v74Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v75Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void _ZN8S19045C9D1Ev();
extern void _ZN8S19045C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C98S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(328,204),
  ABISELECT(304,192),
  ABISELECT(272,168),
  ABISELECT(248,156),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&_ZN8S19045C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C9D0Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C108S19045C98S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(272,168),
  ABISELECT(216,132),
  ABISELECT(240,144),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C108S19045C98S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(216,132),
  ABISELECT(240,144),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C108S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-240,-144),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C108S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-216,-132),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C108S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-240,-144),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C108S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-216,-132),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C108S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-272,-168),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C128S19045C98S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(120,68),
  ABISELECT(200,116),
  ABISELECT(144,80),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C128S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C128S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZThn200_N9S19045C12D1Ev,_ZThn116_N9S19045C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void ABISELECT(_ZThn200_N9S19045C12D0Ev,_ZThn116_N9S19045C12D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C128S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  ABISELECT(-200,-116),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-200,-116),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C128S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-120,-68),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C98S19045C58S19045C2__A2__8S19045C1[] = {
  ABISELECT(128,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C78S19045C98S19045C58S19045C2__A2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-128,-72),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__8S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-248,-156),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void ABISELECT(_ZThn32_N8S19045C9D1Ev,_ZThn24_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C9D0Ev,_ZThn24_N8S19045C9D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C10__8S19045C98S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(272,168),
  ABISELECT(216,132),
  ABISELECT(240,144),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C9D1Ev,_ZThn24_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C9D0Ev,_ZThn24_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__A1__8S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-272,-168),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__8S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-304,-192),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void ABISELECT(_ZThn128_N8S19045C9D1Ev,_ZThn88_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn128_N8S19045C9D0Ev,_ZThn88_N8S19045C9D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__8S19045C98S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(120,68),
  ABISELECT(200,116),
  ABISELECT(144,80),
  ABISELECT(176,104),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C9D1Ev,_ZThn88_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C9D0Ev,_ZThn88_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev)();
extern void ABISELECT(_ZThn328_N8S19045C9D1Ev,_ZThn204_N8S19045C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev)();
extern void ABISELECT(_ZThn328_N8S19045C9D0Ev,_ZThn204_N8S19045C9D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C98S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  ABISELECT(-328,-204),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-328,-204),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A__8S19045C98S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(128,72),
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI8S19045C9[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn224_N8S19045C5D1Ev,_ZThn144_N8S19045C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev)();
extern void ABISELECT(_ZThn224_N8S19045C5D0Ev,_ZThn144_N8S19045C5D0Ev)() __attribute__((weak));
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C6__8S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-224,-144),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  ABISELECT(48,24),
  ABISELECT(-224,-144),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__8S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-248,-156),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-272,-168),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZThn32_N8S19045C5D1Ev,_ZThn24_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C5D0Ev,_ZThn24_N8S19045C5D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C108S19045C9__8S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(272,168),
  ABISELECT(216,132),
  ABISELECT(240,144),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C5D1Ev,_ZThn24_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C5D0Ev,_ZThn24_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A1__8S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-304,-192),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void ABISELECT(_ZThn128_N8S19045C5D1Ev,_ZThn88_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn128_N8S19045C5D0Ev,_ZThn88_N8S19045C5D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C128S19045C9__8S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(120,68),
  ABISELECT(200,116),
  ABISELECT(144,80),
  ABISELECT(176,104),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C5D1Ev,_ZThn88_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S19045C5D0Ev,_ZThn88_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev)();
extern void ABISELECT(_ZThn328_N8S19045C5D1Ev,_ZThn204_N8S19045C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev)();
extern void ABISELECT(_ZThn328_N8S19045C5D0Ev,_ZThn204_N8S19045C5D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C58S19045C2__8S19045C1[] = {
  0,
  0,
  ABISELECT(-328,-204),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-328,-204),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C9__A2__8S19045C58S19045C2__8S19045C1[] = {
  ABISELECT(128,72),
  ABISELECT(-144,-96),
  (VTBL_ENTRY)&(_ZTI8S19045C5[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN8S19045C93v59Ev();
extern void _ZN8S19045C93v60Ev();
extern void _ZN8S19045C93v61Ev();
extern void _ZN8S19045C93v62Ev();
extern void _ZN8S19045C93v63Ev();
extern void _ZN8S19045C93v64Ev();
extern void _ZN8S19045C93v65Ev();
extern void _ZN8S19045C93v66Ev();
extern void _ZN8S19045C93v67Ev();
extern void ABISELECT(_ZThn32_N8S19045C2D1Ev,_ZThn12_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn32_N8S19045C2D0Ev,_ZThn12_N8S19045C2D0Ev)();
extern void _ZN8S19045C53v68Ev();
extern void _ZN8S19045C53v69Ev();
extern void _ZN8S19045C53v70Ev();
extern void _ZN8S19045C53v71Ev();
extern void _ZN8S19045C53v72Ev();
extern void _ZN8S19045C53v73Ev();
extern void _ZN8S19045C53v74Ev();
extern void _ZN8S19045C53v75Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C5__8S19045C2__8S19045C1[] = {
  ABISELECT(224,144),
  ABISELECT(328,204),
  ABISELECT(304,192),
  ABISELECT(272,168),
  ABISELECT(248,156),
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v59Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v60Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v61Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v62Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v63Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v64Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v65Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v66Ev,
  (VTBL_ENTRY)&_ZN8S19045C93v67Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C2D1Ev,_ZThn12_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S19045C2D0Ev,_ZThn12_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C53v68Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v69Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v70Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v71Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v72Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v73Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v74Ev,
  (VTBL_ENTRY)&_ZN8S19045C53v75Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void ABISELECT(_ZTv0_n96_N8S19045C2D1Ev,_ZTv0_n48_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn256_N8S19045C2D1Ev,_ZThn156_N8S19045C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S19045C2D0Ev,_ZTv0_n48_N8S19045C2D0Ev)();
extern void ABISELECT(_ZThn256_N8S19045C2D0Ev,_ZThn156_N8S19045C2D0Ev)() __attribute__((weak));
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C6__8S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-256,-156),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  ABISELECT(48,24),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C2D1Ev,_ZTv0_n48_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S19045C2D0Ev,_ZTv0_n48_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__A1__8S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-280,-168),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-304,-180),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZThn64_N8S19045C2D1Ev,_ZThn36_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn64_N8S19045C2D0Ev,_ZThn36_N8S19045C2D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C108S19045C98S19045C5__8S19045C2__8S19045C1[] = {
  ABISELECT(272,168),
  ABISELECT(216,132),
  ABISELECT(240,144),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S19045C2D1Ev,_ZThn36_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N8S19045C2D0Ev,_ZThn36_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A1__8S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(-336,-204),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void ABISELECT(_ZThn160_N8S19045C2D1Ev,_ZThn100_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn160_N8S19045C2D0Ev,_ZThn100_N8S19045C2D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C128S19045C98S19045C5__8S19045C2__8S19045C1[] = {
  ABISELECT(120,68),
  ABISELECT(200,116),
  ABISELECT(144,80),
  ABISELECT(176,104),
  ABISELECT(-160,-100),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S19045C2D1Ev,_ZThn100_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S19045C2D0Ev,_ZThn100_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S19045C2D1Ev,_ZTv0_n20_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn360_N8S19045C2D1Ev,_ZThn216_N8S19045C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S19045C2D0Ev,_ZTv0_n20_N8S19045C2D0Ev)();
extern void ABISELECT(_ZThn360_N8S19045C2D0Ev,_ZThn216_N8S19045C2D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C2__8S19045C1[] = {
  0,
  0,
  ABISELECT(-360,-216),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(-360,-216),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C2D1Ev,_ZTv0_n20_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S19045C2D0Ev,_ZTv0_n20_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C98S19045C5__A2__8S19045C2__8S19045C1[] = {
  ABISELECT(128,72),
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void ABISELECT(_ZTv0_n48_N8S19045C2D1Ev,_ZTv0_n24_N8S19045C2D1Ev)();
extern void ABISELECT(_ZThn384_N8S19045C2D1Ev,_ZThn236_N8S19045C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19045C2D0Ev,_ZTv0_n24_N8S19045C2D0Ev)();
extern void ABISELECT(_ZThn384_N8S19045C2D0Ev,_ZThn236_N8S19045C2D0Ev)() __attribute__((weak));
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C133v76Ev();
extern void _ZN9S19045C133v77Ev();
extern void _ZN9S19045C133v78Ev();
extern void _ZN9S19045C133v79Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C13__8S19045C2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(64,44),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-384,-236),
  ABISELECT(-48,-32),
  ABISELECT(-104,-68),
  ABISELECT(-80,-56),
  ABISELECT(-384,-236),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19045C2D1Ev,_ZTv0_n24_N8S19045C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19045C2D0Ev,_ZTv0_n24_N8S19045C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v76Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v77Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v78Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v79Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C89S19045C109S19045C13__A3__8S19045C2__8S19045C1[] = {
  ABISELECT(-416,-256),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C49S19045C109S19045C13__A3__8S19045C2__8S19045C1[] = {
  ABISELECT(-448,-280),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C89S19045C13__A4__8S19045C2__8S19045C1[] = {
  ABISELECT(-480,-300),
  (VTBL_ENTRY)&(_ZTI8S19045C2[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
extern void _ZN8S19045C6D1Ev();
extern void _ZN8S19045C6D0Ev();
extern void _ZN8S19045C63v38Ev();
extern void _ZN8S19045C63v39Ev();
extern void _ZN8S19045C63v40Ev();
extern void _ZN8S19045C63v41Ev();
extern void _ZN8S19045C63v42Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C6__8S19045C1[] = {
  ABISELECT(24,12),
  ABISELECT(48,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
  (VTBL_ENTRY)&_ZN8S19045C6D1Ev,
  (VTBL_ENTRY)&_ZN8S19045C6D0Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v38Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v39Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v40Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v41Ev,
  (VTBL_ENTRY)&_ZN8S19045C63v42Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C78S19045C6__8S19045C1[] = {
  ABISELECT(48,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C78S19045C6__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__8S19045C6__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C6__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S19045C6[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__A1__8S19045C1[] = {
  ABISELECT(-32,-24),
  0,
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__8S19045C7__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(32,24),
  (VTBL_ENTRY)&(_ZTI8S19045C7[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__A1__8S19045C1[] = {
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C11__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(56,36),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C11__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,48),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN9S19045C13D1Ev();
extern void _ZN9S19045C13D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
extern void _ZN9S19045C133v76Ev();
extern void _ZN9S19045C133v77Ev();
extern void _ZN9S19045C133v78Ev();
extern void _ZN9S19045C133v79Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C13__8S19045C1[] = {
  ABISELECT(-48,-32),
  ABISELECT(-104,-68),
  ABISELECT(-80,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN9S19045C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C13D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v76Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v77Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v78Ev,
  (VTBL_ENTRY)&_ZN9S19045C133v79Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C109S19045C13__A1__8S19045C1[] = {
  ABISELECT(-48,-32),
  ABISELECT(-104,-68),
  ABISELECT(-80,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C109S19045C13__A2__8S19045C1[] = {
  ABISELECT(-104,-68),
  ABISELECT(-80,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C109S19045C13__A2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,56),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C109S19045C13__A2__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,68),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C109S19045C13__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,56),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C109S19045C13__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,68),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C109S19045C13__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(48,32),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C13__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,68),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C13__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(48,32),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C13__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(80,56),
  (VTBL_ENTRY)&(_ZTI9S19045C13[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
extern void _ZN9S19045C173v95Ev();
extern void _ZN9S19045C173v96Ev();
extern void _ZN9S19045C173v97Ev();
extern void _ZN9S19045C173v98Ev();
extern void _ZN9S19045C17D1Ev();
extern void _ZN9S19045C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C17__8S19045C1[] = {
  ABISELECT(-264,-168),
  ABISELECT(-184,-120),
  ABISELECT(-240,-156),
  ABISELECT(-208,-132),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v95Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v96Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v97Ev,
  (VTBL_ENTRY)&_ZN9S19045C173v98Ev,
  (VTBL_ENTRY)&_ZN9S19045C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C17D0Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C129S19045C17__A1__8S19045C1[] = {
  ABISELECT(-296,-192),
  ABISELECT(-216,-144),
  ABISELECT(-272,-180),
  ABISELECT(-240,-156),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C129S19045C17__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(240,156),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C129S19045C17__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(272,180),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C129S19045C17__A1__8S19045C1[] = {
  0,
  0,
  ABISELECT(216,144),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(216,144),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C129S19045C17__A1__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(296,192),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void ABISELECT(_ZThn32_N9S19045C17D1Ev,_ZThn24_N9S19045C17D1Ev)();
extern void ABISELECT(_ZThn32_N9S19045C17D0Ev,_ZThn24_N9S19045C17D0Ev)();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C12__9S19045C17__8S19045C1[] = {
  ABISELECT(-296,-192),
  ABISELECT(-216,-144),
  ABISELECT(-272,-180),
  ABISELECT(-240,-156),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19045C17D1Ev,_ZThn24_N9S19045C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S19045C17D0Ev,_ZThn24_N9S19045C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C17__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(208,132),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__A1__9S19045C17__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(240,156),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C17__8S19045C1[] = {
  0,
  0,
  ABISELECT(184,120),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(184,120),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C17D1Ev,_ZTv0_n20_N9S19045C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C17D0Ev,_ZTv0_n20_N9S19045C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C17__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(264,168),
  (VTBL_ENTRY)&(_ZTI9S19045C17[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN9S19045C19D1Ev();
extern void _ZN9S19045C19D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
extern void _ZN9S19045C194v110Ev();
extern void _ZN9S19045C194v111Ev();
extern void _ZN9S19045C194v112Ev();
extern void _ZN9S19045C194v113Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C19__8S19045C1[] = {
  ABISELECT(-408,-260),
  ABISELECT(-328,-212),
  ABISELECT(-384,-248),
  ABISELECT(-352,-224),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN9S19045C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C19D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v110Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v111Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v112Ev,
  (VTBL_ENTRY)&_ZN9S19045C194v113Ev,
};
extern void _ZN9S19045C12D1Ev();
extern void _ZN9S19045C12D0Ev();
extern void _ZN9S19045C123v53Ev();
extern void _ZN9S19045C123v54Ev();
extern void _ZN9S19045C123v55Ev();
extern void _ZN9S19045C123v56Ev();
extern void _ZN9S19045C123v57Ev();
extern void _ZN9S19045C123v58Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C129S19045C19__A3__8S19045C1[] = {
  ABISELECT(-408,-260),
  ABISELECT(-328,-212),
  ABISELECT(-384,-248),
  ABISELECT(-352,-224),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN9S19045C12D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C12D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v53Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v54Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v55Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v56Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v57Ev,
  (VTBL_ENTRY)&_ZN9S19045C123v58Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C129S19045C19__A3__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(352,224),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C129S19045C19__A3__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(384,248),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C129S19045C19__A3__8S19045C1[] = {
  0,
  0,
  ABISELECT(328,212),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(328,212),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C129S19045C19__A3__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(408,260),
  (VTBL_ENTRY)&(_ZTI9S19045C12[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C19__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(352,224),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C19__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(384,248),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S19045C19D1Ev,_ZTv0_n20_N9S19045C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N9S19045C19D0Ev,_ZTv0_n20_N9S19045C19D0Ev)();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C11__9S19045C19__8S19045C1[] = {
  0,
  0,
  ABISELECT(328,212),
  ABISELECT(-80,-48),
  ABISELECT(-56,-36),
  ABISELECT(328,212),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C19D1Ev,_ZTv0_n20_N9S19045C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S19045C19D0Ev,_ZTv0_n20_N9S19045C19D0Ev),
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C19__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(408,260),
  (VTBL_ENTRY)&(_ZTI9S19045C19[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN9S19045C10D1Ev();
extern void _ZN9S19045C10D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
extern void _ZN9S19045C103v45Ev();
extern void _ZN9S19045C103v46Ev();
extern void _ZN9S19045C103v47Ev();
extern void _ZN9S19045C103v48Ev();
extern void _ZN9S19045C103v49Ev();
extern void _ZN9S19045C103v50Ev();
extern void _ZN9S19045C103v51Ev();
extern void _ZN9S19045C103v52Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C10__A4__8S19045C1[] = {
  ABISELECT(-368,-232),
  ABISELECT(-424,-268),
  ABISELECT(-400,-256),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN9S19045C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C10D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v45Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v46Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v47Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v48Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v49Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v50Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v51Ev,
  (VTBL_ENTRY)&_ZN9S19045C103v52Ev,
};
extern void _ZN9S19045C11D1Ev();
extern void _ZN9S19045C11D0Ev();
extern void _ZN9S19045C113v43Ev();
extern void _ZN9S19045C113v44Ev();
static  VTBL_ENTRY _tg__ZTV9S19045C119S19045C10__A6__8S19045C1[] = {
  ABISELECT(-424,-268),
  ABISELECT(-400,-256),
  0,
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN9S19045C11D1Ev,
  (VTBL_ENTRY)&_ZN9S19045C11D0Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v43Ev,
  (VTBL_ENTRY)&_ZN9S19045C113v44Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C119S19045C10__A6__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(400,256),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C119S19045C10__A6__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(424,268),
  (VTBL_ENTRY)&(_ZTI9S19045C11[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C83v24Ev();
extern void _ZN8S19045C83v25Ev();
extern void _ZN8S19045C83v26Ev();
extern void _ZN8S19045C83v27Ev();
extern void _ZN8S19045C83v28Ev();
extern void _ZN8S19045C83v29Ev();
extern void _ZN8S19045C83v30Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C8__9S19045C10__A4__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(400,256),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C83v24Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v25Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v26Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v27Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v28Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v29Ev,
  (VTBL_ENTRY)&_ZN8S19045C83v30Ev,
};
extern void _ZN8S19045C43v10Ev();
extern void _ZN8S19045C43v11Ev();
extern void _ZN8S19045C43v12Ev();
extern void _ZN8S19045C43v13Ev();
extern void _ZN8S19045C43v14Ev();
extern void _ZN8S19045C43v15Ev();
extern void _ZN8S19045C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C4__9S19045C10__A4__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(424,268),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C43v10Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v11Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v12Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v13Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v14Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v15Ev,
  (VTBL_ENTRY)&_ZN8S19045C43v16Ev,
};
extern void _ZN8S19045C73v31Ev();
extern void _ZN8S19045C73v32Ev();
extern void _ZN8S19045C73v33Ev();
extern void _ZN8S19045C73v34Ev();
extern void _ZN8S19045C73v35Ev();
extern void _ZN8S19045C73v36Ev();
extern void _ZN8S19045C73v37Ev();
static  VTBL_ENTRY _tg__ZTV8S19045C7__9S19045C10__A4__8S19045C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  ABISELECT(368,232),
  (VTBL_ENTRY)&(_ZTI9S19045C10[0]),
  (VTBL_ENTRY)&_ZN8S19045C73v31Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v32Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v33Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v34Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v35Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v36Ev,
  (VTBL_ENTRY)&_ZN8S19045C73v37Ev,
};
static  VTT_ENTRY vtt_S19045C1[] = {
  {&(_ZTV8S19045C1[13]),  13,728},
  {&(_tg__ZTV9S19045C15__8S19045C1[9]),  9,32},
  {&(_tg__ZTV9S19045C169S19045C15__8S19045C1[8]),  8,26},
  {&(_tg__ZTV9S19045C109S19045C169S19045C15__A2__8S19045C1[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C109S19045C169S19045C15__A3__8S19045C1[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C109S19045C169S19045C15__A3__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C109S19045C169S19045C15__A3__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C109S19045C169S19045C15__A2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C109S19045C169S19045C15__A2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C109S19045C169S19045C15__A2__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C3__9S19045C169S19045C15__8S19045C1[16]),  16,30},
  {&(_tg__ZTV9S19045C11__9S19045C169S19045C15__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C8__9S19045C169S19045C15__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__A1__9S19045C169S19045C15__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C17__9S19045C169S19045C15__8S19045C1[24]),  24,37},
  {&(_tg__ZTV9S19045C129S19045C17__9S19045C169S19045C15__8S19045C1[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C169S19045C15__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C3__9S19045C15__8S19045C1[16]),  16,30},
  {&(_tg__ZTV9S19045C11__9S19045C15__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C8__9S19045C15__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__A1__9S19045C15__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C17__9S19045C15__8S19045C1[24]),  24,37},
  {&(_tg__ZTV9S19045C129S19045C17__9S19045C15__8S19045C1[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C15__8S19045C1[10]),  10,17},
  {&(_tg__ZTV9S19045C13__9S19045C15__8S19045C1[34]),  34,50},
  {&(_tg__ZTV8S19045C89S19045C109S19045C13__A3__9S19045C15__8S19045C1[2]),  2,9},
  {&(_tg__ZTV8S19045C49S19045C109S19045C13__A3__9S19045C15__8S19045C1[2]),  2,9},
  {&(_tg__ZTV8S19045C89S19045C13__A4__9S19045C15__8S19045C1[2]),  2,9},
  {&(_tg__ZTV9S19045C11__A__8S19045C1[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__A__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__A__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C5__A1__8S19045C1[7]),  7,33},
  {&(_tg__ZTV8S19045C98S19045C5__A1__8S19045C1[6]),  6,24},
  {&(_tg__ZTV9S19045C108S19045C98S19045C5__A3__8S19045C1[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C108S19045C98S19045C5__A5__8S19045C1[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C108S19045C98S19045C5__A5__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C108S19045C98S19045C5__A5__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C108S19045C98S19045C5__A3__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C108S19045C98S19045C5__A3__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C108S19045C98S19045C5__A3__8S19045C1[10]),  10,17},
  {&(_tg__ZTV9S19045C128S19045C98S19045C5__A2__8S19045C1[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C128S19045C98S19045C5__A2__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C128S19045C98S19045C5__A2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C128S19045C98S19045C5__A2__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C128S19045C98S19045C5__A2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C78S19045C98S19045C5__A3__8S19045C1[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C78S19045C98S19045C5__A3__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__8S19045C98S19045C5__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C10__8S19045C98S19045C5__A1__8S19045C1[5]),  5,17},
  {&(_tg__ZTV8S19045C8__A1__8S19045C98S19045C5__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C7__8S19045C98S19045C5__A1__8S19045C1[10]),  10,17},
  {&(_tg__ZTV9S19045C12__8S19045C98S19045C5__A1__8S19045C1[6]),  6,14},
  {&(_tg__ZTV9S19045C11__A1__8S19045C98S19045C5__A1__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C7__A__8S19045C98S19045C5__A1__8S19045C1[3]),  3,10},
  {&(_tg__ZTV8S19045C6__8S19045C5__A1__8S19045C1[17]),  17,31},
  {&(_tg__ZTV8S19045C4__8S19045C5__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C8__8S19045C5__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C108S19045C9__8S19045C5__A1__8S19045C1[5]),  5,17},
  {&(_tg__ZTV8S19045C7__A1__8S19045C5__A1__8S19045C1[10]),  10,17},
  {&(_tg__ZTV9S19045C128S19045C9__8S19045C5__A1__8S19045C1[6]),  6,14},
  {&(_tg__ZTV9S19045C11__A1__8S19045C5__A1__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C78S19045C9__A2__8S19045C5__A1__8S19045C1[3]),  3,10},
  {&(_tg__ZTV9S19045C18__8S19045C1[9]),  9,17},
  {&(_tg__ZTV9S19045C19__9S19045C18__8S19045C1[17]),  17,29},
  {&(_tg__ZTV8S19045C7__9S19045C18__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C18__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C18__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C18__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C10__9S19045C18__8S19045C1[30]),  30,42},
  {&(_tg__ZTV8S19045C89S19045C10__A1__9S19045C18__8S19045C1[2]),  2,9},
  {&(_tg__ZTV8S19045C49S19045C10__A1__9S19045C18__8S19045C1[2]),  2,9},
  {&(_tg__ZTV9S19045C17__9S19045C18__8S19045C1[24]),  24,37},
  {&(_tg__ZTV9S19045C129S19045C17__A1__9S19045C18__8S19045C1[6]),  6,14},
  {&(_ZTV8S19045C1[265]),  265,728},
  {&(_ZTV8S19045C1[296]),  296,728},
  {&(_ZTV8S19045C1[407]),  407,728},
  {&(_ZTV8S19045C1[430]),  430,728},
  {&(_ZTV8S19045C1[446]),  446,728},
  {&(_ZTV8S19045C1[327]),  327,728},
  {&(_ZTV8S19045C1[341]),  341,728},
  {&(_ZTV8S19045C1[350]),  350,728},
  {&(_ZTV8S19045C1[463]),  463,728},
  {&(_ZTV8S19045C1[363]),  363,728},
  {&(_ZTV8S19045C1[477]),  477,728},
  {&(_ZTV8S19045C1[374]),  374,728},
  {&(_ZTV8S19045C1[515]),  515,728},
  {&(_ZTV8S19045C1[533]),  533,728},
  {&(_ZTV8S19045C1[542]),  542,728},
  {&(_ZTV8S19045C1[551]),  551,728},
  {&(_ZTV8S19045C1[383]),  383,728},
  {&(_ZTV8S19045C1[574]),  574,728},
  {&(_ZTV8S19045C1[612]),  612,728},
  {&(_ZTV8S19045C1[631]),  631,728},
  {&(_ZTV8S19045C1[67]),  67,728},
  {&(_ZTV8S19045C1[78]),  78,728},
  {&(_ZTV8S19045C1[109]),  109,728},
  {&(_ZTV8S19045C1[145]),  145,728},
  {&(_ZTV8S19045C1[156]),  156,728},
  {&(_ZTV8S19045C1[172]),  172,728},
  {&(_ZTV8S19045C1[656]),  656,728},
  {&(_ZTV8S19045C1[698]),  698,728},
  {&(_ZTV8S19045C1[712]),  712,728},
  {&(_ZTV8S19045C1[721]),  721,728},
  {&(_tg__ZTV8S19045C2__8S19045C1[8]),  8,32},
  {&(_tg__ZTV8S19045C58S19045C2__8S19045C1[7]),  7,33},
  {&(_tg__ZTV8S19045C98S19045C58S19045C2__8S19045C1[6]),  6,24},
  {&(_tg__ZTV9S19045C108S19045C98S19045C58S19045C2__8S19045C1[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C108S19045C98S19045C58S19045C2__8S19045C1[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C108S19045C98S19045C58S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C108S19045C98S19045C58S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C108S19045C98S19045C58S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C108S19045C98S19045C58S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C108S19045C98S19045C58S19045C2__8S19045C1[10]),  10,17},
  {&(_tg__ZTV9S19045C128S19045C98S19045C58S19045C2__8S19045C1[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C128S19045C98S19045C58S19045C2__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C128S19045C98S19045C58S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C128S19045C98S19045C58S19045C2__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C128S19045C98S19045C58S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C78S19045C98S19045C58S19045C2__A2__8S19045C1[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C78S19045C98S19045C58S19045C2__A2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__8S19045C98S19045C58S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C10__8S19045C98S19045C58S19045C2__8S19045C1[5]),  5,17},
  {&(_tg__ZTV8S19045C8__A1__8S19045C98S19045C58S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C7__8S19045C98S19045C58S19045C2__8S19045C1[10]),  10,17},
  {&(_tg__ZTV9S19045C12__8S19045C98S19045C58S19045C2__8S19045C1[6]),  6,14},
  {&(_tg__ZTV9S19045C11__A1__8S19045C98S19045C58S19045C2__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C7__A__8S19045C98S19045C58S19045C2__8S19045C1[3]),  3,10},
  {&(_tg__ZTV8S19045C6__8S19045C58S19045C2__8S19045C1[17]),  17,31},
  {&(_tg__ZTV8S19045C4__8S19045C58S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C8__8S19045C58S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C108S19045C9__8S19045C58S19045C2__8S19045C1[5]),  5,17},
  {&(_tg__ZTV8S19045C7__A1__8S19045C58S19045C2__8S19045C1[10]),  10,17},
  {&(_tg__ZTV9S19045C128S19045C9__8S19045C58S19045C2__8S19045C1[6]),  6,14},
  {&(_tg__ZTV9S19045C11__A1__8S19045C58S19045C2__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C78S19045C9__A2__8S19045C58S19045C2__8S19045C1[3]),  3,10},
  {&(_tg__ZTV8S19045C5__8S19045C2__8S19045C1[7]),  7,33},
  {&(_tg__ZTV8S19045C6__8S19045C2__8S19045C1[17]),  17,31},
  {&(_tg__ZTV8S19045C4__A1__8S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C8__8S19045C2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C108S19045C98S19045C5__8S19045C2__8S19045C1[5]),  5,17},
  {&(_tg__ZTV8S19045C7__A1__8S19045C2__8S19045C1[10]),  10,17},
  {&(_tg__ZTV9S19045C128S19045C98S19045C5__8S19045C2__8S19045C1[6]),  6,14},
  {&(_tg__ZTV9S19045C11__A1__8S19045C2__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C78S19045C98S19045C5__A2__8S19045C2__8S19045C1[3]),  3,10},
  {&(_tg__ZTV9S19045C13__8S19045C2__8S19045C1[34]),  34,50},
  {&(_tg__ZTV8S19045C89S19045C109S19045C13__A3__8S19045C2__8S19045C1[2]),  2,9},
  {&(_tg__ZTV8S19045C49S19045C109S19045C13__A3__8S19045C2__8S19045C1[2]),  2,9},
  {&(_tg__ZTV8S19045C89S19045C13__A4__8S19045C2__8S19045C1[2]),  2,9},
  {&(_tg__ZTV8S19045C6__8S19045C1[4]),  4,18},
  {&(_tg__ZTV8S19045C78S19045C6__8S19045C1[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C78S19045C6__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__8S19045C6__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C8__8S19045C6__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C7__A1__8S19045C1[3]),  3,10},
  {&(_tg__ZTV8S19045C8__8S19045C7__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C11__A1__8S19045C1[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C11__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C11__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C13__8S19045C1[5]),  5,21},
  {&(_tg__ZTV9S19045C109S19045C13__A1__8S19045C1[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C109S19045C13__A2__8S19045C1[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C109S19045C13__A2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C109S19045C13__A2__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C109S19045C13__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C109S19045C13__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C109S19045C13__A1__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C4__9S19045C13__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C13__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C13__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C17__8S19045C1[6]),  6,19},
  {&(_tg__ZTV9S19045C129S19045C17__A1__8S19045C1[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C129S19045C17__A1__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C129S19045C17__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C129S19045C17__A1__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C129S19045C17__A1__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C12__9S19045C17__8S19045C1[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C17__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C8__A1__9S19045C17__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C17__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C17__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C19__8S19045C1[6]),  6,18},
  {&(_tg__ZTV9S19045C129S19045C19__A3__8S19045C1[6]),  6,14},
  {&(_tg__ZTV8S19045C7__9S19045C129S19045C19__A3__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C129S19045C19__A3__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C129S19045C19__A3__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C129S19045C19__A3__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C19__8S19045C1[10]),  10,17},
  {&(_tg__ZTV8S19045C8__9S19045C19__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C11__9S19045C19__8S19045C1[7]),  7,11},
  {&(_tg__ZTV8S19045C4__9S19045C19__8S19045C1[9]),  9,16},
  {&(_tg__ZTV9S19045C10__A4__8S19045C1[5]),  5,17},
  {&(_tg__ZTV9S19045C119S19045C10__A6__8S19045C1[4]),  4,8},
  {&(_tg__ZTV8S19045C8__9S19045C119S19045C10__A6__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C119S19045C10__A6__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C8__9S19045C10__A4__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C4__9S19045C10__A4__8S19045C1[9]),  9,16},
  {&(_tg__ZTV8S19045C7__9S19045C10__A4__8S19045C1[10]),  10,17},
};
extern VTBL_ENTRY _ZTI8S19045C1[];
extern  VTBL_ENTRY _ZTV8S19045C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19045C1[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19045C2D0Ev,_ZTv0_n24_N8S19045C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19045C2D0Ev,_ZThn236_N8S19045C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19045C2D1Ev,_ZTv0_n24_N8S19045C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn384_N8S19045C2D1Ev,_ZThn236_N8S19045C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C2D0Ev,_ZTv0_n20_N8S19045C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S19045C2D0Ev,_ZThn216_N8S19045C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C2D1Ev,_ZTv0_n20_N8S19045C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S19045C2D1Ev,_ZThn216_N8S19045C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C2D0Ev,_ZTv0_n48_N8S19045C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N8S19045C2D0Ev,_ZThn156_N8S19045C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C2D1Ev,_ZTv0_n48_N8S19045C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N8S19045C2D1Ev,_ZThn156_N8S19045C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C18D0Ev,_ZTv0_n72_N9S19045C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn744_N9S19045C18D0Ev,_ZThn440_N9S19045C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C18D1Ev,_ZTv0_n72_N9S19045C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn744_N9S19045C18D1Ev,_ZThn440_N9S19045C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19045C18D0Ev,_ZTv0_n24_N9S19045C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn904_N9S19045C18D0Ev,_ZThn540_N9S19045C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19045C18D1Ev,_ZTv0_n24_N9S19045C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn904_N9S19045C18D1Ev,_ZThn540_N9S19045C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C18D0Ev,_ZTv0_n20_N9S19045C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn560_N9S19045C18D0Ev,_ZThn320_N9S19045C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C18D1Ev,_ZTv0_n20_N9S19045C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn560_N9S19045C18D1Ev,_ZThn320_N9S19045C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19045C18D0Ev,_ZTv0_n28_N9S19045C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn888_N9S19045C18D0Ev,_ZThn532_N9S19045C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S19045C18D1Ev,_ZTv0_n28_N9S19045C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn888_N9S19045C18D1Ev,_ZThn532_N9S19045C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C5D0Ev,_ZTv0_n20_N8S19045C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S19045C5D0Ev,_ZThn204_N8S19045C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn728_N8S19045C5D0Ev,_ZThn428_N8S19045C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C5D1Ev,_ZTv0_n20_N8S19045C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S19045C5D1Ev,_ZThn204_N8S19045C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn728_N8S19045C5D1Ev,_ZThn428_N8S19045C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C5D0Ev,_ZTv0_n48_N8S19045C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19045C5D0Ev,_ZThn144_N8S19045C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn624_N8S19045C5D0Ev,_ZThn368_N8S19045C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C5D1Ev,_ZTv0_n48_N8S19045C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn224_N8S19045C5D1Ev,_ZThn144_N8S19045C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn624_N8S19045C5D1Ev,_ZThn368_N8S19045C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C9D0Ev,_ZTv0_n20_N8S19045C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S19045C9D0Ev,_ZThn204_N8S19045C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn728_N8S19045C9D0Ev,_ZThn428_N8S19045C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C9D1Ev,_ZTv0_n20_N8S19045C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn328_N8S19045C9D1Ev,_ZThn204_N8S19045C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn728_N8S19045C9D1Ev,_ZThn428_N8S19045C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D0Ev,_ZTv0_n20_N9S19045C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N9S19045C12D0Ev,_ZThn116_N9S19045C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn600_N9S19045C12D0Ev,_ZThn340_N9S19045C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C12D1Ev,_ZTv0_n20_N9S19045C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N9S19045C12D1Ev,_ZThn116_N9S19045C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn600_N9S19045C12D1Ev,_ZThn340_N9S19045C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19045C15D0Ev,_ZTv0_n24_N9S19045C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19045C15D0Ev,_ZThn532_N9S19045C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19045C15D1Ev,_ZTv0_n24_N9S19045C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19045C15D1Ev,_ZThn532_N9S19045C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C15D0Ev,_ZTv0_n72_N9S19045C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S19045C15D0Ev,_ZThn632_N9S19045C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C15D1Ev,_ZTv0_n72_N9S19045C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S19045C15D1Ev,_ZThn632_N9S19045C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C15D0Ev,_ZTv0_n20_N9S19045C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn856_N9S19045C15D0Ev,_ZThn512_N9S19045C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C15D1Ev,_ZTv0_n20_N9S19045C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn856_N9S19045C15D1Ev,_ZThn512_N9S19045C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C16D0Ev,_ZTv0_n72_N9S19045C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S19045C16D0Ev,_ZThn632_N9S19045C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N9S19045C16D1Ev,_ZTv0_n72_N9S19045C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S19045C16D1Ev,_ZThn632_N9S19045C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C16D0Ev,_ZTv0_n20_N9S19045C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn856_N9S19045C16D0Ev,_ZThn512_N9S19045C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S19045C16D1Ev,_ZTv0_n20_N9S19045C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn856_N9S19045C16D1Ev,_ZThn512_N9S19045C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19045C1D0Ev,_ZTv0_n28_N8S19045C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1184_N8S19045C1D0Ev,_ZThn724_N8S19045C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S19045C1D1Ev,_ZTv0_n28_N8S19045C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1184_N8S19045C1D1Ev,_ZThn724_N8S19045C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N8S19045C1D0Ev,_ZTv0_n72_N8S19045C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S19045C1D0Ev,_ZThn632_N8S19045C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n144_N8S19045C1D1Ev,_ZTv0_n72_N8S19045C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N8S19045C1D1Ev,_ZThn632_N8S19045C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19045C1D0Ev,_ZTv0_n24_N8S19045C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N8S19045C1D0Ev,_ZThn732_N8S19045C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn880_N8S19045C1D0Ev,_ZThn532_N8S19045C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19045C1D1Ev,_ZTv0_n24_N8S19045C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1200_N8S19045C1D1Ev,_ZThn732_N8S19045C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn880_N8S19045C1D1Ev,_ZThn532_N8S19045C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C1D0Ev,_ZTv0_n20_N8S19045C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn856_N8S19045C1D0Ev,_ZThn512_N8S19045C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S19045C1D1Ev,_ZTv0_n20_N8S19045C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn856_N8S19045C1D1Ev,_ZThn512_N8S19045C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C1D0Ev,_ZTv0_n48_N8S19045C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn752_N8S19045C1D0Ev,_ZThn452_N8S19045C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N8S19045C1D1Ev,_ZTv0_n48_N8S19045C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn752_N8S19045C1D1Ev,_ZThn452_N8S19045C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n184_N8S19045C1D0Ev,_ZTv0_n92_N8S19045C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn496_N8S19045C1D0Ev,_ZThn296_N8S19045C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n184_N8S19045C1D1Ev,_ZTv0_n92_N8S19045C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn496_N8S19045C1D1Ev,_ZThn296_N8S19045C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19045C1 = {  "S19045C1", // class name
  bases_S19045C1, 53,
  &(vtc_S19045C1[0]), // expected_vtbl_contents
  &(vtt_S19045C1[0]), // expected_vtt_contents
  ABISELECT(1296,796), // object size
  NSPAIRA(_ZTI8S19045C1),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S19045C1),728, //virtual function table var
  13, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19045C1),197, //virtual table table var
  53, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1613C5  {
  long double s1613c5f0;
  char  :0;
  short s1613c5f2;
  void  mf1613c5(); // _ZN7S1613C58mf1613c5Ev
};
//SIG(-1 S1613C5) C1{ m FD Fc:0 Fs}


void  S1613C5 ::mf1613c5(){}

static void Test_S1613C5()
{
  {
    init_simple_test("S1613C5");
    static S1613C5 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S1613C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S1613C5)");
    check_field_offset(lv, s1613c5f0, 0, "S1613C5.s1613c5f0");
    check_field_offset(lv, s1613c5f2, ABISELECT(16,12), "S1613C5.s1613c5f2");
  }
}
static Arrange_To_Call_Me vS1613C5(Test_S1613C5, "S1613C5", ABISELECT(32,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S1613C5[];
VTBL_ENTRY *P__ZTI7S1613C5 = _ZTI7S1613C5; 
Class_Descriptor cd_S1613C5 = {  "S1613C5", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI7S1613C5),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1613C4  : virtual S1613C5 {
  unsigned int s1613c4f0:1;
  long s1613c4f1;
  ~S1613C4(); // tgen
  S1613C4(); // tgen
};
//SIG(-1 S1613C4) C1{ VBC2{ m FD Fc:0 Fs} Fi:1 Fl}


S1613C4 ::~S1613C4(){ note_dtor("S1613C4", this);} // tgen
S1613C4 ::S1613C4(){ note_ctor("S1613C4", this);} // tgen

static void Test_S1613C4()
{
  extern Class_Descriptor cd_S1613C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(5,8)];
    init_test(&cd_S1613C4, buf);
    S1613C4 *dp, &lv = *(dp=new (buf) S1613C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,28), "sizeof(S1613C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S1613C4)");
    check_base_class_offset(lv, (S1613C5*), ABISELECT(32,12), "S1613C4");
    set_bf_and_test(lv, s1613c4f0, ABISELECT(8,4), 0, 1, 1, "S1613C4");
    check_field_offset(lv, s1613c4f1, ABISELECT(16,8), "S1613C4.s1613c4f1");
    test_class_info(&lv, &cd_S1613C4);
    dp->~S1613C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1613C4(Test_S1613C4, "S1613C4", ABISELECT(64,28));

#else // __cplusplus

extern void _ZN7S1613C4C1Ev();
extern void _ZN7S1613C4D1Ev();
Name_Map name_map_S1613C4[] = {
  NSPAIR(_ZN7S1613C4C1Ev),
  NSPAIR(_ZN7S1613C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
static Base_Class bases_S1613C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1613C5,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S1613C4[];
static  VTBL_ENTRY vtc_S1613C4[] = {
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI7S1613C4[0]),
};
extern VTBL_ENTRY _ZTV7S1613C4[];
static  VTT_ENTRY vtt_S1613C4[] = {
  {&(_ZTV7S1613C4[3]),  3,3},
};
extern VTBL_ENTRY _ZTI7S1613C4[];
extern  VTBL_ENTRY _ZTV7S1613C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S1613C4[];
Class_Descriptor cd_S1613C4 = {  "S1613C4", // class name
  bases_S1613C4, 1,
  &(vtc_S1613C4[0]), // expected_vtbl_contents
  &(vtt_S1613C4[0]), // expected_vtt_contents
  ABISELECT(64,28), // object size
  NSPAIRA(_ZTI7S1613C4),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S1613C4),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S1613C4),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1613C8  : S1613C5 {
  int s1613c8f0;
  void *s1613c8f1;
};
//SIG(-1 S1613C8) C1{ BC2{ m FD Fc:0 Fs} Fi Fp}



static void Test_S1613C8()
{
  extern Class_Descriptor cd_S1613C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4,7)];
    init_test(&cd_S1613C8, buf);
    S1613C8 &lv = *(new (buf) S1613C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(S1613C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S1613C8)");
    check_base_class_offset(lv, (S1613C5*), 0, "S1613C8");
    check_field_offset(lv, s1613c8f0, ABISELECT(32,16), "S1613C8.s1613c8f0");
    check_field_offset(lv, s1613c8f1, ABISELECT(40,20), "S1613C8.s1613c8f1");
    test_class_info(&lv, &cd_S1613C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1613C8(Test_S1613C8, "S1613C8", ABISELECT(48,24));

#else // __cplusplus

extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
static Base_Class bases_S1613C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1613C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1613C8[];
Class_Descriptor cd_S1613C8 = {  "S1613C8", // class name
  bases_S1613C8, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI7S1613C8),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1613C11  : S1613C8 , virtual S1613C5 {
  int s1613c11f0[2];
  long double s1613c11f1;
  void *s1613c11f2;
  char s1613c11f3[6];
  __tsi64 s1613c11f4;
  ::S1613C8 s1613c11f5[7];
  virtual void  v1(); // _ZN8S1613C112v1Ev
  ~S1613C11(); // tgen
  S1613C11(); // tgen
};
//SIG(-1 S1613C11) C1{ BC2{ BC3{ m FD Fc:0 Fs} Fi Fp} VBC3 v1 Fi[2] FD Fp Fc[6] FL FC2[7]}


void  S1613C11 ::v1(){vfunc_called(this, "_ZN8S1613C112v1Ev");}
S1613C11 ::~S1613C11(){ note_dtor("S1613C11", this);} // tgen
S1613C11 ::S1613C11(){ note_ctor("S1613C11", this);} // tgen

static void Test_S1613C11()
{
  extern Class_Descriptor cd_S1613C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(32,64)];
    init_test(&cd_S1613C11, buf);
    S1613C11 *dp, &lv = *(dp=new (buf) S1613C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(496,252), "sizeof(S1613C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S1613C11)");
    check_base_class_offset(lv, (S1613C5*)(S1613C8*), ABISELECT(16,4), "S1613C11");
    check_base_class_offset(lv, (S1613C8*), ABISELECT(16,4), "S1613C11");
    /*is_ambiguous_... S1613C11::S1613C5 */ AMB_check_base_class_offset(lv, (S1613C5*), ABISELECT(464,236), "S1613C11");
    check_field_offset(lv, s1613c11f0, ABISELECT(64,28), "S1613C11.s1613c11f0");
    check_field_offset(lv, s1613c11f1, ABISELECT(80,36), "S1613C11.s1613c11f1");
    check_field_offset(lv, s1613c11f2, ABISELECT(96,48), "S1613C11.s1613c11f2");
    check_field_offset(lv, s1613c11f3, ABISELECT(104,52), "S1613C11.s1613c11f3");
    check_field_offset(lv, s1613c11f4, ABISELECT(112,60), "S1613C11.s1613c11f4");
    check_field_offset(lv, s1613c11f5, ABISELECT(128,68), "S1613C11.s1613c11f5");
    test_class_info(&lv, &cd_S1613C11);
    dp->~S1613C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1613C11(Test_S1613C11, "S1613C11", ABISELECT(496,252));

#else // __cplusplus

extern void _ZN8S1613C11C1Ev();
extern void _ZN8S1613C11D1Ev();
Name_Map name_map_S1613C11[] = {
  NSPAIR(_ZN8S1613C11C1Ev),
  NSPAIR(_ZN8S1613C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C8;
extern VTBL_ENTRY _ZTI7S1613C8[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
static Base_Class bases_S1613C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1613C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1613C8,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1613C5,    ABISELECT(464,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S1613C11[];
extern void _ZN8S1613C112v1Ev();
static  VTBL_ENTRY vtc_S1613C11[] = {
  ABISELECT(464,236),
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C11[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
};
extern VTBL_ENTRY _ZTV8S1613C11[];
static  VTT_ENTRY vtt_S1613C11[] = {
  {&(_ZTV8S1613C11[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S1613C11[];
extern  VTBL_ENTRY _ZTV8S1613C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1613C11[];
Class_Descriptor cd_S1613C11 = {  "S1613C11", // class name
  bases_S1613C11, 3,
  &(vtc_S1613C11[0]), // expected_vtbl_contents
  &(vtt_S1613C11[0]), // expected_vtt_contents
  ABISELECT(496,252), // object size
  NSPAIRA(_ZTI8S1613C11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S1613C11),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1613C11),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1613C10  : virtual S1613C8 , S1613C11 {
  ::S1613C8 s1613c10f0;
  ::S1613C5 s1613c10f1;
  int s1613c10f2;
  unsigned char s1613c10f3:1;
  short s1613c10f4;
  int s1613c10f5;
  virtual  ~S1613C10(); // _ZN8S1613C10D2Ev
  S1613C10(); // tgen
};
//SIG(-1 S1613C10) C1{ VBC2{ BC3{ m FD Fc:0 Fs} Fi Fp} BC4{ BC2 VBC3 v1 Fi[2] FD Fp Fc[6] FL FC2[7]} vd FC2 FC3 Fi Fc:1 Fs Fi}


 S1613C10 ::~S1613C10(){ note_dtor("S1613C10", this);}
S1613C10 ::S1613C10(){ note_ctor("S1613C10", this);} // tgen

static void Test_S1613C10()
{
  extern Class_Descriptor cd_S1613C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(41,83)];
    init_test(&cd_S1613C10, buf);
    S1613C10 *dp, &lv = *(dp=new (buf) S1613C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(640,328), "sizeof(S1613C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S1613C10)");
    /*is_ambiguous_... S1613C10::S1613C8 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C8*), ABISELECT(560,288), "S1613C10");
    /*is_ambiguous_... S1613C10::S1613C8 */ AMB_check_base_class_offset(lv, (S1613C8*), ABISELECT(560,288), "S1613C10");
    check_base_class_offset(lv, (S1613C5*)(S1613C8*)(S1613C11*), ABISELECT(16,4), "S1613C10");
    check_base_class_offset(lv, (S1613C8*)(S1613C11*), ABISELECT(16,4), "S1613C10");
    /*is_ambiguous_... S1613C11::S1613C5 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C11*), ABISELECT(608,312), "S1613C10");
    check_base_class_offset(lv, (S1613C11*), 0, "S1613C10");
    check_field_offset(lv, s1613c10f0, ABISELECT(464,236), "S1613C10.s1613c10f0");
    check_field_offset(lv, s1613c10f1, ABISELECT(512,260), "S1613C10.s1613c10f1");
    check_field_offset(lv, s1613c10f2, ABISELECT(544,276), "S1613C10.s1613c10f2");
    set_bf_and_test(lv, s1613c10f3, ABISELECT(548,280), 0, 1, 1, "S1613C10");
    check_field_offset(lv, s1613c10f4, ABISELECT(550,282), "S1613C10.s1613c10f4");
    check_field_offset(lv, s1613c10f5, ABISELECT(552,284), "S1613C10.s1613c10f5");
    test_class_info(&lv, &cd_S1613C10);
    dp->~S1613C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1613C10(Test_S1613C10, "S1613C10", ABISELECT(640,328));

#else // __cplusplus

extern void _ZN8S1613C10C1Ev();
extern void _ZN8S1613C10D2Ev();
Name_Map name_map_S1613C10[] = {
  NSPAIR(_ZN8S1613C10C1Ev),
  NSPAIR(_ZN8S1613C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C8;
extern VTBL_ENTRY _ZTI7S1613C8[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C8;
extern VTBL_ENTRY _ZTI7S1613C8[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C11;
extern VTBL_ENTRY _ZTI8S1613C11[];
extern  VTBL_ENTRY _ZTV8S1613C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1613C11[];
static Base_Class bases_S1613C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1613C5,    ABISELECT(560,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1613C8,    ABISELECT(560,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1613C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1613C8,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S1613C5,    ABISELECT(608,312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S1613C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1613C10[];
extern void _ZN8S1613C112v1Ev();
extern void _ZN8S1613C10D1Ev();
extern void _ZN8S1613C10D0Ev();
static  VTBL_ENTRY vtc_S1613C10[] = {
  ABISELECT(560,288),
  ABISELECT(608,312),
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C10[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
  (VTBL_ENTRY)&_ZN8S1613C10D1Ev,
  (VTBL_ENTRY)&_ZN8S1613C10D0Ev,
};
extern VTBL_ENTRY _ZTV8S1613C10[];
extern void _ZN8S1613C112v1Ev();
static  VTBL_ENTRY _tg__ZTV8S1613C11__8S1613C10[] = {
  ABISELECT(608,312),
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C11[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
};
static  VTT_ENTRY vtt_S1613C10[] = {
  {&(_ZTV8S1613C10[4]),  4,7},
  {&(_tg__ZTV8S1613C11__8S1613C10[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S1613C10[];
extern  VTBL_ENTRY _ZTV8S1613C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1613C10[];
Class_Descriptor cd_S1613C10 = {  "S1613C10", // class name
  bases_S1613C10, 6,
  &(vtc_S1613C10[0]), // expected_vtbl_contents
  &(vtt_S1613C10[0]), // expected_vtt_contents
  ABISELECT(640,328), // object size
  NSPAIRA(_ZTI8S1613C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S1613C10),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1613C10),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1613C12  {
  char s1613c12f0;
  int s1613c12f1;
  void *s1613c12f2[2];
  int s1613c12f3;
  long double s1613c12f4[5];
  virtual  ~S1613C12(); // _ZN8S1613C12D1Ev
  virtual void  v2(); // _ZN8S1613C122v2Ev
  S1613C12(); // tgen
};
//SIG(-1 S1613C12) C1{ vd v1 Fc Fi Fp[2] Fi FD[5]}


 S1613C12 ::~S1613C12(){ note_dtor("S1613C12", this);}
void  S1613C12 ::v2(){vfunc_called(this, "_ZN8S1613C122v2Ev");}
S1613C12 ::S1613C12(){ note_ctor("S1613C12", this);} // tgen

static void Test_S1613C12()
{
  extern Class_Descriptor cd_S1613C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,22)];
    init_test(&cd_S1613C12, buf);
    S1613C12 *dp, &lv = *(dp=new (buf) S1613C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,84), "sizeof(S1613C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S1613C12)");
    check_field_offset(lv, s1613c12f0, ABISELECT(8,4), "S1613C12.s1613c12f0");
    check_field_offset(lv, s1613c12f1, ABISELECT(12,8), "S1613C12.s1613c12f1");
    check_field_offset(lv, s1613c12f2, ABISELECT(16,12), "S1613C12.s1613c12f2");
    check_field_offset(lv, s1613c12f3, ABISELECT(32,20), "S1613C12.s1613c12f3");
    check_field_offset(lv, s1613c12f4, ABISELECT(48,24), "S1613C12.s1613c12f4");
    test_class_info(&lv, &cd_S1613C12);
    dp->~S1613C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1613C12(Test_S1613C12, "S1613C12", ABISELECT(128,84));

#else // __cplusplus

extern void _ZN8S1613C12C1Ev();
extern void _ZN8S1613C12D1Ev();
Name_Map name_map_S1613C12[] = {
  NSPAIR(_ZN8S1613C12C1Ev),
  NSPAIR(_ZN8S1613C12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1613C12[];
extern void _ZN8S1613C12D1Ev();
extern void _ZN8S1613C12D0Ev();
extern void _ZN8S1613C122v2Ev();
static  VTBL_ENTRY vtc_S1613C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C12[0]),
  (VTBL_ENTRY)&_ZN8S1613C12D1Ev,
  (VTBL_ENTRY)&_ZN8S1613C12D0Ev,
  (VTBL_ENTRY)&_ZN8S1613C122v2Ev,
};
extern VTBL_ENTRY _ZTI8S1613C12[];
extern  VTBL_ENTRY _ZTV8S1613C12[];
Class_Descriptor cd_S1613C12 = {  "S1613C12", // class name
  0,0,//no base classes
  &(vtc_S1613C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,84), // object size
  NSPAIRA(_ZTI8S1613C12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1613C12),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1613C13  : S1613C11 , S1613C8 , S1613C5 {
  ::S1613C5 s1613c13f0[3];
  __tsi64 s1613c13f1;
  virtual  ~S1613C13(); // _ZN8S1613C13D2Ev
  virtual void  v3(); // _ZN8S1613C132v3Ev
  S1613C13(); // tgen
};
//SIG(-1 S1613C13) C1{ BC2{ BC3{ BC4{ m FD Fc:0 Fs} Fi Fp} VBC4 v2 Fi[2] FD Fp Fc[6] FL FC3[7]} BC3 BC4 vd v1 FC4[3] FL}


 S1613C13 ::~S1613C13(){ note_dtor("S1613C13", this);}
void  S1613C13 ::v3(){vfunc_called(this, "_ZN8S1613C132v3Ev");}
S1613C13 ::S1613C13(){ note_ctor("S1613C13", this);} // tgen

static void Test_S1613C13()
{
  extern Class_Descriptor cd_S1613C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(44,88)];
    init_test(&cd_S1613C13, buf);
    S1613C13 *dp, &lv = *(dp=new (buf) S1613C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(688,348), "sizeof(S1613C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S1613C13)");
    check_base_class_offset(lv, (S1613C5*)(S1613C8*)(S1613C11*), ABISELECT(16,4), "S1613C13");
    check_base_class_offset(lv, (S1613C8*)(S1613C11*), ABISELECT(16,4), "S1613C13");
    /*is_ambiguous_... S1613C11::S1613C5 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C11*), ABISELECT(656,332), "S1613C13");
    check_base_class_offset(lv, (S1613C11*), 0, "S1613C13");
    /*is_ambiguous_... S1613C13::S1613C8 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C8*), ABISELECT(464,236), "S1613C13");
    /*is_ambiguous_... S1613C13::S1613C8 */ AMB_check_base_class_offset(lv, (S1613C8*), ABISELECT(464,236), "S1613C13");
    /*is_ambiguous_... S1613C13::S1613C5 */ AMB_check_base_class_offset(lv, (S1613C5*), ABISELECT(512,260), "S1613C13");
    check_field_offset(lv, s1613c13f0, ABISELECT(544,276), "S1613C13.s1613c13f0");
    check_field_offset(lv, s1613c13f1, ABISELECT(640,324), "S1613C13.s1613c13f1");
    test_class_info(&lv, &cd_S1613C13);
    dp->~S1613C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1613C13(Test_S1613C13, "S1613C13", ABISELECT(688,348));

#else // __cplusplus

extern void _ZN8S1613C13C1Ev();
extern void _ZN8S1613C13D2Ev();
Name_Map name_map_S1613C13[] = {
  NSPAIR(_ZN8S1613C13C1Ev),
  NSPAIR(_ZN8S1613C13D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C8;
extern VTBL_ENTRY _ZTI7S1613C8[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C11;
extern VTBL_ENTRY _ZTI8S1613C11[];
extern  VTBL_ENTRY _ZTV8S1613C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1613C11[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C8;
extern VTBL_ENTRY _ZTI7S1613C8[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
static Base_Class bases_S1613C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1613C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1613C8,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1613C5,    ABISELECT(656,332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S1613C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1613C5,    ABISELECT(464,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S1613C8,    ABISELECT(464,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1613C5,    ABISELECT(512,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1613C13[];
extern void _ZN8S1613C112v1Ev();
extern void _ZN8S1613C13D1Ev();
extern void _ZN8S1613C13D0Ev();
extern void _ZN8S1613C132v3Ev();
static  VTBL_ENTRY vtc_S1613C13[] = {
  ABISELECT(656,332),
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C13[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
  (VTBL_ENTRY)&_ZN8S1613C13D1Ev,
  (VTBL_ENTRY)&_ZN8S1613C13D0Ev,
  (VTBL_ENTRY)&_ZN8S1613C132v3Ev,
};
extern VTBL_ENTRY _ZTV8S1613C13[];
extern void _ZN8S1613C112v1Ev();
static  VTBL_ENTRY _tg__ZTV8S1613C11__8S1613C13[] = {
  ABISELECT(656,332),
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C11[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
};
static  VTT_ENTRY vtt_S1613C13[] = {
  {&(_ZTV8S1613C13[3]),  3,7},
  {&(_tg__ZTV8S1613C11__8S1613C13[3]),  3,4},
};
extern VTBL_ENTRY _ZTI8S1613C13[];
extern  VTBL_ENTRY _ZTV8S1613C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1613C13[];
Class_Descriptor cd_S1613C13 = {  "S1613C13", // class name
  bases_S1613C13, 7,
  &(vtc_S1613C13[0]), // expected_vtbl_contents
  &(vtt_S1613C13[0]), // expected_vtt_contents
  ABISELECT(688,348), // object size
  NSPAIRA(_ZTI8S1613C13),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S1613C13),7, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1613C13),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1613C9  : S1613C10 , virtual S1613C12 , virtual S1613C11 , S1613C13 {
  void *s1613c9f0[2];
  virtual  ~S1613C9(); // _ZN7S1613C9D2Ev
  S1613C9(); // tgen
};
//SIG(-1 S1613C9) C1{ BC2{ VBC3{ BC4{ m FD Fc:0 Fs} Fi Fp} BC5{ BC3 VBC4 v1 Fi[2] FD Fp Fc[6] FL FC3[7]} vd FC3 FC4 Fi Fc:1 Fs Fi} VBC6{ vd v2 Fc Fi Fp[2] Fi FD[5]} VBC5 BC7{ BC5 BC3 BC4 vd v3 FC4[3] FL} vd Fp[2]}


 S1613C9 ::~S1613C9(){ note_dtor("S1613C9", this);}
S1613C9 ::S1613C9(){ note_ctor("S1613C9", this);} // tgen

static void Test_S1613C9()
{
  extern Class_Descriptor cd_S1613C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(120,248)];
    init_test(&cd_S1613C9, buf);
    S1613C9 *dp, &lv = *(dp=new (buf) S1613C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1904,988), "sizeof(S1613C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S1613C9)");
    /*is_ambiguous_... S1613C9::S1613C8 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C8*), ABISELECT(1232,628), "S1613C9");
    /*is_ambiguous_... S1613C10::S1613C8 */ AMB_check_base_class_offset(lv, (S1613C8*)(S1613C10*), ABISELECT(1232,628), "S1613C9");
    check_base_class_offset(lv, (S1613C5*)(S1613C8*)(S1613C11*)(S1613C10*), ABISELECT(16,4), "S1613C9");
    check_base_class_offset(lv, (S1613C8*)(S1613C11*)(S1613C10*), ABISELECT(16,4), "S1613C9");
    /*is_ambiguous_... S1613C11::S1613C5 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C11*)(S1613C10*), ABISELECT(1280,652), "S1613C9");
    /*is_ambiguous_... S1613C9::S1613C11 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C11*), ABISELECT(1280,652), "S1613C9");
    /*is_ambiguous_... S1613C11::S1613C5 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C11*)(S1613C13*), ABISELECT(1280,652), "S1613C9");
    check_base_class_offset(lv, (S1613C11*)(S1613C10*), 0, "S1613C9");
    check_base_class_offset(lv, (S1613C10*), 0, "S1613C9");
    check_base_class_offset(lv, (S1613C12*), ABISELECT(1312,668), "S1613C9");
    /*is_ambiguous_... S1613C9::S1613C11 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C8*)(S1613C11*), ABISELECT(1456,756), "S1613C9");
    /*is_ambiguous_... S1613C9::S1613C11 */ AMB_check_base_class_offset(lv, (S1613C8*)(S1613C11*), ABISELECT(1456,756), "S1613C9");
    /*is_ambiguous_... S1613C9::S1613C11 */ AMB_check_base_class_offset(lv, (S1613C11*), ABISELECT(1440,752), "S1613C9");
    check_base_class_offset(lv, (S1613C5*)(S1613C8*)(S1613C11*)(S1613C13*), ABISELECT(576,292), "S1613C9");
    check_base_class_offset(lv, (S1613C8*)(S1613C11*)(S1613C13*), ABISELECT(576,292), "S1613C9");
    check_base_class_offset(lv, (S1613C11*)(S1613C13*), ABISELECT(560,288), "S1613C9");
    /*is_ambiguous_... S1613C13::S1613C8 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C8*)(S1613C13*), ABISELECT(1024,524), "S1613C9");
    /*is_ambiguous_... S1613C13::S1613C8 */ AMB_check_base_class_offset(lv, (S1613C8*)(S1613C13*), ABISELECT(1024,524), "S1613C9");
    /*is_ambiguous_... S1613C13::S1613C5 */ AMB_check_base_class_offset(lv, (S1613C5*)(S1613C13*), ABISELECT(1072,548), "S1613C9");
    check_base_class_offset(lv, (S1613C13*), ABISELECT(560,288), "S1613C9");
    check_field_offset(lv, s1613c9f0, ABISELECT(1208,620), "S1613C9.s1613c9f0");
    test_class_info(&lv, &cd_S1613C9);
    dp->~S1613C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1613C9(Test_S1613C9, "S1613C9", ABISELECT(1904,988));

#else // __cplusplus

extern void _ZN7S1613C9C1Ev();
extern void _ZN7S1613C9D2Ev();
Name_Map name_map_S1613C9[] = {
  NSPAIR(_ZN7S1613C9C1Ev),
  NSPAIR(_ZN7S1613C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C8;
extern VTBL_ENTRY _ZTI7S1613C8[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C8;
extern VTBL_ENTRY _ZTI7S1613C8[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C11;
extern VTBL_ENTRY _ZTI8S1613C11[];
extern  VTBL_ENTRY _ZTV8S1613C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1613C11[];
extern Class_Descriptor cd_S1613C10;
extern VTBL_ENTRY _ZTI8S1613C10[];
extern  VTBL_ENTRY _ZTV8S1613C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1613C10[];
extern Class_Descriptor cd_S1613C12;
extern VTBL_ENTRY _ZTI8S1613C12[];
extern  VTBL_ENTRY _ZTV8S1613C12[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C8;
extern VTBL_ENTRY _ZTI7S1613C8[];
extern Class_Descriptor cd_S1613C11;
extern VTBL_ENTRY _ZTI8S1613C11[];
extern  VTBL_ENTRY _ZTV8S1613C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1613C11[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C8;
extern VTBL_ENTRY _ZTI7S1613C8[];
extern Class_Descriptor cd_S1613C11;
extern VTBL_ENTRY _ZTI8S1613C11[];
extern  VTBL_ENTRY _ZTV8S1613C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1613C11[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C8;
extern VTBL_ENTRY _ZTI7S1613C8[];
extern Class_Descriptor cd_S1613C5;
extern VTBL_ENTRY _ZTI7S1613C5[];
extern Class_Descriptor cd_S1613C13;
extern VTBL_ENTRY _ZTI8S1613C13[];
extern  VTBL_ENTRY _ZTV8S1613C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1613C13[];
static Base_Class bases_S1613C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1613C5,    ABISELECT(1232,628), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1613C8,    ABISELECT(1232,628), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S1613C5,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1613C8,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S1613C5,    ABISELECT(1280,652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S1613C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S1613C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1613C12,    ABISELECT(1312,668), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1613C5,    ABISELECT(1456,756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S1613C8,    ABISELECT(1456,756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S1613C11,    ABISELECT(1440,752), //bcp->offset
    23, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1613C5,    ABISELECT(576,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S1613C8,    ABISELECT(576,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S1613C11,    ABISELECT(560,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S1613C5,    ABISELECT(1024,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S1613C8,    ABISELECT(1024,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S1613C5,    ABISELECT(1072,548), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S1613C13,    ABISELECT(560,288), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1613C9[];
extern void _ZN8S1613C112v1Ev();
extern void _ZN7S1613C9D1Ev();
extern void _ZN7S1613C9D0Ev();
extern void _ZN8S1613C112v1Ev();
extern void ABISELECT(_ZThn560_N7S1613C9D1Ev,_ZThn288_N7S1613C9D1Ev)();
extern void ABISELECT(_ZThn560_N7S1613C9D0Ev,_ZThn288_N7S1613C9D0Ev)();
extern void _ZN8S1613C132v3Ev();
extern void ABISELECT(_ZTv0_n24_N7S1613C9D1Ev,_ZTv0_n12_N7S1613C9D1Ev)();
extern void ABISELECT(_ZThn1312_N7S1613C9D1Ev,_ZThn668_N7S1613C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1613C9D0Ev,_ZTv0_n12_N7S1613C9D0Ev)();
extern void ABISELECT(_ZThn1312_N7S1613C9D0Ev,_ZThn668_N7S1613C9D0Ev)() __attribute__((weak));
extern void _ZN8S1613C122v2Ev();
extern void _ZN8S1613C112v1Ev();
static  VTBL_ENTRY vtc_S1613C9[] = {
  ABISELECT(1440,752),
  ABISELECT(1312,668),
  ABISELECT(1232,628),
  ABISELECT(1280,652),
  0,
  (VTBL_ENTRY)&(_ZTI7S1613C9[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
  (VTBL_ENTRY)&_ZN7S1613C9D1Ev,
  (VTBL_ENTRY)&_ZN7S1613C9D0Ev,
  ABISELECT(720,364),
  ABISELECT(-560,-288),
  (VTBL_ENTRY)&(_ZTI7S1613C9[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N7S1613C9D1Ev,_ZThn288_N7S1613C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn560_N7S1613C9D0Ev,_ZThn288_N7S1613C9D0Ev),
  (VTBL_ENTRY)&_ZN8S1613C132v3Ev,
  0,
  ABISELECT(-1312,-668),
  ABISELECT(-1312,-668),
  (VTBL_ENTRY)&(_ZTI7S1613C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1613C9D1Ev,_ZTv0_n12_N7S1613C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1613C9D0Ev,_ZTv0_n12_N7S1613C9D0Ev),
  (VTBL_ENTRY)&_ZN8S1613C122v2Ev,
  0,
  ABISELECT(-160,-100),
  ABISELECT(-1440,-752),
  (VTBL_ENTRY)&(_ZTI7S1613C9[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
};
extern VTBL_ENTRY _ZTV7S1613C9[];
extern void _ZN8S1613C112v1Ev();
extern void _ZN8S1613C10D1Ev();
extern void _ZN8S1613C10D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1613C10__7S1613C9[] = {
  ABISELECT(1232,628),
  ABISELECT(1280,652),
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C10[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
  (VTBL_ENTRY)&_ZN8S1613C10D1Ev,
  (VTBL_ENTRY)&_ZN8S1613C10D0Ev,
};
extern void _ZN8S1613C112v1Ev();
static  VTBL_ENTRY _tg__ZTV8S1613C118S1613C10__7S1613C9[] = {
  ABISELECT(1280,652),
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C11[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
};
extern void _ZN8S1613C112v1Ev();
extern void _ZN8S1613C13D1Ev();
extern void _ZN8S1613C13D0Ev();
extern void _ZN8S1613C132v3Ev();
static  VTBL_ENTRY _tg__ZTV8S1613C13__7S1613C9[] = {
  ABISELECT(720,364),
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C13[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
  (VTBL_ENTRY)&_ZN8S1613C13D1Ev,
  (VTBL_ENTRY)&_ZN8S1613C13D0Ev,
  (VTBL_ENTRY)&_ZN8S1613C132v3Ev,
};
extern void _ZN8S1613C112v1Ev();
static  VTBL_ENTRY _tg__ZTV8S1613C118S1613C13__A2__7S1613C9[] = {
  ABISELECT(720,364),
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C11[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
};
extern void _ZN8S1613C112v1Ev();
static  VTBL_ENTRY _tg__ZTV8S1613C11__A1__7S1613C9[] = {
  ABISELECT(-160,-100),
  0,
  (VTBL_ENTRY)&(_ZTI8S1613C11[0]),
  (VTBL_ENTRY)&_ZN8S1613C112v1Ev,
};
static  VTT_ENTRY vtt_S1613C9[] = {
  {&(_ZTV7S1613C9[6]),  6,28},
  {&(_tg__ZTV8S1613C10__7S1613C9[4]),  4,7},
  {&(_tg__ZTV8S1613C118S1613C10__7S1613C9[3]),  3,4},
  {&(_tg__ZTV8S1613C13__7S1613C9[3]),  3,7},
  {&(_tg__ZTV8S1613C118S1613C13__A2__7S1613C9[3]),  3,4},
  {&(_ZTV7S1613C9[20]),  20,28},
  {&(_ZTV7S1613C9[27]),  27,28},
  {&(_ZTV7S1613C9[12]),  12,28},
  {&(_tg__ZTV8S1613C11__A1__7S1613C9[3]),  3,4},
};
extern VTBL_ENTRY _ZTI7S1613C9[];
extern  VTBL_ENTRY _ZTV7S1613C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S1613C9[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1613C9D0Ev,_ZTv0_n12_N7S1613C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1312_N7S1613C9D0Ev,_ZThn668_N7S1613C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1613C9D1Ev,_ZTv0_n12_N7S1613C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1312_N7S1613C9D1Ev,_ZThn668_N7S1613C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S1613C9 = {  "S1613C9", // class name
  bases_S1613C9, 18,
  &(vtc_S1613C9[0]), // expected_vtbl_contents
  &(vtt_S1613C9[0]), // expected_vtt_contents
  ABISELECT(1904,988), // object size
  NSPAIRA(_ZTI7S1613C9),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S1613C9),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S1613C9),9, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//====================================================================