// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S1502C5_nt  {
  int s1502c5f0[2];
  void  mf1502c5(); // _ZN10S1502C5_nt8mf1502c5Ev
};
//SIG(-1 S1502C5_nt) C1{ m Fi[2]}


void  S1502C5_nt ::mf1502c5(){}

//skip512 S1502C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C4_nt  {
  int s1502c4f0;
  __tsi64 s1502c4f1;
  void *s1502c4f2[4];
  int s1502c4f3[2];
  void *s1502c4f4;
  ::S1502C5_nt s1502c4f5;
  void *s1502c4f6[2];
  virtual  ~S1502C4_nt(); // _ZN10S1502C4_ntD1Ev
  virtual void  v6(); // _ZN10S1502C4_nt2v6Ev
  virtual void  v7(); // _ZN10S1502C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1502C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1502C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1502C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1502C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1502C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1502C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1502C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1502C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1502C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1502C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1502C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1502C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1502C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1502C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1502C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1502C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1502C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1502C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1502C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1502C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1502C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1502C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1502C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1502C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1502C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1502C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1502C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1502C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1502C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1502C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1502C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1502C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1502C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1502C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1502C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1502C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1502C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1502C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1502C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1502C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1502C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1502C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1502C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1502C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1502C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1502C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1502C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1502C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1502C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1502C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1502C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1502C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1502C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1502C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1502C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1502C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1502C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1502C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1502C4_nt3v66Ev
  virtual void  v67(); // _ZN10S1502C4_nt3v67Ev
  virtual void  v68(); // _ZN10S1502C4_nt3v68Ev
  virtual void  v69(); // _ZN10S1502C4_nt3v69Ev
  S1502C4_nt(); // tgen
};
//SIG(-1 S1502C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1502C4_nt ::~S1502C4_nt(){ note_dtor("S1502C4_nt", this);}
void  S1502C4_nt ::v6(){vfunc_called(this, "_ZN10S1502C4_nt2v6Ev");}
void  S1502C4_nt ::v7(){vfunc_called(this, "_ZN10S1502C4_nt2v7Ev");}
void  S1502C4_nt ::v8(){vfunc_called(this, "_ZN10S1502C4_nt2v8Ev");}
void  S1502C4_nt ::v9(){vfunc_called(this, "_ZN10S1502C4_nt2v9Ev");}
void  S1502C4_nt ::v10(){vfunc_called(this, "_ZN10S1502C4_nt3v10Ev");}
void  S1502C4_nt ::v11(){vfunc_called(this, "_ZN10S1502C4_nt3v11Ev");}
void  S1502C4_nt ::v12(){vfunc_called(this, "_ZN10S1502C4_nt3v12Ev");}
void  S1502C4_nt ::v13(){vfunc_called(this, "_ZN10S1502C4_nt3v13Ev");}
void  S1502C4_nt ::v14(){vfunc_called(this, "_ZN10S1502C4_nt3v14Ev");}
void  S1502C4_nt ::v15(){vfunc_called(this, "_ZN10S1502C4_nt3v15Ev");}
void  S1502C4_nt ::v16(){vfunc_called(this, "_ZN10S1502C4_nt3v16Ev");}
void  S1502C4_nt ::v17(){vfunc_called(this, "_ZN10S1502C4_nt3v17Ev");}
void  S1502C4_nt ::v18(){vfunc_called(this, "_ZN10S1502C4_nt3v18Ev");}
void  S1502C4_nt ::v19(){vfunc_called(this, "_ZN10S1502C4_nt3v19Ev");}
void  S1502C4_nt ::v20(){vfunc_called(this, "_ZN10S1502C4_nt3v20Ev");}
void  S1502C4_nt ::v21(){vfunc_called(this, "_ZN10S1502C4_nt3v21Ev");}
void  S1502C4_nt ::v22(){vfunc_called(this, "_ZN10S1502C4_nt3v22Ev");}
void  S1502C4_nt ::v23(){vfunc_called(this, "_ZN10S1502C4_nt3v23Ev");}
void  S1502C4_nt ::v24(){vfunc_called(this, "_ZN10S1502C4_nt3v24Ev");}
void  S1502C4_nt ::v25(){vfunc_called(this, "_ZN10S1502C4_nt3v25Ev");}
void  S1502C4_nt ::v26(){vfunc_called(this, "_ZN10S1502C4_nt3v26Ev");}
void  S1502C4_nt ::v27(){vfunc_called(this, "_ZN10S1502C4_nt3v27Ev");}
void  S1502C4_nt ::v28(){vfunc_called(this, "_ZN10S1502C4_nt3v28Ev");}
void  S1502C4_nt ::v29(){vfunc_called(this, "_ZN10S1502C4_nt3v29Ev");}
void  S1502C4_nt ::v30(){vfunc_called(this, "_ZN10S1502C4_nt3v30Ev");}
void  S1502C4_nt ::v31(){vfunc_called(this, "_ZN10S1502C4_nt3v31Ev");}
void  S1502C4_nt ::v32(){vfunc_called(this, "_ZN10S1502C4_nt3v32Ev");}
void  S1502C4_nt ::v33(){vfunc_called(this, "_ZN10S1502C4_nt3v33Ev");}
void  S1502C4_nt ::v34(){vfunc_called(this, "_ZN10S1502C4_nt3v34Ev");}
void  S1502C4_nt ::v35(){vfunc_called(this, "_ZN10S1502C4_nt3v35Ev");}
void  S1502C4_nt ::v36(){vfunc_called(this, "_ZN10S1502C4_nt3v36Ev");}
void  S1502C4_nt ::v37(){vfunc_called(this, "_ZN10S1502C4_nt3v37Ev");}
void  S1502C4_nt ::v38(){vfunc_called(this, "_ZN10S1502C4_nt3v38Ev");}
void  S1502C4_nt ::v39(){vfunc_called(this, "_ZN10S1502C4_nt3v39Ev");}
void  S1502C4_nt ::v40(){vfunc_called(this, "_ZN10S1502C4_nt3v40Ev");}
void  S1502C4_nt ::v41(){vfunc_called(this, "_ZN10S1502C4_nt3v41Ev");}
void  S1502C4_nt ::v42(){vfunc_called(this, "_ZN10S1502C4_nt3v42Ev");}
void  S1502C4_nt ::v43(){vfunc_called(this, "_ZN10S1502C4_nt3v43Ev");}
void  S1502C4_nt ::v44(){vfunc_called(this, "_ZN10S1502C4_nt3v44Ev");}
void  S1502C4_nt ::v45(){vfunc_called(this, "_ZN10S1502C4_nt3v45Ev");}
void  S1502C4_nt ::v46(){vfunc_called(this, "_ZN10S1502C4_nt3v46Ev");}
void  S1502C4_nt ::v47(){vfunc_called(this, "_ZN10S1502C4_nt3v47Ev");}
void  S1502C4_nt ::v48(){vfunc_called(this, "_ZN10S1502C4_nt3v48Ev");}
void  S1502C4_nt ::v49(){vfunc_called(this, "_ZN10S1502C4_nt3v49Ev");}
void  S1502C4_nt ::v50(){vfunc_called(this, "_ZN10S1502C4_nt3v50Ev");}
void  S1502C4_nt ::v51(){vfunc_called(this, "_ZN10S1502C4_nt3v51Ev");}
void  S1502C4_nt ::v52(){vfunc_called(this, "_ZN10S1502C4_nt3v52Ev");}
void  S1502C4_nt ::v53(){vfunc_called(this, "_ZN10S1502C4_nt3v53Ev");}
void  S1502C4_nt ::v54(){vfunc_called(this, "_ZN10S1502C4_nt3v54Ev");}
void  S1502C4_nt ::v55(){vfunc_called(this, "_ZN10S1502C4_nt3v55Ev");}
void  S1502C4_nt ::v56(){vfunc_called(this, "_ZN10S1502C4_nt3v56Ev");}
void  S1502C4_nt ::v57(){vfunc_called(this, "_ZN10S1502C4_nt3v57Ev");}
void  S1502C4_nt ::v58(){vfunc_called(this, "_ZN10S1502C4_nt3v58Ev");}
void  S1502C4_nt ::v59(){vfunc_called(this, "_ZN10S1502C4_nt3v59Ev");}
void  S1502C4_nt ::v60(){vfunc_called(this, "_ZN10S1502C4_nt3v60Ev");}
void  S1502C4_nt ::v61(){vfunc_called(this, "_ZN10S1502C4_nt3v61Ev");}
void  S1502C4_nt ::v62(){vfunc_called(this, "_ZN10S1502C4_nt3v62Ev");}
void  S1502C4_nt ::v63(){vfunc_called(this, "_ZN10S1502C4_nt3v63Ev");}
void  S1502C4_nt ::v64(){vfunc_called(this, "_ZN10S1502C4_nt3v64Ev");}
void  S1502C4_nt ::v65(){vfunc_called(this, "_ZN10S1502C4_nt3v65Ev");}
void  S1502C4_nt ::v66(){vfunc_called(this, "_ZN10S1502C4_nt3v66Ev");}
void  S1502C4_nt ::v67(){vfunc_called(this, "_ZN10S1502C4_nt3v67Ev");}
void  S1502C4_nt ::v68(){vfunc_called(this, "_ZN10S1502C4_nt3v68Ev");}
void  S1502C4_nt ::v69(){vfunc_called(this, "_ZN10S1502C4_nt3v69Ev");}
S1502C4_nt ::S1502C4_nt(){ note_ctor("S1502C4_nt", this);} // tgen

//skip512 S1502C4_nt

#else // __cplusplus

extern void _ZN10S1502C4_ntC1Ev();
extern void _ZN10S1502C4_ntD1Ev();
Name_Map name_map_S1502C4_nt[] = {
  NSPAIR(_ZN10S1502C4_ntC1Ev),
  NSPAIR(_ZN10S1502C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1502C4_nt[];
extern void _ZN10S1502C4_ntD1Ev();
extern void _ZN10S1502C4_ntD0Ev();
extern void _ZN10S1502C4_nt2v6Ev();
extern void _ZN10S1502C4_nt2v7Ev();
extern void _ZN10S1502C4_nt2v8Ev();
extern void _ZN10S1502C4_nt2v9Ev();
extern void _ZN10S1502C4_nt3v10Ev();
extern void _ZN10S1502C4_nt3v11Ev();
extern void _ZN10S1502C4_nt3v12Ev();
extern void _ZN10S1502C4_nt3v13Ev();
extern void _ZN10S1502C4_nt3v14Ev();
extern void _ZN10S1502C4_nt3v15Ev();
extern void _ZN10S1502C4_nt3v16Ev();
extern void _ZN10S1502C4_nt3v17Ev();
extern void _ZN10S1502C4_nt3v18Ev();
extern void _ZN10S1502C4_nt3v19Ev();
extern void _ZN10S1502C4_nt3v20Ev();
extern void _ZN10S1502C4_nt3v21Ev();
extern void _ZN10S1502C4_nt3v22Ev();
extern void _ZN10S1502C4_nt3v23Ev();
extern void _ZN10S1502C4_nt3v24Ev();
extern void _ZN10S1502C4_nt3v25Ev();
extern void _ZN10S1502C4_nt3v26Ev();
extern void _ZN10S1502C4_nt3v27Ev();
extern void _ZN10S1502C4_nt3v28Ev();
extern void _ZN10S1502C4_nt3v29Ev();
extern void _ZN10S1502C4_nt3v30Ev();
extern void _ZN10S1502C4_nt3v31Ev();
extern void _ZN10S1502C4_nt3v32Ev();
extern void _ZN10S1502C4_nt3v33Ev();
extern void _ZN10S1502C4_nt3v34Ev();
extern void _ZN10S1502C4_nt3v35Ev();
extern void _ZN10S1502C4_nt3v36Ev();
extern void _ZN10S1502C4_nt3v37Ev();
extern void _ZN10S1502C4_nt3v38Ev();
extern void _ZN10S1502C4_nt3v39Ev();
extern void _ZN10S1502C4_nt3v40Ev();
extern void _ZN10S1502C4_nt3v41Ev();
extern void _ZN10S1502C4_nt3v42Ev();
extern void _ZN10S1502C4_nt3v43Ev();
extern void _ZN10S1502C4_nt3v44Ev();
extern void _ZN10S1502C4_nt3v45Ev();
extern void _ZN10S1502C4_nt3v46Ev();
extern void _ZN10S1502C4_nt3v47Ev();
extern void _ZN10S1502C4_nt3v48Ev();
extern void _ZN10S1502C4_nt3v49Ev();
extern void _ZN10S1502C4_nt3v50Ev();
extern void _ZN10S1502C4_nt3v51Ev();
extern void _ZN10S1502C4_nt3v52Ev();
extern void _ZN10S1502C4_nt3v53Ev();
extern void _ZN10S1502C4_nt3v54Ev();
extern void _ZN10S1502C4_nt3v55Ev();
extern void _ZN10S1502C4_nt3v56Ev();
extern void _ZN10S1502C4_nt3v57Ev();
extern void _ZN10S1502C4_nt3v58Ev();
extern void _ZN10S1502C4_nt3v59Ev();
extern void _ZN10S1502C4_nt3v60Ev();
extern void _ZN10S1502C4_nt3v61Ev();
extern void _ZN10S1502C4_nt3v62Ev();
extern void _ZN10S1502C4_nt3v63Ev();
extern void _ZN10S1502C4_nt3v64Ev();
extern void _ZN10S1502C4_nt3v65Ev();
extern void _ZN10S1502C4_nt3v66Ev();
extern void _ZN10S1502C4_nt3v67Ev();
extern void _ZN10S1502C4_nt3v68Ev();
extern void _ZN10S1502C4_nt3v69Ev();
static  VTBL_ENTRY vtc_S1502C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1502C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1502C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI10S1502C4_nt[];
VTBL_ENTRY *P__ZTI10S1502C4_nt = _ZTI10S1502C4_nt; 
extern  VTBL_ENTRY _ZTV10S1502C4_nt[];
Class_Descriptor cd_S1502C4_nt = {  "S1502C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1502C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1502C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1502C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C8_nt  {
  void *s1502c8f0;
  int s1502c8f1[2];
  void  mf1502c8(); // _ZN10S1502C8_nt8mf1502c8Ev
};
//SIG(-1 S1502C8_nt) C1{ m Fp Fi[2]}


void  S1502C8_nt ::mf1502c8(){}

//skip512 S1502C8_nt

#else // __cplusplus

Class_Descriptor cd_S1502C8_nt = {  "S1502C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C7_nt  : S1502C8_nt {
};
//SIG(-1 S1502C7_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1502C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
static Base_Class bases_S1502C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1502C7_nt = {  "S1502C7_nt", // class name
  bases_S1502C7_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C6_nt  : S1502C7_nt {
};
//SIG(-1 S1502C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1502C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
extern Class_Descriptor cd_S1502C7_nt;
static Base_Class bases_S1502C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1502C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C9_nt  {
  int s1502c9f0;
  void  mf1502c9(); // _ZN10S1502C9_nt8mf1502c9Ev
};
//SIG(-1 S1502C9_nt) C1{ m Fi}


void  S1502C9_nt ::mf1502c9(){}

//skip512 S1502C9_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S1502C9_nt[];
VTBL_ENTRY *P__ZTI10S1502C9_nt = _ZTI10S1502C9_nt; 
Class_Descriptor cd_S1502C9_nt = {  "S1502C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S1502C9_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C13  : S1502C8_nt {
};
//SIG(-1 S1502C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1502C13()
{
  extern Class_Descriptor cd_S1502C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1502C13, buf);
    S1502C13 &lv = *(new (buf) S1502C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1502C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1502C13)");
    check_base_class_offset(lv, (S1502C8_nt*), 0, "S1502C13");
    test_class_info(&lv, &cd_S1502C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1502C13(Test_S1502C13, "S1502C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
static Base_Class bases_S1502C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1502C13 = {  "S1502C13", // class name
  bases_S1502C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C12  : S1502C13 {
};
//SIG(-1 S1502C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1502C12()
{
  extern Class_Descriptor cd_S1502C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1502C12, buf);
    S1502C12 &lv = *(new (buf) S1502C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1502C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1502C12)");
    check_base_class_offset(lv, (S1502C8_nt*)(S1502C13*), 0, "S1502C12");
    check_base_class_offset(lv, (S1502C13*), 0, "S1502C12");
    test_class_info(&lv, &cd_S1502C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1502C12(Test_S1502C12, "S1502C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
extern Class_Descriptor cd_S1502C13;
static Base_Class bases_S1502C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1502C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1502C12 = {  "S1502C12", // class name
  bases_S1502C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C14_nt  {
  int s1502c14f0[3];
  void  mf1502c14(); // _ZN11S1502C14_nt9mf1502c14Ev
};
//SIG(-1 S1502C14_nt) C1{ m Fi[3]}


void  S1502C14_nt ::mf1502c14(){}

//skip512 S1502C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C19  : S1502C8_nt {
};
//SIG(-1 S1502C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1502C19()
{
  extern Class_Descriptor cd_S1502C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1502C19, buf);
    S1502C19 &lv = *(new (buf) S1502C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1502C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1502C19)");
    check_base_class_offset(lv, (S1502C8_nt*), 0, "S1502C19");
    test_class_info(&lv, &cd_S1502C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1502C19(Test_S1502C19, "S1502C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
static Base_Class bases_S1502C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1502C19 = {  "S1502C19", // class name
  bases_S1502C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C18  : S1502C19 {
};
//SIG(-1 S1502C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1502C18()
{
  extern Class_Descriptor cd_S1502C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1502C18, buf);
    S1502C18 &lv = *(new (buf) S1502C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1502C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1502C18)");
    check_base_class_offset(lv, (S1502C8_nt*)(S1502C19*), 0, "S1502C18");
    check_base_class_offset(lv, (S1502C19*), 0, "S1502C18");
    test_class_info(&lv, &cd_S1502C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1502C18(Test_S1502C18, "S1502C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
extern Class_Descriptor cd_S1502C19;
static Base_Class bases_S1502C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1502C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1502C18 = {  "S1502C18", // class name
  bases_S1502C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C3_nt  : S1502C4_nt {
  ::S1502C6_nt s1502c3f0;
  ::S1502C6_nt s1502c3f1;
  ::S1502C9_nt s1502c3f2;
  int s1502c3f3;
  char s1502c3f4[4];
  void *s1502c3f5[2];
  ::S1502C6_nt s1502c3f6;
  unsigned int s1502c3f7:1;
  unsigned int s1502c3f8:1;
  unsigned int s1502c3f9:1;
  unsigned int s1502c3f10:1;
  unsigned int s1502c3f11:1;
  unsigned int s1502c3f12:1;
  unsigned int s1502c3f13:1;
  unsigned int s1502c3f14:1;
  unsigned int s1502c3f15:1;
  unsigned int s1502c3f16:1;
  unsigned int s1502c3f17:1;
  unsigned int s1502c3f18:1;
  unsigned int s1502c3f19:1;
  unsigned int s1502c3f20:1;
  unsigned int s1502c3f21:1;
  unsigned int s1502c3f22:1;
  unsigned int s1502c3f23:1;
  unsigned int s1502c3f24:1;
  unsigned int s1502c3f25:1;
  unsigned int s1502c3f26:1;
  unsigned int s1502c3f27:1;
  unsigned int s1502c3f28:1;
  unsigned int s1502c3f29:1;
  unsigned int s1502c3f30:1;
  unsigned int s1502c3f31:1;
  unsigned int s1502c3f32:1;
  unsigned int s1502c3f33:1;
  unsigned int s1502c3f34:1;
  unsigned int s1502c3f35:1;
  unsigned int s1502c3f36:1;
  unsigned int s1502c3f37:1;
  unsigned int s1502c3f38:1;
  unsigned int s1502c3f39:1;
  unsigned int s1502c3f40:1;
  unsigned int s1502c3f41:1;
  unsigned int s1502c3f42:1;
  unsigned int s1502c3f43:1;
  unsigned int s1502c3f44:1;
  unsigned int s1502c3f45:1;
  unsigned int s1502c3f46:1;
  unsigned int s1502c3f47:1;
  unsigned int s1502c3f48:1;
  unsigned int s1502c3f49:1;
  unsigned int s1502c3f50:1;
  unsigned int s1502c3f51:1;
  unsigned int s1502c3f52:1;
  unsigned int s1502c3f53:1;
  unsigned int s1502c3f54:1;
  unsigned int s1502c3f55:1;
  unsigned int s1502c3f56:1;
  unsigned int s1502c3f57:1;
  unsigned int s1502c3f58:1;
  unsigned int s1502c3f59:1;
  unsigned int s1502c3f60:1;
  unsigned int s1502c3f61:1;
  unsigned int s1502c3f62:1;
  unsigned int s1502c3f63:1;
  unsigned int s1502c3f64:1;
  unsigned int s1502c3f65:1;
  unsigned int s1502c3f66:1;
  unsigned int s1502c3f67:1;
  unsigned int s1502c3f68:1;
  unsigned int s1502c3f69:1;
  unsigned int s1502c3f70:1;
  unsigned int s1502c3f71:1;
  unsigned int s1502c3f72:1;
  unsigned int s1502c3f73:1;
  unsigned int s1502c3f74:1;
  unsigned int s1502c3f75:1;
  unsigned int s1502c3f76:1;
  unsigned int s1502c3f77:1;
  unsigned int s1502c3f78:1;
  unsigned int s1502c3f79:1;
  unsigned int s1502c3f80:1;
  unsigned int s1502c3f81:1;
  unsigned int s1502c3f82:1;
  unsigned int s1502c3f83:1;
  int s1502c3f84[5];
  void *s1502c3f85[2];
  int s1502c3f86[3];
  ::S1502C5_nt s1502c3f87;
  ::S1502C5_nt s1502c3f88;
  ::S1502C5_nt s1502c3f89;
  ::S1502C12 s1502c3f90;
  ::S1502C12 s1502c3f91;
  int s1502c3f92;
  void *s1502c3f93[2];
  ::S1502C14_nt s1502c3f94;
  ::S1502C14_nt s1502c3f95;
  ::S1502C14_nt s1502c3f96;
  ::S1502C14_nt s1502c3f97;
  void *s1502c3f98;
  ::S1502C5_nt s1502c3f99;
  ::S1502C12 s1502c3f100;
  ::S1502C14_nt s1502c3f101;
  ::S1502C14_nt s1502c3f102;
  int s1502c3f103;
  ::S1502C14_nt s1502c3f104;
  ::S1502C14_nt s1502c3f105;
  void *s1502c3f106;
  int s1502c3f107;
  char s1502c3f108;
  ::S1502C14_nt s1502c3f109;
  ::S1502C14_nt s1502c3f110;
  void *s1502c3f111;
  int s1502c3f112;
  void *s1502c3f113;
  ::S1502C12 s1502c3f114;
  ::S1502C18 s1502c3f115;
  ::S1502C18 s1502c3f116;
  virtual  ~S1502C3_nt(); // _ZN10S1502C3_ntD1Ev
  virtual void  v70(); // _ZN10S1502C3_nt3v70Ev
  virtual void  v71(); // _ZN10S1502C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1502C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1502C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1502C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1502C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1502C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1502C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1502C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1502C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1502C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1502C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1502C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1502C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1502C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1502C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1502C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1502C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1502C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1502C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1502C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1502C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1502C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1502C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1502C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1502C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1502C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1502C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1502C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1502C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1502C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1502C3_nt4v101Ev
  virtual void  v102(); // _ZN10S1502C3_nt4v102Ev
  virtual void  v103(); // _ZN10S1502C3_nt4v103Ev
  virtual void  v104(); // _ZN10S1502C3_nt4v104Ev
  virtual void  v105(); // _ZN10S1502C3_nt4v105Ev
  virtual void  v106(); // _ZN10S1502C3_nt4v106Ev
  virtual void  v107(); // _ZN10S1502C3_nt4v107Ev
  virtual void  v108(); // _ZN10S1502C3_nt4v108Ev
  virtual void  v109(); // _ZN10S1502C3_nt4v109Ev
  virtual void  v110(); // _ZN10S1502C3_nt4v110Ev
  virtual void  v111(); // _ZN10S1502C3_nt4v111Ev
  virtual void  v112(); // _ZN10S1502C3_nt4v112Ev
  virtual void  v113(); // _ZN10S1502C3_nt4v113Ev
  virtual void  v114(); // _ZN10S1502C3_nt4v114Ev
  virtual void  v115(); // _ZN10S1502C3_nt4v115Ev
  virtual void  v116(); // _ZN10S1502C3_nt4v116Ev
  virtual void  v117(); // _ZN10S1502C3_nt4v117Ev
  virtual void  v118(); // _ZN10S1502C3_nt4v118Ev
  virtual void  v119(); // _ZN10S1502C3_nt4v119Ev
  virtual void  v120(); // _ZN10S1502C3_nt4v120Ev
  virtual void  v121(); // _ZN10S1502C3_nt4v121Ev
  virtual void  v122(); // _ZN10S1502C3_nt4v122Ev
  virtual void  v123(); // _ZN10S1502C3_nt4v123Ev
  virtual void  v124(); // _ZN10S1502C3_nt4v124Ev
  virtual void  v125(); // _ZN10S1502C3_nt4v125Ev
  virtual void  v126(); // _ZN10S1502C3_nt4v126Ev
  virtual void  v127(); // _ZN10S1502C3_nt4v127Ev
  virtual void  v128(); // _ZN10S1502C3_nt4v128Ev
  virtual void  v129(); // _ZN10S1502C3_nt4v129Ev
  virtual void  v130(); // _ZN10S1502C3_nt4v130Ev
  virtual void  v131(); // _ZN10S1502C3_nt4v131Ev
  virtual void  v132(); // _ZN10S1502C3_nt4v132Ev
  virtual void  v133(); // _ZN10S1502C3_nt4v133Ev
  virtual void  v134(); // _ZN10S1502C3_nt4v134Ev
  virtual void  v135(); // _ZN10S1502C3_nt4v135Ev
  virtual void  v136(); // _ZN10S1502C3_nt4v136Ev
  virtual void  v137(); // _ZN10S1502C3_nt4v137Ev
  virtual void  v138(); // _ZN10S1502C3_nt4v138Ev
  virtual void  v139(); // _ZN10S1502C3_nt4v139Ev
  virtual void  v140(); // _ZN10S1502C3_nt4v140Ev
  virtual void  v141(); // _ZN10S1502C3_nt4v141Ev
  virtual void  v142(); // _ZN10S1502C3_nt4v142Ev
  virtual void  v143(); // _ZN10S1502C3_nt4v143Ev
  virtual void  v144(); // _ZN10S1502C3_nt4v144Ev
  virtual void  v145(); // _ZN10S1502C3_nt4v145Ev
  virtual void  v146(); // _ZN10S1502C3_nt4v146Ev
  virtual void  v147(); // _ZN10S1502C3_nt4v147Ev
  virtual void  v148(); // _ZN10S1502C3_nt4v148Ev
  virtual void  v149(); // _ZN10S1502C3_nt4v149Ev
  virtual void  v150(); // _ZN10S1502C3_nt4v150Ev
  virtual void  v151(); // _ZN10S1502C3_nt4v151Ev
  virtual void  v152(); // _ZN10S1502C3_nt4v152Ev
  virtual void  v153(); // _ZN10S1502C3_nt4v153Ev
  virtual void  v154(); // _ZN10S1502C3_nt4v154Ev
  virtual void  v155(); // _ZN10S1502C3_nt4v155Ev
  virtual void  v156(); // _ZN10S1502C3_nt4v156Ev
  virtual void  v157(); // _ZN10S1502C3_nt4v157Ev
  virtual void  v158(); // _ZN10S1502C3_nt4v158Ev
  virtual void  v159(); // _ZN10S1502C3_nt4v159Ev
  virtual void  v160(); // _ZN10S1502C3_nt4v160Ev
  virtual void  v161(); // _ZN10S1502C3_nt4v161Ev
  virtual void  v162(); // _ZN10S1502C3_nt4v162Ev
  virtual void  v163(); // _ZN10S1502C3_nt4v163Ev
  virtual void  v164(); // _ZN10S1502C3_nt4v164Ev
  virtual void  v165(); // _ZN10S1502C3_nt4v165Ev
  virtual void  v166(); // _ZN10S1502C3_nt4v166Ev
  virtual void  v167(); // _ZN10S1502C3_nt4v167Ev
  virtual void  v168(); // _ZN10S1502C3_nt4v168Ev
  virtual void  v169(); // _ZN10S1502C3_nt4v169Ev
  virtual void  v170(); // _ZN10S1502C3_nt4v170Ev
  virtual void  v171(); // _ZN10S1502C3_nt4v171Ev
  virtual void  v172(); // _ZN10S1502C3_nt4v172Ev
  virtual void  v173(); // _ZN10S1502C3_nt4v173Ev
  virtual void  v174(); // _ZN10S1502C3_nt4v174Ev
  virtual void  v175(); // _ZN10S1502C3_nt4v175Ev
  virtual void  v176(); // _ZN10S1502C3_nt4v176Ev
  virtual void  v177(); // _ZN10S1502C3_nt4v177Ev
  virtual void  v178(); // _ZN10S1502C3_nt4v178Ev
  virtual void  v179(); // _ZN10S1502C3_nt4v179Ev
  virtual void  v180(); // _ZN10S1502C3_nt4v180Ev
  virtual void  v181(); // _ZN10S1502C3_nt4v181Ev
  virtual void  v182(); // _ZN10S1502C3_nt4v182Ev
  virtual void  v183(); // _ZN10S1502C3_nt4v183Ev
  virtual void  v184(); // _ZN10S1502C3_nt4v184Ev
  virtual void  v185(); // _ZN10S1502C3_nt4v185Ev
  virtual void  v186(); // _ZN10S1502C3_nt4v186Ev
  virtual void  v187(); // _ZN10S1502C3_nt4v187Ev
  virtual void  v188(); // _ZN10S1502C3_nt4v188Ev
  virtual void  v189(); // _ZN10S1502C3_nt4v189Ev
  virtual void  v190(); // _ZN10S1502C3_nt4v190Ev
  virtual void  v191(); // _ZN10S1502C3_nt4v191Ev
  virtual void  v192(); // _ZN10S1502C3_nt4v192Ev
  virtual void  v193(); // _ZN10S1502C3_nt4v193Ev
  virtual void  v194(); // _ZN10S1502C3_nt4v194Ev
  virtual void  v195(); // _ZN10S1502C3_nt4v195Ev
  virtual void  v196(); // _ZN10S1502C3_nt4v196Ev
  virtual void  v197(); // _ZN10S1502C3_nt4v197Ev
  virtual void  v198(); // _ZN10S1502C3_nt4v198Ev
  virtual void  v199(); // _ZN10S1502C3_nt4v199Ev
  virtual void  v200(); // _ZN10S1502C3_nt4v200Ev
  virtual void  v201(); // _ZN10S1502C3_nt4v201Ev
  virtual void  v202(); // _ZN10S1502C3_nt4v202Ev
  virtual void  v203(); // _ZN10S1502C3_nt4v203Ev
  virtual void  v204(); // _ZN10S1502C3_nt4v204Ev
  virtual void  v205(); // _ZN10S1502C3_nt4v205Ev
  virtual void  v206(); // _ZN10S1502C3_nt4v206Ev
  virtual void  v207(); // _ZN10S1502C3_nt4v207Ev
  virtual void  v208(); // _ZN10S1502C3_nt4v208Ev
  virtual void  v209(); // _ZN10S1502C3_nt4v209Ev
  virtual void  v210(); // _ZN10S1502C3_nt4v210Ev
  virtual void  v211(); // _ZN10S1502C3_nt4v211Ev
  virtual void  v212(); // _ZN10S1502C3_nt4v212Ev
  S1502C3_nt(); // tgen
};
//SIG(-1 S1502C3_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S1502C3_nt ::~S1502C3_nt(){ note_dtor("S1502C3_nt", this);}
void  S1502C3_nt ::v70(){vfunc_called(this, "_ZN10S1502C3_nt3v70Ev");}
void  S1502C3_nt ::v71(){vfunc_called(this, "_ZN10S1502C3_nt3v71Ev");}
void  S1502C3_nt ::v72(){vfunc_called(this, "_ZN10S1502C3_nt3v72Ev");}
void  S1502C3_nt ::v73(){vfunc_called(this, "_ZN10S1502C3_nt3v73Ev");}
void  S1502C3_nt ::v74(){vfunc_called(this, "_ZN10S1502C3_nt3v74Ev");}
void  S1502C3_nt ::v75(){vfunc_called(this, "_ZN10S1502C3_nt3v75Ev");}
void  S1502C3_nt ::v76(){vfunc_called(this, "_ZN10S1502C3_nt3v76Ev");}
void  S1502C3_nt ::v77(){vfunc_called(this, "_ZN10S1502C3_nt3v77Ev");}
void  S1502C3_nt ::v78(){vfunc_called(this, "_ZN10S1502C3_nt3v78Ev");}
void  S1502C3_nt ::v79(){vfunc_called(this, "_ZN10S1502C3_nt3v79Ev");}
void  S1502C3_nt ::v80(){vfunc_called(this, "_ZN10S1502C3_nt3v80Ev");}
void  S1502C3_nt ::v81(){vfunc_called(this, "_ZN10S1502C3_nt3v81Ev");}
void  S1502C3_nt ::v82(){vfunc_called(this, "_ZN10S1502C3_nt3v82Ev");}
void  S1502C3_nt ::v83(){vfunc_called(this, "_ZN10S1502C3_nt3v83Ev");}
void  S1502C3_nt ::v84(){vfunc_called(this, "_ZN10S1502C3_nt3v84Ev");}
void  S1502C3_nt ::v85(){vfunc_called(this, "_ZN10S1502C3_nt3v85Ev");}
void  S1502C3_nt ::v86(){vfunc_called(this, "_ZN10S1502C3_nt3v86Ev");}
void  S1502C3_nt ::v87(){vfunc_called(this, "_ZN10S1502C3_nt3v87Ev");}
void  S1502C3_nt ::v88(){vfunc_called(this, "_ZN10S1502C3_nt3v88Ev");}
void  S1502C3_nt ::v89(){vfunc_called(this, "_ZN10S1502C3_nt3v89Ev");}
void  S1502C3_nt ::v90(){vfunc_called(this, "_ZN10S1502C3_nt3v90Ev");}
void  S1502C3_nt ::v91(){vfunc_called(this, "_ZN10S1502C3_nt3v91Ev");}
void  S1502C3_nt ::v92(){vfunc_called(this, "_ZN10S1502C3_nt3v92Ev");}
void  S1502C3_nt ::v93(){vfunc_called(this, "_ZN10S1502C3_nt3v93Ev");}
void  S1502C3_nt ::v94(){vfunc_called(this, "_ZN10S1502C3_nt3v94Ev");}
void  S1502C3_nt ::v95(){vfunc_called(this, "_ZN10S1502C3_nt3v95Ev");}
void  S1502C3_nt ::v96(){vfunc_called(this, "_ZN10S1502C3_nt3v96Ev");}
void  S1502C3_nt ::v97(){vfunc_called(this, "_ZN10S1502C3_nt3v97Ev");}
void  S1502C3_nt ::v98(){vfunc_called(this, "_ZN10S1502C3_nt3v98Ev");}
void  S1502C3_nt ::v99(){vfunc_called(this, "_ZN10S1502C3_nt3v99Ev");}
void  S1502C3_nt ::v100(){vfunc_called(this, "_ZN10S1502C3_nt4v100Ev");}
void  S1502C3_nt ::v101(){vfunc_called(this, "_ZN10S1502C3_nt4v101Ev");}
void  S1502C3_nt ::v102(){vfunc_called(this, "_ZN10S1502C3_nt4v102Ev");}
void  S1502C3_nt ::v103(){vfunc_called(this, "_ZN10S1502C3_nt4v103Ev");}
void  S1502C3_nt ::v104(){vfunc_called(this, "_ZN10S1502C3_nt4v104Ev");}
void  S1502C3_nt ::v105(){vfunc_called(this, "_ZN10S1502C3_nt4v105Ev");}
void  S1502C3_nt ::v106(){vfunc_called(this, "_ZN10S1502C3_nt4v106Ev");}
void  S1502C3_nt ::v107(){vfunc_called(this, "_ZN10S1502C3_nt4v107Ev");}
void  S1502C3_nt ::v108(){vfunc_called(this, "_ZN10S1502C3_nt4v108Ev");}
void  S1502C3_nt ::v109(){vfunc_called(this, "_ZN10S1502C3_nt4v109Ev");}
void  S1502C3_nt ::v110(){vfunc_called(this, "_ZN10S1502C3_nt4v110Ev");}
void  S1502C3_nt ::v111(){vfunc_called(this, "_ZN10S1502C3_nt4v111Ev");}
void  S1502C3_nt ::v112(){vfunc_called(this, "_ZN10S1502C3_nt4v112Ev");}
void  S1502C3_nt ::v113(){vfunc_called(this, "_ZN10S1502C3_nt4v113Ev");}
void  S1502C3_nt ::v114(){vfunc_called(this, "_ZN10S1502C3_nt4v114Ev");}
void  S1502C3_nt ::v115(){vfunc_called(this, "_ZN10S1502C3_nt4v115Ev");}
void  S1502C3_nt ::v116(){vfunc_called(this, "_ZN10S1502C3_nt4v116Ev");}
void  S1502C3_nt ::v117(){vfunc_called(this, "_ZN10S1502C3_nt4v117Ev");}
void  S1502C3_nt ::v118(){vfunc_called(this, "_ZN10S1502C3_nt4v118Ev");}
void  S1502C3_nt ::v119(){vfunc_called(this, "_ZN10S1502C3_nt4v119Ev");}
void  S1502C3_nt ::v120(){vfunc_called(this, "_ZN10S1502C3_nt4v120Ev");}
void  S1502C3_nt ::v121(){vfunc_called(this, "_ZN10S1502C3_nt4v121Ev");}
void  S1502C3_nt ::v122(){vfunc_called(this, "_ZN10S1502C3_nt4v122Ev");}
void  S1502C3_nt ::v123(){vfunc_called(this, "_ZN10S1502C3_nt4v123Ev");}
void  S1502C3_nt ::v124(){vfunc_called(this, "_ZN10S1502C3_nt4v124Ev");}
void  S1502C3_nt ::v125(){vfunc_called(this, "_ZN10S1502C3_nt4v125Ev");}
void  S1502C3_nt ::v126(){vfunc_called(this, "_ZN10S1502C3_nt4v126Ev");}
void  S1502C3_nt ::v127(){vfunc_called(this, "_ZN10S1502C3_nt4v127Ev");}
void  S1502C3_nt ::v128(){vfunc_called(this, "_ZN10S1502C3_nt4v128Ev");}
void  S1502C3_nt ::v129(){vfunc_called(this, "_ZN10S1502C3_nt4v129Ev");}
void  S1502C3_nt ::v130(){vfunc_called(this, "_ZN10S1502C3_nt4v130Ev");}
void  S1502C3_nt ::v131(){vfunc_called(this, "_ZN10S1502C3_nt4v131Ev");}
void  S1502C3_nt ::v132(){vfunc_called(this, "_ZN10S1502C3_nt4v132Ev");}
void  S1502C3_nt ::v133(){vfunc_called(this, "_ZN10S1502C3_nt4v133Ev");}
void  S1502C3_nt ::v134(){vfunc_called(this, "_ZN10S1502C3_nt4v134Ev");}
void  S1502C3_nt ::v135(){vfunc_called(this, "_ZN10S1502C3_nt4v135Ev");}
void  S1502C3_nt ::v136(){vfunc_called(this, "_ZN10S1502C3_nt4v136Ev");}
void  S1502C3_nt ::v137(){vfunc_called(this, "_ZN10S1502C3_nt4v137Ev");}
void  S1502C3_nt ::v138(){vfunc_called(this, "_ZN10S1502C3_nt4v138Ev");}
void  S1502C3_nt ::v139(){vfunc_called(this, "_ZN10S1502C3_nt4v139Ev");}
void  S1502C3_nt ::v140(){vfunc_called(this, "_ZN10S1502C3_nt4v140Ev");}
void  S1502C3_nt ::v141(){vfunc_called(this, "_ZN10S1502C3_nt4v141Ev");}
void  S1502C3_nt ::v142(){vfunc_called(this, "_ZN10S1502C3_nt4v142Ev");}
void  S1502C3_nt ::v143(){vfunc_called(this, "_ZN10S1502C3_nt4v143Ev");}
void  S1502C3_nt ::v144(){vfunc_called(this, "_ZN10S1502C3_nt4v144Ev");}
void  S1502C3_nt ::v145(){vfunc_called(this, "_ZN10S1502C3_nt4v145Ev");}
void  S1502C3_nt ::v146(){vfunc_called(this, "_ZN10S1502C3_nt4v146Ev");}
void  S1502C3_nt ::v147(){vfunc_called(this, "_ZN10S1502C3_nt4v147Ev");}
void  S1502C3_nt ::v148(){vfunc_called(this, "_ZN10S1502C3_nt4v148Ev");}
void  S1502C3_nt ::v149(){vfunc_called(this, "_ZN10S1502C3_nt4v149Ev");}
void  S1502C3_nt ::v150(){vfunc_called(this, "_ZN10S1502C3_nt4v150Ev");}
void  S1502C3_nt ::v151(){vfunc_called(this, "_ZN10S1502C3_nt4v151Ev");}
void  S1502C3_nt ::v152(){vfunc_called(this, "_ZN10S1502C3_nt4v152Ev");}
void  S1502C3_nt ::v153(){vfunc_called(this, "_ZN10S1502C3_nt4v153Ev");}
void  S1502C3_nt ::v154(){vfunc_called(this, "_ZN10S1502C3_nt4v154Ev");}
void  S1502C3_nt ::v155(){vfunc_called(this, "_ZN10S1502C3_nt4v155Ev");}
void  S1502C3_nt ::v156(){vfunc_called(this, "_ZN10S1502C3_nt4v156Ev");}
void  S1502C3_nt ::v157(){vfunc_called(this, "_ZN10S1502C3_nt4v157Ev");}
void  S1502C3_nt ::v158(){vfunc_called(this, "_ZN10S1502C3_nt4v158Ev");}
void  S1502C3_nt ::v159(){vfunc_called(this, "_ZN10S1502C3_nt4v159Ev");}
void  S1502C3_nt ::v160(){vfunc_called(this, "_ZN10S1502C3_nt4v160Ev");}
void  S1502C3_nt ::v161(){vfunc_called(this, "_ZN10S1502C3_nt4v161Ev");}
void  S1502C3_nt ::v162(){vfunc_called(this, "_ZN10S1502C3_nt4v162Ev");}
void  S1502C3_nt ::v163(){vfunc_called(this, "_ZN10S1502C3_nt4v163Ev");}
void  S1502C3_nt ::v164(){vfunc_called(this, "_ZN10S1502C3_nt4v164Ev");}
void  S1502C3_nt ::v165(){vfunc_called(this, "_ZN10S1502C3_nt4v165Ev");}
void  S1502C3_nt ::v166(){vfunc_called(this, "_ZN10S1502C3_nt4v166Ev");}
void  S1502C3_nt ::v167(){vfunc_called(this, "_ZN10S1502C3_nt4v167Ev");}
void  S1502C3_nt ::v168(){vfunc_called(this, "_ZN10S1502C3_nt4v168Ev");}
void  S1502C3_nt ::v169(){vfunc_called(this, "_ZN10S1502C3_nt4v169Ev");}
void  S1502C3_nt ::v170(){vfunc_called(this, "_ZN10S1502C3_nt4v170Ev");}
void  S1502C3_nt ::v171(){vfunc_called(this, "_ZN10S1502C3_nt4v171Ev");}
void  S1502C3_nt ::v172(){vfunc_called(this, "_ZN10S1502C3_nt4v172Ev");}
void  S1502C3_nt ::v173(){vfunc_called(this, "_ZN10S1502C3_nt4v173Ev");}
void  S1502C3_nt ::v174(){vfunc_called(this, "_ZN10S1502C3_nt4v174Ev");}
void  S1502C3_nt ::v175(){vfunc_called(this, "_ZN10S1502C3_nt4v175Ev");}
void  S1502C3_nt ::v176(){vfunc_called(this, "_ZN10S1502C3_nt4v176Ev");}
void  S1502C3_nt ::v177(){vfunc_called(this, "_ZN10S1502C3_nt4v177Ev");}
void  S1502C3_nt ::v178(){vfunc_called(this, "_ZN10S1502C3_nt4v178Ev");}
void  S1502C3_nt ::v179(){vfunc_called(this, "_ZN10S1502C3_nt4v179Ev");}
void  S1502C3_nt ::v180(){vfunc_called(this, "_ZN10S1502C3_nt4v180Ev");}
void  S1502C3_nt ::v181(){vfunc_called(this, "_ZN10S1502C3_nt4v181Ev");}
void  S1502C3_nt ::v182(){vfunc_called(this, "_ZN10S1502C3_nt4v182Ev");}
void  S1502C3_nt ::v183(){vfunc_called(this, "_ZN10S1502C3_nt4v183Ev");}
void  S1502C3_nt ::v184(){vfunc_called(this, "_ZN10S1502C3_nt4v184Ev");}
void  S1502C3_nt ::v185(){vfunc_called(this, "_ZN10S1502C3_nt4v185Ev");}
void  S1502C3_nt ::v186(){vfunc_called(this, "_ZN10S1502C3_nt4v186Ev");}
void  S1502C3_nt ::v187(){vfunc_called(this, "_ZN10S1502C3_nt4v187Ev");}
void  S1502C3_nt ::v188(){vfunc_called(this, "_ZN10S1502C3_nt4v188Ev");}
void  S1502C3_nt ::v189(){vfunc_called(this, "_ZN10S1502C3_nt4v189Ev");}
void  S1502C3_nt ::v190(){vfunc_called(this, "_ZN10S1502C3_nt4v190Ev");}
void  S1502C3_nt ::v191(){vfunc_called(this, "_ZN10S1502C3_nt4v191Ev");}
void  S1502C3_nt ::v192(){vfunc_called(this, "_ZN10S1502C3_nt4v192Ev");}
void  S1502C3_nt ::v193(){vfunc_called(this, "_ZN10S1502C3_nt4v193Ev");}
void  S1502C3_nt ::v194(){vfunc_called(this, "_ZN10S1502C3_nt4v194Ev");}
void  S1502C3_nt ::v195(){vfunc_called(this, "_ZN10S1502C3_nt4v195Ev");}
void  S1502C3_nt ::v196(){vfunc_called(this, "_ZN10S1502C3_nt4v196Ev");}
void  S1502C3_nt ::v197(){vfunc_called(this, "_ZN10S1502C3_nt4v197Ev");}
void  S1502C3_nt ::v198(){vfunc_called(this, "_ZN10S1502C3_nt4v198Ev");}
void  S1502C3_nt ::v199(){vfunc_called(this, "_ZN10S1502C3_nt4v199Ev");}
void  S1502C3_nt ::v200(){vfunc_called(this, "_ZN10S1502C3_nt4v200Ev");}
void  S1502C3_nt ::v201(){vfunc_called(this, "_ZN10S1502C3_nt4v201Ev");}
void  S1502C3_nt ::v202(){vfunc_called(this, "_ZN10S1502C3_nt4v202Ev");}
void  S1502C3_nt ::v203(){vfunc_called(this, "_ZN10S1502C3_nt4v203Ev");}
void  S1502C3_nt ::v204(){vfunc_called(this, "_ZN10S1502C3_nt4v204Ev");}
void  S1502C3_nt ::v205(){vfunc_called(this, "_ZN10S1502C3_nt4v205Ev");}
void  S1502C3_nt ::v206(){vfunc_called(this, "_ZN10S1502C3_nt4v206Ev");}
void  S1502C3_nt ::v207(){vfunc_called(this, "_ZN10S1502C3_nt4v207Ev");}
void  S1502C3_nt ::v208(){vfunc_called(this, "_ZN10S1502C3_nt4v208Ev");}
void  S1502C3_nt ::v209(){vfunc_called(this, "_ZN10S1502C3_nt4v209Ev");}
void  S1502C3_nt ::v210(){vfunc_called(this, "_ZN10S1502C3_nt4v210Ev");}
void  S1502C3_nt ::v211(){vfunc_called(this, "_ZN10S1502C3_nt4v211Ev");}
void  S1502C3_nt ::v212(){vfunc_called(this, "_ZN10S1502C3_nt4v212Ev");}
S1502C3_nt ::S1502C3_nt(){ note_ctor("S1502C3_nt", this);} // tgen

//skip512 S1502C3_nt

#else // __cplusplus

extern void _ZN10S1502C3_ntC1Ev();
extern void _ZN10S1502C3_ntD1Ev();
Name_Map name_map_S1502C3_nt[] = {
  NSPAIR(_ZN10S1502C3_ntC1Ev),
  NSPAIR(_ZN10S1502C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1502C4_nt;
extern VTBL_ENTRY _ZTI10S1502C4_nt[];
extern  VTBL_ENTRY _ZTV10S1502C4_nt[];
static Base_Class bases_S1502C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1502C3_nt[];
extern void _ZN10S1502C3_ntD1Ev();
extern void _ZN10S1502C3_ntD0Ev();
extern void _ZN10S1502C4_nt2v6Ev();
extern void _ZN10S1502C4_nt2v7Ev();
extern void _ZN10S1502C4_nt2v8Ev();
extern void _ZN10S1502C4_nt2v9Ev();
extern void _ZN10S1502C4_nt3v10Ev();
extern void _ZN10S1502C4_nt3v11Ev();
extern void _ZN10S1502C4_nt3v12Ev();
extern void _ZN10S1502C4_nt3v13Ev();
extern void _ZN10S1502C4_nt3v14Ev();
extern void _ZN10S1502C4_nt3v15Ev();
extern void _ZN10S1502C4_nt3v16Ev();
extern void _ZN10S1502C4_nt3v17Ev();
extern void _ZN10S1502C4_nt3v18Ev();
extern void _ZN10S1502C4_nt3v19Ev();
extern void _ZN10S1502C4_nt3v20Ev();
extern void _ZN10S1502C4_nt3v21Ev();
extern void _ZN10S1502C4_nt3v22Ev();
extern void _ZN10S1502C4_nt3v23Ev();
extern void _ZN10S1502C4_nt3v24Ev();
extern void _ZN10S1502C4_nt3v25Ev();
extern void _ZN10S1502C4_nt3v26Ev();
extern void _ZN10S1502C4_nt3v27Ev();
extern void _ZN10S1502C4_nt3v28Ev();
extern void _ZN10S1502C4_nt3v29Ev();
extern void _ZN10S1502C4_nt3v30Ev();
extern void _ZN10S1502C4_nt3v31Ev();
extern void _ZN10S1502C4_nt3v32Ev();
extern void _ZN10S1502C4_nt3v33Ev();
extern void _ZN10S1502C4_nt3v34Ev();
extern void _ZN10S1502C4_nt3v35Ev();
extern void _ZN10S1502C4_nt3v36Ev();
extern void _ZN10S1502C4_nt3v37Ev();
extern void _ZN10S1502C4_nt3v38Ev();
extern void _ZN10S1502C4_nt3v39Ev();
extern void _ZN10S1502C4_nt3v40Ev();
extern void _ZN10S1502C4_nt3v41Ev();
extern void _ZN10S1502C4_nt3v42Ev();
extern void _ZN10S1502C4_nt3v43Ev();
extern void _ZN10S1502C4_nt3v44Ev();
extern void _ZN10S1502C4_nt3v45Ev();
extern void _ZN10S1502C4_nt3v46Ev();
extern void _ZN10S1502C4_nt3v47Ev();
extern void _ZN10S1502C4_nt3v48Ev();
extern void _ZN10S1502C4_nt3v49Ev();
extern void _ZN10S1502C4_nt3v50Ev();
extern void _ZN10S1502C4_nt3v51Ev();
extern void _ZN10S1502C4_nt3v52Ev();
extern void _ZN10S1502C4_nt3v53Ev();
extern void _ZN10S1502C4_nt3v54Ev();
extern void _ZN10S1502C4_nt3v55Ev();
extern void _ZN10S1502C4_nt3v56Ev();
extern void _ZN10S1502C4_nt3v57Ev();
extern void _ZN10S1502C4_nt3v58Ev();
extern void _ZN10S1502C4_nt3v59Ev();
extern void _ZN10S1502C4_nt3v60Ev();
extern void _ZN10S1502C4_nt3v61Ev();
extern void _ZN10S1502C4_nt3v62Ev();
extern void _ZN10S1502C4_nt3v63Ev();
extern void _ZN10S1502C4_nt3v64Ev();
extern void _ZN10S1502C4_nt3v65Ev();
extern void _ZN10S1502C4_nt3v66Ev();
extern void _ZN10S1502C4_nt3v67Ev();
extern void _ZN10S1502C4_nt3v68Ev();
extern void _ZN10S1502C4_nt3v69Ev();
extern void _ZN10S1502C3_nt3v70Ev();
extern void _ZN10S1502C3_nt3v71Ev();
extern void _ZN10S1502C3_nt3v72Ev();
extern void _ZN10S1502C3_nt3v73Ev();
extern void _ZN10S1502C3_nt3v74Ev();
extern void _ZN10S1502C3_nt3v75Ev();
extern void _ZN10S1502C3_nt3v76Ev();
extern void _ZN10S1502C3_nt3v77Ev();
extern void _ZN10S1502C3_nt3v78Ev();
extern void _ZN10S1502C3_nt3v79Ev();
extern void _ZN10S1502C3_nt3v80Ev();
extern void _ZN10S1502C3_nt3v81Ev();
extern void _ZN10S1502C3_nt3v82Ev();
extern void _ZN10S1502C3_nt3v83Ev();
extern void _ZN10S1502C3_nt3v84Ev();
extern void _ZN10S1502C3_nt3v85Ev();
extern void _ZN10S1502C3_nt3v86Ev();
extern void _ZN10S1502C3_nt3v87Ev();
extern void _ZN10S1502C3_nt3v88Ev();
extern void _ZN10S1502C3_nt3v89Ev();
extern void _ZN10S1502C3_nt3v90Ev();
extern void _ZN10S1502C3_nt3v91Ev();
extern void _ZN10S1502C3_nt3v92Ev();
extern void _ZN10S1502C3_nt3v93Ev();
extern void _ZN10S1502C3_nt3v94Ev();
extern void _ZN10S1502C3_nt3v95Ev();
extern void _ZN10S1502C3_nt3v96Ev();
extern void _ZN10S1502C3_nt3v97Ev();
extern void _ZN10S1502C3_nt3v98Ev();
extern void _ZN10S1502C3_nt3v99Ev();
extern void _ZN10S1502C3_nt4v100Ev();
extern void _ZN10S1502C3_nt4v101Ev();
extern void _ZN10S1502C3_nt4v102Ev();
extern void _ZN10S1502C3_nt4v103Ev();
extern void _ZN10S1502C3_nt4v104Ev();
extern void _ZN10S1502C3_nt4v105Ev();
extern void _ZN10S1502C3_nt4v106Ev();
extern void _ZN10S1502C3_nt4v107Ev();
extern void _ZN10S1502C3_nt4v108Ev();
extern void _ZN10S1502C3_nt4v109Ev();
extern void _ZN10S1502C3_nt4v110Ev();
extern void _ZN10S1502C3_nt4v111Ev();
extern void _ZN10S1502C3_nt4v112Ev();
extern void _ZN10S1502C3_nt4v113Ev();
extern void _ZN10S1502C3_nt4v114Ev();
extern void _ZN10S1502C3_nt4v115Ev();
extern void _ZN10S1502C3_nt4v116Ev();
extern void _ZN10S1502C3_nt4v117Ev();
extern void _ZN10S1502C3_nt4v118Ev();
extern void _ZN10S1502C3_nt4v119Ev();
extern void _ZN10S1502C3_nt4v120Ev();
extern void _ZN10S1502C3_nt4v121Ev();
extern void _ZN10S1502C3_nt4v122Ev();
extern void _ZN10S1502C3_nt4v123Ev();
extern void _ZN10S1502C3_nt4v124Ev();
extern void _ZN10S1502C3_nt4v125Ev();
extern void _ZN10S1502C3_nt4v126Ev();
extern void _ZN10S1502C3_nt4v127Ev();
extern void _ZN10S1502C3_nt4v128Ev();
extern void _ZN10S1502C3_nt4v129Ev();
extern void _ZN10S1502C3_nt4v130Ev();
extern void _ZN10S1502C3_nt4v131Ev();
extern void _ZN10S1502C3_nt4v132Ev();
extern void _ZN10S1502C3_nt4v133Ev();
extern void _ZN10S1502C3_nt4v134Ev();
extern void _ZN10S1502C3_nt4v135Ev();
extern void _ZN10S1502C3_nt4v136Ev();
extern void _ZN10S1502C3_nt4v137Ev();
extern void _ZN10S1502C3_nt4v138Ev();
extern void _ZN10S1502C3_nt4v139Ev();
extern void _ZN10S1502C3_nt4v140Ev();
extern void _ZN10S1502C3_nt4v141Ev();
extern void _ZN10S1502C3_nt4v142Ev();
extern void _ZN10S1502C3_nt4v143Ev();
extern void _ZN10S1502C3_nt4v144Ev();
extern void _ZN10S1502C3_nt4v145Ev();
extern void _ZN10S1502C3_nt4v146Ev();
extern void _ZN10S1502C3_nt4v147Ev();
extern void _ZN10S1502C3_nt4v148Ev();
extern void _ZN10S1502C3_nt4v149Ev();
extern void _ZN10S1502C3_nt4v150Ev();
extern void _ZN10S1502C3_nt4v151Ev();
extern void _ZN10S1502C3_nt4v152Ev();
extern void _ZN10S1502C3_nt4v153Ev();
extern void _ZN10S1502C3_nt4v154Ev();
extern void _ZN10S1502C3_nt4v155Ev();
extern void _ZN10S1502C3_nt4v156Ev();
extern void _ZN10S1502C3_nt4v157Ev();
extern void _ZN10S1502C3_nt4v158Ev();
extern void _ZN10S1502C3_nt4v159Ev();
extern void _ZN10S1502C3_nt4v160Ev();
extern void _ZN10S1502C3_nt4v161Ev();
extern void _ZN10S1502C3_nt4v162Ev();
extern void _ZN10S1502C3_nt4v163Ev();
extern void _ZN10S1502C3_nt4v164Ev();
extern void _ZN10S1502C3_nt4v165Ev();
extern void _ZN10S1502C3_nt4v166Ev();
extern void _ZN10S1502C3_nt4v167Ev();
extern void _ZN10S1502C3_nt4v168Ev();
extern void _ZN10S1502C3_nt4v169Ev();
extern void _ZN10S1502C3_nt4v170Ev();
extern void _ZN10S1502C3_nt4v171Ev();
extern void _ZN10S1502C3_nt4v172Ev();
extern void _ZN10S1502C3_nt4v173Ev();
extern void _ZN10S1502C3_nt4v174Ev();
extern void _ZN10S1502C3_nt4v175Ev();
extern void _ZN10S1502C3_nt4v176Ev();
extern void _ZN10S1502C3_nt4v177Ev();
extern void _ZN10S1502C3_nt4v178Ev();
extern void _ZN10S1502C3_nt4v179Ev();
extern void _ZN10S1502C3_nt4v180Ev();
extern void _ZN10S1502C3_nt4v181Ev();
extern void _ZN10S1502C3_nt4v182Ev();
extern void _ZN10S1502C3_nt4v183Ev();
extern void _ZN10S1502C3_nt4v184Ev();
extern void _ZN10S1502C3_nt4v185Ev();
extern void _ZN10S1502C3_nt4v186Ev();
extern void _ZN10S1502C3_nt4v187Ev();
extern void _ZN10S1502C3_nt4v188Ev();
extern void _ZN10S1502C3_nt4v189Ev();
extern void _ZN10S1502C3_nt4v190Ev();
extern void _ZN10S1502C3_nt4v191Ev();
extern void _ZN10S1502C3_nt4v192Ev();
extern void _ZN10S1502C3_nt4v193Ev();
extern void _ZN10S1502C3_nt4v194Ev();
extern void _ZN10S1502C3_nt4v195Ev();
extern void _ZN10S1502C3_nt4v196Ev();
extern void _ZN10S1502C3_nt4v197Ev();
extern void _ZN10S1502C3_nt4v198Ev();
extern void _ZN10S1502C3_nt4v199Ev();
extern void _ZN10S1502C3_nt4v200Ev();
extern void _ZN10S1502C3_nt4v201Ev();
extern void _ZN10S1502C3_nt4v202Ev();
extern void _ZN10S1502C3_nt4v203Ev();
extern void _ZN10S1502C3_nt4v204Ev();
extern void _ZN10S1502C3_nt4v205Ev();
extern void _ZN10S1502C3_nt4v206Ev();
extern void _ZN10S1502C3_nt4v207Ev();
extern void _ZN10S1502C3_nt4v208Ev();
extern void _ZN10S1502C3_nt4v209Ev();
extern void _ZN10S1502C3_nt4v210Ev();
extern void _ZN10S1502C3_nt4v211Ev();
extern void _ZN10S1502C3_nt4v212Ev();
static  VTBL_ENTRY vtc_S1502C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1502C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1502C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v212Ev,
};
extern VTBL_ENTRY _ZTI10S1502C3_nt[];
VTBL_ENTRY *P__ZTI10S1502C3_nt = _ZTI10S1502C3_nt; 
extern  VTBL_ENTRY _ZTV10S1502C3_nt[];
Class_Descriptor cd_S1502C3_nt = {  "S1502C3_nt", // class name
  bases_S1502C3_nt, 1,
  &(vtc_S1502C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1502C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1502C3_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C23_nt  {
  ::S1502C14_nt s1502c23f0;
  ::S1502C14_nt s1502c23f1;
  char s1502c23f2;
  void  mf1502c23(); // _ZN11S1502C23_nt9mf1502c23Ev
};
//SIG(-1 S1502C23_nt) C1{ m FC2{ m Fi[3]} FC2 Fc}


void  S1502C23_nt ::mf1502c23(){}

//skip512 S1502C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C22_nt  {
  ::S1502C23_nt s1502c22f0;
  ::S1502C14_nt s1502c22f1;
  void *s1502c22f2[2];
  char s1502c22f3;
  void  mf1502c22(); // _ZN11S1502C22_nt9mf1502c22Ev
};
//SIG(-1 S1502C22_nt) C1{ m FC2{ m FC3{ m Fi[3]} FC3 Fc} FC3 Fp[2] Fc}


void  S1502C22_nt ::mf1502c22(){}

//skip512 S1502C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C25  : S1502C8_nt {
};
//SIG(-1 S1502C25) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1502C25()
{
  extern Class_Descriptor cd_S1502C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1502C25, buf);
    S1502C25 &lv = *(new (buf) S1502C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1502C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1502C25)");
    check_base_class_offset(lv, (S1502C8_nt*), 0, "S1502C25");
    test_class_info(&lv, &cd_S1502C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1502C25(Test_S1502C25, "S1502C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
static Base_Class bases_S1502C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1502C25 = {  "S1502C25", // class name
  bases_S1502C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C24  : S1502C25 {
};
//SIG(-1 S1502C24) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1502C24()
{
  extern Class_Descriptor cd_S1502C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1502C24, buf);
    S1502C24 &lv = *(new (buf) S1502C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1502C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1502C24)");
    check_base_class_offset(lv, (S1502C8_nt*)(S1502C25*), 0, "S1502C24");
    check_base_class_offset(lv, (S1502C25*), 0, "S1502C24");
    test_class_info(&lv, &cd_S1502C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1502C24(Test_S1502C24, "S1502C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
extern Class_Descriptor cd_S1502C25;
static Base_Class bases_S1502C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1502C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1502C24 = {  "S1502C24", // class name
  bases_S1502C24, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C29  : S1502C8_nt {
};
//SIG(-1 S1502C29) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1502C29()
{
  extern Class_Descriptor cd_S1502C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1502C29, buf);
    S1502C29 &lv = *(new (buf) S1502C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1502C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1502C29)");
    check_base_class_offset(lv, (S1502C8_nt*), 0, "S1502C29");
    test_class_info(&lv, &cd_S1502C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1502C29(Test_S1502C29, "S1502C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
static Base_Class bases_S1502C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1502C29 = {  "S1502C29", // class name
  bases_S1502C29, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C28  : S1502C29 {
};
//SIG(-1 S1502C28) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1502C28()
{
  extern Class_Descriptor cd_S1502C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1502C28, buf);
    S1502C28 &lv = *(new (buf) S1502C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1502C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1502C28)");
    check_base_class_offset(lv, (S1502C8_nt*)(S1502C29*), 0, "S1502C28");
    check_base_class_offset(lv, (S1502C29*), 0, "S1502C28");
    test_class_info(&lv, &cd_S1502C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1502C28(Test_S1502C28, "S1502C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
extern Class_Descriptor cd_S1502C29;
static Base_Class bases_S1502C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1502C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1502C28 = {  "S1502C28", // class name
  bases_S1502C28, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C31_nt  {
  int s1502c31f0[4];
  void  mf1502c31(); // _ZN11S1502C31_nt9mf1502c31Ev
};
//SIG(-1 S1502C31_nt) C1{ m Fi[4]}


void  S1502C31_nt ::mf1502c31(){}

//skip512 S1502C31_nt

#else // __cplusplus

Class_Descriptor cd_S1502C31_nt = {  "S1502C31_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C2_nt  : S1502C3_nt {
  unsigned int s1502c2f0:1;
  unsigned int s1502c2f1:1;
  unsigned int s1502c2f2:1;
  unsigned int s1502c2f3:1;
  unsigned int s1502c2f4:1;
  ::S1502C22_nt s1502c2f5;
  unsigned int s1502c2f6:1;
  unsigned int s1502c2f7:1;
  unsigned int s1502c2f8:1;
  unsigned int s1502c2f9:1;
  unsigned int s1502c2f10:1;
  unsigned int s1502c2f11:1;
  unsigned int s1502c2f12:1;
  unsigned int s1502c2f13:1;
  unsigned int s1502c2f14:1;
  unsigned int s1502c2f15:1;
  unsigned int s1502c2f16:1;
  unsigned int s1502c2f17:1;
  unsigned int s1502c2f18:1;
  unsigned int s1502c2f19:1;
  unsigned int s1502c2f20:1;
  unsigned int s1502c2f21:1;
  unsigned int s1502c2f22:1;
  unsigned int s1502c2f23:1;
  unsigned int s1502c2f24:1;
  unsigned int s1502c2f25:1;
  unsigned int s1502c2f26:1;
  unsigned int s1502c2f27:1;
  unsigned int s1502c2f28:1;
  unsigned int s1502c2f29:1;
  unsigned int s1502c2f30:1;
  ::S1502C24 s1502c2f31;
  ::S1502C24 s1502c2f32;
  ::S1502C24 s1502c2f33;
  ::S1502C28 s1502c2f34;
  int s1502c2f35[2];
  void *s1502c2f36[4];
  int s1502c2f37[5];
  void *s1502c2f38;
  int s1502c2f39[2];
  void *s1502c2f40[2];
  int s1502c2f41;
  ::S1502C5_nt s1502c2f42;
  ::S1502C31_nt s1502c2f43;
  void *s1502c2f44[2];
  int s1502c2f45;
  void *s1502c2f46;
  int s1502c2f47;
  virtual  ~S1502C2_nt(); // _ZN10S1502C2_ntD1Ev
  virtual void  v213(); // _ZN10S1502C2_nt4v213Ev
  virtual void  v214(); // _ZN10S1502C2_nt4v214Ev
  virtual void  v215(); // _ZN10S1502C2_nt4v215Ev
  virtual void  v216(); // _ZN10S1502C2_nt4v216Ev
  virtual void  v217(); // _ZN10S1502C2_nt4v217Ev
  virtual void  v218(); // _ZN10S1502C2_nt4v218Ev
  virtual void  v219(); // _ZN10S1502C2_nt4v219Ev
  virtual void  v220(); // _ZN10S1502C2_nt4v220Ev
  virtual void  v221(); // _ZN10S1502C2_nt4v221Ev
  virtual void  v222(); // _ZN10S1502C2_nt4v222Ev
  virtual void  v223(); // _ZN10S1502C2_nt4v223Ev
  virtual void  v224(); // _ZN10S1502C2_nt4v224Ev
  virtual void  v225(); // _ZN10S1502C2_nt4v225Ev
  virtual void  v226(); // _ZN10S1502C2_nt4v226Ev
  virtual void  v227(); // _ZN10S1502C2_nt4v227Ev
  virtual void  v228(); // _ZN10S1502C2_nt4v228Ev
  virtual void  v229(); // _ZN10S1502C2_nt4v229Ev
  virtual void  v230(); // _ZN10S1502C2_nt4v230Ev
  virtual void  v231(); // _ZN10S1502C2_nt4v231Ev
  virtual void  v232(); // _ZN10S1502C2_nt4v232Ev
  virtual void  v233(); // _ZN10S1502C2_nt4v233Ev
  virtual void  v234(); // _ZN10S1502C2_nt4v234Ev
  virtual void  v235(); // _ZN10S1502C2_nt4v235Ev
  virtual void  v236(); // _ZN10S1502C2_nt4v236Ev
  virtual void  v237(); // _ZN10S1502C2_nt4v237Ev
  virtual void  v238(); // _ZN10S1502C2_nt4v238Ev
  virtual void  v239(); // _ZN10S1502C2_nt4v239Ev
  virtual void  v240(); // _ZN10S1502C2_nt4v240Ev
  virtual void  v241(); // _ZN10S1502C2_nt4v241Ev
  virtual void  v242(); // _ZN10S1502C2_nt4v242Ev
  virtual void  v243(); // _ZN10S1502C2_nt4v243Ev
  virtual void  v244(); // _ZN10S1502C2_nt4v244Ev
  virtual void  v245(); // _ZN10S1502C2_nt4v245Ev
  virtual void  v246(); // _ZN10S1502C2_nt4v246Ev
  virtual void  v247(); // _ZN10S1502C2_nt4v247Ev
  virtual void  v248(); // _ZN10S1502C2_nt4v248Ev
  virtual void  v249(); // _ZN10S1502C2_nt4v249Ev
  S1502C2_nt(); // tgen
};
//SIG(-1 S1502C2_nt) C1{ BC2{ BC3{ vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ m FC15{ m FC11 FC11 Fc} FC11 Fp[2] Fc} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC17{ BC7}} FC16 FC16 FC18{ BC19{ BC7}} Fi[2] Fp[4] Fi[5] Fp Fi[2] Fp[2] Fi FC4 FC20{ m Fi[4]} Fp[2] Fi Fp Fi}


 S1502C2_nt ::~S1502C2_nt(){ note_dtor("S1502C2_nt", this);}
void  S1502C2_nt ::v213(){vfunc_called(this, "_ZN10S1502C2_nt4v213Ev");}
void  S1502C2_nt ::v214(){vfunc_called(this, "_ZN10S1502C2_nt4v214Ev");}
void  S1502C2_nt ::v215(){vfunc_called(this, "_ZN10S1502C2_nt4v215Ev");}
void  S1502C2_nt ::v216(){vfunc_called(this, "_ZN10S1502C2_nt4v216Ev");}
void  S1502C2_nt ::v217(){vfunc_called(this, "_ZN10S1502C2_nt4v217Ev");}
void  S1502C2_nt ::v218(){vfunc_called(this, "_ZN10S1502C2_nt4v218Ev");}
void  S1502C2_nt ::v219(){vfunc_called(this, "_ZN10S1502C2_nt4v219Ev");}
void  S1502C2_nt ::v220(){vfunc_called(this, "_ZN10S1502C2_nt4v220Ev");}
void  S1502C2_nt ::v221(){vfunc_called(this, "_ZN10S1502C2_nt4v221Ev");}
void  S1502C2_nt ::v222(){vfunc_called(this, "_ZN10S1502C2_nt4v222Ev");}
void  S1502C2_nt ::v223(){vfunc_called(this, "_ZN10S1502C2_nt4v223Ev");}
void  S1502C2_nt ::v224(){vfunc_called(this, "_ZN10S1502C2_nt4v224Ev");}
void  S1502C2_nt ::v225(){vfunc_called(this, "_ZN10S1502C2_nt4v225Ev");}
void  S1502C2_nt ::v226(){vfunc_called(this, "_ZN10S1502C2_nt4v226Ev");}
void  S1502C2_nt ::v227(){vfunc_called(this, "_ZN10S1502C2_nt4v227Ev");}
void  S1502C2_nt ::v228(){vfunc_called(this, "_ZN10S1502C2_nt4v228Ev");}
void  S1502C2_nt ::v229(){vfunc_called(this, "_ZN10S1502C2_nt4v229Ev");}
void  S1502C2_nt ::v230(){vfunc_called(this, "_ZN10S1502C2_nt4v230Ev");}
void  S1502C2_nt ::v231(){vfunc_called(this, "_ZN10S1502C2_nt4v231Ev");}
void  S1502C2_nt ::v232(){vfunc_called(this, "_ZN10S1502C2_nt4v232Ev");}
void  S1502C2_nt ::v233(){vfunc_called(this, "_ZN10S1502C2_nt4v233Ev");}
void  S1502C2_nt ::v234(){vfunc_called(this, "_ZN10S1502C2_nt4v234Ev");}
void  S1502C2_nt ::v235(){vfunc_called(this, "_ZN10S1502C2_nt4v235Ev");}
void  S1502C2_nt ::v236(){vfunc_called(this, "_ZN10S1502C2_nt4v236Ev");}
void  S1502C2_nt ::v237(){vfunc_called(this, "_ZN10S1502C2_nt4v237Ev");}
void  S1502C2_nt ::v238(){vfunc_called(this, "_ZN10S1502C2_nt4v238Ev");}
void  S1502C2_nt ::v239(){vfunc_called(this, "_ZN10S1502C2_nt4v239Ev");}
void  S1502C2_nt ::v240(){vfunc_called(this, "_ZN10S1502C2_nt4v240Ev");}
void  S1502C2_nt ::v241(){vfunc_called(this, "_ZN10S1502C2_nt4v241Ev");}
void  S1502C2_nt ::v242(){vfunc_called(this, "_ZN10S1502C2_nt4v242Ev");}
void  S1502C2_nt ::v243(){vfunc_called(this, "_ZN10S1502C2_nt4v243Ev");}
void  S1502C2_nt ::v244(){vfunc_called(this, "_ZN10S1502C2_nt4v244Ev");}
void  S1502C2_nt ::v245(){vfunc_called(this, "_ZN10S1502C2_nt4v245Ev");}
void  S1502C2_nt ::v246(){vfunc_called(this, "_ZN10S1502C2_nt4v246Ev");}
void  S1502C2_nt ::v247(){vfunc_called(this, "_ZN10S1502C2_nt4v247Ev");}
void  S1502C2_nt ::v248(){vfunc_called(this, "_ZN10S1502C2_nt4v248Ev");}
void  S1502C2_nt ::v249(){vfunc_called(this, "_ZN10S1502C2_nt4v249Ev");}
S1502C2_nt ::S1502C2_nt(){ note_ctor("S1502C2_nt", this);} // tgen

//skip512 S1502C2_nt

#else // __cplusplus

extern void _ZN10S1502C2_ntC1Ev();
extern void _ZN10S1502C2_ntD1Ev();
Name_Map name_map_S1502C2_nt[] = {
  NSPAIR(_ZN10S1502C2_ntC1Ev),
  NSPAIR(_ZN10S1502C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1502C4_nt;
extern VTBL_ENTRY _ZTI10S1502C4_nt[];
extern  VTBL_ENTRY _ZTV10S1502C4_nt[];
extern Class_Descriptor cd_S1502C3_nt;
extern VTBL_ENTRY _ZTI10S1502C3_nt[];
extern  VTBL_ENTRY _ZTV10S1502C3_nt[];
static Base_Class bases_S1502C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1502C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1502C2_nt[];
extern void _ZN10S1502C2_ntD1Ev();
extern void _ZN10S1502C2_ntD0Ev();
extern void _ZN10S1502C4_nt2v6Ev();
extern void _ZN10S1502C4_nt2v7Ev();
extern void _ZN10S1502C4_nt2v8Ev();
extern void _ZN10S1502C4_nt2v9Ev();
extern void _ZN10S1502C4_nt3v10Ev();
extern void _ZN10S1502C4_nt3v11Ev();
extern void _ZN10S1502C4_nt3v12Ev();
extern void _ZN10S1502C4_nt3v13Ev();
extern void _ZN10S1502C4_nt3v14Ev();
extern void _ZN10S1502C4_nt3v15Ev();
extern void _ZN10S1502C4_nt3v16Ev();
extern void _ZN10S1502C4_nt3v17Ev();
extern void _ZN10S1502C4_nt3v18Ev();
extern void _ZN10S1502C4_nt3v19Ev();
extern void _ZN10S1502C4_nt3v20Ev();
extern void _ZN10S1502C4_nt3v21Ev();
extern void _ZN10S1502C4_nt3v22Ev();
extern void _ZN10S1502C4_nt3v23Ev();
extern void _ZN10S1502C4_nt3v24Ev();
extern void _ZN10S1502C4_nt3v25Ev();
extern void _ZN10S1502C4_nt3v26Ev();
extern void _ZN10S1502C4_nt3v27Ev();
extern void _ZN10S1502C4_nt3v28Ev();
extern void _ZN10S1502C4_nt3v29Ev();
extern void _ZN10S1502C4_nt3v30Ev();
extern void _ZN10S1502C4_nt3v31Ev();
extern void _ZN10S1502C4_nt3v32Ev();
extern void _ZN10S1502C4_nt3v33Ev();
extern void _ZN10S1502C4_nt3v34Ev();
extern void _ZN10S1502C4_nt3v35Ev();
extern void _ZN10S1502C4_nt3v36Ev();
extern void _ZN10S1502C4_nt3v37Ev();
extern void _ZN10S1502C4_nt3v38Ev();
extern void _ZN10S1502C4_nt3v39Ev();
extern void _ZN10S1502C4_nt3v40Ev();
extern void _ZN10S1502C4_nt3v41Ev();
extern void _ZN10S1502C4_nt3v42Ev();
extern void _ZN10S1502C4_nt3v43Ev();
extern void _ZN10S1502C4_nt3v44Ev();
extern void _ZN10S1502C4_nt3v45Ev();
extern void _ZN10S1502C4_nt3v46Ev();
extern void _ZN10S1502C4_nt3v47Ev();
extern void _ZN10S1502C4_nt3v48Ev();
extern void _ZN10S1502C4_nt3v49Ev();
extern void _ZN10S1502C4_nt3v50Ev();
extern void _ZN10S1502C4_nt3v51Ev();
extern void _ZN10S1502C4_nt3v52Ev();
extern void _ZN10S1502C4_nt3v53Ev();
extern void _ZN10S1502C4_nt3v54Ev();
extern void _ZN10S1502C4_nt3v55Ev();
extern void _ZN10S1502C4_nt3v56Ev();
extern void _ZN10S1502C4_nt3v57Ev();
extern void _ZN10S1502C4_nt3v58Ev();
extern void _ZN10S1502C4_nt3v59Ev();
extern void _ZN10S1502C4_nt3v60Ev();
extern void _ZN10S1502C4_nt3v61Ev();
extern void _ZN10S1502C4_nt3v62Ev();
extern void _ZN10S1502C4_nt3v63Ev();
extern void _ZN10S1502C4_nt3v64Ev();
extern void _ZN10S1502C4_nt3v65Ev();
extern void _ZN10S1502C4_nt3v66Ev();
extern void _ZN10S1502C4_nt3v67Ev();
extern void _ZN10S1502C4_nt3v68Ev();
extern void _ZN10S1502C4_nt3v69Ev();
extern void _ZN10S1502C3_nt3v70Ev();
extern void _ZN10S1502C3_nt3v71Ev();
extern void _ZN10S1502C3_nt3v72Ev();
extern void _ZN10S1502C3_nt3v73Ev();
extern void _ZN10S1502C3_nt3v74Ev();
extern void _ZN10S1502C3_nt3v75Ev();
extern void _ZN10S1502C3_nt3v76Ev();
extern void _ZN10S1502C3_nt3v77Ev();
extern void _ZN10S1502C3_nt3v78Ev();
extern void _ZN10S1502C3_nt3v79Ev();
extern void _ZN10S1502C3_nt3v80Ev();
extern void _ZN10S1502C3_nt3v81Ev();
extern void _ZN10S1502C3_nt3v82Ev();
extern void _ZN10S1502C3_nt3v83Ev();
extern void _ZN10S1502C3_nt3v84Ev();
extern void _ZN10S1502C3_nt3v85Ev();
extern void _ZN10S1502C3_nt3v86Ev();
extern void _ZN10S1502C3_nt3v87Ev();
extern void _ZN10S1502C3_nt3v88Ev();
extern void _ZN10S1502C3_nt3v89Ev();
extern void _ZN10S1502C3_nt3v90Ev();
extern void _ZN10S1502C3_nt3v91Ev();
extern void _ZN10S1502C3_nt3v92Ev();
extern void _ZN10S1502C3_nt3v93Ev();
extern void _ZN10S1502C3_nt3v94Ev();
extern void _ZN10S1502C3_nt3v95Ev();
extern void _ZN10S1502C3_nt3v96Ev();
extern void _ZN10S1502C3_nt3v97Ev();
extern void _ZN10S1502C3_nt3v98Ev();
extern void _ZN10S1502C3_nt3v99Ev();
extern void _ZN10S1502C3_nt4v100Ev();
extern void _ZN10S1502C3_nt4v101Ev();
extern void _ZN10S1502C3_nt4v102Ev();
extern void _ZN10S1502C3_nt4v103Ev();
extern void _ZN10S1502C3_nt4v104Ev();
extern void _ZN10S1502C3_nt4v105Ev();
extern void _ZN10S1502C3_nt4v106Ev();
extern void _ZN10S1502C3_nt4v107Ev();
extern void _ZN10S1502C3_nt4v108Ev();
extern void _ZN10S1502C3_nt4v109Ev();
extern void _ZN10S1502C3_nt4v110Ev();
extern void _ZN10S1502C3_nt4v111Ev();
extern void _ZN10S1502C3_nt4v112Ev();
extern void _ZN10S1502C3_nt4v113Ev();
extern void _ZN10S1502C3_nt4v114Ev();
extern void _ZN10S1502C3_nt4v115Ev();
extern void _ZN10S1502C3_nt4v116Ev();
extern void _ZN10S1502C3_nt4v117Ev();
extern void _ZN10S1502C3_nt4v118Ev();
extern void _ZN10S1502C3_nt4v119Ev();
extern void _ZN10S1502C3_nt4v120Ev();
extern void _ZN10S1502C3_nt4v121Ev();
extern void _ZN10S1502C3_nt4v122Ev();
extern void _ZN10S1502C3_nt4v123Ev();
extern void _ZN10S1502C3_nt4v124Ev();
extern void _ZN10S1502C3_nt4v125Ev();
extern void _ZN10S1502C3_nt4v126Ev();
extern void _ZN10S1502C3_nt4v127Ev();
extern void _ZN10S1502C3_nt4v128Ev();
extern void _ZN10S1502C3_nt4v129Ev();
extern void _ZN10S1502C3_nt4v130Ev();
extern void _ZN10S1502C3_nt4v131Ev();
extern void _ZN10S1502C3_nt4v132Ev();
extern void _ZN10S1502C3_nt4v133Ev();
extern void _ZN10S1502C3_nt4v134Ev();
extern void _ZN10S1502C3_nt4v135Ev();
extern void _ZN10S1502C3_nt4v136Ev();
extern void _ZN10S1502C3_nt4v137Ev();
extern void _ZN10S1502C3_nt4v138Ev();
extern void _ZN10S1502C3_nt4v139Ev();
extern void _ZN10S1502C3_nt4v140Ev();
extern void _ZN10S1502C3_nt4v141Ev();
extern void _ZN10S1502C3_nt4v142Ev();
extern void _ZN10S1502C3_nt4v143Ev();
extern void _ZN10S1502C3_nt4v144Ev();
extern void _ZN10S1502C3_nt4v145Ev();
extern void _ZN10S1502C3_nt4v146Ev();
extern void _ZN10S1502C3_nt4v147Ev();
extern void _ZN10S1502C3_nt4v148Ev();
extern void _ZN10S1502C3_nt4v149Ev();
extern void _ZN10S1502C3_nt4v150Ev();
extern void _ZN10S1502C3_nt4v151Ev();
extern void _ZN10S1502C3_nt4v152Ev();
extern void _ZN10S1502C3_nt4v153Ev();
extern void _ZN10S1502C3_nt4v154Ev();
extern void _ZN10S1502C3_nt4v155Ev();
extern void _ZN10S1502C3_nt4v156Ev();
extern void _ZN10S1502C3_nt4v157Ev();
extern void _ZN10S1502C3_nt4v158Ev();
extern void _ZN10S1502C3_nt4v159Ev();
extern void _ZN10S1502C3_nt4v160Ev();
extern void _ZN10S1502C3_nt4v161Ev();
extern void _ZN10S1502C3_nt4v162Ev();
extern void _ZN10S1502C3_nt4v163Ev();
extern void _ZN10S1502C3_nt4v164Ev();
extern void _ZN10S1502C3_nt4v165Ev();
extern void _ZN10S1502C3_nt4v166Ev();
extern void _ZN10S1502C3_nt4v167Ev();
extern void _ZN10S1502C3_nt4v168Ev();
extern void _ZN10S1502C3_nt4v169Ev();
extern void _ZN10S1502C3_nt4v170Ev();
extern void _ZN10S1502C3_nt4v171Ev();
extern void _ZN10S1502C3_nt4v172Ev();
extern void _ZN10S1502C3_nt4v173Ev();
extern void _ZN10S1502C3_nt4v174Ev();
extern void _ZN10S1502C3_nt4v175Ev();
extern void _ZN10S1502C3_nt4v176Ev();
extern void _ZN10S1502C3_nt4v177Ev();
extern void _ZN10S1502C3_nt4v178Ev();
extern void _ZN10S1502C3_nt4v179Ev();
extern void _ZN10S1502C3_nt4v180Ev();
extern void _ZN10S1502C3_nt4v181Ev();
extern void _ZN10S1502C3_nt4v182Ev();
extern void _ZN10S1502C3_nt4v183Ev();
extern void _ZN10S1502C3_nt4v184Ev();
extern void _ZN10S1502C3_nt4v185Ev();
extern void _ZN10S1502C3_nt4v186Ev();
extern void _ZN10S1502C3_nt4v187Ev();
extern void _ZN10S1502C3_nt4v188Ev();
extern void _ZN10S1502C3_nt4v189Ev();
extern void _ZN10S1502C3_nt4v190Ev();
extern void _ZN10S1502C3_nt4v191Ev();
extern void _ZN10S1502C3_nt4v192Ev();
extern void _ZN10S1502C3_nt4v193Ev();
extern void _ZN10S1502C3_nt4v194Ev();
extern void _ZN10S1502C3_nt4v195Ev();
extern void _ZN10S1502C3_nt4v196Ev();
extern void _ZN10S1502C3_nt4v197Ev();
extern void _ZN10S1502C3_nt4v198Ev();
extern void _ZN10S1502C3_nt4v199Ev();
extern void _ZN10S1502C3_nt4v200Ev();
extern void _ZN10S1502C3_nt4v201Ev();
extern void _ZN10S1502C3_nt4v202Ev();
extern void _ZN10S1502C3_nt4v203Ev();
extern void _ZN10S1502C3_nt4v204Ev();
extern void _ZN10S1502C3_nt4v205Ev();
extern void _ZN10S1502C3_nt4v206Ev();
extern void _ZN10S1502C3_nt4v207Ev();
extern void _ZN10S1502C3_nt4v208Ev();
extern void _ZN10S1502C3_nt4v209Ev();
extern void _ZN10S1502C3_nt4v210Ev();
extern void _ZN10S1502C3_nt4v211Ev();
extern void _ZN10S1502C3_nt4v212Ev();
extern void _ZN10S1502C2_nt4v213Ev();
extern void _ZN10S1502C2_nt4v214Ev();
extern void _ZN10S1502C2_nt4v215Ev();
extern void _ZN10S1502C2_nt4v216Ev();
extern void _ZN10S1502C2_nt4v217Ev();
extern void _ZN10S1502C2_nt4v218Ev();
extern void _ZN10S1502C2_nt4v219Ev();
extern void _ZN10S1502C2_nt4v220Ev();
extern void _ZN10S1502C2_nt4v221Ev();
extern void _ZN10S1502C2_nt4v222Ev();
extern void _ZN10S1502C2_nt4v223Ev();
extern void _ZN10S1502C2_nt4v224Ev();
extern void _ZN10S1502C2_nt4v225Ev();
extern void _ZN10S1502C2_nt4v226Ev();
extern void _ZN10S1502C2_nt4v227Ev();
extern void _ZN10S1502C2_nt4v228Ev();
extern void _ZN10S1502C2_nt4v229Ev();
extern void _ZN10S1502C2_nt4v230Ev();
extern void _ZN10S1502C2_nt4v231Ev();
extern void _ZN10S1502C2_nt4v232Ev();
extern void _ZN10S1502C2_nt4v233Ev();
extern void _ZN10S1502C2_nt4v234Ev();
extern void _ZN10S1502C2_nt4v235Ev();
extern void _ZN10S1502C2_nt4v236Ev();
extern void _ZN10S1502C2_nt4v237Ev();
extern void _ZN10S1502C2_nt4v238Ev();
extern void _ZN10S1502C2_nt4v239Ev();
extern void _ZN10S1502C2_nt4v240Ev();
extern void _ZN10S1502C2_nt4v241Ev();
extern void _ZN10S1502C2_nt4v242Ev();
extern void _ZN10S1502C2_nt4v243Ev();
extern void _ZN10S1502C2_nt4v244Ev();
extern void _ZN10S1502C2_nt4v245Ev();
extern void _ZN10S1502C2_nt4v246Ev();
extern void _ZN10S1502C2_nt4v247Ev();
extern void _ZN10S1502C2_nt4v248Ev();
extern void _ZN10S1502C2_nt4v249Ev();
static  VTBL_ENTRY vtc_S1502C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1502C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1502C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v237Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v238Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v239Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v240Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v241Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v242Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v243Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v244Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v245Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v246Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v247Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v248Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v249Ev,
};
extern VTBL_ENTRY _ZTI10S1502C2_nt[];
VTBL_ENTRY *P__ZTI10S1502C2_nt = _ZTI10S1502C2_nt; 
extern  VTBL_ENTRY _ZTV10S1502C2_nt[];
Class_Descriptor cd_S1502C2_nt = {  "S1502C2_nt", // class name
  bases_S1502C2_nt, 2,
  &(vtc_S1502C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(880,656), // object size
  NSPAIRA(_ZTI10S1502C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1502C2_nt),248, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1502C1  : S1502C2_nt {
  void *s1502c1f0;
  virtual  ~S1502C1(); // _ZN7S1502C1D1Ev
  virtual void  v1(); // _ZN7S1502C12v1Ev
  virtual void  v2(); // _ZN7S1502C12v2Ev
  virtual void  v3(); // _ZN7S1502C12v3Ev
  virtual void  v4(); // _ZN7S1502C12v4Ev
  virtual void  v5(); // _ZN7S1502C12v5Ev
  S1502C1(); // tgen
};
//SIG(1 S1502C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ m FC16{ m FC12 FC12 Fc} FC12 Fp[2] Fc} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC17{ BC18{ BC8}} FC17 FC17 FC19{ BC20{ BC8}} Fi[2] Fp[4] Fi[5] Fp Fi[2] Fp[2] Fi FC5 FC21{ m Fi[4]} Fp[2] Fi Fp Fi} vd v1 v2 v3 v4 v5 Fp}


 S1502C1 ::~S1502C1(){ note_dtor("S1502C1", this);}
void  S1502C1 ::v1(){vfunc_called(this, "_ZN7S1502C12v1Ev");}
void  S1502C1 ::v2(){vfunc_called(this, "_ZN7S1502C12v2Ev");}
void  S1502C1 ::v3(){vfunc_called(this, "_ZN7S1502C12v3Ev");}
void  S1502C1 ::v4(){vfunc_called(this, "_ZN7S1502C12v4Ev");}
void  S1502C1 ::v5(){vfunc_called(this, "_ZN7S1502C12v5Ev");}
S1502C1 ::S1502C1(){ note_ctor("S1502C1", this);} // tgen

static void Test_S1502C1()
{
  extern Class_Descriptor cd_S1502C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(112,166)];
    init_test(&cd_S1502C1, buf);
    S1502C1 *dp, &lv = *(dp=new (buf) S1502C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(888,660), "sizeof(S1502C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1502C1)");
    check_base_class_offset(lv, (S1502C4_nt*)(S1502C3_nt*)(S1502C2_nt*), 0, "S1502C1");
    check_base_class_offset(lv, (S1502C3_nt*)(S1502C2_nt*), 0, "S1502C1");
    check_base_class_offset(lv, (S1502C2_nt*), 0, "S1502C1");
    check_field_offset(lv, s1502c1f0, ABISELECT(880,656), "S1502C1.s1502c1f0");
    test_class_info(&lv, &cd_S1502C1);
    dp->~S1502C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1502C1(Test_S1502C1, "S1502C1", ABISELECT(888,660));

#else // __cplusplus

extern void _ZN7S1502C1C1Ev();
extern void _ZN7S1502C1D1Ev();
Name_Map name_map_S1502C1[] = {
  NSPAIR(_ZN7S1502C1C1Ev),
  NSPAIR(_ZN7S1502C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1502C4_nt;
extern VTBL_ENTRY _ZTI10S1502C4_nt[];
extern  VTBL_ENTRY _ZTV10S1502C4_nt[];
extern Class_Descriptor cd_S1502C3_nt;
extern VTBL_ENTRY _ZTI10S1502C3_nt[];
extern  VTBL_ENTRY _ZTV10S1502C3_nt[];
extern Class_Descriptor cd_S1502C2_nt;
extern VTBL_ENTRY _ZTI10S1502C2_nt[];
extern  VTBL_ENTRY _ZTV10S1502C2_nt[];
static Base_Class bases_S1502C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1502C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1502C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1502C1[];
extern void _ZN7S1502C1D1Ev();
extern void _ZN7S1502C1D0Ev();
extern void _ZN10S1502C4_nt2v6Ev();
extern void _ZN10S1502C4_nt2v7Ev();
extern void _ZN10S1502C4_nt2v8Ev();
extern void _ZN10S1502C4_nt2v9Ev();
extern void _ZN10S1502C4_nt3v10Ev();
extern void _ZN10S1502C4_nt3v11Ev();
extern void _ZN10S1502C4_nt3v12Ev();
extern void _ZN10S1502C4_nt3v13Ev();
extern void _ZN10S1502C4_nt3v14Ev();
extern void _ZN10S1502C4_nt3v15Ev();
extern void _ZN10S1502C4_nt3v16Ev();
extern void _ZN10S1502C4_nt3v17Ev();
extern void _ZN10S1502C4_nt3v18Ev();
extern void _ZN10S1502C4_nt3v19Ev();
extern void _ZN10S1502C4_nt3v20Ev();
extern void _ZN10S1502C4_nt3v21Ev();
extern void _ZN10S1502C4_nt3v22Ev();
extern void _ZN10S1502C4_nt3v23Ev();
extern void _ZN10S1502C4_nt3v24Ev();
extern void _ZN10S1502C4_nt3v25Ev();
extern void _ZN10S1502C4_nt3v26Ev();
extern void _ZN10S1502C4_nt3v27Ev();
extern void _ZN10S1502C4_nt3v28Ev();
extern void _ZN10S1502C4_nt3v29Ev();
extern void _ZN10S1502C4_nt3v30Ev();
extern void _ZN10S1502C4_nt3v31Ev();
extern void _ZN10S1502C4_nt3v32Ev();
extern void _ZN10S1502C4_nt3v33Ev();
extern void _ZN10S1502C4_nt3v34Ev();
extern void _ZN10S1502C4_nt3v35Ev();
extern void _ZN10S1502C4_nt3v36Ev();
extern void _ZN10S1502C4_nt3v37Ev();
extern void _ZN10S1502C4_nt3v38Ev();
extern void _ZN10S1502C4_nt3v39Ev();
extern void _ZN10S1502C4_nt3v40Ev();
extern void _ZN10S1502C4_nt3v41Ev();
extern void _ZN10S1502C4_nt3v42Ev();
extern void _ZN10S1502C4_nt3v43Ev();
extern void _ZN10S1502C4_nt3v44Ev();
extern void _ZN10S1502C4_nt3v45Ev();
extern void _ZN10S1502C4_nt3v46Ev();
extern void _ZN10S1502C4_nt3v47Ev();
extern void _ZN10S1502C4_nt3v48Ev();
extern void _ZN10S1502C4_nt3v49Ev();
extern void _ZN10S1502C4_nt3v50Ev();
extern void _ZN10S1502C4_nt3v51Ev();
extern void _ZN10S1502C4_nt3v52Ev();
extern void _ZN10S1502C4_nt3v53Ev();
extern void _ZN10S1502C4_nt3v54Ev();
extern void _ZN10S1502C4_nt3v55Ev();
extern void _ZN10S1502C4_nt3v56Ev();
extern void _ZN10S1502C4_nt3v57Ev();
extern void _ZN10S1502C4_nt3v58Ev();
extern void _ZN10S1502C4_nt3v59Ev();
extern void _ZN10S1502C4_nt3v60Ev();
extern void _ZN10S1502C4_nt3v61Ev();
extern void _ZN10S1502C4_nt3v62Ev();
extern void _ZN10S1502C4_nt3v63Ev();
extern void _ZN10S1502C4_nt3v64Ev();
extern void _ZN10S1502C4_nt3v65Ev();
extern void _ZN10S1502C4_nt3v66Ev();
extern void _ZN10S1502C4_nt3v67Ev();
extern void _ZN10S1502C4_nt3v68Ev();
extern void _ZN10S1502C4_nt3v69Ev();
extern void _ZN10S1502C3_nt3v70Ev();
extern void _ZN10S1502C3_nt3v71Ev();
extern void _ZN10S1502C3_nt3v72Ev();
extern void _ZN10S1502C3_nt3v73Ev();
extern void _ZN10S1502C3_nt3v74Ev();
extern void _ZN10S1502C3_nt3v75Ev();
extern void _ZN10S1502C3_nt3v76Ev();
extern void _ZN10S1502C3_nt3v77Ev();
extern void _ZN10S1502C3_nt3v78Ev();
extern void _ZN10S1502C3_nt3v79Ev();
extern void _ZN10S1502C3_nt3v80Ev();
extern void _ZN10S1502C3_nt3v81Ev();
extern void _ZN10S1502C3_nt3v82Ev();
extern void _ZN10S1502C3_nt3v83Ev();
extern void _ZN10S1502C3_nt3v84Ev();
extern void _ZN10S1502C3_nt3v85Ev();
extern void _ZN10S1502C3_nt3v86Ev();
extern void _ZN10S1502C3_nt3v87Ev();
extern void _ZN10S1502C3_nt3v88Ev();
extern void _ZN10S1502C3_nt3v89Ev();
extern void _ZN10S1502C3_nt3v90Ev();
extern void _ZN10S1502C3_nt3v91Ev();
extern void _ZN10S1502C3_nt3v92Ev();
extern void _ZN10S1502C3_nt3v93Ev();
extern void _ZN10S1502C3_nt3v94Ev();
extern void _ZN10S1502C3_nt3v95Ev();
extern void _ZN10S1502C3_nt3v96Ev();
extern void _ZN10S1502C3_nt3v97Ev();
extern void _ZN10S1502C3_nt3v98Ev();
extern void _ZN10S1502C3_nt3v99Ev();
extern void _ZN10S1502C3_nt4v100Ev();
extern void _ZN10S1502C3_nt4v101Ev();
extern void _ZN10S1502C3_nt4v102Ev();
extern void _ZN10S1502C3_nt4v103Ev();
extern void _ZN10S1502C3_nt4v104Ev();
extern void _ZN10S1502C3_nt4v105Ev();
extern void _ZN10S1502C3_nt4v106Ev();
extern void _ZN10S1502C3_nt4v107Ev();
extern void _ZN10S1502C3_nt4v108Ev();
extern void _ZN10S1502C3_nt4v109Ev();
extern void _ZN10S1502C3_nt4v110Ev();
extern void _ZN10S1502C3_nt4v111Ev();
extern void _ZN10S1502C3_nt4v112Ev();
extern void _ZN10S1502C3_nt4v113Ev();
extern void _ZN10S1502C3_nt4v114Ev();
extern void _ZN10S1502C3_nt4v115Ev();
extern void _ZN10S1502C3_nt4v116Ev();
extern void _ZN10S1502C3_nt4v117Ev();
extern void _ZN10S1502C3_nt4v118Ev();
extern void _ZN10S1502C3_nt4v119Ev();
extern void _ZN10S1502C3_nt4v120Ev();
extern void _ZN10S1502C3_nt4v121Ev();
extern void _ZN10S1502C3_nt4v122Ev();
extern void _ZN10S1502C3_nt4v123Ev();
extern void _ZN10S1502C3_nt4v124Ev();
extern void _ZN10S1502C3_nt4v125Ev();
extern void _ZN10S1502C3_nt4v126Ev();
extern void _ZN10S1502C3_nt4v127Ev();
extern void _ZN10S1502C3_nt4v128Ev();
extern void _ZN10S1502C3_nt4v129Ev();
extern void _ZN10S1502C3_nt4v130Ev();
extern void _ZN10S1502C3_nt4v131Ev();
extern void _ZN10S1502C3_nt4v132Ev();
extern void _ZN10S1502C3_nt4v133Ev();
extern void _ZN10S1502C3_nt4v134Ev();
extern void _ZN10S1502C3_nt4v135Ev();
extern void _ZN10S1502C3_nt4v136Ev();
extern void _ZN10S1502C3_nt4v137Ev();
extern void _ZN10S1502C3_nt4v138Ev();
extern void _ZN10S1502C3_nt4v139Ev();
extern void _ZN10S1502C3_nt4v140Ev();
extern void _ZN10S1502C3_nt4v141Ev();
extern void _ZN10S1502C3_nt4v142Ev();
extern void _ZN10S1502C3_nt4v143Ev();
extern void _ZN10S1502C3_nt4v144Ev();
extern void _ZN10S1502C3_nt4v145Ev();
extern void _ZN10S1502C3_nt4v146Ev();
extern void _ZN10S1502C3_nt4v147Ev();
extern void _ZN10S1502C3_nt4v148Ev();
extern void _ZN10S1502C3_nt4v149Ev();
extern void _ZN10S1502C3_nt4v150Ev();
extern void _ZN10S1502C3_nt4v151Ev();
extern void _ZN10S1502C3_nt4v152Ev();
extern void _ZN10S1502C3_nt4v153Ev();
extern void _ZN10S1502C3_nt4v154Ev();
extern void _ZN10S1502C3_nt4v155Ev();
extern void _ZN10S1502C3_nt4v156Ev();
extern void _ZN10S1502C3_nt4v157Ev();
extern void _ZN10S1502C3_nt4v158Ev();
extern void _ZN10S1502C3_nt4v159Ev();
extern void _ZN10S1502C3_nt4v160Ev();
extern void _ZN10S1502C3_nt4v161Ev();
extern void _ZN10S1502C3_nt4v162Ev();
extern void _ZN10S1502C3_nt4v163Ev();
extern void _ZN10S1502C3_nt4v164Ev();
extern void _ZN10S1502C3_nt4v165Ev();
extern void _ZN10S1502C3_nt4v166Ev();
extern void _ZN10S1502C3_nt4v167Ev();
extern void _ZN10S1502C3_nt4v168Ev();
extern void _ZN10S1502C3_nt4v169Ev();
extern void _ZN10S1502C3_nt4v170Ev();
extern void _ZN10S1502C3_nt4v171Ev();
extern void _ZN10S1502C3_nt4v172Ev();
extern void _ZN10S1502C3_nt4v173Ev();
extern void _ZN10S1502C3_nt4v174Ev();
extern void _ZN10S1502C3_nt4v175Ev();
extern void _ZN10S1502C3_nt4v176Ev();
extern void _ZN10S1502C3_nt4v177Ev();
extern void _ZN10S1502C3_nt4v178Ev();
extern void _ZN10S1502C3_nt4v179Ev();
extern void _ZN10S1502C3_nt4v180Ev();
extern void _ZN10S1502C3_nt4v181Ev();
extern void _ZN10S1502C3_nt4v182Ev();
extern void _ZN10S1502C3_nt4v183Ev();
extern void _ZN10S1502C3_nt4v184Ev();
extern void _ZN10S1502C3_nt4v185Ev();
extern void _ZN10S1502C3_nt4v186Ev();
extern void _ZN10S1502C3_nt4v187Ev();
extern void _ZN10S1502C3_nt4v188Ev();
extern void _ZN10S1502C3_nt4v189Ev();
extern void _ZN10S1502C3_nt4v190Ev();
extern void _ZN10S1502C3_nt4v191Ev();
extern void _ZN10S1502C3_nt4v192Ev();
extern void _ZN10S1502C3_nt4v193Ev();
extern void _ZN10S1502C3_nt4v194Ev();
extern void _ZN10S1502C3_nt4v195Ev();
extern void _ZN10S1502C3_nt4v196Ev();
extern void _ZN10S1502C3_nt4v197Ev();
extern void _ZN10S1502C3_nt4v198Ev();
extern void _ZN10S1502C3_nt4v199Ev();
extern void _ZN10S1502C3_nt4v200Ev();
extern void _ZN10S1502C3_nt4v201Ev();
extern void _ZN10S1502C3_nt4v202Ev();
extern void _ZN10S1502C3_nt4v203Ev();
extern void _ZN10S1502C3_nt4v204Ev();
extern void _ZN10S1502C3_nt4v205Ev();
extern void _ZN10S1502C3_nt4v206Ev();
extern void _ZN10S1502C3_nt4v207Ev();
extern void _ZN10S1502C3_nt4v208Ev();
extern void _ZN10S1502C3_nt4v209Ev();
extern void _ZN10S1502C3_nt4v210Ev();
extern void _ZN10S1502C3_nt4v211Ev();
extern void _ZN10S1502C3_nt4v212Ev();
extern void _ZN10S1502C2_nt4v213Ev();
extern void _ZN10S1502C2_nt4v214Ev();
extern void _ZN10S1502C2_nt4v215Ev();
extern void _ZN10S1502C2_nt4v216Ev();
extern void _ZN10S1502C2_nt4v217Ev();
extern void _ZN10S1502C2_nt4v218Ev();
extern void _ZN10S1502C2_nt4v219Ev();
extern void _ZN10S1502C2_nt4v220Ev();
extern void _ZN10S1502C2_nt4v221Ev();
extern void _ZN10S1502C2_nt4v222Ev();
extern void _ZN10S1502C2_nt4v223Ev();
extern void _ZN10S1502C2_nt4v224Ev();
extern void _ZN10S1502C2_nt4v225Ev();
extern void _ZN10S1502C2_nt4v226Ev();
extern void _ZN10S1502C2_nt4v227Ev();
extern void _ZN10S1502C2_nt4v228Ev();
extern void _ZN10S1502C2_nt4v229Ev();
extern void _ZN10S1502C2_nt4v230Ev();
extern void _ZN10S1502C2_nt4v231Ev();
extern void _ZN10S1502C2_nt4v232Ev();
extern void _ZN10S1502C2_nt4v233Ev();
extern void _ZN10S1502C2_nt4v234Ev();
extern void _ZN10S1502C2_nt4v235Ev();
extern void _ZN10S1502C2_nt4v236Ev();
extern void _ZN10S1502C2_nt4v237Ev();
extern void _ZN10S1502C2_nt4v238Ev();
extern void _ZN10S1502C2_nt4v239Ev();
extern void _ZN10S1502C2_nt4v240Ev();
extern void _ZN10S1502C2_nt4v241Ev();
extern void _ZN10S1502C2_nt4v242Ev();
extern void _ZN10S1502C2_nt4v243Ev();
extern void _ZN10S1502C2_nt4v244Ev();
extern void _ZN10S1502C2_nt4v245Ev();
extern void _ZN10S1502C2_nt4v246Ev();
extern void _ZN10S1502C2_nt4v247Ev();
extern void _ZN10S1502C2_nt4v248Ev();
extern void _ZN10S1502C2_nt4v249Ev();
extern void _ZN7S1502C12v1Ev();
extern void _ZN7S1502C12v2Ev();
extern void _ZN7S1502C12v3Ev();
extern void _ZN7S1502C12v4Ev();
extern void _ZN7S1502C12v5Ev();
static  VTBL_ENTRY vtc_S1502C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1502C1[0]),
  (VTBL_ENTRY)&_ZN7S1502C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1502C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1502C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1502C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v237Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v238Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v239Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v240Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v241Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v242Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v243Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v244Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v245Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v246Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v247Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v248Ev,
  (VTBL_ENTRY)&_ZN10S1502C2_nt4v249Ev,
  (VTBL_ENTRY)&_ZN7S1502C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1502C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1502C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1502C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1502C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S1502C1[];
extern  VTBL_ENTRY _ZTV7S1502C1[];
Class_Descriptor cd_S1502C1 = {  "S1502C1", // class name
  bases_S1502C1, 3,
  &(vtc_S1502C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(888,660), // object size
  NSPAIRA(_ZTI7S1502C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1502C1),253, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C4_nt  {
  virtual  ~S2280C4_nt(); // _ZN10S2280C4_ntD1Ev
  virtual void  v4(); // _ZN10S2280C4_nt2v4Ev
  virtual void  v5(); // _ZN10S2280C4_nt2v5Ev
  virtual void  v6(); // _ZN10S2280C4_nt2v6Ev
  S2280C4_nt(); // tgen
};
//SIG(-1 S2280C4_nt) C1{ vd v1 v2 v3}


 S2280C4_nt ::~S2280C4_nt(){ note_dtor("S2280C4_nt", this);}
void  S2280C4_nt ::v4(){vfunc_called(this, "_ZN10S2280C4_nt2v4Ev");}
void  S2280C4_nt ::v5(){vfunc_called(this, "_ZN10S2280C4_nt2v5Ev");}
void  S2280C4_nt ::v6(){vfunc_called(this, "_ZN10S2280C4_nt2v6Ev");}
S2280C4_nt ::S2280C4_nt(){ note_ctor("S2280C4_nt", this);} // tgen

//skip512 S2280C4_nt

#else // __cplusplus

extern void _ZN10S2280C4_ntC1Ev();
extern void _ZN10S2280C4_ntD1Ev();
Name_Map name_map_S2280C4_nt[] = {
  NSPAIR(_ZN10S2280C4_ntC1Ev),
  NSPAIR(_ZN10S2280C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2280C4_nt[];
extern void _ZN10S2280C4_ntD1Ev();
extern void _ZN10S2280C4_ntD0Ev();
extern void _ZN10S2280C4_nt2v4Ev();
extern void _ZN10S2280C4_nt2v5Ev();
extern void _ZN10S2280C4_nt2v6Ev();
static  VTBL_ENTRY vtc_S2280C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2280C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2280C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v6Ev,
};
extern VTBL_ENTRY _ZTI10S2280C4_nt[];
VTBL_ENTRY *P__ZTI10S2280C4_nt = _ZTI10S2280C4_nt; 
extern  VTBL_ENTRY _ZTV10S2280C4_nt[];
Class_Descriptor cd_S2280C4_nt = {  "S2280C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2280C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S2280C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2280C4_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C3  : S2280C4_nt {
  void *s2280c3f0[4];
  int s2280c3f1[3];
  void *s2280c3f2;
  char s2280c3f3[128];
  virtual  ~S2280C3(); // _ZN7S2280C3D1Ev
  virtual void  v7(); // _ZN7S2280C32v7Ev
  virtual void  v8(); // _ZN7S2280C32v8Ev
  virtual void  v9(); // _ZN7S2280C32v9Ev
  S2280C3(); // tgen
};
//SIG(-1 S2280C3) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 Fp[4] Fi[3] Fp Fc[128]}


 S2280C3 ::~S2280C3(){ note_dtor("S2280C3", this);}
void  S2280C3 ::v7(){vfunc_called(this, "_ZN7S2280C32v7Ev");}
void  S2280C3 ::v8(){vfunc_called(this, "_ZN7S2280C32v8Ev");}
void  S2280C3 ::v9(){vfunc_called(this, "_ZN7S2280C32v9Ev");}
S2280C3 ::S2280C3(){ note_ctor("S2280C3", this);} // tgen

static void Test_S2280C3()
{
  extern Class_Descriptor cd_S2280C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,42)];
    init_test(&cd_S2280C3, buf);
    S2280C3 *dp, &lv = *(dp=new (buf) S2280C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,164), "sizeof(S2280C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C3)");
    check_base_class_offset(lv, (S2280C4_nt*), 0, "S2280C3");
    check_field_offset(lv, s2280c3f0, ABISELECT(8,4), "S2280C3.s2280c3f0");
    check_field_offset(lv, s2280c3f1, ABISELECT(40,20), "S2280C3.s2280c3f1");
    check_field_offset(lv, s2280c3f2, ABISELECT(56,32), "S2280C3.s2280c3f2");
    check_field_offset(lv, s2280c3f3, ABISELECT(64,36), "S2280C3.s2280c3f3");
    test_class_info(&lv, &cd_S2280C3);
    dp->~S2280C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2280C3(Test_S2280C3, "S2280C3", ABISELECT(192,164));

#else // __cplusplus

extern void _ZN7S2280C3C1Ev();
extern void _ZN7S2280C3D1Ev();
Name_Map name_map_S2280C3[] = {
  NSPAIR(_ZN7S2280C3C1Ev),
  NSPAIR(_ZN7S2280C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2280C4_nt;
extern VTBL_ENTRY _ZTI10S2280C4_nt[];
extern  VTBL_ENTRY _ZTV10S2280C4_nt[];
static Base_Class bases_S2280C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2280C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2280C3[];
extern void _ZN7S2280C3D1Ev();
extern void _ZN7S2280C3D0Ev();
extern void _ZN10S2280C4_nt2v4Ev();
extern void _ZN10S2280C4_nt2v5Ev();
extern void _ZN10S2280C4_nt2v6Ev();
extern void _ZN7S2280C32v7Ev();
extern void _ZN7S2280C32v8Ev();
extern void _ZN7S2280C32v9Ev();
static  VTBL_ENTRY vtc_S2280C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2280C3[0]),
  (VTBL_ENTRY)&_ZN7S2280C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2280C3D0Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN7S2280C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2280C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2280C32v9Ev,
};
extern VTBL_ENTRY _ZTI7S2280C3[];
extern  VTBL_ENTRY _ZTV7S2280C3[];
Class_Descriptor cd_S2280C3 = {  "S2280C3", // class name
  bases_S2280C3, 1,
  &(vtc_S2280C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,164), // object size
  NSPAIRA(_ZTI7S2280C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2280C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C5  {
  int s2280c5f0[2];
  virtual  ~S2280C5(); // _ZN7S2280C5D1Ev
  virtual void  v10(); // _ZN7S2280C53v10Ev
  virtual void  v11(); // _ZN7S2280C53v11Ev
  virtual void  v12(); // _ZN7S2280C53v12Ev
  virtual void  v13(); // _ZN7S2280C53v13Ev
  virtual void  v14(); // _ZN7S2280C53v14Ev
  virtual void  v15(); // _ZN7S2280C53v15Ev
  virtual void  v16(); // _ZN7S2280C53v16Ev
  virtual void  v17(); // _ZN7S2280C53v17Ev
  virtual void  v18(); // _ZN7S2280C53v18Ev
  virtual void  v19(); // _ZN7S2280C53v19Ev
  virtual void  v20(); // _ZN7S2280C53v20Ev
  virtual void  v21(); // _ZN7S2280C53v21Ev
  virtual void  v22(); // _ZN7S2280C53v22Ev
  virtual void  v23(); // _ZN7S2280C53v23Ev
  virtual void  v24(); // _ZN7S2280C53v24Ev
  virtual void  v25(); // _ZN7S2280C53v25Ev
  virtual void  v26(); // _ZN7S2280C53v26Ev
  virtual void  v27(); // _ZN7S2280C53v27Ev
  virtual void  v28(); // _ZN7S2280C53v28Ev
  virtual void  v29(); // _ZN7S2280C53v29Ev
  S2280C5(); // tgen
};
//SIG(-1 S2280C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi[2]}


 S2280C5 ::~S2280C5(){ note_dtor("S2280C5", this);}
void  S2280C5 ::v10(){vfunc_called(this, "_ZN7S2280C53v10Ev");}
void  S2280C5 ::v11(){vfunc_called(this, "_ZN7S2280C53v11Ev");}
void  S2280C5 ::v12(){vfunc_called(this, "_ZN7S2280C53v12Ev");}
void  S2280C5 ::v13(){vfunc_called(this, "_ZN7S2280C53v13Ev");}
void  S2280C5 ::v14(){vfunc_called(this, "_ZN7S2280C53v14Ev");}
void  S2280C5 ::v15(){vfunc_called(this, "_ZN7S2280C53v15Ev");}
void  S2280C5 ::v16(){vfunc_called(this, "_ZN7S2280C53v16Ev");}
void  S2280C5 ::v17(){vfunc_called(this, "_ZN7S2280C53v17Ev");}
void  S2280C5 ::v18(){vfunc_called(this, "_ZN7S2280C53v18Ev");}
void  S2280C5 ::v19(){vfunc_called(this, "_ZN7S2280C53v19Ev");}
void  S2280C5 ::v20(){vfunc_called(this, "_ZN7S2280C53v20Ev");}
void  S2280C5 ::v21(){vfunc_called(this, "_ZN7S2280C53v21Ev");}
void  S2280C5 ::v22(){vfunc_called(this, "_ZN7S2280C53v22Ev");}
void  S2280C5 ::v23(){vfunc_called(this, "_ZN7S2280C53v23Ev");}
void  S2280C5 ::v24(){vfunc_called(this, "_ZN7S2280C53v24Ev");}
void  S2280C5 ::v25(){vfunc_called(this, "_ZN7S2280C53v25Ev");}
void  S2280C5 ::v26(){vfunc_called(this, "_ZN7S2280C53v26Ev");}
void  S2280C5 ::v27(){vfunc_called(this, "_ZN7S2280C53v27Ev");}
void  S2280C5 ::v28(){vfunc_called(this, "_ZN7S2280C53v28Ev");}
void  S2280C5 ::v29(){vfunc_called(this, "_ZN7S2280C53v29Ev");}
S2280C5 ::S2280C5(){ note_ctor("S2280C5", this);} // tgen

static void Test_S2280C5()
{
  extern Class_Descriptor cd_S2280C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2280C5, buf);
    S2280C5 *dp, &lv = *(dp=new (buf) S2280C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2280C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C5)");
    check_field_offset(lv, s2280c5f0, ABISELECT(8,4), "S2280C5.s2280c5f0");
    test_class_info(&lv, &cd_S2280C5);
    dp->~S2280C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2280C5(Test_S2280C5, "S2280C5", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN7S2280C5C1Ev();
extern void _ZN7S2280C5D1Ev();
Name_Map name_map_S2280C5[] = {
  NSPAIR(_ZN7S2280C5C1Ev),
  NSPAIR(_ZN7S2280C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2280C5[];
extern void _ZN7S2280C5D1Ev();
extern void _ZN7S2280C5D0Ev();
extern void _ZN7S2280C53v10Ev();
extern void _ZN7S2280C53v11Ev();
extern void _ZN7S2280C53v12Ev();
extern void _ZN7S2280C53v13Ev();
extern void _ZN7S2280C53v14Ev();
extern void _ZN7S2280C53v15Ev();
extern void _ZN7S2280C53v16Ev();
extern void _ZN7S2280C53v17Ev();
extern void _ZN7S2280C53v18Ev();
extern void _ZN7S2280C53v19Ev();
extern void _ZN7S2280C53v20Ev();
extern void _ZN7S2280C53v21Ev();
extern void _ZN7S2280C53v22Ev();
extern void _ZN7S2280C53v23Ev();
extern void _ZN7S2280C53v24Ev();
extern void _ZN7S2280C53v25Ev();
extern void _ZN7S2280C53v26Ev();
extern void _ZN7S2280C53v27Ev();
extern void _ZN7S2280C53v28Ev();
extern void _ZN7S2280C53v29Ev();
static  VTBL_ENTRY vtc_S2280C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2280C5[0]),
  (VTBL_ENTRY)&_ZN7S2280C5D1Ev,
  (VTBL_ENTRY)&_ZN7S2280C5D0Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v10Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v11Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v12Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v13Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v14Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v15Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v16Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v17Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v18Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v19Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v20Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v21Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v22Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v23Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v24Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v25Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v27Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v28Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v29Ev,
};
extern VTBL_ENTRY _ZTI7S2280C5[];
extern  VTBL_ENTRY _ZTV7S2280C5[];
Class_Descriptor cd_S2280C5 = {  "S2280C5", // class name
  0,0,//no base classes
  &(vtc_S2280C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI7S2280C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2280C5),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C8_nt  {
  short s2280c8f0[2];
};
//SIG(-1 S2280C8_nt) C1{ Fs[2]}



//skip512 S2280C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C7  {
  char s2280c7f0[2];
  void *s2280c7f1[4];
  ::S2280C8_nt s2280c7f2[3];
  void *s2280c7f3;
};
//SIG(1 S2280C7) C1{ Fc[2] Fp[4] FC2{ Fs[2]}[3] Fp}



static void Test_S2280C7()
{
  {
    init_simple_test("S2280C7");
    S2280C7 lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S2280C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C7)");
    check_field_offset(lv, s2280c7f0, 0, "S2280C7.s2280c7f0");
    check_field_offset(lv, s2280c7f1, ABISELECT(8,4), "S2280C7.s2280c7f1");
    check_field_offset(lv, s2280c7f2, ABISELECT(40,20), "S2280C7.s2280c7f2");
    check_field_offset(lv, s2280c7f3, ABISELECT(56,32), "S2280C7.s2280c7f3");
  }
}
static Arrange_To_Call_Me vS2280C7(Test_S2280C7, "S2280C7", ABISELECT(64,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C6  {
  ::S2280C7 s2280c6f0[12];
  void *s2280c6f1[3];
  short s2280c6f2[42];
};
//SIG(-1 S2280C6) C1{ FC2{ Fc[2] Fp[4] FC3{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]}



static void Test_S2280C6()
{
  {
    init_simple_test("S2280C6");
    S2280C6 lv;
    check2(sizeof(lv), ABISELECT(880,528), "sizeof(S2280C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C6)");
    check_field_offset(lv, s2280c6f0, 0, "S2280C6.s2280c6f0");
    check_field_offset(lv, s2280c6f1, ABISELECT(768,432), "S2280C6.s2280c6f1");
    check_field_offset(lv, s2280c6f2, ABISELECT(792,444), "S2280C6.s2280c6f2");
  }
}
static Arrange_To_Call_Me vS2280C6(Test_S2280C6, "S2280C6", ABISELECT(880,528));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C10_nt  {
  long s2280c10f0[4];
};
//SIG(-1 S2280C10_nt) C1{ Fl[4]}



//skip512 S2280C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C9_nt  {
  ::S2280C10_nt s2280c9f0;
  void  mf2280c9(); // _ZN10S2280C9_nt8mf2280c9Ev
};
//SIG(-1 S2280C9_nt) C1{ m FC2{ Fl[4]}}


void  S2280C9_nt ::mf2280c9(){}

//skip512 S2280C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C12  {
  void *s2280c12f0;
  short s2280c12f1;
  void *s2280c12f2;
  short s2280c12f3[2];
};
//SIG(-1 S2280C12) C1{ Fp Fs Fp Fs[2]}



static void Test_S2280C12()
{
  {
    init_simple_test("S2280C12");
    S2280C12 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S2280C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C12)");
    check_field_offset(lv, s2280c12f0, 0, "S2280C12.s2280c12f0");
    check_field_offset(lv, s2280c12f1, ABISELECT(8,4), "S2280C12.s2280c12f1");
    check_field_offset(lv, s2280c12f2, ABISELECT(16,8), "S2280C12.s2280c12f2");
    check_field_offset(lv, s2280c12f3, ABISELECT(24,12), "S2280C12.s2280c12f3");
  }
}
static Arrange_To_Call_Me vS2280C12(Test_S2280C12, "S2280C12", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C19  {
  void *s2280c19f0;
  void *s2280c19f1;
  void *s2280c19f2[2];
  long s2280c19f3;
  long s2280c19f4;
  long s2280c19f5;
  long s2280c19f6[5];
  long s2280c19f7;
  short s2280c19f8;
  char s2280c19f9;
  char s2280c19f10;
  char s2280c19f11;
};
//SIG(-1 S2280C19) C1{ Fp[4] Fl[9] Fs Fc[3]}



static void Test_S2280C19()
{
  {
    init_simple_test("S2280C19");
    S2280C19 lv;
    check2(sizeof(lv), ABISELECT(112,60), "sizeof(S2280C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C19)");
    check_field_offset(lv, s2280c19f0, 0, "S2280C19.s2280c19f0");
    check_field_offset(lv, s2280c19f1, ABISELECT(8,4), "S2280C19.s2280c19f1");
    check_field_offset(lv, s2280c19f2, ABISELECT(16,8), "S2280C19.s2280c19f2");
    check_field_offset(lv, s2280c19f3, ABISELECT(32,16), "S2280C19.s2280c19f3");
    check_field_offset(lv, s2280c19f4, ABISELECT(40,20), "S2280C19.s2280c19f4");
    check_field_offset(lv, s2280c19f5, ABISELECT(48,24), "S2280C19.s2280c19f5");
    check_field_offset(lv, s2280c19f6, ABISELECT(56,28), "S2280C19.s2280c19f6");
    check_field_offset(lv, s2280c19f7, ABISELECT(96,48), "S2280C19.s2280c19f7");
    check_field_offset(lv, s2280c19f8, ABISELECT(104,52), "S2280C19.s2280c19f8");
    check_field_offset(lv, s2280c19f9, ABISELECT(106,54), "S2280C19.s2280c19f9");
    check_field_offset(lv, s2280c19f10, ABISELECT(107,55), "S2280C19.s2280c19f10");
    check_field_offset(lv, s2280c19f11, ABISELECT(108,56), "S2280C19.s2280c19f11");
  }
}
static Arrange_To_Call_Me vS2280C19(Test_S2280C19, "S2280C19", ABISELECT(112,60));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C18  {
  short s2280c18f0;
  short s2280c18f1;
  short s2280c18f2;
  ::S2280C19 s2280c18f3;
  char s2280c18f4;
};
//SIG(-1 S2280C18) C1{ Fs[3] FC2{ Fp[4] Fl[9] Fs Fc[3]} Fc}



static void Test_S2280C18()
{
  {
    init_simple_test("S2280C18");
    S2280C18 lv;
    check2(sizeof(lv), ABISELECT(128,72), "sizeof(S2280C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C18)");
    check_field_offset(lv, s2280c18f0, 0, "S2280C18.s2280c18f0");
    check_field_offset(lv, s2280c18f1, 2, "S2280C18.s2280c18f1");
    check_field_offset(lv, s2280c18f2, 4, "S2280C18.s2280c18f2");
    check_field_offset(lv, s2280c18f3, 8, "S2280C18.s2280c18f3");
    check_field_offset(lv, s2280c18f4, ABISELECT(120,68), "S2280C18.s2280c18f4");
  }
}
static Arrange_To_Call_Me vS2280C18(Test_S2280C18, "S2280C18", ABISELECT(128,72));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C20  {
  short s2280c20f0;
  short s2280c20f1;
  short s2280c20f2;
};
//SIG(-1 S2280C20) C1{ Fs[3]}



static void Test_S2280C20()
{
  {
    init_simple_test("S2280C20");
    S2280C20 lv;
    check2(sizeof(lv), 6, "sizeof(S2280C20)");
    check2(__alignof__(lv), 2, "__alignof__(S2280C20)");
    check_field_offset(lv, s2280c20f0, 0, "S2280C20.s2280c20f0");
    check_field_offset(lv, s2280c20f1, 2, "S2280C20.s2280c20f1");
    check_field_offset(lv, s2280c20f2, 4, "S2280C20.s2280c20f2");
  }
}
static Arrange_To_Call_Me vS2280C20(Test_S2280C20, "S2280C20", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C17  {
  void *s2280c17f0;
  ::S2280C18 s2280c17f1;
  ::S2280C20 s2280c17f2;
};
//SIG(-1 S2280C17) C1{ Fp FC2{ Fs[3] FC3{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC4{ Fs[3]}}



static void Test_S2280C17()
{
  {
    init_simple_test("S2280C17");
    S2280C17 lv;
    check2(sizeof(lv), ABISELECT(144,84), "sizeof(S2280C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C17)");
    check_field_offset(lv, s2280c17f0, 0, "S2280C17.s2280c17f0");
    check_field_offset(lv, s2280c17f1, ABISELECT(8,4), "S2280C17.s2280c17f1");
    check_field_offset(lv, s2280c17f2, ABISELECT(136,76), "S2280C17.s2280c17f2");
  }
}
static Arrange_To_Call_Me vS2280C17(Test_S2280C17, "S2280C17", ABISELECT(144,84));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C16  {
  short s2280c16f0;
  ::S2280C17 s2280c16f1;
};
//SIG(-1 S2280C16) C1{ Fs FC2{ Fp FC3{ Fs[3] FC4{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC5{ Fs[3]}}}



static void Test_S2280C16()
{
  {
    init_simple_test("S2280C16");
    S2280C16 lv;
    check2(sizeof(lv), ABISELECT(152,88), "sizeof(S2280C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C16)");
    check_field_offset(lv, s2280c16f0, 0, "S2280C16.s2280c16f0");
    check_field_offset(lv, s2280c16f1, ABISELECT(8,4), "S2280C16.s2280c16f1");
  }
}
static Arrange_To_Call_Me vS2280C16(Test_S2280C16, "S2280C16", ABISELECT(152,88));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C15  {
  short s2280c15f0;
  short s2280c15f1;
  long s2280c15f2;
  ::S2280C16 s2280c15f3[2];
  char s2280c15f4;
  char s2280c15f5;
  char s2280c15f6;
  void *s2280c15f7;
};
//SIG(1 S2280C15) C1{ Fs[2] Fl FC2{ Fs FC3{ Fp FC4{ Fs[3] FC5{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC6{ Fs[3]}}}[2] Fc[3] Fp}



static void Test_S2280C15()
{
  {
    init_simple_test("S2280C15");
    S2280C15 lv;
    check2(sizeof(lv), ABISELECT(336,192), "sizeof(S2280C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C15)");
    check_field_offset(lv, s2280c15f0, 0, "S2280C15.s2280c15f0");
    check_field_offset(lv, s2280c15f1, 2, "S2280C15.s2280c15f1");
    check_field_offset(lv, s2280c15f2, ABISELECT(8,4), "S2280C15.s2280c15f2");
    check_field_offset(lv, s2280c15f3, ABISELECT(16,8), "S2280C15.s2280c15f3");
    check_field_offset(lv, s2280c15f4, ABISELECT(320,184), "S2280C15.s2280c15f4");
    check_field_offset(lv, s2280c15f5, ABISELECT(321,185), "S2280C15.s2280c15f5");
    check_field_offset(lv, s2280c15f6, ABISELECT(322,186), "S2280C15.s2280c15f6");
    check_field_offset(lv, s2280c15f7, ABISELECT(328,188), "S2280C15.s2280c15f7");
  }
}
static Arrange_To_Call_Me vS2280C15(Test_S2280C15, "S2280C15", ABISELECT(336,192));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C21  {
  short s2280c21f0;
  short s2280c21f1;
  short s2280c21f2;
  short s2280c21f3;
  short s2280c21f4;
  short s2280c21f5;
  short s2280c21f6;
  short s2280c21f7;
  short s2280c21f8;
};
//SIG(-1 S2280C21) C1{ Fs[9]}



static void Test_S2280C21()
{
  {
    init_simple_test("S2280C21");
    S2280C21 lv;
    check2(sizeof(lv), 18, "sizeof(S2280C21)");
    check2(__alignof__(lv), 2, "__alignof__(S2280C21)");
    check_field_offset(lv, s2280c21f0, 0, "S2280C21.s2280c21f0");
    check_field_offset(lv, s2280c21f1, 2, "S2280C21.s2280c21f1");
    check_field_offset(lv, s2280c21f2, 4, "S2280C21.s2280c21f2");
    check_field_offset(lv, s2280c21f3, 6, "S2280C21.s2280c21f3");
    check_field_offset(lv, s2280c21f4, 8, "S2280C21.s2280c21f4");
    check_field_offset(lv, s2280c21f5, 10, "S2280C21.s2280c21f5");
    check_field_offset(lv, s2280c21f6, 12, "S2280C21.s2280c21f6");
    check_field_offset(lv, s2280c21f7, 14, "S2280C21.s2280c21f7");
    check_field_offset(lv, s2280c21f8, 16, "S2280C21.s2280c21f8");
  }
}
static Arrange_To_Call_Me vS2280C21(Test_S2280C21, "S2280C21", 18);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C22  {
  void *s2280c22f0;
  char s2280c22f1;
  char s2280c22f2;
  char s2280c22f3;
};
//SIG(-1 S2280C22) C1{ Fp Fc[3]}



static void Test_S2280C22()
{
  {
    init_simple_test("S2280C22");
    S2280C22 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S2280C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C22)");
    check_field_offset(lv, s2280c22f0, 0, "S2280C22.s2280c22f0");
    check_field_offset(lv, s2280c22f1, ABISELECT(8,4), "S2280C22.s2280c22f1");
    check_field_offset(lv, s2280c22f2, ABISELECT(9,5), "S2280C22.s2280c22f2");
    check_field_offset(lv, s2280c22f3, ABISELECT(10,6), "S2280C22.s2280c22f3");
  }
}
static Arrange_To_Call_Me vS2280C22(Test_S2280C22, "S2280C22", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C14  {
  ::S2280C15 s2280c14f0[101];
  short s2280c14f1;
  short s2280c14f2;
  void *s2280c14f3;
  char s2280c14f4;
  ::S2280C6 s2280c14f5;
  ::S2280C6 s2280c14f6;
  ::S2280C21 s2280c14f7;
  ::S2280C22 s2280c14f8;
  short s2280c14f9;
};
//SIG(1 S2280C14) C1{ FC2{ Fs[2] Fl FC3{ Fs FC4{ Fp FC5{ Fs[3] FC6{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC7{ Fs[3]}}}[2] Fc[3] Fp}[101] Fs[2] Fp Fc FC8{ FC9{ Fc[2] Fp[4] FC10{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} FC8 FC11{ Fs[9]} FC12{ Fp Fc[3]} Fs}



static void Test_S2280C14()
{
  {
    init_simple_test("S2280C14");
    S2280C14 lv;
    check2(sizeof(lv), ABISELECT(35768,20492), "sizeof(S2280C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C14)");
    check_field_offset(lv, s2280c14f0, 0, "S2280C14.s2280c14f0");
    check_field_offset(lv, s2280c14f1, ABISELECT(33936,19392), "S2280C14.s2280c14f1");
    check_field_offset(lv, s2280c14f2, ABISELECT(33938,19394), "S2280C14.s2280c14f2");
    check_field_offset(lv, s2280c14f3, ABISELECT(33944,19396), "S2280C14.s2280c14f3");
    check_field_offset(lv, s2280c14f4, ABISELECT(33952,19400), "S2280C14.s2280c14f4");
    check_field_offset(lv, s2280c14f5, ABISELECT(33960,19404), "S2280C14.s2280c14f5");
    check_field_offset(lv, s2280c14f6, ABISELECT(34840,19932), "S2280C14.s2280c14f6");
    check_field_offset(lv, s2280c14f7, ABISELECT(35720,20460), "S2280C14.s2280c14f7");
    check_field_offset(lv, s2280c14f8, ABISELECT(35744,20480), "S2280C14.s2280c14f8");
    check_field_offset(lv, s2280c14f9, ABISELECT(35760,20488), "S2280C14.s2280c14f9");
  }
}
static Arrange_To_Call_Me vS2280C14(Test_S2280C14, "S2280C14", ABISELECT(35768,20492));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C25  {
  void *s2280c25f0;
  void *s2280c25f1;
  char s2280c25f2;
  char s2280c25f3;
};
//SIG(-1 S2280C25) C1{ Fp[2] Fc[2]}



static void Test_S2280C25()
{
  {
    init_simple_test("S2280C25");
    S2280C25 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S2280C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C25)");
    check_field_offset(lv, s2280c25f0, 0, "S2280C25.s2280c25f0");
    check_field_offset(lv, s2280c25f1, ABISELECT(8,4), "S2280C25.s2280c25f1");
    check_field_offset(lv, s2280c25f2, ABISELECT(16,8), "S2280C25.s2280c25f2");
    check_field_offset(lv, s2280c25f3, ABISELECT(17,9), "S2280C25.s2280c25f3");
  }
}
static Arrange_To_Call_Me vS2280C25(Test_S2280C25, "S2280C25", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C23  {
  void *s2280c23f0;
  ::S2280C20 s2280c23f1[41];
  short s2280c23f2;
  void *s2280c23f3;
  ::S2280C16 s2280c23f4[301];
  short s2280c23f5;
  short s2280c23f6[301];
  short s2280c23f7;
  ::S2280C6 s2280c23f8;
  ::S2280C6 s2280c23f9;
  ::S2280C6 s2280c23f10;
  ::S2280C21 s2280c23f11;
  ::S2280C25 s2280c23f12;
};
//SIG(1 S2280C23) C1{ Fp FC2{ Fs[3]}[41] Fs Fp FC3{ Fs FC4{ Fp FC5{ Fs[3] FC6{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC2}}[301] Fs[303] FC7{ FC8{ Fc[2] Fp[4] FC9{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} FC7 FC7 FC10{ Fs[9]} FC11{ Fp[2] Fc[2]}}



static void Test_S2280C23()
{
  {
    init_simple_test("S2280C23");
    S2280C23 lv;
    check2(sizeof(lv), ABISELECT(49312,28968), "sizeof(S2280C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C23)");
    check_field_offset(lv, s2280c23f0, 0, "S2280C23.s2280c23f0");
    check_field_offset(lv, s2280c23f1, ABISELECT(8,4), "S2280C23.s2280c23f1");
    check_field_offset(lv, s2280c23f2, ABISELECT(254,250), "S2280C23.s2280c23f2");
    check_field_offset(lv, s2280c23f3, ABISELECT(256,252), "S2280C23.s2280c23f3");
    check_field_offset(lv, s2280c23f4, ABISELECT(264,256), "S2280C23.s2280c23f4");
    check_field_offset(lv, s2280c23f5, ABISELECT(46016,26744), "S2280C23.s2280c23f5");
    check_field_offset(lv, s2280c23f6, ABISELECT(46018,26746), "S2280C23.s2280c23f6");
    check_field_offset(lv, s2280c23f7, ABISELECT(46620,27348), "S2280C23.s2280c23f7");
    check_field_offset(lv, s2280c23f8, ABISELECT(46624,27352), "S2280C23.s2280c23f8");
    check_field_offset(lv, s2280c23f9, ABISELECT(47504,27880), "S2280C23.s2280c23f9");
    check_field_offset(lv, s2280c23f10, ABISELECT(48384,28408), "S2280C23.s2280c23f10");
    check_field_offset(lv, s2280c23f11, ABISELECT(49264,28936), "S2280C23.s2280c23f11");
    check_field_offset(lv, s2280c23f12, ABISELECT(49288,28956), "S2280C23.s2280c23f12");
  }
}
static Arrange_To_Call_Me vS2280C23(Test_S2280C23, "S2280C23", ABISELECT(49312,28968));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S2280C13  {
  ::S2280C14 s2280c13f0;
  ::S2280C23 s2280c13f1;
};
//SIG(1 S2280C13) U1{ FC2{ FC3{ Fs Fs Fl FC4{ Fs FC5{ Fp FC6{ Fs Fs Fs FC7{ Fp Fp Fp[2] Fl Fl Fl Fl[5] Fl Fs Fc Fc Fc} Fc} FC8{ Fs Fs Fs}}}[2] Fc Fc Fc Fp}[101] Fs Fs Fp Fc FC9{ FC10{ Fc[2] Fp[4] FC11{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} FC9 FC12{ Fs Fs Fs Fs Fs Fs Fs Fs Fs} FC13{ Fp Fc Fc Fc} Fs} FC14{ Fp FC8[41] Fs Fp FC4[301] Fs Fs[301] Fs FC9 FC9 FC9 FC12 FC15{ Fp Fp Fc Fc}}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S2280C27  {
  void *s2280c27f0;
  ::S2280C16 s2280c27f1[6];
  char s2280c27f2;
  char s2280c27f3;
};
//SIG(1 S2280C27) C1{ Fp FC2{ Fs FC3{ Fp FC4{ Fs[3] FC5{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC6{ Fs[3]}}}[6] Fc[2]}



static void Test_S2280C27()
{
  {
    init_simple_test("S2280C27");
    S2280C27 lv;
    check2(sizeof(lv), ABISELECT(928,536), "sizeof(S2280C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C27)");
    check_field_offset(lv, s2280c27f0, 0, "S2280C27.s2280c27f0");
    check_field_offset(lv, s2280c27f1, ABISELECT(8,4), "S2280C27.s2280c27f1");
    check_field_offset(lv, s2280c27f2, ABISELECT(920,532), "S2280C27.s2280c27f2");
    check_field_offset(lv, s2280c27f3, ABISELECT(921,533), "S2280C27.s2280c27f3");
  }
}
static Arrange_To_Call_Me vS2280C27(Test_S2280C27, "S2280C27", ABISELECT(928,536));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C26  {
  ::S2280C27 s2280c26f0[40];
  short s2280c26f1;
};
//SIG(-1 S2280C26) C1{ FC2{ Fp FC3{ Fs FC4{ Fp FC5{ Fs[3] FC6{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC7{ Fs[3]}}}[6] Fc[2]}[40] Fs}



static void Test_S2280C26()
{
  {
    init_simple_test("S2280C26");
    S2280C26 lv;
    check2(sizeof(lv), ABISELECT(37128,21444), "sizeof(S2280C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C26)");
    check_field_offset(lv, s2280c26f0, 0, "S2280C26.s2280c26f0");
    check_field_offset(lv, s2280c26f1, ABISELECT(37120,21440), "S2280C26.s2280c26f1");
  }
}
static Arrange_To_Call_Me vS2280C26(Test_S2280C26, "S2280C26", ABISELECT(37128,21444));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C30  {
  void *s2280c30f0;
  short s2280c30f1;
  short s2280c30f2;
  void *s2280c30f3;
  short s2280c30f4;
  short s2280c30f5;
  void *s2280c30f6;
  short s2280c30f7;
};
//SIG(-1 S2280C30) C1{ Fp Fs[2] Fp Fs[2] Fp Fs}



static void Test_S2280C30()
{
  {
    init_simple_test("S2280C30");
    S2280C30 lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(S2280C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C30)");
    check_field_offset(lv, s2280c30f0, 0, "S2280C30.s2280c30f0");
    check_field_offset(lv, s2280c30f1, ABISELECT(8,4), "S2280C30.s2280c30f1");
    check_field_offset(lv, s2280c30f2, ABISELECT(10,6), "S2280C30.s2280c30f2");
    check_field_offset(lv, s2280c30f3, ABISELECT(16,8), "S2280C30.s2280c30f3");
    check_field_offset(lv, s2280c30f4, ABISELECT(24,12), "S2280C30.s2280c30f4");
    check_field_offset(lv, s2280c30f5, ABISELECT(26,14), "S2280C30.s2280c30f5");
    check_field_offset(lv, s2280c30f6, ABISELECT(32,16), "S2280C30.s2280c30f6");
    check_field_offset(lv, s2280c30f7, ABISELECT(40,20), "S2280C30.s2280c30f7");
  }
}
static Arrange_To_Call_Me vS2280C30(Test_S2280C30, "S2280C30", ABISELECT(48,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C29  {
  char s2280c29f0;
  char s2280c29f1;
  void *s2280c29f2;
  ::S2280C30 s2280c29f3;
  void *s2280c29f4;
  short s2280c29f5;
  short s2280c29f6;
  void *s2280c29f7;
  void *s2280c29f8;
  char s2280c29f9;
  char s2280c29f10;
};
//SIG(-1 S2280C29) C1{ Fc[2] Fp FC2{ Fp Fs[2] Fp Fs[2] Fp Fs} Fp Fs[2] Fp[2] Fc[2]}



static void Test_S2280C29()
{
  {
    init_simple_test("S2280C29");
    S2280C29 lv;
    check2(sizeof(lv), ABISELECT(104,52), "sizeof(S2280C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C29)");
    check_field_offset(lv, s2280c29f0, 0, "S2280C29.s2280c29f0");
    check_field_offset(lv, s2280c29f1, 1, "S2280C29.s2280c29f1");
    check_field_offset(lv, s2280c29f2, ABISELECT(8,4), "S2280C29.s2280c29f2");
    check_field_offset(lv, s2280c29f3, ABISELECT(16,8), "S2280C29.s2280c29f3");
    check_field_offset(lv, s2280c29f4, ABISELECT(64,32), "S2280C29.s2280c29f4");
    check_field_offset(lv, s2280c29f5, ABISELECT(72,36), "S2280C29.s2280c29f5");
    check_field_offset(lv, s2280c29f6, ABISELECT(74,38), "S2280C29.s2280c29f6");
    check_field_offset(lv, s2280c29f7, ABISELECT(80,40), "S2280C29.s2280c29f7");
    check_field_offset(lv, s2280c29f8, ABISELECT(88,44), "S2280C29.s2280c29f8");
    check_field_offset(lv, s2280c29f9, ABISELECT(96,48), "S2280C29.s2280c29f9");
    check_field_offset(lv, s2280c29f10, ABISELECT(97,49), "S2280C29.s2280c29f10");
  }
}
static Arrange_To_Call_Me vS2280C29(Test_S2280C29, "S2280C29", ABISELECT(104,52));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C31  {
  short s2280c31f0;
  ::S2280C8_nt s2280c31f1;
  short s2280c31f2;
  short s2280c31f3;
  ::S2280C19 s2280c31f4;
};
//SIG(1 S2280C31) C1{ Fs FC2{ Fs[2]} Fs[2] FC3{ Fp[4] Fl[9] Fs Fc[3]}}



static void Test_S2280C31()
{
  {
    init_simple_test("S2280C31");
    S2280C31 lv;
    check2(sizeof(lv), ABISELECT(128,72), "sizeof(S2280C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C31)");
    check_field_offset(lv, s2280c31f0, 0, "S2280C31.s2280c31f0");
    check_field_offset(lv, s2280c31f1, 2, "S2280C31.s2280c31f1");
    check_field_offset(lv, s2280c31f2, 6, "S2280C31.s2280c31f2");
    check_field_offset(lv, s2280c31f3, 8, "S2280C31.s2280c31f3");
    check_field_offset(lv, s2280c31f4, ABISELECT(16,12), "S2280C31.s2280c31f4");
  }
}
static Arrange_To_Call_Me vS2280C31(Test_S2280C31, "S2280C31", ABISELECT(128,72));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C28  {
  ::S2280C29 s2280c28f0;
  ::S2280C31 s2280c28f1[12];
};
//SIG(-1 S2280C28) C1{ FC2{ Fc[2] Fp FC3{ Fp Fs[2] Fp Fs[2] Fp Fs} Fp Fs[2] Fp[2] Fc[2]} FC4{ Fs FC5{ Fs[2]} Fs[2] FC6{ Fp[4] Fl[9] Fs Fc[3]}}[12]}



static void Test_S2280C28()
{
  {
    init_simple_test("S2280C28");
    S2280C28 lv;
    check2(sizeof(lv), ABISELECT(1640,916), "sizeof(S2280C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C28)");
    check_field_offset(lv, s2280c28f0, 0, "S2280C28.s2280c28f0");
    check_field_offset(lv, s2280c28f1, ABISELECT(104,52), "S2280C28.s2280c28f1");
  }
}
static Arrange_To_Call_Me vS2280C28(Test_S2280C28, "S2280C28", ABISELECT(1640,916));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C32  {
  short s2280c32f0;
  char s2280c32f1;
  short s2280c32f2;
  short s2280c32f3;
  char s2280c32f4;
  char s2280c32f5;
  char s2280c32f6;
  char s2280c32f7;
  char s2280c32f8;
};
//SIG(-1 S2280C32) C1{ Fs Fc Fs[2] Fc[5]}



static void Test_S2280C32()
{
  {
    init_simple_test("S2280C32");
    S2280C32 lv;
    check2(sizeof(lv), 14, "sizeof(S2280C32)");
    check2(__alignof__(lv), 2, "__alignof__(S2280C32)");
    check_field_offset(lv, s2280c32f0, 0, "S2280C32.s2280c32f0");
    check_field_offset(lv, s2280c32f1, 2, "S2280C32.s2280c32f1");
    check_field_offset(lv, s2280c32f2, 4, "S2280C32.s2280c32f2");
    check_field_offset(lv, s2280c32f3, 6, "S2280C32.s2280c32f3");
    check_field_offset(lv, s2280c32f4, 8, "S2280C32.s2280c32f4");
    check_field_offset(lv, s2280c32f5, 9, "S2280C32.s2280c32f5");
    check_field_offset(lv, s2280c32f6, 10, "S2280C32.s2280c32f6");
    check_field_offset(lv, s2280c32f7, 11, "S2280C32.s2280c32f7");
    check_field_offset(lv, s2280c32f8, 12, "S2280C32.s2280c32f8");
  }
}
static Arrange_To_Call_Me vS2280C32(Test_S2280C32, "S2280C32", 14);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C34  {
  short s2280c34f0;
  short s2280c34f1;
  char s2280c34f2;
  char s2280c34f3;
  char s2280c34f4;
  short s2280c34f5[41];
  short s2280c34f6[41];
  short s2280c34f7[41];
  long s2280c34f8;
  short s2280c34f9;
  char s2280c34f10;
};
//SIG(-1 S2280C34) C1{ Fs[2] Fc[3] Fs[123] Fl Fs Fc}



static void Test_S2280C34()
{
  {
    init_simple_test("S2280C34");
    S2280C34 lv;
    check2(sizeof(lv), ABISELECT(272,264), "sizeof(S2280C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C34)");
    check_field_offset(lv, s2280c34f0, 0, "S2280C34.s2280c34f0");
    check_field_offset(lv, s2280c34f1, 2, "S2280C34.s2280c34f1");
    check_field_offset(lv, s2280c34f2, 4, "S2280C34.s2280c34f2");
    check_field_offset(lv, s2280c34f3, 5, "S2280C34.s2280c34f3");
    check_field_offset(lv, s2280c34f4, 6, "S2280C34.s2280c34f4");
    check_field_offset(lv, s2280c34f5, 8, "S2280C34.s2280c34f5");
    check_field_offset(lv, s2280c34f6, 90, "S2280C34.s2280c34f6");
    check_field_offset(lv, s2280c34f7, 172, "S2280C34.s2280c34f7");
    check_field_offset(lv, s2280c34f8, 256, "S2280C34.s2280c34f8");
    check_field_offset(lv, s2280c34f9, ABISELECT(264,260), "S2280C34.s2280c34f9");
    check_field_offset(lv, s2280c34f10, ABISELECT(266,262), "S2280C34.s2280c34f10");
  }
}
static Arrange_To_Call_Me vS2280C34(Test_S2280C34, "S2280C34", ABISELECT(272,264));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C33  {
  ::S2280C34 s2280c33f0[5];
  ::S2280C34 s2280c33f1;
  char s2280c33f2;
  char s2280c33f3;
};
//SIG(-1 S2280C33) C1{ FC2{ Fs[2] Fc[3] Fs[123] Fl Fs Fc}[5] FC2 Fc[2]}



static void Test_S2280C33()
{
  {
    init_simple_test("S2280C33");
    S2280C33 lv;
    check2(sizeof(lv), ABISELECT(1640,1588), "sizeof(S2280C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C33)");
    check_field_offset(lv, s2280c33f0, 0, "S2280C33.s2280c33f0");
    check_field_offset(lv, s2280c33f1, ABISELECT(1360,1320), "S2280C33.s2280c33f1");
    check_field_offset(lv, s2280c33f2, ABISELECT(1632,1584), "S2280C33.s2280c33f2");
    check_field_offset(lv, s2280c33f3, ABISELECT(1633,1585), "S2280C33.s2280c33f3");
  }
}
static Arrange_To_Call_Me vS2280C33(Test_S2280C33, "S2280C33", ABISELECT(1640,1588));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C36  {
  short s2280c36f0[12341];
  short s2280c36f1;
};
//SIG(1 S2280C36) C1{ Fs[12342]}



static void Test_S2280C36()
{
  {
    init_simple_test("S2280C36");
    S2280C36 lv;
    check2(sizeof(lv), 24684, "sizeof(S2280C36)");
    check2(__alignof__(lv), 2, "__alignof__(S2280C36)");
    check_field_offset(lv, s2280c36f0, 0, "S2280C36.s2280c36f0");
    check_field_offset(lv, s2280c36f1, 24682, "S2280C36.s2280c36f1");
  }
}
static Arrange_To_Call_Me vS2280C36(Test_S2280C36, "S2280C36", 24684);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C37  {
  short s2280c37f0[2091];
  short s2280c37f1;
};
//SIG(1 S2280C37) C1{ Fs[2092]}



static void Test_S2280C37()
{
  {
    init_simple_test("S2280C37");
    S2280C37 lv;
    check2(sizeof(lv), 4184, "sizeof(S2280C37)");
    check2(__alignof__(lv), 2, "__alignof__(S2280C37)");
    check_field_offset(lv, s2280c37f0, 0, "S2280C37.s2280c37f0");
    check_field_offset(lv, s2280c37f1, 4182, "S2280C37.s2280c37f1");
  }
}
static Arrange_To_Call_Me vS2280C37(Test_S2280C37, "S2280C37", 4184);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S2280C35  {
  ::S2280C36 s2280c35f0;
  ::S2280C37 s2280c35f1;
};
//SIG(1 S2280C35) U1{ FC2{ Fs[12341] Fs} FC3{ Fs[2091] Fs}}

#endif // __cplusplus
#ifdef __cplusplus

struct  S2280C39  {
  short s2280c39f0;
  short s2280c39f1;
  short s2280c39f2;
  char s2280c39f3;
  char s2280c39f4;
};
//SIG(-1 S2280C39) C1{ Fs[3] Fc[2]}



static void Test_S2280C39()
{
  {
    init_simple_test("S2280C39");
    S2280C39 lv;
    check2(sizeof(lv), 8, "sizeof(S2280C39)");
    check2(__alignof__(lv), 2, "__alignof__(S2280C39)");
    check_field_offset(lv, s2280c39f0, 0, "S2280C39.s2280c39f0");
    check_field_offset(lv, s2280c39f1, 2, "S2280C39.s2280c39f1");
    check_field_offset(lv, s2280c39f2, 4, "S2280C39.s2280c39f2");
    check_field_offset(lv, s2280c39f3, 6, "S2280C39.s2280c39f3");
    check_field_offset(lv, s2280c39f4, 7, "S2280C39.s2280c39f4");
  }
}
static Arrange_To_Call_Me vS2280C39(Test_S2280C39, "S2280C39", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C40  {
  ::S2280C16 s2280c40f0[2];
  short s2280c40f1;
  ::S2280C16 s2280c40f2[40];
  short s2280c40f3;
};
//SIG(-1 S2280C40) C1{ FC2{ Fs FC3{ Fp FC4{ Fs[3] FC5{ Fp[4] Fl[9] Fs Fc[3]} Fc} FC6{ Fs[3]}}}[2] Fs FC2[40] Fs}



static void Test_S2280C40()
{
  {
    init_simple_test("S2280C40");
    S2280C40 lv;
    check2(sizeof(lv), ABISELECT(6400,3704), "sizeof(S2280C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C40)");
    check_field_offset(lv, s2280c40f0, 0, "S2280C40.s2280c40f0");
    check_field_offset(lv, s2280c40f1, ABISELECT(304,176), "S2280C40.s2280c40f1");
    check_field_offset(lv, s2280c40f2, ABISELECT(312,180), "S2280C40.s2280c40f2");
    check_field_offset(lv, s2280c40f3, ABISELECT(6392,3700), "S2280C40.s2280c40f3");
  }
}
static Arrange_To_Call_Me vS2280C40(Test_S2280C40, "S2280C40", ABISELECT(6400,3704));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C38  {
  void *s2280c38f0;
  ::S2280C6 s2280c38f1;
  char s2280c38f2;
  ::S2280C28 s2280c38f3;
  void *s2280c38f4;
  short s2280c38f5;
  short s2280c38f6;
  short s2280c38f7;
  short s2280c38f8;
  ::S2280C39 s2280c38f9;
  ::S2280C40 s2280c38f10;
  short s2280c38f11;
  short s2280c38f12;
  short s2280c38f13;
};
//SIG(-1 S2280C38) C1{ Fp FC2{ FC3{ Fc[2] Fp[4] FC4{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} Fc FC5{ FC6{ Fc[2] Fp FC7{ Fp Fs[2] Fp Fs[2] Fp Fs} Fp Fs[2] Fp[2] Fc[2]} FC8{ Fs FC4 Fs[2] FC9{ Fp[4] Fl[9] Fs Fc[3]}}[12]} Fp Fs[4] FC10{ Fs[3] Fc[2]} FC11{ FC12{ Fs FC13{ Fp FC14{ Fs[3] FC9 Fc} FC15{ Fs[3]}}}[2] Fs FC12[40] Fs} Fs[3]}



static void Test_S2280C38()
{
  {
    init_simple_test("S2280C38");
    S2280C38 lv;
    check2(sizeof(lv), ABISELECT(8968,5184), "sizeof(S2280C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C38)");
    check_field_offset(lv, s2280c38f0, 0, "S2280C38.s2280c38f0");
    check_field_offset(lv, s2280c38f1, ABISELECT(8,4), "S2280C38.s2280c38f1");
    check_field_offset(lv, s2280c38f2, ABISELECT(888,532), "S2280C38.s2280c38f2");
    check_field_offset(lv, s2280c38f3, ABISELECT(896,536), "S2280C38.s2280c38f3");
    check_field_offset(lv, s2280c38f4, ABISELECT(2536,1452), "S2280C38.s2280c38f4");
    check_field_offset(lv, s2280c38f5, ABISELECT(2544,1456), "S2280C38.s2280c38f5");
    check_field_offset(lv, s2280c38f6, ABISELECT(2546,1458), "S2280C38.s2280c38f6");
    check_field_offset(lv, s2280c38f7, ABISELECT(2548,1460), "S2280C38.s2280c38f7");
    check_field_offset(lv, s2280c38f8, ABISELECT(2550,1462), "S2280C38.s2280c38f8");
    check_field_offset(lv, s2280c38f9, ABISELECT(2552,1464), "S2280C38.s2280c38f9");
    check_field_offset(lv, s2280c38f10, ABISELECT(2560,1472), "S2280C38.s2280c38f10");
    check_field_offset(lv, s2280c38f11, ABISELECT(8960,5176), "S2280C38.s2280c38f11");
    check_field_offset(lv, s2280c38f12, ABISELECT(8962,5178), "S2280C38.s2280c38f12");
    check_field_offset(lv, s2280c38f13, ABISELECT(8964,5180), "S2280C38.s2280c38f13");
  }
}
static Arrange_To_Call_Me vS2280C38(Test_S2280C38, "S2280C38", ABISELECT(8968,5184));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C41  {
  short s2280c41f0;
  short s2280c41f1;
  void *s2280c41f2;
  void *s2280c41f3;
  void *s2280c41f4;
  void *s2280c41f5;
};
//SIG(-1 S2280C41) C1{ Fs[2] Fp[4]}



static void Test_S2280C41()
{
  {
    init_simple_test("S2280C41");
    S2280C41 lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S2280C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C41)");
    check_field_offset(lv, s2280c41f0, 0, "S2280C41.s2280c41f0");
    check_field_offset(lv, s2280c41f1, 2, "S2280C41.s2280c41f1");
    check_field_offset(lv, s2280c41f2, ABISELECT(8,4), "S2280C41.s2280c41f2");
    check_field_offset(lv, s2280c41f3, ABISELECT(16,8), "S2280C41.s2280c41f3");
    check_field_offset(lv, s2280c41f4, ABISELECT(24,12), "S2280C41.s2280c41f4");
    check_field_offset(lv, s2280c41f5, ABISELECT(32,16), "S2280C41.s2280c41f5");
  }
}
static Arrange_To_Call_Me vS2280C41(Test_S2280C41, "S2280C41", ABISELECT(40,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C42  {
  short s2280c42f0[16];
  short s2280c42f1[2];
  void *s2280c42f2;
};
//SIG(-1 S2280C42) C1{ Fs[18] Fp}



static void Test_S2280C42()
{
  {
    init_simple_test("S2280C42");
    S2280C42 lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S2280C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C42)");
    check_field_offset(lv, s2280c42f0, 0, "S2280C42.s2280c42f0");
    check_field_offset(lv, s2280c42f1, 32, "S2280C42.s2280c42f1");
    check_field_offset(lv, s2280c42f2, ABISELECT(40,36), "S2280C42.s2280c42f2");
  }
}
static Arrange_To_Call_Me vS2280C42(Test_S2280C42, "S2280C42", ABISELECT(48,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C43  {
  char s2280c43f0;
  short s2280c43f1;
  short s2280c43f2;
  short s2280c43f3;
};
//SIG(-1 S2280C43) C1{ Fc Fs[3]}



static void Test_S2280C43()
{
  {
    init_simple_test("S2280C43");
    S2280C43 lv;
    check2(sizeof(lv), 8, "sizeof(S2280C43)");
    check2(__alignof__(lv), 2, "__alignof__(S2280C43)");
    check_field_offset(lv, s2280c43f0, 0, "S2280C43.s2280c43f0");
    check_field_offset(lv, s2280c43f1, 2, "S2280C43.s2280c43f1");
    check_field_offset(lv, s2280c43f2, 4, "S2280C43.s2280c43f2");
    check_field_offset(lv, s2280c43f3, 6, "S2280C43.s2280c43f3");
  }
}
static Arrange_To_Call_Me vS2280C43(Test_S2280C43, "S2280C43", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C11  {
  char s2280c11f0[4];
  ::S2280C12 s2280c11f1;
  ::S2280C13 s2280c11f2;
  ::S2280C26 s2280c11f3;
  ::S2280C28 s2280c11f4[40];
  ::S2280C32 s2280c11f5;
  short s2280c11f6[41];
  short s2280c11f7[41];
  ::S2280C33 s2280c11f8;
  long s2280c11f9[24];
  ::S2280C16 s2280c11f10[50];
  long s2280c11f11;
  ::S2280C35 s2280c11f12;
  ::S2280C38 s2280c11f13;
  char s2280c11f14;
  char s2280c11f15[12];
  ::S2280C41 s2280c11f16;
  ::S2280C6 s2280c11f17;
  ::S2280C6 s2280c11f18;
  ::S2280C42 s2280c11f19;
  ::S2280C43 s2280c11f20;
  short s2280c11f21[41];
};
//SIG(-1 S2280C11) C1{ Fc[4] FC2{ Fp Fs Fp Fs[2]} FU3{ FC4{ FC5{ Fs Fs Fl FC6{ Fs FC7{ Fp FC8{ Fs Fs Fs FC9{ Fp Fp Fp[2] Fl Fl Fl Fl[5] Fl Fs Fc Fc Fc} Fc} FC10{ Fs Fs Fs}}}[2] Fc Fc Fc Fp}[101] Fs Fs Fp Fc FC11{ FC12{ Fc[2] Fp[4] FC13{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} FC11 FC14{ Fs Fs Fs Fs Fs Fs Fs Fs Fs} FC15{ Fp Fc Fc Fc} Fs} FC16{ Fp FC10[41] Fs Fp FC6[301] Fs Fs[301] Fs FC11 FC11 FC11 FC14 FC17{ Fp Fp Fc Fc}}} FC18{ FC19{ Fp FC6[6] Fc Fc}[40] Fs} FC20{ FC21{ Fc Fc Fp FC22{ Fp Fs Fs Fp Fs Fs Fp Fs} Fp Fs Fs Fp Fp Fc Fc} FC23{ Fs FC13 Fs Fs FC9}[12]}[40] FC24{ Fs Fc Fs Fs Fc Fc Fc Fc Fc} Fs[41] Fs[41] FC25{ FC26{ Fs Fs Fc Fc Fc Fs[41] Fs[41] Fs[41] Fl Fs Fc}[5] FC26 Fc Fc} Fl[24] FC6[50] Fl FU27{ FC28{ Fs[12341] Fs} FC29{ Fs[2091] Fs}} FC30{ Fp FC11 Fc FC20 Fp Fs Fs Fs Fs FC31{ Fs Fs Fs Fc Fc} FC32{ FC6[2] Fs FC6[40] Fs} Fs Fs Fs} Fc Fc[12] FC33{ Fs Fs Fp Fp Fp Fp} FC11 FC11 FC34{ Fs[16] Fs[2] Fp} FC35{ Fc Fs Fs Fs} Fs[41]}



static void Test_S2280C11()
{
  {
    init_simple_test("S2280C11");
    S2280C11 lv;
    check2(sizeof(lv), ABISELECT(197320,124432), "sizeof(S2280C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C11)");
    check_field_offset(lv, s2280c11f0, 0, "S2280C11.s2280c11f0");
    check_field_offset(lv, s2280c11f1, ABISELECT(8,4), "S2280C11.s2280c11f1");
    check_field_offset(lv, s2280c11f2, ABISELECT(40,20), "S2280C11.s2280c11f2");
    check_field_offset(lv, s2280c11f3, ABISELECT(49352,28988), "S2280C11.s2280c11f3");
    check_field_offset(lv, s2280c11f4, ABISELECT(86480,50432), "S2280C11.s2280c11f4");
    check_field_offset(lv, s2280c11f5, ABISELECT(152080,87072), "S2280C11.s2280c11f5");
    check_field_offset(lv, s2280c11f6, ABISELECT(152094,87086), "S2280C11.s2280c11f6");
    check_field_offset(lv, s2280c11f7, ABISELECT(152176,87168), "S2280C11.s2280c11f7");
    check_field_offset(lv, s2280c11f8, ABISELECT(152264,87252), "S2280C11.s2280c11f8");
    check_field_offset(lv, s2280c11f9, ABISELECT(153904,88840), "S2280C11.s2280c11f9");
    check_field_offset(lv, s2280c11f10, ABISELECT(154096,88936), "S2280C11.s2280c11f10");
    check_field_offset(lv, s2280c11f11, ABISELECT(161696,93336), "S2280C11.s2280c11f11");
    check_field_offset(lv, s2280c11f12, ABISELECT(161704,93340), "S2280C11.s2280c11f12");
    check_field_offset(lv, s2280c11f13, ABISELECT(186392,118024), "S2280C11.s2280c11f13");
    check_field_offset(lv, s2280c11f14, ABISELECT(195360,123208), "S2280C11.s2280c11f14");
    check_field_offset(lv, s2280c11f15, ABISELECT(195361,123209), "S2280C11.s2280c11f15");
    check_field_offset(lv, s2280c11f16, ABISELECT(195376,123224), "S2280C11.s2280c11f16");
    check_field_offset(lv, s2280c11f17, ABISELECT(195416,123244), "S2280C11.s2280c11f17");
    check_field_offset(lv, s2280c11f18, ABISELECT(196296,123772), "S2280C11.s2280c11f18");
    check_field_offset(lv, s2280c11f19, ABISELECT(197176,124300), "S2280C11.s2280c11f19");
    check_field_offset(lv, s2280c11f20, ABISELECT(197224,124340), "S2280C11.s2280c11f20");
    check_field_offset(lv, s2280c11f21, ABISELECT(197232,124348), "S2280C11.s2280c11f21");
  }
}
static Arrange_To_Call_Me vS2280C11(Test_S2280C11, "S2280C11", ABISELECT(197320,124432));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C44_nt  {
  void *s2280c44f0;
  int s2280c44f1;
  void *s2280c44f2;
  void  mf2280c44(); // _ZN11S2280C44_nt9mf2280c44Ev
};
//SIG(-1 S2280C44_nt) C1{ m Fp Fi Fp}


void  S2280C44_nt ::mf2280c44(){}

//skip512 S2280C44_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C2  : S2280C3 , S2280C5 {
  char s2280c2f0[2];
  short s2280c2f1[3];
  void *s2280c2f2;
  int s2280c2f3;
  ::S2280C6 s2280c2f4;
  void *s2280c2f5[2];
  ::S2280C9_nt s2280c2f6;
  void *s2280c2f7[2];
  ::S2280C11 s2280c2f8;
  void *s2280c2f9;
  ::S2280C44_nt s2280c2f10;
  ::S2280C6 s2280c2f11;
  ::S2280C28 s2280c2f12;
  ::S2280C16 s2280c2f13;
  virtual  ~S2280C2(); // _ZN7S2280C2D1Ev
  virtual void  v30(); // _ZN7S2280C23v30Ev
  virtual void  v31(); // _ZN7S2280C23v31Ev
  virtual void  v32(); // _ZN7S2280C23v32Ev
  virtual void  v33(); // _ZN7S2280C23v33Ev
  virtual void  v34(); // _ZN7S2280C23v34Ev
  virtual void  v35(); // _ZN7S2280C23v35Ev
  virtual void  v36(); // _ZN7S2280C23v36Ev
  virtual void  v37(); // _ZN7S2280C23v37Ev
  virtual void  v38(); // _ZN7S2280C23v38Ev
  virtual void  v39(); // _ZN7S2280C23v39Ev
  virtual void  v40(); // _ZN7S2280C23v40Ev
  virtual void  v41(); // _ZN7S2280C23v41Ev
  virtual void  v42(); // _ZN7S2280C23v42Ev
  virtual void  v43(); // _ZN7S2280C23v43Ev
  virtual void  v44(); // _ZN7S2280C23v44Ev
  virtual void  v45(); // _ZN7S2280C23v45Ev
  virtual void  v46(); // _ZN7S2280C23v46Ev
  virtual void  v47(); // _ZN7S2280C23v47Ev
  virtual void  v48(); // _ZN7S2280C23v48Ev
  virtual void  v49(); // _ZN7S2280C23v49Ev
  S2280C2(); // tgen
};
//SIG(-1 S2280C2) C1{ BC2{ BC3{ vd v21 v22 v23} vd v24 v25 v26 Fp[4] Fi[3] Fp Fc[128]} BC4{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fc[2] Fs[3] Fp Fi FC5{ FC6{ Fc[2] Fp[4] FC7{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} Fp[2] FC8{ m FC9{ Fl[4]}} Fp[2] FC10{ Fc[4] FC11{ Fp Fs Fp Fs[2]} FU12{ FC13{ FC14{ Fs Fs Fl FC15{ Fs FC16{ Fp FC17{ Fs Fs Fs FC18{ Fp Fp Fp[2] Fl Fl Fl Fl[5] Fl Fs Fc Fc Fc} Fc} FC19{ Fs Fs Fs}}}[2] Fc Fc Fc Fp}[101] Fs Fs Fp Fc FC5 FC5 FC20{ Fs Fs Fs Fs Fs Fs Fs Fs Fs} FC21{ Fp Fc Fc Fc} Fs} FC22{ Fp FC19[41] Fs Fp FC15[301] Fs Fs[301] Fs FC5 FC5 FC5 FC20 FC23{ Fp Fp Fc Fc}}} FC24{ FC25{ Fp FC15[6] Fc Fc}[40] Fs} FC26{ FC27{ Fc Fc Fp FC28{ Fp Fs Fs Fp Fs Fs Fp Fs} Fp Fs Fs Fp Fp Fc Fc} FC29{ Fs FC7 Fs Fs FC18}[12]}[40] FC30{ Fs Fc Fs Fs Fc Fc Fc Fc Fc} Fs[41] Fs[41] FC31{ FC32{ Fs Fs Fc Fc Fc Fs[41] Fs[41] Fs[41] Fl Fs Fc}[5] FC32 Fc Fc} Fl[24] FC15[50] Fl FU33{ FC34{ Fs[12341] Fs} FC35{ Fs[2091] Fs}} FC36{ Fp FC5 Fc FC26 Fp Fs Fs Fs Fs FC37{ Fs Fs Fs Fc Fc} FC38{ FC15[2] Fs FC15[40] Fs} Fs Fs Fs} Fc Fc[12] FC39{ Fs Fs Fp Fp Fp Fp} FC5 FC5 FC40{ Fs[16] Fs[2] Fp} FC41{ Fc Fs Fs Fs} Fs[41]} Fp FC42{ m Fp Fi Fp} FC5 FC26 FC15}


 S2280C2 ::~S2280C2(){ note_dtor("S2280C2", this);}
void  S2280C2 ::v30(){vfunc_called(this, "_ZN7S2280C23v30Ev");}
void  S2280C2 ::v31(){vfunc_called(this, "_ZN7S2280C23v31Ev");}
void  S2280C2 ::v32(){vfunc_called(this, "_ZN7S2280C23v32Ev");}
void  S2280C2 ::v33(){vfunc_called(this, "_ZN7S2280C23v33Ev");}
void  S2280C2 ::v34(){vfunc_called(this, "_ZN7S2280C23v34Ev");}
void  S2280C2 ::v35(){vfunc_called(this, "_ZN7S2280C23v35Ev");}
void  S2280C2 ::v36(){vfunc_called(this, "_ZN7S2280C23v36Ev");}
void  S2280C2 ::v37(){vfunc_called(this, "_ZN7S2280C23v37Ev");}
void  S2280C2 ::v38(){vfunc_called(this, "_ZN7S2280C23v38Ev");}
void  S2280C2 ::v39(){vfunc_called(this, "_ZN7S2280C23v39Ev");}
void  S2280C2 ::v40(){vfunc_called(this, "_ZN7S2280C23v40Ev");}
void  S2280C2 ::v41(){vfunc_called(this, "_ZN7S2280C23v41Ev");}
void  S2280C2 ::v42(){vfunc_called(this, "_ZN7S2280C23v42Ev");}
void  S2280C2 ::v43(){vfunc_called(this, "_ZN7S2280C23v43Ev");}
void  S2280C2 ::v44(){vfunc_called(this, "_ZN7S2280C23v44Ev");}
void  S2280C2 ::v45(){vfunc_called(this, "_ZN7S2280C23v45Ev");}
void  S2280C2 ::v46(){vfunc_called(this, "_ZN7S2280C23v46Ev");}
void  S2280C2 ::v47(){vfunc_called(this, "_ZN7S2280C23v47Ev");}
void  S2280C2 ::v48(){vfunc_called(this, "_ZN7S2280C23v48Ev");}
void  S2280C2 ::v49(){vfunc_called(this, "_ZN7S2280C23v49Ev");}
S2280C2 ::S2280C2(){ note_ctor("S2280C2", this);} // tgen

static void Test_S2280C2()
{
  extern Class_Descriptor cd_S2280C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25151,31684)];
    init_test(&cd_S2280C2, buf);
    S2280C2 *dp, &lv = *(dp=new (buf) S2280C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(201200,126732), "sizeof(S2280C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C2)");
    check_base_class_offset(lv, (S2280C4_nt*)(S2280C3*), 0, "S2280C2");
    check_base_class_offset(lv, (S2280C3*), 0, "S2280C2");
    check_base_class_offset(lv, (S2280C5*), ABISELECT(192,164), "S2280C2");
    check_field_offset(lv, s2280c2f0, ABISELECT(208,176), "S2280C2.s2280c2f0");
    check_field_offset(lv, s2280c2f1, ABISELECT(210,178), "S2280C2.s2280c2f1");
    check_field_offset(lv, s2280c2f2, ABISELECT(216,184), "S2280C2.s2280c2f2");
    check_field_offset(lv, s2280c2f3, ABISELECT(224,188), "S2280C2.s2280c2f3");
    check_field_offset(lv, s2280c2f4, ABISELECT(232,192), "S2280C2.s2280c2f4");
    check_field_offset(lv, s2280c2f5, ABISELECT(1112,720), "S2280C2.s2280c2f5");
    check_field_offset(lv, s2280c2f6, ABISELECT(1128,728), "S2280C2.s2280c2f6");
    check_field_offset(lv, s2280c2f7, ABISELECT(1160,744), "S2280C2.s2280c2f7");
    check_field_offset(lv, s2280c2f8, ABISELECT(1176,752), "S2280C2.s2280c2f8");
    check_field_offset(lv, s2280c2f9, ABISELECT(198496,125184), "S2280C2.s2280c2f9");
    check_field_offset(lv, s2280c2f10, ABISELECT(198504,125188), "S2280C2.s2280c2f10");
    check_field_offset(lv, s2280c2f11, ABISELECT(198528,125200), "S2280C2.s2280c2f11");
    check_field_offset(lv, s2280c2f12, ABISELECT(199408,125728), "S2280C2.s2280c2f12");
    check_field_offset(lv, s2280c2f13, ABISELECT(201048,126644), "S2280C2.s2280c2f13");
    test_class_info(&lv, &cd_S2280C2);
    dp->~S2280C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2280C2(Test_S2280C2, "S2280C2", ABISELECT(201200,126732));

#else // __cplusplus

extern void _ZN7S2280C2C1Ev();
extern void _ZN7S2280C2D1Ev();
Name_Map name_map_S2280C2[] = {
  NSPAIR(_ZN7S2280C2C1Ev),
  NSPAIR(_ZN7S2280C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2280C4_nt;
extern VTBL_ENTRY _ZTI10S2280C4_nt[];
extern  VTBL_ENTRY _ZTV10S2280C4_nt[];
extern Class_Descriptor cd_S2280C3;
extern VTBL_ENTRY _ZTI7S2280C3[];
extern  VTBL_ENTRY _ZTV7S2280C3[];
extern Class_Descriptor cd_S2280C5;
extern VTBL_ENTRY _ZTI7S2280C5[];
extern  VTBL_ENTRY _ZTV7S2280C5[];
static Base_Class bases_S2280C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2280C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2280C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2280C5,    ABISELECT(192,164), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2280C2[];
extern void _ZN7S2280C2D1Ev();
extern void _ZN7S2280C2D0Ev();
extern void _ZN10S2280C4_nt2v4Ev();
extern void _ZN10S2280C4_nt2v5Ev();
extern void _ZN10S2280C4_nt2v6Ev();
extern void _ZN7S2280C32v7Ev();
extern void _ZN7S2280C32v8Ev();
extern void _ZN7S2280C32v9Ev();
extern void _ZN7S2280C23v30Ev();
extern void _ZN7S2280C23v31Ev();
extern void _ZN7S2280C23v32Ev();
extern void _ZN7S2280C23v33Ev();
extern void _ZN7S2280C23v34Ev();
extern void _ZN7S2280C23v35Ev();
extern void _ZN7S2280C23v36Ev();
extern void _ZN7S2280C23v37Ev();
extern void _ZN7S2280C23v38Ev();
extern void _ZN7S2280C23v39Ev();
extern void _ZN7S2280C23v40Ev();
extern void _ZN7S2280C23v41Ev();
extern void _ZN7S2280C23v42Ev();
extern void _ZN7S2280C23v43Ev();
extern void _ZN7S2280C23v44Ev();
extern void _ZN7S2280C23v45Ev();
extern void _ZN7S2280C23v46Ev();
extern void _ZN7S2280C23v47Ev();
extern void _ZN7S2280C23v48Ev();
extern void _ZN7S2280C23v49Ev();
extern void ABISELECT(_ZThn192_N7S2280C2D1Ev,_ZThn164_N7S2280C2D1Ev)();
extern void ABISELECT(_ZThn192_N7S2280C2D0Ev,_ZThn164_N7S2280C2D0Ev)();
extern void _ZN7S2280C53v10Ev();
extern void _ZN7S2280C53v11Ev();
extern void _ZN7S2280C53v12Ev();
extern void _ZN7S2280C53v13Ev();
extern void _ZN7S2280C53v14Ev();
extern void _ZN7S2280C53v15Ev();
extern void _ZN7S2280C53v16Ev();
extern void _ZN7S2280C53v17Ev();
extern void _ZN7S2280C53v18Ev();
extern void _ZN7S2280C53v19Ev();
extern void _ZN7S2280C53v20Ev();
extern void _ZN7S2280C53v21Ev();
extern void _ZN7S2280C53v22Ev();
extern void _ZN7S2280C53v23Ev();
extern void _ZN7S2280C53v24Ev();
extern void _ZN7S2280C53v25Ev();
extern void _ZN7S2280C53v26Ev();
extern void _ZN7S2280C53v27Ev();
extern void _ZN7S2280C53v28Ev();
extern void _ZN7S2280C53v29Ev();
static  VTBL_ENTRY vtc_S2280C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2280C2[0]),
  (VTBL_ENTRY)&_ZN7S2280C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2280C2D0Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN7S2280C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2280C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2280C32v9Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v30Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v37Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v38Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v39Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v40Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v41Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v42Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v43Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v44Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v45Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v46Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v47Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v48Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v49Ev,
  ABISELECT(-192,-164),
  (VTBL_ENTRY)&(_ZTI7S2280C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2280C2D1Ev,_ZThn164_N7S2280C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2280C2D0Ev,_ZThn164_N7S2280C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2280C53v10Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v11Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v12Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v13Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v14Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v15Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v16Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v17Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v18Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v19Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v20Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v21Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v22Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v23Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v24Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v25Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v27Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v28Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v29Ev,
};
extern VTBL_ENTRY _ZTI7S2280C2[];
extern  VTBL_ENTRY _ZTV7S2280C2[];
Class_Descriptor cd_S2280C2 = {  "S2280C2", // class name
  bases_S2280C2, 3,
  &(vtc_S2280C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(201200,126732), // object size
  NSPAIRA(_ZTI7S2280C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2280C2),54, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2280C1  : S2280C2 {
  short s2280c1f0;
  short s2280c1f1[41];
  virtual void  v1(); // _ZN7S2280C12v1Ev
  virtual void  v2(); // _ZN7S2280C12v2Ev
  virtual void  v3(); // _ZN7S2280C12v3Ev
  ~S2280C1(); // tgen
  S2280C1(); // tgen
};
//SIG(1 S2280C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6} vd v7 v8 v9 Fp[4] Fi[3] Fp Fc[128]} BC5{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fi[2]} vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 Fc[2] Fs[3] Fp Fi FC6{ FC7{ Fc[2] Fp[4] FC8{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} Fp[2] FC9{ m FC10{ Fl[4]}} Fp[2] FC11{ Fc[4] FC12{ Fp Fs Fp Fs[2]} FU13{ FC14{ FC15{ Fs Fs Fl FC16{ Fs FC17{ Fp FC18{ Fs Fs Fs FC19{ Fp Fp Fp[2] Fl Fl Fl Fl[5] Fl Fs Fc Fc Fc} Fc} FC20{ Fs Fs Fs}}}[2] Fc Fc Fc Fp}[101] Fs Fs Fp Fc FC6 FC6 FC21{ Fs Fs Fs Fs Fs Fs Fs Fs Fs} FC22{ Fp Fc Fc Fc} Fs} FC23{ Fp FC20[41] Fs Fp FC16[301] Fs Fs[301] Fs FC6 FC6 FC6 FC21 FC24{ Fp Fp Fc Fc}}} FC25{ FC26{ Fp FC16[6] Fc Fc}[40] Fs} FC27{ FC28{ Fc Fc Fp FC29{ Fp Fs Fs Fp Fs Fs Fp Fs} Fp Fs Fs Fp Fp Fc Fc} FC30{ Fs FC8 Fs Fs FC19}[12]}[40] FC31{ Fs Fc Fs Fs Fc Fc Fc Fc Fc} Fs[41] Fs[41] FC32{ FC33{ Fs Fs Fc Fc Fc Fs[41] Fs[41] Fs[41] Fl Fs Fc}[5] FC33 Fc Fc} Fl[24] FC16[50] Fl FU34{ FC35{ Fs[12341] Fs} FC36{ Fs[2091] Fs}} FC37{ Fp FC6 Fc FC27 Fp Fs Fs Fs Fs FC38{ Fs Fs Fs Fc Fc} FC39{ FC16[2] Fs FC16[40] Fs} Fs Fs Fs} Fc Fc[12] FC40{ Fs Fs Fp Fp Fp Fp} FC6 FC6 FC41{ Fs[16] Fs[2] Fp} FC42{ Fc Fs Fs Fs} Fs[41]} Fp FC43{ m Fp Fi Fp} FC6 FC27 FC16} v1 v2 v3 Fs Fs[41]}


void  S2280C1 ::v1(){vfunc_called(this, "_ZN7S2280C12v1Ev");}
void  S2280C1 ::v2(){vfunc_called(this, "_ZN7S2280C12v2Ev");}
void  S2280C1 ::v3(){vfunc_called(this, "_ZN7S2280C12v3Ev");}
S2280C1 ::~S2280C1(){ note_dtor("S2280C1", this);} // tgen
S2280C1 ::S2280C1(){ note_ctor("S2280C1", this);} // tgen

static void Test_S2280C1()
{
  extern Class_Descriptor cd_S2280C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25162,31705)];
    init_test(&cd_S2280C1, buf);
    S2280C1 *dp, &lv = *(dp=new (buf) S2280C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(201288,126816), "sizeof(S2280C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2280C1)");
    check_base_class_offset(lv, (S2280C4_nt*)(S2280C3*)(S2280C2*), 0, "S2280C1");
    check_base_class_offset(lv, (S2280C3*)(S2280C2*), 0, "S2280C1");
    check_base_class_offset(lv, (S2280C5*)(S2280C2*), ABISELECT(192,164), "S2280C1");
    check_base_class_offset(lv, (S2280C2*), 0, "S2280C1");
    check_field_offset(lv, s2280c1f0, ABISELECT(201200,126732), "S2280C1.s2280c1f0");
    check_field_offset(lv, s2280c1f1, ABISELECT(201202,126734), "S2280C1.s2280c1f1");
    test_class_info(&lv, &cd_S2280C1);
    dp->~S2280C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2280C1(Test_S2280C1, "S2280C1", ABISELECT(201288,126816));

#else // __cplusplus

extern void _ZN7S2280C1C1Ev();
extern void _ZN7S2280C1D1Ev();
Name_Map name_map_S2280C1[] = {
  NSPAIR(_ZN7S2280C1C1Ev),
  NSPAIR(_ZN7S2280C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2280C4_nt;
extern VTBL_ENTRY _ZTI10S2280C4_nt[];
extern  VTBL_ENTRY _ZTV10S2280C4_nt[];
extern Class_Descriptor cd_S2280C3;
extern VTBL_ENTRY _ZTI7S2280C3[];
extern  VTBL_ENTRY _ZTV7S2280C3[];
extern Class_Descriptor cd_S2280C5;
extern VTBL_ENTRY _ZTI7S2280C5[];
extern  VTBL_ENTRY _ZTV7S2280C5[];
extern Class_Descriptor cd_S2280C2;
extern VTBL_ENTRY _ZTI7S2280C2[];
extern  VTBL_ENTRY _ZTV7S2280C2[];
static Base_Class bases_S2280C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2280C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2280C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2280C5,    ABISELECT(192,164), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2280C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2280C1[];
extern void _ZN7S2280C1D1Ev();
extern void _ZN7S2280C1D0Ev();
extern void _ZN10S2280C4_nt2v4Ev();
extern void _ZN10S2280C4_nt2v5Ev();
extern void _ZN10S2280C4_nt2v6Ev();
extern void _ZN7S2280C32v7Ev();
extern void _ZN7S2280C32v8Ev();
extern void _ZN7S2280C32v9Ev();
extern void _ZN7S2280C23v30Ev();
extern void _ZN7S2280C23v31Ev();
extern void _ZN7S2280C23v32Ev();
extern void _ZN7S2280C23v33Ev();
extern void _ZN7S2280C23v34Ev();
extern void _ZN7S2280C23v35Ev();
extern void _ZN7S2280C23v36Ev();
extern void _ZN7S2280C23v37Ev();
extern void _ZN7S2280C23v38Ev();
extern void _ZN7S2280C23v39Ev();
extern void _ZN7S2280C23v40Ev();
extern void _ZN7S2280C23v41Ev();
extern void _ZN7S2280C23v42Ev();
extern void _ZN7S2280C23v43Ev();
extern void _ZN7S2280C23v44Ev();
extern void _ZN7S2280C23v45Ev();
extern void _ZN7S2280C23v46Ev();
extern void _ZN7S2280C23v47Ev();
extern void _ZN7S2280C23v48Ev();
extern void _ZN7S2280C23v49Ev();
extern void _ZN7S2280C12v1Ev();
extern void _ZN7S2280C12v2Ev();
extern void _ZN7S2280C12v3Ev();
extern void ABISELECT(_ZThn192_N7S2280C1D1Ev,_ZThn164_N7S2280C1D1Ev)();
extern void ABISELECT(_ZThn192_N7S2280C1D0Ev,_ZThn164_N7S2280C1D0Ev)();
extern void _ZN7S2280C53v10Ev();
extern void _ZN7S2280C53v11Ev();
extern void _ZN7S2280C53v12Ev();
extern void _ZN7S2280C53v13Ev();
extern void _ZN7S2280C53v14Ev();
extern void _ZN7S2280C53v15Ev();
extern void _ZN7S2280C53v16Ev();
extern void _ZN7S2280C53v17Ev();
extern void _ZN7S2280C53v18Ev();
extern void _ZN7S2280C53v19Ev();
extern void _ZN7S2280C53v20Ev();
extern void _ZN7S2280C53v21Ev();
extern void _ZN7S2280C53v22Ev();
extern void _ZN7S2280C53v23Ev();
extern void _ZN7S2280C53v24Ev();
extern void _ZN7S2280C53v25Ev();
extern void _ZN7S2280C53v26Ev();
extern void _ZN7S2280C53v27Ev();
extern void _ZN7S2280C53v28Ev();
extern void _ZN7S2280C53v29Ev();
static  VTBL_ENTRY vtc_S2280C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2280C1[0]),
  (VTBL_ENTRY)&_ZN7S2280C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2280C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S2280C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN7S2280C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2280C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2280C32v9Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v30Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v37Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v38Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v39Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v40Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v41Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v42Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v43Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v44Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v45Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v46Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v47Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v48Ev,
  (VTBL_ENTRY)&_ZN7S2280C23v49Ev,
  (VTBL_ENTRY)&_ZN7S2280C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2280C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2280C12v3Ev,
  ABISELECT(-192,-164),
  (VTBL_ENTRY)&(_ZTI7S2280C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2280C1D1Ev,_ZThn164_N7S2280C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2280C1D0Ev,_ZThn164_N7S2280C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2280C53v10Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v11Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v12Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v13Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v14Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v15Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v16Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v17Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v18Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v19Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v20Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v21Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v22Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v23Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v24Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v25Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v27Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v28Ev,
  (VTBL_ENTRY)&_ZN7S2280C53v29Ev,
};
extern VTBL_ENTRY _ZTI7S2280C1[];
extern  VTBL_ENTRY _ZTV7S2280C1[];
Class_Descriptor cd_S2280C1 = {  "S2280C1", // class name
  bases_S2280C1, 4,
  &(vtc_S2280C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(201288,126816), // object size
  NSPAIRA(_ZTI7S2280C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2280C1),57, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2281C4  {
  virtual  ~S2281C4(); // _ZN7S2281C4D1Ev
  virtual void  v4(); // _ZN7S2281C42v4Ev
  virtual void  v5(); // _ZN7S2281C42v5Ev
  virtual void  v6(); // _ZN7S2281C42v6Ev
  S2281C4(); // tgen
};
//SIG(-1 S2281C4) C1{ vd v1 v2 v3}


 S2281C4 ::~S2281C4(){ note_dtor("S2281C4", this);}
void  S2281C4 ::v4(){vfunc_called(this, "_ZN7S2281C42v4Ev");}
void  S2281C4 ::v5(){vfunc_called(this, "_ZN7S2281C42v5Ev");}
void  S2281C4 ::v6(){vfunc_called(this, "_ZN7S2281C42v6Ev");}
S2281C4 ::S2281C4(){ note_ctor("S2281C4", this);} // tgen

static void Test_S2281C4()
{
  extern Class_Descriptor cd_S2281C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2281C4, buf);
    S2281C4 *dp, &lv = *(dp=new (buf) S2281C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2281C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2281C4)");
    test_class_info(&lv, &cd_S2281C4);
    dp->~S2281C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2281C4(Test_S2281C4, "S2281C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2281C4C1Ev();
extern void _ZN7S2281C4D1Ev();
Name_Map name_map_S2281C4[] = {
  NSPAIR(_ZN7S2281C4C1Ev),
  NSPAIR(_ZN7S2281C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2281C4[];
extern void _ZN7S2281C4D1Ev();
extern void _ZN7S2281C4D0Ev();
extern void _ZN7S2281C42v4Ev();
extern void _ZN7S2281C42v5Ev();
extern void _ZN7S2281C42v6Ev();
static  VTBL_ENTRY vtc_S2281C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2281C4[0]),
  (VTBL_ENTRY)&_ZN7S2281C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2281C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v6Ev,
};
extern VTBL_ENTRY _ZTI7S2281C4[];
extern  VTBL_ENTRY _ZTV7S2281C4[];
Class_Descriptor cd_S2281C4 = {  "S2281C4", // class name
  0,0,//no base classes
  &(vtc_S2281C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2281C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2281C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2281C3  : S2281C4 {
  void *s2281c3f0[4];
  int s2281c3f1[3];
  void *s2281c3f2;
  char s2281c3f3[128];
  virtual  ~S2281C3(); // _ZN7S2281C3D1Ev
  virtual void  v7(); // _ZN7S2281C32v7Ev
  virtual void  v8(); // _ZN7S2281C32v8Ev
  virtual void  v9(); // _ZN7S2281C32v9Ev
  S2281C3(); // tgen
};
//SIG(-1 S2281C3) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 Fp[4] Fi[3] Fp Fc[128]}


 S2281C3 ::~S2281C3(){ note_dtor("S2281C3", this);}
void  S2281C3 ::v7(){vfunc_called(this, "_ZN7S2281C32v7Ev");}
void  S2281C3 ::v8(){vfunc_called(this, "_ZN7S2281C32v8Ev");}
void  S2281C3 ::v9(){vfunc_called(this, "_ZN7S2281C32v9Ev");}
S2281C3 ::S2281C3(){ note_ctor("S2281C3", this);} // tgen

static void Test_S2281C3()
{
  extern Class_Descriptor cd_S2281C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,42)];
    init_test(&cd_S2281C3, buf);
    S2281C3 *dp, &lv = *(dp=new (buf) S2281C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,164), "sizeof(S2281C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2281C3)");
    check_base_class_offset(lv, (S2281C4*), 0, "S2281C3");
    check_field_offset(lv, s2281c3f0, ABISELECT(8,4), "S2281C3.s2281c3f0");
    check_field_offset(lv, s2281c3f1, ABISELECT(40,20), "S2281C3.s2281c3f1");
    check_field_offset(lv, s2281c3f2, ABISELECT(56,32), "S2281C3.s2281c3f2");
    check_field_offset(lv, s2281c3f3, ABISELECT(64,36), "S2281C3.s2281c3f3");
    test_class_info(&lv, &cd_S2281C3);
    dp->~S2281C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2281C3(Test_S2281C3, "S2281C3", ABISELECT(192,164));

#else // __cplusplus

extern void _ZN7S2281C3C1Ev();
extern void _ZN7S2281C3D1Ev();
Name_Map name_map_S2281C3[] = {
  NSPAIR(_ZN7S2281C3C1Ev),
  NSPAIR(_ZN7S2281C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2281C4;
extern VTBL_ENTRY _ZTI7S2281C4[];
extern  VTBL_ENTRY _ZTV7S2281C4[];
static Base_Class bases_S2281C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2281C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2281C3[];
extern void _ZN7S2281C3D1Ev();
extern void _ZN7S2281C3D0Ev();
extern void _ZN7S2281C42v4Ev();
extern void _ZN7S2281C42v5Ev();
extern void _ZN7S2281C42v6Ev();
extern void _ZN7S2281C32v7Ev();
extern void _ZN7S2281C32v8Ev();
extern void _ZN7S2281C32v9Ev();
static  VTBL_ENTRY vtc_S2281C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2281C3[0]),
  (VTBL_ENTRY)&_ZN7S2281C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2281C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2281C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2281C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2281C32v9Ev,
};
extern VTBL_ENTRY _ZTI7S2281C3[];
extern  VTBL_ENTRY _ZTV7S2281C3[];
Class_Descriptor cd_S2281C3 = {  "S2281C3", // class name
  bases_S2281C3, 1,
  &(vtc_S2281C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,164), // object size
  NSPAIRA(_ZTI7S2281C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2281C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2281C5  {
  int s2281c5f0[2];
  virtual  ~S2281C5(); // _ZN7S2281C5D1Ev
  virtual void  v10(); // _ZN7S2281C53v10Ev
  virtual void  v11(); // _ZN7S2281C53v11Ev
  virtual void  v12(); // _ZN7S2281C53v12Ev
  virtual void  v13(); // _ZN7S2281C53v13Ev
  virtual void  v14(); // _ZN7S2281C53v14Ev
  virtual void  v15(); // _ZN7S2281C53v15Ev
  virtual void  v16(); // _ZN7S2281C53v16Ev
  virtual void  v17(); // _ZN7S2281C53v17Ev
  virtual void  v18(); // _ZN7S2281C53v18Ev
  virtual void  v19(); // _ZN7S2281C53v19Ev
  virtual void  v20(); // _ZN7S2281C53v20Ev
  virtual void  v21(); // _ZN7S2281C53v21Ev
  virtual void  v22(); // _ZN7S2281C53v22Ev
  virtual void  v23(); // _ZN7S2281C53v23Ev
  virtual void  v24(); // _ZN7S2281C53v24Ev
  virtual void  v25(); // _ZN7S2281C53v25Ev
  virtual void  v26(); // _ZN7S2281C53v26Ev
  virtual void  v27(); // _ZN7S2281C53v27Ev
  virtual void  v28(); // _ZN7S2281C53v28Ev
  virtual void  v29(); // _ZN7S2281C53v29Ev
  S2281C5(); // tgen
};
//SIG(-1 S2281C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi[2]}


 S2281C5 ::~S2281C5(){ note_dtor("S2281C5", this);}
void  S2281C5 ::v10(){vfunc_called(this, "_ZN7S2281C53v10Ev");}
void  S2281C5 ::v11(){vfunc_called(this, "_ZN7S2281C53v11Ev");}
void  S2281C5 ::v12(){vfunc_called(this, "_ZN7S2281C53v12Ev");}
void  S2281C5 ::v13(){vfunc_called(this, "_ZN7S2281C53v13Ev");}
void  S2281C5 ::v14(){vfunc_called(this, "_ZN7S2281C53v14Ev");}
void  S2281C5 ::v15(){vfunc_called(this, "_ZN7S2281C53v15Ev");}
void  S2281C5 ::v16(){vfunc_called(this, "_ZN7S2281C53v16Ev");}
void  S2281C5 ::v17(){vfunc_called(this, "_ZN7S2281C53v17Ev");}
void  S2281C5 ::v18(){vfunc_called(this, "_ZN7S2281C53v18Ev");}
void  S2281C5 ::v19(){vfunc_called(this, "_ZN7S2281C53v19Ev");}
void  S2281C5 ::v20(){vfunc_called(this, "_ZN7S2281C53v20Ev");}
void  S2281C5 ::v21(){vfunc_called(this, "_ZN7S2281C53v21Ev");}
void  S2281C5 ::v22(){vfunc_called(this, "_ZN7S2281C53v22Ev");}
void  S2281C5 ::v23(){vfunc_called(this, "_ZN7S2281C53v23Ev");}
void  S2281C5 ::v24(){vfunc_called(this, "_ZN7S2281C53v24Ev");}
void  S2281C5 ::v25(){vfunc_called(this, "_ZN7S2281C53v25Ev");}
void  S2281C5 ::v26(){vfunc_called(this, "_ZN7S2281C53v26Ev");}
void  S2281C5 ::v27(){vfunc_called(this, "_ZN7S2281C53v27Ev");}
void  S2281C5 ::v28(){vfunc_called(this, "_ZN7S2281C53v28Ev");}
void  S2281C5 ::v29(){vfunc_called(this, "_ZN7S2281C53v29Ev");}
S2281C5 ::S2281C5(){ note_ctor("S2281C5", this);} // tgen

static void Test_S2281C5()
{
  extern Class_Descriptor cd_S2281C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2281C5, buf);
    S2281C5 *dp, &lv = *(dp=new (buf) S2281C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2281C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2281C5)");
    check_field_offset(lv, s2281c5f0, ABISELECT(8,4), "S2281C5.s2281c5f0");
    test_class_info(&lv, &cd_S2281C5);
    dp->~S2281C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2281C5(Test_S2281C5, "S2281C5", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN7S2281C5C1Ev();
extern void _ZN7S2281C5D1Ev();
Name_Map name_map_S2281C5[] = {
  NSPAIR(_ZN7S2281C5C1Ev),
  NSPAIR(_ZN7S2281C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2281C5[];
extern void _ZN7S2281C5D1Ev();
extern void _ZN7S2281C5D0Ev();
extern void _ZN7S2281C53v10Ev();
extern void _ZN7S2281C53v11Ev();
extern void _ZN7S2281C53v12Ev();
extern void _ZN7S2281C53v13Ev();
extern void _ZN7S2281C53v14Ev();
extern void _ZN7S2281C53v15Ev();
extern void _ZN7S2281C53v16Ev();
extern void _ZN7S2281C53v17Ev();
extern void _ZN7S2281C53v18Ev();
extern void _ZN7S2281C53v19Ev();
extern void _ZN7S2281C53v20Ev();
extern void _ZN7S2281C53v21Ev();
extern void _ZN7S2281C53v22Ev();
extern void _ZN7S2281C53v23Ev();
extern void _ZN7S2281C53v24Ev();
extern void _ZN7S2281C53v25Ev();
extern void _ZN7S2281C53v26Ev();
extern void _ZN7S2281C53v27Ev();
extern void _ZN7S2281C53v28Ev();
extern void _ZN7S2281C53v29Ev();
static  VTBL_ENTRY vtc_S2281C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2281C5[0]),
  (VTBL_ENTRY)&_ZN7S2281C5D1Ev,
  (VTBL_ENTRY)&_ZN7S2281C5D0Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v10Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v11Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v12Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v13Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v14Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v15Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v16Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v17Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v18Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v19Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v20Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v21Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v22Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v23Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v24Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v25Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v27Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v28Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v29Ev,
};
extern VTBL_ENTRY _ZTI7S2281C5[];
extern  VTBL_ENTRY _ZTV7S2281C5[];
Class_Descriptor cd_S2281C5 = {  "S2281C5", // class name
  0,0,//no base classes
  &(vtc_S2281C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI7S2281C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2281C5),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2281C10_nt  {
  __tsi64 s2281c10f0[4];
};
//SIG(-1 S2281C10_nt) C1{ FL[4]}



//skip512 S2281C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2281C9_nt  {
  ::S2281C10_nt s2281c9f0;
  void  mf2281c9(); // _ZN10S2281C9_nt8mf2281c9Ev
};
//SIG(-1 S2281C9_nt) C1{ m FC2{ FL[4]}}


void  S2281C9_nt ::mf2281c9(){}

//skip512 S2281C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2281C2  : S2281C3 , S2281C5 {
  char s2281c2f0[2];
  short s2281c2f1[3];
  void *s2281c2f2;
  int s2281c2f3;
  ::S2280C6 s2281c2f4;
  void *s2281c2f5[2];
  ::S2281C9_nt s2281c2f6;
  void *s2281c2f7[2];
  ::S2280C11 s2281c2f8;
  void *s2281c2f9;
  ::S2280C44_nt s2281c2f10;
  ::S2280C6 s2281c2f11;
  ::S2280C28 s2281c2f12;
  ::S2280C16 s2281c2f13;
  virtual  ~S2281C2(); // _ZN7S2281C2D1Ev
  virtual void  v30(); // _ZN7S2281C23v30Ev
  virtual void  v31(); // _ZN7S2281C23v31Ev
  virtual void  v32(); // _ZN7S2281C23v32Ev
  virtual void  v33(); // _ZN7S2281C23v33Ev
  virtual void  v34(); // _ZN7S2281C23v34Ev
  virtual void  v35(); // _ZN7S2281C23v35Ev
  virtual void  v36(); // _ZN7S2281C23v36Ev
  virtual void  v37(); // _ZN7S2281C23v37Ev
  virtual void  v38(); // _ZN7S2281C23v38Ev
  virtual void  v39(); // _ZN7S2281C23v39Ev
  virtual void  v40(); // _ZN7S2281C23v40Ev
  virtual void  v41(); // _ZN7S2281C23v41Ev
  virtual void  v42(); // _ZN7S2281C23v42Ev
  virtual void  v43(); // _ZN7S2281C23v43Ev
  virtual void  v44(); // _ZN7S2281C23v44Ev
  virtual void  v45(); // _ZN7S2281C23v45Ev
  virtual void  v46(); // _ZN7S2281C23v46Ev
  virtual void  v47(); // _ZN7S2281C23v47Ev
  virtual void  v48(); // _ZN7S2281C23v48Ev
  virtual void  v49(); // _ZN7S2281C23v49Ev
  S2281C2(); // tgen
};
//SIG(-1 S2281C2) C1{ BC2{ BC3{ vd v21 v22 v23} vd v24 v25 v26 Fp[4] Fi[3] Fp Fc[128]} BC4{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fc[2] Fs[3] Fp Fi FC5{ FC6{ Fc[2] Fp[4] FC7{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} Fp[2] FC8{ m FC9{ FL[4]}} Fp[2] FC10{ Fc[4] FC11{ Fp Fs Fp Fs[2]} FU12{ FC13{ FC14{ Fs Fs Fl FC15{ Fs FC16{ Fp FC17{ Fs Fs Fs FC18{ Fp Fp Fp[2] Fl Fl Fl Fl[5] Fl Fs Fc Fc Fc} Fc} FC19{ Fs Fs Fs}}}[2] Fc Fc Fc Fp}[101] Fs Fs Fp Fc FC5 FC5 FC20{ Fs Fs Fs Fs Fs Fs Fs Fs Fs} FC21{ Fp Fc Fc Fc} Fs} FC22{ Fp FC19[41] Fs Fp FC15[301] Fs Fs[301] Fs FC5 FC5 FC5 FC20 FC23{ Fp Fp Fc Fc}}} FC24{ FC25{ Fp FC15[6] Fc Fc}[40] Fs} FC26{ FC27{ Fc Fc Fp FC28{ Fp Fs Fs Fp Fs Fs Fp Fs} Fp Fs Fs Fp Fp Fc Fc} FC29{ Fs FC7 Fs Fs FC18}[12]}[40] FC30{ Fs Fc Fs Fs Fc Fc Fc Fc Fc} Fs[41] Fs[41] FC31{ FC32{ Fs Fs Fc Fc Fc Fs[41] Fs[41] Fs[41] Fl Fs Fc}[5] FC32 Fc Fc} Fl[24] FC15[50] Fl FU33{ FC34{ Fs[12341] Fs} FC35{ Fs[2091] Fs}} FC36{ Fp FC5 Fc FC26 Fp Fs Fs Fs Fs FC37{ Fs Fs Fs Fc Fc} FC38{ FC15[2] Fs FC15[40] Fs} Fs Fs Fs} Fc Fc[12] FC39{ Fs Fs Fp Fp Fp Fp} FC5 FC5 FC40{ Fs[16] Fs[2] Fp} FC41{ Fc Fs Fs Fs} Fs[41]} Fp FC42{ m Fp Fi Fp} FC5 FC26 FC15}


 S2281C2 ::~S2281C2(){ note_dtor("S2281C2", this);}
void  S2281C2 ::v30(){vfunc_called(this, "_ZN7S2281C23v30Ev");}
void  S2281C2 ::v31(){vfunc_called(this, "_ZN7S2281C23v31Ev");}
void  S2281C2 ::v32(){vfunc_called(this, "_ZN7S2281C23v32Ev");}
void  S2281C2 ::v33(){vfunc_called(this, "_ZN7S2281C23v33Ev");}
void  S2281C2 ::v34(){vfunc_called(this, "_ZN7S2281C23v34Ev");}
void  S2281C2 ::v35(){vfunc_called(this, "_ZN7S2281C23v35Ev");}
void  S2281C2 ::v36(){vfunc_called(this, "_ZN7S2281C23v36Ev");}
void  S2281C2 ::v37(){vfunc_called(this, "_ZN7S2281C23v37Ev");}
void  S2281C2 ::v38(){vfunc_called(this, "_ZN7S2281C23v38Ev");}
void  S2281C2 ::v39(){vfunc_called(this, "_ZN7S2281C23v39Ev");}
void  S2281C2 ::v40(){vfunc_called(this, "_ZN7S2281C23v40Ev");}
void  S2281C2 ::v41(){vfunc_called(this, "_ZN7S2281C23v41Ev");}
void  S2281C2 ::v42(){vfunc_called(this, "_ZN7S2281C23v42Ev");}
void  S2281C2 ::v43(){vfunc_called(this, "_ZN7S2281C23v43Ev");}
void  S2281C2 ::v44(){vfunc_called(this, "_ZN7S2281C23v44Ev");}
void  S2281C2 ::v45(){vfunc_called(this, "_ZN7S2281C23v45Ev");}
void  S2281C2 ::v46(){vfunc_called(this, "_ZN7S2281C23v46Ev");}
void  S2281C2 ::v47(){vfunc_called(this, "_ZN7S2281C23v47Ev");}
void  S2281C2 ::v48(){vfunc_called(this, "_ZN7S2281C23v48Ev");}
void  S2281C2 ::v49(){vfunc_called(this, "_ZN7S2281C23v49Ev");}
S2281C2 ::S2281C2(){ note_ctor("S2281C2", this);} // tgen

static void Test_S2281C2()
{
  extern Class_Descriptor cd_S2281C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25151,31688)];
    init_test(&cd_S2281C2, buf);
    S2281C2 *dp, &lv = *(dp=new (buf) S2281C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(201200,126748), "sizeof(S2281C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2281C2)");
    check_base_class_offset(lv, (S2281C4*)(S2281C3*), 0, "S2281C2");
    check_base_class_offset(lv, (S2281C3*), 0, "S2281C2");
    check_base_class_offset(lv, (S2281C5*), ABISELECT(192,164), "S2281C2");
    check_field_offset(lv, s2281c2f0, ABISELECT(208,176), "S2281C2.s2281c2f0");
    check_field_offset(lv, s2281c2f1, ABISELECT(210,178), "S2281C2.s2281c2f1");
    check_field_offset(lv, s2281c2f2, ABISELECT(216,184), "S2281C2.s2281c2f2");
    check_field_offset(lv, s2281c2f3, ABISELECT(224,188), "S2281C2.s2281c2f3");
    check_field_offset(lv, s2281c2f4, ABISELECT(232,192), "S2281C2.s2281c2f4");
    check_field_offset(lv, s2281c2f5, ABISELECT(1112,720), "S2281C2.s2281c2f5");
    check_field_offset(lv, s2281c2f6, ABISELECT(1128,728), "S2281C2.s2281c2f6");
    check_field_offset(lv, s2281c2f7, ABISELECT(1160,760), "S2281C2.s2281c2f7");
    check_field_offset(lv, s2281c2f8, ABISELECT(1176,768), "S2281C2.s2281c2f8");
    check_field_offset(lv, s2281c2f9, ABISELECT(198496,125200), "S2281C2.s2281c2f9");
    check_field_offset(lv, s2281c2f10, ABISELECT(198504,125204), "S2281C2.s2281c2f10");
    check_field_offset(lv, s2281c2f11, ABISELECT(198528,125216), "S2281C2.s2281c2f11");
    check_field_offset(lv, s2281c2f12, ABISELECT(199408,125744), "S2281C2.s2281c2f12");
    check_field_offset(lv, s2281c2f13, ABISELECT(201048,126660), "S2281C2.s2281c2f13");
    test_class_info(&lv, &cd_S2281C2);
    dp->~S2281C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2281C2(Test_S2281C2, "S2281C2", ABISELECT(201200,126748));

#else // __cplusplus

extern void _ZN7S2281C2C1Ev();
extern void _ZN7S2281C2D1Ev();
Name_Map name_map_S2281C2[] = {
  NSPAIR(_ZN7S2281C2C1Ev),
  NSPAIR(_ZN7S2281C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2281C4;
extern VTBL_ENTRY _ZTI7S2281C4[];
extern  VTBL_ENTRY _ZTV7S2281C4[];
extern Class_Descriptor cd_S2281C3;
extern VTBL_ENTRY _ZTI7S2281C3[];
extern  VTBL_ENTRY _ZTV7S2281C3[];
extern Class_Descriptor cd_S2281C5;
extern VTBL_ENTRY _ZTI7S2281C5[];
extern  VTBL_ENTRY _ZTV7S2281C5[];
static Base_Class bases_S2281C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2281C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2281C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2281C5,    ABISELECT(192,164), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2281C2[];
extern void _ZN7S2281C2D1Ev();
extern void _ZN7S2281C2D0Ev();
extern void _ZN7S2281C42v4Ev();
extern void _ZN7S2281C42v5Ev();
extern void _ZN7S2281C42v6Ev();
extern void _ZN7S2281C32v7Ev();
extern void _ZN7S2281C32v8Ev();
extern void _ZN7S2281C32v9Ev();
extern void _ZN7S2281C23v30Ev();
extern void _ZN7S2281C23v31Ev();
extern void _ZN7S2281C23v32Ev();
extern void _ZN7S2281C23v33Ev();
extern void _ZN7S2281C23v34Ev();
extern void _ZN7S2281C23v35Ev();
extern void _ZN7S2281C23v36Ev();
extern void _ZN7S2281C23v37Ev();
extern void _ZN7S2281C23v38Ev();
extern void _ZN7S2281C23v39Ev();
extern void _ZN7S2281C23v40Ev();
extern void _ZN7S2281C23v41Ev();
extern void _ZN7S2281C23v42Ev();
extern void _ZN7S2281C23v43Ev();
extern void _ZN7S2281C23v44Ev();
extern void _ZN7S2281C23v45Ev();
extern void _ZN7S2281C23v46Ev();
extern void _ZN7S2281C23v47Ev();
extern void _ZN7S2281C23v48Ev();
extern void _ZN7S2281C23v49Ev();
extern void ABISELECT(_ZThn192_N7S2281C2D1Ev,_ZThn164_N7S2281C2D1Ev)();
extern void ABISELECT(_ZThn192_N7S2281C2D0Ev,_ZThn164_N7S2281C2D0Ev)();
extern void _ZN7S2281C53v10Ev();
extern void _ZN7S2281C53v11Ev();
extern void _ZN7S2281C53v12Ev();
extern void _ZN7S2281C53v13Ev();
extern void _ZN7S2281C53v14Ev();
extern void _ZN7S2281C53v15Ev();
extern void _ZN7S2281C53v16Ev();
extern void _ZN7S2281C53v17Ev();
extern void _ZN7S2281C53v18Ev();
extern void _ZN7S2281C53v19Ev();
extern void _ZN7S2281C53v20Ev();
extern void _ZN7S2281C53v21Ev();
extern void _ZN7S2281C53v22Ev();
extern void _ZN7S2281C53v23Ev();
extern void _ZN7S2281C53v24Ev();
extern void _ZN7S2281C53v25Ev();
extern void _ZN7S2281C53v26Ev();
extern void _ZN7S2281C53v27Ev();
extern void _ZN7S2281C53v28Ev();
extern void _ZN7S2281C53v29Ev();
static  VTBL_ENTRY vtc_S2281C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2281C2[0]),
  (VTBL_ENTRY)&_ZN7S2281C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2281C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2281C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2281C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2281C32v9Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v30Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v37Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v38Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v39Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v40Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v41Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v42Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v43Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v44Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v45Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v46Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v47Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v48Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v49Ev,
  ABISELECT(-192,-164),
  (VTBL_ENTRY)&(_ZTI7S2281C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2281C2D1Ev,_ZThn164_N7S2281C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2281C2D0Ev,_ZThn164_N7S2281C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2281C53v10Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v11Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v12Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v13Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v14Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v15Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v16Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v17Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v18Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v19Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v20Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v21Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v22Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v23Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v24Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v25Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v27Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v28Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v29Ev,
};
extern VTBL_ENTRY _ZTI7S2281C2[];
extern  VTBL_ENTRY _ZTV7S2281C2[];
Class_Descriptor cd_S2281C2 = {  "S2281C2", // class name
  bases_S2281C2, 3,
  &(vtc_S2281C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(201200,126748), // object size
  NSPAIRA(_ZTI7S2281C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2281C2),54, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2281C1  : S2281C2 {
  short s2281c1f0;
  short s2281c1f1[41];
  virtual void  v1(); // _ZN7S2281C12v1Ev
  virtual void  v2(); // _ZN7S2281C12v2Ev
  virtual void  v3(); // _ZN7S2281C12v3Ev
  ~S2281C1(); // tgen
  S2281C1(); // tgen
};
//SIG(1 S2281C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6} vd v7 v8 v9 Fp[4] Fi[3] Fp Fc[128]} BC5{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fi[2]} vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 Fc[2] Fs[3] Fp Fi FC6{ FC7{ Fc[2] Fp[4] FC8{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} Fp[2] FC9{ m FC10{ FL[4]}} Fp[2] FC11{ Fc[4] FC12{ Fp Fs Fp Fs[2]} FU13{ FC14{ FC15{ Fs Fs Fl FC16{ Fs FC17{ Fp FC18{ Fs Fs Fs FC19{ Fp Fp Fp[2] Fl Fl Fl Fl[5] Fl Fs Fc Fc Fc} Fc} FC20{ Fs Fs Fs}}}[2] Fc Fc Fc Fp}[101] Fs Fs Fp Fc FC6 FC6 FC21{ Fs Fs Fs Fs Fs Fs Fs Fs Fs} FC22{ Fp Fc Fc Fc} Fs} FC23{ Fp FC20[41] Fs Fp FC16[301] Fs Fs[301] Fs FC6 FC6 FC6 FC21 FC24{ Fp Fp Fc Fc}}} FC25{ FC26{ Fp FC16[6] Fc Fc}[40] Fs} FC27{ FC28{ Fc Fc Fp FC29{ Fp Fs Fs Fp Fs Fs Fp Fs} Fp Fs Fs Fp Fp Fc Fc} FC30{ Fs FC8 Fs Fs FC19}[12]}[40] FC31{ Fs Fc Fs Fs Fc Fc Fc Fc Fc} Fs[41] Fs[41] FC32{ FC33{ Fs Fs Fc Fc Fc Fs[41] Fs[41] Fs[41] Fl Fs Fc}[5] FC33 Fc Fc} Fl[24] FC16[50] Fl FU34{ FC35{ Fs[12341] Fs} FC36{ Fs[2091] Fs}} FC37{ Fp FC6 Fc FC27 Fp Fs Fs Fs Fs FC38{ Fs Fs Fs Fc Fc} FC39{ FC16[2] Fs FC16[40] Fs} Fs Fs Fs} Fc Fc[12] FC40{ Fs Fs Fp Fp Fp Fp} FC6 FC6 FC41{ Fs[16] Fs[2] Fp} FC42{ Fc Fs Fs Fs} Fs[41]} Fp FC43{ m Fp Fi Fp} FC6 FC27 FC16} v1 v2 v3 Fs Fs[41]}


void  S2281C1 ::v1(){vfunc_called(this, "_ZN7S2281C12v1Ev");}
void  S2281C1 ::v2(){vfunc_called(this, "_ZN7S2281C12v2Ev");}
void  S2281C1 ::v3(){vfunc_called(this, "_ZN7S2281C12v3Ev");}
S2281C1 ::~S2281C1(){ note_dtor("S2281C1", this);} // tgen
S2281C1 ::S2281C1(){ note_ctor("S2281C1", this);} // tgen

static void Test_S2281C1()
{
  extern Class_Descriptor cd_S2281C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25162,31709)];
    init_test(&cd_S2281C1, buf);
    S2281C1 *dp, &lv = *(dp=new (buf) S2281C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(201288,126832), "sizeof(S2281C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2281C1)");
    check_base_class_offset(lv, (S2281C4*)(S2281C3*)(S2281C2*), 0, "S2281C1");
    check_base_class_offset(lv, (S2281C3*)(S2281C2*), 0, "S2281C1");
    check_base_class_offset(lv, (S2281C5*)(S2281C2*), ABISELECT(192,164), "S2281C1");
    check_base_class_offset(lv, (S2281C2*), 0, "S2281C1");
    check_field_offset(lv, s2281c1f0, ABISELECT(201200,126748), "S2281C1.s2281c1f0");
    check_field_offset(lv, s2281c1f1, ABISELECT(201202,126750), "S2281C1.s2281c1f1");
    test_class_info(&lv, &cd_S2281C1);
    dp->~S2281C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2281C1(Test_S2281C1, "S2281C1", ABISELECT(201288,126832));

#else // __cplusplus

extern void _ZN7S2281C1C1Ev();
extern void _ZN7S2281C1D1Ev();
Name_Map name_map_S2281C1[] = {
  NSPAIR(_ZN7S2281C1C1Ev),
  NSPAIR(_ZN7S2281C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2281C4;
extern VTBL_ENTRY _ZTI7S2281C4[];
extern  VTBL_ENTRY _ZTV7S2281C4[];
extern Class_Descriptor cd_S2281C3;
extern VTBL_ENTRY _ZTI7S2281C3[];
extern  VTBL_ENTRY _ZTV7S2281C3[];
extern Class_Descriptor cd_S2281C5;
extern VTBL_ENTRY _ZTI7S2281C5[];
extern  VTBL_ENTRY _ZTV7S2281C5[];
extern Class_Descriptor cd_S2281C2;
extern VTBL_ENTRY _ZTI7S2281C2[];
extern  VTBL_ENTRY _ZTV7S2281C2[];
static Base_Class bases_S2281C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2281C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2281C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2281C5,    ABISELECT(192,164), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2281C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2281C1[];
extern void _ZN7S2281C1D1Ev();
extern void _ZN7S2281C1D0Ev();
extern void _ZN7S2281C42v4Ev();
extern void _ZN7S2281C42v5Ev();
extern void _ZN7S2281C42v6Ev();
extern void _ZN7S2281C32v7Ev();
extern void _ZN7S2281C32v8Ev();
extern void _ZN7S2281C32v9Ev();
extern void _ZN7S2281C23v30Ev();
extern void _ZN7S2281C23v31Ev();
extern void _ZN7S2281C23v32Ev();
extern void _ZN7S2281C23v33Ev();
extern void _ZN7S2281C23v34Ev();
extern void _ZN7S2281C23v35Ev();
extern void _ZN7S2281C23v36Ev();
extern void _ZN7S2281C23v37Ev();
extern void _ZN7S2281C23v38Ev();
extern void _ZN7S2281C23v39Ev();
extern void _ZN7S2281C23v40Ev();
extern void _ZN7S2281C23v41Ev();
extern void _ZN7S2281C23v42Ev();
extern void _ZN7S2281C23v43Ev();
extern void _ZN7S2281C23v44Ev();
extern void _ZN7S2281C23v45Ev();
extern void _ZN7S2281C23v46Ev();
extern void _ZN7S2281C23v47Ev();
extern void _ZN7S2281C23v48Ev();
extern void _ZN7S2281C23v49Ev();
extern void _ZN7S2281C12v1Ev();
extern void _ZN7S2281C12v2Ev();
extern void _ZN7S2281C12v3Ev();
extern void ABISELECT(_ZThn192_N7S2281C1D1Ev,_ZThn164_N7S2281C1D1Ev)();
extern void ABISELECT(_ZThn192_N7S2281C1D0Ev,_ZThn164_N7S2281C1D0Ev)();
extern void _ZN7S2281C53v10Ev();
extern void _ZN7S2281C53v11Ev();
extern void _ZN7S2281C53v12Ev();
extern void _ZN7S2281C53v13Ev();
extern void _ZN7S2281C53v14Ev();
extern void _ZN7S2281C53v15Ev();
extern void _ZN7S2281C53v16Ev();
extern void _ZN7S2281C53v17Ev();
extern void _ZN7S2281C53v18Ev();
extern void _ZN7S2281C53v19Ev();
extern void _ZN7S2281C53v20Ev();
extern void _ZN7S2281C53v21Ev();
extern void _ZN7S2281C53v22Ev();
extern void _ZN7S2281C53v23Ev();
extern void _ZN7S2281C53v24Ev();
extern void _ZN7S2281C53v25Ev();
extern void _ZN7S2281C53v26Ev();
extern void _ZN7S2281C53v27Ev();
extern void _ZN7S2281C53v28Ev();
extern void _ZN7S2281C53v29Ev();
static  VTBL_ENTRY vtc_S2281C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2281C1[0]),
  (VTBL_ENTRY)&_ZN7S2281C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2281C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2281C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2281C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2281C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2281C32v9Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v30Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v37Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v38Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v39Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v40Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v41Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v42Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v43Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v44Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v45Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v46Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v47Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v48Ev,
  (VTBL_ENTRY)&_ZN7S2281C23v49Ev,
  (VTBL_ENTRY)&_ZN7S2281C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2281C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2281C12v3Ev,
  ABISELECT(-192,-164),
  (VTBL_ENTRY)&(_ZTI7S2281C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2281C1D1Ev,_ZThn164_N7S2281C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2281C1D0Ev,_ZThn164_N7S2281C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2281C53v10Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v11Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v12Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v13Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v14Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v15Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v16Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v17Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v18Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v19Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v20Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v21Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v22Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v23Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v24Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v25Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v27Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v28Ev,
  (VTBL_ENTRY)&_ZN7S2281C53v29Ev,
};
extern VTBL_ENTRY _ZTI7S2281C1[];
extern  VTBL_ENTRY _ZTV7S2281C1[];
Class_Descriptor cd_S2281C1 = {  "S2281C1", // class name
  bases_S2281C1, 4,
  &(vtc_S2281C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(201288,126832), // object size
  NSPAIRA(_ZTI7S2281C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2281C1),57, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2282C4  {
  virtual  ~S2282C4(); // _ZN7S2282C4D1Ev
  virtual void  v4(); // _ZN7S2282C42v4Ev
  virtual void  v5(); // _ZN7S2282C42v5Ev
  virtual void  v6(); // _ZN7S2282C42v6Ev
  S2282C4(); // tgen
};
//SIG(-1 S2282C4) C1{ vd v1 v2 v3}


 S2282C4 ::~S2282C4(){ note_dtor("S2282C4", this);}
void  S2282C4 ::v4(){vfunc_called(this, "_ZN7S2282C42v4Ev");}
void  S2282C4 ::v5(){vfunc_called(this, "_ZN7S2282C42v5Ev");}
void  S2282C4 ::v6(){vfunc_called(this, "_ZN7S2282C42v6Ev");}
S2282C4 ::S2282C4(){ note_ctor("S2282C4", this);} // tgen

static void Test_S2282C4()
{
  extern Class_Descriptor cd_S2282C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2282C4, buf);
    S2282C4 *dp, &lv = *(dp=new (buf) S2282C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2282C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2282C4)");
    test_class_info(&lv, &cd_S2282C4);
    dp->~S2282C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2282C4(Test_S2282C4, "S2282C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2282C4C1Ev();
extern void _ZN7S2282C4D1Ev();
Name_Map name_map_S2282C4[] = {
  NSPAIR(_ZN7S2282C4C1Ev),
  NSPAIR(_ZN7S2282C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2282C4[];
extern void _ZN7S2282C4D1Ev();
extern void _ZN7S2282C4D0Ev();
extern void _ZN7S2282C42v4Ev();
extern void _ZN7S2282C42v5Ev();
extern void _ZN7S2282C42v6Ev();
static  VTBL_ENTRY vtc_S2282C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2282C4[0]),
  (VTBL_ENTRY)&_ZN7S2282C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2282C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v6Ev,
};
extern VTBL_ENTRY _ZTI7S2282C4[];
extern  VTBL_ENTRY _ZTV7S2282C4[];
Class_Descriptor cd_S2282C4 = {  "S2282C4", // class name
  0,0,//no base classes
  &(vtc_S2282C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2282C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2282C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2282C3  : S2282C4 {
  void *s2282c3f0[4];
  int s2282c3f1[3];
  void *s2282c3f2;
  char s2282c3f3[128];
  virtual  ~S2282C3(); // _ZN7S2282C3D1Ev
  virtual void  v7(); // _ZN7S2282C32v7Ev
  virtual void  v8(); // _ZN7S2282C32v8Ev
  virtual void  v9(); // _ZN7S2282C32v9Ev
  S2282C3(); // tgen
};
//SIG(-1 S2282C3) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 Fp[4] Fi[3] Fp Fc[128]}


 S2282C3 ::~S2282C3(){ note_dtor("S2282C3", this);}
void  S2282C3 ::v7(){vfunc_called(this, "_ZN7S2282C32v7Ev");}
void  S2282C3 ::v8(){vfunc_called(this, "_ZN7S2282C32v8Ev");}
void  S2282C3 ::v9(){vfunc_called(this, "_ZN7S2282C32v9Ev");}
S2282C3 ::S2282C3(){ note_ctor("S2282C3", this);} // tgen

static void Test_S2282C3()
{
  extern Class_Descriptor cd_S2282C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,42)];
    init_test(&cd_S2282C3, buf);
    S2282C3 *dp, &lv = *(dp=new (buf) S2282C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,164), "sizeof(S2282C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2282C3)");
    check_base_class_offset(lv, (S2282C4*), 0, "S2282C3");
    check_field_offset(lv, s2282c3f0, ABISELECT(8,4), "S2282C3.s2282c3f0");
    check_field_offset(lv, s2282c3f1, ABISELECT(40,20), "S2282C3.s2282c3f1");
    check_field_offset(lv, s2282c3f2, ABISELECT(56,32), "S2282C3.s2282c3f2");
    check_field_offset(lv, s2282c3f3, ABISELECT(64,36), "S2282C3.s2282c3f3");
    test_class_info(&lv, &cd_S2282C3);
    dp->~S2282C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2282C3(Test_S2282C3, "S2282C3", ABISELECT(192,164));

#else // __cplusplus

extern void _ZN7S2282C3C1Ev();
extern void _ZN7S2282C3D1Ev();
Name_Map name_map_S2282C3[] = {
  NSPAIR(_ZN7S2282C3C1Ev),
  NSPAIR(_ZN7S2282C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2282C4;
extern VTBL_ENTRY _ZTI7S2282C4[];
extern  VTBL_ENTRY _ZTV7S2282C4[];
static Base_Class bases_S2282C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2282C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2282C3[];
extern void _ZN7S2282C3D1Ev();
extern void _ZN7S2282C3D0Ev();
extern void _ZN7S2282C42v4Ev();
extern void _ZN7S2282C42v5Ev();
extern void _ZN7S2282C42v6Ev();
extern void _ZN7S2282C32v7Ev();
extern void _ZN7S2282C32v8Ev();
extern void _ZN7S2282C32v9Ev();
static  VTBL_ENTRY vtc_S2282C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2282C3[0]),
  (VTBL_ENTRY)&_ZN7S2282C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2282C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2282C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2282C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2282C32v9Ev,
};
extern VTBL_ENTRY _ZTI7S2282C3[];
extern  VTBL_ENTRY _ZTV7S2282C3[];
Class_Descriptor cd_S2282C3 = {  "S2282C3", // class name
  bases_S2282C3, 1,
  &(vtc_S2282C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,164), // object size
  NSPAIRA(_ZTI7S2282C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2282C3),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2282C5  {
  int s2282c5f0[2];
  virtual  ~S2282C5(); // _ZN7S2282C5D1Ev
  virtual void  v10(); // _ZN7S2282C53v10Ev
  virtual void  v11(); // _ZN7S2282C53v11Ev
  virtual void  v12(); // _ZN7S2282C53v12Ev
  virtual void  v13(); // _ZN7S2282C53v13Ev
  virtual void  v14(); // _ZN7S2282C53v14Ev
  virtual void  v15(); // _ZN7S2282C53v15Ev
  virtual void  v16(); // _ZN7S2282C53v16Ev
  virtual void  v17(); // _ZN7S2282C53v17Ev
  virtual void  v18(); // _ZN7S2282C53v18Ev
  virtual void  v19(); // _ZN7S2282C53v19Ev
  virtual void  v20(); // _ZN7S2282C53v20Ev
  virtual void  v21(); // _ZN7S2282C53v21Ev
  virtual void  v22(); // _ZN7S2282C53v22Ev
  virtual void  v23(); // _ZN7S2282C53v23Ev
  virtual void  v24(); // _ZN7S2282C53v24Ev
  virtual void  v25(); // _ZN7S2282C53v25Ev
  virtual void  v26(); // _ZN7S2282C53v26Ev
  virtual void  v27(); // _ZN7S2282C53v27Ev
  virtual void  v28(); // _ZN7S2282C53v28Ev
  virtual void  v29(); // _ZN7S2282C53v29Ev
  S2282C5(); // tgen
};
//SIG(-1 S2282C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi[2]}


 S2282C5 ::~S2282C5(){ note_dtor("S2282C5", this);}
void  S2282C5 ::v10(){vfunc_called(this, "_ZN7S2282C53v10Ev");}
void  S2282C5 ::v11(){vfunc_called(this, "_ZN7S2282C53v11Ev");}
void  S2282C5 ::v12(){vfunc_called(this, "_ZN7S2282C53v12Ev");}
void  S2282C5 ::v13(){vfunc_called(this, "_ZN7S2282C53v13Ev");}
void  S2282C5 ::v14(){vfunc_called(this, "_ZN7S2282C53v14Ev");}
void  S2282C5 ::v15(){vfunc_called(this, "_ZN7S2282C53v15Ev");}
void  S2282C5 ::v16(){vfunc_called(this, "_ZN7S2282C53v16Ev");}
void  S2282C5 ::v17(){vfunc_called(this, "_ZN7S2282C53v17Ev");}
void  S2282C5 ::v18(){vfunc_called(this, "_ZN7S2282C53v18Ev");}
void  S2282C5 ::v19(){vfunc_called(this, "_ZN7S2282C53v19Ev");}
void  S2282C5 ::v20(){vfunc_called(this, "_ZN7S2282C53v20Ev");}
void  S2282C5 ::v21(){vfunc_called(this, "_ZN7S2282C53v21Ev");}
void  S2282C5 ::v22(){vfunc_called(this, "_ZN7S2282C53v22Ev");}
void  S2282C5 ::v23(){vfunc_called(this, "_ZN7S2282C53v23Ev");}
void  S2282C5 ::v24(){vfunc_called(this, "_ZN7S2282C53v24Ev");}
void  S2282C5 ::v25(){vfunc_called(this, "_ZN7S2282C53v25Ev");}
void  S2282C5 ::v26(){vfunc_called(this, "_ZN7S2282C53v26Ev");}
void  S2282C5 ::v27(){vfunc_called(this, "_ZN7S2282C53v27Ev");}
void  S2282C5 ::v28(){vfunc_called(this, "_ZN7S2282C53v28Ev");}
void  S2282C5 ::v29(){vfunc_called(this, "_ZN7S2282C53v29Ev");}
S2282C5 ::S2282C5(){ note_ctor("S2282C5", this);} // tgen

static void Test_S2282C5()
{
  extern Class_Descriptor cd_S2282C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2282C5, buf);
    S2282C5 *dp, &lv = *(dp=new (buf) S2282C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2282C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2282C5)");
    check_field_offset(lv, s2282c5f0, ABISELECT(8,4), "S2282C5.s2282c5f0");
    test_class_info(&lv, &cd_S2282C5);
    dp->~S2282C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2282C5(Test_S2282C5, "S2282C5", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN7S2282C5C1Ev();
extern void _ZN7S2282C5D1Ev();
Name_Map name_map_S2282C5[] = {
  NSPAIR(_ZN7S2282C5C1Ev),
  NSPAIR(_ZN7S2282C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2282C5[];
extern void _ZN7S2282C5D1Ev();
extern void _ZN7S2282C5D0Ev();
extern void _ZN7S2282C53v10Ev();
extern void _ZN7S2282C53v11Ev();
extern void _ZN7S2282C53v12Ev();
extern void _ZN7S2282C53v13Ev();
extern void _ZN7S2282C53v14Ev();
extern void _ZN7S2282C53v15Ev();
extern void _ZN7S2282C53v16Ev();
extern void _ZN7S2282C53v17Ev();
extern void _ZN7S2282C53v18Ev();
extern void _ZN7S2282C53v19Ev();
extern void _ZN7S2282C53v20Ev();
extern void _ZN7S2282C53v21Ev();
extern void _ZN7S2282C53v22Ev();
extern void _ZN7S2282C53v23Ev();
extern void _ZN7S2282C53v24Ev();
extern void _ZN7S2282C53v25Ev();
extern void _ZN7S2282C53v26Ev();
extern void _ZN7S2282C53v27Ev();
extern void _ZN7S2282C53v28Ev();
extern void _ZN7S2282C53v29Ev();
static  VTBL_ENTRY vtc_S2282C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2282C5[0]),
  (VTBL_ENTRY)&_ZN7S2282C5D1Ev,
  (VTBL_ENTRY)&_ZN7S2282C5D0Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v10Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v11Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v12Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v13Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v14Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v15Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v16Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v17Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v18Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v19Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v20Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v21Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v22Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v23Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v24Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v25Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v27Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v28Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v29Ev,
};
extern VTBL_ENTRY _ZTI7S2282C5[];
extern  VTBL_ENTRY _ZTV7S2282C5[];
Class_Descriptor cd_S2282C5 = {  "S2282C5", // class name
  0,0,//no base classes
  &(vtc_S2282C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI7S2282C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2282C5),24, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2282C9_nt  {
  __tsi64 s2282c9f0[4];
  void  mf2282c9(); // _ZN10S2282C9_nt8mf2282c9Ev
};
//SIG(-1 S2282C9_nt) C1{ m FL[4]}


void  S2282C9_nt ::mf2282c9(){}

//skip512 S2282C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2282C2  : S2282C3 , S2282C5 {
  char s2282c2f0[2];
  short s2282c2f1[3];
  void *s2282c2f2;
  int s2282c2f3;
  ::S2280C6 s2282c2f4;
  void *s2282c2f5[2];
  ::S2282C9_nt s2282c2f6;
  void *s2282c2f7[2];
  ::S2280C11 s2282c2f8;
  void *s2282c2f9;
  ::S2280C44_nt s2282c2f10;
  ::S2280C6 s2282c2f11;
  ::S2280C28 s2282c2f12;
  ::S2280C16 s2282c2f13;
  virtual  ~S2282C2(); // _ZN7S2282C2D1Ev
  virtual void  v30(); // _ZN7S2282C23v30Ev
  virtual void  v31(); // _ZN7S2282C23v31Ev
  virtual void  v32(); // _ZN7S2282C23v32Ev
  virtual void  v33(); // _ZN7S2282C23v33Ev
  virtual void  v34(); // _ZN7S2282C23v34Ev
  virtual void  v35(); // _ZN7S2282C23v35Ev
  virtual void  v36(); // _ZN7S2282C23v36Ev
  virtual void  v37(); // _ZN7S2282C23v37Ev
  virtual void  v38(); // _ZN7S2282C23v38Ev
  virtual void  v39(); // _ZN7S2282C23v39Ev
  virtual void  v40(); // _ZN7S2282C23v40Ev
  virtual void  v41(); // _ZN7S2282C23v41Ev
  virtual void  v42(); // _ZN7S2282C23v42Ev
  virtual void  v43(); // _ZN7S2282C23v43Ev
  virtual void  v44(); // _ZN7S2282C23v44Ev
  virtual void  v45(); // _ZN7S2282C23v45Ev
  virtual void  v46(); // _ZN7S2282C23v46Ev
  virtual void  v47(); // _ZN7S2282C23v47Ev
  virtual void  v48(); // _ZN7S2282C23v48Ev
  virtual void  v49(); // _ZN7S2282C23v49Ev
  S2282C2(); // tgen
};
//SIG(-1 S2282C2) C1{ BC2{ BC3{ vd v21 v22 v23} vd v24 v25 v26 Fp[4] Fi[3] Fp Fc[128]} BC4{ vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fc[2] Fs[3] Fp Fi FC5{ FC6{ Fc[2] Fp[4] FC7{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} Fp[2] FC8{ m FL[4]} Fp[2] FC9{ Fc[4] FC10{ Fp Fs Fp Fs[2]} FU11{ FC12{ FC13{ Fs Fs Fl FC14{ Fs FC15{ Fp FC16{ Fs Fs Fs FC17{ Fp Fp Fp[2] Fl Fl Fl Fl[5] Fl Fs Fc Fc Fc} Fc} FC18{ Fs Fs Fs}}}[2] Fc Fc Fc Fp}[101] Fs Fs Fp Fc FC5 FC5 FC19{ Fs Fs Fs Fs Fs Fs Fs Fs Fs} FC20{ Fp Fc Fc Fc} Fs} FC21{ Fp FC18[41] Fs Fp FC14[301] Fs Fs[301] Fs FC5 FC5 FC5 FC19 FC22{ Fp Fp Fc Fc}}} FC23{ FC24{ Fp FC14[6] Fc Fc}[40] Fs} FC25{ FC26{ Fc Fc Fp FC27{ Fp Fs Fs Fp Fs Fs Fp Fs} Fp Fs Fs Fp Fp Fc Fc} FC28{ Fs FC7 Fs Fs FC17}[12]}[40] FC29{ Fs Fc Fs Fs Fc Fc Fc Fc Fc} Fs[41] Fs[41] FC30{ FC31{ Fs Fs Fc Fc Fc Fs[41] Fs[41] Fs[41] Fl Fs Fc}[5] FC31 Fc Fc} Fl[24] FC14[50] Fl FU32{ FC33{ Fs[12341] Fs} FC34{ Fs[2091] Fs}} FC35{ Fp FC5 Fc FC25 Fp Fs Fs Fs Fs FC36{ Fs Fs Fs Fc Fc} FC37{ FC14[2] Fs FC14[40] Fs} Fs Fs Fs} Fc Fc[12] FC38{ Fs Fs Fp Fp Fp Fp} FC5 FC5 FC39{ Fs[16] Fs[2] Fp} FC40{ Fc Fs Fs Fs} Fs[41]} Fp FC41{ m Fp Fi Fp} FC5 FC25 FC14}


 S2282C2 ::~S2282C2(){ note_dtor("S2282C2", this);}
void  S2282C2 ::v30(){vfunc_called(this, "_ZN7S2282C23v30Ev");}
void  S2282C2 ::v31(){vfunc_called(this, "_ZN7S2282C23v31Ev");}
void  S2282C2 ::v32(){vfunc_called(this, "_ZN7S2282C23v32Ev");}
void  S2282C2 ::v33(){vfunc_called(this, "_ZN7S2282C23v33Ev");}
void  S2282C2 ::v34(){vfunc_called(this, "_ZN7S2282C23v34Ev");}
void  S2282C2 ::v35(){vfunc_called(this, "_ZN7S2282C23v35Ev");}
void  S2282C2 ::v36(){vfunc_called(this, "_ZN7S2282C23v36Ev");}
void  S2282C2 ::v37(){vfunc_called(this, "_ZN7S2282C23v37Ev");}
void  S2282C2 ::v38(){vfunc_called(this, "_ZN7S2282C23v38Ev");}
void  S2282C2 ::v39(){vfunc_called(this, "_ZN7S2282C23v39Ev");}
void  S2282C2 ::v40(){vfunc_called(this, "_ZN7S2282C23v40Ev");}
void  S2282C2 ::v41(){vfunc_called(this, "_ZN7S2282C23v41Ev");}
void  S2282C2 ::v42(){vfunc_called(this, "_ZN7S2282C23v42Ev");}
void  S2282C2 ::v43(){vfunc_called(this, "_ZN7S2282C23v43Ev");}
void  S2282C2 ::v44(){vfunc_called(this, "_ZN7S2282C23v44Ev");}
void  S2282C2 ::v45(){vfunc_called(this, "_ZN7S2282C23v45Ev");}
void  S2282C2 ::v46(){vfunc_called(this, "_ZN7S2282C23v46Ev");}
void  S2282C2 ::v47(){vfunc_called(this, "_ZN7S2282C23v47Ev");}
void  S2282C2 ::v48(){vfunc_called(this, "_ZN7S2282C23v48Ev");}
void  S2282C2 ::v49(){vfunc_called(this, "_ZN7S2282C23v49Ev");}
S2282C2 ::S2282C2(){ note_ctor("S2282C2", this);} // tgen

static void Test_S2282C2()
{
  extern Class_Descriptor cd_S2282C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25151,31688)];
    init_test(&cd_S2282C2, buf);
    S2282C2 *dp, &lv = *(dp=new (buf) S2282C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(201200,126748), "sizeof(S2282C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2282C2)");
    check_base_class_offset(lv, (S2282C4*)(S2282C3*), 0, "S2282C2");
    check_base_class_offset(lv, (S2282C3*), 0, "S2282C2");
    check_base_class_offset(lv, (S2282C5*), ABISELECT(192,164), "S2282C2");
    check_field_offset(lv, s2282c2f0, ABISELECT(208,176), "S2282C2.s2282c2f0");
    check_field_offset(lv, s2282c2f1, ABISELECT(210,178), "S2282C2.s2282c2f1");
    check_field_offset(lv, s2282c2f2, ABISELECT(216,184), "S2282C2.s2282c2f2");
    check_field_offset(lv, s2282c2f3, ABISELECT(224,188), "S2282C2.s2282c2f3");
    check_field_offset(lv, s2282c2f4, ABISELECT(232,192), "S2282C2.s2282c2f4");
    check_field_offset(lv, s2282c2f5, ABISELECT(1112,720), "S2282C2.s2282c2f5");
    check_field_offset(lv, s2282c2f6, ABISELECT(1128,728), "S2282C2.s2282c2f6");
    check_field_offset(lv, s2282c2f7, ABISELECT(1160,760), "S2282C2.s2282c2f7");
    check_field_offset(lv, s2282c2f8, ABISELECT(1176,768), "S2282C2.s2282c2f8");
    check_field_offset(lv, s2282c2f9, ABISELECT(198496,125200), "S2282C2.s2282c2f9");
    check_field_offset(lv, s2282c2f10, ABISELECT(198504,125204), "S2282C2.s2282c2f10");
    check_field_offset(lv, s2282c2f11, ABISELECT(198528,125216), "S2282C2.s2282c2f11");
    check_field_offset(lv, s2282c2f12, ABISELECT(199408,125744), "S2282C2.s2282c2f12");
    check_field_offset(lv, s2282c2f13, ABISELECT(201048,126660), "S2282C2.s2282c2f13");
    test_class_info(&lv, &cd_S2282C2);
    dp->~S2282C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2282C2(Test_S2282C2, "S2282C2", ABISELECT(201200,126748));

#else // __cplusplus

extern void _ZN7S2282C2C1Ev();
extern void _ZN7S2282C2D1Ev();
Name_Map name_map_S2282C2[] = {
  NSPAIR(_ZN7S2282C2C1Ev),
  NSPAIR(_ZN7S2282C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2282C4;
extern VTBL_ENTRY _ZTI7S2282C4[];
extern  VTBL_ENTRY _ZTV7S2282C4[];
extern Class_Descriptor cd_S2282C3;
extern VTBL_ENTRY _ZTI7S2282C3[];
extern  VTBL_ENTRY _ZTV7S2282C3[];
extern Class_Descriptor cd_S2282C5;
extern VTBL_ENTRY _ZTI7S2282C5[];
extern  VTBL_ENTRY _ZTV7S2282C5[];
static Base_Class bases_S2282C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2282C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2282C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2282C5,    ABISELECT(192,164), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2282C2[];
extern void _ZN7S2282C2D1Ev();
extern void _ZN7S2282C2D0Ev();
extern void _ZN7S2282C42v4Ev();
extern void _ZN7S2282C42v5Ev();
extern void _ZN7S2282C42v6Ev();
extern void _ZN7S2282C32v7Ev();
extern void _ZN7S2282C32v8Ev();
extern void _ZN7S2282C32v9Ev();
extern void _ZN7S2282C23v30Ev();
extern void _ZN7S2282C23v31Ev();
extern void _ZN7S2282C23v32Ev();
extern void _ZN7S2282C23v33Ev();
extern void _ZN7S2282C23v34Ev();
extern void _ZN7S2282C23v35Ev();
extern void _ZN7S2282C23v36Ev();
extern void _ZN7S2282C23v37Ev();
extern void _ZN7S2282C23v38Ev();
extern void _ZN7S2282C23v39Ev();
extern void _ZN7S2282C23v40Ev();
extern void _ZN7S2282C23v41Ev();
extern void _ZN7S2282C23v42Ev();
extern void _ZN7S2282C23v43Ev();
extern void _ZN7S2282C23v44Ev();
extern void _ZN7S2282C23v45Ev();
extern void _ZN7S2282C23v46Ev();
extern void _ZN7S2282C23v47Ev();
extern void _ZN7S2282C23v48Ev();
extern void _ZN7S2282C23v49Ev();
extern void ABISELECT(_ZThn192_N7S2282C2D1Ev,_ZThn164_N7S2282C2D1Ev)();
extern void ABISELECT(_ZThn192_N7S2282C2D0Ev,_ZThn164_N7S2282C2D0Ev)();
extern void _ZN7S2282C53v10Ev();
extern void _ZN7S2282C53v11Ev();
extern void _ZN7S2282C53v12Ev();
extern void _ZN7S2282C53v13Ev();
extern void _ZN7S2282C53v14Ev();
extern void _ZN7S2282C53v15Ev();
extern void _ZN7S2282C53v16Ev();
extern void _ZN7S2282C53v17Ev();
extern void _ZN7S2282C53v18Ev();
extern void _ZN7S2282C53v19Ev();
extern void _ZN7S2282C53v20Ev();
extern void _ZN7S2282C53v21Ev();
extern void _ZN7S2282C53v22Ev();
extern void _ZN7S2282C53v23Ev();
extern void _ZN7S2282C53v24Ev();
extern void _ZN7S2282C53v25Ev();
extern void _ZN7S2282C53v26Ev();
extern void _ZN7S2282C53v27Ev();
extern void _ZN7S2282C53v28Ev();
extern void _ZN7S2282C53v29Ev();
static  VTBL_ENTRY vtc_S2282C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2282C2[0]),
  (VTBL_ENTRY)&_ZN7S2282C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2282C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2282C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2282C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2282C32v9Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v30Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v37Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v38Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v39Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v40Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v41Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v42Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v43Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v44Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v45Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v46Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v47Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v48Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v49Ev,
  ABISELECT(-192,-164),
  (VTBL_ENTRY)&(_ZTI7S2282C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2282C2D1Ev,_ZThn164_N7S2282C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2282C2D0Ev,_ZThn164_N7S2282C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2282C53v10Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v11Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v12Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v13Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v14Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v15Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v16Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v17Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v18Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v19Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v20Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v21Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v22Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v23Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v24Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v25Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v27Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v28Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v29Ev,
};
extern VTBL_ENTRY _ZTI7S2282C2[];
extern  VTBL_ENTRY _ZTV7S2282C2[];
Class_Descriptor cd_S2282C2 = {  "S2282C2", // class name
  bases_S2282C2, 3,
  &(vtc_S2282C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(201200,126748), // object size
  NSPAIRA(_ZTI7S2282C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2282C2),54, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2282C1  : S2282C2 {
  short s2282c1f0;
  short s2282c1f1[41];
  virtual void  v1(); // _ZN7S2282C12v1Ev
  virtual void  v2(); // _ZN7S2282C12v2Ev
  virtual void  v3(); // _ZN7S2282C12v3Ev
  ~S2282C1(); // tgen
  S2282C1(); // tgen
};
//SIG(1 S2282C1) C1{ BC2{ BC3{ BC4{ vd v4 v5 v6} vd v7 v8 v9 Fp[4] Fi[3] Fp Fc[128]} BC5{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 Fi[2]} vd v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 Fc[2] Fs[3] Fp Fi FC6{ FC7{ Fc[2] Fp[4] FC8{ Fs[2]}[3] Fp}[12] Fp[3] Fs[42]} Fp[2] FC9{ m FL[4]} Fp[2] FC10{ Fc[4] FC11{ Fp Fs Fp Fs[2]} FU12{ FC13{ FC14{ Fs Fs Fl FC15{ Fs FC16{ Fp FC17{ Fs Fs Fs FC18{ Fp Fp Fp[2] Fl Fl Fl Fl[5] Fl Fs Fc Fc Fc} Fc} FC19{ Fs Fs Fs}}}[2] Fc Fc Fc Fp}[101] Fs Fs Fp Fc FC6 FC6 FC20{ Fs Fs Fs Fs Fs Fs Fs Fs Fs} FC21{ Fp Fc Fc Fc} Fs} FC22{ Fp FC19[41] Fs Fp FC15[301] Fs Fs[301] Fs FC6 FC6 FC6 FC20 FC23{ Fp Fp Fc Fc}}} FC24{ FC25{ Fp FC15[6] Fc Fc}[40] Fs} FC26{ FC27{ Fc Fc Fp FC28{ Fp Fs Fs Fp Fs Fs Fp Fs} Fp Fs Fs Fp Fp Fc Fc} FC29{ Fs FC8 Fs Fs FC18}[12]}[40] FC30{ Fs Fc Fs Fs Fc Fc Fc Fc Fc} Fs[41] Fs[41] FC31{ FC32{ Fs Fs Fc Fc Fc Fs[41] Fs[41] Fs[41] Fl Fs Fc}[5] FC32 Fc Fc} Fl[24] FC15[50] Fl FU33{ FC34{ Fs[12341] Fs} FC35{ Fs[2091] Fs}} FC36{ Fp FC6 Fc FC26 Fp Fs Fs Fs Fs FC37{ Fs Fs Fs Fc Fc} FC38{ FC15[2] Fs FC15[40] Fs} Fs Fs Fs} Fc Fc[12] FC39{ Fs Fs Fp Fp Fp Fp} FC6 FC6 FC40{ Fs[16] Fs[2] Fp} FC41{ Fc Fs Fs Fs} Fs[41]} Fp FC42{ m Fp Fi Fp} FC6 FC26 FC15} v1 v2 v3 Fs Fs[41]}


void  S2282C1 ::v1(){vfunc_called(this, "_ZN7S2282C12v1Ev");}
void  S2282C1 ::v2(){vfunc_called(this, "_ZN7S2282C12v2Ev");}
void  S2282C1 ::v3(){vfunc_called(this, "_ZN7S2282C12v3Ev");}
S2282C1 ::~S2282C1(){ note_dtor("S2282C1", this);} // tgen
S2282C1 ::S2282C1(){ note_ctor("S2282C1", this);} // tgen

static void Test_S2282C1()
{
  extern Class_Descriptor cd_S2282C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25162,31709)];
    init_test(&cd_S2282C1, buf);
    S2282C1 *dp, &lv = *(dp=new (buf) S2282C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(201288,126832), "sizeof(S2282C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2282C1)");
    check_base_class_offset(lv, (S2282C4*)(S2282C3*)(S2282C2*), 0, "S2282C1");
    check_base_class_offset(lv, (S2282C3*)(S2282C2*), 0, "S2282C1");
    check_base_class_offset(lv, (S2282C5*)(S2282C2*), ABISELECT(192,164), "S2282C1");
    check_base_class_offset(lv, (S2282C2*), 0, "S2282C1");
    check_field_offset(lv, s2282c1f0, ABISELECT(201200,126748), "S2282C1.s2282c1f0");
    check_field_offset(lv, s2282c1f1, ABISELECT(201202,126750), "S2282C1.s2282c1f1");
    test_class_info(&lv, &cd_S2282C1);
    dp->~S2282C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2282C1(Test_S2282C1, "S2282C1", ABISELECT(201288,126832));

#else // __cplusplus

extern void _ZN7S2282C1C1Ev();
extern void _ZN7S2282C1D1Ev();
Name_Map name_map_S2282C1[] = {
  NSPAIR(_ZN7S2282C1C1Ev),
  NSPAIR(_ZN7S2282C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2282C4;
extern VTBL_ENTRY _ZTI7S2282C4[];
extern  VTBL_ENTRY _ZTV7S2282C4[];
extern Class_Descriptor cd_S2282C3;
extern VTBL_ENTRY _ZTI7S2282C3[];
extern  VTBL_ENTRY _ZTV7S2282C3[];
extern Class_Descriptor cd_S2282C5;
extern VTBL_ENTRY _ZTI7S2282C5[];
extern  VTBL_ENTRY _ZTV7S2282C5[];
extern Class_Descriptor cd_S2282C2;
extern VTBL_ENTRY _ZTI7S2282C2[];
extern  VTBL_ENTRY _ZTV7S2282C2[];
static Base_Class bases_S2282C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2282C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2282C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2282C5,    ABISELECT(192,164), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2282C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2282C1[];
extern void _ZN7S2282C1D1Ev();
extern void _ZN7S2282C1D0Ev();
extern void _ZN7S2282C42v4Ev();
extern void _ZN7S2282C42v5Ev();
extern void _ZN7S2282C42v6Ev();
extern void _ZN7S2282C32v7Ev();
extern void _ZN7S2282C32v8Ev();
extern void _ZN7S2282C32v9Ev();
extern void _ZN7S2282C23v30Ev();
extern void _ZN7S2282C23v31Ev();
extern void _ZN7S2282C23v32Ev();
extern void _ZN7S2282C23v33Ev();
extern void _ZN7S2282C23v34Ev();
extern void _ZN7S2282C23v35Ev();
extern void _ZN7S2282C23v36Ev();
extern void _ZN7S2282C23v37Ev();
extern void _ZN7S2282C23v38Ev();
extern void _ZN7S2282C23v39Ev();
extern void _ZN7S2282C23v40Ev();
extern void _ZN7S2282C23v41Ev();
extern void _ZN7S2282C23v42Ev();
extern void _ZN7S2282C23v43Ev();
extern void _ZN7S2282C23v44Ev();
extern void _ZN7S2282C23v45Ev();
extern void _ZN7S2282C23v46Ev();
extern void _ZN7S2282C23v47Ev();
extern void _ZN7S2282C23v48Ev();
extern void _ZN7S2282C23v49Ev();
extern void _ZN7S2282C12v1Ev();
extern void _ZN7S2282C12v2Ev();
extern void _ZN7S2282C12v3Ev();
extern void ABISELECT(_ZThn192_N7S2282C1D1Ev,_ZThn164_N7S2282C1D1Ev)();
extern void ABISELECT(_ZThn192_N7S2282C1D0Ev,_ZThn164_N7S2282C1D0Ev)();
extern void _ZN7S2282C53v10Ev();
extern void _ZN7S2282C53v11Ev();
extern void _ZN7S2282C53v12Ev();
extern void _ZN7S2282C53v13Ev();
extern void _ZN7S2282C53v14Ev();
extern void _ZN7S2282C53v15Ev();
extern void _ZN7S2282C53v16Ev();
extern void _ZN7S2282C53v17Ev();
extern void _ZN7S2282C53v18Ev();
extern void _ZN7S2282C53v19Ev();
extern void _ZN7S2282C53v20Ev();
extern void _ZN7S2282C53v21Ev();
extern void _ZN7S2282C53v22Ev();
extern void _ZN7S2282C53v23Ev();
extern void _ZN7S2282C53v24Ev();
extern void _ZN7S2282C53v25Ev();
extern void _ZN7S2282C53v26Ev();
extern void _ZN7S2282C53v27Ev();
extern void _ZN7S2282C53v28Ev();
extern void _ZN7S2282C53v29Ev();
static  VTBL_ENTRY vtc_S2282C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2282C1[0]),
  (VTBL_ENTRY)&_ZN7S2282C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2282C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2282C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2282C32v7Ev,
  (VTBL_ENTRY)&_ZN7S2282C32v8Ev,
  (VTBL_ENTRY)&_ZN7S2282C32v9Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v30Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v35Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v36Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v37Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v38Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v39Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v40Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v41Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v42Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v43Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v44Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v45Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v46Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v47Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v48Ev,
  (VTBL_ENTRY)&_ZN7S2282C23v49Ev,
  (VTBL_ENTRY)&_ZN7S2282C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2282C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2282C12v3Ev,
  ABISELECT(-192,-164),
  (VTBL_ENTRY)&(_ZTI7S2282C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2282C1D1Ev,_ZThn164_N7S2282C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N7S2282C1D0Ev,_ZThn164_N7S2282C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2282C53v10Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v11Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v12Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v13Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v14Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v15Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v16Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v17Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v18Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v19Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v20Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v21Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v22Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v23Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v24Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v25Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v27Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v28Ev,
  (VTBL_ENTRY)&_ZN7S2282C53v29Ev,
};
extern VTBL_ENTRY _ZTI7S2282C1[];
extern  VTBL_ENTRY _ZTV7S2282C1[];
Class_Descriptor cd_S2282C1 = {  "S2282C1", // class name
  bases_S2282C1, 4,
  &(vtc_S2282C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(201288,126832), // object size
  NSPAIRA(_ZTI7S2282C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2282C1),57, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S578C5  {
  int s578c5f0;
  __tsi64 s578c5f1;
  void *s578c5f2[4];
  int s578c5f3[2];
  void *s578c5f4;
  ::S1502C5_nt s578c5f5;
  void *s578c5f6[2];
  virtual  ~S578C5(); // _ZN6S578C5D1Ev
  virtual void  v4(); // _ZN6S578C52v4Ev
  virtual void  v5(); // _ZN6S578C52v5Ev
  virtual void  v6(); // _ZN6S578C52v6Ev
  virtual void  v7(); // _ZN6S578C52v7Ev
  virtual void  v8(); // _ZN6S578C52v8Ev
  virtual void  v9(); // _ZN6S578C52v9Ev
  virtual void  v10(); // _ZN6S578C53v10Ev
  virtual void  v11(); // _ZN6S578C53v11Ev
  virtual void  v12(); // _ZN6S578C53v12Ev
  virtual void  v13(); // _ZN6S578C53v13Ev
  virtual void  v14(); // _ZN6S578C53v14Ev
  virtual void  v15(); // _ZN6S578C53v15Ev
  virtual void  v16(); // _ZN6S578C53v16Ev
  virtual void  v17(); // _ZN6S578C53v17Ev
  virtual void  v18(); // _ZN6S578C53v18Ev
  virtual void  v19(); // _ZN6S578C53v19Ev
  virtual void  v20(); // _ZN6S578C53v20Ev
  virtual void  v21(); // _ZN6S578C53v21Ev
  virtual void  v22(); // _ZN6S578C53v22Ev
  virtual void  v23(); // _ZN6S578C53v23Ev
  virtual void  v24(); // _ZN6S578C53v24Ev
  virtual void  v25(); // _ZN6S578C53v25Ev
  virtual void  v26(); // _ZN6S578C53v26Ev
  virtual void  v27(); // _ZN6S578C53v27Ev
  virtual void  v28(); // _ZN6S578C53v28Ev
  virtual void  v29(); // _ZN6S578C53v29Ev
  virtual void  v30(); // _ZN6S578C53v30Ev
  virtual void  v31(); // _ZN6S578C53v31Ev
  virtual void  v32(); // _ZN6S578C53v32Ev
  virtual void  v33(); // _ZN6S578C53v33Ev
  virtual void  v34(); // _ZN6S578C53v34Ev
  virtual void  v35(); // _ZN6S578C53v35Ev
  virtual void  v36(); // _ZN6S578C53v36Ev
  virtual void  v37(); // _ZN6S578C53v37Ev
  virtual void  v38(); // _ZN6S578C53v38Ev
  virtual void  v39(); // _ZN6S578C53v39Ev
  virtual void  v40(); // _ZN6S578C53v40Ev
  virtual void  v41(); // _ZN6S578C53v41Ev
  virtual void  v42(); // _ZN6S578C53v42Ev
  virtual void  v43(); // _ZN6S578C53v43Ev
  virtual void  v44(); // _ZN6S578C53v44Ev
  virtual void  v45(); // _ZN6S578C53v45Ev
  virtual void  v46(); // _ZN6S578C53v46Ev
  virtual void  v47(); // _ZN6S578C53v47Ev
  virtual void  v48(); // _ZN6S578C53v48Ev
  virtual void  v49(); // _ZN6S578C53v49Ev
  virtual void  v50(); // _ZN6S578C53v50Ev
  virtual void  v51(); // _ZN6S578C53v51Ev
  virtual void  v52(); // _ZN6S578C53v52Ev
  virtual void  v53(); // _ZN6S578C53v53Ev
  virtual void  v54(); // _ZN6S578C53v54Ev
  virtual void  v55(); // _ZN6S578C53v55Ev
  virtual void  v56(); // _ZN6S578C53v56Ev
  virtual void  v57(); // _ZN6S578C53v57Ev
  virtual void  v58(); // _ZN6S578C53v58Ev
  virtual void  v59(); // _ZN6S578C53v59Ev
  virtual void  v60(); // _ZN6S578C53v60Ev
  virtual void  v61(); // _ZN6S578C53v61Ev
  virtual void  v62(); // _ZN6S578C53v62Ev
  virtual void  v63(); // _ZN6S578C53v63Ev
  virtual void  v64(); // _ZN6S578C53v64Ev
  virtual void  v65(); // _ZN6S578C53v65Ev
  virtual void  v66(); // _ZN6S578C53v66Ev
  virtual void  v67(); // _ZN6S578C53v67Ev
  S578C5(); // tgen
};
//SIG(-1 S578C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S578C5 ::~S578C5(){ note_dtor("S578C5", this);}
void  S578C5 ::v4(){vfunc_called(this, "_ZN6S578C52v4Ev");}
void  S578C5 ::v5(){vfunc_called(this, "_ZN6S578C52v5Ev");}
void  S578C5 ::v6(){vfunc_called(this, "_ZN6S578C52v6Ev");}
void  S578C5 ::v7(){vfunc_called(this, "_ZN6S578C52v7Ev");}
void  S578C5 ::v8(){vfunc_called(this, "_ZN6S578C52v8Ev");}
void  S578C5 ::v9(){vfunc_called(this, "_ZN6S578C52v9Ev");}
void  S578C5 ::v10(){vfunc_called(this, "_ZN6S578C53v10Ev");}
void  S578C5 ::v11(){vfunc_called(this, "_ZN6S578C53v11Ev");}
void  S578C5 ::v12(){vfunc_called(this, "_ZN6S578C53v12Ev");}
void  S578C5 ::v13(){vfunc_called(this, "_ZN6S578C53v13Ev");}
void  S578C5 ::v14(){vfunc_called(this, "_ZN6S578C53v14Ev");}
void  S578C5 ::v15(){vfunc_called(this, "_ZN6S578C53v15Ev");}
void  S578C5 ::v16(){vfunc_called(this, "_ZN6S578C53v16Ev");}
void  S578C5 ::v17(){vfunc_called(this, "_ZN6S578C53v17Ev");}
void  S578C5 ::v18(){vfunc_called(this, "_ZN6S578C53v18Ev");}
void  S578C5 ::v19(){vfunc_called(this, "_ZN6S578C53v19Ev");}
void  S578C5 ::v20(){vfunc_called(this, "_ZN6S578C53v20Ev");}
void  S578C5 ::v21(){vfunc_called(this, "_ZN6S578C53v21Ev");}
void  S578C5 ::v22(){vfunc_called(this, "_ZN6S578C53v22Ev");}
void  S578C5 ::v23(){vfunc_called(this, "_ZN6S578C53v23Ev");}
void  S578C5 ::v24(){vfunc_called(this, "_ZN6S578C53v24Ev");}
void  S578C5 ::v25(){vfunc_called(this, "_ZN6S578C53v25Ev");}
void  S578C5 ::v26(){vfunc_called(this, "_ZN6S578C53v26Ev");}
void  S578C5 ::v27(){vfunc_called(this, "_ZN6S578C53v27Ev");}
void  S578C5 ::v28(){vfunc_called(this, "_ZN6S578C53v28Ev");}
void  S578C5 ::v29(){vfunc_called(this, "_ZN6S578C53v29Ev");}
void  S578C5 ::v30(){vfunc_called(this, "_ZN6S578C53v30Ev");}
void  S578C5 ::v31(){vfunc_called(this, "_ZN6S578C53v31Ev");}
void  S578C5 ::v32(){vfunc_called(this, "_ZN6S578C53v32Ev");}
void  S578C5 ::v33(){vfunc_called(this, "_ZN6S578C53v33Ev");}
void  S578C5 ::v34(){vfunc_called(this, "_ZN6S578C53v34Ev");}
void  S578C5 ::v35(){vfunc_called(this, "_ZN6S578C53v35Ev");}
void  S578C5 ::v36(){vfunc_called(this, "_ZN6S578C53v36Ev");}
void  S578C5 ::v37(){vfunc_called(this, "_ZN6S578C53v37Ev");}
void  S578C5 ::v38(){vfunc_called(this, "_ZN6S578C53v38Ev");}
void  S578C5 ::v39(){vfunc_called(this, "_ZN6S578C53v39Ev");}
void  S578C5 ::v40(){vfunc_called(this, "_ZN6S578C53v40Ev");}
void  S578C5 ::v41(){vfunc_called(this, "_ZN6S578C53v41Ev");}
void  S578C5 ::v42(){vfunc_called(this, "_ZN6S578C53v42Ev");}
void  S578C5 ::v43(){vfunc_called(this, "_ZN6S578C53v43Ev");}
void  S578C5 ::v44(){vfunc_called(this, "_ZN6S578C53v44Ev");}
void  S578C5 ::v45(){vfunc_called(this, "_ZN6S578C53v45Ev");}
void  S578C5 ::v46(){vfunc_called(this, "_ZN6S578C53v46Ev");}
void  S578C5 ::v47(){vfunc_called(this, "_ZN6S578C53v47Ev");}
void  S578C5 ::v48(){vfunc_called(this, "_ZN6S578C53v48Ev");}
void  S578C5 ::v49(){vfunc_called(this, "_ZN6S578C53v49Ev");}
void  S578C5 ::v50(){vfunc_called(this, "_ZN6S578C53v50Ev");}
void  S578C5 ::v51(){vfunc_called(this, "_ZN6S578C53v51Ev");}
void  S578C5 ::v52(){vfunc_called(this, "_ZN6S578C53v52Ev");}
void  S578C5 ::v53(){vfunc_called(this, "_ZN6S578C53v53Ev");}
void  S578C5 ::v54(){vfunc_called(this, "_ZN6S578C53v54Ev");}
void  S578C5 ::v55(){vfunc_called(this, "_ZN6S578C53v55Ev");}
void  S578C5 ::v56(){vfunc_called(this, "_ZN6S578C53v56Ev");}
void  S578C5 ::v57(){vfunc_called(this, "_ZN6S578C53v57Ev");}
void  S578C5 ::v58(){vfunc_called(this, "_ZN6S578C53v58Ev");}
void  S578C5 ::v59(){vfunc_called(this, "_ZN6S578C53v59Ev");}
void  S578C5 ::v60(){vfunc_called(this, "_ZN6S578C53v60Ev");}
void  S578C5 ::v61(){vfunc_called(this, "_ZN6S578C53v61Ev");}
void  S578C5 ::v62(){vfunc_called(this, "_ZN6S578C53v62Ev");}
void  S578C5 ::v63(){vfunc_called(this, "_ZN6S578C53v63Ev");}
void  S578C5 ::v64(){vfunc_called(this, "_ZN6S578C53v64Ev");}
void  S578C5 ::v65(){vfunc_called(this, "_ZN6S578C53v65Ev");}
void  S578C5 ::v66(){vfunc_called(this, "_ZN6S578C53v66Ev");}
void  S578C5 ::v67(){vfunc_called(this, "_ZN6S578C53v67Ev");}
S578C5 ::S578C5(){ note_ctor("S578C5", this);} // tgen

static void Test_S578C5()
{
  extern Class_Descriptor cd_S578C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S578C5, buf);
    S578C5 *dp, &lv = *(dp=new (buf) S578C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S578C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S578C5)");
    check_field_offset(lv, s578c5f0, ABISELECT(8,4), "S578C5.s578c5f0");
    check_field_offset(lv, s578c5f1, ABISELECT(16,8), "S578C5.s578c5f1");
    check_field_offset(lv, s578c5f2, ABISELECT(24,16), "S578C5.s578c5f2");
    check_field_offset(lv, s578c5f3, ABISELECT(56,32), "S578C5.s578c5f3");
    check_field_offset(lv, s578c5f4, ABISELECT(64,40), "S578C5.s578c5f4");
    check_field_offset(lv, s578c5f5, ABISELECT(72,44), "S578C5.s578c5f5");
    check_field_offset(lv, s578c5f6, ABISELECT(80,52), "S578C5.s578c5f6");
    test_class_info(&lv, &cd_S578C5);
    dp->~S578C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS578C5(Test_S578C5, "S578C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S578C5C1Ev();
extern void _ZN6S578C5D1Ev();
Name_Map name_map_S578C5[] = {
  NSPAIR(_ZN6S578C5C1Ev),
  NSPAIR(_ZN6S578C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S578C5[];
extern void _ZN6S578C5D1Ev();
extern void _ZN6S578C5D0Ev();
extern void _ZN6S578C52v4Ev();
extern void _ZN6S578C52v5Ev();
extern void _ZN6S578C52v6Ev();
extern void _ZN6S578C52v7Ev();
extern void _ZN6S578C52v8Ev();
extern void _ZN6S578C52v9Ev();
extern void _ZN6S578C53v10Ev();
extern void _ZN6S578C53v11Ev();
extern void _ZN6S578C53v12Ev();
extern void _ZN6S578C53v13Ev();
extern void _ZN6S578C53v14Ev();
extern void _ZN6S578C53v15Ev();
extern void _ZN6S578C53v16Ev();
extern void _ZN6S578C53v17Ev();
extern void _ZN6S578C53v18Ev();
extern void _ZN6S578C53v19Ev();
extern void _ZN6S578C53v20Ev();
extern void _ZN6S578C53v21Ev();
extern void _ZN6S578C53v22Ev();
extern void _ZN6S578C53v23Ev();
extern void _ZN6S578C53v24Ev();
extern void _ZN6S578C53v25Ev();
extern void _ZN6S578C53v26Ev();
extern void _ZN6S578C53v27Ev();
extern void _ZN6S578C53v28Ev();
extern void _ZN6S578C53v29Ev();
extern void _ZN6S578C53v30Ev();
extern void _ZN6S578C53v31Ev();
extern void _ZN6S578C53v32Ev();
extern void _ZN6S578C53v33Ev();
extern void _ZN6S578C53v34Ev();
extern void _ZN6S578C53v35Ev();
extern void _ZN6S578C53v36Ev();
extern void _ZN6S578C53v37Ev();
extern void _ZN6S578C53v38Ev();
extern void _ZN6S578C53v39Ev();
extern void _ZN6S578C53v40Ev();
extern void _ZN6S578C53v41Ev();
extern void _ZN6S578C53v42Ev();
extern void _ZN6S578C53v43Ev();
extern void _ZN6S578C53v44Ev();
extern void _ZN6S578C53v45Ev();
extern void _ZN6S578C53v46Ev();
extern void _ZN6S578C53v47Ev();
extern void _ZN6S578C53v48Ev();
extern void _ZN6S578C53v49Ev();
extern void _ZN6S578C53v50Ev();
extern void _ZN6S578C53v51Ev();
extern void _ZN6S578C53v52Ev();
extern void _ZN6S578C53v53Ev();
extern void _ZN6S578C53v54Ev();
extern void _ZN6S578C53v55Ev();
extern void _ZN6S578C53v56Ev();
extern void _ZN6S578C53v57Ev();
extern void _ZN6S578C53v58Ev();
extern void _ZN6S578C53v59Ev();
extern void _ZN6S578C53v60Ev();
extern void _ZN6S578C53v61Ev();
extern void _ZN6S578C53v62Ev();
extern void _ZN6S578C53v63Ev();
extern void _ZN6S578C53v64Ev();
extern void _ZN6S578C53v65Ev();
extern void _ZN6S578C53v66Ev();
extern void _ZN6S578C53v67Ev();
static  VTBL_ENTRY vtc_S578C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S578C5[0]),
  (VTBL_ENTRY)&_ZN6S578C5D1Ev,
  (VTBL_ENTRY)&_ZN6S578C5D0Ev,
  (VTBL_ENTRY)&_ZN6S578C52v4Ev,
  (VTBL_ENTRY)&_ZN6S578C52v5Ev,
  (VTBL_ENTRY)&_ZN6S578C52v6Ev,
  (VTBL_ENTRY)&_ZN6S578C52v7Ev,
  (VTBL_ENTRY)&_ZN6S578C52v8Ev,
  (VTBL_ENTRY)&_ZN6S578C52v9Ev,
  (VTBL_ENTRY)&_ZN6S578C53v10Ev,
  (VTBL_ENTRY)&_ZN6S578C53v11Ev,
  (VTBL_ENTRY)&_ZN6S578C53v12Ev,
  (VTBL_ENTRY)&_ZN6S578C53v13Ev,
  (VTBL_ENTRY)&_ZN6S578C53v14Ev,
  (VTBL_ENTRY)&_ZN6S578C53v15Ev,
  (VTBL_ENTRY)&_ZN6S578C53v16Ev,
  (VTBL_ENTRY)&_ZN6S578C53v17Ev,
  (VTBL_ENTRY)&_ZN6S578C53v18Ev,
  (VTBL_ENTRY)&_ZN6S578C53v19Ev,
  (VTBL_ENTRY)&_ZN6S578C53v20Ev,
  (VTBL_ENTRY)&_ZN6S578C53v21Ev,
  (VTBL_ENTRY)&_ZN6S578C53v22Ev,
  (VTBL_ENTRY)&_ZN6S578C53v23Ev,
  (VTBL_ENTRY)&_ZN6S578C53v24Ev,
  (VTBL_ENTRY)&_ZN6S578C53v25Ev,
  (VTBL_ENTRY)&_ZN6S578C53v26Ev,
  (VTBL_ENTRY)&_ZN6S578C53v27Ev,
  (VTBL_ENTRY)&_ZN6S578C53v28Ev,
  (VTBL_ENTRY)&_ZN6S578C53v29Ev,
  (VTBL_ENTRY)&_ZN6S578C53v30Ev,
  (VTBL_ENTRY)&_ZN6S578C53v31Ev,
  (VTBL_ENTRY)&_ZN6S578C53v32Ev,
  (VTBL_ENTRY)&_ZN6S578C53v33Ev,
  (VTBL_ENTRY)&_ZN6S578C53v34Ev,
  (VTBL_ENTRY)&_ZN6S578C53v35Ev,
  (VTBL_ENTRY)&_ZN6S578C53v36Ev,
  (VTBL_ENTRY)&_ZN6S578C53v37Ev,
  (VTBL_ENTRY)&_ZN6S578C53v38Ev,
  (VTBL_ENTRY)&_ZN6S578C53v39Ev,
  (VTBL_ENTRY)&_ZN6S578C53v40Ev,
  (VTBL_ENTRY)&_ZN6S578C53v41Ev,
  (VTBL_ENTRY)&_ZN6S578C53v42Ev,
  (VTBL_ENTRY)&_ZN6S578C53v43Ev,
  (VTBL_ENTRY)&_ZN6S578C53v44Ev,
  (VTBL_ENTRY)&_ZN6S578C53v45Ev,
  (VTBL_ENTRY)&_ZN6S578C53v46Ev,
  (VTBL_ENTRY)&_ZN6S578C53v47Ev,
  (VTBL_ENTRY)&_ZN6S578C53v48Ev,
  (VTBL_ENTRY)&_ZN6S578C53v49Ev,
  (VTBL_ENTRY)&_ZN6S578C53v50Ev,
  (VTBL_ENTRY)&_ZN6S578C53v51Ev,
  (VTBL_ENTRY)&_ZN6S578C53v52Ev,
  (VTBL_ENTRY)&_ZN6S578C53v53Ev,
  (VTBL_ENTRY)&_ZN6S578C53v54Ev,
  (VTBL_ENTRY)&_ZN6S578C53v55Ev,
  (VTBL_ENTRY)&_ZN6S578C53v56Ev,
  (VTBL_ENTRY)&_ZN6S578C53v57Ev,
  (VTBL_ENTRY)&_ZN6S578C53v58Ev,
  (VTBL_ENTRY)&_ZN6S578C53v59Ev,
  (VTBL_ENTRY)&_ZN6S578C53v60Ev,
  (VTBL_ENTRY)&_ZN6S578C53v61Ev,
  (VTBL_ENTRY)&_ZN6S578C53v62Ev,
  (VTBL_ENTRY)&_ZN6S578C53v63Ev,
  (VTBL_ENTRY)&_ZN6S578C53v64Ev,
  (VTBL_ENTRY)&_ZN6S578C53v65Ev,
  (VTBL_ENTRY)&_ZN6S578C53v66Ev,
  (VTBL_ENTRY)&_ZN6S578C53v67Ev,
};
extern VTBL_ENTRY _ZTI6S578C5[];
extern  VTBL_ENTRY _ZTV6S578C5[];
Class_Descriptor cd_S578C5 = {  "S578C5", // class name
  0,0,//no base classes
  &(vtc_S578C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S578C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S578C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S578C9  : S1502C8_nt {
};
//SIG(-1 S578C9) C1{ BC2{ m Fp Fi[2]}}



static void Test_S578C9()
{
  extern Class_Descriptor cd_S578C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S578C9, buf);
    S578C9 &lv = *(new (buf) S578C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S578C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S578C9)");
    check_base_class_offset(lv, (S1502C8_nt*), 0, "S578C9");
    test_class_info(&lv, &cd_S578C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS578C9(Test_S578C9, "S578C9", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
static Base_Class bases_S578C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S578C9 = {  "S578C9", // class name
  bases_S578C9, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S578C8  : S578C9 {
};
//SIG(-1 S578C8) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S578C8()
{
  extern Class_Descriptor cd_S578C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S578C8, buf);
    S578C8 &lv = *(new (buf) S578C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S578C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S578C8)");
    check_base_class_offset(lv, (S1502C8_nt*)(S578C9*), 0, "S578C8");
    check_base_class_offset(lv, (S578C9*), 0, "S578C8");
    test_class_info(&lv, &cd_S578C8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS578C8(Test_S578C8, "S578C8", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
extern Class_Descriptor cd_S578C9;
static Base_Class bases_S578C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S578C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S578C8 = {  "S578C8", // class name
  bases_S578C8, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S578C7_nt  : S578C8 {
};
//SIG(-1 S578C7_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S578C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1502C8_nt;
extern Class_Descriptor cd_S578C9;
extern Class_Descriptor cd_S578C8;
static Base_Class bases_S578C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1502C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S578C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S578C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S578C11_nt  {
  void  mf578c11(); // _ZN10S578C11_nt8mf578c11Ev
};
//SIG(-1 S578C11_nt) C1{ m}


void  S578C11_nt ::mf578c11(){}

//skip512 S578C11_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S578C11_nt[];
VTBL_ENTRY *P__ZTI10S578C11_nt = _ZTI10S578C11_nt; 
Class_Descriptor cd_S578C11_nt = {  "S578C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S578C11_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S578C4_nt  : S578C5 {
  int s578c4f0[2];
  void *s578c4f1;
  int s578c4f2[2];
  ::S578C7_nt s578c4f3;
  ::S578C7_nt s578c4f4;
  ::S578C11_nt s578c4f5;
  ::S578C7_nt s578c4f6;
  unsigned int s578c4f7:1;
  unsigned int s578c4f8:1;
  unsigned int s578c4f9:1;
  unsigned int s578c4f10:1;
  unsigned int s578c4f11:1;
  int s578c4f12[2];
  virtual  ~S578C4_nt(); // _ZN9S578C4_ntD1Ev
  virtual void  v68(); // _ZN9S578C4_nt3v68Ev
  virtual void  v69(); // _ZN9S578C4_nt3v69Ev
  virtual void  v70(); // _ZN9S578C4_nt3v70Ev
  virtual void  v71(); // _ZN9S578C4_nt3v71Ev
  virtual void  v72(); // _ZN9S578C4_nt3v72Ev
  virtual void  v73(); // _ZN9S578C4_nt3v73Ev
  virtual void  v74(); // _ZN9S578C4_nt3v74Ev
  virtual void  v75(); // _ZN9S578C4_nt3v75Ev
  virtual void  v76(); // _ZN9S578C4_nt3v76Ev
  virtual void  v77(); // _ZN9S578C4_nt3v77Ev
  virtual void  v78(); // _ZN9S578C4_nt3v78Ev
  virtual void  v79(); // _ZN9S578C4_nt3v79Ev
  virtual void  v80(); // _ZN9S578C4_nt3v80Ev
  virtual void  v81(); // _ZN9S578C4_nt3v81Ev
  virtual void  v82(); // _ZN9S578C4_nt3v82Ev
  virtual void  v83(); // _ZN9S578C4_nt3v83Ev
  virtual void  v84(); // _ZN9S578C4_nt3v84Ev
  virtual void  v85(); // _ZN9S578C4_nt3v85Ev
  virtual void  v86(); // _ZN9S578C4_nt3v86Ev
  virtual void  v87(); // _ZN9S578C4_nt3v87Ev
  virtual void  v88(); // _ZN9S578C4_nt3v88Ev
  virtual void  v89(); // _ZN9S578C4_nt3v89Ev
  S578C4_nt(); // tgen
};
//SIG(-1 S578C4_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S578C4_nt ::~S578C4_nt(){ note_dtor("S578C4_nt", this);}
void  S578C4_nt ::v68(){vfunc_called(this, "_ZN9S578C4_nt3v68Ev");}
void  S578C4_nt ::v69(){vfunc_called(this, "_ZN9S578C4_nt3v69Ev");}
void  S578C4_nt ::v70(){vfunc_called(this, "_ZN9S578C4_nt3v70Ev");}
void  S578C4_nt ::v71(){vfunc_called(this, "_ZN9S578C4_nt3v71Ev");}
void  S578C4_nt ::v72(){vfunc_called(this, "_ZN9S578C4_nt3v72Ev");}
void  S578C4_nt ::v73(){vfunc_called(this, "_ZN9S578C4_nt3v73Ev");}
void  S578C4_nt ::v74(){vfunc_called(this, "_ZN9S578C4_nt3v74Ev");}
void  S578C4_nt ::v75(){vfunc_called(this, "_ZN9S578C4_nt3v75Ev");}
void  S578C4_nt ::v76(){vfunc_called(this, "_ZN9S578C4_nt3v76Ev");}
void  S578C4_nt ::v77(){vfunc_called(this, "_ZN9S578C4_nt3v77Ev");}
void  S578C4_nt ::v78(){vfunc_called(this, "_ZN9S578C4_nt3v78Ev");}
void  S578C4_nt ::v79(){vfunc_called(this, "_ZN9S578C4_nt3v79Ev");}
void  S578C4_nt ::v80(){vfunc_called(this, "_ZN9S578C4_nt3v80Ev");}
void  S578C4_nt ::v81(){vfunc_called(this, "_ZN9S578C4_nt3v81Ev");}
void  S578C4_nt ::v82(){vfunc_called(this, "_ZN9S578C4_nt3v82Ev");}
void  S578C4_nt ::v83(){vfunc_called(this, "_ZN9S578C4_nt3v83Ev");}
void  S578C4_nt ::v84(){vfunc_called(this, "_ZN9S578C4_nt3v84Ev");}
void  S578C4_nt ::v85(){vfunc_called(this, "_ZN9S578C4_nt3v85Ev");}
void  S578C4_nt ::v86(){vfunc_called(this, "_ZN9S578C4_nt3v86Ev");}
void  S578C4_nt ::v87(){vfunc_called(this, "_ZN9S578C4_nt3v87Ev");}
void  S578C4_nt ::v88(){vfunc_called(this, "_ZN9S578C4_nt3v88Ev");}
void  S578C4_nt ::v89(){vfunc_called(this, "_ZN9S578C4_nt3v89Ev");}
S578C4_nt ::S578C4_nt(){ note_ctor("S578C4_nt", this);} // tgen

//skip512 S578C4_nt

#else // __cplusplus

extern void _ZN9S578C4_ntC1Ev();
extern void _ZN9S578C4_ntD1Ev();
Name_Map name_map_S578C4_nt[] = {
  NSPAIR(_ZN9S578C4_ntC1Ev),
  NSPAIR(_ZN9S578C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S578C5;
extern VTBL_ENTRY _ZTI6S578C5[];
extern  VTBL_ENTRY _ZTV6S578C5[];
static Base_Class bases_S578C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S578C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S578C4_nt[];
extern void _ZN9S578C4_ntD1Ev();
extern void _ZN9S578C4_ntD0Ev();
extern void _ZN6S578C52v4Ev();
extern void _ZN6S578C52v5Ev();
extern void _ZN6S578C52v6Ev();
extern void _ZN6S578C52v7Ev();
extern void _ZN6S578C52v8Ev();
extern void _ZN6S578C52v9Ev();
extern void _ZN6S578C53v10Ev();
extern void _ZN6S578C53v11Ev();
extern void _ZN6S578C53v12Ev();
extern void _ZN6S578C53v13Ev();
extern void _ZN6S578C53v14Ev();
extern void _ZN6S578C53v15Ev();
extern void _ZN6S578C53v16Ev();
extern void _ZN6S578C53v17Ev();
extern void _ZN6S578C53v18Ev();
extern void _ZN6S578C53v19Ev();
extern void _ZN6S578C53v20Ev();
extern void _ZN6S578C53v21Ev();
extern void _ZN6S578C53v22Ev();
extern void _ZN6S578C53v23Ev();
extern void _ZN6S578C53v24Ev();
extern void _ZN6S578C53v25Ev();
extern void _ZN6S578C53v26Ev();
extern void _ZN6S578C53v27Ev();
extern void _ZN6S578C53v28Ev();
extern void _ZN6S578C53v29Ev();
extern void _ZN6S578C53v30Ev();
extern void _ZN6S578C53v31Ev();
extern void _ZN6S578C53v32Ev();
extern void _ZN6S578C53v33Ev();
extern void _ZN6S578C53v34Ev();
extern void _ZN6S578C53v35Ev();
extern void _ZN6S578C53v36Ev();
extern void _ZN6S578C53v37Ev();
extern void _ZN6S578C53v38Ev();
extern void _ZN6S578C53v39Ev();
extern void _ZN6S578C53v40Ev();
extern void _ZN6S578C53v41Ev();
extern void _ZN6S578C53v42Ev();
extern void _ZN6S578C53v43Ev();
extern void _ZN6S578C53v44Ev();
extern void _ZN6S578C53v45Ev();
extern void _ZN6S578C53v46Ev();
extern void _ZN6S578C53v47Ev();
extern void _ZN6S578C53v48Ev();
extern void _ZN6S578C53v49Ev();
extern void _ZN6S578C53v50Ev();
extern void _ZN6S578C53v51Ev();
extern void _ZN6S578C53v52Ev();
extern void _ZN6S578C53v53Ev();
extern void _ZN6S578C53v54Ev();
extern void _ZN6S578C53v55Ev();
extern void _ZN6S578C53v56Ev();
extern void _ZN6S578C53v57Ev();
extern void _ZN6S578C53v58Ev();
extern void _ZN6S578C53v59Ev();
extern void _ZN6S578C53v60Ev();
extern void _ZN6S578C53v61Ev();
extern void _ZN6S578C53v62Ev();
extern void _ZN6S578C53v63Ev();
extern void _ZN6S578C53v64Ev();
extern void _ZN6S578C53v65Ev();
extern void _ZN6S578C53v66Ev();
extern void _ZN6S578C53v67Ev();
extern void _ZN9S578C4_nt3v68Ev();
extern void _ZN9S578C4_nt3v69Ev();
extern void _ZN9S578C4_nt3v70Ev();
extern void _ZN9S578C4_nt3v71Ev();
extern void _ZN9S578C4_nt3v72Ev();
extern void _ZN9S578C4_nt3v73Ev();
extern void _ZN9S578C4_nt3v74Ev();
extern void _ZN9S578C4_nt3v75Ev();
extern void _ZN9S578C4_nt3v76Ev();
extern void _ZN9S578C4_nt3v77Ev();
extern void _ZN9S578C4_nt3v78Ev();
extern void _ZN9S578C4_nt3v79Ev();
extern void _ZN9S578C4_nt3v80Ev();
extern void _ZN9S578C4_nt3v81Ev();
extern void _ZN9S578C4_nt3v82Ev();
extern void _ZN9S578C4_nt3v83Ev();
extern void _ZN9S578C4_nt3v84Ev();
extern void _ZN9S578C4_nt3v85Ev();
extern void _ZN9S578C4_nt3v86Ev();
extern void _ZN9S578C4_nt3v87Ev();
extern void _ZN9S578C4_nt3v88Ev();
extern void _ZN9S578C4_nt3v89Ev();
static  VTBL_ENTRY vtc_S578C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S578C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S578C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S578C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S578C52v4Ev,
  (VTBL_ENTRY)&_ZN6S578C52v5Ev,
  (VTBL_ENTRY)&_ZN6S578C52v6Ev,
  (VTBL_ENTRY)&_ZN6S578C52v7Ev,
  (VTBL_ENTRY)&_ZN6S578C52v8Ev,
  (VTBL_ENTRY)&_ZN6S578C52v9Ev,
  (VTBL_ENTRY)&_ZN6S578C53v10Ev,
  (VTBL_ENTRY)&_ZN6S578C53v11Ev,
  (VTBL_ENTRY)&_ZN6S578C53v12Ev,
  (VTBL_ENTRY)&_ZN6S578C53v13Ev,
  (VTBL_ENTRY)&_ZN6S578C53v14Ev,
  (VTBL_ENTRY)&_ZN6S578C53v15Ev,
  (VTBL_ENTRY)&_ZN6S578C53v16Ev,
  (VTBL_ENTRY)&_ZN6S578C53v17Ev,
  (VTBL_ENTRY)&_ZN6S578C53v18Ev,
  (VTBL_ENTRY)&_ZN6S578C53v19Ev,
  (VTBL_ENTRY)&_ZN6S578C53v20Ev,
  (VTBL_ENTRY)&_ZN6S578C53v21Ev,
  (VTBL_ENTRY)&_ZN6S578C53v22Ev,
  (VTBL_ENTRY)&_ZN6S578C53v23Ev,
  (VTBL_ENTRY)&_ZN6S578C53v24Ev,
  (VTBL_ENTRY)&_ZN6S578C53v25Ev,
  (VTBL_ENTRY)&_ZN6S578C53v26Ev,
  (VTBL_ENTRY)&_ZN6S578C53v27Ev,
  (VTBL_ENTRY)&_ZN6S578C53v28Ev,
  (VTBL_ENTRY)&_ZN6S578C53v29Ev,
  (VTBL_ENTRY)&_ZN6S578C53v30Ev,
  (VTBL_ENTRY)&_ZN6S578C53v31Ev,
  (VTBL_ENTRY)&_ZN6S578C53v32Ev,
  (VTBL_ENTRY)&_ZN6S578C53v33Ev,
  (VTBL_ENTRY)&_ZN6S578C53v34Ev,
  (VTBL_ENTRY)&_ZN6S578C53v35Ev,
  (VTBL_ENTRY)&_ZN6S578C53v36Ev,
  (VTBL_ENTRY)&_ZN6S578C53v37Ev,
  (VTBL_ENTRY)&_ZN6S578C53v38Ev,
  (VTBL_ENTRY)&_ZN6S578C53v39Ev,
  (VTBL_ENTRY)&_ZN6S578C53v40Ev,
  (VTBL_ENTRY)&_ZN6S578C53v41Ev,
  (VTBL_ENTRY)&_ZN6S578C53v42Ev,
  (VTBL_ENTRY)&_ZN6S578C53v43Ev,
  (VTBL_ENTRY)&_ZN6S578C53v44Ev,
  (VTBL_ENTRY)&_ZN6S578C53v45Ev,
  (VTBL_ENTRY)&_ZN6S578C53v46Ev,
  (VTBL_ENTRY)&_ZN6S578C53v47Ev,
  (VTBL_ENTRY)&_ZN6S578C53v48Ev,
  (VTBL_ENTRY)&_ZN6S578C53v49Ev,
  (VTBL_ENTRY)&_ZN6S578C53v50Ev,
  (VTBL_ENTRY)&_ZN6S578C53v51Ev,
  (VTBL_ENTRY)&_ZN6S578C53v52Ev,
  (VTBL_ENTRY)&_ZN6S578C53v53Ev,
  (VTBL_ENTRY)&_ZN6S578C53v54Ev,
  (VTBL_ENTRY)&_ZN6S578C53v55Ev,
  (VTBL_ENTRY)&_ZN6S578C53v56Ev,
  (VTBL_ENTRY)&_ZN6S578C53v57Ev,
  (VTBL_ENTRY)&_ZN6S578C53v58Ev,
  (VTBL_ENTRY)&_ZN6S578C53v59Ev,
  (VTBL_ENTRY)&_ZN6S578C53v60Ev,
  (VTBL_ENTRY)&_ZN6S578C53v61Ev,
  (VTBL_ENTRY)&_ZN6S578C53v62Ev,
  (VTBL_ENTRY)&_ZN6S578C53v63Ev,
  (VTBL_ENTRY)&_ZN6S578C53v64Ev,
  (VTBL_ENTRY)&_ZN6S578C53v65Ev,
  (VTBL_ENTRY)&_ZN6S578C53v66Ev,
  (VTBL_ENTRY)&_ZN6S578C53v67Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v89Ev,
};
extern VTBL_ENTRY _ZTI9S578C4_nt[];
VTBL_ENTRY *P__ZTI9S578C4_nt = _ZTI9S578C4_nt; 
extern  VTBL_ENTRY _ZTV9S578C4_nt[];
Class_Descriptor cd_S578C4_nt = {  "S578C4_nt", // class name
  bases_S578C4_nt, 1,
  &(vtc_S578C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S578C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S578C4_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S578C3_nt  : S578C4_nt {
  unsigned int s578c3f0:1;
  unsigned int s578c3f1:1;
  unsigned int s578c3f2:1;
  ::S1502C28 s578c3f3;
  ::S1502C24 s578c3f4;
  ::S1502C18 s578c3f5;
  ::S1502C12 s578c3f6;
  int s578c3f7[3];
  virtual  ~S578C3_nt(); // _ZN9S578C3_ntD1Ev
  virtual void  v90(); // _ZN9S578C3_nt3v90Ev
  virtual void  v91(); // _ZN9S578C3_nt3v91Ev
  virtual void  v92(); // _ZN9S578C3_nt3v92Ev
  virtual void  v93(); // _ZN9S578C3_nt3v93Ev
  virtual void  v94(); // _ZN9S578C3_nt3v94Ev
  virtual void  v95(); // _ZN9S578C3_nt3v95Ev
  virtual void  v96(); // _ZN9S578C3_nt3v96Ev
  virtual void  v97(); // _ZN9S578C3_nt3v97Ev
  virtual void  v98(); // _ZN9S578C3_nt3v98Ev
  virtual void  v99(); // _ZN9S578C3_nt3v99Ev
  virtual void  v100(); // _ZN9S578C3_nt4v100Ev
  virtual void  v101(); // _ZN9S578C3_nt4v101Ev
  virtual void  v102(); // _ZN9S578C3_nt4v102Ev
  virtual void  v103(); // _ZN9S578C3_nt4v103Ev
  virtual void  v104(); // _ZN9S578C3_nt4v104Ev
  virtual void  v105(); // _ZN9S578C3_nt4v105Ev
  virtual void  v106(); // _ZN9S578C3_nt4v106Ev
  virtual void  v107(); // _ZN9S578C3_nt4v107Ev
  virtual void  v108(); // _ZN9S578C3_nt4v108Ev
  virtual void  v109(); // _ZN9S578C3_nt4v109Ev
  S578C3_nt(); // tgen
};
//SIG(-1 S578C3_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S578C3_nt ::~S578C3_nt(){ note_dtor("S578C3_nt", this);}
void  S578C3_nt ::v90(){vfunc_called(this, "_ZN9S578C3_nt3v90Ev");}
void  S578C3_nt ::v91(){vfunc_called(this, "_ZN9S578C3_nt3v91Ev");}
void  S578C3_nt ::v92(){vfunc_called(this, "_ZN9S578C3_nt3v92Ev");}
void  S578C3_nt ::v93(){vfunc_called(this, "_ZN9S578C3_nt3v93Ev");}
void  S578C3_nt ::v94(){vfunc_called(this, "_ZN9S578C3_nt3v94Ev");}
void  S578C3_nt ::v95(){vfunc_called(this, "_ZN9S578C3_nt3v95Ev");}
void  S578C3_nt ::v96(){vfunc_called(this, "_ZN9S578C3_nt3v96Ev");}
void  S578C3_nt ::v97(){vfunc_called(this, "_ZN9S578C3_nt3v97Ev");}
void  S578C3_nt ::v98(){vfunc_called(this, "_ZN9S578C3_nt3v98Ev");}
void  S578C3_nt ::v99(){vfunc_called(this, "_ZN9S578C3_nt3v99Ev");}
void  S578C3_nt ::v100(){vfunc_called(this, "_ZN9S578C3_nt4v100Ev");}
void  S578C3_nt ::v101(){vfunc_called(this, "_ZN9S578C3_nt4v101Ev");}
void  S578C3_nt ::v102(){vfunc_called(this, "_ZN9S578C3_nt4v102Ev");}
void  S578C3_nt ::v103(){vfunc_called(this, "_ZN9S578C3_nt4v103Ev");}
void  S578C3_nt ::v104(){vfunc_called(this, "_ZN9S578C3_nt4v104Ev");}
void  S578C3_nt ::v105(){vfunc_called(this, "_ZN9S578C3_nt4v105Ev");}
void  S578C3_nt ::v106(){vfunc_called(this, "_ZN9S578C3_nt4v106Ev");}
void  S578C3_nt ::v107(){vfunc_called(this, "_ZN9S578C3_nt4v107Ev");}
void  S578C3_nt ::v108(){vfunc_called(this, "_ZN9S578C3_nt4v108Ev");}
void  S578C3_nt ::v109(){vfunc_called(this, "_ZN9S578C3_nt4v109Ev");}
S578C3_nt ::S578C3_nt(){ note_ctor("S578C3_nt", this);} // tgen

//skip512 S578C3_nt

#else // __cplusplus

extern void _ZN9S578C3_ntC1Ev();
extern void _ZN9S578C3_ntD1Ev();
Name_Map name_map_S578C3_nt[] = {
  NSPAIR(_ZN9S578C3_ntC1Ev),
  NSPAIR(_ZN9S578C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S578C5;
extern VTBL_ENTRY _ZTI6S578C5[];
extern  VTBL_ENTRY _ZTV6S578C5[];
extern Class_Descriptor cd_S578C4_nt;
extern VTBL_ENTRY _ZTI9S578C4_nt[];
extern  VTBL_ENTRY _ZTV9S578C4_nt[];
static Base_Class bases_S578C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S578C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S578C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S578C3_nt[];
extern void _ZN9S578C3_ntD1Ev();
extern void _ZN9S578C3_ntD0Ev();
extern void _ZN6S578C52v4Ev();
extern void _ZN6S578C52v5Ev();
extern void _ZN6S578C52v6Ev();
extern void _ZN6S578C52v7Ev();
extern void _ZN6S578C52v8Ev();
extern void _ZN6S578C52v9Ev();
extern void _ZN6S578C53v10Ev();
extern void _ZN6S578C53v11Ev();
extern void _ZN6S578C53v12Ev();
extern void _ZN6S578C53v13Ev();
extern void _ZN6S578C53v14Ev();
extern void _ZN6S578C53v15Ev();
extern void _ZN6S578C53v16Ev();
extern void _ZN6S578C53v17Ev();
extern void _ZN6S578C53v18Ev();
extern void _ZN6S578C53v19Ev();
extern void _ZN6S578C53v20Ev();
extern void _ZN6S578C53v21Ev();
extern void _ZN6S578C53v22Ev();
extern void _ZN6S578C53v23Ev();
extern void _ZN6S578C53v24Ev();
extern void _ZN6S578C53v25Ev();
extern void _ZN6S578C53v26Ev();
extern void _ZN6S578C53v27Ev();
extern void _ZN6S578C53v28Ev();
extern void _ZN6S578C53v29Ev();
extern void _ZN6S578C53v30Ev();
extern void _ZN6S578C53v31Ev();
extern void _ZN6S578C53v32Ev();
extern void _ZN6S578C53v33Ev();
extern void _ZN6S578C53v34Ev();
extern void _ZN6S578C53v35Ev();
extern void _ZN6S578C53v36Ev();
extern void _ZN6S578C53v37Ev();
extern void _ZN6S578C53v38Ev();
extern void _ZN6S578C53v39Ev();
extern void _ZN6S578C53v40Ev();
extern void _ZN6S578C53v41Ev();
extern void _ZN6S578C53v42Ev();
extern void _ZN6S578C53v43Ev();
extern void _ZN6S578C53v44Ev();
extern void _ZN6S578C53v45Ev();
extern void _ZN6S578C53v46Ev();
extern void _ZN6S578C53v47Ev();
extern void _ZN6S578C53v48Ev();
extern void _ZN6S578C53v49Ev();
extern void _ZN6S578C53v50Ev();
extern void _ZN6S578C53v51Ev();
extern void _ZN6S578C53v52Ev();
extern void _ZN6S578C53v53Ev();
extern void _ZN6S578C53v54Ev();
extern void _ZN6S578C53v55Ev();
extern void _ZN6S578C53v56Ev();
extern void _ZN6S578C53v57Ev();
extern void _ZN6S578C53v58Ev();
extern void _ZN6S578C53v59Ev();
extern void _ZN6S578C53v60Ev();
extern void _ZN6S578C53v61Ev();
extern void _ZN6S578C53v62Ev();
extern void _ZN6S578C53v63Ev();
extern void _ZN6S578C53v64Ev();
extern void _ZN6S578C53v65Ev();
extern void _ZN6S578C53v66Ev();
extern void _ZN6S578C53v67Ev();
extern void _ZN9S578C4_nt3v68Ev();
extern void _ZN9S578C4_nt3v69Ev();
extern void _ZN9S578C4_nt3v70Ev();
extern void _ZN9S578C4_nt3v71Ev();
extern void _ZN9S578C4_nt3v72Ev();
extern void _ZN9S578C4_nt3v73Ev();
extern void _ZN9S578C4_nt3v74Ev();
extern void _ZN9S578C4_nt3v75Ev();
extern void _ZN9S578C4_nt3v76Ev();
extern void _ZN9S578C4_nt3v77Ev();
extern void _ZN9S578C4_nt3v78Ev();
extern void _ZN9S578C4_nt3v79Ev();
extern void _ZN9S578C4_nt3v80Ev();
extern void _ZN9S578C4_nt3v81Ev();
extern void _ZN9S578C4_nt3v82Ev();
extern void _ZN9S578C4_nt3v83Ev();
extern void _ZN9S578C4_nt3v84Ev();
extern void _ZN9S578C4_nt3v85Ev();
extern void _ZN9S578C4_nt3v86Ev();
extern void _ZN9S578C4_nt3v87Ev();
extern void _ZN9S578C4_nt3v88Ev();
extern void _ZN9S578C4_nt3v89Ev();
extern void _ZN9S578C3_nt3v90Ev();
extern void _ZN9S578C3_nt3v91Ev();
extern void _ZN9S578C3_nt3v92Ev();
extern void _ZN9S578C3_nt3v93Ev();
extern void _ZN9S578C3_nt3v94Ev();
extern void _ZN9S578C3_nt3v95Ev();
extern void _ZN9S578C3_nt3v96Ev();
extern void _ZN9S578C3_nt3v97Ev();
extern void _ZN9S578C3_nt3v98Ev();
extern void _ZN9S578C3_nt3v99Ev();
extern void _ZN9S578C3_nt4v100Ev();
extern void _ZN9S578C3_nt4v101Ev();
extern void _ZN9S578C3_nt4v102Ev();
extern void _ZN9S578C3_nt4v103Ev();
extern void _ZN9S578C3_nt4v104Ev();
extern void _ZN9S578C3_nt4v105Ev();
extern void _ZN9S578C3_nt4v106Ev();
extern void _ZN9S578C3_nt4v107Ev();
extern void _ZN9S578C3_nt4v108Ev();
extern void _ZN9S578C3_nt4v109Ev();
static  VTBL_ENTRY vtc_S578C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S578C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S578C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S578C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S578C52v4Ev,
  (VTBL_ENTRY)&_ZN6S578C52v5Ev,
  (VTBL_ENTRY)&_ZN6S578C52v6Ev,
  (VTBL_ENTRY)&_ZN6S578C52v7Ev,
  (VTBL_ENTRY)&_ZN6S578C52v8Ev,
  (VTBL_ENTRY)&_ZN6S578C52v9Ev,
  (VTBL_ENTRY)&_ZN6S578C53v10Ev,
  (VTBL_ENTRY)&_ZN6S578C53v11Ev,
  (VTBL_ENTRY)&_ZN6S578C53v12Ev,
  (VTBL_ENTRY)&_ZN6S578C53v13Ev,
  (VTBL_ENTRY)&_ZN6S578C53v14Ev,
  (VTBL_ENTRY)&_ZN6S578C53v15Ev,
  (VTBL_ENTRY)&_ZN6S578C53v16Ev,
  (VTBL_ENTRY)&_ZN6S578C53v17Ev,
  (VTBL_ENTRY)&_ZN6S578C53v18Ev,
  (VTBL_ENTRY)&_ZN6S578C53v19Ev,
  (VTBL_ENTRY)&_ZN6S578C53v20Ev,
  (VTBL_ENTRY)&_ZN6S578C53v21Ev,
  (VTBL_ENTRY)&_ZN6S578C53v22Ev,
  (VTBL_ENTRY)&_ZN6S578C53v23Ev,
  (VTBL_ENTRY)&_ZN6S578C53v24Ev,
  (VTBL_ENTRY)&_ZN6S578C53v25Ev,
  (VTBL_ENTRY)&_ZN6S578C53v26Ev,
  (VTBL_ENTRY)&_ZN6S578C53v27Ev,
  (VTBL_ENTRY)&_ZN6S578C53v28Ev,
  (VTBL_ENTRY)&_ZN6S578C53v29Ev,
  (VTBL_ENTRY)&_ZN6S578C53v30Ev,
  (VTBL_ENTRY)&_ZN6S578C53v31Ev,
  (VTBL_ENTRY)&_ZN6S578C53v32Ev,
  (VTBL_ENTRY)&_ZN6S578C53v33Ev,
  (VTBL_ENTRY)&_ZN6S578C53v34Ev,
  (VTBL_ENTRY)&_ZN6S578C53v35Ev,
  (VTBL_ENTRY)&_ZN6S578C53v36Ev,
  (VTBL_ENTRY)&_ZN6S578C53v37Ev,
  (VTBL_ENTRY)&_ZN6S578C53v38Ev,
  (VTBL_ENTRY)&_ZN6S578C53v39Ev,
  (VTBL_ENTRY)&_ZN6S578C53v40Ev,
  (VTBL_ENTRY)&_ZN6S578C53v41Ev,
  (VTBL_ENTRY)&_ZN6S578C53v42Ev,
  (VTBL_ENTRY)&_ZN6S578C53v43Ev,
  (VTBL_ENTRY)&_ZN6S578C53v44Ev,
  (VTBL_ENTRY)&_ZN6S578C53v45Ev,
  (VTBL_ENTRY)&_ZN6S578C53v46Ev,
  (VTBL_ENTRY)&_ZN6S578C53v47Ev,
  (VTBL_ENTRY)&_ZN6S578C53v48Ev,
  (VTBL_ENTRY)&_ZN6S578C53v49Ev,
  (VTBL_ENTRY)&_ZN6S578C53v50Ev,
  (VTBL_ENTRY)&_ZN6S578C53v51Ev,
  (VTBL_ENTRY)&_ZN6S578C53v52Ev,
  (VTBL_ENTRY)&_ZN6S578C53v53Ev,
  (VTBL_ENTRY)&_ZN6S578C53v54Ev,
  (VTBL_ENTRY)&_ZN6S578C53v55Ev,
  (VTBL_ENTRY)&_ZN6S578C53v56Ev,
  (VTBL_ENTRY)&_ZN6S578C53v57Ev,
  (VTBL_ENTRY)&_ZN6S578C53v58Ev,
  (VTBL_ENTRY)&_ZN6S578C53v59Ev,
  (VTBL_ENTRY)&_ZN6S578C53v60Ev,
  (VTBL_ENTRY)&_ZN6S578C53v61Ev,
  (VTBL_ENTRY)&_ZN6S578C53v62Ev,
  (VTBL_ENTRY)&_ZN6S578C53v63Ev,
  (VTBL_ENTRY)&_ZN6S578C53v64Ev,
  (VTBL_ENTRY)&_ZN6S578C53v65Ev,
  (VTBL_ENTRY)&_ZN6S578C53v66Ev,
  (VTBL_ENTRY)&_ZN6S578C53v67Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v109Ev,
};
extern VTBL_ENTRY _ZTI9S578C3_nt[];
VTBL_ENTRY *P__ZTI9S578C3_nt = _ZTI9S578C3_nt; 
extern  VTBL_ENTRY _ZTV9S578C3_nt[];
Class_Descriptor cd_S578C3_nt = {  "S578C3_nt", // class name
  bases_S578C3_nt, 2,
  &(vtc_S578C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S578C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S578C3_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S578C2_nt  : S578C3_nt {
  ::S1502C5_nt s578c2f0;
  unsigned int s578c2f1:1;
  ::S1502C6_nt s578c2f2;
  virtual  ~S578C2_nt(); // _ZN9S578C2_ntD1Ev
  virtual void  v110(); // _ZN9S578C2_nt4v110Ev
  virtual void  v111(); // _ZN9S578C2_nt4v111Ev
  virtual void  v112(); // _ZN9S578C2_nt4v112Ev
  virtual void  v113(); // _ZN9S578C2_nt4v113Ev
  S578C2_nt(); // tgen
};
//SIG(-1 S578C2_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S578C2_nt ::~S578C2_nt(){ note_dtor("S578C2_nt", this);}
void  S578C2_nt ::v110(){vfunc_called(this, "_ZN9S578C2_nt4v110Ev");}
void  S578C2_nt ::v111(){vfunc_called(this, "_ZN9S578C2_nt4v111Ev");}
void  S578C2_nt ::v112(){vfunc_called(this, "_ZN9S578C2_nt4v112Ev");}
void  S578C2_nt ::v113(){vfunc_called(this, "_ZN9S578C2_nt4v113Ev");}
S578C2_nt ::S578C2_nt(){ note_ctor("S578C2_nt", this);} // tgen

//skip512 S578C2_nt

#else // __cplusplus

extern void _ZN9S578C2_ntC1Ev();
extern void _ZN9S578C2_ntD1Ev();
Name_Map name_map_S578C2_nt[] = {
  NSPAIR(_ZN9S578C2_ntC1Ev),
  NSPAIR(_ZN9S578C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S578C5;
extern VTBL_ENTRY _ZTI6S578C5[];
extern  VTBL_ENTRY _ZTV6S578C5[];
extern Class_Descriptor cd_S578C4_nt;
extern VTBL_ENTRY _ZTI9S578C4_nt[];
extern  VTBL_ENTRY _ZTV9S578C4_nt[];
extern Class_Descriptor cd_S578C3_nt;
extern VTBL_ENTRY _ZTI9S578C3_nt[];
extern  VTBL_ENTRY _ZTV9S578C3_nt[];
static Base_Class bases_S578C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S578C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S578C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S578C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S578C2_nt[];
extern void _ZN9S578C2_ntD1Ev();
extern void _ZN9S578C2_ntD0Ev();
extern void _ZN6S578C52v4Ev();
extern void _ZN6S578C52v5Ev();
extern void _ZN6S578C52v6Ev();
extern void _ZN6S578C52v7Ev();
extern void _ZN6S578C52v8Ev();
extern void _ZN6S578C52v9Ev();
extern void _ZN6S578C53v10Ev();
extern void _ZN6S578C53v11Ev();
extern void _ZN6S578C53v12Ev();
extern void _ZN6S578C53v13Ev();
extern void _ZN6S578C53v14Ev();
extern void _ZN6S578C53v15Ev();
extern void _ZN6S578C53v16Ev();
extern void _ZN6S578C53v17Ev();
extern void _ZN6S578C53v18Ev();
extern void _ZN6S578C53v19Ev();
extern void _ZN6S578C53v20Ev();
extern void _ZN6S578C53v21Ev();
extern void _ZN6S578C53v22Ev();
extern void _ZN6S578C53v23Ev();
extern void _ZN6S578C53v24Ev();
extern void _ZN6S578C53v25Ev();
extern void _ZN6S578C53v26Ev();
extern void _ZN6S578C53v27Ev();
extern void _ZN6S578C53v28Ev();
extern void _ZN6S578C53v29Ev();
extern void _ZN6S578C53v30Ev();
extern void _ZN6S578C53v31Ev();
extern void _ZN6S578C53v32Ev();
extern void _ZN6S578C53v33Ev();
extern void _ZN6S578C53v34Ev();
extern void _ZN6S578C53v35Ev();
extern void _ZN6S578C53v36Ev();
extern void _ZN6S578C53v37Ev();
extern void _ZN6S578C53v38Ev();
extern void _ZN6S578C53v39Ev();
extern void _ZN6S578C53v40Ev();
extern void _ZN6S578C53v41Ev();
extern void _ZN6S578C53v42Ev();
extern void _ZN6S578C53v43Ev();
extern void _ZN6S578C53v44Ev();
extern void _ZN6S578C53v45Ev();
extern void _ZN6S578C53v46Ev();
extern void _ZN6S578C53v47Ev();
extern void _ZN6S578C53v48Ev();
extern void _ZN6S578C53v49Ev();
extern void _ZN6S578C53v50Ev();
extern void _ZN6S578C53v51Ev();
extern void _ZN6S578C53v52Ev();
extern void _ZN6S578C53v53Ev();
extern void _ZN6S578C53v54Ev();
extern void _ZN6S578C53v55Ev();
extern void _ZN6S578C53v56Ev();
extern void _ZN6S578C53v57Ev();
extern void _ZN6S578C53v58Ev();
extern void _ZN6S578C53v59Ev();
extern void _ZN6S578C53v60Ev();
extern void _ZN6S578C53v61Ev();
extern void _ZN6S578C53v62Ev();
extern void _ZN6S578C53v63Ev();
extern void _ZN6S578C53v64Ev();
extern void _ZN6S578C53v65Ev();
extern void _ZN6S578C53v66Ev();
extern void _ZN6S578C53v67Ev();
extern void _ZN9S578C4_nt3v68Ev();
extern void _ZN9S578C4_nt3v69Ev();
extern void _ZN9S578C4_nt3v70Ev();
extern void _ZN9S578C4_nt3v71Ev();
extern void _ZN9S578C4_nt3v72Ev();
extern void _ZN9S578C4_nt3v73Ev();
extern void _ZN9S578C4_nt3v74Ev();
extern void _ZN9S578C4_nt3v75Ev();
extern void _ZN9S578C4_nt3v76Ev();
extern void _ZN9S578C4_nt3v77Ev();
extern void _ZN9S578C4_nt3v78Ev();
extern void _ZN9S578C4_nt3v79Ev();
extern void _ZN9S578C4_nt3v80Ev();
extern void _ZN9S578C4_nt3v81Ev();
extern void _ZN9S578C4_nt3v82Ev();
extern void _ZN9S578C4_nt3v83Ev();
extern void _ZN9S578C4_nt3v84Ev();
extern void _ZN9S578C4_nt3v85Ev();
extern void _ZN9S578C4_nt3v86Ev();
extern void _ZN9S578C4_nt3v87Ev();
extern void _ZN9S578C4_nt3v88Ev();
extern void _ZN9S578C4_nt3v89Ev();
extern void _ZN9S578C3_nt3v90Ev();
extern void _ZN9S578C3_nt3v91Ev();
extern void _ZN9S578C3_nt3v92Ev();
extern void _ZN9S578C3_nt3v93Ev();
extern void _ZN9S578C3_nt3v94Ev();
extern void _ZN9S578C3_nt3v95Ev();
extern void _ZN9S578C3_nt3v96Ev();
extern void _ZN9S578C3_nt3v97Ev();
extern void _ZN9S578C3_nt3v98Ev();
extern void _ZN9S578C3_nt3v99Ev();
extern void _ZN9S578C3_nt4v100Ev();
extern void _ZN9S578C3_nt4v101Ev();
extern void _ZN9S578C3_nt4v102Ev();
extern void _ZN9S578C3_nt4v103Ev();
extern void _ZN9S578C3_nt4v104Ev();
extern void _ZN9S578C3_nt4v105Ev();
extern void _ZN9S578C3_nt4v106Ev();
extern void _ZN9S578C3_nt4v107Ev();
extern void _ZN9S578C3_nt4v108Ev();
extern void _ZN9S578C3_nt4v109Ev();
extern void _ZN9S578C2_nt4v110Ev();
extern void _ZN9S578C2_nt4v111Ev();
extern void _ZN9S578C2_nt4v112Ev();
extern void _ZN9S578C2_nt4v113Ev();
static  VTBL_ENTRY vtc_S578C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S578C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S578C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S578C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S578C52v4Ev,
  (VTBL_ENTRY)&_ZN6S578C52v5Ev,
  (VTBL_ENTRY)&_ZN6S578C52v6Ev,
  (VTBL_ENTRY)&_ZN6S578C52v7Ev,
  (VTBL_ENTRY)&_ZN6S578C52v8Ev,
  (VTBL_ENTRY)&_ZN6S578C52v9Ev,
  (VTBL_ENTRY)&_ZN6S578C53v10Ev,
  (VTBL_ENTRY)&_ZN6S578C53v11Ev,
  (VTBL_ENTRY)&_ZN6S578C53v12Ev,
  (VTBL_ENTRY)&_ZN6S578C53v13Ev,
  (VTBL_ENTRY)&_ZN6S578C53v14Ev,
  (VTBL_ENTRY)&_ZN6S578C53v15Ev,
  (VTBL_ENTRY)&_ZN6S578C53v16Ev,
  (VTBL_ENTRY)&_ZN6S578C53v17Ev,
  (VTBL_ENTRY)&_ZN6S578C53v18Ev,
  (VTBL_ENTRY)&_ZN6S578C53v19Ev,
  (VTBL_ENTRY)&_ZN6S578C53v20Ev,
  (VTBL_ENTRY)&_ZN6S578C53v21Ev,
  (VTBL_ENTRY)&_ZN6S578C53v22Ev,
  (VTBL_ENTRY)&_ZN6S578C53v23Ev,
  (VTBL_ENTRY)&_ZN6S578C53v24Ev,
  (VTBL_ENTRY)&_ZN6S578C53v25Ev,
  (VTBL_ENTRY)&_ZN6S578C53v26Ev,
  (VTBL_ENTRY)&_ZN6S578C53v27Ev,
  (VTBL_ENTRY)&_ZN6S578C53v28Ev,
  (VTBL_ENTRY)&_ZN6S578C53v29Ev,
  (VTBL_ENTRY)&_ZN6S578C53v30Ev,
  (VTBL_ENTRY)&_ZN6S578C53v31Ev,
  (VTBL_ENTRY)&_ZN6S578C53v32Ev,
  (VTBL_ENTRY)&_ZN6S578C53v33Ev,
  (VTBL_ENTRY)&_ZN6S578C53v34Ev,
  (VTBL_ENTRY)&_ZN6S578C53v35Ev,
  (VTBL_ENTRY)&_ZN6S578C53v36Ev,
  (VTBL_ENTRY)&_ZN6S578C53v37Ev,
  (VTBL_ENTRY)&_ZN6S578C53v38Ev,
  (VTBL_ENTRY)&_ZN6S578C53v39Ev,
  (VTBL_ENTRY)&_ZN6S578C53v40Ev,
  (VTBL_ENTRY)&_ZN6S578C53v41Ev,
  (VTBL_ENTRY)&_ZN6S578C53v42Ev,
  (VTBL_ENTRY)&_ZN6S578C53v43Ev,
  (VTBL_ENTRY)&_ZN6S578C53v44Ev,
  (VTBL_ENTRY)&_ZN6S578C53v45Ev,
  (VTBL_ENTRY)&_ZN6S578C53v46Ev,
  (VTBL_ENTRY)&_ZN6S578C53v47Ev,
  (VTBL_ENTRY)&_ZN6S578C53v48Ev,
  (VTBL_ENTRY)&_ZN6S578C53v49Ev,
  (VTBL_ENTRY)&_ZN6S578C53v50Ev,
  (VTBL_ENTRY)&_ZN6S578C53v51Ev,
  (VTBL_ENTRY)&_ZN6S578C53v52Ev,
  (VTBL_ENTRY)&_ZN6S578C53v53Ev,
  (VTBL_ENTRY)&_ZN6S578C53v54Ev,
  (VTBL_ENTRY)&_ZN6S578C53v55Ev,
  (VTBL_ENTRY)&_ZN6S578C53v56Ev,
  (VTBL_ENTRY)&_ZN6S578C53v57Ev,
  (VTBL_ENTRY)&_ZN6S578C53v58Ev,
  (VTBL_ENTRY)&_ZN6S578C53v59Ev,
  (VTBL_ENTRY)&_ZN6S578C53v60Ev,
  (VTBL_ENTRY)&_ZN6S578C53v61Ev,
  (VTBL_ENTRY)&_ZN6S578C53v62Ev,
  (VTBL_ENTRY)&_ZN6S578C53v63Ev,
  (VTBL_ENTRY)&_ZN6S578C53v64Ev,
  (VTBL_ENTRY)&_ZN6S578C53v65Ev,
  (VTBL_ENTRY)&_ZN6S578C53v66Ev,
  (VTBL_ENTRY)&_ZN6S578C53v67Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S578C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S578C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S578C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S578C2_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI9S578C2_nt[];
VTBL_ENTRY *P__ZTI9S578C2_nt = _ZTI9S578C2_nt; 
extern  VTBL_ENTRY _ZTV9S578C2_nt[];
Class_Descriptor cd_S578C2_nt = {  "S578C2_nt", // class name
  bases_S578C2_nt, 3,
  &(vtc_S578C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S578C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S578C2_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S578C1  : S578C2_nt {
  unsigned int s578c1f0:1;
  virtual  ~S578C1(); // _ZN6S578C1D1Ev
  virtual void  v1(); // _ZN6S578C12v1Ev
  virtual void  v2(); // _ZN6S578C12v2Ev
  virtual void  v3(); // _ZN6S578C12v3Ev
  S578C1(); // tgen
};
//SIG(1 S578C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v110 v111 v112 v113 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2 v3 Fi:1}


 S578C1 ::~S578C1(){ note_dtor("S578C1", this);}
void  S578C1 ::v1(){vfunc_called(this, "_ZN6S578C12v1Ev");}
void  S578C1 ::v2(){vfunc_called(this, "_ZN6S578C12v2Ev");}
void  S578C1 ::v3(){vfunc_called(this, "_ZN6S578C12v3Ev");}
S578C1 ::S578C1(){ note_ctor("S578C1", this);} // tgen

static void Test_S578C1()
{
  extern Class_Descriptor cd_S578C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,57)];
    init_test(&cd_S578C1, buf);
    S578C1 *dp, &lv = *(dp=new (buf) S578C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,224), "sizeof(S578C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S578C1)");
    check_base_class_offset(lv, (S578C5*)(S578C4_nt*)(S578C3_nt*)(S578C2_nt*), 0, "S578C1");
    check_base_class_offset(lv, (S578C4_nt*)(S578C3_nt*)(S578C2_nt*), 0, "S578C1");
    check_base_class_offset(lv, (S578C3_nt*)(S578C2_nt*), 0, "S578C1");
    check_base_class_offset(lv, (S578C2_nt*), 0, "S578C1");
    set_bf_and_test(lv, s578c1f0, ABISELECT(296,220), 0, 1, 1, "S578C1");
    test_class_info(&lv, &cd_S578C1);
    dp->~S578C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS578C1(Test_S578C1, "S578C1", ABISELECT(304,224));

#else // __cplusplus

extern void _ZN6S578C1C1Ev();
extern void _ZN6S578C1D1Ev();
Name_Map name_map_S578C1[] = {
  NSPAIR(_ZN6S578C1C1Ev),
  NSPAIR(_ZN6S578C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S578C5;
extern VTBL_ENTRY _ZTI6S578C5[];
extern  VTBL_ENTRY _ZTV6S578C5[];
extern Class_Descriptor cd_S578C4_nt;
extern VTBL_ENTRY _ZTI9S578C4_nt[];
extern  VTBL_ENTRY _ZTV9S578C4_nt[];
extern Class_Descriptor cd_S578C3_nt;
extern VTBL_ENTRY _ZTI9S578C3_nt[];
extern  VTBL_ENTRY _ZTV9S578C3_nt[];
extern Class_Descriptor cd_S578C2_nt;
extern VTBL_ENTRY _ZTI9S578C2_nt[];
extern  VTBL_ENTRY _ZTV9S578C2_nt[];
static Base_Class bases_S578C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S578C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S578C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S578C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S578C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S578C1[];
extern void _ZN6S578C1D1Ev();
extern void _ZN6S578C1D0Ev();
extern void _ZN6S578C52v4Ev();
extern void _ZN6S578C52v5Ev();
extern void _ZN6S578C52v6Ev();
extern void _ZN6S578C52v7Ev();
extern void _ZN6S578C52v8Ev();
extern void _ZN6S578C52v9Ev();
extern void _ZN6S578C53v10Ev();
extern void _ZN6S578C53v11Ev();
extern void _ZN6S578C53v12Ev();
extern void _ZN6S578C53v13Ev();
extern void _ZN6S578C53v14Ev();
extern void _ZN6S578C53v15Ev();
extern void _ZN6S578C53v16Ev();
extern void _ZN6S578C53v17Ev();
extern void _ZN6S578C53v18Ev();
extern void _ZN6S578C53v19Ev();
extern void _ZN6S578C53v20Ev();
extern void _ZN6S578C53v21Ev();
extern void _ZN6S578C53v22Ev();
extern void _ZN6S578C53v23Ev();
extern void _ZN6S578C53v24Ev();
extern void _ZN6S578C53v25Ev();
extern void _ZN6S578C53v26Ev();
extern void _ZN6S578C53v27Ev();
extern void _ZN6S578C53v28Ev();
extern void _ZN6S578C53v29Ev();
extern void _ZN6S578C53v30Ev();
extern void _ZN6S578C53v31Ev();
extern void _ZN6S578C53v32Ev();
extern void _ZN6S578C53v33Ev();
extern void _ZN6S578C53v34Ev();
extern void _ZN6S578C53v35Ev();
extern void _ZN6S578C53v36Ev();
extern void _ZN6S578C53v37Ev();
extern void _ZN6S578C53v38Ev();
extern void _ZN6S578C53v39Ev();
extern void _ZN6S578C53v40Ev();
extern void _ZN6S578C53v41Ev();
extern void _ZN6S578C53v42Ev();
extern void _ZN6S578C53v43Ev();
extern void _ZN6S578C53v44Ev();
extern void _ZN6S578C53v45Ev();
extern void _ZN6S578C53v46Ev();
extern void _ZN6S578C53v47Ev();
extern void _ZN6S578C53v48Ev();
extern void _ZN6S578C53v49Ev();
extern void _ZN6S578C53v50Ev();
extern void _ZN6S578C53v51Ev();
extern void _ZN6S578C53v52Ev();
extern void _ZN6S578C53v53Ev();
extern void _ZN6S578C53v54Ev();
extern void _ZN6S578C53v55Ev();
extern void _ZN6S578C53v56Ev();
extern void _ZN6S578C53v57Ev();
extern void _ZN6S578C53v58Ev();
extern void _ZN6S578C53v59Ev();
extern void _ZN6S578C53v60Ev();
extern void _ZN6S578C53v61Ev();
extern void _ZN6S578C53v62Ev();
extern void _ZN6S578C53v63Ev();
extern void _ZN6S578C53v64Ev();
extern void _ZN6S578C53v65Ev();
extern void _ZN6S578C53v66Ev();
extern void _ZN6S578C53v67Ev();
extern void _ZN9S578C4_nt3v68Ev();
extern void _ZN9S578C4_nt3v69Ev();
extern void _ZN9S578C4_nt3v70Ev();
extern void _ZN9S578C4_nt3v71Ev();
extern void _ZN9S578C4_nt3v72Ev();
extern void _ZN9S578C4_nt3v73Ev();
extern void _ZN9S578C4_nt3v74Ev();
extern void _ZN9S578C4_nt3v75Ev();
extern void _ZN9S578C4_nt3v76Ev();
extern void _ZN9S578C4_nt3v77Ev();
extern void _ZN9S578C4_nt3v78Ev();
extern void _ZN9S578C4_nt3v79Ev();
extern void _ZN9S578C4_nt3v80Ev();
extern void _ZN9S578C4_nt3v81Ev();
extern void _ZN9S578C4_nt3v82Ev();
extern void _ZN9S578C4_nt3v83Ev();
extern void _ZN9S578C4_nt3v84Ev();
extern void _ZN9S578C4_nt3v85Ev();
extern void _ZN9S578C4_nt3v86Ev();
extern void _ZN9S578C4_nt3v87Ev();
extern void _ZN9S578C4_nt3v88Ev();
extern void _ZN9S578C4_nt3v89Ev();
extern void _ZN9S578C3_nt3v90Ev();
extern void _ZN9S578C3_nt3v91Ev();
extern void _ZN9S578C3_nt3v92Ev();
extern void _ZN9S578C3_nt3v93Ev();
extern void _ZN9S578C3_nt3v94Ev();
extern void _ZN9S578C3_nt3v95Ev();
extern void _ZN9S578C3_nt3v96Ev();
extern void _ZN9S578C3_nt3v97Ev();
extern void _ZN9S578C3_nt3v98Ev();
extern void _ZN9S578C3_nt3v99Ev();
extern void _ZN9S578C3_nt4v100Ev();
extern void _ZN9S578C3_nt4v101Ev();
extern void _ZN9S578C3_nt4v102Ev();
extern void _ZN9S578C3_nt4v103Ev();
extern void _ZN9S578C3_nt4v104Ev();
extern void _ZN9S578C3_nt4v105Ev();
extern void _ZN9S578C3_nt4v106Ev();
extern void _ZN9S578C3_nt4v107Ev();
extern void _ZN9S578C3_nt4v108Ev();
extern void _ZN9S578C3_nt4v109Ev();
extern void _ZN9S578C2_nt4v110Ev();
extern void _ZN9S578C2_nt4v111Ev();
extern void _ZN9S578C2_nt4v112Ev();
extern void _ZN9S578C2_nt4v113Ev();
extern void _ZN6S578C12v1Ev();
extern void _ZN6S578C12v2Ev();
extern void _ZN6S578C12v3Ev();
static  VTBL_ENTRY vtc_S578C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S578C1[0]),
  (VTBL_ENTRY)&_ZN6S578C1D1Ev,
  (VTBL_ENTRY)&_ZN6S578C1D0Ev,
  (VTBL_ENTRY)&_ZN6S578C52v4Ev,
  (VTBL_ENTRY)&_ZN6S578C52v5Ev,
  (VTBL_ENTRY)&_ZN6S578C52v6Ev,
  (VTBL_ENTRY)&_ZN6S578C52v7Ev,
  (VTBL_ENTRY)&_ZN6S578C52v8Ev,
  (VTBL_ENTRY)&_ZN6S578C52v9Ev,
  (VTBL_ENTRY)&_ZN6S578C53v10Ev,
  (VTBL_ENTRY)&_ZN6S578C53v11Ev,
  (VTBL_ENTRY)&_ZN6S578C53v12Ev,
  (VTBL_ENTRY)&_ZN6S578C53v13Ev,
  (VTBL_ENTRY)&_ZN6S578C53v14Ev,
  (VTBL_ENTRY)&_ZN6S578C53v15Ev,
  (VTBL_ENTRY)&_ZN6S578C53v16Ev,
  (VTBL_ENTRY)&_ZN6S578C53v17Ev,
  (VTBL_ENTRY)&_ZN6S578C53v18Ev,
  (VTBL_ENTRY)&_ZN6S578C53v19Ev,
  (VTBL_ENTRY)&_ZN6S578C53v20Ev,
  (VTBL_ENTRY)&_ZN6S578C53v21Ev,
  (VTBL_ENTRY)&_ZN6S578C53v22Ev,
  (VTBL_ENTRY)&_ZN6S578C53v23Ev,
  (VTBL_ENTRY)&_ZN6S578C53v24Ev,
  (VTBL_ENTRY)&_ZN6S578C53v25Ev,
  (VTBL_ENTRY)&_ZN6S578C53v26Ev,
  (VTBL_ENTRY)&_ZN6S578C53v27Ev,
  (VTBL_ENTRY)&_ZN6S578C53v28Ev,
  (VTBL_ENTRY)&_ZN6S578C53v29Ev,
  (VTBL_ENTRY)&_ZN6S578C53v30Ev,
  (VTBL_ENTRY)&_ZN6S578C53v31Ev,
  (VTBL_ENTRY)&_ZN6S578C53v32Ev,
  (VTBL_ENTRY)&_ZN6S578C53v33Ev,
  (VTBL_ENTRY)&_ZN6S578C53v34Ev,
  (VTBL_ENTRY)&_ZN6S578C53v35Ev,
  (VTBL_ENTRY)&_ZN6S578C53v36Ev,
  (VTBL_ENTRY)&_ZN6S578C53v37Ev,
  (VTBL_ENTRY)&_ZN6S578C53v38Ev,
  (VTBL_ENTRY)&_ZN6S578C53v39Ev,
  (VTBL_ENTRY)&_ZN6S578C53v40Ev,
  (VTBL_ENTRY)&_ZN6S578C53v41Ev,
  (VTBL_ENTRY)&_ZN6S578C53v42Ev,
  (VTBL_ENTRY)&_ZN6S578C53v43Ev,
  (VTBL_ENTRY)&_ZN6S578C53v44Ev,
  (VTBL_ENTRY)&_ZN6S578C53v45Ev,
  (VTBL_ENTRY)&_ZN6S578C53v46Ev,
  (VTBL_ENTRY)&_ZN6S578C53v47Ev,
  (VTBL_ENTRY)&_ZN6S578C53v48Ev,
  (VTBL_ENTRY)&_ZN6S578C53v49Ev,
  (VTBL_ENTRY)&_ZN6S578C53v50Ev,
  (VTBL_ENTRY)&_ZN6S578C53v51Ev,
  (VTBL_ENTRY)&_ZN6S578C53v52Ev,
  (VTBL_ENTRY)&_ZN6S578C53v53Ev,
  (VTBL_ENTRY)&_ZN6S578C53v54Ev,
  (VTBL_ENTRY)&_ZN6S578C53v55Ev,
  (VTBL_ENTRY)&_ZN6S578C53v56Ev,
  (VTBL_ENTRY)&_ZN6S578C53v57Ev,
  (VTBL_ENTRY)&_ZN6S578C53v58Ev,
  (VTBL_ENTRY)&_ZN6S578C53v59Ev,
  (VTBL_ENTRY)&_ZN6S578C53v60Ev,
  (VTBL_ENTRY)&_ZN6S578C53v61Ev,
  (VTBL_ENTRY)&_ZN6S578C53v62Ev,
  (VTBL_ENTRY)&_ZN6S578C53v63Ev,
  (VTBL_ENTRY)&_ZN6S578C53v64Ev,
  (VTBL_ENTRY)&_ZN6S578C53v65Ev,
  (VTBL_ENTRY)&_ZN6S578C53v66Ev,
  (VTBL_ENTRY)&_ZN6S578C53v67Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S578C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S578C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S578C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S578C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S578C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S578C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN6S578C12v1Ev,
  (VTBL_ENTRY)&_ZN6S578C12v2Ev,
  (VTBL_ENTRY)&_ZN6S578C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S578C1[];
extern  VTBL_ENTRY _ZTV6S578C1[];
Class_Descriptor cd_S578C1 = {  "S578C1", // class name
  bases_S578C1, 4,
  &(vtc_S578C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,224), // object size
  NSPAIRA(_ZTI6S578C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S578C1),117, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S566C5  {
  int s566c5f0;
  __tsi64 s566c5f1;
  void *s566c5f2[4];
  int s566c5f3[2];
  void *s566c5f4;
  ::S1502C5_nt s566c5f5;
  void *s566c5f6[2];
  virtual  ~S566C5(); // _ZN6S566C5D1Ev
  virtual void  v4(); // _ZN6S566C52v4Ev
  virtual void  v5(); // _ZN6S566C52v5Ev
  virtual void  v6(); // _ZN6S566C52v6Ev
  virtual void  v7(); // _ZN6S566C52v7Ev
  virtual void  v8(); // _ZN6S566C52v8Ev
  virtual void  v9(); // _ZN6S566C52v9Ev
  virtual void  v10(); // _ZN6S566C53v10Ev
  virtual void  v11(); // _ZN6S566C53v11Ev
  virtual void  v12(); // _ZN6S566C53v12Ev
  virtual void  v13(); // _ZN6S566C53v13Ev
  virtual void  v14(); // _ZN6S566C53v14Ev
  virtual void  v15(); // _ZN6S566C53v15Ev
  virtual void  v16(); // _ZN6S566C53v16Ev
  virtual void  v17(); // _ZN6S566C53v17Ev
  virtual void  v18(); // _ZN6S566C53v18Ev
  virtual void  v19(); // _ZN6S566C53v19Ev
  virtual void  v20(); // _ZN6S566C53v20Ev
  virtual void  v21(); // _ZN6S566C53v21Ev
  virtual void  v22(); // _ZN6S566C53v22Ev
  virtual void  v23(); // _ZN6S566C53v23Ev
  virtual void  v24(); // _ZN6S566C53v24Ev
  virtual void  v25(); // _ZN6S566C53v25Ev
  virtual void  v26(); // _ZN6S566C53v26Ev
  virtual void  v27(); // _ZN6S566C53v27Ev
  virtual void  v28(); // _ZN6S566C53v28Ev
  virtual void  v29(); // _ZN6S566C53v29Ev
  virtual void  v30(); // _ZN6S566C53v30Ev
  virtual void  v31(); // _ZN6S566C53v31Ev
  virtual void  v32(); // _ZN6S566C53v32Ev
  virtual void  v33(); // _ZN6S566C53v33Ev
  virtual void  v34(); // _ZN6S566C53v34Ev
  virtual void  v35(); // _ZN6S566C53v35Ev
  virtual void  v36(); // _ZN6S566C53v36Ev
  virtual void  v37(); // _ZN6S566C53v37Ev
  virtual void  v38(); // _ZN6S566C53v38Ev
  virtual void  v39(); // _ZN6S566C53v39Ev
  virtual void  v40(); // _ZN6S566C53v40Ev
  virtual void  v41(); // _ZN6S566C53v41Ev
  virtual void  v42(); // _ZN6S566C53v42Ev
  virtual void  v43(); // _ZN6S566C53v43Ev
  virtual void  v44(); // _ZN6S566C53v44Ev
  virtual void  v45(); // _ZN6S566C53v45Ev
  virtual void  v46(); // _ZN6S566C53v46Ev
  virtual void  v47(); // _ZN6S566C53v47Ev
  virtual void  v48(); // _ZN6S566C53v48Ev
  virtual void  v49(); // _ZN6S566C53v49Ev
  virtual void  v50(); // _ZN6S566C53v50Ev
  virtual void  v51(); // _ZN6S566C53v51Ev
  virtual void  v52(); // _ZN6S566C53v52Ev
  virtual void  v53(); // _ZN6S566C53v53Ev
  virtual void  v54(); // _ZN6S566C53v54Ev
  virtual void  v55(); // _ZN6S566C53v55Ev
  virtual void  v56(); // _ZN6S566C53v56Ev
  virtual void  v57(); // _ZN6S566C53v57Ev
  virtual void  v58(); // _ZN6S566C53v58Ev
  virtual void  v59(); // _ZN6S566C53v59Ev
  virtual void  v60(); // _ZN6S566C53v60Ev
  virtual void  v61(); // _ZN6S566C53v61Ev
  virtual void  v62(); // _ZN6S566C53v62Ev
  virtual void  v63(); // _ZN6S566C53v63Ev
  virtual void  v64(); // _ZN6S566C53v64Ev
  virtual void  v65(); // _ZN6S566C53v65Ev
  virtual void  v66(); // _ZN6S566C53v66Ev
  virtual void  v67(); // _ZN6S566C53v67Ev
  S566C5(); // tgen
};
//SIG(-1 S566C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S566C5 ::~S566C5(){ note_dtor("S566C5", this);}
void  S566C5 ::v4(){vfunc_called(this, "_ZN6S566C52v4Ev");}
void  S566C5 ::v5(){vfunc_called(this, "_ZN6S566C52v5Ev");}
void  S566C5 ::v6(){vfunc_called(this, "_ZN6S566C52v6Ev");}
void  S566C5 ::v7(){vfunc_called(this, "_ZN6S566C52v7Ev");}
void  S566C5 ::v8(){vfunc_called(this, "_ZN6S566C52v8Ev");}
void  S566C5 ::v9(){vfunc_called(this, "_ZN6S566C52v9Ev");}
void  S566C5 ::v10(){vfunc_called(this, "_ZN6S566C53v10Ev");}
void  S566C5 ::v11(){vfunc_called(this, "_ZN6S566C53v11Ev");}
void  S566C5 ::v12(){vfunc_called(this, "_ZN6S566C53v12Ev");}
void  S566C5 ::v13(){vfunc_called(this, "_ZN6S566C53v13Ev");}
void  S566C5 ::v14(){vfunc_called(this, "_ZN6S566C53v14Ev");}
void  S566C5 ::v15(){vfunc_called(this, "_ZN6S566C53v15Ev");}
void  S566C5 ::v16(){vfunc_called(this, "_ZN6S566C53v16Ev");}
void  S566C5 ::v17(){vfunc_called(this, "_ZN6S566C53v17Ev");}
void  S566C5 ::v18(){vfunc_called(this, "_ZN6S566C53v18Ev");}
void  S566C5 ::v19(){vfunc_called(this, "_ZN6S566C53v19Ev");}
void  S566C5 ::v20(){vfunc_called(this, "_ZN6S566C53v20Ev");}
void  S566C5 ::v21(){vfunc_called(this, "_ZN6S566C53v21Ev");}
void  S566C5 ::v22(){vfunc_called(this, "_ZN6S566C53v22Ev");}
void  S566C5 ::v23(){vfunc_called(this, "_ZN6S566C53v23Ev");}
void  S566C5 ::v24(){vfunc_called(this, "_ZN6S566C53v24Ev");}
void  S566C5 ::v25(){vfunc_called(this, "_ZN6S566C53v25Ev");}
void  S566C5 ::v26(){vfunc_called(this, "_ZN6S566C53v26Ev");}
void  S566C5 ::v27(){vfunc_called(this, "_ZN6S566C53v27Ev");}
void  S566C5 ::v28(){vfunc_called(this, "_ZN6S566C53v28Ev");}
void  S566C5 ::v29(){vfunc_called(this, "_ZN6S566C53v29Ev");}
void  S566C5 ::v30(){vfunc_called(this, "_ZN6S566C53v30Ev");}
void  S566C5 ::v31(){vfunc_called(this, "_ZN6S566C53v31Ev");}
void  S566C5 ::v32(){vfunc_called(this, "_ZN6S566C53v32Ev");}
void  S566C5 ::v33(){vfunc_called(this, "_ZN6S566C53v33Ev");}
void  S566C5 ::v34(){vfunc_called(this, "_ZN6S566C53v34Ev");}
void  S566C5 ::v35(){vfunc_called(this, "_ZN6S566C53v35Ev");}
void  S566C5 ::v36(){vfunc_called(this, "_ZN6S566C53v36Ev");}
void  S566C5 ::v37(){vfunc_called(this, "_ZN6S566C53v37Ev");}
void  S566C5 ::v38(){vfunc_called(this, "_ZN6S566C53v38Ev");}
void  S566C5 ::v39(){vfunc_called(this, "_ZN6S566C53v39Ev");}
void  S566C5 ::v40(){vfunc_called(this, "_ZN6S566C53v40Ev");}
void  S566C5 ::v41(){vfunc_called(this, "_ZN6S566C53v41Ev");}
void  S566C5 ::v42(){vfunc_called(this, "_ZN6S566C53v42Ev");}
void  S566C5 ::v43(){vfunc_called(this, "_ZN6S566C53v43Ev");}
void  S566C5 ::v44(){vfunc_called(this, "_ZN6S566C53v44Ev");}
void  S566C5 ::v45(){vfunc_called(this, "_ZN6S566C53v45Ev");}
void  S566C5 ::v46(){vfunc_called(this, "_ZN6S566C53v46Ev");}
void  S566C5 ::v47(){vfunc_called(this, "_ZN6S566C53v47Ev");}
void  S566C5 ::v48(){vfunc_called(this, "_ZN6S566C53v48Ev");}
void  S566C5 ::v49(){vfunc_called(this, "_ZN6S566C53v49Ev");}
void  S566C5 ::v50(){vfunc_called(this, "_ZN6S566C53v50Ev");}
void  S566C5 ::v51(){vfunc_called(this, "_ZN6S566C53v51Ev");}
void  S566C5 ::v52(){vfunc_called(this, "_ZN6S566C53v52Ev");}
void  S566C5 ::v53(){vfunc_called(this, "_ZN6S566C53v53Ev");}
void  S566C5 ::v54(){vfunc_called(this, "_ZN6S566C53v54Ev");}
void  S566C5 ::v55(){vfunc_called(this, "_ZN6S566C53v55Ev");}
void  S566C5 ::v56(){vfunc_called(this, "_ZN6S566C53v56Ev");}
void  S566C5 ::v57(){vfunc_called(this, "_ZN6S566C53v57Ev");}
void  S566C5 ::v58(){vfunc_called(this, "_ZN6S566C53v58Ev");}
void  S566C5 ::v59(){vfunc_called(this, "_ZN6S566C53v59Ev");}
void  S566C5 ::v60(){vfunc_called(this, "_ZN6S566C53v60Ev");}
void  S566C5 ::v61(){vfunc_called(this, "_ZN6S566C53v61Ev");}
void  S566C5 ::v62(){vfunc_called(this, "_ZN6S566C53v62Ev");}
void  S566C5 ::v63(){vfunc_called(this, "_ZN6S566C53v63Ev");}
void  S566C5 ::v64(){vfunc_called(this, "_ZN6S566C53v64Ev");}
void  S566C5 ::v65(){vfunc_called(this, "_ZN6S566C53v65Ev");}
void  S566C5 ::v66(){vfunc_called(this, "_ZN6S566C53v66Ev");}
void  S566C5 ::v67(){vfunc_called(this, "_ZN6S566C53v67Ev");}
S566C5 ::S566C5(){ note_ctor("S566C5", this);} // tgen

static void Test_S566C5()
{
  extern Class_Descriptor cd_S566C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S566C5, buf);
    S566C5 *dp, &lv = *(dp=new (buf) S566C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S566C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S566C5)");
    check_field_offset(lv, s566c5f0, ABISELECT(8,4), "S566C5.s566c5f0");
    check_field_offset(lv, s566c5f1, ABISELECT(16,8), "S566C5.s566c5f1");
    check_field_offset(lv, s566c5f2, ABISELECT(24,16), "S566C5.s566c5f2");
    check_field_offset(lv, s566c5f3, ABISELECT(56,32), "S566C5.s566c5f3");
    check_field_offset(lv, s566c5f4, ABISELECT(64,40), "S566C5.s566c5f4");
    check_field_offset(lv, s566c5f5, ABISELECT(72,44), "S566C5.s566c5f5");
    check_field_offset(lv, s566c5f6, ABISELECT(80,52), "S566C5.s566c5f6");
    test_class_info(&lv, &cd_S566C5);
    dp->~S566C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS566C5(Test_S566C5, "S566C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S566C5C1Ev();
extern void _ZN6S566C5D1Ev();
Name_Map name_map_S566C5[] = {
  NSPAIR(_ZN6S566C5C1Ev),
  NSPAIR(_ZN6S566C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S566C5[];
extern void _ZN6S566C5D1Ev();
extern void _ZN6S566C5D0Ev();
extern void _ZN6S566C52v4Ev();
extern void _ZN6S566C52v5Ev();
extern void _ZN6S566C52v6Ev();
extern void _ZN6S566C52v7Ev();
extern void _ZN6S566C52v8Ev();
extern void _ZN6S566C52v9Ev();
extern void _ZN6S566C53v10Ev();
extern void _ZN6S566C53v11Ev();
extern void _ZN6S566C53v12Ev();
extern void _ZN6S566C53v13Ev();
extern void _ZN6S566C53v14Ev();
extern void _ZN6S566C53v15Ev();
extern void _ZN6S566C53v16Ev();
extern void _ZN6S566C53v17Ev();
extern void _ZN6S566C53v18Ev();
extern void _ZN6S566C53v19Ev();
extern void _ZN6S566C53v20Ev();
extern void _ZN6S566C53v21Ev();
extern void _ZN6S566C53v22Ev();
extern void _ZN6S566C53v23Ev();
extern void _ZN6S566C53v24Ev();
extern void _ZN6S566C53v25Ev();
extern void _ZN6S566C53v26Ev();
extern void _ZN6S566C53v27Ev();
extern void _ZN6S566C53v28Ev();
extern void _ZN6S566C53v29Ev();
extern void _ZN6S566C53v30Ev();
extern void _ZN6S566C53v31Ev();
extern void _ZN6S566C53v32Ev();
extern void _ZN6S566C53v33Ev();
extern void _ZN6S566C53v34Ev();
extern void _ZN6S566C53v35Ev();
extern void _ZN6S566C53v36Ev();
extern void _ZN6S566C53v37Ev();
extern void _ZN6S566C53v38Ev();
extern void _ZN6S566C53v39Ev();
extern void _ZN6S566C53v40Ev();
extern void _ZN6S566C53v41Ev();
extern void _ZN6S566C53v42Ev();
extern void _ZN6S566C53v43Ev();
extern void _ZN6S566C53v44Ev();
extern void _ZN6S566C53v45Ev();
extern void _ZN6S566C53v46Ev();
extern void _ZN6S566C53v47Ev();
extern void _ZN6S566C53v48Ev();
extern void _ZN6S566C53v49Ev();
extern void _ZN6S566C53v50Ev();
extern void _ZN6S566C53v51Ev();
extern void _ZN6S566C53v52Ev();
extern void _ZN6S566C53v53Ev();
extern void _ZN6S566C53v54Ev();
extern void _ZN6S566C53v55Ev();
extern void _ZN6S566C53v56Ev();
extern void _ZN6S566C53v57Ev();
extern void _ZN6S566C53v58Ev();
extern void _ZN6S566C53v59Ev();
extern void _ZN6S566C53v60Ev();
extern void _ZN6S566C53v61Ev();
extern void _ZN6S566C53v62Ev();
extern void _ZN6S566C53v63Ev();
extern void _ZN6S566C53v64Ev();
extern void _ZN6S566C53v65Ev();
extern void _ZN6S566C53v66Ev();
extern void _ZN6S566C53v67Ev();
static  VTBL_ENTRY vtc_S566C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S566C5[0]),
  (VTBL_ENTRY)&_ZN6S566C5D1Ev,
  (VTBL_ENTRY)&_ZN6S566C5D0Ev,
  (VTBL_ENTRY)&_ZN6S566C52v4Ev,
  (VTBL_ENTRY)&_ZN6S566C52v5Ev,
  (VTBL_ENTRY)&_ZN6S566C52v6Ev,
  (VTBL_ENTRY)&_ZN6S566C52v7Ev,
  (VTBL_ENTRY)&_ZN6S566C52v8Ev,
  (VTBL_ENTRY)&_ZN6S566C52v9Ev,
  (VTBL_ENTRY)&_ZN6S566C53v10Ev,
  (VTBL_ENTRY)&_ZN6S566C53v11Ev,
  (VTBL_ENTRY)&_ZN6S566C53v12Ev,
  (VTBL_ENTRY)&_ZN6S566C53v13Ev,
  (VTBL_ENTRY)&_ZN6S566C53v14Ev,
  (VTBL_ENTRY)&_ZN6S566C53v15Ev,
  (VTBL_ENTRY)&_ZN6S566C53v16Ev,
  (VTBL_ENTRY)&_ZN6S566C53v17Ev,
  (VTBL_ENTRY)&_ZN6S566C53v18Ev,
  (VTBL_ENTRY)&_ZN6S566C53v19Ev,
  (VTBL_ENTRY)&_ZN6S566C53v20Ev,
  (VTBL_ENTRY)&_ZN6S566C53v21Ev,
  (VTBL_ENTRY)&_ZN6S566C53v22Ev,
  (VTBL_ENTRY)&_ZN6S566C53v23Ev,
  (VTBL_ENTRY)&_ZN6S566C53v24Ev,
  (VTBL_ENTRY)&_ZN6S566C53v25Ev,
  (VTBL_ENTRY)&_ZN6S566C53v26Ev,
  (VTBL_ENTRY)&_ZN6S566C53v27Ev,
  (VTBL_ENTRY)&_ZN6S566C53v28Ev,
  (VTBL_ENTRY)&_ZN6S566C53v29Ev,
  (VTBL_ENTRY)&_ZN6S566C53v30Ev,
  (VTBL_ENTRY)&_ZN6S566C53v31Ev,
  (VTBL_ENTRY)&_ZN6S566C53v32Ev,
  (VTBL_ENTRY)&_ZN6S566C53v33Ev,
  (VTBL_ENTRY)&_ZN6S566C53v34Ev,
  (VTBL_ENTRY)&_ZN6S566C53v35Ev,
  (VTBL_ENTRY)&_ZN6S566C53v36Ev,
  (VTBL_ENTRY)&_ZN6S566C53v37Ev,
  (VTBL_ENTRY)&_ZN6S566C53v38Ev,
  (VTBL_ENTRY)&_ZN6S566C53v39Ev,
  (VTBL_ENTRY)&_ZN6S566C53v40Ev,
  (VTBL_ENTRY)&_ZN6S566C53v41Ev,
  (VTBL_ENTRY)&_ZN6S566C53v42Ev,
  (VTBL_ENTRY)&_ZN6S566C53v43Ev,
  (VTBL_ENTRY)&_ZN6S566C53v44Ev,
  (VTBL_ENTRY)&_ZN6S566C53v45Ev,
  (VTBL_ENTRY)&_ZN6S566C53v46Ev,
  (VTBL_ENTRY)&_ZN6S566C53v47Ev,
  (VTBL_ENTRY)&_ZN6S566C53v48Ev,
  (VTBL_ENTRY)&_ZN6S566C53v49Ev,
  (VTBL_ENTRY)&_ZN6S566C53v50Ev,
  (VTBL_ENTRY)&_ZN6S566C53v51Ev,
  (VTBL_ENTRY)&_ZN6S566C53v52Ev,
  (VTBL_ENTRY)&_ZN6S566C53v53Ev,
  (VTBL_ENTRY)&_ZN6S566C53v54Ev,
  (VTBL_ENTRY)&_ZN6S566C53v55Ev,
  (VTBL_ENTRY)&_ZN6S566C53v56Ev,
  (VTBL_ENTRY)&_ZN6S566C53v57Ev,
  (VTBL_ENTRY)&_ZN6S566C53v58Ev,
  (VTBL_ENTRY)&_ZN6S566C53v59Ev,
  (VTBL_ENTRY)&_ZN6S566C53v60Ev,
  (VTBL_ENTRY)&_ZN6S566C53v61Ev,
  (VTBL_ENTRY)&_ZN6S566C53v62Ev,
  (VTBL_ENTRY)&_ZN6S566C53v63Ev,
  (VTBL_ENTRY)&_ZN6S566C53v64Ev,
  (VTBL_ENTRY)&_ZN6S566C53v65Ev,
  (VTBL_ENTRY)&_ZN6S566C53v66Ev,
  (VTBL_ENTRY)&_ZN6S566C53v67Ev,
};
extern VTBL_ENTRY _ZTI6S566C5[];
extern  VTBL_ENTRY _ZTV6S566C5[];
Class_Descriptor cd_S566C5 = {  "S566C5", // class name
  0,0,//no base classes
  &(vtc_S566C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S566C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S566C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S566C12_nt  {
  ::S1502C31_nt s566c12f0;
  ::S1502C14_nt s566c12f1;
  int s566c12f2;
  void  mf566c12(); // _ZN10S566C12_nt8mf566c12Ev
};
//SIG(-1 S566C12_nt) C1{ m FC2{ m Fi[4]} FC3{ m Fi[3]} Fi}


void  S566C12_nt ::mf566c12(){}

//skip512 S566C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S566C4_nt  : S566C5 {
  void *s566c4f0;
  ::S1502C28 s566c4f1;
  ::S1502C5_nt s566c4f2;
  ::S1502C24 s566c4f3;
  ::S566C12_nt s566c4f4;
  int s566c4f5;
  unsigned int s566c4f6:1;
  unsigned int s566c4f7:1;
  unsigned int s566c4f8:1;
  unsigned int s566c4f9:1;
  int s566c4f10[11];
  virtual  ~S566C4_nt(); // _ZN9S566C4_ntD1Ev
  virtual void  v68(); // _ZN9S566C4_nt3v68Ev
  virtual void  v69(); // _ZN9S566C4_nt3v69Ev
  virtual void  v70(); // _ZN9S566C4_nt3v70Ev
  virtual void  v71(); // _ZN9S566C4_nt3v71Ev
  virtual void  v72(); // _ZN9S566C4_nt3v72Ev
  virtual void  v73(); // _ZN9S566C4_nt3v73Ev
  virtual void  v74(); // _ZN9S566C4_nt3v74Ev
  virtual void  v75(); // _ZN9S566C4_nt3v75Ev
  virtual void  v76(); // _ZN9S566C4_nt3v76Ev
  virtual void  v77(); // _ZN9S566C4_nt3v77Ev
  virtual void  v78(); // _ZN9S566C4_nt3v78Ev
  virtual void  v79(); // _ZN9S566C4_nt3v79Ev
  virtual void  v80(); // _ZN9S566C4_nt3v80Ev
  virtual void  v81(); // _ZN9S566C4_nt3v81Ev
  virtual void  v82(); // _ZN9S566C4_nt3v82Ev
  virtual void  v83(); // _ZN9S566C4_nt3v83Ev
  virtual void  v84(); // _ZN9S566C4_nt3v84Ev
  virtual void  v85(); // _ZN9S566C4_nt3v85Ev
  virtual void  v86(); // _ZN9S566C4_nt3v86Ev
  virtual void  v87(); // _ZN9S566C4_nt3v87Ev
  virtual void  v88(); // _ZN9S566C4_nt3v88Ev
  virtual void  v89(); // _ZN9S566C4_nt3v89Ev
  virtual void  v90(); // _ZN9S566C4_nt3v90Ev
  virtual void  v91(); // _ZN9S566C4_nt3v91Ev
  virtual void  v92(); // _ZN9S566C4_nt3v92Ev
  virtual void  v93(); // _ZN9S566C4_nt3v93Ev
  virtual void  v94(); // _ZN9S566C4_nt3v94Ev
  S566C4_nt(); // tgen
};
//SIG(-1 S566C4_nt) C1{ BC2{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC3 FC7{ BC8{ BC6}} FC9{ m FC10{ m Fi[4]} FC11{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]}


 S566C4_nt ::~S566C4_nt(){ note_dtor("S566C4_nt", this);}
void  S566C4_nt ::v68(){vfunc_called(this, "_ZN9S566C4_nt3v68Ev");}
void  S566C4_nt ::v69(){vfunc_called(this, "_ZN9S566C4_nt3v69Ev");}
void  S566C4_nt ::v70(){vfunc_called(this, "_ZN9S566C4_nt3v70Ev");}
void  S566C4_nt ::v71(){vfunc_called(this, "_ZN9S566C4_nt3v71Ev");}
void  S566C4_nt ::v72(){vfunc_called(this, "_ZN9S566C4_nt3v72Ev");}
void  S566C4_nt ::v73(){vfunc_called(this, "_ZN9S566C4_nt3v73Ev");}
void  S566C4_nt ::v74(){vfunc_called(this, "_ZN9S566C4_nt3v74Ev");}
void  S566C4_nt ::v75(){vfunc_called(this, "_ZN9S566C4_nt3v75Ev");}
void  S566C4_nt ::v76(){vfunc_called(this, "_ZN9S566C4_nt3v76Ev");}
void  S566C4_nt ::v77(){vfunc_called(this, "_ZN9S566C4_nt3v77Ev");}
void  S566C4_nt ::v78(){vfunc_called(this, "_ZN9S566C4_nt3v78Ev");}
void  S566C4_nt ::v79(){vfunc_called(this, "_ZN9S566C4_nt3v79Ev");}
void  S566C4_nt ::v80(){vfunc_called(this, "_ZN9S566C4_nt3v80Ev");}
void  S566C4_nt ::v81(){vfunc_called(this, "_ZN9S566C4_nt3v81Ev");}
void  S566C4_nt ::v82(){vfunc_called(this, "_ZN9S566C4_nt3v82Ev");}
void  S566C4_nt ::v83(){vfunc_called(this, "_ZN9S566C4_nt3v83Ev");}
void  S566C4_nt ::v84(){vfunc_called(this, "_ZN9S566C4_nt3v84Ev");}
void  S566C4_nt ::v85(){vfunc_called(this, "_ZN9S566C4_nt3v85Ev");}
void  S566C4_nt ::v86(){vfunc_called(this, "_ZN9S566C4_nt3v86Ev");}
void  S566C4_nt ::v87(){vfunc_called(this, "_ZN9S566C4_nt3v87Ev");}
void  S566C4_nt ::v88(){vfunc_called(this, "_ZN9S566C4_nt3v88Ev");}
void  S566C4_nt ::v89(){vfunc_called(this, "_ZN9S566C4_nt3v89Ev");}
void  S566C4_nt ::v90(){vfunc_called(this, "_ZN9S566C4_nt3v90Ev");}
void  S566C4_nt ::v91(){vfunc_called(this, "_ZN9S566C4_nt3v91Ev");}
void  S566C4_nt ::v92(){vfunc_called(this, "_ZN9S566C4_nt3v92Ev");}
void  S566C4_nt ::v93(){vfunc_called(this, "_ZN9S566C4_nt3v93Ev");}
void  S566C4_nt ::v94(){vfunc_called(this, "_ZN9S566C4_nt3v94Ev");}
S566C4_nt ::S566C4_nt(){ note_ctor("S566C4_nt", this);} // tgen

//skip512 S566C4_nt

#else // __cplusplus

extern void _ZN9S566C4_ntC1Ev();
extern void _ZN9S566C4_ntD1Ev();
Name_Map name_map_S566C4_nt[] = {
  NSPAIR(_ZN9S566C4_ntC1Ev),
  NSPAIR(_ZN9S566C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S566C5;
extern VTBL_ENTRY _ZTI6S566C5[];
extern  VTBL_ENTRY _ZTV6S566C5[];
static Base_Class bases_S566C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S566C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S566C4_nt[];
extern void _ZN9S566C4_ntD1Ev();
extern void _ZN9S566C4_ntD0Ev();
extern void _ZN6S566C52v4Ev();
extern void _ZN6S566C52v5Ev();
extern void _ZN6S566C52v6Ev();
extern void _ZN6S566C52v7Ev();
extern void _ZN6S566C52v8Ev();
extern void _ZN6S566C52v9Ev();
extern void _ZN6S566C53v10Ev();
extern void _ZN6S566C53v11Ev();
extern void _ZN6S566C53v12Ev();
extern void _ZN6S566C53v13Ev();
extern void _ZN6S566C53v14Ev();
extern void _ZN6S566C53v15Ev();
extern void _ZN6S566C53v16Ev();
extern void _ZN6S566C53v17Ev();
extern void _ZN6S566C53v18Ev();
extern void _ZN6S566C53v19Ev();
extern void _ZN6S566C53v20Ev();
extern void _ZN6S566C53v21Ev();
extern void _ZN6S566C53v22Ev();
extern void _ZN6S566C53v23Ev();
extern void _ZN6S566C53v24Ev();
extern void _ZN6S566C53v25Ev();
extern void _ZN6S566C53v26Ev();
extern void _ZN6S566C53v27Ev();
extern void _ZN6S566C53v28Ev();
extern void _ZN6S566C53v29Ev();
extern void _ZN6S566C53v30Ev();
extern void _ZN6S566C53v31Ev();
extern void _ZN6S566C53v32Ev();
extern void _ZN6S566C53v33Ev();
extern void _ZN6S566C53v34Ev();
extern void _ZN6S566C53v35Ev();
extern void _ZN6S566C53v36Ev();
extern void _ZN6S566C53v37Ev();
extern void _ZN6S566C53v38Ev();
extern void _ZN6S566C53v39Ev();
extern void _ZN6S566C53v40Ev();
extern void _ZN6S566C53v41Ev();
extern void _ZN6S566C53v42Ev();
extern void _ZN6S566C53v43Ev();
extern void _ZN6S566C53v44Ev();
extern void _ZN6S566C53v45Ev();
extern void _ZN6S566C53v46Ev();
extern void _ZN6S566C53v47Ev();
extern void _ZN6S566C53v48Ev();
extern void _ZN6S566C53v49Ev();
extern void _ZN6S566C53v50Ev();
extern void _ZN6S566C53v51Ev();
extern void _ZN6S566C53v52Ev();
extern void _ZN6S566C53v53Ev();
extern void _ZN6S566C53v54Ev();
extern void _ZN6S566C53v55Ev();
extern void _ZN6S566C53v56Ev();
extern void _ZN6S566C53v57Ev();
extern void _ZN6S566C53v58Ev();
extern void _ZN6S566C53v59Ev();
extern void _ZN6S566C53v60Ev();
extern void _ZN6S566C53v61Ev();
extern void _ZN6S566C53v62Ev();
extern void _ZN6S566C53v63Ev();
extern void _ZN6S566C53v64Ev();
extern void _ZN6S566C53v65Ev();
extern void _ZN6S566C53v66Ev();
extern void _ZN6S566C53v67Ev();
extern void _ZN9S566C4_nt3v68Ev();
extern void _ZN9S566C4_nt3v69Ev();
extern void _ZN9S566C4_nt3v70Ev();
extern void _ZN9S566C4_nt3v71Ev();
extern void _ZN9S566C4_nt3v72Ev();
extern void _ZN9S566C4_nt3v73Ev();
extern void _ZN9S566C4_nt3v74Ev();
extern void _ZN9S566C4_nt3v75Ev();
extern void _ZN9S566C4_nt3v76Ev();
extern void _ZN9S566C4_nt3v77Ev();
extern void _ZN9S566C4_nt3v78Ev();
extern void _ZN9S566C4_nt3v79Ev();
extern void _ZN9S566C4_nt3v80Ev();
extern void _ZN9S566C4_nt3v81Ev();
extern void _ZN9S566C4_nt3v82Ev();
extern void _ZN9S566C4_nt3v83Ev();
extern void _ZN9S566C4_nt3v84Ev();
extern void _ZN9S566C4_nt3v85Ev();
extern void _ZN9S566C4_nt3v86Ev();
extern void _ZN9S566C4_nt3v87Ev();
extern void _ZN9S566C4_nt3v88Ev();
extern void _ZN9S566C4_nt3v89Ev();
extern void _ZN9S566C4_nt3v90Ev();
extern void _ZN9S566C4_nt3v91Ev();
extern void _ZN9S566C4_nt3v92Ev();
extern void _ZN9S566C4_nt3v93Ev();
extern void _ZN9S566C4_nt3v94Ev();
static  VTBL_ENTRY vtc_S566C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S566C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S566C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S566C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S566C52v4Ev,
  (VTBL_ENTRY)&_ZN6S566C52v5Ev,
  (VTBL_ENTRY)&_ZN6S566C52v6Ev,
  (VTBL_ENTRY)&_ZN6S566C52v7Ev,
  (VTBL_ENTRY)&_ZN6S566C52v8Ev,
  (VTBL_ENTRY)&_ZN6S566C52v9Ev,
  (VTBL_ENTRY)&_ZN6S566C53v10Ev,
  (VTBL_ENTRY)&_ZN6S566C53v11Ev,
  (VTBL_ENTRY)&_ZN6S566C53v12Ev,
  (VTBL_ENTRY)&_ZN6S566C53v13Ev,
  (VTBL_ENTRY)&_ZN6S566C53v14Ev,
  (VTBL_ENTRY)&_ZN6S566C53v15Ev,
  (VTBL_ENTRY)&_ZN6S566C53v16Ev,
  (VTBL_ENTRY)&_ZN6S566C53v17Ev,
  (VTBL_ENTRY)&_ZN6S566C53v18Ev,
  (VTBL_ENTRY)&_ZN6S566C53v19Ev,
  (VTBL_ENTRY)&_ZN6S566C53v20Ev,
  (VTBL_ENTRY)&_ZN6S566C53v21Ev,
  (VTBL_ENTRY)&_ZN6S566C53v22Ev,
  (VTBL_ENTRY)&_ZN6S566C53v23Ev,
  (VTBL_ENTRY)&_ZN6S566C53v24Ev,
  (VTBL_ENTRY)&_ZN6S566C53v25Ev,
  (VTBL_ENTRY)&_ZN6S566C53v26Ev,
  (VTBL_ENTRY)&_ZN6S566C53v27Ev,
  (VTBL_ENTRY)&_ZN6S566C53v28Ev,
  (VTBL_ENTRY)&_ZN6S566C53v29Ev,
  (VTBL_ENTRY)&_ZN6S566C53v30Ev,
  (VTBL_ENTRY)&_ZN6S566C53v31Ev,
  (VTBL_ENTRY)&_ZN6S566C53v32Ev,
  (VTBL_ENTRY)&_ZN6S566C53v33Ev,
  (VTBL_ENTRY)&_ZN6S566C53v34Ev,
  (VTBL_ENTRY)&_ZN6S566C53v35Ev,
  (VTBL_ENTRY)&_ZN6S566C53v36Ev,
  (VTBL_ENTRY)&_ZN6S566C53v37Ev,
  (VTBL_ENTRY)&_ZN6S566C53v38Ev,
  (VTBL_ENTRY)&_ZN6S566C53v39Ev,
  (VTBL_ENTRY)&_ZN6S566C53v40Ev,
  (VTBL_ENTRY)&_ZN6S566C53v41Ev,
  (VTBL_ENTRY)&_ZN6S566C53v42Ev,
  (VTBL_ENTRY)&_ZN6S566C53v43Ev,
  (VTBL_ENTRY)&_ZN6S566C53v44Ev,
  (VTBL_ENTRY)&_ZN6S566C53v45Ev,
  (VTBL_ENTRY)&_ZN6S566C53v46Ev,
  (VTBL_ENTRY)&_ZN6S566C53v47Ev,
  (VTBL_ENTRY)&_ZN6S566C53v48Ev,
  (VTBL_ENTRY)&_ZN6S566C53v49Ev,
  (VTBL_ENTRY)&_ZN6S566C53v50Ev,
  (VTBL_ENTRY)&_ZN6S566C53v51Ev,
  (VTBL_ENTRY)&_ZN6S566C53v52Ev,
  (VTBL_ENTRY)&_ZN6S566C53v53Ev,
  (VTBL_ENTRY)&_ZN6S566C53v54Ev,
  (VTBL_ENTRY)&_ZN6S566C53v55Ev,
  (VTBL_ENTRY)&_ZN6S566C53v56Ev,
  (VTBL_ENTRY)&_ZN6S566C53v57Ev,
  (VTBL_ENTRY)&_ZN6S566C53v58Ev,
  (VTBL_ENTRY)&_ZN6S566C53v59Ev,
  (VTBL_ENTRY)&_ZN6S566C53v60Ev,
  (VTBL_ENTRY)&_ZN6S566C53v61Ev,
  (VTBL_ENTRY)&_ZN6S566C53v62Ev,
  (VTBL_ENTRY)&_ZN6S566C53v63Ev,
  (VTBL_ENTRY)&_ZN6S566C53v64Ev,
  (VTBL_ENTRY)&_ZN6S566C53v65Ev,
  (VTBL_ENTRY)&_ZN6S566C53v66Ev,
  (VTBL_ENTRY)&_ZN6S566C53v67Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v94Ev,
};
extern VTBL_ENTRY _ZTI9S566C4_nt[];
VTBL_ENTRY *P__ZTI9S566C4_nt = _ZTI9S566C4_nt; 
extern  VTBL_ENTRY _ZTV9S566C4_nt[];
Class_Descriptor cd_S566C4_nt = {  "S566C4_nt", // class name
  bases_S566C4_nt, 1,
  &(vtc_S566C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(232,180), // object size
  NSPAIRA(_ZTI9S566C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S566C4_nt),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S566C3_nt  : S566C4_nt {
  ::S1502C18 s566c3f0;
  unsigned int s566c3f1:1;
  virtual  ~S566C3_nt(); // _ZN9S566C3_ntD1Ev
  virtual void  v95(); // _ZN9S566C3_nt3v95Ev
  virtual void  v96(); // _ZN9S566C3_nt3v96Ev
  virtual void  v97(); // _ZN9S566C3_nt3v97Ev
  virtual void  v98(); // _ZN9S566C3_nt3v98Ev
  virtual void  v99(); // _ZN9S566C3_nt3v99Ev
  virtual void  v100(); // _ZN9S566C3_nt4v100Ev
  virtual void  v101(); // _ZN9S566C3_nt4v101Ev
  virtual void  v102(); // _ZN9S566C3_nt4v102Ev
  virtual void  v103(); // _ZN9S566C3_nt4v103Ev
  virtual void  v104(); // _ZN9S566C3_nt4v104Ev
  virtual void  v105(); // _ZN9S566C3_nt4v105Ev
  virtual void  v106(); // _ZN9S566C3_nt4v106Ev
  virtual void  v107(); // _ZN9S566C3_nt4v107Ev
  virtual void  v108(); // _ZN9S566C3_nt4v108Ev
  virtual void  v109(); // _ZN9S566C3_nt4v109Ev
  virtual void  v110(); // _ZN9S566C3_nt4v110Ev
  virtual void  v111(); // _ZN9S566C3_nt4v111Ev
  virtual void  v112(); // _ZN9S566C3_nt4v112Ev
  S566C3_nt(); // tgen
};
//SIG(-1 S566C3_nt) C1{ BC2{ BC3{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fp FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC4 FC8{ BC9{ BC7}} FC10{ m FC11{ m Fi[4]} FC12{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 FC13{ BC14{ BC7}} Fi:1}


 S566C3_nt ::~S566C3_nt(){ note_dtor("S566C3_nt", this);}
void  S566C3_nt ::v95(){vfunc_called(this, "_ZN9S566C3_nt3v95Ev");}
void  S566C3_nt ::v96(){vfunc_called(this, "_ZN9S566C3_nt3v96Ev");}
void  S566C3_nt ::v97(){vfunc_called(this, "_ZN9S566C3_nt3v97Ev");}
void  S566C3_nt ::v98(){vfunc_called(this, "_ZN9S566C3_nt3v98Ev");}
void  S566C3_nt ::v99(){vfunc_called(this, "_ZN9S566C3_nt3v99Ev");}
void  S566C3_nt ::v100(){vfunc_called(this, "_ZN9S566C3_nt4v100Ev");}
void  S566C3_nt ::v101(){vfunc_called(this, "_ZN9S566C3_nt4v101Ev");}
void  S566C3_nt ::v102(){vfunc_called(this, "_ZN9S566C3_nt4v102Ev");}
void  S566C3_nt ::v103(){vfunc_called(this, "_ZN9S566C3_nt4v103Ev");}
void  S566C3_nt ::v104(){vfunc_called(this, "_ZN9S566C3_nt4v104Ev");}
void  S566C3_nt ::v105(){vfunc_called(this, "_ZN9S566C3_nt4v105Ev");}
void  S566C3_nt ::v106(){vfunc_called(this, "_ZN9S566C3_nt4v106Ev");}
void  S566C3_nt ::v107(){vfunc_called(this, "_ZN9S566C3_nt4v107Ev");}
void  S566C3_nt ::v108(){vfunc_called(this, "_ZN9S566C3_nt4v108Ev");}
void  S566C3_nt ::v109(){vfunc_called(this, "_ZN9S566C3_nt4v109Ev");}
void  S566C3_nt ::v110(){vfunc_called(this, "_ZN9S566C3_nt4v110Ev");}
void  S566C3_nt ::v111(){vfunc_called(this, "_ZN9S566C3_nt4v111Ev");}
void  S566C3_nt ::v112(){vfunc_called(this, "_ZN9S566C3_nt4v112Ev");}
S566C3_nt ::S566C3_nt(){ note_ctor("S566C3_nt", this);} // tgen

//skip512 S566C3_nt

#else // __cplusplus

extern void _ZN9S566C3_ntC1Ev();
extern void _ZN9S566C3_ntD1Ev();
Name_Map name_map_S566C3_nt[] = {
  NSPAIR(_ZN9S566C3_ntC1Ev),
  NSPAIR(_ZN9S566C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S566C5;
extern VTBL_ENTRY _ZTI6S566C5[];
extern  VTBL_ENTRY _ZTV6S566C5[];
extern Class_Descriptor cd_S566C4_nt;
extern VTBL_ENTRY _ZTI9S566C4_nt[];
extern  VTBL_ENTRY _ZTV9S566C4_nt[];
static Base_Class bases_S566C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S566C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S566C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S566C3_nt[];
extern void _ZN9S566C3_ntD1Ev();
extern void _ZN9S566C3_ntD0Ev();
extern void _ZN6S566C52v4Ev();
extern void _ZN6S566C52v5Ev();
extern void _ZN6S566C52v6Ev();
extern void _ZN6S566C52v7Ev();
extern void _ZN6S566C52v8Ev();
extern void _ZN6S566C52v9Ev();
extern void _ZN6S566C53v10Ev();
extern void _ZN6S566C53v11Ev();
extern void _ZN6S566C53v12Ev();
extern void _ZN6S566C53v13Ev();
extern void _ZN6S566C53v14Ev();
extern void _ZN6S566C53v15Ev();
extern void _ZN6S566C53v16Ev();
extern void _ZN6S566C53v17Ev();
extern void _ZN6S566C53v18Ev();
extern void _ZN6S566C53v19Ev();
extern void _ZN6S566C53v20Ev();
extern void _ZN6S566C53v21Ev();
extern void _ZN6S566C53v22Ev();
extern void _ZN6S566C53v23Ev();
extern void _ZN6S566C53v24Ev();
extern void _ZN6S566C53v25Ev();
extern void _ZN6S566C53v26Ev();
extern void _ZN6S566C53v27Ev();
extern void _ZN6S566C53v28Ev();
extern void _ZN6S566C53v29Ev();
extern void _ZN6S566C53v30Ev();
extern void _ZN6S566C53v31Ev();
extern void _ZN6S566C53v32Ev();
extern void _ZN6S566C53v33Ev();
extern void _ZN6S566C53v34Ev();
extern void _ZN6S566C53v35Ev();
extern void _ZN6S566C53v36Ev();
extern void _ZN6S566C53v37Ev();
extern void _ZN6S566C53v38Ev();
extern void _ZN6S566C53v39Ev();
extern void _ZN6S566C53v40Ev();
extern void _ZN6S566C53v41Ev();
extern void _ZN6S566C53v42Ev();
extern void _ZN6S566C53v43Ev();
extern void _ZN6S566C53v44Ev();
extern void _ZN6S566C53v45Ev();
extern void _ZN6S566C53v46Ev();
extern void _ZN6S566C53v47Ev();
extern void _ZN6S566C53v48Ev();
extern void _ZN6S566C53v49Ev();
extern void _ZN6S566C53v50Ev();
extern void _ZN6S566C53v51Ev();
extern void _ZN6S566C53v52Ev();
extern void _ZN6S566C53v53Ev();
extern void _ZN6S566C53v54Ev();
extern void _ZN6S566C53v55Ev();
extern void _ZN6S566C53v56Ev();
extern void _ZN6S566C53v57Ev();
extern void _ZN6S566C53v58Ev();
extern void _ZN6S566C53v59Ev();
extern void _ZN6S566C53v60Ev();
extern void _ZN6S566C53v61Ev();
extern void _ZN6S566C53v62Ev();
extern void _ZN6S566C53v63Ev();
extern void _ZN6S566C53v64Ev();
extern void _ZN6S566C53v65Ev();
extern void _ZN6S566C53v66Ev();
extern void _ZN6S566C53v67Ev();
extern void _ZN9S566C4_nt3v68Ev();
extern void _ZN9S566C4_nt3v69Ev();
extern void _ZN9S566C4_nt3v70Ev();
extern void _ZN9S566C4_nt3v71Ev();
extern void _ZN9S566C4_nt3v72Ev();
extern void _ZN9S566C4_nt3v73Ev();
extern void _ZN9S566C4_nt3v74Ev();
extern void _ZN9S566C4_nt3v75Ev();
extern void _ZN9S566C4_nt3v76Ev();
extern void _ZN9S566C4_nt3v77Ev();
extern void _ZN9S566C4_nt3v78Ev();
extern void _ZN9S566C4_nt3v79Ev();
extern void _ZN9S566C4_nt3v80Ev();
extern void _ZN9S566C4_nt3v81Ev();
extern void _ZN9S566C4_nt3v82Ev();
extern void _ZN9S566C4_nt3v83Ev();
extern void _ZN9S566C4_nt3v84Ev();
extern void _ZN9S566C4_nt3v85Ev();
extern void _ZN9S566C4_nt3v86Ev();
extern void _ZN9S566C4_nt3v87Ev();
extern void _ZN9S566C4_nt3v88Ev();
extern void _ZN9S566C4_nt3v89Ev();
extern void _ZN9S566C4_nt3v90Ev();
extern void _ZN9S566C4_nt3v91Ev();
extern void _ZN9S566C4_nt3v92Ev();
extern void _ZN9S566C4_nt3v93Ev();
extern void _ZN9S566C4_nt3v94Ev();
extern void _ZN9S566C3_nt3v95Ev();
extern void _ZN9S566C3_nt3v96Ev();
extern void _ZN9S566C3_nt3v97Ev();
extern void _ZN9S566C3_nt3v98Ev();
extern void _ZN9S566C3_nt3v99Ev();
extern void _ZN9S566C3_nt4v100Ev();
extern void _ZN9S566C3_nt4v101Ev();
extern void _ZN9S566C3_nt4v102Ev();
extern void _ZN9S566C3_nt4v103Ev();
extern void _ZN9S566C3_nt4v104Ev();
extern void _ZN9S566C3_nt4v105Ev();
extern void _ZN9S566C3_nt4v106Ev();
extern void _ZN9S566C3_nt4v107Ev();
extern void _ZN9S566C3_nt4v108Ev();
extern void _ZN9S566C3_nt4v109Ev();
extern void _ZN9S566C3_nt4v110Ev();
extern void _ZN9S566C3_nt4v111Ev();
extern void _ZN9S566C3_nt4v112Ev();
static  VTBL_ENTRY vtc_S566C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S566C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S566C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S566C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S566C52v4Ev,
  (VTBL_ENTRY)&_ZN6S566C52v5Ev,
  (VTBL_ENTRY)&_ZN6S566C52v6Ev,
  (VTBL_ENTRY)&_ZN6S566C52v7Ev,
  (VTBL_ENTRY)&_ZN6S566C52v8Ev,
  (VTBL_ENTRY)&_ZN6S566C52v9Ev,
  (VTBL_ENTRY)&_ZN6S566C53v10Ev,
  (VTBL_ENTRY)&_ZN6S566C53v11Ev,
  (VTBL_ENTRY)&_ZN6S566C53v12Ev,
  (VTBL_ENTRY)&_ZN6S566C53v13Ev,
  (VTBL_ENTRY)&_ZN6S566C53v14Ev,
  (VTBL_ENTRY)&_ZN6S566C53v15Ev,
  (VTBL_ENTRY)&_ZN6S566C53v16Ev,
  (VTBL_ENTRY)&_ZN6S566C53v17Ev,
  (VTBL_ENTRY)&_ZN6S566C53v18Ev,
  (VTBL_ENTRY)&_ZN6S566C53v19Ev,
  (VTBL_ENTRY)&_ZN6S566C53v20Ev,
  (VTBL_ENTRY)&_ZN6S566C53v21Ev,
  (VTBL_ENTRY)&_ZN6S566C53v22Ev,
  (VTBL_ENTRY)&_ZN6S566C53v23Ev,
  (VTBL_ENTRY)&_ZN6S566C53v24Ev,
  (VTBL_ENTRY)&_ZN6S566C53v25Ev,
  (VTBL_ENTRY)&_ZN6S566C53v26Ev,
  (VTBL_ENTRY)&_ZN6S566C53v27Ev,
  (VTBL_ENTRY)&_ZN6S566C53v28Ev,
  (VTBL_ENTRY)&_ZN6S566C53v29Ev,
  (VTBL_ENTRY)&_ZN6S566C53v30Ev,
  (VTBL_ENTRY)&_ZN6S566C53v31Ev,
  (VTBL_ENTRY)&_ZN6S566C53v32Ev,
  (VTBL_ENTRY)&_ZN6S566C53v33Ev,
  (VTBL_ENTRY)&_ZN6S566C53v34Ev,
  (VTBL_ENTRY)&_ZN6S566C53v35Ev,
  (VTBL_ENTRY)&_ZN6S566C53v36Ev,
  (VTBL_ENTRY)&_ZN6S566C53v37Ev,
  (VTBL_ENTRY)&_ZN6S566C53v38Ev,
  (VTBL_ENTRY)&_ZN6S566C53v39Ev,
  (VTBL_ENTRY)&_ZN6S566C53v40Ev,
  (VTBL_ENTRY)&_ZN6S566C53v41Ev,
  (VTBL_ENTRY)&_ZN6S566C53v42Ev,
  (VTBL_ENTRY)&_ZN6S566C53v43Ev,
  (VTBL_ENTRY)&_ZN6S566C53v44Ev,
  (VTBL_ENTRY)&_ZN6S566C53v45Ev,
  (VTBL_ENTRY)&_ZN6S566C53v46Ev,
  (VTBL_ENTRY)&_ZN6S566C53v47Ev,
  (VTBL_ENTRY)&_ZN6S566C53v48Ev,
  (VTBL_ENTRY)&_ZN6S566C53v49Ev,
  (VTBL_ENTRY)&_ZN6S566C53v50Ev,
  (VTBL_ENTRY)&_ZN6S566C53v51Ev,
  (VTBL_ENTRY)&_ZN6S566C53v52Ev,
  (VTBL_ENTRY)&_ZN6S566C53v53Ev,
  (VTBL_ENTRY)&_ZN6S566C53v54Ev,
  (VTBL_ENTRY)&_ZN6S566C53v55Ev,
  (VTBL_ENTRY)&_ZN6S566C53v56Ev,
  (VTBL_ENTRY)&_ZN6S566C53v57Ev,
  (VTBL_ENTRY)&_ZN6S566C53v58Ev,
  (VTBL_ENTRY)&_ZN6S566C53v59Ev,
  (VTBL_ENTRY)&_ZN6S566C53v60Ev,
  (VTBL_ENTRY)&_ZN6S566C53v61Ev,
  (VTBL_ENTRY)&_ZN6S566C53v62Ev,
  (VTBL_ENTRY)&_ZN6S566C53v63Ev,
  (VTBL_ENTRY)&_ZN6S566C53v64Ev,
  (VTBL_ENTRY)&_ZN6S566C53v65Ev,
  (VTBL_ENTRY)&_ZN6S566C53v66Ev,
  (VTBL_ENTRY)&_ZN6S566C53v67Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v112Ev,
};
extern VTBL_ENTRY _ZTI9S566C3_nt[];
VTBL_ENTRY *P__ZTI9S566C3_nt = _ZTI9S566C3_nt; 
extern  VTBL_ENTRY _ZTV9S566C3_nt[];
Class_Descriptor cd_S566C3_nt = {  "S566C3_nt", // class name
  bases_S566C3_nt, 2,
  &(vtc_S566C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,196), // object size
  NSPAIRA(_ZTI9S566C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S566C3_nt),113, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S566C2  : S566C3_nt {
  int s566c2f0;
  virtual  ~S566C2(); // _ZN6S566C2D1Ev
  virtual void  v113(); // _ZN6S566C24v113Ev
  virtual void  v114(); // _ZN6S566C24v114Ev
  virtual void  v115(); // _ZN6S566C24v115Ev
  virtual void  v116(); // _ZN6S566C24v116Ev
  S566C2(); // tgen
};
//SIG(-1 S566C2) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fp FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC5 FC9{ BC10{ BC8}} FC11{ m FC12{ m Fi[4]} FC13{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 FC14{ BC15{ BC8}} Fi:1} vd v1 v2 v3 v4 Fi}


 S566C2 ::~S566C2(){ note_dtor("S566C2", this);}
void  S566C2 ::v113(){vfunc_called(this, "_ZN6S566C24v113Ev");}
void  S566C2 ::v114(){vfunc_called(this, "_ZN6S566C24v114Ev");}
void  S566C2 ::v115(){vfunc_called(this, "_ZN6S566C24v115Ev");}
void  S566C2 ::v116(){vfunc_called(this, "_ZN6S566C24v116Ev");}
S566C2 ::S566C2(){ note_ctor("S566C2", this);} // tgen

static void Test_S566C2()
{
  extern Class_Descriptor cd_S566C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,51)];
    init_test(&cd_S566C2, buf);
    S566C2 *dp, &lv = *(dp=new (buf) S566C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,200), "sizeof(S566C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S566C2)");
    check_base_class_offset(lv, (S566C5*)(S566C4_nt*)(S566C3_nt*), 0, "S566C2");
    check_base_class_offset(lv, (S566C4_nt*)(S566C3_nt*), 0, "S566C2");
    check_base_class_offset(lv, (S566C3_nt*), 0, "S566C2");
    check_field_offset(lv, s566c2f0, ABISELECT(252,196), "S566C2.s566c2f0");
    test_class_info(&lv, &cd_S566C2);
    dp->~S566C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS566C2(Test_S566C2, "S566C2", ABISELECT(256,200));

#else // __cplusplus

extern void _ZN6S566C2C1Ev();
extern void _ZN6S566C2D1Ev();
Name_Map name_map_S566C2[] = {
  NSPAIR(_ZN6S566C2C1Ev),
  NSPAIR(_ZN6S566C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S566C5;
extern VTBL_ENTRY _ZTI6S566C5[];
extern  VTBL_ENTRY _ZTV6S566C5[];
extern Class_Descriptor cd_S566C4_nt;
extern VTBL_ENTRY _ZTI9S566C4_nt[];
extern  VTBL_ENTRY _ZTV9S566C4_nt[];
extern Class_Descriptor cd_S566C3_nt;
extern VTBL_ENTRY _ZTI9S566C3_nt[];
extern  VTBL_ENTRY _ZTV9S566C3_nt[];
static Base_Class bases_S566C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S566C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S566C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S566C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S566C2[];
extern void _ZN6S566C2D1Ev();
extern void _ZN6S566C2D0Ev();
extern void _ZN6S566C52v4Ev();
extern void _ZN6S566C52v5Ev();
extern void _ZN6S566C52v6Ev();
extern void _ZN6S566C52v7Ev();
extern void _ZN6S566C52v8Ev();
extern void _ZN6S566C52v9Ev();
extern void _ZN6S566C53v10Ev();
extern void _ZN6S566C53v11Ev();
extern void _ZN6S566C53v12Ev();
extern void _ZN6S566C53v13Ev();
extern void _ZN6S566C53v14Ev();
extern void _ZN6S566C53v15Ev();
extern void _ZN6S566C53v16Ev();
extern void _ZN6S566C53v17Ev();
extern void _ZN6S566C53v18Ev();
extern void _ZN6S566C53v19Ev();
extern void _ZN6S566C53v20Ev();
extern void _ZN6S566C53v21Ev();
extern void _ZN6S566C53v22Ev();
extern void _ZN6S566C53v23Ev();
extern void _ZN6S566C53v24Ev();
extern void _ZN6S566C53v25Ev();
extern void _ZN6S566C53v26Ev();
extern void _ZN6S566C53v27Ev();
extern void _ZN6S566C53v28Ev();
extern void _ZN6S566C53v29Ev();
extern void _ZN6S566C53v30Ev();
extern void _ZN6S566C53v31Ev();
extern void _ZN6S566C53v32Ev();
extern void _ZN6S566C53v33Ev();
extern void _ZN6S566C53v34Ev();
extern void _ZN6S566C53v35Ev();
extern void _ZN6S566C53v36Ev();
extern void _ZN6S566C53v37Ev();
extern void _ZN6S566C53v38Ev();
extern void _ZN6S566C53v39Ev();
extern void _ZN6S566C53v40Ev();
extern void _ZN6S566C53v41Ev();
extern void _ZN6S566C53v42Ev();
extern void _ZN6S566C53v43Ev();
extern void _ZN6S566C53v44Ev();
extern void _ZN6S566C53v45Ev();
extern void _ZN6S566C53v46Ev();
extern void _ZN6S566C53v47Ev();
extern void _ZN6S566C53v48Ev();
extern void _ZN6S566C53v49Ev();
extern void _ZN6S566C53v50Ev();
extern void _ZN6S566C53v51Ev();
extern void _ZN6S566C53v52Ev();
extern void _ZN6S566C53v53Ev();
extern void _ZN6S566C53v54Ev();
extern void _ZN6S566C53v55Ev();
extern void _ZN6S566C53v56Ev();
extern void _ZN6S566C53v57Ev();
extern void _ZN6S566C53v58Ev();
extern void _ZN6S566C53v59Ev();
extern void _ZN6S566C53v60Ev();
extern void _ZN6S566C53v61Ev();
extern void _ZN6S566C53v62Ev();
extern void _ZN6S566C53v63Ev();
extern void _ZN6S566C53v64Ev();
extern void _ZN6S566C53v65Ev();
extern void _ZN6S566C53v66Ev();
extern void _ZN6S566C53v67Ev();
extern void _ZN9S566C4_nt3v68Ev();
extern void _ZN9S566C4_nt3v69Ev();
extern void _ZN9S566C4_nt3v70Ev();
extern void _ZN9S566C4_nt3v71Ev();
extern void _ZN9S566C4_nt3v72Ev();
extern void _ZN9S566C4_nt3v73Ev();
extern void _ZN9S566C4_nt3v74Ev();
extern void _ZN9S566C4_nt3v75Ev();
extern void _ZN9S566C4_nt3v76Ev();
extern void _ZN9S566C4_nt3v77Ev();
extern void _ZN9S566C4_nt3v78Ev();
extern void _ZN9S566C4_nt3v79Ev();
extern void _ZN9S566C4_nt3v80Ev();
extern void _ZN9S566C4_nt3v81Ev();
extern void _ZN9S566C4_nt3v82Ev();
extern void _ZN9S566C4_nt3v83Ev();
extern void _ZN9S566C4_nt3v84Ev();
extern void _ZN9S566C4_nt3v85Ev();
extern void _ZN9S566C4_nt3v86Ev();
extern void _ZN9S566C4_nt3v87Ev();
extern void _ZN9S566C4_nt3v88Ev();
extern void _ZN9S566C4_nt3v89Ev();
extern void _ZN9S566C4_nt3v90Ev();
extern void _ZN9S566C4_nt3v91Ev();
extern void _ZN9S566C4_nt3v92Ev();
extern void _ZN9S566C4_nt3v93Ev();
extern void _ZN9S566C4_nt3v94Ev();
extern void _ZN9S566C3_nt3v95Ev();
extern void _ZN9S566C3_nt3v96Ev();
extern void _ZN9S566C3_nt3v97Ev();
extern void _ZN9S566C3_nt3v98Ev();
extern void _ZN9S566C3_nt3v99Ev();
extern void _ZN9S566C3_nt4v100Ev();
extern void _ZN9S566C3_nt4v101Ev();
extern void _ZN9S566C3_nt4v102Ev();
extern void _ZN9S566C3_nt4v103Ev();
extern void _ZN9S566C3_nt4v104Ev();
extern void _ZN9S566C3_nt4v105Ev();
extern void _ZN9S566C3_nt4v106Ev();
extern void _ZN9S566C3_nt4v107Ev();
extern void _ZN9S566C3_nt4v108Ev();
extern void _ZN9S566C3_nt4v109Ev();
extern void _ZN9S566C3_nt4v110Ev();
extern void _ZN9S566C3_nt4v111Ev();
extern void _ZN9S566C3_nt4v112Ev();
extern void _ZN6S566C24v113Ev();
extern void _ZN6S566C24v114Ev();
extern void _ZN6S566C24v115Ev();
extern void _ZN6S566C24v116Ev();
static  VTBL_ENTRY vtc_S566C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S566C2[0]),
  (VTBL_ENTRY)&_ZN6S566C2D1Ev,
  (VTBL_ENTRY)&_ZN6S566C2D0Ev,
  (VTBL_ENTRY)&_ZN6S566C52v4Ev,
  (VTBL_ENTRY)&_ZN6S566C52v5Ev,
  (VTBL_ENTRY)&_ZN6S566C52v6Ev,
  (VTBL_ENTRY)&_ZN6S566C52v7Ev,
  (VTBL_ENTRY)&_ZN6S566C52v8Ev,
  (VTBL_ENTRY)&_ZN6S566C52v9Ev,
  (VTBL_ENTRY)&_ZN6S566C53v10Ev,
  (VTBL_ENTRY)&_ZN6S566C53v11Ev,
  (VTBL_ENTRY)&_ZN6S566C53v12Ev,
  (VTBL_ENTRY)&_ZN6S566C53v13Ev,
  (VTBL_ENTRY)&_ZN6S566C53v14Ev,
  (VTBL_ENTRY)&_ZN6S566C53v15Ev,
  (VTBL_ENTRY)&_ZN6S566C53v16Ev,
  (VTBL_ENTRY)&_ZN6S566C53v17Ev,
  (VTBL_ENTRY)&_ZN6S566C53v18Ev,
  (VTBL_ENTRY)&_ZN6S566C53v19Ev,
  (VTBL_ENTRY)&_ZN6S566C53v20Ev,
  (VTBL_ENTRY)&_ZN6S566C53v21Ev,
  (VTBL_ENTRY)&_ZN6S566C53v22Ev,
  (VTBL_ENTRY)&_ZN6S566C53v23Ev,
  (VTBL_ENTRY)&_ZN6S566C53v24Ev,
  (VTBL_ENTRY)&_ZN6S566C53v25Ev,
  (VTBL_ENTRY)&_ZN6S566C53v26Ev,
  (VTBL_ENTRY)&_ZN6S566C53v27Ev,
  (VTBL_ENTRY)&_ZN6S566C53v28Ev,
  (VTBL_ENTRY)&_ZN6S566C53v29Ev,
  (VTBL_ENTRY)&_ZN6S566C53v30Ev,
  (VTBL_ENTRY)&_ZN6S566C53v31Ev,
  (VTBL_ENTRY)&_ZN6S566C53v32Ev,
  (VTBL_ENTRY)&_ZN6S566C53v33Ev,
  (VTBL_ENTRY)&_ZN6S566C53v34Ev,
  (VTBL_ENTRY)&_ZN6S566C53v35Ev,
  (VTBL_ENTRY)&_ZN6S566C53v36Ev,
  (VTBL_ENTRY)&_ZN6S566C53v37Ev,
  (VTBL_ENTRY)&_ZN6S566C53v38Ev,
  (VTBL_ENTRY)&_ZN6S566C53v39Ev,
  (VTBL_ENTRY)&_ZN6S566C53v40Ev,
  (VTBL_ENTRY)&_ZN6S566C53v41Ev,
  (VTBL_ENTRY)&_ZN6S566C53v42Ev,
  (VTBL_ENTRY)&_ZN6S566C53v43Ev,
  (VTBL_ENTRY)&_ZN6S566C53v44Ev,
  (VTBL_ENTRY)&_ZN6S566C53v45Ev,
  (VTBL_ENTRY)&_ZN6S566C53v46Ev,
  (VTBL_ENTRY)&_ZN6S566C53v47Ev,
  (VTBL_ENTRY)&_ZN6S566C53v48Ev,
  (VTBL_ENTRY)&_ZN6S566C53v49Ev,
  (VTBL_ENTRY)&_ZN6S566C53v50Ev,
  (VTBL_ENTRY)&_ZN6S566C53v51Ev,
  (VTBL_ENTRY)&_ZN6S566C53v52Ev,
  (VTBL_ENTRY)&_ZN6S566C53v53Ev,
  (VTBL_ENTRY)&_ZN6S566C53v54Ev,
  (VTBL_ENTRY)&_ZN6S566C53v55Ev,
  (VTBL_ENTRY)&_ZN6S566C53v56Ev,
  (VTBL_ENTRY)&_ZN6S566C53v57Ev,
  (VTBL_ENTRY)&_ZN6S566C53v58Ev,
  (VTBL_ENTRY)&_ZN6S566C53v59Ev,
  (VTBL_ENTRY)&_ZN6S566C53v60Ev,
  (VTBL_ENTRY)&_ZN6S566C53v61Ev,
  (VTBL_ENTRY)&_ZN6S566C53v62Ev,
  (VTBL_ENTRY)&_ZN6S566C53v63Ev,
  (VTBL_ENTRY)&_ZN6S566C53v64Ev,
  (VTBL_ENTRY)&_ZN6S566C53v65Ev,
  (VTBL_ENTRY)&_ZN6S566C53v66Ev,
  (VTBL_ENTRY)&_ZN6S566C53v67Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN6S566C24v113Ev,
  (VTBL_ENTRY)&_ZN6S566C24v114Ev,
  (VTBL_ENTRY)&_ZN6S566C24v115Ev,
  (VTBL_ENTRY)&_ZN6S566C24v116Ev,
};
extern VTBL_ENTRY _ZTI6S566C2[];
extern  VTBL_ENTRY _ZTV6S566C2[];
Class_Descriptor cd_S566C2 = {  "S566C2", // class name
  bases_S566C2, 3,
  &(vtc_S566C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,200), // object size
  NSPAIRA(_ZTI6S566C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S566C2),117, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S566C1  : S566C2 {
  int s566c1f0;
  virtual  ~S566C1(); // _ZN6S566C1D1Ev
  virtual void  v1(); // _ZN6S566C12v1Ev
  virtual void  v2(); // _ZN6S566C12v2Ev
  virtual void  v3(); // _ZN6S566C12v3Ev
  S566C1(); // tgen
};
//SIG(1 S566C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fp FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC6 FC10{ BC11{ BC9}} FC12{ m FC13{ m Fi[4]} FC14{ m Fi[3]} Fi} Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi[11]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 FC15{ BC16{ BC9}} Fi:1} vd v113 v114 v115 v116 Fi} vd v1 v2 v3 Fi}


 S566C1 ::~S566C1(){ note_dtor("S566C1", this);}
void  S566C1 ::v1(){vfunc_called(this, "_ZN6S566C12v1Ev");}
void  S566C1 ::v2(){vfunc_called(this, "_ZN6S566C12v2Ev");}
void  S566C1 ::v3(){vfunc_called(this, "_ZN6S566C12v3Ev");}
S566C1 ::S566C1(){ note_ctor("S566C1", this);} // tgen

static void Test_S566C1()
{
  extern Class_Descriptor cd_S566C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,52)];
    init_test(&cd_S566C1, buf);
    S566C1 *dp, &lv = *(dp=new (buf) S566C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,204), "sizeof(S566C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S566C1)");
    check_base_class_offset(lv, (S566C5*)(S566C4_nt*)(S566C3_nt*)(S566C2*), 0, "S566C1");
    check_base_class_offset(lv, (S566C4_nt*)(S566C3_nt*)(S566C2*), 0, "S566C1");
    check_base_class_offset(lv, (S566C3_nt*)(S566C2*), 0, "S566C1");
    check_base_class_offset(lv, (S566C2*), 0, "S566C1");
    check_field_offset(lv, s566c1f0, ABISELECT(256,200), "S566C1.s566c1f0");
    test_class_info(&lv, &cd_S566C1);
    dp->~S566C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS566C1(Test_S566C1, "S566C1", ABISELECT(264,204));

#else // __cplusplus

extern void _ZN6S566C1C1Ev();
extern void _ZN6S566C1D1Ev();
Name_Map name_map_S566C1[] = {
  NSPAIR(_ZN6S566C1C1Ev),
  NSPAIR(_ZN6S566C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S566C5;
extern VTBL_ENTRY _ZTI6S566C5[];
extern  VTBL_ENTRY _ZTV6S566C5[];
extern Class_Descriptor cd_S566C4_nt;
extern VTBL_ENTRY _ZTI9S566C4_nt[];
extern  VTBL_ENTRY _ZTV9S566C4_nt[];
extern Class_Descriptor cd_S566C3_nt;
extern VTBL_ENTRY _ZTI9S566C3_nt[];
extern  VTBL_ENTRY _ZTV9S566C3_nt[];
extern Class_Descriptor cd_S566C2;
extern VTBL_ENTRY _ZTI6S566C2[];
extern  VTBL_ENTRY _ZTV6S566C2[];
static Base_Class bases_S566C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S566C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S566C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S566C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S566C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S566C1[];
extern void _ZN6S566C1D1Ev();
extern void _ZN6S566C1D0Ev();
extern void _ZN6S566C52v4Ev();
extern void _ZN6S566C52v5Ev();
extern void _ZN6S566C52v6Ev();
extern void _ZN6S566C52v7Ev();
extern void _ZN6S566C52v8Ev();
extern void _ZN6S566C52v9Ev();
extern void _ZN6S566C53v10Ev();
extern void _ZN6S566C53v11Ev();
extern void _ZN6S566C53v12Ev();
extern void _ZN6S566C53v13Ev();
extern void _ZN6S566C53v14Ev();
extern void _ZN6S566C53v15Ev();
extern void _ZN6S566C53v16Ev();
extern void _ZN6S566C53v17Ev();
extern void _ZN6S566C53v18Ev();
extern void _ZN6S566C53v19Ev();
extern void _ZN6S566C53v20Ev();
extern void _ZN6S566C53v21Ev();
extern void _ZN6S566C53v22Ev();
extern void _ZN6S566C53v23Ev();
extern void _ZN6S566C53v24Ev();
extern void _ZN6S566C53v25Ev();
extern void _ZN6S566C53v26Ev();
extern void _ZN6S566C53v27Ev();
extern void _ZN6S566C53v28Ev();
extern void _ZN6S566C53v29Ev();
extern void _ZN6S566C53v30Ev();
extern void _ZN6S566C53v31Ev();
extern void _ZN6S566C53v32Ev();
extern void _ZN6S566C53v33Ev();
extern void _ZN6S566C53v34Ev();
extern void _ZN6S566C53v35Ev();
extern void _ZN6S566C53v36Ev();
extern void _ZN6S566C53v37Ev();
extern void _ZN6S566C53v38Ev();
extern void _ZN6S566C53v39Ev();
extern void _ZN6S566C53v40Ev();
extern void _ZN6S566C53v41Ev();
extern void _ZN6S566C53v42Ev();
extern void _ZN6S566C53v43Ev();
extern void _ZN6S566C53v44Ev();
extern void _ZN6S566C53v45Ev();
extern void _ZN6S566C53v46Ev();
extern void _ZN6S566C53v47Ev();
extern void _ZN6S566C53v48Ev();
extern void _ZN6S566C53v49Ev();
extern void _ZN6S566C53v50Ev();
extern void _ZN6S566C53v51Ev();
extern void _ZN6S566C53v52Ev();
extern void _ZN6S566C53v53Ev();
extern void _ZN6S566C53v54Ev();
extern void _ZN6S566C53v55Ev();
extern void _ZN6S566C53v56Ev();
extern void _ZN6S566C53v57Ev();
extern void _ZN6S566C53v58Ev();
extern void _ZN6S566C53v59Ev();
extern void _ZN6S566C53v60Ev();
extern void _ZN6S566C53v61Ev();
extern void _ZN6S566C53v62Ev();
extern void _ZN6S566C53v63Ev();
extern void _ZN6S566C53v64Ev();
extern void _ZN6S566C53v65Ev();
extern void _ZN6S566C53v66Ev();
extern void _ZN6S566C53v67Ev();
extern void _ZN9S566C4_nt3v68Ev();
extern void _ZN9S566C4_nt3v69Ev();
extern void _ZN9S566C4_nt3v70Ev();
extern void _ZN9S566C4_nt3v71Ev();
extern void _ZN9S566C4_nt3v72Ev();
extern void _ZN9S566C4_nt3v73Ev();
extern void _ZN9S566C4_nt3v74Ev();
extern void _ZN9S566C4_nt3v75Ev();
extern void _ZN9S566C4_nt3v76Ev();
extern void _ZN9S566C4_nt3v77Ev();
extern void _ZN9S566C4_nt3v78Ev();
extern void _ZN9S566C4_nt3v79Ev();
extern void _ZN9S566C4_nt3v80Ev();
extern void _ZN9S566C4_nt3v81Ev();
extern void _ZN9S566C4_nt3v82Ev();
extern void _ZN9S566C4_nt3v83Ev();
extern void _ZN9S566C4_nt3v84Ev();
extern void _ZN9S566C4_nt3v85Ev();
extern void _ZN9S566C4_nt3v86Ev();
extern void _ZN9S566C4_nt3v87Ev();
extern void _ZN9S566C4_nt3v88Ev();
extern void _ZN9S566C4_nt3v89Ev();
extern void _ZN9S566C4_nt3v90Ev();
extern void _ZN9S566C4_nt3v91Ev();
extern void _ZN9S566C4_nt3v92Ev();
extern void _ZN9S566C4_nt3v93Ev();
extern void _ZN9S566C4_nt3v94Ev();
extern void _ZN9S566C3_nt3v95Ev();
extern void _ZN9S566C3_nt3v96Ev();
extern void _ZN9S566C3_nt3v97Ev();
extern void _ZN9S566C3_nt3v98Ev();
extern void _ZN9S566C3_nt3v99Ev();
extern void _ZN9S566C3_nt4v100Ev();
extern void _ZN9S566C3_nt4v101Ev();
extern void _ZN9S566C3_nt4v102Ev();
extern void _ZN9S566C3_nt4v103Ev();
extern void _ZN9S566C3_nt4v104Ev();
extern void _ZN9S566C3_nt4v105Ev();
extern void _ZN9S566C3_nt4v106Ev();
extern void _ZN9S566C3_nt4v107Ev();
extern void _ZN9S566C3_nt4v108Ev();
extern void _ZN9S566C3_nt4v109Ev();
extern void _ZN9S566C3_nt4v110Ev();
extern void _ZN9S566C3_nt4v111Ev();
extern void _ZN9S566C3_nt4v112Ev();
extern void _ZN6S566C24v113Ev();
extern void _ZN6S566C24v114Ev();
extern void _ZN6S566C24v115Ev();
extern void _ZN6S566C24v116Ev();
extern void _ZN6S566C12v1Ev();
extern void _ZN6S566C12v2Ev();
extern void _ZN6S566C12v3Ev();
static  VTBL_ENTRY vtc_S566C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S566C1[0]),
  (VTBL_ENTRY)&_ZN6S566C1D1Ev,
  (VTBL_ENTRY)&_ZN6S566C1D0Ev,
  (VTBL_ENTRY)&_ZN6S566C52v4Ev,
  (VTBL_ENTRY)&_ZN6S566C52v5Ev,
  (VTBL_ENTRY)&_ZN6S566C52v6Ev,
  (VTBL_ENTRY)&_ZN6S566C52v7Ev,
  (VTBL_ENTRY)&_ZN6S566C52v8Ev,
  (VTBL_ENTRY)&_ZN6S566C52v9Ev,
  (VTBL_ENTRY)&_ZN6S566C53v10Ev,
  (VTBL_ENTRY)&_ZN6S566C53v11Ev,
  (VTBL_ENTRY)&_ZN6S566C53v12Ev,
  (VTBL_ENTRY)&_ZN6S566C53v13Ev,
  (VTBL_ENTRY)&_ZN6S566C53v14Ev,
  (VTBL_ENTRY)&_ZN6S566C53v15Ev,
  (VTBL_ENTRY)&_ZN6S566C53v16Ev,
  (VTBL_ENTRY)&_ZN6S566C53v17Ev,
  (VTBL_ENTRY)&_ZN6S566C53v18Ev,
  (VTBL_ENTRY)&_ZN6S566C53v19Ev,
  (VTBL_ENTRY)&_ZN6S566C53v20Ev,
  (VTBL_ENTRY)&_ZN6S566C53v21Ev,
  (VTBL_ENTRY)&_ZN6S566C53v22Ev,
  (VTBL_ENTRY)&_ZN6S566C53v23Ev,
  (VTBL_ENTRY)&_ZN6S566C53v24Ev,
  (VTBL_ENTRY)&_ZN6S566C53v25Ev,
  (VTBL_ENTRY)&_ZN6S566C53v26Ev,
  (VTBL_ENTRY)&_ZN6S566C53v27Ev,
  (VTBL_ENTRY)&_ZN6S566C53v28Ev,
  (VTBL_ENTRY)&_ZN6S566C53v29Ev,
  (VTBL_ENTRY)&_ZN6S566C53v30Ev,
  (VTBL_ENTRY)&_ZN6S566C53v31Ev,
  (VTBL_ENTRY)&_ZN6S566C53v32Ev,
  (VTBL_ENTRY)&_ZN6S566C53v33Ev,
  (VTBL_ENTRY)&_ZN6S566C53v34Ev,
  (VTBL_ENTRY)&_ZN6S566C53v35Ev,
  (VTBL_ENTRY)&_ZN6S566C53v36Ev,
  (VTBL_ENTRY)&_ZN6S566C53v37Ev,
  (VTBL_ENTRY)&_ZN6S566C53v38Ev,
  (VTBL_ENTRY)&_ZN6S566C53v39Ev,
  (VTBL_ENTRY)&_ZN6S566C53v40Ev,
  (VTBL_ENTRY)&_ZN6S566C53v41Ev,
  (VTBL_ENTRY)&_ZN6S566C53v42Ev,
  (VTBL_ENTRY)&_ZN6S566C53v43Ev,
  (VTBL_ENTRY)&_ZN6S566C53v44Ev,
  (VTBL_ENTRY)&_ZN6S566C53v45Ev,
  (VTBL_ENTRY)&_ZN6S566C53v46Ev,
  (VTBL_ENTRY)&_ZN6S566C53v47Ev,
  (VTBL_ENTRY)&_ZN6S566C53v48Ev,
  (VTBL_ENTRY)&_ZN6S566C53v49Ev,
  (VTBL_ENTRY)&_ZN6S566C53v50Ev,
  (VTBL_ENTRY)&_ZN6S566C53v51Ev,
  (VTBL_ENTRY)&_ZN6S566C53v52Ev,
  (VTBL_ENTRY)&_ZN6S566C53v53Ev,
  (VTBL_ENTRY)&_ZN6S566C53v54Ev,
  (VTBL_ENTRY)&_ZN6S566C53v55Ev,
  (VTBL_ENTRY)&_ZN6S566C53v56Ev,
  (VTBL_ENTRY)&_ZN6S566C53v57Ev,
  (VTBL_ENTRY)&_ZN6S566C53v58Ev,
  (VTBL_ENTRY)&_ZN6S566C53v59Ev,
  (VTBL_ENTRY)&_ZN6S566C53v60Ev,
  (VTBL_ENTRY)&_ZN6S566C53v61Ev,
  (VTBL_ENTRY)&_ZN6S566C53v62Ev,
  (VTBL_ENTRY)&_ZN6S566C53v63Ev,
  (VTBL_ENTRY)&_ZN6S566C53v64Ev,
  (VTBL_ENTRY)&_ZN6S566C53v65Ev,
  (VTBL_ENTRY)&_ZN6S566C53v66Ev,
  (VTBL_ENTRY)&_ZN6S566C53v67Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S566C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S566C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN6S566C24v113Ev,
  (VTBL_ENTRY)&_ZN6S566C24v114Ev,
  (VTBL_ENTRY)&_ZN6S566C24v115Ev,
  (VTBL_ENTRY)&_ZN6S566C24v116Ev,
  (VTBL_ENTRY)&_ZN6S566C12v1Ev,
  (VTBL_ENTRY)&_ZN6S566C12v2Ev,
  (VTBL_ENTRY)&_ZN6S566C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S566C1[];
extern  VTBL_ENTRY _ZTV6S566C1[];
Class_Descriptor cd_S566C1 = {  "S566C1", // class name
  bases_S566C1, 4,
  &(vtc_S566C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,204), // object size
  NSPAIRA(_ZTI6S566C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S566C1),120, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C2_nt  {
  virtual  ~S8644C2_nt(); // _ZN10S8644C2_ntD1Ev
  virtual void  v16(); // _ZN10S8644C2_nt3v16Ev
  virtual void  v17(); // _ZN10S8644C2_nt3v17Ev
  virtual void  v18(); // _ZN10S8644C2_nt3v18Ev
  virtual void  v19(); // _ZN10S8644C2_nt3v19Ev
  virtual void  v20(); // _ZN10S8644C2_nt3v20Ev
  virtual void  v21(); // _ZN10S8644C2_nt3v21Ev
  virtual void  v22(); // _ZN10S8644C2_nt3v22Ev
  virtual void  v23(); // _ZN10S8644C2_nt3v23Ev
  virtual void  v24(); // _ZN10S8644C2_nt3v24Ev
  virtual void  v25(); // _ZN10S8644C2_nt3v25Ev
  virtual void  v26(); // _ZN10S8644C2_nt3v26Ev
  virtual void  v27(); // _ZN10S8644C2_nt3v27Ev
  virtual void  v28(); // _ZN10S8644C2_nt3v28Ev
  virtual void  v29(); // _ZN10S8644C2_nt3v29Ev
  virtual void  v30(); // _ZN10S8644C2_nt3v30Ev
  S8644C2_nt(); // tgen
};
//SIG(-1 S8644C2_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15}


 S8644C2_nt ::~S8644C2_nt(){ note_dtor("S8644C2_nt", this);}
void  S8644C2_nt ::v16(){vfunc_called(this, "_ZN10S8644C2_nt3v16Ev");}
void  S8644C2_nt ::v17(){vfunc_called(this, "_ZN10S8644C2_nt3v17Ev");}
void  S8644C2_nt ::v18(){vfunc_called(this, "_ZN10S8644C2_nt3v18Ev");}
void  S8644C2_nt ::v19(){vfunc_called(this, "_ZN10S8644C2_nt3v19Ev");}
void  S8644C2_nt ::v20(){vfunc_called(this, "_ZN10S8644C2_nt3v20Ev");}
void  S8644C2_nt ::v21(){vfunc_called(this, "_ZN10S8644C2_nt3v21Ev");}
void  S8644C2_nt ::v22(){vfunc_called(this, "_ZN10S8644C2_nt3v22Ev");}
void  S8644C2_nt ::v23(){vfunc_called(this, "_ZN10S8644C2_nt3v23Ev");}
void  S8644C2_nt ::v24(){vfunc_called(this, "_ZN10S8644C2_nt3v24Ev");}
void  S8644C2_nt ::v25(){vfunc_called(this, "_ZN10S8644C2_nt3v25Ev");}
void  S8644C2_nt ::v26(){vfunc_called(this, "_ZN10S8644C2_nt3v26Ev");}
void  S8644C2_nt ::v27(){vfunc_called(this, "_ZN10S8644C2_nt3v27Ev");}
void  S8644C2_nt ::v28(){vfunc_called(this, "_ZN10S8644C2_nt3v28Ev");}
void  S8644C2_nt ::v29(){vfunc_called(this, "_ZN10S8644C2_nt3v29Ev");}
void  S8644C2_nt ::v30(){vfunc_called(this, "_ZN10S8644C2_nt3v30Ev");}
S8644C2_nt ::S8644C2_nt(){ note_ctor("S8644C2_nt", this);} // tgen

//skip512 S8644C2_nt

#else // __cplusplus

extern void _ZN10S8644C2_ntC1Ev();
extern void _ZN10S8644C2_ntD1Ev();
Name_Map name_map_S8644C2_nt[] = {
  NSPAIR(_ZN10S8644C2_ntC1Ev),
  NSPAIR(_ZN10S8644C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S8644C2_nt[];
extern void _ZN10S8644C2_ntD1Ev();
extern void _ZN10S8644C2_ntD0Ev();
extern void _ZN10S8644C2_nt3v16Ev();
extern void _ZN10S8644C2_nt3v17Ev();
extern void _ZN10S8644C2_nt3v18Ev();
extern void _ZN10S8644C2_nt3v19Ev();
extern void _ZN10S8644C2_nt3v20Ev();
extern void _ZN10S8644C2_nt3v21Ev();
extern void _ZN10S8644C2_nt3v22Ev();
extern void _ZN10S8644C2_nt3v23Ev();
extern void _ZN10S8644C2_nt3v24Ev();
extern void _ZN10S8644C2_nt3v25Ev();
extern void _ZN10S8644C2_nt3v26Ev();
extern void _ZN10S8644C2_nt3v27Ev();
extern void _ZN10S8644C2_nt3v28Ev();
extern void _ZN10S8644C2_nt3v29Ev();
extern void _ZN10S8644C2_nt3v30Ev();
static  VTBL_ENTRY vtc_S8644C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S8644C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S8644C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v30Ev,
};
extern VTBL_ENTRY _ZTI10S8644C2_nt[];
VTBL_ENTRY *P__ZTI10S8644C2_nt = _ZTI10S8644C2_nt; 
extern  VTBL_ENTRY _ZTV10S8644C2_nt[];
Class_Descriptor cd_S8644C2_nt = {  "S8644C2_nt", // class name
  0,0,//no base classes
  &(vtc_S8644C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S8644C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S8644C2_nt),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C4_nt  {
  __tsi64 s8644c4f0;
  void  mf8644c4(); // _ZN10S8644C4_nt8mf8644c4Ev
};
//SIG(-1 S8644C4_nt) C1{ m FL}


void  S8644C4_nt ::mf8644c4(){}

//skip512 S8644C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C7_nt  {
  char s8644c7f0;
  char s8644c7f1[15];
  void  mf8644c7(); // _ZN10S8644C7_nt8mf8644c7Ev
};
//SIG(-1 S8644C7_nt) C1{ m Fc[16]}


void  S8644C7_nt ::mf8644c7(){}

//skip512 S8644C7_nt

#else // __cplusplus

Class_Descriptor cd_S8644C7_nt = {  "S8644C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C6_nt  {
  ::S8644C7_nt s8644c6f0;
  ::S8644C7_nt s8644c6f1;
  ::S8644C7_nt s8644c6f2;
  ::S8644C7_nt s8644c6f3;
  void  mf8644c6(); // _ZN10S8644C6_nt8mf8644c6Ev
};
//SIG(-1 S8644C6_nt) C1{ m FC2{ m Fc[16]} FC2 FC2 FC2}


void  S8644C6_nt ::mf8644c6(){}

//skip512 S8644C6_nt

#else // __cplusplus

Class_Descriptor cd_S8644C6_nt = {  "S8644C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  64, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C5_nt  : S8644C6_nt {
};
//SIG(-1 S8644C5_nt) C1{ BC2{ m FC3{ m Fc[16]} FC3 FC3 FC3}}



//skip512 S8644C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S8644C6_nt;
static Base_Class bases_S8644C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C3  {
  char s8644c3f0;
  int s8644c3f1;
  ::S8644C4_nt s8644c3f2;
  ::S8644C5_nt s8644c3f3;
  void  mf8644c3(); // _ZN7S8644C38mf8644c3Ev
};
//SIG(-1 S8644C3) C1{ m Fc Fi FC2{ m FL} FC3{ BC4{ m FC5{ m Fc[16]} FC5 FC5 FC5}}}


void  S8644C3 ::mf8644c3(){}

static void Test_S8644C3()
{
  {
    init_simple_test("S8644C3");
    S8644C3 lv;
    check2(sizeof(lv), 80, "sizeof(S8644C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8644C3)");
    check_field_offset(lv, s8644c3f0, 0, "S8644C3.s8644c3f0");
    check_field_offset(lv, s8644c3f1, 4, "S8644C3.s8644c3f1");
    check_field_offset(lv, s8644c3f2, 8, "S8644C3.s8644c3f2");
    check_field_offset(lv, s8644c3f3, 16, "S8644C3.s8644c3f3");
  }
}
static Arrange_To_Call_Me vS8644C3(Test_S8644C3, "S8644C3", 80);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C8_nt  {
  void *s8644c8f0;
  void  mf8644c8(); // _ZN10S8644C8_nt8mf8644c8Ev
};
//SIG(-1 S8644C8_nt) C1{ m Fp}


void  S8644C8_nt ::mf8644c8(){}

//skip512 S8644C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C10  {
  void *s8644c10f0;
  void  mf8644c10(); // _ZN8S8644C109mf8644c10Ev
};
//SIG(-1 S8644C10) C1{ m Fp}


void  S8644C10 ::mf8644c10(){}

static void Test_S8644C10()
{
  {
    init_simple_test("S8644C10");
    S8644C10 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S8644C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8644C10)");
    check_field_offset(lv, s8644c10f0, 0, "S8644C10.s8644c10f0");
  }
}
static Arrange_To_Call_Me vS8644C10(Test_S8644C10, "S8644C10", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C14_nt  {
};
//SIG(-1 S8644C14_nt) C1{}



//skip512 S8644C14_nt

#else // __cplusplus

Class_Descriptor cd_S8644C14_nt = {  "S8644C14_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C16  {
};
//SIG(-1 S8644C16) C1{}



static void Test_S8644C16()
{
  {
    init_simple_test("S8644C16");
    S8644C16 lv;
    check2(sizeof(lv), 1, "sizeof(S8644C16)");
    check2(__alignof__(lv), 1, "__alignof__(S8644C16)");
  }
}
static Arrange_To_Call_Me vS8644C16(Test_S8644C16, "S8644C16", 1);

#else // __cplusplus

Class_Descriptor cd_S8644C16 = {  "S8644C16", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C15_nt  : S8644C16 {
};
//SIG(-1 S8644C15_nt) C1{ BC2{}}



//skip512 S8644C15_nt

#else // __cplusplus

extern Class_Descriptor cd_S8644C16;
static Base_Class bases_S8644C15_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C13_nt  : S8644C14_nt {
  ::S8644C15_nt s8644c13f0;
};
//SIG(-1 S8644C13_nt) C1{ BC2{} FC3{ BC4{}}}



//skip512 S8644C13_nt

#else // __cplusplus

extern Class_Descriptor cd_S8644C14_nt;
static Base_Class bases_S8644C13_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S8644C13_nt = {  "S8644C13_nt", // class name
  bases_S8644C13_nt, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C12_nt  : S8644C13_nt {
  void *s8644c12f0[3];
};
//SIG(-1 S8644C12_nt) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



//skip512 S8644C12_nt

#else // __cplusplus

extern Class_Descriptor cd_S8644C14_nt;
extern Class_Descriptor cd_S8644C13_nt;
static Base_Class bases_S8644C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S8644C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C11  {
  ::S8644C12_nt s8644c11f0;
  void  mf8644c11(); // _ZN8S8644C119mf8644c11Ev
};
//SIG(-1 S8644C11) C1{ m FC2{ BC3{ BC4{} FC5{ BC6{}}} Fp[3]}}


void  S8644C11 ::mf8644c11(){}

static void Test_S8644C11()
{
  {
    init_simple_test("S8644C11");
    S8644C11 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S8644C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8644C11)");
    check_field_offset(lv, s8644c11f0, 0, "S8644C11.s8644c11f0");
  }
}
static Arrange_To_Call_Me vS8644C11(Test_S8644C11, "S8644C11", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C23  : S8644C14_nt {
  ::S8644C15_nt s8644c23f0;
};
//SIG(-1 S8644C23) C1{ BC2{} FC3{ BC4{}}}



static void Test_S8644C23()
{
  extern Class_Descriptor cd_S8644C23;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S8644C23, buf);
    S8644C23 &lv = *(new (buf) S8644C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S8644C23)");
    check2(__alignof__(lv), 1, "__alignof__(S8644C23)");
    check_base_class_offset(lv, (S8644C14_nt*), 0, "S8644C23");
    check_field_offset(lv, s8644c23f0, 0, "S8644C23.s8644c23f0");
    test_class_info(&lv, &cd_S8644C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8644C23(Test_S8644C23, "S8644C23", 1);

#else // __cplusplus

extern Class_Descriptor cd_S8644C14_nt;
static Base_Class bases_S8644C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S8644C23 = {  "S8644C23", // class name
  bases_S8644C23, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C22  : S8644C23 {
  void *s8644c22f0[3];
};
//SIG(-1 S8644C22) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S8644C22()
{
  extern Class_Descriptor cd_S8644C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S8644C22, buf);
    S8644C22 &lv = *(new (buf) S8644C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S8644C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8644C22)");
    check_base_class_offset(lv, (S8644C14_nt*)(S8644C23*), 0, "S8644C22");
    check_base_class_offset(lv, (S8644C23*), 0, "S8644C22");
    check_field_offset(lv, s8644c22f0, ABISELECT(8,4), "S8644C22.s8644c22f0");
    test_class_info(&lv, &cd_S8644C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8644C22(Test_S8644C22, "S8644C22", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S8644C14_nt;
extern Class_Descriptor cd_S8644C23;
static Base_Class bases_S8644C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S8644C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S8644C22 = {  "S8644C22", // class name
  bases_S8644C22, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C26  {
  void *s8644c26f0;
  void  mf8644c26(); // _ZN8S8644C269mf8644c26Ev
};
//SIG(-1 S8644C26) C1{ m Fp}


void  S8644C26 ::mf8644c26(){}

static void Test_S8644C26()
{
  {
    init_simple_test("S8644C26");
    S8644C26 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S8644C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8644C26)");
    check_field_offset(lv, s8644c26f0, 0, "S8644C26.s8644c26f0");
  }
}
static Arrange_To_Call_Me vS8644C26(Test_S8644C26, "S8644C26", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C27_nt  {
  int s8644c27f0[6];
  void  mf8644c27(); // _ZN11S8644C27_nt9mf8644c27Ev
};
//SIG(-1 S8644C27_nt) C1{ m Fi[6]}


void  S8644C27_nt ::mf8644c27(){}

//skip512 S8644C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C30_nt  : S8644C7_nt {
};
//SIG(-1 S8644C30_nt) C1{ BC2{ m Fc[16]}}



//skip512 S8644C30_nt

#else // __cplusplus

extern Class_Descriptor cd_S8644C7_nt;
static Base_Class bases_S8644C30_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C29  {
  int s8644c29f0[4];
  ::S8644C30_nt s8644c29f1;
};
//SIG(-1 S8644C29) C1{ Fi[4] FC2{ BC3{ m Fc[16]}}}



static void Test_S8644C29()
{
  {
    init_simple_test("S8644C29");
    S8644C29 lv;
    check2(sizeof(lv), 32, "sizeof(S8644C29)");
    check2(__alignof__(lv), 4, "__alignof__(S8644C29)");
    check_field_offset(lv, s8644c29f0, 0, "S8644C29.s8644c29f0");
    check_field_offset(lv, s8644c29f1, 16, "S8644C29.s8644c29f1");
  }
}
static Arrange_To_Call_Me vS8644C29(Test_S8644C29, "S8644C29", 32);

#else // __cplusplus

Class_Descriptor cd_S8644C29 = {  "S8644C29", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  32, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C28  : S8644C29 {
  int s8644c28f0[4];
};
//SIG(-1 S8644C28) C1{ BC2{ Fi[4] FC3{ BC4{ m Fc[16]}}} Fi[4]}



static void Test_S8644C28()
{
  extern Class_Descriptor cd_S8644C28;
  void *lvp;
  {
    int buf[13];
    init_test(&cd_S8644C28, buf);
    S8644C28 &lv = *(new (buf) S8644C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), 48, "sizeof(S8644C28)");
    check2(__alignof__(lv), 4, "__alignof__(S8644C28)");
    check_base_class_offset(lv, (S8644C29*), 0, "S8644C28");
    check_field_offset(lv, s8644c28f0, 32, "S8644C28.s8644c28f0");
    test_class_info(&lv, &cd_S8644C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8644C28(Test_S8644C28, "S8644C28", 48);

#else // __cplusplus

extern Class_Descriptor cd_S8644C29;
static Base_Class bases_S8644C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S8644C28 = {  "S8644C28", // class name
  bases_S8644C28, 1,
  0, // no vftv
  0, //no vtt
  48, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S8644C1  : S8644C2_nt {
  ::S8644C3 s8644c1f0;
  char s8644c1f1[2];
  int s8644c1f2[8];
  ::S8644C8_nt s8644c1f3;
  ::S8644C8_nt s8644c1f4;
  ::S8644C8_nt s8644c1f5;
  ::S8644C8_nt s8644c1f6;
  ::S8644C8_nt s8644c1f7;
  ::S8644C8_nt s8644c1f8;
  ::S8644C8_nt s8644c1f9;
  ::S8644C8_nt s8644c1f10;
  ::S8644C8_nt s8644c1f11;
  ::S8644C8_nt s8644c1f12;
  ::S8644C8_nt s8644c1f13;
  ::S8644C8_nt s8644c1f14;
  void *s8644c1f15;
  ::S8644C10 s8644c1f16;
  ::S8644C10 s8644c1f17;
  ::S8644C10 s8644c1f18;
  ::S8644C10 s8644c1f19;
  ::S8644C10 s8644c1f20;
  ::S8644C11 s8644c1f21;
  ::S8644C11 s8644c1f22;
  ::S8644C11 s8644c1f23;
  ::S8644C11 s8644c1f24;
  ::S8644C11 s8644c1f25;
  void *s8644c1f26[10];
  short s8644c1f27;
  void *s8644c1f28[3];
  ::S8644C10 s8644c1f29;
  ::S8644C12_nt s8644c1f30;
  ::S8644C22 s8644c1f31;
  void *s8644c1f32;
  ::S8644C26 s8644c1f33;
  ::S8644C26 s8644c1f34;
  ::S8644C26 s8644c1f35;
  ::S8644C26 s8644c1f36;
  int s8644c1f37;
  void *s8644c1f38;
  char s8644c1f39[17];
  int s8644c1f40[16];
  ::S8644C27_nt s8644c1f41;
  ::S8644C27_nt s8644c1f42;
  ::S8644C28 s8644c1f43;
  ::S1502C14_nt s8644c1f44;
  ::S1502C14_nt s8644c1f45;
  int s8644c1f46[69];
  char s8644c1f47[3];
  int s8644c1f48;
  char s8644c1f49[2];
  ::S8644C26 s8644c1f50;
  void *s8644c1f51[2];
  ::S8644C22 s8644c1f52;
  virtual  ~S8644C1(); // _ZN7S8644C1D1Ev
  virtual void  v1(); // _ZN7S8644C12v1Ev
  virtual void  v2(); // _ZN7S8644C12v2Ev
  virtual void  v3(); // _ZN7S8644C12v3Ev
  virtual void  v4(); // _ZN7S8644C12v4Ev
  virtual void  v5(); // _ZN7S8644C12v5Ev
  virtual void  v6(); // _ZN7S8644C12v6Ev
  virtual void  v7(); // _ZN7S8644C12v7Ev
  virtual void  v8(); // _ZN7S8644C12v8Ev
  virtual void  v9(); // _ZN7S8644C12v9Ev
  virtual void  v10(); // _ZN7S8644C13v10Ev
  virtual void  v11(); // _ZN7S8644C13v11Ev
  virtual void  v12(); // _ZN7S8644C13v12Ev
  virtual void  v13(); // _ZN7S8644C13v13Ev
  virtual void  v14(); // _ZN7S8644C13v14Ev
  virtual void  v15(); // _ZN7S8644C13v15Ev
  S8644C1(); // tgen
};
//SIG(1 S8644C1) C1{ BC2{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC3{ m Fc Fi FC4{ m FL} FC5{ BC6{ m FC7{ m Fc[16]} FC7 FC7 FC7}}} Fc[2] Fi[8] FC8{ m Fp} FC8 FC8 FC8 FC8 FC8 FC8 FC8 FC8 FC8 FC8 FC8 Fp FC9{ m Fp} FC9 FC9 FC9 FC9 FC10{ m FC11{ BC12{ BC13{} FC14{ BC15{}}} Fp[3]}} FC10 FC10 FC10 FC10 Fp[10] Fs Fp[3] FC9 FC11 FC16{ BC17{ BC13 FC14} Fp[3]} Fp FC18{ m Fp} FC18 FC18 FC18 Fi Fp Fc[17] Fi[16] FC19{ m Fi[6]} FC19 FC20{ BC21{ Fi[4] FC22{ BC7}} Fi[4]} FC23{ m Fi[3]} FC23 Fi[69] Fc[3] Fi Fc[2] FC18 Fp[2] FC16}


 S8644C1 ::~S8644C1(){ note_dtor("S8644C1", this);}
void  S8644C1 ::v1(){vfunc_called(this, "_ZN7S8644C12v1Ev");}
void  S8644C1 ::v2(){vfunc_called(this, "_ZN7S8644C12v2Ev");}
void  S8644C1 ::v3(){vfunc_called(this, "_ZN7S8644C12v3Ev");}
void  S8644C1 ::v4(){vfunc_called(this, "_ZN7S8644C12v4Ev");}
void  S8644C1 ::v5(){vfunc_called(this, "_ZN7S8644C12v5Ev");}
void  S8644C1 ::v6(){vfunc_called(this, "_ZN7S8644C12v6Ev");}
void  S8644C1 ::v7(){vfunc_called(this, "_ZN7S8644C12v7Ev");}
void  S8644C1 ::v8(){vfunc_called(this, "_ZN7S8644C12v8Ev");}
void  S8644C1 ::v9(){vfunc_called(this, "_ZN7S8644C12v9Ev");}
void  S8644C1 ::v10(){vfunc_called(this, "_ZN7S8644C13v10Ev");}
void  S8644C1 ::v11(){vfunc_called(this, "_ZN7S8644C13v11Ev");}
void  S8644C1 ::v12(){vfunc_called(this, "_ZN7S8644C13v12Ev");}
void  S8644C1 ::v13(){vfunc_called(this, "_ZN7S8644C13v13Ev");}
void  S8644C1 ::v14(){vfunc_called(this, "_ZN7S8644C13v14Ev");}
void  S8644C1 ::v15(){vfunc_called(this, "_ZN7S8644C13v15Ev");}
S8644C1 ::S8644C1(){ note_ctor("S8644C1", this);} // tgen

static void Test_S8644C1()
{
  extern Class_Descriptor cd_S8644C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(154,229)];
    init_test(&cd_S8644C1, buf);
    S8644C1 *dp, &lv = *(dp=new (buf) S8644C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1224,912), "sizeof(S8644C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S8644C1)");
    check_base_class_offset(lv, (S8644C2_nt*), 0, "S8644C1");
    check_field_offset(lv, s8644c1f0, ABISELECT(8,4), "S8644C1.s8644c1f0");
    check_field_offset(lv, s8644c1f1, ABISELECT(88,84), "S8644C1.s8644c1f1");
    check_field_offset(lv, s8644c1f2, ABISELECT(92,88), "S8644C1.s8644c1f2");
    check_field_offset(lv, s8644c1f3, ABISELECT(128,120), "S8644C1.s8644c1f3");
    check_field_offset(lv, s8644c1f4, ABISELECT(136,124), "S8644C1.s8644c1f4");
    check_field_offset(lv, s8644c1f5, ABISELECT(144,128), "S8644C1.s8644c1f5");
    check_field_offset(lv, s8644c1f6, ABISELECT(152,132), "S8644C1.s8644c1f6");
    check_field_offset(lv, s8644c1f7, ABISELECT(160,136), "S8644C1.s8644c1f7");
    check_field_offset(lv, s8644c1f8, ABISELECT(168,140), "S8644C1.s8644c1f8");
    check_field_offset(lv, s8644c1f9, ABISELECT(176,144), "S8644C1.s8644c1f9");
    check_field_offset(lv, s8644c1f10, ABISELECT(184,148), "S8644C1.s8644c1f10");
    check_field_offset(lv, s8644c1f11, ABISELECT(192,152), "S8644C1.s8644c1f11");
    check_field_offset(lv, s8644c1f12, ABISELECT(200,156), "S8644C1.s8644c1f12");
    check_field_offset(lv, s8644c1f13, ABISELECT(208,160), "S8644C1.s8644c1f13");
    check_field_offset(lv, s8644c1f14, ABISELECT(216,164), "S8644C1.s8644c1f14");
    check_field_offset(lv, s8644c1f15, ABISELECT(224,168), "S8644C1.s8644c1f15");
    check_field_offset(lv, s8644c1f16, ABISELECT(232,172), "S8644C1.s8644c1f16");
    check_field_offset(lv, s8644c1f17, ABISELECT(240,176), "S8644C1.s8644c1f17");
    check_field_offset(lv, s8644c1f18, ABISELECT(248,180), "S8644C1.s8644c1f18");
    check_field_offset(lv, s8644c1f19, ABISELECT(256,184), "S8644C1.s8644c1f19");
    check_field_offset(lv, s8644c1f20, ABISELECT(264,188), "S8644C1.s8644c1f20");
    check_field_offset(lv, s8644c1f21, ABISELECT(272,192), "S8644C1.s8644c1f21");
    check_field_offset(lv, s8644c1f22, ABISELECT(304,208), "S8644C1.s8644c1f22");
    check_field_offset(lv, s8644c1f23, ABISELECT(336,224), "S8644C1.s8644c1f23");
    check_field_offset(lv, s8644c1f24, ABISELECT(368,240), "S8644C1.s8644c1f24");
    check_field_offset(lv, s8644c1f25, ABISELECT(400,256), "S8644C1.s8644c1f25");
    check_field_offset(lv, s8644c1f26, ABISELECT(432,272), "S8644C1.s8644c1f26");
    check_field_offset(lv, s8644c1f27, ABISELECT(512,312), "S8644C1.s8644c1f27");
    check_field_offset(lv, s8644c1f28, ABISELECT(520,316), "S8644C1.s8644c1f28");
    check_field_offset(lv, s8644c1f29, ABISELECT(544,328), "S8644C1.s8644c1f29");
    check_field_offset(lv, s8644c1f30, ABISELECT(552,332), "S8644C1.s8644c1f30");
    check_field_offset(lv, s8644c1f31, ABISELECT(584,348), "S8644C1.s8644c1f31");
    check_field_offset(lv, s8644c1f32, ABISELECT(616,364), "S8644C1.s8644c1f32");
    check_field_offset(lv, s8644c1f33, ABISELECT(624,368), "S8644C1.s8644c1f33");
    check_field_offset(lv, s8644c1f34, ABISELECT(632,372), "S8644C1.s8644c1f34");
    check_field_offset(lv, s8644c1f35, ABISELECT(640,376), "S8644C1.s8644c1f35");
    check_field_offset(lv, s8644c1f36, ABISELECT(648,380), "S8644C1.s8644c1f36");
    check_field_offset(lv, s8644c1f37, ABISELECT(656,384), "S8644C1.s8644c1f37");
    check_field_offset(lv, s8644c1f38, ABISELECT(664,388), "S8644C1.s8644c1f38");
    check_field_offset(lv, s8644c1f39, ABISELECT(672,392), "S8644C1.s8644c1f39");
    check_field_offset(lv, s8644c1f40, ABISELECT(692,412), "S8644C1.s8644c1f40");
    check_field_offset(lv, s8644c1f41, ABISELECT(756,476), "S8644C1.s8644c1f41");
    check_field_offset(lv, s8644c1f42, ABISELECT(780,500), "S8644C1.s8644c1f42");
    check_field_offset(lv, s8644c1f43, ABISELECT(804,524), "S8644C1.s8644c1f43");
    check_field_offset(lv, s8644c1f44, ABISELECT(852,572), "S8644C1.s8644c1f44");
    check_field_offset(lv, s8644c1f45, ABISELECT(864,584), "S8644C1.s8644c1f45");
    check_field_offset(lv, s8644c1f46, ABISELECT(876,596), "S8644C1.s8644c1f46");
    check_field_offset(lv, s8644c1f47, ABISELECT(1152,872), "S8644C1.s8644c1f47");
    check_field_offset(lv, s8644c1f48, ABISELECT(1156,876), "S8644C1.s8644c1f48");
    check_field_offset(lv, s8644c1f49, ABISELECT(1160,880), "S8644C1.s8644c1f49");
    check_field_offset(lv, s8644c1f50, ABISELECT(1168,884), "S8644C1.s8644c1f50");
    check_field_offset(lv, s8644c1f51, ABISELECT(1176,888), "S8644C1.s8644c1f51");
    check_field_offset(lv, s8644c1f52, ABISELECT(1192,896), "S8644C1.s8644c1f52");
    test_class_info(&lv, &cd_S8644C1);
    dp->~S8644C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS8644C1(Test_S8644C1, "S8644C1", ABISELECT(1224,912));

#else // __cplusplus

extern void _ZN7S8644C1C1Ev();
extern void _ZN7S8644C1D1Ev();
Name_Map name_map_S8644C1[] = {
  NSPAIR(_ZN7S8644C1C1Ev),
  NSPAIR(_ZN7S8644C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S8644C2_nt;
extern VTBL_ENTRY _ZTI10S8644C2_nt[];
extern  VTBL_ENTRY _ZTV10S8644C2_nt[];
static Base_Class bases_S8644C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S8644C1[];
extern void _ZN7S8644C1D1Ev();
extern void _ZN7S8644C1D0Ev();
extern void _ZN10S8644C2_nt3v16Ev();
extern void _ZN10S8644C2_nt3v17Ev();
extern void _ZN10S8644C2_nt3v18Ev();
extern void _ZN10S8644C2_nt3v19Ev();
extern void _ZN10S8644C2_nt3v20Ev();
extern void _ZN10S8644C2_nt3v21Ev();
extern void _ZN10S8644C2_nt3v22Ev();
extern void _ZN10S8644C2_nt3v23Ev();
extern void _ZN10S8644C2_nt3v24Ev();
extern void _ZN10S8644C2_nt3v25Ev();
extern void _ZN10S8644C2_nt3v26Ev();
extern void _ZN10S8644C2_nt3v27Ev();
extern void _ZN10S8644C2_nt3v28Ev();
extern void _ZN10S8644C2_nt3v29Ev();
extern void _ZN10S8644C2_nt3v30Ev();
extern void _ZN7S8644C12v1Ev();
extern void _ZN7S8644C12v2Ev();
extern void _ZN7S8644C12v3Ev();
extern void _ZN7S8644C12v4Ev();
extern void _ZN7S8644C12v5Ev();
extern void _ZN7S8644C12v6Ev();
extern void _ZN7S8644C12v7Ev();
extern void _ZN7S8644C12v8Ev();
extern void _ZN7S8644C12v9Ev();
extern void _ZN7S8644C13v10Ev();
extern void _ZN7S8644C13v11Ev();
extern void _ZN7S8644C13v12Ev();
extern void _ZN7S8644C13v13Ev();
extern void _ZN7S8644C13v14Ev();
extern void _ZN7S8644C13v15Ev();
static  VTBL_ENTRY vtc_S8644C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S8644C1[0]),
  (VTBL_ENTRY)&_ZN7S8644C1D1Ev,
  (VTBL_ENTRY)&_ZN7S8644C1D0Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S8644C2_nt3v30Ev,
  (VTBL_ENTRY)&_ZN7S8644C12v1Ev,
  (VTBL_ENTRY)&_ZN7S8644C12v2Ev,
  (VTBL_ENTRY)&_ZN7S8644C12v3Ev,
  (VTBL_ENTRY)&_ZN7S8644C12v4Ev,
  (VTBL_ENTRY)&_ZN7S8644C12v5Ev,
  (VTBL_ENTRY)&_ZN7S8644C12v6Ev,
  (VTBL_ENTRY)&_ZN7S8644C12v7Ev,
  (VTBL_ENTRY)&_ZN7S8644C12v8Ev,
  (VTBL_ENTRY)&_ZN7S8644C12v9Ev,
  (VTBL_ENTRY)&_ZN7S8644C13v10Ev,
  (VTBL_ENTRY)&_ZN7S8644C13v11Ev,
  (VTBL_ENTRY)&_ZN7S8644C13v12Ev,
  (VTBL_ENTRY)&_ZN7S8644C13v13Ev,
  (VTBL_ENTRY)&_ZN7S8644C13v14Ev,
  (VTBL_ENTRY)&_ZN7S8644C13v15Ev,
};
extern VTBL_ENTRY _ZTI7S8644C1[];
extern  VTBL_ENTRY _ZTV7S8644C1[];
Class_Descriptor cd_S8644C1 = {  "S8644C1", // class name
  bases_S8644C1, 1,
  &(vtc_S8644C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1224,912), // object size
  NSPAIRA(_ZTI7S8644C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S8644C1),34, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9646C8_nt  {
  void *s9646c8f0;
  int s9646c8f1;
  void  mf9646c8(); // _ZN10S9646C8_nt8mf9646c8Ev
};
//SIG(-1 S9646C8_nt) C1{ m Fp Fi}


void  S9646C8_nt ::mf9646c8(){}

//skip512 S9646C8_nt

#else // __cplusplus

Class_Descriptor cd_S9646C8_nt = {  "S9646C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S9646C9  {
  int s9646c9f0;
  int s9646c9f1;
  int s9646c9f2;
};
//SIG(1 S9646C9) U1{ Fi Fi Fi}

#endif // __cplusplus
#ifdef __cplusplus

struct  S9646C3  {
  ::S8644C26 s9646c3f0;
  void *s9646c3f1;
  char s9646c3f2[8];
  int s9646c3f3;
  void *s9646c3f4;
  ::S8644C5_nt s9646c3f5;
  ::S8644C5_nt s9646c3f6;
  ::S8644C5_nt s9646c3f7;
  ::S8644C5_nt s9646c3f8;
  ::S8644C5_nt s9646c3f9;
  ::S8644C5_nt s9646c3f10;
  ::S8644C5_nt s9646c3f11;
  ::S8644C5_nt s9646c3f12;
  ::S8644C5_nt s9646c3f13;
  ::S8644C5_nt s9646c3f14;
  int s9646c3f15;
  ::S9646C8_nt s9646c3f16[2];
  ::S9646C8_nt s9646c3f17[2];
  void *s9646c3f18;
  __tsi64 s9646c3f19[16];
  int s9646c3f20;
  void *s9646c3f21;
  int s9646c3f22;
  char s9646c3f23;
  int s9646c3f24[2];
  char s9646c3f25;
  int s9646c3f26[8];
  char s9646c3f27[3];
  int s9646c3f28;
  ::S9646C9 s9646c3f29;
  void  mf9646c3(); // _ZN7S9646C38mf9646c3Ev
};
//SIG(-1 S9646C3) C1{ m FC2{ m Fp} Fp Fc[8] Fi Fp FC3{ BC4{ m FC5{ m Fc[16]} FC5 FC5 FC5}} FC3 FC3 FC3 FC3 FC3 FC3 FC3 FC3 FC3 Fi FC6{ m Fp Fi}[2] FC6[2] Fp FL[16] Fi Fp Fi Fc Fi[2] Fc Fi[8] Fc[3] Fi FU7{ Fi Fi Fi}}


void  S9646C3 ::mf9646c3(){}

static void Test_S9646C3()
{
  {
    init_simple_test("S9646C3");
    S9646C3 lv;
    check2(sizeof(lv), ABISELECT(968,904), "sizeof(S9646C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9646C3)");
    check_field_offset(lv, s9646c3f0, 0, "S9646C3.s9646c3f0");
    check_field_offset(lv, s9646c3f1, ABISELECT(8,4), "S9646C3.s9646c3f1");
    check_field_offset(lv, s9646c3f2, ABISELECT(16,8), "S9646C3.s9646c3f2");
    check_field_offset(lv, s9646c3f3, ABISELECT(24,16), "S9646C3.s9646c3f3");
    check_field_offset(lv, s9646c3f4, ABISELECT(32,20), "S9646C3.s9646c3f4");
    check_field_offset(lv, s9646c3f5, ABISELECT(40,24), "S9646C3.s9646c3f5");
    check_field_offset(lv, s9646c3f6, ABISELECT(104,88), "S9646C3.s9646c3f6");
    check_field_offset(lv, s9646c3f7, ABISELECT(168,152), "S9646C3.s9646c3f7");
    check_field_offset(lv, s9646c3f8, ABISELECT(232,216), "S9646C3.s9646c3f8");
    check_field_offset(lv, s9646c3f9, ABISELECT(296,280), "S9646C3.s9646c3f9");
    check_field_offset(lv, s9646c3f10, ABISELECT(360,344), "S9646C3.s9646c3f10");
    check_field_offset(lv, s9646c3f11, ABISELECT(424,408), "S9646C3.s9646c3f11");
    check_field_offset(lv, s9646c3f12, ABISELECT(488,472), "S9646C3.s9646c3f12");
    check_field_offset(lv, s9646c3f13, ABISELECT(552,536), "S9646C3.s9646c3f13");
    check_field_offset(lv, s9646c3f14, ABISELECT(616,600), "S9646C3.s9646c3f14");
    check_field_offset(lv, s9646c3f15, ABISELECT(680,664), "S9646C3.s9646c3f15");
    check_field_offset(lv, s9646c3f16, ABISELECT(688,668), "S9646C3.s9646c3f16");
    check_field_offset(lv, s9646c3f17, ABISELECT(720,684), "S9646C3.s9646c3f17");
    check_field_offset(lv, s9646c3f18, ABISELECT(752,700), "S9646C3.s9646c3f18");
    check_field_offset(lv, s9646c3f19, ABISELECT(760,704), "S9646C3.s9646c3f19");
    check_field_offset(lv, s9646c3f20, ABISELECT(888,832), "S9646C3.s9646c3f20");
    check_field_offset(lv, s9646c3f21, ABISELECT(896,836), "S9646C3.s9646c3f21");
    check_field_offset(lv, s9646c3f22, ABISELECT(904,840), "S9646C3.s9646c3f22");
    check_field_offset(lv, s9646c3f23, ABISELECT(908,844), "S9646C3.s9646c3f23");
    check_field_offset(lv, s9646c3f24, ABISELECT(912,848), "S9646C3.s9646c3f24");
    check_field_offset(lv, s9646c3f25, ABISELECT(920,856), "S9646C3.s9646c3f25");
    check_field_offset(lv, s9646c3f26, ABISELECT(924,860), "S9646C3.s9646c3f26");
    check_field_offset(lv, s9646c3f27, ABISELECT(956,892), "S9646C3.s9646c3f27");
    check_field_offset(lv, s9646c3f28, ABISELECT(960,896), "S9646C3.s9646c3f28");
    check_field_offset(lv, s9646c3f29, ABISELECT(964,900), "S9646C3.s9646c3f29");
  }
}
static Arrange_To_Call_Me vS9646C3(Test_S9646C3, "S9646C3", ABISELECT(968,904));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9646C11  : S8644C16 {
  ::S8644C15_nt s9646c11f0;
};
//SIG(-1 S9646C11) C1{ BC2{} FC3{ BC2}}



static void Test_S9646C11()
{
  extern Class_Descriptor cd_S9646C11;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S9646C11, buf);
    S9646C11 &lv = *(new (buf) S9646C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S9646C11)");
    check2(__alignof__(lv), 1, "__alignof__(S9646C11)");
    check_base_class_offset(lv, (S8644C16*), 0, "S9646C11");
    check_field_offset(lv, s9646c11f0, 1, "S9646C11.s9646c11f0");
    test_class_info(&lv, &cd_S9646C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9646C11(Test_S9646C11, "S9646C11", 2);

#else // __cplusplus

extern Class_Descriptor cd_S8644C16;
static Base_Class bases_S9646C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S9646C11 = {  "S9646C11", // class name
  bases_S9646C11, 1,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9646C10_nt  : S9646C11 {
  void *s9646c10f0;
  void *s9646c10f1;
  void *s9646c10f2;
};
//SIG(-1 S9646C10_nt) C1{ BC2{ BC3{} FC4{ BC3}} Fp[3]}



//skip512 S9646C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S8644C16;
extern Class_Descriptor cd_S9646C11;
static Base_Class bases_S9646C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S9646C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9646C15  {
  ::S8644C4_nt s9646c15f0;
  ::S8644C4_nt s9646c15f1;
  ::S8644C4_nt s9646c15f2;
  void *s9646c15f3;
  char s9646c15f4;
  void  mf9646c15(); // _ZN8S9646C159mf9646c15Ev
};
//SIG(-1 S9646C15) C1{ m FC2{ m FL} FC2 FC2 Fp Fc}


void  S9646C15 ::mf9646c15(){}

static void Test_S9646C15()
{
  {
    init_simple_test("S9646C15");
    S9646C15 lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(S9646C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9646C15)");
    check_field_offset(lv, s9646c15f0, 0, "S9646C15.s9646c15f0");
    check_field_offset(lv, s9646c15f1, 8, "S9646C15.s9646c15f1");
    check_field_offset(lv, s9646c15f2, 16, "S9646C15.s9646c15f2");
    check_field_offset(lv, s9646c15f3, 24, "S9646C15.s9646c15f3");
    check_field_offset(lv, s9646c15f4, ABISELECT(32,28), "S9646C15.s9646c15f4");
  }
}
static Arrange_To_Call_Me vS9646C15(Test_S9646C15, "S9646C15", ABISELECT(40,32));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9646C2  {
  ::S9646C3 s9646c2f0;
  ::S9646C10_nt s9646c2f1;
  void *s9646c2f2;
  ::S9646C15 s9646c2f3;
  ::S8644C10 s9646c2f4;
  void *s9646c2f5;
  void *s9646c2f6;
  void *s9646c2f7;
  void *s9646c2f8;
  void *s9646c2f9;
  void *s9646c2f10;
  void *s9646c2f11;
  void *s9646c2f12;
  void *s9646c2f13;
  char s9646c2f14;
  void *s9646c2f15;
  virtual  ~S9646C2(); // _ZN7S9646C2D1Ev
  virtual void  v36(); // _ZN7S9646C23v36Ev
  virtual void  v37(); // _ZN7S9646C23v37Ev
  virtual void  v38(); // _ZN7S9646C23v38Ev
  virtual void  v39(); // _ZN7S9646C23v39Ev
  virtual void  v40(); // _ZN7S9646C23v40Ev
  virtual void  v41(); // _ZN7S9646C23v41Ev
  virtual void  v42(); // _ZN7S9646C23v42Ev
  virtual void  v43(); // _ZN7S9646C23v43Ev
  virtual void  v44(); // _ZN7S9646C23v44Ev
  virtual void  v45(); // _ZN7S9646C23v45Ev
  virtual void  v46(); // _ZN7S9646C23v46Ev
  virtual void  v47(); // _ZN7S9646C23v47Ev
  virtual void  v48(); // _ZN7S9646C23v48Ev
  virtual void  v49(); // _ZN7S9646C23v49Ev
  virtual void  v50(); // _ZN7S9646C23v50Ev
  virtual void  v51(); // _ZN7S9646C23v51Ev
  virtual void  v52(); // _ZN7S9646C23v52Ev
  virtual void  v53(); // _ZN7S9646C23v53Ev
  virtual void  v54(); // _ZN7S9646C23v54Ev
  virtual void  v55(); // _ZN7S9646C23v55Ev
  virtual void  v56(); // _ZN7S9646C23v56Ev
  virtual void  v57(); // _ZN7S9646C23v57Ev
  virtual void  v58(); // _ZN7S9646C23v58Ev
  virtual void  v59(); // _ZN7S9646C23v59Ev
  virtual void  v60(); // _ZN7S9646C23v60Ev
  virtual void  v61(); // _ZN7S9646C23v61Ev
  virtual void  v62(); // _ZN7S9646C23v62Ev
  virtual void  v63(); // _ZN7S9646C23v63Ev
  virtual void  v64(); // _ZN7S9646C23v64Ev
  virtual void  v65(); // _ZN7S9646C23v65Ev
  virtual void  v66(); // _ZN7S9646C23v66Ev
  virtual void  v67(); // _ZN7S9646C23v67Ev
  virtual void  v68(); // _ZN7S9646C23v68Ev
  virtual void  v69(); // _ZN7S9646C23v69Ev
  virtual void  v70(); // _ZN7S9646C23v70Ev
  virtual void  v71(); // _ZN7S9646C23v71Ev
  virtual void  v72(); // _ZN7S9646C23v72Ev
  virtual void  v73(); // _ZN7S9646C23v73Ev
  S9646C2(); // tgen
};
//SIG(-1 S9646C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 FC2{ m FC3{ m Fp} Fp Fc[8] Fi Fp FC4{ BC5{ m FC6{ m Fc[16]} FC6 FC6 FC6}} FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 Fi FC7{ m Fp Fi}[2] FC7[2] Fp FL[16] Fi Fp Fi Fc Fi[2] Fc Fi[8] Fc[3] Fi FU8{ Fi Fi Fi}} FC9{ BC10{ BC11{} FC12{ BC11}} Fp Fp Fp} Fp FC13{ m FC14{ m FL} FC14 FC14 Fp Fc} FC15{ m Fp} Fp Fp Fp Fp Fp Fp Fp Fp Fp Fc Fp}


 S9646C2 ::~S9646C2(){ note_dtor("S9646C2", this);}
void  S9646C2 ::v36(){vfunc_called(this, "_ZN7S9646C23v36Ev");}
void  S9646C2 ::v37(){vfunc_called(this, "_ZN7S9646C23v37Ev");}
void  S9646C2 ::v38(){vfunc_called(this, "_ZN7S9646C23v38Ev");}
void  S9646C2 ::v39(){vfunc_called(this, "_ZN7S9646C23v39Ev");}
void  S9646C2 ::v40(){vfunc_called(this, "_ZN7S9646C23v40Ev");}
void  S9646C2 ::v41(){vfunc_called(this, "_ZN7S9646C23v41Ev");}
void  S9646C2 ::v42(){vfunc_called(this, "_ZN7S9646C23v42Ev");}
void  S9646C2 ::v43(){vfunc_called(this, "_ZN7S9646C23v43Ev");}
void  S9646C2 ::v44(){vfunc_called(this, "_ZN7S9646C23v44Ev");}
void  S9646C2 ::v45(){vfunc_called(this, "_ZN7S9646C23v45Ev");}
void  S9646C2 ::v46(){vfunc_called(this, "_ZN7S9646C23v46Ev");}
void  S9646C2 ::v47(){vfunc_called(this, "_ZN7S9646C23v47Ev");}
void  S9646C2 ::v48(){vfunc_called(this, "_ZN7S9646C23v48Ev");}
void  S9646C2 ::v49(){vfunc_called(this, "_ZN7S9646C23v49Ev");}
void  S9646C2 ::v50(){vfunc_called(this, "_ZN7S9646C23v50Ev");}
void  S9646C2 ::v51(){vfunc_called(this, "_ZN7S9646C23v51Ev");}
void  S9646C2 ::v52(){vfunc_called(this, "_ZN7S9646C23v52Ev");}
void  S9646C2 ::v53(){vfunc_called(this, "_ZN7S9646C23v53Ev");}
void  S9646C2 ::v54(){vfunc_called(this, "_ZN7S9646C23v54Ev");}
void  S9646C2 ::v55(){vfunc_called(this, "_ZN7S9646C23v55Ev");}
void  S9646C2 ::v56(){vfunc_called(this, "_ZN7S9646C23v56Ev");}
void  S9646C2 ::v57(){vfunc_called(this, "_ZN7S9646C23v57Ev");}
void  S9646C2 ::v58(){vfunc_called(this, "_ZN7S9646C23v58Ev");}
void  S9646C2 ::v59(){vfunc_called(this, "_ZN7S9646C23v59Ev");}
void  S9646C2 ::v60(){vfunc_called(this, "_ZN7S9646C23v60Ev");}
void  S9646C2 ::v61(){vfunc_called(this, "_ZN7S9646C23v61Ev");}
void  S9646C2 ::v62(){vfunc_called(this, "_ZN7S9646C23v62Ev");}
void  S9646C2 ::v63(){vfunc_called(this, "_ZN7S9646C23v63Ev");}
void  S9646C2 ::v64(){vfunc_called(this, "_ZN7S9646C23v64Ev");}
void  S9646C2 ::v65(){vfunc_called(this, "_ZN7S9646C23v65Ev");}
void  S9646C2 ::v66(){vfunc_called(this, "_ZN7S9646C23v66Ev");}
void  S9646C2 ::v67(){vfunc_called(this, "_ZN7S9646C23v67Ev");}
void  S9646C2 ::v68(){vfunc_called(this, "_ZN7S9646C23v68Ev");}
void  S9646C2 ::v69(){vfunc_called(this, "_ZN7S9646C23v69Ev");}
void  S9646C2 ::v70(){vfunc_called(this, "_ZN7S9646C23v70Ev");}
void  S9646C2 ::v71(){vfunc_called(this, "_ZN7S9646C23v71Ev");}
void  S9646C2 ::v72(){vfunc_called(this, "_ZN7S9646C23v72Ev");}
void  S9646C2 ::v73(){vfunc_called(this, "_ZN7S9646C23v73Ev");}
S9646C2 ::S9646C2(){ note_ctor("S9646C2", this);} // tgen

static void Test_S9646C2()
{
  extern Class_Descriptor cd_S9646C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(145,253)];
    init_test(&cd_S9646C2, buf);
    S9646C2 *dp, &lv = *(dp=new (buf) S9646C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1152,1008), "sizeof(S9646C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9646C2)");
    check_field_offset(lv, s9646c2f0, ABISELECT(8,4), "S9646C2.s9646c2f0");
    check_field_offset(lv, s9646c2f1, ABISELECT(976,908), "S9646C2.s9646c2f1");
    check_field_offset(lv, s9646c2f2, ABISELECT(1008,924), "S9646C2.s9646c2f2");
    check_field_offset(lv, s9646c2f3, ABISELECT(1016,928), "S9646C2.s9646c2f3");
    check_field_offset(lv, s9646c2f4, ABISELECT(1056,960), "S9646C2.s9646c2f4");
    check_field_offset(lv, s9646c2f5, ABISELECT(1064,964), "S9646C2.s9646c2f5");
    check_field_offset(lv, s9646c2f6, ABISELECT(1072,968), "S9646C2.s9646c2f6");
    check_field_offset(lv, s9646c2f7, ABISELECT(1080,972), "S9646C2.s9646c2f7");
    check_field_offset(lv, s9646c2f8, ABISELECT(1088,976), "S9646C2.s9646c2f8");
    check_field_offset(lv, s9646c2f9, ABISELECT(1096,980), "S9646C2.s9646c2f9");
    check_field_offset(lv, s9646c2f10, ABISELECT(1104,984), "S9646C2.s9646c2f10");
    check_field_offset(lv, s9646c2f11, ABISELECT(1112,988), "S9646C2.s9646c2f11");
    check_field_offset(lv, s9646c2f12, ABISELECT(1120,992), "S9646C2.s9646c2f12");
    check_field_offset(lv, s9646c2f13, ABISELECT(1128,996), "S9646C2.s9646c2f13");
    check_field_offset(lv, s9646c2f14, ABISELECT(1136,1000), "S9646C2.s9646c2f14");
    check_field_offset(lv, s9646c2f15, ABISELECT(1144,1004), "S9646C2.s9646c2f15");
    test_class_info(&lv, &cd_S9646C2);
    dp->~S9646C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9646C2(Test_S9646C2, "S9646C2", ABISELECT(1152,1008));

#else // __cplusplus

extern void _ZN7S9646C2C1Ev();
extern void _ZN7S9646C2D1Ev();
Name_Map name_map_S9646C2[] = {
  NSPAIR(_ZN7S9646C2C1Ev),
  NSPAIR(_ZN7S9646C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9646C2[];
extern void _ZN7S9646C2D1Ev();
extern void _ZN7S9646C2D0Ev();
extern void _ZN7S9646C23v36Ev();
extern void _ZN7S9646C23v37Ev();
extern void _ZN7S9646C23v38Ev();
extern void _ZN7S9646C23v39Ev();
extern void _ZN7S9646C23v40Ev();
extern void _ZN7S9646C23v41Ev();
extern void _ZN7S9646C23v42Ev();
extern void _ZN7S9646C23v43Ev();
extern void _ZN7S9646C23v44Ev();
extern void _ZN7S9646C23v45Ev();
extern void _ZN7S9646C23v46Ev();
extern void _ZN7S9646C23v47Ev();
extern void _ZN7S9646C23v48Ev();
extern void _ZN7S9646C23v49Ev();
extern void _ZN7S9646C23v50Ev();
extern void _ZN7S9646C23v51Ev();
extern void _ZN7S9646C23v52Ev();
extern void _ZN7S9646C23v53Ev();
extern void _ZN7S9646C23v54Ev();
extern void _ZN7S9646C23v55Ev();
extern void _ZN7S9646C23v56Ev();
extern void _ZN7S9646C23v57Ev();
extern void _ZN7S9646C23v58Ev();
extern void _ZN7S9646C23v59Ev();
extern void _ZN7S9646C23v60Ev();
extern void _ZN7S9646C23v61Ev();
extern void _ZN7S9646C23v62Ev();
extern void _ZN7S9646C23v63Ev();
extern void _ZN7S9646C23v64Ev();
extern void _ZN7S9646C23v65Ev();
extern void _ZN7S9646C23v66Ev();
extern void _ZN7S9646C23v67Ev();
extern void _ZN7S9646C23v68Ev();
extern void _ZN7S9646C23v69Ev();
extern void _ZN7S9646C23v70Ev();
extern void _ZN7S9646C23v71Ev();
extern void _ZN7S9646C23v72Ev();
extern void _ZN7S9646C23v73Ev();
static  VTBL_ENTRY vtc_S9646C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9646C2[0]),
  (VTBL_ENTRY)&_ZN7S9646C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9646C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v36Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v37Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v38Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v39Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v40Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v41Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v42Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v43Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v44Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v45Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v46Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v47Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v48Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v49Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v50Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v51Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v52Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v53Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v54Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v55Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v56Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v57Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v58Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v59Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v60Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v61Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v62Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v63Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v64Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v65Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v66Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v67Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v68Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v69Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v70Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v71Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v72Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v73Ev,
};
extern VTBL_ENTRY _ZTI7S9646C2[];
extern  VTBL_ENTRY _ZTV7S9646C2[];
Class_Descriptor cd_S9646C2 = {  "S9646C2", // class name
  0,0,//no base classes
  &(vtc_S9646C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1152,1008), // object size
  NSPAIRA(_ZTI7S9646C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9646C2),42, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9646C1  : S9646C2 {
  int s9646c1f0;
  int s9646c1f1;
  int s9646c1f2;
  void *s9646c1f3;
  int s9646c1f4;
  virtual  ~S9646C1(); // _ZN7S9646C1D1Ev
  virtual void  v1(); // _ZN7S9646C12v1Ev
  virtual void  v2(); // _ZN7S9646C12v2Ev
  virtual void  v3(); // _ZN7S9646C12v3Ev
  virtual void  v4(); // _ZN7S9646C12v4Ev
  virtual void  v5(); // _ZN7S9646C12v5Ev
  virtual void  v6(); // _ZN7S9646C12v6Ev
  virtual void  v7(); // _ZN7S9646C12v7Ev
  virtual void  v8(); // _ZN7S9646C12v8Ev
  virtual void  v9(); // _ZN7S9646C12v9Ev
  virtual void  v10(); // _ZN7S9646C13v10Ev
  virtual void  v11(); // _ZN7S9646C13v11Ev
  virtual void  v12(); // _ZN7S9646C13v12Ev
  virtual void  v13(); // _ZN7S9646C13v13Ev
  virtual void  v14(); // _ZN7S9646C13v14Ev
  virtual void  v15(); // _ZN7S9646C13v15Ev
  virtual void  v16(); // _ZN7S9646C13v16Ev
  virtual void  v17(); // _ZN7S9646C13v17Ev
  virtual void  v18(); // _ZN7S9646C13v18Ev
  virtual void  v19(); // _ZN7S9646C13v19Ev
  virtual void  v20(); // _ZN7S9646C13v20Ev
  virtual void  v21(); // _ZN7S9646C13v21Ev
  virtual void  v22(); // _ZN7S9646C13v22Ev
  virtual void  v23(); // _ZN7S9646C13v23Ev
  virtual void  v24(); // _ZN7S9646C13v24Ev
  virtual void  v25(); // _ZN7S9646C13v25Ev
  virtual void  v26(); // _ZN7S9646C13v26Ev
  virtual void  v27(); // _ZN7S9646C13v27Ev
  virtual void  v28(); // _ZN7S9646C13v28Ev
  virtual void  v29(); // _ZN7S9646C13v29Ev
  virtual void  v30(); // _ZN7S9646C13v30Ev
  virtual void  v31(); // _ZN7S9646C13v31Ev
  virtual void  v32(); // _ZN7S9646C13v32Ev
  virtual void  v33(); // _ZN7S9646C13v33Ev
  virtual void  v34(); // _ZN7S9646C13v34Ev
  virtual void  v35(); // _ZN7S9646C13v35Ev
  S9646C1(); // tgen
};
//SIG(1 S9646C1) C1{ BC2{ vd v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 FC3{ m FC4{ m Fp} Fp Fc[8] Fi Fp FC5{ BC6{ m FC7{ m Fc[16]} FC7 FC7 FC7}} FC5 FC5 FC5 FC5 FC5 FC5 FC5 FC5 FC5 Fi FC8{ m Fp Fi}[2] FC8[2] Fp FL[16] Fi Fp Fi Fc Fi[2] Fc Fi[8] Fc[3] Fi FU9{ Fi Fi Fi}} FC10{ BC11{ BC12{} FC13{ BC12}} Fp Fp Fp} Fp FC14{ m FC15{ m FL} FC15 FC15 Fp Fc} FC16{ m Fp} Fp Fp Fp Fp Fp Fp Fp Fp Fp Fc Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 Fi Fi Fi Fp Fi}


 S9646C1 ::~S9646C1(){ note_dtor("S9646C1", this);}
void  S9646C1 ::v1(){vfunc_called(this, "_ZN7S9646C12v1Ev");}
void  S9646C1 ::v2(){vfunc_called(this, "_ZN7S9646C12v2Ev");}
void  S9646C1 ::v3(){vfunc_called(this, "_ZN7S9646C12v3Ev");}
void  S9646C1 ::v4(){vfunc_called(this, "_ZN7S9646C12v4Ev");}
void  S9646C1 ::v5(){vfunc_called(this, "_ZN7S9646C12v5Ev");}
void  S9646C1 ::v6(){vfunc_called(this, "_ZN7S9646C12v6Ev");}
void  S9646C1 ::v7(){vfunc_called(this, "_ZN7S9646C12v7Ev");}
void  S9646C1 ::v8(){vfunc_called(this, "_ZN7S9646C12v8Ev");}
void  S9646C1 ::v9(){vfunc_called(this, "_ZN7S9646C12v9Ev");}
void  S9646C1 ::v10(){vfunc_called(this, "_ZN7S9646C13v10Ev");}
void  S9646C1 ::v11(){vfunc_called(this, "_ZN7S9646C13v11Ev");}
void  S9646C1 ::v12(){vfunc_called(this, "_ZN7S9646C13v12Ev");}
void  S9646C1 ::v13(){vfunc_called(this, "_ZN7S9646C13v13Ev");}
void  S9646C1 ::v14(){vfunc_called(this, "_ZN7S9646C13v14Ev");}
void  S9646C1 ::v15(){vfunc_called(this, "_ZN7S9646C13v15Ev");}
void  S9646C1 ::v16(){vfunc_called(this, "_ZN7S9646C13v16Ev");}
void  S9646C1 ::v17(){vfunc_called(this, "_ZN7S9646C13v17Ev");}
void  S9646C1 ::v18(){vfunc_called(this, "_ZN7S9646C13v18Ev");}
void  S9646C1 ::v19(){vfunc_called(this, "_ZN7S9646C13v19Ev");}
void  S9646C1 ::v20(){vfunc_called(this, "_ZN7S9646C13v20Ev");}
void  S9646C1 ::v21(){vfunc_called(this, "_ZN7S9646C13v21Ev");}
void  S9646C1 ::v22(){vfunc_called(this, "_ZN7S9646C13v22Ev");}
void  S9646C1 ::v23(){vfunc_called(this, "_ZN7S9646C13v23Ev");}
void  S9646C1 ::v24(){vfunc_called(this, "_ZN7S9646C13v24Ev");}
void  S9646C1 ::v25(){vfunc_called(this, "_ZN7S9646C13v25Ev");}
void  S9646C1 ::v26(){vfunc_called(this, "_ZN7S9646C13v26Ev");}
void  S9646C1 ::v27(){vfunc_called(this, "_ZN7S9646C13v27Ev");}
void  S9646C1 ::v28(){vfunc_called(this, "_ZN7S9646C13v28Ev");}
void  S9646C1 ::v29(){vfunc_called(this, "_ZN7S9646C13v29Ev");}
void  S9646C1 ::v30(){vfunc_called(this, "_ZN7S9646C13v30Ev");}
void  S9646C1 ::v31(){vfunc_called(this, "_ZN7S9646C13v31Ev");}
void  S9646C1 ::v32(){vfunc_called(this, "_ZN7S9646C13v32Ev");}
void  S9646C1 ::v33(){vfunc_called(this, "_ZN7S9646C13v33Ev");}
void  S9646C1 ::v34(){vfunc_called(this, "_ZN7S9646C13v34Ev");}
void  S9646C1 ::v35(){vfunc_called(this, "_ZN7S9646C13v35Ev");}
S9646C1 ::S9646C1(){ note_ctor("S9646C1", this);} // tgen

static void Test_S9646C1()
{
  extern Class_Descriptor cd_S9646C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(149,258)];
    init_test(&cd_S9646C1, buf);
    S9646C1 *dp, &lv = *(dp=new (buf) S9646C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1184,1028), "sizeof(S9646C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9646C1)");
    check_base_class_offset(lv, (S9646C2*), 0, "S9646C1");
    check_field_offset(lv, s9646c1f0, ABISELECT(1152,1008), "S9646C1.s9646c1f0");
    check_field_offset(lv, s9646c1f1, ABISELECT(1156,1012), "S9646C1.s9646c1f1");
    check_field_offset(lv, s9646c1f2, ABISELECT(1160,1016), "S9646C1.s9646c1f2");
    check_field_offset(lv, s9646c1f3, ABISELECT(1168,1020), "S9646C1.s9646c1f3");
    check_field_offset(lv, s9646c1f4, ABISELECT(1176,1024), "S9646C1.s9646c1f4");
    test_class_info(&lv, &cd_S9646C1);
    dp->~S9646C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9646C1(Test_S9646C1, "S9646C1", ABISELECT(1184,1028));

#else // __cplusplus

extern void _ZN7S9646C1C1Ev();
extern void _ZN7S9646C1D1Ev();
Name_Map name_map_S9646C1[] = {
  NSPAIR(_ZN7S9646C1C1Ev),
  NSPAIR(_ZN7S9646C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9646C2;
extern VTBL_ENTRY _ZTI7S9646C2[];
extern  VTBL_ENTRY _ZTV7S9646C2[];
static Base_Class bases_S9646C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9646C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9646C1[];
extern void _ZN7S9646C1D1Ev();
extern void _ZN7S9646C1D0Ev();
extern void _ZN7S9646C23v36Ev();
extern void _ZN7S9646C23v37Ev();
extern void _ZN7S9646C23v38Ev();
extern void _ZN7S9646C23v39Ev();
extern void _ZN7S9646C23v40Ev();
extern void _ZN7S9646C23v41Ev();
extern void _ZN7S9646C23v42Ev();
extern void _ZN7S9646C23v43Ev();
extern void _ZN7S9646C23v44Ev();
extern void _ZN7S9646C23v45Ev();
extern void _ZN7S9646C23v46Ev();
extern void _ZN7S9646C23v47Ev();
extern void _ZN7S9646C23v48Ev();
extern void _ZN7S9646C23v49Ev();
extern void _ZN7S9646C23v50Ev();
extern void _ZN7S9646C23v51Ev();
extern void _ZN7S9646C23v52Ev();
extern void _ZN7S9646C23v53Ev();
extern void _ZN7S9646C23v54Ev();
extern void _ZN7S9646C23v55Ev();
extern void _ZN7S9646C23v56Ev();
extern void _ZN7S9646C23v57Ev();
extern void _ZN7S9646C23v58Ev();
extern void _ZN7S9646C23v59Ev();
extern void _ZN7S9646C23v60Ev();
extern void _ZN7S9646C23v61Ev();
extern void _ZN7S9646C23v62Ev();
extern void _ZN7S9646C23v63Ev();
extern void _ZN7S9646C23v64Ev();
extern void _ZN7S9646C23v65Ev();
extern void _ZN7S9646C23v66Ev();
extern void _ZN7S9646C23v67Ev();
extern void _ZN7S9646C23v68Ev();
extern void _ZN7S9646C23v69Ev();
extern void _ZN7S9646C23v70Ev();
extern void _ZN7S9646C23v71Ev();
extern void _ZN7S9646C23v72Ev();
extern void _ZN7S9646C23v73Ev();
extern void _ZN7S9646C12v1Ev();
extern void _ZN7S9646C12v2Ev();
extern void _ZN7S9646C12v3Ev();
extern void _ZN7S9646C12v4Ev();
extern void _ZN7S9646C12v5Ev();
extern void _ZN7S9646C12v6Ev();
extern void _ZN7S9646C12v7Ev();
extern void _ZN7S9646C12v8Ev();
extern void _ZN7S9646C12v9Ev();
extern void _ZN7S9646C13v10Ev();
extern void _ZN7S9646C13v11Ev();
extern void _ZN7S9646C13v12Ev();
extern void _ZN7S9646C13v13Ev();
extern void _ZN7S9646C13v14Ev();
extern void _ZN7S9646C13v15Ev();
extern void _ZN7S9646C13v16Ev();
extern void _ZN7S9646C13v17Ev();
extern void _ZN7S9646C13v18Ev();
extern void _ZN7S9646C13v19Ev();
extern void _ZN7S9646C13v20Ev();
extern void _ZN7S9646C13v21Ev();
extern void _ZN7S9646C13v22Ev();
extern void _ZN7S9646C13v23Ev();
extern void _ZN7S9646C13v24Ev();
extern void _ZN7S9646C13v25Ev();
extern void _ZN7S9646C13v26Ev();
extern void _ZN7S9646C13v27Ev();
extern void _ZN7S9646C13v28Ev();
extern void _ZN7S9646C13v29Ev();
extern void _ZN7S9646C13v30Ev();
extern void _ZN7S9646C13v31Ev();
extern void _ZN7S9646C13v32Ev();
extern void _ZN7S9646C13v33Ev();
extern void _ZN7S9646C13v34Ev();
extern void _ZN7S9646C13v35Ev();
static  VTBL_ENTRY vtc_S9646C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9646C1[0]),
  (VTBL_ENTRY)&_ZN7S9646C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9646C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v36Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v37Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v38Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v39Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v40Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v41Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v42Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v43Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v44Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v45Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v46Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v47Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v48Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v49Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v50Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v51Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v52Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v53Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v54Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v55Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v56Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v57Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v58Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v59Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v60Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v61Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v62Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v63Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v64Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v65Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v66Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v67Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v68Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v69Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v70Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v71Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v72Ev,
  (VTBL_ENTRY)&_ZN7S9646C23v73Ev,
  (VTBL_ENTRY)&_ZN7S9646C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9646C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9646C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9646C12v4Ev,
  (VTBL_ENTRY)&_ZN7S9646C12v5Ev,
  (VTBL_ENTRY)&_ZN7S9646C12v6Ev,
  (VTBL_ENTRY)&_ZN7S9646C12v7Ev,
  (VTBL_ENTRY)&_ZN7S9646C12v8Ev,
  (VTBL_ENTRY)&_ZN7S9646C12v9Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v10Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v11Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v12Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v13Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v14Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v15Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v16Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v17Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v18Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v19Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v20Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v21Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v22Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v23Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v24Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v25Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v26Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v27Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v28Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v29Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v30Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v31Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v32Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v33Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v34Ev,
  (VTBL_ENTRY)&_ZN7S9646C13v35Ev,
};
extern VTBL_ENTRY _ZTI7S9646C1[];
extern  VTBL_ENTRY _ZTV7S9646C1[];
Class_Descriptor cd_S9646C1 = {  "S9646C1", // class name
  bases_S9646C1, 1,
  &(vtc_S9646C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1184,1028), // object size
  NSPAIRA(_ZTI7S9646C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9646C1),77, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1597C4  {
  int s1597c4f0;
  __tsi64 s1597c4f1;
  void *s1597c4f2[4];
  int s1597c4f3[2];
  void *s1597c4f4;
  ::S1502C5_nt s1597c4f5;
  void *s1597c4f6[2];
  virtual  ~S1597C4(); // _ZN7S1597C4D1Ev
  virtual void  v9(); // _ZN7S1597C42v9Ev
  virtual void  v10(); // _ZN7S1597C43v10Ev
  virtual void  v11(); // _ZN7S1597C43v11Ev
  virtual void  v12(); // _ZN7S1597C43v12Ev
  virtual void  v13(); // _ZN7S1597C43v13Ev
  virtual void  v14(); // _ZN7S1597C43v14Ev
  virtual void  v15(); // _ZN7S1597C43v15Ev
  virtual void  v16(); // _ZN7S1597C43v16Ev
  virtual void  v17(); // _ZN7S1597C43v17Ev
  virtual void  v18(); // _ZN7S1597C43v18Ev
  virtual void  v19(); // _ZN7S1597C43v19Ev
  virtual void  v20(); // _ZN7S1597C43v20Ev
  virtual void  v21(); // _ZN7S1597C43v21Ev
  virtual void  v22(); // _ZN7S1597C43v22Ev
  virtual void  v23(); // _ZN7S1597C43v23Ev
  virtual void  v24(); // _ZN7S1597C43v24Ev
  virtual void  v25(); // _ZN7S1597C43v25Ev
  virtual void  v26(); // _ZN7S1597C43v26Ev
  virtual void  v27(); // _ZN7S1597C43v27Ev
  virtual void  v28(); // _ZN7S1597C43v28Ev
  virtual void  v29(); // _ZN7S1597C43v29Ev
  virtual void  v30(); // _ZN7S1597C43v30Ev
  virtual void  v31(); // _ZN7S1597C43v31Ev
  virtual void  v32(); // _ZN7S1597C43v32Ev
  virtual void  v33(); // _ZN7S1597C43v33Ev
  virtual void  v34(); // _ZN7S1597C43v34Ev
  virtual void  v35(); // _ZN7S1597C43v35Ev
  virtual void  v36(); // _ZN7S1597C43v36Ev
  virtual void  v37(); // _ZN7S1597C43v37Ev
  virtual void  v38(); // _ZN7S1597C43v38Ev
  virtual void  v39(); // _ZN7S1597C43v39Ev
  virtual void  v40(); // _ZN7S1597C43v40Ev
  virtual void  v41(); // _ZN7S1597C43v41Ev
  virtual void  v42(); // _ZN7S1597C43v42Ev
  virtual void  v43(); // _ZN7S1597C43v43Ev
  virtual void  v44(); // _ZN7S1597C43v44Ev
  virtual void  v45(); // _ZN7S1597C43v45Ev
  virtual void  v46(); // _ZN7S1597C43v46Ev
  virtual void  v47(); // _ZN7S1597C43v47Ev
  virtual void  v48(); // _ZN7S1597C43v48Ev
  virtual void  v49(); // _ZN7S1597C43v49Ev
  virtual void  v50(); // _ZN7S1597C43v50Ev
  virtual void  v51(); // _ZN7S1597C43v51Ev
  virtual void  v52(); // _ZN7S1597C43v52Ev
  virtual void  v53(); // _ZN7S1597C43v53Ev
  virtual void  v54(); // _ZN7S1597C43v54Ev
  virtual void  v55(); // _ZN7S1597C43v55Ev
  virtual void  v56(); // _ZN7S1597C43v56Ev
  virtual void  v57(); // _ZN7S1597C43v57Ev
  virtual void  v58(); // _ZN7S1597C43v58Ev
  virtual void  v59(); // _ZN7S1597C43v59Ev
  virtual void  v60(); // _ZN7S1597C43v60Ev
  virtual void  v61(); // _ZN7S1597C43v61Ev
  virtual void  v62(); // _ZN7S1597C43v62Ev
  virtual void  v63(); // _ZN7S1597C43v63Ev
  virtual void  v64(); // _ZN7S1597C43v64Ev
  virtual void  v65(); // _ZN7S1597C43v65Ev
  virtual void  v66(); // _ZN7S1597C43v66Ev
  virtual void  v67(); // _ZN7S1597C43v67Ev
  virtual void  v68(); // _ZN7S1597C43v68Ev
  virtual void  v69(); // _ZN7S1597C43v69Ev
  virtual void  v70(); // _ZN7S1597C43v70Ev
  virtual void  v71(); // _ZN7S1597C43v71Ev
  virtual void  v72(); // _ZN7S1597C43v72Ev
  S1597C4(); // tgen
};
//SIG(-1 S1597C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1597C4 ::~S1597C4(){ note_dtor("S1597C4", this);}
void  S1597C4 ::v9(){vfunc_called(this, "_ZN7S1597C42v9Ev");}
void  S1597C4 ::v10(){vfunc_called(this, "_ZN7S1597C43v10Ev");}
void  S1597C4 ::v11(){vfunc_called(this, "_ZN7S1597C43v11Ev");}
void  S1597C4 ::v12(){vfunc_called(this, "_ZN7S1597C43v12Ev");}
void  S1597C4 ::v13(){vfunc_called(this, "_ZN7S1597C43v13Ev");}
void  S1597C4 ::v14(){vfunc_called(this, "_ZN7S1597C43v14Ev");}
void  S1597C4 ::v15(){vfunc_called(this, "_ZN7S1597C43v15Ev");}
void  S1597C4 ::v16(){vfunc_called(this, "_ZN7S1597C43v16Ev");}
void  S1597C4 ::v17(){vfunc_called(this, "_ZN7S1597C43v17Ev");}
void  S1597C4 ::v18(){vfunc_called(this, "_ZN7S1597C43v18Ev");}
void  S1597C4 ::v19(){vfunc_called(this, "_ZN7S1597C43v19Ev");}
void  S1597C4 ::v20(){vfunc_called(this, "_ZN7S1597C43v20Ev");}
void  S1597C4 ::v21(){vfunc_called(this, "_ZN7S1597C43v21Ev");}
void  S1597C4 ::v22(){vfunc_called(this, "_ZN7S1597C43v22Ev");}
void  S1597C4 ::v23(){vfunc_called(this, "_ZN7S1597C43v23Ev");}
void  S1597C4 ::v24(){vfunc_called(this, "_ZN7S1597C43v24Ev");}
void  S1597C4 ::v25(){vfunc_called(this, "_ZN7S1597C43v25Ev");}
void  S1597C4 ::v26(){vfunc_called(this, "_ZN7S1597C43v26Ev");}
void  S1597C4 ::v27(){vfunc_called(this, "_ZN7S1597C43v27Ev");}
void  S1597C4 ::v28(){vfunc_called(this, "_ZN7S1597C43v28Ev");}
void  S1597C4 ::v29(){vfunc_called(this, "_ZN7S1597C43v29Ev");}
void  S1597C4 ::v30(){vfunc_called(this, "_ZN7S1597C43v30Ev");}
void  S1597C4 ::v31(){vfunc_called(this, "_ZN7S1597C43v31Ev");}
void  S1597C4 ::v32(){vfunc_called(this, "_ZN7S1597C43v32Ev");}
void  S1597C4 ::v33(){vfunc_called(this, "_ZN7S1597C43v33Ev");}
void  S1597C4 ::v34(){vfunc_called(this, "_ZN7S1597C43v34Ev");}
void  S1597C4 ::v35(){vfunc_called(this, "_ZN7S1597C43v35Ev");}
void  S1597C4 ::v36(){vfunc_called(this, "_ZN7S1597C43v36Ev");}
void  S1597C4 ::v37(){vfunc_called(this, "_ZN7S1597C43v37Ev");}
void  S1597C4 ::v38(){vfunc_called(this, "_ZN7S1597C43v38Ev");}
void  S1597C4 ::v39(){vfunc_called(this, "_ZN7S1597C43v39Ev");}
void  S1597C4 ::v40(){vfunc_called(this, "_ZN7S1597C43v40Ev");}
void  S1597C4 ::v41(){vfunc_called(this, "_ZN7S1597C43v41Ev");}
void  S1597C4 ::v42(){vfunc_called(this, "_ZN7S1597C43v42Ev");}
void  S1597C4 ::v43(){vfunc_called(this, "_ZN7S1597C43v43Ev");}
void  S1597C4 ::v44(){vfunc_called(this, "_ZN7S1597C43v44Ev");}
void  S1597C4 ::v45(){vfunc_called(this, "_ZN7S1597C43v45Ev");}
void  S1597C4 ::v46(){vfunc_called(this, "_ZN7S1597C43v46Ev");}
void  S1597C4 ::v47(){vfunc_called(this, "_ZN7S1597C43v47Ev");}
void  S1597C4 ::v48(){vfunc_called(this, "_ZN7S1597C43v48Ev");}
void  S1597C4 ::v49(){vfunc_called(this, "_ZN7S1597C43v49Ev");}
void  S1597C4 ::v50(){vfunc_called(this, "_ZN7S1597C43v50Ev");}
void  S1597C4 ::v51(){vfunc_called(this, "_ZN7S1597C43v51Ev");}
void  S1597C4 ::v52(){vfunc_called(this, "_ZN7S1597C43v52Ev");}
void  S1597C4 ::v53(){vfunc_called(this, "_ZN7S1597C43v53Ev");}
void  S1597C4 ::v54(){vfunc_called(this, "_ZN7S1597C43v54Ev");}
void  S1597C4 ::v55(){vfunc_called(this, "_ZN7S1597C43v55Ev");}
void  S1597C4 ::v56(){vfunc_called(this, "_ZN7S1597C43v56Ev");}
void  S1597C4 ::v57(){vfunc_called(this, "_ZN7S1597C43v57Ev");}
void  S1597C4 ::v58(){vfunc_called(this, "_ZN7S1597C43v58Ev");}
void  S1597C4 ::v59(){vfunc_called(this, "_ZN7S1597C43v59Ev");}
void  S1597C4 ::v60(){vfunc_called(this, "_ZN7S1597C43v60Ev");}
void  S1597C4 ::v61(){vfunc_called(this, "_ZN7S1597C43v61Ev");}
void  S1597C4 ::v62(){vfunc_called(this, "_ZN7S1597C43v62Ev");}
void  S1597C4 ::v63(){vfunc_called(this, "_ZN7S1597C43v63Ev");}
void  S1597C4 ::v64(){vfunc_called(this, "_ZN7S1597C43v64Ev");}
void  S1597C4 ::v65(){vfunc_called(this, "_ZN7S1597C43v65Ev");}
void  S1597C4 ::v66(){vfunc_called(this, "_ZN7S1597C43v66Ev");}
void  S1597C4 ::v67(){vfunc_called(this, "_ZN7S1597C43v67Ev");}
void  S1597C4 ::v68(){vfunc_called(this, "_ZN7S1597C43v68Ev");}
void  S1597C4 ::v69(){vfunc_called(this, "_ZN7S1597C43v69Ev");}
void  S1597C4 ::v70(){vfunc_called(this, "_ZN7S1597C43v70Ev");}
void  S1597C4 ::v71(){vfunc_called(this, "_ZN7S1597C43v71Ev");}
void  S1597C4 ::v72(){vfunc_called(this, "_ZN7S1597C43v72Ev");}
S1597C4 ::S1597C4(){ note_ctor("S1597C4", this);} // tgen

static void Test_S1597C4()
{
  extern Class_Descriptor cd_S1597C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1597C4, buf);
    S1597C4 *dp, &lv = *(dp=new (buf) S1597C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1597C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1597C4)");
    check_field_offset(lv, s1597c4f0, ABISELECT(8,4), "S1597C4.s1597c4f0");
    check_field_offset(lv, s1597c4f1, ABISELECT(16,8), "S1597C4.s1597c4f1");
    check_field_offset(lv, s1597c4f2, ABISELECT(24,16), "S1597C4.s1597c4f2");
    check_field_offset(lv, s1597c4f3, ABISELECT(56,32), "S1597C4.s1597c4f3");
    check_field_offset(lv, s1597c4f4, ABISELECT(64,40), "S1597C4.s1597c4f4");
    check_field_offset(lv, s1597c4f5, ABISELECT(72,44), "S1597C4.s1597c4f5");
    check_field_offset(lv, s1597c4f6, ABISELECT(80,52), "S1597C4.s1597c4f6");
    test_class_info(&lv, &cd_S1597C4);
    dp->~S1597C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1597C4(Test_S1597C4, "S1597C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1597C4C1Ev();
extern void _ZN7S1597C4D1Ev();
Name_Map name_map_S1597C4[] = {
  NSPAIR(_ZN7S1597C4C1Ev),
  NSPAIR(_ZN7S1597C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1597C4[];
extern void _ZN7S1597C4D1Ev();
extern void _ZN7S1597C4D0Ev();
extern void _ZN7S1597C42v9Ev();
extern void _ZN7S1597C43v10Ev();
extern void _ZN7S1597C43v11Ev();
extern void _ZN7S1597C43v12Ev();
extern void _ZN7S1597C43v13Ev();
extern void _ZN7S1597C43v14Ev();
extern void _ZN7S1597C43v15Ev();
extern void _ZN7S1597C43v16Ev();
extern void _ZN7S1597C43v17Ev();
extern void _ZN7S1597C43v18Ev();
extern void _ZN7S1597C43v19Ev();
extern void _ZN7S1597C43v20Ev();
extern void _ZN7S1597C43v21Ev();
extern void _ZN7S1597C43v22Ev();
extern void _ZN7S1597C43v23Ev();
extern void _ZN7S1597C43v24Ev();
extern void _ZN7S1597C43v25Ev();
extern void _ZN7S1597C43v26Ev();
extern void _ZN7S1597C43v27Ev();
extern void _ZN7S1597C43v28Ev();
extern void _ZN7S1597C43v29Ev();
extern void _ZN7S1597C43v30Ev();
extern void _ZN7S1597C43v31Ev();
extern void _ZN7S1597C43v32Ev();
extern void _ZN7S1597C43v33Ev();
extern void _ZN7S1597C43v34Ev();
extern void _ZN7S1597C43v35Ev();
extern void _ZN7S1597C43v36Ev();
extern void _ZN7S1597C43v37Ev();
extern void _ZN7S1597C43v38Ev();
extern void _ZN7S1597C43v39Ev();
extern void _ZN7S1597C43v40Ev();
extern void _ZN7S1597C43v41Ev();
extern void _ZN7S1597C43v42Ev();
extern void _ZN7S1597C43v43Ev();
extern void _ZN7S1597C43v44Ev();
extern void _ZN7S1597C43v45Ev();
extern void _ZN7S1597C43v46Ev();
extern void _ZN7S1597C43v47Ev();
extern void _ZN7S1597C43v48Ev();
extern void _ZN7S1597C43v49Ev();
extern void _ZN7S1597C43v50Ev();
extern void _ZN7S1597C43v51Ev();
extern void _ZN7S1597C43v52Ev();
extern void _ZN7S1597C43v53Ev();
extern void _ZN7S1597C43v54Ev();
extern void _ZN7S1597C43v55Ev();
extern void _ZN7S1597C43v56Ev();
extern void _ZN7S1597C43v57Ev();
extern void _ZN7S1597C43v58Ev();
extern void _ZN7S1597C43v59Ev();
extern void _ZN7S1597C43v60Ev();
extern void _ZN7S1597C43v61Ev();
extern void _ZN7S1597C43v62Ev();
extern void _ZN7S1597C43v63Ev();
extern void _ZN7S1597C43v64Ev();
extern void _ZN7S1597C43v65Ev();
extern void _ZN7S1597C43v66Ev();
extern void _ZN7S1597C43v67Ev();
extern void _ZN7S1597C43v68Ev();
extern void _ZN7S1597C43v69Ev();
extern void _ZN7S1597C43v70Ev();
extern void _ZN7S1597C43v71Ev();
extern void _ZN7S1597C43v72Ev();
static  VTBL_ENTRY vtc_S1597C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1597C4[0]),
  (VTBL_ENTRY)&_ZN7S1597C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1597C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1597C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v72Ev,
};
extern VTBL_ENTRY _ZTI7S1597C4[];
extern  VTBL_ENTRY _ZTV7S1597C4[];
Class_Descriptor cd_S1597C4 = {  "S1597C4", // class name
  0,0,//no base classes
  &(vtc_S1597C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1597C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1597C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1597C3_nt  : S1597C4 {
  unsigned int s1597c3f0:1;
  unsigned int s1597c3f1:1;
  unsigned int s1597c3f2:1;
  unsigned int s1597c3f3:1;
  unsigned int s1597c3f4:1;
  unsigned int s1597c3f5:1;
  unsigned int s1597c3f6:1;
  ::S578C11_nt s1597c3f7;
  virtual  ~S1597C3_nt(); // _ZN10S1597C3_ntD1Ev
  virtual void  v73(); // _ZN10S1597C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1597C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1597C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1597C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1597C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1597C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1597C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1597C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1597C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1597C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1597C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1597C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1597C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1597C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1597C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1597C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1597C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1597C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1597C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1597C3_nt3v92Ev
  S1597C3_nt(); // tgen
};
//SIG(-1 S1597C3_nt) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1597C3_nt ::~S1597C3_nt(){ note_dtor("S1597C3_nt", this);}
void  S1597C3_nt ::v73(){vfunc_called(this, "_ZN10S1597C3_nt3v73Ev");}
void  S1597C3_nt ::v74(){vfunc_called(this, "_ZN10S1597C3_nt3v74Ev");}
void  S1597C3_nt ::v75(){vfunc_called(this, "_ZN10S1597C3_nt3v75Ev");}
void  S1597C3_nt ::v76(){vfunc_called(this, "_ZN10S1597C3_nt3v76Ev");}
void  S1597C3_nt ::v77(){vfunc_called(this, "_ZN10S1597C3_nt3v77Ev");}
void  S1597C3_nt ::v78(){vfunc_called(this, "_ZN10S1597C3_nt3v78Ev");}
void  S1597C3_nt ::v79(){vfunc_called(this, "_ZN10S1597C3_nt3v79Ev");}
void  S1597C3_nt ::v80(){vfunc_called(this, "_ZN10S1597C3_nt3v80Ev");}
void  S1597C3_nt ::v81(){vfunc_called(this, "_ZN10S1597C3_nt3v81Ev");}
void  S1597C3_nt ::v82(){vfunc_called(this, "_ZN10S1597C3_nt3v82Ev");}
void  S1597C3_nt ::v83(){vfunc_called(this, "_ZN10S1597C3_nt3v83Ev");}
void  S1597C3_nt ::v84(){vfunc_called(this, "_ZN10S1597C3_nt3v84Ev");}
void  S1597C3_nt ::v85(){vfunc_called(this, "_ZN10S1597C3_nt3v85Ev");}
void  S1597C3_nt ::v86(){vfunc_called(this, "_ZN10S1597C3_nt3v86Ev");}
void  S1597C3_nt ::v87(){vfunc_called(this, "_ZN10S1597C3_nt3v87Ev");}
void  S1597C3_nt ::v88(){vfunc_called(this, "_ZN10S1597C3_nt3v88Ev");}
void  S1597C3_nt ::v89(){vfunc_called(this, "_ZN10S1597C3_nt3v89Ev");}
void  S1597C3_nt ::v90(){vfunc_called(this, "_ZN10S1597C3_nt3v90Ev");}
void  S1597C3_nt ::v91(){vfunc_called(this, "_ZN10S1597C3_nt3v91Ev");}
void  S1597C3_nt ::v92(){vfunc_called(this, "_ZN10S1597C3_nt3v92Ev");}
S1597C3_nt ::S1597C3_nt(){ note_ctor("S1597C3_nt", this);} // tgen

//skip512 S1597C3_nt

#else // __cplusplus

extern void _ZN10S1597C3_ntC1Ev();
extern void _ZN10S1597C3_ntD1Ev();
Name_Map name_map_S1597C3_nt[] = {
  NSPAIR(_ZN10S1597C3_ntC1Ev),
  NSPAIR(_ZN10S1597C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1597C4;
extern VTBL_ENTRY _ZTI7S1597C4[];
extern  VTBL_ENTRY _ZTV7S1597C4[];
static Base_Class bases_S1597C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1597C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1597C3_nt[];
extern void _ZN10S1597C3_ntD1Ev();
extern void _ZN10S1597C3_ntD0Ev();
extern void _ZN7S1597C42v9Ev();
extern void _ZN7S1597C43v10Ev();
extern void _ZN7S1597C43v11Ev();
extern void _ZN7S1597C43v12Ev();
extern void _ZN7S1597C43v13Ev();
extern void _ZN7S1597C43v14Ev();
extern void _ZN7S1597C43v15Ev();
extern void _ZN7S1597C43v16Ev();
extern void _ZN7S1597C43v17Ev();
extern void _ZN7S1597C43v18Ev();
extern void _ZN7S1597C43v19Ev();
extern void _ZN7S1597C43v20Ev();
extern void _ZN7S1597C43v21Ev();
extern void _ZN7S1597C43v22Ev();
extern void _ZN7S1597C43v23Ev();
extern void _ZN7S1597C43v24Ev();
extern void _ZN7S1597C43v25Ev();
extern void _ZN7S1597C43v26Ev();
extern void _ZN7S1597C43v27Ev();
extern void _ZN7S1597C43v28Ev();
extern void _ZN7S1597C43v29Ev();
extern void _ZN7S1597C43v30Ev();
extern void _ZN7S1597C43v31Ev();
extern void _ZN7S1597C43v32Ev();
extern void _ZN7S1597C43v33Ev();
extern void _ZN7S1597C43v34Ev();
extern void _ZN7S1597C43v35Ev();
extern void _ZN7S1597C43v36Ev();
extern void _ZN7S1597C43v37Ev();
extern void _ZN7S1597C43v38Ev();
extern void _ZN7S1597C43v39Ev();
extern void _ZN7S1597C43v40Ev();
extern void _ZN7S1597C43v41Ev();
extern void _ZN7S1597C43v42Ev();
extern void _ZN7S1597C43v43Ev();
extern void _ZN7S1597C43v44Ev();
extern void _ZN7S1597C43v45Ev();
extern void _ZN7S1597C43v46Ev();
extern void _ZN7S1597C43v47Ev();
extern void _ZN7S1597C43v48Ev();
extern void _ZN7S1597C43v49Ev();
extern void _ZN7S1597C43v50Ev();
extern void _ZN7S1597C43v51Ev();
extern void _ZN7S1597C43v52Ev();
extern void _ZN7S1597C43v53Ev();
extern void _ZN7S1597C43v54Ev();
extern void _ZN7S1597C43v55Ev();
extern void _ZN7S1597C43v56Ev();
extern void _ZN7S1597C43v57Ev();
extern void _ZN7S1597C43v58Ev();
extern void _ZN7S1597C43v59Ev();
extern void _ZN7S1597C43v60Ev();
extern void _ZN7S1597C43v61Ev();
extern void _ZN7S1597C43v62Ev();
extern void _ZN7S1597C43v63Ev();
extern void _ZN7S1597C43v64Ev();
extern void _ZN7S1597C43v65Ev();
extern void _ZN7S1597C43v66Ev();
extern void _ZN7S1597C43v67Ev();
extern void _ZN7S1597C43v68Ev();
extern void _ZN7S1597C43v69Ev();
extern void _ZN7S1597C43v70Ev();
extern void _ZN7S1597C43v71Ev();
extern void _ZN7S1597C43v72Ev();
extern void _ZN10S1597C3_nt3v73Ev();
extern void _ZN10S1597C3_nt3v74Ev();
extern void _ZN10S1597C3_nt3v75Ev();
extern void _ZN10S1597C3_nt3v76Ev();
extern void _ZN10S1597C3_nt3v77Ev();
extern void _ZN10S1597C3_nt3v78Ev();
extern void _ZN10S1597C3_nt3v79Ev();
extern void _ZN10S1597C3_nt3v80Ev();
extern void _ZN10S1597C3_nt3v81Ev();
extern void _ZN10S1597C3_nt3v82Ev();
extern void _ZN10S1597C3_nt3v83Ev();
extern void _ZN10S1597C3_nt3v84Ev();
extern void _ZN10S1597C3_nt3v85Ev();
extern void _ZN10S1597C3_nt3v86Ev();
extern void _ZN10S1597C3_nt3v87Ev();
extern void _ZN10S1597C3_nt3v88Ev();
extern void _ZN10S1597C3_nt3v89Ev();
extern void _ZN10S1597C3_nt3v90Ev();
extern void _ZN10S1597C3_nt3v91Ev();
extern void _ZN10S1597C3_nt3v92Ev();
static  VTBL_ENTRY vtc_S1597C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1597C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1597C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S1597C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v72Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v92Ev,
};
extern VTBL_ENTRY _ZTI10S1597C3_nt[];
VTBL_ENTRY *P__ZTI10S1597C3_nt = _ZTI10S1597C3_nt; 
extern  VTBL_ENTRY _ZTV10S1597C3_nt[];
Class_Descriptor cd_S1597C3_nt = {  "S1597C3_nt", // class name
  bases_S1597C3_nt, 1,
  &(vtc_S1597C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI10S1597C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1597C3_nt),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1597C2  : S1597C3_nt {
  unsigned int s1597c2f0:1;
  virtual  ~S1597C2(); // _ZN7S1597C2D1Ev
  virtual void  v93(); // _ZN7S1597C23v93Ev
  virtual void  v94(); // _ZN7S1597C23v94Ev
  S1597C2(); // tgen
};
//SIG(-1 S1597C2) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 Fi:1}


 S1597C2 ::~S1597C2(){ note_dtor("S1597C2", this);}
void  S1597C2 ::v93(){vfunc_called(this, "_ZN7S1597C23v93Ev");}
void  S1597C2 ::v94(){vfunc_called(this, "_ZN7S1597C23v94Ev");}
S1597C2 ::S1597C2(){ note_ctor("S1597C2", this);} // tgen

static void Test_S1597C2()
{
  extern Class_Descriptor cd_S1597C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1597C2, buf);
    S1597C2 *dp, &lv = *(dp=new (buf) S1597C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1597C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1597C2)");
    check_base_class_offset(lv, (S1597C4*)(S1597C3_nt*), 0, "S1597C2");
    check_base_class_offset(lv, (S1597C3_nt*), 0, "S1597C2");
    set_bf_and_test(lv, s1597c2f0, ABISELECT(98,62), 0, 1, 1, "S1597C2");
    test_class_info(&lv, &cd_S1597C2);
    dp->~S1597C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1597C2(Test_S1597C2, "S1597C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1597C2C1Ev();
extern void _ZN7S1597C2D1Ev();
Name_Map name_map_S1597C2[] = {
  NSPAIR(_ZN7S1597C2C1Ev),
  NSPAIR(_ZN7S1597C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1597C4;
extern VTBL_ENTRY _ZTI7S1597C4[];
extern  VTBL_ENTRY _ZTV7S1597C4[];
extern Class_Descriptor cd_S1597C3_nt;
extern VTBL_ENTRY _ZTI10S1597C3_nt[];
extern  VTBL_ENTRY _ZTV10S1597C3_nt[];
static Base_Class bases_S1597C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1597C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1597C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1597C2[];
extern void _ZN7S1597C2D1Ev();
extern void _ZN7S1597C2D0Ev();
extern void _ZN7S1597C42v9Ev();
extern void _ZN7S1597C43v10Ev();
extern void _ZN7S1597C43v11Ev();
extern void _ZN7S1597C43v12Ev();
extern void _ZN7S1597C43v13Ev();
extern void _ZN7S1597C43v14Ev();
extern void _ZN7S1597C43v15Ev();
extern void _ZN7S1597C43v16Ev();
extern void _ZN7S1597C43v17Ev();
extern void _ZN7S1597C43v18Ev();
extern void _ZN7S1597C43v19Ev();
extern void _ZN7S1597C43v20Ev();
extern void _ZN7S1597C43v21Ev();
extern void _ZN7S1597C43v22Ev();
extern void _ZN7S1597C43v23Ev();
extern void _ZN7S1597C43v24Ev();
extern void _ZN7S1597C43v25Ev();
extern void _ZN7S1597C43v26Ev();
extern void _ZN7S1597C43v27Ev();
extern void _ZN7S1597C43v28Ev();
extern void _ZN7S1597C43v29Ev();
extern void _ZN7S1597C43v30Ev();
extern void _ZN7S1597C43v31Ev();
extern void _ZN7S1597C43v32Ev();
extern void _ZN7S1597C43v33Ev();
extern void _ZN7S1597C43v34Ev();
extern void _ZN7S1597C43v35Ev();
extern void _ZN7S1597C43v36Ev();
extern void _ZN7S1597C43v37Ev();
extern void _ZN7S1597C43v38Ev();
extern void _ZN7S1597C43v39Ev();
extern void _ZN7S1597C43v40Ev();
extern void _ZN7S1597C43v41Ev();
extern void _ZN7S1597C43v42Ev();
extern void _ZN7S1597C43v43Ev();
extern void _ZN7S1597C43v44Ev();
extern void _ZN7S1597C43v45Ev();
extern void _ZN7S1597C43v46Ev();
extern void _ZN7S1597C43v47Ev();
extern void _ZN7S1597C43v48Ev();
extern void _ZN7S1597C43v49Ev();
extern void _ZN7S1597C43v50Ev();
extern void _ZN7S1597C43v51Ev();
extern void _ZN7S1597C43v52Ev();
extern void _ZN7S1597C43v53Ev();
extern void _ZN7S1597C43v54Ev();
extern void _ZN7S1597C43v55Ev();
extern void _ZN7S1597C43v56Ev();
extern void _ZN7S1597C43v57Ev();
extern void _ZN7S1597C43v58Ev();
extern void _ZN7S1597C43v59Ev();
extern void _ZN7S1597C43v60Ev();
extern void _ZN7S1597C43v61Ev();
extern void _ZN7S1597C43v62Ev();
extern void _ZN7S1597C43v63Ev();
extern void _ZN7S1597C43v64Ev();
extern void _ZN7S1597C43v65Ev();
extern void _ZN7S1597C43v66Ev();
extern void _ZN7S1597C43v67Ev();
extern void _ZN7S1597C43v68Ev();
extern void _ZN7S1597C43v69Ev();
extern void _ZN7S1597C43v70Ev();
extern void _ZN7S1597C43v71Ev();
extern void _ZN7S1597C43v72Ev();
extern void _ZN10S1597C3_nt3v73Ev();
extern void _ZN10S1597C3_nt3v74Ev();
extern void _ZN10S1597C3_nt3v75Ev();
extern void _ZN10S1597C3_nt3v76Ev();
extern void _ZN10S1597C3_nt3v77Ev();
extern void _ZN10S1597C3_nt3v78Ev();
extern void _ZN10S1597C3_nt3v79Ev();
extern void _ZN10S1597C3_nt3v80Ev();
extern void _ZN10S1597C3_nt3v81Ev();
extern void _ZN10S1597C3_nt3v82Ev();
extern void _ZN10S1597C3_nt3v83Ev();
extern void _ZN10S1597C3_nt3v84Ev();
extern void _ZN10S1597C3_nt3v85Ev();
extern void _ZN10S1597C3_nt3v86Ev();
extern void _ZN10S1597C3_nt3v87Ev();
extern void _ZN10S1597C3_nt3v88Ev();
extern void _ZN10S1597C3_nt3v89Ev();
extern void _ZN10S1597C3_nt3v90Ev();
extern void _ZN10S1597C3_nt3v91Ev();
extern void _ZN10S1597C3_nt3v92Ev();
extern void _ZN7S1597C23v93Ev();
extern void _ZN7S1597C23v94Ev();
static  VTBL_ENTRY vtc_S1597C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1597C2[0]),
  (VTBL_ENTRY)&_ZN7S1597C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1597C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1597C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v72Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN7S1597C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1597C23v94Ev,
};
extern VTBL_ENTRY _ZTI7S1597C2[];
extern  VTBL_ENTRY _ZTV7S1597C2[];
Class_Descriptor cd_S1597C2 = {  "S1597C2", // class name
  bases_S1597C2, 2,
  &(vtc_S1597C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1597C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1597C2),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1597C8_nt  {
  char s1597c8f0[4];
  ::S1502C28 s1597c8f1;
  int s1597c8f2[2];
  void  mf1597c8(); // _ZN10S1597C8_nt8mf1597c8Ev
};
//SIG(-1 S1597C8_nt) C1{ m Fc[4] FC2{ BC3{ BC4{ m Fp Fi[2]}}} Fi[2]}


void  S1597C8_nt ::mf1597c8(){}

//skip512 S1597C8_nt

#else // __cplusplus

Class_Descriptor cd_S1597C8_nt = {  "S1597C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1597C7_nt  : S1597C8_nt {
  void *s1597c7f0;
};
//SIG(-1 S1597C7_nt) C1{ BC2{ m Fc[4] FC3{ BC4{ BC5{ m Fp Fi[2]}}} Fi[2]} Fp}



//skip512 S1597C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1597C8_nt;
static Base_Class bases_S1597C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1597C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1597C12_nt  {
  unsigned int s1597c12f0:1;
  unsigned int s1597c12f1:1;
  unsigned int s1597c12f2:1;
};
//SIG(-1 S1597C12_nt) C1{ Fi:1 Fi:1 Fi:1}



//skip512 S1597C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1597C1  : S1597C2 {
  char s1597c1f0;
  ::S1597C7_nt s1597c1f1;
  ::S1597C12_nt s1597c1f2;
  ::S1597C7_nt s1597c1f3;
  ::S1597C12_nt s1597c1f4;
  ::S1597C7_nt s1597c1f5;
  ::S1597C12_nt s1597c1f6;
  virtual  ~S1597C1(); // _ZN7S1597C1D1Ev
  virtual void  v1(); // _ZN7S1597C12v1Ev
  virtual void  v2(); // _ZN7S1597C12v2Ev
  virtual void  v3(); // _ZN7S1597C12v3Ev
  virtual void  v4(); // _ZN7S1597C12v4Ev
  virtual void  v5(); // _ZN7S1597C12v5Ev
  virtual void  v6(); // _ZN7S1597C12v6Ev
  virtual void  v7(); // _ZN7S1597C12v7Ev
  virtual void  v8(); // _ZN7S1597C12v8Ev
  S1597C1(); // tgen
};
//SIG(1 S1597C1) C1{ BC2{ BC3{ BC4{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v93 v94 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 Fc FC7{ BC8{ m Fc[4] FC9{ BC10{ BC11{ m Fp Fi[2]}}} Fi[2]} Fp} FC12{ Fi:1 Fi:1 Fi:1} FC7 FC12 FC7 FC12}


 S1597C1 ::~S1597C1(){ note_dtor("S1597C1", this);}
void  S1597C1 ::v1(){vfunc_called(this, "_ZN7S1597C12v1Ev");}
void  S1597C1 ::v2(){vfunc_called(this, "_ZN7S1597C12v2Ev");}
void  S1597C1 ::v3(){vfunc_called(this, "_ZN7S1597C12v3Ev");}
void  S1597C1 ::v4(){vfunc_called(this, "_ZN7S1597C12v4Ev");}
void  S1597C1 ::v5(){vfunc_called(this, "_ZN7S1597C12v5Ev");}
void  S1597C1 ::v6(){vfunc_called(this, "_ZN7S1597C12v6Ev");}
void  S1597C1 ::v7(){vfunc_called(this, "_ZN7S1597C12v7Ev");}
void  S1597C1 ::v8(){vfunc_called(this, "_ZN7S1597C12v8Ev");}
S1597C1 ::S1597C1(){ note_ctor("S1597C1", this);} // tgen

static void Test_S1597C1()
{
  extern Class_Descriptor cd_S1597C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(32,41)];
    init_test(&cd_S1597C1, buf);
    S1597C1 *dp, &lv = *(dp=new (buf) S1597C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(248,160), "sizeof(S1597C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1597C1)");
    check_base_class_offset(lv, (S1597C4*)(S1597C3_nt*)(S1597C2*), 0, "S1597C1");
    check_base_class_offset(lv, (S1597C3_nt*)(S1597C2*), 0, "S1597C1");
    check_base_class_offset(lv, (S1597C2*), 0, "S1597C1");
    check_field_offset(lv, s1597c1f0, ABISELECT(99,63), "S1597C1.s1597c1f0");
    check_field_offset(lv, s1597c1f1, ABISELECT(104,64), "S1597C1.s1597c1f1");
    check_field_offset(lv, s1597c1f2, ABISELECT(144,92), "S1597C1.s1597c1f2");
    check_field_offset(lv, s1597c1f3, ABISELECT(152,96), "S1597C1.s1597c1f3");
    check_field_offset(lv, s1597c1f4, ABISELECT(192,124), "S1597C1.s1597c1f4");
    check_field_offset(lv, s1597c1f5, ABISELECT(200,128), "S1597C1.s1597c1f5");
    check_field_offset(lv, s1597c1f6, ABISELECT(240,156), "S1597C1.s1597c1f6");
    test_class_info(&lv, &cd_S1597C1);
    dp->~S1597C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1597C1(Test_S1597C1, "S1597C1", ABISELECT(248,160));

#else // __cplusplus

extern void _ZN7S1597C1C1Ev();
extern void _ZN7S1597C1D1Ev();
Name_Map name_map_S1597C1[] = {
  NSPAIR(_ZN7S1597C1C1Ev),
  NSPAIR(_ZN7S1597C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1597C4;
extern VTBL_ENTRY _ZTI7S1597C4[];
extern  VTBL_ENTRY _ZTV7S1597C4[];
extern Class_Descriptor cd_S1597C3_nt;
extern VTBL_ENTRY _ZTI10S1597C3_nt[];
extern  VTBL_ENTRY _ZTV10S1597C3_nt[];
extern Class_Descriptor cd_S1597C2;
extern VTBL_ENTRY _ZTI7S1597C2[];
extern  VTBL_ENTRY _ZTV7S1597C2[];
static Base_Class bases_S1597C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1597C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1597C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1597C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1597C1[];
extern void _ZN7S1597C1D1Ev();
extern void _ZN7S1597C1D0Ev();
extern void _ZN7S1597C42v9Ev();
extern void _ZN7S1597C43v10Ev();
extern void _ZN7S1597C43v11Ev();
extern void _ZN7S1597C43v12Ev();
extern void _ZN7S1597C43v13Ev();
extern void _ZN7S1597C43v14Ev();
extern void _ZN7S1597C43v15Ev();
extern void _ZN7S1597C43v16Ev();
extern void _ZN7S1597C43v17Ev();
extern void _ZN7S1597C43v18Ev();
extern void _ZN7S1597C43v19Ev();
extern void _ZN7S1597C43v20Ev();
extern void _ZN7S1597C43v21Ev();
extern void _ZN7S1597C43v22Ev();
extern void _ZN7S1597C43v23Ev();
extern void _ZN7S1597C43v24Ev();
extern void _ZN7S1597C43v25Ev();
extern void _ZN7S1597C43v26Ev();
extern void _ZN7S1597C43v27Ev();
extern void _ZN7S1597C43v28Ev();
extern void _ZN7S1597C43v29Ev();
extern void _ZN7S1597C43v30Ev();
extern void _ZN7S1597C43v31Ev();
extern void _ZN7S1597C43v32Ev();
extern void _ZN7S1597C43v33Ev();
extern void _ZN7S1597C43v34Ev();
extern void _ZN7S1597C43v35Ev();
extern void _ZN7S1597C43v36Ev();
extern void _ZN7S1597C43v37Ev();
extern void _ZN7S1597C43v38Ev();
extern void _ZN7S1597C43v39Ev();
extern void _ZN7S1597C43v40Ev();
extern void _ZN7S1597C43v41Ev();
extern void _ZN7S1597C43v42Ev();
extern void _ZN7S1597C43v43Ev();
extern void _ZN7S1597C43v44Ev();
extern void _ZN7S1597C43v45Ev();
extern void _ZN7S1597C43v46Ev();
extern void _ZN7S1597C43v47Ev();
extern void _ZN7S1597C43v48Ev();
extern void _ZN7S1597C43v49Ev();
extern void _ZN7S1597C43v50Ev();
extern void _ZN7S1597C43v51Ev();
extern void _ZN7S1597C43v52Ev();
extern void _ZN7S1597C43v53Ev();
extern void _ZN7S1597C43v54Ev();
extern void _ZN7S1597C43v55Ev();
extern void _ZN7S1597C43v56Ev();
extern void _ZN7S1597C43v57Ev();
extern void _ZN7S1597C43v58Ev();
extern void _ZN7S1597C43v59Ev();
extern void _ZN7S1597C43v60Ev();
extern void _ZN7S1597C43v61Ev();
extern void _ZN7S1597C43v62Ev();
extern void _ZN7S1597C43v63Ev();
extern void _ZN7S1597C43v64Ev();
extern void _ZN7S1597C43v65Ev();
extern void _ZN7S1597C43v66Ev();
extern void _ZN7S1597C43v67Ev();
extern void _ZN7S1597C43v68Ev();
extern void _ZN7S1597C43v69Ev();
extern void _ZN7S1597C43v70Ev();
extern void _ZN7S1597C43v71Ev();
extern void _ZN7S1597C43v72Ev();
extern void _ZN10S1597C3_nt3v73Ev();
extern void _ZN10S1597C3_nt3v74Ev();
extern void _ZN10S1597C3_nt3v75Ev();
extern void _ZN10S1597C3_nt3v76Ev();
extern void _ZN10S1597C3_nt3v77Ev();
extern void _ZN10S1597C3_nt3v78Ev();
extern void _ZN10S1597C3_nt3v79Ev();
extern void _ZN10S1597C3_nt3v80Ev();
extern void _ZN10S1597C3_nt3v81Ev();
extern void _ZN10S1597C3_nt3v82Ev();
extern void _ZN10S1597C3_nt3v83Ev();
extern void _ZN10S1597C3_nt3v84Ev();
extern void _ZN10S1597C3_nt3v85Ev();
extern void _ZN10S1597C3_nt3v86Ev();
extern void _ZN10S1597C3_nt3v87Ev();
extern void _ZN10S1597C3_nt3v88Ev();
extern void _ZN10S1597C3_nt3v89Ev();
extern void _ZN10S1597C3_nt3v90Ev();
extern void _ZN10S1597C3_nt3v91Ev();
extern void _ZN10S1597C3_nt3v92Ev();
extern void _ZN7S1597C23v93Ev();
extern void _ZN7S1597C23v94Ev();
extern void _ZN7S1597C12v1Ev();
extern void _ZN7S1597C12v2Ev();
extern void _ZN7S1597C12v3Ev();
extern void _ZN7S1597C12v4Ev();
extern void _ZN7S1597C12v5Ev();
extern void _ZN7S1597C12v6Ev();
extern void _ZN7S1597C12v7Ev();
extern void _ZN7S1597C12v8Ev();
static  VTBL_ENTRY vtc_S1597C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1597C1[0]),
  (VTBL_ENTRY)&_ZN7S1597C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1597C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1597C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1597C43v72Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1597C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN7S1597C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1597C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1597C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1597C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1597C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1597C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1597C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1597C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1597C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1597C12v8Ev,
};
extern VTBL_ENTRY _ZTI7S1597C1[];
extern  VTBL_ENTRY _ZTV7S1597C1[];
Class_Descriptor cd_S1597C1 = {  "S1597C1", // class name
  bases_S1597C1, 3,
  &(vtc_S1597C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(248,160), // object size
  NSPAIRA(_ZTI7S1597C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1597C1),98, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1321C4  {
  int s1321c4f0;
  __tsi64 s1321c4f1;
  void *s1321c4f2[4];
  int s1321c4f3[2];
  void *s1321c4f4;
  ::S1502C5_nt s1321c4f5;
  void *s1321c4f6[2];
  virtual  ~S1321C4(); // _ZN7S1321C4D1Ev
  virtual void  v16(); // _ZN7S1321C43v16Ev
  virtual void  v17(); // _ZN7S1321C43v17Ev
  virtual void  v18(); // _ZN7S1321C43v18Ev
  virtual void  v19(); // _ZN7S1321C43v19Ev
  virtual void  v20(); // _ZN7S1321C43v20Ev
  virtual void  v21(); // _ZN7S1321C43v21Ev
  virtual void  v22(); // _ZN7S1321C43v22Ev
  virtual void  v23(); // _ZN7S1321C43v23Ev
  virtual void  v24(); // _ZN7S1321C43v24Ev
  virtual void  v25(); // _ZN7S1321C43v25Ev
  virtual void  v26(); // _ZN7S1321C43v26Ev
  virtual void  v27(); // _ZN7S1321C43v27Ev
  virtual void  v28(); // _ZN7S1321C43v28Ev
  virtual void  v29(); // _ZN7S1321C43v29Ev
  virtual void  v30(); // _ZN7S1321C43v30Ev
  virtual void  v31(); // _ZN7S1321C43v31Ev
  virtual void  v32(); // _ZN7S1321C43v32Ev
  virtual void  v33(); // _ZN7S1321C43v33Ev
  virtual void  v34(); // _ZN7S1321C43v34Ev
  virtual void  v35(); // _ZN7S1321C43v35Ev
  virtual void  v36(); // _ZN7S1321C43v36Ev
  virtual void  v37(); // _ZN7S1321C43v37Ev
  virtual void  v38(); // _ZN7S1321C43v38Ev
  virtual void  v39(); // _ZN7S1321C43v39Ev
  virtual void  v40(); // _ZN7S1321C43v40Ev
  virtual void  v41(); // _ZN7S1321C43v41Ev
  virtual void  v42(); // _ZN7S1321C43v42Ev
  virtual void  v43(); // _ZN7S1321C43v43Ev
  virtual void  v44(); // _ZN7S1321C43v44Ev
  virtual void  v45(); // _ZN7S1321C43v45Ev
  virtual void  v46(); // _ZN7S1321C43v46Ev
  virtual void  v47(); // _ZN7S1321C43v47Ev
  virtual void  v48(); // _ZN7S1321C43v48Ev
  virtual void  v49(); // _ZN7S1321C43v49Ev
  virtual void  v50(); // _ZN7S1321C43v50Ev
  virtual void  v51(); // _ZN7S1321C43v51Ev
  virtual void  v52(); // _ZN7S1321C43v52Ev
  virtual void  v53(); // _ZN7S1321C43v53Ev
  virtual void  v54(); // _ZN7S1321C43v54Ev
  virtual void  v55(); // _ZN7S1321C43v55Ev
  virtual void  v56(); // _ZN7S1321C43v56Ev
  virtual void  v57(); // _ZN7S1321C43v57Ev
  virtual void  v58(); // _ZN7S1321C43v58Ev
  virtual void  v59(); // _ZN7S1321C43v59Ev
  virtual void  v60(); // _ZN7S1321C43v60Ev
  virtual void  v61(); // _ZN7S1321C43v61Ev
  virtual void  v62(); // _ZN7S1321C43v62Ev
  virtual void  v63(); // _ZN7S1321C43v63Ev
  virtual void  v64(); // _ZN7S1321C43v64Ev
  virtual void  v65(); // _ZN7S1321C43v65Ev
  virtual void  v66(); // _ZN7S1321C43v66Ev
  virtual void  v67(); // _ZN7S1321C43v67Ev
  virtual void  v68(); // _ZN7S1321C43v68Ev
  virtual void  v69(); // _ZN7S1321C43v69Ev
  virtual void  v70(); // _ZN7S1321C43v70Ev
  virtual void  v71(); // _ZN7S1321C43v71Ev
  virtual void  v72(); // _ZN7S1321C43v72Ev
  virtual void  v73(); // _ZN7S1321C43v73Ev
  virtual void  v74(); // _ZN7S1321C43v74Ev
  virtual void  v75(); // _ZN7S1321C43v75Ev
  virtual void  v76(); // _ZN7S1321C43v76Ev
  virtual void  v77(); // _ZN7S1321C43v77Ev
  virtual void  v78(); // _ZN7S1321C43v78Ev
  virtual void  v79(); // _ZN7S1321C43v79Ev
  S1321C4(); // tgen
};
//SIG(-1 S1321C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1321C4 ::~S1321C4(){ note_dtor("S1321C4", this);}
void  S1321C4 ::v16(){vfunc_called(this, "_ZN7S1321C43v16Ev");}
void  S1321C4 ::v17(){vfunc_called(this, "_ZN7S1321C43v17Ev");}
void  S1321C4 ::v18(){vfunc_called(this, "_ZN7S1321C43v18Ev");}
void  S1321C4 ::v19(){vfunc_called(this, "_ZN7S1321C43v19Ev");}
void  S1321C4 ::v20(){vfunc_called(this, "_ZN7S1321C43v20Ev");}
void  S1321C4 ::v21(){vfunc_called(this, "_ZN7S1321C43v21Ev");}
void  S1321C4 ::v22(){vfunc_called(this, "_ZN7S1321C43v22Ev");}
void  S1321C4 ::v23(){vfunc_called(this, "_ZN7S1321C43v23Ev");}
void  S1321C4 ::v24(){vfunc_called(this, "_ZN7S1321C43v24Ev");}
void  S1321C4 ::v25(){vfunc_called(this, "_ZN7S1321C43v25Ev");}
void  S1321C4 ::v26(){vfunc_called(this, "_ZN7S1321C43v26Ev");}
void  S1321C4 ::v27(){vfunc_called(this, "_ZN7S1321C43v27Ev");}
void  S1321C4 ::v28(){vfunc_called(this, "_ZN7S1321C43v28Ev");}
void  S1321C4 ::v29(){vfunc_called(this, "_ZN7S1321C43v29Ev");}
void  S1321C4 ::v30(){vfunc_called(this, "_ZN7S1321C43v30Ev");}
void  S1321C4 ::v31(){vfunc_called(this, "_ZN7S1321C43v31Ev");}
void  S1321C4 ::v32(){vfunc_called(this, "_ZN7S1321C43v32Ev");}
void  S1321C4 ::v33(){vfunc_called(this, "_ZN7S1321C43v33Ev");}
void  S1321C4 ::v34(){vfunc_called(this, "_ZN7S1321C43v34Ev");}
void  S1321C4 ::v35(){vfunc_called(this, "_ZN7S1321C43v35Ev");}
void  S1321C4 ::v36(){vfunc_called(this, "_ZN7S1321C43v36Ev");}
void  S1321C4 ::v37(){vfunc_called(this, "_ZN7S1321C43v37Ev");}
void  S1321C4 ::v38(){vfunc_called(this, "_ZN7S1321C43v38Ev");}
void  S1321C4 ::v39(){vfunc_called(this, "_ZN7S1321C43v39Ev");}
void  S1321C4 ::v40(){vfunc_called(this, "_ZN7S1321C43v40Ev");}
void  S1321C4 ::v41(){vfunc_called(this, "_ZN7S1321C43v41Ev");}
void  S1321C4 ::v42(){vfunc_called(this, "_ZN7S1321C43v42Ev");}
void  S1321C4 ::v43(){vfunc_called(this, "_ZN7S1321C43v43Ev");}
void  S1321C4 ::v44(){vfunc_called(this, "_ZN7S1321C43v44Ev");}
void  S1321C4 ::v45(){vfunc_called(this, "_ZN7S1321C43v45Ev");}
void  S1321C4 ::v46(){vfunc_called(this, "_ZN7S1321C43v46Ev");}
void  S1321C4 ::v47(){vfunc_called(this, "_ZN7S1321C43v47Ev");}
void  S1321C4 ::v48(){vfunc_called(this, "_ZN7S1321C43v48Ev");}
void  S1321C4 ::v49(){vfunc_called(this, "_ZN7S1321C43v49Ev");}
void  S1321C4 ::v50(){vfunc_called(this, "_ZN7S1321C43v50Ev");}
void  S1321C4 ::v51(){vfunc_called(this, "_ZN7S1321C43v51Ev");}
void  S1321C4 ::v52(){vfunc_called(this, "_ZN7S1321C43v52Ev");}
void  S1321C4 ::v53(){vfunc_called(this, "_ZN7S1321C43v53Ev");}
void  S1321C4 ::v54(){vfunc_called(this, "_ZN7S1321C43v54Ev");}
void  S1321C4 ::v55(){vfunc_called(this, "_ZN7S1321C43v55Ev");}
void  S1321C4 ::v56(){vfunc_called(this, "_ZN7S1321C43v56Ev");}
void  S1321C4 ::v57(){vfunc_called(this, "_ZN7S1321C43v57Ev");}
void  S1321C4 ::v58(){vfunc_called(this, "_ZN7S1321C43v58Ev");}
void  S1321C4 ::v59(){vfunc_called(this, "_ZN7S1321C43v59Ev");}
void  S1321C4 ::v60(){vfunc_called(this, "_ZN7S1321C43v60Ev");}
void  S1321C4 ::v61(){vfunc_called(this, "_ZN7S1321C43v61Ev");}
void  S1321C4 ::v62(){vfunc_called(this, "_ZN7S1321C43v62Ev");}
void  S1321C4 ::v63(){vfunc_called(this, "_ZN7S1321C43v63Ev");}
void  S1321C4 ::v64(){vfunc_called(this, "_ZN7S1321C43v64Ev");}
void  S1321C4 ::v65(){vfunc_called(this, "_ZN7S1321C43v65Ev");}
void  S1321C4 ::v66(){vfunc_called(this, "_ZN7S1321C43v66Ev");}
void  S1321C4 ::v67(){vfunc_called(this, "_ZN7S1321C43v67Ev");}
void  S1321C4 ::v68(){vfunc_called(this, "_ZN7S1321C43v68Ev");}
void  S1321C4 ::v69(){vfunc_called(this, "_ZN7S1321C43v69Ev");}
void  S1321C4 ::v70(){vfunc_called(this, "_ZN7S1321C43v70Ev");}
void  S1321C4 ::v71(){vfunc_called(this, "_ZN7S1321C43v71Ev");}
void  S1321C4 ::v72(){vfunc_called(this, "_ZN7S1321C43v72Ev");}
void  S1321C4 ::v73(){vfunc_called(this, "_ZN7S1321C43v73Ev");}
void  S1321C4 ::v74(){vfunc_called(this, "_ZN7S1321C43v74Ev");}
void  S1321C4 ::v75(){vfunc_called(this, "_ZN7S1321C43v75Ev");}
void  S1321C4 ::v76(){vfunc_called(this, "_ZN7S1321C43v76Ev");}
void  S1321C4 ::v77(){vfunc_called(this, "_ZN7S1321C43v77Ev");}
void  S1321C4 ::v78(){vfunc_called(this, "_ZN7S1321C43v78Ev");}
void  S1321C4 ::v79(){vfunc_called(this, "_ZN7S1321C43v79Ev");}
S1321C4 ::S1321C4(){ note_ctor("S1321C4", this);} // tgen

static void Test_S1321C4()
{
  extern Class_Descriptor cd_S1321C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1321C4, buf);
    S1321C4 *dp, &lv = *(dp=new (buf) S1321C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1321C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1321C4)");
    check_field_offset(lv, s1321c4f0, ABISELECT(8,4), "S1321C4.s1321c4f0");
    check_field_offset(lv, s1321c4f1, ABISELECT(16,8), "S1321C4.s1321c4f1");
    check_field_offset(lv, s1321c4f2, ABISELECT(24,16), "S1321C4.s1321c4f2");
    check_field_offset(lv, s1321c4f3, ABISELECT(56,32), "S1321C4.s1321c4f3");
    check_field_offset(lv, s1321c4f4, ABISELECT(64,40), "S1321C4.s1321c4f4");
    check_field_offset(lv, s1321c4f5, ABISELECT(72,44), "S1321C4.s1321c4f5");
    check_field_offset(lv, s1321c4f6, ABISELECT(80,52), "S1321C4.s1321c4f6");
    test_class_info(&lv, &cd_S1321C4);
    dp->~S1321C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1321C4(Test_S1321C4, "S1321C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1321C4C1Ev();
extern void _ZN7S1321C4D1Ev();
Name_Map name_map_S1321C4[] = {
  NSPAIR(_ZN7S1321C4C1Ev),
  NSPAIR(_ZN7S1321C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1321C4[];
extern void _ZN7S1321C4D1Ev();
extern void _ZN7S1321C4D0Ev();
extern void _ZN7S1321C43v16Ev();
extern void _ZN7S1321C43v17Ev();
extern void _ZN7S1321C43v18Ev();
extern void _ZN7S1321C43v19Ev();
extern void _ZN7S1321C43v20Ev();
extern void _ZN7S1321C43v21Ev();
extern void _ZN7S1321C43v22Ev();
extern void _ZN7S1321C43v23Ev();
extern void _ZN7S1321C43v24Ev();
extern void _ZN7S1321C43v25Ev();
extern void _ZN7S1321C43v26Ev();
extern void _ZN7S1321C43v27Ev();
extern void _ZN7S1321C43v28Ev();
extern void _ZN7S1321C43v29Ev();
extern void _ZN7S1321C43v30Ev();
extern void _ZN7S1321C43v31Ev();
extern void _ZN7S1321C43v32Ev();
extern void _ZN7S1321C43v33Ev();
extern void _ZN7S1321C43v34Ev();
extern void _ZN7S1321C43v35Ev();
extern void _ZN7S1321C43v36Ev();
extern void _ZN7S1321C43v37Ev();
extern void _ZN7S1321C43v38Ev();
extern void _ZN7S1321C43v39Ev();
extern void _ZN7S1321C43v40Ev();
extern void _ZN7S1321C43v41Ev();
extern void _ZN7S1321C43v42Ev();
extern void _ZN7S1321C43v43Ev();
extern void _ZN7S1321C43v44Ev();
extern void _ZN7S1321C43v45Ev();
extern void _ZN7S1321C43v46Ev();
extern void _ZN7S1321C43v47Ev();
extern void _ZN7S1321C43v48Ev();
extern void _ZN7S1321C43v49Ev();
extern void _ZN7S1321C43v50Ev();
extern void _ZN7S1321C43v51Ev();
extern void _ZN7S1321C43v52Ev();
extern void _ZN7S1321C43v53Ev();
extern void _ZN7S1321C43v54Ev();
extern void _ZN7S1321C43v55Ev();
extern void _ZN7S1321C43v56Ev();
extern void _ZN7S1321C43v57Ev();
extern void _ZN7S1321C43v58Ev();
extern void _ZN7S1321C43v59Ev();
extern void _ZN7S1321C43v60Ev();
extern void _ZN7S1321C43v61Ev();
extern void _ZN7S1321C43v62Ev();
extern void _ZN7S1321C43v63Ev();
extern void _ZN7S1321C43v64Ev();
extern void _ZN7S1321C43v65Ev();
extern void _ZN7S1321C43v66Ev();
extern void _ZN7S1321C43v67Ev();
extern void _ZN7S1321C43v68Ev();
extern void _ZN7S1321C43v69Ev();
extern void _ZN7S1321C43v70Ev();
extern void _ZN7S1321C43v71Ev();
extern void _ZN7S1321C43v72Ev();
extern void _ZN7S1321C43v73Ev();
extern void _ZN7S1321C43v74Ev();
extern void _ZN7S1321C43v75Ev();
extern void _ZN7S1321C43v76Ev();
extern void _ZN7S1321C43v77Ev();
extern void _ZN7S1321C43v78Ev();
extern void _ZN7S1321C43v79Ev();
static  VTBL_ENTRY vtc_S1321C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1321C4[0]),
  (VTBL_ENTRY)&_ZN7S1321C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1321C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v79Ev,
};
extern VTBL_ENTRY _ZTI7S1321C4[];
extern  VTBL_ENTRY _ZTV7S1321C4[];
Class_Descriptor cd_S1321C4 = {  "S1321C4", // class name
  0,0,//no base classes
  &(vtc_S1321C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1321C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1321C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1321C3  : S1321C4 {
  unsigned int s1321c3f0:1;
  unsigned int s1321c3f1:1;
  unsigned int s1321c3f2:1;
  unsigned int s1321c3f3:1;
  unsigned int s1321c3f4:1;
  unsigned int s1321c3f5:1;
  unsigned int s1321c3f6:1;
  ::S578C11_nt s1321c3f7;
  virtual  ~S1321C3(); // _ZN7S1321C3D1Ev
  virtual void  v80(); // _ZN7S1321C33v80Ev
  virtual void  v81(); // _ZN7S1321C33v81Ev
  virtual void  v82(); // _ZN7S1321C33v82Ev
  virtual void  v83(); // _ZN7S1321C33v83Ev
  virtual void  v84(); // _ZN7S1321C33v84Ev
  virtual void  v85(); // _ZN7S1321C33v85Ev
  virtual void  v86(); // _ZN7S1321C33v86Ev
  virtual void  v87(); // _ZN7S1321C33v87Ev
  virtual void  v88(); // _ZN7S1321C33v88Ev
  virtual void  v89(); // _ZN7S1321C33v89Ev
  virtual void  v90(); // _ZN7S1321C33v90Ev
  virtual void  v91(); // _ZN7S1321C33v91Ev
  virtual void  v92(); // _ZN7S1321C33v92Ev
  virtual void  v93(); // _ZN7S1321C33v93Ev
  virtual void  v94(); // _ZN7S1321C33v94Ev
  virtual void  v95(); // _ZN7S1321C33v95Ev
  virtual void  v96(); // _ZN7S1321C33v96Ev
  virtual void  v97(); // _ZN7S1321C33v97Ev
  virtual void  v98(); // _ZN7S1321C33v98Ev
  virtual void  v99(); // _ZN7S1321C33v99Ev
  S1321C3(); // tgen
};
//SIG(-1 S1321C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1321C3 ::~S1321C3(){ note_dtor("S1321C3", this);}
void  S1321C3 ::v80(){vfunc_called(this, "_ZN7S1321C33v80Ev");}
void  S1321C3 ::v81(){vfunc_called(this, "_ZN7S1321C33v81Ev");}
void  S1321C3 ::v82(){vfunc_called(this, "_ZN7S1321C33v82Ev");}
void  S1321C3 ::v83(){vfunc_called(this, "_ZN7S1321C33v83Ev");}
void  S1321C3 ::v84(){vfunc_called(this, "_ZN7S1321C33v84Ev");}
void  S1321C3 ::v85(){vfunc_called(this, "_ZN7S1321C33v85Ev");}
void  S1321C3 ::v86(){vfunc_called(this, "_ZN7S1321C33v86Ev");}
void  S1321C3 ::v87(){vfunc_called(this, "_ZN7S1321C33v87Ev");}
void  S1321C3 ::v88(){vfunc_called(this, "_ZN7S1321C33v88Ev");}
void  S1321C3 ::v89(){vfunc_called(this, "_ZN7S1321C33v89Ev");}
void  S1321C3 ::v90(){vfunc_called(this, "_ZN7S1321C33v90Ev");}
void  S1321C3 ::v91(){vfunc_called(this, "_ZN7S1321C33v91Ev");}
void  S1321C3 ::v92(){vfunc_called(this, "_ZN7S1321C33v92Ev");}
void  S1321C3 ::v93(){vfunc_called(this, "_ZN7S1321C33v93Ev");}
void  S1321C3 ::v94(){vfunc_called(this, "_ZN7S1321C33v94Ev");}
void  S1321C3 ::v95(){vfunc_called(this, "_ZN7S1321C33v95Ev");}
void  S1321C3 ::v96(){vfunc_called(this, "_ZN7S1321C33v96Ev");}
void  S1321C3 ::v97(){vfunc_called(this, "_ZN7S1321C33v97Ev");}
void  S1321C3 ::v98(){vfunc_called(this, "_ZN7S1321C33v98Ev");}
void  S1321C3 ::v99(){vfunc_called(this, "_ZN7S1321C33v99Ev");}
S1321C3 ::S1321C3(){ note_ctor("S1321C3", this);} // tgen

static void Test_S1321C3()
{
  extern Class_Descriptor cd_S1321C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1321C3, buf);
    S1321C3 *dp, &lv = *(dp=new (buf) S1321C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1321C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1321C3)");
    check_base_class_offset(lv, (S1321C4*), 0, "S1321C3");
    set_bf_and_test(lv, s1321c3f0, ABISELECT(96,60), 0, 1, 1, "S1321C3");
    set_bf_and_test(lv, s1321c3f1, ABISELECT(96,60), 1, 1, 1, "S1321C3");
    set_bf_and_test(lv, s1321c3f2, ABISELECT(96,60), 2, 1, 1, "S1321C3");
    set_bf_and_test(lv, s1321c3f3, ABISELECT(96,60), 3, 1, 1, "S1321C3");
    set_bf_and_test(lv, s1321c3f4, ABISELECT(96,60), 4, 1, 1, "S1321C3");
    set_bf_and_test(lv, s1321c3f5, ABISELECT(96,60), 5, 1, 1, "S1321C3");
    set_bf_and_test(lv, s1321c3f6, ABISELECT(96,60), 6, 1, 1, "S1321C3");
    check_field_offset(lv, s1321c3f7, ABISELECT(97,61), "S1321C3.s1321c3f7");
    test_class_info(&lv, &cd_S1321C3);
    dp->~S1321C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1321C3(Test_S1321C3, "S1321C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1321C3C1Ev();
extern void _ZN7S1321C3D1Ev();
Name_Map name_map_S1321C3[] = {
  NSPAIR(_ZN7S1321C3C1Ev),
  NSPAIR(_ZN7S1321C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1321C4;
extern VTBL_ENTRY _ZTI7S1321C4[];
extern  VTBL_ENTRY _ZTV7S1321C4[];
static Base_Class bases_S1321C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1321C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1321C3[];
extern void _ZN7S1321C3D1Ev();
extern void _ZN7S1321C3D0Ev();
extern void _ZN7S1321C43v16Ev();
extern void _ZN7S1321C43v17Ev();
extern void _ZN7S1321C43v18Ev();
extern void _ZN7S1321C43v19Ev();
extern void _ZN7S1321C43v20Ev();
extern void _ZN7S1321C43v21Ev();
extern void _ZN7S1321C43v22Ev();
extern void _ZN7S1321C43v23Ev();
extern void _ZN7S1321C43v24Ev();
extern void _ZN7S1321C43v25Ev();
extern void _ZN7S1321C43v26Ev();
extern void _ZN7S1321C43v27Ev();
extern void _ZN7S1321C43v28Ev();
extern void _ZN7S1321C43v29Ev();
extern void _ZN7S1321C43v30Ev();
extern void _ZN7S1321C43v31Ev();
extern void _ZN7S1321C43v32Ev();
extern void _ZN7S1321C43v33Ev();
extern void _ZN7S1321C43v34Ev();
extern void _ZN7S1321C43v35Ev();
extern void _ZN7S1321C43v36Ev();
extern void _ZN7S1321C43v37Ev();
extern void _ZN7S1321C43v38Ev();
extern void _ZN7S1321C43v39Ev();
extern void _ZN7S1321C43v40Ev();
extern void _ZN7S1321C43v41Ev();
extern void _ZN7S1321C43v42Ev();
extern void _ZN7S1321C43v43Ev();
extern void _ZN7S1321C43v44Ev();
extern void _ZN7S1321C43v45Ev();
extern void _ZN7S1321C43v46Ev();
extern void _ZN7S1321C43v47Ev();
extern void _ZN7S1321C43v48Ev();
extern void _ZN7S1321C43v49Ev();
extern void _ZN7S1321C43v50Ev();
extern void _ZN7S1321C43v51Ev();
extern void _ZN7S1321C43v52Ev();
extern void _ZN7S1321C43v53Ev();
extern void _ZN7S1321C43v54Ev();
extern void _ZN7S1321C43v55Ev();
extern void _ZN7S1321C43v56Ev();
extern void _ZN7S1321C43v57Ev();
extern void _ZN7S1321C43v58Ev();
extern void _ZN7S1321C43v59Ev();
extern void _ZN7S1321C43v60Ev();
extern void _ZN7S1321C43v61Ev();
extern void _ZN7S1321C43v62Ev();
extern void _ZN7S1321C43v63Ev();
extern void _ZN7S1321C43v64Ev();
extern void _ZN7S1321C43v65Ev();
extern void _ZN7S1321C43v66Ev();
extern void _ZN7S1321C43v67Ev();
extern void _ZN7S1321C43v68Ev();
extern void _ZN7S1321C43v69Ev();
extern void _ZN7S1321C43v70Ev();
extern void _ZN7S1321C43v71Ev();
extern void _ZN7S1321C43v72Ev();
extern void _ZN7S1321C43v73Ev();
extern void _ZN7S1321C43v74Ev();
extern void _ZN7S1321C43v75Ev();
extern void _ZN7S1321C43v76Ev();
extern void _ZN7S1321C43v77Ev();
extern void _ZN7S1321C43v78Ev();
extern void _ZN7S1321C43v79Ev();
extern void _ZN7S1321C33v80Ev();
extern void _ZN7S1321C33v81Ev();
extern void _ZN7S1321C33v82Ev();
extern void _ZN7S1321C33v83Ev();
extern void _ZN7S1321C33v84Ev();
extern void _ZN7S1321C33v85Ev();
extern void _ZN7S1321C33v86Ev();
extern void _ZN7S1321C33v87Ev();
extern void _ZN7S1321C33v88Ev();
extern void _ZN7S1321C33v89Ev();
extern void _ZN7S1321C33v90Ev();
extern void _ZN7S1321C33v91Ev();
extern void _ZN7S1321C33v92Ev();
extern void _ZN7S1321C33v93Ev();
extern void _ZN7S1321C33v94Ev();
extern void _ZN7S1321C33v95Ev();
extern void _ZN7S1321C33v96Ev();
extern void _ZN7S1321C33v97Ev();
extern void _ZN7S1321C33v98Ev();
extern void _ZN7S1321C33v99Ev();
static  VTBL_ENTRY vtc_S1321C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1321C3[0]),
  (VTBL_ENTRY)&_ZN7S1321C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1321C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v99Ev,
};
extern VTBL_ENTRY _ZTI7S1321C3[];
extern  VTBL_ENTRY _ZTV7S1321C3[];
Class_Descriptor cd_S1321C3 = {  "S1321C3", // class name
  bases_S1321C3, 1,
  &(vtc_S1321C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1321C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1321C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1321C2_nt  : S1321C3 {
  virtual  ~S1321C2_nt(); // _ZN10S1321C2_ntD1Ev
  virtual void  v100(); // _ZN10S1321C2_nt4v100Ev
  virtual void  v101(); // _ZN10S1321C2_nt4v101Ev
  S1321C2_nt(); // tgen
};
//SIG(-1 S1321C2_nt) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2}


 S1321C2_nt ::~S1321C2_nt(){ note_dtor("S1321C2_nt", this);}
void  S1321C2_nt ::v100(){vfunc_called(this, "_ZN10S1321C2_nt4v100Ev");}
void  S1321C2_nt ::v101(){vfunc_called(this, "_ZN10S1321C2_nt4v101Ev");}
S1321C2_nt ::S1321C2_nt(){ note_ctor("S1321C2_nt", this);} // tgen

//skip512 S1321C2_nt

#else // __cplusplus

extern void _ZN10S1321C2_ntC1Ev();
extern void _ZN10S1321C2_ntD1Ev();
Name_Map name_map_S1321C2_nt[] = {
  NSPAIR(_ZN10S1321C2_ntC1Ev),
  NSPAIR(_ZN10S1321C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1321C4;
extern VTBL_ENTRY _ZTI7S1321C4[];
extern  VTBL_ENTRY _ZTV7S1321C4[];
extern Class_Descriptor cd_S1321C3;
extern VTBL_ENTRY _ZTI7S1321C3[];
extern  VTBL_ENTRY _ZTV7S1321C3[];
static Base_Class bases_S1321C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1321C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1321C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1321C2_nt[];
extern void _ZN10S1321C2_ntD1Ev();
extern void _ZN10S1321C2_ntD0Ev();
extern void _ZN7S1321C43v16Ev();
extern void _ZN7S1321C43v17Ev();
extern void _ZN7S1321C43v18Ev();
extern void _ZN7S1321C43v19Ev();
extern void _ZN7S1321C43v20Ev();
extern void _ZN7S1321C43v21Ev();
extern void _ZN7S1321C43v22Ev();
extern void _ZN7S1321C43v23Ev();
extern void _ZN7S1321C43v24Ev();
extern void _ZN7S1321C43v25Ev();
extern void _ZN7S1321C43v26Ev();
extern void _ZN7S1321C43v27Ev();
extern void _ZN7S1321C43v28Ev();
extern void _ZN7S1321C43v29Ev();
extern void _ZN7S1321C43v30Ev();
extern void _ZN7S1321C43v31Ev();
extern void _ZN7S1321C43v32Ev();
extern void _ZN7S1321C43v33Ev();
extern void _ZN7S1321C43v34Ev();
extern void _ZN7S1321C43v35Ev();
extern void _ZN7S1321C43v36Ev();
extern void _ZN7S1321C43v37Ev();
extern void _ZN7S1321C43v38Ev();
extern void _ZN7S1321C43v39Ev();
extern void _ZN7S1321C43v40Ev();
extern void _ZN7S1321C43v41Ev();
extern void _ZN7S1321C43v42Ev();
extern void _ZN7S1321C43v43Ev();
extern void _ZN7S1321C43v44Ev();
extern void _ZN7S1321C43v45Ev();
extern void _ZN7S1321C43v46Ev();
extern void _ZN7S1321C43v47Ev();
extern void _ZN7S1321C43v48Ev();
extern void _ZN7S1321C43v49Ev();
extern void _ZN7S1321C43v50Ev();
extern void _ZN7S1321C43v51Ev();
extern void _ZN7S1321C43v52Ev();
extern void _ZN7S1321C43v53Ev();
extern void _ZN7S1321C43v54Ev();
extern void _ZN7S1321C43v55Ev();
extern void _ZN7S1321C43v56Ev();
extern void _ZN7S1321C43v57Ev();
extern void _ZN7S1321C43v58Ev();
extern void _ZN7S1321C43v59Ev();
extern void _ZN7S1321C43v60Ev();
extern void _ZN7S1321C43v61Ev();
extern void _ZN7S1321C43v62Ev();
extern void _ZN7S1321C43v63Ev();
extern void _ZN7S1321C43v64Ev();
extern void _ZN7S1321C43v65Ev();
extern void _ZN7S1321C43v66Ev();
extern void _ZN7S1321C43v67Ev();
extern void _ZN7S1321C43v68Ev();
extern void _ZN7S1321C43v69Ev();
extern void _ZN7S1321C43v70Ev();
extern void _ZN7S1321C43v71Ev();
extern void _ZN7S1321C43v72Ev();
extern void _ZN7S1321C43v73Ev();
extern void _ZN7S1321C43v74Ev();
extern void _ZN7S1321C43v75Ev();
extern void _ZN7S1321C43v76Ev();
extern void _ZN7S1321C43v77Ev();
extern void _ZN7S1321C43v78Ev();
extern void _ZN7S1321C43v79Ev();
extern void _ZN7S1321C33v80Ev();
extern void _ZN7S1321C33v81Ev();
extern void _ZN7S1321C33v82Ev();
extern void _ZN7S1321C33v83Ev();
extern void _ZN7S1321C33v84Ev();
extern void _ZN7S1321C33v85Ev();
extern void _ZN7S1321C33v86Ev();
extern void _ZN7S1321C33v87Ev();
extern void _ZN7S1321C33v88Ev();
extern void _ZN7S1321C33v89Ev();
extern void _ZN7S1321C33v90Ev();
extern void _ZN7S1321C33v91Ev();
extern void _ZN7S1321C33v92Ev();
extern void _ZN7S1321C33v93Ev();
extern void _ZN7S1321C33v94Ev();
extern void _ZN7S1321C33v95Ev();
extern void _ZN7S1321C33v96Ev();
extern void _ZN7S1321C33v97Ev();
extern void _ZN7S1321C33v98Ev();
extern void _ZN7S1321C33v99Ev();
extern void _ZN10S1321C2_nt4v100Ev();
extern void _ZN10S1321C2_nt4v101Ev();
static  VTBL_ENTRY vtc_S1321C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1321C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1321C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1321C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v99Ev,
  (VTBL_ENTRY)&_ZN10S1321C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1321C2_nt4v101Ev,
};
extern VTBL_ENTRY _ZTI10S1321C2_nt[];
VTBL_ENTRY *P__ZTI10S1321C2_nt = _ZTI10S1321C2_nt; 
extern  VTBL_ENTRY _ZTV10S1321C2_nt[];
Class_Descriptor cd_S1321C2_nt = {  "S1321C2_nt", // class name
  bases_S1321C2_nt, 2,
  &(vtc_S1321C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI10S1321C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1321C2_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1321C1  : S1321C2_nt {
  ::S1597C7_nt s1321c1f0;
  virtual  ~S1321C1(); // _ZN7S1321C1D1Ev
  virtual void  v1(); // _ZN7S1321C12v1Ev
  virtual void  v2(); // _ZN7S1321C12v2Ev
  virtual void  v3(); // _ZN7S1321C12v3Ev
  virtual void  v4(); // _ZN7S1321C12v4Ev
  virtual void  v5(); // _ZN7S1321C12v5Ev
  virtual void  v6(); // _ZN7S1321C12v6Ev
  virtual void  v7(); // _ZN7S1321C12v7Ev
  virtual void  v8(); // _ZN7S1321C12v8Ev
  virtual void  v9(); // _ZN7S1321C12v9Ev
  virtual void  v10(); // _ZN7S1321C13v10Ev
  virtual void  v11(); // _ZN7S1321C13v11Ev
  virtual void  v12(); // _ZN7S1321C13v12Ev
  virtual void  v13(); // _ZN7S1321C13v13Ev
  virtual void  v14(); // _ZN7S1321C13v14Ev
  virtual void  v15(); // _ZN7S1321C13v15Ev
  S1321C1(); // tgen
};
//SIG(1 S1321C1) C1{ BC2{ BC3{ BC4{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v100 v101} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC7{ BC8{ m Fc[4] FC9{ BC10{ BC11{ m Fp Fi[2]}}} Fi[2]} Fp}}


 S1321C1 ::~S1321C1(){ note_dtor("S1321C1", this);}
void  S1321C1 ::v1(){vfunc_called(this, "_ZN7S1321C12v1Ev");}
void  S1321C1 ::v2(){vfunc_called(this, "_ZN7S1321C12v2Ev");}
void  S1321C1 ::v3(){vfunc_called(this, "_ZN7S1321C12v3Ev");}
void  S1321C1 ::v4(){vfunc_called(this, "_ZN7S1321C12v4Ev");}
void  S1321C1 ::v5(){vfunc_called(this, "_ZN7S1321C12v5Ev");}
void  S1321C1 ::v6(){vfunc_called(this, "_ZN7S1321C12v6Ev");}
void  S1321C1 ::v7(){vfunc_called(this, "_ZN7S1321C12v7Ev");}
void  S1321C1 ::v8(){vfunc_called(this, "_ZN7S1321C12v8Ev");}
void  S1321C1 ::v9(){vfunc_called(this, "_ZN7S1321C12v9Ev");}
void  S1321C1 ::v10(){vfunc_called(this, "_ZN7S1321C13v10Ev");}
void  S1321C1 ::v11(){vfunc_called(this, "_ZN7S1321C13v11Ev");}
void  S1321C1 ::v12(){vfunc_called(this, "_ZN7S1321C13v12Ev");}
void  S1321C1 ::v13(){vfunc_called(this, "_ZN7S1321C13v13Ev");}
void  S1321C1 ::v14(){vfunc_called(this, "_ZN7S1321C13v14Ev");}
void  S1321C1 ::v15(){vfunc_called(this, "_ZN7S1321C13v15Ev");}
S1321C1 ::S1321C1(){ note_ctor("S1321C1", this);} // tgen

static void Test_S1321C1()
{
  extern Class_Descriptor cd_S1321C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,24)];
    init_test(&cd_S1321C1, buf);
    S1321C1 *dp, &lv = *(dp=new (buf) S1321C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,92), "sizeof(S1321C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1321C1)");
    check_base_class_offset(lv, (S1321C4*)(S1321C3*)(S1321C2_nt*), 0, "S1321C1");
    check_base_class_offset(lv, (S1321C3*)(S1321C2_nt*), 0, "S1321C1");
    check_base_class_offset(lv, (S1321C2_nt*), 0, "S1321C1");
    check_field_offset(lv, s1321c1f0, ABISELECT(104,64), "S1321C1.s1321c1f0");
    test_class_info(&lv, &cd_S1321C1);
    dp->~S1321C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1321C1(Test_S1321C1, "S1321C1", ABISELECT(144,92));

#else // __cplusplus

extern void _ZN7S1321C1C1Ev();
extern void _ZN7S1321C1D1Ev();
Name_Map name_map_S1321C1[] = {
  NSPAIR(_ZN7S1321C1C1Ev),
  NSPAIR(_ZN7S1321C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1321C4;
extern VTBL_ENTRY _ZTI7S1321C4[];
extern  VTBL_ENTRY _ZTV7S1321C4[];
extern Class_Descriptor cd_S1321C3;
extern VTBL_ENTRY _ZTI7S1321C3[];
extern  VTBL_ENTRY _ZTV7S1321C3[];
extern Class_Descriptor cd_S1321C2_nt;
extern VTBL_ENTRY _ZTI10S1321C2_nt[];
extern  VTBL_ENTRY _ZTV10S1321C2_nt[];
static Base_Class bases_S1321C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1321C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1321C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1321C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1321C1[];
extern void _ZN7S1321C1D1Ev();
extern void _ZN7S1321C1D0Ev();
extern void _ZN7S1321C43v16Ev();
extern void _ZN7S1321C43v17Ev();
extern void _ZN7S1321C43v18Ev();
extern void _ZN7S1321C43v19Ev();
extern void _ZN7S1321C43v20Ev();
extern void _ZN7S1321C43v21Ev();
extern void _ZN7S1321C43v22Ev();
extern void _ZN7S1321C43v23Ev();
extern void _ZN7S1321C43v24Ev();
extern void _ZN7S1321C43v25Ev();
extern void _ZN7S1321C43v26Ev();
extern void _ZN7S1321C43v27Ev();
extern void _ZN7S1321C43v28Ev();
extern void _ZN7S1321C43v29Ev();
extern void _ZN7S1321C43v30Ev();
extern void _ZN7S1321C43v31Ev();
extern void _ZN7S1321C43v32Ev();
extern void _ZN7S1321C43v33Ev();
extern void _ZN7S1321C43v34Ev();
extern void _ZN7S1321C43v35Ev();
extern void _ZN7S1321C43v36Ev();
extern void _ZN7S1321C43v37Ev();
extern void _ZN7S1321C43v38Ev();
extern void _ZN7S1321C43v39Ev();
extern void _ZN7S1321C43v40Ev();
extern void _ZN7S1321C43v41Ev();
extern void _ZN7S1321C43v42Ev();
extern void _ZN7S1321C43v43Ev();
extern void _ZN7S1321C43v44Ev();
extern void _ZN7S1321C43v45Ev();
extern void _ZN7S1321C43v46Ev();
extern void _ZN7S1321C43v47Ev();
extern void _ZN7S1321C43v48Ev();
extern void _ZN7S1321C43v49Ev();
extern void _ZN7S1321C43v50Ev();
extern void _ZN7S1321C43v51Ev();
extern void _ZN7S1321C43v52Ev();
extern void _ZN7S1321C43v53Ev();
extern void _ZN7S1321C43v54Ev();
extern void _ZN7S1321C43v55Ev();
extern void _ZN7S1321C43v56Ev();
extern void _ZN7S1321C43v57Ev();
extern void _ZN7S1321C43v58Ev();
extern void _ZN7S1321C43v59Ev();
extern void _ZN7S1321C43v60Ev();
extern void _ZN7S1321C43v61Ev();
extern void _ZN7S1321C43v62Ev();
extern void _ZN7S1321C43v63Ev();
extern void _ZN7S1321C43v64Ev();
extern void _ZN7S1321C43v65Ev();
extern void _ZN7S1321C43v66Ev();
extern void _ZN7S1321C43v67Ev();
extern void _ZN7S1321C43v68Ev();
extern void _ZN7S1321C43v69Ev();
extern void _ZN7S1321C43v70Ev();
extern void _ZN7S1321C43v71Ev();
extern void _ZN7S1321C43v72Ev();
extern void _ZN7S1321C43v73Ev();
extern void _ZN7S1321C43v74Ev();
extern void _ZN7S1321C43v75Ev();
extern void _ZN7S1321C43v76Ev();
extern void _ZN7S1321C43v77Ev();
extern void _ZN7S1321C43v78Ev();
extern void _ZN7S1321C43v79Ev();
extern void _ZN7S1321C33v80Ev();
extern void _ZN7S1321C33v81Ev();
extern void _ZN7S1321C33v82Ev();
extern void _ZN7S1321C33v83Ev();
extern void _ZN7S1321C33v84Ev();
extern void _ZN7S1321C33v85Ev();
extern void _ZN7S1321C33v86Ev();
extern void _ZN7S1321C33v87Ev();
extern void _ZN7S1321C33v88Ev();
extern void _ZN7S1321C33v89Ev();
extern void _ZN7S1321C33v90Ev();
extern void _ZN7S1321C33v91Ev();
extern void _ZN7S1321C33v92Ev();
extern void _ZN7S1321C33v93Ev();
extern void _ZN7S1321C33v94Ev();
extern void _ZN7S1321C33v95Ev();
extern void _ZN7S1321C33v96Ev();
extern void _ZN7S1321C33v97Ev();
extern void _ZN7S1321C33v98Ev();
extern void _ZN7S1321C33v99Ev();
extern void _ZN10S1321C2_nt4v100Ev();
extern void _ZN10S1321C2_nt4v101Ev();
extern void _ZN7S1321C12v1Ev();
extern void _ZN7S1321C12v2Ev();
extern void _ZN7S1321C12v3Ev();
extern void _ZN7S1321C12v4Ev();
extern void _ZN7S1321C12v5Ev();
extern void _ZN7S1321C12v6Ev();
extern void _ZN7S1321C12v7Ev();
extern void _ZN7S1321C12v8Ev();
extern void _ZN7S1321C12v9Ev();
extern void _ZN7S1321C13v10Ev();
extern void _ZN7S1321C13v11Ev();
extern void _ZN7S1321C13v12Ev();
extern void _ZN7S1321C13v13Ev();
extern void _ZN7S1321C13v14Ev();
extern void _ZN7S1321C13v15Ev();
static  VTBL_ENTRY vtc_S1321C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1321C1[0]),
  (VTBL_ENTRY)&_ZN7S1321C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1321C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1321C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1321C33v99Ev,
  (VTBL_ENTRY)&_ZN10S1321C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1321C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN7S1321C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1321C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1321C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1321C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1321C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1321C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1321C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1321C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1321C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1321C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1321C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1321C13v12Ev,
  (VTBL_ENTRY)&_ZN7S1321C13v13Ev,
  (VTBL_ENTRY)&_ZN7S1321C13v14Ev,
  (VTBL_ENTRY)&_ZN7S1321C13v15Ev,
};
extern VTBL_ENTRY _ZTI7S1321C1[];
extern  VTBL_ENTRY _ZTV7S1321C1[];
Class_Descriptor cd_S1321C1 = {  "S1321C1", // class name
  bases_S1321C1, 3,
  &(vtc_S1321C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,92), // object size
  NSPAIRA(_ZTI7S1321C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1321C1),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1291C4  {
  int s1291c4f0;
  __tsi64 s1291c4f1;
  void *s1291c4f2[4];
  int s1291c4f3[2];
  void *s1291c4f4;
  ::S1502C5_nt s1291c4f5;
  void *s1291c4f6[2];
  virtual  ~S1291C4(); // _ZN7S1291C4D1Ev
  virtual void  v10(); // _ZN7S1291C43v10Ev
  virtual void  v11(); // _ZN7S1291C43v11Ev
  virtual void  v12(); // _ZN7S1291C43v12Ev
  virtual void  v13(); // _ZN7S1291C43v13Ev
  virtual void  v14(); // _ZN7S1291C43v14Ev
  virtual void  v15(); // _ZN7S1291C43v15Ev
  virtual void  v16(); // _ZN7S1291C43v16Ev
  virtual void  v17(); // _ZN7S1291C43v17Ev
  virtual void  v18(); // _ZN7S1291C43v18Ev
  virtual void  v19(); // _ZN7S1291C43v19Ev
  virtual void  v20(); // _ZN7S1291C43v20Ev
  virtual void  v21(); // _ZN7S1291C43v21Ev
  virtual void  v22(); // _ZN7S1291C43v22Ev
  virtual void  v23(); // _ZN7S1291C43v23Ev
  virtual void  v24(); // _ZN7S1291C43v24Ev
  virtual void  v25(); // _ZN7S1291C43v25Ev
  virtual void  v26(); // _ZN7S1291C43v26Ev
  virtual void  v27(); // _ZN7S1291C43v27Ev
  virtual void  v28(); // _ZN7S1291C43v28Ev
  virtual void  v29(); // _ZN7S1291C43v29Ev
  virtual void  v30(); // _ZN7S1291C43v30Ev
  virtual void  v31(); // _ZN7S1291C43v31Ev
  virtual void  v32(); // _ZN7S1291C43v32Ev
  virtual void  v33(); // _ZN7S1291C43v33Ev
  virtual void  v34(); // _ZN7S1291C43v34Ev
  virtual void  v35(); // _ZN7S1291C43v35Ev
  virtual void  v36(); // _ZN7S1291C43v36Ev
  virtual void  v37(); // _ZN7S1291C43v37Ev
  virtual void  v38(); // _ZN7S1291C43v38Ev
  virtual void  v39(); // _ZN7S1291C43v39Ev
  virtual void  v40(); // _ZN7S1291C43v40Ev
  virtual void  v41(); // _ZN7S1291C43v41Ev
  virtual void  v42(); // _ZN7S1291C43v42Ev
  virtual void  v43(); // _ZN7S1291C43v43Ev
  virtual void  v44(); // _ZN7S1291C43v44Ev
  virtual void  v45(); // _ZN7S1291C43v45Ev
  virtual void  v46(); // _ZN7S1291C43v46Ev
  virtual void  v47(); // _ZN7S1291C43v47Ev
  virtual void  v48(); // _ZN7S1291C43v48Ev
  virtual void  v49(); // _ZN7S1291C43v49Ev
  virtual void  v50(); // _ZN7S1291C43v50Ev
  virtual void  v51(); // _ZN7S1291C43v51Ev
  virtual void  v52(); // _ZN7S1291C43v52Ev
  virtual void  v53(); // _ZN7S1291C43v53Ev
  virtual void  v54(); // _ZN7S1291C43v54Ev
  virtual void  v55(); // _ZN7S1291C43v55Ev
  virtual void  v56(); // _ZN7S1291C43v56Ev
  virtual void  v57(); // _ZN7S1291C43v57Ev
  virtual void  v58(); // _ZN7S1291C43v58Ev
  virtual void  v59(); // _ZN7S1291C43v59Ev
  virtual void  v60(); // _ZN7S1291C43v60Ev
  virtual void  v61(); // _ZN7S1291C43v61Ev
  virtual void  v62(); // _ZN7S1291C43v62Ev
  virtual void  v63(); // _ZN7S1291C43v63Ev
  virtual void  v64(); // _ZN7S1291C43v64Ev
  virtual void  v65(); // _ZN7S1291C43v65Ev
  virtual void  v66(); // _ZN7S1291C43v66Ev
  virtual void  v67(); // _ZN7S1291C43v67Ev
  virtual void  v68(); // _ZN7S1291C43v68Ev
  virtual void  v69(); // _ZN7S1291C43v69Ev
  virtual void  v70(); // _ZN7S1291C43v70Ev
  virtual void  v71(); // _ZN7S1291C43v71Ev
  virtual void  v72(); // _ZN7S1291C43v72Ev
  virtual void  v73(); // _ZN7S1291C43v73Ev
  S1291C4(); // tgen
};
//SIG(-1 S1291C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1291C4 ::~S1291C4(){ note_dtor("S1291C4", this);}
void  S1291C4 ::v10(){vfunc_called(this, "_ZN7S1291C43v10Ev");}
void  S1291C4 ::v11(){vfunc_called(this, "_ZN7S1291C43v11Ev");}
void  S1291C4 ::v12(){vfunc_called(this, "_ZN7S1291C43v12Ev");}
void  S1291C4 ::v13(){vfunc_called(this, "_ZN7S1291C43v13Ev");}
void  S1291C4 ::v14(){vfunc_called(this, "_ZN7S1291C43v14Ev");}
void  S1291C4 ::v15(){vfunc_called(this, "_ZN7S1291C43v15Ev");}
void  S1291C4 ::v16(){vfunc_called(this, "_ZN7S1291C43v16Ev");}
void  S1291C4 ::v17(){vfunc_called(this, "_ZN7S1291C43v17Ev");}
void  S1291C4 ::v18(){vfunc_called(this, "_ZN7S1291C43v18Ev");}
void  S1291C4 ::v19(){vfunc_called(this, "_ZN7S1291C43v19Ev");}
void  S1291C4 ::v20(){vfunc_called(this, "_ZN7S1291C43v20Ev");}
void  S1291C4 ::v21(){vfunc_called(this, "_ZN7S1291C43v21Ev");}
void  S1291C4 ::v22(){vfunc_called(this, "_ZN7S1291C43v22Ev");}
void  S1291C4 ::v23(){vfunc_called(this, "_ZN7S1291C43v23Ev");}
void  S1291C4 ::v24(){vfunc_called(this, "_ZN7S1291C43v24Ev");}
void  S1291C4 ::v25(){vfunc_called(this, "_ZN7S1291C43v25Ev");}
void  S1291C4 ::v26(){vfunc_called(this, "_ZN7S1291C43v26Ev");}
void  S1291C4 ::v27(){vfunc_called(this, "_ZN7S1291C43v27Ev");}
void  S1291C4 ::v28(){vfunc_called(this, "_ZN7S1291C43v28Ev");}
void  S1291C4 ::v29(){vfunc_called(this, "_ZN7S1291C43v29Ev");}
void  S1291C4 ::v30(){vfunc_called(this, "_ZN7S1291C43v30Ev");}
void  S1291C4 ::v31(){vfunc_called(this, "_ZN7S1291C43v31Ev");}
void  S1291C4 ::v32(){vfunc_called(this, "_ZN7S1291C43v32Ev");}
void  S1291C4 ::v33(){vfunc_called(this, "_ZN7S1291C43v33Ev");}
void  S1291C4 ::v34(){vfunc_called(this, "_ZN7S1291C43v34Ev");}
void  S1291C4 ::v35(){vfunc_called(this, "_ZN7S1291C43v35Ev");}
void  S1291C4 ::v36(){vfunc_called(this, "_ZN7S1291C43v36Ev");}
void  S1291C4 ::v37(){vfunc_called(this, "_ZN7S1291C43v37Ev");}
void  S1291C4 ::v38(){vfunc_called(this, "_ZN7S1291C43v38Ev");}
void  S1291C4 ::v39(){vfunc_called(this, "_ZN7S1291C43v39Ev");}
void  S1291C4 ::v40(){vfunc_called(this, "_ZN7S1291C43v40Ev");}
void  S1291C4 ::v41(){vfunc_called(this, "_ZN7S1291C43v41Ev");}
void  S1291C4 ::v42(){vfunc_called(this, "_ZN7S1291C43v42Ev");}
void  S1291C4 ::v43(){vfunc_called(this, "_ZN7S1291C43v43Ev");}
void  S1291C4 ::v44(){vfunc_called(this, "_ZN7S1291C43v44Ev");}
void  S1291C4 ::v45(){vfunc_called(this, "_ZN7S1291C43v45Ev");}
void  S1291C4 ::v46(){vfunc_called(this, "_ZN7S1291C43v46Ev");}
void  S1291C4 ::v47(){vfunc_called(this, "_ZN7S1291C43v47Ev");}
void  S1291C4 ::v48(){vfunc_called(this, "_ZN7S1291C43v48Ev");}
void  S1291C4 ::v49(){vfunc_called(this, "_ZN7S1291C43v49Ev");}
void  S1291C4 ::v50(){vfunc_called(this, "_ZN7S1291C43v50Ev");}
void  S1291C4 ::v51(){vfunc_called(this, "_ZN7S1291C43v51Ev");}
void  S1291C4 ::v52(){vfunc_called(this, "_ZN7S1291C43v52Ev");}
void  S1291C4 ::v53(){vfunc_called(this, "_ZN7S1291C43v53Ev");}
void  S1291C4 ::v54(){vfunc_called(this, "_ZN7S1291C43v54Ev");}
void  S1291C4 ::v55(){vfunc_called(this, "_ZN7S1291C43v55Ev");}
void  S1291C4 ::v56(){vfunc_called(this, "_ZN7S1291C43v56Ev");}
void  S1291C4 ::v57(){vfunc_called(this, "_ZN7S1291C43v57Ev");}
void  S1291C4 ::v58(){vfunc_called(this, "_ZN7S1291C43v58Ev");}
void  S1291C4 ::v59(){vfunc_called(this, "_ZN7S1291C43v59Ev");}
void  S1291C4 ::v60(){vfunc_called(this, "_ZN7S1291C43v60Ev");}
void  S1291C4 ::v61(){vfunc_called(this, "_ZN7S1291C43v61Ev");}
void  S1291C4 ::v62(){vfunc_called(this, "_ZN7S1291C43v62Ev");}
void  S1291C4 ::v63(){vfunc_called(this, "_ZN7S1291C43v63Ev");}
void  S1291C4 ::v64(){vfunc_called(this, "_ZN7S1291C43v64Ev");}
void  S1291C4 ::v65(){vfunc_called(this, "_ZN7S1291C43v65Ev");}
void  S1291C4 ::v66(){vfunc_called(this, "_ZN7S1291C43v66Ev");}
void  S1291C4 ::v67(){vfunc_called(this, "_ZN7S1291C43v67Ev");}
void  S1291C4 ::v68(){vfunc_called(this, "_ZN7S1291C43v68Ev");}
void  S1291C4 ::v69(){vfunc_called(this, "_ZN7S1291C43v69Ev");}
void  S1291C4 ::v70(){vfunc_called(this, "_ZN7S1291C43v70Ev");}
void  S1291C4 ::v71(){vfunc_called(this, "_ZN7S1291C43v71Ev");}
void  S1291C4 ::v72(){vfunc_called(this, "_ZN7S1291C43v72Ev");}
void  S1291C4 ::v73(){vfunc_called(this, "_ZN7S1291C43v73Ev");}
S1291C4 ::S1291C4(){ note_ctor("S1291C4", this);} // tgen

static void Test_S1291C4()
{
  extern Class_Descriptor cd_S1291C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1291C4, buf);
    S1291C4 *dp, &lv = *(dp=new (buf) S1291C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1291C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1291C4)");
    check_field_offset(lv, s1291c4f0, ABISELECT(8,4), "S1291C4.s1291c4f0");
    check_field_offset(lv, s1291c4f1, ABISELECT(16,8), "S1291C4.s1291c4f1");
    check_field_offset(lv, s1291c4f2, ABISELECT(24,16), "S1291C4.s1291c4f2");
    check_field_offset(lv, s1291c4f3, ABISELECT(56,32), "S1291C4.s1291c4f3");
    check_field_offset(lv, s1291c4f4, ABISELECT(64,40), "S1291C4.s1291c4f4");
    check_field_offset(lv, s1291c4f5, ABISELECT(72,44), "S1291C4.s1291c4f5");
    check_field_offset(lv, s1291c4f6, ABISELECT(80,52), "S1291C4.s1291c4f6");
    test_class_info(&lv, &cd_S1291C4);
    dp->~S1291C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1291C4(Test_S1291C4, "S1291C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1291C4C1Ev();
extern void _ZN7S1291C4D1Ev();
Name_Map name_map_S1291C4[] = {
  NSPAIR(_ZN7S1291C4C1Ev),
  NSPAIR(_ZN7S1291C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1291C4[];
extern void _ZN7S1291C4D1Ev();
extern void _ZN7S1291C4D0Ev();
extern void _ZN7S1291C43v10Ev();
extern void _ZN7S1291C43v11Ev();
extern void _ZN7S1291C43v12Ev();
extern void _ZN7S1291C43v13Ev();
extern void _ZN7S1291C43v14Ev();
extern void _ZN7S1291C43v15Ev();
extern void _ZN7S1291C43v16Ev();
extern void _ZN7S1291C43v17Ev();
extern void _ZN7S1291C43v18Ev();
extern void _ZN7S1291C43v19Ev();
extern void _ZN7S1291C43v20Ev();
extern void _ZN7S1291C43v21Ev();
extern void _ZN7S1291C43v22Ev();
extern void _ZN7S1291C43v23Ev();
extern void _ZN7S1291C43v24Ev();
extern void _ZN7S1291C43v25Ev();
extern void _ZN7S1291C43v26Ev();
extern void _ZN7S1291C43v27Ev();
extern void _ZN7S1291C43v28Ev();
extern void _ZN7S1291C43v29Ev();
extern void _ZN7S1291C43v30Ev();
extern void _ZN7S1291C43v31Ev();
extern void _ZN7S1291C43v32Ev();
extern void _ZN7S1291C43v33Ev();
extern void _ZN7S1291C43v34Ev();
extern void _ZN7S1291C43v35Ev();
extern void _ZN7S1291C43v36Ev();
extern void _ZN7S1291C43v37Ev();
extern void _ZN7S1291C43v38Ev();
extern void _ZN7S1291C43v39Ev();
extern void _ZN7S1291C43v40Ev();
extern void _ZN7S1291C43v41Ev();
extern void _ZN7S1291C43v42Ev();
extern void _ZN7S1291C43v43Ev();
extern void _ZN7S1291C43v44Ev();
extern void _ZN7S1291C43v45Ev();
extern void _ZN7S1291C43v46Ev();
extern void _ZN7S1291C43v47Ev();
extern void _ZN7S1291C43v48Ev();
extern void _ZN7S1291C43v49Ev();
extern void _ZN7S1291C43v50Ev();
extern void _ZN7S1291C43v51Ev();
extern void _ZN7S1291C43v52Ev();
extern void _ZN7S1291C43v53Ev();
extern void _ZN7S1291C43v54Ev();
extern void _ZN7S1291C43v55Ev();
extern void _ZN7S1291C43v56Ev();
extern void _ZN7S1291C43v57Ev();
extern void _ZN7S1291C43v58Ev();
extern void _ZN7S1291C43v59Ev();
extern void _ZN7S1291C43v60Ev();
extern void _ZN7S1291C43v61Ev();
extern void _ZN7S1291C43v62Ev();
extern void _ZN7S1291C43v63Ev();
extern void _ZN7S1291C43v64Ev();
extern void _ZN7S1291C43v65Ev();
extern void _ZN7S1291C43v66Ev();
extern void _ZN7S1291C43v67Ev();
extern void _ZN7S1291C43v68Ev();
extern void _ZN7S1291C43v69Ev();
extern void _ZN7S1291C43v70Ev();
extern void _ZN7S1291C43v71Ev();
extern void _ZN7S1291C43v72Ev();
extern void _ZN7S1291C43v73Ev();
static  VTBL_ENTRY vtc_S1291C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1291C4[0]),
  (VTBL_ENTRY)&_ZN7S1291C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1291C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v73Ev,
};
extern VTBL_ENTRY _ZTI7S1291C4[];
extern  VTBL_ENTRY _ZTV7S1291C4[];
Class_Descriptor cd_S1291C4 = {  "S1291C4", // class name
  0,0,//no base classes
  &(vtc_S1291C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1291C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1291C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1291C3  : S1291C4 {
  unsigned int s1291c3f0:1;
  unsigned int s1291c3f1:1;
  unsigned int s1291c3f2:1;
  unsigned int s1291c3f3:1;
  unsigned int s1291c3f4:1;
  unsigned int s1291c3f5:1;
  unsigned int s1291c3f6:1;
  ::S578C11_nt s1291c3f7;
  virtual  ~S1291C3(); // _ZN7S1291C3D1Ev
  virtual void  v74(); // _ZN7S1291C33v74Ev
  virtual void  v75(); // _ZN7S1291C33v75Ev
  virtual void  v76(); // _ZN7S1291C33v76Ev
  virtual void  v77(); // _ZN7S1291C33v77Ev
  virtual void  v78(); // _ZN7S1291C33v78Ev
  virtual void  v79(); // _ZN7S1291C33v79Ev
  virtual void  v80(); // _ZN7S1291C33v80Ev
  virtual void  v81(); // _ZN7S1291C33v81Ev
  virtual void  v82(); // _ZN7S1291C33v82Ev
  virtual void  v83(); // _ZN7S1291C33v83Ev
  virtual void  v84(); // _ZN7S1291C33v84Ev
  virtual void  v85(); // _ZN7S1291C33v85Ev
  virtual void  v86(); // _ZN7S1291C33v86Ev
  virtual void  v87(); // _ZN7S1291C33v87Ev
  virtual void  v88(); // _ZN7S1291C33v88Ev
  virtual void  v89(); // _ZN7S1291C33v89Ev
  virtual void  v90(); // _ZN7S1291C33v90Ev
  virtual void  v91(); // _ZN7S1291C33v91Ev
  virtual void  v92(); // _ZN7S1291C33v92Ev
  virtual void  v93(); // _ZN7S1291C33v93Ev
  S1291C3(); // tgen
};
//SIG(-1 S1291C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1291C3 ::~S1291C3(){ note_dtor("S1291C3", this);}
void  S1291C3 ::v74(){vfunc_called(this, "_ZN7S1291C33v74Ev");}
void  S1291C3 ::v75(){vfunc_called(this, "_ZN7S1291C33v75Ev");}
void  S1291C3 ::v76(){vfunc_called(this, "_ZN7S1291C33v76Ev");}
void  S1291C3 ::v77(){vfunc_called(this, "_ZN7S1291C33v77Ev");}
void  S1291C3 ::v78(){vfunc_called(this, "_ZN7S1291C33v78Ev");}
void  S1291C3 ::v79(){vfunc_called(this, "_ZN7S1291C33v79Ev");}
void  S1291C3 ::v80(){vfunc_called(this, "_ZN7S1291C33v80Ev");}
void  S1291C3 ::v81(){vfunc_called(this, "_ZN7S1291C33v81Ev");}
void  S1291C3 ::v82(){vfunc_called(this, "_ZN7S1291C33v82Ev");}
void  S1291C3 ::v83(){vfunc_called(this, "_ZN7S1291C33v83Ev");}
void  S1291C3 ::v84(){vfunc_called(this, "_ZN7S1291C33v84Ev");}
void  S1291C3 ::v85(){vfunc_called(this, "_ZN7S1291C33v85Ev");}
void  S1291C3 ::v86(){vfunc_called(this, "_ZN7S1291C33v86Ev");}
void  S1291C3 ::v87(){vfunc_called(this, "_ZN7S1291C33v87Ev");}
void  S1291C3 ::v88(){vfunc_called(this, "_ZN7S1291C33v88Ev");}
void  S1291C3 ::v89(){vfunc_called(this, "_ZN7S1291C33v89Ev");}
void  S1291C3 ::v90(){vfunc_called(this, "_ZN7S1291C33v90Ev");}
void  S1291C3 ::v91(){vfunc_called(this, "_ZN7S1291C33v91Ev");}
void  S1291C3 ::v92(){vfunc_called(this, "_ZN7S1291C33v92Ev");}
void  S1291C3 ::v93(){vfunc_called(this, "_ZN7S1291C33v93Ev");}
S1291C3 ::S1291C3(){ note_ctor("S1291C3", this);} // tgen

static void Test_S1291C3()
{
  extern Class_Descriptor cd_S1291C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1291C3, buf);
    S1291C3 *dp, &lv = *(dp=new (buf) S1291C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1291C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1291C3)");
    check_base_class_offset(lv, (S1291C4*), 0, "S1291C3");
    set_bf_and_test(lv, s1291c3f0, ABISELECT(96,60), 0, 1, 1, "S1291C3");
    set_bf_and_test(lv, s1291c3f1, ABISELECT(96,60), 1, 1, 1, "S1291C3");
    set_bf_and_test(lv, s1291c3f2, ABISELECT(96,60), 2, 1, 1, "S1291C3");
    set_bf_and_test(lv, s1291c3f3, ABISELECT(96,60), 3, 1, 1, "S1291C3");
    set_bf_and_test(lv, s1291c3f4, ABISELECT(96,60), 4, 1, 1, "S1291C3");
    set_bf_and_test(lv, s1291c3f5, ABISELECT(96,60), 5, 1, 1, "S1291C3");
    set_bf_and_test(lv, s1291c3f6, ABISELECT(96,60), 6, 1, 1, "S1291C3");
    check_field_offset(lv, s1291c3f7, ABISELECT(97,61), "S1291C3.s1291c3f7");
    test_class_info(&lv, &cd_S1291C3);
    dp->~S1291C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1291C3(Test_S1291C3, "S1291C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1291C3C1Ev();
extern void _ZN7S1291C3D1Ev();
Name_Map name_map_S1291C3[] = {
  NSPAIR(_ZN7S1291C3C1Ev),
  NSPAIR(_ZN7S1291C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1291C4;
extern VTBL_ENTRY _ZTI7S1291C4[];
extern  VTBL_ENTRY _ZTV7S1291C4[];
static Base_Class bases_S1291C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1291C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1291C3[];
extern void _ZN7S1291C3D1Ev();
extern void _ZN7S1291C3D0Ev();
extern void _ZN7S1291C43v10Ev();
extern void _ZN7S1291C43v11Ev();
extern void _ZN7S1291C43v12Ev();
extern void _ZN7S1291C43v13Ev();
extern void _ZN7S1291C43v14Ev();
extern void _ZN7S1291C43v15Ev();
extern void _ZN7S1291C43v16Ev();
extern void _ZN7S1291C43v17Ev();
extern void _ZN7S1291C43v18Ev();
extern void _ZN7S1291C43v19Ev();
extern void _ZN7S1291C43v20Ev();
extern void _ZN7S1291C43v21Ev();
extern void _ZN7S1291C43v22Ev();
extern void _ZN7S1291C43v23Ev();
extern void _ZN7S1291C43v24Ev();
extern void _ZN7S1291C43v25Ev();
extern void _ZN7S1291C43v26Ev();
extern void _ZN7S1291C43v27Ev();
extern void _ZN7S1291C43v28Ev();
extern void _ZN7S1291C43v29Ev();
extern void _ZN7S1291C43v30Ev();
extern void _ZN7S1291C43v31Ev();
extern void _ZN7S1291C43v32Ev();
extern void _ZN7S1291C43v33Ev();
extern void _ZN7S1291C43v34Ev();
extern void _ZN7S1291C43v35Ev();
extern void _ZN7S1291C43v36Ev();
extern void _ZN7S1291C43v37Ev();
extern void _ZN7S1291C43v38Ev();
extern void _ZN7S1291C43v39Ev();
extern void _ZN7S1291C43v40Ev();
extern void _ZN7S1291C43v41Ev();
extern void _ZN7S1291C43v42Ev();
extern void _ZN7S1291C43v43Ev();
extern void _ZN7S1291C43v44Ev();
extern void _ZN7S1291C43v45Ev();
extern void _ZN7S1291C43v46Ev();
extern void _ZN7S1291C43v47Ev();
extern void _ZN7S1291C43v48Ev();
extern void _ZN7S1291C43v49Ev();
extern void _ZN7S1291C43v50Ev();
extern void _ZN7S1291C43v51Ev();
extern void _ZN7S1291C43v52Ev();
extern void _ZN7S1291C43v53Ev();
extern void _ZN7S1291C43v54Ev();
extern void _ZN7S1291C43v55Ev();
extern void _ZN7S1291C43v56Ev();
extern void _ZN7S1291C43v57Ev();
extern void _ZN7S1291C43v58Ev();
extern void _ZN7S1291C43v59Ev();
extern void _ZN7S1291C43v60Ev();
extern void _ZN7S1291C43v61Ev();
extern void _ZN7S1291C43v62Ev();
extern void _ZN7S1291C43v63Ev();
extern void _ZN7S1291C43v64Ev();
extern void _ZN7S1291C43v65Ev();
extern void _ZN7S1291C43v66Ev();
extern void _ZN7S1291C43v67Ev();
extern void _ZN7S1291C43v68Ev();
extern void _ZN7S1291C43v69Ev();
extern void _ZN7S1291C43v70Ev();
extern void _ZN7S1291C43v71Ev();
extern void _ZN7S1291C43v72Ev();
extern void _ZN7S1291C43v73Ev();
extern void _ZN7S1291C33v74Ev();
extern void _ZN7S1291C33v75Ev();
extern void _ZN7S1291C33v76Ev();
extern void _ZN7S1291C33v77Ev();
extern void _ZN7S1291C33v78Ev();
extern void _ZN7S1291C33v79Ev();
extern void _ZN7S1291C33v80Ev();
extern void _ZN7S1291C33v81Ev();
extern void _ZN7S1291C33v82Ev();
extern void _ZN7S1291C33v83Ev();
extern void _ZN7S1291C33v84Ev();
extern void _ZN7S1291C33v85Ev();
extern void _ZN7S1291C33v86Ev();
extern void _ZN7S1291C33v87Ev();
extern void _ZN7S1291C33v88Ev();
extern void _ZN7S1291C33v89Ev();
extern void _ZN7S1291C33v90Ev();
extern void _ZN7S1291C33v91Ev();
extern void _ZN7S1291C33v92Ev();
extern void _ZN7S1291C33v93Ev();
static  VTBL_ENTRY vtc_S1291C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1291C3[0]),
  (VTBL_ENTRY)&_ZN7S1291C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1291C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v93Ev,
};
extern VTBL_ENTRY _ZTI7S1291C3[];
extern  VTBL_ENTRY _ZTV7S1291C3[];
Class_Descriptor cd_S1291C3 = {  "S1291C3", // class name
  bases_S1291C3, 1,
  &(vtc_S1291C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1291C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1291C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1291C2_nt  : S1291C3 {
  virtual  ~S1291C2_nt(); // _ZN10S1291C2_ntD1Ev
  virtual void  v94(); // _ZN10S1291C2_nt3v94Ev
  virtual void  v95(); // _ZN10S1291C2_nt3v95Ev
  virtual void  v96(); // _ZN10S1291C2_nt3v96Ev
  S1291C2_nt(); // tgen
};
//SIG(-1 S1291C2_nt) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3}


 S1291C2_nt ::~S1291C2_nt(){ note_dtor("S1291C2_nt", this);}
void  S1291C2_nt ::v94(){vfunc_called(this, "_ZN10S1291C2_nt3v94Ev");}
void  S1291C2_nt ::v95(){vfunc_called(this, "_ZN10S1291C2_nt3v95Ev");}
void  S1291C2_nt ::v96(){vfunc_called(this, "_ZN10S1291C2_nt3v96Ev");}
S1291C2_nt ::S1291C2_nt(){ note_ctor("S1291C2_nt", this);} // tgen

//skip512 S1291C2_nt

#else // __cplusplus

extern void _ZN10S1291C2_ntC1Ev();
extern void _ZN10S1291C2_ntD1Ev();
Name_Map name_map_S1291C2_nt[] = {
  NSPAIR(_ZN10S1291C2_ntC1Ev),
  NSPAIR(_ZN10S1291C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1291C4;
extern VTBL_ENTRY _ZTI7S1291C4[];
extern  VTBL_ENTRY _ZTV7S1291C4[];
extern Class_Descriptor cd_S1291C3;
extern VTBL_ENTRY _ZTI7S1291C3[];
extern  VTBL_ENTRY _ZTV7S1291C3[];
static Base_Class bases_S1291C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1291C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1291C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1291C2_nt[];
extern void _ZN10S1291C2_ntD1Ev();
extern void _ZN10S1291C2_ntD0Ev();
extern void _ZN7S1291C43v10Ev();
extern void _ZN7S1291C43v11Ev();
extern void _ZN7S1291C43v12Ev();
extern void _ZN7S1291C43v13Ev();
extern void _ZN7S1291C43v14Ev();
extern void _ZN7S1291C43v15Ev();
extern void _ZN7S1291C43v16Ev();
extern void _ZN7S1291C43v17Ev();
extern void _ZN7S1291C43v18Ev();
extern void _ZN7S1291C43v19Ev();
extern void _ZN7S1291C43v20Ev();
extern void _ZN7S1291C43v21Ev();
extern void _ZN7S1291C43v22Ev();
extern void _ZN7S1291C43v23Ev();
extern void _ZN7S1291C43v24Ev();
extern void _ZN7S1291C43v25Ev();
extern void _ZN7S1291C43v26Ev();
extern void _ZN7S1291C43v27Ev();
extern void _ZN7S1291C43v28Ev();
extern void _ZN7S1291C43v29Ev();
extern void _ZN7S1291C43v30Ev();
extern void _ZN7S1291C43v31Ev();
extern void _ZN7S1291C43v32Ev();
extern void _ZN7S1291C43v33Ev();
extern void _ZN7S1291C43v34Ev();
extern void _ZN7S1291C43v35Ev();
extern void _ZN7S1291C43v36Ev();
extern void _ZN7S1291C43v37Ev();
extern void _ZN7S1291C43v38Ev();
extern void _ZN7S1291C43v39Ev();
extern void _ZN7S1291C43v40Ev();
extern void _ZN7S1291C43v41Ev();
extern void _ZN7S1291C43v42Ev();
extern void _ZN7S1291C43v43Ev();
extern void _ZN7S1291C43v44Ev();
extern void _ZN7S1291C43v45Ev();
extern void _ZN7S1291C43v46Ev();
extern void _ZN7S1291C43v47Ev();
extern void _ZN7S1291C43v48Ev();
extern void _ZN7S1291C43v49Ev();
extern void _ZN7S1291C43v50Ev();
extern void _ZN7S1291C43v51Ev();
extern void _ZN7S1291C43v52Ev();
extern void _ZN7S1291C43v53Ev();
extern void _ZN7S1291C43v54Ev();
extern void _ZN7S1291C43v55Ev();
extern void _ZN7S1291C43v56Ev();
extern void _ZN7S1291C43v57Ev();
extern void _ZN7S1291C43v58Ev();
extern void _ZN7S1291C43v59Ev();
extern void _ZN7S1291C43v60Ev();
extern void _ZN7S1291C43v61Ev();
extern void _ZN7S1291C43v62Ev();
extern void _ZN7S1291C43v63Ev();
extern void _ZN7S1291C43v64Ev();
extern void _ZN7S1291C43v65Ev();
extern void _ZN7S1291C43v66Ev();
extern void _ZN7S1291C43v67Ev();
extern void _ZN7S1291C43v68Ev();
extern void _ZN7S1291C43v69Ev();
extern void _ZN7S1291C43v70Ev();
extern void _ZN7S1291C43v71Ev();
extern void _ZN7S1291C43v72Ev();
extern void _ZN7S1291C43v73Ev();
extern void _ZN7S1291C33v74Ev();
extern void _ZN7S1291C33v75Ev();
extern void _ZN7S1291C33v76Ev();
extern void _ZN7S1291C33v77Ev();
extern void _ZN7S1291C33v78Ev();
extern void _ZN7S1291C33v79Ev();
extern void _ZN7S1291C33v80Ev();
extern void _ZN7S1291C33v81Ev();
extern void _ZN7S1291C33v82Ev();
extern void _ZN7S1291C33v83Ev();
extern void _ZN7S1291C33v84Ev();
extern void _ZN7S1291C33v85Ev();
extern void _ZN7S1291C33v86Ev();
extern void _ZN7S1291C33v87Ev();
extern void _ZN7S1291C33v88Ev();
extern void _ZN7S1291C33v89Ev();
extern void _ZN7S1291C33v90Ev();
extern void _ZN7S1291C33v91Ev();
extern void _ZN7S1291C33v92Ev();
extern void _ZN7S1291C33v93Ev();
extern void _ZN10S1291C2_nt3v94Ev();
extern void _ZN10S1291C2_nt3v95Ev();
extern void _ZN10S1291C2_nt3v96Ev();
static  VTBL_ENTRY vtc_S1291C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1291C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1291C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1291C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v93Ev,
  (VTBL_ENTRY)&_ZN10S1291C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1291C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1291C2_nt3v96Ev,
};
extern VTBL_ENTRY _ZTI10S1291C2_nt[];
VTBL_ENTRY *P__ZTI10S1291C2_nt = _ZTI10S1291C2_nt; 
extern  VTBL_ENTRY _ZTV10S1291C2_nt[];
Class_Descriptor cd_S1291C2_nt = {  "S1291C2_nt", // class name
  bases_S1291C2_nt, 2,
  &(vtc_S1291C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI10S1291C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1291C2_nt),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1291C1  : S1291C2_nt {
  char s1291c1f0;
  ::S1597C7_nt s1291c1f1;
  virtual  ~S1291C1(); // _ZN7S1291C1D1Ev
  virtual void  v1(); // _ZN7S1291C12v1Ev
  virtual void  v2(); // _ZN7S1291C12v2Ev
  virtual void  v3(); // _ZN7S1291C12v3Ev
  virtual void  v4(); // _ZN7S1291C12v4Ev
  virtual void  v5(); // _ZN7S1291C12v5Ev
  virtual void  v6(); // _ZN7S1291C12v6Ev
  virtual void  v7(); // _ZN7S1291C12v7Ev
  virtual void  v8(); // _ZN7S1291C12v8Ev
  virtual void  v9(); // _ZN7S1291C12v9Ev
  S1291C1(); // tgen
};
//SIG(1 S1291C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v94 v95 v96} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fc FC7{ BC8{ m Fc[4] FC9{ BC10{ BC11{ m Fp Fi[2]}}} Fi[2]} Fp}}


 S1291C1 ::~S1291C1(){ note_dtor("S1291C1", this);}
void  S1291C1 ::v1(){vfunc_called(this, "_ZN7S1291C12v1Ev");}
void  S1291C1 ::v2(){vfunc_called(this, "_ZN7S1291C12v2Ev");}
void  S1291C1 ::v3(){vfunc_called(this, "_ZN7S1291C12v3Ev");}
void  S1291C1 ::v4(){vfunc_called(this, "_ZN7S1291C12v4Ev");}
void  S1291C1 ::v5(){vfunc_called(this, "_ZN7S1291C12v5Ev");}
void  S1291C1 ::v6(){vfunc_called(this, "_ZN7S1291C12v6Ev");}
void  S1291C1 ::v7(){vfunc_called(this, "_ZN7S1291C12v7Ev");}
void  S1291C1 ::v8(){vfunc_called(this, "_ZN7S1291C12v8Ev");}
void  S1291C1 ::v9(){vfunc_called(this, "_ZN7S1291C12v9Ev");}
S1291C1 ::S1291C1(){ note_ctor("S1291C1", this);} // tgen

static void Test_S1291C1()
{
  extern Class_Descriptor cd_S1291C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,24)];
    init_test(&cd_S1291C1, buf);
    S1291C1 *dp, &lv = *(dp=new (buf) S1291C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,92), "sizeof(S1291C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1291C1)");
    check_base_class_offset(lv, (S1291C4*)(S1291C3*)(S1291C2_nt*), 0, "S1291C1");
    check_base_class_offset(lv, (S1291C3*)(S1291C2_nt*), 0, "S1291C1");
    check_base_class_offset(lv, (S1291C2_nt*), 0, "S1291C1");
    check_field_offset(lv, s1291c1f0, ABISELECT(98,62), "S1291C1.s1291c1f0");
    check_field_offset(lv, s1291c1f1, ABISELECT(104,64), "S1291C1.s1291c1f1");
    test_class_info(&lv, &cd_S1291C1);
    dp->~S1291C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1291C1(Test_S1291C1, "S1291C1", ABISELECT(144,92));

#else // __cplusplus

extern void _ZN7S1291C1C1Ev();
extern void _ZN7S1291C1D1Ev();
Name_Map name_map_S1291C1[] = {
  NSPAIR(_ZN7S1291C1C1Ev),
  NSPAIR(_ZN7S1291C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1291C4;
extern VTBL_ENTRY _ZTI7S1291C4[];
extern  VTBL_ENTRY _ZTV7S1291C4[];
extern Class_Descriptor cd_S1291C3;
extern VTBL_ENTRY _ZTI7S1291C3[];
extern  VTBL_ENTRY _ZTV7S1291C3[];
extern Class_Descriptor cd_S1291C2_nt;
extern VTBL_ENTRY _ZTI10S1291C2_nt[];
extern  VTBL_ENTRY _ZTV10S1291C2_nt[];
static Base_Class bases_S1291C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1291C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1291C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1291C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1291C1[];
extern void _ZN7S1291C1D1Ev();
extern void _ZN7S1291C1D0Ev();
extern void _ZN7S1291C43v10Ev();
extern void _ZN7S1291C43v11Ev();
extern void _ZN7S1291C43v12Ev();
extern void _ZN7S1291C43v13Ev();
extern void _ZN7S1291C43v14Ev();
extern void _ZN7S1291C43v15Ev();
extern void _ZN7S1291C43v16Ev();
extern void _ZN7S1291C43v17Ev();
extern void _ZN7S1291C43v18Ev();
extern void _ZN7S1291C43v19Ev();
extern void _ZN7S1291C43v20Ev();
extern void _ZN7S1291C43v21Ev();
extern void _ZN7S1291C43v22Ev();
extern void _ZN7S1291C43v23Ev();
extern void _ZN7S1291C43v24Ev();
extern void _ZN7S1291C43v25Ev();
extern void _ZN7S1291C43v26Ev();
extern void _ZN7S1291C43v27Ev();
extern void _ZN7S1291C43v28Ev();
extern void _ZN7S1291C43v29Ev();
extern void _ZN7S1291C43v30Ev();
extern void _ZN7S1291C43v31Ev();
extern void _ZN7S1291C43v32Ev();
extern void _ZN7S1291C43v33Ev();
extern void _ZN7S1291C43v34Ev();
extern void _ZN7S1291C43v35Ev();
extern void _ZN7S1291C43v36Ev();
extern void _ZN7S1291C43v37Ev();
extern void _ZN7S1291C43v38Ev();
extern void _ZN7S1291C43v39Ev();
extern void _ZN7S1291C43v40Ev();
extern void _ZN7S1291C43v41Ev();
extern void _ZN7S1291C43v42Ev();
extern void _ZN7S1291C43v43Ev();
extern void _ZN7S1291C43v44Ev();
extern void _ZN7S1291C43v45Ev();
extern void _ZN7S1291C43v46Ev();
extern void _ZN7S1291C43v47Ev();
extern void _ZN7S1291C43v48Ev();
extern void _ZN7S1291C43v49Ev();
extern void _ZN7S1291C43v50Ev();
extern void _ZN7S1291C43v51Ev();
extern void _ZN7S1291C43v52Ev();
extern void _ZN7S1291C43v53Ev();
extern void _ZN7S1291C43v54Ev();
extern void _ZN7S1291C43v55Ev();
extern void _ZN7S1291C43v56Ev();
extern void _ZN7S1291C43v57Ev();
extern void _ZN7S1291C43v58Ev();
extern void _ZN7S1291C43v59Ev();
extern void _ZN7S1291C43v60Ev();
extern void _ZN7S1291C43v61Ev();
extern void _ZN7S1291C43v62Ev();
extern void _ZN7S1291C43v63Ev();
extern void _ZN7S1291C43v64Ev();
extern void _ZN7S1291C43v65Ev();
extern void _ZN7S1291C43v66Ev();
extern void _ZN7S1291C43v67Ev();
extern void _ZN7S1291C43v68Ev();
extern void _ZN7S1291C43v69Ev();
extern void _ZN7S1291C43v70Ev();
extern void _ZN7S1291C43v71Ev();
extern void _ZN7S1291C43v72Ev();
extern void _ZN7S1291C43v73Ev();
extern void _ZN7S1291C33v74Ev();
extern void _ZN7S1291C33v75Ev();
extern void _ZN7S1291C33v76Ev();
extern void _ZN7S1291C33v77Ev();
extern void _ZN7S1291C33v78Ev();
extern void _ZN7S1291C33v79Ev();
extern void _ZN7S1291C33v80Ev();
extern void _ZN7S1291C33v81Ev();
extern void _ZN7S1291C33v82Ev();
extern void _ZN7S1291C33v83Ev();
extern void _ZN7S1291C33v84Ev();
extern void _ZN7S1291C33v85Ev();
extern void _ZN7S1291C33v86Ev();
extern void _ZN7S1291C33v87Ev();
extern void _ZN7S1291C33v88Ev();
extern void _ZN7S1291C33v89Ev();
extern void _ZN7S1291C33v90Ev();
extern void _ZN7S1291C33v91Ev();
extern void _ZN7S1291C33v92Ev();
extern void _ZN7S1291C33v93Ev();
extern void _ZN10S1291C2_nt3v94Ev();
extern void _ZN10S1291C2_nt3v95Ev();
extern void _ZN10S1291C2_nt3v96Ev();
extern void _ZN7S1291C12v1Ev();
extern void _ZN7S1291C12v2Ev();
extern void _ZN7S1291C12v3Ev();
extern void _ZN7S1291C12v4Ev();
extern void _ZN7S1291C12v5Ev();
extern void _ZN7S1291C12v6Ev();
extern void _ZN7S1291C12v7Ev();
extern void _ZN7S1291C12v8Ev();
extern void _ZN7S1291C12v9Ev();
static  VTBL_ENTRY vtc_S1291C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1291C1[0]),
  (VTBL_ENTRY)&_ZN7S1291C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1291C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1291C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1291C33v93Ev,
  (VTBL_ENTRY)&_ZN10S1291C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1291C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1291C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN7S1291C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1291C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1291C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1291C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1291C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1291C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1291C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1291C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1291C12v9Ev,
};
extern VTBL_ENTRY _ZTI7S1291C1[];
extern  VTBL_ENTRY _ZTV7S1291C1[];
Class_Descriptor cd_S1291C1 = {  "S1291C1", // class name
  bases_S1291C1, 3,
  &(vtc_S1291C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,92), // object size
  NSPAIRA(_ZTI7S1291C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1291C1),100, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C5_nt  {
  void *s16431c5f0;
  void  mf16431c5(); // _ZN11S16431C5_nt9mf16431c5Ev
};
//SIG(-1 S16431C5_nt) C1{ m Fp}


void  S16431C5_nt ::mf16431c5(){}

//skip512 S16431C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C7  {
  ::S8644C5_nt s16431c7f0;
  ::S8644C30_nt s16431c7f1;
  void  mf16431c7(); // _ZN8S16431C79mf16431c7Ev
};
//SIG(-1 S16431C7) C1{ m FC2{ BC3{ m FC4{ m Fc[16]} FC4 FC4 FC4}} FC5{ BC4}}


void  S16431C7 ::mf16431c7(){}

static void Test_S16431C7()
{
  {
    init_simple_test("S16431C7");
    S16431C7 lv;
    check2(sizeof(lv), 80, "sizeof(S16431C7)");
    check2(__alignof__(lv), 1, "__alignof__(S16431C7)");
    check_field_offset(lv, s16431c7f0, 0, "S16431C7.s16431c7f0");
    check_field_offset(lv, s16431c7f1, 64, "S16431C7.s16431c7f1");
  }
}
static Arrange_To_Call_Me vS16431C7(Test_S16431C7, "S16431C7", 80);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C13_nt  {
  virtual  ~S16431C13_nt(); // _ZN12S16431C13_ntD1Ev
  virtual void  v15(); // _ZN12S16431C13_nt3v15Ev
  virtual void  v16(); // _ZN12S16431C13_nt3v16Ev
  virtual void  v17(); // _ZN12S16431C13_nt3v17Ev
  virtual void  v18(); // _ZN12S16431C13_nt3v18Ev
  virtual void  v19(); // _ZN12S16431C13_nt3v19Ev
  virtual void  v20(); // _ZN12S16431C13_nt3v20Ev
  virtual void  v21(); // _ZN12S16431C13_nt3v21Ev
  virtual void  v22(); // _ZN12S16431C13_nt3v22Ev
  virtual void  v23(); // _ZN12S16431C13_nt3v23Ev
  virtual void  v24(); // _ZN12S16431C13_nt3v24Ev
  virtual void  v25(); // _ZN12S16431C13_nt3v25Ev
  virtual void  v26(); // _ZN12S16431C13_nt3v26Ev
  virtual void  v27(); // _ZN12S16431C13_nt3v27Ev
  virtual void  v28(); // _ZN12S16431C13_nt3v28Ev
  S16431C13_nt(); // tgen
};
//SIG(-1 S16431C13_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14}


 S16431C13_nt ::~S16431C13_nt(){ note_dtor("S16431C13_nt", this);}
void  S16431C13_nt ::v15(){vfunc_called(this, "_ZN12S16431C13_nt3v15Ev");}
void  S16431C13_nt ::v16(){vfunc_called(this, "_ZN12S16431C13_nt3v16Ev");}
void  S16431C13_nt ::v17(){vfunc_called(this, "_ZN12S16431C13_nt3v17Ev");}
void  S16431C13_nt ::v18(){vfunc_called(this, "_ZN12S16431C13_nt3v18Ev");}
void  S16431C13_nt ::v19(){vfunc_called(this, "_ZN12S16431C13_nt3v19Ev");}
void  S16431C13_nt ::v20(){vfunc_called(this, "_ZN12S16431C13_nt3v20Ev");}
void  S16431C13_nt ::v21(){vfunc_called(this, "_ZN12S16431C13_nt3v21Ev");}
void  S16431C13_nt ::v22(){vfunc_called(this, "_ZN12S16431C13_nt3v22Ev");}
void  S16431C13_nt ::v23(){vfunc_called(this, "_ZN12S16431C13_nt3v23Ev");}
void  S16431C13_nt ::v24(){vfunc_called(this, "_ZN12S16431C13_nt3v24Ev");}
void  S16431C13_nt ::v25(){vfunc_called(this, "_ZN12S16431C13_nt3v25Ev");}
void  S16431C13_nt ::v26(){vfunc_called(this, "_ZN12S16431C13_nt3v26Ev");}
void  S16431C13_nt ::v27(){vfunc_called(this, "_ZN12S16431C13_nt3v27Ev");}
void  S16431C13_nt ::v28(){vfunc_called(this, "_ZN12S16431C13_nt3v28Ev");}
S16431C13_nt ::S16431C13_nt(){ note_ctor("S16431C13_nt", this);} // tgen

//skip512 S16431C13_nt

#else // __cplusplus

extern void _ZN12S16431C13_ntC1Ev();
extern void _ZN12S16431C13_ntD1Ev();
Name_Map name_map_S16431C13_nt[] = {
  NSPAIR(_ZN12S16431C13_ntC1Ev),
  NSPAIR(_ZN12S16431C13_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S16431C13_nt[];
extern void _ZN12S16431C13_ntD1Ev();
extern void _ZN12S16431C13_ntD0Ev();
extern void _ZN12S16431C13_nt3v15Ev();
extern void _ZN12S16431C13_nt3v16Ev();
extern void _ZN12S16431C13_nt3v17Ev();
extern void _ZN12S16431C13_nt3v18Ev();
extern void _ZN12S16431C13_nt3v19Ev();
extern void _ZN12S16431C13_nt3v20Ev();
extern void _ZN12S16431C13_nt3v21Ev();
extern void _ZN12S16431C13_nt3v22Ev();
extern void _ZN12S16431C13_nt3v23Ev();
extern void _ZN12S16431C13_nt3v24Ev();
extern void _ZN12S16431C13_nt3v25Ev();
extern void _ZN12S16431C13_nt3v26Ev();
extern void _ZN12S16431C13_nt3v27Ev();
extern void _ZN12S16431C13_nt3v28Ev();
static  VTBL_ENTRY vtc_S16431C13_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S16431C13_nt[0]),
  (VTBL_ENTRY)&_ZN12S16431C13_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v15Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v16Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v17Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v18Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v19Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v20Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v21Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v22Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v23Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v24Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v25Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v26Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v27Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v28Ev,
};
extern VTBL_ENTRY _ZTI12S16431C13_nt[];
VTBL_ENTRY *P__ZTI12S16431C13_nt = _ZTI12S16431C13_nt; 
extern  VTBL_ENTRY _ZTV12S16431C13_nt[];
Class_Descriptor cd_S16431C13_nt = {  "S16431C13_nt", // class name
  0,0,//no base classes
  &(vtc_S16431C13_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S16431C13_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S16431C13_nt),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C15  : S8644C7_nt {
};
//SIG(-1 S16431C15) C1{ BC2{ m Fc[16]}}



static void Test_S16431C15()
{
  extern Class_Descriptor cd_S16431C15;
  void *lvp;
  {
    char buf[16];
    init_test(&cd_S16431C15, buf);
    S16431C15 &lv = *(new (buf) S16431C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(S16431C15)");
    check2(__alignof__(lv), 1, "__alignof__(S16431C15)");
    check_base_class_offset(lv, (S8644C7_nt*), 0, "S16431C15");
    test_class_info(&lv, &cd_S16431C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16431C15(Test_S16431C15, "S16431C15", 16);

#else // __cplusplus

extern Class_Descriptor cd_S8644C7_nt;
static Base_Class bases_S16431C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S8644C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S16431C15 = {  "S16431C15", // class name
  bases_S16431C15, 1,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C14  {
  ::S16431C15 s16431c14f0;
  ::S16431C15 s16431c14f1;
};
//SIG(-1 S16431C14) C1{ FC2{ BC3{ m Fc[16]}} FC2}



static void Test_S16431C14()
{
  {
    init_simple_test("S16431C14");
    S16431C14 lv;
    check2(sizeof(lv), 32, "sizeof(S16431C14)");
    check2(__alignof__(lv), 1, "__alignof__(S16431C14)");
    check_field_offset(lv, s16431c14f0, 0, "S16431C14.s16431c14f0");
    check_field_offset(lv, s16431c14f1, 16, "S16431C14.s16431c14f1");
  }
}
static Arrange_To_Call_Me vS16431C14(Test_S16431C14, "S16431C14", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C12  : S16431C13_nt {
  ::S16431C14 s16431c12f0;
  virtual void  v1(); // _ZN9S16431C122v1Ev
  virtual void  v2(); // _ZN9S16431C122v2Ev
  virtual void  v3(); // _ZN9S16431C122v3Ev
  virtual void  v4(); // _ZN9S16431C122v4Ev
  virtual void  v5(); // _ZN9S16431C122v5Ev
  virtual void  v6(); // _ZN9S16431C122v6Ev
  virtual void  v7(); // _ZN9S16431C122v7Ev
  virtual void  v8(); // _ZN9S16431C122v8Ev
  virtual void  v9(); // _ZN9S16431C122v9Ev
  virtual void  v10(); // _ZN9S16431C123v10Ev
  virtual void  v11(); // _ZN9S16431C123v11Ev
  virtual void  v12(); // _ZN9S16431C123v12Ev
  virtual void  v13(); // _ZN9S16431C123v13Ev
  virtual void  v14(); // _ZN9S16431C123v14Ev
  ~S16431C12(); // tgen
  S16431C12(); // tgen
};
//SIG(-1 S16431C12) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC3{ FC4{ BC5{ m Fc[16]}} FC4}}


void  S16431C12 ::v1(){vfunc_called(this, "_ZN9S16431C122v1Ev");}
void  S16431C12 ::v2(){vfunc_called(this, "_ZN9S16431C122v2Ev");}
void  S16431C12 ::v3(){vfunc_called(this, "_ZN9S16431C122v3Ev");}
void  S16431C12 ::v4(){vfunc_called(this, "_ZN9S16431C122v4Ev");}
void  S16431C12 ::v5(){vfunc_called(this, "_ZN9S16431C122v5Ev");}
void  S16431C12 ::v6(){vfunc_called(this, "_ZN9S16431C122v6Ev");}
void  S16431C12 ::v7(){vfunc_called(this, "_ZN9S16431C122v7Ev");}
void  S16431C12 ::v8(){vfunc_called(this, "_ZN9S16431C122v8Ev");}
void  S16431C12 ::v9(){vfunc_called(this, "_ZN9S16431C122v9Ev");}
void  S16431C12 ::v10(){vfunc_called(this, "_ZN9S16431C123v10Ev");}
void  S16431C12 ::v11(){vfunc_called(this, "_ZN9S16431C123v11Ev");}
void  S16431C12 ::v12(){vfunc_called(this, "_ZN9S16431C123v12Ev");}
void  S16431C12 ::v13(){vfunc_called(this, "_ZN9S16431C123v13Ev");}
void  S16431C12 ::v14(){vfunc_called(this, "_ZN9S16431C123v14Ev");}
S16431C12 ::~S16431C12(){ note_dtor("S16431C12", this);} // tgen
S16431C12 ::S16431C12(){ note_ctor("S16431C12", this);} // tgen

static void Test_S16431C12()
{
  extern Class_Descriptor cd_S16431C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,10)];
    init_test(&cd_S16431C12, buf);
    S16431C12 *dp, &lv = *(dp=new (buf) S16431C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,36), "sizeof(S16431C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16431C12)");
    check_base_class_offset(lv, (S16431C13_nt*), 0, "S16431C12");
    check_field_offset(lv, s16431c12f0, ABISELECT(8,4), "S16431C12.s16431c12f0");
    test_class_info(&lv, &cd_S16431C12);
    dp->~S16431C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16431C12(Test_S16431C12, "S16431C12", ABISELECT(40,36));

#else // __cplusplus

extern void _ZN9S16431C12C1Ev();
extern void _ZN9S16431C12D1Ev();
Name_Map name_map_S16431C12[] = {
  NSPAIR(_ZN9S16431C12C1Ev),
  NSPAIR(_ZN9S16431C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S16431C13_nt;
extern VTBL_ENTRY _ZTI12S16431C13_nt[];
extern  VTBL_ENTRY _ZTV12S16431C13_nt[];
static Base_Class bases_S16431C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16431C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S16431C12[];
extern void _ZN9S16431C12D1Ev();
extern void _ZN9S16431C12D0Ev();
extern void _ZN12S16431C13_nt3v15Ev();
extern void _ZN12S16431C13_nt3v16Ev();
extern void _ZN12S16431C13_nt3v17Ev();
extern void _ZN12S16431C13_nt3v18Ev();
extern void _ZN12S16431C13_nt3v19Ev();
extern void _ZN12S16431C13_nt3v20Ev();
extern void _ZN12S16431C13_nt3v21Ev();
extern void _ZN12S16431C13_nt3v22Ev();
extern void _ZN12S16431C13_nt3v23Ev();
extern void _ZN12S16431C13_nt3v24Ev();
extern void _ZN12S16431C13_nt3v25Ev();
extern void _ZN12S16431C13_nt3v26Ev();
extern void _ZN12S16431C13_nt3v27Ev();
extern void _ZN12S16431C13_nt3v28Ev();
extern void _ZN9S16431C122v1Ev();
extern void _ZN9S16431C122v2Ev();
extern void _ZN9S16431C122v3Ev();
extern void _ZN9S16431C122v4Ev();
extern void _ZN9S16431C122v5Ev();
extern void _ZN9S16431C122v6Ev();
extern void _ZN9S16431C122v7Ev();
extern void _ZN9S16431C122v8Ev();
extern void _ZN9S16431C122v9Ev();
extern void _ZN9S16431C123v10Ev();
extern void _ZN9S16431C123v11Ev();
extern void _ZN9S16431C123v12Ev();
extern void _ZN9S16431C123v13Ev();
extern void _ZN9S16431C123v14Ev();
static  VTBL_ENTRY vtc_S16431C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S16431C12[0]),
  (VTBL_ENTRY)&_ZN9S16431C12D1Ev,
  (VTBL_ENTRY)&_ZN9S16431C12D0Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v15Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v16Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v17Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v18Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v19Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v20Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v21Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v22Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v23Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v24Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v25Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v26Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v27Ev,
  (VTBL_ENTRY)&_ZN12S16431C13_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S16431C122v1Ev,
  (VTBL_ENTRY)&_ZN9S16431C122v2Ev,
  (VTBL_ENTRY)&_ZN9S16431C122v3Ev,
  (VTBL_ENTRY)&_ZN9S16431C122v4Ev,
  (VTBL_ENTRY)&_ZN9S16431C122v5Ev,
  (VTBL_ENTRY)&_ZN9S16431C122v6Ev,
  (VTBL_ENTRY)&_ZN9S16431C122v7Ev,
  (VTBL_ENTRY)&_ZN9S16431C122v8Ev,
  (VTBL_ENTRY)&_ZN9S16431C122v9Ev,
  (VTBL_ENTRY)&_ZN9S16431C123v10Ev,
  (VTBL_ENTRY)&_ZN9S16431C123v11Ev,
  (VTBL_ENTRY)&_ZN9S16431C123v12Ev,
  (VTBL_ENTRY)&_ZN9S16431C123v13Ev,
  (VTBL_ENTRY)&_ZN9S16431C123v14Ev,
};
extern VTBL_ENTRY _ZTI9S16431C12[];
extern  VTBL_ENTRY _ZTV9S16431C12[];
Class_Descriptor cd_S16431C12 = {  "S16431C12", // class name
  bases_S16431C12, 1,
  &(vtc_S16431C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,36), // object size
  NSPAIRA(_ZTI9S16431C12),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S16431C12),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C17  {
  void *s16431c17f0;
  void  mf16431c17(); // _ZN9S16431C1710mf16431c17Ev
};
//SIG(-1 S16431C17) C1{ m Fp}


void  S16431C17 ::mf16431c17(){}

static void Test_S16431C17()
{
  {
    init_simple_test("S16431C17");
    S16431C17 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S16431C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16431C17)");
    check_field_offset(lv, s16431c17f0, 0, "S16431C17.s16431c17f0");
  }
}
static Arrange_To_Call_Me vS16431C17(Test_S16431C17, "S16431C17", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C19  {
  void *s16431c19f0;
  void  mf16431c19(); // _ZN9S16431C1910mf16431c19Ev
};
//SIG(-1 S16431C19) C1{ m Fp}


void  S16431C19 ::mf16431c19(){}

static void Test_S16431C19()
{
  {
    init_simple_test("S16431C19");
    S16431C19 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S16431C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16431C19)");
    check_field_offset(lv, s16431c19f0, 0, "S16431C19.s16431c19f0");
  }
}
static Arrange_To_Call_Me vS16431C19(Test_S16431C19, "S16431C19", ABISELECT(8,4));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S16431C19[];
VTBL_ENTRY *P__ZTI9S16431C19 = _ZTI9S16431C19; 
Class_Descriptor cd_S16431C19 = {  "S16431C19", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S16431C19),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C23_nt  {
  virtual  ~S16431C23_nt(); // _ZN12S16431C23_ntD1Ev
  virtual void  v30(); // _ZN12S16431C23_nt3v30Ev
  S16431C23_nt(); // tgen
};
//SIG(-1 S16431C23_nt) C1{ vd v1}


 S16431C23_nt ::~S16431C23_nt(){ note_dtor("S16431C23_nt", this);}
void  S16431C23_nt ::v30(){vfunc_called(this, "_ZN12S16431C23_nt3v30Ev");}
S16431C23_nt ::S16431C23_nt(){ note_ctor("S16431C23_nt", this);} // tgen

//skip512 S16431C23_nt

#else // __cplusplus

extern void _ZN12S16431C23_ntC1Ev();
extern void _ZN12S16431C23_ntD1Ev();
Name_Map name_map_S16431C23_nt[] = {
  NSPAIR(_ZN12S16431C23_ntC1Ev),
  NSPAIR(_ZN12S16431C23_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S16431C23_nt[];
extern void _ZN12S16431C23_ntD1Ev();
extern void _ZN12S16431C23_ntD0Ev();
extern void _ZN12S16431C23_nt3v30Ev();
static  VTBL_ENTRY vtc_S16431C23_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S16431C23_nt[0]),
  (VTBL_ENTRY)&_ZN12S16431C23_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S16431C23_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S16431C23_nt3v30Ev,
};
extern VTBL_ENTRY _ZTI12S16431C23_nt[];
VTBL_ENTRY *P__ZTI12S16431C23_nt = _ZTI12S16431C23_nt; 
extern  VTBL_ENTRY _ZTV12S16431C23_nt[];
Class_Descriptor cd_S16431C23_nt = {  "S16431C23_nt", // class name
  0,0,//no base classes
  &(vtc_S16431C23_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S16431C23_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S16431C23_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C22  : S16431C23_nt {
  void *s16431c22f0[2];
  virtual  ~S16431C22(); // _ZN9S16431C22D1Ev
  virtual void  v29(); // _ZN9S16431C223v29Ev
  S16431C22(); // tgen
};
//SIG(-1 S16431C22) C1{ BC2{ vd v2} vd v1 Fp[2]}


 S16431C22 ::~S16431C22(){ note_dtor("S16431C22", this);}
void  S16431C22 ::v29(){vfunc_called(this, "_ZN9S16431C223v29Ev");}
S16431C22 ::S16431C22(){ note_ctor("S16431C22", this);} // tgen

static void Test_S16431C22()
{
  extern Class_Descriptor cd_S16431C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S16431C22, buf);
    S16431C22 *dp, &lv = *(dp=new (buf) S16431C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S16431C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16431C22)");
    check_base_class_offset(lv, (S16431C23_nt*), 0, "S16431C22");
    check_field_offset(lv, s16431c22f0, ABISELECT(8,4), "S16431C22.s16431c22f0");
    test_class_info(&lv, &cd_S16431C22);
    dp->~S16431C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16431C22(Test_S16431C22, "S16431C22", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN9S16431C22C1Ev();
extern void _ZN9S16431C22D1Ev();
Name_Map name_map_S16431C22[] = {
  NSPAIR(_ZN9S16431C22C1Ev),
  NSPAIR(_ZN9S16431C22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S16431C23_nt;
extern VTBL_ENTRY _ZTI12S16431C23_nt[];
extern  VTBL_ENTRY _ZTV12S16431C23_nt[];
static Base_Class bases_S16431C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16431C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S16431C22[];
extern void _ZN9S16431C22D1Ev();
extern void _ZN9S16431C22D0Ev();
extern void _ZN12S16431C23_nt3v30Ev();
extern void _ZN9S16431C223v29Ev();
static  VTBL_ENTRY vtc_S16431C22[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S16431C22[0]),
  (VTBL_ENTRY)&_ZN9S16431C22D1Ev,
  (VTBL_ENTRY)&_ZN9S16431C22D0Ev,
  (VTBL_ENTRY)&_ZN12S16431C23_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S16431C223v29Ev,
};
extern VTBL_ENTRY _ZTI9S16431C22[];
extern  VTBL_ENTRY _ZTV9S16431C22[];
Class_Descriptor cd_S16431C22 = {  "S16431C22", // class name
  bases_S16431C22, 1,
  &(vtc_S16431C22[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI9S16431C22),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S16431C22),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C26_nt  {
  char s16431c26f0;
  void  mf16431c26(); // _ZN12S16431C26_nt10mf16431c26Ev
};
//SIG(-1 S16431C26_nt) C1{ m Fc}


void  S16431C26_nt ::mf16431c26(){}

//skip512 S16431C26_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S16431C26_nt[];
VTBL_ENTRY *P__ZTI12S16431C26_nt = _ZTI12S16431C26_nt; 
Class_Descriptor cd_S16431C26_nt = {  "S16431C26_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI12S16431C26_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C25  : S16431C26_nt {
  int s16431c25f0[4];
};
//SIG(-1 S16431C25) C1{ BC2{ m Fc} Fi[4]}



static void Test_S16431C25()
{
  extern Class_Descriptor cd_S16431C25;
  void *lvp;
  {
    int buf[6];
    init_test(&cd_S16431C25, buf);
    S16431C25 &lv = *(new (buf) S16431C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), 20, "sizeof(S16431C25)");
    check2(__alignof__(lv), 4, "__alignof__(S16431C25)");
    check_base_class_offset(lv, (S16431C26_nt*), 0, "S16431C25");
    check_field_offset(lv, s16431c25f0, 4, "S16431C25.s16431c25f0");
    test_class_info(&lv, &cd_S16431C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16431C25(Test_S16431C25, "S16431C25", 20);

#else // __cplusplus

extern Class_Descriptor cd_S16431C26_nt;
extern VTBL_ENTRY _ZTI12S16431C26_nt[];
static Base_Class bases_S16431C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16431C26_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S16431C25 = {  "S16431C25", // class name
  bases_S16431C25, 1,
  0, // no vftv
  0, //no vtt
  20, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C27_nt  : S16431C26_nt {
  ::S16431C15 s16431c27f0;
  ::S16431C15 s16431c27f1;
  int s16431c27f2;
};
//SIG(-1 S16431C27_nt) C1{ BC2{ m Fc} FC3{ BC4{ m Fc[16]}} FC3 Fi}



//skip512 S16431C27_nt

#else // __cplusplus

extern Class_Descriptor cd_S16431C26_nt;
extern VTBL_ENTRY _ZTI12S16431C26_nt[];
static Base_Class bases_S16431C27_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16431C26_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C28_nt  : S16431C26_nt {
  int s16431c28f0[7];
};
//SIG(-1 S16431C28_nt) C1{ BC2{ m Fc} Fi[7]}



//skip512 S16431C28_nt

#else // __cplusplus

extern Class_Descriptor cd_S16431C26_nt;
extern VTBL_ENTRY _ZTI12S16431C26_nt[];
static Base_Class bases_S16431C28_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16431C26_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C29  : S16431C26_nt {
};
//SIG(-1 S16431C29) C1{ BC2{ m Fc}}



static void Test_S16431C29()
{
  extern Class_Descriptor cd_S16431C29;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S16431C29, buf);
    S16431C29 &lv = *(new (buf) S16431C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S16431C29)");
    check2(__alignof__(lv), 1, "__alignof__(S16431C29)");
    check_base_class_offset(lv, (S16431C26_nt*), 0, "S16431C29");
    test_class_info(&lv, &cd_S16431C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16431C29(Test_S16431C29, "S16431C29", 1);

#else // __cplusplus

extern Class_Descriptor cd_S16431C26_nt;
extern VTBL_ENTRY _ZTI12S16431C26_nt[];
static Base_Class bases_S16431C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16431C26_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S16431C29 = {  "S16431C29", // class name
  bases_S16431C29, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C30  : S16431C26_nt {
  int s16431c30f0[3];
  ::S16431C15 s16431c30f1;
};
//SIG(-1 S16431C30) C1{ BC2{ m Fc} Fi[3] FC3{ BC4{ m Fc[16]}}}



static void Test_S16431C30()
{
  extern Class_Descriptor cd_S16431C30;
  void *lvp;
  {
    int buf[9];
    init_test(&cd_S16431C30, buf);
    S16431C30 &lv = *(new (buf) S16431C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), 32, "sizeof(S16431C30)");
    check2(__alignof__(lv), 4, "__alignof__(S16431C30)");
    check_base_class_offset(lv, (S16431C26_nt*), 0, "S16431C30");
    check_field_offset(lv, s16431c30f0, 4, "S16431C30.s16431c30f0");
    check_field_offset(lv, s16431c30f1, 16, "S16431C30.s16431c30f1");
    test_class_info(&lv, &cd_S16431C30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16431C30(Test_S16431C30, "S16431C30", 32);

#else // __cplusplus

extern Class_Descriptor cd_S16431C26_nt;
extern VTBL_ENTRY _ZTI12S16431C26_nt[];
static Base_Class bases_S16431C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16431C26_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S16431C30 = {  "S16431C30", // class name
  bases_S16431C30, 1,
  0, // no vftv
  0, //no vtt
  32, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C24  {
  int s16431c24f0[4];
  ::S8644C5_nt s16431c24f1;
  ::S16431C25 s16431c24f2;
  ::S16431C27_nt s16431c24f3;
  ::S16431C28_nt s16431c24f4;
  ::S16431C29 s16431c24f5;
  ::S16431C30 s16431c24f6;
  void  mf16431c24(); // _ZN9S16431C2410mf16431c24Ev
};
//SIG(-1 S16431C24) C1{ m Fi[4] FC2{ BC3{ m FC4{ m Fc[16]} FC4 FC4 FC4}} FC5{ BC6{ m Fc} Fi[4]} FC7{ BC6 FC8{ BC4} FC8 Fi} FC9{ BC6 Fi[7]} FC10{ BC6} FC11{ BC6 Fi[3] FC8}}


void  S16431C24 ::mf16431c24(){}

static void Test_S16431C24()
{
  {
    init_simple_test("S16431C24");
    S16431C24 lv;
    check2(sizeof(lv), 208, "sizeof(S16431C24)");
    check2(__alignof__(lv), 4, "__alignof__(S16431C24)");
    check_field_offset(lv, s16431c24f0, 0, "S16431C24.s16431c24f0");
    check_field_offset(lv, s16431c24f1, 16, "S16431C24.s16431c24f1");
    check_field_offset(lv, s16431c24f2, 80, "S16431C24.s16431c24f2");
    check_field_offset(lv, s16431c24f3, 100, "S16431C24.s16431c24f3");
    check_field_offset(lv, s16431c24f4, 140, "S16431C24.s16431c24f4");
    check_field_offset(lv, s16431c24f5, 172, "S16431C24.s16431c24f5");
    check_field_offset(lv, s16431c24f6, 176, "S16431C24.s16431c24f6");
  }
}
static Arrange_To_Call_Me vS16431C24(Test_S16431C24, "S16431C24", 208);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16431C1  {
  ::S8644C26 s16431c1f0;
  ::S8644C10 s16431c1f1;
  ::S8644C8_nt s16431c1f2;
  ::S16431C5_nt s16431c1f3;
  void *s16431c1f4;
  ::S16431C5_nt s16431c1f5;
  ::S16431C7 s16431c1f6;
  ::S16431C12 s16431c1f7;
  char s16431c1f8;
  void *s16431c1f9;
  ::S16431C17 s16431c1f10;
  ::S16431C17 s16431c1f11;
  ::S16431C19 s16431c1f12;
  ::S8644C10 s16431c1f13;
  void *s16431c1f14;
  int s16431c1f15[4];
  ::S8644C8_nt s16431c1f16;
  ::S16431C17 s16431c1f17;
  ::S8644C26 s16431c1f18;
  ::S8644C10 s16431c1f19;
  ::S8644C10 s16431c1f20;
  ::S16431C19 s16431c1f21;
  void *s16431c1f22;
  ::S1502C8_nt s16431c1f23;
  void *s16431c1f24[2];
  ::S16431C22 s16431c1f25;
  ::S8644C8_nt s16431c1f26;
  char s16431c1f27;
  ::S16431C24 s16431c1f28;
  int s16431c1f29[2];
  void  mf16431c1(); // _ZN8S16431C19mf16431c1Ev
};
//SIG(1 S16431C1) C1{ m FC2{ m Fp} FC3{ m Fp} FC4{ m Fp} FC5{ m Fp} Fp FC5 FC6{ m FC7{ BC8{ m FC9{ m Fc[16]} FC9 FC9 FC9}} FC10{ BC9}} FC11{ BC12{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC13{ FC14{ BC9} FC14}} Fc Fp FC15{ m Fp} FC15 FC16{ m Fp} FC3 Fp Fi[4] FC4 FC15 FC2 FC3 FC3 FC16 Fp FC17{ m Fp Fi[2]} Fp[2] FC18{ BC19{ vd v30} vd v29 Fp[2]} FC4 Fc FC20{ m Fi[4] FC7 FC21{ BC22{ m Fc} Fi[4]} FC23{ BC22 FC14 FC14 Fi} FC24{ BC22 Fi[7]} FC25{ BC22} FC26{ BC22 Fi[3] FC14}} Fi[2]}


void  S16431C1 ::mf16431c1(){}

static void Test_S16431C1()
{
  {
    init_simple_test("S16431C1");
    S16431C1 lv;
    check2(sizeof(lv), ABISELECT(584,468), "sizeof(S16431C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16431C1)");
    check_field_offset(lv, s16431c1f0, 0, "S16431C1.s16431c1f0");
    check_field_offset(lv, s16431c1f1, ABISELECT(8,4), "S16431C1.s16431c1f1");
    check_field_offset(lv, s16431c1f2, ABISELECT(16,8), "S16431C1.s16431c1f2");
    check_field_offset(lv, s16431c1f3, ABISELECT(24,12), "S16431C1.s16431c1f3");
    check_field_offset(lv, s16431c1f4, ABISELECT(32,16), "S16431C1.s16431c1f4");
    check_field_offset(lv, s16431c1f5, ABISELECT(40,20), "S16431C1.s16431c1f5");
    check_field_offset(lv, s16431c1f6, ABISELECT(48,24), "S16431C1.s16431c1f6");
    check_field_offset(lv, s16431c1f7, ABISELECT(128,104), "S16431C1.s16431c1f7");
    check_field_offset(lv, s16431c1f8, ABISELECT(168,140), "S16431C1.s16431c1f8");
    check_field_offset(lv, s16431c1f9, ABISELECT(176,144), "S16431C1.s16431c1f9");
    check_field_offset(lv, s16431c1f10, ABISELECT(184,148), "S16431C1.s16431c1f10");
    check_field_offset(lv, s16431c1f11, ABISELECT(192,152), "S16431C1.s16431c1f11");
    check_field_offset(lv, s16431c1f12, ABISELECT(200,156), "S16431C1.s16431c1f12");
    check_field_offset(lv, s16431c1f13, ABISELECT(208,160), "S16431C1.s16431c1f13");
    check_field_offset(lv, s16431c1f14, ABISELECT(216,164), "S16431C1.s16431c1f14");
    check_field_offset(lv, s16431c1f15, ABISELECT(224,168), "S16431C1.s16431c1f15");
    check_field_offset(lv, s16431c1f16, ABISELECT(240,184), "S16431C1.s16431c1f16");
    check_field_offset(lv, s16431c1f17, ABISELECT(248,188), "S16431C1.s16431c1f17");
    check_field_offset(lv, s16431c1f18, ABISELECT(256,192), "S16431C1.s16431c1f18");
    check_field_offset(lv, s16431c1f19, ABISELECT(264,196), "S16431C1.s16431c1f19");
    check_field_offset(lv, s16431c1f20, ABISELECT(272,200), "S16431C1.s16431c1f20");
    check_field_offset(lv, s16431c1f21, ABISELECT(280,204), "S16431C1.s16431c1f21");
    check_field_offset(lv, s16431c1f22, ABISELECT(288,208), "S16431C1.s16431c1f22");
    check_field_offset(lv, s16431c1f23, ABISELECT(296,212), "S16431C1.s16431c1f23");
    check_field_offset(lv, s16431c1f24, ABISELECT(312,224), "S16431C1.s16431c1f24");
    check_field_offset(lv, s16431c1f25, ABISELECT(328,232), "S16431C1.s16431c1f25");
    check_field_offset(lv, s16431c1f26, ABISELECT(352,244), "S16431C1.s16431c1f26");
    check_field_offset(lv, s16431c1f27, ABISELECT(360,248), "S16431C1.s16431c1f27");
    check_field_offset(lv, s16431c1f28, ABISELECT(364,252), "S16431C1.s16431c1f28");
    check_field_offset(lv, s16431c1f29, ABISELECT(572,460), "S16431C1.s16431c1f29");
  }
}
static Arrange_To_Call_Me vS16431C1(Test_S16431C1, "S16431C1", ABISELECT(584,468));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1549C4  {
  int s1549c4f0;
  __tsi64 s1549c4f1;
  void *s1549c4f2[4];
  int s1549c4f3[2];
  void *s1549c4f4;
  ::S1502C5_nt s1549c4f5;
  void *s1549c4f6[2];
  virtual  ~S1549C4(); // _ZN7S1549C4D1Ev
  virtual void  v7(); // _ZN7S1549C42v7Ev
  virtual void  v8(); // _ZN7S1549C42v8Ev
  virtual void  v9(); // _ZN7S1549C42v9Ev
  virtual void  v10(); // _ZN7S1549C43v10Ev
  virtual void  v11(); // _ZN7S1549C43v11Ev
  virtual void  v12(); // _ZN7S1549C43v12Ev
  virtual void  v13(); // _ZN7S1549C43v13Ev
  virtual void  v14(); // _ZN7S1549C43v14Ev
  virtual void  v15(); // _ZN7S1549C43v15Ev
  virtual void  v16(); // _ZN7S1549C43v16Ev
  virtual void  v17(); // _ZN7S1549C43v17Ev
  virtual void  v18(); // _ZN7S1549C43v18Ev
  virtual void  v19(); // _ZN7S1549C43v19Ev
  virtual void  v20(); // _ZN7S1549C43v20Ev
  virtual void  v21(); // _ZN7S1549C43v21Ev
  virtual void  v22(); // _ZN7S1549C43v22Ev
  virtual void  v23(); // _ZN7S1549C43v23Ev
  virtual void  v24(); // _ZN7S1549C43v24Ev
  virtual void  v25(); // _ZN7S1549C43v25Ev
  virtual void  v26(); // _ZN7S1549C43v26Ev
  virtual void  v27(); // _ZN7S1549C43v27Ev
  virtual void  v28(); // _ZN7S1549C43v28Ev
  virtual void  v29(); // _ZN7S1549C43v29Ev
  virtual void  v30(); // _ZN7S1549C43v30Ev
  virtual void  v31(); // _ZN7S1549C43v31Ev
  virtual void  v32(); // _ZN7S1549C43v32Ev
  virtual void  v33(); // _ZN7S1549C43v33Ev
  virtual void  v34(); // _ZN7S1549C43v34Ev
  virtual void  v35(); // _ZN7S1549C43v35Ev
  virtual void  v36(); // _ZN7S1549C43v36Ev
  virtual void  v37(); // _ZN7S1549C43v37Ev
  virtual void  v38(); // _ZN7S1549C43v38Ev
  virtual void  v39(); // _ZN7S1549C43v39Ev
  virtual void  v40(); // _ZN7S1549C43v40Ev
  virtual void  v41(); // _ZN7S1549C43v41Ev
  virtual void  v42(); // _ZN7S1549C43v42Ev
  virtual void  v43(); // _ZN7S1549C43v43Ev
  virtual void  v44(); // _ZN7S1549C43v44Ev
  virtual void  v45(); // _ZN7S1549C43v45Ev
  virtual void  v46(); // _ZN7S1549C43v46Ev
  virtual void  v47(); // _ZN7S1549C43v47Ev
  virtual void  v48(); // _ZN7S1549C43v48Ev
  virtual void  v49(); // _ZN7S1549C43v49Ev
  virtual void  v50(); // _ZN7S1549C43v50Ev
  virtual void  v51(); // _ZN7S1549C43v51Ev
  virtual void  v52(); // _ZN7S1549C43v52Ev
  virtual void  v53(); // _ZN7S1549C43v53Ev
  virtual void  v54(); // _ZN7S1549C43v54Ev
  virtual void  v55(); // _ZN7S1549C43v55Ev
  virtual void  v56(); // _ZN7S1549C43v56Ev
  virtual void  v57(); // _ZN7S1549C43v57Ev
  virtual void  v58(); // _ZN7S1549C43v58Ev
  virtual void  v59(); // _ZN7S1549C43v59Ev
  virtual void  v60(); // _ZN7S1549C43v60Ev
  virtual void  v61(); // _ZN7S1549C43v61Ev
  virtual void  v62(); // _ZN7S1549C43v62Ev
  virtual void  v63(); // _ZN7S1549C43v63Ev
  virtual void  v64(); // _ZN7S1549C43v64Ev
  virtual void  v65(); // _ZN7S1549C43v65Ev
  virtual void  v66(); // _ZN7S1549C43v66Ev
  virtual void  v67(); // _ZN7S1549C43v67Ev
  virtual void  v68(); // _ZN7S1549C43v68Ev
  virtual void  v69(); // _ZN7S1549C43v69Ev
  virtual void  v70(); // _ZN7S1549C43v70Ev
  S1549C4(); // tgen
};
//SIG(-1 S1549C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1549C4 ::~S1549C4(){ note_dtor("S1549C4", this);}
void  S1549C4 ::v7(){vfunc_called(this, "_ZN7S1549C42v7Ev");}
void  S1549C4 ::v8(){vfunc_called(this, "_ZN7S1549C42v8Ev");}
void  S1549C4 ::v9(){vfunc_called(this, "_ZN7S1549C42v9Ev");}
void  S1549C4 ::v10(){vfunc_called(this, "_ZN7S1549C43v10Ev");}
void  S1549C4 ::v11(){vfunc_called(this, "_ZN7S1549C43v11Ev");}
void  S1549C4 ::v12(){vfunc_called(this, "_ZN7S1549C43v12Ev");}
void  S1549C4 ::v13(){vfunc_called(this, "_ZN7S1549C43v13Ev");}
void  S1549C4 ::v14(){vfunc_called(this, "_ZN7S1549C43v14Ev");}
void  S1549C4 ::v15(){vfunc_called(this, "_ZN7S1549C43v15Ev");}
void  S1549C4 ::v16(){vfunc_called(this, "_ZN7S1549C43v16Ev");}
void  S1549C4 ::v17(){vfunc_called(this, "_ZN7S1549C43v17Ev");}
void  S1549C4 ::v18(){vfunc_called(this, "_ZN7S1549C43v18Ev");}
void  S1549C4 ::v19(){vfunc_called(this, "_ZN7S1549C43v19Ev");}
void  S1549C4 ::v20(){vfunc_called(this, "_ZN7S1549C43v20Ev");}
void  S1549C4 ::v21(){vfunc_called(this, "_ZN7S1549C43v21Ev");}
void  S1549C4 ::v22(){vfunc_called(this, "_ZN7S1549C43v22Ev");}
void  S1549C4 ::v23(){vfunc_called(this, "_ZN7S1549C43v23Ev");}
void  S1549C4 ::v24(){vfunc_called(this, "_ZN7S1549C43v24Ev");}
void  S1549C4 ::v25(){vfunc_called(this, "_ZN7S1549C43v25Ev");}
void  S1549C4 ::v26(){vfunc_called(this, "_ZN7S1549C43v26Ev");}
void  S1549C4 ::v27(){vfunc_called(this, "_ZN7S1549C43v27Ev");}
void  S1549C4 ::v28(){vfunc_called(this, "_ZN7S1549C43v28Ev");}
void  S1549C4 ::v29(){vfunc_called(this, "_ZN7S1549C43v29Ev");}
void  S1549C4 ::v30(){vfunc_called(this, "_ZN7S1549C43v30Ev");}
void  S1549C4 ::v31(){vfunc_called(this, "_ZN7S1549C43v31Ev");}
void  S1549C4 ::v32(){vfunc_called(this, "_ZN7S1549C43v32Ev");}
void  S1549C4 ::v33(){vfunc_called(this, "_ZN7S1549C43v33Ev");}
void  S1549C4 ::v34(){vfunc_called(this, "_ZN7S1549C43v34Ev");}
void  S1549C4 ::v35(){vfunc_called(this, "_ZN7S1549C43v35Ev");}
void  S1549C4 ::v36(){vfunc_called(this, "_ZN7S1549C43v36Ev");}
void  S1549C4 ::v37(){vfunc_called(this, "_ZN7S1549C43v37Ev");}
void  S1549C4 ::v38(){vfunc_called(this, "_ZN7S1549C43v38Ev");}
void  S1549C4 ::v39(){vfunc_called(this, "_ZN7S1549C43v39Ev");}
void  S1549C4 ::v40(){vfunc_called(this, "_ZN7S1549C43v40Ev");}
void  S1549C4 ::v41(){vfunc_called(this, "_ZN7S1549C43v41Ev");}
void  S1549C4 ::v42(){vfunc_called(this, "_ZN7S1549C43v42Ev");}
void  S1549C4 ::v43(){vfunc_called(this, "_ZN7S1549C43v43Ev");}
void  S1549C4 ::v44(){vfunc_called(this, "_ZN7S1549C43v44Ev");}
void  S1549C4 ::v45(){vfunc_called(this, "_ZN7S1549C43v45Ev");}
void  S1549C4 ::v46(){vfunc_called(this, "_ZN7S1549C43v46Ev");}
void  S1549C4 ::v47(){vfunc_called(this, "_ZN7S1549C43v47Ev");}
void  S1549C4 ::v48(){vfunc_called(this, "_ZN7S1549C43v48Ev");}
void  S1549C4 ::v49(){vfunc_called(this, "_ZN7S1549C43v49Ev");}
void  S1549C4 ::v50(){vfunc_called(this, "_ZN7S1549C43v50Ev");}
void  S1549C4 ::v51(){vfunc_called(this, "_ZN7S1549C43v51Ev");}
void  S1549C4 ::v52(){vfunc_called(this, "_ZN7S1549C43v52Ev");}
void  S1549C4 ::v53(){vfunc_called(this, "_ZN7S1549C43v53Ev");}
void  S1549C4 ::v54(){vfunc_called(this, "_ZN7S1549C43v54Ev");}
void  S1549C4 ::v55(){vfunc_called(this, "_ZN7S1549C43v55Ev");}
void  S1549C4 ::v56(){vfunc_called(this, "_ZN7S1549C43v56Ev");}
void  S1549C4 ::v57(){vfunc_called(this, "_ZN7S1549C43v57Ev");}
void  S1549C4 ::v58(){vfunc_called(this, "_ZN7S1549C43v58Ev");}
void  S1549C4 ::v59(){vfunc_called(this, "_ZN7S1549C43v59Ev");}
void  S1549C4 ::v60(){vfunc_called(this, "_ZN7S1549C43v60Ev");}
void  S1549C4 ::v61(){vfunc_called(this, "_ZN7S1549C43v61Ev");}
void  S1549C4 ::v62(){vfunc_called(this, "_ZN7S1549C43v62Ev");}
void  S1549C4 ::v63(){vfunc_called(this, "_ZN7S1549C43v63Ev");}
void  S1549C4 ::v64(){vfunc_called(this, "_ZN7S1549C43v64Ev");}
void  S1549C4 ::v65(){vfunc_called(this, "_ZN7S1549C43v65Ev");}
void  S1549C4 ::v66(){vfunc_called(this, "_ZN7S1549C43v66Ev");}
void  S1549C4 ::v67(){vfunc_called(this, "_ZN7S1549C43v67Ev");}
void  S1549C4 ::v68(){vfunc_called(this, "_ZN7S1549C43v68Ev");}
void  S1549C4 ::v69(){vfunc_called(this, "_ZN7S1549C43v69Ev");}
void  S1549C4 ::v70(){vfunc_called(this, "_ZN7S1549C43v70Ev");}
S1549C4 ::S1549C4(){ note_ctor("S1549C4", this);} // tgen

static void Test_S1549C4()
{
  extern Class_Descriptor cd_S1549C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1549C4, buf);
    S1549C4 *dp, &lv = *(dp=new (buf) S1549C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1549C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1549C4)");
    check_field_offset(lv, s1549c4f0, ABISELECT(8,4), "S1549C4.s1549c4f0");
    check_field_offset(lv, s1549c4f1, ABISELECT(16,8), "S1549C4.s1549c4f1");
    check_field_offset(lv, s1549c4f2, ABISELECT(24,16), "S1549C4.s1549c4f2");
    check_field_offset(lv, s1549c4f3, ABISELECT(56,32), "S1549C4.s1549c4f3");
    check_field_offset(lv, s1549c4f4, ABISELECT(64,40), "S1549C4.s1549c4f4");
    check_field_offset(lv, s1549c4f5, ABISELECT(72,44), "S1549C4.s1549c4f5");
    check_field_offset(lv, s1549c4f6, ABISELECT(80,52), "S1549C4.s1549c4f6");
    test_class_info(&lv, &cd_S1549C4);
    dp->~S1549C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1549C4(Test_S1549C4, "S1549C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1549C4C1Ev();
extern void _ZN7S1549C4D1Ev();
Name_Map name_map_S1549C4[] = {
  NSPAIR(_ZN7S1549C4C1Ev),
  NSPAIR(_ZN7S1549C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1549C4[];
extern void _ZN7S1549C4D1Ev();
extern void _ZN7S1549C4D0Ev();
extern void _ZN7S1549C42v7Ev();
extern void _ZN7S1549C42v8Ev();
extern void _ZN7S1549C42v9Ev();
extern void _ZN7S1549C43v10Ev();
extern void _ZN7S1549C43v11Ev();
extern void _ZN7S1549C43v12Ev();
extern void _ZN7S1549C43v13Ev();
extern void _ZN7S1549C43v14Ev();
extern void _ZN7S1549C43v15Ev();
extern void _ZN7S1549C43v16Ev();
extern void _ZN7S1549C43v17Ev();
extern void _ZN7S1549C43v18Ev();
extern void _ZN7S1549C43v19Ev();
extern void _ZN7S1549C43v20Ev();
extern void _ZN7S1549C43v21Ev();
extern void _ZN7S1549C43v22Ev();
extern void _ZN7S1549C43v23Ev();
extern void _ZN7S1549C43v24Ev();
extern void _ZN7S1549C43v25Ev();
extern void _ZN7S1549C43v26Ev();
extern void _ZN7S1549C43v27Ev();
extern void _ZN7S1549C43v28Ev();
extern void _ZN7S1549C43v29Ev();
extern void _ZN7S1549C43v30Ev();
extern void _ZN7S1549C43v31Ev();
extern void _ZN7S1549C43v32Ev();
extern void _ZN7S1549C43v33Ev();
extern void _ZN7S1549C43v34Ev();
extern void _ZN7S1549C43v35Ev();
extern void _ZN7S1549C43v36Ev();
extern void _ZN7S1549C43v37Ev();
extern void _ZN7S1549C43v38Ev();
extern void _ZN7S1549C43v39Ev();
extern void _ZN7S1549C43v40Ev();
extern void _ZN7S1549C43v41Ev();
extern void _ZN7S1549C43v42Ev();
extern void _ZN7S1549C43v43Ev();
extern void _ZN7S1549C43v44Ev();
extern void _ZN7S1549C43v45Ev();
extern void _ZN7S1549C43v46Ev();
extern void _ZN7S1549C43v47Ev();
extern void _ZN7S1549C43v48Ev();
extern void _ZN7S1549C43v49Ev();
extern void _ZN7S1549C43v50Ev();
extern void _ZN7S1549C43v51Ev();
extern void _ZN7S1549C43v52Ev();
extern void _ZN7S1549C43v53Ev();
extern void _ZN7S1549C43v54Ev();
extern void _ZN7S1549C43v55Ev();
extern void _ZN7S1549C43v56Ev();
extern void _ZN7S1549C43v57Ev();
extern void _ZN7S1549C43v58Ev();
extern void _ZN7S1549C43v59Ev();
extern void _ZN7S1549C43v60Ev();
extern void _ZN7S1549C43v61Ev();
extern void _ZN7S1549C43v62Ev();
extern void _ZN7S1549C43v63Ev();
extern void _ZN7S1549C43v64Ev();
extern void _ZN7S1549C43v65Ev();
extern void _ZN7S1549C43v66Ev();
extern void _ZN7S1549C43v67Ev();
extern void _ZN7S1549C43v68Ev();
extern void _ZN7S1549C43v69Ev();
extern void _ZN7S1549C43v70Ev();
static  VTBL_ENTRY vtc_S1549C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1549C4[0]),
  (VTBL_ENTRY)&_ZN7S1549C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1549C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v70Ev,
};
extern VTBL_ENTRY _ZTI7S1549C4[];
extern  VTBL_ENTRY _ZTV7S1549C4[];
Class_Descriptor cd_S1549C4 = {  "S1549C4", // class name
  0,0,//no base classes
  &(vtc_S1549C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1549C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1549C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1549C3  : S1549C4 {
  unsigned int s1549c3f0:1;
  unsigned int s1549c3f1:1;
  unsigned int s1549c3f2:1;
  unsigned int s1549c3f3:1;
  unsigned int s1549c3f4:1;
  unsigned int s1549c3f5:1;
  unsigned int s1549c3f6:1;
  ::S578C11_nt s1549c3f7;
  virtual  ~S1549C3(); // _ZN7S1549C3D1Ev
  virtual void  v71(); // _ZN7S1549C33v71Ev
  virtual void  v72(); // _ZN7S1549C33v72Ev
  virtual void  v73(); // _ZN7S1549C33v73Ev
  virtual void  v74(); // _ZN7S1549C33v74Ev
  virtual void  v75(); // _ZN7S1549C33v75Ev
  virtual void  v76(); // _ZN7S1549C33v76Ev
  virtual void  v77(); // _ZN7S1549C33v77Ev
  virtual void  v78(); // _ZN7S1549C33v78Ev
  virtual void  v79(); // _ZN7S1549C33v79Ev
  virtual void  v80(); // _ZN7S1549C33v80Ev
  virtual void  v81(); // _ZN7S1549C33v81Ev
  virtual void  v82(); // _ZN7S1549C33v82Ev
  virtual void  v83(); // _ZN7S1549C33v83Ev
  virtual void  v84(); // _ZN7S1549C33v84Ev
  virtual void  v85(); // _ZN7S1549C33v85Ev
  virtual void  v86(); // _ZN7S1549C33v86Ev
  virtual void  v87(); // _ZN7S1549C33v87Ev
  virtual void  v88(); // _ZN7S1549C33v88Ev
  virtual void  v89(); // _ZN7S1549C33v89Ev
  virtual void  v90(); // _ZN7S1549C33v90Ev
  S1549C3(); // tgen
};
//SIG(-1 S1549C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1549C3 ::~S1549C3(){ note_dtor("S1549C3", this);}
void  S1549C3 ::v71(){vfunc_called(this, "_ZN7S1549C33v71Ev");}
void  S1549C3 ::v72(){vfunc_called(this, "_ZN7S1549C33v72Ev");}
void  S1549C3 ::v73(){vfunc_called(this, "_ZN7S1549C33v73Ev");}
void  S1549C3 ::v74(){vfunc_called(this, "_ZN7S1549C33v74Ev");}
void  S1549C3 ::v75(){vfunc_called(this, "_ZN7S1549C33v75Ev");}
void  S1549C3 ::v76(){vfunc_called(this, "_ZN7S1549C33v76Ev");}
void  S1549C3 ::v77(){vfunc_called(this, "_ZN7S1549C33v77Ev");}
void  S1549C3 ::v78(){vfunc_called(this, "_ZN7S1549C33v78Ev");}
void  S1549C3 ::v79(){vfunc_called(this, "_ZN7S1549C33v79Ev");}
void  S1549C3 ::v80(){vfunc_called(this, "_ZN7S1549C33v80Ev");}
void  S1549C3 ::v81(){vfunc_called(this, "_ZN7S1549C33v81Ev");}
void  S1549C3 ::v82(){vfunc_called(this, "_ZN7S1549C33v82Ev");}
void  S1549C3 ::v83(){vfunc_called(this, "_ZN7S1549C33v83Ev");}
void  S1549C3 ::v84(){vfunc_called(this, "_ZN7S1549C33v84Ev");}
void  S1549C3 ::v85(){vfunc_called(this, "_ZN7S1549C33v85Ev");}
void  S1549C3 ::v86(){vfunc_called(this, "_ZN7S1549C33v86Ev");}
void  S1549C3 ::v87(){vfunc_called(this, "_ZN7S1549C33v87Ev");}
void  S1549C3 ::v88(){vfunc_called(this, "_ZN7S1549C33v88Ev");}
void  S1549C3 ::v89(){vfunc_called(this, "_ZN7S1549C33v89Ev");}
void  S1549C3 ::v90(){vfunc_called(this, "_ZN7S1549C33v90Ev");}
S1549C3 ::S1549C3(){ note_ctor("S1549C3", this);} // tgen

static void Test_S1549C3()
{
  extern Class_Descriptor cd_S1549C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1549C3, buf);
    S1549C3 *dp, &lv = *(dp=new (buf) S1549C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1549C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1549C3)");
    check_base_class_offset(lv, (S1549C4*), 0, "S1549C3");
    set_bf_and_test(lv, s1549c3f0, ABISELECT(96,60), 0, 1, 1, "S1549C3");
    set_bf_and_test(lv, s1549c3f1, ABISELECT(96,60), 1, 1, 1, "S1549C3");
    set_bf_and_test(lv, s1549c3f2, ABISELECT(96,60), 2, 1, 1, "S1549C3");
    set_bf_and_test(lv, s1549c3f3, ABISELECT(96,60), 3, 1, 1, "S1549C3");
    set_bf_and_test(lv, s1549c3f4, ABISELECT(96,60), 4, 1, 1, "S1549C3");
    set_bf_and_test(lv, s1549c3f5, ABISELECT(96,60), 5, 1, 1, "S1549C3");
    set_bf_and_test(lv, s1549c3f6, ABISELECT(96,60), 6, 1, 1, "S1549C3");
    check_field_offset(lv, s1549c3f7, ABISELECT(97,61), "S1549C3.s1549c3f7");
    test_class_info(&lv, &cd_S1549C3);
    dp->~S1549C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1549C3(Test_S1549C3, "S1549C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1549C3C1Ev();
extern void _ZN7S1549C3D1Ev();
Name_Map name_map_S1549C3[] = {
  NSPAIR(_ZN7S1549C3C1Ev),
  NSPAIR(_ZN7S1549C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1549C4;
extern VTBL_ENTRY _ZTI7S1549C4[];
extern  VTBL_ENTRY _ZTV7S1549C4[];
static Base_Class bases_S1549C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1549C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1549C3[];
extern void _ZN7S1549C3D1Ev();
extern void _ZN7S1549C3D0Ev();
extern void _ZN7S1549C42v7Ev();
extern void _ZN7S1549C42v8Ev();
extern void _ZN7S1549C42v9Ev();
extern void _ZN7S1549C43v10Ev();
extern void _ZN7S1549C43v11Ev();
extern void _ZN7S1549C43v12Ev();
extern void _ZN7S1549C43v13Ev();
extern void _ZN7S1549C43v14Ev();
extern void _ZN7S1549C43v15Ev();
extern void _ZN7S1549C43v16Ev();
extern void _ZN7S1549C43v17Ev();
extern void _ZN7S1549C43v18Ev();
extern void _ZN7S1549C43v19Ev();
extern void _ZN7S1549C43v20Ev();
extern void _ZN7S1549C43v21Ev();
extern void _ZN7S1549C43v22Ev();
extern void _ZN7S1549C43v23Ev();
extern void _ZN7S1549C43v24Ev();
extern void _ZN7S1549C43v25Ev();
extern void _ZN7S1549C43v26Ev();
extern void _ZN7S1549C43v27Ev();
extern void _ZN7S1549C43v28Ev();
extern void _ZN7S1549C43v29Ev();
extern void _ZN7S1549C43v30Ev();
extern void _ZN7S1549C43v31Ev();
extern void _ZN7S1549C43v32Ev();
extern void _ZN7S1549C43v33Ev();
extern void _ZN7S1549C43v34Ev();
extern void _ZN7S1549C43v35Ev();
extern void _ZN7S1549C43v36Ev();
extern void _ZN7S1549C43v37Ev();
extern void _ZN7S1549C43v38Ev();
extern void _ZN7S1549C43v39Ev();
extern void _ZN7S1549C43v40Ev();
extern void _ZN7S1549C43v41Ev();
extern void _ZN7S1549C43v42Ev();
extern void _ZN7S1549C43v43Ev();
extern void _ZN7S1549C43v44Ev();
extern void _ZN7S1549C43v45Ev();
extern void _ZN7S1549C43v46Ev();
extern void _ZN7S1549C43v47Ev();
extern void _ZN7S1549C43v48Ev();
extern void _ZN7S1549C43v49Ev();
extern void _ZN7S1549C43v50Ev();
extern void _ZN7S1549C43v51Ev();
extern void _ZN7S1549C43v52Ev();
extern void _ZN7S1549C43v53Ev();
extern void _ZN7S1549C43v54Ev();
extern void _ZN7S1549C43v55Ev();
extern void _ZN7S1549C43v56Ev();
extern void _ZN7S1549C43v57Ev();
extern void _ZN7S1549C43v58Ev();
extern void _ZN7S1549C43v59Ev();
extern void _ZN7S1549C43v60Ev();
extern void _ZN7S1549C43v61Ev();
extern void _ZN7S1549C43v62Ev();
extern void _ZN7S1549C43v63Ev();
extern void _ZN7S1549C43v64Ev();
extern void _ZN7S1549C43v65Ev();
extern void _ZN7S1549C43v66Ev();
extern void _ZN7S1549C43v67Ev();
extern void _ZN7S1549C43v68Ev();
extern void _ZN7S1549C43v69Ev();
extern void _ZN7S1549C43v70Ev();
extern void _ZN7S1549C33v71Ev();
extern void _ZN7S1549C33v72Ev();
extern void _ZN7S1549C33v73Ev();
extern void _ZN7S1549C33v74Ev();
extern void _ZN7S1549C33v75Ev();
extern void _ZN7S1549C33v76Ev();
extern void _ZN7S1549C33v77Ev();
extern void _ZN7S1549C33v78Ev();
extern void _ZN7S1549C33v79Ev();
extern void _ZN7S1549C33v80Ev();
extern void _ZN7S1549C33v81Ev();
extern void _ZN7S1549C33v82Ev();
extern void _ZN7S1549C33v83Ev();
extern void _ZN7S1549C33v84Ev();
extern void _ZN7S1549C33v85Ev();
extern void _ZN7S1549C33v86Ev();
extern void _ZN7S1549C33v87Ev();
extern void _ZN7S1549C33v88Ev();
extern void _ZN7S1549C33v89Ev();
extern void _ZN7S1549C33v90Ev();
static  VTBL_ENTRY vtc_S1549C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1549C3[0]),
  (VTBL_ENTRY)&_ZN7S1549C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1549C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v90Ev,
};
extern VTBL_ENTRY _ZTI7S1549C3[];
extern  VTBL_ENTRY _ZTV7S1549C3[];
Class_Descriptor cd_S1549C3 = {  "S1549C3", // class name
  bases_S1549C3, 1,
  &(vtc_S1549C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1549C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1549C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1549C2  : S1549C3 {
  virtual  ~S1549C2(); // _ZN7S1549C2D1Ev
  virtual void  v91(); // _ZN7S1549C23v91Ev
  virtual void  v92(); // _ZN7S1549C23v92Ev
  virtual void  v93(); // _ZN7S1549C23v93Ev
  S1549C2(); // tgen
};
//SIG(-1 S1549C2) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3}


 S1549C2 ::~S1549C2(){ note_dtor("S1549C2", this);}
void  S1549C2 ::v91(){vfunc_called(this, "_ZN7S1549C23v91Ev");}
void  S1549C2 ::v92(){vfunc_called(this, "_ZN7S1549C23v92Ev");}
void  S1549C2 ::v93(){vfunc_called(this, "_ZN7S1549C23v93Ev");}
S1549C2 ::S1549C2(){ note_ctor("S1549C2", this);} // tgen

static void Test_S1549C2()
{
  extern Class_Descriptor cd_S1549C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1549C2, buf);
    S1549C2 *dp, &lv = *(dp=new (buf) S1549C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1549C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1549C2)");
    check_base_class_offset(lv, (S1549C4*)(S1549C3*), 0, "S1549C2");
    check_base_class_offset(lv, (S1549C3*), 0, "S1549C2");
    test_class_info(&lv, &cd_S1549C2);
    dp->~S1549C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1549C2(Test_S1549C2, "S1549C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1549C2C1Ev();
extern void _ZN7S1549C2D1Ev();
Name_Map name_map_S1549C2[] = {
  NSPAIR(_ZN7S1549C2C1Ev),
  NSPAIR(_ZN7S1549C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1549C4;
extern VTBL_ENTRY _ZTI7S1549C4[];
extern  VTBL_ENTRY _ZTV7S1549C4[];
extern Class_Descriptor cd_S1549C3;
extern VTBL_ENTRY _ZTI7S1549C3[];
extern  VTBL_ENTRY _ZTV7S1549C3[];
static Base_Class bases_S1549C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1549C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1549C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1549C2[];
extern void _ZN7S1549C2D1Ev();
extern void _ZN7S1549C2D0Ev();
extern void _ZN7S1549C42v7Ev();
extern void _ZN7S1549C42v8Ev();
extern void _ZN7S1549C42v9Ev();
extern void _ZN7S1549C43v10Ev();
extern void _ZN7S1549C43v11Ev();
extern void _ZN7S1549C43v12Ev();
extern void _ZN7S1549C43v13Ev();
extern void _ZN7S1549C43v14Ev();
extern void _ZN7S1549C43v15Ev();
extern void _ZN7S1549C43v16Ev();
extern void _ZN7S1549C43v17Ev();
extern void _ZN7S1549C43v18Ev();
extern void _ZN7S1549C43v19Ev();
extern void _ZN7S1549C43v20Ev();
extern void _ZN7S1549C43v21Ev();
extern void _ZN7S1549C43v22Ev();
extern void _ZN7S1549C43v23Ev();
extern void _ZN7S1549C43v24Ev();
extern void _ZN7S1549C43v25Ev();
extern void _ZN7S1549C43v26Ev();
extern void _ZN7S1549C43v27Ev();
extern void _ZN7S1549C43v28Ev();
extern void _ZN7S1549C43v29Ev();
extern void _ZN7S1549C43v30Ev();
extern void _ZN7S1549C43v31Ev();
extern void _ZN7S1549C43v32Ev();
extern void _ZN7S1549C43v33Ev();
extern void _ZN7S1549C43v34Ev();
extern void _ZN7S1549C43v35Ev();
extern void _ZN7S1549C43v36Ev();
extern void _ZN7S1549C43v37Ev();
extern void _ZN7S1549C43v38Ev();
extern void _ZN7S1549C43v39Ev();
extern void _ZN7S1549C43v40Ev();
extern void _ZN7S1549C43v41Ev();
extern void _ZN7S1549C43v42Ev();
extern void _ZN7S1549C43v43Ev();
extern void _ZN7S1549C43v44Ev();
extern void _ZN7S1549C43v45Ev();
extern void _ZN7S1549C43v46Ev();
extern void _ZN7S1549C43v47Ev();
extern void _ZN7S1549C43v48Ev();
extern void _ZN7S1549C43v49Ev();
extern void _ZN7S1549C43v50Ev();
extern void _ZN7S1549C43v51Ev();
extern void _ZN7S1549C43v52Ev();
extern void _ZN7S1549C43v53Ev();
extern void _ZN7S1549C43v54Ev();
extern void _ZN7S1549C43v55Ev();
extern void _ZN7S1549C43v56Ev();
extern void _ZN7S1549C43v57Ev();
extern void _ZN7S1549C43v58Ev();
extern void _ZN7S1549C43v59Ev();
extern void _ZN7S1549C43v60Ev();
extern void _ZN7S1549C43v61Ev();
extern void _ZN7S1549C43v62Ev();
extern void _ZN7S1549C43v63Ev();
extern void _ZN7S1549C43v64Ev();
extern void _ZN7S1549C43v65Ev();
extern void _ZN7S1549C43v66Ev();
extern void _ZN7S1549C43v67Ev();
extern void _ZN7S1549C43v68Ev();
extern void _ZN7S1549C43v69Ev();
extern void _ZN7S1549C43v70Ev();
extern void _ZN7S1549C33v71Ev();
extern void _ZN7S1549C33v72Ev();
extern void _ZN7S1549C33v73Ev();
extern void _ZN7S1549C33v74Ev();
extern void _ZN7S1549C33v75Ev();
extern void _ZN7S1549C33v76Ev();
extern void _ZN7S1549C33v77Ev();
extern void _ZN7S1549C33v78Ev();
extern void _ZN7S1549C33v79Ev();
extern void _ZN7S1549C33v80Ev();
extern void _ZN7S1549C33v81Ev();
extern void _ZN7S1549C33v82Ev();
extern void _ZN7S1549C33v83Ev();
extern void _ZN7S1549C33v84Ev();
extern void _ZN7S1549C33v85Ev();
extern void _ZN7S1549C33v86Ev();
extern void _ZN7S1549C33v87Ev();
extern void _ZN7S1549C33v88Ev();
extern void _ZN7S1549C33v89Ev();
extern void _ZN7S1549C33v90Ev();
extern void _ZN7S1549C23v91Ev();
extern void _ZN7S1549C23v92Ev();
extern void _ZN7S1549C23v93Ev();
static  VTBL_ENTRY vtc_S1549C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1549C2[0]),
  (VTBL_ENTRY)&_ZN7S1549C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1549C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1549C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1549C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1549C23v93Ev,
};
extern VTBL_ENTRY _ZTI7S1549C2[];
extern  VTBL_ENTRY _ZTV7S1549C2[];
Class_Descriptor cd_S1549C2 = {  "S1549C2", // class name
  bases_S1549C2, 2,
  &(vtc_S1549C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1549C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1549C2),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1549C1  : S1549C2 {
  ::S1597C7_nt s1549c1f0;
  virtual  ~S1549C1(); // _ZN7S1549C1D1Ev
  virtual void  v1(); // _ZN7S1549C12v1Ev
  virtual void  v2(); // _ZN7S1549C12v2Ev
  virtual void  v3(); // _ZN7S1549C12v3Ev
  virtual void  v4(); // _ZN7S1549C12v4Ev
  virtual void  v5(); // _ZN7S1549C12v5Ev
  virtual void  v6(); // _ZN7S1549C12v6Ev
  S1549C1(); // tgen
};
//SIG(1 S1549C1) C1{ BC2{ BC3{ BC4{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v91 v92 v93} vd v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fc[4] FC9{ BC10{ BC11{ m Fp Fi[2]}}} Fi[2]} Fp}}


 S1549C1 ::~S1549C1(){ note_dtor("S1549C1", this);}
void  S1549C1 ::v1(){vfunc_called(this, "_ZN7S1549C12v1Ev");}
void  S1549C1 ::v2(){vfunc_called(this, "_ZN7S1549C12v2Ev");}
void  S1549C1 ::v3(){vfunc_called(this, "_ZN7S1549C12v3Ev");}
void  S1549C1 ::v4(){vfunc_called(this, "_ZN7S1549C12v4Ev");}
void  S1549C1 ::v5(){vfunc_called(this, "_ZN7S1549C12v5Ev");}
void  S1549C1 ::v6(){vfunc_called(this, "_ZN7S1549C12v6Ev");}
S1549C1 ::S1549C1(){ note_ctor("S1549C1", this);} // tgen

static void Test_S1549C1()
{
  extern Class_Descriptor cd_S1549C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,24)];
    init_test(&cd_S1549C1, buf);
    S1549C1 *dp, &lv = *(dp=new (buf) S1549C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,92), "sizeof(S1549C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1549C1)");
    check_base_class_offset(lv, (S1549C4*)(S1549C3*)(S1549C2*), 0, "S1549C1");
    check_base_class_offset(lv, (S1549C3*)(S1549C2*), 0, "S1549C1");
    check_base_class_offset(lv, (S1549C2*), 0, "S1549C1");
    check_field_offset(lv, s1549c1f0, ABISELECT(104,64), "S1549C1.s1549c1f0");
    test_class_info(&lv, &cd_S1549C1);
    dp->~S1549C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1549C1(Test_S1549C1, "S1549C1", ABISELECT(144,92));

#else // __cplusplus

extern void _ZN7S1549C1C1Ev();
extern void _ZN7S1549C1D1Ev();
Name_Map name_map_S1549C1[] = {
  NSPAIR(_ZN7S1549C1C1Ev),
  NSPAIR(_ZN7S1549C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1549C4;
extern VTBL_ENTRY _ZTI7S1549C4[];
extern  VTBL_ENTRY _ZTV7S1549C4[];
extern Class_Descriptor cd_S1549C3;
extern VTBL_ENTRY _ZTI7S1549C3[];
extern  VTBL_ENTRY _ZTV7S1549C3[];
extern Class_Descriptor cd_S1549C2;
extern VTBL_ENTRY _ZTI7S1549C2[];
extern  VTBL_ENTRY _ZTV7S1549C2[];
static Base_Class bases_S1549C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1549C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1549C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1549C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1549C1[];
extern void _ZN7S1549C1D1Ev();
extern void _ZN7S1549C1D0Ev();
extern void _ZN7S1549C42v7Ev();
extern void _ZN7S1549C42v8Ev();
extern void _ZN7S1549C42v9Ev();
extern void _ZN7S1549C43v10Ev();
extern void _ZN7S1549C43v11Ev();
extern void _ZN7S1549C43v12Ev();
extern void _ZN7S1549C43v13Ev();
extern void _ZN7S1549C43v14Ev();
extern void _ZN7S1549C43v15Ev();
extern void _ZN7S1549C43v16Ev();
extern void _ZN7S1549C43v17Ev();
extern void _ZN7S1549C43v18Ev();
extern void _ZN7S1549C43v19Ev();
extern void _ZN7S1549C43v20Ev();
extern void _ZN7S1549C43v21Ev();
extern void _ZN7S1549C43v22Ev();
extern void _ZN7S1549C43v23Ev();
extern void _ZN7S1549C43v24Ev();
extern void _ZN7S1549C43v25Ev();
extern void _ZN7S1549C43v26Ev();
extern void _ZN7S1549C43v27Ev();
extern void _ZN7S1549C43v28Ev();
extern void _ZN7S1549C43v29Ev();
extern void _ZN7S1549C43v30Ev();
extern void _ZN7S1549C43v31Ev();
extern void _ZN7S1549C43v32Ev();
extern void _ZN7S1549C43v33Ev();
extern void _ZN7S1549C43v34Ev();
extern void _ZN7S1549C43v35Ev();
extern void _ZN7S1549C43v36Ev();
extern void _ZN7S1549C43v37Ev();
extern void _ZN7S1549C43v38Ev();
extern void _ZN7S1549C43v39Ev();
extern void _ZN7S1549C43v40Ev();
extern void _ZN7S1549C43v41Ev();
extern void _ZN7S1549C43v42Ev();
extern void _ZN7S1549C43v43Ev();
extern void _ZN7S1549C43v44Ev();
extern void _ZN7S1549C43v45Ev();
extern void _ZN7S1549C43v46Ev();
extern void _ZN7S1549C43v47Ev();
extern void _ZN7S1549C43v48Ev();
extern void _ZN7S1549C43v49Ev();
extern void _ZN7S1549C43v50Ev();
extern void _ZN7S1549C43v51Ev();
extern void _ZN7S1549C43v52Ev();
extern void _ZN7S1549C43v53Ev();
extern void _ZN7S1549C43v54Ev();
extern void _ZN7S1549C43v55Ev();
extern void _ZN7S1549C43v56Ev();
extern void _ZN7S1549C43v57Ev();
extern void _ZN7S1549C43v58Ev();
extern void _ZN7S1549C43v59Ev();
extern void _ZN7S1549C43v60Ev();
extern void _ZN7S1549C43v61Ev();
extern void _ZN7S1549C43v62Ev();
extern void _ZN7S1549C43v63Ev();
extern void _ZN7S1549C43v64Ev();
extern void _ZN7S1549C43v65Ev();
extern void _ZN7S1549C43v66Ev();
extern void _ZN7S1549C43v67Ev();
extern void _ZN7S1549C43v68Ev();
extern void _ZN7S1549C43v69Ev();
extern void _ZN7S1549C43v70Ev();
extern void _ZN7S1549C33v71Ev();
extern void _ZN7S1549C33v72Ev();
extern void _ZN7S1549C33v73Ev();
extern void _ZN7S1549C33v74Ev();
extern void _ZN7S1549C33v75Ev();
extern void _ZN7S1549C33v76Ev();
extern void _ZN7S1549C33v77Ev();
extern void _ZN7S1549C33v78Ev();
extern void _ZN7S1549C33v79Ev();
extern void _ZN7S1549C33v80Ev();
extern void _ZN7S1549C33v81Ev();
extern void _ZN7S1549C33v82Ev();
extern void _ZN7S1549C33v83Ev();
extern void _ZN7S1549C33v84Ev();
extern void _ZN7S1549C33v85Ev();
extern void _ZN7S1549C33v86Ev();
extern void _ZN7S1549C33v87Ev();
extern void _ZN7S1549C33v88Ev();
extern void _ZN7S1549C33v89Ev();
extern void _ZN7S1549C33v90Ev();
extern void _ZN7S1549C23v91Ev();
extern void _ZN7S1549C23v92Ev();
extern void _ZN7S1549C23v93Ev();
extern void _ZN7S1549C12v1Ev();
extern void _ZN7S1549C12v2Ev();
extern void _ZN7S1549C12v3Ev();
extern void _ZN7S1549C12v4Ev();
extern void _ZN7S1549C12v5Ev();
extern void _ZN7S1549C12v6Ev();
static  VTBL_ENTRY vtc_S1549C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1549C1[0]),
  (VTBL_ENTRY)&_ZN7S1549C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1549C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1549C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1549C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1549C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1549C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1549C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1549C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1549C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1549C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1549C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1549C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1549C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1549C12v6Ev,
};
extern VTBL_ENTRY _ZTI7S1549C1[];
extern  VTBL_ENTRY _ZTV7S1549C1[];
Class_Descriptor cd_S1549C1 = {  "S1549C1", // class name
  bases_S1549C1, 3,
  &(vtc_S1549C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,92), // object size
  NSPAIRA(_ZTI7S1549C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1549C1),97, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1293C4  {
  int s1293c4f0;
  __tsi64 s1293c4f1;
  void *s1293c4f2[4];
  int s1293c4f3[2];
  void *s1293c4f4;
  ::S1502C5_nt s1293c4f5;
  void *s1293c4f6[2];
  virtual  ~S1293C4(); // _ZN7S1293C4D1Ev
  virtual void  v10(); // _ZN7S1293C43v10Ev
  virtual void  v11(); // _ZN7S1293C43v11Ev
  virtual void  v12(); // _ZN7S1293C43v12Ev
  virtual void  v13(); // _ZN7S1293C43v13Ev
  virtual void  v14(); // _ZN7S1293C43v14Ev
  virtual void  v15(); // _ZN7S1293C43v15Ev
  virtual void  v16(); // _ZN7S1293C43v16Ev
  virtual void  v17(); // _ZN7S1293C43v17Ev
  virtual void  v18(); // _ZN7S1293C43v18Ev
  virtual void  v19(); // _ZN7S1293C43v19Ev
  virtual void  v20(); // _ZN7S1293C43v20Ev
  virtual void  v21(); // _ZN7S1293C43v21Ev
  virtual void  v22(); // _ZN7S1293C43v22Ev
  virtual void  v23(); // _ZN7S1293C43v23Ev
  virtual void  v24(); // _ZN7S1293C43v24Ev
  virtual void  v25(); // _ZN7S1293C43v25Ev
  virtual void  v26(); // _ZN7S1293C43v26Ev
  virtual void  v27(); // _ZN7S1293C43v27Ev
  virtual void  v28(); // _ZN7S1293C43v28Ev
  virtual void  v29(); // _ZN7S1293C43v29Ev
  virtual void  v30(); // _ZN7S1293C43v30Ev
  virtual void  v31(); // _ZN7S1293C43v31Ev
  virtual void  v32(); // _ZN7S1293C43v32Ev
  virtual void  v33(); // _ZN7S1293C43v33Ev
  virtual void  v34(); // _ZN7S1293C43v34Ev
  virtual void  v35(); // _ZN7S1293C43v35Ev
  virtual void  v36(); // _ZN7S1293C43v36Ev
  virtual void  v37(); // _ZN7S1293C43v37Ev
  virtual void  v38(); // _ZN7S1293C43v38Ev
  virtual void  v39(); // _ZN7S1293C43v39Ev
  virtual void  v40(); // _ZN7S1293C43v40Ev
  virtual void  v41(); // _ZN7S1293C43v41Ev
  virtual void  v42(); // _ZN7S1293C43v42Ev
  virtual void  v43(); // _ZN7S1293C43v43Ev
  virtual void  v44(); // _ZN7S1293C43v44Ev
  virtual void  v45(); // _ZN7S1293C43v45Ev
  virtual void  v46(); // _ZN7S1293C43v46Ev
  virtual void  v47(); // _ZN7S1293C43v47Ev
  virtual void  v48(); // _ZN7S1293C43v48Ev
  virtual void  v49(); // _ZN7S1293C43v49Ev
  virtual void  v50(); // _ZN7S1293C43v50Ev
  virtual void  v51(); // _ZN7S1293C43v51Ev
  virtual void  v52(); // _ZN7S1293C43v52Ev
  virtual void  v53(); // _ZN7S1293C43v53Ev
  virtual void  v54(); // _ZN7S1293C43v54Ev
  virtual void  v55(); // _ZN7S1293C43v55Ev
  virtual void  v56(); // _ZN7S1293C43v56Ev
  virtual void  v57(); // _ZN7S1293C43v57Ev
  virtual void  v58(); // _ZN7S1293C43v58Ev
  virtual void  v59(); // _ZN7S1293C43v59Ev
  virtual void  v60(); // _ZN7S1293C43v60Ev
  virtual void  v61(); // _ZN7S1293C43v61Ev
  virtual void  v62(); // _ZN7S1293C43v62Ev
  virtual void  v63(); // _ZN7S1293C43v63Ev
  virtual void  v64(); // _ZN7S1293C43v64Ev
  virtual void  v65(); // _ZN7S1293C43v65Ev
  virtual void  v66(); // _ZN7S1293C43v66Ev
  virtual void  v67(); // _ZN7S1293C43v67Ev
  virtual void  v68(); // _ZN7S1293C43v68Ev
  virtual void  v69(); // _ZN7S1293C43v69Ev
  virtual void  v70(); // _ZN7S1293C43v70Ev
  virtual void  v71(); // _ZN7S1293C43v71Ev
  virtual void  v72(); // _ZN7S1293C43v72Ev
  virtual void  v73(); // _ZN7S1293C43v73Ev
  S1293C4(); // tgen
};
//SIG(-1 S1293C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1293C4 ::~S1293C4(){ note_dtor("S1293C4", this);}
void  S1293C4 ::v10(){vfunc_called(this, "_ZN7S1293C43v10Ev");}
void  S1293C4 ::v11(){vfunc_called(this, "_ZN7S1293C43v11Ev");}
void  S1293C4 ::v12(){vfunc_called(this, "_ZN7S1293C43v12Ev");}
void  S1293C4 ::v13(){vfunc_called(this, "_ZN7S1293C43v13Ev");}
void  S1293C4 ::v14(){vfunc_called(this, "_ZN7S1293C43v14Ev");}
void  S1293C4 ::v15(){vfunc_called(this, "_ZN7S1293C43v15Ev");}
void  S1293C4 ::v16(){vfunc_called(this, "_ZN7S1293C43v16Ev");}
void  S1293C4 ::v17(){vfunc_called(this, "_ZN7S1293C43v17Ev");}
void  S1293C4 ::v18(){vfunc_called(this, "_ZN7S1293C43v18Ev");}
void  S1293C4 ::v19(){vfunc_called(this, "_ZN7S1293C43v19Ev");}
void  S1293C4 ::v20(){vfunc_called(this, "_ZN7S1293C43v20Ev");}
void  S1293C4 ::v21(){vfunc_called(this, "_ZN7S1293C43v21Ev");}
void  S1293C4 ::v22(){vfunc_called(this, "_ZN7S1293C43v22Ev");}
void  S1293C4 ::v23(){vfunc_called(this, "_ZN7S1293C43v23Ev");}
void  S1293C4 ::v24(){vfunc_called(this, "_ZN7S1293C43v24Ev");}
void  S1293C4 ::v25(){vfunc_called(this, "_ZN7S1293C43v25Ev");}
void  S1293C4 ::v26(){vfunc_called(this, "_ZN7S1293C43v26Ev");}
void  S1293C4 ::v27(){vfunc_called(this, "_ZN7S1293C43v27Ev");}
void  S1293C4 ::v28(){vfunc_called(this, "_ZN7S1293C43v28Ev");}
void  S1293C4 ::v29(){vfunc_called(this, "_ZN7S1293C43v29Ev");}
void  S1293C4 ::v30(){vfunc_called(this, "_ZN7S1293C43v30Ev");}
void  S1293C4 ::v31(){vfunc_called(this, "_ZN7S1293C43v31Ev");}
void  S1293C4 ::v32(){vfunc_called(this, "_ZN7S1293C43v32Ev");}
void  S1293C4 ::v33(){vfunc_called(this, "_ZN7S1293C43v33Ev");}
void  S1293C4 ::v34(){vfunc_called(this, "_ZN7S1293C43v34Ev");}
void  S1293C4 ::v35(){vfunc_called(this, "_ZN7S1293C43v35Ev");}
void  S1293C4 ::v36(){vfunc_called(this, "_ZN7S1293C43v36Ev");}
void  S1293C4 ::v37(){vfunc_called(this, "_ZN7S1293C43v37Ev");}
void  S1293C4 ::v38(){vfunc_called(this, "_ZN7S1293C43v38Ev");}
void  S1293C4 ::v39(){vfunc_called(this, "_ZN7S1293C43v39Ev");}
void  S1293C4 ::v40(){vfunc_called(this, "_ZN7S1293C43v40Ev");}
void  S1293C4 ::v41(){vfunc_called(this, "_ZN7S1293C43v41Ev");}
void  S1293C4 ::v42(){vfunc_called(this, "_ZN7S1293C43v42Ev");}
void  S1293C4 ::v43(){vfunc_called(this, "_ZN7S1293C43v43Ev");}
void  S1293C4 ::v44(){vfunc_called(this, "_ZN7S1293C43v44Ev");}
void  S1293C4 ::v45(){vfunc_called(this, "_ZN7S1293C43v45Ev");}
void  S1293C4 ::v46(){vfunc_called(this, "_ZN7S1293C43v46Ev");}
void  S1293C4 ::v47(){vfunc_called(this, "_ZN7S1293C43v47Ev");}
void  S1293C4 ::v48(){vfunc_called(this, "_ZN7S1293C43v48Ev");}
void  S1293C4 ::v49(){vfunc_called(this, "_ZN7S1293C43v49Ev");}
void  S1293C4 ::v50(){vfunc_called(this, "_ZN7S1293C43v50Ev");}
void  S1293C4 ::v51(){vfunc_called(this, "_ZN7S1293C43v51Ev");}
void  S1293C4 ::v52(){vfunc_called(this, "_ZN7S1293C43v52Ev");}
void  S1293C4 ::v53(){vfunc_called(this, "_ZN7S1293C43v53Ev");}
void  S1293C4 ::v54(){vfunc_called(this, "_ZN7S1293C43v54Ev");}
void  S1293C4 ::v55(){vfunc_called(this, "_ZN7S1293C43v55Ev");}
void  S1293C4 ::v56(){vfunc_called(this, "_ZN7S1293C43v56Ev");}
void  S1293C4 ::v57(){vfunc_called(this, "_ZN7S1293C43v57Ev");}
void  S1293C4 ::v58(){vfunc_called(this, "_ZN7S1293C43v58Ev");}
void  S1293C4 ::v59(){vfunc_called(this, "_ZN7S1293C43v59Ev");}
void  S1293C4 ::v60(){vfunc_called(this, "_ZN7S1293C43v60Ev");}
void  S1293C4 ::v61(){vfunc_called(this, "_ZN7S1293C43v61Ev");}
void  S1293C4 ::v62(){vfunc_called(this, "_ZN7S1293C43v62Ev");}
void  S1293C4 ::v63(){vfunc_called(this, "_ZN7S1293C43v63Ev");}
void  S1293C4 ::v64(){vfunc_called(this, "_ZN7S1293C43v64Ev");}
void  S1293C4 ::v65(){vfunc_called(this, "_ZN7S1293C43v65Ev");}
void  S1293C4 ::v66(){vfunc_called(this, "_ZN7S1293C43v66Ev");}
void  S1293C4 ::v67(){vfunc_called(this, "_ZN7S1293C43v67Ev");}
void  S1293C4 ::v68(){vfunc_called(this, "_ZN7S1293C43v68Ev");}
void  S1293C4 ::v69(){vfunc_called(this, "_ZN7S1293C43v69Ev");}
void  S1293C4 ::v70(){vfunc_called(this, "_ZN7S1293C43v70Ev");}
void  S1293C4 ::v71(){vfunc_called(this, "_ZN7S1293C43v71Ev");}
void  S1293C4 ::v72(){vfunc_called(this, "_ZN7S1293C43v72Ev");}
void  S1293C4 ::v73(){vfunc_called(this, "_ZN7S1293C43v73Ev");}
S1293C4 ::S1293C4(){ note_ctor("S1293C4", this);} // tgen

static void Test_S1293C4()
{
  extern Class_Descriptor cd_S1293C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1293C4, buf);
    S1293C4 *dp, &lv = *(dp=new (buf) S1293C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1293C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1293C4)");
    check_field_offset(lv, s1293c4f0, ABISELECT(8,4), "S1293C4.s1293c4f0");
    check_field_offset(lv, s1293c4f1, ABISELECT(16,8), "S1293C4.s1293c4f1");
    check_field_offset(lv, s1293c4f2, ABISELECT(24,16), "S1293C4.s1293c4f2");
    check_field_offset(lv, s1293c4f3, ABISELECT(56,32), "S1293C4.s1293c4f3");
    check_field_offset(lv, s1293c4f4, ABISELECT(64,40), "S1293C4.s1293c4f4");
    check_field_offset(lv, s1293c4f5, ABISELECT(72,44), "S1293C4.s1293c4f5");
    check_field_offset(lv, s1293c4f6, ABISELECT(80,52), "S1293C4.s1293c4f6");
    test_class_info(&lv, &cd_S1293C4);
    dp->~S1293C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1293C4(Test_S1293C4, "S1293C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1293C4C1Ev();
extern void _ZN7S1293C4D1Ev();
Name_Map name_map_S1293C4[] = {
  NSPAIR(_ZN7S1293C4C1Ev),
  NSPAIR(_ZN7S1293C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1293C4[];
extern void _ZN7S1293C4D1Ev();
extern void _ZN7S1293C4D0Ev();
extern void _ZN7S1293C43v10Ev();
extern void _ZN7S1293C43v11Ev();
extern void _ZN7S1293C43v12Ev();
extern void _ZN7S1293C43v13Ev();
extern void _ZN7S1293C43v14Ev();
extern void _ZN7S1293C43v15Ev();
extern void _ZN7S1293C43v16Ev();
extern void _ZN7S1293C43v17Ev();
extern void _ZN7S1293C43v18Ev();
extern void _ZN7S1293C43v19Ev();
extern void _ZN7S1293C43v20Ev();
extern void _ZN7S1293C43v21Ev();
extern void _ZN7S1293C43v22Ev();
extern void _ZN7S1293C43v23Ev();
extern void _ZN7S1293C43v24Ev();
extern void _ZN7S1293C43v25Ev();
extern void _ZN7S1293C43v26Ev();
extern void _ZN7S1293C43v27Ev();
extern void _ZN7S1293C43v28Ev();
extern void _ZN7S1293C43v29Ev();
extern void _ZN7S1293C43v30Ev();
extern void _ZN7S1293C43v31Ev();
extern void _ZN7S1293C43v32Ev();
extern void _ZN7S1293C43v33Ev();
extern void _ZN7S1293C43v34Ev();
extern void _ZN7S1293C43v35Ev();
extern void _ZN7S1293C43v36Ev();
extern void _ZN7S1293C43v37Ev();
extern void _ZN7S1293C43v38Ev();
extern void _ZN7S1293C43v39Ev();
extern void _ZN7S1293C43v40Ev();
extern void _ZN7S1293C43v41Ev();
extern void _ZN7S1293C43v42Ev();
extern void _ZN7S1293C43v43Ev();
extern void _ZN7S1293C43v44Ev();
extern void _ZN7S1293C43v45Ev();
extern void _ZN7S1293C43v46Ev();
extern void _ZN7S1293C43v47Ev();
extern void _ZN7S1293C43v48Ev();
extern void _ZN7S1293C43v49Ev();
extern void _ZN7S1293C43v50Ev();
extern void _ZN7S1293C43v51Ev();
extern void _ZN7S1293C43v52Ev();
extern void _ZN7S1293C43v53Ev();
extern void _ZN7S1293C43v54Ev();
extern void _ZN7S1293C43v55Ev();
extern void _ZN7S1293C43v56Ev();
extern void _ZN7S1293C43v57Ev();
extern void _ZN7S1293C43v58Ev();
extern void _ZN7S1293C43v59Ev();
extern void _ZN7S1293C43v60Ev();
extern void _ZN7S1293C43v61Ev();
extern void _ZN7S1293C43v62Ev();
extern void _ZN7S1293C43v63Ev();
extern void _ZN7S1293C43v64Ev();
extern void _ZN7S1293C43v65Ev();
extern void _ZN7S1293C43v66Ev();
extern void _ZN7S1293C43v67Ev();
extern void _ZN7S1293C43v68Ev();
extern void _ZN7S1293C43v69Ev();
extern void _ZN7S1293C43v70Ev();
extern void _ZN7S1293C43v71Ev();
extern void _ZN7S1293C43v72Ev();
extern void _ZN7S1293C43v73Ev();
static  VTBL_ENTRY vtc_S1293C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1293C4[0]),
  (VTBL_ENTRY)&_ZN7S1293C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1293C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v73Ev,
};
extern VTBL_ENTRY _ZTI7S1293C4[];
extern  VTBL_ENTRY _ZTV7S1293C4[];
Class_Descriptor cd_S1293C4 = {  "S1293C4", // class name
  0,0,//no base classes
  &(vtc_S1293C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1293C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1293C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1293C3  : S1293C4 {
  unsigned int s1293c3f0:1;
  unsigned int s1293c3f1:1;
  unsigned int s1293c3f2:1;
  unsigned int s1293c3f3:1;
  unsigned int s1293c3f4:1;
  unsigned int s1293c3f5:1;
  unsigned int s1293c3f6:1;
  ::S578C11_nt s1293c3f7;
  virtual  ~S1293C3(); // _ZN7S1293C3D1Ev
  virtual void  v74(); // _ZN7S1293C33v74Ev
  virtual void  v75(); // _ZN7S1293C33v75Ev
  virtual void  v76(); // _ZN7S1293C33v76Ev
  virtual void  v77(); // _ZN7S1293C33v77Ev
  virtual void  v78(); // _ZN7S1293C33v78Ev
  virtual void  v79(); // _ZN7S1293C33v79Ev
  virtual void  v80(); // _ZN7S1293C33v80Ev
  virtual void  v81(); // _ZN7S1293C33v81Ev
  virtual void  v82(); // _ZN7S1293C33v82Ev
  virtual void  v83(); // _ZN7S1293C33v83Ev
  virtual void  v84(); // _ZN7S1293C33v84Ev
  virtual void  v85(); // _ZN7S1293C33v85Ev
  virtual void  v86(); // _ZN7S1293C33v86Ev
  virtual void  v87(); // _ZN7S1293C33v87Ev
  virtual void  v88(); // _ZN7S1293C33v88Ev
  virtual void  v89(); // _ZN7S1293C33v89Ev
  virtual void  v90(); // _ZN7S1293C33v90Ev
  virtual void  v91(); // _ZN7S1293C33v91Ev
  virtual void  v92(); // _ZN7S1293C33v92Ev
  virtual void  v93(); // _ZN7S1293C33v93Ev
  S1293C3(); // tgen
};
//SIG(-1 S1293C3) C1{ BC2{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC4{ m}}


 S1293C3 ::~S1293C3(){ note_dtor("S1293C3", this);}
void  S1293C3 ::v74(){vfunc_called(this, "_ZN7S1293C33v74Ev");}
void  S1293C3 ::v75(){vfunc_called(this, "_ZN7S1293C33v75Ev");}
void  S1293C3 ::v76(){vfunc_called(this, "_ZN7S1293C33v76Ev");}
void  S1293C3 ::v77(){vfunc_called(this, "_ZN7S1293C33v77Ev");}
void  S1293C3 ::v78(){vfunc_called(this, "_ZN7S1293C33v78Ev");}
void  S1293C3 ::v79(){vfunc_called(this, "_ZN7S1293C33v79Ev");}
void  S1293C3 ::v80(){vfunc_called(this, "_ZN7S1293C33v80Ev");}
void  S1293C3 ::v81(){vfunc_called(this, "_ZN7S1293C33v81Ev");}
void  S1293C3 ::v82(){vfunc_called(this, "_ZN7S1293C33v82Ev");}
void  S1293C3 ::v83(){vfunc_called(this, "_ZN7S1293C33v83Ev");}
void  S1293C3 ::v84(){vfunc_called(this, "_ZN7S1293C33v84Ev");}
void  S1293C3 ::v85(){vfunc_called(this, "_ZN7S1293C33v85Ev");}
void  S1293C3 ::v86(){vfunc_called(this, "_ZN7S1293C33v86Ev");}
void  S1293C3 ::v87(){vfunc_called(this, "_ZN7S1293C33v87Ev");}
void  S1293C3 ::v88(){vfunc_called(this, "_ZN7S1293C33v88Ev");}
void  S1293C3 ::v89(){vfunc_called(this, "_ZN7S1293C33v89Ev");}
void  S1293C3 ::v90(){vfunc_called(this, "_ZN7S1293C33v90Ev");}
void  S1293C3 ::v91(){vfunc_called(this, "_ZN7S1293C33v91Ev");}
void  S1293C3 ::v92(){vfunc_called(this, "_ZN7S1293C33v92Ev");}
void  S1293C3 ::v93(){vfunc_called(this, "_ZN7S1293C33v93Ev");}
S1293C3 ::S1293C3(){ note_ctor("S1293C3", this);} // tgen

static void Test_S1293C3()
{
  extern Class_Descriptor cd_S1293C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1293C3, buf);
    S1293C3 *dp, &lv = *(dp=new (buf) S1293C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1293C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1293C3)");
    check_base_class_offset(lv, (S1293C4*), 0, "S1293C3");
    set_bf_and_test(lv, s1293c3f0, ABISELECT(96,60), 0, 1, 1, "S1293C3");
    set_bf_and_test(lv, s1293c3f1, ABISELECT(96,60), 1, 1, 1, "S1293C3");
    set_bf_and_test(lv, s1293c3f2, ABISELECT(96,60), 2, 1, 1, "S1293C3");
    set_bf_and_test(lv, s1293c3f3, ABISELECT(96,60), 3, 1, 1, "S1293C3");
    set_bf_and_test(lv, s1293c3f4, ABISELECT(96,60), 4, 1, 1, "S1293C3");
    set_bf_and_test(lv, s1293c3f5, ABISELECT(96,60), 5, 1, 1, "S1293C3");
    set_bf_and_test(lv, s1293c3f6, ABISELECT(96,60), 6, 1, 1, "S1293C3");
    check_field_offset(lv, s1293c3f7, ABISELECT(97,61), "S1293C3.s1293c3f7");
    test_class_info(&lv, &cd_S1293C3);
    dp->~S1293C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1293C3(Test_S1293C3, "S1293C3", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1293C3C1Ev();
extern void _ZN7S1293C3D1Ev();
Name_Map name_map_S1293C3[] = {
  NSPAIR(_ZN7S1293C3C1Ev),
  NSPAIR(_ZN7S1293C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1293C4;
extern VTBL_ENTRY _ZTI7S1293C4[];
extern  VTBL_ENTRY _ZTV7S1293C4[];
static Base_Class bases_S1293C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1293C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1293C3[];
extern void _ZN7S1293C3D1Ev();
extern void _ZN7S1293C3D0Ev();
extern void _ZN7S1293C43v10Ev();
extern void _ZN7S1293C43v11Ev();
extern void _ZN7S1293C43v12Ev();
extern void _ZN7S1293C43v13Ev();
extern void _ZN7S1293C43v14Ev();
extern void _ZN7S1293C43v15Ev();
extern void _ZN7S1293C43v16Ev();
extern void _ZN7S1293C43v17Ev();
extern void _ZN7S1293C43v18Ev();
extern void _ZN7S1293C43v19Ev();
extern void _ZN7S1293C43v20Ev();
extern void _ZN7S1293C43v21Ev();
extern void _ZN7S1293C43v22Ev();
extern void _ZN7S1293C43v23Ev();
extern void _ZN7S1293C43v24Ev();
extern void _ZN7S1293C43v25Ev();
extern void _ZN7S1293C43v26Ev();
extern void _ZN7S1293C43v27Ev();
extern void _ZN7S1293C43v28Ev();
extern void _ZN7S1293C43v29Ev();
extern void _ZN7S1293C43v30Ev();
extern void _ZN7S1293C43v31Ev();
extern void _ZN7S1293C43v32Ev();
extern void _ZN7S1293C43v33Ev();
extern void _ZN7S1293C43v34Ev();
extern void _ZN7S1293C43v35Ev();
extern void _ZN7S1293C43v36Ev();
extern void _ZN7S1293C43v37Ev();
extern void _ZN7S1293C43v38Ev();
extern void _ZN7S1293C43v39Ev();
extern void _ZN7S1293C43v40Ev();
extern void _ZN7S1293C43v41Ev();
extern void _ZN7S1293C43v42Ev();
extern void _ZN7S1293C43v43Ev();
extern void _ZN7S1293C43v44Ev();
extern void _ZN7S1293C43v45Ev();
extern void _ZN7S1293C43v46Ev();
extern void _ZN7S1293C43v47Ev();
extern void _ZN7S1293C43v48Ev();
extern void _ZN7S1293C43v49Ev();
extern void _ZN7S1293C43v50Ev();
extern void _ZN7S1293C43v51Ev();
extern void _ZN7S1293C43v52Ev();
extern void _ZN7S1293C43v53Ev();
extern void _ZN7S1293C43v54Ev();
extern void _ZN7S1293C43v55Ev();
extern void _ZN7S1293C43v56Ev();
extern void _ZN7S1293C43v57Ev();
extern void _ZN7S1293C43v58Ev();
extern void _ZN7S1293C43v59Ev();
extern void _ZN7S1293C43v60Ev();
extern void _ZN7S1293C43v61Ev();
extern void _ZN7S1293C43v62Ev();
extern void _ZN7S1293C43v63Ev();
extern void _ZN7S1293C43v64Ev();
extern void _ZN7S1293C43v65Ev();
extern void _ZN7S1293C43v66Ev();
extern void _ZN7S1293C43v67Ev();
extern void _ZN7S1293C43v68Ev();
extern void _ZN7S1293C43v69Ev();
extern void _ZN7S1293C43v70Ev();
extern void _ZN7S1293C43v71Ev();
extern void _ZN7S1293C43v72Ev();
extern void _ZN7S1293C43v73Ev();
extern void _ZN7S1293C33v74Ev();
extern void _ZN7S1293C33v75Ev();
extern void _ZN7S1293C33v76Ev();
extern void _ZN7S1293C33v77Ev();
extern void _ZN7S1293C33v78Ev();
extern void _ZN7S1293C33v79Ev();
extern void _ZN7S1293C33v80Ev();
extern void _ZN7S1293C33v81Ev();
extern void _ZN7S1293C33v82Ev();
extern void _ZN7S1293C33v83Ev();
extern void _ZN7S1293C33v84Ev();
extern void _ZN7S1293C33v85Ev();
extern void _ZN7S1293C33v86Ev();
extern void _ZN7S1293C33v87Ev();
extern void _ZN7S1293C33v88Ev();
extern void _ZN7S1293C33v89Ev();
extern void _ZN7S1293C33v90Ev();
extern void _ZN7S1293C33v91Ev();
extern void _ZN7S1293C33v92Ev();
extern void _ZN7S1293C33v93Ev();
static  VTBL_ENTRY vtc_S1293C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1293C3[0]),
  (VTBL_ENTRY)&_ZN7S1293C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1293C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v93Ev,
};
extern VTBL_ENTRY _ZTI7S1293C3[];
extern  VTBL_ENTRY _ZTV7S1293C3[];
Class_Descriptor cd_S1293C3 = {  "S1293C3", // class name
  bases_S1293C3, 1,
  &(vtc_S1293C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1293C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1293C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1293C2  : S1293C3 {
  virtual  ~S1293C2(); // _ZN7S1293C2D1Ev
  virtual void  v94(); // _ZN7S1293C23v94Ev
  virtual void  v95(); // _ZN7S1293C23v95Ev
  virtual void  v96(); // _ZN7S1293C23v96Ev
  S1293C2(); // tgen
};
//SIG(-1 S1293C2) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC5{ m}} vd v1 v2 v3}


 S1293C2 ::~S1293C2(){ note_dtor("S1293C2", this);}
void  S1293C2 ::v94(){vfunc_called(this, "_ZN7S1293C23v94Ev");}
void  S1293C2 ::v95(){vfunc_called(this, "_ZN7S1293C23v95Ev");}
void  S1293C2 ::v96(){vfunc_called(this, "_ZN7S1293C23v96Ev");}
S1293C2 ::S1293C2(){ note_ctor("S1293C2", this);} // tgen

static void Test_S1293C2()
{
  extern Class_Descriptor cd_S1293C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,17)];
    init_test(&cd_S1293C2, buf);
    S1293C2 *dp, &lv = *(dp=new (buf) S1293C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,64), "sizeof(S1293C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1293C2)");
    check_base_class_offset(lv, (S1293C4*)(S1293C3*), 0, "S1293C2");
    check_base_class_offset(lv, (S1293C3*), 0, "S1293C2");
    test_class_info(&lv, &cd_S1293C2);
    dp->~S1293C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1293C2(Test_S1293C2, "S1293C2", ABISELECT(104,64));

#else // __cplusplus

extern void _ZN7S1293C2C1Ev();
extern void _ZN7S1293C2D1Ev();
Name_Map name_map_S1293C2[] = {
  NSPAIR(_ZN7S1293C2C1Ev),
  NSPAIR(_ZN7S1293C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1293C4;
extern VTBL_ENTRY _ZTI7S1293C4[];
extern  VTBL_ENTRY _ZTV7S1293C4[];
extern Class_Descriptor cd_S1293C3;
extern VTBL_ENTRY _ZTI7S1293C3[];
extern  VTBL_ENTRY _ZTV7S1293C3[];
static Base_Class bases_S1293C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1293C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1293C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1293C2[];
extern void _ZN7S1293C2D1Ev();
extern void _ZN7S1293C2D0Ev();
extern void _ZN7S1293C43v10Ev();
extern void _ZN7S1293C43v11Ev();
extern void _ZN7S1293C43v12Ev();
extern void _ZN7S1293C43v13Ev();
extern void _ZN7S1293C43v14Ev();
extern void _ZN7S1293C43v15Ev();
extern void _ZN7S1293C43v16Ev();
extern void _ZN7S1293C43v17Ev();
extern void _ZN7S1293C43v18Ev();
extern void _ZN7S1293C43v19Ev();
extern void _ZN7S1293C43v20Ev();
extern void _ZN7S1293C43v21Ev();
extern void _ZN7S1293C43v22Ev();
extern void _ZN7S1293C43v23Ev();
extern void _ZN7S1293C43v24Ev();
extern void _ZN7S1293C43v25Ev();
extern void _ZN7S1293C43v26Ev();
extern void _ZN7S1293C43v27Ev();
extern void _ZN7S1293C43v28Ev();
extern void _ZN7S1293C43v29Ev();
extern void _ZN7S1293C43v30Ev();
extern void _ZN7S1293C43v31Ev();
extern void _ZN7S1293C43v32Ev();
extern void _ZN7S1293C43v33Ev();
extern void _ZN7S1293C43v34Ev();
extern void _ZN7S1293C43v35Ev();
extern void _ZN7S1293C43v36Ev();
extern void _ZN7S1293C43v37Ev();
extern void _ZN7S1293C43v38Ev();
extern void _ZN7S1293C43v39Ev();
extern void _ZN7S1293C43v40Ev();
extern void _ZN7S1293C43v41Ev();
extern void _ZN7S1293C43v42Ev();
extern void _ZN7S1293C43v43Ev();
extern void _ZN7S1293C43v44Ev();
extern void _ZN7S1293C43v45Ev();
extern void _ZN7S1293C43v46Ev();
extern void _ZN7S1293C43v47Ev();
extern void _ZN7S1293C43v48Ev();
extern void _ZN7S1293C43v49Ev();
extern void _ZN7S1293C43v50Ev();
extern void _ZN7S1293C43v51Ev();
extern void _ZN7S1293C43v52Ev();
extern void _ZN7S1293C43v53Ev();
extern void _ZN7S1293C43v54Ev();
extern void _ZN7S1293C43v55Ev();
extern void _ZN7S1293C43v56Ev();
extern void _ZN7S1293C43v57Ev();
extern void _ZN7S1293C43v58Ev();
extern void _ZN7S1293C43v59Ev();
extern void _ZN7S1293C43v60Ev();
extern void _ZN7S1293C43v61Ev();
extern void _ZN7S1293C43v62Ev();
extern void _ZN7S1293C43v63Ev();
extern void _ZN7S1293C43v64Ev();
extern void _ZN7S1293C43v65Ev();
extern void _ZN7S1293C43v66Ev();
extern void _ZN7S1293C43v67Ev();
extern void _ZN7S1293C43v68Ev();
extern void _ZN7S1293C43v69Ev();
extern void _ZN7S1293C43v70Ev();
extern void _ZN7S1293C43v71Ev();
extern void _ZN7S1293C43v72Ev();
extern void _ZN7S1293C43v73Ev();
extern void _ZN7S1293C33v74Ev();
extern void _ZN7S1293C33v75Ev();
extern void _ZN7S1293C33v76Ev();
extern void _ZN7S1293C33v77Ev();
extern void _ZN7S1293C33v78Ev();
extern void _ZN7S1293C33v79Ev();
extern void _ZN7S1293C33v80Ev();
extern void _ZN7S1293C33v81Ev();
extern void _ZN7S1293C33v82Ev();
extern void _ZN7S1293C33v83Ev();
extern void _ZN7S1293C33v84Ev();
extern void _ZN7S1293C33v85Ev();
extern void _ZN7S1293C33v86Ev();
extern void _ZN7S1293C33v87Ev();
extern void _ZN7S1293C33v88Ev();
extern void _ZN7S1293C33v89Ev();
extern void _ZN7S1293C33v90Ev();
extern void _ZN7S1293C33v91Ev();
extern void _ZN7S1293C33v92Ev();
extern void _ZN7S1293C33v93Ev();
extern void _ZN7S1293C23v94Ev();
extern void _ZN7S1293C23v95Ev();
extern void _ZN7S1293C23v96Ev();
static  VTBL_ENTRY vtc_S1293C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1293C2[0]),
  (VTBL_ENTRY)&_ZN7S1293C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1293C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1293C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1293C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1293C23v96Ev,
};
extern VTBL_ENTRY _ZTI7S1293C2[];
extern  VTBL_ENTRY _ZTV7S1293C2[];
Class_Descriptor cd_S1293C2 = {  "S1293C2", // class name
  bases_S1293C2, 2,
  &(vtc_S1293C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,64), // object size
  NSPAIRA(_ZTI7S1293C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1293C2),91, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1293C1  : S1293C2 {
  void *s1293c1f0;
  int s1293c1f1;
  virtual  ~S1293C1(); // _ZN7S1293C1D1Ev
  virtual void  v1(); // _ZN7S1293C12v1Ev
  virtual void  v2(); // _ZN7S1293C12v2Ev
  virtual void  v3(); // _ZN7S1293C12v3Ev
  virtual void  v4(); // _ZN7S1293C12v4Ev
  virtual void  v5(); // _ZN7S1293C12v5Ev
  virtual void  v6(); // _ZN7S1293C12v6Ev
  virtual void  v7(); // _ZN7S1293C12v7Ev
  virtual void  v8(); // _ZN7S1293C12v8Ev
  virtual void  v9(); // _ZN7S1293C12v9Ev
  S1293C1(); // tgen
};
//SIG(1 S1293C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC6{ m}} vd v94 v95 v96} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp Fi}


 S1293C1 ::~S1293C1(){ note_dtor("S1293C1", this);}
void  S1293C1 ::v1(){vfunc_called(this, "_ZN7S1293C12v1Ev");}
void  S1293C1 ::v2(){vfunc_called(this, "_ZN7S1293C12v2Ev");}
void  S1293C1 ::v3(){vfunc_called(this, "_ZN7S1293C12v3Ev");}
void  S1293C1 ::v4(){vfunc_called(this, "_ZN7S1293C12v4Ev");}
void  S1293C1 ::v5(){vfunc_called(this, "_ZN7S1293C12v5Ev");}
void  S1293C1 ::v6(){vfunc_called(this, "_ZN7S1293C12v6Ev");}
void  S1293C1 ::v7(){vfunc_called(this, "_ZN7S1293C12v7Ev");}
void  S1293C1 ::v8(){vfunc_called(this, "_ZN7S1293C12v8Ev");}
void  S1293C1 ::v9(){vfunc_called(this, "_ZN7S1293C12v9Ev");}
S1293C1 ::S1293C1(){ note_ctor("S1293C1", this);} // tgen

static void Test_S1293C1()
{
  extern Class_Descriptor cd_S1293C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,19)];
    init_test(&cd_S1293C1, buf);
    S1293C1 *dp, &lv = *(dp=new (buf) S1293C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,72), "sizeof(S1293C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1293C1)");
    check_base_class_offset(lv, (S1293C4*)(S1293C3*)(S1293C2*), 0, "S1293C1");
    check_base_class_offset(lv, (S1293C3*)(S1293C2*), 0, "S1293C1");
    check_base_class_offset(lv, (S1293C2*), 0, "S1293C1");
    check_field_offset(lv, s1293c1f0, ABISELECT(104,64), "S1293C1.s1293c1f0");
    check_field_offset(lv, s1293c1f1, ABISELECT(112,68), "S1293C1.s1293c1f1");
    test_class_info(&lv, &cd_S1293C1);
    dp->~S1293C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1293C1(Test_S1293C1, "S1293C1", ABISELECT(120,72));

#else // __cplusplus

extern void _ZN7S1293C1C1Ev();
extern void _ZN7S1293C1D1Ev();
Name_Map name_map_S1293C1[] = {
  NSPAIR(_ZN7S1293C1C1Ev),
  NSPAIR(_ZN7S1293C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1293C4;
extern VTBL_ENTRY _ZTI7S1293C4[];
extern  VTBL_ENTRY _ZTV7S1293C4[];
extern Class_Descriptor cd_S1293C3;
extern VTBL_ENTRY _ZTI7S1293C3[];
extern  VTBL_ENTRY _ZTV7S1293C3[];
extern Class_Descriptor cd_S1293C2;
extern VTBL_ENTRY _ZTI7S1293C2[];
extern  VTBL_ENTRY _ZTV7S1293C2[];
static Base_Class bases_S1293C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1293C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1293C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1293C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1293C1[];
extern void _ZN7S1293C1D1Ev();
extern void _ZN7S1293C1D0Ev();
extern void _ZN7S1293C43v10Ev();
extern void _ZN7S1293C43v11Ev();
extern void _ZN7S1293C43v12Ev();
extern void _ZN7S1293C43v13Ev();
extern void _ZN7S1293C43v14Ev();
extern void _ZN7S1293C43v15Ev();
extern void _ZN7S1293C43v16Ev();
extern void _ZN7S1293C43v17Ev();
extern void _ZN7S1293C43v18Ev();
extern void _ZN7S1293C43v19Ev();
extern void _ZN7S1293C43v20Ev();
extern void _ZN7S1293C43v21Ev();
extern void _ZN7S1293C43v22Ev();
extern void _ZN7S1293C43v23Ev();
extern void _ZN7S1293C43v24Ev();
extern void _ZN7S1293C43v25Ev();
extern void _ZN7S1293C43v26Ev();
extern void _ZN7S1293C43v27Ev();
extern void _ZN7S1293C43v28Ev();
extern void _ZN7S1293C43v29Ev();
extern void _ZN7S1293C43v30Ev();
extern void _ZN7S1293C43v31Ev();
extern void _ZN7S1293C43v32Ev();
extern void _ZN7S1293C43v33Ev();
extern void _ZN7S1293C43v34Ev();
extern void _ZN7S1293C43v35Ev();
extern void _ZN7S1293C43v36Ev();
extern void _ZN7S1293C43v37Ev();
extern void _ZN7S1293C43v38Ev();
extern void _ZN7S1293C43v39Ev();
extern void _ZN7S1293C43v40Ev();
extern void _ZN7S1293C43v41Ev();
extern void _ZN7S1293C43v42Ev();
extern void _ZN7S1293C43v43Ev();
extern void _ZN7S1293C43v44Ev();
extern void _ZN7S1293C43v45Ev();
extern void _ZN7S1293C43v46Ev();
extern void _ZN7S1293C43v47Ev();
extern void _ZN7S1293C43v48Ev();
extern void _ZN7S1293C43v49Ev();
extern void _ZN7S1293C43v50Ev();
extern void _ZN7S1293C43v51Ev();
extern void _ZN7S1293C43v52Ev();
extern void _ZN7S1293C43v53Ev();
extern void _ZN7S1293C43v54Ev();
extern void _ZN7S1293C43v55Ev();
extern void _ZN7S1293C43v56Ev();
extern void _ZN7S1293C43v57Ev();
extern void _ZN7S1293C43v58Ev();
extern void _ZN7S1293C43v59Ev();
extern void _ZN7S1293C43v60Ev();
extern void _ZN7S1293C43v61Ev();
extern void _ZN7S1293C43v62Ev();
extern void _ZN7S1293C43v63Ev();
extern void _ZN7S1293C43v64Ev();
extern void _ZN7S1293C43v65Ev();
extern void _ZN7S1293C43v66Ev();
extern void _ZN7S1293C43v67Ev();
extern void _ZN7S1293C43v68Ev();
extern void _ZN7S1293C43v69Ev();
extern void _ZN7S1293C43v70Ev();
extern void _ZN7S1293C43v71Ev();
extern void _ZN7S1293C43v72Ev();
extern void _ZN7S1293C43v73Ev();
extern void _ZN7S1293C33v74Ev();
extern void _ZN7S1293C33v75Ev();
extern void _ZN7S1293C33v76Ev();
extern void _ZN7S1293C33v77Ev();
extern void _ZN7S1293C33v78Ev();
extern void _ZN7S1293C33v79Ev();
extern void _ZN7S1293C33v80Ev();
extern void _ZN7S1293C33v81Ev();
extern void _ZN7S1293C33v82Ev();
extern void _ZN7S1293C33v83Ev();
extern void _ZN7S1293C33v84Ev();
extern void _ZN7S1293C33v85Ev();
extern void _ZN7S1293C33v86Ev();
extern void _ZN7S1293C33v87Ev();
extern void _ZN7S1293C33v88Ev();
extern void _ZN7S1293C33v89Ev();
extern void _ZN7S1293C33v90Ev();
extern void _ZN7S1293C33v91Ev();
extern void _ZN7S1293C33v92Ev();
extern void _ZN7S1293C33v93Ev();
extern void _ZN7S1293C23v94Ev();
extern void _ZN7S1293C23v95Ev();
extern void _ZN7S1293C23v96Ev();
extern void _ZN7S1293C12v1Ev();
extern void _ZN7S1293C12v2Ev();
extern void _ZN7S1293C12v3Ev();
extern void _ZN7S1293C12v4Ev();
extern void _ZN7S1293C12v5Ev();
extern void _ZN7S1293C12v6Ev();
extern void _ZN7S1293C12v7Ev();
extern void _ZN7S1293C12v8Ev();
extern void _ZN7S1293C12v9Ev();
static  VTBL_ENTRY vtc_S1293C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1293C1[0]),
  (VTBL_ENTRY)&_ZN7S1293C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1293C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1293C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1293C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1293C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1293C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1293C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1293C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1293C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1293C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1293C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1293C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1293C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1293C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1293C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1293C12v9Ev,
};
extern VTBL_ENTRY _ZTI7S1293C1[];
extern  VTBL_ENTRY _ZTV7S1293C1[];
Class_Descriptor cd_S1293C1 = {  "S1293C1", // class name
  bases_S1293C1, 3,
  &(vtc_S1293C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(120,72), // object size
  NSPAIRA(_ZTI7S1293C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1293C1),100, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C2_nt  {
  __tsi64 s21196c2f0;
  void  mf21196c2(); // _ZN11S21196C2_nt9mf21196c2Ev
  virtual  ~S21196C2_nt(); // _ZN11S21196C2_ntD1Ev
  S21196C2_nt(); // tgen
};
//SIG(-1 S21196C2_nt) C1{ vd m FL}


void  S21196C2_nt ::mf21196c2(){}
 S21196C2_nt ::~S21196C2_nt(){ note_dtor("S21196C2_nt", this);}
S21196C2_nt ::S21196C2_nt(){ note_ctor("S21196C2_nt", this);} // tgen

//skip512 S21196C2_nt

#else // __cplusplus

extern void _ZN11S21196C2_ntC1Ev();
extern void _ZN11S21196C2_ntD1Ev();
Name_Map name_map_S21196C2_nt[] = {
  NSPAIR(_ZN11S21196C2_ntC1Ev),
  NSPAIR(_ZN11S21196C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern void _ZN11S21196C2_ntD1Ev();
extern void _ZN11S21196C2_ntD0Ev();
static  VTBL_ENTRY vtc_S21196C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S21196C2_nt[0]),
  (VTBL_ENTRY)&_ZN11S21196C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S21196C2_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
VTBL_ENTRY *P__ZTI11S21196C2_nt = _ZTI11S21196C2_nt; 
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
Class_Descriptor cd_S21196C2_nt = {  "S21196C2_nt", // class name
  0,0,//no base classes
  &(vtc_S21196C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI11S21196C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S21196C2_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C6  : S21196C2_nt {
  ::S21196C2_nt s21196c6f0;
  virtual  ~S21196C6(); // _ZN8S21196C6D1Ev
  S21196C6(); // tgen
};
//SIG(-1 S21196C6) C1{ BC2{ vd m FL} vd FC2}


 S21196C6 ::~S21196C6(){ note_dtor("S21196C6", this);}
S21196C6 ::S21196C6(){ note_ctor("S21196C6", this);} // tgen

static void Test_S21196C6()
{
  extern Class_Descriptor cd_S21196C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_S21196C6, buf);
    S21196C6 *dp, &lv = *(dp=new (buf) S21196C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S21196C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C6)");
    check_base_class_offset(lv, (S21196C2_nt*), 0, "S21196C6");
    check_field_offset(lv, s21196c6f0, ABISELECT(16,12), "S21196C6.s21196c6f0");
    test_class_info(&lv, &cd_S21196C6);
    dp->~S21196C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C6(Test_S21196C6, "S21196C6", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN8S21196C6C1Ev();
extern void _ZN8S21196C6D1Ev();
Name_Map name_map_S21196C6[] = {
  NSPAIR(_ZN8S21196C6C1Ev),
  NSPAIR(_ZN8S21196C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
static Base_Class bases_S21196C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S21196C6[];
extern void _ZN8S21196C6D1Ev();
extern void _ZN8S21196C6D0Ev();
static  VTBL_ENTRY vtc_S21196C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C6[0]),
  (VTBL_ENTRY)&_ZN8S21196C6D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C6D0Ev,
};
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
Class_Descriptor cd_S21196C6 = {  "S21196C6", // class name
  bases_S21196C6, 1,
  &(vtc_S21196C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI8S21196C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S21196C6),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C5  : S21196C2_nt , S21196C6 {
  ::S21196C6 s21196c5f0;
  virtual  ~S21196C5(); // _ZN8S21196C5D1Ev
  S21196C5(); // tgen
};
//SIG(-1 S21196C5) C1{ BC2{ vd m FL} BC3{ BC2 vd FC2} vd FC3}


 S21196C5 ::~S21196C5(){ note_dtor("S21196C5", this);}
S21196C5 ::S21196C5(){ note_ctor("S21196C5", this);} // tgen

static void Test_S21196C5()
{
  extern Class_Descriptor cd_S21196C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,16)];
    init_test(&cd_S21196C5, buf);
    S21196C5 *dp, &lv = *(dp=new (buf) S21196C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S21196C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C5)");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*), 0, "S21196C5");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), ABISELECT(16,12), "S21196C5");
    check_base_class_offset(lv, (S21196C6*), ABISELECT(16,12), "S21196C5");
    check_field_offset(lv, s21196c5f0, ABISELECT(48,36), "S21196C5.s21196c5f0");
    test_class_info(&lv, &cd_S21196C5);
    dp->~S21196C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C5(Test_S21196C5, "S21196C5", ABISELECT(80,60));

#else // __cplusplus

extern void _ZN8S21196C5C1Ev();
extern void _ZN8S21196C5D1Ev();
Name_Map name_map_S21196C5[] = {
  NSPAIR(_ZN8S21196C5C1Ev),
  NSPAIR(_ZN8S21196C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
static Base_Class bases_S21196C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C2_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S21196C5[];
extern void _ZN8S21196C5D1Ev();
extern void _ZN8S21196C5D0Ev();
extern void ABISELECT(_ZThn16_N8S21196C5D1Ev,_ZThn12_N8S21196C5D1Ev)();
extern void ABISELECT(_ZThn16_N8S21196C5D0Ev,_ZThn12_N8S21196C5D0Ev)();
static  VTBL_ENTRY vtc_S21196C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C5[0]),
  (VTBL_ENTRY)&_ZN8S21196C5D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C5D0Ev,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S21196C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S21196C5D1Ev,_ZThn12_N8S21196C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S21196C5D0Ev,_ZThn12_N8S21196C5D0Ev),
};
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
Class_Descriptor cd_S21196C5 = {  "S21196C5", // class name
  bases_S21196C5, 3,
  &(vtc_S21196C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI8S21196C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S21196C5),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C4  : S21196C5 {
  ~S21196C4(); // tgen
  S21196C4(); // tgen
};
//SIG(-1 S21196C4) C1{ BC2{ BC3{ vd m FL} BC4{ BC3 vd FC3} vd FC4}}


S21196C4 ::~S21196C4(){ note_dtor("S21196C4", this);} // tgen
S21196C4 ::S21196C4(){ note_ctor("S21196C4", this);} // tgen

static void Test_S21196C4()
{
  extern Class_Descriptor cd_S21196C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,16)];
    init_test(&cd_S21196C4, buf);
    S21196C4 *dp, &lv = *(dp=new (buf) S21196C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S21196C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C4)");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*), 0, "S21196C4");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*), ABISELECT(16,12), "S21196C4");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*), ABISELECT(16,12), "S21196C4");
    check_base_class_offset(lv, (S21196C5*), 0, "S21196C4");
    test_class_info(&lv, &cd_S21196C4);
    dp->~S21196C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C4(Test_S21196C4, "S21196C4", ABISELECT(80,60));

#else // __cplusplus

extern void _ZN8S21196C4C1Ev();
extern void _ZN8S21196C4D1Ev();
Name_Map name_map_S21196C4[] = {
  NSPAIR(_ZN8S21196C4C1Ev),
  NSPAIR(_ZN8S21196C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
static Base_Class bases_S21196C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S21196C4[];
extern void _ZN8S21196C4D1Ev();
extern void _ZN8S21196C4D0Ev();
extern void ABISELECT(_ZThn16_N8S21196C4D1Ev,_ZThn12_N8S21196C4D1Ev)();
extern void ABISELECT(_ZThn16_N8S21196C4D0Ev,_ZThn12_N8S21196C4D0Ev)();
static  VTBL_ENTRY vtc_S21196C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C4[0]),
  (VTBL_ENTRY)&_ZN8S21196C4D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C4D0Ev,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S21196C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S21196C4D1Ev,_ZThn12_N8S21196C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S21196C4D0Ev,_ZThn12_N8S21196C4D0Ev),
};
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
Class_Descriptor cd_S21196C4 = {  "S21196C4", // class name
  bases_S21196C4, 4,
  &(vtc_S21196C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI8S21196C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S21196C4),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C7  {
  ::S21196C5 s21196c7f0;
  void  mf21196c7(); // _ZN8S21196C79mf21196c7Ev
};
//SIG(-1 S21196C7) C1{ m FC2{ BC3{ vd m FL} BC4{ BC3 vd FC3} vd FC4}}


void  S21196C7 ::mf21196c7(){}

static void Test_S21196C7()
{
  {
    init_simple_test("S21196C7");
    S21196C7 lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S21196C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C7)");
    check_field_offset(lv, s21196c7f0, 0, "S21196C7.s21196c7f0");
  }
}
static Arrange_To_Call_Me vS21196C7(Test_S21196C7, "S21196C7", ABISELECT(80,60));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S21196C7[];
VTBL_ENTRY *P__ZTI8S21196C7 = _ZTI8S21196C7; 
Class_Descriptor cd_S21196C7 = {  "S21196C7", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI8S21196C7),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C9  : S21196C7 , S21196C5 , S21196C6 , virtual S21196C2_nt {
  ~S21196C9(); // tgen
  S21196C9(); // tgen
};
//SIG(-1 S21196C9) C1{ BC2{ m FC3{ BC4{ vd m FL} BC5{ BC4 vd FC4} vd FC5}} BC3 BC5 VBC4}


S21196C9 ::~S21196C9(){ note_dtor("S21196C9", this);} // tgen
S21196C9 ::S21196C9(){ note_ctor("S21196C9", this);} // tgen

static void Test_S21196C9()
{
  extern Class_Descriptor cd_S21196C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(27,40)];
    init_test(&cd_S21196C9, buf);
    S21196C9 *dp, &lv = *(dp=new (buf) S21196C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,156), "sizeof(S21196C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C9)");
    check_base_class_offset(lv, (S21196C7*), ABISELECT(80,60), "S21196C9");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*), 0, "S21196C9");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*), ABISELECT(16,12), "S21196C9");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*), ABISELECT(16,12), "S21196C9");
    check_base_class_offset(lv, (S21196C5*), 0, "S21196C9");
    /*is_ambiguous_... S21196C9::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), ABISELECT(160,120), "S21196C9");
    /*is_ambiguous_... S21196C9::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*), ABISELECT(160,120), "S21196C9");
    /*is_ambiguous_... S21196C9::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*), ABISELECT(192,144), "S21196C9");
    test_class_info(&lv, &cd_S21196C9);
    dp->~S21196C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C9(Test_S21196C9, "S21196C9", ABISELECT(208,156));

#else // __cplusplus

extern void _ZN8S21196C9C1Ev();
extern void _ZN8S21196C9D1Ev();
Name_Map name_map_S21196C9[] = {
  NSPAIR(_ZN8S21196C9C1Ev),
  NSPAIR(_ZN8S21196C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
static Base_Class bases_S21196C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C7,    ABISELECT(80,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S21196C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C2_nt,    ABISELECT(160,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(160,120), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C2_nt,    ABISELECT(192,144), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S21196C9[];
extern void _ZN8S21196C9D1Ev();
extern void _ZN8S21196C9D0Ev();
extern void ABISELECT(_ZThn16_N8S21196C9D1Ev,_ZThn12_N8S21196C9D1Ev)();
extern void ABISELECT(_ZThn16_N8S21196C9D0Ev,_ZThn12_N8S21196C9D0Ev)();
extern void ABISELECT(_ZThn160_N8S21196C9D1Ev,_ZThn120_N8S21196C9D1Ev)();
extern void ABISELECT(_ZThn160_N8S21196C9D0Ev,_ZThn120_N8S21196C9D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev)();
extern void ABISELECT(_ZThn192_N8S21196C9D1Ev,_ZThn144_N8S21196C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev)();
extern void ABISELECT(_ZThn192_N8S21196C9D0Ev,_ZThn144_N8S21196C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S21196C9[] = {
  ABISELECT(192,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&_ZN8S21196C9D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C9D0Ev,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S21196C9D1Ev,_ZThn12_N8S21196C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S21196C9D0Ev,_ZThn12_N8S21196C9D0Ev),
  ABISELECT(-160,-120),
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S21196C9D1Ev,_ZThn120_N8S21196C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S21196C9D0Ev,_ZThn120_N8S21196C9D0Ev),
  ABISELECT(-192,-144),
  ABISELECT(-192,-144),
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev),
};
extern VTBL_ENTRY _ZTV8S21196C9[];
static  VTT_ENTRY vtt_S21196C9[] = {
  {&(_ZTV8S21196C9[3]),  3,18},
  {&(_ZTV8S21196C9[16]),  16,18},
};
extern VTBL_ENTRY _ZTI8S21196C9[];
extern  VTBL_ENTRY _ZTV8S21196C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C9[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N8S21196C9D0Ev,_ZThn144_N8S21196C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N8S21196C9D1Ev,_ZThn144_N8S21196C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21196C9 = {  "S21196C9", // class name
  bases_S21196C9, 8,
  &(vtc_S21196C9[0]), // expected_vtbl_contents
  &(vtt_S21196C9[0]), // expected_vtt_contents
  ABISELECT(208,156), // object size
  NSPAIRA(_ZTI8S21196C9),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S21196C9),18, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S21196C9),2, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C11  : S21196C6 {
  virtual  ~S21196C11(); // _ZN9S21196C11D1Ev
  S21196C11(); // tgen
};
//SIG(-1 S21196C11) C1{ BC2{ BC3{ vd m FL} vd FC3} vd}


 S21196C11 ::~S21196C11(){ note_dtor("S21196C11", this);}
S21196C11 ::S21196C11(){ note_ctor("S21196C11", this);} // tgen

static void Test_S21196C11()
{
  extern Class_Descriptor cd_S21196C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_S21196C11, buf);
    S21196C11 *dp, &lv = *(dp=new (buf) S21196C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S21196C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C11)");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), 0, "S21196C11");
    check_base_class_offset(lv, (S21196C6*), 0, "S21196C11");
    test_class_info(&lv, &cd_S21196C11);
    dp->~S21196C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C11(Test_S21196C11, "S21196C11", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN9S21196C11C1Ev();
extern void _ZN9S21196C11D1Ev();
Name_Map name_map_S21196C11[] = {
  NSPAIR(_ZN9S21196C11C1Ev),
  NSPAIR(_ZN9S21196C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
static Base_Class bases_S21196C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S21196C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21196C11[];
extern void _ZN9S21196C11D1Ev();
extern void _ZN9S21196C11D0Ev();
static  VTBL_ENTRY vtc_S21196C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C11[0]),
  (VTBL_ENTRY)&_ZN9S21196C11D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C11D0Ev,
};
extern VTBL_ENTRY _ZTI9S21196C11[];
extern  VTBL_ENTRY _ZTV9S21196C11[];
Class_Descriptor cd_S21196C11 = {  "S21196C11", // class name
  bases_S21196C11, 2,
  &(vtc_S21196C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI9S21196C11),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S21196C11),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C12  : virtual S21196C2_nt , virtual S21196C6 {
  ~S21196C12(); // tgen
  S21196C12(); // tgen
};
//SIG(-1 S21196C12) C1{ VBC2{ vd m FL} VBC3{ BC2 vd FC2}}


S21196C12 ::~S21196C12(){ note_dtor("S21196C12", this);} // tgen
S21196C12 ::S21196C12(){ note_ctor("S21196C12", this);} // tgen

static void Test_S21196C12()
{
  extern Class_Descriptor cd_S21196C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_S21196C12, buf);
    S21196C12 *dp, &lv = *(dp=new (buf) S21196C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(S21196C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C12)");
    /*is_ambiguous_... S21196C12::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*), ABISELECT(8,4), "S21196C12");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), ABISELECT(24,16), "S21196C12");
    check_base_class_offset(lv, (S21196C6*), ABISELECT(24,16), "S21196C12");
    test_class_info(&lv, &cd_S21196C12);
    dp->~S21196C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C12(Test_S21196C12, "S21196C12", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN9S21196C12C1Ev();
extern void _ZN9S21196C12D1Ev();
Name_Map name_map_S21196C12[] = {
  NSPAIR(_ZN9S21196C12C1Ev),
  NSPAIR(_ZN9S21196C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
static Base_Class bases_S21196C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(24,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S21196C12[];
extern void _ZN9S21196C12D1Ev();
extern void _ZN9S21196C12D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn8_N9S21196C12D1Ev,_ZThn4_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn8_N9S21196C12D0Ev,_ZThn4_N9S21196C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn24_N9S21196C12D1Ev,_ZThn16_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn24_N9S21196C12D0Ev,_ZThn16_N9S21196C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S21196C12[] = {
  ABISELECT(24,16),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&_ZN9S21196C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C12D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
extern VTBL_ENTRY _ZTV9S21196C12[];
static  VTT_ENTRY vtt_S21196C12[] = {
  {&(_ZTV9S21196C12[4]),  4,16},
  {&(_ZTV9S21196C12[9]),  9,16},
  {&(_ZTV9S21196C12[14]),  14,16},
};
extern VTBL_ENTRY _ZTI9S21196C12[];
extern  VTBL_ENTRY _ZTV9S21196C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C12[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S21196C12D0Ev,_ZThn16_N9S21196C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S21196C12D0Ev,_ZThn4_N9S21196C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S21196C12D1Ev,_ZThn16_N9S21196C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S21196C12D1Ev,_ZThn4_N9S21196C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21196C12 = {  "S21196C12", // class name
  bases_S21196C12, 3,
  &(vtc_S21196C12[0]), // expected_vtbl_contents
  &(vtt_S21196C12[0]), // expected_vtt_contents
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI9S21196C12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S21196C12),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21196C12),3, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C10  : virtual S21196C11 , virtual S21196C5 , virtual S21196C4 , virtual S21196C7 , S21196C12 {
  virtual  ~S21196C10(); // _ZN9S21196C10D2Ev
  S21196C10(); // tgen
};
//SIG(-1 S21196C10) C1{ VBC2{ BC3{ BC4{ vd m FL} vd FC4} vd} VBC5{ BC4 BC3 vd FC3} VBC6{ BC5} VBC7{ m FC5} BC8{ VBC4 VBC3} vd}


 S21196C10 ::~S21196C10(){ note_dtor("S21196C10", this);}
S21196C10 ::S21196C10(){ note_ctor("S21196C10", this);} // tgen

static void Test_S21196C10()
{
  extern Class_Descriptor cd_S21196C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,62)];
    init_test(&cd_S21196C10, buf);
    S21196C10 *dp, &lv = *(dp=new (buf) S21196C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,244), "sizeof(S21196C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C10)");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C11*), ABISELECT(8,4), "S21196C10");
    check_base_class_offset(lv, (S21196C6*)(S21196C11*), ABISELECT(8,4), "S21196C10");
    check_base_class_offset(lv, (S21196C11*), ABISELECT(8,4), "S21196C10");
    /*is_ambiguous_... S21196C10::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*), ABISELECT(40,28), "S21196C10");
    /*is_ambiguous_... S21196C10::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*), ABISELECT(56,40), "S21196C10");
    /*is_ambiguous_... S21196C10::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*), ABISELECT(56,40), "S21196C10");
    /*is_ambiguous_... S21196C10::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C5*), ABISELECT(40,28), "S21196C10");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*), ABISELECT(120,88), "S21196C10");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(136,100), "S21196C10");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(136,100), "S21196C10");
    check_base_class_offset(lv, (S21196C5*)(S21196C4*), ABISELECT(120,88), "S21196C10");
    check_base_class_offset(lv, (S21196C4*), ABISELECT(120,88), "S21196C10");
    check_base_class_offset(lv, (S21196C7*), ABISELECT(200,148), "S21196C10");
    /*is_ambiguous_... S21196C12::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C12*), ABISELECT(280,208), "S21196C10");
    /*is_ambiguous_... S21196C10::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), ABISELECT(296,220), "S21196C10");
    check_base_class_offset(lv, (S21196C6*)(S21196C12*), ABISELECT(296,220), "S21196C10");
    check_base_class_offset(lv, (S21196C12*), 0, "S21196C10");
    test_class_info(&lv, &cd_S21196C10);
    dp->~S21196C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C10(Test_S21196C10, "S21196C10", ABISELECT(328,244));

#else // __cplusplus

extern void _ZN9S21196C10C1Ev();
extern void _ZN9S21196C10D2Ev();
Name_Map name_map_S21196C10[] = {
  NSPAIR(_ZN9S21196C10C1Ev),
  NSPAIR(_ZN9S21196C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C11;
extern VTBL_ENTRY _ZTI9S21196C11[];
extern  VTBL_ENTRY _ZTV9S21196C11[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C12;
extern VTBL_ENTRY _ZTI9S21196C12[];
extern  VTBL_ENTRY _ZTV9S21196C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C12[];
static Base_Class bases_S21196C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S21196C11,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(56,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(56,40), //bcp->offset
    20, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(40,28), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    ABISELECT(120,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(136,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(136,100), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(120,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S21196C4,    ABISELECT(120,88), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C7,    ABISELECT(200,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    ABISELECT(280,208), //bcp->offset
    33, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(296,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(296,220), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S21196C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21196C10[];
extern void _ZN9S21196C10D1Ev();
extern void _ZN9S21196C10D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn8_N9S21196C10D1Ev,_ZThn4_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn8_N9S21196C10D0Ev,_ZThn4_N9S21196C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn40_N9S21196C10D1Ev,_ZThn28_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn40_N9S21196C10D0Ev,_ZThn28_N9S21196C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn120_N9S21196C10D1Ev,_ZThn88_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn120_N9S21196C10D0Ev,_ZThn88_N9S21196C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn280_N9S21196C10D1Ev,_ZThn208_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn280_N9S21196C10D0Ev,_ZThn208_N9S21196C10D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn296_N9S21196C10D1Ev,_ZThn220_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn296_N9S21196C10D0Ev,_ZThn220_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S21196C10[] = {
  ABISELECT(200,148),
  ABISELECT(120,88),
  ABISELECT(40,28),
  ABISELECT(8,4),
  ABISELECT(296,220),
  ABISELECT(280,208),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&_ZN9S21196C10D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C10D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
  ABISELECT(-56,-40),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev),
  ABISELECT(-120,-88),
  ABISELECT(-120,-88),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
  ABISELECT(-136,-100),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev),
  ABISELECT(-280,-208),
  ABISELECT(-280,-208),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
  ABISELECT(-296,-220),
  ABISELECT(-296,-220),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern VTBL_ENTRY _ZTV9S21196C10[];
extern void _ZN9S21196C12D1Ev();
extern void _ZN9S21196C12D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21196C12__9S21196C10[] = {
  ABISELECT(296,220),
  ABISELECT(280,208),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&_ZN9S21196C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn280_N9S21196C12D1Ev,_ZThn208_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn280_N9S21196C12D0Ev,_ZThn208_N9S21196C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__9S21196C12__9S21196C10[] = {
  ABISELECT(-280,-208),
  ABISELECT(-280,-208),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn296_N9S21196C12D1Ev,_ZThn220_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn296_N9S21196C12D0Ev,_ZThn220_N9S21196C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C6__9S21196C12__9S21196C10[] = {
  ABISELECT(-296,-220),
  ABISELECT(-296,-220),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
static  VTT_ENTRY vtt_S21196C10[] = {
  {&(_ZTV9S21196C10[8]),  8,43},
  {&(_tg__ZTV9S21196C12__9S21196C10[4]),  4,6},
  {&(_tg__ZTV11S21196C2_nt__9S21196C12__9S21196C10[3]),  3,5},
  {&(_tg__ZTV8S21196C6__9S21196C12__9S21196C10[3]),  3,5},
  {&(_ZTV9S21196C10[13]),  13,43},
  {&(_ZTV9S21196C10[18]),  18,43},
  {&(_ZTV9S21196C10[22]),  22,43},
  {&(_ZTV9S21196C10[27]),  27,43},
  {&(_ZTV9S21196C10[31]),  31,43},
  {&(_ZTV9S21196C10[36]),  36,43},
  {&(_ZTV9S21196C10[41]),  41,43},
};
extern VTBL_ENTRY _ZTI9S21196C10[];
extern  VTBL_ENTRY _ZTV9S21196C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C10[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn296_N9S21196C12D0Ev,_ZThn220_N9S21196C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn280_N9S21196C12D0Ev,_ZThn208_N9S21196C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn296_N9S21196C12D1Ev,_ZThn220_N9S21196C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn280_N9S21196C12D1Ev,_ZThn208_N9S21196C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn296_N9S21196C10D0Ev,_ZThn220_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn280_N9S21196C10D0Ev,_ZThn208_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S21196C10D0Ev,_ZThn88_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S21196C10D0Ev,_ZThn28_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S21196C10D0Ev,_ZThn4_N9S21196C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn296_N9S21196C10D1Ev,_ZThn220_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn280_N9S21196C10D1Ev,_ZThn208_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S21196C10D1Ev,_ZThn88_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N9S21196C10D1Ev,_ZThn28_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S21196C10D1Ev,_ZThn4_N9S21196C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21196C10 = {  "S21196C10", // class name
  bases_S21196C10, 17,
  &(vtc_S21196C10[0]), // expected_vtbl_contents
  &(vtt_S21196C10[0]), // expected_vtt_contents
  ABISELECT(328,244), // object size
  NSPAIRA(_ZTI9S21196C10),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S21196C10),43, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21196C10),11, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C8  : S21196C6 , virtual S21196C9 , S21196C2_nt , virtual S21196C7 , S21196C10 {
  int s21196c8f0;
  long s21196c8f1;
  virtual  ~S21196C8(); // _ZN8S21196C8D2Ev
  S21196C8(); // tgen
};
//SIG(-1 S21196C8) C1{ BC2{ BC3{ vd m FL} vd FC3} VBC4{ BC5{ m FC6{ BC3 BC2 vd FC2}} BC6 BC2 VBC3} BC3 VBC5 BC7{ VBC8{ BC2 vd} VBC6 VBC9{ BC6} VBC5 BC10{ VBC3 VBC2} vd} vd Fi Fl}


 S21196C8 ::~S21196C8(){ note_dtor("S21196C8", this);}
S21196C8 ::S21196C8(){ note_ctor("S21196C8", this);} // tgen

static void Test_S21196C8()
{
  extern Class_Descriptor cd_S21196C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(74,109)];
    init_test(&cd_S21196C8, buf);
    S21196C8 *dp, &lv = *(dp=new (buf) S21196C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(584,432), "sizeof(S21196C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C8)");
    /*is_ambiguous_... S21196C8::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), 0, "S21196C8");
    /*is_ambiguous_... S21196C8::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*), 0, "S21196C8");
    check_base_class_offset(lv, (S21196C7*)(S21196C9*), ABISELECT(152,108), "S21196C8");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C9*), ABISELECT(72,48), "S21196C8");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C9*), ABISELECT(88,60), "S21196C8");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C9*), ABISELECT(88,60), "S21196C8");
    check_base_class_offset(lv, (S21196C5*)(S21196C9*), ABISELECT(72,48), "S21196C8");
    /*is_ambiguous_... S21196C9::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C9*), ABISELECT(232,168), "S21196C8");
    /*is_ambiguous_... S21196C9::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C9*), ABISELECT(232,168), "S21196C8");
    /*is_ambiguous_... S21196C9::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C9*), ABISELECT(264,192), "S21196C8");
    /*is_ambiguous_... S21196C12::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C12*)(S21196C10*), ABISELECT(264,192), "S21196C8");
    check_base_class_offset(lv, (S21196C9*), ABISELECT(72,48), "S21196C8");
    /*is_ambiguous_... S21196C8::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*), ABISELECT(32,24), "S21196C8");
    /*is_ambiguous_... S21196C8::S21196C7 */ AMB_check_base_class_offset(lv, (S21196C7*), ABISELECT(280,204), "S21196C8");
    check_base_class_offset(lv, (S21196C7*)(S21196C10*), ABISELECT(280,204), "S21196C8");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C11*), ABISELECT(360,264), "S21196C8");
    check_base_class_offset(lv, (S21196C6*)(S21196C11*), ABISELECT(360,264), "S21196C8");
    check_base_class_offset(lv, (S21196C11*)(S21196C10*), ABISELECT(360,264), "S21196C8");
    /*is_ambiguous_... S21196C8::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*), ABISELECT(392,288), "S21196C8");
    /*is_ambiguous_... S21196C8::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*), ABISELECT(408,300), "S21196C8");
    /*is_ambiguous_... S21196C8::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*), ABISELECT(408,300), "S21196C8");
    /*is_ambiguous_... S21196C10::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C10*), ABISELECT(392,288), "S21196C8");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*), ABISELECT(472,348), "S21196C8");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(488,360), "S21196C8");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(488,360), "S21196C8");
    check_base_class_offset(lv, (S21196C5*)(S21196C4*), ABISELECT(472,348), "S21196C8");
    check_base_class_offset(lv, (S21196C4*)(S21196C10*), ABISELECT(472,348), "S21196C8");
    /*is_ambiguous_... S21196C8::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), ABISELECT(552,408), "S21196C8");
    check_base_class_offset(lv, (S21196C6*)(S21196C12*)(S21196C10*), ABISELECT(552,408), "S21196C8");
    check_base_class_offset(lv, (S21196C12*)(S21196C10*), ABISELECT(48,36), "S21196C8");
    check_base_class_offset(lv, (S21196C10*), ABISELECT(48,36), "S21196C8");
    check_field_offset(lv, s21196c8f0, ABISELECT(56,40), "S21196C8.s21196c8f0");
    check_field_offset(lv, s21196c8f1, ABISELECT(64,44), "S21196C8.s21196c8f1");
    test_class_info(&lv, &cd_S21196C8);
    dp->~S21196C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C8(Test_S21196C8, "S21196C8", ABISELECT(584,432));

#else // __cplusplus

extern void _ZN8S21196C8C1Ev();
extern void _ZN8S21196C8D2Ev();
Name_Map name_map_S21196C8[] = {
  NSPAIR(_ZN8S21196C8C1Ev),
  NSPAIR(_ZN8S21196C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C9;
extern VTBL_ENTRY _ZTI8S21196C9[];
extern  VTBL_ENTRY _ZTV8S21196C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C9[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C11;
extern VTBL_ENTRY _ZTI9S21196C11[];
extern  VTBL_ENTRY _ZTV9S21196C11[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C12;
extern VTBL_ENTRY _ZTI9S21196C12[];
extern  VTBL_ENTRY _ZTV9S21196C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C12[];
extern Class_Descriptor cd_S21196C10;
extern VTBL_ENTRY _ZTI9S21196C10[];
extern  VTBL_ENTRY _ZTV9S21196C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C10[];
static Base_Class bases_S21196C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S21196C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C7,    ABISELECT(152,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(72,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(88,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(88,60), //bcp->offset
    31, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(72,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(232,168), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(232,168), //bcp->offset
    35, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(264,192), //bcp->offset
    39, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S21196C9,    ABISELECT(72,48), //bcp->offset
    25, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    ABISELECT(32,24), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C7,    ABISELECT(280,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    ABISELECT(360,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(360,264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S21196C11,    ABISELECT(360,264), //bcp->offset
    44, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(392,288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(408,300), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(408,300), //bcp->offset
    54, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(392,288), //bcp->offset
    49, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(472,348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(488,360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(488,360), //bcp->offset
    63, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(472,348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S21196C4,    ABISELECT(472,348), //bcp->offset
    58, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(552,408), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(552,408), //bcp->offset
    67, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S21196C12,    ABISELECT(48,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S21196C10,    ABISELECT(48,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S21196C8[];
extern void _ZN8S21196C8D1Ev();
extern void _ZN8S21196C8D0Ev();
extern void ABISELECT(_ZThn32_N8S21196C8D1Ev,_ZThn24_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn32_N8S21196C8D0Ev,_ZThn24_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn48_N8S21196C8D1Ev,_ZThn36_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn48_N8S21196C8D0Ev,_ZThn36_N8S21196C8D0Ev)();
extern void ABISELECT(_ZTv0_n32_N8S21196C8D1Ev,_ZTv0_n16_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn72_N8S21196C8D1Ev,_ZThn48_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S21196C8D0Ev,_ZTv0_n16_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn72_N8S21196C8D0Ev,_ZThn48_N8S21196C8D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n32_N8S21196C8D1Ev,_ZTvn12_n16_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S21196C8D0Ev,_ZTvn12_n16_N8S21196C8D0Ev)();
extern void ABISELECT(_ZTvn160_n32_N8S21196C8D1Ev,_ZTvn120_n16_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn160_n32_N8S21196C8D0Ev,_ZTvn120_n16_N8S21196C8D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn264_N8S21196C8D1Ev,_ZThn192_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn264_N8S21196C8D0Ev,_ZThn192_N8S21196C8D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn360_N8S21196C8D1Ev,_ZThn264_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn360_N8S21196C8D0Ev,_ZThn264_N8S21196C8D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn392_N8S21196C8D1Ev,_ZThn288_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn392_N8S21196C8D0Ev,_ZThn288_N8S21196C8D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn472_N8S21196C8D1Ev,_ZThn348_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn472_N8S21196C8D0Ev,_ZThn348_N8S21196C8D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn552_N8S21196C8D1Ev,_ZThn408_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn552_N8S21196C8D0Ev,_ZThn408_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S21196C8[] = {
  ABISELECT(552,408),
  ABISELECT(472,348),
  ABISELECT(392,288),
  ABISELECT(360,264),
  ABISELECT(280,204),
  ABISELECT(264,192),
  ABISELECT(72,48),
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&_ZN8S21196C8D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C8D0Ev,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S21196C8D1Ev,_ZThn24_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N8S21196C8D0Ev,_ZThn24_N8S21196C8D0Ev),
  ABISELECT(232,168),
  ABISELECT(424,312),
  ABISELECT(344,252),
  ABISELECT(312,228),
  ABISELECT(504,372),
  ABISELECT(216,156),
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S21196C8D1Ev,_ZThn36_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S21196C8D0Ev,_ZThn36_N8S21196C8D0Ev),
  ABISELECT(-72,-48),
  ABISELECT(192,144),
  ABISELECT(-72,-48),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S21196C8D1Ev,_ZTv0_n16_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S21196C8D0Ev,_ZTv0_n16_N8S21196C8D0Ev),
  ABISELECT(-88,-60),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S21196C8D1Ev,_ZTvn12_n16_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S21196C8D0Ev,_ZTvn12_n16_N8S21196C8D0Ev),
  ABISELECT(-232,-168),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n32_N8S21196C8D1Ev,_ZTvn120_n16_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n32_N8S21196C8D0Ev,_ZTvn120_n16_N8S21196C8D0Ev),
  ABISELECT(-264,-192),
  ABISELECT(-264,-192),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
  ABISELECT(-360,-264),
  ABISELECT(-360,-264),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
  ABISELECT(-392,-288),
  ABISELECT(-392,-288),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
  ABISELECT(-408,-300),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev),
  ABISELECT(-472,-348),
  ABISELECT(-472,-348),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
  ABISELECT(-488,-360),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev),
  ABISELECT(-552,-408),
  ABISELECT(-552,-408),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern VTBL_ENTRY _ZTV8S21196C8[];
extern void _ZN9S21196C10D1Ev();
extern void _ZN9S21196C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21196C10__8S21196C8[] = {
  ABISELECT(232,168),
  ABISELECT(424,312),
  ABISELECT(344,252),
  ABISELECT(312,228),
  ABISELECT(504,372),
  ABISELECT(216,156),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&_ZN9S21196C10D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C10D0Ev,
};
extern void _ZN9S21196C12D1Ev();
extern void _ZN9S21196C12D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21196C129S21196C10__8S21196C8[] = {
  ABISELECT(504,372),
  ABISELECT(216,156),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&_ZN9S21196C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn216_N9S21196C12D1Ev,_ZThn156_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn216_N9S21196C12D0Ev,_ZThn156_N9S21196C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__9S21196C129S21196C10__8S21196C8[] = {
  ABISELECT(-216,-156),
  ABISELECT(-216,-156),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn504_N9S21196C12D1Ev,_ZThn372_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn504_N9S21196C12D0Ev,_ZThn372_N9S21196C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C6__9S21196C129S21196C10__8S21196C8[] = {
  ABISELECT(-504,-372),
  ABISELECT(-504,-372),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn312_N9S21196C10D1Ev,_ZThn228_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn312_N9S21196C10D0Ev,_ZThn228_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21196C11__9S21196C10__8S21196C8[] = {
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn344_N9S21196C10D1Ev,_ZThn252_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn344_N9S21196C10D0Ev,_ZThn252_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C5__9S21196C10__8S21196C8[] = {
  ABISELECT(-344,-252),
  ABISELECT(-344,-252),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C5__A1__9S21196C10__8S21196C8[] = {
  ABISELECT(-360,-264),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn424_N9S21196C10D1Ev,_ZThn312_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn424_N9S21196C10D0Ev,_ZThn312_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C4__9S21196C10__8S21196C8[] = {
  ABISELECT(-424,-312),
  ABISELECT(-424,-312),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C58S21196C4__A2__9S21196C10__8S21196C8[] = {
  ABISELECT(-440,-324),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn216_N9S21196C10D1Ev,_ZThn156_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn216_N9S21196C10D0Ev,_ZThn156_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__A5__9S21196C10__8S21196C8[] = {
  ABISELECT(-216,-156),
  ABISELECT(-216,-156),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn504_N9S21196C10D1Ev,_ZThn372_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn504_N9S21196C10D0Ev,_ZThn372_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C6__A3__9S21196C10__8S21196C8[] = {
  ABISELECT(-504,-372),
  ABISELECT(-504,-372),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void _ZN8S21196C9D1Ev();
extern void _ZN8S21196C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21196C9__8S21196C8[] = {
  ABISELECT(192,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&_ZN8S21196C9D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev)();
extern void ABISELECT(_ZThn192_N8S21196C9D1Ev,_ZThn144_N8S21196C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev)();
extern void ABISELECT(_ZThn192_N8S21196C9D0Ev,_ZThn144_N8S21196C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__A3__8S21196C9__8S21196C8[] = {
  ABISELECT(-192,-144),
  ABISELECT(-192,-144),
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev),
};
static  VTT_ENTRY vtt_S21196C8[] = {
  {&(_ZTV8S21196C8[9]),  9,72},
  {&(_tg__ZTV9S21196C10__8S21196C8[8]),  8,10},
  {&(_tg__ZTV9S21196C129S21196C10__8S21196C8[4]),  4,6},
  {&(_tg__ZTV11S21196C2_nt__9S21196C129S21196C10__8S21196C8[3]),  3,5},
  {&(_tg__ZTV8S21196C6__9S21196C129S21196C10__8S21196C8[3]),  3,5},
  {&(_tg__ZTV9S21196C11__9S21196C10__8S21196C8[3]),  3,5},
  {&(_tg__ZTV8S21196C5__9S21196C10__8S21196C8[3]),  3,5},
  {&(_tg__ZTV8S21196C68S21196C5__A1__9S21196C10__8S21196C8[2]),  2,4},
  {&(_tg__ZTV8S21196C4__9S21196C10__8S21196C8[3]),  3,5},
  {&(_tg__ZTV8S21196C68S21196C58S21196C4__A2__9S21196C10__8S21196C8[2]),  2,4},
  {&(_tg__ZTV11S21196C2_nt__A5__9S21196C10__8S21196C8[3]),  3,5},
  {&(_tg__ZTV8S21196C6__A3__9S21196C10__8S21196C8[3]),  3,5},
  {&(_ZTV8S21196C8[29]),  29,72},
  {&(_ZTV8S21196C8[33]),  33,72},
  {&(_ZTV8S21196C8[37]),  37,72},
  {&(_ZTV8S21196C8[42]),  42,72},
  {&(_ZTV8S21196C8[23]),  23,72},
  {&(_ZTV8S21196C8[47]),  47,72},
  {&(_ZTV8S21196C8[52]),  52,72},
  {&(_ZTV8S21196C8[56]),  56,72},
  {&(_ZTV8S21196C8[61]),  61,72},
  {&(_ZTV8S21196C8[65]),  65,72},
  {&(_ZTV8S21196C8[70]),  70,72},
  {&(_tg__ZTV8S21196C9__8S21196C8[3]),  3,5},
  {&(_tg__ZTV11S21196C2_nt__A3__8S21196C9__8S21196C8[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S21196C8[];
extern  VTBL_ENTRY _ZTV8S21196C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C8[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N8S21196C9D0Ev,_ZThn144_N8S21196C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N8S21196C9D1Ev,_ZThn144_N8S21196C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn504_N9S21196C10D0Ev,_ZThn372_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C10D0Ev,_ZThn156_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn424_N9S21196C10D0Ev,_ZThn312_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn344_N9S21196C10D0Ev,_ZThn252_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn312_N9S21196C10D0Ev,_ZThn228_N9S21196C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn504_N9S21196C10D1Ev,_ZThn372_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C10D1Ev,_ZThn156_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn424_N9S21196C10D1Ev,_ZThn312_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn344_N9S21196C10D1Ev,_ZThn252_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn312_N9S21196C10D1Ev,_ZThn228_N9S21196C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn504_N9S21196C12D0Ev,_ZThn372_N9S21196C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C12D0Ev,_ZThn156_N9S21196C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn504_N9S21196C12D1Ev,_ZThn372_N9S21196C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C12D1Ev,_ZThn156_N9S21196C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn552_N8S21196C8D0Ev,_ZThn408_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn472_N8S21196C8D0Ev,_ZThn348_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn392_N8S21196C8D0Ev,_ZThn288_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S21196C8D0Ev,_ZThn264_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S21196C8D0Ev,_ZThn192_N8S21196C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn552_N8S21196C8D1Ev,_ZThn408_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn472_N8S21196C8D1Ev,_ZThn348_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn392_N8S21196C8D1Ev,_ZThn288_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S21196C8D1Ev,_ZThn264_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S21196C8D1Ev,_ZThn192_N8S21196C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S21196C8D0Ev,_ZTv0_n16_N8S21196C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S21196C8D0Ev,_ZThn48_N8S21196C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S21196C8D1Ev,_ZTv0_n16_N8S21196C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S21196C8D1Ev,_ZThn48_N8S21196C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21196C8 = {  "S21196C8", // class name
  bases_S21196C8, 29,
  &(vtc_S21196C8[0]), // expected_vtbl_contents
  &(vtt_S21196C8[0]), // expected_vtt_contents
  ABISELECT(584,432), // object size
  NSPAIRA(_ZTI8S21196C8),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S21196C8),72, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S21196C8),25, //virtual table table var
  27, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C13  : S21196C4 , S21196C6 , S21196C2_nt {
  virtual  ~S21196C13(); // _ZN9S21196C13D1Ev
  S21196C13(); // tgen
};
//SIG(-1 S21196C13) C1{ BC2{ BC3{ BC4{ vd m FL} BC5{ BC4 vd FC4} vd FC5}} BC5 BC4 vd}


 S21196C13 ::~S21196C13(){ note_dtor("S21196C13", this);}
S21196C13 ::S21196C13(){ note_ctor("S21196C13", this);} // tgen

static void Test_S21196C13()
{
  extern Class_Descriptor cd_S21196C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,25)];
    init_test(&cd_S21196C13, buf);
    S21196C13 *dp, &lv = *(dp=new (buf) S21196C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,96), "sizeof(S21196C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C13)");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*), 0, "S21196C13");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(16,12), "S21196C13");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(16,12), "S21196C13");
    check_base_class_offset(lv, (S21196C5*)(S21196C4*), 0, "S21196C13");
    check_base_class_offset(lv, (S21196C4*), 0, "S21196C13");
    /*is_ambiguous_... S21196C13::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), ABISELECT(80,60), "S21196C13");
    /*is_ambiguous_... S21196C13::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*), ABISELECT(80,60), "S21196C13");
    /*is_ambiguous_... S21196C13::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*), ABISELECT(112,84), "S21196C13");
    test_class_info(&lv, &cd_S21196C13);
    dp->~S21196C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C13(Test_S21196C13, "S21196C13", ABISELECT(128,96));

#else // __cplusplus

extern void _ZN9S21196C13C1Ev();
extern void _ZN9S21196C13D1Ev();
Name_Map name_map_S21196C13[] = {
  NSPAIR(_ZN9S21196C13C1Ev),
  NSPAIR(_ZN9S21196C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
static Base_Class bases_S21196C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S21196C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C2_nt,    ABISELECT(80,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(80,60), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C2_nt,    ABISELECT(112,84), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21196C13[];
extern void _ZN9S21196C13D1Ev();
extern void _ZN9S21196C13D0Ev();
extern void ABISELECT(_ZThn16_N9S21196C13D1Ev,_ZThn12_N9S21196C13D1Ev)();
extern void ABISELECT(_ZThn16_N9S21196C13D0Ev,_ZThn12_N9S21196C13D0Ev)();
extern void ABISELECT(_ZThn80_N9S21196C13D1Ev,_ZThn60_N9S21196C13D1Ev)();
extern void ABISELECT(_ZThn80_N9S21196C13D0Ev,_ZThn60_N9S21196C13D0Ev)();
extern void ABISELECT(_ZThn112_N9S21196C13D1Ev,_ZThn84_N9S21196C13D1Ev)();
extern void ABISELECT(_ZThn112_N9S21196C13D0Ev,_ZThn84_N9S21196C13D0Ev)();
static  VTBL_ENTRY vtc_S21196C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C13[0]),
  (VTBL_ENTRY)&_ZN9S21196C13D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C13D0Ev,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S21196C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S21196C13D1Ev,_ZThn12_N9S21196C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S21196C13D0Ev,_ZThn12_N9S21196C13D0Ev),
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI9S21196C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N9S21196C13D1Ev,_ZThn60_N9S21196C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N9S21196C13D0Ev,_ZThn60_N9S21196C13D0Ev),
  ABISELECT(-112,-84),
  (VTBL_ENTRY)&(_ZTI9S21196C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21196C13D1Ev,_ZThn84_N9S21196C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S21196C13D0Ev,_ZThn84_N9S21196C13D0Ev),
};
extern VTBL_ENTRY _ZTI9S21196C13[];
extern  VTBL_ENTRY _ZTV9S21196C13[];
Class_Descriptor cd_S21196C13 = {  "S21196C13", // class name
  bases_S21196C13, 8,
  &(vtc_S21196C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,96), // object size
  NSPAIRA(_ZTI9S21196C13),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S21196C13),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  8, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C3  : S21196C4 , virtual S21196C7 , virtual S21196C8 , S21196C2_nt , virtual S21196C13 {
  virtual  ~S21196C3(); // _ZN8S21196C3D2Ev
  S21196C3(); // tgen
};
//SIG(-1 S21196C3) C1{ BC2{ BC3{ BC4{ vd m FL} BC5{ BC4 vd FC4} vd FC5}} VBC6{ m FC3} VBC7{ BC5 VBC8{ BC6 BC3 BC5 VBC4} BC4 VBC6 BC9{ VBC10{ BC5 vd} VBC3 VBC2 VBC6 BC11{ VBC4 VBC5} vd} vd Fi Fl} BC4 VBC12{ BC2 BC5 BC4 vd} vd}


 S21196C3 ::~S21196C3(){ note_dtor("S21196C3", this);}
S21196C3 ::S21196C3(){ note_ctor("S21196C3", this);} // tgen

static void Test_S21196C3()
{
  extern Class_Descriptor cd_S21196C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(102,151)];
    init_test(&cd_S21196C3, buf);
    S21196C3 *dp, &lv = *(dp=new (buf) S21196C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(808,600), "sizeof(S21196C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C3)");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*), 0, "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(16,12), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(16,12), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C4*), 0, "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C4*), 0, "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C7 */ AMB_check_base_class_offset(lv, (S21196C7*), ABISELECT(96,72), "S21196C3");
    /*is_ambiguous_... S21196C8::S21196C7 */ AMB_check_base_class_offset(lv, (S21196C7*)(S21196C8*), ABISELECT(96,72), "S21196C3");
    check_base_class_offset(lv, (S21196C7*)(S21196C10*)(S21196C8*), ABISELECT(96,72), "S21196C3");
    /*is_ambiguous_... S21196C8::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C8*), ABISELECT(176,132), "S21196C3");
    /*is_ambiguous_... S21196C8::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C8*), ABISELECT(176,132), "S21196C3");
    check_base_class_offset(lv, (S21196C7*)(S21196C9*), ABISELECT(328,240), "S21196C3");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C9*), ABISELECT(248,180), "S21196C3");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C9*), ABISELECT(264,192), "S21196C3");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C9*), ABISELECT(264,192), "S21196C3");
    check_base_class_offset(lv, (S21196C5*)(S21196C9*), ABISELECT(248,180), "S21196C3");
    /*is_ambiguous_... S21196C9::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C9*), ABISELECT(408,300), "S21196C3");
    /*is_ambiguous_... S21196C9::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C9*), ABISELECT(408,300), "S21196C3");
    /*is_ambiguous_... S21196C9::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C9*), ABISELECT(440,324), "S21196C3");
    /*is_ambiguous_... S21196C12::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C12*)(S21196C10*)(S21196C8*), ABISELECT(440,324), "S21196C3");
    check_base_class_offset(lv, (S21196C9*)(S21196C8*), ABISELECT(248,180), "S21196C3");
    /*is_ambiguous_... S21196C8::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C8*), ABISELECT(208,156), "S21196C3");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C11*), ABISELECT(456,336), "S21196C3");
    check_base_class_offset(lv, (S21196C6*)(S21196C11*), ABISELECT(456,336), "S21196C3");
    check_base_class_offset(lv, (S21196C11*)(S21196C10*)(S21196C8*), ABISELECT(456,336), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*), ABISELECT(488,360), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*), ABISELECT(504,372), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*), ABISELECT(504,372), "S21196C3");
    /*is_ambiguous_... S21196C10::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C10*)(S21196C8*), ABISELECT(488,360), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*), ABISELECT(568,420), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(584,432), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(584,432), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C4*), ABISELECT(568,420), "S21196C3");
    check_base_class_offset(lv, (S21196C4*)(S21196C10*)(S21196C8*), ABISELECT(568,420), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), ABISELECT(648,480), "S21196C3");
    check_base_class_offset(lv, (S21196C6*)(S21196C12*)(S21196C10*)(S21196C8*), ABISELECT(648,480), "S21196C3");
    check_base_class_offset(lv, (S21196C12*)(S21196C10*)(S21196C8*), ABISELECT(224,168), "S21196C3");
    check_base_class_offset(lv, (S21196C10*)(S21196C8*), ABISELECT(224,168), "S21196C3");
    check_base_class_offset(lv, (S21196C8*), ABISELECT(176,132), "S21196C3");
    /*is_ambiguous_... S21196C3::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*), ABISELECT(80,60), "S21196C3");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(680,504), "S21196C3");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(696,516), "S21196C3");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(696,516), "S21196C3");
    check_base_class_offset(lv, (S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(680,504), "S21196C3");
    check_base_class_offset(lv, (S21196C4*)(S21196C13*), ABISELECT(680,504), "S21196C3");
    /*is_ambiguous_... S21196C13::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C13*), ABISELECT(760,564), "S21196C3");
    /*is_ambiguous_... S21196C13::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C13*), ABISELECT(760,564), "S21196C3");
    /*is_ambiguous_... S21196C13::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C13*), ABISELECT(792,588), "S21196C3");
    check_base_class_offset(lv, (S21196C13*), ABISELECT(680,504), "S21196C3");
    test_class_info(&lv, &cd_S21196C3);
    dp->~S21196C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C3(Test_S21196C3, "S21196C3", ABISELECT(808,600));

#else // __cplusplus

extern void _ZN8S21196C3C1Ev();
extern void _ZN8S21196C3D2Ev();
Name_Map name_map_S21196C3[] = {
  NSPAIR(_ZN8S21196C3C1Ev),
  NSPAIR(_ZN8S21196C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C9;
extern VTBL_ENTRY _ZTI8S21196C9[];
extern  VTBL_ENTRY _ZTV8S21196C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C9[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C11;
extern VTBL_ENTRY _ZTI9S21196C11[];
extern  VTBL_ENTRY _ZTV9S21196C11[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C12;
extern VTBL_ENTRY _ZTI9S21196C12[];
extern  VTBL_ENTRY _ZTV9S21196C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C12[];
extern Class_Descriptor cd_S21196C10;
extern VTBL_ENTRY _ZTI9S21196C10[];
extern  VTBL_ENTRY _ZTV9S21196C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C10[];
extern Class_Descriptor cd_S21196C8;
extern VTBL_ENTRY _ZTI8S21196C8[];
extern  VTBL_ENTRY _ZTV8S21196C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C8[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C13;
extern VTBL_ENTRY _ZTI9S21196C13[];
extern  VTBL_ENTRY _ZTV9S21196C13[];
static Base_Class bases_S21196C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(16,12), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S21196C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C7,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    ABISELECT(176,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(176,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S21196C7,    ABISELECT(328,240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(248,180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(264,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(264,192), //bcp->offset
    53, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(248,180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(408,300), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(408,300), //bcp->offset
    57, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(440,324), //bcp->offset
    61, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S21196C9,    ABISELECT(248,180), //bcp->offset
    47, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    34, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(208,156), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(456,336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(456,336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S21196C11,    ABISELECT(456,336), //bcp->offset
    66, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(488,360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(504,372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(504,372), //bcp->offset
    76, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(488,360), //bcp->offset
    71, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(568,420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(584,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(584,432), //bcp->offset
    85, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(568,420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S21196C4,    ABISELECT(568,420), //bcp->offset
    80, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(648,480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(648,480), //bcp->offset
    89, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    32, //immediately_derived
  0, 1},
  {&cd_S21196C12,    ABISELECT(224,168), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S21196C10,    ABISELECT(224,168), //bcp->offset
    37, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S21196C8,    ABISELECT(176,132), //bcp->offset
    21, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    ABISELECT(80,60), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C2_nt,    ABISELECT(680,504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(696,516), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(696,516), //bcp->offset
    99, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(680,504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S21196C4,    ABISELECT(680,504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(760,564), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(760,564), //bcp->offset
    103, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(792,588), //bcp->offset
    107, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S21196C13,    ABISELECT(680,504), //bcp->offset
    94, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S21196C3[];
extern void _ZN8S21196C3D1Ev();
extern void _ZN8S21196C3D0Ev();
extern void ABISELECT(_ZThn16_N8S21196C3D1Ev,_ZThn12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZThn16_N8S21196C3D0Ev,_ZThn12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZThn80_N8S21196C3D1Ev,_ZThn60_N8S21196C3D1Ev)();
extern void ABISELECT(_ZThn80_N8S21196C3D0Ev,_ZThn60_N8S21196C3D0Ev)();
extern void ABISELECT(_ZTv0_n80_N8S21196C3D1Ev,_ZTv0_n40_N8S21196C3D1Ev)();
extern void ABISELECT(_ZThn176_N8S21196C3D1Ev,_ZThn132_N8S21196C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S21196C3D0Ev,_ZTv0_n40_N8S21196C3D0Ev)();
extern void ABISELECT(_ZThn176_N8S21196C3D0Ev,_ZThn132_N8S21196C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn32_n80_N8S21196C3D1Ev,_ZTvn24_n40_N8S21196C3D1Ev)();
extern void ABISELECT(_ZTvn32_n80_N8S21196C3D0Ev,_ZTvn24_n40_N8S21196C3D0Ev)();
extern void ABISELECT(_ZTvn48_n80_N8S21196C3D1Ev,_ZTvn36_n40_N8S21196C3D1Ev)();
extern void ABISELECT(_ZTvn48_n80_N8S21196C3D0Ev,_ZTvn36_n40_N8S21196C3D0Ev)();
extern void ABISELECT(_ZTv0_n32_N8S21196C3D1Ev,_ZTv0_n16_N8S21196C3D1Ev)();
extern void ABISELECT(_ZThn248_N8S21196C3D1Ev,_ZThn180_N8S21196C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S21196C3D0Ev,_ZTv0_n16_N8S21196C3D0Ev)();
extern void ABISELECT(_ZThn248_N8S21196C3D0Ev,_ZThn180_N8S21196C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n32_N8S21196C3D1Ev,_ZTvn12_n16_N8S21196C3D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S21196C3D0Ev,_ZTvn12_n16_N8S21196C3D0Ev)();
extern void ABISELECT(_ZTvn160_n32_N8S21196C3D1Ev,_ZTvn120_n16_N8S21196C3D1Ev)();
extern void ABISELECT(_ZTvn160_n32_N8S21196C3D0Ev,_ZTvn120_n16_N8S21196C3D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZThn440_N8S21196C3D1Ev,_ZThn324_N8S21196C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZThn440_N8S21196C3D0Ev,_ZThn324_N8S21196C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZThn456_N8S21196C3D1Ev,_ZThn336_N8S21196C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZThn456_N8S21196C3D0Ev,_ZThn336_N8S21196C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZThn488_N8S21196C3D1Ev,_ZThn360_N8S21196C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZThn488_N8S21196C3D0Ev,_ZThn360_N8S21196C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N8S21196C3D1Ev,_ZTvn12_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S21196C3D0Ev,_ZTvn12_n12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZThn568_N8S21196C3D1Ev,_ZThn420_N8S21196C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZThn568_N8S21196C3D0Ev,_ZThn420_N8S21196C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N8S21196C3D1Ev,_ZTvn12_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S21196C3D0Ev,_ZTvn12_n12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZThn648_N8S21196C3D1Ev,_ZThn480_N8S21196C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZThn648_N8S21196C3D0Ev,_ZThn480_N8S21196C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZThn680_N8S21196C3D1Ev,_ZThn504_N8S21196C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZThn680_N8S21196C3D0Ev,_ZThn504_N8S21196C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N8S21196C3D1Ev,_ZTvn12_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S21196C3D0Ev,_ZTvn12_n12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZTvn80_n24_N8S21196C3D1Ev,_ZTvn60_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZTvn80_n24_N8S21196C3D0Ev,_ZTvn60_n12_N8S21196C3D0Ev)();
extern void ABISELECT(_ZTvn112_n24_N8S21196C3D1Ev,_ZTvn84_n12_N8S21196C3D1Ev)();
extern void ABISELECT(_ZTvn112_n24_N8S21196C3D0Ev,_ZTvn84_n12_N8S21196C3D0Ev)();
static  VTBL_ENTRY vtc_S21196C3[] = {
  ABISELECT(680,504),
  ABISELECT(648,480),
  ABISELECT(568,420),
  ABISELECT(488,360),
  ABISELECT(456,336),
  ABISELECT(440,324),
  ABISELECT(248,180),
  ABISELECT(176,132),
  ABISELECT(96,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&_ZN8S21196C3D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C3D0Ev,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S21196C3D1Ev,_ZThn12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S21196C3D0Ev,_ZThn12_N8S21196C3D0Ev),
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N8S21196C3D1Ev,_ZThn60_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N8S21196C3D0Ev,_ZThn60_N8S21196C3D0Ev),
  ABISELECT(-176,-132),
  ABISELECT(472,348),
  ABISELECT(392,288),
  ABISELECT(312,228),
  ABISELECT(280,204),
  ABISELECT(-80,-60),
  ABISELECT(264,192),
  ABISELECT(72,48),
  ABISELECT(-176,-132),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S21196C3D1Ev,_ZTv0_n40_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S21196C3D0Ev,_ZTv0_n40_N8S21196C3D0Ev),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n80_N8S21196C3D1Ev,_ZTvn24_n40_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n80_N8S21196C3D0Ev,_ZTvn24_n40_N8S21196C3D0Ev),
  ABISELECT(-128,-96),
  ABISELECT(344,252),
  ABISELECT(264,192),
  ABISELECT(232,168),
  ABISELECT(424,312),
  ABISELECT(216,156),
  ABISELECT(-224,-168),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n80_N8S21196C3D1Ev,_ZTvn36_n40_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n80_N8S21196C3D0Ev,_ZTvn36_n40_N8S21196C3D0Ev),
  ABISELECT(-248,-180),
  ABISELECT(192,144),
  ABISELECT(-248,-180),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S21196C3D1Ev,_ZTv0_n16_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S21196C3D0Ev,_ZTv0_n16_N8S21196C3D0Ev),
  ABISELECT(-264,-192),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S21196C3D1Ev,_ZTvn12_n16_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S21196C3D0Ev,_ZTvn12_n16_N8S21196C3D0Ev),
  ABISELECT(-408,-300),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n32_N8S21196C3D1Ev,_ZTvn120_n16_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n32_N8S21196C3D0Ev,_ZTvn120_n16_N8S21196C3D0Ev),
  ABISELECT(-440,-324),
  ABISELECT(-440,-324),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev),
  ABISELECT(-456,-336),
  ABISELECT(-456,-336),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev),
  ABISELECT(-488,-360),
  ABISELECT(-488,-360),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev),
  ABISELECT(-504,-372),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C3D1Ev,_ZTvn12_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C3D0Ev,_ZTvn12_n12_N8S21196C3D0Ev),
  ABISELECT(-568,-420),
  ABISELECT(-568,-420),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev),
  ABISELECT(-584,-432),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C3D1Ev,_ZTvn12_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C3D0Ev,_ZTvn12_n12_N8S21196C3D0Ev),
  ABISELECT(-648,-480),
  ABISELECT(-648,-480),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev),
  ABISELECT(-680,-504),
  ABISELECT(-680,-504),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev),
  ABISELECT(-696,-516),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C3D1Ev,_ZTvn12_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C3D0Ev,_ZTvn12_n12_N8S21196C3D0Ev),
  ABISELECT(-760,-564),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn80_n24_N8S21196C3D1Ev,_ZTvn60_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn80_n24_N8S21196C3D0Ev,_ZTvn60_n12_N8S21196C3D0Ev),
  ABISELECT(-792,-588),
  (VTBL_ENTRY)&(_ZTI8S21196C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n24_N8S21196C3D1Ev,_ZTvn84_n12_N8S21196C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n24_N8S21196C3D0Ev,_ZTvn84_n12_N8S21196C3D0Ev),
};
extern VTBL_ENTRY _ZTV8S21196C3[];
extern void _ZN8S21196C8D1Ev();
extern void _ZN8S21196C8D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21196C8__8S21196C3[] = {
  ABISELECT(472,348),
  ABISELECT(392,288),
  ABISELECT(312,228),
  ABISELECT(280,204),
  ABISELECT(-80,-60),
  ABISELECT(264,192),
  ABISELECT(72,48),
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&_ZN8S21196C8D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C8D0Ev,
};
extern void _ZN9S21196C10D1Ev();
extern void _ZN9S21196C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(-128,-96),
  ABISELECT(344,252),
  ABISELECT(264,192),
  ABISELECT(232,168),
  ABISELECT(424,312),
  ABISELECT(216,156),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&_ZN9S21196C10D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C10D0Ev,
};
extern void _ZN9S21196C12D1Ev();
extern void _ZN9S21196C12D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21196C129S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(424,312),
  ABISELECT(216,156),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&_ZN9S21196C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn216_N9S21196C12D1Ev,_ZThn156_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn216_N9S21196C12D0Ev,_ZThn156_N9S21196C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__9S21196C129S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(-216,-156),
  ABISELECT(-216,-156),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn424_N9S21196C12D1Ev,_ZThn312_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn424_N9S21196C12D0Ev,_ZThn312_N9S21196C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C6__9S21196C129S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(-424,-312),
  ABISELECT(-424,-312),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn232_N9S21196C10D1Ev,_ZThn168_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn232_N9S21196C10D0Ev,_ZThn168_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21196C11__9S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(-232,-168),
  ABISELECT(-232,-168),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn264_N9S21196C10D1Ev,_ZThn192_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn264_N9S21196C10D0Ev,_ZThn192_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C5__9S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(-264,-192),
  ABISELECT(-264,-192),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C5__A1__9S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(-280,-204),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn344_N9S21196C10D1Ev,_ZThn252_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn344_N9S21196C10D0Ev,_ZThn252_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C4__9S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(-344,-252),
  ABISELECT(-344,-252),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C58S21196C4__A2__9S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(-360,-264),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn216_N9S21196C10D1Ev,_ZThn156_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn216_N9S21196C10D0Ev,_ZThn156_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__A5__9S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(-216,-156),
  ABISELECT(-216,-156),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn424_N9S21196C10D1Ev,_ZThn312_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn424_N9S21196C10D0Ev,_ZThn312_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C6__A3__9S21196C108S21196C8__8S21196C3[] = {
  ABISELECT(-424,-312),
  ABISELECT(-424,-312),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S21196C8D1Ev,_ZTv0_n16_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn72_N8S21196C8D1Ev,_ZThn48_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S21196C8D0Ev,_ZTv0_n16_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn72_N8S21196C8D0Ev,_ZThn48_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C9__8S21196C8__8S21196C3[] = {
  ABISELECT(-72,-48),
  ABISELECT(192,144),
  ABISELECT(-72,-48),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S21196C8D1Ev,_ZTv0_n16_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S21196C8D0Ev,_ZTv0_n16_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTvn16_n32_N8S21196C8D1Ev,_ZTvn12_n16_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S21196C8D0Ev,_ZTvn12_n16_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C58S21196C9__A1__8S21196C8__8S21196C3[] = {
  ABISELECT(-88,-60),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S21196C8D1Ev,_ZTvn12_n16_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S21196C8D0Ev,_ZTvn12_n16_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTvn160_n32_N8S21196C8D1Ev,_ZTvn120_n16_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn160_n32_N8S21196C8D0Ev,_ZTvn120_n16_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C9__A2__8S21196C8__8S21196C3[] = {
  ABISELECT(-232,-168),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n32_N8S21196C8D1Ev,_ZTvn120_n16_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n32_N8S21196C8D0Ev,_ZTvn120_n16_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn264_N8S21196C8D1Ev,_ZThn192_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn264_N8S21196C8D0Ev,_ZThn192_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__A4__8S21196C8__8S21196C3[] = {
  ABISELECT(-264,-192),
  ABISELECT(-264,-192),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZThn48_N8S21196C8D1Ev,_ZThn36_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn48_N8S21196C8D0Ev,_ZThn36_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21196C10__8S21196C8__8S21196C3[] = {
  ABISELECT(-128,-96),
  ABISELECT(344,252),
  ABISELECT(264,192),
  ABISELECT(232,168),
  ABISELECT(424,312),
  ABISELECT(216,156),
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S21196C8D1Ev,_ZThn36_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S21196C8D0Ev,_ZThn36_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn280_N8S21196C8D1Ev,_ZThn204_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn280_N8S21196C8D0Ev,_ZThn204_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21196C11__8S21196C8__8S21196C3[] = {
  ABISELECT(-280,-204),
  ABISELECT(-280,-204),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn312_N8S21196C8D1Ev,_ZThn228_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn312_N8S21196C8D0Ev,_ZThn228_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C5__A1__8S21196C8__8S21196C3[] = {
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C5__A4__8S21196C8__8S21196C3[] = {
  ABISELECT(-328,-240),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn392_N8S21196C8D1Ev,_ZThn288_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn392_N8S21196C8D0Ev,_ZThn288_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C4__8S21196C8__8S21196C3[] = {
  ABISELECT(-392,-288),
  ABISELECT(-392,-288),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C58S21196C4__A5__8S21196C8__8S21196C3[] = {
  ABISELECT(-408,-300),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn472_N8S21196C8D1Ev,_ZThn348_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn472_N8S21196C8D0Ev,_ZThn348_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C6__A6__8S21196C8__8S21196C3[] = {
  ABISELECT(-472,-348),
  ABISELECT(-472,-348),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern void _ZN8S21196C9D1Ev();
extern void _ZN8S21196C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21196C9__8S21196C3[] = {
  ABISELECT(192,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&_ZN8S21196C9D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev)();
extern void ABISELECT(_ZThn192_N8S21196C9D1Ev,_ZThn144_N8S21196C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev)();
extern void ABISELECT(_ZThn192_N8S21196C9D0Ev,_ZThn144_N8S21196C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__A3__8S21196C9__8S21196C3[] = {
  ABISELECT(-192,-144),
  ABISELECT(-192,-144),
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev),
};
static  VTT_ENTRY vtt_S21196C3[] = {
  {&(_ZTV8S21196C3[11]),  11,111},
  {&(_ZTV8S21196C3[31]),  31,111},
  {&(_ZTV8S21196C3[51]),  51,111},
  {&(_ZTV8S21196C3[55]),  55,111},
  {&(_ZTV8S21196C3[59]),  59,111},
  {&(_ZTV8S21196C3[64]),  64,111},
  {&(_ZTV8S21196C3[35]),  35,111},
  {&(_ZTV8S21196C3[45]),  45,111},
  {&(_ZTV8S21196C3[69]),  69,111},
  {&(_ZTV8S21196C3[74]),  74,111},
  {&(_ZTV8S21196C3[78]),  78,111},
  {&(_ZTV8S21196C3[83]),  83,111},
  {&(_ZTV8S21196C3[87]),  87,111},
  {&(_ZTV8S21196C3[92]),  92,111},
  {&(_ZTV8S21196C3[97]),  97,111},
  {&(_ZTV8S21196C3[101]),  101,111},
  {&(_ZTV8S21196C3[105]),  105,111},
  {&(_ZTV8S21196C3[109]),  109,111},
  {&(_tg__ZTV8S21196C8__8S21196C3[9]),  9,11},
  {&(_tg__ZTV9S21196C108S21196C8__8S21196C3[8]),  8,10},
  {&(_tg__ZTV9S21196C129S21196C108S21196C8__8S21196C3[4]),  4,6},
  {&(_tg__ZTV11S21196C2_nt__9S21196C129S21196C108S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV8S21196C6__9S21196C129S21196C108S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV9S21196C11__9S21196C108S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV8S21196C5__9S21196C108S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV8S21196C68S21196C5__A1__9S21196C108S21196C8__8S21196C3[2]),  2,4},
  {&(_tg__ZTV8S21196C4__9S21196C108S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV8S21196C68S21196C58S21196C4__A2__9S21196C108S21196C8__8S21196C3[2]),  2,4},
  {&(_tg__ZTV11S21196C2_nt__A5__9S21196C108S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV8S21196C6__A3__9S21196C108S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV8S21196C9__8S21196C8__8S21196C3[4]),  4,6},
  {&(_tg__ZTV8S21196C68S21196C58S21196C9__A1__8S21196C8__8S21196C3[2]),  2,4},
  {&(_tg__ZTV8S21196C68S21196C9__A2__8S21196C8__8S21196C3[2]),  2,4},
  {&(_tg__ZTV11S21196C2_nt__A4__8S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV9S21196C10__8S21196C8__8S21196C3[8]),  8,10},
  {&(_tg__ZTV9S21196C11__8S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV8S21196C5__A1__8S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV8S21196C68S21196C5__A4__8S21196C8__8S21196C3[2]),  2,4},
  {&(_tg__ZTV8S21196C4__8S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV8S21196C68S21196C58S21196C4__A5__8S21196C8__8S21196C3[2]),  2,4},
  {&(_tg__ZTV8S21196C6__A6__8S21196C8__8S21196C3[3]),  3,5},
  {&(_tg__ZTV8S21196C9__8S21196C3[3]),  3,5},
  {&(_tg__ZTV11S21196C2_nt__A3__8S21196C9__8S21196C3[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S21196C3[];
extern  VTBL_ENTRY _ZTV8S21196C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C3[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N8S21196C9D0Ev,_ZThn144_N8S21196C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N8S21196C9D1Ev,_ZThn144_N8S21196C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn472_N8S21196C8D0Ev,_ZThn348_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn392_N8S21196C8D0Ev,_ZThn288_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S21196C8D0Ev,_ZThn228_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn280_N8S21196C8D0Ev,_ZThn204_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S21196C8D0Ev,_ZThn192_N8S21196C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn472_N8S21196C8D1Ev,_ZThn348_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn392_N8S21196C8D1Ev,_ZThn288_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn312_N8S21196C8D1Ev,_ZThn228_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn280_N8S21196C8D1Ev,_ZThn204_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S21196C8D1Ev,_ZThn192_N8S21196C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S21196C8D0Ev,_ZTv0_n16_N8S21196C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S21196C8D0Ev,_ZThn48_N8S21196C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S21196C8D1Ev,_ZTv0_n16_N8S21196C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S21196C8D1Ev,_ZThn48_N8S21196C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn424_N9S21196C10D0Ev,_ZThn312_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C10D0Ev,_ZThn156_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn344_N9S21196C10D0Ev,_ZThn252_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N9S21196C10D0Ev,_ZThn192_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn232_N9S21196C10D0Ev,_ZThn168_N9S21196C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn424_N9S21196C10D1Ev,_ZThn312_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C10D1Ev,_ZThn156_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn344_N9S21196C10D1Ev,_ZThn252_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N9S21196C10D1Ev,_ZThn192_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn232_N9S21196C10D1Ev,_ZThn168_N9S21196C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn424_N9S21196C12D0Ev,_ZThn312_N9S21196C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C12D0Ev,_ZThn156_N9S21196C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn424_N9S21196C12D1Ev,_ZThn312_N9S21196C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C12D1Ev,_ZThn156_N9S21196C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C3D0Ev,_ZTv0_n12_N8S21196C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn680_N8S21196C3D0Ev,_ZThn504_N8S21196C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn648_N8S21196C3D0Ev,_ZThn480_N8S21196C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn568_N8S21196C3D0Ev,_ZThn420_N8S21196C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn488_N8S21196C3D0Ev,_ZThn360_N8S21196C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn456_N8S21196C3D0Ev,_ZThn336_N8S21196C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn440_N8S21196C3D0Ev,_ZThn324_N8S21196C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C3D1Ev,_ZTv0_n12_N8S21196C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn680_N8S21196C3D1Ev,_ZThn504_N8S21196C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn648_N8S21196C3D1Ev,_ZThn480_N8S21196C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn568_N8S21196C3D1Ev,_ZThn420_N8S21196C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn488_N8S21196C3D1Ev,_ZThn360_N8S21196C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn456_N8S21196C3D1Ev,_ZThn336_N8S21196C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn440_N8S21196C3D1Ev,_ZThn324_N8S21196C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S21196C3D0Ev,_ZTv0_n16_N8S21196C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn248_N8S21196C3D0Ev,_ZThn180_N8S21196C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S21196C3D1Ev,_ZTv0_n16_N8S21196C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn248_N8S21196C3D1Ev,_ZThn180_N8S21196C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S21196C3D0Ev,_ZTv0_n40_N8S21196C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S21196C3D0Ev,_ZThn132_N8S21196C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S21196C3D1Ev,_ZTv0_n40_N8S21196C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S21196C3D1Ev,_ZThn132_N8S21196C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21196C3 = {  "S21196C3", // class name
  bases_S21196C3, 45,
  &(vtc_S21196C3[0]), // expected_vtbl_contents
  &(vtt_S21196C3[0]), // expected_vtt_contents
  ABISELECT(808,600), // object size
  NSPAIRA(_ZTI8S21196C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S21196C3),111, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S21196C3),43, //virtual table table var
  43, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C15  : virtual S21196C4 , S21196C6 , virtual S21196C12 , virtual S21196C13 {
  ~S21196C15(); // tgen
  S21196C15(); // tgen
};
//SIG(-1 S21196C15) C1{ VBC2{ BC3{ BC4{ vd m FL} BC5{ BC4 vd FC4} vd FC5}} BC5 VBC6{ VBC4 VBC5} VBC7{ BC2 BC5 BC4 vd}}


S21196C15 ::~S21196C15(){ note_dtor("S21196C15", this);} // tgen
S21196C15 ::S21196C15(){ note_ctor("S21196C15", this);} // tgen

static void Test_S21196C15()
{
  extern Class_Descriptor cd_S21196C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S21196C15, buf);
    S21196C15 *dp, &lv = *(dp=new (buf) S21196C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S21196C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C15)");
    /*is_ambiguous_... S21196C15::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*), ABISELECT(32,24), "S21196C15");
    /*is_ambiguous_... S21196C15::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(48,36), "S21196C15");
    /*is_ambiguous_... S21196C15::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(48,36), "S21196C15");
    /*is_ambiguous_... S21196C15::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C4*), ABISELECT(32,24), "S21196C15");
    /*is_ambiguous_... S21196C15::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C4*), ABISELECT(32,24), "S21196C15");
    /*is_ambiguous_... S21196C15::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), 0, "S21196C15");
    /*is_ambiguous_... S21196C15::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*), 0, "S21196C15");
    /*is_ambiguous_... S21196C12::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C12*), ABISELECT(120,88), "S21196C15");
    /*is_ambiguous_... S21196C15::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), ABISELECT(136,100), "S21196C15");
    check_base_class_offset(lv, (S21196C6*)(S21196C12*), ABISELECT(136,100), "S21196C15");
    check_base_class_offset(lv, (S21196C12*), ABISELECT(112,84), "S21196C15");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(168,124), "S21196C15");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(184,136), "S21196C15");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(184,136), "S21196C15");
    check_base_class_offset(lv, (S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(168,124), "S21196C15");
    check_base_class_offset(lv, (S21196C4*)(S21196C13*), ABISELECT(168,124), "S21196C15");
    /*is_ambiguous_... S21196C13::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C13*), ABISELECT(248,184), "S21196C15");
    /*is_ambiguous_... S21196C13::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C13*), ABISELECT(248,184), "S21196C15");
    /*is_ambiguous_... S21196C13::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C13*), ABISELECT(280,208), "S21196C15");
    check_base_class_offset(lv, (S21196C13*), ABISELECT(168,124), "S21196C15");
    test_class_info(&lv, &cd_S21196C15);
    dp->~S21196C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C15(Test_S21196C15, "S21196C15", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN9S21196C15C1Ev();
extern void _ZN9S21196C15D1Ev();
Name_Map name_map_S21196C15[] = {
  NSPAIR(_ZN9S21196C15C1Ev),
  NSPAIR(_ZN9S21196C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C12;
extern VTBL_ENTRY _ZTI9S21196C12[];
extern  VTBL_ENTRY _ZTV9S21196C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C12[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C13;
extern VTBL_ENTRY _ZTI9S21196C13[];
extern  VTBL_ENTRY _ZTV9S21196C13[];
static Base_Class bases_S21196C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(48,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(48,36), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S21196C4,    ABISELECT(32,24), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S21196C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C2_nt,    ABISELECT(120,88), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(136,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(136,100), //bcp->offset
    30, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S21196C12,    ABISELECT(112,84), //bcp->offset
    18, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    ABISELECT(168,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(184,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(184,136), //bcp->offset
    40, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(168,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S21196C4,    ABISELECT(168,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(248,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(248,184), //bcp->offset
    44, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(280,208), //bcp->offset
    48, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S21196C13,    ABISELECT(168,124), //bcp->offset
    35, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S21196C15[];
extern void _ZN9S21196C15D1Ev();
extern void _ZN9S21196C15D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S21196C15D1Ev,_ZTv0_n12_N9S21196C15D1Ev)();
extern void ABISELECT(_ZThn32_N9S21196C15D1Ev,_ZThn24_N9S21196C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C15D0Ev,_ZTv0_n12_N9S21196C15D0Ev)();
extern void ABISELECT(_ZThn32_N9S21196C15D0Ev,_ZThn24_N9S21196C15D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N9S21196C15D1Ev,_ZTvn12_n12_N9S21196C15D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C15D0Ev,_ZTvn12_n12_N9S21196C15D0Ev)();
extern void ABISELECT(_ZTv0_n40_N9S21196C15D1Ev,_ZTv0_n20_N9S21196C15D1Ev)();
extern void ABISELECT(_ZThn112_N9S21196C15D1Ev,_ZThn84_N9S21196C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S21196C15D0Ev,_ZTv0_n20_N9S21196C15D0Ev)();
extern void ABISELECT(_ZThn112_N9S21196C15D0Ev,_ZThn84_N9S21196C15D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C15D1Ev,_ZTv0_n12_N9S21196C15D1Ev)();
extern void ABISELECT(_ZThn120_N9S21196C15D1Ev,_ZThn88_N9S21196C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C15D0Ev,_ZTv0_n12_N9S21196C15D0Ev)();
extern void ABISELECT(_ZThn120_N9S21196C15D0Ev,_ZThn88_N9S21196C15D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C15D1Ev,_ZTv0_n12_N9S21196C15D1Ev)();
extern void ABISELECT(_ZThn136_N9S21196C15D1Ev,_ZThn100_N9S21196C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C15D0Ev,_ZTv0_n12_N9S21196C15D0Ev)();
extern void ABISELECT(_ZThn136_N9S21196C15D0Ev,_ZThn100_N9S21196C15D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C15D1Ev,_ZTv0_n12_N9S21196C15D1Ev)();
extern void ABISELECT(_ZThn168_N9S21196C15D1Ev,_ZThn124_N9S21196C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C15D0Ev,_ZTv0_n12_N9S21196C15D0Ev)();
extern void ABISELECT(_ZThn168_N9S21196C15D0Ev,_ZThn124_N9S21196C15D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N9S21196C15D1Ev,_ZTvn12_n12_N9S21196C15D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C15D0Ev,_ZTvn12_n12_N9S21196C15D0Ev)();
extern void ABISELECT(_ZTvn80_n24_N9S21196C15D1Ev,_ZTvn60_n12_N9S21196C15D1Ev)();
extern void ABISELECT(_ZTvn80_n24_N9S21196C15D0Ev,_ZTvn60_n12_N9S21196C15D0Ev)();
extern void ABISELECT(_ZTvn112_n24_N9S21196C15D1Ev,_ZTvn84_n12_N9S21196C15D1Ev)();
extern void ABISELECT(_ZTvn112_n24_N9S21196C15D0Ev,_ZTvn84_n12_N9S21196C15D0Ev)();
static  VTBL_ENTRY vtc_S21196C15[] = {
  ABISELECT(168,124),
  ABISELECT(136,100),
  ABISELECT(120,88),
  ABISELECT(112,84),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C15[0]),
  (VTBL_ENTRY)&_ZN9S21196C15D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C15D0Ev,
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI9S21196C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C15D1Ev,_ZTv0_n12_N9S21196C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C15D0Ev,_ZTv0_n12_N9S21196C15D0Ev),
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI9S21196C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C15D1Ev,_ZTvn12_n12_N9S21196C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C15D0Ev,_ZTvn12_n12_N9S21196C15D0Ev),
  ABISELECT(-112,-84),
  ABISELECT(24,16),
  ABISELECT(8,4),
  ABISELECT(-112,-84),
  (VTBL_ENTRY)&(_ZTI9S21196C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S21196C15D1Ev,_ZTv0_n20_N9S21196C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S21196C15D0Ev,_ZTv0_n20_N9S21196C15D0Ev),
  ABISELECT(-120,-88),
  ABISELECT(-120,-88),
  (VTBL_ENTRY)&(_ZTI9S21196C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C15D1Ev,_ZTv0_n12_N9S21196C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C15D0Ev,_ZTv0_n12_N9S21196C15D0Ev),
  ABISELECT(-136,-100),
  ABISELECT(-136,-100),
  (VTBL_ENTRY)&(_ZTI9S21196C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C15D1Ev,_ZTv0_n12_N9S21196C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C15D0Ev,_ZTv0_n12_N9S21196C15D0Ev),
  ABISELECT(-168,-124),
  ABISELECT(-168,-124),
  (VTBL_ENTRY)&(_ZTI9S21196C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C15D1Ev,_ZTv0_n12_N9S21196C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C15D0Ev,_ZTv0_n12_N9S21196C15D0Ev),
  ABISELECT(-184,-136),
  (VTBL_ENTRY)&(_ZTI9S21196C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C15D1Ev,_ZTvn12_n12_N9S21196C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C15D0Ev,_ZTvn12_n12_N9S21196C15D0Ev),
  ABISELECT(-248,-184),
  (VTBL_ENTRY)&(_ZTI9S21196C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn80_n24_N9S21196C15D1Ev,_ZTvn60_n12_N9S21196C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn80_n24_N9S21196C15D0Ev,_ZTvn60_n12_N9S21196C15D0Ev),
  ABISELECT(-280,-208),
  (VTBL_ENTRY)&(_ZTI9S21196C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n24_N9S21196C15D1Ev,_ZTvn84_n12_N9S21196C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n24_N9S21196C15D0Ev,_ZTvn84_n12_N9S21196C15D0Ev),
};
extern VTBL_ENTRY _ZTV9S21196C15[];
extern void _ZN9S21196C12D1Ev();
extern void _ZN9S21196C12D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21196C12__9S21196C15[] = {
  ABISELECT(24,16),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&_ZN9S21196C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn8_N9S21196C12D1Ev,_ZThn4_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn8_N9S21196C12D0Ev,_ZThn4_N9S21196C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__9S21196C12__9S21196C15[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn24_N9S21196C12D1Ev,_ZThn16_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn24_N9S21196C12D0Ev,_ZThn16_N9S21196C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C6__9S21196C12__9S21196C15[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
static  VTT_ENTRY vtt_S21196C15[] = {
  {&(_ZTV9S21196C15[7]),  7,52},
  {&(_ZTV9S21196C15[12]),  12,52},
  {&(_ZTV9S21196C15[16]),  16,52},
  {&(_ZTV9S21196C15[23]),  23,52},
  {&(_ZTV9S21196C15[28]),  28,52},
  {&(_ZTV9S21196C15[33]),  33,52},
  {&(_ZTV9S21196C15[38]),  38,52},
  {&(_ZTV9S21196C15[42]),  42,52},
  {&(_ZTV9S21196C15[46]),  46,52},
  {&(_ZTV9S21196C15[50]),  50,52},
  {&(_tg__ZTV9S21196C12__9S21196C15[4]),  4,6},
  {&(_tg__ZTV11S21196C2_nt__9S21196C12__9S21196C15[3]),  3,5},
  {&(_tg__ZTV8S21196C6__9S21196C12__9S21196C15[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S21196C15[];
extern  VTBL_ENTRY _ZTV9S21196C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C15[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S21196C12D0Ev,_ZThn16_N9S21196C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S21196C12D0Ev,_ZThn4_N9S21196C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N9S21196C12D1Ev,_ZThn16_N9S21196C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N9S21196C12D1Ev,_ZThn4_N9S21196C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S21196C15D0Ev,_ZTv0_n20_N9S21196C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S21196C15D0Ev,_ZThn84_N9S21196C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S21196C15D1Ev,_ZTv0_n20_N9S21196C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S21196C15D1Ev,_ZThn84_N9S21196C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C15D0Ev,_ZTv0_n12_N9S21196C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N9S21196C15D0Ev,_ZThn124_N9S21196C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn136_N9S21196C15D0Ev,_ZThn100_N9S21196C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S21196C15D0Ev,_ZThn88_N9S21196C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S21196C15D0Ev,_ZThn24_N9S21196C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C15D1Ev,_ZTv0_n12_N9S21196C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn168_N9S21196C15D1Ev,_ZThn124_N9S21196C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn136_N9S21196C15D1Ev,_ZThn100_N9S21196C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn120_N9S21196C15D1Ev,_ZThn88_N9S21196C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S21196C15D1Ev,_ZThn24_N9S21196C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21196C15 = {  "S21196C15", // class name
  bases_S21196C15, 20,
  &(vtc_S21196C15[0]), // expected_vtbl_contents
  &(vtt_S21196C15[0]), // expected_vtt_contents
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S21196C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S21196C15),52, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21196C15),13, //virtual table table var
  20, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C19  : virtual S21196C6 , virtual S21196C8 , S21196C9 , S21196C13 , S21196C7 {
  virtual  ~S21196C19(); // _ZN9S21196C19D2Ev
  S21196C19(); // tgen
};
//SIG(-1 S21196C19) C1{ VBC2{ BC3{ vd m FL} vd FC3} VBC4{ BC2 VBC5{ BC6{ m FC7{ BC3 BC2 vd FC2}} BC7 BC2 VBC3} BC3 VBC6 BC8{ VBC9{ BC2 vd} VBC7 VBC10{ BC7} VBC6 BC11{ VBC3 VBC2} vd} vd Fi Fl} BC5 BC12{ BC10 BC2 BC3 vd} BC6 vd}


 S21196C19 ::~S21196C19(){ note_dtor("S21196C19", this);}
S21196C19 ::S21196C19(){ note_ctor("S21196C19", this);} // tgen

static void Test_S21196C19()
{
  extern Class_Descriptor cd_S21196C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(124,184)];
    init_test(&cd_S21196C19, buf);
    S21196C19 *dp, &lv = *(dp=new (buf) S21196C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(984,732), "sizeof(S21196C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C19)");
    /*is_ambiguous_... S21196C19::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), ABISELECT(400,300), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*), ABISELECT(400,300), "S21196C19");
    check_base_class_offset(lv, (S21196C6*)(S21196C12*)(S21196C10*)(S21196C8*), ABISELECT(400,300), "S21196C19");
    /*is_ambiguous_... S21196C8::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C8*), ABISELECT(432,324), "S21196C19");
    /*is_ambiguous_... S21196C8::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C8*), ABISELECT(432,324), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C7*)(S21196C9*), ABISELECT(584,432), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C9*), ABISELECT(504,372), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C9*), ABISELECT(520,384), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C9*), ABISELECT(520,384), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C9*), ABISELECT(504,372), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C9*), ABISELECT(664,492), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C9*), ABISELECT(664,492), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C9*), ABISELECT(696,516), "S21196C19");
    /*is_ambiguous_... S21196C12::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C12*)(S21196C10*)(S21196C8*), ABISELECT(696,516), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C9*), ABISELECT(696,516), "S21196C19");
    check_base_class_offset(lv, (S21196C9*)(S21196C8*), ABISELECT(504,372), "S21196C19");
    /*is_ambiguous_... S21196C8::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C8*), ABISELECT(464,348), "S21196C19");
    /*is_ambiguous_... S21196C8::S21196C7 */ AMB_check_base_class_offset(lv, (S21196C7*)(S21196C8*), ABISELECT(712,528), "S21196C19");
    check_base_class_offset(lv, (S21196C7*)(S21196C10*)(S21196C8*), ABISELECT(712,528), "S21196C19");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C11*), ABISELECT(792,588), "S21196C19");
    check_base_class_offset(lv, (S21196C6*)(S21196C11*), ABISELECT(792,588), "S21196C19");
    check_base_class_offset(lv, (S21196C11*)(S21196C10*)(S21196C8*), ABISELECT(792,588), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*), ABISELECT(824,612), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*), ABISELECT(840,624), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*), ABISELECT(840,624), "S21196C19");
    /*is_ambiguous_... S21196C10::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C10*)(S21196C8*), ABISELECT(824,612), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*), ABISELECT(904,672), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(920,684), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(920,684), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C4*), ABISELECT(904,672), "S21196C19");
    check_base_class_offset(lv, (S21196C4*)(S21196C10*)(S21196C8*), ABISELECT(904,672), "S21196C19");
    check_base_class_offset(lv, (S21196C12*)(S21196C10*)(S21196C8*), ABISELECT(480,360), "S21196C19");
    check_base_class_offset(lv, (S21196C10*)(S21196C8*), ABISELECT(480,360), "S21196C19");
    check_base_class_offset(lv, (S21196C8*), ABISELECT(432,324), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C7*)(S21196C9*), ABISELECT(80,60), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C9*), 0, "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C9*), ABISELECT(16,12), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C9*), ABISELECT(16,12), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C9*), 0, "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C9*), ABISELECT(160,120), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C9*), ABISELECT(160,120), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C9*), 0, "S21196C19");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(192,144), "S21196C19");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(208,156), "S21196C19");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(208,156), "S21196C19");
    check_base_class_offset(lv, (S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(192,144), "S21196C19");
    check_base_class_offset(lv, (S21196C4*)(S21196C13*), ABISELECT(192,144), "S21196C19");
    /*is_ambiguous_... S21196C13::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C13*), ABISELECT(272,204), "S21196C19");
    /*is_ambiguous_... S21196C13::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C13*), ABISELECT(272,204), "S21196C19");
    /*is_ambiguous_... S21196C13::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C13*), ABISELECT(304,228), "S21196C19");
    check_base_class_offset(lv, (S21196C13*), ABISELECT(192,144), "S21196C19");
    /*is_ambiguous_... S21196C19::S21196C7 */ AMB_check_base_class_offset(lv, (S21196C7*), ABISELECT(320,240), "S21196C19");
    test_class_info(&lv, &cd_S21196C19);
    dp->~S21196C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C19(Test_S21196C19, "S21196C19", ABISELECT(984,732));

#else // __cplusplus

extern void _ZN9S21196C19C1Ev();
extern void _ZN9S21196C19D2Ev();
Name_Map name_map_S21196C19[] = {
  NSPAIR(_ZN9S21196C19C1Ev),
  NSPAIR(_ZN9S21196C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C9;
extern VTBL_ENTRY _ZTI8S21196C9[];
extern  VTBL_ENTRY _ZTV8S21196C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C9[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C11;
extern VTBL_ENTRY _ZTI9S21196C11[];
extern  VTBL_ENTRY _ZTV9S21196C11[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C12;
extern VTBL_ENTRY _ZTI9S21196C12[];
extern  VTBL_ENTRY _ZTV9S21196C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C12[];
extern Class_Descriptor cd_S21196C10;
extern VTBL_ENTRY _ZTI9S21196C10[];
extern  VTBL_ENTRY _ZTV9S21196C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C10[];
extern Class_Descriptor cd_S21196C8;
extern VTBL_ENTRY _ZTI8S21196C8[];
extern  VTBL_ENTRY _ZTV8S21196C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C8[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C9;
extern VTBL_ENTRY _ZTI8S21196C9[];
extern  VTBL_ENTRY _ZTV8S21196C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C9[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C13;
extern VTBL_ENTRY _ZTI9S21196C13[];
extern  VTBL_ENTRY _ZTV9S21196C13[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
static Base_Class bases_S21196C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    ABISELECT(400,300), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(400,300), //bcp->offset
    36, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C2_nt,    ABISELECT(432,324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(432,324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S21196C7,    ABISELECT(584,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(504,372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(520,384), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(520,384), //bcp->offset
    73, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(504,372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(664,492), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(664,492), //bcp->offset
    77, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(696,516), //bcp->offset
    81, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S21196C9,    ABISELECT(504,372), //bcp->offset
    67, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(464,348), //bcp->offset
    53, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S21196C7,    ABISELECT(712,528), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(792,588), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(792,588), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S21196C11,    ABISELECT(792,588), //bcp->offset
    86, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(824,612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(840,624), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(840,624), //bcp->offset
    96, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(824,612), //bcp->offset
    91, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(904,672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(920,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(920,684), //bcp->offset
    105, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(904,672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21196C4,    ABISELECT(904,672), //bcp->offset
    100, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C12,    ABISELECT(480,360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S21196C10,    ABISELECT(480,360), //bcp->offset
    57, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S21196C8,    ABISELECT(432,324), //bcp->offset
    41, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S21196C7,    ABISELECT(80,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(16,12), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S21196C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(160,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(160,120), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S21196C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C2_nt,    ABISELECT(192,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(208,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(208,156), //bcp->offset
    24, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(192,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S21196C4,    ABISELECT(192,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(272,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(272,204), //bcp->offset
    28, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(304,228), //bcp->offset
    32, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S21196C13,    ABISELECT(192,144), //bcp->offset
    20, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S21196C7,    ABISELECT(320,240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S21196C19[];
extern void _ZN9S21196C19D1Ev();
extern void _ZN9S21196C19D0Ev();
extern void ABISELECT(_ZThn16_N9S21196C19D1Ev,_ZThn12_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn16_N9S21196C19D0Ev,_ZThn12_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn160_N9S21196C19D1Ev,_ZThn120_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn160_N9S21196C19D0Ev,_ZThn120_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn192_N9S21196C19D1Ev,_ZThn144_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn192_N9S21196C19D0Ev,_ZThn144_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn208_N9S21196C19D1Ev,_ZThn156_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S21196C19D0Ev,_ZThn156_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn272_N9S21196C19D1Ev,_ZThn204_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn272_N9S21196C19D0Ev,_ZThn204_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn304_N9S21196C19D1Ev,_ZThn228_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn304_N9S21196C19D0Ev,_ZThn228_N9S21196C19D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn400_N9S21196C19D1Ev,_ZThn300_N9S21196C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn400_N9S21196C19D0Ev,_ZThn300_N9S21196C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21196C19D1Ev,_ZTv0_n40_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn432_N9S21196C19D1Ev,_ZThn324_N9S21196C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N9S21196C19D0Ev,_ZTv0_n40_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn432_N9S21196C19D0Ev,_ZThn324_N9S21196C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn32_n80_N9S21196C19D1Ev,_ZTvn24_n40_N9S21196C19D1Ev)();
extern void ABISELECT(_ZTvn32_n80_N9S21196C19D0Ev,_ZTvn24_n40_N9S21196C19D0Ev)();
extern void ABISELECT(_ZTvn48_n80_N9S21196C19D1Ev,_ZTvn36_n40_N9S21196C19D1Ev)();
extern void ABISELECT(_ZTvn48_n80_N9S21196C19D0Ev,_ZTvn36_n40_N9S21196C19D0Ev)();
extern void ABISELECT(_ZTv0_n32_N9S21196C19D1Ev,_ZTv0_n16_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn504_N9S21196C19D1Ev,_ZThn372_N9S21196C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S21196C19D0Ev,_ZTv0_n16_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn504_N9S21196C19D0Ev,_ZThn372_N9S21196C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n32_N9S21196C19D1Ev,_ZTvn12_n16_N9S21196C19D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N9S21196C19D0Ev,_ZTvn12_n16_N9S21196C19D0Ev)();
extern void ABISELECT(_ZTvn160_n32_N9S21196C19D1Ev,_ZTvn120_n16_N9S21196C19D1Ev)();
extern void ABISELECT(_ZTvn160_n32_N9S21196C19D0Ev,_ZTvn120_n16_N9S21196C19D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn696_N9S21196C19D1Ev,_ZThn516_N9S21196C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn696_N9S21196C19D0Ev,_ZThn516_N9S21196C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn792_N9S21196C19D1Ev,_ZThn588_N9S21196C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn792_N9S21196C19D0Ev,_ZThn588_N9S21196C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn824_N9S21196C19D1Ev,_ZThn612_N9S21196C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn824_N9S21196C19D0Ev,_ZThn612_N9S21196C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N9S21196C19D1Ev,_ZTvn12_n12_N9S21196C19D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C19D0Ev,_ZTvn12_n12_N9S21196C19D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev)();
extern void ABISELECT(_ZThn904_N9S21196C19D1Ev,_ZThn672_N9S21196C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev)();
extern void ABISELECT(_ZThn904_N9S21196C19D0Ev,_ZThn672_N9S21196C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N9S21196C19D1Ev,_ZTvn12_n12_N9S21196C19D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C19D0Ev,_ZTvn12_n12_N9S21196C19D0Ev)();
static  VTBL_ENTRY vtc_S21196C19[] = {
  ABISELECT(904,672),
  ABISELECT(824,612),
  ABISELECT(792,588),
  ABISELECT(712,528),
  ABISELECT(504,372),
  ABISELECT(432,324),
  ABISELECT(400,300),
  ABISELECT(696,516),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&_ZN9S21196C19D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C19D0Ev,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S21196C19D1Ev,_ZThn12_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N9S21196C19D0Ev,_ZThn12_N9S21196C19D0Ev),
  ABISELECT(-160,-120),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S21196C19D1Ev,_ZThn120_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S21196C19D0Ev,_ZThn120_N9S21196C19D0Ev),
  ABISELECT(-192,-144),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N9S21196C19D1Ev,_ZThn144_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn192_N9S21196C19D0Ev,_ZThn144_N9S21196C19D0Ev),
  ABISELECT(-208,-156),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21196C19D1Ev,_ZThn156_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N9S21196C19D0Ev,_ZThn156_N9S21196C19D0Ev),
  ABISELECT(-272,-204),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S21196C19D1Ev,_ZThn204_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S21196C19D0Ev,_ZThn204_N9S21196C19D0Ev),
  ABISELECT(-304,-228),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn304_N9S21196C19D1Ev,_ZThn228_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn304_N9S21196C19D0Ev,_ZThn228_N9S21196C19D0Ev),
  ABISELECT(-400,-300),
  ABISELECT(-400,-300),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev),
  ABISELECT(-432,-324),
  ABISELECT(-32,-24),
  ABISELECT(472,348),
  ABISELECT(392,288),
  ABISELECT(360,264),
  ABISELECT(280,204),
  ABISELECT(264,192),
  ABISELECT(72,48),
  ABISELECT(-432,-324),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21196C19D1Ev,_ZTv0_n40_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N9S21196C19D0Ev,_ZTv0_n40_N9S21196C19D0Ev),
  ABISELECT(-464,-348),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n80_N9S21196C19D1Ev,_ZTvn24_n40_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n80_N9S21196C19D0Ev,_ZTvn24_n40_N9S21196C19D0Ev),
  ABISELECT(232,168),
  ABISELECT(424,312),
  ABISELECT(344,252),
  ABISELECT(312,228),
  ABISELECT(-80,-60),
  ABISELECT(216,156),
  ABISELECT(-480,-360),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n80_N9S21196C19D1Ev,_ZTvn36_n40_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n80_N9S21196C19D0Ev,_ZTvn36_n40_N9S21196C19D0Ev),
  ABISELECT(-504,-372),
  ABISELECT(192,144),
  ABISELECT(-504,-372),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S21196C19D1Ev,_ZTv0_n16_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S21196C19D0Ev,_ZTv0_n16_N9S21196C19D0Ev),
  ABISELECT(-520,-384),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N9S21196C19D1Ev,_ZTvn12_n16_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N9S21196C19D0Ev,_ZTvn12_n16_N9S21196C19D0Ev),
  ABISELECT(-664,-492),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n32_N9S21196C19D1Ev,_ZTvn120_n16_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n32_N9S21196C19D0Ev,_ZTvn120_n16_N9S21196C19D0Ev),
  ABISELECT(-696,-516),
  ABISELECT(-696,-516),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev),
  ABISELECT(-792,-588),
  ABISELECT(-792,-588),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev),
  ABISELECT(-824,-612),
  ABISELECT(-824,-612),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev),
  ABISELECT(-840,-624),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C19D1Ev,_ZTvn12_n12_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C19D0Ev,_ZTvn12_n12_N9S21196C19D0Ev),
  ABISELECT(-904,-672),
  ABISELECT(-904,-672),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev),
  ABISELECT(-920,-684),
  (VTBL_ENTRY)&(_ZTI9S21196C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C19D1Ev,_ZTvn12_n12_N9S21196C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C19D0Ev,_ZTvn12_n12_N9S21196C19D0Ev),
};
extern VTBL_ENTRY _ZTV9S21196C19[];
extern void _ZN8S21196C9D1Ev();
extern void _ZN8S21196C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21196C9__A__9S21196C19[] = {
  ABISELECT(696,516),
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&_ZN8S21196C9D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev)();
extern void ABISELECT(_ZThn696_N8S21196C9D1Ev,_ZThn516_N8S21196C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev)();
extern void ABISELECT(_ZThn696_N8S21196C9D0Ev,_ZThn516_N8S21196C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__A3__8S21196C9__A__9S21196C19[] = {
  ABISELECT(-696,-516),
  ABISELECT(-696,-516),
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev),
};
extern void _ZN8S21196C8D1Ev();
extern void _ZN8S21196C8D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21196C8__9S21196C19[] = {
  ABISELECT(-32,-24),
  ABISELECT(472,348),
  ABISELECT(392,288),
  ABISELECT(360,264),
  ABISELECT(280,204),
  ABISELECT(264,192),
  ABISELECT(72,48),
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&_ZN8S21196C8D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C8D0Ev,
};
extern void _ZN9S21196C10D1Ev();
extern void _ZN9S21196C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(232,168),
  ABISELECT(424,312),
  ABISELECT(344,252),
  ABISELECT(312,228),
  ABISELECT(-80,-60),
  ABISELECT(216,156),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&_ZN9S21196C10D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C10D0Ev,
};
extern void _ZN9S21196C12D1Ev();
extern void _ZN9S21196C12D0Ev();
static  VTBL_ENTRY _tg__ZTV9S21196C129S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(-80,-60),
  ABISELECT(216,156),
  0,
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&_ZN9S21196C12D1Ev,
  (VTBL_ENTRY)&_ZN9S21196C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZThn216_N9S21196C12D1Ev,_ZThn156_N9S21196C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
extern void ABISELECT(_ZThn216_N9S21196C12D0Ev,_ZThn156_N9S21196C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__9S21196C129S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(-216,-156),
  ABISELECT(-216,-156),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C6__9S21196C129S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(80,60),
  ABISELECT(80,60),
  (VTBL_ENTRY)&(_ZTI9S21196C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn312_N9S21196C10D1Ev,_ZThn228_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn312_N9S21196C10D0Ev,_ZThn228_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21196C11__9S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(-312,-228),
  ABISELECT(-312,-228),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn344_N9S21196C10D1Ev,_ZThn252_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn344_N9S21196C10D0Ev,_ZThn252_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C5__9S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(-344,-252),
  ABISELECT(-344,-252),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C5__A1__9S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(-360,-264),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn424_N9S21196C10D1Ev,_ZThn312_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn424_N9S21196C10D0Ev,_ZThn312_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C4__9S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(-424,-312),
  ABISELECT(-424,-312),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C58S21196C4__A2__9S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(-440,-324),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D1Ev,_ZTvn12_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N9S21196C10D0Ev,_ZTvn12_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZThn216_N9S21196C10D1Ev,_ZThn156_N9S21196C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
extern void ABISELECT(_ZThn216_N9S21196C10D0Ev,_ZThn156_N9S21196C10D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__A5__9S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(-216,-156),
  ABISELECT(-216,-156),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C6__A3__9S21196C108S21196C8__9S21196C19[] = {
  ABISELECT(80,60),
  ABISELECT(80,60),
  (VTBL_ENTRY)&(_ZTI9S21196C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S21196C8D1Ev,_ZTv0_n16_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn72_N8S21196C8D1Ev,_ZThn48_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S21196C8D0Ev,_ZTv0_n16_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn72_N8S21196C8D0Ev,_ZThn48_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C9__8S21196C8__9S21196C19[] = {
  ABISELECT(-72,-48),
  ABISELECT(192,144),
  ABISELECT(-72,-48),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S21196C8D1Ev,_ZTv0_n16_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S21196C8D0Ev,_ZTv0_n16_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTvn16_n32_N8S21196C8D1Ev,_ZTvn12_n16_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn16_n32_N8S21196C8D0Ev,_ZTvn12_n16_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C58S21196C9__A1__8S21196C8__9S21196C19[] = {
  ABISELECT(-88,-60),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S21196C8D1Ev,_ZTvn12_n16_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n32_N8S21196C8D0Ev,_ZTvn12_n16_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTvn160_n32_N8S21196C8D1Ev,_ZTvn120_n16_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn160_n32_N8S21196C8D0Ev,_ZTvn120_n16_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C9__A2__8S21196C8__9S21196C19[] = {
  ABISELECT(-232,-168),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n32_N8S21196C8D1Ev,_ZTvn120_n16_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n32_N8S21196C8D0Ev,_ZTvn120_n16_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn264_N8S21196C8D1Ev,_ZThn192_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn264_N8S21196C8D0Ev,_ZThn192_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__A4__8S21196C8__9S21196C19[] = {
  ABISELECT(-264,-192),
  ABISELECT(-264,-192),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZThn48_N8S21196C8D1Ev,_ZThn36_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn48_N8S21196C8D0Ev,_ZThn36_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S21196C10__8S21196C8__9S21196C19[] = {
  ABISELECT(232,168),
  ABISELECT(424,312),
  ABISELECT(344,252),
  ABISELECT(312,228),
  ABISELECT(-80,-60),
  ABISELECT(216,156),
  ABISELECT(-48,-36),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S21196C8D1Ev,_ZThn36_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S21196C8D0Ev,_ZThn36_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn360_N8S21196C8D1Ev,_ZThn264_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn360_N8S21196C8D0Ev,_ZThn264_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S21196C11__8S21196C8__9S21196C19[] = {
  ABISELECT(-360,-264),
  ABISELECT(-360,-264),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn392_N8S21196C8D1Ev,_ZThn288_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn392_N8S21196C8D0Ev,_ZThn288_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C5__A1__8S21196C8__9S21196C19[] = {
  ABISELECT(-392,-288),
  ABISELECT(-392,-288),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C5__A4__8S21196C8__9S21196C19[] = {
  ABISELECT(-408,-300),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZThn472_N8S21196C8D1Ev,_ZThn348_N8S21196C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
extern void ABISELECT(_ZThn472_N8S21196C8D0Ev,_ZThn348_N8S21196C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S21196C4__8S21196C8__9S21196C19[] = {
  ABISELECT(-472,-348),
  ABISELECT(-472,-348),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C68S21196C58S21196C4__A5__8S21196C8__9S21196C19[] = {
  ABISELECT(-488,-360),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D1Ev,_ZTvn12_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N8S21196C8D0Ev,_ZTvn12_n12_N8S21196C8D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S21196C6__A6__8S21196C8__9S21196C19[] = {
  ABISELECT(32,24),
  ABISELECT(32,24),
  (VTBL_ENTRY)&(_ZTI8S21196C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev),
};
extern void _ZN8S21196C9D1Ev();
extern void _ZN8S21196C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S21196C9__9S21196C19[] = {
  ABISELECT(192,144),
  0,
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&_ZN8S21196C9D1Ev,
  (VTBL_ENTRY)&_ZN8S21196C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev)();
extern void ABISELECT(_ZThn192_N8S21196C9D1Ev,_ZThn144_N8S21196C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev)();
extern void ABISELECT(_ZThn192_N8S21196C9D0Ev,_ZThn144_N8S21196C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S21196C2_nt__A3__8S21196C9__9S21196C19[] = {
  ABISELECT(-192,-144),
  ABISELECT(-192,-144),
  (VTBL_ENTRY)&(_ZTI8S21196C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev),
};
static  VTT_ENTRY vtt_S21196C19[] = {
  {&(_ZTV9S21196C19[10]),  10,109},
  {&(_tg__ZTV8S21196C9__A__9S21196C19[3]),  3,5},
  {&(_tg__ZTV11S21196C2_nt__A3__8S21196C9__A__9S21196C19[3]),  3,5},
  {&(_ZTV9S21196C19[39]),  39,109},
  {&(_ZTV9S21196C19[51]),  51,109},
  {&(_ZTV9S21196C19[71]),  71,109},
  {&(_ZTV9S21196C19[75]),  75,109},
  {&(_ZTV9S21196C19[79]),  79,109},
  {&(_ZTV9S21196C19[84]),  84,109},
  {&(_ZTV9S21196C19[55]),  55,109},
  {&(_ZTV9S21196C19[65]),  65,109},
  {&(_ZTV9S21196C19[89]),  89,109},
  {&(_ZTV9S21196C19[94]),  94,109},
  {&(_ZTV9S21196C19[98]),  98,109},
  {&(_ZTV9S21196C19[103]),  103,109},
  {&(_ZTV9S21196C19[107]),  107,109},
  {&(_tg__ZTV8S21196C8__9S21196C19[9]),  9,11},
  {&(_tg__ZTV9S21196C108S21196C8__9S21196C19[8]),  8,10},
  {&(_tg__ZTV9S21196C129S21196C108S21196C8__9S21196C19[4]),  4,6},
  {&(_tg__ZTV11S21196C2_nt__9S21196C129S21196C108S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV8S21196C6__9S21196C129S21196C108S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV9S21196C11__9S21196C108S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV8S21196C5__9S21196C108S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV8S21196C68S21196C5__A1__9S21196C108S21196C8__9S21196C19[2]),  2,4},
  {&(_tg__ZTV8S21196C4__9S21196C108S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV8S21196C68S21196C58S21196C4__A2__9S21196C108S21196C8__9S21196C19[2]),  2,4},
  {&(_tg__ZTV11S21196C2_nt__A5__9S21196C108S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV8S21196C6__A3__9S21196C108S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV8S21196C9__8S21196C8__9S21196C19[4]),  4,6},
  {&(_tg__ZTV8S21196C68S21196C58S21196C9__A1__8S21196C8__9S21196C19[2]),  2,4},
  {&(_tg__ZTV8S21196C68S21196C9__A2__8S21196C8__9S21196C19[2]),  2,4},
  {&(_tg__ZTV11S21196C2_nt__A4__8S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV9S21196C10__8S21196C8__9S21196C19[8]),  8,10},
  {&(_tg__ZTV9S21196C11__8S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV8S21196C5__A1__8S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV8S21196C68S21196C5__A4__8S21196C8__9S21196C19[2]),  2,4},
  {&(_tg__ZTV8S21196C4__8S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV8S21196C68S21196C58S21196C4__A5__8S21196C8__9S21196C19[2]),  2,4},
  {&(_tg__ZTV8S21196C6__A6__8S21196C8__9S21196C19[3]),  3,5},
  {&(_tg__ZTV8S21196C9__9S21196C19[3]),  3,5},
  {&(_tg__ZTV11S21196C2_nt__A3__8S21196C9__9S21196C19[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S21196C19[];
extern  VTBL_ENTRY _ZTV9S21196C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C19[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C8D0Ev,_ZTv0_n12_N8S21196C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn472_N8S21196C8D0Ev,_ZThn348_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn392_N8S21196C8D0Ev,_ZThn288_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S21196C8D0Ev,_ZThn264_N8S21196C8D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S21196C8D0Ev,_ZThn192_N8S21196C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C8D1Ev,_ZTv0_n12_N8S21196C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn472_N8S21196C8D1Ev,_ZThn348_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn392_N8S21196C8D1Ev,_ZThn288_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn360_N8S21196C8D1Ev,_ZThn264_N8S21196C8D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn264_N8S21196C8D1Ev,_ZThn192_N8S21196C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S21196C8D0Ev,_ZTv0_n16_N8S21196C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S21196C8D0Ev,_ZThn48_N8S21196C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S21196C8D1Ev,_ZTv0_n16_N8S21196C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S21196C8D1Ev,_ZThn48_N8S21196C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C10D0Ev,_ZTv0_n12_N9S21196C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C10D0Ev,_ZThn156_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn424_N9S21196C10D0Ev,_ZThn312_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn344_N9S21196C10D0Ev,_ZThn252_N9S21196C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn312_N9S21196C10D0Ev,_ZThn228_N9S21196C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C10D1Ev,_ZTv0_n12_N9S21196C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C10D1Ev,_ZThn156_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn424_N9S21196C10D1Ev,_ZThn312_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn344_N9S21196C10D1Ev,_ZThn252_N9S21196C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn312_N9S21196C10D1Ev,_ZThn228_N9S21196C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D0Ev,_ZTv0_n12_N9S21196C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C12D0Ev,_ZThn156_N9S21196C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C12D1Ev,_ZTv0_n12_N9S21196C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S21196C12D1Ev,_ZThn156_N9S21196C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C9D0Ev,_ZTv0_n12_N8S21196C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N8S21196C9D0Ev,_ZThn144_N8S21196C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn696_N8S21196C9D0Ev,_ZThn516_N8S21196C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S21196C9D1Ev,_ZTv0_n12_N8S21196C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn192_N8S21196C9D1Ev,_ZThn144_N8S21196C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn696_N8S21196C9D1Ev,_ZThn516_N8S21196C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S21196C19D0Ev,_ZTv0_n16_N9S21196C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn504_N9S21196C19D0Ev,_ZThn372_N9S21196C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S21196C19D1Ev,_ZTv0_n16_N9S21196C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn504_N9S21196C19D1Ev,_ZThn372_N9S21196C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21196C19D0Ev,_ZTv0_n40_N9S21196C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn432_N9S21196C19D0Ev,_ZThn324_N9S21196C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N9S21196C19D1Ev,_ZTv0_n40_N9S21196C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn432_N9S21196C19D1Ev,_ZThn324_N9S21196C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C19D0Ev,_ZTv0_n12_N9S21196C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn904_N9S21196C19D0Ev,_ZThn672_N9S21196C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn824_N9S21196C19D0Ev,_ZThn612_N9S21196C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn792_N9S21196C19D0Ev,_ZThn588_N9S21196C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn696_N9S21196C19D0Ev,_ZThn516_N9S21196C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn400_N9S21196C19D0Ev,_ZThn300_N9S21196C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S21196C19D1Ev,_ZTv0_n12_N9S21196C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn904_N9S21196C19D1Ev,_ZThn672_N9S21196C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn824_N9S21196C19D1Ev,_ZThn612_N9S21196C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn792_N9S21196C19D1Ev,_ZThn588_N9S21196C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn696_N9S21196C19D1Ev,_ZThn516_N9S21196C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn400_N9S21196C19D1Ev,_ZThn300_N9S21196C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S21196C19 = {  "S21196C19", // class name
  bases_S21196C19, 48,
  &(vtc_S21196C19[0]), // expected_vtbl_contents
  &(vtt_S21196C19[0]), // expected_vtt_contents
  ABISELECT(984,732), // object size
  NSPAIRA(_ZTI9S21196C19),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S21196C19),109, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S21196C19),41, //virtual table table var
  44, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S21196C18  : S21196C19 , virtual S21196C3 , S21196C7 {
  virtual  ~S21196C18(); // _ZN9S21196C18D2Ev
  S21196C18(); // tgen
};
//SIG(-1 S21196C18) C1{ BC2{ VBC3{ BC4{ vd m FL} vd FC4} VBC5{ BC3 VBC6{ BC7{ m FC8{ BC4 BC3 vd FC3}} BC8 BC3 VBC4} BC4 VBC7 BC9{ VBC10{ BC3 vd} VBC8 VBC11{ BC8} VBC7 BC12{ VBC4 VBC3} vd} vd Fi Fl} BC6 BC13{ BC11 BC3 BC4 vd} BC7 vd} VBC14{ BC11 VBC7 VBC5 BC4 VBC13 vd} BC7 vd}


 S21196C18 ::~S21196C18(){ note_dtor("S21196C18", this);}
S21196C18 ::S21196C18(){ note_ctor("S21196C18", this);} // tgen

static void Test_S21196C18()
{
  extern Class_Descriptor cd_S21196C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(162,241)];
    init_test(&cd_S21196C18, buf);
    S21196C18 *dp, &lv = *(dp=new (buf) S21196C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1288,960), "sizeof(S21196C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S21196C18)");
    /*is_ambiguous_... S21196C18::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*), ABISELECT(480,360), "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C19*), ABISELECT(480,360), "S21196C18");
    check_base_class_offset(lv, (S21196C6*)(S21196C12*)(S21196C10*)(S21196C8*), ABISELECT(480,360), "S21196C18");
    /*is_ambiguous_... S21196C8::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C8*), ABISELECT(512,384), "S21196C18");
    /*is_ambiguous_... S21196C8::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C8*), ABISELECT(512,384), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C7*)(S21196C9*), ABISELECT(664,492), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C9*), ABISELECT(584,432), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C9*), ABISELECT(600,444), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C9*), ABISELECT(600,444), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C9*), ABISELECT(584,432), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C9*), ABISELECT(744,552), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C9*), ABISELECT(744,552), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C9*), ABISELECT(776,576), "S21196C18");
    /*is_ambiguous_... S21196C12::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C12*)(S21196C10*)(S21196C8*), ABISELECT(776,576), "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C9*)(S21196C19*), ABISELECT(776,576), "S21196C18");
    check_base_class_offset(lv, (S21196C9*)(S21196C8*), ABISELECT(584,432), "S21196C18");
    /*is_ambiguous_... S21196C8::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C8*), ABISELECT(544,408), "S21196C18");
    /*is_ambiguous_... S21196C8::S21196C7 */ AMB_check_base_class_offset(lv, (S21196C7*)(S21196C8*), ABISELECT(792,588), "S21196C18");
    check_base_class_offset(lv, (S21196C7*)(S21196C10*)(S21196C8*), ABISELECT(792,588), "S21196C18");
    /*is_ambiguous_... S21196C3::S21196C7 */ AMB_check_base_class_offset(lv, (S21196C7*)(S21196C3*), ABISELECT(792,588), "S21196C18");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C11*), ABISELECT(872,648), "S21196C18");
    check_base_class_offset(lv, (S21196C6*)(S21196C11*), ABISELECT(872,648), "S21196C18");
    check_base_class_offset(lv, (S21196C11*)(S21196C10*)(S21196C8*), ABISELECT(872,648), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*), ABISELECT(904,672), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*), ABISELECT(920,684), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*), ABISELECT(920,684), "S21196C18");
    /*is_ambiguous_... S21196C10::S21196C5 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C10*)(S21196C8*), ABISELECT(904,672), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*), ABISELECT(984,732), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(1000,744), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*), ABISELECT(1000,744), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C4*), ABISELECT(984,732), "S21196C18");
    check_base_class_offset(lv, (S21196C4*)(S21196C10*)(S21196C8*), ABISELECT(984,732), "S21196C18");
    check_base_class_offset(lv, (S21196C12*)(S21196C10*)(S21196C8*), ABISELECT(560,420), "S21196C18");
    check_base_class_offset(lv, (S21196C10*)(S21196C8*), ABISELECT(560,420), "S21196C18");
    check_base_class_offset(lv, (S21196C8*)(S21196C19*), ABISELECT(512,384), "S21196C18");
    check_base_class_offset(lv, (S21196C8*)(S21196C3*), ABISELECT(512,384), "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C7*)(S21196C9*)(S21196C19*), ABISELECT(80,60), "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C9*)(S21196C19*), 0, "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C9*)(S21196C19*), ABISELECT(16,12), "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C9*)(S21196C19*), ABISELECT(16,12), "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C9*)(S21196C19*), 0, "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C9*)(S21196C19*), ABISELECT(160,120), "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C9*)(S21196C19*), ABISELECT(160,120), "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C9 */ AMB_check_base_class_offset(lv, (S21196C9*)(S21196C19*), 0, "S21196C18");
    /*is_ambiguous_... S21196C5::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*)(S21196C13*)(S21196C19*), ABISELECT(192,144), "S21196C18");
    check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*)(S21196C13*)(S21196C19*), ABISELECT(208,156), "S21196C18");
    check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*)(S21196C13*)(S21196C19*), ABISELECT(208,156), "S21196C18");
    check_base_class_offset(lv, (S21196C5*)(S21196C4*)(S21196C13*)(S21196C19*), ABISELECT(192,144), "S21196C18");
    check_base_class_offset(lv, (S21196C4*)(S21196C13*)(S21196C19*), ABISELECT(192,144), "S21196C18");
    /*is_ambiguous_... S21196C13::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C13*)(S21196C19*), ABISELECT(272,204), "S21196C18");
    /*is_ambiguous_... S21196C13::S21196C6 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C13*)(S21196C19*), ABISELECT(272,204), "S21196C18");
    /*is_ambiguous_... S21196C13::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C13*)(S21196C19*), ABISELECT(304,228), "S21196C18");
    check_base_class_offset(lv, (S21196C13*)(S21196C19*), ABISELECT(192,144), "S21196C18");
    /*is_ambiguous_... S21196C19::S21196C7 */ AMB_check_base_class_offset(lv, (S21196C7*)(S21196C19*), ABISELECT(320,240), "S21196C18");
    check_base_class_offset(lv, (S21196C19*), 0, "S21196C18");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*)(S21196C3*), ABISELECT(1064,792), "S21196C18");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*)(S21196C3*), ABISELECT(1080,804), "S21196C18");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*)(S21196C3*), ABISELECT(1080,804), "S21196C18");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C4*)(S21196C3*), ABISELECT(1064,792), "S21196C18");
    /*is_ambiguous_... S21196C3::S21196C4 */ AMB_check_base_class_offset(lv, (S21196C4*)(S21196C3*), ABISELECT(1064,792), "S21196C18");
    /*is_ambiguous_... S21196C3::S21196C2_nt */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C3*), ABISELECT(1144,852), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C13 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(1160,864), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C13 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(1176,876), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C13 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(1176,876), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C13 */ AMB_check_base_class_offset(lv, (S21196C5*)(S21196C4*)(S21196C13*), ABISELECT(1160,864), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C13 */ AMB_check_base_class_offset(lv, (S21196C4*)(S21196C13*), ABISELECT(1160,864), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C13 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C6*)(S21196C13*), ABISELECT(1240,924), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C13 */ AMB_check_base_class_offset(lv, (S21196C6*)(S21196C13*), ABISELECT(1240,924), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C13 */ AMB_check_base_class_offset(lv, (S21196C2_nt*)(S21196C13*), ABISELECT(1272,948), "S21196C18");
    check_base_class_offset(lv, (S21196C13*)(S21196C3*), ABISELECT(1160,864), "S21196C18");
    check_base_class_offset(lv, (S21196C3*), ABISELECT(1064,792), "S21196C18");
    /*is_ambiguous_... S21196C18::S21196C7 */ AMB_check_base_class_offset(lv, (S21196C7*), ABISELECT(400,300), "S21196C18");
    test_class_info(&lv, &cd_S21196C18);
    dp->~S21196C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS21196C18(Test_S21196C18, "S21196C18", ABISELECT(1288,960));

#else // __cplusplus

extern void _ZN9S21196C18C1Ev();
extern void _ZN9S21196C18D2Ev();
Name_Map name_map_S21196C18[] = {
  NSPAIR(_ZN9S21196C18C1Ev),
  NSPAIR(_ZN9S21196C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C9;
extern VTBL_ENTRY _ZTI8S21196C9[];
extern  VTBL_ENTRY _ZTV8S21196C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C9[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C11;
extern VTBL_ENTRY _ZTI9S21196C11[];
extern  VTBL_ENTRY _ZTV9S21196C11[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C12;
extern VTBL_ENTRY _ZTI9S21196C12[];
extern  VTBL_ENTRY _ZTV9S21196C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C12[];
extern Class_Descriptor cd_S21196C10;
extern VTBL_ENTRY _ZTI9S21196C10[];
extern  VTBL_ENTRY _ZTV9S21196C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C10[];
extern Class_Descriptor cd_S21196C8;
extern VTBL_ENTRY _ZTI8S21196C8[];
extern  VTBL_ENTRY _ZTV8S21196C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C8[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C9;
extern VTBL_ENTRY _ZTI8S21196C9[];
extern  VTBL_ENTRY _ZTV8S21196C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C9[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C13;
extern VTBL_ENTRY _ZTI9S21196C13[];
extern  VTBL_ENTRY _ZTV9S21196C13[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
extern Class_Descriptor cd_S21196C19;
extern VTBL_ENTRY _ZTI9S21196C19[];
extern  VTBL_ENTRY _ZTV9S21196C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S21196C19[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C5;
extern VTBL_ENTRY _ZTI8S21196C5[];
extern  VTBL_ENTRY _ZTV8S21196C5[];
extern Class_Descriptor cd_S21196C4;
extern VTBL_ENTRY _ZTI8S21196C4[];
extern  VTBL_ENTRY _ZTV8S21196C4[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C6;
extern VTBL_ENTRY _ZTI8S21196C6[];
extern  VTBL_ENTRY _ZTV8S21196C6[];
extern Class_Descriptor cd_S21196C2_nt;
extern VTBL_ENTRY _ZTI11S21196C2_nt[];
extern  VTBL_ENTRY _ZTV11S21196C2_nt[];
extern Class_Descriptor cd_S21196C13;
extern VTBL_ENTRY _ZTI9S21196C13[];
extern  VTBL_ENTRY _ZTV9S21196C13[];
extern Class_Descriptor cd_S21196C3;
extern VTBL_ENTRY _ZTI8S21196C3[];
extern  VTBL_ENTRY _ZTV8S21196C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S21196C3[];
extern Class_Descriptor cd_S21196C7;
extern VTBL_ENTRY _ZTI8S21196C7[];
static Base_Class bases_S21196C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S21196C2_nt,    ABISELECT(480,360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(480,360), //bcp->offset
    38, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(512,384), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(512,384), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S21196C7,    ABISELECT(664,492), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(584,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(600,444), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(600,444), //bcp->offset
    75, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(584,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(744,552), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(744,552), //bcp->offset
    79, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(776,576), //bcp->offset
    83, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S21196C9,    ABISELECT(584,432), //bcp->offset
    69, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(544,408), //bcp->offset
    55, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S21196C7,    ABISELECT(792,588), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(872,648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(872,648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S21196C11,    ABISELECT(872,648), //bcp->offset
    88, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(904,672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(920,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(920,684), //bcp->offset
    98, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(904,672), //bcp->offset
    93, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C2_nt,    ABISELECT(984,732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(1000,744), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(1000,744), //bcp->offset
    107, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S21196C5,    ABISELECT(984,732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S21196C4,    ABISELECT(984,732), //bcp->offset
    102, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    28, //immediately_derived
  0, 1},
  {&cd_S21196C12,    ABISELECT(560,420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S21196C10,    ABISELECT(560,420), //bcp->offset
    59, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S21196C8,    ABISELECT(512,384), //bcp->offset
    43, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    48, //immediately_derived
  0, 1},
  {&cd_S21196C7,    ABISELECT(80,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(16,12), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S21196C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(160,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S21196C6,    ABISELECT(160,120), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    50, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S21196C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    51, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(192,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    52, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S21196C2_nt,    ABISELECT(208,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construct