// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S1503C5_nt  {
  int s1503c5f0[2];
  void  mf1503c5(); // _ZN10S1503C5_nt8mf1503c5Ev
};
//SIG(-1 S1503C5_nt) C1{ m Fi[2]}


void  S1503C5_nt ::mf1503c5(){}

//skip512 S1503C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C4_nt  {
  int s1503c4f0;
  __tsi64 s1503c4f1;
  void *s1503c4f2[4];
  int s1503c4f3[2];
  void *s1503c4f4;
  ::S1503C5_nt s1503c4f5;
  void *s1503c4f6[2];
  virtual  ~S1503C4_nt(); // _ZN10S1503C4_ntD1Ev
  virtual void  v6(); // _ZN10S1503C4_nt2v6Ev
  virtual void  v7(); // _ZN10S1503C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1503C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1503C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1503C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1503C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1503C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1503C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1503C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1503C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1503C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1503C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1503C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1503C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1503C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1503C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1503C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1503C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1503C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1503C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1503C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1503C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1503C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1503C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1503C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1503C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1503C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1503C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1503C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1503C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1503C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1503C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1503C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1503C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1503C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1503C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1503C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1503C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1503C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1503C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1503C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1503C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1503C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1503C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1503C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1503C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1503C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1503C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1503C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1503C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1503C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1503C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1503C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1503C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1503C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1503C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1503C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1503C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1503C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1503C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1503C4_nt3v66Ev
  virtual void  v67(); // _ZN10S1503C4_nt3v67Ev
  virtual void  v68(); // _ZN10S1503C4_nt3v68Ev
  virtual void  v69(); // _ZN10S1503C4_nt3v69Ev
  S1503C4_nt(); // tgen
};
//SIG(-1 S1503C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1503C4_nt ::~S1503C4_nt(){ note_dtor("S1503C4_nt", this);}
void  S1503C4_nt ::v6(){vfunc_called(this, "_ZN10S1503C4_nt2v6Ev");}
void  S1503C4_nt ::v7(){vfunc_called(this, "_ZN10S1503C4_nt2v7Ev");}
void  S1503C4_nt ::v8(){vfunc_called(this, "_ZN10S1503C4_nt2v8Ev");}
void  S1503C4_nt ::v9(){vfunc_called(this, "_ZN10S1503C4_nt2v9Ev");}
void  S1503C4_nt ::v10(){vfunc_called(this, "_ZN10S1503C4_nt3v10Ev");}
void  S1503C4_nt ::v11(){vfunc_called(this, "_ZN10S1503C4_nt3v11Ev");}
void  S1503C4_nt ::v12(){vfunc_called(this, "_ZN10S1503C4_nt3v12Ev");}
void  S1503C4_nt ::v13(){vfunc_called(this, "_ZN10S1503C4_nt3v13Ev");}
void  S1503C4_nt ::v14(){vfunc_called(this, "_ZN10S1503C4_nt3v14Ev");}
void  S1503C4_nt ::v15(){vfunc_called(this, "_ZN10S1503C4_nt3v15Ev");}
void  S1503C4_nt ::v16(){vfunc_called(this, "_ZN10S1503C4_nt3v16Ev");}
void  S1503C4_nt ::v17(){vfunc_called(this, "_ZN10S1503C4_nt3v17Ev");}
void  S1503C4_nt ::v18(){vfunc_called(this, "_ZN10S1503C4_nt3v18Ev");}
void  S1503C4_nt ::v19(){vfunc_called(this, "_ZN10S1503C4_nt3v19Ev");}
void  S1503C4_nt ::v20(){vfunc_called(this, "_ZN10S1503C4_nt3v20Ev");}
void  S1503C4_nt ::v21(){vfunc_called(this, "_ZN10S1503C4_nt3v21Ev");}
void  S1503C4_nt ::v22(){vfunc_called(this, "_ZN10S1503C4_nt3v22Ev");}
void  S1503C4_nt ::v23(){vfunc_called(this, "_ZN10S1503C4_nt3v23Ev");}
void  S1503C4_nt ::v24(){vfunc_called(this, "_ZN10S1503C4_nt3v24Ev");}
void  S1503C4_nt ::v25(){vfunc_called(this, "_ZN10S1503C4_nt3v25Ev");}
void  S1503C4_nt ::v26(){vfunc_called(this, "_ZN10S1503C4_nt3v26Ev");}
void  S1503C4_nt ::v27(){vfunc_called(this, "_ZN10S1503C4_nt3v27Ev");}
void  S1503C4_nt ::v28(){vfunc_called(this, "_ZN10S1503C4_nt3v28Ev");}
void  S1503C4_nt ::v29(){vfunc_called(this, "_ZN10S1503C4_nt3v29Ev");}
void  S1503C4_nt ::v30(){vfunc_called(this, "_ZN10S1503C4_nt3v30Ev");}
void  S1503C4_nt ::v31(){vfunc_called(this, "_ZN10S1503C4_nt3v31Ev");}
void  S1503C4_nt ::v32(){vfunc_called(this, "_ZN10S1503C4_nt3v32Ev");}
void  S1503C4_nt ::v33(){vfunc_called(this, "_ZN10S1503C4_nt3v33Ev");}
void  S1503C4_nt ::v34(){vfunc_called(this, "_ZN10S1503C4_nt3v34Ev");}
void  S1503C4_nt ::v35(){vfunc_called(this, "_ZN10S1503C4_nt3v35Ev");}
void  S1503C4_nt ::v36(){vfunc_called(this, "_ZN10S1503C4_nt3v36Ev");}
void  S1503C4_nt ::v37(){vfunc_called(this, "_ZN10S1503C4_nt3v37Ev");}
void  S1503C4_nt ::v38(){vfunc_called(this, "_ZN10S1503C4_nt3v38Ev");}
void  S1503C4_nt ::v39(){vfunc_called(this, "_ZN10S1503C4_nt3v39Ev");}
void  S1503C4_nt ::v40(){vfunc_called(this, "_ZN10S1503C4_nt3v40Ev");}
void  S1503C4_nt ::v41(){vfunc_called(this, "_ZN10S1503C4_nt3v41Ev");}
void  S1503C4_nt ::v42(){vfunc_called(this, "_ZN10S1503C4_nt3v42Ev");}
void  S1503C4_nt ::v43(){vfunc_called(this, "_ZN10S1503C4_nt3v43Ev");}
void  S1503C4_nt ::v44(){vfunc_called(this, "_ZN10S1503C4_nt3v44Ev");}
void  S1503C4_nt ::v45(){vfunc_called(this, "_ZN10S1503C4_nt3v45Ev");}
void  S1503C4_nt ::v46(){vfunc_called(this, "_ZN10S1503C4_nt3v46Ev");}
void  S1503C4_nt ::v47(){vfunc_called(this, "_ZN10S1503C4_nt3v47Ev");}
void  S1503C4_nt ::v48(){vfunc_called(this, "_ZN10S1503C4_nt3v48Ev");}
void  S1503C4_nt ::v49(){vfunc_called(this, "_ZN10S1503C4_nt3v49Ev");}
void  S1503C4_nt ::v50(){vfunc_called(this, "_ZN10S1503C4_nt3v50Ev");}
void  S1503C4_nt ::v51(){vfunc_called(this, "_ZN10S1503C4_nt3v51Ev");}
void  S1503C4_nt ::v52(){vfunc_called(this, "_ZN10S1503C4_nt3v52Ev");}
void  S1503C4_nt ::v53(){vfunc_called(this, "_ZN10S1503C4_nt3v53Ev");}
void  S1503C4_nt ::v54(){vfunc_called(this, "_ZN10S1503C4_nt3v54Ev");}
void  S1503C4_nt ::v55(){vfunc_called(this, "_ZN10S1503C4_nt3v55Ev");}
void  S1503C4_nt ::v56(){vfunc_called(this, "_ZN10S1503C4_nt3v56Ev");}
void  S1503C4_nt ::v57(){vfunc_called(this, "_ZN10S1503C4_nt3v57Ev");}
void  S1503C4_nt ::v58(){vfunc_called(this, "_ZN10S1503C4_nt3v58Ev");}
void  S1503C4_nt ::v59(){vfunc_called(this, "_ZN10S1503C4_nt3v59Ev");}
void  S1503C4_nt ::v60(){vfunc_called(this, "_ZN10S1503C4_nt3v60Ev");}
void  S1503C4_nt ::v61(){vfunc_called(this, "_ZN10S1503C4_nt3v61Ev");}
void  S1503C4_nt ::v62(){vfunc_called(this, "_ZN10S1503C4_nt3v62Ev");}
void  S1503C4_nt ::v63(){vfunc_called(this, "_ZN10S1503C4_nt3v63Ev");}
void  S1503C4_nt ::v64(){vfunc_called(this, "_ZN10S1503C4_nt3v64Ev");}
void  S1503C4_nt ::v65(){vfunc_called(this, "_ZN10S1503C4_nt3v65Ev");}
void  S1503C4_nt ::v66(){vfunc_called(this, "_ZN10S1503C4_nt3v66Ev");}
void  S1503C4_nt ::v67(){vfunc_called(this, "_ZN10S1503C4_nt3v67Ev");}
void  S1503C4_nt ::v68(){vfunc_called(this, "_ZN10S1503C4_nt3v68Ev");}
void  S1503C4_nt ::v69(){vfunc_called(this, "_ZN10S1503C4_nt3v69Ev");}
S1503C4_nt ::S1503C4_nt(){ note_ctor("S1503C4_nt", this);} // tgen

//skip512 S1503C4_nt

#else // __cplusplus

extern void _ZN10S1503C4_ntC1Ev();
extern void _ZN10S1503C4_ntD1Ev();
Name_Map name_map_S1503C4_nt[] = {
  NSPAIR(_ZN10S1503C4_ntC1Ev),
  NSPAIR(_ZN10S1503C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1503C4_nt[];
extern void _ZN10S1503C4_ntD1Ev();
extern void _ZN10S1503C4_ntD0Ev();
extern void _ZN10S1503C4_nt2v6Ev();
extern void _ZN10S1503C4_nt2v7Ev();
extern void _ZN10S1503C4_nt2v8Ev();
extern void _ZN10S1503C4_nt2v9Ev();
extern void _ZN10S1503C4_nt3v10Ev();
extern void _ZN10S1503C4_nt3v11Ev();
extern void _ZN10S1503C4_nt3v12Ev();
extern void _ZN10S1503C4_nt3v13Ev();
extern void _ZN10S1503C4_nt3v14Ev();
extern void _ZN10S1503C4_nt3v15Ev();
extern void _ZN10S1503C4_nt3v16Ev();
extern void _ZN10S1503C4_nt3v17Ev();
extern void _ZN10S1503C4_nt3v18Ev();
extern void _ZN10S1503C4_nt3v19Ev();
extern void _ZN10S1503C4_nt3v20Ev();
extern void _ZN10S1503C4_nt3v21Ev();
extern void _ZN10S1503C4_nt3v22Ev();
extern void _ZN10S1503C4_nt3v23Ev();
extern void _ZN10S1503C4_nt3v24Ev();
extern void _ZN10S1503C4_nt3v25Ev();
extern void _ZN10S1503C4_nt3v26Ev();
extern void _ZN10S1503C4_nt3v27Ev();
extern void _ZN10S1503C4_nt3v28Ev();
extern void _ZN10S1503C4_nt3v29Ev();
extern void _ZN10S1503C4_nt3v30Ev();
extern void _ZN10S1503C4_nt3v31Ev();
extern void _ZN10S1503C4_nt3v32Ev();
extern void _ZN10S1503C4_nt3v33Ev();
extern void _ZN10S1503C4_nt3v34Ev();
extern void _ZN10S1503C4_nt3v35Ev();
extern void _ZN10S1503C4_nt3v36Ev();
extern void _ZN10S1503C4_nt3v37Ev();
extern void _ZN10S1503C4_nt3v38Ev();
extern void _ZN10S1503C4_nt3v39Ev();
extern void _ZN10S1503C4_nt3v40Ev();
extern void _ZN10S1503C4_nt3v41Ev();
extern void _ZN10S1503C4_nt3v42Ev();
extern void _ZN10S1503C4_nt3v43Ev();
extern void _ZN10S1503C4_nt3v44Ev();
extern void _ZN10S1503C4_nt3v45Ev();
extern void _ZN10S1503C4_nt3v46Ev();
extern void _ZN10S1503C4_nt3v47Ev();
extern void _ZN10S1503C4_nt3v48Ev();
extern void _ZN10S1503C4_nt3v49Ev();
extern void _ZN10S1503C4_nt3v50Ev();
extern void _ZN10S1503C4_nt3v51Ev();
extern void _ZN10S1503C4_nt3v52Ev();
extern void _ZN10S1503C4_nt3v53Ev();
extern void _ZN10S1503C4_nt3v54Ev();
extern void _ZN10S1503C4_nt3v55Ev();
extern void _ZN10S1503C4_nt3v56Ev();
extern void _ZN10S1503C4_nt3v57Ev();
extern void _ZN10S1503C4_nt3v58Ev();
extern void _ZN10S1503C4_nt3v59Ev();
extern void _ZN10S1503C4_nt3v60Ev();
extern void _ZN10S1503C4_nt3v61Ev();
extern void _ZN10S1503C4_nt3v62Ev();
extern void _ZN10S1503C4_nt3v63Ev();
extern void _ZN10S1503C4_nt3v64Ev();
extern void _ZN10S1503C4_nt3v65Ev();
extern void _ZN10S1503C4_nt3v66Ev();
extern void _ZN10S1503C4_nt3v67Ev();
extern void _ZN10S1503C4_nt3v68Ev();
extern void _ZN10S1503C4_nt3v69Ev();
static  VTBL_ENTRY vtc_S1503C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1503C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1503C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v69Ev,
};
extern VTBL_ENTRY _ZTI10S1503C4_nt[];
VTBL_ENTRY *P__ZTI10S1503C4_nt = _ZTI10S1503C4_nt; 
extern  VTBL_ENTRY _ZTV10S1503C4_nt[];
Class_Descriptor cd_S1503C4_nt = {  "S1503C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1503C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1503C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1503C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C8_nt  {
  void *s1503c8f0;
  int s1503c8f1[2];
  void  mf1503c8(); // _ZN10S1503C8_nt8mf1503c8Ev
};
//SIG(-1 S1503C8_nt) C1{ m Fp Fi[2]}


void  S1503C8_nt ::mf1503c8(){}

//skip512 S1503C8_nt

#else // __cplusplus

Class_Descriptor cd_S1503C8_nt = {  "S1503C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C7_nt  : S1503C8_nt {
};
//SIG(-1 S1503C7_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1503C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
static Base_Class bases_S1503C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1503C7_nt = {  "S1503C7_nt", // class name
  bases_S1503C7_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C6_nt  : S1503C7_nt {
};
//SIG(-1 S1503C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1503C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
extern Class_Descriptor cd_S1503C7_nt;
static Base_Class bases_S1503C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1503C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C9_nt  {
  int s1503c9f0;
  void  mf1503c9(); // _ZN10S1503C9_nt8mf1503c9Ev
};
//SIG(-1 S1503C9_nt) C1{ m Fi}


void  S1503C9_nt ::mf1503c9(){}

//skip512 S1503C9_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S1503C9_nt[];
VTBL_ENTRY *P__ZTI10S1503C9_nt = _ZTI10S1503C9_nt; 
Class_Descriptor cd_S1503C9_nt = {  "S1503C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S1503C9_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C13  : S1503C8_nt {
};
//SIG(-1 S1503C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1503C13()
{
  extern Class_Descriptor cd_S1503C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1503C13, buf);
    S1503C13 &lv = *(new (buf) S1503C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1503C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1503C13)");
    check_base_class_offset(lv, (S1503C8_nt*), 0, "S1503C13");
    test_class_info(&lv, &cd_S1503C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1503C13(Test_S1503C13, "S1503C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
static Base_Class bases_S1503C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1503C13 = {  "S1503C13", // class name
  bases_S1503C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C12  : S1503C13 {
};
//SIG(-1 S1503C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1503C12()
{
  extern Class_Descriptor cd_S1503C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1503C12, buf);
    S1503C12 &lv = *(new (buf) S1503C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1503C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1503C12)");
    check_base_class_offset(lv, (S1503C8_nt*)(S1503C13*), 0, "S1503C12");
    check_base_class_offset(lv, (S1503C13*), 0, "S1503C12");
    test_class_info(&lv, &cd_S1503C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1503C12(Test_S1503C12, "S1503C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
extern Class_Descriptor cd_S1503C13;
static Base_Class bases_S1503C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1503C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1503C12 = {  "S1503C12", // class name
  bases_S1503C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C14_nt  {
  int s1503c14f0[3];
  void  mf1503c14(); // _ZN11S1503C14_nt9mf1503c14Ev
};
//SIG(-1 S1503C14_nt) C1{ m Fi[3]}


void  S1503C14_nt ::mf1503c14(){}

//skip512 S1503C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C19  : S1503C8_nt {
};
//SIG(-1 S1503C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1503C19()
{
  extern Class_Descriptor cd_S1503C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1503C19, buf);
    S1503C19 &lv = *(new (buf) S1503C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1503C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1503C19)");
    check_base_class_offset(lv, (S1503C8_nt*), 0, "S1503C19");
    test_class_info(&lv, &cd_S1503C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1503C19(Test_S1503C19, "S1503C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
static Base_Class bases_S1503C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1503C19 = {  "S1503C19", // class name
  bases_S1503C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C18  : S1503C19 {
};
//SIG(-1 S1503C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1503C18()
{
  extern Class_Descriptor cd_S1503C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1503C18, buf);
    S1503C18 &lv = *(new (buf) S1503C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1503C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1503C18)");
    check_base_class_offset(lv, (S1503C8_nt*)(S1503C19*), 0, "S1503C18");
    check_base_class_offset(lv, (S1503C19*), 0, "S1503C18");
    test_class_info(&lv, &cd_S1503C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1503C18(Test_S1503C18, "S1503C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
extern Class_Descriptor cd_S1503C19;
static Base_Class bases_S1503C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1503C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1503C18 = {  "S1503C18", // class name
  bases_S1503C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C3_nt  : S1503C4_nt {
  ::S1503C6_nt s1503c3f0;
  ::S1503C6_nt s1503c3f1;
  ::S1503C9_nt s1503c3f2;
  int s1503c3f3;
  char s1503c3f4[4];
  void *s1503c3f5[2];
  ::S1503C6_nt s1503c3f6;
  unsigned int s1503c3f7:1;
  unsigned int s1503c3f8:1;
  unsigned int s1503c3f9:1;
  unsigned int s1503c3f10:1;
  unsigned int s1503c3f11:1;
  unsigned int s1503c3f12:1;
  unsigned int s1503c3f13:1;
  unsigned int s1503c3f14:1;
  unsigned int s1503c3f15:1;
  unsigned int s1503c3f16:1;
  unsigned int s1503c3f17:1;
  unsigned int s1503c3f18:1;
  unsigned int s1503c3f19:1;
  unsigned int s1503c3f20:1;
  unsigned int s1503c3f21:1;
  unsigned int s1503c3f22:1;
  unsigned int s1503c3f23:1;
  unsigned int s1503c3f24:1;
  unsigned int s1503c3f25:1;
  unsigned int s1503c3f26:1;
  unsigned int s1503c3f27:1;
  unsigned int s1503c3f28:1;
  unsigned int s1503c3f29:1;
  unsigned int s1503c3f30:1;
  unsigned int s1503c3f31:1;
  unsigned int s1503c3f32:1;
  unsigned int s1503c3f33:1;
  unsigned int s1503c3f34:1;
  unsigned int s1503c3f35:1;
  unsigned int s1503c3f36:1;
  unsigned int s1503c3f37:1;
  unsigned int s1503c3f38:1;
  unsigned int s1503c3f39:1;
  unsigned int s1503c3f40:1;
  unsigned int s1503c3f41:1;
  unsigned int s1503c3f42:1;
  unsigned int s1503c3f43:1;
  unsigned int s1503c3f44:1;
  unsigned int s1503c3f45:1;
  unsigned int s1503c3f46:1;
  unsigned int s1503c3f47:1;
  unsigned int s1503c3f48:1;
  unsigned int s1503c3f49:1;
  unsigned int s1503c3f50:1;
  unsigned int s1503c3f51:1;
  unsigned int s1503c3f52:1;
  unsigned int s1503c3f53:1;
  unsigned int s1503c3f54:1;
  unsigned int s1503c3f55:1;
  unsigned int s1503c3f56:1;
  unsigned int s1503c3f57:1;
  unsigned int s1503c3f58:1;
  unsigned int s1503c3f59:1;
  unsigned int s1503c3f60:1;
  unsigned int s1503c3f61:1;
  unsigned int s1503c3f62:1;
  unsigned int s1503c3f63:1;
  unsigned int s1503c3f64:1;
  unsigned int s1503c3f65:1;
  unsigned int s1503c3f66:1;
  unsigned int s1503c3f67:1;
  unsigned int s1503c3f68:1;
  unsigned int s1503c3f69:1;
  unsigned int s1503c3f70:1;
  unsigned int s1503c3f71:1;
  unsigned int s1503c3f72:1;
  unsigned int s1503c3f73:1;
  unsigned int s1503c3f74:1;
  unsigned int s1503c3f75:1;
  unsigned int s1503c3f76:1;
  unsigned int s1503c3f77:1;
  unsigned int s1503c3f78:1;
  unsigned int s1503c3f79:1;
  unsigned int s1503c3f80:1;
  unsigned int s1503c3f81:1;
  unsigned int s1503c3f82:1;
  unsigned int s1503c3f83:1;
  int s1503c3f84[5];
  void *s1503c3f85[2];
  int s1503c3f86[3];
  ::S1503C5_nt s1503c3f87;
  ::S1503C5_nt s1503c3f88;
  ::S1503C5_nt s1503c3f89;
  ::S1503C12 s1503c3f90;
  ::S1503C12 s1503c3f91;
  int s1503c3f92;
  void *s1503c3f93[2];
  ::S1503C14_nt s1503c3f94;
  ::S1503C14_nt s1503c3f95;
  ::S1503C14_nt s1503c3f96;
  ::S1503C14_nt s1503c3f97;
  void *s1503c3f98;
  ::S1503C5_nt s1503c3f99;
  ::S1503C12 s1503c3f100;
  ::S1503C14_nt s1503c3f101;
  ::S1503C14_nt s1503c3f102;
  int s1503c3f103;
  ::S1503C14_nt s1503c3f104;
  ::S1503C14_nt s1503c3f105;
  void *s1503c3f106;
  int s1503c3f107;
  char s1503c3f108;
  ::S1503C14_nt s1503c3f109;
  ::S1503C14_nt s1503c3f110;
  void *s1503c3f111;
  int s1503c3f112;
  void *s1503c3f113;
  ::S1503C12 s1503c3f114;
  ::S1503C18 s1503c3f115;
  ::S1503C18 s1503c3f116;
  virtual  ~S1503C3_nt(); // _ZN10S1503C3_ntD1Ev
  virtual void  v70(); // _ZN10S1503C3_nt3v70Ev
  virtual void  v71(); // _ZN10S1503C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1503C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1503C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1503C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1503C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1503C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1503C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1503C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1503C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1503C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1503C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1503C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1503C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1503C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1503C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1503C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1503C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1503C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1503C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1503C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1503C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1503C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1503C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1503C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1503C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1503C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1503C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1503C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1503C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1503C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1503C3_nt4v101Ev
  virtual void  v102(); // _ZN10S1503C3_nt4v102Ev
  virtual void  v103(); // _ZN10S1503C3_nt4v103Ev
  virtual void  v104(); // _ZN10S1503C3_nt4v104Ev
  virtual void  v105(); // _ZN10S1503C3_nt4v105Ev
  virtual void  v106(); // _ZN10S1503C3_nt4v106Ev
  virtual void  v107(); // _ZN10S1503C3_nt4v107Ev
  virtual void  v108(); // _ZN10S1503C3_nt4v108Ev
  virtual void  v109(); // _ZN10S1503C3_nt4v109Ev
  virtual void  v110(); // _ZN10S1503C3_nt4v110Ev
  virtual void  v111(); // _ZN10S1503C3_nt4v111Ev
  virtual void  v112(); // _ZN10S1503C3_nt4v112Ev
  virtual void  v113(); // _ZN10S1503C3_nt4v113Ev
  virtual void  v114(); // _ZN10S1503C3_nt4v114Ev
  virtual void  v115(); // _ZN10S1503C3_nt4v115Ev
  virtual void  v116(); // _ZN10S1503C3_nt4v116Ev
  virtual void  v117(); // _ZN10S1503C3_nt4v117Ev
  virtual void  v118(); // _ZN10S1503C3_nt4v118Ev
  virtual void  v119(); // _ZN10S1503C3_nt4v119Ev
  virtual void  v120(); // _ZN10S1503C3_nt4v120Ev
  virtual void  v121(); // _ZN10S1503C3_nt4v121Ev
  virtual void  v122(); // _ZN10S1503C3_nt4v122Ev
  virtual void  v123(); // _ZN10S1503C3_nt4v123Ev
  virtual void  v124(); // _ZN10S1503C3_nt4v124Ev
  virtual void  v125(); // _ZN10S1503C3_nt4v125Ev
  virtual void  v126(); // _ZN10S1503C3_nt4v126Ev
  virtual void  v127(); // _ZN10S1503C3_nt4v127Ev
  virtual void  v128(); // _ZN10S1503C3_nt4v128Ev
  virtual void  v129(); // _ZN10S1503C3_nt4v129Ev
  virtual void  v130(); // _ZN10S1503C3_nt4v130Ev
  virtual void  v131(); // _ZN10S1503C3_nt4v131Ev
  virtual void  v132(); // _ZN10S1503C3_nt4v132Ev
  virtual void  v133(); // _ZN10S1503C3_nt4v133Ev
  virtual void  v134(); // _ZN10S1503C3_nt4v134Ev
  virtual void  v135(); // _ZN10S1503C3_nt4v135Ev
  virtual void  v136(); // _ZN10S1503C3_nt4v136Ev
  virtual void  v137(); // _ZN10S1503C3_nt4v137Ev
  virtual void  v138(); // _ZN10S1503C3_nt4v138Ev
  virtual void  v139(); // _ZN10S1503C3_nt4v139Ev
  virtual void  v140(); // _ZN10S1503C3_nt4v140Ev
  virtual void  v141(); // _ZN10S1503C3_nt4v141Ev
  virtual void  v142(); // _ZN10S1503C3_nt4v142Ev
  virtual void  v143(); // _ZN10S1503C3_nt4v143Ev
  virtual void  v144(); // _ZN10S1503C3_nt4v144Ev
  virtual void  v145(); // _ZN10S1503C3_nt4v145Ev
  virtual void  v146(); // _ZN10S1503C3_nt4v146Ev
  virtual void  v147(); // _ZN10S1503C3_nt4v147Ev
  virtual void  v148(); // _ZN10S1503C3_nt4v148Ev
  virtual void  v149(); // _ZN10S1503C3_nt4v149Ev
  virtual void  v150(); // _ZN10S1503C3_nt4v150Ev
  virtual void  v151(); // _ZN10S1503C3_nt4v151Ev
  virtual void  v152(); // _ZN10S1503C3_nt4v152Ev
  virtual void  v153(); // _ZN10S1503C3_nt4v153Ev
  virtual void  v154(); // _ZN10S1503C3_nt4v154Ev
  virtual void  v155(); // _ZN10S1503C3_nt4v155Ev
  virtual void  v156(); // _ZN10S1503C3_nt4v156Ev
  virtual void  v157(); // _ZN10S1503C3_nt4v157Ev
  virtual void  v158(); // _ZN10S1503C3_nt4v158Ev
  virtual void  v159(); // _ZN10S1503C3_nt4v159Ev
  virtual void  v160(); // _ZN10S1503C3_nt4v160Ev
  virtual void  v161(); // _ZN10S1503C3_nt4v161Ev
  virtual void  v162(); // _ZN10S1503C3_nt4v162Ev
  virtual void  v163(); // _ZN10S1503C3_nt4v163Ev
  virtual void  v164(); // _ZN10S1503C3_nt4v164Ev
  virtual void  v165(); // _ZN10S1503C3_nt4v165Ev
  virtual void  v166(); // _ZN10S1503C3_nt4v166Ev
  virtual void  v167(); // _ZN10S1503C3_nt4v167Ev
  virtual void  v168(); // _ZN10S1503C3_nt4v168Ev
  virtual void  v169(); // _ZN10S1503C3_nt4v169Ev
  virtual void  v170(); // _ZN10S1503C3_nt4v170Ev
  virtual void  v171(); // _ZN10S1503C3_nt4v171Ev
  virtual void  v172(); // _ZN10S1503C3_nt4v172Ev
  virtual void  v173(); // _ZN10S1503C3_nt4v173Ev
  virtual void  v174(); // _ZN10S1503C3_nt4v174Ev
  virtual void  v175(); // _ZN10S1503C3_nt4v175Ev
  virtual void  v176(); // _ZN10S1503C3_nt4v176Ev
  virtual void  v177(); // _ZN10S1503C3_nt4v177Ev
  virtual void  v178(); // _ZN10S1503C3_nt4v178Ev
  virtual void  v179(); // _ZN10S1503C3_nt4v179Ev
  virtual void  v180(); // _ZN10S1503C3_nt4v180Ev
  virtual void  v181(); // _ZN10S1503C3_nt4v181Ev
  virtual void  v182(); // _ZN10S1503C3_nt4v182Ev
  virtual void  v183(); // _ZN10S1503C3_nt4v183Ev
  virtual void  v184(); // _ZN10S1503C3_nt4v184Ev
  virtual void  v185(); // _ZN10S1503C3_nt4v185Ev
  virtual void  v186(); // _ZN10S1503C3_nt4v186Ev
  virtual void  v187(); // _ZN10S1503C3_nt4v187Ev
  virtual void  v188(); // _ZN10S1503C3_nt4v188Ev
  virtual void  v189(); // _ZN10S1503C3_nt4v189Ev
  virtual void  v190(); // _ZN10S1503C3_nt4v190Ev
  virtual void  v191(); // _ZN10S1503C3_nt4v191Ev
  virtual void  v192(); // _ZN10S1503C3_nt4v192Ev
  virtual void  v193(); // _ZN10S1503C3_nt4v193Ev
  virtual void  v194(); // _ZN10S1503C3_nt4v194Ev
  virtual void  v195(); // _ZN10S1503C3_nt4v195Ev
  virtual void  v196(); // _ZN10S1503C3_nt4v196Ev
  virtual void  v197(); // _ZN10S1503C3_nt4v197Ev
  virtual void  v198(); // _ZN10S1503C3_nt4v198Ev
  virtual void  v199(); // _ZN10S1503C3_nt4v199Ev
  virtual void  v200(); // _ZN10S1503C3_nt4v200Ev
  virtual void  v201(); // _ZN10S1503C3_nt4v201Ev
  virtual void  v202(); // _ZN10S1503C3_nt4v202Ev
  virtual void  v203(); // _ZN10S1503C3_nt4v203Ev
  virtual void  v204(); // _ZN10S1503C3_nt4v204Ev
  virtual void  v205(); // _ZN10S1503C3_nt4v205Ev
  virtual void  v206(); // _ZN10S1503C3_nt4v206Ev
  virtual void  v207(); // _ZN10S1503C3_nt4v207Ev
  virtual void  v208(); // _ZN10S1503C3_nt4v208Ev
  virtual void  v209(); // _ZN10S1503C3_nt4v209Ev
  virtual void  v210(); // _ZN10S1503C3_nt4v210Ev
  virtual void  v211(); // _ZN10S1503C3_nt4v211Ev
  virtual void  v212(); // _ZN10S1503C3_nt4v212Ev
  S1503C3_nt(); // tgen
};
//SIG(-1 S1503C3_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S1503C3_nt ::~S1503C3_nt(){ note_dtor("S1503C3_nt", this);}
void  S1503C3_nt ::v70(){vfunc_called(this, "_ZN10S1503C3_nt3v70Ev");}
void  S1503C3_nt ::v71(){vfunc_called(this, "_ZN10S1503C3_nt3v71Ev");}
void  S1503C3_nt ::v72(){vfunc_called(this, "_ZN10S1503C3_nt3v72Ev");}
void  S1503C3_nt ::v73(){vfunc_called(this, "_ZN10S1503C3_nt3v73Ev");}
void  S1503C3_nt ::v74(){vfunc_called(this, "_ZN10S1503C3_nt3v74Ev");}
void  S1503C3_nt ::v75(){vfunc_called(this, "_ZN10S1503C3_nt3v75Ev");}
void  S1503C3_nt ::v76(){vfunc_called(this, "_ZN10S1503C3_nt3v76Ev");}
void  S1503C3_nt ::v77(){vfunc_called(this, "_ZN10S1503C3_nt3v77Ev");}
void  S1503C3_nt ::v78(){vfunc_called(this, "_ZN10S1503C3_nt3v78Ev");}
void  S1503C3_nt ::v79(){vfunc_called(this, "_ZN10S1503C3_nt3v79Ev");}
void  S1503C3_nt ::v80(){vfunc_called(this, "_ZN10S1503C3_nt3v80Ev");}
void  S1503C3_nt ::v81(){vfunc_called(this, "_ZN10S1503C3_nt3v81Ev");}
void  S1503C3_nt ::v82(){vfunc_called(this, "_ZN10S1503C3_nt3v82Ev");}
void  S1503C3_nt ::v83(){vfunc_called(this, "_ZN10S1503C3_nt3v83Ev");}
void  S1503C3_nt ::v84(){vfunc_called(this, "_ZN10S1503C3_nt3v84Ev");}
void  S1503C3_nt ::v85(){vfunc_called(this, "_ZN10S1503C3_nt3v85Ev");}
void  S1503C3_nt ::v86(){vfunc_called(this, "_ZN10S1503C3_nt3v86Ev");}
void  S1503C3_nt ::v87(){vfunc_called(this, "_ZN10S1503C3_nt3v87Ev");}
void  S1503C3_nt ::v88(){vfunc_called(this, "_ZN10S1503C3_nt3v88Ev");}
void  S1503C3_nt ::v89(){vfunc_called(this, "_ZN10S1503C3_nt3v89Ev");}
void  S1503C3_nt ::v90(){vfunc_called(this, "_ZN10S1503C3_nt3v90Ev");}
void  S1503C3_nt ::v91(){vfunc_called(this, "_ZN10S1503C3_nt3v91Ev");}
void  S1503C3_nt ::v92(){vfunc_called(this, "_ZN10S1503C3_nt3v92Ev");}
void  S1503C3_nt ::v93(){vfunc_called(this, "_ZN10S1503C3_nt3v93Ev");}
void  S1503C3_nt ::v94(){vfunc_called(this, "_ZN10S1503C3_nt3v94Ev");}
void  S1503C3_nt ::v95(){vfunc_called(this, "_ZN10S1503C3_nt3v95Ev");}
void  S1503C3_nt ::v96(){vfunc_called(this, "_ZN10S1503C3_nt3v96Ev");}
void  S1503C3_nt ::v97(){vfunc_called(this, "_ZN10S1503C3_nt3v97Ev");}
void  S1503C3_nt ::v98(){vfunc_called(this, "_ZN10S1503C3_nt3v98Ev");}
void  S1503C3_nt ::v99(){vfunc_called(this, "_ZN10S1503C3_nt3v99Ev");}
void  S1503C3_nt ::v100(){vfunc_called(this, "_ZN10S1503C3_nt4v100Ev");}
void  S1503C3_nt ::v101(){vfunc_called(this, "_ZN10S1503C3_nt4v101Ev");}
void  S1503C3_nt ::v102(){vfunc_called(this, "_ZN10S1503C3_nt4v102Ev");}
void  S1503C3_nt ::v103(){vfunc_called(this, "_ZN10S1503C3_nt4v103Ev");}
void  S1503C3_nt ::v104(){vfunc_called(this, "_ZN10S1503C3_nt4v104Ev");}
void  S1503C3_nt ::v105(){vfunc_called(this, "_ZN10S1503C3_nt4v105Ev");}
void  S1503C3_nt ::v106(){vfunc_called(this, "_ZN10S1503C3_nt4v106Ev");}
void  S1503C3_nt ::v107(){vfunc_called(this, "_ZN10S1503C3_nt4v107Ev");}
void  S1503C3_nt ::v108(){vfunc_called(this, "_ZN10S1503C3_nt4v108Ev");}
void  S1503C3_nt ::v109(){vfunc_called(this, "_ZN10S1503C3_nt4v109Ev");}
void  S1503C3_nt ::v110(){vfunc_called(this, "_ZN10S1503C3_nt4v110Ev");}
void  S1503C3_nt ::v111(){vfunc_called(this, "_ZN10S1503C3_nt4v111Ev");}
void  S1503C3_nt ::v112(){vfunc_called(this, "_ZN10S1503C3_nt4v112Ev");}
void  S1503C3_nt ::v113(){vfunc_called(this, "_ZN10S1503C3_nt4v113Ev");}
void  S1503C3_nt ::v114(){vfunc_called(this, "_ZN10S1503C3_nt4v114Ev");}
void  S1503C3_nt ::v115(){vfunc_called(this, "_ZN10S1503C3_nt4v115Ev");}
void  S1503C3_nt ::v116(){vfunc_called(this, "_ZN10S1503C3_nt4v116Ev");}
void  S1503C3_nt ::v117(){vfunc_called(this, "_ZN10S1503C3_nt4v117Ev");}
void  S1503C3_nt ::v118(){vfunc_called(this, "_ZN10S1503C3_nt4v118Ev");}
void  S1503C3_nt ::v119(){vfunc_called(this, "_ZN10S1503C3_nt4v119Ev");}
void  S1503C3_nt ::v120(){vfunc_called(this, "_ZN10S1503C3_nt4v120Ev");}
void  S1503C3_nt ::v121(){vfunc_called(this, "_ZN10S1503C3_nt4v121Ev");}
void  S1503C3_nt ::v122(){vfunc_called(this, "_ZN10S1503C3_nt4v122Ev");}
void  S1503C3_nt ::v123(){vfunc_called(this, "_ZN10S1503C3_nt4v123Ev");}
void  S1503C3_nt ::v124(){vfunc_called(this, "_ZN10S1503C3_nt4v124Ev");}
void  S1503C3_nt ::v125(){vfunc_called(this, "_ZN10S1503C3_nt4v125Ev");}
void  S1503C3_nt ::v126(){vfunc_called(this, "_ZN10S1503C3_nt4v126Ev");}
void  S1503C3_nt ::v127(){vfunc_called(this, "_ZN10S1503C3_nt4v127Ev");}
void  S1503C3_nt ::v128(){vfunc_called(this, "_ZN10S1503C3_nt4v128Ev");}
void  S1503C3_nt ::v129(){vfunc_called(this, "_ZN10S1503C3_nt4v129Ev");}
void  S1503C3_nt ::v130(){vfunc_called(this, "_ZN10S1503C3_nt4v130Ev");}
void  S1503C3_nt ::v131(){vfunc_called(this, "_ZN10S1503C3_nt4v131Ev");}
void  S1503C3_nt ::v132(){vfunc_called(this, "_ZN10S1503C3_nt4v132Ev");}
void  S1503C3_nt ::v133(){vfunc_called(this, "_ZN10S1503C3_nt4v133Ev");}
void  S1503C3_nt ::v134(){vfunc_called(this, "_ZN10S1503C3_nt4v134Ev");}
void  S1503C3_nt ::v135(){vfunc_called(this, "_ZN10S1503C3_nt4v135Ev");}
void  S1503C3_nt ::v136(){vfunc_called(this, "_ZN10S1503C3_nt4v136Ev");}
void  S1503C3_nt ::v137(){vfunc_called(this, "_ZN10S1503C3_nt4v137Ev");}
void  S1503C3_nt ::v138(){vfunc_called(this, "_ZN10S1503C3_nt4v138Ev");}
void  S1503C3_nt ::v139(){vfunc_called(this, "_ZN10S1503C3_nt4v139Ev");}
void  S1503C3_nt ::v140(){vfunc_called(this, "_ZN10S1503C3_nt4v140Ev");}
void  S1503C3_nt ::v141(){vfunc_called(this, "_ZN10S1503C3_nt4v141Ev");}
void  S1503C3_nt ::v142(){vfunc_called(this, "_ZN10S1503C3_nt4v142Ev");}
void  S1503C3_nt ::v143(){vfunc_called(this, "_ZN10S1503C3_nt4v143Ev");}
void  S1503C3_nt ::v144(){vfunc_called(this, "_ZN10S1503C3_nt4v144Ev");}
void  S1503C3_nt ::v145(){vfunc_called(this, "_ZN10S1503C3_nt4v145Ev");}
void  S1503C3_nt ::v146(){vfunc_called(this, "_ZN10S1503C3_nt4v146Ev");}
void  S1503C3_nt ::v147(){vfunc_called(this, "_ZN10S1503C3_nt4v147Ev");}
void  S1503C3_nt ::v148(){vfunc_called(this, "_ZN10S1503C3_nt4v148Ev");}
void  S1503C3_nt ::v149(){vfunc_called(this, "_ZN10S1503C3_nt4v149Ev");}
void  S1503C3_nt ::v150(){vfunc_called(this, "_ZN10S1503C3_nt4v150Ev");}
void  S1503C3_nt ::v151(){vfunc_called(this, "_ZN10S1503C3_nt4v151Ev");}
void  S1503C3_nt ::v152(){vfunc_called(this, "_ZN10S1503C3_nt4v152Ev");}
void  S1503C3_nt ::v153(){vfunc_called(this, "_ZN10S1503C3_nt4v153Ev");}
void  S1503C3_nt ::v154(){vfunc_called(this, "_ZN10S1503C3_nt4v154Ev");}
void  S1503C3_nt ::v155(){vfunc_called(this, "_ZN10S1503C3_nt4v155Ev");}
void  S1503C3_nt ::v156(){vfunc_called(this, "_ZN10S1503C3_nt4v156Ev");}
void  S1503C3_nt ::v157(){vfunc_called(this, "_ZN10S1503C3_nt4v157Ev");}
void  S1503C3_nt ::v158(){vfunc_called(this, "_ZN10S1503C3_nt4v158Ev");}
void  S1503C3_nt ::v159(){vfunc_called(this, "_ZN10S1503C3_nt4v159Ev");}
void  S1503C3_nt ::v160(){vfunc_called(this, "_ZN10S1503C3_nt4v160Ev");}
void  S1503C3_nt ::v161(){vfunc_called(this, "_ZN10S1503C3_nt4v161Ev");}
void  S1503C3_nt ::v162(){vfunc_called(this, "_ZN10S1503C3_nt4v162Ev");}
void  S1503C3_nt ::v163(){vfunc_called(this, "_ZN10S1503C3_nt4v163Ev");}
void  S1503C3_nt ::v164(){vfunc_called(this, "_ZN10S1503C3_nt4v164Ev");}
void  S1503C3_nt ::v165(){vfunc_called(this, "_ZN10S1503C3_nt4v165Ev");}
void  S1503C3_nt ::v166(){vfunc_called(this, "_ZN10S1503C3_nt4v166Ev");}
void  S1503C3_nt ::v167(){vfunc_called(this, "_ZN10S1503C3_nt4v167Ev");}
void  S1503C3_nt ::v168(){vfunc_called(this, "_ZN10S1503C3_nt4v168Ev");}
void  S1503C3_nt ::v169(){vfunc_called(this, "_ZN10S1503C3_nt4v169Ev");}
void  S1503C3_nt ::v170(){vfunc_called(this, "_ZN10S1503C3_nt4v170Ev");}
void  S1503C3_nt ::v171(){vfunc_called(this, "_ZN10S1503C3_nt4v171Ev");}
void  S1503C3_nt ::v172(){vfunc_called(this, "_ZN10S1503C3_nt4v172Ev");}
void  S1503C3_nt ::v173(){vfunc_called(this, "_ZN10S1503C3_nt4v173Ev");}
void  S1503C3_nt ::v174(){vfunc_called(this, "_ZN10S1503C3_nt4v174Ev");}
void  S1503C3_nt ::v175(){vfunc_called(this, "_ZN10S1503C3_nt4v175Ev");}
void  S1503C3_nt ::v176(){vfunc_called(this, "_ZN10S1503C3_nt4v176Ev");}
void  S1503C3_nt ::v177(){vfunc_called(this, "_ZN10S1503C3_nt4v177Ev");}
void  S1503C3_nt ::v178(){vfunc_called(this, "_ZN10S1503C3_nt4v178Ev");}
void  S1503C3_nt ::v179(){vfunc_called(this, "_ZN10S1503C3_nt4v179Ev");}
void  S1503C3_nt ::v180(){vfunc_called(this, "_ZN10S1503C3_nt4v180Ev");}
void  S1503C3_nt ::v181(){vfunc_called(this, "_ZN10S1503C3_nt4v181Ev");}
void  S1503C3_nt ::v182(){vfunc_called(this, "_ZN10S1503C3_nt4v182Ev");}
void  S1503C3_nt ::v183(){vfunc_called(this, "_ZN10S1503C3_nt4v183Ev");}
void  S1503C3_nt ::v184(){vfunc_called(this, "_ZN10S1503C3_nt4v184Ev");}
void  S1503C3_nt ::v185(){vfunc_called(this, "_ZN10S1503C3_nt4v185Ev");}
void  S1503C3_nt ::v186(){vfunc_called(this, "_ZN10S1503C3_nt4v186Ev");}
void  S1503C3_nt ::v187(){vfunc_called(this, "_ZN10S1503C3_nt4v187Ev");}
void  S1503C3_nt ::v188(){vfunc_called(this, "_ZN10S1503C3_nt4v188Ev");}
void  S1503C3_nt ::v189(){vfunc_called(this, "_ZN10S1503C3_nt4v189Ev");}
void  S1503C3_nt ::v190(){vfunc_called(this, "_ZN10S1503C3_nt4v190Ev");}
void  S1503C3_nt ::v191(){vfunc_called(this, "_ZN10S1503C3_nt4v191Ev");}
void  S1503C3_nt ::v192(){vfunc_called(this, "_ZN10S1503C3_nt4v192Ev");}
void  S1503C3_nt ::v193(){vfunc_called(this, "_ZN10S1503C3_nt4v193Ev");}
void  S1503C3_nt ::v194(){vfunc_called(this, "_ZN10S1503C3_nt4v194Ev");}
void  S1503C3_nt ::v195(){vfunc_called(this, "_ZN10S1503C3_nt4v195Ev");}
void  S1503C3_nt ::v196(){vfunc_called(this, "_ZN10S1503C3_nt4v196Ev");}
void  S1503C3_nt ::v197(){vfunc_called(this, "_ZN10S1503C3_nt4v197Ev");}
void  S1503C3_nt ::v198(){vfunc_called(this, "_ZN10S1503C3_nt4v198Ev");}
void  S1503C3_nt ::v199(){vfunc_called(this, "_ZN10S1503C3_nt4v199Ev");}
void  S1503C3_nt ::v200(){vfunc_called(this, "_ZN10S1503C3_nt4v200Ev");}
void  S1503C3_nt ::v201(){vfunc_called(this, "_ZN10S1503C3_nt4v201Ev");}
void  S1503C3_nt ::v202(){vfunc_called(this, "_ZN10S1503C3_nt4v202Ev");}
void  S1503C3_nt ::v203(){vfunc_called(this, "_ZN10S1503C3_nt4v203Ev");}
void  S1503C3_nt ::v204(){vfunc_called(this, "_ZN10S1503C3_nt4v204Ev");}
void  S1503C3_nt ::v205(){vfunc_called(this, "_ZN10S1503C3_nt4v205Ev");}
void  S1503C3_nt ::v206(){vfunc_called(this, "_ZN10S1503C3_nt4v206Ev");}
void  S1503C3_nt ::v207(){vfunc_called(this, "_ZN10S1503C3_nt4v207Ev");}
void  S1503C3_nt ::v208(){vfunc_called(this, "_ZN10S1503C3_nt4v208Ev");}
void  S1503C3_nt ::v209(){vfunc_called(this, "_ZN10S1503C3_nt4v209Ev");}
void  S1503C3_nt ::v210(){vfunc_called(this, "_ZN10S1503C3_nt4v210Ev");}
void  S1503C3_nt ::v211(){vfunc_called(this, "_ZN10S1503C3_nt4v211Ev");}
void  S1503C3_nt ::v212(){vfunc_called(this, "_ZN10S1503C3_nt4v212Ev");}
S1503C3_nt ::S1503C3_nt(){ note_ctor("S1503C3_nt", this);} // tgen

//skip512 S1503C3_nt

#else // __cplusplus

extern void _ZN10S1503C3_ntC1Ev();
extern void _ZN10S1503C3_ntD1Ev();
Name_Map name_map_S1503C3_nt[] = {
  NSPAIR(_ZN10S1503C3_ntC1Ev),
  NSPAIR(_ZN10S1503C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1503C4_nt;
extern VTBL_ENTRY _ZTI10S1503C4_nt[];
extern  VTBL_ENTRY _ZTV10S1503C4_nt[];
static Base_Class bases_S1503C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1503C3_nt[];
extern void _ZN10S1503C3_ntD1Ev();
extern void _ZN10S1503C3_ntD0Ev();
extern void _ZN10S1503C4_nt2v6Ev();
extern void _ZN10S1503C4_nt2v7Ev();
extern void _ZN10S1503C4_nt2v8Ev();
extern void _ZN10S1503C4_nt2v9Ev();
extern void _ZN10S1503C4_nt3v10Ev();
extern void _ZN10S1503C4_nt3v11Ev();
extern void _ZN10S1503C4_nt3v12Ev();
extern void _ZN10S1503C4_nt3v13Ev();
extern void _ZN10S1503C4_nt3v14Ev();
extern void _ZN10S1503C4_nt3v15Ev();
extern void _ZN10S1503C4_nt3v16Ev();
extern void _ZN10S1503C4_nt3v17Ev();
extern void _ZN10S1503C4_nt3v18Ev();
extern void _ZN10S1503C4_nt3v19Ev();
extern void _ZN10S1503C4_nt3v20Ev();
extern void _ZN10S1503C4_nt3v21Ev();
extern void _ZN10S1503C4_nt3v22Ev();
extern void _ZN10S1503C4_nt3v23Ev();
extern void _ZN10S1503C4_nt3v24Ev();
extern void _ZN10S1503C4_nt3v25Ev();
extern void _ZN10S1503C4_nt3v26Ev();
extern void _ZN10S1503C4_nt3v27Ev();
extern void _ZN10S1503C4_nt3v28Ev();
extern void _ZN10S1503C4_nt3v29Ev();
extern void _ZN10S1503C4_nt3v30Ev();
extern void _ZN10S1503C4_nt3v31Ev();
extern void _ZN10S1503C4_nt3v32Ev();
extern void _ZN10S1503C4_nt3v33Ev();
extern void _ZN10S1503C4_nt3v34Ev();
extern void _ZN10S1503C4_nt3v35Ev();
extern void _ZN10S1503C4_nt3v36Ev();
extern void _ZN10S1503C4_nt3v37Ev();
extern void _ZN10S1503C4_nt3v38Ev();
extern void _ZN10S1503C4_nt3v39Ev();
extern void _ZN10S1503C4_nt3v40Ev();
extern void _ZN10S1503C4_nt3v41Ev();
extern void _ZN10S1503C4_nt3v42Ev();
extern void _ZN10S1503C4_nt3v43Ev();
extern void _ZN10S1503C4_nt3v44Ev();
extern void _ZN10S1503C4_nt3v45Ev();
extern void _ZN10S1503C4_nt3v46Ev();
extern void _ZN10S1503C4_nt3v47Ev();
extern void _ZN10S1503C4_nt3v48Ev();
extern void _ZN10S1503C4_nt3v49Ev();
extern void _ZN10S1503C4_nt3v50Ev();
extern void _ZN10S1503C4_nt3v51Ev();
extern void _ZN10S1503C4_nt3v52Ev();
extern void _ZN10S1503C4_nt3v53Ev();
extern void _ZN10S1503C4_nt3v54Ev();
extern void _ZN10S1503C4_nt3v55Ev();
extern void _ZN10S1503C4_nt3v56Ev();
extern void _ZN10S1503C4_nt3v57Ev();
extern void _ZN10S1503C4_nt3v58Ev();
extern void _ZN10S1503C4_nt3v59Ev();
extern void _ZN10S1503C4_nt3v60Ev();
extern void _ZN10S1503C4_nt3v61Ev();
extern void _ZN10S1503C4_nt3v62Ev();
extern void _ZN10S1503C4_nt3v63Ev();
extern void _ZN10S1503C4_nt3v64Ev();
extern void _ZN10S1503C4_nt3v65Ev();
extern void _ZN10S1503C4_nt3v66Ev();
extern void _ZN10S1503C4_nt3v67Ev();
extern void _ZN10S1503C4_nt3v68Ev();
extern void _ZN10S1503C4_nt3v69Ev();
extern void _ZN10S1503C3_nt3v70Ev();
extern void _ZN10S1503C3_nt3v71Ev();
extern void _ZN10S1503C3_nt3v72Ev();
extern void _ZN10S1503C3_nt3v73Ev();
extern void _ZN10S1503C3_nt3v74Ev();
extern void _ZN10S1503C3_nt3v75Ev();
extern void _ZN10S1503C3_nt3v76Ev();
extern void _ZN10S1503C3_nt3v77Ev();
extern void _ZN10S1503C3_nt3v78Ev();
extern void _ZN10S1503C3_nt3v79Ev();
extern void _ZN10S1503C3_nt3v80Ev();
extern void _ZN10S1503C3_nt3v81Ev();
extern void _ZN10S1503C3_nt3v82Ev();
extern void _ZN10S1503C3_nt3v83Ev();
extern void _ZN10S1503C3_nt3v84Ev();
extern void _ZN10S1503C3_nt3v85Ev();
extern void _ZN10S1503C3_nt3v86Ev();
extern void _ZN10S1503C3_nt3v87Ev();
extern void _ZN10S1503C3_nt3v88Ev();
extern void _ZN10S1503C3_nt3v89Ev();
extern void _ZN10S1503C3_nt3v90Ev();
extern void _ZN10S1503C3_nt3v91Ev();
extern void _ZN10S1503C3_nt3v92Ev();
extern void _ZN10S1503C3_nt3v93Ev();
extern void _ZN10S1503C3_nt3v94Ev();
extern void _ZN10S1503C3_nt3v95Ev();
extern void _ZN10S1503C3_nt3v96Ev();
extern void _ZN10S1503C3_nt3v97Ev();
extern void _ZN10S1503C3_nt3v98Ev();
extern void _ZN10S1503C3_nt3v99Ev();
extern void _ZN10S1503C3_nt4v100Ev();
extern void _ZN10S1503C3_nt4v101Ev();
extern void _ZN10S1503C3_nt4v102Ev();
extern void _ZN10S1503C3_nt4v103Ev();
extern void _ZN10S1503C3_nt4v104Ev();
extern void _ZN10S1503C3_nt4v105Ev();
extern void _ZN10S1503C3_nt4v106Ev();
extern void _ZN10S1503C3_nt4v107Ev();
extern void _ZN10S1503C3_nt4v108Ev();
extern void _ZN10S1503C3_nt4v109Ev();
extern void _ZN10S1503C3_nt4v110Ev();
extern void _ZN10S1503C3_nt4v111Ev();
extern void _ZN10S1503C3_nt4v112Ev();
extern void _ZN10S1503C3_nt4v113Ev();
extern void _ZN10S1503C3_nt4v114Ev();
extern void _ZN10S1503C3_nt4v115Ev();
extern void _ZN10S1503C3_nt4v116Ev();
extern void _ZN10S1503C3_nt4v117Ev();
extern void _ZN10S1503C3_nt4v118Ev();
extern void _ZN10S1503C3_nt4v119Ev();
extern void _ZN10S1503C3_nt4v120Ev();
extern void _ZN10S1503C3_nt4v121Ev();
extern void _ZN10S1503C3_nt4v122Ev();
extern void _ZN10S1503C3_nt4v123Ev();
extern void _ZN10S1503C3_nt4v124Ev();
extern void _ZN10S1503C3_nt4v125Ev();
extern void _ZN10S1503C3_nt4v126Ev();
extern void _ZN10S1503C3_nt4v127Ev();
extern void _ZN10S1503C3_nt4v128Ev();
extern void _ZN10S1503C3_nt4v129Ev();
extern void _ZN10S1503C3_nt4v130Ev();
extern void _ZN10S1503C3_nt4v131Ev();
extern void _ZN10S1503C3_nt4v132Ev();
extern void _ZN10S1503C3_nt4v133Ev();
extern void _ZN10S1503C3_nt4v134Ev();
extern void _ZN10S1503C3_nt4v135Ev();
extern void _ZN10S1503C3_nt4v136Ev();
extern void _ZN10S1503C3_nt4v137Ev();
extern void _ZN10S1503C3_nt4v138Ev();
extern void _ZN10S1503C3_nt4v139Ev();
extern void _ZN10S1503C3_nt4v140Ev();
extern void _ZN10S1503C3_nt4v141Ev();
extern void _ZN10S1503C3_nt4v142Ev();
extern void _ZN10S1503C3_nt4v143Ev();
extern void _ZN10S1503C3_nt4v144Ev();
extern void _ZN10S1503C3_nt4v145Ev();
extern void _ZN10S1503C3_nt4v146Ev();
extern void _ZN10S1503C3_nt4v147Ev();
extern void _ZN10S1503C3_nt4v148Ev();
extern void _ZN10S1503C3_nt4v149Ev();
extern void _ZN10S1503C3_nt4v150Ev();
extern void _ZN10S1503C3_nt4v151Ev();
extern void _ZN10S1503C3_nt4v152Ev();
extern void _ZN10S1503C3_nt4v153Ev();
extern void _ZN10S1503C3_nt4v154Ev();
extern void _ZN10S1503C3_nt4v155Ev();
extern void _ZN10S1503C3_nt4v156Ev();
extern void _ZN10S1503C3_nt4v157Ev();
extern void _ZN10S1503C3_nt4v158Ev();
extern void _ZN10S1503C3_nt4v159Ev();
extern void _ZN10S1503C3_nt4v160Ev();
extern void _ZN10S1503C3_nt4v161Ev();
extern void _ZN10S1503C3_nt4v162Ev();
extern void _ZN10S1503C3_nt4v163Ev();
extern void _ZN10S1503C3_nt4v164Ev();
extern void _ZN10S1503C3_nt4v165Ev();
extern void _ZN10S1503C3_nt4v166Ev();
extern void _ZN10S1503C3_nt4v167Ev();
extern void _ZN10S1503C3_nt4v168Ev();
extern void _ZN10S1503C3_nt4v169Ev();
extern void _ZN10S1503C3_nt4v170Ev();
extern void _ZN10S1503C3_nt4v171Ev();
extern void _ZN10S1503C3_nt4v172Ev();
extern void _ZN10S1503C3_nt4v173Ev();
extern void _ZN10S1503C3_nt4v174Ev();
extern void _ZN10S1503C3_nt4v175Ev();
extern void _ZN10S1503C3_nt4v176Ev();
extern void _ZN10S1503C3_nt4v177Ev();
extern void _ZN10S1503C3_nt4v178Ev();
extern void _ZN10S1503C3_nt4v179Ev();
extern void _ZN10S1503C3_nt4v180Ev();
extern void _ZN10S1503C3_nt4v181Ev();
extern void _ZN10S1503C3_nt4v182Ev();
extern void _ZN10S1503C3_nt4v183Ev();
extern void _ZN10S1503C3_nt4v184Ev();
extern void _ZN10S1503C3_nt4v185Ev();
extern void _ZN10S1503C3_nt4v186Ev();
extern void _ZN10S1503C3_nt4v187Ev();
extern void _ZN10S1503C3_nt4v188Ev();
extern void _ZN10S1503C3_nt4v189Ev();
extern void _ZN10S1503C3_nt4v190Ev();
extern void _ZN10S1503C3_nt4v191Ev();
extern void _ZN10S1503C3_nt4v192Ev();
extern void _ZN10S1503C3_nt4v193Ev();
extern void _ZN10S1503C3_nt4v194Ev();
extern void _ZN10S1503C3_nt4v195Ev();
extern void _ZN10S1503C3_nt4v196Ev();
extern void _ZN10S1503C3_nt4v197Ev();
extern void _ZN10S1503C3_nt4v198Ev();
extern void _ZN10S1503C3_nt4v199Ev();
extern void _ZN10S1503C3_nt4v200Ev();
extern void _ZN10S1503C3_nt4v201Ev();
extern void _ZN10S1503C3_nt4v202Ev();
extern void _ZN10S1503C3_nt4v203Ev();
extern void _ZN10S1503C3_nt4v204Ev();
extern void _ZN10S1503C3_nt4v205Ev();
extern void _ZN10S1503C3_nt4v206Ev();
extern void _ZN10S1503C3_nt4v207Ev();
extern void _ZN10S1503C3_nt4v208Ev();
extern void _ZN10S1503C3_nt4v209Ev();
extern void _ZN10S1503C3_nt4v210Ev();
extern void _ZN10S1503C3_nt4v211Ev();
extern void _ZN10S1503C3_nt4v212Ev();
static  VTBL_ENTRY vtc_S1503C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1503C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1503C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v212Ev,
};
extern VTBL_ENTRY _ZTI10S1503C3_nt[];
VTBL_ENTRY *P__ZTI10S1503C3_nt = _ZTI10S1503C3_nt; 
extern  VTBL_ENTRY _ZTV10S1503C3_nt[];
Class_Descriptor cd_S1503C3_nt = {  "S1503C3_nt", // class name
  bases_S1503C3_nt, 1,
  &(vtc_S1503C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1503C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1503C3_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C23_nt  {
  ::S1503C14_nt s1503c23f0;
  ::S1503C14_nt s1503c23f1;
  char s1503c23f2;
  void  mf1503c23(); // _ZN11S1503C23_nt9mf1503c23Ev
};
//SIG(-1 S1503C23_nt) C1{ m FC2{ m Fi[3]} FC2 Fc}


void  S1503C23_nt ::mf1503c23(){}

//skip512 S1503C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C22_nt  {
  ::S1503C23_nt s1503c22f0;
  ::S1503C14_nt s1503c22f1;
  void *s1503c22f2[2];
  char s1503c22f3;
  void  mf1503c22(); // _ZN11S1503C22_nt9mf1503c22Ev
};
//SIG(-1 S1503C22_nt) C1{ m FC2{ m FC3{ m Fi[3]} FC3 Fc} FC3 Fp[2] Fc}


void  S1503C22_nt ::mf1503c22(){}

//skip512 S1503C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C25  : S1503C8_nt {
};
//SIG(-1 S1503C25) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1503C25()
{
  extern Class_Descriptor cd_S1503C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1503C25, buf);
    S1503C25 &lv = *(new (buf) S1503C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1503C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1503C25)");
    check_base_class_offset(lv, (S1503C8_nt*), 0, "S1503C25");
    test_class_info(&lv, &cd_S1503C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1503C25(Test_S1503C25, "S1503C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
static Base_Class bases_S1503C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1503C25 = {  "S1503C25", // class name
  bases_S1503C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C24  : S1503C25 {
};
//SIG(-1 S1503C24) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1503C24()
{
  extern Class_Descriptor cd_S1503C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1503C24, buf);
    S1503C24 &lv = *(new (buf) S1503C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1503C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1503C24)");
    check_base_class_offset(lv, (S1503C8_nt*)(S1503C25*), 0, "S1503C24");
    check_base_class_offset(lv, (S1503C25*), 0, "S1503C24");
    test_class_info(&lv, &cd_S1503C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1503C24(Test_S1503C24, "S1503C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
extern Class_Descriptor cd_S1503C25;
static Base_Class bases_S1503C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1503C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1503C24 = {  "S1503C24", // class name
  bases_S1503C24, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C29  : S1503C8_nt {
};
//SIG(-1 S1503C29) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1503C29()
{
  extern Class_Descriptor cd_S1503C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1503C29, buf);
    S1503C29 &lv = *(new (buf) S1503C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1503C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1503C29)");
    check_base_class_offset(lv, (S1503C8_nt*), 0, "S1503C29");
    test_class_info(&lv, &cd_S1503C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1503C29(Test_S1503C29, "S1503C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
static Base_Class bases_S1503C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1503C29 = {  "S1503C29", // class name
  bases_S1503C29, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C28  : S1503C29 {
};
//SIG(-1 S1503C28) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1503C28()
{
  extern Class_Descriptor cd_S1503C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1503C28, buf);
    S1503C28 &lv = *(new (buf) S1503C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1503C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1503C28)");
    check_base_class_offset(lv, (S1503C8_nt*)(S1503C29*), 0, "S1503C28");
    check_base_class_offset(lv, (S1503C29*), 0, "S1503C28");
    test_class_info(&lv, &cd_S1503C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1503C28(Test_S1503C28, "S1503C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
extern Class_Descriptor cd_S1503C29;
static Base_Class bases_S1503C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1503C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1503C28 = {  "S1503C28", // class name
  bases_S1503C28, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C31_nt  {
  int s1503c31f0[4];
  void  mf1503c31(); // _ZN11S1503C31_nt9mf1503c31Ev
};
//SIG(-1 S1503C31_nt) C1{ m Fi[4]}


void  S1503C31_nt ::mf1503c31(){}

//skip512 S1503C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C2_nt  : S1503C3_nt {
  unsigned int s1503c2f0:1;
  unsigned int s1503c2f1:1;
  unsigned int s1503c2f2:1;
  unsigned int s1503c2f3:1;
  unsigned int s1503c2f4:1;
  ::S1503C22_nt s1503c2f5;
  unsigned int s1503c2f6:1;
  unsigned int s1503c2f7:1;
  unsigned int s1503c2f8:1;
  unsigned int s1503c2f9:1;
  unsigned int s1503c2f10:1;
  unsigned int s1503c2f11:1;
  unsigned int s1503c2f12:1;
  unsigned int s1503c2f13:1;
  unsigned int s1503c2f14:1;
  unsigned int s1503c2f15:1;
  unsigned int s1503c2f16:1;
  unsigned int s1503c2f17:1;
  unsigned int s1503c2f18:1;
  unsigned int s1503c2f19:1;
  unsigned int s1503c2f20:1;
  unsigned int s1503c2f21:1;
  unsigned int s1503c2f22:1;
  unsigned int s1503c2f23:1;
  unsigned int s1503c2f24:1;
  unsigned int s1503c2f25:1;
  unsigned int s1503c2f26:1;
  unsigned int s1503c2f27:1;
  unsigned int s1503c2f28:1;
  unsigned int s1503c2f29:1;
  unsigned int s1503c2f30:1;
  ::S1503C24 s1503c2f31;
  ::S1503C24 s1503c2f32;
  ::S1503C24 s1503c2f33;
  ::S1503C28 s1503c2f34;
  int s1503c2f35[2];
  void *s1503c2f36[4];
  int s1503c2f37[5];
  void *s1503c2f38;
  int s1503c2f39[2];
  void *s1503c2f40[2];
  int s1503c2f41;
  ::S1503C5_nt s1503c2f42;
  ::S1503C31_nt s1503c2f43;
  void *s1503c2f44[2];
  int s1503c2f45;
  void *s1503c2f46;
  int s1503c2f47;
  virtual  ~S1503C2_nt(); // _ZN10S1503C2_ntD1Ev
  virtual void  v213(); // _ZN10S1503C2_nt4v213Ev
  virtual void  v214(); // _ZN10S1503C2_nt4v214Ev
  virtual void  v215(); // _ZN10S1503C2_nt4v215Ev
  virtual void  v216(); // _ZN10S1503C2_nt4v216Ev
  virtual void  v217(); // _ZN10S1503C2_nt4v217Ev
  virtual void  v218(); // _ZN10S1503C2_nt4v218Ev
  virtual void  v219(); // _ZN10S1503C2_nt4v219Ev
  virtual void  v220(); // _ZN10S1503C2_nt4v220Ev
  virtual void  v221(); // _ZN10S1503C2_nt4v221Ev
  virtual void  v222(); // _ZN10S1503C2_nt4v222Ev
  virtual void  v223(); // _ZN10S1503C2_nt4v223Ev
  virtual void  v224(); // _ZN10S1503C2_nt4v224Ev
  virtual void  v225(); // _ZN10S1503C2_nt4v225Ev
  virtual void  v226(); // _ZN10S1503C2_nt4v226Ev
  virtual void  v227(); // _ZN10S1503C2_nt4v227Ev
  virtual void  v228(); // _ZN10S1503C2_nt4v228Ev
  virtual void  v229(); // _ZN10S1503C2_nt4v229Ev
  virtual void  v230(); // _ZN10S1503C2_nt4v230Ev
  virtual void  v231(); // _ZN10S1503C2_nt4v231Ev
  virtual void  v232(); // _ZN10S1503C2_nt4v232Ev
  virtual void  v233(); // _ZN10S1503C2_nt4v233Ev
  virtual void  v234(); // _ZN10S1503C2_nt4v234Ev
  virtual void  v235(); // _ZN10S1503C2_nt4v235Ev
  virtual void  v236(); // _ZN10S1503C2_nt4v236Ev
  virtual void  v237(); // _ZN10S1503C2_nt4v237Ev
  virtual void  v238(); // _ZN10S1503C2_nt4v238Ev
  virtual void  v239(); // _ZN10S1503C2_nt4v239Ev
  virtual void  v240(); // _ZN10S1503C2_nt4v240Ev
  virtual void  v241(); // _ZN10S1503C2_nt4v241Ev
  virtual void  v242(); // _ZN10S1503C2_nt4v242Ev
  virtual void  v243(); // _ZN10S1503C2_nt4v243Ev
  virtual void  v244(); // _ZN10S1503C2_nt4v244Ev
  virtual void  v245(); // _ZN10S1503C2_nt4v245Ev
  virtual void  v246(); // _ZN10S1503C2_nt4v246Ev
  virtual void  v247(); // _ZN10S1503C2_nt4v247Ev
  virtual void  v248(); // _ZN10S1503C2_nt4v248Ev
  virtual void  v249(); // _ZN10S1503C2_nt4v249Ev
  S1503C2_nt(); // tgen
};
//SIG(-1 S1503C2_nt) C1{ BC2{ BC3{ vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ m FC15{ m FC11 FC11 Fc} FC11 Fp[2] Fc} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC17{ BC7}} FC16 FC16 FC18{ BC19{ BC7}} Fi[2] Fp[4] Fi[5] Fp Fi[2] Fp[2] Fi FC4 FC20{ m Fi[4]} Fp[2] Fi Fp Fi}


 S1503C2_nt ::~S1503C2_nt(){ note_dtor("S1503C2_nt", this);}
void  S1503C2_nt ::v213(){vfunc_called(this, "_ZN10S1503C2_nt4v213Ev");}
void  S1503C2_nt ::v214(){vfunc_called(this, "_ZN10S1503C2_nt4v214Ev");}
void  S1503C2_nt ::v215(){vfunc_called(this, "_ZN10S1503C2_nt4v215Ev");}
void  S1503C2_nt ::v216(){vfunc_called(this, "_ZN10S1503C2_nt4v216Ev");}
void  S1503C2_nt ::v217(){vfunc_called(this, "_ZN10S1503C2_nt4v217Ev");}
void  S1503C2_nt ::v218(){vfunc_called(this, "_ZN10S1503C2_nt4v218Ev");}
void  S1503C2_nt ::v219(){vfunc_called(this, "_ZN10S1503C2_nt4v219Ev");}
void  S1503C2_nt ::v220(){vfunc_called(this, "_ZN10S1503C2_nt4v220Ev");}
void  S1503C2_nt ::v221(){vfunc_called(this, "_ZN10S1503C2_nt4v221Ev");}
void  S1503C2_nt ::v222(){vfunc_called(this, "_ZN10S1503C2_nt4v222Ev");}
void  S1503C2_nt ::v223(){vfunc_called(this, "_ZN10S1503C2_nt4v223Ev");}
void  S1503C2_nt ::v224(){vfunc_called(this, "_ZN10S1503C2_nt4v224Ev");}
void  S1503C2_nt ::v225(){vfunc_called(this, "_ZN10S1503C2_nt4v225Ev");}
void  S1503C2_nt ::v226(){vfunc_called(this, "_ZN10S1503C2_nt4v226Ev");}
void  S1503C2_nt ::v227(){vfunc_called(this, "_ZN10S1503C2_nt4v227Ev");}
void  S1503C2_nt ::v228(){vfunc_called(this, "_ZN10S1503C2_nt4v228Ev");}
void  S1503C2_nt ::v229(){vfunc_called(this, "_ZN10S1503C2_nt4v229Ev");}
void  S1503C2_nt ::v230(){vfunc_called(this, "_ZN10S1503C2_nt4v230Ev");}
void  S1503C2_nt ::v231(){vfunc_called(this, "_ZN10S1503C2_nt4v231Ev");}
void  S1503C2_nt ::v232(){vfunc_called(this, "_ZN10S1503C2_nt4v232Ev");}
void  S1503C2_nt ::v233(){vfunc_called(this, "_ZN10S1503C2_nt4v233Ev");}
void  S1503C2_nt ::v234(){vfunc_called(this, "_ZN10S1503C2_nt4v234Ev");}
void  S1503C2_nt ::v235(){vfunc_called(this, "_ZN10S1503C2_nt4v235Ev");}
void  S1503C2_nt ::v236(){vfunc_called(this, "_ZN10S1503C2_nt4v236Ev");}
void  S1503C2_nt ::v237(){vfunc_called(this, "_ZN10S1503C2_nt4v237Ev");}
void  S1503C2_nt ::v238(){vfunc_called(this, "_ZN10S1503C2_nt4v238Ev");}
void  S1503C2_nt ::v239(){vfunc_called(this, "_ZN10S1503C2_nt4v239Ev");}
void  S1503C2_nt ::v240(){vfunc_called(this, "_ZN10S1503C2_nt4v240Ev");}
void  S1503C2_nt ::v241(){vfunc_called(this, "_ZN10S1503C2_nt4v241Ev");}
void  S1503C2_nt ::v242(){vfunc_called(this, "_ZN10S1503C2_nt4v242Ev");}
void  S1503C2_nt ::v243(){vfunc_called(this, "_ZN10S1503C2_nt4v243Ev");}
void  S1503C2_nt ::v244(){vfunc_called(this, "_ZN10S1503C2_nt4v244Ev");}
void  S1503C2_nt ::v245(){vfunc_called(this, "_ZN10S1503C2_nt4v245Ev");}
void  S1503C2_nt ::v246(){vfunc_called(this, "_ZN10S1503C2_nt4v246Ev");}
void  S1503C2_nt ::v247(){vfunc_called(this, "_ZN10S1503C2_nt4v247Ev");}
void  S1503C2_nt ::v248(){vfunc_called(this, "_ZN10S1503C2_nt4v248Ev");}
void  S1503C2_nt ::v249(){vfunc_called(this, "_ZN10S1503C2_nt4v249Ev");}
S1503C2_nt ::S1503C2_nt(){ note_ctor("S1503C2_nt", this);} // tgen

//skip512 S1503C2_nt

#else // __cplusplus

extern void _ZN10S1503C2_ntC1Ev();
extern void _ZN10S1503C2_ntD1Ev();
Name_Map name_map_S1503C2_nt[] = {
  NSPAIR(_ZN10S1503C2_ntC1Ev),
  NSPAIR(_ZN10S1503C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1503C4_nt;
extern VTBL_ENTRY _ZTI10S1503C4_nt[];
extern  VTBL_ENTRY _ZTV10S1503C4_nt[];
extern Class_Descriptor cd_S1503C3_nt;
extern VTBL_ENTRY _ZTI10S1503C3_nt[];
extern  VTBL_ENTRY _ZTV10S1503C3_nt[];
static Base_Class bases_S1503C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1503C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1503C2_nt[];
extern void _ZN10S1503C2_ntD1Ev();
extern void _ZN10S1503C2_ntD0Ev();
extern void _ZN10S1503C4_nt2v6Ev();
extern void _ZN10S1503C4_nt2v7Ev();
extern void _ZN10S1503C4_nt2v8Ev();
extern void _ZN10S1503C4_nt2v9Ev();
extern void _ZN10S1503C4_nt3v10Ev();
extern void _ZN10S1503C4_nt3v11Ev();
extern void _ZN10S1503C4_nt3v12Ev();
extern void _ZN10S1503C4_nt3v13Ev();
extern void _ZN10S1503C4_nt3v14Ev();
extern void _ZN10S1503C4_nt3v15Ev();
extern void _ZN10S1503C4_nt3v16Ev();
extern void _ZN10S1503C4_nt3v17Ev();
extern void _ZN10S1503C4_nt3v18Ev();
extern void _ZN10S1503C4_nt3v19Ev();
extern void _ZN10S1503C4_nt3v20Ev();
extern void _ZN10S1503C4_nt3v21Ev();
extern void _ZN10S1503C4_nt3v22Ev();
extern void _ZN10S1503C4_nt3v23Ev();
extern void _ZN10S1503C4_nt3v24Ev();
extern void _ZN10S1503C4_nt3v25Ev();
extern void _ZN10S1503C4_nt3v26Ev();
extern void _ZN10S1503C4_nt3v27Ev();
extern void _ZN10S1503C4_nt3v28Ev();
extern void _ZN10S1503C4_nt3v29Ev();
extern void _ZN10S1503C4_nt3v30Ev();
extern void _ZN10S1503C4_nt3v31Ev();
extern void _ZN10S1503C4_nt3v32Ev();
extern void _ZN10S1503C4_nt3v33Ev();
extern void _ZN10S1503C4_nt3v34Ev();
extern void _ZN10S1503C4_nt3v35Ev();
extern void _ZN10S1503C4_nt3v36Ev();
extern void _ZN10S1503C4_nt3v37Ev();
extern void _ZN10S1503C4_nt3v38Ev();
extern void _ZN10S1503C4_nt3v39Ev();
extern void _ZN10S1503C4_nt3v40Ev();
extern void _ZN10S1503C4_nt3v41Ev();
extern void _ZN10S1503C4_nt3v42Ev();
extern void _ZN10S1503C4_nt3v43Ev();
extern void _ZN10S1503C4_nt3v44Ev();
extern void _ZN10S1503C4_nt3v45Ev();
extern void _ZN10S1503C4_nt3v46Ev();
extern void _ZN10S1503C4_nt3v47Ev();
extern void _ZN10S1503C4_nt3v48Ev();
extern void _ZN10S1503C4_nt3v49Ev();
extern void _ZN10S1503C4_nt3v50Ev();
extern void _ZN10S1503C4_nt3v51Ev();
extern void _ZN10S1503C4_nt3v52Ev();
extern void _ZN10S1503C4_nt3v53Ev();
extern void _ZN10S1503C4_nt3v54Ev();
extern void _ZN10S1503C4_nt3v55Ev();
extern void _ZN10S1503C4_nt3v56Ev();
extern void _ZN10S1503C4_nt3v57Ev();
extern void _ZN10S1503C4_nt3v58Ev();
extern void _ZN10S1503C4_nt3v59Ev();
extern void _ZN10S1503C4_nt3v60Ev();
extern void _ZN10S1503C4_nt3v61Ev();
extern void _ZN10S1503C4_nt3v62Ev();
extern void _ZN10S1503C4_nt3v63Ev();
extern void _ZN10S1503C4_nt3v64Ev();
extern void _ZN10S1503C4_nt3v65Ev();
extern void _ZN10S1503C4_nt3v66Ev();
extern void _ZN10S1503C4_nt3v67Ev();
extern void _ZN10S1503C4_nt3v68Ev();
extern void _ZN10S1503C4_nt3v69Ev();
extern void _ZN10S1503C3_nt3v70Ev();
extern void _ZN10S1503C3_nt3v71Ev();
extern void _ZN10S1503C3_nt3v72Ev();
extern void _ZN10S1503C3_nt3v73Ev();
extern void _ZN10S1503C3_nt3v74Ev();
extern void _ZN10S1503C3_nt3v75Ev();
extern void _ZN10S1503C3_nt3v76Ev();
extern void _ZN10S1503C3_nt3v77Ev();
extern void _ZN10S1503C3_nt3v78Ev();
extern void _ZN10S1503C3_nt3v79Ev();
extern void _ZN10S1503C3_nt3v80Ev();
extern void _ZN10S1503C3_nt3v81Ev();
extern void _ZN10S1503C3_nt3v82Ev();
extern void _ZN10S1503C3_nt3v83Ev();
extern void _ZN10S1503C3_nt3v84Ev();
extern void _ZN10S1503C3_nt3v85Ev();
extern void _ZN10S1503C3_nt3v86Ev();
extern void _ZN10S1503C3_nt3v87Ev();
extern void _ZN10S1503C3_nt3v88Ev();
extern void _ZN10S1503C3_nt3v89Ev();
extern void _ZN10S1503C3_nt3v90Ev();
extern void _ZN10S1503C3_nt3v91Ev();
extern void _ZN10S1503C3_nt3v92Ev();
extern void _ZN10S1503C3_nt3v93Ev();
extern void _ZN10S1503C3_nt3v94Ev();
extern void _ZN10S1503C3_nt3v95Ev();
extern void _ZN10S1503C3_nt3v96Ev();
extern void _ZN10S1503C3_nt3v97Ev();
extern void _ZN10S1503C3_nt3v98Ev();
extern void _ZN10S1503C3_nt3v99Ev();
extern void _ZN10S1503C3_nt4v100Ev();
extern void _ZN10S1503C3_nt4v101Ev();
extern void _ZN10S1503C3_nt4v102Ev();
extern void _ZN10S1503C3_nt4v103Ev();
extern void _ZN10S1503C3_nt4v104Ev();
extern void _ZN10S1503C3_nt4v105Ev();
extern void _ZN10S1503C3_nt4v106Ev();
extern void _ZN10S1503C3_nt4v107Ev();
extern void _ZN10S1503C3_nt4v108Ev();
extern void _ZN10S1503C3_nt4v109Ev();
extern void _ZN10S1503C3_nt4v110Ev();
extern void _ZN10S1503C3_nt4v111Ev();
extern void _ZN10S1503C3_nt4v112Ev();
extern void _ZN10S1503C3_nt4v113Ev();
extern void _ZN10S1503C3_nt4v114Ev();
extern void _ZN10S1503C3_nt4v115Ev();
extern void _ZN10S1503C3_nt4v116Ev();
extern void _ZN10S1503C3_nt4v117Ev();
extern void _ZN10S1503C3_nt4v118Ev();
extern void _ZN10S1503C3_nt4v119Ev();
extern void _ZN10S1503C3_nt4v120Ev();
extern void _ZN10S1503C3_nt4v121Ev();
extern void _ZN10S1503C3_nt4v122Ev();
extern void _ZN10S1503C3_nt4v123Ev();
extern void _ZN10S1503C3_nt4v124Ev();
extern void _ZN10S1503C3_nt4v125Ev();
extern void _ZN10S1503C3_nt4v126Ev();
extern void _ZN10S1503C3_nt4v127Ev();
extern void _ZN10S1503C3_nt4v128Ev();
extern void _ZN10S1503C3_nt4v129Ev();
extern void _ZN10S1503C3_nt4v130Ev();
extern void _ZN10S1503C3_nt4v131Ev();
extern void _ZN10S1503C3_nt4v132Ev();
extern void _ZN10S1503C3_nt4v133Ev();
extern void _ZN10S1503C3_nt4v134Ev();
extern void _ZN10S1503C3_nt4v135Ev();
extern void _ZN10S1503C3_nt4v136Ev();
extern void _ZN10S1503C3_nt4v137Ev();
extern void _ZN10S1503C3_nt4v138Ev();
extern void _ZN10S1503C3_nt4v139Ev();
extern void _ZN10S1503C3_nt4v140Ev();
extern void _ZN10S1503C3_nt4v141Ev();
extern void _ZN10S1503C3_nt4v142Ev();
extern void _ZN10S1503C3_nt4v143Ev();
extern void _ZN10S1503C3_nt4v144Ev();
extern void _ZN10S1503C3_nt4v145Ev();
extern void _ZN10S1503C3_nt4v146Ev();
extern void _ZN10S1503C3_nt4v147Ev();
extern void _ZN10S1503C3_nt4v148Ev();
extern void _ZN10S1503C3_nt4v149Ev();
extern void _ZN10S1503C3_nt4v150Ev();
extern void _ZN10S1503C3_nt4v151Ev();
extern void _ZN10S1503C3_nt4v152Ev();
extern void _ZN10S1503C3_nt4v153Ev();
extern void _ZN10S1503C3_nt4v154Ev();
extern void _ZN10S1503C3_nt4v155Ev();
extern void _ZN10S1503C3_nt4v156Ev();
extern void _ZN10S1503C3_nt4v157Ev();
extern void _ZN10S1503C3_nt4v158Ev();
extern void _ZN10S1503C3_nt4v159Ev();
extern void _ZN10S1503C3_nt4v160Ev();
extern void _ZN10S1503C3_nt4v161Ev();
extern void _ZN10S1503C3_nt4v162Ev();
extern void _ZN10S1503C3_nt4v163Ev();
extern void _ZN10S1503C3_nt4v164Ev();
extern void _ZN10S1503C3_nt4v165Ev();
extern void _ZN10S1503C3_nt4v166Ev();
extern void _ZN10S1503C3_nt4v167Ev();
extern void _ZN10S1503C3_nt4v168Ev();
extern void _ZN10S1503C3_nt4v169Ev();
extern void _ZN10S1503C3_nt4v170Ev();
extern void _ZN10S1503C3_nt4v171Ev();
extern void _ZN10S1503C3_nt4v172Ev();
extern void _ZN10S1503C3_nt4v173Ev();
extern void _ZN10S1503C3_nt4v174Ev();
extern void _ZN10S1503C3_nt4v175Ev();
extern void _ZN10S1503C3_nt4v176Ev();
extern void _ZN10S1503C3_nt4v177Ev();
extern void _ZN10S1503C3_nt4v178Ev();
extern void _ZN10S1503C3_nt4v179Ev();
extern void _ZN10S1503C3_nt4v180Ev();
extern void _ZN10S1503C3_nt4v181Ev();
extern void _ZN10S1503C3_nt4v182Ev();
extern void _ZN10S1503C3_nt4v183Ev();
extern void _ZN10S1503C3_nt4v184Ev();
extern void _ZN10S1503C3_nt4v185Ev();
extern void _ZN10S1503C3_nt4v186Ev();
extern void _ZN10S1503C3_nt4v187Ev();
extern void _ZN10S1503C3_nt4v188Ev();
extern void _ZN10S1503C3_nt4v189Ev();
extern void _ZN10S1503C3_nt4v190Ev();
extern void _ZN10S1503C3_nt4v191Ev();
extern void _ZN10S1503C3_nt4v192Ev();
extern void _ZN10S1503C3_nt4v193Ev();
extern void _ZN10S1503C3_nt4v194Ev();
extern void _ZN10S1503C3_nt4v195Ev();
extern void _ZN10S1503C3_nt4v196Ev();
extern void _ZN10S1503C3_nt4v197Ev();
extern void _ZN10S1503C3_nt4v198Ev();
extern void _ZN10S1503C3_nt4v199Ev();
extern void _ZN10S1503C3_nt4v200Ev();
extern void _ZN10S1503C3_nt4v201Ev();
extern void _ZN10S1503C3_nt4v202Ev();
extern void _ZN10S1503C3_nt4v203Ev();
extern void _ZN10S1503C3_nt4v204Ev();
extern void _ZN10S1503C3_nt4v205Ev();
extern void _ZN10S1503C3_nt4v206Ev();
extern void _ZN10S1503C3_nt4v207Ev();
extern void _ZN10S1503C3_nt4v208Ev();
extern void _ZN10S1503C3_nt4v209Ev();
extern void _ZN10S1503C3_nt4v210Ev();
extern void _ZN10S1503C3_nt4v211Ev();
extern void _ZN10S1503C3_nt4v212Ev();
extern void _ZN10S1503C2_nt4v213Ev();
extern void _ZN10S1503C2_nt4v214Ev();
extern void _ZN10S1503C2_nt4v215Ev();
extern void _ZN10S1503C2_nt4v216Ev();
extern void _ZN10S1503C2_nt4v217Ev();
extern void _ZN10S1503C2_nt4v218Ev();
extern void _ZN10S1503C2_nt4v219Ev();
extern void _ZN10S1503C2_nt4v220Ev();
extern void _ZN10S1503C2_nt4v221Ev();
extern void _ZN10S1503C2_nt4v222Ev();
extern void _ZN10S1503C2_nt4v223Ev();
extern void _ZN10S1503C2_nt4v224Ev();
extern void _ZN10S1503C2_nt4v225Ev();
extern void _ZN10S1503C2_nt4v226Ev();
extern void _ZN10S1503C2_nt4v227Ev();
extern void _ZN10S1503C2_nt4v228Ev();
extern void _ZN10S1503C2_nt4v229Ev();
extern void _ZN10S1503C2_nt4v230Ev();
extern void _ZN10S1503C2_nt4v231Ev();
extern void _ZN10S1503C2_nt4v232Ev();
extern void _ZN10S1503C2_nt4v233Ev();
extern void _ZN10S1503C2_nt4v234Ev();
extern void _ZN10S1503C2_nt4v235Ev();
extern void _ZN10S1503C2_nt4v236Ev();
extern void _ZN10S1503C2_nt4v237Ev();
extern void _ZN10S1503C2_nt4v238Ev();
extern void _ZN10S1503C2_nt4v239Ev();
extern void _ZN10S1503C2_nt4v240Ev();
extern void _ZN10S1503C2_nt4v241Ev();
extern void _ZN10S1503C2_nt4v242Ev();
extern void _ZN10S1503C2_nt4v243Ev();
extern void _ZN10S1503C2_nt4v244Ev();
extern void _ZN10S1503C2_nt4v245Ev();
extern void _ZN10S1503C2_nt4v246Ev();
extern void _ZN10S1503C2_nt4v247Ev();
extern void _ZN10S1503C2_nt4v248Ev();
extern void _ZN10S1503C2_nt4v249Ev();
static  VTBL_ENTRY vtc_S1503C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1503C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1503C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v237Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v238Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v239Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v240Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v241Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v242Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v243Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v244Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v245Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v246Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v247Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v248Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v249Ev,
};
extern VTBL_ENTRY _ZTI10S1503C2_nt[];
VTBL_ENTRY *P__ZTI10S1503C2_nt = _ZTI10S1503C2_nt; 
extern  VTBL_ENTRY _ZTV10S1503C2_nt[];
Class_Descriptor cd_S1503C2_nt = {  "S1503C2_nt", // class name
  bases_S1503C2_nt, 2,
  &(vtc_S1503C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(880,656), // object size
  NSPAIRA(_ZTI10S1503C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1503C2_nt),248, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1503C1  : S1503C2_nt {
  ::S1503C14_nt s1503c1f0;
  void *s1503c1f1[2];
  int s1503c1f2[2];
  void *s1503c1f3;
  virtual  ~S1503C1(); // _ZN7S1503C1D1Ev
  virtual void  v1(); // _ZN7S1503C12v1Ev
  virtual void  v2(); // _ZN7S1503C12v2Ev
  virtual void  v3(); // _ZN7S1503C12v3Ev
  virtual void  v4(); // _ZN7S1503C12v4Ev
  virtual void  v5(); // _ZN7S1503C12v5Ev
  S1503C1(); // tgen
};
//SIG(1 S1503C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ m FC16{ m FC12 FC12 Fc} FC12 Fp[2] Fc} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC17{ BC18{ BC8}} FC17 FC17 FC19{ BC20{ BC8}} Fi[2] Fp[4] Fi[5] Fp Fi[2] Fp[2] Fi FC5 FC21{ m Fi[4]} Fp[2] Fi Fp Fi} vd v1 v2 v3 v4 v5 FC12 Fp[2] Fi[2] Fp}


 S1503C1 ::~S1503C1(){ note_dtor("S1503C1", this);}
void  S1503C1 ::v1(){vfunc_called(this, "_ZN7S1503C12v1Ev");}
void  S1503C1 ::v2(){vfunc_called(this, "_ZN7S1503C12v2Ev");}
void  S1503C1 ::v3(){vfunc_called(this, "_ZN7S1503C12v3Ev");}
void  S1503C1 ::v4(){vfunc_called(this, "_ZN7S1503C12v4Ev");}
void  S1503C1 ::v5(){vfunc_called(this, "_ZN7S1503C12v5Ev");}
S1503C1 ::S1503C1(){ note_ctor("S1503C1", this);} // tgen

static void Test_S1503C1()
{
  extern Class_Descriptor cd_S1503C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(116,173)];
    init_test(&cd_S1503C1, buf);
    S1503C1 *dp, &lv = *(dp=new (buf) S1503C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(920,688), "sizeof(S1503C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1503C1)");
    check_base_class_offset(lv, (S1503C4_nt*)(S1503C3_nt*)(S1503C2_nt*), 0, "S1503C1");
    check_base_class_offset(lv, (S1503C3_nt*)(S1503C2_nt*), 0, "S1503C1");
    check_base_class_offset(lv, (S1503C2_nt*), 0, "S1503C1");
    check_field_offset(lv, s1503c1f0, ABISELECT(876,656), "S1503C1.s1503c1f0");
    check_field_offset(lv, s1503c1f1, ABISELECT(888,668), "S1503C1.s1503c1f1");
    check_field_offset(lv, s1503c1f2, ABISELECT(904,676), "S1503C1.s1503c1f2");
    check_field_offset(lv, s1503c1f3, ABISELECT(912,684), "S1503C1.s1503c1f3");
    test_class_info(&lv, &cd_S1503C1);
    dp->~S1503C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1503C1(Test_S1503C1, "S1503C1", ABISELECT(920,688));

#else // __cplusplus

extern void _ZN7S1503C1C1Ev();
extern void _ZN7S1503C1D1Ev();
Name_Map name_map_S1503C1[] = {
  NSPAIR(_ZN7S1503C1C1Ev),
  NSPAIR(_ZN7S1503C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1503C4_nt;
extern VTBL_ENTRY _ZTI10S1503C4_nt[];
extern  VTBL_ENTRY _ZTV10S1503C4_nt[];
extern Class_Descriptor cd_S1503C3_nt;
extern VTBL_ENTRY _ZTI10S1503C3_nt[];
extern  VTBL_ENTRY _ZTV10S1503C3_nt[];
extern Class_Descriptor cd_S1503C2_nt;
extern VTBL_ENTRY _ZTI10S1503C2_nt[];
extern  VTBL_ENTRY _ZTV10S1503C2_nt[];
static Base_Class bases_S1503C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1503C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1503C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1503C1[];
extern void _ZN7S1503C1D1Ev();
extern void _ZN7S1503C1D0Ev();
extern void _ZN10S1503C4_nt2v6Ev();
extern void _ZN10S1503C4_nt2v7Ev();
extern void _ZN10S1503C4_nt2v8Ev();
extern void _ZN10S1503C4_nt2v9Ev();
extern void _ZN10S1503C4_nt3v10Ev();
extern void _ZN10S1503C4_nt3v11Ev();
extern void _ZN10S1503C4_nt3v12Ev();
extern void _ZN10S1503C4_nt3v13Ev();
extern void _ZN10S1503C4_nt3v14Ev();
extern void _ZN10S1503C4_nt3v15Ev();
extern void _ZN10S1503C4_nt3v16Ev();
extern void _ZN10S1503C4_nt3v17Ev();
extern void _ZN10S1503C4_nt3v18Ev();
extern void _ZN10S1503C4_nt3v19Ev();
extern void _ZN10S1503C4_nt3v20Ev();
extern void _ZN10S1503C4_nt3v21Ev();
extern void _ZN10S1503C4_nt3v22Ev();
extern void _ZN10S1503C4_nt3v23Ev();
extern void _ZN10S1503C4_nt3v24Ev();
extern void _ZN10S1503C4_nt3v25Ev();
extern void _ZN10S1503C4_nt3v26Ev();
extern void _ZN10S1503C4_nt3v27Ev();
extern void _ZN10S1503C4_nt3v28Ev();
extern void _ZN10S1503C4_nt3v29Ev();
extern void _ZN10S1503C4_nt3v30Ev();
extern void _ZN10S1503C4_nt3v31Ev();
extern void _ZN10S1503C4_nt3v32Ev();
extern void _ZN10S1503C4_nt3v33Ev();
extern void _ZN10S1503C4_nt3v34Ev();
extern void _ZN10S1503C4_nt3v35Ev();
extern void _ZN10S1503C4_nt3v36Ev();
extern void _ZN10S1503C4_nt3v37Ev();
extern void _ZN10S1503C4_nt3v38Ev();
extern void _ZN10S1503C4_nt3v39Ev();
extern void _ZN10S1503C4_nt3v40Ev();
extern void _ZN10S1503C4_nt3v41Ev();
extern void _ZN10S1503C4_nt3v42Ev();
extern void _ZN10S1503C4_nt3v43Ev();
extern void _ZN10S1503C4_nt3v44Ev();
extern void _ZN10S1503C4_nt3v45Ev();
extern void _ZN10S1503C4_nt3v46Ev();
extern void _ZN10S1503C4_nt3v47Ev();
extern void _ZN10S1503C4_nt3v48Ev();
extern void _ZN10S1503C4_nt3v49Ev();
extern void _ZN10S1503C4_nt3v50Ev();
extern void _ZN10S1503C4_nt3v51Ev();
extern void _ZN10S1503C4_nt3v52Ev();
extern void _ZN10S1503C4_nt3v53Ev();
extern void _ZN10S1503C4_nt3v54Ev();
extern void _ZN10S1503C4_nt3v55Ev();
extern void _ZN10S1503C4_nt3v56Ev();
extern void _ZN10S1503C4_nt3v57Ev();
extern void _ZN10S1503C4_nt3v58Ev();
extern void _ZN10S1503C4_nt3v59Ev();
extern void _ZN10S1503C4_nt3v60Ev();
extern void _ZN10S1503C4_nt3v61Ev();
extern void _ZN10S1503C4_nt3v62Ev();
extern void _ZN10S1503C4_nt3v63Ev();
extern void _ZN10S1503C4_nt3v64Ev();
extern void _ZN10S1503C4_nt3v65Ev();
extern void _ZN10S1503C4_nt3v66Ev();
extern void _ZN10S1503C4_nt3v67Ev();
extern void _ZN10S1503C4_nt3v68Ev();
extern void _ZN10S1503C4_nt3v69Ev();
extern void _ZN10S1503C3_nt3v70Ev();
extern void _ZN10S1503C3_nt3v71Ev();
extern void _ZN10S1503C3_nt3v72Ev();
extern void _ZN10S1503C3_nt3v73Ev();
extern void _ZN10S1503C3_nt3v74Ev();
extern void _ZN10S1503C3_nt3v75Ev();
extern void _ZN10S1503C3_nt3v76Ev();
extern void _ZN10S1503C3_nt3v77Ev();
extern void _ZN10S1503C3_nt3v78Ev();
extern void _ZN10S1503C3_nt3v79Ev();
extern void _ZN10S1503C3_nt3v80Ev();
extern void _ZN10S1503C3_nt3v81Ev();
extern void _ZN10S1503C3_nt3v82Ev();
extern void _ZN10S1503C3_nt3v83Ev();
extern void _ZN10S1503C3_nt3v84Ev();
extern void _ZN10S1503C3_nt3v85Ev();
extern void _ZN10S1503C3_nt3v86Ev();
extern void _ZN10S1503C3_nt3v87Ev();
extern void _ZN10S1503C3_nt3v88Ev();
extern void _ZN10S1503C3_nt3v89Ev();
extern void _ZN10S1503C3_nt3v90Ev();
extern void _ZN10S1503C3_nt3v91Ev();
extern void _ZN10S1503C3_nt3v92Ev();
extern void _ZN10S1503C3_nt3v93Ev();
extern void _ZN10S1503C3_nt3v94Ev();
extern void _ZN10S1503C3_nt3v95Ev();
extern void _ZN10S1503C3_nt3v96Ev();
extern void _ZN10S1503C3_nt3v97Ev();
extern void _ZN10S1503C3_nt3v98Ev();
extern void _ZN10S1503C3_nt3v99Ev();
extern void _ZN10S1503C3_nt4v100Ev();
extern void _ZN10S1503C3_nt4v101Ev();
extern void _ZN10S1503C3_nt4v102Ev();
extern void _ZN10S1503C3_nt4v103Ev();
extern void _ZN10S1503C3_nt4v104Ev();
extern void _ZN10S1503C3_nt4v105Ev();
extern void _ZN10S1503C3_nt4v106Ev();
extern void _ZN10S1503C3_nt4v107Ev();
extern void _ZN10S1503C3_nt4v108Ev();
extern void _ZN10S1503C3_nt4v109Ev();
extern void _ZN10S1503C3_nt4v110Ev();
extern void _ZN10S1503C3_nt4v111Ev();
extern void _ZN10S1503C3_nt4v112Ev();
extern void _ZN10S1503C3_nt4v113Ev();
extern void _ZN10S1503C3_nt4v114Ev();
extern void _ZN10S1503C3_nt4v115Ev();
extern void _ZN10S1503C3_nt4v116Ev();
extern void _ZN10S1503C3_nt4v117Ev();
extern void _ZN10S1503C3_nt4v118Ev();
extern void _ZN10S1503C3_nt4v119Ev();
extern void _ZN10S1503C3_nt4v120Ev();
extern void _ZN10S1503C3_nt4v121Ev();
extern void _ZN10S1503C3_nt4v122Ev();
extern void _ZN10S1503C3_nt4v123Ev();
extern void _ZN10S1503C3_nt4v124Ev();
extern void _ZN10S1503C3_nt4v125Ev();
extern void _ZN10S1503C3_nt4v126Ev();
extern void _ZN10S1503C3_nt4v127Ev();
extern void _ZN10S1503C3_nt4v128Ev();
extern void _ZN10S1503C3_nt4v129Ev();
extern void _ZN10S1503C3_nt4v130Ev();
extern void _ZN10S1503C3_nt4v131Ev();
extern void _ZN10S1503C3_nt4v132Ev();
extern void _ZN10S1503C3_nt4v133Ev();
extern void _ZN10S1503C3_nt4v134Ev();
extern void _ZN10S1503C3_nt4v135Ev();
extern void _ZN10S1503C3_nt4v136Ev();
extern void _ZN10S1503C3_nt4v137Ev();
extern void _ZN10S1503C3_nt4v138Ev();
extern void _ZN10S1503C3_nt4v139Ev();
extern void _ZN10S1503C3_nt4v140Ev();
extern void _ZN10S1503C3_nt4v141Ev();
extern void _ZN10S1503C3_nt4v142Ev();
extern void _ZN10S1503C3_nt4v143Ev();
extern void _ZN10S1503C3_nt4v144Ev();
extern void _ZN10S1503C3_nt4v145Ev();
extern void _ZN10S1503C3_nt4v146Ev();
extern void _ZN10S1503C3_nt4v147Ev();
extern void _ZN10S1503C3_nt4v148Ev();
extern void _ZN10S1503C3_nt4v149Ev();
extern void _ZN10S1503C3_nt4v150Ev();
extern void _ZN10S1503C3_nt4v151Ev();
extern void _ZN10S1503C3_nt4v152Ev();
extern void _ZN10S1503C3_nt4v153Ev();
extern void _ZN10S1503C3_nt4v154Ev();
extern void _ZN10S1503C3_nt4v155Ev();
extern void _ZN10S1503C3_nt4v156Ev();
extern void _ZN10S1503C3_nt4v157Ev();
extern void _ZN10S1503C3_nt4v158Ev();
extern void _ZN10S1503C3_nt4v159Ev();
extern void _ZN10S1503C3_nt4v160Ev();
extern void _ZN10S1503C3_nt4v161Ev();
extern void _ZN10S1503C3_nt4v162Ev();
extern void _ZN10S1503C3_nt4v163Ev();
extern void _ZN10S1503C3_nt4v164Ev();
extern void _ZN10S1503C3_nt4v165Ev();
extern void _ZN10S1503C3_nt4v166Ev();
extern void _ZN10S1503C3_nt4v167Ev();
extern void _ZN10S1503C3_nt4v168Ev();
extern void _ZN10S1503C3_nt4v169Ev();
extern void _ZN10S1503C3_nt4v170Ev();
extern void _ZN10S1503C3_nt4v171Ev();
extern void _ZN10S1503C3_nt4v172Ev();
extern void _ZN10S1503C3_nt4v173Ev();
extern void _ZN10S1503C3_nt4v174Ev();
extern void _ZN10S1503C3_nt4v175Ev();
extern void _ZN10S1503C3_nt4v176Ev();
extern void _ZN10S1503C3_nt4v177Ev();
extern void _ZN10S1503C3_nt4v178Ev();
extern void _ZN10S1503C3_nt4v179Ev();
extern void _ZN10S1503C3_nt4v180Ev();
extern void _ZN10S1503C3_nt4v181Ev();
extern void _ZN10S1503C3_nt4v182Ev();
extern void _ZN10S1503C3_nt4v183Ev();
extern void _ZN10S1503C3_nt4v184Ev();
extern void _ZN10S1503C3_nt4v185Ev();
extern void _ZN10S1503C3_nt4v186Ev();
extern void _ZN10S1503C3_nt4v187Ev();
extern void _ZN10S1503C3_nt4v188Ev();
extern void _ZN10S1503C3_nt4v189Ev();
extern void _ZN10S1503C3_nt4v190Ev();
extern void _ZN10S1503C3_nt4v191Ev();
extern void _ZN10S1503C3_nt4v192Ev();
extern void _ZN10S1503C3_nt4v193Ev();
extern void _ZN10S1503C3_nt4v194Ev();
extern void _ZN10S1503C3_nt4v195Ev();
extern void _ZN10S1503C3_nt4v196Ev();
extern void _ZN10S1503C3_nt4v197Ev();
extern void _ZN10S1503C3_nt4v198Ev();
extern void _ZN10S1503C3_nt4v199Ev();
extern void _ZN10S1503C3_nt4v200Ev();
extern void _ZN10S1503C3_nt4v201Ev();
extern void _ZN10S1503C3_nt4v202Ev();
extern void _ZN10S1503C3_nt4v203Ev();
extern void _ZN10S1503C3_nt4v204Ev();
extern void _ZN10S1503C3_nt4v205Ev();
extern void _ZN10S1503C3_nt4v206Ev();
extern void _ZN10S1503C3_nt4v207Ev();
extern void _ZN10S1503C3_nt4v208Ev();
extern void _ZN10S1503C3_nt4v209Ev();
extern void _ZN10S1503C3_nt4v210Ev();
extern void _ZN10S1503C3_nt4v211Ev();
extern void _ZN10S1503C3_nt4v212Ev();
extern void _ZN10S1503C2_nt4v213Ev();
extern void _ZN10S1503C2_nt4v214Ev();
extern void _ZN10S1503C2_nt4v215Ev();
extern void _ZN10S1503C2_nt4v216Ev();
extern void _ZN10S1503C2_nt4v217Ev();
extern void _ZN10S1503C2_nt4v218Ev();
extern void _ZN10S1503C2_nt4v219Ev();
extern void _ZN10S1503C2_nt4v220Ev();
extern void _ZN10S1503C2_nt4v221Ev();
extern void _ZN10S1503C2_nt4v222Ev();
extern void _ZN10S1503C2_nt4v223Ev();
extern void _ZN10S1503C2_nt4v224Ev();
extern void _ZN10S1503C2_nt4v225Ev();
extern void _ZN10S1503C2_nt4v226Ev();
extern void _ZN10S1503C2_nt4v227Ev();
extern void _ZN10S1503C2_nt4v228Ev();
extern void _ZN10S1503C2_nt4v229Ev();
extern void _ZN10S1503C2_nt4v230Ev();
extern void _ZN10S1503C2_nt4v231Ev();
extern void _ZN10S1503C2_nt4v232Ev();
extern void _ZN10S1503C2_nt4v233Ev();
extern void _ZN10S1503C2_nt4v234Ev();
extern void _ZN10S1503C2_nt4v235Ev();
extern void _ZN10S1503C2_nt4v236Ev();
extern void _ZN10S1503C2_nt4v237Ev();
extern void _ZN10S1503C2_nt4v238Ev();
extern void _ZN10S1503C2_nt4v239Ev();
extern void _ZN10S1503C2_nt4v240Ev();
extern void _ZN10S1503C2_nt4v241Ev();
extern void _ZN10S1503C2_nt4v242Ev();
extern void _ZN10S1503C2_nt4v243Ev();
extern void _ZN10S1503C2_nt4v244Ev();
extern void _ZN10S1503C2_nt4v245Ev();
extern void _ZN10S1503C2_nt4v246Ev();
extern void _ZN10S1503C2_nt4v247Ev();
extern void _ZN10S1503C2_nt4v248Ev();
extern void _ZN10S1503C2_nt4v249Ev();
extern void _ZN7S1503C12v1Ev();
extern void _ZN7S1503C12v2Ev();
extern void _ZN7S1503C12v3Ev();
extern void _ZN7S1503C12v4Ev();
extern void _ZN7S1503C12v5Ev();
static  VTBL_ENTRY vtc_S1503C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1503C1[0]),
  (VTBL_ENTRY)&_ZN7S1503C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1503C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1503C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1503C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v237Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v238Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v239Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v240Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v241Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v242Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v243Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v244Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v245Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v246Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v247Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v248Ev,
  (VTBL_ENTRY)&_ZN10S1503C2_nt4v249Ev,
  (VTBL_ENTRY)&_ZN7S1503C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1503C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1503C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1503C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1503C12v5Ev,
};
extern VTBL_ENTRY _ZTI7S1503C1[];
extern  VTBL_ENTRY _ZTV7S1503C1[];
Class_Descriptor cd_S1503C1 = {  "S1503C1", // class name
  bases_S1503C1, 3,
  &(vtc_S1503C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(920,688), // object size
  NSPAIRA(_ZTI7S1503C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1503C1),253, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S629C5  {
  int s629c5f0;
  __tsi64 s629c5f1;
  void *s629c5f2[4];
  int s629c5f3[2];
  void *s629c5f4;
  ::S1503C5_nt s629c5f5;
  void *s629c5f6[2];
  virtual  ~S629C5(); // _ZN6S629C5D1Ev
  virtual void  v5(); // _ZN6S629C52v5Ev
  virtual void  v6(); // _ZN6S629C52v6Ev
  virtual void  v7(); // _ZN6S629C52v7Ev
  virtual void  v8(); // _ZN6S629C52v8Ev
  virtual void  v9(); // _ZN6S629C52v9Ev
  virtual void  v10(); // _ZN6S629C53v10Ev
  virtual void  v11(); // _ZN6S629C53v11Ev
  virtual void  v12(); // _ZN6S629C53v12Ev
  virtual void  v13(); // _ZN6S629C53v13Ev
  virtual void  v14(); // _ZN6S629C53v14Ev
  virtual void  v15(); // _ZN6S629C53v15Ev
  virtual void  v16(); // _ZN6S629C53v16Ev
  virtual void  v17(); // _ZN6S629C53v17Ev
  virtual void  v18(); // _ZN6S629C53v18Ev
  virtual void  v19(); // _ZN6S629C53v19Ev
  virtual void  v20(); // _ZN6S629C53v20Ev
  virtual void  v21(); // _ZN6S629C53v21Ev
  virtual void  v22(); // _ZN6S629C53v22Ev
  virtual void  v23(); // _ZN6S629C53v23Ev
  virtual void  v24(); // _ZN6S629C53v24Ev
  virtual void  v25(); // _ZN6S629C53v25Ev
  virtual void  v26(); // _ZN6S629C53v26Ev
  virtual void  v27(); // _ZN6S629C53v27Ev
  virtual void  v28(); // _ZN6S629C53v28Ev
  virtual void  v29(); // _ZN6S629C53v29Ev
  virtual void  v30(); // _ZN6S629C53v30Ev
  virtual void  v31(); // _ZN6S629C53v31Ev
  virtual void  v32(); // _ZN6S629C53v32Ev
  virtual void  v33(); // _ZN6S629C53v33Ev
  virtual void  v34(); // _ZN6S629C53v34Ev
  virtual void  v35(); // _ZN6S629C53v35Ev
  virtual void  v36(); // _ZN6S629C53v36Ev
  virtual void  v37(); // _ZN6S629C53v37Ev
  virtual void  v38(); // _ZN6S629C53v38Ev
  virtual void  v39(); // _ZN6S629C53v39Ev
  virtual void  v40(); // _ZN6S629C53v40Ev
  virtual void  v41(); // _ZN6S629C53v41Ev
  virtual void  v42(); // _ZN6S629C53v42Ev
  virtual void  v43(); // _ZN6S629C53v43Ev
  virtual void  v44(); // _ZN6S629C53v44Ev
  virtual void  v45(); // _ZN6S629C53v45Ev
  virtual void  v46(); // _ZN6S629C53v46Ev
  virtual void  v47(); // _ZN6S629C53v47Ev
  virtual void  v48(); // _ZN6S629C53v48Ev
  virtual void  v49(); // _ZN6S629C53v49Ev
  virtual void  v50(); // _ZN6S629C53v50Ev
  virtual void  v51(); // _ZN6S629C53v51Ev
  virtual void  v52(); // _ZN6S629C53v52Ev
  virtual void  v53(); // _ZN6S629C53v53Ev
  virtual void  v54(); // _ZN6S629C53v54Ev
  virtual void  v55(); // _ZN6S629C53v55Ev
  virtual void  v56(); // _ZN6S629C53v56Ev
  virtual void  v57(); // _ZN6S629C53v57Ev
  virtual void  v58(); // _ZN6S629C53v58Ev
  virtual void  v59(); // _ZN6S629C53v59Ev
  virtual void  v60(); // _ZN6S629C53v60Ev
  virtual void  v61(); // _ZN6S629C53v61Ev
  virtual void  v62(); // _ZN6S629C53v62Ev
  virtual void  v63(); // _ZN6S629C53v63Ev
  virtual void  v64(); // _ZN6S629C53v64Ev
  virtual void  v65(); // _ZN6S629C53v65Ev
  virtual void  v66(); // _ZN6S629C53v66Ev
  virtual void  v67(); // _ZN6S629C53v67Ev
  virtual void  v68(); // _ZN6S629C53v68Ev
  S629C5(); // tgen
};
//SIG(-1 S629C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S629C5 ::~S629C5(){ note_dtor("S629C5", this);}
void  S629C5 ::v5(){vfunc_called(this, "_ZN6S629C52v5Ev");}
void  S629C5 ::v6(){vfunc_called(this, "_ZN6S629C52v6Ev");}
void  S629C5 ::v7(){vfunc_called(this, "_ZN6S629C52v7Ev");}
void  S629C5 ::v8(){vfunc_called(this, "_ZN6S629C52v8Ev");}
void  S629C5 ::v9(){vfunc_called(this, "_ZN6S629C52v9Ev");}
void  S629C5 ::v10(){vfunc_called(this, "_ZN6S629C53v10Ev");}
void  S629C5 ::v11(){vfunc_called(this, "_ZN6S629C53v11Ev");}
void  S629C5 ::v12(){vfunc_called(this, "_ZN6S629C53v12Ev");}
void  S629C5 ::v13(){vfunc_called(this, "_ZN6S629C53v13Ev");}
void  S629C5 ::v14(){vfunc_called(this, "_ZN6S629C53v14Ev");}
void  S629C5 ::v15(){vfunc_called(this, "_ZN6S629C53v15Ev");}
void  S629C5 ::v16(){vfunc_called(this, "_ZN6S629C53v16Ev");}
void  S629C5 ::v17(){vfunc_called(this, "_ZN6S629C53v17Ev");}
void  S629C5 ::v18(){vfunc_called(this, "_ZN6S629C53v18Ev");}
void  S629C5 ::v19(){vfunc_called(this, "_ZN6S629C53v19Ev");}
void  S629C5 ::v20(){vfunc_called(this, "_ZN6S629C53v20Ev");}
void  S629C5 ::v21(){vfunc_called(this, "_ZN6S629C53v21Ev");}
void  S629C5 ::v22(){vfunc_called(this, "_ZN6S629C53v22Ev");}
void  S629C5 ::v23(){vfunc_called(this, "_ZN6S629C53v23Ev");}
void  S629C5 ::v24(){vfunc_called(this, "_ZN6S629C53v24Ev");}
void  S629C5 ::v25(){vfunc_called(this, "_ZN6S629C53v25Ev");}
void  S629C5 ::v26(){vfunc_called(this, "_ZN6S629C53v26Ev");}
void  S629C5 ::v27(){vfunc_called(this, "_ZN6S629C53v27Ev");}
void  S629C5 ::v28(){vfunc_called(this, "_ZN6S629C53v28Ev");}
void  S629C5 ::v29(){vfunc_called(this, "_ZN6S629C53v29Ev");}
void  S629C5 ::v30(){vfunc_called(this, "_ZN6S629C53v30Ev");}
void  S629C5 ::v31(){vfunc_called(this, "_ZN6S629C53v31Ev");}
void  S629C5 ::v32(){vfunc_called(this, "_ZN6S629C53v32Ev");}
void  S629C5 ::v33(){vfunc_called(this, "_ZN6S629C53v33Ev");}
void  S629C5 ::v34(){vfunc_called(this, "_ZN6S629C53v34Ev");}
void  S629C5 ::v35(){vfunc_called(this, "_ZN6S629C53v35Ev");}
void  S629C5 ::v36(){vfunc_called(this, "_ZN6S629C53v36Ev");}
void  S629C5 ::v37(){vfunc_called(this, "_ZN6S629C53v37Ev");}
void  S629C5 ::v38(){vfunc_called(this, "_ZN6S629C53v38Ev");}
void  S629C5 ::v39(){vfunc_called(this, "_ZN6S629C53v39Ev");}
void  S629C5 ::v40(){vfunc_called(this, "_ZN6S629C53v40Ev");}
void  S629C5 ::v41(){vfunc_called(this, "_ZN6S629C53v41Ev");}
void  S629C5 ::v42(){vfunc_called(this, "_ZN6S629C53v42Ev");}
void  S629C5 ::v43(){vfunc_called(this, "_ZN6S629C53v43Ev");}
void  S629C5 ::v44(){vfunc_called(this, "_ZN6S629C53v44Ev");}
void  S629C5 ::v45(){vfunc_called(this, "_ZN6S629C53v45Ev");}
void  S629C5 ::v46(){vfunc_called(this, "_ZN6S629C53v46Ev");}
void  S629C5 ::v47(){vfunc_called(this, "_ZN6S629C53v47Ev");}
void  S629C5 ::v48(){vfunc_called(this, "_ZN6S629C53v48Ev");}
void  S629C5 ::v49(){vfunc_called(this, "_ZN6S629C53v49Ev");}
void  S629C5 ::v50(){vfunc_called(this, "_ZN6S629C53v50Ev");}
void  S629C5 ::v51(){vfunc_called(this, "_ZN6S629C53v51Ev");}
void  S629C5 ::v52(){vfunc_called(this, "_ZN6S629C53v52Ev");}
void  S629C5 ::v53(){vfunc_called(this, "_ZN6S629C53v53Ev");}
void  S629C5 ::v54(){vfunc_called(this, "_ZN6S629C53v54Ev");}
void  S629C5 ::v55(){vfunc_called(this, "_ZN6S629C53v55Ev");}
void  S629C5 ::v56(){vfunc_called(this, "_ZN6S629C53v56Ev");}
void  S629C5 ::v57(){vfunc_called(this, "_ZN6S629C53v57Ev");}
void  S629C5 ::v58(){vfunc_called(this, "_ZN6S629C53v58Ev");}
void  S629C5 ::v59(){vfunc_called(this, "_ZN6S629C53v59Ev");}
void  S629C5 ::v60(){vfunc_called(this, "_ZN6S629C53v60Ev");}
void  S629C5 ::v61(){vfunc_called(this, "_ZN6S629C53v61Ev");}
void  S629C5 ::v62(){vfunc_called(this, "_ZN6S629C53v62Ev");}
void  S629C5 ::v63(){vfunc_called(this, "_ZN6S629C53v63Ev");}
void  S629C5 ::v64(){vfunc_called(this, "_ZN6S629C53v64Ev");}
void  S629C5 ::v65(){vfunc_called(this, "_ZN6S629C53v65Ev");}
void  S629C5 ::v66(){vfunc_called(this, "_ZN6S629C53v66Ev");}
void  S629C5 ::v67(){vfunc_called(this, "_ZN6S629C53v67Ev");}
void  S629C5 ::v68(){vfunc_called(this, "_ZN6S629C53v68Ev");}
S629C5 ::S629C5(){ note_ctor("S629C5", this);} // tgen

static void Test_S629C5()
{
  extern Class_Descriptor cd_S629C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S629C5, buf);
    S629C5 *dp, &lv = *(dp=new (buf) S629C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S629C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S629C5)");
    check_field_offset(lv, s629c5f0, ABISELECT(8,4), "S629C5.s629c5f0");
    check_field_offset(lv, s629c5f1, ABISELECT(16,8), "S629C5.s629c5f1");
    check_field_offset(lv, s629c5f2, ABISELECT(24,16), "S629C5.s629c5f2");
    check_field_offset(lv, s629c5f3, ABISELECT(56,32), "S629C5.s629c5f3");
    check_field_offset(lv, s629c5f4, ABISELECT(64,40), "S629C5.s629c5f4");
    check_field_offset(lv, s629c5f5, ABISELECT(72,44), "S629C5.s629c5f5");
    check_field_offset(lv, s629c5f6, ABISELECT(80,52), "S629C5.s629c5f6");
    test_class_info(&lv, &cd_S629C5);
    dp->~S629C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS629C5(Test_S629C5, "S629C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S629C5C1Ev();
extern void _ZN6S629C5D1Ev();
Name_Map name_map_S629C5[] = {
  NSPAIR(_ZN6S629C5C1Ev),
  NSPAIR(_ZN6S629C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S629C5[];
extern void _ZN6S629C5D1Ev();
extern void _ZN6S629C5D0Ev();
extern void _ZN6S629C52v5Ev();
extern void _ZN6S629C52v6Ev();
extern void _ZN6S629C52v7Ev();
extern void _ZN6S629C52v8Ev();
extern void _ZN6S629C52v9Ev();
extern void _ZN6S629C53v10Ev();
extern void _ZN6S629C53v11Ev();
extern void _ZN6S629C53v12Ev();
extern void _ZN6S629C53v13Ev();
extern void _ZN6S629C53v14Ev();
extern void _ZN6S629C53v15Ev();
extern void _ZN6S629C53v16Ev();
extern void _ZN6S629C53v17Ev();
extern void _ZN6S629C53v18Ev();
extern void _ZN6S629C53v19Ev();
extern void _ZN6S629C53v20Ev();
extern void _ZN6S629C53v21Ev();
extern void _ZN6S629C53v22Ev();
extern void _ZN6S629C53v23Ev();
extern void _ZN6S629C53v24Ev();
extern void _ZN6S629C53v25Ev();
extern void _ZN6S629C53v26Ev();
extern void _ZN6S629C53v27Ev();
extern void _ZN6S629C53v28Ev();
extern void _ZN6S629C53v29Ev();
extern void _ZN6S629C53v30Ev();
extern void _ZN6S629C53v31Ev();
extern void _ZN6S629C53v32Ev();
extern void _ZN6S629C53v33Ev();
extern void _ZN6S629C53v34Ev();
extern void _ZN6S629C53v35Ev();
extern void _ZN6S629C53v36Ev();
extern void _ZN6S629C53v37Ev();
extern void _ZN6S629C53v38Ev();
extern void _ZN6S629C53v39Ev();
extern void _ZN6S629C53v40Ev();
extern void _ZN6S629C53v41Ev();
extern void _ZN6S629C53v42Ev();
extern void _ZN6S629C53v43Ev();
extern void _ZN6S629C53v44Ev();
extern void _ZN6S629C53v45Ev();
extern void _ZN6S629C53v46Ev();
extern void _ZN6S629C53v47Ev();
extern void _ZN6S629C53v48Ev();
extern void _ZN6S629C53v49Ev();
extern void _ZN6S629C53v50Ev();
extern void _ZN6S629C53v51Ev();
extern void _ZN6S629C53v52Ev();
extern void _ZN6S629C53v53Ev();
extern void _ZN6S629C53v54Ev();
extern void _ZN6S629C53v55Ev();
extern void _ZN6S629C53v56Ev();
extern void _ZN6S629C53v57Ev();
extern void _ZN6S629C53v58Ev();
extern void _ZN6S629C53v59Ev();
extern void _ZN6S629C53v60Ev();
extern void _ZN6S629C53v61Ev();
extern void _ZN6S629C53v62Ev();
extern void _ZN6S629C53v63Ev();
extern void _ZN6S629C53v64Ev();
extern void _ZN6S629C53v65Ev();
extern void _ZN6S629C53v66Ev();
extern void _ZN6S629C53v67Ev();
extern void _ZN6S629C53v68Ev();
static  VTBL_ENTRY vtc_S629C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S629C5[0]),
  (VTBL_ENTRY)&_ZN6S629C5D1Ev,
  (VTBL_ENTRY)&_ZN6S629C5D0Ev,
  (VTBL_ENTRY)&_ZN6S629C52v5Ev,
  (VTBL_ENTRY)&_ZN6S629C52v6Ev,
  (VTBL_ENTRY)&_ZN6S629C52v7Ev,
  (VTBL_ENTRY)&_ZN6S629C52v8Ev,
  (VTBL_ENTRY)&_ZN6S629C52v9Ev,
  (VTBL_ENTRY)&_ZN6S629C53v10Ev,
  (VTBL_ENTRY)&_ZN6S629C53v11Ev,
  (VTBL_ENTRY)&_ZN6S629C53v12Ev,
  (VTBL_ENTRY)&_ZN6S629C53v13Ev,
  (VTBL_ENTRY)&_ZN6S629C53v14Ev,
  (VTBL_ENTRY)&_ZN6S629C53v15Ev,
  (VTBL_ENTRY)&_ZN6S629C53v16Ev,
  (VTBL_ENTRY)&_ZN6S629C53v17Ev,
  (VTBL_ENTRY)&_ZN6S629C53v18Ev,
  (VTBL_ENTRY)&_ZN6S629C53v19Ev,
  (VTBL_ENTRY)&_ZN6S629C53v20Ev,
  (VTBL_ENTRY)&_ZN6S629C53v21Ev,
  (VTBL_ENTRY)&_ZN6S629C53v22Ev,
  (VTBL_ENTRY)&_ZN6S629C53v23Ev,
  (VTBL_ENTRY)&_ZN6S629C53v24Ev,
  (VTBL_ENTRY)&_ZN6S629C53v25Ev,
  (VTBL_ENTRY)&_ZN6S629C53v26Ev,
  (VTBL_ENTRY)&_ZN6S629C53v27Ev,
  (VTBL_ENTRY)&_ZN6S629C53v28Ev,
  (VTBL_ENTRY)&_ZN6S629C53v29Ev,
  (VTBL_ENTRY)&_ZN6S629C53v30Ev,
  (VTBL_ENTRY)&_ZN6S629C53v31Ev,
  (VTBL_ENTRY)&_ZN6S629C53v32Ev,
  (VTBL_ENTRY)&_ZN6S629C53v33Ev,
  (VTBL_ENTRY)&_ZN6S629C53v34Ev,
  (VTBL_ENTRY)&_ZN6S629C53v35Ev,
  (VTBL_ENTRY)&_ZN6S629C53v36Ev,
  (VTBL_ENTRY)&_ZN6S629C53v37Ev,
  (VTBL_ENTRY)&_ZN6S629C53v38Ev,
  (VTBL_ENTRY)&_ZN6S629C53v39Ev,
  (VTBL_ENTRY)&_ZN6S629C53v40Ev,
  (VTBL_ENTRY)&_ZN6S629C53v41Ev,
  (VTBL_ENTRY)&_ZN6S629C53v42Ev,
  (VTBL_ENTRY)&_ZN6S629C53v43Ev,
  (VTBL_ENTRY)&_ZN6S629C53v44Ev,
  (VTBL_ENTRY)&_ZN6S629C53v45Ev,
  (VTBL_ENTRY)&_ZN6S629C53v46Ev,
  (VTBL_ENTRY)&_ZN6S629C53v47Ev,
  (VTBL_ENTRY)&_ZN6S629C53v48Ev,
  (VTBL_ENTRY)&_ZN6S629C53v49Ev,
  (VTBL_ENTRY)&_ZN6S629C53v50Ev,
  (VTBL_ENTRY)&_ZN6S629C53v51Ev,
  (VTBL_ENTRY)&_ZN6S629C53v52Ev,
  (VTBL_ENTRY)&_ZN6S629C53v53Ev,
  (VTBL_ENTRY)&_ZN6S629C53v54Ev,
  (VTBL_ENTRY)&_ZN6S629C53v55Ev,
  (VTBL_ENTRY)&_ZN6S629C53v56Ev,
  (VTBL_ENTRY)&_ZN6S629C53v57Ev,
  (VTBL_ENTRY)&_ZN6S629C53v58Ev,
  (VTBL_ENTRY)&_ZN6S629C53v59Ev,
  (VTBL_ENTRY)&_ZN6S629C53v60Ev,
  (VTBL_ENTRY)&_ZN6S629C53v61Ev,
  (VTBL_ENTRY)&_ZN6S629C53v62Ev,
  (VTBL_ENTRY)&_ZN6S629C53v63Ev,
  (VTBL_ENTRY)&_ZN6S629C53v64Ev,
  (VTBL_ENTRY)&_ZN6S629C53v65Ev,
  (VTBL_ENTRY)&_ZN6S629C53v66Ev,
  (VTBL_ENTRY)&_ZN6S629C53v67Ev,
  (VTBL_ENTRY)&_ZN6S629C53v68Ev,
};
extern VTBL_ENTRY _ZTI6S629C5[];
extern  VTBL_ENTRY _ZTV6S629C5[];
Class_Descriptor cd_S629C5 = {  "S629C5", // class name
  0,0,//no base classes
  &(vtc_S629C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S629C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S629C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S629C4_nt  : S629C5 {
  void *s629c4f0;
  ::S1503C5_nt s629c4f1;
  virtual  ~S629C4_nt(); // _ZN9S629C4_ntD1Ev
  virtual void  v69(); // _ZN9S629C4_nt3v69Ev
  virtual void  v70(); // _ZN9S629C4_nt3v70Ev
  virtual void  v71(); // _ZN9S629C4_nt3v71Ev
  virtual void  v72(); // _ZN9S629C4_nt3v72Ev
  virtual void  v73(); // _ZN9S629C4_nt3v73Ev
  S629C4_nt(); // tgen
};
//SIG(-1 S629C4_nt) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S629C4_nt ::~S629C4_nt(){ note_dtor("S629C4_nt", this);}
void  S629C4_nt ::v69(){vfunc_called(this, "_ZN9S629C4_nt3v69Ev");}
void  S629C4_nt ::v70(){vfunc_called(this, "_ZN9S629C4_nt3v70Ev");}
void  S629C4_nt ::v71(){vfunc_called(this, "_ZN9S629C4_nt3v71Ev");}
void  S629C4_nt ::v72(){vfunc_called(this, "_ZN9S629C4_nt3v72Ev");}
void  S629C4_nt ::v73(){vfunc_called(this, "_ZN9S629C4_nt3v73Ev");}
S629C4_nt ::S629C4_nt(){ note_ctor("S629C4_nt", this);} // tgen

//skip512 S629C4_nt

#else // __cplusplus

extern void _ZN9S629C4_ntC1Ev();
extern void _ZN9S629C4_ntD1Ev();
Name_Map name_map_S629C4_nt[] = {
  NSPAIR(_ZN9S629C4_ntC1Ev),
  NSPAIR(_ZN9S629C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S629C5;
extern VTBL_ENTRY _ZTI6S629C5[];
extern  VTBL_ENTRY _ZTV6S629C5[];
static Base_Class bases_S629C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S629C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S629C4_nt[];
extern void _ZN9S629C4_ntD1Ev();
extern void _ZN9S629C4_ntD0Ev();
extern void _ZN6S629C52v5Ev();
extern void _ZN6S629C52v6Ev();
extern void _ZN6S629C52v7Ev();
extern void _ZN6S629C52v8Ev();
extern void _ZN6S629C52v9Ev();
extern void _ZN6S629C53v10Ev();
extern void _ZN6S629C53v11Ev();
extern void _ZN6S629C53v12Ev();
extern void _ZN6S629C53v13Ev();
extern void _ZN6S629C53v14Ev();
extern void _ZN6S629C53v15Ev();
extern void _ZN6S629C53v16Ev();
extern void _ZN6S629C53v17Ev();
extern void _ZN6S629C53v18Ev();
extern void _ZN6S629C53v19Ev();
extern void _ZN6S629C53v20Ev();
extern void _ZN6S629C53v21Ev();
extern void _ZN6S629C53v22Ev();
extern void _ZN6S629C53v23Ev();
extern void _ZN6S629C53v24Ev();
extern void _ZN6S629C53v25Ev();
extern void _ZN6S629C53v26Ev();
extern void _ZN6S629C53v27Ev();
extern void _ZN6S629C53v28Ev();
extern void _ZN6S629C53v29Ev();
extern void _ZN6S629C53v30Ev();
extern void _ZN6S629C53v31Ev();
extern void _ZN6S629C53v32Ev();
extern void _ZN6S629C53v33Ev();
extern void _ZN6S629C53v34Ev();
extern void _ZN6S629C53v35Ev();
extern void _ZN6S629C53v36Ev();
extern void _ZN6S629C53v37Ev();
extern void _ZN6S629C53v38Ev();
extern void _ZN6S629C53v39Ev();
extern void _ZN6S629C53v40Ev();
extern void _ZN6S629C53v41Ev();
extern void _ZN6S629C53v42Ev();
extern void _ZN6S629C53v43Ev();
extern void _ZN6S629C53v44Ev();
extern void _ZN6S629C53v45Ev();
extern void _ZN6S629C53v46Ev();
extern void _ZN6S629C53v47Ev();
extern void _ZN6S629C53v48Ev();
extern void _ZN6S629C53v49Ev();
extern void _ZN6S629C53v50Ev();
extern void _ZN6S629C53v51Ev();
extern void _ZN6S629C53v52Ev();
extern void _ZN6S629C53v53Ev();
extern void _ZN6S629C53v54Ev();
extern void _ZN6S629C53v55Ev();
extern void _ZN6S629C53v56Ev();
extern void _ZN6S629C53v57Ev();
extern void _ZN6S629C53v58Ev();
extern void _ZN6S629C53v59Ev();
extern void _ZN6S629C53v60Ev();
extern void _ZN6S629C53v61Ev();
extern void _ZN6S629C53v62Ev();
extern void _ZN6S629C53v63Ev();
extern void _ZN6S629C53v64Ev();
extern void _ZN6S629C53v65Ev();
extern void _ZN6S629C53v66Ev();
extern void _ZN6S629C53v67Ev();
extern void _ZN6S629C53v68Ev();
extern void _ZN9S629C4_nt3v69Ev();
extern void _ZN9S629C4_nt3v70Ev();
extern void _ZN9S629C4_nt3v71Ev();
extern void _ZN9S629C4_nt3v72Ev();
extern void _ZN9S629C4_nt3v73Ev();
static  VTBL_ENTRY vtc_S629C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S629C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S629C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S629C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S629C52v5Ev,
  (VTBL_ENTRY)&_ZN6S629C52v6Ev,
  (VTBL_ENTRY)&_ZN6S629C52v7Ev,
  (VTBL_ENTRY)&_ZN6S629C52v8Ev,
  (VTBL_ENTRY)&_ZN6S629C52v9Ev,
  (VTBL_ENTRY)&_ZN6S629C53v10Ev,
  (VTBL_ENTRY)&_ZN6S629C53v11Ev,
  (VTBL_ENTRY)&_ZN6S629C53v12Ev,
  (VTBL_ENTRY)&_ZN6S629C53v13Ev,
  (VTBL_ENTRY)&_ZN6S629C53v14Ev,
  (VTBL_ENTRY)&_ZN6S629C53v15Ev,
  (VTBL_ENTRY)&_ZN6S629C53v16Ev,
  (VTBL_ENTRY)&_ZN6S629C53v17Ev,
  (VTBL_ENTRY)&_ZN6S629C53v18Ev,
  (VTBL_ENTRY)&_ZN6S629C53v19Ev,
  (VTBL_ENTRY)&_ZN6S629C53v20Ev,
  (VTBL_ENTRY)&_ZN6S629C53v21Ev,
  (VTBL_ENTRY)&_ZN6S629C53v22Ev,
  (VTBL_ENTRY)&_ZN6S629C53v23Ev,
  (VTBL_ENTRY)&_ZN6S629C53v24Ev,
  (VTBL_ENTRY)&_ZN6S629C53v25Ev,
  (VTBL_ENTRY)&_ZN6S629C53v26Ev,
  (VTBL_ENTRY)&_ZN6S629C53v27Ev,
  (VTBL_ENTRY)&_ZN6S629C53v28Ev,
  (VTBL_ENTRY)&_ZN6S629C53v29Ev,
  (VTBL_ENTRY)&_ZN6S629C53v30Ev,
  (VTBL_ENTRY)&_ZN6S629C53v31Ev,
  (VTBL_ENTRY)&_ZN6S629C53v32Ev,
  (VTBL_ENTRY)&_ZN6S629C53v33Ev,
  (VTBL_ENTRY)&_ZN6S629C53v34Ev,
  (VTBL_ENTRY)&_ZN6S629C53v35Ev,
  (VTBL_ENTRY)&_ZN6S629C53v36Ev,
  (VTBL_ENTRY)&_ZN6S629C53v37Ev,
  (VTBL_ENTRY)&_ZN6S629C53v38Ev,
  (VTBL_ENTRY)&_ZN6S629C53v39Ev,
  (VTBL_ENTRY)&_ZN6S629C53v40Ev,
  (VTBL_ENTRY)&_ZN6S629C53v41Ev,
  (VTBL_ENTRY)&_ZN6S629C53v42Ev,
  (VTBL_ENTRY)&_ZN6S629C53v43Ev,
  (VTBL_ENTRY)&_ZN6S629C53v44Ev,
  (VTBL_ENTRY)&_ZN6S629C53v45Ev,
  (VTBL_ENTRY)&_ZN6S629C53v46Ev,
  (VTBL_ENTRY)&_ZN6S629C53v47Ev,
  (VTBL_ENTRY)&_ZN6S629C53v48Ev,
  (VTBL_ENTRY)&_ZN6S629C53v49Ev,
  (VTBL_ENTRY)&_ZN6S629C53v50Ev,
  (VTBL_ENTRY)&_ZN6S629C53v51Ev,
  (VTBL_ENTRY)&_ZN6S629C53v52Ev,
  (VTBL_ENTRY)&_ZN6S629C53v53Ev,
  (VTBL_ENTRY)&_ZN6S629C53v54Ev,
  (VTBL_ENTRY)&_ZN6S629C53v55Ev,
  (VTBL_ENTRY)&_ZN6S629C53v56Ev,
  (VTBL_ENTRY)&_ZN6S629C53v57Ev,
  (VTBL_ENTRY)&_ZN6S629C53v58Ev,
  (VTBL_ENTRY)&_ZN6S629C53v59Ev,
  (VTBL_ENTRY)&_ZN6S629C53v60Ev,
  (VTBL_ENTRY)&_ZN6S629C53v61Ev,
  (VTBL_ENTRY)&_ZN6S629C53v62Ev,
  (VTBL_ENTRY)&_ZN6S629C53v63Ev,
  (VTBL_ENTRY)&_ZN6S629C53v64Ev,
  (VTBL_ENTRY)&_ZN6S629C53v65Ev,
  (VTBL_ENTRY)&_ZN6S629C53v66Ev,
  (VTBL_ENTRY)&_ZN6S629C53v67Ev,
  (VTBL_ENTRY)&_ZN6S629C53v68Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v73Ev,
};
extern VTBL_ENTRY _ZTI9S629C4_nt[];
VTBL_ENTRY *P__ZTI9S629C4_nt = _ZTI9S629C4_nt; 
extern  VTBL_ENTRY _ZTV9S629C4_nt[];
Class_Descriptor cd_S629C4_nt = {  "S629C4_nt", // class name
  bases_S629C4_nt, 1,
  &(vtc_S629C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI9S629C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S629C4_nt),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S629C3_nt  : S629C4_nt {
  void *s629c3f0[2];
  unsigned int s629c3f1:1;
  unsigned int s629c3f2:1;
  unsigned int s629c3f3:1;
  unsigned int s629c3f4:1;
  char s629c3f5;
  virtual  ~S629C3_nt(); // _ZN9S629C3_ntD1Ev
  virtual void  v74(); // _ZN9S629C3_nt3v74Ev
  virtual void  v75(); // _ZN9S629C3_nt3v75Ev
  virtual void  v76(); // _ZN9S629C3_nt3v76Ev
  virtual void  v77(); // _ZN9S629C3_nt3v77Ev
  virtual void  v78(); // _ZN9S629C3_nt3v78Ev
  virtual void  v79(); // _ZN9S629C3_nt3v79Ev
  virtual void  v80(); // _ZN9S629C3_nt3v80Ev
  virtual void  v81(); // _ZN9S629C3_nt3v81Ev
  virtual void  v82(); // _ZN9S629C3_nt3v82Ev
  virtual void  v83(); // _ZN9S629C3_nt3v83Ev
  virtual void  v84(); // _ZN9S629C3_nt3v84Ev
  virtual void  v85(); // _ZN9S629C3_nt3v85Ev
  virtual void  v86(); // _ZN9S629C3_nt3v86Ev
  virtual void  v87(); // _ZN9S629C3_nt3v87Ev
  virtual void  v88(); // _ZN9S629C3_nt3v88Ev
  virtual void  v89(); // _ZN9S629C3_nt3v89Ev
  virtual void  v90(); // _ZN9S629C3_nt3v90Ev
  virtual void  v91(); // _ZN9S629C3_nt3v91Ev
  virtual void  v92(); // _ZN9S629C3_nt3v92Ev
  virtual void  v93(); // _ZN9S629C3_nt3v93Ev
  virtual void  v94(); // _ZN9S629C3_nt3v94Ev
  virtual void  v95(); // _ZN9S629C3_nt3v95Ev
  S629C3_nt(); // tgen
};
//SIG(-1 S629C3_nt) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S629C3_nt ::~S629C3_nt(){ note_dtor("S629C3_nt", this);}
void  S629C3_nt ::v74(){vfunc_called(this, "_ZN9S629C3_nt3v74Ev");}
void  S629C3_nt ::v75(){vfunc_called(this, "_ZN9S629C3_nt3v75Ev");}
void  S629C3_nt ::v76(){vfunc_called(this, "_ZN9S629C3_nt3v76Ev");}
void  S629C3_nt ::v77(){vfunc_called(this, "_ZN9S629C3_nt3v77Ev");}
void  S629C3_nt ::v78(){vfunc_called(this, "_ZN9S629C3_nt3v78Ev");}
void  S629C3_nt ::v79(){vfunc_called(this, "_ZN9S629C3_nt3v79Ev");}
void  S629C3_nt ::v80(){vfunc_called(this, "_ZN9S629C3_nt3v80Ev");}
void  S629C3_nt ::v81(){vfunc_called(this, "_ZN9S629C3_nt3v81Ev");}
void  S629C3_nt ::v82(){vfunc_called(this, "_ZN9S629C3_nt3v82Ev");}
void  S629C3_nt ::v83(){vfunc_called(this, "_ZN9S629C3_nt3v83Ev");}
void  S629C3_nt ::v84(){vfunc_called(this, "_ZN9S629C3_nt3v84Ev");}
void  S629C3_nt ::v85(){vfunc_called(this, "_ZN9S629C3_nt3v85Ev");}
void  S629C3_nt ::v86(){vfunc_called(this, "_ZN9S629C3_nt3v86Ev");}
void  S629C3_nt ::v87(){vfunc_called(this, "_ZN9S629C3_nt3v87Ev");}
void  S629C3_nt ::v88(){vfunc_called(this, "_ZN9S629C3_nt3v88Ev");}
void  S629C3_nt ::v89(){vfunc_called(this, "_ZN9S629C3_nt3v89Ev");}
void  S629C3_nt ::v90(){vfunc_called(this, "_ZN9S629C3_nt3v90Ev");}
void  S629C3_nt ::v91(){vfunc_called(this, "_ZN9S629C3_nt3v91Ev");}
void  S629C3_nt ::v92(){vfunc_called(this, "_ZN9S629C3_nt3v92Ev");}
void  S629C3_nt ::v93(){vfunc_called(this, "_ZN9S629C3_nt3v93Ev");}
void  S629C3_nt ::v94(){vfunc_called(this, "_ZN9S629C3_nt3v94Ev");}
void  S629C3_nt ::v95(){vfunc_called(this, "_ZN9S629C3_nt3v95Ev");}
S629C3_nt ::S629C3_nt(){ note_ctor("S629C3_nt", this);} // tgen

//skip512 S629C3_nt

#else // __cplusplus

extern void _ZN9S629C3_ntC1Ev();
extern void _ZN9S629C3_ntD1Ev();
Name_Map name_map_S629C3_nt[] = {
  NSPAIR(_ZN9S629C3_ntC1Ev),
  NSPAIR(_ZN9S629C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S629C5;
extern VTBL_ENTRY _ZTI6S629C5[];
extern  VTBL_ENTRY _ZTV6S629C5[];
extern Class_Descriptor cd_S629C4_nt;
extern VTBL_ENTRY _ZTI9S629C4_nt[];
extern  VTBL_ENTRY _ZTV9S629C4_nt[];
static Base_Class bases_S629C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S629C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S629C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S629C3_nt[];
extern void _ZN9S629C3_ntD1Ev();
extern void _ZN9S629C3_ntD0Ev();
extern void _ZN6S629C52v5Ev();
extern void _ZN6S629C52v6Ev();
extern void _ZN6S629C52v7Ev();
extern void _ZN6S629C52v8Ev();
extern void _ZN6S629C52v9Ev();
extern void _ZN6S629C53v10Ev();
extern void _ZN6S629C53v11Ev();
extern void _ZN6S629C53v12Ev();
extern void _ZN6S629C53v13Ev();
extern void _ZN6S629C53v14Ev();
extern void _ZN6S629C53v15Ev();
extern void _ZN6S629C53v16Ev();
extern void _ZN6S629C53v17Ev();
extern void _ZN6S629C53v18Ev();
extern void _ZN6S629C53v19Ev();
extern void _ZN6S629C53v20Ev();
extern void _ZN6S629C53v21Ev();
extern void _ZN6S629C53v22Ev();
extern void _ZN6S629C53v23Ev();
extern void _ZN6S629C53v24Ev();
extern void _ZN6S629C53v25Ev();
extern void _ZN6S629C53v26Ev();
extern void _ZN6S629C53v27Ev();
extern void _ZN6S629C53v28Ev();
extern void _ZN6S629C53v29Ev();
extern void _ZN6S629C53v30Ev();
extern void _ZN6S629C53v31Ev();
extern void _ZN6S629C53v32Ev();
extern void _ZN6S629C53v33Ev();
extern void _ZN6S629C53v34Ev();
extern void _ZN6S629C53v35Ev();
extern void _ZN6S629C53v36Ev();
extern void _ZN6S629C53v37Ev();
extern void _ZN6S629C53v38Ev();
extern void _ZN6S629C53v39Ev();
extern void _ZN6S629C53v40Ev();
extern void _ZN6S629C53v41Ev();
extern void _ZN6S629C53v42Ev();
extern void _ZN6S629C53v43Ev();
extern void _ZN6S629C53v44Ev();
extern void _ZN6S629C53v45Ev();
extern void _ZN6S629C53v46Ev();
extern void _ZN6S629C53v47Ev();
extern void _ZN6S629C53v48Ev();
extern void _ZN6S629C53v49Ev();
extern void _ZN6S629C53v50Ev();
extern void _ZN6S629C53v51Ev();
extern void _ZN6S629C53v52Ev();
extern void _ZN6S629C53v53Ev();
extern void _ZN6S629C53v54Ev();
extern void _ZN6S629C53v55Ev();
extern void _ZN6S629C53v56Ev();
extern void _ZN6S629C53v57Ev();
extern void _ZN6S629C53v58Ev();
extern void _ZN6S629C53v59Ev();
extern void _ZN6S629C53v60Ev();
extern void _ZN6S629C53v61Ev();
extern void _ZN6S629C53v62Ev();
extern void _ZN6S629C53v63Ev();
extern void _ZN6S629C53v64Ev();
extern void _ZN6S629C53v65Ev();
extern void _ZN6S629C53v66Ev();
extern void _ZN6S629C53v67Ev();
extern void _ZN6S629C53v68Ev();
extern void _ZN9S629C4_nt3v69Ev();
extern void _ZN9S629C4_nt3v70Ev();
extern void _ZN9S629C4_nt3v71Ev();
extern void _ZN9S629C4_nt3v72Ev();
extern void _ZN9S629C4_nt3v73Ev();
extern void _ZN9S629C3_nt3v74Ev();
extern void _ZN9S629C3_nt3v75Ev();
extern void _ZN9S629C3_nt3v76Ev();
extern void _ZN9S629C3_nt3v77Ev();
extern void _ZN9S629C3_nt3v78Ev();
extern void _ZN9S629C3_nt3v79Ev();
extern void _ZN9S629C3_nt3v80Ev();
extern void _ZN9S629C3_nt3v81Ev();
extern void _ZN9S629C3_nt3v82Ev();
extern void _ZN9S629C3_nt3v83Ev();
extern void _ZN9S629C3_nt3v84Ev();
extern void _ZN9S629C3_nt3v85Ev();
extern void _ZN9S629C3_nt3v86Ev();
extern void _ZN9S629C3_nt3v87Ev();
extern void _ZN9S629C3_nt3v88Ev();
extern void _ZN9S629C3_nt3v89Ev();
extern void _ZN9S629C3_nt3v90Ev();
extern void _ZN9S629C3_nt3v91Ev();
extern void _ZN9S629C3_nt3v92Ev();
extern void _ZN9S629C3_nt3v93Ev();
extern void _ZN9S629C3_nt3v94Ev();
extern void _ZN9S629C3_nt3v95Ev();
static  VTBL_ENTRY vtc_S629C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S629C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S629C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S629C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S629C52v5Ev,
  (VTBL_ENTRY)&_ZN6S629C52v6Ev,
  (VTBL_ENTRY)&_ZN6S629C52v7Ev,
  (VTBL_ENTRY)&_ZN6S629C52v8Ev,
  (VTBL_ENTRY)&_ZN6S629C52v9Ev,
  (VTBL_ENTRY)&_ZN6S629C53v10Ev,
  (VTBL_ENTRY)&_ZN6S629C53v11Ev,
  (VTBL_ENTRY)&_ZN6S629C53v12Ev,
  (VTBL_ENTRY)&_ZN6S629C53v13Ev,
  (VTBL_ENTRY)&_ZN6S629C53v14Ev,
  (VTBL_ENTRY)&_ZN6S629C53v15Ev,
  (VTBL_ENTRY)&_ZN6S629C53v16Ev,
  (VTBL_ENTRY)&_ZN6S629C53v17Ev,
  (VTBL_ENTRY)&_ZN6S629C53v18Ev,
  (VTBL_ENTRY)&_ZN6S629C53v19Ev,
  (VTBL_ENTRY)&_ZN6S629C53v20Ev,
  (VTBL_ENTRY)&_ZN6S629C53v21Ev,
  (VTBL_ENTRY)&_ZN6S629C53v22Ev,
  (VTBL_ENTRY)&_ZN6S629C53v23Ev,
  (VTBL_ENTRY)&_ZN6S629C53v24Ev,
  (VTBL_ENTRY)&_ZN6S629C53v25Ev,
  (VTBL_ENTRY)&_ZN6S629C53v26Ev,
  (VTBL_ENTRY)&_ZN6S629C53v27Ev,
  (VTBL_ENTRY)&_ZN6S629C53v28Ev,
  (VTBL_ENTRY)&_ZN6S629C53v29Ev,
  (VTBL_ENTRY)&_ZN6S629C53v30Ev,
  (VTBL_ENTRY)&_ZN6S629C53v31Ev,
  (VTBL_ENTRY)&_ZN6S629C53v32Ev,
  (VTBL_ENTRY)&_ZN6S629C53v33Ev,
  (VTBL_ENTRY)&_ZN6S629C53v34Ev,
  (VTBL_ENTRY)&_ZN6S629C53v35Ev,
  (VTBL_ENTRY)&_ZN6S629C53v36Ev,
  (VTBL_ENTRY)&_ZN6S629C53v37Ev,
  (VTBL_ENTRY)&_ZN6S629C53v38Ev,
  (VTBL_ENTRY)&_ZN6S629C53v39Ev,
  (VTBL_ENTRY)&_ZN6S629C53v40Ev,
  (VTBL_ENTRY)&_ZN6S629C53v41Ev,
  (VTBL_ENTRY)&_ZN6S629C53v42Ev,
  (VTBL_ENTRY)&_ZN6S629C53v43Ev,
  (VTBL_ENTRY)&_ZN6S629C53v44Ev,
  (VTBL_ENTRY)&_ZN6S629C53v45Ev,
  (VTBL_ENTRY)&_ZN6S629C53v46Ev,
  (VTBL_ENTRY)&_ZN6S629C53v47Ev,
  (VTBL_ENTRY)&_ZN6S629C53v48Ev,
  (VTBL_ENTRY)&_ZN6S629C53v49Ev,
  (VTBL_ENTRY)&_ZN6S629C53v50Ev,
  (VTBL_ENTRY)&_ZN6S629C53v51Ev,
  (VTBL_ENTRY)&_ZN6S629C53v52Ev,
  (VTBL_ENTRY)&_ZN6S629C53v53Ev,
  (VTBL_ENTRY)&_ZN6S629C53v54Ev,
  (VTBL_ENTRY)&_ZN6S629C53v55Ev,
  (VTBL_ENTRY)&_ZN6S629C53v56Ev,
  (VTBL_ENTRY)&_ZN6S629C53v57Ev,
  (VTBL_ENTRY)&_ZN6S629C53v58Ev,
  (VTBL_ENTRY)&_ZN6S629C53v59Ev,
  (VTBL_ENTRY)&_ZN6S629C53v60Ev,
  (VTBL_ENTRY)&_ZN6S629C53v61Ev,
  (VTBL_ENTRY)&_ZN6S629C53v62Ev,
  (VTBL_ENTRY)&_ZN6S629C53v63Ev,
  (VTBL_ENTRY)&_ZN6S629C53v64Ev,
  (VTBL_ENTRY)&_ZN6S629C53v65Ev,
  (VTBL_ENTRY)&_ZN6S629C53v66Ev,
  (VTBL_ENTRY)&_ZN6S629C53v67Ev,
  (VTBL_ENTRY)&_ZN6S629C53v68Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v95Ev,
};
extern VTBL_ENTRY _ZTI9S629C3_nt[];
VTBL_ENTRY *P__ZTI9S629C3_nt = _ZTI9S629C3_nt; 
extern  VTBL_ENTRY _ZTV9S629C3_nt[];
Class_Descriptor cd_S629C3_nt = {  "S629C3_nt", // class name
  bases_S629C3_nt, 2,
  &(vtc_S629C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI9S629C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S629C3_nt),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S629C8_nt  {
  void  mf629c8(); // _ZN9S629C8_nt7mf629c8Ev
};
//SIG(-1 S629C8_nt) C1{ m}


void  S629C8_nt ::mf629c8(){}

//skip512 S629C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S629C8_nt[];
VTBL_ENTRY *P__ZTI9S629C8_nt = _ZTI9S629C8_nt; 
Class_Descriptor cd_S629C8_nt = {  "S629C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI9S629C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S629C11_nt  {
  ::S1503C14_nt s629c11f0;
  ::S1503C14_nt s629c11f1;
  int s629c11f2;
  void  mf629c11(); // _ZN10S629C11_nt8mf629c11Ev
};
//SIG(-1 S629C11_nt) C1{ m FC2{ m Fi[3]} FC2 Fi}


void  S629C11_nt ::mf629c11(){}

//skip512 S629C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S629C14  {
  void  mf629c14(); // _ZN7S629C148mf629c14Ev
};
//SIG(-1 S629C14) C1{ m}


void  S629C14 ::mf629c14(){}

static void Test_S629C14()
{
  {
    init_simple_test("S629C14");
    S629C14 lv;
    check2(sizeof(lv), 1, "sizeof(S629C14)");
    check2(__alignof__(lv), 1, "__alignof__(S629C14)");
  }
}
static Arrange_To_Call_Me vS629C14(Test_S629C14, "S629C14", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S629C14[];
VTBL_ENTRY *P__ZTI7S629C14 = _ZTI7S629C14; 
Class_Descriptor cd_S629C14 = {  "S629C14", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI7S629C14),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S629C17_nt  {
  int s629c17f0[3];
  void  mf629c17(); // _ZN10S629C17_nt8mf629c17Ev
};
//SIG(-1 S629C17_nt) C1{ m Fi[3]}


void  S629C17_nt ::mf629c17(){}

//skip512 S629C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S629C2_nt  : S629C3_nt {
  void *s629c2f0;
  ::S1503C9_nt s629c2f1;
  int s629c2f2;
  ::S629C8_nt s629c2f3;
  int s629c2f4;
  ::S1503C29 s629c2f5;
  int s629c2f6;
  void *s629c2f7[2];
  ::S629C11_nt s629c2f8;
  void *s629c2f9;
  int s629c2f10[2];
  char s629c2f11[3];
  int s629c2f12;
  unsigned int s629c2f13:1;
  unsigned int s629c2f14:1;
  unsigned int s629c2f15:1;
  unsigned int s629c2f16:1;
  unsigned int s629c2f17:1;
  unsigned int s629c2f18:1;
  unsigned int s629c2f19:1;
  unsigned int s629c2f20:1;
  unsigned int s629c2f21:1;
  unsigned int s629c2f22:1;
  unsigned int s629c2f23:1;
  unsigned int s629c2f24:1;
  unsigned int s629c2f25:1;
  unsigned int s629c2f26:1;
  int s629c2f27;
  unsigned int s629c2f28:1;
  unsigned int s629c2f29:1;
  unsigned int s629c2f30:1;
  unsigned int s629c2f31:1;
  unsigned int s629c2f32:1;
  unsigned int s629c2f33:1;
  ::S629C8_nt s629c2f34;
  unsigned int s629c2f35:1;
  unsigned int s629c2f36:1;
  unsigned int s629c2f37:1;
  unsigned int s629c2f38:1;
  unsigned int s629c2f39:1;
  unsigned int s629c2f40:1;
  unsigned int s629c2f41:1;
  char s629c2f42;
  ::S629C14 s629c2f43;
  unsigned int s629c2f44:1;
  unsigned int s629c2f45:1;
  unsigned int s629c2f46:1;
  unsigned int s629c2f47:1;
  unsigned int s629c2f48:1;
  unsigned int s629c2f49:1;
  unsigned int s629c2f50:1;
  unsigned int s629c2f51:1;
  unsigned int s629c2f52:1;
  unsigned int s629c2f53:1;
  unsigned int s629c2f54:1;
  unsigned int s629c2f55:1;
  ::S1503C28 s629c2f56;
  void *s629c2f57[2];
  char s629c2f58;
  ::S629C8_nt s629c2f59;
  ::S1503C14_nt s629c2f60;
  ::S629C17_nt s629c2f61;
  int s629c2f62;
  ::S1503C14_nt s629c2f63;
  unsigned int s629c2f64:1;
  unsigned int s629c2f65:1;
  unsigned int s629c2f66:1;
  int s629c2f67[3];
  virtual  ~S629C2_nt(); // _ZN9S629C2_ntD1Ev
  virtual void  v96(); // _ZN9S629C2_nt3v96Ev
  virtual void  v97(); // _ZN9S629C2_nt3v97Ev
  virtual void  v98(); // _ZN9S629C2_nt3v98Ev
  virtual void  v99(); // _ZN9S629C2_nt3v99Ev
  virtual void  v100(); // _ZN9S629C2_nt4v100Ev
  virtual void  v101(); // _ZN9S629C2_nt4v101Ev
  virtual void  v102(); // _ZN9S629C2_nt4v102Ev
  virtual void  v103(); // _ZN9S629C2_nt4v103Ev
  virtual void  v104(); // _ZN9S629C2_nt4v104Ev
  virtual void  v105(); // _ZN9S629C2_nt4v105Ev
  virtual void  v106(); // _ZN9S629C2_nt4v106Ev
  virtual void  v107(); // _ZN9S629C2_nt4v107Ev
  virtual void  v108(); // _ZN9S629C2_nt4v108Ev
  virtual void  v109(); // _ZN9S629C2_nt4v109Ev
  virtual void  v110(); // _ZN9S629C2_nt4v110Ev
  virtual void  v111(); // _ZN9S629C2_nt4v111Ev
  virtual void  v112(); // _ZN9S629C2_nt4v112Ev
  virtual void  v113(); // _ZN9S629C2_nt4v113Ev
  virtual void  v114(); // _ZN9S629C2_nt4v114Ev
  virtual void  v115(); // _ZN9S629C2_nt4v115Ev
  virtual void  v116(); // _ZN9S629C2_nt4v116Ev
  virtual void  v117(); // _ZN9S629C2_nt4v117Ev
  virtual void  v118(); // _ZN9S629C2_nt4v118Ev
  virtual void  v119(); // _ZN9S629C2_nt4v119Ev
  virtual void  v120(); // _ZN9S629C2_nt4v120Ev
  virtual void  v121(); // _ZN9S629C2_nt4v121Ev
  virtual void  v122(); // _ZN9S629C2_nt4v122Ev
  virtual void  v123(); // _ZN9S629C2_nt4v123Ev
  virtual void  v124(); // _ZN9S629C2_nt4v124Ev
  virtual void  v125(); // _ZN9S629C2_nt4v125Ev
  virtual void  v126(); // _ZN9S629C2_nt4v126Ev
  virtual void  v127(); // _ZN9S629C2_nt4v127Ev
  virtual void  v128(); // _ZN9S629C2_nt4v128Ev
  virtual void  v129(); // _ZN9S629C2_nt4v129Ev
  virtual void  v130(); // _ZN9S629C2_nt4v130Ev
  virtual void  v131(); // _ZN9S629C2_nt4v131Ev
  virtual void  v132(); // _ZN9S629C2_nt4v132Ev
  virtual void  v133(); // _ZN9S629C2_nt4v133Ev
  virtual void  v134(); // _ZN9S629C2_nt4v134Ev
  virtual void  v135(); // _ZN9S629C2_nt4v135Ev
  virtual void  v136(); // _ZN9S629C2_nt4v136Ev
  virtual void  v137(); // _ZN9S629C2_nt4v137Ev
  virtual void  v138(); // _ZN9S629C2_nt4v138Ev
  virtual void  v139(); // _ZN9S629C2_nt4v139Ev
  virtual void  v140(); // _ZN9S629C2_nt4v140Ev
  virtual void  v141(); // _ZN9S629C2_nt4v141Ev
  virtual void  v142(); // _ZN9S629C2_nt4v142Ev
  virtual void  v143(); // _ZN9S629C2_nt4v143Ev
  virtual void  v144(); // _ZN9S629C2_nt4v144Ev
  virtual void  v145(); // _ZN9S629C2_nt4v145Ev
  virtual void  v146(); // _ZN9S629C2_nt4v146Ev
  virtual void  v147(); // _ZN9S629C2_nt4v147Ev
  virtual void  v148(); // _ZN9S629C2_nt4v148Ev
  virtual void  v149(); // _ZN9S629C2_nt4v149Ev
  virtual void  v150(); // _ZN9S629C2_nt4v150Ev
  virtual void  v151(); // _ZN9S629C2_nt4v151Ev
  virtual void  v152(); // _ZN9S629C2_nt4v152Ev
  virtual void  v153(); // _ZN9S629C2_nt4v153Ev
  virtual void  v154(); // _ZN9S629C2_nt4v154Ev
  virtual void  v155(); // _ZN9S629C2_nt4v155Ev
  virtual void  v156(); // _ZN9S629C2_nt4v156Ev
  S629C2_nt(); // tgen
};
//SIG(-1 S629C2_nt) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ BC8} Fp[2] Fc FC7 FC11 FC14{ m Fi[3]} Fi FC11 Fi:1 Fi:1 Fi:1 Fi[3]}


 S629C2_nt ::~S629C2_nt(){ note_dtor("S629C2_nt", this);}
void  S629C2_nt ::v96(){vfunc_called(this, "_ZN9S629C2_nt3v96Ev");}
void  S629C2_nt ::v97(){vfunc_called(this, "_ZN9S629C2_nt3v97Ev");}
void  S629C2_nt ::v98(){vfunc_called(this, "_ZN9S629C2_nt3v98Ev");}
void  S629C2_nt ::v99(){vfunc_called(this, "_ZN9S629C2_nt3v99Ev");}
void  S629C2_nt ::v100(){vfunc_called(this, "_ZN9S629C2_nt4v100Ev");}
void  S629C2_nt ::v101(){vfunc_called(this, "_ZN9S629C2_nt4v101Ev");}
void  S629C2_nt ::v102(){vfunc_called(this, "_ZN9S629C2_nt4v102Ev");}
void  S629C2_nt ::v103(){vfunc_called(this, "_ZN9S629C2_nt4v103Ev");}
void  S629C2_nt ::v104(){vfunc_called(this, "_ZN9S629C2_nt4v104Ev");}
void  S629C2_nt ::v105(){vfunc_called(this, "_ZN9S629C2_nt4v105Ev");}
void  S629C2_nt ::v106(){vfunc_called(this, "_ZN9S629C2_nt4v106Ev");}
void  S629C2_nt ::v107(){vfunc_called(this, "_ZN9S629C2_nt4v107Ev");}
void  S629C2_nt ::v108(){vfunc_called(this, "_ZN9S629C2_nt4v108Ev");}
void  S629C2_nt ::v109(){vfunc_called(this, "_ZN9S629C2_nt4v109Ev");}
void  S629C2_nt ::v110(){vfunc_called(this, "_ZN9S629C2_nt4v110Ev");}
void  S629C2_nt ::v111(){vfunc_called(this, "_ZN9S629C2_nt4v111Ev");}
void  S629C2_nt ::v112(){vfunc_called(this, "_ZN9S629C2_nt4v112Ev");}
void  S629C2_nt ::v113(){vfunc_called(this, "_ZN9S629C2_nt4v113Ev");}
void  S629C2_nt ::v114(){vfunc_called(this, "_ZN9S629C2_nt4v114Ev");}
void  S629C2_nt ::v115(){vfunc_called(this, "_ZN9S629C2_nt4v115Ev");}
void  S629C2_nt ::v116(){vfunc_called(this, "_ZN9S629C2_nt4v116Ev");}
void  S629C2_nt ::v117(){vfunc_called(this, "_ZN9S629C2_nt4v117Ev");}
void  S629C2_nt ::v118(){vfunc_called(this, "_ZN9S629C2_nt4v118Ev");}
void  S629C2_nt ::v119(){vfunc_called(this, "_ZN9S629C2_nt4v119Ev");}
void  S629C2_nt ::v120(){vfunc_called(this, "_ZN9S629C2_nt4v120Ev");}
void  S629C2_nt ::v121(){vfunc_called(this, "_ZN9S629C2_nt4v121Ev");}
void  S629C2_nt ::v122(){vfunc_called(this, "_ZN9S629C2_nt4v122Ev");}
void  S629C2_nt ::v123(){vfunc_called(this, "_ZN9S629C2_nt4v123Ev");}
void  S629C2_nt ::v124(){vfunc_called(this, "_ZN9S629C2_nt4v124Ev");}
void  S629C2_nt ::v125(){vfunc_called(this, "_ZN9S629C2_nt4v125Ev");}
void  S629C2_nt ::v126(){vfunc_called(this, "_ZN9S629C2_nt4v126Ev");}
void  S629C2_nt ::v127(){vfunc_called(this, "_ZN9S629C2_nt4v127Ev");}
void  S629C2_nt ::v128(){vfunc_called(this, "_ZN9S629C2_nt4v128Ev");}
void  S629C2_nt ::v129(){vfunc_called(this, "_ZN9S629C2_nt4v129Ev");}
void  S629C2_nt ::v130(){vfunc_called(this, "_ZN9S629C2_nt4v130Ev");}
void  S629C2_nt ::v131(){vfunc_called(this, "_ZN9S629C2_nt4v131Ev");}
void  S629C2_nt ::v132(){vfunc_called(this, "_ZN9S629C2_nt4v132Ev");}
void  S629C2_nt ::v133(){vfunc_called(this, "_ZN9S629C2_nt4v133Ev");}
void  S629C2_nt ::v134(){vfunc_called(this, "_ZN9S629C2_nt4v134Ev");}
void  S629C2_nt ::v135(){vfunc_called(this, "_ZN9S629C2_nt4v135Ev");}
void  S629C2_nt ::v136(){vfunc_called(this, "_ZN9S629C2_nt4v136Ev");}
void  S629C2_nt ::v137(){vfunc_called(this, "_ZN9S629C2_nt4v137Ev");}
void  S629C2_nt ::v138(){vfunc_called(this, "_ZN9S629C2_nt4v138Ev");}
void  S629C2_nt ::v139(){vfunc_called(this, "_ZN9S629C2_nt4v139Ev");}
void  S629C2_nt ::v140(){vfunc_called(this, "_ZN9S629C2_nt4v140Ev");}
void  S629C2_nt ::v141(){vfunc_called(this, "_ZN9S629C2_nt4v141Ev");}
void  S629C2_nt ::v142(){vfunc_called(this, "_ZN9S629C2_nt4v142Ev");}
void  S629C2_nt ::v143(){vfunc_called(this, "_ZN9S629C2_nt4v143Ev");}
void  S629C2_nt ::v144(){vfunc_called(this, "_ZN9S629C2_nt4v144Ev");}
void  S629C2_nt ::v145(){vfunc_called(this, "_ZN9S629C2_nt4v145Ev");}
void  S629C2_nt ::v146(){vfunc_called(this, "_ZN9S629C2_nt4v146Ev");}
void  S629C2_nt ::v147(){vfunc_called(this, "_ZN9S629C2_nt4v147Ev");}
void  S629C2_nt ::v148(){vfunc_called(this, "_ZN9S629C2_nt4v148Ev");}
void  S629C2_nt ::v149(){vfunc_called(this, "_ZN9S629C2_nt4v149Ev");}
void  S629C2_nt ::v150(){vfunc_called(this, "_ZN9S629C2_nt4v150Ev");}
void  S629C2_nt ::v151(){vfunc_called(this, "_ZN9S629C2_nt4v151Ev");}
void  S629C2_nt ::v152(){vfunc_called(this, "_ZN9S629C2_nt4v152Ev");}
void  S629C2_nt ::v153(){vfunc_called(this, "_ZN9S629C2_nt4v153Ev");}
void  S629C2_nt ::v154(){vfunc_called(this, "_ZN9S629C2_nt4v154Ev");}
void  S629C2_nt ::v155(){vfunc_called(this, "_ZN9S629C2_nt4v155Ev");}
void  S629C2_nt ::v156(){vfunc_called(this, "_ZN9S629C2_nt4v156Ev");}
S629C2_nt ::S629C2_nt(){ note_ctor("S629C2_nt", this);} // tgen

//skip512 S629C2_nt

#else // __cplusplus

extern void _ZN9S629C2_ntC1Ev();
extern void _ZN9S629C2_ntD1Ev();
Name_Map name_map_S629C2_nt[] = {
  NSPAIR(_ZN9S629C2_ntC1Ev),
  NSPAIR(_ZN9S629C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S629C5;
extern VTBL_ENTRY _ZTI6S629C5[];
extern  VTBL_ENTRY _ZTV6S629C5[];
extern Class_Descriptor cd_S629C4_nt;
extern VTBL_ENTRY _ZTI9S629C4_nt[];
extern  VTBL_ENTRY _ZTV9S629C4_nt[];
extern Class_Descriptor cd_S629C3_nt;
extern VTBL_ENTRY _ZTI9S629C3_nt[];
extern  VTBL_ENTRY _ZTV9S629C3_nt[];
static Base_Class bases_S629C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S629C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S629C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S629C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S629C2_nt[];
extern void _ZN9S629C2_ntD1Ev();
extern void _ZN9S629C2_ntD0Ev();
extern void _ZN6S629C52v5Ev();
extern void _ZN6S629C52v6Ev();
extern void _ZN6S629C52v7Ev();
extern void _ZN6S629C52v8Ev();
extern void _ZN6S629C52v9Ev();
extern void _ZN6S629C53v10Ev();
extern void _ZN6S629C53v11Ev();
extern void _ZN6S629C53v12Ev();
extern void _ZN6S629C53v13Ev();
extern void _ZN6S629C53v14Ev();
extern void _ZN6S629C53v15Ev();
extern void _ZN6S629C53v16Ev();
extern void _ZN6S629C53v17Ev();
extern void _ZN6S629C53v18Ev();
extern void _ZN6S629C53v19Ev();
extern void _ZN6S629C53v20Ev();
extern void _ZN6S629C53v21Ev();
extern void _ZN6S629C53v22Ev();
extern void _ZN6S629C53v23Ev();
extern void _ZN6S629C53v24Ev();
extern void _ZN6S629C53v25Ev();
extern void _ZN6S629C53v26Ev();
extern void _ZN6S629C53v27Ev();
extern void _ZN6S629C53v28Ev();
extern void _ZN6S629C53v29Ev();
extern void _ZN6S629C53v30Ev();
extern void _ZN6S629C53v31Ev();
extern void _ZN6S629C53v32Ev();
extern void _ZN6S629C53v33Ev();
extern void _ZN6S629C53v34Ev();
extern void _ZN6S629C53v35Ev();
extern void _ZN6S629C53v36Ev();
extern void _ZN6S629C53v37Ev();
extern void _ZN6S629C53v38Ev();
extern void _ZN6S629C53v39Ev();
extern void _ZN6S629C53v40Ev();
extern void _ZN6S629C53v41Ev();
extern void _ZN6S629C53v42Ev();
extern void _ZN6S629C53v43Ev();
extern void _ZN6S629C53v44Ev();
extern void _ZN6S629C53v45Ev();
extern void _ZN6S629C53v46Ev();
extern void _ZN6S629C53v47Ev();
extern void _ZN6S629C53v48Ev();
extern void _ZN6S629C53v49Ev();
extern void _ZN6S629C53v50Ev();
extern void _ZN6S629C53v51Ev();
extern void _ZN6S629C53v52Ev();
extern void _ZN6S629C53v53Ev();
extern void _ZN6S629C53v54Ev();
extern void _ZN6S629C53v55Ev();
extern void _ZN6S629C53v56Ev();
extern void _ZN6S629C53v57Ev();
extern void _ZN6S629C53v58Ev();
extern void _ZN6S629C53v59Ev();
extern void _ZN6S629C53v60Ev();
extern void _ZN6S629C53v61Ev();
extern void _ZN6S629C53v62Ev();
extern void _ZN6S629C53v63Ev();
extern void _ZN6S629C53v64Ev();
extern void _ZN6S629C53v65Ev();
extern void _ZN6S629C53v66Ev();
extern void _ZN6S629C53v67Ev();
extern void _ZN6S629C53v68Ev();
extern void _ZN9S629C4_nt3v69Ev();
extern void _ZN9S629C4_nt3v70Ev();
extern void _ZN9S629C4_nt3v71Ev();
extern void _ZN9S629C4_nt3v72Ev();
extern void _ZN9S629C4_nt3v73Ev();
extern void _ZN9S629C3_nt3v74Ev();
extern void _ZN9S629C3_nt3v75Ev();
extern void _ZN9S629C3_nt3v76Ev();
extern void _ZN9S629C3_nt3v77Ev();
extern void _ZN9S629C3_nt3v78Ev();
extern void _ZN9S629C3_nt3v79Ev();
extern void _ZN9S629C3_nt3v80Ev();
extern void _ZN9S629C3_nt3v81Ev();
extern void _ZN9S629C3_nt3v82Ev();
extern void _ZN9S629C3_nt3v83Ev();
extern void _ZN9S629C3_nt3v84Ev();
extern void _ZN9S629C3_nt3v85Ev();
extern void _ZN9S629C3_nt3v86Ev();
extern void _ZN9S629C3_nt3v87Ev();
extern void _ZN9S629C3_nt3v88Ev();
extern void _ZN9S629C3_nt3v89Ev();
extern void _ZN9S629C3_nt3v90Ev();
extern void _ZN9S629C3_nt3v91Ev();
extern void _ZN9S629C3_nt3v92Ev();
extern void _ZN9S629C3_nt3v93Ev();
extern void _ZN9S629C3_nt3v94Ev();
extern void _ZN9S629C3_nt3v95Ev();
extern void _ZN9S629C2_nt3v96Ev();
extern void _ZN9S629C2_nt3v97Ev();
extern void _ZN9S629C2_nt3v98Ev();
extern void _ZN9S629C2_nt3v99Ev();
extern void _ZN9S629C2_nt4v100Ev();
extern void _ZN9S629C2_nt4v101Ev();
extern void _ZN9S629C2_nt4v102Ev();
extern void _ZN9S629C2_nt4v103Ev();
extern void _ZN9S629C2_nt4v104Ev();
extern void _ZN9S629C2_nt4v105Ev();
extern void _ZN9S629C2_nt4v106Ev();
extern void _ZN9S629C2_nt4v107Ev();
extern void _ZN9S629C2_nt4v108Ev();
extern void _ZN9S629C2_nt4v109Ev();
extern void _ZN9S629C2_nt4v110Ev();
extern void _ZN9S629C2_nt4v111Ev();
extern void _ZN9S629C2_nt4v112Ev();
extern void _ZN9S629C2_nt4v113Ev();
extern void _ZN9S629C2_nt4v114Ev();
extern void _ZN9S629C2_nt4v115Ev();
extern void _ZN9S629C2_nt4v116Ev();
extern void _ZN9S629C2_nt4v117Ev();
extern void _ZN9S629C2_nt4v118Ev();
extern void _ZN9S629C2_nt4v119Ev();
extern void _ZN9S629C2_nt4v120Ev();
extern void _ZN9S629C2_nt4v121Ev();
extern void _ZN9S629C2_nt4v122Ev();
extern void _ZN9S629C2_nt4v123Ev();
extern void _ZN9S629C2_nt4v124Ev();
extern void _ZN9S629C2_nt4v125Ev();
extern void _ZN9S629C2_nt4v126Ev();
extern void _ZN9S629C2_nt4v127Ev();
extern void _ZN9S629C2_nt4v128Ev();
extern void _ZN9S629C2_nt4v129Ev();
extern void _ZN9S629C2_nt4v130Ev();
extern void _ZN9S629C2_nt4v131Ev();
extern void _ZN9S629C2_nt4v132Ev();
extern void _ZN9S629C2_nt4v133Ev();
extern void _ZN9S629C2_nt4v134Ev();
extern void _ZN9S629C2_nt4v135Ev();
extern void _ZN9S629C2_nt4v136Ev();
extern void _ZN9S629C2_nt4v137Ev();
extern void _ZN9S629C2_nt4v138Ev();
extern void _ZN9S629C2_nt4v139Ev();
extern void _ZN9S629C2_nt4v140Ev();
extern void _ZN9S629C2_nt4v141Ev();
extern void _ZN9S629C2_nt4v142Ev();
extern void _ZN9S629C2_nt4v143Ev();
extern void _ZN9S629C2_nt4v144Ev();
extern void _ZN9S629C2_nt4v145Ev();
extern void _ZN9S629C2_nt4v146Ev();
extern void _ZN9S629C2_nt4v147Ev();
extern void _ZN9S629C2_nt4v148Ev();
extern void _ZN9S629C2_nt4v149Ev();
extern void _ZN9S629C2_nt4v150Ev();
extern void _ZN9S629C2_nt4v151Ev();
extern void _ZN9S629C2_nt4v152Ev();
extern void _ZN9S629C2_nt4v153Ev();
extern void _ZN9S629C2_nt4v154Ev();
extern void _ZN9S629C2_nt4v155Ev();
extern void _ZN9S629C2_nt4v156Ev();
static  VTBL_ENTRY vtc_S629C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S629C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S629C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S629C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S629C52v5Ev,
  (VTBL_ENTRY)&_ZN6S629C52v6Ev,
  (VTBL_ENTRY)&_ZN6S629C52v7Ev,
  (VTBL_ENTRY)&_ZN6S629C52v8Ev,
  (VTBL_ENTRY)&_ZN6S629C52v9Ev,
  (VTBL_ENTRY)&_ZN6S629C53v10Ev,
  (VTBL_ENTRY)&_ZN6S629C53v11Ev,
  (VTBL_ENTRY)&_ZN6S629C53v12Ev,
  (VTBL_ENTRY)&_ZN6S629C53v13Ev,
  (VTBL_ENTRY)&_ZN6S629C53v14Ev,
  (VTBL_ENTRY)&_ZN6S629C53v15Ev,
  (VTBL_ENTRY)&_ZN6S629C53v16Ev,
  (VTBL_ENTRY)&_ZN6S629C53v17Ev,
  (VTBL_ENTRY)&_ZN6S629C53v18Ev,
  (VTBL_ENTRY)&_ZN6S629C53v19Ev,
  (VTBL_ENTRY)&_ZN6S629C53v20Ev,
  (VTBL_ENTRY)&_ZN6S629C53v21Ev,
  (VTBL_ENTRY)&_ZN6S629C53v22Ev,
  (VTBL_ENTRY)&_ZN6S629C53v23Ev,
  (VTBL_ENTRY)&_ZN6S629C53v24Ev,
  (VTBL_ENTRY)&_ZN6S629C53v25Ev,
  (VTBL_ENTRY)&_ZN6S629C53v26Ev,
  (VTBL_ENTRY)&_ZN6S629C53v27Ev,
  (VTBL_ENTRY)&_ZN6S629C53v28Ev,
  (VTBL_ENTRY)&_ZN6S629C53v29Ev,
  (VTBL_ENTRY)&_ZN6S629C53v30Ev,
  (VTBL_ENTRY)&_ZN6S629C53v31Ev,
  (VTBL_ENTRY)&_ZN6S629C53v32Ev,
  (VTBL_ENTRY)&_ZN6S629C53v33Ev,
  (VTBL_ENTRY)&_ZN6S629C53v34Ev,
  (VTBL_ENTRY)&_ZN6S629C53v35Ev,
  (VTBL_ENTRY)&_ZN6S629C53v36Ev,
  (VTBL_ENTRY)&_ZN6S629C53v37Ev,
  (VTBL_ENTRY)&_ZN6S629C53v38Ev,
  (VTBL_ENTRY)&_ZN6S629C53v39Ev,
  (VTBL_ENTRY)&_ZN6S629C53v40Ev,
  (VTBL_ENTRY)&_ZN6S629C53v41Ev,
  (VTBL_ENTRY)&_ZN6S629C53v42Ev,
  (VTBL_ENTRY)&_ZN6S629C53v43Ev,
  (VTBL_ENTRY)&_ZN6S629C53v44Ev,
  (VTBL_ENTRY)&_ZN6S629C53v45Ev,
  (VTBL_ENTRY)&_ZN6S629C53v46Ev,
  (VTBL_ENTRY)&_ZN6S629C53v47Ev,
  (VTBL_ENTRY)&_ZN6S629C53v48Ev,
  (VTBL_ENTRY)&_ZN6S629C53v49Ev,
  (VTBL_ENTRY)&_ZN6S629C53v50Ev,
  (VTBL_ENTRY)&_ZN6S629C53v51Ev,
  (VTBL_ENTRY)&_ZN6S629C53v52Ev,
  (VTBL_ENTRY)&_ZN6S629C53v53Ev,
  (VTBL_ENTRY)&_ZN6S629C53v54Ev,
  (VTBL_ENTRY)&_ZN6S629C53v55Ev,
  (VTBL_ENTRY)&_ZN6S629C53v56Ev,
  (VTBL_ENTRY)&_ZN6S629C53v57Ev,
  (VTBL_ENTRY)&_ZN6S629C53v58Ev,
  (VTBL_ENTRY)&_ZN6S629C53v59Ev,
  (VTBL_ENTRY)&_ZN6S629C53v60Ev,
  (VTBL_ENTRY)&_ZN6S629C53v61Ev,
  (VTBL_ENTRY)&_ZN6S629C53v62Ev,
  (VTBL_ENTRY)&_ZN6S629C53v63Ev,
  (VTBL_ENTRY)&_ZN6S629C53v64Ev,
  (VTBL_ENTRY)&_ZN6S629C53v65Ev,
  (VTBL_ENTRY)&_ZN6S629C53v66Ev,
  (VTBL_ENTRY)&_ZN6S629C53v67Ev,
  (VTBL_ENTRY)&_ZN6S629C53v68Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v156Ev,
};
extern VTBL_ENTRY _ZTI9S629C2_nt[];
VTBL_ENTRY *P__ZTI9S629C2_nt = _ZTI9S629C2_nt; 
extern  VTBL_ENTRY _ZTV9S629C2_nt[];
Class_Descriptor cd_S629C2_nt = {  "S629C2_nt", // class name
  bases_S629C2_nt, 3,
  &(vtc_S629C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI9S629C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S629C2_nt),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S629C1  : S629C2_nt {
  void *s629c1f0;
  int s629c1f1[2];
  virtual  ~S629C1(); // _ZN6S629C1D1Ev
  virtual void  v1(); // _ZN6S629C12v1Ev
  virtual void  v2(); // _ZN6S629C12v2Ev
  virtual void  v3(); // _ZN6S629C12v3Ev
  virtual void  v4(); // _ZN6S629C12v4Ev
  S629C1(); // tgen
};
//SIG(1 S629C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 Fp FC6} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC9} Fp[2] Fc FC8 FC12 FC15{ m Fi[3]} Fi FC12 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 Fp Fi[2]}


 S629C1 ::~S629C1(){ note_dtor("S629C1", this);}
void  S629C1 ::v1(){vfunc_called(this, "_ZN6S629C12v1Ev");}
void  S629C1 ::v2(){vfunc_called(this, "_ZN6S629C12v2Ev");}
void  S629C1 ::v3(){vfunc_called(this, "_ZN6S629C12v3Ev");}
void  S629C1 ::v4(){vfunc_called(this, "_ZN6S629C12v4Ev");}
S629C1 ::S629C1(){ note_ctor("S629C1", this);} // tgen

static void Test_S629C1()
{
  extern Class_Descriptor cd_S629C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,72)];
    init_test(&cd_S629C1, buf);
    S629C1 *dp, &lv = *(dp=new (buf) S629C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,284), "sizeof(S629C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S629C1)");
    check_base_class_offset(lv, (S629C5*)(S629C4_nt*)(S629C3_nt*)(S629C2_nt*), 0, "S629C1");
    check_base_class_offset(lv, (S629C4_nt*)(S629C3_nt*)(S629C2_nt*), 0, "S629C1");
    check_base_class_offset(lv, (S629C3_nt*)(S629C2_nt*), 0, "S629C1");
    check_base_class_offset(lv, (S629C2_nt*), 0, "S629C1");
    check_field_offset(lv, s629c1f0, ABISELECT(368,272), "S629C1.s629c1f0");
    check_field_offset(lv, s629c1f1, ABISELECT(376,276), "S629C1.s629c1f1");
    test_class_info(&lv, &cd_S629C1);
    dp->~S629C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS629C1(Test_S629C1, "S629C1", ABISELECT(384,284));

#else // __cplusplus

extern void _ZN6S629C1C1Ev();
extern void _ZN6S629C1D1Ev();
Name_Map name_map_S629C1[] = {
  NSPAIR(_ZN6S629C1C1Ev),
  NSPAIR(_ZN6S629C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S629C5;
extern VTBL_ENTRY _ZTI6S629C5[];
extern  VTBL_ENTRY _ZTV6S629C5[];
extern Class_Descriptor cd_S629C4_nt;
extern VTBL_ENTRY _ZTI9S629C4_nt[];
extern  VTBL_ENTRY _ZTV9S629C4_nt[];
extern Class_Descriptor cd_S629C3_nt;
extern VTBL_ENTRY _ZTI9S629C3_nt[];
extern  VTBL_ENTRY _ZTV9S629C3_nt[];
extern Class_Descriptor cd_S629C2_nt;
extern VTBL_ENTRY _ZTI9S629C2_nt[];
extern  VTBL_ENTRY _ZTV9S629C2_nt[];
static Base_Class bases_S629C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S629C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S629C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S629C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S629C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S629C1[];
extern void _ZN6S629C1D1Ev();
extern void _ZN6S629C1D0Ev();
extern void _ZN6S629C52v5Ev();
extern void _ZN6S629C52v6Ev();
extern void _ZN6S629C52v7Ev();
extern void _ZN6S629C52v8Ev();
extern void _ZN6S629C52v9Ev();
extern void _ZN6S629C53v10Ev();
extern void _ZN6S629C53v11Ev();
extern void _ZN6S629C53v12Ev();
extern void _ZN6S629C53v13Ev();
extern void _ZN6S629C53v14Ev();
extern void _ZN6S629C53v15Ev();
extern void _ZN6S629C53v16Ev();
extern void _ZN6S629C53v17Ev();
extern void _ZN6S629C53v18Ev();
extern void _ZN6S629C53v19Ev();
extern void _ZN6S629C53v20Ev();
extern void _ZN6S629C53v21Ev();
extern void _ZN6S629C53v22Ev();
extern void _ZN6S629C53v23Ev();
extern void _ZN6S629C53v24Ev();
extern void _ZN6S629C53v25Ev();
extern void _ZN6S629C53v26Ev();
extern void _ZN6S629C53v27Ev();
extern void _ZN6S629C53v28Ev();
extern void _ZN6S629C53v29Ev();
extern void _ZN6S629C53v30Ev();
extern void _ZN6S629C53v31Ev();
extern void _ZN6S629C53v32Ev();
extern void _ZN6S629C53v33Ev();
extern void _ZN6S629C53v34Ev();
extern void _ZN6S629C53v35Ev();
extern void _ZN6S629C53v36Ev();
extern void _ZN6S629C53v37Ev();
extern void _ZN6S629C53v38Ev();
extern void _ZN6S629C53v39Ev();
extern void _ZN6S629C53v40Ev();
extern void _ZN6S629C53v41Ev();
extern void _ZN6S629C53v42Ev();
extern void _ZN6S629C53v43Ev();
extern void _ZN6S629C53v44Ev();
extern void _ZN6S629C53v45Ev();
extern void _ZN6S629C53v46Ev();
extern void _ZN6S629C53v47Ev();
extern void _ZN6S629C53v48Ev();
extern void _ZN6S629C53v49Ev();
extern void _ZN6S629C53v50Ev();
extern void _ZN6S629C53v51Ev();
extern void _ZN6S629C53v52Ev();
extern void _ZN6S629C53v53Ev();
extern void _ZN6S629C53v54Ev();
extern void _ZN6S629C53v55Ev();
extern void _ZN6S629C53v56Ev();
extern void _ZN6S629C53v57Ev();
extern void _ZN6S629C53v58Ev();
extern void _ZN6S629C53v59Ev();
extern void _ZN6S629C53v60Ev();
extern void _ZN6S629C53v61Ev();
extern void _ZN6S629C53v62Ev();
extern void _ZN6S629C53v63Ev();
extern void _ZN6S629C53v64Ev();
extern void _ZN6S629C53v65Ev();
extern void _ZN6S629C53v66Ev();
extern void _ZN6S629C53v67Ev();
extern void _ZN6S629C53v68Ev();
extern void _ZN9S629C4_nt3v69Ev();
extern void _ZN9S629C4_nt3v70Ev();
extern void _ZN9S629C4_nt3v71Ev();
extern void _ZN9S629C4_nt3v72Ev();
extern void _ZN9S629C4_nt3v73Ev();
extern void _ZN9S629C3_nt3v74Ev();
extern void _ZN9S629C3_nt3v75Ev();
extern void _ZN9S629C3_nt3v76Ev();
extern void _ZN9S629C3_nt3v77Ev();
extern void _ZN9S629C3_nt3v78Ev();
extern void _ZN9S629C3_nt3v79Ev();
extern void _ZN9S629C3_nt3v80Ev();
extern void _ZN9S629C3_nt3v81Ev();
extern void _ZN9S629C3_nt3v82Ev();
extern void _ZN9S629C3_nt3v83Ev();
extern void _ZN9S629C3_nt3v84Ev();
extern void _ZN9S629C3_nt3v85Ev();
extern void _ZN9S629C3_nt3v86Ev();
extern void _ZN9S629C3_nt3v87Ev();
extern void _ZN9S629C3_nt3v88Ev();
extern void _ZN9S629C3_nt3v89Ev();
extern void _ZN9S629C3_nt3v90Ev();
extern void _ZN9S629C3_nt3v91Ev();
extern void _ZN9S629C3_nt3v92Ev();
extern void _ZN9S629C3_nt3v93Ev();
extern void _ZN9S629C3_nt3v94Ev();
extern void _ZN9S629C3_nt3v95Ev();
extern void _ZN9S629C2_nt3v96Ev();
extern void _ZN9S629C2_nt3v97Ev();
extern void _ZN9S629C2_nt3v98Ev();
extern void _ZN9S629C2_nt3v99Ev();
extern void _ZN9S629C2_nt4v100Ev();
extern void _ZN9S629C2_nt4v101Ev();
extern void _ZN9S629C2_nt4v102Ev();
extern void _ZN9S629C2_nt4v103Ev();
extern void _ZN9S629C2_nt4v104Ev();
extern void _ZN9S629C2_nt4v105Ev();
extern void _ZN9S629C2_nt4v106Ev();
extern void _ZN9S629C2_nt4v107Ev();
extern void _ZN9S629C2_nt4v108Ev();
extern void _ZN9S629C2_nt4v109Ev();
extern void _ZN9S629C2_nt4v110Ev();
extern void _ZN9S629C2_nt4v111Ev();
extern void _ZN9S629C2_nt4v112Ev();
extern void _ZN9S629C2_nt4v113Ev();
extern void _ZN9S629C2_nt4v114Ev();
extern void _ZN9S629C2_nt4v115Ev();
extern void _ZN9S629C2_nt4v116Ev();
extern void _ZN9S629C2_nt4v117Ev();
extern void _ZN9S629C2_nt4v118Ev();
extern void _ZN9S629C2_nt4v119Ev();
extern void _ZN9S629C2_nt4v120Ev();
extern void _ZN9S629C2_nt4v121Ev();
extern void _ZN9S629C2_nt4v122Ev();
extern void _ZN9S629C2_nt4v123Ev();
extern void _ZN9S629C2_nt4v124Ev();
extern void _ZN9S629C2_nt4v125Ev();
extern void _ZN9S629C2_nt4v126Ev();
extern void _ZN9S629C2_nt4v127Ev();
extern void _ZN9S629C2_nt4v128Ev();
extern void _ZN9S629C2_nt4v129Ev();
extern void _ZN9S629C2_nt4v130Ev();
extern void _ZN9S629C2_nt4v131Ev();
extern void _ZN9S629C2_nt4v132Ev();
extern void _ZN9S629C2_nt4v133Ev();
extern void _ZN9S629C2_nt4v134Ev();
extern void _ZN9S629C2_nt4v135Ev();
extern void _ZN9S629C2_nt4v136Ev();
extern void _ZN9S629C2_nt4v137Ev();
extern void _ZN9S629C2_nt4v138Ev();
extern void _ZN9S629C2_nt4v139Ev();
extern void _ZN9S629C2_nt4v140Ev();
extern void _ZN9S629C2_nt4v141Ev();
extern void _ZN9S629C2_nt4v142Ev();
extern void _ZN9S629C2_nt4v143Ev();
extern void _ZN9S629C2_nt4v144Ev();
extern void _ZN9S629C2_nt4v145Ev();
extern void _ZN9S629C2_nt4v146Ev();
extern void _ZN9S629C2_nt4v147Ev();
extern void _ZN9S629C2_nt4v148Ev();
extern void _ZN9S629C2_nt4v149Ev();
extern void _ZN9S629C2_nt4v150Ev();
extern void _ZN9S629C2_nt4v151Ev();
extern void _ZN9S629C2_nt4v152Ev();
extern void _ZN9S629C2_nt4v153Ev();
extern void _ZN9S629C2_nt4v154Ev();
extern void _ZN9S629C2_nt4v155Ev();
extern void _ZN9S629C2_nt4v156Ev();
extern void _ZN6S629C12v1Ev();
extern void _ZN6S629C12v2Ev();
extern void _ZN6S629C12v3Ev();
extern void _ZN6S629C12v4Ev();
static  VTBL_ENTRY vtc_S629C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S629C1[0]),
  (VTBL_ENTRY)&_ZN6S629C1D1Ev,
  (VTBL_ENTRY)&_ZN6S629C1D0Ev,
  (VTBL_ENTRY)&_ZN6S629C52v5Ev,
  (VTBL_ENTRY)&_ZN6S629C52v6Ev,
  (VTBL_ENTRY)&_ZN6S629C52v7Ev,
  (VTBL_ENTRY)&_ZN6S629C52v8Ev,
  (VTBL_ENTRY)&_ZN6S629C52v9Ev,
  (VTBL_ENTRY)&_ZN6S629C53v10Ev,
  (VTBL_ENTRY)&_ZN6S629C53v11Ev,
  (VTBL_ENTRY)&_ZN6S629C53v12Ev,
  (VTBL_ENTRY)&_ZN6S629C53v13Ev,
  (VTBL_ENTRY)&_ZN6S629C53v14Ev,
  (VTBL_ENTRY)&_ZN6S629C53v15Ev,
  (VTBL_ENTRY)&_ZN6S629C53v16Ev,
  (VTBL_ENTRY)&_ZN6S629C53v17Ev,
  (VTBL_ENTRY)&_ZN6S629C53v18Ev,
  (VTBL_ENTRY)&_ZN6S629C53v19Ev,
  (VTBL_ENTRY)&_ZN6S629C53v20Ev,
  (VTBL_ENTRY)&_ZN6S629C53v21Ev,
  (VTBL_ENTRY)&_ZN6S629C53v22Ev,
  (VTBL_ENTRY)&_ZN6S629C53v23Ev,
  (VTBL_ENTRY)&_ZN6S629C53v24Ev,
  (VTBL_ENTRY)&_ZN6S629C53v25Ev,
  (VTBL_ENTRY)&_ZN6S629C53v26Ev,
  (VTBL_ENTRY)&_ZN6S629C53v27Ev,
  (VTBL_ENTRY)&_ZN6S629C53v28Ev,
  (VTBL_ENTRY)&_ZN6S629C53v29Ev,
  (VTBL_ENTRY)&_ZN6S629C53v30Ev,
  (VTBL_ENTRY)&_ZN6S629C53v31Ev,
  (VTBL_ENTRY)&_ZN6S629C53v32Ev,
  (VTBL_ENTRY)&_ZN6S629C53v33Ev,
  (VTBL_ENTRY)&_ZN6S629C53v34Ev,
  (VTBL_ENTRY)&_ZN6S629C53v35Ev,
  (VTBL_ENTRY)&_ZN6S629C53v36Ev,
  (VTBL_ENTRY)&_ZN6S629C53v37Ev,
  (VTBL_ENTRY)&_ZN6S629C53v38Ev,
  (VTBL_ENTRY)&_ZN6S629C53v39Ev,
  (VTBL_ENTRY)&_ZN6S629C53v40Ev,
  (VTBL_ENTRY)&_ZN6S629C53v41Ev,
  (VTBL_ENTRY)&_ZN6S629C53v42Ev,
  (VTBL_ENTRY)&_ZN6S629C53v43Ev,
  (VTBL_ENTRY)&_ZN6S629C53v44Ev,
  (VTBL_ENTRY)&_ZN6S629C53v45Ev,
  (VTBL_ENTRY)&_ZN6S629C53v46Ev,
  (VTBL_ENTRY)&_ZN6S629C53v47Ev,
  (VTBL_ENTRY)&_ZN6S629C53v48Ev,
  (VTBL_ENTRY)&_ZN6S629C53v49Ev,
  (VTBL_ENTRY)&_ZN6S629C53v50Ev,
  (VTBL_ENTRY)&_ZN6S629C53v51Ev,
  (VTBL_ENTRY)&_ZN6S629C53v52Ev,
  (VTBL_ENTRY)&_ZN6S629C53v53Ev,
  (VTBL_ENTRY)&_ZN6S629C53v54Ev,
  (VTBL_ENTRY)&_ZN6S629C53v55Ev,
  (VTBL_ENTRY)&_ZN6S629C53v56Ev,
  (VTBL_ENTRY)&_ZN6S629C53v57Ev,
  (VTBL_ENTRY)&_ZN6S629C53v58Ev,
  (VTBL_ENTRY)&_ZN6S629C53v59Ev,
  (VTBL_ENTRY)&_ZN6S629C53v60Ev,
  (VTBL_ENTRY)&_ZN6S629C53v61Ev,
  (VTBL_ENTRY)&_ZN6S629C53v62Ev,
  (VTBL_ENTRY)&_ZN6S629C53v63Ev,
  (VTBL_ENTRY)&_ZN6S629C53v64Ev,
  (VTBL_ENTRY)&_ZN6S629C53v65Ev,
  (VTBL_ENTRY)&_ZN6S629C53v66Ev,
  (VTBL_ENTRY)&_ZN6S629C53v67Ev,
  (VTBL_ENTRY)&_ZN6S629C53v68Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S629C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S629C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S629C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN6S629C12v1Ev,
  (VTBL_ENTRY)&_ZN6S629C12v2Ev,
  (VTBL_ENTRY)&_ZN6S629C12v3Ev,
  (VTBL_ENTRY)&_ZN6S629C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S629C1[];
extern  VTBL_ENTRY _ZTV6S629C1[];
Class_Descriptor cd_S629C1 = {  "S629C1", // class name
  bases_S629C1, 4,
  &(vtc_S629C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,284), // object size
  NSPAIRA(_ZTI6S629C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S629C1),160, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C3  {
  void *s20677c3f0;
  __tsi64 s20677c3f1[4];
  short s20677c3f2;
  void  mf20677c3(); // _ZN8S20677C39mf20677c3Ev
};
//SIG(-1 S20677C3) C1{ m Fp FL[4] Fs}


void  S20677C3 ::mf20677c3(){}

static void Test_S20677C3()
{
  {
    init_simple_test("S20677C3");
    S20677C3 lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S20677C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20677C3)");
    check_field_offset(lv, s20677c3f0, 0, "S20677C3.s20677c3f0");
    check_field_offset(lv, s20677c3f1, ABISELECT(8,4), "S20677C3.s20677c3f1");
    check_field_offset(lv, s20677c3f2, ABISELECT(40,36), "S20677C3.s20677c3f2");
  }
}
static Arrange_To_Call_Me vS20677C3(Test_S20677C3, "S20677C3", ABISELECT(48,40));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S20677C3[];
VTBL_ENTRY *P__ZTI8S20677C3 = _ZTI8S20677C3; 
Class_Descriptor cd_S20677C3 = {  "S20677C3", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(48,40), // object size
  NSPAIRA(_ZTI8S20677C3),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C5  : virtual S20677C3 {
  long double s20677c5f0;
  int s20677c5f1;
  ::S20677C3 s20677c5f2;
  ::S20677C3 s20677c5f3;
  ~S20677C5(); // tgen
  S20677C5(); // tgen
};
//SIG(-1 S20677C5) C1{ VBC2{ m Fp FL[4] Fs} FD Fi FC2 FC2}


S20677C5 ::~S20677C5(){ note_dtor("S20677C5", this);} // tgen
S20677C5 ::S20677C5(){ note_ctor("S20677C5", this);} // tgen

static void Test_S20677C5()
{
  extern Class_Descriptor cd_S20677C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(13,36)];
    init_test(&cd_S20677C5, buf);
    S20677C5 *dp, &lv = *(dp=new (buf) S20677C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,140), "sizeof(S20677C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C5)");
    check_base_class_offset(lv, (S20677C3*), ABISELECT(136,100), "S20677C5");
    check_field_offset(lv, s20677c5f0, ABISELECT(16,4), "S20677C5.s20677c5f0");
    check_field_offset(lv, s20677c5f1, ABISELECT(32,16), "S20677C5.s20677c5f1");
    check_field_offset(lv, s20677c5f2, ABISELECT(40,20), "S20677C5.s20677c5f2");
    check_field_offset(lv, s20677c5f3, ABISELECT(88,60), "S20677C5.s20677c5f3");
    test_class_info(&lv, &cd_S20677C5);
    dp->~S20677C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C5(Test_S20677C5, "S20677C5", ABISELECT(192,140));

#else // __cplusplus

extern void _ZN8S20677C5C1Ev();
extern void _ZN8S20677C5D1Ev();
Name_Map name_map_S20677C5[] = {
  NSPAIR(_ZN8S20677C5C1Ev),
  NSPAIR(_ZN8S20677C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
static Base_Class bases_S20677C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(136,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20677C5[];
static  VTBL_ENTRY vtc_S20677C5[] = {
  ABISELECT(136,100),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern VTBL_ENTRY _ZTV8S20677C5[];
static  VTT_ENTRY vtt_S20677C5[] = {
  {&(_ZTV8S20677C5[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
Class_Descriptor cd_S20677C5 = {  "S20677C5", // class name
  bases_S20677C5, 1,
  &(vtc_S20677C5[0]), // expected_vtbl_contents
  &(vtt_S20677C5[0]), // expected_vtt_contents
  ABISELECT(192,140), // object size
  NSPAIRA(_ZTI8S20677C5),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20677C5),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20677C5),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C4  : virtual S20677C3 , S20677C5 {
  short s20677c4f0;
  __tsi64 s20677c4f1;
  char s20677c4f2;
  int s20677c4f3[2];
  ::S20677C5 s20677c4f4;
  void *s20677c4f5;
  __tsi64 s20677c4f6;
  int s20677c4f7;
  __tsi64 s20677c4f8;
  int s20677c4f9;
  virtual void  v2(); // _ZN8S20677C42v2Ev
  virtual void  v3(); // _ZN8S20677C42v3Ev
  virtual void  v4(); // _ZN8S20677C42v4Ev
  ~S20677C4(); // tgen
  S20677C4(); // tgen
};
//SIG(-1 S20677C4) C1{ VBC2{ m Fp FL[4] Fs} BC3{ VBC2 FD Fi FC2 FC2} v1 v2 v3 Fs FL Fc Fi[2] FC3 Fp FL Fi FL Fi}


void  S20677C4 ::v2(){vfunc_called(this, "_ZN8S20677C42v2Ev");}
void  S20677C4 ::v3(){vfunc_called(this, "_ZN8S20677C42v3Ev");}
void  S20677C4 ::v4(){vfunc_called(this, "_ZN8S20677C42v4Ev");}
S20677C4 ::~S20677C4(){ note_dtor("S20677C4", this);} // tgen
S20677C4 ::S20677C4(){ note_ctor("S20677C4", this);} // tgen

static void Test_S20677C4()
{
  extern Class_Descriptor cd_S20677C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(30,84)];
    init_test(&cd_S20677C4, buf);
    S20677C4 *dp, &lv = *(dp=new (buf) S20677C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,332), "sizeof(S20677C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C4)");
    check_base_class_offset(lv, (S20677C3*), ABISELECT(408,292), "S20677C4");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(408,292), "S20677C4");
    check_base_class_offset(lv, (S20677C5*), 0, "S20677C4");
    check_field_offset(lv, s20677c4f0, ABISELECT(136,100), "S20677C4.s20677c4f0");
    check_field_offset(lv, s20677c4f1, ABISELECT(144,104), "S20677C4.s20677c4f1");
    check_field_offset(lv, s20677c4f2, ABISELECT(152,112), "S20677C4.s20677c4f2");
    check_field_offset(lv, s20677c4f3, ABISELECT(156,116), "S20677C4.s20677c4f3");
    check_field_offset(lv, s20677c4f4, ABISELECT(176,124), "S20677C4.s20677c4f4");
    check_field_offset(lv, s20677c4f5, ABISELECT(368,264), "S20677C4.s20677c4f5");
    check_field_offset(lv, s20677c4f6, ABISELECT(376,268), "S20677C4.s20677c4f6");
    check_field_offset(lv, s20677c4f7, ABISELECT(384,276), "S20677C4.s20677c4f7");
    check_field_offset(lv, s20677c4f8, ABISELECT(392,280), "S20677C4.s20677c4f8");
    check_field_offset(lv, s20677c4f9, ABISELECT(400,288), "S20677C4.s20677c4f9");
    test_class_info(&lv, &cd_S20677C4);
    dp->~S20677C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C4(Test_S20677C4, "S20677C4", ABISELECT(464,332));

#else // __cplusplus

extern void _ZN8S20677C4C1Ev();
extern void _ZN8S20677C4D1Ev();
Name_Map name_map_S20677C4[] = {
  NSPAIR(_ZN8S20677C4C1Ev),
  NSPAIR(_ZN8S20677C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
static Base_Class bases_S20677C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(408,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20677C4[];
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY vtc_S20677C4[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern VTBL_ENTRY _ZTV8S20677C4[];
static  VTBL_ENTRY _tg__ZTV8S20677C5__8S20677C4[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C4[] = {
  {&(_ZTV8S20677C4[3]),  3,6},
  {&(_tg__ZTV8S20677C5__8S20677C4[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
Class_Descriptor cd_S20677C4 = {  "S20677C4", // class name
  bases_S20677C4, 2,
  &(vtc_S20677C4[0]), // expected_vtbl_contents
  &(vtt_S20677C4[0]), // expected_vtt_contents
  ABISELECT(464,332), // object size
  NSPAIRA(_ZTI8S20677C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20677C4),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20677C4),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C6_nt  {
};
//SIG(-1 S20677C6_nt) C1{}



//skip512 S20677C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C2  : virtual S20677C3 , virtual S20677C4 {
  __tsi64 s20677c2f0;
  ::S20677C6_nt s20677c2f1;
  void *s20677c2f2;
  char s20677c2f3[2];
  ::S20677C3 s20677c2f4;
  long s20677c2f5;
  ::S20677C6_nt s20677c2f6;
  virtual void  v5(); // _ZN8S20677C22v5Ev
  virtual void  v6(); // _ZN8S20677C22v6Ev
  virtual void  v7(); // _ZN8S20677C22v7Ev
  ~S20677C2(); // tgen
  S20677C2(); // tgen
};
//SIG(-1 S20677C2) C1{ VBC2{ m Fp FL[4] Fs} VBC3{ VBC2 BC4{ VBC2 FD Fi FC2 FC2} v4 v5 v6 Fs FL Fc Fi[2] FC4 Fp FL Fi FL Fi} v1 v2 v3 FL FC5{} Fp Fc[2] FC2 Fl FC5}


void  S20677C2 ::v5(){vfunc_called(this, "_ZN8S20677C22v5Ev");}
void  S20677C2 ::v6(){vfunc_called(this, "_ZN8S20677C22v6Ev");}
void  S20677C2 ::v7(){vfunc_called(this, "_ZN8S20677C22v7Ev");}
S20677C2 ::~S20677C2(){ note_dtor("S20677C2", this);} // tgen
S20677C2 ::S20677C2(){ note_ctor("S20677C2", this);} // tgen

static void Test_S20677C2()
{
  extern Class_Descriptor cd_S20677C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(37,102)];
    init_test(&cd_S20677C2, buf);
    S20677C2 *dp, &lv = *(dp=new (buf) S20677C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(576,404), "sizeof(S20677C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C2)");
    check_base_class_offset(lv, (S20677C3*), ABISELECT(104,72), "S20677C2");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*), ABISELECT(104,72), "S20677C2");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*), ABISELECT(104,72), "S20677C2");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*), ABISELECT(160,112), "S20677C2");
    check_base_class_offset(lv, (S20677C4*), ABISELECT(160,112), "S20677C2");
    check_field_offset(lv, s20677c2f0, ABISELECT(8,4), "S20677C2.s20677c2f0");
    check_field_offset(lv, s20677c2f1, ABISELECT(16,12), "S20677C2.s20677c2f1");
    check_field_offset(lv, s20677c2f2, ABISELECT(24,16), "S20677C2.s20677c2f2");
    check_field_offset(lv, s20677c2f3, ABISELECT(32,20), "S20677C2.s20677c2f3");
    check_field_offset(lv, s20677c2f4, ABISELECT(40,24), "S20677C2.s20677c2f4");
    check_field_offset(lv, s20677c2f5, ABISELECT(88,64), "S20677C2.s20677c2f5");
    check_field_offset(lv, s20677c2f6, ABISELECT(96,68), "S20677C2.s20677c2f6");
    test_class_info(&lv, &cd_S20677C2);
    dp->~S20677C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C2(Test_S20677C2, "S20677C2", ABISELECT(576,404));

#else // __cplusplus

extern void _ZN8S20677C2C1Ev();
extern void _ZN8S20677C2D1Ev();
Name_Map name_map_S20677C2[] = {
  NSPAIR(_ZN8S20677C2C1Ev),
  NSPAIR(_ZN8S20677C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
static Base_Class bases_S20677C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(104,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C5,    ABISELECT(160,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(160,112), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20677C2[];
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY vtc_S20677C2[] = {
  ABISELECT(160,112),
  ABISELECT(104,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern VTBL_ENTRY _ZTV8S20677C2[];
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__8S20677C2[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C4__8S20677C2[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C2[] = {
  {&(_ZTV8S20677C2[4]),  4,16},
  {&(_ZTV8S20677C2[13]),  13,16},
  {&(_tg__ZTV8S20677C4__8S20677C2[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C4__8S20677C2[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20677C2[];
extern  VTBL_ENTRY _ZTV8S20677C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C2[];
Class_Descriptor cd_S20677C2 = {  "S20677C2", // class name
  bases_S20677C2, 3,
  &(vtc_S20677C2[0]), // expected_vtbl_contents
  &(vtt_S20677C2[0]), // expected_vtt_contents
  ABISELECT(576,404), // object size
  NSPAIRA(_ZTI8S20677C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20677C2),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20677C2),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C8  {
  ::S20677C6_nt s20677c8f0;
  ::S20677C5 s20677c8f1;
  ::S20677C6_nt s20677c8f2;
  __tsi64 s20677c8f3;
  ::S20677C6_nt s20677c8f4;
  void *s20677c8f5;
  ::S20677C6_nt s20677c8f6;
  void *s20677c8f7[2];
  ::S20677C6_nt s20677c8f8;
  virtual void  v8(); // _ZN8S20677C82v8Ev
  ~S20677C8(); // tgen
  S20677C8(); // tgen
};
//SIG(-1 S20677C8) C1{ v1 FC2{} FC3{ VBC4{ m Fp FL[4] Fs} FD Fi FC4 FC4} FC2 FL FC2 Fp FC2 Fp[2] FC2}


void  S20677C8 ::v8(){vfunc_called(this, "_ZN8S20677C82v8Ev");}
S20677C8 ::~S20677C8(){ note_dtor("S20677C8", this);} // tgen
S20677C8 ::S20677C8(){ note_ctor("S20677C8", this);} // tgen

static void Test_S20677C8()
{
  extern Class_Descriptor cd_S20677C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(18,47)];
    init_test(&cd_S20677C8, buf);
    S20677C8 *dp, &lv = *(dp=new (buf) S20677C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,184), "sizeof(S20677C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C8)");
    check_field_offset(lv, s20677c8f0, ABISELECT(8,4), "S20677C8.s20677c8f0");
    check_field_offset(lv, s20677c8f1, ABISELECT(16,8), "S20677C8.s20677c8f1");
    check_field_offset(lv, s20677c8f2, ABISELECT(208,148), "S20677C8.s20677c8f2");
    check_field_offset(lv, s20677c8f3, ABISELECT(216,152), "S20677C8.s20677c8f3");
    check_field_offset(lv, s20677c8f4, ABISELECT(224,160), "S20677C8.s20677c8f4");
    check_field_offset(lv, s20677c8f5, ABISELECT(232,164), "S20677C8.s20677c8f5");
    check_field_offset(lv, s20677c8f6, ABISELECT(240,168), "S20677C8.s20677c8f6");
    check_field_offset(lv, s20677c8f7, ABISELECT(248,172), "S20677C8.s20677c8f7");
    check_field_offset(lv, s20677c8f8, ABISELECT(264,180), "S20677C8.s20677c8f8");
    test_class_info(&lv, &cd_S20677C8);
    dp->~S20677C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C8(Test_S20677C8, "S20677C8", ABISELECT(272,184));

#else // __cplusplus

extern void _ZN8S20677C8C1Ev();
extern void _ZN8S20677C8D1Ev();
Name_Map name_map_S20677C8[] = {
  NSPAIR(_ZN8S20677C8C1Ev),
  NSPAIR(_ZN8S20677C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S20677C8[];
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY vtc_S20677C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C8[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern VTBL_ENTRY _ZTI8S20677C8[];
extern  VTBL_ENTRY _ZTV8S20677C8[];
Class_Descriptor cd_S20677C8 = {  "S20677C8", // class name
  0,0,//no base classes
  &(vtc_S20677C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,184), // object size
  NSPAIRA(_ZTI8S20677C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S20677C8),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C9  : S20677C3 {
  ::S20677C3 s20677c9f0;
  int s20677c9f1;
  long double s20677c9f2;
  int s20677c9f3;
  __tsi64 s20677c9f4;
  long s20677c9f5;
};
//SIG(-1 S20677C9) C1{ BC2{ m Fp FL[4] Fs} FC2 Fi FD Fi FL Fl}



static void Test_S20677C9()
{
  extern Class_Descriptor cd_S20677C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(11,29)];
    init_test(&cd_S20677C9, buf);
    S20677C9 &lv = *(new (buf) S20677C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,112), "sizeof(S20677C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C9)");
    check_base_class_offset(lv, (S20677C3*), 0, "S20677C9");
    check_field_offset(lv, s20677c9f0, ABISELECT(48,40), "S20677C9.s20677c9f0");
    check_field_offset(lv, s20677c9f1, ABISELECT(96,80), "S20677C9.s20677c9f1");
    check_field_offset(lv, s20677c9f2, ABISELECT(112,84), "S20677C9.s20677c9f2");
    check_field_offset(lv, s20677c9f3, ABISELECT(128,96), "S20677C9.s20677c9f3");
    check_field_offset(lv, s20677c9f4, ABISELECT(136,100), "S20677C9.s20677c9f4");
    check_field_offset(lv, s20677c9f5, ABISELECT(144,108), "S20677C9.s20677c9f5");
    test_class_info(&lv, &cd_S20677C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C9(Test_S20677C9, "S20677C9", ABISELECT(160,112));

#else // __cplusplus

extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
static Base_Class bases_S20677C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20677C9[];
Class_Descriptor cd_S20677C9 = {  "S20677C9", // class name
  bases_S20677C9, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(160,112), // object size
  NSPAIRA(_ZTI8S20677C9),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C7  : virtual S20677C8 , S20677C5 , S20677C9 {
  void *s20677c7f0;
  ::S20677C9 s20677c7f1;
  void *s20677c7f2;
  int s20677c7f3[2];
  long double s20677c7f4;
  int s20677c7f5[2];
  virtual void  v9(); // _ZN8S20677C72v9Ev
  ~S20677C7(); // tgen
  S20677C7(); // tgen
};
//SIG(-1 S20677C7) C1{ VBC2{ v2 FC3{} FC4{ VBC5{ m Fp FL[4] Fs} FD Fi FC5 FC5} FC3 FL FC3 Fp FC3 Fp[2] FC3} BC4 BC6{ BC5 FC5 Fi FD Fi FL Fl} v1 Fp FC6 Fp Fi[2] FD Fi[2]}


void  S20677C7 ::v9(){vfunc_called(this, "_ZN8S20677C72v9Ev");}
S20677C7 ::~S20677C7(){ note_dtor("S20677C7", this);} // tgen
S20677C7 ::S20677C7(){ note_ctor("S20677C7", this);} // tgen

static void Test_S20677C7()
{
  extern Class_Descriptor cd_S20677C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(53,147)];
    init_test(&cd_S20677C7, buf);
    S20677C7 *dp, &lv = *(dp=new (buf) S20677C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,584), "sizeof(S20677C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C7)");
    check_base_class_offset(lv, (S20677C8*), ABISELECT(512,360), "S20677C7");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(784,544), "S20677C7");
    check_base_class_offset(lv, (S20677C5*), 0, "S20677C7");
    check_base_class_offset(lv, (S20677C3*)(S20677C9*), ABISELECT(144,100), "S20677C7");
    check_base_class_offset(lv, (S20677C9*), ABISELECT(144,100), "S20677C7");
    check_field_offset(lv, s20677c7f0, ABISELECT(296,212), "S20677C7.s20677c7f0");
    check_field_offset(lv, s20677c7f1, ABISELECT(304,216), "S20677C7.s20677c7f1");
    check_field_offset(lv, s20677c7f2, ABISELECT(464,328), "S20677C7.s20677c7f2");
    check_field_offset(lv, s20677c7f3, ABISELECT(472,332), "S20677C7.s20677c7f3");
    check_field_offset(lv, s20677c7f4, ABISELECT(480,340), "S20677C7.s20677c7f4");
    check_field_offset(lv, s20677c7f5, ABISELECT(496,352), "S20677C7.s20677c7f5");
    test_class_info(&lv, &cd_S20677C7);
    dp->~S20677C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C7(Test_S20677C7, "S20677C7", ABISELECT(832,584));

#else // __cplusplus

extern void _ZN8S20677C7C1Ev();
extern void _ZN8S20677C7D1Ev();
Name_Map name_map_S20677C7[] = {
  NSPAIR(_ZN8S20677C7C1Ev),
  NSPAIR(_ZN8S20677C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C8;
extern VTBL_ENTRY _ZTI8S20677C8[];
extern  VTBL_ENTRY _ZTV8S20677C8[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C9;
extern VTBL_ENTRY _ZTI8S20677C9[];
static Base_Class bases_S20677C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C8,    ABISELECT(512,360), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C3,    ABISELECT(784,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20677C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C3,    ABISELECT(144,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20677C9,    ABISELECT(144,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20677C7[];
extern void _ZN8S20677C72v9Ev();
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY vtc_S20677C7[] = {
  ABISELECT(512,360),
  ABISELECT(784,544),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C7[0]),
  (VTBL_ENTRY)&_ZN8S20677C72v9Ev,
  0,
  ABISELECT(-512,-360),
  (VTBL_ENTRY)&(_ZTI8S20677C7[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern VTBL_ENTRY _ZTV8S20677C7[];
static  VTBL_ENTRY _tg__ZTV8S20677C5__8S20677C7[] = {
  ABISELECT(784,544),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C7[] = {
  {&(_ZTV8S20677C7[4]),  4,9},
  {&(_tg__ZTV8S20677C5__8S20677C7[3]),  3,3},
  {&(_ZTV8S20677C7[8]),  8,9},
};
extern VTBL_ENTRY _ZTI8S20677C7[];
extern  VTBL_ENTRY _ZTV8S20677C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C7[];
Class_Descriptor cd_S20677C7 = {  "S20677C7", // class name
  bases_S20677C7, 5,
  &(vtc_S20677C7[0]), // expected_vtbl_contents
  &(vtt_S20677C7[0]), // expected_vtt_contents
  ABISELECT(832,584), // object size
  NSPAIRA(_ZTI8S20677C7),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S20677C7),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20677C7),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C12  : virtual S20677C3 , virtual S20677C5 {
  int s20677c12f0;
  ::S20677C5 s20677c12f1;
  __tsi64 s20677c12f2;
  int s20677c12f3;
  void *s20677c12f4;
  virtual void  v10(); // _ZN9S20677C123v10Ev
  virtual void  v11(); // _ZN9S20677C123v11Ev
  ~S20677C12(); // tgen
  S20677C12(); // tgen
};
//SIG(-1 S20677C12) C1{ VBC2{ m Fp FL[4] Fs} VBC3{ VBC2 FD Fi FC2 FC2} v1 v2 Fi FC3 FL Fi Fp}


void  S20677C12 ::v10(){vfunc_called(this, "_ZN9S20677C123v10Ev");}
void  S20677C12 ::v11(){vfunc_called(this, "_ZN9S20677C123v11Ev");}
S20677C12 ::~S20677C12(){ note_dtor("S20677C12", this);} // tgen
S20677C12 ::S20677C12(){ note_ctor("S20677C12", this);} // tgen

static void Test_S20677C12()
{
  extern Class_Descriptor cd_S20677C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(28,77)];
    init_test(&cd_S20677C12, buf);
    S20677C12 *dp, &lv = *(dp=new (buf) S20677C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,304), "sizeof(S20677C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C12)");
    check_base_class_offset(lv, (S20677C3*), ABISELECT(232,164), "S20677C12");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(232,164), "S20677C12");
    check_base_class_offset(lv, (S20677C5*), ABISELECT(288,204), "S20677C12");
    check_field_offset(lv, s20677c12f0, ABISELECT(8,4), "S20677C12.s20677c12f0");
    check_field_offset(lv, s20677c12f1, ABISELECT(16,8), "S20677C12.s20677c12f1");
    check_field_offset(lv, s20677c12f2, ABISELECT(208,148), "S20677C12.s20677c12f2");
    check_field_offset(lv, s20677c12f3, ABISELECT(216,156), "S20677C12.s20677c12f3");
    check_field_offset(lv, s20677c12f4, ABISELECT(224,160), "S20677C12.s20677c12f4");
    test_class_info(&lv, &cd_S20677C12);
    dp->~S20677C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C12(Test_S20677C12, "S20677C12", ABISELECT(432,304));

#else // __cplusplus

extern void _ZN9S20677C12C1Ev();
extern void _ZN9S20677C12D1Ev();
Name_Map name_map_S20677C12[] = {
  NSPAIR(_ZN9S20677C12C1Ev),
  NSPAIR(_ZN9S20677C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
static Base_Class bases_S20677C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(232,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C5,    ABISELECT(288,204), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C12[];
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY vtc_S20677C12[] = {
  ABISELECT(288,204),
  ABISELECT(232,164),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  ABISELECT(-56,-40),
  ABISELECT(-288,-204),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
extern VTBL_ENTRY _ZTV9S20677C12[];
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C12[] = {
  {&(_ZTV9S20677C12[4]),  4,9},
  {&(_ZTV9S20677C12[9]),  9,9},
  {&(_tg__ZTV8S20677C5__9S20677C12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
Class_Descriptor cd_S20677C12 = {  "S20677C12", // class name
  bases_S20677C12, 2,
  &(vtc_S20677C12[0]), // expected_vtbl_contents
  &(vtt_S20677C12[0]), // expected_vtt_contents
  ABISELECT(432,304), // object size
  NSPAIRA(_ZTI9S20677C12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20677C12),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C12),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C11  : virtual S20677C4 , virtual S20677C2 , virtual S20677C12 {
  ::S20677C6_nt s20677c11f0;
  ::S20677C6_nt s20677c11f1;
  int s20677c11f2;
  ::S20677C5 s20677c11f3;
  ::S20677C6_nt s20677c11f4;
  ::S20677C6_nt s20677c11f5;
  ::S20677C8 s20677c11f6;
  ::S20677C2 s20677c11f7;
  void *s20677c11f8;
  ::S20677C6_nt s20677c11f9;
  virtual void  v12(); // _ZN9S20677C113v12Ev
  virtual void  v13(); // _ZN9S20677C113v13Ev
  ~S20677C11(); // tgen
  S20677C11(); // tgen
};
//SIG(-1 S20677C11) C1{ VBC2{ VBC3{ m Fp FL[4] Fs} BC4{ VBC3 FD Fi FC3 FC3} v3 v4 v5 Fs FL Fc Fi[2] FC4 Fp FL Fi FL Fi} VBC5{ VBC3 VBC2 v6 v7 v8 FL FC6{} Fp Fc[2] FC3 Fl FC6} VBC7{ VBC3 VBC4 v9 v10 Fi FC4 FL Fi Fp} v1 v2 FC6 FC6 Fi FC4 FC6 FC6 FC8{ v11 FC6 FC4 FC6 FL FC6 Fp FC6 Fp[2] FC6} FC5 Fp FC6}


void  S20677C11 ::v12(){vfunc_called(this, "_ZN9S20677C113v12Ev");}
void  S20677C11 ::v13(){vfunc_called(this, "_ZN9S20677C113v13Ev");}
S20677C11 ::~S20677C11(){ note_dtor("S20677C11", this);} // tgen
S20677C11 ::S20677C11(){ note_ctor("S20677C11", this);} // tgen

static void Test_S20677C11()
{
  extern Class_Descriptor cd_S20677C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(128,356)];
    init_test(&cd_S20677C11, buf);
    S20677C11 *dp, &lv = *(dp=new (buf) S20677C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2032,1420), "sizeof(S20677C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C11)");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*), ABISELECT(1496,1044), "S20677C11");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*), ABISELECT(1496,1044), "S20677C11");
    check_base_class_offset(lv, (S20677C3*)(S20677C2*), ABISELECT(1496,1044), "S20677C11");
    check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(1496,1044), "S20677C11");
    /*is_ambiguous_... S20677C11::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(1496,1044), "S20677C11");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*), ABISELECT(1088,752), "S20677C11");
    check_base_class_offset(lv, (S20677C4*), ABISELECT(1088,752), "S20677C11");
    check_base_class_offset(lv, (S20677C4*)(S20677C2*), ABISELECT(1088,752), "S20677C11");
    check_base_class_offset(lv, (S20677C2*), ABISELECT(1544,1084), "S20677C11");
    check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(1888,1320), "S20677C11");
    check_base_class_offset(lv, (S20677C12*), ABISELECT(1648,1156), "S20677C11");
    check_field_offset(lv, s20677c11f0, ABISELECT(8,4), "S20677C11.s20677c11f0");
    check_field_offset(lv, s20677c11f1, ABISELECT(9,5), "S20677C11.s20677c11f1");
    check_field_offset(lv, s20677c11f2, ABISELECT(12,8), "S20677C11.s20677c11f2");
    check_field_offset(lv, s20677c11f3, ABISELECT(16,12), "S20677C11.s20677c11f3");
    check_field_offset(lv, s20677c11f4, ABISELECT(208,152), "S20677C11.s20677c11f4");
    check_field_offset(lv, s20677c11f5, ABISELECT(209,153), "S20677C11.s20677c11f5");
    check_field_offset(lv, s20677c11f6, ABISELECT(224,156), "S20677C11.s20677c11f6");
    check_field_offset(lv, s20677c11f7, ABISELECT(496,340), "S20677C11.s20677c11f7");
    check_field_offset(lv, s20677c11f8, ABISELECT(1072,744), "S20677C11.s20677c11f8");
    check_field_offset(lv, s20677c11f9, ABISELECT(1080,748), "S20677C11.s20677c11f9");
    test_class_info(&lv, &cd_S20677C11);
    dp->~S20677C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C11(Test_S20677C11, "S20677C11", ABISELECT(2032,1420));

#else // __cplusplus

extern void _ZN9S20677C11C1Ev();
extern void _ZN9S20677C11D1Ev();
Name_Map name_map_S20677C11[] = {
  NSPAIR(_ZN9S20677C11C1Ev),
  NSPAIR(_ZN9S20677C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C2;
extern VTBL_ENTRY _ZTI8S20677C2[];
extern  VTBL_ENTRY _ZTV8S20677C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C2[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
static Base_Class bases_S20677C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(1496,1044), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(1088,752), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(1088,752), //bcp->offset
    9, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C2,    ABISELECT(1544,1084), //bcp->offset
    18, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C5,    ABISELECT(1888,1320), //bcp->offset
    36, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20677C12,    ABISELECT(1648,1156), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C11[];
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY vtc_S20677C11[] = {
  ABISELECT(1888,1320),
  ABISELECT(1648,1156),
  ABISELECT(1544,1084),
  ABISELECT(1496,1044),
  ABISELECT(1088,752),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-1544,-1084),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-1648,-1156),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  ABISELECT(-392,-276),
  ABISELECT(-1888,-1320),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
};
extern VTBL_ENTRY _ZTV9S20677C11[];
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C11[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C4__9S20677C11[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C11[] = {
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__8S20677C2__9S20677C11[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(456,332),
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C11[] = {
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__9S20677C11[] = {
  ABISELECT(-392,-276),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C11[] = {
  ABISELECT(-392,-276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C11[] = {
  {&(_ZTV9S20677C11[7]),  7,39},
  {&(_ZTV9S20677C11[15]),  15,39},
  {&(_ZTV9S20677C11[25]),  25,39},
  {&(_ZTV9S20677C11[34]),  34,39},
  {&(_ZTV9S20677C11[39]),  39,39},
  {&(_tg__ZTV8S20677C4__9S20677C11[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C4__9S20677C11[3]),  3,3},
  {&(_tg__ZTV8S20677C2__9S20677C11[4]),  4,7},
  {&(_tg__ZTV8S20677C4__8S20677C2__9S20677C11[6]),  6,9},
  {&(_tg__ZTV9S20677C12__9S20677C11[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__9S20677C11[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A1__9S20677C11[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20677C11[];
extern  VTBL_ENTRY _ZTV9S20677C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C11[];
Class_Descriptor cd_S20677C11 = {  "S20677C11", // class name
  bases_S20677C11, 6,
  &(vtc_S20677C11[0]), // expected_vtbl_contents
  &(vtt_S20677C11[0]), // expected_vtt_contents
  ABISELECT(2032,1420), // object size
  NSPAIRA(_ZTI9S20677C11),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20677C11),39, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C11),12, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C13  : virtual S20677C5 , S20677C11 , S20677C12 {
  int s20677c13f0;
  char s20677c13f1:2;
  ::S20677C6_nt s20677c13f2;
  int s20677c13f3;
  ~S20677C13(); // tgen
  S20677C13(); // tgen
};
//SIG(-1 S20677C13) C1{ VBC2{ VBC3{ m Fp FL[4] Fs} FD Fi FC3 FC3} BC4{ VBC5{ VBC3 BC2 v1 v2 v3 Fs FL Fc Fi[2] FC2 Fp FL Fi FL Fi} VBC6{ VBC3 VBC5 v4 v5 v6 FL FC7{} Fp Fc[2] FC3 Fl FC7} VBC8{ VBC3 VBC2 v7 v8 Fi FC2 FL Fi Fp} v9 v10 FC7 FC7 Fi FC2 FC7 FC7 FC9{ v11 FC7 FC2 FC7 FL FC7 Fp FC7 Fp[2] FC7} FC6 Fp FC7} BC8 Fi Fc:2 FC7 Fi}


S20677C13 ::~S20677C13(){ note_dtor("S20677C13", this);} // tgen
S20677C13 ::S20677C13(){ note_ctor("S20677C13", this);} // tgen

static void Test_S20677C13()
{
  extern Class_Descriptor cd_S20677C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(144,400)];
    init_test(&cd_S20677C13, buf);
    S20677C13 *dp, &lv = *(dp=new (buf) S20677C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2288,1596), "sizeof(S20677C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C13)");
    /*is_ambiguous_... S20677C13::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(1480,1028), "S20677C13");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*), ABISELECT(1480,1028), "S20677C13");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*), ABISELECT(1480,1028), "S20677C13");
    check_base_class_offset(lv, (S20677C3*)(S20677C2*), ABISELECT(1480,1028), "S20677C13");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(1480,1028), "S20677C13");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(1480,1028), "S20677C13");
    /*is_ambiguous_... S20677C13::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C5*), ABISELECT(1344,928), "S20677C13");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(1344,928), "S20677C13");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(1344,928), "S20677C13");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*), ABISELECT(1536,1068), "S20677C13");
    check_base_class_offset(lv, (S20677C4*)(S20677C11*), ABISELECT(1536,1068), "S20677C13");
    check_base_class_offset(lv, (S20677C4*)(S20677C2*), ABISELECT(1536,1068), "S20677C13");
    check_base_class_offset(lv, (S20677C2*)(S20677C11*), ABISELECT(1944,1360), "S20677C13");
    check_base_class_offset(lv, (S20677C12*)(S20677C11*), ABISELECT(2048,1432), "S20677C13");
    check_base_class_offset(lv, (S20677C11*), 0, "S20677C13");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C12*), ABISELECT(1088,752), "S20677C13");
    check_field_offset(lv, s20677c13f0, ABISELECT(1320,916), "S20677C13.s20677c13f0");
    set_bf_and_test(lv, s20677c13f1, ABISELECT(1324,920), 0, 2, 1, "S20677C13");
    set_bf_and_test(lv, s20677c13f1, ABISELECT(1324,920), 0, 2, hide_sll(1LL<<1), "S20677C13");
    check_field_offset(lv, s20677c13f2, ABISELECT(1325,921), "S20677C13.s20677c13f2");
    check_field_offset(lv, s20677c13f3, ABISELECT(1328,924), "S20677C13.s20677c13f3");
    test_class_info(&lv, &cd_S20677C13);
    dp->~S20677C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C13(Test_S20677C13, "S20677C13", ABISELECT(2288,1596));

#else // __cplusplus

extern void _ZN9S20677C13C1Ev();
extern void _ZN9S20677C13D1Ev();
Name_Map name_map_S20677C13[] = {
  NSPAIR(_ZN9S20677C13C1Ev),
  NSPAIR(_ZN9S20677C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C2;
extern VTBL_ENTRY _ZTI8S20677C2[];
extern  VTBL_ENTRY _ZTV8S20677C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C2[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C11;
extern VTBL_ENTRY _ZTI9S20677C11[];
extern  VTBL_ENTRY _ZTV9S20677C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C11[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
static Base_Class bases_S20677C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(1480,1028), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(1344,928), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C5,    ABISELECT(1536,1068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(1536,1068), //bcp->offset
    18, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20677C2,    ABISELECT(1944,1360), //bcp->offset
    27, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20677C12,    ABISELECT(2048,1432), //bcp->offset
    37, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20677C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C12,    ABISELECT(1088,752), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C13[];
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY vtc_S20677C13[] = {
  ABISELECT(1344,928),
  ABISELECT(2048,1432),
  ABISELECT(1944,1360),
  ABISELECT(1480,1028),
  ABISELECT(1536,1068),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  ABISELECT(256,176),
  ABISELECT(392,276),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  ABISELECT(136,100),
  ABISELECT(-1344,-928),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-1536,-1068),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  ABISELECT(-1944,-1360),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
  0,
  0,
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  ABISELECT(-2048,-1432),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
extern VTBL_ENTRY _ZTV9S20677C13[];
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C11__9S20677C13[] = {
  ABISELECT(1344,928),
  ABISELECT(2048,1432),
  ABISELECT(1944,1360),
  ABISELECT(1480,1028),
  ABISELECT(1536,1068),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C11__9S20677C13[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-1536,-1068),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C11__9S20677C13[] = {
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  ABISELECT(-1944,-1360),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C11__9S20677C13[] = {
  0,
  0,
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  ABISELECT(-2048,-1432),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C11__9S20677C13[] = {
  ABISELECT(136,100),
  ABISELECT(-1344,-928),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__A__9S20677C13[] = {
  ABISELECT(256,176),
  ABISELECT(392,276),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__A__9S20677C13[] = {
  ABISELECT(136,100),
  ABISELECT(-256,-176),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C13[] = {
  ABISELECT(136,100),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C13[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C4__A1__9S20677C13[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C13[] = {
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__8S20677C2__9S20677C13[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(408,292),
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C13[] = {
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__9S20677C13[] = {
  ABISELECT(136,100),
  ABISELECT(704,504),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTT_ENTRY vtt_S20677C13[] = {
  {&(_ZTV9S20677C13[7]),  7,45},
  {&(_tg__ZTV9S20677C11__9S20677C13[7]),  7,9},
  {&(_tg__ZTV8S20677C4__9S20677C11__9S20677C13[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C11__9S20677C13[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C11__9S20677C13[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C11__9S20677C13[3]),  3,3},
  {&(_tg__ZTV9S20677C12__A__9S20677C13[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__A__9S20677C13[3]),  3,3},
  {&(_ZTV9S20677C13[18]),  18,45},
  {&(_ZTV9S20677C13[24]),  24,45},
  {&(_ZTV9S20677C13[34]),  34,45},
  {&(_ZTV9S20677C13[43]),  43,45},
  {&(_ZTV9S20677C13[13]),  13,45},
  {&(_tg__ZTV8S20677C5__9S20677C13[3]),  3,3},
  {&(_tg__ZTV8S20677C4__9S20677C13[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C4__A1__9S20677C13[3]),  3,3},
  {&(_tg__ZTV8S20677C2__9S20677C13[4]),  4,7},
  {&(_tg__ZTV8S20677C4__8S20677C2__9S20677C13[6]),  6,9},
  {&(_tg__ZTV9S20677C12__9S20677C13[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__9S20677C13[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20677C13[];
extern  VTBL_ENTRY _ZTV9S20677C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C13[];
Class_Descriptor cd_S20677C13 = {  "S20677C13", // class name
  bases_S20677C13, 8,
  &(vtc_S20677C13[0]), // expected_vtbl_contents
  &(vtt_S20677C13[0]), // expected_vtt_contents
  ABISELECT(2288,1596), // object size
  NSPAIRA(_ZTI9S20677C13),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20677C13),45, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C13),20, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C16  : S20677C5 {
  __tsi64 s20677c16f0;
  char s20677c16f1[7];
  void *s20677c16f2;
  int s20677c16f3;
  ::S20677C6_nt s20677c16f4;
  ::S20677C6_nt s20677c16f5;
  char s20677c16f6[10];
  virtual void  v15(); // _ZN9S20677C163v15Ev
  ~S20677C16(); // tgen
  S20677C16(); // tgen
};
//SIG(-1 S20677C16) C1{ BC2{ VBC3{ m Fp FL[4] Fs} FD Fi FC3 FC3} v1 FL Fc[7] Fp Fi FC4{} FC4 Fc[10]}


void  S20677C16 ::v15(){vfunc_called(this, "_ZN9S20677C163v15Ev");}
S20677C16 ::~S20677C16(){ note_dtor("S20677C16", this);} // tgen
S20677C16 ::S20677C16(){ note_ctor("S20677C16", this);} // tgen

static void Test_S20677C16()
{
  extern Class_Descriptor cd_S20677C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(15,45)];
    init_test(&cd_S20677C16, buf);
    S20677C16 *dp, &lv = *(dp=new (buf) S20677C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,176), "sizeof(S20677C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C16)");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(176,136), "S20677C16");
    check_base_class_offset(lv, (S20677C5*), 0, "S20677C16");
    check_field_offset(lv, s20677c16f0, ABISELECT(136,100), "S20677C16.s20677c16f0");
    check_field_offset(lv, s20677c16f1, ABISELECT(144,108), "S20677C16.s20677c16f1");
    check_field_offset(lv, s20677c16f2, ABISELECT(152,116), "S20677C16.s20677c16f2");
    check_field_offset(lv, s20677c16f3, ABISELECT(160,120), "S20677C16.s20677c16f3");
    check_field_offset(lv, s20677c16f4, ABISELECT(164,124), "S20677C16.s20677c16f4");
    check_field_offset(lv, s20677c16f5, ABISELECT(165,125), "S20677C16.s20677c16f5");
    check_field_offset(lv, s20677c16f6, ABISELECT(166,126), "S20677C16.s20677c16f6");
    test_class_info(&lv, &cd_S20677C16);
    dp->~S20677C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C16(Test_S20677C16, "S20677C16", ABISELECT(224,176));

#else // __cplusplus

extern void _ZN9S20677C16C1Ev();
extern void _ZN9S20677C16D1Ev();
Name_Map name_map_S20677C16[] = {
  NSPAIR(_ZN9S20677C16C1Ev),
  NSPAIR(_ZN9S20677C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
static Base_Class bases_S20677C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(176,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20677C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C16[];
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY vtc_S20677C16[] = {
  ABISELECT(176,136),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C16[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern VTBL_ENTRY _ZTV9S20677C16[];
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C16[] = {
  ABISELECT(176,136),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C16[] = {
  {&(_ZTV9S20677C16[3]),  3,4},
  {&(_tg__ZTV8S20677C5__9S20677C16[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20677C16[];
extern  VTBL_ENTRY _ZTV9S20677C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C16[];
Class_Descriptor cd_S20677C16 = {  "S20677C16", // class name
  bases_S20677C16, 2,
  &(vtc_S20677C16[0]), // expected_vtbl_contents
  &(vtt_S20677C16[0]), // expected_vtt_contents
  ABISELECT(224,176), // object size
  NSPAIRA(_ZTI9S20677C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S20677C16),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C16),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C15  : S20677C4 , virtual S20677C12 , S20677C5 , virtual S20677C8 , virtual S20677C16 {
  long s20677c15f0;
  __tsi64 s20677c15f1;
  long double s20677c15f2;
  ::S20677C6_nt s20677c15f3;
  virtual void  v16(); // _ZN9S20677C153v16Ev
  ~S20677C15(); // tgen
  S20677C15(); // tgen
};
//SIG(-1 S20677C15) C1{ BC2{ VBC3{ m Fp FL[4] Fs} BC4{ VBC3 FD Fi FC3 FC3} v2 v3 v4 Fs FL Fc Fi[2] FC4 Fp FL Fi FL Fi} VBC5{ VBC3 VBC4 v5 v6 Fi FC4 FL Fi Fp} BC4 VBC6{ v7 FC7{} FC4 FC7 FL FC7 Fp FC7 Fp[2] FC7} VBC8{ BC4 v8 FL Fc[7] Fp Fi FC7 FC7 Fc[10]} v1 Fl FL FD FC7}


void  S20677C15 ::v16(){vfunc_called(this, "_ZN9S20677C153v16Ev");}
S20677C15 ::~S20677C15(){ note_dtor("S20677C15", this);} // tgen
S20677C15 ::S20677C15(){ note_ctor("S20677C15", this);} // tgen

static void Test_S20677C15()
{
  extern Class_Descriptor cd_S20677C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(94,262)];
    init_test(&cd_S20677C15, buf);
    S20677C15 *dp, &lv = *(dp=new (buf) S20677C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1488,1044), "sizeof(S20677C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C15)");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*), ABISELECT(600,420), "S20677C15");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*), ABISELECT(600,420), "S20677C15");
    check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(600,420), "S20677C15");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(600,420), "S20677C15");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(600,420), "S20677C15");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C16*), ABISELECT(600,420), "S20677C15");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*), 0, "S20677C15");
    check_base_class_offset(lv, (S20677C4*), 0, "S20677C15");
    check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(896,624), "S20677C15");
    check_base_class_offset(lv, (S20677C12*), ABISELECT(656,460), "S20677C15");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C5*), ABISELECT(416,292), "S20677C15");
    check_base_class_offset(lv, (S20677C8*), ABISELECT(1040,724), "S20677C15");
    check_base_class_offset(lv, (S20677C5*)(S20677C16*), ABISELECT(1312,908), "S20677C15");
    check_base_class_offset(lv, (S20677C16*), ABISELECT(1312,908), "S20677C15");
    check_field_offset(lv, s20677c15f0, ABISELECT(552,392), "S20677C15.s20677c15f0");
    check_field_offset(lv, s20677c15f1, ABISELECT(560,396), "S20677C15.s20677c15f1");
    check_field_offset(lv, s20677c15f2, ABISELECT(576,404), "S20677C15.s20677c15f2");
    check_field_offset(lv, s20677c15f3, ABISELECT(592,416), "S20677C15.s20677c15f3");
    test_class_info(&lv, &cd_S20677C15);
    dp->~S20677C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C15(Test_S20677C15, "S20677C15", ABISELECT(1488,1044));

#else // __cplusplus

extern void _ZN9S20677C15C1Ev();
extern void _ZN9S20677C15D1Ev();
Name_Map name_map_S20677C15[] = {
  NSPAIR(_ZN9S20677C15C1Ev),
  NSPAIR(_ZN9S20677C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C8;
extern VTBL_ENTRY _ZTI8S20677C8[];
extern  VTBL_ENTRY _ZTV8S20677C8[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C16;
extern VTBL_ENTRY _ZTI9S20677C16[];
extern  VTBL_ENTRY _ZTV9S20677C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C16[];
static Base_Class bases_S20677C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(600,420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20677C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20677C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C5,    ABISELECT(896,624), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20677C12,    ABISELECT(656,460), //bcp->offset
    14, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C5,    ABISELECT(416,292), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C8,    ABISELECT(1040,724), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C5,    ABISELECT(1312,908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20677C16,    ABISELECT(1312,908), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C15[];
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN8S20677C82v8Ev();
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY vtc_S20677C15[] = {
  ABISELECT(1312,908),
  ABISELECT(1040,724),
  ABISELECT(896,624),
  ABISELECT(656,460),
  ABISELECT(600,420),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
  ABISELECT(184,128),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-56,-40),
  ABISELECT(-656,-460),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  ABISELECT(-296,-204),
  ABISELECT(-896,-624),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  0,
  ABISELECT(-1040,-724),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
  0,
  ABISELECT(-712,-488),
  ABISELECT(-1312,-908),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern VTBL_ENTRY _ZTV9S20677C15[];
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C15[] = {
  ABISELECT(600,420),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C4__9S20677C15[] = {
  ABISELECT(600,420),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A__9S20677C15[] = {
  ABISELECT(184,128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C15[] = {
  ABISELECT(240,164),
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__9S20677C15[] = {
  ABISELECT(-296,-204),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C15[] = {
  ABISELECT(-296,-204),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C15[] = {
  ABISELECT(-712,-488),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C16[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C16__A3__9S20677C15[] = {
  ABISELECT(-712,-488),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C15[] = {
  {&(_ZTV9S20677C15[7]),  7,34},
  {&(_tg__ZTV8S20677C4__9S20677C15[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C4__9S20677C15[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A__9S20677C15[3]),  3,3},
  {&(_ZTV9S20677C15[20]),  20,34},
  {&(_ZTV9S20677C15[25]),  25,34},
  {&(_ZTV9S20677C15[14]),  14,34},
  {&(_ZTV9S20677C15[28]),  28,34},
  {&(_ZTV9S20677C15[33]),  33,34},
  {&(_tg__ZTV9S20677C12__9S20677C15[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__9S20677C15[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A1__9S20677C15[3]),  3,3},
  {&(_tg__ZTV9S20677C16__9S20677C15[3]),  3,4},
  {&(_tg__ZTV8S20677C59S20677C16__A3__9S20677C15[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20677C15[];
extern  VTBL_ENTRY _ZTV9S20677C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C15[];
Class_Descriptor cd_S20677C15 = {  "S20677C15", // class name
  bases_S20677C15, 9,
  &(vtc_S20677C15[0]), // expected_vtbl_contents
  &(vtt_S20677C15[0]), // expected_vtt_contents
  ABISELECT(1488,1044), // object size
  NSPAIRA(_ZTI9S20677C15),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20677C15),34, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C15),14, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C17  : virtual S20677C8 {
  ::S20677C15 s20677c17f0;
  ::S20677C6_nt s20677c17f1;
  long s20677c17f2;
  int s20677c17f3[2];
  virtual void  v22(); // _ZN9S20677C173v22Ev
  ~S20677C17(); // tgen
  S20677C17(); // tgen
};
//SIG(-1 S20677C17) C1{ VBC2{ v2 FC3{} FC4{ VBC5{ m Fp FL[4] Fs} FD Fi FC5 FC5} FC3 FL FC3 Fp FC3 Fp[2] FC3} v1 FC6{ BC7{ VBC5 BC4 v4 v5 v6 Fs FL Fc Fi[2] FC4 Fp FL Fi FL Fi} VBC8{ VBC5 VBC4 v7 v8 Fi FC4 FL Fi Fp} BC4 VBC2 VBC9{ BC4 v9 FL Fc[7] Fp Fi FC3 FC3 Fc[10]} v3 Fl FL FD FC3} FC3 Fl Fi[2]}


void  S20677C17 ::v22(){vfunc_called(this, "_ZN9S20677C173v22Ev");}
S20677C17 ::~S20677C17(){ note_dtor("S20677C17", this);} // tgen
S20677C17 ::S20677C17(){ note_ctor("S20677C17", this);} // tgen

static void Test_S20677C17()
{
  extern Class_Descriptor cd_S20677C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(114,313)];
    init_test(&cd_S20677C17, buf);
    S20677C17 *dp, &lv = *(dp=new (buf) S20677C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1808,1248), "sizeof(S20677C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C17)");
    check_base_class_offset(lv, (S20677C8*), ABISELECT(1536,1064), "S20677C17");
    check_field_offset(lv, s20677c17f0, ABISELECT(16,4), "S20677C17.s20677c17f0");
    check_field_offset(lv, s20677c17f1, ABISELECT(1504,1048), "S20677C17.s20677c17f1");
    check_field_offset(lv, s20677c17f2, ABISELECT(1512,1052), "S20677C17.s20677c17f2");
    check_field_offset(lv, s20677c17f3, ABISELECT(1520,1056), "S20677C17.s20677c17f3");
    test_class_info(&lv, &cd_S20677C17);
    dp->~S20677C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C17(Test_S20677C17, "S20677C17", ABISELECT(1808,1248));

#else // __cplusplus

extern void _ZN9S20677C17C1Ev();
extern void _ZN9S20677C17D1Ev();
Name_Map name_map_S20677C17[] = {
  NSPAIR(_ZN9S20677C17C1Ev),
  NSPAIR(_ZN9S20677C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C8;
extern VTBL_ENTRY _ZTI8S20677C8[];
extern  VTBL_ENTRY _ZTV8S20677C8[];
static Base_Class bases_S20677C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C8,    ABISELECT(1536,1064), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C17[];
extern void _ZN9S20677C173v22Ev();
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY vtc_S20677C17[] = {
  ABISELECT(1536,1064),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C17[0]),
  (VTBL_ENTRY)&_ZN9S20677C173v22Ev,
  0,
  ABISELECT(-1536,-1064),
  (VTBL_ENTRY)&(_ZTI9S20677C17[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern VTBL_ENTRY _ZTV9S20677C17[];
static  VTT_ENTRY vtt_S20677C17[] = {
  {&(_ZTV9S20677C17[3]),  3,8},
  {&(_ZTV9S20677C17[7]),  7,8},
};
extern VTBL_ENTRY _ZTI9S20677C17[];
extern  VTBL_ENTRY _ZTV9S20677C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C17[];
Class_Descriptor cd_S20677C17 = {  "S20677C17", // class name
  bases_S20677C17, 1,
  &(vtc_S20677C17[0]), // expected_vtbl_contents
  &(vtt_S20677C17[0]), // expected_vtt_contents
  ABISELECT(1808,1248), // object size
  NSPAIRA(_ZTI9S20677C17),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S20677C17),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C17),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C14  : S20677C15 , S20677C17 , S20677C13 {
  void *s20677c14f0;
  __tsi64 s20677c14f1;
  int s20677c14f2;
  void *s20677c14f3;
  int s20677c14f4[3];
  char s20677c14f5;
  __tsi64 s20677c14f6;
  void *s20677c14f7;
  long double s20677c14f8;
  ~S20677C14(); // tgen
  S20677C14(); // tgen
};
//SIG(-1 S20677C14) C1{ BC2{ BC3{ VBC4{ m Fp FL[4] Fs} BC5{ VBC4 FD Fi FC4 FC4} v1 v2 v3 Fs FL Fc Fi[2] FC5 Fp FL Fi FL Fi} VBC6{ VBC4 VBC5 v4 v5 Fi FC5 FL Fi Fp} BC5 VBC7{ v6 FC8{} FC5 FC8 FL FC8 Fp FC8 Fp[2] FC8} VBC9{ BC5 v7 FL Fc[7] Fp Fi FC8 FC8 Fc[10]} v8 Fl FL FD FC8} BC10{ VBC7 v9 FC2 FC8 Fl Fi[2]} BC11{ VBC5 BC12{ VBC3 VBC13{ VBC4 VBC3 v10 v11 v12 FL FC8 Fp Fc[2] FC4 Fl FC8} VBC6 v13 v14 FC8 FC8 Fi FC5 FC8 FC8 FC7 FC13 Fp FC8} BC6 Fi Fc:2 FC8 Fi} Fp FL Fi Fp Fi[3] Fc FL Fp FD}


S20677C14 ::~S20677C14(){ note_dtor("S20677C14", this);} // tgen
S20677C14 ::S20677C14(){ note_ctor("S20677C14", this);} // tgen

static void Test_S20677C14()
{
  extern Class_Descriptor cd_S20677C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(311,866)];
    init_test(&cd_S20677C14, buf);
    S20677C14 *dp, &lv = *(dp=new (buf) S20677C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4960,3460), "sizeof(S20677C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C14)");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*)(S20677C15*), ABISELECT(3568,2472), "S20677C14");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*)(S20677C15*), ABISELECT(3568,2472), "S20677C14");
    /*is_ambiguous_... S20677C14::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(3568,2472), "S20677C14");
    /*is_ambiguous_... S20677C14::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(3568,2472), "S20677C14");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C15*), ABISELECT(3568,2472), "S20677C14");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C16*), ABISELECT(3568,2472), "S20677C14");
    /*is_ambiguous_... S20677C14::S20677C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C4*), ABISELECT(3568,2472), "S20677C14");
    /*is_ambiguous_... S20677C14::S20677C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*), ABISELECT(3568,2472), "S20677C14");
    check_base_class_offset(lv, (S20677C3*)(S20677C2*), ABISELECT(3568,2472), "S20677C14");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*)(S20677C13*), ABISELECT(3568,2472), "S20677C14");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*)(S20677C15*), 0, "S20677C14");
    check_base_class_offset(lv, (S20677C4*)(S20677C15*), 0, "S20677C14");
    /*is_ambiguous_... S20677C14::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(3856,2676), "S20677C14");
    /*is_ambiguous_... S20677C13::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C13*), ABISELECT(3856,2676), "S20677C14");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*)(S20677C13*), ABISELECT(3856,2676), "S20677C14");
    check_base_class_offset(lv, (S20677C12*)(S20677C15*), ABISELECT(3616,2512), "S20677C14");
    check_base_class_offset(lv, (S20677C12*)(S20677C11*)(S20677C13*), ABISELECT(3616,2512), "S20677C14");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C15*), ABISELECT(416,292), "S20677C14");
    check_base_class_offset(lv, (S20677C8*)(S20677C15*), ABISELECT(4000,2776), "S20677C14");
    check_base_class_offset(lv, (S20677C8*)(S20677C17*), ABISELECT(4000,2776), "S20677C14");
    check_base_class_offset(lv, (S20677C5*)(S20677C16*), ABISELECT(4272,2960), "S20677C14");
    check_base_class_offset(lv, (S20677C16*)(S20677C15*), ABISELECT(4272,2960), "S20677C14");
    check_base_class_offset(lv, (S20677C15*), 0, "S20677C14");
    check_base_class_offset(lv, (S20677C17*), ABISELECT(608,420), "S20677C14");
    /*is_ambiguous_... S20677C14::S20677C4 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C4*), ABISELECT(4448,3096), "S20677C14");
    check_base_class_offset(lv, (S20677C4*)(S20677C11*)(S20677C13*), ABISELECT(4448,3096), "S20677C14");
    check_base_class_offset(lv, (S20677C4*)(S20677C2*), ABISELECT(4448,3096), "S20677C14");
    check_base_class_offset(lv, (S20677C2*)(S20677C11*)(S20677C13*), ABISELECT(4856,3388), "S20677C14");
    check_base_class_offset(lv, (S20677C11*)(S20677C13*), ABISELECT(2144,1484), "S20677C14");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C12*)(S20677C13*), ABISELECT(3232,2236), "S20677C14");
    check_base_class_offset(lv, (S20677C13*), ABISELECT(2144,1484), "S20677C14");
    check_field_offset(lv, s20677c14f0, ABISELECT(3480,2412), "S20677C14.s20677c14f0");
    check_field_offset(lv, s20677c14f1, ABISELECT(3488,2416), "S20677C14.s20677c14f1");
    check_field_offset(lv, s20677c14f2, ABISELECT(3496,2424), "S20677C14.s20677c14f2");
    check_field_offset(lv, s20677c14f3, ABISELECT(3504,2428), "S20677C14.s20677c14f3");
    check_field_offset(lv, s20677c14f4, ABISELECT(3512,2432), "S20677C14.s20677c14f4");
    check_field_offset(lv, s20677c14f5, ABISELECT(3524,2444), "S20677C14.s20677c14f5");
    check_field_offset(lv, s20677c14f6, ABISELECT(3528,2448), "S20677C14.s20677c14f6");
    check_field_offset(lv, s20677c14f7, ABISELECT(3536,2456), "S20677C14.s20677c14f7");
    check_field_offset(lv, s20677c14f8, ABISELECT(3552,2460), "S20677C14.s20677c14f8");
    test_class_info(&lv, &cd_S20677C14);
    dp->~S20677C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C14(Test_S20677C14, "S20677C14", ABISELECT(4960,3460));

#else // __cplusplus

extern void _ZN9S20677C14C1Ev();
extern void _ZN9S20677C14D1Ev();
Name_Map name_map_S20677C14[] = {
  NSPAIR(_ZN9S20677C14C1Ev),
  NSPAIR(_ZN9S20677C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C8;
extern VTBL_ENTRY _ZTI8S20677C8[];
extern  VTBL_ENTRY _ZTV8S20677C8[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C16;
extern VTBL_ENTRY _ZTI9S20677C16[];
extern  VTBL_ENTRY _ZTV9S20677C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C16[];
extern Class_Descriptor cd_S20677C15;
extern VTBL_ENTRY _ZTI9S20677C15[];
extern  VTBL_ENTRY _ZTV9S20677C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C15[];
extern Class_Descriptor cd_S20677C17;
extern VTBL_ENTRY _ZTI9S20677C17[];
extern  VTBL_ENTRY _ZTV9S20677C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C17[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C2;
extern VTBL_ENTRY _ZTI8S20677C2[];
extern  VTBL_ENTRY _ZTV8S20677C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C2[];
extern Class_Descriptor cd_S20677C11;
extern VTBL_ENTRY _ZTI9S20677C11[];
extern  VTBL_ENTRY _ZTV9S20677C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C11[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C13;
extern VTBL_ENTRY _ZTI9S20677C13[];
extern  VTBL_ENTRY _ZTV9S20677C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C13[];
static Base_Class bases_S20677C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(3568,2472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20677C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20677C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20677C5,    ABISELECT(3856,2676), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20677C12,    ABISELECT(3616,2512), //bcp->offset
    35, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(416,292), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20677C8,    ABISELECT(4000,2776), //bcp->offset
    46, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(4272,2960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20677C16,    ABISELECT(4272,2960), //bcp->offset
    50, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20677C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C17,    ABISELECT(608,420), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C5,    ABISELECT(4448,3096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(4448,3096), //bcp->offset
    55, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S20677C2,    ABISELECT(4856,3388), //bcp->offset
    64, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S20677C11,    ABISELECT(2144,1484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20677C12,    ABISELECT(3232,2236), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20677C13,    ABISELECT(2144,1484), //bcp->offset
    20, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C14[];
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
extern void _ZN9S20677C173v22Ev();
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN8S20677C82v8Ev();
extern void _ZN9S20677C163v15Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY vtc_S20677C14[] = {
  ABISELECT(4856,3388),
  ABISELECT(4448,3096),
  ABISELECT(4272,2960),
  ABISELECT(4000,2776),
  ABISELECT(3856,2676),
  ABISELECT(3616,2512),
  ABISELECT(3568,2472),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
  ABISELECT(3152,2180),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  ABISELECT(3392,2356),
  ABISELECT(-608,-420),
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  (VTBL_ENTRY)&_ZN9S20677C173v22Ev,
  ABISELECT(1712,1192),
  ABISELECT(1472,1028),
  ABISELECT(2712,1904),
  ABISELECT(1424,988),
  ABISELECT(2304,1612),
  ABISELECT(-2144,-1484),
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  ABISELECT(624,440),
  ABISELECT(336,236),
  ABISELECT(-3232,-2236),
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-48,-40),
  ABISELECT(-3616,-2512),
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  ABISELECT(-288,-204),
  ABISELECT(-3856,-2676),
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  0,
  ABISELECT(-4000,-2776),
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
  0,
  ABISELECT(-704,-488),
  ABISELECT(-4272,-2960),
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
  0,
  0,
  0,
  ABISELECT(-880,-624),
  ABISELECT(-4448,-3096),
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-1288,-916),
  ABISELECT(-4856,-3388),
  (VTBL_ENTRY)&(_ZTI9S20677C14[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern VTBL_ENTRY _ZTV9S20677C14[];
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C15__9S20677C14[] = {
  ABISELECT(4272,2960),
  ABISELECT(4000,2776),
  ABISELECT(3856,2676),
  ABISELECT(3616,2512),
  ABISELECT(3568,2472),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C49S20677C15__9S20677C14[] = {
  ABISELECT(3568,2472),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C49S20677C15__9S20677C14[] = {
  ABISELECT(3568,2472),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C15__A2__9S20677C14[] = {
  ABISELECT(3152,2180),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C15__9S20677C14[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-48,-40),
  ABISELECT(-3616,-2512),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C15__9S20677C14[] = {
  ABISELECT(-288,-204),
  ABISELECT(-3856,-2676),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A__9S20677C15__9S20677C14[] = {
  ABISELECT(3152,2180),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
};
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C8__9S20677C15__9S20677C14[] = {
  0,
  ABISELECT(-4000,-2776),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C15__9S20677C14[] = {
  0,
  ABISELECT(-704,-488),
  ABISELECT(-4272,-2960),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern void _ZN9S20677C173v22Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C17__9S20677C14[] = {
  ABISELECT(3392,2356),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C17[0]),
  (VTBL_ENTRY)&_ZN9S20677C173v22Ev,
};
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C8__9S20677C17__9S20677C14[] = {
  0,
  ABISELECT(-3392,-2356),
  (VTBL_ENTRY)&(_ZTI9S20677C17[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C13__9S20677C14[] = {
  ABISELECT(1712,1192),
  ABISELECT(1472,1028),
  ABISELECT(2712,1904),
  ABISELECT(1424,988),
  ABISELECT(2304,1612),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C119S20677C13__9S20677C14[] = {
  ABISELECT(1712,1192),
  ABISELECT(1472,1028),
  ABISELECT(2712,1904),
  ABISELECT(1424,988),
  ABISELECT(2304,1612),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C119S20677C13__9S20677C14[] = {
  0,
  0,
  0,
  ABISELECT(-880,-624),
  ABISELECT(-2304,-1612),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C119S20677C13__9S20677C14[] = {
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-1288,-916),
  ABISELECT(-2712,-1904),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C119S20677C13__9S20677C14[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-48,-40),
  ABISELECT(-1472,-1028),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C119S20677C13__9S20677C14[] = {
  ABISELECT(-288,-204),
  ABISELECT(-1712,-1192),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C129S20677C13__A1__9S20677C14[] = {
  ABISELECT(624,440),
  ABISELECT(336,236),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C129S20677C13__A1__9S20677C14[] = {
  ABISELECT(-288,-204),
  ABISELECT(-624,-440),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C13__9S20677C14[] = {
  ABISELECT(-288,-204),
  ABISELECT(-1712,-1192),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C13__9S20677C14[] = {
  0,
  0,
  0,
  ABISELECT(-880,-624),
  ABISELECT(-2304,-1612),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C13__9S20677C14[] = {
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-1288,-916),
  ABISELECT(-2712,-1904),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C13__9S20677C14[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-48,-40),
  ABISELECT(-1472,-1028),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__A__9S20677C13__9S20677C14[] = {
  ABISELECT(624,440),
  ABISELECT(336,236),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C14[] = {
  ABISELECT(240,164),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__9S20677C14[] = {
  ABISELECT(-288,-204),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C14[] = {
  ABISELECT(-288,-204),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C14[] = {
  ABISELECT(-704,-488),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C16[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C16__A3__9S20677C14[] = {
  ABISELECT(-704,-488),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__A1__9S20677C14[] = {
  ABISELECT(-880,-624),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C4__A4__9S20677C14[] = {
  ABISELECT(-880,-624),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C14[] = {
  ABISELECT(-408,-292),
  ABISELECT(-1288,-916),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__8S20677C2__9S20677C14[] = {
  0,
  0,
  0,
  ABISELECT(-880,-624),
  ABISELECT(408,292),
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTT_ENTRY vtt_S20677C14[] = {
  {&(_ZTV9S20677C14[9]),  9,74},
  {&(_tg__ZTV9S20677C15__9S20677C14[7]),  7,11},
  {&(_tg__ZTV8S20677C49S20677C15__9S20677C14[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C49S20677C15__9S20677C14[3]),  3,3},
  {&(_tg__ZTV8S20677C59S20677C15__A2__9S20677C14[3]),  3,3},
  {&(_tg__ZTV9S20677C12__9S20677C15__9S20677C14[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C15__9S20677C14[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A__9S20677C15__9S20677C14[3]),  3,3},
  {&(_tg__ZTV8S20677C8__9S20677C15__9S20677C14[3]),  3,4},
  {&(_tg__ZTV9S20677C16__9S20677C15__9S20677C14[4]),  4,5},
  {&(_tg__ZTV9S20677C17__9S20677C14[3]),  3,4},
  {&(_tg__ZTV8S20677C8__9S20677C17__9S20677C14[3]),  3,4},
  {&(_tg__ZTV9S20677C13__9S20677C14[7]),  7,9},
  {&(_tg__ZTV9S20677C119S20677C13__9S20677C14[7]),  7,9},
  {&(_tg__ZTV8S20677C4__9S20677C119S20677C13__9S20677C14[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C119S20677C13__9S20677C14[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C119S20677C13__9S20677C14[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C119S20677C13__9S20677C14[3]),  3,3},
  {&(_tg__ZTV9S20677C129S20677C13__A1__9S20677C14[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C129S20677C13__A1__9S20677C14[3]),  3,3},
  {&(_tg__ZTV8S20677C5__9S20677C13__9S20677C14[3]),  3,3},
  {&(_tg__ZTV8S20677C4__9S20677C13__9S20677C14[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C13__9S20677C14[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C13__9S20677C14[6]),  6,8},
  {&(_tg__ZTV9S20677C12__A__9S20677C13__9S20677C14[4]),  4,6},
  {&(_ZTV9S20677C14[41]),  41,74},
  {&(_ZTV9S20677C14[46]),  46,74},
  {&(_ZTV9S20677C14[16]),  16,74},
  {&(_ZTV9S20677C14[49]),  49,74},
  {&(_ZTV9S20677C14[54]),  54,74},
  {&(_ZTV9S20677C14[19]),  19,74},
  {&(_ZTV9S20677C14[27]),  27,74},
  {&(_ZTV9S20677C14[61]),  61,74},
  {&(_ZTV9S20677C14[71]),  71,74},
  {&(_ZTV9S20677C14[33]),  33,74},
  {&(_tg__ZTV9S20677C12__9S20677C14[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__9S20677C14[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A1__9S20677C14[3]),  3,3},
  {&(_tg__ZTV9S20677C16__9S20677C14[3]),  3,4},
  {&(_tg__ZTV8S20677C59S20677C16__A3__9S20677C14[3]),  3,3},
  {&(_tg__ZTV8S20677C4__A1__9S20677C14[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C4__A4__9S20677C14[3]),  3,3},
  {&(_tg__ZTV8S20677C2__9S20677C14[4]),  4,7},
  {&(_tg__ZTV8S20677C4__8S20677C2__9S20677C14[6]),  6,9},
};
extern VTBL_ENTRY _ZTI9S20677C14[];
extern  VTBL_ENTRY _ZTV9S20677C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C14[];
Class_Descriptor cd_S20677C14 = {  "S20677C14", // class name
  bases_S20677C14, 17,
  &(vtc_S20677C14[0]), // expected_vtbl_contents
  &(vtt_S20677C14[0]), // expected_vtt_contents
  ABISELECT(4960,3460), // object size
  NSPAIRA(_ZTI9S20677C14),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20677C14),74, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C14),44, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C10  : S20677C11 {
  int s20677c10f0[2];
  ::S20677C6_nt s20677c10f1;
  ::S20677C6_nt s20677c10f2;
  ::S20677C6_nt s20677c10f3;
  ::S20677C6_nt s20677c10f4;
  ::S20677C6_nt s20677c10f5;
  ::S20677C13 s20677c10f6;
  long s20677c10f7[4];
  ::S20677C6_nt s20677c10f8;
  ::S20677C14 s20677c10f9[2];
  char s20677c10f10;
  ::S20677C6_nt s20677c10f11;
  virtual void  v14(); // _ZN9S20677C103v14Ev
  ~S20677C10(); // tgen
  S20677C10(); // tgen
};
//SIG(-1 S20677C10) C1{ BC2{ VBC3{ VBC4{ m Fp FL[4] Fs} BC5{ VBC4 FD Fi FC4 FC4} v2 v3 v4 Fs FL Fc Fi[2] FC5 Fp FL Fi FL Fi} VBC6{ VBC4 VBC3 v5 v6 v7 FL FC7{} Fp Fc[2] FC4 Fl FC7} VBC8{ VBC4 VBC5 v8 v9 Fi FC5 FL Fi Fp} v10 v11 FC7 FC7 Fi FC5 FC7 FC7 FC9{ v12 FC7 FC5 FC7 FL FC7 Fp FC7 Fp[2] FC7} FC6 Fp FC7} v1 Fi[2] FC7 FC7 FC7 FC7 FC7 FC10{ VBC5 BC2 BC8 Fi Fc:2 FC7 Fi} Fl[4] FC7 FC11{ BC12{ BC3 VBC8 BC5 VBC9 VBC13{ BC5 v13 FL Fc[7] Fp Fi FC7 FC7 Fc[10]} v14 Fl FL FD FC7} BC14{ VBC9 v15 FC12 FC7 Fl Fi[2]} BC10 Fp FL Fi Fp Fi[3] Fc FL Fp FD}[2] Fc FC7}


void  S20677C10 ::v14(){vfunc_called(this, "_ZN9S20677C103v14Ev");}
S20677C10 ::~S20677C10(){ note_dtor("S20677C10", this);} // tgen
S20677C10 ::S20677C10(){ note_ctor("S20677C10", this);} // tgen

static void Test_S20677C10()
{
  extern Class_Descriptor cd_S20677C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(896,2495)];
    init_test(&cd_S20677C10, buf);
    S20677C10 *dp, &lv = *(dp=new (buf) S20677C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14320,9976), "sizeof(S20677C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C10)");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*), ABISELECT(13784,9600), "S20677C10");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*), ABISELECT(13784,9600), "S20677C10");
    check_base_class_offset(lv, (S20677C3*)(S20677C2*), ABISELECT(13784,9600), "S20677C10");
    check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(13784,9600), "S20677C10");
    /*is_ambiguous_... S20677C10::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(13784,9600), "S20677C10");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*), ABISELECT(13376,9308), "S20677C10");
    check_base_class_offset(lv, (S20677C4*)(S20677C11*), ABISELECT(13376,9308), "S20677C10");
    check_base_class_offset(lv, (S20677C4*)(S20677C2*), ABISELECT(13376,9308), "S20677C10");
    check_base_class_offset(lv, (S20677C2*)(S20677C11*), ABISELECT(13832,9640), "S20677C10");
    check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(14176,9876), "S20677C10");
    check_base_class_offset(lv, (S20677C12*)(S20677C11*), ABISELECT(13936,9712), "S20677C10");
    check_base_class_offset(lv, (S20677C11*), 0, "S20677C10");
    check_field_offset(lv, s20677c10f0, ABISELECT(1084,752), "S20677C10.s20677c10f0");
    check_field_offset(lv, s20677c10f1, ABISELECT(1092,760), "S20677C10.s20677c10f1");
    check_field_offset(lv, s20677c10f2, ABISELECT(1093,761), "S20677C10.s20677c10f2");
    check_field_offset(lv, s20677c10f3, ABISELECT(1094,762), "S20677C10.s20677c10f3");
    check_field_offset(lv, s20677c10f4, ABISELECT(1095,763), "S20677C10.s20677c10f4");
    check_field_offset(lv, s20677c10f5, ABISELECT(1096,764), "S20677C10.s20677c10f5");
    check_field_offset(lv, s20677c10f6, ABISELECT(1104,768), "S20677C10.s20677c10f6");
    check_field_offset(lv, s20677c10f7, ABISELECT(3392,2364), "S20677C10.s20677c10f7");
    check_field_offset(lv, s20677c10f8, ABISELECT(3424,2380), "S20677C10.s20677c10f8");
    check_field_offset(lv, s20677c10f9, ABISELECT(3440,2384), "S20677C10.s20677c10f9");
    check_field_offset(lv, s20677c10f10, ABISELECT(13360,9304), "S20677C10.s20677c10f10");
    check_field_offset(lv, s20677c10f11, ABISELECT(13361,9305), "S20677C10.s20677c10f11");
    test_class_info(&lv, &cd_S20677C10);
    dp->~S20677C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C10(Test_S20677C10, "S20677C10", ABISELECT(14320,9976));

#else // __cplusplus

extern void _ZN9S20677C10C1Ev();
extern void _ZN9S20677C10D1Ev();
Name_Map name_map_S20677C10[] = {
  NSPAIR(_ZN9S20677C10C1Ev),
  NSPAIR(_ZN9S20677C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C2;
extern VTBL_ENTRY _ZTI8S20677C2[];
extern  VTBL_ENTRY _ZTV8S20677C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C2[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C11;
extern VTBL_ENTRY _ZTI9S20677C11[];
extern  VTBL_ENTRY _ZTV9S20677C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C11[];
static Base_Class bases_S20677C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(13784,9600), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(13376,9308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(13376,9308), //bcp->offset
    10, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20677C2,    ABISELECT(13832,9640), //bcp->offset
    19, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(14176,9876), //bcp->offset
    37, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20677C12,    ABISELECT(13936,9712), //bcp->offset
    29, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20677C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C10[];
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN9S20677C103v14Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY vtc_S20677C10[] = {
  ABISELECT(14176,9876),
  ABISELECT(13936,9712),
  ABISELECT(13832,9640),
  ABISELECT(13784,9600),
  ABISELECT(13376,9308),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20677C103v14Ev,
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-13376,-9308),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-13832,-9640),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-13936,-9712),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  ABISELECT(-392,-276),
  ABISELECT(-14176,-9876),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
};
extern VTBL_ENTRY _ZTV9S20677C10[];
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C11__9S20677C10[] = {
  ABISELECT(14176,9876),
  ABISELECT(13936,9712),
  ABISELECT(13832,9640),
  ABISELECT(13784,9600),
  ABISELECT(13376,9308),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C11__9S20677C10[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-13376,-9308),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C11__9S20677C10[] = {
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-13832,-9640),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C11__9S20677C10[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-13936,-9712),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C11__9S20677C10[] = {
  ABISELECT(-392,-276),
  ABISELECT(-14176,-9876),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C10[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C4__9S20677C10[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C10[] = {
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__8S20677C2__9S20677C10[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(456,332),
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C10[] = {
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__9S20677C10[] = {
  ABISELECT(-392,-276),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C10[] = {
  ABISELECT(-392,-276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C10[] = {
  {&(_ZTV9S20677C10[7]),  7,40},
  {&(_tg__ZTV9S20677C11__9S20677C10[7]),  7,9},
  {&(_tg__ZTV8S20677C4__9S20677C11__9S20677C10[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C11__9S20677C10[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C11__9S20677C10[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C11__9S20677C10[3]),  3,3},
  {&(_ZTV9S20677C10[16]),  16,40},
  {&(_ZTV9S20677C10[26]),  26,40},
  {&(_ZTV9S20677C10[35]),  35,40},
  {&(_ZTV9S20677C10[40]),  40,40},
  {&(_tg__ZTV8S20677C4__9S20677C10[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C4__9S20677C10[3]),  3,3},
  {&(_tg__ZTV8S20677C2__9S20677C10[4]),  4,7},
  {&(_tg__ZTV8S20677C4__8S20677C2__9S20677C10[6]),  6,9},
  {&(_tg__ZTV9S20677C12__9S20677C10[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__9S20677C10[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A1__9S20677C10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20677C10[];
extern  VTBL_ENTRY _ZTV9S20677C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C10[];
Class_Descriptor cd_S20677C10 = {  "S20677C10", // class name
  bases_S20677C10, 7,
  &(vtc_S20677C10[0]), // expected_vtbl_contents
  &(vtt_S20677C10[0]), // expected_vtt_contents
  ABISELECT(14320,9976), // object size
  NSPAIRA(_ZTI9S20677C10),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S20677C10),40, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C10),17, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C19  : S20677C9 , S20677C12 , virtual S20677C15 {
  void *s20677c19f0;
  char s20677c19f1[4];
  ::S20677C4 s20677c19f2;
  int s20677c19f3[8];
  ::S20677C6_nt s20677c19f4;
  ::S20677C7 s20677c19f5;
  ::S20677C6_nt s20677c19f6;
  long double s20677c19f7;
  ::S20677C5 s20677c19f8[9];
  long double s20677c19f9[10];
  short s20677c19f10;
  virtual void  v17(); // _ZN9S20677C193v17Ev
  virtual void  v18(); // _ZN9S20677C193v18Ev
  virtual void  v19(); // _ZN9S20677C193v19Ev
  virtual void  v20(); // _ZN9S20677C193v20Ev
  ~S20677C19(); // tgen
  S20677C19(); // tgen
};
//SIG(-1 S20677C19) C1{ BC2{ BC3{ m Fp FL[4] Fs} FC3 Fi FD Fi FL Fl} BC4{ VBC3 VBC5{ VBC3 FD Fi FC3 FC3} v5 v6 Fi FC5 FL Fi Fp} VBC6{ BC7{ VBC3 BC5 v7 v8 v9 Fs FL Fc Fi[2] FC5 Fp FL Fi FL Fi} VBC4 BC5 VBC8{ v10 FC9{} FC5 FC9 FL FC9 Fp FC9 Fp[2] FC9} VBC10{ BC5 v11 FL Fc[7] Fp Fi FC9 FC9 Fc[10]} v12 Fl FL FD FC9} v1 v2 v3 v4 Fp Fc[4] FC7 Fi[8] FC9 FC11{ VBC8 BC5 BC2 v13 Fp FC2 Fp Fi[2] FD Fi[2]} FC9 FD FC5[9] FD[10] Fs}


void  S20677C19 ::v17(){vfunc_called(this, "_ZN9S20677C193v17Ev");}
void  S20677C19 ::v18(){vfunc_called(this, "_ZN9S20677C193v18Ev");}
void  S20677C19 ::v19(){vfunc_called(this, "_ZN9S20677C193v19Ev");}
void  S20677C19 ::v20(){vfunc_called(this, "_ZN9S20677C193v20Ev");}
S20677C19 ::~S20677C19(){ note_dtor("S20677C19", this);} // tgen
S20677C19 ::S20677C19(){ note_ctor("S20677C19", this);} // tgen

static void Test_S20677C19()
{
  extern Class_Descriptor cd_S20677C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(325,921)];
    init_test(&cd_S20677C19, buf);
    S20677C19 *dp, &lv = *(dp=new (buf) S20677C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5184,3680), "sizeof(S20677C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C19)");
    check_base_class_offset(lv, (S20677C3*)(S20677C9*), ABISELECT(240,164), "S20677C19");
    check_base_class_offset(lv, (S20677C9*), ABISELECT(240,164), "S20677C19");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(3688,2636), "S20677C19");
    /*is_ambiguous_... S20677C19::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(3688,2636), "S20677C19");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*)(S20677C15*), ABISELECT(3688,2636), "S20677C19");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*)(S20677C15*), ABISELECT(3688,2636), "S20677C19");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(3688,2636), "S20677C19");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C15*), ABISELECT(3688,2636), "S20677C19");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C16*), ABISELECT(3688,2636), "S20677C19");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(3744,2676), "S20677C19");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(3744,2676), "S20677C19");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C12*), 0, "S20677C19");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*)(S20677C15*), ABISELECT(3888,2776), "S20677C19");
    check_base_class_offset(lv, (S20677C4*)(S20677C15*), ABISELECT(3888,2776), "S20677C19");
    check_base_class_offset(lv, (S20677C12*)(S20677C15*), ABISELECT(4496,3196), "S20677C19");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C15*), ABISELECT(4304,3068), "S20677C19");
    check_base_class_offset(lv, (S20677C8*)(S20677C15*), ABISELECT(4736,3360), "S20677C19");
    check_base_class_offset(lv, (S20677C5*)(S20677C16*), ABISELECT(5008,3544), "S20677C19");
    check_base_class_offset(lv, (S20677C16*)(S20677C15*), ABISELECT(5008,3544), "S20677C19");
    check_base_class_offset(lv, (S20677C15*), ABISELECT(3888,2776), "S20677C19");
    check_field_offset(lv, s20677c19f0, ABISELECT(392,276), "S20677C19.s20677c19f0");
    check_field_offset(lv, s20677c19f1, ABISELECT(400,280), "S20677C19.s20677c19f1");
    check_field_offset(lv, s20677c19f2, ABISELECT(416,284), "S20677C19.s20677c19f2");
    check_field_offset(lv, s20677c19f3, ABISELECT(880,616), "S20677C19.s20677c19f3");
    check_field_offset(lv, s20677c19f4, ABISELECT(912,648), "S20677C19.s20677c19f4");
    check_field_offset(lv, s20677c19f5, ABISELECT(928,652), "S20677C19.s20677c19f5");
    check_field_offset(lv, s20677c19f6, ABISELECT(1760,1236), "S20677C19.s20677c19f6");
    check_field_offset(lv, s20677c19f7, ABISELECT(1776,1240), "S20677C19.s20677c19f7");
    check_field_offset(lv, s20677c19f8, ABISELECT(1792,1252), "S20677C19.s20677c19f8");
    check_field_offset(lv, s20677c19f9, ABISELECT(3520,2512), "S20677C19.s20677c19f9");
    check_field_offset(lv, s20677c19f10, ABISELECT(3680,2632), "S20677C19.s20677c19f10");
    test_class_info(&lv, &cd_S20677C19);
    dp->~S20677C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C19(Test_S20677C19, "S20677C19", ABISELECT(5184,3680));

#else // __cplusplus

extern void _ZN9S20677C19C1Ev();
extern void _ZN9S20677C19D1Ev();
Name_Map name_map_S20677C19[] = {
  NSPAIR(_ZN9S20677C19C1Ev),
  NSPAIR(_ZN9S20677C19D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C9;
extern VTBL_ENTRY _ZTI8S20677C9[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C8;
extern VTBL_ENTRY _ZTI8S20677C8[];
extern  VTBL_ENTRY _ZTV8S20677C8[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C16;
extern VTBL_ENTRY _ZTI9S20677C16[];
extern  VTBL_ENTRY _ZTV9S20677C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C16[];
extern Class_Descriptor cd_S20677C15;
extern VTBL_ENTRY _ZTI9S20677C15[];
extern  VTBL_ENTRY _ZTV9S20677C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C15[];
static Base_Class bases_S20677C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(240,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20677C9,    ABISELECT(240,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C3,    ABISELECT(3688,2636), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(3744,2676), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20677C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C5,    ABISELECT(3888,2776), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(3888,2776), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20677C12,    ABISELECT(4496,3196), //bcp->offset
    35, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(4304,3068), //bcp->offset
    32, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20677C8,    ABISELECT(4736,3360), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(5008,3544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20677C16,    ABISELECT(5008,3544), //bcp->offset
    47, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20677C15,    ABISELECT(3888,2776), //bcp->offset
    17, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C19[];
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN9S20677C193v17Ev();
extern void _ZN9S20677C193v18Ev();
extern void _ZN9S20677C193v19Ev();
extern void _ZN9S20677C193v20Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN8S20677C82v8Ev();
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY vtc_S20677C19[] = {
  ABISELECT(5008,3544),
  ABISELECT(4736,3360),
  ABISELECT(4496,3196),
  ABISELECT(3888,2776),
  ABISELECT(3744,2676),
  ABISELECT(3688,2636),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v20Ev,
  ABISELECT(-56,-40),
  ABISELECT(-3744,-2676),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  0,
  0,
  0,
  0,
  ABISELECT(1120,768),
  ABISELECT(848,584),
  ABISELECT(-144,-100),
  ABISELECT(608,420),
  ABISELECT(-200,-140),
  ABISELECT(-3888,-2776),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
  ABISELECT(-616,-432),
  ABISELECT(-4304,-3068),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  0,
  0,
  ABISELECT(-752,-520),
  ABISELECT(-808,-560),
  ABISELECT(-4496,-3196),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  0,
  ABISELECT(-4736,-3360),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
  0,
  ABISELECT(-1320,-908),
  ABISELECT(-5008,-3544),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern VTBL_ENTRY _ZTV9S20677C19[];
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__A__9S20677C19[] = {
  ABISELECT(3744,2676),
  ABISELECT(3688,2636),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__A__9S20677C19[] = {
  ABISELECT(-56,-40),
  ABISELECT(-3744,-2676),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C19[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C15__9S20677C19[] = {
  ABISELECT(1120,768),
  ABISELECT(848,584),
  ABISELECT(-144,-100),
  ABISELECT(608,420),
  ABISELECT(-200,-140),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C49S20677C15__9S20677C19[] = {
  ABISELECT(-200,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C49S20677C15__A1__9S20677C19[] = {
  ABISELECT(-200,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C15__A2__9S20677C19[] = {
  ABISELECT(-616,-432),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C15__9S20677C19[] = {
  0,
  0,
  ABISELECT(-752,-520),
  ABISELECT(-808,-560),
  ABISELECT(-608,-420),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C15__9S20677C19[] = {
  ABISELECT(-56,-40),
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A__9S20677C15__9S20677C19[] = {
  ABISELECT(-616,-432),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
};
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C8__9S20677C15__9S20677C19[] = {
  0,
  ABISELECT(-848,-584),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C15__9S20677C19[] = {
  0,
  ABISELECT(-1320,-908),
  ABISELECT(-1120,-768),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__A1__9S20677C19[] = {
  ABISELECT(-752,-520),
  ABISELECT(-808,-560),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__A1__9S20677C19[] = {
  ABISELECT(-56,-40),
  ABISELECT(752,520),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C19[] = {
  ABISELECT(-1320,-908),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C16[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C16__A3__9S20677C19[] = {
  ABISELECT(-1320,-908),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C19[] = {
  {&(_ZTV9S20677C19[8]),  8,52},
  {&(_tg__ZTV9S20677C12__A__9S20677C19[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__A__9S20677C19[3]),  3,3},
  {&(_ZTV9S20677C19[17]),  17,52},
  {&(_ZTV9S20677C19[28]),  28,52},
  {&(_ZTV9S20677C19[41]),  41,52},
  {&(_ZTV9S20677C19[35]),  35,52},
  {&(_ZTV9S20677C19[46]),  46,52},
  {&(_ZTV9S20677C19[51]),  51,52},
  {&(_tg__ZTV8S20677C5__9S20677C19[3]),  3,3},
  {&(_tg__ZTV9S20677C15__9S20677C19[7]),  7,11},
  {&(_tg__ZTV8S20677C49S20677C15__9S20677C19[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C49S20677C15__A1__9S20677C19[3]),  3,3},
  {&(_tg__ZTV8S20677C59S20677C15__A2__9S20677C19[3]),  3,3},
  {&(_tg__ZTV9S20677C12__9S20677C15__9S20677C19[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C15__9S20677C19[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A__9S20677C15__9S20677C19[3]),  3,3},
  {&(_tg__ZTV8S20677C8__9S20677C15__9S20677C19[3]),  3,4},
  {&(_tg__ZTV9S20677C16__9S20677C15__9S20677C19[4]),  4,5},
  {&(_tg__ZTV9S20677C12__A1__9S20677C19[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__A1__9S20677C19[3]),  3,3},
  {&(_tg__ZTV9S20677C16__9S20677C19[3]),  3,4},
  {&(_tg__ZTV8S20677C59S20677C16__A3__9S20677C19[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20677C19[];
extern  VTBL_ENTRY _ZTV9S20677C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C19[];
Class_Descriptor cd_S20677C19 = {  "S20677C19", // class name
  bases_S20677C19, 13,
  &(vtc_S20677C19[0]), // expected_vtbl_contents
  &(vtt_S20677C19[0]), // expected_vtt_contents
  ABISELECT(5184,3680), // object size
  NSPAIRA(_ZTI9S20677C19),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20677C19),52, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C19),23, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C20  : S20677C13 {
  int s20677c20f0;
  ::S20677C6_nt s20677c20f1;
  short s20677c20f2;
  long s20677c20f3;
  ::S20677C5 s20677c20f4;
  long s20677c20f5;
  virtual void  v23(); // _ZN9S20677C203v23Ev
  ~S20677C20(); // tgen
  S20677C20(); // tgen
};
//SIG(-1 S20677C20) C1{ BC2{ VBC3{ VBC4{ m Fp FL[4] Fs} FD Fi FC4 FC4} BC5{ VBC6{ VBC4 BC3 v2 v3 v4 Fs FL Fc Fi[2] FC3 Fp FL Fi FL Fi} VBC7{ VBC4 VBC6 v5 v6 v7 FL FC8{} Fp Fc[2] FC4 Fl FC8} VBC9{ VBC4 VBC3 v8 v9 Fi FC3 FL Fi Fp} v10 v11 FC8 FC8 Fi FC3 FC8 FC8 FC10{ v12 FC8 FC3 FC8 FL FC8 Fp FC8 Fp[2] FC8} FC7 Fp FC8} BC9 Fi Fc:2 FC8 Fi} v1 Fi FC8 Fs Fl FC3 Fl}


void  S20677C20 ::v23(){vfunc_called(this, "_ZN9S20677C203v23Ev");}
S20677C20 ::~S20677C20(){ note_dtor("S20677C20", this);} // tgen
S20677C20 ::S20677C20(){ note_ctor("S20677C20", this);} // tgen

static void Test_S20677C20()
{
  extern Class_Descriptor cd_S20677C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(158,439)];
    init_test(&cd_S20677C20, buf);
    S20677C20 *dp, &lv = *(dp=new (buf) S20677C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2512,1752), "sizeof(S20677C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C20)");
    /*is_ambiguous_... S20677C20::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(1704,1184), "S20677C20");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*), ABISELECT(1704,1184), "S20677C20");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*), ABISELECT(1704,1184), "S20677C20");
    check_base_class_offset(lv, (S20677C3*)(S20677C2*), ABISELECT(1704,1184), "S20677C20");
    /*is_ambiguous_... S20677C20::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(1704,1184), "S20677C20");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*)(S20677C13*), ABISELECT(1704,1184), "S20677C20");
    /*is_ambiguous_... S20677C13::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C13*), ABISELECT(1568,1084), "S20677C20");
    /*is_ambiguous_... S20677C20::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(1568,1084), "S20677C20");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*)(S20677C13*), ABISELECT(1568,1084), "S20677C20");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*), ABISELECT(1760,1224), "S20677C20");
    check_base_class_offset(lv, (S20677C4*)(S20677C11*)(S20677C13*), ABISELECT(1760,1224), "S20677C20");
    check_base_class_offset(lv, (S20677C4*)(S20677C2*), ABISELECT(1760,1224), "S20677C20");
    check_base_class_offset(lv, (S20677C2*)(S20677C11*)(S20677C13*), ABISELECT(2168,1516), "S20677C20");
    check_base_class_offset(lv, (S20677C12*)(S20677C11*)(S20677C13*), ABISELECT(2272,1588), "S20677C20");
    check_base_class_offset(lv, (S20677C11*)(S20677C13*), 0, "S20677C20");
    /*is_ambiguous_... S20677C13::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C12*)(S20677C13*), ABISELECT(1088,752), "S20677C20");
    check_base_class_offset(lv, (S20677C13*), 0, "S20677C20");
    check_field_offset(lv, s20677c20f0, ABISELECT(1332,928), "S20677C20.s20677c20f0");
    check_field_offset(lv, s20677c20f1, ABISELECT(1336,932), "S20677C20.s20677c20f1");
    check_field_offset(lv, s20677c20f2, ABISELECT(1338,934), "S20677C20.s20677c20f2");
    check_field_offset(lv, s20677c20f3, ABISELECT(1344,936), "S20677C20.s20677c20f3");
    check_field_offset(lv, s20677c20f4, ABISELECT(1360,940), "S20677C20.s20677c20f4");
    check_field_offset(lv, s20677c20f5, ABISELECT(1552,1080), "S20677C20.s20677c20f5");
    test_class_info(&lv, &cd_S20677C20);
    dp->~S20677C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C20(Test_S20677C20, "S20677C20", ABISELECT(2512,1752));

#else // __cplusplus

extern void _ZN9S20677C20C1Ev();
extern void _ZN9S20677C20D1Ev();
Name_Map name_map_S20677C20[] = {
  NSPAIR(_ZN9S20677C20C1Ev),
  NSPAIR(_ZN9S20677C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C2;
extern VTBL_ENTRY _ZTI8S20677C2[];
extern  VTBL_ENTRY _ZTV8S20677C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C2[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C11;
extern VTBL_ENTRY _ZTI9S20677C11[];
extern  VTBL_ENTRY _ZTV9S20677C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C11[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C13;
extern VTBL_ENTRY _ZTI9S20677C13[];
extern  VTBL_ENTRY _ZTV9S20677C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C13[];
static Base_Class bases_S20677C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(1704,1184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(1568,1084), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(1760,1224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(1760,1224), //bcp->offset
    19, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20677C2,    ABISELECT(2168,1516), //bcp->offset
    28, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20677C12,    ABISELECT(2272,1588), //bcp->offset
    38, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20677C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20677C12,    ABISELECT(1088,752), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20677C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C20[];
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN9S20677C203v23Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY vtc_S20677C20[] = {
  ABISELECT(1568,1084),
  ABISELECT(2272,1588),
  ABISELECT(2168,1516),
  ABISELECT(1704,1184),
  ABISELECT(1760,1224),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C20[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20677C203v23Ev,
  ABISELECT(480,332),
  ABISELECT(616,432),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20677C20[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  ABISELECT(136,100),
  ABISELECT(-1568,-1084),
  (VTBL_ENTRY)&(_ZTI9S20677C20[0]),
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-1760,-1224),
  (VTBL_ENTRY)&(_ZTI9S20677C20[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  ABISELECT(-2168,-1516),
  (VTBL_ENTRY)&(_ZTI9S20677C20[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
  0,
  0,
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  ABISELECT(-2272,-1588),
  (VTBL_ENTRY)&(_ZTI9S20677C20[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
extern VTBL_ENTRY _ZTV9S20677C20[];
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C13__9S20677C20[] = {
  ABISELECT(1568,1084),
  ABISELECT(2272,1588),
  ABISELECT(2168,1516),
  ABISELECT(1704,1184),
  ABISELECT(1760,1224),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C119S20677C13__9S20677C20[] = {
  ABISELECT(1568,1084),
  ABISELECT(2272,1588),
  ABISELECT(2168,1516),
  ABISELECT(1704,1184),
  ABISELECT(1760,1224),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C119S20677C13__9S20677C20[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-1760,-1224),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C119S20677C13__9S20677C20[] = {
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  ABISELECT(-2168,-1516),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C119S20677C13__9S20677C20[] = {
  0,
  0,
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  ABISELECT(-2272,-1588),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C119S20677C13__9S20677C20[] = {
  ABISELECT(136,100),
  ABISELECT(-1568,-1084),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C129S20677C13__A1__9S20677C20[] = {
  ABISELECT(480,332),
  ABISELECT(616,432),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C129S20677C13__A1__9S20677C20[] = {
  ABISELECT(136,100),
  ABISELECT(-480,-332),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C13__9S20677C20[] = {
  ABISELECT(136,100),
  ABISELECT(-1568,-1084),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C13__9S20677C20[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-1760,-1224),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C13__9S20677C20[] = {
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  ABISELECT(-2168,-1516),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C13__9S20677C20[] = {
  0,
  0,
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  ABISELECT(-2272,-1588),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__A__9S20677C13__9S20677C20[] = {
  ABISELECT(480,332),
  ABISELECT(616,432),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20677C13[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C20[] = {
  ABISELECT(136,100),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C20[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C4__A1__9S20677C20[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C20[] = {
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__8S20677C2__9S20677C20[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(408,292),
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C20[] = {
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__9S20677C20[] = {
  ABISELECT(136,100),
  ABISELECT(704,504),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTT_ENTRY vtt_S20677C20[] = {
  {&(_ZTV9S20677C20[7]),  7,46},
  {&(_tg__ZTV9S20677C13__9S20677C20[7]),  7,9},
  {&(_tg__ZTV9S20677C119S20677C13__9S20677C20[7]),  7,9},
  {&(_tg__ZTV8S20677C4__9S20677C119S20677C13__9S20677C20[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C119S20677C13__9S20677C20[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C119S20677C13__9S20677C20[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C119S20677C13__9S20677C20[3]),  3,3},
  {&(_tg__ZTV9S20677C129S20677C13__A1__9S20677C20[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C129S20677C13__A1__9S20677C20[3]),  3,3},
  {&(_tg__ZTV8S20677C5__9S20677C13__9S20677C20[3]),  3,3},
  {&(_tg__ZTV8S20677C4__9S20677C13__9S20677C20[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C13__9S20677C20[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C13__9S20677C20[6]),  6,8},
  {&(_tg__ZTV9S20677C12__A__9S20677C13__9S20677C20[4]),  4,6},
  {&(_ZTV9S20677C20[19]),  19,46},
  {&(_ZTV9S20677C20[25]),  25,46},
  {&(_ZTV9S20677C20[35]),  35,46},
  {&(_ZTV9S20677C20[44]),  44,46},
  {&(_ZTV9S20677C20[14]),  14,46},
  {&(_tg__ZTV8S20677C5__9S20677C20[3]),  3,3},
  {&(_tg__ZTV8S20677C4__9S20677C20[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C4__A1__9S20677C20[3]),  3,3},
  {&(_tg__ZTV8S20677C2__9S20677C20[4]),  4,7},
  {&(_tg__ZTV8S20677C4__8S20677C2__9S20677C20[6]),  6,9},
  {&(_tg__ZTV9S20677C12__9S20677C20[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__9S20677C20[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20677C20[];
extern  VTBL_ENTRY _ZTV9S20677C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C20[];
Class_Descriptor cd_S20677C20 = {  "S20677C20", // class name
  bases_S20677C20, 9,
  &(vtc_S20677C20[0]), // expected_vtbl_contents
  &(vtt_S20677C20[0]), // expected_vtt_contents
  ABISELECT(2512,1752), // object size
  NSPAIRA(_ZTI9S20677C20),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S20677C20),46, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C20),26, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C21  {
  long s20677c21f0;
  ::S20677C16 s20677c21f1;
  ::S20677C6_nt s20677c21f2;
  int s20677c21f3;
  virtual void  v24(); // _ZN9S20677C213v24Ev
  ~S20677C21(); // tgen
  S20677C21(); // tgen
};
//SIG(-1 S20677C21) C1{ v1 Fl FC2{ BC3{ VBC4{ m Fp FL[4] Fs} FD Fi FC4 FC4} v2 FL Fc[7] Fp Fi FC5{} FC5 Fc[10]} FC5 Fi}


void  S20677C21 ::v24(){vfunc_called(this, "_ZN9S20677C213v24Ev");}
S20677C21 ::~S20677C21(){ note_dtor("S20677C21", this);} // tgen
S20677C21 ::S20677C21(){ note_ctor("S20677C21", this);} // tgen

static void Test_S20677C21()
{
  extern Class_Descriptor cd_S20677C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(17,49)];
    init_test(&cd_S20677C21, buf);
    S20677C21 *dp, &lv = *(dp=new (buf) S20677C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,192), "sizeof(S20677C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C21)");
    check_field_offset(lv, s20677c21f0, ABISELECT(8,4), "S20677C21.s20677c21f0");
    check_field_offset(lv, s20677c21f1, ABISELECT(16,8), "S20677C21.s20677c21f1");
    check_field_offset(lv, s20677c21f2, ABISELECT(240,184), "S20677C21.s20677c21f2");
    check_field_offset(lv, s20677c21f3, ABISELECT(244,188), "S20677C21.s20677c21f3");
    test_class_info(&lv, &cd_S20677C21);
    dp->~S20677C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C21(Test_S20677C21, "S20677C21", ABISELECT(256,192));

#else // __cplusplus

extern void _ZN9S20677C21C1Ev();
extern void _ZN9S20677C21D1Ev();
Name_Map name_map_S20677C21[] = {
  NSPAIR(_ZN9S20677C21C1Ev),
  NSPAIR(_ZN9S20677C21D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20677C21[];
extern void _ZN9S20677C213v24Ev();
static  VTBL_ENTRY vtc_S20677C21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C21[0]),
  (VTBL_ENTRY)&_ZN9S20677C213v24Ev,
};
extern VTBL_ENTRY _ZTI9S20677C21[];
extern  VTBL_ENTRY _ZTV9S20677C21[];
Class_Descriptor cd_S20677C21 = {  "S20677C21", // class name
  0,0,//no base classes
  &(vtc_S20677C21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,192), // object size
  NSPAIRA(_ZTI9S20677C21),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20677C21),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C18  : virtual S20677C11 , virtual S20677C19 {
  void *s20677c18f0;
  ::S20677C20 s20677c18f1;
  void *s20677c18f2;
  __tsi64 s20677c18f3;
  int s20677c18f4;
  ::S20677C6_nt s20677c18f5;
  void *s20677c18f6;
  ::S20677C21 s20677c18f7;
  long s20677c18f8;
  virtual void  v21(); // _ZN9S20677C183v21Ev
  ~S20677C18(); // tgen
  S20677C18(); // tgen
};
//SIG(-1 S20677C18) C1{ VBC2{ VBC3{ VBC4{ m Fp FL[4] Fs} BC5{ VBC4 FD Fi FC4 FC4} v2 v3 v4 Fs FL Fc Fi[2] FC5 Fp FL Fi FL Fi} VBC6{ VBC4 VBC3 v5 v6 v7 FL FC7{} Fp Fc[2] FC4 Fl FC7} VBC8{ VBC4 VBC5 v8 v9 Fi FC5 FL Fi Fp} v10 v11 FC7 FC7 Fi FC5 FC7 FC7 FC9{ v12 FC7 FC5 FC7 FL FC7 Fp FC7 Fp[2] FC7} FC6 Fp FC7} VBC10{ BC11{ BC4 FC4 Fi FD Fi FL Fl} BC8 VBC12{ BC3 VBC8 BC5 VBC9 VBC13{ BC5 v13 FL Fc[7] Fp Fi FC7 FC7 Fc[10]} v14 Fl FL FD FC7} v15 v16 v17 v18 Fp Fc[4] FC3 Fi[8] FC7 FC14{ VBC9 BC5 BC11 v21 Fp FC11 Fp Fi[2] FD Fi[2]} FC7 FD FC5[9] FD[10] Fs} v1 Fp FC15{ BC16{ VBC5 BC2 BC8 Fi Fc:2 FC7 Fi} v19 Fi FC7 Fs Fl FC5 Fl} Fp FL Fi FC7 Fp FC17{ v20 Fl FC13 FC7 Fi} Fl}


void  S20677C18 ::v21(){vfunc_called(this, "_ZN9S20677C183v21Ev");}
S20677C18 ::~S20677C18(){ note_dtor("S20677C18", this);} // tgen
S20677C18 ::S20677C18(){ note_ctor("S20677C18", this);} // tgen

static void Test_S20677C18()
{
  extern Class_Descriptor cd_S20677C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(602,1695)];
    init_test(&cd_S20677C18, buf);
    S20677C18 *dp, &lv = *(dp=new (buf) S20677C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(9616,6776), "sizeof(S20677C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C18)");
    /*is_ambiguous_... S20677C18::S20677C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C4*), ABISELECT(4328,3024), "S20677C18");
    /*is_ambiguous_... S20677C18::S20677C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*), ABISELECT(4328,3024), "S20677C18");
    check_base_class_offset(lv, (S20677C3*)(S20677C2*), ABISELECT(4328,3024), "S20677C18");
    /*is_ambiguous_... S20677C18::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(4328,3024), "S20677C18");
    /*is_ambiguous_... S20677C18::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(4328,3024), "S20677C18");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*)(S20677C19*), ABISELECT(4328,3024), "S20677C18");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*)(S20677C15*), ABISELECT(4328,3024), "S20677C18");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*)(S20677C15*), ABISELECT(4328,3024), "S20677C18");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C15*), ABISELECT(4328,3024), "S20677C18");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C16*), ABISELECT(4328,3024), "S20677C18");
    /*is_ambiguous_... S20677C18::S20677C4 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C4*), ABISELECT(3920,2732), "S20677C18");
    check_base_class_offset(lv, (S20677C4*)(S20677C11*), ABISELECT(3920,2732), "S20677C18");
    check_base_class_offset(lv, (S20677C4*)(S20677C2*), ABISELECT(3920,2732), "S20677C18");
    check_base_class_offset(lv, (S20677C2*)(S20677C11*), ABISELECT(4376,3064), "S20677C18");
    /*is_ambiguous_... S20677C18::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(4720,3300), "S20677C18");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*)(S20677C19*), ABISELECT(4720,3300), "S20677C18");
    check_base_class_offset(lv, (S20677C12*)(S20677C11*), ABISELECT(4480,3136), "S20677C18");
    check_base_class_offset(lv, (S20677C12*)(S20677C15*), ABISELECT(4480,3136), "S20677C18");
    check_base_class_offset(lv, (S20677C11*), ABISELECT(2832,1980), "S20677C18");
    check_base_class_offset(lv, (S20677C3*)(S20677C9*)(S20677C19*), ABISELECT(5104,3564), "S20677C18");
    check_base_class_offset(lv, (S20677C9*)(S20677C19*), ABISELECT(5104,3564), "S20677C18");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C12*)(S20677C19*), ABISELECT(4864,3400), "S20677C18");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*)(S20677C15*), ABISELECT(8560,6036), "S20677C18");
    check_base_class_offset(lv, (S20677C4*)(S20677C15*), ABISELECT(8560,6036), "S20677C18");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C15*), ABISELECT(8976,6328), "S20677C18");
    check_base_class_offset(lv, (S20677C8*)(S20677C15*), ABISELECT(9168,6456), "S20677C18");
    check_base_class_offset(lv, (S20677C5*)(S20677C16*), ABISELECT(9440,6640), "S20677C18");
    check_base_class_offset(lv, (S20677C16*)(S20677C15*), ABISELECT(9440,6640), "S20677C18");
    check_base_class_offset(lv, (S20677C15*)(S20677C19*), ABISELECT(8560,6036), "S20677C18");
    check_base_class_offset(lv, (S20677C19*), ABISELECT(4864,3400), "S20677C18");
    check_field_offset(lv, s20677c18f0, ABISELECT(8,4), "S20677C18.s20677c18f0");
    check_field_offset(lv, s20677c18f1, ABISELECT(16,8), "S20677C18.s20677c18f1");
    check_field_offset(lv, s20677c18f2, ABISELECT(2528,1760), "S20677C18.s20677c18f2");
    check_field_offset(lv, s20677c18f3, ABISELECT(2536,1764), "S20677C18.s20677c18f3");
    check_field_offset(lv, s20677c18f4, ABISELECT(2544,1772), "S20677C18.s20677c18f4");
    check_field_offset(lv, s20677c18f5, ABISELECT(2548,1776), "S20677C18.s20677c18f5");
    check_field_offset(lv, s20677c18f6, ABISELECT(2552,1780), "S20677C18.s20677c18f6");
    check_field_offset(lv, s20677c18f7, ABISELECT(2560,1784), "S20677C18.s20677c18f7");
    check_field_offset(lv, s20677c18f8, ABISELECT(2816,1976), "S20677C18.s20677c18f8");
    test_class_info(&lv, &cd_S20677C18);
    dp->~S20677C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C18(Test_S20677C18, "S20677C18", ABISELECT(9616,6776));

#else // __cplusplus

extern void _ZN9S20677C18C1Ev();
extern void _ZN9S20677C18D1Ev();
Name_Map name_map_S20677C18[] = {
  NSPAIR(_ZN9S20677C18C1Ev),
  NSPAIR(_ZN9S20677C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C2;
extern VTBL_ENTRY _ZTI8S20677C2[];
extern  VTBL_ENTRY _ZTV8S20677C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C2[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C11;
extern VTBL_ENTRY _ZTI9S20677C11[];
extern  VTBL_ENTRY _ZTV9S20677C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C11[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C9;
extern VTBL_ENTRY _ZTI8S20677C9[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C8;
extern VTBL_ENTRY _ZTI8S20677C8[];
extern  VTBL_ENTRY _ZTV8S20677C8[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C16;
extern VTBL_ENTRY _ZTI9S20677C16[];
extern  VTBL_ENTRY _ZTV9S20677C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C16[];
extern Class_Descriptor cd_S20677C15;
extern VTBL_ENTRY _ZTI9S20677C15[];
extern  VTBL_ENTRY _ZTV9S20677C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C15[];
extern Class_Descriptor cd_S20677C19;
extern VTBL_ENTRY _ZTI9S20677C19[];
extern  VTBL_ENTRY _ZTV9S20677C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C19[];
static Base_Class bases_S20677C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(4328,3024), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(3920,2732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(3920,2732), //bcp->offset
    24, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20677C2,    ABISELECT(4376,3064), //bcp->offset
    33, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(4720,3300), //bcp->offset
    51, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20677C12,    ABISELECT(4480,3136), //bcp->offset
    43, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20677C11,    ABISELECT(2832,1980), //bcp->offset
    13, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C3,    ABISELECT(5104,3564), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20677C9,    ABISELECT(5104,3564), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20677C12,    ABISELECT(4864,3400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20677C5,    ABISELECT(8560,6036), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(8560,6036), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20677C5,    ABISELECT(8976,6328), //bcp->offset
    89, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20677C8,    ABISELECT(9168,6456), //bcp->offset
    92, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(9440,6640), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20677C16,    ABISELECT(9440,6640), //bcp->offset
    96, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S20677C15,    ABISELECT(8560,6036), //bcp->offset
    74, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S20677C19,    ABISELECT(4864,3400), //bcp->offset
    54, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C18[];
extern void _ZN9S20677C183v21Ev();
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN9S20677C193v17Ev();
extern void _ZN9S20677C193v18Ev();
extern void _ZN9S20677C193v19Ev();
extern void _ZN9S20677C193v20Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
extern void _ZN8S20677C82v8Ev();
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY vtc_S20677C18[] = {
  ABISELECT(9440,6640),
  ABISELECT(9168,6456),
  ABISELECT(8560,6036),
  ABISELECT(4864,3400),
  ABISELECT(4720,3300),
  ABISELECT(4480,3136),
  ABISELECT(4376,3064),
  ABISELECT(4328,3024),
  ABISELECT(3920,2732),
  ABISELECT(2832,1980),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN9S20677C183v21Ev,
  0,
  0,
  ABISELECT(1888,1320),
  ABISELECT(1648,1156),
  ABISELECT(1544,1084),
  ABISELECT(1496,1044),
  ABISELECT(1088,752),
  ABISELECT(-2832,-1980),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-3920,-2732),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-4376,-3064),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-4480,-3136),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  ABISELECT(-392,-276),
  ABISELECT(-4720,-3300),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(4576,3240),
  ABISELECT(4304,3056),
  ABISELECT(-384,-264),
  ABISELECT(3696,2636),
  ABISELECT(-144,-100),
  ABISELECT(-536,-376),
  ABISELECT(-4864,-3400),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v20Ev,
  0,
  0,
  0,
  0,
  ABISELECT(880,604),
  ABISELECT(608,420),
  ABISELECT(-3840,-2736),
  ABISELECT(-4080,-2900),
  ABISELECT(-4232,-3012),
  ABISELECT(-8560,-6036),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
  ABISELECT(-4648,-3304),
  ABISELECT(-8976,-6328),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  0,
  ABISELECT(-9168,-6456),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
  0,
  ABISELECT(-5112,-3616),
  ABISELECT(-9440,-6640),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern VTBL_ENTRY _ZTV9S20677C18[];
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C11__9S20677C18[] = {
  ABISELECT(1888,1320),
  ABISELECT(1648,1156),
  ABISELECT(1544,1084),
  ABISELECT(1496,1044),
  ABISELECT(1088,752),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C11__9S20677C18[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C11__9S20677C18[] = {
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-1544,-1084),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C11__9S20677C18[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-1648,-1156),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C11__9S20677C18[] = {
  ABISELECT(-392,-276),
  ABISELECT(-1888,-1320),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C18[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C4__9S20677C18[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C18[] = {
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__8S20677C2__9S20677C18[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(456,332),
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C18[] = {
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__9S20677C18[] = {
  ABISELECT(-392,-276),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C18[] = {
  ABISELECT(-392,-276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN9S20677C193v17Ev();
extern void _ZN9S20677C193v18Ev();
extern void _ZN9S20677C193v19Ev();
extern void _ZN9S20677C193v20Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C19__9S20677C18[] = {
  ABISELECT(4576,3240),
  ABISELECT(4304,3056),
  ABISELECT(-384,-264),
  ABISELECT(3696,2636),
  ABISELECT(-144,-100),
  ABISELECT(-536,-376),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v20Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C129S20677C19__A1__9S20677C18[] = {
  ABISELECT(-144,-100),
  ABISELECT(-536,-376),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C129S20677C19__A1__9S20677C18[] = {
  ABISELECT(-392,-276),
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C19__9S20677C18[] = {
  ABISELECT(-392,-276),
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C15__9S20677C19__9S20677C18[] = {
  0,
  0,
  0,
  0,
  ABISELECT(880,604),
  ABISELECT(608,420),
  ABISELECT(-3840,-2736),
  ABISELECT(-4080,-2900),
  ABISELECT(-4232,-3012),
  ABISELECT(-3696,-2636),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__A1__9S20677C19__9S20677C18[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(384,264),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C15__A2__9S20677C19__9S20677C18[] = {
  ABISELECT(-4648,-3304),
  ABISELECT(-4112,-2928),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
};
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C8__9S20677C19__9S20677C18[] = {
  0,
  ABISELECT(-4304,-3056),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C19__9S20677C18[] = {
  0,
  ABISELECT(-5112,-3616),
  ABISELECT(-4576,-3240),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C15__9S20677C18[] = {
  ABISELECT(880,604),
  ABISELECT(608,420),
  ABISELECT(-3840,-2736),
  ABISELECT(-4080,-2900),
  ABISELECT(-4232,-3012),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C49S20677C15__A1__9S20677C18[] = {
  ABISELECT(-4232,-3012),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C49S20677C15__A2__9S20677C18[] = {
  ABISELECT(-4232,-3012),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C15__A3__9S20677C18[] = {
  ABISELECT(-4648,-3304),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C15__9S20677C18[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(4080,2900),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C15__9S20677C18[] = {
  ABISELECT(-392,-276),
  ABISELECT(3840,2736),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A__9S20677C15__9S20677C18[] = {
  ABISELECT(-4648,-3304),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
};
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C8__9S20677C15__9S20677C18[] = {
  0,
  ABISELECT(-608,-420),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C15__9S20677C18[] = {
  0,
  ABISELECT(-5112,-3616),
  ABISELECT(-880,-604),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C18[] = {
  ABISELECT(-5112,-3616),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C16[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C16__A4__9S20677C18[] = {
  ABISELECT(-5112,-3616),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C18[] = {
  {&(_ZTV9S20677C18[12]),  12,101},
  {&(_ZTV9S20677C18[22]),  22,101},
  {&(_ZTV9S20677C18[30]),  30,101},
  {&(_ZTV9S20677C18[40]),  40,101},
  {&(_ZTV9S20677C18[49]),  49,101},
  {&(_ZTV9S20677C18[54]),  54,101},
  {&(_ZTV9S20677C18[68]),  68,101},
  {&(_ZTV9S20677C18[85]),  85,101},
  {&(_ZTV9S20677C18[92]),  92,101},
  {&(_ZTV9S20677C18[95]),  95,101},
  {&(_ZTV9S20677C18[100]),  100,101},
  {&(_tg__ZTV9S20677C11__9S20677C18[7]),  7,9},
  {&(_tg__ZTV8S20677C4__9S20677C11__9S20677C18[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C11__9S20677C18[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C11__9S20677C18[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C11__9S20677C18[3]),  3,3},
  {&(_tg__ZTV8S20677C4__9S20677C18[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C4__9S20677C18[3]),  3,3},
  {&(_tg__ZTV8S20677C2__9S20677C18[4]),  4,7},
  {&(_tg__ZTV8S20677C4__8S20677C2__9S20677C18[6]),  6,9},
  {&(_tg__ZTV9S20677C12__9S20677C18[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__9S20677C18[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A1__9S20677C18[3]),  3,3},
  {&(_tg__ZTV9S20677C19__9S20677C18[8]),  8,14},
  {&(_tg__ZTV9S20677C129S20677C19__A1__9S20677C18[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C129S20677C19__A1__9S20677C18[3]),  3,3},
  {&(_tg__ZTV8S20677C5__9S20677C19__9S20677C18[3]),  3,3},
  {&(_tg__ZTV9S20677C15__9S20677C19__9S20677C18[11]),  11,15},
  {&(_tg__ZTV9S20677C12__A1__9S20677C19__9S20677C18[6]),  6,8},
  {&(_tg__ZTV8S20677C59S20677C15__A2__9S20677C19__9S20677C18[3]),  3,3},
  {&(_tg__ZTV8S20677C8__9S20677C19__9S20677C18[3]),  3,4},
  {&(_tg__ZTV9S20677C16__9S20677C19__9S20677C18[4]),  4,5},
  {&(_tg__ZTV9S20677C15__9S20677C18[7]),  7,11},
  {&(_tg__ZTV8S20677C49S20677C15__A1__9S20677C18[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C49S20677C15__A2__9S20677C18[3]),  3,3},
  {&(_tg__ZTV8S20677C59S20677C15__A3__9S20677C18[3]),  3,3},
  {&(_tg__ZTV9S20677C12__9S20677C15__9S20677C18[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C15__9S20677C18[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A__9S20677C15__9S20677C18[3]),  3,3},
  {&(_tg__ZTV8S20677C8__9S20677C15__9S20677C18[3]),  3,4},
  {&(_tg__ZTV9S20677C16__9S20677C15__9S20677C18[4]),  4,5},
  {&(_tg__ZTV9S20677C16__9S20677C18[3]),  3,4},
  {&(_tg__ZTV8S20677C59S20677C16__A4__9S20677C18[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20677C18[];
extern  VTBL_ENTRY _ZTV9S20677C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C18[];
Class_Descriptor cd_S20677C18 = {  "S20677C18", // class name
  bases_S20677C18, 18,
  &(vtc_S20677C18[0]), // expected_vtbl_contents
  &(vtt_S20677C18[0]), // expected_vtt_contents
  ABISELECT(9616,6776), // object size
  NSPAIRA(_ZTI9S20677C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20677C18),101, //virtual function table var
  12, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C18),43, //virtual table table var
  15, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C22  : S20677C10 , S20677C5 , virtual S20677C11 {
  void *s20677c22f0;
  ::S20677C6_nt s20677c22f1;
  long s20677c22f2;
  virtual  ~S20677C22(); // _ZN9S20677C22D2Ev
  S20677C22(); // tgen
};
//SIG(-1 S20677C22) C1{ BC2{ BC3{ VBC4{ VBC5{ m Fp FL[4] Fs} BC6{ VBC5 FD Fi FC5 FC5} v1 v2 v3 Fs FL Fc Fi[2] FC6 Fp FL Fi FL Fi} VBC7{ VBC5 VBC4 v4 v5 v6 FL FC8{} Fp Fc[2] FC5 Fl FC8} VBC9{ VBC5 VBC6 v7 v8 Fi FC6 FL Fi Fp} v9 v10 FC8 FC8 Fi FC6 FC8 FC8 FC10{ v12 FC8 FC6 FC8 FL FC8 Fp FC8 Fp[2] FC8} FC7 Fp FC8} v11 Fi[2] FC8 FC8 FC8 FC8 FC8 FC11{ VBC6 BC3 BC9 Fi Fc:2 FC8 Fi} Fl[4] FC8 FC12{ BC13{ BC4 VBC9 BC6 VBC10 VBC14{ BC6 v13 FL Fc[7] Fp Fi FC8 FC8 Fc[10]} v14 Fl FL FD FC8} BC15{ VBC10 v15 FC13 FC8 Fl Fi[2]} BC11 Fp FL Fi Fp Fi[3] Fc FL Fp FD}[2] Fc FC8} BC6 VBC3 vd Fp FC8 Fl}


 S20677C22 ::~S20677C22(){ note_dtor("S20677C22", this);}
S20677C22 ::S20677C22(){ note_ctor("S20677C22", this);} // tgen

static void Test_S20677C22()
{
  extern Class_Descriptor cd_S20677C22;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(974,2711)];
    init_test(&cd_S20677C22, buf);
    S20677C22 *dp, &lv = *(dp=new (buf) S20677C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(15568,10840), "sizeof(S20677C22)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C22)");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*), ABISELECT(13944,9712), "S20677C22");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*), ABISELECT(13944,9712), "S20677C22");
    check_base_class_offset(lv, (S20677C3*)(S20677C2*), ABISELECT(13944,9712), "S20677C22");
    check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(13944,9712), "S20677C22");
    /*is_ambiguous_... S20677C22::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(13944,9712), "S20677C22");
    /*is_ambiguous_... S20677C22::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(13944,9712), "S20677C22");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*), ABISELECT(13536,9420), "S20677C22");
    check_base_class_offset(lv, (S20677C4*)(S20677C11*)(S20677C10*), ABISELECT(13536,9420), "S20677C22");
    check_base_class_offset(lv, (S20677C4*)(S20677C2*), ABISELECT(13536,9420), "S20677C22");
    /*is_ambiguous_... S20677C22::S20677C11 */ AMB_check_base_class_offset(lv, (S20677C4*)(S20677C11*), ABISELECT(13536,9420), "S20677C22");
    check_base_class_offset(lv, (S20677C2*)(S20677C11*)(S20677C10*), ABISELECT(13992,9752), "S20677C22");
    /*is_ambiguous_... S20677C22::S20677C11 */ AMB_check_base_class_offset(lv, (S20677C2*)(S20677C11*), ABISELECT(13992,9752), "S20677C22");
    check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(14336,9988), "S20677C22");
    check_base_class_offset(lv, (S20677C12*)(S20677C11*)(S20677C10*), ABISELECT(14096,9824), "S20677C22");
    /*is_ambiguous_... S20677C22::S20677C11 */ AMB_check_base_class_offset(lv, (S20677C12*)(S20677C11*), ABISELECT(14096,9824), "S20677C22");
    check_base_class_offset(lv, (S20677C11*)(S20677C10*), 0, "S20677C22");
    check_base_class_offset(lv, (S20677C10*), 0, "S20677C22");
    /*is_ambiguous_... S20677C22::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C5*), ABISELECT(13376,9308), "S20677C22");
    /*is_ambiguous_... S20677C22::S20677C11 */ AMB_check_base_class_offset(lv, (S20677C11*), ABISELECT(14480,10088), "S20677C22");
    check_field_offset(lv, s20677c22f0, ABISELECT(13512,9408), "S20677C22.s20677c22f0");
    check_field_offset(lv, s20677c22f1, ABISELECT(13520,9412), "S20677C22.s20677c22f1");
    check_field_offset(lv, s20677c22f2, ABISELECT(13528,9416), "S20677C22.s20677c22f2");
    test_class_info(&lv, &cd_S20677C22);
    dp->~S20677C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C22(Test_S20677C22, "S20677C22", ABISELECT(15568,10840));

#else // __cplusplus

extern void _ZN9S20677C22C1Ev();
extern void _ZN9S20677C22D2Ev();
Name_Map name_map_S20677C22[] = {
  NSPAIR(_ZN9S20677C22C1Ev),
  NSPAIR(_ZN9S20677C22D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C2;
extern VTBL_ENTRY _ZTI8S20677C2[];
extern  VTBL_ENTRY _ZTV8S20677C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C2[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C11;
extern VTBL_ENTRY _ZTI9S20677C11[];
extern  VTBL_ENTRY _ZTV9S20677C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C11[];
extern Class_Descriptor cd_S20677C10;
extern VTBL_ENTRY _ZTI9S20677C10[];
extern  VTBL_ENTRY _ZTV9S20677C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C10[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C11;
extern VTBL_ENTRY _ZTI9S20677C11[];
extern  VTBL_ENTRY _ZTV9S20677C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C11[];
static Base_Class bases_S20677C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(13944,9712), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(13536,9420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(13536,9420), //bcp->offset
    16, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20677C2,    ABISELECT(13992,9752), //bcp->offset
    25, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(14336,9988), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20677C12,    ABISELECT(14096,9824), //bcp->offset
    35, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20677C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20677C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C5,    ABISELECT(13376,9308), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C11,    ABISELECT(14480,10088), //bcp->offset
    46, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20677C22[];
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN9S20677C103v14Ev();
extern void _ZN9S20677C22D1Ev();
extern void _ZN9S20677C22D0Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY vtc_S20677C22[] = {
  ABISELECT(14480,10088),
  ABISELECT(14336,9988),
  ABISELECT(14096,9824),
  ABISELECT(13992,9752),
  ABISELECT(13944,9712),
  ABISELECT(13536,9420),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C22[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20677C103v14Ev,
  (VTBL_ENTRY)&_ZN9S20677C22D1Ev,
  (VTBL_ENTRY)&_ZN9S20677C22D0Ev,
  ABISELECT(568,404),
  ABISELECT(-13376,-9308),
  (VTBL_ENTRY)&(_ZTI9S20677C22[0]),
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-13536,-9420),
  (VTBL_ENTRY)&(_ZTI9S20677C22[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-13992,-9752),
  (VTBL_ENTRY)&(_ZTI9S20677C22[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-14096,-9824),
  (VTBL_ENTRY)&(_ZTI9S20677C22[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  ABISELECT(-392,-276),
  ABISELECT(-14336,-9988),
  (VTBL_ENTRY)&(_ZTI9S20677C22[0]),
  0,
  0,
  ABISELECT(-144,-100),
  ABISELECT(-384,-264),
  ABISELECT(-488,-336),
  ABISELECT(-536,-376),
  ABISELECT(-944,-668),
  ABISELECT(-14480,-10088),
  (VTBL_ENTRY)&(_ZTI9S20677C22[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern VTBL_ENTRY _ZTV9S20677C22[];
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN9S20677C103v14Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C10__9S20677C22[] = {
  ABISELECT(14336,9988),
  ABISELECT(14096,9824),
  ABISELECT(13992,9752),
  ABISELECT(13944,9712),
  ABISELECT(13536,9420),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20677C103v14Ev,
};
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C119S20677C10__9S20677C22[] = {
  ABISELECT(14336,9988),
  ABISELECT(14096,9824),
  ABISELECT(13992,9752),
  ABISELECT(13944,9712),
  ABISELECT(13536,9420),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C119S20677C10__9S20677C22[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-13536,-9420),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C119S20677C10__9S20677C22[] = {
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-13992,-9752),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C119S20677C10__9S20677C22[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-14096,-9824),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C119S20677C10__9S20677C22[] = {
  ABISELECT(-392,-276),
  ABISELECT(-14336,-9988),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C10__9S20677C22[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-13536,-9420),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C10__9S20677C22[] = {
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-13992,-9752),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C10__9S20677C22[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-14096,-9824),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C10__9S20677C22[] = {
  ABISELECT(-392,-276),
  ABISELECT(-14336,-9988),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A__9S20677C22[] = {
  ABISELECT(568,404),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C22[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C4__9S20677C22[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C22[] = {
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__8S20677C2__9S20677C22[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(456,332),
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C22[] = {
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__9S20677C22[] = {
  ABISELECT(-392,-276),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C22[] = {
  ABISELECT(-392,-276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C11__A1__9S20677C22[] = {
  ABISELECT(-144,-100),
  ABISELECT(-384,-264),
  ABISELECT(-488,-336),
  ABISELECT(-536,-376),
  ABISELECT(-944,-668),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C11__A1__9S20677C22[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(944,668),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C11__A1__9S20677C22[] = {
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(488,336),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C11__A1__9S20677C22[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(384,264),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C11__A1__9S20677C22[] = {
  ABISELECT(-392,-276),
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
};
static  VTT_ENTRY vtt_S20677C22[] = {
  {&(_ZTV9S20677C22[8]),  8,57},
  {&(_tg__ZTV9S20677C10__9S20677C22[7]),  7,10},
  {&(_tg__ZTV9S20677C119S20677C10__9S20677C22[7]),  7,9},
  {&(_tg__ZTV8S20677C4__9S20677C119S20677C10__9S20677C22[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C119S20677C10__9S20677C22[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C119S20677C10__9S20677C22[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C119S20677C10__9S20677C22[3]),  3,3},
  {&(_tg__ZTV8S20677C4__9S20677C10__9S20677C22[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C10__9S20677C22[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C10__9S20677C22[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C10__9S20677C22[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A__9S20677C22[3]),  3,3},
  {&(_ZTV9S20677C22[22]),  22,57},
  {&(_ZTV9S20677C22[32]),  32,57},
  {&(_ZTV9S20677C22[41]),  41,57},
  {&(_ZTV9S20677C22[46]),  46,57},
  {&(_ZTV9S20677C22[16]),  16,57},
  {&(_ZTV9S20677C22[55]),  55,57},
  {&(_tg__ZTV8S20677C4__9S20677C22[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C4__9S20677C22[3]),  3,3},
  {&(_tg__ZTV8S20677C2__9S20677C22[4]),  4,7},
  {&(_tg__ZTV8S20677C4__8S20677C2__9S20677C22[6]),  6,9},
  {&(_tg__ZTV9S20677C12__9S20677C22[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__9S20677C22[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A1__9S20677C22[3]),  3,3},
  {&(_tg__ZTV9S20677C11__A1__9S20677C22[7]),  7,9},
  {&(_tg__ZTV8S20677C4__9S20677C11__A1__9S20677C22[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C11__A1__9S20677C22[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C11__A1__9S20677C22[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C11__A1__9S20677C22[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20677C22[];
extern  VTBL_ENTRY _ZTV9S20677C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C22[];
Class_Descriptor cd_S20677C22 = {  "S20677C22", // class name
  bases_S20677C22, 10,
  &(vtc_S20677C22[0]), // expected_vtbl_contents
  &(vtt_S20677C22[0]), // expected_vtt_contents
  ABISELECT(15568,10840), // object size
  NSPAIRA(_ZTI9S20677C22),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20677C22),57, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20677C22),30, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20677C1  : virtual S20677C2 , virtual S20677C7 , virtual S20677C10 , virtual S20677C18 {
  int s20677c1f0[2];
  char s20677c1f1;
  void *s20677c1f2;
  int s20677c1f3;
  ::S20677C22 s20677c1f4;
  virtual  ~S20677C1(); // _ZN8S20677C1D2Ev
  virtual void  v1(); // _ZN8S20677C12v1Ev
  S20677C1(); // tgen
};
//SIG(1 S20677C1) C1{ VBC2{ VBC3{ m Fp FL[4] Fs} VBC4{ VBC3 BC5{ VBC3 FD Fi FC3 FC3} v2 v3 v4 Fs FL Fc Fi[2] FC5 Fp FL Fi FL Fi} v5 v6 v7 FL FC6{} Fp Fc[2] FC3 Fl FC6} VBC7{ VBC8{ v8 FC6 FC5 FC6 FL FC6 Fp FC6 Fp[2] FC6} BC5 BC9{ BC3 FC3 Fi FD Fi FL Fl} v9 Fp FC9 Fp Fi[2] FD Fi[2]} VBC10{ BC11{ VBC4 VBC2 VBC12{ VBC3 VBC5 v10 v11 Fi FC5 FL Fi Fp} v12 v13 FC6 FC6 Fi FC5 FC6 FC6 FC8 FC2 Fp FC6} v14 Fi[2] FC6 FC6 FC6 FC6 FC6 FC13{ VBC5 BC11 BC12 Fi Fc:2 FC6 Fi} Fl[4] FC6 FC14{ BC15{ BC4 VBC12 BC5 VBC8 VBC16{ BC5 v15 FL Fc[7] Fp Fi FC6 FC6 Fc[10]} v16 Fl FL FD FC6} BC17{ VBC8 v22 FC15 FC6 Fl Fi[2]} BC13 Fp FL Fi Fp Fi[3] Fc FL Fp FD}[2] Fc FC6} VBC18{ VBC11 VBC19{ BC9 BC12 VBC15 v17 v18 v19 v20 Fp Fc[4] FC4 Fi[8] FC6 FC7 FC6 FD FC5[9] FD[10] Fs} v21 Fp FC20{ BC13 v23 Fi FC6 Fs Fl FC5 Fl} Fp FL Fi FC6 Fp FC21{ v24 Fl FC16 FC6 Fi} Fl} vd v1 Fi[2] Fc Fp Fi FC22{ BC10 BC5 VBC11 vd Fp FC6 Fl}}


 S20677C1 ::~S20677C1(){ note_dtor("S20677C1", this);}
void  S20677C1 ::v1(){vfunc_called(this, "_ZN8S20677C12v1Ev");}
S20677C1 ::S20677C1(){ note_ctor("S20677C1", this);} // tgen

static void Test_S20677C1()
{
  extern Class_Descriptor cd_S20677C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2447,6828)];
    init_test(&cd_S20677C1, buf);
    S20677C1 *dp, &lv = *(dp=new (buf) S20677C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(39136,27308), "sizeof(S20677C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20677C1)");
    check_base_class_offset(lv, (S20677C3*)(S20677C2*), ABISELECT(15720,10936), "S20677C1");
    /*is_ambiguous_... S20677C1::S20677C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C4*), ABISELECT(15720,10936), "S20677C1");
    /*is_ambiguous_... S20677C1::S20677C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*), ABISELECT(15720,10936), "S20677C1");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C7*), ABISELECT(15720,10936), "S20677C1");
    /*is_ambiguous_... S20677C1::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*), ABISELECT(15720,10936), "S20677C1");
    /*is_ambiguous_... S20677C1::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*), ABISELECT(15720,10936), "S20677C1");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C12*)(S20677C19*), ABISELECT(15720,10936), "S20677C1");
    check_base_class_offset(lv, (S20677C3*)(S20677C4*)(S20677C15*), ABISELECT(15720,10936), "S20677C1");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C4*)(S20677C15*), ABISELECT(15720,10936), "S20677C1");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C15*), ABISELECT(15720,10936), "S20677C1");
    check_base_class_offset(lv, (S20677C3*)(S20677C5*)(S20677C16*), ABISELECT(15720,10936), "S20677C1");
    /*is_ambiguous_... S20677C1::S20677C4 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C4*), ABISELECT(15776,10976), "S20677C1");
    check_base_class_offset(lv, (S20677C4*)(S20677C2*), ABISELECT(15776,10976), "S20677C1");
    check_base_class_offset(lv, (S20677C4*)(S20677C11*)(S20677C10*), ABISELECT(15776,10976), "S20677C1");
    /*is_ambiguous_... S20677C1::S20677C11 */ AMB_check_base_class_offset(lv, (S20677C4*)(S20677C11*), ABISELECT(15776,10976), "S20677C1");
    check_base_class_offset(lv, (S20677C2*), ABISELECT(15616,10864), "S20677C1");
    check_base_class_offset(lv, (S20677C2*)(S20677C11*)(S20677C10*), ABISELECT(15616,10864), "S20677C1");
    /*is_ambiguous_... S20677C1::S20677C11 */ AMB_check_base_class_offset(lv, (S20677C2*)(S20677C11*), ABISELECT(15616,10864), "S20677C1");
    check_base_class_offset(lv, (S20677C8*)(S20677C7*), ABISELECT(16704,11628), "S20677C1");
    check_base_class_offset(lv, (S20677C8*)(S20677C15*), ABISELECT(16704,11628), "S20677C1");
    check_base_class_offset(lv, (S20677C5*)(S20677C7*), ABISELECT(16192,11268), "S20677C1");
    check_base_class_offset(lv, (S20677C3*)(S20677C9*)(S20677C7*), ABISELECT(16336,11368), "S20677C1");
    check_base_class_offset(lv, (S20677C9*)(S20677C7*), ABISELECT(16336,11368), "S20677C1");
    check_base_class_offset(lv, (S20677C7*), ABISELECT(16192,11268), "S20677C1");
    /*is_ambiguous_... S20677C1::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*), ABISELECT(30592,21284), "S20677C1");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C12*)(S20677C19*), ABISELECT(30592,21284), "S20677C1");
    check_base_class_offset(lv, (S20677C12*)(S20677C11*)(S20677C10*), ABISELECT(30352,21120), "S20677C1");
    /*is_ambiguous_... S20677C1::S20677C11 */ AMB_check_base_class_offset(lv, (S20677C12*)(S20677C11*), ABISELECT(30352,21120), "S20677C1");
    check_base_class_offset(lv, (S20677C12*)(S20677C15*), ABISELECT(30352,21120), "S20677C1");
    check_base_class_offset(lv, (S20677C11*)(S20677C10*), ABISELECT(16976,11812), "S20677C1");
    check_base_class_offset(lv, (S20677C10*), ABISELECT(16976,11812), "S20677C1");
    check_base_class_offset(lv, (S20677C11*)(S20677C18*), ABISELECT(33568,23364), "S20677C1");
    check_base_class_offset(lv, (S20677C3*)(S20677C9*)(S20677C19*), ABISELECT(34896,24280), "S20677C1");
    check_base_class_offset(lv, (S20677C9*)(S20677C19*), ABISELECT(34896,24280), "S20677C1");
    /*is_ambiguous_... S20677C19::S20677C12 */ AMB_check_base_class_offset(lv, (S20677C12*)(S20677C19*), ABISELECT(34656,24116), "S20677C1");
    check_base_class_offset(lv, (S20677C5*)(S20677C4*)(S20677C15*), ABISELECT(38352,26752), "S20677C1");
    check_base_class_offset(lv, (S20677C4*)(S20677C15*), ABISELECT(38352,26752), "S20677C1");
    /*is_ambiguous_... S20677C15::S20677C5 */ AMB_check_base_class_offset(lv, (S20677C5*)(S20677C15*), ABISELECT(38768,27044), "S20677C1");
    check_base_class_offset(lv, (S20677C5*)(S20677C16*), ABISELECT(38960,27172), "S20677C1");
    check_base_class_offset(lv, (S20677C16*)(S20677C15*), ABISELECT(38960,27172), "S20677C1");
    check_base_class_offset(lv, (S20677C15*)(S20677C19*), ABISELECT(38352,26752), "S20677C1");
    check_base_class_offset(lv, (S20677C19*)(S20677C18*), ABISELECT(34656,24116), "S20677C1");
    check_base_class_offset(lv, (S20677C18*), ABISELECT(30736,21384), "S20677C1");
    check_field_offset(lv, s20677c1f0, ABISELECT(8,4), "S20677C1.s20677c1f0");
    check_field_offset(lv, s20677c1f1, ABISELECT(16,12), "S20677C1.s20677c1f1");
    check_field_offset(lv, s20677c1f2, ABISELECT(24,16), "S20677C1.s20677c1f2");
    check_field_offset(lv, s20677c1f3, ABISELECT(32,20), "S20677C1.s20677c1f3");
    check_field_offset(lv, s20677c1f4, ABISELECT(48,24), "S20677C1.s20677c1f4");
    test_class_info(&lv, &cd_S20677C1);
    dp->~S20677C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20677C1(Test_S20677C1, "S20677C1", ABISELECT(39136,27308));

#else // __cplusplus

extern void _ZN8S20677C1C1Ev();
extern void _ZN8S20677C1D2Ev();
Name_Map name_map_S20677C1[] = {
  NSPAIR(_ZN8S20677C1C1Ev),
  NSPAIR(_ZN8S20677C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C2;
extern VTBL_ENTRY _ZTI8S20677C2[];
extern  VTBL_ENTRY _ZTV8S20677C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C2[];
extern Class_Descriptor cd_S20677C8;
extern VTBL_ENTRY _ZTI8S20677C8[];
extern  VTBL_ENTRY _ZTV8S20677C8[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C9;
extern VTBL_ENTRY _ZTI8S20677C9[];
extern Class_Descriptor cd_S20677C7;
extern VTBL_ENTRY _ZTI8S20677C7[];
extern  VTBL_ENTRY _ZTV8S20677C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C7[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C11;
extern VTBL_ENTRY _ZTI9S20677C11[];
extern  VTBL_ENTRY _ZTV9S20677C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C11[];
extern Class_Descriptor cd_S20677C10;
extern VTBL_ENTRY _ZTI9S20677C10[];
extern  VTBL_ENTRY _ZTV9S20677C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C10[];
extern Class_Descriptor cd_S20677C11;
extern VTBL_ENTRY _ZTI9S20677C11[];
extern  VTBL_ENTRY _ZTV9S20677C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C11[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20677C9;
extern VTBL_ENTRY _ZTI8S20677C9[];
extern Class_Descriptor cd_S20677C12;
extern VTBL_ENTRY _ZTI9S20677C12[];
extern  VTBL_ENTRY _ZTV9S20677C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C12[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C4;
extern VTBL_ENTRY _ZTI8S20677C4[];
extern  VTBL_ENTRY _ZTV8S20677C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C4[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C5;
extern VTBL_ENTRY _ZTI8S20677C5[];
extern  VTBL_ENTRY _ZTV8S20677C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C5[];
extern Class_Descriptor cd_S20677C16;
extern VTBL_ENTRY _ZTI9S20677C16[];
extern  VTBL_ENTRY _ZTV9S20677C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C16[];
extern Class_Descriptor cd_S20677C15;
extern VTBL_ENTRY _ZTI9S20677C15[];
extern  VTBL_ENTRY _ZTV9S20677C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C15[];
extern Class_Descriptor cd_S20677C19;
extern VTBL_ENTRY _ZTI9S20677C19[];
extern  VTBL_ENTRY _ZTV9S20677C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C19[];
extern Class_Descriptor cd_S20677C18;
extern VTBL_ENTRY _ZTI9S20677C18[];
extern  VTBL_ENTRY _ZTV9S20677C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20677C18[];
static Base_Class bases_S20677C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(15720,10936), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(15776,10976), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(15776,10976), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20677C2,    ABISELECT(15616,10864), //bcp->offset
    18, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C8,    ABISELECT(16704,11628), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S20677C5,    ABISELECT(16192,11268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20677C3,    ABISELECT(16336,11368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20677C9,    ABISELECT(16336,11368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20677C7,    ABISELECT(16192,11268), //bcp->offset
    37, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C5,    ABISELECT(30592,21284), //bcp->offset
    68, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S20677C12,    ABISELECT(30352,21120), //bcp->offset
    60, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S20677C11,    ABISELECT(16976,11812), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20677C10,    ABISELECT(16976,11812), //bcp->offset
    47, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C11,    ABISELECT(33568,23364), //bcp->offset
    85, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S20677C3,    ABISELECT(34896,24280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20677C9,    ABISELECT(34896,24280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20677C12,    ABISELECT(34656,24116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20677C5,    ABISELECT(38352,26752), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20677C4,    ABISELECT(38352,26752), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20677C5,    ABISELECT(38768,27044), //bcp->offset
    131, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20677C5,    ABISELECT(38960,27172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S20677C16,    ABISELECT(38960,27172), //bcp->offset
    134, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    69, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S20677C15,    ABISELECT(38352,26752), //bcp->offset
    116, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S20677C19,    ABISELECT(34656,24116), //bcp->offset
    96, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S20677C18,    ABISELECT(30736,21384), //bcp->offset
    71, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20677C1[];
extern void _ZN8S20677C1D1Ev();
extern void _ZN8S20677C1D0Ev();
extern void _ZN8S20677C12v1Ev();
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN8S20677C72v9Ev();
extern void _ZN8S20677C82v8Ev();
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN9S20677C103v14Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN9S20677C183v21Ev();
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN9S20677C193v17Ev();
extern void _ZN9S20677C193v18Ev();
extern void _ZN9S20677C193v19Ev();
extern void _ZN9S20677C193v20Ev();
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY vtc_S20677C1[] = {
  ABISELECT(38960,27172),
  ABISELECT(38352,26752),
  ABISELECT(34656,24116),
  ABISELECT(33568,23364),
  ABISELECT(30736,21384),
  ABISELECT(30592,21284),
  ABISELECT(30352,21120),
  ABISELECT(16976,11812),
  ABISELECT(16704,11628),
  ABISELECT(16192,11268),
  ABISELECT(15776,10976),
  ABISELECT(15720,10936),
  ABISELECT(15616,10864),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN8S20677C1D1Ev,
  (VTBL_ENTRY)&_ZN8S20677C1D0Ev,
  (VTBL_ENTRY)&_ZN8S20677C12v1Ev,
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(104,72),
  ABISELECT(-15616,-10864),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-15776,-10976),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  0,
  ABISELECT(512,360),
  ABISELECT(-472,-332),
  ABISELECT(-16192,-11268),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN8S20677C72v9Ev,
  0,
  ABISELECT(-16704,-11628),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
  0,
  0,
  0,
  ABISELECT(13616,9472),
  ABISELECT(13376,9308),
  ABISELECT(-1360,-948),
  ABISELECT(-1256,-876),
  ABISELECT(-1200,-836),
  ABISELECT(-16976,-11812),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20677C103v14Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10184),
  ABISELECT(-30352,-21120),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  ABISELECT(-14872,-10348),
  ABISELECT(-30592,-21284),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  0,
  ABISELECT(8224,5788),
  ABISELECT(-14032,-9756),
  ABISELECT(7616,5368),
  ABISELECT(3920,2732),
  ABISELECT(-144,-100),
  ABISELECT(-384,-264),
  ABISELECT(-15120,-10520),
  ABISELECT(-15016,-10448),
  ABISELECT(-14960,-10408),
  ABISELECT(2832,1980),
  ABISELECT(-30736,-21384),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN9S20677C183v21Ev,
  0,
  0,
  ABISELECT(-2976,-2080),
  ABISELECT(-3216,-2244),
  ABISELECT(-17952,-12500),
  ABISELECT(-17848,-12428),
  ABISELECT(-17792,-12388),
  ABISELECT(-33568,-23364),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(4304,3056),
  ABISELECT(-17952,-12488),
  ABISELECT(-4304,-2996),
  ABISELECT(3696,2636),
  ABISELECT(-4064,-2832),
  ABISELECT(-18936,-13180),
  ABISELECT(-34656,-24116),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v20Ev,
  0,
  0,
  0,
  0,
  ABISELECT(608,420),
  ABISELECT(-21648,-15124),
  ABISELECT(-7760,-5468),
  ABISELECT(-8000,-5632),
  ABISELECT(-22632,-15816),
  ABISELECT(-38352,-26752),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
  ABISELECT(-23048,-16108),
  ABISELECT(-38768,-27044),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  0,
  ABISELECT(-23240,-16236),
  ABISELECT(-38960,-27172),
  (VTBL_ENTRY)&(_ZTI8S20677C1[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern VTBL_ENTRY _ZTV8S20677C1[];
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__8S20677C1[] = {
  ABISELECT(160,112),
  ABISELECT(104,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__8S20677C2__8S20677C1[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI8S20677C2[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__8S20677C1[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C4__8S20677C1[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C72v9Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C7__8S20677C1[] = {
  ABISELECT(512,360),
  ABISELECT(-472,-332),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C7[0]),
  (VTBL_ENTRY)&_ZN8S20677C72v9Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C7__A1__8S20677C1[] = {
  ABISELECT(-472,-332),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C8__8S20677C7__8S20677C1[] = {
  0,
  ABISELECT(-512,-360),
  (VTBL_ENTRY)&(_ZTI8S20677C7[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
extern void _ZN9S20677C103v14Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C10__8S20677C1[] = {
  ABISELECT(13616,9472),
  ABISELECT(13376,9308),
  ABISELECT(-1360,-948),
  ABISELECT(-1256,-876),
  ABISELECT(-1200,-836),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20677C103v14Ev,
};
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C119S20677C10__8S20677C1[] = {
  ABISELECT(13616,9472),
  ABISELECT(13376,9308),
  ABISELECT(-1360,-948),
  ABISELECT(-1256,-876),
  ABISELECT(-1200,-836),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C119S20677C10__8S20677C1[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(1200,836),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C119S20677C10__8S20677C1[] = {
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(104,72),
  ABISELECT(1360,948),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C119S20677C10__8S20677C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10184),
  ABISELECT(-13376,-9308),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C119S20677C10__8S20677C1[] = {
  ABISELECT(-14872,-10348),
  ABISELECT(-13616,-9472),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C10__8S20677C1[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(1200,836),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C10__8S20677C1[] = {
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(104,72),
  ABISELECT(1360,948),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C10__8S20677C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10184),
  ABISELECT(-13376,-9308),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C10__8S20677C1[] = {
  ABISELECT(-14872,-10348),
  ABISELECT(-13616,-9472),
  (VTBL_ENTRY)&(_ZTI9S20677C10[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__8S20677C1[] = {
  ABISELECT(240,164),
  ABISELECT(-14632,-10184),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C12__8S20677C1[] = {
  ABISELECT(-14872,-10348),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A2__8S20677C1[] = {
  ABISELECT(-14872,-10348),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN9S20677C183v21Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C18__8S20677C1[] = {
  ABISELECT(8224,5788),
  ABISELECT(-14032,-9756),
  ABISELECT(7616,5368),
  ABISELECT(3920,2732),
  ABISELECT(-144,-100),
  ABISELECT(-384,-264),
  ABISELECT(-15120,-10520),
  ABISELECT(-15016,-10448),
  ABISELECT(-14960,-10408),
  ABISELECT(2832,1980),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN9S20677C183v21Ev,
};
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C11__9S20677C18__8S20677C1[] = {
  0,
  0,
  ABISELECT(-2976,-2080),
  ABISELECT(-3216,-2244),
  ABISELECT(-17952,-12500),
  ABISELECT(-17848,-12428),
  ABISELECT(-17792,-12388),
  ABISELECT(-2832,-1980),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C18__8S20677C1[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(14960,10408),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C18__8S20677C1[] = {
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(104,72),
  ABISELECT(15120,10520),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C18__8S20677C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10184),
  ABISELECT(384,264),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C18__8S20677C1[] = {
  ABISELECT(-14872,-10348),
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN9S20677C193v17Ev();
extern void _ZN9S20677C193v18Ev();
extern void _ZN9S20677C193v19Ev();
extern void _ZN9S20677C193v20Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C19__9S20677C18__8S20677C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(4304,3056),
  ABISELECT(-17952,-12488),
  ABISELECT(-4304,-2996),
  ABISELECT(3696,2636),
  ABISELECT(-4064,-2832),
  ABISELECT(-18936,-13180),
  ABISELECT(-3920,-2732),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v20Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C15__9S20677C18__8S20677C1[] = {
  0,
  0,
  0,
  0,
  ABISELECT(608,420),
  ABISELECT(-21648,-15124),
  ABISELECT(-7760,-5468),
  ABISELECT(-8000,-5632),
  ABISELECT(-22632,-15816),
  ABISELECT(-7616,-5368),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C15__A3__9S20677C18__8S20677C1[] = {
  ABISELECT(-23048,-16108),
  ABISELECT(-8032,-5660),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
};
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C8__9S20677C18__8S20677C1[] = {
  0,
  ABISELECT(14032,9756),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C18__8S20677C1[] = {
  0,
  ABISELECT(-23240,-16236),
  ABISELECT(-8224,-5788),
  (VTBL_ENTRY)&(_ZTI9S20677C18[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern void _ZN9S20677C113v12Ev();
extern void _ZN9S20677C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C11__A1__8S20677C1[] = {
  ABISELECT(-2976,-2080),
  ABISELECT(-3216,-2244),
  ABISELECT(-17952,-12500),
  ABISELECT(-17848,-12428),
  ABISELECT(-17792,-12388),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20677C113v13Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C4__9S20677C11__A1__8S20677C1[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(17792,12388),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
extern void _ZN8S20677C22v5Ev();
extern void _ZN8S20677C22v6Ev();
extern void _ZN8S20677C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C2__9S20677C11__A1__8S20677C1[] = {
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(104,72),
  ABISELECT(17952,12500),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN8S20677C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20677C22v7Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C11__A1__8S20677C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10184),
  ABISELECT(3216,2244),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C11__A1__8S20677C1[] = {
  ABISELECT(-14872,-10348),
  ABISELECT(2976,2080),
  (VTBL_ENTRY)&(_ZTI9S20677C11[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
extern void _ZN9S20677C193v17Ev();
extern void _ZN9S20677C193v18Ev();
extern void _ZN9S20677C193v19Ev();
extern void _ZN9S20677C193v20Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C19__8S20677C1[] = {
  ABISELECT(4304,3056),
  ABISELECT(-17952,-12488),
  ABISELECT(-4304,-2996),
  ABISELECT(3696,2636),
  ABISELECT(-4064,-2832),
  ABISELECT(-18936,-13180),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20677C193v20Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C129S20677C19__A1__8S20677C1[] = {
  ABISELECT(-4064,-2832),
  ABISELECT(-18936,-13180),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C129S20677C19__A1__8S20677C1[] = {
  ABISELECT(-14872,-10348),
  ABISELECT(4064,2832),
  (VTBL_ENTRY)&(_ZTI9S20677C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__9S20677C19__8S20677C1[] = {
  ABISELECT(-14872,-10348),
  ABISELECT(4064,2832),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C15__9S20677C19__8S20677C1[] = {
  0,
  0,
  0,
  0,
  ABISELECT(608,420),
  ABISELECT(-21648,-15124),
  ABISELECT(-7760,-5468),
  ABISELECT(-8000,-5632),
  ABISELECT(-22632,-15816),
  ABISELECT(-3696,-2636),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__A1__9S20677C19__8S20677C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10184),
  ABISELECT(4304,2996),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C15__A2__9S20677C19__8S20677C1[] = {
  ABISELECT(-23048,-16108),
  ABISELECT(-4112,-2928),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
};
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C8__9S20677C19__8S20677C1[] = {
  0,
  ABISELECT(17952,12488),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C19__8S20677C1[] = {
  0,
  ABISELECT(-23240,-16236),
  ABISELECT(-4304,-3056),
  (VTBL_ENTRY)&(_ZTI9S20677C19[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
extern void _ZN9S20677C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C15__8S20677C1[] = {
  ABISELECT(608,420),
  ABISELECT(-21648,-15124),
  ABISELECT(-7760,-5468),
  ABISELECT(-8000,-5632),
  ABISELECT(-22632,-15816),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20677C153v16Ev,
};
extern void _ZN8S20677C42v2Ev();
extern void _ZN8S20677C42v3Ev();
extern void _ZN8S20677C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C49S20677C15__A1__8S20677C1[] = {
  ABISELECT(-22632,-15816),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C4[0]),
  (VTBL_ENTRY)&_ZN8S20677C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20677C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C58S20677C49S20677C15__A3__8S20677C1[] = {
  ABISELECT(-22632,-15816),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C15__A4__8S20677C1[] = {
  ABISELECT(-23048,-16108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
extern void _ZN9S20677C123v10Ev();
extern void _ZN9S20677C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C12__9S20677C15__8S20677C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10184),
  ABISELECT(8000,5632),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN9S20677C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20677C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A1__9S20677C15__8S20677C1[] = {
  ABISELECT(-14872,-10348),
  ABISELECT(7760,5468),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20677C5__A__9S20677C15__8S20677C1[] = {
  ABISELECT(-23048,-16108),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
};
extern void _ZN8S20677C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20677C8__9S20677C15__8S20677C1[] = {
  0,
  ABISELECT(21648,15124),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN8S20677C82v8Ev,
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__9S20677C15__8S20677C1[] = {
  0,
  ABISELECT(-23240,-16236),
  ABISELECT(-608,-420),
  (VTBL_ENTRY)&(_ZTI9S20677C15[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
extern void _ZN9S20677C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20677C16__8S20677C1[] = {
  ABISELECT(-23240,-16236),
  0,
  (VTBL_ENTRY)&(_ZTI9S20677C16[0]),
  (VTBL_ENTRY)&_ZN9S20677C163v15Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20677C59S20677C16__A5__8S20677C1[] = {
  ABISELECT(-23240,-16236),
  0,
  (VTBL_ENTRY)&(_ZTI8S20677C5[0]),
};
static  VTT_ENTRY vtt_S20677C1[] = {
  {&(_ZTV8S20677C1[15]),  15,139},
  {&(_ZTV8S20677C1[25]),  25,139},
  {&(_ZTV8S20677C1[34]),  34,139},
  {&(_ZTV8S20677C1[42]),  42,139},
  {&(_ZTV8S20677C1[46]),  46,139},
  {&(_ZTV8S20677C1[57]),  57,139},
  {&(_ZTV8S20677C1[66]),  66,139},
  {&(_ZTV8S20677C1[71]),  71,139},
  {&(_ZTV8S20677C1[84]),  84,139},
  {&(_ZTV8S20677C1[94]),  94,139},
  {&(_ZTV8S20677C1[110]),  110,139},
  {&(_ZTV8S20677C1[127]),  127,139},
  {&(_ZTV8S20677C1[134]),  134,139},
  {&(_ZTV8S20677C1[138]),  138,139},
  {&(_tg__ZTV8S20677C2__8S20677C1[4]),  4,7},
  {&(_tg__ZTV8S20677C4__8S20677C2__8S20677C1[6]),  6,9},
  {&(_tg__ZTV8S20677C4__8S20677C1[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C4__8S20677C1[3]),  3,3},
  {&(_tg__ZTV8S20677C7__8S20677C1[4]),  4,5},
  {&(_tg__ZTV8S20677C58S20677C7__A1__8S20677C1[3]),  3,3},
  {&(_tg__ZTV8S20677C8__8S20677C7__8S20677C1[3]),  3,4},
  {&(_tg__ZTV9S20677C10__8S20677C1[7]),  7,10},
  {&(_tg__ZTV9S20677C119S20677C10__8S20677C1[7]),  7,9},
  {&(_tg__ZTV8S20677C4__9S20677C119S20677C10__8S20677C1[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C119S20677C10__8S20677C1[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C119S20677C10__8S20677C1[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C119S20677C10__8S20677C1[3]),  3,3},
  {&(_tg__ZTV8S20677C4__9S20677C10__8S20677C1[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C10__8S20677C1[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C10__8S20677C1[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C10__8S20677C1[3]),  3,3},
  {&(_tg__ZTV9S20677C12__8S20677C1[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C12__8S20677C1[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A2__8S20677C1[3]),  3,3},
  {&(_tg__ZTV9S20677C18__8S20677C1[12]),  12,13},
  {&(_tg__ZTV9S20677C11__9S20677C18__8S20677C1[9]),  9,11},
  {&(_tg__ZTV8S20677C4__9S20677C18__8S20677C1[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C18__8S20677C1[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C18__8S20677C1[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C18__8S20677C1[3]),  3,3},
  {&(_tg__ZTV9S20677C19__9S20677C18__8S20677C1[14]),  14,20},
  {&(_tg__ZTV9S20677C15__9S20677C18__8S20677C1[11]),  11,15},
  {&(_tg__ZTV8S20677C59S20677C15__A3__9S20677C18__8S20677C1[3]),  3,3},
  {&(_tg__ZTV8S20677C8__9S20677C18__8S20677C1[3]),  3,4},
  {&(_tg__ZTV9S20677C16__9S20677C18__8S20677C1[4]),  4,5},
  {&(_tg__ZTV9S20677C11__A1__8S20677C1[7]),  7,9},
  {&(_tg__ZTV8S20677C4__9S20677C11__A1__8S20677C1[6]),  6,9},
  {&(_tg__ZTV8S20677C2__9S20677C11__A1__8S20677C1[7]),  7,10},
  {&(_tg__ZTV9S20677C12__9S20677C11__A1__8S20677C1[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C11__A1__8S20677C1[3]),  3,3},
  {&(_tg__ZTV9S20677C19__8S20677C1[8]),  8,14},
  {&(_tg__ZTV9S20677C129S20677C19__A1__8S20677C1[4]),  4,6},
  {&(_tg__ZTV8S20677C5__9S20677C129S20677C19__A1__8S20677C1[3]),  3,3},
  {&(_tg__ZTV8S20677C5__9S20677C19__8S20677C1[3]),  3,3},
  {&(_tg__ZTV9S20677C15__9S20677C19__8S20677C1[11]),  11,15},
  {&(_tg__ZTV9S20677C12__A1__9S20677C19__8S20677C1[6]),  6,8},
  {&(_tg__ZTV8S20677C59S20677C15__A2__9S20677C19__8S20677C1[3]),  3,3},
  {&(_tg__ZTV8S20677C8__9S20677C19__8S20677C1[3]),  3,4},
  {&(_tg__ZTV9S20677C16__9S20677C19__8S20677C1[4]),  4,5},
  {&(_tg__ZTV9S20677C15__8S20677C1[7]),  7,11},
  {&(_tg__ZTV8S20677C49S20677C15__A1__8S20677C1[3]),  3,6},
  {&(_tg__ZTV8S20677C58S20677C49S20677C15__A3__8S20677C1[3]),  3,3},
  {&(_tg__ZTV8S20677C59S20677C15__A4__8S20677C1[3]),  3,3},
  {&(_tg__ZTV9S20677C12__9S20677C15__8S20677C1[6]),  6,8},
  {&(_tg__ZTV8S20677C5__A1__9S20677C15__8S20677C1[3]),  3,3},
  {&(_tg__ZTV8S20677C5__A__9S20677C15__8S20677C1[3]),  3,3},
  {&(_tg__ZTV8S20677C8__9S20677C15__8S20677C1[3]),  3,4},
  {&(_tg__ZTV9S20677C16__9S20677C15__8S20677C1[4]),  4,5},
  {&(_tg__ZTV9S20677C16__8S20677C1[3]),  3,4},
  {&(_tg__ZTV8S20677C59S20677C16__A5__8S20677C1[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20677C1[];
extern  VTBL_ENTRY _ZTV8S20677C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20677C1[];
Class_Descriptor cd_S20677C1 = {  "S20677C1", // class name
  bases_S20677C1, 25,
  &(vtc_S20677C1[0]), // expected_vtbl_contents
  &(vtt_S20677C1[0]), // expected_vtt_contents
  ABISELECT(39136,27308), // object size
  NSPAIRA(_ZTI8S20677C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20677C1),139, //virtual function table var
  15, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20677C1),70, //virtual table table var
  20, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C5  : virtual S20677C3 {
  long double s20678c5f0;
  int s20678c5f1;
  ::S20677C3 s20678c5f2;
  ::S20677C3 s20678c5f3;
  ~S20678C5(); // tgen
  S20678C5(); // tgen
};
//SIG(-1 S20678C5) C1{ VBC2{ m Fp FL[4] Fs} FD Fi FC2 FC2}


S20678C5 ::~S20678C5(){ note_dtor("S20678C5", this);} // tgen
S20678C5 ::S20678C5(){ note_ctor("S20678C5", this);} // tgen

static void Test_S20678C5()
{
  extern Class_Descriptor cd_S20678C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(13,36)];
    init_test(&cd_S20678C5, buf);
    S20678C5 *dp, &lv = *(dp=new (buf) S20678C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,140), "sizeof(S20678C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C5)");
    check_base_class_offset(lv, (S20677C3*), ABISELECT(136,100), "S20678C5");
    check_field_offset(lv, s20678c5f0, ABISELECT(16,4), "S20678C5.s20678c5f0");
    check_field_offset(lv, s20678c5f1, ABISELECT(32,16), "S20678C5.s20678c5f1");
    check_field_offset(lv, s20678c5f2, ABISELECT(40,20), "S20678C5.s20678c5f2");
    check_field_offset(lv, s20678c5f3, ABISELECT(88,60), "S20678C5.s20678c5f3");
    test_class_info(&lv, &cd_S20678C5);
    dp->~S20678C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C5(Test_S20678C5, "S20678C5", ABISELECT(192,140));

#else // __cplusplus

extern void _ZN8S20678C5C1Ev();
extern void _ZN8S20678C5D1Ev();
Name_Map name_map_S20678C5[] = {
  NSPAIR(_ZN8S20678C5C1Ev),
  NSPAIR(_ZN8S20678C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
static Base_Class bases_S20678C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(136,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20678C5[];
static  VTBL_ENTRY vtc_S20678C5[] = {
  ABISELECT(136,100),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern VTBL_ENTRY _ZTV8S20678C5[];
static  VTT_ENTRY vtt_S20678C5[] = {
  {&(_ZTV8S20678C5[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
Class_Descriptor cd_S20678C5 = {  "S20678C5", // class name
  bases_S20678C5, 1,
  &(vtc_S20678C5[0]), // expected_vtbl_contents
  &(vtt_S20678C5[0]), // expected_vtt_contents
  ABISELECT(192,140), // object size
  NSPAIRA(_ZTI8S20678C5),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20678C5),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20678C5),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C4  : virtual S20677C3 , S20678C5 {
  short s20678c4f0;
  __tsi64 s20678c4f1;
  char s20678c4f2;
  int s20678c4f3[2];
  ::S20678C5 s20678c4f4;
  void *s20678c4f5;
  __tsi64 s20678c4f6;
  int s20678c4f7;
  __tsi64 s20678c4f8;
  int s20678c4f9;
  virtual void  v2(); // _ZN8S20678C42v2Ev
  virtual void  v3(); // _ZN8S20678C42v3Ev
  virtual void  v4(); // _ZN8S20678C42v4Ev
  ~S20678C4(); // tgen
  S20678C4(); // tgen
};
//SIG(-1 S20678C4) C1{ VBC2{ m Fp FL[4] Fs} BC3{ VBC2 FD Fi FC2 FC2} v1 v2 v3 Fs FL Fc Fi[2] FC3 Fp FL Fi FL Fi}


void  S20678C4 ::v2(){vfunc_called(this, "_ZN8S20678C42v2Ev");}
void  S20678C4 ::v3(){vfunc_called(this, "_ZN8S20678C42v3Ev");}
void  S20678C4 ::v4(){vfunc_called(this, "_ZN8S20678C42v4Ev");}
S20678C4 ::~S20678C4(){ note_dtor("S20678C4", this);} // tgen
S20678C4 ::S20678C4(){ note_ctor("S20678C4", this);} // tgen

static void Test_S20678C4()
{
  extern Class_Descriptor cd_S20678C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(30,84)];
    init_test(&cd_S20678C4, buf);
    S20678C4 *dp, &lv = *(dp=new (buf) S20678C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(464,332), "sizeof(S20678C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C4)");
    check_base_class_offset(lv, (S20677C3*), ABISELECT(408,292), "S20678C4");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(408,292), "S20678C4");
    check_base_class_offset(lv, (S20678C5*), 0, "S20678C4");
    check_field_offset(lv, s20678c4f0, ABISELECT(136,100), "S20678C4.s20678c4f0");
    check_field_offset(lv, s20678c4f1, ABISELECT(144,104), "S20678C4.s20678c4f1");
    check_field_offset(lv, s20678c4f2, ABISELECT(152,112), "S20678C4.s20678c4f2");
    check_field_offset(lv, s20678c4f3, ABISELECT(156,116), "S20678C4.s20678c4f3");
    check_field_offset(lv, s20678c4f4, ABISELECT(176,124), "S20678C4.s20678c4f4");
    check_field_offset(lv, s20678c4f5, ABISELECT(368,264), "S20678C4.s20678c4f5");
    check_field_offset(lv, s20678c4f6, ABISELECT(376,268), "S20678C4.s20678c4f6");
    check_field_offset(lv, s20678c4f7, ABISELECT(384,276), "S20678C4.s20678c4f7");
    check_field_offset(lv, s20678c4f8, ABISELECT(392,280), "S20678C4.s20678c4f8");
    check_field_offset(lv, s20678c4f9, ABISELECT(400,288), "S20678C4.s20678c4f9");
    test_class_info(&lv, &cd_S20678C4);
    dp->~S20678C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C4(Test_S20678C4, "S20678C4", ABISELECT(464,332));

#else // __cplusplus

extern void _ZN8S20678C4C1Ev();
extern void _ZN8S20678C4D1Ev();
Name_Map name_map_S20678C4[] = {
  NSPAIR(_ZN8S20678C4C1Ev),
  NSPAIR(_ZN8S20678C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
static Base_Class bases_S20678C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(408,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20678C4[];
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY vtc_S20678C4[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern VTBL_ENTRY _ZTV8S20678C4[];
static  VTBL_ENTRY _tg__ZTV8S20678C5__8S20678C4[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C4[] = {
  {&(_ZTV8S20678C4[3]),  3,6},
  {&(_tg__ZTV8S20678C5__8S20678C4[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
Class_Descriptor cd_S20678C4 = {  "S20678C4", // class name
  bases_S20678C4, 2,
  &(vtc_S20678C4[0]), // expected_vtbl_contents
  &(vtt_S20678C4[0]), // expected_vtt_contents
  ABISELECT(464,332), // object size
  NSPAIRA(_ZTI8S20678C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20678C4),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20678C4),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C2  : virtual S20677C3 , virtual S20678C4 {
  __tsi64 s20678c2f0;
  ::S20677C6_nt s20678c2f1;
  void *s20678c2f2;
  char s20678c2f3[2];
  ::S20677C3 s20678c2f4;
  long s20678c2f5;
  ::S20677C6_nt s20678c2f6;
  virtual void  v5(); // _ZN8S20678C22v5Ev
  virtual void  v6(); // _ZN8S20678C22v6Ev
  virtual void  v7(); // _ZN8S20678C22v7Ev
  ~S20678C2(); // tgen
  S20678C2(); // tgen
};
//SIG(-1 S20678C2) C1{ VBC2{ m Fp FL[4] Fs} VBC3{ VBC2 BC4{ VBC2 FD Fi FC2 FC2} v4 v5 v6 Fs FL Fc Fi[2] FC4 Fp FL Fi FL Fi} v1 v2 v3 FL FC5{} Fp Fc[2] FC2 Fl FC5}


void  S20678C2 ::v5(){vfunc_called(this, "_ZN8S20678C22v5Ev");}
void  S20678C2 ::v6(){vfunc_called(this, "_ZN8S20678C22v6Ev");}
void  S20678C2 ::v7(){vfunc_called(this, "_ZN8S20678C22v7Ev");}
S20678C2 ::~S20678C2(){ note_dtor("S20678C2", this);} // tgen
S20678C2 ::S20678C2(){ note_ctor("S20678C2", this);} // tgen

static void Test_S20678C2()
{
  extern Class_Descriptor cd_S20678C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(37,102)];
    init_test(&cd_S20678C2, buf);
    S20678C2 *dp, &lv = *(dp=new (buf) S20678C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(576,404), "sizeof(S20678C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C2)");
    check_base_class_offset(lv, (S20677C3*), ABISELECT(104,72), "S20678C2");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*), ABISELECT(104,72), "S20678C2");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*), ABISELECT(104,72), "S20678C2");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*), ABISELECT(160,112), "S20678C2");
    check_base_class_offset(lv, (S20678C4*), ABISELECT(160,112), "S20678C2");
    check_field_offset(lv, s20678c2f0, ABISELECT(8,4), "S20678C2.s20678c2f0");
    check_field_offset(lv, s20678c2f1, ABISELECT(16,12), "S20678C2.s20678c2f1");
    check_field_offset(lv, s20678c2f2, ABISELECT(24,16), "S20678C2.s20678c2f2");
    check_field_offset(lv, s20678c2f3, ABISELECT(32,20), "S20678C2.s20678c2f3");
    check_field_offset(lv, s20678c2f4, ABISELECT(40,24), "S20678C2.s20678c2f4");
    check_field_offset(lv, s20678c2f5, ABISELECT(88,64), "S20678C2.s20678c2f5");
    check_field_offset(lv, s20678c2f6, ABISELECT(96,68), "S20678C2.s20678c2f6");
    test_class_info(&lv, &cd_S20678C2);
    dp->~S20678C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C2(Test_S20678C2, "S20678C2", ABISELECT(576,404));

#else // __cplusplus

extern void _ZN8S20678C2C1Ev();
extern void _ZN8S20678C2D1Ev();
Name_Map name_map_S20678C2[] = {
  NSPAIR(_ZN8S20678C2C1Ev),
  NSPAIR(_ZN8S20678C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
static Base_Class bases_S20678C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(104,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C5,    ABISELECT(160,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(160,112), //bcp->offset
    7, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20678C2[];
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY vtc_S20678C2[] = {
  ABISELECT(160,112),
  ABISELECT(104,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern VTBL_ENTRY _ZTV8S20678C2[];
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__8S20678C2[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C4__8S20678C2[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C2[] = {
  {&(_ZTV8S20678C2[4]),  4,16},
  {&(_ZTV8S20678C2[13]),  13,16},
  {&(_tg__ZTV8S20678C4__8S20678C2[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C4__8S20678C2[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20678C2[];
extern  VTBL_ENTRY _ZTV8S20678C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C2[];
Class_Descriptor cd_S20678C2 = {  "S20678C2", // class name
  bases_S20678C2, 3,
  &(vtc_S20678C2[0]), // expected_vtbl_contents
  &(vtt_S20678C2[0]), // expected_vtt_contents
  ABISELECT(576,404), // object size
  NSPAIRA(_ZTI8S20678C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20678C2),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20678C2),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C8  {
  ::S20677C6_nt s20678c8f0;
  ::S20678C5 s20678c8f1;
  ::S20677C6_nt s20678c8f2;
  __tsi64 s20678c8f3;
  ::S20677C6_nt s20678c8f4;
  void *s20678c8f5;
  ::S20677C6_nt s20678c8f6;
  void *s20678c8f7[2];
  ::S20677C6_nt s20678c8f8;
  virtual void  v8(); // _ZN8S20678C82v8Ev
  ~S20678C8(); // tgen
  S20678C8(); // tgen
};
//SIG(-1 S20678C8) C1{ v1 FC2{} FC3{ VBC4{ m Fp FL[4] Fs} FD Fi FC4 FC4} FC2 FL FC2 Fp FC2 Fp[2] FC2}


void  S20678C8 ::v8(){vfunc_called(this, "_ZN8S20678C82v8Ev");}
S20678C8 ::~S20678C8(){ note_dtor("S20678C8", this);} // tgen
S20678C8 ::S20678C8(){ note_ctor("S20678C8", this);} // tgen

static void Test_S20678C8()
{
  extern Class_Descriptor cd_S20678C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(18,47)];
    init_test(&cd_S20678C8, buf);
    S20678C8 *dp, &lv = *(dp=new (buf) S20678C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,184), "sizeof(S20678C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C8)");
    check_field_offset(lv, s20678c8f0, ABISELECT(8,4), "S20678C8.s20678c8f0");
    check_field_offset(lv, s20678c8f1, ABISELECT(16,8), "S20678C8.s20678c8f1");
    check_field_offset(lv, s20678c8f2, ABISELECT(208,148), "S20678C8.s20678c8f2");
    check_field_offset(lv, s20678c8f3, ABISELECT(216,152), "S20678C8.s20678c8f3");
    check_field_offset(lv, s20678c8f4, ABISELECT(224,160), "S20678C8.s20678c8f4");
    check_field_offset(lv, s20678c8f5, ABISELECT(232,164), "S20678C8.s20678c8f5");
    check_field_offset(lv, s20678c8f6, ABISELECT(240,168), "S20678C8.s20678c8f6");
    check_field_offset(lv, s20678c8f7, ABISELECT(248,172), "S20678C8.s20678c8f7");
    check_field_offset(lv, s20678c8f8, ABISELECT(264,180), "S20678C8.s20678c8f8");
    test_class_info(&lv, &cd_S20678C8);
    dp->~S20678C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C8(Test_S20678C8, "S20678C8", ABISELECT(272,184));

#else // __cplusplus

extern void _ZN8S20678C8C1Ev();
extern void _ZN8S20678C8D1Ev();
Name_Map name_map_S20678C8[] = {
  NSPAIR(_ZN8S20678C8C1Ev),
  NSPAIR(_ZN8S20678C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S20678C8[];
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY vtc_S20678C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C8[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern VTBL_ENTRY _ZTI8S20678C8[];
extern  VTBL_ENTRY _ZTV8S20678C8[];
Class_Descriptor cd_S20678C8 = {  "S20678C8", // class name
  0,0,//no base classes
  &(vtc_S20678C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,184), // object size
  NSPAIRA(_ZTI8S20678C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S20678C8),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C9  : S20677C3 {
  ::S20677C3 s20678c9f0;
  int s20678c9f1;
  long double s20678c9f2;
  int s20678c9f3;
  __tsi64 s20678c9f4;
  long s20678c9f5;
};
//SIG(-1 S20678C9) C1{ BC2{ m Fp FL[4] Fs} FC2 Fi FD Fi FL Fl}



static void Test_S20678C9()
{
  extern Class_Descriptor cd_S20678C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(11,29)];
    init_test(&cd_S20678C9, buf);
    S20678C9 &lv = *(new (buf) S20678C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,112), "sizeof(S20678C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C9)");
    check_base_class_offset(lv, (S20677C3*), 0, "S20678C9");
    check_field_offset(lv, s20678c9f0, ABISELECT(48,40), "S20678C9.s20678c9f0");
    check_field_offset(lv, s20678c9f1, ABISELECT(96,80), "S20678C9.s20678c9f1");
    check_field_offset(lv, s20678c9f2, ABISELECT(112,84), "S20678C9.s20678c9f2");
    check_field_offset(lv, s20678c9f3, ABISELECT(128,96), "S20678C9.s20678c9f3");
    check_field_offset(lv, s20678c9f4, ABISELECT(136,100), "S20678C9.s20678c9f4");
    check_field_offset(lv, s20678c9f5, ABISELECT(144,108), "S20678C9.s20678c9f5");
    test_class_info(&lv, &cd_S20678C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C9(Test_S20678C9, "S20678C9", ABISELECT(160,112));

#else // __cplusplus

extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
static Base_Class bases_S20678C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20678C9[];
Class_Descriptor cd_S20678C9 = {  "S20678C9", // class name
  bases_S20678C9, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(160,112), // object size
  NSPAIRA(_ZTI8S20678C9),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C7  : virtual S20678C8 , S20678C5 , S20678C9 {
  void *s20678c7f0;
  ::S20678C9 s20678c7f1;
  void *s20678c7f2;
  int s20678c7f3[2];
  long double s20678c7f4;
  int s20678c7f5[2];
  virtual void  v9(); // _ZN8S20678C72v9Ev
  ~S20678C7(); // tgen
  S20678C7(); // tgen
};
//SIG(-1 S20678C7) C1{ VBC2{ v2 FC3{} FC4{ VBC5{ m Fp FL[4] Fs} FD Fi FC5 FC5} FC3 FL FC3 Fp FC3 Fp[2] FC3} BC4 BC6{ BC5 FC5 Fi FD Fi FL Fl} v1 Fp FC6 Fp Fi[2] FD Fi[2]}


void  S20678C7 ::v9(){vfunc_called(this, "_ZN8S20678C72v9Ev");}
S20678C7 ::~S20678C7(){ note_dtor("S20678C7", this);} // tgen
S20678C7 ::S20678C7(){ note_ctor("S20678C7", this);} // tgen

static void Test_S20678C7()
{
  extern Class_Descriptor cd_S20678C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(53,147)];
    init_test(&cd_S20678C7, buf);
    S20678C7 *dp, &lv = *(dp=new (buf) S20678C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,584), "sizeof(S20678C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C7)");
    check_base_class_offset(lv, (S20678C8*), ABISELECT(512,360), "S20678C7");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(784,544), "S20678C7");
    check_base_class_offset(lv, (S20678C5*), 0, "S20678C7");
    check_base_class_offset(lv, (S20677C3*)(S20678C9*), ABISELECT(144,100), "S20678C7");
    check_base_class_offset(lv, (S20678C9*), ABISELECT(144,100), "S20678C7");
    check_field_offset(lv, s20678c7f0, ABISELECT(296,212), "S20678C7.s20678c7f0");
    check_field_offset(lv, s20678c7f1, ABISELECT(304,216), "S20678C7.s20678c7f1");
    check_field_offset(lv, s20678c7f2, ABISELECT(464,328), "S20678C7.s20678c7f2");
    check_field_offset(lv, s20678c7f3, ABISELECT(472,332), "S20678C7.s20678c7f3");
    check_field_offset(lv, s20678c7f4, ABISELECT(480,340), "S20678C7.s20678c7f4");
    check_field_offset(lv, s20678c7f5, ABISELECT(496,352), "S20678C7.s20678c7f5");
    test_class_info(&lv, &cd_S20678C7);
    dp->~S20678C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C7(Test_S20678C7, "S20678C7", ABISELECT(832,584));

#else // __cplusplus

extern void _ZN8S20678C7C1Ev();
extern void _ZN8S20678C7D1Ev();
Name_Map name_map_S20678C7[] = {
  NSPAIR(_ZN8S20678C7C1Ev),
  NSPAIR(_ZN8S20678C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20678C8;
extern VTBL_ENTRY _ZTI8S20678C8[];
extern  VTBL_ENTRY _ZTV8S20678C8[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C9;
extern VTBL_ENTRY _ZTI8S20678C9[];
static Base_Class bases_S20678C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20678C8,    ABISELECT(512,360), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C3,    ABISELECT(784,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20678C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C3,    ABISELECT(144,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20678C9,    ABISELECT(144,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20678C7[];
extern void _ZN8S20678C72v9Ev();
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY vtc_S20678C7[] = {
  ABISELECT(512,360),
  ABISELECT(784,544),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C7[0]),
  (VTBL_ENTRY)&_ZN8S20678C72v9Ev,
  0,
  ABISELECT(-512,-360),
  (VTBL_ENTRY)&(_ZTI8S20678C7[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern VTBL_ENTRY _ZTV8S20678C7[];
static  VTBL_ENTRY _tg__ZTV8S20678C5__8S20678C7[] = {
  ABISELECT(784,544),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C7[] = {
  {&(_ZTV8S20678C7[4]),  4,9},
  {&(_tg__ZTV8S20678C5__8S20678C7[3]),  3,3},
  {&(_ZTV8S20678C7[8]),  8,9},
};
extern VTBL_ENTRY _ZTI8S20678C7[];
extern  VTBL_ENTRY _ZTV8S20678C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C7[];
Class_Descriptor cd_S20678C7 = {  "S20678C7", // class name
  bases_S20678C7, 5,
  &(vtc_S20678C7[0]), // expected_vtbl_contents
  &(vtt_S20678C7[0]), // expected_vtt_contents
  ABISELECT(832,584), // object size
  NSPAIRA(_ZTI8S20678C7),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S20678C7),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20678C7),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C12  : virtual S20677C3 , virtual S20678C5 {
  int s20678c12f0;
  ::S20678C5 s20678c12f1;
  __tsi64 s20678c12f2;
  int s20678c12f3;
  void *s20678c12f4;
  virtual void  v10(); // _ZN9S20678C123v10Ev
  virtual void  v11(); // _ZN9S20678C123v11Ev
  ~S20678C12(); // tgen
  S20678C12(); // tgen
};
//SIG(-1 S20678C12) C1{ VBC2{ m Fp FL[4] Fs} VBC3{ VBC2 FD Fi FC2 FC2} v1 v2 Fi FC3 FL Fi Fp}


void  S20678C12 ::v10(){vfunc_called(this, "_ZN9S20678C123v10Ev");}
void  S20678C12 ::v11(){vfunc_called(this, "_ZN9S20678C123v11Ev");}
S20678C12 ::~S20678C12(){ note_dtor("S20678C12", this);} // tgen
S20678C12 ::S20678C12(){ note_ctor("S20678C12", this);} // tgen

static void Test_S20678C12()
{
  extern Class_Descriptor cd_S20678C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(28,77)];
    init_test(&cd_S20678C12, buf);
    S20678C12 *dp, &lv = *(dp=new (buf) S20678C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,304), "sizeof(S20678C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C12)");
    check_base_class_offset(lv, (S20677C3*), ABISELECT(232,164), "S20678C12");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(232,164), "S20678C12");
    check_base_class_offset(lv, (S20678C5*), ABISELECT(288,204), "S20678C12");
    check_field_offset(lv, s20678c12f0, ABISELECT(8,4), "S20678C12.s20678c12f0");
    check_field_offset(lv, s20678c12f1, ABISELECT(16,8), "S20678C12.s20678c12f1");
    check_field_offset(lv, s20678c12f2, ABISELECT(208,148), "S20678C12.s20678c12f2");
    check_field_offset(lv, s20678c12f3, ABISELECT(216,156), "S20678C12.s20678c12f3");
    check_field_offset(lv, s20678c12f4, ABISELECT(224,160), "S20678C12.s20678c12f4");
    test_class_info(&lv, &cd_S20678C12);
    dp->~S20678C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C12(Test_S20678C12, "S20678C12", ABISELECT(432,304));

#else // __cplusplus

extern void _ZN9S20678C12C1Ev();
extern void _ZN9S20678C12D1Ev();
Name_Map name_map_S20678C12[] = {
  NSPAIR(_ZN9S20678C12C1Ev),
  NSPAIR(_ZN9S20678C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
static Base_Class bases_S20678C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(232,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C5,    ABISELECT(288,204), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C12[];
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY vtc_S20678C12[] = {
  ABISELECT(288,204),
  ABISELECT(232,164),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  ABISELECT(-56,-40),
  ABISELECT(-288,-204),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
extern VTBL_ENTRY _ZTV9S20678C12[];
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C12[] = {
  {&(_ZTV9S20678C12[4]),  4,9},
  {&(_ZTV9S20678C12[9]),  9,9},
  {&(_tg__ZTV8S20678C5__9S20678C12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
Class_Descriptor cd_S20678C12 = {  "S20678C12", // class name
  bases_S20678C12, 2,
  &(vtc_S20678C12[0]), // expected_vtbl_contents
  &(vtt_S20678C12[0]), // expected_vtt_contents
  ABISELECT(432,304), // object size
  NSPAIRA(_ZTI9S20678C12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20678C12),9, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C12),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C11  : virtual S20678C4 , virtual S20678C2 , virtual S20678C12 {
  ::S20677C6_nt s20678c11f0;
  ::S20677C6_nt s20678c11f1;
  int s20678c11f2;
  ::S20678C5 s20678c11f3;
  ::S20677C6_nt s20678c11f4;
  ::S20677C6_nt s20678c11f5;
  ::S20678C8 s20678c11f6;
  ::S20678C2 s20678c11f7;
  void *s20678c11f8;
  ::S20677C6_nt s20678c11f9;
  virtual void  v12(); // _ZN9S20678C113v12Ev
  virtual void  v13(); // _ZN9S20678C113v13Ev
  ~S20678C11(); // tgen
  S20678C11(); // tgen
};
//SIG(-1 S20678C11) C1{ VBC2{ VBC3{ m Fp FL[4] Fs} BC4{ VBC3 FD Fi FC3 FC3} v3 v4 v5 Fs FL Fc Fi[2] FC4 Fp FL Fi FL Fi} VBC5{ VBC3 VBC2 v6 v7 v8 FL FC6{} Fp Fc[2] FC3 Fl FC6} VBC7{ VBC3 VBC4 v9 v10 Fi FC4 FL Fi Fp} v1 v2 FC6 FC6 Fi FC4 FC6 FC6 FC8{ v11 FC6 FC4 FC6 FL FC6 Fp FC6 Fp[2] FC6} FC5 Fp FC6}


void  S20678C11 ::v12(){vfunc_called(this, "_ZN9S20678C113v12Ev");}
void  S20678C11 ::v13(){vfunc_called(this, "_ZN9S20678C113v13Ev");}
S20678C11 ::~S20678C11(){ note_dtor("S20678C11", this);} // tgen
S20678C11 ::S20678C11(){ note_ctor("S20678C11", this);} // tgen

static void Test_S20678C11()
{
  extern Class_Descriptor cd_S20678C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(128,356)];
    init_test(&cd_S20678C11, buf);
    S20678C11 *dp, &lv = *(dp=new (buf) S20678C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2032,1420), "sizeof(S20678C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C11)");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*), ABISELECT(1496,1044), "S20678C11");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*), ABISELECT(1496,1044), "S20678C11");
    check_base_class_offset(lv, (S20677C3*)(S20678C2*), ABISELECT(1496,1044), "S20678C11");
    check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(1496,1044), "S20678C11");
    /*is_ambiguous_... S20678C11::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(1496,1044), "S20678C11");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*), ABISELECT(1088,752), "S20678C11");
    check_base_class_offset(lv, (S20678C4*), ABISELECT(1088,752), "S20678C11");
    check_base_class_offset(lv, (S20678C4*)(S20678C2*), ABISELECT(1088,752), "S20678C11");
    check_base_class_offset(lv, (S20678C2*), ABISELECT(1544,1084), "S20678C11");
    check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(1888,1320), "S20678C11");
    check_base_class_offset(lv, (S20678C12*), ABISELECT(1648,1156), "S20678C11");
    check_field_offset(lv, s20678c11f0, ABISELECT(8,4), "S20678C11.s20678c11f0");
    check_field_offset(lv, s20678c11f1, ABISELECT(9,5), "S20678C11.s20678c11f1");
    check_field_offset(lv, s20678c11f2, ABISELECT(12,8), "S20678C11.s20678c11f2");
    check_field_offset(lv, s20678c11f3, ABISELECT(16,12), "S20678C11.s20678c11f3");
    check_field_offset(lv, s20678c11f4, ABISELECT(208,152), "S20678C11.s20678c11f4");
    check_field_offset(lv, s20678c11f5, ABISELECT(209,153), "S20678C11.s20678c11f5");
    check_field_offset(lv, s20678c11f6, ABISELECT(224,156), "S20678C11.s20678c11f6");
    check_field_offset(lv, s20678c11f7, ABISELECT(496,340), "S20678C11.s20678c11f7");
    check_field_offset(lv, s20678c11f8, ABISELECT(1072,744), "S20678C11.s20678c11f8");
    check_field_offset(lv, s20678c11f9, ABISELECT(1080,748), "S20678C11.s20678c11f9");
    test_class_info(&lv, &cd_S20678C11);
    dp->~S20678C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C11(Test_S20678C11, "S20678C11", ABISELECT(2032,1420));

#else // __cplusplus

extern void _ZN9S20678C11C1Ev();
extern void _ZN9S20678C11D1Ev();
Name_Map name_map_S20678C11[] = {
  NSPAIR(_ZN9S20678C11C1Ev),
  NSPAIR(_ZN9S20678C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C2;
extern VTBL_ENTRY _ZTI8S20678C2[];
extern  VTBL_ENTRY _ZTV8S20678C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C2[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
static Base_Class bases_S20678C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(1496,1044), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(1088,752), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(1088,752), //bcp->offset
    9, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C2,    ABISELECT(1544,1084), //bcp->offset
    18, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C5,    ABISELECT(1888,1320), //bcp->offset
    36, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20678C12,    ABISELECT(1648,1156), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C11[];
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY vtc_S20678C11[] = {
  ABISELECT(1888,1320),
  ABISELECT(1648,1156),
  ABISELECT(1544,1084),
  ABISELECT(1496,1044),
  ABISELECT(1088,752),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-1544,-1084),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-1648,-1156),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  ABISELECT(-392,-276),
  ABISELECT(-1888,-1320),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
};
extern VTBL_ENTRY _ZTV9S20678C11[];
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C11[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C4__9S20678C11[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C11[] = {
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__8S20678C2__9S20678C11[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(456,332),
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C11[] = {
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__9S20678C11[] = {
  ABISELECT(-392,-276),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C11[] = {
  ABISELECT(-392,-276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C11[] = {
  {&(_ZTV9S20678C11[7]),  7,39},
  {&(_ZTV9S20678C11[15]),  15,39},
  {&(_ZTV9S20678C11[25]),  25,39},
  {&(_ZTV9S20678C11[34]),  34,39},
  {&(_ZTV9S20678C11[39]),  39,39},
  {&(_tg__ZTV8S20678C4__9S20678C11[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C4__9S20678C11[3]),  3,3},
  {&(_tg__ZTV8S20678C2__9S20678C11[4]),  4,7},
  {&(_tg__ZTV8S20678C4__8S20678C2__9S20678C11[6]),  6,9},
  {&(_tg__ZTV9S20678C12__9S20678C11[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__9S20678C11[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A1__9S20678C11[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20678C11[];
extern  VTBL_ENTRY _ZTV9S20678C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C11[];
Class_Descriptor cd_S20678C11 = {  "S20678C11", // class name
  bases_S20678C11, 6,
  &(vtc_S20678C11[0]), // expected_vtbl_contents
  &(vtt_S20678C11[0]), // expected_vtt_contents
  ABISELECT(2032,1420), // object size
  NSPAIRA(_ZTI9S20678C11),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20678C11),39, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C11),12, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C13  : virtual S20678C5 , S20678C11 , S20678C12 {
  int s20678c13f0;
  char s20678c13f1:2;
  ::S20677C6_nt s20678c13f2;
  int s20678c13f3;
  ~S20678C13(); // tgen
  S20678C13(); // tgen
};
//SIG(-1 S20678C13) C1{ VBC2{ VBC3{ m Fp FL[4] Fs} FD Fi FC3 FC3} BC4{ VBC5{ VBC3 BC2 v1 v2 v3 Fs FL Fc Fi[2] FC2 Fp FL Fi FL Fi} VBC6{ VBC3 VBC5 v4 v5 v6 FL FC7{} Fp Fc[2] FC3 Fl FC7} VBC8{ VBC3 VBC2 v7 v8 Fi FC2 FL Fi Fp} v9 v10 FC7 FC7 Fi FC2 FC7 FC7 FC9{ v11 FC7 FC2 FC7 FL FC7 Fp FC7 Fp[2] FC7} FC6 Fp FC7} BC8 Fi Fc:2 FC7 Fi}


S20678C13 ::~S20678C13(){ note_dtor("S20678C13", this);} // tgen
S20678C13 ::S20678C13(){ note_ctor("S20678C13", this);} // tgen

static void Test_S20678C13()
{
  extern Class_Descriptor cd_S20678C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(144,400)];
    init_test(&cd_S20678C13, buf);
    S20678C13 *dp, &lv = *(dp=new (buf) S20678C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2288,1596), "sizeof(S20678C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C13)");
    /*is_ambiguous_... S20678C13::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(1480,1028), "S20678C13");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*), ABISELECT(1480,1028), "S20678C13");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*), ABISELECT(1480,1028), "S20678C13");
    check_base_class_offset(lv, (S20677C3*)(S20678C2*), ABISELECT(1480,1028), "S20678C13");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(1480,1028), "S20678C13");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(1480,1028), "S20678C13");
    /*is_ambiguous_... S20678C13::S20678C5 */ AMB_check_base_class_offset(lv, (S20678C5*), ABISELECT(1344,928), "S20678C13");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(1344,928), "S20678C13");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(1344,928), "S20678C13");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*), ABISELECT(1536,1068), "S20678C13");
    check_base_class_offset(lv, (S20678C4*)(S20678C11*), ABISELECT(1536,1068), "S20678C13");
    check_base_class_offset(lv, (S20678C4*)(S20678C2*), ABISELECT(1536,1068), "S20678C13");
    check_base_class_offset(lv, (S20678C2*)(S20678C11*), ABISELECT(1944,1360), "S20678C13");
    check_base_class_offset(lv, (S20678C12*)(S20678C11*), ABISELECT(2048,1432), "S20678C13");
    check_base_class_offset(lv, (S20678C11*), 0, "S20678C13");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C12*), ABISELECT(1088,752), "S20678C13");
    check_field_offset(lv, s20678c13f0, ABISELECT(1320,916), "S20678C13.s20678c13f0");
    set_bf_and_test(lv, s20678c13f1, ABISELECT(1324,920), 0, 2, 1, "S20678C13");
    set_bf_and_test(lv, s20678c13f1, ABISELECT(1324,920), 0, 2, hide_sll(1LL<<1), "S20678C13");
    check_field_offset(lv, s20678c13f2, ABISELECT(1325,921), "S20678C13.s20678c13f2");
    check_field_offset(lv, s20678c13f3, ABISELECT(1328,924), "S20678C13.s20678c13f3");
    test_class_info(&lv, &cd_S20678C13);
    dp->~S20678C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C13(Test_S20678C13, "S20678C13", ABISELECT(2288,1596));

#else // __cplusplus

extern void _ZN9S20678C13C1Ev();
extern void _ZN9S20678C13D1Ev();
Name_Map name_map_S20678C13[] = {
  NSPAIR(_ZN9S20678C13C1Ev),
  NSPAIR(_ZN9S20678C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C2;
extern VTBL_ENTRY _ZTI8S20678C2[];
extern  VTBL_ENTRY _ZTV8S20678C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C2[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C11;
extern VTBL_ENTRY _ZTI9S20678C11[];
extern  VTBL_ENTRY _ZTV9S20678C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C11[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
static Base_Class bases_S20678C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(1480,1028), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(1344,928), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C5,    ABISELECT(1536,1068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(1536,1068), //bcp->offset
    18, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20678C2,    ABISELECT(1944,1360), //bcp->offset
    27, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20678C12,    ABISELECT(2048,1432), //bcp->offset
    37, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20678C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20678C12,    ABISELECT(1088,752), //bcp->offset
    9, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C13[];
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY vtc_S20678C13[] = {
  ABISELECT(1344,928),
  ABISELECT(2048,1432),
  ABISELECT(1944,1360),
  ABISELECT(1480,1028),
  ABISELECT(1536,1068),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  ABISELECT(256,176),
  ABISELECT(392,276),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  ABISELECT(136,100),
  ABISELECT(-1344,-928),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-1536,-1068),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  ABISELECT(-1944,-1360),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
  0,
  0,
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  ABISELECT(-2048,-1432),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
extern VTBL_ENTRY _ZTV9S20678C13[];
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C11__9S20678C13[] = {
  ABISELECT(1344,928),
  ABISELECT(2048,1432),
  ABISELECT(1944,1360),
  ABISELECT(1480,1028),
  ABISELECT(1536,1068),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C11__9S20678C13[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-1536,-1068),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C11__9S20678C13[] = {
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  ABISELECT(-1944,-1360),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C11__9S20678C13[] = {
  0,
  0,
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  ABISELECT(-2048,-1432),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C11__9S20678C13[] = {
  ABISELECT(136,100),
  ABISELECT(-1344,-928),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__A__9S20678C13[] = {
  ABISELECT(256,176),
  ABISELECT(392,276),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__A__9S20678C13[] = {
  ABISELECT(136,100),
  ABISELECT(-256,-176),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C13[] = {
  ABISELECT(136,100),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C13[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C4__A1__9S20678C13[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C13[] = {
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__8S20678C2__9S20678C13[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(408,292),
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C13[] = {
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__9S20678C13[] = {
  ABISELECT(136,100),
  ABISELECT(704,504),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTT_ENTRY vtt_S20678C13[] = {
  {&(_ZTV9S20678C13[7]),  7,45},
  {&(_tg__ZTV9S20678C11__9S20678C13[7]),  7,9},
  {&(_tg__ZTV8S20678C4__9S20678C11__9S20678C13[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C11__9S20678C13[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C11__9S20678C13[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C11__9S20678C13[3]),  3,3},
  {&(_tg__ZTV9S20678C12__A__9S20678C13[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__A__9S20678C13[3]),  3,3},
  {&(_ZTV9S20678C13[18]),  18,45},
  {&(_ZTV9S20678C13[24]),  24,45},
  {&(_ZTV9S20678C13[34]),  34,45},
  {&(_ZTV9S20678C13[43]),  43,45},
  {&(_ZTV9S20678C13[13]),  13,45},
  {&(_tg__ZTV8S20678C5__9S20678C13[3]),  3,3},
  {&(_tg__ZTV8S20678C4__9S20678C13[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C4__A1__9S20678C13[3]),  3,3},
  {&(_tg__ZTV8S20678C2__9S20678C13[4]),  4,7},
  {&(_tg__ZTV8S20678C4__8S20678C2__9S20678C13[6]),  6,9},
  {&(_tg__ZTV9S20678C12__9S20678C13[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__9S20678C13[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20678C13[];
extern  VTBL_ENTRY _ZTV9S20678C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C13[];
Class_Descriptor cd_S20678C13 = {  "S20678C13", // class name
  bases_S20678C13, 8,
  &(vtc_S20678C13[0]), // expected_vtbl_contents
  &(vtt_S20678C13[0]), // expected_vtt_contents
  ABISELECT(2288,1596), // object size
  NSPAIRA(_ZTI9S20678C13),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20678C13),45, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C13),20, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C16  : S20678C5 {
  __tsi64 s20678c16f0;
  char s20678c16f1[7];
  void *s20678c16f2;
  int s20678c16f3;
  ::S20677C6_nt s20678c16f4;
  ::S20677C6_nt s20678c16f5;
  char s20678c16f6[10];
  virtual void  v15(); // _ZN9S20678C163v15Ev
  ~S20678C16(); // tgen
  S20678C16(); // tgen
};
//SIG(-1 S20678C16) C1{ BC2{ VBC3{ m Fp FL[4] Fs} FD Fi FC3 FC3} v1 FL Fc[7] Fp Fi FC4{} FC4 Fc[10]}


void  S20678C16 ::v15(){vfunc_called(this, "_ZN9S20678C163v15Ev");}
S20678C16 ::~S20678C16(){ note_dtor("S20678C16", this);} // tgen
S20678C16 ::S20678C16(){ note_ctor("S20678C16", this);} // tgen

static void Test_S20678C16()
{
  extern Class_Descriptor cd_S20678C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(15,45)];
    init_test(&cd_S20678C16, buf);
    S20678C16 *dp, &lv = *(dp=new (buf) S20678C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,176), "sizeof(S20678C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C16)");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(176,136), "S20678C16");
    check_base_class_offset(lv, (S20678C5*), 0, "S20678C16");
    check_field_offset(lv, s20678c16f0, ABISELECT(136,100), "S20678C16.s20678c16f0");
    check_field_offset(lv, s20678c16f1, ABISELECT(144,108), "S20678C16.s20678c16f1");
    check_field_offset(lv, s20678c16f2, ABISELECT(152,116), "S20678C16.s20678c16f2");
    check_field_offset(lv, s20678c16f3, ABISELECT(160,120), "S20678C16.s20678c16f3");
    check_field_offset(lv, s20678c16f4, ABISELECT(164,124), "S20678C16.s20678c16f4");
    check_field_offset(lv, s20678c16f5, ABISELECT(165,125), "S20678C16.s20678c16f5");
    check_field_offset(lv, s20678c16f6, ABISELECT(166,126), "S20678C16.s20678c16f6");
    test_class_info(&lv, &cd_S20678C16);
    dp->~S20678C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C16(Test_S20678C16, "S20678C16", ABISELECT(224,176));

#else // __cplusplus

extern void _ZN9S20678C16C1Ev();
extern void _ZN9S20678C16D1Ev();
Name_Map name_map_S20678C16[] = {
  NSPAIR(_ZN9S20678C16C1Ev),
  NSPAIR(_ZN9S20678C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
static Base_Class bases_S20678C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(176,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20678C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C16[];
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY vtc_S20678C16[] = {
  ABISELECT(176,136),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C16[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern VTBL_ENTRY _ZTV9S20678C16[];
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C16[] = {
  ABISELECT(176,136),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C16[] = {
  {&(_ZTV9S20678C16[3]),  3,4},
  {&(_tg__ZTV8S20678C5__9S20678C16[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20678C16[];
extern  VTBL_ENTRY _ZTV9S20678C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C16[];
Class_Descriptor cd_S20678C16 = {  "S20678C16", // class name
  bases_S20678C16, 2,
  &(vtc_S20678C16[0]), // expected_vtbl_contents
  &(vtt_S20678C16[0]), // expected_vtt_contents
  ABISELECT(224,176), // object size
  NSPAIRA(_ZTI9S20678C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S20678C16),4, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C16),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C15  : S20678C4 , virtual S20678C12 , S20678C5 , virtual S20678C8 , virtual S20678C16 {
  long s20678c15f0;
  __tsi64 s20678c15f1;
  long double s20678c15f2;
  ::S20677C6_nt s20678c15f3;
  virtual void  v16(); // _ZN9S20678C153v16Ev
  ~S20678C15(); // tgen
  S20678C15(); // tgen
};
//SIG(-1 S20678C15) C1{ BC2{ VBC3{ m Fp FL[4] Fs} BC4{ VBC3 FD Fi FC3 FC3} v2 v3 v4 Fs FL Fc Fi[2] FC4 Fp FL Fi FL Fi} VBC5{ VBC3 VBC4 v5 v6 Fi FC4 FL Fi Fp} BC4 VBC6{ v7 FC7{} FC4 FC7 FL FC7 Fp FC7 Fp[2] FC7} VBC8{ BC4 v8 FL Fc[7] Fp Fi FC7 FC7 Fc[10]} v1 Fl FL FD FC7}


void  S20678C15 ::v16(){vfunc_called(this, "_ZN9S20678C153v16Ev");}
S20678C15 ::~S20678C15(){ note_dtor("S20678C15", this);} // tgen
S20678C15 ::S20678C15(){ note_ctor("S20678C15", this);} // tgen

static void Test_S20678C15()
{
  extern Class_Descriptor cd_S20678C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(94,262)];
    init_test(&cd_S20678C15, buf);
    S20678C15 *dp, &lv = *(dp=new (buf) S20678C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1488,1044), "sizeof(S20678C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C15)");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*), ABISELECT(600,420), "S20678C15");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*), ABISELECT(600,420), "S20678C15");
    check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(600,420), "S20678C15");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(600,420), "S20678C15");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(600,420), "S20678C15");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C16*), ABISELECT(600,420), "S20678C15");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*), 0, "S20678C15");
    check_base_class_offset(lv, (S20678C4*), 0, "S20678C15");
    check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(896,624), "S20678C15");
    check_base_class_offset(lv, (S20678C12*), ABISELECT(656,460), "S20678C15");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20678C5*), ABISELECT(416,292), "S20678C15");
    check_base_class_offset(lv, (S20678C8*), ABISELECT(1040,724), "S20678C15");
    check_base_class_offset(lv, (S20678C5*)(S20678C16*), ABISELECT(1312,908), "S20678C15");
    check_base_class_offset(lv, (S20678C16*), ABISELECT(1312,908), "S20678C15");
    check_field_offset(lv, s20678c15f0, ABISELECT(552,392), "S20678C15.s20678c15f0");
    check_field_offset(lv, s20678c15f1, ABISELECT(560,396), "S20678C15.s20678c15f1");
    check_field_offset(lv, s20678c15f2, ABISELECT(576,404), "S20678C15.s20678c15f2");
    check_field_offset(lv, s20678c15f3, ABISELECT(592,416), "S20678C15.s20678c15f3");
    test_class_info(&lv, &cd_S20678C15);
    dp->~S20678C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C15(Test_S20678C15, "S20678C15", ABISELECT(1488,1044));

#else // __cplusplus

extern void _ZN9S20678C15C1Ev();
extern void _ZN9S20678C15D1Ev();
Name_Map name_map_S20678C15[] = {
  NSPAIR(_ZN9S20678C15C1Ev),
  NSPAIR(_ZN9S20678C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C8;
extern VTBL_ENTRY _ZTI8S20678C8[];
extern  VTBL_ENTRY _ZTV8S20678C8[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C16;
extern VTBL_ENTRY _ZTI9S20678C16[];
extern  VTBL_ENTRY _ZTV9S20678C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C16[];
static Base_Class bases_S20678C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(600,420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20678C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20678C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20678C5,    ABISELECT(896,624), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20678C12,    ABISELECT(656,460), //bcp->offset
    14, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C5,    ABISELECT(416,292), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20678C8,    ABISELECT(1040,724), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C5,    ABISELECT(1312,908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20678C16,    ABISELECT(1312,908), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C15[];
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN8S20678C82v8Ev();
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY vtc_S20678C15[] = {
  ABISELECT(1312,908),
  ABISELECT(1040,724),
  ABISELECT(896,624),
  ABISELECT(656,460),
  ABISELECT(600,420),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
  ABISELECT(184,128),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-56,-40),
  ABISELECT(-656,-460),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  ABISELECT(-296,-204),
  ABISELECT(-896,-624),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  0,
  ABISELECT(-1040,-724),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
  0,
  ABISELECT(-712,-488),
  ABISELECT(-1312,-908),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern VTBL_ENTRY _ZTV9S20678C15[];
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C15[] = {
  ABISELECT(600,420),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C4__9S20678C15[] = {
  ABISELECT(600,420),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A__9S20678C15[] = {
  ABISELECT(184,128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C15[] = {
  ABISELECT(240,164),
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__9S20678C15[] = {
  ABISELECT(-296,-204),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C15[] = {
  ABISELECT(-296,-204),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C15[] = {
  ABISELECT(-712,-488),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C16[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C16__A3__9S20678C15[] = {
  ABISELECT(-712,-488),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C15[] = {
  {&(_ZTV9S20678C15[7]),  7,34},
  {&(_tg__ZTV8S20678C4__9S20678C15[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C4__9S20678C15[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A__9S20678C15[3]),  3,3},
  {&(_ZTV9S20678C15[20]),  20,34},
  {&(_ZTV9S20678C15[25]),  25,34},
  {&(_ZTV9S20678C15[14]),  14,34},
  {&(_ZTV9S20678C15[28]),  28,34},
  {&(_ZTV9S20678C15[33]),  33,34},
  {&(_tg__ZTV9S20678C12__9S20678C15[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__9S20678C15[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A1__9S20678C15[3]),  3,3},
  {&(_tg__ZTV9S20678C16__9S20678C15[3]),  3,4},
  {&(_tg__ZTV8S20678C59S20678C16__A3__9S20678C15[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20678C15[];
extern  VTBL_ENTRY _ZTV9S20678C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C15[];
Class_Descriptor cd_S20678C15 = {  "S20678C15", // class name
  bases_S20678C15, 9,
  &(vtc_S20678C15[0]), // expected_vtbl_contents
  &(vtt_S20678C15[0]), // expected_vtt_contents
  ABISELECT(1488,1044), // object size
  NSPAIRA(_ZTI9S20678C15),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20678C15),34, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C15),14, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C17  : virtual S20678C8 {
  ::S20678C15 s20678c17f0;
  ::S20677C6_nt s20678c17f1;
  __tsi64 s20678c17f2;
  int s20678c17f3[2];
  virtual void  v22(); // _ZN9S20678C173v22Ev
  ~S20678C17(); // tgen
  S20678C17(); // tgen
};
//SIG(-1 S20678C17) C1{ VBC2{ v2 FC3{} FC4{ VBC5{ m Fp FL[4] Fs} FD Fi FC5 FC5} FC3 FL FC3 Fp FC3 Fp[2] FC3} v1 FC6{ BC7{ VBC5 BC4 v4 v5 v6 Fs FL Fc Fi[2] FC4 Fp FL Fi FL Fi} VBC8{ VBC5 VBC4 v7 v8 Fi FC4 FL Fi Fp} BC4 VBC2 VBC9{ BC4 v9 FL Fc[7] Fp Fi FC3 FC3 Fc[10]} v3 Fl FL FD FC3} FC3 FL Fi[2]}


void  S20678C17 ::v22(){vfunc_called(this, "_ZN9S20678C173v22Ev");}
S20678C17 ::~S20678C17(){ note_dtor("S20678C17", this);} // tgen
S20678C17 ::S20678C17(){ note_ctor("S20678C17", this);} // tgen

static void Test_S20678C17()
{
  extern Class_Descriptor cd_S20678C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(114,314)];
    init_test(&cd_S20678C17, buf);
    S20678C17 *dp, &lv = *(dp=new (buf) S20678C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1808,1252), "sizeof(S20678C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C17)");
    check_base_class_offset(lv, (S20678C8*), ABISELECT(1536,1068), "S20678C17");
    check_field_offset(lv, s20678c17f0, ABISELECT(16,4), "S20678C17.s20678c17f0");
    check_field_offset(lv, s20678c17f1, ABISELECT(1504,1048), "S20678C17.s20678c17f1");
    check_field_offset(lv, s20678c17f2, ABISELECT(1512,1052), "S20678C17.s20678c17f2");
    check_field_offset(lv, s20678c17f3, ABISELECT(1520,1060), "S20678C17.s20678c17f3");
    test_class_info(&lv, &cd_S20678C17);
    dp->~S20678C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C17(Test_S20678C17, "S20678C17", ABISELECT(1808,1252));

#else // __cplusplus

extern void _ZN9S20678C17C1Ev();
extern void _ZN9S20678C17D1Ev();
Name_Map name_map_S20678C17[] = {
  NSPAIR(_ZN9S20678C17C1Ev),
  NSPAIR(_ZN9S20678C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20678C8;
extern VTBL_ENTRY _ZTI8S20678C8[];
extern  VTBL_ENTRY _ZTV8S20678C8[];
static Base_Class bases_S20678C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20678C8,    ABISELECT(1536,1068), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C17[];
extern void _ZN9S20678C173v22Ev();
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY vtc_S20678C17[] = {
  ABISELECT(1536,1068),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C17[0]),
  (VTBL_ENTRY)&_ZN9S20678C173v22Ev,
  0,
  ABISELECT(-1536,-1068),
  (VTBL_ENTRY)&(_ZTI9S20678C17[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern VTBL_ENTRY _ZTV9S20678C17[];
static  VTT_ENTRY vtt_S20678C17[] = {
  {&(_ZTV9S20678C17[3]),  3,8},
  {&(_ZTV9S20678C17[7]),  7,8},
};
extern VTBL_ENTRY _ZTI9S20678C17[];
extern  VTBL_ENTRY _ZTV9S20678C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C17[];
Class_Descriptor cd_S20678C17 = {  "S20678C17", // class name
  bases_S20678C17, 1,
  &(vtc_S20678C17[0]), // expected_vtbl_contents
  &(vtt_S20678C17[0]), // expected_vtt_contents
  ABISELECT(1808,1252), // object size
  NSPAIRA(_ZTI9S20678C17),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S20678C17),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C17),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C14  : S20678C15 , S20678C17 , S20678C13 {
  void *s20678c14f0;
  __tsi64 s20678c14f1;
  int s20678c14f2;
  void *s20678c14f3;
  int s20678c14f4[3];
  char s20678c14f5;
  __tsi64 s20678c14f6;
  void *s20678c14f7;
  long double s20678c14f8;
  ~S20678C14(); // tgen
  S20678C14(); // tgen
};
//SIG(-1 S20678C14) C1{ BC2{ BC3{ VBC4{ m Fp FL[4] Fs} BC5{ VBC4 FD Fi FC4 FC4} v1 v2 v3 Fs FL Fc Fi[2] FC5 Fp FL Fi FL Fi} VBC6{ VBC4 VBC5 v4 v5 Fi FC5 FL Fi Fp} BC5 VBC7{ v6 FC8{} FC5 FC8 FL FC8 Fp FC8 Fp[2] FC8} VBC9{ BC5 v7 FL Fc[7] Fp Fi FC8 FC8 Fc[10]} v8 Fl FL FD FC8} BC10{ VBC7 v9 FC2 FC8 FL Fi[2]} BC11{ VBC5 BC12{ VBC3 VBC13{ VBC4 VBC3 v10 v11 v12 FL FC8 Fp Fc[2] FC4 Fl FC8} VBC6 v13 v14 FC8 FC8 Fi FC5 FC8 FC8 FC7 FC13 Fp FC8} BC6 Fi Fc:2 FC8 Fi} Fp FL Fi Fp Fi[3] Fc FL Fp FD}


S20678C14 ::~S20678C14(){ note_dtor("S20678C14", this);} // tgen
S20678C14 ::S20678C14(){ note_ctor("S20678C14", this);} // tgen

static void Test_S20678C14()
{
  extern Class_Descriptor cd_S20678C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(311,867)];
    init_test(&cd_S20678C14, buf);
    S20678C14 *dp, &lv = *(dp=new (buf) S20678C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4960,3464), "sizeof(S20678C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C14)");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*)(S20678C15*), ABISELECT(3568,2476), "S20678C14");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*)(S20678C15*), ABISELECT(3568,2476), "S20678C14");
    /*is_ambiguous_... S20678C14::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(3568,2476), "S20678C14");
    /*is_ambiguous_... S20678C14::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(3568,2476), "S20678C14");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C15*), ABISELECT(3568,2476), "S20678C14");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C16*), ABISELECT(3568,2476), "S20678C14");
    /*is_ambiguous_... S20678C14::S20678C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C4*), ABISELECT(3568,2476), "S20678C14");
    /*is_ambiguous_... S20678C14::S20678C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*), ABISELECT(3568,2476), "S20678C14");
    check_base_class_offset(lv, (S20677C3*)(S20678C2*), ABISELECT(3568,2476), "S20678C14");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*)(S20678C13*), ABISELECT(3568,2476), "S20678C14");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*)(S20678C15*), 0, "S20678C14");
    check_base_class_offset(lv, (S20678C4*)(S20678C15*), 0, "S20678C14");
    /*is_ambiguous_... S20678C14::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(3856,2680), "S20678C14");
    /*is_ambiguous_... S20678C13::S20678C5 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C13*), ABISELECT(3856,2680), "S20678C14");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*)(S20678C13*), ABISELECT(3856,2680), "S20678C14");
    check_base_class_offset(lv, (S20678C12*)(S20678C15*), ABISELECT(3616,2516), "S20678C14");
    check_base_class_offset(lv, (S20678C12*)(S20678C11*)(S20678C13*), ABISELECT(3616,2516), "S20678C14");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C15*), ABISELECT(416,292), "S20678C14");
    check_base_class_offset(lv, (S20678C8*)(S20678C15*), ABISELECT(4000,2780), "S20678C14");
    check_base_class_offset(lv, (S20678C8*)(S20678C17*), ABISELECT(4000,2780), "S20678C14");
    check_base_class_offset(lv, (S20678C5*)(S20678C16*), ABISELECT(4272,2964), "S20678C14");
    check_base_class_offset(lv, (S20678C16*)(S20678C15*), ABISELECT(4272,2964), "S20678C14");
    check_base_class_offset(lv, (S20678C15*), 0, "S20678C14");
    check_base_class_offset(lv, (S20678C17*), ABISELECT(608,420), "S20678C14");
    /*is_ambiguous_... S20678C14::S20678C4 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C4*), ABISELECT(4448,3100), "S20678C14");
    check_base_class_offset(lv, (S20678C4*)(S20678C11*)(S20678C13*), ABISELECT(4448,3100), "S20678C14");
    check_base_class_offset(lv, (S20678C4*)(S20678C2*), ABISELECT(4448,3100), "S20678C14");
    check_base_class_offset(lv, (S20678C2*)(S20678C11*)(S20678C13*), ABISELECT(4856,3392), "S20678C14");
    check_base_class_offset(lv, (S20678C11*)(S20678C13*), ABISELECT(2144,1488), "S20678C14");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C12*)(S20678C13*), ABISELECT(3232,2240), "S20678C14");
    check_base_class_offset(lv, (S20678C13*), ABISELECT(2144,1488), "S20678C14");
    check_field_offset(lv, s20678c14f0, ABISELECT(3480,2416), "S20678C14.s20678c14f0");
    check_field_offset(lv, s20678c14f1, ABISELECT(3488,2420), "S20678C14.s20678c14f1");
    check_field_offset(lv, s20678c14f2, ABISELECT(3496,2428), "S20678C14.s20678c14f2");
    check_field_offset(lv, s20678c14f3, ABISELECT(3504,2432), "S20678C14.s20678c14f3");
    check_field_offset(lv, s20678c14f4, ABISELECT(3512,2436), "S20678C14.s20678c14f4");
    check_field_offset(lv, s20678c14f5, ABISELECT(3524,2448), "S20678C14.s20678c14f5");
    check_field_offset(lv, s20678c14f6, ABISELECT(3528,2452), "S20678C14.s20678c14f6");
    check_field_offset(lv, s20678c14f7, ABISELECT(3536,2460), "S20678C14.s20678c14f7");
    check_field_offset(lv, s20678c14f8, ABISELECT(3552,2464), "S20678C14.s20678c14f8");
    test_class_info(&lv, &cd_S20678C14);
    dp->~S20678C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C14(Test_S20678C14, "S20678C14", ABISELECT(4960,3464));

#else // __cplusplus

extern void _ZN9S20678C14C1Ev();
extern void _ZN9S20678C14D1Ev();
Name_Map name_map_S20678C14[] = {
  NSPAIR(_ZN9S20678C14C1Ev),
  NSPAIR(_ZN9S20678C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C8;
extern VTBL_ENTRY _ZTI8S20678C8[];
extern  VTBL_ENTRY _ZTV8S20678C8[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C16;
extern VTBL_ENTRY _ZTI9S20678C16[];
extern  VTBL_ENTRY _ZTV9S20678C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C16[];
extern Class_Descriptor cd_S20678C15;
extern VTBL_ENTRY _ZTI9S20678C15[];
extern  VTBL_ENTRY _ZTV9S20678C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C15[];
extern Class_Descriptor cd_S20678C17;
extern VTBL_ENTRY _ZTI9S20678C17[];
extern  VTBL_ENTRY _ZTV9S20678C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C17[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C2;
extern VTBL_ENTRY _ZTI8S20678C2[];
extern  VTBL_ENTRY _ZTV8S20678C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C2[];
extern Class_Descriptor cd_S20678C11;
extern VTBL_ENTRY _ZTI9S20678C11[];
extern  VTBL_ENTRY _ZTV9S20678C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C11[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C13;
extern VTBL_ENTRY _ZTI9S20678C13[];
extern  VTBL_ENTRY _ZTV9S20678C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C13[];
static Base_Class bases_S20678C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(3568,2476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20678C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20678C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20678C5,    ABISELECT(3856,2680), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20678C12,    ABISELECT(3616,2516), //bcp->offset
    35, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(416,292), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20678C8,    ABISELECT(4000,2780), //bcp->offset
    46, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(4272,2964), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20678C16,    ABISELECT(4272,2964), //bcp->offset
    50, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20678C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20678C17,    ABISELECT(608,420), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20678C5,    ABISELECT(4448,3100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(4448,3100), //bcp->offset
    55, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S20678C2,    ABISELECT(4856,3392), //bcp->offset
    64, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S20678C11,    ABISELECT(2144,1488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20678C12,    ABISELECT(3232,2240), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20678C13,    ABISELECT(2144,1488), //bcp->offset
    20, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C14[];
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
extern void _ZN9S20678C173v22Ev();
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN8S20678C82v8Ev();
extern void _ZN9S20678C163v15Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY vtc_S20678C14[] = {
  ABISELECT(4856,3392),
  ABISELECT(4448,3100),
  ABISELECT(4272,2964),
  ABISELECT(4000,2780),
  ABISELECT(3856,2680),
  ABISELECT(3616,2516),
  ABISELECT(3568,2476),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
  ABISELECT(3152,2184),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  ABISELECT(3392,2360),
  ABISELECT(-608,-420),
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  (VTBL_ENTRY)&_ZN9S20678C173v22Ev,
  ABISELECT(1712,1192),
  ABISELECT(1472,1028),
  ABISELECT(2712,1904),
  ABISELECT(1424,988),
  ABISELECT(2304,1612),
  ABISELECT(-2144,-1488),
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  ABISELECT(624,440),
  ABISELECT(336,236),
  ABISELECT(-3232,-2240),
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-48,-40),
  ABISELECT(-3616,-2516),
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  ABISELECT(-288,-204),
  ABISELECT(-3856,-2680),
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  0,
  ABISELECT(-4000,-2780),
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
  0,
  ABISELECT(-704,-488),
  ABISELECT(-4272,-2964),
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
  0,
  0,
  0,
  ABISELECT(-880,-624),
  ABISELECT(-4448,-3100),
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-1288,-916),
  ABISELECT(-4856,-3392),
  (VTBL_ENTRY)&(_ZTI9S20678C14[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern VTBL_ENTRY _ZTV9S20678C14[];
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C15__9S20678C14[] = {
  ABISELECT(4272,2964),
  ABISELECT(4000,2780),
  ABISELECT(3856,2680),
  ABISELECT(3616,2516),
  ABISELECT(3568,2476),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C49S20678C15__9S20678C14[] = {
  ABISELECT(3568,2476),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C49S20678C15__9S20678C14[] = {
  ABISELECT(3568,2476),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C15__A2__9S20678C14[] = {
  ABISELECT(3152,2184),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C15__9S20678C14[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-48,-40),
  ABISELECT(-3616,-2516),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C15__9S20678C14[] = {
  ABISELECT(-288,-204),
  ABISELECT(-3856,-2680),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A__9S20678C15__9S20678C14[] = {
  ABISELECT(3152,2184),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
};
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C8__9S20678C15__9S20678C14[] = {
  0,
  ABISELECT(-4000,-2780),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C15__9S20678C14[] = {
  0,
  ABISELECT(-704,-488),
  ABISELECT(-4272,-2964),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern void _ZN9S20678C173v22Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C17__9S20678C14[] = {
  ABISELECT(3392,2360),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C17[0]),
  (VTBL_ENTRY)&_ZN9S20678C173v22Ev,
};
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C8__9S20678C17__9S20678C14[] = {
  0,
  ABISELECT(-3392,-2360),
  (VTBL_ENTRY)&(_ZTI9S20678C17[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C13__9S20678C14[] = {
  ABISELECT(1712,1192),
  ABISELECT(1472,1028),
  ABISELECT(2712,1904),
  ABISELECT(1424,988),
  ABISELECT(2304,1612),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C119S20678C13__9S20678C14[] = {
  ABISELECT(1712,1192),
  ABISELECT(1472,1028),
  ABISELECT(2712,1904),
  ABISELECT(1424,988),
  ABISELECT(2304,1612),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C119S20678C13__9S20678C14[] = {
  0,
  0,
  0,
  ABISELECT(-880,-624),
  ABISELECT(-2304,-1612),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C119S20678C13__9S20678C14[] = {
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-1288,-916),
  ABISELECT(-2712,-1904),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C119S20678C13__9S20678C14[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-48,-40),
  ABISELECT(-1472,-1028),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C119S20678C13__9S20678C14[] = {
  ABISELECT(-288,-204),
  ABISELECT(-1712,-1192),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C129S20678C13__A1__9S20678C14[] = {
  ABISELECT(624,440),
  ABISELECT(336,236),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C129S20678C13__A1__9S20678C14[] = {
  ABISELECT(-288,-204),
  ABISELECT(-624,-440),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C13__9S20678C14[] = {
  ABISELECT(-288,-204),
  ABISELECT(-1712,-1192),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C13__9S20678C14[] = {
  0,
  0,
  0,
  ABISELECT(-880,-624),
  ABISELECT(-2304,-1612),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C13__9S20678C14[] = {
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-1288,-916),
  ABISELECT(-2712,-1904),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C13__9S20678C14[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-48,-40),
  ABISELECT(-1472,-1028),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__A__9S20678C13__9S20678C14[] = {
  ABISELECT(624,440),
  ABISELECT(336,236),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C14[] = {
  ABISELECT(240,164),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__9S20678C14[] = {
  ABISELECT(-288,-204),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C14[] = {
  ABISELECT(-288,-204),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C14[] = {
  ABISELECT(-704,-488),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C16[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C16__A3__9S20678C14[] = {
  ABISELECT(-704,-488),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__A1__9S20678C14[] = {
  ABISELECT(-880,-624),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C4__A4__9S20678C14[] = {
  ABISELECT(-880,-624),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C14[] = {
  ABISELECT(-408,-292),
  ABISELECT(-1288,-916),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__8S20678C2__9S20678C14[] = {
  0,
  0,
  0,
  ABISELECT(-880,-624),
  ABISELECT(408,292),
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTT_ENTRY vtt_S20678C14[] = {
  {&(_ZTV9S20678C14[9]),  9,74},
  {&(_tg__ZTV9S20678C15__9S20678C14[7]),  7,11},
  {&(_tg__ZTV8S20678C49S20678C15__9S20678C14[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C49S20678C15__9S20678C14[3]),  3,3},
  {&(_tg__ZTV8S20678C59S20678C15__A2__9S20678C14[3]),  3,3},
  {&(_tg__ZTV9S20678C12__9S20678C15__9S20678C14[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C15__9S20678C14[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A__9S20678C15__9S20678C14[3]),  3,3},
  {&(_tg__ZTV8S20678C8__9S20678C15__9S20678C14[3]),  3,4},
  {&(_tg__ZTV9S20678C16__9S20678C15__9S20678C14[4]),  4,5},
  {&(_tg__ZTV9S20678C17__9S20678C14[3]),  3,4},
  {&(_tg__ZTV8S20678C8__9S20678C17__9S20678C14[3]),  3,4},
  {&(_tg__ZTV9S20678C13__9S20678C14[7]),  7,9},
  {&(_tg__ZTV9S20678C119S20678C13__9S20678C14[7]),  7,9},
  {&(_tg__ZTV8S20678C4__9S20678C119S20678C13__9S20678C14[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C119S20678C13__9S20678C14[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C119S20678C13__9S20678C14[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C119S20678C13__9S20678C14[3]),  3,3},
  {&(_tg__ZTV9S20678C129S20678C13__A1__9S20678C14[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C129S20678C13__A1__9S20678C14[3]),  3,3},
  {&(_tg__ZTV8S20678C5__9S20678C13__9S20678C14[3]),  3,3},
  {&(_tg__ZTV8S20678C4__9S20678C13__9S20678C14[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C13__9S20678C14[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C13__9S20678C14[6]),  6,8},
  {&(_tg__ZTV9S20678C12__A__9S20678C13__9S20678C14[4]),  4,6},
  {&(_ZTV9S20678C14[41]),  41,74},
  {&(_ZTV9S20678C14[46]),  46,74},
  {&(_ZTV9S20678C14[16]),  16,74},
  {&(_ZTV9S20678C14[49]),  49,74},
  {&(_ZTV9S20678C14[54]),  54,74},
  {&(_ZTV9S20678C14[19]),  19,74},
  {&(_ZTV9S20678C14[27]),  27,74},
  {&(_ZTV9S20678C14[61]),  61,74},
  {&(_ZTV9S20678C14[71]),  71,74},
  {&(_ZTV9S20678C14[33]),  33,74},
  {&(_tg__ZTV9S20678C12__9S20678C14[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__9S20678C14[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A1__9S20678C14[3]),  3,3},
  {&(_tg__ZTV9S20678C16__9S20678C14[3]),  3,4},
  {&(_tg__ZTV8S20678C59S20678C16__A3__9S20678C14[3]),  3,3},
  {&(_tg__ZTV8S20678C4__A1__9S20678C14[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C4__A4__9S20678C14[3]),  3,3},
  {&(_tg__ZTV8S20678C2__9S20678C14[4]),  4,7},
  {&(_tg__ZTV8S20678C4__8S20678C2__9S20678C14[6]),  6,9},
};
extern VTBL_ENTRY _ZTI9S20678C14[];
extern  VTBL_ENTRY _ZTV9S20678C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C14[];
Class_Descriptor cd_S20678C14 = {  "S20678C14", // class name
  bases_S20678C14, 17,
  &(vtc_S20678C14[0]), // expected_vtbl_contents
  &(vtt_S20678C14[0]), // expected_vtt_contents
  ABISELECT(4960,3464), // object size
  NSPAIRA(_ZTI9S20678C14),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20678C14),74, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C14),44, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C10  : S20678C11 {
  int s20678c10f0[2];
  ::S20677C6_nt s20678c10f1;
  ::S20677C6_nt s20678c10f2;
  ::S20677C6_nt s20678c10f3;
  ::S20677C6_nt s20678c10f4;
  ::S20677C6_nt s20678c10f5;
  ::S20678C13 s20678c10f6;
  __tsi64 s20678c10f7[4];
  ::S20677C6_nt s20678c10f8;
  ::S20678C14 s20678c10f9[2];
  char s20678c10f10;
  ::S20677C6_nt s20678c10f11;
  virtual void  v14(); // _ZN9S20678C103v14Ev
  ~S20678C10(); // tgen
  S20678C10(); // tgen
};
//SIG(-1 S20678C10) C1{ BC2{ VBC3{ VBC4{ m Fp FL[4] Fs} BC5{ VBC4 FD Fi FC4 FC4} v2 v3 v4 Fs FL Fc Fi[2] FC5 Fp FL Fi FL Fi} VBC6{ VBC4 VBC3 v5 v6 v7 FL FC7{} Fp Fc[2] FC4 Fl FC7} VBC8{ VBC4 VBC5 v8 v9 Fi FC5 FL Fi Fp} v10 v11 FC7 FC7 Fi FC5 FC7 FC7 FC9{ v12 FC7 FC5 FC7 FL FC7 Fp FC7 Fp[2] FC7} FC6 Fp FC7} v1 Fi[2] FC7 FC7 FC7 FC7 FC7 FC10{ VBC5 BC2 BC8 Fi Fc:2 FC7 Fi} FL[4] FC7 FC11{ BC12{ BC3 VBC8 BC5 VBC9 VBC13{ BC5 v13 FL Fc[7] Fp Fi FC7 FC7 Fc[10]} v14 Fl FL FD FC7} BC14{ VBC9 v15 FC12 FC7 FL Fi[2]} BC10 Fp FL Fi Fp Fi[3] Fc FL Fp FD}[2] Fc FC7}


void  S20678C10 ::v14(){vfunc_called(this, "_ZN9S20678C103v14Ev");}
S20678C10 ::~S20678C10(){ note_dtor("S20678C10", this);} // tgen
S20678C10 ::S20678C10(){ note_ctor("S20678C10", this);} // tgen

static void Test_S20678C10()
{
  extern Class_Descriptor cd_S20678C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(896,2501)];
    init_test(&cd_S20678C10, buf);
    S20678C10 *dp, &lv = *(dp=new (buf) S20678C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(14320,10000), "sizeof(S20678C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C10)");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*), ABISELECT(13784,9624), "S20678C10");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*), ABISELECT(13784,9624), "S20678C10");
    check_base_class_offset(lv, (S20677C3*)(S20678C2*), ABISELECT(13784,9624), "S20678C10");
    check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(13784,9624), "S20678C10");
    /*is_ambiguous_... S20678C10::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(13784,9624), "S20678C10");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*), ABISELECT(13376,9332), "S20678C10");
    check_base_class_offset(lv, (S20678C4*)(S20678C11*), ABISELECT(13376,9332), "S20678C10");
    check_base_class_offset(lv, (S20678C4*)(S20678C2*), ABISELECT(13376,9332), "S20678C10");
    check_base_class_offset(lv, (S20678C2*)(S20678C11*), ABISELECT(13832,9664), "S20678C10");
    check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(14176,9900), "S20678C10");
    check_base_class_offset(lv, (S20678C12*)(S20678C11*), ABISELECT(13936,9736), "S20678C10");
    check_base_class_offset(lv, (S20678C11*), 0, "S20678C10");
    check_field_offset(lv, s20678c10f0, ABISELECT(1084,752), "S20678C10.s20678c10f0");
    check_field_offset(lv, s20678c10f1, ABISELECT(1092,760), "S20678C10.s20678c10f1");
    check_field_offset(lv, s20678c10f2, ABISELECT(1093,761), "S20678C10.s20678c10f2");
    check_field_offset(lv, s20678c10f3, ABISELECT(1094,762), "S20678C10.s20678c10f3");
    check_field_offset(lv, s20678c10f4, ABISELECT(1095,763), "S20678C10.s20678c10f4");
    check_field_offset(lv, s20678c10f5, ABISELECT(1096,764), "S20678C10.s20678c10f5");
    check_field_offset(lv, s20678c10f6, ABISELECT(1104,768), "S20678C10.s20678c10f6");
    check_field_offset(lv, s20678c10f7, ABISELECT(3392,2364), "S20678C10.s20678c10f7");
    check_field_offset(lv, s20678c10f8, ABISELECT(3424,2396), "S20678C10.s20678c10f8");
    check_field_offset(lv, s20678c10f9, ABISELECT(3440,2400), "S20678C10.s20678c10f9");
    check_field_offset(lv, s20678c10f10, ABISELECT(13360,9328), "S20678C10.s20678c10f10");
    check_field_offset(lv, s20678c10f11, ABISELECT(13361,9329), "S20678C10.s20678c10f11");
    test_class_info(&lv, &cd_S20678C10);
    dp->~S20678C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C10(Test_S20678C10, "S20678C10", ABISELECT(14320,10000));

#else // __cplusplus

extern void _ZN9S20678C10C1Ev();
extern void _ZN9S20678C10D1Ev();
Name_Map name_map_S20678C10[] = {
  NSPAIR(_ZN9S20678C10C1Ev),
  NSPAIR(_ZN9S20678C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C2;
extern VTBL_ENTRY _ZTI8S20678C2[];
extern  VTBL_ENTRY _ZTV8S20678C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C2[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C11;
extern VTBL_ENTRY _ZTI9S20678C11[];
extern  VTBL_ENTRY _ZTV9S20678C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C11[];
static Base_Class bases_S20678C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(13784,9624), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(13376,9332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(13376,9332), //bcp->offset
    10, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20678C2,    ABISELECT(13832,9664), //bcp->offset
    19, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(14176,9900), //bcp->offset
    37, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20678C12,    ABISELECT(13936,9736), //bcp->offset
    29, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20678C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C10[];
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN9S20678C103v14Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY vtc_S20678C10[] = {
  ABISELECT(14176,9900),
  ABISELECT(13936,9736),
  ABISELECT(13832,9664),
  ABISELECT(13784,9624),
  ABISELECT(13376,9332),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20678C103v14Ev,
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-13376,-9332),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-13832,-9664),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-13936,-9736),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  ABISELECT(-392,-276),
  ABISELECT(-14176,-9900),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
};
extern VTBL_ENTRY _ZTV9S20678C10[];
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C11__9S20678C10[] = {
  ABISELECT(14176,9900),
  ABISELECT(13936,9736),
  ABISELECT(13832,9664),
  ABISELECT(13784,9624),
  ABISELECT(13376,9332),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C11__9S20678C10[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-13376,-9332),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C11__9S20678C10[] = {
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-13832,-9664),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C11__9S20678C10[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-13936,-9736),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C11__9S20678C10[] = {
  ABISELECT(-392,-276),
  ABISELECT(-14176,-9900),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C10[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C4__9S20678C10[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C10[] = {
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__8S20678C2__9S20678C10[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(456,332),
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C10[] = {
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__9S20678C10[] = {
  ABISELECT(-392,-276),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C10[] = {
  ABISELECT(-392,-276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C10[] = {
  {&(_ZTV9S20678C10[7]),  7,40},
  {&(_tg__ZTV9S20678C11__9S20678C10[7]),  7,9},
  {&(_tg__ZTV8S20678C4__9S20678C11__9S20678C10[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C11__9S20678C10[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C11__9S20678C10[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C11__9S20678C10[3]),  3,3},
  {&(_ZTV9S20678C10[16]),  16,40},
  {&(_ZTV9S20678C10[26]),  26,40},
  {&(_ZTV9S20678C10[35]),  35,40},
  {&(_ZTV9S20678C10[40]),  40,40},
  {&(_tg__ZTV8S20678C4__9S20678C10[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C4__9S20678C10[3]),  3,3},
  {&(_tg__ZTV8S20678C2__9S20678C10[4]),  4,7},
  {&(_tg__ZTV8S20678C4__8S20678C2__9S20678C10[6]),  6,9},
  {&(_tg__ZTV9S20678C12__9S20678C10[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__9S20678C10[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A1__9S20678C10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20678C10[];
extern  VTBL_ENTRY _ZTV9S20678C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C10[];
Class_Descriptor cd_S20678C10 = {  "S20678C10", // class name
  bases_S20678C10, 7,
  &(vtc_S20678C10[0]), // expected_vtbl_contents
  &(vtt_S20678C10[0]), // expected_vtt_contents
  ABISELECT(14320,10000), // object size
  NSPAIRA(_ZTI9S20678C10),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S20678C10),40, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C10),17, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C19  : S20678C9 , S20678C12 , virtual S20678C15 {
  void *s20678c19f0;
  char s20678c19f1[4];
  ::S20678C4 s20678c19f2;
  int s20678c19f3[8];
  ::S20677C6_nt s20678c19f4;
  ::S20678C7 s20678c19f5;
  ::S20677C6_nt s20678c19f6;
  long double s20678c19f7;
  ::S20678C5 s20678c19f8[9];
  long double s20678c19f9[10];
  short s20678c19f10;
  virtual void  v17(); // _ZN9S20678C193v17Ev
  virtual void  v18(); // _ZN9S20678C193v18Ev
  virtual void  v19(); // _ZN9S20678C193v19Ev
  virtual void  v20(); // _ZN9S20678C193v20Ev
  ~S20678C19(); // tgen
  S20678C19(); // tgen
};
//SIG(-1 S20678C19) C1{ BC2{ BC3{ m Fp FL[4] Fs} FC3 Fi FD Fi FL Fl} BC4{ VBC3 VBC5{ VBC3 FD Fi FC3 FC3} v5 v6 Fi FC5 FL Fi Fp} VBC6{ BC7{ VBC3 BC5 v7 v8 v9 Fs FL Fc Fi[2] FC5 Fp FL Fi FL Fi} VBC4 BC5 VBC8{ v10 FC9{} FC5 FC9 FL FC9 Fp FC9 Fp[2] FC9} VBC10{ BC5 v11 FL Fc[7] Fp Fi FC9 FC9 Fc[10]} v12 Fl FL FD FC9} v1 v2 v3 v4 Fp Fc[4] FC7 Fi[8] FC9 FC11{ VBC8 BC5 BC2 v13 Fp FC2 Fp Fi[2] FD Fi[2]} FC9 FD FC5[9] FD[10] Fs}


void  S20678C19 ::v17(){vfunc_called(this, "_ZN9S20678C193v17Ev");}
void  S20678C19 ::v18(){vfunc_called(this, "_ZN9S20678C193v18Ev");}
void  S20678C19 ::v19(){vfunc_called(this, "_ZN9S20678C193v19Ev");}
void  S20678C19 ::v20(){vfunc_called(this, "_ZN9S20678C193v20Ev");}
S20678C19 ::~S20678C19(){ note_dtor("S20678C19", this);} // tgen
S20678C19 ::S20678C19(){ note_ctor("S20678C19", this);} // tgen

static void Test_S20678C19()
{
  extern Class_Descriptor cd_S20678C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(325,921)];
    init_test(&cd_S20678C19, buf);
    S20678C19 *dp, &lv = *(dp=new (buf) S20678C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5184,3680), "sizeof(S20678C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C19)");
    check_base_class_offset(lv, (S20677C3*)(S20678C9*), ABISELECT(240,164), "S20678C19");
    check_base_class_offset(lv, (S20678C9*), ABISELECT(240,164), "S20678C19");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(3688,2636), "S20678C19");
    /*is_ambiguous_... S20678C19::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(3688,2636), "S20678C19");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*)(S20678C15*), ABISELECT(3688,2636), "S20678C19");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*)(S20678C15*), ABISELECT(3688,2636), "S20678C19");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(3688,2636), "S20678C19");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C15*), ABISELECT(3688,2636), "S20678C19");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C16*), ABISELECT(3688,2636), "S20678C19");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(3744,2676), "S20678C19");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(3744,2676), "S20678C19");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C12*), 0, "S20678C19");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*)(S20678C15*), ABISELECT(3888,2776), "S20678C19");
    check_base_class_offset(lv, (S20678C4*)(S20678C15*), ABISELECT(3888,2776), "S20678C19");
    check_base_class_offset(lv, (S20678C12*)(S20678C15*), ABISELECT(4496,3196), "S20678C19");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C15*), ABISELECT(4304,3068), "S20678C19");
    check_base_class_offset(lv, (S20678C8*)(S20678C15*), ABISELECT(4736,3360), "S20678C19");
    check_base_class_offset(lv, (S20678C5*)(S20678C16*), ABISELECT(5008,3544), "S20678C19");
    check_base_class_offset(lv, (S20678C16*)(S20678C15*), ABISELECT(5008,3544), "S20678C19");
    check_base_class_offset(lv, (S20678C15*), ABISELECT(3888,2776), "S20678C19");
    check_field_offset(lv, s20678c19f0, ABISELECT(392,276), "S20678C19.s20678c19f0");
    check_field_offset(lv, s20678c19f1, ABISELECT(400,280), "S20678C19.s20678c19f1");
    check_field_offset(lv, s20678c19f2, ABISELECT(416,284), "S20678C19.s20678c19f2");
    check_field_offset(lv, s20678c19f3, ABISELECT(880,616), "S20678C19.s20678c19f3");
    check_field_offset(lv, s20678c19f4, ABISELECT(912,648), "S20678C19.s20678c19f4");
    check_field_offset(lv, s20678c19f5, ABISELECT(928,652), "S20678C19.s20678c19f5");
    check_field_offset(lv, s20678c19f6, ABISELECT(1760,1236), "S20678C19.s20678c19f6");
    check_field_offset(lv, s20678c19f7, ABISELECT(1776,1240), "S20678C19.s20678c19f7");
    check_field_offset(lv, s20678c19f8, ABISELECT(1792,1252), "S20678C19.s20678c19f8");
    check_field_offset(lv, s20678c19f9, ABISELECT(3520,2512), "S20678C19.s20678c19f9");
    check_field_offset(lv, s20678c19f10, ABISELECT(3680,2632), "S20678C19.s20678c19f10");
    test_class_info(&lv, &cd_S20678C19);
    dp->~S20678C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C19(Test_S20678C19, "S20678C19", ABISELECT(5184,3680));

#else // __cplusplus

extern void _ZN9S20678C19C1Ev();
extern void _ZN9S20678C19D1Ev();
Name_Map name_map_S20678C19[] = {
  NSPAIR(_ZN9S20678C19C1Ev),
  NSPAIR(_ZN9S20678C19D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C9;
extern VTBL_ENTRY _ZTI8S20678C9[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C8;
extern VTBL_ENTRY _ZTI8S20678C8[];
extern  VTBL_ENTRY _ZTV8S20678C8[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C16;
extern VTBL_ENTRY _ZTI9S20678C16[];
extern  VTBL_ENTRY _ZTV9S20678C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C16[];
extern Class_Descriptor cd_S20678C15;
extern VTBL_ENTRY _ZTI9S20678C15[];
extern  VTBL_ENTRY _ZTV9S20678C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C15[];
static Base_Class bases_S20678C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(240,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20678C9,    ABISELECT(240,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20677C3,    ABISELECT(3688,2636), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(3744,2676), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20678C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20678C5,    ABISELECT(3888,2776), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(3888,2776), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20678C12,    ABISELECT(4496,3196), //bcp->offset
    35, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(4304,3068), //bcp->offset
    32, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20678C8,    ABISELECT(4736,3360), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(5008,3544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20678C16,    ABISELECT(5008,3544), //bcp->offset
    47, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20678C15,    ABISELECT(3888,2776), //bcp->offset
    17, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C19[];
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN9S20678C193v17Ev();
extern void _ZN9S20678C193v18Ev();
extern void _ZN9S20678C193v19Ev();
extern void _ZN9S20678C193v20Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN8S20678C82v8Ev();
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY vtc_S20678C19[] = {
  ABISELECT(5008,3544),
  ABISELECT(4736,3360),
  ABISELECT(4496,3196),
  ABISELECT(3888,2776),
  ABISELECT(3744,2676),
  ABISELECT(3688,2636),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v20Ev,
  ABISELECT(-56,-40),
  ABISELECT(-3744,-2676),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  0,
  0,
  0,
  0,
  ABISELECT(1120,768),
  ABISELECT(848,584),
  ABISELECT(-144,-100),
  ABISELECT(608,420),
  ABISELECT(-200,-140),
  ABISELECT(-3888,-2776),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
  ABISELECT(-616,-432),
  ABISELECT(-4304,-3068),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  0,
  0,
  ABISELECT(-752,-520),
  ABISELECT(-808,-560),
  ABISELECT(-4496,-3196),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  0,
  ABISELECT(-4736,-3360),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
  0,
  ABISELECT(-1320,-908),
  ABISELECT(-5008,-3544),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern VTBL_ENTRY _ZTV9S20678C19[];
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__A__9S20678C19[] = {
  ABISELECT(3744,2676),
  ABISELECT(3688,2636),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__A__9S20678C19[] = {
  ABISELECT(-56,-40),
  ABISELECT(-3744,-2676),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C19[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C15__9S20678C19[] = {
  ABISELECT(1120,768),
  ABISELECT(848,584),
  ABISELECT(-144,-100),
  ABISELECT(608,420),
  ABISELECT(-200,-140),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C49S20678C15__9S20678C19[] = {
  ABISELECT(-200,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C49S20678C15__A1__9S20678C19[] = {
  ABISELECT(-200,-140),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C15__A2__9S20678C19[] = {
  ABISELECT(-616,-432),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C15__9S20678C19[] = {
  0,
  0,
  ABISELECT(-752,-520),
  ABISELECT(-808,-560),
  ABISELECT(-608,-420),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C15__9S20678C19[] = {
  ABISELECT(-56,-40),
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A__9S20678C15__9S20678C19[] = {
  ABISELECT(-616,-432),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
};
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C8__9S20678C15__9S20678C19[] = {
  0,
  ABISELECT(-848,-584),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C15__9S20678C19[] = {
  0,
  ABISELECT(-1320,-908),
  ABISELECT(-1120,-768),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__A1__9S20678C19[] = {
  ABISELECT(-752,-520),
  ABISELECT(-808,-560),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__A1__9S20678C19[] = {
  ABISELECT(-56,-40),
  ABISELECT(752,520),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C19[] = {
  ABISELECT(-1320,-908),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C16[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C16__A3__9S20678C19[] = {
  ABISELECT(-1320,-908),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C19[] = {
  {&(_ZTV9S20678C19[8]),  8,52},
  {&(_tg__ZTV9S20678C12__A__9S20678C19[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__A__9S20678C19[3]),  3,3},
  {&(_ZTV9S20678C19[17]),  17,52},
  {&(_ZTV9S20678C19[28]),  28,52},
  {&(_ZTV9S20678C19[41]),  41,52},
  {&(_ZTV9S20678C19[35]),  35,52},
  {&(_ZTV9S20678C19[46]),  46,52},
  {&(_ZTV9S20678C19[51]),  51,52},
  {&(_tg__ZTV8S20678C5__9S20678C19[3]),  3,3},
  {&(_tg__ZTV9S20678C15__9S20678C19[7]),  7,11},
  {&(_tg__ZTV8S20678C49S20678C15__9S20678C19[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C49S20678C15__A1__9S20678C19[3]),  3,3},
  {&(_tg__ZTV8S20678C59S20678C15__A2__9S20678C19[3]),  3,3},
  {&(_tg__ZTV9S20678C12__9S20678C15__9S20678C19[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C15__9S20678C19[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A__9S20678C15__9S20678C19[3]),  3,3},
  {&(_tg__ZTV8S20678C8__9S20678C15__9S20678C19[3]),  3,4},
  {&(_tg__ZTV9S20678C16__9S20678C15__9S20678C19[4]),  4,5},
  {&(_tg__ZTV9S20678C12__A1__9S20678C19[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__A1__9S20678C19[3]),  3,3},
  {&(_tg__ZTV9S20678C16__9S20678C19[3]),  3,4},
  {&(_tg__ZTV8S20678C59S20678C16__A3__9S20678C19[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20678C19[];
extern  VTBL_ENTRY _ZTV9S20678C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C19[];
Class_Descriptor cd_S20678C19 = {  "S20678C19", // class name
  bases_S20678C19, 13,
  &(vtc_S20678C19[0]), // expected_vtbl_contents
  &(vtt_S20678C19[0]), // expected_vtt_contents
  ABISELECT(5184,3680), // object size
  NSPAIRA(_ZTI9S20678C19),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20678C19),52, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C19),23, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C20  : S20678C13 {
  int s20678c20f0;
  ::S20677C6_nt s20678c20f1;
  short s20678c20f2;
  __tsi64 s20678c20f3;
  ::S20678C5 s20678c20f4;
  __tsi64 s20678c20f5;
  virtual void  v23(); // _ZN9S20678C203v23Ev
  ~S20678C20(); // tgen
  S20678C20(); // tgen
};
//SIG(-1 S20678C20) C1{ BC2{ VBC3{ VBC4{ m Fp FL[4] Fs} FD Fi FC4 FC4} BC5{ VBC6{ VBC4 BC3 v2 v3 v4 Fs FL Fc Fi[2] FC3 Fp FL Fi FL Fi} VBC7{ VBC4 VBC6 v5 v6 v7 FL FC8{} Fp Fc[2] FC4 Fl FC8} VBC9{ VBC4 VBC3 v8 v9 Fi FC3 FL Fi Fp} v10 v11 FC8 FC8 Fi FC3 FC8 FC8 FC10{ v12 FC8 FC3 FC8 FL FC8 Fp FC8 Fp[2] FC8} FC7 Fp FC8} BC9 Fi Fc:2 FC8 Fi} v1 Fi FC8 Fs FL FC3 FL}


void  S20678C20 ::v23(){vfunc_called(this, "_ZN9S20678C203v23Ev");}
S20678C20 ::~S20678C20(){ note_dtor("S20678C20", this);} // tgen
S20678C20 ::S20678C20(){ note_ctor("S20678C20", this);} // tgen

static void Test_S20678C20()
{
  extern Class_Descriptor cd_S20678C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(158,441)];
    init_test(&cd_S20678C20, buf);
    S20678C20 *dp, &lv = *(dp=new (buf) S20678C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2512,1760), "sizeof(S20678C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C20)");
    /*is_ambiguous_... S20678C20::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(1704,1192), "S20678C20");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*), ABISELECT(1704,1192), "S20678C20");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*), ABISELECT(1704,1192), "S20678C20");
    check_base_class_offset(lv, (S20677C3*)(S20678C2*), ABISELECT(1704,1192), "S20678C20");
    /*is_ambiguous_... S20678C20::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(1704,1192), "S20678C20");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*)(S20678C13*), ABISELECT(1704,1192), "S20678C20");
    /*is_ambiguous_... S20678C13::S20678C5 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C13*), ABISELECT(1568,1092), "S20678C20");
    /*is_ambiguous_... S20678C20::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(1568,1092), "S20678C20");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*)(S20678C13*), ABISELECT(1568,1092), "S20678C20");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*), ABISELECT(1760,1232), "S20678C20");
    check_base_class_offset(lv, (S20678C4*)(S20678C11*)(S20678C13*), ABISELECT(1760,1232), "S20678C20");
    check_base_class_offset(lv, (S20678C4*)(S20678C2*), ABISELECT(1760,1232), "S20678C20");
    check_base_class_offset(lv, (S20678C2*)(S20678C11*)(S20678C13*), ABISELECT(2168,1524), "S20678C20");
    check_base_class_offset(lv, (S20678C12*)(S20678C11*)(S20678C13*), ABISELECT(2272,1596), "S20678C20");
    check_base_class_offset(lv, (S20678C11*)(S20678C13*), 0, "S20678C20");
    /*is_ambiguous_... S20678C13::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C12*)(S20678C13*), ABISELECT(1088,752), "S20678C20");
    check_base_class_offset(lv, (S20678C13*), 0, "S20678C20");
    check_field_offset(lv, s20678c20f0, ABISELECT(1332,928), "S20678C20.s20678c20f0");
    check_field_offset(lv, s20678c20f1, ABISELECT(1336,932), "S20678C20.s20678c20f1");
    check_field_offset(lv, s20678c20f2, ABISELECT(1338,934), "S20678C20.s20678c20f2");
    check_field_offset(lv, s20678c20f3, ABISELECT(1344,936), "S20678C20.s20678c20f3");
    check_field_offset(lv, s20678c20f4, ABISELECT(1360,944), "S20678C20.s20678c20f4");
    check_field_offset(lv, s20678c20f5, ABISELECT(1552,1084), "S20678C20.s20678c20f5");
    test_class_info(&lv, &cd_S20678C20);
    dp->~S20678C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C20(Test_S20678C20, "S20678C20", ABISELECT(2512,1760));

#else // __cplusplus

extern void _ZN9S20678C20C1Ev();
extern void _ZN9S20678C20D1Ev();
Name_Map name_map_S20678C20[] = {
  NSPAIR(_ZN9S20678C20C1Ev),
  NSPAIR(_ZN9S20678C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C2;
extern VTBL_ENTRY _ZTI8S20678C2[];
extern  VTBL_ENTRY _ZTV8S20678C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C2[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C11;
extern VTBL_ENTRY _ZTI9S20678C11[];
extern  VTBL_ENTRY _ZTV9S20678C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C11[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C13;
extern VTBL_ENTRY _ZTI9S20678C13[];
extern  VTBL_ENTRY _ZTV9S20678C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C13[];
static Base_Class bases_S20678C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(1704,1192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(1568,1092), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(1760,1232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(1760,1232), //bcp->offset
    19, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20678C2,    ABISELECT(2168,1524), //bcp->offset
    28, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20678C12,    ABISELECT(2272,1596), //bcp->offset
    38, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20678C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20678C12,    ABISELECT(1088,752), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20678C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C20[];
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN9S20678C203v23Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY vtc_S20678C20[] = {
  ABISELECT(1568,1092),
  ABISELECT(2272,1596),
  ABISELECT(2168,1524),
  ABISELECT(1704,1192),
  ABISELECT(1760,1232),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C20[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20678C203v23Ev,
  ABISELECT(480,340),
  ABISELECT(616,440),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20678C20[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  ABISELECT(136,100),
  ABISELECT(-1568,-1092),
  (VTBL_ENTRY)&(_ZTI9S20678C20[0]),
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-1760,-1232),
  (VTBL_ENTRY)&(_ZTI9S20678C20[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  ABISELECT(-2168,-1524),
  (VTBL_ENTRY)&(_ZTI9S20678C20[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
  0,
  0,
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  ABISELECT(-2272,-1596),
  (VTBL_ENTRY)&(_ZTI9S20678C20[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
extern VTBL_ENTRY _ZTV9S20678C20[];
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C13__9S20678C20[] = {
  ABISELECT(1568,1092),
  ABISELECT(2272,1596),
  ABISELECT(2168,1524),
  ABISELECT(1704,1192),
  ABISELECT(1760,1232),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C119S20678C13__9S20678C20[] = {
  ABISELECT(1568,1092),
  ABISELECT(2272,1596),
  ABISELECT(2168,1524),
  ABISELECT(1704,1192),
  ABISELECT(1760,1232),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C119S20678C13__9S20678C20[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-1760,-1232),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C119S20678C13__9S20678C20[] = {
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  ABISELECT(-2168,-1524),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C119S20678C13__9S20678C20[] = {
  0,
  0,
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  ABISELECT(-2272,-1596),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C119S20678C13__9S20678C20[] = {
  ABISELECT(136,100),
  ABISELECT(-1568,-1092),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C129S20678C13__A1__9S20678C20[] = {
  ABISELECT(480,340),
  ABISELECT(616,440),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C129S20678C13__A1__9S20678C20[] = {
  ABISELECT(136,100),
  ABISELECT(-480,-340),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C13__9S20678C20[] = {
  ABISELECT(136,100),
  ABISELECT(-1568,-1092),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C13__9S20678C20[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-1760,-1232),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C13__9S20678C20[] = {
  0,
  0,
  0,
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  ABISELECT(-2168,-1524),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C13__9S20678C20[] = {
  0,
  0,
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  ABISELECT(-2272,-1596),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__A__9S20678C13__9S20678C20[] = {
  ABISELECT(480,340),
  ABISELECT(616,440),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20678C13[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C20[] = {
  ABISELECT(136,100),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C20[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C4__A1__9S20678C20[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C20[] = {
  ABISELECT(-408,-292),
  ABISELECT(-464,-332),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__8S20678C2__9S20678C20[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(408,292),
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C20[] = {
  ABISELECT(-704,-504),
  ABISELECT(-568,-404),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__9S20678C20[] = {
  ABISELECT(136,100),
  ABISELECT(704,504),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTT_ENTRY vtt_S20678C20[] = {
  {&(_ZTV9S20678C20[7]),  7,46},
  {&(_tg__ZTV9S20678C13__9S20678C20[7]),  7,9},
  {&(_tg__ZTV9S20678C119S20678C13__9S20678C20[7]),  7,9},
  {&(_tg__ZTV8S20678C4__9S20678C119S20678C13__9S20678C20[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C119S20678C13__9S20678C20[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C119S20678C13__9S20678C20[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C119S20678C13__9S20678C20[3]),  3,3},
  {&(_tg__ZTV9S20678C129S20678C13__A1__9S20678C20[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C129S20678C13__A1__9S20678C20[3]),  3,3},
  {&(_tg__ZTV8S20678C5__9S20678C13__9S20678C20[3]),  3,3},
  {&(_tg__ZTV8S20678C4__9S20678C13__9S20678C20[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C13__9S20678C20[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C13__9S20678C20[6]),  6,8},
  {&(_tg__ZTV9S20678C12__A__9S20678C13__9S20678C20[4]),  4,6},
  {&(_ZTV9S20678C20[19]),  19,46},
  {&(_ZTV9S20678C20[25]),  25,46},
  {&(_ZTV9S20678C20[35]),  35,46},
  {&(_ZTV9S20678C20[44]),  44,46},
  {&(_ZTV9S20678C20[14]),  14,46},
  {&(_tg__ZTV8S20678C5__9S20678C20[3]),  3,3},
  {&(_tg__ZTV8S20678C4__9S20678C20[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C4__A1__9S20678C20[3]),  3,3},
  {&(_tg__ZTV8S20678C2__9S20678C20[4]),  4,7},
  {&(_tg__ZTV8S20678C4__8S20678C2__9S20678C20[6]),  6,9},
  {&(_tg__ZTV9S20678C12__9S20678C20[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__9S20678C20[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20678C20[];
extern  VTBL_ENTRY _ZTV9S20678C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C20[];
Class_Descriptor cd_S20678C20 = {  "S20678C20", // class name
  bases_S20678C20, 9,
  &(vtc_S20678C20[0]), // expected_vtbl_contents
  &(vtt_S20678C20[0]), // expected_vtt_contents
  ABISELECT(2512,1760), // object size
  NSPAIRA(_ZTI9S20678C20),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S20678C20),46, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C20),26, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C21  {
  __tsi64 s20678c21f0;
  ::S20678C16 s20678c21f1;
  ::S20677C6_nt s20678c21f2;
  int s20678c21f3;
  virtual void  v24(); // _ZN9S20678C213v24Ev
  ~S20678C21(); // tgen
  S20678C21(); // tgen
};
//SIG(-1 S20678C21) C1{ v1 FL FC2{ BC3{ VBC4{ m Fp FL[4] Fs} FD Fi FC4 FC4} v2 FL Fc[7] Fp Fi FC5{} FC5 Fc[10]} FC5 Fi}


void  S20678C21 ::v24(){vfunc_called(this, "_ZN9S20678C213v24Ev");}
S20678C21 ::~S20678C21(){ note_dtor("S20678C21", this);} // tgen
S20678C21 ::S20678C21(){ note_ctor("S20678C21", this);} // tgen

static void Test_S20678C21()
{
  extern Class_Descriptor cd_S20678C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(17,50)];
    init_test(&cd_S20678C21, buf);
    S20678C21 *dp, &lv = *(dp=new (buf) S20678C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,196), "sizeof(S20678C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C21)");
    check_field_offset(lv, s20678c21f0, ABISELECT(8,4), "S20678C21.s20678c21f0");
    check_field_offset(lv, s20678c21f1, ABISELECT(16,12), "S20678C21.s20678c21f1");
    check_field_offset(lv, s20678c21f2, ABISELECT(240,188), "S20678C21.s20678c21f2");
    check_field_offset(lv, s20678c21f3, ABISELECT(244,192), "S20678C21.s20678c21f3");
    test_class_info(&lv, &cd_S20678C21);
    dp->~S20678C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C21(Test_S20678C21, "S20678C21", ABISELECT(256,196));

#else // __cplusplus

extern void _ZN9S20678C21C1Ev();
extern void _ZN9S20678C21D1Ev();
Name_Map name_map_S20678C21[] = {
  NSPAIR(_ZN9S20678C21C1Ev),
  NSPAIR(_ZN9S20678C21D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20678C21[];
extern void _ZN9S20678C213v24Ev();
static  VTBL_ENTRY vtc_S20678C21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C21[0]),
  (VTBL_ENTRY)&_ZN9S20678C213v24Ev,
};
extern VTBL_ENTRY _ZTI9S20678C21[];
extern  VTBL_ENTRY _ZTV9S20678C21[];
Class_Descriptor cd_S20678C21 = {  "S20678C21", // class name
  0,0,//no base classes
  &(vtc_S20678C21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,196), // object size
  NSPAIRA(_ZTI9S20678C21),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20678C21),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C18  : virtual S20678C11 , virtual S20678C19 {
  void *s20678c18f0;
  ::S20678C20 s20678c18f1;
  void *s20678c18f2;
  __tsi64 s20678c18f3;
  int s20678c18f4;
  ::S20677C6_nt s20678c18f5;
  void *s20678c18f6;
  ::S20678C21 s20678c18f7;
  __tsi64 s20678c18f8;
  virtual void  v21(); // _ZN9S20678C183v21Ev
  ~S20678C18(); // tgen
  S20678C18(); // tgen
};
//SIG(-1 S20678C18) C1{ VBC2{ VBC3{ VBC4{ m Fp FL[4] Fs} BC5{ VBC4 FD Fi FC4 FC4} v2 v3 v4 Fs FL Fc Fi[2] FC5 Fp FL Fi FL Fi} VBC6{ VBC4 VBC3 v5 v6 v7 FL FC7{} Fp Fc[2] FC4 Fl FC7} VBC8{ VBC4 VBC5 v8 v9 Fi FC5 FL Fi Fp} v10 v11 FC7 FC7 Fi FC5 FC7 FC7 FC9{ v12 FC7 FC5 FC7 FL FC7 Fp FC7 Fp[2] FC7} FC6 Fp FC7} VBC10{ BC11{ BC4 FC4 Fi FD Fi FL Fl} BC8 VBC12{ BC3 VBC8 BC5 VBC9 VBC13{ BC5 v13 FL Fc[7] Fp Fi FC7 FC7 Fc[10]} v14 Fl FL FD FC7} v15 v16 v17 v18 Fp Fc[4] FC3 Fi[8] FC7 FC14{ VBC9 BC5 BC11 v21 Fp FC11 Fp Fi[2] FD Fi[2]} FC7 FD FC5[9] FD[10] Fs} v1 Fp FC15{ BC16{ VBC5 BC2 BC8 Fi Fc:2 FC7 Fi} v19 Fi FC7 Fs FL FC5 FL} Fp FL Fi FC7 Fp FC17{ v20 FL FC13 FC7 Fi} FL}


void  S20678C18 ::v21(){vfunc_called(this, "_ZN9S20678C183v21Ev");}
S20678C18 ::~S20678C18(){ note_dtor("S20678C18", this);} // tgen
S20678C18 ::S20678C18(){ note_ctor("S20678C18", this);} // tgen

static void Test_S20678C18()
{
  extern Class_Descriptor cd_S20678C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(602,1699)];
    init_test(&cd_S20678C18, buf);
    S20678C18 *dp, &lv = *(dp=new (buf) S20678C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(9616,6792), "sizeof(S20678C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C18)");
    /*is_ambiguous_... S20678C18::S20678C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C4*), ABISELECT(4328,3040), "S20678C18");
    /*is_ambiguous_... S20678C18::S20678C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*), ABISELECT(4328,3040), "S20678C18");
    check_base_class_offset(lv, (S20677C3*)(S20678C2*), ABISELECT(4328,3040), "S20678C18");
    /*is_ambiguous_... S20678C18::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(4328,3040), "S20678C18");
    /*is_ambiguous_... S20678C18::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(4328,3040), "S20678C18");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*)(S20678C19*), ABISELECT(4328,3040), "S20678C18");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*)(S20678C15*), ABISELECT(4328,3040), "S20678C18");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*)(S20678C15*), ABISELECT(4328,3040), "S20678C18");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C15*), ABISELECT(4328,3040), "S20678C18");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C16*), ABISELECT(4328,3040), "S20678C18");
    /*is_ambiguous_... S20678C18::S20678C4 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C4*), ABISELECT(3920,2748), "S20678C18");
    check_base_class_offset(lv, (S20678C4*)(S20678C11*), ABISELECT(3920,2748), "S20678C18");
    check_base_class_offset(lv, (S20678C4*)(S20678C2*), ABISELECT(3920,2748), "S20678C18");
    check_base_class_offset(lv, (S20678C2*)(S20678C11*), ABISELECT(4376,3080), "S20678C18");
    /*is_ambiguous_... S20678C18::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(4720,3316), "S20678C18");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*)(S20678C19*), ABISELECT(4720,3316), "S20678C18");
    check_base_class_offset(lv, (S20678C12*)(S20678C11*), ABISELECT(4480,3152), "S20678C18");
    check_base_class_offset(lv, (S20678C12*)(S20678C15*), ABISELECT(4480,3152), "S20678C18");
    check_base_class_offset(lv, (S20678C11*), ABISELECT(2832,1996), "S20678C18");
    check_base_class_offset(lv, (S20677C3*)(S20678C9*)(S20678C19*), ABISELECT(5104,3580), "S20678C18");
    check_base_class_offset(lv, (S20678C9*)(S20678C19*), ABISELECT(5104,3580), "S20678C18");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C12*)(S20678C19*), ABISELECT(4864,3416), "S20678C18");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*)(S20678C15*), ABISELECT(8560,6052), "S20678C18");
    check_base_class_offset(lv, (S20678C4*)(S20678C15*), ABISELECT(8560,6052), "S20678C18");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C15*), ABISELECT(8976,6344), "S20678C18");
    check_base_class_offset(lv, (S20678C8*)(S20678C15*), ABISELECT(9168,6472), "S20678C18");
    check_base_class_offset(lv, (S20678C5*)(S20678C16*), ABISELECT(9440,6656), "S20678C18");
    check_base_class_offset(lv, (S20678C16*)(S20678C15*), ABISELECT(9440,6656), "S20678C18");
    check_base_class_offset(lv, (S20678C15*)(S20678C19*), ABISELECT(8560,6052), "S20678C18");
    check_base_class_offset(lv, (S20678C19*), ABISELECT(4864,3416), "S20678C18");
    check_field_offset(lv, s20678c18f0, ABISELECT(8,4), "S20678C18.s20678c18f0");
    check_field_offset(lv, s20678c18f1, ABISELECT(16,8), "S20678C18.s20678c18f1");
    check_field_offset(lv, s20678c18f2, ABISELECT(2528,1768), "S20678C18.s20678c18f2");
    check_field_offset(lv, s20678c18f3, ABISELECT(2536,1772), "S20678C18.s20678c18f3");
    check_field_offset(lv, s20678c18f4, ABISELECT(2544,1780), "S20678C18.s20678c18f4");
    check_field_offset(lv, s20678c18f5, ABISELECT(2548,1784), "S20678C18.s20678c18f5");
    check_field_offset(lv, s20678c18f6, ABISELECT(2552,1788), "S20678C18.s20678c18f6");
    check_field_offset(lv, s20678c18f7, ABISELECT(2560,1792), "S20678C18.s20678c18f7");
    check_field_offset(lv, s20678c18f8, ABISELECT(2816,1988), "S20678C18.s20678c18f8");
    test_class_info(&lv, &cd_S20678C18);
    dp->~S20678C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C18(Test_S20678C18, "S20678C18", ABISELECT(9616,6792));

#else // __cplusplus

extern void _ZN9S20678C18C1Ev();
extern void _ZN9S20678C18D1Ev();
Name_Map name_map_S20678C18[] = {
  NSPAIR(_ZN9S20678C18C1Ev),
  NSPAIR(_ZN9S20678C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C2;
extern VTBL_ENTRY _ZTI8S20678C2[];
extern  VTBL_ENTRY _ZTV8S20678C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C2[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C11;
extern VTBL_ENTRY _ZTI9S20678C11[];
extern  VTBL_ENTRY _ZTV9S20678C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C11[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C9;
extern VTBL_ENTRY _ZTI8S20678C9[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C8;
extern VTBL_ENTRY _ZTI8S20678C8[];
extern  VTBL_ENTRY _ZTV8S20678C8[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C16;
extern VTBL_ENTRY _ZTI9S20678C16[];
extern  VTBL_ENTRY _ZTV9S20678C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C16[];
extern Class_Descriptor cd_S20678C15;
extern VTBL_ENTRY _ZTI9S20678C15[];
extern  VTBL_ENTRY _ZTV9S20678C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C15[];
extern Class_Descriptor cd_S20678C19;
extern VTBL_ENTRY _ZTI9S20678C19[];
extern  VTBL_ENTRY _ZTV9S20678C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C19[];
static Base_Class bases_S20678C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(4328,3040), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(3920,2748), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(3920,2748), //bcp->offset
    24, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20678C2,    ABISELECT(4376,3080), //bcp->offset
    33, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(4720,3316), //bcp->offset
    51, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20678C12,    ABISELECT(4480,3152), //bcp->offset
    43, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20678C11,    ABISELECT(2832,1996), //bcp->offset
    13, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20677C3,    ABISELECT(5104,3580), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20678C9,    ABISELECT(5104,3580), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20678C12,    ABISELECT(4864,3416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20678C5,    ABISELECT(8560,6052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(8560,6052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20678C5,    ABISELECT(8976,6344), //bcp->offset
    89, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20678C8,    ABISELECT(9168,6472), //bcp->offset
    92, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(9440,6656), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20678C16,    ABISELECT(9440,6656), //bcp->offset
    96, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S20678C15,    ABISELECT(8560,6052), //bcp->offset
    74, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S20678C19,    ABISELECT(4864,3416), //bcp->offset
    54, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C18[];
extern void _ZN9S20678C183v21Ev();
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN9S20678C193v17Ev();
extern void _ZN9S20678C193v18Ev();
extern void _ZN9S20678C193v19Ev();
extern void _ZN9S20678C193v20Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
extern void _ZN8S20678C82v8Ev();
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY vtc_S20678C18[] = {
  ABISELECT(9440,6656),
  ABISELECT(9168,6472),
  ABISELECT(8560,6052),
  ABISELECT(4864,3416),
  ABISELECT(4720,3316),
  ABISELECT(4480,3152),
  ABISELECT(4376,3080),
  ABISELECT(4328,3040),
  ABISELECT(3920,2748),
  ABISELECT(2832,1996),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN9S20678C183v21Ev,
  0,
  0,
  ABISELECT(1888,1320),
  ABISELECT(1648,1156),
  ABISELECT(1544,1084),
  ABISELECT(1496,1044),
  ABISELECT(1088,752),
  ABISELECT(-2832,-1996),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-3920,-2748),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-4376,-3080),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-4480,-3152),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  ABISELECT(-392,-276),
  ABISELECT(-4720,-3316),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(4576,3240),
  ABISELECT(4304,3056),
  ABISELECT(-384,-264),
  ABISELECT(3696,2636),
  ABISELECT(-144,-100),
  ABISELECT(-536,-376),
  ABISELECT(-4864,-3416),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v20Ev,
  0,
  0,
  0,
  0,
  ABISELECT(880,604),
  ABISELECT(608,420),
  ABISELECT(-3840,-2736),
  ABISELECT(-4080,-2900),
  ABISELECT(-4232,-3012),
  ABISELECT(-8560,-6052),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
  ABISELECT(-4648,-3304),
  ABISELECT(-8976,-6344),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  0,
  ABISELECT(-9168,-6472),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
  0,
  ABISELECT(-5112,-3616),
  ABISELECT(-9440,-6656),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern VTBL_ENTRY _ZTV9S20678C18[];
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C11__9S20678C18[] = {
  ABISELECT(1888,1320),
  ABISELECT(1648,1156),
  ABISELECT(1544,1084),
  ABISELECT(1496,1044),
  ABISELECT(1088,752),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C11__9S20678C18[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-1088,-752),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C11__9S20678C18[] = {
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-1544,-1084),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C11__9S20678C18[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-1648,-1156),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C11__9S20678C18[] = {
  ABISELECT(-392,-276),
  ABISELECT(-1888,-1320),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C18[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C4__9S20678C18[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C18[] = {
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__8S20678C2__9S20678C18[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(456,332),
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C18[] = {
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__9S20678C18[] = {
  ABISELECT(-392,-276),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C18[] = {
  ABISELECT(-392,-276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN9S20678C193v17Ev();
extern void _ZN9S20678C193v18Ev();
extern void _ZN9S20678C193v19Ev();
extern void _ZN9S20678C193v20Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C19__9S20678C18[] = {
  ABISELECT(4576,3240),
  ABISELECT(4304,3056),
  ABISELECT(-384,-264),
  ABISELECT(3696,2636),
  ABISELECT(-144,-100),
  ABISELECT(-536,-376),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v20Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C129S20678C19__A1__9S20678C18[] = {
  ABISELECT(-144,-100),
  ABISELECT(-536,-376),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C129S20678C19__A1__9S20678C18[] = {
  ABISELECT(-392,-276),
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C19__9S20678C18[] = {
  ABISELECT(-392,-276),
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C15__9S20678C19__9S20678C18[] = {
  0,
  0,
  0,
  0,
  ABISELECT(880,604),
  ABISELECT(608,420),
  ABISELECT(-3840,-2736),
  ABISELECT(-4080,-2900),
  ABISELECT(-4232,-3012),
  ABISELECT(-3696,-2636),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__A1__9S20678C19__9S20678C18[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(384,264),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C15__A2__9S20678C19__9S20678C18[] = {
  ABISELECT(-4648,-3304),
  ABISELECT(-4112,-2928),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
};
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C8__9S20678C19__9S20678C18[] = {
  0,
  ABISELECT(-4304,-3056),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C19__9S20678C18[] = {
  0,
  ABISELECT(-5112,-3616),
  ABISELECT(-4576,-3240),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C15__9S20678C18[] = {
  ABISELECT(880,604),
  ABISELECT(608,420),
  ABISELECT(-3840,-2736),
  ABISELECT(-4080,-2900),
  ABISELECT(-4232,-3012),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C49S20678C15__A1__9S20678C18[] = {
  ABISELECT(-4232,-3012),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C49S20678C15__A2__9S20678C18[] = {
  ABISELECT(-4232,-3012),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C15__A3__9S20678C18[] = {
  ABISELECT(-4648,-3304),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C15__9S20678C18[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(4080,2900),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C15__9S20678C18[] = {
  ABISELECT(-392,-276),
  ABISELECT(3840,2736),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A__9S20678C15__9S20678C18[] = {
  ABISELECT(-4648,-3304),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
};
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C8__9S20678C15__9S20678C18[] = {
  0,
  ABISELECT(-608,-420),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C15__9S20678C18[] = {
  0,
  ABISELECT(-5112,-3616),
  ABISELECT(-880,-604),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C18[] = {
  ABISELECT(-5112,-3616),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C16[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C16__A4__9S20678C18[] = {
  ABISELECT(-5112,-3616),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C18[] = {
  {&(_ZTV9S20678C18[12]),  12,101},
  {&(_ZTV9S20678C18[22]),  22,101},
  {&(_ZTV9S20678C18[30]),  30,101},
  {&(_ZTV9S20678C18[40]),  40,101},
  {&(_ZTV9S20678C18[49]),  49,101},
  {&(_ZTV9S20678C18[54]),  54,101},
  {&(_ZTV9S20678C18[68]),  68,101},
  {&(_ZTV9S20678C18[85]),  85,101},
  {&(_ZTV9S20678C18[92]),  92,101},
  {&(_ZTV9S20678C18[95]),  95,101},
  {&(_ZTV9S20678C18[100]),  100,101},
  {&(_tg__ZTV9S20678C11__9S20678C18[7]),  7,9},
  {&(_tg__ZTV8S20678C4__9S20678C11__9S20678C18[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C11__9S20678C18[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C11__9S20678C18[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C11__9S20678C18[3]),  3,3},
  {&(_tg__ZTV8S20678C4__9S20678C18[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C4__9S20678C18[3]),  3,3},
  {&(_tg__ZTV8S20678C2__9S20678C18[4]),  4,7},
  {&(_tg__ZTV8S20678C4__8S20678C2__9S20678C18[6]),  6,9},
  {&(_tg__ZTV9S20678C12__9S20678C18[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__9S20678C18[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A1__9S20678C18[3]),  3,3},
  {&(_tg__ZTV9S20678C19__9S20678C18[8]),  8,14},
  {&(_tg__ZTV9S20678C129S20678C19__A1__9S20678C18[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C129S20678C19__A1__9S20678C18[3]),  3,3},
  {&(_tg__ZTV8S20678C5__9S20678C19__9S20678C18[3]),  3,3},
  {&(_tg__ZTV9S20678C15__9S20678C19__9S20678C18[11]),  11,15},
  {&(_tg__ZTV9S20678C12__A1__9S20678C19__9S20678C18[6]),  6,8},
  {&(_tg__ZTV8S20678C59S20678C15__A2__9S20678C19__9S20678C18[3]),  3,3},
  {&(_tg__ZTV8S20678C8__9S20678C19__9S20678C18[3]),  3,4},
  {&(_tg__ZTV9S20678C16__9S20678C19__9S20678C18[4]),  4,5},
  {&(_tg__ZTV9S20678C15__9S20678C18[7]),  7,11},
  {&(_tg__ZTV8S20678C49S20678C15__A1__9S20678C18[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C49S20678C15__A2__9S20678C18[3]),  3,3},
  {&(_tg__ZTV8S20678C59S20678C15__A3__9S20678C18[3]),  3,3},
  {&(_tg__ZTV9S20678C12__9S20678C15__9S20678C18[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C15__9S20678C18[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A__9S20678C15__9S20678C18[3]),  3,3},
  {&(_tg__ZTV8S20678C8__9S20678C15__9S20678C18[3]),  3,4},
  {&(_tg__ZTV9S20678C16__9S20678C15__9S20678C18[4]),  4,5},
  {&(_tg__ZTV9S20678C16__9S20678C18[3]),  3,4},
  {&(_tg__ZTV8S20678C59S20678C16__A4__9S20678C18[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20678C18[];
extern  VTBL_ENTRY _ZTV9S20678C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C18[];
Class_Descriptor cd_S20678C18 = {  "S20678C18", // class name
  bases_S20678C18, 18,
  &(vtc_S20678C18[0]), // expected_vtbl_contents
  &(vtt_S20678C18[0]), // expected_vtt_contents
  ABISELECT(9616,6792), // object size
  NSPAIRA(_ZTI9S20678C18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20678C18),101, //virtual function table var
  12, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C18),43, //virtual table table var
  15, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C22  : S20678C10 , S20678C5 , virtual S20678C11 {
  void *s20678c22f0;
  ::S20677C6_nt s20678c22f1;
  __tsi64 s20678c22f2;
  virtual  ~S20678C22(); // _ZN9S20678C22D2Ev
  S20678C22(); // tgen
};
//SIG(-1 S20678C22) C1{ BC2{ BC3{ VBC4{ VBC5{ m Fp FL[4] Fs} BC6{ VBC5 FD Fi FC5 FC5} v1 v2 v3 Fs FL Fc Fi[2] FC6 Fp FL Fi FL Fi} VBC7{ VBC5 VBC4 v4 v5 v6 FL FC8{} Fp Fc[2] FC5 Fl FC8} VBC9{ VBC5 VBC6 v7 v8 Fi FC6 FL Fi Fp} v9 v10 FC8 FC8 Fi FC6 FC8 FC8 FC10{ v12 FC8 FC6 FC8 FL FC8 Fp FC8 Fp[2] FC8} FC7 Fp FC8} v11 Fi[2] FC8 FC8 FC8 FC8 FC8 FC11{ VBC6 BC3 BC9 Fi Fc:2 FC8 Fi} FL[4] FC8 FC12{ BC13{ BC4 VBC9 BC6 VBC10 VBC14{ BC6 v13 FL Fc[7] Fp Fi FC8 FC8 Fc[10]} v14 Fl FL FD FC8} BC15{ VBC10 v15 FC13 FC8 FL Fi[2]} BC11 Fp FL Fi Fp Fi[3] Fc FL Fp FD}[2] Fc FC8} BC6 VBC3 vd Fp FC8 FL}


 S20678C22 ::~S20678C22(){ note_dtor("S20678C22", this);}
S20678C22 ::S20678C22(){ note_ctor("S20678C22", this);} // tgen

static void Test_S20678C22()
{
  extern Class_Descriptor cd_S20678C22;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(974,2718)];
    init_test(&cd_S20678C22, buf);
    S20678C22 *dp, &lv = *(dp=new (buf) S20678C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(15568,10868), "sizeof(S20678C22)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C22)");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*), ABISELECT(13944,9740), "S20678C22");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*), ABISELECT(13944,9740), "S20678C22");
    check_base_class_offset(lv, (S20677C3*)(S20678C2*), ABISELECT(13944,9740), "S20678C22");
    check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(13944,9740), "S20678C22");
    /*is_ambiguous_... S20678C22::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(13944,9740), "S20678C22");
    /*is_ambiguous_... S20678C22::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(13944,9740), "S20678C22");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*), ABISELECT(13536,9448), "S20678C22");
    check_base_class_offset(lv, (S20678C4*)(S20678C11*)(S20678C10*), ABISELECT(13536,9448), "S20678C22");
    check_base_class_offset(lv, (S20678C4*)(S20678C2*), ABISELECT(13536,9448), "S20678C22");
    /*is_ambiguous_... S20678C22::S20678C11 */ AMB_check_base_class_offset(lv, (S20678C4*)(S20678C11*), ABISELECT(13536,9448), "S20678C22");
    check_base_class_offset(lv, (S20678C2*)(S20678C11*)(S20678C10*), ABISELECT(13992,9780), "S20678C22");
    /*is_ambiguous_... S20678C22::S20678C11 */ AMB_check_base_class_offset(lv, (S20678C2*)(S20678C11*), ABISELECT(13992,9780), "S20678C22");
    check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(14336,10016), "S20678C22");
    check_base_class_offset(lv, (S20678C12*)(S20678C11*)(S20678C10*), ABISELECT(14096,9852), "S20678C22");
    /*is_ambiguous_... S20678C22::S20678C11 */ AMB_check_base_class_offset(lv, (S20678C12*)(S20678C11*), ABISELECT(14096,9852), "S20678C22");
    check_base_class_offset(lv, (S20678C11*)(S20678C10*), 0, "S20678C22");
    check_base_class_offset(lv, (S20678C10*), 0, "S20678C22");
    /*is_ambiguous_... S20678C22::S20678C5 */ AMB_check_base_class_offset(lv, (S20678C5*), ABISELECT(13376,9332), "S20678C22");
    /*is_ambiguous_... S20678C22::S20678C11 */ AMB_check_base_class_offset(lv, (S20678C11*), ABISELECT(14480,10116), "S20678C22");
    check_field_offset(lv, s20678c22f0, ABISELECT(13512,9432), "S20678C22.s20678c22f0");
    check_field_offset(lv, s20678c22f1, ABISELECT(13520,9436), "S20678C22.s20678c22f1");
    check_field_offset(lv, s20678c22f2, ABISELECT(13528,9440), "S20678C22.s20678c22f2");
    test_class_info(&lv, &cd_S20678C22);
    dp->~S20678C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C22(Test_S20678C22, "S20678C22", ABISELECT(15568,10868));

#else // __cplusplus

extern void _ZN9S20678C22C1Ev();
extern void _ZN9S20678C22D2Ev();
Name_Map name_map_S20678C22[] = {
  NSPAIR(_ZN9S20678C22C1Ev),
  NSPAIR(_ZN9S20678C22D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C2;
extern VTBL_ENTRY _ZTI8S20678C2[];
extern  VTBL_ENTRY _ZTV8S20678C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C2[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C11;
extern VTBL_ENTRY _ZTI9S20678C11[];
extern  VTBL_ENTRY _ZTV9S20678C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C11[];
extern Class_Descriptor cd_S20678C10;
extern VTBL_ENTRY _ZTI9S20678C10[];
extern  VTBL_ENTRY _ZTV9S20678C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C10[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C11;
extern VTBL_ENTRY _ZTI9S20678C11[];
extern  VTBL_ENTRY _ZTV9S20678C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C11[];
static Base_Class bases_S20678C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(13944,9740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(13536,9448), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(13536,9448), //bcp->offset
    16, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20678C2,    ABISELECT(13992,9780), //bcp->offset
    25, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(14336,10016), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20678C12,    ABISELECT(14096,9852), //bcp->offset
    35, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20678C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20678C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20678C5,    ABISELECT(13376,9332), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20678C11,    ABISELECT(14480,10116), //bcp->offset
    46, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20678C22[];
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN9S20678C103v14Ev();
extern void _ZN9S20678C22D1Ev();
extern void _ZN9S20678C22D0Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY vtc_S20678C22[] = {
  ABISELECT(14480,10116),
  ABISELECT(14336,10016),
  ABISELECT(14096,9852),
  ABISELECT(13992,9780),
  ABISELECT(13944,9740),
  ABISELECT(13536,9448),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C22[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20678C103v14Ev,
  (VTBL_ENTRY)&_ZN9S20678C22D1Ev,
  (VTBL_ENTRY)&_ZN9S20678C22D0Ev,
  ABISELECT(568,408),
  ABISELECT(-13376,-9332),
  (VTBL_ENTRY)&(_ZTI9S20678C22[0]),
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-13536,-9448),
  (VTBL_ENTRY)&(_ZTI9S20678C22[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-13992,-9780),
  (VTBL_ENTRY)&(_ZTI9S20678C22[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-14096,-9852),
  (VTBL_ENTRY)&(_ZTI9S20678C22[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  ABISELECT(-392,-276),
  ABISELECT(-14336,-10016),
  (VTBL_ENTRY)&(_ZTI9S20678C22[0]),
  0,
  0,
  ABISELECT(-144,-100),
  ABISELECT(-384,-264),
  ABISELECT(-488,-336),
  ABISELECT(-536,-376),
  ABISELECT(-944,-668),
  ABISELECT(-14480,-10116),
  (VTBL_ENTRY)&(_ZTI9S20678C22[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern VTBL_ENTRY _ZTV9S20678C22[];
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN9S20678C103v14Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C10__9S20678C22[] = {
  ABISELECT(14336,10016),
  ABISELECT(14096,9852),
  ABISELECT(13992,9780),
  ABISELECT(13944,9740),
  ABISELECT(13536,9448),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20678C103v14Ev,
};
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C119S20678C10__9S20678C22[] = {
  ABISELECT(14336,10016),
  ABISELECT(14096,9852),
  ABISELECT(13992,9780),
  ABISELECT(13944,9740),
  ABISELECT(13536,9448),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C119S20678C10__9S20678C22[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-13536,-9448),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C119S20678C10__9S20678C22[] = {
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-13992,-9780),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C119S20678C10__9S20678C22[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-14096,-9852),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C119S20678C10__9S20678C22[] = {
  ABISELECT(-392,-276),
  ABISELECT(-14336,-10016),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C10__9S20678C22[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(-13536,-9448),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C10__9S20678C22[] = {
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(-13992,-9780),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C10__9S20678C22[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(-14096,-9852),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C10__9S20678C22[] = {
  ABISELECT(-392,-276),
  ABISELECT(-14336,-10016),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A__9S20678C22[] = {
  ABISELECT(568,408),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C22[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C4__9S20678C22[] = {
  ABISELECT(408,292),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C22[] = {
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__8S20678C2__9S20678C22[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(456,332),
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C22[] = {
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__9S20678C22[] = {
  ABISELECT(-392,-276),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C22[] = {
  ABISELECT(-392,-276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C11__A1__9S20678C22[] = {
  ABISELECT(-144,-100),
  ABISELECT(-384,-264),
  ABISELECT(-488,-336),
  ABISELECT(-536,-376),
  ABISELECT(-944,-668),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C11__A1__9S20678C22[] = {
  0,
  0,
  0,
  ABISELECT(408,292),
  ABISELECT(944,668),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C11__A1__9S20678C22[] = {
  0,
  0,
  0,
  ABISELECT(-456,-332),
  ABISELECT(-48,-40),
  ABISELECT(488,336),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C11__A1__9S20678C22[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-152,-112),
  ABISELECT(384,264),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C11__A1__9S20678C22[] = {
  ABISELECT(-392,-276),
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
};
static  VTT_ENTRY vtt_S20678C22[] = {
  {&(_ZTV9S20678C22[8]),  8,57},
  {&(_tg__ZTV9S20678C10__9S20678C22[7]),  7,10},
  {&(_tg__ZTV9S20678C119S20678C10__9S20678C22[7]),  7,9},
  {&(_tg__ZTV8S20678C4__9S20678C119S20678C10__9S20678C22[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C119S20678C10__9S20678C22[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C119S20678C10__9S20678C22[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C119S20678C10__9S20678C22[3]),  3,3},
  {&(_tg__ZTV8S20678C4__9S20678C10__9S20678C22[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C10__9S20678C22[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C10__9S20678C22[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C10__9S20678C22[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A__9S20678C22[3]),  3,3},
  {&(_ZTV9S20678C22[22]),  22,57},
  {&(_ZTV9S20678C22[32]),  32,57},
  {&(_ZTV9S20678C22[41]),  41,57},
  {&(_ZTV9S20678C22[46]),  46,57},
  {&(_ZTV9S20678C22[16]),  16,57},
  {&(_ZTV9S20678C22[55]),  55,57},
  {&(_tg__ZTV8S20678C4__9S20678C22[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C4__9S20678C22[3]),  3,3},
  {&(_tg__ZTV8S20678C2__9S20678C22[4]),  4,7},
  {&(_tg__ZTV8S20678C4__8S20678C2__9S20678C22[6]),  6,9},
  {&(_tg__ZTV9S20678C12__9S20678C22[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__9S20678C22[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A1__9S20678C22[3]),  3,3},
  {&(_tg__ZTV9S20678C11__A1__9S20678C22[7]),  7,9},
  {&(_tg__ZTV8S20678C4__9S20678C11__A1__9S20678C22[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C11__A1__9S20678C22[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C11__A1__9S20678C22[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C11__A1__9S20678C22[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20678C22[];
extern  VTBL_ENTRY _ZTV9S20678C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C22[];
Class_Descriptor cd_S20678C22 = {  "S20678C22", // class name
  bases_S20678C22, 10,
  &(vtc_S20678C22[0]), // expected_vtbl_contents
  &(vtt_S20678C22[0]), // expected_vtt_contents
  ABISELECT(15568,10868), // object size
  NSPAIRA(_ZTI9S20678C22),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20678C22),57, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20678C22),30, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20678C1  : virtual S20678C2 , virtual S20678C7 , virtual S20678C10 , virtual S20678C18 {
  int s20678c1f0[2];
  char s20678c1f1;
  void *s20678c1f2;
  int s20678c1f3;
  ::S20678C22 s20678c1f4;
  virtual  ~S20678C1(); // _ZN8S20678C1D2Ev
  virtual void  v1(); // _ZN8S20678C12v1Ev
  S20678C1(); // tgen
};
//SIG(1 S20678C1) C1{ VBC2{ VBC3{ m Fp FL[4] Fs} VBC4{ VBC3 BC5{ VBC3 FD Fi FC3 FC3} v2 v3 v4 Fs FL Fc Fi[2] FC5 Fp FL Fi FL Fi} v5 v6 v7 FL FC6{} Fp Fc[2] FC3 Fl FC6} VBC7{ VBC8{ v8 FC6 FC5 FC6 FL FC6 Fp FC6 Fp[2] FC6} BC5 BC9{ BC3 FC3 Fi FD Fi FL Fl} v9 Fp FC9 Fp Fi[2] FD Fi[2]} VBC10{ BC11{ VBC4 VBC2 VBC12{ VBC3 VBC5 v10 v11 Fi FC5 FL Fi Fp} v12 v13 FC6 FC6 Fi FC5 FC6 FC6 FC8 FC2 Fp FC6} v14 Fi[2] FC6 FC6 FC6 FC6 FC6 FC13{ VBC5 BC11 BC12 Fi Fc:2 FC6 Fi} FL[4] FC6 FC14{ BC15{ BC4 VBC12 BC5 VBC8 VBC16{ BC5 v15 FL Fc[7] Fp Fi FC6 FC6 Fc[10]} v16 Fl FL FD FC6} BC17{ VBC8 v22 FC15 FC6 FL Fi[2]} BC13 Fp FL Fi Fp Fi[3] Fc FL Fp FD}[2] Fc FC6} VBC18{ VBC11 VBC19{ BC9 BC12 VBC15 v17 v18 v19 v20 Fp Fc[4] FC4 Fi[8] FC6 FC7 FC6 FD FC5[9] FD[10] Fs} v21 Fp FC20{ BC13 v23 Fi FC6 Fs FL FC5 FL} Fp FL Fi FC6 Fp FC21{ v24 FL FC16 FC6 Fi} FL} vd v1 Fi[2] Fc Fp Fi FC22{ BC10 BC5 VBC11 vd Fp FC6 FL}}


 S20678C1 ::~S20678C1(){ note_dtor("S20678C1", this);}
void  S20678C1 ::v1(){vfunc_called(this, "_ZN8S20678C12v1Ev");}
S20678C1 ::S20678C1(){ note_ctor("S20678C1", this);} // tgen

static void Test_S20678C1()
{
  extern Class_Descriptor cd_S20678C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(2447,6845)];
    init_test(&cd_S20678C1, buf);
    S20678C1 *dp, &lv = *(dp=new (buf) S20678C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(39136,27376), "sizeof(S20678C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20678C1)");
    check_base_class_offset(lv, (S20677C3*)(S20678C2*), ABISELECT(15720,10964), "S20678C1");
    /*is_ambiguous_... S20678C1::S20678C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C4*), ABISELECT(15720,10964), "S20678C1");
    /*is_ambiguous_... S20678C1::S20678C4 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*), ABISELECT(15720,10964), "S20678C1");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C7*), ABISELECT(15720,10964), "S20678C1");
    /*is_ambiguous_... S20678C1::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*), ABISELECT(15720,10964), "S20678C1");
    /*is_ambiguous_... S20678C1::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*), ABISELECT(15720,10964), "S20678C1");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C12*)(S20678C19*), ABISELECT(15720,10964), "S20678C1");
    check_base_class_offset(lv, (S20677C3*)(S20678C4*)(S20678C15*), ABISELECT(15720,10964), "S20678C1");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C4*)(S20678C15*), ABISELECT(15720,10964), "S20678C1");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C15*), ABISELECT(15720,10964), "S20678C1");
    check_base_class_offset(lv, (S20677C3*)(S20678C5*)(S20678C16*), ABISELECT(15720,10964), "S20678C1");
    /*is_ambiguous_... S20678C1::S20678C4 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C4*), ABISELECT(15776,11004), "S20678C1");
    check_base_class_offset(lv, (S20678C4*)(S20678C2*), ABISELECT(15776,11004), "S20678C1");
    check_base_class_offset(lv, (S20678C4*)(S20678C11*)(S20678C10*), ABISELECT(15776,11004), "S20678C1");
    /*is_ambiguous_... S20678C1::S20678C11 */ AMB_check_base_class_offset(lv, (S20678C4*)(S20678C11*), ABISELECT(15776,11004), "S20678C1");
    check_base_class_offset(lv, (S20678C2*), ABISELECT(15616,10892), "S20678C1");
    check_base_class_offset(lv, (S20678C2*)(S20678C11*)(S20678C10*), ABISELECT(15616,10892), "S20678C1");
    /*is_ambiguous_... S20678C1::S20678C11 */ AMB_check_base_class_offset(lv, (S20678C2*)(S20678C11*), ABISELECT(15616,10892), "S20678C1");
    check_base_class_offset(lv, (S20678C8*)(S20678C7*), ABISELECT(16704,11656), "S20678C1");
    check_base_class_offset(lv, (S20678C8*)(S20678C15*), ABISELECT(16704,11656), "S20678C1");
    check_base_class_offset(lv, (S20678C5*)(S20678C7*), ABISELECT(16192,11296), "S20678C1");
    check_base_class_offset(lv, (S20677C3*)(S20678C9*)(S20678C7*), ABISELECT(16336,11396), "S20678C1");
    check_base_class_offset(lv, (S20678C9*)(S20678C7*), ABISELECT(16336,11396), "S20678C1");
    check_base_class_offset(lv, (S20678C7*), ABISELECT(16192,11296), "S20678C1");
    /*is_ambiguous_... S20678C1::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*), ABISELECT(30592,21336), "S20678C1");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C12*)(S20678C19*), ABISELECT(30592,21336), "S20678C1");
    check_base_class_offset(lv, (S20678C12*)(S20678C11*)(S20678C10*), ABISELECT(30352,21172), "S20678C1");
    /*is_ambiguous_... S20678C1::S20678C11 */ AMB_check_base_class_offset(lv, (S20678C12*)(S20678C11*), ABISELECT(30352,21172), "S20678C1");
    check_base_class_offset(lv, (S20678C12*)(S20678C15*), ABISELECT(30352,21172), "S20678C1");
    check_base_class_offset(lv, (S20678C11*)(S20678C10*), ABISELECT(16976,11840), "S20678C1");
    check_base_class_offset(lv, (S20678C10*), ABISELECT(16976,11840), "S20678C1");
    check_base_class_offset(lv, (S20678C11*)(S20678C18*), ABISELECT(33568,23432), "S20678C1");
    check_base_class_offset(lv, (S20677C3*)(S20678C9*)(S20678C19*), ABISELECT(34896,24348), "S20678C1");
    check_base_class_offset(lv, (S20678C9*)(S20678C19*), ABISELECT(34896,24348), "S20678C1");
    /*is_ambiguous_... S20678C19::S20678C12 */ AMB_check_base_class_offset(lv, (S20678C12*)(S20678C19*), ABISELECT(34656,24184), "S20678C1");
    check_base_class_offset(lv, (S20678C5*)(S20678C4*)(S20678C15*), ABISELECT(38352,26820), "S20678C1");
    check_base_class_offset(lv, (S20678C4*)(S20678C15*), ABISELECT(38352,26820), "S20678C1");
    /*is_ambiguous_... S20678C15::S20678C5 */ AMB_check_base_class_offset(lv, (S20678C5*)(S20678C15*), ABISELECT(38768,27112), "S20678C1");
    check_base_class_offset(lv, (S20678C5*)(S20678C16*), ABISELECT(38960,27240), "S20678C1");
    check_base_class_offset(lv, (S20678C16*)(S20678C15*), ABISELECT(38960,27240), "S20678C1");
    check_base_class_offset(lv, (S20678C15*)(S20678C19*), ABISELECT(38352,26820), "S20678C1");
    check_base_class_offset(lv, (S20678C19*)(S20678C18*), ABISELECT(34656,24184), "S20678C1");
    check_base_class_offset(lv, (S20678C18*), ABISELECT(30736,21436), "S20678C1");
    check_field_offset(lv, s20678c1f0, ABISELECT(8,4), "S20678C1.s20678c1f0");
    check_field_offset(lv, s20678c1f1, ABISELECT(16,12), "S20678C1.s20678c1f1");
    check_field_offset(lv, s20678c1f2, ABISELECT(24,16), "S20678C1.s20678c1f2");
    check_field_offset(lv, s20678c1f3, ABISELECT(32,20), "S20678C1.s20678c1f3");
    check_field_offset(lv, s20678c1f4, ABISELECT(48,24), "S20678C1.s20678c1f4");
    test_class_info(&lv, &cd_S20678C1);
    dp->~S20678C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20678C1(Test_S20678C1, "S20678C1", ABISELECT(39136,27376));

#else // __cplusplus

extern void _ZN8S20678C1C1Ev();
extern void _ZN8S20678C1D2Ev();
Name_Map name_map_S20678C1[] = {
  NSPAIR(_ZN8S20678C1C1Ev),
  NSPAIR(_ZN8S20678C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C2;
extern VTBL_ENTRY _ZTI8S20678C2[];
extern  VTBL_ENTRY _ZTV8S20678C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C2[];
extern Class_Descriptor cd_S20678C8;
extern VTBL_ENTRY _ZTI8S20678C8[];
extern  VTBL_ENTRY _ZTV8S20678C8[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C9;
extern VTBL_ENTRY _ZTI8S20678C9[];
extern Class_Descriptor cd_S20678C7;
extern VTBL_ENTRY _ZTI8S20678C7[];
extern  VTBL_ENTRY _ZTV8S20678C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C7[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C11;
extern VTBL_ENTRY _ZTI9S20678C11[];
extern  VTBL_ENTRY _ZTV9S20678C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C11[];
extern Class_Descriptor cd_S20678C10;
extern VTBL_ENTRY _ZTI9S20678C10[];
extern  VTBL_ENTRY _ZTV9S20678C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C10[];
extern Class_Descriptor cd_S20678C11;
extern VTBL_ENTRY _ZTI9S20678C11[];
extern  VTBL_ENTRY _ZTV9S20678C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C11[];
extern Class_Descriptor cd_S20677C3;
extern VTBL_ENTRY _ZTI8S20677C3[];
extern Class_Descriptor cd_S20678C9;
extern VTBL_ENTRY _ZTI8S20678C9[];
extern Class_Descriptor cd_S20678C12;
extern VTBL_ENTRY _ZTI9S20678C12[];
extern  VTBL_ENTRY _ZTV9S20678C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C12[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C4;
extern VTBL_ENTRY _ZTI8S20678C4[];
extern  VTBL_ENTRY _ZTV8S20678C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C4[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C5;
extern VTBL_ENTRY _ZTI8S20678C5[];
extern  VTBL_ENTRY _ZTV8S20678C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C5[];
extern Class_Descriptor cd_S20678C16;
extern VTBL_ENTRY _ZTI9S20678C16[];
extern  VTBL_ENTRY _ZTV9S20678C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C16[];
extern Class_Descriptor cd_S20678C15;
extern VTBL_ENTRY _ZTI9S20678C15[];
extern  VTBL_ENTRY _ZTV9S20678C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C15[];
extern Class_Descriptor cd_S20678C19;
extern VTBL_ENTRY _ZTI9S20678C19[];
extern  VTBL_ENTRY _ZTV9S20678C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C19[];
extern Class_Descriptor cd_S20678C18;
extern VTBL_ENTRY _ZTI9S20678C18[];
extern  VTBL_ENTRY _ZTV9S20678C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20678C18[];
static Base_Class bases_S20678C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20677C3,    ABISELECT(15720,10964), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(15776,11004), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(15776,11004), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20678C2,    ABISELECT(15616,10892), //bcp->offset
    18, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C8,    ABISELECT(16704,11656), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S20678C5,    ABISELECT(16192,11296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20677C3,    ABISELECT(16336,11396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20678C9,    ABISELECT(16336,11396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20678C7,    ABISELECT(16192,11296), //bcp->offset
    37, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C5,    ABISELECT(30592,21336), //bcp->offset
    68, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S20678C12,    ABISELECT(30352,21172), //bcp->offset
    60, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S20678C11,    ABISELECT(16976,11840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20678C10,    ABISELECT(16976,11840), //bcp->offset
    47, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20678C11,    ABISELECT(33568,23432), //bcp->offset
    85, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S20677C3,    ABISELECT(34896,24348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20678C9,    ABISELECT(34896,24348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20678C12,    ABISELECT(34656,24184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20678C5,    ABISELECT(38352,26820), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20678C4,    ABISELECT(38352,26820), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20678C5,    ABISELECT(38768,27112), //bcp->offset
    131, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20678C5,    ABISELECT(38960,27240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S20678C16,    ABISELECT(38960,27240), //bcp->offset
    134, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    69, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S20678C15,    ABISELECT(38352,26820), //bcp->offset
    116, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S20678C19,    ABISELECT(34656,24184), //bcp->offset
    96, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S20678C18,    ABISELECT(30736,21436), //bcp->offset
    71, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20678C1[];
extern void _ZN8S20678C1D1Ev();
extern void _ZN8S20678C1D0Ev();
extern void _ZN8S20678C12v1Ev();
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN8S20678C72v9Ev();
extern void _ZN8S20678C82v8Ev();
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN9S20678C103v14Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN9S20678C183v21Ev();
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN9S20678C193v17Ev();
extern void _ZN9S20678C193v18Ev();
extern void _ZN9S20678C193v19Ev();
extern void _ZN9S20678C193v20Ev();
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY vtc_S20678C1[] = {
  ABISELECT(38960,27240),
  ABISELECT(38352,26820),
  ABISELECT(34656,24184),
  ABISELECT(33568,23432),
  ABISELECT(30736,21436),
  ABISELECT(30592,21336),
  ABISELECT(30352,21172),
  ABISELECT(16976,11840),
  ABISELECT(16704,11656),
  ABISELECT(16192,11296),
  ABISELECT(15776,11004),
  ABISELECT(15720,10964),
  ABISELECT(15616,10892),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN8S20678C1D1Ev,
  (VTBL_ENTRY)&_ZN8S20678C1D0Ev,
  (VTBL_ENTRY)&_ZN8S20678C12v1Ev,
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(104,72),
  ABISELECT(-15616,-10892),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-15776,-11004),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  0,
  ABISELECT(512,360),
  ABISELECT(-472,-332),
  ABISELECT(-16192,-11296),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN8S20678C72v9Ev,
  0,
  ABISELECT(-16704,-11656),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
  0,
  0,
  0,
  ABISELECT(13616,9496),
  ABISELECT(13376,9332),
  ABISELECT(-1360,-948),
  ABISELECT(-1256,-876),
  ABISELECT(-1200,-836),
  ABISELECT(-16976,-11840),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20678C103v14Ev,
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10208),
  ABISELECT(-30352,-21172),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  ABISELECT(-14872,-10372),
  ABISELECT(-30592,-21336),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  0,
  ABISELECT(8224,5804),
  ABISELECT(-14032,-9780),
  ABISELECT(7616,5384),
  ABISELECT(3920,2748),
  ABISELECT(-144,-100),
  ABISELECT(-384,-264),
  ABISELECT(-15120,-10544),
  ABISELECT(-15016,-10472),
  ABISELECT(-14960,-10432),
  ABISELECT(2832,1996),
  ABISELECT(-30736,-21436),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN9S20678C183v21Ev,
  0,
  0,
  ABISELECT(-2976,-2096),
  ABISELECT(-3216,-2260),
  ABISELECT(-17952,-12540),
  ABISELECT(-17848,-12468),
  ABISELECT(-17792,-12428),
  ABISELECT(-33568,-23432),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(4304,3056),
  ABISELECT(-17952,-12528),
  ABISELECT(-4304,-3012),
  ABISELECT(3696,2636),
  ABISELECT(-4064,-2848),
  ABISELECT(-18936,-13220),
  ABISELECT(-34656,-24184),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v20Ev,
  0,
  0,
  0,
  0,
  ABISELECT(608,420),
  ABISELECT(-21648,-15164),
  ABISELECT(-7760,-5484),
  ABISELECT(-8000,-5648),
  ABISELECT(-22632,-15856),
  ABISELECT(-38352,-26820),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
  ABISELECT(-23048,-16148),
  ABISELECT(-38768,-27112),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  0,
  ABISELECT(-23240,-16276),
  ABISELECT(-38960,-27240),
  (VTBL_ENTRY)&(_ZTI8S20678C1[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern VTBL_ENTRY _ZTV8S20678C1[];
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__8S20678C1[] = {
  ABISELECT(160,112),
  ABISELECT(104,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__8S20678C2__8S20678C1[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI8S20678C2[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__8S20678C1[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C4__8S20678C1[] = {
  ABISELECT(-56,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C72v9Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C7__8S20678C1[] = {
  ABISELECT(512,360),
  ABISELECT(-472,-332),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C7[0]),
  (VTBL_ENTRY)&_ZN8S20678C72v9Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C7__A1__8S20678C1[] = {
  ABISELECT(-472,-332),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C8__8S20678C7__8S20678C1[] = {
  0,
  ABISELECT(-512,-360),
  (VTBL_ENTRY)&(_ZTI8S20678C7[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
extern void _ZN9S20678C103v14Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C10__8S20678C1[] = {
  ABISELECT(13616,9496),
  ABISELECT(13376,9332),
  ABISELECT(-1360,-948),
  ABISELECT(-1256,-876),
  ABISELECT(-1200,-836),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
  (VTBL_ENTRY)&_ZN9S20678C103v14Ev,
};
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C119S20678C10__8S20678C1[] = {
  ABISELECT(13616,9496),
  ABISELECT(13376,9332),
  ABISELECT(-1360,-948),
  ABISELECT(-1256,-876),
  ABISELECT(-1200,-836),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C119S20678C10__8S20678C1[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(1200,836),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C119S20678C10__8S20678C1[] = {
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(104,72),
  ABISELECT(1360,948),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C119S20678C10__8S20678C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10208),
  ABISELECT(-13376,-9332),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C119S20678C10__8S20678C1[] = {
  ABISELECT(-14872,-10372),
  ABISELECT(-13616,-9496),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C10__8S20678C1[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(1200,836),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C10__8S20678C1[] = {
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(104,72),
  ABISELECT(1360,948),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C10__8S20678C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10208),
  ABISELECT(-13376,-9332),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C10__8S20678C1[] = {
  ABISELECT(-14872,-10372),
  ABISELECT(-13616,-9496),
  (VTBL_ENTRY)&(_ZTI9S20678C10[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__8S20678C1[] = {
  ABISELECT(240,164),
  ABISELECT(-14632,-10208),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C12__8S20678C1[] = {
  ABISELECT(-14872,-10372),
  ABISELECT(-240,-164),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A2__8S20678C1[] = {
  ABISELECT(-14872,-10372),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN9S20678C183v21Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C18__8S20678C1[] = {
  ABISELECT(8224,5804),
  ABISELECT(-14032,-9780),
  ABISELECT(7616,5384),
  ABISELECT(3920,2748),
  ABISELECT(-144,-100),
  ABISELECT(-384,-264),
  ABISELECT(-15120,-10544),
  ABISELECT(-15016,-10472),
  ABISELECT(-14960,-10432),
  ABISELECT(2832,1996),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN9S20678C183v21Ev,
};
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C11__9S20678C18__8S20678C1[] = {
  0,
  0,
  ABISELECT(-2976,-2096),
  ABISELECT(-3216,-2260),
  ABISELECT(-17952,-12540),
  ABISELECT(-17848,-12468),
  ABISELECT(-17792,-12428),
  ABISELECT(-2832,-1996),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C18__8S20678C1[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(14960,10432),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C18__8S20678C1[] = {
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(104,72),
  ABISELECT(15120,10544),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C18__8S20678C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10208),
  ABISELECT(384,264),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C18__8S20678C1[] = {
  ABISELECT(-14872,-10372),
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN9S20678C193v17Ev();
extern void _ZN9S20678C193v18Ev();
extern void _ZN9S20678C193v19Ev();
extern void _ZN9S20678C193v20Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C19__9S20678C18__8S20678C1[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(4304,3056),
  ABISELECT(-17952,-12528),
  ABISELECT(-4304,-3012),
  ABISELECT(3696,2636),
  ABISELECT(-4064,-2848),
  ABISELECT(-18936,-13220),
  ABISELECT(-3920,-2748),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v20Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C15__9S20678C18__8S20678C1[] = {
  0,
  0,
  0,
  0,
  ABISELECT(608,420),
  ABISELECT(-21648,-15164),
  ABISELECT(-7760,-5484),
  ABISELECT(-8000,-5648),
  ABISELECT(-22632,-15856),
  ABISELECT(-7616,-5384),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C15__A3__9S20678C18__8S20678C1[] = {
  ABISELECT(-23048,-16148),
  ABISELECT(-8032,-5676),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
};
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C8__9S20678C18__8S20678C1[] = {
  0,
  ABISELECT(14032,9780),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C18__8S20678C1[] = {
  0,
  ABISELECT(-23240,-16276),
  ABISELECT(-8224,-5804),
  (VTBL_ENTRY)&(_ZTI9S20678C18[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern void _ZN9S20678C113v12Ev();
extern void _ZN9S20678C113v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C11__A1__8S20678C1[] = {
  ABISELECT(-2976,-2096),
  ABISELECT(-3216,-2260),
  ABISELECT(-17952,-12540),
  ABISELECT(-17848,-12468),
  ABISELECT(-17792,-12428),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C113v12Ev,
  (VTBL_ENTRY)&_ZN9S20678C113v13Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C4__9S20678C11__A1__8S20678C1[] = {
  0,
  0,
  0,
  ABISELECT(-56,-40),
  ABISELECT(17792,12428),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
extern void _ZN8S20678C22v5Ev();
extern void _ZN8S20678C22v6Ev();
extern void _ZN8S20678C22v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C2__9S20678C11__A1__8S20678C1[] = {
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(104,72),
  ABISELECT(17952,12540),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN8S20678C22v5Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v6Ev,
  (VTBL_ENTRY)&_ZN8S20678C22v7Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C11__A1__8S20678C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10208),
  ABISELECT(3216,2260),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C11__A1__8S20678C1[] = {
  ABISELECT(-14872,-10372),
  ABISELECT(2976,2096),
  (VTBL_ENTRY)&(_ZTI9S20678C11[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
extern void _ZN9S20678C193v17Ev();
extern void _ZN9S20678C193v18Ev();
extern void _ZN9S20678C193v19Ev();
extern void _ZN9S20678C193v20Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C19__8S20678C1[] = {
  ABISELECT(4304,3056),
  ABISELECT(-17952,-12528),
  ABISELECT(-4304,-3012),
  ABISELECT(3696,2636),
  ABISELECT(-4064,-2848),
  ABISELECT(-18936,-13220),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v17Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v18Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v19Ev,
  (VTBL_ENTRY)&_ZN9S20678C193v20Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C129S20678C19__A1__8S20678C1[] = {
  ABISELECT(-4064,-2848),
  ABISELECT(-18936,-13220),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C129S20678C19__A1__8S20678C1[] = {
  ABISELECT(-14872,-10372),
  ABISELECT(4064,2848),
  (VTBL_ENTRY)&(_ZTI9S20678C12[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__9S20678C19__8S20678C1[] = {
  ABISELECT(-14872,-10372),
  ABISELECT(4064,2848),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C15__9S20678C19__8S20678C1[] = {
  0,
  0,
  0,
  0,
  ABISELECT(608,420),
  ABISELECT(-21648,-15164),
  ABISELECT(-7760,-5484),
  ABISELECT(-8000,-5648),
  ABISELECT(-22632,-15856),
  ABISELECT(-3696,-2636),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__A1__9S20678C19__8S20678C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10208),
  ABISELECT(4304,3012),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C15__A2__9S20678C19__8S20678C1[] = {
  ABISELECT(-23048,-16148),
  ABISELECT(-4112,-2928),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
};
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C8__9S20678C19__8S20678C1[] = {
  0,
  ABISELECT(17952,12528),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C19__8S20678C1[] = {
  0,
  ABISELECT(-23240,-16276),
  ABISELECT(-4304,-3056),
  (VTBL_ENTRY)&(_ZTI9S20678C19[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
extern void _ZN9S20678C153v16Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C15__8S20678C1[] = {
  ABISELECT(608,420),
  ABISELECT(-21648,-15164),
  ABISELECT(-7760,-5484),
  ABISELECT(-8000,-5648),
  ABISELECT(-22632,-15856),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
  (VTBL_ENTRY)&_ZN9S20678C153v16Ev,
};
extern void _ZN8S20678C42v2Ev();
extern void _ZN8S20678C42v3Ev();
extern void _ZN8S20678C42v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C49S20678C15__A1__8S20678C1[] = {
  ABISELECT(-22632,-15856),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C4[0]),
  (VTBL_ENTRY)&_ZN8S20678C42v2Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v3Ev,
  (VTBL_ENTRY)&_ZN8S20678C42v4Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C58S20678C49S20678C15__A3__8S20678C1[] = {
  ABISELECT(-22632,-15856),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C15__A4__8S20678C1[] = {
  ABISELECT(-23048,-16148),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
extern void _ZN9S20678C123v10Ev();
extern void _ZN9S20678C123v11Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C12__9S20678C15__8S20678C1[] = {
  0,
  0,
  ABISELECT(240,164),
  ABISELECT(-14632,-10208),
  ABISELECT(8000,5648),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN9S20678C123v10Ev,
  (VTBL_ENTRY)&_ZN9S20678C123v11Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A1__9S20678C15__8S20678C1[] = {
  ABISELECT(-14872,-10372),
  ABISELECT(7760,5484),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
};
static  VTBL_ENTRY _tg__ZTV8S20678C5__A__9S20678C15__8S20678C1[] = {
  ABISELECT(-23048,-16148),
  ABISELECT(-416,-292),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
};
extern void _ZN8S20678C82v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20678C8__9S20678C15__8S20678C1[] = {
  0,
  ABISELECT(21648,15164),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN8S20678C82v8Ev,
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__9S20678C15__8S20678C1[] = {
  0,
  ABISELECT(-23240,-16276),
  ABISELECT(-608,-420),
  (VTBL_ENTRY)&(_ZTI9S20678C15[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
extern void _ZN9S20678C163v15Ev();
static  VTBL_ENTRY _tg__ZTV9S20678C16__8S20678C1[] = {
  ABISELECT(-23240,-16276),
  0,
  (VTBL_ENTRY)&(_ZTI9S20678C16[0]),
  (VTBL_ENTRY)&_ZN9S20678C163v15Ev,
};
static  VTBL_ENTRY _tg__ZTV8S20678C59S20678C16__A5__8S20678C1[] = {
  ABISELECT(-23240,-16276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20678C5[0]),
};
static  VTT_ENTRY vtt_S20678C1[] = {
  {&(_ZTV8S20678C1[15]),  15,139},
  {&(_ZTV8S20678C1[25]),  25,139},
  {&(_ZTV8S20678C1[34]),  34,139},
  {&(_ZTV8S20678C1[42]),  42,139},
  {&(_ZTV8S20678C1[46]),  46,139},
  {&(_ZTV8S20678C1[57]),  57,139},
  {&(_ZTV8S20678C1[66]),  66,139},
  {&(_ZTV8S20678C1[71]),  71,139},
  {&(_ZTV8S20678C1[84]),  84,139},
  {&(_ZTV8S20678C1[94]),  94,139},
  {&(_ZTV8S20678C1[110]),  110,139},
  {&(_ZTV8S20678C1[127]),  127,139},
  {&(_ZTV8S20678C1[134]),  134,139},
  {&(_ZTV8S20678C1[138]),  138,139},
  {&(_tg__ZTV8S20678C2__8S20678C1[4]),  4,7},
  {&(_tg__ZTV8S20678C4__8S20678C2__8S20678C1[6]),  6,9},
  {&(_tg__ZTV8S20678C4__8S20678C1[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C4__8S20678C1[3]),  3,3},
  {&(_tg__ZTV8S20678C7__8S20678C1[4]),  4,5},
  {&(_tg__ZTV8S20678C58S20678C7__A1__8S20678C1[3]),  3,3},
  {&(_tg__ZTV8S20678C8__8S20678C7__8S20678C1[3]),  3,4},
  {&(_tg__ZTV9S20678C10__8S20678C1[7]),  7,10},
  {&(_tg__ZTV9S20678C119S20678C10__8S20678C1[7]),  7,9},
  {&(_tg__ZTV8S20678C4__9S20678C119S20678C10__8S20678C1[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C119S20678C10__8S20678C1[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C119S20678C10__8S20678C1[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C119S20678C10__8S20678C1[3]),  3,3},
  {&(_tg__ZTV8S20678C4__9S20678C10__8S20678C1[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C10__8S20678C1[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C10__8S20678C1[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C10__8S20678C1[3]),  3,3},
  {&(_tg__ZTV9S20678C12__8S20678C1[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C12__8S20678C1[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A2__8S20678C1[3]),  3,3},
  {&(_tg__ZTV9S20678C18__8S20678C1[12]),  12,13},
  {&(_tg__ZTV9S20678C11__9S20678C18__8S20678C1[9]),  9,11},
  {&(_tg__ZTV8S20678C4__9S20678C18__8S20678C1[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C18__8S20678C1[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C18__8S20678C1[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C18__8S20678C1[3]),  3,3},
  {&(_tg__ZTV9S20678C19__9S20678C18__8S20678C1[14]),  14,20},
  {&(_tg__ZTV9S20678C15__9S20678C18__8S20678C1[11]),  11,15},
  {&(_tg__ZTV8S20678C59S20678C15__A3__9S20678C18__8S20678C1[3]),  3,3},
  {&(_tg__ZTV8S20678C8__9S20678C18__8S20678C1[3]),  3,4},
  {&(_tg__ZTV9S20678C16__9S20678C18__8S20678C1[4]),  4,5},
  {&(_tg__ZTV9S20678C11__A1__8S20678C1[7]),  7,9},
  {&(_tg__ZTV8S20678C4__9S20678C11__A1__8S20678C1[6]),  6,9},
  {&(_tg__ZTV8S20678C2__9S20678C11__A1__8S20678C1[7]),  7,10},
  {&(_tg__ZTV9S20678C12__9S20678C11__A1__8S20678C1[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C11__A1__8S20678C1[3]),  3,3},
  {&(_tg__ZTV9S20678C19__8S20678C1[8]),  8,14},
  {&(_tg__ZTV9S20678C129S20678C19__A1__8S20678C1[4]),  4,6},
  {&(_tg__ZTV8S20678C5__9S20678C129S20678C19__A1__8S20678C1[3]),  3,3},
  {&(_tg__ZTV8S20678C5__9S20678C19__8S20678C1[3]),  3,3},
  {&(_tg__ZTV9S20678C15__9S20678C19__8S20678C1[11]),  11,15},
  {&(_tg__ZTV9S20678C12__A1__9S20678C19__8S20678C1[6]),  6,8},
  {&(_tg__ZTV8S20678C59S20678C15__A2__9S20678C19__8S20678C1[3]),  3,3},
  {&(_tg__ZTV8S20678C8__9S20678C19__8S20678C1[3]),  3,4},
  {&(_tg__ZTV9S20678C16__9S20678C19__8S20678C1[4]),  4,5},
  {&(_tg__ZTV9S20678C15__8S20678C1[7]),  7,11},
  {&(_tg__ZTV8S20678C49S20678C15__A1__8S20678C1[3]),  3,6},
  {&(_tg__ZTV8S20678C58S20678C49S20678C15__A3__8S20678C1[3]),  3,3},
  {&(_tg__ZTV8S20678C59S20678C15__A4__8S20678C1[3]),  3,3},
  {&(_tg__ZTV9S20678C12__9S20678C15__8S20678C1[6]),  6,8},
  {&(_tg__ZTV8S20678C5__A1__9S20678C15__8S20678C1[3]),  3,3},
  {&(_tg__ZTV8S20678C5__A__9S20678C15__8S20678C1[3]),  3,3},
  {&(_tg__ZTV8S20678C8__9S20678C15__8S20678C1[3]),  3,4},
  {&(_tg__ZTV9S20678C16__9S20678C15__8S20678C1[4]),  4,5},
  {&(_tg__ZTV9S20678C16__8S20678C1[3]),  3,4},
  {&(_tg__ZTV8S20678C59S20678C16__A5__8S20678C1[3]),  3,3},
};
extern VTBL_ENTRY _ZTI8S20678C1[];
extern  VTBL_ENTRY _ZTV8S20678C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20678C1[];
Class_Descriptor cd_S20678C1 = {  "S20678C1", // class name
  bases_S20678C1, 25,
  &(vtc_S20678C1[0]), // expected_vtbl_contents
  &(vtt_S20678C1[0]), // expected_vtt_contents
  ABISELECT(39136,27376), // object size
  NSPAIRA(_ZTI8S20678C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20678C1),139, //virtual function table var
  15, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20678C1),70, //virtual table table var
  20, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S210C6  {
  int s210c6f0;
  __tsi64 s210c6f1;
  void *s210c6f2[4];
  int s210c6f3[2];
  void *s210c6f4;
  ::S1503C5_nt s210c6f5;
  void *s210c6f6[2];
  virtual  ~S210C6(); // _ZN6S210C6D1Ev
  virtual void  v4(); // _ZN6S210C62v4Ev
  virtual void  v5(); // _ZN6S210C62v5Ev
  virtual void  v6(); // _ZN6S210C62v6Ev
  virtual void  v7(); // _ZN6S210C62v7Ev
  virtual void  v8(); // _ZN6S210C62v8Ev
  virtual void  v9(); // _ZN6S210C62v9Ev
  virtual void  v10(); // _ZN6S210C63v10Ev
  virtual void  v11(); // _ZN6S210C63v11Ev
  virtual void  v12(); // _ZN6S210C63v12Ev
  virtual void  v13(); // _ZN6S210C63v13Ev
  virtual void  v14(); // _ZN6S210C63v14Ev
  virtual void  v15(); // _ZN6S210C63v15Ev
  virtual void  v16(); // _ZN6S210C63v16Ev
  virtual void  v17(); // _ZN6S210C63v17Ev
  virtual void  v18(); // _ZN6S210C63v18Ev
  virtual void  v19(); // _ZN6S210C63v19Ev
  virtual void  v20(); // _ZN6S210C63v20Ev
  virtual void  v21(); // _ZN6S210C63v21Ev
  virtual void  v22(); // _ZN6S210C63v22Ev
  virtual void  v23(); // _ZN6S210C63v23Ev
  virtual void  v24(); // _ZN6S210C63v24Ev
  virtual void  v25(); // _ZN6S210C63v25Ev
  virtual void  v26(); // _ZN6S210C63v26Ev
  virtual void  v27(); // _ZN6S210C63v27Ev
  virtual void  v28(); // _ZN6S210C63v28Ev
  virtual void  v29(); // _ZN6S210C63v29Ev
  virtual void  v30(); // _ZN6S210C63v30Ev
  virtual void  v31(); // _ZN6S210C63v31Ev
  virtual void  v32(); // _ZN6S210C63v32Ev
  virtual void  v33(); // _ZN6S210C63v33Ev
  virtual void  v34(); // _ZN6S210C63v34Ev
  virtual void  v35(); // _ZN6S210C63v35Ev
  virtual void  v36(); // _ZN6S210C63v36Ev
  virtual void  v37(); // _ZN6S210C63v37Ev
  virtual void  v38(); // _ZN6S210C63v38Ev
  virtual void  v39(); // _ZN6S210C63v39Ev
  virtual void  v40(); // _ZN6S210C63v40Ev
  virtual void  v41(); // _ZN6S210C63v41Ev
  virtual void  v42(); // _ZN6S210C63v42Ev
  virtual void  v43(); // _ZN6S210C63v43Ev
  virtual void  v44(); // _ZN6S210C63v44Ev
  virtual void  v45(); // _ZN6S210C63v45Ev
  virtual void  v46(); // _ZN6S210C63v46Ev
  virtual void  v47(); // _ZN6S210C63v47Ev
  virtual void  v48(); // _ZN6S210C63v48Ev
  virtual void  v49(); // _ZN6S210C63v49Ev
  virtual void  v50(); // _ZN6S210C63v50Ev
  virtual void  v51(); // _ZN6S210C63v51Ev
  virtual void  v52(); // _ZN6S210C63v52Ev
  virtual void  v53(); // _ZN6S210C63v53Ev
  virtual void  v54(); // _ZN6S210C63v54Ev
  virtual void  v55(); // _ZN6S210C63v55Ev
  virtual void  v56(); // _ZN6S210C63v56Ev
  virtual void  v57(); // _ZN6S210C63v57Ev
  virtual void  v58(); // _ZN6S210C63v58Ev
  virtual void  v59(); // _ZN6S210C63v59Ev
  virtual void  v60(); // _ZN6S210C63v60Ev
  virtual void  v61(); // _ZN6S210C63v61Ev
  virtual void  v62(); // _ZN6S210C63v62Ev
  virtual void  v63(); // _ZN6S210C63v63Ev
  virtual void  v64(); // _ZN6S210C63v64Ev
  virtual void  v65(); // _ZN6S210C63v65Ev
  virtual void  v66(); // _ZN6S210C63v66Ev
  virtual void  v67(); // _ZN6S210C63v67Ev
  S210C6(); // tgen
};
//SIG(-1 S210C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S210C6 ::~S210C6(){ note_dtor("S210C6", this);}
void  S210C6 ::v4(){vfunc_called(this, "_ZN6S210C62v4Ev");}
void  S210C6 ::v5(){vfunc_called(this, "_ZN6S210C62v5Ev");}
void  S210C6 ::v6(){vfunc_called(this, "_ZN6S210C62v6Ev");}
void  S210C6 ::v7(){vfunc_called(this, "_ZN6S210C62v7Ev");}
void  S210C6 ::v8(){vfunc_called(this, "_ZN6S210C62v8Ev");}
void  S210C6 ::v9(){vfunc_called(this, "_ZN6S210C62v9Ev");}
void  S210C6 ::v10(){vfunc_called(this, "_ZN6S210C63v10Ev");}
void  S210C6 ::v11(){vfunc_called(this, "_ZN6S210C63v11Ev");}
void  S210C6 ::v12(){vfunc_called(this, "_ZN6S210C63v12Ev");}
void  S210C6 ::v13(){vfunc_called(this, "_ZN6S210C63v13Ev");}
void  S210C6 ::v14(){vfunc_called(this, "_ZN6S210C63v14Ev");}
void  S210C6 ::v15(){vfunc_called(this, "_ZN6S210C63v15Ev");}
void  S210C6 ::v16(){vfunc_called(this, "_ZN6S210C63v16Ev");}
void  S210C6 ::v17(){vfunc_called(this, "_ZN6S210C63v17Ev");}
void  S210C6 ::v18(){vfunc_called(this, "_ZN6S210C63v18Ev");}
void  S210C6 ::v19(){vfunc_called(this, "_ZN6S210C63v19Ev");}
void  S210C6 ::v20(){vfunc_called(this, "_ZN6S210C63v20Ev");}
void  S210C6 ::v21(){vfunc_called(this, "_ZN6S210C63v21Ev");}
void  S210C6 ::v22(){vfunc_called(this, "_ZN6S210C63v22Ev");}
void  S210C6 ::v23(){vfunc_called(this, "_ZN6S210C63v23Ev");}
void  S210C6 ::v24(){vfunc_called(this, "_ZN6S210C63v24Ev");}
void  S210C6 ::v25(){vfunc_called(this, "_ZN6S210C63v25Ev");}
void  S210C6 ::v26(){vfunc_called(this, "_ZN6S210C63v26Ev");}
void  S210C6 ::v27(){vfunc_called(this, "_ZN6S210C63v27Ev");}
void  S210C6 ::v28(){vfunc_called(this, "_ZN6S210C63v28Ev");}
void  S210C6 ::v29(){vfunc_called(this, "_ZN6S210C63v29Ev");}
void  S210C6 ::v30(){vfunc_called(this, "_ZN6S210C63v30Ev");}
void  S210C6 ::v31(){vfunc_called(this, "_ZN6S210C63v31Ev");}
void  S210C6 ::v32(){vfunc_called(this, "_ZN6S210C63v32Ev");}
void  S210C6 ::v33(){vfunc_called(this, "_ZN6S210C63v33Ev");}
void  S210C6 ::v34(){vfunc_called(this, "_ZN6S210C63v34Ev");}
void  S210C6 ::v35(){vfunc_called(this, "_ZN6S210C63v35Ev");}
void  S210C6 ::v36(){vfunc_called(this, "_ZN6S210C63v36Ev");}
void  S210C6 ::v37(){vfunc_called(this, "_ZN6S210C63v37Ev");}
void  S210C6 ::v38(){vfunc_called(this, "_ZN6S210C63v38Ev");}
void  S210C6 ::v39(){vfunc_called(this, "_ZN6S210C63v39Ev");}
void  S210C6 ::v40(){vfunc_called(this, "_ZN6S210C63v40Ev");}
void  S210C6 ::v41(){vfunc_called(this, "_ZN6S210C63v41Ev");}
void  S210C6 ::v42(){vfunc_called(this, "_ZN6S210C63v42Ev");}
void  S210C6 ::v43(){vfunc_called(this, "_ZN6S210C63v43Ev");}
void  S210C6 ::v44(){vfunc_called(this, "_ZN6S210C63v44Ev");}
void  S210C6 ::v45(){vfunc_called(this, "_ZN6S210C63v45Ev");}
void  S210C6 ::v46(){vfunc_called(this, "_ZN6S210C63v46Ev");}
void  S210C6 ::v47(){vfunc_called(this, "_ZN6S210C63v47Ev");}
void  S210C6 ::v48(){vfunc_called(this, "_ZN6S210C63v48Ev");}
void  S210C6 ::v49(){vfunc_called(this, "_ZN6S210C63v49Ev");}
void  S210C6 ::v50(){vfunc_called(this, "_ZN6S210C63v50Ev");}
void  S210C6 ::v51(){vfunc_called(this, "_ZN6S210C63v51Ev");}
void  S210C6 ::v52(){vfunc_called(this, "_ZN6S210C63v52Ev");}
void  S210C6 ::v53(){vfunc_called(this, "_ZN6S210C63v53Ev");}
void  S210C6 ::v54(){vfunc_called(this, "_ZN6S210C63v54Ev");}
void  S210C6 ::v55(){vfunc_called(this, "_ZN6S210C63v55Ev");}
void  S210C6 ::v56(){vfunc_called(this, "_ZN6S210C63v56Ev");}
void  S210C6 ::v57(){vfunc_called(this, "_ZN6S210C63v57Ev");}
void  S210C6 ::v58(){vfunc_called(this, "_ZN6S210C63v58Ev");}
void  S210C6 ::v59(){vfunc_called(this, "_ZN6S210C63v59Ev");}
void  S210C6 ::v60(){vfunc_called(this, "_ZN6S210C63v60Ev");}
void  S210C6 ::v61(){vfunc_called(this, "_ZN6S210C63v61Ev");}
void  S210C6 ::v62(){vfunc_called(this, "_ZN6S210C63v62Ev");}
void  S210C6 ::v63(){vfunc_called(this, "_ZN6S210C63v63Ev");}
void  S210C6 ::v64(){vfunc_called(this, "_ZN6S210C63v64Ev");}
void  S210C6 ::v65(){vfunc_called(this, "_ZN6S210C63v65Ev");}
void  S210C6 ::v66(){vfunc_called(this, "_ZN6S210C63v66Ev");}
void  S210C6 ::v67(){vfunc_called(this, "_ZN6S210C63v67Ev");}
S210C6 ::S210C6(){ note_ctor("S210C6", this);} // tgen

static void Test_S210C6()
{
  extern Class_Descriptor cd_S210C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S210C6, buf);
    S210C6 *dp, &lv = *(dp=new (buf) S210C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S210C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S210C6)");
    check_field_offset(lv, s210c6f0, ABISELECT(8,4), "S210C6.s210c6f0");
    check_field_offset(lv, s210c6f1, ABISELECT(16,8), "S210C6.s210c6f1");
    check_field_offset(lv, s210c6f2, ABISELECT(24,16), "S210C6.s210c6f2");
    check_field_offset(lv, s210c6f3, ABISELECT(56,32), "S210C6.s210c6f3");
    check_field_offset(lv, s210c6f4, ABISELECT(64,40), "S210C6.s210c6f4");
    check_field_offset(lv, s210c6f5, ABISELECT(72,44), "S210C6.s210c6f5");
    check_field_offset(lv, s210c6f6, ABISELECT(80,52), "S210C6.s210c6f6");
    test_class_info(&lv, &cd_S210C6);
    dp->~S210C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS210C6(Test_S210C6, "S210C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S210C6C1Ev();
extern void _ZN6S210C6D1Ev();
Name_Map name_map_S210C6[] = {
  NSPAIR(_ZN6S210C6C1Ev),
  NSPAIR(_ZN6S210C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S210C6[];
extern void _ZN6S210C6D1Ev();
extern void _ZN6S210C6D0Ev();
extern void _ZN6S210C62v4Ev();
extern void _ZN6S210C62v5Ev();
extern void _ZN6S210C62v6Ev();
extern void _ZN6S210C62v7Ev();
extern void _ZN6S210C62v8Ev();
extern void _ZN6S210C62v9Ev();
extern void _ZN6S210C63v10Ev();
extern void _ZN6S210C63v11Ev();
extern void _ZN6S210C63v12Ev();
extern void _ZN6S210C63v13Ev();
extern void _ZN6S210C63v14Ev();
extern void _ZN6S210C63v15Ev();
extern void _ZN6S210C63v16Ev();
extern void _ZN6S210C63v17Ev();
extern void _ZN6S210C63v18Ev();
extern void _ZN6S210C63v19Ev();
extern void _ZN6S210C63v20Ev();
extern void _ZN6S210C63v21Ev();
extern void _ZN6S210C63v22Ev();
extern void _ZN6S210C63v23Ev();
extern void _ZN6S210C63v24Ev();
extern void _ZN6S210C63v25Ev();
extern void _ZN6S210C63v26Ev();
extern void _ZN6S210C63v27Ev();
extern void _ZN6S210C63v28Ev();
extern void _ZN6S210C63v29Ev();
extern void _ZN6S210C63v30Ev();
extern void _ZN6S210C63v31Ev();
extern void _ZN6S210C63v32Ev();
extern void _ZN6S210C63v33Ev();
extern void _ZN6S210C63v34Ev();
extern void _ZN6S210C63v35Ev();
extern void _ZN6S210C63v36Ev();
extern void _ZN6S210C63v37Ev();
extern void _ZN6S210C63v38Ev();
extern void _ZN6S210C63v39Ev();
extern void _ZN6S210C63v40Ev();
extern void _ZN6S210C63v41Ev();
extern void _ZN6S210C63v42Ev();
extern void _ZN6S210C63v43Ev();
extern void _ZN6S210C63v44Ev();
extern void _ZN6S210C63v45Ev();
extern void _ZN6S210C63v46Ev();
extern void _ZN6S210C63v47Ev();
extern void _ZN6S210C63v48Ev();
extern void _ZN6S210C63v49Ev();
extern void _ZN6S210C63v50Ev();
extern void _ZN6S210C63v51Ev();
extern void _ZN6S210C63v52Ev();
extern void _ZN6S210C63v53Ev();
extern void _ZN6S210C63v54Ev();
extern void _ZN6S210C63v55Ev();
extern void _ZN6S210C63v56Ev();
extern void _ZN6S210C63v57Ev();
extern void _ZN6S210C63v58Ev();
extern void _ZN6S210C63v59Ev();
extern void _ZN6S210C63v60Ev();
extern void _ZN6S210C63v61Ev();
extern void _ZN6S210C63v62Ev();
extern void _ZN6S210C63v63Ev();
extern void _ZN6S210C63v64Ev();
extern void _ZN6S210C63v65Ev();
extern void _ZN6S210C63v66Ev();
extern void _ZN6S210C63v67Ev();
static  VTBL_ENTRY vtc_S210C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S210C6[0]),
  (VTBL_ENTRY)&_ZN6S210C6D1Ev,
  (VTBL_ENTRY)&_ZN6S210C6D0Ev,
  (VTBL_ENTRY)&_ZN6S210C62v4Ev,
  (VTBL_ENTRY)&_ZN6S210C62v5Ev,
  (VTBL_ENTRY)&_ZN6S210C62v6Ev,
  (VTBL_ENTRY)&_ZN6S210C62v7Ev,
  (VTBL_ENTRY)&_ZN6S210C62v8Ev,
  (VTBL_ENTRY)&_ZN6S210C62v9Ev,
  (VTBL_ENTRY)&_ZN6S210C63v10Ev,
  (VTBL_ENTRY)&_ZN6S210C63v11Ev,
  (VTBL_ENTRY)&_ZN6S210C63v12Ev,
  (VTBL_ENTRY)&_ZN6S210C63v13Ev,
  (VTBL_ENTRY)&_ZN6S210C63v14Ev,
  (VTBL_ENTRY)&_ZN6S210C63v15Ev,
  (VTBL_ENTRY)&_ZN6S210C63v16Ev,
  (VTBL_ENTRY)&_ZN6S210C63v17Ev,
  (VTBL_ENTRY)&_ZN6S210C63v18Ev,
  (VTBL_ENTRY)&_ZN6S210C63v19Ev,
  (VTBL_ENTRY)&_ZN6S210C63v20Ev,
  (VTBL_ENTRY)&_ZN6S210C63v21Ev,
  (VTBL_ENTRY)&_ZN6S210C63v22Ev,
  (VTBL_ENTRY)&_ZN6S210C63v23Ev,
  (VTBL_ENTRY)&_ZN6S210C63v24Ev,
  (VTBL_ENTRY)&_ZN6S210C63v25Ev,
  (VTBL_ENTRY)&_ZN6S210C63v26Ev,
  (VTBL_ENTRY)&_ZN6S210C63v27Ev,
  (VTBL_ENTRY)&_ZN6S210C63v28Ev,
  (VTBL_ENTRY)&_ZN6S210C63v29Ev,
  (VTBL_ENTRY)&_ZN6S210C63v30Ev,
  (VTBL_ENTRY)&_ZN6S210C63v31Ev,
  (VTBL_ENTRY)&_ZN6S210C63v32Ev,
  (VTBL_ENTRY)&_ZN6S210C63v33Ev,
  (VTBL_ENTRY)&_ZN6S210C63v34Ev,
  (VTBL_ENTRY)&_ZN6S210C63v35Ev,
  (VTBL_ENTRY)&_ZN6S210C63v36Ev,
  (VTBL_ENTRY)&_ZN6S210C63v37Ev,
  (VTBL_ENTRY)&_ZN6S210C63v38Ev,
  (VTBL_ENTRY)&_ZN6S210C63v39Ev,
  (VTBL_ENTRY)&_ZN6S210C63v40Ev,
  (VTBL_ENTRY)&_ZN6S210C63v41Ev,
  (VTBL_ENTRY)&_ZN6S210C63v42Ev,
  (VTBL_ENTRY)&_ZN6S210C63v43Ev,
  (VTBL_ENTRY)&_ZN6S210C63v44Ev,
  (VTBL_ENTRY)&_ZN6S210C63v45Ev,
  (VTBL_ENTRY)&_ZN6S210C63v46Ev,
  (VTBL_ENTRY)&_ZN6S210C63v47Ev,
  (VTBL_ENTRY)&_ZN6S210C63v48Ev,
  (VTBL_ENTRY)&_ZN6S210C63v49Ev,
  (VTBL_ENTRY)&_ZN6S210C63v50Ev,
  (VTBL_ENTRY)&_ZN6S210C63v51Ev,
  (VTBL_ENTRY)&_ZN6S210C63v52Ev,
  (VTBL_ENTRY)&_ZN6S210C63v53Ev,
  (VTBL_ENTRY)&_ZN6S210C63v54Ev,
  (VTBL_ENTRY)&_ZN6S210C63v55Ev,
  (VTBL_ENTRY)&_ZN6S210C63v56Ev,
  (VTBL_ENTRY)&_ZN6S210C63v57Ev,
  (VTBL_ENTRY)&_ZN6S210C63v58Ev,
  (VTBL_ENTRY)&_ZN6S210C63v59Ev,
  (VTBL_ENTRY)&_ZN6S210C63v60Ev,
  (VTBL_ENTRY)&_ZN6S210C63v61Ev,
  (VTBL_ENTRY)&_ZN6S210C63v62Ev,
  (VTBL_ENTRY)&_ZN6S210C63v63Ev,
  (VTBL_ENTRY)&_ZN6S210C63v64Ev,
  (VTBL_ENTRY)&_ZN6S210C63v65Ev,
  (VTBL_ENTRY)&_ZN6S210C63v66Ev,
  (VTBL_ENTRY)&_ZN6S210C63v67Ev,
};
extern VTBL_ENTRY _ZTI6S210C6[];
extern  VTBL_ENTRY _ZTV6S210C6[];
Class_Descriptor cd_S210C6 = {  "S210C6", // class name
  0,0,//no base classes
  &(vtc_S210C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S210C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S210C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S210C10  : S1503C8_nt {
};
//SIG(-1 S210C10) C1{ BC2{ m Fp Fi[2]}}



static void Test_S210C10()
{
  extern Class_Descriptor cd_S210C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S210C10, buf);
    S210C10 &lv = *(new (buf) S210C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S210C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S210C10)");
    check_base_class_offset(lv, (S1503C8_nt*), 0, "S210C10");
    test_class_info(&lv, &cd_S210C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS210C10(Test_S210C10, "S210C10", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
static Base_Class bases_S210C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S210C10 = {  "S210C10", // class name
  bases_S210C10, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S210C9  : S210C10 {
};
//SIG(-1 S210C9) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S210C9()
{
  extern Class_Descriptor cd_S210C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S210C9, buf);
    S210C9 &lv = *(new (buf) S210C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S210C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S210C9)");
    check_base_class_offset(lv, (S1503C8_nt*)(S210C10*), 0, "S210C9");
    check_base_class_offset(lv, (S210C10*), 0, "S210C9");
    test_class_info(&lv, &cd_S210C9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS210C9(Test_S210C9, "S210C9", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
extern Class_Descriptor cd_S210C10;
static Base_Class bases_S210C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S210C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S210C9 = {  "S210C9", // class name
  bases_S210C9, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S210C8_nt  : S210C9 {
};
//SIG(-1 S210C8_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S210C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S1503C8_nt;
extern Class_Descriptor cd_S210C10;
extern Class_Descriptor cd_S210C9;
static Base_Class bases_S210C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1503C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S210C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S210C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S210C5_nt  : S210C6 {
  int s210c5f0[2];
  void *s210c5f1;
  int s210c5f2[2];
  ::S210C8_nt s210c5f3;
  ::S210C8_nt s210c5f4;
  ::S629C14 s210c5f5;
  ::S210C8_nt s210c5f6;
  unsigned int s210c5f7:1;
  unsigned int s210c5f8:1;
  unsigned int s210c5f9:1;
  unsigned int s210c5f10:1;
  unsigned int s210c5f11:1;
  int s210c5f12[2];
  virtual  ~S210C5_nt(); // _ZN9S210C5_ntD1Ev
  virtual void  v68(); // _ZN9S210C5_nt3v68Ev
  virtual void  v69(); // _ZN9S210C5_nt3v69Ev
  virtual void  v70(); // _ZN9S210C5_nt3v70Ev
  virtual void  v71(); // _ZN9S210C5_nt3v71Ev
  virtual void  v72(); // _ZN9S210C5_nt3v72Ev
  virtual void  v73(); // _ZN9S210C5_nt3v73Ev
  virtual void  v74(); // _ZN9S210C5_nt3v74Ev
  virtual void  v75(); // _ZN9S210C5_nt3v75Ev
  virtual void  v76(); // _ZN9S210C5_nt3v76Ev
  virtual void  v77(); // _ZN9S210C5_nt3v77Ev
  virtual void  v78(); // _ZN9S210C5_nt3v78Ev
  virtual void  v79(); // _ZN9S210C5_nt3v79Ev
  virtual void  v80(); // _ZN9S210C5_nt3v80Ev
  virtual void  v81(); // _ZN9S210C5_nt3v81Ev
  virtual void  v82(); // _ZN9S210C5_nt3v82Ev
  virtual void  v83(); // _ZN9S210C5_nt3v83Ev
  virtual void  v84(); // _ZN9S210C5_nt3v84Ev
  virtual void  v85(); // _ZN9S210C5_nt3v85Ev
  virtual void  v86(); // _ZN9S210C5_nt3v86Ev
  virtual void  v87(); // _ZN9S210C5_nt3v87Ev
  virtual void  v88(); // _ZN9S210C5_nt3v88Ev
  virtual void  v89(); // _ZN9S210C5_nt3v89Ev
  S210C5_nt(); // tgen
};
//SIG(-1 S210C5_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S210C5_nt ::~S210C5_nt(){ note_dtor("S210C5_nt", this);}
void  S210C5_nt ::v68(){vfunc_called(this, "_ZN9S210C5_nt3v68Ev");}
void  S210C5_nt ::v69(){vfunc_called(this, "_ZN9S210C5_nt3v69Ev");}
void  S210C5_nt ::v70(){vfunc_called(this, "_ZN9S210C5_nt3v70Ev");}
void  S210C5_nt ::v71(){vfunc_called(this, "_ZN9S210C5_nt3v71Ev");}
void  S210C5_nt ::v72(){vfunc_called(this, "_ZN9S210C5_nt3v72Ev");}
void  S210C5_nt ::v73(){vfunc_called(this, "_ZN9S210C5_nt3v73Ev");}
void  S210C5_nt ::v74(){vfunc_called(this, "_ZN9S210C5_nt3v74Ev");}
void  S210C5_nt ::v75(){vfunc_called(this, "_ZN9S210C5_nt3v75Ev");}
void  S210C5_nt ::v76(){vfunc_called(this, "_ZN9S210C5_nt3v76Ev");}
void  S210C5_nt ::v77(){vfunc_called(this, "_ZN9S210C5_nt3v77Ev");}
void  S210C5_nt ::v78(){vfunc_called(this, "_ZN9S210C5_nt3v78Ev");}
void  S210C5_nt ::v79(){vfunc_called(this, "_ZN9S210C5_nt3v79Ev");}
void  S210C5_nt ::v80(){vfunc_called(this, "_ZN9S210C5_nt3v80Ev");}
void  S210C5_nt ::v81(){vfunc_called(this, "_ZN9S210C5_nt3v81Ev");}
void  S210C5_nt ::v82(){vfunc_called(this, "_ZN9S210C5_nt3v82Ev");}
void  S210C5_nt ::v83(){vfunc_called(this, "_ZN9S210C5_nt3v83Ev");}
void  S210C5_nt ::v84(){vfunc_called(this, "_ZN9S210C5_nt3v84Ev");}
void  S210C5_nt ::v85(){vfunc_called(this, "_ZN9S210C5_nt3v85Ev");}
void  S210C5_nt ::v86(){vfunc_called(this, "_ZN9S210C5_nt3v86Ev");}
void  S210C5_nt ::v87(){vfunc_called(this, "_ZN9S210C5_nt3v87Ev");}
void  S210C5_nt ::v88(){vfunc_called(this, "_ZN9S210C5_nt3v88Ev");}
void  S210C5_nt ::v89(){vfunc_called(this, "_ZN9S210C5_nt3v89Ev");}
S210C5_nt ::S210C5_nt(){ note_ctor("S210C5_nt", this);} // tgen

//skip512 S210C5_nt

#else // __cplusplus

extern void _ZN9S210C5_ntC1Ev();
extern void _ZN9S210C5_ntD1Ev();
Name_Map name_map_S210C5_nt[] = {
  NSPAIR(_ZN9S210C5_ntC1Ev),
  NSPAIR(_ZN9S210C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S210C6;
extern VTBL_ENTRY _ZTI6S210C6[];
extern  VTBL_ENTRY _ZTV6S210C6[];
static Base_Class bases_S210C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S210C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S210C5_nt[];
extern void _ZN9S210C5_ntD1Ev();
extern void _ZN9S210C5_ntD0Ev();
extern void _ZN6S210C62v4Ev();
extern void _ZN6S210C62v5Ev();
extern void _ZN6S210C62v6Ev();
extern void _ZN6S210C62v7Ev();
extern void _ZN6S210C62v8Ev();
extern void _ZN6S210C62v9Ev();
extern void _ZN6S210C63v10Ev();
extern void _ZN6S210C63v11Ev();
extern void _ZN6S210C63v12Ev();
extern void _ZN6S210C63v13Ev();
extern void _ZN6S210C63v14Ev();
extern void _ZN6S210C63v15Ev();
extern void _ZN6S210C63v16Ev();
extern void _ZN6S210C63v17Ev();
extern void _ZN6S210C63v18Ev();
extern void _ZN6S210C63v19Ev();
extern void _ZN6S210C63v20Ev();
extern void _ZN6S210C63v21Ev();
extern void _ZN6S210C63v22Ev();
extern void _ZN6S210C63v23Ev();
extern void _ZN6S210C63v24Ev();
extern void _ZN6S210C63v25Ev();
extern void _ZN6S210C63v26Ev();
extern void _ZN6S210C63v27Ev();
extern void _ZN6S210C63v28Ev();
extern void _ZN6S210C63v29Ev();
extern void _ZN6S210C63v30Ev();
extern void _ZN6S210C63v31Ev();
extern void _ZN6S210C63v32Ev();
extern void _ZN6S210C63v33Ev();
extern void _ZN6S210C63v34Ev();
extern void _ZN6S210C63v35Ev();
extern void _ZN6S210C63v36Ev();
extern void _ZN6S210C63v37Ev();
extern void _ZN6S210C63v38Ev();
extern void _ZN6S210C63v39Ev();
extern void _ZN6S210C63v40Ev();
extern void _ZN6S210C63v41Ev();
extern void _ZN6S210C63v42Ev();
extern void _ZN6S210C63v43Ev();
extern void _ZN6S210C63v44Ev();
extern void _ZN6S210C63v45Ev();
extern void _ZN6S210C63v46Ev();
extern void _ZN6S210C63v47Ev();
extern void _ZN6S210C63v48Ev();
extern void _ZN6S210C63v49Ev();
extern void _ZN6S210C63v50Ev();
extern void _ZN6S210C63v51Ev();
extern void _ZN6S210C63v52Ev();
extern void _ZN6S210C63v53Ev();
extern void _ZN6S210C63v54Ev();
extern void _ZN6S210C63v55Ev();
extern void _ZN6S210C63v56Ev();
extern void _ZN6S210C63v57Ev();
extern void _ZN6S210C63v58Ev();
extern void _ZN6S210C63v59Ev();
extern void _ZN6S210C63v60Ev();
extern void _ZN6S210C63v61Ev();
extern void _ZN6S210C63v62Ev();
extern void _ZN6S210C63v63Ev();
extern void _ZN6S210C63v64Ev();
extern void _ZN6S210C63v65Ev();
extern void _ZN6S210C63v66Ev();
extern void _ZN6S210C63v67Ev();
extern void _ZN9S210C5_nt3v68Ev();
extern void _ZN9S210C5_nt3v69Ev();
extern void _ZN9S210C5_nt3v70Ev();
extern void _ZN9S210C5_nt3v71Ev();
extern void _ZN9S210C5_nt3v72Ev();
extern void _ZN9S210C5_nt3v73Ev();
extern void _ZN9S210C5_nt3v74Ev();
extern void _ZN9S210C5_nt3v75Ev();
extern void _ZN9S210C5_nt3v76Ev();
extern void _ZN9S210C5_nt3v77Ev();
extern void _ZN9S210C5_nt3v78Ev();
extern void _ZN9S210C5_nt3v79Ev();
extern void _ZN9S210C5_nt3v80Ev();
extern void _ZN9S210C5_nt3v81Ev();
extern void _ZN9S210C5_nt3v82Ev();
extern void _ZN9S210C5_nt3v83Ev();
extern void _ZN9S210C5_nt3v84Ev();
extern void _ZN9S210C5_nt3v85Ev();
extern void _ZN9S210C5_nt3v86Ev();
extern void _ZN9S210C5_nt3v87Ev();
extern void _ZN9S210C5_nt3v88Ev();
extern void _ZN9S210C5_nt3v89Ev();
static  VTBL_ENTRY vtc_S210C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S210C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S210C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S210C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S210C62v4Ev,
  (VTBL_ENTRY)&_ZN6S210C62v5Ev,
  (VTBL_ENTRY)&_ZN6S210C62v6Ev,
  (VTBL_ENTRY)&_ZN6S210C62v7Ev,
  (VTBL_ENTRY)&_ZN6S210C62v8Ev,
  (VTBL_ENTRY)&_ZN6S210C62v9Ev,
  (VTBL_ENTRY)&_ZN6S210C63v10Ev,
  (VTBL_ENTRY)&_ZN6S210C63v11Ev,
  (VTBL_ENTRY)&_ZN6S210C63v12Ev,
  (VTBL_ENTRY)&_ZN6S210C63v13Ev,
  (VTBL_ENTRY)&_ZN6S210C63v14Ev,
  (VTBL_ENTRY)&_ZN6S210C63v15Ev,
  (VTBL_ENTRY)&_ZN6S210C63v16Ev,
  (VTBL_ENTRY)&_ZN6S210C63v17Ev,
  (VTBL_ENTRY)&_ZN6S210C63v18Ev,
  (VTBL_ENTRY)&_ZN6S210C63v19Ev,
  (VTBL_ENTRY)&_ZN6S210C63v20Ev,
  (VTBL_ENTRY)&_ZN6S210C63v21Ev,
  (VTBL_ENTRY)&_ZN6S210C63v22Ev,
  (VTBL_ENTRY)&_ZN6S210C63v23Ev,
  (VTBL_ENTRY)&_ZN6S210C63v24Ev,
  (VTBL_ENTRY)&_ZN6S210C63v25Ev,
  (VTBL_ENTRY)&_ZN6S210C63v26Ev,
  (VTBL_ENTRY)&_ZN6S210C63v27Ev,
  (VTBL_ENTRY)&_ZN6S210C63v28Ev,
  (VTBL_ENTRY)&_ZN6S210C63v29Ev,
  (VTBL_ENTRY)&_ZN6S210C63v30Ev,
  (VTBL_ENTRY)&_ZN6S210C63v31Ev,
  (VTBL_ENTRY)&_ZN6S210C63v32Ev,
  (VTBL_ENTRY)&_ZN6S210C63v33Ev,
  (VTBL_ENTRY)&_ZN6S210C63v34Ev,
  (VTBL_ENTRY)&_ZN6S210C63v35Ev,
  (VTBL_ENTRY)&_ZN6S210C63v36Ev,
  (VTBL_ENTRY)&_ZN6S210C63v37Ev,
  (VTBL_ENTRY)&_ZN6S210C63v38Ev,
  (VTBL_ENTRY)&_ZN6S210C63v39Ev,
  (VTBL_ENTRY)&_ZN6S210C63v40Ev,
  (VTBL_ENTRY)&_ZN6S210C63v41Ev,
  (VTBL_ENTRY)&_ZN6S210C63v42Ev,
  (VTBL_ENTRY)&_ZN6S210C63v43Ev,
  (VTBL_ENTRY)&_ZN6S210C63v44Ev,
  (VTBL_ENTRY)&_ZN6S210C63v45Ev,
  (VTBL_ENTRY)&_ZN6S210C63v46Ev,
  (VTBL_ENTRY)&_ZN6S210C63v47Ev,
  (VTBL_ENTRY)&_ZN6S210C63v48Ev,
  (VTBL_ENTRY)&_ZN6S210C63v49Ev,
  (VTBL_ENTRY)&_ZN6S210C63v50Ev,
  (VTBL_ENTRY)&_ZN6S210C63v51Ev,
  (VTBL_ENTRY)&_ZN6S210C63v52Ev,
  (VTBL_ENTRY)&_ZN6S210C63v53Ev,
  (VTBL_ENTRY)&_ZN6S210C63v54Ev,
  (VTBL_ENTRY)&_ZN6S210C63v55Ev,
  (VTBL_ENTRY)&_ZN6S210C63v56Ev,
  (VTBL_ENTRY)&_ZN6S210C63v57Ev,
  (VTBL_ENTRY)&_ZN6S210C63v58Ev,
  (VTBL_ENTRY)&_ZN6S210C63v59Ev,
  (VTBL_ENTRY)&_ZN6S210C63v60Ev,
  (VTBL_ENTRY)&_ZN6S210C63v61Ev,
  (VTBL_ENTRY)&_ZN6S210C63v62Ev,
  (VTBL_ENTRY)&_ZN6S210C63v63Ev,
  (VTBL_ENTRY)&_ZN6S210C63v64Ev,
  (VTBL_ENTRY)&_ZN6S210C63v65Ev,
  (VTBL_ENTRY)&_ZN6S210C63v66Ev,
  (VTBL_ENTRY)&_ZN6S210C63v67Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v89Ev,
};
extern VTBL_ENTRY _ZTI9S210C5_nt[];
VTBL_ENTRY *P__ZTI9S210C5_nt = _ZTI9S210C5_nt; 
extern  VTBL_ENTRY _ZTV9S210C5_nt[];
Class_Descriptor cd_S210C5_nt = {  "S210C5_nt", // class name
  bases_S210C5_nt, 1,
  &(vtc_S210C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S210C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S210C5_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S210C4_nt  : S210C5_nt {
  unsigned int s210c4f0:1;
  unsigned int s210c4f1:1;
  unsigned int s210c4f2:1;
  ::S1503C28 s210c4f3;
  ::S1503C24 s210c4f4;
  ::S1503C18 s210c4f5;
  ::S1503C12 s210c4f6;
  int s210c4f7[3];
  virtual  ~S210C4_nt(); // _ZN9S210C4_ntD1Ev
  virtual void  v90(); // _ZN9S210C4_nt3v90Ev
  virtual void  v91(); // _ZN9S210C4_nt3v91Ev
  virtual void  v92(); // _ZN9S210C4_nt3v92Ev
  virtual void  v93(); // _ZN9S210C4_nt3v93Ev
  virtual void  v94(); // _ZN9S210C4_nt3v94Ev
  virtual void  v95(); // _ZN9S210C4_nt3v95Ev
  virtual void  v96(); // _ZN9S210C4_nt3v96Ev
  virtual void  v97(); // _ZN9S210C4_nt3v97Ev
  virtual void  v98(); // _ZN9S210C4_nt3v98Ev
  virtual void  v99(); // _ZN9S210C4_nt3v99Ev
  virtual void  v100(); // _ZN9S210C4_nt4v100Ev
  virtual void  v101(); // _ZN9S210C4_nt4v101Ev
  virtual void  v102(); // _ZN9S210C4_nt4v102Ev
  virtual void  v103(); // _ZN9S210C4_nt4v103Ev
  virtual void  v104(); // _ZN9S210C4_nt4v104Ev
  virtual void  v105(); // _ZN9S210C4_nt4v105Ev
  virtual void  v106(); // _ZN9S210C4_nt4v106Ev
  virtual void  v107(); // _ZN9S210C4_nt4v107Ev
  virtual void  v108(); // _ZN9S210C4_nt4v108Ev
  virtual void  v109(); // _ZN9S210C4_nt4v109Ev
  S210C4_nt(); // tgen
};
//SIG(-1 S210C4_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S210C4_nt ::~S210C4_nt(){ note_dtor("S210C4_nt", this);}
void  S210C4_nt ::v90(){vfunc_called(this, "_ZN9S210C4_nt3v90Ev");}
void  S210C4_nt ::v91(){vfunc_called(this, "_ZN9S210C4_nt3v91Ev");}
void  S210C4_nt ::v92(){vfunc_called(this, "_ZN9S210C4_nt3v92Ev");}
void  S210C4_nt ::v93(){vfunc_called(this, "_ZN9S210C4_nt3v93Ev");}
void  S210C4_nt ::v94(){vfunc_called(this, "_ZN9S210C4_nt3v94Ev");}
void  S210C4_nt ::v95(){vfunc_called(this, "_ZN9S210C4_nt3v95Ev");}
void  S210C4_nt ::v96(){vfunc_called(this, "_ZN9S210C4_nt3v96Ev");}
void  S210C4_nt ::v97(){vfunc_called(this, "_ZN9S210C4_nt3v97Ev");}
void  S210C4_nt ::v98(){vfunc_called(this, "_ZN9S210C4_nt3v98Ev");}
void  S210C4_nt ::v99(){vfunc_called(this, "_ZN9S210C4_nt3v99Ev");}
void  S210C4_nt ::v100(){vfunc_called(this, "_ZN9S210C4_nt4v100Ev");}
void  S210C4_nt ::v101(){vfunc_called(this, "_ZN9S210C4_nt4v101Ev");}
void  S210C4_nt ::v102(){vfunc_called(this, "_ZN9S210C4_nt4v102Ev");}
void  S210C4_nt ::v103(){vfunc_called(this, "_ZN9S210C4_nt4v103Ev");}
void  S210C4_nt ::v104(){vfunc_called(this, "_ZN9S210C4_nt4v104Ev");}
void  S210C4_nt ::v105(){vfunc_called(this, "_ZN9S210C4_nt4v105Ev");}
void  S210C4_nt ::v106(){vfunc_called(this, "_ZN9S210C4_nt4v106Ev");}
void  S210C4_nt ::v107(){vfunc_called(this, "_ZN9S210C4_nt4v107Ev");}
void  S210C4_nt ::v108(){vfunc_called(this, "_ZN9S210C4_nt4v108Ev");}
void  S210C4_nt ::v109(){vfunc_called(this, "_ZN9S210C4_nt4v109Ev");}
S210C4_nt ::S210C4_nt(){ note_ctor("S210C4_nt", this);} // tgen

//skip512 S210C4_nt

#else // __cplusplus

extern void _ZN9S210C4_ntC1Ev();
extern void _ZN9S210C4_ntD1Ev();
Name_Map name_map_S210C4_nt[] = {
  NSPAIR(_ZN9S210C4_ntC1Ev),
  NSPAIR(_ZN9S210C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S210C6;
extern VTBL_ENTRY _ZTI6S210C6[];
extern  VTBL_ENTRY _ZTV6S210C6[];
extern Class_Descriptor cd_S210C5_nt;
extern VTBL_ENTRY _ZTI9S210C5_nt[];
extern  VTBL_ENTRY _ZTV9S210C5_nt[];
static Base_Class bases_S210C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S210C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S210C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S210C4_nt[];
extern void _ZN9S210C4_ntD1Ev();
extern void _ZN9S210C4_ntD0Ev();
extern void _ZN6S210C62v4Ev();
extern void _ZN6S210C62v5Ev();
extern void _ZN6S210C62v6Ev();
extern void _ZN6S210C62v7Ev();
extern void _ZN6S210C62v8Ev();
extern void _ZN6S210C62v9Ev();
extern void _ZN6S210C63v10Ev();
extern void _ZN6S210C63v11Ev();
extern void _ZN6S210C63v12Ev();
extern void _ZN6S210C63v13Ev();
extern void _ZN6S210C63v14Ev();
extern void _ZN6S210C63v15Ev();
extern void _ZN6S210C63v16Ev();
extern void _ZN6S210C63v17Ev();
extern void _ZN6S210C63v18Ev();
extern void _ZN6S210C63v19Ev();
extern void _ZN6S210C63v20Ev();
extern void _ZN6S210C63v21Ev();
extern void _ZN6S210C63v22Ev();
extern void _ZN6S210C63v23Ev();
extern void _ZN6S210C63v24Ev();
extern void _ZN6S210C63v25Ev();
extern void _ZN6S210C63v26Ev();
extern void _ZN6S210C63v27Ev();
extern void _ZN6S210C63v28Ev();
extern void _ZN6S210C63v29Ev();
extern void _ZN6S210C63v30Ev();
extern void _ZN6S210C63v31Ev();
extern void _ZN6S210C63v32Ev();
extern void _ZN6S210C63v33Ev();
extern void _ZN6S210C63v34Ev();
extern void _ZN6S210C63v35Ev();
extern void _ZN6S210C63v36Ev();
extern void _ZN6S210C63v37Ev();
extern void _ZN6S210C63v38Ev();
extern void _ZN6S210C63v39Ev();
extern void _ZN6S210C63v40Ev();
extern void _ZN6S210C63v41Ev();
extern void _ZN6S210C63v42Ev();
extern void _ZN6S210C63v43Ev();
extern void _ZN6S210C63v44Ev();
extern void _ZN6S210C63v45Ev();
extern void _ZN6S210C63v46Ev();
extern void _ZN6S210C63v47Ev();
extern void _ZN6S210C63v48Ev();
extern void _ZN6S210C63v49Ev();
extern void _ZN6S210C63v50Ev();
extern void _ZN6S210C63v51Ev();
extern void _ZN6S210C63v52Ev();
extern void _ZN6S210C63v53Ev();
extern void _ZN6S210C63v54Ev();
extern void _ZN6S210C63v55Ev();
extern void _ZN6S210C63v56Ev();
extern void _ZN6S210C63v57Ev();
extern void _ZN6S210C63v58Ev();
extern void _ZN6S210C63v59Ev();
extern void _ZN6S210C63v60Ev();
extern void _ZN6S210C63v61Ev();
extern void _ZN6S210C63v62Ev();
extern void _ZN6S210C63v63Ev();
extern void _ZN6S210C63v64Ev();
extern void _ZN6S210C63v65Ev();
extern void _ZN6S210C63v66Ev();
extern void _ZN6S210C63v67Ev();
extern void _ZN9S210C5_nt3v68Ev();
extern void _ZN9S210C5_nt3v69Ev();
extern void _ZN9S210C5_nt3v70Ev();
extern void _ZN9S210C5_nt3v71Ev();
extern void _ZN9S210C5_nt3v72Ev();
extern void _ZN9S210C5_nt3v73Ev();
extern void _ZN9S210C5_nt3v74Ev();
extern void _ZN9S210C5_nt3v75Ev();
extern void _ZN9S210C5_nt3v76Ev();
extern void _ZN9S210C5_nt3v77Ev();
extern void _ZN9S210C5_nt3v78Ev();
extern void _ZN9S210C5_nt3v79Ev();
extern void _ZN9S210C5_nt3v80Ev();
extern void _ZN9S210C5_nt3v81Ev();
extern void _ZN9S210C5_nt3v82Ev();
extern void _ZN9S210C5_nt3v83Ev();
extern void _ZN9S210C5_nt3v84Ev();
extern void _ZN9S210C5_nt3v85Ev();
extern void _ZN9S210C5_nt3v86Ev();
extern void _ZN9S210C5_nt3v87Ev();
extern void _ZN9S210C5_nt3v88Ev();
extern void _ZN9S210C5_nt3v89Ev();
extern void _ZN9S210C4_nt3v90Ev();
extern void _ZN9S210C4_nt3v91Ev();
extern void _ZN9S210C4_nt3v92Ev();
extern void _ZN9S210C4_nt3v93Ev();
extern void _ZN9S210C4_nt3v94Ev();
extern void _ZN9S210C4_nt3v95Ev();
extern void _ZN9S210C4_nt3v96Ev();
extern void _ZN9S210C4_nt3v97Ev();
extern void _ZN9S210C4_nt3v98Ev();
extern void _ZN9S210C4_nt3v99Ev();
extern void _ZN9S210C4_nt4v100Ev();
extern void _ZN9S210C4_nt4v101Ev();
extern void _ZN9S210C4_nt4v102Ev();
extern void _ZN9S210C4_nt4v103Ev();
extern void _ZN9S210C4_nt4v104Ev();
extern void _ZN9S210C4_nt4v105Ev();
extern void _ZN9S210C4_nt4v106Ev();
extern void _ZN9S210C4_nt4v107Ev();
extern void _ZN9S210C4_nt4v108Ev();
extern void _ZN9S210C4_nt4v109Ev();
static  VTBL_ENTRY vtc_S210C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S210C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S210C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S210C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S210C62v4Ev,
  (VTBL_ENTRY)&_ZN6S210C62v5Ev,
  (VTBL_ENTRY)&_ZN6S210C62v6Ev,
  (VTBL_ENTRY)&_ZN6S210C62v7Ev,
  (VTBL_ENTRY)&_ZN6S210C62v8Ev,
  (VTBL_ENTRY)&_ZN6S210C62v9Ev,
  (VTBL_ENTRY)&_ZN6S210C63v10Ev,
  (VTBL_ENTRY)&_ZN6S210C63v11Ev,
  (VTBL_ENTRY)&_ZN6S210C63v12Ev,
  (VTBL_ENTRY)&_ZN6S210C63v13Ev,
  (VTBL_ENTRY)&_ZN6S210C63v14Ev,
  (VTBL_ENTRY)&_ZN6S210C63v15Ev,
  (VTBL_ENTRY)&_ZN6S210C63v16Ev,
  (VTBL_ENTRY)&_ZN6S210C63v17Ev,
  (VTBL_ENTRY)&_ZN6S210C63v18Ev,
  (VTBL_ENTRY)&_ZN6S210C63v19Ev,
  (VTBL_ENTRY)&_ZN6S210C63v20Ev,
  (VTBL_ENTRY)&_ZN6S210C63v21Ev,
  (VTBL_ENTRY)&_ZN6S210C63v22Ev,
  (VTBL_ENTRY)&_ZN6S210C63v23Ev,
  (VTBL_ENTRY)&_ZN6S210C63v24Ev,
  (VTBL_ENTRY)&_ZN6S210C63v25Ev,
  (VTBL_ENTRY)&_ZN6S210C63v26Ev,
  (VTBL_ENTRY)&_ZN6S210C63v27Ev,
  (VTBL_ENTRY)&_ZN6S210C63v28Ev,
  (VTBL_ENTRY)&_ZN6S210C63v29Ev,
  (VTBL_ENTRY)&_ZN6S210C63v30Ev,
  (VTBL_ENTRY)&_ZN6S210C63v31Ev,
  (VTBL_ENTRY)&_ZN6S210C63v32Ev,
  (VTBL_ENTRY)&_ZN6S210C63v33Ev,
  (VTBL_ENTRY)&_ZN6S210C63v34Ev,
  (VTBL_ENTRY)&_ZN6S210C63v35Ev,
  (VTBL_ENTRY)&_ZN6S210C63v36Ev,
  (VTBL_ENTRY)&_ZN6S210C63v37Ev,
  (VTBL_ENTRY)&_ZN6S210C63v38Ev,
  (VTBL_ENTRY)&_ZN6S210C63v39Ev,
  (VTBL_ENTRY)&_ZN6S210C63v40Ev,
  (VTBL_ENTRY)&_ZN6S210C63v41Ev,
  (VTBL_ENTRY)&_ZN6S210C63v42Ev,
  (VTBL_ENTRY)&_ZN6S210C63v43Ev,
  (VTBL_ENTRY)&_ZN6S210C63v44Ev,
  (VTBL_ENTRY)&_ZN6S210C63v45Ev,
  (VTBL_ENTRY)&_ZN6S210C63v46Ev,
  (VTBL_ENTRY)&_ZN6S210C63v47Ev,
  (VTBL_ENTRY)&_ZN6S210C63v48Ev,
  (VTBL_ENTRY)&_ZN6S210C63v49Ev,
  (VTBL_ENTRY)&_ZN6S210C63v50Ev,
  (VTBL_ENTRY)&_ZN6S210C63v51Ev,
  (VTBL_ENTRY)&_ZN6S210C63v52Ev,
  (VTBL_ENTRY)&_ZN6S210C63v53Ev,
  (VTBL_ENTRY)&_ZN6S210C63v54Ev,
  (VTBL_ENTRY)&_ZN6S210C63v55Ev,
  (VTBL_ENTRY)&_ZN6S210C63v56Ev,
  (VTBL_ENTRY)&_ZN6S210C63v57Ev,
  (VTBL_ENTRY)&_ZN6S210C63v58Ev,
  (VTBL_ENTRY)&_ZN6S210C63v59Ev,
  (VTBL_ENTRY)&_ZN6S210C63v60Ev,
  (VTBL_ENTRY)&_ZN6S210C63v61Ev,
  (VTBL_ENTRY)&_ZN6S210C63v62Ev,
  (VTBL_ENTRY)&_ZN6S210C63v63Ev,
  (VTBL_ENTRY)&_ZN6S210C63v64Ev,
  (VTBL_ENTRY)&_ZN6S210C63v65Ev,
  (VTBL_ENTRY)&_ZN6S210C63v66Ev,
  (VTBL_ENTRY)&_ZN6S210C63v67Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v109Ev,
};
extern VTBL_ENTRY _ZTI9S210C4_nt[];
VTBL_ENTRY *P__ZTI9S210C4_nt = _ZTI9S210C4_nt; 
extern  VTBL_ENTRY _ZTV9S210C4_nt[];
Class_Descriptor cd_S210C4_nt = {  "S210C4_nt", // class name
  bases_S210C4_nt, 2,
  &(vtc_S210C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S210C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S210C4_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S210C3_nt  : S210C4_nt {
  ::S1503C5_nt s210c3f0;
  unsigned int s210c3f1:1;
  ::S1503C6_nt s210c3f2;
  virtual  ~S210C3_nt(); // _ZN9S210C3_ntD1Ev
  virtual void  v110(); // _ZN9S210C3_nt4v110Ev
  virtual void  v111(); // _ZN9S210C3_nt4v111Ev
  virtual void  v112(); // _ZN9S210C3_nt4v112Ev
  virtual void  v113(); // _ZN9S210C3_nt4v113Ev
  S210C3_nt(); // tgen
};
//SIG(-1 S210C3_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S210C3_nt ::~S210C3_nt(){ note_dtor("S210C3_nt", this);}
void  S210C3_nt ::v110(){vfunc_called(this, "_ZN9S210C3_nt4v110Ev");}
void  S210C3_nt ::v111(){vfunc_called(this, "_ZN9S210C3_nt4v111Ev");}
void  S210C3_nt ::v112(){vfunc_called(this, "_ZN9S210C3_nt4v112Ev");}
void  S210C3_nt ::v113(){vfunc_called(this, "_ZN9S210C3_nt4v113Ev");}
S210C3_nt ::S210C3_nt(){ note_ctor("S210C3_nt", this);} // tgen

//skip512 S210C3_nt

#else // __cplusplus

extern void _ZN9S210C3_ntC1Ev();
extern void _ZN9S210C3_ntD1Ev();
Name_Map name_map_S210C3_nt[] = {
  NSPAIR(_ZN9S210C3_ntC1Ev),
  NSPAIR(_ZN9S210C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S210C6;
extern VTBL_ENTRY _ZTI6S210C6[];
extern  VTBL_ENTRY _ZTV6S210C6[];
extern Class_Descriptor cd_S210C5_nt;
extern VTBL_ENTRY _ZTI9S210C5_nt[];
extern  VTBL_ENTRY _ZTV9S210C5_nt[];
extern Class_Descriptor cd_S210C4_nt;
extern VTBL_ENTRY _ZTI9S210C4_nt[];
extern  VTBL_ENTRY _ZTV9S210C4_nt[];
static Base_Class bases_S210C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S210C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S210C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S210C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S210C3_nt[];
extern void _ZN9S210C3_ntD1Ev();
extern void _ZN9S210C3_ntD0Ev();
extern void _ZN6S210C62v4Ev();
extern void _ZN6S210C62v5Ev();
extern void _ZN6S210C62v6Ev();
extern void _ZN6S210C62v7Ev();
extern void _ZN6S210C62v8Ev();
extern void _ZN6S210C62v9Ev();
extern void _ZN6S210C63v10Ev();
extern void _ZN6S210C63v11Ev();
extern void _ZN6S210C63v12Ev();
extern void _ZN6S210C63v13Ev();
extern void _ZN6S210C63v14Ev();
extern void _ZN6S210C63v15Ev();
extern void _ZN6S210C63v16Ev();
extern void _ZN6S210C63v17Ev();
extern void _ZN6S210C63v18Ev();
extern void _ZN6S210C63v19Ev();
extern void _ZN6S210C63v20Ev();
extern void _ZN6S210C63v21Ev();
extern void _ZN6S210C63v22Ev();
extern void _ZN6S210C63v23Ev();
extern void _ZN6S210C63v24Ev();
extern void _ZN6S210C63v25Ev();
extern void _ZN6S210C63v26Ev();
extern void _ZN6S210C63v27Ev();
extern void _ZN6S210C63v28Ev();
extern void _ZN6S210C63v29Ev();
extern void _ZN6S210C63v30Ev();
extern void _ZN6S210C63v31Ev();
extern void _ZN6S210C63v32Ev();
extern void _ZN6S210C63v33Ev();
extern void _ZN6S210C63v34Ev();
extern void _ZN6S210C63v35Ev();
extern void _ZN6S210C63v36Ev();
extern void _ZN6S210C63v37Ev();
extern void _ZN6S210C63v38Ev();
extern void _ZN6S210C63v39Ev();
extern void _ZN6S210C63v40Ev();
extern void _ZN6S210C63v41Ev();
extern void _ZN6S210C63v42Ev();
extern void _ZN6S210C63v43Ev();
extern void _ZN6S210C63v44Ev();
extern void _ZN6S210C63v45Ev();
extern void _ZN6S210C63v46Ev();
extern void _ZN6S210C63v47Ev();
extern void _ZN6S210C63v48Ev();
extern void _ZN6S210C63v49Ev();
extern void _ZN6S210C63v50Ev();
extern void _ZN6S210C63v51Ev();
extern void _ZN6S210C63v52Ev();
extern void _ZN6S210C63v53Ev();
extern void _ZN6S210C63v54Ev();
extern void _ZN6S210C63v55Ev();
extern void _ZN6S210C63v56Ev();
extern void _ZN6S210C63v57Ev();
extern void _ZN6S210C63v58Ev();
extern void _ZN6S210C63v59Ev();
extern void _ZN6S210C63v60Ev();
extern void _ZN6S210C63v61Ev();
extern void _ZN6S210C63v62Ev();
extern void _ZN6S210C63v63Ev();
extern void _ZN6S210C63v64Ev();
extern void _ZN6S210C63v65Ev();
extern void _ZN6S210C63v66Ev();
extern void _ZN6S210C63v67Ev();
extern void _ZN9S210C5_nt3v68Ev();
extern void _ZN9S210C5_nt3v69Ev();
extern void _ZN9S210C5_nt3v70Ev();
extern void _ZN9S210C5_nt3v71Ev();
extern void _ZN9S210C5_nt3v72Ev();
extern void _ZN9S210C5_nt3v73Ev();
extern void _ZN9S210C5_nt3v74Ev();
extern void _ZN9S210C5_nt3v75Ev();
extern void _ZN9S210C5_nt3v76Ev();
extern void _ZN9S210C5_nt3v77Ev();
extern void _ZN9S210C5_nt3v78Ev();
extern void _ZN9S210C5_nt3v79Ev();
extern void _ZN9S210C5_nt3v80Ev();
extern void _ZN9S210C5_nt3v81Ev();
extern void _ZN9S210C5_nt3v82Ev();
extern void _ZN9S210C5_nt3v83Ev();
extern void _ZN9S210C5_nt3v84Ev();
extern void _ZN9S210C5_nt3v85Ev();
extern void _ZN9S210C5_nt3v86Ev();
extern void _ZN9S210C5_nt3v87Ev();
extern void _ZN9S210C5_nt3v88Ev();
extern void _ZN9S210C5_nt3v89Ev();
extern void _ZN9S210C4_nt3v90Ev();
extern void _ZN9S210C4_nt3v91Ev();
extern void _ZN9S210C4_nt3v92Ev();
extern void _ZN9S210C4_nt3v93Ev();
extern void _ZN9S210C4_nt3v94Ev();
extern void _ZN9S210C4_nt3v95Ev();
extern void _ZN9S210C4_nt3v96Ev();
extern void _ZN9S210C4_nt3v97Ev();
extern void _ZN9S210C4_nt3v98Ev();
extern void _ZN9S210C4_nt3v99Ev();
extern void _ZN9S210C4_nt4v100Ev();
extern void _ZN9S210C4_nt4v101Ev();
extern void _ZN9S210C4_nt4v102Ev();
extern void _ZN9S210C4_nt4v103Ev();
extern void _ZN9S210C4_nt4v104Ev();
extern void _ZN9S210C4_nt4v105Ev();
extern void _ZN9S210C4_nt4v106Ev();
extern void _ZN9S210C4_nt4v107Ev();
extern void _ZN9S210C4_nt4v108Ev();
extern void _ZN9S210C4_nt4v109Ev();
extern void _ZN9S210C3_nt4v110Ev();
extern void _ZN9S210C3_nt4v111Ev();
extern void _ZN9S210C3_nt4v112Ev();
extern void _ZN9S210C3_nt4v113Ev();
static  VTBL_ENTRY vtc_S210C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S210C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S210C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S210C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S210C62v4Ev,
  (VTBL_ENTRY)&_ZN6S210C62v5Ev,
  (VTBL_ENTRY)&_ZN6S210C62v6Ev,
  (VTBL_ENTRY)&_ZN6S210C62v7Ev,
  (VTBL_ENTRY)&_ZN6S210C62v8Ev,
  (VTBL_ENTRY)&_ZN6S210C62v9Ev,
  (VTBL_ENTRY)&_ZN6S210C63v10Ev,
  (VTBL_ENTRY)&_ZN6S210C63v11Ev,
  (VTBL_ENTRY)&_ZN6S210C63v12Ev,
  (VTBL_ENTRY)&_ZN6S210C63v13Ev,
  (VTBL_ENTRY)&_ZN6S210C63v14Ev,
  (VTBL_ENTRY)&_ZN6S210C63v15Ev,
  (VTBL_ENTRY)&_ZN6S210C63v16Ev,
  (VTBL_ENTRY)&_ZN6S210C63v17Ev,
  (VTBL_ENTRY)&_ZN6S210C63v18Ev,
  (VTBL_ENTRY)&_ZN6S210C63v19Ev,
  (VTBL_ENTRY)&_ZN6S210C63v20Ev,
  (VTBL_ENTRY)&_ZN6S210C63v21Ev,
  (VTBL_ENTRY)&_ZN6S210C63v22Ev,
  (VTBL_ENTRY)&_ZN6S210C63v23Ev,
  (VTBL_ENTRY)&_ZN6S210C63v24Ev,
  (VTBL_ENTRY)&_ZN6S210C63v25Ev,
  (VTBL_ENTRY)&_ZN6S210C63v26Ev,
  (VTBL_ENTRY)&_ZN6S210C63v27Ev,
  (VTBL_ENTRY)&_ZN6S210C63v28Ev,
  (VTBL_ENTRY)&_ZN6S210C63v29Ev,
  (VTBL_ENTRY)&_ZN6S210C63v30Ev,
  (VTBL_ENTRY)&_ZN6S210C63v31Ev,
  (VTBL_ENTRY)&_ZN6S210C63v32Ev,
  (VTBL_ENTRY)&_ZN6S210C63v33Ev,
  (VTBL_ENTRY)&_ZN6S210C63v34Ev,
  (VTBL_ENTRY)&_ZN6S210C63v35Ev,
  (VTBL_ENTRY)&_ZN6S210C63v36Ev,
  (VTBL_ENTRY)&_ZN6S210C63v37Ev,
  (VTBL_ENTRY)&_ZN6S210C63v38Ev,
  (VTBL_ENTRY)&_ZN6S210C63v39Ev,
  (VTBL_ENTRY)&_ZN6S210C63v40Ev,
  (VTBL_ENTRY)&_ZN6S210C63v41Ev,
  (VTBL_ENTRY)&_ZN6S210C63v42Ev,
  (VTBL_ENTRY)&_ZN6S210C63v43Ev,
  (VTBL_ENTRY)&_ZN6S210C63v44Ev,
  (VTBL_ENTRY)&_ZN6S210C63v45Ev,
  (VTBL_ENTRY)&_ZN6S210C63v46Ev,
  (VTBL_ENTRY)&_ZN6S210C63v47Ev,
  (VTBL_ENTRY)&_ZN6S210C63v48Ev,
  (VTBL_ENTRY)&_ZN6S210C63v49Ev,
  (VTBL_ENTRY)&_ZN6S210C63v50Ev,
  (VTBL_ENTRY)&_ZN6S210C63v51Ev,
  (VTBL_ENTRY)&_ZN6S210C63v52Ev,
  (VTBL_ENTRY)&_ZN6S210C63v53Ev,
  (VTBL_ENTRY)&_ZN6S210C63v54Ev,
  (VTBL_ENTRY)&_ZN6S210C63v55Ev,
  (VTBL_ENTRY)&_ZN6S210C63v56Ev,
  (VTBL_ENTRY)&_ZN6S210C63v57Ev,
  (VTBL_ENTRY)&_ZN6S210C63v58Ev,
  (VTBL_ENTRY)&_ZN6S210C63v59Ev,
  (VTBL_ENTRY)&_ZN6S210C63v60Ev,
  (VTBL_ENTRY)&_ZN6S210C63v61Ev,
  (VTBL_ENTRY)&_ZN6S210C63v62Ev,
  (VTBL_ENTRY)&_ZN6S210C63v63Ev,
  (VTBL_ENTRY)&_ZN6S210C63v64Ev,
  (VTBL_ENTRY)&_ZN6S210C63v65Ev,
  (VTBL_ENTRY)&_ZN6S210C63v66Ev,
  (VTBL_ENTRY)&_ZN6S210C63v67Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI9S210C3_nt[];
VTBL_ENTRY *P__ZTI9S210C3_nt = _ZTI9S210C3_nt; 
extern  VTBL_ENTRY _ZTV9S210C3_nt[];
Class_Descriptor cd_S210C3_nt = {  "S210C3_nt", // class name
  bases_S210C3_nt, 3,
  &(vtc_S210C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S210C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S210C3_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S210C2  : S210C3_nt {
  virtual  ~S210C2(); // _ZN6S210C2D1Ev
  virtual void  v114(); // _ZN6S210C24v114Ev
  virtual void  v115(); // _ZN6S210C24v115Ev
  S210C2(); // tgen
};
//SIG(-1 S210C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v109 v110 v111 v112 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2}


 S210C2 ::~S210C2(){ note_dtor("S210C2", this);}
void  S210C2 ::v114(){vfunc_called(this, "_ZN6S210C24v114Ev");}
void  S210C2 ::v115(){vfunc_called(this, "_ZN6S210C24v115Ev");}
S210C2 ::S210C2(){ note_ctor("S210C2", this);} // tgen

static void Test_S210C2()
{
  extern Class_Descriptor cd_S210C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S210C2, buf);
    S210C2 *dp, &lv = *(dp=new (buf) S210C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S210C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S210C2)");
    check_base_class_offset(lv, (S210C6*)(S210C5_nt*)(S210C4_nt*)(S210C3_nt*), 0, "S210C2");
    check_base_class_offset(lv, (S210C5_nt*)(S210C4_nt*)(S210C3_nt*), 0, "S210C2");
    check_base_class_offset(lv, (S210C4_nt*)(S210C3_nt*), 0, "S210C2");
    check_base_class_offset(lv, (S210C3_nt*), 0, "S210C2");
    test_class_info(&lv, &cd_S210C2);
    dp->~S210C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS210C2(Test_S210C2, "S210C2", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S210C2C1Ev();
extern void _ZN6S210C2D1Ev();
Name_Map name_map_S210C2[] = {
  NSPAIR(_ZN6S210C2C1Ev),
  NSPAIR(_ZN6S210C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S210C6;
extern VTBL_ENTRY _ZTI6S210C6[];
extern  VTBL_ENTRY _ZTV6S210C6[];
extern Class_Descriptor cd_S210C5_nt;
extern VTBL_ENTRY _ZTI9S210C5_nt[];
extern  VTBL_ENTRY _ZTV9S210C5_nt[];
extern Class_Descriptor cd_S210C4_nt;
extern VTBL_ENTRY _ZTI9S210C4_nt[];
extern  VTBL_ENTRY _ZTV9S210C4_nt[];
extern Class_Descriptor cd_S210C3_nt;
extern VTBL_ENTRY _ZTI9S210C3_nt[];
extern  VTBL_ENTRY _ZTV9S210C3_nt[];
static Base_Class bases_S210C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S210C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S210C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S210C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S210C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S210C2[];
extern void _ZN6S210C2D1Ev();
extern void _ZN6S210C2D0Ev();
extern void _ZN6S210C62v4Ev();
extern void _ZN6S210C62v5Ev();
extern void _ZN6S210C62v6Ev();
extern void _ZN6S210C62v7Ev();
extern void _ZN6S210C62v8Ev();
extern void _ZN6S210C62v9Ev();
extern void _ZN6S210C63v10Ev();
extern void _ZN6S210C63v11Ev();
extern void _ZN6S210C63v12Ev();
extern void _ZN6S210C63v13Ev();
extern void _ZN6S210C63v14Ev();
extern void _ZN6S210C63v15Ev();
extern void _ZN6S210C63v16Ev();
extern void _ZN6S210C63v17Ev();
extern void _ZN6S210C63v18Ev();
extern void _ZN6S210C63v19Ev();
extern void _ZN6S210C63v20Ev();
extern void _ZN6S210C63v21Ev();
extern void _ZN6S210C63v22Ev();
extern void _ZN6S210C63v23Ev();
extern void _ZN6S210C63v24Ev();
extern void _ZN6S210C63v25Ev();
extern void _ZN6S210C63v26Ev();
extern void _ZN6S210C63v27Ev();
extern void _ZN6S210C63v28Ev();
extern void _ZN6S210C63v29Ev();
extern void _ZN6S210C63v30Ev();
extern void _ZN6S210C63v31Ev();
extern void _ZN6S210C63v32Ev();
extern void _ZN6S210C63v33Ev();
extern void _ZN6S210C63v34Ev();
extern void _ZN6S210C63v35Ev();
extern void _ZN6S210C63v36Ev();
extern void _ZN6S210C63v37Ev();
extern void _ZN6S210C63v38Ev();
extern void _ZN6S210C63v39Ev();
extern void _ZN6S210C63v40Ev();
extern void _ZN6S210C63v41Ev();
extern void _ZN6S210C63v42Ev();
extern void _ZN6S210C63v43Ev();
extern void _ZN6S210C63v44Ev();
extern void _ZN6S210C63v45Ev();
extern void _ZN6S210C63v46Ev();
extern void _ZN6S210C63v47Ev();
extern void _ZN6S210C63v48Ev();
extern void _ZN6S210C63v49Ev();
extern void _ZN6S210C63v50Ev();
extern void _ZN6S210C63v51Ev();
extern void _ZN6S210C63v52Ev();
extern void _ZN6S210C63v53Ev();
extern void _ZN6S210C63v54Ev();
extern void _ZN6S210C63v55Ev();
extern void _ZN6S210C63v56Ev();
extern void _ZN6S210C63v57Ev();
extern void _ZN6S210C63v58Ev();
extern void _ZN6S210C63v59Ev();
extern void _ZN6S210C63v60Ev();
extern void _ZN6S210C63v61Ev();
extern void _ZN6S210C63v62Ev();
extern void _ZN6S210C63v63Ev();
extern void _ZN6S210C63v64Ev();
extern void _ZN6S210C63v65Ev();
extern void _ZN6S210C63v66Ev();
extern void _ZN6S210C63v67Ev();
extern void _ZN9S210C5_nt3v68Ev();
extern void _ZN9S210C5_nt3v69Ev();
extern void _ZN9S210C5_nt3v70Ev();
extern void _ZN9S210C5_nt3v71Ev();
extern void _ZN9S210C5_nt3v72Ev();
extern void _ZN9S210C5_nt3v73Ev();
extern void _ZN9S210C5_nt3v74Ev();
extern void _ZN9S210C5_nt3v75Ev();
extern void _ZN9S210C5_nt3v76Ev();
extern void _ZN9S210C5_nt3v77Ev();
extern void _ZN9S210C5_nt3v78Ev();
extern void _ZN9S210C5_nt3v79Ev();
extern void _ZN9S210C5_nt3v80Ev();
extern void _ZN9S210C5_nt3v81Ev();
extern void _ZN9S210C5_nt3v82Ev();
extern void _ZN9S210C5_nt3v83Ev();
extern void _ZN9S210C5_nt3v84Ev();
extern void _ZN9S210C5_nt3v85Ev();
extern void _ZN9S210C5_nt3v86Ev();
extern void _ZN9S210C5_nt3v87Ev();
extern void _ZN9S210C5_nt3v88Ev();
extern void _ZN9S210C5_nt3v89Ev();
extern void _ZN9S210C4_nt3v90Ev();
extern void _ZN9S210C4_nt3v91Ev();
extern void _ZN9S210C4_nt3v92Ev();
extern void _ZN9S210C4_nt3v93Ev();
extern void _ZN9S210C4_nt3v94Ev();
extern void _ZN9S210C4_nt3v95Ev();
extern void _ZN9S210C4_nt3v96Ev();
extern void _ZN9S210C4_nt3v97Ev();
extern void _ZN9S210C4_nt3v98Ev();
extern void _ZN9S210C4_nt3v99Ev();
extern void _ZN9S210C4_nt4v100Ev();
extern void _ZN9S210C4_nt4v101Ev();
extern void _ZN9S210C4_nt4v102Ev();
extern void _ZN9S210C4_nt4v103Ev();
extern void _ZN9S210C4_nt4v104Ev();
extern void _ZN9S210C4_nt4v105Ev();
extern void _ZN9S210C4_nt4v106Ev();
extern void _ZN9S210C4_nt4v107Ev();
extern void _ZN9S210C4_nt4v108Ev();
extern void _ZN9S210C4_nt4v109Ev();
extern void _ZN9S210C3_nt4v110Ev();
extern void _ZN9S210C3_nt4v111Ev();
extern void _ZN9S210C3_nt4v112Ev();
extern void _ZN9S210C3_nt4v113Ev();
extern void _ZN6S210C24v114Ev();
extern void _ZN6S210C24v115Ev();
static  VTBL_ENTRY vtc_S210C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S210C2[0]),
  (VTBL_ENTRY)&_ZN6S210C2D1Ev,
  (VTBL_ENTRY)&_ZN6S210C2D0Ev,
  (VTBL_ENTRY)&_ZN6S210C62v4Ev,
  (VTBL_ENTRY)&_ZN6S210C62v5Ev,
  (VTBL_ENTRY)&_ZN6S210C62v6Ev,
  (VTBL_ENTRY)&_ZN6S210C62v7Ev,
  (VTBL_ENTRY)&_ZN6S210C62v8Ev,
  (VTBL_ENTRY)&_ZN6S210C62v9Ev,
  (VTBL_ENTRY)&_ZN6S210C63v10Ev,
  (VTBL_ENTRY)&_ZN6S210C63v11Ev,
  (VTBL_ENTRY)&_ZN6S210C63v12Ev,
  (VTBL_ENTRY)&_ZN6S210C63v13Ev,
  (VTBL_ENTRY)&_ZN6S210C63v14Ev,
  (VTBL_ENTRY)&_ZN6S210C63v15Ev,
  (VTBL_ENTRY)&_ZN6S210C63v16Ev,
  (VTBL_ENTRY)&_ZN6S210C63v17Ev,
  (VTBL_ENTRY)&_ZN6S210C63v18Ev,
  (VTBL_ENTRY)&_ZN6S210C63v19Ev,
  (VTBL_ENTRY)&_ZN6S210C63v20Ev,
  (VTBL_ENTRY)&_ZN6S210C63v21Ev,
  (VTBL_ENTRY)&_ZN6S210C63v22Ev,
  (VTBL_ENTRY)&_ZN6S210C63v23Ev,
  (VTBL_ENTRY)&_ZN6S210C63v24Ev,
  (VTBL_ENTRY)&_ZN6S210C63v25Ev,
  (VTBL_ENTRY)&_ZN6S210C63v26Ev,
  (VTBL_ENTRY)&_ZN6S210C63v27Ev,
  (VTBL_ENTRY)&_ZN6S210C63v28Ev,
  (VTBL_ENTRY)&_ZN6S210C63v29Ev,
  (VTBL_ENTRY)&_ZN6S210C63v30Ev,
  (VTBL_ENTRY)&_ZN6S210C63v31Ev,
  (VTBL_ENTRY)&_ZN6S210C63v32Ev,
  (VTBL_ENTRY)&_ZN6S210C63v33Ev,
  (VTBL_ENTRY)&_ZN6S210C63v34Ev,
  (VTBL_ENTRY)&_ZN6S210C63v35Ev,
  (VTBL_ENTRY)&_ZN6S210C63v36Ev,
  (VTBL_ENTRY)&_ZN6S210C63v37Ev,
  (VTBL_ENTRY)&_ZN6S210C63v38Ev,
  (VTBL_ENTRY)&_ZN6S210C63v39Ev,
  (VTBL_ENTRY)&_ZN6S210C63v40Ev,
  (VTBL_ENTRY)&_ZN6S210C63v41Ev,
  (VTBL_ENTRY)&_ZN6S210C63v42Ev,
  (VTBL_ENTRY)&_ZN6S210C63v43Ev,
  (VTBL_ENTRY)&_ZN6S210C63v44Ev,
  (VTBL_ENTRY)&_ZN6S210C63v45Ev,
  (VTBL_ENTRY)&_ZN6S210C63v46Ev,
  (VTBL_ENTRY)&_ZN6S210C63v47Ev,
  (VTBL_ENTRY)&_ZN6S210C63v48Ev,
  (VTBL_ENTRY)&_ZN6S210C63v49Ev,
  (VTBL_ENTRY)&_ZN6S210C63v50Ev,
  (VTBL_ENTRY)&_ZN6S210C63v51Ev,
  (VTBL_ENTRY)&_ZN6S210C63v52Ev,
  (VTBL_ENTRY)&_ZN6S210C63v53Ev,
  (VTBL_ENTRY)&_ZN6S210C63v54Ev,
  (VTBL_ENTRY)&_ZN6S210C63v55Ev,
  (VTBL_ENTRY)&_ZN6S210C63v56Ev,
  (VTBL_ENTRY)&_ZN6S210C63v57Ev,
  (VTBL_ENTRY)&_ZN6S210C63v58Ev,
  (VTBL_ENTRY)&_ZN6S210C63v59Ev,
  (VTBL_ENTRY)&_ZN6S210C63v60Ev,
  (VTBL_ENTRY)&_ZN6S210C63v61Ev,
  (VTBL_ENTRY)&_ZN6S210C63v62Ev,
  (VTBL_ENTRY)&_ZN6S210C63v63Ev,
  (VTBL_ENTRY)&_ZN6S210C63v64Ev,
  (VTBL_ENTRY)&_ZN6S210C63v65Ev,
  (VTBL_ENTRY)&_ZN6S210C63v66Ev,
  (VTBL_ENTRY)&_ZN6S210C63v67Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN6S210C24v114Ev,
  (VTBL_ENTRY)&_ZN6S210C24v115Ev,
};
extern VTBL_ENTRY _ZTI6S210C2[];
extern  VTBL_ENTRY _ZTV6S210C2[];
Class_Descriptor cd_S210C2 = {  "S210C2", // class name
  bases_S210C2, 4,
  &(vtc_S210C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S210C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S210C2),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S210C1  : S210C2 {
  unsigned int s210c1f0:1;
  int s210c1f1[2];
  virtual  ~S210C1(); // _ZN6S210C1D1Ev
  virtual void  v1(); // _ZN6S210C12v1Ev
  virtual void  v2(); // _ZN6S210C12v2Ev
  virtual void  v3(); // _ZN6S210C12v3Ev
  S210C1(); // tgen
};
//SIG(1 S210C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v110 v111 v112 v113 FC7 Fi:1 FC21{ BC22{ BC11}}} vd v114 v115} vd v1 v2 v3 Fi:1 Fi[2]}


 S210C1 ::~S210C1(){ note_dtor("S210C1", this);}
void  S210C1 ::v1(){vfunc_called(this, "_ZN6S210C12v1Ev");}
void  S210C1 ::v2(){vfunc_called(this, "_ZN6S210C12v2Ev");}
void  S210C1 ::v3(){vfunc_called(this, "_ZN6S210C12v3Ev");}
S210C1 ::S210C1(){ note_ctor("S210C1", this);} // tgen

static void Test_S210C1()
{
  extern Class_Descriptor cd_S210C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,59)];
    init_test(&cd_S210C1, buf);
    S210C1 *dp, &lv = *(dp=new (buf) S210C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,232), "sizeof(S210C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S210C1)");
    check_base_class_offset(lv, (S210C6*)(S210C5_nt*)(S210C4_nt*)(S210C3_nt*)(S210C2*), 0, "S210C1");
    check_base_class_offset(lv, (S210C5_nt*)(S210C4_nt*)(S210C3_nt*)(S210C2*), 0, "S210C1");
    check_base_class_offset(lv, (S210C4_nt*)(S210C3_nt*)(S210C2*), 0, "S210C1");
    check_base_class_offset(lv, (S210C3_nt*)(S210C2*), 0, "S210C1");
    check_base_class_offset(lv, (S210C2*), 0, "S210C1");
    set_bf_and_test(lv, s210c1f0, ABISELECT(296,220), 0, 1, 1, "S210C1");
    check_field_offset(lv, s210c1f1, ABISELECT(300,224), "S210C1.s210c1f1");
    test_class_info(&lv, &cd_S210C1);
    dp->~S210C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS210C1(Test_S210C1, "S210C1", ABISELECT(312,232));

#else // __cplusplus

extern void _ZN6S210C1C1Ev();
extern void _ZN6S210C1D1Ev();
Name_Map name_map_S210C1[] = {
  NSPAIR(_ZN6S210C1C1Ev),
  NSPAIR(_ZN6S210C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S210C6;
extern VTBL_ENTRY _ZTI6S210C6[];
extern  VTBL_ENTRY _ZTV6S210C6[];
extern Class_Descriptor cd_S210C5_nt;
extern VTBL_ENTRY _ZTI9S210C5_nt[];
extern  VTBL_ENTRY _ZTV9S210C5_nt[];
extern Class_Descriptor cd_S210C4_nt;
extern VTBL_ENTRY _ZTI9S210C4_nt[];
extern  VTBL_ENTRY _ZTV9S210C4_nt[];
extern Class_Descriptor cd_S210C3_nt;
extern VTBL_ENTRY _ZTI9S210C3_nt[];
extern  VTBL_ENTRY _ZTV9S210C3_nt[];
extern Class_Descriptor cd_S210C2;
extern VTBL_ENTRY _ZTI6S210C2[];
extern  VTBL_ENTRY _ZTV6S210C2[];
static Base_Class bases_S210C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S210C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S210C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S210C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S210C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S210C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S210C1[];
extern void _ZN6S210C1D1Ev();
extern void _ZN6S210C1D0Ev();
extern void _ZN6S210C62v4Ev();
extern void _ZN6S210C62v5Ev();
extern void _ZN6S210C62v6Ev();
extern void _ZN6S210C62v7Ev();
extern void _ZN6S210C62v8Ev();
extern void _ZN6S210C62v9Ev();
extern void _ZN6S210C63v10Ev();
extern void _ZN6S210C63v11Ev();
extern void _ZN6S210C63v12Ev();
extern void _ZN6S210C63v13Ev();
extern void _ZN6S210C63v14Ev();
extern void _ZN6S210C63v15Ev();
extern void _ZN6S210C63v16Ev();
extern void _ZN6S210C63v17Ev();
extern void _ZN6S210C63v18Ev();
extern void _ZN6S210C63v19Ev();
extern void _ZN6S210C63v20Ev();
extern void _ZN6S210C63v21Ev();
extern void _ZN6S210C63v22Ev();
extern void _ZN6S210C63v23Ev();
extern void _ZN6S210C63v24Ev();
extern void _ZN6S210C63v25Ev();
extern void _ZN6S210C63v26Ev();
extern void _ZN6S210C63v27Ev();
extern void _ZN6S210C63v28Ev();
extern void _ZN6S210C63v29Ev();
extern void _ZN6S210C63v30Ev();
extern void _ZN6S210C63v31Ev();
extern void _ZN6S210C63v32Ev();
extern void _ZN6S210C63v33Ev();
extern void _ZN6S210C63v34Ev();
extern void _ZN6S210C63v35Ev();
extern void _ZN6S210C63v36Ev();
extern void _ZN6S210C63v37Ev();
extern void _ZN6S210C63v38Ev();
extern void _ZN6S210C63v39Ev();
extern void _ZN6S210C63v40Ev();
extern void _ZN6S210C63v41Ev();
extern void _ZN6S210C63v42Ev();
extern void _ZN6S210C63v43Ev();
extern void _ZN6S210C63v44Ev();
extern void _ZN6S210C63v45Ev();
extern void _ZN6S210C63v46Ev();
extern void _ZN6S210C63v47Ev();
extern void _ZN6S210C63v48Ev();
extern void _ZN6S210C63v49Ev();
extern void _ZN6S210C63v50Ev();
extern void _ZN6S210C63v51Ev();
extern void _ZN6S210C63v52Ev();
extern void _ZN6S210C63v53Ev();
extern void _ZN6S210C63v54Ev();
extern void _ZN6S210C63v55Ev();
extern void _ZN6S210C63v56Ev();
extern void _ZN6S210C63v57Ev();
extern void _ZN6S210C63v58Ev();
extern void _ZN6S210C63v59Ev();
extern void _ZN6S210C63v60Ev();
extern void _ZN6S210C63v61Ev();
extern void _ZN6S210C63v62Ev();
extern void _ZN6S210C63v63Ev();
extern void _ZN6S210C63v64Ev();
extern void _ZN6S210C63v65Ev();
extern void _ZN6S210C63v66Ev();
extern void _ZN6S210C63v67Ev();
extern void _ZN9S210C5_nt3v68Ev();
extern void _ZN9S210C5_nt3v69Ev();
extern void _ZN9S210C5_nt3v70Ev();
extern void _ZN9S210C5_nt3v71Ev();
extern void _ZN9S210C5_nt3v72Ev();
extern void _ZN9S210C5_nt3v73Ev();
extern void _ZN9S210C5_nt3v74Ev();
extern void _ZN9S210C5_nt3v75Ev();
extern void _ZN9S210C5_nt3v76Ev();
extern void _ZN9S210C5_nt3v77Ev();
extern void _ZN9S210C5_nt3v78Ev();
extern void _ZN9S210C5_nt3v79Ev();
extern void _ZN9S210C5_nt3v80Ev();
extern void _ZN9S210C5_nt3v81Ev();
extern void _ZN9S210C5_nt3v82Ev();
extern void _ZN9S210C5_nt3v83Ev();
extern void _ZN9S210C5_nt3v84Ev();
extern void _ZN9S210C5_nt3v85Ev();
extern void _ZN9S210C5_nt3v86Ev();
extern void _ZN9S210C5_nt3v87Ev();
extern void _ZN9S210C5_nt3v88Ev();
extern void _ZN9S210C5_nt3v89Ev();
extern void _ZN9S210C4_nt3v90Ev();
extern void _ZN9S210C4_nt3v91Ev();
extern void _ZN9S210C4_nt3v92Ev();
extern void _ZN9S210C4_nt3v93Ev();
extern void _ZN9S210C4_nt3v94Ev();
extern void _ZN9S210C4_nt3v95Ev();
extern void _ZN9S210C4_nt3v96Ev();
extern void _ZN9S210C4_nt3v97Ev();
extern void _ZN9S210C4_nt3v98Ev();
extern void _ZN9S210C4_nt3v99Ev();
extern void _ZN9S210C4_nt4v100Ev();
extern void _ZN9S210C4_nt4v101Ev();
extern void _ZN9S210C4_nt4v102Ev();
extern void _ZN9S210C4_nt4v103Ev();
extern void _ZN9S210C4_nt4v104Ev();
extern void _ZN9S210C4_nt4v105Ev();
extern void _ZN9S210C4_nt4v106Ev();
extern void _ZN9S210C4_nt4v107Ev();
extern void _ZN9S210C4_nt4v108Ev();
extern void _ZN9S210C4_nt4v109Ev();
extern void _ZN9S210C3_nt4v110Ev();
extern void _ZN9S210C3_nt4v111Ev();
extern void _ZN9S210C3_nt4v112Ev();
extern void _ZN9S210C3_nt4v113Ev();
extern void _ZN6S210C24v114Ev();
extern void _ZN6S210C24v115Ev();
extern void _ZN6S210C12v1Ev();
extern void _ZN6S210C12v2Ev();
extern void _ZN6S210C12v3Ev();
static  VTBL_ENTRY vtc_S210C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S210C1[0]),
  (VTBL_ENTRY)&_ZN6S210C1D1Ev,
  (VTBL_ENTRY)&_ZN6S210C1D0Ev,
  (VTBL_ENTRY)&_ZN6S210C62v4Ev,
  (VTBL_ENTRY)&_ZN6S210C62v5Ev,
  (VTBL_ENTRY)&_ZN6S210C62v6Ev,
  (VTBL_ENTRY)&_ZN6S210C62v7Ev,
  (VTBL_ENTRY)&_ZN6S210C62v8Ev,
  (VTBL_ENTRY)&_ZN6S210C62v9Ev,
  (VTBL_ENTRY)&_ZN6S210C63v10Ev,
  (VTBL_ENTRY)&_ZN6S210C63v11Ev,
  (VTBL_ENTRY)&_ZN6S210C63v12Ev,
  (VTBL_ENTRY)&_ZN6S210C63v13Ev,
  (VTBL_ENTRY)&_ZN6S210C63v14Ev,
  (VTBL_ENTRY)&_ZN6S210C63v15Ev,
  (VTBL_ENTRY)&_ZN6S210C63v16Ev,
  (VTBL_ENTRY)&_ZN6S210C63v17Ev,
  (VTBL_ENTRY)&_ZN6S210C63v18Ev,
  (VTBL_ENTRY)&_ZN6S210C63v19Ev,
  (VTBL_ENTRY)&_ZN6S210C63v20Ev,
  (VTBL_ENTRY)&_ZN6S210C63v21Ev,
  (VTBL_ENTRY)&_ZN6S210C63v22Ev,
  (VTBL_ENTRY)&_ZN6S210C63v23Ev,
  (VTBL_ENTRY)&_ZN6S210C63v24Ev,
  (VTBL_ENTRY)&_ZN6S210C63v25Ev,
  (VTBL_ENTRY)&_ZN6S210C63v26Ev,
  (VTBL_ENTRY)&_ZN6S210C63v27Ev,
  (VTBL_ENTRY)&_ZN6S210C63v28Ev,
  (VTBL_ENTRY)&_ZN6S210C63v29Ev,
  (VTBL_ENTRY)&_ZN6S210C63v30Ev,
  (VTBL_ENTRY)&_ZN6S210C63v31Ev,
  (VTBL_ENTRY)&_ZN6S210C63v32Ev,
  (VTBL_ENTRY)&_ZN6S210C63v33Ev,
  (VTBL_ENTRY)&_ZN6S210C63v34Ev,
  (VTBL_ENTRY)&_ZN6S210C63v35Ev,
  (VTBL_ENTRY)&_ZN6S210C63v36Ev,
  (VTBL_ENTRY)&_ZN6S210C63v37Ev,
  (VTBL_ENTRY)&_ZN6S210C63v38Ev,
  (VTBL_ENTRY)&_ZN6S210C63v39Ev,
  (VTBL_ENTRY)&_ZN6S210C63v40Ev,
  (VTBL_ENTRY)&_ZN6S210C63v41Ev,
  (VTBL_ENTRY)&_ZN6S210C63v42Ev,
  (VTBL_ENTRY)&_ZN6S210C63v43Ev,
  (VTBL_ENTRY)&_ZN6S210C63v44Ev,
  (VTBL_ENTRY)&_ZN6S210C63v45Ev,
  (VTBL_ENTRY)&_ZN6S210C63v46Ev,
  (VTBL_ENTRY)&_ZN6S210C63v47Ev,
  (VTBL_ENTRY)&_ZN6S210C63v48Ev,
  (VTBL_ENTRY)&_ZN6S210C63v49Ev,
  (VTBL_ENTRY)&_ZN6S210C63v50Ev,
  (VTBL_ENTRY)&_ZN6S210C63v51Ev,
  (VTBL_ENTRY)&_ZN6S210C63v52Ev,
  (VTBL_ENTRY)&_ZN6S210C63v53Ev,
  (VTBL_ENTRY)&_ZN6S210C63v54Ev,
  (VTBL_ENTRY)&_ZN6S210C63v55Ev,
  (VTBL_ENTRY)&_ZN6S210C63v56Ev,
  (VTBL_ENTRY)&_ZN6S210C63v57Ev,
  (VTBL_ENTRY)&_ZN6S210C63v58Ev,
  (VTBL_ENTRY)&_ZN6S210C63v59Ev,
  (VTBL_ENTRY)&_ZN6S210C63v60Ev,
  (VTBL_ENTRY)&_ZN6S210C63v61Ev,
  (VTBL_ENTRY)&_ZN6S210C63v62Ev,
  (VTBL_ENTRY)&_ZN6S210C63v63Ev,
  (VTBL_ENTRY)&_ZN6S210C63v64Ev,
  (VTBL_ENTRY)&_ZN6S210C63v65Ev,
  (VTBL_ENTRY)&_ZN6S210C63v66Ev,
  (VTBL_ENTRY)&_ZN6S210C63v67Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S210C5_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S210C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S210C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN6S210C24v114Ev,
  (VTBL_ENTRY)&_ZN6S210C24v115Ev,
  (VTBL_ENTRY)&_ZN6S210C12v1Ev,
  (VTBL_ENTRY)&_ZN6S210C12v2Ev,
  (VTBL_ENTRY)&_ZN6S210C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S210C1[];
extern  VTBL_ENTRY _ZTV6S210C1[];
Class_Descriptor cd_S210C1 = {  "S210C1", // class name
  bases_S210C1, 5,
  &(vtc_S210C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,232), // object size
  NSPAIRA(_ZTI6S210C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S210C1),119, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S209C6  {
  int s209c6f0;
  __tsi64 s209c6f1;
  void *s209c6f2[4];
  int s209c6f3[2];
  void *s209c6f4;
  ::S1503C5_nt s209c6f5;
  void *s209c6f6[2];
  virtual  ~S209C6(); // _ZN6S209C6D1Ev
  virtual void  v4(); // _ZN6S209C62v4Ev
  virtual void  v5(); // _ZN6S209C62v5Ev
  virtual void  v6(); // _ZN6S209C62v6Ev
  virtual void  v7(); // _ZN6S209C62v7Ev
  virtual void  v8(); // _ZN6S209C62v8Ev
  virtual void  v9(); // _ZN6S209C62v9Ev
  virtual void  v10(); // _ZN6S209C63v10Ev
  virtual void  v11(); // _ZN6S209C63v11Ev
  virtual void  v12(); // _ZN6S209C63v12Ev
  virtual void  v13(); // _ZN6S209C63v13Ev
  virtual void  v14(); // _ZN6S209C63v14Ev
  virtual void  v15(); // _ZN6S209C63v15Ev
  virtual void  v16(); // _ZN6S209C63v16Ev
  virtual void  v17(); // _ZN6S209C63v17Ev
  virtual void  v18(); // _ZN6S209C63v18Ev
  virtual void  v19(); // _ZN6S209C63v19Ev
  virtual void  v20(); // _ZN6S209C63v20Ev
  virtual void  v21(); // _ZN6S209C63v21Ev
  virtual void  v22(); // _ZN6S209C63v22Ev
  virtual void  v23(); // _ZN6S209C63v23Ev
  virtual void  v24(); // _ZN6S209C63v24Ev
  virtual void  v25(); // _ZN6S209C63v25Ev
  virtual void  v26(); // _ZN6S209C63v26Ev
  virtual void  v27(); // _ZN6S209C63v27Ev
  virtual void  v28(); // _ZN6S209C63v28Ev
  virtual void  v29(); // _ZN6S209C63v29Ev
  virtual void  v30(); // _ZN6S209C63v30Ev
  virtual void  v31(); // _ZN6S209C63v31Ev
  virtual void  v32(); // _ZN6S209C63v32Ev
  virtual void  v33(); // _ZN6S209C63v33Ev
  virtual void  v34(); // _ZN6S209C63v34Ev
  virtual void  v35(); // _ZN6S209C63v35Ev
  virtual void  v36(); // _ZN6S209C63v36Ev
  virtual void  v37(); // _ZN6S209C63v37Ev
  virtual void  v38(); // _ZN6S209C63v38Ev
  virtual void  v39(); // _ZN6S209C63v39Ev
  virtual void  v40(); // _ZN6S209C63v40Ev
  virtual void  v41(); // _ZN6S209C63v41Ev
  virtual void  v42(); // _ZN6S209C63v42Ev
  virtual void  v43(); // _ZN6S209C63v43Ev
  virtual void  v44(); // _ZN6S209C63v44Ev
  virtual void  v45(); // _ZN6S209C63v45Ev
  virtual void  v46(); // _ZN6S209C63v46Ev
  virtual void  v47(); // _ZN6S209C63v47Ev
  virtual void  v48(); // _ZN6S209C63v48Ev
  virtual void  v49(); // _ZN6S209C63v49Ev
  virtual void  v50(); // _ZN6S209C63v50Ev
  virtual void  v51(); // _ZN6S209C63v51Ev
  virtual void  v52(); // _ZN6S209C63v52Ev
  virtual void  v53(); // _ZN6S209C63v53Ev
  virtual void  v54(); // _ZN6S209C63v54Ev
  virtual void  v55(); // _ZN6S209C63v55Ev
  virtual void  v56(); // _ZN6S209C63v56Ev
  virtual void  v57(); // _ZN6S209C63v57Ev
  virtual void  v58(); // _ZN6S209C63v58Ev
  virtual void  v59(); // _ZN6S209C63v59Ev
  virtual void  v60(); // _ZN6S209C63v60Ev
  virtual void  v61(); // _ZN6S209C63v61Ev
  virtual void  v62(); // _ZN6S209C63v62Ev
  virtual void  v63(); // _ZN6S209C63v63Ev
  virtual void  v64(); // _ZN6S209C63v64Ev
  virtual void  v65(); // _ZN6S209C63v65Ev
  virtual void  v66(); // _ZN6S209C63v66Ev
  virtual void  v67(); // _ZN6S209C63v67Ev
  S209C6(); // tgen
};
//SIG(-1 S209C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S209C6 ::~S209C6(){ note_dtor("S209C6", this);}
void  S209C6 ::v4(){vfunc_called(this, "_ZN6S209C62v4Ev");}
void  S209C6 ::v5(){vfunc_called(this, "_ZN6S209C62v5Ev");}
void  S209C6 ::v6(){vfunc_called(this, "_ZN6S209C62v6Ev");}
void  S209C6 ::v7(){vfunc_called(this, "_ZN6S209C62v7Ev");}
void  S209C6 ::v8(){vfunc_called(this, "_ZN6S209C62v8Ev");}
void  S209C6 ::v9(){vfunc_called(this, "_ZN6S209C62v9Ev");}
void  S209C6 ::v10(){vfunc_called(this, "_ZN6S209C63v10Ev");}
void  S209C6 ::v11(){vfunc_called(this, "_ZN6S209C63v11Ev");}
void  S209C6 ::v12(){vfunc_called(this, "_ZN6S209C63v12Ev");}
void  S209C6 ::v13(){vfunc_called(this, "_ZN6S209C63v13Ev");}
void  S209C6 ::v14(){vfunc_called(this, "_ZN6S209C63v14Ev");}
void  S209C6 ::v15(){vfunc_called(this, "_ZN6S209C63v15Ev");}
void  S209C6 ::v16(){vfunc_called(this, "_ZN6S209C63v16Ev");}
void  S209C6 ::v17(){vfunc_called(this, "_ZN6S209C63v17Ev");}
void  S209C6 ::v18(){vfunc_called(this, "_ZN6S209C63v18Ev");}
void  S209C6 ::v19(){vfunc_called(this, "_ZN6S209C63v19Ev");}
void  S209C6 ::v20(){vfunc_called(this, "_ZN6S209C63v20Ev");}
void  S209C6 ::v21(){vfunc_called(this, "_ZN6S209C63v21Ev");}
void  S209C6 ::v22(){vfunc_called(this, "_ZN6S209C63v22Ev");}
void  S209C6 ::v23(){vfunc_called(this, "_ZN6S209C63v23Ev");}
void  S209C6 ::v24(){vfunc_called(this, "_ZN6S209C63v24Ev");}
void  S209C6 ::v25(){vfunc_called(this, "_ZN6S209C63v25Ev");}
void  S209C6 ::v26(){vfunc_called(this, "_ZN6S209C63v26Ev");}
void  S209C6 ::v27(){vfunc_called(this, "_ZN6S209C63v27Ev");}
void  S209C6 ::v28(){vfunc_called(this, "_ZN6S209C63v28Ev");}
void  S209C6 ::v29(){vfunc_called(this, "_ZN6S209C63v29Ev");}
void  S209C6 ::v30(){vfunc_called(this, "_ZN6S209C63v30Ev");}
void  S209C6 ::v31(){vfunc_called(this, "_ZN6S209C63v31Ev");}
void  S209C6 ::v32(){vfunc_called(this, "_ZN6S209C63v32Ev");}
void  S209C6 ::v33(){vfunc_called(this, "_ZN6S209C63v33Ev");}
void  S209C6 ::v34(){vfunc_called(this, "_ZN6S209C63v34Ev");}
void  S209C6 ::v35(){vfunc_called(this, "_ZN6S209C63v35Ev");}
void  S209C6 ::v36(){vfunc_called(this, "_ZN6S209C63v36Ev");}
void  S209C6 ::v37(){vfunc_called(this, "_ZN6S209C63v37Ev");}
void  S209C6 ::v38(){vfunc_called(this, "_ZN6S209C63v38Ev");}
void  S209C6 ::v39(){vfunc_called(this, "_ZN6S209C63v39Ev");}
void  S209C6 ::v40(){vfunc_called(this, "_ZN6S209C63v40Ev");}
void  S209C6 ::v41(){vfunc_called(this, "_ZN6S209C63v41Ev");}
void  S209C6 ::v42(){vfunc_called(this, "_ZN6S209C63v42Ev");}
void  S209C6 ::v43(){vfunc_called(this, "_ZN6S209C63v43Ev");}
void  S209C6 ::v44(){vfunc_called(this, "_ZN6S209C63v44Ev");}
void  S209C6 ::v45(){vfunc_called(this, "_ZN6S209C63v45Ev");}
void  S209C6 ::v46(){vfunc_called(this, "_ZN6S209C63v46Ev");}
void  S209C6 ::v47(){vfunc_called(this, "_ZN6S209C63v47Ev");}
void  S209C6 ::v48(){vfunc_called(this, "_ZN6S209C63v48Ev");}
void  S209C6 ::v49(){vfunc_called(this, "_ZN6S209C63v49Ev");}
void  S209C6 ::v50(){vfunc_called(this, "_ZN6S209C63v50Ev");}
void  S209C6 ::v51(){vfunc_called(this, "_ZN6S209C63v51Ev");}
void  S209C6 ::v52(){vfunc_called(this, "_ZN6S209C63v52Ev");}
void  S209C6 ::v53(){vfunc_called(this, "_ZN6S209C63v53Ev");}
void  S209C6 ::v54(){vfunc_called(this, "_ZN6S209C63v54Ev");}
void  S209C6 ::v55(){vfunc_called(this, "_ZN6S209C63v55Ev");}
void  S209C6 ::v56(){vfunc_called(this, "_ZN6S209C63v56Ev");}
void  S209C6 ::v57(){vfunc_called(this, "_ZN6S209C63v57Ev");}
void  S209C6 ::v58(){vfunc_called(this, "_ZN6S209C63v58Ev");}
void  S209C6 ::v59(){vfunc_called(this, "_ZN6S209C63v59Ev");}
void  S209C6 ::v60(){vfunc_called(this, "_ZN6S209C63v60Ev");}
void  S209C6 ::v61(){vfunc_called(this, "_ZN6S209C63v61Ev");}
void  S209C6 ::v62(){vfunc_called(this, "_ZN6S209C63v62Ev");}
void  S209C6 ::v63(){vfunc_called(this, "_ZN6S209C63v63Ev");}
void  S209C6 ::v64(){vfunc_called(this, "_ZN6S209C63v64Ev");}
void  S209C6 ::v65(){vfunc_called(this, "_ZN6S209C63v65Ev");}
void  S209C6 ::v66(){vfunc_called(this, "_ZN6S209C63v66Ev");}
void  S209C6 ::v67(){vfunc_called(this, "_ZN6S209C63v67Ev");}
S209C6 ::S209C6(){ note_ctor("S209C6", this);} // tgen

static void Test_S209C6()
{
  extern Class_Descriptor cd_S209C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S209C6, buf);
    S209C6 *dp, &lv = *(dp=new (buf) S209C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S209C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S209C6)");
    check_field_offset(lv, s209c6f0, ABISELECT(8,4), "S209C6.s209c6f0");
    check_field_offset(lv, s209c6f1, ABISELECT(16,8), "S209C6.s209c6f1");
    check_field_offset(lv, s209c6f2, ABISELECT(24,16), "S209C6.s209c6f2");
    check_field_offset(lv, s209c6f3, ABISELECT(56,32), "S209C6.s209c6f3");
    check_field_offset(lv, s209c6f4, ABISELECT(64,40), "S209C6.s209c6f4");
    check_field_offset(lv, s209c6f5, ABISELECT(72,44), "S209C6.s209c6f5");
    check_field_offset(lv, s209c6f6, ABISELECT(80,52), "S209C6.s209c6f6");
    test_class_info(&lv, &cd_S209C6);
    dp->~S209C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS209C6(Test_S209C6, "S209C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S209C6C1Ev();
extern void _ZN6S209C6D1Ev();
Name_Map name_map_S209C6[] = {
  NSPAIR(_ZN6S209C6C1Ev),
  NSPAIR(_ZN6S209C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S209C6[];
extern void _ZN6S209C6D1Ev();
extern void _ZN6S209C6D0Ev();
extern void _ZN6S209C62v4Ev();
extern void _ZN6S209C62v5Ev();
extern void _ZN6S209C62v6Ev();
extern void _ZN6S209C62v7Ev();
extern void _ZN6S209C62v8Ev();
extern void _ZN6S209C62v9Ev();
extern void _ZN6S209C63v10Ev();
extern void _ZN6S209C63v11Ev();
extern void _ZN6S209C63v12Ev();
extern void _ZN6S209C63v13Ev();
extern void _ZN6S209C63v14Ev();
extern void _ZN6S209C63v15Ev();
extern void _ZN6S209C63v16Ev();
extern void _ZN6S209C63v17Ev();
extern void _ZN6S209C63v18Ev();
extern void _ZN6S209C63v19Ev();
extern void _ZN6S209C63v20Ev();
extern void _ZN6S209C63v21Ev();
extern void _ZN6S209C63v22Ev();
extern void _ZN6S209C63v23Ev();
extern void _ZN6S209C63v24Ev();
extern void _ZN6S209C63v25Ev();
extern void _ZN6S209C63v26Ev();
extern void _ZN6S209C63v27Ev();
extern void _ZN6S209C63v28Ev();
extern void _ZN6S209C63v29Ev();
extern void _ZN6S209C63v30Ev();
extern void _ZN6S209C63v31Ev();
extern void _ZN6S209C63v32Ev();
extern void _ZN6S209C63v33Ev();
extern void _ZN6S209C63v34Ev();
extern void _ZN6S209C63v35Ev();
extern void _ZN6S209C63v36Ev();
extern void _ZN6S209C63v37Ev();
extern void _ZN6S209C63v38Ev();
extern void _ZN6S209C63v39Ev();
extern void _ZN6S209C63v40Ev();
extern void _ZN6S209C63v41Ev();
extern void _ZN6S209C63v42Ev();
extern void _ZN6S209C63v43Ev();
extern void _ZN6S209C63v44Ev();
extern void _ZN6S209C63v45Ev();
extern void _ZN6S209C63v46Ev();
extern void _ZN6S209C63v47Ev();
extern void _ZN6S209C63v48Ev();
extern void _ZN6S209C63v49Ev();
extern void _ZN6S209C63v50Ev();
extern void _ZN6S209C63v51Ev();
extern void _ZN6S209C63v52Ev();
extern void _ZN6S209C63v53Ev();
extern void _ZN6S209C63v54Ev();
extern void _ZN6S209C63v55Ev();
extern void _ZN6S209C63v56Ev();
extern void _ZN6S209C63v57Ev();
extern void _ZN6S209C63v58Ev();
extern void _ZN6S209C63v59Ev();
extern void _ZN6S209C63v60Ev();
extern void _ZN6S209C63v61Ev();
extern void _ZN6S209C63v62Ev();
extern void _ZN6S209C63v63Ev();
extern void _ZN6S209C63v64Ev();
extern void _ZN6S209C63v65Ev();
extern void _ZN6S209C63v66Ev();
extern void _ZN6S209C63v67Ev();
static  VTBL_ENTRY vtc_S209C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S209C6[0]),
  (VTBL_ENTRY)&_ZN6S209C6D1Ev,
  (VTBL_ENTRY)&_ZN6S209C6D0Ev,
  (VTBL_ENTRY)&_ZN6S209C62v4Ev,
  (VTBL_ENTRY)&_ZN6S209C62v5Ev,
  (VTBL_ENTRY)&_ZN6S209C62v6Ev,
  (VTBL_ENTRY)&_ZN6S209C62v7Ev,
  (VTBL_ENTRY)&_ZN6S209C62v8Ev,
  (VTBL_ENTRY)&_ZN6S209C62v9Ev,
  (VTBL_ENTRY)&_ZN6S209C63v10Ev,
  (VTBL_ENTRY)&_ZN6S209C63v11Ev,
  (VTBL_ENTRY)&_ZN6S209C63v12Ev,
  (VTBL_ENTRY)&_ZN6S209C63v13Ev,
  (VTBL_ENTRY)&_ZN6S209C63v14Ev,
  (VTBL_ENTRY)&_ZN6S209C63v15Ev,
  (VTBL_ENTRY)&_ZN6S209C63v16Ev,
  (VTBL_ENTRY)&_ZN6S209C63v17Ev,
  (VTBL_ENTRY)&_ZN6S209C63v18Ev,
  (VTBL_ENTRY)&_ZN6S209C63v19Ev,
  (VTBL_ENTRY)&_ZN6S209C63v20Ev,
  (VTBL_ENTRY)&_ZN6S209C63v21Ev,
  (VTBL_ENTRY)&_ZN6S209C63v22Ev,
  (VTBL_ENTRY)&_ZN6S209C63v23Ev,
  (VTBL_ENTRY)&_ZN6S209C63v24Ev,
  (VTBL_ENTRY)&_ZN6S209C63v25Ev,
  (VTBL_ENTRY)&_ZN6S209C63v26Ev,
  (VTBL_ENTRY)&_ZN6S209C63v27Ev,
  (VTBL_ENTRY)&_ZN6S209C63v28Ev,
  (VTBL_ENTRY)&_ZN6S209C63v29Ev,
  (VTBL_ENTRY)&_ZN6S209C63v30Ev,
  (VTBL_ENTRY)&_ZN6S209C63v31Ev,
  (VTBL_ENTRY)&_ZN6S209C63v32Ev,
  (VTBL_ENTRY)&_ZN6S209C63v33Ev,
  (VTBL_ENTRY)&_ZN6S209C63v34Ev,
  (VTBL_ENTRY)&_ZN6S209C63v35Ev,
  (VTBL_ENTRY)&_ZN6S209C63v36Ev,
  (VTBL_ENTRY)&_ZN6S209C63v37Ev,
  (VTBL_ENTRY)&_ZN6S209C63v38Ev,
  (VTBL_ENTRY)&_ZN6S209C63v39Ev,
  (VTBL_ENTRY)&_ZN6S209C63v40Ev,
  (VTBL_ENTRY)&_ZN6S209C63v41Ev,
  (VTBL_ENTRY)&_ZN6S209C63v42Ev,
  (VTBL_ENTRY)&_ZN6S209C63v43Ev,
  (VTBL_ENTRY)&_ZN6S209C63v44Ev,
  (VTBL_ENTRY)&_ZN6S209C63v45Ev,
  (VTBL_ENTRY)&_ZN6S209C63v46Ev,
  (VTBL_ENTRY)&_ZN6S209C63v47Ev,
  (VTBL_ENTRY)&_ZN6S209C63v48Ev,
  (VTBL_ENTRY)&_ZN6S209C63v49Ev,
  (VTBL_ENTRY)&_ZN6S209C63v50Ev,
  (VTBL_ENTRY)&_ZN6S209C63v51Ev,
  (VTBL_ENTRY)&_ZN6S209C63v52Ev,
  (VTBL_ENTRY)&_ZN6S209C63v53Ev,
  (VTBL_ENTRY)&_ZN6S209C63v54Ev,
  (VTBL_ENTRY)&_ZN6S209C63v55Ev,
  (VTBL_ENTRY)&_ZN6S209C63v56Ev,
  (VTBL_ENTRY)&_ZN6S209C63v57Ev,
  (VTBL_ENTRY)&_ZN6S209C63v58Ev,
  (VTBL_ENTRY)&_ZN6S209C63v59Ev,
  (VTBL_ENTRY)&_ZN6S209C63v60Ev,
  (VTBL_ENTRY)&_ZN6S209C63v61Ev,
  (VTBL_ENTRY)&_ZN6S209C63v62Ev,
  (VTBL_ENTRY)&_ZN6S209C63v63Ev,
  (VTBL_ENTRY)&_ZN6S209C63v64Ev,
  (VTBL_ENTRY)&_ZN6S209C63v65Ev,
  (VTBL_ENTRY)&_ZN6S209C63v66Ev,
  (VTBL_ENTRY)&_ZN6S209C63v67Ev,
};
extern VTBL_ENTRY _ZTI6S209C6[];
extern  VTBL_ENTRY _ZTV6S209C6[];
Class_Descriptor cd_S209C6 = {  "S209C6", // class name
  0,0,//no base classes
  &(vtc_S209C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S209C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S209C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S209C5  : S209C6 {
  int s209c5f0[2];
  void *s209c5f1;
  int s209c5f2[2];
  ::S210C8_nt s209c5f3;
  ::S210C8_nt s209c5f4;
  ::S629C14 s209c5f5;
  ::S210C8_nt s209c5f6;
  unsigned int s209c5f7:1;
  unsigned int s209c5f8:1;
  unsigned int s209c5f9:1;
  unsigned int s209c5f10:1;
  unsigned int s209c5f11:1;
  int s209c5f12[2];
  virtual  ~S209C5(); // _ZN6S209C5D1Ev
  virtual void  v68(); // _ZN6S209C53v68Ev
  virtual void  v69(); // _ZN6S209C53v69Ev
  virtual void  v70(); // _ZN6S209C53v70Ev
  virtual void  v71(); // _ZN6S209C53v71Ev
  virtual void  v72(); // _ZN6S209C53v72Ev
  virtual void  v73(); // _ZN6S209C53v73Ev
  virtual void  v74(); // _ZN6S209C53v74Ev
  virtual void  v75(); // _ZN6S209C53v75Ev
  virtual void  v76(); // _ZN6S209C53v76Ev
  virtual void  v77(); // _ZN6S209C53v77Ev
  virtual void  v78(); // _ZN6S209C53v78Ev
  virtual void  v79(); // _ZN6S209C53v79Ev
  virtual void  v80(); // _ZN6S209C53v80Ev
  virtual void  v81(); // _ZN6S209C53v81Ev
  virtual void  v82(); // _ZN6S209C53v82Ev
  virtual void  v83(); // _ZN6S209C53v83Ev
  virtual void  v84(); // _ZN6S209C53v84Ev
  virtual void  v85(); // _ZN6S209C53v85Ev
  virtual void  v86(); // _ZN6S209C53v86Ev
  virtual void  v87(); // _ZN6S209C53v87Ev
  virtual void  v88(); // _ZN6S209C53v88Ev
  virtual void  v89(); // _ZN6S209C53v89Ev
  S209C5(); // tgen
};
//SIG(-1 S209C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S209C5 ::~S209C5(){ note_dtor("S209C5", this);}
void  S209C5 ::v68(){vfunc_called(this, "_ZN6S209C53v68Ev");}
void  S209C5 ::v69(){vfunc_called(this, "_ZN6S209C53v69Ev");}
void  S209C5 ::v70(){vfunc_called(this, "_ZN6S209C53v70Ev");}
void  S209C5 ::v71(){vfunc_called(this, "_ZN6S209C53v71Ev");}
void  S209C5 ::v72(){vfunc_called(this, "_ZN6S209C53v72Ev");}
void  S209C5 ::v73(){vfunc_called(this, "_ZN6S209C53v73Ev");}
void  S209C5 ::v74(){vfunc_called(this, "_ZN6S209C53v74Ev");}
void  S209C5 ::v75(){vfunc_called(this, "_ZN6S209C53v75Ev");}
void  S209C5 ::v76(){vfunc_called(this, "_ZN6S209C53v76Ev");}
void  S209C5 ::v77(){vfunc_called(this, "_ZN6S209C53v77Ev");}
void  S209C5 ::v78(){vfunc_called(this, "_ZN6S209C53v78Ev");}
void  S209C5 ::v79(){vfunc_called(this, "_ZN6S209C53v79Ev");}
void  S209C5 ::v80(){vfunc_called(this, "_ZN6S209C53v80Ev");}
void  S209C5 ::v81(){vfunc_called(this, "_ZN6S209C53v81Ev");}
void  S209C5 ::v82(){vfunc_called(this, "_ZN6S209C53v82Ev");}
void  S209C5 ::v83(){vfunc_called(this, "_ZN6S209C53v83Ev");}
void  S209C5 ::v84(){vfunc_called(this, "_ZN6S209C53v84Ev");}
void  S209C5 ::v85(){vfunc_called(this, "_ZN6S209C53v85Ev");}
void  S209C5 ::v86(){vfunc_called(this, "_ZN6S209C53v86Ev");}
void  S209C5 ::v87(){vfunc_called(this, "_ZN6S209C53v87Ev");}
void  S209C5 ::v88(){vfunc_called(this, "_ZN6S209C53v88Ev");}
void  S209C5 ::v89(){vfunc_called(this, "_ZN6S209C53v89Ev");}
S209C5 ::S209C5(){ note_ctor("S209C5", this);} // tgen

static void Test_S209C5()
{
  extern Class_Descriptor cd_S209C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S209C5, buf);
    S209C5 *dp, &lv = *(dp=new (buf) S209C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S209C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S209C5)");
    check_base_class_offset(lv, (S209C6*), 0, "S209C5");
    check_field_offset(lv, s209c5f0, ABISELECT(96,60), "S209C5.s209c5f0");
    check_field_offset(lv, s209c5f1, ABISELECT(104,68), "S209C5.s209c5f1");
    check_field_offset(lv, s209c5f2, ABISELECT(112,72), "S209C5.s209c5f2");
    check_field_offset(lv, s209c5f3, ABISELECT(120,80), "S209C5.s209c5f3");
    check_field_offset(lv, s209c5f4, ABISELECT(136,92), "S209C5.s209c5f4");
    check_field_offset(lv, s209c5f5, ABISELECT(152,104), "S209C5.s209c5f5");
    check_field_offset(lv, s209c5f6, ABISELECT(160,108), "S209C5.s209c5f6");
    set_bf_and_test(lv, s209c5f7, ABISELECT(176,120), 0, 1, 1, "S209C5");
    set_bf_and_test(lv, s209c5f8, ABISELECT(176,120), 1, 1, 1, "S209C5");
    set_bf_and_test(lv, s209c5f9, ABISELECT(176,120), 2, 1, 1, "S209C5");
    set_bf_and_test(lv, s209c5f10, ABISELECT(176,120), 3, 1, 1, "S209C5");
    set_bf_and_test(lv, s209c5f11, ABISELECT(176,120), 4, 1, 1, "S209C5");
    check_field_offset(lv, s209c5f12, ABISELECT(180,124), "S209C5.s209c5f12");
    test_class_info(&lv, &cd_S209C5);
    dp->~S209C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS209C5(Test_S209C5, "S209C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S209C5C1Ev();
extern void _ZN6S209C5D1Ev();
Name_Map name_map_S209C5[] = {
  NSPAIR(_ZN6S209C5C1Ev),
  NSPAIR(_ZN6S209C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S209C6;
extern VTBL_ENTRY _ZTI6S209C6[];
extern  VTBL_ENTRY _ZTV6S209C6[];
static Base_Class bases_S209C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S209C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S209C5[];
extern void _ZN6S209C5D1Ev();
extern void _ZN6S209C5D0Ev();
extern void _ZN6S209C62v4Ev();
extern void _ZN6S209C62v5Ev();
extern void _ZN6S209C62v6Ev();
extern void _ZN6S209C62v7Ev();
extern void _ZN6S209C62v8Ev();
extern void _ZN6S209C62v9Ev();
extern void _ZN6S209C63v10Ev();
extern void _ZN6S209C63v11Ev();
extern void _ZN6S209C63v12Ev();
extern void _ZN6S209C63v13Ev();
extern void _ZN6S209C63v14Ev();
extern void _ZN6S209C63v15Ev();
extern void _ZN6S209C63v16Ev();
extern void _ZN6S209C63v17Ev();
extern void _ZN6S209C63v18Ev();
extern void _ZN6S209C63v19Ev();
extern void _ZN6S209C63v20Ev();
extern void _ZN6S209C63v21Ev();
extern void _ZN6S209C63v22Ev();
extern void _ZN6S209C63v23Ev();
extern void _ZN6S209C63v24Ev();
extern void _ZN6S209C63v25Ev();
extern void _ZN6S209C63v26Ev();
extern void _ZN6S209C63v27Ev();
extern void _ZN6S209C63v28Ev();
extern void _ZN6S209C63v29Ev();
extern void _ZN6S209C63v30Ev();
extern void _ZN6S209C63v31Ev();
extern void _ZN6S209C63v32Ev();
extern void _ZN6S209C63v33Ev();
extern void _ZN6S209C63v34Ev();
extern void _ZN6S209C63v35Ev();
extern void _ZN6S209C63v36Ev();
extern void _ZN6S209C63v37Ev();
extern void _ZN6S209C63v38Ev();
extern void _ZN6S209C63v39Ev();
extern void _ZN6S209C63v40Ev();
extern void _ZN6S209C63v41Ev();
extern void _ZN6S209C63v42Ev();
extern void _ZN6S209C63v43Ev();
extern void _ZN6S209C63v44Ev();
extern void _ZN6S209C63v45Ev();
extern void _ZN6S209C63v46Ev();
extern void _ZN6S209C63v47Ev();
extern void _ZN6S209C63v48Ev();
extern void _ZN6S209C63v49Ev();
extern void _ZN6S209C63v50Ev();
extern void _ZN6S209C63v51Ev();
extern void _ZN6S209C63v52Ev();
extern void _ZN6S209C63v53Ev();
extern void _ZN6S209C63v54Ev();
extern void _ZN6S209C63v55Ev();
extern void _ZN6S209C63v56Ev();
extern void _ZN6S209C63v57Ev();
extern void _ZN6S209C63v58Ev();
extern void _ZN6S209C63v59Ev();
extern void _ZN6S209C63v60Ev();
extern void _ZN6S209C63v61Ev();
extern void _ZN6S209C63v62Ev();
extern void _ZN6S209C63v63Ev();
extern void _ZN6S209C63v64Ev();
extern void _ZN6S209C63v65Ev();
extern void _ZN6S209C63v66Ev();
extern void _ZN6S209C63v67Ev();
extern void _ZN6S209C53v68Ev();
extern void _ZN6S209C53v69Ev();
extern void _ZN6S209C53v70Ev();
extern void _ZN6S209C53v71Ev();
extern void _ZN6S209C53v72Ev();
extern void _ZN6S209C53v73Ev();
extern void _ZN6S209C53v74Ev();
extern void _ZN6S209C53v75Ev();
extern void _ZN6S209C53v76Ev();
extern void _ZN6S209C53v77Ev();
extern void _ZN6S209C53v78Ev();
extern void _ZN6S209C53v79Ev();
extern void _ZN6S209C53v80Ev();
extern void _ZN6S209C53v81Ev();
extern void _ZN6S209C53v82Ev();
extern void _ZN6S209C53v83Ev();
extern void _ZN6S209C53v84Ev();
extern void _ZN6S209C53v85Ev();
extern void _ZN6S209C53v86Ev();
extern void _ZN6S209C53v87Ev();
extern void _ZN6S209C53v88Ev();
extern void _ZN6S209C53v89Ev();
static  VTBL_ENTRY vtc_S209C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S209C5[0]),
  (VTBL_ENTRY)&_ZN6S209C5D1Ev,
  (VTBL_ENTRY)&_ZN6S209C5D0Ev,
  (VTBL_ENTRY)&_ZN6S209C62v4Ev,
  (VTBL_ENTRY)&_ZN6S209C62v5Ev,
  (VTBL_ENTRY)&_ZN6S209C62v6Ev,
  (VTBL_ENTRY)&_ZN6S209C62v7Ev,
  (VTBL_ENTRY)&_ZN6S209C62v8Ev,
  (VTBL_ENTRY)&_ZN6S209C62v9Ev,
  (VTBL_ENTRY)&_ZN6S209C63v10Ev,
  (VTBL_ENTRY)&_ZN6S209C63v11Ev,
  (VTBL_ENTRY)&_ZN6S209C63v12Ev,
  (VTBL_ENTRY)&_ZN6S209C63v13Ev,
  (VTBL_ENTRY)&_ZN6S209C63v14Ev,
  (VTBL_ENTRY)&_ZN6S209C63v15Ev,
  (VTBL_ENTRY)&_ZN6S209C63v16Ev,
  (VTBL_ENTRY)&_ZN6S209C63v17Ev,
  (VTBL_ENTRY)&_ZN6S209C63v18Ev,
  (VTBL_ENTRY)&_ZN6S209C63v19Ev,
  (VTBL_ENTRY)&_ZN6S209C63v20Ev,
  (VTBL_ENTRY)&_ZN6S209C63v21Ev,
  (VTBL_ENTRY)&_ZN6S209C63v22Ev,
  (VTBL_ENTRY)&_ZN6S209C63v23Ev,
  (VTBL_ENTRY)&_ZN6S209C63v24Ev,
  (VTBL_ENTRY)&_ZN6S209C63v25Ev,
  (VTBL_ENTRY)&_ZN6S209C63v26Ev,
  (VTBL_ENTRY)&_ZN6S209C63v27Ev,
  (VTBL_ENTRY)&_ZN6S209C63v28Ev,
  (VTBL_ENTRY)&_ZN6S209C63v29Ev,
  (VTBL_ENTRY)&_ZN6S209C63v30Ev,
  (VTBL_ENTRY)&_ZN6S209C63v31Ev,
  (VTBL_ENTRY)&_ZN6S209C63v32Ev,
  (VTBL_ENTRY)&_ZN6S209C63v33Ev,
  (VTBL_ENTRY)&_ZN6S209C63v34Ev,
  (VTBL_ENTRY)&_ZN6S209C63v35Ev,
  (VTBL_ENTRY)&_ZN6S209C63v36Ev,
  (VTBL_ENTRY)&_ZN6S209C63v37Ev,
  (VTBL_ENTRY)&_ZN6S209C63v38Ev,
  (VTBL_ENTRY)&_ZN6S209C63v39Ev,
  (VTBL_ENTRY)&_ZN6S209C63v40Ev,
  (VTBL_ENTRY)&_ZN6S209C63v41Ev,
  (VTBL_ENTRY)&_ZN6S209C63v42Ev,
  (VTBL_ENTRY)&_ZN6S209C63v43Ev,
  (VTBL_ENTRY)&_ZN6S209C63v44Ev,
  (VTBL_ENTRY)&_ZN6S209C63v45Ev,
  (VTBL_ENTRY)&_ZN6S209C63v46Ev,
  (VTBL_ENTRY)&_ZN6S209C63v47Ev,
  (VTBL_ENTRY)&_ZN6S209C63v48Ev,
  (VTBL_ENTRY)&_ZN6S209C63v49Ev,
  (VTBL_ENTRY)&_ZN6S209C63v50Ev,
  (VTBL_ENTRY)&_ZN6S209C63v51Ev,
  (VTBL_ENTRY)&_ZN6S209C63v52Ev,
  (VTBL_ENTRY)&_ZN6S209C63v53Ev,
  (VTBL_ENTRY)&_ZN6S209C63v54Ev,
  (VTBL_ENTRY)&_ZN6S209C63v55Ev,
  (VTBL_ENTRY)&_ZN6S209C63v56Ev,
  (VTBL_ENTRY)&_ZN6S209C63v57Ev,
  (VTBL_ENTRY)&_ZN6S209C63v58Ev,
  (VTBL_ENTRY)&_ZN6S209C63v59Ev,
  (VTBL_ENTRY)&_ZN6S209C63v60Ev,
  (VTBL_ENTRY)&_ZN6S209C63v61Ev,
  (VTBL_ENTRY)&_ZN6S209C63v62Ev,
  (VTBL_ENTRY)&_ZN6S209C63v63Ev,
  (VTBL_ENTRY)&_ZN6S209C63v64Ev,
  (VTBL_ENTRY)&_ZN6S209C63v65Ev,
  (VTBL_ENTRY)&_ZN6S209C63v66Ev,
  (VTBL_ENTRY)&_ZN6S209C63v67Ev,
  (VTBL_ENTRY)&_ZN6S209C53v68Ev,
  (VTBL_ENTRY)&_ZN6S209C53v69Ev,
  (VTBL_ENTRY)&_ZN6S209C53v70Ev,
  (VTBL_ENTRY)&_ZN6S209C53v71Ev,
  (VTBL_ENTRY)&_ZN6S209C53v72Ev,
  (VTBL_ENTRY)&_ZN6S209C53v73Ev,
  (VTBL_ENTRY)&_ZN6S209C53v74Ev,
  (VTBL_ENTRY)&_ZN6S209C53v75Ev,
  (VTBL_ENTRY)&_ZN6S209C53v76Ev,
  (VTBL_ENTRY)&_ZN6S209C53v77Ev,
  (VTBL_ENTRY)&_ZN6S209C53v78Ev,
  (VTBL_ENTRY)&_ZN6S209C53v79Ev,
  (VTBL_ENTRY)&_ZN6S209C53v80Ev,
  (VTBL_ENTRY)&_ZN6S209C53v81Ev,
  (VTBL_ENTRY)&_ZN6S209C53v82Ev,
  (VTBL_ENTRY)&_ZN6S209C53v83Ev,
  (VTBL_ENTRY)&_ZN6S209C53v84Ev,
  (VTBL_ENTRY)&_ZN6S209C53v85Ev,
  (VTBL_ENTRY)&_ZN6S209C53v86Ev,
  (VTBL_ENTRY)&_ZN6S209C53v87Ev,
  (VTBL_ENTRY)&_ZN6S209C53v88Ev,
  (VTBL_ENTRY)&_ZN6S209C53v89Ev,
};
extern VTBL_ENTRY _ZTI6S209C5[];
extern  VTBL_ENTRY _ZTV6S209C5[];
Class_Descriptor cd_S209C5 = {  "S209C5", // class name
  bases_S209C5, 1,
  &(vtc_S209C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S209C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S209C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S209C4  : S209C5 {
  unsigned int s209c4f0:1;
  unsigned int s209c4f1:1;
  unsigned int s209c4f2:1;
  ::S1503C28 s209c4f3;
  ::S1503C24 s209c4f4;
  ::S1503C18 s209c4f5;
  ::S1503C12 s209c4f6;
  int s209c4f7[3];
  virtual  ~S209C4(); // _ZN6S209C4D1Ev
  virtual void  v90(); // _ZN6S209C43v90Ev
  virtual void  v91(); // _ZN6S209C43v91Ev
  virtual void  v92(); // _ZN6S209C43v92Ev
  virtual void  v93(); // _ZN6S209C43v93Ev
  virtual void  v94(); // _ZN6S209C43v94Ev
  virtual void  v95(); // _ZN6S209C43v95Ev
  virtual void  v96(); // _ZN6S209C43v96Ev
  virtual void  v97(); // _ZN6S209C43v97Ev
  virtual void  v98(); // _ZN6S209C43v98Ev
  virtual void  v99(); // _ZN6S209C43v99Ev
  virtual void  v100(); // _ZN6S209C44v100Ev
  virtual void  v101(); // _ZN6S209C44v101Ev
  virtual void  v102(); // _ZN6S209C44v102Ev
  virtual void  v103(); // _ZN6S209C44v103Ev
  virtual void  v104(); // _ZN6S209C44v104Ev
  virtual void  v105(); // _ZN6S209C44v105Ev
  virtual void  v106(); // _ZN6S209C44v106Ev
  virtual void  v107(); // _ZN6S209C44v107Ev
  virtual void  v108(); // _ZN6S209C44v108Ev
  virtual void  v109(); // _ZN6S209C44v109Ev
  S209C4(); // tgen
};
//SIG(-1 S209C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S209C4 ::~S209C4(){ note_dtor("S209C4", this);}
void  S209C4 ::v90(){vfunc_called(this, "_ZN6S209C43v90Ev");}
void  S209C4 ::v91(){vfunc_called(this, "_ZN6S209C43v91Ev");}
void  S209C4 ::v92(){vfunc_called(this, "_ZN6S209C43v92Ev");}
void  S209C4 ::v93(){vfunc_called(this, "_ZN6S209C43v93Ev");}
void  S209C4 ::v94(){vfunc_called(this, "_ZN6S209C43v94Ev");}
void  S209C4 ::v95(){vfunc_called(this, "_ZN6S209C43v95Ev");}
void  S209C4 ::v96(){vfunc_called(this, "_ZN6S209C43v96Ev");}
void  S209C4 ::v97(){vfunc_called(this, "_ZN6S209C43v97Ev");}
void  S209C4 ::v98(){vfunc_called(this, "_ZN6S209C43v98Ev");}
void  S209C4 ::v99(){vfunc_called(this, "_ZN6S209C43v99Ev");}
void  S209C4 ::v100(){vfunc_called(this, "_ZN6S209C44v100Ev");}
void  S209C4 ::v101(){vfunc_called(this, "_ZN6S209C44v101Ev");}
void  S209C4 ::v102(){vfunc_called(this, "_ZN6S209C44v102Ev");}
void  S209C4 ::v103(){vfunc_called(this, "_ZN6S209C44v103Ev");}
void  S209C4 ::v104(){vfunc_called(this, "_ZN6S209C44v104Ev");}
void  S209C4 ::v105(){vfunc_called(this, "_ZN6S209C44v105Ev");}
void  S209C4 ::v106(){vfunc_called(this, "_ZN6S209C44v106Ev");}
void  S209C4 ::v107(){vfunc_called(this, "_ZN6S209C44v107Ev");}
void  S209C4 ::v108(){vfunc_called(this, "_ZN6S209C44v108Ev");}
void  S209C4 ::v109(){vfunc_called(this, "_ZN6S209C44v109Ev");}
S209C4 ::S209C4(){ note_ctor("S209C4", this);} // tgen

static void Test_S209C4()
{
  extern Class_Descriptor cd_S209C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S209C4, buf);
    S209C4 *dp, &lv = *(dp=new (buf) S209C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S209C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S209C4)");
    check_base_class_offset(lv, (S209C6*)(S209C5*), 0, "S209C4");
    check_base_class_offset(lv, (S209C5*), 0, "S209C4");
    set_bf_and_test(lv, s209c4f0, ABISELECT(188,132), 0, 1, 1, "S209C4");
    set_bf_and_test(lv, s209c4f1, ABISELECT(188,132), 1, 1, 1, "S209C4");
    set_bf_and_test(lv, s209c4f2, ABISELECT(188,132), 2, 1, 1, "S209C4");
    check_field_offset(lv, s209c4f3, ABISELECT(192,136), "S209C4.s209c4f3");
    check_field_offset(lv, s209c4f4, ABISELECT(208,148), "S209C4.s209c4f4");
    check_field_offset(lv, s209c4f5, ABISELECT(224,160), "S209C4.s209c4f5");
    check_field_offset(lv, s209c4f6, ABISELECT(240,172), "S209C4.s209c4f6");
    check_field_offset(lv, s209c4f7, ABISELECT(256,184), "S209C4.s209c4f7");
    test_class_info(&lv, &cd_S209C4);
    dp->~S209C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS209C4(Test_S209C4, "S209C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S209C4C1Ev();
extern void _ZN6S209C4D1Ev();
Name_Map name_map_S209C4[] = {
  NSPAIR(_ZN6S209C4C1Ev),
  NSPAIR(_ZN6S209C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S209C6;
extern VTBL_ENTRY _ZTI6S209C6[];
extern  VTBL_ENTRY _ZTV6S209C6[];
extern Class_Descriptor cd_S209C5;
extern VTBL_ENTRY _ZTI6S209C5[];
extern  VTBL_ENTRY _ZTV6S209C5[];
static Base_Class bases_S209C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S209C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S209C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S209C4[];
extern void _ZN6S209C4D1Ev();
extern void _ZN6S209C4D0Ev();
extern void _ZN6S209C62v4Ev();
extern void _ZN6S209C62v5Ev();
extern void _ZN6S209C62v6Ev();
extern void _ZN6S209C62v7Ev();
extern void _ZN6S209C62v8Ev();
extern void _ZN6S209C62v9Ev();
extern void _ZN6S209C63v10Ev();
extern void _ZN6S209C63v11Ev();
extern void _ZN6S209C63v12Ev();
extern void _ZN6S209C63v13Ev();
extern void _ZN6S209C63v14Ev();
extern void _ZN6S209C63v15Ev();
extern void _ZN6S209C63v16Ev();
extern void _ZN6S209C63v17Ev();
extern void _ZN6S209C63v18Ev();
extern void _ZN6S209C63v19Ev();
extern void _ZN6S209C63v20Ev();
extern void _ZN6S209C63v21Ev();
extern void _ZN6S209C63v22Ev();
extern void _ZN6S209C63v23Ev();
extern void _ZN6S209C63v24Ev();
extern void _ZN6S209C63v25Ev();
extern void _ZN6S209C63v26Ev();
extern void _ZN6S209C63v27Ev();
extern void _ZN6S209C63v28Ev();
extern void _ZN6S209C63v29Ev();
extern void _ZN6S209C63v30Ev();
extern void _ZN6S209C63v31Ev();
extern void _ZN6S209C63v32Ev();
extern void _ZN6S209C63v33Ev();
extern void _ZN6S209C63v34Ev();
extern void _ZN6S209C63v35Ev();
extern void _ZN6S209C63v36Ev();
extern void _ZN6S209C63v37Ev();
extern void _ZN6S209C63v38Ev();
extern void _ZN6S209C63v39Ev();
extern void _ZN6S209C63v40Ev();
extern void _ZN6S209C63v41Ev();
extern void _ZN6S209C63v42Ev();
extern void _ZN6S209C63v43Ev();
extern void _ZN6S209C63v44Ev();
extern void _ZN6S209C63v45Ev();
extern void _ZN6S209C63v46Ev();
extern void _ZN6S209C63v47Ev();
extern void _ZN6S209C63v48Ev();
extern void _ZN6S209C63v49Ev();
extern void _ZN6S209C63v50Ev();
extern void _ZN6S209C63v51Ev();
extern void _ZN6S209C63v52Ev();
extern void _ZN6S209C63v53Ev();
extern void _ZN6S209C63v54Ev();
extern void _ZN6S209C63v55Ev();
extern void _ZN6S209C63v56Ev();
extern void _ZN6S209C63v57Ev();
extern void _ZN6S209C63v58Ev();
extern void _ZN6S209C63v59Ev();
extern void _ZN6S209C63v60Ev();
extern void _ZN6S209C63v61Ev();
extern void _ZN6S209C63v62Ev();
extern void _ZN6S209C63v63Ev();
extern void _ZN6S209C63v64Ev();
extern void _ZN6S209C63v65Ev();
extern void _ZN6S209C63v66Ev();
extern void _ZN6S209C63v67Ev();
extern void _ZN6S209C53v68Ev();
extern void _ZN6S209C53v69Ev();
extern void _ZN6S209C53v70Ev();
extern void _ZN6S209C53v71Ev();
extern void _ZN6S209C53v72Ev();
extern void _ZN6S209C53v73Ev();
extern void _ZN6S209C53v74Ev();
extern void _ZN6S209C53v75Ev();
extern void _ZN6S209C53v76Ev();
extern void _ZN6S209C53v77Ev();
extern void _ZN6S209C53v78Ev();
extern void _ZN6S209C53v79Ev();
extern void _ZN6S209C53v80Ev();
extern void _ZN6S209C53v81Ev();
extern void _ZN6S209C53v82Ev();
extern void _ZN6S209C53v83Ev();
extern void _ZN6S209C53v84Ev();
extern void _ZN6S209C53v85Ev();
extern void _ZN6S209C53v86Ev();
extern void _ZN6S209C53v87Ev();
extern void _ZN6S209C53v88Ev();
extern void _ZN6S209C53v89Ev();
extern void _ZN6S209C43v90Ev();
extern void _ZN6S209C43v91Ev();
extern void _ZN6S209C43v92Ev();
extern void _ZN6S209C43v93Ev();
extern void _ZN6S209C43v94Ev();
extern void _ZN6S209C43v95Ev();
extern void _ZN6S209C43v96Ev();
extern void _ZN6S209C43v97Ev();
extern void _ZN6S209C43v98Ev();
extern void _ZN6S209C43v99Ev();
extern void _ZN6S209C44v100Ev();
extern void _ZN6S209C44v101Ev();
extern void _ZN6S209C44v102Ev();
extern void _ZN6S209C44v103Ev();
extern void _ZN6S209C44v104Ev();
extern void _ZN6S209C44v105Ev();
extern void _ZN6S209C44v106Ev();
extern void _ZN6S209C44v107Ev();
extern void _ZN6S209C44v108Ev();
extern void _ZN6S209C44v109Ev();
static  VTBL_ENTRY vtc_S209C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S209C4[0]),
  (VTBL_ENTRY)&_ZN6S209C4D1Ev,
  (VTBL_ENTRY)&_ZN6S209C4D0Ev,
  (VTBL_ENTRY)&_ZN6S209C62v4Ev,
  (VTBL_ENTRY)&_ZN6S209C62v5Ev,
  (VTBL_ENTRY)&_ZN6S209C62v6Ev,
  (VTBL_ENTRY)&_ZN6S209C62v7Ev,
  (VTBL_ENTRY)&_ZN6S209C62v8Ev,
  (VTBL_ENTRY)&_ZN6S209C62v9Ev,
  (VTBL_ENTRY)&_ZN6S209C63v10Ev,
  (VTBL_ENTRY)&_ZN6S209C63v11Ev,
  (VTBL_ENTRY)&_ZN6S209C63v12Ev,
  (VTBL_ENTRY)&_ZN6S209C63v13Ev,
  (VTBL_ENTRY)&_ZN6S209C63v14Ev,
  (VTBL_ENTRY)&_ZN6S209C63v15Ev,
  (VTBL_ENTRY)&_ZN6S209C63v16Ev,
  (VTBL_ENTRY)&_ZN6S209C63v17Ev,
  (VTBL_ENTRY)&_ZN6S209C63v18Ev,
  (VTBL_ENTRY)&_ZN6S209C63v19Ev,
  (VTBL_ENTRY)&_ZN6S209C63v20Ev,
  (VTBL_ENTRY)&_ZN6S209C63v21Ev,
  (VTBL_ENTRY)&_ZN6S209C63v22Ev,
  (VTBL_ENTRY)&_ZN6S209C63v23Ev,
  (VTBL_ENTRY)&_ZN6S209C63v24Ev,
  (VTBL_ENTRY)&_ZN6S209C63v25Ev,
  (VTBL_ENTRY)&_ZN6S209C63v26Ev,
  (VTBL_ENTRY)&_ZN6S209C63v27Ev,
  (VTBL_ENTRY)&_ZN6S209C63v28Ev,
  (VTBL_ENTRY)&_ZN6S209C63v29Ev,
  (VTBL_ENTRY)&_ZN6S209C63v30Ev,
  (VTBL_ENTRY)&_ZN6S209C63v31Ev,
  (VTBL_ENTRY)&_ZN6S209C63v32Ev,
  (VTBL_ENTRY)&_ZN6S209C63v33Ev,
  (VTBL_ENTRY)&_ZN6S209C63v34Ev,
  (VTBL_ENTRY)&_ZN6S209C63v35Ev,
  (VTBL_ENTRY)&_ZN6S209C63v36Ev,
  (VTBL_ENTRY)&_ZN6S209C63v37Ev,
  (VTBL_ENTRY)&_ZN6S209C63v38Ev,
  (VTBL_ENTRY)&_ZN6S209C63v39Ev,
  (VTBL_ENTRY)&_ZN6S209C63v40Ev,
  (VTBL_ENTRY)&_ZN6S209C63v41Ev,
  (VTBL_ENTRY)&_ZN6S209C63v42Ev,
  (VTBL_ENTRY)&_ZN6S209C63v43Ev,
  (VTBL_ENTRY)&_ZN6S209C63v44Ev,
  (VTBL_ENTRY)&_ZN6S209C63v45Ev,
  (VTBL_ENTRY)&_ZN6S209C63v46Ev,
  (VTBL_ENTRY)&_ZN6S209C63v47Ev,
  (VTBL_ENTRY)&_ZN6S209C63v48Ev,
  (VTBL_ENTRY)&_ZN6S209C63v49Ev,
  (VTBL_ENTRY)&_ZN6S209C63v50Ev,
  (VTBL_ENTRY)&_ZN6S209C63v51Ev,
  (VTBL_ENTRY)&_ZN6S209C63v52Ev,
  (VTBL_ENTRY)&_ZN6S209C63v53Ev,
  (VTBL_ENTRY)&_ZN6S209C63v54Ev,
  (VTBL_ENTRY)&_ZN6S209C63v55Ev,
  (VTBL_ENTRY)&_ZN6S209C63v56Ev,
  (VTBL_ENTRY)&_ZN6S209C63v57Ev,
  (VTBL_ENTRY)&_ZN6S209C63v58Ev,
  (VTBL_ENTRY)&_ZN6S209C63v59Ev,
  (VTBL_ENTRY)&_ZN6S209C63v60Ev,
  (VTBL_ENTRY)&_ZN6S209C63v61Ev,
  (VTBL_ENTRY)&_ZN6S209C63v62Ev,
  (VTBL_ENTRY)&_ZN6S209C63v63Ev,
  (VTBL_ENTRY)&_ZN6S209C63v64Ev,
  (VTBL_ENTRY)&_ZN6S209C63v65Ev,
  (VTBL_ENTRY)&_ZN6S209C63v66Ev,
  (VTBL_ENTRY)&_ZN6S209C63v67Ev,
  (VTBL_ENTRY)&_ZN6S209C53v68Ev,
  (VTBL_ENTRY)&_ZN6S209C53v69Ev,
  (VTBL_ENTRY)&_ZN6S209C53v70Ev,
  (VTBL_ENTRY)&_ZN6S209C53v71Ev,
  (VTBL_ENTRY)&_ZN6S209C53v72Ev,
  (VTBL_ENTRY)&_ZN6S209C53v73Ev,
  (VTBL_ENTRY)&_ZN6S209C53v74Ev,
  (VTBL_ENTRY)&_ZN6S209C53v75Ev,
  (VTBL_ENTRY)&_ZN6S209C53v76Ev,
  (VTBL_ENTRY)&_ZN6S209C53v77Ev,
  (VTBL_ENTRY)&_ZN6S209C53v78Ev,
  (VTBL_ENTRY)&_ZN6S209C53v79Ev,
  (VTBL_ENTRY)&_ZN6S209C53v80Ev,
  (VTBL_ENTRY)&_ZN6S209C53v81Ev,
  (VTBL_ENTRY)&_ZN6S209C53v82Ev,
  (VTBL_ENTRY)&_ZN6S209C53v83Ev,
  (VTBL_ENTRY)&_ZN6S209C53v84Ev,
  (VTBL_ENTRY)&_ZN6S209C53v85Ev,
  (VTBL_ENTRY)&_ZN6S209C53v86Ev,
  (VTBL_ENTRY)&_ZN6S209C53v87Ev,
  (VTBL_ENTRY)&_ZN6S209C53v88Ev,
  (VTBL_ENTRY)&_ZN6S209C53v89Ev,
  (VTBL_ENTRY)&_ZN6S209C43v90Ev,
  (VTBL_ENTRY)&_ZN6S209C43v91Ev,
  (VTBL_ENTRY)&_ZN6S209C43v92Ev,
  (VTBL_ENTRY)&_ZN6S209C43v93Ev,
  (VTBL_ENTRY)&_ZN6S209C43v94Ev,
  (VTBL_ENTRY)&_ZN6S209C43v95Ev,
  (VTBL_ENTRY)&_ZN6S209C43v96Ev,
  (VTBL_ENTRY)&_ZN6S209C43v97Ev,
  (VTBL_ENTRY)&_ZN6S209C43v98Ev,
  (VTBL_ENTRY)&_ZN6S209C43v99Ev,
  (VTBL_ENTRY)&_ZN6S209C44v100Ev,
  (VTBL_ENTRY)&_ZN6S209C44v101Ev,
  (VTBL_ENTRY)&_ZN6S209C44v102Ev,
  (VTBL_ENTRY)&_ZN6S209C44v103Ev,
  (VTBL_ENTRY)&_ZN6S209C44v104Ev,
  (VTBL_ENTRY)&_ZN6S209C44v105Ev,
  (VTBL_ENTRY)&_ZN6S209C44v106Ev,
  (VTBL_ENTRY)&_ZN6S209C44v107Ev,
  (VTBL_ENTRY)&_ZN6S209C44v108Ev,
  (VTBL_ENTRY)&_ZN6S209C44v109Ev,
};
extern VTBL_ENTRY _ZTI6S209C4[];
extern  VTBL_ENTRY _ZTV6S209C4[];
Class_Descriptor cd_S209C4 = {  "S209C4", // class name
  bases_S209C4, 2,
  &(vtc_S209C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S209C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S209C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S209C3  : S209C4 {
  ::S1503C5_nt s209c3f0;
  unsigned int s209c3f1:1;
  ::S1503C6_nt s209c3f2;
  virtual  ~S209C3(); // _ZN6S209C3D1Ev
  virtual void  v110(); // _ZN6S209C34v110Ev
  virtual void  v111(); // _ZN6S209C34v111Ev
  virtual void  v112(); // _ZN6S209C34v112Ev
  virtual void  v113(); // _ZN6S209C34v113Ev
  S209C3(); // tgen
};
//SIG(-1 S209C3) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S209C3 ::~S209C3(){ note_dtor("S209C3", this);}
void  S209C3 ::v110(){vfunc_called(this, "_ZN6S209C34v110Ev");}
void  S209C3 ::v111(){vfunc_called(this, "_ZN6S209C34v111Ev");}
void  S209C3 ::v112(){vfunc_called(this, "_ZN6S209C34v112Ev");}
void  S209C3 ::v113(){vfunc_called(this, "_ZN6S209C34v113Ev");}
S209C3 ::S209C3(){ note_ctor("S209C3", this);} // tgen

static void Test_S209C3()
{
  extern Class_Descriptor cd_S209C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S209C3, buf);
    S209C3 *dp, &lv = *(dp=new (buf) S209C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S209C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S209C3)");
    check_base_class_offset(lv, (S209C6*)(S209C5*)(S209C4*), 0, "S209C3");
    check_base_class_offset(lv, (S209C5*)(S209C4*), 0, "S209C3");
    check_base_class_offset(lv, (S209C4*), 0, "S209C3");
    check_field_offset(lv, s209c3f0, ABISELECT(268,196), "S209C3.s209c3f0");
    set_bf_and_test(lv, s209c3f1, ABISELECT(276,204), 0, 1, 1, "S209C3");
    check_field_offset(lv, s209c3f2, ABISELECT(280,208), "S209C3.s209c3f2");
    test_class_info(&lv, &cd_S209C3);
    dp->~S209C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS209C3(Test_S209C3, "S209C3", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S209C3C1Ev();
extern void _ZN6S209C3D1Ev();
Name_Map name_map_S209C3[] = {
  NSPAIR(_ZN6S209C3C1Ev),
  NSPAIR(_ZN6S209C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S209C6;
extern VTBL_ENTRY _ZTI6S209C6[];
extern  VTBL_ENTRY _ZTV6S209C6[];
extern Class_Descriptor cd_S209C5;
extern VTBL_ENTRY _ZTI6S209C5[];
extern  VTBL_ENTRY _ZTV6S209C5[];
extern Class_Descriptor cd_S209C4;
extern VTBL_ENTRY _ZTI6S209C4[];
extern  VTBL_ENTRY _ZTV6S209C4[];
static Base_Class bases_S209C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S209C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S209C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S209C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S209C3[];
extern void _ZN6S209C3D1Ev();
extern void _ZN6S209C3D0Ev();
extern void _ZN6S209C62v4Ev();
extern void _ZN6S209C62v5Ev();
extern void _ZN6S209C62v6Ev();
extern void _ZN6S209C62v7Ev();
extern void _ZN6S209C62v8Ev();
extern void _ZN6S209C62v9Ev();
extern void _ZN6S209C63v10Ev();
extern void _ZN6S209C63v11Ev();
extern void _ZN6S209C63v12Ev();
extern void _ZN6S209C63v13Ev();
extern void _ZN6S209C63v14Ev();
extern void _ZN6S209C63v15Ev();
extern void _ZN6S209C63v16Ev();
extern void _ZN6S209C63v17Ev();
extern void _ZN6S209C63v18Ev();
extern void _ZN6S209C63v19Ev();
extern void _ZN6S209C63v20Ev();
extern void _ZN6S209C63v21Ev();
extern void _ZN6S209C63v22Ev();
extern void _ZN6S209C63v23Ev();
extern void _ZN6S209C63v24Ev();
extern void _ZN6S209C63v25Ev();
extern void _ZN6S209C63v26Ev();
extern void _ZN6S209C63v27Ev();
extern void _ZN6S209C63v28Ev();
extern void _ZN6S209C63v29Ev();
extern void _ZN6S209C63v30Ev();
extern void _ZN6S209C63v31Ev();
extern void _ZN6S209C63v32Ev();
extern void _ZN6S209C63v33Ev();
extern void _ZN6S209C63v34Ev();
extern void _ZN6S209C63v35Ev();
extern void _ZN6S209C63v36Ev();
extern void _ZN6S209C63v37Ev();
extern void _ZN6S209C63v38Ev();
extern void _ZN6S209C63v39Ev();
extern void _ZN6S209C63v40Ev();
extern void _ZN6S209C63v41Ev();
extern void _ZN6S209C63v42Ev();
extern void _ZN6S209C63v43Ev();
extern void _ZN6S209C63v44Ev();
extern void _ZN6S209C63v45Ev();
extern void _ZN6S209C63v46Ev();
extern void _ZN6S209C63v47Ev();
extern void _ZN6S209C63v48Ev();
extern void _ZN6S209C63v49Ev();
extern void _ZN6S209C63v50Ev();
extern void _ZN6S209C63v51Ev();
extern void _ZN6S209C63v52Ev();
extern void _ZN6S209C63v53Ev();
extern void _ZN6S209C63v54Ev();
extern void _ZN6S209C63v55Ev();
extern void _ZN6S209C63v56Ev();
extern void _ZN6S209C63v57Ev();
extern void _ZN6S209C63v58Ev();
extern void _ZN6S209C63v59Ev();
extern void _ZN6S209C63v60Ev();
extern void _ZN6S209C63v61Ev();
extern void _ZN6S209C63v62Ev();
extern void _ZN6S209C63v63Ev();
extern void _ZN6S209C63v64Ev();
extern void _ZN6S209C63v65Ev();
extern void _ZN6S209C63v66Ev();
extern void _ZN6S209C63v67Ev();
extern void _ZN6S209C53v68Ev();
extern void _ZN6S209C53v69Ev();
extern void _ZN6S209C53v70Ev();
extern void _ZN6S209C53v71Ev();
extern void _ZN6S209C53v72Ev();
extern void _ZN6S209C53v73Ev();
extern void _ZN6S209C53v74Ev();
extern void _ZN6S209C53v75Ev();
extern void _ZN6S209C53v76Ev();
extern void _ZN6S209C53v77Ev();
extern void _ZN6S209C53v78Ev();
extern void _ZN6S209C53v79Ev();
extern void _ZN6S209C53v80Ev();
extern void _ZN6S209C53v81Ev();
extern void _ZN6S209C53v82Ev();
extern void _ZN6S209C53v83Ev();
extern void _ZN6S209C53v84Ev();
extern void _ZN6S209C53v85Ev();
extern void _ZN6S209C53v86Ev();
extern void _ZN6S209C53v87Ev();
extern void _ZN6S209C53v88Ev();
extern void _ZN6S209C53v89Ev();
extern void _ZN6S209C43v90Ev();
extern void _ZN6S209C43v91Ev();
extern void _ZN6S209C43v92Ev();
extern void _ZN6S209C43v93Ev();
extern void _ZN6S209C43v94Ev();
extern void _ZN6S209C43v95Ev();
extern void _ZN6S209C43v96Ev();
extern void _ZN6S209C43v97Ev();
extern void _ZN6S209C43v98Ev();
extern void _ZN6S209C43v99Ev();
extern void _ZN6S209C44v100Ev();
extern void _ZN6S209C44v101Ev();
extern void _ZN6S209C44v102Ev();
extern void _ZN6S209C44v103Ev();
extern void _ZN6S209C44v104Ev();
extern void _ZN6S209C44v105Ev();
extern void _ZN6S209C44v106Ev();
extern void _ZN6S209C44v107Ev();
extern void _ZN6S209C44v108Ev();
extern void _ZN6S209C44v109Ev();
extern void _ZN6S209C34v110Ev();
extern void _ZN6S209C34v111Ev();
extern void _ZN6S209C34v112Ev();
extern void _ZN6S209C34v113Ev();
static  VTBL_ENTRY vtc_S209C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S209C3[0]),
  (VTBL_ENTRY)&_ZN6S209C3D1Ev,
  (VTBL_ENTRY)&_ZN6S209C3D0Ev,
  (VTBL_ENTRY)&_ZN6S209C62v4Ev,
  (VTBL_ENTRY)&_ZN6S209C62v5Ev,
  (VTBL_ENTRY)&_ZN6S209C62v6Ev,
  (VTBL_ENTRY)&_ZN6S209C62v7Ev,
  (VTBL_ENTRY)&_ZN6S209C62v8Ev,
  (VTBL_ENTRY)&_ZN6S209C62v9Ev,
  (VTBL_ENTRY)&_ZN6S209C63v10Ev,
  (VTBL_ENTRY)&_ZN6S209C63v11Ev,
  (VTBL_ENTRY)&_ZN6S209C63v12Ev,
  (VTBL_ENTRY)&_ZN6S209C63v13Ev,
  (VTBL_ENTRY)&_ZN6S209C63v14Ev,
  (VTBL_ENTRY)&_ZN6S209C63v15Ev,
  (VTBL_ENTRY)&_ZN6S209C63v16Ev,
  (VTBL_ENTRY)&_ZN6S209C63v17Ev,
  (VTBL_ENTRY)&_ZN6S209C63v18Ev,
  (VTBL_ENTRY)&_ZN6S209C63v19Ev,
  (VTBL_ENTRY)&_ZN6S209C63v20Ev,
  (VTBL_ENTRY)&_ZN6S209C63v21Ev,
  (VTBL_ENTRY)&_ZN6S209C63v22Ev,
  (VTBL_ENTRY)&_ZN6S209C63v23Ev,
  (VTBL_ENTRY)&_ZN6S209C63v24Ev,
  (VTBL_ENTRY)&_ZN6S209C63v25Ev,
  (VTBL_ENTRY)&_ZN6S209C63v26Ev,
  (VTBL_ENTRY)&_ZN6S209C63v27Ev,
  (VTBL_ENTRY)&_ZN6S209C63v28Ev,
  (VTBL_ENTRY)&_ZN6S209C63v29Ev,
  (VTBL_ENTRY)&_ZN6S209C63v30Ev,
  (VTBL_ENTRY)&_ZN6S209C63v31Ev,
  (VTBL_ENTRY)&_ZN6S209C63v32Ev,
  (VTBL_ENTRY)&_ZN6S209C63v33Ev,
  (VTBL_ENTRY)&_ZN6S209C63v34Ev,
  (VTBL_ENTRY)&_ZN6S209C63v35Ev,
  (VTBL_ENTRY)&_ZN6S209C63v36Ev,
  (VTBL_ENTRY)&_ZN6S209C63v37Ev,
  (VTBL_ENTRY)&_ZN6S209C63v38Ev,
  (VTBL_ENTRY)&_ZN6S209C63v39Ev,
  (VTBL_ENTRY)&_ZN6S209C63v40Ev,
  (VTBL_ENTRY)&_ZN6S209C63v41Ev,
  (VTBL_ENTRY)&_ZN6S209C63v42Ev,
  (VTBL_ENTRY)&_ZN6S209C63v43Ev,
  (VTBL_ENTRY)&_ZN6S209C63v44Ev,
  (VTBL_ENTRY)&_ZN6S209C63v45Ev,
  (VTBL_ENTRY)&_ZN6S209C63v46Ev,
  (VTBL_ENTRY)&_ZN6S209C63v47Ev,
  (VTBL_ENTRY)&_ZN6S209C63v48Ev,
  (VTBL_ENTRY)&_ZN6S209C63v49Ev,
  (VTBL_ENTRY)&_ZN6S209C63v50Ev,
  (VTBL_ENTRY)&_ZN6S209C63v51Ev,
  (VTBL_ENTRY)&_ZN6S209C63v52Ev,
  (VTBL_ENTRY)&_ZN6S209C63v53Ev,
  (VTBL_ENTRY)&_ZN6S209C63v54Ev,
  (VTBL_ENTRY)&_ZN6S209C63v55Ev,
  (VTBL_ENTRY)&_ZN6S209C63v56Ev,
  (VTBL_ENTRY)&_ZN6S209C63v57Ev,
  (VTBL_ENTRY)&_ZN6S209C63v58Ev,
  (VTBL_ENTRY)&_ZN6S209C63v59Ev,
  (VTBL_ENTRY)&_ZN6S209C63v60Ev,
  (VTBL_ENTRY)&_ZN6S209C63v61Ev,
  (VTBL_ENTRY)&_ZN6S209C63v62Ev,
  (VTBL_ENTRY)&_ZN6S209C63v63Ev,
  (VTBL_ENTRY)&_ZN6S209C63v64Ev,
  (VTBL_ENTRY)&_ZN6S209C63v65Ev,
  (VTBL_ENTRY)&_ZN6S209C63v66Ev,
  (VTBL_ENTRY)&_ZN6S209C63v67Ev,
  (VTBL_ENTRY)&_ZN6S209C53v68Ev,
  (VTBL_ENTRY)&_ZN6S209C53v69Ev,
  (VTBL_ENTRY)&_ZN6S209C53v70Ev,
  (VTBL_ENTRY)&_ZN6S209C53v71Ev,
  (VTBL_ENTRY)&_ZN6S209C53v72Ev,
  (VTBL_ENTRY)&_ZN6S209C53v73Ev,
  (VTBL_ENTRY)&_ZN6S209C53v74Ev,
  (VTBL_ENTRY)&_ZN6S209C53v75Ev,
  (VTBL_ENTRY)&_ZN6S209C53v76Ev,
  (VTBL_ENTRY)&_ZN6S209C53v77Ev,
  (VTBL_ENTRY)&_ZN6S209C53v78Ev,
  (VTBL_ENTRY)&_ZN6S209C53v79Ev,
  (VTBL_ENTRY)&_ZN6S209C53v80Ev,
  (VTBL_ENTRY)&_ZN6S209C53v81Ev,
  (VTBL_ENTRY)&_ZN6S209C53v82Ev,
  (VTBL_ENTRY)&_ZN6S209C53v83Ev,
  (VTBL_ENTRY)&_ZN6S209C53v84Ev,
  (VTBL_ENTRY)&_ZN6S209C53v85Ev,
  (VTBL_ENTRY)&_ZN6S209C53v86Ev,
  (VTBL_ENTRY)&_ZN6S209C53v87Ev,
  (VTBL_ENTRY)&_ZN6S209C53v88Ev,
  (VTBL_ENTRY)&_ZN6S209C53v89Ev,
  (VTBL_ENTRY)&_ZN6S209C43v90Ev,
  (VTBL_ENTRY)&_ZN6S209C43v91Ev,
  (VTBL_ENTRY)&_ZN6S209C43v92Ev,
  (VTBL_ENTRY)&_ZN6S209C43v93Ev,
  (VTBL_ENTRY)&_ZN6S209C43v94Ev,
  (VTBL_ENTRY)&_ZN6S209C43v95Ev,
  (VTBL_ENTRY)&_ZN6S209C43v96Ev,
  (VTBL_ENTRY)&_ZN6S209C43v97Ev,
  (VTBL_ENTRY)&_ZN6S209C43v98Ev,
  (VTBL_ENTRY)&_ZN6S209C43v99Ev,
  (VTBL_ENTRY)&_ZN6S209C44v100Ev,
  (VTBL_ENTRY)&_ZN6S209C44v101Ev,
  (VTBL_ENTRY)&_ZN6S209C44v102Ev,
  (VTBL_ENTRY)&_ZN6S209C44v103Ev,
  (VTBL_ENTRY)&_ZN6S209C44v104Ev,
  (VTBL_ENTRY)&_ZN6S209C44v105Ev,
  (VTBL_ENTRY)&_ZN6S209C44v106Ev,
  (VTBL_ENTRY)&_ZN6S209C44v107Ev,
  (VTBL_ENTRY)&_ZN6S209C44v108Ev,
  (VTBL_ENTRY)&_ZN6S209C44v109Ev,
  (VTBL_ENTRY)&_ZN6S209C34v110Ev,
  (VTBL_ENTRY)&_ZN6S209C34v111Ev,
  (VTBL_ENTRY)&_ZN6S209C34v112Ev,
  (VTBL_ENTRY)&_ZN6S209C34v113Ev,
};
extern VTBL_ENTRY _ZTI6S209C3[];
extern  VTBL_ENTRY _ZTV6S209C3[];
Class_Descriptor cd_S209C3 = {  "S209C3", // class name
  bases_S209C3, 3,
  &(vtc_S209C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S209C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S209C3),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S209C2  : S209C3 {
  virtual  ~S209C2(); // _ZN6S209C2D1Ev
  virtual void  v114(); // _ZN6S209C24v114Ev
  virtual void  v115(); // _ZN6S209C24v115Ev
  S209C2(); // tgen
};
//SIG(-1 S209C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v109 v110 v111 v112 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2}


 S209C2 ::~S209C2(){ note_dtor("S209C2", this);}
void  S209C2 ::v114(){vfunc_called(this, "_ZN6S209C24v114Ev");}
void  S209C2 ::v115(){vfunc_called(this, "_ZN6S209C24v115Ev");}
S209C2 ::S209C2(){ note_ctor("S209C2", this);} // tgen

static void Test_S209C2()
{
  extern Class_Descriptor cd_S209C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S209C2, buf);
    S209C2 *dp, &lv = *(dp=new (buf) S209C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S209C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S209C2)");
    check_base_class_offset(lv, (S209C6*)(S209C5*)(S209C4*)(S209C3*), 0, "S209C2");
    check_base_class_offset(lv, (S209C5*)(S209C4*)(S209C3*), 0, "S209C2");
    check_base_class_offset(lv, (S209C4*)(S209C3*), 0, "S209C2");
    check_base_class_offset(lv, (S209C3*), 0, "S209C2");
    test_class_info(&lv, &cd_S209C2);
    dp->~S209C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS209C2(Test_S209C2, "S209C2", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S209C2C1Ev();
extern void _ZN6S209C2D1Ev();
Name_Map name_map_S209C2[] = {
  NSPAIR(_ZN6S209C2C1Ev),
  NSPAIR(_ZN6S209C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S209C6;
extern VTBL_ENTRY _ZTI6S209C6[];
extern  VTBL_ENTRY _ZTV6S209C6[];
extern Class_Descriptor cd_S209C5;
extern VTBL_ENTRY _ZTI6S209C5[];
extern  VTBL_ENTRY _ZTV6S209C5[];
extern Class_Descriptor cd_S209C4;
extern VTBL_ENTRY _ZTI6S209C4[];
extern  VTBL_ENTRY _ZTV6S209C4[];
extern Class_Descriptor cd_S209C3;
extern VTBL_ENTRY _ZTI6S209C3[];
extern  VTBL_ENTRY _ZTV6S209C3[];
static Base_Class bases_S209C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S209C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S209C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S209C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S209C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S209C2[];
extern void _ZN6S209C2D1Ev();
extern void _ZN6S209C2D0Ev();
extern void _ZN6S209C62v4Ev();
extern void _ZN6S209C62v5Ev();
extern void _ZN6S209C62v6Ev();
extern void _ZN6S209C62v7Ev();
extern void _ZN6S209C62v8Ev();
extern void _ZN6S209C62v9Ev();
extern void _ZN6S209C63v10Ev();
extern void _ZN6S209C63v11Ev();
extern void _ZN6S209C63v12Ev();
extern void _ZN6S209C63v13Ev();
extern void _ZN6S209C63v14Ev();
extern void _ZN6S209C63v15Ev();
extern void _ZN6S209C63v16Ev();
extern void _ZN6S209C63v17Ev();
extern void _ZN6S209C63v18Ev();
extern void _ZN6S209C63v19Ev();
extern void _ZN6S209C63v20Ev();
extern void _ZN6S209C63v21Ev();
extern void _ZN6S209C63v22Ev();
extern void _ZN6S209C63v23Ev();
extern void _ZN6S209C63v24Ev();
extern void _ZN6S209C63v25Ev();
extern void _ZN6S209C63v26Ev();
extern void _ZN6S209C63v27Ev();
extern void _ZN6S209C63v28Ev();
extern void _ZN6S209C63v29Ev();
extern void _ZN6S209C63v30Ev();
extern void _ZN6S209C63v31Ev();
extern void _ZN6S209C63v32Ev();
extern void _ZN6S209C63v33Ev();
extern void _ZN6S209C63v34Ev();
extern void _ZN6S209C63v35Ev();
extern void _ZN6S209C63v36Ev();
extern void _ZN6S209C63v37Ev();
extern void _ZN6S209C63v38Ev();
extern void _ZN6S209C63v39Ev();
extern void _ZN6S209C63v40Ev();
extern void _ZN6S209C63v41Ev();
extern void _ZN6S209C63v42Ev();
extern void _ZN6S209C63v43Ev();
extern void _ZN6S209C63v44Ev();
extern void _ZN6S209C63v45Ev();
extern void _ZN6S209C63v46Ev();
extern void _ZN6S209C63v47Ev();
extern void _ZN6S209C63v48Ev();
extern void _ZN6S209C63v49Ev();
extern void _ZN6S209C63v50Ev();
extern void _ZN6S209C63v51Ev();
extern void _ZN6S209C63v52Ev();
extern void _ZN6S209C63v53Ev();
extern void _ZN6S209C63v54Ev();
extern void _ZN6S209C63v55Ev();
extern void _ZN6S209C63v56Ev();
extern void _ZN6S209C63v57Ev();
extern void _ZN6S209C63v58Ev();
extern void _ZN6S209C63v59Ev();
extern void _ZN6S209C63v60Ev();
extern void _ZN6S209C63v61Ev();
extern void _ZN6S209C63v62Ev();
extern void _ZN6S209C63v63Ev();
extern void _ZN6S209C63v64Ev();
extern void _ZN6S209C63v65Ev();
extern void _ZN6S209C63v66Ev();
extern void _ZN6S209C63v67Ev();
extern void _ZN6S209C53v68Ev();
extern void _ZN6S209C53v69Ev();
extern void _ZN6S209C53v70Ev();
extern void _ZN6S209C53v71Ev();
extern void _ZN6S209C53v72Ev();
extern void _ZN6S209C53v73Ev();
extern void _ZN6S209C53v74Ev();
extern void _ZN6S209C53v75Ev();
extern void _ZN6S209C53v76Ev();
extern void _ZN6S209C53v77Ev();
extern void _ZN6S209C53v78Ev();
extern void _ZN6S209C53v79Ev();
extern void _ZN6S209C53v80Ev();
extern void _ZN6S209C53v81Ev();
extern void _ZN6S209C53v82Ev();
extern void _ZN6S209C53v83Ev();
extern void _ZN6S209C53v84Ev();
extern void _ZN6S209C53v85Ev();
extern void _ZN6S209C53v86Ev();
extern void _ZN6S209C53v87Ev();
extern void _ZN6S209C53v88Ev();
extern void _ZN6S209C53v89Ev();
extern void _ZN6S209C43v90Ev();
extern void _ZN6S209C43v91Ev();
extern void _ZN6S209C43v92Ev();
extern void _ZN6S209C43v93Ev();
extern void _ZN6S209C43v94Ev();
extern void _ZN6S209C43v95Ev();
extern void _ZN6S209C43v96Ev();
extern void _ZN6S209C43v97Ev();
extern void _ZN6S209C43v98Ev();
extern void _ZN6S209C43v99Ev();
extern void _ZN6S209C44v100Ev();
extern void _ZN6S209C44v101Ev();
extern void _ZN6S209C44v102Ev();
extern void _ZN6S209C44v103Ev();
extern void _ZN6S209C44v104Ev();
extern void _ZN6S209C44v105Ev();
extern void _ZN6S209C44v106Ev();
extern void _ZN6S209C44v107Ev();
extern void _ZN6S209C44v108Ev();
extern void _ZN6S209C44v109Ev();
extern void _ZN6S209C34v110Ev();
extern void _ZN6S209C34v111Ev();
extern void _ZN6S209C34v112Ev();
extern void _ZN6S209C34v113Ev();
extern void _ZN6S209C24v114Ev();
extern void _ZN6S209C24v115Ev();
static  VTBL_ENTRY vtc_S209C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S209C2[0]),
  (VTBL_ENTRY)&_ZN6S209C2D1Ev,
  (VTBL_ENTRY)&_ZN6S209C2D0Ev,
  (VTBL_ENTRY)&_ZN6S209C62v4Ev,
  (VTBL_ENTRY)&_ZN6S209C62v5Ev,
  (VTBL_ENTRY)&_ZN6S209C62v6Ev,
  (VTBL_ENTRY)&_ZN6S209C62v7Ev,
  (VTBL_ENTRY)&_ZN6S209C62v8Ev,
  (VTBL_ENTRY)&_ZN6S209C62v9Ev,
  (VTBL_ENTRY)&_ZN6S209C63v10Ev,
  (VTBL_ENTRY)&_ZN6S209C63v11Ev,
  (VTBL_ENTRY)&_ZN6S209C63v12Ev,
  (VTBL_ENTRY)&_ZN6S209C63v13Ev,
  (VTBL_ENTRY)&_ZN6S209C63v14Ev,
  (VTBL_ENTRY)&_ZN6S209C63v15Ev,
  (VTBL_ENTRY)&_ZN6S209C63v16Ev,
  (VTBL_ENTRY)&_ZN6S209C63v17Ev,
  (VTBL_ENTRY)&_ZN6S209C63v18Ev,
  (VTBL_ENTRY)&_ZN6S209C63v19Ev,
  (VTBL_ENTRY)&_ZN6S209C63v20Ev,
  (VTBL_ENTRY)&_ZN6S209C63v21Ev,
  (VTBL_ENTRY)&_ZN6S209C63v22Ev,
  (VTBL_ENTRY)&_ZN6S209C63v23Ev,
  (VTBL_ENTRY)&_ZN6S209C63v24Ev,
  (VTBL_ENTRY)&_ZN6S209C63v25Ev,
  (VTBL_ENTRY)&_ZN6S209C63v26Ev,
  (VTBL_ENTRY)&_ZN6S209C63v27Ev,
  (VTBL_ENTRY)&_ZN6S209C63v28Ev,
  (VTBL_ENTRY)&_ZN6S209C63v29Ev,
  (VTBL_ENTRY)&_ZN6S209C63v30Ev,
  (VTBL_ENTRY)&_ZN6S209C63v31Ev,
  (VTBL_ENTRY)&_ZN6S209C63v32Ev,
  (VTBL_ENTRY)&_ZN6S209C63v33Ev,
  (VTBL_ENTRY)&_ZN6S209C63v34Ev,
  (VTBL_ENTRY)&_ZN6S209C63v35Ev,
  (VTBL_ENTRY)&_ZN6S209C63v36Ev,
  (VTBL_ENTRY)&_ZN6S209C63v37Ev,
  (VTBL_ENTRY)&_ZN6S209C63v38Ev,
  (VTBL_ENTRY)&_ZN6S209C63v39Ev,
  (VTBL_ENTRY)&_ZN6S209C63v40Ev,
  (VTBL_ENTRY)&_ZN6S209C63v41Ev,
  (VTBL_ENTRY)&_ZN6S209C63v42Ev,
  (VTBL_ENTRY)&_ZN6S209C63v43Ev,
  (VTBL_ENTRY)&_ZN6S209C63v44Ev,
  (VTBL_ENTRY)&_ZN6S209C63v45Ev,
  (VTBL_ENTRY)&_ZN6S209C63v46Ev,
  (VTBL_ENTRY)&_ZN6S209C63v47Ev,
  (VTBL_ENTRY)&_ZN6S209C63v48Ev,
  (VTBL_ENTRY)&_ZN6S209C63v49Ev,
  (VTBL_ENTRY)&_ZN6S209C63v50Ev,
  (VTBL_ENTRY)&_ZN6S209C63v51Ev,
  (VTBL_ENTRY)&_ZN6S209C63v52Ev,
  (VTBL_ENTRY)&_ZN6S209C63v53Ev,
  (VTBL_ENTRY)&_ZN6S209C63v54Ev,
  (VTBL_ENTRY)&_ZN6S209C63v55Ev,
  (VTBL_ENTRY)&_ZN6S209C63v56Ev,
  (VTBL_ENTRY)&_ZN6S209C63v57Ev,
  (VTBL_ENTRY)&_ZN6S209C63v58Ev,
  (VTBL_ENTRY)&_ZN6S209C63v59Ev,
  (VTBL_ENTRY)&_ZN6S209C63v60Ev,
  (VTBL_ENTRY)&_ZN6S209C63v61Ev,
  (VTBL_ENTRY)&_ZN6S209C63v62Ev,
  (VTBL_ENTRY)&_ZN6S209C63v63Ev,
  (VTBL_ENTRY)&_ZN6S209C63v64Ev,
  (VTBL_ENTRY)&_ZN6S209C63v65Ev,
  (VTBL_ENTRY)&_ZN6S209C63v66Ev,
  (VTBL_ENTRY)&_ZN6S209C63v67Ev,
  (VTBL_ENTRY)&_ZN6S209C53v68Ev,
  (VTBL_ENTRY)&_ZN6S209C53v69Ev,
  (VTBL_ENTRY)&_ZN6S209C53v70Ev,
  (VTBL_ENTRY)&_ZN6S209C53v71Ev,
  (VTBL_ENTRY)&_ZN6S209C53v72Ev,
  (VTBL_ENTRY)&_ZN6S209C53v73Ev,
  (VTBL_ENTRY)&_ZN6S209C53v74Ev,
  (VTBL_ENTRY)&_ZN6S209C53v75Ev,
  (VTBL_ENTRY)&_ZN6S209C53v76Ev,
  (VTBL_ENTRY)&_ZN6S209C53v77Ev,
  (VTBL_ENTRY)&_ZN6S209C53v78Ev,
  (VTBL_ENTRY)&_ZN6S209C53v79Ev,
  (VTBL_ENTRY)&_ZN6S209C53v80Ev,
  (VTBL_ENTRY)&_ZN6S209C53v81Ev,
  (VTBL_ENTRY)&_ZN6S209C53v82Ev,
  (VTBL_ENTRY)&_ZN6S209C53v83Ev,
  (VTBL_ENTRY)&_ZN6S209C53v84Ev,
  (VTBL_ENTRY)&_ZN6S209C53v85Ev,
  (VTBL_ENTRY)&_ZN6S209C53v86Ev,
  (VTBL_ENTRY)&_ZN6S209C53v87Ev,
  (VTBL_ENTRY)&_ZN6S209C53v88Ev,
  (VTBL_ENTRY)&_ZN6S209C53v89Ev,
  (VTBL_ENTRY)&_ZN6S209C43v90Ev,
  (VTBL_ENTRY)&_ZN6S209C43v91Ev,
  (VTBL_ENTRY)&_ZN6S209C43v92Ev,
  (VTBL_ENTRY)&_ZN6S209C43v93Ev,
  (VTBL_ENTRY)&_ZN6S209C43v94Ev,
  (VTBL_ENTRY)&_ZN6S209C43v95Ev,
  (VTBL_ENTRY)&_ZN6S209C43v96Ev,
  (VTBL_ENTRY)&_ZN6S209C43v97Ev,
  (VTBL_ENTRY)&_ZN6S209C43v98Ev,
  (VTBL_ENTRY)&_ZN6S209C43v99Ev,
  (VTBL_ENTRY)&_ZN6S209C44v100Ev,
  (VTBL_ENTRY)&_ZN6S209C44v101Ev,
  (VTBL_ENTRY)&_ZN6S209C44v102Ev,
  (VTBL_ENTRY)&_ZN6S209C44v103Ev,
  (VTBL_ENTRY)&_ZN6S209C44v104Ev,
  (VTBL_ENTRY)&_ZN6S209C44v105Ev,
  (VTBL_ENTRY)&_ZN6S209C44v106Ev,
  (VTBL_ENTRY)&_ZN6S209C44v107Ev,
  (VTBL_ENTRY)&_ZN6S209C44v108Ev,
  (VTBL_ENTRY)&_ZN6S209C44v109Ev,
  (VTBL_ENTRY)&_ZN6S209C34v110Ev,
  (VTBL_ENTRY)&_ZN6S209C34v111Ev,
  (VTBL_ENTRY)&_ZN6S209C34v112Ev,
  (VTBL_ENTRY)&_ZN6S209C34v113Ev,
  (VTBL_ENTRY)&_ZN6S209C24v114Ev,
  (VTBL_ENTRY)&_ZN6S209C24v115Ev,
};
extern VTBL_ENTRY _ZTI6S209C2[];
extern  VTBL_ENTRY _ZTV6S209C2[];
Class_Descriptor cd_S209C2 = {  "S209C2", // class name
  bases_S209C2, 4,
  &(vtc_S209C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S209C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S209C2),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S209C1  : S209C2 {
  ::S210C8_nt s209c1f0;
  ::S210C8_nt s209c1f1;
  virtual  ~S209C1(); // _ZN6S209C1D1Ev
  virtual void  v1(); // _ZN6S209C12v1Ev
  virtual void  v2(); // _ZN6S209C12v2Ev
  virtual void  v3(); // _ZN6S209C12v3Ev
  S209C1(); // tgen
};
//SIG(1 S209C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v110 v111 v112 v113 FC7 Fi:1 FC21{ BC22{ BC11}}} vd v114 v115} vd v1 v2 v3 FC8 FC8}


 S209C1 ::~S209C1(){ note_dtor("S209C1", this);}
void  S209C1 ::v1(){vfunc_called(this, "_ZN6S209C12v1Ev");}
void  S209C1 ::v2(){vfunc_called(this, "_ZN6S209C12v2Ev");}
void  S209C1 ::v3(){vfunc_called(this, "_ZN6S209C12v3Ev");}
S209C1 ::S209C1(){ note_ctor("S209C1", this);} // tgen

static void Test_S209C1()
{
  extern Class_Descriptor cd_S209C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,62)];
    init_test(&cd_S209C1, buf);
    S209C1 *dp, &lv = *(dp=new (buf) S209C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,244), "sizeof(S209C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S209C1)");
    check_base_class_offset(lv, (S209C6*)(S209C5*)(S209C4*)(S209C3*)(S209C2*), 0, "S209C1");
    check_base_class_offset(lv, (S209C5*)(S209C4*)(S209C3*)(S209C2*), 0, "S209C1");
    check_base_class_offset(lv, (S209C4*)(S209C3*)(S209C2*), 0, "S209C1");
    check_base_class_offset(lv, (S209C3*)(S209C2*), 0, "S209C1");
    check_base_class_offset(lv, (S209C2*), 0, "S209C1");
    check_field_offset(lv, s209c1f0, ABISELECT(296,220), "S209C1.s209c1f0");
    check_field_offset(lv, s209c1f1, ABISELECT(312,232), "S209C1.s209c1f1");
    test_class_info(&lv, &cd_S209C1);
    dp->~S209C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS209C1(Test_S209C1, "S209C1", ABISELECT(328,244));

#else // __cplusplus

extern void _ZN6S209C1C1Ev();
extern void _ZN6S209C1D1Ev();
Name_Map name_map_S209C1[] = {
  NSPAIR(_ZN6S209C1C1Ev),
  NSPAIR(_ZN6S209C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S209C6;
extern VTBL_ENTRY _ZTI6S209C6[];
extern  VTBL_ENTRY _ZTV6S209C6[];
extern Class_Descriptor cd_S209C5;
extern VTBL_ENTRY _ZTI6S209C5[];
extern  VTBL_ENTRY _ZTV6S209C5[];
extern Class_Descriptor cd_S209C4;
extern VTBL_ENTRY _ZTI6S209C4[];
extern  VTBL_ENTRY _ZTV6S209C4[];
extern Class_Descriptor cd_S209C3;
extern VTBL_ENTRY _ZTI6S209C3[];
extern  VTBL_ENTRY _ZTV6S209C3[];
extern Class_Descriptor cd_S209C2;
extern VTBL_ENTRY _ZTI6S209C2[];
extern  VTBL_ENTRY _ZTV6S209C2[];
static Base_Class bases_S209C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S209C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S209C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S209C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S209C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S209C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S209C1[];
extern void _ZN6S209C1D1Ev();
extern void _ZN6S209C1D0Ev();
extern void _ZN6S209C62v4Ev();
extern void _ZN6S209C62v5Ev();
extern void _ZN6S209C62v6Ev();
extern void _ZN6S209C62v7Ev();
extern void _ZN6S209C62v8Ev();
extern void _ZN6S209C62v9Ev();
extern void _ZN6S209C63v10Ev();
extern void _ZN6S209C63v11Ev();
extern void _ZN6S209C63v12Ev();
extern void _ZN6S209C63v13Ev();
extern void _ZN6S209C63v14Ev();
extern void _ZN6S209C63v15Ev();
extern void _ZN6S209C63v16Ev();
extern void _ZN6S209C63v17Ev();
extern void _ZN6S209C63v18Ev();
extern void _ZN6S209C63v19Ev();
extern void _ZN6S209C63v20Ev();
extern void _ZN6S209C63v21Ev();
extern void _ZN6S209C63v22Ev();
extern void _ZN6S209C63v23Ev();
extern void _ZN6S209C63v24Ev();
extern void _ZN6S209C63v25Ev();
extern void _ZN6S209C63v26Ev();
extern void _ZN6S209C63v27Ev();
extern void _ZN6S209C63v28Ev();
extern void _ZN6S209C63v29Ev();
extern void _ZN6S209C63v30Ev();
extern void _ZN6S209C63v31Ev();
extern void _ZN6S209C63v32Ev();
extern void _ZN6S209C63v33Ev();
extern void _ZN6S209C63v34Ev();
extern void _ZN6S209C63v35Ev();
extern void _ZN6S209C63v36Ev();
extern void _ZN6S209C63v37Ev();
extern void _ZN6S209C63v38Ev();
extern void _ZN6S209C63v39Ev();
extern void _ZN6S209C63v40Ev();
extern void _ZN6S209C63v41Ev();
extern void _ZN6S209C63v42Ev();
extern void _ZN6S209C63v43Ev();
extern void _ZN6S209C63v44Ev();
extern void _ZN6S209C63v45Ev();
extern void _ZN6S209C63v46Ev();
extern void _ZN6S209C63v47Ev();
extern void _ZN6S209C63v48Ev();
extern void _ZN6S209C63v49Ev();
extern void _ZN6S209C63v50Ev();
extern void _ZN6S209C63v51Ev();
extern void _ZN6S209C63v52Ev();
extern void _ZN6S209C63v53Ev();
extern void _ZN6S209C63v54Ev();
extern void _ZN6S209C63v55Ev();
extern void _ZN6S209C63v56Ev();
extern void _ZN6S209C63v57Ev();
extern void _ZN6S209C63v58Ev();
extern void _ZN6S209C63v59Ev();
extern void _ZN6S209C63v60Ev();
extern void _ZN6S209C63v61Ev();
extern void _ZN6S209C63v62Ev();
extern void _ZN6S209C63v63Ev();
extern void _ZN6S209C63v64Ev();
extern void _ZN6S209C63v65Ev();
extern void _ZN6S209C63v66Ev();
extern void _ZN6S209C63v67Ev();
extern void _ZN6S209C53v68Ev();
extern void _ZN6S209C53v69Ev();
extern void _ZN6S209C53v70Ev();
extern void _ZN6S209C53v71Ev();
extern void _ZN6S209C53v72Ev();
extern void _ZN6S209C53v73Ev();
extern void _ZN6S209C53v74Ev();
extern void _ZN6S209C53v75Ev();
extern void _ZN6S209C53v76Ev();
extern void _ZN6S209C53v77Ev();
extern void _ZN6S209C53v78Ev();
extern void _ZN6S209C53v79Ev();
extern void _ZN6S209C53v80Ev();
extern void _ZN6S209C53v81Ev();
extern void _ZN6S209C53v82Ev();
extern void _ZN6S209C53v83Ev();
extern void _ZN6S209C53v84Ev();
extern void _ZN6S209C53v85Ev();
extern void _ZN6S209C53v86Ev();
extern void _ZN6S209C53v87Ev();
extern void _ZN6S209C53v88Ev();
extern void _ZN6S209C53v89Ev();
extern void _ZN6S209C43v90Ev();
extern void _ZN6S209C43v91Ev();
extern void _ZN6S209C43v92Ev();
extern void _ZN6S209C43v93Ev();
extern void _ZN6S209C43v94Ev();
extern void _ZN6S209C43v95Ev();
extern void _ZN6S209C43v96Ev();
extern void _ZN6S209C43v97Ev();
extern void _ZN6S209C43v98Ev();
extern void _ZN6S209C43v99Ev();
extern void _ZN6S209C44v100Ev();
extern void _ZN6S209C44v101Ev();
extern void _ZN6S209C44v102Ev();
extern void _ZN6S209C44v103Ev();
extern void _ZN6S209C44v104Ev();
extern void _ZN6S209C44v105Ev();
extern void _ZN6S209C44v106Ev();
extern void _ZN6S209C44v107Ev();
extern void _ZN6S209C44v108Ev();
extern void _ZN6S209C44v109Ev();
extern void _ZN6S209C34v110Ev();
extern void _ZN6S209C34v111Ev();
extern void _ZN6S209C34v112Ev();
extern void _ZN6S209C34v113Ev();
extern void _ZN6S209C24v114Ev();
extern void _ZN6S209C24v115Ev();
extern void _ZN6S209C12v1Ev();
extern void _ZN6S209C12v2Ev();
extern void _ZN6S209C12v3Ev();
static  VTBL_ENTRY vtc_S209C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S209C1[0]),
  (VTBL_ENTRY)&_ZN6S209C1D1Ev,
  (VTBL_ENTRY)&_ZN6S209C1D0Ev,
  (VTBL_ENTRY)&_ZN6S209C62v4Ev,
  (VTBL_ENTRY)&_ZN6S209C62v5Ev,
  (VTBL_ENTRY)&_ZN6S209C62v6Ev,
  (VTBL_ENTRY)&_ZN6S209C62v7Ev,
  (VTBL_ENTRY)&_ZN6S209C62v8Ev,
  (VTBL_ENTRY)&_ZN6S209C62v9Ev,
  (VTBL_ENTRY)&_ZN6S209C63v10Ev,
  (VTBL_ENTRY)&_ZN6S209C63v11Ev,
  (VTBL_ENTRY)&_ZN6S209C63v12Ev,
  (VTBL_ENTRY)&_ZN6S209C63v13Ev,
  (VTBL_ENTRY)&_ZN6S209C63v14Ev,
  (VTBL_ENTRY)&_ZN6S209C63v15Ev,
  (VTBL_ENTRY)&_ZN6S209C63v16Ev,
  (VTBL_ENTRY)&_ZN6S209C63v17Ev,
  (VTBL_ENTRY)&_ZN6S209C63v18Ev,
  (VTBL_ENTRY)&_ZN6S209C63v19Ev,
  (VTBL_ENTRY)&_ZN6S209C63v20Ev,
  (VTBL_ENTRY)&_ZN6S209C63v21Ev,
  (VTBL_ENTRY)&_ZN6S209C63v22Ev,
  (VTBL_ENTRY)&_ZN6S209C63v23Ev,
  (VTBL_ENTRY)&_ZN6S209C63v24Ev,
  (VTBL_ENTRY)&_ZN6S209C63v25Ev,
  (VTBL_ENTRY)&_ZN6S209C63v26Ev,
  (VTBL_ENTRY)&_ZN6S209C63v27Ev,
  (VTBL_ENTRY)&_ZN6S209C63v28Ev,
  (VTBL_ENTRY)&_ZN6S209C63v29Ev,
  (VTBL_ENTRY)&_ZN6S209C63v30Ev,
  (VTBL_ENTRY)&_ZN6S209C63v31Ev,
  (VTBL_ENTRY)&_ZN6S209C63v32Ev,
  (VTBL_ENTRY)&_ZN6S209C63v33Ev,
  (VTBL_ENTRY)&_ZN6S209C63v34Ev,
  (VTBL_ENTRY)&_ZN6S209C63v35Ev,
  (VTBL_ENTRY)&_ZN6S209C63v36Ev,
  (VTBL_ENTRY)&_ZN6S209C63v37Ev,
  (VTBL_ENTRY)&_ZN6S209C63v38Ev,
  (VTBL_ENTRY)&_ZN6S209C63v39Ev,
  (VTBL_ENTRY)&_ZN6S209C63v40Ev,
  (VTBL_ENTRY)&_ZN6S209C63v41Ev,
  (VTBL_ENTRY)&_ZN6S209C63v42Ev,
  (VTBL_ENTRY)&_ZN6S209C63v43Ev,
  (VTBL_ENTRY)&_ZN6S209C63v44Ev,
  (VTBL_ENTRY)&_ZN6S209C63v45Ev,
  (VTBL_ENTRY)&_ZN6S209C63v46Ev,
  (VTBL_ENTRY)&_ZN6S209C63v47Ev,
  (VTBL_ENTRY)&_ZN6S209C63v48Ev,
  (VTBL_ENTRY)&_ZN6S209C63v49Ev,
  (VTBL_ENTRY)&_ZN6S209C63v50Ev,
  (VTBL_ENTRY)&_ZN6S209C63v51Ev,
  (VTBL_ENTRY)&_ZN6S209C63v52Ev,
  (VTBL_ENTRY)&_ZN6S209C63v53Ev,
  (VTBL_ENTRY)&_ZN6S209C63v54Ev,
  (VTBL_ENTRY)&_ZN6S209C63v55Ev,
  (VTBL_ENTRY)&_ZN6S209C63v56Ev,
  (VTBL_ENTRY)&_ZN6S209C63v57Ev,
  (VTBL_ENTRY)&_ZN6S209C63v58Ev,
  (VTBL_ENTRY)&_ZN6S209C63v59Ev,
  (VTBL_ENTRY)&_ZN6S209C63v60Ev,
  (VTBL_ENTRY)&_ZN6S209C63v61Ev,
  (VTBL_ENTRY)&_ZN6S209C63v62Ev,
  (VTBL_ENTRY)&_ZN6S209C63v63Ev,
  (VTBL_ENTRY)&_ZN6S209C63v64Ev,
  (VTBL_ENTRY)&_ZN6S209C63v65Ev,
  (VTBL_ENTRY)&_ZN6S209C63v66Ev,
  (VTBL_ENTRY)&_ZN6S209C63v67Ev,
  (VTBL_ENTRY)&_ZN6S209C53v68Ev,
  (VTBL_ENTRY)&_ZN6S209C53v69Ev,
  (VTBL_ENTRY)&_ZN6S209C53v70Ev,
  (VTBL_ENTRY)&_ZN6S209C53v71Ev,
  (VTBL_ENTRY)&_ZN6S209C53v72Ev,
  (VTBL_ENTRY)&_ZN6S209C53v73Ev,
  (VTBL_ENTRY)&_ZN6S209C53v74Ev,
  (VTBL_ENTRY)&_ZN6S209C53v75Ev,
  (VTBL_ENTRY)&_ZN6S209C53v76Ev,
  (VTBL_ENTRY)&_ZN6S209C53v77Ev,
  (VTBL_ENTRY)&_ZN6S209C53v78Ev,
  (VTBL_ENTRY)&_ZN6S209C53v79Ev,
  (VTBL_ENTRY)&_ZN6S209C53v80Ev,
  (VTBL_ENTRY)&_ZN6S209C53v81Ev,
  (VTBL_ENTRY)&_ZN6S209C53v82Ev,
  (VTBL_ENTRY)&_ZN6S209C53v83Ev,
  (VTBL_ENTRY)&_ZN6S209C53v84Ev,
  (VTBL_ENTRY)&_ZN6S209C53v85Ev,
  (VTBL_ENTRY)&_ZN6S209C53v86Ev,
  (VTBL_ENTRY)&_ZN6S209C53v87Ev,
  (VTBL_ENTRY)&_ZN6S209C53v88Ev,
  (VTBL_ENTRY)&_ZN6S209C53v89Ev,
  (VTBL_ENTRY)&_ZN6S209C43v90Ev,
  (VTBL_ENTRY)&_ZN6S209C43v91Ev,
  (VTBL_ENTRY)&_ZN6S209C43v92Ev,
  (VTBL_ENTRY)&_ZN6S209C43v93Ev,
  (VTBL_ENTRY)&_ZN6S209C43v94Ev,
  (VTBL_ENTRY)&_ZN6S209C43v95Ev,
  (VTBL_ENTRY)&_ZN6S209C43v96Ev,
  (VTBL_ENTRY)&_ZN6S209C43v97Ev,
  (VTBL_ENTRY)&_ZN6S209C43v98Ev,
  (VTBL_ENTRY)&_ZN6S209C43v99Ev,
  (VTBL_ENTRY)&_ZN6S209C44v100Ev,
  (VTBL_ENTRY)&_ZN6S209C44v101Ev,
  (VTBL_ENTRY)&_ZN6S209C44v102Ev,
  (VTBL_ENTRY)&_ZN6S209C44v103Ev,
  (VTBL_ENTRY)&_ZN6S209C44v104Ev,
  (VTBL_ENTRY)&_ZN6S209C44v105Ev,
  (VTBL_ENTRY)&_ZN6S209C44v106Ev,
  (VTBL_ENTRY)&_ZN6S209C44v107Ev,
  (VTBL_ENTRY)&_ZN6S209C44v108Ev,
  (VTBL_ENTRY)&_ZN6S209C44v109Ev,
  (VTBL_ENTRY)&_ZN6S209C34v110Ev,
  (VTBL_ENTRY)&_ZN6S209C34v111Ev,
  (VTBL_ENTRY)&_ZN6S209C34v112Ev,
  (VTBL_ENTRY)&_ZN6S209C34v113Ev,
  (VTBL_ENTRY)&_ZN6S209C24v114Ev,
  (VTBL_ENTRY)&_ZN6S209C24v115Ev,
  (VTBL_ENTRY)&_ZN6S209C12v1Ev,
  (VTBL_ENTRY)&_ZN6S209C12v2Ev,
  (VTBL_ENTRY)&_ZN6S209C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S209C1[];
extern  VTBL_ENTRY _ZTV6S209C1[];
Class_Descriptor cd_S209C1 = {  "S209C1", // class name
  bases_S209C1, 5,
  &(vtc_S209C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(328,244), // object size
  NSPAIRA(_ZTI6S209C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S209C1),119, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S247C6  {
  int s247c6f0;
  __tsi64 s247c6f1;
  void *s247c6f2[4];
  int s247c6f3[2];
  void *s247c6f4;
  ::S1503C5_nt s247c6f5;
  void *s247c6f6[2];
  virtual  ~S247C6(); // _ZN6S247C6D1Ev
  virtual void  v5(); // _ZN6S247C62v5Ev
  virtual void  v6(); // _ZN6S247C62v6Ev
  virtual void  v7(); // _ZN6S247C62v7Ev
  virtual void  v8(); // _ZN6S247C62v8Ev
  virtual void  v9(); // _ZN6S247C62v9Ev
  virtual void  v10(); // _ZN6S247C63v10Ev
  virtual void  v11(); // _ZN6S247C63v11Ev
  virtual void  v12(); // _ZN6S247C63v12Ev
  virtual void  v13(); // _ZN6S247C63v13Ev
  virtual void  v14(); // _ZN6S247C63v14Ev
  virtual void  v15(); // _ZN6S247C63v15Ev
  virtual void  v16(); // _ZN6S247C63v16Ev
  virtual void  v17(); // _ZN6S247C63v17Ev
  virtual void  v18(); // _ZN6S247C63v18Ev
  virtual void  v19(); // _ZN6S247C63v19Ev
  virtual void  v20(); // _ZN6S247C63v20Ev
  virtual void  v21(); // _ZN6S247C63v21Ev
  virtual void  v22(); // _ZN6S247C63v22Ev
  virtual void  v23(); // _ZN6S247C63v23Ev
  virtual void  v24(); // _ZN6S247C63v24Ev
  virtual void  v25(); // _ZN6S247C63v25Ev
  virtual void  v26(); // _ZN6S247C63v26Ev
  virtual void  v27(); // _ZN6S247C63v27Ev
  virtual void  v28(); // _ZN6S247C63v28Ev
  virtual void  v29(); // _ZN6S247C63v29Ev
  virtual void  v30(); // _ZN6S247C63v30Ev
  virtual void  v31(); // _ZN6S247C63v31Ev
  virtual void  v32(); // _ZN6S247C63v32Ev
  virtual void  v33(); // _ZN6S247C63v33Ev
  virtual void  v34(); // _ZN6S247C63v34Ev
  virtual void  v35(); // _ZN6S247C63v35Ev
  virtual void  v36(); // _ZN6S247C63v36Ev
  virtual void  v37(); // _ZN6S247C63v37Ev
  virtual void  v38(); // _ZN6S247C63v38Ev
  virtual void  v39(); // _ZN6S247C63v39Ev
  virtual void  v40(); // _ZN6S247C63v40Ev
  virtual void  v41(); // _ZN6S247C63v41Ev
  virtual void  v42(); // _ZN6S247C63v42Ev
  virtual void  v43(); // _ZN6S247C63v43Ev
  virtual void  v44(); // _ZN6S247C63v44Ev
  virtual void  v45(); // _ZN6S247C63v45Ev
  virtual void  v46(); // _ZN6S247C63v46Ev
  virtual void  v47(); // _ZN6S247C63v47Ev
  virtual void  v48(); // _ZN6S247C63v48Ev
  virtual void  v49(); // _ZN6S247C63v49Ev
  virtual void  v50(); // _ZN6S247C63v50Ev
  virtual void  v51(); // _ZN6S247C63v51Ev
  virtual void  v52(); // _ZN6S247C63v52Ev
  virtual void  v53(); // _ZN6S247C63v53Ev
  virtual void  v54(); // _ZN6S247C63v54Ev
  virtual void  v55(); // _ZN6S247C63v55Ev
  virtual void  v56(); // _ZN6S247C63v56Ev
  virtual void  v57(); // _ZN6S247C63v57Ev
  virtual void  v58(); // _ZN6S247C63v58Ev
  virtual void  v59(); // _ZN6S247C63v59Ev
  virtual void  v60(); // _ZN6S247C63v60Ev
  virtual void  v61(); // _ZN6S247C63v61Ev
  virtual void  v62(); // _ZN6S247C63v62Ev
  virtual void  v63(); // _ZN6S247C63v63Ev
  virtual void  v64(); // _ZN6S247C63v64Ev
  virtual void  v65(); // _ZN6S247C63v65Ev
  virtual void  v66(); // _ZN6S247C63v66Ev
  virtual void  v67(); // _ZN6S247C63v67Ev
  virtual void  v68(); // _ZN6S247C63v68Ev
  S247C6(); // tgen
};
//SIG(-1 S247C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S247C6 ::~S247C6(){ note_dtor("S247C6", this);}
void  S247C6 ::v5(){vfunc_called(this, "_ZN6S247C62v5Ev");}
void  S247C6 ::v6(){vfunc_called(this, "_ZN6S247C62v6Ev");}
void  S247C6 ::v7(){vfunc_called(this, "_ZN6S247C62v7Ev");}
void  S247C6 ::v8(){vfunc_called(this, "_ZN6S247C62v8Ev");}
void  S247C6 ::v9(){vfunc_called(this, "_ZN6S247C62v9Ev");}
void  S247C6 ::v10(){vfunc_called(this, "_ZN6S247C63v10Ev");}
void  S247C6 ::v11(){vfunc_called(this, "_ZN6S247C63v11Ev");}
void  S247C6 ::v12(){vfunc_called(this, "_ZN6S247C63v12Ev");}
void  S247C6 ::v13(){vfunc_called(this, "_ZN6S247C63v13Ev");}
void  S247C6 ::v14(){vfunc_called(this, "_ZN6S247C63v14Ev");}
void  S247C6 ::v15(){vfunc_called(this, "_ZN6S247C63v15Ev");}
void  S247C6 ::v16(){vfunc_called(this, "_ZN6S247C63v16Ev");}
void  S247C6 ::v17(){vfunc_called(this, "_ZN6S247C63v17Ev");}
void  S247C6 ::v18(){vfunc_called(this, "_ZN6S247C63v18Ev");}
void  S247C6 ::v19(){vfunc_called(this, "_ZN6S247C63v19Ev");}
void  S247C6 ::v20(){vfunc_called(this, "_ZN6S247C63v20Ev");}
void  S247C6 ::v21(){vfunc_called(this, "_ZN6S247C63v21Ev");}
void  S247C6 ::v22(){vfunc_called(this, "_ZN6S247C63v22Ev");}
void  S247C6 ::v23(){vfunc_called(this, "_ZN6S247C63v23Ev");}
void  S247C6 ::v24(){vfunc_called(this, "_ZN6S247C63v24Ev");}
void  S247C6 ::v25(){vfunc_called(this, "_ZN6S247C63v25Ev");}
void  S247C6 ::v26(){vfunc_called(this, "_ZN6S247C63v26Ev");}
void  S247C6 ::v27(){vfunc_called(this, "_ZN6S247C63v27Ev");}
void  S247C6 ::v28(){vfunc_called(this, "_ZN6S247C63v28Ev");}
void  S247C6 ::v29(){vfunc_called(this, "_ZN6S247C63v29Ev");}
void  S247C6 ::v30(){vfunc_called(this, "_ZN6S247C63v30Ev");}
void  S247C6 ::v31(){vfunc_called(this, "_ZN6S247C63v31Ev");}
void  S247C6 ::v32(){vfunc_called(this, "_ZN6S247C63v32Ev");}
void  S247C6 ::v33(){vfunc_called(this, "_ZN6S247C63v33Ev");}
void  S247C6 ::v34(){vfunc_called(this, "_ZN6S247C63v34Ev");}
void  S247C6 ::v35(){vfunc_called(this, "_ZN6S247C63v35Ev");}
void  S247C6 ::v36(){vfunc_called(this, "_ZN6S247C63v36Ev");}
void  S247C6 ::v37(){vfunc_called(this, "_ZN6S247C63v37Ev");}
void  S247C6 ::v38(){vfunc_called(this, "_ZN6S247C63v38Ev");}
void  S247C6 ::v39(){vfunc_called(this, "_ZN6S247C63v39Ev");}
void  S247C6 ::v40(){vfunc_called(this, "_ZN6S247C63v40Ev");}
void  S247C6 ::v41(){vfunc_called(this, "_ZN6S247C63v41Ev");}
void  S247C6 ::v42(){vfunc_called(this, "_ZN6S247C63v42Ev");}
void  S247C6 ::v43(){vfunc_called(this, "_ZN6S247C63v43Ev");}
void  S247C6 ::v44(){vfunc_called(this, "_ZN6S247C63v44Ev");}
void  S247C6 ::v45(){vfunc_called(this, "_ZN6S247C63v45Ev");}
void  S247C6 ::v46(){vfunc_called(this, "_ZN6S247C63v46Ev");}
void  S247C6 ::v47(){vfunc_called(this, "_ZN6S247C63v47Ev");}
void  S247C6 ::v48(){vfunc_called(this, "_ZN6S247C63v48Ev");}
void  S247C6 ::v49(){vfunc_called(this, "_ZN6S247C63v49Ev");}
void  S247C6 ::v50(){vfunc_called(this, "_ZN6S247C63v50Ev");}
void  S247C6 ::v51(){vfunc_called(this, "_ZN6S247C63v51Ev");}
void  S247C6 ::v52(){vfunc_called(this, "_ZN6S247C63v52Ev");}
void  S247C6 ::v53(){vfunc_called(this, "_ZN6S247C63v53Ev");}
void  S247C6 ::v54(){vfunc_called(this, "_ZN6S247C63v54Ev");}
void  S247C6 ::v55(){vfunc_called(this, "_ZN6S247C63v55Ev");}
void  S247C6 ::v56(){vfunc_called(this, "_ZN6S247C63v56Ev");}
void  S247C6 ::v57(){vfunc_called(this, "_ZN6S247C63v57Ev");}
void  S247C6 ::v58(){vfunc_called(this, "_ZN6S247C63v58Ev");}
void  S247C6 ::v59(){vfunc_called(this, "_ZN6S247C63v59Ev");}
void  S247C6 ::v60(){vfunc_called(this, "_ZN6S247C63v60Ev");}
void  S247C6 ::v61(){vfunc_called(this, "_ZN6S247C63v61Ev");}
void  S247C6 ::v62(){vfunc_called(this, "_ZN6S247C63v62Ev");}
void  S247C6 ::v63(){vfunc_called(this, "_ZN6S247C63v63Ev");}
void  S247C6 ::v64(){vfunc_called(this, "_ZN6S247C63v64Ev");}
void  S247C6 ::v65(){vfunc_called(this, "_ZN6S247C63v65Ev");}
void  S247C6 ::v66(){vfunc_called(this, "_ZN6S247C63v66Ev");}
void  S247C6 ::v67(){vfunc_called(this, "_ZN6S247C63v67Ev");}
void  S247C6 ::v68(){vfunc_called(this, "_ZN6S247C63v68Ev");}
S247C6 ::S247C6(){ note_ctor("S247C6", this);} // tgen

static void Test_S247C6()
{
  extern Class_Descriptor cd_S247C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S247C6, buf);
    S247C6 *dp, &lv = *(dp=new (buf) S247C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S247C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S247C6)");
    check_field_offset(lv, s247c6f0, ABISELECT(8,4), "S247C6.s247c6f0");
    check_field_offset(lv, s247c6f1, ABISELECT(16,8), "S247C6.s247c6f1");
    check_field_offset(lv, s247c6f2, ABISELECT(24,16), "S247C6.s247c6f2");
    check_field_offset(lv, s247c6f3, ABISELECT(56,32), "S247C6.s247c6f3");
    check_field_offset(lv, s247c6f4, ABISELECT(64,40), "S247C6.s247c6f4");
    check_field_offset(lv, s247c6f5, ABISELECT(72,44), "S247C6.s247c6f5");
    check_field_offset(lv, s247c6f6, ABISELECT(80,52), "S247C6.s247c6f6");
    test_class_info(&lv, &cd_S247C6);
    dp->~S247C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS247C6(Test_S247C6, "S247C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S247C6C1Ev();
extern void _ZN6S247C6D1Ev();
Name_Map name_map_S247C6[] = {
  NSPAIR(_ZN6S247C6C1Ev),
  NSPAIR(_ZN6S247C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S247C6[];
extern void _ZN6S247C6D1Ev();
extern void _ZN6S247C6D0Ev();
extern void _ZN6S247C62v5Ev();
extern void _ZN6S247C62v6Ev();
extern void _ZN6S247C62v7Ev();
extern void _ZN6S247C62v8Ev();
extern void _ZN6S247C62v9Ev();
extern void _ZN6S247C63v10Ev();
extern void _ZN6S247C63v11Ev();
extern void _ZN6S247C63v12Ev();
extern void _ZN6S247C63v13Ev();
extern void _ZN6S247C63v14Ev();
extern void _ZN6S247C63v15Ev();
extern void _ZN6S247C63v16Ev();
extern void _ZN6S247C63v17Ev();
extern void _ZN6S247C63v18Ev();
extern void _ZN6S247C63v19Ev();
extern void _ZN6S247C63v20Ev();
extern void _ZN6S247C63v21Ev();
extern void _ZN6S247C63v22Ev();
extern void _ZN6S247C63v23Ev();
extern void _ZN6S247C63v24Ev();
extern void _ZN6S247C63v25Ev();
extern void _ZN6S247C63v26Ev();
extern void _ZN6S247C63v27Ev();
extern void _ZN6S247C63v28Ev();
extern void _ZN6S247C63v29Ev();
extern void _ZN6S247C63v30Ev();
extern void _ZN6S247C63v31Ev();
extern void _ZN6S247C63v32Ev();
extern void _ZN6S247C63v33Ev();
extern void _ZN6S247C63v34Ev();
extern void _ZN6S247C63v35Ev();
extern void _ZN6S247C63v36Ev();
extern void _ZN6S247C63v37Ev();
extern void _ZN6S247C63v38Ev();
extern void _ZN6S247C63v39Ev();
extern void _ZN6S247C63v40Ev();
extern void _ZN6S247C63v41Ev();
extern void _ZN6S247C63v42Ev();
extern void _ZN6S247C63v43Ev();
extern void _ZN6S247C63v44Ev();
extern void _ZN6S247C63v45Ev();
extern void _ZN6S247C63v46Ev();
extern void _ZN6S247C63v47Ev();
extern void _ZN6S247C63v48Ev();
extern void _ZN6S247C63v49Ev();
extern void _ZN6S247C63v50Ev();
extern void _ZN6S247C63v51Ev();
extern void _ZN6S247C63v52Ev();
extern void _ZN6S247C63v53Ev();
extern void _ZN6S247C63v54Ev();
extern void _ZN6S247C63v55Ev();
extern void _ZN6S247C63v56Ev();
extern void _ZN6S247C63v57Ev();
extern void _ZN6S247C63v58Ev();
extern void _ZN6S247C63v59Ev();
extern void _ZN6S247C63v60Ev();
extern void _ZN6S247C63v61Ev();
extern void _ZN6S247C63v62Ev();
extern void _ZN6S247C63v63Ev();
extern void _ZN6S247C63v64Ev();
extern void _ZN6S247C63v65Ev();
extern void _ZN6S247C63v66Ev();
extern void _ZN6S247C63v67Ev();
extern void _ZN6S247C63v68Ev();
static  VTBL_ENTRY vtc_S247C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S247C6[0]),
  (VTBL_ENTRY)&_ZN6S247C6D1Ev,
  (VTBL_ENTRY)&_ZN6S247C6D0Ev,
  (VTBL_ENTRY)&_ZN6S247C62v5Ev,
  (VTBL_ENTRY)&_ZN6S247C62v6Ev,
  (VTBL_ENTRY)&_ZN6S247C62v7Ev,
  (VTBL_ENTRY)&_ZN6S247C62v8Ev,
  (VTBL_ENTRY)&_ZN6S247C62v9Ev,
  (VTBL_ENTRY)&_ZN6S247C63v10Ev,
  (VTBL_ENTRY)&_ZN6S247C63v11Ev,
  (VTBL_ENTRY)&_ZN6S247C63v12Ev,
  (VTBL_ENTRY)&_ZN6S247C63v13Ev,
  (VTBL_ENTRY)&_ZN6S247C63v14Ev,
  (VTBL_ENTRY)&_ZN6S247C63v15Ev,
  (VTBL_ENTRY)&_ZN6S247C63v16Ev,
  (VTBL_ENTRY)&_ZN6S247C63v17Ev,
  (VTBL_ENTRY)&_ZN6S247C63v18Ev,
  (VTBL_ENTRY)&_ZN6S247C63v19Ev,
  (VTBL_ENTRY)&_ZN6S247C63v20Ev,
  (VTBL_ENTRY)&_ZN6S247C63v21Ev,
  (VTBL_ENTRY)&_ZN6S247C63v22Ev,
  (VTBL_ENTRY)&_ZN6S247C63v23Ev,
  (VTBL_ENTRY)&_ZN6S247C63v24Ev,
  (VTBL_ENTRY)&_ZN6S247C63v25Ev,
  (VTBL_ENTRY)&_ZN6S247C63v26Ev,
  (VTBL_ENTRY)&_ZN6S247C63v27Ev,
  (VTBL_ENTRY)&_ZN6S247C63v28Ev,
  (VTBL_ENTRY)&_ZN6S247C63v29Ev,
  (VTBL_ENTRY)&_ZN6S247C63v30Ev,
  (VTBL_ENTRY)&_ZN6S247C63v31Ev,
  (VTBL_ENTRY)&_ZN6S247C63v32Ev,
  (VTBL_ENTRY)&_ZN6S247C63v33Ev,
  (VTBL_ENTRY)&_ZN6S247C63v34Ev,
  (VTBL_ENTRY)&_ZN6S247C63v35Ev,
  (VTBL_ENTRY)&_ZN6S247C63v36Ev,
  (VTBL_ENTRY)&_ZN6S247C63v37Ev,
  (VTBL_ENTRY)&_ZN6S247C63v38Ev,
  (VTBL_ENTRY)&_ZN6S247C63v39Ev,
  (VTBL_ENTRY)&_ZN6S247C63v40Ev,
  (VTBL_ENTRY)&_ZN6S247C63v41Ev,
  (VTBL_ENTRY)&_ZN6S247C63v42Ev,
  (VTBL_ENTRY)&_ZN6S247C63v43Ev,
  (VTBL_ENTRY)&_ZN6S247C63v44Ev,
  (VTBL_ENTRY)&_ZN6S247C63v45Ev,
  (VTBL_ENTRY)&_ZN6S247C63v46Ev,
  (VTBL_ENTRY)&_ZN6S247C63v47Ev,
  (VTBL_ENTRY)&_ZN6S247C63v48Ev,
  (VTBL_ENTRY)&_ZN6S247C63v49Ev,
  (VTBL_ENTRY)&_ZN6S247C63v50Ev,
  (VTBL_ENTRY)&_ZN6S247C63v51Ev,
  (VTBL_ENTRY)&_ZN6S247C63v52Ev,
  (VTBL_ENTRY)&_ZN6S247C63v53Ev,
  (VTBL_ENTRY)&_ZN6S247C63v54Ev,
  (VTBL_ENTRY)&_ZN6S247C63v55Ev,
  (VTBL_ENTRY)&_ZN6S247C63v56Ev,
  (VTBL_ENTRY)&_ZN6S247C63v57Ev,
  (VTBL_ENTRY)&_ZN6S247C63v58Ev,
  (VTBL_ENTRY)&_ZN6S247C63v59Ev,
  (VTBL_ENTRY)&_ZN6S247C63v60Ev,
  (VTBL_ENTRY)&_ZN6S247C63v61Ev,
  (VTBL_ENTRY)&_ZN6S247C63v62Ev,
  (VTBL_ENTRY)&_ZN6S247C63v63Ev,
  (VTBL_ENTRY)&_ZN6S247C63v64Ev,
  (VTBL_ENTRY)&_ZN6S247C63v65Ev,
  (VTBL_ENTRY)&_ZN6S247C63v66Ev,
  (VTBL_ENTRY)&_ZN6S247C63v67Ev,
  (VTBL_ENTRY)&_ZN6S247C63v68Ev,
};
extern VTBL_ENTRY _ZTI6S247C6[];
extern  VTBL_ENTRY _ZTV6S247C6[];
Class_Descriptor cd_S247C6 = {  "S247C6", // class name
  0,0,//no base classes
  &(vtc_S247C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S247C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S247C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S247C5  : S247C6 {
  int s247c5f0[2];
  void *s247c5f1;
  int s247c5f2[2];
  ::S210C8_nt s247c5f3;
  ::S210C8_nt s247c5f4;
  ::S629C14 s247c5f5;
  ::S210C8_nt s247c5f6;
  unsigned int s247c5f7:1;
  unsigned int s247c5f8:1;
  unsigned int s247c5f9:1;
  unsigned int s247c5f10:1;
  unsigned int s247c5f11:1;
  int s247c5f12[2];
  virtual  ~S247C5(); // _ZN6S247C5D1Ev
  virtual void  v69(); // _ZN6S247C53v69Ev
  virtual void  v70(); // _ZN6S247C53v70Ev
  virtual void  v71(); // _ZN6S247C53v71Ev
  virtual void  v72(); // _ZN6S247C53v72Ev
  virtual void  v73(); // _ZN6S247C53v73Ev
  virtual void  v74(); // _ZN6S247C53v74Ev
  virtual void  v75(); // _ZN6S247C53v75Ev
  virtual void  v76(); // _ZN6S247C53v76Ev
  virtual void  v77(); // _ZN6S247C53v77Ev
  virtual void  v78(); // _ZN6S247C53v78Ev
  virtual void  v79(); // _ZN6S247C53v79Ev
  virtual void  v80(); // _ZN6S247C53v80Ev
  virtual void  v81(); // _ZN6S247C53v81Ev
  virtual void  v82(); // _ZN6S247C53v82Ev
  virtual void  v83(); // _ZN6S247C53v83Ev
  virtual void  v84(); // _ZN6S247C53v84Ev
  virtual void  v85(); // _ZN6S247C53v85Ev
  virtual void  v86(); // _ZN6S247C53v86Ev
  virtual void  v87(); // _ZN6S247C53v87Ev
  virtual void  v88(); // _ZN6S247C53v88Ev
  virtual void  v89(); // _ZN6S247C53v89Ev
  virtual void  v90(); // _ZN6S247C53v90Ev
  S247C5(); // tgen
};
//SIG(-1 S247C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S247C5 ::~S247C5(){ note_dtor("S247C5", this);}
void  S247C5 ::v69(){vfunc_called(this, "_ZN6S247C53v69Ev");}
void  S247C5 ::v70(){vfunc_called(this, "_ZN6S247C53v70Ev");}
void  S247C5 ::v71(){vfunc_called(this, "_ZN6S247C53v71Ev");}
void  S247C5 ::v72(){vfunc_called(this, "_ZN6S247C53v72Ev");}
void  S247C5 ::v73(){vfunc_called(this, "_ZN6S247C53v73Ev");}
void  S247C5 ::v74(){vfunc_called(this, "_ZN6S247C53v74Ev");}
void  S247C5 ::v75(){vfunc_called(this, "_ZN6S247C53v75Ev");}
void  S247C5 ::v76(){vfunc_called(this, "_ZN6S247C53v76Ev");}
void  S247C5 ::v77(){vfunc_called(this, "_ZN6S247C53v77Ev");}
void  S247C5 ::v78(){vfunc_called(this, "_ZN6S247C53v78Ev");}
void  S247C5 ::v79(){vfunc_called(this, "_ZN6S247C53v79Ev");}
void  S247C5 ::v80(){vfunc_called(this, "_ZN6S247C53v80Ev");}
void  S247C5 ::v81(){vfunc_called(this, "_ZN6S247C53v81Ev");}
void  S247C5 ::v82(){vfunc_called(this, "_ZN6S247C53v82Ev");}
void  S247C5 ::v83(){vfunc_called(this, "_ZN6S247C53v83Ev");}
void  S247C5 ::v84(){vfunc_called(this, "_ZN6S247C53v84Ev");}
void  S247C5 ::v85(){vfunc_called(this, "_ZN6S247C53v85Ev");}
void  S247C5 ::v86(){vfunc_called(this, "_ZN6S247C53v86Ev");}
void  S247C5 ::v87(){vfunc_called(this, "_ZN6S247C53v87Ev");}
void  S247C5 ::v88(){vfunc_called(this, "_ZN6S247C53v88Ev");}
void  S247C5 ::v89(){vfunc_called(this, "_ZN6S247C53v89Ev");}
void  S247C5 ::v90(){vfunc_called(this, "_ZN6S247C53v90Ev");}
S247C5 ::S247C5(){ note_ctor("S247C5", this);} // tgen

static void Test_S247C5()
{
  extern Class_Descriptor cd_S247C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S247C5, buf);
    S247C5 *dp, &lv = *(dp=new (buf) S247C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S247C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S247C5)");
    check_base_class_offset(lv, (S247C6*), 0, "S247C5");
    check_field_offset(lv, s247c5f0, ABISELECT(96,60), "S247C5.s247c5f0");
    check_field_offset(lv, s247c5f1, ABISELECT(104,68), "S247C5.s247c5f1");
    check_field_offset(lv, s247c5f2, ABISELECT(112,72), "S247C5.s247c5f2");
    check_field_offset(lv, s247c5f3, ABISELECT(120,80), "S247C5.s247c5f3");
    check_field_offset(lv, s247c5f4, ABISELECT(136,92), "S247C5.s247c5f4");
    check_field_offset(lv, s247c5f5, ABISELECT(152,104), "S247C5.s247c5f5");
    check_field_offset(lv, s247c5f6, ABISELECT(160,108), "S247C5.s247c5f6");
    set_bf_and_test(lv, s247c5f7, ABISELECT(176,120), 0, 1, 1, "S247C5");
    set_bf_and_test(lv, s247c5f8, ABISELECT(176,120), 1, 1, 1, "S247C5");
    set_bf_and_test(lv, s247c5f9, ABISELECT(176,120), 2, 1, 1, "S247C5");
    set_bf_and_test(lv, s247c5f10, ABISELECT(176,120), 3, 1, 1, "S247C5");
    set_bf_and_test(lv, s247c5f11, ABISELECT(176,120), 4, 1, 1, "S247C5");
    check_field_offset(lv, s247c5f12, ABISELECT(180,124), "S247C5.s247c5f12");
    test_class_info(&lv, &cd_S247C5);
    dp->~S247C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS247C5(Test_S247C5, "S247C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S247C5C1Ev();
extern void _ZN6S247C5D1Ev();
Name_Map name_map_S247C5[] = {
  NSPAIR(_ZN6S247C5C1Ev),
  NSPAIR(_ZN6S247C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S247C6;
extern VTBL_ENTRY _ZTI6S247C6[];
extern  VTBL_ENTRY _ZTV6S247C6[];
static Base_Class bases_S247C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S247C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S247C5[];
extern void _ZN6S247C5D1Ev();
extern void _ZN6S247C5D0Ev();
extern void _ZN6S247C62v5Ev();
extern void _ZN6S247C62v6Ev();
extern void _ZN6S247C62v7Ev();
extern void _ZN6S247C62v8Ev();
extern void _ZN6S247C62v9Ev();
extern void _ZN6S247C63v10Ev();
extern void _ZN6S247C63v11Ev();
extern void _ZN6S247C63v12Ev();
extern void _ZN6S247C63v13Ev();
extern void _ZN6S247C63v14Ev();
extern void _ZN6S247C63v15Ev();
extern void _ZN6S247C63v16Ev();
extern void _ZN6S247C63v17Ev();
extern void _ZN6S247C63v18Ev();
extern void _ZN6S247C63v19Ev();
extern void _ZN6S247C63v20Ev();
extern void _ZN6S247C63v21Ev();
extern void _ZN6S247C63v22Ev();
extern void _ZN6S247C63v23Ev();
extern void _ZN6S247C63v24Ev();
extern void _ZN6S247C63v25Ev();
extern void _ZN6S247C63v26Ev();
extern void _ZN6S247C63v27Ev();
extern void _ZN6S247C63v28Ev();
extern void _ZN6S247C63v29Ev();
extern void _ZN6S247C63v30Ev();
extern void _ZN6S247C63v31Ev();
extern void _ZN6S247C63v32Ev();
extern void _ZN6S247C63v33Ev();
extern void _ZN6S247C63v34Ev();
extern void _ZN6S247C63v35Ev();
extern void _ZN6S247C63v36Ev();
extern void _ZN6S247C63v37Ev();
extern void _ZN6S247C63v38Ev();
extern void _ZN6S247C63v39Ev();
extern void _ZN6S247C63v40Ev();
extern void _ZN6S247C63v41Ev();
extern void _ZN6S247C63v42Ev();
extern void _ZN6S247C63v43Ev();
extern void _ZN6S247C63v44Ev();
extern void _ZN6S247C63v45Ev();
extern void _ZN6S247C63v46Ev();
extern void _ZN6S247C63v47Ev();
extern void _ZN6S247C63v48Ev();
extern void _ZN6S247C63v49Ev();
extern void _ZN6S247C63v50Ev();
extern void _ZN6S247C63v51Ev();
extern void _ZN6S247C63v52Ev();
extern void _ZN6S247C63v53Ev();
extern void _ZN6S247C63v54Ev();
extern void _ZN6S247C63v55Ev();
extern void _ZN6S247C63v56Ev();
extern void _ZN6S247C63v57Ev();
extern void _ZN6S247C63v58Ev();
extern void _ZN6S247C63v59Ev();
extern void _ZN6S247C63v60Ev();
extern void _ZN6S247C63v61Ev();
extern void _ZN6S247C63v62Ev();
extern void _ZN6S247C63v63Ev();
extern void _ZN6S247C63v64Ev();
extern void _ZN6S247C63v65Ev();
extern void _ZN6S247C63v66Ev();
extern void _ZN6S247C63v67Ev();
extern void _ZN6S247C63v68Ev();
extern void _ZN6S247C53v69Ev();
extern void _ZN6S247C53v70Ev();
extern void _ZN6S247C53v71Ev();
extern void _ZN6S247C53v72Ev();
extern void _ZN6S247C53v73Ev();
extern void _ZN6S247C53v74Ev();
extern void _ZN6S247C53v75Ev();
extern void _ZN6S247C53v76Ev();
extern void _ZN6S247C53v77Ev();
extern void _ZN6S247C53v78Ev();
extern void _ZN6S247C53v79Ev();
extern void _ZN6S247C53v80Ev();
extern void _ZN6S247C53v81Ev();
extern void _ZN6S247C53v82Ev();
extern void _ZN6S247C53v83Ev();
extern void _ZN6S247C53v84Ev();
extern void _ZN6S247C53v85Ev();
extern void _ZN6S247C53v86Ev();
extern void _ZN6S247C53v87Ev();
extern void _ZN6S247C53v88Ev();
extern void _ZN6S247C53v89Ev();
extern void _ZN6S247C53v90Ev();
static  VTBL_ENTRY vtc_S247C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S247C5[0]),
  (VTBL_ENTRY)&_ZN6S247C5D1Ev,
  (VTBL_ENTRY)&_ZN6S247C5D0Ev,
  (VTBL_ENTRY)&_ZN6S247C62v5Ev,
  (VTBL_ENTRY)&_ZN6S247C62v6Ev,
  (VTBL_ENTRY)&_ZN6S247C62v7Ev,
  (VTBL_ENTRY)&_ZN6S247C62v8Ev,
  (VTBL_ENTRY)&_ZN6S247C62v9Ev,
  (VTBL_ENTRY)&_ZN6S247C63v10Ev,
  (VTBL_ENTRY)&_ZN6S247C63v11Ev,
  (VTBL_ENTRY)&_ZN6S247C63v12Ev,
  (VTBL_ENTRY)&_ZN6S247C63v13Ev,
  (VTBL_ENTRY)&_ZN6S247C63v14Ev,
  (VTBL_ENTRY)&_ZN6S247C63v15Ev,
  (VTBL_ENTRY)&_ZN6S247C63v16Ev,
  (VTBL_ENTRY)&_ZN6S247C63v17Ev,
  (VTBL_ENTRY)&_ZN6S247C63v18Ev,
  (VTBL_ENTRY)&_ZN6S247C63v19Ev,
  (VTBL_ENTRY)&_ZN6S247C63v20Ev,
  (VTBL_ENTRY)&_ZN6S247C63v21Ev,
  (VTBL_ENTRY)&_ZN6S247C63v22Ev,
  (VTBL_ENTRY)&_ZN6S247C63v23Ev,
  (VTBL_ENTRY)&_ZN6S247C63v24Ev,
  (VTBL_ENTRY)&_ZN6S247C63v25Ev,
  (VTBL_ENTRY)&_ZN6S247C63v26Ev,
  (VTBL_ENTRY)&_ZN6S247C63v27Ev,
  (VTBL_ENTRY)&_ZN6S247C63v28Ev,
  (VTBL_ENTRY)&_ZN6S247C63v29Ev,
  (VTBL_ENTRY)&_ZN6S247C63v30Ev,
  (VTBL_ENTRY)&_ZN6S247C63v31Ev,
  (VTBL_ENTRY)&_ZN6S247C63v32Ev,
  (VTBL_ENTRY)&_ZN6S247C63v33Ev,
  (VTBL_ENTRY)&_ZN6S247C63v34Ev,
  (VTBL_ENTRY)&_ZN6S247C63v35Ev,
  (VTBL_ENTRY)&_ZN6S247C63v36Ev,
  (VTBL_ENTRY)&_ZN6S247C63v37Ev,
  (VTBL_ENTRY)&_ZN6S247C63v38Ev,
  (VTBL_ENTRY)&_ZN6S247C63v39Ev,
  (VTBL_ENTRY)&_ZN6S247C63v40Ev,
  (VTBL_ENTRY)&_ZN6S247C63v41Ev,
  (VTBL_ENTRY)&_ZN6S247C63v42Ev,
  (VTBL_ENTRY)&_ZN6S247C63v43Ev,
  (VTBL_ENTRY)&_ZN6S247C63v44Ev,
  (VTBL_ENTRY)&_ZN6S247C63v45Ev,
  (VTBL_ENTRY)&_ZN6S247C63v46Ev,
  (VTBL_ENTRY)&_ZN6S247C63v47Ev,
  (VTBL_ENTRY)&_ZN6S247C63v48Ev,
  (VTBL_ENTRY)&_ZN6S247C63v49Ev,
  (VTBL_ENTRY)&_ZN6S247C63v50Ev,
  (VTBL_ENTRY)&_ZN6S247C63v51Ev,
  (VTBL_ENTRY)&_ZN6S247C63v52Ev,
  (VTBL_ENTRY)&_ZN6S247C63v53Ev,
  (VTBL_ENTRY)&_ZN6S247C63v54Ev,
  (VTBL_ENTRY)&_ZN6S247C63v55Ev,
  (VTBL_ENTRY)&_ZN6S247C63v56Ev,
  (VTBL_ENTRY)&_ZN6S247C63v57Ev,
  (VTBL_ENTRY)&_ZN6S247C63v58Ev,
  (VTBL_ENTRY)&_ZN6S247C63v59Ev,
  (VTBL_ENTRY)&_ZN6S247C63v60Ev,
  (VTBL_ENTRY)&_ZN6S247C63v61Ev,
  (VTBL_ENTRY)&_ZN6S247C63v62Ev,
  (VTBL_ENTRY)&_ZN6S247C63v63Ev,
  (VTBL_ENTRY)&_ZN6S247C63v64Ev,
  (VTBL_ENTRY)&_ZN6S247C63v65Ev,
  (VTBL_ENTRY)&_ZN6S247C63v66Ev,
  (VTBL_ENTRY)&_ZN6S247C63v67Ev,
  (VTBL_ENTRY)&_ZN6S247C63v68Ev,
  (VTBL_ENTRY)&_ZN6S247C53v69Ev,
  (VTBL_ENTRY)&_ZN6S247C53v70Ev,
  (VTBL_ENTRY)&_ZN6S247C53v71Ev,
  (VTBL_ENTRY)&_ZN6S247C53v72Ev,
  (VTBL_ENTRY)&_ZN6S247C53v73Ev,
  (VTBL_ENTRY)&_ZN6S247C53v74Ev,
  (VTBL_ENTRY)&_ZN6S247C53v75Ev,
  (VTBL_ENTRY)&_ZN6S247C53v76Ev,
  (VTBL_ENTRY)&_ZN6S247C53v77Ev,
  (VTBL_ENTRY)&_ZN6S247C53v78Ev,
  (VTBL_ENTRY)&_ZN6S247C53v79Ev,
  (VTBL_ENTRY)&_ZN6S247C53v80Ev,
  (VTBL_ENTRY)&_ZN6S247C53v81Ev,
  (VTBL_ENTRY)&_ZN6S247C53v82Ev,
  (VTBL_ENTRY)&_ZN6S247C53v83Ev,
  (VTBL_ENTRY)&_ZN6S247C53v84Ev,
  (VTBL_ENTRY)&_ZN6S247C53v85Ev,
  (VTBL_ENTRY)&_ZN6S247C53v86Ev,
  (VTBL_ENTRY)&_ZN6S247C53v87Ev,
  (VTBL_ENTRY)&_ZN6S247C53v88Ev,
  (VTBL_ENTRY)&_ZN6S247C53v89Ev,
  (VTBL_ENTRY)&_ZN6S247C53v90Ev,
};
extern VTBL_ENTRY _ZTI6S247C5[];
extern  VTBL_ENTRY _ZTV6S247C5[];
Class_Descriptor cd_S247C5 = {  "S247C5", // class name
  bases_S247C5, 1,
  &(vtc_S247C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S247C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S247C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S247C4  : S247C5 {
  unsigned int s247c4f0:1;
  unsigned int s247c4f1:1;
  unsigned int s247c4f2:1;
  ::S1503C28 s247c4f3;
  ::S1503C24 s247c4f4;
  ::S1503C18 s247c4f5;
  ::S1503C12 s247c4f6;
  int s247c4f7[3];
  virtual  ~S247C4(); // _ZN6S247C4D1Ev
  virtual void  v91(); // _ZN6S247C43v91Ev
  virtual void  v92(); // _ZN6S247C43v92Ev
  virtual void  v93(); // _ZN6S247C43v93Ev
  virtual void  v94(); // _ZN6S247C43v94Ev
  virtual void  v95(); // _ZN6S247C43v95Ev
  virtual void  v96(); // _ZN6S247C43v96Ev
  virtual void  v97(); // _ZN6S247C43v97Ev
  virtual void  v98(); // _ZN6S247C43v98Ev
  virtual void  v99(); // _ZN6S247C43v99Ev
  virtual void  v100(); // _ZN6S247C44v100Ev
  virtual void  v101(); // _ZN6S247C44v101Ev
  virtual void  v102(); // _ZN6S247C44v102Ev
  virtual void  v103(); // _ZN6S247C44v103Ev
  virtual void  v104(); // _ZN6S247C44v104Ev
  virtual void  v105(); // _ZN6S247C44v105Ev
  virtual void  v106(); // _ZN6S247C44v106Ev
  virtual void  v107(); // _ZN6S247C44v107Ev
  virtual void  v108(); // _ZN6S247C44v108Ev
  virtual void  v109(); // _ZN6S247C44v109Ev
  virtual void  v110(); // _ZN6S247C44v110Ev
  S247C4(); // tgen
};
//SIG(-1 S247C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S247C4 ::~S247C4(){ note_dtor("S247C4", this);}
void  S247C4 ::v91(){vfunc_called(this, "_ZN6S247C43v91Ev");}
void  S247C4 ::v92(){vfunc_called(this, "_ZN6S247C43v92Ev");}
void  S247C4 ::v93(){vfunc_called(this, "_ZN6S247C43v93Ev");}
void  S247C4 ::v94(){vfunc_called(this, "_ZN6S247C43v94Ev");}
void  S247C4 ::v95(){vfunc_called(this, "_ZN6S247C43v95Ev");}
void  S247C4 ::v96(){vfunc_called(this, "_ZN6S247C43v96Ev");}
void  S247C4 ::v97(){vfunc_called(this, "_ZN6S247C43v97Ev");}
void  S247C4 ::v98(){vfunc_called(this, "_ZN6S247C43v98Ev");}
void  S247C4 ::v99(){vfunc_called(this, "_ZN6S247C43v99Ev");}
void  S247C4 ::v100(){vfunc_called(this, "_ZN6S247C44v100Ev");}
void  S247C4 ::v101(){vfunc_called(this, "_ZN6S247C44v101Ev");}
void  S247C4 ::v102(){vfunc_called(this, "_ZN6S247C44v102Ev");}
void  S247C4 ::v103(){vfunc_called(this, "_ZN6S247C44v103Ev");}
void  S247C4 ::v104(){vfunc_called(this, "_ZN6S247C44v104Ev");}
void  S247C4 ::v105(){vfunc_called(this, "_ZN6S247C44v105Ev");}
void  S247C4 ::v106(){vfunc_called(this, "_ZN6S247C44v106Ev");}
void  S247C4 ::v107(){vfunc_called(this, "_ZN6S247C44v107Ev");}
void  S247C4 ::v108(){vfunc_called(this, "_ZN6S247C44v108Ev");}
void  S247C4 ::v109(){vfunc_called(this, "_ZN6S247C44v109Ev");}
void  S247C4 ::v110(){vfunc_called(this, "_ZN6S247C44v110Ev");}
S247C4 ::S247C4(){ note_ctor("S247C4", this);} // tgen

static void Test_S247C4()
{
  extern Class_Descriptor cd_S247C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S247C4, buf);
    S247C4 *dp, &lv = *(dp=new (buf) S247C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S247C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S247C4)");
    check_base_class_offset(lv, (S247C6*)(S247C5*), 0, "S247C4");
    check_base_class_offset(lv, (S247C5*), 0, "S247C4");
    set_bf_and_test(lv, s247c4f0, ABISELECT(188,132), 0, 1, 1, "S247C4");
    set_bf_and_test(lv, s247c4f1, ABISELECT(188,132), 1, 1, 1, "S247C4");
    set_bf_and_test(lv, s247c4f2, ABISELECT(188,132), 2, 1, 1, "S247C4");
    check_field_offset(lv, s247c4f3, ABISELECT(192,136), "S247C4.s247c4f3");
    check_field_offset(lv, s247c4f4, ABISELECT(208,148), "S247C4.s247c4f4");
    check_field_offset(lv, s247c4f5, ABISELECT(224,160), "S247C4.s247c4f5");
    check_field_offset(lv, s247c4f6, ABISELECT(240,172), "S247C4.s247c4f6");
    check_field_offset(lv, s247c4f7, ABISELECT(256,184), "S247C4.s247c4f7");
    test_class_info(&lv, &cd_S247C4);
    dp->~S247C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS247C4(Test_S247C4, "S247C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S247C4C1Ev();
extern void _ZN6S247C4D1Ev();
Name_Map name_map_S247C4[] = {
  NSPAIR(_ZN6S247C4C1Ev),
  NSPAIR(_ZN6S247C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S247C6;
extern VTBL_ENTRY _ZTI6S247C6[];
extern  VTBL_ENTRY _ZTV6S247C6[];
extern Class_Descriptor cd_S247C5;
extern VTBL_ENTRY _ZTI6S247C5[];
extern  VTBL_ENTRY _ZTV6S247C5[];
static Base_Class bases_S247C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S247C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S247C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S247C4[];
extern void _ZN6S247C4D1Ev();
extern void _ZN6S247C4D0Ev();
extern void _ZN6S247C62v5Ev();
extern void _ZN6S247C62v6Ev();
extern void _ZN6S247C62v7Ev();
extern void _ZN6S247C62v8Ev();
extern void _ZN6S247C62v9Ev();
extern void _ZN6S247C63v10Ev();
extern void _ZN6S247C63v11Ev();
extern void _ZN6S247C63v12Ev();
extern void _ZN6S247C63v13Ev();
extern void _ZN6S247C63v14Ev();
extern void _ZN6S247C63v15Ev();
extern void _ZN6S247C63v16Ev();
extern void _ZN6S247C63v17Ev();
extern void _ZN6S247C63v18Ev();
extern void _ZN6S247C63v19Ev();
extern void _ZN6S247C63v20Ev();
extern void _ZN6S247C63v21Ev();
extern void _ZN6S247C63v22Ev();
extern void _ZN6S247C63v23Ev();
extern void _ZN6S247C63v24Ev();
extern void _ZN6S247C63v25Ev();
extern void _ZN6S247C63v26Ev();
extern void _ZN6S247C63v27Ev();
extern void _ZN6S247C63v28Ev();
extern void _ZN6S247C63v29Ev();
extern void _ZN6S247C63v30Ev();
extern void _ZN6S247C63v31Ev();
extern void _ZN6S247C63v32Ev();
extern void _ZN6S247C63v33Ev();
extern void _ZN6S247C63v34Ev();
extern void _ZN6S247C63v35Ev();
extern void _ZN6S247C63v36Ev();
extern void _ZN6S247C63v37Ev();
extern void _ZN6S247C63v38Ev();
extern void _ZN6S247C63v39Ev();
extern void _ZN6S247C63v40Ev();
extern void _ZN6S247C63v41Ev();
extern void _ZN6S247C63v42Ev();
extern void _ZN6S247C63v43Ev();
extern void _ZN6S247C63v44Ev();
extern void _ZN6S247C63v45Ev();
extern void _ZN6S247C63v46Ev();
extern void _ZN6S247C63v47Ev();
extern void _ZN6S247C63v48Ev();
extern void _ZN6S247C63v49Ev();
extern void _ZN6S247C63v50Ev();
extern void _ZN6S247C63v51Ev();
extern void _ZN6S247C63v52Ev();
extern void _ZN6S247C63v53Ev();
extern void _ZN6S247C63v54Ev();
extern void _ZN6S247C63v55Ev();
extern void _ZN6S247C63v56Ev();
extern void _ZN6S247C63v57Ev();
extern void _ZN6S247C63v58Ev();
extern void _ZN6S247C63v59Ev();
extern void _ZN6S247C63v60Ev();
extern void _ZN6S247C63v61Ev();
extern void _ZN6S247C63v62Ev();
extern void _ZN6S247C63v63Ev();
extern void _ZN6S247C63v64Ev();
extern void _ZN6S247C63v65Ev();
extern void _ZN6S247C63v66Ev();
extern void _ZN6S247C63v67Ev();
extern void _ZN6S247C63v68Ev();
extern void _ZN6S247C53v69Ev();
extern void _ZN6S247C53v70Ev();
extern void _ZN6S247C53v71Ev();
extern void _ZN6S247C53v72Ev();
extern void _ZN6S247C53v73Ev();
extern void _ZN6S247C53v74Ev();
extern void _ZN6S247C53v75Ev();
extern void _ZN6S247C53v76Ev();
extern void _ZN6S247C53v77Ev();
extern void _ZN6S247C53v78Ev();
extern void _ZN6S247C53v79Ev();
extern void _ZN6S247C53v80Ev();
extern void _ZN6S247C53v81Ev();
extern void _ZN6S247C53v82Ev();
extern void _ZN6S247C53v83Ev();
extern void _ZN6S247C53v84Ev();
extern void _ZN6S247C53v85Ev();
extern void _ZN6S247C53v86Ev();
extern void _ZN6S247C53v87Ev();
extern void _ZN6S247C53v88Ev();
extern void _ZN6S247C53v89Ev();
extern void _ZN6S247C53v90Ev();
extern void _ZN6S247C43v91Ev();
extern void _ZN6S247C43v92Ev();
extern void _ZN6S247C43v93Ev();
extern void _ZN6S247C43v94Ev();
extern void _ZN6S247C43v95Ev();
extern void _ZN6S247C43v96Ev();
extern void _ZN6S247C43v97Ev();
extern void _ZN6S247C43v98Ev();
extern void _ZN6S247C43v99Ev();
extern void _ZN6S247C44v100Ev();
extern void _ZN6S247C44v101Ev();
extern void _ZN6S247C44v102Ev();
extern void _ZN6S247C44v103Ev();
extern void _ZN6S247C44v104Ev();
extern void _ZN6S247C44v105Ev();
extern void _ZN6S247C44v106Ev();
extern void _ZN6S247C44v107Ev();
extern void _ZN6S247C44v108Ev();
extern void _ZN6S247C44v109Ev();
extern void _ZN6S247C44v110Ev();
static  VTBL_ENTRY vtc_S247C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S247C4[0]),
  (VTBL_ENTRY)&_ZN6S247C4D1Ev,
  (VTBL_ENTRY)&_ZN6S247C4D0Ev,
  (VTBL_ENTRY)&_ZN6S247C62v5Ev,
  (VTBL_ENTRY)&_ZN6S247C62v6Ev,
  (VTBL_ENTRY)&_ZN6S247C62v7Ev,
  (VTBL_ENTRY)&_ZN6S247C62v8Ev,
  (VTBL_ENTRY)&_ZN6S247C62v9Ev,
  (VTBL_ENTRY)&_ZN6S247C63v10Ev,
  (VTBL_ENTRY)&_ZN6S247C63v11Ev,
  (VTBL_ENTRY)&_ZN6S247C63v12Ev,
  (VTBL_ENTRY)&_ZN6S247C63v13Ev,
  (VTBL_ENTRY)&_ZN6S247C63v14Ev,
  (VTBL_ENTRY)&_ZN6S247C63v15Ev,
  (VTBL_ENTRY)&_ZN6S247C63v16Ev,
  (VTBL_ENTRY)&_ZN6S247C63v17Ev,
  (VTBL_ENTRY)&_ZN6S247C63v18Ev,
  (VTBL_ENTRY)&_ZN6S247C63v19Ev,
  (VTBL_ENTRY)&_ZN6S247C63v20Ev,
  (VTBL_ENTRY)&_ZN6S247C63v21Ev,
  (VTBL_ENTRY)&_ZN6S247C63v22Ev,
  (VTBL_ENTRY)&_ZN6S247C63v23Ev,
  (VTBL_ENTRY)&_ZN6S247C63v24Ev,
  (VTBL_ENTRY)&_ZN6S247C63v25Ev,
  (VTBL_ENTRY)&_ZN6S247C63v26Ev,
  (VTBL_ENTRY)&_ZN6S247C63v27Ev,
  (VTBL_ENTRY)&_ZN6S247C63v28Ev,
  (VTBL_ENTRY)&_ZN6S247C63v29Ev,
  (VTBL_ENTRY)&_ZN6S247C63v30Ev,
  (VTBL_ENTRY)&_ZN6S247C63v31Ev,
  (VTBL_ENTRY)&_ZN6S247C63v32Ev,
  (VTBL_ENTRY)&_ZN6S247C63v33Ev,
  (VTBL_ENTRY)&_ZN6S247C63v34Ev,
  (VTBL_ENTRY)&_ZN6S247C63v35Ev,
  (VTBL_ENTRY)&_ZN6S247C63v36Ev,
  (VTBL_ENTRY)&_ZN6S247C63v37Ev,
  (VTBL_ENTRY)&_ZN6S247C63v38Ev,
  (VTBL_ENTRY)&_ZN6S247C63v39Ev,
  (VTBL_ENTRY)&_ZN6S247C63v40Ev,
  (VTBL_ENTRY)&_ZN6S247C63v41Ev,
  (VTBL_ENTRY)&_ZN6S247C63v42Ev,
  (VTBL_ENTRY)&_ZN6S247C63v43Ev,
  (VTBL_ENTRY)&_ZN6S247C63v44Ev,
  (VTBL_ENTRY)&_ZN6S247C63v45Ev,
  (VTBL_ENTRY)&_ZN6S247C63v46Ev,
  (VTBL_ENTRY)&_ZN6S247C63v47Ev,
  (VTBL_ENTRY)&_ZN6S247C63v48Ev,
  (VTBL_ENTRY)&_ZN6S247C63v49Ev,
  (VTBL_ENTRY)&_ZN6S247C63v50Ev,
  (VTBL_ENTRY)&_ZN6S247C63v51Ev,
  (VTBL_ENTRY)&_ZN6S247C63v52Ev,
  (VTBL_ENTRY)&_ZN6S247C63v53Ev,
  (VTBL_ENTRY)&_ZN6S247C63v54Ev,
  (VTBL_ENTRY)&_ZN6S247C63v55Ev,
  (VTBL_ENTRY)&_ZN6S247C63v56Ev,
  (VTBL_ENTRY)&_ZN6S247C63v57Ev,
  (VTBL_ENTRY)&_ZN6S247C63v58Ev,
  (VTBL_ENTRY)&_ZN6S247C63v59Ev,
  (VTBL_ENTRY)&_ZN6S247C63v60Ev,
  (VTBL_ENTRY)&_ZN6S247C63v61Ev,
  (VTBL_ENTRY)&_ZN6S247C63v62Ev,
  (VTBL_ENTRY)&_ZN6S247C63v63Ev,
  (VTBL_ENTRY)&_ZN6S247C63v64Ev,
  (VTBL_ENTRY)&_ZN6S247C63v65Ev,
  (VTBL_ENTRY)&_ZN6S247C63v66Ev,
  (VTBL_ENTRY)&_ZN6S247C63v67Ev,
  (VTBL_ENTRY)&_ZN6S247C63v68Ev,
  (VTBL_ENTRY)&_ZN6S247C53v69Ev,
  (VTBL_ENTRY)&_ZN6S247C53v70Ev,
  (VTBL_ENTRY)&_ZN6S247C53v71Ev,
  (VTBL_ENTRY)&_ZN6S247C53v72Ev,
  (VTBL_ENTRY)&_ZN6S247C53v73Ev,
  (VTBL_ENTRY)&_ZN6S247C53v74Ev,
  (VTBL_ENTRY)&_ZN6S247C53v75Ev,
  (VTBL_ENTRY)&_ZN6S247C53v76Ev,
  (VTBL_ENTRY)&_ZN6S247C53v77Ev,
  (VTBL_ENTRY)&_ZN6S247C53v78Ev,
  (VTBL_ENTRY)&_ZN6S247C53v79Ev,
  (VTBL_ENTRY)&_ZN6S247C53v80Ev,
  (VTBL_ENTRY)&_ZN6S247C53v81Ev,
  (VTBL_ENTRY)&_ZN6S247C53v82Ev,
  (VTBL_ENTRY)&_ZN6S247C53v83Ev,
  (VTBL_ENTRY)&_ZN6S247C53v84Ev,
  (VTBL_ENTRY)&_ZN6S247C53v85Ev,
  (VTBL_ENTRY)&_ZN6S247C53v86Ev,
  (VTBL_ENTRY)&_ZN6S247C53v87Ev,
  (VTBL_ENTRY)&_ZN6S247C53v88Ev,
  (VTBL_ENTRY)&_ZN6S247C53v89Ev,
  (VTBL_ENTRY)&_ZN6S247C53v90Ev,
  (VTBL_ENTRY)&_ZN6S247C43v91Ev,
  (VTBL_ENTRY)&_ZN6S247C43v92Ev,
  (VTBL_ENTRY)&_ZN6S247C43v93Ev,
  (VTBL_ENTRY)&_ZN6S247C43v94Ev,
  (VTBL_ENTRY)&_ZN6S247C43v95Ev,
  (VTBL_ENTRY)&_ZN6S247C43v96Ev,
  (VTBL_ENTRY)&_ZN6S247C43v97Ev,
  (VTBL_ENTRY)&_ZN6S247C43v98Ev,
  (VTBL_ENTRY)&_ZN6S247C43v99Ev,
  (VTBL_ENTRY)&_ZN6S247C44v100Ev,
  (VTBL_ENTRY)&_ZN6S247C44v101Ev,
  (VTBL_ENTRY)&_ZN6S247C44v102Ev,
  (VTBL_ENTRY)&_ZN6S247C44v103Ev,
  (VTBL_ENTRY)&_ZN6S247C44v104Ev,
  (VTBL_ENTRY)&_ZN6S247C44v105Ev,
  (VTBL_ENTRY)&_ZN6S247C44v106Ev,
  (VTBL_ENTRY)&_ZN6S247C44v107Ev,
  (VTBL_ENTRY)&_ZN6S247C44v108Ev,
  (VTBL_ENTRY)&_ZN6S247C44v109Ev,
  (VTBL_ENTRY)&_ZN6S247C44v110Ev,
};
extern VTBL_ENTRY _ZTI6S247C4[];
extern  VTBL_ENTRY _ZTV6S247C4[];
Class_Descriptor cd_S247C4 = {  "S247C4", // class name
  bases_S247C4, 2,
  &(vtc_S247C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S247C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S247C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S247C3  : S247C4 {
  ::S1503C5_nt s247c3f0;
  unsigned int s247c3f1:1;
  ::S1503C6_nt s247c3f2;
  virtual  ~S247C3(); // _ZN6S247C3D1Ev
  virtual void  v111(); // _ZN6S247C34v111Ev
  virtual void  v112(); // _ZN6S247C34v112Ev
  virtual void  v113(); // _ZN6S247C34v113Ev
  virtual void  v114(); // _ZN6S247C34v114Ev
  S247C3(); // tgen
};
//SIG(-1 S247C3) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S247C3 ::~S247C3(){ note_dtor("S247C3", this);}
void  S247C3 ::v111(){vfunc_called(this, "_ZN6S247C34v111Ev");}
void  S247C3 ::v112(){vfunc_called(this, "_ZN6S247C34v112Ev");}
void  S247C3 ::v113(){vfunc_called(this, "_ZN6S247C34v113Ev");}
void  S247C3 ::v114(){vfunc_called(this, "_ZN6S247C34v114Ev");}
S247C3 ::S247C3(){ note_ctor("S247C3", this);} // tgen

static void Test_S247C3()
{
  extern Class_Descriptor cd_S247C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S247C3, buf);
    S247C3 *dp, &lv = *(dp=new (buf) S247C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S247C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S247C3)");
    check_base_class_offset(lv, (S247C6*)(S247C5*)(S247C4*), 0, "S247C3");
    check_base_class_offset(lv, (S247C5*)(S247C4*), 0, "S247C3");
    check_base_class_offset(lv, (S247C4*), 0, "S247C3");
    check_field_offset(lv, s247c3f0, ABISELECT(268,196), "S247C3.s247c3f0");
    set_bf_and_test(lv, s247c3f1, ABISELECT(276,204), 0, 1, 1, "S247C3");
    check_field_offset(lv, s247c3f2, ABISELECT(280,208), "S247C3.s247c3f2");
    test_class_info(&lv, &cd_S247C3);
    dp->~S247C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS247C3(Test_S247C3, "S247C3", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S247C3C1Ev();
extern void _ZN6S247C3D1Ev();
Name_Map name_map_S247C3[] = {
  NSPAIR(_ZN6S247C3C1Ev),
  NSPAIR(_ZN6S247C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S247C6;
extern VTBL_ENTRY _ZTI6S247C6[];
extern  VTBL_ENTRY _ZTV6S247C6[];
extern Class_Descriptor cd_S247C5;
extern VTBL_ENTRY _ZTI6S247C5[];
extern  VTBL_ENTRY _ZTV6S247C5[];
extern Class_Descriptor cd_S247C4;
extern VTBL_ENTRY _ZTI6S247C4[];
extern  VTBL_ENTRY _ZTV6S247C4[];
static Base_Class bases_S247C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S247C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S247C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S247C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S247C3[];
extern void _ZN6S247C3D1Ev();
extern void _ZN6S247C3D0Ev();
extern void _ZN6S247C62v5Ev();
extern void _ZN6S247C62v6Ev();
extern void _ZN6S247C62v7Ev();
extern void _ZN6S247C62v8Ev();
extern void _ZN6S247C62v9Ev();
extern void _ZN6S247C63v10Ev();
extern void _ZN6S247C63v11Ev();
extern void _ZN6S247C63v12Ev();
extern void _ZN6S247C63v13Ev();
extern void _ZN6S247C63v14Ev();
extern void _ZN6S247C63v15Ev();
extern void _ZN6S247C63v16Ev();
extern void _ZN6S247C63v17Ev();
extern void _ZN6S247C63v18Ev();
extern void _ZN6S247C63v19Ev();
extern void _ZN6S247C63v20Ev();
extern void _ZN6S247C63v21Ev();
extern void _ZN6S247C63v22Ev();
extern void _ZN6S247C63v23Ev();
extern void _ZN6S247C63v24Ev();
extern void _ZN6S247C63v25Ev();
extern void _ZN6S247C63v26Ev();
extern void _ZN6S247C63v27Ev();
extern void _ZN6S247C63v28Ev();
extern void _ZN6S247C63v29Ev();
extern void _ZN6S247C63v30Ev();
extern void _ZN6S247C63v31Ev();
extern void _ZN6S247C63v32Ev();
extern void _ZN6S247C63v33Ev();
extern void _ZN6S247C63v34Ev();
extern void _ZN6S247C63v35Ev();
extern void _ZN6S247C63v36Ev();
extern void _ZN6S247C63v37Ev();
extern void _ZN6S247C63v38Ev();
extern void _ZN6S247C63v39Ev();
extern void _ZN6S247C63v40Ev();
extern void _ZN6S247C63v41Ev();
extern void _ZN6S247C63v42Ev();
extern void _ZN6S247C63v43Ev();
extern void _ZN6S247C63v44Ev();
extern void _ZN6S247C63v45Ev();
extern void _ZN6S247C63v46Ev();
extern void _ZN6S247C63v47Ev();
extern void _ZN6S247C63v48Ev();
extern void _ZN6S247C63v49Ev();
extern void _ZN6S247C63v50Ev();
extern void _ZN6S247C63v51Ev();
extern void _ZN6S247C63v52Ev();
extern void _ZN6S247C63v53Ev();
extern void _ZN6S247C63v54Ev();
extern void _ZN6S247C63v55Ev();
extern void _ZN6S247C63v56Ev();
extern void _ZN6S247C63v57Ev();
extern void _ZN6S247C63v58Ev();
extern void _ZN6S247C63v59Ev();
extern void _ZN6S247C63v60Ev();
extern void _ZN6S247C63v61Ev();
extern void _ZN6S247C63v62Ev();
extern void _ZN6S247C63v63Ev();
extern void _ZN6S247C63v64Ev();
extern void _ZN6S247C63v65Ev();
extern void _ZN6S247C63v66Ev();
extern void _ZN6S247C63v67Ev();
extern void _ZN6S247C63v68Ev();
extern void _ZN6S247C53v69Ev();
extern void _ZN6S247C53v70Ev();
extern void _ZN6S247C53v71Ev();
extern void _ZN6S247C53v72Ev();
extern void _ZN6S247C53v73Ev();
extern void _ZN6S247C53v74Ev();
extern void _ZN6S247C53v75Ev();
extern void _ZN6S247C53v76Ev();
extern void _ZN6S247C53v77Ev();
extern void _ZN6S247C53v78Ev();
extern void _ZN6S247C53v79Ev();
extern void _ZN6S247C53v80Ev();
extern void _ZN6S247C53v81Ev();
extern void _ZN6S247C53v82Ev();
extern void _ZN6S247C53v83Ev();
extern void _ZN6S247C53v84Ev();
extern void _ZN6S247C53v85Ev();
extern void _ZN6S247C53v86Ev();
extern void _ZN6S247C53v87Ev();
extern void _ZN6S247C53v88Ev();
extern void _ZN6S247C53v89Ev();
extern void _ZN6S247C53v90Ev();
extern void _ZN6S247C43v91Ev();
extern void _ZN6S247C43v92Ev();
extern void _ZN6S247C43v93Ev();
extern void _ZN6S247C43v94Ev();
extern void _ZN6S247C43v95Ev();
extern void _ZN6S247C43v96Ev();
extern void _ZN6S247C43v97Ev();
extern void _ZN6S247C43v98Ev();
extern void _ZN6S247C43v99Ev();
extern void _ZN6S247C44v100Ev();
extern void _ZN6S247C44v101Ev();
extern void _ZN6S247C44v102Ev();
extern void _ZN6S247C44v103Ev();
extern void _ZN6S247C44v104Ev();
extern void _ZN6S247C44v105Ev();
extern void _ZN6S247C44v106Ev();
extern void _ZN6S247C44v107Ev();
extern void _ZN6S247C44v108Ev();
extern void _ZN6S247C44v109Ev();
extern void _ZN6S247C44v110Ev();
extern void _ZN6S247C34v111Ev();
extern void _ZN6S247C34v112Ev();
extern void _ZN6S247C34v113Ev();
extern void _ZN6S247C34v114Ev();
static  VTBL_ENTRY vtc_S247C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S247C3[0]),
  (VTBL_ENTRY)&_ZN6S247C3D1Ev,
  (VTBL_ENTRY)&_ZN6S247C3D0Ev,
  (VTBL_ENTRY)&_ZN6S247C62v5Ev,
  (VTBL_ENTRY)&_ZN6S247C62v6Ev,
  (VTBL_ENTRY)&_ZN6S247C62v7Ev,
  (VTBL_ENTRY)&_ZN6S247C62v8Ev,
  (VTBL_ENTRY)&_ZN6S247C62v9Ev,
  (VTBL_ENTRY)&_ZN6S247C63v10Ev,
  (VTBL_ENTRY)&_ZN6S247C63v11Ev,
  (VTBL_ENTRY)&_ZN6S247C63v12Ev,
  (VTBL_ENTRY)&_ZN6S247C63v13Ev,
  (VTBL_ENTRY)&_ZN6S247C63v14Ev,
  (VTBL_ENTRY)&_ZN6S247C63v15Ev,
  (VTBL_ENTRY)&_ZN6S247C63v16Ev,
  (VTBL_ENTRY)&_ZN6S247C63v17Ev,
  (VTBL_ENTRY)&_ZN6S247C63v18Ev,
  (VTBL_ENTRY)&_ZN6S247C63v19Ev,
  (VTBL_ENTRY)&_ZN6S247C63v20Ev,
  (VTBL_ENTRY)&_ZN6S247C63v21Ev,
  (VTBL_ENTRY)&_ZN6S247C63v22Ev,
  (VTBL_ENTRY)&_ZN6S247C63v23Ev,
  (VTBL_ENTRY)&_ZN6S247C63v24Ev,
  (VTBL_ENTRY)&_ZN6S247C63v25Ev,
  (VTBL_ENTRY)&_ZN6S247C63v26Ev,
  (VTBL_ENTRY)&_ZN6S247C63v27Ev,
  (VTBL_ENTRY)&_ZN6S247C63v28Ev,
  (VTBL_ENTRY)&_ZN6S247C63v29Ev,
  (VTBL_ENTRY)&_ZN6S247C63v30Ev,
  (VTBL_ENTRY)&_ZN6S247C63v31Ev,
  (VTBL_ENTRY)&_ZN6S247C63v32Ev,
  (VTBL_ENTRY)&_ZN6S247C63v33Ev,
  (VTBL_ENTRY)&_ZN6S247C63v34Ev,
  (VTBL_ENTRY)&_ZN6S247C63v35Ev,
  (VTBL_ENTRY)&_ZN6S247C63v36Ev,
  (VTBL_ENTRY)&_ZN6S247C63v37Ev,
  (VTBL_ENTRY)&_ZN6S247C63v38Ev,
  (VTBL_ENTRY)&_ZN6S247C63v39Ev,
  (VTBL_ENTRY)&_ZN6S247C63v40Ev,
  (VTBL_ENTRY)&_ZN6S247C63v41Ev,
  (VTBL_ENTRY)&_ZN6S247C63v42Ev,
  (VTBL_ENTRY)&_ZN6S247C63v43Ev,
  (VTBL_ENTRY)&_ZN6S247C63v44Ev,
  (VTBL_ENTRY)&_ZN6S247C63v45Ev,
  (VTBL_ENTRY)&_ZN6S247C63v46Ev,
  (VTBL_ENTRY)&_ZN6S247C63v47Ev,
  (VTBL_ENTRY)&_ZN6S247C63v48Ev,
  (VTBL_ENTRY)&_ZN6S247C63v49Ev,
  (VTBL_ENTRY)&_ZN6S247C63v50Ev,
  (VTBL_ENTRY)&_ZN6S247C63v51Ev,
  (VTBL_ENTRY)&_ZN6S247C63v52Ev,
  (VTBL_ENTRY)&_ZN6S247C63v53Ev,
  (VTBL_ENTRY)&_ZN6S247C63v54Ev,
  (VTBL_ENTRY)&_ZN6S247C63v55Ev,
  (VTBL_ENTRY)&_ZN6S247C63v56Ev,
  (VTBL_ENTRY)&_ZN6S247C63v57Ev,
  (VTBL_ENTRY)&_ZN6S247C63v58Ev,
  (VTBL_ENTRY)&_ZN6S247C63v59Ev,
  (VTBL_ENTRY)&_ZN6S247C63v60Ev,
  (VTBL_ENTRY)&_ZN6S247C63v61Ev,
  (VTBL_ENTRY)&_ZN6S247C63v62Ev,
  (VTBL_ENTRY)&_ZN6S247C63v63Ev,
  (VTBL_ENTRY)&_ZN6S247C63v64Ev,
  (VTBL_ENTRY)&_ZN6S247C63v65Ev,
  (VTBL_ENTRY)&_ZN6S247C63v66Ev,
  (VTBL_ENTRY)&_ZN6S247C63v67Ev,
  (VTBL_ENTRY)&_ZN6S247C63v68Ev,
  (VTBL_ENTRY)&_ZN6S247C53v69Ev,
  (VTBL_ENTRY)&_ZN6S247C53v70Ev,
  (VTBL_ENTRY)&_ZN6S247C53v71Ev,
  (VTBL_ENTRY)&_ZN6S247C53v72Ev,
  (VTBL_ENTRY)&_ZN6S247C53v73Ev,
  (VTBL_ENTRY)&_ZN6S247C53v74Ev,
  (VTBL_ENTRY)&_ZN6S247C53v75Ev,
  (VTBL_ENTRY)&_ZN6S247C53v76Ev,
  (VTBL_ENTRY)&_ZN6S247C53v77Ev,
  (VTBL_ENTRY)&_ZN6S247C53v78Ev,
  (VTBL_ENTRY)&_ZN6S247C53v79Ev,
  (VTBL_ENTRY)&_ZN6S247C53v80Ev,
  (VTBL_ENTRY)&_ZN6S247C53v81Ev,
  (VTBL_ENTRY)&_ZN6S247C53v82Ev,
  (VTBL_ENTRY)&_ZN6S247C53v83Ev,
  (VTBL_ENTRY)&_ZN6S247C53v84Ev,
  (VTBL_ENTRY)&_ZN6S247C53v85Ev,
  (VTBL_ENTRY)&_ZN6S247C53v86Ev,
  (VTBL_ENTRY)&_ZN6S247C53v87Ev,
  (VTBL_ENTRY)&_ZN6S247C53v88Ev,
  (VTBL_ENTRY)&_ZN6S247C53v89Ev,
  (VTBL_ENTRY)&_ZN6S247C53v90Ev,
  (VTBL_ENTRY)&_ZN6S247C43v91Ev,
  (VTBL_ENTRY)&_ZN6S247C43v92Ev,
  (VTBL_ENTRY)&_ZN6S247C43v93Ev,
  (VTBL_ENTRY)&_ZN6S247C43v94Ev,
  (VTBL_ENTRY)&_ZN6S247C43v95Ev,
  (VTBL_ENTRY)&_ZN6S247C43v96Ev,
  (VTBL_ENTRY)&_ZN6S247C43v97Ev,
  (VTBL_ENTRY)&_ZN6S247C43v98Ev,
  (VTBL_ENTRY)&_ZN6S247C43v99Ev,
  (VTBL_ENTRY)&_ZN6S247C44v100Ev,
  (VTBL_ENTRY)&_ZN6S247C44v101Ev,
  (VTBL_ENTRY)&_ZN6S247C44v102Ev,
  (VTBL_ENTRY)&_ZN6S247C44v103Ev,
  (VTBL_ENTRY)&_ZN6S247C44v104Ev,
  (VTBL_ENTRY)&_ZN6S247C44v105Ev,
  (VTBL_ENTRY)&_ZN6S247C44v106Ev,
  (VTBL_ENTRY)&_ZN6S247C44v107Ev,
  (VTBL_ENTRY)&_ZN6S247C44v108Ev,
  (VTBL_ENTRY)&_ZN6S247C44v109Ev,
  (VTBL_ENTRY)&_ZN6S247C44v110Ev,
  (VTBL_ENTRY)&_ZN6S247C34v111Ev,
  (VTBL_ENTRY)&_ZN6S247C34v112Ev,
  (VTBL_ENTRY)&_ZN6S247C34v113Ev,
  (VTBL_ENTRY)&_ZN6S247C34v114Ev,
};
extern VTBL_ENTRY _ZTI6S247C3[];
extern  VTBL_ENTRY _ZTV6S247C3[];
Class_Descriptor cd_S247C3 = {  "S247C3", // class name
  bases_S247C3, 3,
  &(vtc_S247C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S247C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S247C3),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S247C2  : S247C3 {
  virtual  ~S247C2(); // _ZN6S247C2D1Ev
  virtual void  v115(); // _ZN6S247C24v115Ev
  virtual void  v116(); // _ZN6S247C24v116Ev
  S247C2(); // tgen
};
//SIG(-1 S247C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v109 v110 v111 v112 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2}


 S247C2 ::~S247C2(){ note_dtor("S247C2", this);}
void  S247C2 ::v115(){vfunc_called(this, "_ZN6S247C24v115Ev");}
void  S247C2 ::v116(){vfunc_called(this, "_ZN6S247C24v116Ev");}
S247C2 ::S247C2(){ note_ctor("S247C2", this);} // tgen

static void Test_S247C2()
{
  extern Class_Descriptor cd_S247C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S247C2, buf);
    S247C2 *dp, &lv = *(dp=new (buf) S247C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S247C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S247C2)");
    check_base_class_offset(lv, (S247C6*)(S247C5*)(S247C4*)(S247C3*), 0, "S247C2");
    check_base_class_offset(lv, (S247C5*)(S247C4*)(S247C3*), 0, "S247C2");
    check_base_class_offset(lv, (S247C4*)(S247C3*), 0, "S247C2");
    check_base_class_offset(lv, (S247C3*), 0, "S247C2");
    test_class_info(&lv, &cd_S247C2);
    dp->~S247C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS247C2(Test_S247C2, "S247C2", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S247C2C1Ev();
extern void _ZN6S247C2D1Ev();
Name_Map name_map_S247C2[] = {
  NSPAIR(_ZN6S247C2C1Ev),
  NSPAIR(_ZN6S247C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S247C6;
extern VTBL_ENTRY _ZTI6S247C6[];
extern  VTBL_ENTRY _ZTV6S247C6[];
extern Class_Descriptor cd_S247C5;
extern VTBL_ENTRY _ZTI6S247C5[];
extern  VTBL_ENTRY _ZTV6S247C5[];
extern Class_Descriptor cd_S247C4;
extern VTBL_ENTRY _ZTI6S247C4[];
extern  VTBL_ENTRY _ZTV6S247C4[];
extern Class_Descriptor cd_S247C3;
extern VTBL_ENTRY _ZTI6S247C3[];
extern  VTBL_ENTRY _ZTV6S247C3[];
static Base_Class bases_S247C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S247C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S247C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S247C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S247C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S247C2[];
extern void _ZN6S247C2D1Ev();
extern void _ZN6S247C2D0Ev();
extern void _ZN6S247C62v5Ev();
extern void _ZN6S247C62v6Ev();
extern void _ZN6S247C62v7Ev();
extern void _ZN6S247C62v8Ev();
extern void _ZN6S247C62v9Ev();
extern void _ZN6S247C63v10Ev();
extern void _ZN6S247C63v11Ev();
extern void _ZN6S247C63v12Ev();
extern void _ZN6S247C63v13Ev();
extern void _ZN6S247C63v14Ev();
extern void _ZN6S247C63v15Ev();
extern void _ZN6S247C63v16Ev();
extern void _ZN6S247C63v17Ev();
extern void _ZN6S247C63v18Ev();
extern void _ZN6S247C63v19Ev();
extern void _ZN6S247C63v20Ev();
extern void _ZN6S247C63v21Ev();
extern void _ZN6S247C63v22Ev();
extern void _ZN6S247C63v23Ev();
extern void _ZN6S247C63v24Ev();
extern void _ZN6S247C63v25Ev();
extern void _ZN6S247C63v26Ev();
extern void _ZN6S247C63v27Ev();
extern void _ZN6S247C63v28Ev();
extern void _ZN6S247C63v29Ev();
extern void _ZN6S247C63v30Ev();
extern void _ZN6S247C63v31Ev();
extern void _ZN6S247C63v32Ev();
extern void _ZN6S247C63v33Ev();
extern void _ZN6S247C63v34Ev();
extern void _ZN6S247C63v35Ev();
extern void _ZN6S247C63v36Ev();
extern void _ZN6S247C63v37Ev();
extern void _ZN6S247C63v38Ev();
extern void _ZN6S247C63v39Ev();
extern void _ZN6S247C63v40Ev();
extern void _ZN6S247C63v41Ev();
extern void _ZN6S247C63v42Ev();
extern void _ZN6S247C63v43Ev();
extern void _ZN6S247C63v44Ev();
extern void _ZN6S247C63v45Ev();
extern void _ZN6S247C63v46Ev();
extern void _ZN6S247C63v47Ev();
extern void _ZN6S247C63v48Ev();
extern void _ZN6S247C63v49Ev();
extern void _ZN6S247C63v50Ev();
extern void _ZN6S247C63v51Ev();
extern void _ZN6S247C63v52Ev();
extern void _ZN6S247C63v53Ev();
extern void _ZN6S247C63v54Ev();
extern void _ZN6S247C63v55Ev();
extern void _ZN6S247C63v56Ev();
extern void _ZN6S247C63v57Ev();
extern void _ZN6S247C63v58Ev();
extern void _ZN6S247C63v59Ev();
extern void _ZN6S247C63v60Ev();
extern void _ZN6S247C63v61Ev();
extern void _ZN6S247C63v62Ev();
extern void _ZN6S247C63v63Ev();
extern void _ZN6S247C63v64Ev();
extern void _ZN6S247C63v65Ev();
extern void _ZN6S247C63v66Ev();
extern void _ZN6S247C63v67Ev();
extern void _ZN6S247C63v68Ev();
extern void _ZN6S247C53v69Ev();
extern void _ZN6S247C53v70Ev();
extern void _ZN6S247C53v71Ev();
extern void _ZN6S247C53v72Ev();
extern void _ZN6S247C53v73Ev();
extern void _ZN6S247C53v74Ev();
extern void _ZN6S247C53v75Ev();
extern void _ZN6S247C53v76Ev();
extern void _ZN6S247C53v77Ev();
extern void _ZN6S247C53v78Ev();
extern void _ZN6S247C53v79Ev();
extern void _ZN6S247C53v80Ev();
extern void _ZN6S247C53v81Ev();
extern void _ZN6S247C53v82Ev();
extern void _ZN6S247C53v83Ev();
extern void _ZN6S247C53v84Ev();
extern void _ZN6S247C53v85Ev();
extern void _ZN6S247C53v86Ev();
extern void _ZN6S247C53v87Ev();
extern void _ZN6S247C53v88Ev();
extern void _ZN6S247C53v89Ev();
extern void _ZN6S247C53v90Ev();
extern void _ZN6S247C43v91Ev();
extern void _ZN6S247C43v92Ev();
extern void _ZN6S247C43v93Ev();
extern void _ZN6S247C43v94Ev();
extern void _ZN6S247C43v95Ev();
extern void _ZN6S247C43v96Ev();
extern void _ZN6S247C43v97Ev();
extern void _ZN6S247C43v98Ev();
extern void _ZN6S247C43v99Ev();
extern void _ZN6S247C44v100Ev();
extern void _ZN6S247C44v101Ev();
extern void _ZN6S247C44v102Ev();
extern void _ZN6S247C44v103Ev();
extern void _ZN6S247C44v104Ev();
extern void _ZN6S247C44v105Ev();
extern void _ZN6S247C44v106Ev();
extern void _ZN6S247C44v107Ev();
extern void _ZN6S247C44v108Ev();
extern void _ZN6S247C44v109Ev();
extern void _ZN6S247C44v110Ev();
extern void _ZN6S247C34v111Ev();
extern void _ZN6S247C34v112Ev();
extern void _ZN6S247C34v113Ev();
extern void _ZN6S247C34v114Ev();
extern void _ZN6S247C24v115Ev();
extern void _ZN6S247C24v116Ev();
static  VTBL_ENTRY vtc_S247C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S247C2[0]),
  (VTBL_ENTRY)&_ZN6S247C2D1Ev,
  (VTBL_ENTRY)&_ZN6S247C2D0Ev,
  (VTBL_ENTRY)&_ZN6S247C62v5Ev,
  (VTBL_ENTRY)&_ZN6S247C62v6Ev,
  (VTBL_ENTRY)&_ZN6S247C62v7Ev,
  (VTBL_ENTRY)&_ZN6S247C62v8Ev,
  (VTBL_ENTRY)&_ZN6S247C62v9Ev,
  (VTBL_ENTRY)&_ZN6S247C63v10Ev,
  (VTBL_ENTRY)&_ZN6S247C63v11Ev,
  (VTBL_ENTRY)&_ZN6S247C63v12Ev,
  (VTBL_ENTRY)&_ZN6S247C63v13Ev,
  (VTBL_ENTRY)&_ZN6S247C63v14Ev,
  (VTBL_ENTRY)&_ZN6S247C63v15Ev,
  (VTBL_ENTRY)&_ZN6S247C63v16Ev,
  (VTBL_ENTRY)&_ZN6S247C63v17Ev,
  (VTBL_ENTRY)&_ZN6S247C63v18Ev,
  (VTBL_ENTRY)&_ZN6S247C63v19Ev,
  (VTBL_ENTRY)&_ZN6S247C63v20Ev,
  (VTBL_ENTRY)&_ZN6S247C63v21Ev,
  (VTBL_ENTRY)&_ZN6S247C63v22Ev,
  (VTBL_ENTRY)&_ZN6S247C63v23Ev,
  (VTBL_ENTRY)&_ZN6S247C63v24Ev,
  (VTBL_ENTRY)&_ZN6S247C63v25Ev,
  (VTBL_ENTRY)&_ZN6S247C63v26Ev,
  (VTBL_ENTRY)&_ZN6S247C63v27Ev,
  (VTBL_ENTRY)&_ZN6S247C63v28Ev,
  (VTBL_ENTRY)&_ZN6S247C63v29Ev,
  (VTBL_ENTRY)&_ZN6S247C63v30Ev,
  (VTBL_ENTRY)&_ZN6S247C63v31Ev,
  (VTBL_ENTRY)&_ZN6S247C63v32Ev,
  (VTBL_ENTRY)&_ZN6S247C63v33Ev,
  (VTBL_ENTRY)&_ZN6S247C63v34Ev,
  (VTBL_ENTRY)&_ZN6S247C63v35Ev,
  (VTBL_ENTRY)&_ZN6S247C63v36Ev,
  (VTBL_ENTRY)&_ZN6S247C63v37Ev,
  (VTBL_ENTRY)&_ZN6S247C63v38Ev,
  (VTBL_ENTRY)&_ZN6S247C63v39Ev,
  (VTBL_ENTRY)&_ZN6S247C63v40Ev,
  (VTBL_ENTRY)&_ZN6S247C63v41Ev,
  (VTBL_ENTRY)&_ZN6S247C63v42Ev,
  (VTBL_ENTRY)&_ZN6S247C63v43Ev,
  (VTBL_ENTRY)&_ZN6S247C63v44Ev,
  (VTBL_ENTRY)&_ZN6S247C63v45Ev,
  (VTBL_ENTRY)&_ZN6S247C63v46Ev,
  (VTBL_ENTRY)&_ZN6S247C63v47Ev,
  (VTBL_ENTRY)&_ZN6S247C63v48Ev,
  (VTBL_ENTRY)&_ZN6S247C63v49Ev,
  (VTBL_ENTRY)&_ZN6S247C63v50Ev,
  (VTBL_ENTRY)&_ZN6S247C63v51Ev,
  (VTBL_ENTRY)&_ZN6S247C63v52Ev,
  (VTBL_ENTRY)&_ZN6S247C63v53Ev,
  (VTBL_ENTRY)&_ZN6S247C63v54Ev,
  (VTBL_ENTRY)&_ZN6S247C63v55Ev,
  (VTBL_ENTRY)&_ZN6S247C63v56Ev,
  (VTBL_ENTRY)&_ZN6S247C63v57Ev,
  (VTBL_ENTRY)&_ZN6S247C63v58Ev,
  (VTBL_ENTRY)&_ZN6S247C63v59Ev,
  (VTBL_ENTRY)&_ZN6S247C63v60Ev,
  (VTBL_ENTRY)&_ZN6S247C63v61Ev,
  (VTBL_ENTRY)&_ZN6S247C63v62Ev,
  (VTBL_ENTRY)&_ZN6S247C63v63Ev,
  (VTBL_ENTRY)&_ZN6S247C63v64Ev,
  (VTBL_ENTRY)&_ZN6S247C63v65Ev,
  (VTBL_ENTRY)&_ZN6S247C63v66Ev,
  (VTBL_ENTRY)&_ZN6S247C63v67Ev,
  (VTBL_ENTRY)&_ZN6S247C63v68Ev,
  (VTBL_ENTRY)&_ZN6S247C53v69Ev,
  (VTBL_ENTRY)&_ZN6S247C53v70Ev,
  (VTBL_ENTRY)&_ZN6S247C53v71Ev,
  (VTBL_ENTRY)&_ZN6S247C53v72Ev,
  (VTBL_ENTRY)&_ZN6S247C53v73Ev,
  (VTBL_ENTRY)&_ZN6S247C53v74Ev,
  (VTBL_ENTRY)&_ZN6S247C53v75Ev,
  (VTBL_ENTRY)&_ZN6S247C53v76Ev,
  (VTBL_ENTRY)&_ZN6S247C53v77Ev,
  (VTBL_ENTRY)&_ZN6S247C53v78Ev,
  (VTBL_ENTRY)&_ZN6S247C53v79Ev,
  (VTBL_ENTRY)&_ZN6S247C53v80Ev,
  (VTBL_ENTRY)&_ZN6S247C53v81Ev,
  (VTBL_ENTRY)&_ZN6S247C53v82Ev,
  (VTBL_ENTRY)&_ZN6S247C53v83Ev,
  (VTBL_ENTRY)&_ZN6S247C53v84Ev,
  (VTBL_ENTRY)&_ZN6S247C53v85Ev,
  (VTBL_ENTRY)&_ZN6S247C53v86Ev,
  (VTBL_ENTRY)&_ZN6S247C53v87Ev,
  (VTBL_ENTRY)&_ZN6S247C53v88Ev,
  (VTBL_ENTRY)&_ZN6S247C53v89Ev,
  (VTBL_ENTRY)&_ZN6S247C53v90Ev,
  (VTBL_ENTRY)&_ZN6S247C43v91Ev,
  (VTBL_ENTRY)&_ZN6S247C43v92Ev,
  (VTBL_ENTRY)&_ZN6S247C43v93Ev,
  (VTBL_ENTRY)&_ZN6S247C43v94Ev,
  (VTBL_ENTRY)&_ZN6S247C43v95Ev,
  (VTBL_ENTRY)&_ZN6S247C43v96Ev,
  (VTBL_ENTRY)&_ZN6S247C43v97Ev,
  (VTBL_ENTRY)&_ZN6S247C43v98Ev,
  (VTBL_ENTRY)&_ZN6S247C43v99Ev,
  (VTBL_ENTRY)&_ZN6S247C44v100Ev,
  (VTBL_ENTRY)&_ZN6S247C44v101Ev,
  (VTBL_ENTRY)&_ZN6S247C44v102Ev,
  (VTBL_ENTRY)&_ZN6S247C44v103Ev,
  (VTBL_ENTRY)&_ZN6S247C44v104Ev,
  (VTBL_ENTRY)&_ZN6S247C44v105Ev,
  (VTBL_ENTRY)&_ZN6S247C44v106Ev,
  (VTBL_ENTRY)&_ZN6S247C44v107Ev,
  (VTBL_ENTRY)&_ZN6S247C44v108Ev,
  (VTBL_ENTRY)&_ZN6S247C44v109Ev,
  (VTBL_ENTRY)&_ZN6S247C44v110Ev,
  (VTBL_ENTRY)&_ZN6S247C34v111Ev,
  (VTBL_ENTRY)&_ZN6S247C34v112Ev,
  (VTBL_ENTRY)&_ZN6S247C34v113Ev,
  (VTBL_ENTRY)&_ZN6S247C34v114Ev,
  (VTBL_ENTRY)&_ZN6S247C24v115Ev,
  (VTBL_ENTRY)&_ZN6S247C24v116Ev,
};
extern VTBL_ENTRY _ZTI6S247C2[];
extern  VTBL_ENTRY _ZTV6S247C2[];
Class_Descriptor cd_S247C2 = {  "S247C2", // class name
  bases_S247C2, 4,
  &(vtc_S247C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S247C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S247C2),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S247C1  : S247C2 {
  int s247c1f0;
  virtual  ~S247C1(); // _ZN6S247C1D1Ev
  virtual void  v1(); // _ZN6S247C12v1Ev
  virtual void  v2(); // _ZN6S247C12v2Ev
  virtual void  v3(); // _ZN6S247C12v3Ev
  virtual void  v4(); // _ZN6S247C12v4Ev
  S247C1(); // tgen
};
//SIG(1 S247C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v111 v112 v113 v114 FC7 Fi:1 FC21{ BC22{ BC11}}} vd v115 v116} vd v1 v2 v3 v4 Fi}


 S247C1 ::~S247C1(){ note_dtor("S247C1", this);}
void  S247C1 ::v1(){vfunc_called(this, "_ZN6S247C12v1Ev");}
void  S247C1 ::v2(){vfunc_called(this, "_ZN6S247C12v2Ev");}
void  S247C1 ::v3(){vfunc_called(this, "_ZN6S247C12v3Ev");}
void  S247C1 ::v4(){vfunc_called(this, "_ZN6S247C12v4Ev");}
S247C1 ::S247C1(){ note_ctor("S247C1", this);} // tgen

static void Test_S247C1()
{
  extern Class_Descriptor cd_S247C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,57)];
    init_test(&cd_S247C1, buf);
    S247C1 *dp, &lv = *(dp=new (buf) S247C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,224), "sizeof(S247C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S247C1)");
    check_base_class_offset(lv, (S247C6*)(S247C5*)(S247C4*)(S247C3*)(S247C2*), 0, "S247C1");
    check_base_class_offset(lv, (S247C5*)(S247C4*)(S247C3*)(S247C2*), 0, "S247C1");
    check_base_class_offset(lv, (S247C4*)(S247C3*)(S247C2*), 0, "S247C1");
    check_base_class_offset(lv, (S247C3*)(S247C2*), 0, "S247C1");
    check_base_class_offset(lv, (S247C2*), 0, "S247C1");
    check_field_offset(lv, s247c1f0, ABISELECT(296,220), "S247C1.s247c1f0");
    test_class_info(&lv, &cd_S247C1);
    dp->~S247C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS247C1(Test_S247C1, "S247C1", ABISELECT(304,224));

#else // __cplusplus

extern void _ZN6S247C1C1Ev();
extern void _ZN6S247C1D1Ev();
Name_Map name_map_S247C1[] = {
  NSPAIR(_ZN6S247C1C1Ev),
  NSPAIR(_ZN6S247C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S247C6;
extern VTBL_ENTRY _ZTI6S247C6[];
extern  VTBL_ENTRY _ZTV6S247C6[];
extern Class_Descriptor cd_S247C5;
extern VTBL_ENTRY _ZTI6S247C5[];
extern  VTBL_ENTRY _ZTV6S247C5[];
extern Class_Descriptor cd_S247C4;
extern VTBL_ENTRY _ZTI6S247C4[];
extern  VTBL_ENTRY _ZTV6S247C4[];
extern Class_Descriptor cd_S247C3;
extern VTBL_ENTRY _ZTI6S247C3[];
extern  VTBL_ENTRY _ZTV6S247C3[];
extern Class_Descriptor cd_S247C2;
extern VTBL_ENTRY _ZTI6S247C2[];
extern  VTBL_ENTRY _ZTV6S247C2[];
static Base_Class bases_S247C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S247C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S247C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S247C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S247C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S247C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S247C1[];
extern void _ZN6S247C1D1Ev();
extern void _ZN6S247C1D0Ev();
extern void _ZN6S247C62v5Ev();
extern void _ZN6S247C62v6Ev();
extern void _ZN6S247C62v7Ev();
extern void _ZN6S247C62v8Ev();
extern void _ZN6S247C62v9Ev();
extern void _ZN6S247C63v10Ev();
extern void _ZN6S247C63v11Ev();
extern void _ZN6S247C63v12Ev();
extern void _ZN6S247C63v13Ev();
extern void _ZN6S247C63v14Ev();
extern void _ZN6S247C63v15Ev();
extern void _ZN6S247C63v16Ev();
extern void _ZN6S247C63v17Ev();
extern void _ZN6S247C63v18Ev();
extern void _ZN6S247C63v19Ev();
extern void _ZN6S247C63v20Ev();
extern void _ZN6S247C63v21Ev();
extern void _ZN6S247C63v22Ev();
extern void _ZN6S247C63v23Ev();
extern void _ZN6S247C63v24Ev();
extern void _ZN6S247C63v25Ev();
extern void _ZN6S247C63v26Ev();
extern void _ZN6S247C63v27Ev();
extern void _ZN6S247C63v28Ev();
extern void _ZN6S247C63v29Ev();
extern void _ZN6S247C63v30Ev();
extern void _ZN6S247C63v31Ev();
extern void _ZN6S247C63v32Ev();
extern void _ZN6S247C63v33Ev();
extern void _ZN6S247C63v34Ev();
extern void _ZN6S247C63v35Ev();
extern void _ZN6S247C63v36Ev();
extern void _ZN6S247C63v37Ev();
extern void _ZN6S247C63v38Ev();
extern void _ZN6S247C63v39Ev();
extern void _ZN6S247C63v40Ev();
extern void _ZN6S247C63v41Ev();
extern void _ZN6S247C63v42Ev();
extern void _ZN6S247C63v43Ev();
extern void _ZN6S247C63v44Ev();
extern void _ZN6S247C63v45Ev();
extern void _ZN6S247C63v46Ev();
extern void _ZN6S247C63v47Ev();
extern void _ZN6S247C63v48Ev();
extern void _ZN6S247C63v49Ev();
extern void _ZN6S247C63v50Ev();
extern void _ZN6S247C63v51Ev();
extern void _ZN6S247C63v52Ev();
extern void _ZN6S247C63v53Ev();
extern void _ZN6S247C63v54Ev();
extern void _ZN6S247C63v55Ev();
extern void _ZN6S247C63v56Ev();
extern void _ZN6S247C63v57Ev();
extern void _ZN6S247C63v58Ev();
extern void _ZN6S247C63v59Ev();
extern void _ZN6S247C63v60Ev();
extern void _ZN6S247C63v61Ev();
extern void _ZN6S247C63v62Ev();
extern void _ZN6S247C63v63Ev();
extern void _ZN6S247C63v64Ev();
extern void _ZN6S247C63v65Ev();
extern void _ZN6S247C63v66Ev();
extern void _ZN6S247C63v67Ev();
extern void _ZN6S247C63v68Ev();
extern void _ZN6S247C53v69Ev();
extern void _ZN6S247C53v70Ev();
extern void _ZN6S247C53v71Ev();
extern void _ZN6S247C53v72Ev();
extern void _ZN6S247C53v73Ev();
extern void _ZN6S247C53v74Ev();
extern void _ZN6S247C53v75Ev();
extern void _ZN6S247C53v76Ev();
extern void _ZN6S247C53v77Ev();
extern void _ZN6S247C53v78Ev();
extern void _ZN6S247C53v79Ev();
extern void _ZN6S247C53v80Ev();
extern void _ZN6S247C53v81Ev();
extern void _ZN6S247C53v82Ev();
extern void _ZN6S247C53v83Ev();
extern void _ZN6S247C53v84Ev();
extern void _ZN6S247C53v85Ev();
extern void _ZN6S247C53v86Ev();
extern void _ZN6S247C53v87Ev();
extern void _ZN6S247C53v88Ev();
extern void _ZN6S247C53v89Ev();
extern void _ZN6S247C53v90Ev();
extern void _ZN6S247C43v91Ev();
extern void _ZN6S247C43v92Ev();
extern void _ZN6S247C43v93Ev();
extern void _ZN6S247C43v94Ev();
extern void _ZN6S247C43v95Ev();
extern void _ZN6S247C43v96Ev();
extern void _ZN6S247C43v97Ev();
extern void _ZN6S247C43v98Ev();
extern void _ZN6S247C43v99Ev();
extern void _ZN6S247C44v100Ev();
extern void _ZN6S247C44v101Ev();
extern void _ZN6S247C44v102Ev();
extern void _ZN6S247C44v103Ev();
extern void _ZN6S247C44v104Ev();
extern void _ZN6S247C44v105Ev();
extern void _ZN6S247C44v106Ev();
extern void _ZN6S247C44v107Ev();
extern void _ZN6S247C44v108Ev();
extern void _ZN6S247C44v109Ev();
extern void _ZN6S247C44v110Ev();
extern void _ZN6S247C34v111Ev();
extern void _ZN6S247C34v112Ev();
extern void _ZN6S247C34v113Ev();
extern void _ZN6S247C34v114Ev();
extern void _ZN6S247C24v115Ev();
extern void _ZN6S247C24v116Ev();
extern void _ZN6S247C12v1Ev();
extern void _ZN6S247C12v2Ev();
extern void _ZN6S247C12v3Ev();
extern void _ZN6S247C12v4Ev();
static  VTBL_ENTRY vtc_S247C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S247C1[0]),
  (VTBL_ENTRY)&_ZN6S247C1D1Ev,
  (VTBL_ENTRY)&_ZN6S247C1D0Ev,
  (VTBL_ENTRY)&_ZN6S247C62v5Ev,
  (VTBL_ENTRY)&_ZN6S247C62v6Ev,
  (VTBL_ENTRY)&_ZN6S247C62v7Ev,
  (VTBL_ENTRY)&_ZN6S247C62v8Ev,
  (VTBL_ENTRY)&_ZN6S247C62v9Ev,
  (VTBL_ENTRY)&_ZN6S247C63v10Ev,
  (VTBL_ENTRY)&_ZN6S247C63v11Ev,
  (VTBL_ENTRY)&_ZN6S247C63v12Ev,
  (VTBL_ENTRY)&_ZN6S247C63v13Ev,
  (VTBL_ENTRY)&_ZN6S247C63v14Ev,
  (VTBL_ENTRY)&_ZN6S247C63v15Ev,
  (VTBL_ENTRY)&_ZN6S247C63v16Ev,
  (VTBL_ENTRY)&_ZN6S247C63v17Ev,
  (VTBL_ENTRY)&_ZN6S247C63v18Ev,
  (VTBL_ENTRY)&_ZN6S247C63v19Ev,
  (VTBL_ENTRY)&_ZN6S247C63v20Ev,
  (VTBL_ENTRY)&_ZN6S247C63v21Ev,
  (VTBL_ENTRY)&_ZN6S247C63v22Ev,
  (VTBL_ENTRY)&_ZN6S247C63v23Ev,
  (VTBL_ENTRY)&_ZN6S247C63v24Ev,
  (VTBL_ENTRY)&_ZN6S247C63v25Ev,
  (VTBL_ENTRY)&_ZN6S247C63v26Ev,
  (VTBL_ENTRY)&_ZN6S247C63v27Ev,
  (VTBL_ENTRY)&_ZN6S247C63v28Ev,
  (VTBL_ENTRY)&_ZN6S247C63v29Ev,
  (VTBL_ENTRY)&_ZN6S247C63v30Ev,
  (VTBL_ENTRY)&_ZN6S247C63v31Ev,
  (VTBL_ENTRY)&_ZN6S247C63v32Ev,
  (VTBL_ENTRY)&_ZN6S247C63v33Ev,
  (VTBL_ENTRY)&_ZN6S247C63v34Ev,
  (VTBL_ENTRY)&_ZN6S247C63v35Ev,
  (VTBL_ENTRY)&_ZN6S247C63v36Ev,
  (VTBL_ENTRY)&_ZN6S247C63v37Ev,
  (VTBL_ENTRY)&_ZN6S247C63v38Ev,
  (VTBL_ENTRY)&_ZN6S247C63v39Ev,
  (VTBL_ENTRY)&_ZN6S247C63v40Ev,
  (VTBL_ENTRY)&_ZN6S247C63v41Ev,
  (VTBL_ENTRY)&_ZN6S247C63v42Ev,
  (VTBL_ENTRY)&_ZN6S247C63v43Ev,
  (VTBL_ENTRY)&_ZN6S247C63v44Ev,
  (VTBL_ENTRY)&_ZN6S247C63v45Ev,
  (VTBL_ENTRY)&_ZN6S247C63v46Ev,
  (VTBL_ENTRY)&_ZN6S247C63v47Ev,
  (VTBL_ENTRY)&_ZN6S247C63v48Ev,
  (VTBL_ENTRY)&_ZN6S247C63v49Ev,
  (VTBL_ENTRY)&_ZN6S247C63v50Ev,
  (VTBL_ENTRY)&_ZN6S247C63v51Ev,
  (VTBL_ENTRY)&_ZN6S247C63v52Ev,
  (VTBL_ENTRY)&_ZN6S247C63v53Ev,
  (VTBL_ENTRY)&_ZN6S247C63v54Ev,
  (VTBL_ENTRY)&_ZN6S247C63v55Ev,
  (VTBL_ENTRY)&_ZN6S247C63v56Ev,
  (VTBL_ENTRY)&_ZN6S247C63v57Ev,
  (VTBL_ENTRY)&_ZN6S247C63v58Ev,
  (VTBL_ENTRY)&_ZN6S247C63v59Ev,
  (VTBL_ENTRY)&_ZN6S247C63v60Ev,
  (VTBL_ENTRY)&_ZN6S247C63v61Ev,
  (VTBL_ENTRY)&_ZN6S247C63v62Ev,
  (VTBL_ENTRY)&_ZN6S247C63v63Ev,
  (VTBL_ENTRY)&_ZN6S247C63v64Ev,
  (VTBL_ENTRY)&_ZN6S247C63v65Ev,
  (VTBL_ENTRY)&_ZN6S247C63v66Ev,
  (VTBL_ENTRY)&_ZN6S247C63v67Ev,
  (VTBL_ENTRY)&_ZN6S247C63v68Ev,
  (VTBL_ENTRY)&_ZN6S247C53v69Ev,
  (VTBL_ENTRY)&_ZN6S247C53v70Ev,
  (VTBL_ENTRY)&_ZN6S247C53v71Ev,
  (VTBL_ENTRY)&_ZN6S247C53v72Ev,
  (VTBL_ENTRY)&_ZN6S247C53v73Ev,
  (VTBL_ENTRY)&_ZN6S247C53v74Ev,
  (VTBL_ENTRY)&_ZN6S247C53v75Ev,
  (VTBL_ENTRY)&_ZN6S247C53v76Ev,
  (VTBL_ENTRY)&_ZN6S247C53v77Ev,
  (VTBL_ENTRY)&_ZN6S247C53v78Ev,
  (VTBL_ENTRY)&_ZN6S247C53v79Ev,
  (VTBL_ENTRY)&_ZN6S247C53v80Ev,
  (VTBL_ENTRY)&_ZN6S247C53v81Ev,
  (VTBL_ENTRY)&_ZN6S247C53v82Ev,
  (VTBL_ENTRY)&_ZN6S247C53v83Ev,
  (VTBL_ENTRY)&_ZN6S247C53v84Ev,
  (VTBL_ENTRY)&_ZN6S247C53v85Ev,
  (VTBL_ENTRY)&_ZN6S247C53v86Ev,
  (VTBL_ENTRY)&_ZN6S247C53v87Ev,
  (VTBL_ENTRY)&_ZN6S247C53v88Ev,
  (VTBL_ENTRY)&_ZN6S247C53v89Ev,
  (VTBL_ENTRY)&_ZN6S247C53v90Ev,
  (VTBL_ENTRY)&_ZN6S247C43v91Ev,
  (VTBL_ENTRY)&_ZN6S247C43v92Ev,
  (VTBL_ENTRY)&_ZN6S247C43v93Ev,
  (VTBL_ENTRY)&_ZN6S247C43v94Ev,
  (VTBL_ENTRY)&_ZN6S247C43v95Ev,
  (VTBL_ENTRY)&_ZN6S247C43v96Ev,
  (VTBL_ENTRY)&_ZN6S247C43v97Ev,
  (VTBL_ENTRY)&_ZN6S247C43v98Ev,
  (VTBL_ENTRY)&_ZN6S247C43v99Ev,
  (VTBL_ENTRY)&_ZN6S247C44v100Ev,
  (VTBL_ENTRY)&_ZN6S247C44v101Ev,
  (VTBL_ENTRY)&_ZN6S247C44v102Ev,
  (VTBL_ENTRY)&_ZN6S247C44v103Ev,
  (VTBL_ENTRY)&_ZN6S247C44v104Ev,
  (VTBL_ENTRY)&_ZN6S247C44v105Ev,
  (VTBL_ENTRY)&_ZN6S247C44v106Ev,
  (VTBL_ENTRY)&_ZN6S247C44v107Ev,
  (VTBL_ENTRY)&_ZN6S247C44v108Ev,
  (VTBL_ENTRY)&_ZN6S247C44v109Ev,
  (VTBL_ENTRY)&_ZN6S247C44v110Ev,
  (VTBL_ENTRY)&_ZN6S247C34v111Ev,
  (VTBL_ENTRY)&_ZN6S247C34v112Ev,
  (VTBL_ENTRY)&_ZN6S247C34v113Ev,
  (VTBL_ENTRY)&_ZN6S247C34v114Ev,
  (VTBL_ENTRY)&_ZN6S247C24v115Ev,
  (VTBL_ENTRY)&_ZN6S247C24v116Ev,
  (VTBL_ENTRY)&_ZN6S247C12v1Ev,
  (VTBL_ENTRY)&_ZN6S247C12v2Ev,
  (VTBL_ENTRY)&_ZN6S247C12v3Ev,
  (VTBL_ENTRY)&_ZN6S247C12v4Ev,
};
extern VTBL_ENTRY _ZTI6S247C1[];
extern  VTBL_ENTRY _ZTV6S247C1[];
Class_Descriptor cd_S247C1 = {  "S247C1", // class name
  bases_S247C1, 5,
  &(vtc_S247C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,224), // object size
  NSPAIRA(_ZTI6S247C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S247C1),120, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S212C6  {
  int s212c6f0;
  __tsi64 s212c6f1;
  void *s212c6f2[4];
  int s212c6f3[2];
  void *s212c6f4;
  ::S1503C5_nt s212c6f5;
  void *s212c6f6[2];
  virtual  ~S212C6(); // _ZN6S212C6D1Ev
  virtual void  v4(); // _ZN6S212C62v4Ev
  virtual void  v5(); // _ZN6S212C62v5Ev
  virtual void  v6(); // _ZN6S212C62v6Ev
  virtual void  v7(); // _ZN6S212C62v7Ev
  virtual void  v8(); // _ZN6S212C62v8Ev
  virtual void  v9(); // _ZN6S212C62v9Ev
  virtual void  v10(); // _ZN6S212C63v10Ev
  virtual void  v11(); // _ZN6S212C63v11Ev
  virtual void  v12(); // _ZN6S212C63v12Ev
  virtual void  v13(); // _ZN6S212C63v13Ev
  virtual void  v14(); // _ZN6S212C63v14Ev
  virtual void  v15(); // _ZN6S212C63v15Ev
  virtual void  v16(); // _ZN6S212C63v16Ev
  virtual void  v17(); // _ZN6S212C63v17Ev
  virtual void  v18(); // _ZN6S212C63v18Ev
  virtual void  v19(); // _ZN6S212C63v19Ev
  virtual void  v20(); // _ZN6S212C63v20Ev
  virtual void  v21(); // _ZN6S212C63v21Ev
  virtual void  v22(); // _ZN6S212C63v22Ev
  virtual void  v23(); // _ZN6S212C63v23Ev
  virtual void  v24(); // _ZN6S212C63v24Ev
  virtual void  v25(); // _ZN6S212C63v25Ev
  virtual void  v26(); // _ZN6S212C63v26Ev
  virtual void  v27(); // _ZN6S212C63v27Ev
  virtual void  v28(); // _ZN6S212C63v28Ev
  virtual void  v29(); // _ZN6S212C63v29Ev
  virtual void  v30(); // _ZN6S212C63v30Ev
  virtual void  v31(); // _ZN6S212C63v31Ev
  virtual void  v32(); // _ZN6S212C63v32Ev
  virtual void  v33(); // _ZN6S212C63v33Ev
  virtual void  v34(); // _ZN6S212C63v34Ev
  virtual void  v35(); // _ZN6S212C63v35Ev
  virtual void  v36(); // _ZN6S212C63v36Ev
  virtual void  v37(); // _ZN6S212C63v37Ev
  virtual void  v38(); // _ZN6S212C63v38Ev
  virtual void  v39(); // _ZN6S212C63v39Ev
  virtual void  v40(); // _ZN6S212C63v40Ev
  virtual void  v41(); // _ZN6S212C63v41Ev
  virtual void  v42(); // _ZN6S212C63v42Ev
  virtual void  v43(); // _ZN6S212C63v43Ev
  virtual void  v44(); // _ZN6S212C63v44Ev
  virtual void  v45(); // _ZN6S212C63v45Ev
  virtual void  v46(); // _ZN6S212C63v46Ev
  virtual void  v47(); // _ZN6S212C63v47Ev
  virtual void  v48(); // _ZN6S212C63v48Ev
  virtual void  v49(); // _ZN6S212C63v49Ev
  virtual void  v50(); // _ZN6S212C63v50Ev
  virtual void  v51(); // _ZN6S212C63v51Ev
  virtual void  v52(); // _ZN6S212C63v52Ev
  virtual void  v53(); // _ZN6S212C63v53Ev
  virtual void  v54(); // _ZN6S212C63v54Ev
  virtual void  v55(); // _ZN6S212C63v55Ev
  virtual void  v56(); // _ZN6S212C63v56Ev
  virtual void  v57(); // _ZN6S212C63v57Ev
  virtual void  v58(); // _ZN6S212C63v58Ev
  virtual void  v59(); // _ZN6S212C63v59Ev
  virtual void  v60(); // _ZN6S212C63v60Ev
  virtual void  v61(); // _ZN6S212C63v61Ev
  virtual void  v62(); // _ZN6S212C63v62Ev
  virtual void  v63(); // _ZN6S212C63v63Ev
  virtual void  v64(); // _ZN6S212C63v64Ev
  virtual void  v65(); // _ZN6S212C63v65Ev
  virtual void  v66(); // _ZN6S212C63v66Ev
  virtual void  v67(); // _ZN6S212C63v67Ev
  S212C6(); // tgen
};
//SIG(-1 S212C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S212C6 ::~S212C6(){ note_dtor("S212C6", this);}
void  S212C6 ::v4(){vfunc_called(this, "_ZN6S212C62v4Ev");}
void  S212C6 ::v5(){vfunc_called(this, "_ZN6S212C62v5Ev");}
void  S212C6 ::v6(){vfunc_called(this, "_ZN6S212C62v6Ev");}
void  S212C6 ::v7(){vfunc_called(this, "_ZN6S212C62v7Ev");}
void  S212C6 ::v8(){vfunc_called(this, "_ZN6S212C62v8Ev");}
void  S212C6 ::v9(){vfunc_called(this, "_ZN6S212C62v9Ev");}
void  S212C6 ::v10(){vfunc_called(this, "_ZN6S212C63v10Ev");}
void  S212C6 ::v11(){vfunc_called(this, "_ZN6S212C63v11Ev");}
void  S212C6 ::v12(){vfunc_called(this, "_ZN6S212C63v12Ev");}
void  S212C6 ::v13(){vfunc_called(this, "_ZN6S212C63v13Ev");}
void  S212C6 ::v14(){vfunc_called(this, "_ZN6S212C63v14Ev");}
void  S212C6 ::v15(){vfunc_called(this, "_ZN6S212C63v15Ev");}
void  S212C6 ::v16(){vfunc_called(this, "_ZN6S212C63v16Ev");}
void  S212C6 ::v17(){vfunc_called(this, "_ZN6S212C63v17Ev");}
void  S212C6 ::v18(){vfunc_called(this, "_ZN6S212C63v18Ev");}
void  S212C6 ::v19(){vfunc_called(this, "_ZN6S212C63v19Ev");}
void  S212C6 ::v20(){vfunc_called(this, "_ZN6S212C63v20Ev");}
void  S212C6 ::v21(){vfunc_called(this, "_ZN6S212C63v21Ev");}
void  S212C6 ::v22(){vfunc_called(this, "_ZN6S212C63v22Ev");}
void  S212C6 ::v23(){vfunc_called(this, "_ZN6S212C63v23Ev");}
void  S212C6 ::v24(){vfunc_called(this, "_ZN6S212C63v24Ev");}
void  S212C6 ::v25(){vfunc_called(this, "_ZN6S212C63v25Ev");}
void  S212C6 ::v26(){vfunc_called(this, "_ZN6S212C63v26Ev");}
void  S212C6 ::v27(){vfunc_called(this, "_ZN6S212C63v27Ev");}
void  S212C6 ::v28(){vfunc_called(this, "_ZN6S212C63v28Ev");}
void  S212C6 ::v29(){vfunc_called(this, "_ZN6S212C63v29Ev");}
void  S212C6 ::v30(){vfunc_called(this, "_ZN6S212C63v30Ev");}
void  S212C6 ::v31(){vfunc_called(this, "_ZN6S212C63v31Ev");}
void  S212C6 ::v32(){vfunc_called(this, "_ZN6S212C63v32Ev");}
void  S212C6 ::v33(){vfunc_called(this, "_ZN6S212C63v33Ev");}
void  S212C6 ::v34(){vfunc_called(this, "_ZN6S212C63v34Ev");}
void  S212C6 ::v35(){vfunc_called(this, "_ZN6S212C63v35Ev");}
void  S212C6 ::v36(){vfunc_called(this, "_ZN6S212C63v36Ev");}
void  S212C6 ::v37(){vfunc_called(this, "_ZN6S212C63v37Ev");}
void  S212C6 ::v38(){vfunc_called(this, "_ZN6S212C63v38Ev");}
void  S212C6 ::v39(){vfunc_called(this, "_ZN6S212C63v39Ev");}
void  S212C6 ::v40(){vfunc_called(this, "_ZN6S212C63v40Ev");}
void  S212C6 ::v41(){vfunc_called(this, "_ZN6S212C63v41Ev");}
void  S212C6 ::v42(){vfunc_called(this, "_ZN6S212C63v42Ev");}
void  S212C6 ::v43(){vfunc_called(this, "_ZN6S212C63v43Ev");}
void  S212C6 ::v44(){vfunc_called(this, "_ZN6S212C63v44Ev");}
void  S212C6 ::v45(){vfunc_called(this, "_ZN6S212C63v45Ev");}
void  S212C6 ::v46(){vfunc_called(this, "_ZN6S212C63v46Ev");}
void  S212C6 ::v47(){vfunc_called(this, "_ZN6S212C63v47Ev");}
void  S212C6 ::v48(){vfunc_called(this, "_ZN6S212C63v48Ev");}
void  S212C6 ::v49(){vfunc_called(this, "_ZN6S212C63v49Ev");}
void  S212C6 ::v50(){vfunc_called(this, "_ZN6S212C63v50Ev");}
void  S212C6 ::v51(){vfunc_called(this, "_ZN6S212C63v51Ev");}
void  S212C6 ::v52(){vfunc_called(this, "_ZN6S212C63v52Ev");}
void  S212C6 ::v53(){vfunc_called(this, "_ZN6S212C63v53Ev");}
void  S212C6 ::v54(){vfunc_called(this, "_ZN6S212C63v54Ev");}
void  S212C6 ::v55(){vfunc_called(this, "_ZN6S212C63v55Ev");}
void  S212C6 ::v56(){vfunc_called(this, "_ZN6S212C63v56Ev");}
void  S212C6 ::v57(){vfunc_called(this, "_ZN6S212C63v57Ev");}
void  S212C6 ::v58(){vfunc_called(this, "_ZN6S212C63v58Ev");}
void  S212C6 ::v59(){vfunc_called(this, "_ZN6S212C63v59Ev");}
void  S212C6 ::v60(){vfunc_called(this, "_ZN6S212C63v60Ev");}
void  S212C6 ::v61(){vfunc_called(this, "_ZN6S212C63v61Ev");}
void  S212C6 ::v62(){vfunc_called(this, "_ZN6S212C63v62Ev");}
void  S212C6 ::v63(){vfunc_called(this, "_ZN6S212C63v63Ev");}
void  S212C6 ::v64(){vfunc_called(this, "_ZN6S212C63v64Ev");}
void  S212C6 ::v65(){vfunc_called(this, "_ZN6S212C63v65Ev");}
void  S212C6 ::v66(){vfunc_called(this, "_ZN6S212C63v66Ev");}
void  S212C6 ::v67(){vfunc_called(this, "_ZN6S212C63v67Ev");}
S212C6 ::S212C6(){ note_ctor("S212C6", this);} // tgen

static void Test_S212C6()
{
  extern Class_Descriptor cd_S212C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S212C6, buf);
    S212C6 *dp, &lv = *(dp=new (buf) S212C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S212C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S212C6)");
    check_field_offset(lv, s212c6f0, ABISELECT(8,4), "S212C6.s212c6f0");
    check_field_offset(lv, s212c6f1, ABISELECT(16,8), "S212C6.s212c6f1");
    check_field_offset(lv, s212c6f2, ABISELECT(24,16), "S212C6.s212c6f2");
    check_field_offset(lv, s212c6f3, ABISELECT(56,32), "S212C6.s212c6f3");
    check_field_offset(lv, s212c6f4, ABISELECT(64,40), "S212C6.s212c6f4");
    check_field_offset(lv, s212c6f5, ABISELECT(72,44), "S212C6.s212c6f5");
    check_field_offset(lv, s212c6f6, ABISELECT(80,52), "S212C6.s212c6f6");
    test_class_info(&lv, &cd_S212C6);
    dp->~S212C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS212C6(Test_S212C6, "S212C6", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S212C6C1Ev();
extern void _ZN6S212C6D1Ev();
Name_Map name_map_S212C6[] = {
  NSPAIR(_ZN6S212C6C1Ev),
  NSPAIR(_ZN6S212C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S212C6[];
extern void _ZN6S212C6D1Ev();
extern void _ZN6S212C6D0Ev();
extern void _ZN6S212C62v4Ev();
extern void _ZN6S212C62v5Ev();
extern void _ZN6S212C62v6Ev();
extern void _ZN6S212C62v7Ev();
extern void _ZN6S212C62v8Ev();
extern void _ZN6S212C62v9Ev();
extern void _ZN6S212C63v10Ev();
extern void _ZN6S212C63v11Ev();
extern void _ZN6S212C63v12Ev();
extern void _ZN6S212C63v13Ev();
extern void _ZN6S212C63v14Ev();
extern void _ZN6S212C63v15Ev();
extern void _ZN6S212C63v16Ev();
extern void _ZN6S212C63v17Ev();
extern void _ZN6S212C63v18Ev();
extern void _ZN6S212C63v19Ev();
extern void _ZN6S212C63v20Ev();
extern void _ZN6S212C63v21Ev();
extern void _ZN6S212C63v22Ev();
extern void _ZN6S212C63v23Ev();
extern void _ZN6S212C63v24Ev();
extern void _ZN6S212C63v25Ev();
extern void _ZN6S212C63v26Ev();
extern void _ZN6S212C63v27Ev();
extern void _ZN6S212C63v28Ev();
extern void _ZN6S212C63v29Ev();
extern void _ZN6S212C63v30Ev();
extern void _ZN6S212C63v31Ev();
extern void _ZN6S212C63v32Ev();
extern void _ZN6S212C63v33Ev();
extern void _ZN6S212C63v34Ev();
extern void _ZN6S212C63v35Ev();
extern void _ZN6S212C63v36Ev();
extern void _ZN6S212C63v37Ev();
extern void _ZN6S212C63v38Ev();
extern void _ZN6S212C63v39Ev();
extern void _ZN6S212C63v40Ev();
extern void _ZN6S212C63v41Ev();
extern void _ZN6S212C63v42Ev();
extern void _ZN6S212C63v43Ev();
extern void _ZN6S212C63v44Ev();
extern void _ZN6S212C63v45Ev();
extern void _ZN6S212C63v46Ev();
extern void _ZN6S212C63v47Ev();
extern void _ZN6S212C63v48Ev();
extern void _ZN6S212C63v49Ev();
extern void _ZN6S212C63v50Ev();
extern void _ZN6S212C63v51Ev();
extern void _ZN6S212C63v52Ev();
extern void _ZN6S212C63v53Ev();
extern void _ZN6S212C63v54Ev();
extern void _ZN6S212C63v55Ev();
extern void _ZN6S212C63v56Ev();
extern void _ZN6S212C63v57Ev();
extern void _ZN6S212C63v58Ev();
extern void _ZN6S212C63v59Ev();
extern void _ZN6S212C63v60Ev();
extern void _ZN6S212C63v61Ev();
extern void _ZN6S212C63v62Ev();
extern void _ZN6S212C63v63Ev();
extern void _ZN6S212C63v64Ev();
extern void _ZN6S212C63v65Ev();
extern void _ZN6S212C63v66Ev();
extern void _ZN6S212C63v67Ev();
static  VTBL_ENTRY vtc_S212C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S212C6[0]),
  (VTBL_ENTRY)&_ZN6S212C6D1Ev,
  (VTBL_ENTRY)&_ZN6S212C6D0Ev,
  (VTBL_ENTRY)&_ZN6S212C62v4Ev,
  (VTBL_ENTRY)&_ZN6S212C62v5Ev,
  (VTBL_ENTRY)&_ZN6S212C62v6Ev,
  (VTBL_ENTRY)&_ZN6S212C62v7Ev,
  (VTBL_ENTRY)&_ZN6S212C62v8Ev,
  (VTBL_ENTRY)&_ZN6S212C62v9Ev,
  (VTBL_ENTRY)&_ZN6S212C63v10Ev,
  (VTBL_ENTRY)&_ZN6S212C63v11Ev,
  (VTBL_ENTRY)&_ZN6S212C63v12Ev,
  (VTBL_ENTRY)&_ZN6S212C63v13Ev,
  (VTBL_ENTRY)&_ZN6S212C63v14Ev,
  (VTBL_ENTRY)&_ZN6S212C63v15Ev,
  (VTBL_ENTRY)&_ZN6S212C63v16Ev,
  (VTBL_ENTRY)&_ZN6S212C63v17Ev,
  (VTBL_ENTRY)&_ZN6S212C63v18Ev,
  (VTBL_ENTRY)&_ZN6S212C63v19Ev,
  (VTBL_ENTRY)&_ZN6S212C63v20Ev,
  (VTBL_ENTRY)&_ZN6S212C63v21Ev,
  (VTBL_ENTRY)&_ZN6S212C63v22Ev,
  (VTBL_ENTRY)&_ZN6S212C63v23Ev,
  (VTBL_ENTRY)&_ZN6S212C63v24Ev,
  (VTBL_ENTRY)&_ZN6S212C63v25Ev,
  (VTBL_ENTRY)&_ZN6S212C63v26Ev,
  (VTBL_ENTRY)&_ZN6S212C63v27Ev,
  (VTBL_ENTRY)&_ZN6S212C63v28Ev,
  (VTBL_ENTRY)&_ZN6S212C63v29Ev,
  (VTBL_ENTRY)&_ZN6S212C63v30Ev,
  (VTBL_ENTRY)&_ZN6S212C63v31Ev,
  (VTBL_ENTRY)&_ZN6S212C63v32Ev,
  (VTBL_ENTRY)&_ZN6S212C63v33Ev,
  (VTBL_ENTRY)&_ZN6S212C63v34Ev,
  (VTBL_ENTRY)&_ZN6S212C63v35Ev,
  (VTBL_ENTRY)&_ZN6S212C63v36Ev,
  (VTBL_ENTRY)&_ZN6S212C63v37Ev,
  (VTBL_ENTRY)&_ZN6S212C63v38Ev,
  (VTBL_ENTRY)&_ZN6S212C63v39Ev,
  (VTBL_ENTRY)&_ZN6S212C63v40Ev,
  (VTBL_ENTRY)&_ZN6S212C63v41Ev,
  (VTBL_ENTRY)&_ZN6S212C63v42Ev,
  (VTBL_ENTRY)&_ZN6S212C63v43Ev,
  (VTBL_ENTRY)&_ZN6S212C63v44Ev,
  (VTBL_ENTRY)&_ZN6S212C63v45Ev,
  (VTBL_ENTRY)&_ZN6S212C63v46Ev,
  (VTBL_ENTRY)&_ZN6S212C63v47Ev,
  (VTBL_ENTRY)&_ZN6S212C63v48Ev,
  (VTBL_ENTRY)&_ZN6S212C63v49Ev,
  (VTBL_ENTRY)&_ZN6S212C63v50Ev,
  (VTBL_ENTRY)&_ZN6S212C63v51Ev,
  (VTBL_ENTRY)&_ZN6S212C63v52Ev,
  (VTBL_ENTRY)&_ZN6S212C63v53Ev,
  (VTBL_ENTRY)&_ZN6S212C63v54Ev,
  (VTBL_ENTRY)&_ZN6S212C63v55Ev,
  (VTBL_ENTRY)&_ZN6S212C63v56Ev,
  (VTBL_ENTRY)&_ZN6S212C63v57Ev,
  (VTBL_ENTRY)&_ZN6S212C63v58Ev,
  (VTBL_ENTRY)&_ZN6S212C63v59Ev,
  (VTBL_ENTRY)&_ZN6S212C63v60Ev,
  (VTBL_ENTRY)&_ZN6S212C63v61Ev,
  (VTBL_ENTRY)&_ZN6S212C63v62Ev,
  (VTBL_ENTRY)&_ZN6S212C63v63Ev,
  (VTBL_ENTRY)&_ZN6S212C63v64Ev,
  (VTBL_ENTRY)&_ZN6S212C63v65Ev,
  (VTBL_ENTRY)&_ZN6S212C63v66Ev,
  (VTBL_ENTRY)&_ZN6S212C63v67Ev,
};
extern VTBL_ENTRY _ZTI6S212C6[];
extern  VTBL_ENTRY _ZTV6S212C6[];
Class_Descriptor cd_S212C6 = {  "S212C6", // class name
  0,0,//no base classes
  &(vtc_S212C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S212C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S212C6),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S212C5  : S212C6 {
  int s212c5f0[2];
  void *s212c5f1;
  int s212c5f2[2];
  ::S210C8_nt s212c5f3;
  ::S210C8_nt s212c5f4;
  ::S629C14 s212c5f5;
  ::S210C8_nt s212c5f6;
  unsigned int s212c5f7:1;
  unsigned int s212c5f8:1;
  unsigned int s212c5f9:1;
  unsigned int s212c5f10:1;
  unsigned int s212c5f11:1;
  int s212c5f12[2];
  virtual  ~S212C5(); // _ZN6S212C5D1Ev
  virtual void  v68(); // _ZN6S212C53v68Ev
  virtual void  v69(); // _ZN6S212C53v69Ev
  virtual void  v70(); // _ZN6S212C53v70Ev
  virtual void  v71(); // _ZN6S212C53v71Ev
  virtual void  v72(); // _ZN6S212C53v72Ev
  virtual void  v73(); // _ZN6S212C53v73Ev
  virtual void  v74(); // _ZN6S212C53v74Ev
  virtual void  v75(); // _ZN6S212C53v75Ev
  virtual void  v76(); // _ZN6S212C53v76Ev
  virtual void  v77(); // _ZN6S212C53v77Ev
  virtual void  v78(); // _ZN6S212C53v78Ev
  virtual void  v79(); // _ZN6S212C53v79Ev
  virtual void  v80(); // _ZN6S212C53v80Ev
  virtual void  v81(); // _ZN6S212C53v81Ev
  virtual void  v82(); // _ZN6S212C53v82Ev
  virtual void  v83(); // _ZN6S212C53v83Ev
  virtual void  v84(); // _ZN6S212C53v84Ev
  virtual void  v85(); // _ZN6S212C53v85Ev
  virtual void  v86(); // _ZN6S212C53v86Ev
  virtual void  v87(); // _ZN6S212C53v87Ev
  virtual void  v88(); // _ZN6S212C53v88Ev
  virtual void  v89(); // _ZN6S212C53v89Ev
  S212C5(); // tgen
};
//SIG(-1 S212C5) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S212C5 ::~S212C5(){ note_dtor("S212C5", this);}
void  S212C5 ::v68(){vfunc_called(this, "_ZN6S212C53v68Ev");}
void  S212C5 ::v69(){vfunc_called(this, "_ZN6S212C53v69Ev");}
void  S212C5 ::v70(){vfunc_called(this, "_ZN6S212C53v70Ev");}
void  S212C5 ::v71(){vfunc_called(this, "_ZN6S212C53v71Ev");}
void  S212C5 ::v72(){vfunc_called(this, "_ZN6S212C53v72Ev");}
void  S212C5 ::v73(){vfunc_called(this, "_ZN6S212C53v73Ev");}
void  S212C5 ::v74(){vfunc_called(this, "_ZN6S212C53v74Ev");}
void  S212C5 ::v75(){vfunc_called(this, "_ZN6S212C53v75Ev");}
void  S212C5 ::v76(){vfunc_called(this, "_ZN6S212C53v76Ev");}
void  S212C5 ::v77(){vfunc_called(this, "_ZN6S212C53v77Ev");}
void  S212C5 ::v78(){vfunc_called(this, "_ZN6S212C53v78Ev");}
void  S212C5 ::v79(){vfunc_called(this, "_ZN6S212C53v79Ev");}
void  S212C5 ::v80(){vfunc_called(this, "_ZN6S212C53v80Ev");}
void  S212C5 ::v81(){vfunc_called(this, "_ZN6S212C53v81Ev");}
void  S212C5 ::v82(){vfunc_called(this, "_ZN6S212C53v82Ev");}
void  S212C5 ::v83(){vfunc_called(this, "_ZN6S212C53v83Ev");}
void  S212C5 ::v84(){vfunc_called(this, "_ZN6S212C53v84Ev");}
void  S212C5 ::v85(){vfunc_called(this, "_ZN6S212C53v85Ev");}
void  S212C5 ::v86(){vfunc_called(this, "_ZN6S212C53v86Ev");}
void  S212C5 ::v87(){vfunc_called(this, "_ZN6S212C53v87Ev");}
void  S212C5 ::v88(){vfunc_called(this, "_ZN6S212C53v88Ev");}
void  S212C5 ::v89(){vfunc_called(this, "_ZN6S212C53v89Ev");}
S212C5 ::S212C5(){ note_ctor("S212C5", this);} // tgen

static void Test_S212C5()
{
  extern Class_Descriptor cd_S212C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S212C5, buf);
    S212C5 *dp, &lv = *(dp=new (buf) S212C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S212C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S212C5)");
    check_base_class_offset(lv, (S212C6*), 0, "S212C5");
    check_field_offset(lv, s212c5f0, ABISELECT(96,60), "S212C5.s212c5f0");
    check_field_offset(lv, s212c5f1, ABISELECT(104,68), "S212C5.s212c5f1");
    check_field_offset(lv, s212c5f2, ABISELECT(112,72), "S212C5.s212c5f2");
    check_field_offset(lv, s212c5f3, ABISELECT(120,80), "S212C5.s212c5f3");
    check_field_offset(lv, s212c5f4, ABISELECT(136,92), "S212C5.s212c5f4");
    check_field_offset(lv, s212c5f5, ABISELECT(152,104), "S212C5.s212c5f5");
    check_field_offset(lv, s212c5f6, ABISELECT(160,108), "S212C5.s212c5f6");
    set_bf_and_test(lv, s212c5f7, ABISELECT(176,120), 0, 1, 1, "S212C5");
    set_bf_and_test(lv, s212c5f8, ABISELECT(176,120), 1, 1, 1, "S212C5");
    set_bf_and_test(lv, s212c5f9, ABISELECT(176,120), 2, 1, 1, "S212C5");
    set_bf_and_test(lv, s212c5f10, ABISELECT(176,120), 3, 1, 1, "S212C5");
    set_bf_and_test(lv, s212c5f11, ABISELECT(176,120), 4, 1, 1, "S212C5");
    check_field_offset(lv, s212c5f12, ABISELECT(180,124), "S212C5.s212c5f12");
    test_class_info(&lv, &cd_S212C5);
    dp->~S212C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS212C5(Test_S212C5, "S212C5", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN6S212C5C1Ev();
extern void _ZN6S212C5D1Ev();
Name_Map name_map_S212C5[] = {
  NSPAIR(_ZN6S212C5C1Ev),
  NSPAIR(_ZN6S212C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S212C6;
extern VTBL_ENTRY _ZTI6S212C6[];
extern  VTBL_ENTRY _ZTV6S212C6[];
static Base_Class bases_S212C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S212C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S212C5[];
extern void _ZN6S212C5D1Ev();
extern void _ZN6S212C5D0Ev();
extern void _ZN6S212C62v4Ev();
extern void _ZN6S212C62v5Ev();
extern void _ZN6S212C62v6Ev();
extern void _ZN6S212C62v7Ev();
extern void _ZN6S212C62v8Ev();
extern void _ZN6S212C62v9Ev();
extern void _ZN6S212C63v10Ev();
extern void _ZN6S212C63v11Ev();
extern void _ZN6S212C63v12Ev();
extern void _ZN6S212C63v13Ev();
extern void _ZN6S212C63v14Ev();
extern void _ZN6S212C63v15Ev();
extern void _ZN6S212C63v16Ev();
extern void _ZN6S212C63v17Ev();
extern void _ZN6S212C63v18Ev();
extern void _ZN6S212C63v19Ev();
extern void _ZN6S212C63v20Ev();
extern void _ZN6S212C63v21Ev();
extern void _ZN6S212C63v22Ev();
extern void _ZN6S212C63v23Ev();
extern void _ZN6S212C63v24Ev();
extern void _ZN6S212C63v25Ev();
extern void _ZN6S212C63v26Ev();
extern void _ZN6S212C63v27Ev();
extern void _ZN6S212C63v28Ev();
extern void _ZN6S212C63v29Ev();
extern void _ZN6S212C63v30Ev();
extern void _ZN6S212C63v31Ev();
extern void _ZN6S212C63v32Ev();
extern void _ZN6S212C63v33Ev();
extern void _ZN6S212C63v34Ev();
extern void _ZN6S212C63v35Ev();
extern void _ZN6S212C63v36Ev();
extern void _ZN6S212C63v37Ev();
extern void _ZN6S212C63v38Ev();
extern void _ZN6S212C63v39Ev();
extern void _ZN6S212C63v40Ev();
extern void _ZN6S212C63v41Ev();
extern void _ZN6S212C63v42Ev();
extern void _ZN6S212C63v43Ev();
extern void _ZN6S212C63v44Ev();
extern void _ZN6S212C63v45Ev();
extern void _ZN6S212C63v46Ev();
extern void _ZN6S212C63v47Ev();
extern void _ZN6S212C63v48Ev();
extern void _ZN6S212C63v49Ev();
extern void _ZN6S212C63v50Ev();
extern void _ZN6S212C63v51Ev();
extern void _ZN6S212C63v52Ev();
extern void _ZN6S212C63v53Ev();
extern void _ZN6S212C63v54Ev();
extern void _ZN6S212C63v55Ev();
extern void _ZN6S212C63v56Ev();
extern void _ZN6S212C63v57Ev();
extern void _ZN6S212C63v58Ev();
extern void _ZN6S212C63v59Ev();
extern void _ZN6S212C63v60Ev();
extern void _ZN6S212C63v61Ev();
extern void _ZN6S212C63v62Ev();
extern void _ZN6S212C63v63Ev();
extern void _ZN6S212C63v64Ev();
extern void _ZN6S212C63v65Ev();
extern void _ZN6S212C63v66Ev();
extern void _ZN6S212C63v67Ev();
extern void _ZN6S212C53v68Ev();
extern void _ZN6S212C53v69Ev();
extern void _ZN6S212C53v70Ev();
extern void _ZN6S212C53v71Ev();
extern void _ZN6S212C53v72Ev();
extern void _ZN6S212C53v73Ev();
extern void _ZN6S212C53v74Ev();
extern void _ZN6S212C53v75Ev();
extern void _ZN6S212C53v76Ev();
extern void _ZN6S212C53v77Ev();
extern void _ZN6S212C53v78Ev();
extern void _ZN6S212C53v79Ev();
extern void _ZN6S212C53v80Ev();
extern void _ZN6S212C53v81Ev();
extern void _ZN6S212C53v82Ev();
extern void _ZN6S212C53v83Ev();
extern void _ZN6S212C53v84Ev();
extern void _ZN6S212C53v85Ev();
extern void _ZN6S212C53v86Ev();
extern void _ZN6S212C53v87Ev();
extern void _ZN6S212C53v88Ev();
extern void _ZN6S212C53v89Ev();
static  VTBL_ENTRY vtc_S212C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S212C5[0]),
  (VTBL_ENTRY)&_ZN6S212C5D1Ev,
  (VTBL_ENTRY)&_ZN6S212C5D0Ev,
  (VTBL_ENTRY)&_ZN6S212C62v4Ev,
  (VTBL_ENTRY)&_ZN6S212C62v5Ev,
  (VTBL_ENTRY)&_ZN6S212C62v6Ev,
  (VTBL_ENTRY)&_ZN6S212C62v7Ev,
  (VTBL_ENTRY)&_ZN6S212C62v8Ev,
  (VTBL_ENTRY)&_ZN6S212C62v9Ev,
  (VTBL_ENTRY)&_ZN6S212C63v10Ev,
  (VTBL_ENTRY)&_ZN6S212C63v11Ev,
  (VTBL_ENTRY)&_ZN6S212C63v12Ev,
  (VTBL_ENTRY)&_ZN6S212C63v13Ev,
  (VTBL_ENTRY)&_ZN6S212C63v14Ev,
  (VTBL_ENTRY)&_ZN6S212C63v15Ev,
  (VTBL_ENTRY)&_ZN6S212C63v16Ev,
  (VTBL_ENTRY)&_ZN6S212C63v17Ev,
  (VTBL_ENTRY)&_ZN6S212C63v18Ev,
  (VTBL_ENTRY)&_ZN6S212C63v19Ev,
  (VTBL_ENTRY)&_ZN6S212C63v20Ev,
  (VTBL_ENTRY)&_ZN6S212C63v21Ev,
  (VTBL_ENTRY)&_ZN6S212C63v22Ev,
  (VTBL_ENTRY)&_ZN6S212C63v23Ev,
  (VTBL_ENTRY)&_ZN6S212C63v24Ev,
  (VTBL_ENTRY)&_ZN6S212C63v25Ev,
  (VTBL_ENTRY)&_ZN6S212C63v26Ev,
  (VTBL_ENTRY)&_ZN6S212C63v27Ev,
  (VTBL_ENTRY)&_ZN6S212C63v28Ev,
  (VTBL_ENTRY)&_ZN6S212C63v29Ev,
  (VTBL_ENTRY)&_ZN6S212C63v30Ev,
  (VTBL_ENTRY)&_ZN6S212C63v31Ev,
  (VTBL_ENTRY)&_ZN6S212C63v32Ev,
  (VTBL_ENTRY)&_ZN6S212C63v33Ev,
  (VTBL_ENTRY)&_ZN6S212C63v34Ev,
  (VTBL_ENTRY)&_ZN6S212C63v35Ev,
  (VTBL_ENTRY)&_ZN6S212C63v36Ev,
  (VTBL_ENTRY)&_ZN6S212C63v37Ev,
  (VTBL_ENTRY)&_ZN6S212C63v38Ev,
  (VTBL_ENTRY)&_ZN6S212C63v39Ev,
  (VTBL_ENTRY)&_ZN6S212C63v40Ev,
  (VTBL_ENTRY)&_ZN6S212C63v41Ev,
  (VTBL_ENTRY)&_ZN6S212C63v42Ev,
  (VTBL_ENTRY)&_ZN6S212C63v43Ev,
  (VTBL_ENTRY)&_ZN6S212C63v44Ev,
  (VTBL_ENTRY)&_ZN6S212C63v45Ev,
  (VTBL_ENTRY)&_ZN6S212C63v46Ev,
  (VTBL_ENTRY)&_ZN6S212C63v47Ev,
  (VTBL_ENTRY)&_ZN6S212C63v48Ev,
  (VTBL_ENTRY)&_ZN6S212C63v49Ev,
  (VTBL_ENTRY)&_ZN6S212C63v50Ev,
  (VTBL_ENTRY)&_ZN6S212C63v51Ev,
  (VTBL_ENTRY)&_ZN6S212C63v52Ev,
  (VTBL_ENTRY)&_ZN6S212C63v53Ev,
  (VTBL_ENTRY)&_ZN6S212C63v54Ev,
  (VTBL_ENTRY)&_ZN6S212C63v55Ev,
  (VTBL_ENTRY)&_ZN6S212C63v56Ev,
  (VTBL_ENTRY)&_ZN6S212C63v57Ev,
  (VTBL_ENTRY)&_ZN6S212C63v58Ev,
  (VTBL_ENTRY)&_ZN6S212C63v59Ev,
  (VTBL_ENTRY)&_ZN6S212C63v60Ev,
  (VTBL_ENTRY)&_ZN6S212C63v61Ev,
  (VTBL_ENTRY)&_ZN6S212C63v62Ev,
  (VTBL_ENTRY)&_ZN6S212C63v63Ev,
  (VTBL_ENTRY)&_ZN6S212C63v64Ev,
  (VTBL_ENTRY)&_ZN6S212C63v65Ev,
  (VTBL_ENTRY)&_ZN6S212C63v66Ev,
  (VTBL_ENTRY)&_ZN6S212C63v67Ev,
  (VTBL_ENTRY)&_ZN6S212C53v68Ev,
  (VTBL_ENTRY)&_ZN6S212C53v69Ev,
  (VTBL_ENTRY)&_ZN6S212C53v70Ev,
  (VTBL_ENTRY)&_ZN6S212C53v71Ev,
  (VTBL_ENTRY)&_ZN6S212C53v72Ev,
  (VTBL_ENTRY)&_ZN6S212C53v73Ev,
  (VTBL_ENTRY)&_ZN6S212C53v74Ev,
  (VTBL_ENTRY)&_ZN6S212C53v75Ev,
  (VTBL_ENTRY)&_ZN6S212C53v76Ev,
  (VTBL_ENTRY)&_ZN6S212C53v77Ev,
  (VTBL_ENTRY)&_ZN6S212C53v78Ev,
  (VTBL_ENTRY)&_ZN6S212C53v79Ev,
  (VTBL_ENTRY)&_ZN6S212C53v80Ev,
  (VTBL_ENTRY)&_ZN6S212C53v81Ev,
  (VTBL_ENTRY)&_ZN6S212C53v82Ev,
  (VTBL_ENTRY)&_ZN6S212C53v83Ev,
  (VTBL_ENTRY)&_ZN6S212C53v84Ev,
  (VTBL_ENTRY)&_ZN6S212C53v85Ev,
  (VTBL_ENTRY)&_ZN6S212C53v86Ev,
  (VTBL_ENTRY)&_ZN6S212C53v87Ev,
  (VTBL_ENTRY)&_ZN6S212C53v88Ev,
  (VTBL_ENTRY)&_ZN6S212C53v89Ev,
};
extern VTBL_ENTRY _ZTI6S212C5[];
extern  VTBL_ENTRY _ZTV6S212C5[];
Class_Descriptor cd_S212C5 = {  "S212C5", // class name
  bases_S212C5, 1,
  &(vtc_S212C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI6S212C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S212C5),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S212C4  : S212C5 {
  unsigned int s212c4f0:1;
  unsigned int s212c4f1:1;
  unsigned int s212c4f2:1;
  ::S1503C28 s212c4f3;
  ::S1503C24 s212c4f4;
  ::S1503C18 s212c4f5;
  ::S1503C12 s212c4f6;
  int s212c4f7[3];
  virtual  ~S212C4(); // _ZN6S212C4D1Ev
  virtual void  v90(); // _ZN6S212C43v90Ev
  virtual void  v91(); // _ZN6S212C43v91Ev
  virtual void  v92(); // _ZN6S212C43v92Ev
  virtual void  v93(); // _ZN6S212C43v93Ev
  virtual void  v94(); // _ZN6S212C43v94Ev
  virtual void  v95(); // _ZN6S212C43v95Ev
  virtual void  v96(); // _ZN6S212C43v96Ev
  virtual void  v97(); // _ZN6S212C43v97Ev
  virtual void  v98(); // _ZN6S212C43v98Ev
  virtual void  v99(); // _ZN6S212C43v99Ev
  virtual void  v100(); // _ZN6S212C44v100Ev
  virtual void  v101(); // _ZN6S212C44v101Ev
  virtual void  v102(); // _ZN6S212C44v102Ev
  virtual void  v103(); // _ZN6S212C44v103Ev
  virtual void  v104(); // _ZN6S212C44v104Ev
  virtual void  v105(); // _ZN6S212C44v105Ev
  virtual void  v106(); // _ZN6S212C44v106Ev
  virtual void  v107(); // _ZN6S212C44v107Ev
  virtual void  v108(); // _ZN6S212C44v108Ev
  virtual void  v109(); // _ZN6S212C44v109Ev
  S212C4(); // tgen
};
//SIG(-1 S212C4) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S212C4 ::~S212C4(){ note_dtor("S212C4", this);}
void  S212C4 ::v90(){vfunc_called(this, "_ZN6S212C43v90Ev");}
void  S212C4 ::v91(){vfunc_called(this, "_ZN6S212C43v91Ev");}
void  S212C4 ::v92(){vfunc_called(this, "_ZN6S212C43v92Ev");}
void  S212C4 ::v93(){vfunc_called(this, "_ZN6S212C43v93Ev");}
void  S212C4 ::v94(){vfunc_called(this, "_ZN6S212C43v94Ev");}
void  S212C4 ::v95(){vfunc_called(this, "_ZN6S212C43v95Ev");}
void  S212C4 ::v96(){vfunc_called(this, "_ZN6S212C43v96Ev");}
void  S212C4 ::v97(){vfunc_called(this, "_ZN6S212C43v97Ev");}
void  S212C4 ::v98(){vfunc_called(this, "_ZN6S212C43v98Ev");}
void  S212C4 ::v99(){vfunc_called(this, "_ZN6S212C43v99Ev");}
void  S212C4 ::v100(){vfunc_called(this, "_ZN6S212C44v100Ev");}
void  S212C4 ::v101(){vfunc_called(this, "_ZN6S212C44v101Ev");}
void  S212C4 ::v102(){vfunc_called(this, "_ZN6S212C44v102Ev");}
void  S212C4 ::v103(){vfunc_called(this, "_ZN6S212C44v103Ev");}
void  S212C4 ::v104(){vfunc_called(this, "_ZN6S212C44v104Ev");}
void  S212C4 ::v105(){vfunc_called(this, "_ZN6S212C44v105Ev");}
void  S212C4 ::v106(){vfunc_called(this, "_ZN6S212C44v106Ev");}
void  S212C4 ::v107(){vfunc_called(this, "_ZN6S212C44v107Ev");}
void  S212C4 ::v108(){vfunc_called(this, "_ZN6S212C44v108Ev");}
void  S212C4 ::v109(){vfunc_called(this, "_ZN6S212C44v109Ev");}
S212C4 ::S212C4(){ note_ctor("S212C4", this);} // tgen

static void Test_S212C4()
{
  extern Class_Descriptor cd_S212C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S212C4, buf);
    S212C4 *dp, &lv = *(dp=new (buf) S212C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S212C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S212C4)");
    check_base_class_offset(lv, (S212C6*)(S212C5*), 0, "S212C4");
    check_base_class_offset(lv, (S212C5*), 0, "S212C4");
    set_bf_and_test(lv, s212c4f0, ABISELECT(188,132), 0, 1, 1, "S212C4");
    set_bf_and_test(lv, s212c4f1, ABISELECT(188,132), 1, 1, 1, "S212C4");
    set_bf_and_test(lv, s212c4f2, ABISELECT(188,132), 2, 1, 1, "S212C4");
    check_field_offset(lv, s212c4f3, ABISELECT(192,136), "S212C4.s212c4f3");
    check_field_offset(lv, s212c4f4, ABISELECT(208,148), "S212C4.s212c4f4");
    check_field_offset(lv, s212c4f5, ABISELECT(224,160), "S212C4.s212c4f5");
    check_field_offset(lv, s212c4f6, ABISELECT(240,172), "S212C4.s212c4f6");
    check_field_offset(lv, s212c4f7, ABISELECT(256,184), "S212C4.s212c4f7");
    test_class_info(&lv, &cd_S212C4);
    dp->~S212C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS212C4(Test_S212C4, "S212C4", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S212C4C1Ev();
extern void _ZN6S212C4D1Ev();
Name_Map name_map_S212C4[] = {
  NSPAIR(_ZN6S212C4C1Ev),
  NSPAIR(_ZN6S212C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S212C6;
extern VTBL_ENTRY _ZTI6S212C6[];
extern  VTBL_ENTRY _ZTV6S212C6[];
extern Class_Descriptor cd_S212C5;
extern VTBL_ENTRY _ZTI6S212C5[];
extern  VTBL_ENTRY _ZTV6S212C5[];
static Base_Class bases_S212C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S212C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S212C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S212C4[];
extern void _ZN6S212C4D1Ev();
extern void _ZN6S212C4D0Ev();
extern void _ZN6S212C62v4Ev();
extern void _ZN6S212C62v5Ev();
extern void _ZN6S212C62v6Ev();
extern void _ZN6S212C62v7Ev();
extern void _ZN6S212C62v8Ev();
extern void _ZN6S212C62v9Ev();
extern void _ZN6S212C63v10Ev();
extern void _ZN6S212C63v11Ev();
extern void _ZN6S212C63v12Ev();
extern void _ZN6S212C63v13Ev();
extern void _ZN6S212C63v14Ev();
extern void _ZN6S212C63v15Ev();
extern void _ZN6S212C63v16Ev();
extern void _ZN6S212C63v17Ev();
extern void _ZN6S212C63v18Ev();
extern void _ZN6S212C63v19Ev();
extern void _ZN6S212C63v20Ev();
extern void _ZN6S212C63v21Ev();
extern void _ZN6S212C63v22Ev();
extern void _ZN6S212C63v23Ev();
extern void _ZN6S212C63v24Ev();
extern void _ZN6S212C63v25Ev();
extern void _ZN6S212C63v26Ev();
extern void _ZN6S212C63v27Ev();
extern void _ZN6S212C63v28Ev();
extern void _ZN6S212C63v29Ev();
extern void _ZN6S212C63v30Ev();
extern void _ZN6S212C63v31Ev();
extern void _ZN6S212C63v32Ev();
extern void _ZN6S212C63v33Ev();
extern void _ZN6S212C63v34Ev();
extern void _ZN6S212C63v35Ev();
extern void _ZN6S212C63v36Ev();
extern void _ZN6S212C63v37Ev();
extern void _ZN6S212C63v38Ev();
extern void _ZN6S212C63v39Ev();
extern void _ZN6S212C63v40Ev();
extern void _ZN6S212C63v41Ev();
extern void _ZN6S212C63v42Ev();
extern void _ZN6S212C63v43Ev();
extern void _ZN6S212C63v44Ev();
extern void _ZN6S212C63v45Ev();
extern void _ZN6S212C63v46Ev();
extern void _ZN6S212C63v47Ev();
extern void _ZN6S212C63v48Ev();
extern void _ZN6S212C63v49Ev();
extern void _ZN6S212C63v50Ev();
extern void _ZN6S212C63v51Ev();
extern void _ZN6S212C63v52Ev();
extern void _ZN6S212C63v53Ev();
extern void _ZN6S212C63v54Ev();
extern void _ZN6S212C63v55Ev();
extern void _ZN6S212C63v56Ev();
extern void _ZN6S212C63v57Ev();
extern void _ZN6S212C63v58Ev();
extern void _ZN6S212C63v59Ev();
extern void _ZN6S212C63v60Ev();
extern void _ZN6S212C63v61Ev();
extern void _ZN6S212C63v62Ev();
extern void _ZN6S212C63v63Ev();
extern void _ZN6S212C63v64Ev();
extern void _ZN6S212C63v65Ev();
extern void _ZN6S212C63v66Ev();
extern void _ZN6S212C63v67Ev();
extern void _ZN6S212C53v68Ev();
extern void _ZN6S212C53v69Ev();
extern void _ZN6S212C53v70Ev();
extern void _ZN6S212C53v71Ev();
extern void _ZN6S212C53v72Ev();
extern void _ZN6S212C53v73Ev();
extern void _ZN6S212C53v74Ev();
extern void _ZN6S212C53v75Ev();
extern void _ZN6S212C53v76Ev();
extern void _ZN6S212C53v77Ev();
extern void _ZN6S212C53v78Ev();
extern void _ZN6S212C53v79Ev();
extern void _ZN6S212C53v80Ev();
extern void _ZN6S212C53v81Ev();
extern void _ZN6S212C53v82Ev();
extern void _ZN6S212C53v83Ev();
extern void _ZN6S212C53v84Ev();
extern void _ZN6S212C53v85Ev();
extern void _ZN6S212C53v86Ev();
extern void _ZN6S212C53v87Ev();
extern void _ZN6S212C53v88Ev();
extern void _ZN6S212C53v89Ev();
extern void _ZN6S212C43v90Ev();
extern void _ZN6S212C43v91Ev();
extern void _ZN6S212C43v92Ev();
extern void _ZN6S212C43v93Ev();
extern void _ZN6S212C43v94Ev();
extern void _ZN6S212C43v95Ev();
extern void _ZN6S212C43v96Ev();
extern void _ZN6S212C43v97Ev();
extern void _ZN6S212C43v98Ev();
extern void _ZN6S212C43v99Ev();
extern void _ZN6S212C44v100Ev();
extern void _ZN6S212C44v101Ev();
extern void _ZN6S212C44v102Ev();
extern void _ZN6S212C44v103Ev();
extern void _ZN6S212C44v104Ev();
extern void _ZN6S212C44v105Ev();
extern void _ZN6S212C44v106Ev();
extern void _ZN6S212C44v107Ev();
extern void _ZN6S212C44v108Ev();
extern void _ZN6S212C44v109Ev();
static  VTBL_ENTRY vtc_S212C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S212C4[0]),
  (VTBL_ENTRY)&_ZN6S212C4D1Ev,
  (VTBL_ENTRY)&_ZN6S212C4D0Ev,
  (VTBL_ENTRY)&_ZN6S212C62v4Ev,
  (VTBL_ENTRY)&_ZN6S212C62v5Ev,
  (VTBL_ENTRY)&_ZN6S212C62v6Ev,
  (VTBL_ENTRY)&_ZN6S212C62v7Ev,
  (VTBL_ENTRY)&_ZN6S212C62v8Ev,
  (VTBL_ENTRY)&_ZN6S212C62v9Ev,
  (VTBL_ENTRY)&_ZN6S212C63v10Ev,
  (VTBL_ENTRY)&_ZN6S212C63v11Ev,
  (VTBL_ENTRY)&_ZN6S212C63v12Ev,
  (VTBL_ENTRY)&_ZN6S212C63v13Ev,
  (VTBL_ENTRY)&_ZN6S212C63v14Ev,
  (VTBL_ENTRY)&_ZN6S212C63v15Ev,
  (VTBL_ENTRY)&_ZN6S212C63v16Ev,
  (VTBL_ENTRY)&_ZN6S212C63v17Ev,
  (VTBL_ENTRY)&_ZN6S212C63v18Ev,
  (VTBL_ENTRY)&_ZN6S212C63v19Ev,
  (VTBL_ENTRY)&_ZN6S212C63v20Ev,
  (VTBL_ENTRY)&_ZN6S212C63v21Ev,
  (VTBL_ENTRY)&_ZN6S212C63v22Ev,
  (VTBL_ENTRY)&_ZN6S212C63v23Ev,
  (VTBL_ENTRY)&_ZN6S212C63v24Ev,
  (VTBL_ENTRY)&_ZN6S212C63v25Ev,
  (VTBL_ENTRY)&_ZN6S212C63v26Ev,
  (VTBL_ENTRY)&_ZN6S212C63v27Ev,
  (VTBL_ENTRY)&_ZN6S212C63v28Ev,
  (VTBL_ENTRY)&_ZN6S212C63v29Ev,
  (VTBL_ENTRY)&_ZN6S212C63v30Ev,
  (VTBL_ENTRY)&_ZN6S212C63v31Ev,
  (VTBL_ENTRY)&_ZN6S212C63v32Ev,
  (VTBL_ENTRY)&_ZN6S212C63v33Ev,
  (VTBL_ENTRY)&_ZN6S212C63v34Ev,
  (VTBL_ENTRY)&_ZN6S212C63v35Ev,
  (VTBL_ENTRY)&_ZN6S212C63v36Ev,
  (VTBL_ENTRY)&_ZN6S212C63v37Ev,
  (VTBL_ENTRY)&_ZN6S212C63v38Ev,
  (VTBL_ENTRY)&_ZN6S212C63v39Ev,
  (VTBL_ENTRY)&_ZN6S212C63v40Ev,
  (VTBL_ENTRY)&_ZN6S212C63v41Ev,
  (VTBL_ENTRY)&_ZN6S212C63v42Ev,
  (VTBL_ENTRY)&_ZN6S212C63v43Ev,
  (VTBL_ENTRY)&_ZN6S212C63v44Ev,
  (VTBL_ENTRY)&_ZN6S212C63v45Ev,
  (VTBL_ENTRY)&_ZN6S212C63v46Ev,
  (VTBL_ENTRY)&_ZN6S212C63v47Ev,
  (VTBL_ENTRY)&_ZN6S212C63v48Ev,
  (VTBL_ENTRY)&_ZN6S212C63v49Ev,
  (VTBL_ENTRY)&_ZN6S212C63v50Ev,
  (VTBL_ENTRY)&_ZN6S212C63v51Ev,
  (VTBL_ENTRY)&_ZN6S212C63v52Ev,
  (VTBL_ENTRY)&_ZN6S212C63v53Ev,
  (VTBL_ENTRY)&_ZN6S212C63v54Ev,
  (VTBL_ENTRY)&_ZN6S212C63v55Ev,
  (VTBL_ENTRY)&_ZN6S212C63v56Ev,
  (VTBL_ENTRY)&_ZN6S212C63v57Ev,
  (VTBL_ENTRY)&_ZN6S212C63v58Ev,
  (VTBL_ENTRY)&_ZN6S212C63v59Ev,
  (VTBL_ENTRY)&_ZN6S212C63v60Ev,
  (VTBL_ENTRY)&_ZN6S212C63v61Ev,
  (VTBL_ENTRY)&_ZN6S212C63v62Ev,
  (VTBL_ENTRY)&_ZN6S212C63v63Ev,
  (VTBL_ENTRY)&_ZN6S212C63v64Ev,
  (VTBL_ENTRY)&_ZN6S212C63v65Ev,
  (VTBL_ENTRY)&_ZN6S212C63v66Ev,
  (VTBL_ENTRY)&_ZN6S212C63v67Ev,
  (VTBL_ENTRY)&_ZN6S212C53v68Ev,
  (VTBL_ENTRY)&_ZN6S212C53v69Ev,
  (VTBL_ENTRY)&_ZN6S212C53v70Ev,
  (VTBL_ENTRY)&_ZN6S212C53v71Ev,
  (VTBL_ENTRY)&_ZN6S212C53v72Ev,
  (VTBL_ENTRY)&_ZN6S212C53v73Ev,
  (VTBL_ENTRY)&_ZN6S212C53v74Ev,
  (VTBL_ENTRY)&_ZN6S212C53v75Ev,
  (VTBL_ENTRY)&_ZN6S212C53v76Ev,
  (VTBL_ENTRY)&_ZN6S212C53v77Ev,
  (VTBL_ENTRY)&_ZN6S212C53v78Ev,
  (VTBL_ENTRY)&_ZN6S212C53v79Ev,
  (VTBL_ENTRY)&_ZN6S212C53v80Ev,
  (VTBL_ENTRY)&_ZN6S212C53v81Ev,
  (VTBL_ENTRY)&_ZN6S212C53v82Ev,
  (VTBL_ENTRY)&_ZN6S212C53v83Ev,
  (VTBL_ENTRY)&_ZN6S212C53v84Ev,
  (VTBL_ENTRY)&_ZN6S212C53v85Ev,
  (VTBL_ENTRY)&_ZN6S212C53v86Ev,
  (VTBL_ENTRY)&_ZN6S212C53v87Ev,
  (VTBL_ENTRY)&_ZN6S212C53v88Ev,
  (VTBL_ENTRY)&_ZN6S212C53v89Ev,
  (VTBL_ENTRY)&_ZN6S212C43v90Ev,
  (VTBL_ENTRY)&_ZN6S212C43v91Ev,
  (VTBL_ENTRY)&_ZN6S212C43v92Ev,
  (VTBL_ENTRY)&_ZN6S212C43v93Ev,
  (VTBL_ENTRY)&_ZN6S212C43v94Ev,
  (VTBL_ENTRY)&_ZN6S212C43v95Ev,
  (VTBL_ENTRY)&_ZN6S212C43v96Ev,
  (VTBL_ENTRY)&_ZN6S212C43v97Ev,
  (VTBL_ENTRY)&_ZN6S212C43v98Ev,
  (VTBL_ENTRY)&_ZN6S212C43v99Ev,
  (VTBL_ENTRY)&_ZN6S212C44v100Ev,
  (VTBL_ENTRY)&_ZN6S212C44v101Ev,
  (VTBL_ENTRY)&_ZN6S212C44v102Ev,
  (VTBL_ENTRY)&_ZN6S212C44v103Ev,
  (VTBL_ENTRY)&_ZN6S212C44v104Ev,
  (VTBL_ENTRY)&_ZN6S212C44v105Ev,
  (VTBL_ENTRY)&_ZN6S212C44v106Ev,
  (VTBL_ENTRY)&_ZN6S212C44v107Ev,
  (VTBL_ENTRY)&_ZN6S212C44v108Ev,
  (VTBL_ENTRY)&_ZN6S212C44v109Ev,
};
extern VTBL_ENTRY _ZTI6S212C4[];
extern  VTBL_ENTRY _ZTV6S212C4[];
Class_Descriptor cd_S212C4 = {  "S212C4", // class name
  bases_S212C4, 2,
  &(vtc_S212C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S212C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S212C4),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S212C3  : S212C4 {
  ::S1503C5_nt s212c3f0;
  unsigned int s212c3f1:1;
  ::S1503C6_nt s212c3f2;
  virtual  ~S212C3(); // _ZN6S212C3D1Ev
  virtual void  v110(); // _ZN6S212C34v110Ev
  virtual void  v111(); // _ZN6S212C34v111Ev
  virtual void  v112(); // _ZN6S212C34v112Ev
  virtual void  v113(); // _ZN6S212C34v113Ev
  S212C3(); // tgen
};
//SIG(-1 S212C3) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC19{ BC20{ BC9}}}


 S212C3 ::~S212C3(){ note_dtor("S212C3", this);}
void  S212C3 ::v110(){vfunc_called(this, "_ZN6S212C34v110Ev");}
void  S212C3 ::v111(){vfunc_called(this, "_ZN6S212C34v111Ev");}
void  S212C3 ::v112(){vfunc_called(this, "_ZN6S212C34v112Ev");}
void  S212C3 ::v113(){vfunc_called(this, "_ZN6S212C34v113Ev");}
S212C3 ::S212C3(){ note_ctor("S212C3", this);} // tgen

static void Test_S212C3()
{
  extern Class_Descriptor cd_S212C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S212C3, buf);
    S212C3 *dp, &lv = *(dp=new (buf) S212C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S212C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S212C3)");
    check_base_class_offset(lv, (S212C6*)(S212C5*)(S212C4*), 0, "S212C3");
    check_base_class_offset(lv, (S212C5*)(S212C4*), 0, "S212C3");
    check_base_class_offset(lv, (S212C4*), 0, "S212C3");
    check_field_offset(lv, s212c3f0, ABISELECT(268,196), "S212C3.s212c3f0");
    set_bf_and_test(lv, s212c3f1, ABISELECT(276,204), 0, 1, 1, "S212C3");
    check_field_offset(lv, s212c3f2, ABISELECT(280,208), "S212C3.s212c3f2");
    test_class_info(&lv, &cd_S212C3);
    dp->~S212C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS212C3(Test_S212C3, "S212C3", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S212C3C1Ev();
extern void _ZN6S212C3D1Ev();
Name_Map name_map_S212C3[] = {
  NSPAIR(_ZN6S212C3C1Ev),
  NSPAIR(_ZN6S212C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S212C6;
extern VTBL_ENTRY _ZTI6S212C6[];
extern  VTBL_ENTRY _ZTV6S212C6[];
extern Class_Descriptor cd_S212C5;
extern VTBL_ENTRY _ZTI6S212C5[];
extern  VTBL_ENTRY _ZTV6S212C5[];
extern Class_Descriptor cd_S212C4;
extern VTBL_ENTRY _ZTI6S212C4[];
extern  VTBL_ENTRY _ZTV6S212C4[];
static Base_Class bases_S212C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S212C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S212C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S212C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S212C3[];
extern void _ZN6S212C3D1Ev();
extern void _ZN6S212C3D0Ev();
extern void _ZN6S212C62v4Ev();
extern void _ZN6S212C62v5Ev();
extern void _ZN6S212C62v6Ev();
extern void _ZN6S212C62v7Ev();
extern void _ZN6S212C62v8Ev();
extern void _ZN6S212C62v9Ev();
extern void _ZN6S212C63v10Ev();
extern void _ZN6S212C63v11Ev();
extern void _ZN6S212C63v12Ev();
extern void _ZN6S212C63v13Ev();
extern void _ZN6S212C63v14Ev();
extern void _ZN6S212C63v15Ev();
extern void _ZN6S212C63v16Ev();
extern void _ZN6S212C63v17Ev();
extern void _ZN6S212C63v18Ev();
extern void _ZN6S212C63v19Ev();
extern void _ZN6S212C63v20Ev();
extern void _ZN6S212C63v21Ev();
extern void _ZN6S212C63v22Ev();
extern void _ZN6S212C63v23Ev();
extern void _ZN6S212C63v24Ev();
extern void _ZN6S212C63v25Ev();
extern void _ZN6S212C63v26Ev();
extern void _ZN6S212C63v27Ev();
extern void _ZN6S212C63v28Ev();
extern void _ZN6S212C63v29Ev();
extern void _ZN6S212C63v30Ev();
extern void _ZN6S212C63v31Ev();
extern void _ZN6S212C63v32Ev();
extern void _ZN6S212C63v33Ev();
extern void _ZN6S212C63v34Ev();
extern void _ZN6S212C63v35Ev();
extern void _ZN6S212C63v36Ev();
extern void _ZN6S212C63v37Ev();
extern void _ZN6S212C63v38Ev();
extern void _ZN6S212C63v39Ev();
extern void _ZN6S212C63v40Ev();
extern void _ZN6S212C63v41Ev();
extern void _ZN6S212C63v42Ev();
extern void _ZN6S212C63v43Ev();
extern void _ZN6S212C63v44Ev();
extern void _ZN6S212C63v45Ev();
extern void _ZN6S212C63v46Ev();
extern void _ZN6S212C63v47Ev();
extern void _ZN6S212C63v48Ev();
extern void _ZN6S212C63v49Ev();
extern void _ZN6S212C63v50Ev();
extern void _ZN6S212C63v51Ev();
extern void _ZN6S212C63v52Ev();
extern void _ZN6S212C63v53Ev();
extern void _ZN6S212C63v54Ev();
extern void _ZN6S212C63v55Ev();
extern void _ZN6S212C63v56Ev();
extern void _ZN6S212C63v57Ev();
extern void _ZN6S212C63v58Ev();
extern void _ZN6S212C63v59Ev();
extern void _ZN6S212C63v60Ev();
extern void _ZN6S212C63v61Ev();
extern void _ZN6S212C63v62Ev();
extern void _ZN6S212C63v63Ev();
extern void _ZN6S212C63v64Ev();
extern void _ZN6S212C63v65Ev();
extern void _ZN6S212C63v66Ev();
extern void _ZN6S212C63v67Ev();
extern void _ZN6S212C53v68Ev();
extern void _ZN6S212C53v69Ev();
extern void _ZN6S212C53v70Ev();
extern void _ZN6S212C53v71Ev();
extern void _ZN6S212C53v72Ev();
extern void _ZN6S212C53v73Ev();
extern void _ZN6S212C53v74Ev();
extern void _ZN6S212C53v75Ev();
extern void _ZN6S212C53v76Ev();
extern void _ZN6S212C53v77Ev();
extern void _ZN6S212C53v78Ev();
extern void _ZN6S212C53v79Ev();
extern void _ZN6S212C53v80Ev();
extern void _ZN6S212C53v81Ev();
extern void _ZN6S212C53v82Ev();
extern void _ZN6S212C53v83Ev();
extern void _ZN6S212C53v84Ev();
extern void _ZN6S212C53v85Ev();
extern void _ZN6S212C53v86Ev();
extern void _ZN6S212C53v87Ev();
extern void _ZN6S212C53v88Ev();
extern void _ZN6S212C53v89Ev();
extern void _ZN6S212C43v90Ev();
extern void _ZN6S212C43v91Ev();
extern void _ZN6S212C43v92Ev();
extern void _ZN6S212C43v93Ev();
extern void _ZN6S212C43v94Ev();
extern void _ZN6S212C43v95Ev();
extern void _ZN6S212C43v96Ev();
extern void _ZN6S212C43v97Ev();
extern void _ZN6S212C43v98Ev();
extern void _ZN6S212C43v99Ev();
extern void _ZN6S212C44v100Ev();
extern void _ZN6S212C44v101Ev();
extern void _ZN6S212C44v102Ev();
extern void _ZN6S212C44v103Ev();
extern void _ZN6S212C44v104Ev();
extern void _ZN6S212C44v105Ev();
extern void _ZN6S212C44v106Ev();
extern void _ZN6S212C44v107Ev();
extern void _ZN6S212C44v108Ev();
extern void _ZN6S212C44v109Ev();
extern void _ZN6S212C34v110Ev();
extern void _ZN6S212C34v111Ev();
extern void _ZN6S212C34v112Ev();
extern void _ZN6S212C34v113Ev();
static  VTBL_ENTRY vtc_S212C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S212C3[0]),
  (VTBL_ENTRY)&_ZN6S212C3D1Ev,
  (VTBL_ENTRY)&_ZN6S212C3D0Ev,
  (VTBL_ENTRY)&_ZN6S212C62v4Ev,
  (VTBL_ENTRY)&_ZN6S212C62v5Ev,
  (VTBL_ENTRY)&_ZN6S212C62v6Ev,
  (VTBL_ENTRY)&_ZN6S212C62v7Ev,
  (VTBL_ENTRY)&_ZN6S212C62v8Ev,
  (VTBL_ENTRY)&_ZN6S212C62v9Ev,
  (VTBL_ENTRY)&_ZN6S212C63v10Ev,
  (VTBL_ENTRY)&_ZN6S212C63v11Ev,
  (VTBL_ENTRY)&_ZN6S212C63v12Ev,
  (VTBL_ENTRY)&_ZN6S212C63v13Ev,
  (VTBL_ENTRY)&_ZN6S212C63v14Ev,
  (VTBL_ENTRY)&_ZN6S212C63v15Ev,
  (VTBL_ENTRY)&_ZN6S212C63v16Ev,
  (VTBL_ENTRY)&_ZN6S212C63v17Ev,
  (VTBL_ENTRY)&_ZN6S212C63v18Ev,
  (VTBL_ENTRY)&_ZN6S212C63v19Ev,
  (VTBL_ENTRY)&_ZN6S212C63v20Ev,
  (VTBL_ENTRY)&_ZN6S212C63v21Ev,
  (VTBL_ENTRY)&_ZN6S212C63v22Ev,
  (VTBL_ENTRY)&_ZN6S212C63v23Ev,
  (VTBL_ENTRY)&_ZN6S212C63v24Ev,
  (VTBL_ENTRY)&_ZN6S212C63v25Ev,
  (VTBL_ENTRY)&_ZN6S212C63v26Ev,
  (VTBL_ENTRY)&_ZN6S212C63v27Ev,
  (VTBL_ENTRY)&_ZN6S212C63v28Ev,
  (VTBL_ENTRY)&_ZN6S212C63v29Ev,
  (VTBL_ENTRY)&_ZN6S212C63v30Ev,
  (VTBL_ENTRY)&_ZN6S212C63v31Ev,
  (VTBL_ENTRY)&_ZN6S212C63v32Ev,
  (VTBL_ENTRY)&_ZN6S212C63v33Ev,
  (VTBL_ENTRY)&_ZN6S212C63v34Ev,
  (VTBL_ENTRY)&_ZN6S212C63v35Ev,
  (VTBL_ENTRY)&_ZN6S212C63v36Ev,
  (VTBL_ENTRY)&_ZN6S212C63v37Ev,
  (VTBL_ENTRY)&_ZN6S212C63v38Ev,
  (VTBL_ENTRY)&_ZN6S212C63v39Ev,
  (VTBL_ENTRY)&_ZN6S212C63v40Ev,
  (VTBL_ENTRY)&_ZN6S212C63v41Ev,
  (VTBL_ENTRY)&_ZN6S212C63v42Ev,
  (VTBL_ENTRY)&_ZN6S212C63v43Ev,
  (VTBL_ENTRY)&_ZN6S212C63v44Ev,
  (VTBL_ENTRY)&_ZN6S212C63v45Ev,
  (VTBL_ENTRY)&_ZN6S212C63v46Ev,
  (VTBL_ENTRY)&_ZN6S212C63v47Ev,
  (VTBL_ENTRY)&_ZN6S212C63v48Ev,
  (VTBL_ENTRY)&_ZN6S212C63v49Ev,
  (VTBL_ENTRY)&_ZN6S212C63v50Ev,
  (VTBL_ENTRY)&_ZN6S212C63v51Ev,
  (VTBL_ENTRY)&_ZN6S212C63v52Ev,
  (VTBL_ENTRY)&_ZN6S212C63v53Ev,
  (VTBL_ENTRY)&_ZN6S212C63v54Ev,
  (VTBL_ENTRY)&_ZN6S212C63v55Ev,
  (VTBL_ENTRY)&_ZN6S212C63v56Ev,
  (VTBL_ENTRY)&_ZN6S212C63v57Ev,
  (VTBL_ENTRY)&_ZN6S212C63v58Ev,
  (VTBL_ENTRY)&_ZN6S212C63v59Ev,
  (VTBL_ENTRY)&_ZN6S212C63v60Ev,
  (VTBL_ENTRY)&_ZN6S212C63v61Ev,
  (VTBL_ENTRY)&_ZN6S212C63v62Ev,
  (VTBL_ENTRY)&_ZN6S212C63v63Ev,
  (VTBL_ENTRY)&_ZN6S212C63v64Ev,
  (VTBL_ENTRY)&_ZN6S212C63v65Ev,
  (VTBL_ENTRY)&_ZN6S212C63v66Ev,
  (VTBL_ENTRY)&_ZN6S212C63v67Ev,
  (VTBL_ENTRY)&_ZN6S212C53v68Ev,
  (VTBL_ENTRY)&_ZN6S212C53v69Ev,
  (VTBL_ENTRY)&_ZN6S212C53v70Ev,
  (VTBL_ENTRY)&_ZN6S212C53v71Ev,
  (VTBL_ENTRY)&_ZN6S212C53v72Ev,
  (VTBL_ENTRY)&_ZN6S212C53v73Ev,
  (VTBL_ENTRY)&_ZN6S212C53v74Ev,
  (VTBL_ENTRY)&_ZN6S212C53v75Ev,
  (VTBL_ENTRY)&_ZN6S212C53v76Ev,
  (VTBL_ENTRY)&_ZN6S212C53v77Ev,
  (VTBL_ENTRY)&_ZN6S212C53v78Ev,
  (VTBL_ENTRY)&_ZN6S212C53v79Ev,
  (VTBL_ENTRY)&_ZN6S212C53v80Ev,
  (VTBL_ENTRY)&_ZN6S212C53v81Ev,
  (VTBL_ENTRY)&_ZN6S212C53v82Ev,
  (VTBL_ENTRY)&_ZN6S212C53v83Ev,
  (VTBL_ENTRY)&_ZN6S212C53v84Ev,
  (VTBL_ENTRY)&_ZN6S212C53v85Ev,
  (VTBL_ENTRY)&_ZN6S212C53v86Ev,
  (VTBL_ENTRY)&_ZN6S212C53v87Ev,
  (VTBL_ENTRY)&_ZN6S212C53v88Ev,
  (VTBL_ENTRY)&_ZN6S212C53v89Ev,
  (VTBL_ENTRY)&_ZN6S212C43v90Ev,
  (VTBL_ENTRY)&_ZN6S212C43v91Ev,
  (VTBL_ENTRY)&_ZN6S212C43v92Ev,
  (VTBL_ENTRY)&_ZN6S212C43v93Ev,
  (VTBL_ENTRY)&_ZN6S212C43v94Ev,
  (VTBL_ENTRY)&_ZN6S212C43v95Ev,
  (VTBL_ENTRY)&_ZN6S212C43v96Ev,
  (VTBL_ENTRY)&_ZN6S212C43v97Ev,
  (VTBL_ENTRY)&_ZN6S212C43v98Ev,
  (VTBL_ENTRY)&_ZN6S212C43v99Ev,
  (VTBL_ENTRY)&_ZN6S212C44v100Ev,
  (VTBL_ENTRY)&_ZN6S212C44v101Ev,
  (VTBL_ENTRY)&_ZN6S212C44v102Ev,
  (VTBL_ENTRY)&_ZN6S212C44v103Ev,
  (VTBL_ENTRY)&_ZN6S212C44v104Ev,
  (VTBL_ENTRY)&_ZN6S212C44v105Ev,
  (VTBL_ENTRY)&_ZN6S212C44v106Ev,
  (VTBL_ENTRY)&_ZN6S212C44v107Ev,
  (VTBL_ENTRY)&_ZN6S212C44v108Ev,
  (VTBL_ENTRY)&_ZN6S212C44v109Ev,
  (VTBL_ENTRY)&_ZN6S212C34v110Ev,
  (VTBL_ENTRY)&_ZN6S212C34v111Ev,
  (VTBL_ENTRY)&_ZN6S212C34v112Ev,
  (VTBL_ENTRY)&_ZN6S212C34v113Ev,
};
extern VTBL_ENTRY _ZTI6S212C3[];
extern  VTBL_ENTRY _ZTV6S212C3[];
Class_Descriptor cd_S212C3 = {  "S212C3", // class name
  bases_S212C3, 3,
  &(vtc_S212C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI6S212C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S212C3),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S212C2  : S212C3 {
  virtual  ~S212C2(); // _ZN6S212C2D1Ev
  virtual void  v114(); // _ZN6S212C24v114Ev
  virtual void  v115(); // _ZN6S212C24v115Ev
  S212C2(); // tgen
};
//SIG(-1 S212C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v109 v110 v111 v112 FC6 Fi:1 FC20{ BC21{ BC10}}} vd v1 v2}


 S212C2 ::~S212C2(){ note_dtor("S212C2", this);}
void  S212C2 ::v114(){vfunc_called(this, "_ZN6S212C24v114Ev");}
void  S212C2 ::v115(){vfunc_called(this, "_ZN6S212C24v115Ev");}
S212C2 ::S212C2(){ note_ctor("S212C2", this);} // tgen

static void Test_S212C2()
{
  extern Class_Descriptor cd_S212C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S212C2, buf);
    S212C2 *dp, &lv = *(dp=new (buf) S212C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S212C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S212C2)");
    check_base_class_offset(lv, (S212C6*)(S212C5*)(S212C4*)(S212C3*), 0, "S212C2");
    check_base_class_offset(lv, (S212C5*)(S212C4*)(S212C3*), 0, "S212C2");
    check_base_class_offset(lv, (S212C4*)(S212C3*), 0, "S212C2");
    check_base_class_offset(lv, (S212C3*), 0, "S212C2");
    test_class_info(&lv, &cd_S212C2);
    dp->~S212C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS212C2(Test_S212C2, "S212C2", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN6S212C2C1Ev();
extern void _ZN6S212C2D1Ev();
Name_Map name_map_S212C2[] = {
  NSPAIR(_ZN6S212C2C1Ev),
  NSPAIR(_ZN6S212C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S212C6;
extern VTBL_ENTRY _ZTI6S212C6[];
extern  VTBL_ENTRY _ZTV6S212C6[];
extern Class_Descriptor cd_S212C5;
extern VTBL_ENTRY _ZTI6S212C5[];
extern  VTBL_ENTRY _ZTV6S212C5[];
extern Class_Descriptor cd_S212C4;
extern VTBL_ENTRY _ZTI6S212C4[];
extern  VTBL_ENTRY _ZTV6S212C4[];
extern Class_Descriptor cd_S212C3;
extern VTBL_ENTRY _ZTI6S212C3[];
extern  VTBL_ENTRY _ZTV6S212C3[];
static Base_Class bases_S212C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S212C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S212C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S212C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S212C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S212C2[];
extern void _ZN6S212C2D1Ev();
extern void _ZN6S212C2D0Ev();
extern void _ZN6S212C62v4Ev();
extern void _ZN6S212C62v5Ev();
extern void _ZN6S212C62v6Ev();
extern void _ZN6S212C62v7Ev();
extern void _ZN6S212C62v8Ev();
extern void _ZN6S212C62v9Ev();
extern void _ZN6S212C63v10Ev();
extern void _ZN6S212C63v11Ev();
extern void _ZN6S212C63v12Ev();
extern void _ZN6S212C63v13Ev();
extern 