// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S1540C5_nt  {
  int s1540c5f0[2];
  void  mf1540c5(); // _ZN10S1540C5_nt8mf1540c5Ev
};
//SIG(-1 S1540C5_nt) C1{ m Fi[2]}


void  S1540C5_nt ::mf1540c5(){}

//skip512 S1540C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C4_nt  {
  int s1540c4f0;
  __tsi64 s1540c4f1;
  void *s1540c4f2[4];
  int s1540c4f3[2];
  void *s1540c4f4;
  ::S1540C5_nt s1540c4f5;
  void *s1540c4f6[2];
  virtual  ~S1540C4_nt(); // _ZN10S1540C4_ntD1Ev
  virtual void  v7(); // _ZN10S1540C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1540C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1540C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1540C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1540C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1540C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1540C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1540C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1540C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1540C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1540C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1540C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1540C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1540C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1540C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1540C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1540C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1540C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1540C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1540C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1540C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1540C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1540C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1540C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1540C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1540C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1540C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1540C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1540C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1540C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1540C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1540C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1540C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1540C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1540C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1540C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1540C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1540C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1540C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1540C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1540C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1540C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1540C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1540C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1540C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1540C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1540C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1540C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1540C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1540C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1540C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1540C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1540C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1540C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1540C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1540C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1540C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1540C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1540C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1540C4_nt3v66Ev
  virtual void  v67(); // _ZN10S1540C4_nt3v67Ev
  virtual void  v68(); // _ZN10S1540C4_nt3v68Ev
  virtual void  v69(); // _ZN10S1540C4_nt3v69Ev
  virtual void  v70(); // _ZN10S1540C4_nt3v70Ev
  S1540C4_nt(); // tgen
};
//SIG(-1 S1540C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1540C4_nt ::~S1540C4_nt(){ note_dtor("S1540C4_nt", this);}
void  S1540C4_nt ::v7(){vfunc_called(this, "_ZN10S1540C4_nt2v7Ev");}
void  S1540C4_nt ::v8(){vfunc_called(this, "_ZN10S1540C4_nt2v8Ev");}
void  S1540C4_nt ::v9(){vfunc_called(this, "_ZN10S1540C4_nt2v9Ev");}
void  S1540C4_nt ::v10(){vfunc_called(this, "_ZN10S1540C4_nt3v10Ev");}
void  S1540C4_nt ::v11(){vfunc_called(this, "_ZN10S1540C4_nt3v11Ev");}
void  S1540C4_nt ::v12(){vfunc_called(this, "_ZN10S1540C4_nt3v12Ev");}
void  S1540C4_nt ::v13(){vfunc_called(this, "_ZN10S1540C4_nt3v13Ev");}
void  S1540C4_nt ::v14(){vfunc_called(this, "_ZN10S1540C4_nt3v14Ev");}
void  S1540C4_nt ::v15(){vfunc_called(this, "_ZN10S1540C4_nt3v15Ev");}
void  S1540C4_nt ::v16(){vfunc_called(this, "_ZN10S1540C4_nt3v16Ev");}
void  S1540C4_nt ::v17(){vfunc_called(this, "_ZN10S1540C4_nt3v17Ev");}
void  S1540C4_nt ::v18(){vfunc_called(this, "_ZN10S1540C4_nt3v18Ev");}
void  S1540C4_nt ::v19(){vfunc_called(this, "_ZN10S1540C4_nt3v19Ev");}
void  S1540C4_nt ::v20(){vfunc_called(this, "_ZN10S1540C4_nt3v20Ev");}
void  S1540C4_nt ::v21(){vfunc_called(this, "_ZN10S1540C4_nt3v21Ev");}
void  S1540C4_nt ::v22(){vfunc_called(this, "_ZN10S1540C4_nt3v22Ev");}
void  S1540C4_nt ::v23(){vfunc_called(this, "_ZN10S1540C4_nt3v23Ev");}
void  S1540C4_nt ::v24(){vfunc_called(this, "_ZN10S1540C4_nt3v24Ev");}
void  S1540C4_nt ::v25(){vfunc_called(this, "_ZN10S1540C4_nt3v25Ev");}
void  S1540C4_nt ::v26(){vfunc_called(this, "_ZN10S1540C4_nt3v26Ev");}
void  S1540C4_nt ::v27(){vfunc_called(this, "_ZN10S1540C4_nt3v27Ev");}
void  S1540C4_nt ::v28(){vfunc_called(this, "_ZN10S1540C4_nt3v28Ev");}
void  S1540C4_nt ::v29(){vfunc_called(this, "_ZN10S1540C4_nt3v29Ev");}
void  S1540C4_nt ::v30(){vfunc_called(this, "_ZN10S1540C4_nt3v30Ev");}
void  S1540C4_nt ::v31(){vfunc_called(this, "_ZN10S1540C4_nt3v31Ev");}
void  S1540C4_nt ::v32(){vfunc_called(this, "_ZN10S1540C4_nt3v32Ev");}
void  S1540C4_nt ::v33(){vfunc_called(this, "_ZN10S1540C4_nt3v33Ev");}
void  S1540C4_nt ::v34(){vfunc_called(this, "_ZN10S1540C4_nt3v34Ev");}
void  S1540C4_nt ::v35(){vfunc_called(this, "_ZN10S1540C4_nt3v35Ev");}
void  S1540C4_nt ::v36(){vfunc_called(this, "_ZN10S1540C4_nt3v36Ev");}
void  S1540C4_nt ::v37(){vfunc_called(this, "_ZN10S1540C4_nt3v37Ev");}
void  S1540C4_nt ::v38(){vfunc_called(this, "_ZN10S1540C4_nt3v38Ev");}
void  S1540C4_nt ::v39(){vfunc_called(this, "_ZN10S1540C4_nt3v39Ev");}
void  S1540C4_nt ::v40(){vfunc_called(this, "_ZN10S1540C4_nt3v40Ev");}
void  S1540C4_nt ::v41(){vfunc_called(this, "_ZN10S1540C4_nt3v41Ev");}
void  S1540C4_nt ::v42(){vfunc_called(this, "_ZN10S1540C4_nt3v42Ev");}
void  S1540C4_nt ::v43(){vfunc_called(this, "_ZN10S1540C4_nt3v43Ev");}
void  S1540C4_nt ::v44(){vfunc_called(this, "_ZN10S1540C4_nt3v44Ev");}
void  S1540C4_nt ::v45(){vfunc_called(this, "_ZN10S1540C4_nt3v45Ev");}
void  S1540C4_nt ::v46(){vfunc_called(this, "_ZN10S1540C4_nt3v46Ev");}
void  S1540C4_nt ::v47(){vfunc_called(this, "_ZN10S1540C4_nt3v47Ev");}
void  S1540C4_nt ::v48(){vfunc_called(this, "_ZN10S1540C4_nt3v48Ev");}
void  S1540C4_nt ::v49(){vfunc_called(this, "_ZN10S1540C4_nt3v49Ev");}
void  S1540C4_nt ::v50(){vfunc_called(this, "_ZN10S1540C4_nt3v50Ev");}
void  S1540C4_nt ::v51(){vfunc_called(this, "_ZN10S1540C4_nt3v51Ev");}
void  S1540C4_nt ::v52(){vfunc_called(this, "_ZN10S1540C4_nt3v52Ev");}
void  S1540C4_nt ::v53(){vfunc_called(this, "_ZN10S1540C4_nt3v53Ev");}
void  S1540C4_nt ::v54(){vfunc_called(this, "_ZN10S1540C4_nt3v54Ev");}
void  S1540C4_nt ::v55(){vfunc_called(this, "_ZN10S1540C4_nt3v55Ev");}
void  S1540C4_nt ::v56(){vfunc_called(this, "_ZN10S1540C4_nt3v56Ev");}
void  S1540C4_nt ::v57(){vfunc_called(this, "_ZN10S1540C4_nt3v57Ev");}
void  S1540C4_nt ::v58(){vfunc_called(this, "_ZN10S1540C4_nt3v58Ev");}
void  S1540C4_nt ::v59(){vfunc_called(this, "_ZN10S1540C4_nt3v59Ev");}
void  S1540C4_nt ::v60(){vfunc_called(this, "_ZN10S1540C4_nt3v60Ev");}
void  S1540C4_nt ::v61(){vfunc_called(this, "_ZN10S1540C4_nt3v61Ev");}
void  S1540C4_nt ::v62(){vfunc_called(this, "_ZN10S1540C4_nt3v62Ev");}
void  S1540C4_nt ::v63(){vfunc_called(this, "_ZN10S1540C4_nt3v63Ev");}
void  S1540C4_nt ::v64(){vfunc_called(this, "_ZN10S1540C4_nt3v64Ev");}
void  S1540C4_nt ::v65(){vfunc_called(this, "_ZN10S1540C4_nt3v65Ev");}
void  S1540C4_nt ::v66(){vfunc_called(this, "_ZN10S1540C4_nt3v66Ev");}
void  S1540C4_nt ::v67(){vfunc_called(this, "_ZN10S1540C4_nt3v67Ev");}
void  S1540C4_nt ::v68(){vfunc_called(this, "_ZN10S1540C4_nt3v68Ev");}
void  S1540C4_nt ::v69(){vfunc_called(this, "_ZN10S1540C4_nt3v69Ev");}
void  S1540C4_nt ::v70(){vfunc_called(this, "_ZN10S1540C4_nt3v70Ev");}
S1540C4_nt ::S1540C4_nt(){ note_ctor("S1540C4_nt", this);} // tgen

//skip512 S1540C4_nt

#else // __cplusplus

extern void _ZN10S1540C4_ntC1Ev();
extern void _ZN10S1540C4_ntD1Ev();
Name_Map name_map_S1540C4_nt[] = {
  NSPAIR(_ZN10S1540C4_ntC1Ev),
  NSPAIR(_ZN10S1540C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1540C4_nt[];
extern void _ZN10S1540C4_ntD1Ev();
extern void _ZN10S1540C4_ntD0Ev();
extern void _ZN10S1540C4_nt2v7Ev();
extern void _ZN10S1540C4_nt2v8Ev();
extern void _ZN10S1540C4_nt2v9Ev();
extern void _ZN10S1540C4_nt3v10Ev();
extern void _ZN10S1540C4_nt3v11Ev();
extern void _ZN10S1540C4_nt3v12Ev();
extern void _ZN10S1540C4_nt3v13Ev();
extern void _ZN10S1540C4_nt3v14Ev();
extern void _ZN10S1540C4_nt3v15Ev();
extern void _ZN10S1540C4_nt3v16Ev();
extern void _ZN10S1540C4_nt3v17Ev();
extern void _ZN10S1540C4_nt3v18Ev();
extern void _ZN10S1540C4_nt3v19Ev();
extern void _ZN10S1540C4_nt3v20Ev();
extern void _ZN10S1540C4_nt3v21Ev();
extern void _ZN10S1540C4_nt3v22Ev();
extern void _ZN10S1540C4_nt3v23Ev();
extern void _ZN10S1540C4_nt3v24Ev();
extern void _ZN10S1540C4_nt3v25Ev();
extern void _ZN10S1540C4_nt3v26Ev();
extern void _ZN10S1540C4_nt3v27Ev();
extern void _ZN10S1540C4_nt3v28Ev();
extern void _ZN10S1540C4_nt3v29Ev();
extern void _ZN10S1540C4_nt3v30Ev();
extern void _ZN10S1540C4_nt3v31Ev();
extern void _ZN10S1540C4_nt3v32Ev();
extern void _ZN10S1540C4_nt3v33Ev();
extern void _ZN10S1540C4_nt3v34Ev();
extern void _ZN10S1540C4_nt3v35Ev();
extern void _ZN10S1540C4_nt3v36Ev();
extern void _ZN10S1540C4_nt3v37Ev();
extern void _ZN10S1540C4_nt3v38Ev();
extern void _ZN10S1540C4_nt3v39Ev();
extern void _ZN10S1540C4_nt3v40Ev();
extern void _ZN10S1540C4_nt3v41Ev();
extern void _ZN10S1540C4_nt3v42Ev();
extern void _ZN10S1540C4_nt3v43Ev();
extern void _ZN10S1540C4_nt3v44Ev();
extern void _ZN10S1540C4_nt3v45Ev();
extern void _ZN10S1540C4_nt3v46Ev();
extern void _ZN10S1540C4_nt3v47Ev();
extern void _ZN10S1540C4_nt3v48Ev();
extern void _ZN10S1540C4_nt3v49Ev();
extern void _ZN10S1540C4_nt3v50Ev();
extern void _ZN10S1540C4_nt3v51Ev();
extern void _ZN10S1540C4_nt3v52Ev();
extern void _ZN10S1540C4_nt3v53Ev();
extern void _ZN10S1540C4_nt3v54Ev();
extern void _ZN10S1540C4_nt3v55Ev();
extern void _ZN10S1540C4_nt3v56Ev();
extern void _ZN10S1540C4_nt3v57Ev();
extern void _ZN10S1540C4_nt3v58Ev();
extern void _ZN10S1540C4_nt3v59Ev();
extern void _ZN10S1540C4_nt3v60Ev();
extern void _ZN10S1540C4_nt3v61Ev();
extern void _ZN10S1540C4_nt3v62Ev();
extern void _ZN10S1540C4_nt3v63Ev();
extern void _ZN10S1540C4_nt3v64Ev();
extern void _ZN10S1540C4_nt3v65Ev();
extern void _ZN10S1540C4_nt3v66Ev();
extern void _ZN10S1540C4_nt3v67Ev();
extern void _ZN10S1540C4_nt3v68Ev();
extern void _ZN10S1540C4_nt3v69Ev();
extern void _ZN10S1540C4_nt3v70Ev();
static  VTBL_ENTRY vtc_S1540C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1540C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1540C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v70Ev,
};
extern VTBL_ENTRY _ZTI10S1540C4_nt[];
VTBL_ENTRY *P__ZTI10S1540C4_nt = _ZTI10S1540C4_nt; 
extern  VTBL_ENTRY _ZTV10S1540C4_nt[];
Class_Descriptor cd_S1540C4_nt = {  "S1540C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1540C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1540C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1540C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C8_nt  {
  void *s1540c8f0;
  int s1540c8f1[2];
  void  mf1540c8(); // _ZN10S1540C8_nt8mf1540c8Ev
};
//SIG(-1 S1540C8_nt) C1{ m Fp Fi[2]}


void  S1540C8_nt ::mf1540c8(){}

//skip512 S1540C8_nt

#else // __cplusplus

Class_Descriptor cd_S1540C8_nt = {  "S1540C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C7_nt  : S1540C8_nt {
};
//SIG(-1 S1540C7_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1540C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1540C8_nt;
static Base_Class bases_S1540C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1540C7_nt = {  "S1540C7_nt", // class name
  bases_S1540C7_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C6_nt  : S1540C7_nt {
};
//SIG(-1 S1540C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1540C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1540C8_nt;
extern Class_Descriptor cd_S1540C7_nt;
static Base_Class bases_S1540C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1540C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C9_nt  {
  int s1540c9f0;
  void  mf1540c9(); // _ZN10S1540C9_nt8mf1540c9Ev
};
//SIG(-1 S1540C9_nt) C1{ m Fi}


void  S1540C9_nt ::mf1540c9(){}

//skip512 S1540C9_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S1540C9_nt[];
VTBL_ENTRY *P__ZTI10S1540C9_nt = _ZTI10S1540C9_nt; 
Class_Descriptor cd_S1540C9_nt = {  "S1540C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S1540C9_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C13  : S1540C8_nt {
};
//SIG(-1 S1540C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1540C13()
{
  extern Class_Descriptor cd_S1540C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1540C13, buf);
    S1540C13 &lv = *(new (buf) S1540C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1540C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1540C13)");
    check_base_class_offset(lv, (S1540C8_nt*), 0, "S1540C13");
    test_class_info(&lv, &cd_S1540C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1540C13(Test_S1540C13, "S1540C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1540C8_nt;
static Base_Class bases_S1540C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1540C13 = {  "S1540C13", // class name
  bases_S1540C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C12  : S1540C13 {
};
//SIG(-1 S1540C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1540C12()
{
  extern Class_Descriptor cd_S1540C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1540C12, buf);
    S1540C12 &lv = *(new (buf) S1540C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1540C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1540C12)");
    check_base_class_offset(lv, (S1540C8_nt*)(S1540C13*), 0, "S1540C12");
    check_base_class_offset(lv, (S1540C13*), 0, "S1540C12");
    test_class_info(&lv, &cd_S1540C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1540C12(Test_S1540C12, "S1540C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1540C8_nt;
extern Class_Descriptor cd_S1540C13;
static Base_Class bases_S1540C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1540C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1540C12 = {  "S1540C12", // class name
  bases_S1540C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C14_nt  {
  int s1540c14f0[3];
  void  mf1540c14(); // _ZN11S1540C14_nt9mf1540c14Ev
};
//SIG(-1 S1540C14_nt) C1{ m Fi[3]}


void  S1540C14_nt ::mf1540c14(){}

//skip512 S1540C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C19  : S1540C8_nt {
};
//SIG(-1 S1540C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1540C19()
{
  extern Class_Descriptor cd_S1540C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1540C19, buf);
    S1540C19 &lv = *(new (buf) S1540C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1540C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1540C19)");
    check_base_class_offset(lv, (S1540C8_nt*), 0, "S1540C19");
    test_class_info(&lv, &cd_S1540C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1540C19(Test_S1540C19, "S1540C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1540C8_nt;
static Base_Class bases_S1540C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1540C19 = {  "S1540C19", // class name
  bases_S1540C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C18  : S1540C19 {
};
//SIG(-1 S1540C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1540C18()
{
  extern Class_Descriptor cd_S1540C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1540C18, buf);
    S1540C18 &lv = *(new (buf) S1540C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1540C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1540C18)");
    check_base_class_offset(lv, (S1540C8_nt*)(S1540C19*), 0, "S1540C18");
    check_base_class_offset(lv, (S1540C19*), 0, "S1540C18");
    test_class_info(&lv, &cd_S1540C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1540C18(Test_S1540C18, "S1540C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1540C8_nt;
extern Class_Descriptor cd_S1540C19;
static Base_Class bases_S1540C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1540C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1540C18 = {  "S1540C18", // class name
  bases_S1540C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C3_nt  : S1540C4_nt {
  ::S1540C6_nt s1540c3f0;
  ::S1540C6_nt s1540c3f1;
  ::S1540C9_nt s1540c3f2;
  int s1540c3f3;
  char s1540c3f4[4];
  void *s1540c3f5[2];
  ::S1540C6_nt s1540c3f6;
  unsigned int s1540c3f7:1;
  unsigned int s1540c3f8:1;
  unsigned int s1540c3f9:1;
  unsigned int s1540c3f10:1;
  unsigned int s1540c3f11:1;
  unsigned int s1540c3f12:1;
  unsigned int s1540c3f13:1;
  unsigned int s1540c3f14:1;
  unsigned int s1540c3f15:1;
  unsigned int s1540c3f16:1;
  unsigned int s1540c3f17:1;
  unsigned int s1540c3f18:1;
  unsigned int s1540c3f19:1;
  unsigned int s1540c3f20:1;
  unsigned int s1540c3f21:1;
  unsigned int s1540c3f22:1;
  unsigned int s1540c3f23:1;
  unsigned int s1540c3f24:1;
  unsigned int s1540c3f25:1;
  unsigned int s1540c3f26:1;
  unsigned int s1540c3f27:1;
  unsigned int s1540c3f28:1;
  unsigned int s1540c3f29:1;
  unsigned int s1540c3f30:1;
  unsigned int s1540c3f31:1;
  unsigned int s1540c3f32:1;
  unsigned int s1540c3f33:1;
  unsigned int s1540c3f34:1;
  unsigned int s1540c3f35:1;
  unsigned int s1540c3f36:1;
  unsigned int s1540c3f37:1;
  unsigned int s1540c3f38:1;
  unsigned int s1540c3f39:1;
  unsigned int s1540c3f40:1;
  unsigned int s1540c3f41:1;
  unsigned int s1540c3f42:1;
  unsigned int s1540c3f43:1;
  unsigned int s1540c3f44:1;
  unsigned int s1540c3f45:1;
  unsigned int s1540c3f46:1;
  unsigned int s1540c3f47:1;
  unsigned int s1540c3f48:1;
  unsigned int s1540c3f49:1;
  unsigned int s1540c3f50:1;
  unsigned int s1540c3f51:1;
  unsigned int s1540c3f52:1;
  unsigned int s1540c3f53:1;
  unsigned int s1540c3f54:1;
  unsigned int s1540c3f55:1;
  unsigned int s1540c3f56:1;
  unsigned int s1540c3f57:1;
  unsigned int s1540c3f58:1;
  unsigned int s1540c3f59:1;
  unsigned int s1540c3f60:1;
  unsigned int s1540c3f61:1;
  unsigned int s1540c3f62:1;
  unsigned int s1540c3f63:1;
  unsigned int s1540c3f64:1;
  unsigned int s1540c3f65:1;
  unsigned int s1540c3f66:1;
  unsigned int s1540c3f67:1;
  unsigned int s1540c3f68:1;
  unsigned int s1540c3f69:1;
  unsigned int s1540c3f70:1;
  unsigned int s1540c3f71:1;
  unsigned int s1540c3f72:1;
  unsigned int s1540c3f73:1;
  unsigned int s1540c3f74:1;
  unsigned int s1540c3f75:1;
  unsigned int s1540c3f76:1;
  unsigned int s1540c3f77:1;
  unsigned int s1540c3f78:1;
  unsigned int s1540c3f79:1;
  unsigned int s1540c3f80:1;
  unsigned int s1540c3f81:1;
  unsigned int s1540c3f82:1;
  unsigned int s1540c3f83:1;
  int s1540c3f84[5];
  void *s1540c3f85[2];
  int s1540c3f86[3];
  ::S1540C5_nt s1540c3f87;
  ::S1540C5_nt s1540c3f88;
  ::S1540C5_nt s1540c3f89;
  ::S1540C12 s1540c3f90;
  ::S1540C12 s1540c3f91;
  int s1540c3f92;
  void *s1540c3f93[2];
  ::S1540C14_nt s1540c3f94;
  ::S1540C14_nt s1540c3f95;
  ::S1540C14_nt s1540c3f96;
  ::S1540C14_nt s1540c3f97;
  void *s1540c3f98;
  ::S1540C5_nt s1540c3f99;
  ::S1540C12 s1540c3f100;
  ::S1540C14_nt s1540c3f101;
  ::S1540C14_nt s1540c3f102;
  int s1540c3f103;
  ::S1540C14_nt s1540c3f104;
  ::S1540C14_nt s1540c3f105;
  void *s1540c3f106;
  int s1540c3f107;
  char s1540c3f108;
  ::S1540C14_nt s1540c3f109;
  ::S1540C14_nt s1540c3f110;
  void *s1540c3f111;
  int s1540c3f112;
  void *s1540c3f113;
  ::S1540C12 s1540c3f114;
  ::S1540C18 s1540c3f115;
  ::S1540C18 s1540c3f116;
  virtual  ~S1540C3_nt(); // _ZN10S1540C3_ntD1Ev
  virtual void  v71(); // _ZN10S1540C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1540C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1540C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1540C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1540C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1540C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1540C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1540C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1540C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1540C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1540C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1540C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1540C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1540C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1540C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1540C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1540C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1540C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1540C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1540C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1540C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1540C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1540C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1540C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1540C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1540C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1540C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1540C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1540C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1540C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1540C3_nt4v101Ev
  virtual void  v102(); // _ZN10S1540C3_nt4v102Ev
  virtual void  v103(); // _ZN10S1540C3_nt4v103Ev
  virtual void  v104(); // _ZN10S1540C3_nt4v104Ev
  virtual void  v105(); // _ZN10S1540C3_nt4v105Ev
  virtual void  v106(); // _ZN10S1540C3_nt4v106Ev
  virtual void  v107(); // _ZN10S1540C3_nt4v107Ev
  virtual void  v108(); // _ZN10S1540C3_nt4v108Ev
  virtual void  v109(); // _ZN10S1540C3_nt4v109Ev
  virtual void  v110(); // _ZN10S1540C3_nt4v110Ev
  virtual void  v111(); // _ZN10S1540C3_nt4v111Ev
  virtual void  v112(); // _ZN10S1540C3_nt4v112Ev
  virtual void  v113(); // _ZN10S1540C3_nt4v113Ev
  virtual void  v114(); // _ZN10S1540C3_nt4v114Ev
  virtual void  v115(); // _ZN10S1540C3_nt4v115Ev
  virtual void  v116(); // _ZN10S1540C3_nt4v116Ev
  virtual void  v117(); // _ZN10S1540C3_nt4v117Ev
  virtual void  v118(); // _ZN10S1540C3_nt4v118Ev
  virtual void  v119(); // _ZN10S1540C3_nt4v119Ev
  virtual void  v120(); // _ZN10S1540C3_nt4v120Ev
  virtual void  v121(); // _ZN10S1540C3_nt4v121Ev
  virtual void  v122(); // _ZN10S1540C3_nt4v122Ev
  virtual void  v123(); // _ZN10S1540C3_nt4v123Ev
  virtual void  v124(); // _ZN10S1540C3_nt4v124Ev
  virtual void  v125(); // _ZN10S1540C3_nt4v125Ev
  virtual void  v126(); // _ZN10S1540C3_nt4v126Ev
  virtual void  v127(); // _ZN10S1540C3_nt4v127Ev
  virtual void  v128(); // _ZN10S1540C3_nt4v128Ev
  virtual void  v129(); // _ZN10S1540C3_nt4v129Ev
  virtual void  v130(); // _ZN10S1540C3_nt4v130Ev
  virtual void  v131(); // _ZN10S1540C3_nt4v131Ev
  virtual void  v132(); // _ZN10S1540C3_nt4v132Ev
  virtual void  v133(); // _ZN10S1540C3_nt4v133Ev
  virtual void  v134(); // _ZN10S1540C3_nt4v134Ev
  virtual void  v135(); // _ZN10S1540C3_nt4v135Ev
  virtual void  v136(); // _ZN10S1540C3_nt4v136Ev
  virtual void  v137(); // _ZN10S1540C3_nt4v137Ev
  virtual void  v138(); // _ZN10S1540C3_nt4v138Ev
  virtual void  v139(); // _ZN10S1540C3_nt4v139Ev
  virtual void  v140(); // _ZN10S1540C3_nt4v140Ev
  virtual void  v141(); // _ZN10S1540C3_nt4v141Ev
  virtual void  v142(); // _ZN10S1540C3_nt4v142Ev
  virtual void  v143(); // _ZN10S1540C3_nt4v143Ev
  virtual void  v144(); // _ZN10S1540C3_nt4v144Ev
  virtual void  v145(); // _ZN10S1540C3_nt4v145Ev
  virtual void  v146(); // _ZN10S1540C3_nt4v146Ev
  virtual void  v147(); // _ZN10S1540C3_nt4v147Ev
  virtual void  v148(); // _ZN10S1540C3_nt4v148Ev
  virtual void  v149(); // _ZN10S1540C3_nt4v149Ev
  virtual void  v150(); // _ZN10S1540C3_nt4v150Ev
  virtual void  v151(); // _ZN10S1540C3_nt4v151Ev
  virtual void  v152(); // _ZN10S1540C3_nt4v152Ev
  virtual void  v153(); // _ZN10S1540C3_nt4v153Ev
  virtual void  v154(); // _ZN10S1540C3_nt4v154Ev
  virtual void  v155(); // _ZN10S1540C3_nt4v155Ev
  virtual void  v156(); // _ZN10S1540C3_nt4v156Ev
  virtual void  v157(); // _ZN10S1540C3_nt4v157Ev
  virtual void  v158(); // _ZN10S1540C3_nt4v158Ev
  virtual void  v159(); // _ZN10S1540C3_nt4v159Ev
  virtual void  v160(); // _ZN10S1540C3_nt4v160Ev
  virtual void  v161(); // _ZN10S1540C3_nt4v161Ev
  virtual void  v162(); // _ZN10S1540C3_nt4v162Ev
  virtual void  v163(); // _ZN10S1540C3_nt4v163Ev
  virtual void  v164(); // _ZN10S1540C3_nt4v164Ev
  virtual void  v165(); // _ZN10S1540C3_nt4v165Ev
  virtual void  v166(); // _ZN10S1540C3_nt4v166Ev
  virtual void  v167(); // _ZN10S1540C3_nt4v167Ev
  virtual void  v168(); // _ZN10S1540C3_nt4v168Ev
  virtual void  v169(); // _ZN10S1540C3_nt4v169Ev
  virtual void  v170(); // _ZN10S1540C3_nt4v170Ev
  virtual void  v171(); // _ZN10S1540C3_nt4v171Ev
  virtual void  v172(); // _ZN10S1540C3_nt4v172Ev
  virtual void  v173(); // _ZN10S1540C3_nt4v173Ev
  virtual void  v174(); // _ZN10S1540C3_nt4v174Ev
  virtual void  v175(); // _ZN10S1540C3_nt4v175Ev
  virtual void  v176(); // _ZN10S1540C3_nt4v176Ev
  virtual void  v177(); // _ZN10S1540C3_nt4v177Ev
  virtual void  v178(); // _ZN10S1540C3_nt4v178Ev
  virtual void  v179(); // _ZN10S1540C3_nt4v179Ev
  virtual void  v180(); // _ZN10S1540C3_nt4v180Ev
  virtual void  v181(); // _ZN10S1540C3_nt4v181Ev
  virtual void  v182(); // _ZN10S1540C3_nt4v182Ev
  virtual void  v183(); // _ZN10S1540C3_nt4v183Ev
  virtual void  v184(); // _ZN10S1540C3_nt4v184Ev
  virtual void  v185(); // _ZN10S1540C3_nt4v185Ev
  virtual void  v186(); // _ZN10S1540C3_nt4v186Ev
  virtual void  v187(); // _ZN10S1540C3_nt4v187Ev
  virtual void  v188(); // _ZN10S1540C3_nt4v188Ev
  virtual void  v189(); // _ZN10S1540C3_nt4v189Ev
  virtual void  v190(); // _ZN10S1540C3_nt4v190Ev
  virtual void  v191(); // _ZN10S1540C3_nt4v191Ev
  virtual void  v192(); // _ZN10S1540C3_nt4v192Ev
  virtual void  v193(); // _ZN10S1540C3_nt4v193Ev
  virtual void  v194(); // _ZN10S1540C3_nt4v194Ev
  virtual void  v195(); // _ZN10S1540C3_nt4v195Ev
  virtual void  v196(); // _ZN10S1540C3_nt4v196Ev
  virtual void  v197(); // _ZN10S1540C3_nt4v197Ev
  virtual void  v198(); // _ZN10S1540C3_nt4v198Ev
  virtual void  v199(); // _ZN10S1540C3_nt4v199Ev
  virtual void  v200(); // _ZN10S1540C3_nt4v200Ev
  virtual void  v201(); // _ZN10S1540C3_nt4v201Ev
  virtual void  v202(); // _ZN10S1540C3_nt4v202Ev
  virtual void  v203(); // _ZN10S1540C3_nt4v203Ev
  virtual void  v204(); // _ZN10S1540C3_nt4v204Ev
  virtual void  v205(); // _ZN10S1540C3_nt4v205Ev
  virtual void  v206(); // _ZN10S1540C3_nt4v206Ev
  virtual void  v207(); // _ZN10S1540C3_nt4v207Ev
  virtual void  v208(); // _ZN10S1540C3_nt4v208Ev
  virtual void  v209(); // _ZN10S1540C3_nt4v209Ev
  virtual void  v210(); // _ZN10S1540C3_nt4v210Ev
  virtual void  v211(); // _ZN10S1540C3_nt4v211Ev
  virtual void  v212(); // _ZN10S1540C3_nt4v212Ev
  virtual void  v213(); // _ZN10S1540C3_nt4v213Ev
  S1540C3_nt(); // tgen
};
//SIG(-1 S1540C3_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S1540C3_nt ::~S1540C3_nt(){ note_dtor("S1540C3_nt", this);}
void  S1540C3_nt ::v71(){vfunc_called(this, "_ZN10S1540C3_nt3v71Ev");}
void  S1540C3_nt ::v72(){vfunc_called(this, "_ZN10S1540C3_nt3v72Ev");}
void  S1540C3_nt ::v73(){vfunc_called(this, "_ZN10S1540C3_nt3v73Ev");}
void  S1540C3_nt ::v74(){vfunc_called(this, "_ZN10S1540C3_nt3v74Ev");}
void  S1540C3_nt ::v75(){vfunc_called(this, "_ZN10S1540C3_nt3v75Ev");}
void  S1540C3_nt ::v76(){vfunc_called(this, "_ZN10S1540C3_nt3v76Ev");}
void  S1540C3_nt ::v77(){vfunc_called(this, "_ZN10S1540C3_nt3v77Ev");}
void  S1540C3_nt ::v78(){vfunc_called(this, "_ZN10S1540C3_nt3v78Ev");}
void  S1540C3_nt ::v79(){vfunc_called(this, "_ZN10S1540C3_nt3v79Ev");}
void  S1540C3_nt ::v80(){vfunc_called(this, "_ZN10S1540C3_nt3v80Ev");}
void  S1540C3_nt ::v81(){vfunc_called(this, "_ZN10S1540C3_nt3v81Ev");}
void  S1540C3_nt ::v82(){vfunc_called(this, "_ZN10S1540C3_nt3v82Ev");}
void  S1540C3_nt ::v83(){vfunc_called(this, "_ZN10S1540C3_nt3v83Ev");}
void  S1540C3_nt ::v84(){vfunc_called(this, "_ZN10S1540C3_nt3v84Ev");}
void  S1540C3_nt ::v85(){vfunc_called(this, "_ZN10S1540C3_nt3v85Ev");}
void  S1540C3_nt ::v86(){vfunc_called(this, "_ZN10S1540C3_nt3v86Ev");}
void  S1540C3_nt ::v87(){vfunc_called(this, "_ZN10S1540C3_nt3v87Ev");}
void  S1540C3_nt ::v88(){vfunc_called(this, "_ZN10S1540C3_nt3v88Ev");}
void  S1540C3_nt ::v89(){vfunc_called(this, "_ZN10S1540C3_nt3v89Ev");}
void  S1540C3_nt ::v90(){vfunc_called(this, "_ZN10S1540C3_nt3v90Ev");}
void  S1540C3_nt ::v91(){vfunc_called(this, "_ZN10S1540C3_nt3v91Ev");}
void  S1540C3_nt ::v92(){vfunc_called(this, "_ZN10S1540C3_nt3v92Ev");}
void  S1540C3_nt ::v93(){vfunc_called(this, "_ZN10S1540C3_nt3v93Ev");}
void  S1540C3_nt ::v94(){vfunc_called(this, "_ZN10S1540C3_nt3v94Ev");}
void  S1540C3_nt ::v95(){vfunc_called(this, "_ZN10S1540C3_nt3v95Ev");}
void  S1540C3_nt ::v96(){vfunc_called(this, "_ZN10S1540C3_nt3v96Ev");}
void  S1540C3_nt ::v97(){vfunc_called(this, "_ZN10S1540C3_nt3v97Ev");}
void  S1540C3_nt ::v98(){vfunc_called(this, "_ZN10S1540C3_nt3v98Ev");}
void  S1540C3_nt ::v99(){vfunc_called(this, "_ZN10S1540C3_nt3v99Ev");}
void  S1540C3_nt ::v100(){vfunc_called(this, "_ZN10S1540C3_nt4v100Ev");}
void  S1540C3_nt ::v101(){vfunc_called(this, "_ZN10S1540C3_nt4v101Ev");}
void  S1540C3_nt ::v102(){vfunc_called(this, "_ZN10S1540C3_nt4v102Ev");}
void  S1540C3_nt ::v103(){vfunc_called(this, "_ZN10S1540C3_nt4v103Ev");}
void  S1540C3_nt ::v104(){vfunc_called(this, "_ZN10S1540C3_nt4v104Ev");}
void  S1540C3_nt ::v105(){vfunc_called(this, "_ZN10S1540C3_nt4v105Ev");}
void  S1540C3_nt ::v106(){vfunc_called(this, "_ZN10S1540C3_nt4v106Ev");}
void  S1540C3_nt ::v107(){vfunc_called(this, "_ZN10S1540C3_nt4v107Ev");}
void  S1540C3_nt ::v108(){vfunc_called(this, "_ZN10S1540C3_nt4v108Ev");}
void  S1540C3_nt ::v109(){vfunc_called(this, "_ZN10S1540C3_nt4v109Ev");}
void  S1540C3_nt ::v110(){vfunc_called(this, "_ZN10S1540C3_nt4v110Ev");}
void  S1540C3_nt ::v111(){vfunc_called(this, "_ZN10S1540C3_nt4v111Ev");}
void  S1540C3_nt ::v112(){vfunc_called(this, "_ZN10S1540C3_nt4v112Ev");}
void  S1540C3_nt ::v113(){vfunc_called(this, "_ZN10S1540C3_nt4v113Ev");}
void  S1540C3_nt ::v114(){vfunc_called(this, "_ZN10S1540C3_nt4v114Ev");}
void  S1540C3_nt ::v115(){vfunc_called(this, "_ZN10S1540C3_nt4v115Ev");}
void  S1540C3_nt ::v116(){vfunc_called(this, "_ZN10S1540C3_nt4v116Ev");}
void  S1540C3_nt ::v117(){vfunc_called(this, "_ZN10S1540C3_nt4v117Ev");}
void  S1540C3_nt ::v118(){vfunc_called(this, "_ZN10S1540C3_nt4v118Ev");}
void  S1540C3_nt ::v119(){vfunc_called(this, "_ZN10S1540C3_nt4v119Ev");}
void  S1540C3_nt ::v120(){vfunc_called(this, "_ZN10S1540C3_nt4v120Ev");}
void  S1540C3_nt ::v121(){vfunc_called(this, "_ZN10S1540C3_nt4v121Ev");}
void  S1540C3_nt ::v122(){vfunc_called(this, "_ZN10S1540C3_nt4v122Ev");}
void  S1540C3_nt ::v123(){vfunc_called(this, "_ZN10S1540C3_nt4v123Ev");}
void  S1540C3_nt ::v124(){vfunc_called(this, "_ZN10S1540C3_nt4v124Ev");}
void  S1540C3_nt ::v125(){vfunc_called(this, "_ZN10S1540C3_nt4v125Ev");}
void  S1540C3_nt ::v126(){vfunc_called(this, "_ZN10S1540C3_nt4v126Ev");}
void  S1540C3_nt ::v127(){vfunc_called(this, "_ZN10S1540C3_nt4v127Ev");}
void  S1540C3_nt ::v128(){vfunc_called(this, "_ZN10S1540C3_nt4v128Ev");}
void  S1540C3_nt ::v129(){vfunc_called(this, "_ZN10S1540C3_nt4v129Ev");}
void  S1540C3_nt ::v130(){vfunc_called(this, "_ZN10S1540C3_nt4v130Ev");}
void  S1540C3_nt ::v131(){vfunc_called(this, "_ZN10S1540C3_nt4v131Ev");}
void  S1540C3_nt ::v132(){vfunc_called(this, "_ZN10S1540C3_nt4v132Ev");}
void  S1540C3_nt ::v133(){vfunc_called(this, "_ZN10S1540C3_nt4v133Ev");}
void  S1540C3_nt ::v134(){vfunc_called(this, "_ZN10S1540C3_nt4v134Ev");}
void  S1540C3_nt ::v135(){vfunc_called(this, "_ZN10S1540C3_nt4v135Ev");}
void  S1540C3_nt ::v136(){vfunc_called(this, "_ZN10S1540C3_nt4v136Ev");}
void  S1540C3_nt ::v137(){vfunc_called(this, "_ZN10S1540C3_nt4v137Ev");}
void  S1540C3_nt ::v138(){vfunc_called(this, "_ZN10S1540C3_nt4v138Ev");}
void  S1540C3_nt ::v139(){vfunc_called(this, "_ZN10S1540C3_nt4v139Ev");}
void  S1540C3_nt ::v140(){vfunc_called(this, "_ZN10S1540C3_nt4v140Ev");}
void  S1540C3_nt ::v141(){vfunc_called(this, "_ZN10S1540C3_nt4v141Ev");}
void  S1540C3_nt ::v142(){vfunc_called(this, "_ZN10S1540C3_nt4v142Ev");}
void  S1540C3_nt ::v143(){vfunc_called(this, "_ZN10S1540C3_nt4v143Ev");}
void  S1540C3_nt ::v144(){vfunc_called(this, "_ZN10S1540C3_nt4v144Ev");}
void  S1540C3_nt ::v145(){vfunc_called(this, "_ZN10S1540C3_nt4v145Ev");}
void  S1540C3_nt ::v146(){vfunc_called(this, "_ZN10S1540C3_nt4v146Ev");}
void  S1540C3_nt ::v147(){vfunc_called(this, "_ZN10S1540C3_nt4v147Ev");}
void  S1540C3_nt ::v148(){vfunc_called(this, "_ZN10S1540C3_nt4v148Ev");}
void  S1540C3_nt ::v149(){vfunc_called(this, "_ZN10S1540C3_nt4v149Ev");}
void  S1540C3_nt ::v150(){vfunc_called(this, "_ZN10S1540C3_nt4v150Ev");}
void  S1540C3_nt ::v151(){vfunc_called(this, "_ZN10S1540C3_nt4v151Ev");}
void  S1540C3_nt ::v152(){vfunc_called(this, "_ZN10S1540C3_nt4v152Ev");}
void  S1540C3_nt ::v153(){vfunc_called(this, "_ZN10S1540C3_nt4v153Ev");}
void  S1540C3_nt ::v154(){vfunc_called(this, "_ZN10S1540C3_nt4v154Ev");}
void  S1540C3_nt ::v155(){vfunc_called(this, "_ZN10S1540C3_nt4v155Ev");}
void  S1540C3_nt ::v156(){vfunc_called(this, "_ZN10S1540C3_nt4v156Ev");}
void  S1540C3_nt ::v157(){vfunc_called(this, "_ZN10S1540C3_nt4v157Ev");}
void  S1540C3_nt ::v158(){vfunc_called(this, "_ZN10S1540C3_nt4v158Ev");}
void  S1540C3_nt ::v159(){vfunc_called(this, "_ZN10S1540C3_nt4v159Ev");}
void  S1540C3_nt ::v160(){vfunc_called(this, "_ZN10S1540C3_nt4v160Ev");}
void  S1540C3_nt ::v161(){vfunc_called(this, "_ZN10S1540C3_nt4v161Ev");}
void  S1540C3_nt ::v162(){vfunc_called(this, "_ZN10S1540C3_nt4v162Ev");}
void  S1540C3_nt ::v163(){vfunc_called(this, "_ZN10S1540C3_nt4v163Ev");}
void  S1540C3_nt ::v164(){vfunc_called(this, "_ZN10S1540C3_nt4v164Ev");}
void  S1540C3_nt ::v165(){vfunc_called(this, "_ZN10S1540C3_nt4v165Ev");}
void  S1540C3_nt ::v166(){vfunc_called(this, "_ZN10S1540C3_nt4v166Ev");}
void  S1540C3_nt ::v167(){vfunc_called(this, "_ZN10S1540C3_nt4v167Ev");}
void  S1540C3_nt ::v168(){vfunc_called(this, "_ZN10S1540C3_nt4v168Ev");}
void  S1540C3_nt ::v169(){vfunc_called(this, "_ZN10S1540C3_nt4v169Ev");}
void  S1540C3_nt ::v170(){vfunc_called(this, "_ZN10S1540C3_nt4v170Ev");}
void  S1540C3_nt ::v171(){vfunc_called(this, "_ZN10S1540C3_nt4v171Ev");}
void  S1540C3_nt ::v172(){vfunc_called(this, "_ZN10S1540C3_nt4v172Ev");}
void  S1540C3_nt ::v173(){vfunc_called(this, "_ZN10S1540C3_nt4v173Ev");}
void  S1540C3_nt ::v174(){vfunc_called(this, "_ZN10S1540C3_nt4v174Ev");}
void  S1540C3_nt ::v175(){vfunc_called(this, "_ZN10S1540C3_nt4v175Ev");}
void  S1540C3_nt ::v176(){vfunc_called(this, "_ZN10S1540C3_nt4v176Ev");}
void  S1540C3_nt ::v177(){vfunc_called(this, "_ZN10S1540C3_nt4v177Ev");}
void  S1540C3_nt ::v178(){vfunc_called(this, "_ZN10S1540C3_nt4v178Ev");}
void  S1540C3_nt ::v179(){vfunc_called(this, "_ZN10S1540C3_nt4v179Ev");}
void  S1540C3_nt ::v180(){vfunc_called(this, "_ZN10S1540C3_nt4v180Ev");}
void  S1540C3_nt ::v181(){vfunc_called(this, "_ZN10S1540C3_nt4v181Ev");}
void  S1540C3_nt ::v182(){vfunc_called(this, "_ZN10S1540C3_nt4v182Ev");}
void  S1540C3_nt ::v183(){vfunc_called(this, "_ZN10S1540C3_nt4v183Ev");}
void  S1540C3_nt ::v184(){vfunc_called(this, "_ZN10S1540C3_nt4v184Ev");}
void  S1540C3_nt ::v185(){vfunc_called(this, "_ZN10S1540C3_nt4v185Ev");}
void  S1540C3_nt ::v186(){vfunc_called(this, "_ZN10S1540C3_nt4v186Ev");}
void  S1540C3_nt ::v187(){vfunc_called(this, "_ZN10S1540C3_nt4v187Ev");}
void  S1540C3_nt ::v188(){vfunc_called(this, "_ZN10S1540C3_nt4v188Ev");}
void  S1540C3_nt ::v189(){vfunc_called(this, "_ZN10S1540C3_nt4v189Ev");}
void  S1540C3_nt ::v190(){vfunc_called(this, "_ZN10S1540C3_nt4v190Ev");}
void  S1540C3_nt ::v191(){vfunc_called(this, "_ZN10S1540C3_nt4v191Ev");}
void  S1540C3_nt ::v192(){vfunc_called(this, "_ZN10S1540C3_nt4v192Ev");}
void  S1540C3_nt ::v193(){vfunc_called(this, "_ZN10S1540C3_nt4v193Ev");}
void  S1540C3_nt ::v194(){vfunc_called(this, "_ZN10S1540C3_nt4v194Ev");}
void  S1540C3_nt ::v195(){vfunc_called(this, "_ZN10S1540C3_nt4v195Ev");}
void  S1540C3_nt ::v196(){vfunc_called(this, "_ZN10S1540C3_nt4v196Ev");}
void  S1540C3_nt ::v197(){vfunc_called(this, "_ZN10S1540C3_nt4v197Ev");}
void  S1540C3_nt ::v198(){vfunc_called(this, "_ZN10S1540C3_nt4v198Ev");}
void  S1540C3_nt ::v199(){vfunc_called(this, "_ZN10S1540C3_nt4v199Ev");}
void  S1540C3_nt ::v200(){vfunc_called(this, "_ZN10S1540C3_nt4v200Ev");}
void  S1540C3_nt ::v201(){vfunc_called(this, "_ZN10S1540C3_nt4v201Ev");}
void  S1540C3_nt ::v202(){vfunc_called(this, "_ZN10S1540C3_nt4v202Ev");}
void  S1540C3_nt ::v203(){vfunc_called(this, "_ZN10S1540C3_nt4v203Ev");}
void  S1540C3_nt ::v204(){vfunc_called(this, "_ZN10S1540C3_nt4v204Ev");}
void  S1540C3_nt ::v205(){vfunc_called(this, "_ZN10S1540C3_nt4v205Ev");}
void  S1540C3_nt ::v206(){vfunc_called(this, "_ZN10S1540C3_nt4v206Ev");}
void  S1540C3_nt ::v207(){vfunc_called(this, "_ZN10S1540C3_nt4v207Ev");}
void  S1540C3_nt ::v208(){vfunc_called(this, "_ZN10S1540C3_nt4v208Ev");}
void  S1540C3_nt ::v209(){vfunc_called(this, "_ZN10S1540C3_nt4v209Ev");}
void  S1540C3_nt ::v210(){vfunc_called(this, "_ZN10S1540C3_nt4v210Ev");}
void  S1540C3_nt ::v211(){vfunc_called(this, "_ZN10S1540C3_nt4v211Ev");}
void  S1540C3_nt ::v212(){vfunc_called(this, "_ZN10S1540C3_nt4v212Ev");}
void  S1540C3_nt ::v213(){vfunc_called(this, "_ZN10S1540C3_nt4v213Ev");}
S1540C3_nt ::S1540C3_nt(){ note_ctor("S1540C3_nt", this);} // tgen

//skip512 S1540C3_nt

#else // __cplusplus

extern void _ZN10S1540C3_ntC1Ev();
extern void _ZN10S1540C3_ntD1Ev();
Name_Map name_map_S1540C3_nt[] = {
  NSPAIR(_ZN10S1540C3_ntC1Ev),
  NSPAIR(_ZN10S1540C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1540C4_nt;
extern VTBL_ENTRY _ZTI10S1540C4_nt[];
extern  VTBL_ENTRY _ZTV10S1540C4_nt[];
static Base_Class bases_S1540C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1540C3_nt[];
extern void _ZN10S1540C3_ntD1Ev();
extern void _ZN10S1540C3_ntD0Ev();
extern void _ZN10S1540C4_nt2v7Ev();
extern void _ZN10S1540C4_nt2v8Ev();
extern void _ZN10S1540C4_nt2v9Ev();
extern void _ZN10S1540C4_nt3v10Ev();
extern void _ZN10S1540C4_nt3v11Ev();
extern void _ZN10S1540C4_nt3v12Ev();
extern void _ZN10S1540C4_nt3v13Ev();
extern void _ZN10S1540C4_nt3v14Ev();
extern void _ZN10S1540C4_nt3v15Ev();
extern void _ZN10S1540C4_nt3v16Ev();
extern void _ZN10S1540C4_nt3v17Ev();
extern void _ZN10S1540C4_nt3v18Ev();
extern void _ZN10S1540C4_nt3v19Ev();
extern void _ZN10S1540C4_nt3v20Ev();
extern void _ZN10S1540C4_nt3v21Ev();
extern void _ZN10S1540C4_nt3v22Ev();
extern void _ZN10S1540C4_nt3v23Ev();
extern void _ZN10S1540C4_nt3v24Ev();
extern void _ZN10S1540C4_nt3v25Ev();
extern void _ZN10S1540C4_nt3v26Ev();
extern void _ZN10S1540C4_nt3v27Ev();
extern void _ZN10S1540C4_nt3v28Ev();
extern void _ZN10S1540C4_nt3v29Ev();
extern void _ZN10S1540C4_nt3v30Ev();
extern void _ZN10S1540C4_nt3v31Ev();
extern void _ZN10S1540C4_nt3v32Ev();
extern void _ZN10S1540C4_nt3v33Ev();
extern void _ZN10S1540C4_nt3v34Ev();
extern void _ZN10S1540C4_nt3v35Ev();
extern void _ZN10S1540C4_nt3v36Ev();
extern void _ZN10S1540C4_nt3v37Ev();
extern void _ZN10S1540C4_nt3v38Ev();
extern void _ZN10S1540C4_nt3v39Ev();
extern void _ZN10S1540C4_nt3v40Ev();
extern void _ZN10S1540C4_nt3v41Ev();
extern void _ZN10S1540C4_nt3v42Ev();
extern void _ZN10S1540C4_nt3v43Ev();
extern void _ZN10S1540C4_nt3v44Ev();
extern void _ZN10S1540C4_nt3v45Ev();
extern void _ZN10S1540C4_nt3v46Ev();
extern void _ZN10S1540C4_nt3v47Ev();
extern void _ZN10S1540C4_nt3v48Ev();
extern void _ZN10S1540C4_nt3v49Ev();
extern void _ZN10S1540C4_nt3v50Ev();
extern void _ZN10S1540C4_nt3v51Ev();
extern void _ZN10S1540C4_nt3v52Ev();
extern void _ZN10S1540C4_nt3v53Ev();
extern void _ZN10S1540C4_nt3v54Ev();
extern void _ZN10S1540C4_nt3v55Ev();
extern void _ZN10S1540C4_nt3v56Ev();
extern void _ZN10S1540C4_nt3v57Ev();
extern void _ZN10S1540C4_nt3v58Ev();
extern void _ZN10S1540C4_nt3v59Ev();
extern void _ZN10S1540C4_nt3v60Ev();
extern void _ZN10S1540C4_nt3v61Ev();
extern void _ZN10S1540C4_nt3v62Ev();
extern void _ZN10S1540C4_nt3v63Ev();
extern void _ZN10S1540C4_nt3v64Ev();
extern void _ZN10S1540C4_nt3v65Ev();
extern void _ZN10S1540C4_nt3v66Ev();
extern void _ZN10S1540C4_nt3v67Ev();
extern void _ZN10S1540C4_nt3v68Ev();
extern void _ZN10S1540C4_nt3v69Ev();
extern void _ZN10S1540C4_nt3v70Ev();
extern void _ZN10S1540C3_nt3v71Ev();
extern void _ZN10S1540C3_nt3v72Ev();
extern void _ZN10S1540C3_nt3v73Ev();
extern void _ZN10S1540C3_nt3v74Ev();
extern void _ZN10S1540C3_nt3v75Ev();
extern void _ZN10S1540C3_nt3v76Ev();
extern void _ZN10S1540C3_nt3v77Ev();
extern void _ZN10S1540C3_nt3v78Ev();
extern void _ZN10S1540C3_nt3v79Ev();
extern void _ZN10S1540C3_nt3v80Ev();
extern void _ZN10S1540C3_nt3v81Ev();
extern void _ZN10S1540C3_nt3v82Ev();
extern void _ZN10S1540C3_nt3v83Ev();
extern void _ZN10S1540C3_nt3v84Ev();
extern void _ZN10S1540C3_nt3v85Ev();
extern void _ZN10S1540C3_nt3v86Ev();
extern void _ZN10S1540C3_nt3v87Ev();
extern void _ZN10S1540C3_nt3v88Ev();
extern void _ZN10S1540C3_nt3v89Ev();
extern void _ZN10S1540C3_nt3v90Ev();
extern void _ZN10S1540C3_nt3v91Ev();
extern void _ZN10S1540C3_nt3v92Ev();
extern void _ZN10S1540C3_nt3v93Ev();
extern void _ZN10S1540C3_nt3v94Ev();
extern void _ZN10S1540C3_nt3v95Ev();
extern void _ZN10S1540C3_nt3v96Ev();
extern void _ZN10S1540C3_nt3v97Ev();
extern void _ZN10S1540C3_nt3v98Ev();
extern void _ZN10S1540C3_nt3v99Ev();
extern void _ZN10S1540C3_nt4v100Ev();
extern void _ZN10S1540C3_nt4v101Ev();
extern void _ZN10S1540C3_nt4v102Ev();
extern void _ZN10S1540C3_nt4v103Ev();
extern void _ZN10S1540C3_nt4v104Ev();
extern void _ZN10S1540C3_nt4v105Ev();
extern void _ZN10S1540C3_nt4v106Ev();
extern void _ZN10S1540C3_nt4v107Ev();
extern void _ZN10S1540C3_nt4v108Ev();
extern void _ZN10S1540C3_nt4v109Ev();
extern void _ZN10S1540C3_nt4v110Ev();
extern void _ZN10S1540C3_nt4v111Ev();
extern void _ZN10S1540C3_nt4v112Ev();
extern void _ZN10S1540C3_nt4v113Ev();
extern void _ZN10S1540C3_nt4v114Ev();
extern void _ZN10S1540C3_nt4v115Ev();
extern void _ZN10S1540C3_nt4v116Ev();
extern void _ZN10S1540C3_nt4v117Ev();
extern void _ZN10S1540C3_nt4v118Ev();
extern void _ZN10S1540C3_nt4v119Ev();
extern void _ZN10S1540C3_nt4v120Ev();
extern void _ZN10S1540C3_nt4v121Ev();
extern void _ZN10S1540C3_nt4v122Ev();
extern void _ZN10S1540C3_nt4v123Ev();
extern void _ZN10S1540C3_nt4v124Ev();
extern void _ZN10S1540C3_nt4v125Ev();
extern void _ZN10S1540C3_nt4v126Ev();
extern void _ZN10S1540C3_nt4v127Ev();
extern void _ZN10S1540C3_nt4v128Ev();
extern void _ZN10S1540C3_nt4v129Ev();
extern void _ZN10S1540C3_nt4v130Ev();
extern void _ZN10S1540C3_nt4v131Ev();
extern void _ZN10S1540C3_nt4v132Ev();
extern void _ZN10S1540C3_nt4v133Ev();
extern void _ZN10S1540C3_nt4v134Ev();
extern void _ZN10S1540C3_nt4v135Ev();
extern void _ZN10S1540C3_nt4v136Ev();
extern void _ZN10S1540C3_nt4v137Ev();
extern void _ZN10S1540C3_nt4v138Ev();
extern void _ZN10S1540C3_nt4v139Ev();
extern void _ZN10S1540C3_nt4v140Ev();
extern void _ZN10S1540C3_nt4v141Ev();
extern void _ZN10S1540C3_nt4v142Ev();
extern void _ZN10S1540C3_nt4v143Ev();
extern void _ZN10S1540C3_nt4v144Ev();
extern void _ZN10S1540C3_nt4v145Ev();
extern void _ZN10S1540C3_nt4v146Ev();
extern void _ZN10S1540C3_nt4v147Ev();
extern void _ZN10S1540C3_nt4v148Ev();
extern void _ZN10S1540C3_nt4v149Ev();
extern void _ZN10S1540C3_nt4v150Ev();
extern void _ZN10S1540C3_nt4v151Ev();
extern void _ZN10S1540C3_nt4v152Ev();
extern void _ZN10S1540C3_nt4v153Ev();
extern void _ZN10S1540C3_nt4v154Ev();
extern void _ZN10S1540C3_nt4v155Ev();
extern void _ZN10S1540C3_nt4v156Ev();
extern void _ZN10S1540C3_nt4v157Ev();
extern void _ZN10S1540C3_nt4v158Ev();
extern void _ZN10S1540C3_nt4v159Ev();
extern void _ZN10S1540C3_nt4v160Ev();
extern void _ZN10S1540C3_nt4v161Ev();
extern void _ZN10S1540C3_nt4v162Ev();
extern void _ZN10S1540C3_nt4v163Ev();
extern void _ZN10S1540C3_nt4v164Ev();
extern void _ZN10S1540C3_nt4v165Ev();
extern void _ZN10S1540C3_nt4v166Ev();
extern void _ZN10S1540C3_nt4v167Ev();
extern void _ZN10S1540C3_nt4v168Ev();
extern void _ZN10S1540C3_nt4v169Ev();
extern void _ZN10S1540C3_nt4v170Ev();
extern void _ZN10S1540C3_nt4v171Ev();
extern void _ZN10S1540C3_nt4v172Ev();
extern void _ZN10S1540C3_nt4v173Ev();
extern void _ZN10S1540C3_nt4v174Ev();
extern void _ZN10S1540C3_nt4v175Ev();
extern void _ZN10S1540C3_nt4v176Ev();
extern void _ZN10S1540C3_nt4v177Ev();
extern void _ZN10S1540C3_nt4v178Ev();
extern void _ZN10S1540C3_nt4v179Ev();
extern void _ZN10S1540C3_nt4v180Ev();
extern void _ZN10S1540C3_nt4v181Ev();
extern void _ZN10S1540C3_nt4v182Ev();
extern void _ZN10S1540C3_nt4v183Ev();
extern void _ZN10S1540C3_nt4v184Ev();
extern void _ZN10S1540C3_nt4v185Ev();
extern void _ZN10S1540C3_nt4v186Ev();
extern void _ZN10S1540C3_nt4v187Ev();
extern void _ZN10S1540C3_nt4v188Ev();
extern void _ZN10S1540C3_nt4v189Ev();
extern void _ZN10S1540C3_nt4v190Ev();
extern void _ZN10S1540C3_nt4v191Ev();
extern void _ZN10S1540C3_nt4v192Ev();
extern void _ZN10S1540C3_nt4v193Ev();
extern void _ZN10S1540C3_nt4v194Ev();
extern void _ZN10S1540C3_nt4v195Ev();
extern void _ZN10S1540C3_nt4v196Ev();
extern void _ZN10S1540C3_nt4v197Ev();
extern void _ZN10S1540C3_nt4v198Ev();
extern void _ZN10S1540C3_nt4v199Ev();
extern void _ZN10S1540C3_nt4v200Ev();
extern void _ZN10S1540C3_nt4v201Ev();
extern void _ZN10S1540C3_nt4v202Ev();
extern void _ZN10S1540C3_nt4v203Ev();
extern void _ZN10S1540C3_nt4v204Ev();
extern void _ZN10S1540C3_nt4v205Ev();
extern void _ZN10S1540C3_nt4v206Ev();
extern void _ZN10S1540C3_nt4v207Ev();
extern void _ZN10S1540C3_nt4v208Ev();
extern void _ZN10S1540C3_nt4v209Ev();
extern void _ZN10S1540C3_nt4v210Ev();
extern void _ZN10S1540C3_nt4v211Ev();
extern void _ZN10S1540C3_nt4v212Ev();
extern void _ZN10S1540C3_nt4v213Ev();
static  VTBL_ENTRY vtc_S1540C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1540C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1540C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v213Ev,
};
extern VTBL_ENTRY _ZTI10S1540C3_nt[];
VTBL_ENTRY *P__ZTI10S1540C3_nt = _ZTI10S1540C3_nt; 
extern  VTBL_ENTRY _ZTV10S1540C3_nt[];
Class_Descriptor cd_S1540C3_nt = {  "S1540C3_nt", // class name
  bases_S1540C3_nt, 1,
  &(vtc_S1540C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1540C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1540C3_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C23_nt  {
  ::S1540C14_nt s1540c23f0;
  ::S1540C14_nt s1540c23f1;
  char s1540c23f2;
  void  mf1540c23(); // _ZN11S1540C23_nt9mf1540c23Ev
};
//SIG(-1 S1540C23_nt) C1{ m FC2{ m Fi[3]} FC2 Fc}


void  S1540C23_nt ::mf1540c23(){}

//skip512 S1540C23_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C22_nt  {
  ::S1540C23_nt s1540c22f0;
  ::S1540C14_nt s1540c22f1;
  void *s1540c22f2[2];
  char s1540c22f3;
  void  mf1540c22(); // _ZN11S1540C22_nt9mf1540c22Ev
};
//SIG(-1 S1540C22_nt) C1{ m FC2{ m FC3{ m Fi[3]} FC3 Fc} FC3 Fp[2] Fc}


void  S1540C22_nt ::mf1540c22(){}

//skip512 S1540C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C25  : S1540C8_nt {
};
//SIG(-1 S1540C25) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1540C25()
{
  extern Class_Descriptor cd_S1540C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1540C25, buf);
    S1540C25 &lv = *(new (buf) S1540C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1540C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1540C25)");
    check_base_class_offset(lv, (S1540C8_nt*), 0, "S1540C25");
    test_class_info(&lv, &cd_S1540C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1540C25(Test_S1540C25, "S1540C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1540C8_nt;
static Base_Class bases_S1540C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1540C25 = {  "S1540C25", // class name
  bases_S1540C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C24  : S1540C25 {
};
//SIG(-1 S1540C24) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1540C24()
{
  extern Class_Descriptor cd_S1540C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1540C24, buf);
    S1540C24 &lv = *(new (buf) S1540C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1540C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1540C24)");
    check_base_class_offset(lv, (S1540C8_nt*)(S1540C25*), 0, "S1540C24");
    check_base_class_offset(lv, (S1540C25*), 0, "S1540C24");
    test_class_info(&lv, &cd_S1540C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1540C24(Test_S1540C24, "S1540C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1540C8_nt;
extern Class_Descriptor cd_S1540C25;
static Base_Class bases_S1540C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1540C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1540C24 = {  "S1540C24", // class name
  bases_S1540C24, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C29  : S1540C8_nt {
};
//SIG(-1 S1540C29) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1540C29()
{
  extern Class_Descriptor cd_S1540C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1540C29, buf);
    S1540C29 &lv = *(new (buf) S1540C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1540C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1540C29)");
    check_base_class_offset(lv, (S1540C8_nt*), 0, "S1540C29");
    test_class_info(&lv, &cd_S1540C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1540C29(Test_S1540C29, "S1540C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1540C8_nt;
static Base_Class bases_S1540C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1540C29 = {  "S1540C29", // class name
  bases_S1540C29, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C28  : S1540C29 {
};
//SIG(-1 S1540C28) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1540C28()
{
  extern Class_Descriptor cd_S1540C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1540C28, buf);
    S1540C28 &lv = *(new (buf) S1540C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1540C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1540C28)");
    check_base_class_offset(lv, (S1540C8_nt*)(S1540C29*), 0, "S1540C28");
    check_base_class_offset(lv, (S1540C29*), 0, "S1540C28");
    test_class_info(&lv, &cd_S1540C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1540C28(Test_S1540C28, "S1540C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1540C8_nt;
extern Class_Descriptor cd_S1540C29;
static Base_Class bases_S1540C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1540C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1540C28 = {  "S1540C28", // class name
  bases_S1540C28, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C31_nt  {
  int s1540c31f0[4];
  void  mf1540c31(); // _ZN11S1540C31_nt9mf1540c31Ev
};
//SIG(-1 S1540C31_nt) C1{ m Fi[4]}


void  S1540C31_nt ::mf1540c31(){}

//skip512 S1540C31_nt

#else // __cplusplus

Class_Descriptor cd_S1540C31_nt = {  "S1540C31_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C2_nt  : S1540C3_nt {
  unsigned int s1540c2f0:1;
  unsigned int s1540c2f1:1;
  unsigned int s1540c2f2:1;
  unsigned int s1540c2f3:1;
  unsigned int s1540c2f4:1;
  ::S1540C22_nt s1540c2f5;
  unsigned int s1540c2f6:1;
  unsigned int s1540c2f7:1;
  unsigned int s1540c2f8:1;
  unsigned int s1540c2f9:1;
  unsigned int s1540c2f10:1;
  unsigned int s1540c2f11:1;
  unsigned int s1540c2f12:1;
  unsigned int s1540c2f13:1;
  unsigned int s1540c2f14:1;
  unsigned int s1540c2f15:1;
  unsigned int s1540c2f16:1;
  unsigned int s1540c2f17:1;
  unsigned int s1540c2f18:1;
  unsigned int s1540c2f19:1;
  unsigned int s1540c2f20:1;
  unsigned int s1540c2f21:1;
  unsigned int s1540c2f22:1;
  unsigned int s1540c2f23:1;
  unsigned int s1540c2f24:1;
  unsigned int s1540c2f25:1;
  unsigned int s1540c2f26:1;
  unsigned int s1540c2f27:1;
  unsigned int s1540c2f28:1;
  unsigned int s1540c2f29:1;
  unsigned int s1540c2f30:1;
  ::S1540C24 s1540c2f31;
  ::S1540C24 s1540c2f32;
  ::S1540C24 s1540c2f33;
  ::S1540C28 s1540c2f34;
  int s1540c2f35[2];
  void *s1540c2f36[4];
  int s1540c2f37[5];
  void *s1540c2f38;
  int s1540c2f39[2];
  void *s1540c2f40[2];
  int s1540c2f41;
  ::S1540C5_nt s1540c2f42;
  ::S1540C31_nt s1540c2f43;
  void *s1540c2f44[2];
  int s1540c2f45;
  void *s1540c2f46;
  int s1540c2f47;
  virtual  ~S1540C2_nt(); // _ZN10S1540C2_ntD1Ev
  virtual void  v214(); // _ZN10S1540C2_nt4v214Ev
  virtual void  v215(); // _ZN10S1540C2_nt4v215Ev
  virtual void  v216(); // _ZN10S1540C2_nt4v216Ev
  virtual void  v217(); // _ZN10S1540C2_nt4v217Ev
  virtual void  v218(); // _ZN10S1540C2_nt4v218Ev
  virtual void  v219(); // _ZN10S1540C2_nt4v219Ev
  virtual void  v220(); // _ZN10S1540C2_nt4v220Ev
  virtual void  v221(); // _ZN10S1540C2_nt4v221Ev
  virtual void  v222(); // _ZN10S1540C2_nt4v222Ev
  virtual void  v223(); // _ZN10S1540C2_nt4v223Ev
  virtual void  v224(); // _ZN10S1540C2_nt4v224Ev
  virtual void  v225(); // _ZN10S1540C2_nt4v225Ev
  virtual void  v226(); // _ZN10S1540C2_nt4v226Ev
  virtual void  v227(); // _ZN10S1540C2_nt4v227Ev
  virtual void  v228(); // _ZN10S1540C2_nt4v228Ev
  virtual void  v229(); // _ZN10S1540C2_nt4v229Ev
  virtual void  v230(); // _ZN10S1540C2_nt4v230Ev
  virtual void  v231(); // _ZN10S1540C2_nt4v231Ev
  virtual void  v232(); // _ZN10S1540C2_nt4v232Ev
  virtual void  v233(); // _ZN10S1540C2_nt4v233Ev
  virtual void  v234(); // _ZN10S1540C2_nt4v234Ev
  virtual void  v235(); // _ZN10S1540C2_nt4v235Ev
  virtual void  v236(); // _ZN10S1540C2_nt4v236Ev
  virtual void  v237(); // _ZN10S1540C2_nt4v237Ev
  virtual void  v238(); // _ZN10S1540C2_nt4v238Ev
  virtual void  v239(); // _ZN10S1540C2_nt4v239Ev
  virtual void  v240(); // _ZN10S1540C2_nt4v240Ev
  virtual void  v241(); // _ZN10S1540C2_nt4v241Ev
  virtual void  v242(); // _ZN10S1540C2_nt4v242Ev
  virtual void  v243(); // _ZN10S1540C2_nt4v243Ev
  virtual void  v244(); // _ZN10S1540C2_nt4v244Ev
  virtual void  v245(); // _ZN10S1540C2_nt4v245Ev
  virtual void  v246(); // _ZN10S1540C2_nt4v246Ev
  virtual void  v247(); // _ZN10S1540C2_nt4v247Ev
  virtual void  v248(); // _ZN10S1540C2_nt4v248Ev
  virtual void  v249(); // _ZN10S1540C2_nt4v249Ev
  virtual void  v250(); // _ZN10S1540C2_nt4v250Ev
  S1540C2_nt(); // tgen
};
//SIG(-1 S1540C2_nt) C1{ BC2{ BC3{ vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ m FC15{ m FC11 FC11 Fc} FC11 Fp[2] Fc} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC16{ BC17{ BC7}} FC16 FC16 FC18{ BC19{ BC7}} Fi[2] Fp[4] Fi[5] Fp Fi[2] Fp[2] Fi FC4 FC20{ m Fi[4]} Fp[2] Fi Fp Fi}


 S1540C2_nt ::~S1540C2_nt(){ note_dtor("S1540C2_nt", this);}
void  S1540C2_nt ::v214(){vfunc_called(this, "_ZN10S1540C2_nt4v214Ev");}
void  S1540C2_nt ::v215(){vfunc_called(this, "_ZN10S1540C2_nt4v215Ev");}
void  S1540C2_nt ::v216(){vfunc_called(this, "_ZN10S1540C2_nt4v216Ev");}
void  S1540C2_nt ::v217(){vfunc_called(this, "_ZN10S1540C2_nt4v217Ev");}
void  S1540C2_nt ::v218(){vfunc_called(this, "_ZN10S1540C2_nt4v218Ev");}
void  S1540C2_nt ::v219(){vfunc_called(this, "_ZN10S1540C2_nt4v219Ev");}
void  S1540C2_nt ::v220(){vfunc_called(this, "_ZN10S1540C2_nt4v220Ev");}
void  S1540C2_nt ::v221(){vfunc_called(this, "_ZN10S1540C2_nt4v221Ev");}
void  S1540C2_nt ::v222(){vfunc_called(this, "_ZN10S1540C2_nt4v222Ev");}
void  S1540C2_nt ::v223(){vfunc_called(this, "_ZN10S1540C2_nt4v223Ev");}
void  S1540C2_nt ::v224(){vfunc_called(this, "_ZN10S1540C2_nt4v224Ev");}
void  S1540C2_nt ::v225(){vfunc_called(this, "_ZN10S1540C2_nt4v225Ev");}
void  S1540C2_nt ::v226(){vfunc_called(this, "_ZN10S1540C2_nt4v226Ev");}
void  S1540C2_nt ::v227(){vfunc_called(this, "_ZN10S1540C2_nt4v227Ev");}
void  S1540C2_nt ::v228(){vfunc_called(this, "_ZN10S1540C2_nt4v228Ev");}
void  S1540C2_nt ::v229(){vfunc_called(this, "_ZN10S1540C2_nt4v229Ev");}
void  S1540C2_nt ::v230(){vfunc_called(this, "_ZN10S1540C2_nt4v230Ev");}
void  S1540C2_nt ::v231(){vfunc_called(this, "_ZN10S1540C2_nt4v231Ev");}
void  S1540C2_nt ::v232(){vfunc_called(this, "_ZN10S1540C2_nt4v232Ev");}
void  S1540C2_nt ::v233(){vfunc_called(this, "_ZN10S1540C2_nt4v233Ev");}
void  S1540C2_nt ::v234(){vfunc_called(this, "_ZN10S1540C2_nt4v234Ev");}
void  S1540C2_nt ::v235(){vfunc_called(this, "_ZN10S1540C2_nt4v235Ev");}
void  S1540C2_nt ::v236(){vfunc_called(this, "_ZN10S1540C2_nt4v236Ev");}
void  S1540C2_nt ::v237(){vfunc_called(this, "_ZN10S1540C2_nt4v237Ev");}
void  S1540C2_nt ::v238(){vfunc_called(this, "_ZN10S1540C2_nt4v238Ev");}
void  S1540C2_nt ::v239(){vfunc_called(this, "_ZN10S1540C2_nt4v239Ev");}
void  S1540C2_nt ::v240(){vfunc_called(this, "_ZN10S1540C2_nt4v240Ev");}
void  S1540C2_nt ::v241(){vfunc_called(this, "_ZN10S1540C2_nt4v241Ev");}
void  S1540C2_nt ::v242(){vfunc_called(this, "_ZN10S1540C2_nt4v242Ev");}
void  S1540C2_nt ::v243(){vfunc_called(this, "_ZN10S1540C2_nt4v243Ev");}
void  S1540C2_nt ::v244(){vfunc_called(this, "_ZN10S1540C2_nt4v244Ev");}
void  S1540C2_nt ::v245(){vfunc_called(this, "_ZN10S1540C2_nt4v245Ev");}
void  S1540C2_nt ::v246(){vfunc_called(this, "_ZN10S1540C2_nt4v246Ev");}
void  S1540C2_nt ::v247(){vfunc_called(this, "_ZN10S1540C2_nt4v247Ev");}
void  S1540C2_nt ::v248(){vfunc_called(this, "_ZN10S1540C2_nt4v248Ev");}
void  S1540C2_nt ::v249(){vfunc_called(this, "_ZN10S1540C2_nt4v249Ev");}
void  S1540C2_nt ::v250(){vfunc_called(this, "_ZN10S1540C2_nt4v250Ev");}
S1540C2_nt ::S1540C2_nt(){ note_ctor("S1540C2_nt", this);} // tgen

//skip512 S1540C2_nt

#else // __cplusplus

extern void _ZN10S1540C2_ntC1Ev();
extern void _ZN10S1540C2_ntD1Ev();
Name_Map name_map_S1540C2_nt[] = {
  NSPAIR(_ZN10S1540C2_ntC1Ev),
  NSPAIR(_ZN10S1540C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1540C4_nt;
extern VTBL_ENTRY _ZTI10S1540C4_nt[];
extern  VTBL_ENTRY _ZTV10S1540C4_nt[];
extern Class_Descriptor cd_S1540C3_nt;
extern VTBL_ENTRY _ZTI10S1540C3_nt[];
extern  VTBL_ENTRY _ZTV10S1540C3_nt[];
static Base_Class bases_S1540C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1540C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1540C2_nt[];
extern void _ZN10S1540C2_ntD1Ev();
extern void _ZN10S1540C2_ntD0Ev();
extern void _ZN10S1540C4_nt2v7Ev();
extern void _ZN10S1540C4_nt2v8Ev();
extern void _ZN10S1540C4_nt2v9Ev();
extern void _ZN10S1540C4_nt3v10Ev();
extern void _ZN10S1540C4_nt3v11Ev();
extern void _ZN10S1540C4_nt3v12Ev();
extern void _ZN10S1540C4_nt3v13Ev();
extern void _ZN10S1540C4_nt3v14Ev();
extern void _ZN10S1540C4_nt3v15Ev();
extern void _ZN10S1540C4_nt3v16Ev();
extern void _ZN10S1540C4_nt3v17Ev();
extern void _ZN10S1540C4_nt3v18Ev();
extern void _ZN10S1540C4_nt3v19Ev();
extern void _ZN10S1540C4_nt3v20Ev();
extern void _ZN10S1540C4_nt3v21Ev();
extern void _ZN10S1540C4_nt3v22Ev();
extern void _ZN10S1540C4_nt3v23Ev();
extern void _ZN10S1540C4_nt3v24Ev();
extern void _ZN10S1540C4_nt3v25Ev();
extern void _ZN10S1540C4_nt3v26Ev();
extern void _ZN10S1540C4_nt3v27Ev();
extern void _ZN10S1540C4_nt3v28Ev();
extern void _ZN10S1540C4_nt3v29Ev();
extern void _ZN10S1540C4_nt3v30Ev();
extern void _ZN10S1540C4_nt3v31Ev();
extern void _ZN10S1540C4_nt3v32Ev();
extern void _ZN10S1540C4_nt3v33Ev();
extern void _ZN10S1540C4_nt3v34Ev();
extern void _ZN10S1540C4_nt3v35Ev();
extern void _ZN10S1540C4_nt3v36Ev();
extern void _ZN10S1540C4_nt3v37Ev();
extern void _ZN10S1540C4_nt3v38Ev();
extern void _ZN10S1540C4_nt3v39Ev();
extern void _ZN10S1540C4_nt3v40Ev();
extern void _ZN10S1540C4_nt3v41Ev();
extern void _ZN10S1540C4_nt3v42Ev();
extern void _ZN10S1540C4_nt3v43Ev();
extern void _ZN10S1540C4_nt3v44Ev();
extern void _ZN10S1540C4_nt3v45Ev();
extern void _ZN10S1540C4_nt3v46Ev();
extern void _ZN10S1540C4_nt3v47Ev();
extern void _ZN10S1540C4_nt3v48Ev();
extern void _ZN10S1540C4_nt3v49Ev();
extern void _ZN10S1540C4_nt3v50Ev();
extern void _ZN10S1540C4_nt3v51Ev();
extern void _ZN10S1540C4_nt3v52Ev();
extern void _ZN10S1540C4_nt3v53Ev();
extern void _ZN10S1540C4_nt3v54Ev();
extern void _ZN10S1540C4_nt3v55Ev();
extern void _ZN10S1540C4_nt3v56Ev();
extern void _ZN10S1540C4_nt3v57Ev();
extern void _ZN10S1540C4_nt3v58Ev();
extern void _ZN10S1540C4_nt3v59Ev();
extern void _ZN10S1540C4_nt3v60Ev();
extern void _ZN10S1540C4_nt3v61Ev();
extern void _ZN10S1540C4_nt3v62Ev();
extern void _ZN10S1540C4_nt3v63Ev();
extern void _ZN10S1540C4_nt3v64Ev();
extern void _ZN10S1540C4_nt3v65Ev();
extern void _ZN10S1540C4_nt3v66Ev();
extern void _ZN10S1540C4_nt3v67Ev();
extern void _ZN10S1540C4_nt3v68Ev();
extern void _ZN10S1540C4_nt3v69Ev();
extern void _ZN10S1540C4_nt3v70Ev();
extern void _ZN10S1540C3_nt3v71Ev();
extern void _ZN10S1540C3_nt3v72Ev();
extern void _ZN10S1540C3_nt3v73Ev();
extern void _ZN10S1540C3_nt3v74Ev();
extern void _ZN10S1540C3_nt3v75Ev();
extern void _ZN10S1540C3_nt3v76Ev();
extern void _ZN10S1540C3_nt3v77Ev();
extern void _ZN10S1540C3_nt3v78Ev();
extern void _ZN10S1540C3_nt3v79Ev();
extern void _ZN10S1540C3_nt3v80Ev();
extern void _ZN10S1540C3_nt3v81Ev();
extern void _ZN10S1540C3_nt3v82Ev();
extern void _ZN10S1540C3_nt3v83Ev();
extern void _ZN10S1540C3_nt3v84Ev();
extern void _ZN10S1540C3_nt3v85Ev();
extern void _ZN10S1540C3_nt3v86Ev();
extern void _ZN10S1540C3_nt3v87Ev();
extern void _ZN10S1540C3_nt3v88Ev();
extern void _ZN10S1540C3_nt3v89Ev();
extern void _ZN10S1540C3_nt3v90Ev();
extern void _ZN10S1540C3_nt3v91Ev();
extern void _ZN10S1540C3_nt3v92Ev();
extern void _ZN10S1540C3_nt3v93Ev();
extern void _ZN10S1540C3_nt3v94Ev();
extern void _ZN10S1540C3_nt3v95Ev();
extern void _ZN10S1540C3_nt3v96Ev();
extern void _ZN10S1540C3_nt3v97Ev();
extern void _ZN10S1540C3_nt3v98Ev();
extern void _ZN10S1540C3_nt3v99Ev();
extern void _ZN10S1540C3_nt4v100Ev();
extern void _ZN10S1540C3_nt4v101Ev();
extern void _ZN10S1540C3_nt4v102Ev();
extern void _ZN10S1540C3_nt4v103Ev();
extern void _ZN10S1540C3_nt4v104Ev();
extern void _ZN10S1540C3_nt4v105Ev();
extern void _ZN10S1540C3_nt4v106Ev();
extern void _ZN10S1540C3_nt4v107Ev();
extern void _ZN10S1540C3_nt4v108Ev();
extern void _ZN10S1540C3_nt4v109Ev();
extern void _ZN10S1540C3_nt4v110Ev();
extern void _ZN10S1540C3_nt4v111Ev();
extern void _ZN10S1540C3_nt4v112Ev();
extern void _ZN10S1540C3_nt4v113Ev();
extern void _ZN10S1540C3_nt4v114Ev();
extern void _ZN10S1540C3_nt4v115Ev();
extern void _ZN10S1540C3_nt4v116Ev();
extern void _ZN10S1540C3_nt4v117Ev();
extern void _ZN10S1540C3_nt4v118Ev();
extern void _ZN10S1540C3_nt4v119Ev();
extern void _ZN10S1540C3_nt4v120Ev();
extern void _ZN10S1540C3_nt4v121Ev();
extern void _ZN10S1540C3_nt4v122Ev();
extern void _ZN10S1540C3_nt4v123Ev();
extern void _ZN10S1540C3_nt4v124Ev();
extern void _ZN10S1540C3_nt4v125Ev();
extern void _ZN10S1540C3_nt4v126Ev();
extern void _ZN10S1540C3_nt4v127Ev();
extern void _ZN10S1540C3_nt4v128Ev();
extern void _ZN10S1540C3_nt4v129Ev();
extern void _ZN10S1540C3_nt4v130Ev();
extern void _ZN10S1540C3_nt4v131Ev();
extern void _ZN10S1540C3_nt4v132Ev();
extern void _ZN10S1540C3_nt4v133Ev();
extern void _ZN10S1540C3_nt4v134Ev();
extern void _ZN10S1540C3_nt4v135Ev();
extern void _ZN10S1540C3_nt4v136Ev();
extern void _ZN10S1540C3_nt4v137Ev();
extern void _ZN10S1540C3_nt4v138Ev();
extern void _ZN10S1540C3_nt4v139Ev();
extern void _ZN10S1540C3_nt4v140Ev();
extern void _ZN10S1540C3_nt4v141Ev();
extern void _ZN10S1540C3_nt4v142Ev();
extern void _ZN10S1540C3_nt4v143Ev();
extern void _ZN10S1540C3_nt4v144Ev();
extern void _ZN10S1540C3_nt4v145Ev();
extern void _ZN10S1540C3_nt4v146Ev();
extern void _ZN10S1540C3_nt4v147Ev();
extern void _ZN10S1540C3_nt4v148Ev();
extern void _ZN10S1540C3_nt4v149Ev();
extern void _ZN10S1540C3_nt4v150Ev();
extern void _ZN10S1540C3_nt4v151Ev();
extern void _ZN10S1540C3_nt4v152Ev();
extern void _ZN10S1540C3_nt4v153Ev();
extern void _ZN10S1540C3_nt4v154Ev();
extern void _ZN10S1540C3_nt4v155Ev();
extern void _ZN10S1540C3_nt4v156Ev();
extern void _ZN10S1540C3_nt4v157Ev();
extern void _ZN10S1540C3_nt4v158Ev();
extern void _ZN10S1540C3_nt4v159Ev();
extern void _ZN10S1540C3_nt4v160Ev();
extern void _ZN10S1540C3_nt4v161Ev();
extern void _ZN10S1540C3_nt4v162Ev();
extern void _ZN10S1540C3_nt4v163Ev();
extern void _ZN10S1540C3_nt4v164Ev();
extern void _ZN10S1540C3_nt4v165Ev();
extern void _ZN10S1540C3_nt4v166Ev();
extern void _ZN10S1540C3_nt4v167Ev();
extern void _ZN10S1540C3_nt4v168Ev();
extern void _ZN10S1540C3_nt4v169Ev();
extern void _ZN10S1540C3_nt4v170Ev();
extern void _ZN10S1540C3_nt4v171Ev();
extern void _ZN10S1540C3_nt4v172Ev();
extern void _ZN10S1540C3_nt4v173Ev();
extern void _ZN10S1540C3_nt4v174Ev();
extern void _ZN10S1540C3_nt4v175Ev();
extern void _ZN10S1540C3_nt4v176Ev();
extern void _ZN10S1540C3_nt4v177Ev();
extern void _ZN10S1540C3_nt4v178Ev();
extern void _ZN10S1540C3_nt4v179Ev();
extern void _ZN10S1540C3_nt4v180Ev();
extern void _ZN10S1540C3_nt4v181Ev();
extern void _ZN10S1540C3_nt4v182Ev();
extern void _ZN10S1540C3_nt4v183Ev();
extern void _ZN10S1540C3_nt4v184Ev();
extern void _ZN10S1540C3_nt4v185Ev();
extern void _ZN10S1540C3_nt4v186Ev();
extern void _ZN10S1540C3_nt4v187Ev();
extern void _ZN10S1540C3_nt4v188Ev();
extern void _ZN10S1540C3_nt4v189Ev();
extern void _ZN10S1540C3_nt4v190Ev();
extern void _ZN10S1540C3_nt4v191Ev();
extern void _ZN10S1540C3_nt4v192Ev();
extern void _ZN10S1540C3_nt4v193Ev();
extern void _ZN10S1540C3_nt4v194Ev();
extern void _ZN10S1540C3_nt4v195Ev();
extern void _ZN10S1540C3_nt4v196Ev();
extern void _ZN10S1540C3_nt4v197Ev();
extern void _ZN10S1540C3_nt4v198Ev();
extern void _ZN10S1540C3_nt4v199Ev();
extern void _ZN10S1540C3_nt4v200Ev();
extern void _ZN10S1540C3_nt4v201Ev();
extern void _ZN10S1540C3_nt4v202Ev();
extern void _ZN10S1540C3_nt4v203Ev();
extern void _ZN10S1540C3_nt4v204Ev();
extern void _ZN10S1540C3_nt4v205Ev();
extern void _ZN10S1540C3_nt4v206Ev();
extern void _ZN10S1540C3_nt4v207Ev();
extern void _ZN10S1540C3_nt4v208Ev();
extern void _ZN10S1540C3_nt4v209Ev();
extern void _ZN10S1540C3_nt4v210Ev();
extern void _ZN10S1540C3_nt4v211Ev();
extern void _ZN10S1540C3_nt4v212Ev();
extern void _ZN10S1540C3_nt4v213Ev();
extern void _ZN10S1540C2_nt4v214Ev();
extern void _ZN10S1540C2_nt4v215Ev();
extern void _ZN10S1540C2_nt4v216Ev();
extern void _ZN10S1540C2_nt4v217Ev();
extern void _ZN10S1540C2_nt4v218Ev();
extern void _ZN10S1540C2_nt4v219Ev();
extern void _ZN10S1540C2_nt4v220Ev();
extern void _ZN10S1540C2_nt4v221Ev();
extern void _ZN10S1540C2_nt4v222Ev();
extern void _ZN10S1540C2_nt4v223Ev();
extern void _ZN10S1540C2_nt4v224Ev();
extern void _ZN10S1540C2_nt4v225Ev();
extern void _ZN10S1540C2_nt4v226Ev();
extern void _ZN10S1540C2_nt4v227Ev();
extern void _ZN10S1540C2_nt4v228Ev();
extern void _ZN10S1540C2_nt4v229Ev();
extern void _ZN10S1540C2_nt4v230Ev();
extern void _ZN10S1540C2_nt4v231Ev();
extern void _ZN10S1540C2_nt4v232Ev();
extern void _ZN10S1540C2_nt4v233Ev();
extern void _ZN10S1540C2_nt4v234Ev();
extern void _ZN10S1540C2_nt4v235Ev();
extern void _ZN10S1540C2_nt4v236Ev();
extern void _ZN10S1540C2_nt4v237Ev();
extern void _ZN10S1540C2_nt4v238Ev();
extern void _ZN10S1540C2_nt4v239Ev();
extern void _ZN10S1540C2_nt4v240Ev();
extern void _ZN10S1540C2_nt4v241Ev();
extern void _ZN10S1540C2_nt4v242Ev();
extern void _ZN10S1540C2_nt4v243Ev();
extern void _ZN10S1540C2_nt4v244Ev();
extern void _ZN10S1540C2_nt4v245Ev();
extern void _ZN10S1540C2_nt4v246Ev();
extern void _ZN10S1540C2_nt4v247Ev();
extern void _ZN10S1540C2_nt4v248Ev();
extern void _ZN10S1540C2_nt4v249Ev();
extern void _ZN10S1540C2_nt4v250Ev();
static  VTBL_ENTRY vtc_S1540C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1540C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1540C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v237Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v238Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v239Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v240Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v241Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v242Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v243Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v244Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v245Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v246Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v247Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v248Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v249Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v250Ev,
};
extern VTBL_ENTRY _ZTI10S1540C2_nt[];
VTBL_ENTRY *P__ZTI10S1540C2_nt = _ZTI10S1540C2_nt; 
extern  VTBL_ENTRY _ZTV10S1540C2_nt[];
Class_Descriptor cd_S1540C2_nt = {  "S1540C2_nt", // class name
  bases_S1540C2_nt, 2,
  &(vtc_S1540C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(880,656), // object size
  NSPAIRA(_ZTI10S1540C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1540C2_nt),248, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1540C1  : S1540C2_nt {
  void *s1540c1f0;
  int s1540c1f1;
  ::S1540C14_nt s1540c1f2;
  unsigned int s1540c1f3:1;
  int s1540c1f4;
  void *s1540c1f5;
  virtual  ~S1540C1(); // _ZN7S1540C1D1Ev
  virtual void  v1(); // _ZN7S1540C12v1Ev
  virtual void  v2(); // _ZN7S1540C12v2Ev
  virtual void  v3(); // _ZN7S1540C12v3Ev
  virtual void  v4(); // _ZN7S1540C12v4Ev
  virtual void  v5(); // _ZN7S1540C12v5Ev
  virtual void  v6(); // _ZN7S1540C12v6Ev
  S1540C1(); // tgen
};
//SIG(1 S1540C1) C1{ BC2{ BC3{ BC4{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v214 v215 v216 v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 v227 v228 v229 v230 v231 v232 v233 v234 v235 v236 v237 v238 v239 v240 v241 v242 v243 v244 v245 v246 v247 v248 v249 v250 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC15{ m FC16{ m FC12 FC12 Fc} FC12 Fp[2] Fc} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC17{ BC18{ BC8}} FC17 FC17 FC19{ BC20{ BC8}} Fi[2] Fp[4] Fi[5] Fp Fi[2] Fp[2] Fi FC5 FC21{ m Fi[4]} Fp[2] Fi Fp Fi} vd v1 v2 v3 v4 v5 v6 Fp Fi FC12 Fi:1 Fi Fp}


 S1540C1 ::~S1540C1(){ note_dtor("S1540C1", this);}
void  S1540C1 ::v1(){vfunc_called(this, "_ZN7S1540C12v1Ev");}
void  S1540C1 ::v2(){vfunc_called(this, "_ZN7S1540C12v2Ev");}
void  S1540C1 ::v3(){vfunc_called(this, "_ZN7S1540C12v3Ev");}
void  S1540C1 ::v4(){vfunc_called(this, "_ZN7S1540C12v4Ev");}
void  S1540C1 ::v5(){vfunc_called(this, "_ZN7S1540C12v5Ev");}
void  S1540C1 ::v6(){vfunc_called(this, "_ZN7S1540C12v6Ev");}
S1540C1 ::S1540C1(){ note_ctor("S1540C1", this);} // tgen

static void Test_S1540C1()
{
  extern Class_Descriptor cd_S1540C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(116,173)];
    init_test(&cd_S1540C1, buf);
    S1540C1 *dp, &lv = *(dp=new (buf) S1540C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(920,688), "sizeof(S1540C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1540C1)");
    check_base_class_offset(lv, (S1540C4_nt*)(S1540C3_nt*)(S1540C2_nt*), 0, "S1540C1");
    check_base_class_offset(lv, (S1540C3_nt*)(S1540C2_nt*), 0, "S1540C1");
    check_base_class_offset(lv, (S1540C2_nt*), 0, "S1540C1");
    check_field_offset(lv, s1540c1f0, ABISELECT(880,656), "S1540C1.s1540c1f0");
    check_field_offset(lv, s1540c1f1, ABISELECT(888,660), "S1540C1.s1540c1f1");
    check_field_offset(lv, s1540c1f2, ABISELECT(892,664), "S1540C1.s1540c1f2");
    set_bf_and_test(lv, s1540c1f3, ABISELECT(904,676), 0, 1, 1, "S1540C1");
    check_field_offset(lv, s1540c1f4, ABISELECT(908,680), "S1540C1.s1540c1f4");
    check_field_offset(lv, s1540c1f5, ABISELECT(912,684), "S1540C1.s1540c1f5");
    test_class_info(&lv, &cd_S1540C1);
    dp->~S1540C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1540C1(Test_S1540C1, "S1540C1", ABISELECT(920,688));

#else // __cplusplus

extern void _ZN7S1540C1C1Ev();
extern void _ZN7S1540C1D1Ev();
Name_Map name_map_S1540C1[] = {
  NSPAIR(_ZN7S1540C1C1Ev),
  NSPAIR(_ZN7S1540C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1540C4_nt;
extern VTBL_ENTRY _ZTI10S1540C4_nt[];
extern  VTBL_ENTRY _ZTV10S1540C4_nt[];
extern Class_Descriptor cd_S1540C3_nt;
extern VTBL_ENTRY _ZTI10S1540C3_nt[];
extern  VTBL_ENTRY _ZTV10S1540C3_nt[];
extern Class_Descriptor cd_S1540C2_nt;
extern VTBL_ENTRY _ZTI10S1540C2_nt[];
extern  VTBL_ENTRY _ZTV10S1540C2_nt[];
static Base_Class bases_S1540C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1540C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1540C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1540C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1540C1[];
extern void _ZN7S1540C1D1Ev();
extern void _ZN7S1540C1D0Ev();
extern void _ZN10S1540C4_nt2v7Ev();
extern void _ZN10S1540C4_nt2v8Ev();
extern void _ZN10S1540C4_nt2v9Ev();
extern void _ZN10S1540C4_nt3v10Ev();
extern void _ZN10S1540C4_nt3v11Ev();
extern void _ZN10S1540C4_nt3v12Ev();
extern void _ZN10S1540C4_nt3v13Ev();
extern void _ZN10S1540C4_nt3v14Ev();
extern void _ZN10S1540C4_nt3v15Ev();
extern void _ZN10S1540C4_nt3v16Ev();
extern void _ZN10S1540C4_nt3v17Ev();
extern void _ZN10S1540C4_nt3v18Ev();
extern void _ZN10S1540C4_nt3v19Ev();
extern void _ZN10S1540C4_nt3v20Ev();
extern void _ZN10S1540C4_nt3v21Ev();
extern void _ZN10S1540C4_nt3v22Ev();
extern void _ZN10S1540C4_nt3v23Ev();
extern void _ZN10S1540C4_nt3v24Ev();
extern void _ZN10S1540C4_nt3v25Ev();
extern void _ZN10S1540C4_nt3v26Ev();
extern void _ZN10S1540C4_nt3v27Ev();
extern void _ZN10S1540C4_nt3v28Ev();
extern void _ZN10S1540C4_nt3v29Ev();
extern void _ZN10S1540C4_nt3v30Ev();
extern void _ZN10S1540C4_nt3v31Ev();
extern void _ZN10S1540C4_nt3v32Ev();
extern void _ZN10S1540C4_nt3v33Ev();
extern void _ZN10S1540C4_nt3v34Ev();
extern void _ZN10S1540C4_nt3v35Ev();
extern void _ZN10S1540C4_nt3v36Ev();
extern void _ZN10S1540C4_nt3v37Ev();
extern void _ZN10S1540C4_nt3v38Ev();
extern void _ZN10S1540C4_nt3v39Ev();
extern void _ZN10S1540C4_nt3v40Ev();
extern void _ZN10S1540C4_nt3v41Ev();
extern void _ZN10S1540C4_nt3v42Ev();
extern void _ZN10S1540C4_nt3v43Ev();
extern void _ZN10S1540C4_nt3v44Ev();
extern void _ZN10S1540C4_nt3v45Ev();
extern void _ZN10S1540C4_nt3v46Ev();
extern void _ZN10S1540C4_nt3v47Ev();
extern void _ZN10S1540C4_nt3v48Ev();
extern void _ZN10S1540C4_nt3v49Ev();
extern void _ZN10S1540C4_nt3v50Ev();
extern void _ZN10S1540C4_nt3v51Ev();
extern void _ZN10S1540C4_nt3v52Ev();
extern void _ZN10S1540C4_nt3v53Ev();
extern void _ZN10S1540C4_nt3v54Ev();
extern void _ZN10S1540C4_nt3v55Ev();
extern void _ZN10S1540C4_nt3v56Ev();
extern void _ZN10S1540C4_nt3v57Ev();
extern void _ZN10S1540C4_nt3v58Ev();
extern void _ZN10S1540C4_nt3v59Ev();
extern void _ZN10S1540C4_nt3v60Ev();
extern void _ZN10S1540C4_nt3v61Ev();
extern void _ZN10S1540C4_nt3v62Ev();
extern void _ZN10S1540C4_nt3v63Ev();
extern void _ZN10S1540C4_nt3v64Ev();
extern void _ZN10S1540C4_nt3v65Ev();
extern void _ZN10S1540C4_nt3v66Ev();
extern void _ZN10S1540C4_nt3v67Ev();
extern void _ZN10S1540C4_nt3v68Ev();
extern void _ZN10S1540C4_nt3v69Ev();
extern void _ZN10S1540C4_nt3v70Ev();
extern void _ZN10S1540C3_nt3v71Ev();
extern void _ZN10S1540C3_nt3v72Ev();
extern void _ZN10S1540C3_nt3v73Ev();
extern void _ZN10S1540C3_nt3v74Ev();
extern void _ZN10S1540C3_nt3v75Ev();
extern void _ZN10S1540C3_nt3v76Ev();
extern void _ZN10S1540C3_nt3v77Ev();
extern void _ZN10S1540C3_nt3v78Ev();
extern void _ZN10S1540C3_nt3v79Ev();
extern void _ZN10S1540C3_nt3v80Ev();
extern void _ZN10S1540C3_nt3v81Ev();
extern void _ZN10S1540C3_nt3v82Ev();
extern void _ZN10S1540C3_nt3v83Ev();
extern void _ZN10S1540C3_nt3v84Ev();
extern void _ZN10S1540C3_nt3v85Ev();
extern void _ZN10S1540C3_nt3v86Ev();
extern void _ZN10S1540C3_nt3v87Ev();
extern void _ZN10S1540C3_nt3v88Ev();
extern void _ZN10S1540C3_nt3v89Ev();
extern void _ZN10S1540C3_nt3v90Ev();
extern void _ZN10S1540C3_nt3v91Ev();
extern void _ZN10S1540C3_nt3v92Ev();
extern void _ZN10S1540C3_nt3v93Ev();
extern void _ZN10S1540C3_nt3v94Ev();
extern void _ZN10S1540C3_nt3v95Ev();
extern void _ZN10S1540C3_nt3v96Ev();
extern void _ZN10S1540C3_nt3v97Ev();
extern void _ZN10S1540C3_nt3v98Ev();
extern void _ZN10S1540C3_nt3v99Ev();
extern void _ZN10S1540C3_nt4v100Ev();
extern void _ZN10S1540C3_nt4v101Ev();
extern void _ZN10S1540C3_nt4v102Ev();
extern void _ZN10S1540C3_nt4v103Ev();
extern void _ZN10S1540C3_nt4v104Ev();
extern void _ZN10S1540C3_nt4v105Ev();
extern void _ZN10S1540C3_nt4v106Ev();
extern void _ZN10S1540C3_nt4v107Ev();
extern void _ZN10S1540C3_nt4v108Ev();
extern void _ZN10S1540C3_nt4v109Ev();
extern void _ZN10S1540C3_nt4v110Ev();
extern void _ZN10S1540C3_nt4v111Ev();
extern void _ZN10S1540C3_nt4v112Ev();
extern void _ZN10S1540C3_nt4v113Ev();
extern void _ZN10S1540C3_nt4v114Ev();
extern void _ZN10S1540C3_nt4v115Ev();
extern void _ZN10S1540C3_nt4v116Ev();
extern void _ZN10S1540C3_nt4v117Ev();
extern void _ZN10S1540C3_nt4v118Ev();
extern void _ZN10S1540C3_nt4v119Ev();
extern void _ZN10S1540C3_nt4v120Ev();
extern void _ZN10S1540C3_nt4v121Ev();
extern void _ZN10S1540C3_nt4v122Ev();
extern void _ZN10S1540C3_nt4v123Ev();
extern void _ZN10S1540C3_nt4v124Ev();
extern void _ZN10S1540C3_nt4v125Ev();
extern void _ZN10S1540C3_nt4v126Ev();
extern void _ZN10S1540C3_nt4v127Ev();
extern void _ZN10S1540C3_nt4v128Ev();
extern void _ZN10S1540C3_nt4v129Ev();
extern void _ZN10S1540C3_nt4v130Ev();
extern void _ZN10S1540C3_nt4v131Ev();
extern void _ZN10S1540C3_nt4v132Ev();
extern void _ZN10S1540C3_nt4v133Ev();
extern void _ZN10S1540C3_nt4v134Ev();
extern void _ZN10S1540C3_nt4v135Ev();
extern void _ZN10S1540C3_nt4v136Ev();
extern void _ZN10S1540C3_nt4v137Ev();
extern void _ZN10S1540C3_nt4v138Ev();
extern void _ZN10S1540C3_nt4v139Ev();
extern void _ZN10S1540C3_nt4v140Ev();
extern void _ZN10S1540C3_nt4v141Ev();
extern void _ZN10S1540C3_nt4v142Ev();
extern void _ZN10S1540C3_nt4v143Ev();
extern void _ZN10S1540C3_nt4v144Ev();
extern void _ZN10S1540C3_nt4v145Ev();
extern void _ZN10S1540C3_nt4v146Ev();
extern void _ZN10S1540C3_nt4v147Ev();
extern void _ZN10S1540C3_nt4v148Ev();
extern void _ZN10S1540C3_nt4v149Ev();
extern void _ZN10S1540C3_nt4v150Ev();
extern void _ZN10S1540C3_nt4v151Ev();
extern void _ZN10S1540C3_nt4v152Ev();
extern void _ZN10S1540C3_nt4v153Ev();
extern void _ZN10S1540C3_nt4v154Ev();
extern void _ZN10S1540C3_nt4v155Ev();
extern void _ZN10S1540C3_nt4v156Ev();
extern void _ZN10S1540C3_nt4v157Ev();
extern void _ZN10S1540C3_nt4v158Ev();
extern void _ZN10S1540C3_nt4v159Ev();
extern void _ZN10S1540C3_nt4v160Ev();
extern void _ZN10S1540C3_nt4v161Ev();
extern void _ZN10S1540C3_nt4v162Ev();
extern void _ZN10S1540C3_nt4v163Ev();
extern void _ZN10S1540C3_nt4v164Ev();
extern void _ZN10S1540C3_nt4v165Ev();
extern void _ZN10S1540C3_nt4v166Ev();
extern void _ZN10S1540C3_nt4v167Ev();
extern void _ZN10S1540C3_nt4v168Ev();
extern void _ZN10S1540C3_nt4v169Ev();
extern void _ZN10S1540C3_nt4v170Ev();
extern void _ZN10S1540C3_nt4v171Ev();
extern void _ZN10S1540C3_nt4v172Ev();
extern void _ZN10S1540C3_nt4v173Ev();
extern void _ZN10S1540C3_nt4v174Ev();
extern void _ZN10S1540C3_nt4v175Ev();
extern void _ZN10S1540C3_nt4v176Ev();
extern void _ZN10S1540C3_nt4v177Ev();
extern void _ZN10S1540C3_nt4v178Ev();
extern void _ZN10S1540C3_nt4v179Ev();
extern void _ZN10S1540C3_nt4v180Ev();
extern void _ZN10S1540C3_nt4v181Ev();
extern void _ZN10S1540C3_nt4v182Ev();
extern void _ZN10S1540C3_nt4v183Ev();
extern void _ZN10S1540C3_nt4v184Ev();
extern void _ZN10S1540C3_nt4v185Ev();
extern void _ZN10S1540C3_nt4v186Ev();
extern void _ZN10S1540C3_nt4v187Ev();
extern void _ZN10S1540C3_nt4v188Ev();
extern void _ZN10S1540C3_nt4v189Ev();
extern void _ZN10S1540C3_nt4v190Ev();
extern void _ZN10S1540C3_nt4v191Ev();
extern void _ZN10S1540C3_nt4v192Ev();
extern void _ZN10S1540C3_nt4v193Ev();
extern void _ZN10S1540C3_nt4v194Ev();
extern void _ZN10S1540C3_nt4v195Ev();
extern void _ZN10S1540C3_nt4v196Ev();
extern void _ZN10S1540C3_nt4v197Ev();
extern void _ZN10S1540C3_nt4v198Ev();
extern void _ZN10S1540C3_nt4v199Ev();
extern void _ZN10S1540C3_nt4v200Ev();
extern void _ZN10S1540C3_nt4v201Ev();
extern void _ZN10S1540C3_nt4v202Ev();
extern void _ZN10S1540C3_nt4v203Ev();
extern void _ZN10S1540C3_nt4v204Ev();
extern void _ZN10S1540C3_nt4v205Ev();
extern void _ZN10S1540C3_nt4v206Ev();
extern void _ZN10S1540C3_nt4v207Ev();
extern void _ZN10S1540C3_nt4v208Ev();
extern void _ZN10S1540C3_nt4v209Ev();
extern void _ZN10S1540C3_nt4v210Ev();
extern void _ZN10S1540C3_nt4v211Ev();
extern void _ZN10S1540C3_nt4v212Ev();
extern void _ZN10S1540C3_nt4v213Ev();
extern void _ZN10S1540C2_nt4v214Ev();
extern void _ZN10S1540C2_nt4v215Ev();
extern void _ZN10S1540C2_nt4v216Ev();
extern void _ZN10S1540C2_nt4v217Ev();
extern void _ZN10S1540C2_nt4v218Ev();
extern void _ZN10S1540C2_nt4v219Ev();
extern void _ZN10S1540C2_nt4v220Ev();
extern void _ZN10S1540C2_nt4v221Ev();
extern void _ZN10S1540C2_nt4v222Ev();
extern void _ZN10S1540C2_nt4v223Ev();
extern void _ZN10S1540C2_nt4v224Ev();
extern void _ZN10S1540C2_nt4v225Ev();
extern void _ZN10S1540C2_nt4v226Ev();
extern void _ZN10S1540C2_nt4v227Ev();
extern void _ZN10S1540C2_nt4v228Ev();
extern void _ZN10S1540C2_nt4v229Ev();
extern void _ZN10S1540C2_nt4v230Ev();
extern void _ZN10S1540C2_nt4v231Ev();
extern void _ZN10S1540C2_nt4v232Ev();
extern void _ZN10S1540C2_nt4v233Ev();
extern void _ZN10S1540C2_nt4v234Ev();
extern void _ZN10S1540C2_nt4v235Ev();
extern void _ZN10S1540C2_nt4v236Ev();
extern void _ZN10S1540C2_nt4v237Ev();
extern void _ZN10S1540C2_nt4v238Ev();
extern void _ZN10S1540C2_nt4v239Ev();
extern void _ZN10S1540C2_nt4v240Ev();
extern void _ZN10S1540C2_nt4v241Ev();
extern void _ZN10S1540C2_nt4v242Ev();
extern void _ZN10S1540C2_nt4v243Ev();
extern void _ZN10S1540C2_nt4v244Ev();
extern void _ZN10S1540C2_nt4v245Ev();
extern void _ZN10S1540C2_nt4v246Ev();
extern void _ZN10S1540C2_nt4v247Ev();
extern void _ZN10S1540C2_nt4v248Ev();
extern void _ZN10S1540C2_nt4v249Ev();
extern void _ZN10S1540C2_nt4v250Ev();
extern void _ZN7S1540C12v1Ev();
extern void _ZN7S1540C12v2Ev();
extern void _ZN7S1540C12v3Ev();
extern void _ZN7S1540C12v4Ev();
extern void _ZN7S1540C12v5Ev();
extern void _ZN7S1540C12v6Ev();
static  VTBL_ENTRY vtc_S1540C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1540C1[0]),
  (VTBL_ENTRY)&_ZN7S1540C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1540C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1540C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v211Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v212Ev,
  (VTBL_ENTRY)&_ZN10S1540C3_nt4v213Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v214Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v215Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v216Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v217Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v218Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v219Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v220Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v221Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v222Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v223Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v224Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v225Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v226Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v227Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v228Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v229Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v230Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v231Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v232Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v233Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v234Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v235Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v236Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v237Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v238Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v239Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v240Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v241Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v242Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v243Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v244Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v245Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v246Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v247Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v248Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v249Ev,
  (VTBL_ENTRY)&_ZN10S1540C2_nt4v250Ev,
  (VTBL_ENTRY)&_ZN7S1540C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1540C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1540C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1540C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1540C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1540C12v6Ev,
};
extern VTBL_ENTRY _ZTI7S1540C1[];
extern  VTBL_ENTRY _ZTV7S1540C1[];
Class_Descriptor cd_S1540C1 = {  "S1540C1", // class name
  bases_S1540C1, 3,
  &(vtc_S1540C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(920,688), // object size
  NSPAIRA(_ZTI7S1540C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1540C1),254, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S662C5  {
  int s662c5f0;
  __tsi64 s662c5f1;
  void *s662c5f2[4];
  int s662c5f3[2];
  void *s662c5f4;
  ::S1540C5_nt s662c5f5;
  void *s662c5f6[2];
  virtual  ~S662C5(); // _ZN6S662C5D1Ev
  virtual void  v6(); // _ZN6S662C52v6Ev
  virtual void  v7(); // _ZN6S662C52v7Ev
  virtual void  v8(); // _ZN6S662C52v8Ev
  virtual void  v9(); // _ZN6S662C52v9Ev
  virtual void  v10(); // _ZN6S662C53v10Ev
  virtual void  v11(); // _ZN6S662C53v11Ev
  virtual void  v12(); // _ZN6S662C53v12Ev
  virtual void  v13(); // _ZN6S662C53v13Ev
  virtual void  v14(); // _ZN6S662C53v14Ev
  virtual void  v15(); // _ZN6S662C53v15Ev
  virtual void  v16(); // _ZN6S662C53v16Ev
  virtual void  v17(); // _ZN6S662C53v17Ev
  virtual void  v18(); // _ZN6S662C53v18Ev
  virtual void  v19(); // _ZN6S662C53v19Ev
  virtual void  v20(); // _ZN6S662C53v20Ev
  virtual void  v21(); // _ZN6S662C53v21Ev
  virtual void  v22(); // _ZN6S662C53v22Ev
  virtual void  v23(); // _ZN6S662C53v23Ev
  virtual void  v24(); // _ZN6S662C53v24Ev
  virtual void  v25(); // _ZN6S662C53v25Ev
  virtual void  v26(); // _ZN6S662C53v26Ev
  virtual void  v27(); // _ZN6S662C53v27Ev
  virtual void  v28(); // _ZN6S662C53v28Ev
  virtual void  v29(); // _ZN6S662C53v29Ev
  virtual void  v30(); // _ZN6S662C53v30Ev
  virtual void  v31(); // _ZN6S662C53v31Ev
  virtual void  v32(); // _ZN6S662C53v32Ev
  virtual void  v33(); // _ZN6S662C53v33Ev
  virtual void  v34(); // _ZN6S662C53v34Ev
  virtual void  v35(); // _ZN6S662C53v35Ev
  virtual void  v36(); // _ZN6S662C53v36Ev
  virtual void  v37(); // _ZN6S662C53v37Ev
  virtual void  v38(); // _ZN6S662C53v38Ev
  virtual void  v39(); // _ZN6S662C53v39Ev
  virtual void  v40(); // _ZN6S662C53v40Ev
  virtual void  v41(); // _ZN6S662C53v41Ev
  virtual void  v42(); // _ZN6S662C53v42Ev
  virtual void  v43(); // _ZN6S662C53v43Ev
  virtual void  v44(); // _ZN6S662C53v44Ev
  virtual void  v45(); // _ZN6S662C53v45Ev
  virtual void  v46(); // _ZN6S662C53v46Ev
  virtual void  v47(); // _ZN6S662C53v47Ev
  virtual void  v48(); // _ZN6S662C53v48Ev
  virtual void  v49(); // _ZN6S662C53v49Ev
  virtual void  v50(); // _ZN6S662C53v50Ev
  virtual void  v51(); // _ZN6S662C53v51Ev
  virtual void  v52(); // _ZN6S662C53v52Ev
  virtual void  v53(); // _ZN6S662C53v53Ev
  virtual void  v54(); // _ZN6S662C53v54Ev
  virtual void  v55(); // _ZN6S662C53v55Ev
  virtual void  v56(); // _ZN6S662C53v56Ev
  virtual void  v57(); // _ZN6S662C53v57Ev
  virtual void  v58(); // _ZN6S662C53v58Ev
  virtual void  v59(); // _ZN6S662C53v59Ev
  virtual void  v60(); // _ZN6S662C53v60Ev
  virtual void  v61(); // _ZN6S662C53v61Ev
  virtual void  v62(); // _ZN6S662C53v62Ev
  virtual void  v63(); // _ZN6S662C53v63Ev
  virtual void  v64(); // _ZN6S662C53v64Ev
  virtual void  v65(); // _ZN6S662C53v65Ev
  virtual void  v66(); // _ZN6S662C53v66Ev
  virtual void  v67(); // _ZN6S662C53v67Ev
  virtual void  v68(); // _ZN6S662C53v68Ev
  virtual void  v69(); // _ZN6S662C53v69Ev
  S662C5(); // tgen
};
//SIG(-1 S662C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S662C5 ::~S662C5(){ note_dtor("S662C5", this);}
void  S662C5 ::v6(){vfunc_called(this, "_ZN6S662C52v6Ev");}
void  S662C5 ::v7(){vfunc_called(this, "_ZN6S662C52v7Ev");}
void  S662C5 ::v8(){vfunc_called(this, "_ZN6S662C52v8Ev");}
void  S662C5 ::v9(){vfunc_called(this, "_ZN6S662C52v9Ev");}
void  S662C5 ::v10(){vfunc_called(this, "_ZN6S662C53v10Ev");}
void  S662C5 ::v11(){vfunc_called(this, "_ZN6S662C53v11Ev");}
void  S662C5 ::v12(){vfunc_called(this, "_ZN6S662C53v12Ev");}
void  S662C5 ::v13(){vfunc_called(this, "_ZN6S662C53v13Ev");}
void  S662C5 ::v14(){vfunc_called(this, "_ZN6S662C53v14Ev");}
void  S662C5 ::v15(){vfunc_called(this, "_ZN6S662C53v15Ev");}
void  S662C5 ::v16(){vfunc_called(this, "_ZN6S662C53v16Ev");}
void  S662C5 ::v17(){vfunc_called(this, "_ZN6S662C53v17Ev");}
void  S662C5 ::v18(){vfunc_called(this, "_ZN6S662C53v18Ev");}
void  S662C5 ::v19(){vfunc_called(this, "_ZN6S662C53v19Ev");}
void  S662C5 ::v20(){vfunc_called(this, "_ZN6S662C53v20Ev");}
void  S662C5 ::v21(){vfunc_called(this, "_ZN6S662C53v21Ev");}
void  S662C5 ::v22(){vfunc_called(this, "_ZN6S662C53v22Ev");}
void  S662C5 ::v23(){vfunc_called(this, "_ZN6S662C53v23Ev");}
void  S662C5 ::v24(){vfunc_called(this, "_ZN6S662C53v24Ev");}
void  S662C5 ::v25(){vfunc_called(this, "_ZN6S662C53v25Ev");}
void  S662C5 ::v26(){vfunc_called(this, "_ZN6S662C53v26Ev");}
void  S662C5 ::v27(){vfunc_called(this, "_ZN6S662C53v27Ev");}
void  S662C5 ::v28(){vfunc_called(this, "_ZN6S662C53v28Ev");}
void  S662C5 ::v29(){vfunc_called(this, "_ZN6S662C53v29Ev");}
void  S662C5 ::v30(){vfunc_called(this, "_ZN6S662C53v30Ev");}
void  S662C5 ::v31(){vfunc_called(this, "_ZN6S662C53v31Ev");}
void  S662C5 ::v32(){vfunc_called(this, "_ZN6S662C53v32Ev");}
void  S662C5 ::v33(){vfunc_called(this, "_ZN6S662C53v33Ev");}
void  S662C5 ::v34(){vfunc_called(this, "_ZN6S662C53v34Ev");}
void  S662C5 ::v35(){vfunc_called(this, "_ZN6S662C53v35Ev");}
void  S662C5 ::v36(){vfunc_called(this, "_ZN6S662C53v36Ev");}
void  S662C5 ::v37(){vfunc_called(this, "_ZN6S662C53v37Ev");}
void  S662C5 ::v38(){vfunc_called(this, "_ZN6S662C53v38Ev");}
void  S662C5 ::v39(){vfunc_called(this, "_ZN6S662C53v39Ev");}
void  S662C5 ::v40(){vfunc_called(this, "_ZN6S662C53v40Ev");}
void  S662C5 ::v41(){vfunc_called(this, "_ZN6S662C53v41Ev");}
void  S662C5 ::v42(){vfunc_called(this, "_ZN6S662C53v42Ev");}
void  S662C5 ::v43(){vfunc_called(this, "_ZN6S662C53v43Ev");}
void  S662C5 ::v44(){vfunc_called(this, "_ZN6S662C53v44Ev");}
void  S662C5 ::v45(){vfunc_called(this, "_ZN6S662C53v45Ev");}
void  S662C5 ::v46(){vfunc_called(this, "_ZN6S662C53v46Ev");}
void  S662C5 ::v47(){vfunc_called(this, "_ZN6S662C53v47Ev");}
void  S662C5 ::v48(){vfunc_called(this, "_ZN6S662C53v48Ev");}
void  S662C5 ::v49(){vfunc_called(this, "_ZN6S662C53v49Ev");}
void  S662C5 ::v50(){vfunc_called(this, "_ZN6S662C53v50Ev");}
void  S662C5 ::v51(){vfunc_called(this, "_ZN6S662C53v51Ev");}
void  S662C5 ::v52(){vfunc_called(this, "_ZN6S662C53v52Ev");}
void  S662C5 ::v53(){vfunc_called(this, "_ZN6S662C53v53Ev");}
void  S662C5 ::v54(){vfunc_called(this, "_ZN6S662C53v54Ev");}
void  S662C5 ::v55(){vfunc_called(this, "_ZN6S662C53v55Ev");}
void  S662C5 ::v56(){vfunc_called(this, "_ZN6S662C53v56Ev");}
void  S662C5 ::v57(){vfunc_called(this, "_ZN6S662C53v57Ev");}
void  S662C5 ::v58(){vfunc_called(this, "_ZN6S662C53v58Ev");}
void  S662C5 ::v59(){vfunc_called(this, "_ZN6S662C53v59Ev");}
void  S662C5 ::v60(){vfunc_called(this, "_ZN6S662C53v60Ev");}
void  S662C5 ::v61(){vfunc_called(this, "_ZN6S662C53v61Ev");}
void  S662C5 ::v62(){vfunc_called(this, "_ZN6S662C53v62Ev");}
void  S662C5 ::v63(){vfunc_called(this, "_ZN6S662C53v63Ev");}
void  S662C5 ::v64(){vfunc_called(this, "_ZN6S662C53v64Ev");}
void  S662C5 ::v65(){vfunc_called(this, "_ZN6S662C53v65Ev");}
void  S662C5 ::v66(){vfunc_called(this, "_ZN6S662C53v66Ev");}
void  S662C5 ::v67(){vfunc_called(this, "_ZN6S662C53v67Ev");}
void  S662C5 ::v68(){vfunc_called(this, "_ZN6S662C53v68Ev");}
void  S662C5 ::v69(){vfunc_called(this, "_ZN6S662C53v69Ev");}
S662C5 ::S662C5(){ note_ctor("S662C5", this);} // tgen

static void Test_S662C5()
{
  extern Class_Descriptor cd_S662C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S662C5, buf);
    S662C5 *dp, &lv = *(dp=new (buf) S662C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S662C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S662C5)");
    check_field_offset(lv, s662c5f0, ABISELECT(8,4), "S662C5.s662c5f0");
    check_field_offset(lv, s662c5f1, ABISELECT(16,8), "S662C5.s662c5f1");
    check_field_offset(lv, s662c5f2, ABISELECT(24,16), "S662C5.s662c5f2");
    check_field_offset(lv, s662c5f3, ABISELECT(56,32), "S662C5.s662c5f3");
    check_field_offset(lv, s662c5f4, ABISELECT(64,40), "S662C5.s662c5f4");
    check_field_offset(lv, s662c5f5, ABISELECT(72,44), "S662C5.s662c5f5");
    check_field_offset(lv, s662c5f6, ABISELECT(80,52), "S662C5.s662c5f6");
    test_class_info(&lv, &cd_S662C5);
    dp->~S662C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS662C5(Test_S662C5, "S662C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S662C5C1Ev();
extern void _ZN6S662C5D1Ev();
Name_Map name_map_S662C5[] = {
  NSPAIR(_ZN6S662C5C1Ev),
  NSPAIR(_ZN6S662C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S662C5[];
extern void _ZN6S662C5D1Ev();
extern void _ZN6S662C5D0Ev();
extern void _ZN6S662C52v6Ev();
extern void _ZN6S662C52v7Ev();
extern void _ZN6S662C52v8Ev();
extern void _ZN6S662C52v9Ev();
extern void _ZN6S662C53v10Ev();
extern void _ZN6S662C53v11Ev();
extern void _ZN6S662C53v12Ev();
extern void _ZN6S662C53v13Ev();
extern void _ZN6S662C53v14Ev();
extern void _ZN6S662C53v15Ev();
extern void _ZN6S662C53v16Ev();
extern void _ZN6S662C53v17Ev();
extern void _ZN6S662C53v18Ev();
extern void _ZN6S662C53v19Ev();
extern void _ZN6S662C53v20Ev();
extern void _ZN6S662C53v21Ev();
extern void _ZN6S662C53v22Ev();
extern void _ZN6S662C53v23Ev();
extern void _ZN6S662C53v24Ev();
extern void _ZN6S662C53v25Ev();
extern void _ZN6S662C53v26Ev();
extern void _ZN6S662C53v27Ev();
extern void _ZN6S662C53v28Ev();
extern void _ZN6S662C53v29Ev();
extern void _ZN6S662C53v30Ev();
extern void _ZN6S662C53v31Ev();
extern void _ZN6S662C53v32Ev();
extern void _ZN6S662C53v33Ev();
extern void _ZN6S662C53v34Ev();
extern void _ZN6S662C53v35Ev();
extern void _ZN6S662C53v36Ev();
extern void _ZN6S662C53v37Ev();
extern void _ZN6S662C53v38Ev();
extern void _ZN6S662C53v39Ev();
extern void _ZN6S662C53v40Ev();
extern void _ZN6S662C53v41Ev();
extern void _ZN6S662C53v42Ev();
extern void _ZN6S662C53v43Ev();
extern void _ZN6S662C53v44Ev();
extern void _ZN6S662C53v45Ev();
extern void _ZN6S662C53v46Ev();
extern void _ZN6S662C53v47Ev();
extern void _ZN6S662C53v48Ev();
extern void _ZN6S662C53v49Ev();
extern void _ZN6S662C53v50Ev();
extern void _ZN6S662C53v51Ev();
extern void _ZN6S662C53v52Ev();
extern void _ZN6S662C53v53Ev();
extern void _ZN6S662C53v54Ev();
extern void _ZN6S662C53v55Ev();
extern void _ZN6S662C53v56Ev();
extern void _ZN6S662C53v57Ev();
extern void _ZN6S662C53v58Ev();
extern void _ZN6S662C53v59Ev();
extern void _ZN6S662C53v60Ev();
extern void _ZN6S662C53v61Ev();
extern void _ZN6S662C53v62Ev();
extern void _ZN6S662C53v63Ev();
extern void _ZN6S662C53v64Ev();
extern void _ZN6S662C53v65Ev();
extern void _ZN6S662C53v66Ev();
extern void _ZN6S662C53v67Ev();
extern void _ZN6S662C53v68Ev();
extern void _ZN6S662C53v69Ev();
static  VTBL_ENTRY vtc_S662C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S662C5[0]),
  (VTBL_ENTRY)&_ZN6S662C5D1Ev,
  (VTBL_ENTRY)&_ZN6S662C5D0Ev,
  (VTBL_ENTRY)&_ZN6S662C52v6Ev,
  (VTBL_ENTRY)&_ZN6S662C52v7Ev,
  (VTBL_ENTRY)&_ZN6S662C52v8Ev,
  (VTBL_ENTRY)&_ZN6S662C52v9Ev,
  (VTBL_ENTRY)&_ZN6S662C53v10Ev,
  (VTBL_ENTRY)&_ZN6S662C53v11Ev,
  (VTBL_ENTRY)&_ZN6S662C53v12Ev,
  (VTBL_ENTRY)&_ZN6S662C53v13Ev,
  (VTBL_ENTRY)&_ZN6S662C53v14Ev,
  (VTBL_ENTRY)&_ZN6S662C53v15Ev,
  (VTBL_ENTRY)&_ZN6S662C53v16Ev,
  (VTBL_ENTRY)&_ZN6S662C53v17Ev,
  (VTBL_ENTRY)&_ZN6S662C53v18Ev,
  (VTBL_ENTRY)&_ZN6S662C53v19Ev,
  (VTBL_ENTRY)&_ZN6S662C53v20Ev,
  (VTBL_ENTRY)&_ZN6S662C53v21Ev,
  (VTBL_ENTRY)&_ZN6S662C53v22Ev,
  (VTBL_ENTRY)&_ZN6S662C53v23Ev,
  (VTBL_ENTRY)&_ZN6S662C53v24Ev,
  (VTBL_ENTRY)&_ZN6S662C53v25Ev,
  (VTBL_ENTRY)&_ZN6S662C53v26Ev,
  (VTBL_ENTRY)&_ZN6S662C53v27Ev,
  (VTBL_ENTRY)&_ZN6S662C53v28Ev,
  (VTBL_ENTRY)&_ZN6S662C53v29Ev,
  (VTBL_ENTRY)&_ZN6S662C53v30Ev,
  (VTBL_ENTRY)&_ZN6S662C53v31Ev,
  (VTBL_ENTRY)&_ZN6S662C53v32Ev,
  (VTBL_ENTRY)&_ZN6S662C53v33Ev,
  (VTBL_ENTRY)&_ZN6S662C53v34Ev,
  (VTBL_ENTRY)&_ZN6S662C53v35Ev,
  (VTBL_ENTRY)&_ZN6S662C53v36Ev,
  (VTBL_ENTRY)&_ZN6S662C53v37Ev,
  (VTBL_ENTRY)&_ZN6S662C53v38Ev,
  (VTBL_ENTRY)&_ZN6S662C53v39Ev,
  (VTBL_ENTRY)&_ZN6S662C53v40Ev,
  (VTBL_ENTRY)&_ZN6S662C53v41Ev,
  (VTBL_ENTRY)&_ZN6S662C53v42Ev,
  (VTBL_ENTRY)&_ZN6S662C53v43Ev,
  (VTBL_ENTRY)&_ZN6S662C53v44Ev,
  (VTBL_ENTRY)&_ZN6S662C53v45Ev,
  (VTBL_ENTRY)&_ZN6S662C53v46Ev,
  (VTBL_ENTRY)&_ZN6S662C53v47Ev,
  (VTBL_ENTRY)&_ZN6S662C53v48Ev,
  (VTBL_ENTRY)&_ZN6S662C53v49Ev,
  (VTBL_ENTRY)&_ZN6S662C53v50Ev,
  (VTBL_ENTRY)&_ZN6S662C53v51Ev,
  (VTBL_ENTRY)&_ZN6S662C53v52Ev,
  (VTBL_ENTRY)&_ZN6S662C53v53Ev,
  (VTBL_ENTRY)&_ZN6S662C53v54Ev,
  (VTBL_ENTRY)&_ZN6S662C53v55Ev,
  (VTBL_ENTRY)&_ZN6S662C53v56Ev,
  (VTBL_ENTRY)&_ZN6S662C53v57Ev,
  (VTBL_ENTRY)&_ZN6S662C53v58Ev,
  (VTBL_ENTRY)&_ZN6S662C53v59Ev,
  (VTBL_ENTRY)&_ZN6S662C53v60Ev,
  (VTBL_ENTRY)&_ZN6S662C53v61Ev,
  (VTBL_ENTRY)&_ZN6S662C53v62Ev,
  (VTBL_ENTRY)&_ZN6S662C53v63Ev,
  (VTBL_ENTRY)&_ZN6S662C53v64Ev,
  (VTBL_ENTRY)&_ZN6S662C53v65Ev,
  (VTBL_ENTRY)&_ZN6S662C53v66Ev,
  (VTBL_ENTRY)&_ZN6S662C53v67Ev,
  (VTBL_ENTRY)&_ZN6S662C53v68Ev,
  (VTBL_ENTRY)&_ZN6S662C53v69Ev,
};
extern VTBL_ENTRY _ZTI6S662C5[];
extern  VTBL_ENTRY _ZTV6S662C5[];
Class_Descriptor cd_S662C5 = {  "S662C5", // class name
  0,0,//no base classes
  &(vtc_S662C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S662C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S662C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S662C4_nt  : S662C5 {
  void *s662c4f0;
  ::S1540C5_nt s662c4f1;
  virtual  ~S662C4_nt(); // _ZN9S662C4_ntD1Ev
  virtual void  v70(); // _ZN9S662C4_nt3v70Ev
  virtual void  v71(); // _ZN9S662C4_nt3v71Ev
  virtual void  v72(); // _ZN9S662C4_nt3v72Ev
  virtual void  v73(); // _ZN9S662C4_nt3v73Ev
  virtual void  v74(); // _ZN9S662C4_nt3v74Ev
  S662C4_nt(); // tgen
};
//SIG(-1 S662C4_nt) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 Fp FC3}


 S662C4_nt ::~S662C4_nt(){ note_dtor("S662C4_nt", this);}
void  S662C4_nt ::v70(){vfunc_called(this, "_ZN9S662C4_nt3v70Ev");}
void  S662C4_nt ::v71(){vfunc_called(this, "_ZN9S662C4_nt3v71Ev");}
void  S662C4_nt ::v72(){vfunc_called(this, "_ZN9S662C4_nt3v72Ev");}
void  S662C4_nt ::v73(){vfunc_called(this, "_ZN9S662C4_nt3v73Ev");}
void  S662C4_nt ::v74(){vfunc_called(this, "_ZN9S662C4_nt3v74Ev");}
S662C4_nt ::S662C4_nt(){ note_ctor("S662C4_nt", this);} // tgen

//skip512 S662C4_nt

#else // __cplusplus

extern void _ZN9S662C4_ntC1Ev();
extern void _ZN9S662C4_ntD1Ev();
Name_Map name_map_S662C4_nt[] = {
  NSPAIR(_ZN9S662C4_ntC1Ev),
  NSPAIR(_ZN9S662C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S662C5;
extern VTBL_ENTRY _ZTI6S662C5[];
extern  VTBL_ENTRY _ZTV6S662C5[];
static Base_Class bases_S662C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S662C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S662C4_nt[];
extern void _ZN9S662C4_ntD1Ev();
extern void _ZN9S662C4_ntD0Ev();
extern void _ZN6S662C52v6Ev();
extern void _ZN6S662C52v7Ev();
extern void _ZN6S662C52v8Ev();
extern void _ZN6S662C52v9Ev();
extern void _ZN6S662C53v10Ev();
extern void _ZN6S662C53v11Ev();
extern void _ZN6S662C53v12Ev();
extern void _ZN6S662C53v13Ev();
extern void _ZN6S662C53v14Ev();
extern void _ZN6S662C53v15Ev();
extern void _ZN6S662C53v16Ev();
extern void _ZN6S662C53v17Ev();
extern void _ZN6S662C53v18Ev();
extern void _ZN6S662C53v19Ev();
extern void _ZN6S662C53v20Ev();
extern void _ZN6S662C53v21Ev();
extern void _ZN6S662C53v22Ev();
extern void _ZN6S662C53v23Ev();
extern void _ZN6S662C53v24Ev();
extern void _ZN6S662C53v25Ev();
extern void _ZN6S662C53v26Ev();
extern void _ZN6S662C53v27Ev();
extern void _ZN6S662C53v28Ev();
extern void _ZN6S662C53v29Ev();
extern void _ZN6S662C53v30Ev();
extern void _ZN6S662C53v31Ev();
extern void _ZN6S662C53v32Ev();
extern void _ZN6S662C53v33Ev();
extern void _ZN6S662C53v34Ev();
extern void _ZN6S662C53v35Ev();
extern void _ZN6S662C53v36Ev();
extern void _ZN6S662C53v37Ev();
extern void _ZN6S662C53v38Ev();
extern void _ZN6S662C53v39Ev();
extern void _ZN6S662C53v40Ev();
extern void _ZN6S662C53v41Ev();
extern void _ZN6S662C53v42Ev();
extern void _ZN6S662C53v43Ev();
extern void _ZN6S662C53v44Ev();
extern void _ZN6S662C53v45Ev();
extern void _ZN6S662C53v46Ev();
extern void _ZN6S662C53v47Ev();
extern void _ZN6S662C53v48Ev();
extern void _ZN6S662C53v49Ev();
extern void _ZN6S662C53v50Ev();
extern void _ZN6S662C53v51Ev();
extern void _ZN6S662C53v52Ev();
extern void _ZN6S662C53v53Ev();
extern void _ZN6S662C53v54Ev();
extern void _ZN6S662C53v55Ev();
extern void _ZN6S662C53v56Ev();
extern void _ZN6S662C53v57Ev();
extern void _ZN6S662C53v58Ev();
extern void _ZN6S662C53v59Ev();
extern void _ZN6S662C53v60Ev();
extern void _ZN6S662C53v61Ev();
extern void _ZN6S662C53v62Ev();
extern void _ZN6S662C53v63Ev();
extern void _ZN6S662C53v64Ev();
extern void _ZN6S662C53v65Ev();
extern void _ZN6S662C53v66Ev();
extern void _ZN6S662C53v67Ev();
extern void _ZN6S662C53v68Ev();
extern void _ZN6S662C53v69Ev();
extern void _ZN9S662C4_nt3v70Ev();
extern void _ZN9S662C4_nt3v71Ev();
extern void _ZN9S662C4_nt3v72Ev();
extern void _ZN9S662C4_nt3v73Ev();
extern void _ZN9S662C4_nt3v74Ev();
static  VTBL_ENTRY vtc_S662C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S662C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S662C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S662C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S662C52v6Ev,
  (VTBL_ENTRY)&_ZN6S662C52v7Ev,
  (VTBL_ENTRY)&_ZN6S662C52v8Ev,
  (VTBL_ENTRY)&_ZN6S662C52v9Ev,
  (VTBL_ENTRY)&_ZN6S662C53v10Ev,
  (VTBL_ENTRY)&_ZN6S662C53v11Ev,
  (VTBL_ENTRY)&_ZN6S662C53v12Ev,
  (VTBL_ENTRY)&_ZN6S662C53v13Ev,
  (VTBL_ENTRY)&_ZN6S662C53v14Ev,
  (VTBL_ENTRY)&_ZN6S662C53v15Ev,
  (VTBL_ENTRY)&_ZN6S662C53v16Ev,
  (VTBL_ENTRY)&_ZN6S662C53v17Ev,
  (VTBL_ENTRY)&_ZN6S662C53v18Ev,
  (VTBL_ENTRY)&_ZN6S662C53v19Ev,
  (VTBL_ENTRY)&_ZN6S662C53v20Ev,
  (VTBL_ENTRY)&_ZN6S662C53v21Ev,
  (VTBL_ENTRY)&_ZN6S662C53v22Ev,
  (VTBL_ENTRY)&_ZN6S662C53v23Ev,
  (VTBL_ENTRY)&_ZN6S662C53v24Ev,
  (VTBL_ENTRY)&_ZN6S662C53v25Ev,
  (VTBL_ENTRY)&_ZN6S662C53v26Ev,
  (VTBL_ENTRY)&_ZN6S662C53v27Ev,
  (VTBL_ENTRY)&_ZN6S662C53v28Ev,
  (VTBL_ENTRY)&_ZN6S662C53v29Ev,
  (VTBL_ENTRY)&_ZN6S662C53v30Ev,
  (VTBL_ENTRY)&_ZN6S662C53v31Ev,
  (VTBL_ENTRY)&_ZN6S662C53v32Ev,
  (VTBL_ENTRY)&_ZN6S662C53v33Ev,
  (VTBL_ENTRY)&_ZN6S662C53v34Ev,
  (VTBL_ENTRY)&_ZN6S662C53v35Ev,
  (VTBL_ENTRY)&_ZN6S662C53v36Ev,
  (VTBL_ENTRY)&_ZN6S662C53v37Ev,
  (VTBL_ENTRY)&_ZN6S662C53v38Ev,
  (VTBL_ENTRY)&_ZN6S662C53v39Ev,
  (VTBL_ENTRY)&_ZN6S662C53v40Ev,
  (VTBL_ENTRY)&_ZN6S662C53v41Ev,
  (VTBL_ENTRY)&_ZN6S662C53v42Ev,
  (VTBL_ENTRY)&_ZN6S662C53v43Ev,
  (VTBL_ENTRY)&_ZN6S662C53v44Ev,
  (VTBL_ENTRY)&_ZN6S662C53v45Ev,
  (VTBL_ENTRY)&_ZN6S662C53v46Ev,
  (VTBL_ENTRY)&_ZN6S662C53v47Ev,
  (VTBL_ENTRY)&_ZN6S662C53v48Ev,
  (VTBL_ENTRY)&_ZN6S662C53v49Ev,
  (VTBL_ENTRY)&_ZN6S662C53v50Ev,
  (VTBL_ENTRY)&_ZN6S662C53v51Ev,
  (VTBL_ENTRY)&_ZN6S662C53v52Ev,
  (VTBL_ENTRY)&_ZN6S662C53v53Ev,
  (VTBL_ENTRY)&_ZN6S662C53v54Ev,
  (VTBL_ENTRY)&_ZN6S662C53v55Ev,
  (VTBL_ENTRY)&_ZN6S662C53v56Ev,
  (VTBL_ENTRY)&_ZN6S662C53v57Ev,
  (VTBL_ENTRY)&_ZN6S662C53v58Ev,
  (VTBL_ENTRY)&_ZN6S662C53v59Ev,
  (VTBL_ENTRY)&_ZN6S662C53v60Ev,
  (VTBL_ENTRY)&_ZN6S662C53v61Ev,
  (VTBL_ENTRY)&_ZN6S662C53v62Ev,
  (VTBL_ENTRY)&_ZN6S662C53v63Ev,
  (VTBL_ENTRY)&_ZN6S662C53v64Ev,
  (VTBL_ENTRY)&_ZN6S662C53v65Ev,
  (VTBL_ENTRY)&_ZN6S662C53v66Ev,
  (VTBL_ENTRY)&_ZN6S662C53v67Ev,
  (VTBL_ENTRY)&_ZN6S662C53v68Ev,
  (VTBL_ENTRY)&_ZN6S662C53v69Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v74Ev,
};
extern VTBL_ENTRY _ZTI9S662C4_nt[];
VTBL_ENTRY *P__ZTI9S662C4_nt = _ZTI9S662C4_nt; 
extern  VTBL_ENTRY _ZTV9S662C4_nt[];
Class_Descriptor cd_S662C4_nt = {  "S662C4_nt", // class name
  bases_S662C4_nt, 1,
  &(vtc_S662C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI9S662C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S662C4_nt),73, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S662C3_nt  : S662C4_nt {
  void *s662c3f0[2];
  unsigned int s662c3f1:1;
  unsigned int s662c3f2:1;
  unsigned int s662c3f3:1;
  unsigned int s662c3f4:1;
  char s662c3f5;
  virtual  ~S662C3_nt(); // _ZN9S662C3_ntD1Ev
  virtual void  v75(); // _ZN9S662C3_nt3v75Ev
  virtual void  v76(); // _ZN9S662C3_nt3v76Ev
  virtual void  v77(); // _ZN9S662C3_nt3v77Ev
  virtual void  v78(); // _ZN9S662C3_nt3v78Ev
  virtual void  v79(); // _ZN9S662C3_nt3v79Ev
  virtual void  v80(); // _ZN9S662C3_nt3v80Ev
  virtual void  v81(); // _ZN9S662C3_nt3v81Ev
  virtual void  v82(); // _ZN9S662C3_nt3v82Ev
  virtual void  v83(); // _ZN9S662C3_nt3v83Ev
  virtual void  v84(); // _ZN9S662C3_nt3v84Ev
  virtual void  v85(); // _ZN9S662C3_nt3v85Ev
  virtual void  v86(); // _ZN9S662C3_nt3v86Ev
  virtual void  v87(); // _ZN9S662C3_nt3v87Ev
  virtual void  v88(); // _ZN9S662C3_nt3v88Ev
  virtual void  v89(); // _ZN9S662C3_nt3v89Ev
  virtual void  v90(); // _ZN9S662C3_nt3v90Ev
  virtual void  v91(); // _ZN9S662C3_nt3v91Ev
  virtual void  v92(); // _ZN9S662C3_nt3v92Ev
  virtual void  v93(); // _ZN9S662C3_nt3v93Ev
  virtual void  v94(); // _ZN9S662C3_nt3v94Ev
  virtual void  v95(); // _ZN9S662C3_nt3v95Ev
  virtual void  v96(); // _ZN9S662C3_nt3v96Ev
  S662C3_nt(); // tgen
};
//SIG(-1 S662C3_nt) C1{ BC2{ BC3{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v87 v88 v89 v90 v91 Fp FC4} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc}


 S662C3_nt ::~S662C3_nt(){ note_dtor("S662C3_nt", this);}
void  S662C3_nt ::v75(){vfunc_called(this, "_ZN9S662C3_nt3v75Ev");}
void  S662C3_nt ::v76(){vfunc_called(this, "_ZN9S662C3_nt3v76Ev");}
void  S662C3_nt ::v77(){vfunc_called(this, "_ZN9S662C3_nt3v77Ev");}
void  S662C3_nt ::v78(){vfunc_called(this, "_ZN9S662C3_nt3v78Ev");}
void  S662C3_nt ::v79(){vfunc_called(this, "_ZN9S662C3_nt3v79Ev");}
void  S662C3_nt ::v80(){vfunc_called(this, "_ZN9S662C3_nt3v80Ev");}
void  S662C3_nt ::v81(){vfunc_called(this, "_ZN9S662C3_nt3v81Ev");}
void  S662C3_nt ::v82(){vfunc_called(this, "_ZN9S662C3_nt3v82Ev");}
void  S662C3_nt ::v83(){vfunc_called(this, "_ZN9S662C3_nt3v83Ev");}
void  S662C3_nt ::v84(){vfunc_called(this, "_ZN9S662C3_nt3v84Ev");}
void  S662C3_nt ::v85(){vfunc_called(this, "_ZN9S662C3_nt3v85Ev");}
void  S662C3_nt ::v86(){vfunc_called(this, "_ZN9S662C3_nt3v86Ev");}
void  S662C3_nt ::v87(){vfunc_called(this, "_ZN9S662C3_nt3v87Ev");}
void  S662C3_nt ::v88(){vfunc_called(this, "_ZN9S662C3_nt3v88Ev");}
void  S662C3_nt ::v89(){vfunc_called(this, "_ZN9S662C3_nt3v89Ev");}
void  S662C3_nt ::v90(){vfunc_called(this, "_ZN9S662C3_nt3v90Ev");}
void  S662C3_nt ::v91(){vfunc_called(this, "_ZN9S662C3_nt3v91Ev");}
void  S662C3_nt ::v92(){vfunc_called(this, "_ZN9S662C3_nt3v92Ev");}
void  S662C3_nt ::v93(){vfunc_called(this, "_ZN9S662C3_nt3v93Ev");}
void  S662C3_nt ::v94(){vfunc_called(this, "_ZN9S662C3_nt3v94Ev");}
void  S662C3_nt ::v95(){vfunc_called(this, "_ZN9S662C3_nt3v95Ev");}
void  S662C3_nt ::v96(){vfunc_called(this, "_ZN9S662C3_nt3v96Ev");}
S662C3_nt ::S662C3_nt(){ note_ctor("S662C3_nt", this);} // tgen

//skip512 S662C3_nt

#else // __cplusplus

extern void _ZN9S662C3_ntC1Ev();
extern void _ZN9S662C3_ntD1Ev();
Name_Map name_map_S662C3_nt[] = {
  NSPAIR(_ZN9S662C3_ntC1Ev),
  NSPAIR(_ZN9S662C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S662C5;
extern VTBL_ENTRY _ZTI6S662C5[];
extern  VTBL_ENTRY _ZTV6S662C5[];
extern Class_Descriptor cd_S662C4_nt;
extern VTBL_ENTRY _ZTI9S662C4_nt[];
extern  VTBL_ENTRY _ZTV9S662C4_nt[];
static Base_Class bases_S662C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S662C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S662C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S662C3_nt[];
extern void _ZN9S662C3_ntD1Ev();
extern void _ZN9S662C3_ntD0Ev();
extern void _ZN6S662C52v6Ev();
extern void _ZN6S662C52v7Ev();
extern void _ZN6S662C52v8Ev();
extern void _ZN6S662C52v9Ev();
extern void _ZN6S662C53v10Ev();
extern void _ZN6S662C53v11Ev();
extern void _ZN6S662C53v12Ev();
extern void _ZN6S662C53v13Ev();
extern void _ZN6S662C53v14Ev();
extern void _ZN6S662C53v15Ev();
extern void _ZN6S662C53v16Ev();
extern void _ZN6S662C53v17Ev();
extern void _ZN6S662C53v18Ev();
extern void _ZN6S662C53v19Ev();
extern void _ZN6S662C53v20Ev();
extern void _ZN6S662C53v21Ev();
extern void _ZN6S662C53v22Ev();
extern void _ZN6S662C53v23Ev();
extern void _ZN6S662C53v24Ev();
extern void _ZN6S662C53v25Ev();
extern void _ZN6S662C53v26Ev();
extern void _ZN6S662C53v27Ev();
extern void _ZN6S662C53v28Ev();
extern void _ZN6S662C53v29Ev();
extern void _ZN6S662C53v30Ev();
extern void _ZN6S662C53v31Ev();
extern void _ZN6S662C53v32Ev();
extern void _ZN6S662C53v33Ev();
extern void _ZN6S662C53v34Ev();
extern void _ZN6S662C53v35Ev();
extern void _ZN6S662C53v36Ev();
extern void _ZN6S662C53v37Ev();
extern void _ZN6S662C53v38Ev();
extern void _ZN6S662C53v39Ev();
extern void _ZN6S662C53v40Ev();
extern void _ZN6S662C53v41Ev();
extern void _ZN6S662C53v42Ev();
extern void _ZN6S662C53v43Ev();
extern void _ZN6S662C53v44Ev();
extern void _ZN6S662C53v45Ev();
extern void _ZN6S662C53v46Ev();
extern void _ZN6S662C53v47Ev();
extern void _ZN6S662C53v48Ev();
extern void _ZN6S662C53v49Ev();
extern void _ZN6S662C53v50Ev();
extern void _ZN6S662C53v51Ev();
extern void _ZN6S662C53v52Ev();
extern void _ZN6S662C53v53Ev();
extern void _ZN6S662C53v54Ev();
extern void _ZN6S662C53v55Ev();
extern void _ZN6S662C53v56Ev();
extern void _ZN6S662C53v57Ev();
extern void _ZN6S662C53v58Ev();
extern void _ZN6S662C53v59Ev();
extern void _ZN6S662C53v60Ev();
extern void _ZN6S662C53v61Ev();
extern void _ZN6S662C53v62Ev();
extern void _ZN6S662C53v63Ev();
extern void _ZN6S662C53v64Ev();
extern void _ZN6S662C53v65Ev();
extern void _ZN6S662C53v66Ev();
extern void _ZN6S662C53v67Ev();
extern void _ZN6S662C53v68Ev();
extern void _ZN6S662C53v69Ev();
extern void _ZN9S662C4_nt3v70Ev();
extern void _ZN9S662C4_nt3v71Ev();
extern void _ZN9S662C4_nt3v72Ev();
extern void _ZN9S662C4_nt3v73Ev();
extern void _ZN9S662C4_nt3v74Ev();
extern void _ZN9S662C3_nt3v75Ev();
extern void _ZN9S662C3_nt3v76Ev();
extern void _ZN9S662C3_nt3v77Ev();
extern void _ZN9S662C3_nt3v78Ev();
extern void _ZN9S662C3_nt3v79Ev();
extern void _ZN9S662C3_nt3v80Ev();
extern void _ZN9S662C3_nt3v81Ev();
extern void _ZN9S662C3_nt3v82Ev();
extern void _ZN9S662C3_nt3v83Ev();
extern void _ZN9S662C3_nt3v84Ev();
extern void _ZN9S662C3_nt3v85Ev();
extern void _ZN9S662C3_nt3v86Ev();
extern void _ZN9S662C3_nt3v87Ev();
extern void _ZN9S662C3_nt3v88Ev();
extern void _ZN9S662C3_nt3v89Ev();
extern void _ZN9S662C3_nt3v90Ev();
extern void _ZN9S662C3_nt3v91Ev();
extern void _ZN9S662C3_nt3v92Ev();
extern void _ZN9S662C3_nt3v93Ev();
extern void _ZN9S662C3_nt3v94Ev();
extern void _ZN9S662C3_nt3v95Ev();
extern void _ZN9S662C3_nt3v96Ev();
static  VTBL_ENTRY vtc_S662C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S662C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S662C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S662C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S662C52v6Ev,
  (VTBL_ENTRY)&_ZN6S662C52v7Ev,
  (VTBL_ENTRY)&_ZN6S662C52v8Ev,
  (VTBL_ENTRY)&_ZN6S662C52v9Ev,
  (VTBL_ENTRY)&_ZN6S662C53v10Ev,
  (VTBL_ENTRY)&_ZN6S662C53v11Ev,
  (VTBL_ENTRY)&_ZN6S662C53v12Ev,
  (VTBL_ENTRY)&_ZN6S662C53v13Ev,
  (VTBL_ENTRY)&_ZN6S662C53v14Ev,
  (VTBL_ENTRY)&_ZN6S662C53v15Ev,
  (VTBL_ENTRY)&_ZN6S662C53v16Ev,
  (VTBL_ENTRY)&_ZN6S662C53v17Ev,
  (VTBL_ENTRY)&_ZN6S662C53v18Ev,
  (VTBL_ENTRY)&_ZN6S662C53v19Ev,
  (VTBL_ENTRY)&_ZN6S662C53v20Ev,
  (VTBL_ENTRY)&_ZN6S662C53v21Ev,
  (VTBL_ENTRY)&_ZN6S662C53v22Ev,
  (VTBL_ENTRY)&_ZN6S662C53v23Ev,
  (VTBL_ENTRY)&_ZN6S662C53v24Ev,
  (VTBL_ENTRY)&_ZN6S662C53v25Ev,
  (VTBL_ENTRY)&_ZN6S662C53v26Ev,
  (VTBL_ENTRY)&_ZN6S662C53v27Ev,
  (VTBL_ENTRY)&_ZN6S662C53v28Ev,
  (VTBL_ENTRY)&_ZN6S662C53v29Ev,
  (VTBL_ENTRY)&_ZN6S662C53v30Ev,
  (VTBL_ENTRY)&_ZN6S662C53v31Ev,
  (VTBL_ENTRY)&_ZN6S662C53v32Ev,
  (VTBL_ENTRY)&_ZN6S662C53v33Ev,
  (VTBL_ENTRY)&_ZN6S662C53v34Ev,
  (VTBL_ENTRY)&_ZN6S662C53v35Ev,
  (VTBL_ENTRY)&_ZN6S662C53v36Ev,
  (VTBL_ENTRY)&_ZN6S662C53v37Ev,
  (VTBL_ENTRY)&_ZN6S662C53v38Ev,
  (VTBL_ENTRY)&_ZN6S662C53v39Ev,
  (VTBL_ENTRY)&_ZN6S662C53v40Ev,
  (VTBL_ENTRY)&_ZN6S662C53v41Ev,
  (VTBL_ENTRY)&_ZN6S662C53v42Ev,
  (VTBL_ENTRY)&_ZN6S662C53v43Ev,
  (VTBL_ENTRY)&_ZN6S662C53v44Ev,
  (VTBL_ENTRY)&_ZN6S662C53v45Ev,
  (VTBL_ENTRY)&_ZN6S662C53v46Ev,
  (VTBL_ENTRY)&_ZN6S662C53v47Ev,
  (VTBL_ENTRY)&_ZN6S662C53v48Ev,
  (VTBL_ENTRY)&_ZN6S662C53v49Ev,
  (VTBL_ENTRY)&_ZN6S662C53v50Ev,
  (VTBL_ENTRY)&_ZN6S662C53v51Ev,
  (VTBL_ENTRY)&_ZN6S662C53v52Ev,
  (VTBL_ENTRY)&_ZN6S662C53v53Ev,
  (VTBL_ENTRY)&_ZN6S662C53v54Ev,
  (VTBL_ENTRY)&_ZN6S662C53v55Ev,
  (VTBL_ENTRY)&_ZN6S662C53v56Ev,
  (VTBL_ENTRY)&_ZN6S662C53v57Ev,
  (VTBL_ENTRY)&_ZN6S662C53v58Ev,
  (VTBL_ENTRY)&_ZN6S662C53v59Ev,
  (VTBL_ENTRY)&_ZN6S662C53v60Ev,
  (VTBL_ENTRY)&_ZN6S662C53v61Ev,
  (VTBL_ENTRY)&_ZN6S662C53v62Ev,
  (VTBL_ENTRY)&_ZN6S662C53v63Ev,
  (VTBL_ENTRY)&_ZN6S662C53v64Ev,
  (VTBL_ENTRY)&_ZN6S662C53v65Ev,
  (VTBL_ENTRY)&_ZN6S662C53v66Ev,
  (VTBL_ENTRY)&_ZN6S662C53v67Ev,
  (VTBL_ENTRY)&_ZN6S662C53v68Ev,
  (VTBL_ENTRY)&_ZN6S662C53v69Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v96Ev,
};
extern VTBL_ENTRY _ZTI9S662C3_nt[];
VTBL_ENTRY *P__ZTI9S662C3_nt = _ZTI9S662C3_nt; 
extern  VTBL_ENTRY _ZTV9S662C3_nt[];
Class_Descriptor cd_S662C3_nt = {  "S662C3_nt", // class name
  bases_S662C3_nt, 2,
  &(vtc_S662C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(136,84), // object size
  NSPAIRA(_ZTI9S662C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S662C3_nt),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S662C8_nt  {
  void  mf662c8(); // _ZN9S662C8_nt7mf662c8Ev
};
//SIG(-1 S662C8_nt) C1{ m}


void  S662C8_nt ::mf662c8(){}

//skip512 S662C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S662C11_nt  {
  ::S1540C14_nt s662c11f0;
  ::S1540C14_nt s662c11f1;
  int s662c11f2;
  void  mf662c11(); // _ZN10S662C11_nt8mf662c11Ev
};
//SIG(-1 S662C11_nt) C1{ m FC2{ m Fi[3]} FC2 Fi}


void  S662C11_nt ::mf662c11(){}

//skip512 S662C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S662C14  {
  void  mf662c14(); // _ZN7S662C148mf662c14Ev
};
//SIG(-1 S662C14) C1{ m}


void  S662C14 ::mf662c14(){}

static void Test_S662C14()
{
  {
    init_simple_test("S662C14");
    S662C14 lv;
    check2(sizeof(lv), 1, "sizeof(S662C14)");
    check2(__alignof__(lv), 1, "__alignof__(S662C14)");
  }
}
static Arrange_To_Call_Me vS662C14(Test_S662C14, "S662C14", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S662C14[];
VTBL_ENTRY *P__ZTI7S662C14 = _ZTI7S662C14; 
Class_Descriptor cd_S662C14 = {  "S662C14", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI7S662C14),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S662C17_nt  {
  int s662c17f0[3];
  void  mf662c17(); // _ZN10S662C17_nt8mf662c17Ev
};
//SIG(-1 S662C17_nt) C1{ m Fi[3]}


void  S662C17_nt ::mf662c17(){}

//skip512 S662C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S662C2_nt  : S662C3_nt {
  void *s662c2f0;
  ::S1540C9_nt s662c2f1;
  int s662c2f2;
  ::S662C8_nt s662c2f3;
  int s662c2f4;
  ::S1540C29 s662c2f5;
  int s662c2f6;
  void *s662c2f7[2];
  ::S662C11_nt s662c2f8;
  void *s662c2f9;
  int s662c2f10[2];
  char s662c2f11[3];
  int s662c2f12;
  unsigned int s662c2f13:1;
  unsigned int s662c2f14:1;
  unsigned int s662c2f15:1;
  unsigned int s662c2f16:1;
  unsigned int s662c2f17:1;
  unsigned int s662c2f18:1;
  unsigned int s662c2f19:1;
  unsigned int s662c2f20:1;
  unsigned int s662c2f21:1;
  unsigned int s662c2f22:1;
  unsigned int s662c2f23:1;
  unsigned int s662c2f24:1;
  unsigned int s662c2f25:1;
  unsigned int s662c2f26:1;
  int s662c2f27;
  unsigned int s662c2f28:1;
  unsigned int s662c2f29:1;
  unsigned int s662c2f30:1;
  unsigned int s662c2f31:1;
  unsigned int s662c2f32:1;
  unsigned int s662c2f33:1;
  ::S662C8_nt s662c2f34;
  unsigned int s662c2f35:1;
  unsigned int s662c2f36:1;
  unsigned int s662c2f37:1;
  unsigned int s662c2f38:1;
  unsigned int s662c2f39:1;
  unsigned int s662c2f40:1;
  unsigned int s662c2f41:1;
  char s662c2f42;
  ::S662C14 s662c2f43;
  unsigned int s662c2f44:1;
  unsigned int s662c2f45:1;
  unsigned int s662c2f46:1;
  unsigned int s662c2f47:1;
  unsigned int s662c2f48:1;
  unsigned int s662c2f49:1;
  unsigned int s662c2f50:1;
  unsigned int s662c2f51:1;
  unsigned int s662c2f52:1;
  unsigned int s662c2f53:1;
  unsigned int s662c2f54:1;
  unsigned int s662c2f55:1;
  ::S1540C28 s662c2f56;
  void *s662c2f57[2];
  char s662c2f58;
  ::S662C8_nt s662c2f59;
  ::S1540C14_nt s662c2f60;
  ::S662C17_nt s662c2f61;
  int s662c2f62;
  ::S1540C14_nt s662c2f63;
  unsigned int s662c2f64:1;
  unsigned int s662c2f65:1;
  unsigned int s662c2f66:1;
  int s662c2f67[3];
  virtual  ~S662C2_nt(); // _ZN9S662C2_ntD1Ev
  virtual void  v97(); // _ZN9S662C2_nt3v97Ev
  virtual void  v98(); // _ZN9S662C2_nt3v98Ev
  virtual void  v99(); // _ZN9S662C2_nt3v99Ev
  virtual void  v100(); // _ZN9S662C2_nt4v100Ev
  virtual void  v101(); // _ZN9S662C2_nt4v101Ev
  virtual void  v102(); // _ZN9S662C2_nt4v102Ev
  virtual void  v103(); // _ZN9S662C2_nt4v103Ev
  virtual void  v104(); // _ZN9S662C2_nt4v104Ev
  virtual void  v105(); // _ZN9S662C2_nt4v105Ev
  virtual void  v106(); // _ZN9S662C2_nt4v106Ev
  virtual void  v107(); // _ZN9S662C2_nt4v107Ev
  virtual void  v108(); // _ZN9S662C2_nt4v108Ev
  virtual void  v109(); // _ZN9S662C2_nt4v109Ev
  virtual void  v110(); // _ZN9S662C2_nt4v110Ev
  virtual void  v111(); // _ZN9S662C2_nt4v111Ev
  virtual void  v112(); // _ZN9S662C2_nt4v112Ev
  virtual void  v113(); // _ZN9S662C2_nt4v113Ev
  virtual void  v114(); // _ZN9S662C2_nt4v114Ev
  virtual void  v115(); // _ZN9S662C2_nt4v115Ev
  virtual void  v116(); // _ZN9S662C2_nt4v116Ev
  virtual void  v117(); // _ZN9S662C2_nt4v117Ev
  virtual void  v118(); // _ZN9S662C2_nt4v118Ev
  virtual void  v119(); // _ZN9S662C2_nt4v119Ev
  virtual void  v120(); // _ZN9S662C2_nt4v120Ev
  virtual void  v121(); // _ZN9S662C2_nt4v121Ev
  virtual void  v122(); // _ZN9S662C2_nt4v122Ev
  virtual void  v123(); // _ZN9S662C2_nt4v123Ev
  virtual void  v124(); // _ZN9S662C2_nt4v124Ev
  virtual void  v125(); // _ZN9S662C2_nt4v125Ev
  virtual void  v126(); // _ZN9S662C2_nt4v126Ev
  virtual void  v127(); // _ZN9S662C2_nt4v127Ev
  virtual void  v128(); // _ZN9S662C2_nt4v128Ev
  virtual void  v129(); // _ZN9S662C2_nt4v129Ev
  virtual void  v130(); // _ZN9S662C2_nt4v130Ev
  virtual void  v131(); // _ZN9S662C2_nt4v131Ev
  virtual void  v132(); // _ZN9S662C2_nt4v132Ev
  virtual void  v133(); // _ZN9S662C2_nt4v133Ev
  virtual void  v134(); // _ZN9S662C2_nt4v134Ev
  virtual void  v135(); // _ZN9S662C2_nt4v135Ev
  virtual void  v136(); // _ZN9S662C2_nt4v136Ev
  virtual void  v137(); // _ZN9S662C2_nt4v137Ev
  virtual void  v138(); // _ZN9S662C2_nt4v138Ev
  virtual void  v139(); // _ZN9S662C2_nt4v139Ev
  virtual void  v140(); // _ZN9S662C2_nt4v140Ev
  virtual void  v141(); // _ZN9S662C2_nt4v141Ev
  virtual void  v142(); // _ZN9S662C2_nt4v142Ev
  virtual void  v143(); // _ZN9S662C2_nt4v143Ev
  virtual void  v144(); // _ZN9S662C2_nt4v144Ev
  virtual void  v145(); // _ZN9S662C2_nt4v145Ev
  virtual void  v146(); // _ZN9S662C2_nt4v146Ev
  virtual void  v147(); // _ZN9S662C2_nt4v147Ev
  virtual void  v148(); // _ZN9S662C2_nt4v148Ev
  virtual void  v149(); // _ZN9S662C2_nt4v149Ev
  virtual void  v150(); // _ZN9S662C2_nt4v150Ev
  virtual void  v151(); // _ZN9S662C2_nt4v151Ev
  virtual void  v152(); // _ZN9S662C2_nt4v152Ev
  virtual void  v153(); // _ZN9S662C2_nt4v153Ev
  virtual void  v154(); // _ZN9S662C2_nt4v154Ev
  virtual void  v155(); // _ZN9S662C2_nt4v155Ev
  virtual void  v156(); // _ZN9S662C2_nt4v156Ev
  virtual void  v157(); // _ZN9S662C2_nt4v157Ev
  S662C2_nt(); // tgen
};
//SIG(-1 S662C2_nt) C1{ BC2{ BC3{ BC4{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v126 v127 v128 v129 v130 Fp FC5} vd v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp FC6{ m Fi} Fi FC7{ m} Fi FC8{ BC9{ m Fp Fi[2]}} Fi Fp[2] FC10{ m FC11{ m Fi[3]} FC11 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC12{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC13{ BC8} Fp[2] Fc FC7 FC11 FC14{ m Fi[3]} Fi FC11 Fi:1 Fi:1 Fi:1 Fi[3]}


 S662C2_nt ::~S662C2_nt(){ note_dtor("S662C2_nt", this);}
void  S662C2_nt ::v97(){vfunc_called(this, "_ZN9S662C2_nt3v97Ev");}
void  S662C2_nt ::v98(){vfunc_called(this, "_ZN9S662C2_nt3v98Ev");}
void  S662C2_nt ::v99(){vfunc_called(this, "_ZN9S662C2_nt3v99Ev");}
void  S662C2_nt ::v100(){vfunc_called(this, "_ZN9S662C2_nt4v100Ev");}
void  S662C2_nt ::v101(){vfunc_called(this, "_ZN9S662C2_nt4v101Ev");}
void  S662C2_nt ::v102(){vfunc_called(this, "_ZN9S662C2_nt4v102Ev");}
void  S662C2_nt ::v103(){vfunc_called(this, "_ZN9S662C2_nt4v103Ev");}
void  S662C2_nt ::v104(){vfunc_called(this, "_ZN9S662C2_nt4v104Ev");}
void  S662C2_nt ::v105(){vfunc_called(this, "_ZN9S662C2_nt4v105Ev");}
void  S662C2_nt ::v106(){vfunc_called(this, "_ZN9S662C2_nt4v106Ev");}
void  S662C2_nt ::v107(){vfunc_called(this, "_ZN9S662C2_nt4v107Ev");}
void  S662C2_nt ::v108(){vfunc_called(this, "_ZN9S662C2_nt4v108Ev");}
void  S662C2_nt ::v109(){vfunc_called(this, "_ZN9S662C2_nt4v109Ev");}
void  S662C2_nt ::v110(){vfunc_called(this, "_ZN9S662C2_nt4v110Ev");}
void  S662C2_nt ::v111(){vfunc_called(this, "_ZN9S662C2_nt4v111Ev");}
void  S662C2_nt ::v112(){vfunc_called(this, "_ZN9S662C2_nt4v112Ev");}
void  S662C2_nt ::v113(){vfunc_called(this, "_ZN9S662C2_nt4v113Ev");}
void  S662C2_nt ::v114(){vfunc_called(this, "_ZN9S662C2_nt4v114Ev");}
void  S662C2_nt ::v115(){vfunc_called(this, "_ZN9S662C2_nt4v115Ev");}
void  S662C2_nt ::v116(){vfunc_called(this, "_ZN9S662C2_nt4v116Ev");}
void  S662C2_nt ::v117(){vfunc_called(this, "_ZN9S662C2_nt4v117Ev");}
void  S662C2_nt ::v118(){vfunc_called(this, "_ZN9S662C2_nt4v118Ev");}
void  S662C2_nt ::v119(){vfunc_called(this, "_ZN9S662C2_nt4v119Ev");}
void  S662C2_nt ::v120(){vfunc_called(this, "_ZN9S662C2_nt4v120Ev");}
void  S662C2_nt ::v121(){vfunc_called(this, "_ZN9S662C2_nt4v121Ev");}
void  S662C2_nt ::v122(){vfunc_called(this, "_ZN9S662C2_nt4v122Ev");}
void  S662C2_nt ::v123(){vfunc_called(this, "_ZN9S662C2_nt4v123Ev");}
void  S662C2_nt ::v124(){vfunc_called(this, "_ZN9S662C2_nt4v124Ev");}
void  S662C2_nt ::v125(){vfunc_called(this, "_ZN9S662C2_nt4v125Ev");}
void  S662C2_nt ::v126(){vfunc_called(this, "_ZN9S662C2_nt4v126Ev");}
void  S662C2_nt ::v127(){vfunc_called(this, "_ZN9S662C2_nt4v127Ev");}
void  S662C2_nt ::v128(){vfunc_called(this, "_ZN9S662C2_nt4v128Ev");}
void  S662C2_nt ::v129(){vfunc_called(this, "_ZN9S662C2_nt4v129Ev");}
void  S662C2_nt ::v130(){vfunc_called(this, "_ZN9S662C2_nt4v130Ev");}
void  S662C2_nt ::v131(){vfunc_called(this, "_ZN9S662C2_nt4v131Ev");}
void  S662C2_nt ::v132(){vfunc_called(this, "_ZN9S662C2_nt4v132Ev");}
void  S662C2_nt ::v133(){vfunc_called(this, "_ZN9S662C2_nt4v133Ev");}
void  S662C2_nt ::v134(){vfunc_called(this, "_ZN9S662C2_nt4v134Ev");}
void  S662C2_nt ::v135(){vfunc_called(this, "_ZN9S662C2_nt4v135Ev");}
void  S662C2_nt ::v136(){vfunc_called(this, "_ZN9S662C2_nt4v136Ev");}
void  S662C2_nt ::v137(){vfunc_called(this, "_ZN9S662C2_nt4v137Ev");}
void  S662C2_nt ::v138(){vfunc_called(this, "_ZN9S662C2_nt4v138Ev");}
void  S662C2_nt ::v139(){vfunc_called(this, "_ZN9S662C2_nt4v139Ev");}
void  S662C2_nt ::v140(){vfunc_called(this, "_ZN9S662C2_nt4v140Ev");}
void  S662C2_nt ::v141(){vfunc_called(this, "_ZN9S662C2_nt4v141Ev");}
void  S662C2_nt ::v142(){vfunc_called(this, "_ZN9S662C2_nt4v142Ev");}
void  S662C2_nt ::v143(){vfunc_called(this, "_ZN9S662C2_nt4v143Ev");}
void  S662C2_nt ::v144(){vfunc_called(this, "_ZN9S662C2_nt4v144Ev");}
void  S662C2_nt ::v145(){vfunc_called(this, "_ZN9S662C2_nt4v145Ev");}
void  S662C2_nt ::v146(){vfunc_called(this, "_ZN9S662C2_nt4v146Ev");}
void  S662C2_nt ::v147(){vfunc_called(this, "_ZN9S662C2_nt4v147Ev");}
void  S662C2_nt ::v148(){vfunc_called(this, "_ZN9S662C2_nt4v148Ev");}
void  S662C2_nt ::v149(){vfunc_called(this, "_ZN9S662C2_nt4v149Ev");}
void  S662C2_nt ::v150(){vfunc_called(this, "_ZN9S662C2_nt4v150Ev");}
void  S662C2_nt ::v151(){vfunc_called(this, "_ZN9S662C2_nt4v151Ev");}
void  S662C2_nt ::v152(){vfunc_called(this, "_ZN9S662C2_nt4v152Ev");}
void  S662C2_nt ::v153(){vfunc_called(this, "_ZN9S662C2_nt4v153Ev");}
void  S662C2_nt ::v154(){vfunc_called(this, "_ZN9S662C2_nt4v154Ev");}
void  S662C2_nt ::v155(){vfunc_called(this, "_ZN9S662C2_nt4v155Ev");}
void  S662C2_nt ::v156(){vfunc_called(this, "_ZN9S662C2_nt4v156Ev");}
void  S662C2_nt ::v157(){vfunc_called(this, "_ZN9S662C2_nt4v157Ev");}
S662C2_nt ::S662C2_nt(){ note_ctor("S662C2_nt", this);} // tgen

//skip512 S662C2_nt

#else // __cplusplus

extern void _ZN9S662C2_ntC1Ev();
extern void _ZN9S662C2_ntD1Ev();
Name_Map name_map_S662C2_nt[] = {
  NSPAIR(_ZN9S662C2_ntC1Ev),
  NSPAIR(_ZN9S662C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S662C5;
extern VTBL_ENTRY _ZTI6S662C5[];
extern  VTBL_ENTRY _ZTV6S662C5[];
extern Class_Descriptor cd_S662C4_nt;
extern VTBL_ENTRY _ZTI9S662C4_nt[];
extern  VTBL_ENTRY _ZTV9S662C4_nt[];
extern Class_Descriptor cd_S662C3_nt;
extern VTBL_ENTRY _ZTI9S662C3_nt[];
extern  VTBL_ENTRY _ZTV9S662C3_nt[];
static Base_Class bases_S662C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S662C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S662C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S662C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S662C2_nt[];
extern void _ZN9S662C2_ntD1Ev();
extern void _ZN9S662C2_ntD0Ev();
extern void _ZN6S662C52v6Ev();
extern void _ZN6S662C52v7Ev();
extern void _ZN6S662C52v8Ev();
extern void _ZN6S662C52v9Ev();
extern void _ZN6S662C53v10Ev();
extern void _ZN6S662C53v11Ev();
extern void _ZN6S662C53v12Ev();
extern void _ZN6S662C53v13Ev();
extern void _ZN6S662C53v14Ev();
extern void _ZN6S662C53v15Ev();
extern void _ZN6S662C53v16Ev();
extern void _ZN6S662C53v17Ev();
extern void _ZN6S662C53v18Ev();
extern void _ZN6S662C53v19Ev();
extern void _ZN6S662C53v20Ev();
extern void _ZN6S662C53v21Ev();
extern void _ZN6S662C53v22Ev();
extern void _ZN6S662C53v23Ev();
extern void _ZN6S662C53v24Ev();
extern void _ZN6S662C53v25Ev();
extern void _ZN6S662C53v26Ev();
extern void _ZN6S662C53v27Ev();
extern void _ZN6S662C53v28Ev();
extern void _ZN6S662C53v29Ev();
extern void _ZN6S662C53v30Ev();
extern void _ZN6S662C53v31Ev();
extern void _ZN6S662C53v32Ev();
extern void _ZN6S662C53v33Ev();
extern void _ZN6S662C53v34Ev();
extern void _ZN6S662C53v35Ev();
extern void _ZN6S662C53v36Ev();
extern void _ZN6S662C53v37Ev();
extern void _ZN6S662C53v38Ev();
extern void _ZN6S662C53v39Ev();
extern void _ZN6S662C53v40Ev();
extern void _ZN6S662C53v41Ev();
extern void _ZN6S662C53v42Ev();
extern void _ZN6S662C53v43Ev();
extern void _ZN6S662C53v44Ev();
extern void _ZN6S662C53v45Ev();
extern void _ZN6S662C53v46Ev();
extern void _ZN6S662C53v47Ev();
extern void _ZN6S662C53v48Ev();
extern void _ZN6S662C53v49Ev();
extern void _ZN6S662C53v50Ev();
extern void _ZN6S662C53v51Ev();
extern void _ZN6S662C53v52Ev();
extern void _ZN6S662C53v53Ev();
extern void _ZN6S662C53v54Ev();
extern void _ZN6S662C53v55Ev();
extern void _ZN6S662C53v56Ev();
extern void _ZN6S662C53v57Ev();
extern void _ZN6S662C53v58Ev();
extern void _ZN6S662C53v59Ev();
extern void _ZN6S662C53v60Ev();
extern void _ZN6S662C53v61Ev();
extern void _ZN6S662C53v62Ev();
extern void _ZN6S662C53v63Ev();
extern void _ZN6S662C53v64Ev();
extern void _ZN6S662C53v65Ev();
extern void _ZN6S662C53v66Ev();
extern void _ZN6S662C53v67Ev();
extern void _ZN6S662C53v68Ev();
extern void _ZN6S662C53v69Ev();
extern void _ZN9S662C4_nt3v70Ev();
extern void _ZN9S662C4_nt3v71Ev();
extern void _ZN9S662C4_nt3v72Ev();
extern void _ZN9S662C4_nt3v73Ev();
extern void _ZN9S662C4_nt3v74Ev();
extern void _ZN9S662C3_nt3v75Ev();
extern void _ZN9S662C3_nt3v76Ev();
extern void _ZN9S662C3_nt3v77Ev();
extern void _ZN9S662C3_nt3v78Ev();
extern void _ZN9S662C3_nt3v79Ev();
extern void _ZN9S662C3_nt3v80Ev();
extern void _ZN9S662C3_nt3v81Ev();
extern void _ZN9S662C3_nt3v82Ev();
extern void _ZN9S662C3_nt3v83Ev();
extern void _ZN9S662C3_nt3v84Ev();
extern void _ZN9S662C3_nt3v85Ev();
extern void _ZN9S662C3_nt3v86Ev();
extern void _ZN9S662C3_nt3v87Ev();
extern void _ZN9S662C3_nt3v88Ev();
extern void _ZN9S662C3_nt3v89Ev();
extern void _ZN9S662C3_nt3v90Ev();
extern void _ZN9S662C3_nt3v91Ev();
extern void _ZN9S662C3_nt3v92Ev();
extern void _ZN9S662C3_nt3v93Ev();
extern void _ZN9S662C3_nt3v94Ev();
extern void _ZN9S662C3_nt3v95Ev();
extern void _ZN9S662C3_nt3v96Ev();
extern void _ZN9S662C2_nt3v97Ev();
extern void _ZN9S662C2_nt3v98Ev();
extern void _ZN9S662C2_nt3v99Ev();
extern void _ZN9S662C2_nt4v100Ev();
extern void _ZN9S662C2_nt4v101Ev();
extern void _ZN9S662C2_nt4v102Ev();
extern void _ZN9S662C2_nt4v103Ev();
extern void _ZN9S662C2_nt4v104Ev();
extern void _ZN9S662C2_nt4v105Ev();
extern void _ZN9S662C2_nt4v106Ev();
extern void _ZN9S662C2_nt4v107Ev();
extern void _ZN9S662C2_nt4v108Ev();
extern void _ZN9S662C2_nt4v109Ev();
extern void _ZN9S662C2_nt4v110Ev();
extern void _ZN9S662C2_nt4v111Ev();
extern void _ZN9S662C2_nt4v112Ev();
extern void _ZN9S662C2_nt4v113Ev();
extern void _ZN9S662C2_nt4v114Ev();
extern void _ZN9S662C2_nt4v115Ev();
extern void _ZN9S662C2_nt4v116Ev();
extern void _ZN9S662C2_nt4v117Ev();
extern void _ZN9S662C2_nt4v118Ev();
extern void _ZN9S662C2_nt4v119Ev();
extern void _ZN9S662C2_nt4v120Ev();
extern void _ZN9S662C2_nt4v121Ev();
extern void _ZN9S662C2_nt4v122Ev();
extern void _ZN9S662C2_nt4v123Ev();
extern void _ZN9S662C2_nt4v124Ev();
extern void _ZN9S662C2_nt4v125Ev();
extern void _ZN9S662C2_nt4v126Ev();
extern void _ZN9S662C2_nt4v127Ev();
extern void _ZN9S662C2_nt4v128Ev();
extern void _ZN9S662C2_nt4v129Ev();
extern void _ZN9S662C2_nt4v130Ev();
extern void _ZN9S662C2_nt4v131Ev();
extern void _ZN9S662C2_nt4v132Ev();
extern void _ZN9S662C2_nt4v133Ev();
extern void _ZN9S662C2_nt4v134Ev();
extern void _ZN9S662C2_nt4v135Ev();
extern void _ZN9S662C2_nt4v136Ev();
extern void _ZN9S662C2_nt4v137Ev();
extern void _ZN9S662C2_nt4v138Ev();
extern void _ZN9S662C2_nt4v139Ev();
extern void _ZN9S662C2_nt4v140Ev();
extern void _ZN9S662C2_nt4v141Ev();
extern void _ZN9S662C2_nt4v142Ev();
extern void _ZN9S662C2_nt4v143Ev();
extern void _ZN9S662C2_nt4v144Ev();
extern void _ZN9S662C2_nt4v145Ev();
extern void _ZN9S662C2_nt4v146Ev();
extern void _ZN9S662C2_nt4v147Ev();
extern void _ZN9S662C2_nt4v148Ev();
extern void _ZN9S662C2_nt4v149Ev();
extern void _ZN9S662C2_nt4v150Ev();
extern void _ZN9S662C2_nt4v151Ev();
extern void _ZN9S662C2_nt4v152Ev();
extern void _ZN9S662C2_nt4v153Ev();
extern void _ZN9S662C2_nt4v154Ev();
extern void _ZN9S662C2_nt4v155Ev();
extern void _ZN9S662C2_nt4v156Ev();
extern void _ZN9S662C2_nt4v157Ev();
static  VTBL_ENTRY vtc_S662C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S662C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S662C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S662C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN6S662C52v6Ev,
  (VTBL_ENTRY)&_ZN6S662C52v7Ev,
  (VTBL_ENTRY)&_ZN6S662C52v8Ev,
  (VTBL_ENTRY)&_ZN6S662C52v9Ev,
  (VTBL_ENTRY)&_ZN6S662C53v10Ev,
  (VTBL_ENTRY)&_ZN6S662C53v11Ev,
  (VTBL_ENTRY)&_ZN6S662C53v12Ev,
  (VTBL_ENTRY)&_ZN6S662C53v13Ev,
  (VTBL_ENTRY)&_ZN6S662C53v14Ev,
  (VTBL_ENTRY)&_ZN6S662C53v15Ev,
  (VTBL_ENTRY)&_ZN6S662C53v16Ev,
  (VTBL_ENTRY)&_ZN6S662C53v17Ev,
  (VTBL_ENTRY)&_ZN6S662C53v18Ev,
  (VTBL_ENTRY)&_ZN6S662C53v19Ev,
  (VTBL_ENTRY)&_ZN6S662C53v20Ev,
  (VTBL_ENTRY)&_ZN6S662C53v21Ev,
  (VTBL_ENTRY)&_ZN6S662C53v22Ev,
  (VTBL_ENTRY)&_ZN6S662C53v23Ev,
  (VTBL_ENTRY)&_ZN6S662C53v24Ev,
  (VTBL_ENTRY)&_ZN6S662C53v25Ev,
  (VTBL_ENTRY)&_ZN6S662C53v26Ev,
  (VTBL_ENTRY)&_ZN6S662C53v27Ev,
  (VTBL_ENTRY)&_ZN6S662C53v28Ev,
  (VTBL_ENTRY)&_ZN6S662C53v29Ev,
  (VTBL_ENTRY)&_ZN6S662C53v30Ev,
  (VTBL_ENTRY)&_ZN6S662C53v31Ev,
  (VTBL_ENTRY)&_ZN6S662C53v32Ev,
  (VTBL_ENTRY)&_ZN6S662C53v33Ev,
  (VTBL_ENTRY)&_ZN6S662C53v34Ev,
  (VTBL_ENTRY)&_ZN6S662C53v35Ev,
  (VTBL_ENTRY)&_ZN6S662C53v36Ev,
  (VTBL_ENTRY)&_ZN6S662C53v37Ev,
  (VTBL_ENTRY)&_ZN6S662C53v38Ev,
  (VTBL_ENTRY)&_ZN6S662C53v39Ev,
  (VTBL_ENTRY)&_ZN6S662C53v40Ev,
  (VTBL_ENTRY)&_ZN6S662C53v41Ev,
  (VTBL_ENTRY)&_ZN6S662C53v42Ev,
  (VTBL_ENTRY)&_ZN6S662C53v43Ev,
  (VTBL_ENTRY)&_ZN6S662C53v44Ev,
  (VTBL_ENTRY)&_ZN6S662C53v45Ev,
  (VTBL_ENTRY)&_ZN6S662C53v46Ev,
  (VTBL_ENTRY)&_ZN6S662C53v47Ev,
  (VTBL_ENTRY)&_ZN6S662C53v48Ev,
  (VTBL_ENTRY)&_ZN6S662C53v49Ev,
  (VTBL_ENTRY)&_ZN6S662C53v50Ev,
  (VTBL_ENTRY)&_ZN6S662C53v51Ev,
  (VTBL_ENTRY)&_ZN6S662C53v52Ev,
  (VTBL_ENTRY)&_ZN6S662C53v53Ev,
  (VTBL_ENTRY)&_ZN6S662C53v54Ev,
  (VTBL_ENTRY)&_ZN6S662C53v55Ev,
  (VTBL_ENTRY)&_ZN6S662C53v56Ev,
  (VTBL_ENTRY)&_ZN6S662C53v57Ev,
  (VTBL_ENTRY)&_ZN6S662C53v58Ev,
  (VTBL_ENTRY)&_ZN6S662C53v59Ev,
  (VTBL_ENTRY)&_ZN6S662C53v60Ev,
  (VTBL_ENTRY)&_ZN6S662C53v61Ev,
  (VTBL_ENTRY)&_ZN6S662C53v62Ev,
  (VTBL_ENTRY)&_ZN6S662C53v63Ev,
  (VTBL_ENTRY)&_ZN6S662C53v64Ev,
  (VTBL_ENTRY)&_ZN6S662C53v65Ev,
  (VTBL_ENTRY)&_ZN6S662C53v66Ev,
  (VTBL_ENTRY)&_ZN6S662C53v67Ev,
  (VTBL_ENTRY)&_ZN6S662C53v68Ev,
  (VTBL_ENTRY)&_ZN6S662C53v69Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v157Ev,
};
extern VTBL_ENTRY _ZTI9S662C2_nt[];
VTBL_ENTRY *P__ZTI9S662C2_nt = _ZTI9S662C2_nt; 
extern  VTBL_ENTRY _ZTV9S662C2_nt[];
Class_Descriptor cd_S662C2_nt = {  "S662C2_nt", // class name
  bases_S662C2_nt, 3,
  &(vtc_S662C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI9S662C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S662C2_nt),156, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S662C1  : S662C2_nt {
  virtual  ~S662C1(); // _ZN6S662C1D1Ev
  virtual void  v1(); // _ZN6S662C12v1Ev
  virtual void  v2(); // _ZN6S662C12v2Ev
  virtual void  v3(); // _ZN6S662C12v3Ev
  virtual void  v4(); // _ZN6S662C12v4Ev
  virtual void  v5(); // _ZN6S662C12v5Ev
  S662C1(); // tgen
};
//SIG(1 S662C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73 v74 Fp FC6} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 Fc} vd v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 Fp FC7{ m Fi} Fi FC8{ m} Fi FC9{ BC10{ m Fp Fi[2]}} Fi Fp[2] FC11{ m FC12{ m Fi[3]} FC12 Fi} Fp Fi[2] Fc[3] Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fc FC13{ m} Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 FC14{ BC9} Fp[2] Fc FC8 FC12 FC15{ m Fi[3]} Fi FC12 Fi:1 Fi:1 Fi:1 Fi[3]} vd v1 v2 v3 v4 v5}


 S662C1 ::~S662C1(){ note_dtor("S662C1", this);}
void  S662C1 ::v1(){vfunc_called(this, "_ZN6S662C12v1Ev");}
void  S662C1 ::v2(){vfunc_called(this, "_ZN6S662C12v2Ev");}
void  S662C1 ::v3(){vfunc_called(this, "_ZN6S662C12v3Ev");}
void  S662C1 ::v4(){vfunc_called(this, "_ZN6S662C12v4Ev");}
void  S662C1 ::v5(){vfunc_called(this, "_ZN6S662C12v5Ev");}
S662C1 ::S662C1(){ note_ctor("S662C1", this);} // tgen

static void Test_S662C1()
{
  extern Class_Descriptor cd_S662C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,69)];
    init_test(&cd_S662C1, buf);
    S662C1 *dp, &lv = *(dp=new (buf) S662C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,272), "sizeof(S662C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S662C1)");
    check_base_class_offset(lv, (S662C5*)(S662C4_nt*)(S662C3_nt*)(S662C2_nt*), 0, "S662C1");
    check_base_class_offset(lv, (S662C4_nt*)(S662C3_nt*)(S662C2_nt*), 0, "S662C1");
    check_base_class_offset(lv, (S662C3_nt*)(S662C2_nt*), 0, "S662C1");
    check_base_class_offset(lv, (S662C2_nt*), 0, "S662C1");
    test_class_info(&lv, &cd_S662C1);
    dp->~S662C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS662C1(Test_S662C1, "S662C1", ABISELECT(368,272));

#else // __cplusplus

extern void _ZN6S662C1C1Ev();
extern void _ZN6S662C1D1Ev();
Name_Map name_map_S662C1[] = {
  NSPAIR(_ZN6S662C1C1Ev),
  NSPAIR(_ZN6S662C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S662C5;
extern VTBL_ENTRY _ZTI6S662C5[];
extern  VTBL_ENTRY _ZTV6S662C5[];
extern Class_Descriptor cd_S662C4_nt;
extern VTBL_ENTRY _ZTI9S662C4_nt[];
extern  VTBL_ENTRY _ZTV9S662C4_nt[];
extern Class_Descriptor cd_S662C3_nt;
extern VTBL_ENTRY _ZTI9S662C3_nt[];
extern  VTBL_ENTRY _ZTV9S662C3_nt[];
extern Class_Descriptor cd_S662C2_nt;
extern VTBL_ENTRY _ZTI9S662C2_nt[];
extern  VTBL_ENTRY _ZTV9S662C2_nt[];
static Base_Class bases_S662C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S662C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S662C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S662C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S662C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S662C1[];
extern void _ZN6S662C1D1Ev();
extern void _ZN6S662C1D0Ev();
extern void _ZN6S662C52v6Ev();
extern void _ZN6S662C52v7Ev();
extern void _ZN6S662C52v8Ev();
extern void _ZN6S662C52v9Ev();
extern void _ZN6S662C53v10Ev();
extern void _ZN6S662C53v11Ev();
extern void _ZN6S662C53v12Ev();
extern void _ZN6S662C53v13Ev();
extern void _ZN6S662C53v14Ev();
extern void _ZN6S662C53v15Ev();
extern void _ZN6S662C53v16Ev();
extern void _ZN6S662C53v17Ev();
extern void _ZN6S662C53v18Ev();
extern void _ZN6S662C53v19Ev();
extern void _ZN6S662C53v20Ev();
extern void _ZN6S662C53v21Ev();
extern void _ZN6S662C53v22Ev();
extern void _ZN6S662C53v23Ev();
extern void _ZN6S662C53v24Ev();
extern void _ZN6S662C53v25Ev();
extern void _ZN6S662C53v26Ev();
extern void _ZN6S662C53v27Ev();
extern void _ZN6S662C53v28Ev();
extern void _ZN6S662C53v29Ev();
extern void _ZN6S662C53v30Ev();
extern void _ZN6S662C53v31Ev();
extern void _ZN6S662C53v32Ev();
extern void _ZN6S662C53v33Ev();
extern void _ZN6S662C53v34Ev();
extern void _ZN6S662C53v35Ev();
extern void _ZN6S662C53v36Ev();
extern void _ZN6S662C53v37Ev();
extern void _ZN6S662C53v38Ev();
extern void _ZN6S662C53v39Ev();
extern void _ZN6S662C53v40Ev();
extern void _ZN6S662C53v41Ev();
extern void _ZN6S662C53v42Ev();
extern void _ZN6S662C53v43Ev();
extern void _ZN6S662C53v44Ev();
extern void _ZN6S662C53v45Ev();
extern void _ZN6S662C53v46Ev();
extern void _ZN6S662C53v47Ev();
extern void _ZN6S662C53v48Ev();
extern void _ZN6S662C53v49Ev();
extern void _ZN6S662C53v50Ev();
extern void _ZN6S662C53v51Ev();
extern void _ZN6S662C53v52Ev();
extern void _ZN6S662C53v53Ev();
extern void _ZN6S662C53v54Ev();
extern void _ZN6S662C53v55Ev();
extern void _ZN6S662C53v56Ev();
extern void _ZN6S662C53v57Ev();
extern void _ZN6S662C53v58Ev();
extern void _ZN6S662C53v59Ev();
extern void _ZN6S662C53v60Ev();
extern void _ZN6S662C53v61Ev();
extern void _ZN6S662C53v62Ev();
extern void _ZN6S662C53v63Ev();
extern void _ZN6S662C53v64Ev();
extern void _ZN6S662C53v65Ev();
extern void _ZN6S662C53v66Ev();
extern void _ZN6S662C53v67Ev();
extern void _ZN6S662C53v68Ev();
extern void _ZN6S662C53v69Ev();
extern void _ZN9S662C4_nt3v70Ev();
extern void _ZN9S662C4_nt3v71Ev();
extern void _ZN9S662C4_nt3v72Ev();
extern void _ZN9S662C4_nt3v73Ev();
extern void _ZN9S662C4_nt3v74Ev();
extern void _ZN9S662C3_nt3v75Ev();
extern void _ZN9S662C3_nt3v76Ev();
extern void _ZN9S662C3_nt3v77Ev();
extern void _ZN9S662C3_nt3v78Ev();
extern void _ZN9S662C3_nt3v79Ev();
extern void _ZN9S662C3_nt3v80Ev();
extern void _ZN9S662C3_nt3v81Ev();
extern void _ZN9S662C3_nt3v82Ev();
extern void _ZN9S662C3_nt3v83Ev();
extern void _ZN9S662C3_nt3v84Ev();
extern void _ZN9S662C3_nt3v85Ev();
extern void _ZN9S662C3_nt3v86Ev();
extern void _ZN9S662C3_nt3v87Ev();
extern void _ZN9S662C3_nt3v88Ev();
extern void _ZN9S662C3_nt3v89Ev();
extern void _ZN9S662C3_nt3v90Ev();
extern void _ZN9S662C3_nt3v91Ev();
extern void _ZN9S662C3_nt3v92Ev();
extern void _ZN9S662C3_nt3v93Ev();
extern void _ZN9S662C3_nt3v94Ev();
extern void _ZN9S662C3_nt3v95Ev();
extern void _ZN9S662C3_nt3v96Ev();
extern void _ZN9S662C2_nt3v97Ev();
extern void _ZN9S662C2_nt3v98Ev();
extern void _ZN9S662C2_nt3v99Ev();
extern void _ZN9S662C2_nt4v100Ev();
extern void _ZN9S662C2_nt4v101Ev();
extern void _ZN9S662C2_nt4v102Ev();
extern void _ZN9S662C2_nt4v103Ev();
extern void _ZN9S662C2_nt4v104Ev();
extern void _ZN9S662C2_nt4v105Ev();
extern void _ZN9S662C2_nt4v106Ev();
extern void _ZN9S662C2_nt4v107Ev();
extern void _ZN9S662C2_nt4v108Ev();
extern void _ZN9S662C2_nt4v109Ev();
extern void _ZN9S662C2_nt4v110Ev();
extern void _ZN9S662C2_nt4v111Ev();
extern void _ZN9S662C2_nt4v112Ev();
extern void _ZN9S662C2_nt4v113Ev();
extern void _ZN9S662C2_nt4v114Ev();
extern void _ZN9S662C2_nt4v115Ev();
extern void _ZN9S662C2_nt4v116Ev();
extern void _ZN9S662C2_nt4v117Ev();
extern void _ZN9S662C2_nt4v118Ev();
extern void _ZN9S662C2_nt4v119Ev();
extern void _ZN9S662C2_nt4v120Ev();
extern void _ZN9S662C2_nt4v121Ev();
extern void _ZN9S662C2_nt4v122Ev();
extern void _ZN9S662C2_nt4v123Ev();
extern void _ZN9S662C2_nt4v124Ev();
extern void _ZN9S662C2_nt4v125Ev();
extern void _ZN9S662C2_nt4v126Ev();
extern void _ZN9S662C2_nt4v127Ev();
extern void _ZN9S662C2_nt4v128Ev();
extern void _ZN9S662C2_nt4v129Ev();
extern void _ZN9S662C2_nt4v130Ev();
extern void _ZN9S662C2_nt4v131Ev();
extern void _ZN9S662C2_nt4v132Ev();
extern void _ZN9S662C2_nt4v133Ev();
extern void _ZN9S662C2_nt4v134Ev();
extern void _ZN9S662C2_nt4v135Ev();
extern void _ZN9S662C2_nt4v136Ev();
extern void _ZN9S662C2_nt4v137Ev();
extern void _ZN9S662C2_nt4v138Ev();
extern void _ZN9S662C2_nt4v139Ev();
extern void _ZN9S662C2_nt4v140Ev();
extern void _ZN9S662C2_nt4v141Ev();
extern void _ZN9S662C2_nt4v142Ev();
extern void _ZN9S662C2_nt4v143Ev();
extern void _ZN9S662C2_nt4v144Ev();
extern void _ZN9S662C2_nt4v145Ev();
extern void _ZN9S662C2_nt4v146Ev();
extern void _ZN9S662C2_nt4v147Ev();
extern void _ZN9S662C2_nt4v148Ev();
extern void _ZN9S662C2_nt4v149Ev();
extern void _ZN9S662C2_nt4v150Ev();
extern void _ZN9S662C2_nt4v151Ev();
extern void _ZN9S662C2_nt4v152Ev();
extern void _ZN9S662C2_nt4v153Ev();
extern void _ZN9S662C2_nt4v154Ev();
extern void _ZN9S662C2_nt4v155Ev();
extern void _ZN9S662C2_nt4v156Ev();
extern void _ZN9S662C2_nt4v157Ev();
extern void _ZN6S662C12v1Ev();
extern void _ZN6S662C12v2Ev();
extern void _ZN6S662C12v3Ev();
extern void _ZN6S662C12v4Ev();
extern void _ZN6S662C12v5Ev();
static  VTBL_ENTRY vtc_S662C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S662C1[0]),
  (VTBL_ENTRY)&_ZN6S662C1D1Ev,
  (VTBL_ENTRY)&_ZN6S662C1D0Ev,
  (VTBL_ENTRY)&_ZN6S662C52v6Ev,
  (VTBL_ENTRY)&_ZN6S662C52v7Ev,
  (VTBL_ENTRY)&_ZN6S662C52v8Ev,
  (VTBL_ENTRY)&_ZN6S662C52v9Ev,
  (VTBL_ENTRY)&_ZN6S662C53v10Ev,
  (VTBL_ENTRY)&_ZN6S662C53v11Ev,
  (VTBL_ENTRY)&_ZN6S662C53v12Ev,
  (VTBL_ENTRY)&_ZN6S662C53v13Ev,
  (VTBL_ENTRY)&_ZN6S662C53v14Ev,
  (VTBL_ENTRY)&_ZN6S662C53v15Ev,
  (VTBL_ENTRY)&_ZN6S662C53v16Ev,
  (VTBL_ENTRY)&_ZN6S662C53v17Ev,
  (VTBL_ENTRY)&_ZN6S662C53v18Ev,
  (VTBL_ENTRY)&_ZN6S662C53v19Ev,
  (VTBL_ENTRY)&_ZN6S662C53v20Ev,
  (VTBL_ENTRY)&_ZN6S662C53v21Ev,
  (VTBL_ENTRY)&_ZN6S662C53v22Ev,
  (VTBL_ENTRY)&_ZN6S662C53v23Ev,
  (VTBL_ENTRY)&_ZN6S662C53v24Ev,
  (VTBL_ENTRY)&_ZN6S662C53v25Ev,
  (VTBL_ENTRY)&_ZN6S662C53v26Ev,
  (VTBL_ENTRY)&_ZN6S662C53v27Ev,
  (VTBL_ENTRY)&_ZN6S662C53v28Ev,
  (VTBL_ENTRY)&_ZN6S662C53v29Ev,
  (VTBL_ENTRY)&_ZN6S662C53v30Ev,
  (VTBL_ENTRY)&_ZN6S662C53v31Ev,
  (VTBL_ENTRY)&_ZN6S662C53v32Ev,
  (VTBL_ENTRY)&_ZN6S662C53v33Ev,
  (VTBL_ENTRY)&_ZN6S662C53v34Ev,
  (VTBL_ENTRY)&_ZN6S662C53v35Ev,
  (VTBL_ENTRY)&_ZN6S662C53v36Ev,
  (VTBL_ENTRY)&_ZN6S662C53v37Ev,
  (VTBL_ENTRY)&_ZN6S662C53v38Ev,
  (VTBL_ENTRY)&_ZN6S662C53v39Ev,
  (VTBL_ENTRY)&_ZN6S662C53v40Ev,
  (VTBL_ENTRY)&_ZN6S662C53v41Ev,
  (VTBL_ENTRY)&_ZN6S662C53v42Ev,
  (VTBL_ENTRY)&_ZN6S662C53v43Ev,
  (VTBL_ENTRY)&_ZN6S662C53v44Ev,
  (VTBL_ENTRY)&_ZN6S662C53v45Ev,
  (VTBL_ENTRY)&_ZN6S662C53v46Ev,
  (VTBL_ENTRY)&_ZN6S662C53v47Ev,
  (VTBL_ENTRY)&_ZN6S662C53v48Ev,
  (VTBL_ENTRY)&_ZN6S662C53v49Ev,
  (VTBL_ENTRY)&_ZN6S662C53v50Ev,
  (VTBL_ENTRY)&_ZN6S662C53v51Ev,
  (VTBL_ENTRY)&_ZN6S662C53v52Ev,
  (VTBL_ENTRY)&_ZN6S662C53v53Ev,
  (VTBL_ENTRY)&_ZN6S662C53v54Ev,
  (VTBL_ENTRY)&_ZN6S662C53v55Ev,
  (VTBL_ENTRY)&_ZN6S662C53v56Ev,
  (VTBL_ENTRY)&_ZN6S662C53v57Ev,
  (VTBL_ENTRY)&_ZN6S662C53v58Ev,
  (VTBL_ENTRY)&_ZN6S662C53v59Ev,
  (VTBL_ENTRY)&_ZN6S662C53v60Ev,
  (VTBL_ENTRY)&_ZN6S662C53v61Ev,
  (VTBL_ENTRY)&_ZN6S662C53v62Ev,
  (VTBL_ENTRY)&_ZN6S662C53v63Ev,
  (VTBL_ENTRY)&_ZN6S662C53v64Ev,
  (VTBL_ENTRY)&_ZN6S662C53v65Ev,
  (VTBL_ENTRY)&_ZN6S662C53v66Ev,
  (VTBL_ENTRY)&_ZN6S662C53v67Ev,
  (VTBL_ENTRY)&_ZN6S662C53v68Ev,
  (VTBL_ENTRY)&_ZN6S662C53v69Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S662C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S662C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S662C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN6S662C12v1Ev,
  (VTBL_ENTRY)&_ZN6S662C12v2Ev,
  (VTBL_ENTRY)&_ZN6S662C12v3Ev,
  (VTBL_ENTRY)&_ZN6S662C12v4Ev,
  (VTBL_ENTRY)&_ZN6S662C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S662C1[];
extern  VTBL_ENTRY _ZTV6S662C1[];
Class_Descriptor cd_S662C1 = {  "S662C1", // class name
  bases_S662C1, 4,
  &(vtc_S662C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,272), // object size
  NSPAIRA(_ZTI6S662C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S662C1),161, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C2_nt  {
  virtual  ~S9624C2_nt(); // _ZN10S9624C2_ntD1Ev
  virtual void  v3(); // _ZN10S9624C2_nt2v3Ev
  S9624C2_nt(); // tgen
};
//SIG(-1 S9624C2_nt) C1{ vd v1}


 S9624C2_nt ::~S9624C2_nt(){ note_dtor("S9624C2_nt", this);}
void  S9624C2_nt ::v3(){vfunc_called(this, "_ZN10S9624C2_nt2v3Ev");}
S9624C2_nt ::S9624C2_nt(){ note_ctor("S9624C2_nt", this);} // tgen

//skip512 S9624C2_nt

#else // __cplusplus

extern void _ZN10S9624C2_ntC1Ev();
extern void _ZN10S9624C2_ntD1Ev();
Name_Map name_map_S9624C2_nt[] = {
  NSPAIR(_ZN10S9624C2_ntC1Ev),
  NSPAIR(_ZN10S9624C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S9624C2_nt[];
extern void _ZN10S9624C2_ntD1Ev();
extern void _ZN10S9624C2_ntD0Ev();
extern void _ZN10S9624C2_nt2v3Ev();
static  VTBL_ENTRY vtc_S9624C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9624C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S9624C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9624C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S9624C2_nt2v3Ev,
};
extern VTBL_ENTRY _ZTI10S9624C2_nt[];
VTBL_ENTRY *P__ZTI10S9624C2_nt = _ZTI10S9624C2_nt; 
extern  VTBL_ENTRY _ZTV10S9624C2_nt[];
Class_Descriptor cd_S9624C2_nt = {  "S9624C2_nt", // class name
  0,0,//no base classes
  &(vtc_S9624C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S9624C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S9624C2_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C3  {
  virtual  ~S9624C3(); // _ZN7S9624C3D1Ev
  virtual void  v4(); // _ZN7S9624C32v4Ev
  S9624C3(); // tgen
};
//SIG(-1 S9624C3) C1{ vd v1}


 S9624C3 ::~S9624C3(){ note_dtor("S9624C3", this);}
void  S9624C3 ::v4(){vfunc_called(this, "_ZN7S9624C32v4Ev");}
S9624C3 ::S9624C3(){ note_ctor("S9624C3", this);} // tgen

static void Test_S9624C3()
{
  extern Class_Descriptor cd_S9624C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9624C3, buf);
    S9624C3 *dp, &lv = *(dp=new (buf) S9624C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9624C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9624C3)");
    test_class_info(&lv, &cd_S9624C3);
    dp->~S9624C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9624C3(Test_S9624C3, "S9624C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9624C3C1Ev();
extern void _ZN7S9624C3D1Ev();
Name_Map name_map_S9624C3[] = {
  NSPAIR(_ZN7S9624C3C1Ev),
  NSPAIR(_ZN7S9624C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9624C3[];
extern void _ZN7S9624C3D1Ev();
extern void _ZN7S9624C3D0Ev();
extern void _ZN7S9624C32v4Ev();
static  VTBL_ENTRY vtc_S9624C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9624C3[0]),
  (VTBL_ENTRY)&_ZN7S9624C3D1Ev,
  (VTBL_ENTRY)&_ZN7S9624C3D0Ev,
  (VTBL_ENTRY)&_ZN7S9624C32v4Ev,
};
extern VTBL_ENTRY _ZTI7S9624C3[];
extern  VTBL_ENTRY _ZTV7S9624C3[];
Class_Descriptor cd_S9624C3 = {  "S9624C3", // class name
  0,0,//no base classes
  &(vtc_S9624C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9624C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9624C3),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C6_nt  {
  virtual  ~S9624C6_nt(); // _ZN10S9624C6_ntD1Ev
  virtual void  v6(); // _ZN10S9624C6_nt2v6Ev
  virtual void  v7(); // _ZN10S9624C6_nt2v7Ev
  virtual void  v8(); // _ZN10S9624C6_nt2v8Ev
  S9624C6_nt(); // tgen
};
//SIG(-1 S9624C6_nt) C1{ vd v1 v2 v3}


 S9624C6_nt ::~S9624C6_nt(){ note_dtor("S9624C6_nt", this);}
void  S9624C6_nt ::v6(){vfunc_called(this, "_ZN10S9624C6_nt2v6Ev");}
void  S9624C6_nt ::v7(){vfunc_called(this, "_ZN10S9624C6_nt2v7Ev");}
void  S9624C6_nt ::v8(){vfunc_called(this, "_ZN10S9624C6_nt2v8Ev");}
S9624C6_nt ::S9624C6_nt(){ note_ctor("S9624C6_nt", this);} // tgen

//skip512 S9624C6_nt

#else // __cplusplus

extern void _ZN10S9624C6_ntC1Ev();
extern void _ZN10S9624C6_ntD1Ev();
Name_Map name_map_S9624C6_nt[] = {
  NSPAIR(_ZN10S9624C6_ntC1Ev),
  NSPAIR(_ZN10S9624C6_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S9624C6_nt[];
extern void _ZN10S9624C6_ntD1Ev();
extern void _ZN10S9624C6_ntD0Ev();
extern void _ZN10S9624C6_nt2v6Ev();
extern void _ZN10S9624C6_nt2v7Ev();
extern void _ZN10S9624C6_nt2v8Ev();
static  VTBL_ENTRY vtc_S9624C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9624C6_nt[0]),
  (VTBL_ENTRY)&_ZN10S9624C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9624C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S9624C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S9624C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S9624C6_nt2v8Ev,
};
extern VTBL_ENTRY _ZTI10S9624C6_nt[];
VTBL_ENTRY *P__ZTI10S9624C6_nt = _ZTI10S9624C6_nt; 
extern  VTBL_ENTRY _ZTV10S9624C6_nt[];
Class_Descriptor cd_S9624C6_nt = {  "S9624C6_nt", // class name
  0,0,//no base classes
  &(vtc_S9624C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S9624C6_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S9624C6_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C7_nt  {
  void *s9624c7f0;
  int s9624c7f1[2];
  ::S662C14 s9624c7f2;
  void  mf9624c7(); // _ZN10S9624C7_nt8mf9624c7Ev
};
//SIG(-1 S9624C7_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S9624C7_nt ::mf9624c7(){}

//skip512 S9624C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C10_nt  {
  long s9624c10f0[4];
};
//SIG(-1 S9624C10_nt) C1{ Fl[4]}



//skip512 S9624C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C9_nt  {
  ::S9624C10_nt s9624c9f0;
  void  mf9624c9(); // _ZN10S9624C9_nt8mf9624c9Ev
};
//SIG(-1 S9624C9_nt) C1{ m FC2{ Fl[4]}}


void  S9624C9_nt ::mf9624c9(){}

//skip512 S9624C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C5_nt  : S9624C6_nt {
  ::S9624C7_nt s9624c5f0;
  ::S9624C9_nt s9624c5f1;
  char s9624c5f2;
  virtual  ~S9624C5_nt(); // _ZN10S9624C5_ntD1Ev
  virtual void  v9(); // _ZN10S9624C5_nt2v9Ev
  virtual void  v10(); // _ZN10S9624C5_nt3v10Ev
  virtual void  v11(); // _ZN10S9624C5_nt3v11Ev
  S9624C5_nt(); // tgen
};
//SIG(-1 S9624C5_nt) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ Fl[4]}} Fc}


 S9624C5_nt ::~S9624C5_nt(){ note_dtor("S9624C5_nt", this);}
void  S9624C5_nt ::v9(){vfunc_called(this, "_ZN10S9624C5_nt2v9Ev");}
void  S9624C5_nt ::v10(){vfunc_called(this, "_ZN10S9624C5_nt3v10Ev");}
void  S9624C5_nt ::v11(){vfunc_called(this, "_ZN10S9624C5_nt3v11Ev");}
S9624C5_nt ::S9624C5_nt(){ note_ctor("S9624C5_nt", this);} // tgen

//skip512 S9624C5_nt

#else // __cplusplus

extern void _ZN10S9624C5_ntC1Ev();
extern void _ZN10S9624C5_ntD1Ev();
Name_Map name_map_S9624C5_nt[] = {
  NSPAIR(_ZN10S9624C5_ntC1Ev),
  NSPAIR(_ZN10S9624C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C6_nt;
extern VTBL_ENTRY _ZTI10S9624C6_nt[];
extern  VTBL_ENTRY _ZTV10S9624C6_nt[];
static Base_Class bases_S9624C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S9624C5_nt[];
extern void _ZN10S9624C5_ntD1Ev();
extern void _ZN10S9624C5_ntD0Ev();
extern void _ZN10S9624C6_nt2v6Ev();
extern void _ZN10S9624C6_nt2v7Ev();
extern void _ZN10S9624C6_nt2v8Ev();
extern void _ZN10S9624C5_nt2v9Ev();
extern void _ZN10S9624C5_nt3v10Ev();
extern void _ZN10S9624C5_nt3v11Ev();
static  VTBL_ENTRY vtc_S9624C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9624C5_nt[0]),
  (VTBL_ENTRY)&_ZN10S9624C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9624C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S9624C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S9624C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S9624C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S9624C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S9624C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S9624C5_nt3v11Ev,
};
extern VTBL_ENTRY _ZTI10S9624C5_nt[];
VTBL_ENTRY *P__ZTI10S9624C5_nt = _ZTI10S9624C5_nt; 
extern  VTBL_ENTRY _ZTV10S9624C5_nt[];
Class_Descriptor cd_S9624C5_nt = {  "S9624C5_nt", // class name
  bases_S9624C5_nt, 1,
  &(vtc_S9624C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI10S9624C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S9624C5_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C11  {
  virtual  ~S9624C11(); // _ZN8S9624C11D1Ev
  virtual void  v12(); // _ZN8S9624C113v12Ev
  S9624C11(); // tgen
};
//SIG(-1 S9624C11) C1{ vd v1}


 S9624C11 ::~S9624C11(){ note_dtor("S9624C11", this);}
void  S9624C11 ::v12(){vfunc_called(this, "_ZN8S9624C113v12Ev");}
S9624C11 ::S9624C11(){ note_ctor("S9624C11", this);} // tgen

static void Test_S9624C11()
{
  extern Class_Descriptor cd_S9624C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9624C11, buf);
    S9624C11 *dp, &lv = *(dp=new (buf) S9624C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9624C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9624C11)");
    test_class_info(&lv, &cd_S9624C11);
    dp->~S9624C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9624C11(Test_S9624C11, "S9624C11", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9624C11C1Ev();
extern void _ZN8S9624C11D1Ev();
Name_Map name_map_S9624C11[] = {
  NSPAIR(_ZN8S9624C11C1Ev),
  NSPAIR(_ZN8S9624C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9624C11[];
extern void _ZN8S9624C11D1Ev();
extern void _ZN8S9624C11D0Ev();
extern void _ZN8S9624C113v12Ev();
static  VTBL_ENTRY vtc_S9624C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9624C11[0]),
  (VTBL_ENTRY)&_ZN8S9624C11D1Ev,
  (VTBL_ENTRY)&_ZN8S9624C11D0Ev,
  (VTBL_ENTRY)&_ZN8S9624C113v12Ev,
};
extern VTBL_ENTRY _ZTI8S9624C11[];
extern  VTBL_ENTRY _ZTV8S9624C11[];
Class_Descriptor cd_S9624C11 = {  "S9624C11", // class name
  0,0,//no base classes
  &(vtc_S9624C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9624C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9624C11),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C13_nt  {
  virtual  ~S9624C13_nt(); // _ZN11S9624C13_ntD1Ev
  virtual void  v14(); // _ZN11S9624C13_nt3v14Ev
  virtual void  v15(); // _ZN11S9624C13_nt3v15Ev
  S9624C13_nt(); // tgen
};
//SIG(-1 S9624C13_nt) C1{ vd v1 v2}


 S9624C13_nt ::~S9624C13_nt(){ note_dtor("S9624C13_nt", this);}
void  S9624C13_nt ::v14(){vfunc_called(this, "_ZN11S9624C13_nt3v14Ev");}
void  S9624C13_nt ::v15(){vfunc_called(this, "_ZN11S9624C13_nt3v15Ev");}
S9624C13_nt ::S9624C13_nt(){ note_ctor("S9624C13_nt", this);} // tgen

//skip512 S9624C13_nt

#else // __cplusplus

extern void _ZN11S9624C13_ntC1Ev();
extern void _ZN11S9624C13_ntD1Ev();
Name_Map name_map_S9624C13_nt[] = {
  NSPAIR(_ZN11S9624C13_ntC1Ev),
  NSPAIR(_ZN11S9624C13_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S9624C13_nt[];
extern void _ZN11S9624C13_ntD1Ev();
extern void _ZN11S9624C13_ntD0Ev();
extern void _ZN11S9624C13_nt3v14Ev();
extern void _ZN11S9624C13_nt3v15Ev();
static  VTBL_ENTRY vtc_S9624C13_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C13_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C13_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v15Ev,
};
extern VTBL_ENTRY _ZTI11S9624C13_nt[];
VTBL_ENTRY *P__ZTI11S9624C13_nt = _ZTI11S9624C13_nt; 
extern  VTBL_ENTRY _ZTV11S9624C13_nt[];
Class_Descriptor cd_S9624C13_nt = {  "S9624C13_nt", // class name
  0,0,//no base classes
  &(vtc_S9624C13_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S9624C13_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S9624C13_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C14_nt  {
  void *s9624c14f0;
  int s9624c14f1;
  ::S662C8_nt s9624c14f2;
  void  mf9624c14(); // _ZN11S9624C14_nt9mf9624c14Ev
};
//SIG(-1 S9624C14_nt) C1{ m Fp Fi FC2{ m}}


void  S9624C14_nt ::mf9624c14(){}

//skip512 S9624C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C12_nt  : S9624C13_nt {
  ::S9624C14_nt s9624c12f0;
  virtual  ~S9624C12_nt(); // _ZN11S9624C12_ntD1Ev
  virtual void  v13(); // _ZN11S9624C12_nt3v13Ev
  S9624C12_nt(); // tgen
};
//SIG(-1 S9624C12_nt) C1{ BC2{ vd v2 v3} vd v1 FC3{ m Fp Fi FC4{ m}}}


 S9624C12_nt ::~S9624C12_nt(){ note_dtor("S9624C12_nt", this);}
void  S9624C12_nt ::v13(){vfunc_called(this, "_ZN11S9624C12_nt3v13Ev");}
S9624C12_nt ::S9624C12_nt(){ note_ctor("S9624C12_nt", this);} // tgen

//skip512 S9624C12_nt

#else // __cplusplus

extern void _ZN11S9624C12_ntC1Ev();
extern void _ZN11S9624C12_ntD1Ev();
Name_Map name_map_S9624C12_nt[] = {
  NSPAIR(_ZN11S9624C12_ntC1Ev),
  NSPAIR(_ZN11S9624C12_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C13_nt;
extern VTBL_ENTRY _ZTI11S9624C13_nt[];
extern  VTBL_ENTRY _ZTV11S9624C13_nt[];
static Base_Class bases_S9624C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S9624C12_nt[];
extern void _ZN11S9624C12_ntD1Ev();
extern void _ZN11S9624C12_ntD0Ev();
extern void _ZN11S9624C13_nt3v14Ev();
extern void _ZN11S9624C13_nt3v15Ev();
extern void _ZN11S9624C12_nt3v13Ev();
static  VTBL_ENTRY vtc_S9624C12_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C12_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C12_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C12_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v15Ev,
  (VTBL_ENTRY)&_ZN11S9624C12_nt3v13Ev,
};
extern VTBL_ENTRY _ZTI11S9624C12_nt[];
VTBL_ENTRY *P__ZTI11S9624C12_nt = _ZTI11S9624C12_nt; 
extern  VTBL_ENTRY _ZTV11S9624C12_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C19_nt  {
  void  mf9624c19(); // _ZN11S9624C19_nt9mf9624c19Ev
};
//SIG(-1 S9624C19_nt) C1{ m}


void  S9624C19_nt ::mf9624c19(){}

//skip512 S9624C19_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S9624C19_nt[];
VTBL_ENTRY *P__ZTI11S9624C19_nt = _ZTI11S9624C19_nt; 
Class_Descriptor cd_S9624C19_nt = {  "S9624C19_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI11S9624C19_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C18  {
  void *s9624c18f0;
  int s9624c18f1[2];
  ::S9624C19_nt s9624c18f2;
  void  mf9624c18(); // _ZN8S9624C189mf9624c18Ev
};
//SIG(-1 S9624C18) C1{ m Fp Fi[2] FC2{ m}}


void  S9624C18 ::mf9624c18(){}

static void Test_S9624C18()
{
  {
    init_simple_test("S9624C18");
    S9624C18 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S9624C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9624C18)");
    check_field_offset(lv, s9624c18f0, 0, "S9624C18.s9624c18f0");
    check_field_offset(lv, s9624c18f1, ABISELECT(8,4), "S9624C18.s9624c18f1");
    check_field_offset(lv, s9624c18f2, ABISELECT(16,12), "S9624C18.s9624c18f2");
  }
}
static Arrange_To_Call_Me vS9624C18(Test_S9624C18, "S9624C18", ABISELECT(24,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S9624C18[];
VTBL_ENTRY *P__ZTI8S9624C18 = _ZTI8S9624C18; 
Class_Descriptor cd_S9624C18 = {  "S9624C18", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S9624C18),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C17_nt  : S9624C18 , S9624C13_nt {
  virtual  ~S9624C17_nt(); // _ZN11S9624C17_ntD1Ev
  virtual void  v17(); // _ZN11S9624C17_nt3v17Ev
  virtual void  v18(); // _ZN11S9624C17_nt3v18Ev
  S9624C17_nt(); // tgen
};
//SIG(-1 S9624C17_nt) C1{ BC2{ m Fp Fi[2] FC3{ m}} BC4{ vd v3 v4} vd v1 v2}


 S9624C17_nt ::~S9624C17_nt(){ note_dtor("S9624C17_nt", this);}
void  S9624C17_nt ::v17(){vfunc_called(this, "_ZN11S9624C17_nt3v17Ev");}
void  S9624C17_nt ::v18(){vfunc_called(this, "_ZN11S9624C17_nt3v18Ev");}
S9624C17_nt ::S9624C17_nt(){ note_ctor("S9624C17_nt", this);} // tgen

//skip512 S9624C17_nt

#else // __cplusplus

extern void _ZN11S9624C17_ntC1Ev();
extern void _ZN11S9624C17_ntD1Ev();
Name_Map name_map_S9624C17_nt[] = {
  NSPAIR(_ZN11S9624C17_ntC1Ev),
  NSPAIR(_ZN11S9624C17_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C18;
extern VTBL_ENTRY _ZTI8S9624C18[];
extern Class_Descriptor cd_S9624C13_nt;
extern VTBL_ENTRY _ZTI11S9624C13_nt[];
extern  VTBL_ENTRY _ZTV11S9624C13_nt[];
static Base_Class bases_S9624C17_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C18,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S9624C17_nt[];
extern void _ZN11S9624C17_ntD1Ev();
extern void _ZN11S9624C17_ntD0Ev();
extern void _ZN11S9624C13_nt3v14Ev();
extern void _ZN11S9624C13_nt3v15Ev();
extern void _ZN11S9624C17_nt3v17Ev();
extern void _ZN11S9624C17_nt3v18Ev();
static  VTBL_ENTRY vtc_S9624C17_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C17_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C17_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C17_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v15Ev,
  (VTBL_ENTRY)&_ZN11S9624C17_nt3v17Ev,
  (VTBL_ENTRY)&_ZN11S9624C17_nt3v18Ev,
};
extern VTBL_ENTRY _ZTI11S9624C17_nt[];
VTBL_ENTRY *P__ZTI11S9624C17_nt = _ZTI11S9624C17_nt; 
extern  VTBL_ENTRY _ZTV11S9624C17_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C21_nt  {
  short s9624c21f0[2];
  char s9624c21f1[6];
  short s9624c21f2[2];
  char s9624c21f3[6];
  ::S9624C14_nt s9624c21f4;
  virtual  ~S9624C21_nt(); // _ZN11S9624C21_ntD1Ev
  virtual void  v20(); // _ZN11S9624C21_nt3v20Ev
  S9624C21_nt(); // tgen
};
//SIG(-1 S9624C21_nt) C1{ vd v1 Fs[2] Fc[6] Fs[2] Fc[6] FC2{ m Fp Fi FC3{ m}}}


 S9624C21_nt ::~S9624C21_nt(){ note_dtor("S9624C21_nt", this);}
void  S9624C21_nt ::v20(){vfunc_called(this, "_ZN11S9624C21_nt3v20Ev");}
S9624C21_nt ::S9624C21_nt(){ note_ctor("S9624C21_nt", this);} // tgen

//skip512 S9624C21_nt

#else // __cplusplus

extern void _ZN11S9624C21_ntC1Ev();
extern void _ZN11S9624C21_ntD1Ev();
Name_Map name_map_S9624C21_nt[] = {
  NSPAIR(_ZN11S9624C21_ntC1Ev),
  NSPAIR(_ZN11S9624C21_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S9624C21_nt[];
extern void _ZN11S9624C21_ntD1Ev();
extern void _ZN11S9624C21_ntD0Ev();
extern void _ZN11S9624C21_nt3v20Ev();
static  VTBL_ENTRY vtc_S9624C21_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C21_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C21_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C21_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9624C21_nt3v20Ev,
};
extern VTBL_ENTRY _ZTI11S9624C21_nt[];
VTBL_ENTRY *P__ZTI11S9624C21_nt = _ZTI11S9624C21_nt; 
extern  VTBL_ENTRY _ZTV11S9624C21_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C24_nt  {
  int s9624c24f0;
  virtual  ~S9624C24_nt(); // _ZN11S9624C24_ntD1Ev
  virtual void  v21(); // _ZN11S9624C24_nt3v21Ev
  S9624C24_nt(); // tgen
};
//SIG(-1 S9624C24_nt) C1{ vd v1 Fi}


 S9624C24_nt ::~S9624C24_nt(){ note_dtor("S9624C24_nt", this);}
void  S9624C24_nt ::v21(){vfunc_called(this, "_ZN11S9624C24_nt3v21Ev");}
S9624C24_nt ::S9624C24_nt(){ note_ctor("S9624C24_nt", this);} // tgen

//skip512 S9624C24_nt

#else // __cplusplus

extern void _ZN11S9624C24_ntC1Ev();
extern void _ZN11S9624C24_ntD1Ev();
Name_Map name_map_S9624C24_nt[] = {
  NSPAIR(_ZN11S9624C24_ntC1Ev),
  NSPAIR(_ZN11S9624C24_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S9624C24_nt[];
extern void _ZN11S9624C24_ntD1Ev();
extern void _ZN11S9624C24_ntD0Ev();
extern void _ZN11S9624C24_nt3v21Ev();
static  VTBL_ENTRY vtc_S9624C24_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C24_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C24_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C24_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9624C24_nt3v21Ev,
};
extern VTBL_ENTRY _ZTI11S9624C24_nt[];
VTBL_ENTRY *P__ZTI11S9624C24_nt = _ZTI11S9624C24_nt; 
extern  VTBL_ENTRY _ZTV11S9624C24_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C20_nt  : S9624C13_nt {
  ::S9624C21_nt s9624c20f0;
  ::S9624C14_nt s9624c20f1;
  int s9624c20f2[2];
  ::S9624C24_nt s9624c20f3;
  int s9624c20f4[2];
  virtual  ~S9624C20_nt(); // _ZN11S9624C20_ntD1Ev
  virtual void  v19(); // _ZN11S9624C20_nt3v19Ev
  S9624C20_nt(); // tgen
};
//SIG(-1 S9624C20_nt) C1{ BC2{ vd v2 v3} vd v1 FC3{ vd v4 Fs[2] Fc[6] Fs[2] Fc[6] FC4{ m Fp Fi FC5{ m}}} FC4 Fi[2] FC6{ vd v5 Fi} Fi[2]}


 S9624C20_nt ::~S9624C20_nt(){ note_dtor("S9624C20_nt", this);}
void  S9624C20_nt ::v19(){vfunc_called(this, "_ZN11S9624C20_nt3v19Ev");}
S9624C20_nt ::S9624C20_nt(){ note_ctor("S9624C20_nt", this);} // tgen

//skip512 S9624C20_nt

#else // __cplusplus

extern void _ZN11S9624C20_ntC1Ev();
extern void _ZN11S9624C20_ntD1Ev();
Name_Map name_map_S9624C20_nt[] = {
  NSPAIR(_ZN11S9624C20_ntC1Ev),
  NSPAIR(_ZN11S9624C20_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C13_nt;
extern VTBL_ENTRY _ZTI11S9624C13_nt[];
extern  VTBL_ENTRY _ZTV11S9624C13_nt[];
static Base_Class bases_S9624C20_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S9624C20_nt[];
extern void _ZN11S9624C20_ntD1Ev();
extern void _ZN11S9624C20_ntD0Ev();
extern void _ZN11S9624C13_nt3v14Ev();
extern void _ZN11S9624C13_nt3v15Ev();
extern void _ZN11S9624C20_nt3v19Ev();
static  VTBL_ENTRY vtc_S9624C20_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C20_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C20_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C20_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v15Ev,
  (VTBL_ENTRY)&_ZN11S9624C20_nt3v19Ev,
};
extern VTBL_ENTRY _ZTI11S9624C20_nt[];
VTBL_ENTRY *P__ZTI11S9624C20_nt = _ZTI11S9624C20_nt; 
extern  VTBL_ENTRY _ZTV11S9624C20_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C26  : S9624C13_nt {
  __tsi64 s9624c26f0;
  virtual  ~S9624C26(); // _ZN8S9624C26D1Ev
  virtual void  v24(); // _ZN8S9624C263v24Ev
  virtual void  v25(); // _ZN8S9624C263v25Ev
  S9624C26(); // tgen
};
//SIG(-1 S9624C26) C1{ BC2{ vd v3 v4} vd v1 v2 FL}


 S9624C26 ::~S9624C26(){ note_dtor("S9624C26", this);}
void  S9624C26 ::v24(){vfunc_called(this, "_ZN8S9624C263v24Ev");}
void  S9624C26 ::v25(){vfunc_called(this, "_ZN8S9624C263v25Ev");}
S9624C26 ::S9624C26(){ note_ctor("S9624C26", this);} // tgen

static void Test_S9624C26()
{
  extern Class_Descriptor cd_S9624C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S9624C26, buf);
    S9624C26 *dp, &lv = *(dp=new (buf) S9624C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S9624C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9624C26)");
    check_base_class_offset(lv, (S9624C13_nt*), 0, "S9624C26");
    check_field_offset(lv, s9624c26f0, ABISELECT(8,4), "S9624C26.s9624c26f0");
    test_class_info(&lv, &cd_S9624C26);
    dp->~S9624C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9624C26(Test_S9624C26, "S9624C26", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN8S9624C26C1Ev();
extern void _ZN8S9624C26D1Ev();
Name_Map name_map_S9624C26[] = {
  NSPAIR(_ZN8S9624C26C1Ev),
  NSPAIR(_ZN8S9624C26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C13_nt;
extern VTBL_ENTRY _ZTI11S9624C13_nt[];
extern  VTBL_ENTRY _ZTV11S9624C13_nt[];
static Base_Class bases_S9624C26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9624C26[];
extern void _ZN8S9624C26D1Ev();
extern void _ZN8S9624C26D0Ev();
extern void _ZN11S9624C13_nt3v14Ev();
extern void _ZN11S9624C13_nt3v15Ev();
extern void _ZN8S9624C263v24Ev();
extern void _ZN8S9624C263v25Ev();
static  VTBL_ENTRY vtc_S9624C26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9624C26[0]),
  (VTBL_ENTRY)&_ZN8S9624C26D1Ev,
  (VTBL_ENTRY)&_ZN8S9624C26D0Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S9624C263v24Ev,
  (VTBL_ENTRY)&_ZN8S9624C263v25Ev,
};
extern VTBL_ENTRY _ZTI8S9624C26[];
extern  VTBL_ENTRY _ZTV8S9624C26[];
Class_Descriptor cd_S9624C26 = {  "S9624C26", // class name
  bases_S9624C26, 1,
  &(vtc_S9624C26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI8S9624C26),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9624C26),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C31_nt  {
  short s9624c31f0[6];
  int s9624c31f1[2];
  char s9624c31f2;
  short s9624c31f3;
  void  mf9624c31(); // _ZN11S9624C31_nt9mf9624c31Ev
};
//SIG(-1 S9624C31_nt) C1{ m Fs[6] Fi[2] Fc Fs}


void  S9624C31_nt ::mf9624c31(){}

//skip512 S9624C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C30_nt  {
  ::S9624C31_nt s9624c30f0;
  void  mf9624c30(); // _ZN11S9624C30_nt9mf9624c30Ev
  virtual  ~S9624C30_nt(); // _ZN11S9624C30_ntD1Ev
  S9624C30_nt(); // tgen
};
//SIG(-1 S9624C30_nt) C1{ vd m FC2{ m Fs[6] Fi[2] Fc Fs}}


void  S9624C30_nt ::mf9624c30(){}
 S9624C30_nt ::~S9624C30_nt(){ note_dtor("S9624C30_nt", this);}
S9624C30_nt ::S9624C30_nt(){ note_ctor("S9624C30_nt", this);} // tgen

//skip512 S9624C30_nt

#else // __cplusplus

extern void _ZN11S9624C30_ntC1Ev();
extern void _ZN11S9624C30_ntD1Ev();
Name_Map name_map_S9624C30_nt[] = {
  NSPAIR(_ZN11S9624C30_ntC1Ev),
  NSPAIR(_ZN11S9624C30_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S9624C30_nt[];
extern void _ZN11S9624C30_ntD1Ev();
extern void _ZN11S9624C30_ntD0Ev();
static  VTBL_ENTRY vtc_S9624C30_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C30_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C30_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C30_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S9624C30_nt[];
VTBL_ENTRY *P__ZTI11S9624C30_nt = _ZTI11S9624C30_nt; 
extern  VTBL_ENTRY _ZTV11S9624C30_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C25  : S9624C13_nt {
  int s9624c25f0[5];
  ::S9624C26 s9624c25f1;
  ::S9624C17_nt s9624c25f2;
  ::S9624C14_nt s9624c25f3;
  ::S9624C30_nt s9624c25f4;
  ::S9624C30_nt s9624c25f5;
  virtual  ~S9624C25(); // _ZN8S9624C25D1Ev
  virtual void  v22(); // _ZN8S9624C253v22Ev
  virtual void  v23(); // _ZN8S9624C253v23Ev
  S9624C25(); // tgen
};
//SIG(-1 S9624C25) C1{ BC2{ vd v3 v4} vd v1 v2 Fi[5] FC3{ BC2 vd v5 v6 FL} FC4{ BC5{ m Fp Fi[2] FC6{ m}} BC2 vd v7 v8} FC7{ m Fp Fi FC8{ m}} FC9{ vd m FC10{ m Fs[6] Fi[2] Fc Fs}} FC9}


 S9624C25 ::~S9624C25(){ note_dtor("S9624C25", this);}
void  S9624C25 ::v22(){vfunc_called(this, "_ZN8S9624C253v22Ev");}
void  S9624C25 ::v23(){vfunc_called(this, "_ZN8S9624C253v23Ev");}
S9624C25 ::S9624C25(){ note_ctor("S9624C25", this);} // tgen

static void Test_S9624C25()
{
  extern Class_Descriptor cd_S9624C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(21,32)];
    init_test(&cd_S9624C25, buf);
    S9624C25 *dp, &lv = *(dp=new (buf) S9624C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,124), "sizeof(S9624C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9624C25)");
    check_base_class_offset(lv, (S9624C13_nt*), 0, "S9624C25");
    check_field_offset(lv, s9624c25f0, ABISELECT(8,4), "S9624C25.s9624c25f0");
    check_field_offset(lv, s9624c25f1, ABISELECT(32,24), "S9624C25.s9624c25f1");
    check_field_offset(lv, s9624c25f2, ABISELECT(48,36), "S9624C25.s9624c25f2");
    check_field_offset(lv, s9624c25f3, ABISELECT(80,56), "S9624C25.s9624c25f3");
    check_field_offset(lv, s9624c25f4, ABISELECT(96,68), "S9624C25.s9624c25f4");
    check_field_offset(lv, s9624c25f5, ABISELECT(128,96), "S9624C25.s9624c25f5");
    test_class_info(&lv, &cd_S9624C25);
    dp->~S9624C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9624C25(Test_S9624C25, "S9624C25", ABISELECT(160,124));

#else // __cplusplus

extern void _ZN8S9624C25C1Ev();
extern void _ZN8S9624C25D1Ev();
Name_Map name_map_S9624C25[] = {
  NSPAIR(_ZN8S9624C25C1Ev),
  NSPAIR(_ZN8S9624C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C13_nt;
extern VTBL_ENTRY _ZTI11S9624C13_nt[];
extern  VTBL_ENTRY _ZTV11S9624C13_nt[];
static Base_Class bases_S9624C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9624C25[];
extern void _ZN8S9624C25D1Ev();
extern void _ZN8S9624C25D0Ev();
extern void _ZN11S9624C13_nt3v14Ev();
extern void _ZN11S9624C13_nt3v15Ev();
extern void _ZN8S9624C253v22Ev();
extern void _ZN8S9624C253v23Ev();
static  VTBL_ENTRY vtc_S9624C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9624C25[0]),
  (VTBL_ENTRY)&_ZN8S9624C25D1Ev,
  (VTBL_ENTRY)&_ZN8S9624C25D0Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S9624C253v22Ev,
  (VTBL_ENTRY)&_ZN8S9624C253v23Ev,
};
extern VTBL_ENTRY _ZTI8S9624C25[];
extern  VTBL_ENTRY _ZTV8S9624C25[];
Class_Descriptor cd_S9624C25 = {  "S9624C25", // class name
  bases_S9624C25, 1,
  &(vtc_S9624C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(160,124), // object size
  NSPAIRA(_ZTI8S9624C25),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9624C25),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C32_nt  {
  int s9624c32f0[2];
  short s9624c32f1[2];
  int s9624c32f2[3];
  ::S9624C14_nt s9624c32f3;
  virtual  ~S9624C32_nt(); // _ZN11S9624C32_ntD1Ev
  virtual void  v28(); // _ZN11S9624C32_nt3v28Ev
  S9624C32_nt(); // tgen
};
//SIG(-1 S9624C32_nt) C1{ vd v1 Fi[2] Fs[2] Fi[3] FC2{ m Fp Fi FC3{ m}}}


 S9624C32_nt ::~S9624C32_nt(){ note_dtor("S9624C32_nt", this);}
void  S9624C32_nt ::v28(){vfunc_called(this, "_ZN11S9624C32_nt3v28Ev");}
S9624C32_nt ::S9624C32_nt(){ note_ctor("S9624C32_nt", this);} // tgen

//skip512 S9624C32_nt

#else // __cplusplus

extern void _ZN11S9624C32_ntC1Ev();
extern void _ZN11S9624C32_ntD1Ev();
Name_Map name_map_S9624C32_nt[] = {
  NSPAIR(_ZN11S9624C32_ntC1Ev),
  NSPAIR(_ZN11S9624C32_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S9624C32_nt[];
extern void _ZN11S9624C32_ntD1Ev();
extern void _ZN11S9624C32_ntD0Ev();
extern void _ZN11S9624C32_nt3v28Ev();
static  VTBL_ENTRY vtc_S9624C32_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C32_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C32_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C32_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9624C32_nt3v28Ev,
};
extern VTBL_ENTRY _ZTI11S9624C32_nt[];
VTBL_ENTRY *P__ZTI11S9624C32_nt = _ZTI11S9624C32_nt; 
extern  VTBL_ENTRY _ZTV11S9624C32_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C33_nt  : S9624C13_nt {
  ::S9624C14_nt s9624c33f0;
  ::S9624C14_nt s9624c33f1;
  ::S9624C14_nt s9624c33f2;
  virtual  ~S9624C33_nt(); // _ZN11S9624C33_ntD1Ev
  virtual void  v29(); // _ZN11S9624C33_nt3v29Ev
  S9624C33_nt(); // tgen
};
//SIG(-1 S9624C33_nt) C1{ BC2{ vd v2 v3} vd v1 FC3{ m Fp Fi FC4{ m}} FC3 FC3}


 S9624C33_nt ::~S9624C33_nt(){ note_dtor("S9624C33_nt", this);}
void  S9624C33_nt ::v29(){vfunc_called(this, "_ZN11S9624C33_nt3v29Ev");}
S9624C33_nt ::S9624C33_nt(){ note_ctor("S9624C33_nt", this);} // tgen

//skip512 S9624C33_nt

#else // __cplusplus

extern void _ZN11S9624C33_ntC1Ev();
extern void _ZN11S9624C33_ntD1Ev();
Name_Map name_map_S9624C33_nt[] = {
  NSPAIR(_ZN11S9624C33_ntC1Ev),
  NSPAIR(_ZN11S9624C33_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C13_nt;
extern VTBL_ENTRY _ZTI11S9624C13_nt[];
extern  VTBL_ENTRY _ZTV11S9624C13_nt[];
static Base_Class bases_S9624C33_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S9624C33_nt[];
extern void _ZN11S9624C33_ntD1Ev();
extern void _ZN11S9624C33_ntD0Ev();
extern void _ZN11S9624C13_nt3v14Ev();
extern void _ZN11S9624C13_nt3v15Ev();
extern void _ZN11S9624C33_nt3v29Ev();
static  VTBL_ENTRY vtc_S9624C33_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C33_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C33_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C33_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v15Ev,
  (VTBL_ENTRY)&_ZN11S9624C33_nt3v29Ev,
};
extern VTBL_ENTRY _ZTI11S9624C33_nt[];
VTBL_ENTRY *P__ZTI11S9624C33_nt = _ZTI11S9624C33_nt; 
extern  VTBL_ENTRY _ZTV11S9624C33_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C35  {
  void *s9624c35f0;
  int s9624c35f1[2];
  ::S9624C19_nt s9624c35f2;
  void  mf9624c35(); // _ZN8S9624C359mf9624c35Ev
};
//SIG(-1 S9624C35) C1{ m Fp Fi[2] FC2{ m}}


void  S9624C35 ::mf9624c35(){}

static void Test_S9624C35()
{
  {
    init_simple_test("S9624C35");
    S9624C35 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S9624C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9624C35)");
    check_field_offset(lv, s9624c35f0, 0, "S9624C35.s9624c35f0");
    check_field_offset(lv, s9624c35f1, ABISELECT(8,4), "S9624C35.s9624c35f1");
    check_field_offset(lv, s9624c35f2, ABISELECT(16,12), "S9624C35.s9624c35f2");
  }
}
static Arrange_To_Call_Me vS9624C35(Test_S9624C35, "S9624C35", ABISELECT(24,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S9624C35[];
VTBL_ENTRY *P__ZTI8S9624C35 = _ZTI8S9624C35; 
Class_Descriptor cd_S9624C35 = {  "S9624C35", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S9624C35),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C34  : S9624C35 , S9624C13_nt {
  virtual  ~S9624C34(); // _ZN8S9624C34D1Ev
  virtual void  v30(); // _ZN8S9624C343v30Ev
  virtual void  v31(); // _ZN8S9624C343v31Ev
  S9624C34(); // tgen
};
//SIG(-1 S9624C34) C1{ BC2{ m Fp Fi[2] FC3{ m}} BC4{ vd v3 v4} vd v1 v2}


 S9624C34 ::~S9624C34(){ note_dtor("S9624C34", this);}
void  S9624C34 ::v30(){vfunc_called(this, "_ZN8S9624C343v30Ev");}
void  S9624C34 ::v31(){vfunc_called(this, "_ZN8S9624C343v31Ev");}
S9624C34 ::S9624C34(){ note_ctor("S9624C34", this);} // tgen

static void Test_S9624C34()
{
  extern Class_Descriptor cd_S9624C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S9624C34, buf);
    S9624C34 *dp, &lv = *(dp=new (buf) S9624C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S9624C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9624C34)");
    check_base_class_offset(lv, (S9624C35*), ABISELECT(8,4), "S9624C34");
    check_base_class_offset(lv, (S9624C13_nt*), 0, "S9624C34");
    test_class_info(&lv, &cd_S9624C34);
    dp->~S9624C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9624C34(Test_S9624C34, "S9624C34", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN8S9624C34C1Ev();
extern void _ZN8S9624C34D1Ev();
Name_Map name_map_S9624C34[] = {
  NSPAIR(_ZN8S9624C34C1Ev),
  NSPAIR(_ZN8S9624C34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C35;
extern VTBL_ENTRY _ZTI8S9624C35[];
extern Class_Descriptor cd_S9624C13_nt;
extern VTBL_ENTRY _ZTI11S9624C13_nt[];
extern  VTBL_ENTRY _ZTV11S9624C13_nt[];
static Base_Class bases_S9624C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C35,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9624C34[];
extern void _ZN8S9624C34D1Ev();
extern void _ZN8S9624C34D0Ev();
extern void _ZN11S9624C13_nt3v14Ev();
extern void _ZN11S9624C13_nt3v15Ev();
extern void _ZN8S9624C343v30Ev();
extern void _ZN8S9624C343v31Ev();
static  VTBL_ENTRY vtc_S9624C34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9624C34[0]),
  (VTBL_ENTRY)&_ZN8S9624C34D1Ev,
  (VTBL_ENTRY)&_ZN8S9624C34D0Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S9624C13_nt3v15Ev,
  (VTBL_ENTRY)&_ZN8S9624C343v30Ev,
  (VTBL_ENTRY)&_ZN8S9624C343v31Ev,
};
extern VTBL_ENTRY _ZTI8S9624C34[];
extern  VTBL_ENTRY _ZTV8S9624C34[];
Class_Descriptor cd_S9624C34 = {  "S9624C34", // class name
  bases_S9624C34, 2,
  &(vtc_S9624C34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S9624C34),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S9624C34),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C39  {
  void  mf9624c39(); // _ZN8S9624C399mf9624c39Ev
};
//SIG(-1 S9624C39) C1{ m}


void  S9624C39 ::mf9624c39(){}

static void Test_S9624C39()
{
  {
    init_simple_test("S9624C39");
    S9624C39 lv;
    check2(sizeof(lv), 1, "sizeof(S9624C39)");
    check2(__alignof__(lv), 1, "__alignof__(S9624C39)");
  }
}
static Arrange_To_Call_Me vS9624C39(Test_S9624C39, "S9624C39", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S9624C39[];
VTBL_ENTRY *P__ZTI8S9624C39 = _ZTI8S9624C39; 
Class_Descriptor cd_S9624C39 = {  "S9624C39", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S9624C39),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C38_nt  {
  void *s9624c38f0;
  int s9624c38f1;
  ::S9624C39 s9624c38f2;
  ::S9624C39 s9624c38f3;
  void  mf9624c38(); // _ZN11S9624C38_nt9mf9624c38Ev
};
//SIG(-1 S9624C38_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S9624C38_nt ::mf9624c38(){}

//skip512 S9624C38_nt

#else // __cplusplus

Class_Descriptor cd_S9624C38_nt = {  "S9624C38_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C37_nt  : S9624C38_nt {
};
//SIG(-1 S9624C37_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S9624C37_nt

#else // __cplusplus

extern Class_Descriptor cd_S9624C38_nt;
static Base_Class bases_S9624C37_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C38_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C43_nt  {
  void *s9624c43f0;
  ::S9624C37_nt s9624c43f1;
  void  mf9624c43(); // _ZN11S9624C43_nt9mf9624c43Ev
};
//SIG(-1 S9624C43_nt) C1{ m Fp FC2{ BC3{ m Fp Fi FC4{ m} FC4}}}


void  S9624C43_nt ::mf9624c43(){}

//skip512 S9624C43_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C4  : S9624C5_nt , S9624C11 {
  ::S9624C12_nt s9624c4f0;
  ::S9624C12_nt s9624c4f1;
  ::S9624C12_nt s9624c4f2;
  ::S9624C17_nt s9624c4f3;
  ::S9624C20_nt s9624c4f4;
  int s9624c4f5;
  ::S9624C25 s9624c4f6;
  char s9624c4f7;
  int s9624c4f8;
  ::S9624C14_nt s9624c4f9;
  char s9624c4f10;
  int s9624c4f11;
  ::S9624C32_nt s9624c4f12;
  ::S9624C32_nt s9624c4f13;
  ::S9624C26 s9624c4f14;
  int s9624c4f15;
  ::S9624C33_nt s9624c4f16;
  ::S9624C34 s9624c4f17;
  int s9624c4f18[3];
  char s9624c4f19[2];
  void *s9624c4f20;
  ::S9624C37_nt s9624c4f21;
  void *s9624c4f22;
  ::S9624C7_nt s9624c4f23;
  void *s9624c4f24;
  char s9624c4f25[2];
  int s9624c4f26;
  ::S9624C21_nt s9624c4f27;
  char s9624c4f28;
  ::S9624C43_nt s9624c4f29;
  virtual  ~S9624C4(); // _ZN7S9624C4D1Ev
  virtual void  v5(); // _ZN7S9624C42v5Ev
  S9624C4(); // tgen
};
//SIG(-1 S9624C4) C1{ BC2{ BC3{ vd v2 v3 v4} vd v5 v6 v7 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc} BC8{ vd v8} vd v1 FC9{ BC10{ vd v10 v11} vd v9 FC11{ m Fp Fi FC12{ m}}} FC9 FC9 FC13{ BC14{ m Fp Fi[2] FC15{ m}} BC10 vd v12 v13} FC16{ BC10 vd v14 FC17{ vd v15 Fs[2] Fc[6] Fs[2] Fc[6] FC11} FC11 Fi[2] FC18{ vd v16 Fi} Fi[2]} Fi FC19{ BC10 vd v17 v18 Fi[5] FC20{ BC10 vd v19 v20 FL} FC13 FC11 FC21{ vd m FC22{ m Fs[6] Fi[2] Fc Fs}} FC21} Fc Fi FC11 Fc Fi FC23{ vd v21 Fi[2] Fs[2] Fi[3] FC11} FC23 FC20 Fi FC24{ BC10 vd v22 FC11 FC11 FC11} FC25{ BC26{ m Fp Fi[2] FC15} BC10 vd v23 v24} Fi[3] Fc[2] Fp FC27{ BC28{ m Fp Fi FC29{ m} FC29}} Fp FC4 Fp Fc[2] Fi FC17 Fc FC30{ m Fp FC27}}


 S9624C4 ::~S9624C4(){ note_dtor("S9624C4", this);}
void  S9624C4 ::v5(){vfunc_called(this, "_ZN7S9624C42v5Ev");}
S9624C4 ::S9624C4(){ note_ctor("S9624C4", this);} // tgen

static void Test_S9624C4()
{
  extern Class_Descriptor cd_S9624C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,156)];
    init_test(&cd_S9624C4, buf);
    S9624C4 *dp, &lv = *(dp=new (buf) S9624C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,620), "sizeof(S9624C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9624C4)");
    check_base_class_offset(lv, (S9624C6_nt*)(S9624C5_nt*), 0, "S9624C4");
    check_base_class_offset(lv, (S9624C5_nt*), 0, "S9624C4");
    check_base_class_offset(lv, (S9624C11*), ABISELECT(72,40), "S9624C4");
    check_field_offset(lv, s9624c4f0, ABISELECT(80,44), "S9624C4.s9624c4f0");
    check_field_offset(lv, s9624c4f1, ABISELECT(104,60), "S9624C4.s9624c4f1");
    check_field_offset(lv, s9624c4f2, ABISELECT(128,76), "S9624C4.s9624c4f2");
    check_field_offset(lv, s9624c4f3, ABISELECT(152,92), "S9624C4.s9624c4f3");
    check_field_offset(lv, s9624c4f4, ABISELECT(184,112), "S9624C4.s9624c4f4");
    check_field_offset(lv, s9624c4f5, ABISELECT(288,188), "S9624C4.s9624c4f5");
    check_field_offset(lv, s9624c4f6, ABISELECT(296,192), "S9624C4.s9624c4f6");
    check_field_offset(lv, s9624c4f7, ABISELECT(456,316), "S9624C4.s9624c4f7");
    check_field_offset(lv, s9624c4f8, ABISELECT(460,320), "S9624C4.s9624c4f8");
    check_field_offset(lv, s9624c4f9, ABISELECT(464,324), "S9624C4.s9624c4f9");
    check_field_offset(lv, s9624c4f10, ABISELECT(480,336), "S9624C4.s9624c4f10");
    check_field_offset(lv, s9624c4f11, ABISELECT(484,340), "S9624C4.s9624c4f11");
    check_field_offset(lv, s9624c4f12, ABISELECT(488,344), "S9624C4.s9624c4f12");
    check_field_offset(lv, s9624c4f13, ABISELECT(536,384), "S9624C4.s9624c4f13");
    check_field_offset(lv, s9624c4f14, ABISELECT(584,424), "S9624C4.s9624c4f14");
    check_field_offset(lv, s9624c4f15, ABISELECT(600,436), "S9624C4.s9624c4f15");
    check_field_offset(lv, s9624c4f16, ABISELECT(608,440), "S9624C4.s9624c4f16");
    check_field_offset(lv, s9624c4f17, ABISELECT(664,480), "S9624C4.s9624c4f17");
    check_field_offset(lv, s9624c4f18, ABISELECT(696,500), "S9624C4.s9624c4f18");
    check_field_offset(lv, s9624c4f19, ABISELECT(708,512), "S9624C4.s9624c4f19");
    check_field_offset(lv, s9624c4f20, ABISELECT(712,516), "S9624C4.s9624c4f20");
    check_field_offset(lv, s9624c4f21, ABISELECT(720,520), "S9624C4.s9624c4f21");
    check_field_offset(lv, s9624c4f22, ABISELECT(736,532), "S9624C4.s9624c4f22");
    check_field_offset(lv, s9624c4f23, ABISELECT(744,536), "S9624C4.s9624c4f23");
    check_field_offset(lv, s9624c4f24, ABISELECT(768,552), "S9624C4.s9624c4f24");
    check_field_offset(lv, s9624c4f25, ABISELECT(776,556), "S9624C4.s9624c4f25");
    check_field_offset(lv, s9624c4f26, ABISELECT(780,560), "S9624C4.s9624c4f26");
    check_field_offset(lv, s9624c4f27, ABISELECT(784,564), "S9624C4.s9624c4f27");
    check_field_offset(lv, s9624c4f28, ABISELECT(832,600), "S9624C4.s9624c4f28");
    check_field_offset(lv, s9624c4f29, ABISELECT(840,604), "S9624C4.s9624c4f29");
    test_class_info(&lv, &cd_S9624C4);
    dp->~S9624C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9624C4(Test_S9624C4, "S9624C4", ABISELECT(864,620));

#else // __cplusplus

extern void _ZN7S9624C4C1Ev();
extern void _ZN7S9624C4D1Ev();
Name_Map name_map_S9624C4[] = {
  NSPAIR(_ZN7S9624C4C1Ev),
  NSPAIR(_ZN7S9624C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C6_nt;
extern VTBL_ENTRY _ZTI10S9624C6_nt[];
extern  VTBL_ENTRY _ZTV10S9624C6_nt[];
extern Class_Descriptor cd_S9624C5_nt;
extern VTBL_ENTRY _ZTI10S9624C5_nt[];
extern  VTBL_ENTRY _ZTV10S9624C5_nt[];
extern Class_Descriptor cd_S9624C11;
extern VTBL_ENTRY _ZTI8S9624C11[];
extern  VTBL_ENTRY _ZTV8S9624C11[];
static Base_Class bases_S9624C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S9624C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C11,    ABISELECT(72,40), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9624C4[];
extern void _ZN7S9624C4D1Ev();
extern void _ZN7S9624C4D0Ev();
extern void _ZN10S9624C6_nt2v6Ev();
extern void _ZN10S9624C6_nt2v7Ev();
extern void _ZN10S9624C6_nt2v8Ev();
extern void _ZN10S9624C5_nt2v9Ev();
extern void _ZN10S9624C5_nt3v10Ev();
extern void _ZN10S9624C5_nt3v11Ev();
extern void _ZN7S9624C42v5Ev();
extern void ABISELECT(_ZThn72_N7S9624C4D1Ev,_ZThn40_N7S9624C4D1Ev)();
extern void ABISELECT(_ZThn72_N7S9624C4D0Ev,_ZThn40_N7S9624C4D0Ev)();
extern void _ZN8S9624C113v12Ev();
static  VTBL_ENTRY vtc_S9624C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9624C4[0]),
  (VTBL_ENTRY)&_ZN7S9624C4D1Ev,
  (VTBL_ENTRY)&_ZN7S9624C4D0Ev,
  (VTBL_ENTRY)&_ZN10S9624C6_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S9624C6_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S9624C6_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S9624C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S9624C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S9624C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN7S9624C42v5Ev,
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI7S9624C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S9624C4D1Ev,_ZThn40_N7S9624C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S9624C4D0Ev,_ZThn40_N7S9624C4D0Ev),
  (VTBL_ENTRY)&_ZN8S9624C113v12Ev,
};
extern VTBL_ENTRY _ZTI7S9624C4[];
extern  VTBL_ENTRY _ZTV7S9624C4[];
Class_Descriptor cd_S9624C4 = {  "S9624C4", // class name
  bases_S9624C4, 3,
  &(vtc_S9624C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,620), // object size
  NSPAIRA(_ZTI7S9624C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9624C4),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C48  {
  void  mf9624c48(); // _ZN8S9624C489mf9624c48Ev
};
//SIG(-1 S9624C48) C1{ m}


void  S9624C48 ::mf9624c48(){}

static void Test_S9624C48()
{
  {
    init_simple_test("S9624C48");
    S9624C48 lv;
    check2(sizeof(lv), 1, "sizeof(S9624C48)");
    check2(__alignof__(lv), 1, "__alignof__(S9624C48)");
  }
}
static Arrange_To_Call_Me vS9624C48(Test_S9624C48, "S9624C48", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S9624C48[];
VTBL_ENTRY *P__ZTI8S9624C48 = _ZTI8S9624C48; 
Class_Descriptor cd_S9624C48 = {  "S9624C48", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S9624C48),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C47  {
  void *s9624c47f0;
  int s9624c47f1;
  ::S9624C48 s9624c47f2;
  ::S9624C48 s9624c47f3;
  void  mf9624c47(); // _ZN8S9624C479mf9624c47Ev
};
//SIG(-1 S9624C47) C1{ m Fp Fi FC2{ m} FC2}


void  S9624C47 ::mf9624c47(){}

static void Test_S9624C47()
{
  {
    init_simple_test("S9624C47");
    S9624C47 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S9624C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9624C47)");
    check_field_offset(lv, s9624c47f0, 0, "S9624C47.s9624c47f0");
    check_field_offset(lv, s9624c47f1, ABISELECT(8,4), "S9624C47.s9624c47f1");
    check_field_offset(lv, s9624c47f2, ABISELECT(12,8), "S9624C47.s9624c47f2");
    check_field_offset(lv, s9624c47f3, ABISELECT(13,9), "S9624C47.s9624c47f3");
  }
}
static Arrange_To_Call_Me vS9624C47(Test_S9624C47, "S9624C47", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C46_nt  {
  ::S9624C47 s9624c46f0;
  void  mf9624c46(); // _ZN11S9624C46_nt9mf9624c46Ev
};
//SIG(-1 S9624C46_nt) C1{ m FC2{ m Fp Fi FC3{ m} FC3}}


void  S9624C46_nt ::mf9624c46(){}

//skip512 S9624C46_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C45_nt  {
  ::S9624C46_nt s9624c45f0;
  void *s9624c45f1[3];
  char s9624c45f2;
  virtual  ~S9624C45_nt(); // _ZN11S9624C45_ntD1Ev
  virtual void  v33(); // _ZN11S9624C45_nt3v33Ev
  S9624C45_nt(); // tgen
};
//SIG(-1 S9624C45_nt) C1{ vd v1 FC2{ m FC3{ m Fp Fi FC4{ m} FC4}} Fp[3] Fc}


 S9624C45_nt ::~S9624C45_nt(){ note_dtor("S9624C45_nt", this);}
void  S9624C45_nt ::v33(){vfunc_called(this, "_ZN11S9624C45_nt3v33Ev");}
S9624C45_nt ::S9624C45_nt(){ note_ctor("S9624C45_nt", this);} // tgen

//skip512 S9624C45_nt

#else // __cplusplus

extern void _ZN11S9624C45_ntC1Ev();
extern void _ZN11S9624C45_ntD1Ev();
Name_Map name_map_S9624C45_nt[] = {
  NSPAIR(_ZN11S9624C45_ntC1Ev),
  NSPAIR(_ZN11S9624C45_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S9624C45_nt[];
extern void _ZN11S9624C45_ntD1Ev();
extern void _ZN11S9624C45_ntD0Ev();
extern void _ZN11S9624C45_nt3v33Ev();
static  VTBL_ENTRY vtc_S9624C45_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C45_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C45_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C45_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9624C45_nt3v33Ev,
};
extern VTBL_ENTRY _ZTI11S9624C45_nt[];
VTBL_ENTRY *P__ZTI11S9624C45_nt = _ZTI11S9624C45_nt; 
extern  VTBL_ENTRY _ZTV11S9624C45_nt[];
Class_Descriptor cd_S9624C45_nt = {  "S9624C45_nt", // class name
  0,0,//no base classes
  &(vtc_S9624C45_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI11S9624C45_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S9624C45_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C44_nt  : S9624C45_nt {
  void *s9624c44f0;
  virtual void  v32(); // _ZN11S9624C44_nt3v32Ev
  ~S9624C44_nt(); // tgen
  S9624C44_nt(); // tgen
};
//SIG(-1 S9624C44_nt) C1{ BC2{ vd v2 FC3{ m FC4{ m Fp Fi FC5{ m} FC5}} Fp[3] Fc} v1 Fp}


void  S9624C44_nt ::v32(){vfunc_called(this, "_ZN11S9624C44_nt3v32Ev");}
S9624C44_nt ::~S9624C44_nt(){ note_dtor("S9624C44_nt", this);} // tgen
S9624C44_nt ::S9624C44_nt(){ note_ctor("S9624C44_nt", this);} // tgen

//skip512 S9624C44_nt

#else // __cplusplus

extern void _ZN11S9624C44_ntC1Ev();
extern void _ZN11S9624C44_ntD1Ev();
Name_Map name_map_S9624C44_nt[] = {
  NSPAIR(_ZN11S9624C44_ntC1Ev),
  NSPAIR(_ZN11S9624C44_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C45_nt;
extern VTBL_ENTRY _ZTI11S9624C45_nt[];
extern  VTBL_ENTRY _ZTV11S9624C45_nt[];
static Base_Class bases_S9624C44_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C45_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S9624C44_nt[];
extern void _ZN11S9624C44_ntD1Ev();
extern void _ZN11S9624C44_ntD0Ev();
extern void _ZN11S9624C45_nt3v33Ev();
extern void _ZN11S9624C44_nt3v32Ev();
static  VTBL_ENTRY vtc_S9624C44_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S9624C44_nt[0]),
  (VTBL_ENTRY)&_ZN11S9624C44_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S9624C44_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S9624C45_nt3v33Ev,
  (VTBL_ENTRY)&_ZN11S9624C44_nt3v32Ev,
};
extern VTBL_ENTRY _ZTI11S9624C44_nt[];
VTBL_ENTRY *P__ZTI11S9624C44_nt = _ZTI11S9624C44_nt; 
extern  VTBL_ENTRY _ZTV11S9624C44_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9624C1  : S9624C2_nt , S9624C3 {
  ::S9624C4 s9624c1f0;
  ::S9624C44_nt s9624c1f1;
  void *s9624c1f2[2];
  int s9624c1f3;
  virtual  ~S9624C1(); // _ZN7S9624C1D1Ev
  virtual void  v1(); // _ZN7S9624C12v1Ev
  virtual void  v2(); // _ZN7S9624C12v2Ev
  S9624C1(); // tgen
};
//SIG(1 S9624C1) C1{ BC2{ vd v3} BC3{ vd v4} vd v1 v2 FC4{ BC5{ BC6{ vd v6 v7 v8} vd v9 v10 v11 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FC10{ Fl[4]}} Fc} BC11{ vd v12} vd v5 FC12{ BC13{ vd v14 v15} vd v13 FC14{ m Fp Fi FC15{ m}}} FC12 FC12 FC16{ BC17{ m Fp Fi[2] FC18{ m}} BC13 vd v16 v17} FC19{ BC13 vd v18 FC20{ vd v19 Fs[2] Fc[6] Fs[2] Fc[6] FC14} FC14 Fi[2] FC21{ vd v20 Fi} Fi[2]} Fi FC22{ BC13 vd v21 v22 Fi[5] FC23{ BC13 vd v23 v24 FL} FC16 FC14 FC24{ vd m FC25{ m Fs[6] Fi[2] Fc Fs}} FC24} Fc Fi FC14 Fc Fi FC26{ vd v25 Fi[2] Fs[2] Fi[3] FC14} FC26 FC23 Fi FC27{ BC13 vd v26 FC14 FC14 FC14} FC28{ BC29{ m Fp Fi[2] FC18} BC13 vd v27 v28} Fi[3] Fc[2] Fp FC30{ BC31{ m Fp Fi FC32{ m} FC32}} Fp FC7 Fp Fc[2] Fi FC20 Fc FC33{ m Fp FC30}} FC34{ BC35{ vd v30 FC36{ m FC37{ m Fp Fi FC38{ m} FC38}} Fp[3] Fc} v29 Fp} Fp[2] Fi}


 S9624C1 ::~S9624C1(){ note_dtor("S9624C1", this);}
void  S9624C1 ::v1(){vfunc_called(this, "_ZN7S9624C12v1Ev");}
void  S9624C1 ::v2(){vfunc_called(this, "_ZN7S9624C12v2Ev");}
S9624C1 ::S9624C1(){ note_ctor("S9624C1", this);} // tgen

static void Test_S9624C1()
{
  extern Class_Descriptor cd_S9624C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(122,170)];
    init_test(&cd_S9624C1, buf);
    S9624C1 *dp, &lv = *(dp=new (buf) S9624C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(968,676), "sizeof(S9624C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9624C1)");
    check_base_class_offset(lv, (S9624C2_nt*), 0, "S9624C1");
    check_base_class_offset(lv, (S9624C3*), ABISELECT(8,4), "S9624C1");
    check_field_offset(lv, s9624c1f0, ABISELECT(16,8), "S9624C1.s9624c1f0");
    check_field_offset(lv, s9624c1f1, ABISELECT(880,628), "S9624C1.s9624c1f1");
    check_field_offset(lv, s9624c1f2, ABISELECT(944,664), "S9624C1.s9624c1f2");
    check_field_offset(lv, s9624c1f3, ABISELECT(960,672), "S9624C1.s9624c1f3");
    test_class_info(&lv, &cd_S9624C1);
    dp->~S9624C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9624C1(Test_S9624C1, "S9624C1", ABISELECT(968,676));

#else // __cplusplus

extern void _ZN7S9624C1C1Ev();
extern void _ZN7S9624C1D1Ev();
Name_Map name_map_S9624C1[] = {
  NSPAIR(_ZN7S9624C1C1Ev),
  NSPAIR(_ZN7S9624C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C2_nt;
extern VTBL_ENTRY _ZTI10S9624C2_nt[];
extern  VTBL_ENTRY _ZTV10S9624C2_nt[];
extern Class_Descriptor cd_S9624C3;
extern VTBL_ENTRY _ZTI7S9624C3[];
extern  VTBL_ENTRY _ZTV7S9624C3[];
static Base_Class bases_S9624C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C3,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9624C1[];
extern void _ZN7S9624C1D1Ev();
extern void _ZN7S9624C1D0Ev();
extern void _ZN10S9624C2_nt2v3Ev();
extern void _ZN7S9624C12v1Ev();
extern void _ZN7S9624C12v2Ev();
extern void ABISELECT(_ZThn8_N7S9624C1D1Ev,_ZThn4_N7S9624C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9624C1D0Ev,_ZThn4_N7S9624C1D0Ev)();
extern void _ZN7S9624C32v4Ev();
static  VTBL_ENTRY vtc_S9624C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9624C1[0]),
  (VTBL_ENTRY)&_ZN7S9624C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9624C1D0Ev,
  (VTBL_ENTRY)&_ZN10S9624C2_nt2v3Ev,
  (VTBL_ENTRY)&_ZN7S9624C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9624C12v2Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9624C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9624C1D1Ev,_ZThn4_N7S9624C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9624C1D0Ev,_ZThn4_N7S9624C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9624C32v4Ev,
};
extern VTBL_ENTRY _ZTI7S9624C1[];
extern  VTBL_ENTRY _ZTV7S9624C1[];
Class_Descriptor cd_S9624C1 = {  "S9624C1", // class name
  bases_S9624C1, 2,
  &(vtc_S9624C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(968,676), // object size
  NSPAIRA(_ZTI7S9624C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9624C1),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C2  {
  virtual  ~S9625C2(); // _ZN7S9625C2D1Ev
  virtual void  v3(); // _ZN7S9625C22v3Ev
  S9625C2(); // tgen
};
//SIG(-1 S9625C2) C1{ vd v1}


 S9625C2 ::~S9625C2(){ note_dtor("S9625C2", this);}
void  S9625C2 ::v3(){vfunc_called(this, "_ZN7S9625C22v3Ev");}
S9625C2 ::S9625C2(){ note_ctor("S9625C2", this);} // tgen

static void Test_S9625C2()
{
  extern Class_Descriptor cd_S9625C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9625C2, buf);
    S9625C2 *dp, &lv = *(dp=new (buf) S9625C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9625C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9625C2)");
    test_class_info(&lv, &cd_S9625C2);
    dp->~S9625C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9625C2(Test_S9625C2, "S9625C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9625C2C1Ev();
extern void _ZN7S9625C2D1Ev();
Name_Map name_map_S9625C2[] = {
  NSPAIR(_ZN7S9625C2C1Ev),
  NSPAIR(_ZN7S9625C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9625C2[];
extern void _ZN7S9625C2D1Ev();
extern void _ZN7S9625C2D0Ev();
extern void _ZN7S9625C22v3Ev();
static  VTBL_ENTRY vtc_S9625C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9625C2[0]),
  (VTBL_ENTRY)&_ZN7S9625C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9625C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9625C22v3Ev,
};
extern VTBL_ENTRY _ZTI7S9625C2[];
extern  VTBL_ENTRY _ZTV7S9625C2[];
Class_Descriptor cd_S9625C2 = {  "S9625C2", // class name
  0,0,//no base classes
  &(vtc_S9625C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9625C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9625C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C3  {
  virtual  ~S9625C3(); // _ZN7S9625C3D1Ev
  virtual void  v4(); // _ZN7S9625C32v4Ev
  S9625C3(); // tgen
};
//SIG(-1 S9625C3) C1{ vd v1}


 S9625C3 ::~S9625C3(){ note_dtor("S9625C3", this);}
void  S9625C3 ::v4(){vfunc_called(this, "_ZN7S9625C32v4Ev");}
S9625C3 ::S9625C3(){ note_ctor("S9625C3", this);} // tgen

static void Test_S9625C3()
{
  extern Class_Descriptor cd_S9625C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9625C3, buf);
    S9625C3 *dp, &lv = *(dp=new (buf) S9625C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9625C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9625C3)");
    test_class_info(&lv, &cd_S9625C3);
    dp->~S9625C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9625C3(Test_S9625C3, "S9625C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9625C3C1Ev();
extern void _ZN7S9625C3D1Ev();
Name_Map name_map_S9625C3[] = {
  NSPAIR(_ZN7S9625C3C1Ev),
  NSPAIR(_ZN7S9625C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9625C3[];
extern void _ZN7S9625C3D1Ev();
extern void _ZN7S9625C3D0Ev();
extern void _ZN7S9625C32v4Ev();
static  VTBL_ENTRY vtc_S9625C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9625C3[0]),
  (VTBL_ENTRY)&_ZN7S9625C3D1Ev,
  (VTBL_ENTRY)&_ZN7S9625C3D0Ev,
  (VTBL_ENTRY)&_ZN7S9625C32v4Ev,
};
extern VTBL_ENTRY _ZTI7S9625C3[];
extern  VTBL_ENTRY _ZTV7S9625C3[];
Class_Descriptor cd_S9625C3 = {  "S9625C3", // class name
  0,0,//no base classes
  &(vtc_S9625C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9625C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9625C3),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C6  {
  virtual  ~S9625C6(); // _ZN7S9625C6D1Ev
  virtual void  v6(); // _ZN7S9625C62v6Ev
  virtual void  v7(); // _ZN7S9625C62v7Ev
  virtual void  v8(); // _ZN7S9625C62v8Ev
  S9625C6(); // tgen
};
//SIG(-1 S9625C6) C1{ vd v1 v2 v3}


 S9625C6 ::~S9625C6(){ note_dtor("S9625C6", this);}
void  S9625C6 ::v6(){vfunc_called(this, "_ZN7S9625C62v6Ev");}
void  S9625C6 ::v7(){vfunc_called(this, "_ZN7S9625C62v7Ev");}
void  S9625C6 ::v8(){vfunc_called(this, "_ZN7S9625C62v8Ev");}
S9625C6 ::S9625C6(){ note_ctor("S9625C6", this);} // tgen

static void Test_S9625C6()
{
  extern Class_Descriptor cd_S9625C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9625C6, buf);
    S9625C6 *dp, &lv = *(dp=new (buf) S9625C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9625C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9625C6)");
    test_class_info(&lv, &cd_S9625C6);
    dp->~S9625C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9625C6(Test_S9625C6, "S9625C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9625C6C1Ev();
extern void _ZN7S9625C6D1Ev();
Name_Map name_map_S9625C6[] = {
  NSPAIR(_ZN7S9625C6C1Ev),
  NSPAIR(_ZN7S9625C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9625C6[];
extern void _ZN7S9625C6D1Ev();
extern void _ZN7S9625C6D0Ev();
extern void _ZN7S9625C62v6Ev();
extern void _ZN7S9625C62v7Ev();
extern void _ZN7S9625C62v8Ev();
static  VTBL_ENTRY vtc_S9625C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9625C6[0]),
  (VTBL_ENTRY)&_ZN7S9625C6D1Ev,
  (VTBL_ENTRY)&_ZN7S9625C6D0Ev,
  (VTBL_ENTRY)&_ZN7S9625C62v6Ev,
  (VTBL_ENTRY)&_ZN7S9625C62v7Ev,
  (VTBL_ENTRY)&_ZN7S9625C62v8Ev,
};
extern VTBL_ENTRY _ZTI7S9625C6[];
extern  VTBL_ENTRY _ZTV7S9625C6[];
Class_Descriptor cd_S9625C6 = {  "S9625C6", // class name
  0,0,//no base classes
  &(vtc_S9625C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9625C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9625C6),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C10_nt  {
  __tsi64 s9625c10f0[4];
};
//SIG(-1 S9625C10_nt) C1{ FL[4]}



//skip512 S9625C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C9_nt  {
  ::S9625C10_nt s9625c9f0;
  void  mf9625c9(); // _ZN10S9625C9_nt8mf9625c9Ev
};
//SIG(-1 S9625C9_nt) C1{ m FC2{ FL[4]}}


void  S9625C9_nt ::mf9625c9(){}

//skip512 S9625C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C5_nt  : S9625C6 {
  ::S9624C35 s9625c5f0;
  ::S9625C9_nt s9625c5f1;
  char s9625c5f2;
  virtual  ~S9625C5_nt(); // _ZN10S9625C5_ntD1Ev
  virtual void  v9(); // _ZN10S9625C5_nt2v9Ev
  virtual void  v10(); // _ZN10S9625C5_nt3v10Ev
  virtual void  v11(); // _ZN10S9625C5_nt3v11Ev
  S9625C5_nt(); // tgen
};
//SIG(-1 S9625C5_nt) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ FL[4]}} Fc}


 S9625C5_nt ::~S9625C5_nt(){ note_dtor("S9625C5_nt", this);}
void  S9625C5_nt ::v9(){vfunc_called(this, "_ZN10S9625C5_nt2v9Ev");}
void  S9625C5_nt ::v10(){vfunc_called(this, "_ZN10S9625C5_nt3v10Ev");}
void  S9625C5_nt ::v11(){vfunc_called(this, "_ZN10S9625C5_nt3v11Ev");}
S9625C5_nt ::S9625C5_nt(){ note_ctor("S9625C5_nt", this);} // tgen

//skip512 S9625C5_nt

#else // __cplusplus

extern void _ZN10S9625C5_ntC1Ev();
extern void _ZN10S9625C5_ntD1Ev();
Name_Map name_map_S9625C5_nt[] = {
  NSPAIR(_ZN10S9625C5_ntC1Ev),
  NSPAIR(_ZN10S9625C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9625C6;
extern VTBL_ENTRY _ZTI7S9625C6[];
extern  VTBL_ENTRY _ZTV7S9625C6[];
static Base_Class bases_S9625C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9625C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S9625C5_nt[];
extern void _ZN10S9625C5_ntD1Ev();
extern void _ZN10S9625C5_ntD0Ev();
extern void _ZN7S9625C62v6Ev();
extern void _ZN7S9625C62v7Ev();
extern void _ZN7S9625C62v8Ev();
extern void _ZN10S9625C5_nt2v9Ev();
extern void _ZN10S9625C5_nt3v10Ev();
extern void _ZN10S9625C5_nt3v11Ev();
static  VTBL_ENTRY vtc_S9625C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9625C5_nt[0]),
  (VTBL_ENTRY)&_ZN10S9625C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9625C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S9625C62v6Ev,
  (VTBL_ENTRY)&_ZN7S9625C62v7Ev,
  (VTBL_ENTRY)&_ZN7S9625C62v8Ev,
  (VTBL_ENTRY)&_ZN10S9625C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S9625C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S9625C5_nt3v11Ev,
};
extern VTBL_ENTRY _ZTI10S9625C5_nt[];
VTBL_ENTRY *P__ZTI10S9625C5_nt = _ZTI10S9625C5_nt; 
extern  VTBL_ENTRY _ZTV10S9625C5_nt[];
Class_Descriptor cd_S9625C5_nt = {  "S9625C5_nt", // class name
  bases_S9625C5_nt, 1,
  &(vtc_S9625C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI10S9625C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S9625C5_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C11  {
  virtual  ~S9625C11(); // _ZN8S9625C11D1Ev
  virtual void  v12(); // _ZN8S9625C113v12Ev
  S9625C11(); // tgen
};
//SIG(-1 S9625C11) C1{ vd v1}


 S9625C11 ::~S9625C11(){ note_dtor("S9625C11", this);}
void  S9625C11 ::v12(){vfunc_called(this, "_ZN8S9625C113v12Ev");}
S9625C11 ::S9625C11(){ note_ctor("S9625C11", this);} // tgen

static void Test_S9625C11()
{
  extern Class_Descriptor cd_S9625C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9625C11, buf);
    S9625C11 *dp, &lv = *(dp=new (buf) S9625C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9625C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9625C11)");
    test_class_info(&lv, &cd_S9625C11);
    dp->~S9625C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9625C11(Test_S9625C11, "S9625C11", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9625C11C1Ev();
extern void _ZN8S9625C11D1Ev();
Name_Map name_map_S9625C11[] = {
  NSPAIR(_ZN8S9625C11C1Ev),
  NSPAIR(_ZN8S9625C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9625C11[];
extern void _ZN8S9625C11D1Ev();
extern void _ZN8S9625C11D0Ev();
extern void _ZN8S9625C113v12Ev();
static  VTBL_ENTRY vtc_S9625C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9625C11[0]),
  (VTBL_ENTRY)&_ZN8S9625C11D1Ev,
  (VTBL_ENTRY)&_ZN8S9625C11D0Ev,
  (VTBL_ENTRY)&_ZN8S9625C113v12Ev,
};
extern VTBL_ENTRY _ZTI8S9625C11[];
extern  VTBL_ENTRY _ZTV8S9625C11[];
Class_Descriptor cd_S9625C11 = {  "S9625C11", // class name
  0,0,//no base classes
  &(vtc_S9625C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9625C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9625C11),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C13  {
  virtual  ~S9625C13(); // _ZN8S9625C13D1Ev
  virtual void  v14(); // _ZN8S9625C133v14Ev
  virtual void  v15(); // _ZN8S9625C133v15Ev
  S9625C13(); // tgen
};
//SIG(-1 S9625C13) C1{ vd v1 v2}


 S9625C13 ::~S9625C13(){ note_dtor("S9625C13", this);}
void  S9625C13 ::v14(){vfunc_called(this, "_ZN8S9625C133v14Ev");}
void  S9625C13 ::v15(){vfunc_called(this, "_ZN8S9625C133v15Ev");}
S9625C13 ::S9625C13(){ note_ctor("S9625C13", this);} // tgen

static void Test_S9625C13()
{
  extern Class_Descriptor cd_S9625C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9625C13, buf);
    S9625C13 *dp, &lv = *(dp=new (buf) S9625C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9625C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9625C13)");
    test_class_info(&lv, &cd_S9625C13);
    dp->~S9625C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9625C13(Test_S9625C13, "S9625C13", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9625C13C1Ev();
extern void _ZN8S9625C13D1Ev();
Name_Map name_map_S9625C13[] = {
  NSPAIR(_ZN8S9625C13C1Ev),
  NSPAIR(_ZN8S9625C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9625C13[];
extern void _ZN8S9625C13D1Ev();
extern void _ZN8S9625C13D0Ev();
extern void _ZN8S9625C133v14Ev();
extern void _ZN8S9625C133v15Ev();
static  VTBL_ENTRY vtc_S9625C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9625C13[0]),
  (VTBL_ENTRY)&_ZN8S9625C13D1Ev,
  (VTBL_ENTRY)&_ZN8S9625C13D0Ev,
  (VTBL_ENTRY)&_ZN8S9625C133v14Ev,
  (VTBL_ENTRY)&_ZN8S9625C133v15Ev,
};
extern VTBL_ENTRY _ZTI8S9625C13[];
extern  VTBL_ENTRY _ZTV8S9625C13[];
Class_Descriptor cd_S9625C13 = {  "S9625C13", // class name
  0,0,//no base classes
  &(vtc_S9625C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9625C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9625C13),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C16  : S9625C13 {
  ::S9624C14_nt s9625c16f0;
  virtual  ~S9625C16(); // _ZN8S9625C16D1Ev
  virtual void  v16(); // _ZN8S9625C163v16Ev
  S9625C16(); // tgen
};
//SIG(-1 S9625C16) C1{ BC2{ vd v2 v3} vd v1 FC3{ m Fp Fi FC4{ m}}}


 S9625C16 ::~S9625C16(){ note_dtor("S9625C16", this);}
void  S9625C16 ::v16(){vfunc_called(this, "_ZN8S9625C163v16Ev");}
S9625C16 ::S9625C16(){ note_ctor("S9625C16", this);} // tgen

static void Test_S9625C16()
{
  extern Class_Descriptor cd_S9625C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S9625C16, buf);
    S9625C16 *dp, &lv = *(dp=new (buf) S9625C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S9625C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9625C16)");
    check_base_class_offset(lv, (S9625C13*), 0, "S9625C16");
    check_field_offset(lv, s9625c16f0, ABISELECT(8,4), "S9625C16.s9625c16f0");
    test_class_info(&lv, &cd_S9625C16);
    dp->~S9625C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9625C16(Test_S9625C16, "S9625C16", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S9625C16C1Ev();
extern void _ZN8S9625C16D1Ev();
Name_Map name_map_S9625C16[] = {
  NSPAIR(_ZN8S9625C16C1Ev),
  NSPAIR(_ZN8S9625C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9625C13;
extern VTBL_ENTRY _ZTI8S9625C13[];
extern  VTBL_ENTRY _ZTV8S9625C13[];
static Base_Class bases_S9625C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9625C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9625C16[];
extern void _ZN8S9625C16D1Ev();
extern void _ZN8S9625C16D0Ev();
extern void _ZN8S9625C133v14Ev();
extern void _ZN8S9625C133v15Ev();
extern void _ZN8S9625C163v16Ev();
static  VTBL_ENTRY vtc_S9625C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9625C16[0]),
  (VTBL_ENTRY)&_ZN8S9625C16D1Ev,
  (VTBL_ENTRY)&_ZN8S9625C16D0Ev,
  (VTBL_ENTRY)&_ZN8S9625C133v14Ev,
  (VTBL_ENTRY)&_ZN8S9625C133v15Ev,
  (VTBL_ENTRY)&_ZN8S9625C163v16Ev,
};
extern VTBL_ENTRY _ZTI8S9625C16[];
extern  VTBL_ENTRY _ZTV8S9625C16[];
Class_Descriptor cd_S9625C16 = {  "S9625C16", // class name
  bases_S9625C16, 1,
  &(vtc_S9625C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S9625C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9625C16),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C4  : S9625C5_nt , S9625C11 {
  ::S9624C12_nt s9625c4f0;
  ::S9624C12_nt s9625c4f1;
  ::S9625C16 s9625c4f2;
  ::S9624C34 s9625c4f3;
  ::S9624C20_nt s9625c4f4;
  int s9625c4f5;
  ::S9624C25 s9625c4f6;
  char s9625c4f7;
  int s9625c4f8;
  ::S9624C14_nt s9625c4f9;
  char s9625c4f10;
  int s9625c4f11;
  ::S9624C32_nt s9625c4f12;
  ::S9624C32_nt s9625c4f13;
  ::S9624C26 s9625c4f14;
  int s9625c4f15;
  ::S9624C33_nt s9625c4f16;
  ::S9624C17_nt s9625c4f17;
  int s9625c4f18[3];
  char s9625c4f19[2];
  void *s9625c4f20;
  ::S9624C37_nt s9625c4f21;
  void *s9625c4f22;
  ::S9624C18 s9625c4f23;
  void *s9625c4f24;
  char s9625c4f25[2];
  int s9625c4f26;
  ::S9624C21_nt s9625c4f27;
  char s9625c4f28;
  ::S9624C43_nt s9625c4f29;
  virtual  ~S9625C4(); // _ZN7S9625C4D1Ev
  virtual void  v5(); // _ZN7S9625C42v5Ev
  S9625C4(); // tgen
};
//SIG(-1 S9625C4) C1{ BC2{ BC3{ vd v2 v3 v4} vd v5 v6 v7 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc} BC8{ vd v8} vd v1 FC9{ BC10{ vd v10 v11} vd v9 FC11{ m Fp Fi FC12{ m}}} FC9 FC13{ BC14{ vd v13 v14} vd v12 FC11} FC15{ BC4 BC10 vd v15 v16} FC16{ BC10 vd v17 FC17{ vd v18 Fs[2] Fc[6] Fs[2] Fc[6] FC11} FC11 Fi[2] FC18{ vd v19 Fi} Fi[2]} Fi FC19{ BC10 vd v20 v21 Fi[5] FC20{ BC10 vd v22 v23 FL} FC21{ BC22{ m Fp Fi[2] FC5} BC10 vd v24 v25} FC11 FC23{ vd m FC24{ m Fs[6] Fi[2] Fc Fs}} FC23} Fc Fi FC11 Fc Fi FC25{ vd v26 Fi[2] Fs[2] Fi[3] FC11} FC25 FC20 Fi FC26{ BC10 vd v27 FC11 FC11 FC11} FC21 Fi[3] Fc[2] Fp FC27{ BC28{ m Fp Fi FC29{ m} FC29}} Fp FC22 Fp Fc[2] Fi FC17 Fc FC30{ m Fp FC27}}


 S9625C4 ::~S9625C4(){ note_dtor("S9625C4", this);}
void  S9625C4 ::v5(){vfunc_called(this, "_ZN7S9625C42v5Ev");}
S9625C4 ::S9625C4(){ note_ctor("S9625C4", this);} // tgen

static void Test_S9625C4()
{
  extern Class_Descriptor cd_S9625C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,160)];
    init_test(&cd_S9625C4, buf);
    S9625C4 *dp, &lv = *(dp=new (buf) S9625C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,636), "sizeof(S9625C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9625C4)");
    check_base_class_offset(lv, (S9625C6*)(S9625C5_nt*), 0, "S9625C4");
    check_base_class_offset(lv, (S9625C5_nt*), 0, "S9625C4");
    check_base_class_offset(lv, (S9625C11*), ABISELECT(72,56), "S9625C4");
    check_field_offset(lv, s9625c4f0, ABISELECT(80,60), "S9625C4.s9625c4f0");
    check_field_offset(lv, s9625c4f1, ABISELECT(104,76), "S9625C4.s9625c4f1");
    check_field_offset(lv, s9625c4f2, ABISELECT(128,92), "S9625C4.s9625c4f2");
    check_field_offset(lv, s9625c4f3, ABISELECT(152,108), "S9625C4.s9625c4f3");
    check_field_offset(lv, s9625c4f4, ABISELECT(184,128), "S9625C4.s9625c4f4");
    check_field_offset(lv, s9625c4f5, ABISELECT(288,204), "S9625C4.s9625c4f5");
    check_field_offset(lv, s9625c4f6, ABISELECT(296,208), "S9625C4.s9625c4f6");
    check_field_offset(lv, s9625c4f7, ABISELECT(456,332), "S9625C4.s9625c4f7");
    check_field_offset(lv, s9625c4f8, ABISELECT(460,336), "S9625C4.s9625c4f8");
    check_field_offset(lv, s9625c4f9, ABISELECT(464,340), "S9625C4.s9625c4f9");
    check_field_offset(lv, s9625c4f10, ABISELECT(480,352), "S9625C4.s9625c4f10");
    check_field_offset(lv, s9625c4f11, ABISELECT(484,356), "S9625C4.s9625c4f11");
    check_field_offset(lv, s9625c4f12, ABISELECT(488,360), "S9625C4.s9625c4f12");
    check_field_offset(lv, s9625c4f13, ABISELECT(536,400), "S9625C4.s9625c4f13");
    check_field_offset(lv, s9625c4f14, ABISELECT(584,440), "S9625C4.s9625c4f14");
    check_field_offset(lv, s9625c4f15, ABISELECT(600,452), "S9625C4.s9625c4f15");
    check_field_offset(lv, s9625c4f16, ABISELECT(608,456), "S9625C4.s9625c4f16");
    check_field_offset(lv, s9625c4f17, ABISELECT(664,496), "S9625C4.s9625c4f17");
    check_field_offset(lv, s9625c4f18, ABISELECT(696,516), "S9625C4.s9625c4f18");
    check_field_offset(lv, s9625c4f19, ABISELECT(708,528), "S9625C4.s9625c4f19");
    check_field_offset(lv, s9625c4f20, ABISELECT(712,532), "S9625C4.s9625c4f20");
    check_field_offset(lv, s9625c4f21, ABISELECT(720,536), "S9625C4.s9625c4f21");
    check_field_offset(lv, s9625c4f22, ABISELECT(736,548), "S9625C4.s9625c4f22");
    check_field_offset(lv, s9625c4f23, ABISELECT(744,552), "S9625C4.s9625c4f23");
    check_field_offset(lv, s9625c4f24, ABISELECT(768,568), "S9625C4.s9625c4f24");
    check_field_offset(lv, s9625c4f25, ABISELECT(776,572), "S9625C4.s9625c4f25");
    check_field_offset(lv, s9625c4f26, ABISELECT(780,576), "S9625C4.s9625c4f26");
    check_field_offset(lv, s9625c4f27, ABISELECT(784,580), "S9625C4.s9625c4f27");
    check_field_offset(lv, s9625c4f28, ABISELECT(832,616), "S9625C4.s9625c4f28");
    check_field_offset(lv, s9625c4f29, ABISELECT(840,620), "S9625C4.s9625c4f29");
    test_class_info(&lv, &cd_S9625C4);
    dp->~S9625C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9625C4(Test_S9625C4, "S9625C4", ABISELECT(864,636));

#else // __cplusplus

extern void _ZN7S9625C4C1Ev();
extern void _ZN7S9625C4D1Ev();
Name_Map name_map_S9625C4[] = {
  NSPAIR(_ZN7S9625C4C1Ev),
  NSPAIR(_ZN7S9625C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9625C6;
extern VTBL_ENTRY _ZTI7S9625C6[];
extern  VTBL_ENTRY _ZTV7S9625C6[];
extern Class_Descriptor cd_S9625C5_nt;
extern VTBL_ENTRY _ZTI10S9625C5_nt[];
extern  VTBL_ENTRY _ZTV10S9625C5_nt[];
extern Class_Descriptor cd_S9625C11;
extern VTBL_ENTRY _ZTI8S9625C11[];
extern  VTBL_ENTRY _ZTV8S9625C11[];
static Base_Class bases_S9625C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9625C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S9625C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9625C11,    ABISELECT(72,56), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9625C4[];
extern void _ZN7S9625C4D1Ev();
extern void _ZN7S9625C4D0Ev();
extern void _ZN7S9625C62v6Ev();
extern void _ZN7S9625C62v7Ev();
extern void _ZN7S9625C62v8Ev();
extern void _ZN10S9625C5_nt2v9Ev();
extern void _ZN10S9625C5_nt3v10Ev();
extern void _ZN10S9625C5_nt3v11Ev();
extern void _ZN7S9625C42v5Ev();
extern void ABISELECT(_ZThn72_N7S9625C4D1Ev,_ZThn56_N7S9625C4D1Ev)();
extern void ABISELECT(_ZThn72_N7S9625C4D0Ev,_ZThn56_N7S9625C4D0Ev)();
extern void _ZN8S9625C113v12Ev();
static  VTBL_ENTRY vtc_S9625C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9625C4[0]),
  (VTBL_ENTRY)&_ZN7S9625C4D1Ev,
  (VTBL_ENTRY)&_ZN7S9625C4D0Ev,
  (VTBL_ENTRY)&_ZN7S9625C62v6Ev,
  (VTBL_ENTRY)&_ZN7S9625C62v7Ev,
  (VTBL_ENTRY)&_ZN7S9625C62v8Ev,
  (VTBL_ENTRY)&_ZN10S9625C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S9625C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S9625C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN7S9625C42v5Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S9625C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S9625C4D1Ev,_ZThn56_N7S9625C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S9625C4D0Ev,_ZThn56_N7S9625C4D0Ev),
  (VTBL_ENTRY)&_ZN8S9625C113v12Ev,
};
extern VTBL_ENTRY _ZTI7S9625C4[];
extern  VTBL_ENTRY _ZTV7S9625C4[];
Class_Descriptor cd_S9625C4 = {  "S9625C4", // class name
  bases_S9625C4, 3,
  &(vtc_S9625C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,636), // object size
  NSPAIRA(_ZTI7S9625C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9625C4),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9625C1  : S9625C2 , S9625C3 {
  ::S9625C4 s9625c1f0;
  ::S9624C44_nt s9625c1f1;
  void *s9625c1f2[2];
  int s9625c1f3;
  virtual  ~S9625C1(); // _ZN7S9625C1D1Ev
  virtual void  v1(); // _ZN7S9625C12v1Ev
  virtual void  v2(); // _ZN7S9625C12v2Ev
  S9625C1(); // tgen
};
//SIG(1 S9625C1) C1{ BC2{ vd v3} BC3{ vd v4} vd v1 v2 FC4{ BC5{ BC6{ vd v6 v7 v8} vd v9 v10 v11 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FC10{ FL[4]}} Fc} BC11{ vd v12} vd v5 FC12{ BC13{ vd v14 v15} vd v13 FC14{ m Fp Fi FC15{ m}}} FC12 FC16{ BC17{ vd v17 v18} vd v16 FC14} FC18{ BC7 BC13 vd v19 v20} FC19{ BC13 vd v21 FC20{ vd v22 Fs[2] Fc[6] Fs[2] Fc[6] FC14} FC14 Fi[2] FC21{ vd v23 Fi} Fi[2]} Fi FC22{ BC13 vd v24 v25 Fi[5] FC23{ BC13 vd v26 v27 FL} FC24{ BC25{ m Fp Fi[2] FC8} BC13 vd v28 v29} FC14 FC26{ vd m FC27{ m Fs[6] Fi[2] Fc Fs}} FC26} Fc Fi FC14 Fc Fi FC28{ vd v30 Fi[2] Fs[2] Fi[3] FC14} FC28 FC23 Fi FC29{ BC13 vd v31 FC14 FC14 FC14} FC24 Fi[3] Fc[2] Fp FC30{ BC31{ m Fp Fi FC32{ m} FC32}} Fp FC25 Fp Fc[2] Fi FC20 Fc FC33{ m Fp FC30}} FC34{ BC35{ vd v33 FC36{ m FC37{ m Fp Fi FC38{ m} FC38}} Fp[3] Fc} v32 Fp} Fp[2] Fi}


 S9625C1 ::~S9625C1(){ note_dtor("S9625C1", this);}
void  S9625C1 ::v1(){vfunc_called(this, "_ZN7S9625C12v1Ev");}
void  S9625C1 ::v2(){vfunc_called(this, "_ZN7S9625C12v2Ev");}
S9625C1 ::S9625C1(){ note_ctor("S9625C1", this);} // tgen

static void Test_S9625C1()
{
  extern Class_Descriptor cd_S9625C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(122,174)];
    init_test(&cd_S9625C1, buf);
    S9625C1 *dp, &lv = *(dp=new (buf) S9625C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(968,692), "sizeof(S9625C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9625C1)");
    check_base_class_offset(lv, (S9625C2*), 0, "S9625C1");
    check_base_class_offset(lv, (S9625C3*), ABISELECT(8,4), "S9625C1");
    check_field_offset(lv, s9625c1f0, ABISELECT(16,8), "S9625C1.s9625c1f0");
    check_field_offset(lv, s9625c1f1, ABISELECT(880,644), "S9625C1.s9625c1f1");
    check_field_offset(lv, s9625c1f2, ABISELECT(944,680), "S9625C1.s9625c1f2");
    check_field_offset(lv, s9625c1f3, ABISELECT(960,688), "S9625C1.s9625c1f3");
    test_class_info(&lv, &cd_S9625C1);
    dp->~S9625C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9625C1(Test_S9625C1, "S9625C1", ABISELECT(968,692));

#else // __cplusplus

extern void _ZN7S9625C1C1Ev();
extern void _ZN7S9625C1D1Ev();
Name_Map name_map_S9625C1[] = {
  NSPAIR(_ZN7S9625C1C1Ev),
  NSPAIR(_ZN7S9625C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9625C2;
extern VTBL_ENTRY _ZTI7S9625C2[];
extern  VTBL_ENTRY _ZTV7S9625C2[];
extern Class_Descriptor cd_S9625C3;
extern VTBL_ENTRY _ZTI7S9625C3[];
extern  VTBL_ENTRY _ZTV7S9625C3[];
static Base_Class bases_S9625C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9625C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9625C3,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9625C1[];
extern void _ZN7S9625C1D1Ev();
extern void _ZN7S9625C1D0Ev();
extern void _ZN7S9625C22v3Ev();
extern void _ZN7S9625C12v1Ev();
extern void _ZN7S9625C12v2Ev();
extern void ABISELECT(_ZThn8_N7S9625C1D1Ev,_ZThn4_N7S9625C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9625C1D0Ev,_ZThn4_N7S9625C1D0Ev)();
extern void _ZN7S9625C32v4Ev();
static  VTBL_ENTRY vtc_S9625C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9625C1[0]),
  (VTBL_ENTRY)&_ZN7S9625C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9625C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9625C22v3Ev,
  (VTBL_ENTRY)&_ZN7S9625C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9625C12v2Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9625C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9625C1D1Ev,_ZThn4_N7S9625C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9625C1D0Ev,_ZThn4_N7S9625C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9625C32v4Ev,
};
extern VTBL_ENTRY _ZTI7S9625C1[];
extern  VTBL_ENTRY _ZTV7S9625C1[];
Class_Descriptor cd_S9625C1 = {  "S9625C1", // class name
  bases_S9625C1, 2,
  &(vtc_S9625C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(968,692), // object size
  NSPAIRA(_ZTI7S9625C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9625C1),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9626C2  {
  virtual  ~S9626C2(); // _ZN7S9626C2D1Ev
  virtual void  v3(); // _ZN7S9626C22v3Ev
  S9626C2(); // tgen
};
//SIG(-1 S9626C2) C1{ vd v1}


 S9626C2 ::~S9626C2(){ note_dtor("S9626C2", this);}
void  S9626C2 ::v3(){vfunc_called(this, "_ZN7S9626C22v3Ev");}
S9626C2 ::S9626C2(){ note_ctor("S9626C2", this);} // tgen

static void Test_S9626C2()
{
  extern Class_Descriptor cd_S9626C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9626C2, buf);
    S9626C2 *dp, &lv = *(dp=new (buf) S9626C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9626C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9626C2)");
    test_class_info(&lv, &cd_S9626C2);
    dp->~S9626C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9626C2(Test_S9626C2, "S9626C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9626C2C1Ev();
extern void _ZN7S9626C2D1Ev();
Name_Map name_map_S9626C2[] = {
  NSPAIR(_ZN7S9626C2C1Ev),
  NSPAIR(_ZN7S9626C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9626C2[];
extern void _ZN7S9626C2D1Ev();
extern void _ZN7S9626C2D0Ev();
extern void _ZN7S9626C22v3Ev();
static  VTBL_ENTRY vtc_S9626C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9626C2[0]),
  (VTBL_ENTRY)&_ZN7S9626C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9626C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9626C22v3Ev,
};
extern VTBL_ENTRY _ZTI7S9626C2[];
extern  VTBL_ENTRY _ZTV7S9626C2[];
Class_Descriptor cd_S9626C2 = {  "S9626C2", // class name
  0,0,//no base classes
  &(vtc_S9626C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9626C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9626C2),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9626C3  {
  virtual  ~S9626C3(); // _ZN7S9626C3D1Ev
  virtual void  v4(); // _ZN7S9626C32v4Ev
  S9626C3(); // tgen
};
//SIG(-1 S9626C3) C1{ vd v1}


 S9626C3 ::~S9626C3(){ note_dtor("S9626C3", this);}
void  S9626C3 ::v4(){vfunc_called(this, "_ZN7S9626C32v4Ev");}
S9626C3 ::S9626C3(){ note_ctor("S9626C3", this);} // tgen

static void Test_S9626C3()
{
  extern Class_Descriptor cd_S9626C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9626C3, buf);
    S9626C3 *dp, &lv = *(dp=new (buf) S9626C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9626C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9626C3)");
    test_class_info(&lv, &cd_S9626C3);
    dp->~S9626C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9626C3(Test_S9626C3, "S9626C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9626C3C1Ev();
extern void _ZN7S9626C3D1Ev();
Name_Map name_map_S9626C3[] = {
  NSPAIR(_ZN7S9626C3C1Ev),
  NSPAIR(_ZN7S9626C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9626C3[];
extern void _ZN7S9626C3D1Ev();
extern void _ZN7S9626C3D0Ev();
extern void _ZN7S9626C32v4Ev();
static  VTBL_ENTRY vtc_S9626C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9626C3[0]),
  (VTBL_ENTRY)&_ZN7S9626C3D1Ev,
  (VTBL_ENTRY)&_ZN7S9626C3D0Ev,
  (VTBL_ENTRY)&_ZN7S9626C32v4Ev,
};
extern VTBL_ENTRY _ZTI7S9626C3[];
extern  VTBL_ENTRY _ZTV7S9626C3[];
Class_Descriptor cd_S9626C3 = {  "S9626C3", // class name
  0,0,//no base classes
  &(vtc_S9626C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9626C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9626C3),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9626C6  {
  virtual  ~S9626C6(); // _ZN7S9626C6D1Ev
  virtual void  v6(); // _ZN7S9626C62v6Ev
  virtual void  v7(); // _ZN7S9626C62v7Ev
  virtual void  v8(); // _ZN7S9626C62v8Ev
  S9626C6(); // tgen
};
//SIG(-1 S9626C6) C1{ vd v1 v2 v3}


 S9626C6 ::~S9626C6(){ note_dtor("S9626C6", this);}
void  S9626C6 ::v6(){vfunc_called(this, "_ZN7S9626C62v6Ev");}
void  S9626C6 ::v7(){vfunc_called(this, "_ZN7S9626C62v7Ev");}
void  S9626C6 ::v8(){vfunc_called(this, "_ZN7S9626C62v8Ev");}
S9626C6 ::S9626C6(){ note_ctor("S9626C6", this);} // tgen

static void Test_S9626C6()
{
  extern Class_Descriptor cd_S9626C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9626C6, buf);
    S9626C6 *dp, &lv = *(dp=new (buf) S9626C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9626C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9626C6)");
    test_class_info(&lv, &cd_S9626C6);
    dp->~S9626C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9626C6(Test_S9626C6, "S9626C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9626C6C1Ev();
extern void _ZN7S9626C6D1Ev();
Name_Map name_map_S9626C6[] = {
  NSPAIR(_ZN7S9626C6C1Ev),
  NSPAIR(_ZN7S9626C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9626C6[];
extern void _ZN7S9626C6D1Ev();
extern void _ZN7S9626C6D0Ev();
extern void _ZN7S9626C62v6Ev();
extern void _ZN7S9626C62v7Ev();
extern void _ZN7S9626C62v8Ev();
static  VTBL_ENTRY vtc_S9626C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9626C6[0]),
  (VTBL_ENTRY)&_ZN7S9626C6D1Ev,
  (VTBL_ENTRY)&_ZN7S9626C6D0Ev,
  (VTBL_ENTRY)&_ZN7S9626C62v6Ev,
  (VTBL_ENTRY)&_ZN7S9626C62v7Ev,
  (VTBL_ENTRY)&_ZN7S9626C62v8Ev,
};
extern VTBL_ENTRY _ZTI7S9626C6[];
extern  VTBL_ENTRY _ZTV7S9626C6[];
Class_Descriptor cd_S9626C6 = {  "S9626C6", // class name
  0,0,//no base classes
  &(vtc_S9626C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9626C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9626C6),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9626C9_nt  {
  __tsi64 s9626c9f0[4];
  void  mf9626c9(); // _ZN10S9626C9_nt8mf9626c9Ev
};
//SIG(-1 S9626C9_nt) C1{ m FL[4]}


void  S9626C9_nt ::mf9626c9(){}

//skip512 S9626C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9626C5_nt  : S9626C6 {
  ::S9624C35 s9626c5f0;
  ::S9626C9_nt s9626c5f1;
  char s9626c5f2;
  virtual  ~S9626C5_nt(); // _ZN10S9626C5_ntD1Ev
  virtual void  v9(); // _ZN10S9626C5_nt2v9Ev
  virtual void  v10(); // _ZN10S9626C5_nt3v10Ev
  virtual void  v11(); // _ZN10S9626C5_nt3v11Ev
  S9626C5_nt(); // tgen
};
//SIG(-1 S9626C5_nt) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FL[4]} Fc}


 S9626C5_nt ::~S9626C5_nt(){ note_dtor("S9626C5_nt", this);}
void  S9626C5_nt ::v9(){vfunc_called(this, "_ZN10S9626C5_nt2v9Ev");}
void  S9626C5_nt ::v10(){vfunc_called(this, "_ZN10S9626C5_nt3v10Ev");}
void  S9626C5_nt ::v11(){vfunc_called(this, "_ZN10S9626C5_nt3v11Ev");}
S9626C5_nt ::S9626C5_nt(){ note_ctor("S9626C5_nt", this);} // tgen

//skip512 S9626C5_nt

#else // __cplusplus

extern void _ZN10S9626C5_ntC1Ev();
extern void _ZN10S9626C5_ntD1Ev();
Name_Map name_map_S9626C5_nt[] = {
  NSPAIR(_ZN10S9626C5_ntC1Ev),
  NSPAIR(_ZN10S9626C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9626C6;
extern VTBL_ENTRY _ZTI7S9626C6[];
extern  VTBL_ENTRY _ZTV7S9626C6[];
static Base_Class bases_S9626C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9626C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S9626C5_nt[];
extern void _ZN10S9626C5_ntD1Ev();
extern void _ZN10S9626C5_ntD0Ev();
extern void _ZN7S9626C62v6Ev();
extern void _ZN7S9626C62v7Ev();
extern void _ZN7S9626C62v8Ev();
extern void _ZN10S9626C5_nt2v9Ev();
extern void _ZN10S9626C5_nt3v10Ev();
extern void _ZN10S9626C5_nt3v11Ev();
static  VTBL_ENTRY vtc_S9626C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9626C5_nt[0]),
  (VTBL_ENTRY)&_ZN10S9626C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9626C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S9626C62v6Ev,
  (VTBL_ENTRY)&_ZN7S9626C62v7Ev,
  (VTBL_ENTRY)&_ZN7S9626C62v8Ev,
  (VTBL_ENTRY)&_ZN10S9626C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S9626C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S9626C5_nt3v11Ev,
};
extern VTBL_ENTRY _ZTI10S9626C5_nt[];
VTBL_ENTRY *P__ZTI10S9626C5_nt = _ZTI10S9626C5_nt; 
extern  VTBL_ENTRY _ZTV10S9626C5_nt[];
Class_Descriptor cd_S9626C5_nt = {  "S9626C5_nt", // class name
  bases_S9626C5_nt, 1,
  &(vtc_S9626C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI10S9626C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S9626C5_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9626C10  {
  virtual  ~S9626C10(); // _ZN8S9626C10D1Ev
  virtual void  v12(); // _ZN8S9626C103v12Ev
  S9626C10(); // tgen
};
//SIG(-1 S9626C10) C1{ vd v1}


 S9626C10 ::~S9626C10(){ note_dtor("S9626C10", this);}
void  S9626C10 ::v12(){vfunc_called(this, "_ZN8S9626C103v12Ev");}
S9626C10 ::S9626C10(){ note_ctor("S9626C10", this);} // tgen

static void Test_S9626C10()
{
  extern Class_Descriptor cd_S9626C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9626C10, buf);
    S9626C10 *dp, &lv = *(dp=new (buf) S9626C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9626C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9626C10)");
    test_class_info(&lv, &cd_S9626C10);
    dp->~S9626C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9626C10(Test_S9626C10, "S9626C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9626C10C1Ev();
extern void _ZN8S9626C10D1Ev();
Name_Map name_map_S9626C10[] = {
  NSPAIR(_ZN8S9626C10C1Ev),
  NSPAIR(_ZN8S9626C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9626C10[];
extern void _ZN8S9626C10D1Ev();
extern void _ZN8S9626C10D0Ev();
extern void _ZN8S9626C103v12Ev();
static  VTBL_ENTRY vtc_S9626C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9626C10[0]),
  (VTBL_ENTRY)&_ZN8S9626C10D1Ev,
  (VTBL_ENTRY)&_ZN8S9626C10D0Ev,
  (VTBL_ENTRY)&_ZN8S9626C103v12Ev,
};
extern VTBL_ENTRY _ZTI8S9626C10[];
extern  VTBL_ENTRY _ZTV8S9626C10[];
Class_Descriptor cd_S9626C10 = {  "S9626C10", // class name
  0,0,//no base classes
  &(vtc_S9626C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9626C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9626C10),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9626C4  : S9626C5_nt , S9626C10 {
  ::S9625C16 s9626c4f0;
  ::S9625C16 s9626c4f1;
  ::S9624C12_nt s9626c4f2;
  ::S9624C34 s9626c4f3;
  ::S9624C20_nt s9626c4f4;
  int s9626c4f5;
  ::S9624C25 s9626c4f6;
  char s9626c4f7;
  int s9626c4f8;
  ::S9624C14_nt s9626c4f9;
  char s9626c4f10;
  int s9626c4f11;
  ::S9624C32_nt s9626c4f12;
  ::S9624C32_nt s9626c4f13;
  ::S9624C26 s9626c4f14;
  int s9626c4f15;
  ::S9624C33_nt s9626c4f16;
  ::S9624C17_nt s9626c4f17;
  int s9626c4f18[3];
  char s9626c4f19[2];
  void *s9626c4f20;
  ::S9624C37_nt s9626c4f21;
  void *s9626c4f22;
  ::S9624C18 s9626c4f23;
  void *s9626c4f24;
  char s9626c4f25[2];
  int s9626c4f26;
  ::S9624C21_nt s9626c4f27;
  char s9626c4f28;
  ::S9624C43_nt s9626c4f29;
  virtual  ~S9626C4(); // _ZN7S9626C4D1Ev
  virtual void  v5(); // _ZN7S9626C42v5Ev
  S9626C4(); // tgen
};
//SIG(-1 S9626C4) C1{ BC2{ BC3{ vd v2 v3 v4} vd v5 v6 v7 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FL[4]} Fc} BC7{ vd v8} vd v1 FC8{ BC9{ vd v10 v11} vd v9 FC10{ m Fp Fi FC11{ m}}} FC8 FC12{ BC13{ vd v13 v14} vd v12 FC10} FC14{ BC4 BC13 vd v15 v16} FC15{ BC13 vd v17 FC16{ vd v18 Fs[2] Fc[6] Fs[2] Fc[6] FC10} FC10 Fi[2] FC17{ vd v19 Fi} Fi[2]} Fi FC18{ BC13 vd v20 v21 Fi[5] FC19{ BC13 vd v22 v23 FL} FC20{ BC21{ m Fp Fi[2] FC5} BC13 vd v24 v25} FC10 FC22{ vd m FC23{ m Fs[6] Fi[2] Fc Fs}} FC22} Fc Fi FC10 Fc Fi FC24{ vd v26 Fi[2] Fs[2] Fi[3] FC10} FC24 FC19 Fi FC25{ BC13 vd v27 FC10 FC10 FC10} FC20 Fi[3] Fc[2] Fp FC26{ BC27{ m Fp Fi FC28{ m} FC28}} Fp FC21 Fp Fc[2] Fi FC16 Fc FC29{ m Fp FC26}}


 S9626C4 ::~S9626C4(){ note_dtor("S9626C4", this);}
void  S9626C4 ::v5(){vfunc_called(this, "_ZN7S9626C42v5Ev");}
S9626C4 ::S9626C4(){ note_ctor("S9626C4", this);} // tgen

static void Test_S9626C4()
{
  extern Class_Descriptor cd_S9626C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(109,160)];
    init_test(&cd_S9626C4, buf);
    S9626C4 *dp, &lv = *(dp=new (buf) S9626C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(864,636), "sizeof(S9626C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9626C4)");
    check_base_class_offset(lv, (S9626C6*)(S9626C5_nt*), 0, "S9626C4");
    check_base_class_offset(lv, (S9626C5_nt*), 0, "S9626C4");
    check_base_class_offset(lv, (S9626C10*), ABISELECT(72,56), "S9626C4");
    check_field_offset(lv, s9626c4f0, ABISELECT(80,60), "S9626C4.s9626c4f0");
    check_field_offset(lv, s9626c4f1, ABISELECT(104,76), "S9626C4.s9626c4f1");
    check_field_offset(lv, s9626c4f2, ABISELECT(128,92), "S9626C4.s9626c4f2");
    check_field_offset(lv, s9626c4f3, ABISELECT(152,108), "S9626C4.s9626c4f3");
    check_field_offset(lv, s9626c4f4, ABISELECT(184,128), "S9626C4.s9626c4f4");
    check_field_offset(lv, s9626c4f5, ABISELECT(288,204), "S9626C4.s9626c4f5");
    check_field_offset(lv, s9626c4f6, ABISELECT(296,208), "S9626C4.s9626c4f6");
    check_field_offset(lv, s9626c4f7, ABISELECT(456,332), "S9626C4.s9626c4f7");
    check_field_offset(lv, s9626c4f8, ABISELECT(460,336), "S9626C4.s9626c4f8");
    check_field_offset(lv, s9626c4f9, ABISELECT(464,340), "S9626C4.s9626c4f9");
    check_field_offset(lv, s9626c4f10, ABISELECT(480,352), "S9626C4.s9626c4f10");
    check_field_offset(lv, s9626c4f11, ABISELECT(484,356), "S9626C4.s9626c4f11");
    check_field_offset(lv, s9626c4f12, ABISELECT(488,360), "S9626C4.s9626c4f12");
    check_field_offset(lv, s9626c4f13, ABISELECT(536,400), "S9626C4.s9626c4f13");
    check_field_offset(lv, s9626c4f14, ABISELECT(584,440), "S9626C4.s9626c4f14");
    check_field_offset(lv, s9626c4f15, ABISELECT(600,452), "S9626C4.s9626c4f15");
    check_field_offset(lv, s9626c4f16, ABISELECT(608,456), "S9626C4.s9626c4f16");
    check_field_offset(lv, s9626c4f17, ABISELECT(664,496), "S9626C4.s9626c4f17");
    check_field_offset(lv, s9626c4f18, ABISELECT(696,516), "S9626C4.s9626c4f18");
    check_field_offset(lv, s9626c4f19, ABISELECT(708,528), "S9626C4.s9626c4f19");
    check_field_offset(lv, s9626c4f20, ABISELECT(712,532), "S9626C4.s9626c4f20");
    check_field_offset(lv, s9626c4f21, ABISELECT(720,536), "S9626C4.s9626c4f21");
    check_field_offset(lv, s9626c4f22, ABISELECT(736,548), "S9626C4.s9626c4f22");
    check_field_offset(lv, s9626c4f23, ABISELECT(744,552), "S9626C4.s9626c4f23");
    check_field_offset(lv, s9626c4f24, ABISELECT(768,568), "S9626C4.s9626c4f24");
    check_field_offset(lv, s9626c4f25, ABISELECT(776,572), "S9626C4.s9626c4f25");
    check_field_offset(lv, s9626c4f26, ABISELECT(780,576), "S9626C4.s9626c4f26");
    check_field_offset(lv, s9626c4f27, ABISELECT(784,580), "S9626C4.s9626c4f27");
    check_field_offset(lv, s9626c4f28, ABISELECT(832,616), "S9626C4.s9626c4f28");
    check_field_offset(lv, s9626c4f29, ABISELECT(840,620), "S9626C4.s9626c4f29");
    test_class_info(&lv, &cd_S9626C4);
    dp->~S9626C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9626C4(Test_S9626C4, "S9626C4", ABISELECT(864,636));

#else // __cplusplus

extern void _ZN7S9626C4C1Ev();
extern void _ZN7S9626C4D1Ev();
Name_Map name_map_S9626C4[] = {
  NSPAIR(_ZN7S9626C4C1Ev),
  NSPAIR(_ZN7S9626C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9626C6;
extern VTBL_ENTRY _ZTI7S9626C6[];
extern  VTBL_ENTRY _ZTV7S9626C6[];
extern Class_Descriptor cd_S9626C5_nt;
extern VTBL_ENTRY _ZTI10S9626C5_nt[];
extern  VTBL_ENTRY _ZTV10S9626C5_nt[];
extern Class_Descriptor cd_S9626C10;
extern VTBL_ENTRY _ZTI8S9626C10[];
extern  VTBL_ENTRY _ZTV8S9626C10[];
static Base_Class bases_S9626C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9626C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S9626C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9626C10,    ABISELECT(72,56), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9626C4[];
extern void _ZN7S9626C4D1Ev();
extern void _ZN7S9626C4D0Ev();
extern void _ZN7S9626C62v6Ev();
extern void _ZN7S9626C62v7Ev();
extern void _ZN7S9626C62v8Ev();
extern void _ZN10S9626C5_nt2v9Ev();
extern void _ZN10S9626C5_nt3v10Ev();
extern void _ZN10S9626C5_nt3v11Ev();
extern void _ZN7S9626C42v5Ev();
extern void ABISELECT(_ZThn72_N7S9626C4D1Ev,_ZThn56_N7S9626C4D1Ev)();
extern void ABISELECT(_ZThn72_N7S9626C4D0Ev,_ZThn56_N7S9626C4D0Ev)();
extern void _ZN8S9626C103v12Ev();
static  VTBL_ENTRY vtc_S9626C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9626C4[0]),
  (VTBL_ENTRY)&_ZN7S9626C4D1Ev,
  (VTBL_ENTRY)&_ZN7S9626C4D0Ev,
  (VTBL_ENTRY)&_ZN7S9626C62v6Ev,
  (VTBL_ENTRY)&_ZN7S9626C62v7Ev,
  (VTBL_ENTRY)&_ZN7S9626C62v8Ev,
  (VTBL_ENTRY)&_ZN10S9626C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S9626C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S9626C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN7S9626C42v5Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S9626C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S9626C4D1Ev,_ZThn56_N7S9626C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S9626C4D0Ev,_ZThn56_N7S9626C4D0Ev),
  (VTBL_ENTRY)&_ZN8S9626C103v12Ev,
};
extern VTBL_ENTRY _ZTI7S9626C4[];
extern  VTBL_ENTRY _ZTV7S9626C4[];
Class_Descriptor cd_S9626C4 = {  "S9626C4", // class name
  bases_S9626C4, 3,
  &(vtc_S9626C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(864,636), // object size
  NSPAIRA(_ZTI7S9626C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9626C4),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9626C1  : S9626C2 , S9626C3 {
  ::S9626C4 s9626c1f0;
  ::S9624C44_nt s9626c1f1;
  void *s9626c1f2[2];
  int s9626c1f3;
  virtual  ~S9626C1(); // _ZN7S9626C1D1Ev
  virtual void  v1(); // _ZN7S9626C12v1Ev
  virtual void  v2(); // _ZN7S9626C12v2Ev
  S9626C1(); // tgen
};
//SIG(1 S9626C1) C1{ BC2{ vd v3} BC3{ vd v4} vd v1 v2 FC4{ BC5{ BC6{ vd v6 v7 v8} vd v9 v10 v11 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FL[4]} Fc} BC10{ vd v12} vd v5 FC11{ BC12{ vd v14 v15} vd v13 FC13{ m Fp Fi FC14{ m}}} FC11 FC15{ BC16{ vd v17 v18} vd v16 FC13} FC17{ BC7 BC16 vd v19 v20} FC18{ BC16 vd v21 FC19{ vd v22 Fs[2] Fc[6] Fs[2] Fc[6] FC13} FC13 Fi[2] FC20{ vd v23 Fi} Fi[2]} Fi FC21{ BC16 vd v24 v25 Fi[5] FC22{ BC16 vd v26 v27 FL} FC23{ BC24{ m Fp Fi[2] FC8} BC16 vd v28 v29} FC13 FC25{ vd m FC26{ m Fs[6] Fi[2] Fc Fs}} FC25} Fc Fi FC13 Fc Fi FC27{ vd v30 Fi[2] Fs[2] Fi[3] FC13} FC27 FC22 Fi FC28{ BC16 vd v31 FC13 FC13 FC13} FC23 Fi[3] Fc[2] Fp FC29{ BC30{ m Fp Fi FC31{ m} FC31}} Fp FC24 Fp Fc[2] Fi FC19 Fc FC32{ m Fp FC29}} FC33{ BC34{ vd v33 FC35{ m FC36{ m Fp Fi FC37{ m} FC37}} Fp[3] Fc} v32 Fp} Fp[2] Fi}


 S9626C1 ::~S9626C1(){ note_dtor("S9626C1", this);}
void  S9626C1 ::v1(){vfunc_called(this, "_ZN7S9626C12v1Ev");}
void  S9626C1 ::v2(){vfunc_called(this, "_ZN7S9626C12v2Ev");}
S9626C1 ::S9626C1(){ note_ctor("S9626C1", this);} // tgen

static void Test_S9626C1()
{
  extern Class_Descriptor cd_S9626C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(122,174)];
    init_test(&cd_S9626C1, buf);
    S9626C1 *dp, &lv = *(dp=new (buf) S9626C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(968,692), "sizeof(S9626C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9626C1)");
    check_base_class_offset(lv, (S9626C2*), 0, "S9626C1");
    check_base_class_offset(lv, (S9626C3*), ABISELECT(8,4), "S9626C1");
    check_field_offset(lv, s9626c1f0, ABISELECT(16,8), "S9626C1.s9626c1f0");
    check_field_offset(lv, s9626c1f1, ABISELECT(880,644), "S9626C1.s9626c1f1");
    check_field_offset(lv, s9626c1f2, ABISELECT(944,680), "S9626C1.s9626c1f2");
    check_field_offset(lv, s9626c1f3, ABISELECT(960,688), "S9626C1.s9626c1f3");
    test_class_info(&lv, &cd_S9626C1);
    dp->~S9626C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9626C1(Test_S9626C1, "S9626C1", ABISELECT(968,692));

#else // __cplusplus

extern void _ZN7S9626C1C1Ev();
extern void _ZN7S9626C1D1Ev();
Name_Map name_map_S9626C1[] = {
  NSPAIR(_ZN7S9626C1C1Ev),
  NSPAIR(_ZN7S9626C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9626C2;
extern VTBL_ENTRY _ZTI7S9626C2[];
extern  VTBL_ENTRY _ZTV7S9626C2[];
extern Class_Descriptor cd_S9626C3;
extern VTBL_ENTRY _ZTI7S9626C3[];
extern  VTBL_ENTRY _ZTV7S9626C3[];
static Base_Class bases_S9626C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9626C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9626C3,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9626C1[];
extern void _ZN7S9626C1D1Ev();
extern void _ZN7S9626C1D0Ev();
extern void _ZN7S9626C22v3Ev();
extern void _ZN7S9626C12v1Ev();
extern void _ZN7S9626C12v2Ev();
extern void ABISELECT(_ZThn8_N7S9626C1D1Ev,_ZThn4_N7S9626C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9626C1D0Ev,_ZThn4_N7S9626C1D0Ev)();
extern void _ZN7S9626C32v4Ev();
static  VTBL_ENTRY vtc_S9626C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9626C1[0]),
  (VTBL_ENTRY)&_ZN7S9626C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9626C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9626C22v3Ev,
  (VTBL_ENTRY)&_ZN7S9626C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9626C12v2Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9626C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9626C1D1Ev,_ZThn4_N7S9626C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9626C1D0Ev,_ZThn4_N7S9626C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9626C32v4Ev,
};
extern VTBL_ENTRY _ZTI7S9626C1[];
extern  VTBL_ENTRY _ZTV7S9626C1[];
Class_Descriptor cd_S9626C1 = {  "S9626C1", // class name
  bases_S9626C1, 2,
  &(vtc_S9626C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(968,692), // object size
  NSPAIRA(_ZTI7S9626C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9626C1),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C2_nt  {
  virtual  ~S10296C2_nt(); // _ZN11S10296C2_ntD1Ev
  virtual void  v9(); // _ZN11S10296C2_nt2v9Ev
  virtual void  v10(); // _ZN11S10296C2_nt3v10Ev
  virtual void  v11(); // _ZN11S10296C2_nt3v11Ev
  virtual void  v12(); // _ZN11S10296C2_nt3v12Ev
  virtual void  v13(); // _ZN11S10296C2_nt3v13Ev
  virtual void  v14(); // _ZN11S10296C2_nt3v14Ev
  virtual void  v15(); // _ZN11S10296C2_nt3v15Ev
  virtual void  v16(); // _ZN11S10296C2_nt3v16Ev
  virtual void  v17(); // _ZN11S10296C2_nt3v17Ev
  virtual void  v18(); // _ZN11S10296C2_nt3v18Ev
  S10296C2_nt(); // tgen
};
//SIG(-1 S10296C2_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10}


 S10296C2_nt ::~S10296C2_nt(){ note_dtor("S10296C2_nt", this);}
void  S10296C2_nt ::v9(){vfunc_called(this, "_ZN11S10296C2_nt2v9Ev");}
void  S10296C2_nt ::v10(){vfunc_called(this, "_ZN11S10296C2_nt3v10Ev");}
void  S10296C2_nt ::v11(){vfunc_called(this, "_ZN11S10296C2_nt3v11Ev");}
void  S10296C2_nt ::v12(){vfunc_called(this, "_ZN11S10296C2_nt3v12Ev");}
void  S10296C2_nt ::v13(){vfunc_called(this, "_ZN11S10296C2_nt3v13Ev");}
void  S10296C2_nt ::v14(){vfunc_called(this, "_ZN11S10296C2_nt3v14Ev");}
void  S10296C2_nt ::v15(){vfunc_called(this, "_ZN11S10296C2_nt3v15Ev");}
void  S10296C2_nt ::v16(){vfunc_called(this, "_ZN11S10296C2_nt3v16Ev");}
void  S10296C2_nt ::v17(){vfunc_called(this, "_ZN11S10296C2_nt3v17Ev");}
void  S10296C2_nt ::v18(){vfunc_called(this, "_ZN11S10296C2_nt3v18Ev");}
S10296C2_nt ::S10296C2_nt(){ note_ctor("S10296C2_nt", this);} // tgen

//skip512 S10296C2_nt

#else // __cplusplus

extern void _ZN11S10296C2_ntC1Ev();
extern void _ZN11S10296C2_ntD1Ev();
Name_Map name_map_S10296C2_nt[] = {
  NSPAIR(_ZN11S10296C2_ntC1Ev),
  NSPAIR(_ZN11S10296C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S10296C2_nt[];
extern void _ZN11S10296C2_ntD1Ev();
extern void _ZN11S10296C2_ntD0Ev();
extern void _ZN11S10296C2_nt2v9Ev();
extern void _ZN11S10296C2_nt3v10Ev();
extern void _ZN11S10296C2_nt3v11Ev();
extern void _ZN11S10296C2_nt3v12Ev();
extern void _ZN11S10296C2_nt3v13Ev();
extern void _ZN11S10296C2_nt3v14Ev();
extern void _ZN11S10296C2_nt3v15Ev();
extern void _ZN11S10296C2_nt3v16Ev();
extern void _ZN11S10296C2_nt3v17Ev();
extern void _ZN11S10296C2_nt3v18Ev();
static  VTBL_ENTRY vtc_S10296C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S10296C2_nt[0]),
  (VTBL_ENTRY)&_ZN11S10296C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v18Ev,
};
extern VTBL_ENTRY _ZTI11S10296C2_nt[];
VTBL_ENTRY *P__ZTI11S10296C2_nt = _ZTI11S10296C2_nt; 
extern  VTBL_ENTRY _ZTV11S10296C2_nt[];
Class_Descriptor cd_S10296C2_nt = {  "S10296C2_nt", // class name
  0,0,//no base classes
  &(vtc_S10296C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S10296C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S10296C2_nt),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C4_nt  {
  void *s10296c4f0[2];
  void  mf10296c4(); // _ZN11S10296C4_nt9mf10296c4Ev
};
//SIG(-1 S10296C4_nt) C1{ m Fp[2]}


void  S10296C4_nt ::mf10296c4(){}

//skip512 S10296C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C5_nt  {
  void *s10296c5f0;
  void  mf10296c5(); // _ZN11S10296C5_nt9mf10296c5Ev
};
//SIG(-1 S10296C5_nt) C1{ m Fp}


void  S10296C5_nt ::mf10296c5(){}

//skip512 S10296C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C3_nt  {
  ::S10296C4_nt s10296c3f0;
  ::S10296C5_nt s10296c3f1;
  void  mf10296c3(); // _ZN11S10296C3_nt9mf10296c3Ev
};
//SIG(-1 S10296C3_nt) C1{ m FC2{ m Fp[2]} FC3{ m Fp}}


void  S10296C3_nt ::mf10296c3(){}

//skip512 S10296C3_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C9  {
  void *s10296c9f0[2];
  void  mf10296c9(); // _ZN8S10296C99mf10296c9Ev
};
//SIG(-1 S10296C9) C1{ m Fp[2]}


void  S10296C9 ::mf10296c9(){}

static void Test_S10296C9()
{
  {
    init_simple_test("S10296C9");
    S10296C9 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10296C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10296C9)");
    check_field_offset(lv, s10296c9f0, 0, "S10296C9.s10296c9f0");
  }
}
static Arrange_To_Call_Me vS10296C9(Test_S10296C9, "S10296C9", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C7_nt  {
  ::S10296C4_nt s10296c7f0;
  ::S10296C9 s10296c7f1;
  void  mf10296c7(); // _ZN11S10296C7_nt9mf10296c7Ev
};
//SIG(-1 S10296C7_nt) C1{ m FC2{ m Fp[2]} FC3{ m Fp[2]}}


void  S10296C7_nt ::mf10296c7(){}

//skip512 S10296C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C6_nt  {
  ::S10296C7_nt s10296c6f0;
  ::S10296C7_nt s10296c6f1;
  void  mf10296c6(); // _ZN11S10296C6_nt9mf10296c6Ev
};
//SIG(-1 S10296C6_nt) C1{ m FC2{ m FC3{ m Fp[2]} FC4{ m Fp[2]}} FC2}


void  S10296C6_nt ::mf10296c6(){}

//skip512 S10296C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C14_nt  {
  void *s10296c14f0[4];
  void  mf10296c14(); // _ZN12S10296C14_nt10mf10296c14Ev
};
//SIG(-1 S10296C14_nt) C1{ m Fp[4]}


void  S10296C14_nt ::mf10296c14(){}

//skip512 S10296C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C13_nt  {
  ::S10296C14_nt s10296c13f0;
  virtual  ~S10296C13_nt(); // _ZN12S10296C13_ntD1Ev
  virtual void  v25(); // _ZN12S10296C13_nt3v25Ev
  virtual void  v26(); // _ZN12S10296C13_nt3v26Ev
  virtual void  v27(); // _ZN12S10296C13_nt3v27Ev
  virtual void  v28(); // _ZN12S10296C13_nt3v28Ev
  virtual void  v29(); // _ZN12S10296C13_nt3v29Ev
  virtual void  v30(); // _ZN12S10296C13_nt3v30Ev
  S10296C13_nt(); // tgen
};
//SIG(-1 S10296C13_nt) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S10296C13_nt ::~S10296C13_nt(){ note_dtor("S10296C13_nt", this);}
void  S10296C13_nt ::v25(){vfunc_called(this, "_ZN12S10296C13_nt3v25Ev");}
void  S10296C13_nt ::v26(){vfunc_called(this, "_ZN12S10296C13_nt3v26Ev");}
void  S10296C13_nt ::v27(){vfunc_called(this, "_ZN12S10296C13_nt3v27Ev");}
void  S10296C13_nt ::v28(){vfunc_called(this, "_ZN12S10296C13_nt3v28Ev");}
void  S10296C13_nt ::v29(){vfunc_called(this, "_ZN12S10296C13_nt3v29Ev");}
void  S10296C13_nt ::v30(){vfunc_called(this, "_ZN12S10296C13_nt3v30Ev");}
S10296C13_nt ::S10296C13_nt(){ note_ctor("S10296C13_nt", this);} // tgen

//skip512 S10296C13_nt

#else // __cplusplus

extern void _ZN12S10296C13_ntC1Ev();
extern void _ZN12S10296C13_ntD1Ev();
Name_Map name_map_S10296C13_nt[] = {
  NSPAIR(_ZN12S10296C13_ntC1Ev),
  NSPAIR(_ZN12S10296C13_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI12S10296C13_nt[];
extern void _ZN12S10296C13_ntD1Ev();
extern void _ZN12S10296C13_ntD0Ev();
extern void _ZN12S10296C13_nt3v25Ev();
extern void _ZN12S10296C13_nt3v26Ev();
extern void _ZN12S10296C13_nt3v27Ev();
extern void _ZN12S10296C13_nt3v28Ev();
extern void _ZN12S10296C13_nt3v29Ev();
extern void _ZN12S10296C13_nt3v30Ev();
static  VTBL_ENTRY vtc_S10296C13_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10296C13_nt[0]),
  (VTBL_ENTRY)&_ZN12S10296C13_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v25Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v26Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v27Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v28Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v29Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v30Ev,
};
extern VTBL_ENTRY _ZTI12S10296C13_nt[];
VTBL_ENTRY *P__ZTI12S10296C13_nt = _ZTI12S10296C13_nt; 
extern  VTBL_ENTRY _ZTV12S10296C13_nt[];
Class_Descriptor cd_S10296C13_nt = {  "S10296C13_nt", // class name
  0,0,//no base classes
  &(vtc_S10296C13_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI12S10296C13_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV12S10296C13_nt),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C15_nt  {
};
//SIG(-1 S10296C15_nt) C1{}



//skip512 S10296C15_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S10296C15_nt[];
VTBL_ENTRY *P__ZTI12S10296C15_nt = _ZTI12S10296C15_nt; 
Class_Descriptor cd_S10296C15_nt = {  "S10296C15_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI12S10296C15_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C17_nt  {
  void *s10296c17f0;
  int s10296c17f1;
  void *s10296c17f2;
  int s10296c17f3[2];
  void  mf10296c17(); // _ZN12S10296C17_nt10mf10296c17Ev
};
//SIG(-1 S10296C17_nt) C1{ m Fp Fi Fp Fi[2]}


void  S10296C17_nt ::mf10296c17(){}

//skip512 S10296C17_nt

#else // __cplusplus

Class_Descriptor cd_S10296C17_nt = {  "S10296C17_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C20_nt  {
  __tsi64 s10296c20f0[2];
  void  mf10296c20(); // _ZN12S10296C20_nt10mf10296c20Ev
};
//SIG(-1 S10296C20_nt) C1{ m FL[2]}


void  S10296C20_nt ::mf10296c20(){}

//skip512 S10296C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C19_nt  {
  ::S10296C20_nt s10296c19f0;
  void  mf10296c19(); // _ZN12S10296C19_nt10mf10296c19Ev
};
//SIG(-1 S10296C19_nt) C1{ m FC2{ m FL[2]}}


void  S10296C19_nt ::mf10296c19(){}

//skip512 S10296C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C18_nt  {
  ::S10296C19_nt s10296c18f0;
  ::S10296C19_nt s10296c18f1;
  ::S10296C19_nt s10296c18f2;
  ::S10296C19_nt s10296c18f3;
  void  mf10296c18(); // _ZN12S10296C18_nt10mf10296c18Ev
};
//SIG(-1 S10296C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S10296C18_nt ::mf10296c18(){}

//skip512 S10296C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C16_nt  : S10296C17_nt {
  ::S10296C18_nt s10296c16f0;
};
//SIG(-1 S10296C16_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FC5{ m FL[2]}} FC4 FC4 FC4}}



//skip512 S10296C16_nt

#else // __cplusplus

extern Class_Descriptor cd_S10296C17_nt;
static Base_Class bases_S10296C16_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C21_nt  : S10296C17_nt {
  ::S10296C19_nt s10296c21f0;
};
//SIG(-1 S10296C21_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FL[2]}}}



//skip512 S10296C21_nt

#else // __cplusplus

extern Class_Descriptor cd_S10296C17_nt;
static Base_Class bases_S10296C21_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C12_nt  : S10296C13_nt , S10296C15_nt {
  ::S10296C16_nt s10296c12f0;
  ::S10296C21_nt s10296c12f1;
  virtual void  v19(); // _ZN12S10296C12_nt3v19Ev
  virtual void  v20(); // _ZN12S10296C12_nt3v20Ev
  virtual void  v21(); // _ZN12S10296C12_nt3v21Ev
  virtual void  v22(); // _ZN12S10296C12_nt3v22Ev
  virtual void  v23(); // _ZN12S10296C12_nt3v23Ev
  virtual void  v24(); // _ZN12S10296C12_nt3v24Ev
  ~S10296C12_nt(); // tgen
  S10296C12_nt(); // tgen
};
//SIG(-1 S10296C12_nt) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC8}}


void  S10296C12_nt ::v19(){vfunc_called(this, "_ZN12S10296C12_nt3v19Ev");}
void  S10296C12_nt ::v20(){vfunc_called(this, "_ZN12S10296C12_nt3v20Ev");}
void  S10296C12_nt ::v21(){vfunc_called(this, "_ZN12S10296C12_nt3v21Ev");}
void  S10296C12_nt ::v22(){vfunc_called(this, "_ZN12S10296C12_nt3v22Ev");}
void  S10296C12_nt ::v23(){vfunc_called(this, "_ZN12S10296C12_nt3v23Ev");}
void  S10296C12_nt ::v24(){vfunc_called(this, "_ZN12S10296C12_nt3v24Ev");}
S10296C12_nt ::~S10296C12_nt(){ note_dtor("S10296C12_nt", this);} // tgen
S10296C12_nt ::S10296C12_nt(){ note_ctor("S10296C12_nt", this);} // tgen

//skip512 S10296C12_nt

#else // __cplusplus

extern void _ZN12S10296C12_ntC1Ev();
extern void _ZN12S10296C12_ntD1Ev();
Name_Map name_map_S10296C12_nt[] = {
  NSPAIR(_ZN12S10296C12_ntC1Ev),
  NSPAIR(_ZN12S10296C12_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10296C13_nt;
extern VTBL_ENTRY _ZTI12S10296C13_nt[];
extern  VTBL_ENTRY _ZTV12S10296C13_nt[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S10296C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S10296C12_nt[];
extern void _ZN12S10296C12_ntD1Ev();
extern void _ZN12S10296C12_ntD0Ev();
extern void _ZN12S10296C13_nt3v25Ev();
extern void _ZN12S10296C13_nt3v26Ev();
extern void _ZN12S10296C13_nt3v27Ev();
extern void _ZN12S10296C13_nt3v28Ev();
extern void _ZN12S10296C13_nt3v29Ev();
extern void _ZN12S10296C13_nt3v30Ev();
extern void _ZN12S10296C12_nt3v19Ev();
extern void _ZN12S10296C12_nt3v20Ev();
extern void _ZN12S10296C12_nt3v21Ev();
extern void _ZN12S10296C12_nt3v22Ev();
extern void _ZN12S10296C12_nt3v23Ev();
extern void _ZN12S10296C12_nt3v24Ev();
static  VTBL_ENTRY vtc_S10296C12_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10296C12_nt[0]),
  (VTBL_ENTRY)&_ZN12S10296C12_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10296C12_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v25Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v26Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v27Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v28Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v29Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v30Ev,
  (VTBL_ENTRY)&_ZN12S10296C12_nt3v19Ev,
  (VTBL_ENTRY)&_ZN12S10296C12_nt3v20Ev,
  (VTBL_ENTRY)&_ZN12S10296C12_nt3v21Ev,
  (VTBL_ENTRY)&_ZN12S10296C12_nt3v22Ev,
  (VTBL_ENTRY)&_ZN12S10296C12_nt3v23Ev,
  (VTBL_ENTRY)&_ZN12S10296C12_nt3v24Ev,
};
extern VTBL_ENTRY _ZTI12S10296C12_nt[];
VTBL_ENTRY *P__ZTI12S10296C12_nt = _ZTI12S10296C12_nt; 
extern  VTBL_ENTRY _ZTV12S10296C12_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C24  {
  virtual  ~S10296C24(); // _ZN9S10296C24D1Ev
  virtual void  v31(); // _ZN9S10296C243v31Ev
  S10296C24(); // tgen
};
//SIG(-1 S10296C24) C1{ vd v1}


 S10296C24 ::~S10296C24(){ note_dtor("S10296C24", this);}
void  S10296C24 ::v31(){vfunc_called(this, "_ZN9S10296C243v31Ev");}
S10296C24 ::S10296C24(){ note_ctor("S10296C24", this);} // tgen

static void Test_S10296C24()
{
  extern Class_Descriptor cd_S10296C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10296C24, buf);
    S10296C24 *dp, &lv = *(dp=new (buf) S10296C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10296C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10296C24)");
    test_class_info(&lv, &cd_S10296C24);
    dp->~S10296C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10296C24(Test_S10296C24, "S10296C24", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S10296C24C1Ev();
extern void _ZN9S10296C24D1Ev();
Name_Map name_map_S10296C24[] = {
  NSPAIR(_ZN9S10296C24C1Ev),
  NSPAIR(_ZN9S10296C24D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S10296C24[];
extern void _ZN9S10296C24D1Ev();
extern void _ZN9S10296C24D0Ev();
extern void _ZN9S10296C243v31Ev();
static  VTBL_ENTRY vtc_S10296C24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10296C24[0]),
  (VTBL_ENTRY)&_ZN9S10296C24D1Ev,
  (VTBL_ENTRY)&_ZN9S10296C24D0Ev,
  (VTBL_ENTRY)&_ZN9S10296C243v31Ev,
};
extern VTBL_ENTRY _ZTI9S10296C24[];
extern  VTBL_ENTRY _ZTV9S10296C24[];
Class_Descriptor cd_S10296C24 = {  "S10296C24", // class name
  0,0,//no base classes
  &(vtc_S10296C24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S10296C24),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S10296C24),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C25_nt  {
  ::S9624C35 s10296c25f0;
  void  mf10296c25(); // _ZN12S10296C25_nt10mf10296c25Ev
};
//SIG(-1 S10296C25_nt) C1{ m FC2{ m Fp Fi[2] FC3{ m}}}


void  S10296C25_nt ::mf10296c25(){}

//skip512 S10296C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C23_nt  : S10296C24 {
  void *s10296c23f0[2];
  ::S10296C25_nt s10296c23f1;
  ::S10296C9 s10296c23f2;
  virtual  ~S10296C23_nt(); // _ZN12S10296C23_ntD1Ev
  virtual void  v32(); // _ZN12S10296C23_nt3v32Ev
  S10296C23_nt(); // tgen
};
//SIG(-1 S10296C23_nt) C1{ BC2{ vd v2} vd v1 Fp[2] FC3{ m FC4{ m Fp Fi[2] FC5{ m}}} FC6{ m Fp[2]}}


 S10296C23_nt ::~S10296C23_nt(){ note_dtor("S10296C23_nt", this);}
void  S10296C23_nt ::v32(){vfunc_called(this, "_ZN12S10296C23_nt3v32Ev");}
S10296C23_nt ::S10296C23_nt(){ note_ctor("S10296C23_nt", this);} // tgen

//skip512 S10296C23_nt

#else // __cplusplus

extern void _ZN12S10296C23_ntC1Ev();
extern void _ZN12S10296C23_ntD1Ev();
Name_Map name_map_S10296C23_nt[] = {
  NSPAIR(_ZN12S10296C23_ntC1Ev),
  NSPAIR(_ZN12S10296C23_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10296C24;
extern VTBL_ENTRY _ZTI9S10296C24[];
extern  VTBL_ENTRY _ZTV9S10296C24[];
static Base_Class bases_S10296C23_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S10296C23_nt[];
extern void _ZN12S10296C23_ntD1Ev();
extern void _ZN12S10296C23_ntD0Ev();
extern void _ZN9S10296C243v31Ev();
extern void _ZN12S10296C23_nt3v32Ev();
static  VTBL_ENTRY vtc_S10296C23_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10296C23_nt[0]),
  (VTBL_ENTRY)&_ZN12S10296C23_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10296C23_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S10296C243v31Ev,
  (VTBL_ENTRY)&_ZN12S10296C23_nt3v32Ev,
};
extern VTBL_ENTRY _ZTI12S10296C23_nt[];
VTBL_ENTRY *P__ZTI12S10296C23_nt = _ZTI12S10296C23_nt; 
extern  VTBL_ENTRY _ZTV12S10296C23_nt[];
Class_Descriptor cd_S10296C23_nt = {  "S10296C23_nt", // class name
  bases_S10296C23_nt, 1,
  &(vtc_S10296C23_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI12S10296C23_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV12S10296C23_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C30_nt  {
  short s10296c30f0[2];
  char s10296c30f1[2];
  short s10296c30f2;
};
//SIG(1 S10296C30_nt) C1{ Fs[2] Fc[2] Fs}



//skip512 S10296C30_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C31_nt  {
  short s10296c31f0[2];
};
//SIG(1 S10296C31_nt) C1{ Fs[2]}



//skip512 S10296C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C32  {
  void *s10296c32f0[2];
  void  mf10296c32(); // _ZN9S10296C3210mf10296c32Ev
};
//SIG(-1 S10296C32) C1{ m Fp[2]}


void  S10296C32 ::mf10296c32(){}

static void Test_S10296C32()
{
  {
    init_simple_test("S10296C32");
    S10296C32 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10296C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10296C32)");
    check_field_offset(lv, s10296c32f0, 0, "S10296C32.s10296c32f0");
  }
}
static Arrange_To_Call_Me vS10296C32(Test_S10296C32, "S10296C32", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C29_nt  {
  ::S10296C30_nt s10296c29f0[12];
  int s10296c29f1;
  ::S10296C31_nt s10296c29f2[4];
  int s10296c29f3;
  ::S10296C32 s10296c29f4;
  void  mf10296c29(); // _ZN12S10296C29_nt10mf10296c29Ev
};
//SIG(-1 S10296C29_nt) C1{ m FC2{ Fs[2] Fc[2] Fs}[12] Fi FC3{ Fs[2]}[4] Fi FC4{ m Fp[2]}}


void  S10296C29_nt ::mf10296c29(){}

//skip512 S10296C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C22_nt  : S10296C23_nt {
  ::S10296C29_nt s10296c22f0;
  virtual  ~S10296C22_nt(); // _ZN12S10296C22_ntD1Ev
  S10296C22_nt(); // tgen
};
//SIG(-1 S10296C22_nt) C1{ BC2{ BC3{ vd v1} vd v2 Fp[2] FC4{ m FC5{ m Fp Fi[2] FC6{ m}}} FC7{ m Fp[2]}} vd FC8{ m FC9{ Fs[2] Fc[2] Fs}[12] Fi FC10{ Fs[2]}[4] Fi FC11{ m Fp[2]}}}


 S10296C22_nt ::~S10296C22_nt(){ note_dtor("S10296C22_nt", this);}
S10296C22_nt ::S10296C22_nt(){ note_ctor("S10296C22_nt", this);} // tgen

//skip512 S10296C22_nt

#else // __cplusplus

extern void _ZN12S10296C22_ntC1Ev();
extern void _ZN12S10296C22_ntD1Ev();
Name_Map name_map_S10296C22_nt[] = {
  NSPAIR(_ZN12S10296C22_ntC1Ev),
  NSPAIR(_ZN12S10296C22_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10296C24;
extern VTBL_ENTRY _ZTI9S10296C24[];
extern  VTBL_ENTRY _ZTV9S10296C24[];
extern Class_Descriptor cd_S10296C23_nt;
extern VTBL_ENTRY _ZTI12S10296C23_nt[];
extern  VTBL_ENTRY _ZTV12S10296C23_nt[];
static Base_Class bases_S10296C22_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10296C23_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S10296C22_nt[];
extern void _ZN12S10296C22_ntD1Ev();
extern void _ZN12S10296C22_ntD0Ev();
extern void _ZN9S10296C243v31Ev();
extern void _ZN12S10296C23_nt3v32Ev();
static  VTBL_ENTRY vtc_S10296C22_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10296C22_nt[0]),
  (VTBL_ENTRY)&_ZN12S10296C22_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10296C22_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S10296C243v31Ev,
  (VTBL_ENTRY)&_ZN12S10296C23_nt3v32Ev,
};
extern VTBL_ENTRY _ZTI12S10296C22_nt[];
VTBL_ENTRY *P__ZTI12S10296C22_nt = _ZTI12S10296C22_nt; 
extern  VTBL_ENTRY _ZTV12S10296C22_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C11_nt  {
  ::S10296C12_nt s10296c11f0;
  ::S10296C22_nt s10296c11f1;
  void  mf10296c11(); // _ZN12S10296C11_nt10mf10296c11Ev
};
//SIG(-1 S10296C11_nt) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC9}} FC12{ BC13{ BC14{ vd v13} vd v14 Fp[2] FC15{ m FC16{ m Fp Fi[2] FC17{ m}}} FC18{ m Fp[2]}} vd FC19{ m FC20{ Fs[2] Fc[2] Fs}[12] Fi FC21{ Fs[2]}[4] Fi FC22{ m Fp[2]}}}}


void  S10296C11_nt ::mf10296c11(){}

//skip512 S10296C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C35_nt  : S10296C17_nt {
  ::S10296C3_nt s10296c35f0;
};
//SIG(-1 S10296C35_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m Fp[2]} FC5{ m Fp}}}



//skip512 S10296C35_nt

#else // __cplusplus

extern Class_Descriptor cd_S10296C17_nt;
static Base_Class bases_S10296C35_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C34_nt  : S10296C13_nt , S10296C15_nt {
  ::S10296C35_nt s10296c34f0;
  virtual void  v33(); // _ZN12S10296C34_nt3v33Ev
  virtual void  v34(); // _ZN12S10296C34_nt3v34Ev
  virtual void  v35(); // _ZN12S10296C34_nt3v35Ev
  virtual void  v36(); // _ZN12S10296C34_nt3v36Ev
  virtual void  v37(); // _ZN12S10296C34_nt3v37Ev
  virtual void  v38(); // _ZN12S10296C34_nt3v38Ev
  ~S10296C34_nt(); // tgen
  S10296C34_nt(); // tgen
};
//SIG(-1 S10296C34_nt) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}}}


void  S10296C34_nt ::v33(){vfunc_called(this, "_ZN12S10296C34_nt3v33Ev");}
void  S10296C34_nt ::v34(){vfunc_called(this, "_ZN12S10296C34_nt3v34Ev");}
void  S10296C34_nt ::v35(){vfunc_called(this, "_ZN12S10296C34_nt3v35Ev");}
void  S10296C34_nt ::v36(){vfunc_called(this, "_ZN12S10296C34_nt3v36Ev");}
void  S10296C34_nt ::v37(){vfunc_called(this, "_ZN12S10296C34_nt3v37Ev");}
void  S10296C34_nt ::v38(){vfunc_called(this, "_ZN12S10296C34_nt3v38Ev");}
S10296C34_nt ::~S10296C34_nt(){ note_dtor("S10296C34_nt", this);} // tgen
S10296C34_nt ::S10296C34_nt(){ note_ctor("S10296C34_nt", this);} // tgen

//skip512 S10296C34_nt

#else // __cplusplus

extern void _ZN12S10296C34_ntC1Ev();
extern void _ZN12S10296C34_ntD1Ev();
Name_Map name_map_S10296C34_nt[] = {
  NSPAIR(_ZN12S10296C34_ntC1Ev),
  NSPAIR(_ZN12S10296C34_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10296C13_nt;
extern VTBL_ENTRY _ZTI12S10296C13_nt[];
extern  VTBL_ENTRY _ZTV12S10296C13_nt[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S10296C34_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S10296C34_nt[];
extern void _ZN12S10296C34_ntD1Ev();
extern void _ZN12S10296C34_ntD0Ev();
extern void _ZN12S10296C13_nt3v25Ev();
extern void _ZN12S10296C13_nt3v26Ev();
extern void _ZN12S10296C13_nt3v27Ev();
extern void _ZN12S10296C13_nt3v28Ev();
extern void _ZN12S10296C13_nt3v29Ev();
extern void _ZN12S10296C13_nt3v30Ev();
extern void _ZN12S10296C34_nt3v33Ev();
extern void _ZN12S10296C34_nt3v34Ev();
extern void _ZN12S10296C34_nt3v35Ev();
extern void _ZN12S10296C34_nt3v36Ev();
extern void _ZN12S10296C34_nt3v37Ev();
extern void _ZN12S10296C34_nt3v38Ev();
static  VTBL_ENTRY vtc_S10296C34_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10296C34_nt[0]),
  (VTBL_ENTRY)&_ZN12S10296C34_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10296C34_ntD0Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v25Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v26Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v27Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v28Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v29Ev,
  (VTBL_ENTRY)&_ZN12S10296C13_nt3v30Ev,
  (VTBL_ENTRY)&_ZN12S10296C34_nt3v33Ev,
  (VTBL_ENTRY)&_ZN12S10296C34_nt3v34Ev,
  (VTBL_ENTRY)&_ZN12S10296C34_nt3v35Ev,
  (VTBL_ENTRY)&_ZN12S10296C34_nt3v36Ev,
  (VTBL_ENTRY)&_ZN12S10296C34_nt3v37Ev,
  (VTBL_ENTRY)&_ZN12S10296C34_nt3v38Ev,
};
extern VTBL_ENTRY _ZTI12S10296C34_nt[];
VTBL_ENTRY *P__ZTI12S10296C34_nt = _ZTI12S10296C34_nt; 
extern  VTBL_ENTRY _ZTV12S10296C34_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C37  : S10296C24 {
  void *s10296c37f0[2];
  ::S10296C25_nt s10296c37f1;
  ::S10296C32 s10296c37f2;
  virtual  ~S10296C37(); // _ZN9S10296C37D1Ev
  virtual void  v39(); // _ZN9S10296C373v39Ev
  S10296C37(); // tgen
};
//SIG(-1 S10296C37) C1{ BC2{ vd v2} vd v1 Fp[2] FC3{ m FC4{ m Fp Fi[2] FC5{ m}}} FC6{ m Fp[2]}}


 S10296C37 ::~S10296C37(){ note_dtor("S10296C37", this);}
void  S10296C37 ::v39(){vfunc_called(this, "_ZN9S10296C373v39Ev");}
S10296C37 ::S10296C37(){ note_ctor("S10296C37", this);} // tgen

static void Test_S10296C37()
{
  extern Class_Descriptor cd_S10296C37;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S10296C37, buf);
    S10296C37 *dp, &lv = *(dp=new (buf) S10296C37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S10296C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10296C37)");
    check_base_class_offset(lv, (S10296C24*), 0, "S10296C37");
    check_field_offset(lv, s10296c37f0, ABISELECT(8,4), "S10296C37.s10296c37f0");
    check_field_offset(lv, s10296c37f1, ABISELECT(24,12), "S10296C37.s10296c37f1");
    check_field_offset(lv, s10296c37f2, ABISELECT(48,28), "S10296C37.s10296c37f2");
    test_class_info(&lv, &cd_S10296C37);
    dp->~S10296C37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10296C37(Test_S10296C37, "S10296C37", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN9S10296C37C1Ev();
extern void _ZN9S10296C37D1Ev();
Name_Map name_map_S10296C37[] = {
  NSPAIR(_ZN9S10296C37C1Ev),
  NSPAIR(_ZN9S10296C37D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10296C24;
extern VTBL_ENTRY _ZTI9S10296C24[];
extern  VTBL_ENTRY _ZTV9S10296C24[];
static Base_Class bases_S10296C37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S10296C37[];
extern void _ZN9S10296C37D1Ev();
extern void _ZN9S10296C37D0Ev();
extern void _ZN9S10296C243v31Ev();
extern void _ZN9S10296C373v39Ev();
static  VTBL_ENTRY vtc_S10296C37[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S10296C37[0]),
  (VTBL_ENTRY)&_ZN9S10296C37D1Ev,
  (VTBL_ENTRY)&_ZN9S10296C37D0Ev,
  (VTBL_ENTRY)&_ZN9S10296C243v31Ev,
  (VTBL_ENTRY)&_ZN9S10296C373v39Ev,
};
extern VTBL_ENTRY _ZTI9S10296C37[];
extern  VTBL_ENTRY _ZTV9S10296C37[];
Class_Descriptor cd_S10296C37 = {  "S10296C37", // class name
  bases_S10296C37, 1,
  &(vtc_S10296C37[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI9S10296C37),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S10296C37),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C43_nt  {
  char s10296c43f0;
  char s10296c43f1:4;
  char s10296c43f2:4;
  char s10296c43f3:4;
  char s10296c43f4:4;
  char s10296c43f5:4;
  char s10296c43f6:4;
};
//SIG(-1 S10296C43_nt) C1{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4}



//skip512 S10296C43_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C42_nt  {
  void *s10296c42f0;
  int s10296c42f1;
  ::S10296C43_nt s10296c42f2;
  int s10296c42f3;
  ::S10296C32 s10296c42f4;
  void  mf10296c42(); // _ZN12S10296C42_nt10mf10296c42Ev
};
//SIG(-1 S10296C42_nt) C1{ m Fp Fi FC2{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC3{ m Fp[2]}}


void  S10296C42_nt ::mf10296c42(){}

//skip512 S10296C42_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C36_nt  : S10296C37 {
  ::S10296C42_nt s10296c36f0;
  virtual  ~S10296C36_nt(); // _ZN12S10296C36_ntD1Ev
  S10296C36_nt(); // tgen
};
//SIG(-1 S10296C36_nt) C1{ BC2{ BC3{ vd v1} vd v2 Fp[2] FC4{ m FC5{ m Fp Fi[2] FC6{ m}}} FC7{ m Fp[2]}} vd FC8{ m Fp Fi FC9{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC7}}


 S10296C36_nt ::~S10296C36_nt(){ note_dtor("S10296C36_nt", this);}
S10296C36_nt ::S10296C36_nt(){ note_ctor("S10296C36_nt", this);} // tgen

//skip512 S10296C36_nt

#else // __cplusplus

extern void _ZN12S10296C36_ntC1Ev();
extern void _ZN12S10296C36_ntD1Ev();
Name_Map name_map_S10296C36_nt[] = {
  NSPAIR(_ZN12S10296C36_ntC1Ev),
  NSPAIR(_ZN12S10296C36_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10296C24;
extern VTBL_ENTRY _ZTI9S10296C24[];
extern  VTBL_ENTRY _ZTV9S10296C24[];
extern Class_Descriptor cd_S10296C37;
extern VTBL_ENTRY _ZTI9S10296C37[];
extern  VTBL_ENTRY _ZTV9S10296C37[];
static Base_Class bases_S10296C36_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S10296C37,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S10296C36_nt[];
extern void _ZN12S10296C36_ntD1Ev();
extern void _ZN12S10296C36_ntD0Ev();
extern void _ZN9S10296C243v31Ev();
extern void _ZN9S10296C373v39Ev();
static  VTBL_ENTRY vtc_S10296C36_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S10296C36_nt[0]),
  (VTBL_ENTRY)&_ZN12S10296C36_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S10296C36_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S10296C243v31Ev,
  (VTBL_ENTRY)&_ZN9S10296C373v39Ev,
};
extern VTBL_ENTRY _ZTI12S10296C36_nt[];
VTBL_ENTRY *P__ZTI12S10296C36_nt = _ZTI12S10296C36_nt; 
extern  VTBL_ENTRY _ZTV12S10296C36_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C33_nt  {
  ::S10296C34_nt s10296c33f0;
  ::S10296C36_nt s10296c33f1;
  void  mf10296c33(); // _ZN12S10296C33_nt10mf10296c33Ev
};
//SIG(-1 S10296C33_nt) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}}} FC11{ BC12{ BC13{ vd v13} vd v14 Fp[2] FC14{ m FC15{ m Fp Fi[2] FC16{ m}}} FC17{ m Fp[2]}} vd FC18{ m Fp Fi FC19{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC17}}}


void  S10296C33_nt ::mf10296c33(){}

//skip512 S10296C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C10  {
  ::S10296C11_nt s10296c10f0;
  ::S10296C33_nt s10296c10f1;
  void  mf10296c10(); // _ZN9S10296C1010mf10296c10Ev
};
//SIG(-1 S10296C10) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC10}} FC13{ BC14{ BC15{ vd v13} vd v14 Fp[2] FC16{ m FC17{ m Fp Fi[2] FC18{ m}}} FC19{ m Fp[2]}} vd FC20{ m FC21{ Fs[2] Fc[2] Fs}[12] Fi FC22{ Fs[2]}[4] Fi FC23{ m Fp[2]}}}} FC24{ m FC25{ BC4 BC6 v15 v16 v17 v18 v19 v20 FC26{ BC8 FC27{ m FC28{ m Fp[2]} FC29{ m Fp}}}} FC30{ BC31{ BC15 vd v21 Fp[2] FC16 FC23} vd FC32{ m Fp Fi FC33{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23}}}}


void  S10296C10 ::mf10296c10(){}

static void Test_S10296C10()
{
  {
    init_simple_test("S10296C10");
    static S10296C10 lv;
    check2(sizeof(lv), ABISELECT(584,416), "sizeof(S10296C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10296C10)");
    check_field_offset(lv, s10296c10f0, 0, "S10296C10.s10296c10f0");
    check_field_offset(lv, s10296c10f1, ABISELECT(384,304), "S10296C10.s10296c10f1");
  }
}
static Arrange_To_Call_Me vS10296C10(Test_S10296C10, "S10296C10", ABISELECT(584,416));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C47_nt  {
  __tsi64 s10296c47f0;
  void  mf10296c47(); // _ZN12S10296C47_nt10mf10296c47Ev
};
//SIG(-1 S10296C47_nt) C1{ m FL}


void  S10296C47_nt ::mf10296c47(){}

//skip512 S10296C47_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI12S10296C47_nt[];
VTBL_ENTRY *P__ZTI12S10296C47_nt = _ZTI12S10296C47_nt; 
Class_Descriptor cd_S10296C47_nt = {  "S10296C47_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  NSPAIRA(_ZTI12S10296C47_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C46_nt  {
  ::S10296C47_nt s10296c46f0;
  void  mf10296c46(); // _ZN12S10296C46_nt10mf10296c46Ev
};
//SIG(-1 S10296C46_nt) C1{ m FC2{ m FL}}


void  S10296C46_nt ::mf10296c46(){}

//skip512 S10296C46_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C45_nt  {
  ::S10296C46_nt s10296c45f0;
  ::S10296C46_nt s10296c45f1;
  void  mf10296c45(); // _ZN12S10296C45_nt10mf10296c45Ev
};
//SIG(-1 S10296C45_nt) C1{ m FC2{ m FC3{ m FL}} FC2}


void  S10296C45_nt ::mf10296c45(){}

//skip512 S10296C45_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C44_nt  {
  ::S10296C45_nt s10296c44f0;
  ::S10296C45_nt s10296c44f1;
  void  mf10296c44(); // _ZN12S10296C44_nt10mf10296c44Ev
};
//SIG(-1 S10296C44_nt) C1{ m FC2{ m FC3{ m FC4{ m FL}} FC3} FC2}


void  S10296C44_nt ::mf10296c44(){}

//skip512 S10296C44_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C48  {
  void *s10296c48f0[2];
  void  mf10296c48(); // _ZN9S10296C4810mf10296c48Ev
};
//SIG(-1 S10296C48) C1{ m Fp[2]}


void  S10296C48 ::mf10296c48(){}

static void Test_S10296C48()
{
  {
    init_simple_test("S10296C48");
    S10296C48 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S10296C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10296C48)");
    check_field_offset(lv, s10296c48f0, 0, "S10296C48.s10296c48f0");
  }
}
static Arrange_To_Call_Me vS10296C48(Test_S10296C48, "S10296C48", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10296C1  : S10296C2_nt {
  ::S10296C3_nt s10296c1f0;
  ::S10296C6_nt s10296c1f1;
  ::S10296C10 s10296c1f2;
  ::S10296C44_nt s10296c1f3;
  ::S10296C48 s10296c1f4;
  char s10296c1f5;
  virtual void  v1(); // _ZN8S10296C12v1Ev
  virtual void  v2(); // _ZN8S10296C12v2Ev
  virtual void  v3(); // _ZN8S10296C12v3Ev
  virtual void  v4(); // _ZN8S10296C12v4Ev
  virtual void  v5(); // _ZN8S10296C12v5Ev
  virtual void  v6(); // _ZN8S10296C12v6Ev
  virtual void  v7(); // _ZN8S10296C12v7Ev
  virtual void  v8(); // _ZN8S10296C12v8Ev
  ~S10296C1(); // tgen
  S10296C1(); // tgen
};
//SIG(1 S10296C1) C1{ BC2{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18} v1 v2 v3 v4 v5 v6 v7 v8 FC3{ m FC4{ m Fp[2]} FC5{ m Fp}} FC6{ m FC7{ m FC4 FC8{ m Fp[2]}} FC7} FC9{ m FC10{ m FC11{ BC12{ vd v25 v26 v27 v28 v29 v30 FC13{ m Fp[4]}} BC14{} v19 v20 v21 v22 v23 v24 FC15{ BC16{ m Fp Fi Fp Fi[2]} FC17{ m FC18{ m FC19{ m FL[2]}} FC18 FC18 FC18}} FC20{ BC16 FC18}} FC21{ BC22{ BC23{ vd v31} vd v32 Fp[2] FC24{ m FC25{ m Fp Fi[2] FC26{ m}}} FC8} vd FC27{ m FC28{ Fs[2] Fc[2] Fs}[12] Fi FC29{ Fs[2]}[4] Fi FC30{ m Fp[2]}}}} FC31{ m FC32{ BC12 BC14 v33 v34 v35 v36 v37 v38 FC33{ BC16 FC3}} FC34{ BC35{ BC23 vd v39 Fp[2] FC24 FC30} vd FC36{ m Fp Fi FC37{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC30}}}} FC38{ m FC39{ m FC40{ m FC41{ m FL}} FC40} FC39} FC42{ m Fp[2]} Fc}


void  S10296C1 ::v1(){vfunc_called(this, "_ZN8S10296C12v1Ev");}
void  S10296C1 ::v2(){vfunc_called(this, "_ZN8S10296C12v2Ev");}
void  S10296C1 ::v3(){vfunc_called(this, "_ZN8S10296C12v3Ev");}
void  S10296C1 ::v4(){vfunc_called(this, "_ZN8S10296C12v4Ev");}
void  S10296C1 ::v5(){vfunc_called(this, "_ZN8S10296C12v5Ev");}
void  S10296C1 ::v6(){vfunc_called(this, "_ZN8S10296C12v6Ev");}
void  S10296C1 ::v7(){vfunc_called(this, "_ZN8S10296C12v7Ev");}
void  S10296C1 ::v8(){vfunc_called(this, "_ZN8S10296C12v8Ev");}
S10296C1 ::~S10296C1(){ note_dtor("S10296C1", this);} // tgen
S10296C1 ::S10296C1(){ note_ctor("S10296C1", this);} // tgen

static void Test_S10296C1()
{
  extern Class_Descriptor cd_S10296C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(93,128)];
    init_test(&cd_S10296C1, buf);
    S10296C1 *dp, &lv = *(dp=new (buf) S10296C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(736,508), "sizeof(S10296C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10296C1)");
    check_base_class_offset(lv, (S10296C2_nt*), 0, "S10296C1");
    check_field_offset(lv, s10296c1f0, ABISELECT(8,4), "S10296C1.s10296c1f0");
    check_field_offset(lv, s10296c1f1, ABISELECT(32,16), "S10296C1.s10296c1f1");
    check_field_offset(lv, s10296c1f2, ABISELECT(96,48), "S10296C1.s10296c1f2");
    check_field_offset(lv, s10296c1f3, ABISELECT(680,464), "S10296C1.s10296c1f3");
    check_field_offset(lv, s10296c1f4, ABISELECT(712,496), "S10296C1.s10296c1f4");
    check_field_offset(lv, s10296c1f5, ABISELECT(728,504), "S10296C1.s10296c1f5");
    test_class_info(&lv, &cd_S10296C1);
    dp->~S10296C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10296C1(Test_S10296C1, "S10296C1", ABISELECT(736,508));

#else // __cplusplus

extern void _ZN8S10296C1C1Ev();
extern void _ZN8S10296C1D1Ev();
Name_Map name_map_S10296C1[] = {
  NSPAIR(_ZN8S10296C1C1Ev),
  NSPAIR(_ZN8S10296C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10296C2_nt;
extern VTBL_ENTRY _ZTI11S10296C2_nt[];
extern  VTBL_ENTRY _ZTV11S10296C2_nt[];
static Base_Class bases_S10296C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10296C1[];
extern void _ZN8S10296C1D1Ev();
extern void _ZN8S10296C1D0Ev();
extern void _ZN11S10296C2_nt2v9Ev();
extern void _ZN11S10296C2_nt3v10Ev();
extern void _ZN11S10296C2_nt3v11Ev();
extern void _ZN11S10296C2_nt3v12Ev();
extern void _ZN11S10296C2_nt3v13Ev();
extern void _ZN11S10296C2_nt3v14Ev();
extern void _ZN11S10296C2_nt3v15Ev();
extern void _ZN11S10296C2_nt3v16Ev();
extern void _ZN11S10296C2_nt3v17Ev();
extern void _ZN11S10296C2_nt3v18Ev();
extern void _ZN8S10296C12v1Ev();
extern void _ZN8S10296C12v2Ev();
extern void _ZN8S10296C12v3Ev();
extern void _ZN8S10296C12v4Ev();
extern void _ZN8S10296C12v5Ev();
extern void _ZN8S10296C12v6Ev();
extern void _ZN8S10296C12v7Ev();
extern void _ZN8S10296C12v8Ev();
static  VTBL_ENTRY vtc_S10296C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10296C1[0]),
  (VTBL_ENTRY)&_ZN8S10296C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10296C1D0Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt2v9Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v10Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v11Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v12Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v13Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v14Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v15Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v16Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN11S10296C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN8S10296C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10296C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10296C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10296C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10296C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10296C12v6Ev,
  (VTBL_ENTRY)&_ZN8S10296C12v7Ev,
  (VTBL_ENTRY)&_ZN8S10296C12v8Ev,
};
extern VTBL_ENTRY _ZTI8S10296C1[];
extern  VTBL_ENTRY _ZTV8S10296C1[];
Class_Descriptor cd_S10296C1 = {  "S10296C1", // class name
  bases_S10296C1, 1,
  &(vtc_S10296C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(736,508), // object size
  NSPAIRA(_ZTI8S10296C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S10296C1),22, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15657C4  {
  ::S10296C14_nt s15657c4f0;
  virtual  ~S15657C4(); // _ZN8S15657C4D1Ev
  virtual void  v7(); // _ZN8S15657C42v7Ev
  virtual void  v8(); // _ZN8S15657C42v8Ev
  virtual void  v9(); // _ZN8S15657C42v9Ev
  virtual void  v10(); // _ZN8S15657C43v10Ev
  virtual void  v11(); // _ZN8S15657C43v11Ev
  virtual void  v12(); // _ZN8S15657C43v12Ev
  S15657C4(); // tgen
};
//SIG(-1 S15657C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15657C4 ::~S15657C4(){ note_dtor("S15657C4", this);}
void  S15657C4 ::v7(){vfunc_called(this, "_ZN8S15657C42v7Ev");}
void  S15657C4 ::v8(){vfunc_called(this, "_ZN8S15657C42v8Ev");}
void  S15657C4 ::v9(){vfunc_called(this, "_ZN8S15657C42v9Ev");}
void  S15657C4 ::v10(){vfunc_called(this, "_ZN8S15657C43v10Ev");}
void  S15657C4 ::v11(){vfunc_called(this, "_ZN8S15657C43v11Ev");}
void  S15657C4 ::v12(){vfunc_called(this, "_ZN8S15657C43v12Ev");}
S15657C4 ::S15657C4(){ note_ctor("S15657C4", this);} // tgen

static void Test_S15657C4()
{
  extern Class_Descriptor cd_S15657C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15657C4, buf);
    S15657C4 *dp, &lv = *(dp=new (buf) S15657C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15657C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15657C4)");
    check_field_offset(lv, s15657c4f0, ABISELECT(8,4), "S15657C4.s15657c4f0");
    test_class_info(&lv, &cd_S15657C4);
    dp->~S15657C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15657C4(Test_S15657C4, "S15657C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S15657C4C1Ev();
extern void _ZN8S15657C4D1Ev();
Name_Map name_map_S15657C4[] = {
  NSPAIR(_ZN8S15657C4C1Ev),
  NSPAIR(_ZN8S15657C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15657C4[];
extern void _ZN8S15657C4D1Ev();
extern void _ZN8S15657C4D0Ev();
extern void _ZN8S15657C42v7Ev();
extern void _ZN8S15657C42v8Ev();
extern void _ZN8S15657C42v9Ev();
extern void _ZN8S15657C43v10Ev();
extern void _ZN8S15657C43v11Ev();
extern void _ZN8S15657C43v12Ev();
static  VTBL_ENTRY vtc_S15657C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15657C4[0]),
  (VTBL_ENTRY)&_ZN8S15657C4D1Ev,
  (VTBL_ENTRY)&_ZN8S15657C4D0Ev,
  (VTBL_ENTRY)&_ZN8S15657C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15657C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15657C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15657C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15657C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15657C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S15657C4[];
extern  VTBL_ENTRY _ZTV8S15657C4[];
Class_Descriptor cd_S15657C4 = {  "S15657C4", // class name
  0,0,//no base classes
  &(vtc_S15657C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S15657C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15657C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15657C13_nt  : S10296C17_nt {
  ::S10296C46_nt s15657c13f0;
};
//SIG(-1 S15657C13_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} FC3{ m FC4{ m FL}}}



//skip512 S15657C13_nt

#else // __cplusplus

extern Class_Descriptor cd_S10296C17_nt;
static Base_Class bases_S15657C13_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15657C3  : S15657C4 , S10296C15_nt {
  ::S10296C16_nt s15657c3f0;
  ::S10296C21_nt s15657c3f1;
  ::S15657C13_nt s15657c3f2;
  virtual void  v1(); // _ZN8S15657C32v1Ev
  virtual void  v2(); // _ZN8S15657C32v2Ev
  virtual void  v3(); // _ZN8S15657C32v3Ev
  virtual void  v4(); // _ZN8S15657C32v4Ev
  virtual void  v5(); // _ZN8S15657C32v5Ev
  virtual void  v6(); // _ZN8S15657C32v6Ev
  ~S15657C3(); // tgen
  S15657C3(); // tgen
};
//SIG(-1 S15657C3) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC8} FC11{ BC6 FC12{ m FC13{ m FL}}}}


void  S15657C3 ::v1(){vfunc_called(this, "_ZN8S15657C32v1Ev");}
void  S15657C3 ::v2(){vfunc_called(this, "_ZN8S15657C32v2Ev");}
void  S15657C3 ::v3(){vfunc_called(this, "_ZN8S15657C32v3Ev");}
void  S15657C3 ::v4(){vfunc_called(this, "_ZN8S15657C32v4Ev");}
void  S15657C3 ::v5(){vfunc_called(this, "_ZN8S15657C32v5Ev");}
void  S15657C3 ::v6(){vfunc_called(this, "_ZN8S15657C32v6Ev");}
S15657C3 ::~S15657C3(){ note_dtor("S15657C3", this);} // tgen
S15657C3 ::S15657C3(){ note_ctor("S15657C3", this);} // tgen

static void Test_S15657C3()
{
  extern Class_Descriptor cd_S15657C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,43)];
    init_test(&cd_S15657C3, buf);
    S15657C3 *dp, &lv = *(dp=new (buf) S15657C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,168), "sizeof(S15657C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15657C3)");
    check_base_class_offset(lv, (S15657C4*), 0, "S15657C3");
    check_base_class_offset(lv, (S10296C15_nt*), 0, "S15657C3");
    check_field_offset(lv, s15657c3f0, ABISELECT(40,20), "S15657C3.s15657c3f0");
    check_field_offset(lv, s15657c3f1, ABISELECT(136,104), "S15657C3.s15657c3f1");
    check_field_offset(lv, s15657c3f2, ABISELECT(184,140), "S15657C3.s15657c3f2");
    test_class_info(&lv, &cd_S15657C3);
    dp->~S15657C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15657C3(Test_S15657C3, "S15657C3", ABISELECT(224,168));

#else // __cplusplus

extern void _ZN8S15657C3C1Ev();
extern void _ZN8S15657C3D1Ev();
Name_Map name_map_S15657C3[] = {
  NSPAIR(_ZN8S15657C3C1Ev),
  NSPAIR(_ZN8S15657C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15657C4;
extern VTBL_ENTRY _ZTI8S15657C4[];
extern  VTBL_ENTRY _ZTV8S15657C4[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S15657C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15657C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S15657C3[];
extern void _ZN8S15657C3D1Ev();
extern void _ZN8S15657C3D0Ev();
extern void _ZN8S15657C42v7Ev();
extern void _ZN8S15657C42v8Ev();
extern void _ZN8S15657C42v9Ev();
extern void _ZN8S15657C43v10Ev();
extern void _ZN8S15657C43v11Ev();
extern void _ZN8S15657C43v12Ev();
extern void _ZN8S15657C32v1Ev();
extern void _ZN8S15657C32v2Ev();
extern void _ZN8S15657C32v3Ev();
extern void _ZN8S15657C32v4Ev();
extern void _ZN8S15657C32v5Ev();
extern void _ZN8S15657C32v6Ev();
static  VTBL_ENTRY vtc_S15657C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15657C3[0]),
  (VTBL_ENTRY)&_ZN8S15657C3D1Ev,
  (VTBL_ENTRY)&_ZN8S15657C3D0Ev,
  (VTBL_ENTRY)&_ZN8S15657C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15657C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15657C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15657C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15657C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15657C43v12Ev,
  (VTBL_ENTRY)&_ZN8S15657C32v1Ev,
  (VTBL_ENTRY)&_ZN8S15657C32v2Ev,
  (VTBL_ENTRY)&_ZN8S15657C32v3Ev,
  (VTBL_ENTRY)&_ZN8S15657C32v4Ev,
  (VTBL_ENTRY)&_ZN8S15657C32v5Ev,
  (VTBL_ENTRY)&_ZN8S15657C32v6Ev,
};
extern VTBL_ENTRY _ZTI8S15657C3[];
extern  VTBL_ENTRY _ZTV8S15657C3[];
Class_Descriptor cd_S15657C3 = {  "S15657C3", // class name
  bases_S15657C3, 2,
  &(vtc_S15657C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,168), // object size
  NSPAIRA(_ZTI8S15657C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S15657C3),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15657C2  {
  ::S15657C3 s15657c2f0;
  ::S10296C22_nt s15657c2f1;
  void  mf15657c2(); // _ZN8S15657C29mf15657c2Ev
};
//SIG(-1 S15657C2) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC9} FC12{ BC7 FC13{ m FC14{ m FL}}}} FC15{ BC16{ BC17{ vd v13} vd v14 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m FC23{ Fs[2] Fc[2] Fs}[12] Fi FC24{ Fs[2]}[4] Fi FC25{ m Fp[2]}}}}


void  S15657C2 ::mf15657c2(){}

static void Test_S15657C2()
{
  {
    init_simple_test("S15657C2");
    S15657C2 lv;
    check2(sizeof(lv), ABISELECT(424,332), "sizeof(S15657C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15657C2)");
    check_field_offset(lv, s15657c2f0, 0, "S15657C2.s15657c2f0");
    check_field_offset(lv, s15657c2f1, ABISELECT(224,168), "S15657C2.s15657c2f1");
  }
}
static Arrange_To_Call_Me vS15657C2(Test_S15657C2, "S15657C2", ABISELECT(424,332));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15657C33_nt  : S10296C17_nt {
  int s15657c33f0;
};
//SIG(-1 S15657C33_nt) C1{ BC2{ m Fp Fi Fp Fi[2]} Fi}



//skip512 S15657C33_nt

#else // __cplusplus

extern Class_Descriptor cd_S10296C17_nt;
static Base_Class bases_S15657C33_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10296C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15657C28  : S15657C4 , S10296C15_nt {
  ::S10296C35_nt s15657c28f0;
  ::S10296C21_nt s15657c28f1;
  ::S15657C13_nt s15657c28f2;
  ::S15657C33_nt s15657c28f3;
  ::S15657C13_nt s15657c28f4;
  ::S15657C33_nt s15657c28f5;
  ::S15657C13_nt s15657c28f6;
  ::S15657C33_nt s15657c28f7;
  ::S15657C13_nt s15657c28f8;
  ::S15657C33_nt s15657c28f9;
  ::S15657C13_nt s15657c28f10;
  ::S15657C33_nt s15657c28f11;
  ::S15657C13_nt s15657c28f12;
  ::S15657C33_nt s15657c28f13;
  ::S15657C13_nt s15657c28f14;
  ::S15657C33_nt s15657c28f15;
  ::S15657C13_nt s15657c28f16;
  ::S15657C33_nt s15657c28f17;
  ::S15657C13_nt s15657c28f18;
  ::S15657C33_nt s15657c28f19;
  ::S15657C13_nt s15657c28f20;
  ::S15657C33_nt s15657c28f21;
  ::S15657C13_nt s15657c28f22;
  ::S15657C33_nt s15657c28f23;
  ::S15657C13_nt s15657c28f24;
  ::S15657C33_nt s15657c28f25;
  ::S15657C13_nt s15657c28f26;
  ::S15657C33_nt s15657c28f27;
  virtual void  v15(); // _ZN9S15657C283v15Ev
  virtual void  v16(); // _ZN9S15657C283v16Ev
  virtual void  v17(); // _ZN9S15657C283v17Ev
  virtual void  v18(); // _ZN9S15657C283v18Ev
  virtual void  v19(); // _ZN9S15657C283v19Ev
  virtual void  v20(); // _ZN9S15657C283v20Ev
  ~S15657C28(); // tgen
  S15657C28(); // tgen
};
//SIG(-1 S15657C28) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL[2]}}} FC13{ BC6 FC14{ m FC15{ m FL}}} FC16{ BC6 Fi} FC13 FC16 FC13 FC16 FC13 FC16 FC13 FC16 FC13 FC16 FC13 FC16 FC13 FC16 FC13 FC16 FC13 FC16 FC13 FC16 FC13 FC16 FC13 FC16}


void  S15657C28 ::v15(){vfunc_called(this, "_ZN9S15657C283v15Ev");}
void  S15657C28 ::v16(){vfunc_called(this, "_ZN9S15657C283v16Ev");}
void  S15657C28 ::v17(){vfunc_called(this, "_ZN9S15657C283v17Ev");}
void  S15657C28 ::v18(){vfunc_called(this, "_ZN9S15657C283v18Ev");}
void  S15657C28 ::v19(){vfunc_called(this, "_ZN9S15657C283v19Ev");}
void  S15657C28 ::v20(){vfunc_called(this, "_ZN9S15657C283v20Ev");}
S15657C28 ::~S15657C28(){ note_dtor("S15657C28", this);} // tgen
S15657C28 ::S15657C28(){ note_ctor("S15657C28", this);} // tgen

static void Test_S15657C28()
{
  extern Class_Descriptor cd_S15657C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(149,192)];
    init_test(&cd_S15657C28, buf);
    S15657C28 *dp, &lv = *(dp=new (buf) S15657C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1184,764), "sizeof(S15657C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15657C28)");
    check_base_class_offset(lv, (S15657C4*), 0, "S15657C28");
    check_base_class_offset(lv, (S10296C15_nt*), 0, "S15657C28");
    check_field_offset(lv, s15657c28f0, ABISELECT(40,20), "S15657C28.s15657c28f0");
    check_field_offset(lv, s15657c28f1, ABISELECT(96,52), "S15657C28.s15657c28f1");
    check_field_offset(lv, s15657c28f2, ABISELECT(144,88), "S15657C28.s15657c28f2");
    check_field_offset(lv, s15657c28f3, ABISELECT(184,116), "S15657C28.s15657c28f3");
    check_field_offset(lv, s15657c28f4, ABISELECT(224,140), "S15657C28.s15657c28f4");
    check_field_offset(lv, s15657c28f5, ABISELECT(264,168), "S15657C28.s15657c28f5");
    check_field_offset(lv, s15657c28f6, ABISELECT(304,192), "S15657C28.s15657c28f6");
    check_field_offset(lv, s15657c28f7, ABISELECT(344,220), "S15657C28.s15657c28f7");
    check_field_offset(lv, s15657c28f8, ABISELECT(384,244), "S15657C28.s15657c28f8");
    check_field_offset(lv, s15657c28f9, ABISELECT(424,272), "S15657C28.s15657c28f9");
    check_field_offset(lv, s15657c28f10, ABISELECT(464,296), "S15657C28.s15657c28f10");
    check_field_offset(lv, s15657c28f11, ABISELECT(504,324), "S15657C28.s15657c28f11");
    check_field_offset(lv, s15657c28f12, ABISELECT(544,348), "S15657C28.s15657c28f12");
    check_field_offset(lv, s15657c28f13, ABISELECT(584,376), "S15657C28.s15657c28f13");
    check_field_offset(lv, s15657c28f14, ABISELECT(624,400), "S15657C28.s15657c28f14");
    check_field_offset(lv, s15657c28f15, ABISELECT(664,428), "S15657C28.s15657c28f15");
    check_field_offset(lv, s15657c28f16, ABISELECT(704,452), "S15657C28.s15657c28f16");
    check_field_offset(lv, s15657c28f17, ABISELECT(744,480), "S15657C28.s15657c28f17");
    check_field_offset(lv, s15657c28f18, ABISELECT(784,504), "S15657C28.s15657c28f18");
    check_field_offset(lv, s15657c28f19, ABISELECT(824,532), "S15657C28.s15657c28f19");
    check_field_offset(lv, s15657c28f20, ABISELECT(864,556), "S15657C28.s15657c28f20");
    check_field_offset(lv, s15657c28f21, ABISELECT(904,584), "S15657C28.s15657c28f21");
    check_field_offset(lv, s15657c28f22, ABISELECT(944,608), "S15657C28.s15657c28f22");
    check_field_offset(lv, s15657c28f23, ABISELECT(984,636), "S15657C28.s15657c28f23");
    check_field_offset(lv, s15657c28f24, ABISELECT(1024,660), "S15657C28.s15657c28f24");
    check_field_offset(lv, s15657c28f25, ABISELECT(1064,688), "S15657C28.s15657c28f25");
    check_field_offset(lv, s15657c28f26, ABISELECT(1104,712), "S15657C28.s15657c28f26");
    check_field_offset(lv, s15657c28f27, ABISELECT(1144,740), "S15657C28.s15657c28f27");
    test_class_info(&lv, &cd_S15657C28);
    dp->~S15657C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15657C28(Test_S15657C28, "S15657C28", ABISELECT(1184,764));

#else // __cplusplus

extern void _ZN9S15657C28C1Ev();
extern void _ZN9S15657C28D1Ev();
Name_Map name_map_S15657C28[] = {
  NSPAIR(_ZN9S15657C28C1Ev),
  NSPAIR(_ZN9S15657C28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15657C4;
extern VTBL_ENTRY _ZTI8S15657C4[];
extern  VTBL_ENTRY _ZTV8S15657C4[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S15657C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15657C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15657C28[];
extern void _ZN9S15657C28D1Ev();
extern void _ZN9S15657C28D0Ev();
extern void _ZN8S15657C42v7Ev();
extern void _ZN8S15657C42v8Ev();
extern void _ZN8S15657C42v9Ev();
extern void _ZN8S15657C43v10Ev();
extern void _ZN8S15657C43v11Ev();
extern void _ZN8S15657C43v12Ev();
extern void _ZN9S15657C283v15Ev();
extern void _ZN9S15657C283v16Ev();
extern void _ZN9S15657C283v17Ev();
extern void _ZN9S15657C283v18Ev();
extern void _ZN9S15657C283v19Ev();
extern void _ZN9S15657C283v20Ev();
static  VTBL_ENTRY vtc_S15657C28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15657C28[0]),
  (VTBL_ENTRY)&_ZN9S15657C28D1Ev,
  (VTBL_ENTRY)&_ZN9S15657C28D0Ev,
  (VTBL_ENTRY)&_ZN8S15657C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15657C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15657C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15657C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15657C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15657C43v12Ev,
  (VTBL_ENTRY)&_ZN9S15657C283v15Ev,
  (VTBL_ENTRY)&_ZN9S15657C283v16Ev,
  (VTBL_ENTRY)&_ZN9S15657C283v17Ev,
  (VTBL_ENTRY)&_ZN9S15657C283v18Ev,
  (VTBL_ENTRY)&_ZN9S15657C283v19Ev,
  (VTBL_ENTRY)&_ZN9S15657C283v20Ev,
};
extern VTBL_ENTRY _ZTI9S15657C28[];
extern  VTBL_ENTRY _ZTV9S15657C28[];
Class_Descriptor cd_S15657C28 = {  "S15657C28", // class name
  bases_S15657C28, 2,
  &(vtc_S15657C28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1184,764), // object size
  NSPAIRA(_ZTI9S15657C28),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15657C28),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15657C27  {
  ::S15657C28 s15657c27f0;
  ::S10296C36_nt s15657c27f1;
  void  mf15657c27(); // _ZN9S15657C2710mf15657c27Ev
};
//SIG(-1 S15657C27) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL[2]}}} FC14{ BC7 FC15{ m FC16{ m FL}}} FC17{ BC7 Fi} FC14 FC17 FC14 FC17 FC14 FC17 FC14 FC17 FC14 FC17 FC14 FC17 FC14 FC17 FC14 FC17 FC14 FC17 FC14 FC17 FC14 FC17 FC14 FC17} FC18{ BC19{ BC20{ vd v13} vd v14 Fp[2] FC21{ m FC22{ m Fp Fi[2] FC23{ m}}} FC24{ m Fp[2]}} vd FC25{ m Fp Fi FC26{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC24}}}


void  S15657C27 ::mf15657c27(){}

static void Test_S15657C27()
{
  {
    init_simple_test("S15657C27");
    static S15657C27 lv;
    check2(sizeof(lv), ABISELECT(1288,824), "sizeof(S15657C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15657C27)");
    check_field_offset(lv, s15657c27f0, 0, "S15657C27.s15657c27f0");
    check_field_offset(lv, s15657c27f1, ABISELECT(1184,764), "S15657C27.s15657c27f1");
  }
}
static Arrange_To_Call_Me vS15657C27(Test_S15657C27, "S15657C27", ABISELECT(1288,824));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15657C1  {
  ::S15657C2 s15657c1f0;
  ::S15657C27 s15657c1f1;
  void  mf15657c1(); // _ZN8S15657C19mf15657c1Ev
};
//SIG(1 S15657C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC10} FC13{ BC8 FC14{ m FC15{ m FL}}}} FC16{ BC17{ BC18{ vd v13} vd v14 Fp[2] FC19{ m FC20{ m Fp Fi[2] FC21{ m}}} FC22{ m Fp[2]}} vd FC23{ m FC24{ Fs[2] Fc[2] Fs}[12] Fi FC25{ Fs[2]}[4] Fi FC26{ m Fp[2]}}}} FC27{ m FC28{ BC4 BC6 v15 v16 v17 v18 v19 v20 FC29{ BC8 FC30{ m FC31{ m Fp[2]} FC32{ m Fp}}} FC12 FC13 FC33{ BC8 Fi} FC13 FC33 FC13 FC33 FC13 FC33 FC13 FC33 FC13 FC33 FC13 FC33 FC13 FC33 FC13 FC33 FC13 FC33 FC13 FC33 FC13 FC33 FC13 FC33} FC34{ BC35{ BC18 vd v21 Fp[2] FC19 FC26} vd FC36{ m Fp Fi FC37{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC26}}}}


void  S15657C1 ::mf15657c1(){}

static void Test_S15657C1()
{
  {
    init_simple_test("S15657C1");
    static S15657C1 lv;
    check2(sizeof(lv), ABISELECT(1712,1156), "sizeof(S15657C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15657C1)");
    check_field_offset(lv, s15657c1f0, 0, "S15657C1.s15657c1f0");
    check_field_offset(lv, s15657c1f1, ABISELECT(424,332), "S15657C1.s15657c1f1");
  }
}
static Arrange_To_Call_Me vS15657C1(Test_S15657C1, "S15657C1", ABISELECT(1712,1156));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15056C8_nt  {
  ::S10296C48 s15056c8f0;
  int s15056c8f1;
  void  mf15056c8(); // _ZN11S15056C8_nt9mf15056c8Ev
};
//SIG(-1 S15056C8_nt) C1{ m FC2{ m Fp[2]} Fi}


void  S15056C8_nt ::mf15056c8(){}

//skip512 S15056C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15056C2_nt  {
  int s15056c2f0[3];
  ::S10296C7_nt s15056c2f1;
  int s15056c2f2[3];
  char s15056c2f3;
  void *s15056c2f4;
  ::S9624C14_nt s15056c2f5;
  char s15056c2f6;
  ::S15056C8_nt s15056c2f7;
  void  mf15056c2(); // _ZN11S15056C2_nt9mf15056c2Ev
};
//SIG(-1 S15056C2_nt) C1{ m Fi[3] FC2{ m FC3{ m Fp[2]} FC4{ m Fp[2]}} Fi[3] Fc Fp FC5{ m Fp Fi FC6{ m}} Fc FC7{ m FC8{ m Fp[2]} Fi}}


void  S15056C2_nt ::mf15056c2(){}

//skip512 S15056C2_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15056C13  {
  ::S10296C14_nt s15056c13f0;
  virtual  ~S15056C13(); // _ZN9S15056C13D1Ev
  virtual void  v7(); // _ZN9S15056C132v7Ev
  virtual void  v8(); // _ZN9S15056C132v8Ev
  virtual void  v9(); // _ZN9S15056C132v9Ev
  virtual void  v10(); // _ZN9S15056C133v10Ev
  virtual void  v11(); // _ZN9S15056C133v11Ev
  virtual void  v12(); // _ZN9S15056C133v12Ev
  S15056C13(); // tgen
};
//SIG(-1 S15056C13) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15056C13 ::~S15056C13(){ note_dtor("S15056C13", this);}
void  S15056C13 ::v7(){vfunc_called(this, "_ZN9S15056C132v7Ev");}
void  S15056C13 ::v8(){vfunc_called(this, "_ZN9S15056C132v8Ev");}
void  S15056C13 ::v9(){vfunc_called(this, "_ZN9S15056C132v9Ev");}
void  S15056C13 ::v10(){vfunc_called(this, "_ZN9S15056C133v10Ev");}
void  S15056C13 ::v11(){vfunc_called(this, "_ZN9S15056C133v11Ev");}
void  S15056C13 ::v12(){vfunc_called(this, "_ZN9S15056C133v12Ev");}
S15056C13 ::S15056C13(){ note_ctor("S15056C13", this);} // tgen

static void Test_S15056C13()
{
  extern Class_Descriptor cd_S15056C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15056C13, buf);
    S15056C13 *dp, &lv = *(dp=new (buf) S15056C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15056C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15056C13)");
    check_field_offset(lv, s15056c13f0, ABISELECT(8,4), "S15056C13.s15056c13f0");
    test_class_info(&lv, &cd_S15056C13);
    dp->~S15056C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15056C13(Test_S15056C13, "S15056C13", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN9S15056C13C1Ev();
extern void _ZN9S15056C13D1Ev();
Name_Map name_map_S15056C13[] = {
  NSPAIR(_ZN9S15056C13C1Ev),
  NSPAIR(_ZN9S15056C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S15056C13[];
extern void _ZN9S15056C13D1Ev();
extern void _ZN9S15056C13D0Ev();
extern void _ZN9S15056C132v7Ev();
extern void _ZN9S15056C132v8Ev();
extern void _ZN9S15056C132v9Ev();
extern void _ZN9S15056C133v10Ev();
extern void _ZN9S15056C133v11Ev();
extern void _ZN9S15056C133v12Ev();
static  VTBL_ENTRY vtc_S15056C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15056C13[0]),
  (VTBL_ENTRY)&_ZN9S15056C13D1Ev,
  (VTBL_ENTRY)&_ZN9S15056C13D0Ev,
  (VTBL_ENTRY)&_ZN9S15056C132v7Ev,
  (VTBL_ENTRY)&_ZN9S15056C132v8Ev,
  (VTBL_ENTRY)&_ZN9S15056C132v9Ev,
  (VTBL_ENTRY)&_ZN9S15056C133v10Ev,
  (VTBL_ENTRY)&_ZN9S15056C133v11Ev,
  (VTBL_ENTRY)&_ZN9S15056C133v12Ev,
};
extern VTBL_ENTRY _ZTI9S15056C13[];
extern  VTBL_ENTRY _ZTV9S15056C13[];
Class_Descriptor cd_S15056C13 = {  "S15056C13", // class name
  0,0,//no base classes
  &(vtc_S15056C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI9S15056C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S15056C13),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15056C12  : S15056C13 , S10296C15_nt {
  ::S10296C21_nt s15056c12f0;
  ::S10296C16_nt s15056c12f1;
  virtual void  v1(); // _ZN9S15056C122v1Ev
  virtual void  v2(); // _ZN9S15056C122v2Ev
  virtual void  v3(); // _ZN9S15056C122v3Ev
  virtual void  v4(); // _ZN9S15056C122v4Ev
  virtual void  v5(); // _ZN9S15056C122v5Ev
  virtual void  v6(); // _ZN9S15056C122v6Ev
  ~S15056C12(); // tgen
  S15056C12(); // tgen
};
//SIG(-1 S15056C12) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FL[2]}}} FC9{ BC6 FC10{ m FC7 FC7 FC7 FC7}}}


void  S15056C12 ::v1(){vfunc_called(this, "_ZN9S15056C122v1Ev");}
void  S15056C12 ::v2(){vfunc_called(this, "_ZN9S15056C122v2Ev");}
void  S15056C12 ::v3(){vfunc_called(this, "_ZN9S15056C122v3Ev");}
void  S15056C12 ::v4(){vfunc_called(this, "_ZN9S15056C122v4Ev");}
void  S15056C12 ::v5(){vfunc_called(this, "_ZN9S15056C122v5Ev");}
void  S15056C12 ::v6(){vfunc_called(this, "_ZN9S15056C122v6Ev");}
S15056C12 ::~S15056C12(){ note_dtor("S15056C12", this);} // tgen
S15056C12 ::S15056C12(){ note_ctor("S15056C12", this);} // tgen

static void Test_S15056C12()
{
  extern Class_Descriptor cd_S15056C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,36)];
    init_test(&cd_S15056C12, buf);
    S15056C12 *dp, &lv = *(dp=new (buf) S15056C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,140), "sizeof(S15056C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15056C12)");
    check_base_class_offset(lv, (S15056C13*), 0, "S15056C12");
    check_base_class_offset(lv, (S10296C15_nt*), 0, "S15056C12");
    check_field_offset(lv, s15056c12f0, ABISELECT(40,20), "S15056C12.s15056c12f0");
    check_field_offset(lv, s15056c12f1, ABISELECT(88,56), "S15056C12.s15056c12f1");
    test_class_info(&lv, &cd_S15056C12);
    dp->~S15056C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15056C12(Test_S15056C12, "S15056C12", ABISELECT(184,140));

#else // __cplusplus

extern void _ZN9S15056C12C1Ev();
extern void _ZN9S15056C12D1Ev();
Name_Map name_map_S15056C12[] = {
  NSPAIR(_ZN9S15056C12C1Ev),
  NSPAIR(_ZN9S15056C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15056C13;
extern VTBL_ENTRY _ZTI9S15056C13[];
extern  VTBL_ENTRY _ZTV9S15056C13[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S15056C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15056C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15056C12[];
extern void _ZN9S15056C12D1Ev();
extern void _ZN9S15056C12D0Ev();
extern void _ZN9S15056C132v7Ev();
extern void _ZN9S15056C132v8Ev();
extern void _ZN9S15056C132v9Ev();
extern void _ZN9S15056C133v10Ev();
extern void _ZN9S15056C133v11Ev();
extern void _ZN9S15056C133v12Ev();
extern void _ZN9S15056C122v1Ev();
extern void _ZN9S15056C122v2Ev();
extern void _ZN9S15056C122v3Ev();
extern void _ZN9S15056C122v4Ev();
extern void _ZN9S15056C122v5Ev();
extern void _ZN9S15056C122v6Ev();
static  VTBL_ENTRY vtc_S15056C12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15056C12[0]),
  (VTBL_ENTRY)&_ZN9S15056C12D1Ev,
  (VTBL_ENTRY)&_ZN9S15056C12D0Ev,
  (VTBL_ENTRY)&_ZN9S15056C132v7Ev,
  (VTBL_ENTRY)&_ZN9S15056C132v8Ev,
  (VTBL_ENTRY)&_ZN9S15056C132v9Ev,
  (VTBL_ENTRY)&_ZN9S15056C133v10Ev,
  (VTBL_ENTRY)&_ZN9S15056C133v11Ev,
  (VTBL_ENTRY)&_ZN9S15056C133v12Ev,
  (VTBL_ENTRY)&_ZN9S15056C122v1Ev,
  (VTBL_ENTRY)&_ZN9S15056C122v2Ev,
  (VTBL_ENTRY)&_ZN9S15056C122v3Ev,
  (VTBL_ENTRY)&_ZN9S15056C122v4Ev,
  (VTBL_ENTRY)&_ZN9S15056C122v5Ev,
  (VTBL_ENTRY)&_ZN9S15056C122v6Ev,
};
extern VTBL_ENTRY _ZTI9S15056C12[];
extern  VTBL_ENTRY _ZTV9S15056C12[];
Class_Descriptor cd_S15056C12 = {  "S15056C12", // class name
  bases_S15056C12, 2,
  &(vtc_S15056C12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,140), // object size
  NSPAIRA(_ZTI9S15056C12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15056C12),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15056C11  {
  ::S15056C12 s15056c11f0;
  ::S10296C22_nt s15056c11f1;
  void  mf15056c11(); // _ZN9S15056C1110mf15056c11Ev
};
//SIG(-1 S15056C11) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FL[2]}}} FC10{ BC7 FC11{ m FC8 FC8 FC8 FC8}}} FC12{ BC13{ BC14{ vd v13} vd v14 Fp[2] FC15{ m FC16{ m Fp Fi[2] FC17{ m}}} FC18{ m Fp[2]}} vd FC19{ m FC20{ Fs[2] Fc[2] Fs}[12] Fi FC21{ Fs[2]}[4] Fi FC22{ m Fp[2]}}}}


void  S15056C11 ::mf15056c11(){}

static void Test_S15056C11()
{
  {
    init_simple_test("S15056C11");
    S15056C11 lv;
    check2(sizeof(lv), ABISELECT(384,304), "sizeof(S15056C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15056C11)");
    check_field_offset(lv, s15056c11f0, 0, "S15056C11.s15056c11f0");
    check_field_offset(lv, s15056c11f1, ABISELECT(184,140), "S15056C11.s15056c11f1");
  }
}
static Arrange_To_Call_Me vS15056C11(Test_S15056C11, "S15056C11", ABISELECT(384,304));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15056C10  {
  ::S15056C11 s15056c10f0;
  ::S10296C33_nt s15056c10f1;
  void  mf15056c10(); // _ZN9S15056C1010mf15056c10Ev
};
//SIG(-1 S15056C10) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FL[2]}}} FC11{ BC8 FC12{ m FC9 FC9 FC9 FC9}}} FC13{ BC14{ BC15{ vd v13} vd v14 Fp[2] FC16{ m FC17{ m Fp Fi[2] FC18{ m}}} FC19{ m Fp[2]}} vd FC20{ m FC21{ Fs[2] Fc[2] Fs}[12] Fi FC22{ Fs[2]}[4] Fi FC23{ m Fp[2]}}}} FC24{ m FC25{ BC26{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC27{ BC8 FC28{ m FC29{ m Fp[2]} FC30{ m Fp}}}} FC31{ BC32{ BC15 vd v27 Fp[2] FC16 FC23} vd FC33{ m Fp Fi FC34{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC23}}}}


void  S15056C10 ::mf15056c10(){}

static void Test_S15056C10()
{
  {
    init_simple_test("S15056C10");
    static S15056C10 lv;
    check2(sizeof(lv), ABISELECT(584,416), "sizeof(S15056C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15056C10)");
    check_field_offset(lv, s15056c10f0, 0, "S15056C10.s15056c10f0");
    check_field_offset(lv, s15056c10f1, ABISELECT(384,304), "S15056C10.s15056c10f1");
  }
}
static Arrange_To_Call_Me vS15056C10(Test_S15056C10, "S15056C10", ABISELECT(584,416));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15056C1  {
  char s15056c1f0;
  ::S15056C2_nt s15056c1f1;
  int s15056c1f2;
  ::S15056C10 s15056c1f3;
  ::S10296C32 s15056c1f4;
  void  mf15056c1(); // _ZN8S15056C19mf15056c1Ev
};
//SIG(1 S15056C1) C1{ m Fc FC2{ m Fi[3] FC3{ m FC4{ m Fp[2]} FC5{ m Fp[2]}} Fi[3] Fc Fp FC6{ m Fp Fi FC7{ m}} Fc FC8{ m FC9{ m Fp[2]} Fi}} Fi FC10{ m FC11{ m FC12{ BC13{ vd v7 v8 v9 v10 v11 v12 FC14{ m Fp[4]}} BC15{} v1 v2 v3 v4 v5 v6 FC16{ BC17{ m Fp Fi Fp Fi[2]} FC18{ m FC19{ m FL[2]}}} FC20{ BC17 FC21{ m FC18 FC18 FC18 FC18}}} FC22{ BC23{ BC24{ vd v13} vd v14 Fp[2] FC25{ m FC26{ m Fp Fi[2] FC27{ m}}} FC5} vd FC28{ m FC29{ Fs[2] Fc[2] Fs}[12] Fi FC30{ Fs[2]}[4] Fi FC31{ m Fp[2]}}}} FC32{ m FC33{ BC34{ vd v21 v22 v23 v24 v25 v26 FC14} BC15 v15 v16 v17 v18 v19 v20 FC35{ BC17 FC36{ m FC4 FC37{ m Fp}}}} FC38{ BC39{ BC24 vd v27 Fp[2] FC25 FC31} vd FC40{ m Fp Fi FC41{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC31}}}} FC31}


void  S15056C1 ::mf15056c1(){}

static void Test_S15056C1()
{
  {
    init_simple_test("S15056C1");
    static S15056C1 lv;
    check2(sizeof(lv), ABISELECT(736,508), "sizeof(S15056C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15056C1)");
    check_field_offset(lv, s15056c1f0, 0, "S15056C1.s15056c1f0");
    check_field_offset(lv, s15056c1f1, ABISELECT(8,4), "S15056C1.s15056c1f1");
    check_field_offset(lv, s15056c1f2, ABISELECT(128,80), "S15056C1.s15056c1f2");
    check_field_offset(lv, s15056c1f3, ABISELECT(136,84), "S15056C1.s15056c1f3");
    check_field_offset(lv, s15056c1f4, ABISELECT(720,500), "S15056C1.s15056c1f4");
  }
}
static Arrange_To_Call_Me vS15056C1(Test_S15056C1, "S15056C1", ABISELECT(736,508));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16242C43  {
  ::S10296C3_nt s16242c43f0;
  ::S10296C7_nt s16242c43f1;
  int s16242c43f2[3];
  void  mf16242c43(); // _ZN9S16242C4310mf16242c43Ev
};
//SIG(1 S16242C43) C1{ m FC2{ m FC3{ m Fp[2]} FC4{ m Fp}} FC5{ m FC3 FC6{ m Fp[2]}} Fi[3]}


void  S16242C43 ::mf16242c43(){}

static void Test_S16242C43()
{
  {
    init_simple_test("S16242C43");
    S16242C43 lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S16242C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16242C43)");
    check_field_offset(lv, s16242c43f0, 0, "S16242C43.s16242c43f0");
    check_field_offset(lv, s16242c43f1, ABISELECT(24,12), "S16242C43.s16242c43f1");
    check_field_offset(lv, s16242c43f2, ABISELECT(56,28), "S16242C43.s16242c43f2");
  }
}
static Arrange_To_Call_Me vS16242C43(Test_S16242C43, "S16242C43", ABISELECT(72,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16242C42  {
  ::S16242C43 s16242c42f0[6];
  ::S9624C14_nt s16242c42f1;
  void  mf16242c42(); // _ZN9S16242C4210mf16242c42Ev
};
//SIG(-1 S16242C42) C1{ m FC2{ m FC3{ m FC4{ m Fp[2]} FC5{ m Fp}} FC6{ m FC4 FC7{ m Fp[2]}} Fi[3]}[6] FC8{ m Fp Fi FC9{ m}}}


void  S16242C42 ::mf16242c42(){}

static void Test_S16242C42()
{
  {
    init_simple_test("S16242C42");
    S16242C42 lv;
    check2(sizeof(lv), ABISELECT(448,252), "sizeof(S16242C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16242C42)");
    check_field_offset(lv, s16242c42f0, 0, "S16242C42.s16242c42f0");
    check_field_offset(lv, s16242c42f1, ABISELECT(432,240), "S16242C42.s16242c42f1");
  }
}
static Arrange_To_Call_Me vS16242C42(Test_S16242C42, "S16242C42", ABISELECT(448,252));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16242C4  {
  ::S15056C10 s16242c4f0;
  ::S16242C42 s16242c4f1;
  void  mf16242c4(); // _ZN8S16242C49mf16242c4Ev
};
//SIG(-1 S16242C4) C1{ m FC2{ m FC3{ m FC4{ BC5{ vd v7 v8 v9 v10 v11 v12 FC6{ m Fp[4]}} BC7{} v1 v2 v3 v4 v5 v6 FC8{ BC9{ m Fp Fi Fp Fi[2]} FC10{ m FC11{ m FL[2]}}} FC12{ BC9 FC13{ m FC10 FC10 FC10 FC10}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m FC22{ Fs[2] Fc[2] Fs}[12] Fi FC23{ Fs[2]}[4] Fi FC24{ m Fp[2]}}}} FC25{ m FC26{ BC27{ vd v21 v22 v23 v24 v25 v26 FC6} BC7 v15 v16 v17 v18 v19 v20 FC28{ BC9 FC29{ m FC30{ m Fp[2]} FC31{ m Fp}}}} FC32{ BC33{ BC16 vd v27 Fp[2] FC17 FC24} vd FC34{ m Fp Fi FC35{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC24}}}} FC36{ m FC37{ m FC29 FC38{ m FC30 FC20} Fi[3]}[6] FC39{ m Fp Fi FC40{ m}}}}


void  S16242C4 ::mf16242c4(){}

static void Test_S16242C4()
{
  {
    init_simple_test("S16242C4");
    static S16242C4 lv;
    check2(sizeof(lv), ABISELECT(1032,668), "sizeof(S16242C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16242C4)");
    check_field_offset(lv, s16242c4f0, 0, "S16242C4.s16242c4f0");
    check_field_offset(lv, s16242c4f1, ABISELECT(584,416), "S16242C4.s16242c4f1");
  }
}
static Arrange_To_Call_Me vS16242C4(Test_S16242C4, "S16242C4", ABISELECT(1032,668));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16242C1  {
  ::S9624C14_nt s16242c1f0;
  ::S16242C4 s16242c1f1;
  ::S10296C3_nt s16242c1f2;
  void  mf16242c1(); // _ZN8S16242C19mf16242c1Ev
};
//SIG(1 S16242C1) C1{ m FC2{ m Fp Fi FC3{ m}} FC4{ m FC5{ m FC6{ m FC7{ BC8{ vd v7 v8 v9 v10 v11 v12 FC9{ m Fp[4]}} BC10{} v1 v2 v3 v4 v5 v6 FC11{ BC12{ m Fp Fi Fp Fi[2]} FC13{ m FC14{ m FL[2]}}} FC15{ BC12 FC16{ m FC13 FC13 FC13 FC13}}} FC17{ BC18{ BC19{ vd v13} vd v14 Fp[2] FC20{ m FC21{ m Fp Fi[2] FC22{ m}}} FC23{ m Fp[2]}} vd FC24{ m FC25{ Fs[2] Fc[2] Fs}[12] Fi FC26{ Fs[2]}[4] Fi FC27{ m Fp[2]}}}} FC28{ m FC29{ BC30{ vd v21 v22 v23 v24 v25 v26 FC9} BC10 v15 v16 v17 v18 v19 v20 FC31{ BC12 FC32{ m FC33{ m Fp[2]} FC34{ m Fp}}}} FC35{ BC36{ BC19 vd v27 Fp[2] FC20 FC27} vd FC37{ m Fp Fi FC38{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC27}}}} FC39{ m FC40{ m FC32 FC41{ m FC33 FC23} Fi[3]}[6] FC2}} FC32}


void  S16242C1 ::mf16242c1(){}

static void Test_S16242C1()
{
  {
    init_simple_test("S16242C1");
    static S16242C1 lv;
    check2(sizeof(lv), ABISELECT(1072,692), "sizeof(S16242C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16242C1)");
    check_field_offset(lv, s16242c1f0, 0, "S16242C1.s16242c1f0");
    check_field_offset(lv, s16242c1f1, ABISELECT(16,12), "S16242C1.s16242c1f1");
    check_field_offset(lv, s16242c1f2, ABISELECT(1048,680), "S16242C1.s16242c1f2");
  }
}
static Arrange_To_Call_Me vS16242C1(Test_S16242C1, "S16242C1", ABISELECT(1072,692));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C2_nt  {
  ::S9624C14_nt s9857c2f0;
  int s9857c2f1[2];
  char s9857c2f2;
  virtual  ~S9857C2_nt(); // _ZN10S9857C2_ntD1Ev
  virtual void  v5(); // _ZN10S9857C2_nt2v5Ev
  virtual void  v6(); // _ZN10S9857C2_nt2v6Ev
  virtual void  v7(); // _ZN10S9857C2_nt2v7Ev
  S9857C2_nt(); // tgen
};
//SIG(-1 S9857C2_nt) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S9857C2_nt ::~S9857C2_nt(){ note_dtor("S9857C2_nt", this);}
void  S9857C2_nt ::v5(){vfunc_called(this, "_ZN10S9857C2_nt2v5Ev");}
void  S9857C2_nt ::v6(){vfunc_called(this, "_ZN10S9857C2_nt2v6Ev");}
void  S9857C2_nt ::v7(){vfunc_called(this, "_ZN10S9857C2_nt2v7Ev");}
S9857C2_nt ::S9857C2_nt(){ note_ctor("S9857C2_nt", this);} // tgen

//skip512 S9857C2_nt

#else // __cplusplus

extern void _ZN10S9857C2_ntC1Ev();
extern void _ZN10S9857C2_ntD1Ev();
Name_Map name_map_S9857C2_nt[] = {
  NSPAIR(_ZN10S9857C2_ntC1Ev),
  NSPAIR(_ZN10S9857C2_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S9857C2_nt[];
extern void _ZN10S9857C2_ntD1Ev();
extern void _ZN10S9857C2_ntD0Ev();
extern void _ZN10S9857C2_nt2v5Ev();
extern void _ZN10S9857C2_nt2v6Ev();
extern void _ZN10S9857C2_nt2v7Ev();
static  VTBL_ENTRY vtc_S9857C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9857C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S9857C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9857C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S9857C2_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S9857C2_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S9857C2_nt2v7Ev,
};
extern VTBL_ENTRY _ZTI10S9857C2_nt[];
VTBL_ENTRY *P__ZTI10S9857C2_nt = _ZTI10S9857C2_nt; 
extern  VTBL_ENTRY _ZTV10S9857C2_nt[];
Class_Descriptor cd_S9857C2_nt = {  "S9857C2_nt", // class name
  0,0,//no base classes
  &(vtc_S9857C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI10S9857C2_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S9857C2_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C6  {
  virtual  ~S9857C6(); // _ZN7S9857C6D1Ev
  virtual void  v8(); // _ZN7S9857C62v8Ev
  virtual void  v9(); // _ZN7S9857C62v9Ev
  virtual void  v10(); // _ZN7S9857C63v10Ev
  S9857C6(); // tgen
};
//SIG(-1 S9857C6) C1{ vd v1 v2 v3}


 S9857C6 ::~S9857C6(){ note_dtor("S9857C6", this);}
void  S9857C6 ::v8(){vfunc_called(this, "_ZN7S9857C62v8Ev");}
void  S9857C6 ::v9(){vfunc_called(this, "_ZN7S9857C62v9Ev");}
void  S9857C6 ::v10(){vfunc_called(this, "_ZN7S9857C63v10Ev");}
S9857C6 ::S9857C6(){ note_ctor("S9857C6", this);} // tgen

static void Test_S9857C6()
{
  extern Class_Descriptor cd_S9857C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9857C6, buf);
    S9857C6 *dp, &lv = *(dp=new (buf) S9857C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9857C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9857C6)");
    test_class_info(&lv, &cd_S9857C6);
    dp->~S9857C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9857C6(Test_S9857C6, "S9857C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9857C6C1Ev();
extern void _ZN7S9857C6D1Ev();
Name_Map name_map_S9857C6[] = {
  NSPAIR(_ZN7S9857C6C1Ev),
  NSPAIR(_ZN7S9857C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9857C6[];
extern void _ZN7S9857C6D1Ev();
extern void _ZN7S9857C6D0Ev();
extern void _ZN7S9857C62v8Ev();
extern void _ZN7S9857C62v9Ev();
extern void _ZN7S9857C63v10Ev();
static  VTBL_ENTRY vtc_S9857C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9857C6[0]),
  (VTBL_ENTRY)&_ZN7S9857C6D1Ev,
  (VTBL_ENTRY)&_ZN7S9857C6D0Ev,
  (VTBL_ENTRY)&_ZN7S9857C62v8Ev,
  (VTBL_ENTRY)&_ZN7S9857C62v9Ev,
  (VTBL_ENTRY)&_ZN7S9857C63v10Ev,
};
extern VTBL_ENTRY _ZTI7S9857C6[];
extern  VTBL_ENTRY _ZTV7S9857C6[];
Class_Descriptor cd_S9857C6 = {  "S9857C6", // class name
  0,0,//no base classes
  &(vtc_S9857C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9857C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9857C6),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C5  : S9857C6 {
  ::S9624C35 s9857c5f0;
  ::S9625C9_nt s9857c5f1;
  char s9857c5f2;
  virtual  ~S9857C5(); // _ZN7S9857C5D1Ev
  virtual void  v11(); // _ZN7S9857C53v11Ev
  virtual void  v12(); // _ZN7S9857C53v12Ev
  virtual void  v13(); // _ZN7S9857C53v13Ev
  S9857C5(); // tgen
};
//SIG(-1 S9857C5) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ FL[4]}} Fc}


 S9857C5 ::~S9857C5(){ note_dtor("S9857C5", this);}
void  S9857C5 ::v11(){vfunc_called(this, "_ZN7S9857C53v11Ev");}
void  S9857C5 ::v12(){vfunc_called(this, "_ZN7S9857C53v12Ev");}
void  S9857C5 ::v13(){vfunc_called(this, "_ZN7S9857C53v13Ev");}
S9857C5 ::S9857C5(){ note_ctor("S9857C5", this);} // tgen

static void Test_S9857C5()
{
  extern Class_Descriptor cd_S9857C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S9857C5, buf);
    S9857C5 *dp, &lv = *(dp=new (buf) S9857C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S9857C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9857C5)");
    check_base_class_offset(lv, (S9857C6*), 0, "S9857C5");
    check_field_offset(lv, s9857c5f0, ABISELECT(8,4), "S9857C5.s9857c5f0");
    check_field_offset(lv, s9857c5f1, ABISELECT(32,20), "S9857C5.s9857c5f1");
    check_field_offset(lv, s9857c5f2, ABISELECT(64,52), "S9857C5.s9857c5f2");
    test_class_info(&lv, &cd_S9857C5);
    dp->~S9857C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9857C5(Test_S9857C5, "S9857C5", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S9857C5C1Ev();
extern void _ZN7S9857C5D1Ev();
Name_Map name_map_S9857C5[] = {
  NSPAIR(_ZN7S9857C5C1Ev),
  NSPAIR(_ZN7S9857C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9857C6;
extern VTBL_ENTRY _ZTI7S9857C6[];
extern  VTBL_ENTRY _ZTV7S9857C6[];
static Base_Class bases_S9857C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9857C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9857C5[];
extern void _ZN7S9857C5D1Ev();
extern void _ZN7S9857C5D0Ev();
extern void _ZN7S9857C62v8Ev();
extern void _ZN7S9857C62v9Ev();
extern void _ZN7S9857C63v10Ev();
extern void _ZN7S9857C53v11Ev();
extern void _ZN7S9857C53v12Ev();
extern void _ZN7S9857C53v13Ev();
static  VTBL_ENTRY vtc_S9857C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9857C5[0]),
  (VTBL_ENTRY)&_ZN7S9857C5D1Ev,
  (VTBL_ENTRY)&_ZN7S9857C5D0Ev,
  (VTBL_ENTRY)&_ZN7S9857C62v8Ev,
  (VTBL_ENTRY)&_ZN7S9857C62v9Ev,
  (VTBL_ENTRY)&_ZN7S9857C63v10Ev,
  (VTBL_ENTRY)&_ZN7S9857C53v11Ev,
  (VTBL_ENTRY)&_ZN7S9857C53v12Ev,
  (VTBL_ENTRY)&_ZN7S9857C53v13Ev,
};
extern VTBL_ENTRY _ZTI7S9857C5[];
extern  VTBL_ENTRY _ZTV7S9857C5[];
Class_Descriptor cd_S9857C5 = {  "S9857C5", // class name
  bases_S9857C5, 1,
  &(vtc_S9857C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S9857C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9857C5),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C11  {
  virtual  ~S9857C11(); // _ZN8S9857C11D1Ev
  virtual void  v14(); // _ZN8S9857C113v14Ev
  S9857C11(); // tgen
};
//SIG(-1 S9857C11) C1{ vd v1}


 S9857C11 ::~S9857C11(){ note_dtor("S9857C11", this);}
void  S9857C11 ::v14(){vfunc_called(this, "_ZN8S9857C113v14Ev");}
S9857C11 ::S9857C11(){ note_ctor("S9857C11", this);} // tgen

static void Test_S9857C11()
{
  extern Class_Descriptor cd_S9857C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9857C11, buf);
    S9857C11 *dp, &lv = *(dp=new (buf) S9857C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9857C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9857C11)");
    test_class_info(&lv, &cd_S9857C11);
    dp->~S9857C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9857C11(Test_S9857C11, "S9857C11", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9857C11C1Ev();
extern void _ZN8S9857C11D1Ev();
Name_Map name_map_S9857C11[] = {
  NSPAIR(_ZN8S9857C11C1Ev),
  NSPAIR(_ZN8S9857C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9857C11[];
extern void _ZN8S9857C11D1Ev();
extern void _ZN8S9857C11D0Ev();
extern void _ZN8S9857C113v14Ev();
static  VTBL_ENTRY vtc_S9857C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9857C11[0]),
  (VTBL_ENTRY)&_ZN8S9857C11D1Ev,
  (VTBL_ENTRY)&_ZN8S9857C11D0Ev,
  (VTBL_ENTRY)&_ZN8S9857C113v14Ev,
};
extern VTBL_ENTRY _ZTI8S9857C11[];
extern  VTBL_ENTRY _ZTV8S9857C11[];
Class_Descriptor cd_S9857C11 = {  "S9857C11", // class name
  0,0,//no base classes
  &(vtc_S9857C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9857C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9857C11),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C15  {
  virtual  ~S9857C15(); // _ZN8S9857C15D1Ev
  virtual void  v16(); // _ZN8S9857C153v16Ev
  virtual void  v17(); // _ZN8S9857C153v17Ev
  S9857C15(); // tgen
};
//SIG(-1 S9857C15) C1{ vd v1 v2}


 S9857C15 ::~S9857C15(){ note_dtor("S9857C15", this);}
void  S9857C15 ::v16(){vfunc_called(this, "_ZN8S9857C153v16Ev");}
void  S9857C15 ::v17(){vfunc_called(this, "_ZN8S9857C153v17Ev");}
S9857C15 ::S9857C15(){ note_ctor("S9857C15", this);} // tgen

static void Test_S9857C15()
{
  extern Class_Descriptor cd_S9857C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9857C15, buf);
    S9857C15 *dp, &lv = *(dp=new (buf) S9857C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9857C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9857C15)");
    test_class_info(&lv, &cd_S9857C15);
    dp->~S9857C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9857C15(Test_S9857C15, "S9857C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9857C15C1Ev();
extern void _ZN8S9857C15D1Ev();
Name_Map name_map_S9857C15[] = {
  NSPAIR(_ZN8S9857C15C1Ev),
  NSPAIR(_ZN8S9857C15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9857C15[];
extern void _ZN8S9857C15D1Ev();
extern void _ZN8S9857C15D0Ev();
extern void _ZN8S9857C153v16Ev();
extern void _ZN8S9857C153v17Ev();
static  VTBL_ENTRY vtc_S9857C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9857C15[0]),
  (VTBL_ENTRY)&_ZN8S9857C15D1Ev,
  (VTBL_ENTRY)&_ZN8S9857C15D0Ev,
  (VTBL_ENTRY)&_ZN8S9857C153v16Ev,
  (VTBL_ENTRY)&_ZN8S9857C153v17Ev,
};
extern VTBL_ENTRY _ZTI8S9857C15[];
extern  VTBL_ENTRY _ZTV8S9857C15[];
Class_Descriptor cd_S9857C15 = {  "S9857C15", // class name
  0,0,//no base classes
  &(vtc_S9857C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9857C15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9857C15),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C17  : S9857C15 {
  ::S9624C14_nt s9857c17f0;
  virtual  ~S9857C17(); // _ZN8S9857C17D1Ev
  virtual void  v19(); // _ZN8S9857C173v19Ev
  S9857C17(); // tgen
};
//SIG(-1 S9857C17) C1{ BC2{ vd v2 v3} vd v1 FC3{ m Fp Fi FC4{ m}}}


 S9857C17 ::~S9857C17(){ note_dtor("S9857C17", this);}
void  S9857C17 ::v19(){vfunc_called(this, "_ZN8S9857C173v19Ev");}
S9857C17 ::S9857C17(){ note_ctor("S9857C17", this);} // tgen

static void Test_S9857C17()
{
  extern Class_Descriptor cd_S9857C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S9857C17, buf);
    S9857C17 *dp, &lv = *(dp=new (buf) S9857C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S9857C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9857C17)");
    check_base_class_offset(lv, (S9857C15*), 0, "S9857C17");
    check_field_offset(lv, s9857c17f0, ABISELECT(8,4), "S9857C17.s9857c17f0");
    test_class_info(&lv, &cd_S9857C17);
    dp->~S9857C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9857C17(Test_S9857C17, "S9857C17", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S9857C17C1Ev();
extern void _ZN8S9857C17D1Ev();
Name_Map name_map_S9857C17[] = {
  NSPAIR(_ZN8S9857C17C1Ev),
  NSPAIR(_ZN8S9857C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9857C15;
extern VTBL_ENTRY _ZTI8S9857C15[];
extern  VTBL_ENTRY _ZTV8S9857C15[];
static Base_Class bases_S9857C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9857C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9857C17[];
extern void _ZN8S9857C17D1Ev();
extern void _ZN8S9857C17D0Ev();
extern void _ZN8S9857C153v16Ev();
extern void _ZN8S9857C153v17Ev();
extern void _ZN8S9857C173v19Ev();
static  VTBL_ENTRY vtc_S9857C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9857C17[0]),
  (VTBL_ENTRY)&_ZN8S9857C17D1Ev,
  (VTBL_ENTRY)&_ZN8S9857C17D0Ev,
  (VTBL_ENTRY)&_ZN8S9857C153v16Ev,
  (VTBL_ENTRY)&_ZN8S9857C153v17Ev,
  (VTBL_ENTRY)&_ZN8S9857C173v19Ev,
};
extern VTBL_ENTRY _ZTI8S9857C17[];
extern  VTBL_ENTRY _ZTV8S9857C17[];
Class_Descriptor cd_S9857C17 = {  "S9857C17", // class name
  bases_S9857C17, 1,
  &(vtc_S9857C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S9857C17),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9857C17),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C13  {
  ::S9625C16 s9857c13f0;
  ::S9624C12_nt s9857c13f1;
  ::S9857C17 s9857c13f2;
  ::S9857C17 s9857c13f3;
  ::S9857C17 s9857c13f4;
  ::S9857C17 s9857c13f5;
  ::S9624C33_nt s9857c13f6;
  ::S9624C20_nt s9857c13f7;
  ::S9624C32_nt s9857c13f8;
  int s9857c13f9;
  ::S9624C26 s9857c13f10;
  ::S9624C25 s9857c13f11;
  void  mf9857c13(); // _ZN8S9857C139mf9857c13Ev
};
//SIG(-1 S9857C13) C1{ m FC2{ BC3{ vd v2 v3} vd v1 FC4{ m Fp Fi FC5{ m}}} FC6{ BC7{ vd v5 v6} vd v4 FC4} FC8{ BC9{ vd v8 v9} vd v7 FC4} FC8 FC8 FC8 FC10{ BC7 vd v10 FC4 FC4 FC4} FC11{ BC7 vd v11 FC12{ vd v12 Fs[2] Fc[6] Fs[2] Fc[6] FC4} FC4 Fi[2] FC13{ vd v13 Fi} Fi[2]} FC14{ vd v14 Fi[2] Fs[2] Fi[3] FC4} Fi FC15{ BC7 vd v15 v16 FL} FC16{ BC7 vd v17 v18 Fi[5] FC15 FC17{ BC18{ m Fp Fi[2] FC19{ m}} BC7 vd v19 v20} FC4 FC20{ vd m FC21{ m Fs[6] Fi[2] Fc Fs}} FC20}}


void  S9857C13 ::mf9857c13(){}

static void Test_S9857C13()
{
  {
    init_simple_test("S9857C13");
    S9857C13 lv;
    check2(sizeof(lv), ABISELECT(536,392), "sizeof(S9857C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9857C13)");
    check_field_offset(lv, s9857c13f0, 0, "S9857C13.s9857c13f0");
    check_field_offset(lv, s9857c13f1, ABISELECT(24,16), "S9857C13.s9857c13f1");
    check_field_offset(lv, s9857c13f2, ABISELECT(48,32), "S9857C13.s9857c13f2");
    check_field_offset(lv, s9857c13f3, ABISELECT(72,48), "S9857C13.s9857c13f3");
    check_field_offset(lv, s9857c13f4, ABISELECT(96,64), "S9857C13.s9857c13f4");
    check_field_offset(lv, s9857c13f5, ABISELECT(120,80), "S9857C13.s9857c13f5");
    check_field_offset(lv, s9857c13f6, ABISELECT(144,96), "S9857C13.s9857c13f6");
    check_field_offset(lv, s9857c13f7, ABISELECT(200,136), "S9857C13.s9857c13f7");
    check_field_offset(lv, s9857c13f8, ABISELECT(304,212), "S9857C13.s9857c13f8");
    check_field_offset(lv, s9857c13f9, ABISELECT(352,252), "S9857C13.s9857c13f9");
    check_field_offset(lv, s9857c13f10, ABISELECT(360,256), "S9857C13.s9857c13f10");
    check_field_offset(lv, s9857c13f11, ABISELECT(376,268), "S9857C13.s9857c13f11");
  }
}
static Arrange_To_Call_Me vS9857C13(Test_S9857C13, "S9857C13", ABISELECT(536,392));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C33_nt  {
  ::S9625C10_nt s9857c33f0;
  void  mf9857c33(); // _ZN11S9857C33_nt9mf9857c33Ev
};
//SIG(-1 S9857C33_nt) C1{ m FC2{ FL[4]}}


void  S9857C33_nt ::mf9857c33(){}

//skip512 S9857C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C35_nt  {
  int s9857c35f0[4];
};
//SIG(-1 S9857C35_nt) C1{ Fi[4]}



//skip512 S9857C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C34_nt  {
  void *s9857c34f0;
  ::S9857C35_nt s9857c34f1;
  void  mf9857c34(); // _ZN11S9857C34_nt9mf9857c34Ev
};
//SIG(-1 S9857C34_nt) C1{ m Fp FC2{ Fi[4]}}


void  S9857C34_nt ::mf9857c34(){}

//skip512 S9857C34_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9857C1  : S9857C2_nt , S9857C5 , S9857C11 {
  void *s9857c1f0;
  int s9857c1f1;
  ::S10296C48 s9857c1f2;
  ::S9857C13 s9857c1f3;
  ::S9857C33_nt s9857c1f4;
  ::S9857C34_nt s9857c1f5;
  int s9857c1f6;
  virtual  ~S9857C1(); // _ZN7S9857C1D1Ev
  virtual void  v1(); // _ZN7S9857C12v1Ev
  virtual void  v2(); // _ZN7S9857C12v2Ev
  virtual void  v3(); // _ZN7S9857C12v3Ev
  virtual void  v4(); // _ZN7S9857C12v4Ev
  S9857C1(); // tgen
};
//SIG(1 S9857C1) C1{ BC2{ vd v5 v6 v7 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ BC6{ vd v8 v9 v10} vd v11 v12 v13 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FC10{ FL[4]}} Fc} BC11{ vd v14} vd v1 v2 v3 v4 Fp Fi FC12{ m Fp[2]} FC13{ m FC14{ BC15{ vd v16 v17} vd v15 FC3} FC16{ BC17{ vd v19 v20} vd v18 FC3} FC18{ BC19{ vd v22 v23} vd v21 FC3} FC18 FC18 FC18 FC20{ BC17 vd v24 FC3 FC3 FC3} FC21{ BC17 vd v25 FC22{ vd v26 Fs[2] Fc[6] Fs[2] Fc[6] FC3} FC3 Fi[2] FC23{ vd v27 Fi} Fi[2]} FC24{ vd v28 Fi[2] Fs[2] Fi[3] FC3} Fi FC25{ BC17 vd v29 v30 FL} FC26{ BC17 vd v31 v32 Fi[5] FC25 FC27{ BC28{ m Fp Fi[2] FC8} BC17 vd v33 v34} FC3 FC29{ vd m FC30{ m Fs[6] Fi[2] Fc Fs}} FC29}} FC31{ m FC10} FC32{ m Fp FC33{ Fi[4]}} Fi}


 S9857C1 ::~S9857C1(){ note_dtor("S9857C1", this);}
void  S9857C1 ::v1(){vfunc_called(this, "_ZN7S9857C12v1Ev");}
void  S9857C1 ::v2(){vfunc_called(this, "_ZN7S9857C12v2Ev");}
void  S9857C1 ::v3(){vfunc_called(this, "_ZN7S9857C12v3Ev");}
void  S9857C1 ::v4(){vfunc_called(this, "_ZN7S9857C12v4Ev");}
S9857C1 ::S9857C1(){ note_ctor("S9857C1", this);} // tgen

static void Test_S9857C1()
{
  extern Class_Descriptor cd_S9857C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(95,139)];
    init_test(&cd_S9857C1, buf);
    S9857C1 *dp, &lv = *(dp=new (buf) S9857C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(752,552), "sizeof(S9857C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9857C1)");
    check_base_class_offset(lv, (S9857C2_nt*), 0, "S9857C1");
    check_base_class_offset(lv, (S9857C6*)(S9857C5*), ABISELECT(40,28), "S9857C1");
    check_base_class_offset(lv, (S9857C5*), ABISELECT(40,28), "S9857C1");
    check_base_class_offset(lv, (S9857C11*), ABISELECT(112,84), "S9857C1");
    check_field_offset(lv, s9857c1f0, ABISELECT(120,88), "S9857C1.s9857c1f0");
    check_field_offset(lv, s9857c1f1, ABISELECT(128,92), "S9857C1.s9857c1f1");
    check_field_offset(lv, s9857c1f2, ABISELECT(136,96), "S9857C1.s9857c1f2");
    check_field_offset(lv, s9857c1f3, ABISELECT(152,104), "S9857C1.s9857c1f3");
    check_field_offset(lv, s9857c1f4, ABISELECT(688,496), "S9857C1.s9857c1f4");
    check_field_offset(lv, s9857c1f5, ABISELECT(720,528), "S9857C1.s9857c1f5");
    check_field_offset(lv, s9857c1f6, ABISELECT(744,548), "S9857C1.s9857c1f6");
    test_class_info(&lv, &cd_S9857C1);
    dp->~S9857C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9857C1(Test_S9857C1, "S9857C1", ABISELECT(752,552));

#else // __cplusplus

extern void _ZN7S9857C1C1Ev();
extern void _ZN7S9857C1D1Ev();
Name_Map name_map_S9857C1[] = {
  NSPAIR(_ZN7S9857C1C1Ev),
  NSPAIR(_ZN7S9857C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9857C2_nt;
extern VTBL_ENTRY _ZTI10S9857C2_nt[];
extern  VTBL_ENTRY _ZTV10S9857C2_nt[];
extern Class_Descriptor cd_S9857C6;
extern VTBL_ENTRY _ZTI7S9857C6[];
extern  VTBL_ENTRY _ZTV7S9857C6[];
extern Class_Descriptor cd_S9857C5;
extern VTBL_ENTRY _ZTI7S9857C5[];
extern  VTBL_ENTRY _ZTV7S9857C5[];
extern Class_Descriptor cd_S9857C11;
extern VTBL_ENTRY _ZTI8S9857C11[];
extern  VTBL_ENTRY _ZTV8S9857C11[];
static Base_Class bases_S9857C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9857C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9857C6,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S9857C5,    ABISELECT(40,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9857C11,    ABISELECT(112,84), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9857C1[];
extern void _ZN7S9857C1D1Ev();
extern void _ZN7S9857C1D0Ev();
extern void _ZN10S9857C2_nt2v5Ev();
extern void _ZN10S9857C2_nt2v6Ev();
extern void _ZN10S9857C2_nt2v7Ev();
extern void _ZN7S9857C12v1Ev();
extern void _ZN7S9857C12v2Ev();
extern void _ZN7S9857C12v3Ev();
extern void _ZN7S9857C12v4Ev();
extern void ABISELECT(_ZThn40_N7S9857C1D1Ev,_ZThn28_N7S9857C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S9857C1D0Ev,_ZThn28_N7S9857C1D0Ev)();
extern void _ZN7S9857C62v8Ev();
extern void _ZN7S9857C62v9Ev();
extern void _ZN7S9857C63v10Ev();
extern void _ZN7S9857C53v11Ev();
extern void _ZN7S9857C53v12Ev();
extern void _ZN7S9857C53v13Ev();
extern void ABISELECT(_ZThn112_N7S9857C1D1Ev,_ZThn84_N7S9857C1D1Ev)();
extern void ABISELECT(_ZThn112_N7S9857C1D0Ev,_ZThn84_N7S9857C1D0Ev)();
extern void _ZN8S9857C113v14Ev();
static  VTBL_ENTRY vtc_S9857C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9857C1[0]),
  (VTBL_ENTRY)&_ZN7S9857C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9857C1D0Ev,
  (VTBL_ENTRY)&_ZN10S9857C2_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S9857C2_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S9857C2_nt2v7Ev,
  (VTBL_ENTRY)&_ZN7S9857C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9857C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9857C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9857C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S9857C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S9857C1D1Ev,_ZThn28_N7S9857C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S9857C1D0Ev,_ZThn28_N7S9857C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9857C62v8Ev,
  (VTBL_ENTRY)&_ZN7S9857C62v9Ev,
  (VTBL_ENTRY)&_ZN7S9857C63v10Ev,
  (VTBL_ENTRY)&_ZN7S9857C53v11Ev,
  (VTBL_ENTRY)&_ZN7S9857C53v12Ev,
  (VTBL_ENTRY)&_ZN7S9857C53v13Ev,
  ABISELECT(-112,-84),
  (VTBL_ENTRY)&(_ZTI7S9857C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N7S9857C1D1Ev,_ZThn84_N7S9857C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N7S9857C1D0Ev,_ZThn84_N7S9857C1D0Ev),
  (VTBL_ENTRY)&_ZN8S9857C113v14Ev,
};
extern VTBL_ENTRY _ZTI7S9857C1[];
extern  VTBL_ENTRY _ZTV7S9857C1[];
Class_Descriptor cd_S9857C1 = {  "S9857C1", // class name
  bases_S9857C1, 4,
  &(vtc_S9857C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(752,552), // object size
  NSPAIRA(_ZTI7S9857C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S9857C1),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9856C2  {
  ::S9624C14_nt s9856c2f0;
  int s9856c2f1[2];
  char s9856c2f2;
  virtual  ~S9856C2(); // _ZN7S9856C2D1Ev
  virtual void  v5(); // _ZN7S9856C22v5Ev
  virtual void  v6(); // _ZN7S9856C22v6Ev
  virtual void  v7(); // _ZN7S9856C22v7Ev
  S9856C2(); // tgen
};
//SIG(-1 S9856C2) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S9856C2 ::~S9856C2(){ note_dtor("S9856C2", this);}
void  S9856C2 ::v5(){vfunc_called(this, "_ZN7S9856C22v5Ev");}
void  S9856C2 ::v6(){vfunc_called(this, "_ZN7S9856C22v6Ev");}
void  S9856C2 ::v7(){vfunc_called(this, "_ZN7S9856C22v7Ev");}
S9856C2 ::S9856C2(){ note_ctor("S9856C2", this);} // tgen

static void Test_S9856C2()
{
  extern Class_Descriptor cd_S9856C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S9856C2, buf);
    S9856C2 *dp, &lv = *(dp=new (buf) S9856C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S9856C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9856C2)");
    check_field_offset(lv, s9856c2f0, ABISELECT(8,4), "S9856C2.s9856c2f0");
    check_field_offset(lv, s9856c2f1, ABISELECT(24,16), "S9856C2.s9856c2f1");
    check_field_offset(lv, s9856c2f2, ABISELECT(32,24), "S9856C2.s9856c2f2");
    test_class_info(&lv, &cd_S9856C2);
    dp->~S9856C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9856C2(Test_S9856C2, "S9856C2", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S9856C2C1Ev();
extern void _ZN7S9856C2D1Ev();
Name_Map name_map_S9856C2[] = {
  NSPAIR(_ZN7S9856C2C1Ev),
  NSPAIR(_ZN7S9856C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9856C2[];
extern void _ZN7S9856C2D1Ev();
extern void _ZN7S9856C2D0Ev();
extern void _ZN7S9856C22v5Ev();
extern void _ZN7S9856C22v6Ev();
extern void _ZN7S9856C22v7Ev();
static  VTBL_ENTRY vtc_S9856C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9856C2[0]),
  (VTBL_ENTRY)&_ZN7S9856C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9856C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9856C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9856C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9856C22v7Ev,
};
extern VTBL_ENTRY _ZTI7S9856C2[];
extern  VTBL_ENTRY _ZTV7S9856C2[];
Class_Descriptor cd_S9856C2 = {  "S9856C2", // class name
  0,0,//no base classes
  &(vtc_S9856C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S9856C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9856C2),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9856C6  {
  virtual  ~S9856C6(); // _ZN7S9856C6D1Ev
  virtual void  v8(); // _ZN7S9856C62v8Ev
  virtual void  v9(); // _ZN7S9856C62v9Ev
  virtual void  v10(); // _ZN7S9856C63v10Ev
  S9856C6(); // tgen
};
//SIG(-1 S9856C6) C1{ vd v1 v2 v3}


 S9856C6 ::~S9856C6(){ note_dtor("S9856C6", this);}
void  S9856C6 ::v8(){vfunc_called(this, "_ZN7S9856C62v8Ev");}
void  S9856C6 ::v9(){vfunc_called(this, "_ZN7S9856C62v9Ev");}
void  S9856C6 ::v10(){vfunc_called(this, "_ZN7S9856C63v10Ev");}
S9856C6 ::S9856C6(){ note_ctor("S9856C6", this);} // tgen

static void Test_S9856C6()
{
  extern Class_Descriptor cd_S9856C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9856C6, buf);
    S9856C6 *dp, &lv = *(dp=new (buf) S9856C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9856C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9856C6)");
    test_class_info(&lv, &cd_S9856C6);
    dp->~S9856C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9856C6(Test_S9856C6, "S9856C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9856C6C1Ev();
extern void _ZN7S9856C6D1Ev();
Name_Map name_map_S9856C6[] = {
  NSPAIR(_ZN7S9856C6C1Ev),
  NSPAIR(_ZN7S9856C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9856C6[];
extern void _ZN7S9856C6D1Ev();
extern void _ZN7S9856C6D0Ev();
extern void _ZN7S9856C62v8Ev();
extern void _ZN7S9856C62v9Ev();
extern void _ZN7S9856C63v10Ev();
static  VTBL_ENTRY vtc_S9856C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9856C6[0]),
  (VTBL_ENTRY)&_ZN7S9856C6D1Ev,
  (VTBL_ENTRY)&_ZN7S9856C6D0Ev,
  (VTBL_ENTRY)&_ZN7S9856C62v8Ev,
  (VTBL_ENTRY)&_ZN7S9856C62v9Ev,
  (VTBL_ENTRY)&_ZN7S9856C63v10Ev,
};
extern VTBL_ENTRY _ZTI7S9856C6[];
extern  VTBL_ENTRY _ZTV7S9856C6[];
Class_Descriptor cd_S9856C6 = {  "S9856C6", // class name
  0,0,//no base classes
  &(vtc_S9856C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9856C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9856C6),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9856C5  : S9856C6 {
  ::S9624C35 s9856c5f0;
  ::S9624C9_nt s9856c5f1;
  char s9856c5f2;
  virtual  ~S9856C5(); // _ZN7S9856C5D1Ev
  virtual void  v11(); // _ZN7S9856C53v11Ev
  virtual void  v12(); // _ZN7S9856C53v12Ev
  virtual void  v13(); // _ZN7S9856C53v13Ev
  S9856C5(); // tgen
};
//SIG(-1 S9856C5) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ Fl[4]}} Fc}


 S9856C5 ::~S9856C5(){ note_dtor("S9856C5", this);}
void  S9856C5 ::v11(){vfunc_called(this, "_ZN7S9856C53v11Ev");}
void  S9856C5 ::v12(){vfunc_called(this, "_ZN7S9856C53v12Ev");}
void  S9856C5 ::v13(){vfunc_called(this, "_ZN7S9856C53v13Ev");}
S9856C5 ::S9856C5(){ note_ctor("S9856C5", this);} // tgen

static void Test_S9856C5()
{
  extern Class_Descriptor cd_S9856C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S9856C5, buf);
    S9856C5 *dp, &lv = *(dp=new (buf) S9856C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S9856C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9856C5)");
    check_base_class_offset(lv, (S9856C6*), 0, "S9856C5");
    check_field_offset(lv, s9856c5f0, ABISELECT(8,4), "S9856C5.s9856c5f0");
    check_field_offset(lv, s9856c5f1, ABISELECT(32,20), "S9856C5.s9856c5f1");
    check_field_offset(lv, s9856c5f2, ABISELECT(64,36), "S9856C5.s9856c5f2");
    test_class_info(&lv, &cd_S9856C5);
    dp->~S9856C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9856C5(Test_S9856C5, "S9856C5", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S9856C5C1Ev();
extern void _ZN7S9856C5D1Ev();
Name_Map name_map_S9856C5[] = {
  NSPAIR(_ZN7S9856C5C1Ev),
  NSPAIR(_ZN7S9856C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9856C6;
extern VTBL_ENTRY _ZTI7S9856C6[];
extern  VTBL_ENTRY _ZTV7S9856C6[];
static Base_Class bases_S9856C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9856C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9856C5[];
extern void _ZN7S9856C5D1Ev();
extern void _ZN7S9856C5D0Ev();
extern void _ZN7S9856C62v8Ev();
extern void _ZN7S9856C62v9Ev();
extern void _ZN7S9856C63v10Ev();
extern void _ZN7S9856C53v11Ev();
extern void _ZN7S9856C53v12Ev();
extern void _ZN7S9856C53v13Ev();
static  VTBL_ENTRY vtc_S9856C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9856C5[0]),
  (VTBL_ENTRY)&_ZN7S9856C5D1Ev,
  (VTBL_ENTRY)&_ZN7S9856C5D0Ev,
  (VTBL_ENTRY)&_ZN7S9856C62v8Ev,
  (VTBL_ENTRY)&_ZN7S9856C62v9Ev,
  (VTBL_ENTRY)&_ZN7S9856C63v10Ev,
  (VTBL_ENTRY)&_ZN7S9856C53v11Ev,
  (VTBL_ENTRY)&_ZN7S9856C53v12Ev,
  (VTBL_ENTRY)&_ZN7S9856C53v13Ev,
};
extern VTBL_ENTRY _ZTI7S9856C5[];
extern  VTBL_ENTRY _ZTV7S9856C5[];
Class_Descriptor cd_S9856C5 = {  "S9856C5", // class name
  bases_S9856C5, 1,
  &(vtc_S9856C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S9856C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9856C5),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9856C11  {
  virtual  ~S9856C11(); // _ZN8S9856C11D1Ev
  virtual void  v14(); // _ZN8S9856C113v14Ev
  S9856C11(); // tgen
};
//SIG(-1 S9856C11) C1{ vd v1}


 S9856C11 ::~S9856C11(){ note_dtor("S9856C11", this);}
void  S9856C11 ::v14(){vfunc_called(this, "_ZN8S9856C113v14Ev");}
S9856C11 ::S9856C11(){ note_ctor("S9856C11", this);} // tgen

static void Test_S9856C11()
{
  extern Class_Descriptor cd_S9856C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9856C11, buf);
    S9856C11 *dp, &lv = *(dp=new (buf) S9856C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9856C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9856C11)");
    test_class_info(&lv, &cd_S9856C11);
    dp->~S9856C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9856C11(Test_S9856C11, "S9856C11", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9856C11C1Ev();
extern void _ZN8S9856C11D1Ev();
Name_Map name_map_S9856C11[] = {
  NSPAIR(_ZN8S9856C11C1Ev),
  NSPAIR(_ZN8S9856C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9856C11[];
extern void _ZN8S9856C11D1Ev();
extern void _ZN8S9856C11D0Ev();
extern void _ZN8S9856C113v14Ev();
static  VTBL_ENTRY vtc_S9856C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9856C11[0]),
  (VTBL_ENTRY)&_ZN8S9856C11D1Ev,
  (VTBL_ENTRY)&_ZN8S9856C11D0Ev,
  (VTBL_ENTRY)&_ZN8S9856C113v14Ev,
};
extern VTBL_ENTRY _ZTI8S9856C11[];
extern  VTBL_ENTRY _ZTV8S9856C11[];
Class_Descriptor cd_S9856C11 = {  "S9856C11", // class name
  0,0,//no base classes
  &(vtc_S9856C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9856C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9856C11),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9856C33_nt  {
  ::S9624C10_nt s9856c33f0;
  void  mf9856c33(); // _ZN11S9856C33_nt9mf9856c33Ev
};
//SIG(-1 S9856C33_nt) C1{ m FC2{ Fl[4]}}


void  S9856C33_nt ::mf9856c33(){}

//skip512 S9856C33_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9856C1  : S9856C2 , S9856C5 , S9856C11 {
  void *s9856c1f0;
  int s9856c1f1;
  ::S10296C48 s9856c1f2;
  ::S9857C13 s9856c1f3;
  ::S9856C33_nt s9856c1f4;
  ::S9857C34_nt s9856c1f5;
  int s9856c1f6;
  virtual  ~S9856C1(); // _ZN7S9856C1D1Ev
  virtual void  v1(); // _ZN7S9856C12v1Ev
  virtual void  v2(); // _ZN7S9856C12v2Ev
  virtual void  v3(); // _ZN7S9856C12v3Ev
  virtual void  v4(); // _ZN7S9856C12v4Ev
  S9856C1(); // tgen
};
//SIG(1 S9856C1) C1{ BC2{ vd v5 v6 v7 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ BC6{ vd v8 v9 v10} vd v11 v12 v13 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FC10{ Fl[4]}} Fc} BC11{ vd v14} vd v1 v2 v3 v4 Fp Fi FC12{ m Fp[2]} FC13{ m FC14{ BC15{ vd v16 v17} vd v15 FC3} FC16{ BC17{ vd v19 v20} vd v18 FC3} FC18{ BC19{ vd v22 v23} vd v21 FC3} FC18 FC18 FC18 FC20{ BC17 vd v24 FC3 FC3 FC3} FC21{ BC17 vd v25 FC22{ vd v26 Fs[2] Fc[6] Fs[2] Fc[6] FC3} FC3 Fi[2] FC23{ vd v27 Fi} Fi[2]} FC24{ vd v28 Fi[2] Fs[2] Fi[3] FC3} Fi FC25{ BC17 vd v29 v30 FL} FC26{ BC17 vd v31 v32 Fi[5] FC25 FC27{ BC28{ m Fp Fi[2] FC8} BC17 vd v33 v34} FC3 FC29{ vd m FC30{ m Fs[6] Fi[2] Fc Fs}} FC29}} FC31{ m FC10} FC32{ m Fp FC33{ Fi[4]}} Fi}


 S9856C1 ::~S9856C1(){ note_dtor("S9856C1", this);}
void  S9856C1 ::v1(){vfunc_called(this, "_ZN7S9856C12v1Ev");}
void  S9856C1 ::v2(){vfunc_called(this, "_ZN7S9856C12v2Ev");}
void  S9856C1 ::v3(){vfunc_called(this, "_ZN7S9856C12v3Ev");}
void  S9856C1 ::v4(){vfunc_called(this, "_ZN7S9856C12v4Ev");}
S9856C1 ::S9856C1(){ note_ctor("S9856C1", this);} // tgen

static void Test_S9856C1()
{
  extern Class_Descriptor cd_S9856C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(95,131)];
    init_test(&cd_S9856C1, buf);
    S9856C1 *dp, &lv = *(dp=new (buf) S9856C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(752,520), "sizeof(S9856C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9856C1)");
    check_base_class_offset(lv, (S9856C2*), 0, "S9856C1");
    check_base_class_offset(lv, (S9856C6*)(S9856C5*), ABISELECT(40,28), "S9856C1");
    check_base_class_offset(lv, (S9856C5*), ABISELECT(40,28), "S9856C1");
    check_base_class_offset(lv, (S9856C11*), ABISELECT(112,68), "S9856C1");
    check_field_offset(lv, s9856c1f0, ABISELECT(120,72), "S9856C1.s9856c1f0");
    check_field_offset(lv, s9856c1f1, ABISELECT(128,76), "S9856C1.s9856c1f1");
    check_field_offset(lv, s9856c1f2, ABISELECT(136,80), "S9856C1.s9856c1f2");
    check_field_offset(lv, s9856c1f3, ABISELECT(152,88), "S9856C1.s9856c1f3");
    check_field_offset(lv, s9856c1f4, ABISELECT(688,480), "S9856C1.s9856c1f4");
    check_field_offset(lv, s9856c1f5, ABISELECT(720,496), "S9856C1.s9856c1f5");
    check_field_offset(lv, s9856c1f6, ABISELECT(744,516), "S9856C1.s9856c1f6");
    test_class_info(&lv, &cd_S9856C1);
    dp->~S9856C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9856C1(Test_S9856C1, "S9856C1", ABISELECT(752,520));

#else // __cplusplus

extern void _ZN7S9856C1C1Ev();
extern void _ZN7S9856C1D1Ev();
Name_Map name_map_S9856C1[] = {
  NSPAIR(_ZN7S9856C1C1Ev),
  NSPAIR(_ZN7S9856C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9856C2;
extern VTBL_ENTRY _ZTI7S9856C2[];
extern  VTBL_ENTRY _ZTV7S9856C2[];
extern Class_Descriptor cd_S9856C6;
extern VTBL_ENTRY _ZTI7S9856C6[];
extern  VTBL_ENTRY _ZTV7S9856C6[];
extern Class_Descriptor cd_S9856C5;
extern VTBL_ENTRY _ZTI7S9856C5[];
extern  VTBL_ENTRY _ZTV7S9856C5[];
extern Class_Descriptor cd_S9856C11;
extern VTBL_ENTRY _ZTI8S9856C11[];
extern  VTBL_ENTRY _ZTV8S9856C11[];
static Base_Class bases_S9856C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9856C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9856C6,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S9856C5,    ABISELECT(40,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9856C11,    ABISELECT(112,68), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9856C1[];
extern void _ZN7S9856C1D1Ev();
extern void _ZN7S9856C1D0Ev();
extern void _ZN7S9856C22v5Ev();
extern void _ZN7S9856C22v6Ev();
extern void _ZN7S9856C22v7Ev();
extern void _ZN7S9856C12v1Ev();
extern void _ZN7S9856C12v2Ev();
extern void _ZN7S9856C12v3Ev();
extern void _ZN7S9856C12v4Ev();
extern void ABISELECT(_ZThn40_N7S9856C1D1Ev,_ZThn28_N7S9856C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S9856C1D0Ev,_ZThn28_N7S9856C1D0Ev)();
extern void _ZN7S9856C62v8Ev();
extern void _ZN7S9856C62v9Ev();
extern void _ZN7S9856C63v10Ev();
extern void _ZN7S9856C53v11Ev();
extern void _ZN7S9856C53v12Ev();
extern void _ZN7S9856C53v13Ev();
extern void ABISELECT(_ZThn112_N7S9856C1D1Ev,_ZThn68_N7S9856C1D1Ev)();
extern void ABISELECT(_ZThn112_N7S9856C1D0Ev,_ZThn68_N7S9856C1D0Ev)();
extern void _ZN8S9856C113v14Ev();
static  VTBL_ENTRY vtc_S9856C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9856C1[0]),
  (VTBL_ENTRY)&_ZN7S9856C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9856C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9856C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9856C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9856C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9856C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9856C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9856C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9856C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S9856C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S9856C1D1Ev,_ZThn28_N7S9856C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S9856C1D0Ev,_ZThn28_N7S9856C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9856C62v8Ev,
  (VTBL_ENTRY)&_ZN7S9856C62v9Ev,
  (VTBL_ENTRY)&_ZN7S9856C63v10Ev,
  (VTBL_ENTRY)&_ZN7S9856C53v11Ev,
  (VTBL_ENTRY)&_ZN7S9856C53v12Ev,
  (VTBL_ENTRY)&_ZN7S9856C53v13Ev,
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI7S9856C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N7S9856C1D1Ev,_ZThn68_N7S9856C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N7S9856C1D0Ev,_ZThn68_N7S9856C1D0Ev),
  (VTBL_ENTRY)&_ZN8S9856C113v14Ev,
};
extern VTBL_ENTRY _ZTI7S9856C1[];
extern  VTBL_ENTRY _ZTV7S9856C1[];
Class_Descriptor cd_S9856C1 = {  "S9856C1", // class name
  bases_S9856C1, 4,
  &(vtc_S9856C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(752,520), // object size
  NSPAIRA(_ZTI7S9856C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S9856C1),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9859C2  {
  ::S9624C14_nt s9859c2f0;
  int s9859c2f1[2];
  char s9859c2f2;
  virtual  ~S9859C2(); // _ZN7S9859C2D1Ev
  virtual void  v5(); // _ZN7S9859C22v5Ev
  virtual void  v6(); // _ZN7S9859C22v6Ev
  virtual void  v7(); // _ZN7S9859C22v7Ev
  S9859C2(); // tgen
};
//SIG(-1 S9859C2) C1{ vd v1 v2 v3 FC2{ m Fp Fi FC3{ m}} Fi[2] Fc}


 S9859C2 ::~S9859C2(){ note_dtor("S9859C2", this);}
void  S9859C2 ::v5(){vfunc_called(this, "_ZN7S9859C22v5Ev");}
void  S9859C2 ::v6(){vfunc_called(this, "_ZN7S9859C22v6Ev");}
void  S9859C2 ::v7(){vfunc_called(this, "_ZN7S9859C22v7Ev");}
S9859C2 ::S9859C2(){ note_ctor("S9859C2", this);} // tgen

static void Test_S9859C2()
{
  extern Class_Descriptor cd_S9859C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S9859C2, buf);
    S9859C2 *dp, &lv = *(dp=new (buf) S9859C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S9859C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9859C2)");
    check_field_offset(lv, s9859c2f0, ABISELECT(8,4), "S9859C2.s9859c2f0");
    check_field_offset(lv, s9859c2f1, ABISELECT(24,16), "S9859C2.s9859c2f1");
    check_field_offset(lv, s9859c2f2, ABISELECT(32,24), "S9859C2.s9859c2f2");
    test_class_info(&lv, &cd_S9859C2);
    dp->~S9859C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9859C2(Test_S9859C2, "S9859C2", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S9859C2C1Ev();
extern void _ZN7S9859C2D1Ev();
Name_Map name_map_S9859C2[] = {
  NSPAIR(_ZN7S9859C2C1Ev),
  NSPAIR(_ZN7S9859C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9859C2[];
extern void _ZN7S9859C2D1Ev();
extern void _ZN7S9859C2D0Ev();
extern void _ZN7S9859C22v5Ev();
extern void _ZN7S9859C22v6Ev();
extern void _ZN7S9859C22v7Ev();
static  VTBL_ENTRY vtc_S9859C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9859C2[0]),
  (VTBL_ENTRY)&_ZN7S9859C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9859C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9859C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9859C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9859C22v7Ev,
};
extern VTBL_ENTRY _ZTI7S9859C2[];
extern  VTBL_ENTRY _ZTV7S9859C2[];
Class_Descriptor cd_S9859C2 = {  "S9859C2", // class name
  0,0,//no base classes
  &(vtc_S9859C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S9859C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9859C2),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9859C6  {
  virtual  ~S9859C6(); // _ZN7S9859C6D1Ev
  virtual void  v8(); // _ZN7S9859C62v8Ev
  virtual void  v9(); // _ZN7S9859C62v9Ev
  virtual void  v10(); // _ZN7S9859C63v10Ev
  S9859C6(); // tgen
};
//SIG(-1 S9859C6) C1{ vd v1 v2 v3}


 S9859C6 ::~S9859C6(){ note_dtor("S9859C6", this);}
void  S9859C6 ::v8(){vfunc_called(this, "_ZN7S9859C62v8Ev");}
void  S9859C6 ::v9(){vfunc_called(this, "_ZN7S9859C62v9Ev");}
void  S9859C6 ::v10(){vfunc_called(this, "_ZN7S9859C63v10Ev");}
S9859C6 ::S9859C6(){ note_ctor("S9859C6", this);} // tgen

static void Test_S9859C6()
{
  extern Class_Descriptor cd_S9859C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9859C6, buf);
    S9859C6 *dp, &lv = *(dp=new (buf) S9859C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9859C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9859C6)");
    test_class_info(&lv, &cd_S9859C6);
    dp->~S9859C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9859C6(Test_S9859C6, "S9859C6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9859C6C1Ev();
extern void _ZN7S9859C6D1Ev();
Name_Map name_map_S9859C6[] = {
  NSPAIR(_ZN7S9859C6C1Ev),
  NSPAIR(_ZN7S9859C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9859C6[];
extern void _ZN7S9859C6D1Ev();
extern void _ZN7S9859C6D0Ev();
extern void _ZN7S9859C62v8Ev();
extern void _ZN7S9859C62v9Ev();
extern void _ZN7S9859C63v10Ev();
static  VTBL_ENTRY vtc_S9859C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9859C6[0]),
  (VTBL_ENTRY)&_ZN7S9859C6D1Ev,
  (VTBL_ENTRY)&_ZN7S9859C6D0Ev,
  (VTBL_ENTRY)&_ZN7S9859C62v8Ev,
  (VTBL_ENTRY)&_ZN7S9859C62v9Ev,
  (VTBL_ENTRY)&_ZN7S9859C63v10Ev,
};
extern VTBL_ENTRY _ZTI7S9859C6[];
extern  VTBL_ENTRY _ZTV7S9859C6[];
Class_Descriptor cd_S9859C6 = {  "S9859C6", // class name
  0,0,//no base classes
  &(vtc_S9859C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9859C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9859C6),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9859C5  : S9859C6 {
  ::S9624C35 s9859c5f0;
  ::S9626C9_nt s9859c5f1;
  char s9859c5f2;
  virtual  ~S9859C5(); // _ZN7S9859C5D1Ev
  virtual void  v11(); // _ZN7S9859C53v11Ev
  virtual void  v12(); // _ZN7S9859C53v12Ev
  virtual void  v13(); // _ZN7S9859C53v13Ev
  S9859C5(); // tgen
};
//SIG(-1 S9859C5) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FL[4]} Fc}


 S9859C5 ::~S9859C5(){ note_dtor("S9859C5", this);}
void  S9859C5 ::v11(){vfunc_called(this, "_ZN7S9859C53v11Ev");}
void  S9859C5 ::v12(){vfunc_called(this, "_ZN7S9859C53v12Ev");}
void  S9859C5 ::v13(){vfunc_called(this, "_ZN7S9859C53v13Ev");}
S9859C5 ::S9859C5(){ note_ctor("S9859C5", this);} // tgen

static void Test_S9859C5()
{
  extern Class_Descriptor cd_S9859C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S9859C5, buf);
    S9859C5 *dp, &lv = *(dp=new (buf) S9859C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S9859C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9859C5)");
    check_base_class_offset(lv, (S9859C6*), 0, "S9859C5");
    check_field_offset(lv, s9859c5f0, ABISELECT(8,4), "S9859C5.s9859c5f0");
    check_field_offset(lv, s9859c5f1, ABISELECT(32,20), "S9859C5.s9859c5f1");
    check_field_offset(lv, s9859c5f2, ABISELECT(64,52), "S9859C5.s9859c5f2");
    test_class_info(&lv, &cd_S9859C5);
    dp->~S9859C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9859C5(Test_S9859C5, "S9859C5", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S9859C5C1Ev();
extern void _ZN7S9859C5D1Ev();
Name_Map name_map_S9859C5[] = {
  NSPAIR(_ZN7S9859C5C1Ev),
  NSPAIR(_ZN7S9859C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9859C6;
extern VTBL_ENTRY _ZTI7S9859C6[];
extern  VTBL_ENTRY _ZTV7S9859C6[];
static Base_Class bases_S9859C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9859C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9859C5[];
extern void _ZN7S9859C5D1Ev();
extern void _ZN7S9859C5D0Ev();
extern void _ZN7S9859C62v8Ev();
extern void _ZN7S9859C62v9Ev();
extern void _ZN7S9859C63v10Ev();
extern void _ZN7S9859C53v11Ev();
extern void _ZN7S9859C53v12Ev();
extern void _ZN7S9859C53v13Ev();
static  VTBL_ENTRY vtc_S9859C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9859C5[0]),
  (VTBL_ENTRY)&_ZN7S9859C5D1Ev,
  (VTBL_ENTRY)&_ZN7S9859C5D0Ev,
  (VTBL_ENTRY)&_ZN7S9859C62v8Ev,
  (VTBL_ENTRY)&_ZN7S9859C62v9Ev,
  (VTBL_ENTRY)&_ZN7S9859C63v10Ev,
  (VTBL_ENTRY)&_ZN7S9859C53v11Ev,
  (VTBL_ENTRY)&_ZN7S9859C53v12Ev,
  (VTBL_ENTRY)&_ZN7S9859C53v13Ev,
};
extern VTBL_ENTRY _ZTI7S9859C5[];
extern  VTBL_ENTRY _ZTV7S9859C5[];
Class_Descriptor cd_S9859C5 = {  "S9859C5", // class name
  bases_S9859C5, 1,
  &(vtc_S9859C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S9859C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9859C5),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9859C10  {
  virtual  ~S9859C10(); // _ZN8S9859C10D1Ev
  virtual void  v14(); // _ZN8S9859C103v14Ev
  S9859C10(); // tgen
};
//SIG(-1 S9859C10) C1{ vd v1}


 S9859C10 ::~S9859C10(){ note_dtor("S9859C10", this);}
void  S9859C10 ::v14(){vfunc_called(this, "_ZN8S9859C103v14Ev");}
S9859C10 ::S9859C10(){ note_ctor("S9859C10", this);} // tgen

static void Test_S9859C10()
{
  extern Class_Descriptor cd_S9859C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9859C10, buf);
    S9859C10 *dp, &lv = *(dp=new (buf) S9859C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9859C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9859C10)");
    test_class_info(&lv, &cd_S9859C10);
    dp->~S9859C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9859C10(Test_S9859C10, "S9859C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S9859C10C1Ev();
extern void _ZN8S9859C10D1Ev();
Name_Map name_map_S9859C10[] = {
  NSPAIR(_ZN8S9859C10C1Ev),
  NSPAIR(_ZN8S9859C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S9859C10[];
extern void _ZN8S9859C10D1Ev();
extern void _ZN8S9859C10D0Ev();
extern void _ZN8S9859C103v14Ev();
static  VTBL_ENTRY vtc_S9859C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9859C10[0]),
  (VTBL_ENTRY)&_ZN8S9859C10D1Ev,
  (VTBL_ENTRY)&_ZN8S9859C10D0Ev,
  (VTBL_ENTRY)&_ZN8S9859C103v14Ev,
};
extern VTBL_ENTRY _ZTI8S9859C10[];
extern  VTBL_ENTRY _ZTV8S9859C10[];
Class_Descriptor cd_S9859C10 = {  "S9859C10", // class name
  0,0,//no base classes
  &(vtc_S9859C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S9859C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S9859C10),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9859C32_nt  {
  __tsi64 s9859c32f0[4];
  void  mf9859c32(); // _ZN11S9859C32_nt9mf9859c32Ev
};
//SIG(-1 S9859C32_nt) C1{ m FL[4]}


void  S9859C32_nt ::mf9859c32(){}

//skip512 S9859C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9859C1  : S9859C2 , S9859C5 , S9859C10 {
  void *s9859c1f0;
  int s9859c1f1;
  ::S10296C48 s9859c1f2;
  ::S9857C13 s9859c1f3;
  ::S9859C32_nt s9859c1f4;
  ::S9857C34_nt s9859c1f5;
  int s9859c1f6;
  virtual  ~S9859C1(); // _ZN7S9859C1D1Ev
  virtual void  v1(); // _ZN7S9859C12v1Ev
  virtual void  v2(); // _ZN7S9859C12v2Ev
  virtual void  v3(); // _ZN7S9859C12v3Ev
  virtual void  v4(); // _ZN7S9859C12v4Ev
  S9859C1(); // tgen
};
//SIG(1 S9859C1) C1{ BC2{ vd v5 v6 v7 FC3{ m Fp Fi FC4{ m}} Fi[2] Fc} BC5{ BC6{ vd v8 v9 v10} vd v11 v12 v13 FC7{ m Fp Fi[2] FC8{ m}} FC9{ m FL[4]} Fc} BC10{ vd v14} vd v1 v2 v3 v4 Fp Fi FC11{ m Fp[2]} FC12{ m FC13{ BC14{ vd v16 v17} vd v15 FC3} FC15{ BC16{ vd v19 v20} vd v18 FC3} FC17{ BC18{ vd v22 v23} vd v21 FC3} FC17 FC17 FC17 FC19{ BC16 vd v24 FC3 FC3 FC3} FC20{ BC16 vd v25 FC21{ vd v26 Fs[2] Fc[6] Fs[2] Fc[6] FC3} FC3 Fi[2] FC22{ vd v27 Fi} Fi[2]} FC23{ vd v28 Fi[2] Fs[2] Fi[3] FC3} Fi FC24{ BC16 vd v29 v30 FL} FC25{ BC16 vd v31 v32 Fi[5] FC24 FC26{ BC27{ m Fp Fi[2] FC8} BC16 vd v33 v34} FC3 FC28{ vd m FC29{ m Fs[6] Fi[2] Fc Fs}} FC28}} FC30{ m FL[4]} FC31{ m Fp FC32{ Fi[4]}} Fi}


 S9859C1 ::~S9859C1(){ note_dtor("S9859C1", this);}
void  S9859C1 ::v1(){vfunc_called(this, "_ZN7S9859C12v1Ev");}
void  S9859C1 ::v2(){vfunc_called(this, "_ZN7S9859C12v2Ev");}
void  S9859C1 ::v3(){vfunc_called(this, "_ZN7S9859C12v3Ev");}
void  S9859C1 ::v4(){vfunc_called(this, "_ZN7S9859C12v4Ev");}
S9859C1 ::S9859C1(){ note_ctor("S9859C1", this);} // tgen

static void Test_S9859C1()
{
  extern Class_Descriptor cd_S9859C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(95,139)];
    init_test(&cd_S9859C1, buf);
    S9859C1 *dp, &lv = *(dp=new (buf) S9859C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(752,552), "sizeof(S9859C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9859C1)");
    check_base_class_offset(lv, (S9859C2*), 0, "S9859C1");
    check_base_class_offset(lv, (S9859C6*)(S9859C5*), ABISELECT(40,28), "S9859C1");
    check_base_class_offset(lv, (S9859C5*), ABISELECT(40,28), "S9859C1");
    check_base_class_offset(lv, (S9859C10*), ABISELECT(112,84), "S9859C1");
    check_field_offset(lv, s9859c1f0, ABISELECT(120,88), "S9859C1.s9859c1f0");
    check_field_offset(lv, s9859c1f1, ABISELECT(128,92), "S9859C1.s9859c1f1");
    check_field_offset(lv, s9859c1f2, ABISELECT(136,96), "S9859C1.s9859c1f2");
    check_field_offset(lv, s9859c1f3, ABISELECT(152,104), "S9859C1.s9859c1f3");
    check_field_offset(lv, s9859c1f4, ABISELECT(688,496), "S9859C1.s9859c1f4");
    check_field_offset(lv, s9859c1f5, ABISELECT(720,528), "S9859C1.s9859c1f5");
    check_field_offset(lv, s9859c1f6, ABISELECT(744,548), "S9859C1.s9859c1f6");
    test_class_info(&lv, &cd_S9859C1);
    dp->~S9859C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9859C1(Test_S9859C1, "S9859C1", ABISELECT(752,552));

#else // __cplusplus

extern void _ZN7S9859C1C1Ev();
extern void _ZN7S9859C1D1Ev();
Name_Map name_map_S9859C1[] = {
  NSPAIR(_ZN7S9859C1C1Ev),
  NSPAIR(_ZN7S9859C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9859C2;
extern VTBL_ENTRY _ZTI7S9859C2[];
extern  VTBL_ENTRY _ZTV7S9859C2[];
extern Class_Descriptor cd_S9859C6;
extern VTBL_ENTRY _ZTI7S9859C6[];
extern  VTBL_ENTRY _ZTV7S9859C6[];
extern Class_Descriptor cd_S9859C5;
extern VTBL_ENTRY _ZTI7S9859C5[];
extern  VTBL_ENTRY _ZTV7S9859C5[];
extern Class_Descriptor cd_S9859C10;
extern VTBL_ENTRY _ZTI8S9859C10[];
extern  VTBL_ENTRY _ZTV8S9859C10[];
static Base_Class bases_S9859C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9859C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9859C6,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S9859C5,    ABISELECT(40,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9859C10,    ABISELECT(112,84), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9859C1[];
extern void _ZN7S9859C1D1Ev();
extern void _ZN7S9859C1D0Ev();
extern void _ZN7S9859C22v5Ev();
extern void _ZN7S9859C22v6Ev();
extern void _ZN7S9859C22v7Ev();
extern void _ZN7S9859C12v1Ev();
extern void _ZN7S9859C12v2Ev();
extern void _ZN7S9859C12v3Ev();
extern void _ZN7S9859C12v4Ev();
extern void ABISELECT(_ZThn40_N7S9859C1D1Ev,_ZThn28_N7S9859C1D1Ev)();
extern void ABISELECT(_ZThn40_N7S9859C1D0Ev,_ZThn28_N7S9859C1D0Ev)();
extern void _ZN7S9859C62v8Ev();
extern void _ZN7S9859C62v9Ev();
extern void _ZN7S9859C63v10Ev();
extern void _ZN7S9859C53v11Ev();
extern void _ZN7S9859C53v12Ev();
extern void _ZN7S9859C53v13Ev();
extern void ABISELECT(_ZThn112_N7S9859C1D1Ev,_ZThn84_N7S9859C1D1Ev)();
extern void ABISELECT(_ZThn112_N7S9859C1D0Ev,_ZThn84_N7S9859C1D0Ev)();
extern void _ZN8S9859C103v14Ev();
static  VTBL_ENTRY vtc_S9859C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9859C1[0]),
  (VTBL_ENTRY)&_ZN7S9859C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9859C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9859C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9859C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9859C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9859C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9859C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9859C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9859C12v4Ev,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S9859C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S9859C1D1Ev,_ZThn28_N7S9859C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N7S9859C1D0Ev,_ZThn28_N7S9859C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9859C62v8Ev,
  (VTBL_ENTRY)&_ZN7S9859C62v9Ev,
  (VTBL_ENTRY)&_ZN7S9859C63v10Ev,
  (VTBL_ENTRY)&_ZN7S9859C53v11Ev,
  (VTBL_ENTRY)&_ZN7S9859C53v12Ev,
  (VTBL_ENTRY)&_ZN7S9859C53v13Ev,
  ABISELECT(-112,-84),
  (VTBL_ENTRY)&(_ZTI7S9859C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N7S9859C1D1Ev,_ZThn84_N7S9859C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N7S9859C1D0Ev,_ZThn84_N7S9859C1D0Ev),
  (VTBL_ENTRY)&_ZN8S9859C103v14Ev,
};
extern VTBL_ENTRY _ZTI7S9859C1[];
extern  VTBL_ENTRY _ZTV7S9859C1[];
Class_Descriptor cd_S9859C1 = {  "S9859C1", // class name
  bases_S9859C1, 4,
  &(vtc_S9859C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(752,552), // object size
  NSPAIRA(_ZTI7S9859C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S9859C1),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15658C4  {
  ::S10296C14_nt s15658c4f0;
  virtual  ~S15658C4(); // _ZN8S15658C4D1Ev
  virtual void  v7(); // _ZN8S15658C42v7Ev
  virtual void  v8(); // _ZN8S15658C42v8Ev
  virtual void  v9(); // _ZN8S15658C42v9Ev
  virtual void  v10(); // _ZN8S15658C43v10Ev
  virtual void  v11(); // _ZN8S15658C43v11Ev
  virtual void  v12(); // _ZN8S15658C43v12Ev
  S15658C4(); // tgen
};
//SIG(-1 S15658C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15658C4 ::~S15658C4(){ note_dtor("S15658C4", this);}
void  S15658C4 ::v7(){vfunc_called(this, "_ZN8S15658C42v7Ev");}
void  S15658C4 ::v8(){vfunc_called(this, "_ZN8S15658C42v8Ev");}
void  S15658C4 ::v9(){vfunc_called(this, "_ZN8S15658C42v9Ev");}
void  S15658C4 ::v10(){vfunc_called(this, "_ZN8S15658C43v10Ev");}
void  S15658C4 ::v11(){vfunc_called(this, "_ZN8S15658C43v11Ev");}
void  S15658C4 ::v12(){vfunc_called(this, "_ZN8S15658C43v12Ev");}
S15658C4 ::S15658C4(){ note_ctor("S15658C4", this);} // tgen

static void Test_S15658C4()
{
  extern Class_Descriptor cd_S15658C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15658C4, buf);
    S15658C4 *dp, &lv = *(dp=new (buf) S15658C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15658C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15658C4)");
    check_field_offset(lv, s15658c4f0, ABISELECT(8,4), "S15658C4.s15658c4f0");
    test_class_info(&lv, &cd_S15658C4);
    dp->~S15658C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15658C4(Test_S15658C4, "S15658C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S15658C4C1Ev();
extern void _ZN8S15658C4D1Ev();
Name_Map name_map_S15658C4[] = {
  NSPAIR(_ZN8S15658C4C1Ev),
  NSPAIR(_ZN8S15658C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15658C4[];
extern void _ZN8S15658C4D1Ev();
extern void _ZN8S15658C4D0Ev();
extern void _ZN8S15658C42v7Ev();
extern void _ZN8S15658C42v8Ev();
extern void _ZN8S15658C42v9Ev();
extern void _ZN8S15658C43v10Ev();
extern void _ZN8S15658C43v11Ev();
extern void _ZN8S15658C43v12Ev();
static  VTBL_ENTRY vtc_S15658C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15658C4[0]),
  (VTBL_ENTRY)&_ZN8S15658C4D1Ev,
  (VTBL_ENTRY)&_ZN8S15658C4D0Ev,
  (VTBL_ENTRY)&_ZN8S15658C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15658C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15658C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15658C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15658C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15658C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S15658C4[];
extern  VTBL_ENTRY _ZTV8S15658C4[];
Class_Descriptor cd_S15658C4 = {  "S15658C4", // class name
  0,0,//no base classes
  &(vtc_S15658C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S15658C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15658C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15658C28  : S15658C4 , S10296C15_nt {
  ::S10296C35_nt s15658c28f0;
  ::S10296C21_nt s15658c28f1;
  ::S15657C13_nt s15658c28f2;
  ::S15657C33_nt s15658c28f3;
  ::S15657C13_nt s15658c28f4;
  ::S15657C33_nt s15658c28f5;
  ::S15657C13_nt s15658c28f6;
  ::S15657C33_nt s15658c28f7;
  ::S15657C13_nt s15658c28f8;
  ::S15657C33_nt s15658c28f9;
  ::S15657C13_nt s15658c28f10;
  ::S15657C33_nt s15658c28f11;
  virtual void  v15(); // _ZN9S15658C283v15Ev
  virtual void  v16(); // _ZN9S15658C283v16Ev
  virtual void  v17(); // _ZN9S15658C283v17Ev
  virtual void  v18(); // _ZN9S15658C283v18Ev
  virtual void  v19(); // _ZN9S15658C283v19Ev
  virtual void  v20(); // _ZN9S15658C283v20Ev
  ~S15658C28(); // tgen
  S15658C28(); // tgen
};
//SIG(-1 S15658C28) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL[2]}}} FC13{ BC6 FC14{ m FC15{ m FL}}} FC16{ BC6 Fi} FC13 FC16 FC13 FC16 FC13 FC16 FC13 FC16}


void  S15658C28 ::v15(){vfunc_called(this, "_ZN9S15658C283v15Ev");}
void  S15658C28 ::v16(){vfunc_called(this, "_ZN9S15658C283v16Ev");}
void  S15658C28 ::v17(){vfunc_called(this, "_ZN9S15658C283v17Ev");}
void  S15658C28 ::v18(){vfunc_called(this, "_ZN9S15658C283v18Ev");}
void  S15658C28 ::v19(){vfunc_called(this, "_ZN9S15658C283v19Ev");}
void  S15658C28 ::v20(){vfunc_called(this, "_ZN9S15658C283v20Ev");}
S15658C28 ::~S15658C28(){ note_dtor("S15658C28", this);} // tgen
S15658C28 ::S15658C28(){ note_ctor("S15658C28", this);} // tgen

static void Test_S15658C28()
{
  extern Class_Descriptor cd_S15658C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(69,88)];
    init_test(&cd_S15658C28, buf);
    S15658C28 *dp, &lv = *(dp=new (buf) S15658C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(544,348), "sizeof(S15658C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15658C28)");
    check_base_class_offset(lv, (S15658C4*), 0, "S15658C28");
    check_base_class_offset(lv, (S10296C15_nt*), 0, "S15658C28");
    check_field_offset(lv, s15658c28f0, ABISELECT(40,20), "S15658C28.s15658c28f0");
    check_field_offset(lv, s15658c28f1, ABISELECT(96,52), "S15658C28.s15658c28f1");
    check_field_offset(lv, s15658c28f2, ABISELECT(144,88), "S15658C28.s15658c28f2");
    check_field_offset(lv, s15658c28f3, ABISELECT(184,116), "S15658C28.s15658c28f3");
    check_field_offset(lv, s15658c28f4, ABISELECT(224,140), "S15658C28.s15658c28f4");
    check_field_offset(lv, s15658c28f5, ABISELECT(264,168), "S15658C28.s15658c28f5");
    check_field_offset(lv, s15658c28f6, ABISELECT(304,192), "S15658C28.s15658c28f6");
    check_field_offset(lv, s15658c28f7, ABISELECT(344,220), "S15658C28.s15658c28f7");
    check_field_offset(lv, s15658c28f8, ABISELECT(384,244), "S15658C28.s15658c28f8");
    check_field_offset(lv, s15658c28f9, ABISELECT(424,272), "S15658C28.s15658c28f9");
    check_field_offset(lv, s15658c28f10, ABISELECT(464,296), "S15658C28.s15658c28f10");
    check_field_offset(lv, s15658c28f11, ABISELECT(504,324), "S15658C28.s15658c28f11");
    test_class_info(&lv, &cd_S15658C28);
    dp->~S15658C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15658C28(Test_S15658C28, "S15658C28", ABISELECT(544,348));

#else // __cplusplus

extern void _ZN9S15658C28C1Ev();
extern void _ZN9S15658C28D1Ev();
Name_Map name_map_S15658C28[] = {
  NSPAIR(_ZN9S15658C28C1Ev),
  NSPAIR(_ZN9S15658C28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15658C4;
extern VTBL_ENTRY _ZTI8S15658C4[];
extern  VTBL_ENTRY _ZTV8S15658C4[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S15658C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15658C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15658C28[];
extern void _ZN9S15658C28D1Ev();
extern void _ZN9S15658C28D0Ev();
extern void _ZN8S15658C42v7Ev();
extern void _ZN8S15658C42v8Ev();
extern void _ZN8S15658C42v9Ev();
extern void _ZN8S15658C43v10Ev();
extern void _ZN8S15658C43v11Ev();
extern void _ZN8S15658C43v12Ev();
extern void _ZN9S15658C283v15Ev();
extern void _ZN9S15658C283v16Ev();
extern void _ZN9S15658C283v17Ev();
extern void _ZN9S15658C283v18Ev();
extern void _ZN9S15658C283v19Ev();
extern void _ZN9S15658C283v20Ev();
static  VTBL_ENTRY vtc_S15658C28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15658C28[0]),
  (VTBL_ENTRY)&_ZN9S15658C28D1Ev,
  (VTBL_ENTRY)&_ZN9S15658C28D0Ev,
  (VTBL_ENTRY)&_ZN8S15658C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15658C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15658C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15658C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15658C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15658C43v12Ev,
  (VTBL_ENTRY)&_ZN9S15658C283v15Ev,
  (VTBL_ENTRY)&_ZN9S15658C283v16Ev,
  (VTBL_ENTRY)&_ZN9S15658C283v17Ev,
  (VTBL_ENTRY)&_ZN9S15658C283v18Ev,
  (VTBL_ENTRY)&_ZN9S15658C283v19Ev,
  (VTBL_ENTRY)&_ZN9S15658C283v20Ev,
};
extern VTBL_ENTRY _ZTI9S15658C28[];
extern  VTBL_ENTRY _ZTV9S15658C28[];
Class_Descriptor cd_S15658C28 = {  "S15658C28", // class name
  bases_S15658C28, 2,
  &(vtc_S15658C28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(544,348), // object size
  NSPAIRA(_ZTI9S15658C28),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15658C28),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15658C27  {
  ::S15658C28 s15658c27f0;
  ::S10296C36_nt s15658c27f1;
  void  mf15658c27(); // _ZN9S15658C2710mf15658c27Ev
};
//SIG(-1 S15658C27) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL[2]}}} FC14{ BC7 FC15{ m FC16{ m FL}}} FC17{ BC7 Fi} FC14 FC17 FC14 FC17 FC14 FC17 FC14 FC17} FC18{ BC19{ BC20{ vd v13} vd v14 Fp[2] FC21{ m FC22{ m Fp Fi[2] FC23{ m}}} FC24{ m Fp[2]}} vd FC25{ m Fp Fi FC26{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC24}}}


void  S15658C27 ::mf15658c27(){}

static void Test_S15658C27()
{
  {
    init_simple_test("S15658C27");
    static S15658C27 lv;
    check2(sizeof(lv), ABISELECT(648,408), "sizeof(S15658C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15658C27)");
    check_field_offset(lv, s15658c27f0, 0, "S15658C27.s15658c27f0");
    check_field_offset(lv, s15658c27f1, ABISELECT(544,348), "S15658C27.s15658c27f1");
  }
}
static Arrange_To_Call_Me vS15658C27(Test_S15658C27, "S15658C27", ABISELECT(648,408));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15658C1  {
  ::S15657C2 s15658c1f0;
  ::S15658C27 s15658c1f1;
  void  mf15658c1(); // _ZN8S15658C19mf15658c1Ev
};
//SIG(1 S15658C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC10} FC13{ BC8 FC14{ m FC15{ m FL}}}} FC16{ BC17{ BC18{ vd v13} vd v14 Fp[2] FC19{ m FC20{ m Fp Fi[2] FC21{ m}}} FC22{ m Fp[2]}} vd FC23{ m FC24{ Fs[2] Fc[2] Fs}[12] Fi FC25{ Fs[2]}[4] Fi FC26{ m Fp[2]}}}} FC27{ m FC28{ BC29{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC30{ BC8 FC31{ m FC32{ m Fp[2]} FC33{ m Fp}}} FC12 FC13 FC34{ BC8 Fi} FC13 FC34 FC13 FC34 FC13 FC34 FC13 FC34} FC35{ BC36{ BC18 vd v27 Fp[2] FC19 FC26} vd FC37{ m Fp Fi FC38{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC26}}}}


void  S15658C1 ::mf15658c1(){}

static void Test_S15658C1()
{
  {
    init_simple_test("S15658C1");
    static S15658C1 lv;
    check2(sizeof(lv), ABISELECT(1072,740), "sizeof(S15658C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15658C1)");
    check_field_offset(lv, s15658c1f0, 0, "S15658C1.s15658c1f0");
    check_field_offset(lv, s15658c1f1, ABISELECT(424,332), "S15658C1.s15658c1f1");
  }
}
static Arrange_To_Call_Me vS15658C1(Test_S15658C1, "S15658C1", ABISELECT(1072,740));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15661C4  {
  ::S10296C14_nt s15661c4f0;
  virtual  ~S15661C4(); // _ZN8S15661C4D1Ev
  virtual void  v7(); // _ZN8S15661C42v7Ev
  virtual void  v8(); // _ZN8S15661C42v8Ev
  virtual void  v9(); // _ZN8S15661C42v9Ev
  virtual void  v10(); // _ZN8S15661C43v10Ev
  virtual void  v11(); // _ZN8S15661C43v11Ev
  virtual void  v12(); // _ZN8S15661C43v12Ev
  S15661C4(); // tgen
};
//SIG(-1 S15661C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15661C4 ::~S15661C4(){ note_dtor("S15661C4", this);}
void  S15661C4 ::v7(){vfunc_called(this, "_ZN8S15661C42v7Ev");}
void  S15661C4 ::v8(){vfunc_called(this, "_ZN8S15661C42v8Ev");}
void  S15661C4 ::v9(){vfunc_called(this, "_ZN8S15661C42v9Ev");}
void  S15661C4 ::v10(){vfunc_called(this, "_ZN8S15661C43v10Ev");}
void  S15661C4 ::v11(){vfunc_called(this, "_ZN8S15661C43v11Ev");}
void  S15661C4 ::v12(){vfunc_called(this, "_ZN8S15661C43v12Ev");}
S15661C4 ::S15661C4(){ note_ctor("S15661C4", this);} // tgen

static void Test_S15661C4()
{
  extern Class_Descriptor cd_S15661C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15661C4, buf);
    S15661C4 *dp, &lv = *(dp=new (buf) S15661C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15661C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15661C4)");
    check_field_offset(lv, s15661c4f0, ABISELECT(8,4), "S15661C4.s15661c4f0");
    test_class_info(&lv, &cd_S15661C4);
    dp->~S15661C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15661C4(Test_S15661C4, "S15661C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S15661C4C1Ev();
extern void _ZN8S15661C4D1Ev();
Name_Map name_map_S15661C4[] = {
  NSPAIR(_ZN8S15661C4C1Ev),
  NSPAIR(_ZN8S15661C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15661C4[];
extern void _ZN8S15661C4D1Ev();
extern void _ZN8S15661C4D0Ev();
extern void _ZN8S15661C42v7Ev();
extern void _ZN8S15661C42v8Ev();
extern void _ZN8S15661C42v9Ev();
extern void _ZN8S15661C43v10Ev();
extern void _ZN8S15661C43v11Ev();
extern void _ZN8S15661C43v12Ev();
static  VTBL_ENTRY vtc_S15661C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15661C4[0]),
  (VTBL_ENTRY)&_ZN8S15661C4D1Ev,
  (VTBL_ENTRY)&_ZN8S15661C4D0Ev,
  (VTBL_ENTRY)&_ZN8S15661C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15661C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15661C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15661C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15661C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15661C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S15661C4[];
extern  VTBL_ENTRY _ZTV8S15661C4[];
Class_Descriptor cd_S15661C4 = {  "S15661C4", // class name
  0,0,//no base classes
  &(vtc_S15661C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S15661C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15661C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15661C3  : S15661C4 , S10296C15_nt {
  ::S10296C16_nt s15661c3f0;
  ::S15657C13_nt s15661c3f1;
  ::S15657C13_nt s15661c3f2;
  ::S15657C13_nt s15661c3f3;
  virtual void  v1(); // _ZN8S15661C32v1Ev
  virtual void  v2(); // _ZN8S15661C32v2Ev
  virtual void  v3(); // _ZN8S15661C32v3Ev
  virtual void  v4(); // _ZN8S15661C32v4Ev
  virtual void  v5(); // _ZN8S15661C32v5Ev
  virtual void  v6(); // _ZN8S15661C32v6Ev
  ~S15661C3(); // tgen
  S15661C3(); // tgen
};
//SIG(-1 S15661C3) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8}} FC10{ BC6 FC11{ m FC12{ m FL}}} FC10 FC10}


void  S15661C3 ::v1(){vfunc_called(this, "_ZN8S15661C32v1Ev");}
void  S15661C3 ::v2(){vfunc_called(this, "_ZN8S15661C32v2Ev");}
void  S15661C3 ::v3(){vfunc_called(this, "_ZN8S15661C32v3Ev");}
void  S15661C3 ::v4(){vfunc_called(this, "_ZN8S15661C32v4Ev");}
void  S15661C3 ::v5(){vfunc_called(this, "_ZN8S15661C32v5Ev");}
void  S15661C3 ::v6(){vfunc_called(this, "_ZN8S15661C32v6Ev");}
S15661C3 ::~S15661C3(){ note_dtor("S15661C3", this);} // tgen
S15661C3 ::S15661C3(){ note_ctor("S15661C3", this);} // tgen

static void Test_S15661C3()
{
  extern Class_Descriptor cd_S15661C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,48)];
    init_test(&cd_S15661C3, buf);
    S15661C3 *dp, &lv = *(dp=new (buf) S15661C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,188), "sizeof(S15661C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15661C3)");
    check_base_class_offset(lv, (S15661C4*), 0, "S15661C3");
    check_base_class_offset(lv, (S10296C15_nt*), 0, "S15661C3");
    check_field_offset(lv, s15661c3f0, ABISELECT(40,20), "S15661C3.s15661c3f0");
    check_field_offset(lv, s15661c3f1, ABISELECT(136,104), "S15661C3.s15661c3f1");
    check_field_offset(lv, s15661c3f2, ABISELECT(176,132), "S15661C3.s15661c3f2");
    check_field_offset(lv, s15661c3f3, ABISELECT(216,160), "S15661C3.s15661c3f3");
    test_class_info(&lv, &cd_S15661C3);
    dp->~S15661C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15661C3(Test_S15661C3, "S15661C3", ABISELECT(256,188));

#else // __cplusplus

extern void _ZN8S15661C3C1Ev();
extern void _ZN8S15661C3D1Ev();
Name_Map name_map_S15661C3[] = {
  NSPAIR(_ZN8S15661C3C1Ev),
  NSPAIR(_ZN8S15661C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15661C4;
extern VTBL_ENTRY _ZTI8S15661C4[];
extern  VTBL_ENTRY _ZTV8S15661C4[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S15661C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15661C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S15661C3[];
extern void _ZN8S15661C3D1Ev();
extern void _ZN8S15661C3D0Ev();
extern void _ZN8S15661C42v7Ev();
extern void _ZN8S15661C42v8Ev();
extern void _ZN8S15661C42v9Ev();
extern void _ZN8S15661C43v10Ev();
extern void _ZN8S15661C43v11Ev();
extern void _ZN8S15661C43v12Ev();
extern void _ZN8S15661C32v1Ev();
extern void _ZN8S15661C32v2Ev();
extern void _ZN8S15661C32v3Ev();
extern void _ZN8S15661C32v4Ev();
extern void _ZN8S15661C32v5Ev();
extern void _ZN8S15661C32v6Ev();
static  VTBL_ENTRY vtc_S15661C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15661C3[0]),
  (VTBL_ENTRY)&_ZN8S15661C3D1Ev,
  (VTBL_ENTRY)&_ZN8S15661C3D0Ev,
  (VTBL_ENTRY)&_ZN8S15661C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15661C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15661C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15661C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15661C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15661C43v12Ev,
  (VTBL_ENTRY)&_ZN8S15661C32v1Ev,
  (VTBL_ENTRY)&_ZN8S15661C32v2Ev,
  (VTBL_ENTRY)&_ZN8S15661C32v3Ev,
  (VTBL_ENTRY)&_ZN8S15661C32v4Ev,
  (VTBL_ENTRY)&_ZN8S15661C32v5Ev,
  (VTBL_ENTRY)&_ZN8S15661C32v6Ev,
};
extern VTBL_ENTRY _ZTI8S15661C3[];
extern  VTBL_ENTRY _ZTV8S15661C3[];
Class_Descriptor cd_S15661C3 = {  "S15661C3", // class name
  bases_S15661C3, 2,
  &(vtc_S15661C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,188), // object size
  NSPAIRA(_ZTI8S15661C3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S15661C3),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15661C2  {
  ::S15661C3 s15661c2f0;
  ::S10296C22_nt s15661c2f1;
  void  mf15661c2(); // _ZN8S15661C29mf15661c2Ev
};
//SIG(-1 S15661C2) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FC10{ m FL[2]}} FC9 FC9 FC9}} FC11{ BC7 FC12{ m FC13{ m FL}}} FC11 FC11} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m FC22{ Fs[2] Fc[2] Fs}[12] Fi FC23{ Fs[2]}[4] Fi FC24{ m Fp[2]}}}}


void  S15661C2 ::mf15661c2(){}

static void Test_S15661C2()
{
  {
    init_simple_test("S15661C2");
    S15661C2 lv;
    check2(sizeof(lv), ABISELECT(456,352), "sizeof(S15661C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15661C2)");
    check_field_offset(lv, s15661c2f0, 0, "S15661C2.s15661c2f0");
    check_field_offset(lv, s15661c2f1, ABISELECT(256,188), "S15661C2.s15661c2f1");
  }
}
static Arrange_To_Call_Me vS15661C2(Test_S15661C2, "S15661C2", ABISELECT(456,352));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15661C27  : S15661C4 , S10296C15_nt {
  ::S10296C21_nt s15661c27f0;
  ::S10296C35_nt s15661c27f1;
  ::S10296C35_nt s15661c27f2;
  virtual void  v15(); // _ZN9S15661C273v15Ev
  virtual void  v16(); // _ZN9S15661C273v16Ev
  virtual void  v17(); // _ZN9S15661C273v17Ev
  virtual void  v18(); // _ZN9S15661C273v18Ev
  virtual void  v19(); // _ZN9S15661C273v19Ev
  virtual void  v20(); // _ZN9S15661C273v20Ev
  ~S15661C27(); // tgen
  S15661C27(); // tgen
};
//SIG(-1 S15661C27) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FL[2]}}} FC9{ BC6 FC10{ m FC11{ m Fp[2]} FC12{ m Fp}}} FC9}


void  S15661C27 ::v15(){vfunc_called(this, "_ZN9S15661C273v15Ev");}
void  S15661C27 ::v16(){vfunc_called(this, "_ZN9S15661C273v16Ev");}
void  S15661C27 ::v17(){vfunc_called(this, "_ZN9S15661C273v17Ev");}
void  S15661C27 ::v18(){vfunc_called(this, "_ZN9S15661C273v18Ev");}
void  S15661C27 ::v19(){vfunc_called(this, "_ZN9S15661C273v19Ev");}
void  S15661C27 ::v20(){vfunc_called(this, "_ZN9S15661C273v20Ev");}
S15661C27 ::~S15661C27(){ note_dtor("S15661C27", this);} // tgen
S15661C27 ::S15661C27(){ note_ctor("S15661C27", this);} // tgen

static void Test_S15661C27()
{
  extern Class_Descriptor cd_S15661C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,31)];
    init_test(&cd_S15661C27, buf);
    S15661C27 *dp, &lv = *(dp=new (buf) S15661C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,120), "sizeof(S15661C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15661C27)");
    check_base_class_offset(lv, (S15661C4*), 0, "S15661C27");
    check_base_class_offset(lv, (S10296C15_nt*), 0, "S15661C27");
    check_field_offset(lv, s15661c27f0, ABISELECT(40,20), "S15661C27.s15661c27f0");
    check_field_offset(lv, s15661c27f1, ABISELECT(88,56), "S15661C27.s15661c27f1");
    check_field_offset(lv, s15661c27f2, ABISELECT(144,88), "S15661C27.s15661c27f2");
    test_class_info(&lv, &cd_S15661C27);
    dp->~S15661C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15661C27(Test_S15661C27, "S15661C27", ABISELECT(200,120));

#else // __cplusplus

extern void _ZN9S15661C27C1Ev();
extern void _ZN9S15661C27D1Ev();
Name_Map name_map_S15661C27[] = {
  NSPAIR(_ZN9S15661C27C1Ev),
  NSPAIR(_ZN9S15661C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15661C4;
extern VTBL_ENTRY _ZTI8S15661C4[];
extern  VTBL_ENTRY _ZTV8S15661C4[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S15661C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15661C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S15661C27[];
extern void _ZN9S15661C27D1Ev();
extern void _ZN9S15661C27D0Ev();
extern void _ZN8S15661C42v7Ev();
extern void _ZN8S15661C42v8Ev();
extern void _ZN8S15661C42v9Ev();
extern void _ZN8S15661C43v10Ev();
extern void _ZN8S15661C43v11Ev();
extern void _ZN8S15661C43v12Ev();
extern void _ZN9S15661C273v15Ev();
extern void _ZN9S15661C273v16Ev();
extern void _ZN9S15661C273v17Ev();
extern void _ZN9S15661C273v18Ev();
extern void _ZN9S15661C273v19Ev();
extern void _ZN9S15661C273v20Ev();
static  VTBL_ENTRY vtc_S15661C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S15661C27[0]),
  (VTBL_ENTRY)&_ZN9S15661C27D1Ev,
  (VTBL_ENTRY)&_ZN9S15661C27D0Ev,
  (VTBL_ENTRY)&_ZN8S15661C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15661C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15661C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15661C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15661C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15661C43v12Ev,
  (VTBL_ENTRY)&_ZN9S15661C273v15Ev,
  (VTBL_ENTRY)&_ZN9S15661C273v16Ev,
  (VTBL_ENTRY)&_ZN9S15661C273v17Ev,
  (VTBL_ENTRY)&_ZN9S15661C273v18Ev,
  (VTBL_ENTRY)&_ZN9S15661C273v19Ev,
  (VTBL_ENTRY)&_ZN9S15661C273v20Ev,
};
extern VTBL_ENTRY _ZTI9S15661C27[];
extern  VTBL_ENTRY _ZTV9S15661C27[];
Class_Descriptor cd_S15661C27 = {  "S15661C27", // class name
  bases_S15661C27, 2,
  &(vtc_S15661C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,120), // object size
  NSPAIRA(_ZTI9S15661C27),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S15661C27),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15661C26  {
  ::S15661C27 s15661c26f0;
  ::S10296C36_nt s15661c26f1;
  void  mf15661c26(); // _ZN9S15661C2610mf15661c26Ev
};
//SIG(-1 S15661C26) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FL[2]}}} FC10{ BC7 FC11{ m FC12{ m Fp[2]} FC13{ m Fp}}} FC10} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC20}}}


void  S15661C26 ::mf15661c26(){}

static void Test_S15661C26()
{
  {
    init_simple_test("S15661C26");
    static S15661C26 lv;
    check2(sizeof(lv), ABISELECT(304,180), "sizeof(S15661C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15661C26)");
    check_field_offset(lv, s15661c26f0, 0, "S15661C26.s15661c26f0");
    check_field_offset(lv, s15661c26f1, ABISELECT(200,120), "S15661C26.s15661c26f1");
  }
}
static Arrange_To_Call_Me vS15661C26(Test_S15661C26, "S15661C26", ABISELECT(304,180));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15661C1  {
  ::S15661C2 s15661c1f0;
  ::S15661C26 s15661c1f1;
  void  mf15661c1(); // _ZN8S15661C19mf15661c1Ev
};
//SIG(1 S15661C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC13{ m FC14{ m FL}}} FC12 FC12} FC15{ BC16{ BC17{ vd v13} vd v14 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m FC23{ Fs[2] Fc[2] Fs}[12] Fi FC24{ Fs[2]}[4] Fi FC25{ m Fp[2]}}}} FC26{ m FC27{ BC4 BC6 v15 v16 v17 v18 v19 v20 FC28{ BC8 FC10} FC29{ BC8 FC30{ m FC31{ m Fp[2]} FC32{ m Fp}}} FC29} FC33{ BC34{ BC17 vd v21 Fp[2] FC18 FC25} vd FC35{ m Fp Fi FC36{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC25}}}}


void  S15661C1 ::mf15661c1(){}

static void Test_S15661C1()
{
  {
    init_simple_test("S15661C1");
    static S15661C1 lv;
    check2(sizeof(lv), ABISELECT(760,532), "sizeof(S15661C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15661C1)");
    check_field_offset(lv, s15661c1f0, 0, "S15661C1.s15661c1f0");
    check_field_offset(lv, s15661c1f1, ABISELECT(456,352), "S15661C1.s15661c1f1");
  }
}
static Arrange_To_Call_Me vS15661C1(Test_S15661C1, "S15661C1", ABISELECT(760,532));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15662C4  {
  ::S10296C14_nt s15662c4f0;
  virtual  ~S15662C4(); // _ZN8S15662C4D1Ev
  virtual void  v7(); // _ZN8S15662C42v7Ev
  virtual void  v8(); // _ZN8S15662C42v8Ev
  virtual void  v9(); // _ZN8S15662C42v9Ev
  virtual void  v10(); // _ZN8S15662C43v10Ev
  virtual void  v11(); // _ZN8S15662C43v11Ev
  virtual void  v12(); // _ZN8S15662C43v12Ev
  S15662C4(); // tgen
};
//SIG(-1 S15662C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15662C4 ::~S15662C4(){ note_dtor("S15662C4", this);}
void  S15662C4 ::v7(){vfunc_called(this, "_ZN8S15662C42v7Ev");}
void  S15662C4 ::v8(){vfunc_called(this, "_ZN8S15662C42v8Ev");}
void  S15662C4 ::v9(){vfunc_called(this, "_ZN8S15662C42v9Ev");}
void  S15662C4 ::v10(){vfunc_called(this, "_ZN8S15662C43v10Ev");}
void  S15662C4 ::v11(){vfunc_called(this, "_ZN8S15662C43v11Ev");}
void  S15662C4 ::v12(){vfunc_called(this, "_ZN8S15662C43v12Ev");}
S15662C4 ::S15662C4(){ note_ctor("S15662C4", this);} // tgen

static void Test_S15662C4()
{
  extern Class_Descriptor cd_S15662C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15662C4, buf);
    S15662C4 *dp, &lv = *(dp=new (buf) S15662C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15662C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15662C4)");
    check_field_offset(lv, s15662c4f0, ABISELECT(8,4), "S15662C4.s15662c4f0");
    test_class_info(&lv, &cd_S15662C4);
    dp->~S15662C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15662C4(Test_S15662C4, "S15662C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S15662C4C1Ev();
extern void _ZN8S15662C4D1Ev();
Name_Map name_map_S15662C4[] = {
  NSPAIR(_ZN8S15662C4C1Ev),
  NSPAIR(_ZN8S15662C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15662C4[];
extern void _ZN8S15662C4D1Ev();
extern void _ZN8S15662C4D0Ev();
extern void _ZN8S15662C42v7Ev();
extern void _ZN8S15662C42v8Ev();
extern void _ZN8S15662C42v9Ev();
extern void _ZN8S15662C43v10Ev();
extern void _ZN8S15662C43v11Ev();
extern void _ZN8S15662C43v12Ev();
static  VTBL_ENTRY vtc_S15662C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15662C4[0]),
  (VTBL_ENTRY)&_ZN8S15662C4D1Ev,
  (VTBL_ENTRY)&_ZN8S15662C4D0Ev,
  (VTBL_ENTRY)&_ZN8S15662C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15662C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15662C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15662C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15662C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15662C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S15662C4[];
extern  VTBL_ENTRY _ZTV8S15662C4[];
Class_Descriptor cd_S15662C4 = {  "S15662C4", // class name
  0,0,//no base classes
  &(vtc_S15662C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S15662C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15662C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15662C27_nt  : S15662C4 , S10296C15_nt {
  ::S10296C21_nt s15662c27f0;
  ::S10296C35_nt s15662c27f1;
  virtual void  v15(); // _ZN12S15662C27_nt3v15Ev
  virtual void  v16(); // _ZN12S15662C27_nt3v16Ev
  virtual void  v17(); // _ZN12S15662C27_nt3v17Ev
  virtual void  v18(); // _ZN12S15662C27_nt3v18Ev
  virtual void  v19(); // _ZN12S15662C27_nt3v19Ev
  virtual void  v20(); // _ZN12S15662C27_nt3v20Ev
  ~S15662C27_nt(); // tgen
  S15662C27_nt(); // tgen
};
//SIG(-1 S15662C27_nt) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m FL[2]}}} FC9{ BC6 FC10{ m FC11{ m Fp[2]} FC12{ m Fp}}}}


void  S15662C27_nt ::v15(){vfunc_called(this, "_ZN12S15662C27_nt3v15Ev");}
void  S15662C27_nt ::v16(){vfunc_called(this, "_ZN12S15662C27_nt3v16Ev");}
void  S15662C27_nt ::v17(){vfunc_called(this, "_ZN12S15662C27_nt3v17Ev");}
void  S15662C27_nt ::v18(){vfunc_called(this, "_ZN12S15662C27_nt3v18Ev");}
void  S15662C27_nt ::v19(){vfunc_called(this, "_ZN12S15662C27_nt3v19Ev");}
void  S15662C27_nt ::v20(){vfunc_called(this, "_ZN12S15662C27_nt3v20Ev");}
S15662C27_nt ::~S15662C27_nt(){ note_dtor("S15662C27_nt", this);} // tgen
S15662C27_nt ::S15662C27_nt(){ note_ctor("S15662C27_nt", this);} // tgen

//skip512 S15662C27_nt

#else // __cplusplus

extern void _ZN12S15662C27_ntC1Ev();
extern void _ZN12S15662C27_ntD1Ev();
Name_Map name_map_S15662C27_nt[] = {
  NSPAIR(_ZN12S15662C27_ntC1Ev),
  NSPAIR(_ZN12S15662C27_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15662C4;
extern VTBL_ENTRY _ZTI8S15662C4[];
extern  VTBL_ENTRY _ZTV8S15662C4[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S15662C27_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15662C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S15662C27_nt[];
extern void _ZN12S15662C27_ntD1Ev();
extern void _ZN12S15662C27_ntD0Ev();
extern void _ZN8S15662C42v7Ev();
extern void _ZN8S15662C42v8Ev();
extern void _ZN8S15662C42v9Ev();
extern void _ZN8S15662C43v10Ev();
extern void _ZN8S15662C43v11Ev();
extern void _ZN8S15662C43v12Ev();
extern void _ZN12S15662C27_nt3v15Ev();
extern void _ZN12S15662C27_nt3v16Ev();
extern void _ZN12S15662C27_nt3v17Ev();
extern void _ZN12S15662C27_nt3v18Ev();
extern void _ZN12S15662C27_nt3v19Ev();
extern void _ZN12S15662C27_nt3v20Ev();
static  VTBL_ENTRY vtc_S15662C27_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S15662C27_nt[0]),
  (VTBL_ENTRY)&_ZN12S15662C27_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S15662C27_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S15662C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15662C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15662C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15662C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15662C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15662C43v12Ev,
  (VTBL_ENTRY)&_ZN12S15662C27_nt3v15Ev,
  (VTBL_ENTRY)&_ZN12S15662C27_nt3v16Ev,
  (VTBL_ENTRY)&_ZN12S15662C27_nt3v17Ev,
  (VTBL_ENTRY)&_ZN12S15662C27_nt3v18Ev,
  (VTBL_ENTRY)&_ZN12S15662C27_nt3v19Ev,
  (VTBL_ENTRY)&_ZN12S15662C27_nt3v20Ev,
};
extern VTBL_ENTRY _ZTI12S15662C27_nt[];
VTBL_ENTRY *P__ZTI12S15662C27_nt = _ZTI12S15662C27_nt; 
extern  VTBL_ENTRY _ZTV12S15662C27_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15662C26_nt  {
  ::S15662C27_nt s15662c26f0;
  ::S10296C36_nt s15662c26f1;
  void  mf15662c26(); // _ZN12S15662C26_nt10mf15662c26Ev
};
//SIG(-1 S15662C26_nt) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m FL[2]}}} FC10{ BC7 FC11{ m FC12{ m Fp[2]} FC13{ m Fp}}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC20}}}


void  S15662C26_nt ::mf15662c26(){}

//skip512 S15662C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15662C1  {
  ::S15661C2 s15662c1f0;
  ::S15662C26_nt s15662c1f1;
  void  mf15662c1(); // _ZN8S15662C19mf15662c1Ev
};
//SIG(1 S15662C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC13{ m FC14{ m FL}}} FC12 FC12} FC15{ BC16{ BC17{ vd v13} vd v14 Fp[2] FC18{ m FC19{ m Fp Fi[2] FC20{ m}}} FC21{ m Fp[2]}} vd FC22{ m FC23{ Fs[2] Fc[2] Fs}[12] Fi FC24{ Fs[2]}[4] Fi FC25{ m Fp[2]}}}} FC26{ m FC27{ BC28{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC29{ BC8 FC10} FC30{ BC8 FC31{ m FC32{ m Fp[2]} FC33{ m Fp}}}} FC34{ BC35{ BC17 vd v27 Fp[2] FC18 FC25} vd FC36{ m Fp Fi FC37{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC25}}}}


void  S15662C1 ::mf15662c1(){}

static void Test_S15662C1()
{
  {
    init_simple_test("S15662C1");
    static S15662C1 lv;
    check2(sizeof(lv), ABISELECT(704,500), "sizeof(S15662C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15662C1)");
    check_field_offset(lv, s15662c1f0, 0, "S15662C1.s15662c1f0");
    check_field_offset(lv, s15662c1f1, ABISELECT(456,352), "S15662C1.s15662c1f1");
  }
}
static Arrange_To_Call_Me vS15662C1(Test_S15662C1, "S15662C1", ABISELECT(704,500));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15659C4  {
  ::S10296C14_nt s15659c4f0;
  virtual  ~S15659C4(); // _ZN8S15659C4D1Ev
  virtual void  v7(); // _ZN8S15659C42v7Ev
  virtual void  v8(); // _ZN8S15659C42v8Ev
  virtual void  v9(); // _ZN8S15659C42v9Ev
  virtual void  v10(); // _ZN8S15659C43v10Ev
  virtual void  v11(); // _ZN8S15659C43v11Ev
  virtual void  v12(); // _ZN8S15659C43v12Ev
  S15659C4(); // tgen
};
//SIG(-1 S15659C4) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S15659C4 ::~S15659C4(){ note_dtor("S15659C4", this);}
void  S15659C4 ::v7(){vfunc_called(this, "_ZN8S15659C42v7Ev");}
void  S15659C4 ::v8(){vfunc_called(this, "_ZN8S15659C42v8Ev");}
void  S15659C4 ::v9(){vfunc_called(this, "_ZN8S15659C42v9Ev");}
void  S15659C4 ::v10(){vfunc_called(this, "_ZN8S15659C43v10Ev");}
void  S15659C4 ::v11(){vfunc_called(this, "_ZN8S15659C43v11Ev");}
void  S15659C4 ::v12(){vfunc_called(this, "_ZN8S15659C43v12Ev");}
S15659C4 ::S15659C4(){ note_ctor("S15659C4", this);} // tgen

static void Test_S15659C4()
{
  extern Class_Descriptor cd_S15659C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S15659C4, buf);
    S15659C4 *dp, &lv = *(dp=new (buf) S15659C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S15659C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15659C4)");
    check_field_offset(lv, s15659c4f0, ABISELECT(8,4), "S15659C4.s15659c4f0");
    test_class_info(&lv, &cd_S15659C4);
    dp->~S15659C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15659C4(Test_S15659C4, "S15659C4", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN8S15659C4C1Ev();
extern void _ZN8S15659C4D1Ev();
Name_Map name_map_S15659C4[] = {
  NSPAIR(_ZN8S15659C4C1Ev),
  NSPAIR(_ZN8S15659C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S15659C4[];
extern void _ZN8S15659C4D1Ev();
extern void _ZN8S15659C4D0Ev();
extern void _ZN8S15659C42v7Ev();
extern void _ZN8S15659C42v8Ev();
extern void _ZN8S15659C42v9Ev();
extern void _ZN8S15659C43v10Ev();
extern void _ZN8S15659C43v11Ev();
extern void _ZN8S15659C43v12Ev();
static  VTBL_ENTRY vtc_S15659C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S15659C4[0]),
  (VTBL_ENTRY)&_ZN8S15659C4D1Ev,
  (VTBL_ENTRY)&_ZN8S15659C4D0Ev,
  (VTBL_ENTRY)&_ZN8S15659C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15659C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15659C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15659C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15659C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15659C43v12Ev,
};
extern VTBL_ENTRY _ZTI8S15659C4[];
extern  VTBL_ENTRY _ZTV8S15659C4[];
Class_Descriptor cd_S15659C4 = {  "S15659C4", // class name
  0,0,//no base classes
  &(vtc_S15659C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI8S15659C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S15659C4),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15659C28_nt  : S15659C4 , S10296C15_nt {
  ::S10296C35_nt s15659c28f0;
  ::S10296C21_nt s15659c28f1;
  virtual void  v15(); // _ZN12S15659C28_nt3v15Ev
  virtual void  v16(); // _ZN12S15659C28_nt3v16Ev
  virtual void  v17(); // _ZN12S15659C28_nt3v17Ev
  virtual void  v18(); // _ZN12S15659C28_nt3v18Ev
  virtual void  v19(); // _ZN12S15659C28_nt3v19Ev
  virtual void  v20(); // _ZN12S15659C28_nt3v20Ev
  ~S15659C28_nt(); // tgen
  S15659C28_nt(); // tgen
};
//SIG(-1 S15659C28_nt) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6 FC5{ BC6{ m Fp Fi Fp Fi[2]} FC7{ m FC8{ m Fp[2]} FC9{ m Fp}}} FC10{ BC6 FC11{ m FC12{ m FL[2]}}}}


void  S15659C28_nt ::v15(){vfunc_called(this, "_ZN12S15659C28_nt3v15Ev");}
void  S15659C28_nt ::v16(){vfunc_called(this, "_ZN12S15659C28_nt3v16Ev");}
void  S15659C28_nt ::v17(){vfunc_called(this, "_ZN12S15659C28_nt3v17Ev");}
void  S15659C28_nt ::v18(){vfunc_called(this, "_ZN12S15659C28_nt3v18Ev");}
void  S15659C28_nt ::v19(){vfunc_called(this, "_ZN12S15659C28_nt3v19Ev");}
void  S15659C28_nt ::v20(){vfunc_called(this, "_ZN12S15659C28_nt3v20Ev");}
S15659C28_nt ::~S15659C28_nt(){ note_dtor("S15659C28_nt", this);} // tgen
S15659C28_nt ::S15659C28_nt(){ note_ctor("S15659C28_nt", this);} // tgen

//skip512 S15659C28_nt

#else // __cplusplus

extern void _ZN12S15659C28_ntC1Ev();
extern void _ZN12S15659C28_ntD1Ev();
Name_Map name_map_S15659C28_nt[] = {
  NSPAIR(_ZN12S15659C28_ntC1Ev),
  NSPAIR(_ZN12S15659C28_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15659C4;
extern VTBL_ENTRY _ZTI8S15659C4[];
extern  VTBL_ENTRY _ZTV8S15659C4[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S15659C28_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15659C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S15659C28_nt[];
extern void _ZN12S15659C28_ntD1Ev();
extern void _ZN12S15659C28_ntD0Ev();
extern void _ZN8S15659C42v7Ev();
extern void _ZN8S15659C42v8Ev();
extern void _ZN8S15659C42v9Ev();
extern void _ZN8S15659C43v10Ev();
extern void _ZN8S15659C43v11Ev();
extern void _ZN8S15659C43v12Ev();
extern void _ZN12S15659C28_nt3v15Ev();
extern void _ZN12S15659C28_nt3v16Ev();
extern void _ZN12S15659C28_nt3v17Ev();
extern void _ZN12S15659C28_nt3v18Ev();
extern void _ZN12S15659C28_nt3v19Ev();
extern void _ZN12S15659C28_nt3v20Ev();
static  VTBL_ENTRY vtc_S15659C28_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S15659C28_nt[0]),
  (VTBL_ENTRY)&_ZN12S15659C28_ntD1Ev,
  (VTBL_ENTRY)&_ZN12S15659C28_ntD0Ev,
  (VTBL_ENTRY)&_ZN8S15659C42v7Ev,
  (VTBL_ENTRY)&_ZN8S15659C42v8Ev,
  (VTBL_ENTRY)&_ZN8S15659C42v9Ev,
  (VTBL_ENTRY)&_ZN8S15659C43v10Ev,
  (VTBL_ENTRY)&_ZN8S15659C43v11Ev,
  (VTBL_ENTRY)&_ZN8S15659C43v12Ev,
  (VTBL_ENTRY)&_ZN12S15659C28_nt3v15Ev,
  (VTBL_ENTRY)&_ZN12S15659C28_nt3v16Ev,
  (VTBL_ENTRY)&_ZN12S15659C28_nt3v17Ev,
  (VTBL_ENTRY)&_ZN12S15659C28_nt3v18Ev,
  (VTBL_ENTRY)&_ZN12S15659C28_nt3v19Ev,
  (VTBL_ENTRY)&_ZN12S15659C28_nt3v20Ev,
};
extern VTBL_ENTRY _ZTI12S15659C28_nt[];
VTBL_ENTRY *P__ZTI12S15659C28_nt = _ZTI12S15659C28_nt; 
extern  VTBL_ENTRY _ZTV12S15659C28_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15659C27_nt  {
  ::S15659C28_nt s15659c27f0;
  ::S10296C36_nt s15659c27f1;
  void  mf15659c27(); // _ZN12S15659C27_nt10mf15659c27Ev
};
//SIG(-1 S15659C27_nt) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6 FC6{ BC7{ m Fp Fi Fp Fi[2]} FC8{ m FC9{ m Fp[2]} FC10{ m Fp}}} FC11{ BC7 FC12{ m FC13{ m FL[2]}}}} FC14{ BC15{ BC16{ vd v13} vd v14 Fp[2] FC17{ m FC18{ m Fp Fi[2] FC19{ m}}} FC20{ m Fp[2]}} vd FC21{ m Fp Fi FC22{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC20}}}


void  S15659C27_nt ::mf15659c27(){}

//skip512 S15659C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15659C1  {
  ::S15657C2 s15659c1f0;
  ::S15659C27_nt s15659c1f1;
  void  mf15659c1(); // _ZN8S15659C19mf15659c1Ev
};
//SIG(1 S15659C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC10} FC13{ BC8 FC14{ m FC15{ m FL}}}} FC16{ BC17{ BC18{ vd v13} vd v14 Fp[2] FC19{ m FC20{ m Fp Fi[2] FC21{ m}}} FC22{ m Fp[2]}} vd FC23{ m FC24{ Fs[2] Fc[2] Fs}[12] Fi FC25{ Fs[2]}[4] Fi FC26{ m Fp[2]}}}} FC27{ m FC28{ BC29{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC30{ BC8 FC31{ m FC32{ m Fp[2]} FC33{ m Fp}}} FC12} FC34{ BC35{ BC18 vd v27 Fp[2] FC19 FC26} vd FC36{ m Fp Fi FC37{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC26}}}}


void  S15659C1 ::mf15659c1(){}

static void Test_S15659C1()
{
  {
    init_simple_test("S15659C1");
    static S15659C1 lv;
    check2(sizeof(lv), ABISELECT(672,480), "sizeof(S15659C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15659C1)");
    check_field_offset(lv, s15659c1f0, 0, "S15659C1.s15659c1f0");
    check_field_offset(lv, s15659c1f1, ABISELECT(424,332), "S15659C1.s15659c1f1");
  }
}
static Arrange_To_Call_Me vS15659C1(Test_S15659C1, "S15659C1", ABISELECT(672,480));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15660C1  {
  ::S15657C2 s15660c1f0;
  ::S10296C33_nt s15660c1f1;
  void  mf15660c1(); // _ZN8S15660C19mf15660c1Ev
};
//SIG(1 S15660C1) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6 FC7{ BC8{ m Fp Fi Fp Fi[2]} FC9{ m FC10{ m FC11{ m FL[2]}} FC10 FC10 FC10}} FC12{ BC8 FC10} FC13{ BC8 FC14{ m FC15{ m FL}}}} FC16{ BC17{ BC18{ vd v13} vd v14 Fp[2] FC19{ m FC20{ m Fp Fi[2] FC21{ m}}} FC22{ m Fp[2]}} vd FC23{ m FC24{ Fs[2] Fc[2] Fs}[12] Fi FC25{ Fs[2]}[4] Fi FC26{ m Fp[2]}}}} FC27{ m FC28{ BC29{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC30{ BC8 FC31{ m FC32{ m Fp[2]} FC33{ m Fp}}}} FC34{ BC35{ BC18 vd v27 Fp[2] FC19 FC26} vd FC36{ m Fp Fi FC37{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC26}}}}


void  S15660C1 ::mf15660c1(){}

static void Test_S15660C1()
{
  {
    init_simple_test("S15660C1");
    static S15660C1 lv;
    check2(sizeof(lv), ABISELECT(624,444), "sizeof(S15660C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15660C1)");
    check_field_offset(lv, s15660c1f0, 0, "S15660C1.s15660c1f0");
    check_field_offset(lv, s15660c1f1, ABISELECT(424,332), "S15660C1.s15660c1f1");
  }
}
static Arrange_To_Call_Me vS15660C1(Test_S15660C1, "S15660C1", ABISELECT(624,444));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16395C10  {
  ::S10296C14_nt s16395c10f0;
  virtual  ~S16395C10(); // _ZN9S16395C10D1Ev
  virtual void  v7(); // _ZN9S16395C102v7Ev
  virtual void  v8(); // _ZN9S16395C102v8Ev
  virtual void  v9(); // _ZN9S16395C102v9Ev
  virtual void  v10(); // _ZN9S16395C103v10Ev
  virtual void  v11(); // _ZN9S16395C103v11Ev
  virtual void  v12(); // _ZN9S16395C103v12Ev
  S16395C10(); // tgen
};
//SIG(-1 S16395C10) C1{ vd v1 v2 v3 v4 v5 v6 FC2{ m Fp[4]}}


 S16395C10 ::~S16395C10(){ note_dtor("S16395C10", this);}
void  S16395C10 ::v7(){vfunc_called(this, "_ZN9S16395C102v7Ev");}
void  S16395C10 ::v8(){vfunc_called(this, "_ZN9S16395C102v8Ev");}
void  S16395C10 ::v9(){vfunc_called(this, "_ZN9S16395C102v9Ev");}
void  S16395C10 ::v10(){vfunc_called(this, "_ZN9S16395C103v10Ev");}
void  S16395C10 ::v11(){vfunc_called(this, "_ZN9S16395C103v11Ev");}
void  S16395C10 ::v12(){vfunc_called(this, "_ZN9S16395C103v12Ev");}
S16395C10 ::S16395C10(){ note_ctor("S16395C10", this);} // tgen

static void Test_S16395C10()
{
  extern Class_Descriptor cd_S16395C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[6];
    init_test(&cd_S16395C10, buf);
    S16395C10 *dp, &lv = *(dp=new (buf) S16395C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S16395C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16395C10)");
    check_field_offset(lv, s16395c10f0, ABISELECT(8,4), "S16395C10.s16395c10f0");
    test_class_info(&lv, &cd_S16395C10);
    dp->~S16395C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS16395C10(Test_S16395C10, "S16395C10", ABISELECT(40,20));

#else // __cplusplus

extern void _ZN9S16395C10C1Ev();
extern void _ZN9S16395C10D1Ev();
Name_Map name_map_S16395C10[] = {
  NSPAIR(_ZN9S16395C10C1Ev),
  NSPAIR(_ZN9S16395C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S16395C10[];
extern void _ZN9S16395C10D1Ev();
extern void _ZN9S16395C10D0Ev();
extern void _ZN9S16395C102v7Ev();
extern void _ZN9S16395C102v8Ev();
extern void _ZN9S16395C102v9Ev();
extern void _ZN9S16395C103v10Ev();
extern void _ZN9S16395C103v11Ev();
extern void _ZN9S16395C103v12Ev();
static  VTBL_ENTRY vtc_S16395C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S16395C10[0]),
  (VTBL_ENTRY)&_ZN9S16395C10D1Ev,
  (VTBL_ENTRY)&_ZN9S16395C10D0Ev,
  (VTBL_ENTRY)&_ZN9S16395C102v7Ev,
  (VTBL_ENTRY)&_ZN9S16395C102v8Ev,
  (VTBL_ENTRY)&_ZN9S16395C102v9Ev,
  (VTBL_ENTRY)&_ZN9S16395C103v10Ev,
  (VTBL_ENTRY)&_ZN9S16395C103v11Ev,
  (VTBL_ENTRY)&_ZN9S16395C103v12Ev,
};
extern VTBL_ENTRY _ZTI9S16395C10[];
extern  VTBL_ENTRY _ZTV9S16395C10[];
Class_Descriptor cd_S16395C10 = {  "S16395C10", // class name
  0,0,//no base classes
  &(vtc_S16395C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,20), // object size
  NSPAIRA(_ZTI9S16395C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S16395C10),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16395C9_nt  : S16395C10 , S10296C15_nt {
  virtual void  v1(); // _ZN11S16395C9_nt2v1Ev
  virtual void  v2(); // _ZN11S16395C9_nt2v2Ev
  virtual void  v3(); // _ZN11S16395C9_nt2v3Ev
  virtual void  v4(); // _ZN11S16395C9_nt2v4Ev
  virtual void  v5(); // _ZN11S16395C9_nt2v5Ev
  virtual void  v6(); // _ZN11S16395C9_nt2v6Ev
  ~S16395C9_nt(); // tgen
  S16395C9_nt(); // tgen
};
//SIG(-1 S16395C9_nt) C1{ BC2{ vd v7 v8 v9 v10 v11 v12 FC3{ m Fp[4]}} BC4{} v1 v2 v3 v4 v5 v6}


void  S16395C9_nt ::v1(){vfunc_called(this, "_ZN11S16395C9_nt2v1Ev");}
void  S16395C9_nt ::v2(){vfunc_called(this, "_ZN11S16395C9_nt2v2Ev");}
void  S16395C9_nt ::v3(){vfunc_called(this, "_ZN11S16395C9_nt2v3Ev");}
void  S16395C9_nt ::v4(){vfunc_called(this, "_ZN11S16395C9_nt2v4Ev");}
void  S16395C9_nt ::v5(){vfunc_called(this, "_ZN11S16395C9_nt2v5Ev");}
void  S16395C9_nt ::v6(){vfunc_called(this, "_ZN11S16395C9_nt2v6Ev");}
S16395C9_nt ::~S16395C9_nt(){ note_dtor("S16395C9_nt", this);} // tgen
S16395C9_nt ::S16395C9_nt(){ note_ctor("S16395C9_nt", this);} // tgen

//skip512 S16395C9_nt

#else // __cplusplus

extern void _ZN11S16395C9_ntC1Ev();
extern void _ZN11S16395C9_ntD1Ev();
Name_Map name_map_S16395C9_nt[] = {
  NSPAIR(_ZN11S16395C9_ntC1Ev),
  NSPAIR(_ZN11S16395C9_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S16395C10;
extern VTBL_ENTRY _ZTI9S16395C10[];
extern  VTBL_ENTRY _ZTV9S16395C10[];
extern Class_Descriptor cd_S10296C15_nt;
extern VTBL_ENTRY _ZTI12S10296C15_nt[];
static Base_Class bases_S16395C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S16395C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10296C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI11S16395C9_nt[];
extern void _ZN11S16395C9_ntD1Ev();
extern void _ZN11S16395C9_ntD0Ev();
extern void _ZN9S16395C102v7Ev();
extern void _ZN9S16395C102v8Ev();
extern void _ZN9S16395C102v9Ev();
extern void _ZN9S16395C103v10Ev();
extern void _ZN9S16395C103v11Ev();
extern void _ZN9S16395C103v12Ev();
extern void _ZN11S16395C9_nt2v1Ev();
extern void _ZN11S16395C9_nt2v2Ev();
extern void _ZN11S16395C9_nt2v3Ev();
extern void _ZN11S16395C9_nt2v4Ev();
extern void _ZN11S16395C9_nt2v5Ev();
extern void _ZN11S16395C9_nt2v6Ev();
static  VTBL_ENTRY vtc_S16395C9_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S16395C9_nt[0]),
  (VTBL_ENTRY)&_ZN11S16395C9_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S16395C9_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S16395C102v7Ev,
  (VTBL_ENTRY)&_ZN9S16395C102v8Ev,
  (VTBL_ENTRY)&_ZN9S16395C102v9Ev,
  (VTBL_ENTRY)&_ZN9S16395C103v10Ev,
  (VTBL_ENTRY)&_ZN9S16395C103v11Ev,
  (VTBL_ENTRY)&_ZN9S16395C103v12Ev,
  (VTBL_ENTRY)&_ZN11S16395C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN11S16395C9_nt2v2Ev,
  (VTBL_ENTRY)&_ZN11S16395C9_nt2v3Ev,
  (VTBL_ENTRY)&_ZN11S16395C9_nt2v4Ev,
  (VTBL_ENTRY)&_ZN11S16395C9_nt2v5Ev,
  (VTBL_ENTRY)&_ZN11S16395C9_nt2v6Ev,
};
extern VTBL_ENTRY _ZTI11S16395C9_nt[];
VTBL_ENTRY *P__ZTI11S16395C9_nt = _ZTI11S16395C9_nt; 
extern  VTBL_ENTRY _ZTV11S16395C9_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16395C8_nt  {
  ::S16395C9_nt s16395c8f0;
  ::S10296C22_nt s16395c8f1;
  void  mf16395c8(); // _ZN11S16395C8_nt9mf16395c8Ev
};
//SIG(-1 S16395C8_nt) C1{ m FC2{ BC3{ vd v7 v8 v9 v10 v11 v12 FC4{ m Fp[4]}} BC5{} v1 v2 v3 v4 v5 v6} FC6{ BC7{ BC8{ vd v13} vd v14 Fp[2] FC9{ m FC10{ m Fp Fi[2] FC11{ m}}} FC12{ m Fp[2]}} vd FC13{ m FC14{ Fs[2] Fc[2] Fs}[12] Fi FC15{ Fs[2]}[4] Fi FC16{ m Fp[2]}}}}


void  S16395C8_nt ::mf16395c8(){}

//skip512 S16395C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16395C7  {
  ::S16395C8_nt s16395c7f0;
  ::S10296C33_nt s16395c7f1;
  void  mf16395c7(); // _ZN8S16395C79mf16395c7Ev
};
//SIG(-1 S16395C7) C1{ m FC2{ m FC3{ BC4{ vd v7 v8 v9 v10 v11 v12 FC5{ m Fp[4]}} BC6{} v1 v2 v3 v4 v5 v6} FC7{ BC8{ BC9{ vd v13} vd v14 Fp[2] FC10{ m FC11{ m Fp Fi[2] FC12{ m}}} FC13{ m Fp[2]}} vd FC14{ m FC15{ Fs[2] Fc[2] Fs}[12] Fi FC16{ Fs[2]}[4] Fi FC17{ m Fp[2]}}}} FC18{ m FC19{ BC20{ vd v21 v22 v23 v24 v25 v26 FC5} BC6 v15 v16 v17 v18 v19 v20 FC21{ BC22{ m Fp Fi Fp Fi[2]} FC23{ m FC24{ m Fp[2]} FC25{ m Fp}}}} FC26{ BC27{ BC9 vd v27 Fp[2] FC10 FC17} vd FC28{ m Fp Fi FC29{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC17}}}}


void  S16395C7 ::mf16395c7(){}

static void Test_S16395C7()
{
  {
    init_simple_test("S16395C7");
    static S16395C7 lv;
    check2(sizeof(lv), ABISELECT(440,296), "sizeof(S16395C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16395C7)");
    check_field_offset(lv, s16395c7f0, 0, "S16395C7.s16395c7f0");
    check_field_offset(lv, s16395c7f1, ABISELECT(240,184), "S16395C7.s16395c7f1");
  }
}
static Arrange_To_Call_Me vS16395C7(Test_S16395C7, "S16395C7", ABISELECT(440,296));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16395C1  {
  ::S10296C48 s16395c1f0[2];
  ::S10296C32 s16395c1f1;
  ::S10296C7_nt s16395c1f2;
  ::S16395C7 s16395c1f3;
  char s16395c1f4;
  void  mf16395c1(); // _ZN8S16395C19mf16395c1Ev
};
//SIG(1 S16395C1) C1{ m FC2{ m Fp[2]}[2] FC3{ m Fp[2]} FC4{ m FC5{ m Fp[2]} FC6{ m Fp[2]}} FC7{ m FC8{ m FC9{ BC10{ vd v7 v8 v9 v10 v11 v12 FC11{ m Fp[4]}} BC12{} v1 v2 v3 v4 v5 v6} FC13{ BC14{ BC15{ vd v13} vd v14 Fp[2] FC16{ m FC17{ m Fp Fi[2] FC18{ m}}} FC6} vd FC19{ m FC20{ Fs[2] Fc[2] Fs}[12] Fi FC21{ Fs[2]}[4] Fi FC3}}} FC22{ m FC23{ BC24{ vd v21 v22 v23 v24 v25 v26 FC11} BC12 v15 v16 v17 v18 v19 v20 FC25{ BC26{ m Fp Fi Fp Fi[2]} FC27{ m FC5 FC28{ m Fp}}}} FC29{ BC30{ BC15 vd v27 Fp[2] FC16 FC3} vd FC31{ m Fp Fi FC32{ Fc Fc:4 Fc:4 Fc:4 Fc:4 Fc:4 Fc:4} Fi FC3}}}} Fc}


void  S16395C1 ::mf16395c1(){}

static void Test_S16395C1()
{
  {
    init_simple_test("S16395C1");
    static S16395C1 lv;
    check2(sizeof(lv), ABISELECT(528,340), "sizeof(S16395C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16395C1)");
    check_field_offset(lv, s16395c1f0, 0, "S16395C1.s16395c1f0");
    check_field_offset(lv, s16395c1f1, ABISELECT(32,16), "S16395C1.s16395c1f1");
    check_field_offset(lv, s16395c1f2, ABISELECT(48,24), "S16395C1.s16395c1f2");
    check_field_offset(lv, s16395c1f3, ABISELECT(80,40), "S16395C1.s16395c1f3");
    check_field_offset(lv, s16395c1f4, ABISELECT(520,336), "S16395C1.s16395c1f4");
  }
}
static Arrange_To_Call_Me vS16395C1(Test_S16395C1, "S16395C1", ABISELECT(528,340));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C7_nt  {
  long double s20948c7f0;
  void  mf20948c7(); // _ZN11S20948C7_nt9mf20948c7Ev
  virtual  ~S20948C7_nt(); // _ZN11S20948C7_ntD1Ev
  S20948C7_nt(); // tgen
};
//SIG(-1 S20948C7_nt) C1{ vd m FD}


void  S20948C7_nt ::mf20948c7(){}
 S20948C7_nt ::~S20948C7_nt(){ note_dtor("S20948C7_nt", this);}
S20948C7_nt ::S20948C7_nt(){ note_ctor("S20948C7_nt", this);} // tgen

//skip512 S20948C7_nt

#else // __cplusplus

extern void _ZN11S20948C7_ntC1Ev();
extern void _ZN11S20948C7_ntD1Ev();
Name_Map name_map_S20948C7_nt[] = {
  NSPAIR(_ZN11S20948C7_ntC1Ev),
  NSPAIR(_ZN11S20948C7_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern void _ZN11S20948C7_ntD1Ev();
extern void _ZN11S20948C7_ntD0Ev();
static  VTBL_ENTRY vtc_S20948C7_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S20948C7_nt[0]),
  (VTBL_ENTRY)&_ZN11S20948C7_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S20948C7_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
VTBL_ENTRY *P__ZTI11S20948C7_nt = _ZTI11S20948C7_nt; 
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
Class_Descriptor cd_S20948C7_nt = {  "S20948C7_nt", // class name
  0,0,//no base classes
  &(vtc_S20948C7_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI11S20948C7_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S20948C7_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C5  : S9624C48 , virtual S20948C7_nt {
  virtual  ~S20948C5(); // _ZN8S20948C5D2Ev
  S20948C5(); // tgen
};
//SIG(-1 S20948C5) C1{ BC2{ m} VBC3{ vd m FD} vd}


 S20948C5 ::~S20948C5(){ note_dtor("S20948C5", this);}
S20948C5 ::S20948C5(){ note_ctor("S20948C5", this);} // tgen

static void Test_S20948C5()
{
  extern Class_Descriptor cd_S20948C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4,6)];
    init_test(&cd_S20948C5, buf);
    S20948C5 *dp, &lv = *(dp=new (buf) S20948C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,20), "sizeof(S20948C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C5)");
    check_base_class_offset(lv, (S9624C48*), 0, "S20948C5");
    check_base_class_offset(lv, (S20948C7_nt*), ABISELECT(16,4), "S20948C5");
    test_class_info(&lv, &cd_S20948C5);
    dp->~S20948C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C5(Test_S20948C5, "S20948C5", ABISELECT(48,20));

#else // __cplusplus

extern void _ZN8S20948C5C1Ev();
extern void _ZN8S20948C5D2Ev();
Name_Map name_map_S20948C5[] = {
  NSPAIR(_ZN8S20948C5C1Ev),
  NSPAIR(_ZN8S20948C5D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
static Base_Class bases_S20948C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C7_nt,    ABISELECT(16,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20948C5[];
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn16_N8S20948C5D1Ev,_ZThn4_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn16_N8S20948C5D0Ev,_ZThn4_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20948C5[] = {
  ABISELECT(16,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
  ABISELECT(-16,-4),
  ABISELECT(-16,-4),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern VTBL_ENTRY _ZTV8S20948C5[];
static  VTT_ENTRY vtt_S20948C5[] = {
  {&(_ZTV8S20948C5[3]),  3,10},
  {&(_ZTV8S20948C5[8]),  8,10},
};
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S20948C5D0Ev,_ZThn4_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S20948C5D1Ev,_ZThn4_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C5 = {  "S20948C5", // class name
  bases_S20948C5, 2,
  &(vtc_S20948C5[0]), // expected_vtbl_contents
  &(vtt_S20948C5[0]), // expected_vtt_contents
  ABISELECT(48,20), // object size
  NSPAIRA(_ZTI8S20948C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20948C5),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20948C5),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C8  {
  char s20948c8f0[7];
  void  mf20948c8(); // _ZN8S20948C89mf20948c8Ev
};
//SIG(-1 S20948C8) C1{ m Fc[7]}


void  S20948C8 ::mf20948c8(){}

static void Test_S20948C8()
{
  {
    init_simple_test("S20948C8");
    S20948C8 lv;
    check2(sizeof(lv), 7, "sizeof(S20948C8)");
    check2(__alignof__(lv), 1, "__alignof__(S20948C8)");
    check_field_offset(lv, s20948c8f0, 0, "S20948C8.s20948c8f0");
  }
}
static Arrange_To_Call_Me vS20948C8(Test_S20948C8, "S20948C8", 7);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S20948C8[];
VTBL_ENTRY *P__ZTI8S20948C8 = _ZTI8S20948C8; 
Class_Descriptor cd_S20948C8 = {  "S20948C8", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  7, // object size
  NSPAIRA(_ZTI8S20948C8),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C9_nt  {
  virtual void  v1(); // _ZN11S20948C9_nt2v1Ev
  ~S20948C9_nt(); // tgen
  S20948C9_nt(); // tgen
};
//SIG(-1 S20948C9_nt) C1{ v1}


void  S20948C9_nt ::v1(){vfunc_called(this, "_ZN11S20948C9_nt2v1Ev");}
S20948C9_nt ::~S20948C9_nt(){ note_dtor("S20948C9_nt", this);} // tgen
S20948C9_nt ::S20948C9_nt(){ note_ctor("S20948C9_nt", this);} // tgen

//skip512 S20948C9_nt

#else // __cplusplus

extern void _ZN11S20948C9_ntC1Ev();
extern void _ZN11S20948C9_ntD1Ev();
Name_Map name_map_S20948C9_nt[] = {
  NSPAIR(_ZN11S20948C9_ntC1Ev),
  NSPAIR(_ZN11S20948C9_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY vtc_S20948C9_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S20948C9_nt[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
VTBL_ENTRY *P__ZTI11S20948C9_nt = _ZTI11S20948C9_nt; 
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
Class_Descriptor cd_S20948C9_nt = {  "S20948C9_nt", // class name
  0,0,//no base classes
  &(vtc_S20948C9_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S20948C9_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S20948C9_nt),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C4  : S20948C5 , S20948C8 , S20948C9_nt , virtual S9624C48 {
  ~S20948C4(); // tgen
  S20948C4(); // tgen
};
//SIG(-1 S20948C4) C1{ BC2{ BC3{ m} VBC4{ vd m FD} vd} BC5{ m Fc[7]} BC6{ v1} VBC3}


S20948C4 ::~S20948C4(){ note_dtor("S20948C4", this);} // tgen
S20948C4 ::S20948C4(){ note_ctor("S20948C4", this);} // tgen

static void Test_S20948C4()
{
  extern Class_Descriptor cd_S20948C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(6,10)];
    init_test(&cd_S20948C4, buf);
    S20948C4 *dp, &lv = *(dp=new (buf) S20948C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,36), "sizeof(S20948C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C4)");
    check_base_class_offset(lv, (S9624C48*)(S20948C5*), 0, "S20948C4");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*), ABISELECT(32,16), "S20948C4");
    check_base_class_offset(lv, (S20948C5*), 0, "S20948C4");
    check_base_class_offset(lv, (S20948C8*), ABISELECT(8,4), "S20948C4");
    check_base_class_offset(lv, (S20948C9_nt*), ABISELECT(16,12), "S20948C4");
    /*is_ambiguous_... S20948C4::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*), ABISELECT(64,32), "S20948C4");
    test_class_info(&lv, &cd_S20948C4);
    dp->~S20948C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C4(Test_S20948C4, "S20948C4", ABISELECT(80,36));

#else // __cplusplus

extern void _ZN8S20948C4C1Ev();
extern void _ZN8S20948C4D1Ev();
Name_Map name_map_S20948C4[] = {
  NSPAIR(_ZN8S20948C4C1Ev),
  NSPAIR(_ZN8S20948C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
static Base_Class bases_S20948C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20948C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C8,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C9_nt,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C48,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20948C4[];
extern void _ZN8S20948C4D1Ev();
extern void _ZN8S20948C4D0Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev)();
extern void ABISELECT(_ZThn32_N8S20948C4D1Ev,_ZThn16_N8S20948C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev)();
extern void ABISELECT(_ZThn32_N8S20948C4D0Ev,_ZThn16_N8S20948C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20948C4[] = {
  ABISELECT(64,32),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&_ZN8S20948C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C4D0Ev,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev),
};
extern VTBL_ENTRY _ZTV8S20948C4[];
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C5__8S20948C4[] = {
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn32_N8S20948C5D1Ev,_ZThn16_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn32_N8S20948C5D0Ev,_ZThn16_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C5__8S20948C4[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
static  VTT_ENTRY vtt_S20948C4[] = {
  {&(_ZTV8S20948C4[4]),  4,14},
  {&(_tg__ZTV8S20948C5__8S20948C4[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C5__8S20948C4[3]),  3,5},
  {&(_ZTV8S20948C4[12]),  12,14},
};
extern VTBL_ENTRY _ZTI8S20948C4[];
extern  VTBL_ENTRY _ZTV8S20948C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C4[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C5D0Ev,_ZThn16_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C5D1Ev,_ZThn16_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C4D0Ev,_ZThn16_N8S20948C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C4D1Ev,_ZThn16_N8S20948C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C4 = {  "S20948C4", // class name
  bases_S20948C4, 6,
  &(vtc_S20948C4[0]), // expected_vtbl_contents
  &(vtt_S20948C4[0]), // expected_vtt_contents
  ABISELECT(80,36), // object size
  NSPAIRA(_ZTI8S20948C4),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20948C4),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20948C4),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C10  : S20948C9_nt , virtual S9624C39 {
  int s20948c10f0:23;
  virtual  ~S20948C10(); // _ZN9S20948C10D2Ev
  S20948C10(); // tgen
};
//SIG(-1 S20948C10) C1{ BC2{ v1} VBC3{ m} vd Fi:23}


 S20948C10 ::~S20948C10(){ note_dtor("S20948C10", this);}
S20948C10 ::S20948C10(){ note_ctor("S20948C10", this);} // tgen

static void Test_S20948C10()
{
  extern Class_Descriptor cd_S20948C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S20948C10, buf);
    S20948C10 *dp, &lv = *(dp=new (buf) S20948C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S20948C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20948C10)");
    check_base_class_offset(lv, (S20948C9_nt*), 0, "S20948C10");
    check_base_class_offset(lv, (S9624C39*), 0, "S20948C10");
    set_bf_and_test(lv, s20948c10f0, ABISELECT(8,4), 0, 23, 1, "S20948C10");
    set_bf_and_test(lv, s20948c10f0, ABISELECT(8,4), 0, 23, hide_sll(1LL<<22), "S20948C10");
    test_class_info(&lv, &cd_S20948C10);
    dp->~S20948C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C10(Test_S20948C10, "S20948C10", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN9S20948C10C1Ev();
extern void _ZN9S20948C10D2Ev();
Name_Map name_map_S20948C10[] = {
  NSPAIR(_ZN9S20948C10C1Ev),
  NSPAIR(_ZN9S20948C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
static Base_Class bases_S20948C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20948C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C10[];
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C10D1Ev();
extern void _ZN9S20948C10D0Ev();
static  VTBL_ENTRY vtc_S20948C10[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C10[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D0Ev,
};
extern VTBL_ENTRY _ZTV9S20948C10[];
static  VTT_ENTRY vtt_S20948C10[] = {
  {&(_ZTV9S20948C10[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20948C10[];
extern  VTBL_ENTRY _ZTV9S20948C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C10[];
Class_Descriptor cd_S20948C10 = {  "S20948C10", // class name
  bases_S20948C10, 2,
  &(vtc_S20948C10[0]), // expected_vtbl_contents
  &(vtt_S20948C10[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI9S20948C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20948C10),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C10),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C12  : S20948C8 , virtual S20948C5 , virtual S9624C48 {
  virtual  ~S20948C12(); // _ZN9S20948C12D2Ev
  S20948C12(); // tgen
};
//SIG(-1 S20948C12) C1{ BC2{ m Fc[7]} VBC3{ BC4{ m} VBC5{ vd m FD} vd} VBC4 vd}


 S20948C12 ::~S20948C12(){ note_dtor("S20948C12", this);}
S20948C12 ::S20948C12(){ note_ctor("S20948C12", this);} // tgen

static void Test_S20948C12()
{
  extern Class_Descriptor cd_S20948C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(5,9)];
    init_test(&cd_S20948C12, buf);
    S20948C12 *dp, &lv = *(dp=new (buf) S20948C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(S20948C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C12)");
    check_base_class_offset(lv, (S20948C8*), ABISELECT(8,4), "S20948C12");
    check_base_class_offset(lv, (S9624C48*)(S20948C5*), 0, "S20948C12");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*), ABISELECT(16,12), "S20948C12");
    check_base_class_offset(lv, (S20948C5*), 0, "S20948C12");
    /*is_ambiguous_... S20948C12::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*), ABISELECT(48,28), "S20948C12");
    test_class_info(&lv, &cd_S20948C12);
    dp->~S20948C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C12(Test_S20948C12, "S20948C12", ABISELECT(64,32));

#else // __cplusplus

extern void _ZN9S20948C12C1Ev();
extern void _ZN9S20948C12D2Ev();
Name_Map name_map_S20948C12[] = {
  NSPAIR(_ZN9S20948C12C1Ev),
  NSPAIR(_ZN9S20948C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
static Base_Class bases_S20948C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20948C8,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(16,12), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20948C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S9624C48,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C12[];
extern void _ZN9S20948C12D1Ev();
extern void _ZN9S20948C12D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S20948C12D1Ev,_ZTv0_n12_N9S20948C12D1Ev)();
extern void ABISELECT(_ZThn16_N9S20948C12D1Ev,_ZThn12_N9S20948C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C12D0Ev,_ZTv0_n12_N9S20948C12D0Ev)();
extern void ABISELECT(_ZThn16_N9S20948C12D0Ev,_ZThn12_N9S20948C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20948C12[] = {
  ABISELECT(48,28),
  0,
  0,
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C12[0]),
  (VTBL_ENTRY)&_ZN9S20948C12D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C12D0Ev,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S20948C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C12D1Ev,_ZTv0_n12_N9S20948C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C12D0Ev,_ZTv0_n12_N9S20948C12D0Ev),
};
extern VTBL_ENTRY _ZTV9S20948C12[];
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C12[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn16_N8S20948C5D1Ev,_ZThn12_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn16_N8S20948C5D0Ev,_ZThn12_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C5__9S20948C12[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
static  VTT_ENTRY vtt_S20948C12[] = {
  {&(_ZTV9S20948C12[6]),  6,13},
  {&(_ZTV9S20948C12[6]),  6,13},
  {&(_ZTV9S20948C12[11]),  11,13},
  {&(_tg__ZTV8S20948C5__9S20948C12[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C5__9S20948C12[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S20948C12[];
extern  VTBL_ENTRY _ZTV9S20948C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C12[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S20948C5D0Ev,_ZThn12_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S20948C5D1Ev,_ZThn12_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C12D0Ev,_ZTv0_n12_N9S20948C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S20948C12D0Ev,_ZThn12_N9S20948C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C12D1Ev,_ZTv0_n12_N9S20948C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S20948C12D1Ev,_ZThn12_N9S20948C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C12 = {  "S20948C12", // class name
  bases_S20948C12, 5,
  &(vtc_S20948C12[0]), // expected_vtbl_contents
  &(vtt_S20948C12[0]), // expected_vtt_contents
  ABISELECT(64,32), // object size
  NSPAIRA(_ZTI9S20948C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20948C12),13, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C12),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C15  : S9624C39 {
  ::S9624C48 s20948c15f0;
  ::S9624C39 s20948c15f1;
};
//SIG(-1 S20948C15) C1{ BC2{ m} FC3{ m} FC2}



static void Test_S20948C15()
{
  extern Class_Descriptor cd_S20948C15;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S20948C15, buf);
    S20948C15 &lv = *(new (buf) S20948C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S20948C15)");
    check2(__alignof__(lv), 1, "__alignof__(S20948C15)");
    check_base_class_offset(lv, (S9624C39*), 0, "S20948C15");
    check_field_offset(lv, s20948c15f0, 0, "S20948C15.s20948c15f0");
    check_field_offset(lv, s20948c15f1, 1, "S20948C15.s20948c15f1");
    test_class_info(&lv, &cd_S20948C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C15(Test_S20948C15, "S20948C15", 2);

#else // __cplusplus

extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
static Base_Class bases_S20948C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C15[];
Class_Descriptor cd_S20948C15 = {  "S20948C15", // class name
  bases_S20948C15, 1,
  0, // no vftv
  0, //no vtt
  2, // object size
  NSPAIRA(_ZTI9S20948C15),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C14  : S9624C48 , S20948C15 , virtual S20948C5 , virtual S20948C9_nt {
  void *s20948c14f0;
  ~S20948C14(); // tgen
  S20948C14(); // tgen
};
//SIG(-1 S20948C14) C1{ BC2{ m} BC3{ BC4{ m} FC2 FC4} VBC5{ BC2 VBC6{ vd m FD} vd} VBC7{ v1} Fp}


S20948C14 ::~S20948C14(){ note_dtor("S20948C14", this);} // tgen
S20948C14 ::S20948C14(){ note_ctor("S20948C14", this);} // tgen

static void Test_S20948C14()
{
  extern Class_Descriptor cd_S20948C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(6,9)];
    init_test(&cd_S20948C14, buf);
    S20948C14 *dp, &lv = *(dp=new (buf) S20948C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,32), "sizeof(S20948C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C14)");
    /*is_ambiguous_... S20948C14::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*), ABISELECT(8,4), "S20948C14");
    check_base_class_offset(lv, (S9624C39*)(S20948C15*), ABISELECT(9,5), "S20948C14");
    check_base_class_offset(lv, (S20948C15*), ABISELECT(9,5), "S20948C14");
    check_base_class_offset(lv, (S9624C48*)(S20948C5*), 0, "S20948C14");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*), ABISELECT(32,12), "S20948C14");
    check_base_class_offset(lv, (S20948C5*), 0, "S20948C14");
    check_base_class_offset(lv, (S20948C9_nt*), ABISELECT(64,28), "S20948C14");
    check_field_offset(lv, s20948c14f0, ABISELECT(16,8), "S20948C14.s20948c14f0");
    test_class_info(&lv, &cd_S20948C14);
    dp->~S20948C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C14(Test_S20948C14, "S20948C14", ABISELECT(80,32));

#else // __cplusplus

extern void _ZN9S20948C14C1Ev();
extern void _ZN9S20948C14D1Ev();
Name_Map name_map_S20948C14[] = {
  NSPAIR(_ZN9S20948C14C1Ev),
  NSPAIR(_ZN9S20948C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
static Base_Class bases_S20948C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C48,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C39,    ABISELECT(9,5), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(9,5), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(32,12), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20948C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C9_nt,    ABISELECT(64,28), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C14[];
extern void _ZN9S20948C14D1Ev();
extern void _ZN9S20948C14D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev)();
extern void ABISELECT(_ZThn32_N9S20948C14D1Ev,_ZThn12_N9S20948C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev)();
extern void ABISELECT(_ZThn32_N9S20948C14D0Ev,_ZThn12_N9S20948C14D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY vtc_S20948C14[] = {
  ABISELECT(64,28),
  0,
  0,
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN9S20948C14D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C14D0Ev,
  ABISELECT(-32,-12),
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev),
  0,
  ABISELECT(-64,-28),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern VTBL_ENTRY _ZTV9S20948C14[];
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C14[] = {
  ABISELECT(32,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn32_N8S20948C5D1Ev,_ZThn12_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn32_N8S20948C5D0Ev,_ZThn12_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C5__9S20948C14[] = {
  ABISELECT(-32,-12),
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
static  VTT_ENTRY vtt_S20948C14[] = {
  {&(_ZTV9S20948C14[6]),  6,17},
  {&(_ZTV9S20948C14[6]),  6,17},
  {&(_ZTV9S20948C14[11]),  11,17},
  {&(_ZTV9S20948C14[16]),  16,17},
  {&(_tg__ZTV8S20948C5__9S20948C14[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C5__9S20948C14[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C5D0Ev,_ZThn12_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C5D1Ev,_ZThn12_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S20948C14D0Ev,_ZThn12_N9S20948C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S20948C14D1Ev,_ZThn12_N9S20948C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C14 = {  "S20948C14", // class name
  bases_S20948C14, 7,
  &(vtc_S20948C14[0]), // expected_vtbl_contents
  &(vtt_S20948C14[0]), // expected_vtt_contents
  ABISELECT(80,32), // object size
  NSPAIRA(_ZTI9S20948C14),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20948C14),17, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C14),6, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C17  : virtual S20948C9_nt {
  virtual  ~S20948C17(); // _ZN9S20948C17D2Ev
  S20948C17(); // tgen
};
//SIG(-1 S20948C17) C1{ VBC2{ v1} vd}


 S20948C17 ::~S20948C17(){ note_dtor("S20948C17", this);}
S20948C17 ::S20948C17(){ note_ctor("S20948C17", this);} // tgen

static void Test_S20948C17()
{
  extern Class_Descriptor cd_S20948C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S20948C17, buf);
    S20948C17 *dp, &lv = *(dp=new (buf) S20948C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S20948C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20948C17)");
    check_base_class_offset(lv, (S20948C9_nt*), 0, "S20948C17");
    test_class_info(&lv, &cd_S20948C17);
    dp->~S20948C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C17(Test_S20948C17, "S20948C17", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN9S20948C17C1Ev();
extern void _ZN9S20948C17D2Ev();
Name_Map name_map_S20948C17[] = {
  NSPAIR(_ZN9S20948C17C1Ev),
  NSPAIR(_ZN9S20948C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
static Base_Class bases_S20948C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20948C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C17[];
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY vtc_S20948C17[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern VTBL_ENTRY _ZTV9S20948C17[];
static  VTT_ENTRY vtt_S20948C17[] = {
  {&(_ZTV9S20948C17[4]),  4,7},
  {&(_ZTV9S20948C17[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
Class_Descriptor cd_S20948C17 = {  "S20948C17", // class name
  bases_S20948C17, 1,
  &(vtc_S20948C17[0]), // expected_vtbl_contents
  &(vtt_S20948C17[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI9S20948C17),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV9S20948C17),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C17),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C16  : S20948C17 , virtual S9624C48 {
  ::S20948C8 s20948c16f0;
  virtual  ~S20948C16(); // _ZN9S20948C16D2Ev
  S20948C16(); // tgen
};
//SIG(-1 S20948C16) C1{ BC2{ VBC3{ v1} vd} VBC4{ m} vd FC5{ m Fc[7]}}


 S20948C16 ::~S20948C16(){ note_dtor("S20948C16", this);}
S20948C16 ::S20948C16(){ note_ctor("S20948C16", this);} // tgen

static void Test_S20948C16()
{
  extern Class_Descriptor cd_S20948C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S20948C16, buf);
    S20948C16 *dp, &lv = *(dp=new (buf) S20948C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S20948C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20948C16)");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*), 0, "S20948C16");
    check_base_class_offset(lv, (S20948C17*), 0, "S20948C16");
    check_base_class_offset(lv, (S9624C48*), 0, "S20948C16");
    check_field_offset(lv, s20948c16f0, ABISELECT(8,4), "S20948C16.s20948c16f0");
    test_class_info(&lv, &cd_S20948C16);
    dp->~S20948C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C16(Test_S20948C16, "S20948C16", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN9S20948C16C1Ev();
extern void _ZN9S20948C16D2Ev();
Name_Map name_map_S20948C16[] = {
  NSPAIR(_ZN9S20948C16C1Ev),
  NSPAIR(_ZN9S20948C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
static Base_Class bases_S20948C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20948C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S20948C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C16[];
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY vtc_S20948C16[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern VTBL_ENTRY _ZTV9S20948C16[];
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C17__9S20948C16[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
static  VTT_ENTRY vtt_S20948C16[] = {
  {&(_ZTV9S20948C16[5]),  5,8},
  {&(_tg__ZTV9S20948C17__9S20948C16[4]),  4,7},
  {&(_tg__ZTV9S20948C17__9S20948C16[4]),  4,7},
  {&(_ZTV9S20948C16[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
Class_Descriptor cd_S20948C16 = {  "S20948C16", // class name
  bases_S20948C16, 3,
  &(vtc_S20948C16[0]), // expected_vtbl_contents
  &(vtt_S20948C16[0]), // expected_vtt_contents
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI9S20948C16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20948C16),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C16),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C13  : S20948C14 , S20948C15 , S20948C7_nt , S20948C16 {
  ~S20948C13(); // tgen
  S20948C13(); // tgen
};
//SIG(-1 S20948C13) C1{ BC2{ BC3{ m} BC4{ BC5{ m} FC3 FC5} VBC6{ BC3 VBC7{ vd m FD} vd} VBC8{ v1} Fp} BC4 BC7 BC9{ BC10{ VBC8 vd} VBC3 vd FC11{ m Fc[7]}}}


S20948C13 ::~S20948C13(){ note_dtor("S20948C13", this);} // tgen
S20948C13 ::S20948C13(){ note_ctor("S20948C13", this);} // tgen

static void Test_S20948C13()
{
  extern Class_Descriptor cd_S20948C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,17)];
    init_test(&cd_S20948C13, buf);
    S20948C13 *dp, &lv = *(dp=new (buf) S20948C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,64), "sizeof(S20948C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C13)");
    /*is_ambiguous_... S20948C14::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*), ABISELECT(8,4), "S20948C13");
    check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*), ABISELECT(9,5), "S20948C13");
    check_base_class_offset(lv, (S20948C15*)(S20948C14*), ABISELECT(9,5), "S20948C13");
    check_base_class_offset(lv, (S9624C48*)(S20948C5*), 0, "S20948C13");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*), ABISELECT(80,44), "S20948C13");
    check_base_class_offset(lv, (S20948C5*)(S20948C14*), 0, "S20948C13");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*), ABISELECT(64,32), "S20948C13");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*), ABISELECT(64,32), "S20948C13");
    check_base_class_offset(lv, (S20948C14*), 0, "S20948C13");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*), ABISELECT(24,12), "S20948C13");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S20948C15*), ABISELECT(24,12), "S20948C13");
    /*is_ambiguous_... S20948C13::S20948C7_nt */ AMB_check_base_class_offset(lv, (S20948C7_nt*), ABISELECT(32,16), "S20948C13");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*), ABISELECT(64,32), "S20948C13");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*), ABISELECT(112,60), "S20948C13");
    check_base_class_offset(lv, (S20948C16*), ABISELECT(64,32), "S20948C13");
    test_class_info(&lv, &cd_S20948C13);
    dp->~S20948C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C13(Test_S20948C13, "S20948C13", ABISELECT(128,64));

#else // __cplusplus

extern void _ZN9S20948C13C1Ev();
extern void _ZN9S20948C13D1Ev();
Name_Map name_map_S20948C13[] = {
  NSPAIR(_ZN9S20948C13C1Ev),
  NSPAIR(_ZN9S20948C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
static Base_Class bases_S20948C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C48,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(9,5), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(9,5), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(80,44), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20948C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20948C9_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20948C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C39,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C7_nt,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C17,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S20948C16,    ABISELECT(64,32), //bcp->offset
    13, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C13[];
extern void _ZN9S20948C13D1Ev();
extern void _ZN9S20948C13D0Ev();
extern void ABISELECT(_ZThn32_N9S20948C13D1Ev,_ZThn16_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn32_N9S20948C13D0Ev,_ZThn16_N9S20948C13D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn80_N9S20948C13D1Ev,_ZThn44_N9S20948C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev)();
extern void ABISELECT(_ZThn80_N9S20948C13D0Ev,_ZThn44_N9S20948C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20948C13[] = {
  ABISELECT(112,60),
  ABISELECT(64,32),
  0,
  0,
  ABISELECT(80,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN9S20948C13D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C13D0Ev,
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S20948C13D1Ev,_ZThn16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N9S20948C13D0Ev,_ZThn16_N9S20948C13D0Ev),
  ABISELECT(48,28),
  0,
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev),
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev),
};
extern VTBL_ENTRY _ZTV9S20948C13[];
extern void _ZN9S20948C14D1Ev();
extern void _ZN9S20948C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C14__9S20948C13[] = {
  ABISELECT(64,32),
  0,
  0,
  ABISELECT(80,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN9S20948C14D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C14D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev)();
extern void ABISELECT(_ZThn80_N9S20948C14D1Ev,_ZThn44_N9S20948C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev)();
extern void ABISELECT(_ZThn80_N9S20948C14D0Ev,_ZThn44_N9S20948C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C14__9S20948C13[] = {
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C14__9S20948C13[] = {
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C13[] = {
  ABISELECT(48,28),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C16__9S20948C13[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C13[] = {
  ABISELECT(80,44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn80_N8S20948C5D1Ev,_ZThn44_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn80_N8S20948C5D0Ev,_ZThn44_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C5__9S20948C13[] = {
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
static  VTT_ENTRY vtt_S20948C13[] = {
  {&(_ZTV9S20948C13[7]),  7,26},
  {&(_tg__ZTV9S20948C14__9S20948C13[6]),  6,8},
  {&(_tg__ZTV9S20948C14__9S20948C13[6]),  6,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C14__9S20948C13[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C14__9S20948C13[3]),  3,4},
  {&(_tg__ZTV9S20948C16__9S20948C13[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C16__9S20948C13[4]),  4,7},
  {&(_tg__ZTV9S20948C179S20948C16__9S20948C13[4]),  4,7},
  {&(_tg__ZTV9S20948C16__9S20948C13[5]),  5,8},
  {&(_ZTV9S20948C13[7]),  7,26},
  {&(_ZTV9S20948C13[24]),  24,26},
  {&(_ZTV9S20948C13[18]),  18,26},
  {&(_ZTV9S20948C13[18]),  18,26},
  {&(_tg__ZTV8S20948C5__9S20948C13[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C5__9S20948C13[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S20948C5D0Ev,_ZThn44_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S20948C5D1Ev,_ZThn44_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S20948C14D0Ev,_ZThn44_N9S20948C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S20948C14D1Ev,_ZThn44_N9S20948C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S20948C13D0Ev,_ZThn44_N9S20948C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S20948C13D1Ev,_ZThn44_N9S20948C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C13 = {  "S20948C13", // class name
  bases_S20948C13, 14,
  &(vtc_S20948C13[0]), // expected_vtbl_contents
  &(vtt_S20948C13[0]), // expected_vtt_contents
  ABISELECT(128,64), // object size
  NSPAIRA(_ZTI9S20948C13),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20948C13),26, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C13),15, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C3  : virtual S20948C4 , virtual S20948C10 , virtual S20948C9_nt , S20948C12 , S20948C13 {
  virtual  ~S20948C3(); // _ZN8S20948C3D2Ev
  S20948C3(); // tgen
};
//SIG(-1 S20948C3) C1{ VBC2{ BC3{ BC4{ m} VBC5{ vd m FD} vd} BC6{ m Fc[7]} BC7{ v1} VBC4} VBC8{ BC7 VBC9{ m} vd Fi:23} VBC7 BC10{ BC6 VBC3 VBC4 vd} BC11{ BC12{ BC4 BC13{ BC9 FC4 FC9} VBC3 VBC7 Fp} BC13 BC5 BC14{ BC15{ VBC7 vd} VBC4 vd FC6}} vd}


 S20948C3 ::~S20948C3(){ note_dtor("S20948C3", this);}
S20948C3 ::S20948C3(){ note_ctor("S20948C3", this);} // tgen

static void Test_S20948C3()
{
  extern Class_Descriptor cd_S20948C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(12,25)];
    init_test(&cd_S20948C3, buf);
    S20948C3 *dp, &lv = *(dp=new (buf) S20948C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,96), "sizeof(S20948C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C3)");
    check_base_class_offset(lv, (S9624C48*)(S20948C5*)(S20948C4*), ABISELECT(96,56), "S20948C3");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*)(S20948C4*), ABISELECT(128,72), "S20948C3");
    /*is_ambiguous_... S20948C3::S20948C5 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*), ABISELECT(128,72), "S20948C3");
    check_base_class_offset(lv, (S20948C5*)(S20948C4*), ABISELECT(96,56), "S20948C3");
    check_base_class_offset(lv, (S20948C8*)(S20948C4*), ABISELECT(104,60), "S20948C3");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C4*), ABISELECT(112,68), "S20948C3");
    /*is_ambiguous_... S20948C4::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C4*), ABISELECT(160,88), "S20948C3");
    /*is_ambiguous_... S20948C12::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C12*), ABISELECT(160,88), "S20948C3");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C13*), ABISELECT(160,88), "S20948C3");
    check_base_class_offset(lv, (S20948C4*), ABISELECT(96,56), "S20948C3");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C10*), ABISELECT(160,88), "S20948C3");
    check_base_class_offset(lv, (S9624C39*)(S20948C10*), 0, "S20948C3");
    check_base_class_offset(lv, (S20948C10*), ABISELECT(160,88), "S20948C3");
    /*is_ambiguous_... S20948C3::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*), ABISELECT(80,44), "S20948C3");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*)(S20948C13*), ABISELECT(80,44), "S20948C3");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C13*), ABISELECT(80,44), "S20948C3");
    check_base_class_offset(lv, (S20948C8*)(S20948C12*), ABISELECT(8,4), "S20948C3");
    /*is_ambiguous_... S20948C3::S20948C5 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C5*), 0, "S20948C3");
    check_base_class_offset(lv, (S20948C5*)(S20948C12*), 0, "S20948C3");
    check_base_class_offset(lv, (S20948C5*)(S20948C14*)(S20948C13*), 0, "S20948C3");
    check_base_class_offset(lv, (S20948C12*), 0, "S20948C3");
    /*is_ambiguous_... S20948C14::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*)(S20948C13*), ABISELECT(24,16), "S20948C3");
    check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*)(S20948C13*), ABISELECT(25,17), "S20948C3");
    check_base_class_offset(lv, (S20948C15*)(S20948C14*)(S20948C13*), ABISELECT(25,17), "S20948C3");
    check_base_class_offset(lv, (S20948C14*)(S20948C13*), ABISELECT(16,12), "S20948C3");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C13*), ABISELECT(40,24), "S20948C3");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C13*), ABISELECT(40,24), "S20948C3");
    /*is_ambiguous_... S20948C13::S20948C7_nt */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C13*), ABISELECT(48,28), "S20948C3");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C13*), ABISELECT(80,44), "S20948C3");
    check_base_class_offset(lv, (S20948C16*)(S20948C13*), ABISELECT(80,44), "S20948C3");
    check_base_class_offset(lv, (S20948C13*), ABISELECT(16,12), "S20948C3");
    test_class_info(&lv, &cd_S20948C3);
    dp->~S20948C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C3(Test_S20948C3, "S20948C3", ABISELECT(176,96));

#else // __cplusplus

extern void _ZN8S20948C3C1Ev();
extern void _ZN8S20948C3D2Ev();
Name_Map name_map_S20948C3[] = {
  NSPAIR(_ZN8S20948C3C1Ev),
  NSPAIR(_ZN8S20948C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C4;
extern VTBL_ENTRY _ZTI8S20948C4[];
extern  VTBL_ENTRY _ZTV8S20948C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C4[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C10;
extern VTBL_ENTRY _ZTI9S20948C10[];
extern  VTBL_ENTRY _ZTV9S20948C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C10[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C12;
extern VTBL_ENTRY _ZTI9S20948C12[];
extern  VTBL_ENTRY _ZTV9S20948C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C12[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C13;
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
static Base_Class bases_S20948C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C48,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(128,72), //bcp->offset
    44, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20948C5,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20948C8,    ABISELECT(104,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(112,68), //bcp->offset
    41, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(160,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20948C4,    ABISELECT(96,56), //bcp->offset
    33, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C9_nt,    ABISELECT(160,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S9624C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20948C10,    ABISELECT(160,88), //bcp->offset
    49, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C9_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C8,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20948C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S20948C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C48,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(25,17), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(25,17), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20948C14,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(48,28), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(80,44), //bcp->offset
    25, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20948C13,    ABISELECT(16,12), //bcp->offset
    12, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20948C3[];
extern void ABISELECT(_ZTv0_n32_N8S20948C3D1Ev,_ZTv0_n16_N8S20948C3D1Ev)();
extern void _ZN8S20948C3D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C3D0Ev,_ZTv0_n16_N8S20948C3D0Ev)();
extern void _ZN8S20948C3D0Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C3D1Ev,_ZTv0_n16_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn16_N8S20948C3D1Ev,_ZThn12_N8S20948C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C3D0Ev,_ZTv0_n16_N8S20948C3D0Ev)();
extern void ABISELECT(_ZThn16_N8S20948C3D0Ev,_ZThn12_N8S20948C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZThn48_N8S20948C3D1Ev,_ZThn28_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn48_N8S20948C3D0Ev,_ZThn28_N8S20948C3D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn80_N8S20948C3D1Ev,_ZThn44_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn80_N8S20948C3D0Ev,_ZThn44_N8S20948C3D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S20948C3D1Ev,_ZTv0_n20_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn96_N8S20948C3D1Ev,_ZThn56_N8S20948C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20948C3D0Ev,_ZTv0_n20_N8S20948C3D0Ev)();
extern void ABISELECT(_ZThn96_N8S20948C3D0Ev,_ZThn56_N8S20948C3D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n24_N8S20948C3D1Ev,_ZTv0_n12_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn128_N8S20948C3D1Ev,_ZThn72_N8S20948C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C3D0Ev,_ZTv0_n12_N8S20948C3D0Ev)();
extern void ABISELECT(_ZThn128_N8S20948C3D0Ev,_ZThn72_N8S20948C3D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N8S20948C3D1Ev,_ZTv0_n20_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn160_N8S20948C3D1Ev,_ZThn88_N8S20948C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20948C3D0Ev,_ZTv0_n20_N8S20948C3D0Ev)();
extern void ABISELECT(_ZThn160_N8S20948C3D0Ev,_ZThn88_N8S20948C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20948C3[] = {
  ABISELECT(80,44),
  0,
  ABISELECT(160,88),
  ABISELECT(96,56),
  ABISELECT(160,88),
  0,
  0,
  ABISELECT(128,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C3D1Ev,_ZTv0_n16_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C3D0Ev,_ZTv0_n16_N8S20948C3D0Ev),
  ABISELECT(144,76),
  ABISELECT(64,32),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(112,60),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C3D1Ev,_ZTv0_n16_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C3D0Ev,_ZTv0_n16_N8S20948C3D0Ev),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S20948C3D1Ev,_ZThn28_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N8S20948C3D0Ev,_ZThn28_N8S20948C3D0Ev),
  ABISELECT(80,44),
  0,
  0,
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N8S20948C3D1Ev,_ZThn44_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N8S20948C3D0Ev,_ZThn44_N8S20948C3D0Ev),
  ABISELECT(16,12),
  ABISELECT(-96,-56),
  ABISELECT(64,32),
  ABISELECT(32,16),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C3D1Ev,_ZTv0_n20_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C3D0Ev,_ZTv0_n20_N8S20948C3D0Ev),
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  ABISELECT(-128,-72),
  ABISELECT(-128,-72),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C3D1Ev,_ZTv0_n12_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C3D0Ev,_ZTv0_n12_N8S20948C3D0Ev),
  ABISELECT(-160,-88),
  0,
  ABISELECT(-160,-88),
  ABISELECT(-160,-88),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C3D1Ev,_ZTv0_n20_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C3D0Ev,_ZTv0_n20_N8S20948C3D0Ev),
};
extern VTBL_ENTRY _ZTV8S20948C3[];
extern void ABISELECT(_ZTv0_n32_N9S20948C12D1Ev,_ZTv0_n16_N9S20948C12D1Ev)();
extern void _ZN9S20948C12D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C12D0Ev,_ZTv0_n16_N9S20948C12D0Ev)();
extern void _ZN9S20948C12D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C12__8S20948C3[] = {
  ABISELECT(160,88),
  0,
  0,
  ABISELECT(128,72),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C12D1Ev,_ZTv0_n16_N9S20948C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C12D0Ev,_ZTv0_n16_N9S20948C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C12D1Ev,_ZTv0_n12_N9S20948C12D1Ev)();
extern void ABISELECT(_ZThn128_N9S20948C12D1Ev,_ZThn72_N9S20948C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C12D0Ev,_ZTv0_n12_N9S20948C12D0Ev)();
extern void ABISELECT(_ZThn128_N9S20948C12D0Ev,_ZThn72_N9S20948C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C12__8S20948C3[] = {
  ABISELECT(-128,-72),
  ABISELECT(-128,-72),
  (VTBL_ENTRY)&(_ZTI9S20948C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C12D1Ev,_ZTv0_n12_N9S20948C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C12D0Ev,_ZTv0_n12_N9S20948C12D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void _ZN9S20948C13D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
extern void _ZN9S20948C13D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C13__8S20948C3[] = {
  ABISELECT(144,76),
  ABISELECT(64,32),
  ABISELECT(-16,-12),
  0,
  ABISELECT(112,60),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void _ZN9S20948C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
extern void _ZN9S20948C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C149S20948C13__8S20948C3[] = {
  ABISELECT(64,32),
  ABISELECT(-16,-12),
  0,
  ABISELECT(112,60),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C149S20948C13__8S20948C3[] = {
  ABISELECT(16,12),
  ABISELECT(128,72),
  ABISELECT(16,12),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C14D1Ev,_ZThn60_N9S20948C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C14D0Ev,_ZThn60_N9S20948C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C149S20948C13__8S20948C3[] = {
  ABISELECT(-112,-60),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C149S20948C13__8S20948C3[] = {
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C13__8S20948C3[] = {
  ABISELECT(80,44),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C13__8S20948C3[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C13__8S20948C3[] = {
  ABISELECT(16,12),
  ABISELECT(128,72),
  ABISELECT(16,12),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C13D1Ev,_ZThn60_N9S20948C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C13D0Ev,_ZThn60_N9S20948C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C13__8S20948C3[] = {
  ABISELECT(-112,-60),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C13__8S20948C3[] = {
  ABISELECT(80,44),
  0,
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev),
};
extern void _ZN8S20948C4D1Ev();
extern void _ZN8S20948C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C4__8S20948C3[] = {
  ABISELECT(64,32),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&_ZN8S20948C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C4D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C58S20948C4__8S20948C3[] = {
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn32_N8S20948C5D1Ev,_ZThn16_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn32_N8S20948C5D0Ev,_ZThn16_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C58S20948C4__8S20948C3[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev)();
extern void ABISELECT(_ZThn32_N8S20948C4D1Ev,_ZThn16_N8S20948C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev)();
extern void ABISELECT(_ZThn32_N8S20948C4D0Ev,_ZThn16_N8S20948C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C4__8S20948C3[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C10D1Ev();
extern void _ZN9S20948C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C10__8S20948C3[] = {
  ABISELECT(-160,-88),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C10[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C5__A1__8S20948C3[] = {
  ABISELECT(128,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn128_N8S20948C5D1Ev,_ZThn72_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn128_N8S20948C5D0Ev,_ZThn72_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C5__A1__8S20948C3[] = {
  ABISELECT(-128,-72),
  ABISELECT(-128,-72),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
static  VTT_ENTRY vtt_S20948C3[] = {
  {&(_ZTV8S20948C3[10]),  10,57},
  {&(_tg__ZTV9S20948C12__8S20948C3[6]),  6,8},
  {&(_tg__ZTV9S20948C12__8S20948C3[6]),  6,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C12__8S20948C3[3]),  3,5},
  {&(_tg__ZTV9S20948C13__8S20948C3[7]),  7,9},
  {&(_tg__ZTV9S20948C149S20948C13__8S20948C3[6]),  6,8},
  {&(_tg__ZTV8S20948C5__9S20948C149S20948C13__8S20948C3[4]),  4,6},
  {&(_tg__ZTV11S20948C7_nt__9S20948C149S20948C13__8S20948C3[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C149S20948C13__8S20948C3[3]),  3,4},
  {&(_tg__ZTV9S20948C169S20948C13__8S20948C3[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C13__8S20948C3[4]),  4,7},
  {&(_tg__ZTV9S20948C179S20948C169S20948C13__8S20948C3[4]),  4,7},
  {&(_tg__ZTV9S20948C169S20948C13__8S20948C3[5]),  5,8},
  {&(_tg__ZTV8S20948C5__9S20948C13__8S20948C3[4]),  4,6},
  {&(_tg__ZTV11S20948C7_nt__9S20948C13__8S20948C3[3]),  3,5},
  {&(_tg__ZTV9S20948C16__9S20948C13__8S20948C3[5]),  5,8},
  {&(_tg__ZTV9S20948C16__9S20948C13__8S20948C3[5]),  5,8},
  {&(_ZTV8S20948C3[39]),  39,57},
  {&(_ZTV8S20948C3[47]),  47,57},
  {&(_ZTV8S20948C3[43]),  43,57},
  {&(_ZTV8S20948C3[54]),  54,57},
  {&(_ZTV8S20948C3[30]),  30,57},
  {&(_ZTV8S20948C3[10]),  10,57},
  {&(_ZTV8S20948C3[19]),  19,57},
  {&(_ZTV8S20948C3[30]),  30,57},
  {&(_tg__ZTV8S20948C4__8S20948C3[4]),  4,6},
  {&(_tg__ZTV8S20948C58S20948C4__8S20948C3[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C58S20948C4__8S20948C3[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C4__8S20948C3[3]),  3,5},
  {&(_tg__ZTV9S20948C10__8S20948C3[3]),  3,6},
  {&(_tg__ZTV8S20948C5__A1__8S20948C3[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C5__A1__8S20948C3[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S20948C3[];
extern  VTBL_ENTRY _ZTV8S20948C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C3[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C4D0Ev,_ZThn16_N8S20948C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C4D1Ev,_ZThn16_N8S20948C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S20948C5D0Ev,_ZThn72_N8S20948C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C5D0Ev,_ZThn16_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S20948C5D1Ev,_ZThn72_N8S20948C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C5D1Ev,_ZThn16_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C13D0Ev,_ZThn60_N9S20948C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C13D1Ev,_ZThn60_N9S20948C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C14D0Ev,_ZThn60_N9S20948C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C14D1Ev,_ZThn60_N9S20948C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev), // 
  (VTBL_ENTRY)_ZN9S20948C14D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev), // 
  (VTBL_ENTRY)_ZN9S20948C14D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev), // 
  (VTBL_ENTRY)_ZN9S20948C13D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev), // 
  (VTBL_ENTRY)_ZN9S20948C13D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C12D0Ev,_ZTv0_n12_N9S20948C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N9S20948C12D0Ev,_ZThn72_N9S20948C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C12D1Ev,_ZTv0_n12_N9S20948C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N9S20948C12D1Ev,_ZThn72_N9S20948C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C12D0Ev,_ZTv0_n16_N9S20948C12D0Ev), // 
  (VTBL_ENTRY)_ZN9S20948C12D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C12D1Ev,_ZTv0_n16_N9S20948C12D1Ev), // 
  (VTBL_ENTRY)_ZN9S20948C12D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C3D0Ev,_ZTv0_n12_N8S20948C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S20948C3D0Ev,_ZThn72_N8S20948C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C3D1Ev,_ZTv0_n12_N8S20948C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N8S20948C3D1Ev,_ZThn72_N8S20948C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20948C3D0Ev,_ZTv0_n20_N8S20948C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn160_N8S20948C3D0Ev,_ZThn88_N8S20948C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S20948C3D0Ev,_ZThn56_N8S20948C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S20948C3D1Ev,_ZTv0_n20_N8S20948C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn160_N8S20948C3D1Ev,_ZThn88_N8S20948C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S20948C3D1Ev,_ZThn56_N8S20948C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20948C3D0Ev,_ZTv0_n16_N8S20948C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S20948C3D0Ev,_ZThn12_N8S20948C3D0Ev),
  (VTBL_ENTRY)_ZN8S20948C3D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20948C3D1Ev,_ZTv0_n16_N8S20948C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S20948C3D1Ev,_ZThn12_N8S20948C3D1Ev),
  (VTBL_ENTRY)_ZN8S20948C3D1Ev,
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C3 = {  "S20948C3", // class name
  bases_S20948C3, 25,
  &(vtc_S20948C3[0]), // expected_vtbl_contents
  &(vtt_S20948C3[0]), // expected_vtt_contents
  ABISELECT(176,96), // object size
  NSPAIRA(_ZTI8S20948C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S20948C3),57, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20948C3),32, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C20  : S9624C48 , virtual S20948C7_nt , S20948C9_nt , S20948C16 {
  int s20948c20f0;
  virtual  ~S20948C20(); // _ZN9S20948C20D2Ev
  S20948C20(); // tgen
};
//SIG(-1 S20948C20) C1{ BC2{ m} VBC3{ vd m FD} BC4{ v1} BC5{ BC6{ VBC4 vd} VBC2 vd FC7{ m Fc[7]}} vd Fi}


 S20948C20 ::~S20948C20(){ note_dtor("S20948C20", this);}
S20948C20 ::S20948C20(){ note_ctor("S20948C20", this);} // tgen

static void Test_S20948C20()
{
  extern Class_Descriptor cd_S20948C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(6,11)];
    init_test(&cd_S20948C20, buf);
    S20948C20 *dp, &lv = *(dp=new (buf) S20948C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(S20948C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C20)");
    /*is_ambiguous_... S20948C20::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*), 0, "S20948C20");
    check_base_class_offset(lv, (S20948C7_nt*), ABISELECT(32,20), "S20948C20");
    /*is_ambiguous_... S20948C20::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*), 0, "S20948C20");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*), ABISELECT(8,4), "S20948C20");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*), ABISELECT(8,4), "S20948C20");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*), ABISELECT(64,36), "S20948C20");
    check_base_class_offset(lv, (S20948C16*), ABISELECT(8,4), "S20948C20");
    check_field_offset(lv, s20948c20f0, ABISELECT(24,16), "S20948C20.s20948c20f0");
    test_class_info(&lv, &cd_S20948C20);
    dp->~S20948C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C20(Test_S20948C20, "S20948C20", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN9S20948C20C1Ev();
extern void _ZN9S20948C20D2Ev();
Name_Map name_map_S20948C20[] = {
  NSPAIR(_ZN9S20948C20C1Ev),
  NSPAIR(_ZN9S20948C20D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
static Base_Class bases_S20948C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C7_nt,    ABISELECT(32,20), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C9_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20948C17,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20948C16,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C20[];
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C20D1Ev();
extern void _ZN9S20948C20D0Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn8_N9S20948C20D1Ev,_ZThn4_N9S20948C20D1Ev)();
extern void ABISELECT(_ZThn8_N9S20948C20D0Ev,_ZThn4_N9S20948C20D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C20D1Ev,_ZTv0_n12_N9S20948C20D1Ev)();
extern void ABISELECT(_ZThn32_N9S20948C20D1Ev,_ZThn20_N9S20948C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C20D0Ev,_ZTv0_n12_N9S20948C20D0Ev)();
extern void ABISELECT(_ZThn32_N9S20948C20D0Ev,_ZThn20_N9S20948C20D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20948C20[] = {
  ABISELECT(64,36),
  ABISELECT(8,4),
  ABISELECT(32,20),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C20D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C20D0Ev,
  ABISELECT(56,32),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S20948C20D1Ev,_ZThn4_N9S20948C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S20948C20D0Ev,_ZThn4_N9S20948C20D0Ev),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C20D1Ev,_ZTv0_n12_N9S20948C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C20D0Ev,_ZTv0_n12_N9S20948C20D0Ev),
};
extern VTBL_ENTRY _ZTV9S20948C20[];
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C20[] = {
  ABISELECT(56,32),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C16__9S20948C20[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
static  VTT_ENTRY vtt_S20948C20[] = {
  {&(_ZTV9S20948C20[5]),  5,21},
  {&(_tg__ZTV9S20948C16__9S20948C20[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C16__9S20948C20[4]),  4,7},
  {&(_tg__ZTV9S20948C179S20948C16__9S20948C20[4]),  4,7},
  {&(_tg__ZTV9S20948C16__9S20948C20[5]),  5,8},
  {&(_ZTV9S20948C20[19]),  19,21},
  {&(_ZTV9S20948C20[13]),  13,21},
  {&(_ZTV9S20948C20[13]),  13,21},
};
extern VTBL_ENTRY _ZTI9S20948C20[];
extern  VTBL_ENTRY _ZTV9S20948C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C20[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C20D0Ev,_ZTv0_n12_N9S20948C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S20948C20D0Ev,_ZThn20_N9S20948C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C20D1Ev,_ZTv0_n12_N9S20948C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S20948C20D1Ev,_ZThn20_N9S20948C20D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C20 = {  "S20948C20", // class name
  bases_S20948C20, 7,
  &(vtc_S20948C20[0]), // expected_vtbl_contents
  &(vtt_S20948C20[0]), // expected_vtt_contents
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI9S20948C20),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20948C20),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C20),8, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C19  : virtual S20948C9_nt , S20948C4 , virtual S20948C20 , S20948C8 {
  int s20948c19f0;
  virtual  ~S20948C19(); // _ZN9S20948C19D2Ev
  S20948C19(); // tgen
};
//SIG(-1 S20948C19) C1{ VBC2{ v1} BC3{ BC4{ BC5{ m} VBC6{ vd m FD} vd} BC7{ m Fc[7]} BC2 VBC5} VBC8{ BC5 VBC6 BC2 BC9{ BC10{ VBC2 vd} VBC5 vd FC7} vd Fi} BC7 vd Fi}


 S20948C19 ::~S20948C19(){ note_dtor("S20948C19", this);}
S20948C19 ::S20948C19(){ note_ctor("S20948C19", this);} // tgen

static void Test_S20948C19()
{
  extern Class_Descriptor cd_S20948C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9,18)];
    init_test(&cd_S20948C19, buf);
    S20948C19 *dp, &lv = *(dp=new (buf) S20948C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,68), "sizeof(S20948C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C19)");
    /*is_ambiguous_... S20948C19::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*), ABISELECT(96,52), "S20948C19");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C20*), ABISELECT(96,52), "S20948C19");
    check_base_class_offset(lv, (S9624C48*)(S20948C5*)(S20948C4*), 0, "S20948C19");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*)(S20948C4*), ABISELECT(48,28), "S20948C19");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C20*), ABISELECT(48,28), "S20948C19");
    check_base_class_offset(lv, (S20948C5*)(S20948C4*), 0, "S20948C19");
    check_base_class_offset(lv, (S20948C8*)(S20948C4*), ABISELECT(8,4), "S20948C19");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C4*), ABISELECT(16,12), "S20948C19");
    /*is_ambiguous_... S20948C4::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C4*), ABISELECT(80,44), "S20948C19");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C20*), ABISELECT(80,44), "S20948C19");
    check_base_class_offset(lv, (S20948C4*), 0, "S20948C19");
    /*is_ambiguous_... S20948C20::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C20*), ABISELECT(88,48), "S20948C19");
    /*is_ambiguous_... S20948C20::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C20*), ABISELECT(88,48), "S20948C19");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C20*), ABISELECT(96,52), "S20948C19");
    check_base_class_offset(lv, (S20948C16*)(S20948C20*), ABISELECT(96,52), "S20948C19");
    check_base_class_offset(lv, (S20948C20*), ABISELECT(88,48), "S20948C19");
    /*is_ambiguous_... S20948C19::S20948C8 */ AMB_check_base_class_offset(lv, (S20948C8*), ABISELECT(24,16), "S20948C19");
    check_field_offset(lv, s20948c19f0, ABISELECT(32,24), "S20948C19.s20948c19f0");
    test_class_info(&lv, &cd_S20948C19);
    dp->~S20948C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C19(Test_S20948C19, "S20948C19", ABISELECT(128,68));

#else // __cplusplus

extern void _ZN9S20948C19C1Ev();
extern void _ZN9S20948C19D2Ev();
Name_Map name_map_S20948C19[] = {
  NSPAIR(_ZN9S20948C19C1Ev),
  NSPAIR(_ZN9S20948C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C4;
extern VTBL_ENTRY _ZTI8S20948C4[];
extern  VTBL_ENTRY _ZTV8S20948C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C4[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C20;
extern VTBL_ENTRY _ZTI9S20948C20[];
extern  VTBL_ENTRY _ZTV9S20948C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C20[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
static Base_Class bases_S20948C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20948C9_nt,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20948C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20948C8,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(16,12), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20948C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C48,    ABISELECT(88,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(88,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(96,52), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20948C20,    ABISELECT(88,48), //bcp->offset
    16, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C8,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C19[];
extern void _ZN9S20948C19D1Ev();
extern void _ZN9S20948C19D0Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev)();
extern void ABISELECT(_ZThn48_N9S20948C19D1Ev,_ZThn28_N9S20948C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev)();
extern void ABISELECT(_ZThn48_N9S20948C19D0Ev,_ZThn28_N9S20948C19D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev)();
extern void ABISELECT(_ZThn88_N9S20948C19D1Ev,_ZThn48_N9S20948C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev)();
extern void ABISELECT(_ZThn88_N9S20948C19D0Ev,_ZThn48_N9S20948C19D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn8_n56_N9S20948C19D1Ev,_ZTvn4_n28_N9S20948C19D1Ev)();
extern void ABISELECT(_ZTvn8_n56_N9S20948C19D0Ev,_ZTvn4_n28_N9S20948C19D0Ev)();
static  VTBL_ENTRY vtc_S20948C19[] = {
  ABISELECT(88,48),
  ABISELECT(96,52),
  ABISELECT(80,44),
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN9S20948C19D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C19D0Ev,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev),
  ABISELECT(-88,-48),
  0,
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  ABISELECT(-40,-20),
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev),
  ABISELECT(-16,-8),
  0,
  0,
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C19D1Ev,_ZTvn4_n28_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C19D0Ev,_ZTvn4_n28_N9S20948C19D0Ev),
};
extern VTBL_ENTRY _ZTV9S20948C19[];
extern void _ZN8S20948C4D1Ev();
extern void _ZN8S20948C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C4__9S20948C19[] = {
  ABISELECT(80,44),
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&_ZN8S20948C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C4D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C58S20948C4__9S20948C19[] = {
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn48_N8S20948C5D1Ev,_ZThn28_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn48_N8S20948C5D0Ev,_ZThn28_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C58S20948C4__9S20948C19[] = {
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev)();
extern void ABISELECT(_ZThn48_N8S20948C4D1Ev,_ZThn28_N8S20948C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev)();
extern void ABISELECT(_ZThn48_N8S20948C4D0Ev,_ZThn28_N8S20948C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C4__9S20948C19[] = {
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C20D1Ev();
extern void _ZN9S20948C20D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C20__9S20948C19[] = {
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  ABISELECT(-40,-20),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C20D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C20D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C20__9S20948C19[] = {
  ABISELECT(-16,-8),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C20__9S20948C19[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20948C20D1Ev,_ZTv0_n12_N9S20948C20D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C20D0Ev,_ZTv0_n12_N9S20948C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C20__9S20948C19[] = {
  ABISELECT(40,20),
  ABISELECT(40,20),
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C20D1Ev,_ZTv0_n12_N9S20948C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C20D0Ev,_ZTv0_n12_N9S20948C20D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn8_N9S20948C20D1Ev,_ZThn4_N9S20948C20D1Ev)();
extern void ABISELECT(_ZThn8_N9S20948C20D0Ev,_ZThn4_N9S20948C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C20__9S20948C19[] = {
  ABISELECT(-16,-8),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S20948C20D1Ev,_ZThn4_N9S20948C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S20948C20D0Ev,_ZThn4_N9S20948C20D0Ev),
};
static  VTT_ENTRY vtt_S20948C19[] = {
  {&(_ZTV9S20948C19[6]),  6,34},
  {&(_tg__ZTV8S20948C4__9S20948C19[4]),  4,6},
  {&(_tg__ZTV8S20948C58S20948C4__9S20948C19[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C58S20948C4__9S20948C19[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C4__9S20948C19[3]),  3,5},
  {&(_ZTV9S20948C19[31]),  31,34},
  {&(_ZTV9S20948C19[14]),  14,34},
  {&(_ZTV9S20948C19[23]),  23,34},
  {&(_ZTV9S20948C19[31]),  31,34},
  {&(_tg__ZTV9S20948C20__9S20948C19[5]),  5,8},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C19[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C20__9S20948C19[4]),  4,7},
  {&(_tg__ZTV9S20948C179S20948C169S20948C20__9S20948C19[4]),  4,7},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C19[5]),  5,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C20__9S20948C19[3]),  3,5},
  {&(_tg__ZTV9S20948C16__9S20948C20__9S20948C19[5]),  5,8},
  {&(_tg__ZTV9S20948C16__9S20948C20__9S20948C19[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S20948C19[];
extern  VTBL_ENTRY _ZTV9S20948C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C19[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S20948C4D0Ev,_ZThn28_N8S20948C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S20948C4D1Ev,_ZThn28_N8S20948C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S20948C5D0Ev,_ZThn28_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S20948C5D1Ev,_ZThn28_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N9S20948C19D0Ev,_ZThn48_N9S20948C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N9S20948C19D1Ev,_ZThn48_N9S20948C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S20948C19D0Ev,_ZThn28_N9S20948C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N9S20948C19D1Ev,_ZThn28_N9S20948C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C19 = {  "S20948C19", // class name
  bases_S20948C19, 14,
  &(vtc_S20948C19[0]), // expected_vtbl_contents
  &(vtt_S20948C19[0]), // expected_vtt_contents
  ABISELECT(128,68), // object size
  NSPAIRA(_ZTI9S20948C19),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20948C19),34, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C19),17, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C21  : virtual S20948C10 , S20948C16 , S20948C13 , S20948C17 {
  virtual  ~S20948C21(); // _ZN9S20948C21D2Ev
  virtual void  v2(); // _ZN9S20948C212v2Ev
  S20948C21(); // tgen
};
//SIG(-1 S20948C21) C1{ VBC2{ BC3{ v2} VBC4{ m} vd Fi:23} BC5{ BC6{ VBC3 vd} VBC7{ m} vd FC8{ m Fc[7]}} BC9{ BC10{ BC7 BC11{ BC4 FC7 FC4} VBC12{ BC7 VBC13{ vd m FD} vd} VBC3 Fp} BC11 BC13 BC5} BC6 vd v1}


 S20948C21 ::~S20948C21(){ note_dtor("S20948C21", this);}
void  S20948C21 ::v2(){vfunc_called(this, "_ZN9S20948C212v2Ev");}
S20948C21 ::S20948C21(){ note_ctor("S20948C21", this);} // tgen

static void Test_S20948C21()
{
  extern Class_Descriptor cd_S20948C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(11,22)];
    init_test(&cd_S20948C21, buf);
    S20948C21 *dp, &lv = *(dp=new (buf) S20948C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(160,84), "sizeof(S20948C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C21)");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C10*), ABISELECT(104,60), "S20948C21");
    check_base_class_offset(lv, (S9624C39*)(S20948C10*), 0, "S20948C21");
    check_base_class_offset(lv, (S20948C10*), ABISELECT(104,60), "S20948C21");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*), 0, "S20948C21");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*)(S20948C13*), 0, "S20948C21");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C13*), 0, "S20948C21");
    /*is_ambiguous_... S20948C21::S20948C17 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*), 0, "S20948C21");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*), 0, "S20948C21");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*), 0, "S20948C21");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C13*), 0, "S20948C21");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C16*), 0, "S20948C21");
    /*is_ambiguous_... S20948C14::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*)(S20948C13*), ABISELECT(24,16), "S20948C21");
    check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*)(S20948C13*), ABISELECT(25,17), "S20948C21");
    check_base_class_offset(lv, (S20948C15*)(S20948C14*)(S20948C13*), ABISELECT(25,17), "S20948C21");
    check_base_class_offset(lv, (S9624C48*)(S20948C5*), ABISELECT(16,12), "S20948C21");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*), ABISELECT(128,68), "S20948C21");
    check_base_class_offset(lv, (S20948C5*)(S20948C14*)(S20948C13*), ABISELECT(16,12), "S20948C21");
    check_base_class_offset(lv, (S20948C14*)(S20948C13*), ABISELECT(16,12), "S20948C21");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C13*), ABISELECT(40,24), "S20948C21");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C13*), ABISELECT(40,24), "S20948C21");
    /*is_ambiguous_... S20948C13::S20948C7_nt */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C13*), ABISELECT(48,28), "S20948C21");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C13*), ABISELECT(80,44), "S20948C21");
    check_base_class_offset(lv, (S20948C16*)(S20948C13*), ABISELECT(80,44), "S20948C21");
    check_base_class_offset(lv, (S20948C13*), ABISELECT(16,12), "S20948C21");
    /*is_ambiguous_... S20948C21::S20948C17 */ AMB_check_base_class_offset(lv, (S20948C17*), ABISELECT(96,56), "S20948C21");
    test_class_info(&lv, &cd_S20948C21);
    dp->~S20948C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C21(Test_S20948C21, "S20948C21", ABISELECT(160,84));

#else // __cplusplus

extern void _ZN9S20948C21C1Ev();
extern void _ZN9S20948C21D2Ev();
Name_Map name_map_S20948C21[] = {
  NSPAIR(_ZN9S20948C21C1Ev),
  NSPAIR(_ZN9S20948C21D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C10;
extern VTBL_ENTRY _ZTI9S20948C10[];
extern  VTBL_ENTRY _ZTV9S20948C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C10[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C13;
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
static Base_Class bases_S20948C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20948C9_nt,    ABISELECT(104,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S9624C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20948C10,    ABISELECT(104,60), //bcp->offset
    41, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20948C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20948C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C48,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(25,17), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(25,17), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(128,68), //bcp->offset
    49, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20948C5,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S20948C14,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(48,28), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(80,44), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20948C13,    ABISELECT(16,12), //bcp->offset
    13, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C17,    ABISELECT(96,56), //bcp->offset
    34, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C21[];
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C21D1Ev();
extern void _ZN9S20948C21D0Ev();
extern void _ZN9S20948C212v2Ev();
extern void ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn16_N9S20948C21D1Ev,_ZThn12_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn16_N9S20948C21D0Ev,_ZThn12_N9S20948C21D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZThn48_N9S20948C21D1Ev,_ZThn28_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn48_N9S20948C21D0Ev,_ZThn28_N9S20948C21D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn80_N9S20948C21D1Ev,_ZThn44_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn80_N9S20948C21D0Ev,_ZThn44_N9S20948C21D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn96_N9S20948C21D1Ev,_ZThn56_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn96_N9S20948C21D0Ev,_ZThn56_N9S20948C21D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn104_N9S20948C21D1Ev,_ZThn60_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn104_N9S20948C21D0Ev,_ZThn60_N9S20948C21D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn128_N9S20948C21D1Ev,_ZThn68_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn128_N9S20948C21D0Ev,_ZThn68_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20948C21[] = {
  ABISELECT(128,68),
  ABISELECT(16,12),
  0,
  ABISELECT(104,60),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C21D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C21D0Ev,
  (VTBL_ENTRY)&_ZN9S20948C212v2Ev,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  0,
  ABISELECT(-16,-12),
  ABISELECT(112,56),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S20948C21D1Ev,_ZThn28_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N9S20948C21D0Ev,_ZThn28_N9S20948C21D0Ev),
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N9S20948C21D1Ev,_ZThn44_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N9S20948C21D0Ev,_ZThn44_N9S20948C21D0Ev),
  ABISELECT(-96,-56),
  ABISELECT(-96,-56),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N9S20948C21D1Ev,_ZThn56_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N9S20948C21D0Ev,_ZThn56_N9S20948C21D0Ev),
  ABISELECT(-104,-60),
  0,
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev),
  ABISELECT(-128,-68),
  ABISELECT(-128,-68),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev),
};
extern VTBL_ENTRY _ZTV9S20948C21[];
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C21[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C16__9S20948C21[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void _ZN9S20948C13D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
extern void _ZN9S20948C13D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C13__9S20948C21[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  0,
  0,
  ABISELECT(112,56),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void _ZN9S20948C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
extern void _ZN9S20948C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C149S20948C13__9S20948C21[] = {
  ABISELECT(-16,-12),
  0,
  0,
  ABISELECT(112,56),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C14D1Ev,_ZThn56_N9S20948C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C14D0Ev,_ZThn56_N9S20948C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C149S20948C13__9S20948C21[] = {
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C149S20948C13__9S20948C21[] = {
  0,
  ABISELECT(16,12),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C13__A1__9S20948C21[] = {
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C13__A1__9S20948C21[] = {
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C13__A1__9S20948C21[] = {
  0,
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C13__A1__9S20948C21[] = {
  0,
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C13D1Ev,_ZThn56_N9S20948C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C13D0Ev,_ZThn56_N9S20948C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C13__9S20948C21[] = {
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C13__9S20948C21[] = {
  0,
  ABISELECT(16,12),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C13__9S20948C21[] = {
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C17__A2__9S20948C21[] = {
  ABISELECT(-96,-56),
  ABISELECT(-96,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C17__A2__9S20948C21[] = {
  0,
  ABISELECT(96,56),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C10D1Ev();
extern void _ZN9S20948C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C10__9S20948C21[] = {
  ABISELECT(-104,-60),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C10[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C21[] = {
  ABISELECT(112,56),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn112_N8S20948C5D1Ev,_ZThn56_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn112_N8S20948C5D0Ev,_ZThn56_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C5__9S20948C21[] = {
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
static  VTT_ENTRY vtt_S20948C21[] = {
  {&(_ZTV9S20948C21[9]),  9,54},
  {&(_tg__ZTV9S20948C16__9S20948C21[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C16__9S20948C21[4]),  4,7},
  {&(_tg__ZTV9S20948C179S20948C16__9S20948C21[4]),  4,7},
  {&(_tg__ZTV9S20948C16__9S20948C21[5]),  5,8},
  {&(_tg__ZTV9S20948C13__9S20948C21[7]),  7,9},
  {&(_tg__ZTV9S20948C149S20948C13__9S20948C21[6]),  6,8},
  {&(_tg__ZTV9S20948C149S20948C13__9S20948C21[6]),  6,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C149S20948C13__9S20948C21[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C149S20948C13__9S20948C21[3]),  3,4},
  {&(_tg__ZTV9S20948C169S20948C13__A1__9S20948C21[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C13__A1__9S20948C21[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C13__A1__9S20948C21[3]),  3,4},
  {&(_tg__ZTV11S20948C9_nt__9S20948C169S20948C13__A1__9S20948C21[3]),  3,4},
  {&(_tg__ZTV9S20948C13__9S20948C21[7]),  7,9},
  {&(_tg__ZTV11S20948C7_nt__9S20948C13__9S20948C21[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C13__9S20948C21[3]),  3,4},
  {&(_tg__ZTV9S20948C16__9S20948C13__9S20948C21[5]),  5,8},
  {&(_tg__ZTV9S20948C17__A2__9S20948C21[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C17__A2__9S20948C21[3]),  3,4},
  {&(_ZTV9S20948C21[46]),  46,54},
  {&(_ZTV9S20948C21[9]),  9,54},
  {&(_ZTV9S20948C21[20]),  20,54},
  {&(_ZTV9S20948C21[20]),  20,54},
  {&(_ZTV9S20948C21[52]),  52,54},
  {&(_ZTV9S20948C21[31]),  31,54},
  {&(_ZTV9S20948C21[38]),  38,54},
  {&(_tg__ZTV9S20948C10__9S20948C21[3]),  3,6},
  {&(_tg__ZTV8S20948C5__9S20948C21[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C5__9S20948C21[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S20948C21[];
extern  VTBL_ENTRY _ZTV9S20948C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C21[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S20948C5D0Ev,_ZThn56_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S20948C5D1Ev,_ZThn56_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C13D0Ev,_ZThn56_N9S20948C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C13D1Ev,_ZThn56_N9S20948C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C14D0Ev,_ZThn56_N9S20948C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C14D1Ev,_ZThn56_N9S20948C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev), // 
  (VTBL_ENTRY)_ZN9S20948C14D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev), // 
  (VTBL_ENTRY)_ZN9S20948C14D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev), // 
  (VTBL_ENTRY)_ZN9S20948C13D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev), // 
  (VTBL_ENTRY)_ZN9S20948C13D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N9S20948C21D0Ev,_ZThn68_N9S20948C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn128_N9S20948C21D1Ev,_ZThn68_N9S20948C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N9S20948C21D0Ev,_ZThn60_N9S20948C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N9S20948C21D1Ev,_ZThn60_N9S20948C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S20948C21D0Ev,_ZThn12_N9S20948C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S20948C21D1Ev,_ZThn12_N9S20948C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C21 = {  "S20948C21", // class name
  bases_S20948C21, 21,
  &(vtc_S20948C21[0]), // expected_vtbl_contents
  &(vtt_S20948C21[0]), // expected_vtt_contents
  ABISELECT(160,84), // object size
  NSPAIRA(_ZTI9S20948C21),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20948C21),54, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C21),30, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C18  : virtual S20948C15 , S20948C19 , S20948C16 , S20948C21 , virtual S20948C13 {
  virtual  ~S20948C18(); // _ZN9S20948C18D2Ev
  virtual void  v3(); // _ZN9S20948C182v3Ev
  S20948C18(); // tgen
};
//SIG(-1 S20948C18) C1{ VBC2{ BC3{ m} FC4{ m} FC3} BC5{ VBC6{ v2} BC7{ BC8{ BC4 VBC9{ vd m FD} vd} BC10{ m Fc[7]} BC6 VBC4} VBC11{ BC4 VBC9 BC6 BC12{ BC13{ VBC6 vd} VBC4 vd FC10} vd Fi} BC10 vd Fi} BC12 BC14{ VBC15{ BC6 VBC3 vd Fi:23} BC12 BC16{ BC17{ BC4 BC2 VBC8 VBC6 Fp} BC2 BC9 BC12} BC13 vd v3} VBC16 vd v1}


 S20948C18 ::~S20948C18(){ note_dtor("S20948C18", this);}
void  S20948C18 ::v3(){vfunc_called(this, "_ZN9S20948C182v3Ev");}
S20948C18 ::S20948C18(){ note_ctor("S20948C18", this);} // tgen

static void Test_S20948C18()
{
  extern Class_Descriptor cd_S20948C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(23,50)];
    init_test(&cd_S20948C18, buf);
    S20948C18 *dp, &lv = *(dp=new (buf) S20948C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(352,196), "sizeof(S20948C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C18)");
    /*is_ambiguous_... S20948C18::S20948C15 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*), ABISELECT(168,100), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C15 */ AMB_check_base_class_offset(lv, (S20948C15*), ABISELECT(168,100), "S20948C18");
    /*is_ambiguous_... S20948C19::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C19*), ABISELECT(224,128), "S20948C18");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C20*), ABISELECT(224,128), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*), ABISELECT(224,128), "S20948C18");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C21*), ABISELECT(224,128), "S20948C18");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*)(S20948C13*)(S20948C21*), ABISELECT(224,128), "S20948C18");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C13*)(S20948C21*), ABISELECT(224,128), "S20948C18");
    /*is_ambiguous_... S20948C21::S20948C17 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C21*), ABISELECT(224,128), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*)(S20948C13*), ABISELECT(224,128), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C13*), ABISELECT(224,128), "S20948C18");
    check_base_class_offset(lv, (S9624C48*)(S20948C5*)(S20948C4*)(S20948C19*), 0, "S20948C18");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*)(S20948C4*)(S20948C19*), ABISELECT(176,104), "S20948C18");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C20*), ABISELECT(176,104), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C5 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*), ABISELECT(176,104), "S20948C18");
    check_base_class_offset(lv, (S20948C5*)(S20948C4*)(S20948C19*), 0, "S20948C18");
    check_base_class_offset(lv, (S20948C8*)(S20948C4*)(S20948C19*), ABISELECT(8,4), "S20948C18");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C4*)(S20948C19*), ABISELECT(16,12), "S20948C18");
    /*is_ambiguous_... S20948C4::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C4*)(S20948C19*), ABISELECT(208,120), "S20948C18");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C20*), ABISELECT(208,120), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C16 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*), ABISELECT(208,120), "S20948C18");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C21*), ABISELECT(208,120), "S20948C18");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C13*)(S20948C21*), ABISELECT(208,120), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C13*), ABISELECT(208,120), "S20948C18");
    check_base_class_offset(lv, (S20948C4*)(S20948C19*), 0, "S20948C18");
    /*is_ambiguous_... S20948C20::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C20*), ABISELECT(216,124), "S20948C18");
    /*is_ambiguous_... S20948C20::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C20*), ABISELECT(216,124), "S20948C18");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C20*), ABISELECT(224,128), "S20948C18");
    check_base_class_offset(lv, (S20948C16*)(S20948C20*), ABISELECT(224,128), "S20948C18");
    check_base_class_offset(lv, (S20948C20*)(S20948C19*), ABISELECT(216,124), "S20948C18");
    /*is_ambiguous_... S20948C19::S20948C8 */ AMB_check_base_class_offset(lv, (S20948C8*)(S20948C19*), ABISELECT(24,16), "S20948C18");
    check_base_class_offset(lv, (S20948C19*), 0, "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*), ABISELECT(40,28), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C16*), ABISELECT(40,28), "S20948C18");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C10*), ABISELECT(248,144), "S20948C18");
    check_base_class_offset(lv, (S9624C39*)(S20948C10*), 0, "S20948C18");
    check_base_class_offset(lv, (S20948C10*)(S20948C21*), ABISELECT(248,144), "S20948C18");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C21*), ABISELECT(64,40), "S20948C18");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C21*), ABISELECT(64,40), "S20948C18");
    /*is_ambiguous_... S20948C14::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*)(S20948C13*)(S20948C21*), ABISELECT(88,56), "S20948C18");
    check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*)(S20948C13*)(S20948C21*), ABISELECT(89,57), "S20948C18");
    check_base_class_offset(lv, (S20948C15*)(S20948C14*)(S20948C13*)(S20948C21*), ABISELECT(89,57), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C5 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C5*), ABISELECT(80,52), "S20948C18");
    check_base_class_offset(lv, (S20948C5*)(S20948C14*)(S20948C13*)(S20948C21*), ABISELECT(80,52), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C5*)(S20948C14*)(S20948C13*), ABISELECT(80,52), "S20948C18");
    check_base_class_offset(lv, (S20948C14*)(S20948C13*)(S20948C21*), ABISELECT(80,52), "S20948C18");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C13*)(S20948C21*), ABISELECT(104,64), "S20948C18");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C13*)(S20948C21*), ABISELECT(104,64), "S20948C18");
    /*is_ambiguous_... S20948C13::S20948C7_nt */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C13*)(S20948C21*), ABISELECT(112,68), "S20948C18");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C13*)(S20948C21*), ABISELECT(144,84), "S20948C18");
    check_base_class_offset(lv, (S20948C16*)(S20948C13*)(S20948C21*), ABISELECT(144,84), "S20948C18");
    check_base_class_offset(lv, (S20948C13*)(S20948C21*), ABISELECT(80,52), "S20948C18");
    /*is_ambiguous_... S20948C21::S20948C17 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C21*), ABISELECT(160,96), "S20948C18");
    check_base_class_offset(lv, (S20948C21*), ABISELECT(64,40), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*)(S20948C13*), ABISELECT(280,156), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*)(S20948C13*), ABISELECT(281,157), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C14*)(S20948C13*), ABISELECT(281,157), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C14*)(S20948C13*), ABISELECT(272,152), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C13*), ABISELECT(296,164), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C13*), ABISELECT(296,164), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C13*), ABISELECT(304,168), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C13*), ABISELECT(336,184), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C13*), ABISELECT(336,184), "S20948C18");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C13*), ABISELECT(272,152), "S20948C18");
    test_class_info(&lv, &cd_S20948C18);
    dp->~S20948C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C18(Test_S20948C18, "S20948C18", ABISELECT(352,196));

#else // __cplusplus

extern void _ZN9S20948C18C1Ev();
extern void _ZN9S20948C18D2Ev();
Name_Map name_map_S20948C18[] = {
  NSPAIR(_ZN9S20948C18C1Ev),
  NSPAIR(_ZN9S20948C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C4;
extern VTBL_ENTRY _ZTI8S20948C4[];
extern  VTBL_ENTRY _ZTV8S20948C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C4[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C20;
extern VTBL_ENTRY _ZTI9S20948C20[];
extern  VTBL_ENTRY _ZTV9S20948C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C20[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C19;
extern VTBL_ENTRY _ZTI9S20948C19[];
extern  VTBL_ENTRY _ZTV9S20948C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C19[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C10;
extern VTBL_ENTRY _ZTI9S20948C10[];
extern  VTBL_ENTRY _ZTV9S20948C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C10[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C13;
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C21;
extern VTBL_ENTRY _ZTI9S20948C21[];
extern  VTBL_ENTRY _ZTV9S20948C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C21[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C13;
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
static Base_Class bases_S20948C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C39,    ABISELECT(168,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(168,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C9_nt,    ABISELECT(224,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(176,104), //bcp->offset
    66, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S20948C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20948C8,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(16,12), //bcp->offset
    14, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(208,120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20948C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(216,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(216,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(224,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(224,128), //bcp->offset
    81, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20948C20,    ABISELECT(216,124), //bcp->offset
    71, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S20948C8,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20948C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C17,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(40,28), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C9_nt,    ABISELECT(248,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S9624C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S20948C10,    ABISELECT(248,144), //bcp->offset
    89, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    37, //immediately_derived
  0, 1},
  {&cd_S20948C17,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(88,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(89,57), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(89,57), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(80,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S20948C5,    ABISELECT(80,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S20948C14,    ABISELECT(80,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(104,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(104,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(112,68), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(144,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(144,84), //bcp->offset
    51, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S20948C13,    ABISELECT(80,52), //bcp->offset
    38, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(160,96), //bcp->offset
    59, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20948C21,    ABISELECT(64,40), //bcp->offset
    25, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C48,    ABISELECT(280,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(281,157), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(281,157), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20948C14,    ABISELECT(272,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(296,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(296,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(304,168), //bcp->offset
    106, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    54, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(336,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    73, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(336,184), //bcp->offset
    110, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    55, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S20948C13,    ABISELECT(272,152), //bcp->offset
    97, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C18[];
extern void _ZN9S20948C18D1Ev();
extern void _ZN9S20948C18D0Ev();
extern void _ZN9S20948C182v3Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn40_N9S20948C18D1Ev,_ZThn28_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn40_N9S20948C18D0Ev,_ZThn28_N9S20948C18D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C18D1Ev,_ZThn40_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C18D0Ev,_ZThn40_N9S20948C18D0Ev)();
extern void _ZN9S20948C212v2Ev();
extern void ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn80_N9S20948C18D1Ev,_ZThn52_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn80_N9S20948C18D0Ev,_ZThn52_N9S20948C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZThn112_N9S20948C18D1Ev,_ZThn68_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C18D0Ev,_ZThn68_N9S20948C18D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn144_N9S20948C18D1Ev,_ZThn84_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn144_N9S20948C18D0Ev,_ZThn84_N9S20948C18D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn160_N9S20948C18D1Ev,_ZThn96_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn160_N9S20948C18D0Ev,_ZThn96_N9S20948C18D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C18D1Ev,_ZTv0_n12_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn176_N9S20948C18D1Ev,_ZThn104_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C18D0Ev,_ZTv0_n12_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn176_N9S20948C18D0Ev,_ZThn104_N9S20948C18D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n56_N9S20948C18D1Ev,_ZTv0_n28_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn216_N9S20948C18D1Ev,_ZThn124_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20948C18D0Ev,_ZTv0_n28_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn216_N9S20948C18D0Ev,_ZThn124_N9S20948C18D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn8_n56_N9S20948C18D1Ev,_ZTvn4_n28_N9S20948C18D1Ev)();
extern void ABISELECT(_ZTvn8_n56_N9S20948C18D0Ev,_ZTvn4_n28_N9S20948C18D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N9S20948C18D1Ev,_ZTv0_n20_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn248_N9S20948C18D1Ev,_ZThn144_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20948C18D0Ev,_ZTv0_n20_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn248_N9S20948C18D0Ev,_ZThn144_N9S20948C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn272_N9S20948C18D1Ev,_ZThn152_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn272_N9S20948C18D0Ev,_ZThn152_N9S20948C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn32_n32_N9S20948C18D1Ev,_ZTvn16_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N9S20948C18D0Ev,_ZTvn16_n16_N9S20948C18D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn64_n32_N9S20948C18D1Ev,_ZTvn32_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZTvn64_n32_N9S20948C18D0Ev,_ZTvn32_n16_N9S20948C18D0Ev)();
static  VTBL_ENTRY vtc_S20948C18[] = {
  ABISELECT(272,152),
  ABISELECT(80,52),
  0,
  ABISELECT(248,144),
  ABISELECT(168,100),
  ABISELECT(216,124),
  ABISELECT(224,128),
  ABISELECT(208,120),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN9S20948C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20948C182v3Ev,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  ABISELECT(168,92),
  ABISELECT(184,100),
  ABISELECT(184,100),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S20948C18D1Ev,_ZThn28_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S20948C18D0Ev,_ZThn28_N9S20948C18D0Ev),
  ABISELECT(112,64),
  ABISELECT(16,12),
  ABISELECT(-64,-40),
  ABISELECT(184,104),
  ABISELECT(144,80),
  ABISELECT(160,88),
  ABISELECT(160,88),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C18D1Ev,_ZThn40_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C18D0Ev,_ZThn40_N9S20948C18D0Ev),
  (VTBL_ENTRY)&_ZN9S20948C212v2Ev,
  ABISELECT(128,68),
  ABISELECT(144,76),
  0,
  ABISELECT(-80,-52),
  ABISELECT(96,52),
  ABISELECT(-80,-52),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev),
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S20948C18D1Ev,_ZThn68_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn112_N9S20948C18D0Ev,_ZThn68_N9S20948C18D0Ev),
  ABISELECT(64,36),
  ABISELECT(80,44),
  ABISELECT(80,44),
  ABISELECT(-144,-84),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S20948C18D1Ev,_ZThn84_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S20948C18D0Ev,_ZThn84_N9S20948C18D0Ev),
  ABISELECT(64,32),
  ABISELECT(64,32),
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S20948C18D1Ev,_ZThn96_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S20948C18D0Ev,_ZThn96_N9S20948C18D0Ev),
  ABISELECT(-176,-104),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C18D1Ev,_ZTv0_n12_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C18D0Ev,_ZTv0_n12_N9S20948C18D0Ev),
  ABISELECT(-216,-124),
  0,
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  ABISELECT(-40,-20),
  ABISELECT(-216,-124),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C18D1Ev,_ZTv0_n28_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C18D0Ev,_ZTv0_n28_N9S20948C18D0Ev),
  ABISELECT(-16,-8),
  0,
  0,
  ABISELECT(-224,-128),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C18D1Ev,_ZTvn4_n28_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C18D0Ev,_ZTvn4_n28_N9S20948C18D0Ev),
  ABISELECT(-248,-144),
  0,
  ABISELECT(-248,-144),
  ABISELECT(-248,-144),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C18D1Ev,_ZTv0_n20_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C18D0Ev,_ZTv0_n20_N9S20948C18D0Ev),
  ABISELECT(-64,-32),
  ABISELECT(-48,-24),
  ABISELECT(-192,-100),
  ABISELECT(-272,-152),
  ABISELECT(-96,-48),
  ABISELECT(-272,-152),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev),
  ABISELECT(-304,-168),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N9S20948C18D1Ev,_ZTvn16_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N9S20948C18D0Ev,_ZTvn16_n16_N9S20948C18D0Ev),
  ABISELECT(-128,-64),
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  ABISELECT(-336,-184),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n32_N9S20948C18D1Ev,_ZTvn32_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n32_N9S20948C18D0Ev,_ZTvn32_n16_N9S20948C18D0Ev),
};
extern VTBL_ENTRY _ZTV9S20948C18[];
extern void _ZN9S20948C19D1Ev();
extern void _ZN9S20948C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C19__9S20948C18[] = {
  ABISELECT(216,124),
  ABISELECT(224,128),
  ABISELECT(208,120),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN9S20948C19D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C19D0Ev,
};
extern void _ZN8S20948C4D1Ev();
extern void _ZN8S20948C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C49S20948C19__9S20948C18[] = {
  ABISELECT(208,120),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&_ZN8S20948C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C4D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C58S20948C49S20948C19__9S20948C18[] = {
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn176_N8S20948C5D1Ev,_ZThn104_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn176_N8S20948C5D0Ev,_ZThn104_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C58S20948C49S20948C19__9S20948C18[] = {
  ABISELECT(-176,-104),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev)();
extern void ABISELECT(_ZThn176_N8S20948C4D1Ev,_ZThn104_N8S20948C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev)();
extern void ABISELECT(_ZThn176_N8S20948C4D0Ev,_ZThn104_N8S20948C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C49S20948C19__9S20948C18[] = {
  ABISELECT(-176,-104),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn8_n56_N9S20948C19D1Ev,_ZTvn4_n28_N9S20948C19D1Ev)();
extern void ABISELECT(_ZTvn8_n56_N9S20948C19D0Ev,_ZTvn4_n28_N9S20948C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C20__9S20948C19__9S20948C18[] = {
  ABISELECT(-16,-8),
  0,
  0,
  ABISELECT(-224,-128),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C19D1Ev,_ZTvn4_n28_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C19D0Ev,_ZTvn4_n28_N9S20948C19D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev)();
extern void ABISELECT(_ZThn176_N9S20948C19D1Ev,_ZThn104_N9S20948C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev)();
extern void ABISELECT(_ZThn176_N9S20948C19D0Ev,_ZThn104_N9S20948C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C19__9S20948C18[] = {
  ABISELECT(-176,-104),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev)();
extern void ABISELECT(_ZThn216_N9S20948C19D1Ev,_ZThn124_N9S20948C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev)();
extern void ABISELECT(_ZThn216_N9S20948C19D0Ev,_ZThn124_N9S20948C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C20__9S20948C19__9S20948C18[] = {
  ABISELECT(-216,-124),
  0,
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  ABISELECT(-40,-20),
  ABISELECT(-216,-124),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C16__A1__9S20948C18[] = {
  ABISELECT(168,92),
  ABISELECT(184,100),
  ABISELECT(184,100),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C16__A1__9S20948C18[] = {
  ABISELECT(184,100),
  ABISELECT(184,100),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C16__A1__9S20948C18[] = {
  0,
  ABISELECT(-184,-100),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C16__A1__9S20948C18[] = {
  0,
  ABISELECT(-184,-100),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C21D1Ev();
extern void _ZN9S20948C21D0Ev();
extern void _ZN9S20948C212v2Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C21__9S20948C18[] = {
  ABISELECT(112,64),
  ABISELECT(16,12),
  ABISELECT(-64,-40),
  ABISELECT(184,104),
  ABISELECT(144,80),
  ABISELECT(160,88),
  ABISELECT(160,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C21D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C21D0Ev,
  (VTBL_ENTRY)&_ZN9S20948C212v2Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C21__A2__9S20948C18[] = {
  ABISELECT(144,80),
  ABISELECT(160,88),
  ABISELECT(160,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C21__A2__9S20948C18[] = {
  ABISELECT(160,88),
  ABISELECT(160,88),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C21__A2__9S20948C18[] = {
  0,
  ABISELECT(-160,-88),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C21__A2__9S20948C18[] = {
  0,
  ABISELECT(-160,-88),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void _ZN9S20948C13D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
extern void _ZN9S20948C13D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C139S20948C21__9S20948C18[] = {
  ABISELECT(128,68),
  ABISELECT(144,76),
  0,
  0,
  ABISELECT(96,52),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void _ZN9S20948C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
extern void _ZN9S20948C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C149S20948C139S20948C21__9S20948C18[] = {
  ABISELECT(144,76),
  0,
  0,
  ABISELECT(96,52),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev)();
extern void ABISELECT(_ZThn96_N9S20948C14D1Ev,_ZThn52_N9S20948C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev)();
extern void ABISELECT(_ZThn96_N9S20948C14D0Ev,_ZThn52_N9S20948C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C149S20948C139S20948C21__9S20948C18[] = {
  ABISELECT(-96,-52),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C149S20948C139S20948C21__9S20948C18[] = {
  0,
  ABISELECT(-144,-76),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C139S20948C21__A3__9S20948C18[] = {
  ABISELECT(64,36),
  ABISELECT(80,44),
  ABISELECT(80,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C139S20948C21__A3__9S20948C18[] = {
  ABISELECT(80,44),
  ABISELECT(80,44),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C139S20948C21__A3__9S20948C18[] = {
  0,
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C139S20948C21__A3__9S20948C18[] = {
  0,
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn96_N9S20948C13D1Ev,_ZThn52_N9S20948C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev)();
extern void ABISELECT(_ZThn96_N9S20948C13D0Ev,_ZThn52_N9S20948C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C139S20948C21__9S20948C18[] = {
  ABISELECT(-96,-52),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C139S20948C21__9S20948C18[] = {
  0,
  ABISELECT(-144,-76),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C139S20948C21__9S20948C18[] = {
  ABISELECT(64,36),
  ABISELECT(80,44),
  ABISELECT(80,44),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C21__A4__9S20948C18[] = {
  ABISELECT(64,32),
  ABISELECT(64,32),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C21__A4__9S20948C18[] = {
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn184_N9S20948C21D1Ev,_ZThn104_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn184_N9S20948C21D0Ev,_ZThn104_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C10__9S20948C21__9S20948C18[] = {
  ABISELECT(-184,-104),
  0,
  ABISELECT(-248,-144),
  ABISELECT(-184,-104),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__A1__9S20948C21__9S20948C18[] = {
  0,
  ABISELECT(-160,-88),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn16_N9S20948C21D1Ev,_ZThn12_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn16_N9S20948C21D0Ev,_ZThn12_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C13__9S20948C21__9S20948C18[] = {
  ABISELECT(128,68),
  ABISELECT(144,76),
  0,
  ABISELECT(-16,-12),
  ABISELECT(96,52),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C21D1Ev,_ZThn64_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C21D0Ev,_ZThn64_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C21__9S20948C18[] = {
  ABISELECT(-112,-64),
  ABISELECT(-112,-64),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn80_N9S20948C21D1Ev,_ZThn44_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn80_N9S20948C21D0Ev,_ZThn44_N9S20948C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C13__A1__9S20948C21__9S20948C18[] = {
  ABISELECT(64,36),
  ABISELECT(80,44),
  ABISELECT(80,44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N9S20948C21D1Ev,_ZThn44_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N9S20948C21D0Ev,_ZThn44_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn96_N9S20948C21D1Ev,_ZThn56_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn96_N9S20948C21D0Ev,_ZThn56_N9S20948C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C17__A2__9S20948C21__9S20948C18[] = {
  ABISELECT(64,32),
  ABISELECT(64,32),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N9S20948C21D1Ev,_ZThn56_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N9S20948C21D0Ev,_ZThn56_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C20D1Ev();
extern void _ZN9S20948C20D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C20__9S20948C18[] = {
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  ABISELECT(-40,-20),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C20D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C20D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C20__9S20948C18[] = {
  ABISELECT(-16,-8),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C20__9S20948C18[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20948C20D1Ev,_ZTv0_n12_N9S20948C20D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C20D0Ev,_ZTv0_n12_N9S20948C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C20__9S20948C18[] = {
  ABISELECT(40,20),
  ABISELECT(40,20),
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C20D1Ev,_ZTv0_n12_N9S20948C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C20D0Ev,_ZTv0_n12_N9S20948C20D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn8_N9S20948C20D1Ev,_ZThn4_N9S20948C20D1Ev)();
extern void ABISELECT(_ZThn8_N9S20948C20D0Ev,_ZThn4_N9S20948C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C20__9S20948C18[] = {
  ABISELECT(-16,-8),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S20948C20D1Ev,_ZThn4_N9S20948C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S20948C20D0Ev,_ZThn4_N9S20948C20D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C10D1Ev();
extern void _ZN9S20948C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C10__9S20948C18[] = {
  ABISELECT(-248,-144),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C10[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C5__A1__9S20948C18[] = {
  ABISELECT(96,52),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn96_N8S20948C5D1Ev,_ZThn52_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn96_N8S20948C5D0Ev,_ZThn52_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C5__A1__9S20948C18[] = {
  ABISELECT(-96,-52),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void _ZN9S20948C13D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
extern void _ZN9S20948C13D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C13__A1__9S20948C18[] = {
  ABISELECT(-64,-32),
  ABISELECT(-48,-24),
  ABISELECT(-192,-100),
  0,
  ABISELECT(-96,-48),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void _ZN9S20948C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
extern void _ZN9S20948C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C149S20948C13__A1__9S20948C18[] = {
  ABISELECT(-48,-24),
  ABISELECT(-192,-100),
  0,
  ABISELECT(-96,-48),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C149S20948C13__A1__9S20948C18[] = {
  ABISELECT(192,100),
  ABISELECT(96,52),
  ABISELECT(192,100),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C149S20948C13__A1__9S20948C18[] = {
  ABISELECT(96,48),
  ABISELECT(96,48),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C149S20948C13__A1__9S20948C18[] = {
  0,
  ABISELECT(48,24),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C13__A4__9S20948C18[] = {
  ABISELECT(-128,-64),
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C13__A5__9S20948C18[] = {
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C13__A5__9S20948C18[] = {
  0,
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C13__A4__9S20948C18[] = {
  0,
  ABISELECT(112,56),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C13__A1__9S20948C18[] = {
  ABISELECT(192,100),
  ABISELECT(96,52),
  ABISELECT(192,100),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C13__A1__9S20948C18[] = {
  ABISELECT(96,48),
  ABISELECT(96,48),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C13__A1__9S20948C18[] = {
  0,
  ABISELECT(48,24),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C13__A1__9S20948C18[] = {
  ABISELECT(-128,-64),
  ABISELECT(-112,-56),
  ABISELECT(-112,-56),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev),
};
static  VTT_ENTRY vtt_S20948C18[] = {
  {&(_ZTV9S20948C18[11]),  11,118},
  {&(_tg__ZTV9S20948C19__9S20948C18[6]),  6,8},
  {&(_tg__ZTV8S20948C49S20948C19__9S20948C18[4]),  4,6},
  {&(_tg__ZTV8S20948C58S20948C49S20948C19__9S20948C18[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C58S20948C49S20948C19__9S20948C18[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C49S20948C19__9S20948C18[3]),  3,5},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C19__9S20948C18[5]),  5,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C19__9S20948C18[3]),  3,5},
  {&(_tg__ZTV9S20948C20__9S20948C19__9S20948C18[7]),  7,10},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C19__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C16__A1__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C16__A1__9S20948C18[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C16__A1__9S20948C18[3]),  3,4},
  {&(_tg__ZTV11S20948C9_nt__9S20948C16__A1__9S20948C18[3]),  3,4},
  {&(_tg__ZTV9S20948C21__9S20948C18[9]),  9,13},
  {&(_tg__ZTV9S20948C169S20948C21__A2__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C21__A2__9S20948C18[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C21__A2__9S20948C18[3]),  3,4},
  {&(_tg__ZTV11S20948C9_nt__9S20948C169S20948C21__A2__9S20948C18[3]),  3,4},
  {&(_tg__ZTV9S20948C139S20948C21__9S20948C18[7]),  7,9},
  {&(_tg__ZTV9S20948C149S20948C139S20948C21__9S20948C18[6]),  6,8},
  {&(_tg__ZTV9S20948C149S20948C139S20948C21__9S20948C18[6]),  6,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C149S20948C139S20948C21__9S20948C18[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C149S20948C139S20948C21__9S20948C18[3]),  3,4},
  {&(_tg__ZTV9S20948C169S20948C139S20948C21__A3__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C139S20948C21__A3__9S20948C18[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C139S20948C21__A3__9S20948C18[3]),  3,4},
  {&(_tg__ZTV11S20948C9_nt__9S20948C169S20948C139S20948C21__A3__9S20948C18[3]),  3,4},
  {&(_tg__ZTV9S20948C139S20948C21__9S20948C18[7]),  7,9},
  {&(_tg__ZTV11S20948C7_nt__9S20948C139S20948C21__9S20948C18[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C139S20948C21__9S20948C18[3]),  3,4},
  {&(_tg__ZTV9S20948C16__9S20948C139S20948C21__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C21__A4__9S20948C18[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C21__A4__9S20948C18[3]),  3,4},
  {&(_tg__ZTV9S20948C10__9S20948C21__9S20948C18[5]),  5,8},
  {&(_tg__ZTV11S20948C9_nt__A1__9S20948C21__9S20948C18[3]),  3,4},
  {&(_tg__ZTV9S20948C13__9S20948C21__9S20948C18[7]),  7,9},
  {&(_tg__ZTV9S20948C13__9S20948C21__9S20948C18[7]),  7,9},
  {&(_tg__ZTV11S20948C7_nt__9S20948C21__9S20948C18[3]),  3,5},
  {&(_tg__ZTV9S20948C169S20948C13__A1__9S20948C21__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C17__A2__9S20948C21__9S20948C18[4]),  4,7},
  {&(_ZTV9S20948C18[86]),  86,118},
  {&(_ZTV9S20948C18[69]),  69,118},
  {&(_ZTV9S20948C18[78]),  78,118},
  {&(_ZTV9S20948C18[86]),  86,118},
  {&(_ZTV9S20948C18[22]),  22,118},
  {&(_ZTV9S20948C18[34]),  34,118},
  {&(_ZTV9S20948C18[94]),  94,118},
  {&(_ZTV9S20948C18[45]),  45,118},
  {&(_ZTV9S20948C18[45]),  45,118},
  {&(_ZTV9S20948C18[56]),  56,118},
  {&(_ZTV9S20948C18[63]),  63,118},
  {&(_ZTV9S20948C18[104]),  104,118},
  {&(_ZTV9S20948C18[108]),  108,118},
  {&(_ZTV9S20948C18[115]),  115,118},
  {&(_tg__ZTV9S20948C20__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C20__9S20948C18[4]),  4,7},
  {&(_tg__ZTV9S20948C179S20948C169S20948C20__9S20948C18[4]),  4,7},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C18[5]),  5,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C20__9S20948C18[3]),  3,5},
  {&(_tg__ZTV9S20948C16__9S20948C20__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C16__9S20948C20__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C10__9S20948C18[3]),  3,6},
  {&(_tg__ZTV8S20948C5__A1__9S20948C18[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C5__A1__9S20948C18[3]),  3,5},
  {&(_tg__ZTV9S20948C13__A1__9S20948C18[7]),  7,9},
  {&(_tg__ZTV9S20948C149S20948C13__A1__9S20948C18[6]),  6,8},
  {&(_tg__ZTV8S20948C5__9S20948C149S20948C13__A1__9S20948C18[4]),  4,6},
  {&(_tg__ZTV11S20948C7_nt__9S20948C149S20948C13__A1__9S20948C18[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C149S20948C13__A1__9S20948C18[3]),  3,4},
  {&(_tg__ZTV9S20948C169S20948C13__A4__9S20948C18[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C13__A5__9S20948C18[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C13__A5__9S20948C18[3]),  3,4},
  {&(_tg__ZTV11S20948C9_nt__9S20948C169S20948C13__A4__9S20948C18[3]),  3,4},
  {&(_tg__ZTV8S20948C5__9S20948C13__A1__9S20948C18[4]),  4,6},
  {&(_tg__ZTV11S20948C7_nt__9S20948C13__A1__9S20948C18[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C13__A1__9S20948C18[3]),  3,4},
  {&(_tg__ZTV9S20948C16__9S20948C13__A1__9S20948C18[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S20948C18[];
extern  VTBL_ENTRY _ZTV9S20948C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C18[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C21D0Ev,_ZThn64_N9S20948C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C21D1Ev,_ZThn64_N9S20948C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S20948C21D0Ev,_ZThn12_N9S20948C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S20948C21D1Ev,_ZThn12_N9S20948C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn184_N9S20948C21D0Ev,_ZThn104_N9S20948C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn184_N9S20948C21D1Ev,_ZThn104_N9S20948C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S20948C13D0Ev,_ZThn52_N9S20948C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S20948C13D1Ev,_ZThn52_N9S20948C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S20948C14D0Ev,_ZThn52_N9S20948C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S20948C14D1Ev,_ZThn52_N9S20948C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev), // 
  (VTBL_ENTRY)_ZN9S20948C14D0Ev,
  (VTBL_ENTRY)_ZN9S20948C14D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev), // 
  (VTBL_ENTRY)_ZN9S20948C14D1Ev,
  (VTBL_ENTRY)_ZN9S20948C14D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev), // 
  (VTBL_ENTRY)_ZN9S20948C13D0Ev,
  (VTBL_ENTRY)_ZN9S20948C13D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev), // 
  (VTBL_ENTRY)_ZN9S20948C13D1Ev,
  (VTBL_ENTRY)_ZN9S20948C13D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S20948C19D0Ev,_ZThn124_N9S20948C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S20948C19D1Ev,_ZThn124_N9S20948C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S20948C19D0Ev,_ZThn104_N9S20948C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S20948C19D1Ev,_ZThn104_N9S20948C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S20948C4D0Ev,_ZThn104_N8S20948C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S20948C4D1Ev,_ZThn104_N8S20948C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S20948C5D0Ev,_ZThn52_N8S20948C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S20948C5D0Ev,_ZThn104_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S20948C5D1Ev,_ZThn52_N8S20948C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S20948C5D1Ev,_ZThn104_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C18D0Ev,_ZTv0_n20_N9S20948C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn248_N9S20948C18D0Ev,_ZThn144_N9S20948C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C18D1Ev,_ZTv0_n20_N9S20948C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn248_N9S20948C18D1Ev,_ZThn144_N9S20948C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C18D0Ev,_ZTv0_n28_N9S20948C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S20948C18D0Ev,_ZThn124_N9S20948C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C18D1Ev,_ZTv0_n28_N9S20948C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S20948C18D1Ev,_ZThn124_N9S20948C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C18D0Ev,_ZTv0_n12_N9S20948C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S20948C18D0Ev,_ZThn104_N9S20948C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C18D1Ev,_ZTv0_n12_N9S20948C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S20948C18D1Ev,_ZThn104_N9S20948C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn272_N9S20948C18D0Ev,_ZThn152_N9S20948C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S20948C18D0Ev,_ZThn52_N9S20948C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn272_N9S20948C18D1Ev,_ZThn152_N9S20948C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S20948C18D1Ev,_ZThn52_N9S20948C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C18 = {  "S20948C18", // class name
  bases_S20948C18, 48,
  &(vtc_S20948C18[0]), // expected_vtbl_contents
  &(vtt_S20948C18[0]), // expected_vtt_contents
  ABISELECT(352,196), // object size
  NSPAIRA(_ZTI9S20948C18),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20948C18),118, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C18),79, //virtual table table var
  29, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C22  : virtual S20948C15 , virtual S20948C4 , S20948C8 , S20948C9_nt {
  void *s20948c22f0;
  ~S20948C22(); // tgen
  S20948C22(); // tgen
};
//SIG(-1 S20948C22) C1{ VBC2{ BC3{ m} FC4{ m} FC3} VBC5{ BC6{ BC4 VBC7{ vd m FD} vd} BC8{ m Fc[7]} BC9{ v1} VBC4} BC8 BC9 Fp}


S20948C22 ::~S20948C22(){ note_dtor("S20948C22", this);} // tgen
S20948C22 ::S20948C22(){ note_ctor("S20948C22", this);} // tgen

static void Test_S20948C22()
{
  extern Class_Descriptor cd_S20948C22;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(7,14)];
    init_test(&cd_S20948C22, buf);
    S20948C22 *dp, &lv = *(dp=new (buf) S20948C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,52), "sizeof(S20948C22)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C22)");
    check_base_class_offset(lv, (S9624C39*)(S20948C15*), ABISELECT(24,16), "S20948C22");
    check_base_class_offset(lv, (S20948C15*), ABISELECT(24,16), "S20948C22");
    check_base_class_offset(lv, (S9624C48*)(S20948C5*)(S20948C4*), ABISELECT(32,20), "S20948C22");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*)(S20948C4*), ABISELECT(64,36), "S20948C22");
    check_base_class_offset(lv, (S20948C5*)(S20948C4*), ABISELECT(32,20), "S20948C22");
    check_base_class_offset(lv, (S20948C8*)(S20948C4*), ABISELECT(40,24), "S20948C22");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C4*), ABISELECT(48,32), "S20948C22");
    /*is_ambiguous_... S20948C4::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C4*), 0, "S20948C22");
    check_base_class_offset(lv, (S20948C4*), ABISELECT(32,20), "S20948C22");
    /*is_ambiguous_... S20948C22::S20948C8 */ AMB_check_base_class_offset(lv, (S20948C8*), ABISELECT(8,4), "S20948C22");
    /*is_ambiguous_... S20948C22::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*), 0, "S20948C22");
    check_field_offset(lv, s20948c22f0, ABISELECT(16,12), "S20948C22.s20948c22f0");
    test_class_info(&lv, &cd_S20948C22);
    dp->~S20948C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C22(Test_S20948C22, "S20948C22", ABISELECT(96,52));

#else // __cplusplus

extern void _ZN9S20948C22C1Ev();
extern void _ZN9S20948C22D1Ev();
Name_Map name_map_S20948C22[] = {
  NSPAIR(_ZN9S20948C22C1Ev),
  NSPAIR(_ZN9S20948C22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C4;
extern VTBL_ENTRY _ZTI8S20948C4[];
extern  VTBL_ENTRY _ZTV8S20948C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C4[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
static Base_Class bases_S20948C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C39,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S9624C48,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(64,36), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20948C5,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20948C8,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(48,32), //bcp->offset
    17, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S20948C4,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C8,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C22[];
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C22D1Ev();
extern void _ZN9S20948C22D0Ev();
extern void ABISELECT(_ZTv0_n40_N9S20948C22D1Ev,_ZTv0_n20_N9S20948C22D1Ev)();
extern void ABISELECT(_ZThn32_N9S20948C22D1Ev,_ZThn20_N9S20948C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20948C22D0Ev,_ZTv0_n20_N9S20948C22D0Ev)();
extern void ABISELECT(_ZThn32_N9S20948C22D0Ev,_ZThn20_N9S20948C22D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n24_N9S20948C22D1Ev,_ZTv0_n12_N9S20948C22D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C22D1Ev,_ZThn36_N9S20948C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C22D0Ev,_ZTv0_n12_N9S20948C22D0Ev)();
extern void ABISELECT(_ZThn64_N9S20948C22D0Ev,_ZThn36_N9S20948C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20948C22[] = {
  0,
  ABISELECT(64,36),
  ABISELECT(32,20),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C22[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C22D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C22D0Ev,
  ABISELECT(16,12),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  ABISELECT(32,16),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S20948C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C22D1Ev,_ZTv0_n20_N9S20948C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C22D0Ev,_ZTv0_n20_N9S20948C22D0Ev),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C22[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI9S20948C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C22D1Ev,_ZTv0_n12_N9S20948C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C22D0Ev,_ZTv0_n12_N9S20948C22D0Ev),
};
extern VTBL_ENTRY _ZTV9S20948C22[];
extern void _ZN8S20948C4D1Ev();
extern void _ZN8S20948C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C4__9S20948C22[] = {
  ABISELECT(-32,-20),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&_ZN8S20948C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C4D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C58S20948C4__9S20948C22[] = {
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn32_N8S20948C5D1Ev,_ZThn16_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn32_N8S20948C5D0Ev,_ZThn16_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C58S20948C4__9S20948C22[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev)();
extern void ABISELECT(_ZThn32_N8S20948C4D1Ev,_ZThn16_N8S20948C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev)();
extern void ABISELECT(_ZThn32_N8S20948C4D0Ev,_ZThn16_N8S20948C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C4__9S20948C22[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev),
};
static  VTT_ENTRY vtt_S20948C22[] = {
  {&(_ZTV9S20948C22[6]),  6,25},
  {&(_ZTV9S20948C22[15]),  15,25},
  {&(_ZTV9S20948C22[23]),  23,25},
  {&(_ZTV9S20948C22[19]),  19,25},
  {&(_tg__ZTV8S20948C4__9S20948C22[4]),  4,6},
  {&(_tg__ZTV8S20948C58S20948C4__9S20948C22[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C58S20948C4__9S20948C22[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C4__9S20948C22[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S20948C22[];
extern  VTBL_ENTRY _ZTV9S20948C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C22[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C4D0Ev,_ZThn16_N8S20948C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C4D1Ev,_ZThn16_N8S20948C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C5D0Ev,_ZThn16_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S20948C5D1Ev,_ZThn16_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C22D0Ev,_ZTv0_n12_N9S20948C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S20948C22D0Ev,_ZThn36_N9S20948C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C22D1Ev,_ZTv0_n12_N9S20948C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N9S20948C22D1Ev,_ZThn36_N9S20948C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C22D0Ev,_ZTv0_n20_N9S20948C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S20948C22D0Ev,_ZThn20_N9S20948C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C22D1Ev,_ZTv0_n20_N9S20948C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S20948C22D1Ev,_ZThn20_N9S20948C22D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C22 = {  "S20948C22", // class name
  bases_S20948C22, 11,
  &(vtc_S20948C22[0]), // expected_vtbl_contents
  &(vtt_S20948C22[0]), // expected_vtt_contents
  ABISELECT(96,52), // object size
  NSPAIRA(_ZTI9S20948C22),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20948C22),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C22),8, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C24_nt  : S20948C9_nt {
  ~S20948C24_nt(); // tgen
  S20948C24_nt(); // tgen
};
//SIG(-1 S20948C24_nt) C1{ BC2{ v1}}


S20948C24_nt ::~S20948C24_nt(){ note_dtor("S20948C24_nt", this);} // tgen
S20948C24_nt ::S20948C24_nt(){ note_ctor("S20948C24_nt", this);} // tgen

//skip512 S20948C24_nt

#else // __cplusplus

extern void _ZN12S20948C24_ntC1Ev();
extern void _ZN12S20948C24_ntD1Ev();
Name_Map name_map_S20948C24_nt[] = {
  NSPAIR(_ZN12S20948C24_ntC1Ev),
  NSPAIR(_ZN12S20948C24_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
static Base_Class bases_S20948C24_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20948C9_nt,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI12S20948C24_nt[];
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY vtc_S20948C24_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI12S20948C24_nt[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern VTBL_ENTRY _ZTI12S20948C24_nt[];
VTBL_ENTRY *P__ZTI12S20948C24_nt = _ZTI12S20948C24_nt; 
extern  VTBL_ENTRY _ZTV12S20948C24_nt[];
Class_Descriptor cd_S20948C24_nt = {  "S20948C24_nt", // class name
  bases_S20948C24_nt, 1,
  &(vtc_S20948C24_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI12S20948C24_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV12S20948C24_nt),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C23  : virtual S20948C24_nt , virtual S20948C9_nt , virtual S20948C18 {
  long s20948c23f0[2];
  ~S20948C23(); // tgen
  S20948C23(); // tgen
};
//SIG(-1 S20948C23) C1{ VBC2{ BC3{ v1}} VBC3 VBC4{ VBC5{ BC6{ m} FC7{ m} FC6} BC8{ VBC3 BC9{ BC10{ BC7 VBC11{ vd m FD} vd} BC12{ m Fc[7]} BC3 VBC7} VBC13{ BC7 VBC11 BC3 BC14{ BC15{ VBC3 vd} VBC7 vd FC12} vd Fi} BC12 vd Fi} BC14 BC16{ VBC17{ BC3 VBC6 vd Fi:23} BC14 BC18{ BC19{ BC7 BC5 VBC10 VBC3 Fp} BC5 BC11 BC14} BC15 vd v2} VBC18 vd v3} Fl[2]}


S20948C23 ::~S20948C23(){ note_dtor("S20948C23", this);} // tgen
S20948C23 ::S20948C23(){ note_ctor("S20948C23", this);} // tgen

static void Test_S20948C23()
{
  extern Class_Descriptor cd_S20948C23;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(24,52)];
    init_test(&cd_S20948C23, buf);
    S20948C23 *dp, &lv = *(dp=new (buf) S20948C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,204), "sizeof(S20948C23)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C23)");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C24_nt*), 0, "S20948C23");
    check_base_class_offset(lv, (S20948C24_nt*), 0, "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*), ABISELECT(248,136), "S20948C23");
    /*is_ambiguous_... S20948C19::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C19*)(S20948C18*), ABISELECT(248,136), "S20948C23");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C20*), ABISELECT(248,136), "S20948C23");
    /*is_ambiguous_... S20948C18::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C18*), ABISELECT(248,136), "S20948C23");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C21*)(S20948C18*), ABISELECT(248,136), "S20948C23");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(248,136), "S20948C23");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(248,136), "S20948C23");
    /*is_ambiguous_... S20948C21::S20948C17 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C21*)(S20948C18*), ABISELECT(248,136), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*)(S20948C13*), ABISELECT(248,136), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C13*), ABISELECT(248,136), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C15 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*), ABISELECT(200,112), "S20948C23");
    /*is_ambiguous_... S20948C18::S20948C15 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C18*), ABISELECT(200,112), "S20948C23");
    check_base_class_offset(lv, (S9624C48*)(S20948C5*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(32,12), "S20948C23");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(208,116), "S20948C23");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C20*), ABISELECT(208,116), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C5 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*), ABISELECT(208,116), "S20948C23");
    check_base_class_offset(lv, (S20948C5*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(32,12), "S20948C23");
    check_base_class_offset(lv, (S20948C8*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(40,16), "S20948C23");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(48,24), "S20948C23");
    /*is_ambiguous_... S20948C4::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C4*)(S20948C19*)(S20948C18*), 0, "S20948C23");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C20*), 0, "S20948C23");
    /*is_ambiguous_... S20948C18::S20948C16 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C18*), 0, "S20948C23");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C21*)(S20948C18*), 0, "S20948C23");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), 0, "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C13*), 0, "S20948C23");
    check_base_class_offset(lv, (S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(32,12), "S20948C23");
    /*is_ambiguous_... S20948C20::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C20*), ABISELECT(240,132), "S20948C23");
    /*is_ambiguous_... S20948C20::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C20*), ABISELECT(240,132), "S20948C23");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C20*), ABISELECT(248,136), "S20948C23");
    check_base_class_offset(lv, (S20948C16*)(S20948C20*), ABISELECT(248,136), "S20948C23");
    check_base_class_offset(lv, (S20948C20*)(S20948C19*)(S20948C18*), ABISELECT(240,132), "S20948C23");
    /*is_ambiguous_... S20948C19::S20948C8 */ AMB_check_base_class_offset(lv, (S20948C8*)(S20948C19*)(S20948C18*), ABISELECT(56,28), "S20948C23");
    check_base_class_offset(lv, (S20948C19*)(S20948C18*), ABISELECT(32,12), "S20948C23");
    /*is_ambiguous_... S20948C18::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C18*), ABISELECT(72,40), "S20948C23");
    /*is_ambiguous_... S20948C18::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C18*), ABISELECT(72,40), "S20948C23");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C10*), ABISELECT(272,152), "S20948C23");
    check_base_class_offset(lv, (S9624C39*)(S20948C10*), 0, "S20948C23");
    check_base_class_offset(lv, (S20948C10*)(S20948C21*)(S20948C18*), ABISELECT(272,152), "S20948C23");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C21*)(S20948C18*), ABISELECT(96,52), "S20948C23");
    /*is_ambiguous_... S20948C21::S20948C16 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C21*)(S20948C18*), ABISELECT(96,52), "S20948C23");
    /*is_ambiguous_... S20948C14::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(120,68), "S20948C23");
    check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(121,69), "S20948C23");
    check_base_class_offset(lv, (S20948C15*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(121,69), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C5 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C5*), ABISELECT(112,64), "S20948C23");
    check_base_class_offset(lv, (S20948C5*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(112,64), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C5*)(S20948C14*)(S20948C13*), ABISELECT(112,64), "S20948C23");
    check_base_class_offset(lv, (S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(112,64), "S20948C23");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(136,76), "S20948C23");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(136,76), "S20948C23");
    /*is_ambiguous_... S20948C13::S20948C7_nt */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(144,80), "S20948C23");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(176,96), "S20948C23");
    check_base_class_offset(lv, (S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(176,96), "S20948C23");
    check_base_class_offset(lv, (S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(112,64), "S20948C23");
    /*is_ambiguous_... S20948C21::S20948C17 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C21*)(S20948C18*), ABISELECT(192,108), "S20948C23");
    check_base_class_offset(lv, (S20948C21*)(S20948C18*), ABISELECT(96,52), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*)(S20948C13*), ABISELECT(296,164), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*)(S20948C13*), ABISELECT(297,165), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C14*)(S20948C13*), ABISELECT(297,165), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C14*)(S20948C13*), ABISELECT(288,160), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C13*), ABISELECT(312,172), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C13*), ABISELECT(312,172), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C13*), ABISELECT(320,176), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C13*), ABISELECT(352,192), "S20948C23");
    /*is_ambiguous_... S20948C23::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C13*), ABISELECT(352,192), "S20948C23");
    /*is_ambiguous_... S20948C18::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C13*)(S20948C18*), ABISELECT(288,160), "S20948C23");
    check_base_class_offset(lv, (S20948C18*), ABISELECT(32,12), "S20948C23");
    check_field_offset(lv, s20948c23f0, ABISELECT(8,4), "S20948C23.s20948c23f0");
    test_class_info(&lv, &cd_S20948C23);
    dp->~S20948C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C23(Test_S20948C23, "S20948C23", ABISELECT(368,204));

#else // __cplusplus

extern void _ZN9S20948C23C1Ev();
extern void _ZN9S20948C23D1Ev();
Name_Map name_map_S20948C23[] = {
  NSPAIR(_ZN9S20948C23C1Ev),
  NSPAIR(_ZN9S20948C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C24_nt;
extern VTBL_ENTRY _ZTI12S20948C24_nt[];
extern  VTBL_ENTRY _ZTV12S20948C24_nt[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C4;
extern VTBL_ENTRY _ZTI8S20948C4[];
extern  VTBL_ENTRY _ZTV8S20948C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C4[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C20;
extern VTBL_ENTRY _ZTI9S20948C20[];
extern  VTBL_ENTRY _ZTV9S20948C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C20[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C19;
extern VTBL_ENTRY _ZTI9S20948C19[];
extern  VTBL_ENTRY _ZTV9S20948C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C19[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C10;
extern VTBL_ENTRY _ZTI9S20948C10[];
extern  VTBL_ENTRY _ZTV9S20948C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C10[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C13;
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C21;
extern VTBL_ENTRY _ZTI9S20948C21[];
extern  VTBL_ENTRY _ZTV9S20948C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C21[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C13;
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
extern Class_Descriptor cd_S20948C18;
extern VTBL_ENTRY _ZTI9S20948C18[];
extern  VTBL_ENTRY _ZTV9S20948C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C18[];
static Base_Class bases_S20948C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20948C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20948C24_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C9_nt,    ABISELECT(248,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S9624C39,    ABISELECT(200,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(200,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    50, //immediately_derived
  0, 1},
  {&cd_S9624C48,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(208,116), //bcp->offset
    87, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20948C5,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20948C8,    ABISELECT(40,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(48,24), //bcp->offset
    35, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S20948C4,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(240,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(240,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(248,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    77, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(248,136), //bcp->offset
    102, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    76, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20948C20,    ABISELECT(240,132), //bcp->offset
    92, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    75, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S20948C8,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20948C19,    ABISELECT(32,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(72,40), //bcp->offset
    38, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(272,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S9624C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S20948C10,    ABISELECT(272,152), //bcp->offset
    110, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    83, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    39, //immediately_derived
  0, 1},
  {&cd_S20948C17,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(120,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(121,69), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(121,69), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(112,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S20948C5,    ABISELECT(112,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    84, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    31, //immediately_derived
  0, 1},
  {&cd_S20948C14,    ABISELECT(112,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(136,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(144,80), //bcp->offset
    68, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(176,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(176,96), //bcp->offset
    72, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20948C13,    ABISELECT(112,64), //bcp->offset
    59, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(192,108), //bcp->offset
    80, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20948C21,    ABISELECT(96,52), //bcp->offset
    46, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(296,164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(297,165), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(297,165), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S20948C14,    ABISELECT(288,160), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    87, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(312,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(312,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(320,176), //bcp->offset
    127, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(352,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    92, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(352,192), //bcp->offset
    131, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    91, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S20948C13,    ABISELECT(288,160), //bcp->offset
    118, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    86, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    50, //immediately_derived
  0, 1},
  {&cd_S20948C18,    ABISELECT(32,12), //bcp->offset
    17, //bcp->virtual_function_table_offset
    15, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20948C23[];
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C23D1Ev();
extern void _ZN9S20948C23D0Ev();
extern void ABISELECT(_ZTv0_n96_N9S20948C23D1Ev,_ZTv0_n48_N9S20948C23D1Ev)();
extern void ABISELECT(_ZThn32_N9S20948C23D1Ev,_ZThn12_N9S20948C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N9S20948C23D0Ev,_ZTv0_n48_N9S20948C23D0Ev)();
extern void ABISELECT(_ZThn32_N9S20948C23D0Ev,_ZThn12_N9S20948C23D0Ev)() __attribute__((weak));
extern void _ZN9S20948C182v3Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn40_n96_N9S20948C23D1Ev,_ZTvn28_n48_N9S20948C23D1Ev)();
extern void ABISELECT(_ZTvn40_n96_N9S20948C23D0Ev,_ZTvn28_n48_N9S20948C23D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn64_n96_N9S20948C23D1Ev,_ZTvn40_n48_N9S20948C23D1Ev)();
extern void ABISELECT(_ZTvn64_n96_N9S20948C23D0Ev,_ZTvn40_n48_N9S20948C23D0Ev)();
extern void _ZN9S20948C212v2Ev();
extern void ABISELECT(_ZTv0_n32_N9S20948C23D1Ev,_ZTv0_n16_N9S20948C23D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C23D1Ev,_ZThn64_N9S20948C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C23D0Ev,_ZTv0_n16_N9S20948C23D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C23D0Ev,_ZThn64_N9S20948C23D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn112_n96_N9S20948C23D1Ev,_ZTvn68_n48_N9S20948C23D1Ev)();
extern void ABISELECT(_ZTvn112_n96_N9S20948C23D0Ev,_ZTvn68_n48_N9S20948C23D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn144_n96_N9S20948C23D1Ev,_ZTvn84_n48_N9S20948C23D1Ev)();
extern void ABISELECT(_ZTvn144_n96_N9S20948C23D0Ev,_ZTvn84_n48_N9S20948C23D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn160_n96_N9S20948C23D1Ev,_ZTvn96_n48_N9S20948C23D1Ev)();
extern void ABISELECT(_ZTvn160_n96_N9S20948C23D0Ev,_ZTvn96_n48_N9S20948C23D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C23D1Ev,_ZTv0_n12_N9S20948C23D1Ev)();
extern void ABISELECT(_ZThn208_N9S20948C23D1Ev,_ZThn116_N9S20948C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C23D0Ev,_ZTv0_n12_N9S20948C23D0Ev)();
extern void ABISELECT(_ZThn208_N9S20948C23D0Ev,_ZThn116_N9S20948C23D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n56_N9S20948C23D1Ev,_ZTv0_n28_N9S20948C23D1Ev)();
extern void ABISELECT(_ZThn240_N9S20948C23D1Ev,_ZThn132_N9S20948C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20948C23D0Ev,_ZTv0_n28_N9S20948C23D0Ev)();
extern void ABISELECT(_ZThn240_N9S20948C23D0Ev,_ZThn132_N9S20948C23D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn8_n56_N9S20948C23D1Ev,_ZTvn4_n28_N9S20948C23D1Ev)();
extern void ABISELECT(_ZTvn8_n56_N9S20948C23D0Ev,_ZTvn4_n28_N9S20948C23D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N9S20948C23D1Ev,_ZTv0_n20_N9S20948C23D1Ev)();
extern void ABISELECT(_ZThn272_N9S20948C23D1Ev,_ZThn152_N9S20948C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20948C23D0Ev,_ZTv0_n20_N9S20948C23D0Ev)();
extern void ABISELECT(_ZThn272_N9S20948C23D0Ev,_ZThn152_N9S20948C23D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C23D1Ev,_ZTv0_n16_N9S20948C23D1Ev)();
extern void ABISELECT(_ZThn288_N9S20948C23D1Ev,_ZThn160_N9S20948C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C23D0Ev,_ZTv0_n16_N9S20948C23D0Ev)();
extern void ABISELECT(_ZThn288_N9S20948C23D0Ev,_ZThn160_N9S20948C23D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn32_n32_N9S20948C23D1Ev,_ZTvn16_n16_N9S20948C23D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N9S20948C23D0Ev,_ZTvn16_n16_N9S20948C23D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn64_n32_N9S20948C23D1Ev,_ZTvn32_n16_N9S20948C23D1Ev)();
extern void ABISELECT(_ZTvn64_n32_N9S20948C23D0Ev,_ZTvn32_n16_N9S20948C23D0Ev)();
static  VTBL_ENTRY vtc_S20948C23[] = {
  ABISELECT(288,160),
  ABISELECT(112,64),
  0,
  ABISELECT(272,152),
  ABISELECT(240,132),
  0,
  ABISELECT(208,116),
  ABISELECT(200,112),
  ABISELECT(32,12),
  ABISELECT(248,136),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C23D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C23D0Ev,
  ABISELECT(64,40),
  0,
  ABISELECT(16,12),
  ABISELECT(-32,-12),
  ABISELECT(256,148),
  ABISELECT(80,52),
  ABISELECT(-32,-12),
  ABISELECT(240,140),
  ABISELECT(168,100),
  ABISELECT(208,120),
  ABISELECT(216,124),
  ABISELECT(-32,-12),
  ABISELECT(176,104),
  ABISELECT(-32,-12),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20948C23D1Ev,_ZTv0_n48_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N9S20948C23D0Ev,_ZTv0_n48_N9S20948C23D0Ev),
  (VTBL_ENTRY)&_ZN9S20948C182v3Ev,
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  ABISELECT(-72,-40),
  ABISELECT(176,96),
  ABISELECT(176,96),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n96_N9S20948C23D1Ev,_ZTvn28_n48_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n96_N9S20948C23D0Ev,_ZTvn28_n48_N9S20948C23D0Ev),
  ABISELECT(112,64),
  ABISELECT(16,12),
  ABISELECT(-96,-52),
  ABISELECT(176,100),
  ABISELECT(-96,-52),
  ABISELECT(152,84),
  ABISELECT(152,84),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n96_N9S20948C23D1Ev,_ZTvn40_n48_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n96_N9S20948C23D0Ev,_ZTvn40_n48_N9S20948C23D0Ev),
  (VTBL_ENTRY)&_ZN9S20948C212v2Ev,
  ABISELECT(-112,-64),
  ABISELECT(136,72),
  0,
  ABISELECT(-112,-64),
  ABISELECT(96,52),
  ABISELECT(-112,-64),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C23D1Ev,_ZTv0_n16_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C23D0Ev,_ZTv0_n16_N9S20948C23D0Ev),
  ABISELECT(-144,-80),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n96_N9S20948C23D1Ev,_ZTvn68_n48_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n96_N9S20948C23D0Ev,_ZTvn68_n48_N9S20948C23D0Ev),
  ABISELECT(-176,-96),
  ABISELECT(72,40),
  ABISELECT(72,40),
  ABISELECT(-176,-96),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn144_n96_N9S20948C23D1Ev,_ZTvn84_n48_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn144_n96_N9S20948C23D0Ev,_ZTvn84_n48_N9S20948C23D0Ev),
  ABISELECT(56,28),
  ABISELECT(56,28),
  ABISELECT(-192,-108),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n96_N9S20948C23D1Ev,_ZTvn96_n48_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n96_N9S20948C23D0Ev,_ZTvn96_n48_N9S20948C23D0Ev),
  ABISELECT(-208,-116),
  ABISELECT(-208,-116),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C23D1Ev,_ZTv0_n12_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C23D0Ev,_ZTv0_n12_N9S20948C23D0Ev),
  ABISELECT(-240,-132),
  0,
  ABISELECT(-240,-132),
  ABISELECT(8,4),
  ABISELECT(-32,-16),
  ABISELECT(-240,-132),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C23D1Ev,_ZTv0_n28_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C23D0Ev,_ZTv0_n28_N9S20948C23D0Ev),
  ABISELECT(-248,-136),
  0,
  0,
  ABISELECT(-248,-136),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C23D1Ev,_ZTvn4_n28_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C23D0Ev,_ZTvn4_n28_N9S20948C23D0Ev),
  ABISELECT(-272,-152),
  0,
  ABISELECT(-272,-152),
  ABISELECT(-272,-152),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C23D1Ev,_ZTv0_n20_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C23D0Ev,_ZTv0_n20_N9S20948C23D0Ev),
  ABISELECT(-288,-160),
  ABISELECT(-40,-24),
  ABISELECT(-176,-96),
  ABISELECT(-288,-160),
  ABISELECT(-80,-44),
  ABISELECT(-288,-160),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C23D1Ev,_ZTv0_n16_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C23D0Ev,_ZTv0_n16_N9S20948C23D0Ev),
  ABISELECT(-320,-176),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N9S20948C23D1Ev,_ZTvn16_n16_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N9S20948C23D0Ev,_ZTvn16_n16_N9S20948C23D0Ev),
  ABISELECT(-352,-192),
  ABISELECT(-104,-56),
  ABISELECT(-104,-56),
  ABISELECT(-352,-192),
  (VTBL_ENTRY)&(_ZTI9S20948C23[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n32_N9S20948C23D1Ev,_ZTvn32_n16_N9S20948C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n32_N9S20948C23D0Ev,_ZTvn32_n16_N9S20948C23D0Ev),
};
extern VTBL_ENTRY _ZTV9S20948C23[];
extern void _ZN9S20948C18D1Ev();
extern void _ZN9S20948C18D0Ev();
extern void _ZN9S20948C182v3Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C18__9S20948C23[] = {
  ABISELECT(256,148),
  ABISELECT(80,52),
  ABISELECT(-32,-12),
  ABISELECT(240,140),
  ABISELECT(168,100),
  ABISELECT(208,120),
  ABISELECT(216,124),
  ABISELECT(-32,-12),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN9S20948C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20948C182v3Ev,
};
extern void _ZN9S20948C19D1Ev();
extern void _ZN9S20948C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C199S20948C18__9S20948C23[] = {
  ABISELECT(208,120),
  ABISELECT(216,124),
  ABISELECT(-32,-12),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN9S20948C19D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C19D0Ev,
};
extern void _ZN8S20948C4D1Ev();
extern void _ZN8S20948C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C49S20948C199S20948C18__9S20948C23[] = {
  ABISELECT(-32,-12),
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&_ZN8S20948C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C4D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C58S20948C49S20948C199S20948C18__9S20948C23[] = {
  ABISELECT(176,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn176_N8S20948C5D1Ev,_ZThn104_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn176_N8S20948C5D0Ev,_ZThn104_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C58S20948C49S20948C199S20948C18__9S20948C23[] = {
  ABISELECT(-176,-104),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev)();
extern void ABISELECT(_ZThn176_N8S20948C4D1Ev,_ZThn104_N8S20948C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev)();
extern void ABISELECT(_ZThn176_N8S20948C4D0Ev,_ZThn104_N8S20948C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C49S20948C199S20948C18__9S20948C23[] = {
  ABISELECT(-176,-104),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn8_n56_N9S20948C19D1Ev,_ZTvn4_n28_N9S20948C19D1Ev)();
extern void ABISELECT(_ZTvn8_n56_N9S20948C19D0Ev,_ZTvn4_n28_N9S20948C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C20__9S20948C199S20948C18__9S20948C23[] = {
  ABISELECT(-248,-136),
  0,
  0,
  ABISELECT(-216,-124),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C19D1Ev,_ZTvn4_n28_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C19D0Ev,_ZTvn4_n28_N9S20948C19D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev)();
extern void ABISELECT(_ZThn176_N9S20948C19D1Ev,_ZThn104_N9S20948C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev)();
extern void ABISELECT(_ZThn176_N9S20948C19D0Ev,_ZThn104_N9S20948C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C199S20948C18__9S20948C23[] = {
  ABISELECT(-176,-104),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S20948C19D1Ev,_ZThn120_N9S20948C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev)();
extern void ABISELECT(_ZThn208_N9S20948C19D0Ev,_ZThn120_N9S20948C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C20__9S20948C199S20948C18__9S20948C23[] = {
  ABISELECT(-208,-120),
  0,
  ABISELECT(-240,-132),
  ABISELECT(8,4),
  ABISELECT(-32,-16),
  ABISELECT(-208,-120),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C18__A1__9S20948C23[] = {
  ABISELECT(-72,-40),
  ABISELECT(176,96),
  ABISELECT(176,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C18__A1__9S20948C23[] = {
  ABISELECT(176,96),
  ABISELECT(176,96),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C18__A1__9S20948C23[] = {
  0,
  ABISELECT(-176,-96),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C18__A1__9S20948C23[] = {
  0,
  ABISELECT(-176,-96),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C21D1Ev();
extern void _ZN9S20948C21D0Ev();
extern void _ZN9S20948C212v2Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(112,64),
  ABISELECT(16,12),
  ABISELECT(-96,-52),
  ABISELECT(176,100),
  ABISELECT(-96,-52),
  ABISELECT(152,84),
  ABISELECT(152,84),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C21D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C21D0Ev,
  (VTBL_ENTRY)&_ZN9S20948C212v2Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C219S20948C18__A2__9S20948C23[] = {
  ABISELECT(-96,-52),
  ABISELECT(152,84),
  ABISELECT(152,84),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C219S20948C18__A2__9S20948C23[] = {
  ABISELECT(152,84),
  ABISELECT(152,84),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C219S20948C18__A2__9S20948C23[] = {
  0,
  ABISELECT(-152,-84),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C219S20948C18__A2__9S20948C23[] = {
  0,
  ABISELECT(-152,-84),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void _ZN9S20948C13D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
extern void _ZN9S20948C13D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C139S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(-112,-64),
  ABISELECT(136,72),
  0,
  0,
  ABISELECT(96,52),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void _ZN9S20948C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
extern void _ZN9S20948C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C149S20948C139S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(136,72),
  0,
  0,
  ABISELECT(96,52),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev)();
extern void ABISELECT(_ZThn96_N9S20948C14D1Ev,_ZThn52_N9S20948C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev)();
extern void ABISELECT(_ZThn96_N9S20948C14D0Ev,_ZThn52_N9S20948C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C149S20948C139S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(-96,-52),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C149S20948C139S20948C219S20948C18__9S20948C23[] = {
  0,
  ABISELECT(-136,-72),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C139S20948C219S20948C18__A3__9S20948C23[] = {
  ABISELECT(-176,-96),
  ABISELECT(72,40),
  ABISELECT(72,40),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C139S20948C219S20948C18__A3__9S20948C23[] = {
  ABISELECT(72,40),
  ABISELECT(72,40),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C139S20948C219S20948C18__A3__9S20948C23[] = {
  0,
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C139S20948C219S20948C18__A3__9S20948C23[] = {
  0,
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn96_N9S20948C13D1Ev,_ZThn52_N9S20948C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev)();
extern void ABISELECT(_ZThn96_N9S20948C13D0Ev,_ZThn52_N9S20948C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C139S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(-96,-52),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C139S20948C219S20948C18__9S20948C23[] = {
  0,
  ABISELECT(-136,-72),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C139S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(-176,-96),
  ABISELECT(72,40),
  ABISELECT(72,40),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C219S20948C18__A4__9S20948C23[] = {
  ABISELECT(56,28),
  ABISELECT(56,28),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C219S20948C18__A4__9S20948C23[] = {
  0,
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn176_N9S20948C21D1Ev,_ZThn100_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn176_N9S20948C21D0Ev,_ZThn100_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C10__9S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(-176,-100),
  0,
  ABISELECT(-272,-152),
  ABISELECT(-176,-100),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__A1__9S20948C219S20948C18__9S20948C23[] = {
  0,
  ABISELECT(-152,-84),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn16_N9S20948C21D1Ev,_ZThn12_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn16_N9S20948C21D0Ev,_ZThn12_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C13__9S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(-112,-64),
  ABISELECT(136,72),
  0,
  ABISELECT(-16,-12),
  ABISELECT(96,52),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C21D1Ev,_ZThn64_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C21D0Ev,_ZThn64_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(-112,-64),
  ABISELECT(-112,-64),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn80_N9S20948C21D1Ev,_ZThn44_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn80_N9S20948C21D0Ev,_ZThn44_N9S20948C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C13__A1__9S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(-176,-96),
  ABISELECT(72,40),
  ABISELECT(72,40),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N9S20948C21D1Ev,_ZThn44_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N9S20948C21D0Ev,_ZThn44_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn96_N9S20948C21D1Ev,_ZThn56_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn96_N9S20948C21D0Ev,_ZThn56_N9S20948C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C17__A2__9S20948C219S20948C18__9S20948C23[] = {
  ABISELECT(56,28),
  ABISELECT(56,28),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N9S20948C21D1Ev,_ZThn56_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N9S20948C21D0Ev,_ZThn56_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn8_n56_N9S20948C18D1Ev,_ZTvn4_n28_N9S20948C18D1Ev)();
extern void ABISELECT(_ZTvn8_n56_N9S20948C18D0Ev,_ZTvn4_n28_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C20__9S20948C18__9S20948C23[] = {
  ABISELECT(-248,-136),
  0,
  0,
  ABISELECT(-216,-124),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C18D1Ev,_ZTvn4_n28_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C18D0Ev,_ZTvn4_n28_N9S20948C18D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C18D1Ev,_ZTv0_n12_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn176_N9S20948C18D1Ev,_ZThn104_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C18D0Ev,_ZTv0_n12_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn176_N9S20948C18D0Ev,_ZThn104_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C18__9S20948C23[] = {
  ABISELECT(-176,-104),
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C18D1Ev,_ZTv0_n12_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C18D0Ev,_ZTv0_n12_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n56_N9S20948C18D1Ev,_ZTv0_n28_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn208_N9S20948C18D1Ev,_ZThn120_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20948C18D0Ev,_ZTv0_n28_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn208_N9S20948C18D0Ev,_ZThn120_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C20__9S20948C18__9S20948C23[] = {
  ABISELECT(-208,-120),
  0,
  ABISELECT(-240,-132),
  ABISELECT(8,4),
  ABISELECT(-32,-16),
  ABISELECT(-208,-120),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C18D1Ev,_ZTv0_n28_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C18D0Ev,_ZTv0_n28_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn40_N9S20948C18D1Ev,_ZThn28_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn40_N9S20948C18D0Ev,_ZThn28_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__A1__9S20948C18__9S20948C23[] = {
  ABISELECT(-72,-40),
  ABISELECT(176,96),
  ABISELECT(176,96),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S20948C18D1Ev,_ZThn28_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S20948C18D0Ev,_ZThn28_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C18D1Ev,_ZThn40_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C18D0Ev,_ZThn40_N9S20948C18D0Ev)();
extern void _ZN9S20948C212v2Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C21__9S20948C18__9S20948C23[] = {
  ABISELECT(112,64),
  ABISELECT(16,12),
  ABISELECT(-96,-52),
  ABISELECT(176,100),
  ABISELECT(-96,-52),
  ABISELECT(152,84),
  ABISELECT(152,84),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C18D1Ev,_ZThn40_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C18D0Ev,_ZThn40_N9S20948C18D0Ev),
  (VTBL_ENTRY)&_ZN9S20948C212v2Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N9S20948C18D1Ev,_ZTv0_n20_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn240_N9S20948C18D1Ev,_ZThn140_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20948C18D0Ev,_ZTv0_n20_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn240_N9S20948C18D0Ev,_ZThn140_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C10__9S20948C18__9S20948C23[] = {
  ABISELECT(-240,-140),
  0,
  ABISELECT(-272,-152),
  ABISELECT(-240,-140),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C18D1Ev,_ZTv0_n20_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C18D0Ev,_ZTv0_n20_N9S20948C18D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn80_N9S20948C18D1Ev,_ZThn52_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn80_N9S20948C18D0Ev,_ZThn52_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C139S20948C21__9S20948C18__9S20948C23[] = {
  ABISELECT(-112,-64),
  ABISELECT(136,72),
  0,
  ABISELECT(-80,-52),
  ABISELECT(96,52),
  ABISELECT(-80,-52),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn144_N9S20948C18D1Ev,_ZThn84_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn144_N9S20948C18D0Ev,_ZThn84_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C139S20948C21__A3__9S20948C18__9S20948C23[] = {
  ABISELECT(-176,-96),
  ABISELECT(72,40),
  ABISELECT(72,40),
  ABISELECT(-144,-84),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S20948C18D1Ev,_ZThn84_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S20948C18D0Ev,_ZThn84_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn160_N9S20948C18D1Ev,_ZThn96_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn160_N9S20948C18D0Ev,_ZThn96_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C21__A4__9S20948C18__9S20948C23[] = {
  ABISELECT(56,28),
  ABISELECT(56,28),
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S20948C18D1Ev,_ZThn96_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S20948C18D0Ev,_ZThn96_N9S20948C18D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn256_N9S20948C18D1Ev,_ZThn148_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn256_N9S20948C18D0Ev,_ZThn148_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C13__A1__9S20948C18__9S20948C23[] = {
  ABISELECT(-288,-160),
  ABISELECT(-40,-24),
  ABISELECT(-176,-96),
  ABISELECT(-256,-148),
  ABISELECT(-80,-44),
  ABISELECT(-256,-148),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev),
};
extern void ABISELECT(_ZTvn32_n32_N9S20948C18D1Ev,_ZTvn16_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N9S20948C18D0Ev,_ZTvn16_n16_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt9S20948C13__A2__9S20948C18__9S20948C23[] = {
  ABISELECT(-288,-164),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N9S20948C18D1Ev,_ZTvn16_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N9S20948C18D0Ev,_ZTvn16_n16_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn64_n32_N9S20948C18D1Ev,_ZTvn32_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZTvn64_n32_N9S20948C18D0Ev,_ZTvn32_n16_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C13__A4__9S20948C18__9S20948C23[] = {
  ABISELECT(-352,-192),
  ABISELECT(-104,-56),
  ABISELECT(-104,-56),
  ABISELECT(-320,-180),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n32_N9S20948C18D1Ev,_ZTvn32_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n32_N9S20948C18D0Ev,_ZTvn32_n16_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C20D1Ev();
extern void _ZN9S20948C20D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C20__9S20948C23[] = {
  ABISELECT(-240,-132),
  ABISELECT(8,4),
  ABISELECT(-32,-16),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C20D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C20D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C20__9S20948C23[] = {
  ABISELECT(-248,-136),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C20__9S20948C23[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20948C20D1Ev,_ZTv0_n12_N9S20948C20D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C20D0Ev,_ZTv0_n12_N9S20948C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C20__9S20948C23[] = {
  ABISELECT(32,16),
  ABISELECT(32,16),
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C20D1Ev,_ZTv0_n12_N9S20948C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C20D0Ev,_ZTv0_n12_N9S20948C20D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn8_N9S20948C20D1Ev,_ZThn4_N9S20948C20D1Ev)();
extern void ABISELECT(_ZThn8_N9S20948C20D0Ev,_ZThn4_N9S20948C20D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C20__9S20948C23[] = {
  ABISELECT(-248,-136),
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S20948C20D1Ev,_ZThn4_N9S20948C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N9S20948C20D0Ev,_ZThn4_N9S20948C20D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C10D1Ev();
extern void _ZN9S20948C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C10__9S20948C23[] = {
  ABISELECT(-272,-152),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C10[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C5__A1__9S20948C23[] = {
  ABISELECT(96,52),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn96_N8S20948C5D1Ev,_ZThn52_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn96_N8S20948C5D0Ev,_ZThn52_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C5__A1__9S20948C23[] = {
  ABISELECT(-96,-52),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void _ZN9S20948C13D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
extern void _ZN9S20948C13D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C13__A1__9S20948C23[] = {
  ABISELECT(-288,-160),
  ABISELECT(-40,-24),
  ABISELECT(-176,-96),
  0,
  ABISELECT(-80,-44),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void _ZN9S20948C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
extern void _ZN9S20948C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C149S20948C13__A1__9S20948C23[] = {
  ABISELECT(-40,-24),
  ABISELECT(-176,-96),
  0,
  ABISELECT(-80,-44),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C149S20948C13__A1__9S20948C23[] = {
  ABISELECT(176,96),
  ABISELECT(96,52),
  ABISELECT(176,96),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C149S20948C13__A1__9S20948C23[] = {
  ABISELECT(80,44),
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C149S20948C13__A1__9S20948C23[] = {
  0,
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C13__A4__9S20948C23[] = {
  ABISELECT(-352,-192),
  ABISELECT(-104,-56),
  ABISELECT(-104,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C13__A5__9S20948C23[] = {
  ABISELECT(-104,-56),
  ABISELECT(-104,-56),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C13__A5__9S20948C23[] = {
  0,
  ABISELECT(104,56),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C13__A4__9S20948C23[] = {
  0,
  ABISELECT(104,56),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C13__A1__9S20948C23[] = {
  ABISELECT(176,96),
  ABISELECT(96,52),
  ABISELECT(176,96),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C13__A1__9S20948C23[] = {
  ABISELECT(80,44),
  ABISELECT(80,44),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C13__A1__9S20948C23[] = {
  0,
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C13__A1__9S20948C23[] = {
  ABISELECT(-352,-192),
  ABISELECT(-104,-56),
  ABISELECT(-104,-56),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev),
};
static  VTT_ENTRY vtt_S20948C23[] = {
  {&(_ZTV9S20948C23[14]),  14,139},
  {&(_ZTV9S20948C23[14]),  14,139},
  {&(_ZTV9S20948C23[107]),  107,139},
  {&(_ZTV9S20948C23[32]),  32,139},
  {&(_ZTV9S20948C23[90]),  90,139},
  {&(_ZTV9S20948C23[37]),  37,139},
  {&(_ZTV9S20948C23[99]),  99,139},
  {&(_ZTV9S20948C23[107]),  107,139},
  {&(_ZTV9S20948C23[43]),  43,139},
  {&(_ZTV9S20948C23[55]),  55,139},
  {&(_ZTV9S20948C23[115]),  115,139},
  {&(_ZTV9S20948C23[66]),  66,139},
  {&(_ZTV9S20948C23[66]),  66,139},
  {&(_ZTV9S20948C23[70]),  70,139},
  {&(_ZTV9S20948C23[77]),  77,139},
  {&(_ZTV9S20948C23[84]),  84,139},
  {&(_ZTV9S20948C23[125]),  125,139},
  {&(_ZTV9S20948C23[129]),  129,139},
  {&(_ZTV9S20948C23[136]),  136,139},
  {&(_tg__ZTV9S20948C18__9S20948C23[11]),  11,14},
  {&(_tg__ZTV9S20948C199S20948C18__9S20948C23[6]),  6,8},
  {&(_tg__ZTV8S20948C49S20948C199S20948C18__9S20948C23[4]),  4,6},
  {&(_tg__ZTV8S20948C58S20948C49S20948C199S20948C18__9S20948C23[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C58S20948C49S20948C199S20948C18__9S20948C23[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C49S20948C199S20948C18__9S20948C23[3]),  3,5},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C199S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C199S20948C18__9S20948C23[3]),  3,5},
  {&(_tg__ZTV9S20948C20__9S20948C199S20948C18__9S20948C23[7]),  7,10},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C199S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C169S20948C18__A1__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C18__A1__9S20948C23[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C18__A1__9S20948C23[3]),  3,4},
  {&(_tg__ZTV11S20948C9_nt__9S20948C169S20948C18__A1__9S20948C23[3]),  3,4},
  {&(_tg__ZTV9S20948C219S20948C18__9S20948C23[9]),  9,13},
  {&(_tg__ZTV9S20948C169S20948C219S20948C18__A2__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C219S20948C18__A2__9S20948C23[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C219S20948C18__A2__9S20948C23[3]),  3,4},
  {&(_tg__ZTV11S20948C9_nt__9S20948C169S20948C219S20948C18__A2__9S20948C23[3]),  3,4},
  {&(_tg__ZTV9S20948C139S20948C219S20948C18__9S20948C23[7]),  7,9},
  {&(_tg__ZTV9S20948C149S20948C139S20948C219S20948C18__9S20948C23[6]),  6,8},
  {&(_tg__ZTV9S20948C149S20948C139S20948C219S20948C18__9S20948C23[6]),  6,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C149S20948C139S20948C219S20948C18__9S20948C23[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C149S20948C139S20948C219S20948C18__9S20948C23[3]),  3,4},
  {&(_tg__ZTV9S20948C169S20948C139S20948C219S20948C18__A3__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C139S20948C219S20948C18__A3__9S20948C23[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C139S20948C219S20948C18__A3__9S20948C23[3]),  3,4},
  {&(_tg__ZTV11S20948C9_nt__9S20948C169S20948C139S20948C219S20948C18__A3__9S20948C23[3]),  3,4},
  {&(_tg__ZTV9S20948C139S20948C219S20948C18__9S20948C23[7]),  7,9},
  {&(_tg__ZTV11S20948C7_nt__9S20948C139S20948C219S20948C18__9S20948C23[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C139S20948C219S20948C18__9S20948C23[3]),  3,4},
  {&(_tg__ZTV9S20948C16__9S20948C139S20948C219S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C219S20948C18__A4__9S20948C23[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C219S20948C18__A4__9S20948C23[3]),  3,4},
  {&(_tg__ZTV9S20948C10__9S20948C219S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV11S20948C9_nt__A1__9S20948C219S20948C18__9S20948C23[3]),  3,4},
  {&(_tg__ZTV9S20948C13__9S20948C219S20948C18__9S20948C23[7]),  7,9},
  {&(_tg__ZTV9S20948C13__9S20948C219S20948C18__9S20948C23[7]),  7,9},
  {&(_tg__ZTV11S20948C7_nt__9S20948C219S20948C18__9S20948C23[3]),  3,5},
  {&(_tg__ZTV9S20948C169S20948C13__A1__9S20948C219S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C17__A2__9S20948C219S20948C18__9S20948C23[4]),  4,7},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C18__9S20948C23[3]),  3,5},
  {&(_tg__ZTV9S20948C20__9S20948C18__9S20948C23[7]),  7,10},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C16__A1__9S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C21__9S20948C18__9S20948C23[9]),  9,13},
  {&(_tg__ZTV9S20948C10__9S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C139S20948C21__9S20948C18__9S20948C23[7]),  7,9},
  {&(_tg__ZTV9S20948C139S20948C21__9S20948C18__9S20948C23[7]),  7,9},
  {&(_tg__ZTV9S20948C169S20948C139S20948C21__A3__9S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C21__A4__9S20948C18__9S20948C23[4]),  4,7},
  {&(_tg__ZTV9S20948C13__A1__9S20948C18__9S20948C23[7]),  7,9},
  {&(_tg__ZTV11S20948C7_nt9S20948C13__A2__9S20948C18__9S20948C23[2]),  2,4},
  {&(_tg__ZTV9S20948C169S20948C13__A4__9S20948C18__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C20__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C20__9S20948C23[4]),  4,7},
  {&(_tg__ZTV9S20948C179S20948C169S20948C20__9S20948C23[4]),  4,7},
  {&(_tg__ZTV9S20948C169S20948C20__9S20948C23[5]),  5,8},
  {&(_tg__ZTV11S20948C7_nt__9S20948C20__9S20948C23[3]),  3,5},
  {&(_tg__ZTV9S20948C16__9S20948C20__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C16__9S20948C20__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C10__9S20948C23[3]),  3,6},
  {&(_tg__ZTV8S20948C5__A1__9S20948C23[3]),  3,5},
  {&(_tg__ZTV11S20948C7_nt__8S20948C5__A1__9S20948C23[3]),  3,5},
  {&(_tg__ZTV9S20948C13__A1__9S20948C23[7]),  7,9},
  {&(_tg__ZTV9S20948C149S20948C13__A1__9S20948C23[6]),  6,8},
  {&(_tg__ZTV8S20948C5__9S20948C149S20948C13__A1__9S20948C23[4]),  4,6},
  {&(_tg__ZTV11S20948C7_nt__9S20948C149S20948C13__A1__9S20948C23[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C149S20948C13__A1__9S20948C23[3]),  3,4},
  {&(_tg__ZTV9S20948C169S20948C13__A4__9S20948C23[5]),  5,8},
  {&(_tg__ZTV9S20948C179S20948C169S20948C13__A5__9S20948C23[4]),  4,7},
  {&(_tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C13__A5__9S20948C23[3]),  3,4},
  {&(_tg__ZTV11S20948C9_nt__9S20948C169S20948C13__A4__9S20948C23[3]),  3,4},
  {&(_tg__ZTV8S20948C5__9S20948C13__A1__9S20948C23[4]),  4,6},
  {&(_tg__ZTV11S20948C7_nt__9S20948C13__A1__9S20948C23[3]),  3,5},
  {&(_tg__ZTV11S20948C9_nt__9S20948C13__A1__9S20948C23[3]),  3,4},
  {&(_tg__ZTV9S20948C16__9S20948C13__A1__9S20948C23[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S20948C23[];
extern  VTBL_ENTRY _ZTV9S20948C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C23[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N9S20948C18D0Ev,_ZThn148_N9S20948C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S20948C18D0Ev,_ZThn52_N9S20948C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn256_N9S20948C18D1Ev,_ZThn148_N9S20948C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn80_N9S20948C18D1Ev,_ZThn52_N9S20948C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C18D0Ev,_ZTv0_n20_N9S20948C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N9S20948C18D0Ev,_ZThn140_N9S20948C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C18D1Ev,_ZTv0_n20_N9S20948C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N9S20948C18D1Ev,_ZThn140_N9S20948C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C18D0Ev,_ZTv0_n28_N9S20948C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S20948C18D0Ev,_ZThn120_N9S20948C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C18D1Ev,_ZTv0_n28_N9S20948C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S20948C18D1Ev,_ZThn120_N9S20948C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C18D0Ev,_ZTv0_n12_N9S20948C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S20948C18D0Ev,_ZThn104_N9S20948C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C18D1Ev,_ZTv0_n12_N9S20948C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S20948C18D1Ev,_ZThn104_N9S20948C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C21D0Ev,_ZThn64_N9S20948C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C21D1Ev,_ZThn64_N9S20948C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S20948C21D0Ev,_ZThn12_N9S20948C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N9S20948C21D1Ev,_ZThn12_N9S20948C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S20948C21D0Ev,_ZThn100_N9S20948C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S20948C21D1Ev,_ZThn100_N9S20948C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S20948C13D0Ev,_ZThn52_N9S20948C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S20948C13D1Ev,_ZThn52_N9S20948C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S20948C14D0Ev,_ZThn52_N9S20948C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N9S20948C14D1Ev,_ZThn52_N9S20948C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev), // 
  (VTBL_ENTRY)_ZN9S20948C14D0Ev,
  (VTBL_ENTRY)_ZN9S20948C14D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev), // 
  (VTBL_ENTRY)_ZN9S20948C14D1Ev,
  (VTBL_ENTRY)_ZN9S20948C14D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev), // 
  (VTBL_ENTRY)_ZN9S20948C13D0Ev,
  (VTBL_ENTRY)_ZN9S20948C13D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev), // 
  (VTBL_ENTRY)_ZN9S20948C13D1Ev,
  (VTBL_ENTRY)_ZN9S20948C13D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S20948C19D0Ev,_ZThn120_N9S20948C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S20948C19D1Ev,_ZThn120_N9S20948C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S20948C19D0Ev,_ZThn104_N9S20948C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N9S20948C19D1Ev,_ZThn104_N9S20948C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S20948C4D0Ev,_ZThn104_N8S20948C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S20948C4D1Ev,_ZThn104_N8S20948C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S20948C5D0Ev,_ZThn52_N8S20948C5D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S20948C5D0Ev,_ZThn104_N8S20948C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S20948C5D1Ev,_ZThn52_N8S20948C5D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn176_N8S20948C5D1Ev,_ZThn104_N8S20948C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C23D0Ev,_ZTv0_n20_N9S20948C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn272_N9S20948C23D0Ev,_ZThn152_N9S20948C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N9S20948C23D1Ev,_ZTv0_n20_N9S20948C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn272_N9S20948C23D1Ev,_ZThn152_N9S20948C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C23D0Ev,_ZTv0_n28_N9S20948C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N9S20948C23D0Ev,_ZThn132_N9S20948C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20948C23D1Ev,_ZTv0_n28_N9S20948C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn240_N9S20948C23D1Ev,_ZThn132_N9S20948C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C23D0Ev,_ZTv0_n12_N9S20948C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S20948C23D0Ev,_ZThn116_N9S20948C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S20948C23D1Ev,_ZTv0_n12_N9S20948C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S20948C23D1Ev,_ZThn116_N9S20948C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C23D0Ev,_ZTv0_n16_N9S20948C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn288_N9S20948C23D0Ev,_ZThn160_N9S20948C23D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C23D0Ev,_ZThn64_N9S20948C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20948C23D1Ev,_ZTv0_n16_N9S20948C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn288_N9S20948C23D1Ev,_ZThn160_N9S20948C23D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn112_N9S20948C23D1Ev,_ZThn64_N9S20948C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20948C23D0Ev,_ZTv0_n48_N9S20948C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S20948C23D0Ev,_ZThn12_N9S20948C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n96_N9S20948C23D1Ev,_ZTv0_n48_N9S20948C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N9S20948C23D1Ev,_ZThn12_N9S20948C23D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20948C23 = {  "S20948C23", // class name
  bases_S20948C23, 51,
  &(vtc_S20948C23[0]), // expected_vtbl_contents
  &(vtt_S20948C23[0]), // expected_vtt_contents
  ABISELECT(368,204), // object size
  NSPAIRA(_ZTI9S20948C23),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20948C23),139, //virtual function table var
  14, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20948C23),98, //virtual table table var
  32, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20948C2  : virtual S20948C3 , S20948C12 , S20948C18 , S20948C22 , virtual S20948C23 {
  ~S20948C2(); // tgen
  S20948C2(); // tgen
};
//SIG(-1 S20948C2) C1{ VBC2{ VBC3{ BC4{ BC5{ m} VBC6{ vd m FD} vd} BC7{ m Fc[7]} BC8{ v1} VBC5} VBC9{ BC8 VBC10{ m} vd Fi:23} VBC8 BC11{ BC7 VBC4 VBC5 vd} BC12{ BC13{ BC5 BC14{ BC10 FC5 FC10} VBC4 VBC8 Fp} BC14 BC6 BC15{ BC16{ VBC8 vd} VBC5 vd FC7}} vd} BC11 BC17{ VBC14 BC18{ VBC8 BC3 VBC19{ BC5 VBC6 BC8 BC15 vd Fi} BC7 vd Fi} BC15 BC20{ VBC9 BC15 BC12 BC16 vd v2} VBC12 vd v3} BC21{ VBC14 VBC3 BC7 BC8 Fp} VBC22{ VBC23{ BC8} VBC8 VBC17 Fl[2]}}


S20948C2 ::~S20948C2(){ note_dtor("S20948C2", this);} // tgen
S20948C2 ::S20948C2(){ note_ctor("S20948C2", this);} // tgen

static void Test_S20948C2()
{
  extern Class_Descriptor cd_S20948C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(45,102)];
    init_test(&cd_S20948C2, buf);
    S20948C2 *dp, &lv = *(dp=new (buf) S20948C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(704,404), "sizeof(S20948C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20948C2)");
    /*is_ambiguous_... S20948C2::S20948C4 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C5*)(S20948C4*), ABISELECT(304,184), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C4 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*)(S20948C4*), ABISELECT(336,200), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C5 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*), ABISELECT(336,200), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(336,200), "S20948C2");
    check_base_class_offset(lv, (S20948C7_nt*)(S20948C20*), ABISELECT(336,200), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C5*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(336,200), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C4 */ AMB_check_base_class_offset(lv, (S20948C5*)(S20948C4*), ABISELECT(304,184), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C4 */ AMB_check_base_class_offset(lv, (S20948C8*)(S20948C4*), ABISELECT(312,188), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C4 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C4*), ABISELECT(320,196), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C4 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C4*), 0, "S20948C2");
    /*is_ambiguous_... S20948C12::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C12*)(S20948C3*), 0, "S20948C2");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C13*)(S20948C3*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C12 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C12*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C4*)(S20948C19*)(S20948C18*), 0, "S20948C2");
    check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C20*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C18*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C21*)(S20948C18*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C13*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C4*)(S20948C19*)(S20948C18*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C18*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C21*)(S20948C18*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), 0, "S20948C2");
    check_base_class_offset(lv, (S20948C4*)(S20948C3*), ABISELECT(304,184), "S20948C2");
    check_base_class_offset(lv, (S20948C4*)(S20948C22*), ABISELECT(304,184), "S20948C2");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C10*), ABISELECT(368,216), "S20948C2");
    check_base_class_offset(lv, (S9624C39*)(S20948C10*), 0, "S20948C2");
    check_base_class_offset(lv, (S20948C10*)(S20948C3*), ABISELECT(368,216), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C10*)(S20948C21*)(S20948C18*), ABISELECT(368,216), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C10*)(S20948C21*)(S20948C18*), ABISELECT(368,216), "S20948C2");
    /*is_ambiguous_... S20948C3::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C3*), ABISELECT(288,172), "S20948C2");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*)(S20948C13*)(S20948C3*), ABISELECT(288,172), "S20948C2");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C13*)(S20948C3*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C19*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C20*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C21*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C21*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*)(S20948C13*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C13*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C23::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C23*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C19*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C21*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C17*)(S20948C21*)(S20948C18*), ABISELECT(288,172), "S20948C2");
    check_base_class_offset(lv, (S20948C8*)(S20948C12*)(S20948C3*), ABISELECT(216,132), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C5 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C5*), ABISELECT(208,128), "S20948C2");
    check_base_class_offset(lv, (S20948C5*)(S20948C12*)(S20948C3*), ABISELECT(208,128), "S20948C2");
    check_base_class_offset(lv, (S20948C5*)(S20948C14*)(S20948C13*)(S20948C3*), ABISELECT(208,128), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C12 */ AMB_check_base_class_offset(lv, (S20948C5*)(S20948C12*), ABISELECT(208,128), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C5*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(208,128), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C5*)(S20948C14*)(S20948C13*), ABISELECT(208,128), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C5*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(208,128), "S20948C2");
    check_base_class_offset(lv, (S20948C12*)(S20948C3*), ABISELECT(208,128), "S20948C2");
    /*is_ambiguous_... S20948C14::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*)(S20948C13*)(S20948C3*), ABISELECT(232,144), "S20948C2");
    check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*)(S20948C13*)(S20948C3*), ABISELECT(233,145), "S20948C2");
    check_base_class_offset(lv, (S20948C15*)(S20948C14*)(S20948C13*)(S20948C3*), ABISELECT(233,145), "S20948C2");
    check_base_class_offset(lv, (S20948C14*)(S20948C13*)(S20948C3*), ABISELECT(224,140), "S20948C2");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C13*)(S20948C3*), ABISELECT(248,152), "S20948C2");
    /*is_ambiguous_... S20948C13::S20948C15 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C13*)(S20948C3*), ABISELECT(248,152), "S20948C2");
    /*is_ambiguous_... S20948C13::S20948C7_nt */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C13*)(S20948C3*), ABISELECT(256,156), "S20948C2");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C13*)(S20948C3*), ABISELECT(288,172), "S20948C2");
    check_base_class_offset(lv, (S20948C16*)(S20948C13*)(S20948C3*), ABISELECT(288,172), "S20948C2");
    check_base_class_offset(lv, (S20948C13*)(S20948C3*), ABISELECT(224,140), "S20948C2");
    check_base_class_offset(lv, (S20948C3*), ABISELECT(208,128), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C12 */ AMB_check_base_class_offset(lv, (S20948C8*)(S20948C12*), ABISELECT(8,4), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C12 */ AMB_check_base_class_offset(lv, (S20948C12*), 0, "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C15 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*), ABISELECT(379,223), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C18*), ABISELECT(379,223), "S20948C2");
    check_base_class_offset(lv, (S20948C15*)(S20948C22*), ABISELECT(379,223), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C18*), ABISELECT(379,223), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C5*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(16,12), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C5*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(16,12), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C8*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(24,16), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(32,24), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(16,12), "S20948C2");
    /*is_ambiguous_... S20948C20::S9624C48 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C20*), ABISELECT(384,228), "S20948C2");
    /*is_ambiguous_... S20948C20::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C20*), ABISELECT(384,228), "S20948C2");
    check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C20*), ABISELECT(392,232), "S20948C2");
    check_base_class_offset(lv, (S20948C16*)(S20948C20*), ABISELECT(392,232), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C20*)(S20948C19*)(S20948C18*), ABISELECT(384,228), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C20*)(S20948C19*)(S20948C18*), ABISELECT(384,228), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C8*)(S20948C19*)(S20948C18*), ABISELECT(40,28), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C19*)(S20948C18*), ABISELECT(16,12), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C18*), ABISELECT(56,40), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C18*), ABISELECT(56,40), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C21*)(S20948C18*), ABISELECT(80,52), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C21*)(S20948C18*), ABISELECT(80,52), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(104,68), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(105,69), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(105,69), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(96,64), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(120,76), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(120,76), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(128,80), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(160,96), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(160,96), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(96,64), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C21*)(S20948C18*), ABISELECT(176,108), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C21*)(S20948C18*), ABISELECT(80,52), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*)(S20948C13*), ABISELECT(424,252), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*)(S20948C13*), ABISELECT(425,253), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C14*)(S20948C13*), ABISELECT(425,253), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C14*)(S20948C13*), ABISELECT(416,248), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C13*), ABISELECT(440,260), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C13*), ABISELECT(440,260), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C13*), ABISELECT(448,264), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C13*), ABISELECT(480,280), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C13 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C13*), ABISELECT(480,280), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C13*)(S20948C18*), ABISELECT(416,248), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C13*)(S20948C18*), ABISELECT(416,248), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C18*), ABISELECT(16,12), "S20948C2");
    /*is_ambiguous_... S20948C22::S20948C8 */ AMB_check_base_class_offset(lv, (S20948C8*)(S20948C22*), ABISELECT(192,116), "S20948C2");
    /*is_ambiguous_... S20948C22::S20948C9_nt */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C22*), ABISELECT(184,112), "S20948C2");
    check_base_class_offset(lv, (S20948C22*), ABISELECT(184,112), "S20948C2");
    check_base_class_offset(lv, (S20948C9_nt*)(S20948C24_nt*), ABISELECT(496,292), "S20948C2");
    check_base_class_offset(lv, (S20948C24_nt*)(S20948C23*), ABISELECT(496,292), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C5*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(528,304), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C5*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(528,304), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C8*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(536,308), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C9_nt*)(S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(544,316), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C4*)(S20948C19*)(S20948C18*), ABISELECT(528,304), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C8*)(S20948C19*)(S20948C18*), ABISELECT(552,320), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C19*)(S20948C18*), ABISELECT(528,304), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C18*), ABISELECT(568,332), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C18*), ABISELECT(568,332), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C21*)(S20948C18*), ABISELECT(592,344), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C21*)(S20948C18*), ABISELECT(592,344), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C48*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(616,360), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(617,361), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(617,361), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C14*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(608,356), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S9624C39*)(S20948C15*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(632,368), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C15*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(632,368), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C7_nt*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(640,372), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(672,388), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C16*)(S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(672,388), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C13*)(S20948C21*)(S20948C18*), ABISELECT(608,356), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C17*)(S20948C21*)(S20948C18*), ABISELECT(688,400), "S20948C2");
    /*is_ambiguous_... S20948C2::S20948C18 */ AMB_check_base_class_offset(lv, (S20948C21*)(S20948C18*), ABISELECT(592,344), "S20948C2");
    check_base_class_offset(lv, (S20948C18*)(S20948C23*), ABISELECT(528,304), "S20948C2");
    check_base_class_offset(lv, (S20948C23*), ABISELECT(496,292), "S20948C2");
    test_class_info(&lv, &cd_S20948C2);
    dp->~S20948C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20948C2(Test_S20948C2, "S20948C2", ABISELECT(704,404));

#else // __cplusplus

extern void _ZN8S20948C2C1Ev();
extern void _ZN8S20948C2D1Ev();
Name_Map name_map_S20948C2[] = {
  NSPAIR(_ZN8S20948C2C1Ev),
  NSPAIR(_ZN8S20948C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C4;
extern VTBL_ENTRY _ZTI8S20948C4[];
extern  VTBL_ENTRY _ZTV8S20948C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C4[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C10;
extern VTBL_ENTRY _ZTI9S20948C10[];
extern  VTBL_ENTRY _ZTV9S20948C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C10[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C12;
extern VTBL_ENTRY _ZTI9S20948C12[];
extern  VTBL_ENTRY _ZTV9S20948C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C12[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C13;
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
extern Class_Descriptor cd_S20948C3;
extern VTBL_ENTRY _ZTI8S20948C3[];
extern  VTBL_ENTRY _ZTV8S20948C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C3[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C12;
extern VTBL_ENTRY _ZTI9S20948C12[];
extern  VTBL_ENTRY _ZTV9S20948C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C12[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C4;
extern VTBL_ENTRY _ZTI8S20948C4[];
extern  VTBL_ENTRY _ZTV8S20948C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C4[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C20;
extern VTBL_ENTRY _ZTI9S20948C20[];
extern  VTBL_ENTRY _ZTV9S20948C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C20[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C19;
extern VTBL_ENTRY _ZTI9S20948C19[];
extern  VTBL_ENTRY _ZTV9S20948C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C19[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C13;
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C21;
extern VTBL_ENTRY _ZTI9S20948C21[];
extern  VTBL_ENTRY _ZTV9S20948C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C21[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C13;
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
extern Class_Descriptor cd_S20948C18;
extern VTBL_ENTRY _ZTI9S20948C18[];
extern  VTBL_ENTRY _ZTV9S20948C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C18[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C22;
extern VTBL_ENTRY _ZTI9S20948C22[];
extern  VTBL_ENTRY _ZTV9S20948C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C22[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C24_nt;
extern VTBL_ENTRY _ZTI12S20948C24_nt[];
extern  VTBL_ENTRY _ZTV12S20948C24_nt[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S20948C5;
extern VTBL_ENTRY _ZTI8S20948C5[];
extern  VTBL_ENTRY _ZTV8S20948C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C5[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C9_nt;
extern VTBL_ENTRY _ZTI11S20948C9_nt[];
extern  VTBL_ENTRY _ZTV11S20948C9_nt[];
extern Class_Descriptor cd_S20948C4;
extern VTBL_ENTRY _ZTI8S20948C4[];
extern  VTBL_ENTRY _ZTV8S20948C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20948C4[];
extern Class_Descriptor cd_S20948C8;
extern VTBL_ENTRY _ZTI8S20948C8[];
extern Class_Descriptor cd_S20948C19;
extern VTBL_ENTRY _ZTI9S20948C19[];
extern  VTBL_ENTRY _ZTV9S20948C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C19[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S9624C48;
extern VTBL_ENTRY _ZTI8S9624C48[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C14;
extern VTBL_ENTRY _ZTI9S20948C14[];
extern  VTBL_ENTRY _ZTV9S20948C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C14[];
extern Class_Descriptor cd_S9624C39;
extern VTBL_ENTRY _ZTI8S9624C39[];
extern Class_Descriptor cd_S20948C15;
extern VTBL_ENTRY _ZTI9S20948C15[];
extern Class_Descriptor cd_S20948C7_nt;
extern VTBL_ENTRY _ZTI11S20948C7_nt[];
extern  VTBL_ENTRY _ZTV11S20948C7_nt[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C16;
extern VTBL_ENTRY _ZTI9S20948C16[];
extern  VTBL_ENTRY _ZTV9S20948C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C16[];
extern Class_Descriptor cd_S20948C13;
extern VTBL_ENTRY _ZTI9S20948C13[];
extern  VTBL_ENTRY _ZTV9S20948C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C13[];
extern Class_Descriptor cd_S20948C17;
extern VTBL_ENTRY _ZTI9S20948C17[];
extern  VTBL_ENTRY _ZTV9S20948C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C17[];
extern Class_Descriptor cd_S20948C21;
extern VTBL_ENTRY _ZTI9S20948C21[];
extern  VTBL_ENTRY _ZTV9S20948C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C21[];
extern Class_Descriptor cd_S20948C18;
extern VTBL_ENTRY _ZTI9S20948C18[];
extern  VTBL_ENTRY _ZTV9S20948C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C18[];
extern Class_Descriptor cd_S20948C23;
extern VTBL_ENTRY _ZTI9S20948C23[];
extern  VTBL_ENTRY _ZTV9S20948C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20948C23[];
static Base_Class bases_S20948C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9624C48,    ABISELECT(304,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(336,200), //bcp->offset
    138, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    66, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20948C5,    ABISELECT(304,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    122, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20948C8,    ABISELECT(312,188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(320,196), //bcp->offset
    135, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    67, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S9624C48,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20948C4,    ABISELECT(304,184), //bcp->offset
    127, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    65, //bcp->index_in_construction_vtbl_array
    121, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S20948C9_nt,    ABISELECT(368,216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S9624C39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20948C10,    ABISELECT(368,216), //bcp->offset
    143, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    68, //bcp->index_in_construction_vtbl_array
    125, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S20948C9_nt,    ABISELECT(288,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    69, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S20948C8,    ABISELECT(216,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(208,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20948C5,    ABISELECT(208,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    70, //bcp->index_in_construction_vtbl_array
    126, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S20948C12,    ABISELECT(208,128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    97, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(232,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(233,145), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(233,145), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20948C14,    ABISELECT(224,140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    101, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(248,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(248,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(256,156), //bcp->offset
    115, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    72, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(288,172), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    106, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(288,172), //bcp->offset
    119, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    73, //bcp->index_in_construction_vtbl_array
    105, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20948C13,    ABISELECT(224,140), //bcp->offset
    106, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    71, //bcp->index_in_construction_vtbl_array
    100, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20948C3,    ABISELECT(208,128), //bcp->offset
    94, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    64, //bcp->index_in_construction_vtbl_array
    96, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20948C8,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20948C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    44, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9624C39,    ABISELECT(379,223), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(379,223), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    68, //immediately_derived
  0, 1},
  {&cd_S9624C48,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S20948C5,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    45, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20948C8,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(32,24), //bcp->offset
    33, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    46, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20948C4,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    47, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(384,228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(384,228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(392,232), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    130, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(392,232), //bcp->offset
    161, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    76, //bcp->index_in_construction_vtbl_array
    129, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20948C20,    ABISELECT(384,228), //bcp->offset
    151, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    75, //bcp->index_in_construction_vtbl_array
    128, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    41, //immediately_derived
  0, 1},
  {&cd_S20948C8,    ABISELECT(40,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20948C19,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    48, //init_seq
    68, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(56,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    49, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(56,40), //bcp->offset
    36, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    77, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    50, //init_seq
    68, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(80,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    51, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(80,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    52, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(104,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(105,69), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    48, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(105,69), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S20948C14,    ABISELECT(96,64), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    53, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(120,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(120,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(128,80), //bcp->offset
    66, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    54, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(160,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    55, //init_seq
    54, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(160,96), //bcp->offset
    70, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    80, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    56, //init_seq
    55, //immediately_derived
  0, 0},
  {&cd_S20948C13,    ABISELECT(96,64), //bcp->offset
    57, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    79, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    57, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(176,108), //bcp->offset
    78, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    81, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    58, //init_seq
    57, //immediately_derived
  0, 0},
  {&cd_S20948C21,    ABISELECT(80,52), //bcp->offset
    44, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    78, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    59, //init_seq
    68, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(424,252), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    61, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(425,253), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    60, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(425,253), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    61, //immediately_derived
  0, 0},
  {&cd_S20948C14,    ABISELECT(416,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    137, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(440,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    63, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(440,260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(448,264), //bcp->offset
    178, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    83, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(480,280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    142, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    66, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(480,280), //bcp->offset
    182, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    84, //bcp->index_in_construction_vtbl_array
    141, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    67, //immediately_derived
  0, 0},
  {&cd_S20948C13,    ABISELECT(416,248), //bcp->offset
    169, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    82, //bcp->index_in_construction_vtbl_array
    136, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    68, //immediately_derived
  0, 1},
  {&cd_S20948C18,    ABISELECT(16,12), //bcp->offset
    19, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    74, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    60, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C8,    ABISELECT(192,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    71, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(184,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    61, //init_seq
    71, //immediately_derived
  0, 0},
  {&cd_S20948C22,    ABISELECT(184,112), //bcp->offset
    85, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    85, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    62, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20948C9_nt,    ABISELECT(496,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    73, //immediately_derived
  0, 0},
  {&cd_S20948C24_nt,    ABISELECT(496,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    87, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    98, //immediately_derived
  0, 1},
  {&cd_S9624C48,    ABISELECT(528,304), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    75, //immediately_derived
  0, 0},
  {&cd_S20948C5,    ABISELECT(528,304), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    171, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    78, //immediately_derived
  0, 0},
  {&cd_S20948C8,    ABISELECT(536,308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    78, //immediately_derived
  0, 0},
  {&cd_S20948C9_nt,    ABISELECT(544,316), //bcp->offset
    226, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    89, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    78, //immediately_derived
  0, 0},
  {&cd_S20948C4,    ABISELECT(528,304), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    170, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    80, //immediately_derived
  0, 0},
  {&cd_S20948C8,    ABISELECT(552,320), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    80, //immediately_derived
  0, 0},
  {&cd_S20948C19,    ABISELECT(528,304), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    169, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    97, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(568,332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    179, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    82, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(568,332), //bcp->offset
    229, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    90, //bcp->index_in_construction_vtbl_array
    178, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    97, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(592,344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    184, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    84, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(592,344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    183, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    96, //immediately_derived
  0, 0},
  {&cd_S9624C48,    ABISELECT(616,360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    88, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(617,361), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    87, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(617,361), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    88, //immediately_derived
  0, 0},
  {&cd_S20948C14,    ABISELECT(608,356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    188, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    94, //immediately_derived
  0, 0},
  {&cd_S9624C39,    ABISELECT(632,368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    90, //immediately_derived
  0, 0},
  {&cd_S20948C15,    ABISELECT(632,368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    94, //immediately_derived
  0, 0},
  {&cd_S20948C7_nt,    ABISELECT(640,372), //bcp->offset
    259, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    93, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    94, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(672,388), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    193, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    93, //immediately_derived
  0, 0},
  {&cd_S20948C16,    ABISELECT(672,388), //bcp->offset
    263, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    94, //bcp->index_in_construction_vtbl_array
    192, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    94, //immediately_derived
  0, 0},
  {&cd_S20948C13,    ABISELECT(608,356), //bcp->offset
    250, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    92, //bcp->index_in_construction_vtbl_array
    187, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    96, //immediately_derived
  0, 0},
  {&cd_S20948C17,    ABISELECT(688,400), //bcp->offset
    271, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    95, //bcp->index_in_construction_vtbl_array
    200, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    96, //immediately_derived
  0, 0},
  {&cd_S20948C21,    ABISELECT(592,344), //bcp->offset
    237, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    91, //bcp->index_in_construction_vtbl_array
    182, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    97, //immediately_derived
  0, 0},
  {&cd_S20948C18,    ABISELECT(528,304), //bcp->offset
    208, //bcp->virtual_function_table_offset
    15, //num_negative_vtable_entries(t, bcp)
    88, //bcp->index_in_construction_vtbl_array
    168, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    98, //immediately_derived
  0, 1},
  {&cd_S20948C23,    ABISELECT(496,292), //bcp->offset
    190, //bcp->virtual_function_table_offset
    15, //num_negative_vtable_entries(t, bcp)
    86, //bcp->index_in_construction_vtbl_array
    149, //bcp->base_subarray_index_in_construction_vtbl_array
    43, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20948C2[];
extern void ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev)();
extern void _ZN8S20948C2D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev)();
extern void _ZN8S20948C2D0Ev() __attribute__((weak));
extern void ABISELECT(_ZThn16_N8S20948C2D1Ev,_ZThn12_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn16_N8S20948C2D0Ev,_ZThn12_N8S20948C2D0Ev)();
extern void _ZN9S20948C182v3Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn56_N8S20948C2D1Ev,_ZThn40_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn56_N8S20948C2D0Ev,_ZThn40_N8S20948C2D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn80_N8S20948C2D1Ev,_ZThn52_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn80_N8S20948C2D0Ev,_ZThn52_N8S20948C2D0Ev)();
extern void _ZN9S20948C212v2Ev();
extern void ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn96_N8S20948C2D1Ev,_ZThn64_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn96_N8S20948C2D0Ev,_ZThn64_N8S20948C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZThn128_N8S20948C2D1Ev,_ZThn80_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn128_N8S20948C2D0Ev,_ZThn80_N8S20948C2D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn160_N8S20948C2D1Ev,_ZThn96_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn160_N8S20948C2D0Ev,_ZThn96_N8S20948C2D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn176_N8S20948C2D1Ev,_ZThn108_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn176_N8S20948C2D0Ev,_ZThn108_N8S20948C2D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn184_N8S20948C2D1Ev,_ZThn112_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn184_N8S20948C2D0Ev,_ZThn112_N8S20948C2D0Ev)();
extern void ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn208_N8S20948C2D1Ev,_ZThn128_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn208_N8S20948C2D0Ev,_ZThn128_N8S20948C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn224_N8S20948C2D1Ev,_ZThn140_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn224_N8S20948C2D0Ev,_ZThn140_N8S20948C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn48_n32_N8S20948C2D1Ev,_ZTvn28_n16_N8S20948C2D1Ev)();
extern void ABISELECT(_ZTvn48_n32_N8S20948C2D0Ev,_ZTvn28_n16_N8S20948C2D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn80_n32_N8S20948C2D1Ev,_ZTvn44_n16_N8S20948C2D1Ev)();
extern void ABISELECT(_ZTvn80_n32_N8S20948C2D0Ev,_ZTvn44_n16_N8S20948C2D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S20948C2D1Ev,_ZTv0_n20_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn304_N8S20948C2D1Ev,_ZThn184_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20948C2D0Ev,_ZTv0_n20_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn304_N8S20948C2D0Ev,_ZThn184_N8S20948C2D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n24_N8S20948C2D1Ev,_ZTv0_n12_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn336_N8S20948C2D1Ev,_ZThn200_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C2D0Ev,_ZTv0_n12_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn336_N8S20948C2D0Ev,_ZThn200_N8S20948C2D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N8S20948C2D1Ev,_ZTv0_n20_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn368_N8S20948C2D1Ev,_ZThn216_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20948C2D0Ev,_ZTv0_n20_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn368_N8S20948C2D0Ev,_ZThn216_N8S20948C2D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n56_N8S20948C2D1Ev,_ZTv0_n28_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn384_N8S20948C2D1Ev,_ZThn228_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S20948C2D0Ev,_ZTv0_n28_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn384_N8S20948C2D0Ev,_ZThn228_N8S20948C2D0Ev)() __attribute__((weak));
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn8_n56_N8S20948C2D1Ev,_ZTvn4_n28_N8S20948C2D1Ev)();
extern void ABISELECT(_ZTvn8_n56_N8S20948C2D0Ev,_ZTvn4_n28_N8S20948C2D0Ev)();
extern void ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn416_N8S20948C2D1Ev,_ZThn248_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn416_N8S20948C2D0Ev,_ZThn248_N8S20948C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn32_n32_N8S20948C2D1Ev,_ZTvn16_n16_N8S20948C2D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N8S20948C2D0Ev,_ZTvn16_n16_N8S20948C2D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn64_n32_N8S20948C2D1Ev,_ZTvn32_n16_N8S20948C2D1Ev)();
extern void ABISELECT(_ZTvn64_n32_N8S20948C2D0Ev,_ZTvn32_n16_N8S20948C2D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n120_N8S20948C2D1Ev,_ZTv0_n60_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn496_N8S20948C2D1Ev,_ZThn292_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n120_N8S20948C2D0Ev,_ZTv0_n60_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn496_N8S20948C2D0Ev,_ZThn292_N8S20948C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S20948C2D1Ev,_ZTv0_n48_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn528_N8S20948C2D1Ev,_ZThn304_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n96_N8S20948C2D0Ev,_ZTv0_n48_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn528_N8S20948C2D0Ev,_ZThn304_N8S20948C2D0Ev)() __attribute__((weak));
extern void _ZN9S20948C182v3Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn40_n96_N8S20948C2D1Ev,_ZTvn28_n48_N8S20948C2D1Ev)();
extern void ABISELECT(_ZTvn40_n96_N8S20948C2D0Ev,_ZTvn28_n48_N8S20948C2D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn64_n96_N8S20948C2D1Ev,_ZTvn40_n48_N8S20948C2D1Ev)();
extern void ABISELECT(_ZTvn64_n96_N8S20948C2D0Ev,_ZTvn40_n48_N8S20948C2D0Ev)();
extern void _ZN9S20948C212v2Ev();
extern void ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev)();
extern void ABISELECT(_ZThn608_N8S20948C2D1Ev,_ZThn356_N8S20948C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev)();
extern void ABISELECT(_ZThn608_N8S20948C2D0Ev,_ZThn356_N8S20948C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn112_n96_N8S20948C2D1Ev,_ZTvn68_n48_N8S20948C2D1Ev)();
extern void ABISELECT(_ZTvn112_n96_N8S20948C2D0Ev,_ZTvn68_n48_N8S20948C2D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn144_n96_N8S20948C2D1Ev,_ZTvn84_n48_N8S20948C2D1Ev)();
extern void ABISELECT(_ZTvn144_n96_N8S20948C2D0Ev,_ZTvn84_n48_N8S20948C2D0Ev)();
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn160_n96_N8S20948C2D1Ev,_ZTvn96_n48_N8S20948C2D1Ev)();
extern void ABISELECT(_ZTvn160_n96_N8S20948C2D0Ev,_ZTvn96_n48_N8S20948C2D0Ev)();
static  VTBL_ENTRY vtc_S20948C2[] = {
  ABISELECT(528,304),
  ABISELECT(496,292),
  ABISELECT(496,292),
  ABISELECT(416,248),
  ABISELECT(384,228),
  ABISELECT(379,223),
  ABISELECT(288,172),
  0,
  ABISELECT(368,216),
  ABISELECT(304,184),
  ABISELECT(208,128),
  0,
  ABISELECT(208,128),
  0,
  ABISELECT(336,200),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev),
  ABISELECT(400,236),
  ABISELECT(192,116),
  ABISELECT(-16,-12),
  ABISELECT(352,204),
  ABISELECT(363,211),
  ABISELECT(368,216),
  ABISELECT(272,160),
  ABISELECT(-16,-12),
  ABISELECT(320,188),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S20948C2D1Ev,_ZThn12_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S20948C2D0Ev,_ZThn12_N8S20948C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20948C182v3Ev,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  ABISELECT(-56,-40),
  ABISELECT(232,132),
  ABISELECT(232,132),
  ABISELECT(-56,-40),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N8S20948C2D1Ev,_ZThn40_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N8S20948C2D0Ev,_ZThn40_N8S20948C2D0Ev),
  ABISELECT(256,148),
  ABISELECT(128,76),
  ABISELECT(-80,-52),
  ABISELECT(288,164),
  ABISELECT(-80,-52),
  ABISELECT(208,120),
  ABISELECT(208,120),
  ABISELECT(-80,-52),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N8S20948C2D1Ev,_ZThn52_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N8S20948C2D0Ev,_ZThn52_N8S20948C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20948C212v2Ev,
  ABISELECT(-96,-64),
  ABISELECT(192,108),
  ABISELECT(112,64),
  ABISELECT(-96,-64),
  ABISELECT(240,136),
  ABISELECT(-96,-64),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev),
  ABISELECT(-128,-80),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S20948C2D1Ev,_ZThn80_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S20948C2D0Ev,_ZThn80_N8S20948C2D0Ev),
  ABISELECT(-160,-96),
  ABISELECT(128,76),
  ABISELECT(128,76),
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S20948C2D1Ev,_ZThn96_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N8S20948C2D0Ev,_ZThn96_N8S20948C2D0Ev),
  ABISELECT(112,64),
  ABISELECT(112,64),
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N8S20948C2D1Ev,_ZThn108_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn176_N8S20948C2D0Ev,_ZThn108_N8S20948C2D0Ev),
  ABISELECT(-184,-112),
  ABISELECT(152,88),
  ABISELECT(120,72),
  ABISELECT(195,111),
  ABISELECT(-184,-112),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N8S20948C2D1Ev,_ZThn112_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn184_N8S20948C2D0Ev,_ZThn112_N8S20948C2D0Ev),
  ABISELECT(80,44),
  ABISELECT(-208,-128),
  ABISELECT(160,88),
  ABISELECT(96,56),
  ABISELECT(-208,-128),
  0,
  ABISELECT(-208,-128),
  ABISELECT(128,72),
  ABISELECT(-208,-128),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev),
  ABISELECT(-224,-140),
  ABISELECT(64,32),
  ABISELECT(-16,-12),
  ABISELECT(-224,-140),
  ABISELECT(112,60),
  ABISELECT(-224,-140),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n32_N8S20948C2D1Ev,_ZTvn28_n16_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn48_n32_N8S20948C2D0Ev,_ZTvn28_n16_N8S20948C2D0Ev),
  ABISELECT(-288,-172),
  0,
  0,
  ABISELECT(-288,-172),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn80_n32_N8S20948C2D1Ev,_ZTvn44_n16_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn80_n32_N8S20948C2D0Ev,_ZTvn44_n16_N8S20948C2D0Ev),
  ABISELECT(16,12),
  ABISELECT(-304,-184),
  ABISELECT(-304,-184),
  ABISELECT(32,16),
  ABISELECT(-304,-184),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C2D1Ev,_ZTv0_n20_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C2D0Ev,_ZTv0_n20_N8S20948C2D0Ev),
  ABISELECT(-320,-196),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  ABISELECT(-336,-200),
  ABISELECT(-336,-200),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C2D1Ev,_ZTv0_n12_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C2D0Ev,_ZTv0_n12_N8S20948C2D0Ev),
  ABISELECT(-368,-216),
  0,
  ABISELECT(-368,-216),
  ABISELECT(-368,-216),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C2D1Ev,_ZTv0_n20_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C2D0Ev,_ZTv0_n20_N8S20948C2D0Ev),
  ABISELECT(-384,-228),
  0,
  ABISELECT(-384,-228),
  ABISELECT(-96,-56),
  ABISELECT(-48,-28),
  ABISELECT(-384,-228),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20948C2D1Ev,_ZTv0_n28_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20948C2D0Ev,_ZTv0_n28_N8S20948C2D0Ev),
  ABISELECT(-392,-232),
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  ABISELECT(-392,-232),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N8S20948C2D1Ev,_ZTvn4_n28_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N8S20948C2D0Ev,_ZTvn4_n28_N8S20948C2D0Ev),
  ABISELECT(-416,-248),
  ABISELECT(-128,-76),
  ABISELECT(-208,-120),
  ABISELECT(-416,-248),
  ABISELECT(-80,-48),
  ABISELECT(-416,-248),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev),
  ABISELECT(-448,-264),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S20948C2D1Ev,_ZTvn16_n16_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N8S20948C2D0Ev,_ZTvn16_n16_N8S20948C2D0Ev),
  ABISELECT(-480,-280),
  ABISELECT(-192,-108),
  ABISELECT(-192,-108),
  ABISELECT(-480,-280),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n32_N8S20948C2D1Ev,_ZTvn32_n16_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n32_N8S20948C2D0Ev,_ZTvn32_n16_N8S20948C2D0Ev),
  ABISELECT(-496,-292),
  ABISELECT(-80,-44),
  ABISELECT(-288,-164),
  ABISELECT(-496,-292),
  ABISELECT(-128,-76),
  ABISELECT(-112,-64),
  ABISELECT(-496,-292),
  ABISELECT(-160,-92),
  ABISELECT(-117,-69),
  ABISELECT(32,12),
  ABISELECT(-208,-120),
  0,
  0,
  ABISELECT(-496,-292),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n120_N8S20948C2D1Ev,_ZTv0_n60_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n120_N8S20948C2D0Ev,_ZTv0_n60_N8S20948C2D0Ev),
  ABISELECT(64,40),
  0,
  ABISELECT(16,12),
  ABISELECT(-528,-304),
  ABISELECT(-112,-56),
  ABISELECT(-320,-176),
  ABISELECT(-528,-304),
  ABISELECT(-160,-88),
  ABISELECT(-149,-81),
  ABISELECT(-144,-76),
  ABISELECT(-240,-132),
  ABISELECT(-528,-304),
  ABISELECT(-192,-104),
  ABISELECT(-528,-304),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S20948C2D1Ev,_ZTv0_n48_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n96_N8S20948C2D0Ev,_ZTv0_n48_N8S20948C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20948C182v3Ev,
  ABISELECT(-544,-316),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  ABISELECT(-568,-332),
  ABISELECT(-280,-160),
  ABISELECT(-280,-160),
  ABISELECT(-568,-332),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n96_N8S20948C2D1Ev,_ZTvn28_n48_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn40_n96_N8S20948C2D0Ev,_ZTvn28_n48_N8S20948C2D0Ev),
  ABISELECT(-256,-144),
  ABISELECT(-384,-216),
  ABISELECT(-592,-344),
  ABISELECT(-224,-128),
  ABISELECT(-592,-344),
  ABISELECT(-304,-172),
  ABISELECT(-304,-172),
  ABISELECT(-592,-344),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n96_N8S20948C2D1Ev,_ZTvn40_n48_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n96_N8S20948C2D0Ev,_ZTvn40_n48_N8S20948C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20948C212v2Ev,
  ABISELECT(-608,-356),
  ABISELECT(-320,-184),
  ABISELECT(-400,-228),
  ABISELECT(-608,-356),
  ABISELECT(-272,-156),
  ABISELECT(-608,-356),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D1Ev,_ZTv0_n16_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C2D0Ev,_ZTv0_n16_N8S20948C2D0Ev),
  ABISELECT(-640,-372),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n96_N8S20948C2D1Ev,_ZTvn68_n48_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn112_n96_N8S20948C2D0Ev,_ZTvn68_n48_N8S20948C2D0Ev),
  ABISELECT(-672,-388),
  ABISELECT(-384,-216),
  ABISELECT(-384,-216),
  ABISELECT(-672,-388),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn144_n96_N8S20948C2D1Ev,_ZTvn84_n48_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn144_n96_N8S20948C2D0Ev,_ZTvn84_n48_N8S20948C2D0Ev),
  ABISELECT(-400,-228),
  ABISELECT(-400,-228),
  ABISELECT(-688,-400),
  (VTBL_ENTRY)&(_ZTI8S20948C2[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n96_N8S20948C2D1Ev,_ZTvn96_n48_N8S20948C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn160_n96_N8S20948C2D0Ev,_ZTvn96_n48_N8S20948C2D0Ev),
};
extern VTBL_ENTRY _ZTV8S20948C2[];
extern void ABISELECT(_ZTv0_n32_N9S20948C12D1Ev,_ZTv0_n16_N9S20948C12D1Ev)();
extern void _ZN9S20948C12D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C12D0Ev,_ZTv0_n16_N9S20948C12D0Ev)();
extern void _ZN9S20948C12D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C12__A1__8S20948C2[] = {
  0,
  ABISELECT(208,128),
  0,
  ABISELECT(336,200),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C12D1Ev,_ZTv0_n16_N9S20948C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C12D0Ev,_ZTv0_n16_N9S20948C12D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C12D1Ev,_ZTv0_n16_N9S20948C12D1Ev)();
extern void ABISELECT(_ZThn208_N9S20948C12D1Ev,_ZThn128_N9S20948C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C12D0Ev,_ZTv0_n16_N9S20948C12D0Ev)();
extern void ABISELECT(_ZThn208_N9S20948C12D0Ev,_ZThn128_N9S20948C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C12__A1__8S20948C2[] = {
  ABISELECT(-208,-128),
  ABISELECT(128,72),
  ABISELECT(-208,-128),
  (VTBL_ENTRY)&(_ZTI9S20948C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C12D1Ev,_ZTv0_n16_N9S20948C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C12D0Ev,_ZTv0_n16_N9S20948C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C12D1Ev,_ZTv0_n12_N9S20948C12D1Ev)();
extern void ABISELECT(_ZThn336_N9S20948C12D1Ev,_ZThn200_N9S20948C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C12D0Ev,_ZTv0_n12_N9S20948C12D0Ev)();
extern void ABISELECT(_ZThn336_N9S20948C12D0Ev,_ZThn200_N9S20948C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C12__A1__8S20948C2[] = {
  ABISELECT(-336,-200),
  ABISELECT(-336,-200),
  (VTBL_ENTRY)&(_ZTI9S20948C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C12D1Ev,_ZTv0_n12_N9S20948C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C12D0Ev,_ZTv0_n12_N9S20948C12D0Ev),
};
extern void _ZN9S20948C18D1Ev();
extern void _ZN9S20948C18D0Ev();
extern void _ZN9S20948C182v3Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C18__A__8S20948C2[] = {
  ABISELECT(400,236),
  ABISELECT(192,116),
  ABISELECT(-16,-12),
  ABISELECT(352,204),
  ABISELECT(363,211),
  ABISELECT(368,216),
  ABISELECT(272,160),
  ABISELECT(-16,-12),
  ABISELECT(320,188),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN9S20948C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C18D0Ev,
  (VTBL_ENTRY)&_ZN9S20948C182v3Ev,
};
extern void _ZN9S20948C19D1Ev();
extern void _ZN9S20948C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C199S20948C18__8S20948C2[] = {
  ABISELECT(368,216),
  ABISELECT(272,160),
  ABISELECT(-16,-12),
  ABISELECT(320,188),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN9S20948C19D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C19D0Ev,
};
extern void _ZN8S20948C4D1Ev();
extern void _ZN8S20948C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C49S20948C199S20948C18__A1__8S20948C2[] = {
  ABISELECT(-16,-12),
  ABISELECT(320,188),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&_ZN8S20948C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C4D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C58S20948C49S20948C199S20948C18__A2__8S20948C2[] = {
  ABISELECT(320,188),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn320_N8S20948C5D1Ev,_ZThn188_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn320_N8S20948C5D0Ev,_ZThn188_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C58S20948C49S20948C199S20948C18__A2__8S20948C2[] = {
  ABISELECT(-320,-188),
  ABISELECT(-320,-188),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev)();
extern void ABISELECT(_ZThn320_N8S20948C4D1Ev,_ZThn188_N8S20948C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev)();
extern void ABISELECT(_ZThn320_N8S20948C4D0Ev,_ZThn188_N8S20948C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C49S20948C199S20948C18__A1__8S20948C2[] = {
  ABISELECT(-320,-188),
  ABISELECT(-320,-188),
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C199S20948C18__8S20948C2[] = {
  0,
  ABISELECT(-272,-160),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev)();
extern void ABISELECT(_ZThn320_N9S20948C19D1Ev,_ZThn188_N9S20948C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev)();
extern void ABISELECT(_ZThn320_N9S20948C19D0Ev,_ZThn188_N9S20948C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C199S20948C18__8S20948C2[] = {
  ABISELECT(-320,-188),
  ABISELECT(-320,-188),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C19D1Ev,_ZTv0_n12_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C19D0Ev,_ZTv0_n12_N9S20948C19D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev)();
extern void ABISELECT(_ZThn368_N9S20948C19D1Ev,_ZThn216_N9S20948C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev)();
extern void ABISELECT(_ZThn368_N9S20948C19D0Ev,_ZThn216_N9S20948C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C20__9S20948C199S20948C18__8S20948C2[] = {
  ABISELECT(-368,-216),
  0,
  ABISELECT(-384,-228),
  ABISELECT(-96,-56),
  ABISELECT(-48,-28),
  ABISELECT(-368,-216),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C19D1Ev,_ZTv0_n28_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C19D0Ev,_ZTv0_n28_N9S20948C19D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn8_n56_N9S20948C19D1Ev,_ZTvn4_n28_N9S20948C19D1Ev)();
extern void ABISELECT(_ZTvn8_n56_N9S20948C19D0Ev,_ZTvn4_n28_N9S20948C19D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C20__9S20948C199S20948C18__8S20948C2[] = {
  ABISELECT(-392,-232),
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  ABISELECT(-376,-220),
  (VTBL_ENTRY)&(_ZTI9S20948C19[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C19D1Ev,_ZTvn4_n28_N9S20948C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C19D0Ev,_ZTvn4_n28_N9S20948C19D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C18__A2__8S20948C2[] = {
  ABISELECT(-56,-40),
  ABISELECT(232,132),
  ABISELECT(232,132),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C18__A2__8S20948C2[] = {
  ABISELECT(232,132),
  ABISELECT(232,132),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C18__A2__8S20948C2[] = {
  0,
  ABISELECT(-232,-132),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C18__A2__8S20948C2[] = {
  0,
  ABISELECT(-232,-132),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C21D1Ev();
extern void _ZN9S20948C21D0Ev();
extern void _ZN9S20948C212v2Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C219S20948C18__8S20948C2[] = {
  ABISELECT(256,148),
  ABISELECT(128,76),
  ABISELECT(-80,-52),
  ABISELECT(288,164),
  ABISELECT(-80,-52),
  ABISELECT(208,120),
  ABISELECT(208,120),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C21D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C21D0Ev,
  (VTBL_ENTRY)&_ZN9S20948C212v2Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C219S20948C18__A3__8S20948C2[] = {
  ABISELECT(-80,-52),
  ABISELECT(208,120),
  ABISELECT(208,120),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C219S20948C18__A3__8S20948C2[] = {
  ABISELECT(208,120),
  ABISELECT(208,120),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C219S20948C18__A3__8S20948C2[] = {
  0,
  ABISELECT(-208,-120),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C219S20948C18__A3__8S20948C2[] = {
  0,
  ABISELECT(-208,-120),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void _ZN9S20948C13D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
extern void _ZN9S20948C13D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C139S20948C219S20948C18__A1__8S20948C2[] = {
  ABISELECT(-96,-64),
  ABISELECT(192,108),
  ABISELECT(112,64),
  0,
  ABISELECT(240,136),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void _ZN9S20948C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
extern void _ZN9S20948C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C149S20948C139S20948C219S20948C18__A1__8S20948C2[] = {
  ABISELECT(192,108),
  ABISELECT(112,64),
  0,
  ABISELECT(240,136),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C14D1Ev,_ZThn64_N9S20948C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C14D0Ev,_ZThn64_N9S20948C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C149S20948C139S20948C219S20948C18__A1__8S20948C2[] = {
  ABISELECT(-112,-64),
  ABISELECT(128,72),
  ABISELECT(-112,-64),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev)();
extern void ABISELECT(_ZThn240_N9S20948C14D1Ev,_ZThn136_N9S20948C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev)();
extern void ABISELECT(_ZThn240_N9S20948C14D0Ev,_ZThn136_N9S20948C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C149S20948C139S20948C219S20948C18__A1__8S20948C2[] = {
  ABISELECT(-240,-136),
  ABISELECT(-240,-136),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C149S20948C139S20948C219S20948C18__A1__8S20948C2[] = {
  0,
  ABISELECT(-192,-108),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C139S20948C219S20948C18__A4__8S20948C2[] = {
  ABISELECT(-160,-96),
  ABISELECT(128,76),
  ABISELECT(128,76),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C139S20948C219S20948C18__A4__8S20948C2[] = {
  ABISELECT(128,76),
  ABISELECT(128,76),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C139S20948C219S20948C18__A4__8S20948C2[] = {
  0,
  ABISELECT(-128,-76),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C169S20948C139S20948C219S20948C18__A4__8S20948C2[] = {
  0,
  ABISELECT(-128,-76),
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C13D1Ev,_ZThn64_N9S20948C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C13D0Ev,_ZThn64_N9S20948C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C139S20948C219S20948C18__A1__8S20948C2[] = {
  ABISELECT(-112,-64),
  ABISELECT(128,72),
  ABISELECT(-112,-64),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn240_N9S20948C13D1Ev,_ZThn136_N9S20948C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev)();
extern void ABISELECT(_ZThn240_N9S20948C13D0Ev,_ZThn136_N9S20948C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C139S20948C219S20948C18__A1__8S20948C2[] = {
  ABISELECT(-240,-136),
  ABISELECT(-240,-136),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C139S20948C219S20948C18__A1__8S20948C2[] = {
  0,
  ABISELECT(-192,-108),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C139S20948C219S20948C18__A1__8S20948C2[] = {
  ABISELECT(-160,-96),
  ABISELECT(128,76),
  ABISELECT(128,76),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C219S20948C18__A5__8S20948C2[] = {
  ABISELECT(112,64),
  ABISELECT(112,64),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C219S20948C18__A5__8S20948C2[] = {
  0,
  ABISELECT(-112,-64),
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn288_N9S20948C21D1Ev,_ZThn164_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn288_N9S20948C21D0Ev,_ZThn164_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C10__9S20948C219S20948C18__8S20948C2[] = {
  ABISELECT(-288,-164),
  0,
  ABISELECT(-368,-216),
  ABISELECT(-288,-164),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C21D1Ev,_ZTv0_n20_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C21D0Ev,_ZTv0_n20_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__A1__9S20948C219S20948C18__8S20948C2[] = {
  0,
  ABISELECT(-208,-120),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn16_N9S20948C21D1Ev,_ZThn12_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn16_N9S20948C21D0Ev,_ZThn12_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C13__9S20948C219S20948C18__8S20948C2[] = {
  ABISELECT(-96,-64),
  ABISELECT(192,108),
  ABISELECT(112,64),
  ABISELECT(-16,-12),
  ABISELECT(240,136),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn128_N9S20948C21D1Ev,_ZThn76_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn128_N9S20948C21D0Ev,_ZThn76_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C219S20948C18__8S20948C2[] = {
  ABISELECT(-128,-76),
  ABISELECT(128,72),
  ABISELECT(-128,-76),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C21D1Ev,_ZTv0_n16_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C21D0Ev,_ZTv0_n16_N9S20948C21D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn256_N9S20948C21D1Ev,_ZThn148_N9S20948C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev)();
extern void ABISELECT(_ZThn256_N9S20948C21D0Ev,_ZThn148_N9S20948C21D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C219S20948C18__8S20948C2[] = {
  ABISELECT(-256,-148),
  ABISELECT(-256,-148),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C21D1Ev,_ZTv0_n12_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C21D0Ev,_ZTv0_n12_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn80_N9S20948C21D1Ev,_ZThn44_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn80_N9S20948C21D0Ev,_ZThn44_N9S20948C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C13__A1__9S20948C219S20948C18__8S20948C2[] = {
  ABISELECT(-160,-96),
  ABISELECT(128,76),
  ABISELECT(128,76),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N9S20948C21D1Ev,_ZThn44_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N9S20948C21D0Ev,_ZThn44_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn96_N9S20948C21D1Ev,_ZThn56_N9S20948C21D1Ev)();
extern void ABISELECT(_ZThn96_N9S20948C21D0Ev,_ZThn56_N9S20948C21D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C17__A2__9S20948C219S20948C18__8S20948C2[] = {
  ABISELECT(112,64),
  ABISELECT(112,64),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI9S20948C21[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N9S20948C21D1Ev,_ZThn56_N9S20948C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N9S20948C21D0Ev,_ZThn56_N9S20948C21D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C18__A__8S20948C2[] = {
  0,
  ABISELECT(-272,-160),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S20948C18D1Ev,_ZTv0_n12_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn320_N9S20948C18D1Ev,_ZThn188_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C18D0Ev,_ZTv0_n12_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn320_N9S20948C18D0Ev,_ZThn188_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-320,-188),
  ABISELECT(-320,-188),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C18D1Ev,_ZTv0_n12_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C18D0Ev,_ZTv0_n12_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n56_N9S20948C18D1Ev,_ZTv0_n28_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn368_N9S20948C18D1Ev,_ZThn216_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20948C18D0Ev,_ZTv0_n28_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn368_N9S20948C18D0Ev,_ZThn216_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C20__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-368,-216),
  0,
  ABISELECT(-384,-228),
  ABISELECT(-96,-56),
  ABISELECT(-48,-28),
  ABISELECT(-368,-216),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C18D1Ev,_ZTv0_n28_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20948C18D0Ev,_ZTv0_n28_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn8_n56_N9S20948C18D1Ev,_ZTvn4_n28_N9S20948C18D1Ev)();
extern void ABISELECT(_ZTvn8_n56_N9S20948C18D0Ev,_ZTvn4_n28_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C20__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-392,-232),
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  ABISELECT(-376,-220),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C18D1Ev,_ZTvn4_n28_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn8_n56_N9S20948C18D0Ev,_ZTvn4_n28_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn40_N9S20948C18D1Ev,_ZThn28_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn40_N9S20948C18D0Ev,_ZThn28_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__A1__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-56,-40),
  ABISELECT(232,132),
  ABISELECT(232,132),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S20948C18D1Ev,_ZThn28_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N9S20948C18D0Ev,_ZThn28_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C18D1Ev,_ZThn40_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C18D0Ev,_ZThn40_N9S20948C18D0Ev)();
extern void _ZN9S20948C212v2Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C21__9S20948C18__A__8S20948C2[] = {
  ABISELECT(256,148),
  ABISELECT(128,76),
  ABISELECT(-80,-52),
  ABISELECT(288,164),
  ABISELECT(-80,-52),
  ABISELECT(208,120),
  ABISELECT(208,120),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C18D1Ev,_ZThn40_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C18D0Ev,_ZThn40_N9S20948C18D0Ev),
  (VTBL_ENTRY)&_ZN9S20948C212v2Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N9S20948C18D1Ev,_ZTv0_n20_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn352_N9S20948C18D1Ev,_ZThn204_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20948C18D0Ev,_ZTv0_n20_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn352_N9S20948C18D0Ev,_ZThn204_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C10__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-352,-204),
  0,
  ABISELECT(-368,-216),
  ABISELECT(-352,-204),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C18D1Ev,_ZTv0_n20_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C18D0Ev,_ZTv0_n20_N9S20948C18D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn80_N9S20948C18D1Ev,_ZThn52_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn80_N9S20948C18D0Ev,_ZThn52_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C139S20948C21__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-96,-64),
  ABISELECT(192,108),
  ABISELECT(112,64),
  ABISELECT(-80,-52),
  ABISELECT(240,136),
  ABISELECT(-80,-52),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn192_N9S20948C18D1Ev,_ZThn116_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn192_N9S20948C18D0Ev,_ZThn116_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20948C5__A1__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-192,-116),
  ABISELECT(128,72),
  ABISELECT(-192,-116),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn144_N9S20948C18D1Ev,_ZThn84_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn144_N9S20948C18D0Ev,_ZThn84_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C139S20948C21__A3__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-160,-96),
  ABISELECT(128,76),
  ABISELECT(128,76),
  ABISELECT(-144,-84),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S20948C18D1Ev,_ZThn84_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn144_N9S20948C18D0Ev,_ZThn84_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn160_N9S20948C18D1Ev,_ZThn96_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn160_N9S20948C18D0Ev,_ZThn96_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C21__A4__9S20948C18__A__8S20948C2[] = {
  ABISELECT(112,64),
  ABISELECT(112,64),
  ABISELECT(-160,-96),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S20948C18D1Ev,_ZThn96_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N9S20948C18D0Ev,_ZThn96_N9S20948C18D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZThn400_N9S20948C18D1Ev,_ZThn236_N9S20948C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev)();
extern void ABISELECT(_ZThn400_N9S20948C18D0Ev,_ZThn236_N9S20948C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C13__A1__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-416,-248),
  ABISELECT(-128,-76),
  ABISELECT(-208,-120),
  ABISELECT(-400,-236),
  ABISELECT(-80,-48),
  ABISELECT(-400,-236),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D1Ev,_ZTv0_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C18D0Ev,_ZTv0_n16_N9S20948C18D0Ev),
};
extern void ABISELECT(_ZTvn32_n32_N9S20948C18D1Ev,_ZTvn16_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZTvn32_n32_N9S20948C18D0Ev,_ZTvn16_n16_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt9S20948C13__A2__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-432,-252),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N9S20948C18D1Ev,_ZTvn16_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn32_n32_N9S20948C18D0Ev,_ZTvn16_n16_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTvn64_n32_N9S20948C18D1Ev,_ZTvn32_n16_N9S20948C18D1Ev)();
extern void ABISELECT(_ZTvn64_n32_N9S20948C18D0Ev,_ZTvn32_n16_N9S20948C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C13__A4__9S20948C18__A__8S20948C2[] = {
  ABISELECT(-480,-280),
  ABISELECT(-192,-108),
  ABISELECT(-192,-108),
  ABISELECT(-464,-268),
  (VTBL_ENTRY)&(_ZTI9S20948C18[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n32_N9S20948C18D1Ev,_ZTvn32_n16_N9S20948C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn64_n32_N9S20948C18D0Ev,_ZTvn32_n16_N9S20948C18D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C22D1Ev();
extern void _ZN9S20948C22D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C22__8S20948C2[] = {
  ABISELECT(-184,-112),
  ABISELECT(152,88),
  ABISELECT(120,72),
  ABISELECT(195,111),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C22[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C22D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C22D0Ev,
};
extern void ABISELECT(_ZTv0_n40_N9S20948C22D1Ev,_ZTv0_n20_N9S20948C22D1Ev)();
extern void ABISELECT(_ZThn120_N9S20948C22D1Ev,_ZThn72_N9S20948C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N9S20948C22D0Ev,_ZTv0_n20_N9S20948C22D0Ev)();
extern void ABISELECT(_ZThn120_N9S20948C22D0Ev,_ZThn72_N9S20948C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20948C4__9S20948C22__8S20948C2[] = {
  ABISELECT(16,12),
  ABISELECT(-120,-72),
  ABISELECT(-304,-184),
  ABISELECT(32,16),
  ABISELECT(-120,-72),
  (VTBL_ENTRY)&(_ZTI9S20948C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C22D1Ev,_ZTv0_n20_N9S20948C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N9S20948C22D0Ev,_ZTv0_n20_N9S20948C22D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C22D1Ev,_ZTv0_n12_N9S20948C22D1Ev)();
extern void ABISELECT(_ZThn152_N9S20948C22D1Ev,_ZThn88_N9S20948C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C22D0Ev,_ZTv0_n12_N9S20948C22D0Ev)();
extern void ABISELECT(_ZThn152_N9S20948C22D0Ev,_ZThn88_N9S20948C22D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C22__8S20948C2[] = {
  ABISELECT(-152,-88),
  ABISELECT(-152,-88),
  (VTBL_ENTRY)&(_ZTI9S20948C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C22D1Ev,_ZTv0_n12_N9S20948C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C22D0Ev,_ZTv0_n12_N9S20948C22D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt8S20948C4__9S20948C22__8S20948C2[] = {
  ABISELECT(-136,-84),
  (VTBL_ENTRY)&(_ZTI9S20948C22[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S20948C3D1Ev,_ZTv0_n16_N8S20948C3D1Ev)();
extern void _ZN8S20948C3D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C3D0Ev,_ZTv0_n16_N8S20948C3D0Ev)();
extern void _ZN8S20948C3D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20948C3__8S20948C2[] = {
  ABISELECT(80,44),
  ABISELECT(-208,-128),
  ABISELECT(160,88),
  ABISELECT(96,56),
  ABISELECT(-208,-128),
  0,
  0,
  ABISELECT(128,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C3D1Ev,_ZTv0_n16_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C3D0Ev,_ZTv0_n16_N8S20948C3D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C12D1Ev,_ZTv0_n16_N9S20948C12D1Ev)();
extern void _ZN9S20948C12D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C12D0Ev,_ZTv0_n16_N9S20948C12D0Ev)();
extern void _ZN9S20948C12D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C128S20948C3__8S20948C2[] = {
  ABISELECT(-208,-128),
  0,
  0,
  ABISELECT(128,72),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C12D1Ev,_ZTv0_n16_N9S20948C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C12D0Ev,_ZTv0_n16_N9S20948C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C12D1Ev,_ZTv0_n12_N9S20948C12D1Ev)();
extern void ABISELECT(_ZThn128_N9S20948C12D1Ev,_ZThn72_N9S20948C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C12D0Ev,_ZTv0_n12_N9S20948C12D0Ev)();
extern void ABISELECT(_ZThn128_N9S20948C12D0Ev,_ZThn72_N9S20948C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C128S20948C3__8S20948C2[] = {
  ABISELECT(-128,-72),
  ABISELECT(-128,-72),
  (VTBL_ENTRY)&(_ZTI9S20948C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C12D1Ev,_ZTv0_n12_N9S20948C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C12D0Ev,_ZTv0_n12_N9S20948C12D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void _ZN9S20948C13D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
extern void _ZN9S20948C13D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C138S20948C3__8S20948C2[] = {
  ABISELECT(-224,-140),
  ABISELECT(64,32),
  ABISELECT(-16,-12),
  0,
  ABISELECT(112,60),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void _ZN9S20948C14D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
extern void _ZN9S20948C14D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C149S20948C138S20948C3__8S20948C2[] = {
  ABISELECT(64,32),
  ABISELECT(-16,-12),
  0,
  ABISELECT(112,60),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C149S20948C138S20948C3__8S20948C2[] = {
  ABISELECT(16,12),
  ABISELECT(128,72),
  ABISELECT(16,12),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D1Ev,_ZTv0_n16_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C14D0Ev,_ZTv0_n16_N9S20948C14D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C14D1Ev,_ZThn60_N9S20948C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C14D0Ev,_ZThn60_N9S20948C14D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C149S20948C138S20948C3__8S20948C2[] = {
  ABISELECT(-112,-60),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D1Ev,_ZTv0_n12_N9S20948C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C14D0Ev,_ZTv0_n12_N9S20948C14D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C149S20948C138S20948C3__8S20948C2[] = {
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C14[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C138S20948C3__8S20948C2[] = {
  ABISELECT(-288,-172),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C138S20948C3__8S20948C2[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S20948C5__9S20948C138S20948C3__8S20948C2[] = {
  ABISELECT(16,12),
  ABISELECT(128,72),
  ABISELECT(16,12),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D1Ev,_ZTv0_n16_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20948C13D0Ev,_ZTv0_n16_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn112_N9S20948C13D1Ev,_ZThn60_N9S20948C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev)();
extern void ABISELECT(_ZThn112_N9S20948C13D0Ev,_ZThn60_N9S20948C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__9S20948C138S20948C3__8S20948C2[] = {
  ABISELECT(-112,-60),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D1Ev,_ZTv0_n12_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S20948C13D0Ev,_ZTv0_n12_N9S20948C13D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev)();
extern void ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C16__9S20948C138S20948C3__8S20948C2[] = {
  ABISELECT(-288,-172),
  0,
  0,
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI9S20948C13[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D1Ev,_ZThn32_N9S20948C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn64_N9S20948C13D0Ev,_ZThn32_N9S20948C13D0Ev),
};
extern void ABISELECT(_ZTv0_n40_N8S20948C3D1Ev,_ZTv0_n20_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn96_N8S20948C3D1Ev,_ZThn56_N8S20948C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20948C3D0Ev,_ZTv0_n20_N8S20948C3D0Ev)();
extern void ABISELECT(_ZThn96_N8S20948C3D0Ev,_ZThn56_N8S20948C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S20948C4__8S20948C3__8S20948C2[] = {
  ABISELECT(16,12),
  ABISELECT(-96,-56),
  ABISELECT(-304,-184),
  ABISELECT(32,16),
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C3D1Ev,_ZTv0_n20_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C3D0Ev,_ZTv0_n20_N8S20948C3D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20948C3D1Ev,_ZTv0_n12_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn128_N8S20948C3D1Ev,_ZThn72_N8S20948C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C3D0Ev,_ZTv0_n12_N8S20948C3D0Ev)();
extern void ABISELECT(_ZThn128_N8S20948C3D0Ev,_ZThn72_N8S20948C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C3__8S20948C2[] = {
  ABISELECT(-128,-72),
  ABISELECT(-128,-72),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C3D1Ev,_ZTv0_n12_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C3D0Ev,_ZTv0_n12_N8S20948C3D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt8S20948C4__8S20948C3__8S20948C2[] = {
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZTv0_n40_N8S20948C3D1Ev,_ZTv0_n20_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn160_N8S20948C3D1Ev,_ZThn88_N8S20948C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S20948C3D0Ev,_ZTv0_n20_N8S20948C3D0Ev)();
extern void ABISELECT(_ZThn160_N8S20948C3D0Ev,_ZThn88_N8S20948C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C10__8S20948C3__8S20948C2[] = {
  ABISELECT(-160,-88),
  0,
  ABISELECT(-368,-216),
  ABISELECT(-160,-88),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C3D1Ev,_ZTv0_n20_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S20948C3D0Ev,_ZTv0_n20_N8S20948C3D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void ABISELECT(_ZThn80_N8S20948C3D1Ev,_ZThn44_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn80_N8S20948C3D0Ev,_ZThn44_N8S20948C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C13__8S20948C3__8S20948C2[] = {
  ABISELECT(-288,-172),
  0,
  0,
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N8S20948C3D1Ev,_ZThn44_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N8S20948C3D0Ev,_ZThn44_N8S20948C3D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S20948C3D1Ev,_ZTv0_n16_N8S20948C3D1Ev)();
extern void ABISELECT(_ZThn16_N8S20948C3D1Ev,_ZThn12_N8S20948C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20948C3D0Ev,_ZTv0_n16_N8S20948C3D0Ev)();
extern void ABISELECT(_ZThn16_N8S20948C3D0Ev,_ZThn12_N8S20948C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20948C13__8S20948C3__8S20948C2[] = {
  ABISELECT(-224,-140),
  ABISELECT(64,32),
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(112,60),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S20948C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C3D1Ev,_ZTv0_n16_N8S20948C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20948C3D0Ev,_ZTv0_n16_N8S20948C3D0Ev),
};
extern void _ZN8S20948C4D1Ev();
extern void _ZN8S20948C4D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C4__8S20948C2[] = {
  ABISELECT(-304,-184),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&_ZN8S20948C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C4D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C58S20948C4__8S20948C2[] = {
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn32_N8S20948C5D1Ev,_ZThn16_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn32_N8S20948C5D0Ev,_ZThn16_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C58S20948C4__8S20948C2[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev)();
extern void ABISELECT(_ZThn32_N8S20948C4D1Ev,_ZThn16_N8S20948C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev)();
extern void ABISELECT(_ZThn32_N8S20948C4D0Ev,_ZThn16_N8S20948C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C4__8S20948C2[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S20948C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D1Ev,_ZTv0_n12_N8S20948C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C4D0Ev,_ZTv0_n12_N8S20948C4D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C10D1Ev();
extern void _ZN9S20948C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C10__8S20948C2[] = {
  ABISELECT(-368,-216),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C10[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C10D0Ev,
};
extern void _ZN8S20948C5D1Ev();
extern void _ZN8S20948C5D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20948C5__A1__8S20948C2[] = {
  ABISELECT(128,72),
  0,
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&_ZN8S20948C5D1Ev,
  (VTBL_ENTRY)&_ZN8S20948C5D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev)();
extern void ABISELECT(_ZThn128_N8S20948C5D1Ev,_ZThn72_N8S20948C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev)();
extern void ABISELECT(_ZThn128_N8S20948C5D0Ev,_ZThn72_N8S20948C5D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV11S20948C7_nt__8S20948C5__A1__8S20948C2[] = {
  ABISELECT(-128,-72),
  ABISELECT(-128,-72),
  (VTBL_ENTRY)&(_ZTI8S20948C5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D1Ev,_ZTv0_n12_N8S20948C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S20948C5D0Ev,_ZTv0_n12_N8S20948C5D0Ev),
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C20D1Ev();
extern void _ZN9S20948C20D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C20__8S20948C2[] = {
  ABISELECT(-384,-228),
  ABISELECT(-96,-56),
  ABISELECT(-48,-28),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C20[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C20D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C20D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C16D1Ev();
extern void _ZN9S20948C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C169S20948C20__A1__8S20948C2[] = {
  ABISELECT(-392,-232),
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C16[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C16D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
extern void _ZN9S20948C17D1Ev();
extern void _ZN9S20948C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20948C179S20948C169S20948C20__A1__8S20948C2[] = {
  ABISELECT(-104,-60),
  ABISELECT(-104,-60),
  0,
  (VTBL_ENTRY)&(_ZTI9S20948C17[0]),
  (VTBL_ENTRY)&_ZN11S20948C9_nt2v1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20948C17D0Ev,
};
extern void _ZN11S20948C9_nt2v1Ev();
static  VTBL_ENTRY _tg__ZTV11S20948C9_nt__9S20948C179S20948C169S20948C20__A1__8S20948C2[] = {
  0,
  ABISELECT(1