// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S15308C5_nt  {
};
//SIG(-1 S15308C5_nt) C1{}



//skip512 S15308C5_nt

#else // __cplusplus

Class_Descriptor cd_S15308C5_nt = {  "S15308C5_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C4_nt  : S15308C5_nt {
};
//SIG(-1 S15308C4_nt) C1{ BC2{}}



//skip512 S15308C4_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C4_nt = {  "S15308C4_nt", // class name
  bases_S15308C4_nt, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C7  {
};
//SIG(-1 S15308C7) C1{}



static void Test_S15308C7()
{
  {
    init_simple_test("S15308C7");
    S15308C7 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C7)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C7)");
  }
}
static Arrange_To_Call_Me vS15308C7(Test_S15308C7, "S15308C7", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C7 = {  "S15308C7", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C6  : S15308C7 {
};
//SIG(-1 S15308C6) C1{ BC2{}}



static void Test_S15308C6()
{
  extern Class_Descriptor cd_S15308C6;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C6, buf);
    S15308C6 &lv = *(new (buf) S15308C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C6)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C6)");
    check_base_class_offset(lv, (S15308C7*), 0, "S15308C6");
    test_class_info(&lv, &cd_S15308C6);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C6(Test_S15308C6, "S15308C6", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C7;
static Base_Class bases_S15308C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C6 = {  "S15308C6", // class name
  bases_S15308C6, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C3_nt  : S15308C4_nt {
  ::S15308C6 s15308c3f0;
};
//SIG(-1 S15308C3_nt) C1{ BC2{ BC3{}} FC4{ BC5{}}}



//skip512 S15308C3_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C4_nt;
static Base_Class bases_S15308C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C3_nt = {  "S15308C3_nt", // class name
  bases_S15308C3_nt, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S15308C8_nt  {
  char s15308c8f0[16];
  void *s15308c8f1;
};
//SIG(1 S15308C8_nt) U1{ Fc[16] Fp}

#endif // __cplusplus
#ifdef __cplusplus

struct  S15308C2_nt  : S15308C3_nt {
  ::S15308C8_nt s15308c2f0;
  int s15308c2f1;
  int s15308c2f2;
};
//SIG(-1 S15308C2_nt) C1{ BC2{ BC3{ BC4{}} FC5{ BC6{}}} FU7{ Fc[16] Fp} Fi Fi}



//skip512 S15308C2_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C4_nt;
extern Class_Descriptor cd_S15308C3_nt;
static Base_Class bases_S15308C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C9_nt  {
  __tsi64 s15308c9f0;
  void  mf15308c9(); // _ZN11S15308C9_nt9mf15308c9Ev
};
//SIG(-1 S15308C9_nt) C1{ m FL}


void  S15308C9_nt ::mf15308c9(){}

//skip512 S15308C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C10_nt  {
  void *s15308c10f0;
  void  mf15308c10(); // _ZN12S15308C10_nt10mf15308c10Ev
};
//SIG(-1 S15308C10_nt) C1{ m Fp}


void  S15308C10_nt ::mf15308c10(){}

//skip512 S15308C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C12_nt  : S15308C5_nt {
  ::S15308C6 s15308c12f0;
};
//SIG(-1 S15308C12_nt) C1{ BC2{} FC3{ BC4{}}}



//skip512 S15308C12_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C12_nt = {  "S15308C12_nt", // class name
  bases_S15308C12_nt, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C11_nt  : S15308C12_nt {
  void *s15308c11f0;
  void *s15308c11f1;
  void *s15308c11f2;
};
//SIG(-1 S15308C11_nt) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



//skip512 S15308C11_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C12_nt;
static Base_Class bases_S15308C11_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C12_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C23  {
};
//SIG(-1 S15308C23) C1{}



static void Test_S15308C23()
{
  {
    init_simple_test("S15308C23");
    S15308C23 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C23)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C23)");
  }
}
static Arrange_To_Call_Me vS15308C23(Test_S15308C23, "S15308C23", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C23 = {  "S15308C23", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C22  : S15308C23 {
};
//SIG(-1 S15308C22) C1{ BC2{}}



static void Test_S15308C22()
{
  extern Class_Descriptor cd_S15308C22;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C22, buf);
    S15308C22 &lv = *(new (buf) S15308C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C22)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C22)");
    check_base_class_offset(lv, (S15308C23*), 0, "S15308C22");
    test_class_info(&lv, &cd_S15308C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C22(Test_S15308C22, "S15308C22", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C23;
static Base_Class bases_S15308C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C22 = {  "S15308C22", // class name
  bases_S15308C22, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C21  : S15308C5_nt {
  ::S15308C22 s15308c21f0;
};
//SIG(-1 S15308C21) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C21()
{
  extern Class_Descriptor cd_S15308C21;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C21, buf);
    S15308C21 &lv = *(new (buf) S15308C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C21)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C21)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C21");
    check_field_offset(lv, s15308c21f0, 0, "S15308C21.s15308c21f0");
    test_class_info(&lv, &cd_S15308C21);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C21(Test_S15308C21, "S15308C21", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C21 = {  "S15308C21", // class name
  bases_S15308C21, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C20  : S15308C21 {
  void *s15308c20f0;
  void *s15308c20f1;
  void *s15308c20f2;
};
//SIG(-1 S15308C20) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S15308C20()
{
  extern Class_Descriptor cd_S15308C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S15308C20, buf);
    S15308C20 &lv = *(new (buf) S15308C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S15308C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C20)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C21*), 0, "S15308C20");
    check_base_class_offset(lv, (S15308C21*), 0, "S15308C20");
    check_field_offset(lv, s15308c20f0, ABISELECT(8,4), "S15308C20.s15308c20f0");
    check_field_offset(lv, s15308c20f1, ABISELECT(16,8), "S15308C20.s15308c20f1");
    check_field_offset(lv, s15308c20f2, ABISELECT(24,12), "S15308C20.s15308c20f2");
    test_class_info(&lv, &cd_S15308C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C20(Test_S15308C20, "S15308C20", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C21;
static Base_Class bases_S15308C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C20 = {  "S15308C20", // class name
  bases_S15308C20, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C29  : S15308C5_nt {
  ::S15308C6 s15308c29f0;
};
//SIG(-1 S15308C29) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C29()
{
  extern Class_Descriptor cd_S15308C29;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C29, buf);
    S15308C29 &lv = *(new (buf) S15308C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C29)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C29)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C29");
    check_field_offset(lv, s15308c29f0, 0, "S15308C29.s15308c29f0");
    test_class_info(&lv, &cd_S15308C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C29(Test_S15308C29, "S15308C29", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C29 = {  "S15308C29", // class name
  bases_S15308C29, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C28  : S15308C29 {
  void *s15308c28f0;
  void *s15308c28f1;
  void *s15308c28f2;
};
//SIG(-1 S15308C28) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S15308C28()
{
  extern Class_Descriptor cd_S15308C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S15308C28, buf);
    S15308C28 &lv = *(new (buf) S15308C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S15308C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C28)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C29*), 0, "S15308C28");
    check_base_class_offset(lv, (S15308C29*), 0, "S15308C28");
    check_field_offset(lv, s15308c28f0, ABISELECT(8,4), "S15308C28.s15308c28f0");
    check_field_offset(lv, s15308c28f1, ABISELECT(16,8), "S15308C28.s15308c28f1");
    check_field_offset(lv, s15308c28f2, ABISELECT(24,12), "S15308C28.s15308c28f2");
    test_class_info(&lv, &cd_S15308C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C28(Test_S15308C28, "S15308C28", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C29;
static Base_Class bases_S15308C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C28 = {  "S15308C28", // class name
  bases_S15308C28, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C19  {
  ::S15308C20 s15308c19f0;
  ::S15308C20 s15308c19f1;
  ::S15308C28 s15308c19f2;
  ::S15308C28 s15308c19f3;
  ::S15308C2_nt s15308c19f4;
  void  mf15308c19(); // _ZN9S15308C1910mf15308c19Ev
};
//SIG(-1 S15308C19) C1{ m FC2{ BC3{ BC4{} FC5{ BC6{}}} Fp[3]} FC2 FC7{ BC8{ BC4 FC9{ BC10{}}} Fp[3]} FC7 FC11{ BC12{ BC13{ BC4} FC9} FU14{ Fc[16] Fp} Fi Fi}}


void  S15308C19 ::mf15308c19(){}

static void Test_S15308C19()
{
  {
    init_simple_test("S15308C19");
    S15308C19 lv;
    check2(sizeof(lv), ABISELECT(160,92), "sizeof(S15308C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C19)");
    check_field_offset(lv, s15308c19f0, 0, "S15308C19.s15308c19f0");
    check_field_offset(lv, s15308c19f1, ABISELECT(32,16), "S15308C19.s15308c19f1");
    check_field_offset(lv, s15308c19f2, ABISELECT(64,32), "S15308C19.s15308c19f2");
    check_field_offset(lv, s15308c19f3, ABISELECT(96,48), "S15308C19.s15308c19f3");
    check_field_offset(lv, s15308c19f4, ABISELECT(128,64), "S15308C19.s15308c19f4");
  }
}
static Arrange_To_Call_Me vS15308C19(Test_S15308C19, "S15308C19", ABISELECT(160,92));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C37  : S15308C5_nt {
  ::S15308C22 s15308c37f0;
};
//SIG(-1 S15308C37) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C37()
{
  extern Class_Descriptor cd_S15308C37;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C37, buf);
    S15308C37 &lv = *(new (buf) S15308C37());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C37)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C37)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C37");
    check_field_offset(lv, s15308c37f0, 0, "S15308C37.s15308c37f0");
    test_class_info(&lv, &cd_S15308C37);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C37(Test_S15308C37, "S15308C37", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C37 = {  "S15308C37", // class name
  bases_S15308C37, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C41  {
};
//SIG(-1 S15308C41) C1{}



static void Test_S15308C41()
{
  {
    init_simple_test("S15308C41");
    S15308C41 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C41)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C41)");
  }
}
static Arrange_To_Call_Me vS15308C41(Test_S15308C41, "S15308C41", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C41 = {  "S15308C41", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C40  : S15308C41 {
};
//SIG(-1 S15308C40) C1{ BC2{}}



static void Test_S15308C40()
{
  extern Class_Descriptor cd_S15308C40;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C40, buf);
    S15308C40 &lv = *(new (buf) S15308C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C40)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C40)");
    check_base_class_offset(lv, (S15308C41*), 0, "S15308C40");
    test_class_info(&lv, &cd_S15308C40);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C40(Test_S15308C40, "S15308C40", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C41;
static Base_Class bases_S15308C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C40 = {  "S15308C40", // class name
  bases_S15308C40, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C36_nt  : S15308C37 {
  ::S15308C40 s15308c36f0;
};
//SIG(-1 S15308C36_nt) C1{ BC2{ BC3{} FC4{ BC5{}}} FC6{ BC7{}}}



//skip512 S15308C36_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C37;
static Base_Class bases_S15308C36_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C37,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C36_nt = {  "S15308C36_nt", // class name
  bases_S15308C36_nt, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C35_nt  : S15308C36_nt {
  ::S15308C40 s15308c35f0;
};
//SIG(-1 S15308C35_nt) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC7{ BC8{}}} FC7}



//skip512 S15308C35_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C37;
extern Class_Descriptor cd_S15308C36_nt;
static Base_Class bases_S15308C35_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C37,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C36_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C35_nt = {  "S15308C35_nt", // class name
  bases_S15308C35_nt, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C34_nt  : S15308C35_nt {
  void *s15308c34f0;
  int s15308c34f1;
};
//SIG(-1 S15308C34_nt) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC8{ BC9{}}} FC8} Fp Fi}



//skip512 S15308C34_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C37;
extern Class_Descriptor cd_S15308C36_nt;
extern Class_Descriptor cd_S15308C35_nt;
static Base_Class bases_S15308C34_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C37,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C36_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C35_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C61  {
};
//SIG(-1 S15308C61) C1{}



static void Test_S15308C61()
{
  {
    init_simple_test("S15308C61");
    S15308C61 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C61)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C61)");
  }
}
static Arrange_To_Call_Me vS15308C61(Test_S15308C61, "S15308C61", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C61 = {  "S15308C61", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C60  : S15308C61 {
};
//SIG(-1 S15308C60) C1{ BC2{}}



static void Test_S15308C60()
{
  extern Class_Descriptor cd_S15308C60;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C60, buf);
    S15308C60 &lv = *(new (buf) S15308C60());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C60)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C60)");
    check_base_class_offset(lv, (S15308C61*), 0, "S15308C60");
    test_class_info(&lv, &cd_S15308C60);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C60(Test_S15308C60, "S15308C60", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C61;
static Base_Class bases_S15308C60[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C61,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C60 = {  "S15308C60", // class name
  bases_S15308C60, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C59  : S15308C5_nt {
  ::S15308C60 s15308c59f0;
};
//SIG(-1 S15308C59) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C59()
{
  extern Class_Descriptor cd_S15308C59;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C59, buf);
    S15308C59 &lv = *(new (buf) S15308C59());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C59)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C59)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C59");
    check_field_offset(lv, s15308c59f0, 0, "S15308C59.s15308c59f0");
    test_class_info(&lv, &cd_S15308C59);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C59(Test_S15308C59, "S15308C59", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C59[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C59 = {  "S15308C59", // class name
  bases_S15308C59, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C58  : S15308C59 {
  ::S15308C60 s15308c58f0;
};
//SIG(-1 S15308C58) C1{ BC2{ BC3{} FC4{ BC5{}}} FC4}



static void Test_S15308C58()
{
  extern Class_Descriptor cd_S15308C58;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S15308C58, buf);
    S15308C58 &lv = *(new (buf) S15308C58());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S15308C58)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C58)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C59*), 0, "S15308C58");
    check_base_class_offset(lv, (S15308C59*), 0, "S15308C58");
    check_field_offset(lv, s15308c58f0, 1, "S15308C58.s15308c58f0");
    test_class_info(&lv, &cd_S15308C58);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C58(Test_S15308C58, "S15308C58", 2);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C59;
static Base_Class bases_S15308C58[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C59,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C58 = {  "S15308C58", // class name
  bases_S15308C58, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C65  {
};
//SIG(-1 S15308C65) C1{}



static void Test_S15308C65()
{
  {
    init_simple_test("S15308C65");
    S15308C65 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C65)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C65)");
  }
}
static Arrange_To_Call_Me vS15308C65(Test_S15308C65, "S15308C65", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C65 = {  "S15308C65", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C64  : S15308C65 {
};
//SIG(-1 S15308C64) C1{ BC2{}}



static void Test_S15308C64()
{
  extern Class_Descriptor cd_S15308C64;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C64, buf);
    S15308C64 &lv = *(new (buf) S15308C64());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C64)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C64)");
    check_base_class_offset(lv, (S15308C65*), 0, "S15308C64");
    test_class_info(&lv, &cd_S15308C64);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C64(Test_S15308C64, "S15308C64", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C65;
static Base_Class bases_S15308C64[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C65,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C64 = {  "S15308C64", // class name
  bases_S15308C64, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C57  : S15308C58 {
  ::S15308C64 s15308c57f0;
};
//SIG(-1 S15308C57) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC5} FC7{ BC8{}}}



static void Test_S15308C57()
{
  extern Class_Descriptor cd_S15308C57;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S15308C57, buf);
    S15308C57 &lv = *(new (buf) S15308C57());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S15308C57)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C57)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C59*)(S15308C58*), 0, "S15308C57");
    check_base_class_offset(lv, (S15308C59*)(S15308C58*), 0, "S15308C57");
    check_base_class_offset(lv, (S15308C58*), 0, "S15308C57");
    check_field_offset(lv, s15308c57f0, 2, "S15308C57.s15308c57f0");
    test_class_info(&lv, &cd_S15308C57);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C57(Test_S15308C57, "S15308C57", 3);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C59;
extern Class_Descriptor cd_S15308C58;
static Base_Class bases_S15308C57[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C59,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C58,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C57 = {  "S15308C57", // class name
  bases_S15308C57, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C56_nt  : S15308C57 {
  ::S15308C64 s15308c56f0;
};
//SIG(-1 S15308C56_nt) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC6} FC8{ BC9{}}} FC8}



//skip512 S15308C56_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C59;
extern Class_Descriptor cd_S15308C58;
extern Class_Descriptor cd_S15308C57;
static Base_Class bases_S15308C56_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C59,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C58,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C57,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C56_nt = {  "S15308C56_nt", // class name
  bases_S15308C56_nt, 4,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C55_nt  : S15308C56_nt {
  void *s15308c55f0;
  int s15308c55f1;
};
//SIG(-1 S15308C55_nt) C1{ BC2{ BC3{ BC4{ BC5{ BC6{} FC7{ BC8{}}} FC7} FC9{ BC10{}}} FC9} Fp Fi}



//skip512 S15308C55_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C59;
extern Class_Descriptor cd_S15308C58;
extern Class_Descriptor cd_S15308C57;
extern Class_Descriptor cd_S15308C56_nt;
static Base_Class bases_S15308C55_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C59,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C58,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C57,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C56_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C55_nt = {  "S15308C55_nt", // class name
  bases_S15308C55_nt, 5,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C54_nt  : S15308C55_nt {
};
//SIG(-1 S15308C54_nt) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{} FC8{ BC9{}}} FC8} FC10{ BC11{}}} FC10} Fp Fi}}



//skip512 S15308C54_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C59;
extern Class_Descriptor cd_S15308C58;
extern Class_Descriptor cd_S15308C57;
extern Class_Descriptor cd_S15308C56_nt;
extern Class_Descriptor cd_S15308C55_nt;
static Base_Class bases_S15308C54_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C59,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C58,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C57,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C56_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S15308C55_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C87  {
};
//SIG(-1 S15308C87) C1{}



static void Test_S15308C87()
{
  {
    init_simple_test("S15308C87");
    S15308C87 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C87)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C87)");
  }
}
static Arrange_To_Call_Me vS15308C87(Test_S15308C87, "S15308C87", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C87 = {  "S15308C87", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C86  : S15308C87 {
};
//SIG(-1 S15308C86) C1{ BC2{}}



static void Test_S15308C86()
{
  extern Class_Descriptor cd_S15308C86;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C86, buf);
    S15308C86 &lv = *(new (buf) S15308C86());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C86)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C86)");
    check_base_class_offset(lv, (S15308C87*), 0, "S15308C86");
    test_class_info(&lv, &cd_S15308C86);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C86(Test_S15308C86, "S15308C86", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C87;
static Base_Class bases_S15308C86[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C87,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C86 = {  "S15308C86", // class name
  bases_S15308C86, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C85  : S15308C5_nt {
  ::S15308C86 s15308c85f0;
};
//SIG(-1 S15308C85) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C85()
{
  extern Class_Descriptor cd_S15308C85;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C85, buf);
    S15308C85 &lv = *(new (buf) S15308C85());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C85)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C85)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C85");
    check_field_offset(lv, s15308c85f0, 0, "S15308C85.s15308c85f0");
    test_class_info(&lv, &cd_S15308C85);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C85(Test_S15308C85, "S15308C85", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C85[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C85 = {  "S15308C85", // class name
  bases_S15308C85, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C84  : S15308C85 {
  ::S15308C86 s15308c84f0;
};
//SIG(-1 S15308C84) C1{ BC2{ BC3{} FC4{ BC5{}}} FC4}



static void Test_S15308C84()
{
  extern Class_Descriptor cd_S15308C84;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S15308C84, buf);
    S15308C84 &lv = *(new (buf) S15308C84());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S15308C84)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C84)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C85*), 0, "S15308C84");
    check_base_class_offset(lv, (S15308C85*), 0, "S15308C84");
    check_field_offset(lv, s15308c84f0, 1, "S15308C84.s15308c84f0");
    test_class_info(&lv, &cd_S15308C84);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C84(Test_S15308C84, "S15308C84", 2);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C85;
static Base_Class bases_S15308C84[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C85,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C84 = {  "S15308C84", // class name
  bases_S15308C84, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C91  {
};
//SIG(-1 S15308C91) C1{}



static void Test_S15308C91()
{
  {
    init_simple_test("S15308C91");
    S15308C91 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C91)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C91)");
  }
}
static Arrange_To_Call_Me vS15308C91(Test_S15308C91, "S15308C91", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C91 = {  "S15308C91", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C90  : S15308C91 {
};
//SIG(-1 S15308C90) C1{ BC2{}}



static void Test_S15308C90()
{
  extern Class_Descriptor cd_S15308C90;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C90, buf);
    S15308C90 &lv = *(new (buf) S15308C90());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C90)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C90)");
    check_base_class_offset(lv, (S15308C91*), 0, "S15308C90");
    test_class_info(&lv, &cd_S15308C90);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C90(Test_S15308C90, "S15308C90", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C91;
static Base_Class bases_S15308C90[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C91,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C90 = {  "S15308C90", // class name
  bases_S15308C90, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C83  : S15308C84 {
  ::S15308C90 s15308c83f0;
};
//SIG(-1 S15308C83) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC5} FC7{ BC8{}}}



static void Test_S15308C83()
{
  extern Class_Descriptor cd_S15308C83;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S15308C83, buf);
    S15308C83 &lv = *(new (buf) S15308C83());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S15308C83)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C83)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C85*)(S15308C84*), 0, "S15308C83");
    check_base_class_offset(lv, (S15308C85*)(S15308C84*), 0, "S15308C83");
    check_base_class_offset(lv, (S15308C84*), 0, "S15308C83");
    check_field_offset(lv, s15308c83f0, 2, "S15308C83.s15308c83f0");
    test_class_info(&lv, &cd_S15308C83);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C83(Test_S15308C83, "S15308C83", 3);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C85;
extern Class_Descriptor cd_S15308C84;
static Base_Class bases_S15308C83[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C85,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C84,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C83 = {  "S15308C83", // class name
  bases_S15308C83, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C82  : S15308C83 {
  ::S15308C90 s15308c82f0;
};
//SIG(-1 S15308C82) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC6} FC8{ BC9{}}} FC8}



static void Test_S15308C82()
{
  extern Class_Descriptor cd_S15308C82;
  void *lvp;
  {
    char buf[4];
    init_test(&cd_S15308C82, buf);
    S15308C82 &lv = *(new (buf) S15308C82());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(S15308C82)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C82)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C85*)(S15308C84*)(S15308C83*), 0, "S15308C82");
    check_base_class_offset(lv, (S15308C85*)(S15308C84*)(S15308C83*), 0, "S15308C82");
    check_base_class_offset(lv, (S15308C84*)(S15308C83*), 0, "S15308C82");
    check_base_class_offset(lv, (S15308C83*), 0, "S15308C82");
    check_field_offset(lv, s15308c82f0, 3, "S15308C82.s15308c82f0");
    test_class_info(&lv, &cd_S15308C82);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C82(Test_S15308C82, "S15308C82", 4);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C85;
extern Class_Descriptor cd_S15308C84;
extern Class_Descriptor cd_S15308C83;
static Base_Class bases_S15308C82[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C85,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C84,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C83,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C82 = {  "S15308C82", // class name
  bases_S15308C82, 4,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C81  : S15308C82 {
  void *s15308c81f0;
  int s15308c81f1;
};
//SIG(-1 S15308C81) C1{ BC2{ BC3{ BC4{ BC5{ BC6{} FC7{ BC8{}}} FC7} FC9{ BC10{}}} FC9} Fp Fi}



static void Test_S15308C81()
{
  extern Class_Descriptor cd_S15308C81;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C81, buf);
    S15308C81 &lv = *(new (buf) S15308C81());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C81)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C81)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C85*)(S15308C84*)(S15308C83*)(S15308C82*), 0, "S15308C81");
    check_base_class_offset(lv, (S15308C85*)(S15308C84*)(S15308C83*)(S15308C82*), 0, "S15308C81");
    check_base_class_offset(lv, (S15308C84*)(S15308C83*)(S15308C82*), 0, "S15308C81");
    check_base_class_offset(lv, (S15308C83*)(S15308C82*), 0, "S15308C81");
    check_base_class_offset(lv, (S15308C82*), 0, "S15308C81");
    check_field_offset(lv, s15308c81f0, ABISELECT(8,4), "S15308C81.s15308c81f0");
    check_field_offset(lv, s15308c81f1, ABISELECT(16,8), "S15308C81.s15308c81f1");
    test_class_info(&lv, &cd_S15308C81);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C81(Test_S15308C81, "S15308C81", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C85;
extern Class_Descriptor cd_S15308C84;
extern Class_Descriptor cd_S15308C83;
extern Class_Descriptor cd_S15308C82;
static Base_Class bases_S15308C81[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C85,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C84,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C83,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C81 = {  "S15308C81", // class name
  bases_S15308C81, 5,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C80  : S15308C81 {
};
//SIG(-1 S15308C80) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{} FC8{ BC9{}}} FC8} FC10{ BC11{}}} FC10} Fp Fi}}



static void Test_S15308C80()
{
  extern Class_Descriptor cd_S15308C80;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C80, buf);
    S15308C80 &lv = *(new (buf) S15308C80());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C80)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C80)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C85*)(S15308C84*)(S15308C83*)(S15308C82*)(S15308C81*), 0, "S15308C80");
    check_base_class_offset(lv, (S15308C85*)(S15308C84*)(S15308C83*)(S15308C82*)(S15308C81*), 0, "S15308C80");
    check_base_class_offset(lv, (S15308C84*)(S15308C83*)(S15308C82*)(S15308C81*), 0, "S15308C80");
    check_base_class_offset(lv, (S15308C83*)(S15308C82*)(S15308C81*), 0, "S15308C80");
    check_base_class_offset(lv, (S15308C82*)(S15308C81*), 0, "S15308C80");
    check_base_class_offset(lv, (S15308C81*), 0, "S15308C80");
    test_class_info(&lv, &cd_S15308C80);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C80(Test_S15308C80, "S15308C80", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C85;
extern Class_Descriptor cd_S15308C84;
extern Class_Descriptor cd_S15308C83;
extern Class_Descriptor cd_S15308C82;
extern Class_Descriptor cd_S15308C81;
static Base_Class bases_S15308C80[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C85,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C84,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C83,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C82,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S15308C81,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C80 = {  "S15308C80", // class name
  bases_S15308C80, 6,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C94  {
  char s15308c94f0;
  int s15308c94f1;
  int s15308c94f2;
  ::S15308C2_nt s15308c94f3;
  void  mf15308c94(); // _ZN9S15308C9410mf15308c94Ev
};
//SIG(-1 S15308C94) C1{ m Fc Fi[2] FC2{ BC3{ BC4{ BC5{}} FC6{ BC7{}}} FU8{ Fc[16] Fp} Fi Fi}}


void  S15308C94 ::mf15308c94(){}

static void Test_S15308C94()
{
  {
    init_simple_test("S15308C94");
    S15308C94 lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S15308C94)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C94)");
    check_field_offset(lv, s15308c94f0, 0, "S15308C94.s15308c94f0");
    check_field_offset(lv, s15308c94f1, 4, "S15308C94.s15308c94f1");
    check_field_offset(lv, s15308c94f2, 8, "S15308C94.s15308c94f2");
    check_field_offset(lv, s15308c94f3, ABISELECT(16,12), "S15308C94.s15308c94f3");
  }
}
static Arrange_To_Call_Me vS15308C94(Test_S15308C94, "S15308C94", ABISELECT(48,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C110_nt  {
  virtual  ~S15308C110_nt(); // _ZN13S15308C110_ntD1Ev
  virtual void  v5(); // _ZN13S15308C110_nt2v5Ev
  virtual void  v6(); // _ZN13S15308C110_nt2v6Ev
  virtual void  v7(); // _ZN13S15308C110_nt2v7Ev
  virtual void  v8(); // _ZN13S15308C110_nt2v8Ev
  virtual void  v9(); // _ZN13S15308C110_nt2v9Ev
  S15308C110_nt(); // tgen
};
//SIG(-1 S15308C110_nt) C1{ vd v1 v2 v3 v4 v5}


 S15308C110_nt ::~S15308C110_nt(){ note_dtor("S15308C110_nt", this);}
void  S15308C110_nt ::v5(){vfunc_called(this, "_ZN13S15308C110_nt2v5Ev");}
void  S15308C110_nt ::v6(){vfunc_called(this, "_ZN13S15308C110_nt2v6Ev");}
void  S15308C110_nt ::v7(){vfunc_called(this, "_ZN13S15308C110_nt2v7Ev");}
void  S15308C110_nt ::v8(){vfunc_called(this, "_ZN13S15308C110_nt2v8Ev");}
void  S15308C110_nt ::v9(){vfunc_called(this, "_ZN13S15308C110_nt2v9Ev");}
S15308C110_nt ::S15308C110_nt(){ note_ctor("S15308C110_nt", this);} // tgen

//skip512 S15308C110_nt

#else // __cplusplus

extern void _ZN13S15308C110_ntC1Ev();
extern void _ZN13S15308C110_ntD1Ev();
Name_Map name_map_S15308C110_nt[] = {
  NSPAIR(_ZN13S15308C110_ntC1Ev),
  NSPAIR(_ZN13S15308C110_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI13S15308C110_nt[];
extern void _ZN13S15308C110_ntD1Ev();
extern void _ZN13S15308C110_ntD0Ev();
extern void _ZN13S15308C110_nt2v5Ev();
extern void _ZN13S15308C110_nt2v6Ev();
extern void _ZN13S15308C110_nt2v7Ev();
extern void _ZN13S15308C110_nt2v8Ev();
extern void _ZN13S15308C110_nt2v9Ev();
static  VTBL_ENTRY vtc_S15308C110_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI13S15308C110_nt[0]),
  (VTBL_ENTRY)&_ZN13S15308C110_ntD1Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_ntD0Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_nt2v5Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_nt2v6Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_nt2v7Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_nt2v8Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_nt2v9Ev,
};
extern VTBL_ENTRY _ZTI13S15308C110_nt[];
VTBL_ENTRY *P__ZTI13S15308C110_nt = _ZTI13S15308C110_nt; 
extern  VTBL_ENTRY _ZTV13S15308C110_nt[];
Class_Descriptor cd_S15308C110_nt = {  "S15308C110_nt", // class name
  0,0,//no base classes
  &(vtc_S15308C110_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI13S15308C110_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV13S15308C110_nt),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C111  {
  char s15308c111f0[64];
  char s15308c111f1;
};
//SIG(1 S15308C111) C1{ Fc[65]}



static void Test_S15308C111()
{
  {
    init_simple_test("S15308C111");
    S15308C111 lv;
    check2(sizeof(lv), 65, "sizeof(S15308C111)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C111)");
    check_field_offset(lv, s15308c111f0, 0, "S15308C111.s15308c111f0");
    check_field_offset(lv, s15308c111f1, 64, "S15308C111.s15308c111f1");
  }
}
static Arrange_To_Call_Me vS15308C111(Test_S15308C111, "S15308C111", 65);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C112  {
  int s15308c112f0;
  void *s15308c112f1;
  int s15308c112f2;
  int s15308c112f3;
};
//SIG(1 S15308C112) C1{ Fi Fp Fi[2]}



static void Test_S15308C112()
{
  {
    init_simple_test("S15308C112");
    S15308C112 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S15308C112)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C112)");
    check_field_offset(lv, s15308c112f0, 0, "S15308C112.s15308c112f0");
    check_field_offset(lv, s15308c112f1, ABISELECT(8,4), "S15308C112.s15308c112f1");
    check_field_offset(lv, s15308c112f2, ABISELECT(16,8), "S15308C112.s15308c112f2");
    check_field_offset(lv, s15308c112f3, ABISELECT(20,12), "S15308C112.s15308c112f3");
  }
}
static Arrange_To_Call_Me vS15308C112(Test_S15308C112, "S15308C112", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C113  {
  void *s15308c113f0;
  void *s15308c113f1;
  void *s15308c113f2;
  int s15308c113f3;
  int s15308c113f4;
};
//SIG(1 S15308C113) C1{ Fp[3] Fi[2]}



static void Test_S15308C113()
{
  {
    init_simple_test("S15308C113");
    S15308C113 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S15308C113)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C113)");
    check_field_offset(lv, s15308c113f0, 0, "S15308C113.s15308c113f0");
    check_field_offset(lv, s15308c113f1, ABISELECT(8,4), "S15308C113.s15308c113f1");
    check_field_offset(lv, s15308c113f2, ABISELECT(16,8), "S15308C113.s15308c113f2");
    check_field_offset(lv, s15308c113f3, ABISELECT(24,12), "S15308C113.s15308c113f3");
    check_field_offset(lv, s15308c113f4, ABISELECT(28,16), "S15308C113.s15308c113f4");
  }
}
static Arrange_To_Call_Me vS15308C113(Test_S15308C113, "S15308C113", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C114  {
  void *s15308c114f0;
  int s15308c114f1;
  void *s15308c114f2;
};
//SIG(-1 S15308C114) C1{ Fp Fi Fp}



static void Test_S15308C114()
{
  {
    init_simple_test("S15308C114");
    S15308C114 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C114)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C114)");
    check_field_offset(lv, s15308c114f0, 0, "S15308C114.s15308c114f0");
    check_field_offset(lv, s15308c114f1, ABISELECT(8,4), "S15308C114.s15308c114f1");
    check_field_offset(lv, s15308c114f2, ABISELECT(16,8), "S15308C114.s15308c114f2");
  }
}
static Arrange_To_Call_Me vS15308C114(Test_S15308C114, "S15308C114", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C115  {
  void *s15308c115f0;
  void  mf15308c115(); // _ZN10S15308C11511mf15308c115Ev
};
//SIG(-1 S15308C115) C1{ m Fp}


void  S15308C115 ::mf15308c115(){}

static void Test_S15308C115()
{
  {
    init_simple_test("S15308C115");
    S15308C115 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S15308C115)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C115)");
    check_field_offset(lv, s15308c115f0, 0, "S15308C115.s15308c115f0");
  }
}
static Arrange_To_Call_Me vS15308C115(Test_S15308C115, "S15308C115", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C117  {
  void *s15308c117f0;
  void  mf15308c117(); // _ZN10S15308C11711mf15308c117Ev
};
//SIG(-1 S15308C117) C1{ m Fp}


void  S15308C117 ::mf15308c117(){}

static void Test_S15308C117()
{
  {
    init_simple_test("S15308C117");
    S15308C117 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S15308C117)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C117)");
    check_field_offset(lv, s15308c117f0, 0, "S15308C117.s15308c117f0");
  }
}
static Arrange_To_Call_Me vS15308C117(Test_S15308C117, "S15308C117", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C109  : S15308C110_nt {
  ::S15308C111 s15308c109f0[16];
  int s15308c109f1;
  int s15308c109f2;
  int s15308c109f3;
  int s15308c109f4[16];
  ::S15308C112 s15308c109f5[2];
  ::S15308C113 s15308c109f6[11];
  char s15308c109f7;
  ::S15308C114 s15308c109f8[16];
  void *s15308c109f9;
  void *s15308c109f10;
  void *s15308c109f11;
  ::S15308C115 s15308c109f12;
  ::S15308C115 s15308c109f13;
  ::S15308C115 s15308c109f14[2];
  ::S15308C115 s15308c109f15;
  ::S15308C115 s15308c109f16;
  ::S15308C115 s15308c109f17;
  ::S15308C117 s15308c109f18;
  ::S15308C117 s15308c109f19;
  int s15308c109f20;
  int s15308c109f21;
  int s15308c109f22;
  int s15308c109f23;
  virtual  ~S15308C109(); // _ZN10S15308C109D1Ev
  virtual void  v1(); // _ZN10S15308C1092v1Ev
  virtual void  v2(); // _ZN10S15308C1092v2Ev
  virtual void  v3(); // _ZN10S15308C1092v3Ev
  virtual void  v4(); // _ZN10S15308C1092v4Ev
  S15308C109(); // tgen
};
//SIG(-1 S15308C109) C1{ BC2{ vd v5 v6 v7 v8 v9} vd v1 v2 v3 v4 FC3{ Fc[65]}[16] Fi[19] FC4{ Fi Fp Fi[2]}[2] FC5{ Fp[3] Fi[2]}[11] Fc FC6{ Fp Fi Fp}[16] Fp[3] FC7{ m Fp} FC7 FC7[2] FC7 FC7 FC7 FC8{ m Fp} FC8 Fi[4]}


 S15308C109 ::~S15308C109(){ note_dtor("S15308C109", this);}
void  S15308C109 ::v1(){vfunc_called(this, "_ZN10S15308C1092v1Ev");}
void  S15308C109 ::v2(){vfunc_called(this, "_ZN10S15308C1092v2Ev");}
void  S15308C109 ::v3(){vfunc_called(this, "_ZN10S15308C1092v3Ev");}
void  S15308C109 ::v4(){vfunc_called(this, "_ZN10S15308C1092v4Ev");}
S15308C109 ::S15308C109(){ note_ctor("S15308C109", this);} // tgen

static void Test_S15308C109()
{
  extern Class_Descriptor cd_S15308C109;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(255,409)];
    init_test(&cd_S15308C109, buf);
    S15308C109 *dp, &lv = *(dp=new (buf) S15308C109());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2032,1632), "sizeof(S15308C109)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C109)");
    check_base_class_offset(lv, (S15308C110_nt*), 0, "S15308C109");
    check_field_offset(lv, s15308c109f0, ABISELECT(8,4), "S15308C109.s15308c109f0");
    check_field_offset(lv, s15308c109f1, ABISELECT(1048,1044), "S15308C109.s15308c109f1");
    check_field_offset(lv, s15308c109f2, ABISELECT(1052,1048), "S15308C109.s15308c109f2");
    check_field_offset(lv, s15308c109f3, ABISELECT(1056,1052), "S15308C109.s15308c109f3");
    check_field_offset(lv, s15308c109f4, ABISELECT(1060,1056), "S15308C109.s15308c109f4");
    check_field_offset(lv, s15308c109f5, ABISELECT(1128,1120), "S15308C109.s15308c109f5");
    check_field_offset(lv, s15308c109f6, ABISELECT(1176,1152), "S15308C109.s15308c109f6");
    check_field_offset(lv, s15308c109f7, ABISELECT(1528,1372), "S15308C109.s15308c109f7");
    check_field_offset(lv, s15308c109f8, ABISELECT(1536,1376), "S15308C109.s15308c109f8");
    check_field_offset(lv, s15308c109f9, ABISELECT(1920,1568), "S15308C109.s15308c109f9");
    check_field_offset(lv, s15308c109f10, ABISELECT(1928,1572), "S15308C109.s15308c109f10");
    check_field_offset(lv, s15308c109f11, ABISELECT(1936,1576), "S15308C109.s15308c109f11");
    check_field_offset(lv, s15308c109f12, ABISELECT(1944,1580), "S15308C109.s15308c109f12");
    check_field_offset(lv, s15308c109f13, ABISELECT(1952,1584), "S15308C109.s15308c109f13");
    check_field_offset(lv, s15308c109f14, ABISELECT(1960,1588), "S15308C109.s15308c109f14");
    check_field_offset(lv, s15308c109f15, ABISELECT(1976,1596), "S15308C109.s15308c109f15");
    check_field_offset(lv, s15308c109f16, ABISELECT(1984,1600), "S15308C109.s15308c109f16");
    check_field_offset(lv, s15308c109f17, ABISELECT(1992,1604), "S15308C109.s15308c109f17");
    check_field_offset(lv, s15308c109f18, ABISELECT(2000,1608), "S15308C109.s15308c109f18");
    check_field_offset(lv, s15308c109f19, ABISELECT(2008,1612), "S15308C109.s15308c109f19");
    check_field_offset(lv, s15308c109f20, ABISELECT(2016,1616), "S15308C109.s15308c109f20");
    check_field_offset(lv, s15308c109f21, ABISELECT(2020,1620), "S15308C109.s15308c109f21");
    check_field_offset(lv, s15308c109f22, ABISELECT(2024,1624), "S15308C109.s15308c109f22");
    check_field_offset(lv, s15308c109f23, ABISELECT(2028,1628), "S15308C109.s15308c109f23");
    test_class_info(&lv, &cd_S15308C109);
    dp->~S15308C109();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C109(Test_S15308C109, "S15308C109", ABISELECT(2032,1632));

#else // __cplusplus

extern void _ZN10S15308C109C1Ev();
extern void _ZN10S15308C109D1Ev();
Name_Map name_map_S15308C109[] = {
  NSPAIR(_ZN10S15308C109C1Ev),
  NSPAIR(_ZN10S15308C109D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S15308C110_nt;
extern VTBL_ENTRY _ZTI13S15308C110_nt[];
extern  VTBL_ENTRY _ZTV13S15308C110_nt[];
static Base_Class bases_S15308C109[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C110_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S15308C109[];
extern void _ZN10S15308C109D1Ev();
extern void _ZN10S15308C109D0Ev();
extern void _ZN13S15308C110_nt2v5Ev();
extern void _ZN13S15308C110_nt2v6Ev();
extern void _ZN13S15308C110_nt2v7Ev();
extern void _ZN13S15308C110_nt2v8Ev();
extern void _ZN13S15308C110_nt2v9Ev();
extern void _ZN10S15308C1092v1Ev();
extern void _ZN10S15308C1092v2Ev();
extern void _ZN10S15308C1092v3Ev();
extern void _ZN10S15308C1092v4Ev();
static  VTBL_ENTRY vtc_S15308C109[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S15308C109[0]),
  (VTBL_ENTRY)&_ZN10S15308C109D1Ev,
  (VTBL_ENTRY)&_ZN10S15308C109D0Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_nt2v5Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_nt2v6Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_nt2v7Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_nt2v8Ev,
  (VTBL_ENTRY)&_ZN13S15308C110_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S15308C1092v1Ev,
  (VTBL_ENTRY)&_ZN10S15308C1092v2Ev,
  (VTBL_ENTRY)&_ZN10S15308C1092v3Ev,
  (VTBL_ENTRY)&_ZN10S15308C1092v4Ev,
};
extern VTBL_ENTRY _ZTI10S15308C109[];
extern  VTBL_ENTRY _ZTV10S15308C109[];
Class_Descriptor cd_S15308C109 = {  "S15308C109", // class name
  bases_S15308C109, 1,
  &(vtc_S15308C109[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2032,1632), // object size
  NSPAIRA(_ZTI10S15308C109),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S15308C109),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C121  {
};
//SIG(-1 S15308C121) C1{}



static void Test_S15308C121()
{
  {
    init_simple_test("S15308C121");
    S15308C121 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C121)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C121)");
  }
}
static Arrange_To_Call_Me vS15308C121(Test_S15308C121, "S15308C121", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C121 = {  "S15308C121", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C120  : S15308C121 {
};
//SIG(-1 S15308C120) C1{ BC2{}}



static void Test_S15308C120()
{
  extern Class_Descriptor cd_S15308C120;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C120, buf);
    S15308C120 &lv = *(new (buf) S15308C120());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C120)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C120)");
    check_base_class_offset(lv, (S15308C121*), 0, "S15308C120");
    test_class_info(&lv, &cd_S15308C120);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C120(Test_S15308C120, "S15308C120", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C121;
static Base_Class bases_S15308C120[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C121,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C120 = {  "S15308C120", // class name
  bases_S15308C120, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C119  : S15308C5_nt {
  ::S15308C120 s15308c119f0;
};
//SIG(-1 S15308C119) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C119()
{
  extern Class_Descriptor cd_S15308C119;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C119, buf);
    S15308C119 &lv = *(new (buf) S15308C119());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C119)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C119)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C119");
    check_field_offset(lv, s15308c119f0, 0, "S15308C119.s15308c119f0");
    test_class_info(&lv, &cd_S15308C119);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C119(Test_S15308C119, "S15308C119", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C119[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C119 = {  "S15308C119", // class name
  bases_S15308C119, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C118  : S15308C119 {
  void *s15308c118f0;
  void *s15308c118f1;
  void *s15308c118f2;
};
//SIG(-1 S15308C118) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S15308C118()
{
  extern Class_Descriptor cd_S15308C118;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S15308C118, buf);
    S15308C118 &lv = *(new (buf) S15308C118());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S15308C118)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C118)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C119*), 0, "S15308C118");
    check_base_class_offset(lv, (S15308C119*), 0, "S15308C118");
    check_field_offset(lv, s15308c118f0, ABISELECT(8,4), "S15308C118.s15308c118f0");
    check_field_offset(lv, s15308c118f1, ABISELECT(16,8), "S15308C118.s15308c118f1");
    check_field_offset(lv, s15308c118f2, ABISELECT(24,12), "S15308C118.s15308c118f2");
    test_class_info(&lv, &cd_S15308C118);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C118(Test_S15308C118, "S15308C118", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C119;
static Base_Class bases_S15308C118[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C119,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C118 = {  "S15308C118", // class name
  bases_S15308C118, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C127  : S15308C5_nt {
  ::S15308C60 s15308c127f0;
};
//SIG(-1 S15308C127) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C127()
{
  extern Class_Descriptor cd_S15308C127;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C127, buf);
    S15308C127 &lv = *(new (buf) S15308C127());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C127)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C127)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C127");
    check_field_offset(lv, s15308c127f0, 0, "S15308C127.s15308c127f0");
    test_class_info(&lv, &cd_S15308C127);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C127(Test_S15308C127, "S15308C127", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C127[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C127 = {  "S15308C127", // class name
  bases_S15308C127, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C126  : S15308C127 {
  ::S15308C120 s15308c126f0;
};
//SIG(-1 S15308C126) C1{ BC2{ BC3{} FC4{ BC5{}}} FC6{ BC7{}}}



static void Test_S15308C126()
{
  extern Class_Descriptor cd_S15308C126;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S15308C126, buf);
    S15308C126 &lv = *(new (buf) S15308C126());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S15308C126)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C126)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C127*), 0, "S15308C126");
    check_base_class_offset(lv, (S15308C127*), 0, "S15308C126");
    check_field_offset(lv, s15308c126f0, 1, "S15308C126.s15308c126f0");
    test_class_info(&lv, &cd_S15308C126);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C126(Test_S15308C126, "S15308C126", 2);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C127;
static Base_Class bases_S15308C126[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C127,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C126 = {  "S15308C126", // class name
  bases_S15308C126, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C131  {
};
//SIG(-1 S15308C131) C1{}



static void Test_S15308C131()
{
  {
    init_simple_test("S15308C131");
    S15308C131 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C131)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C131)");
  }
}
static Arrange_To_Call_Me vS15308C131(Test_S15308C131, "S15308C131", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C131 = {  "S15308C131", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C130  : S15308C131 {
};
//SIG(-1 S15308C130) C1{ BC2{}}



static void Test_S15308C130()
{
  extern Class_Descriptor cd_S15308C130;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C130, buf);
    S15308C130 &lv = *(new (buf) S15308C130());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C130)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C130)");
    check_base_class_offset(lv, (S15308C131*), 0, "S15308C130");
    test_class_info(&lv, &cd_S15308C130);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C130(Test_S15308C130, "S15308C130", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C131;
static Base_Class bases_S15308C130[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C131,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C130 = {  "S15308C130", // class name
  bases_S15308C130, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C125  : S15308C126 {
  ::S15308C130 s15308c125f0;
};
//SIG(-1 S15308C125) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC7{ BC8{}}} FC9{ BC10{}}}



static void Test_S15308C125()
{
  extern Class_Descriptor cd_S15308C125;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S15308C125, buf);
    S15308C125 &lv = *(new (buf) S15308C125());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S15308C125)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C125)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C127*)(S15308C126*), 0, "S15308C125");
    check_base_class_offset(lv, (S15308C127*)(S15308C126*), 0, "S15308C125");
    check_base_class_offset(lv, (S15308C126*), 0, "S15308C125");
    check_field_offset(lv, s15308c125f0, 2, "S15308C125.s15308c125f0");
    test_class_info(&lv, &cd_S15308C125);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C125(Test_S15308C125, "S15308C125", 3);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C127;
extern Class_Descriptor cd_S15308C126;
static Base_Class bases_S15308C125[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C127,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C126,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C125 = {  "S15308C125", // class name
  bases_S15308C125, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C124  : S15308C125 {
  ::S15308C130 s15308c124f0;
};
//SIG(-1 S15308C124) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC8{ BC9{}}} FC10{ BC11{}}} FC10}



static void Test_S15308C124()
{
  extern Class_Descriptor cd_S15308C124;
  void *lvp;
  {
    char buf[4];
    init_test(&cd_S15308C124, buf);
    S15308C124 &lv = *(new (buf) S15308C124());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(S15308C124)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C124)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C127*)(S15308C126*)(S15308C125*), 0, "S15308C124");
    check_base_class_offset(lv, (S15308C127*)(S15308C126*)(S15308C125*), 0, "S15308C124");
    check_base_class_offset(lv, (S15308C126*)(S15308C125*), 0, "S15308C124");
    check_base_class_offset(lv, (S15308C125*), 0, "S15308C124");
    check_field_offset(lv, s15308c124f0, 3, "S15308C124.s15308c124f0");
    test_class_info(&lv, &cd_S15308C124);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C124(Test_S15308C124, "S15308C124", 4);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C127;
extern Class_Descriptor cd_S15308C126;
extern Class_Descriptor cd_S15308C125;
static Base_Class bases_S15308C124[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C127,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C126,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C125,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C124 = {  "S15308C124", // class name
  bases_S15308C124, 4,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C123  : S15308C124 {
  void *s15308c123f0;
  int s15308c123f1;
};
//SIG(-1 S15308C123) C1{ BC2{ BC3{ BC4{ BC5{ BC6{} FC7{ BC8{}}} FC9{ BC10{}}} FC11{ BC12{}}} FC11} Fp Fi}



static void Test_S15308C123()
{
  extern Class_Descriptor cd_S15308C123;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C123, buf);
    S15308C123 &lv = *(new (buf) S15308C123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C123)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C123)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C127*)(S15308C126*)(S15308C125*)(S15308C124*), 0, "S15308C123");
    check_base_class_offset(lv, (S15308C127*)(S15308C126*)(S15308C125*)(S15308C124*), 0, "S15308C123");
    check_base_class_offset(lv, (S15308C126*)(S15308C125*)(S15308C124*), 0, "S15308C123");
    check_base_class_offset(lv, (S15308C125*)(S15308C124*), 0, "S15308C123");
    check_base_class_offset(lv, (S15308C124*), 0, "S15308C123");
    check_field_offset(lv, s15308c123f0, ABISELECT(8,4), "S15308C123.s15308c123f0");
    check_field_offset(lv, s15308c123f1, ABISELECT(16,8), "S15308C123.s15308c123f1");
    test_class_info(&lv, &cd_S15308C123);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C123(Test_S15308C123, "S15308C123", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C127;
extern Class_Descriptor cd_S15308C126;
extern Class_Descriptor cd_S15308C125;
extern Class_Descriptor cd_S15308C124;
static Base_Class bases_S15308C123[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C127,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C126,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C125,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C124,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C123 = {  "S15308C123", // class name
  bases_S15308C123, 5,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C122  : S15308C123 {
};
//SIG(-1 S15308C122) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{} FC8{ BC9{}}} FC10{ BC11{}}} FC12{ BC13{}}} FC12} Fp Fi}}



static void Test_S15308C122()
{
  extern Class_Descriptor cd_S15308C122;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C122, buf);
    S15308C122 &lv = *(new (buf) S15308C122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C122)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C122)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C127*)(S15308C126*)(S15308C125*)(S15308C124*)(S15308C123*), 0, "S15308C122");
    check_base_class_offset(lv, (S15308C127*)(S15308C126*)(S15308C125*)(S15308C124*)(S15308C123*), 0, "S15308C122");
    check_base_class_offset(lv, (S15308C126*)(S15308C125*)(S15308C124*)(S15308C123*), 0, "S15308C122");
    check_base_class_offset(lv, (S15308C125*)(S15308C124*)(S15308C123*), 0, "S15308C122");
    check_base_class_offset(lv, (S15308C124*)(S15308C123*), 0, "S15308C122");
    check_base_class_offset(lv, (S15308C123*), 0, "S15308C122");
    test_class_info(&lv, &cd_S15308C122);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C122(Test_S15308C122, "S15308C122", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C127;
extern Class_Descriptor cd_S15308C126;
extern Class_Descriptor cd_S15308C125;
extern Class_Descriptor cd_S15308C124;
extern Class_Descriptor cd_S15308C123;
static Base_Class bases_S15308C122[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C127,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C126,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C125,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C124,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S15308C123,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C122 = {  "S15308C122", // class name
  bases_S15308C122, 6,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C151  : S15308C5_nt {
  ::S15308C60 s15308c151f0;
};
//SIG(-1 S15308C151) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C151()
{
  extern Class_Descriptor cd_S15308C151;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C151, buf);
    S15308C151 &lv = *(new (buf) S15308C151());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C151)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C151)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C151");
    check_field_offset(lv, s15308c151f0, 0, "S15308C151.s15308c151f0");
    test_class_info(&lv, &cd_S15308C151);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C151(Test_S15308C151, "S15308C151", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C151[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C151 = {  "S15308C151", // class name
  bases_S15308C151, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C153  {
};
//SIG(-1 S15308C153) C1{}



static void Test_S15308C153()
{
  {
    init_simple_test("S15308C153");
    S15308C153 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C153)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C153)");
  }
}
static Arrange_To_Call_Me vS15308C153(Test_S15308C153, "S15308C153", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C153 = {  "S15308C153", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C152  : S15308C153 {
};
//SIG(-1 S15308C152) C1{ BC2{}}



static void Test_S15308C152()
{
  extern Class_Descriptor cd_S15308C152;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C152, buf);
    S15308C152 &lv = *(new (buf) S15308C152());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C152)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C152)");
    check_base_class_offset(lv, (S15308C153*), 0, "S15308C152");
    test_class_info(&lv, &cd_S15308C152);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C152(Test_S15308C152, "S15308C152", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C153;
static Base_Class bases_S15308C152[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C153,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C152 = {  "S15308C152", // class name
  bases_S15308C152, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C150  : S15308C151 {
  ::S15308C152 s15308c150f0;
};
//SIG(-1 S15308C150) C1{ BC2{ BC3{} FC4{ BC5{}}} FC6{ BC7{}}}



static void Test_S15308C150()
{
  extern Class_Descriptor cd_S15308C150;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S15308C150, buf);
    S15308C150 &lv = *(new (buf) S15308C150());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S15308C150)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C150)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C151*), 0, "S15308C150");
    check_base_class_offset(lv, (S15308C151*), 0, "S15308C150");
    check_field_offset(lv, s15308c150f0, 1, "S15308C150.s15308c150f0");
    test_class_info(&lv, &cd_S15308C150);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C150(Test_S15308C150, "S15308C150", 2);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C151;
static Base_Class bases_S15308C150[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C151,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C150 = {  "S15308C150", // class name
  bases_S15308C150, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C149  : S15308C150 {
  ::S15308C152 s15308c149f0;
};
//SIG(-1 S15308C149) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC7{ BC8{}}} FC7}



static void Test_S15308C149()
{
  extern Class_Descriptor cd_S15308C149;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S15308C149, buf);
    S15308C149 &lv = *(new (buf) S15308C149());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S15308C149)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C149)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C151*)(S15308C150*), 0, "S15308C149");
    check_base_class_offset(lv, (S15308C151*)(S15308C150*), 0, "S15308C149");
    check_base_class_offset(lv, (S15308C150*), 0, "S15308C149");
    check_field_offset(lv, s15308c149f0, 2, "S15308C149.s15308c149f0");
    test_class_info(&lv, &cd_S15308C149);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C149(Test_S15308C149, "S15308C149", 3);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C151;
extern Class_Descriptor cd_S15308C150;
static Base_Class bases_S15308C149[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C151,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C149 = {  "S15308C149", // class name
  bases_S15308C149, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C157  {
};
//SIG(-1 S15308C157) C1{}



static void Test_S15308C157()
{
  {
    init_simple_test("S15308C157");
    S15308C157 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C157)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C157)");
  }
}
static Arrange_To_Call_Me vS15308C157(Test_S15308C157, "S15308C157", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C157 = {  "S15308C157", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C156  : S15308C157 {
};
//SIG(-1 S15308C156) C1{ BC2{}}



static void Test_S15308C156()
{
  extern Class_Descriptor cd_S15308C156;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C156, buf);
    S15308C156 &lv = *(new (buf) S15308C156());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C156)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C156)");
    check_base_class_offset(lv, (S15308C157*), 0, "S15308C156");
    test_class_info(&lv, &cd_S15308C156);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C156(Test_S15308C156, "S15308C156", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C157;
static Base_Class bases_S15308C156[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C157,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C156 = {  "S15308C156", // class name
  bases_S15308C156, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C148  : S15308C149 {
  ::S15308C156 s15308c148f0;
};
//SIG(-1 S15308C148) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC8{ BC9{}}} FC8} FC10{ BC11{}}}



static void Test_S15308C148()
{
  extern Class_Descriptor cd_S15308C148;
  void *lvp;
  {
    char buf[4];
    init_test(&cd_S15308C148, buf);
    S15308C148 &lv = *(new (buf) S15308C148());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(S15308C148)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C148)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C151*)(S15308C150*)(S15308C149*), 0, "S15308C148");
    check_base_class_offset(lv, (S15308C151*)(S15308C150*)(S15308C149*), 0, "S15308C148");
    check_base_class_offset(lv, (S15308C150*)(S15308C149*), 0, "S15308C148");
    check_base_class_offset(lv, (S15308C149*), 0, "S15308C148");
    check_field_offset(lv, s15308c148f0, 3, "S15308C148.s15308c148f0");
    test_class_info(&lv, &cd_S15308C148);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C148(Test_S15308C148, "S15308C148", 4);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C151;
extern Class_Descriptor cd_S15308C150;
extern Class_Descriptor cd_S15308C149;
static Base_Class bases_S15308C148[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C151,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C149,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C148 = {  "S15308C148", // class name
  bases_S15308C148, 4,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C147  : S15308C148 {
  void *s15308c147f0;
  int s15308c147f1;
};
//SIG(-1 S15308C147) C1{ BC2{ BC3{ BC4{ BC5{ BC6{} FC7{ BC8{}}} FC9{ BC10{}}} FC9} FC11{ BC12{}}} Fp Fi}



static void Test_S15308C147()
{
  extern Class_Descriptor cd_S15308C147;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C147, buf);
    S15308C147 &lv = *(new (buf) S15308C147());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C147)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C147)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C151*)(S15308C150*)(S15308C149*)(S15308C148*), 0, "S15308C147");
    check_base_class_offset(lv, (S15308C151*)(S15308C150*)(S15308C149*)(S15308C148*), 0, "S15308C147");
    check_base_class_offset(lv, (S15308C150*)(S15308C149*)(S15308C148*), 0, "S15308C147");
    check_base_class_offset(lv, (S15308C149*)(S15308C148*), 0, "S15308C147");
    check_base_class_offset(lv, (S15308C148*), 0, "S15308C147");
    check_field_offset(lv, s15308c147f0, ABISELECT(8,4), "S15308C147.s15308c147f0");
    check_field_offset(lv, s15308c147f1, ABISELECT(16,8), "S15308C147.s15308c147f1");
    test_class_info(&lv, &cd_S15308C147);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C147(Test_S15308C147, "S15308C147", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C151;
extern Class_Descriptor cd_S15308C150;
extern Class_Descriptor cd_S15308C149;
extern Class_Descriptor cd_S15308C148;
static Base_Class bases_S15308C147[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C151,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C149,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C148,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C147 = {  "S15308C147", // class name
  bases_S15308C147, 5,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C146  : S15308C147 {
};
//SIG(-1 S15308C146) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{} FC8{ BC9{}}} FC10{ BC11{}}} FC10} FC12{ BC13{}}} Fp Fi}}



static void Test_S15308C146()
{
  extern Class_Descriptor cd_S15308C146;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C146, buf);
    S15308C146 &lv = *(new (buf) S15308C146());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C146)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C146)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C151*)(S15308C150*)(S15308C149*)(S15308C148*)(S15308C147*), 0, "S15308C146");
    check_base_class_offset(lv, (S15308C151*)(S15308C150*)(S15308C149*)(S15308C148*)(S15308C147*), 0, "S15308C146");
    check_base_class_offset(lv, (S15308C150*)(S15308C149*)(S15308C148*)(S15308C147*), 0, "S15308C146");
    check_base_class_offset(lv, (S15308C149*)(S15308C148*)(S15308C147*), 0, "S15308C146");
    check_base_class_offset(lv, (S15308C148*)(S15308C147*), 0, "S15308C146");
    check_base_class_offset(lv, (S15308C147*), 0, "S15308C146");
    test_class_info(&lv, &cd_S15308C146);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C146(Test_S15308C146, "S15308C146", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C151;
extern Class_Descriptor cd_S15308C150;
extern Class_Descriptor cd_S15308C149;
extern Class_Descriptor cd_S15308C148;
extern Class_Descriptor cd_S15308C147;
static Base_Class bases_S15308C146[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C151,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C150,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C149,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C148,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S15308C147,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C146 = {  "S15308C146", // class name
  bases_S15308C146, 6,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C171  {
  char s15308c171f0;
  void  mf15308c171(); // _ZN10S15308C17111mf15308c171Ev
};
//SIG(-1 S15308C171) C1{ m Fc}


void  S15308C171 ::mf15308c171(){}

static void Test_S15308C171()
{
  {
    init_simple_test("S15308C171");
    S15308C171 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C171)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C171)");
    check_field_offset(lv, s15308c171f0, 0, "S15308C171.s15308c171f0");
  }
}
static Arrange_To_Call_Me vS15308C171(Test_S15308C171, "S15308C171", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C171 = {  "S15308C171", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C173_nt  {
  char s15308c173f0;
  char s15308c173f1[15];
  void  mf15308c173(); // _ZN13S15308C173_nt11mf15308c173Ev
};
//SIG(-1 S15308C173_nt) C1{ m Fc[16]}


void  S15308C173_nt ::mf15308c173(){}

//skip512 S15308C173_nt

#else // __cplusplus

Class_Descriptor cd_S15308C173_nt = {  "S15308C173_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C172  : S15308C173_nt {
};
//SIG(-1 S15308C172) C1{ BC2{ m Fc[16]}}



static void Test_S15308C172()
{
  extern Class_Descriptor cd_S15308C172;
  void *lvp;
  {
    char buf[16];
    init_test(&cd_S15308C172, buf);
    S15308C172 &lv = *(new (buf) S15308C172());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(S15308C172)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C172)");
    check_base_class_offset(lv, (S15308C173_nt*), 0, "S15308C172");
    test_class_info(&lv, &cd_S15308C172);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C172(Test_S15308C172, "S15308C172", 16);

#else // __cplusplus

extern Class_Descriptor cd_S15308C173_nt;
static Base_Class bases_S15308C172[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C173_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C172 = {  "S15308C172", // class name
  bases_S15308C172, 1,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C170  : S15308C171 {
  ::S15308C172 s15308c170f0;
  ::S15308C172 s15308c170f1;
  int s15308c170f2;
};
//SIG(-1 S15308C170) C1{ BC2{ m Fc} FC3{ BC4{ m Fc[16]}} FC3 Fi}



static void Test_S15308C170()
{
  extern Class_Descriptor cd_S15308C170;
  void *lvp;
  {
    int buf[11];
    init_test(&cd_S15308C170, buf);
    S15308C170 &lv = *(new (buf) S15308C170());
    lvp = (void*)&lv;
    check2(sizeof(lv), 40, "sizeof(S15308C170)");
    check2(__alignof__(lv), 4, "__alignof__(S15308C170)");
    check_base_class_offset(lv, (S15308C171*), 0, "S15308C170");
    check_field_offset(lv, s15308c170f0, 1, "S15308C170.s15308c170f0");
    check_field_offset(lv, s15308c170f1, 17, "S15308C170.s15308c170f1");
    check_field_offset(lv, s15308c170f2, 36, "S15308C170.s15308c170f2");
    test_class_info(&lv, &cd_S15308C170);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C170(Test_S15308C170, "S15308C170", 40);

#else // __cplusplus

extern Class_Descriptor cd_S15308C171;
static Base_Class bases_S15308C170[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C171,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C170 = {  "S15308C170", // class name
  bases_S15308C170, 1,
  0, // no vftv
  0, //no vtt
  40, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C108  {
  void *s15308c108f0;
  ::S15308C109 s15308c108f1;
  ::S15308C118 s15308c108f2;
  ::S15308C9_nt s15308c108f3;
  ::S15308C10_nt s15308c108f4;
  ::S15308C122 s15308c108f5;
  int s15308c108f6;
  int s15308c108f7;
  int s15308c108f8;
  int s15308c108f9;
  int s15308c108f10;
  int s15308c108f11;
  int s15308c108f12;
  int s15308c108f13;
  int s15308c108f14;
  void *s15308c108f15;
  char s15308c108f16;
  int s15308c108f17;
  char s15308c108f18;
  ::S15308C122 s15308c108f19;
  char s15308c108f20;
  int s15308c108f21;
  char s15308c108f22;
  int s15308c108f23;
  ::S15308C11_nt s15308c108f24;
  ::S15308C146 s15308c108f25;
  ::S15308C146 s15308c108f26;
  int s15308c108f27;
  int s15308c108f28;
  char s15308c108f29;
  ::S15308C170 s15308c108f30;
  ::S15308C170 s15308c108f31;
  char s15308c108f32;
  char s15308c108f33;
  char s15308c108f34;
  int s15308c108f35;
  int s15308c108f36;
  int s15308c108f37;
  char s15308c108f38;
  char s15308c108f39;
  void  mf15308c108(); // _ZN10S15308C10811mf15308c108Ev
};
//SIG(-1 S15308C108) C1{ m Fp FC2{ BC3{ vd v5 v6 v7 v8 v9} vd v1 v2 v3 v4 FC4{ Fc[65]}[16] Fi[19] FC5{ Fi Fp Fi[2]}[2] FC6{ Fp[3] Fi[2]}[11] Fc FC7{ Fp Fi Fp}[16] Fp[3] FC8{ m Fp} FC8 FC8[2] FC8 FC8 FC8 FC9{ m Fp} FC9 Fi[4]} FC10{ BC11{ BC12{} FC13{ BC14{}}} Fp[3]} FC15{ m FL} FC16{ m Fp} FC17{ BC18{ BC19{ BC20{ BC21{ BC22{ BC12 FC23{ BC24{}}} FC13} FC25{ BC26{}}} FC25} Fp Fi}} Fi[9] Fp Fc Fi Fc FC17 Fc Fi Fc Fi FC27{ BC28{ BC12 FC29{ BC30{}}} Fp[3]} FC31{ BC32{ BC33{ BC34{ BC35{ BC36{ BC12 FC23} FC37{ BC38{}}} FC37} FC39{ BC40{}}} Fp Fi}} FC31 Fi[2] Fc FC41{ BC42{ m Fc} FC43{ BC44{ m Fc[16]}} FC43 Fi} FC41 Fc[3] Fi[3] Fc[2]}


void  S15308C108 ::mf15308c108(){}

static void Test_S15308C108()
{
  {
    init_simple_test("S15308C108");
    S15308C108 lv;
    check2(sizeof(lv), ABISELECT(2408,1908), "sizeof(S15308C108)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C108)");
    check_field_offset(lv, s15308c108f0, 0, "S15308C108.s15308c108f0");
    check_field_offset(lv, s15308c108f1, ABISELECT(8,4), "S15308C108.s15308c108f1");
    check_field_offset(lv, s15308c108f2, ABISELECT(2040,1636), "S15308C108.s15308c108f2");
    check_field_offset(lv, s15308c108f3, ABISELECT(2072,1652), "S15308C108.s15308c108f3");
    check_field_offset(lv, s15308c108f4, ABISELECT(2080,1660), "S15308C108.s15308c108f4");
    check_field_offset(lv, s15308c108f5, ABISELECT(2088,1664), "S15308C108.s15308c108f5");
    check_field_offset(lv, s15308c108f6, ABISELECT(2112,1676), "S15308C108.s15308c108f6");
    check_field_offset(lv, s15308c108f7, ABISELECT(2116,1680), "S15308C108.s15308c108f7");
    check_field_offset(lv, s15308c108f8, ABISELECT(2120,1684), "S15308C108.s15308c108f8");
    check_field_offset(lv, s15308c108f9, ABISELECT(2124,1688), "S15308C108.s15308c108f9");
    check_field_offset(lv, s15308c108f10, ABISELECT(2128,1692), "S15308C108.s15308c108f10");
    check_field_offset(lv, s15308c108f11, ABISELECT(2132,1696), "S15308C108.s15308c108f11");
    check_field_offset(lv, s15308c108f12, ABISELECT(2136,1700), "S15308C108.s15308c108f12");
    check_field_offset(lv, s15308c108f13, ABISELECT(2140,1704), "S15308C108.s15308c108f13");
    check_field_offset(lv, s15308c108f14, ABISELECT(2144,1708), "S15308C108.s15308c108f14");
    check_field_offset(lv, s15308c108f15, ABISELECT(2152,1712), "S15308C108.s15308c108f15");
    check_field_offset(lv, s15308c108f16, ABISELECT(2160,1716), "S15308C108.s15308c108f16");
    check_field_offset(lv, s15308c108f17, ABISELECT(2164,1720), "S15308C108.s15308c108f17");
    check_field_offset(lv, s15308c108f18, ABISELECT(2168,1724), "S15308C108.s15308c108f18");
    check_field_offset(lv, s15308c108f19, ABISELECT(2176,1728), "S15308C108.s15308c108f19");
    check_field_offset(lv, s15308c108f20, ABISELECT(2200,1740), "S15308C108.s15308c108f20");
    check_field_offset(lv, s15308c108f21, ABISELECT(2204,1744), "S15308C108.s15308c108f21");
    check_field_offset(lv, s15308c108f22, ABISELECT(2208,1748), "S15308C108.s15308c108f22");
    check_field_offset(lv, s15308c108f23, ABISELECT(2212,1752), "S15308C108.s15308c108f23");
    check_field_offset(lv, s15308c108f24, ABISELECT(2216,1756), "S15308C108.s15308c108f24");
    check_field_offset(lv, s15308c108f25, ABISELECT(2248,1772), "S15308C108.s15308c108f25");
    check_field_offset(lv, s15308c108f26, ABISELECT(2272,1784), "S15308C108.s15308c108f26");
    check_field_offset(lv, s15308c108f27, ABISELECT(2296,1796), "S15308C108.s15308c108f27");
    check_field_offset(lv, s15308c108f28, ABISELECT(2300,1800), "S15308C108.s15308c108f28");
    check_field_offset(lv, s15308c108f29, ABISELECT(2304,1804), "S15308C108.s15308c108f29");
    check_field_offset(lv, s15308c108f30, ABISELECT(2308,1808), "S15308C108.s15308c108f30");
    check_field_offset(lv, s15308c108f31, ABISELECT(2348,1848), "S15308C108.s15308c108f31");
    check_field_offset(lv, s15308c108f32, ABISELECT(2388,1888), "S15308C108.s15308c108f32");
    check_field_offset(lv, s15308c108f33, ABISELECT(2389,1889), "S15308C108.s15308c108f33");
    check_field_offset(lv, s15308c108f34, ABISELECT(2390,1890), "S15308C108.s15308c108f34");
    check_field_offset(lv, s15308c108f35, ABISELECT(2392,1892), "S15308C108.s15308c108f35");
    check_field_offset(lv, s15308c108f36, ABISELECT(2396,1896), "S15308C108.s15308c108f36");
    check_field_offset(lv, s15308c108f37, ABISELECT(2400,1900), "S15308C108.s15308c108f37");
    check_field_offset(lv, s15308c108f38, ABISELECT(2404,1904), "S15308C108.s15308c108f38");
    check_field_offset(lv, s15308c108f39, ABISELECT(2405,1905), "S15308C108.s15308c108f39");
  }
}
static Arrange_To_Call_Me vS15308C108(Test_S15308C108, "S15308C108", ABISELECT(2408,1908));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C179  : S15308C5_nt {
  ::S15308C60 s15308c179f0;
};
//SIG(-1 S15308C179) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C179()
{
  extern Class_Descriptor cd_S15308C179;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C179, buf);
    S15308C179 &lv = *(new (buf) S15308C179());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C179)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C179)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C179");
    check_field_offset(lv, s15308c179f0, 0, "S15308C179.s15308c179f0");
    test_class_info(&lv, &cd_S15308C179);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C179(Test_S15308C179, "S15308C179", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C179[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C179 = {  "S15308C179", // class name
  bases_S15308C179, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C178  : S15308C179 {
  ::S15308C156 s15308c178f0;
};
//SIG(-1 S15308C178) C1{ BC2{ BC3{} FC4{ BC5{}}} FC6{ BC7{}}}



static void Test_S15308C178()
{
  extern Class_Descriptor cd_S15308C178;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S15308C178, buf);
    S15308C178 &lv = *(new (buf) S15308C178());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S15308C178)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C178)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C179*), 0, "S15308C178");
    check_base_class_offset(lv, (S15308C179*), 0, "S15308C178");
    check_field_offset(lv, s15308c178f0, 1, "S15308C178.s15308c178f0");
    test_class_info(&lv, &cd_S15308C178);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C178(Test_S15308C178, "S15308C178", 2);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C179;
static Base_Class bases_S15308C178[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C179,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C178 = {  "S15308C178", // class name
  bases_S15308C178, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C183  {
};
//SIG(-1 S15308C183) C1{}



static void Test_S15308C183()
{
  {
    init_simple_test("S15308C183");
    S15308C183 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C183)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C183)");
  }
}
static Arrange_To_Call_Me vS15308C183(Test_S15308C183, "S15308C183", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C183 = {  "S15308C183", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C182  : S15308C183 {
};
//SIG(-1 S15308C182) C1{ BC2{}}



static void Test_S15308C182()
{
  extern Class_Descriptor cd_S15308C182;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C182, buf);
    S15308C182 &lv = *(new (buf) S15308C182());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C182)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C182)");
    check_base_class_offset(lv, (S15308C183*), 0, "S15308C182");
    test_class_info(&lv, &cd_S15308C182);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C182(Test_S15308C182, "S15308C182", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C183;
static Base_Class bases_S15308C182[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C183,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C182 = {  "S15308C182", // class name
  bases_S15308C182, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C177  : S15308C178 {
  ::S15308C182 s15308c177f0;
};
//SIG(-1 S15308C177) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC7{ BC8{}}} FC9{ BC10{}}}



static void Test_S15308C177()
{
  extern Class_Descriptor cd_S15308C177;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S15308C177, buf);
    S15308C177 &lv = *(new (buf) S15308C177());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S15308C177)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C177)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C179*)(S15308C178*), 0, "S15308C177");
    check_base_class_offset(lv, (S15308C179*)(S15308C178*), 0, "S15308C177");
    check_base_class_offset(lv, (S15308C178*), 0, "S15308C177");
    check_field_offset(lv, s15308c177f0, 2, "S15308C177.s15308c177f0");
    test_class_info(&lv, &cd_S15308C177);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C177(Test_S15308C177, "S15308C177", 3);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C179;
extern Class_Descriptor cd_S15308C178;
static Base_Class bases_S15308C177[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C179,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C178,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C177 = {  "S15308C177", // class name
  bases_S15308C177, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C176  : S15308C177 {
  ::S15308C182 s15308c176f0;
};
//SIG(-1 S15308C176) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC8{ BC9{}}} FC10{ BC11{}}} FC10}



static void Test_S15308C176()
{
  extern Class_Descriptor cd_S15308C176;
  void *lvp;
  {
    char buf[4];
    init_test(&cd_S15308C176, buf);
    S15308C176 &lv = *(new (buf) S15308C176());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(S15308C176)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C176)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C179*)(S15308C178*)(S15308C177*), 0, "S15308C176");
    check_base_class_offset(lv, (S15308C179*)(S15308C178*)(S15308C177*), 0, "S15308C176");
    check_base_class_offset(lv, (S15308C178*)(S15308C177*), 0, "S15308C176");
    check_base_class_offset(lv, (S15308C177*), 0, "S15308C176");
    check_field_offset(lv, s15308c176f0, 3, "S15308C176.s15308c176f0");
    test_class_info(&lv, &cd_S15308C176);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C176(Test_S15308C176, "S15308C176", 4);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C179;
extern Class_Descriptor cd_S15308C178;
extern Class_Descriptor cd_S15308C177;
static Base_Class bases_S15308C176[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C179,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C178,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C177,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C176 = {  "S15308C176", // class name
  bases_S15308C176, 4,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C175  : S15308C176 {
  void *s15308c175f0;
  int s15308c175f1;
};
//SIG(-1 S15308C175) C1{ BC2{ BC3{ BC4{ BC5{ BC6{} FC7{ BC8{}}} FC9{ BC10{}}} FC11{ BC12{}}} FC11} Fp Fi}



static void Test_S15308C175()
{
  extern Class_Descriptor cd_S15308C175;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C175, buf);
    S15308C175 &lv = *(new (buf) S15308C175());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C175)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C175)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C179*)(S15308C178*)(S15308C177*)(S15308C176*), 0, "S15308C175");
    check_base_class_offset(lv, (S15308C179*)(S15308C178*)(S15308C177*)(S15308C176*), 0, "S15308C175");
    check_base_class_offset(lv, (S15308C178*)(S15308C177*)(S15308C176*), 0, "S15308C175");
    check_base_class_offset(lv, (S15308C177*)(S15308C176*), 0, "S15308C175");
    check_base_class_offset(lv, (S15308C176*), 0, "S15308C175");
    check_field_offset(lv, s15308c175f0, ABISELECT(8,4), "S15308C175.s15308c175f0");
    check_field_offset(lv, s15308c175f1, ABISELECT(16,8), "S15308C175.s15308c175f1");
    test_class_info(&lv, &cd_S15308C175);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C175(Test_S15308C175, "S15308C175", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C179;
extern Class_Descriptor cd_S15308C178;
extern Class_Descriptor cd_S15308C177;
extern Class_Descriptor cd_S15308C176;
static Base_Class bases_S15308C175[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C179,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C178,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C177,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C176,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C175 = {  "S15308C175", // class name
  bases_S15308C175, 5,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C174  : S15308C175 {
};
//SIG(-1 S15308C174) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{} FC8{ BC9{}}} FC10{ BC11{}}} FC12{ BC13{}}} FC12} Fp Fi}}



static void Test_S15308C174()
{
  extern Class_Descriptor cd_S15308C174;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C174, buf);
    S15308C174 &lv = *(new (buf) S15308C174());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C174)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C174)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C179*)(S15308C178*)(S15308C177*)(S15308C176*)(S15308C175*), 0, "S15308C174");
    check_base_class_offset(lv, (S15308C179*)(S15308C178*)(S15308C177*)(S15308C176*)(S15308C175*), 0, "S15308C174");
    check_base_class_offset(lv, (S15308C178*)(S15308C177*)(S15308C176*)(S15308C175*), 0, "S15308C174");
    check_base_class_offset(lv, (S15308C177*)(S15308C176*)(S15308C175*), 0, "S15308C174");
    check_base_class_offset(lv, (S15308C176*)(S15308C175*), 0, "S15308C174");
    check_base_class_offset(lv, (S15308C175*), 0, "S15308C174");
    test_class_info(&lv, &cd_S15308C174);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C174(Test_S15308C174, "S15308C174", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C179;
extern Class_Descriptor cd_S15308C178;
extern Class_Descriptor cd_S15308C177;
extern Class_Descriptor cd_S15308C176;
extern Class_Descriptor cd_S15308C175;
static Base_Class bases_S15308C174[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C179,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C178,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C177,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C176,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S15308C175,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C174 = {  "S15308C174", // class name
  bases_S15308C174, 6,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C207  : S15308C5_nt {
  ::S15308C60 s15308c207f0;
};
//SIG(-1 S15308C207) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C207()
{
  extern Class_Descriptor cd_S15308C207;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C207, buf);
    S15308C207 &lv = *(new (buf) S15308C207());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C207)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C207)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C207");
    check_field_offset(lv, s15308c207f0, 0, "S15308C207.s15308c207f0");
    test_class_info(&lv, &cd_S15308C207);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C207(Test_S15308C207, "S15308C207", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C207[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C207 = {  "S15308C207", // class name
  bases_S15308C207, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C209  {
};
//SIG(-1 S15308C209) C1{}



static void Test_S15308C209()
{
  {
    init_simple_test("S15308C209");
    S15308C209 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C209)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C209)");
  }
}
static Arrange_To_Call_Me vS15308C209(Test_S15308C209, "S15308C209", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C209 = {  "S15308C209", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C208  : S15308C209 {
};
//SIG(-1 S15308C208) C1{ BC2{}}



static void Test_S15308C208()
{
  extern Class_Descriptor cd_S15308C208;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C208, buf);
    S15308C208 &lv = *(new (buf) S15308C208());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C208)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C208)");
    check_base_class_offset(lv, (S15308C209*), 0, "S15308C208");
    test_class_info(&lv, &cd_S15308C208);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C208(Test_S15308C208, "S15308C208", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C209;
static Base_Class bases_S15308C208[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C209,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C208 = {  "S15308C208", // class name
  bases_S15308C208, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C206  : S15308C207 {
  ::S15308C208 s15308c206f0;
};
//SIG(-1 S15308C206) C1{ BC2{ BC3{} FC4{ BC5{}}} FC6{ BC7{}}}



static void Test_S15308C206()
{
  extern Class_Descriptor cd_S15308C206;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S15308C206, buf);
    S15308C206 &lv = *(new (buf) S15308C206());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S15308C206)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C206)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C207*), 0, "S15308C206");
    check_base_class_offset(lv, (S15308C207*), 0, "S15308C206");
    check_field_offset(lv, s15308c206f0, 1, "S15308C206.s15308c206f0");
    test_class_info(&lv, &cd_S15308C206);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C206(Test_S15308C206, "S15308C206", 2);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C207;
static Base_Class bases_S15308C206[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C207,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C206 = {  "S15308C206", // class name
  bases_S15308C206, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C205  : S15308C206 {
  ::S15308C208 s15308c205f0;
};
//SIG(-1 S15308C205) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC7{ BC8{}}} FC7}



static void Test_S15308C205()
{
  extern Class_Descriptor cd_S15308C205;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S15308C205, buf);
    S15308C205 &lv = *(new (buf) S15308C205());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S15308C205)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C205)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C207*)(S15308C206*), 0, "S15308C205");
    check_base_class_offset(lv, (S15308C207*)(S15308C206*), 0, "S15308C205");
    check_base_class_offset(lv, (S15308C206*), 0, "S15308C205");
    check_field_offset(lv, s15308c205f0, 2, "S15308C205.s15308c205f0");
    test_class_info(&lv, &cd_S15308C205);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C205(Test_S15308C205, "S15308C205", 3);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C207;
extern Class_Descriptor cd_S15308C206;
static Base_Class bases_S15308C205[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C207,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C206,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C205 = {  "S15308C205", // class name
  bases_S15308C205, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C213  {
};
//SIG(-1 S15308C213) C1{}



static void Test_S15308C213()
{
  {
    init_simple_test("S15308C213");
    S15308C213 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C213)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C213)");
  }
}
static Arrange_To_Call_Me vS15308C213(Test_S15308C213, "S15308C213", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C213 = {  "S15308C213", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C212  : S15308C213 {
};
//SIG(-1 S15308C212) C1{ BC2{}}



static void Test_S15308C212()
{
  extern Class_Descriptor cd_S15308C212;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C212, buf);
    S15308C212 &lv = *(new (buf) S15308C212());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C212)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C212)");
    check_base_class_offset(lv, (S15308C213*), 0, "S15308C212");
    test_class_info(&lv, &cd_S15308C212);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C212(Test_S15308C212, "S15308C212", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C213;
static Base_Class bases_S15308C212[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C213,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C212 = {  "S15308C212", // class name
  bases_S15308C212, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C204  : S15308C205 {
  ::S15308C212 s15308c204f0;
};
//SIG(-1 S15308C204) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC8{ BC9{}}} FC8} FC10{ BC11{}}}



static void Test_S15308C204()
{
  extern Class_Descriptor cd_S15308C204;
  void *lvp;
  {
    char buf[4];
    init_test(&cd_S15308C204, buf);
    S15308C204 &lv = *(new (buf) S15308C204());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(S15308C204)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C204)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C207*)(S15308C206*)(S15308C205*), 0, "S15308C204");
    check_base_class_offset(lv, (S15308C207*)(S15308C206*)(S15308C205*), 0, "S15308C204");
    check_base_class_offset(lv, (S15308C206*)(S15308C205*), 0, "S15308C204");
    check_base_class_offset(lv, (S15308C205*), 0, "S15308C204");
    check_field_offset(lv, s15308c204f0, 3, "S15308C204.s15308c204f0");
    test_class_info(&lv, &cd_S15308C204);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C204(Test_S15308C204, "S15308C204", 4);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C207;
extern Class_Descriptor cd_S15308C206;
extern Class_Descriptor cd_S15308C205;
static Base_Class bases_S15308C204[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C207,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C206,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C205,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C204 = {  "S15308C204", // class name
  bases_S15308C204, 4,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C203  : S15308C204 {
  void *s15308c203f0;
  int s15308c203f1;
};
//SIG(-1 S15308C203) C1{ BC2{ BC3{ BC4{ BC5{ BC6{} FC7{ BC8{}}} FC9{ BC10{}}} FC9} FC11{ BC12{}}} Fp Fi}



static void Test_S15308C203()
{
  extern Class_Descriptor cd_S15308C203;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C203, buf);
    S15308C203 &lv = *(new (buf) S15308C203());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C203)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C203)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C207*)(S15308C206*)(S15308C205*)(S15308C204*), 0, "S15308C203");
    check_base_class_offset(lv, (S15308C207*)(S15308C206*)(S15308C205*)(S15308C204*), 0, "S15308C203");
    check_base_class_offset(lv, (S15308C206*)(S15308C205*)(S15308C204*), 0, "S15308C203");
    check_base_class_offset(lv, (S15308C205*)(S15308C204*), 0, "S15308C203");
    check_base_class_offset(lv, (S15308C204*), 0, "S15308C203");
    check_field_offset(lv, s15308c203f0, ABISELECT(8,4), "S15308C203.s15308c203f0");
    check_field_offset(lv, s15308c203f1, ABISELECT(16,8), "S15308C203.s15308c203f1");
    test_class_info(&lv, &cd_S15308C203);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C203(Test_S15308C203, "S15308C203", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C207;
extern Class_Descriptor cd_S15308C206;
extern Class_Descriptor cd_S15308C205;
extern Class_Descriptor cd_S15308C204;
static Base_Class bases_S15308C203[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C207,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C206,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C205,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C204,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C203 = {  "S15308C203", // class name
  bases_S15308C203, 5,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C202  : S15308C203 {
};
//SIG(-1 S15308C202) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{} FC8{ BC9{}}} FC10{ BC11{}}} FC10} FC12{ BC13{}}} Fp Fi}}



static void Test_S15308C202()
{
  extern Class_Descriptor cd_S15308C202;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C202, buf);
    S15308C202 &lv = *(new (buf) S15308C202());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C202)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C202)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C207*)(S15308C206*)(S15308C205*)(S15308C204*)(S15308C203*), 0, "S15308C202");
    check_base_class_offset(lv, (S15308C207*)(S15308C206*)(S15308C205*)(S15308C204*)(S15308C203*), 0, "S15308C202");
    check_base_class_offset(lv, (S15308C206*)(S15308C205*)(S15308C204*)(S15308C203*), 0, "S15308C202");
    check_base_class_offset(lv, (S15308C205*)(S15308C204*)(S15308C203*), 0, "S15308C202");
    check_base_class_offset(lv, (S15308C204*)(S15308C203*), 0, "S15308C202");
    check_base_class_offset(lv, (S15308C203*), 0, "S15308C202");
    test_class_info(&lv, &cd_S15308C202);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C202(Test_S15308C202, "S15308C202", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C207;
extern Class_Descriptor cd_S15308C206;
extern Class_Descriptor cd_S15308C205;
extern Class_Descriptor cd_S15308C204;
extern Class_Descriptor cd_S15308C203;
static Base_Class bases_S15308C202[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C207,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C206,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C205,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S15308C204,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S15308C203,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C202 = {  "S15308C202", // class name
  bases_S15308C202, 6,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C217  : S15308C5_nt {
  ::S15308C212 s15308c217f0;
};
//SIG(-1 S15308C217) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C217()
{
  extern Class_Descriptor cd_S15308C217;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C217, buf);
    S15308C217 &lv = *(new (buf) S15308C217());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C217)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C217)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C217");
    check_field_offset(lv, s15308c217f0, 0, "S15308C217.s15308c217f0");
    test_class_info(&lv, &cd_S15308C217);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C217(Test_S15308C217, "S15308C217", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C217[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C217 = {  "S15308C217", // class name
  bases_S15308C217, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C221  {
};
//SIG(-1 S15308C221) C1{}



static void Test_S15308C221()
{
  {
    init_simple_test("S15308C221");
    S15308C221 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C221)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C221)");
  }
}
static Arrange_To_Call_Me vS15308C221(Test_S15308C221, "S15308C221", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C221 = {  "S15308C221", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C220  : S15308C221 {
};
//SIG(-1 S15308C220) C1{ BC2{}}



static void Test_S15308C220()
{
  extern Class_Descriptor cd_S15308C220;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C220, buf);
    S15308C220 &lv = *(new (buf) S15308C220());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C220)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C220)");
    check_base_class_offset(lv, (S15308C221*), 0, "S15308C220");
    test_class_info(&lv, &cd_S15308C220);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C220(Test_S15308C220, "S15308C220", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C221;
static Base_Class bases_S15308C220[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C221,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C220 = {  "S15308C220", // class name
  bases_S15308C220, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C216  : S15308C217 {
  ::S15308C220 s15308c216f0;
};
//SIG(-1 S15308C216) C1{ BC2{ BC3{} FC4{ BC5{}}} FC6{ BC7{}}}



static void Test_S15308C216()
{
  extern Class_Descriptor cd_S15308C216;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S15308C216, buf);
    S15308C216 &lv = *(new (buf) S15308C216());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S15308C216)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C216)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C217*), 0, "S15308C216");
    check_base_class_offset(lv, (S15308C217*), 0, "S15308C216");
    check_field_offset(lv, s15308c216f0, 1, "S15308C216.s15308c216f0");
    test_class_info(&lv, &cd_S15308C216);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C216(Test_S15308C216, "S15308C216", 2);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C217;
static Base_Class bases_S15308C216[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C217,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C216 = {  "S15308C216", // class name
  bases_S15308C216, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C215  : S15308C216 {
  ::S15308C220 s15308c215f0;
};
//SIG(-1 S15308C215) C1{ BC2{ BC3{ BC4{} FC5{ BC6{}}} FC7{ BC8{}}} FC7}



static void Test_S15308C215()
{
  extern Class_Descriptor cd_S15308C215;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S15308C215, buf);
    S15308C215 &lv = *(new (buf) S15308C215());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S15308C215)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C215)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C217*)(S15308C216*), 0, "S15308C215");
    check_base_class_offset(lv, (S15308C217*)(S15308C216*), 0, "S15308C215");
    check_base_class_offset(lv, (S15308C216*), 0, "S15308C215");
    check_field_offset(lv, s15308c215f0, 2, "S15308C215.s15308c215f0");
    test_class_info(&lv, &cd_S15308C215);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C215(Test_S15308C215, "S15308C215", 3);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C217;
extern Class_Descriptor cd_S15308C216;
static Base_Class bases_S15308C215[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C217,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C216,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C215 = {  "S15308C215", // class name
  bases_S15308C215, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C214  : S15308C215 {
  void *s15308c214f0;
  int s15308c214f1;
};
//SIG(-1 S15308C214) C1{ BC2{ BC3{ BC4{ BC5{} FC6{ BC7{}}} FC8{ BC9{}}} FC8} Fp Fi}



static void Test_S15308C214()
{
  extern Class_Descriptor cd_S15308C214;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S15308C214, buf);
    S15308C214 &lv = *(new (buf) S15308C214());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S15308C214)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C214)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C217*)(S15308C216*)(S15308C215*), 0, "S15308C214");
    check_base_class_offset(lv, (S15308C217*)(S15308C216*)(S15308C215*), 0, "S15308C214");
    check_base_class_offset(lv, (S15308C216*)(S15308C215*), 0, "S15308C214");
    check_base_class_offset(lv, (S15308C215*), 0, "S15308C214");
    check_field_offset(lv, s15308c214f0, ABISELECT(8,4), "S15308C214.s15308c214f0");
    check_field_offset(lv, s15308c214f1, ABISELECT(16,8), "S15308C214.s15308c214f1");
    test_class_info(&lv, &cd_S15308C214);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C214(Test_S15308C214, "S15308C214", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C217;
extern Class_Descriptor cd_S15308C216;
extern Class_Descriptor cd_S15308C215;
static Base_Class bases_S15308C214[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C217,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S15308C216,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S15308C215,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C214 = {  "S15308C214", // class name
  bases_S15308C214, 4,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C224  {
  ::S15308C9_nt s15308c224f0;
  void *s15308c224f1;
  short s15308c224f2;
  char s15308c224f3;
  char s15308c224f4;
  void  mf15308c224(); // _ZN10S15308C22411mf15308c224Ev
};
//SIG(-1 S15308C224) C1{ m FC2{ m FL} Fp Fs Fc[2]}


void  S15308C224 ::mf15308c224(){}

static void Test_S15308C224()
{
  {
    init_simple_test("S15308C224");
    S15308C224 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S15308C224)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C224)");
    check_field_offset(lv, s15308c224f0, 0, "S15308C224.s15308c224f0");
    check_field_offset(lv, s15308c224f1, 8, "S15308C224.s15308c224f1");
    check_field_offset(lv, s15308c224f2, ABISELECT(16,12), "S15308C224.s15308c224f2");
    check_field_offset(lv, s15308c224f3, ABISELECT(18,14), "S15308C224.s15308c224f3");
    check_field_offset(lv, s15308c224f4, ABISELECT(19,15), "S15308C224.s15308c224f4");
  }
}
static Arrange_To_Call_Me vS15308C224(Test_S15308C224, "S15308C224", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C228  {
};
//SIG(-1 S15308C228) C1{}



static void Test_S15308C228()
{
  {
    init_simple_test("S15308C228");
    S15308C228 lv;
    check2(sizeof(lv), 1, "sizeof(S15308C228)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C228)");
  }
}
static Arrange_To_Call_Me vS15308C228(Test_S15308C228, "S15308C228", 1);

#else // __cplusplus

Class_Descriptor cd_S15308C228 = {  "S15308C228", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C227  : S15308C228 {
};
//SIG(-1 S15308C227) C1{ BC2{}}



static void Test_S15308C227()
{
  extern Class_Descriptor cd_S15308C227;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C227, buf);
    S15308C227 &lv = *(new (buf) S15308C227());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C227)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C227)");
    check_base_class_offset(lv, (S15308C228*), 0, "S15308C227");
    test_class_info(&lv, &cd_S15308C227);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C227(Test_S15308C227, "S15308C227", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C228;
static Base_Class bases_S15308C227[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C228,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C227 = {  "S15308C227", // class name
  bases_S15308C227, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C226  : S15308C5_nt {
  ::S15308C227 s15308c226f0;
};
//SIG(-1 S15308C226) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C226()
{
  extern Class_Descriptor cd_S15308C226;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C226, buf);
    S15308C226 &lv = *(new (buf) S15308C226());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C226)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C226)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C226");
    check_field_offset(lv, s15308c226f0, 0, "S15308C226.s15308c226f0");
    test_class_info(&lv, &cd_S15308C226);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C226(Test_S15308C226, "S15308C226", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C226[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C226 = {  "S15308C226", // class name
  bases_S15308C226, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C225  : S15308C226 {
  void *s15308c225f0;
  void *s15308c225f1;
  void *s15308c225f2;
};
//SIG(-1 S15308C225) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S15308C225()
{
  extern Class_Descriptor cd_S15308C225;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S15308C225, buf);
    S15308C225 &lv = *(new (buf) S15308C225());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S15308C225)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C225)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C226*), 0, "S15308C225");
    check_base_class_offset(lv, (S15308C226*), 0, "S15308C225");
    check_field_offset(lv, s15308c225f0, ABISELECT(8,4), "S15308C225.s15308c225f0");
    check_field_offset(lv, s15308c225f1, ABISELECT(16,8), "S15308C225.s15308c225f1");
    check_field_offset(lv, s15308c225f2, ABISELECT(24,12), "S15308C225.s15308c225f2");
    test_class_info(&lv, &cd_S15308C225);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C225(Test_S15308C225, "S15308C225", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C226;
static Base_Class bases_S15308C225[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C226,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C225 = {  "S15308C225", // class name
  bases_S15308C225, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C230  {
  void *s15308c230f0;
  void  mf15308c230(); // _ZN10S15308C23011mf15308c230Ev
};
//SIG(-1 S15308C230) C1{ m Fp}


void  S15308C230 ::mf15308c230(){}

static void Test_S15308C230()
{
  {
    init_simple_test("S15308C230");
    S15308C230 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S15308C230)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C230)");
    check_field_offset(lv, s15308c230f0, 0, "S15308C230.s15308c230f0");
  }
}
static Arrange_To_Call_Me vS15308C230(Test_S15308C230, "S15308C230", ABISELECT(8,4));

#else // __cplusplus

Class_Descriptor cd_S15308C230 = {  "S15308C230", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C229_nt  : S15308C230 {
};
//SIG(-1 S15308C229_nt) C1{ BC2{ m Fp}}



//skip512 S15308C229_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C230;
static Base_Class bases_S15308C229_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C230,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C235_nt  {
  char s15308c235f0;
  int s15308c235f1;
  char s15308c235f2;
  char s15308c235f3[1024];
  int s15308c235f4;
  int s15308c235f5;
  void *s15308c235f6;
  void  mf15308c235(); // _ZN13S15308C235_nt11mf15308c235Ev
};
//SIG(-1 S15308C235_nt) C1{ m Fc Fi Fc[1025] Fi[2] Fp}


void  S15308C235_nt ::mf15308c235(){}

//skip512 S15308C235_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C237  : S15308C5_nt {
  ::S15308C227 s15308c237f0;
};
//SIG(-1 S15308C237) C1{ BC2{} FC3{ BC4{}}}



static void Test_S15308C237()
{
  extern Class_Descriptor cd_S15308C237;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S15308C237, buf);
    S15308C237 &lv = *(new (buf) S15308C237());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S15308C237)");
    check2(__alignof__(lv), 1, "__alignof__(S15308C237)");
    check_base_class_offset(lv, (S15308C5_nt*), 0, "S15308C237");
    check_field_offset(lv, s15308c237f0, 0, "S15308C237.s15308c237f0");
    test_class_info(&lv, &cd_S15308C237);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C237(Test_S15308C237, "S15308C237", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
static Base_Class bases_S15308C237[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C237 = {  "S15308C237", // class name
  bases_S15308C237, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C236  : S15308C237 {
  void *s15308c236f0;
  void *s15308c236f1;
  void *s15308c236f2;
};
//SIG(-1 S15308C236) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S15308C236()
{
  extern Class_Descriptor cd_S15308C236;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S15308C236, buf);
    S15308C236 &lv = *(new (buf) S15308C236());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S15308C236)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C236)");
    check_base_class_offset(lv, (S15308C5_nt*)(S15308C237*), 0, "S15308C236");
    check_base_class_offset(lv, (S15308C237*), 0, "S15308C236");
    check_field_offset(lv, s15308c236f0, ABISELECT(8,4), "S15308C236.s15308c236f0");
    check_field_offset(lv, s15308c236f1, ABISELECT(16,8), "S15308C236.s15308c236f1");
    check_field_offset(lv, s15308c236f2, ABISELECT(24,12), "S15308C236.s15308c236f2");
    test_class_info(&lv, &cd_S15308C236);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS15308C236(Test_S15308C236, "S15308C236", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S15308C5_nt;
extern Class_Descriptor cd_S15308C237;
static Base_Class bases_S15308C236[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S15308C237,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S15308C236 = {  "S15308C236", // class name
  bases_S15308C236, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S15308C1  {
  ::S15308C2_nt s15308c1f0;
  char s15308c1f1;
  ::S15308C9_nt s15308c1f2;
  ::S15308C10_nt s15308c1f3;
  void *s15308c1f4;
  ::S15308C11_nt s15308c1f5;
  ::S15308C11_nt s15308c1f6;
  ::S15308C19 s15308c1f7;
  ::S15308C34_nt s15308c1f8;
  ::S15308C34_nt s15308c1f9;
  ::S15308C54_nt s15308c1f10;
  ::S15308C54_nt s15308c1f11;
  ::S15308C80 s15308c1f12;
  ::S15308C2_nt s15308c1f13;
  ::S15308C94 s15308c1f14;
  int s15308c1f15;
  int s15308c1f16;
  int s15308c1f17;
  int s15308c1f18[3];
  int s15308c1f19[3];
  int s15308c1f20[3];
  ::S15308C10_nt s15308c1f21;
  char s15308c1f22;
  char s15308c1f23;
  void *s15308c1f24;
  int s15308c1f25;
  int s15308c1f26;
  ::S15308C80 s15308c1f27;
  ::S15308C108 s15308c1f28;
  ::S15308C174 s15308c1f29;
  int s15308c1f30;
  ::S15308C174 s15308c1f31;
  ::S15308C118 s15308c1f32;
  char s15308c1f33;
  ::S15308C202 s15308c1f34;
  ::S15308C214 s15308c1f35;
  int s15308c1f36;
  ::S15308C224 s15308c1f37;
  ::S15308C225 s15308c1f38;
  ::S15308C225 s15308c1f39;
  ::S15308C229_nt s15308c1f40;
  int s15308c1f41;
  ::S15308C225 s15308c1f42;
  ::S15308C235_nt s15308c1f43;
  ::S15308C235_nt s15308c1f44;
  ::S15308C2_nt s15308c1f45;
  int s15308c1f46;
  void *s15308c1f47[2];
  ::S15308C236 s15308c1f48;
  ::S15308C202 s15308c1f49;
  int s15308c1f50;
  int s15308c1f51;
  void  mf15308c1(); // _ZN8S15308C19mf15308c1Ev
};
//SIG(1 S15308C1) C1{ m FC2{ BC3{ BC4{ BC5{}} FC6{ BC7{}}} FU8{ Fc[16] Fp} Fi Fi} Fc FC9{ m FL} FC10{ m Fp} Fp FC11{ BC12{ BC5 FC6} Fp Fp Fp} FC11 FC13{ m FC14{ BC15{ BC5 FC16{ BC17{}}} Fp Fp Fp} FC14 FC18{ BC19{ BC5 FC6} Fp Fp Fp} FC18 FC2} FC20{ BC21{ BC22{ BC23{ BC5 FC16} FC24{ BC25{}}} FC24} Fp Fi} FC20 FC26{ BC27{ BC28{ BC29{ BC30{ BC31{ BC5 FC32{ BC33{}}} FC32} FC34{ BC35{}}} FC34} Fp Fi}} FC26 FC36{ BC37{ BC38{ BC39{ BC40{ BC41{ BC5 FC42{ BC43{}}} FC42} FC44{ BC45{}}} FC44} Fp Fi}} FC2 FC46{ m Fc Fi Fi FC2} Fi Fi Fi Fi[3] Fi[3] Fi[3] FC10 Fc Fc Fp Fi Fi FC36 FC47{ m Fp FC48{ BC49{ vd v5 v6 v7 v8 v9} vd v1 v2 v3 v4 FC50{ Fc[64] Fc}[16] Fi Fi Fi Fi[16] FC51{ Fi Fp Fi Fi}[2] FC52{ Fp Fp Fp Fi Fi}[11] Fc FC53{ Fp Fi Fp}[16] Fp Fp Fp FC54{ m Fp} FC54 FC54[2] FC54 FC54 FC54 FC55{ m Fp} FC55 Fi Fi Fi Fi} FC56{ BC57{ BC5 FC58{ BC59{}}} Fp Fp Fp} FC9 FC10 FC60{ BC61{ BC62{ BC63{ BC64{ BC65{ BC5 FC32} FC58} FC66{ BC67{}}} FC66} Fp Fi}} Fi Fi Fi Fi Fi Fi Fi Fi Fi Fp Fc Fi Fc FC60 Fc Fi Fc Fi FC11 FC68{ BC69{ BC70{ BC71{ BC72{ BC73{ BC5 FC32} FC74{ BC75{}}} FC74} FC76{ BC77{}}} Fp Fi}} FC68 Fi Fi Fc FC78{ BC79{ m Fc} FC80{ BC81{ m Fc Fc[15]}} FC80 Fi} FC78 Fc Fc Fc Fi Fi Fi Fc Fc} FC82{ BC83{ BC84{ BC85{ BC86{ BC87{ BC5 FC32} FC76} FC88{ BC89{}}} FC88} Fp Fi}} Fi FC82 FC56 Fc FC90{ BC91{ BC92{ BC93{ BC94{ BC95{ BC5 FC32} FC96{ BC97{}}} FC96} FC98{ BC99{}}} Fp Fi}} FC100{ BC101{ BC102{ BC103{ BC5 FC98} FC104{ BC105{}}} FC104} Fp Fi} Fi FC106{ m FC9 Fp Fs Fc Fc} FC107{ BC108{ BC5 FC109{ BC110{}}} Fp Fp Fp} FC107 FC111{ BC112{ m Fp}} Fi FC107 FC113{ m Fc Fi Fc Fc[1024] Fi Fi Fp} FC113 FC2 Fi Fp[2] FC114{ BC115{ BC5 FC109} Fp Fp Fp} FC90 Fi Fi}


void  S15308C1 ::mf15308c1(){}

static void Test_S15308C1()
{
  {
    init_simple_test("S15308C1");
    S15308C1 lv;
    check2(sizeof(lv), ABISELECT(5520,4608), "sizeof(S15308C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S15308C1)");
    check_field_offset(lv, s15308c1f0, 0, "S15308C1.s15308c1f0");
    check_field_offset(lv, s15308c1f1, ABISELECT(32,28), "S15308C1.s15308c1f1");
    check_field_offset(lv, s15308c1f2, ABISELECT(40,32), "S15308C1.s15308c1f2");
    check_field_offset(lv, s15308c1f3, ABISELECT(48,40), "S15308C1.s15308c1f3");
    check_field_offset(lv, s15308c1f4, ABISELECT(56,44), "S15308C1.s15308c1f4");
    check_field_offset(lv, s15308c1f5, ABISELECT(64,48), "S15308C1.s15308c1f5");
    check_field_offset(lv, s15308c1f6, ABISELECT(96,64), "S15308C1.s15308c1f6");
    check_field_offset(lv, s15308c1f7, ABISELECT(128,80), "S15308C1.s15308c1f7");
    check_field_offset(lv, s15308c1f8, ABISELECT(288,172), "S15308C1.s15308c1f8");
    check_field_offset(lv, s15308c1f9, ABISELECT(312,184), "S15308C1.s15308c1f9");
    check_field_offset(lv, s15308c1f10, ABISELECT(336,196), "S15308C1.s15308c1f10");
    check_field_offset(lv, s15308c1f11, ABISELECT(360,208), "S15308C1.s15308c1f11");
    check_field_offset(lv, s15308c1f12, ABISELECT(384,220), "S15308C1.s15308c1f12");
    check_field_offset(lv, s15308c1f13, ABISELECT(408,232), "S15308C1.s15308c1f13");
    check_field_offset(lv, s15308c1f14, ABISELECT(440,260), "S15308C1.s15308c1f14");
    check_field_offset(lv, s15308c1f15, ABISELECT(488,300), "S15308C1.s15308c1f15");
    check_field_offset(lv, s15308c1f16, ABISELECT(492,304), "S15308C1.s15308c1f16");
    check_field_offset(lv, s15308c1f17, ABISELECT(496,308), "S15308C1.s15308c1f17");
    check_field_offset(lv, s15308c1f18, ABISELECT(500,312), "S15308C1.s15308c1f18");
    check_field_offset(lv, s15308c1f19, ABISELECT(512,324), "S15308C1.s15308c1f19");
    check_field_offset(lv, s15308c1f20, ABISELECT(524,336), "S15308C1.s15308c1f20");
    check_field_offset(lv, s15308c1f21, ABISELECT(536,348), "S15308C1.s15308c1f21");
    check_field_offset(lv, s15308c1f22, ABISELECT(544,352), "S15308C1.s15308c1f22");
    check_field_offset(lv, s15308c1f23, ABISELECT(545,353), "S15308C1.s15308c1f23");
    check_field_offset(lv, s15308c1f24, ABISELECT(552,356), "S15308C1.s15308c1f24");
    check_field_offset(lv, s15308c1f25, ABISELECT(560,360), "S15308C1.s15308c1f25");
    check_field_offset(lv, s15308c1f26, ABISELECT(564,364), "S15308C1.s15308c1f26");
    check_field_offset(lv, s15308c1f27, ABISELECT(568,368), "S15308C1.s15308c1f27");
    check_field_offset(lv, s15308c1f28, ABISELECT(592,380), "S15308C1.s15308c1f28");
    check_field_offset(lv, s15308c1f29, ABISELECT(3000,2288), "S15308C1.s15308c1f29");
    check_field_offset(lv, s15308c1f30, ABISELECT(3024,2300), "S15308C1.s15308c1f30");
    check_field_offset(lv, s15308c1f31, ABISELECT(3032,2304), "S15308C1.s15308c1f31");
    check_field_offset(lv, s15308c1f32, ABISELECT(3056,2316), "S15308C1.s15308c1f32");
    check_field_offset(lv, s15308c1f33, ABISELECT(3088,2332), "S15308C1.s15308c1f33");
    check_field_offset(lv, s15308c1f34, ABISELECT(3096,2336), "S15308C1.s15308c1f34");
    check_field_offset(lv, s15308c1f35, ABISELECT(3120,2348), "S15308C1.s15308c1f35");
    check_field_offset(lv, s15308c1f36, ABISELECT(3144,2360), "S15308C1.s15308c1f36");
    check_field_offset(lv, s15308c1f37, ABISELECT(3152,2364), "S15308C1.s15308c1f37");
    check_field_offset(lv, s15308c1f38, ABISELECT(3176,2380), "S15308C1.s15308c1f38");
    check_field_offset(lv, s15308c1f39, ABISELECT(3208,2396), "S15308C1.s15308c1f39");
    check_field_offset(lv, s15308c1f40, ABISELECT(3240,2412), "S15308C1.s15308c1f40");
    check_field_offset(lv, s15308c1f41, ABISELECT(3248,2416), "S15308C1.s15308c1f41");
    check_field_offset(lv, s15308c1f42, ABISELECT(3256,2420), "S15308C1.s15308c1f42");
    check_field_offset(lv, s15308c1f43, ABISELECT(3288,2436), "S15308C1.s15308c1f43");
    check_field_offset(lv, s15308c1f44, ABISELECT(4344,3484), "S15308C1.s15308c1f44");
    check_field_offset(lv, s15308c1f45, ABISELECT(5400,4532), "S15308C1.s15308c1f45");
    check_field_offset(lv, s15308c1f46, ABISELECT(5432,4560), "S15308C1.s15308c1f46");
    check_field_offset(lv, s15308c1f47, ABISELECT(5440,4564), "S15308C1.s15308c1f47");
    check_field_offset(lv, s15308c1f48, ABISELECT(5456,4572), "S15308C1.s15308c1f48");
    check_field_offset(lv, s15308c1f49, ABISELECT(5488,4588), "S15308C1.s15308c1f49");
    check_field_offset(lv, s15308c1f50, ABISELECT(5512,4600), "S15308C1.s15308c1f50");
    check_field_offset(lv, s15308c1f51, ABISELECT(5516,4604), "S15308C1.s15308c1f51");
  }
}
static Arrange_To_Call_Me vS15308C1(Test_S15308C1, "S15308C1", ABISELECT(5520,4608));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C2  {
  virtual  ~S9928C2(); // _ZN7S9928C2D1Ev
  virtual void  v5(); // _ZN7S9928C22v5Ev
  virtual void  v6(); // _ZN7S9928C22v6Ev
  virtual void  v7(); // _ZN7S9928C22v7Ev
  virtual void  v8(); // _ZN7S9928C22v8Ev
  virtual void  v9(); // _ZN7S9928C22v9Ev
  S9928C2(); // tgen
};
//SIG(-1 S9928C2) C1{ vd v1 v2 v3 v4 v5}


 S9928C2 ::~S9928C2(){ note_dtor("S9928C2", this);}
void  S9928C2 ::v5(){vfunc_called(this, "_ZN7S9928C22v5Ev");}
void  S9928C2 ::v6(){vfunc_called(this, "_ZN7S9928C22v6Ev");}
void  S9928C2 ::v7(){vfunc_called(this, "_ZN7S9928C22v7Ev");}
void  S9928C2 ::v8(){vfunc_called(this, "_ZN7S9928C22v8Ev");}
void  S9928C2 ::v9(){vfunc_called(this, "_ZN7S9928C22v9Ev");}
S9928C2 ::S9928C2(){ note_ctor("S9928C2", this);} // tgen

static void Test_S9928C2()
{
  extern Class_Descriptor cd_S9928C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9928C2, buf);
    S9928C2 *dp, &lv = *(dp=new (buf) S9928C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9928C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C2)");
    test_class_info(&lv, &cd_S9928C2);
    dp->~S9928C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C2(Test_S9928C2, "S9928C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9928C2C1Ev();
extern void _ZN7S9928C2D1Ev();
Name_Map name_map_S9928C2[] = {
  NSPAIR(_ZN7S9928C2C1Ev),
  NSPAIR(_ZN7S9928C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9928C2[];
extern void _ZN7S9928C2D1Ev();
extern void _ZN7S9928C2D0Ev();
extern void _ZN7S9928C22v5Ev();
extern void _ZN7S9928C22v6Ev();
extern void _ZN7S9928C22v7Ev();
extern void _ZN7S9928C22v8Ev();
extern void _ZN7S9928C22v9Ev();
static  VTBL_ENTRY vtc_S9928C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9928C2[0]),
  (VTBL_ENTRY)&_ZN7S9928C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9928C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v9Ev,
};
extern VTBL_ENTRY _ZTI7S9928C2[];
extern  VTBL_ENTRY _ZTV7S9928C2[];
Class_Descriptor cd_S9928C2 = {  "S9928C2", // class name
  0,0,//no base classes
  &(vtc_S9928C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9928C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9928C2),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C3_nt  {
  virtual  ~S9928C3_nt(); // _ZN10S9928C3_ntD1Ev
  virtual void  v10(); // _ZN10S9928C3_nt3v10Ev
  virtual void  v11(); // _ZN10S9928C3_nt3v11Ev
  virtual void  v12(); // _ZN10S9928C3_nt3v12Ev
  virtual void  v13(); // _ZN10S9928C3_nt3v13Ev
  S9928C3_nt(); // tgen
};
//SIG(-1 S9928C3_nt) C1{ vd v1 v2 v3 v4}


 S9928C3_nt ::~S9928C3_nt(){ note_dtor("S9928C3_nt", this);}
void  S9928C3_nt ::v10(){vfunc_called(this, "_ZN10S9928C3_nt3v10Ev");}
void  S9928C3_nt ::v11(){vfunc_called(this, "_ZN10S9928C3_nt3v11Ev");}
void  S9928C3_nt ::v12(){vfunc_called(this, "_ZN10S9928C3_nt3v12Ev");}
void  S9928C3_nt ::v13(){vfunc_called(this, "_ZN10S9928C3_nt3v13Ev");}
S9928C3_nt ::S9928C3_nt(){ note_ctor("S9928C3_nt", this);} // tgen

//skip512 S9928C3_nt

#else // __cplusplus

extern void _ZN10S9928C3_ntC1Ev();
extern void _ZN10S9928C3_ntD1Ev();
Name_Map name_map_S9928C3_nt[] = {
  NSPAIR(_ZN10S9928C3_ntC1Ev),
  NSPAIR(_ZN10S9928C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S9928C3_nt[];
extern void _ZN10S9928C3_ntD1Ev();
extern void _ZN10S9928C3_ntD0Ev();
extern void _ZN10S9928C3_nt3v10Ev();
extern void _ZN10S9928C3_nt3v11Ev();
extern void _ZN10S9928C3_nt3v12Ev();
extern void _ZN10S9928C3_nt3v13Ev();
static  VTBL_ENTRY vtc_S9928C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S9928C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S9928C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v13Ev,
};
extern VTBL_ENTRY _ZTI10S9928C3_nt[];
VTBL_ENTRY *P__ZTI10S9928C3_nt = _ZTI10S9928C3_nt; 
extern  VTBL_ENTRY _ZTV10S9928C3_nt[];
Class_Descriptor cd_S9928C3_nt = {  "S9928C3_nt", // class name
  0,0,//no base classes
  &(vtc_S9928C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S9928C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S9928C3_nt),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C6  : S15308C228 {
  ::S15308C227 s9928c6f0;
};
//SIG(-1 S9928C6) C1{ BC2{} FC3{ BC2}}



static void Test_S9928C6()
{
  extern Class_Descriptor cd_S9928C6;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S9928C6, buf);
    S9928C6 &lv = *(new (buf) S9928C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S9928C6)");
    check2(__alignof__(lv), 1, "__alignof__(S9928C6)");
    check_base_class_offset(lv, (S15308C228*), 0, "S9928C6");
    check_field_offset(lv, s9928c6f0, 1, "S9928C6.s9928c6f0");
    test_class_info(&lv, &cd_S9928C6);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C6(Test_S9928C6, "S9928C6", 2);

#else // __cplusplus

extern Class_Descriptor cd_S15308C228;
static Base_Class bases_S9928C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C228,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S9928C6 = {  "S9928C6", // class name
  bases_S9928C6, 1,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C5_nt  : S9928C6 {
  void *s9928c5f0[3];
};
//SIG(-1 S9928C5_nt) C1{ BC2{ BC3{} FC4{ BC3}} Fp[3]}



//skip512 S9928C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S15308C228;
extern Class_Descriptor cd_S9928C6;
static Base_Class bases_S9928C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C228,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S9928C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C10  {
  ::S9928C5_nt s9928c10f0;
  int s9928c10f1;
  ::S15308C202 s9928c10f2;
  int s9928c10f3;
  void  mf9928c10(); // _ZN8S9928C109mf9928c10Ev
};
//SIG(-1 S9928C10) C1{ m FC2{ BC3{ BC4{} FC5{ BC4}} Fp[3]} Fi FC6{ BC7{ BC8{ BC9{ BC10{ BC11{ BC12{} FC13{ BC14{}}} FC15{ BC16{}}} FC15} FC17{ BC18{}}} Fp Fi}} Fi}


void  S9928C10 ::mf9928c10(){}

static void Test_S9928C10()
{
  {
    init_simple_test("S9928C10");
    S9928C10 lv;
    check2(sizeof(lv), ABISELECT(72,36), "sizeof(S9928C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C10)");
    check_field_offset(lv, s9928c10f0, 0, "S9928C10.s9928c10f0");
    check_field_offset(lv, s9928c10f1, ABISELECT(32,16), "S9928C10.s9928c10f1");
    check_field_offset(lv, s9928c10f2, ABISELECT(40,20), "S9928C10.s9928c10f2");
    check_field_offset(lv, s9928c10f3, ABISELECT(64,32), "S9928C10.s9928c10f3");
  }
}
static Arrange_To_Call_Me vS9928C10(Test_S9928C10, "S9928C10", ABISELECT(72,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C30  : S15308C228 {
  ::S15308C220 s9928c30f0;
};
//SIG(-1 S9928C30) C1{ BC2{} FC3{ BC4{}}}



static void Test_S9928C30()
{
  extern Class_Descriptor cd_S9928C30;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S9928C30, buf);
    S9928C30 &lv = *(new (buf) S9928C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S9928C30)");
    check2(__alignof__(lv), 1, "__alignof__(S9928C30)");
    check_base_class_offset(lv, (S15308C228*), 0, "S9928C30");
    check_field_offset(lv, s9928c30f0, 0, "S9928C30.s9928c30f0");
    test_class_info(&lv, &cd_S9928C30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C30(Test_S9928C30, "S9928C30", 1);

#else // __cplusplus

extern Class_Descriptor cd_S15308C228;
static Base_Class bases_S9928C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C228,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S9928C30 = {  "S9928C30", // class name
  bases_S9928C30, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C29  : S9928C30 {
  void *s9928c29f0[3];
};
//SIG(-1 S9928C29) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S9928C29()
{
  extern Class_Descriptor cd_S9928C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S9928C29, buf);
    S9928C29 &lv = *(new (buf) S9928C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S9928C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C29)");
    check_base_class_offset(lv, (S15308C228*)(S9928C30*), 0, "S9928C29");
    check_base_class_offset(lv, (S9928C30*), 0, "S9928C29");
    check_field_offset(lv, s9928c29f0, ABISELECT(8,4), "S9928C29.s9928c29f0");
    test_class_info(&lv, &cd_S9928C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C29(Test_S9928C29, "S9928C29", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S15308C228;
extern Class_Descriptor cd_S9928C30;
static Base_Class bases_S9928C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C228,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S9928C30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S9928C29 = {  "S9928C29", // class name
  bases_S9928C29, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C4  : S9928C2 , S9928C3_nt {
  ::S9928C5_nt s9928c4f0;
  ::S9928C10 s9928c4f1;
  char s9928c4f2[3];
  int s9928c4f3;
  ::S9928C29 s9928c4f4;
  ::S15308C2_nt s9928c4f5;
  virtual  ~S9928C4(); // _ZN7S9928C4D1Ev
  virtual void  v14(); // _ZN7S9928C43v14Ev
  virtual void  v15(); // _ZN7S9928C43v15Ev
  virtual void  v16(); // _ZN7S9928C43v16Ev
  virtual void  v17(); // _ZN7S9928C43v17Ev
  virtual void  v18(); // _ZN7S9928C43v18Ev
  virtual void  v19(); // _ZN7S9928C43v19Ev
  S9928C4(); // tgen
};
//SIG(-1 S9928C4) C1{ BC2{ vd v7 v8 v9 v10 v11} BC3{ vd v12 v13 v14 v15} vd v1 v2 v3 v4 v5 v6 FC4{ BC5{ BC6{} FC7{ BC6}} Fp[3]} FC8{ m FC4 Fi FC9{ BC10{ BC11{ BC12{ BC13{ BC14{ BC15{} FC16{ BC17{}}} FC18{ BC19{}}} FC18} FC20{ BC21{}}} Fp Fi}} Fi} Fc[3] Fi FC22{ BC23{ BC6 FC24{ BC25{}}} Fp[3]} FC26{ BC27{ BC28{ BC15} FC29{ BC30{}}} FU31{ Fc[16] Fp} Fi Fi}}


 S9928C4 ::~S9928C4(){ note_dtor("S9928C4", this);}
void  S9928C4 ::v14(){vfunc_called(this, "_ZN7S9928C43v14Ev");}
void  S9928C4 ::v15(){vfunc_called(this, "_ZN7S9928C43v15Ev");}
void  S9928C4 ::v16(){vfunc_called(this, "_ZN7S9928C43v16Ev");}
void  S9928C4 ::v17(){vfunc_called(this, "_ZN7S9928C43v17Ev");}
void  S9928C4 ::v18(){vfunc_called(this, "_ZN7S9928C43v18Ev");}
void  S9928C4 ::v19(){vfunc_called(this, "_ZN7S9928C43v19Ev");}
S9928C4 ::S9928C4(){ note_ctor("S9928C4", this);} // tgen

static void Test_S9928C4()
{
  extern Class_Descriptor cd_S9928C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,29)];
    init_test(&cd_S9928C4, buf);
    S9928C4 *dp, &lv = *(dp=new (buf) S9928C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,112), "sizeof(S9928C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C4)");
    check_base_class_offset(lv, (S9928C2*), 0, "S9928C4");
    check_base_class_offset(lv, (S9928C3_nt*), ABISELECT(8,4), "S9928C4");
    check_field_offset(lv, s9928c4f0, ABISELECT(16,8), "S9928C4.s9928c4f0");
    check_field_offset(lv, s9928c4f1, ABISELECT(48,24), "S9928C4.s9928c4f1");
    check_field_offset(lv, s9928c4f2, ABISELECT(120,60), "S9928C4.s9928c4f2");
    check_field_offset(lv, s9928c4f3, ABISELECT(124,64), "S9928C4.s9928c4f3");
    check_field_offset(lv, s9928c4f4, ABISELECT(128,68), "S9928C4.s9928c4f4");
    check_field_offset(lv, s9928c4f5, ABISELECT(160,84), "S9928C4.s9928c4f5");
    test_class_info(&lv, &cd_S9928C4);
    dp->~S9928C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C4(Test_S9928C4, "S9928C4", ABISELECT(192,112));

#else // __cplusplus

extern void _ZN7S9928C4C1Ev();
extern void _ZN7S9928C4D1Ev();
Name_Map name_map_S9928C4[] = {
  NSPAIR(_ZN7S9928C4C1Ev),
  NSPAIR(_ZN7S9928C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9928C2;
extern VTBL_ENTRY _ZTI7S9928C2[];
extern  VTBL_ENTRY _ZTV7S9928C2[];
extern Class_Descriptor cd_S9928C3_nt;
extern VTBL_ENTRY _ZTI10S9928C3_nt[];
extern  VTBL_ENTRY _ZTV10S9928C3_nt[];
static Base_Class bases_S9928C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9928C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9928C3_nt,    ABISELECT(8,4), //bcp->offset
    15, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9928C4[];
extern void _ZN7S9928C4D1Ev();
extern void _ZN7S9928C4D0Ev();
extern void _ZN7S9928C22v5Ev();
extern void _ZN7S9928C22v6Ev();
extern void _ZN7S9928C22v7Ev();
extern void _ZN7S9928C22v8Ev();
extern void _ZN7S9928C22v9Ev();
extern void _ZN7S9928C43v14Ev();
extern void _ZN7S9928C43v15Ev();
extern void _ZN7S9928C43v16Ev();
extern void _ZN7S9928C43v17Ev();
extern void _ZN7S9928C43v18Ev();
extern void _ZN7S9928C43v19Ev();
extern void ABISELECT(_ZThn8_N7S9928C4D1Ev,_ZThn4_N7S9928C4D1Ev)();
extern void ABISELECT(_ZThn8_N7S9928C4D0Ev,_ZThn4_N7S9928C4D0Ev)();
extern void _ZN10S9928C3_nt3v10Ev();
extern void _ZN10S9928C3_nt3v11Ev();
extern void _ZN10S9928C3_nt3v12Ev();
extern void _ZN10S9928C3_nt3v13Ev();
static  VTBL_ENTRY vtc_S9928C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9928C4[0]),
  (VTBL_ENTRY)&_ZN7S9928C4D1Ev,
  (VTBL_ENTRY)&_ZN7S9928C4D0Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v9Ev,
  (VTBL_ENTRY)&_ZN7S9928C43v14Ev,
  (VTBL_ENTRY)&_ZN7S9928C43v15Ev,
  (VTBL_ENTRY)&_ZN7S9928C43v16Ev,
  (VTBL_ENTRY)&_ZN7S9928C43v17Ev,
  (VTBL_ENTRY)&_ZN7S9928C43v18Ev,
  (VTBL_ENTRY)&_ZN7S9928C43v19Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9928C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9928C4D1Ev,_ZThn4_N7S9928C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9928C4D0Ev,_ZThn4_N7S9928C4D0Ev),
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v13Ev,
};
extern VTBL_ENTRY _ZTI7S9928C4[];
extern  VTBL_ENTRY _ZTV7S9928C4[];
Class_Descriptor cd_S9928C4 = {  "S9928C4", // class name
  bases_S9928C4, 2,
  &(vtc_S9928C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,112), // object size
  NSPAIRA(_ZTI7S9928C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9928C4),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C39  : S9928C2 {
  ::S15308C236 s9928c39f0;
  ::S15308C236 s9928c39f1;
  int s9928c39f2;
  char s9928c39f3;
  virtual  ~S9928C39(); // _ZN8S9928C39D1Ev
  virtual void  v20(); // _ZN8S9928C393v20Ev
  virtual void  v21(); // _ZN8S9928C393v21Ev
  S9928C39(); // tgen
};
//SIG(-1 S9928C39) C1{ BC2{ vd v3 v4 v5 v6 v7} vd v1 v2 FC3{ BC4{ BC5{} FC6{ BC7{}}} Fp[3]} FC3 Fi Fc}


 S9928C39 ::~S9928C39(){ note_dtor("S9928C39", this);}
void  S9928C39 ::v20(){vfunc_called(this, "_ZN8S9928C393v20Ev");}
void  S9928C39 ::v21(){vfunc_called(this, "_ZN8S9928C393v21Ev");}
S9928C39 ::S9928C39(){ note_ctor("S9928C39", this);} // tgen

static void Test_S9928C39()
{
  extern Class_Descriptor cd_S9928C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,12)];
    init_test(&cd_S9928C39, buf);
    S9928C39 *dp, &lv = *(dp=new (buf) S9928C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,44), "sizeof(S9928C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C39)");
    check_base_class_offset(lv, (S9928C2*), 0, "S9928C39");
    check_field_offset(lv, s9928c39f0, ABISELECT(8,4), "S9928C39.s9928c39f0");
    check_field_offset(lv, s9928c39f1, ABISELECT(40,20), "S9928C39.s9928c39f1");
    check_field_offset(lv, s9928c39f2, ABISELECT(72,36), "S9928C39.s9928c39f2");
    check_field_offset(lv, s9928c39f3, ABISELECT(76,40), "S9928C39.s9928c39f3");
    test_class_info(&lv, &cd_S9928C39);
    dp->~S9928C39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C39(Test_S9928C39, "S9928C39", ABISELECT(80,44));

#else // __cplusplus

extern void _ZN8S9928C39C1Ev();
extern void _ZN8S9928C39D1Ev();
Name_Map name_map_S9928C39[] = {
  NSPAIR(_ZN8S9928C39C1Ev),
  NSPAIR(_ZN8S9928C39D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9928C2;
extern VTBL_ENTRY _ZTI7S9928C2[];
extern  VTBL_ENTRY _ZTV7S9928C2[];
static Base_Class bases_S9928C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9928C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9928C39[];
extern void _ZN8S9928C39D1Ev();
extern void _ZN8S9928C39D0Ev();
extern void _ZN7S9928C22v5Ev();
extern void _ZN7S9928C22v6Ev();
extern void _ZN7S9928C22v7Ev();
extern void _ZN7S9928C22v8Ev();
extern void _ZN7S9928C22v9Ev();
extern void _ZN8S9928C393v20Ev();
extern void _ZN8S9928C393v21Ev();
static  VTBL_ENTRY vtc_S9928C39[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9928C39[0]),
  (VTBL_ENTRY)&_ZN8S9928C39D1Ev,
  (VTBL_ENTRY)&_ZN8S9928C39D0Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v9Ev,
  (VTBL_ENTRY)&_ZN8S9928C393v20Ev,
  (VTBL_ENTRY)&_ZN8S9928C393v21Ev,
};
extern VTBL_ENTRY _ZTI8S9928C39[];
extern  VTBL_ENTRY _ZTV8S9928C39[];
Class_Descriptor cd_S9928C39 = {  "S9928C39", // class name
  bases_S9928C39, 1,
  &(vtc_S9928C39[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,44), // object size
  NSPAIRA(_ZTI8S9928C39),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9928C39),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C44  : S9928C2 {
  char s9928c44f0;
  ::S15308C225 s9928c44f1;
  ::S15308C118 s9928c44f2;
  virtual  ~S9928C44(); // _ZN8S9928C44D1Ev
  virtual void  v22(); // _ZN8S9928C443v22Ev
  virtual void  v23(); // _ZN8S9928C443v23Ev
  S9928C44(); // tgen
};
//SIG(-1 S9928C44) C1{ BC2{ vd v3 v4 v5 v6 v7} vd v1 v2 Fc FC3{ BC4{ BC5{} FC6{ BC7{}}} Fp[3]} FC8{ BC9{ BC5 FC10{ BC11{}}} Fp[3]}}


 S9928C44 ::~S9928C44(){ note_dtor("S9928C44", this);}
void  S9928C44 ::v22(){vfunc_called(this, "_ZN8S9928C443v22Ev");}
void  S9928C44 ::v23(){vfunc_called(this, "_ZN8S9928C443v23Ev");}
S9928C44 ::S9928C44(){ note_ctor("S9928C44", this);} // tgen

static void Test_S9928C44()
{
  extern Class_Descriptor cd_S9928C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[11];
    init_test(&cd_S9928C44, buf);
    S9928C44 *dp, &lv = *(dp=new (buf) S9928C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,40), "sizeof(S9928C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C44)");
    check_base_class_offset(lv, (S9928C2*), 0, "S9928C44");
    check_field_offset(lv, s9928c44f0, ABISELECT(8,4), "S9928C44.s9928c44f0");
    check_field_offset(lv, s9928c44f1, ABISELECT(16,8), "S9928C44.s9928c44f1");
    check_field_offset(lv, s9928c44f2, ABISELECT(48,24), "S9928C44.s9928c44f2");
    test_class_info(&lv, &cd_S9928C44);
    dp->~S9928C44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C44(Test_S9928C44, "S9928C44", ABISELECT(80,40));

#else // __cplusplus

extern void _ZN8S9928C44C1Ev();
extern void _ZN8S9928C44D1Ev();
Name_Map name_map_S9928C44[] = {
  NSPAIR(_ZN8S9928C44C1Ev),
  NSPAIR(_ZN8S9928C44D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9928C2;
extern VTBL_ENTRY _ZTI7S9928C2[];
extern  VTBL_ENTRY _ZTV7S9928C2[];
static Base_Class bases_S9928C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9928C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9928C44[];
extern void _ZN8S9928C44D1Ev();
extern void _ZN8S9928C44D0Ev();
extern void _ZN7S9928C22v5Ev();
extern void _ZN7S9928C22v6Ev();
extern void _ZN7S9928C22v7Ev();
extern void _ZN7S9928C22v8Ev();
extern void _ZN7S9928C22v9Ev();
extern void _ZN8S9928C443v22Ev();
extern void _ZN8S9928C443v23Ev();
static  VTBL_ENTRY vtc_S9928C44[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9928C44[0]),
  (VTBL_ENTRY)&_ZN8S9928C44D1Ev,
  (VTBL_ENTRY)&_ZN8S9928C44D0Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v9Ev,
  (VTBL_ENTRY)&_ZN8S9928C443v22Ev,
  (VTBL_ENTRY)&_ZN8S9928C443v23Ev,
};
extern VTBL_ENTRY _ZTI8S9928C44[];
extern  VTBL_ENTRY _ZTV8S9928C44[];
Class_Descriptor cd_S9928C44 = {  "S9928C44", // class name
  bases_S9928C44, 1,
  &(vtc_S9928C44[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,40), // object size
  NSPAIRA(_ZTI8S9928C44),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9928C44),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C53  {
  char s9928c53f0;
  int s9928c53f1;
  int s9928c53f2;
  ::S15308C172 s9928c53f3;
  ::S15308C172 s9928c53f4;
  ::S15308C2_nt s9928c53f5;
  int s9928c53f6;
  int s9928c53f7;
  int s9928c53f8;
  int s9928c53f9;
  void *s9928c53f10;
  void  mf9928c53(); // _ZN8S9928C539mf9928c53Ev
};
//SIG(-1 S9928C53) C1{ m Fc Fi[2] FC2{ BC3{ m Fc[16]}} FC2 FC4{ BC5{ BC6{ BC7{}} FC8{ BC9{}}} FU10{ Fc[16] Fp} Fi Fi} Fi Fi Fi Fi Fp}


void  S9928C53 ::mf9928c53(){}

static void Test_S9928C53()
{
  {
    init_simple_test("S9928C53");
    S9928C53 lv;
    check2(sizeof(lv), ABISELECT(104,92), "sizeof(S9928C53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C53)");
    check_field_offset(lv, s9928c53f0, 0, "S9928C53.s9928c53f0");
    check_field_offset(lv, s9928c53f1, 4, "S9928C53.s9928c53f1");
    check_field_offset(lv, s9928c53f2, 8, "S9928C53.s9928c53f2");
    check_field_offset(lv, s9928c53f3, 12, "S9928C53.s9928c53f3");
    check_field_offset(lv, s9928c53f4, 28, "S9928C53.s9928c53f4");
    check_field_offset(lv, s9928c53f5, ABISELECT(48,44), "S9928C53.s9928c53f5");
    check_field_offset(lv, s9928c53f6, ABISELECT(80,72), "S9928C53.s9928c53f6");
    check_field_offset(lv, s9928c53f7, ABISELECT(84,76), "S9928C53.s9928c53f7");
    check_field_offset(lv, s9928c53f8, ABISELECT(88,80), "S9928C53.s9928c53f8");
    check_field_offset(lv, s9928c53f9, ABISELECT(92,84), "S9928C53.s9928c53f9");
    check_field_offset(lv, s9928c53f10, ABISELECT(96,88), "S9928C53.s9928c53f10");
  }
}
static Arrange_To_Call_Me vS9928C53(Test_S9928C53, "S9928C53", ABISELECT(104,92));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C56  {
  int s9928c56f0;
  int s9928c56f1;
  char s9928c56f2;
  ::S15308C28 s9928c56f3;
  void  mf9928c56(); // _ZN8S9928C569mf9928c56Ev
};
//SIG(-1 S9928C56) C1{ m Fi[2] Fc FC2{ BC3{ BC4{} FC5{ BC6{}}} Fp[3]}}


void  S9928C56 ::mf9928c56(){}

static void Test_S9928C56()
{
  {
    init_simple_test("S9928C56");
    S9928C56 lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S9928C56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C56)");
    check_field_offset(lv, s9928c56f0, 0, "S9928C56.s9928c56f0");
    check_field_offset(lv, s9928c56f1, 4, "S9928C56.s9928c56f1");
    check_field_offset(lv, s9928c56f2, 8, "S9928C56.s9928c56f2");
    check_field_offset(lv, s9928c56f3, ABISELECT(16,12), "S9928C56.s9928c56f3");
  }
}
static Arrange_To_Call_Me vS9928C56(Test_S9928C56, "S9928C56", ABISELECT(48,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C63  {
  int s9928c63f0;
  int s9928c63f1;
  int s9928c63f2;
  int s9928c63f3;
};
//SIG(-1 S9928C63) C1{ Fi[4]}



static void Test_S9928C63()
{
  {
    init_simple_test("S9928C63");
    S9928C63 lv;
    check2(sizeof(lv), 16, "sizeof(S9928C63)");
    check2(__alignof__(lv), 4, "__alignof__(S9928C63)");
    check_field_offset(lv, s9928c63f0, 0, "S9928C63.s9928c63f0");
    check_field_offset(lv, s9928c63f1, 4, "S9928C63.s9928c63f1");
    check_field_offset(lv, s9928c63f2, 8, "S9928C63.s9928c63f2");
    check_field_offset(lv, s9928c63f3, 12, "S9928C63.s9928c63f3");
  }
}
static Arrange_To_Call_Me vS9928C63(Test_S9928C63, "S9928C63", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C64  {
  int s9928c64f0;
  int s9928c64f1;
  int s9928c64f2;
  int s9928c64f3;
  int s9928c64f4;
  char s9928c64f5;
  int s9928c64f6;
  int s9928c64f7;
  void  mf9928c64(); // _ZN8S9928C649mf9928c64Ev
};
//SIG(-1 S9928C64) C1{ m Fi[5] Fc Fi[2]}


void  S9928C64 ::mf9928c64(){}

static void Test_S9928C64()
{
  {
    init_simple_test("S9928C64");
    S9928C64 lv;
    check2(sizeof(lv), 32, "sizeof(S9928C64)");
    check2(__alignof__(lv), 4, "__alignof__(S9928C64)");
    check_field_offset(lv, s9928c64f0, 0, "S9928C64.s9928c64f0");
    check_field_offset(lv, s9928c64f1, 4, "S9928C64.s9928c64f1");
    check_field_offset(lv, s9928c64f2, 8, "S9928C64.s9928c64f2");
    check_field_offset(lv, s9928c64f3, 12, "S9928C64.s9928c64f3");
    check_field_offset(lv, s9928c64f4, 16, "S9928C64.s9928c64f4");
    check_field_offset(lv, s9928c64f5, 20, "S9928C64.s9928c64f5");
    check_field_offset(lv, s9928c64f6, 24, "S9928C64.s9928c64f6");
    check_field_offset(lv, s9928c64f7, 28, "S9928C64.s9928c64f7");
  }
}
static Arrange_To_Call_Me vS9928C64(Test_S9928C64, "S9928C64", 32);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C62  {
  int s9928c62f0;
  int s9928c62f1;
  int s9928c62f2;
  int s9928c62f3;
  int s9928c62f4;
  int s9928c62f5;
  int s9928c62f6;
  int s9928c62f7;
  int s9928c62f8;
  int s9928c62f9;
  int s9928c62f10;
  int s9928c62f11;
  int s9928c62f12;
  int s9928c62f13;
  int s9928c62f14;
  int s9928c62f15;
  int s9928c62f16;
  int s9928c62f17;
  ::S9928C63 s9928c62f18;
  ::S9928C64 s9928c62f19;
};
//SIG(1 S9928C62) C1{ Fi[18] FC2{ Fi[4]} FC3{ m Fi[5] Fc Fi[2]}}



static void Test_S9928C62()
{
  {
    init_simple_test("S9928C62");
    S9928C62 lv;
    check2(sizeof(lv), 120, "sizeof(S9928C62)");
    check2(__alignof__(lv), 4, "__alignof__(S9928C62)");
    check_field_offset(lv, s9928c62f0, 0, "S9928C62.s9928c62f0");
    check_field_offset(lv, s9928c62f1, 4, "S9928C62.s9928c62f1");
    check_field_offset(lv, s9928c62f2, 8, "S9928C62.s9928c62f2");
    check_field_offset(lv, s9928c62f3, 12, "S9928C62.s9928c62f3");
    check_field_offset(lv, s9928c62f4, 16, "S9928C62.s9928c62f4");
    check_field_offset(lv, s9928c62f5, 20, "S9928C62.s9928c62f5");
    check_field_offset(lv, s9928c62f6, 24, "S9928C62.s9928c62f6");
    check_field_offset(lv, s9928c62f7, 28, "S9928C62.s9928c62f7");
    check_field_offset(lv, s9928c62f8, 32, "S9928C62.s9928c62f8");
    check_field_offset(lv, s9928c62f9, 36, "S9928C62.s9928c62f9");
    check_field_offset(lv, s9928c62f10, 40, "S9928C62.s9928c62f10");
    check_field_offset(lv, s9928c62f11, 44, "S9928C62.s9928c62f11");
    check_field_offset(lv, s9928c62f12, 48, "S9928C62.s9928c62f12");
    check_field_offset(lv, s9928c62f13, 52, "S9928C62.s9928c62f13");
    check_field_offset(lv, s9928c62f14, 56, "S9928C62.s9928c62f14");
    check_field_offset(lv, s9928c62f15, 60, "S9928C62.s9928c62f15");
    check_field_offset(lv, s9928c62f16, 64, "S9928C62.s9928c62f16");
    check_field_offset(lv, s9928c62f17, 68, "S9928C62.s9928c62f17");
    check_field_offset(lv, s9928c62f18, 72, "S9928C62.s9928c62f18");
    check_field_offset(lv, s9928c62f19, 88, "S9928C62.s9928c62f19");
  }
}
static Arrange_To_Call_Me vS9928C62(Test_S9928C62, "S9928C62", 120);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C65  {
  int s9928c65f0;
  int s9928c65f1;
  int s9928c65f2;
  int s9928c65f3;
  int s9928c65f4;
};
//SIG(1 S9928C65) C1{ Fi[5]}



static void Test_S9928C65()
{
  {
    init_simple_test("S9928C65");
    S9928C65 lv;
    check2(sizeof(lv), 20, "sizeof(S9928C65)");
    check2(__alignof__(lv), 4, "__alignof__(S9928C65)");
    check_field_offset(lv, s9928c65f0, 0, "S9928C65.s9928c65f0");
    check_field_offset(lv, s9928c65f1, 4, "S9928C65.s9928c65f1");
    check_field_offset(lv, s9928c65f2, 8, "S9928C65.s9928c65f2");
    check_field_offset(lv, s9928c65f3, 12, "S9928C65.s9928c65f3");
    check_field_offset(lv, s9928c65f4, 16, "S9928C65.s9928c65f4");
  }
}
static Arrange_To_Call_Me vS9928C65(Test_S9928C65, "S9928C65", 20);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C66  {
  int s9928c66f0;
  int s9928c66f1;
  int s9928c66f2;
  int s9928c66f3;
  int s9928c66f4;
  int s9928c66f5;
  int s9928c66f6;
  int s9928c66f7;
  int s9928c66f8;
  int s9928c66f9;
  int s9928c66f10;
  ::S15308C172 s9928c66f11;
  ::S15308C172 s9928c66f12;
};
//SIG(1 S9928C66) C1{ Fi[11] FC2{ BC3{ m Fc[16]}} FC2}



static void Test_S9928C66()
{
  {
    init_simple_test("S9928C66");
    S9928C66 lv;
    check2(sizeof(lv), 76, "sizeof(S9928C66)");
    check2(__alignof__(lv), 4, "__alignof__(S9928C66)");
    check_field_offset(lv, s9928c66f0, 0, "S9928C66.s9928c66f0");
    check_field_offset(lv, s9928c66f1, 4, "S9928C66.s9928c66f1");
    check_field_offset(lv, s9928c66f2, 8, "S9928C66.s9928c66f2");
    check_field_offset(lv, s9928c66f3, 12, "S9928C66.s9928c66f3");
    check_field_offset(lv, s9928c66f4, 16, "S9928C66.s9928c66f4");
    check_field_offset(lv, s9928c66f5, 20, "S9928C66.s9928c66f5");
    check_field_offset(lv, s9928c66f6, 24, "S9928C66.s9928c66f6");
    check_field_offset(lv, s9928c66f7, 28, "S9928C66.s9928c66f7");
    check_field_offset(lv, s9928c66f8, 32, "S9928C66.s9928c66f8");
    check_field_offset(lv, s9928c66f9, 36, "S9928C66.s9928c66f9");
    check_field_offset(lv, s9928c66f10, 40, "S9928C66.s9928c66f10");
    check_field_offset(lv, s9928c66f11, 44, "S9928C66.s9928c66f11");
    check_field_offset(lv, s9928c66f12, 60, "S9928C66.s9928c66f12");
  }
}
static Arrange_To_Call_Me vS9928C66(Test_S9928C66, "S9928C66", 76);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C61  : S9928C2 {
  ::S9928C62 s9928c61f0[21];
  ::S9928C65 s9928c61f1[7];
  int s9928c61f2[21];
  ::S15308C172 s9928c61f3[21];
  ::S9928C66 s9928c61f4[21];
  int s9928c61f5;
  char s9928c61f6;
  char s9928c61f7;
  char s9928c61f8;
  char s9928c61f9;
  char s9928c61f10;
  int s9928c61f11;
  int s9928c61f12;
  int s9928c61f13;
  char s9928c61f14;
  int s9928c61f15;
  int s9928c61f16;
  int s9928c61f17;
  int s9928c61f18;
  int s9928c61f19;
  int s9928c61f20;
  int s9928c61f21;
  int s9928c61f22;
  int s9928c61f23;
  int s9928c61f24;
  int s9928c61f25;
  int s9928c61f26;
  int s9928c61f27;
  char s9928c61f28;
  char s9928c61f29;
  int s9928c61f30;
  char s9928c61f31;
  int s9928c61f32;
  int s9928c61f33;
  int s9928c61f34;
  int s9928c61f35;
  int s9928c61f36;
  int s9928c61f37;
  int s9928c61f38;
  int s9928c61f39;
  int s9928c61f40;
  int s9928c61f41;
  int s9928c61f42;
  int s9928c61f43;
  int s9928c61f44;
  int s9928c61f45;
  int s9928c61f46;
  int s9928c61f47;
  int s9928c61f48;
  int s9928c61f49;
  virtual  ~S9928C61(); // _ZN8S9928C61D1Ev
  virtual void  v24(); // _ZN8S9928C613v24Ev
  virtual void  v25(); // _ZN8S9928C613v25Ev
  S9928C61(); // tgen
};
//SIG(-1 S9928C61) C1{ BC2{ vd v3 v4 v5 v6 v7} vd v1 v2 FC3{ Fi[18] FC4{ Fi[4]} FC5{ m Fi[5] Fc Fi[2]}}[21] FC6{ Fi[5]}[7] Fi[21] FC7{ BC8{ m Fc[16]}}[21] FC9{ Fi[11] FC7 FC7}[21] Fi Fc[5] Fi[3] Fc Fi[13] Fc[2] Fi Fc Fi[18]}


 S9928C61 ::~S9928C61(){ note_dtor("S9928C61", this);}
void  S9928C61 ::v24(){vfunc_called(this, "_ZN8S9928C613v24Ev");}
void  S9928C61 ::v25(){vfunc_called(this, "_ZN8S9928C613v25Ev");}
S9928C61 ::S9928C61(){ note_ctor("S9928C61", this);} // tgen

static void Test_S9928C61()
{
  extern Class_Descriptor cd_S9928C61;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(607,1212)];
    init_test(&cd_S9928C61, buf);
    S9928C61 *dp, &lv = *(dp=new (buf) S9928C61());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4848,4844), "sizeof(S9928C61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C61)");
    check_base_class_offset(lv, (S9928C2*), 0, "S9928C61");
    check_field_offset(lv, s9928c61f0, ABISELECT(8,4), "S9928C61.s9928c61f0");
    check_field_offset(lv, s9928c61f1, ABISELECT(2528,2524), "S9928C61.s9928c61f1");
    check_field_offset(lv, s9928c61f2, ABISELECT(2668,2664), "S9928C61.s9928c61f2");
    check_field_offset(lv, s9928c61f3, ABISELECT(2752,2748), "S9928C61.s9928c61f3");
    check_field_offset(lv, s9928c61f4, ABISELECT(3088,3084), "S9928C61.s9928c61f4");
    check_field_offset(lv, s9928c61f5, ABISELECT(4684,4680), "S9928C61.s9928c61f5");
    check_field_offset(lv, s9928c61f6, ABISELECT(4688,4684), "S9928C61.s9928c61f6");
    check_field_offset(lv, s9928c61f7, ABISELECT(4689,4685), "S9928C61.s9928c61f7");
    check_field_offset(lv, s9928c61f8, ABISELECT(4690,4686), "S9928C61.s9928c61f8");
    check_field_offset(lv, s9928c61f9, ABISELECT(4691,4687), "S9928C61.s9928c61f9");
    check_field_offset(lv, s9928c61f10, ABISELECT(4692,4688), "S9928C61.s9928c61f10");
    check_field_offset(lv, s9928c61f11, ABISELECT(4696,4692), "S9928C61.s9928c61f11");
    check_field_offset(lv, s9928c61f12, ABISELECT(4700,4696), "S9928C61.s9928c61f12");
    check_field_offset(lv, s9928c61f13, ABISELECT(4704,4700), "S9928C61.s9928c61f13");
    check_field_offset(lv, s9928c61f14, ABISELECT(4708,4704), "S9928C61.s9928c61f14");
    check_field_offset(lv, s9928c61f15, ABISELECT(4712,4708), "S9928C61.s9928c61f15");
    check_field_offset(lv, s9928c61f16, ABISELECT(4716,4712), "S9928C61.s9928c61f16");
    check_field_offset(lv, s9928c61f17, ABISELECT(4720,4716), "S9928C61.s9928c61f17");
    check_field_offset(lv, s9928c61f18, ABISELECT(4724,4720), "S9928C61.s9928c61f18");
    check_field_offset(lv, s9928c61f19, ABISELECT(4728,4724), "S9928C61.s9928c61f19");
    check_field_offset(lv, s9928c61f20, ABISELECT(4732,4728), "S9928C61.s9928c61f20");
    check_field_offset(lv, s9928c61f21, ABISELECT(4736,4732), "S9928C61.s9928c61f21");
    check_field_offset(lv, s9928c61f22, ABISELECT(4740,4736), "S9928C61.s9928c61f22");
    check_field_offset(lv, s9928c61f23, ABISELECT(4744,4740), "S9928C61.s9928c61f23");
    check_field_offset(lv, s9928c61f24, ABISELECT(4748,4744), "S9928C61.s9928c61f24");
    check_field_offset(lv, s9928c61f25, ABISELECT(4752,4748), "S9928C61.s9928c61f25");
    check_field_offset(lv, s9928c61f26, ABISELECT(4756,4752), "S9928C61.s9928c61f26");
    check_field_offset(lv, s9928c61f27, ABISELECT(4760,4756), "S9928C61.s9928c61f27");
    check_field_offset(lv, s9928c61f28, ABISELECT(4764,4760), "S9928C61.s9928c61f28");
    check_field_offset(lv, s9928c61f29, ABISELECT(4765,4761), "S9928C61.s9928c61f29");
    check_field_offset(lv, s9928c61f30, ABISELECT(4768,4764), "S9928C61.s9928c61f30");
    check_field_offset(lv, s9928c61f31, ABISELECT(4772,4768), "S9928C61.s9928c61f31");
    check_field_offset(lv, s9928c61f32, ABISELECT(4776,4772), "S9928C61.s9928c61f32");
    check_field_offset(lv, s9928c61f33, ABISELECT(4780,4776), "S9928C61.s9928c61f33");
    check_field_offset(lv, s9928c61f34, ABISELECT(4784,4780), "S9928C61.s9928c61f34");
    check_field_offset(lv, s9928c61f35, ABISELECT(4788,4784), "S9928C61.s9928c61f35");
    check_field_offset(lv, s9928c61f36, ABISELECT(4792,4788), "S9928C61.s9928c61f36");
    check_field_offset(lv, s9928c61f37, ABISELECT(4796,4792), "S9928C61.s9928c61f37");
    check_field_offset(lv, s9928c61f38, ABISELECT(4800,4796), "S9928C61.s9928c61f38");
    check_field_offset(lv, s9928c61f39, ABISELECT(4804,4800), "S9928C61.s9928c61f39");
    check_field_offset(lv, s9928c61f40, ABISELECT(4808,4804), "S9928C61.s9928c61f40");
    check_field_offset(lv, s9928c61f41, ABISELECT(4812,4808), "S9928C61.s9928c61f41");
    check_field_offset(lv, s9928c61f42, ABISELECT(4816,4812), "S9928C61.s9928c61f42");
    check_field_offset(lv, s9928c61f43, ABISELECT(4820,4816), "S9928C61.s9928c61f43");
    check_field_offset(lv, s9928c61f44, ABISELECT(4824,4820), "S9928C61.s9928c61f44");
    check_field_offset(lv, s9928c61f45, ABISELECT(4828,4824), "S9928C61.s9928c61f45");
    check_field_offset(lv, s9928c61f46, ABISELECT(4832,4828), "S9928C61.s9928c61f46");
    check_field_offset(lv, s9928c61f47, ABISELECT(4836,4832), "S9928C61.s9928c61f47");
    check_field_offset(lv, s9928c61f48, ABISELECT(4840,4836), "S9928C61.s9928c61f48");
    check_field_offset(lv, s9928c61f49, ABISELECT(4844,4840), "S9928C61.s9928c61f49");
    test_class_info(&lv, &cd_S9928C61);
    dp->~S9928C61();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C61(Test_S9928C61, "S9928C61", ABISELECT(4848,4844));

#else // __cplusplus

extern void _ZN8S9928C61C1Ev();
extern void _ZN8S9928C61D1Ev();
Name_Map name_map_S9928C61[] = {
  NSPAIR(_ZN8S9928C61C1Ev),
  NSPAIR(_ZN8S9928C61D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9928C2;
extern VTBL_ENTRY _ZTI7S9928C2[];
extern  VTBL_ENTRY _ZTV7S9928C2[];
static Base_Class bases_S9928C61[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9928C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9928C61[];
extern void _ZN8S9928C61D1Ev();
extern void _ZN8S9928C61D0Ev();
extern void _ZN7S9928C22v5Ev();
extern void _ZN7S9928C22v6Ev();
extern void _ZN7S9928C22v7Ev();
extern void _ZN7S9928C22v8Ev();
extern void _ZN7S9928C22v9Ev();
extern void _ZN8S9928C613v24Ev();
extern void _ZN8S9928C613v25Ev();
static  VTBL_ENTRY vtc_S9928C61[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9928C61[0]),
  (VTBL_ENTRY)&_ZN8S9928C61D1Ev,
  (VTBL_ENTRY)&_ZN8S9928C61D0Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v9Ev,
  (VTBL_ENTRY)&_ZN8S9928C613v24Ev,
  (VTBL_ENTRY)&_ZN8S9928C613v25Ev,
};
extern VTBL_ENTRY _ZTI8S9928C61[];
extern  VTBL_ENTRY _ZTV8S9928C61[];
Class_Descriptor cd_S9928C61 = {  "S9928C61", // class name
  bases_S9928C61, 1,
  &(vtc_S9928C61[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(4848,4844), // object size
  NSPAIRA(_ZTI8S9928C61),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9928C61),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C68  {
  char s9928c68f0;
  char s9928c68f1;
  int s9928c68f2;
  char s9928c68f3;
  int s9928c68f4;
  char s9928c68f5;
  int s9928c68f6;
  void  mf9928c68(); // _ZN8S9928C689mf9928c68Ev
};
//SIG(-1 S9928C68) C1{ m Fc[2] Fi Fc Fi Fc Fi}


void  S9928C68 ::mf9928c68(){}

static void Test_S9928C68()
{
  {
    init_simple_test("S9928C68");
    S9928C68 lv;
    check2(sizeof(lv), 24, "sizeof(S9928C68)");
    check2(__alignof__(lv), 4, "__alignof__(S9928C68)");
    check_field_offset(lv, s9928c68f0, 0, "S9928C68.s9928c68f0");
    check_field_offset(lv, s9928c68f1, 1, "S9928C68.s9928c68f1");
    check_field_offset(lv, s9928c68f2, 4, "S9928C68.s9928c68f2");
    check_field_offset(lv, s9928c68f3, 8, "S9928C68.s9928c68f3");
    check_field_offset(lv, s9928c68f4, 12, "S9928C68.s9928c68f4");
    check_field_offset(lv, s9928c68f5, 16, "S9928C68.s9928c68f5");
    check_field_offset(lv, s9928c68f6, 20, "S9928C68.s9928c68f6");
  }
}
static Arrange_To_Call_Me vS9928C68(Test_S9928C68, "S9928C68", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C67  : S9928C2 {
  void *s9928c67f0[20];
  char s9928c67f1[20];
  char s9928c67f2;
  void *s9928c67f3[20];
  void *s9928c67f4[20];
  ::S15308C2_nt s9928c67f5;
  char s9928c67f6;
  ::S9928C68 s9928c67f7;
  void *s9928c67f8;
  int s9928c67f9;
  int s9928c67f10;
  int s9928c67f11;
  void *s9928c67f12;
  void *s9928c67f13;
  ::S15308C2_nt s9928c67f14[9];
  void *s9928c67f15[9];
  virtual  ~S9928C67(); // _ZN8S9928C67D1Ev
  virtual void  v26(); // _ZN8S9928C673v26Ev
  virtual void  v27(); // _ZN8S9928C673v27Ev
  virtual void  v28(); // _ZN8S9928C673v28Ev
  virtual void  v29(); // _ZN8S9928C673v29Ev
  S9928C67(); // tgen
};
//SIG(-1 S9928C67) C1{ BC2{ vd v5 v6 v7 v8 v9} vd v1 v2 v3 v4 Fp[20] Fc[21] Fp[40] FC3{ BC4{ BC5{ BC6{}} FC7{ BC8{}}} FU9{ Fc[16] Fp} Fi Fi} Fc FC10{ m Fc Fc Fi Fc Fi Fc Fi} Fp Fi Fi Fi Fp Fp FC3[9] Fp[9]}


 S9928C67 ::~S9928C67(){ note_dtor("S9928C67", this);}
void  S9928C67 ::v26(){vfunc_called(this, "_ZN8S9928C673v26Ev");}
void  S9928C67 ::v27(){vfunc_called(this, "_ZN8S9928C673v27Ev");}
void  S9928C67 ::v28(){vfunc_called(this, "_ZN8S9928C673v28Ev");}
void  S9928C67 ::v29(){vfunc_called(this, "_ZN8S9928C673v29Ev");}
S9928C67 ::S9928C67(){ note_ctor("S9928C67", this);} // tgen

static void Test_S9928C67()
{
  extern Class_Descriptor cd_S9928C67;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(123,160)];
    init_test(&cd_S9928C67, buf);
    S9928C67 *dp, &lv = *(dp=new (buf) S9928C67());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(976,636), "sizeof(S9928C67)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C67)");
    check_base_class_offset(lv, (S9928C2*), 0, "S9928C67");
    check_field_offset(lv, s9928c67f0, ABISELECT(8,4), "S9928C67.s9928c67f0");
    check_field_offset(lv, s9928c67f1, ABISELECT(168,84), "S9928C67.s9928c67f1");
    check_field_offset(lv, s9928c67f2, ABISELECT(188,104), "S9928C67.s9928c67f2");
    check_field_offset(lv, s9928c67f3, ABISELECT(192,108), "S9928C67.s9928c67f3");
    check_field_offset(lv, s9928c67f4, ABISELECT(352,188), "S9928C67.s9928c67f4");
    check_field_offset(lv, s9928c67f5, ABISELECT(512,268), "S9928C67.s9928c67f5");
    check_field_offset(lv, s9928c67f6, ABISELECT(544,296), "S9928C67.s9928c67f6");
    check_field_offset(lv, s9928c67f7, ABISELECT(548,300), "S9928C67.s9928c67f7");
    check_field_offset(lv, s9928c67f8, ABISELECT(576,324), "S9928C67.s9928c67f8");
    check_field_offset(lv, s9928c67f9, ABISELECT(584,328), "S9928C67.s9928c67f9");
    check_field_offset(lv, s9928c67f10, ABISELECT(588,332), "S9928C67.s9928c67f10");
    check_field_offset(lv, s9928c67f11, ABISELECT(592,336), "S9928C67.s9928c67f11");
    check_field_offset(lv, s9928c67f12, ABISELECT(600,340), "S9928C67.s9928c67f12");
    check_field_offset(lv, s9928c67f13, ABISELECT(608,344), "S9928C67.s9928c67f13");
    check_field_offset(lv, s9928c67f14, ABISELECT(616,348), "S9928C67.s9928c67f14");
    check_field_offset(lv, s9928c67f15, ABISELECT(904,600), "S9928C67.s9928c67f15");
    test_class_info(&lv, &cd_S9928C67);
    dp->~S9928C67();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C67(Test_S9928C67, "S9928C67", ABISELECT(976,636));

#else // __cplusplus

extern void _ZN8S9928C67C1Ev();
extern void _ZN8S9928C67D1Ev();
Name_Map name_map_S9928C67[] = {
  NSPAIR(_ZN8S9928C67C1Ev),
  NSPAIR(_ZN8S9928C67D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9928C2;
extern VTBL_ENTRY _ZTI7S9928C2[];
extern  VTBL_ENTRY _ZTV7S9928C2[];
static Base_Class bases_S9928C67[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9928C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9928C67[];
extern void _ZN8S9928C67D1Ev();
extern void _ZN8S9928C67D0Ev();
extern void _ZN7S9928C22v5Ev();
extern void _ZN7S9928C22v6Ev();
extern void _ZN7S9928C22v7Ev();
extern void _ZN7S9928C22v8Ev();
extern void _ZN7S9928C22v9Ev();
extern void _ZN8S9928C673v26Ev();
extern void _ZN8S9928C673v27Ev();
extern void _ZN8S9928C673v28Ev();
extern void _ZN8S9928C673v29Ev();
static  VTBL_ENTRY vtc_S9928C67[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9928C67[0]),
  (VTBL_ENTRY)&_ZN8S9928C67D1Ev,
  (VTBL_ENTRY)&_ZN8S9928C67D0Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v9Ev,
  (VTBL_ENTRY)&_ZN8S9928C673v26Ev,
  (VTBL_ENTRY)&_ZN8S9928C673v27Ev,
  (VTBL_ENTRY)&_ZN8S9928C673v28Ev,
  (VTBL_ENTRY)&_ZN8S9928C673v29Ev,
};
extern VTBL_ENTRY _ZTI8S9928C67[];
extern  VTBL_ENTRY _ZTV8S9928C67[];
Class_Descriptor cd_S9928C67 = {  "S9928C67", // class name
  bases_S9928C67, 1,
  &(vtc_S9928C67[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(976,636), // object size
  NSPAIRA(_ZTI8S9928C67),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9928C67),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C69  : S9928C2 {
  char s9928c69f0;
  char s9928c69f1;
  void *s9928c69f2;
  int s9928c69f3;
  char s9928c69f4;
  int s9928c69f5;
  int s9928c69f6[21];
  int s9928c69f7;
  char s9928c69f8;
  char s9928c69f9;
  int s9928c69f10;
  int s9928c69f11;
  int s9928c69f12;
  int s9928c69f13;
  int s9928c69f14;
  int s9928c69f15;
  char s9928c69f16;
  char s9928c69f17;
  char s9928c69f18;
  int s9928c69f19;
  int s9928c69f20;
  char s9928c69f21;
  int s9928c69f22;
  int s9928c69f23;
  int s9928c69f24;
  int s9928c69f25;
  int s9928c69f26;
  int s9928c69f27;
  int s9928c69f28;
  int s9928c69f29;
  int s9928c69f30;
  int s9928c69f31;
  int s9928c69f32;
  char s9928c69f33;
  char s9928c69f34;
  void *s9928c69f35;
  virtual  ~S9928C69(); // _ZN8S9928C69D1Ev
  virtual void  v30(); // _ZN8S9928C693v30Ev
  virtual void  v31(); // _ZN8S9928C693v31Ev
  S9928C69(); // tgen
};
//SIG(-1 S9928C69) C1{ BC2{ vd v3 v4 v5 v6 v7} vd v1 v2 Fc[2] Fp Fi Fc Fi[23] Fc[2] Fi[6] Fc[3] Fi[2] Fc Fi[11] Fc[2] Fp}


 S9928C69 ::~S9928C69(){ note_dtor("S9928C69", this);}
void  S9928C69 ::v30(){vfunc_called(this, "_ZN8S9928C693v30Ev");}
void  S9928C69 ::v31(){vfunc_called(this, "_ZN8S9928C693v31Ev");}
S9928C69 ::S9928C69(){ note_ctor("S9928C69", this);} // tgen

static void Test_S9928C69()
{
  extern Class_Descriptor cd_S9928C69;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,53)];
    init_test(&cd_S9928C69, buf);
    S9928C69 *dp, &lv = *(dp=new (buf) S9928C69());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,208), "sizeof(S9928C69)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C69)");
    check_base_class_offset(lv, (S9928C2*), 0, "S9928C69");
    check_field_offset(lv, s9928c69f0, ABISELECT(8,4), "S9928C69.s9928c69f0");
    check_field_offset(lv, s9928c69f1, ABISELECT(9,5), "S9928C69.s9928c69f1");
    check_field_offset(lv, s9928c69f2, ABISELECT(16,8), "S9928C69.s9928c69f2");
    check_field_offset(lv, s9928c69f3, ABISELECT(24,12), "S9928C69.s9928c69f3");
    check_field_offset(lv, s9928c69f4, ABISELECT(28,16), "S9928C69.s9928c69f4");
    check_field_offset(lv, s9928c69f5, ABISELECT(32,20), "S9928C69.s9928c69f5");
    check_field_offset(lv, s9928c69f6, ABISELECT(36,24), "S9928C69.s9928c69f6");
    check_field_offset(lv, s9928c69f7, ABISELECT(120,108), "S9928C69.s9928c69f7");
    check_field_offset(lv, s9928c69f8, ABISELECT(124,112), "S9928C69.s9928c69f8");
    check_field_offset(lv, s9928c69f9, ABISELECT(125,113), "S9928C69.s9928c69f9");
    check_field_offset(lv, s9928c69f10, ABISELECT(128,116), "S9928C69.s9928c69f10");
    check_field_offset(lv, s9928c69f11, ABISELECT(132,120), "S9928C69.s9928c69f11");
    check_field_offset(lv, s9928c69f12, ABISELECT(136,124), "S9928C69.s9928c69f12");
    check_field_offset(lv, s9928c69f13, ABISELECT(140,128), "S9928C69.s9928c69f13");
    check_field_offset(lv, s9928c69f14, ABISELECT(144,132), "S9928C69.s9928c69f14");
    check_field_offset(lv, s9928c69f15, ABISELECT(148,136), "S9928C69.s9928c69f15");
    check_field_offset(lv, s9928c69f16, ABISELECT(152,140), "S9928C69.s9928c69f16");
    check_field_offset(lv, s9928c69f17, ABISELECT(153,141), "S9928C69.s9928c69f17");
    check_field_offset(lv, s9928c69f18, ABISELECT(154,142), "S9928C69.s9928c69f18");
    check_field_offset(lv, s9928c69f19, ABISELECT(156,144), "S9928C69.s9928c69f19");
    check_field_offset(lv, s9928c69f20, ABISELECT(160,148), "S9928C69.s9928c69f20");
    check_field_offset(lv, s9928c69f21, ABISELECT(164,152), "S9928C69.s9928c69f21");
    check_field_offset(lv, s9928c69f22, ABISELECT(168,156), "S9928C69.s9928c69f22");
    check_field_offset(lv, s9928c69f23, ABISELECT(172,160), "S9928C69.s9928c69f23");
    check_field_offset(lv, s9928c69f24, ABISELECT(176,164), "S9928C69.s9928c69f24");
    check_field_offset(lv, s9928c69f25, ABISELECT(180,168), "S9928C69.s9928c69f25");
    check_field_offset(lv, s9928c69f26, ABISELECT(184,172), "S9928C69.s9928c69f26");
    check_field_offset(lv, s9928c69f27, ABISELECT(188,176), "S9928C69.s9928c69f27");
    check_field_offset(lv, s9928c69f28, ABISELECT(192,180), "S9928C69.s9928c69f28");
    check_field_offset(lv, s9928c69f29, ABISELECT(196,184), "S9928C69.s9928c69f29");
    check_field_offset(lv, s9928c69f30, ABISELECT(200,188), "S9928C69.s9928c69f30");
    check_field_offset(lv, s9928c69f31, ABISELECT(204,192), "S9928C69.s9928c69f31");
    check_field_offset(lv, s9928c69f32, ABISELECT(208,196), "S9928C69.s9928c69f32");
    check_field_offset(lv, s9928c69f33, ABISELECT(212,200), "S9928C69.s9928c69f33");
    check_field_offset(lv, s9928c69f34, ABISELECT(213,201), "S9928C69.s9928c69f34");
    check_field_offset(lv, s9928c69f35, ABISELECT(216,204), "S9928C69.s9928c69f35");
    test_class_info(&lv, &cd_S9928C69);
    dp->~S9928C69();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C69(Test_S9928C69, "S9928C69", ABISELECT(224,208));

#else // __cplusplus

extern void _ZN8S9928C69C1Ev();
extern void _ZN8S9928C69D1Ev();
Name_Map name_map_S9928C69[] = {
  NSPAIR(_ZN8S9928C69C1Ev),
  NSPAIR(_ZN8S9928C69D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9928C2;
extern VTBL_ENTRY _ZTI7S9928C2[];
extern  VTBL_ENTRY _ZTV7S9928C2[];
static Base_Class bases_S9928C69[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9928C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9928C69[];
extern void _ZN8S9928C69D1Ev();
extern void _ZN8S9928C69D0Ev();
extern void _ZN7S9928C22v5Ev();
extern void _ZN7S9928C22v6Ev();
extern void _ZN7S9928C22v7Ev();
extern void _ZN7S9928C22v8Ev();
extern void _ZN7S9928C22v9Ev();
extern void _ZN8S9928C693v30Ev();
extern void _ZN8S9928C693v31Ev();
static  VTBL_ENTRY vtc_S9928C69[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9928C69[0]),
  (VTBL_ENTRY)&_ZN8S9928C69D1Ev,
  (VTBL_ENTRY)&_ZN8S9928C69D0Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v9Ev,
  (VTBL_ENTRY)&_ZN8S9928C693v30Ev,
  (VTBL_ENTRY)&_ZN8S9928C693v31Ev,
};
extern VTBL_ENTRY _ZTI8S9928C69[];
extern  VTBL_ENTRY _ZTV8S9928C69[];
Class_Descriptor cd_S9928C69 = {  "S9928C69", // class name
  bases_S9928C69, 1,
  &(vtc_S9928C69[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,208), // object size
  NSPAIRA(_ZTI8S9928C69),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9928C69),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9928C1  : S9928C2 , S9928C3_nt {
  ::S9928C4 s9928c1f0;
  ::S9928C39 s9928c1f1;
  ::S9928C44 s9928c1f2;
  ::S9928C53 s9928c1f3;
  ::S9928C56 s9928c1f4;
  ::S9928C61 s9928c1f5;
  ::S9928C67 s9928c1f6;
  ::S9928C69 s9928c1f7;
  ::S15308C2_nt s9928c1f8;
  int s9928c1f9;
  char s9928c1f10;
  int s9928c1f11;
  int s9928c1f12;
  char s9928c1f13;
  int s9928c1f14;
  int s9928c1f15;
  virtual  ~S9928C1(); // _ZN7S9928C1D1Ev
  virtual void  v1(); // _ZN7S9928C12v1Ev
  virtual void  v2(); // _ZN7S9928C12v2Ev
  virtual void  v3(); // _ZN7S9928C12v3Ev
  virtual void  v4(); // _ZN7S9928C12v4Ev
  S9928C1(); // tgen
};
//SIG(1 S9928C1) C1{ BC2{ vd v5 v6 v7 v8 v9} BC3{ vd v10 v11 v12 v13} vd v1 v2 v3 v4 FC4{ BC2 BC3 vd v14 v15 v16 v17 v18 v19 FC5{ BC6{ BC7{} FC8{ BC7}} Fp[3]} FC9{ m FC5 Fi FC10{ BC11{ BC12{ BC13{ BC14{ BC15{ BC16{} FC17{ BC18{}}} FC19{ BC20{}}} FC19} FC21{ BC22{}}} Fp Fi}} Fi} Fc[3] Fi FC23{ BC24{ BC7 FC25{ BC26{}}} Fp[3]} FC27{ BC28{ BC29{ BC16} FC30{ BC31{}}} FU32{ Fc[16] Fp} Fi Fi}} FC33{ BC2 vd v20 v21 FC34{ BC35{ BC16 FC8} Fp Fp Fp} FC34 Fi Fc} FC36{ BC2 vd v22 v23 Fc FC37{ BC38{ BC16 FC8} Fp Fp Fp} FC39{ BC40{ BC16 FC41{ BC42{}}} Fp Fp Fp}} FC43{ m Fc Fi Fi FC44{ BC45{ m Fc Fc[15]}} FC44 FC27 Fi Fi Fi Fi Fp} FC46{ m Fi Fi Fc FC47{ BC48{ BC16 FC30} Fp Fp Fp}} FC49{ BC2 vd v24 v25 FC50{ Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi FC51{ Fi Fi Fi Fi} FC52{ m Fi Fi Fi Fi Fi Fc Fi Fi}}[21] FC53{ Fi Fi Fi Fi Fi}[7] Fi[21] FC44[21] FC54{ Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi FC44 FC44}[21] Fi Fc Fc Fc Fc Fc Fi Fi Fi Fc Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fc Fc Fi Fc Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi} FC55{ BC2 vd v26 v27 v28 v29 Fp[20] Fc[20] Fc Fp[20] Fp[20] FC27 Fc FC56{ m Fc Fc Fi Fc Fi Fc Fi} Fp Fi Fi Fi Fp Fp FC27[9] Fp[9]} FC57{ BC2 vd v30 v31 Fc Fc Fp Fi Fc Fi Fi[21] Fi Fc Fc Fi Fi Fi Fi Fi Fi Fc Fc Fc Fi Fi Fc Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fi Fc Fc Fp} FC27 Fi Fc Fi Fi Fc Fi Fi}


 S9928C1 ::~S9928C1(){ note_dtor("S9928C1", this);}
void  S9928C1 ::v1(){vfunc_called(this, "_ZN7S9928C12v1Ev");}
void  S9928C1 ::v2(){vfunc_called(this, "_ZN7S9928C12v2Ev");}
void  S9928C1 ::v3(){vfunc_called(this, "_ZN7S9928C12v3Ev");}
void  S9928C1 ::v4(){vfunc_called(this, "_ZN7S9928C12v4Ev");}
S9928C1 ::S9928C1(){ note_ctor("S9928C1", this);} // tgen

static void Test_S9928C1()
{
  extern Class_Descriptor cd_S9928C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(830,1518)];
    init_test(&cd_S9928C1, buf);
    S9928C1 *dp, &lv = *(dp=new (buf) S9928C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6632,6068), "sizeof(S9928C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9928C1)");
    check_base_class_offset(lv, (S9928C2*), 0, "S9928C1");
    check_base_class_offset(lv, (S9928C3_nt*), ABISELECT(8,4), "S9928C1");
    check_field_offset(lv, s9928c1f0, ABISELECT(16,8), "S9928C1.s9928c1f0");
    check_field_offset(lv, s9928c1f1, ABISELECT(208,120), "S9928C1.s9928c1f1");
    check_field_offset(lv, s9928c1f2, ABISELECT(288,164), "S9928C1.s9928c1f2");
    check_field_offset(lv, s9928c1f3, ABISELECT(368,204), "S9928C1.s9928c1f3");
    check_field_offset(lv, s9928c1f4, ABISELECT(472,296), "S9928C1.s9928c1f4");
    check_field_offset(lv, s9928c1f5, ABISELECT(520,324), "S9928C1.s9928c1f5");
    check_field_offset(lv, s9928c1f6, ABISELECT(5368,5168), "S9928C1.s9928c1f6");
    check_field_offset(lv, s9928c1f7, ABISELECT(6344,5804), "S9928C1.s9928c1f7");
    check_field_offset(lv, s9928c1f8, ABISELECT(6568,6012), "S9928C1.s9928c1f8");
    check_field_offset(lv, s9928c1f9, ABISELECT(6600,6040), "S9928C1.s9928c1f9");
    check_field_offset(lv, s9928c1f10, ABISELECT(6604,6044), "S9928C1.s9928c1f10");
    check_field_offset(lv, s9928c1f11, ABISELECT(6608,6048), "S9928C1.s9928c1f11");
    check_field_offset(lv, s9928c1f12, ABISELECT(6612,6052), "S9928C1.s9928c1f12");
    check_field_offset(lv, s9928c1f13, ABISELECT(6616,6056), "S9928C1.s9928c1f13");
    check_field_offset(lv, s9928c1f14, ABISELECT(6620,6060), "S9928C1.s9928c1f14");
    check_field_offset(lv, s9928c1f15, ABISELECT(6624,6064), "S9928C1.s9928c1f15");
    test_class_info(&lv, &cd_S9928C1);
    dp->~S9928C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9928C1(Test_S9928C1, "S9928C1", ABISELECT(6632,6068));

#else // __cplusplus

extern void _ZN7S9928C1C1Ev();
extern void _ZN7S9928C1D1Ev();
Name_Map name_map_S9928C1[] = {
  NSPAIR(_ZN7S9928C1C1Ev),
  NSPAIR(_ZN7S9928C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9928C2;
extern VTBL_ENTRY _ZTI7S9928C2[];
extern  VTBL_ENTRY _ZTV7S9928C2[];
extern Class_Descriptor cd_S9928C3_nt;
extern VTBL_ENTRY _ZTI10S9928C3_nt[];
extern  VTBL_ENTRY _ZTV10S9928C3_nt[];
static Base_Class bases_S9928C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9928C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9928C3_nt,    ABISELECT(8,4), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9928C1[];
extern void _ZN7S9928C1D1Ev();
extern void _ZN7S9928C1D0Ev();
extern void _ZN7S9928C22v5Ev();
extern void _ZN7S9928C22v6Ev();
extern void _ZN7S9928C22v7Ev();
extern void _ZN7S9928C22v8Ev();
extern void _ZN7S9928C22v9Ev();
extern void _ZN7S9928C12v1Ev();
extern void _ZN7S9928C12v2Ev();
extern void _ZN7S9928C12v3Ev();
extern void _ZN7S9928C12v4Ev();
extern void ABISELECT(_ZThn8_N7S9928C1D1Ev,_ZThn4_N7S9928C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9928C1D0Ev,_ZThn4_N7S9928C1D0Ev)();
extern void _ZN10S9928C3_nt3v10Ev();
extern void _ZN10S9928C3_nt3v11Ev();
extern void _ZN10S9928C3_nt3v12Ev();
extern void _ZN10S9928C3_nt3v13Ev();
static  VTBL_ENTRY vtc_S9928C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9928C1[0]),
  (VTBL_ENTRY)&_ZN7S9928C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9928C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9928C22v9Ev,
  (VTBL_ENTRY)&_ZN7S9928C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9928C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9928C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9928C12v4Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9928C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9928C1D1Ev,_ZThn4_N7S9928C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9928C1D0Ev,_ZThn4_N7S9928C1D0Ev),
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S9928C3_nt3v13Ev,
};
extern VTBL_ENTRY _ZTI7S9928C1[];
extern  VTBL_ENTRY _ZTV7S9928C1[];
Class_Descriptor cd_S9928C1 = {  "S9928C1", // class name
  bases_S9928C1, 2,
  &(vtc_S9928C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6632,6068), // object size
  NSPAIRA(_ZTI7S9928C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9928C1),21, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C3  {
  virtual  ~S4658C3(); // _ZN7S4658C3D1Ev
  virtual void  v21(); // _ZN7S4658C33v21Ev
  virtual void  v22(); // _ZN7S4658C33v22Ev
  virtual void  v23(); // _ZN7S4658C33v23Ev
  virtual void  v24(); // _ZN7S4658C33v24Ev
  virtual void  v25(); // _ZN7S4658C33v25Ev
  virtual void  v26(); // _ZN7S4658C33v26Ev
  virtual void  v27(); // _ZN7S4658C33v27Ev
  virtual void  v28(); // _ZN7S4658C33v28Ev
  virtual void  v29(); // _ZN7S4658C33v29Ev
  virtual void  v30(); // _ZN7S4658C33v30Ev
  virtual void  v31(); // _ZN7S4658C33v31Ev
  virtual void  v32(); // _ZN7S4658C33v32Ev
  virtual void  v33(); // _ZN7S4658C33v33Ev
  virtual void  v34(); // _ZN7S4658C33v34Ev
  virtual void  v35(); // _ZN7S4658C33v35Ev
  virtual void  v36(); // _ZN7S4658C33v36Ev
  virtual void  v37(); // _ZN7S4658C33v37Ev
  virtual void  v38(); // _ZN7S4658C33v38Ev
  virtual void  v39(); // _ZN7S4658C33v39Ev
  virtual void  v40(); // _ZN7S4658C33v40Ev
  virtual void  v41(); // _ZN7S4658C33v41Ev
  virtual void  v42(); // _ZN7S4658C33v42Ev
  virtual void  v43(); // _ZN7S4658C33v43Ev
  virtual void  v44(); // _ZN7S4658C33v44Ev
  virtual void  v45(); // _ZN7S4658C33v45Ev
  virtual void  v46(); // _ZN7S4658C33v46Ev
  virtual void  v47(); // _ZN7S4658C33v47Ev
  virtual void  v48(); // _ZN7S4658C33v48Ev
  virtual void  v49(); // _ZN7S4658C33v49Ev
  virtual void  v50(); // _ZN7S4658C33v50Ev
  virtual void  v51(); // _ZN7S4658C33v51Ev
  virtual void  v52(); // _ZN7S4658C33v52Ev
  virtual void  v53(); // _ZN7S4658C33v53Ev
  virtual void  v54(); // _ZN7S4658C33v54Ev
  virtual void  v55(); // _ZN7S4658C33v55Ev
  virtual void  v56(); // _ZN7S4658C33v56Ev
  virtual void  v57(); // _ZN7S4658C33v57Ev
  virtual void  v58(); // _ZN7S4658C33v58Ev
  virtual void  v59(); // _ZN7S4658C33v59Ev
  virtual void  v60(); // _ZN7S4658C33v60Ev
  virtual void  v61(); // _ZN7S4658C33v61Ev
  virtual void  v62(); // _ZN7S4658C33v62Ev
  virtual void  v63(); // _ZN7S4658C33v63Ev
  virtual void  v64(); // _ZN7S4658C33v64Ev
  virtual void  v65(); // _ZN7S4658C33v65Ev
  virtual void  v66(); // _ZN7S4658C33v66Ev
  virtual void  v67(); // _ZN7S4658C33v67Ev
  S4658C3(); // tgen
};
//SIG(-1 S4658C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47}


 S4658C3 ::~S4658C3(){ note_dtor("S4658C3", this);}
void  S4658C3 ::v21(){vfunc_called(this, "_ZN7S4658C33v21Ev");}
void  S4658C3 ::v22(){vfunc_called(this, "_ZN7S4658C33v22Ev");}
void  S4658C3 ::v23(){vfunc_called(this, "_ZN7S4658C33v23Ev");}
void  S4658C3 ::v24(){vfunc_called(this, "_ZN7S4658C33v24Ev");}
void  S4658C3 ::v25(){vfunc_called(this, "_ZN7S4658C33v25Ev");}
void  S4658C3 ::v26(){vfunc_called(this, "_ZN7S4658C33v26Ev");}
void  S4658C3 ::v27(){vfunc_called(this, "_ZN7S4658C33v27Ev");}
void  S4658C3 ::v28(){vfunc_called(this, "_ZN7S4658C33v28Ev");}
void  S4658C3 ::v29(){vfunc_called(this, "_ZN7S4658C33v29Ev");}
void  S4658C3 ::v30(){vfunc_called(this, "_ZN7S4658C33v30Ev");}
void  S4658C3 ::v31(){vfunc_called(this, "_ZN7S4658C33v31Ev");}
void  S4658C3 ::v32(){vfunc_called(this, "_ZN7S4658C33v32Ev");}
void  S4658C3 ::v33(){vfunc_called(this, "_ZN7S4658C33v33Ev");}
void  S4658C3 ::v34(){vfunc_called(this, "_ZN7S4658C33v34Ev");}
void  S4658C3 ::v35(){vfunc_called(this, "_ZN7S4658C33v35Ev");}
void  S4658C3 ::v36(){vfunc_called(this, "_ZN7S4658C33v36Ev");}
void  S4658C3 ::v37(){vfunc_called(this, "_ZN7S4658C33v37Ev");}
void  S4658C3 ::v38(){vfunc_called(this, "_ZN7S4658C33v38Ev");}
void  S4658C3 ::v39(){vfunc_called(this, "_ZN7S4658C33v39Ev");}
void  S4658C3 ::v40(){vfunc_called(this, "_ZN7S4658C33v40Ev");}
void  S4658C3 ::v41(){vfunc_called(this, "_ZN7S4658C33v41Ev");}
void  S4658C3 ::v42(){vfunc_called(this, "_ZN7S4658C33v42Ev");}
void  S4658C3 ::v43(){vfunc_called(this, "_ZN7S4658C33v43Ev");}
void  S4658C3 ::v44(){vfunc_called(this, "_ZN7S4658C33v44Ev");}
void  S4658C3 ::v45(){vfunc_called(this, "_ZN7S4658C33v45Ev");}
void  S4658C3 ::v46(){vfunc_called(this, "_ZN7S4658C33v46Ev");}
void  S4658C3 ::v47(){vfunc_called(this, "_ZN7S4658C33v47Ev");}
void  S4658C3 ::v48(){vfunc_called(this, "_ZN7S4658C33v48Ev");}
void  S4658C3 ::v49(){vfunc_called(this, "_ZN7S4658C33v49Ev");}
void  S4658C3 ::v50(){vfunc_called(this, "_ZN7S4658C33v50Ev");}
void  S4658C3 ::v51(){vfunc_called(this, "_ZN7S4658C33v51Ev");}
void  S4658C3 ::v52(){vfunc_called(this, "_ZN7S4658C33v52Ev");}
void  S4658C3 ::v53(){vfunc_called(this, "_ZN7S4658C33v53Ev");}
void  S4658C3 ::v54(){vfunc_called(this, "_ZN7S4658C33v54Ev");}
void  S4658C3 ::v55(){vfunc_called(this, "_ZN7S4658C33v55Ev");}
void  S4658C3 ::v56(){vfunc_called(this, "_ZN7S4658C33v56Ev");}
void  S4658C3 ::v57(){vfunc_called(this, "_ZN7S4658C33v57Ev");}
void  S4658C3 ::v58(){vfunc_called(this, "_ZN7S4658C33v58Ev");}
void  S4658C3 ::v59(){vfunc_called(this, "_ZN7S4658C33v59Ev");}
void  S4658C3 ::v60(){vfunc_called(this, "_ZN7S4658C33v60Ev");}
void  S4658C3 ::v61(){vfunc_called(this, "_ZN7S4658C33v61Ev");}
void  S4658C3 ::v62(){vfunc_called(this, "_ZN7S4658C33v62Ev");}
void  S4658C3 ::v63(){vfunc_called(this, "_ZN7S4658C33v63Ev");}
void  S4658C3 ::v64(){vfunc_called(this, "_ZN7S4658C33v64Ev");}
void  S4658C3 ::v65(){vfunc_called(this, "_ZN7S4658C33v65Ev");}
void  S4658C3 ::v66(){vfunc_called(this, "_ZN7S4658C33v66Ev");}
void  S4658C3 ::v67(){vfunc_called(this, "_ZN7S4658C33v67Ev");}
S4658C3 ::S4658C3(){ note_ctor("S4658C3", this);} // tgen

static void Test_S4658C3()
{
  extern Class_Descriptor cd_S4658C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4658C3, buf);
    S4658C3 *dp, &lv = *(dp=new (buf) S4658C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4658C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4658C3)");
    test_class_info(&lv, &cd_S4658C3);
    dp->~S4658C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4658C3(Test_S4658C3, "S4658C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4658C3C1Ev();
extern void _ZN7S4658C3D1Ev();
Name_Map name_map_S4658C3[] = {
  NSPAIR(_ZN7S4658C3C1Ev),
  NSPAIR(_ZN7S4658C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4658C3[];
extern void _ZN7S4658C3D1Ev();
extern void _ZN7S4658C3D0Ev();
extern void _ZN7S4658C33v21Ev();
extern void _ZN7S4658C33v22Ev();
extern void _ZN7S4658C33v23Ev();
extern void _ZN7S4658C33v24Ev();
extern void _ZN7S4658C33v25Ev();
extern void _ZN7S4658C33v26Ev();
extern void _ZN7S4658C33v27Ev();
extern void _ZN7S4658C33v28Ev();
extern void _ZN7S4658C33v29Ev();
extern void _ZN7S4658C33v30Ev();
extern void _ZN7S4658C33v31Ev();
extern void _ZN7S4658C33v32Ev();
extern void _ZN7S4658C33v33Ev();
extern void _ZN7S4658C33v34Ev();
extern void _ZN7S4658C33v35Ev();
extern void _ZN7S4658C33v36Ev();
extern void _ZN7S4658C33v37Ev();
extern void _ZN7S4658C33v38Ev();
extern void _ZN7S4658C33v39Ev();
extern void _ZN7S4658C33v40Ev();
extern void _ZN7S4658C33v41Ev();
extern void _ZN7S4658C33v42Ev();
extern void _ZN7S4658C33v43Ev();
extern void _ZN7S4658C33v44Ev();
extern void _ZN7S4658C33v45Ev();
extern void _ZN7S4658C33v46Ev();
extern void _ZN7S4658C33v47Ev();
extern void _ZN7S4658C33v48Ev();
extern void _ZN7S4658C33v49Ev();
extern void _ZN7S4658C33v50Ev();
extern void _ZN7S4658C33v51Ev();
extern void _ZN7S4658C33v52Ev();
extern void _ZN7S4658C33v53Ev();
extern void _ZN7S4658C33v54Ev();
extern void _ZN7S4658C33v55Ev();
extern void _ZN7S4658C33v56Ev();
extern void _ZN7S4658C33v57Ev();
extern void _ZN7S4658C33v58Ev();
extern void _ZN7S4658C33v59Ev();
extern void _ZN7S4658C33v60Ev();
extern void _ZN7S4658C33v61Ev();
extern void _ZN7S4658C33v62Ev();
extern void _ZN7S4658C33v63Ev();
extern void _ZN7S4658C33v64Ev();
extern void _ZN7S4658C33v65Ev();
extern void _ZN7S4658C33v66Ev();
extern void _ZN7S4658C33v67Ev();
static  VTBL_ENTRY vtc_S4658C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4658C3[0]),
  (VTBL_ENTRY)&_ZN7S4658C3D1Ev,
  (VTBL_ENTRY)&_ZN7S4658C3D0Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v42Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v43Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v44Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v45Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v46Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v47Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v48Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v49Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v50Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v51Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v52Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v53Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v54Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v55Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v56Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v57Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v58Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v59Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v60Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v61Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v62Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v63Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v64Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v65Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v66Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v67Ev,
};
extern VTBL_ENTRY _ZTI7S4658C3[];
extern  VTBL_ENTRY _ZTV7S4658C3[];
Class_Descriptor cd_S4658C3 = {  "S4658C3", // class name
  0,0,//no base classes
  &(vtc_S4658C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4658C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4658C3),51, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C7  : S15308C228 {
  ::S15308C227 s4658c7f0;
};
//SIG(-1 S4658C7) C1{ BC2{} FC3{ BC2}}



static void Test_S4658C7()
{
  extern Class_Descriptor cd_S4658C7;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_S4658C7, buf);
    S4658C7 &lv = *(new (buf) S4658C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(S4658C7)");
    check2(__alignof__(lv), 1, "__alignof__(S4658C7)");
    check_base_class_offset(lv, (S15308C228*), 0, "S4658C7");
    check_field_offset(lv, s4658c7f0, 1, "S4658C7.s4658c7f0");
    test_class_info(&lv, &cd_S4658C7);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4658C7(Test_S4658C7, "S4658C7", 2);

#else // __cplusplus

extern Class_Descriptor cd_S15308C228;
static Base_Class bases_S4658C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C228,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S4658C7 = {  "S4658C7", // class name
  bases_S4658C7, 1,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C6  : S4658C7 {
  ::S15308C220 s4658c6f0;
};
//SIG(-1 S4658C6) C1{ BC2{ BC3{} FC4{ BC3}} FC5{ BC6{}}}



static void Test_S4658C6()
{
  extern Class_Descriptor cd_S4658C6;
  void *lvp;
  {
    char buf[3];
    init_test(&cd_S4658C6, buf);
    S4658C6 &lv = *(new (buf) S4658C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(S4658C6)");
    check2(__alignof__(lv), 1, "__alignof__(S4658C6)");
    check_base_class_offset(lv, (S15308C228*)(S4658C7*), 0, "S4658C6");
    check_base_class_offset(lv, (S4658C7*), 0, "S4658C6");
    check_field_offset(lv, s4658c6f0, 2, "S4658C6.s4658c6f0");
    test_class_info(&lv, &cd_S4658C6);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4658C6(Test_S4658C6, "S4658C6", 3);

#else // __cplusplus

extern Class_Descriptor cd_S15308C228;
extern Class_Descriptor cd_S4658C7;
static Base_Class bases_S4658C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C228,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4658C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S4658C6 = {  "S4658C6", // class name
  bases_S4658C6, 2,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C5  : S4658C6 {
  void *s4658c5f0;
  int s4658c5f1[3];
};
//SIG(-1 S4658C5) C1{ BC2{ BC3{ BC4{} FC5{ BC4}} FC6{ BC7{}}} Fp Fi[3]}



static void Test_S4658C5()
{
  extern Class_Descriptor cd_S4658C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S4658C5, buf);
    S4658C5 &lv = *(new (buf) S4658C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S4658C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4658C5)");
    check_base_class_offset(lv, (S15308C228*)(S4658C7*)(S4658C6*), 0, "S4658C5");
    check_base_class_offset(lv, (S4658C7*)(S4658C6*), 0, "S4658C5");
    check_base_class_offset(lv, (S4658C6*), 0, "S4658C5");
    check_field_offset(lv, s4658c5f0, ABISELECT(8,4), "S4658C5.s4658c5f0");
    check_field_offset(lv, s4658c5f1, ABISELECT(16,8), "S4658C5.s4658c5f1");
    test_class_info(&lv, &cd_S4658C5);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4658C5(Test_S4658C5, "S4658C5", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd_S15308C228;
extern Class_Descriptor cd_S4658C7;
extern Class_Descriptor cd_S4658C6;
static Base_Class bases_S4658C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S15308C228,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4658C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S4658C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S4658C5 = {  "S4658C5", // class name
  bases_S4658C5, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C4  {
  ::S4658C5 s4658c4f0;
  void  mf4658c4(); // _ZN7S4658C48mf4658c4Ev
};
//SIG(-1 S4658C4) C1{ m FC2{ BC3{ BC4{ BC5{} FC6{ BC5}} FC7{ BC8{}}} Fp Fi[3]}}


void  S4658C4 ::mf4658c4(){}

static void Test_S4658C4()
{
  {
    init_simple_test("S4658C4");
    S4658C4 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S4658C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4658C4)");
    check_field_offset(lv, s4658c4f0, 0, "S4658C4.s4658c4f0");
  }
}
static Arrange_To_Call_Me vS4658C4(Test_S4658C4, "S4658C4", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C21_nt  {
  int s4658c21f0[3];
  void  mf4658c21(); // _ZN11S4658C21_nt9mf4658c21Ev
};
//SIG(-1 S4658C21_nt) C1{ m Fi[3]}


void  S4658C21_nt ::mf4658c21(){}

//skip512 S4658C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C22  {
  ::S4658C5 s4658c22f0;
  void  mf4658c22(); // _ZN8S4658C229mf4658c22Ev
};
//SIG(-1 S4658C22) C1{ m FC2{ BC3{ BC4{ BC5{} FC6{ BC5}} FC7{ BC8{}}} Fp Fi[3]}}


void  S4658C22 ::mf4658c22(){}

static void Test_S4658C22()
{
  {
    init_simple_test("S4658C22");
    S4658C22 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S4658C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4658C22)");
    check_field_offset(lv, s4658c22f0, 0, "S4658C22.s4658c22f0");
  }
}
static Arrange_To_Call_Me vS4658C22(Test_S4658C22, "S4658C22", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C32_nt  {
  int s4658c32f0[2];
  void  mf4658c32(); // _ZN11S4658C32_nt9mf4658c32Ev
};
//SIG(-1 S4658C32_nt) C1{ m Fi[2]}


void  S4658C32_nt ::mf4658c32(){}

//skip512 S4658C32_nt

#else // __cplusplus

Class_Descriptor cd_S4658C32_nt = {  "S4658C32_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C31_nt  {
  ::S4658C32_nt s4658c31f0;
  ::S4658C32_nt s4658c31f1;
  void  mf4658c31(); // _ZN11S4658C31_nt9mf4658c31Ev
};
//SIG(-1 S4658C31_nt) C1{ m FC2{ m Fi[2]} FC2}


void  S4658C31_nt ::mf4658c31(){}

//skip512 S4658C31_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C30  {
  ::S4658C31_nt s4658c30f0;
  ::S4658C31_nt s4658c30f1;
  char s4658c30f2;
  void  mf4658c30(); // _ZN8S4658C309mf4658c30Ev
};
//SIG(-1 S4658C30) C1{ m FC2{ m FC3{ m Fi[2]} FC3} FC2 Fc}


void  S4658C30 ::mf4658c30(){}

static void Test_S4658C30()
{
  {
    init_simple_test("S4658C30");
    S4658C30 lv;
    check2(sizeof(lv), 36, "sizeof(S4658C30)");
    check2(__alignof__(lv), 4, "__alignof__(S4658C30)");
    check_field_offset(lv, s4658c30f0, 0, "S4658C30.s4658c30f0");
    check_field_offset(lv, s4658c30f1, 16, "S4658C30.s4658c30f1");
    check_field_offset(lv, s4658c30f2, 32, "S4658C30.s4658c30f2");
  }
}
static Arrange_To_Call_Me vS4658C30(Test_S4658C30, "S4658C30", 36);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C62  {
  int s4658c62f0[2];
  ::S15308C2_nt s4658c62f1;
  int s4658c62f2;
  int s4658c62f3;
  void  mf4658c62(); // _ZN8S4658C629mf4658c62Ev
};
//SIG(-1 S4658C62) C1{ m Fi[2] FC2{ BC3{ BC4{ BC5{}} FC6{ BC7{}}} FU8{ Fc[16] Fp} Fi Fi} Fi Fi}


void  S4658C62 ::mf4658c62(){}

static void Test_S4658C62()
{
  {
    init_simple_test("S4658C62");
    S4658C62 lv;
    check2(sizeof(lv), ABISELECT(48,44), "sizeof(S4658C62)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4658C62)");
    check_field_offset(lv, s4658c62f0, 0, "S4658C62.s4658c62f0");
    check_field_offset(lv, s4658c62f1, 8, "S4658C62.s4658c62f1");
    check_field_offset(lv, s4658c62f2, ABISELECT(40,36), "S4658C62.s4658c62f2");
    check_field_offset(lv, s4658c62f3, ABISELECT(44,40), "S4658C62.s4658c62f3");
  }
}
static Arrange_To_Call_Me vS4658C62(Test_S4658C62, "S4658C62", ABISELECT(48,44));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C93  {
  char s4658c93f0;
  char s4658c93f1;
  char s4658c93f2;
  char s4658c93f3;
  void  mf4658c93(); // _ZN8S4658C939mf4658c93Ev
};
//SIG(-1 S4658C93) C1{ m Fc[4]}


void  S4658C93 ::mf4658c93(){}

static void Test_S4658C93()
{
  {
    init_simple_test("S4658C93");
    S4658C93 lv;
    check2(sizeof(lv), 4, "sizeof(S4658C93)");
    check2(__alignof__(lv), 1, "__alignof__(S4658C93)");
    check_field_offset(lv, s4658c93f0, 0, "S4658C93.s4658c93f0");
    check_field_offset(lv, s4658c93f1, 1, "S4658C93.s4658c93f1");
    check_field_offset(lv, s4658c93f2, 2, "S4658C93.s4658c93f2");
    check_field_offset(lv, s4658c93f3, 3, "S4658C93.s4658c93f3");
  }
}
static Arrange_To_Call_Me vS4658C93(Test_S4658C93, "S4658C93", 4);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C2  : S4658C3 {
  void *s4658c2f0;
  ::S4658C4 s4658c2f1;
  int s4658c2f2[5];
  char s4658c2f3;
  ::S4658C4 s4658c2f4;
  ::S4658C21_nt s4658c2f5;
  ::S4658C22 s4658c2f6;
  ::S4658C30 s4658c2f7;
  ::S15308C202 s4658c2f8;
  ::S15308C174 s4658c2f9;
  char s4658c2f10[2];
  ::S4658C32_nt s4658c2f11;
  ::S4658C62 s4658c2f12;
  ::S15308C146 s4658c2f13;
  ::S15308C122 s4658c2f14;
  ::S4658C62 s4658c2f15;
  char s4658c2f16;
  ::S4658C93 s4658c2f17;
  virtual  ~S4658C2(); // _ZN7S4658C2D1Ev
  virtual void  v68(); // _ZN7S4658C23v68Ev
  virtual void  v69(); // _ZN7S4658C23v69Ev
  virtual void  v70(); // _ZN7S4658C23v70Ev
  virtual void  v71(); // _ZN7S4658C23v71Ev
  virtual void  v72(); // _ZN7S4658C23v72Ev
  virtual void  v73(); // _ZN7S4658C23v73Ev
  virtual void  v74(); // _ZN7S4658C23v74Ev
  virtual void  v75(); // _ZN7S4658C23v75Ev
  virtual void  v76(); // _ZN7S4658C23v76Ev
  virtual void  v77(); // _ZN7S4658C23v77Ev
  virtual void  v78(); // _ZN7S4658C23v78Ev
  virtual void  v79(); // _ZN7S4658C23v79Ev
  virtual void  v80(); // _ZN7S4658C23v80Ev
  virtual void  v81(); // _ZN7S4658C23v81Ev
  virtual void  v82(); // _ZN7S4658C23v82Ev
  virtual void  v83(); // _ZN7S4658C23v83Ev
  virtual void  v84(); // _ZN7S4658C23v84Ev
  virtual void  v85(); // _ZN7S4658C23v85Ev
  virtual void  v86(); // _ZN7S4658C23v86Ev
  virtual void  v87(); // _ZN7S4658C23v87Ev
  virtual void  v88(); // _ZN7S4658C23v88Ev
  virtual void  v89(); // _ZN7S4658C23v89Ev
  virtual void  v90(); // _ZN7S4658C23v90Ev
  virtual void  v91(); // _ZN7S4658C23v91Ev
  virtual void  v92(); // _ZN7S4658C23v92Ev
  virtual void  v93(); // _ZN7S4658C23v93Ev
  virtual void  v94(); // _ZN7S4658C23v94Ev
  virtual void  v95(); // _ZN7S4658C23v95Ev
  virtual void  v96(); // _ZN7S4658C23v96Ev
  virtual void  v97(); // _ZN7S4658C23v97Ev
  S4658C2(); // tgen
};
//SIG(-1 S4658C2) C1{ BC2{ vd v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC3{ m FC4{ BC5{ BC6{ BC7{} FC8{ BC7}} FC9{ BC10{}}} Fp Fi[3]}} Fi[5] Fc FC3 FC11{ m Fi[3]} FC12{ m FC4} FC13{ m FC14{ m FC15{ m Fi[2]} FC15} FC14 Fc} FC16{ BC17{ BC18{ BC19{ BC20{ BC21{ BC22{} FC23{ BC24{}}} FC25{ BC26{}}} FC25} FC27{ BC28{}}} Fp Fi}} FC29{ BC30{ BC31{ BC32{ BC33{ BC34{ BC22 FC23} FC35{ BC36{}}} FC37{ BC38{}}} FC37} Fp Fi}} Fc[2] FC15 FC39{ m Fi[2] FC40{ BC41{ BC42{ BC22} FC43{ BC44{}}} FU45{ Fc[16] Fp} Fi Fi} Fi Fi} FC46{ BC47{ BC48{ BC49{ BC50{ BC51{ BC22 FC23} FC52{ BC53{}}} FC52} FC35} Fp Fi}} FC54{ BC55{ BC56{ BC57{ BC58{ BC59{ BC22 FC23} FC60{ BC61{}}} FC62{ BC63{}}} FC62} Fp Fi}} FC39 Fc FC64{ m Fc Fc Fc Fc}}


 S4658C2 ::~S4658C2(){ note_dtor("S4658C2", this);}
void  S4658C2 ::v68(){vfunc_called(this, "_ZN7S4658C23v68Ev");}
void  S4658C2 ::v69(){vfunc_called(this, "_ZN7S4658C23v69Ev");}
void  S4658C2 ::v70(){vfunc_called(this, "_ZN7S4658C23v70Ev");}
void  S4658C2 ::v71(){vfunc_called(this, "_ZN7S4658C23v71Ev");}
void  S4658C2 ::v72(){vfunc_called(this, "_ZN7S4658C23v72Ev");}
void  S4658C2 ::v73(){vfunc_called(this, "_ZN7S4658C23v73Ev");}
void  S4658C2 ::v74(){vfunc_called(this, "_ZN7S4658C23v74Ev");}
void  S4658C2 ::v75(){vfunc_called(this, "_ZN7S4658C23v75Ev");}
void  S4658C2 ::v76(){vfunc_called(this, "_ZN7S4658C23v76Ev");}
void  S4658C2 ::v77(){vfunc_called(this, "_ZN7S4658C23v77Ev");}
void  S4658C2 ::v78(){vfunc_called(this, "_ZN7S4658C23v78Ev");}
void  S4658C2 ::v79(){vfunc_called(this, "_ZN7S4658C23v79Ev");}
void  S4658C2 ::v80(){vfunc_called(this, "_ZN7S4658C23v80Ev");}
void  S4658C2 ::v81(){vfunc_called(this, "_ZN7S4658C23v81Ev");}
void  S4658C2 ::v82(){vfunc_called(this, "_ZN7S4658C23v82Ev");}
void  S4658C2 ::v83(){vfunc_called(this, "_ZN7S4658C23v83Ev");}
void  S4658C2 ::v84(){vfunc_called(this, "_ZN7S4658C23v84Ev");}
void  S4658C2 ::v85(){vfunc_called(this, "_ZN7S4658C23v85Ev");}
void  S4658C2 ::v86(){vfunc_called(this, "_ZN7S4658C23v86Ev");}
void  S4658C2 ::v87(){vfunc_called(this, "_ZN7S4658C23v87Ev");}
void  S4658C2 ::v88(){vfunc_called(this, "_ZN7S4658C23v88Ev");}
void  S4658C2 ::v89(){vfunc_called(this, "_ZN7S4658C23v89Ev");}
void  S4658C2 ::v90(){vfunc_called(this, "_ZN7S4658C23v90Ev");}
void  S4658C2 ::v91(){vfunc_called(this, "_ZN7S4658C23v91Ev");}
void  S4658C2 ::v92(){vfunc_called(this, "_ZN7S4658C23v92Ev");}
void  S4658C2 ::v93(){vfunc_called(this, "_ZN7S4658C23v93Ev");}
void  S4658C2 ::v94(){vfunc_called(this, "_ZN7S4658C23v94Ev");}
void  S4658C2 ::v95(){vfunc_called(this, "_ZN7S4658C23v95Ev");}
void  S4658C2 ::v96(){vfunc_called(this, "_ZN7S4658C23v96Ev");}
void  S4658C2 ::v97(){vfunc_called(this, "_ZN7S4658C23v97Ev");}
S4658C2 ::S4658C2(){ note_ctor("S4658C2", this);} // tgen

static void Test_S4658C2()
{
  extern Class_Descriptor cd_S4658C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(52,75)];
    init_test(&cd_S4658C2, buf);
    S4658C2 *dp, &lv = *(dp=new (buf) S4658C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(408,296), "sizeof(S4658C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4658C2)");
    check_base_class_offset(lv, (S4658C3*), 0, "S4658C2");
    check_field_offset(lv, s4658c2f0, ABISELECT(8,4), "S4658C2.s4658c2f0");
    check_field_offset(lv, s4658c2f1, ABISELECT(16,8), "S4658C2.s4658c2f1");
    check_field_offset(lv, s4658c2f2, ABISELECT(48,28), "S4658C2.s4658c2f2");
    check_field_offset(lv, s4658c2f3, ABISELECT(68,48), "S4658C2.s4658c2f3");
    check_field_offset(lv, s4658c2f4, ABISELECT(72,52), "S4658C2.s4658c2f4");
    check_field_offset(lv, s4658c2f5, ABISELECT(104,72), "S4658C2.s4658c2f5");
    check_field_offset(lv, s4658c2f6, ABISELECT(120,84), "S4658C2.s4658c2f6");
    check_field_offset(lv, s4658c2f7, ABISELECT(152,104), "S4658C2.s4658c2f7");
    check_field_offset(lv, s4658c2f8, ABISELECT(192,140), "S4658C2.s4658c2f8");
    check_field_offset(lv, s4658c2f9, ABISELECT(216,152), "S4658C2.s4658c2f9");
    check_field_offset(lv, s4658c2f10, ABISELECT(240,164), "S4658C2.s4658c2f10");
    check_field_offset(lv, s4658c2f11, ABISELECT(244,168), "S4658C2.s4658c2f11");
    check_field_offset(lv, s4658c2f12, ABISELECT(256,176), "S4658C2.s4658c2f12");
    check_field_offset(lv, s4658c2f13, ABISELECT(304,220), "S4658C2.s4658c2f13");
    check_field_offset(lv, s4658c2f14, ABISELECT(328,232), "S4658C2.s4658c2f14");
    check_field_offset(lv, s4658c2f15, ABISELECT(352,244), "S4658C2.s4658c2f15");
    check_field_offset(lv, s4658c2f16, ABISELECT(400,288), "S4658C2.s4658c2f16");
    check_field_offset(lv, s4658c2f17, ABISELECT(401,289), "S4658C2.s4658c2f17");
    test_class_info(&lv, &cd_S4658C2);
    dp->~S4658C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4658C2(Test_S4658C2, "S4658C2", ABISELECT(408,296));

#else // __cplusplus

extern void _ZN7S4658C2C1Ev();
extern void _ZN7S4658C2D1Ev();
Name_Map name_map_S4658C2[] = {
  NSPAIR(_ZN7S4658C2C1Ev),
  NSPAIR(_ZN7S4658C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4658C3;
extern VTBL_ENTRY _ZTI7S4658C3[];
extern  VTBL_ENTRY _ZTV7S4658C3[];
static Base_Class bases_S4658C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4658C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4658C2[];
extern void _ZN7S4658C2D1Ev();
extern void _ZN7S4658C2D0Ev();
extern void _ZN7S4658C33v21Ev();
extern void _ZN7S4658C33v22Ev();
extern void _ZN7S4658C33v23Ev();
extern void _ZN7S4658C33v24Ev();
extern void _ZN7S4658C33v25Ev();
extern void _ZN7S4658C33v26Ev();
extern void _ZN7S4658C33v27Ev();
extern void _ZN7S4658C33v28Ev();
extern void _ZN7S4658C33v29Ev();
extern void _ZN7S4658C33v30Ev();
extern void _ZN7S4658C33v31Ev();
extern void _ZN7S4658C33v32Ev();
extern void _ZN7S4658C33v33Ev();
extern void _ZN7S4658C33v34Ev();
extern void _ZN7S4658C33v35Ev();
extern void _ZN7S4658C33v36Ev();
extern void _ZN7S4658C33v37Ev();
extern void _ZN7S4658C33v38Ev();
extern void _ZN7S4658C33v39Ev();
extern void _ZN7S4658C33v40Ev();
extern void _ZN7S4658C33v41Ev();
extern void _ZN7S4658C33v42Ev();
extern void _ZN7S4658C33v43Ev();
extern void _ZN7S4658C33v44Ev();
extern void _ZN7S4658C33v45Ev();
extern void _ZN7S4658C33v46Ev();
extern void _ZN7S4658C33v47Ev();
extern void _ZN7S4658C33v48Ev();
extern void _ZN7S4658C33v49Ev();
extern void _ZN7S4658C33v50Ev();
extern void _ZN7S4658C33v51Ev();
extern void _ZN7S4658C33v52Ev();
extern void _ZN7S4658C33v53Ev();
extern void _ZN7S4658C33v54Ev();
extern void _ZN7S4658C33v55Ev();
extern void _ZN7S4658C33v56Ev();
extern void _ZN7S4658C33v57Ev();
extern void _ZN7S4658C33v58Ev();
extern void _ZN7S4658C33v59Ev();
extern void _ZN7S4658C33v60Ev();
extern void _ZN7S4658C33v61Ev();
extern void _ZN7S4658C33v62Ev();
extern void _ZN7S4658C33v63Ev();
extern void _ZN7S4658C33v64Ev();
extern void _ZN7S4658C33v65Ev();
extern void _ZN7S4658C33v66Ev();
extern void _ZN7S4658C33v67Ev();
extern void _ZN7S4658C23v68Ev();
extern void _ZN7S4658C23v69Ev();
extern void _ZN7S4658C23v70Ev();
extern void _ZN7S4658C23v71Ev();
extern void _ZN7S4658C23v72Ev();
extern void _ZN7S4658C23v73Ev();
extern void _ZN7S4658C23v74Ev();
extern void _ZN7S4658C23v75Ev();
extern void _ZN7S4658C23v76Ev();
extern void _ZN7S4658C23v77Ev();
extern void _ZN7S4658C23v78Ev();
extern void _ZN7S4658C23v79Ev();
extern void _ZN7S4658C23v80Ev();
extern void _ZN7S4658C23v81Ev();
extern void _ZN7S4658C23v82Ev();
extern void _ZN7S4658C23v83Ev();
extern void _ZN7S4658C23v84Ev();
extern void _ZN7S4658C23v85Ev();
extern void _ZN7S4658C23v86Ev();
extern void _ZN7S4658C23v87Ev();
extern void _ZN7S4658C23v88Ev();
extern void _ZN7S4658C23v89Ev();
extern void _ZN7S4658C23v90Ev();
extern void _ZN7S4658C23v91Ev();
extern void _ZN7S4658C23v92Ev();
extern void _ZN7S4658C23v93Ev();
extern void _ZN7S4658C23v94Ev();
extern void _ZN7S4658C23v95Ev();
extern void _ZN7S4658C23v96Ev();
extern void _ZN7S4658C23v97Ev();
static  VTBL_ENTRY vtc_S4658C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4658C2[0]),
  (VTBL_ENTRY)&_ZN7S4658C2D1Ev,
  (VTBL_ENTRY)&_ZN7S4658C2D0Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v42Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v43Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v44Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v45Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v46Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v47Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v48Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v49Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v50Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v51Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v52Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v53Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v54Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v55Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v56Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v57Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v58Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v59Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v60Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v61Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v62Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v63Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v64Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v65Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v66Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v67Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v68Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v69Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v70Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v71Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v72Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v73Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v74Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v75Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v76Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v77Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v78Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v79Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v80Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v81Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v82Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v83Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v84Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v85Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v86Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v87Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v88Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v89Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v90Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v91Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v92Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v93Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v94Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v95Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v96Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v97Ev,
};
extern VTBL_ENTRY _ZTI7S4658C2[];
extern  VTBL_ENTRY _ZTV7S4658C2[];
Class_Descriptor cd_S4658C2 = {  "S4658C2", // class name
  bases_S4658C2, 1,
  &(vtc_S4658C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(408,296), // object size
  NSPAIRA(_ZTI7S4658C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4658C2),81, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C94  {
  int s4658c94f0;
  int s4658c94f1;
  int s4658c94f2;
  int s4658c94f3;
  int s4658c94f4;
  char s4658c94f5;
  void  mf4658c94(); // _ZN8S4658C949mf4658c94Ev
};
//SIG(-1 S4658C94) C1{ m Fi[5] Fc}


void  S4658C94 ::mf4658c94(){}

static void Test_S4658C94()
{
  {
    init_simple_test("S4658C94");
    S4658C94 lv;
    check2(sizeof(lv), 24, "sizeof(S4658C94)");
    check2(__alignof__(lv), 4, "__alignof__(S4658C94)");
    check_field_offset(lv, s4658c94f0, 0, "S4658C94.s4658c94f0");
    check_field_offset(lv, s4658c94f1, 4, "S4658C94.s4658c94f1");
    check_field_offset(lv, s4658c94f2, 8, "S4658C94.s4658c94f2");
    check_field_offset(lv, s4658c94f3, 12, "S4658C94.s4658c94f3");
    check_field_offset(lv, s4658c94f4, 16, "S4658C94.s4658c94f4");
    check_field_offset(lv, s4658c94f5, 20, "S4658C94.s4658c94f5");
  }
}
static Arrange_To_Call_Me vS4658C94(Test_S4658C94, "S4658C94", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4658C1  : S4658C2 {
  void *s4658c1f0;
  void *s4658c1f1;
  ::S4658C94 s4658c1f2;
  ::S15308C236 s4658c1f3;
  void *s4658c1f4;
  void *s4658c1f5;
  void *s4658c1f6;
  char s4658c1f7;
  int s4658c1f8;
  ::S15308C225 s4658c1f9;
  virtual  ~S4658C1(); // _ZN7S4658C1D1Ev
  virtual void  v1(); // _ZN7S4658C12v1Ev
  virtual void  v2(); // _ZN7S4658C12v2Ev
  virtual void  v3(); // _ZN7S4658C12v3Ev
  virtual void  v4(); // _ZN7S4658C12v4Ev
  virtual void  v5(); // _ZN7S4658C12v5Ev
  virtual void  v6(); // _ZN7S4658C12v6Ev
  virtual void  v7(); // _ZN7S4658C12v7Ev
  virtual void  v8(); // _ZN7S4658C12v8Ev
  virtual void  v9(); // _ZN7S4658C12v9Ev
  virtual void  v10(); // _ZN7S4658C13v10Ev
  virtual void  v11(); // _ZN7S4658C13v11Ev
  virtual void  v12(); // _ZN7S4658C13v12Ev
  virtual void  v13(); // _ZN7S4658C13v13Ev
  virtual void  v14(); // _ZN7S4658C13v14Ev
  virtual void  v15(); // _ZN7S4658C13v15Ev
  virtual void  v16(); // _ZN7S4658C13v16Ev
  virtual void  v17(); // _ZN7S4658C13v17Ev
  virtual void  v18(); // _ZN7S4658C13v18Ev
  virtual void  v19(); // _ZN7S4658C13v19Ev
  virtual void  v20(); // _ZN7S4658C13v20Ev
  S4658C1(); // tgen
};
//SIG(1 S4658C1) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fp FC4{ m FC5{ BC6{ BC7{ BC8{} FC9{ BC8}} FC10{ BC11{}}} Fp Fi[3]}} Fi[5] Fc FC4 FC12{ m Fi[3]} FC13{ m FC5} FC14{ m FC15{ m FC16{ m Fi[2]} FC16} FC15 Fc} FC17{ BC18{ BC19{ BC20{ BC21{ BC22{ BC23{} FC24{ BC25{}}} FC26{ BC27{}}} FC26} FC28{ BC29{}}} Fp Fi}} FC30{ BC31{ BC32{ BC33{ BC34{ BC35{ BC23 FC24} FC36{ BC37{}}} FC38{ BC39{}}} FC38} Fp Fi}} Fc[2] FC16 FC40{ m Fi[2] FC41{ BC42{ BC43{ BC23} FC44{ BC45{}}} FU46{ Fc[16] Fp} Fi Fi} Fi Fi} FC47{ BC48{ BC49{ BC50{ BC51{ BC52{ BC23 FC24} FC53{ BC54{}}} FC53} FC36} Fp Fi}} FC55{ BC56{ BC57{ BC58{ BC59{ BC60{ BC23 FC24} FC61{ BC62{}}} FC63{ BC64{}}} FC63} Fp Fi}} FC40 Fc FC65{ m Fc Fc Fc Fc}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fp Fp FC66{ m Fi Fi Fi Fi Fi Fc} FC67{ BC68{ BC23 FC9} Fp Fp Fp} Fp Fp Fp Fc Fi FC69{ BC70{ BC23 FC9} Fp Fp Fp}}


 S4658C1 ::~S4658C1(){ note_dtor("S4658C1", this);}
void  S4658C1 ::v1(){vfunc_called(this, "_ZN7S4658C12v1Ev");}
void  S4658C1 ::v2(){vfunc_called(this, "_ZN7S4658C12v2Ev");}
void  S4658C1 ::v3(){vfunc_called(this, "_ZN7S4658C12v3Ev");}
void  S4658C1 ::v4(){vfunc_called(this, "_ZN7S4658C12v4Ev");}
void  S4658C1 ::v5(){vfunc_called(this, "_ZN7S4658C12v5Ev");}
void  S4658C1 ::v6(){vfunc_called(this, "_ZN7S4658C12v6Ev");}
void  S4658C1 ::v7(){vfunc_called(this, "_ZN7S4658C12v7Ev");}
void  S4658C1 ::v8(){vfunc_called(this, "_ZN7S4658C12v8Ev");}
void  S4658C1 ::v9(){vfunc_called(this, "_ZN7S4658C12v9Ev");}
void  S4658C1 ::v10(){vfunc_called(this, "_ZN7S4658C13v10Ev");}
void  S4658C1 ::v11(){vfunc_called(this, "_ZN7S4658C13v11Ev");}
void  S4658C1 ::v12(){vfunc_called(this, "_ZN7S4658C13v12Ev");}
void  S4658C1 ::v13(){vfunc_called(this, "_ZN7S4658C13v13Ev");}
void  S4658C1 ::v14(){vfunc_called(this, "_ZN7S4658C13v14Ev");}
void  S4658C1 ::v15(){vfunc_called(this, "_ZN7S4658C13v15Ev");}
void  S4658C1 ::v16(){vfunc_called(this, "_ZN7S4658C13v16Ev");}
void  S4658C1 ::v17(){vfunc_called(this, "_ZN7S4658C13v17Ev");}
void  S4658C1 ::v18(){vfunc_called(this, "_ZN7S4658C13v18Ev");}
void  S4658C1 ::v19(){vfunc_called(this, "_ZN7S4658C13v19Ev");}
void  S4658C1 ::v20(){vfunc_called(this, "_ZN7S4658C13v20Ev");}
S4658C1 ::S4658C1(){ note_ctor("S4658C1", this);} // tgen

static void Test_S4658C1()
{
  extern Class_Descriptor cd_S4658C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(69,96)];
    init_test(&cd_S4658C1, buf);
    S4658C1 *dp, &lv = *(dp=new (buf) S4658C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(544,380), "sizeof(S4658C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4658C1)");
    check_base_class_offset(lv, (S4658C3*)(S4658C2*), 0, "S4658C1");
    check_base_class_offset(lv, (S4658C2*), 0, "S4658C1");
    check_field_offset(lv, s4658c1f0, ABISELECT(408,296), "S4658C1.s4658c1f0");
    check_field_offset(lv, s4658c1f1, ABISELECT(416,300), "S4658C1.s4658c1f1");
    check_field_offset(lv, s4658c1f2, ABISELECT(424,304), "S4658C1.s4658c1f2");
    check_field_offset(lv, s4658c1f3, ABISELECT(448,328), "S4658C1.s4658c1f3");
    check_field_offset(lv, s4658c1f4, ABISELECT(480,344), "S4658C1.s4658c1f4");
    check_field_offset(lv, s4658c1f5, ABISELECT(488,348), "S4658C1.s4658c1f5");
    check_field_offset(lv, s4658c1f6, ABISELECT(496,352), "S4658C1.s4658c1f6");
    check_field_offset(lv, s4658c1f7, ABISELECT(504,356), "S4658C1.s4658c1f7");
    check_field_offset(lv, s4658c1f8, ABISELECT(508,360), "S4658C1.s4658c1f8");
    check_field_offset(lv, s4658c1f9, ABISELECT(512,364), "S4658C1.s4658c1f9");
    test_class_info(&lv, &cd_S4658C1);
    dp->~S4658C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4658C1(Test_S4658C1, "S4658C1", ABISELECT(544,380));

#else // __cplusplus

extern void _ZN7S4658C1C1Ev();
extern void _ZN7S4658C1D1Ev();
Name_Map name_map_S4658C1[] = {
  NSPAIR(_ZN7S4658C1C1Ev),
  NSPAIR(_ZN7S4658C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4658C3;
extern VTBL_ENTRY _ZTI7S4658C3[];
extern  VTBL_ENTRY _ZTV7S4658C3[];
extern Class_Descriptor cd_S4658C2;
extern VTBL_ENTRY _ZTI7S4658C2[];
extern  VTBL_ENTRY _ZTV7S4658C2[];
static Base_Class bases_S4658C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4658C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4658C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4658C1[];
extern void _ZN7S4658C1D1Ev();
extern void _ZN7S4658C1D0Ev();
extern void _ZN7S4658C33v21Ev();
extern void _ZN7S4658C33v22Ev();
extern void _ZN7S4658C33v23Ev();
extern void _ZN7S4658C33v24Ev();
extern void _ZN7S4658C33v25Ev();
extern void _ZN7S4658C33v26Ev();
extern void _ZN7S4658C33v27Ev();
extern void _ZN7S4658C33v28Ev();
extern void _ZN7S4658C33v29Ev();
extern void _ZN7S4658C33v30Ev();
extern void _ZN7S4658C33v31Ev();
extern void _ZN7S4658C33v32Ev();
extern void _ZN7S4658C33v33Ev();
extern void _ZN7S4658C33v34Ev();
extern void _ZN7S4658C33v35Ev();
extern void _ZN7S4658C33v36Ev();
extern void _ZN7S4658C33v37Ev();
extern void _ZN7S4658C33v38Ev();
extern void _ZN7S4658C33v39Ev();
extern void _ZN7S4658C33v40Ev();
extern void _ZN7S4658C33v41Ev();
extern void _ZN7S4658C33v42Ev();
extern void _ZN7S4658C33v43Ev();
extern void _ZN7S4658C33v44Ev();
extern void _ZN7S4658C33v45Ev();
extern void _ZN7S4658C33v46Ev();
extern void _ZN7S4658C33v47Ev();
extern void _ZN7S4658C33v48Ev();
extern void _ZN7S4658C33v49Ev();
extern void _ZN7S4658C33v50Ev();
extern void _ZN7S4658C33v51Ev();
extern void _ZN7S4658C33v52Ev();
extern void _ZN7S4658C33v53Ev();
extern void _ZN7S4658C33v54Ev();
extern void _ZN7S4658C33v55Ev();
extern void _ZN7S4658C33v56Ev();
extern void _ZN7S4658C33v57Ev();
extern void _ZN7S4658C33v58Ev();
extern void _ZN7S4658C33v59Ev();
extern void _ZN7S4658C33v60Ev();
extern void _ZN7S4658C33v61Ev();
extern void _ZN7S4658C33v62Ev();
extern void _ZN7S4658C33v63Ev();
extern void _ZN7S4658C33v64Ev();
extern void _ZN7S4658C33v65Ev();
extern void _ZN7S4658C33v66Ev();
extern void _ZN7S4658C33v67Ev();
extern void _ZN7S4658C23v68Ev();
extern void _ZN7S4658C23v69Ev();
extern void _ZN7S4658C23v70Ev();
extern void _ZN7S4658C23v71Ev();
extern void _ZN7S4658C23v72Ev();
extern void _ZN7S4658C23v73Ev();
extern void _ZN7S4658C23v74Ev();
extern void _ZN7S4658C23v75Ev();
extern void _ZN7S4658C23v76Ev();
extern void _ZN7S4658C23v77Ev();
extern void _ZN7S4658C23v78Ev();
extern void _ZN7S4658C23v79Ev();
extern void _ZN7S4658C23v80Ev();
extern void _ZN7S4658C23v81Ev();
extern void _ZN7S4658C23v82Ev();
extern void _ZN7S4658C23v83Ev();
extern void _ZN7S4658C23v84Ev();
extern void _ZN7S4658C23v85Ev();
extern void _ZN7S4658C23v86Ev();
extern void _ZN7S4658C23v87Ev();
extern void _ZN7S4658C23v88Ev();
extern void _ZN7S4658C23v89Ev();
extern void _ZN7S4658C23v90Ev();
extern void _ZN7S4658C23v91Ev();
extern void _ZN7S4658C23v92Ev();
extern void _ZN7S4658C23v93Ev();
extern void _ZN7S4658C23v94Ev();
extern void _ZN7S4658C23v95Ev();
extern void _ZN7S4658C23v96Ev();
extern void _ZN7S4658C23v97Ev();
extern void _ZN7S4658C12v1Ev();
extern void _ZN7S4658C12v2Ev();
extern void _ZN7S4658C12v3Ev();
extern void _ZN7S4658C12v4Ev();
extern void _ZN7S4658C12v5Ev();
extern void _ZN7S4658C12v6Ev();
extern void _ZN7S4658C12v7Ev();
extern void _ZN7S4658C12v8Ev();
extern void _ZN7S4658C12v9Ev();
extern void _ZN7S4658C13v10Ev();
extern void _ZN7S4658C13v11Ev();
extern void _ZN7S4658C13v12Ev();
extern void _ZN7S4658C13v13Ev();
extern void _ZN7S4658C13v14Ev();
extern void _ZN7S4658C13v15Ev();
extern void _ZN7S4658C13v16Ev();
extern void _ZN7S4658C13v17Ev();
extern void _ZN7S4658C13v18Ev();
extern void _ZN7S4658C13v19Ev();
extern void _ZN7S4658C13v20Ev();
static  VTBL_ENTRY vtc_S4658C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4658C1[0]),
  (VTBL_ENTRY)&_ZN7S4658C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4658C1D0Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v33Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v34Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v35Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v36Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v37Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v38Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v39Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v40Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v41Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v42Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v43Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v44Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v45Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v46Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v47Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v48Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v49Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v50Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v51Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v52Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v53Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v54Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v55Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v56Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v57Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v58Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v59Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v60Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v61Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v62Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v63Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v64Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v65Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v66Ev,
  (VTBL_ENTRY)&_ZN7S4658C33v67Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v68Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v69Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v70Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v71Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v72Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v73Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v74Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v75Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v76Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v77Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v78Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v79Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v80Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v81Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v82Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v83Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v84Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v85Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v86Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v87Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v88Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v89Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v90Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v91Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v92Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v93Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v94Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v95Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v96Ev,
  (VTBL_ENTRY)&_ZN7S4658C23v97Ev,
  (VTBL_ENTRY)&_ZN7S4658C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4658C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4658C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4658C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4658C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4658C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4658C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4658C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4658C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v12Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v13Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v14Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v15Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v16Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v17Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v18Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v19Ev,
  (VTBL_ENTRY)&_ZN7S4658C13v20Ev,
};
extern VTBL_ENTRY _ZTI7S4658C1[];
extern  VTBL_ENTRY _ZTV7S4658C1[];
Class_Descriptor cd_S4658C1 = {  "S4658C1", // class name
  bases_S4658C1, 2,
  &(vtc_S4658C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(544,380), // object size
  NSPAIRA(_ZTI7S4658C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4658C1),101, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C2  {
  virtual  ~S9509C2(); // _ZN7S9509C2D1Ev
  virtual void  v3(); // _ZN7S9509C22v3Ev
  virtual void  v4(); // _ZN7S9509C22v4Ev
  virtual void  v5(); // _ZN7S9509C22v5Ev
  virtual void  v6(); // _ZN7S9509C22v6Ev
  virtual void  v7(); // _ZN7S9509C22v7Ev
  S9509C2(); // tgen
};
//SIG(-1 S9509C2) C1{ vd v1 v2 v3 v4 v5}


 S9509C2 ::~S9509C2(){ note_dtor("S9509C2", this);}
void  S9509C2 ::v3(){vfunc_called(this, "_ZN7S9509C22v3Ev");}
void  S9509C2 ::v4(){vfunc_called(this, "_ZN7S9509C22v4Ev");}
void  S9509C2 ::v5(){vfunc_called(this, "_ZN7S9509C22v5Ev");}
void  S9509C2 ::v6(){vfunc_called(this, "_ZN7S9509C22v6Ev");}
void  S9509C2 ::v7(){vfunc_called(this, "_ZN7S9509C22v7Ev");}
S9509C2 ::S9509C2(){ note_ctor("S9509C2", this);} // tgen

static void Test_S9509C2()
{
  extern Class_Descriptor cd_S9509C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9509C2, buf);
    S9509C2 *dp, &lv = *(dp=new (buf) S9509C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9509C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9509C2)");
    test_class_info(&lv, &cd_S9509C2);
    dp->~S9509C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9509C2(Test_S9509C2, "S9509C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9509C2C1Ev();
extern void _ZN7S9509C2D1Ev();
Name_Map name_map_S9509C2[] = {
  NSPAIR(_ZN7S9509C2C1Ev),
  NSPAIR(_ZN7S9509C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9509C2[];
extern void _ZN7S9509C2D1Ev();
extern void _ZN7S9509C2D0Ev();
extern void _ZN7S9509C22v3Ev();
extern void _ZN7S9509C22v4Ev();
extern void _ZN7S9509C22v5Ev();
extern void _ZN7S9509C22v6Ev();
extern void _ZN7S9509C22v7Ev();
static  VTBL_ENTRY vtc_S9509C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9509C2[0]),
  (VTBL_ENTRY)&_ZN7S9509C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9509C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v3Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v4Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v7Ev,
};
extern VTBL_ENTRY _ZTI7S9509C2[];
extern  VTBL_ENTRY _ZTV7S9509C2[];
Class_Descriptor cd_S9509C2 = {  "S9509C2", // class name
  0,0,//no base classes
  &(vtc_S9509C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9509C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9509C2),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C4  {
  int s9509c4f0[7];
  void  mf9509c4(); // _ZN7S9509C48mf9509c4Ev
};
//SIG(-1 S9509C4) C1{ m Fi[7]}


void  S9509C4 ::mf9509c4(){}

static void Test_S9509C4()
{
  {
    init_simple_test("S9509C4");
    S9509C4 lv;
    check2(sizeof(lv), 28, "sizeof(S9509C4)");
    check2(__alignof__(lv), 4, "__alignof__(S9509C4)");
    check_field_offset(lv, s9509c4f0, 0, "S9509C4.s9509c4f0");
  }
}
static Arrange_To_Call_Me vS9509C4(Test_S9509C4, "S9509C4", 28);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C5  {
  int s9509c5f0[4];
  ::S15308C172 s9509c5f1;
  int s9509c5f2;
  void  mf9509c5(); // _ZN7S9509C58mf9509c5Ev
};
//SIG(-1 S9509C5) C1{ m Fi[4] FC2{ BC3{ m Fc[16]}} Fi}


void  S9509C5 ::mf9509c5(){}

static void Test_S9509C5()
{
  {
    init_simple_test("S9509C5");
    S9509C5 lv;
    check2(sizeof(lv), 36, "sizeof(S9509C5)");
    check2(__alignof__(lv), 4, "__alignof__(S9509C5)");
    check_field_offset(lv, s9509c5f0, 0, "S9509C5.s9509c5f0");
    check_field_offset(lv, s9509c5f1, 16, "S9509C5.s9509c5f1");
    check_field_offset(lv, s9509c5f2, 32, "S9509C5.s9509c5f2");
  }
}
static Arrange_To_Call_Me vS9509C5(Test_S9509C5, "S9509C5", 36);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C8  {
  int s9509c8f0[7];
  char s9509c8f1[3];
  int s9509c8f2;
  void  mf9509c8(); // _ZN7S9509C88mf9509c8Ev
};
//SIG(-1 S9509C8) C1{ m Fi[7] Fc[3] Fi}


void  S9509C8 ::mf9509c8(){}

static void Test_S9509C8()
{
  {
    init_simple_test("S9509C8");
    S9509C8 lv;
    check2(sizeof(lv), 36, "sizeof(S9509C8)");
    check2(__alignof__(lv), 4, "__alignof__(S9509C8)");
    check_field_offset(lv, s9509c8f0, 0, "S9509C8.s9509c8f0");
    check_field_offset(lv, s9509c8f1, 28, "S9509C8.s9509c8f1");
    check_field_offset(lv, s9509c8f2, 32, "S9509C8.s9509c8f2");
  }
}
static Arrange_To_Call_Me vS9509C8(Test_S9509C8, "S9509C8", 36);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C10_nt  {
  ::S15308C173_nt s9509c10f0;
  ::S15308C173_nt s9509c10f1;
  ::S15308C173_nt s9509c10f2;
  ::S15308C173_nt s9509c10f3;
  void  mf9509c10(); // _ZN11S9509C10_nt9mf9509c10Ev
};
//SIG(-1 S9509C10_nt) C1{ m FC2{ m Fc[16]} FC2 FC2 FC2}


void  S9509C10_nt ::mf9509c10(){}

//skip512 S9509C10_nt

#else // __cplusplus

Class_Descriptor cd_S9509C10_nt = {  "S9509C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  64, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C9_nt  : S9509C10_nt {
};
//SIG(-1 S9509C9_nt) C1{ BC2{ m FC3{ m Fc[16]} FC3 FC3 FC3}}



//skip512 S9509C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S9509C10_nt;
static Base_Class bases_S9509C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9509C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C11  {
  int s9509c11f0[5];
  char s9509c11f1;
  void  mf9509c11(); // _ZN8S9509C119mf9509c11Ev
};
//SIG(-1 S9509C11) C1{ m Fi[5] Fc}


void  S9509C11 ::mf9509c11(){}

static void Test_S9509C11()
{
  {
    init_simple_test("S9509C11");
    S9509C11 lv;
    check2(sizeof(lv), 24, "sizeof(S9509C11)");
    check2(__alignof__(lv), 4, "__alignof__(S9509C11)");
    check_field_offset(lv, s9509c11f0, 0, "S9509C11.s9509c11f0");
    check_field_offset(lv, s9509c11f1, 20, "S9509C11.s9509c11f1");
  }
}
static Arrange_To_Call_Me vS9509C11(Test_S9509C11, "S9509C11", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C3  {
  ::S9509C4 s9509c3f0;
  int s9509c3f1[3];
  char s9509c3f2;
  int s9509c3f3[2];
  ::S9509C5 s9509c3f4;
  int s9509c3f5[4];
  ::S9509C8 s9509c3f6;
  ::S9509C9_nt s9509c3f7;
  ::S15308C172 s9509c3f8;
  ::S15308C172 s9509c3f9;
  ::S15308C172 s9509c3f10;
  ::S15308C172 s9509c3f11;
  ::S15308C172 s9509c3f12;
  ::S15308C172 s9509c3f13;
  int s9509c3f14[23];
  void *s9509c3f15[2];
  char s9509c3f16[2];
  int s9509c3f17;
  char s9509c3f18;
  int s9509c3f19[2];
  char s9509c3f20;
  int s9509c3f21[2];
  ::S15308C172 s9509c3f22;
  ::S15308C172 s9509c3f23;
  char s9509c3f24[3];
  ::S15308C172 s9509c3f25;
  int s9509c3f26;
  char s9509c3f27[2];
  int s9509c3f28[3];
  char s9509c3f29;
  int s9509c3f30[2];
  char s9509c3f31;
  int s9509c3f32[4];
  ::S15308C172 s9509c3f33;
  ::S15308C172 s9509c3f34;
  ::S15308C172 s9509c3f35;
  ::S15308C172 s9509c3f36;
  ::S15308C172 s9509c3f37;
  ::S15308C172 s9509c3f38;
  ::S15308C172 s9509c3f39;
  ::S15308C172 s9509c3f40;
  ::S15308C172 s9509c3f41;
  ::S15308C172 s9509c3f42;
  ::S15308C172 s9509c3f43;
  ::S15308C172 s9509c3f44;
  char s9509c3f45[8];
  int s9509c3f46;
  char s9509c3f47;
  int s9509c3f48;
  char s9509c3f49;
  void *s9509c3f50[3];
  char s9509c3f51;
  int s9509c3f52[2];
  char s9509c3f53;
  ::S15308C172 s9509c3f54;
  ::S15308C172 s9509c3f55;
  ::S15308C172 s9509c3f56;
  int s9509c3f57[12];
  ::S15308C172 s9509c3f58;
  int s9509c3f59[3];
  char s9509c3f60[2];
  ::S9509C9_nt s9509c3f61;
  int s9509c3f62[6];
  char s9509c3f63;
  int s9509c3f64;
  char s9509c3f65;
  ::S9509C11 s9509c3f66;
  int s9509c3f67;
  ::S15308C172 s9509c3f68;
  int s9509c3f69[6];
  ::S15308C172 s9509c3f70[4];
  ::S15308C172 s9509c3f71[4];
  void  mf9509c3(); // _ZN7S9509C38mf9509c3Ev
};
//SIG(1 S9509C3) C1{ m FC2{ m Fi[7]} Fi[3] Fc Fi[2] FC3{ m Fi[4] FC4{ BC5{ m Fc[16]}} Fi} Fi[4] FC6{ m Fi[7] Fc[3] Fi} FC7{ BC8{ m FC5 FC5 FC5 FC5}} FC4 FC4 FC4 FC4 FC4 FC4 Fi[23] Fp[2] Fc[2] Fi Fc Fi[2] Fc Fi[2] FC4 FC4 Fc[3] FC4 Fi Fc[2] Fi[3] Fc Fi[2] Fc Fi[4] FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 Fc[8] Fi Fc Fi Fc Fp[3] Fc Fi[2] Fc FC4 FC4 FC4 Fi[12] FC4 Fi[3] Fc[2] FC7 Fi[6] Fc Fi Fc FC9{ m Fi[5] Fc} Fi FC4 Fi[6] FC4[4] FC4[4]}


void  S9509C3 ::mf9509c3(){}

static void Test_S9509C3()
{
  {
    init_simple_test("S9509C3");
    S9509C3 lv;
    check2(sizeof(lv), ABISELECT(1224,1204), "sizeof(S9509C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9509C3)");
    check_field_offset(lv, s9509c3f0, 0, "S9509C3.s9509c3f0");
    check_field_offset(lv, s9509c3f1, 28, "S9509C3.s9509c3f1");
    check_field_offset(lv, s9509c3f2, 40, "S9509C3.s9509c3f2");
    check_field_offset(lv, s9509c3f3, 44, "S9509C3.s9509c3f3");
    check_field_offset(lv, s9509c3f4, 52, "S9509C3.s9509c3f4");
    check_field_offset(lv, s9509c3f5, 88, "S9509C3.s9509c3f5");
    check_field_offset(lv, s9509c3f6, 104, "S9509C3.s9509c3f6");
    check_field_offset(lv, s9509c3f7, 140, "S9509C3.s9509c3f7");
    check_field_offset(lv, s9509c3f8, 204, "S9509C3.s9509c3f8");
    check_field_offset(lv, s9509c3f9, 220, "S9509C3.s9509c3f9");
    check_field_offset(lv, s9509c3f10, 236, "S9509C3.s9509c3f10");
    check_field_offset(lv, s9509c3f11, 252, "S9509C3.s9509c3f11");
    check_field_offset(lv, s9509c3f12, 268, "S9509C3.s9509c3f12");
    check_field_offset(lv, s9509c3f13, 284, "S9509C3.s9509c3f13");
    check_field_offset(lv, s9509c3f14, 300, "S9509C3.s9509c3f14");
    check_field_offset(lv, s9509c3f15, 392, "S9509C3.s9509c3f15");
    check_field_offset(lv, s9509c3f16, ABISELECT(408,400), "S9509C3.s9509c3f16");
    check_field_offset(lv, s9509c3f17, ABISELECT(412,404), "S9509C3.s9509c3f17");
    check_field_offset(lv, s9509c3f18, ABISELECT(416,408), "S9509C3.s9509c3f18");
    check_field_offset(lv, s9509c3f19, ABISELECT(420,412), "S9509C3.s9509c3f19");
    check_field_offset(lv, s9509c3f20, ABISELECT(428,420), "S9509C3.s9509c3f20");
    check_field_offset(lv, s9509c3f21, ABISELECT(432,424), "S9509C3.s9509c3f21");
    check_field_offset(lv, s9509c3f22, ABISELECT(440,432), "S9509C3.s9509c3f22");
    check_field_offset(lv, s9509c3f23, ABISELECT(456,448), "S9509C3.s9509c3f23");
    check_field_offset(lv, s9509c3f24, ABISELECT(472,464), "S9509C3.s9509c3f24");
    check_field_offset(lv, s9509c3f25, ABISELECT(475,467), "S9509C3.s9509c3f25");
    check_field_offset(lv, s9509c3f26, ABISELECT(492,484), "S9509C3.s9509c3f26");
    check_field_offset(lv, s9509c3f27, ABISELECT(496,488), "S9509C3.s9509c3f27");
    check_field_offset(lv, s9509c3f28, ABISELECT(500,492), "S9509C3.s9509c3f28");
    check_field_offset(lv, s9509c3f29, ABISELECT(512,504), "S9509C3.s9509c3f29");
    check_field_offset(lv, s9509c3f30, ABISELECT(516,508), "S9509C3.s9509c3f30");
    check_field_offset(lv, s9509c3f31, ABISELECT(524,516), "S9509C3.s9509c3f31");
    check_field_offset(lv, s9509c3f32, ABISELECT(528,520), "S9509C3.s9509c3f32");
    check_field_offset(lv, s9509c3f33, ABISELECT(544,536), "S9509C3.s9509c3f33");
    check_field_offset(lv, s9509c3f34, ABISELECT(560,552), "S9509C3.s9509c3f34");
    check_field_offset(lv, s9509c3f35, ABISELECT(576,568), "S9509C3.s9509c3f35");
    check_field_offset(lv, s9509c3f36, ABISELECT(592,584), "S9509C3.s9509c3f36");
    check_field_offset(lv, s9509c3f37, ABISELECT(608,600), "S9509C3.s9509c3f37");
    check_field_offset(lv, s9509c3f38, ABISELECT(624,616), "S9509C3.s9509c3f38");
    check_field_offset(lv, s9509c3f39, ABISELECT(640,632), "S9509C3.s9509c3f39");
    check_field_offset(lv, s9509c3f40, ABISELECT(656,648), "S9509C3.s9509c3f40");
    check_field_offset(lv, s9509c3f41, ABISELECT(672,664), "S9509C3.s9509c3f41");
    check_field_offset(lv, s9509c3f42, ABISELECT(688,680), "S9509C3.s9509c3f42");
    check_field_offset(lv, s9509c3f43, ABISELECT(704,696), "S9509C3.s9509c3f43");
    check_field_offset(lv, s9509c3f44, ABISELECT(720,712), "S9509C3.s9509c3f44");
    check_field_offset(lv, s9509c3f45, ABISELECT(736,728), "S9509C3.s9509c3f45");
    check_field_offset(lv, s9509c3f46, ABISELECT(744,736), "S9509C3.s9509c3f46");
    check_field_offset(lv, s9509c3f47, ABISELECT(748,740), "S9509C3.s9509c3f47");
    check_field_offset(lv, s9509c3f48, ABISELECT(752,744), "S9509C3.s9509c3f48");
    check_field_offset(lv, s9509c3f49, ABISELECT(756,748), "S9509C3.s9509c3f49");
    check_field_offset(lv, s9509c3f50, ABISELECT(760,752), "S9509C3.s9509c3f50");
    check_field_offset(lv, s9509c3f51, ABISELECT(784,764), "S9509C3.s9509c3f51");
    check_field_offset(lv, s9509c3f52, ABISELECT(788,768), "S9509C3.s9509c3f52");
    check_field_offset(lv, s9509c3f53, ABISELECT(796,776), "S9509C3.s9509c3f53");
    check_field_offset(lv, s9509c3f54, ABISELECT(797,777), "S9509C3.s9509c3f54");
    check_field_offset(lv, s9509c3f55, ABISELECT(813,793), "S9509C3.s9509c3f55");
    check_field_offset(lv, s9509c3f56, ABISELECT(829,809), "S9509C3.s9509c3f56");
    check_field_offset(lv, s9509c3f57, ABISELECT(848,828), "S9509C3.s9509c3f57");
    check_field_offset(lv, s9509c3f58, ABISELECT(896,876), "S9509C3.s9509c3f58");
    check_field_offset(lv, s9509c3f59, ABISELECT(912,892), "S9509C3.s9509c3f59");
    check_field_offset(lv, s9509c3f60, ABISELECT(924,904), "S9509C3.s9509c3f60");
    check_field_offset(lv, s9509c3f61, ABISELECT(926,906), "S9509C3.s9509c3f61");
    check_field_offset(lv, s9509c3f62, ABISELECT(992,972), "S9509C3.s9509c3f62");
    check_field_offset(lv, s9509c3f63, ABISELECT(1016,996), "S9509C3.s9509c3f63");
    check_field_offset(lv, s9509c3f64, ABISELECT(1020,1000), "S9509C3.s9509c3f64");
    check_field_offset(lv, s9509c3f65, ABISELECT(1024,1004), "S9509C3.s9509c3f65");
    check_field_offset(lv, s9509c3f66, ABISELECT(1028,1008), "S9509C3.s9509c3f66");
    check_field_offset(lv, s9509c3f67, ABISELECT(1052,1032), "S9509C3.s9509c3f67");
    check_field_offset(lv, s9509c3f68, ABISELECT(1056,1036), "S9509C3.s9509c3f68");
    check_field_offset(lv, s9509c3f69, ABISELECT(1072,1052), "S9509C3.s9509c3f69");
    check_field_offset(lv, s9509c3f70, ABISELECT(1096,1076), "S9509C3.s9509c3f70");
    check_field_offset(lv, s9509c3f71, ABISELECT(1160,1140), "S9509C3.s9509c3f71");
  }
}
static Arrange_To_Call_Me vS9509C3(Test_S9509C3, "S9509C3", ABISELECT(1224,1204));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C14_nt  {
  int s9509c14f0[4];
};
//SIG(-1 S9509C14_nt) C1{ Fi[4]}



//skip512 S9509C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C12  {
  void *s9509c12f0;
  char s9509c12f1[2];
  int s9509c12f2[15];
  char s9509c12f3;
  int s9509c12f4;
  void *s9509c12f5;
  int s9509c12f6;
  ::S15308C9_nt s9509c12f7;
  char s9509c12f8;
  int s9509c12f9[2];
  void *s9509c12f10;
  int s9509c12f11[3];
  char s9509c12f12[3];
  ::S9509C14_nt s9509c12f13;
  int s9509c12f14[3];
  char s9509c12f15[2];
  ::S15308C172 s9509c12f16;
  int s9509c12f17;
  void *s9509c12f18;
  char s9509c12f19;
  int s9509c12f20;
  void  mf9509c12(); // _ZN8S9509C129mf9509c12Ev
};
//SIG(1 S9509C12) C1{ m Fp Fc[2] Fi[15] Fc Fi Fp Fi FC2{ m FL} Fc Fi[2] Fp Fi[3] Fc[3] FC3{ Fi[4]} Fi[3] Fc[2] FC4{ BC5{ m Fc[16]}} Fi Fp Fc Fi}


void  S9509C12 ::mf9509c12(){}

static void Test_S9509C12()
{
  {
    init_simple_test("S9509C12");
    S9509C12 lv;
    check2(sizeof(lv), ABISELECT(216,188), "sizeof(S9509C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9509C12)");
    check_field_offset(lv, s9509c12f0, 0, "S9509C12.s9509c12f0");
    check_field_offset(lv, s9509c12f1, ABISELECT(8,4), "S9509C12.s9509c12f1");
    check_field_offset(lv, s9509c12f2, ABISELECT(12,8), "S9509C12.s9509c12f2");
    check_field_offset(lv, s9509c12f3, ABISELECT(72,68), "S9509C12.s9509c12f3");
    check_field_offset(lv, s9509c12f4, ABISELECT(76,72), "S9509C12.s9509c12f4");
    check_field_offset(lv, s9509c12f5, ABISELECT(80,76), "S9509C12.s9509c12f5");
    check_field_offset(lv, s9509c12f6, ABISELECT(88,80), "S9509C12.s9509c12f6");
    check_field_offset(lv, s9509c12f7, ABISELECT(96,84), "S9509C12.s9509c12f7");
    check_field_offset(lv, s9509c12f8, ABISELECT(104,92), "S9509C12.s9509c12f8");
    check_field_offset(lv, s9509c12f9, ABISELECT(108,96), "S9509C12.s9509c12f9");
    check_field_offset(lv, s9509c12f10, ABISELECT(120,104), "S9509C12.s9509c12f10");
    check_field_offset(lv, s9509c12f11, ABISELECT(128,108), "S9509C12.s9509c12f11");
    check_field_offset(lv, s9509c12f12, ABISELECT(140,120), "S9509C12.s9509c12f12");
    check_field_offset(lv, s9509c12f13, ABISELECT(144,124), "S9509C12.s9509c12f13");
    check_field_offset(lv, s9509c12f14, ABISELECT(160,140), "S9509C12.s9509c12f14");
    check_field_offset(lv, s9509c12f15, ABISELECT(172,152), "S9509C12.s9509c12f15");
    check_field_offset(lv, s9509c12f16, ABISELECT(174,154), "S9509C12.s9509c12f16");
    check_field_offset(lv, s9509c12f17, ABISELECT(192,172), "S9509C12.s9509c12f17");
    check_field_offset(lv, s9509c12f18, ABISELECT(200,176), "S9509C12.s9509c12f18");
    check_field_offset(lv, s9509c12f19, ABISELECT(208,180), "S9509C12.s9509c12f19");
    check_field_offset(lv, s9509c12f20, ABISELECT(212,184), "S9509C12.s9509c12f20");
  }
}
static Arrange_To_Call_Me vS9509C12(Test_S9509C12, "S9509C12", ABISELECT(216,188));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C15  : S9509C2 {
  void *s9509c15f0[2];
  int s9509c15f1;
  char s9509c15f2;
  int s9509c15f3;
  char s9509c15f4[2];
  int s9509c15f5;
  char s9509c15f6;
  int s9509c15f7;
  void *s9509c15f8[32];
  ::S9509C9_nt s9509c15f9;
  virtual  ~S9509C15(); // _ZN8S9509C15D1Ev
  virtual void  v8(); // _ZN8S9509C152v8Ev
  virtual void  v9(); // _ZN8S9509C152v9Ev
  S9509C15(); // tgen
};
//SIG(-1 S9509C15) C1{ BC2{ vd v3 v4 v5 v6 v7} vd v1 v2 Fp[2] Fi Fc Fi Fc[2] Fi Fc Fi Fp[32] FC3{ BC4{ m FC5{ m Fc[16]} FC5 FC5 FC5}}}


 S9509C15 ::~S9509C15(){ note_dtor("S9509C15", this);}
void  S9509C15 ::v8(){vfunc_called(this, "_ZN8S9509C152v8Ev");}
void  S9509C15 ::v9(){vfunc_called(this, "_ZN8S9509C152v9Ev");}
S9509C15 ::S9509C15(){ note_ctor("S9509C15", this);} // tgen

static void Test_S9509C15()
{
  extern Class_Descriptor cd_S9509C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(48,59)];
    init_test(&cd_S9509C15, buf);
    S9509C15 *dp, &lv = *(dp=new (buf) S9509C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(376,232), "sizeof(S9509C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9509C15)");
    check_base_class_offset(lv, (S9509C2*), 0, "S9509C15");
    check_field_offset(lv, s9509c15f0, ABISELECT(8,4), "S9509C15.s9509c15f0");
    check_field_offset(lv, s9509c15f1, ABISELECT(24,12), "S9509C15.s9509c15f1");
    check_field_offset(lv, s9509c15f2, ABISELECT(28,16), "S9509C15.s9509c15f2");
    check_field_offset(lv, s9509c15f3, ABISELECT(32,20), "S9509C15.s9509c15f3");
    check_field_offset(lv, s9509c15f4, ABISELECT(36,24), "S9509C15.s9509c15f4");
    check_field_offset(lv, s9509c15f5, ABISELECT(40,28), "S9509C15.s9509c15f5");
    check_field_offset(lv, s9509c15f6, ABISELECT(44,32), "S9509C15.s9509c15f6");
    check_field_offset(lv, s9509c15f7, ABISELECT(48,36), "S9509C15.s9509c15f7");
    check_field_offset(lv, s9509c15f8, ABISELECT(56,40), "S9509C15.s9509c15f8");
    check_field_offset(lv, s9509c15f9, ABISELECT(312,168), "S9509C15.s9509c15f9");
    test_class_info(&lv, &cd_S9509C15);
    dp->~S9509C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9509C15(Test_S9509C15, "S9509C15", ABISELECT(376,232));

#else // __cplusplus

extern void _ZN8S9509C15C1Ev();
extern void _ZN8S9509C15D1Ev();
Name_Map name_map_S9509C15[] = {
  NSPAIR(_ZN8S9509C15C1Ev),
  NSPAIR(_ZN8S9509C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9509C2;
extern VTBL_ENTRY _ZTI7S9509C2[];
extern  VTBL_ENTRY _ZTV7S9509C2[];
static Base_Class bases_S9509C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9509C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S9509C15[];
extern void _ZN8S9509C15D1Ev();
extern void _ZN8S9509C15D0Ev();
extern void _ZN7S9509C22v3Ev();
extern void _ZN7S9509C22v4Ev();
extern void _ZN7S9509C22v5Ev();
extern void _ZN7S9509C22v6Ev();
extern void _ZN7S9509C22v7Ev();
extern void _ZN8S9509C152v8Ev();
extern void _ZN8S9509C152v9Ev();
static  VTBL_ENTRY vtc_S9509C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S9509C15[0]),
  (VTBL_ENTRY)&_ZN8S9509C15D1Ev,
  (VTBL_ENTRY)&_ZN8S9509C15D0Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v3Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v4Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v7Ev,
  (VTBL_ENTRY)&_ZN8S9509C152v8Ev,
  (VTBL_ENTRY)&_ZN8S9509C152v9Ev,
};
extern VTBL_ENTRY _ZTI8S9509C15[];
extern  VTBL_ENTRY _ZTV8S9509C15[];
Class_Descriptor cd_S9509C15 = {  "S9509C15", // class name
  bases_S9509C15, 1,
  &(vtc_S9509C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(376,232), // object size
  NSPAIRA(_ZTI8S9509C15),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S9509C15),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C16_nt  {
  int s9509c16f0;
  void  mf9509c16(); // _ZN11S9509C16_nt9mf9509c16Ev
};
//SIG(-1 S9509C16_nt) C1{ m Fi}


void  S9509C16_nt ::mf9509c16(){}

//skip512 S9509C16_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S9509C16_nt[];
VTBL_ENTRY *P__ZTI11S9509C16_nt = _ZTI11S9509C16_nt; 
Class_Descriptor cd_S9509C16_nt = {  "S9509C16_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI11S9509C16_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9509C1  : S9509C2 {
  int s9509c1f0;
  ::S9509C3 s9509c1f1[20];
  ::S9509C12 s9509c1f2[20];
  void *s9509c1f3[20];
  int s9509c1f4;
  char s9509c1f5[4];
  int s9509c1f6[5];
  ::S9509C15 s9509c1f7;
  int s9509c1f8[3];
  char s9509c1f9[10];
  int s9509c1f10[6];
  char s9509c1f11[5];
  int s9509c1f12[30];
  char s9509c1f13[3];
  int s9509c1f14[14];
  char s9509c1f15;
  int s9509c1f16[15];
  ::S9509C16_nt s9509c1f17;
  int s9509c1f18[2];
  void *s9509c1f19[3];
  int s9509c1f20;
  char s9509c1f21;
  int s9509c1f22;
  char s9509c1f23;
  int s9509c1f24[7];
  char s9509c1f25;
  ::S15308C172 s9509c1f26;
  int s9509c1f27[3];
  char s9509c1f28;
  ::S15308C202 s9509c1f29;
  char s9509c1f30;
  virtual  ~S9509C1(); // _ZN7S9509C1D1Ev
  virtual void  v1(); // _ZN7S9509C12v1Ev
  virtual void  v2(); // _ZN7S9509C12v2Ev
  S9509C1(); // tgen
};
//SIG(1 S9509C1) C1{ BC2{ vd v3 v4 v5 v6 v7} vd v1 v2 Fi FC3{ m FC4{ m Fi[7]} Fi[3] Fc Fi[2] FC5{ m Fi[4] FC6{ BC7{ m Fc[16]}} Fi} Fi[4] FC8{ m Fi[7] Fc[3] Fi} FC9{ BC10{ m FC7 FC7 FC7 FC7}} FC6 FC6 FC6 FC6 FC6 FC6 Fi[23] Fp[2] Fc[2] Fi Fc Fi[2] Fc Fi[2] FC6 FC6 Fc[3] FC6 Fi Fc[2] Fi[3] Fc Fi[2] Fc Fi[4] FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6 FC6 Fc[8] Fi Fc Fi Fc Fp[3] Fc Fi[2] Fc FC6 FC6 FC6 Fi[12] FC6 Fi[3] Fc[2] FC9 Fi[6] Fc Fi Fc FC11{ m Fi[5] Fc} Fi FC6 Fi[6] FC6[4] FC6[4]}[20] FC12{ m Fp Fc[2] Fi[15] Fc Fi Fp Fi FC13{ m FL} Fc Fi[2] Fp Fi[3] Fc[3] FC14{ Fi[4]} Fi[3] Fc[2] FC6 Fi Fp Fc Fi}[20] Fp[20] Fi Fc[4] Fi[5] FC15{ BC2 vd v8 v9 Fp[2] Fi Fc Fi Fc[2] Fi Fc Fi Fp[32] FC9} Fi[3] Fc[10] Fi[6] Fc[5] Fi[30] Fc[3] Fi[14] Fc Fi[15] FC16{ m Fi} Fi[2] Fp[3] Fi Fc Fi Fc Fi[7] Fc FC6 Fi[3] Fc FC17{ BC18{ BC19{ BC20{ BC21{ BC22{ BC23{} FC24{ BC25{}}} FC26{ BC27{}}} FC26} FC28{ BC29{}}} Fp Fi}} Fc}


 S9509C1 ::~S9509C1(){ note_dtor("S9509C1", this);}
void  S9509C1 ::v1(){vfunc_called(this, "_ZN7S9509C12v1Ev");}
void  S9509C1 ::v2(){vfunc_called(this, "_ZN7S9509C12v2Ev");}
S9509C1 ::S9509C1(){ note_ctor("S9509C1", this);} // tgen

static void Test_S9509C1()
{
  extern Class_Descriptor cd_S9509C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3730,7153)];
    init_test(&cd_S9509C1, buf);
    S9509C1 *dp, &lv = *(dp=new (buf) S9509C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(29832,28608), "sizeof(S9509C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9509C1)");
    check_base_class_offset(lv, (S9509C2*), 0, "S9509C1");
    check_field_offset(lv, s9509c1f0, ABISELECT(8,4), "S9509C1.s9509c1f0");
    check_field_offset(lv, s9509c1f1, ABISELECT(16,8), "S9509C1.s9509c1f1");
    check_field_offset(lv, s9509c1f2, ABISELECT(24496,24088), "S9509C1.s9509c1f2");
    check_field_offset(lv, s9509c1f3, ABISELECT(28816,27848), "S9509C1.s9509c1f3");
    check_field_offset(lv, s9509c1f4, ABISELECT(28976,27928), "S9509C1.s9509c1f4");
    check_field_offset(lv, s9509c1f5, ABISELECT(28980,27932), "S9509C1.s9509c1f5");
    check_field_offset(lv, s9509c1f6, ABISELECT(28984,27936), "S9509C1.s9509c1f6");
    check_field_offset(lv, s9509c1f7, ABISELECT(29008,27956), "S9509C1.s9509c1f7");
    check_field_offset(lv, s9509c1f8, ABISELECT(29384,28188), "S9509C1.s9509c1f8");
    check_field_offset(lv, s9509c1f9, ABISELECT(29396,28200), "S9509C1.s9509c1f9");
    check_field_offset(lv, s9509c1f10, ABISELECT(29408,28212), "S9509C1.s9509c1f10");
    check_field_offset(lv, s9509c1f11, ABISELECT(29432,28236), "S9509C1.s9509c1f11");
    check_field_offset(lv, s9509c1f12, ABISELECT(29440,28244), "S9509C1.s9509c1f12");
    check_field_offset(lv, s9509c1f13, ABISELECT(29560,28364), "S9509C1.s9509c1f13");
    check_field_offset(lv, s9509c1f14, ABISELECT(29564,28368), "S9509C1.s9509c1f14");
    check_field_offset(lv, s9509c1f15, ABISELECT(29620,28424), "S9509C1.s9509c1f15");
    check_field_offset(lv, s9509c1f16, ABISELECT(29624,28428), "S9509C1.s9509c1f16");
    check_field_offset(lv, s9509c1f17, ABISELECT(29684,28488), "S9509C1.s9509c1f17");
    check_field_offset(lv, s9509c1f18, ABISELECT(29688,28492), "S9509C1.s9509c1f18");
    check_field_offset(lv, s9509c1f19, ABISELECT(29696,28500), "S9509C1.s9509c1f19");
    check_field_offset(lv, s9509c1f20, ABISELECT(29720,28512), "S9509C1.s9509c1f20");
    check_field_offset(lv, s9509c1f21, ABISELECT(29724,28516), "S9509C1.s9509c1f21");
    check_field_offset(lv, s9509c1f22, ABISELECT(29728,28520), "S9509C1.s9509c1f22");
    check_field_offset(lv, s9509c1f23, ABISELECT(29732,28524), "S9509C1.s9509c1f23");
    check_field_offset(lv, s9509c1f24, ABISELECT(29736,28528), "S9509C1.s9509c1f24");
    check_field_offset(lv, s9509c1f25, ABISELECT(29764,28556), "S9509C1.s9509c1f25");
    check_field_offset(lv, s9509c1f26, ABISELECT(29765,28557), "S9509C1.s9509c1f26");
    check_field_offset(lv, s9509c1f27, ABISELECT(29784,28576), "S9509C1.s9509c1f27");
    check_field_offset(lv, s9509c1f28, ABISELECT(29796,28588), "S9509C1.s9509c1f28");
    check_field_offset(lv, s9509c1f29, ABISELECT(29800,28592), "S9509C1.s9509c1f29");
    check_field_offset(lv, s9509c1f30, ABISELECT(29824,28604), "S9509C1.s9509c1f30");
    test_class_info(&lv, &cd_S9509C1);
    dp->~S9509C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9509C1(Test_S9509C1, "S9509C1", ABISELECT(29832,28608));

#else // __cplusplus

extern void _ZN7S9509C1C1Ev();
extern void _ZN7S9509C1D1Ev();
Name_Map name_map_S9509C1[] = {
  NSPAIR(_ZN7S9509C1C1Ev),
  NSPAIR(_ZN7S9509C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9509C2;
extern VTBL_ENTRY _ZTI7S9509C2[];
extern  VTBL_ENTRY _ZTV7S9509C2[];
static Base_Class bases_S9509C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9509C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9509C1[];
extern void _ZN7S9509C1D1Ev();
extern void _ZN7S9509C1D0Ev();
extern void _ZN7S9509C22v3Ev();
extern void _ZN7S9509C22v4Ev();
extern void _ZN7S9509C22v5Ev();
extern void _ZN7S9509C22v6Ev();
extern void _ZN7S9509C22v7Ev();
extern void _ZN7S9509C12v1Ev();
extern void _ZN7S9509C12v2Ev();
static  VTBL_ENTRY vtc_S9509C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9509C1[0]),
  (VTBL_ENTRY)&_ZN7S9509C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9509C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v3Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v4Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9509C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9509C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9509C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S9509C1[];
extern  VTBL_ENTRY _ZTV7S9509C1[];
Class_Descriptor cd_S9509C1 = {  "S9509C1", // class name
  bases_S9509C1, 1,
  &(vtc_S9509C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(29832,28608), // object size
  NSPAIRA(_ZTI7S9509C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9509C1),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C5_nt  {
  int s572c5f0;
  __tsi64 s572c5f1;
  void *s572c5f2[4];
  int s572c5f3[2];
  void *s572c5f4;
  ::S4658C32_nt s572c5f5;
  void *s572c5f6[2];
  virtual  ~S572C5_nt(); // _ZN9S572C5_ntD1Ev
  virtual void  v4(); // _ZN9S572C5_nt2v4Ev
  virtual void  v5(); // _ZN9S572C5_nt2v5Ev
  virtual void  v6(); // _ZN9S572C5_nt2v6Ev
  virtual void  v7(); // _ZN9S572C5_nt2v7Ev
  virtual void  v8(); // _ZN9S572C5_nt2v8Ev
  virtual void  v9(); // _ZN9S572C5_nt2v9Ev
  virtual void  v10(); // _ZN9S572C5_nt3v10Ev
  virtual void  v11(); // _ZN9S572C5_nt3v11Ev
  virtual void  v12(); // _ZN9S572C5_nt3v12Ev
  virtual void  v13(); // _ZN9S572C5_nt3v13Ev
  virtual void  v14(); // _ZN9S572C5_nt3v14Ev
  virtual void  v15(); // _ZN9S572C5_nt3v15Ev
  virtual void  v16(); // _ZN9S572C5_nt3v16Ev
  virtual void  v17(); // _ZN9S572C5_nt3v17Ev
  virtual void  v18(); // _ZN9S572C5_nt3v18Ev
  virtual void  v19(); // _ZN9S572C5_nt3v19Ev
  virtual void  v20(); // _ZN9S572C5_nt3v20Ev
  virtual void  v21(); // _ZN9S572C5_nt3v21Ev
  virtual void  v22(); // _ZN9S572C5_nt3v22Ev
  virtual void  v23(); // _ZN9S572C5_nt3v23Ev
  virtual void  v24(); // _ZN9S572C5_nt3v24Ev
  virtual void  v25(); // _ZN9S572C5_nt3v25Ev
  virtual void  v26(); // _ZN9S572C5_nt3v26Ev
  virtual void  v27(); // _ZN9S572C5_nt3v27Ev
  virtual void  v28(); // _ZN9S572C5_nt3v28Ev
  virtual void  v29(); // _ZN9S572C5_nt3v29Ev
  virtual void  v30(); // _ZN9S572C5_nt3v30Ev
  virtual void  v31(); // _ZN9S572C5_nt3v31Ev
  virtual void  v32(); // _ZN9S572C5_nt3v32Ev
  virtual void  v33(); // _ZN9S572C5_nt3v33Ev
  virtual void  v34(); // _ZN9S572C5_nt3v34Ev
  virtual void  v35(); // _ZN9S572C5_nt3v35Ev
  virtual void  v36(); // _ZN9S572C5_nt3v36Ev
  virtual void  v37(); // _ZN9S572C5_nt3v37Ev
  virtual void  v38(); // _ZN9S572C5_nt3v38Ev
  virtual void  v39(); // _ZN9S572C5_nt3v39Ev
  virtual void  v40(); // _ZN9S572C5_nt3v40Ev
  virtual void  v41(); // _ZN9S572C5_nt3v41Ev
  virtual void  v42(); // _ZN9S572C5_nt3v42Ev
  virtual void  v43(); // _ZN9S572C5_nt3v43Ev
  virtual void  v44(); // _ZN9S572C5_nt3v44Ev
  virtual void  v45(); // _ZN9S572C5_nt3v45Ev
  virtual void  v46(); // _ZN9S572C5_nt3v46Ev
  virtual void  v47(); // _ZN9S572C5_nt3v47Ev
  virtual void  v48(); // _ZN9S572C5_nt3v48Ev
  virtual void  v49(); // _ZN9S572C5_nt3v49Ev
  virtual void  v50(); // _ZN9S572C5_nt3v50Ev
  virtual void  v51(); // _ZN9S572C5_nt3v51Ev
  virtual void  v52(); // _ZN9S572C5_nt3v52Ev
  virtual void  v53(); // _ZN9S572C5_nt3v53Ev
  virtual void  v54(); // _ZN9S572C5_nt3v54Ev
  virtual void  v55(); // _ZN9S572C5_nt3v55Ev
  virtual void  v56(); // _ZN9S572C5_nt3v56Ev
  virtual void  v57(); // _ZN9S572C5_nt3v57Ev
  virtual void  v58(); // _ZN9S572C5_nt3v58Ev
  virtual void  v59(); // _ZN9S572C5_nt3v59Ev
  virtual void  v60(); // _ZN9S572C5_nt3v60Ev
  virtual void  v61(); // _ZN9S572C5_nt3v61Ev
  virtual void  v62(); // _ZN9S572C5_nt3v62Ev
  virtual void  v63(); // _ZN9S572C5_nt3v63Ev
  virtual void  v64(); // _ZN9S572C5_nt3v64Ev
  virtual void  v65(); // _ZN9S572C5_nt3v65Ev
  virtual void  v66(); // _ZN9S572C5_nt3v66Ev
  virtual void  v67(); // _ZN9S572C5_nt3v67Ev
  S572C5_nt(); // tgen
};
//SIG(-1 S572C5_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S572C5_nt ::~S572C5_nt(){ note_dtor("S572C5_nt", this);}
void  S572C5_nt ::v4(){vfunc_called(this, "_ZN9S572C5_nt2v4Ev");}
void  S572C5_nt ::v5(){vfunc_called(this, "_ZN9S572C5_nt2v5Ev");}
void  S572C5_nt ::v6(){vfunc_called(this, "_ZN9S572C5_nt2v6Ev");}
void  S572C5_nt ::v7(){vfunc_called(this, "_ZN9S572C5_nt2v7Ev");}
void  S572C5_nt ::v8(){vfunc_called(this, "_ZN9S572C5_nt2v8Ev");}
void  S572C5_nt ::v9(){vfunc_called(this, "_ZN9S572C5_nt2v9Ev");}
void  S572C5_nt ::v10(){vfunc_called(this, "_ZN9S572C5_nt3v10Ev");}
void  S572C5_nt ::v11(){vfunc_called(this, "_ZN9S572C5_nt3v11Ev");}
void  S572C5_nt ::v12(){vfunc_called(this, "_ZN9S572C5_nt3v12Ev");}
void  S572C5_nt ::v13(){vfunc_called(this, "_ZN9S572C5_nt3v13Ev");}
void  S572C5_nt ::v14(){vfunc_called(this, "_ZN9S572C5_nt3v14Ev");}
void  S572C5_nt ::v15(){vfunc_called(this, "_ZN9S572C5_nt3v15Ev");}
void  S572C5_nt ::v16(){vfunc_called(this, "_ZN9S572C5_nt3v16Ev");}
void  S572C5_nt ::v17(){vfunc_called(this, "_ZN9S572C5_nt3v17Ev");}
void  S572C5_nt ::v18(){vfunc_called(this, "_ZN9S572C5_nt3v18Ev");}
void  S572C5_nt ::v19(){vfunc_called(this, "_ZN9S572C5_nt3v19Ev");}
void  S572C5_nt ::v20(){vfunc_called(this, "_ZN9S572C5_nt3v20Ev");}
void  S572C5_nt ::v21(){vfunc_called(this, "_ZN9S572C5_nt3v21Ev");}
void  S572C5_nt ::v22(){vfunc_called(this, "_ZN9S572C5_nt3v22Ev");}
void  S572C5_nt ::v23(){vfunc_called(this, "_ZN9S572C5_nt3v23Ev");}
void  S572C5_nt ::v24(){vfunc_called(this, "_ZN9S572C5_nt3v24Ev");}
void  S572C5_nt ::v25(){vfunc_called(this, "_ZN9S572C5_nt3v25Ev");}
void  S572C5_nt ::v26(){vfunc_called(this, "_ZN9S572C5_nt3v26Ev");}
void  S572C5_nt ::v27(){vfunc_called(this, "_ZN9S572C5_nt3v27Ev");}
void  S572C5_nt ::v28(){vfunc_called(this, "_ZN9S572C5_nt3v28Ev");}
void  S572C5_nt ::v29(){vfunc_called(this, "_ZN9S572C5_nt3v29Ev");}
void  S572C5_nt ::v30(){vfunc_called(this, "_ZN9S572C5_nt3v30Ev");}
void  S572C5_nt ::v31(){vfunc_called(this, "_ZN9S572C5_nt3v31Ev");}
void  S572C5_nt ::v32(){vfunc_called(this, "_ZN9S572C5_nt3v32Ev");}
void  S572C5_nt ::v33(){vfunc_called(this, "_ZN9S572C5_nt3v33Ev");}
void  S572C5_nt ::v34(){vfunc_called(this, "_ZN9S572C5_nt3v34Ev");}
void  S572C5_nt ::v35(){vfunc_called(this, "_ZN9S572C5_nt3v35Ev");}
void  S572C5_nt ::v36(){vfunc_called(this, "_ZN9S572C5_nt3v36Ev");}
void  S572C5_nt ::v37(){vfunc_called(this, "_ZN9S572C5_nt3v37Ev");}
void  S572C5_nt ::v38(){vfunc_called(this, "_ZN9S572C5_nt3v38Ev");}
void  S572C5_nt ::v39(){vfunc_called(this, "_ZN9S572C5_nt3v39Ev");}
void  S572C5_nt ::v40(){vfunc_called(this, "_ZN9S572C5_nt3v40Ev");}
void  S572C5_nt ::v41(){vfunc_called(this, "_ZN9S572C5_nt3v41Ev");}
void  S572C5_nt ::v42(){vfunc_called(this, "_ZN9S572C5_nt3v42Ev");}
void  S572C5_nt ::v43(){vfunc_called(this, "_ZN9S572C5_nt3v43Ev");}
void  S572C5_nt ::v44(){vfunc_called(this, "_ZN9S572C5_nt3v44Ev");}
void  S572C5_nt ::v45(){vfunc_called(this, "_ZN9S572C5_nt3v45Ev");}
void  S572C5_nt ::v46(){vfunc_called(this, "_ZN9S572C5_nt3v46Ev");}
void  S572C5_nt ::v47(){vfunc_called(this, "_ZN9S572C5_nt3v47Ev");}
void  S572C5_nt ::v48(){vfunc_called(this, "_ZN9S572C5_nt3v48Ev");}
void  S572C5_nt ::v49(){vfunc_called(this, "_ZN9S572C5_nt3v49Ev");}
void  S572C5_nt ::v50(){vfunc_called(this, "_ZN9S572C5_nt3v50Ev");}
void  S572C5_nt ::v51(){vfunc_called(this, "_ZN9S572C5_nt3v51Ev");}
void  S572C5_nt ::v52(){vfunc_called(this, "_ZN9S572C5_nt3v52Ev");}
void  S572C5_nt ::v53(){vfunc_called(this, "_ZN9S572C5_nt3v53Ev");}
void  S572C5_nt ::v54(){vfunc_called(this, "_ZN9S572C5_nt3v54Ev");}
void  S572C5_nt ::v55(){vfunc_called(this, "_ZN9S572C5_nt3v55Ev");}
void  S572C5_nt ::v56(){vfunc_called(this, "_ZN9S572C5_nt3v56Ev");}
void  S572C5_nt ::v57(){vfunc_called(this, "_ZN9S572C5_nt3v57Ev");}
void  S572C5_nt ::v58(){vfunc_called(this, "_ZN9S572C5_nt3v58Ev");}
void  S572C5_nt ::v59(){vfunc_called(this, "_ZN9S572C5_nt3v59Ev");}
void  S572C5_nt ::v60(){vfunc_called(this, "_ZN9S572C5_nt3v60Ev");}
void  S572C5_nt ::v61(){vfunc_called(this, "_ZN9S572C5_nt3v61Ev");}
void  S572C5_nt ::v62(){vfunc_called(this, "_ZN9S572C5_nt3v62Ev");}
void  S572C5_nt ::v63(){vfunc_called(this, "_ZN9S572C5_nt3v63Ev");}
void  S572C5_nt ::v64(){vfunc_called(this, "_ZN9S572C5_nt3v64Ev");}
void  S572C5_nt ::v65(){vfunc_called(this, "_ZN9S572C5_nt3v65Ev");}
void  S572C5_nt ::v66(){vfunc_called(this, "_ZN9S572C5_nt3v66Ev");}
void  S572C5_nt ::v67(){vfunc_called(this, "_ZN9S572C5_nt3v67Ev");}
S572C5_nt ::S572C5_nt(){ note_ctor("S572C5_nt", this);} // tgen

//skip512 S572C5_nt

#else // __cplusplus

extern void _ZN9S572C5_ntC1Ev();
extern void _ZN9S572C5_ntD1Ev();
Name_Map name_map_S572C5_nt[] = {
  NSPAIR(_ZN9S572C5_ntC1Ev),
  NSPAIR(_ZN9S572C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S572C5_nt[];
extern void _ZN9S572C5_ntD1Ev();
extern void _ZN9S572C5_ntD0Ev();
extern void _ZN9S572C5_nt2v4Ev();
extern void _ZN9S572C5_nt2v5Ev();
extern void _ZN9S572C5_nt2v6Ev();
extern void _ZN9S572C5_nt2v7Ev();
extern void _ZN9S572C5_nt2v8Ev();
extern void _ZN9S572C5_nt2v9Ev();
extern void _ZN9S572C5_nt3v10Ev();
extern void _ZN9S572C5_nt3v11Ev();
extern void _ZN9S572C5_nt3v12Ev();
extern void _ZN9S572C5_nt3v13Ev();
extern void _ZN9S572C5_nt3v14Ev();
extern void _ZN9S572C5_nt3v15Ev();
extern void _ZN9S572C5_nt3v16Ev();
extern void _ZN9S572C5_nt3v17Ev();
extern void _ZN9S572C5_nt3v18Ev();
extern void _ZN9S572C5_nt3v19Ev();
extern void _ZN9S572C5_nt3v20Ev();
extern void _ZN9S572C5_nt3v21Ev();
extern void _ZN9S572C5_nt3v22Ev();
extern void _ZN9S572C5_nt3v23Ev();
extern void _ZN9S572C5_nt3v24Ev();
extern void _ZN9S572C5_nt3v25Ev();
extern void _ZN9S572C5_nt3v26Ev();
extern void _ZN9S572C5_nt3v27Ev();
extern void _ZN9S572C5_nt3v28Ev();
extern void _ZN9S572C5_nt3v29Ev();
extern void _ZN9S572C5_nt3v30Ev();
extern void _ZN9S572C5_nt3v31Ev();
extern void _ZN9S572C5_nt3v32Ev();
extern void _ZN9S572C5_nt3v33Ev();
extern void _ZN9S572C5_nt3v34Ev();
extern void _ZN9S572C5_nt3v35Ev();
extern void _ZN9S572C5_nt3v36Ev();
extern void _ZN9S572C5_nt3v37Ev();
extern void _ZN9S572C5_nt3v38Ev();
extern void _ZN9S572C5_nt3v39Ev();
extern void _ZN9S572C5_nt3v40Ev();
extern void _ZN9S572C5_nt3v41Ev();
extern void _ZN9S572C5_nt3v42Ev();
extern void _ZN9S572C5_nt3v43Ev();
extern void _ZN9S572C5_nt3v44Ev();
extern void _ZN9S572C5_nt3v45Ev();
extern void _ZN9S572C5_nt3v46Ev();
extern void _ZN9S572C5_nt3v47Ev();
extern void _ZN9S572C5_nt3v48Ev();
extern void _ZN9S572C5_nt3v49Ev();
extern void _ZN9S572C5_nt3v50Ev();
extern void _ZN9S572C5_nt3v51Ev();
extern void _ZN9S572C5_nt3v52Ev();
extern void _ZN9S572C5_nt3v53Ev();
extern void _ZN9S572C5_nt3v54Ev();
extern void _ZN9S572C5_nt3v55Ev();
extern void _ZN9S572C5_nt3v56Ev();
extern void _ZN9S572C5_nt3v57Ev();
extern void _ZN9S572C5_nt3v58Ev();
extern void _ZN9S572C5_nt3v59Ev();
extern void _ZN9S572C5_nt3v60Ev();
extern void _ZN9S572C5_nt3v61Ev();
extern void _ZN9S572C5_nt3v62Ev();
extern void _ZN9S572C5_nt3v63Ev();
extern void _ZN9S572C5_nt3v64Ev();
extern void _ZN9S572C5_nt3v65Ev();
extern void _ZN9S572C5_nt3v66Ev();
extern void _ZN9S572C5_nt3v67Ev();
static  VTBL_ENTRY vtc_S572C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S572C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S572C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S572C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI9S572C5_nt[];
VTBL_ENTRY *P__ZTI9S572C5_nt = _ZTI9S572C5_nt; 
extern  VTBL_ENTRY _ZTV9S572C5_nt[];
Class_Descriptor cd_S572C5_nt = {  "S572C5_nt", // class name
  0,0,//no base classes
  &(vtc_S572C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S572C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S572C5_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C10_nt  {
  void *s572c10f0;
  int s572c10f1[2];
  void  mf572c10(); // _ZN10S572C10_nt8mf572c10Ev
};
//SIG(-1 S572C10_nt) C1{ m Fp Fi[2]}


void  S572C10_nt ::mf572c10(){}

//skip512 S572C10_nt

#else // __cplusplus

Class_Descriptor cd_S572C10_nt = {  "S572C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C9_nt  : S572C10_nt {
};
//SIG(-1 S572C9_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S572C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S572C10_nt;
static Base_Class bases_S572C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S572C9_nt = {  "S572C9_nt", // class name
  bases_S572C9_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C8_nt  : S572C9_nt {
};
//SIG(-1 S572C8_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S572C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S572C10_nt;
extern Class_Descriptor cd_S572C9_nt;
static Base_Class bases_S572C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S572C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S572C8_nt = {  "S572C8_nt", // class name
  bases_S572C8_nt, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C7_nt  : S572C8_nt {
};
//SIG(-1 S572C7_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S572C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S572C10_nt;
extern Class_Descriptor cd_S572C9_nt;
extern Class_Descriptor cd_S572C8_nt;
static Base_Class bases_S572C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S572C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S572C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C11_nt  {
  void  mf572c11(); // _ZN10S572C11_nt8mf572c11Ev
};
//SIG(-1 S572C11_nt) C1{ m}


void  S572C11_nt ::mf572c11(){}

//skip512 S572C11_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S572C11_nt[];
VTBL_ENTRY *P__ZTI10S572C11_nt = _ZTI10S572C11_nt; 
Class_Descriptor cd_S572C11_nt = {  "S572C11_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S572C11_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C4_nt  : S572C5_nt {
  int s572c4f0[2];
  void *s572c4f1;
  int s572c4f2[2];
  ::S572C7_nt s572c4f3;
  ::S572C7_nt s572c4f4;
  ::S572C11_nt s572c4f5;
  ::S572C7_nt s572c4f6;
  unsigned int s572c4f7:1;
  unsigned int s572c4f8:1;
  unsigned int s572c4f9:1;
  unsigned int s572c4f10:1;
  unsigned int s572c4f11:1;
  int s572c4f12[2];
  virtual  ~S572C4_nt(); // _ZN9S572C4_ntD1Ev
  virtual void  v68(); // _ZN9S572C4_nt3v68Ev
  virtual void  v69(); // _ZN9S572C4_nt3v69Ev
  virtual void  v70(); // _ZN9S572C4_nt3v70Ev
  virtual void  v71(); // _ZN9S572C4_nt3v71Ev
  virtual void  v72(); // _ZN9S572C4_nt3v72Ev
  virtual void  v73(); // _ZN9S572C4_nt3v73Ev
  virtual void  v74(); // _ZN9S572C4_nt3v74Ev
  virtual void  v75(); // _ZN9S572C4_nt3v75Ev
  virtual void  v76(); // _ZN9S572C4_nt3v76Ev
  virtual void  v77(); // _ZN9S572C4_nt3v77Ev
  virtual void  v78(); // _ZN9S572C4_nt3v78Ev
  virtual void  v79(); // _ZN9S572C4_nt3v79Ev
  virtual void  v80(); // _ZN9S572C4_nt3v80Ev
  virtual void  v81(); // _ZN9S572C4_nt3v81Ev
  virtual void  v82(); // _ZN9S572C4_nt3v82Ev
  virtual void  v83(); // _ZN9S572C4_nt3v83Ev
  virtual void  v84(); // _ZN9S572C4_nt3v84Ev
  virtual void  v85(); // _ZN9S572C4_nt3v85Ev
  virtual void  v86(); // _ZN9S572C4_nt3v86Ev
  virtual void  v87(); // _ZN9S572C4_nt3v87Ev
  virtual void  v88(); // _ZN9S572C4_nt3v88Ev
  virtual void  v89(); // _ZN9S572C4_nt3v89Ev
  S572C4_nt(); // tgen
};
//SIG(-1 S572C4_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S572C4_nt ::~S572C4_nt(){ note_dtor("S572C4_nt", this);}
void  S572C4_nt ::v68(){vfunc_called(this, "_ZN9S572C4_nt3v68Ev");}
void  S572C4_nt ::v69(){vfunc_called(this, "_ZN9S572C4_nt3v69Ev");}
void  S572C4_nt ::v70(){vfunc_called(this, "_ZN9S572C4_nt3v70Ev");}
void  S572C4_nt ::v71(){vfunc_called(this, "_ZN9S572C4_nt3v71Ev");}
void  S572C4_nt ::v72(){vfunc_called(this, "_ZN9S572C4_nt3v72Ev");}
void  S572C4_nt ::v73(){vfunc_called(this, "_ZN9S572C4_nt3v73Ev");}
void  S572C4_nt ::v74(){vfunc_called(this, "_ZN9S572C4_nt3v74Ev");}
void  S572C4_nt ::v75(){vfunc_called(this, "_ZN9S572C4_nt3v75Ev");}
void  S572C4_nt ::v76(){vfunc_called(this, "_ZN9S572C4_nt3v76Ev");}
void  S572C4_nt ::v77(){vfunc_called(this, "_ZN9S572C4_nt3v77Ev");}
void  S572C4_nt ::v78(){vfunc_called(this, "_ZN9S572C4_nt3v78Ev");}
void  S572C4_nt ::v79(){vfunc_called(this, "_ZN9S572C4_nt3v79Ev");}
void  S572C4_nt ::v80(){vfunc_called(this, "_ZN9S572C4_nt3v80Ev");}
void  S572C4_nt ::v81(){vfunc_called(this, "_ZN9S572C4_nt3v81Ev");}
void  S572C4_nt ::v82(){vfunc_called(this, "_ZN9S572C4_nt3v82Ev");}
void  S572C4_nt ::v83(){vfunc_called(this, "_ZN9S572C4_nt3v83Ev");}
void  S572C4_nt ::v84(){vfunc_called(this, "_ZN9S572C4_nt3v84Ev");}
void  S572C4_nt ::v85(){vfunc_called(this, "_ZN9S572C4_nt3v85Ev");}
void  S572C4_nt ::v86(){vfunc_called(this, "_ZN9S572C4_nt3v86Ev");}
void  S572C4_nt ::v87(){vfunc_called(this, "_ZN9S572C4_nt3v87Ev");}
void  S572C4_nt ::v88(){vfunc_called(this, "_ZN9S572C4_nt3v88Ev");}
void  S572C4_nt ::v89(){vfunc_called(this, "_ZN9S572C4_nt3v89Ev");}
S572C4_nt ::S572C4_nt(){ note_ctor("S572C4_nt", this);} // tgen

//skip512 S572C4_nt

#else // __cplusplus

extern void _ZN9S572C4_ntC1Ev();
extern void _ZN9S572C4_ntD1Ev();
Name_Map name_map_S572C4_nt[] = {
  NSPAIR(_ZN9S572C4_ntC1Ev),
  NSPAIR(_ZN9S572C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S572C5_nt;
extern VTBL_ENTRY _ZTI9S572C5_nt[];
extern  VTBL_ENTRY _ZTV9S572C5_nt[];
static Base_Class bases_S572C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S572C4_nt[];
extern void _ZN9S572C4_ntD1Ev();
extern void _ZN9S572C4_ntD0Ev();
extern void _ZN9S572C5_nt2v4Ev();
extern void _ZN9S572C5_nt2v5Ev();
extern void _ZN9S572C5_nt2v6Ev();
extern void _ZN9S572C5_nt2v7Ev();
extern void _ZN9S572C5_nt2v8Ev();
extern void _ZN9S572C5_nt2v9Ev();
extern void _ZN9S572C5_nt3v10Ev();
extern void _ZN9S572C5_nt3v11Ev();
extern void _ZN9S572C5_nt3v12Ev();
extern void _ZN9S572C5_nt3v13Ev();
extern void _ZN9S572C5_nt3v14Ev();
extern void _ZN9S572C5_nt3v15Ev();
extern void _ZN9S572C5_nt3v16Ev();
extern void _ZN9S572C5_nt3v17Ev();
extern void _ZN9S572C5_nt3v18Ev();
extern void _ZN9S572C5_nt3v19Ev();
extern void _ZN9S572C5_nt3v20Ev();
extern void _ZN9S572C5_nt3v21Ev();
extern void _ZN9S572C5_nt3v22Ev();
extern void _ZN9S572C5_nt3v23Ev();
extern void _ZN9S572C5_nt3v24Ev();
extern void _ZN9S572C5_nt3v25Ev();
extern void _ZN9S572C5_nt3v26Ev();
extern void _ZN9S572C5_nt3v27Ev();
extern void _ZN9S572C5_nt3v28Ev();
extern void _ZN9S572C5_nt3v29Ev();
extern void _ZN9S572C5_nt3v30Ev();
extern void _ZN9S572C5_nt3v31Ev();
extern void _ZN9S572C5_nt3v32Ev();
extern void _ZN9S572C5_nt3v33Ev();
extern void _ZN9S572C5_nt3v34Ev();
extern void _ZN9S572C5_nt3v35Ev();
extern void _ZN9S572C5_nt3v36Ev();
extern void _ZN9S572C5_nt3v37Ev();
extern void _ZN9S572C5_nt3v38Ev();
extern void _ZN9S572C5_nt3v39Ev();
extern void _ZN9S572C5_nt3v40Ev();
extern void _ZN9S572C5_nt3v41Ev();
extern void _ZN9S572C5_nt3v42Ev();
extern void _ZN9S572C5_nt3v43Ev();
extern void _ZN9S572C5_nt3v44Ev();
extern void _ZN9S572C5_nt3v45Ev();
extern void _ZN9S572C5_nt3v46Ev();
extern void _ZN9S572C5_nt3v47Ev();
extern void _ZN9S572C5_nt3v48Ev();
extern void _ZN9S572C5_nt3v49Ev();
extern void _ZN9S572C5_nt3v50Ev();
extern void _ZN9S572C5_nt3v51Ev();
extern void _ZN9S572C5_nt3v52Ev();
extern void _ZN9S572C5_nt3v53Ev();
extern void _ZN9S572C5_nt3v54Ev();
extern void _ZN9S572C5_nt3v55Ev();
extern void _ZN9S572C5_nt3v56Ev();
extern void _ZN9S572C5_nt3v57Ev();
extern void _ZN9S572C5_nt3v58Ev();
extern void _ZN9S572C5_nt3v59Ev();
extern void _ZN9S572C5_nt3v60Ev();
extern void _ZN9S572C5_nt3v61Ev();
extern void _ZN9S572C5_nt3v62Ev();
extern void _ZN9S572C5_nt3v63Ev();
extern void _ZN9S572C5_nt3v64Ev();
extern void _ZN9S572C5_nt3v65Ev();
extern void _ZN9S572C5_nt3v66Ev();
extern void _ZN9S572C5_nt3v67Ev();
extern void _ZN9S572C4_nt3v68Ev();
extern void _ZN9S572C4_nt3v69Ev();
extern void _ZN9S572C4_nt3v70Ev();
extern void _ZN9S572C4_nt3v71Ev();
extern void _ZN9S572C4_nt3v72Ev();
extern void _ZN9S572C4_nt3v73Ev();
extern void _ZN9S572C4_nt3v74Ev();
extern void _ZN9S572C4_nt3v75Ev();
extern void _ZN9S572C4_nt3v76Ev();
extern void _ZN9S572C4_nt3v77Ev();
extern void _ZN9S572C4_nt3v78Ev();
extern void _ZN9S572C4_nt3v79Ev();
extern void _ZN9S572C4_nt3v80Ev();
extern void _ZN9S572C4_nt3v81Ev();
extern void _ZN9S572C4_nt3v82Ev();
extern void _ZN9S572C4_nt3v83Ev();
extern void _ZN9S572C4_nt3v84Ev();
extern void _ZN9S572C4_nt3v85Ev();
extern void _ZN9S572C4_nt3v86Ev();
extern void _ZN9S572C4_nt3v87Ev();
extern void _ZN9S572C4_nt3v88Ev();
extern void _ZN9S572C4_nt3v89Ev();
static  VTBL_ENTRY vtc_S572C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S572C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S572C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S572C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v89Ev,
};
extern VTBL_ENTRY _ZTI9S572C4_nt[];
VTBL_ENTRY *P__ZTI9S572C4_nt = _ZTI9S572C4_nt; 
extern  VTBL_ENTRY _ZTV9S572C4_nt[];
Class_Descriptor cd_S572C4_nt = {  "S572C4_nt", // class name
  bases_S572C4_nt, 1,
  &(vtc_S572C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI9S572C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S572C4_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C13  : S572C10_nt {
};
//SIG(-1 S572C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S572C13()
{
  extern Class_Descriptor cd_S572C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S572C13, buf);
    S572C13 &lv = *(new (buf) S572C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S572C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S572C13)");
    check_base_class_offset(lv, (S572C10_nt*), 0, "S572C13");
    test_class_info(&lv, &cd_S572C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS572C13(Test_S572C13, "S572C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S572C10_nt;
static Base_Class bases_S572C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S572C13 = {  "S572C13", // class name
  bases_S572C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C12  : S572C13 {
};
//SIG(-1 S572C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S572C12()
{
  extern Class_Descriptor cd_S572C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S572C12, buf);
    S572C12 &lv = *(new (buf) S572C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S572C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S572C12)");
    check_base_class_offset(lv, (S572C10_nt*)(S572C13*), 0, "S572C12");
    check_base_class_offset(lv, (S572C13*), 0, "S572C12");
    test_class_info(&lv, &cd_S572C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS572C12(Test_S572C12, "S572C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S572C10_nt;
extern Class_Descriptor cd_S572C13;
static Base_Class bases_S572C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S572C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S572C12 = {  "S572C12", // class name
  bases_S572C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C17  : S572C10_nt {
};
//SIG(-1 S572C17) C1{ BC2{ m Fp Fi[2]}}



static void Test_S572C17()
{
  extern Class_Descriptor cd_S572C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S572C17, buf);
    S572C17 &lv = *(new (buf) S572C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S572C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S572C17)");
    check_base_class_offset(lv, (S572C10_nt*), 0, "S572C17");
    test_class_info(&lv, &cd_S572C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS572C17(Test_S572C17, "S572C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S572C10_nt;
static Base_Class bases_S572C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S572C17 = {  "S572C17", // class name
  bases_S572C17, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C16  : S572C17 {
};
//SIG(-1 S572C16) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S572C16()
{
  extern Class_Descriptor cd_S572C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S572C16, buf);
    S572C16 &lv = *(new (buf) S572C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S572C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S572C16)");
    check_base_class_offset(lv, (S572C10_nt*)(S572C17*), 0, "S572C16");
    check_base_class_offset(lv, (S572C17*), 0, "S572C16");
    test_class_info(&lv, &cd_S572C16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS572C16(Test_S572C16, "S572C16", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S572C10_nt;
extern Class_Descriptor cd_S572C17;
static Base_Class bases_S572C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S572C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S572C16 = {  "S572C16", // class name
  bases_S572C16, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C3_nt  : S572C4_nt {
  unsigned int s572c3f0:1;
  unsigned int s572c3f1:1;
  unsigned int s572c3f2:1;
  ::S572C12 s572c3f3;
  ::S572C12 s572c3f4;
  ::S572C16 s572c3f5;
  ::S572C16 s572c3f6;
  int s572c3f7[3];
  virtual  ~S572C3_nt(); // _ZN9S572C3_ntD1Ev
  virtual void  v90(); // _ZN9S572C3_nt3v90Ev
  virtual void  v91(); // _ZN9S572C3_nt3v91Ev
  virtual void  v92(); // _ZN9S572C3_nt3v92Ev
  virtual void  v93(); // _ZN9S572C3_nt3v93Ev
  virtual void  v94(); // _ZN9S572C3_nt3v94Ev
  virtual void  v95(); // _ZN9S572C3_nt3v95Ev
  virtual void  v96(); // _ZN9S572C3_nt3v96Ev
  virtual void  v97(); // _ZN9S572C3_nt3v97Ev
  virtual void  v98(); // _ZN9S572C3_nt3v98Ev
  virtual void  v99(); // _ZN9S572C3_nt3v99Ev
  virtual void  v100(); // _ZN9S572C3_nt4v100Ev
  virtual void  v101(); // _ZN9S572C3_nt4v101Ev
  virtual void  v102(); // _ZN9S572C3_nt4v102Ev
  virtual void  v103(); // _ZN9S572C3_nt4v103Ev
  virtual void  v104(); // _ZN9S572C3_nt4v104Ev
  virtual void  v105(); // _ZN9S572C3_nt4v105Ev
  virtual void  v106(); // _ZN9S572C3_nt4v106Ev
  virtual void  v107(); // _ZN9S572C3_nt4v107Ev
  virtual void  v108(); // _ZN9S572C3_nt4v108Ev
  virtual void  v109(); // _ZN9S572C3_nt4v109Ev
  S572C3_nt(); // tgen
};
//SIG(-1 S572C3_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC10 FC12{ BC13{ BC8}} FC12 Fi[3]}


 S572C3_nt ::~S572C3_nt(){ note_dtor("S572C3_nt", this);}
void  S572C3_nt ::v90(){vfunc_called(this, "_ZN9S572C3_nt3v90Ev");}
void  S572C3_nt ::v91(){vfunc_called(this, "_ZN9S572C3_nt3v91Ev");}
void  S572C3_nt ::v92(){vfunc_called(this, "_ZN9S572C3_nt3v92Ev");}
void  S572C3_nt ::v93(){vfunc_called(this, "_ZN9S572C3_nt3v93Ev");}
void  S572C3_nt ::v94(){vfunc_called(this, "_ZN9S572C3_nt3v94Ev");}
void  S572C3_nt ::v95(){vfunc_called(this, "_ZN9S572C3_nt3v95Ev");}
void  S572C3_nt ::v96(){vfunc_called(this, "_ZN9S572C3_nt3v96Ev");}
void  S572C3_nt ::v97(){vfunc_called(this, "_ZN9S572C3_nt3v97Ev");}
void  S572C3_nt ::v98(){vfunc_called(this, "_ZN9S572C3_nt3v98Ev");}
void  S572C3_nt ::v99(){vfunc_called(this, "_ZN9S572C3_nt3v99Ev");}
void  S572C3_nt ::v100(){vfunc_called(this, "_ZN9S572C3_nt4v100Ev");}
void  S572C3_nt ::v101(){vfunc_called(this, "_ZN9S572C3_nt4v101Ev");}
void  S572C3_nt ::v102(){vfunc_called(this, "_ZN9S572C3_nt4v102Ev");}
void  S572C3_nt ::v103(){vfunc_called(this, "_ZN9S572C3_nt4v103Ev");}
void  S572C3_nt ::v104(){vfunc_called(this, "_ZN9S572C3_nt4v104Ev");}
void  S572C3_nt ::v105(){vfunc_called(this, "_ZN9S572C3_nt4v105Ev");}
void  S572C3_nt ::v106(){vfunc_called(this, "_ZN9S572C3_nt4v106Ev");}
void  S572C3_nt ::v107(){vfunc_called(this, "_ZN9S572C3_nt4v107Ev");}
void  S572C3_nt ::v108(){vfunc_called(this, "_ZN9S572C3_nt4v108Ev");}
void  S572C3_nt ::v109(){vfunc_called(this, "_ZN9S572C3_nt4v109Ev");}
S572C3_nt ::S572C3_nt(){ note_ctor("S572C3_nt", this);} // tgen

//skip512 S572C3_nt

#else // __cplusplus

extern void _ZN9S572C3_ntC1Ev();
extern void _ZN9S572C3_ntD1Ev();
Name_Map name_map_S572C3_nt[] = {
  NSPAIR(_ZN9S572C3_ntC1Ev),
  NSPAIR(_ZN9S572C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S572C5_nt;
extern VTBL_ENTRY _ZTI9S572C5_nt[];
extern  VTBL_ENTRY _ZTV9S572C5_nt[];
extern Class_Descriptor cd_S572C4_nt;
extern VTBL_ENTRY _ZTI9S572C4_nt[];
extern  VTBL_ENTRY _ZTV9S572C4_nt[];
static Base_Class bases_S572C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S572C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S572C3_nt[];
extern void _ZN9S572C3_ntD1Ev();
extern void _ZN9S572C3_ntD0Ev();
extern void _ZN9S572C5_nt2v4Ev();
extern void _ZN9S572C5_nt2v5Ev();
extern void _ZN9S572C5_nt2v6Ev();
extern void _ZN9S572C5_nt2v7Ev();
extern void _ZN9S572C5_nt2v8Ev();
extern void _ZN9S572C5_nt2v9Ev();
extern void _ZN9S572C5_nt3v10Ev();
extern void _ZN9S572C5_nt3v11Ev();
extern void _ZN9S572C5_nt3v12Ev();
extern void _ZN9S572C5_nt3v13Ev();
extern void _ZN9S572C5_nt3v14Ev();
extern void _ZN9S572C5_nt3v15Ev();
extern void _ZN9S572C5_nt3v16Ev();
extern void _ZN9S572C5_nt3v17Ev();
extern void _ZN9S572C5_nt3v18Ev();
extern void _ZN9S572C5_nt3v19Ev();
extern void _ZN9S572C5_nt3v20Ev();
extern void _ZN9S572C5_nt3v21Ev();
extern void _ZN9S572C5_nt3v22Ev();
extern void _ZN9S572C5_nt3v23Ev();
extern void _ZN9S572C5_nt3v24Ev();
extern void _ZN9S572C5_nt3v25Ev();
extern void _ZN9S572C5_nt3v26Ev();
extern void _ZN9S572C5_nt3v27Ev();
extern void _ZN9S572C5_nt3v28Ev();
extern void _ZN9S572C5_nt3v29Ev();
extern void _ZN9S572C5_nt3v30Ev();
extern void _ZN9S572C5_nt3v31Ev();
extern void _ZN9S572C5_nt3v32Ev();
extern void _ZN9S572C5_nt3v33Ev();
extern void _ZN9S572C5_nt3v34Ev();
extern void _ZN9S572C5_nt3v35Ev();
extern void _ZN9S572C5_nt3v36Ev();
extern void _ZN9S572C5_nt3v37Ev();
extern void _ZN9S572C5_nt3v38Ev();
extern void _ZN9S572C5_nt3v39Ev();
extern void _ZN9S572C5_nt3v40Ev();
extern void _ZN9S572C5_nt3v41Ev();
extern void _ZN9S572C5_nt3v42Ev();
extern void _ZN9S572C5_nt3v43Ev();
extern void _ZN9S572C5_nt3v44Ev();
extern void _ZN9S572C5_nt3v45Ev();
extern void _ZN9S572C5_nt3v46Ev();
extern void _ZN9S572C5_nt3v47Ev();
extern void _ZN9S572C5_nt3v48Ev();
extern void _ZN9S572C5_nt3v49Ev();
extern void _ZN9S572C5_nt3v50Ev();
extern void _ZN9S572C5_nt3v51Ev();
extern void _ZN9S572C5_nt3v52Ev();
extern void _ZN9S572C5_nt3v53Ev();
extern void _ZN9S572C5_nt3v54Ev();
extern void _ZN9S572C5_nt3v55Ev();
extern void _ZN9S572C5_nt3v56Ev();
extern void _ZN9S572C5_nt3v57Ev();
extern void _ZN9S572C5_nt3v58Ev();
extern void _ZN9S572C5_nt3v59Ev();
extern void _ZN9S572C5_nt3v60Ev();
extern void _ZN9S572C5_nt3v61Ev();
extern void _ZN9S572C5_nt3v62Ev();
extern void _ZN9S572C5_nt3v63Ev();
extern void _ZN9S572C5_nt3v64Ev();
extern void _ZN9S572C5_nt3v65Ev();
extern void _ZN9S572C5_nt3v66Ev();
extern void _ZN9S572C5_nt3v67Ev();
extern void _ZN9S572C4_nt3v68Ev();
extern void _ZN9S572C4_nt3v69Ev();
extern void _ZN9S572C4_nt3v70Ev();
extern void _ZN9S572C4_nt3v71Ev();
extern void _ZN9S572C4_nt3v72Ev();
extern void _ZN9S572C4_nt3v73Ev();
extern void _ZN9S572C4_nt3v74Ev();
extern void _ZN9S572C4_nt3v75Ev();
extern void _ZN9S572C4_nt3v76Ev();
extern void _ZN9S572C4_nt3v77Ev();
extern void _ZN9S572C4_nt3v78Ev();
extern void _ZN9S572C4_nt3v79Ev();
extern void _ZN9S572C4_nt3v80Ev();
extern void _ZN9S572C4_nt3v81Ev();
extern void _ZN9S572C4_nt3v82Ev();
extern void _ZN9S572C4_nt3v83Ev();
extern void _ZN9S572C4_nt3v84Ev();
extern void _ZN9S572C4_nt3v85Ev();
extern void _ZN9S572C4_nt3v86Ev();
extern void _ZN9S572C4_nt3v87Ev();
extern void _ZN9S572C4_nt3v88Ev();
extern void _ZN9S572C4_nt3v89Ev();
extern void _ZN9S572C3_nt3v90Ev();
extern void _ZN9S572C3_nt3v91Ev();
extern void _ZN9S572C3_nt3v92Ev();
extern void _ZN9S572C3_nt3v93Ev();
extern void _ZN9S572C3_nt3v94Ev();
extern void _ZN9S572C3_nt3v95Ev();
extern void _ZN9S572C3_nt3v96Ev();
extern void _ZN9S572C3_nt3v97Ev();
extern void _ZN9S572C3_nt3v98Ev();
extern void _ZN9S572C3_nt3v99Ev();
extern void _ZN9S572C3_nt4v100Ev();
extern void _ZN9S572C3_nt4v101Ev();
extern void _ZN9S572C3_nt4v102Ev();
extern void _ZN9S572C3_nt4v103Ev();
extern void _ZN9S572C3_nt4v104Ev();
extern void _ZN9S572C3_nt4v105Ev();
extern void _ZN9S572C3_nt4v106Ev();
extern void _ZN9S572C3_nt4v107Ev();
extern void _ZN9S572C3_nt4v108Ev();
extern void _ZN9S572C3_nt4v109Ev();
static  VTBL_ENTRY vtc_S572C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S572C3_nt[0]),
  (VTBL_ENTRY)&_ZN9S572C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S572C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v109Ev,
};
extern VTBL_ENTRY _ZTI9S572C3_nt[];
VTBL_ENTRY *P__ZTI9S572C3_nt = _ZTI9S572C3_nt; 
extern  VTBL_ENTRY _ZTV9S572C3_nt[];
Class_Descriptor cd_S572C3_nt = {  "S572C3_nt", // class name
  bases_S572C3_nt, 2,
  &(vtc_S572C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI9S572C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S572C3_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C21  : S572C10_nt {
};
//SIG(-1 S572C21) C1{ BC2{ m Fp Fi[2]}}



static void Test_S572C21()
{
  extern Class_Descriptor cd_S572C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S572C21, buf);
    S572C21 &lv = *(new (buf) S572C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S572C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S572C21)");
    check_base_class_offset(lv, (S572C10_nt*), 0, "S572C21");
    test_class_info(&lv, &cd_S572C21);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS572C21(Test_S572C21, "S572C21", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S572C10_nt;
static Base_Class bases_S572C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S572C21 = {  "S572C21", // class name
  bases_S572C21, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C20  : S572C21 {
};
//SIG(-1 S572C20) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S572C20()
{
  extern Class_Descriptor cd_S572C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S572C20, buf);
    S572C20 &lv = *(new (buf) S572C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S572C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S572C20)");
    check_base_class_offset(lv, (S572C10_nt*)(S572C21*), 0, "S572C20");
    check_base_class_offset(lv, (S572C21*), 0, "S572C20");
    test_class_info(&lv, &cd_S572C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS572C20(Test_S572C20, "S572C20", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S572C10_nt;
extern Class_Descriptor cd_S572C21;
static Base_Class bases_S572C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S572C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S572C20 = {  "S572C20", // class name
  bases_S572C20, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C2_nt  : S572C3_nt {
  ::S4658C32_nt s572c2f0;
  unsigned int s572c2f1:1;
  ::S572C20 s572c2f2;
  virtual  ~S572C2_nt(); // _ZN9S572C2_ntD1Ev
  virtual void  v110(); // _ZN9S572C2_nt4v110Ev
  virtual void  v111(); // _ZN9S572C2_nt4v111Ev
  virtual void  v112(); // _ZN9S572C2_nt4v112Ev
  virtual void  v113(); // _ZN9S572C2_nt4v113Ev
  S572C2_nt(); // tgen
};
//SIG(-1 S572C2_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC11 FC13{ BC14{ BC9}} FC13 Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC15{ BC16{ BC9}}}


 S572C2_nt ::~S572C2_nt(){ note_dtor("S572C2_nt", this);}
void  S572C2_nt ::v110(){vfunc_called(this, "_ZN9S572C2_nt4v110Ev");}
void  S572C2_nt ::v111(){vfunc_called(this, "_ZN9S572C2_nt4v111Ev");}
void  S572C2_nt ::v112(){vfunc_called(this, "_ZN9S572C2_nt4v112Ev");}
void  S572C2_nt ::v113(){vfunc_called(this, "_ZN9S572C2_nt4v113Ev");}
S572C2_nt ::S572C2_nt(){ note_ctor("S572C2_nt", this);} // tgen

//skip512 S572C2_nt

#else // __cplusplus

extern void _ZN9S572C2_ntC1Ev();
extern void _ZN9S572C2_ntD1Ev();
Name_Map name_map_S572C2_nt[] = {
  NSPAIR(_ZN9S572C2_ntC1Ev),
  NSPAIR(_ZN9S572C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S572C5_nt;
extern VTBL_ENTRY _ZTI9S572C5_nt[];
extern  VTBL_ENTRY _ZTV9S572C5_nt[];
extern Class_Descriptor cd_S572C4_nt;
extern VTBL_ENTRY _ZTI9S572C4_nt[];
extern  VTBL_ENTRY _ZTV9S572C4_nt[];
extern Class_Descriptor cd_S572C3_nt;
extern VTBL_ENTRY _ZTI9S572C3_nt[];
extern  VTBL_ENTRY _ZTV9S572C3_nt[];
static Base_Class bases_S572C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S572C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S572C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S572C2_nt[];
extern void _ZN9S572C2_ntD1Ev();
extern void _ZN9S572C2_ntD0Ev();
extern void _ZN9S572C5_nt2v4Ev();
extern void _ZN9S572C5_nt2v5Ev();
extern void _ZN9S572C5_nt2v6Ev();
extern void _ZN9S572C5_nt2v7Ev();
extern void _ZN9S572C5_nt2v8Ev();
extern void _ZN9S572C5_nt2v9Ev();
extern void _ZN9S572C5_nt3v10Ev();
extern void _ZN9S572C5_nt3v11Ev();
extern void _ZN9S572C5_nt3v12Ev();
extern void _ZN9S572C5_nt3v13Ev();
extern void _ZN9S572C5_nt3v14Ev();
extern void _ZN9S572C5_nt3v15Ev();
extern void _ZN9S572C5_nt3v16Ev();
extern void _ZN9S572C5_nt3v17Ev();
extern void _ZN9S572C5_nt3v18Ev();
extern void _ZN9S572C5_nt3v19Ev();
extern void _ZN9S572C5_nt3v20Ev();
extern void _ZN9S572C5_nt3v21Ev();
extern void _ZN9S572C5_nt3v22Ev();
extern void _ZN9S572C5_nt3v23Ev();
extern void _ZN9S572C5_nt3v24Ev();
extern void _ZN9S572C5_nt3v25Ev();
extern void _ZN9S572C5_nt3v26Ev();
extern void _ZN9S572C5_nt3v27Ev();
extern void _ZN9S572C5_nt3v28Ev();
extern void _ZN9S572C5_nt3v29Ev();
extern void _ZN9S572C5_nt3v30Ev();
extern void _ZN9S572C5_nt3v31Ev();
extern void _ZN9S572C5_nt3v32Ev();
extern void _ZN9S572C5_nt3v33Ev();
extern void _ZN9S572C5_nt3v34Ev();
extern void _ZN9S572C5_nt3v35Ev();
extern void _ZN9S572C5_nt3v36Ev();
extern void _ZN9S572C5_nt3v37Ev();
extern void _ZN9S572C5_nt3v38Ev();
extern void _ZN9S572C5_nt3v39Ev();
extern void _ZN9S572C5_nt3v40Ev();
extern void _ZN9S572C5_nt3v41Ev();
extern void _ZN9S572C5_nt3v42Ev();
extern void _ZN9S572C5_nt3v43Ev();
extern void _ZN9S572C5_nt3v44Ev();
extern void _ZN9S572C5_nt3v45Ev();
extern void _ZN9S572C5_nt3v46Ev();
extern void _ZN9S572C5_nt3v47Ev();
extern void _ZN9S572C5_nt3v48Ev();
extern void _ZN9S572C5_nt3v49Ev();
extern void _ZN9S572C5_nt3v50Ev();
extern void _ZN9S572C5_nt3v51Ev();
extern void _ZN9S572C5_nt3v52Ev();
extern void _ZN9S572C5_nt3v53Ev();
extern void _ZN9S572C5_nt3v54Ev();
extern void _ZN9S572C5_nt3v55Ev();
extern void _ZN9S572C5_nt3v56Ev();
extern void _ZN9S572C5_nt3v57Ev();
extern void _ZN9S572C5_nt3v58Ev();
extern void _ZN9S572C5_nt3v59Ev();
extern void _ZN9S572C5_nt3v60Ev();
extern void _ZN9S572C5_nt3v61Ev();
extern void _ZN9S572C5_nt3v62Ev();
extern void _ZN9S572C5_nt3v63Ev();
extern void _ZN9S572C5_nt3v64Ev();
extern void _ZN9S572C5_nt3v65Ev();
extern void _ZN9S572C5_nt3v66Ev();
extern void _ZN9S572C5_nt3v67Ev();
extern void _ZN9S572C4_nt3v68Ev();
extern void _ZN9S572C4_nt3v69Ev();
extern void _ZN9S572C4_nt3v70Ev();
extern void _ZN9S572C4_nt3v71Ev();
extern void _ZN9S572C4_nt3v72Ev();
extern void _ZN9S572C4_nt3v73Ev();
extern void _ZN9S572C4_nt3v74Ev();
extern void _ZN9S572C4_nt3v75Ev();
extern void _ZN9S572C4_nt3v76Ev();
extern void _ZN9S572C4_nt3v77Ev();
extern void _ZN9S572C4_nt3v78Ev();
extern void _ZN9S572C4_nt3v79Ev();
extern void _ZN9S572C4_nt3v80Ev();
extern void _ZN9S572C4_nt3v81Ev();
extern void _ZN9S572C4_nt3v82Ev();
extern void _ZN9S572C4_nt3v83Ev();
extern void _ZN9S572C4_nt3v84Ev();
extern void _ZN9S572C4_nt3v85Ev();
extern void _ZN9S572C4_nt3v86Ev();
extern void _ZN9S572C4_nt3v87Ev();
extern void _ZN9S572C4_nt3v88Ev();
extern void _ZN9S572C4_nt3v89Ev();
extern void _ZN9S572C3_nt3v90Ev();
extern void _ZN9S572C3_nt3v91Ev();
extern void _ZN9S572C3_nt3v92Ev();
extern void _ZN9S572C3_nt3v93Ev();
extern void _ZN9S572C3_nt3v94Ev();
extern void _ZN9S572C3_nt3v95Ev();
extern void _ZN9S572C3_nt3v96Ev();
extern void _ZN9S572C3_nt3v97Ev();
extern void _ZN9S572C3_nt3v98Ev();
extern void _ZN9S572C3_nt3v99Ev();
extern void _ZN9S572C3_nt4v100Ev();
extern void _ZN9S572C3_nt4v101Ev();
extern void _ZN9S572C3_nt4v102Ev();
extern void _ZN9S572C3_nt4v103Ev();
extern void _ZN9S572C3_nt4v104Ev();
extern void _ZN9S572C3_nt4v105Ev();
extern void _ZN9S572C3_nt4v106Ev();
extern void _ZN9S572C3_nt4v107Ev();
extern void _ZN9S572C3_nt4v108Ev();
extern void _ZN9S572C3_nt4v109Ev();
extern void _ZN9S572C2_nt4v110Ev();
extern void _ZN9S572C2_nt4v111Ev();
extern void _ZN9S572C2_nt4v112Ev();
extern void _ZN9S572C2_nt4v113Ev();
static  VTBL_ENTRY vtc_S572C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S572C2_nt[0]),
  (VTBL_ENTRY)&_ZN9S572C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S572C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S572C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S572C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S572C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S572C2_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI9S572C2_nt[];
VTBL_ENTRY *P__ZTI9S572C2_nt = _ZTI9S572C2_nt; 
extern  VTBL_ENTRY _ZTV9S572C2_nt[];
Class_Descriptor cd_S572C2_nt = {  "S572C2_nt", // class name
  bases_S572C2_nt, 3,
  &(vtc_S572C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI9S572C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S572C2_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S572C1  : S572C2_nt {
  ::S4658C32_nt s572c1f0;
  virtual  ~S572C1(); // _ZN6S572C1D1Ev
  virtual void  v1(); // _ZN6S572C12v1Ev
  virtual void  v2(); // _ZN6S572C12v2Ev
  virtual void  v3(); // _ZN6S572C12v3Ev
  S572C1(); // tgen
};
//SIG(1 S572C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC12 FC14{ BC15{ BC10}} FC14 Fi[3]} vd v110 v111 v112 v113 FC6 Fi:1 FC16{ BC17{ BC10}}} vd v1 v2 v3 FC6}


 S572C1 ::~S572C1(){ note_dtor("S572C1", this);}
void  S572C1 ::v1(){vfunc_called(this, "_ZN6S572C12v1Ev");}
void  S572C1 ::v2(){vfunc_called(this, "_ZN6S572C12v2Ev");}
void  S572C1 ::v3(){vfunc_called(this, "_ZN6S572C12v3Ev");}
S572C1 ::S572C1(){ note_ctor("S572C1", this);} // tgen

static void Test_S572C1()
{
  extern Class_Descriptor cd_S572C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,58)];
    init_test(&cd_S572C1, buf);
    S572C1 *dp, &lv = *(dp=new (buf) S572C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,228), "sizeof(S572C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S572C1)");
    check_base_class_offset(lv, (S572C5_nt*)(S572C4_nt*)(S572C3_nt*)(S572C2_nt*), 0, "S572C1");
    check_base_class_offset(lv, (S572C4_nt*)(S572C3_nt*)(S572C2_nt*), 0, "S572C1");
    check_base_class_offset(lv, (S572C3_nt*)(S572C2_nt*), 0, "S572C1");
    check_base_class_offset(lv, (S572C2_nt*), 0, "S572C1");
    check_field_offset(lv, s572c1f0, ABISELECT(296,220), "S572C1.s572c1f0");
    test_class_info(&lv, &cd_S572C1);
    dp->~S572C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS572C1(Test_S572C1, "S572C1", ABISELECT(304,228));

#else // __cplusplus

extern void _ZN6S572C1C1Ev();
extern void _ZN6S572C1D1Ev();
Name_Map name_map_S572C1[] = {
  NSPAIR(_ZN6S572C1C1Ev),
  NSPAIR(_ZN6S572C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S572C5_nt;
extern VTBL_ENTRY _ZTI9S572C5_nt[];
extern  VTBL_ENTRY _ZTV9S572C5_nt[];
extern Class_Descriptor cd_S572C4_nt;
extern VTBL_ENTRY _ZTI9S572C4_nt[];
extern  VTBL_ENTRY _ZTV9S572C4_nt[];
extern Class_Descriptor cd_S572C3_nt;
extern VTBL_ENTRY _ZTI9S572C3_nt[];
extern  VTBL_ENTRY _ZTV9S572C3_nt[];
extern Class_Descriptor cd_S572C2_nt;
extern VTBL_ENTRY _ZTI9S572C2_nt[];
extern  VTBL_ENTRY _ZTV9S572C2_nt[];
static Base_Class bases_S572C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S572C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S572C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S572C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S572C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S572C1[];
extern void _ZN6S572C1D1Ev();
extern void _ZN6S572C1D0Ev();
extern void _ZN9S572C5_nt2v4Ev();
extern void _ZN9S572C5_nt2v5Ev();
extern void _ZN9S572C5_nt2v6Ev();
extern void _ZN9S572C5_nt2v7Ev();
extern void _ZN9S572C5_nt2v8Ev();
extern void _ZN9S572C5_nt2v9Ev();
extern void _ZN9S572C5_nt3v10Ev();
extern void _ZN9S572C5_nt3v11Ev();
extern void _ZN9S572C5_nt3v12Ev();
extern void _ZN9S572C5_nt3v13Ev();
extern void _ZN9S572C5_nt3v14Ev();
extern void _ZN9S572C5_nt3v15Ev();
extern void _ZN9S572C5_nt3v16Ev();
extern void _ZN9S572C5_nt3v17Ev();
extern void _ZN9S572C5_nt3v18Ev();
extern void _ZN9S572C5_nt3v19Ev();
extern void _ZN9S572C5_nt3v20Ev();
extern void _ZN9S572C5_nt3v21Ev();
extern void _ZN9S572C5_nt3v22Ev();
extern void _ZN9S572C5_nt3v23Ev();
extern void _ZN9S572C5_nt3v24Ev();
extern void _ZN9S572C5_nt3v25Ev();
extern void _ZN9S572C5_nt3v26Ev();
extern void _ZN9S572C5_nt3v27Ev();
extern void _ZN9S572C5_nt3v28Ev();
extern void _ZN9S572C5_nt3v29Ev();
extern void _ZN9S572C5_nt3v30Ev();
extern void _ZN9S572C5_nt3v31Ev();
extern void _ZN9S572C5_nt3v32Ev();
extern void _ZN9S572C5_nt3v33Ev();
extern void _ZN9S572C5_nt3v34Ev();
extern void _ZN9S572C5_nt3v35Ev();
extern void _ZN9S572C5_nt3v36Ev();
extern void _ZN9S572C5_nt3v37Ev();
extern void _ZN9S572C5_nt3v38Ev();
extern void _ZN9S572C5_nt3v39Ev();
extern void _ZN9S572C5_nt3v40Ev();
extern void _ZN9S572C5_nt3v41Ev();
extern void _ZN9S572C5_nt3v42Ev();
extern void _ZN9S572C5_nt3v43Ev();
extern void _ZN9S572C5_nt3v44Ev();
extern void _ZN9S572C5_nt3v45Ev();
extern void _ZN9S572C5_nt3v46Ev();
extern void _ZN9S572C5_nt3v47Ev();
extern void _ZN9S572C5_nt3v48Ev();
extern void _ZN9S572C5_nt3v49Ev();
extern void _ZN9S572C5_nt3v50Ev();
extern void _ZN9S572C5_nt3v51Ev();
extern void _ZN9S572C5_nt3v52Ev();
extern void _ZN9S572C5_nt3v53Ev();
extern void _ZN9S572C5_nt3v54Ev();
extern void _ZN9S572C5_nt3v55Ev();
extern void _ZN9S572C5_nt3v56Ev();
extern void _ZN9S572C5_nt3v57Ev();
extern void _ZN9S572C5_nt3v58Ev();
extern void _ZN9S572C5_nt3v59Ev();
extern void _ZN9S572C5_nt3v60Ev();
extern void _ZN9S572C5_nt3v61Ev();
extern void _ZN9S572C5_nt3v62Ev();
extern void _ZN9S572C5_nt3v63Ev();
extern void _ZN9S572C5_nt3v64Ev();
extern void _ZN9S572C5_nt3v65Ev();
extern void _ZN9S572C5_nt3v66Ev();
extern void _ZN9S572C5_nt3v67Ev();
extern void _ZN9S572C4_nt3v68Ev();
extern void _ZN9S572C4_nt3v69Ev();
extern void _ZN9S572C4_nt3v70Ev();
extern void _ZN9S572C4_nt3v71Ev();
extern void _ZN9S572C4_nt3v72Ev();
extern void _ZN9S572C4_nt3v73Ev();
extern void _ZN9S572C4_nt3v74Ev();
extern void _ZN9S572C4_nt3v75Ev();
extern void _ZN9S572C4_nt3v76Ev();
extern void _ZN9S572C4_nt3v77Ev();
extern void _ZN9S572C4_nt3v78Ev();
extern void _ZN9S572C4_nt3v79Ev();
extern void _ZN9S572C4_nt3v80Ev();
extern void _ZN9S572C4_nt3v81Ev();
extern void _ZN9S572C4_nt3v82Ev();
extern void _ZN9S572C4_nt3v83Ev();
extern void _ZN9S572C4_nt3v84Ev();
extern void _ZN9S572C4_nt3v85Ev();
extern void _ZN9S572C4_nt3v86Ev();
extern void _ZN9S572C4_nt3v87Ev();
extern void _ZN9S572C4_nt3v88Ev();
extern void _ZN9S572C4_nt3v89Ev();
extern void _ZN9S572C3_nt3v90Ev();
extern void _ZN9S572C3_nt3v91Ev();
extern void _ZN9S572C3_nt3v92Ev();
extern void _ZN9S572C3_nt3v93Ev();
extern void _ZN9S572C3_nt3v94Ev();
extern void _ZN9S572C3_nt3v95Ev();
extern void _ZN9S572C3_nt3v96Ev();
extern void _ZN9S572C3_nt3v97Ev();
extern void _ZN9S572C3_nt3v98Ev();
extern void _ZN9S572C3_nt3v99Ev();
extern void _ZN9S572C3_nt4v100Ev();
extern void _ZN9S572C3_nt4v101Ev();
extern void _ZN9S572C3_nt4v102Ev();
extern void _ZN9S572C3_nt4v103Ev();
extern void _ZN9S572C3_nt4v104Ev();
extern void _ZN9S572C3_nt4v105Ev();
extern void _ZN9S572C3_nt4v106Ev();
extern void _ZN9S572C3_nt4v107Ev();
extern void _ZN9S572C3_nt4v108Ev();
extern void _ZN9S572C3_nt4v109Ev();
extern void _ZN9S572C2_nt4v110Ev();
extern void _ZN9S572C2_nt4v111Ev();
extern void _ZN9S572C2_nt4v112Ev();
extern void _ZN9S572C2_nt4v113Ev();
extern void _ZN6S572C12v1Ev();
extern void _ZN6S572C12v2Ev();
extern void _ZN6S572C12v3Ev();
static  VTBL_ENTRY vtc_S572C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S572C1[0]),
  (VTBL_ENTRY)&_ZN6S572C1D1Ev,
  (VTBL_ENTRY)&_ZN6S572C1D0Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v4Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v5Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v6Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S572C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S572C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S572C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S572C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S572C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S572C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S572C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN6S572C12v1Ev,
  (VTBL_ENTRY)&_ZN6S572C12v2Ev,
  (VTBL_ENTRY)&_ZN6S572C12v3Ev,
};
extern VTBL_ENTRY _ZTI6S572C1[];
extern  VTBL_ENTRY _ZTV6S572C1[];
Class_Descriptor cd_S572C1 = {  "S572C1", // class name
  bases_S572C1, 4,
  &(vtc_S572C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI6S572C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S572C1),117, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1107C3  : S9509C16_nt {
};
//SIG(-1 S1107C3) C1{ BC2{ m Fi}}



static void Test_S1107C3()
{
  extern Class_Descriptor cd_S1107C3;
  void *lvp;
  {
    int buf[2];
    init_test(&cd_S1107C3, buf);
    S1107C3 &lv = *(new (buf) S1107C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(S1107C3)");
    check2(__alignof__(lv), 4, "__alignof__(S1107C3)");
    check_base_class_offset(lv, (S9509C16_nt*), 0, "S1107C3");
    test_class_info(&lv, &cd_S1107C3);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1107C3(Test_S1107C3, "S1107C3", 4);

#else // __cplusplus

extern Class_Descriptor cd_S9509C16_nt;
extern VTBL_ENTRY _ZTI11S9509C16_nt[];
static Base_Class bases_S1107C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9509C16_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1107C3[];
Class_Descriptor cd_S1107C3 = {  "S1107C3", // class name
  bases_S1107C3, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI7S1107C3),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1107C2  : S1107C3 {
  void *s1107c2f0[2];
  char s1107c2f1[2];
  ::S4658C31_nt s1107c2f2;
  virtual  ~S1107C2(); // _ZN7S1107C2D1Ev
  virtual void  v58(); // _ZN7S1107C23v58Ev
  virtual void  v59(); // _ZN7S1107C23v59Ev
  virtual void  v60(); // _ZN7S1107C23v60Ev
  virtual void  v61(); // _ZN7S1107C23v61Ev
  virtual void  v62(); // _ZN7S1107C23v62Ev
  virtual void  v63(); // _ZN7S1107C23v63Ev
  virtual void  v64(); // _ZN7S1107C23v64Ev
  virtual void  v65(); // _ZN7S1107C23v65Ev
  virtual void  v66(); // _ZN7S1107C23v66Ev
  virtual void  v67(); // _ZN7S1107C23v67Ev
  virtual void  v68(); // _ZN7S1107C23v68Ev
  virtual void  v69(); // _ZN7S1107C23v69Ev
  virtual void  v70(); // _ZN7S1107C23v70Ev
  virtual void  v71(); // _ZN7S1107C23v71Ev
  virtual void  v72(); // _ZN7S1107C23v72Ev
  virtual void  v73(); // _ZN7S1107C23v73Ev
  virtual void  v74(); // _ZN7S1107C23v74Ev
  virtual void  v75(); // _ZN7S1107C23v75Ev
  virtual void  v76(); // _ZN7S1107C23v76Ev
  virtual void  v77(); // _ZN7S1107C23v77Ev
  virtual void  v78(); // _ZN7S1107C23v78Ev
  virtual void  v79(); // _ZN7S1107C23v79Ev
  S1107C2(); // tgen
};
//SIG(-1 S1107C2) C1{ BC2{ BC3{ m Fi}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fc[2] FC4{ m FC5{ m Fi[2]} FC5}}


 S1107C2 ::~S1107C2(){ note_dtor("S1107C2", this);}
void  S1107C2 ::v58(){vfunc_called(this, "_ZN7S1107C23v58Ev");}
void  S1107C2 ::v59(){vfunc_called(this, "_ZN7S1107C23v59Ev");}
void  S1107C2 ::v60(){vfunc_called(this, "_ZN7S1107C23v60Ev");}
void  S1107C2 ::v61(){vfunc_called(this, "_ZN7S1107C23v61Ev");}
void  S1107C2 ::v62(){vfunc_called(this, "_ZN7S1107C23v62Ev");}
void  S1107C2 ::v63(){vfunc_called(this, "_ZN7S1107C23v63Ev");}
void  S1107C2 ::v64(){vfunc_called(this, "_ZN7S1107C23v64Ev");}
void  S1107C2 ::v65(){vfunc_called(this, "_ZN7S1107C23v65Ev");}
void  S1107C2 ::v66(){vfunc_called(this, "_ZN7S1107C23v66Ev");}
void  S1107C2 ::v67(){vfunc_called(this, "_ZN7S1107C23v67Ev");}
void  S1107C2 ::v68(){vfunc_called(this, "_ZN7S1107C23v68Ev");}
void  S1107C2 ::v69(){vfunc_called(this, "_ZN7S1107C23v69Ev");}
void  S1107C2 ::v70(){vfunc_called(this, "_ZN7S1107C23v70Ev");}
void  S1107C2 ::v71(){vfunc_called(this, "_ZN7S1107C23v71Ev");}
void  S1107C2 ::v72(){vfunc_called(this, "_ZN7S1107C23v72Ev");}
void  S1107C2 ::v73(){vfunc_called(this, "_ZN7S1107C23v73Ev");}
void  S1107C2 ::v74(){vfunc_called(this, "_ZN7S1107C23v74Ev");}
void  S1107C2 ::v75(){vfunc_called(this, "_ZN7S1107C23v75Ev");}
void  S1107C2 ::v76(){vfunc_called(this, "_ZN7S1107C23v76Ev");}
void  S1107C2 ::v77(){vfunc_called(this, "_ZN7S1107C23v77Ev");}
void  S1107C2 ::v78(){vfunc_called(this, "_ZN7S1107C23v78Ev");}
void  S1107C2 ::v79(){vfunc_called(this, "_ZN7S1107C23v79Ev");}
S1107C2 ::S1107C2(){ note_ctor("S1107C2", this);} // tgen

static void Test_S1107C2()
{
  extern Class_Descriptor cd_S1107C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,10)];
    init_test(&cd_S1107C2, buf);
    S1107C2 *dp, &lv = *(dp=new (buf) S1107C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,36), "sizeof(S1107C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1107C2)");
    check_base_class_offset(lv, (S9509C16_nt*)(S1107C3*), ABISELECT(8,4), "S1107C2");
    check_base_class_offset(lv, (S1107C3*), ABISELECT(8,4), "S1107C2");
    check_field_offset(lv, s1107c2f0, ABISELECT(16,8), "S1107C2.s1107c2f0");
    check_field_offset(lv, s1107c2f1, ABISELECT(32,16), "S1107C2.s1107c2f1");
    check_field_offset(lv, s1107c2f2, ABISELECT(36,20), "S1107C2.s1107c2f2");
    test_class_info(&lv, &cd_S1107C2);
    dp->~S1107C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1107C2(Test_S1107C2, "S1107C2", ABISELECT(56,36));

#else // __cplusplus

extern void _ZN7S1107C2C1Ev();
extern void _ZN7S1107C2D1Ev();
Name_Map name_map_S1107C2[] = {
  NSPAIR(_ZN7S1107C2C1Ev),
  NSPAIR(_ZN7S1107C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9509C16_nt;
extern VTBL_ENTRY _ZTI11S9509C16_nt[];
extern Class_Descriptor cd_S1107C3;
extern VTBL_ENTRY _ZTI7S1107C3[];
static Base_Class bases_S1107C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9509C16_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1107C3,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1107C2[];
extern void _ZN7S1107C2D1Ev();
extern void _ZN7S1107C2D0Ev();
extern void _ZN7S1107C23v58Ev();
extern void _ZN7S1107C23v59Ev();
extern void _ZN7S1107C23v60Ev();
extern void _ZN7S1107C23v61Ev();
extern void _ZN7S1107C23v62Ev();
extern void _ZN7S1107C23v63Ev();
extern void _ZN7S1107C23v64Ev();
extern void _ZN7S1107C23v65Ev();
extern void _ZN7S1107C23v66Ev();
extern void _ZN7S1107C23v67Ev();
extern void _ZN7S1107C23v68Ev();
extern void _ZN7S1107C23v69Ev();
extern void _ZN7S1107C23v70Ev();
extern void _ZN7S1107C23v71Ev();
extern void _ZN7S1107C23v72Ev();
extern void _ZN7S1107C23v73Ev();
extern void _ZN7S1107C23v74Ev();
extern void _ZN7S1107C23v75Ev();
extern void _ZN7S1107C23v76Ev();
extern void _ZN7S1107C23v77Ev();
extern void _ZN7S1107C23v78Ev();
extern void _ZN7S1107C23v79Ev();
static  VTBL_ENTRY vtc_S1107C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1107C2[0]),
  (VTBL_ENTRY)&_ZN7S1107C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1107C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v58Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v59Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v60Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v61Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v62Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v63Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v64Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v65Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v66Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v67Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v68Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v69Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v70Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v71Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v72Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v73Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v74Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v75Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v76Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v77Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v78Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v79Ev,
};
extern VTBL_ENTRY _ZTI7S1107C2[];
extern  VTBL_ENTRY _ZTV7S1107C2[];
Class_Descriptor cd_S1107C2 = {  "S1107C2", // class name
  bases_S1107C2, 2,
  &(vtc_S1107C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,36), // object size
  NSPAIRA(_ZTI7S1107C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S1107C2),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1107C8  {
  ::S15308C230 s1107c8f0;
  unsigned int s1107c8f1:1;
  unsigned int s1107c8f2:1;
  int s1107c8f3:2;
  int s1107c8f4:2;
  int s1107c8f5:2;
  unsigned int s1107c8f6:1;
  ::S4658C32_nt s1107c8f7;
  virtual  ~S1107C8(); // _ZN7S1107C8D1Ev
  virtual void  v80(); // _ZN7S1107C83v80Ev
  virtual void  v81(); // _ZN7S1107C83v81Ev
  virtual void  v82(); // _ZN7S1107C83v82Ev
  virtual void  v83(); // _ZN7S1107C83v83Ev
  virtual void  v84(); // _ZN7S1107C83v84Ev
  virtual void  v85(); // _ZN7S1107C83v85Ev
  virtual void  v86(); // _ZN7S1107C83v86Ev
  virtual void  v87(); // _ZN7S1107C83v87Ev
  virtual void  v88(); // _ZN7S1107C83v88Ev
  virtual void  v89(); // _ZN7S1107C83v89Ev
  virtual void  v90(); // _ZN7S1107C83v90Ev
  virtual void  v91(); // _ZN7S1107C83v91Ev
  virtual void  v92(); // _ZN7S1107C83v92Ev
  virtual void  v93(); // _ZN7S1107C83v93Ev
  virtual void  v94(); // _ZN7S1107C83v94Ev
  virtual void  v95(); // _ZN7S1107C83v95Ev
  virtual void  v96(); // _ZN7S1107C83v96Ev
  virtual void  v97(); // _ZN7S1107C83v97Ev
  virtual void  v98(); // _ZN7S1107C83v98Ev
  virtual void  v99(); // _ZN7S1107C83v99Ev
  virtual void  v100(); // _ZN7S1107C84v100Ev
  virtual void  v101(); // _ZN7S1107C84v101Ev
  virtual void  v102(); // _ZN7S1107C84v102Ev
  virtual void  v103(); // _ZN7S1107C84v103Ev
  virtual void  v104(); // _ZN7S1107C84v104Ev
  virtual void  v105(); // _ZN7S1107C84v105Ev
  virtual void  v106(); // _ZN7S1107C84v106Ev
  virtual void  v107(); // _ZN7S1107C84v107Ev
  virtual void  v108(); // _ZN7S1107C84v108Ev
  virtual void  v109(); // _ZN7S1107C84v109Ev
  virtual void  v110(); // _ZN7S1107C84v110Ev
  virtual void  v111(); // _ZN7S1107C84v111Ev
  virtual void  v112(); // _ZN7S1107C84v112Ev
  virtual void  v113(); // _ZN7S1107C84v113Ev
  virtual void  v114(); // _ZN7S1107C84v114Ev
  virtual void  v115(); // _ZN7S1107C84v115Ev
  virtual void  v116(); // _ZN7S1107C84v116Ev
  virtual void  v117(); // _ZN7S1107C84v117Ev
  S1107C8(); // tgen
};
//SIG(-1 S1107C8) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 FC2{ m Fp} Fi:1 Fi:1 Fi:2 Fi:2 Fi:2 Fi:1 FC3{ m Fi[2]}}


 S1107C8 ::~S1107C8(){ note_dtor("S1107C8", this);}
void  S1107C8 ::v80(){vfunc_called(this, "_ZN7S1107C83v80Ev");}
void  S1107C8 ::v81(){vfunc_called(this, "_ZN7S1107C83v81Ev");}
void  S1107C8 ::v82(){vfunc_called(this, "_ZN7S1107C83v82Ev");}
void  S1107C8 ::v83(){vfunc_called(this, "_ZN7S1107C83v83Ev");}
void  S1107C8 ::v84(){vfunc_called(this, "_ZN7S1107C83v84Ev");}
void  S1107C8 ::v85(){vfunc_called(this, "_ZN7S1107C83v85Ev");}
void  S1107C8 ::v86(){vfunc_called(this, "_ZN7S1107C83v86Ev");}
void  S1107C8 ::v87(){vfunc_called(this, "_ZN7S1107C83v87Ev");}
void  S1107C8 ::v88(){vfunc_called(this, "_ZN7S1107C83v88Ev");}
void  S1107C8 ::v89(){vfunc_called(this, "_ZN7S1107C83v89Ev");}
void  S1107C8 ::v90(){vfunc_called(this, "_ZN7S1107C83v90Ev");}
void  S1107C8 ::v91(){vfunc_called(this, "_ZN7S1107C83v91Ev");}
void  S1107C8 ::v92(){vfunc_called(this, "_ZN7S1107C83v92Ev");}
void  S1107C8 ::v93(){vfunc_called(this, "_ZN7S1107C83v93Ev");}
void  S1107C8 ::v94(){vfunc_called(this, "_ZN7S1107C83v94Ev");}
void  S1107C8 ::v95(){vfunc_called(this, "_ZN7S1107C83v95Ev");}
void  S1107C8 ::v96(){vfunc_called(this, "_ZN7S1107C83v96Ev");}
void  S1107C8 ::v97(){vfunc_called(this, "_ZN7S1107C83v97Ev");}
void  S1107C8 ::v98(){vfunc_called(this, "_ZN7S1107C83v98Ev");}
void  S1107C8 ::v99(){vfunc_called(this, "_ZN7S1107C83v99Ev");}
void  S1107C8 ::v100(){vfunc_called(this, "_ZN7S1107C84v100Ev");}
void  S1107C8 ::v101(){vfunc_called(this, "_ZN7S1107C84v101Ev");}
void  S1107C8 ::v102(){vfunc_called(this, "_ZN7S1107C84v102Ev");}
void  S1107C8 ::v103(){vfunc_called(this, "_ZN7S1107C84v103Ev");}
void  S1107C8 ::v104(){vfunc_called(this, "_ZN7S1107C84v104Ev");}
void  S1107C8 ::v105(){vfunc_called(this, "_ZN7S1107C84v105Ev");}
void  S1107C8 ::v106(){vfunc_called(this, "_ZN7S1107C84v106Ev");}
void  S1107C8 ::v107(){vfunc_called(this, "_ZN7S1107C84v107Ev");}
void  S1107C8 ::v108(){vfunc_called(this, "_ZN7S1107C84v108Ev");}
void  S1107C8 ::v109(){vfunc_called(this, "_ZN7S1107C84v109Ev");}
void  S1107C8 ::v110(){vfunc_called(this, "_ZN7S1107C84v110Ev");}
void  S1107C8 ::v111(){vfunc_called(this, "_ZN7S1107C84v111Ev");}
void  S1107C8 ::v112(){vfunc_called(this, "_ZN7S1107C84v112Ev");}
void  S1107C8 ::v113(){vfunc_called(this, "_ZN7S1107C84v113Ev");}
void  S1107C8 ::v114(){vfunc_called(this, "_ZN7S1107C84v114Ev");}
void  S1107C8 ::v115(){vfunc_called(this, "_ZN7S1107C84v115Ev");}
void  S1107C8 ::v116(){vfunc_called(this, "_ZN7S1107C84v116Ev");}
void  S1107C8 ::v117(){vfunc_called(this, "_ZN7S1107C84v117Ev");}
S1107C8 ::S1107C8(){ note_ctor("S1107C8", this);} // tgen

static void Test_S1107C8()
{
  extern Class_Descriptor cd_S1107C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S1107C8, buf);
    S1107C8 *dp, &lv = *(dp=new (buf) S1107C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S1107C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1107C8)");
    check_field_offset(lv, s1107c8f0, ABISELECT(8,4), "S1107C8.s1107c8f0");
    set_bf_and_test(lv, s1107c8f1, ABISELECT(16,8), 0, 1, 1, "S1107C8");
    set_bf_and_test(lv, s1107c8f2, ABISELECT(16,8), 1, 1, 1, "S1107C8");
    set_bf_and_test(lv, s1107c8f3, ABISELECT(16,8), 2, 2, 1, "S1107C8");
    set_bf_and_test(lv, s1107c8f3, ABISELECT(16,8), 2, 2, hide_sll(1LL<<1), "S1107C8");
    set_bf_and_test(lv, s1107c8f4, ABISELECT(16,8), 4, 2, 1, "S1107C8");
    set_bf_and_test(lv, s1107c8f4, ABISELECT(16,8), 4, 2, hide_sll(1LL<<1), "S1107C8");
    set_bf_and_test(lv, s1107c8f5, ABISELECT(16,8), 6, 2, 1, "S1107C8");
    set_bf_and_test(lv, s1107c8f5, ABISELECT(16,8), 6, 2, hide_sll(1LL<<1), "S1107C8");
    set_bf_and_test(lv, s1107c8f6, ABISELECT(17,9), 0, 1, 1, "S1107C8");
    check_field_offset(lv, s1107c8f7, ABISELECT(20,12), "S1107C8.s1107c8f7");
    test_class_info(&lv, &cd_S1107C8);
    dp->~S1107C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1107C8(Test_S1107C8, "S1107C8", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN7S1107C8C1Ev();
extern void _ZN7S1107C8D1Ev();
Name_Map name_map_S1107C8[] = {
  NSPAIR(_ZN7S1107C8C1Ev),
  NSPAIR(_ZN7S1107C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1107C8[];
extern void _ZN7S1107C8D1Ev();
extern void _ZN7S1107C8D0Ev();
extern void _ZN7S1107C83v80Ev();
extern void _ZN7S1107C83v81Ev();
extern void _ZN7S1107C83v82Ev();
extern void _ZN7S1107C83v83Ev();
extern void _ZN7S1107C83v84Ev();
extern void _ZN7S1107C83v85Ev();
extern void _ZN7S1107C83v86Ev();
extern void _ZN7S1107C83v87Ev();
extern void _ZN7S1107C83v88Ev();
extern void _ZN7S1107C83v89Ev();
extern void _ZN7S1107C83v90Ev();
extern void _ZN7S1107C83v91Ev();
extern void _ZN7S1107C83v92Ev();
extern void _ZN7S1107C83v93Ev();
extern void _ZN7S1107C83v94Ev();
extern void _ZN7S1107C83v95Ev();
extern void _ZN7S1107C83v96Ev();
extern void _ZN7S1107C83v97Ev();
extern void _ZN7S1107C83v98Ev();
extern void _ZN7S1107C83v99Ev();
extern void _ZN7S1107C84v100Ev();
extern void _ZN7S1107C84v101Ev();
extern void _ZN7S1107C84v102Ev();
extern void _ZN7S1107C84v103Ev();
extern void _ZN7S1107C84v104Ev();
extern void _ZN7S1107C84v105Ev();
extern void _ZN7S1107C84v106Ev();
extern void _ZN7S1107C84v107Ev();
extern void _ZN7S1107C84v108Ev();
extern void _ZN7S1107C84v109Ev();
extern void _ZN7S1107C84v110Ev();
extern void _ZN7S1107C84v111Ev();
extern void _ZN7S1107C84v112Ev();
extern void _ZN7S1107C84v113Ev();
extern void _ZN7S1107C84v114Ev();
extern void _ZN7S1107C84v115Ev();
extern void _ZN7S1107C84v116Ev();
extern void _ZN7S1107C84v117Ev();
static  VTBL_ENTRY vtc_S1107C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1107C8[0]),
  (VTBL_ENTRY)&_ZN7S1107C8D1Ev,
  (VTBL_ENTRY)&_ZN7S1107C8D0Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v80Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v81Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v82Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v83Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v84Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v85Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v86Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v87Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v88Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v89Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v90Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v91Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v92Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v93Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v94Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v95Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v96Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v97Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v98Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v99Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v100Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v101Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v102Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v103Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v104Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v105Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v106Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v107Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v108Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v109Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v110Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v111Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v112Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v113Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v114Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v115Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v116Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v117Ev,
};
extern VTBL_ENTRY _ZTI7S1107C8[];
extern  VTBL_ENTRY _ZTV7S1107C8[];
Class_Descriptor cd_S1107C8 = {  "S1107C8", // class name
  0,0,//no base classes
  &(vtc_S1107C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI7S1107C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1107C8),42, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1107C12_nt  {
  void *s1107c12f0;
  int s1107c12f1[4];
  void  mf1107c12(); // _ZN11S1107C12_nt9mf1107c12Ev
};
//SIG(-1 S1107C12_nt) C1{ m Fp Fi[4]}


void  S1107C12_nt ::mf1107c12(){}

//skip512 S1107C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1107C11_nt  {
  ::S1107C12_nt s1107c11f0;
  void  mf1107c11(); // _ZN11S1107C11_nt9mf1107c11Ev
};
//SIG(-1 S1107C11_nt) C1{ m FC2{ m Fp Fi[4]}}


void  S1107C11_nt ::mf1107c11(){}

//skip512 S1107C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1107C7_nt  {
  int s1107c7f0[2];
  void  mf1107c7(); // _ZN10S1107C7_nt8mf1107c7Ev
};
//SIG(-1 S1107C7_nt) C1{ m Fi[2]}


void  S1107C7_nt ::mf1107c7(){}

//skip512 S1107C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1107C1  : S1107C2 , S1107C8 {
  ::S15308C117 s1107c1f0;
  ::S15308C117 s1107c1f1;
  int s1107c1f2[2];
  char s1107c1f3[3];
  ::S1107C11_nt s1107c1f4;
  char s1107c1f5;
  ::S4658C31_nt s1107c1f6;
  ::S1107C7_nt s1107c1f7;
  ::S4658C32_nt s1107c1f8;
  ::S1107C7_nt s1107c1f9;
  ::S1107C7_nt s1107c1f10;
  int s1107c1f11;
  char s1107c1f12[2];
  int s1107c1f13;
  ::S4658C32_nt s1107c1f14;
  char s1107c1f15[6];
  virtual  ~S1107C1(); // _ZN7S1107C1D1Ev
  virtual void  v1(); // _ZN7S1107C12v1Ev
  virtual void  v2(); // _ZN7S1107C12v2Ev
  virtual void  v3(); // _ZN7S1107C12v3Ev
  virtual void  v4(); // _ZN7S1107C12v4Ev
  virtual void  v5(); // _ZN7S1107C12v5Ev
  virtual void  v6(); // _ZN7S1107C12v6Ev
  virtual void  v7(); // _ZN7S1107C12v7Ev
  virtual void  v8(); // _ZN7S1107C12v8Ev
  virtual void  v9(); // _ZN7S1107C12v9Ev
  virtual void  v10(); // _ZN7S1107C13v10Ev
  virtual void  v11(); // _ZN7S1107C13v11Ev
  virtual void  v12(); // _ZN7S1107C13v12Ev
  virtual void  v13(); // _ZN7S1107C13v13Ev
  virtual void  v14(); // _ZN7S1107C13v14Ev
  virtual void  v15(); // _ZN7S1107C13v15Ev
  virtual void  v16(); // _ZN7S1107C13v16Ev
  virtual void  v17(); // _ZN7S1107C13v17Ev
  virtual void  v18(); // _ZN7S1107C13v18Ev
  virtual void  v19(); // _ZN7S1107C13v19Ev
  virtual void  v20(); // _ZN7S1107C13v20Ev
  virtual void  v21(); // _ZN7S1107C13v21Ev
  virtual void  v22(); // _ZN7S1107C13v22Ev
  virtual void  v23(); // _ZN7S1107C13v23Ev
  virtual void  v24(); // _ZN7S1107C13v24Ev
  virtual void  v25(); // _ZN7S1107C13v25Ev
  virtual void  v26(); // _ZN7S1107C13v26Ev
  virtual void  v27(); // _ZN7S1107C13v27Ev
  virtual void  v28(); // _ZN7S1107C13v28Ev
  virtual void  v29(); // _ZN7S1107C13v29Ev
  virtual void  v30(); // _ZN7S1107C13v30Ev
  virtual void  v31(); // _ZN7S1107C13v31Ev
  virtual void  v32(); // _ZN7S1107C13v32Ev
  virtual void  v33(); // _ZN7S1107C13v33Ev
  virtual void  v34(); // _ZN7S1107C13v34Ev
  virtual void  v35(); // _ZN7S1107C13v35Ev
  virtual void  v36(); // _ZN7S1107C13v36Ev
  virtual void  v37(); // _ZN7S1107C13v37Ev
  virtual void  v38(); // _ZN7S1107C13v38Ev
  virtual void  v39(); // _ZN7S1107C13v39Ev
  virtual void  v40(); // _ZN7S1107C13v40Ev
  virtual void  v41(); // _ZN7S1107C13v41Ev
  virtual void  v42(); // _ZN7S1107C13v42Ev
  virtual void  v43(); // _ZN7S1107C13v43Ev
  virtual void  v44(); // _ZN7S1107C13v44Ev
  virtual void  v45(); // _ZN7S1107C13v45Ev
  virtual void  v46(); // _ZN7S1107C13v46Ev
  virtual void  v47(); // _ZN7S1107C13v47Ev
  virtual void  v48(); // _ZN7S1107C13v48Ev
  virtual void  v49(); // _ZN7S1107C13v49Ev
  virtual void  v50(); // _ZN7S1107C13v50Ev
  virtual void  v51(); // _ZN7S1107C13v51Ev
  virtual void  v52(); // _ZN7S1107C13v52Ev
  virtual void  v53(); // _ZN7S1107C13v53Ev
  virtual void  v54(); // _ZN7S1107C13v54Ev
  virtual void  v55(); // _ZN7S1107C13v55Ev
  virtual void  v56(); // _ZN7S1107C13v56Ev
  virtual void  v57(); // _ZN7S1107C13v57Ev
  S1107C1(); // tgen
};
//SIG(1 S1107C1) C1{ BC2{ BC3{ BC4{ m Fi}} vd v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fp[2] Fc[2] FC5{ m FC6{ m Fi[2]} FC6}} BC7{ vd v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 FC8{ m Fp} Fi:1 Fi:1 Fi:2 Fi:2 Fi:2 Fi:1 FC6} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 FC9{ m Fp} FC9 Fi[2] Fc[3] FC10{ m FC11{ m Fp Fi[4]}} Fc FC5 FC12{ m Fi[2]} FC6 FC12 FC12 Fi Fc[2] Fi FC6 Fc[6]}


 S1107C1 ::~S1107C1(){ note_dtor("S1107C1", this);}
void  S1107C1 ::v1(){vfunc_called(this, "_ZN7S1107C12v1Ev");}
void  S1107C1 ::v2(){vfunc_called(this, "_ZN7S1107C12v2Ev");}
void  S1107C1 ::v3(){vfunc_called(this, "_ZN7S1107C12v3Ev");}
void  S1107C1 ::v4(){vfunc_called(this, "_ZN7S1107C12v4Ev");}
void  S1107C1 ::v5(){vfunc_called(this, "_ZN7S1107C12v5Ev");}
void  S1107C1 ::v6(){vfunc_called(this, "_ZN7S1107C12v6Ev");}
void  S1107C1 ::v7(){vfunc_called(this, "_ZN7S1107C12v7Ev");}
void  S1107C1 ::v8(){vfunc_called(this, "_ZN7S1107C12v8Ev");}
void  S1107C1 ::v9(){vfunc_called(this, "_ZN7S1107C12v9Ev");}
void  S1107C1 ::v10(){vfunc_called(this, "_ZN7S1107C13v10Ev");}
void  S1107C1 ::v11(){vfunc_called(this, "_ZN7S1107C13v11Ev");}
void  S1107C1 ::v12(){vfunc_called(this, "_ZN7S1107C13v12Ev");}
void  S1107C1 ::v13(){vfunc_called(this, "_ZN7S1107C13v13Ev");}
void  S1107C1 ::v14(){vfunc_called(this, "_ZN7S1107C13v14Ev");}
void  S1107C1 ::v15(){vfunc_called(this, "_ZN7S1107C13v15Ev");}
void  S1107C1 ::v16(){vfunc_called(this, "_ZN7S1107C13v16Ev");}
void  S1107C1 ::v17(){vfunc_called(this, "_ZN7S1107C13v17Ev");}
void  S1107C1 ::v18(){vfunc_called(this, "_ZN7S1107C13v18Ev");}
void  S1107C1 ::v19(){vfunc_called(this, "_ZN7S1107C13v19Ev");}
void  S1107C1 ::v20(){vfunc_called(this, "_ZN7S1107C13v20Ev");}
void  S1107C1 ::v21(){vfunc_called(this, "_ZN7S1107C13v21Ev");}
void  S1107C1 ::v22(){vfunc_called(this, "_ZN7S1107C13v22Ev");}
void  S1107C1 ::v23(){vfunc_called(this, "_ZN7S1107C13v23Ev");}
void  S1107C1 ::v24(){vfunc_called(this, "_ZN7S1107C13v24Ev");}
void  S1107C1 ::v25(){vfunc_called(this, "_ZN7S1107C13v25Ev");}
void  S1107C1 ::v26(){vfunc_called(this, "_ZN7S1107C13v26Ev");}
void  S1107C1 ::v27(){vfunc_called(this, "_ZN7S1107C13v27Ev");}
void  S1107C1 ::v28(){vfunc_called(this, "_ZN7S1107C13v28Ev");}
void  S1107C1 ::v29(){vfunc_called(this, "_ZN7S1107C13v29Ev");}
void  S1107C1 ::v30(){vfunc_called(this, "_ZN7S1107C13v30Ev");}
void  S1107C1 ::v31(){vfunc_called(this, "_ZN7S1107C13v31Ev");}
void  S1107C1 ::v32(){vfunc_called(this, "_ZN7S1107C13v32Ev");}
void  S1107C1 ::v33(){vfunc_called(this, "_ZN7S1107C13v33Ev");}
void  S1107C1 ::v34(){vfunc_called(this, "_ZN7S1107C13v34Ev");}
void  S1107C1 ::v35(){vfunc_called(this, "_ZN7S1107C13v35Ev");}
void  S1107C1 ::v36(){vfunc_called(this, "_ZN7S1107C13v36Ev");}
void  S1107C1 ::v37(){vfunc_called(this, "_ZN7S1107C13v37Ev");}
void  S1107C1 ::v38(){vfunc_called(this, "_ZN7S1107C13v38Ev");}
void  S1107C1 ::v39(){vfunc_called(this, "_ZN7S1107C13v39Ev");}
void  S1107C1 ::v40(){vfunc_called(this, "_ZN7S1107C13v40Ev");}
void  S1107C1 ::v41(){vfunc_called(this, "_ZN7S1107C13v41Ev");}
void  S1107C1 ::v42(){vfunc_called(this, "_ZN7S1107C13v42Ev");}
void  S1107C1 ::v43(){vfunc_called(this, "_ZN7S1107C13v43Ev");}
void  S1107C1 ::v44(){vfunc_called(this, "_ZN7S1107C13v44Ev");}
void  S1107C1 ::v45(){vfunc_called(this, "_ZN7S1107C13v45Ev");}
void  S1107C1 ::v46(){vfunc_called(this, "_ZN7S1107C13v46Ev");}
void  S1107C1 ::v47(){vfunc_called(this, "_ZN7S1107C13v47Ev");}
void  S1107C1 ::v48(){vfunc_called(this, "_ZN7S1107C13v48Ev");}
void  S1107C1 ::v49(){vfunc_called(this, "_ZN7S1107C13v49Ev");}
void  S1107C1 ::v50(){vfunc_called(this, "_ZN7S1107C13v50Ev");}
void  S1107C1 ::v51(){vfunc_called(this, "_ZN7S1107C13v51Ev");}
void  S1107C1 ::v52(){vfunc_called(this, "_ZN7S1107C13v52Ev");}
void  S1107C1 ::v53(){vfunc_called(this, "_ZN7S1107C13v53Ev");}
void  S1107C1 ::v54(){vfunc_called(this, "_ZN7S1107C13v54Ev");}
void  S1107C1 ::v55(){vfunc_called(this, "_ZN7S1107C13v55Ev");}
void  S1107C1 ::v56(){vfunc_called(this, "_ZN7S1107C13v56Ev");}
void  S1107C1 ::v57(){vfunc_called(this, "_ZN7S1107C13v57Ev");}
S1107C1 ::S1107C1(){ note_ctor("S1107C1", this);} // tgen

static void Test_S1107C1()
{
  extern Class_Descriptor cd_S1107C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,45)];
    init_test(&cd_S1107C1, buf);
    S1107C1 *dp, &lv = *(dp=new (buf) S1107C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,176), "sizeof(S1107C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1107C1)");
    check_base_class_offset(lv, (S9509C16_nt*)(S1107C3*)(S1107C2*), ABISELECT(8,4), "S1107C1");
    check_base_class_offset(lv, (S1107C3*)(S1107C2*), ABISELECT(8,4), "S1107C1");
    check_base_class_offset(lv, (S1107C2*), 0, "S1107C1");
    check_base_class_offset(lv, (S1107C8*), ABISELECT(56,36), "S1107C1");
    check_field_offset(lv, s1107c1f0, ABISELECT(88,56), "S1107C1.s1107c1f0");
    check_field_offset(lv, s1107c1f1, ABISELECT(96,60), "S1107C1.s1107c1f1");
    check_field_offset(lv, s1107c1f2, ABISELECT(104,64), "S1107C1.s1107c1f2");
    check_field_offset(lv, s1107c1f3, ABISELECT(112,72), "S1107C1.s1107c1f3");
    check_field_offset(lv, s1107c1f4, ABISELECT(120,76), "S1107C1.s1107c1f4");
    check_field_offset(lv, s1107c1f5, ABISELECT(144,96), "S1107C1.s1107c1f5");
    check_field_offset(lv, s1107c1f6, ABISELECT(148,100), "S1107C1.s1107c1f6");
    check_field_offset(lv, s1107c1f7, ABISELECT(164,116), "S1107C1.s1107c1f7");
    check_field_offset(lv, s1107c1f8, ABISELECT(172,124), "S1107C1.s1107c1f8");
    check_field_offset(lv, s1107c1f9, ABISELECT(180,132), "S1107C1.s1107c1f9");
    check_field_offset(lv, s1107c1f10, ABISELECT(188,140), "S1107C1.s1107c1f10");
    check_field_offset(lv, s1107c1f11, ABISELECT(196,148), "S1107C1.s1107c1f11");
    check_field_offset(lv, s1107c1f12, ABISELECT(200,152), "S1107C1.s1107c1f12");
    check_field_offset(lv, s1107c1f13, ABISELECT(204,156), "S1107C1.s1107c1f13");
    check_field_offset(lv, s1107c1f14, ABISELECT(208,160), "S1107C1.s1107c1f14");
    check_field_offset(lv, s1107c1f15, ABISELECT(216,168), "S1107C1.s1107c1f15");
    test_class_info(&lv, &cd_S1107C1);
    dp->~S1107C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1107C1(Test_S1107C1, "S1107C1", ABISELECT(224,176));

#else // __cplusplus

extern void _ZN7S1107C1C1Ev();
extern void _ZN7S1107C1D1Ev();
Name_Map name_map_S1107C1[] = {
  NSPAIR(_ZN7S1107C1C1Ev),
  NSPAIR(_ZN7S1107C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9509C16_nt;
extern VTBL_ENTRY _ZTI11S9509C16_nt[];
extern Class_Descriptor cd_S1107C3;
extern VTBL_ENTRY _ZTI7S1107C3[];
extern Class_Descriptor cd_S1107C2;
extern VTBL_ENTRY _ZTI7S1107C2[];
extern  VTBL_ENTRY _ZTV7S1107C2[];
extern Class_Descriptor cd_S1107C8;
extern VTBL_ENTRY _ZTI7S1107C8[];
extern  VTBL_ENTRY _ZTV7S1107C8[];
static Base_Class bases_S1107C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9509C16_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1107C3,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1107C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1107C8,    ABISELECT(56,36), //bcp->offset
    83, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1107C1[];
extern void _ZN7S1107C1D1Ev();
extern void _ZN7S1107C1D0Ev();
extern void _ZN7S1107C23v58Ev();
extern void _ZN7S1107C23v59Ev();
extern void _ZN7S1107C23v60Ev();
extern void _ZN7S1107C23v61Ev();
extern void _ZN7S1107C23v62Ev();
extern void _ZN7S1107C23v63Ev();
extern void _ZN7S1107C23v64Ev();
extern void _ZN7S1107C23v65Ev();
extern void _ZN7S1107C23v66Ev();
extern void _ZN7S1107C23v67Ev();
extern void _ZN7S1107C23v68Ev();
extern void _ZN7S1107C23v69Ev();
extern void _ZN7S1107C23v70Ev();
extern void _ZN7S1107C23v71Ev();
extern void _ZN7S1107C23v72Ev();
extern void _ZN7S1107C23v73Ev();
extern void _ZN7S1107C23v74Ev();
extern void _ZN7S1107C23v75Ev();
extern void _ZN7S1107C23v76Ev();
extern void _ZN7S1107C23v77Ev();
extern void _ZN7S1107C23v78Ev();
extern void _ZN7S1107C23v79Ev();
extern void _ZN7S1107C12v1Ev();
extern void _ZN7S1107C12v2Ev();
extern void _ZN7S1107C12v3Ev();
extern void _ZN7S1107C12v4Ev();
extern void _ZN7S1107C12v5Ev();
extern void _ZN7S1107C12v6Ev();
extern void _ZN7S1107C12v7Ev();
extern void _ZN7S1107C12v8Ev();
extern void _ZN7S1107C12v9Ev();
extern void _ZN7S1107C13v10Ev();
extern void _ZN7S1107C13v11Ev();
extern void _ZN7S1107C13v12Ev();
extern void _ZN7S1107C13v13Ev();
extern void _ZN7S1107C13v14Ev();
extern void _ZN7S1107C13v15Ev();
extern void _ZN7S1107C13v16Ev();
extern void _ZN7S1107C13v17Ev();
extern void _ZN7S1107C13v18Ev();
extern void _ZN7S1107C13v19Ev();
extern void _ZN7S1107C13v20Ev();
extern void _ZN7S1107C13v21Ev();
extern void _ZN7S1107C13v22Ev();
extern void _ZN7S1107C13v23Ev();
extern void _ZN7S1107C13v24Ev();
extern void _ZN7S1107C13v25Ev();
extern void _ZN7S1107C13v26Ev();
extern void _ZN7S1107C13v27Ev();
extern void _ZN7S1107C13v28Ev();
extern void _ZN7S1107C13v29Ev();
extern void _ZN7S1107C13v30Ev();
extern void _ZN7S1107C13v31Ev();
extern void _ZN7S1107C13v32Ev();
extern void _ZN7S1107C13v33Ev();
extern void _ZN7S1107C13v34Ev();
extern void _ZN7S1107C13v35Ev();
extern void _ZN7S1107C13v36Ev();
extern void _ZN7S1107C13v37Ev();
extern void _ZN7S1107C13v38Ev();
extern void _ZN7S1107C13v39Ev();
extern void _ZN7S1107C13v40Ev();
extern void _ZN7S1107C13v41Ev();
extern void _ZN7S1107C13v42Ev();
extern void _ZN7S1107C13v43Ev();
extern void _ZN7S1107C13v44Ev();
extern void _ZN7S1107C13v45Ev();
extern void _ZN7S1107C13v46Ev();
extern void _ZN7S1107C13v47Ev();
extern void _ZN7S1107C13v48Ev();
extern void _ZN7S1107C13v49Ev();
extern void _ZN7S1107C13v50Ev();
extern void _ZN7S1107C13v51Ev();
extern void _ZN7S1107C13v52Ev();
extern void _ZN7S1107C13v53Ev();
extern void _ZN7S1107C13v54Ev();
extern void _ZN7S1107C13v55Ev();
extern void _ZN7S1107C13v56Ev();
extern void _ZN7S1107C13v57Ev();
extern void ABISELECT(_ZThn56_N7S1107C1D1Ev,_ZThn36_N7S1107C1D1Ev)();
extern void ABISELECT(_ZThn56_N7S1107C1D0Ev,_ZThn36_N7S1107C1D0Ev)();
extern void _ZN7S1107C83v80Ev();
extern void _ZN7S1107C83v81Ev();
extern void _ZN7S1107C83v82Ev();
extern void _ZN7S1107C83v83Ev();
extern void _ZN7S1107C83v84Ev();
extern void _ZN7S1107C83v85Ev();
extern void _ZN7S1107C83v86Ev();
extern void _ZN7S1107C83v87Ev();
extern void _ZN7S1107C83v88Ev();
extern void _ZN7S1107C83v89Ev();
extern void _ZN7S1107C83v90Ev();
extern void _ZN7S1107C83v91Ev();
extern void _ZN7S1107C83v92Ev();
extern void _ZN7S1107C83v93Ev();
extern void _ZN7S1107C83v94Ev();
extern void _ZN7S1107C83v95Ev();
extern void _ZN7S1107C83v96Ev();
extern void _ZN7S1107C83v97Ev();
extern void _ZN7S1107C83v98Ev();
extern void _ZN7S1107C83v99Ev();
extern void _ZN7S1107C84v100Ev();
extern void _ZN7S1107C84v101Ev();
extern void _ZN7S1107C84v102Ev();
extern void _ZN7S1107C84v103Ev();
extern void _ZN7S1107C84v104Ev();
extern void _ZN7S1107C84v105Ev();
extern void _ZN7S1107C84v106Ev();
extern void _ZN7S1107C84v107Ev();
extern void _ZN7S1107C84v108Ev();
extern void _ZN7S1107C84v109Ev();
extern void _ZN7S1107C84v110Ev();
extern void _ZN7S1107C84v111Ev();
extern void _ZN7S1107C84v112Ev();
extern void _ZN7S1107C84v113Ev();
extern void _ZN7S1107C84v114Ev();
extern void _ZN7S1107C84v115Ev();
extern void _ZN7S1107C84v116Ev();
extern void _ZN7S1107C84v117Ev();
static  VTBL_ENTRY vtc_S1107C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1107C1[0]),
  (VTBL_ENTRY)&_ZN7S1107C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1107C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v58Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v59Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v60Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v61Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v62Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v63Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v64Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v65Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v66Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v67Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v68Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v69Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v70Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v71Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v72Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v73Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v74Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v75Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v76Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v77Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v78Ev,
  (VTBL_ENTRY)&_ZN7S1107C23v79Ev,
  (VTBL_ENTRY)&_ZN7S1107C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1107C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1107C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1107C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1107C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1107C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1107C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1107C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1107C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v12Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v13Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v14Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v15Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v16Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v17Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v18Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v19Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v20Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v21Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v22Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v23Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v24Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v25Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v26Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v27Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v28Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v29Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v30Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v31Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v32Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v33Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v34Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v35Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v36Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v37Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v38Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v39Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v40Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v41Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v42Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v43Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v44Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v45Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v46Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v47Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v48Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v49Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v50Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v51Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v52Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v53Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v54Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v55Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v56Ev,
  (VTBL_ENTRY)&_ZN7S1107C13v57Ev,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI7S1107C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N7S1107C1D1Ev,_ZThn36_N7S1107C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N7S1107C1D0Ev,_ZThn36_N7S1107C1D0Ev),
  (VTBL_ENTRY)&_ZN7S1107C83v80Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v81Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v82Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v83Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v84Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v85Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v86Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v87Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v88Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v89Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v90Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v91Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v92Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v93Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v94Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v95Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v96Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v97Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v98Ev,
  (VTBL_ENTRY)&_ZN7S1107C83v99Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v100Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v101Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v102Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v103Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v104Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v105Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v106Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v107Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v108Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v109Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v110Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v111Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v112Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v113Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v114Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v115Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v116Ev,
  (VTBL_ENTRY)&_ZN7S1107C84v117Ev,
};
extern VTBL_ENTRY _ZTI7S1107C1[];
extern  VTBL_ENTRY _ZTV7S1107C1[];
Class_Descriptor cd_S1107C1 = {  "S1107C1", // class name
  bases_S1107C1, 4,
  &(vtc_S1107C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,176), // object size
  NSPAIRA(_ZTI7S1107C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S1107C1),125, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9929C2  {
  virtual  ~S9929C2(); // _ZN7S9929C2D1Ev
  virtual void  v5(); // _ZN7S9929C22v5Ev
  virtual void  v6(); // _ZN7S9929C22v6Ev
  virtual void  v7(); // _ZN7S9929C22v7Ev
  virtual void  v8(); // _ZN7S9929C22v8Ev
  virtual void  v9(); // _ZN7S9929C22v9Ev
  S9929C2(); // tgen
};
//SIG(-1 S9929C2) C1{ vd v1 v2 v3 v4 v5}


 S9929C2 ::~S9929C2(){ note_dtor("S9929C2", this);}
void  S9929C2 ::v5(){vfunc_called(this, "_ZN7S9929C22v5Ev");}
void  S9929C2 ::v6(){vfunc_called(this, "_ZN7S9929C22v6Ev");}
void  S9929C2 ::v7(){vfunc_called(this, "_ZN7S9929C22v7Ev");}
void  S9929C2 ::v8(){vfunc_called(this, "_ZN7S9929C22v8Ev");}
void  S9929C2 ::v9(){vfunc_called(this, "_ZN7S9929C22v9Ev");}
S9929C2 ::S9929C2(){ note_ctor("S9929C2", this);} // tgen

static void Test_S9929C2()
{
  extern Class_Descriptor cd_S9929C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9929C2, buf);
    S9929C2 *dp, &lv = *(dp=new (buf) S9929C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9929C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9929C2)");
    test_class_info(&lv, &cd_S9929C2);
    dp->~S9929C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9929C2(Test_S9929C2, "S9929C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9929C2C1Ev();
extern void _ZN7S9929C2D1Ev();
Name_Map name_map_S9929C2[] = {
  NSPAIR(_ZN7S9929C2C1Ev),
  NSPAIR(_ZN7S9929C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9929C2[];
extern void _ZN7S9929C2D1Ev();
extern void _ZN7S9929C2D0Ev();
extern void _ZN7S9929C22v5Ev();
extern void _ZN7S9929C22v6Ev();
extern void _ZN7S9929C22v7Ev();
extern void _ZN7S9929C22v8Ev();
extern void _ZN7S9929C22v9Ev();
static  VTBL_ENTRY vtc_S9929C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9929C2[0]),
  (VTBL_ENTRY)&_ZN7S9929C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9929C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9929C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9929C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9929C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9929C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9929C22v9Ev,
};
extern VTBL_ENTRY _ZTI7S9929C2[];
extern  VTBL_ENTRY _ZTV7S9929C2[];
Class_Descriptor cd_S9929C2 = {  "S9929C2", // class name
  0,0,//no base classes
  &(vtc_S9929C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9929C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9929C2),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9929C3  {
  virtual  ~S9929C3(); // _ZN7S9929C3D1Ev
  virtual void  v10(); // _ZN7S9929C33v10Ev
  virtual void  v11(); // _ZN7S9929C33v11Ev
  virtual void  v12(); // _ZN7S9929C33v12Ev
  virtual void  v13(); // _ZN7S9929C33v13Ev
  S9929C3(); // tgen
};
//SIG(-1 S9929C3) C1{ vd v1 v2 v3 v4}


 S9929C3 ::~S9929C3(){ note_dtor("S9929C3", this);}
void  S9929C3 ::v10(){vfunc_called(this, "_ZN7S9929C33v10Ev");}
void  S9929C3 ::v11(){vfunc_called(this, "_ZN7S9929C33v11Ev");}
void  S9929C3 ::v12(){vfunc_called(this, "_ZN7S9929C33v12Ev");}
void  S9929C3 ::v13(){vfunc_called(this, "_ZN7S9929C33v13Ev");}
S9929C3 ::S9929C3(){ note_ctor("S9929C3", this);} // tgen

static void Test_S9929C3()
{
  extern Class_Descriptor cd_S9929C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9929C3, buf);
    S9929C3 *dp, &lv = *(dp=new (buf) S9929C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9929C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9929C3)");
    test_class_info(&lv, &cd_S9929C3);
    dp->~S9929C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9929C3(Test_S9929C3, "S9929C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9929C3C1Ev();
extern void _ZN7S9929C3D1Ev();
Name_Map name_map_S9929C3[] = {
  NSPAIR(_ZN7S9929C3C1Ev),
  NSPAIR(_ZN7S9929C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9929C3[];
extern void _ZN7S9929C3D1Ev();
extern void _ZN7S9929C3D0Ev();
extern void _ZN7S9929C33v10Ev();
extern void _ZN7S9929C33v11Ev();
extern void _ZN7S9929C33v12Ev();
extern void _ZN7S9929C33v13Ev();
static  VTBL_ENTRY vtc_S9929C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9929C3[0]),
  (VTBL_ENTRY)&_ZN7S9929C3D1Ev,
  (VTBL_ENTRY)&_ZN7S9929C3D0Ev,
  (VTBL_ENTRY)&_ZN7S9929C33v10Ev,
  (VTBL_ENTRY)&_ZN7S9929C33v11Ev,
  (VTBL_ENTRY)&_ZN7S9929C33v12Ev,
  (VTBL_ENTRY)&_ZN7S9929C33v13Ev,
};
extern VTBL_ENTRY _ZTI7S9929C3[];
extern  VTBL_ENTRY _ZTV7S9929C3[];
Class_Descriptor cd_S9929C3 = {  "S9929C3", // class name
  0,0,//no base classes
  &(vtc_S9929C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9929C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9929C3),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9929C4  {
  ::S15308C202 s9929c4f0;
  ::S15308C202 s9929c4f1;
  char s9929c4f2;
  ::S15308C2_nt s9929c4f3;
  ::S15308C2_nt s9929c4f4[20];
  char s9929c4f5;
  void  mf9929c4(); // _ZN7S9929C48mf9929c4Ev
};
//SIG(-1 S9929C4) C1{ m FC2{ BC3{ BC4{ BC5{ BC6{ BC7{ BC8{} FC9{ BC10{}}} FC11{ BC12{}}} FC11} FC13{ BC14{}}} Fp Fi}} FC2 Fc FC15{ BC16{ BC17{ BC8} FC18{ BC19{}}} FU20{ Fc[16] Fp} Fi Fi} FC15[20] Fc}


void  S9929C4 ::mf9929c4(){}

static void Test_S9929C4()
{
  {
    init_simple_test("S9929C4");
    S9929C4 lv;
    check2(sizeof(lv), ABISELECT(736,620), "sizeof(S9929C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9929C4)");
    check_field_offset(lv, s9929c4f0, 0, "S9929C4.s9929c4f0");
    check_field_offset(lv, s9929c4f1, ABISELECT(24,12), "S9929C4.s9929c4f1");
    check_field_offset(lv, s9929c4f2, ABISELECT(48,24), "S9929C4.s9929c4f2");
    check_field_offset(lv, s9929c4f3, ABISELECT(56,28), "S9929C4.s9929c4f3");
    check_field_offset(lv, s9929c4f4, ABISELECT(88,56), "S9929C4.s9929c4f4");
    check_field_offset(lv, s9929c4f5, ABISELECT(728,616), "S9929C4.s9929c4f5");
  }
}
static Arrange_To_Call_Me vS9929C4(Test_S9929C4, "S9929C4", ABISELECT(736,620));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9929C30  {
  char s9929c30f0;
  void *s9929c30f1;
  int s9929c30f2;
  int s9929c30f3;
  int s9929c30f4;
  ::S15308C172 s9929c30f5;
  int s9929c30f6;
  int s9929c30f7[10];
  int s9929c30f8;
  void *s9929c30f9;
  int s9929c30f10;
  void *s9929c30f11[24];
  int s9929c30f12;
  int s9929c30f13;
  int s9929c30f14;
  int s9929c30f15;
  void *s9929c30f16[4];
  int s9929c30f17;
  int s9929c30f18;
  void  mf9929c30(); // _ZN8S9929C309mf9929c30Ev
};
//SIG(1 S9929C30) C1{ m Fc Fp Fi[3] FC2{ BC3{ m Fc[16]}} Fi[12] Fp Fi Fp[24] Fi[4] Fp[4] Fi[2]}


void  S9929C30 ::mf9929c30(){}

static void Test_S9929C30()
{
  {
    init_simple_test("S9929C30");
    S9929C30 lv;
    check2(sizeof(lv), ABISELECT(360,228), "sizeof(S9929C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9929C30)");
    check_field_offset(lv, s9929c30f0, 0, "S9929C30.s9929c30f0");
    check_field_offset(lv, s9929c30f1, ABISELECT(8,4), "S9929C30.s9929c30f1");
    check_field_offset(lv, s9929c30f2, ABISELECT(16,8), "S9929C30.s9929c30f2");
    check_field_offset(lv, s9929c30f3, ABISELECT(20,12), "S9929C30.s9929c30f3");
    check_field_offset(lv, s9929c30f4, ABISELECT(24,16), "S9929C30.s9929c30f4");
    check_field_offset(lv, s9929c30f5, ABISELECT(28,20), "S9929C30.s9929c30f5");
    check_field_offset(lv, s9929c30f6, ABISELECT(44,36), "S9929C30.s9929c30f6");
    check_field_offset(lv, s9929c30f7, ABISELECT(48,40), "S9929C30.s9929c30f7");
    check_field_offset(lv, s9929c30f8, ABISELECT(88,80), "S9929C30.s9929c30f8");
    check_field_offset(lv, s9929c30f9, ABISELECT(96,84), "S9929C30.s9929c30f9");
    check_field_offset(lv, s9929c30f10, ABISELECT(104,88), "S9929C30.s9929c30f10");
    check_field_offset(lv, s9929c30f11, ABISELECT(112,92), "S9929C30.s9929c30f11");
    check_field_offset(lv, s9929c30f12, ABISELECT(304,188), "S9929C30.s9929c30f12");
    check_field_offset(lv, s9929c30f13, ABISELECT(308,192), "S9929C30.s9929c30f13");
    check_field_offset(lv, s9929c30f14, ABISELECT(312,196), "S9929C30.s9929c30f14");
    check_field_offset(lv, s9929c30f15, ABISELECT(316,200), "S9929C30.s9929c30f15");
    check_field_offset(lv, s9929c30f16, ABISELECT(320,204), "S9929C30.s9929c30f16");
    check_field_offset(lv, s9929c30f17, ABISELECT(352,220), "S9929C30.s9929c30f17");
    check_field_offset(lv, s9929c30f18, ABISELECT(356,224), "S9929C30.s9929c30f18");
  }
}
static Arrange_To_Call_Me vS9929C30(Test_S9929C30, "S9929C30", ABISELECT(360,228));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9929C33  {
  ::S15308C172 s9929c33f0;
  ::S15308C172 s9929c33f1;
  int s9929c33f2;
  int s9929c33f3;
  int s9929c33f4;
  int s9929c33f5;
  int s9929c33f6;
  int s9929c33f7;
  int s9929c33f8;
  int s9929c33f9;
  char s9929c33f10;
};
//SIG(1 S9929C33) C1{ FC2{ BC3{ m Fc[16]}} FC2 Fi[8] Fc}



static void Test_S9929C33()
{
  {
    init_simple_test("S9929C33");
    S9929C33 lv;
    check2(sizeof(lv), 68, "sizeof(S9929C33)");
    check2(__alignof__(lv), 4, "__alignof__(S9929C33)");
    check_field_offset(lv, s9929c33f0, 0, "S9929C33.s9929c33f0");
    check_field_offset(lv, s9929c33f1, 16, "S9929C33.s9929c33f1");
    check_field_offset(lv, s9929c33f2, 32, "S9929C33.s9929c33f2");
    check_field_offset(lv, s9929c33f3, 36, "S9929C33.s9929c33f3");
    check_field_offset(lv, s9929c33f4, 40, "S9929C33.s9929c33f4");
    check_field_offset(lv, s9929c33f5, 44, "S9929C33.s9929c33f5");
    check_field_offset(lv, s9929c33f6, 48, "S9929C33.s9929c33f6");
    check_field_offset(lv, s9929c33f7, 52, "S9929C33.s9929c33f7");
    check_field_offset(lv, s9929c33f8, 56, "S9929C33.s9929c33f8");
    check_field_offset(lv, s9929c33f9, 60, "S9929C33.s9929c33f9");
    check_field_offset(lv, s9929c33f10, 64, "S9929C33.s9929c33f10");
  }
}
static Arrange_To_Call_Me vS9929C33(Test_S9929C33, "S9929C33", 68);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9929C1  : S9929C2 , S9929C3 {
  int s9929c1f0;
  char s9929c1f1[16];
  int s9929c1f2[34];
  char s9929c1f3[3];
  int s9929c1f4[2];
  ::S9929C4 s9929c1f5;
  int s9929c1f6;
  int s9929c1f7;
  ::S15308C236 s9929c1f8[7];
  int s9929c1f9;
  int s9929c1f10;
  int s9929c1f11;
  void *s9929c1f12;
  int s9929c1f13;
  void *s9929c1f14[150];
  void *s9929c1f15[16];
  int s9929c1f16;
  ::S9929C30 s9929c1f17[16];
  int s9929c1f18;
  ::S9929C33 s9929c1f19[32];
  int s9929c1f20;
  void *s9929c1f21[64];
  int s9929c1f22;
  int s9929c1f23[32];
  int s9929c1f24[256];
  int s9929c1f25;
  int s9929c1f26;
  int s9929c1f27[16];
  int s9929c1f28;
  int s9929c1f29[16];
  ::S15308C225 s9929c1f30;
  ::S15308C225 s9929c1f31;
  ::S15308C225 s9929c1f32;
  ::S15308C225 s9929c1f33;
  ::S15308C225 s9929c1f34;
  ::S15308C225 s9929c1f35;
  ::S15308C225 s9929c1f36;
  ::S15308C225 s9929c1f37;
  ::S15308C236 s9929c1f38;
  int s9929c1f39;
  int s9929c1f40;
  void *s9929c1f41;
  void *s9929c1f42;
  int s9929c1f43;
  int s9929c1f44;
  int s9929c1f45;
  int s9929c1f46;
  ::S9928C68 s9929c1f47;
  virtual  ~S9929C1(); // _ZN7S9929C1D1Ev
  virtual void  v1(); // _ZN7S9929C12v1Ev
  virtual void  v2(); // _ZN7S9929C12v2Ev
  virtual void  v3(); // _ZN7S9929C12v3Ev
  virtual void  v4(); // _ZN7S9929C12v4Ev
  S9929C1(); // tgen
};
//SIG(1 S9929C1) C1{ BC2{ vd v5 v6 v7 v8 v9} BC3{ vd v10 v11 v12 v13} vd v1 v2 v3 v4 Fi Fc[16] Fi[34] Fc[3] Fi[2] FC4{ m FC5{ BC6{ BC7{ BC8{ BC9{ BC10{ BC11{} FC12{ BC13{}}} FC14{ BC15{}}} FC14} FC16{ BC17{}}} Fp Fi}} FC5 Fc FC18{ BC19{ BC20{ BC11} FC21{ BC22{}}} FU23{ Fc[16] Fp} Fi Fi} FC18[20] Fc} Fi Fi FC24{ BC25{ BC11 FC26{ BC27{}}} Fp Fp Fp}[7] Fi Fi Fi Fp Fi Fp[150] Fp[16] Fi FC28{ m Fc Fp Fi Fi Fi FC29{ BC30{ m Fc Fc[15]}} Fi Fi[10] Fi Fp Fi Fp[24] Fi Fi Fi Fi Fp[4] Fi Fi}[16] Fi FC31{ FC29 FC29 Fi Fi Fi Fi Fi Fi Fi Fi Fc}[32] Fi Fp[64] Fi Fi[32] Fi[256] Fi Fi Fi[16] Fi Fi[16] FC32{ BC33{ BC11 FC26} Fp Fp Fp} FC32 FC32 FC32 FC32 FC32 FC32 FC32 FC24 Fi Fi Fp Fp Fi Fi Fi Fi FC34{ m Fc Fc Fi Fc Fi Fc Fi}}


 S9929C1 ::~S9929C1(){ note_dtor("S9929C1", this);}
void  S9929C1 ::v1(){vfunc_called(this, "_ZN7S9929C12v1Ev");}
void  S9929C1 ::v2(){vfunc_called(this, "_ZN7S9929C12v2Ev");}
void  S9929C1 ::v3(){vfunc_called(this, "_ZN7S9929C12v3Ev");}
void  S9929C1 ::v4(){vfunc_called(this, "_ZN7S9929C12v4Ev");}
S9929C1 ::S9929C1(){ note_ctor("S9929C1", this);} // tgen

static void Test_S9929C1()
{
  extern Class_Descriptor cd_S9929C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(1579,2298)];
    init_test(&cd_S9929C1, buf);
    S9929C1 *dp, &lv = *(dp=new (buf) S9929C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(12624,9188), "sizeof(S9929C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9929C1)");
    check_base_class_offset(lv, (S9929C2*), 0, "S9929C1");
    check_base_class_offset(lv, (S9929C3*), ABISELECT(8,4), "S9929C1");
    check_field_offset(lv, s9929c1f0, ABISELECT(16,8), "S9929C1.s9929c1f0");
    check_field_offset(lv, s9929c1f1, ABISELECT(20,12), "S9929C1.s9929c1f1");
    check_field_offset(lv, s9929c1f2, ABISELECT(36,28), "S9929C1.s9929c1f2");
    check_field_offset(lv, s9929c1f3, ABISELECT(172,164), "S9929C1.s9929c1f3");
    check_field_offset(lv, s9929c1f4, ABISELECT(176,168), "S9929C1.s9929c1f4");
    check_field_offset(lv, s9929c1f5, ABISELECT(184,176), "S9929C1.s9929c1f5");
    check_field_offset(lv, s9929c1f6, ABISELECT(920,796), "S9929C1.s9929c1f6");
    check_field_offset(lv, s9929c1f7, ABISELECT(924,800), "S9929C1.s9929c1f7");
    check_field_offset(lv, s9929c1f8, ABISELECT(928,804), "S9929C1.s9929c1f8");
    check_field_offset(lv, s9929c1f9, ABISELECT(1152,916), "S9929C1.s9929c1f9");
    check_field_offset(lv, s9929c1f10, ABISELECT(1156,920), "S9929C1.s9929c1f10");
    check_field_offset(lv, s9929c1f11, ABISELECT(1160,924), "S9929C1.s9929c1f11");
    check_field_offset(lv, s9929c1f12, ABISELECT(1168,928), "S9929C1.s9929c1f12");
    check_field_offset(lv, s9929c1f13, ABISELECT(1176,932), "S9929C1.s9929c1f13");
    check_field_offset(lv, s9929c1f14, ABISELECT(1184,936), "S9929C1.s9929c1f14");
    check_field_offset(lv, s9929c1f15, ABISELECT(2384,1536), "S9929C1.s9929c1f15");
    check_field_offset(lv, s9929c1f16, ABISELECT(2512,1600), "S9929C1.s9929c1f16");
    check_field_offset(lv, s9929c1f17, ABISELECT(2520,1604), "S9929C1.s9929c1f17");
    check_field_offset(lv, s9929c1f18, ABISELECT(8280,5252), "S9929C1.s9929c1f18");
    check_field_offset(lv, s9929c1f19, ABISELECT(8284,5256), "S9929C1.s9929c1f19");
    check_field_offset(lv, s9929c1f20, ABISELECT(10460,7432), "S9929C1.s9929c1f20");
    check_field_offset(lv, s9929c1f21, ABISELECT(10464,7436), "S9929C1.s9929c1f21");
    check_field_offset(lv, s9929c1f22, ABISELECT(10976,7692), "S9929C1.s9929c1f22");
    check_field_offset(lv, s9929c1f23, ABISELECT(10980,7696), "S9929C1.s9929c1f23");
    check_field_offset(lv, s9929c1f24, ABISELECT(11108,7824), "S9929C1.s9929c1f24");
    check_field_offset(lv, s9929c1f25, ABISELECT(12132,8848), "S9929C1.s9929c1f25");
    check_field_offset(lv, s9929c1f26, ABISELECT(12136,8852), "S9929C1.s9929c1f26");
    check_field_offset(lv, s9929c1f27, ABISELECT(12140,8856), "S9929C1.s9929c1f27");
    check_field_offset(lv, s9929c1f28, ABISELECT(12204,8920), "S9929C1.s9929c1f28");
    check_field_offset(lv, s9929c1f29, ABISELECT(12208,8924), "S9929C1.s9929c1f29");
    check_field_offset(lv, s9929c1f30, ABISELECT(12272,8988), "S9929C1.s9929c1f30");
    check_field_offset(lv, s9929c1f31, ABISELECT(12304,9004), "S9929C1.s9929c1f31");
    check_field_offset(lv, s9929c1f32, ABISELECT(12336,9020), "S9929C1.s9929c1f32");
    check_field_offset(lv, s9929c1f33, ABISELECT(12368,9036), "S9929C1.s9929c1f33");
    check_field_offset(lv, s9929c1f34, ABISELECT(12400,9052), "S9929C1.s9929c1f34");
    check_field_offset(lv, s9929c1f35, ABISELECT(12432,9068), "S9929C1.s9929c1f35");
    check_field_offset(lv, s9929c1f36, ABISELECT(12464,9084), "S9929C1.s9929c1f36");
    check_field_offset(lv, s9929c1f37, ABISELECT(12496,9100), "S9929C1.s9929c1f37");
    check_field_offset(lv, s9929c1f38, ABISELECT(12528,9116), "S9929C1.s9929c1f38");
    check_field_offset(lv, s9929c1f39, ABISELECT(12560,9132), "S9929C1.s9929c1f39");
    check_field_offset(lv, s9929c1f40, ABISELECT(12564,9136), "S9929C1.s9929c1f40");
    check_field_offset(lv, s9929c1f41, ABISELECT(12568,9140), "S9929C1.s9929c1f41");
    check_field_offset(lv, s9929c1f42, ABISELECT(12576,9144), "S9929C1.s9929c1f42");
    check_field_offset(lv, s9929c1f43, ABISELECT(12584,9148), "S9929C1.s9929c1f43");
    check_field_offset(lv, s9929c1f44, ABISELECT(12588,9152), "S9929C1.s9929c1f44");
    check_field_offset(lv, s9929c1f45, ABISELECT(12592,9156), "S9929C1.s9929c1f45");
    check_field_offset(lv, s9929c1f46, ABISELECT(12596,9160), "S9929C1.s9929c1f46");
    check_field_offset(lv, s9929c1f47, ABISELECT(12600,9164), "S9929C1.s9929c1f47");
    test_class_info(&lv, &cd_S9929C1);
    dp->~S9929C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9929C1(Test_S9929C1, "S9929C1", ABISELECT(12624,9188));

#else // __cplusplus

extern void _ZN7S9929C1C1Ev();
extern void _ZN7S9929C1D1Ev();
Name_Map name_map_S9929C1[] = {
  NSPAIR(_ZN7S9929C1C1Ev),
  NSPAIR(_ZN7S9929C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9929C2;
extern VTBL_ENTRY _ZTI7S9929C2[];
extern  VTBL_ENTRY _ZTV7S9929C2[];
extern Class_Descriptor cd_S9929C3;
extern VTBL_ENTRY _ZTI7S9929C3[];
extern  VTBL_ENTRY _ZTV7S9929C3[];
static Base_Class bases_S9929C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9929C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S9929C3,    ABISELECT(8,4), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9929C1[];
extern void _ZN7S9929C1D1Ev();
extern void _ZN7S9929C1D0Ev();
extern void _ZN7S9929C22v5Ev();
extern void _ZN7S9929C22v6Ev();
extern void _ZN7S9929C22v7Ev();
extern void _ZN7S9929C22v8Ev();
extern void _ZN7S9929C22v9Ev();
extern void _ZN7S9929C12v1Ev();
extern void _ZN7S9929C12v2Ev();
extern void _ZN7S9929C12v3Ev();
extern void _ZN7S9929C12v4Ev();
extern void ABISELECT(_ZThn8_N7S9929C1D1Ev,_ZThn4_N7S9929C1D1Ev)();
extern void ABISELECT(_ZThn8_N7S9929C1D0Ev,_ZThn4_N7S9929C1D0Ev)();
extern void _ZN7S9929C33v10Ev();
extern void _ZN7S9929C33v11Ev();
extern void _ZN7S9929C33v12Ev();
extern void _ZN7S9929C33v13Ev();
static  VTBL_ENTRY vtc_S9929C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9929C1[0]),
  (VTBL_ENTRY)&_ZN7S9929C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9929C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9929C22v5Ev,
  (VTBL_ENTRY)&_ZN7S9929C22v6Ev,
  (VTBL_ENTRY)&_ZN7S9929C22v7Ev,
  (VTBL_ENTRY)&_ZN7S9929C22v8Ev,
  (VTBL_ENTRY)&_ZN7S9929C22v9Ev,
  (VTBL_ENTRY)&_ZN7S9929C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9929C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9929C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9929C12v4Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S9929C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9929C1D1Ev,_ZThn4_N7S9929C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N7S9929C1D0Ev,_ZThn4_N7S9929C1D0Ev),
  (VTBL_ENTRY)&_ZN7S9929C33v10Ev,
  (VTBL_ENTRY)&_ZN7S9929C33v11Ev,
  (VTBL_ENTRY)&_ZN7S9929C33v12Ev,
  (VTBL_ENTRY)&_ZN7S9929C33v13Ev,
};
extern VTBL_ENTRY _ZTI7S9929C1[];
extern  VTBL_ENTRY _ZTV7S9929C1[];
Class_Descriptor cd_S9929C1 = {  "S9929C1", // class name
  bases_S9929C1, 2,
  &(vtc_S9929C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(12624,9188), // object size
  NSPAIRA(_ZTI7S9929C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S9929C1),21, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S397C4  : S9509C16_nt {
};
//SIG(-1 S397C4) C1{ BC2{ m Fi}}



static void Test_S397C4()
{
  extern Class_Descriptor cd_S397C4;
  void *lvp;
  {
    int buf[2];
    init_test(&cd_S397C4, buf);
    S397C4 &lv = *(new (buf) S397C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(S397C4)");
    check2(__alignof__(lv), 4, "__alignof__(S397C4)");
    check_base_class_offset(lv, (S9509C16_nt*), 0, "S397C4");
    test_class_info(&lv, &cd_S397C4);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS397C4(Test_S397C4, "S397C4", 4);

#else // __cplusplus

extern Class_Descriptor cd_S9509C16_nt;
extern VTBL_ENTRY _ZTI11S9509C16_nt[];
static Base_Class bases_S397C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9509C16_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S397C4[];
Class_Descriptor cd_S397C4 = {  "S397C4", // class name
  bases_S397C4, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI6S397C4),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S397C3  : S397C4 {
  void *s397c3f0[2];
  char s397c3f1[2];
  ::S4658C31_nt s397c3f2;
  virtual  ~S397C3(); // _ZN6S397C3D1Ev
  virtual void  v9(); // _ZN6S397C32v9Ev
  virtual void  v10(); // _ZN6S397C33v10Ev
  virtual void  v11(); // _ZN6S397C33v11Ev
  virtual void  v12(); // _ZN6S397C33v12Ev
  virtual void  v13(); // _ZN6S397C33v13Ev
  virtual void  v14(); // _ZN6S397C33v14Ev
  virtual void  v15(); // _ZN6S397C33v15Ev
  virtual void  v16(); // _ZN6S397C33v16Ev
  virtual void  v17(); // _ZN6S397C33v17Ev
  virtual void  v18(); // _ZN6S397C33v18Ev
  virtual void  v19(); // _ZN6S397C33v19Ev
  virtual void  v20(); // _ZN6S397C33v20Ev
  virtual void  v21(); // _ZN6S397C33v21Ev
  virtual void  v22(); // _ZN6S397C33v22Ev
  virtual void  v23(); // _ZN6S397C33v23Ev
  virtual void  v24(); // _ZN6S397C33v24Ev
  virtual void  v25(); // _ZN6S397C33v25Ev
  virtual void  v26(); // _ZN6S397C33v26Ev
  virtual void  v27(); // _ZN6S397C33v27Ev
  virtual void  v28(); // _ZN6S397C33v28Ev
  virtual void  v29(); // _ZN6S397C33v29Ev
  virtual void  v30(); // _ZN6S397C33v30Ev
  S397C3(); // tgen
};
//SIG(-1 S397C3) C1{ BC2{ BC3{ m Fi}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fp[2] Fc[2] FC4{ m FC5{ m Fi[2]} FC5}}


 S397C3 ::~S397C3(){ note_dtor("S397C3", this);}
void  S397C3 ::v9(){vfunc_called(this, "_ZN6S397C32v9Ev");}
void  S397C3 ::v10(){vfunc_called(this, "_ZN6S397C33v10Ev");}
void  S397C3 ::v11(){vfunc_called(this, "_ZN6S397C33v11Ev");}
void  S397C3 ::v12(){vfunc_called(this, "_ZN6S397C33v12Ev");}
void  S397C3 ::v13(){vfunc_called(this, "_ZN6S397C33v13Ev");}
void  S397C3 ::v14(){vfunc_called(this, "_ZN6S397C33v14Ev");}
void  S397C3 ::v15(){vfunc_called(this, "_ZN6S397C33v15Ev");}
void  S397C3 ::v16(){vfunc_called(this, "_ZN6S397C33v16Ev");}
void  S397C3 ::v17(){vfunc_called(this, "_ZN6S397C33v17Ev");}
void  S397C3 ::v18(){vfunc_called(this, "_ZN6S397C33v18Ev");}
void  S397C3 ::v19(){vfunc_called(this, "_ZN6S397C33v19Ev");}
void  S397C3 ::v20(){vfunc_called(this, "_ZN6S397C33v20Ev");}
void  S397C3 ::v21(){vfunc_called(this, "_ZN6S397C33v21Ev");}
void  S397C3 ::v22(){vfunc_called(this, "_ZN6S397C33v22Ev");}
void  S397C3 ::v23(){vfunc_called(this, "_ZN6S397C33v23Ev");}
void  S397C3 ::v24(){vfunc_called(this, "_ZN6S397C33v24Ev");}
void  S397C3 ::v25(){vfunc_called(this, "_ZN6S397C33v25Ev");}
void  S397C3 ::v26(){vfunc_called(this, "_ZN6S397C33v26Ev");}
void  S397C3 ::v27(){vfunc_called(this, "_ZN6S397C33v27Ev");}
void  S397C3 ::v28(){vfunc_called(this, "_ZN6S397C33v28Ev");}
void  S397C3 ::v29(){vfunc_called(this, "_ZN6S397C33v29Ev");}
void  S397C3 ::v30(){vfunc_called(this, "_ZN6S397C33v30Ev");}
S397C3 ::S397C3(){ note_ctor("S397C3", this);} // tgen

static void Test_S397C3()
{
  extern Class_Descriptor cd_S397C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,10)];
    init_test(&cd_S397C3, buf);
    S397C3 *dp, &lv = *(dp=new (buf) S397C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,36), "sizeof(S397C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S397C3)");
    check_base_class_offset(lv, (S9509C16_nt*)(S397C4*), ABISELECT(8,4), "S397C3");
    check_base_class_offset(lv, (S397C4*), ABISELECT(8,4), "S397C3");
    check_field_offset(lv, s397c3f0, ABISELECT(16,8), "S397C3.s397c3f0");
    check_field_offset(lv, s397c3f1, ABISELECT(32,16), "S397C3.s397c3f1");
    check_field_offset(lv, s397c3f2, ABISELECT(36,20), "S397C3.s397c3f2");
    test_class_info(&lv, &cd_S397C3);
    dp->~S397C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS397C3(Test_S397C3, "S397C3", ABISELECT(56,36));

#else // __cplusplus

extern void _ZN6S397C3C1Ev();
extern void _ZN6S397C3D1Ev();
Name_Map name_map_S397C3[] = {
  NSPAIR(_ZN6S397C3C1Ev),
  NSPAIR(_ZN6S397C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9509C16_nt;
extern VTBL_ENTRY _ZTI11S9509C16_nt[];
extern Class_Descriptor cd_S397C4;
extern VTBL_ENTRY _ZTI6S397C4[];
static Base_Class bases_S397C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9509C16_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S397C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S397C3[];
extern void _ZN6S397C3D1Ev();
extern void _ZN6S397C3D0Ev();
extern void _ZN6S397C32v9Ev();
extern void _ZN6S397C33v10Ev();
extern void _ZN6S397C33v11Ev();
extern void _ZN6S397C33v12Ev();
extern void _ZN6S397C33v13Ev();
extern void _ZN6S397C33v14Ev();
extern void _ZN6S397C33v15Ev();
extern void _ZN6S397C33v16Ev();
extern void _ZN6S397C33v17Ev();
extern void _ZN6S397C33v18Ev();
extern void _ZN6S397C33v19Ev();
extern void _ZN6S397C33v20Ev();
extern void _ZN6S397C33v21Ev();
extern void _ZN6S397C33v22Ev();
extern void _ZN6S397C33v23Ev();
extern void _ZN6S397C33v24Ev();
extern void _ZN6S397C33v25Ev();
extern void _ZN6S397C33v26Ev();
extern void _ZN6S397C33v27Ev();
extern void _ZN6S397C33v28Ev();
extern void _ZN6S397C33v29Ev();
extern void _ZN6S397C33v30Ev();
static  VTBL_ENTRY vtc_S397C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S397C3[0]),
  (VTBL_ENTRY)&_ZN6S397C3D1Ev,
  (VTBL_ENTRY)&_ZN6S397C3D0Ev,
  (VTBL_ENTRY)&_ZN6S397C32v9Ev,
  (VTBL_ENTRY)&_ZN6S397C33v10Ev,
  (VTBL_ENTRY)&_ZN6S397C33v11Ev,
  (VTBL_ENTRY)&_ZN6S397C33v12Ev,
  (VTBL_ENTRY)&_ZN6S397C33v13Ev,
  (VTBL_ENTRY)&_ZN6S397C33v14Ev,
  (VTBL_ENTRY)&_ZN6S397C33v15Ev,
  (VTBL_ENTRY)&_ZN6S397C33v16Ev,
  (VTBL_ENTRY)&_ZN6S397C33v17Ev,
  (VTBL_ENTRY)&_ZN6S397C33v18Ev,
  (VTBL_ENTRY)&_ZN6S397C33v19Ev,
  (VTBL_ENTRY)&_ZN6S397C33v20Ev,
  (VTBL_ENTRY)&_ZN6S397C33v21Ev,
  (VTBL_ENTRY)&_ZN6S397C33v22Ev,
  (VTBL_ENTRY)&_ZN6S397C33v23Ev,
  (VTBL_ENTRY)&_ZN6S397C33v24Ev,
  (VTBL_ENTRY)&_ZN6S397C33v25Ev,
  (VTBL_ENTRY)&_ZN6S397C33v26Ev,
  (VTBL_ENTRY)&_ZN6S397C33v27Ev,
  (VTBL_ENTRY)&_ZN6S397C33v28Ev,
  (VTBL_ENTRY)&_ZN6S397C33v29Ev,
  (VTBL_ENTRY)&_ZN6S397C33v30Ev,
};
extern VTBL_ENTRY _ZTI6S397C3[];
extern  VTBL_ENTRY _ZTV6S397C3[];
Class_Descriptor cd_S397C3 = {  "S397C3", // class name
  bases_S397C3, 2,
  &(vtc_S397C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,36), // object size
  NSPAIRA(_ZTI6S397C3),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6S397C3),26, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S397C9  {
  virtual  ~S397C9(); // _ZN6S397C9D1Ev
  virtual void  v31(); // _ZN6S397C93v31Ev
  virtual void  v32(); // _ZN6S397C93v32Ev
  virtual void  v33(); // _ZN6S397C93v33Ev
  virtual void  v34(); // _ZN6S397C93v34Ev
  virtual void  v35(); // _ZN6S397C93v35Ev
  virtual void  v36(); // _ZN6S397C93v36Ev
  virtual void  v37(); // _ZN6S397C93v37Ev
  virtual void  v38(); // _ZN6S397C93v38Ev
  virtual void  v39(); // _ZN6S397C93v39Ev
  virtual void  v40(); // _ZN6S397C93v40Ev
  virtual void  v41(); // _ZN6S397C93v41Ev
  virtual void  v42(); // _ZN6S397C93v42Ev
  virtual void  v43(); // _ZN6S397C93v43Ev
  virtual void  v44(); // _ZN6S397C93v44Ev
  virtual void  v45(); // _ZN6S397C93v45Ev
  virtual void  v46(); // _ZN6S397C93v46Ev
  virtual void  v47(); // _ZN6S397C93v47Ev
  virtual void  v48(); // _ZN6S397C93v48Ev
  virtual void  v49(); // _ZN6S397C93v49Ev
  virtual void  v50(); // _ZN6S397C93v50Ev
  virtual void  v51(); // _ZN6S397C93v51Ev
  virtual void  v52(); // _ZN6S397C93v52Ev
  virtual void  v53(); // _ZN6S397C93v53Ev
  virtual void  v54(); // _ZN6S397C93v54Ev
  virtual void  v55(); // _ZN6S397C93v55Ev
  virtual void  v56(); // _ZN6S397C93v56Ev
  virtual void  v57(); // _ZN6S397C93v57Ev
  virtual void  v58(); // _ZN6S397C93v58Ev
  virtual void  v59(); // _ZN6S397C93v59Ev
  virtual void  v60(); // _ZN6S397C93v60Ev
  virtual void  v61(); // _ZN6S397C93v61Ev
  virtual void  v62(); // _ZN6S397C93v62Ev
  S397C9(); // tgen
};
//SIG(-1 S397C9) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32}


 S397C9 ::~S397C9(){ note_dtor("S397C9", this);}
void  S397C9 ::v31(){vfunc_called(this, "_ZN6S397C93v31Ev");}
void  S397C9 ::v32(){vfunc_called(this, "_ZN6S397C93v32Ev");}
void  S397C9 ::v33(){vfunc_called(this, "_ZN6S397C93v33Ev");}
void  S397C9 ::v34(){vfunc_called(this, "_ZN6S397C93v34Ev");}
void  S397C9 ::v35(){vfunc_called(this, "_ZN6S397C93v35Ev");}
void  S397C9 ::v36(){vfunc_called(this, "_ZN6S397C93v36Ev");}
void  S397C9 ::v37(){vfunc_called(this, "_ZN6S397C93v37Ev");}
void  S397C9 ::v38(){vfunc_called(this, "_ZN6S397C93v38Ev");}
void  S397C9 ::v39(){vfunc_called(this, "_ZN6S397C93v39Ev");}
void  S397C9 ::v40(){vfunc_called(this, "_ZN6S397C93v40Ev");}
void  S397C9 ::v41(){vfunc_called(this, "_ZN6S397C93v41Ev");}
void  S397C9 ::v42(){vfunc_called(this, "_ZN6S397C93v42Ev");}
void  S397C9 ::v43(){vfunc_called(this, "_ZN6S397C93v43Ev");}
void  S397C9 ::v44(){vfunc_called(this, "_ZN6S397C93v44Ev");}
void  S397C9 ::v45(){vfunc_called(this, "_ZN6S397C93v45Ev");}
void  S397C9 ::v46(){vfunc_called(this, "_ZN6S397C93v46Ev");}
void  S397C9 ::v47(){vfunc_called(this, "_ZN6S397C93v47Ev");}
void  S397C9 ::v48(){vfunc_called(this, "_ZN6S397C93v48Ev");}
void  S397C9 ::v49(){vfunc_called(this, "_ZN6S397C93v49Ev");}
void  S397C9 ::v50(){vfunc_called(this, "_ZN6S397C93v50Ev");}
void  S397C9 ::v51(){vfunc_called(this, "_ZN6S397C93v51Ev");}
void  S397C9 ::v52(){vfunc_called(this, "_ZN6S397C93v52Ev");}
void  S397C9 ::v53(){vfunc_called(this, "_ZN6S397C93v53Ev");}
void  S397C9 ::v54(){vfunc_called(this, "_ZN6S397C93v54Ev");}
void  S397C9 ::v55(){vfunc_called(this, "_ZN6S397C93v55Ev");}
void  S397C9 ::v56(){vfunc_called(this, "_ZN6S397C93v56Ev");}
void  S397C9 ::v57(){vfunc_called(this, "_ZN6S397C93v57Ev");}
void  S397C9 ::v58(){vfunc_called(this, "_ZN6S397C93v58Ev");}
void  S397C9 ::v59(){vfunc_called(this, "_ZN6S397C93v59Ev");}
void  S397C9 ::v60(){vfunc_called(this, "_ZN6S397C93v60Ev");}
void  S397C9 ::v61(){vfunc_called(this, "_ZN6S397C93v61Ev");}
void  S397C9 ::v62(){vfunc_called(this, "_ZN6S397C93v62Ev");}
S397C9 ::S397C9(){ note_ctor("S397C9", this);} // tgen

static void Test_S397C9()
{
  extern Class_Descriptor cd_S397C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S397C9, buf);
    S397C9 *dp, &lv = *(dp=new (buf) S397C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S397C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S397C9)");
    test_class_info(&lv, &cd_S397C9);
    dp->~S397C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS397C9(Test_S397C9, "S397C9", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN6S397C9C1Ev();
extern void _ZN6S397C9D1Ev();
Name_Map name_map_S397C9[] = {
  NSPAIR(_ZN6S397C9C1Ev),
  NSPAIR(_ZN6S397C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S397C9[];
extern void _ZN6S397C9D1Ev();
extern void _ZN6S397C9D0Ev();
extern void _ZN6S397C93v31Ev();
extern void _ZN6S397C93v32Ev();
extern void _ZN6S397C93v33Ev();
extern void _ZN6S397C93v34Ev();
extern void _ZN6S397C93v35Ev();
extern void _ZN6S397C93v36Ev();
extern void _ZN6S397C93v37Ev();
extern void _ZN6S397C93v38Ev();
extern void _ZN6S397C93v39Ev();
extern void _ZN6S397C93v40Ev();
extern void _ZN6S397C93v41Ev();
extern void _ZN6S397C93v42Ev();
extern void _ZN6S397C93v43Ev();
extern void _ZN6S397C93v44Ev();
extern void _ZN6S397C93v45Ev();
extern void _ZN6S397C93v46Ev();
extern void _ZN6S397C93v47Ev();
extern void _ZN6S397C93v48Ev();
extern void _ZN6S397C93v49Ev();
extern void _ZN6S397C93v50Ev();
extern void _ZN6S397C93v51Ev();
extern void _ZN6S397C93v52Ev();
extern void _ZN6S397C93v53Ev();
extern void _ZN6S397C93v54Ev();
extern void _ZN6S397C93v55Ev();
extern void _ZN6S397C93v56Ev();
extern void _ZN6S397C93v57Ev();
extern void _ZN6S397C93v58Ev();
extern void _ZN6S397C93v59Ev();
extern void _ZN6S397C93v60Ev();
extern void _ZN6S397C93v61Ev();
extern void _ZN6S397C93v62Ev();
static  VTBL_ENTRY vtc_S397C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S397C9[0]),
  (VTBL_ENTRY)&_ZN6S397C9D1Ev,
  (VTBL_ENTRY)&_ZN6S397C9D0Ev,
  (VTBL_ENTRY)&_ZN6S397C93v31Ev,
  (VTBL_ENTRY)&_ZN6S397C93v32Ev,
  (VTBL_ENTRY)&_ZN6S397C93v33Ev,
  (VTBL_ENTRY)&_ZN6S397C93v34Ev,
  (VTBL_ENTRY)&_ZN6S397C93v35Ev,
  (VTBL_ENTRY)&_ZN6S397C93v36Ev,
  (VTBL_ENTRY)&_ZN6S397C93v37Ev,
  (VTBL_ENTRY)&_ZN6S397C93v38Ev,
  (VTBL_ENTRY)&_ZN6S397C93v39Ev,
  (VTBL_ENTRY)&_ZN6S397C93v40Ev,
  (VTBL_ENTRY)&_ZN6S397C93v41Ev,
  (VTBL_ENTRY)&_ZN6S397C93v42Ev,
  (VTBL_ENTRY)&_ZN6S397C93v43Ev,
  (VTBL_ENTRY)&_ZN6S397C93v44Ev,
  (VTBL_ENTRY)&_ZN6S397C93v45Ev,
  (VTBL_ENTRY)&_ZN6S397C93v46Ev,
  (VTBL_ENTRY)&_ZN6S397C93v47Ev,
  (VTBL_ENTRY)&_ZN6S397C93v48Ev,
  (VTBL_ENTRY)&_ZN6S397C93v49Ev,
  (VTBL_ENTRY)&_ZN6S397C93v50Ev,
  (VTBL_ENTRY)&_ZN6S397C93v51Ev,
  (VTBL_ENTRY)&_ZN6S397C93v52Ev,
  (VTBL_ENTRY)&_ZN6S397C93v53Ev,
  (VTBL_ENTRY)&_ZN6S397C93v54Ev,
  (VTBL_ENTRY)&_ZN6S397C93v55Ev,
  (VTBL_ENTRY)&_ZN6S397C93v56Ev,
  (VTBL_ENTRY)&_ZN6S397C93v57Ev,
  (VTBL_ENTRY)&_ZN6S397C93v58Ev,
  (VTBL_ENTRY)&_ZN6S397C93v59Ev,
  (VTBL_ENTRY)&_ZN6S397C93v60Ev,
  (VTBL_ENTRY)&_ZN6S397C93v61Ev,
  (VTBL_ENTRY)&_ZN6S397C93v62Ev,
};
extern VTBL_ENTRY _ZTI6S397C9[];
extern  VTBL_ENTRY _ZTV6S397C9[];
Class_Descriptor cd_S397C9 = {  "S397C9", // class name
  0,0,//no base classes
  &(vtc_S397C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI6S397C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S397C9),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S397C11_nt  {
  __tsi64 s397c11f0[2];
  int s397c11f1[2];
  virtual  ~S397C11_nt(); // _ZN10S397C11_ntD1Ev
  virtual void  v109(); // _ZN10S397C11_nt4v109Ev
  S397C11_nt(); // tgen
};
//SIG(-1 S397C11_nt) C1{ vd v1 FL[2] Fi[2]}


 S397C11_nt ::~S397C11_nt(){ note_dtor("S397C11_nt", this);}
void  S397C11_nt ::v109(){vfunc_called(this, "_ZN10S397C11_nt4v109Ev");}
S397C11_nt ::S397C11_nt(){ note_ctor("S397C11_nt", this);} // tgen

//skip512 S397C11_nt

#else // __cplusplus

extern void _ZN10S397C11_ntC1Ev();
extern void _ZN10S397C11_ntD1Ev();
Name_Map name_map_S397C11_nt[] = {
  NSPAIR(_ZN10S397C11_ntC1Ev),
  NSPAIR(_ZN10S397C11_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S397C11_nt[];
extern void _ZN10S397C11_ntD1Ev();
extern void _ZN10S397C11_ntD0Ev();
extern void _ZN10S397C11_nt4v109Ev();
static  VTBL_ENTRY vtc_S397C11_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S397C11_nt[0]),
  (VTBL_ENTRY)&_ZN10S397C11_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S397C11_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S397C11_nt4v109Ev,
};
extern VTBL_ENTRY _ZTI10S397C11_nt[];
VTBL_ENTRY *P__ZTI10S397C11_nt = _ZTI10S397C11_nt; 
extern  VTBL_ENTRY _ZTV10S397C11_nt[];
Class_Descriptor cd_S397C11_nt = {  "S397C11_nt", // class name
  0,0,//no base classes
  &(vtc_S397C11_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,28), // object size
  NSPAIRA(_ZTI10S397C11_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S397C11_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S397C10_nt  : S397C11_nt {
  void *s397c10f0;
  ::S15308C228 s397c10f1;
  virtual void  v108(); // _ZN10S397C10_nt4v108Ev
  ~S397C10_nt(); // tgen
  S397C10_nt(); // tgen
};
//SIG(-1 S397C10_nt) C1{ BC2{ vd v2 FL[2] Fi[2]} v1 Fp FC3{}}


void  S397C10_nt ::v108(){vfunc_called(this, "_ZN10S397C10_nt4v108Ev");}
S397C10_nt ::~S397C10_nt(){ note_dtor("S397C10_nt", this);} // tgen
S397C10_nt ::S397C10_nt(){ note_ctor("S397C10_nt", this);} // tgen

//skip512 S397C10_nt

#else // __cplusplus

extern void _ZN10S397C10_ntC1Ev();
extern void _ZN10S397C10_ntD1Ev();
Name_Map name_map_S397C10_nt[] = {
  NSPAIR(_ZN10S397C10_ntC1Ev),
  NSPAIR(_ZN10S397C10_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S397C11_nt;
extern VTBL_ENTRY _ZTI10S397C11_nt[];
extern  VTBL_ENTRY _ZTV10S397C11_nt[];
static Base_Class bases_S397C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S397C11_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S397C10_nt[];
extern void _ZN10S397C10_ntD1Ev();
extern void _ZN10S397C10_ntD0Ev();
extern void _ZN10S397C11_nt4v109Ev();
extern void _ZN10S397C10_nt4v108Ev();
static  VTBL_ENTRY vtc_S397C10_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S397C10_nt[0]),
  (VTBL_ENTRY)&_ZN10S397C10_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S397C10_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S397C11_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S397C10_nt4v108Ev,
};
extern VTBL_ENTRY _ZTI10S397C10_nt[];
VTBL_ENTRY *P__ZTI10S397C10_nt = _ZTI10S397C10_nt; 
extern  VTBL_ENTRY _ZTV10S397C10_nt[];
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S397C2  : S397C3 , S397C9 {
  void *s397c2f0;
  int s397c2f1[2];
  void *s397c2f2;
  int s397c2f3[10];
  char s397c2f4;
  int s397c2f5;
  char s397c2f6;
  ::S397C10_nt s397c2f7;
  char s397c2f8[2];
  virtual  ~S397C2(); // _ZN6S397C2D1Ev
  virtual void  v63(); // _ZN6S397C23v63Ev
  virtual void  v64(); // _ZN6S397C23v64Ev
  virtual void  v65(); // _ZN6S397C23v65Ev
  virtual void  v66(); // _ZN6S397C23v66Ev
  virtual void  v67(); // _ZN6S397C23v67Ev
  virtual void  v68(); // _ZN6S397C23v68Ev
  virtual void  v69(); // _ZN6S397C23v69Ev
  virtual void  v70(); // _ZN6S397C23v70Ev
  virtual void  v71(); // _ZN6S397C23v71Ev
  virtual void  v72(); // _ZN6S397C23v72Ev
  virtual void  v73(); // _ZN6S397C23v73Ev
  virtual void  v74(); // _ZN6S397C23v74Ev
  virtual void  v75(); // _ZN6S397C23v75Ev
  virtual void  v76(); // _ZN6S397C23v76Ev
  virtual void  v77(); // _ZN6S397C23v77Ev
  virtual void  v78(); // _ZN6S397C23v78Ev
  virtual void  v79(); // _ZN6S397C23v79Ev
  virtual void  v80(); // _ZN6S397C23v80Ev
  virtual void  v81(); // _ZN6S397C23v81Ev
  virtual void  v82(); // _ZN6S397C23v82Ev
  virtual void  v83(); // _ZN6S397C23v83Ev
  virtual void  v84(); // _ZN6S397C23v84Ev
  virtual void  v85(); // _ZN6S397C23v85Ev
  virtual void  v86(); // _ZN6S397C23v86Ev
  virtual void  v87(); // _ZN6S397C23v87Ev
  virtual void  v88(); // _ZN6S397C23v88Ev
  virtual void  v89(); // _ZN6S397C23v89Ev
  virtual void  v90(); // _ZN6S397C23v90Ev
  virtual void  v91(); // _ZN6S397C23v91Ev
  virtual void  v92(); // _ZN6S397C23v92Ev
  virtual void  v93(); // _ZN6S397C23v93Ev
  virtual void  v94(); // _ZN6S397C23v94Ev
  virtual void  v95(); // _ZN6S397C23v95Ev
  virtual void  v96(); // _ZN6S397C23v96Ev
  virtual void  v97(); // _ZN6S397C23v97Ev
  virtual void  v98(); // _ZN6S397C23v98Ev
  virtual void  v99(); // _ZN6S397C23v99Ev
  virtual void  v100(); // _ZN6S397C24v100Ev
  virtual void  v101(); // _ZN6S397C24v101Ev
  virtual void  v102(); // _ZN6S397C24v102Ev
  virtual void  v103(); // _ZN6S397C24v103Ev
  virtual void  v104(); // _ZN6S397C24v104Ev
  virtual void  v105(); // _ZN6S397C24v105Ev
  virtual void  v106(); // _ZN6S397C24v106Ev
  virtual void  v107(); // _ZN6S397C24v107Ev
  S397C2(); // tgen
};
//SIG(-1 S397C2) C1{ BC2{ BC3{ BC4{ m Fi}} vd v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fp[2] Fc[2] FC5{ m FC6{ m Fi[2]} FC6}} BC7{ vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 Fp Fi[2] Fp Fi[10] Fc Fi Fc FC8{ BC9{ vd v101 FL[2] Fi[2]} v100 Fp FC10{}} Fc[2]}


 S397C2 ::~S397C2(){ note_dtor("S397C2", this);}
void  S397C2 ::v63(){vfunc_called(this, "_ZN6S397C23v63Ev");}
void  S397C2 ::v64(){vfunc_called(this, "_ZN6S397C23v64Ev");}
void  S397C2 ::v65(){vfunc_called(this, "_ZN6S397C23v65Ev");}
void  S397C2 ::v66(){vfunc_called(this, "_ZN6S397C23v66Ev");}
void  S397C2 ::v67(){vfunc_called(this, "_ZN6S397C23v67Ev");}
void  S397C2 ::v68(){vfunc_called(this, "_ZN6S397C23v68Ev");}
void  S397C2 ::v69(){vfunc_called(this, "_ZN6S397C23v69Ev");}
void  S397C2 ::v70(){vfunc_called(this, "_ZN6S397C23v70Ev");}
void  S397C2 ::v71(){vfunc_called(this, "_ZN6S397C23v71Ev");}
void  S397C2 ::v72(){vfunc_called(this, "_ZN6S397C23v72Ev");}
void  S397C2 ::v73(){vfunc_called(this, "_ZN6S397C23v73Ev");}
void  S397C2 ::v74(){vfunc_called(this, "_ZN6S397C23v74Ev");}
void  S397C2 ::v75(){vfunc_called(this, "_ZN6S397C23v75Ev");}
void  S397C2 ::v76(){vfunc_called(this, "_ZN6S397C23v76Ev");}
void  S397C2 ::v77(){vfunc_called(this, "_ZN6S397C23v77Ev");}
void  S397C2 ::v78(){vfunc_called(this, "_ZN6S397C23v78Ev");}
void  S397C2 ::v79(){vfunc_called(this, "_ZN6S397C23v79Ev");}
void  S397C2 ::v80(){vfunc_called(this, "_ZN6S397C23v80Ev");}
void  S397C2 ::v81(){vfunc_called(this, "_ZN6S397C23v81Ev");}
void  S397C2 ::v82(){vfunc_called(this, "_ZN6S397C23v82Ev");}
void  S397C2 ::v83(){vfunc_called(this, "_ZN6S397C23v83Ev");}
void  S397C2 ::v84(){vfunc_called(this, "_ZN6S397C23v84Ev");}
void  S397C2 ::v85(){vfunc_called(this, "_ZN6S397C23v85Ev");}
void  S397C2 ::v86(){vfunc_called(this, "_ZN6S397C23v86Ev");}
void  S397C2 ::v87(){vfunc_called(this, "_ZN6S397C23v87Ev");}
void  S397C2 ::v88(){vfunc_called(this, "_ZN6S397C23v88Ev");}
void  S397C2 ::v89(){vfunc_called(this, "_ZN6S397C23v89Ev");}
void  S397C2 ::v90(){vfunc_called(this, "_ZN6S397C23v90Ev");}
void  S397C2 ::v91(){vfunc_called(this, "_ZN6S397C23v91Ev");}
void  S397C2 ::v92(){vfunc_called(this, "_ZN6S397C23v92Ev");}
void  S397C2 ::v93(){vfunc_called(this, "_ZN6S397C23v93Ev");}
void  S397C2 ::v94(){vfunc_called(this, "_ZN6S397C23v94Ev");}
void  S397C2 ::v95(){vfunc_called(this, "_ZN6S397C23v95Ev");}
void  S397C2 ::v96(){vfunc_called(this, "_ZN6S397C23v96Ev");}
void  S397C2 ::v97(){vfunc_called(this, "_ZN6S397C23v97Ev");}
void  S397C2 ::v98(){vfunc_called(this, "_ZN6S397C23v98Ev");}
void  S397C2 ::v99(){vfunc_called(this, "_ZN6S397C23v99Ev");}
void  S397C2 ::v100(){vfunc_called(this, "_ZN6S397C24v100Ev");}
void  S397C2 ::v101(){vfunc_called(this, "_ZN6S397C24v101Ev");}
void  S397C2 ::v102(){vfunc_called(this, "_ZN6S397C24v102Ev");}
void  S397C2 ::v103(){vfunc_called(this, "_ZN6S397C24v103Ev");}
void  S397C2 ::v104(){vfunc_called(this, "_ZN6S397C24v104Ev");}
void  S397C2 ::v105(){vfunc_called(this, "_ZN6S397C24v105Ev");}
void  S397C2 ::v106(){vfunc_called(this, "_ZN6S397C24v106Ev");}
void  S397C2 ::v107(){vfunc_called(this, "_ZN6S397C24v107Ev");}
S397C2 ::S397C2(){ note_ctor("S397C2", this);} // tgen

static void Test_S397C2()
{
  extern Class_Descriptor cd_S397C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,38)];
    init_test(&cd_S397C2, buf);
    S397C2 *dp, &lv = *(dp=new (buf) S397C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,148), "sizeof(S397C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S397C2)");
    check_base_class_offset(lv, (S9509C16_nt*)(S397C4*)(S397C3*), ABISELECT(8,4), "S397C2");
    check_base_class_offset(lv, (S397C4*)(S397C3*), ABISELECT(8,4), "S397C2");
    check_base_class_offset(lv, (S397C3*), 0, "S397C2");
    check_base_class_offset(lv, (S397C9*), ABISELECT(56,36), "S397C2");
    check_field_offset(lv, s397c2f0, ABISELECT(64,40), "S397C2.s397c2f0");
    check_field_offset(lv, s397c2f1, ABISELECT(72,44), "S397C2.s397c2f1");
    check_field_offset(lv, s397c2f2, ABISELECT(80,52), "S397C2.s397c2f2");
    check_field_offset(lv, s397c2f3, ABISELECT(88,56), "S397C2.s397c2f3");
    check_field_offset(lv, s397c2f4, ABISELECT(128,96), "S397C2.s397c2f4");
    check_field_offset(lv, s397c2f5, ABISELECT(132,100), "S397C2.s397c2f5");
    check_field_offset(lv, s397c2f6, ABISELECT(136,104), "S397C2.s397c2f6");
    check_field_offset(lv, s397c2f7, ABISELECT(144,108), "S397C2.s397c2f7");
    check_field_offset(lv, s397c2f8, ABISELECT(192,144), "S397C2.s397c2f8");
    test_class_info(&lv, &cd_S397C2);
    dp->~S397C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS397C2(Test_S397C2, "S397C2", ABISELECT(200,148));

#else // __cplusplus

extern void _ZN6S397C2C1Ev();
extern void _ZN6S397C2D1Ev();
Name_Map name_map_S397C2[] = {
  NSPAIR(_ZN6S397C2C1Ev),
  NSPAIR(_ZN6S397C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9509C16_nt;
extern VTBL_ENTRY _ZTI11S9509C16_nt[];
extern Class_Descriptor cd_S397C4;
extern VTBL_ENTRY _ZTI6S397C4[];
extern Class_Descriptor cd_S397C3;
extern VTBL_ENTRY _ZTI6S397C3[];
extern  VTBL_ENTRY _ZTV6S397C3[];
extern Class_Descriptor cd_S397C9;
extern VTBL_ENTRY _ZTI6S397C9[];
extern  VTBL_ENTRY _ZTV6S397C9[];
static Base_Class bases_S397C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9509C16_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S397C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S397C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S397C9,    ABISELECT(56,36), //bcp->offset
    71, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S397C2[];
extern void _ZN6S397C2D1Ev();
extern void _ZN6S397C2D0Ev();
extern void _ZN6S397C32v9Ev();
extern void _ZN6S397C33v10Ev();
extern void _ZN6S397C33v11Ev();
extern void _ZN6S397C33v12Ev();
extern void _ZN6S397C33v13Ev();
extern void _ZN6S397C33v14Ev();
extern void _ZN6S397C33v15Ev();
extern void _ZN6S397C33v16Ev();
extern void _ZN6S397C33v17Ev();
extern void _ZN6S397C33v18Ev();
extern void _ZN6S397C33v19Ev();
extern void _ZN6S397C33v20Ev();
extern void _ZN6S397C33v21Ev();
extern void _ZN6S397C33v22Ev();
extern void _ZN6S397C33v23Ev();
extern void _ZN6S397C33v24Ev();
extern void _ZN6S397C33v25Ev();
extern void _ZN6S397C33v26Ev();
extern void _ZN6S397C33v27Ev();
extern void _ZN6S397C33v28Ev();
extern void _ZN6S397C33v29Ev();
extern void _ZN6S397C33v30Ev();
extern void _ZN6S397C23v63Ev();
extern void _ZN6S397C23v64Ev();
extern void _ZN6S397C23v65Ev();
extern void _ZN6S397C23v66Ev();
extern void _ZN6S397C23v67Ev();
extern void _ZN6S397C23v68Ev();
extern void _ZN6S397C23v69Ev();
extern void _ZN6S397C23v70Ev();
extern void _ZN6S397C23v71Ev();
extern void _ZN6S397C23v72Ev();
extern void _ZN6S397C23v73Ev();
extern void _ZN6S397C23v74Ev();
extern void _ZN6S397C23v75Ev();
extern void _ZN6S397C23v76Ev();
extern void _ZN6S397C23v77Ev();
extern void _ZN6S397C23v78Ev();
extern void _ZN6S397C23v79Ev();
extern void _ZN6S397C23v80Ev();
extern void _ZN6S397C23v81Ev();
extern void _ZN6S397C23v82Ev();
extern void _ZN6S397C23v83Ev();
extern void _ZN6S397C23v84Ev();
extern void _ZN6S397C23v85Ev();
extern void _ZN6S397C23v86Ev();
extern void _ZN6S397C23v87Ev();
extern void _ZN6S397C23v88Ev();
extern void _ZN6S397C23v89Ev();
extern void _ZN6S397C23v90Ev();
extern void _ZN6S397C23v91Ev();
extern void _ZN6S397C23v92Ev();
extern void _ZN6S397C23v93Ev();
extern void _ZN6S397C23v94Ev();
extern void _ZN6S397C23v95Ev();
extern void _ZN6S397C23v96Ev();
extern void _ZN6S397C23v97Ev();
extern void _ZN6S397C23v98Ev();
extern void _ZN6S397C23v99Ev();
extern void _ZN6S397C24v100Ev();
extern void _ZN6S397C24v101Ev();
extern void _ZN6S397C24v102Ev();
extern void _ZN6S397C24v103Ev();
extern void _ZN6S397C24v104Ev();
extern void _ZN6S397C24v105Ev();
extern void _ZN6S397C24v106Ev();
extern void _ZN6S397C24v107Ev();
extern void ABISELECT(_ZThn56_N6S397C2D1Ev,_ZThn36_N6S397C2D1Ev)();
extern void ABISELECT(_ZThn56_N6S397C2D0Ev,_ZThn36_N6S397C2D0Ev)();
extern void _ZN6S397C93v31Ev();
extern void _ZN6S397C93v32Ev();
extern void _ZN6S397C93v33Ev();
extern void _ZN6S397C93v34Ev();
extern void _ZN6S397C93v35Ev();
extern void _ZN6S397C93v36Ev();
extern void _ZN6S397C93v37Ev();
extern void _ZN6S397C93v38Ev();
extern void _ZN6S397C93v39Ev();
extern void _ZN6S397C93v40Ev();
extern void _ZN6S397C93v41Ev();
extern void _ZN6S397C93v42Ev();
extern void _ZN6S397C93v43Ev();
extern void _ZN6S397C93v44Ev();
extern void _ZN6S397C93v45Ev();
extern void _ZN6S397C93v46Ev();
extern void _ZN6S397C93v47Ev();
extern void _ZN6S397C93v48Ev();
extern void _ZN6S397C93v49Ev();
extern void _ZN6S397C93v50Ev();
extern void _ZN6S397C93v51Ev();
extern void _ZN6S397C93v52Ev();
extern void _ZN6S397C93v53Ev();
extern void _ZN6S397C93v54Ev();
extern void _ZN6S397C93v55Ev();
extern void _ZN6S397C93v56Ev();
extern void _ZN6S397C93v57Ev();
extern void _ZN6S397C93v58Ev();
extern void _ZN6S397C93v59Ev();
extern void _ZN6S397C93v60Ev();
extern void _ZN6S397C93v61Ev();
extern void _ZN6S397C93v62Ev();
static  VTBL_ENTRY vtc_S397C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S397C2[0]),
  (VTBL_ENTRY)&_ZN6S397C2D1Ev,
  (VTBL_ENTRY)&_ZN6S397C2D0Ev,
  (VTBL_ENTRY)&_ZN6S397C32v9Ev,
  (VTBL_ENTRY)&_ZN6S397C33v10Ev,
  (VTBL_ENTRY)&_ZN6S397C33v11Ev,
  (VTBL_ENTRY)&_ZN6S397C33v12Ev,
  (VTBL_ENTRY)&_ZN6S397C33v13Ev,
  (VTBL_ENTRY)&_ZN6S397C33v14Ev,
  (VTBL_ENTRY)&_ZN6S397C33v15Ev,
  (VTBL_ENTRY)&_ZN6S397C33v16Ev,
  (VTBL_ENTRY)&_ZN6S397C33v17Ev,
  (VTBL_ENTRY)&_ZN6S397C33v18Ev,
  (VTBL_ENTRY)&_ZN6S397C33v19Ev,
  (VTBL_ENTRY)&_ZN6S397C33v20Ev,
  (VTBL_ENTRY)&_ZN6S397C33v21Ev,
  (VTBL_ENTRY)&_ZN6S397C33v22Ev,
  (VTBL_ENTRY)&_ZN6S397C33v23Ev,
  (VTBL_ENTRY)&_ZN6S397C33v24Ev,
  (VTBL_ENTRY)&_ZN6S397C33v25Ev,
  (VTBL_ENTRY)&_ZN6S397C33v26Ev,
  (VTBL_ENTRY)&_ZN6S397C33v27Ev,
  (VTBL_ENTRY)&_ZN6S397C33v28Ev,
  (VTBL_ENTRY)&_ZN6S397C33v29Ev,
  (VTBL_ENTRY)&_ZN6S397C33v30Ev,
  (VTBL_ENTRY)&_ZN6S397C23v63Ev,
  (VTBL_ENTRY)&_ZN6S397C23v64Ev,
  (VTBL_ENTRY)&_ZN6S397C23v65Ev,
  (VTBL_ENTRY)&_ZN6S397C23v66Ev,
  (VTBL_ENTRY)&_ZN6S397C23v67Ev,
  (VTBL_ENTRY)&_ZN6S397C23v68Ev,
  (VTBL_ENTRY)&_ZN6S397C23v69Ev,
  (VTBL_ENTRY)&_ZN6S397C23v70Ev,
  (VTBL_ENTRY)&_ZN6S397C23v71Ev,
  (VTBL_ENTRY)&_ZN6S397C23v72Ev,
  (VTBL_ENTRY)&_ZN6S397C23v73Ev,
  (VTBL_ENTRY)&_ZN6S397C23v74Ev,
  (VTBL_ENTRY)&_ZN6S397C23v75Ev,
  (VTBL_ENTRY)&_ZN6S397C23v76Ev,
  (VTBL_ENTRY)&_ZN6S397C23v77Ev,
  (VTBL_ENTRY)&_ZN6S397C23v78Ev,
  (VTBL_ENTRY)&_ZN6S397C23v79Ev,
  (VTBL_ENTRY)&_ZN6S397C23v80Ev,
  (VTBL_ENTRY)&_ZN6S397C23v81Ev,
  (VTBL_ENTRY)&_ZN6S397C23v82Ev,
  (VTBL_ENTRY)&_ZN6S397C23v83Ev,
  (VTBL_ENTRY)&_ZN6S397C23v84Ev,
  (VTBL_ENTRY)&_ZN6S397C23v85Ev,
  (VTBL_ENTRY)&_ZN6S397C23v86Ev,
  (VTBL_ENTRY)&_ZN6S397C23v87Ev,
  (VTBL_ENTRY)&_ZN6S397C23v88Ev,
  (VTBL_ENTRY)&_ZN6S397C23v89Ev,
  (VTBL_ENTRY)&_ZN6S397C23v90Ev,
  (VTBL_ENTRY)&_ZN6S397C23v91Ev,
  (VTBL_ENTRY)&_ZN6S397C23v92Ev,
  (VTBL_ENTRY)&_ZN6S397C23v93Ev,
  (VTBL_ENTRY)&_ZN6S397C23v94Ev,
  (VTBL_ENTRY)&_ZN6S397C23v95Ev,
  (VTBL_ENTRY)&_ZN6S397C23v96Ev,
  (VTBL_ENTRY)&_ZN6S397C23v97Ev,
  (VTBL_ENTRY)&_ZN6S397C23v98Ev,
  (VTBL_ENTRY)&_ZN6S397C23v99Ev,
  (VTBL_ENTRY)&_ZN6S397C24v100Ev,
  (VTBL_ENTRY)&_ZN6S397C24v101Ev,
  (VTBL_ENTRY)&_ZN6S397C24v102Ev,
  (VTBL_ENTRY)&_ZN6S397C24v103Ev,
  (VTBL_ENTRY)&_ZN6S397C24v104Ev,
  (VTBL_ENTRY)&_ZN6S397C24v105Ev,
  (VTBL_ENTRY)&_ZN6S397C24v106Ev,
  (VTBL_ENTRY)&_ZN6S397C24v107Ev,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI6S397C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N6S397C2D1Ev,_ZThn36_N6S397C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N6S397C2D0Ev,_ZThn36_N6S397C2D0Ev),
  (VTBL_ENTRY)&_ZN6S397C93v31Ev,
  (VTBL_ENTRY)&_ZN6S397C93v32Ev,
  (VTBL_ENTRY)&_ZN6S397C93v33Ev,
  (VTBL_ENTRY)&_ZN6S397C93v34Ev,
  (VTBL_ENTRY)&_ZN6S397C93v35Ev,
  (VTBL_ENTRY)&_ZN6S397C93v36Ev,
  (VTBL_ENTRY)&_ZN6S397C93v37Ev,
  (VTBL_ENTRY)&_ZN6S397C93v38Ev,
  (VTBL_ENTRY)&_ZN6S397C93v39Ev,
  (VTBL_ENTRY)&_ZN6S397C93v40Ev,
  (VTBL_ENTRY)&_ZN6S397C93v41Ev,
  (VTBL_ENTRY)&_ZN6S397C93v42Ev,
  (VTBL_ENTRY)&_ZN6S397C93v43Ev,
  (VTBL_ENTRY)&_ZN6S397C93v44Ev,
  (VTBL_ENTRY)&_ZN6S397C93v45Ev,
  (VTBL_ENTRY)&_ZN6S397C93v46Ev,
  (VTBL_ENTRY)&_ZN6S397C93v47Ev,
  (VTBL_ENTRY)&_ZN6S397C93v48Ev,
  (VTBL_ENTRY)&_ZN6S397C93v49Ev,
  (VTBL_ENTRY)&_ZN6S397C93v50Ev,
  (VTBL_ENTRY)&_ZN6S397C93v51Ev,
  (VTBL_ENTRY)&_ZN6S397C93v52Ev,
  (VTBL_ENTRY)&_ZN6S397C93v53Ev,
  (VTBL_ENTRY)&_ZN6S397C93v54Ev,
  (VTBL_ENTRY)&_ZN6S397C93v55Ev,
  (VTBL_ENTRY)&_ZN6S397C93v56Ev,
  (VTBL_ENTRY)&_ZN6S397C93v57Ev,
  (VTBL_ENTRY)&_ZN6S397C93v58Ev,
  (VTBL_ENTRY)&_ZN6S397C93v59Ev,
  (VTBL_ENTRY)&_ZN6S397C93v60Ev,
  (VTBL_ENTRY)&_ZN6S397C93v61Ev,
  (VTBL_ENTRY)&_ZN6S397C93v62Ev,
};
extern VTBL_ENTRY _ZTI6S397C2[];
extern  VTBL_ENTRY _ZTV6S397C2[];
Class_Descriptor cd_S397C2 = {  "S397C2", // class name
  bases_S397C2, 4,
  &(vtc_S397C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,148), // object size
  NSPAIRA(_ZTI6S397C2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S397C2),107, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S397C1  : S397C2 {
  void *s397c1f0[2];
  ::S1107C11_nt s397c1f1;
  virtual  ~S397C1(); // _ZN6S397C1D1Ev
  virtual void  v1(); // _ZN6S397C12v1Ev
  virtual void  v2(); // _ZN6S397C12v2Ev
  virtual void  v3(); // _ZN6S397C12v3Ev
  virtual void  v4(); // _ZN6S397C12v4Ev
  virtual void  v5(); // _ZN6S397C12v5Ev
  virtual void  v6(); // _ZN6S397C12v6Ev
  virtual void  v7(); // _ZN6S397C12v7Ev
  virtual void  v8(); // _ZN6S397C12v8Ev
  S397C1(); // tgen
};
//SIG(1 S397C1) C1{ BC2{ BC3{ BC4{ BC5{ m Fi}} vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp[2] Fc[2] FC6{ m FC7{ m Fi[2]} FC7}} BC8{ vd v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62} vd v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 Fp Fi[2] Fp Fi[10] Fc Fi Fc FC9{ BC10{ vd v109 FL[2] Fi[2]} v108 Fp FC11{}} Fc[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 Fp[2] FC12{ m FC13{ m Fp Fi[4]}}}


 S397C1 ::~S397C1(){ note_dtor("S397C1", this);}
void  S397C1 ::v1(){vfunc_called(this, "_ZN6S397C12v1Ev");}
void  S397C1 ::v2(){vfunc_called(this, "_ZN6S397C12v2Ev");}
void  S397C1 ::v3(){vfunc_called(this, "_ZN6S397C12v3Ev");}
void  S397C1 ::v4(){vfunc_called(this, "_ZN6S397C12v4Ev");}
void  S397C1 ::v5(){vfunc_called(this, "_ZN6S397C12v5Ev");}
void  S397C1 ::v6(){vfunc_called(this, "_ZN6S397C12v6Ev");}
void  S397C1 ::v7(){vfunc_called(this, "_ZN6S397C12v7Ev");}
void  S397C1 ::v8(){vfunc_called(this, "_ZN6S397C12v8Ev");}
S397C1 ::S397C1(){ note_ctor("S397C1", this);} // tgen

static void Test_S397C1()
{
  extern Class_Descriptor cd_S397C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(31,45)];
    init_test(&cd_S397C1, buf);
    S397C1 *dp, &lv = *(dp=new (buf) S397C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,176), "sizeof(S397C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S397C1)");
    check_base_class_offset(lv, (S9509C16_nt*)(S397C4*)(S397C3*)(S397C2*), ABISELECT(8,4), "S397C1");
    check_base_class_offset(lv, (S397C4*)(S397C3*)(S397C2*), ABISELECT(8,4), "S397C1");
    check_base_class_offset(lv, (S397C3*)(S397C2*), 0, "S397C1");
    check_base_class_offset(lv, (S397C9*)(S397C2*), ABISELECT(56,36), "S397C1");
    check_base_class_offset(lv, (S397C2*), 0, "S397C1");
    check_field_offset(lv, s397c1f0, ABISELECT(200,148), "S397C1.s397c1f0");
    check_field_offset(lv, s397c1f1, ABISELECT(216,156), "S397C1.s397c1f1");
    test_class_info(&lv, &cd_S397C1);
    dp->~S397C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS397C1(Test_S397C1, "S397C1", ABISELECT(240,176));

#else // __cplusplus

extern void _ZN6S397C1C1Ev();
extern void _ZN6S397C1D1Ev();
Name_Map name_map_S397C1[] = {
  NSPAIR(_ZN6S397C1C1Ev),
  NSPAIR(_ZN6S397C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9509C16_nt;
extern VTBL_ENTRY _ZTI11S9509C16_nt[];
extern Class_Descriptor cd_S397C4;
extern VTBL_ENTRY _ZTI6S397C4[];
extern Class_Descriptor cd_S397C3;
extern VTBL_ENTRY _ZTI6S397C3[];
extern  VTBL_ENTRY _ZTV6S397C3[];
extern Class_Descriptor cd_S397C9;
extern VTBL_ENTRY _ZTI6S397C9[];
extern  VTBL_ENTRY _ZTV6S397C9[];
extern Class_Descriptor cd_S397C2;
extern VTBL_ENTRY _ZTI6S397C2[];
extern  VTBL_ENTRY _ZTV6S397C2[];
static Base_Class bases_S397C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9509C16_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S397C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S397C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S397C9,    ABISELECT(56,36), //bcp->offset
    79, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S397C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S397C1[];
extern void _ZN6S397C1D1Ev();
extern void _ZN6S397C1D0Ev();
extern void _ZN6S397C32v9Ev();
extern void _ZN6S397C33v10Ev();
extern void _ZN6S397C33v11Ev();
extern void _ZN6S397C33v12Ev();
extern void _ZN6S397C33v13Ev();
extern void _ZN6S397C33v14Ev();
extern void _ZN6S397C33v15Ev();
extern void _ZN6S397C33v16Ev();
extern void _ZN6S397C33v17Ev();
extern void _ZN6S397C33v18Ev();
extern void _ZN6S397C33v19Ev();
extern void _ZN6S397C33v20Ev();
extern void _ZN6S397C33v21Ev();
extern void _ZN6S397C33v22Ev();
extern void _ZN6S397C33v23Ev();
extern void _ZN6S397C33v24Ev();
extern void _ZN6S397C33v25Ev();
extern void _ZN6S397C33v26Ev();
extern void _ZN6S397C33v27Ev();
extern void _ZN6S397C33v28Ev();
extern void _ZN6S397C33v29Ev();
extern void _ZN6S397C33v30Ev();
extern void _ZN6S397C23v63Ev();
extern void _ZN6S397C23v64Ev();
extern void _ZN6S397C23v65Ev();
extern void _ZN6S397C23v66Ev();
extern void _ZN6S397C23v67Ev();
extern void _ZN6S397C23v68Ev();
extern void _ZN6S397C23v69Ev();
extern void _ZN6S397C23v70Ev();
extern void _ZN6S397C23v71Ev();
extern void _ZN6S397C23v72Ev();
extern void _ZN6S397C23v73Ev();
extern void _ZN6S397C23v74Ev();
extern void _ZN6S397C23v75Ev();
extern void _ZN6S397C23v76Ev();
extern void _ZN6S397C23v77Ev();
extern void _ZN6S397C23v78Ev();
extern void _ZN6S397C23v79Ev();
extern void _ZN6S397C23v80Ev();
extern void _ZN6S397C23v81Ev();
extern void _ZN6S397C23v82Ev();
extern void _ZN6S397C23v83Ev();
extern void _ZN6S397C23v84Ev();
extern void _ZN6S397C23v85Ev();
extern void _ZN6S397C23v86Ev();
extern void _ZN6S397C23v87Ev();
extern void _ZN6S397C23v88Ev();
extern void _ZN6S397C23v89Ev();
extern void _ZN6S397C23v90Ev();
extern void _ZN6S397C23v91Ev();
extern void _ZN6S397C23v92Ev();
extern void _ZN6S397C23v93Ev();
extern void _ZN6S397C23v94Ev();
extern void _ZN6S397C23v95Ev();
extern void _ZN6S397C23v96Ev();
extern void _ZN6S397C23v97Ev();
extern void _ZN6S397C23v98Ev();
extern void _ZN6S397C23v99Ev();
extern void _ZN6S397C24v100Ev();
extern void _ZN6S397C24v101Ev();
extern void _ZN6S397C24v102Ev();
extern void _ZN6S397C24v103Ev();
extern void _ZN6S397C24v104Ev();
extern void _ZN6S397C24v105Ev();
extern void _ZN6S397C24v106Ev();
extern void _ZN6S397C24v107Ev();
extern void _ZN6S397C12v1Ev();
extern void _ZN6S397C12v2Ev();
extern void _ZN6S397C12v3Ev();
extern void _ZN6S397C12v4Ev();
extern void _ZN6S397C12v5Ev();
extern void _ZN6S397C12v6Ev();
extern void _ZN6S397C12v7Ev();
extern void _ZN6S397C12v8Ev();
extern void ABISELECT(_ZThn56_N6S397C1D1Ev,_ZThn36_N6S397C1D1Ev)();
extern void ABISELECT(_ZThn56_N6S397C1D0Ev,_ZThn36_N6S397C1D0Ev)();
extern void _ZN6S397C93v31Ev();
extern void _ZN6S397C93v32Ev();
extern void _ZN6S397C93v33Ev();
extern void _ZN6S397C93v34Ev();
extern void _ZN6S397C93v35Ev();
extern void _ZN6S397C93v36Ev();
extern void _ZN6S397C93v37Ev();
extern void _ZN6S397C93v38Ev();
extern void _ZN6S397C93v39Ev();
extern void _ZN6S397C93v40Ev();
extern void _ZN6S397C93v41Ev();
extern void _ZN6S397C93v42Ev();
extern void _ZN6S397C93v43Ev();
extern void _ZN6S397C93v44Ev();
extern void _ZN6S397C93v45Ev();
extern void _ZN6S397C93v46Ev();
extern void _ZN6S397C93v47Ev();
extern void _ZN6S397C93v48Ev();
extern void _ZN6S397C93v49Ev();
extern void _ZN6S397C93v50Ev();
extern void _ZN6S397C93v51Ev();
extern void _ZN6S397C93v52Ev();
extern void _ZN6S397C93v53Ev();
extern void _ZN6S397C93v54Ev();
extern void _ZN6S397C93v55Ev();
extern void _ZN6S397C93v56Ev();
extern void _ZN6S397C93v57Ev();
extern void _ZN6S397C93v58Ev();
extern void _ZN6S397C93v59Ev();
extern void _ZN6S397C93v60Ev();
extern void _ZN6S397C93v61Ev();
extern void _ZN6S397C93v62Ev();
static  VTBL_ENTRY vtc_S397C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S397C1[0]),
  (VTBL_ENTRY)&_ZN6S397C1D1Ev,
  (VTBL_ENTRY)&_ZN6S397C1D0Ev,
  (VTBL_ENTRY)&_ZN6S397C32v9Ev,
  (VTBL_ENTRY)&_ZN6S397C33v10Ev,
  (VTBL_ENTRY)&_ZN6S397C33v11Ev,
  (VTBL_ENTRY)&_ZN6S397C33v12Ev,
  (VTBL_ENTRY)&_ZN6S397C33v13Ev,
  (VTBL_ENTRY)&_ZN6S397C33v14Ev,
  (VTBL_ENTRY)&_ZN6S397C33v15Ev,
  (VTBL_ENTRY)&_ZN6S397C33v16Ev,
  (VTBL_ENTRY)&_ZN6S397C33v17Ev,
  (VTBL_ENTRY)&_ZN6S397C33v18Ev,
  (VTBL_ENTRY)&_ZN6S397C33v19Ev,
  (VTBL_ENTRY)&_ZN6S397C33v20Ev,
  (VTBL_ENTRY)&_ZN6S397C33v21Ev,
  (VTBL_ENTRY)&_ZN6S397C33v22Ev,
  (VTBL_ENTRY)&_ZN6S397C33v23Ev,
  (VTBL_ENTRY)&_ZN6S397C33v24Ev,
  (VTBL_ENTRY)&_ZN6S397C33v25Ev,
  (VTBL_ENTRY)&_ZN6S397C33v26Ev,
  (VTBL_ENTRY)&_ZN6S397C33v27Ev,
  (VTBL_ENTRY)&_ZN6S397C33v28Ev,
  (VTBL_ENTRY)&_ZN6S397C33v29Ev,
  (VTBL_ENTRY)&_ZN6S397C33v30Ev,
  (VTBL_ENTRY)&_ZN6S397C23v63Ev,
  (VTBL_ENTRY)&_ZN6S397C23v64Ev,
  (VTBL_ENTRY)&_ZN6S397C23v65Ev,
  (VTBL_ENTRY)&_ZN6S397C23v66Ev,
  (VTBL_ENTRY)&_ZN6S397C23v67Ev,
  (VTBL_ENTRY)&_ZN6S397C23v68Ev,
  (VTBL_ENTRY)&_ZN6S397C23v69Ev,
  (VTBL_ENTRY)&_ZN6S397C23v70Ev,
  (VTBL_ENTRY)&_ZN6S397C23v71Ev,
  (VTBL_ENTRY)&_ZN6S397C23v72Ev,
  (VTBL_ENTRY)&_ZN6S397C23v73Ev,
  (VTBL_ENTRY)&_ZN6S397C23v74Ev,
  (VTBL_ENTRY)&_ZN6S397C23v75Ev,
  (VTBL_ENTRY)&_ZN6S397C23v76Ev,
  (VTBL_ENTRY)&_ZN6S397C23v77Ev,
  (VTBL_ENTRY)&_ZN6S397C23v78Ev,
  (VTBL_ENTRY)&_ZN6S397C23v79Ev,
  (VTBL_ENTRY)&_ZN6S397C23v80Ev,
  (VTBL_ENTRY)&_ZN6S397C23v81Ev,
  (VTBL_ENTRY)&_ZN6S397C23v82Ev,
  (VTBL_ENTRY)&_ZN6S397C23v83Ev,
  (VTBL_ENTRY)&_ZN6S397C23v84Ev,
  (VTBL_ENTRY)&_ZN6S397C23v85Ev,
  (VTBL_ENTRY)&_ZN6S397C23v86Ev,
  (VTBL_ENTRY)&_ZN6S397C23v87Ev,
  (VTBL_ENTRY)&_ZN6S397C23v88Ev,
  (VTBL_ENTRY)&_ZN6S397C23v89Ev,
  (VTBL_ENTRY)&_ZN6S397C23v90Ev,
  (VTBL_ENTRY)&_ZN6S397C23v91Ev,
  (VTBL_ENTRY)&_ZN6S397C23v92Ev,
  (VTBL_ENTRY)&_ZN6S397C23v93Ev,
  (VTBL_ENTRY)&_ZN6S397C23v94Ev,
  (VTBL_ENTRY)&_ZN6S397C23v95Ev,
  (VTBL_ENTRY)&_ZN6S397C23v96Ev,
  (VTBL_ENTRY)&_ZN6S397C23v97Ev,
  (VTBL_ENTRY)&_ZN6S397C23v98Ev,
  (VTBL_ENTRY)&_ZN6S397C23v99Ev,
  (VTBL_ENTRY)&_ZN6S397C24v100Ev,
  (VTBL_ENTRY)&_ZN6S397C24v101Ev,
  (VTBL_ENTRY)&_ZN6S397C24v102Ev,
  (VTBL_ENTRY)&_ZN6S397C24v103Ev,
  (VTBL_ENTRY)&_ZN6S397C24v104Ev,
  (VTBL_ENTRY)&_ZN6S397C24v105Ev,
  (VTBL_ENTRY)&_ZN6S397C24v106Ev,
  (VTBL_ENTRY)&_ZN6S397C24v107Ev,
  (VTBL_ENTRY)&_ZN6S397C12v1Ev,
  (VTBL_ENTRY)&_ZN6S397C12v2Ev,
  (VTBL_ENTRY)&_ZN6S397C12v3Ev,
  (VTBL_ENTRY)&_ZN6S397C12v4Ev,
  (VTBL_ENTRY)&_ZN6S397C12v5Ev,
  (VTBL_ENTRY)&_ZN6S397C12v6Ev,
  (VTBL_ENTRY)&_ZN6S397C12v7Ev,
  (VTBL_ENTRY)&_ZN6S397C12v8Ev,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI6S397C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N6S397C1D1Ev,_ZThn36_N6S397C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N6S397C1D0Ev,_ZThn36_N6S397C1D0Ev),
  (VTBL_ENTRY)&_ZN6S397C93v31Ev,
  (VTBL_ENTRY)&_ZN6S397C93v32Ev,
  (VTBL_ENTRY)&_ZN6S397C93v33Ev,
  (VTBL_ENTRY)&_ZN6S397C93v34Ev,
  (VTBL_ENTRY)&_ZN6S397C93v35Ev,
  (VTBL_ENTRY)&_ZN6S397C93v36Ev,
  (VTBL_ENTRY)&_ZN6S397C93v37Ev,
  (VTBL_ENTRY)&_ZN6S397C93v38Ev,
  (VTBL_ENTRY)&_ZN6S397C93v39Ev,
  (VTBL_ENTRY)&_ZN6S397C93v40Ev,
  (VTBL_ENTRY)&_ZN6S397C93v41Ev,
  (VTBL_ENTRY)&_ZN6S397C93v42Ev,
  (VTBL_ENTRY)&_ZN6S397C93v43Ev,
  (VTBL_ENTRY)&_ZN6S397C93v44Ev,
  (VTBL_ENTRY)&_ZN6S397C93v45Ev,
  (VTBL_ENTRY)&_ZN6S397C93v46Ev,
  (VTBL_ENTRY)&_ZN6S397C93v47Ev,
  (VTBL_ENTRY)&_ZN6S397C93v48Ev,
  (VTBL_ENTRY)&_ZN6S397C93v49Ev,
  (VTBL_ENTRY)&_ZN6S397C93v50Ev,
  (VTBL_ENTRY)&_ZN6S397C93v51Ev,
  (VTBL_ENTRY)&_ZN6S397C93v52Ev,
  (VTBL_ENTRY)&_ZN6S397C93v53Ev,
  (VTBL_ENTRY)&_ZN6S397C93v54Ev,
  (VTBL_ENTRY)&_ZN6S397C93v55Ev,
  (VTBL_ENTRY)&_ZN6S397C93v56Ev,
  (VTBL_ENTRY)&_ZN6S397C93v57Ev,
  (VTBL_ENTRY)&_ZN6S397C93v58Ev,
  (VTBL_ENTRY)&_ZN6S397C93v59Ev,
  (VTBL_ENTRY)&_ZN6S397C93v60Ev,
  (VTBL_ENTRY)&_ZN6S397C93v61Ev,
  (VTBL_ENTRY)&_ZN6S397C93v62Ev,
};
extern VTBL_ENTRY _ZTI6S397C1[];
extern  VTBL_ENTRY _ZTV6S397C1[];
Class_Descriptor cd_S397C1 = {  "S397C1", // class name
  bases_S397C1, 5,
  &(vtc_S397C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(240,176), // object size
  NSPAIRA(_ZTI6S397C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S397C1),115, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C5  {
  __tsi64 s19430c5f0[4];
  char s19430c5f1[8];
  void *s19430c5f2;
  void  mf19430c5(); // _ZN8S19430C59mf19430c5Ev
};
//SIG(-1 S19430C5) C1{ m FL[4] Fc[8] Fp}


void  S19430C5 ::mf19430c5(){}

static void Test_S19430C5()
{
  {
    init_simple_test("S19430C5");
    S19430C5 lv;
    check2(sizeof(lv), ABISELECT(48,44), "sizeof(S19430C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S19430C5)");
    check_field_offset(lv, s19430c5f0, 0, "S19430C5.s19430c5f0");
    check_field_offset(lv, s19430c5f1, 32, "S19430C5.s19430c5f1");
    check_field_offset(lv, s19430c5f2, 40, "S19430C5.s19430c5f2");
  }
}
static Arrange_To_Call_Me vS19430C5(Test_S19430C5, "S19430C5", ABISELECT(48,44));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S19430C5[];
VTBL_ENTRY *P__ZTI8S19430C5 = _ZTI8S19430C5; 
Class_Descriptor cd_S19430C5 = {  "S19430C5", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(48,44), // object size
  NSPAIRA(_ZTI8S19430C5),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C7  {
  long double s19430c7f0;
  int s19430c7f1[2];
  void *s19430c7f2[7];
  void  mf19430c7(); // _ZN8S19430C79mf19430c7Ev
};
//SIG(-1 S19430C7) C1{ m FD Fi[2] Fp[7]}


void  S19430C7 ::mf19430c7(){}

static void Test_S19430C7()
{
  {
    init_simple_test("S19430C7");
    S19430C7 lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S19430C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C7)");
    check_field_offset(lv, s19430c7f0, 0, "S19430C7.s19430c7f0");
    check_field_offset(lv, s19430c7f1, ABISELECT(16,12), "S19430C7.s19430c7f1");
    check_field_offset(lv, s19430c7f2, ABISELECT(24,20), "S19430C7.s19430c7f2");
  }
}
static Arrange_To_Call_Me vS19430C7(Test_S19430C7, "S19430C7", ABISELECT(80,48));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S19430C7[];
VTBL_ENTRY *P__ZTI8S19430C7 = _ZTI8S19430C7; 
Class_Descriptor cd_S19430C7 = {  "S19430C7", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI8S19430C7),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S19430C8  {
  void *s19430c8f0;
  int s19430c8f1;
  void  mf19430c8(); // _ZN8S19430C89mf19430c8Ev
};
//SIG(1 S19430C8) U1{ m Fp Fi}

#endif // __cplusplus
#ifdef __cplusplus

struct  S19430C6  : S19430C7 , S19430C5 {
  ::S19430C8 s19430c6f0[4];
  int s19430c6f1;
  void *s19430c6f2;
};
//SIG(-1 S19430C6) C1{ BC2{ m FD Fi[2] Fp[7]} BC3{ m FL[4] Fc[8] Fp} FU4{ m Fp Fi}[4] Fi Fp}



static void Test_S19430C6()
{
  extern Class_Descriptor cd_S19430C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(12,30)];
    init_test(&cd_S19430C6, buf);
    S19430C6 &lv = *(new (buf) S19430C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(176,116), "sizeof(S19430C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C6)");
    check_base_class_offset(lv, (S19430C7*), 0, "S19430C6");
    check_base_class_offset(lv, (S19430C5*), ABISELECT(80,48), "S19430C6");
    check_field_offset(lv, s19430c6f0, ABISELECT(128,92), "S19430C6.s19430c6f0");
    check_field_offset(lv, s19430c6f1, ABISELECT(160,108), "S19430C6.s19430c6f1");
    check_field_offset(lv, s19430c6f2, ABISELECT(168,112), "S19430C6.s19430c6f2");
    test_class_info(&lv, &cd_S19430C6);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C6(Test_S19430C6, "S19430C6", ABISELECT(176,116));

#else // __cplusplus

extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
static Base_Class bases_S19430C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C5,    ABISELECT(80,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19430C6[];
Class_Descriptor cd_S19430C6 = {  "S19430C6", // class name
  bases_S19430C6, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(176,116), // object size
  NSPAIRA(_ZTI8S19430C6),ABISELECT(56,32), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C4  : S19430C5 , S19430C6 {
  void *s19430c4f0;
  short s19430c4f1:16;
  int s19430c4f2;
  long double s19430c4f3;
  virtual  ~S19430C4(); // _ZN8S19430C4D1Ev
  virtual void  v1(); // _ZN8S19430C42v1Ev
  S19430C4(); // tgen
};
//SIG(-1 S19430C4) C1{ BC2{ m FL[4] Fc[8] Fp} BC3{ BC4{ m FD Fi[2] Fp[7]} BC2 FU5{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD}


 S19430C4 ::~S19430C4(){ note_dtor("S19430C4", this);}
void  S19430C4 ::v1(){vfunc_called(this, "_ZN8S19430C42v1Ev");}
S19430C4 ::S19430C4(){ note_ctor("S19430C4", this);} // tgen

static void Test_S19430C4()
{
  extern Class_Descriptor cd_S19430C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(18,48)];
    init_test(&cd_S19430C4, buf);
    S19430C4 *dp, &lv = *(dp=new (buf) S19430C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,188), "sizeof(S19430C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C4)");
    /*is_ambiguous_... S19430C4::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*), ABISELECT(8,4), "S19430C4");
    check_base_class_offset(lv, (S19430C7*)(S19430C6*), ABISELECT(64,48), "S19430C4");
    check_base_class_offset(lv, (S19430C5*)(S19430C6*), ABISELECT(144,96), "S19430C4");
    check_base_class_offset(lv, (S19430C6*), ABISELECT(64,48), "S19430C4");
    check_field_offset(lv, s19430c4f0, ABISELECT(240,164), "S19430C4.s19430c4f0");
    set_bf_and_test(lv, s19430c4f1, ABISELECT(248,168), 0, 16, 1, "S19430C4");
    set_bf_and_test(lv, s19430c4f1, ABISELECT(248,168), 0, 16, hide_sll(1LL<<15), "S19430C4");
    check_field_offset(lv, s19430c4f2, ABISELECT(252,172), "S19430C4.s19430c4f2");
    check_field_offset(lv, s19430c4f3, ABISELECT(256,176), "S19430C4.s19430c4f3");
    test_class_info(&lv, &cd_S19430C4);
    dp->~S19430C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C4(Test_S19430C4, "S19430C4", ABISELECT(272,188));

#else // __cplusplus

extern void _ZN8S19430C4C1Ev();
extern void _ZN8S19430C4D1Ev();
Name_Map name_map_S19430C4[] = {
  NSPAIR(_ZN8S19430C4C1Ev),
  NSPAIR(_ZN8S19430C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
static Base_Class bases_S19430C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C7,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(144,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19430C4[];
extern void _ZN8S19430C4D1Ev();
extern void _ZN8S19430C4D0Ev();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY vtc_S19430C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C4[0]),
  (VTBL_ENTRY)&_ZN8S19430C4D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C4D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
Class_Descriptor cd_S19430C4 = {  "S19430C4", // class name
  bases_S19430C4, 4,
  &(vtc_S19430C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,188), // object size
  NSPAIRA(_ZTI8S19430C4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S19430C4),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C10  : virtual S19430C4 , S19430C6 {
  void *s19430c10f0;
  ::S19430C8 s19430c10f1;
  ~S19430C10(); // tgen
  S19430C10(); // tgen
};
//SIG(-1 S19430C10) C1{ VBC2{ BC3{ m FL[4] Fc[8] Fp} BC4{ BC5{ m FD Fi[2] Fp[7]} BC3 FU6{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD} BC4 Fp FU6}


S19430C10 ::~S19430C10(){ note_dtor("S19430C10", this);} // tgen
S19430C10 ::S19430C10(){ note_ctor("S19430C10", this);} // tgen

static void Test_S19430C10()
{
  extern Class_Descriptor cd_S19430C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(31,80)];
    init_test(&cd_S19430C10, buf);
    S19430C10 *dp, &lv = *(dp=new (buf) S19430C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(480,316), "sizeof(S19430C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C10)");
    /*is_ambiguous_... S19430C4::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(216,132), "S19430C10");
    check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(272,176), "S19430C10");
    check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(352,224), "S19430C10");
    check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(272,176), "S19430C10");
    check_base_class_offset(lv, (S19430C4*), ABISELECT(208,128), "S19430C10");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*), ABISELECT(16,4), "S19430C10");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*), ABISELECT(96,52), "S19430C10");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*), ABISELECT(16,4), "S19430C10");
    check_field_offset(lv, s19430c10f0, ABISELECT(192,120), "S19430C10.s19430c10f0");
    check_field_offset(lv, s19430c10f1, ABISELECT(200,124), "S19430C10.s19430c10f1");
    test_class_info(&lv, &cd_S19430C10);
    dp->~S19430C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C10(Test_S19430C10, "S19430C10", ABISELECT(480,316));

#else // __cplusplus

extern void _ZN9S19430C10C1Ev();
extern void _ZN9S19430C10D1Ev();
Name_Map name_map_S19430C10[] = {
  NSPAIR(_ZN9S19430C10C1Ev),
  NSPAIR(_ZN9S19430C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
static Base_Class bases_S19430C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C5,    ABISELECT(216,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(272,176), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(352,224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(272,176), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(208,128), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C7,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19430C10[];
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZThn208_N9S19430C10D1Ev,_ZThn128_N9S19430C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void ABISELECT(_ZThn208_N9S19430C10D0Ev,_ZThn128_N9S19430C10D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY vtc_S19430C10[] = {
  ABISELECT(208,128),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
  0,
  ABISELECT(-208,-128),
  ABISELECT(-208,-128),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern VTBL_ENTRY _ZTV9S19430C10[];
static  VTT_ENTRY vtt_S19430C10[] = {
  {&(_ZTV9S19430C10[3]),  3,12},
  {&(_ZTV9S19430C10[9]),  9,12},
};
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19430C10D0Ev,_ZThn128_N9S19430C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19430C10D1Ev,_ZThn128_N9S19430C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C10 = {  "S19430C10", // class name
  bases_S19430C10, 8,
  &(vtc_S19430C10[0]), // expected_vtbl_contents
  &(vtt_S19430C10[0]), // expected_vtt_contents
  ABISELECT(480,316), // object size
  NSPAIRA(_ZTI9S19430C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S19430C10),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19430C10),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C11  {
  int s19430c11f0;
  int s19430c11f1;
  int s19430c11f2;
  int s19430c11f3;
  int s19430c11f4[4];
  long s19430c11f5;
  char s19430c11f6;
  long double s19430c11f7;
  int s19430c11f8;
  void  mf19430c11(); // _ZN9S19430C1110mf19430c11Ev
};
//SIG(-1 S19430C11) C1{ m Fi[8] Fl Fc FD Fi}


void  S19430C11 ::mf19430c11(){}

static void Test_S19430C11()
{
  {
    init_simple_test("S19430C11");
    S19430C11 lv;
    check2(sizeof(lv), ABISELECT(80,56), "sizeof(S19430C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C11)");
    check_field_offset(lv, s19430c11f0, 0, "S19430C11.s19430c11f0");
    check_field_offset(lv, s19430c11f1, 4, "S19430C11.s19430c11f1");
    check_field_offset(lv, s19430c11f2, 8, "S19430C11.s19430c11f2");
    check_field_offset(lv, s19430c11f3, 12, "S19430C11.s19430c11f3");
    check_field_offset(lv, s19430c11f4, 16, "S19430C11.s19430c11f4");
    check_field_offset(lv, s19430c11f5, 32, "S19430C11.s19430c11f5");
    check_field_offset(lv, s19430c11f6, ABISELECT(40,36), "S19430C11.s19430c11f6");
    check_field_offset(lv, s19430c11f7, ABISELECT(48,40), "S19430C11.s19430c11f7");
    check_field_offset(lv, s19430c11f8, ABISELECT(64,52), "S19430C11.s19430c11f8");
  }
}
static Arrange_To_Call_Me vS19430C11(Test_S19430C11, "S19430C11", ABISELECT(80,56));

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S19430C11[];
VTBL_ENTRY *P__ZTI9S19430C11 = _ZTI9S19430C11; 
Class_Descriptor cd_S19430C11 = {  "S19430C11", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(80,56), // object size
  NSPAIRA(_ZTI9S19430C11),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C9  : virtual S19430C4 , virtual S19430C10 , S19430C11 , S19430C5 {
  ::S15308C228 s19430c9f0;
  ::S19430C4 s19430c9f1;
  int s19430c9f2;
  char s19430c9f3[8];
  int s19430c9f4;
  long double s19430c9f5;
  virtual void  v2(); // _ZN8S19430C92v2Ev
  ~S19430C9(); // tgen
  S19430C9(); // tgen
};
//SIG(-1 S19430C9) C1{ VBC2{ BC3{ m FL[4] Fc[8] Fp} BC4{ BC5{ m FD Fi[2] Fp[7]} BC3 FU6{ m Fp Fi}[4] Fi Fp} vd v2 Fp Fs:16 Fi FD} VBC7{ VBC2 BC4 Fp FU6} BC8{ m Fi Fi Fi Fi Fi[4] Fl Fc FD Fi} BC3 v1 FC9{} FC2 Fi Fc[8] Fi FD}


void  S19430C9 ::v2(){vfunc_called(this, "_ZN8S19430C92v2Ev");}
S19430C9 ::~S19430C9(){ note_dtor("S19430C9", this);} // tgen
S19430C9 ::S19430C9(){ note_ctor("S19430C9", this);} // tgen

static void Test_S19430C9()
{
  extern Class_Descriptor cd_S19430C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(60,161)];
    init_test(&cd_S19430C9, buf);
    S19430C9 *dp, &lv = *(dp=new (buf) S19430C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(944,640), "sizeof(S19430C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C9)");
    /*is_ambiguous_... S19430C4::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(472,328), "S19430C9");
    check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(528,372), "S19430C9");
    check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(608,420), "S19430C9");
    check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(528,372), "S19430C9");
    check_base_class_offset(lv, (S19430C4*), ABISELECT(464,324), "S19430C9");
    check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(464,324), "S19430C9");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(752,516), "S19430C9");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(832,564), "S19430C9");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(752,516), "S19430C9");
    check_base_class_offset(lv, (S19430C10*), ABISELECT(736,512), "S19430C9");
    check_base_class_offset(lv, (S19430C11*), ABISELECT(16,4), "S19430C9");
    /*is_ambiguous_... S19430C9::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*), ABISELECT(96,60), "S19430C9");
    check_field_offset(lv, s19430c9f0, ABISELECT(144,104), "S19430C9.s19430c9f0");
    check_field_offset(lv, s19430c9f1, ABISELECT(160,108), "S19430C9.s19430c9f1");
    check_field_offset(lv, s19430c9f2, ABISELECT(432,296), "S19430C9.s19430c9f2");
    check_field_offset(lv, s19430c9f3, ABISELECT(436,300), "S19430C9.s19430c9f3");
    check_field_offset(lv, s19430c9f4, ABISELECT(444,308), "S19430C9.s19430c9f4");
    check_field_offset(lv, s19430c9f5, ABISELECT(448,312), "S19430C9.s19430c9f5");
    test_class_info(&lv, &cd_S19430C9);
    dp->~S19430C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C9(Test_S19430C9, "S19430C9", ABISELECT(944,640));

#else // __cplusplus

extern void _ZN8S19430C9C1Ev();
extern void _ZN8S19430C9D1Ev();
Name_Map name_map_S19430C9[] = {
  NSPAIR(_ZN8S19430C9C1Ev),
  NSPAIR(_ZN8S19430C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
static Base_Class bases_S19430C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C5,    ABISELECT(472,328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(528,372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(608,420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(528,372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(464,324), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C7,    ABISELECT(752,516), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(832,564), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(752,516), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(736,512), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C11,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C5,    ABISELECT(96,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19430C9[];
extern void _ZN8S19430C92v2Ev();
extern void _ZN8S19430C9D1Ev();
extern void _ZN8S19430C9D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn464_N8S19430C9D1Ev,_ZThn324_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn464_N8S19430C9D0Ev,_ZThn324_N8S19430C9D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
extern void ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn736_N8S19430C9D1Ev,_ZThn512_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn736_N8S19430C9D0Ev,_ZThn512_N8S19430C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19430C9[] = {
  ABISELECT(736,512),
  ABISELECT(464,324),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D0Ev,
  0,
  ABISELECT(-464,-324),
  ABISELECT(-464,-324),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(-736,-512),
  ABISELECT(-272,-188),
  ABISELECT(-736,-512),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev),
};
extern VTBL_ENTRY _ZTV8S19430C9[];
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C9[] = {
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C10__8S19430C9[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
static  VTT_ENTRY vtt_S19430C9[] = {
  {&(_ZTV8S19430C9[4]),  4,20},
  {&(_ZTV8S19430C9[11]),  11,20},
  {&(_ZTV8S19430C9[18]),  18,20},
  {&(_tg__ZTV9S19430C10__8S19430C9[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C10__8S19430C9[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N8S19430C9D0Ev,_ZThn512_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn736_N8S19430C9D1Ev,_ZThn512_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S19430C9D0Ev,_ZThn324_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S19430C9D1Ev,_ZThn324_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C9 = {  "S19430C9", // class name
  bases_S19430C9, 11,
  &(vtc_S19430C9[0]), // expected_vtbl_contents
  &(vtt_S19430C9[0]), // expected_vtt_contents
  ABISELECT(944,640), // object size
  NSPAIRA(_ZTI8S19430C9),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S19430C9),20, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19430C9),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C14  : S19430C11 , S19430C7 , virtual S19430C4 {
  int s19430c14f0;
  ::S19430C4 s19430c14f1;
  long s19430c14f2;
  int s19430c14f3;
  virtual  ~S19430C14(); // _ZN9S19430C14D2Ev
  S19430C14(); // tgen
};
//SIG(-1 S19430C14) C1{ BC2{ m Fi[8] Fl Fc FD Fi} BC3{ m FD Fi[2] Fp[7]} VBC4{ BC5{ m FL[4] Fc[8] Fp} BC6{ BC3 BC5 FU7{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD} vd Fi FC4 Fl Fi}


 S19430C14 ::~S19430C14(){ note_dtor("S19430C14", this);}
S19430C14 ::S19430C14(){ note_ctor("S19430C14", this);} // tgen

static void Test_S19430C14()
{
  extern Class_Descriptor cd_S19430C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(48,125)];
    init_test(&cd_S19430C14, buf);
    S19430C14 *dp, &lv = *(dp=new (buf) S19430C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(752,496), "sizeof(S19430C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C14)");
    check_base_class_offset(lv, (S19430C11*), ABISELECT(16,4), "S19430C14");
    /*is_ambiguous_... S19430C14::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*), ABISELECT(96,60), "S19430C14");
    /*is_ambiguous_... S19430C4::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(488,312), "S19430C14");
    check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(544,356), "S19430C14");
    check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(624,404), "S19430C14");
    check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(544,356), "S19430C14");
    check_base_class_offset(lv, (S19430C4*), ABISELECT(480,308), "S19430C14");
    check_field_offset(lv, s19430c14f0, ABISELECT(176,108), "S19430C14.s19430c14f0");
    check_field_offset(lv, s19430c14f1, ABISELECT(192,112), "S19430C14.s19430c14f1");
    check_field_offset(lv, s19430c14f2, ABISELECT(464,300), "S19430C14.s19430c14f2");
    check_field_offset(lv, s19430c14f3, ABISELECT(472,304), "S19430C14.s19430c14f3");
    test_class_info(&lv, &cd_S19430C14);
    dp->~S19430C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C14(Test_S19430C14, "S19430C14", ABISELECT(752,496));

#else // __cplusplus

extern void _ZN9S19430C14C1Ev();
extern void _ZN9S19430C14D2Ev();
Name_Map name_map_S19430C14[] = {
  NSPAIR(_ZN9S19430C14C1Ev),
  NSPAIR(_ZN9S19430C14D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
static Base_Class bases_S19430C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C11,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C7,    ABISELECT(96,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C5,    ABISELECT(488,312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(544,356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(624,404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(544,356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(480,308), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19430C14[];
extern void _ZN9S19430C14D1Ev();
extern void _ZN9S19430C14D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev)();
extern void ABISELECT(_ZThn480_N9S19430C14D1Ev,_ZThn308_N9S19430C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev)();
extern void ABISELECT(_ZThn480_N9S19430C14D0Ev,_ZThn308_N9S19430C14D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY vtc_S19430C14[] = {
  ABISELECT(480,308),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&_ZN9S19430C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C14D0Ev,
  0,
  ABISELECT(-480,-308),
  ABISELECT(-480,-308),
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern VTBL_ENTRY _ZTV9S19430C14[];
static  VTT_ENTRY vtt_S19430C14[] = {
  {&(_ZTV9S19430C14[3]),  3,12},
  {&(_ZTV9S19430C14[9]),  9,12},
};
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N9S19430C14D0Ev,_ZThn308_N9S19430C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N9S19430C14D1Ev,_ZThn308_N9S19430C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C14 = {  "S19430C14", // class name
  bases_S19430C14, 7,
  &(vtc_S19430C14[0]), // expected_vtbl_contents
  &(vtt_S19430C14[0]), // expected_vtt_contents
  ABISELECT(752,496), // object size
  NSPAIRA(_ZTI9S19430C14),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19430C14),12, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19430C14),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C15  : S19430C10 {
  ::S19430C6 s19430c15f0;
  int s19430c15f1;
  ::S19430C10 s19430c15f2;
  virtual  ~S19430C15(); // _ZN9S19430C15D2Ev
  virtual void  v3(); // _ZN9S19430C152v3Ev
  S19430C15(); // tgen
};
//SIG(-1 S19430C15) C1{ BC2{ VBC3{ BC4{ m FL[4] Fc[8] Fp} BC5{ BC6{ m FD Fi[2] Fp[7]} BC4 FU7{ m Fp Fi}[4] Fi Fp} vd v2 Fp Fs:16 Fi FD} BC5 Fp FU7} vd v1 FC5 Fi FC2}


 S19430C15 ::~S19430C15(){ note_dtor("S19430C15", this);}
void  S19430C15 ::v3(){vfunc_called(this, "_ZN9S19430C152v3Ev");}
S19430C15 ::S19430C15(){ note_ctor("S19430C15", this);} // tgen

static void Test_S19430C15()
{
  extern Class_Descriptor cd_S19430C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(73,189)];
    init_test(&cd_S19430C15, buf);
    S19430C15 *dp, &lv = *(dp=new (buf) S19430C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1152,752), "sizeof(S19430C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C15)");
    /*is_ambiguous_... S19430C4::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(888,568), "S19430C15");
    check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(944,612), "S19430C15");
    check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(1024,660), "S19430C15");
    check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(944,612), "S19430C15");
    check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(880,564), "S19430C15");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(16,4), "S19430C15");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(96,52), "S19430C15");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(16,4), "S19430C15");
    check_base_class_offset(lv, (S19430C10*), 0, "S19430C15");
    check_field_offset(lv, s19430c15f0, ABISELECT(208,128), "S19430C15.s19430c15f0");
    check_field_offset(lv, s19430c15f1, ABISELECT(384,244), "S19430C15.s19430c15f1");
    check_field_offset(lv, s19430c15f2, ABISELECT(400,248), "S19430C15.s19430c15f2");
    test_class_info(&lv, &cd_S19430C15);
    dp->~S19430C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C15(Test_S19430C15, "S19430C15", ABISELECT(1152,752));

#else // __cplusplus

extern void _ZN9S19430C15C1Ev();
extern void _ZN9S19430C15D2Ev();
Name_Map name_map_S19430C15[] = {
  NSPAIR(_ZN9S19430C15C1Ev),
  NSPAIR(_ZN9S19430C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
static Base_Class bases_S19430C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C5,    ABISELECT(888,568), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(944,612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1024,660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(944,612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(880,564), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19430C15[];
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZThn880_N9S19430C15D1Ev,_ZThn564_N9S19430C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void ABISELECT(_ZThn880_N9S19430C15D0Ev,_ZThn564_N9S19430C15D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY vtc_S19430C15[] = {
  ABISELECT(880,564),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
  0,
  ABISELECT(-880,-564),
  ABISELECT(-880,-564),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern VTBL_ENTRY _ZTV9S19430C15[];
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C15[] = {
  ABISELECT(880,564),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZThn880_N9S19430C10D1Ev,_ZThn564_N9S19430C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void ABISELECT(_ZThn880_N9S19430C10D0Ev,_ZThn564_N9S19430C10D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C10__9S19430C15[] = {
  0,
  ABISELECT(-880,-564),
  ABISELECT(-880,-564),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
static  VTT_ENTRY vtt_S19430C15[] = {
  {&(_ZTV9S19430C15[3]),  3,13},
  {&(_tg__ZTV9S19430C10__9S19430C15[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C10__9S19430C15[4]),  4,7},
  {&(_ZTV9S19430C15[10]),  10,13},
};
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19430C10D0Ev,_ZThn564_N9S19430C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19430C10D1Ev,_ZThn564_N9S19430C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19430C15D0Ev,_ZThn564_N9S19430C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19430C15D1Ev,_ZThn564_N9S19430C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C15 = {  "S19430C15", // class name
  bases_S19430C15, 9,
  &(vtc_S19430C15[0]), // expected_vtbl_contents
  &(vtt_S19430C15[0]), // expected_vtt_contents
  ABISELECT(1152,752), // object size
  NSPAIRA(_ZTI9S19430C15),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S19430C15),13, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19430C15),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C13  : S19430C4 , S19430C14 , virtual S19430C15 , virtual S19430C6 , virtual S19430C10 {
  void *s19430c13f0;
  int s19430c13f1;
  int s19430c13f2;
  void *s19430c13f3;
  void *s19430c13f4;
  int s19430c13f5;
  ~S19430C13(); // tgen
  S19430C13(); // tgen
};
//SIG(-1 S19430C13) C1{ BC2{ BC3{ m FL[4] Fc[8] Fp} BC4{ BC5{ m FD Fi[2] Fp[7]} BC3 FU6{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD} BC7{ BC8{ m Fi Fi Fi Fi Fi[4] Fl Fc FD Fi} BC5 VBC2 vd Fi FC2 Fl Fi} VBC9{ BC10{ VBC2 BC4 Fp FU6} vd v2 FC4 Fi FC10} VBC4 VBC10 Fp Fi Fi Fp Fp Fi}


S19430C13 ::~S19430C13(){ note_dtor("S19430C13", this);} // tgen
S19430C13 ::S19430C13(){ note_ctor("S19430C13", this);} // tgen

static void Test_S19430C13()
{
  extern Class_Descriptor cd_S19430C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(147,380)];
    init_test(&cd_S19430C13, buf);
    S19430C13 *dp, &lv = *(dp=new (buf) S19430C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2336,1516), "sizeof(S19430C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C13)");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(8,4), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(64,48), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(144,96), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(64,48), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*), 0, "S19430C13");
    check_base_class_offset(lv, (S19430C11*)(S19430C14*), ABISELECT(288,192), "S19430C13");
    /*is_ambiguous_... S19430C14::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*), ABISELECT(368,248), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(808,524), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(864,568), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(944,616), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(864,568), "S19430C13");
    check_base_class_offset(lv, (S19430C4*)(S19430C14*), ABISELECT(800,520), "S19430C13");
    check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*), ABISELECT(800,520), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(800,520), "S19430C13");
    check_base_class_offset(lv, (S19430C14*), ABISELECT(272,188), "S19430C13");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1088,712), "S19430C13");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1168,760), "S19430C13");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1088,712), "S19430C13");
    check_base_class_offset(lv, (S19430C10*)(S19430C15*), ABISELECT(1072,708), "S19430C13");
    check_base_class_offset(lv, (S19430C15*), ABISELECT(1072,708), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*), ABISELECT(1952,1272), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*), ABISELECT(2032,1320), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*), ABISELECT(1952,1272), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(2144,1392), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(2224,1440), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(2144,1392), "S19430C13");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C10*), ABISELECT(2128,1388), "S19430C13");
    check_field_offset(lv, s19430c13f0, ABISELECT(752,496), "S19430C13.s19430c13f0");
    check_field_offset(lv, s19430c13f1, ABISELECT(760,500), "S19430C13.s19430c13f1");
    check_field_offset(lv, s19430c13f2, ABISELECT(764,504), "S19430C13.s19430c13f2");
    check_field_offset(lv, s19430c13f3, ABISELECT(768,508), "S19430C13.s19430c13f3");
    check_field_offset(lv, s19430c13f4, ABISELECT(776,512), "S19430C13.s19430c13f4");
    check_field_offset(lv, s19430c13f5, ABISELECT(784,516), "S19430C13.s19430c13f5");
    test_class_info(&lv, &cd_S19430C13);
    dp->~S19430C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C13(Test_S19430C13, "S19430C13", ABISELECT(2336,1516));

#else // __cplusplus

extern void _ZN9S19430C13C1Ev();
extern void _ZN9S19430C13D1Ev();
Name_Map name_map_S19430C13[] = {
  NSPAIR(_ZN9S19430C13C1Ev),
  NSPAIR(_ZN9S19430C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
static Base_Class bases_S19430C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(144,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C11,    ABISELECT(288,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(368,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(808,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(864,568), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(944,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(864,568), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(800,520), //bcp->offset
    14, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S19430C14,    ABISELECT(272,188), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C7,    ABISELECT(1088,712), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1168,760), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(1088,712), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(1072,708), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C15,    ABISELECT(1072,708), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C7,    ABISELECT(1952,1272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2032,1320), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(1952,1272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C7,    ABISELECT(2144,1392), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2224,1440), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(2144,1392), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(2128,1388), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19430C13[];
extern void _ZN9S19430C13D1Ev();
extern void _ZN9S19430C13D0Ev();
extern void _ZN8S19430C42v1Ev();
extern void ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn800_N9S19430C13D1Ev,_ZThn520_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn800_N9S19430C13D0Ev,_ZThn520_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn1072_N9S19430C13D1Ev,_ZThn708_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn1072_N9S19430C13D0Ev,_ZThn708_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn2128_N9S19430C13D1Ev,_ZThn1388_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn2128_N9S19430C13D0Ev,_ZThn1388_N9S19430C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19430C13[] = {
  ABISELECT(2128,1388),
  ABISELECT(1952,1272),
  ABISELECT(1072,708),
  ABISELECT(800,520),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&_ZN9S19430C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C13D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(528,332),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev),
  0,
  ABISELECT(-800,-520),
  ABISELECT(-800,-520),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  0,
  ABISELECT(-1072,-708),
  ABISELECT(-272,-188),
  ABISELECT(-1072,-708),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
  ABISELECT(-2128,-1388),
  ABISELECT(-1328,-868),
  ABISELECT(-2128,-1388),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
};
extern VTBL_ENTRY _ZTV9S19430C13[];
extern void _ZN9S19430C14D1Ev();
extern void _ZN9S19430C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C14__9S19430C13[] = {
  ABISELECT(528,332),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&_ZN9S19430C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C14D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev)();
extern void ABISELECT(_ZThn528_N9S19430C14D1Ev,_ZThn332_N9S19430C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev)();
extern void ABISELECT(_ZThn528_N9S19430C14D0Ev,_ZThn332_N9S19430C14D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C14__9S19430C13[] = {
  0,
  ABISELECT(-528,-332),
  ABISELECT(-528,-332),
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C13[] = {
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C109S19430C15__9S19430C13[] = {
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C109S19430C15__9S19430C13[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C15__9S19430C13[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C10__A1__9S19430C13[] = {
  ABISELECT(-1328,-868),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C10__A1__9S19430C13[] = {
  0,
  ABISELECT(1328,868),
  ABISELECT(1328,868),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
static  VTT_ENTRY vtt_S19430C13[] = {
  {&(_ZTV9S19430C13[6]),  6,35},
  {&(_tg__ZTV9S19430C14__9S19430C13[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C14__9S19430C13[4]),  4,7},
  {&(_ZTV9S19430C13[12]),  12,35},
  {&(_ZTV9S19430C13[18]),  18,35},
  {&(_ZTV9S19430C13[26]),  26,35},
  {&(_ZTV9S19430C13[33]),  33,35},
  {&(_tg__ZTV9S19430C15__9S19430C13[3]),  3,6},
  {&(_tg__ZTV9S19430C109S19430C15__9S19430C13[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C109S19430C15__9S19430C13[4]),  4,7},
  {&(_tg__ZTV8S19430C4__9S19430C15__9S19430C13[4]),  4,7},
  {&(_tg__ZTV9S19430C10__A1__9S19430C13[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C10__A1__9S19430C13[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S19430C13[];
extern  VTBL_ENTRY _ZTV9S19430C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C13[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn528_N9S19430C14D0Ev,_ZThn332_N9S19430C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn528_N9S19430C14D1Ev,_ZThn332_N9S19430C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S19430C13D0Ev,_ZThn1388_N9S19430C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S19430C13D0Ev,_ZThn708_N9S19430C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2128_N9S19430C13D1Ev,_ZThn1388_N9S19430C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1072_N9S19430C13D1Ev,_ZThn708_N9S19430C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn800_N9S19430C13D0Ev,_ZThn520_N9S19430C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn800_N9S19430C13D1Ev,_ZThn520_N9S19430C13D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C13 = {  "S19430C13", // class name
  bases_S19430C13, 25,
  &(vtc_S19430C13[0]), // expected_vtbl_contents
  &(vtt_S19430C13[0]), // expected_vtt_contents
  ABISELECT(2336,1516), // object size
  NSPAIRA(_ZTI9S19430C13),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19430C13),35, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19430C13),13, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C3  : virtual S19430C4 , virtual S19430C9 , virtual S19430C11 , S19430C13 {
  int s19430c3f0;
  int s19430c3f1;
  void *s19430c3f2[8];
  __tsi64 s19430c3f3;
  char s19430c3f4;
  virtual  ~S19430C3(); // _ZN8S19430C3D2Ev
  virtual void  v4(); // _ZN8S19430C32v4Ev
  S19430C3(); // tgen
};
//SIG(-1 S19430C3) C1{ VBC2{ BC3{ m FL[4] Fc[8] Fp} BC4{ BC5{ m FD Fi[2] Fp[7]} BC3 FU6{ m Fp Fi}[4] Fi Fp} vd v2 Fp Fs:16 Fi FD} VBC7{ VBC2 VBC8{ VBC2 BC4 Fp FU6} BC9{ m Fi Fi Fi Fi Fi[4] Fl Fc FD Fi} BC3 v3 FC10{} FC2 Fi Fc[8] Fi FD} VBC9 BC11{ BC2 BC12{ BC9 BC5 VBC2 vd Fi FC2 Fl Fi} VBC13{ BC8 vd v4 FC4 Fi FC8} VBC4 VBC8 Fp Fi Fi Fp Fp Fi} vd v1 Fi Fi Fp[8] FL Fc}


 S19430C3 ::~S19430C3(){ note_dtor("S19430C3", this);}
void  S19430C3 ::v4(){vfunc_called(this, "_ZN8S19430C32v4Ev");}
S19430C3 ::S19430C3(){ note_ctor("S19430C3", this);} // tgen

static void Test_S19430C3()
{
  extern Class_Descriptor cd_S19430C3;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(186,488)];
    init_test(&cd_S19430C3, buf);
    S19430C3 *dp, &lv = *(dp=new (buf) S19430C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2960,1948), "sizeof(S19430C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C3)");
    /*is_ambiguous_... S19430C3::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(888,576), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(944,620), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(1024,668), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(944,620), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*), ABISELECT(880,572), "S19430C3");
    check_base_class_offset(lv, (S19430C4*)(S19430C9*), ABISELECT(880,572), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(880,572), "S19430C3");
    check_base_class_offset(lv, (S19430C4*)(S19430C14*)(S19430C13*), ABISELECT(880,572), "S19430C3");
    check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*), ABISELECT(880,572), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(1632,1088), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(1712,1136), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(1632,1088), "S19430C3");
    check_base_class_offset(lv, (S19430C10*)(S19430C9*), ABISELECT(1616,1084), "S19430C3");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C13*), ABISELECT(1616,1084), "S19430C3");
    check_base_class_offset(lv, (S19430C11*)(S19430C9*), ABISELECT(1168,764), "S19430C3");
    /*is_ambiguous_... S19430C9::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*), ABISELECT(1248,820), "S19430C3");
    check_base_class_offset(lv, (S19430C9*), ABISELECT(1152,760), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C11 */ AMB_check_base_class_offset(lv, (S19430C11*), ABISELECT(1824,1212), "S19430C3");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C13*), ABISELECT(8,4), "S19430C3");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C13*), ABISELECT(64,48), "S19430C3");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C13*), ABISELECT(144,96), "S19430C3");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C13*), ABISELECT(64,48), "S19430C3");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C13*), 0, "S19430C3");
    check_base_class_offset(lv, (S19430C11*)(S19430C14*)(S19430C13*), ABISELECT(288,192), "S19430C3");
    /*is_ambiguous_... S19430C14::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*)(S19430C13*), ABISELECT(368,248), "S19430C3");
    check_base_class_offset(lv, (S19430C14*)(S19430C13*), ABISELECT(272,188), "S19430C3");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1920,1272), "S19430C3");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(2000,1320), "S19430C3");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1920,1272), "S19430C3");
    check_base_class_offset(lv, (S19430C10*)(S19430C15*), ABISELECT(1904,1268), "S19430C3");
    check_base_class_offset(lv, (S19430C15*)(S19430C13*), ABISELECT(1904,1268), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*), ABISELECT(2784,1832), "S19430C3");
    /*is_ambiguous_... S19430C3::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*), ABISELECT(2864,1880), "S19430C3");
    /*is_ambiguous_... S19430C13::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C13*), ABISELECT(2784,1832), "S19430C3");
    check_base_class_offset(lv, (S19430C13*), 0, "S19430C3");
    check_field_offset(lv, s19430c3f0, ABISELECT(788,520), "S19430C3.s19430c3f0");
    check_field_offset(lv, s19430c3f1, ABISELECT(792,524), "S19430C3.s19430c3f1");
    check_field_offset(lv, s19430c3f2, ABISELECT(800,528), "S19430C3.s19430c3f2");
    check_field_offset(lv, s19430c3f3, ABISELECT(864,560), "S19430C3.s19430c3f3");
    check_field_offset(lv, s19430c3f4, ABISELECT(872,568), "S19430C3.s19430c3f4");
    test_class_info(&lv, &cd_S19430C3);
    dp->~S19430C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C3(Test_S19430C3, "S19430C3", ABISELECT(2960,1948));

#else // __cplusplus

extern void _ZN8S19430C3C1Ev();
extern void _ZN8S19430C3D2Ev();
Name_Map name_map_S19430C3[] = {
  NSPAIR(_ZN8S19430C3C1Ev),
  NSPAIR(_ZN8S19430C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C13;
extern VTBL_ENTRY _ZTI9S19430C13[];
extern  VTBL_ENTRY _ZTV9S19430C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C13[];
static Base_Class bases_S19430C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C5,    ABISELECT(888,576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(944,620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1024,668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(944,620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(880,572), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C7,    ABISELECT(1632,1088), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1712,1136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(1632,1088), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(1616,1084), //bcp->offset
    33, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(1168,764), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1248,820), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19430C9,    ABISELECT(1152,760), //bcp->offset
    24, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C11,    ABISELECT(1824,1212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(144,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C11,    ABISELECT(288,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(368,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19430C14,    ABISELECT(272,188), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(1920,1272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2000,1320), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(1920,1272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(1904,1268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19430C15,    ABISELECT(1904,1268), //bcp->offset
    39, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(2784,1832), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2864,1880), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(2784,1832), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S19430C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19430C3[];
extern void _ZN8S19430C3D1Ev();
extern void _ZN8S19430C3D0Ev();
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C32v4Ev();
extern void ABISELECT(_ZThn272_N8S19430C3D1Ev,_ZThn188_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn272_N8S19430C3D0Ev,_ZThn188_N8S19430C3D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19430C3D1Ev,_ZTv0_n12_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn880_N8S19430C3D1Ev,_ZThn572_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19430C3D0Ev,_ZTv0_n12_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn880_N8S19430C3D0Ev,_ZThn572_N8S19430C3D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n48_N8S19430C3D1Ev,_ZTv0_n24_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn1152_N8S19430C3D1Ev,_ZThn760_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19430C3D0Ev,_ZTv0_n24_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn1152_N8S19430C3D0Ev,_ZThn760_N8S19430C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn1616_N8S19430C3D1Ev,_ZThn1084_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn1616_N8S19430C3D0Ev,_ZThn1084_N8S19430C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn1904_N8S19430C3D1Ev,_ZThn1268_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn1904_N8S19430C3D0Ev,_ZThn1268_N8S19430C3D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY vtc_S19430C3[] = {
  ABISELECT(1824,1212),
  ABISELECT(1152,760),
  ABISELECT(1616,1084),
  ABISELECT(2784,1832),
  ABISELECT(1904,1268),
  ABISELECT(880,572),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&_ZN8S19430C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  (VTBL_ENTRY)&_ZN8S19430C32v4Ev,
  ABISELECT(608,384),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N8S19430C3D1Ev,_ZThn188_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N8S19430C3D0Ev,_ZThn188_N8S19430C3D0Ev),
  0,
  ABISELECT(-880,-572),
  ABISELECT(-880,-572),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C3D1Ev,_ZTv0_n12_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C3D0Ev,_ZTv0_n12_N8S19430C3D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(-1152,-760),
  0,
  ABISELECT(464,324),
  ABISELECT(-272,-188),
  ABISELECT(-1152,-760),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19430C3D1Ev,_ZTv0_n24_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19430C3D0Ev,_ZTv0_n24_N8S19430C3D0Ev),
  ABISELECT(-1616,-1084),
  ABISELECT(-736,-512),
  ABISELECT(-1616,-1084),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev),
  0,
  ABISELECT(-1904,-1268),
  ABISELECT(-1024,-696),
  ABISELECT(-1904,-1268),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern VTBL_ENTRY _ZTV8S19430C3[];
extern void _ZN9S19430C13D1Ev();
extern void _ZN9S19430C13D0Ev();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C13__8S19430C3[] = {
  ABISELECT(1616,1084),
  ABISELECT(2784,1832),
  ABISELECT(1904,1268),
  ABISELECT(880,572),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&_ZN9S19430C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C13D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C14D1Ev();
extern void _ZN9S19430C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C149S19430C13__8S19430C3[] = {
  ABISELECT(608,384),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&_ZN9S19430C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C14D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev)();
extern void ABISELECT(_ZThn608_N9S19430C14D1Ev,_ZThn384_N9S19430C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev)();
extern void ABISELECT(_ZThn608_N9S19430C14D0Ev,_ZThn384_N9S19430C14D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C149S19430C13__8S19430C3[] = {
  0,
  ABISELECT(-608,-384),
  ABISELECT(-608,-384),
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19430C14__9S19430C13__8S19430C3[] = {
  ABISELECT(608,384),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn880_N9S19430C13D1Ev,_ZThn572_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn880_N9S19430C13D0Ev,_ZThn572_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__A1__9S19430C13__8S19430C3[] = {
  0,
  ABISELECT(-880,-572),
  ABISELECT(-880,-572),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn1904_N9S19430C13D1Ev,_ZThn1268_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn1904_N9S19430C13D0Ev,_ZThn1268_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C13__8S19430C3[] = {
  0,
  ABISELECT(-1904,-1268),
  ABISELECT(-1024,-696),
  ABISELECT(-1904,-1268),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn1616_N9S19430C13D1Ev,_ZThn1084_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn1616_N9S19430C13D0Ev,_ZThn1084_N9S19430C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__A1__9S19430C13__8S19430C3[] = {
  ABISELECT(-1616,-1084),
  ABISELECT(-736,-512),
  ABISELECT(-1616,-1084),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN8S19430C9D1Ev();
extern void _ZN8S19430C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C9__8S19430C3[] = {
  ABISELECT(464,324),
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C9__8S19430C3[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn464_N8S19430C9D1Ev,_ZThn324_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn464_N8S19430C9D0Ev,_ZThn324_N8S19430C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C9__8S19430C3[] = {
  ABISELECT(-464,-324),
  ABISELECT(-736,-512),
  ABISELECT(-464,-324),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev),
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C3[] = {
  ABISELECT(-736,-512),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C10__8S19430C3[] = {
  0,
  ABISELECT(736,512),
  ABISELECT(736,512),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__8S19430C3[] = {
  ABISELECT(-1024,-696),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C109S19430C15__A1__8S19430C3[] = {
  ABISELECT(-1024,-696),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C109S19430C15__A1__8S19430C3[] = {
  0,
  ABISELECT(1024,696),
  ABISELECT(1024,696),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C15__8S19430C3[] = {
  0,
  ABISELECT(1024,696),
  ABISELECT(1024,696),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
static  VTT_ENTRY vtt_S19430C3[] = {
  {&(_ZTV8S19430C3[8]),  8,47},
  {&(_tg__ZTV9S19430C13__8S19430C3[6]),  6,9},
  {&(_tg__ZTV9S19430C149S19430C13__8S19430C3[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C149S19430C13__8S19430C3[4]),  4,7},
  {&(_tg__ZTV9S19430C14__9S19430C13__8S19430C3[3]),  3,5},
  {&(_tg__ZTV8S19430C4__A1__9S19430C13__8S19430C3[4]),  4,7},
  {&(_tg__ZTV9S19430C15__9S19430C13__8S19430C3[5]),  5,8},
  {&(_tg__ZTV9S19430C10__A1__9S19430C13__8S19430C3[4]),  4,6},
  {&(_ZTV8S19430C3[21]),  21,47},
  {&(_ZTV8S19430C3[30]),  30,47},
  {&(_ZTV8S19430C3[37]),  37,47},
  {&(_ZTV8S19430C3[15]),  15,47},
  {&(_ZTV8S19430C3[44]),  44,47},
  {&(_tg__ZTV8S19430C9__8S19430C3[4]),  4,7},
  {&(_tg__ZTV8S19430C4__8S19430C9__8S19430C3[4]),  4,7},
  {&(_tg__ZTV9S19430C10__8S19430C9__8S19430C3[4]),  4,6},
  {&(_tg__ZTV9S19430C10__8S19430C3[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C10__8S19430C3[4]),  4,7},
  {&(_tg__ZTV9S19430C15__8S19430C3[3]),  3,6},
  {&(_tg__ZTV9S19430C109S19430C15__A1__8S19430C3[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C109S19430C15__A1__8S19430C3[4]),  4,7},
  {&(_tg__ZTV8S19430C4__9S19430C15__8S19430C3[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S19430C3[];
extern  VTBL_ENTRY _ZTV8S19430C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C3[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S19430C9D0Ev,_ZThn324_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S19430C9D1Ev,_ZThn324_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1616_N9S19430C13D0Ev,_ZThn1084_N9S19430C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S19430C13D0Ev,_ZThn1268_N9S19430C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1616_N9S19430C13D1Ev,_ZThn1084_N9S19430C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N9S19430C13D1Ev,_ZThn1268_N9S19430C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19430C13D0Ev,_ZThn572_N9S19430C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19430C13D1Ev,_ZThn572_N9S19430C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn608_N9S19430C14D0Ev,_ZThn384_N9S19430C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn608_N9S19430C14D1Ev,_ZThn384_N9S19430C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S19430C3D0Ev,_ZThn1268_N8S19430C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1616_N8S19430C3D0Ev,_ZThn1084_N8S19430C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1904_N8S19430C3D1Ev,_ZThn1268_N8S19430C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1616_N8S19430C3D1Ev,_ZThn1084_N8S19430C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19430C3D0Ev,_ZTv0_n24_N8S19430C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1152_N8S19430C3D0Ev,_ZThn760_N8S19430C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19430C3D1Ev,_ZTv0_n24_N8S19430C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1152_N8S19430C3D1Ev,_ZThn760_N8S19430C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C3D0Ev,_ZTv0_n12_N8S19430C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N8S19430C3D0Ev,_ZThn572_N8S19430C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C3D1Ev,_ZTv0_n12_N8S19430C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N8S19430C3D1Ev,_ZThn572_N8S19430C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C3 = {  "S19430C3", // class name
  bases_S19430C3, 30,
  &(vtc_S19430C3[0]), // expected_vtbl_contents
  &(vtt_S19430C3[0]), // expected_vtt_contents
  ABISELECT(2960,1948), // object size
  NSPAIRA(_ZTI8S19430C3),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S19430C3),47, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19430C3),22, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C16  : virtual S19430C7 , virtual S19430C4 , S19430C9 , virtual S19430C15 , virtual S19430C5 {
  int s19430c16f0;
  int  :0;
  void *s19430c16f2;
  virtual  ~S19430C16(); // _ZN9S19430C16D2Ev
  S19430C16(); // tgen
};
//SIG(-1 S19430C16) C1{ VBC2{ m FD Fi[2] Fp[7]} VBC3{ BC4{ m FL[4] Fc[8] Fp} BC5{ BC2 BC4 FU6{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD} BC7{ VBC3 VBC8{ VBC3 BC5 Fp FU6} BC9{ m Fi Fi Fi Fi Fi[4] Fl Fc FD Fi} BC4 v2 FC10{} FC3 Fi Fc[8] Fi FD} VBC11{ BC8 vd v3 FC5 Fi FC8} VBC4 vd Fi Fi:0 Fp}


 S19430C16 ::~S19430C16(){ note_dtor("S19430C16", this);}
S19430C16 ::S19430C16(){ note_ctor("S19430C16", this);} // tgen

static void Test_S19430C16()
{
  extern Class_Descriptor cd_S19430C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(124,327)];
    init_test(&cd_S19430C16, buf);
    S19430C16 *dp, &lv = *(dp=new (buf) S19430C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1968,1304), "sizeof(S19430C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C16)");
    /*is_ambiguous_... S19430C16::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*), ABISELECT(480,332), "S19430C16");
    /*is_ambiguous_... S19430C4::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(568,384), "S19430C16");
    check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(624,428), "S19430C16");
    check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(704,476), "S19430C16");
    check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(624,428), "S19430C16");
    check_base_class_offset(lv, (S19430C4*), ABISELECT(560,380), "S19430C16");
    check_base_class_offset(lv, (S19430C4*)(S19430C9*), ABISELECT(560,380), "S19430C16");
    /*is_ambiguous_... S19430C16::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(560,380), "S19430C16");
    check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*), ABISELECT(560,380), "S19430C16");
    /*is_ambiguous_... S19430C16::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(848,572), "S19430C16");
    /*is_ambiguous_... S19430C16::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(928,620), "S19430C16");
    /*is_ambiguous_... S19430C16::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(848,572), "S19430C16");
    check_base_class_offset(lv, (S19430C10*)(S19430C9*), ABISELECT(832,568), "S19430C16");
    check_base_class_offset(lv, (S19430C11*)(S19430C9*), ABISELECT(16,4), "S19430C16");
    /*is_ambiguous_... S19430C9::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*), ABISELECT(96,60), "S19430C16");
    check_base_class_offset(lv, (S19430C9*), 0, "S19430C16");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1056,700), "S19430C16");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1136,748), "S19430C16");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1056,700), "S19430C16");
    check_base_class_offset(lv, (S19430C10*)(S19430C15*), ABISELECT(1040,696), "S19430C16");
    check_base_class_offset(lv, (S19430C15*), ABISELECT(1040,696), "S19430C16");
    /*is_ambiguous_... S19430C16::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*), ABISELECT(1920,1260), "S19430C16");
    check_field_offset(lv, s19430c16f0, ABISELECT(464,324), "S19430C16.s19430c16f0");
    check_field_offset(lv, s19430c16f2, ABISELECT(472,328), "S19430C16.s19430c16f2");
    test_class_info(&lv, &cd_S19430C16);
    dp->~S19430C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C16(Test_S19430C16, "S19430C16", ABISELECT(1968,1304));

#else // __cplusplus

extern void _ZN9S19430C16C1Ev();
extern void _ZN9S19430C16D2Ev();
Name_Map name_map_S19430C16[] = {
  NSPAIR(_ZN9S19430C16C1Ev),
  NSPAIR(_ZN9S19430C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
static Base_Class bases_S19430C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C7,    ABISELECT(480,332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C5,    ABISELECT(568,384), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(624,428), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(704,476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(624,428), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(560,380), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C7,    ABISELECT(848,572), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(928,620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(848,572), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(832,568), //bcp->offset
    17, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(96,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19430C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C7,    ABISELECT(1056,700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1136,748), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(1056,700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(1040,696), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C15,    ABISELECT(1040,696), //bcp->offset
    23, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C5,    ABISELECT(1920,1260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S19430C16[];
extern void _ZN8S19430C92v2Ev();
extern void _ZN9S19430C16D1Ev();
extern void _ZN9S19430C16D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn560_N9S19430C16D1Ev,_ZThn380_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn560_N9S19430C16D0Ev,_ZThn380_N9S19430C16D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn832_N9S19430C16D1Ev,_ZThn568_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn832_N9S19430C16D0Ev,_ZThn568_N9S19430C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn1040_N9S19430C16D1Ev,_ZThn696_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn1040_N9S19430C16D0Ev,_ZThn696_N9S19430C16D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY vtc_S19430C16[] = {
  ABISELECT(1920,1260),
  ABISELECT(1040,696),
  ABISELECT(480,332),
  ABISELECT(832,568),
  ABISELECT(560,380),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D0Ev,
  0,
  ABISELECT(-560,-380),
  ABISELECT(-560,-380),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(-832,-568),
  ABISELECT(-272,-188),
  ABISELECT(-832,-568),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
  0,
  ABISELECT(-1040,-696),
  ABISELECT(-480,-316),
  ABISELECT(-1040,-696),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern VTBL_ENTRY _ZTV9S19430C16[];
extern void _ZN8S19430C92v2Ev();
extern void _ZN8S19430C9D1Ev();
extern void _ZN8S19430C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C9__9S19430C16[] = {
  ABISELECT(832,568),
  ABISELECT(560,380),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn560_N8S19430C9D1Ev,_ZThn380_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn560_N8S19430C9D0Ev,_ZThn380_N8S19430C9D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C9__9S19430C16[] = {
  0,
  ABISELECT(-560,-380),
  ABISELECT(-560,-380),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn832_N8S19430C9D1Ev,_ZThn568_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn832_N8S19430C9D0Ev,_ZThn568_N8S19430C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C9__9S19430C16[] = {
  ABISELECT(-832,-568),
  ABISELECT(-272,-188),
  ABISELECT(-832,-568),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev),
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C16[] = {
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C10__9S19430C16[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C16[] = {
  ABISELECT(-480,-316),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C109S19430C15__A1__9S19430C16[] = {
  ABISELECT(-480,-316),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C109S19430C15__A1__9S19430C16[] = {
  0,
  ABISELECT(480,316),
  ABISELECT(480,316),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C15__9S19430C16[] = {
  0,
  ABISELECT(480,316),
  ABISELECT(480,316),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
static  VTT_ENTRY vtt_S19430C16[] = {
  {&(_ZTV9S19430C16[7]),  7,31},
  {&(_tg__ZTV8S19430C9__9S19430C16[4]),  4,7},
  {&(_tg__ZTV8S19430C4__8S19430C9__9S19430C16[4]),  4,7},
  {&(_tg__ZTV9S19430C10__8S19430C9__9S19430C16[4]),  4,6},
  {&(_ZTV9S19430C16[14]),  14,31},
  {&(_ZTV9S19430C16[21]),  21,31},
  {&(_ZTV9S19430C16[28]),  28,31},
  {&(_tg__ZTV9S19430C10__9S19430C16[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C10__9S19430C16[4]),  4,7},
  {&(_tg__ZTV9S19430C15__9S19430C16[3]),  3,6},
  {&(_tg__ZTV9S19430C109S19430C15__A1__9S19430C16[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C109S19430C15__A1__9S19430C16[4]),  4,7},
  {&(_tg__ZTV8S19430C4__9S19430C15__9S19430C16[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S19430C16[];
extern  VTBL_ENTRY _ZTV9S19430C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C16[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn832_N8S19430C9D0Ev,_ZThn568_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn832_N8S19430C9D1Ev,_ZThn568_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn560_N8S19430C9D0Ev,_ZThn380_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn560_N8S19430C9D1Ev,_ZThn380_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S19430C16D0Ev,_ZThn696_N9S19430C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn832_N9S19430C16D0Ev,_ZThn568_N9S19430C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1040_N9S19430C16D1Ev,_ZThn696_N9S19430C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn832_N9S19430C16D1Ev,_ZThn568_N9S19430C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn560_N9S19430C16D0Ev,_ZThn380_N9S19430C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn560_N9S19430C16D1Ev,_ZThn380_N9S19430C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C16 = {  "S19430C16", // class name
  bases_S19430C16, 19,
  &(vtc_S19430C16[0]), // expected_vtbl_contents
  &(vtt_S19430C16[0]), // expected_vtt_contents
  ABISELECT(1968,1304), // object size
  NSPAIRA(_ZTI9S19430C16),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19430C16),31, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19430C16),13, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C2  : S19430C3 , S19430C13 , S19430C16 {
  long double s19430c2f0[9];
  char s19430c2f1;
  __tsi64 s19430c2f2;
  ~S19430C2(); // tgen
  S19430C2(); // tgen
};
//SIG(-1 S19430C2) C1{ BC2{ VBC3{ BC4{ m FL[4] Fc[8] Fp} BC5{ BC6{ m FD Fi[2] Fp[7]} BC4 FU7{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD} VBC8{ VBC3 VBC9{ VBC3 BC5 Fp FU7} BC10{ m Fi Fi Fi Fi Fi[4] Fl Fc FD Fi} BC4 v2 FC11{} FC3 Fi Fc[8] Fi FD} VBC10 BC12{ BC3 BC13{ BC10 BC6 VBC3 vd Fi FC3 Fl Fi} VBC14{ BC9 vd v3 FC5 Fi FC9} VBC5 VBC9 Fp Fi Fi Fp Fp Fi} vd v4 Fi Fi Fp[8] FL Fc} BC12 BC15{ VBC6 VBC3 BC8 VBC14 VBC4 vd Fi Fi:0 Fp} FD[9] Fc FL}


S19430C2 ::~S19430C2(){ note_dtor("S19430C2", this);} // tgen
S19430C2 ::S19430C2(){ note_ctor("S19430C2", this);} // tgen

static void Test_S19430C2()
{
  extern Class_Descriptor cd_S19430C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(284,754)];
    init_test(&cd_S19430C2, buf);
    S19430C2 *dp, &lv = *(dp=new (buf) S19430C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4528,3012), "sizeof(S19430C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C2)");
    /*is_ambiguous_... S19430C2::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(2328,1548), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(2384,1592), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(2464,1640), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(2384,1592), "S19430C2");
    /*is_ambiguous_... S19430C3::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C3*), ABISELECT(2320,1544), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C9*), ABISELECT(2320,1544), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(2320,1544), "S19430C2");
    check_base_class_offset(lv, (S19430C4*)(S19430C14*)(S19430C13*)(S19430C3*), ABISELECT(2320,1544), "S19430C2");
    check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*), ABISELECT(2320,1544), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C14*)(S19430C13*), ABISELECT(2320,1544), "S19430C2");
    check_base_class_offset(lv, (S19430C4*)(S19430C16*), ABISELECT(2320,1544), "S19430C2");
    check_base_class_offset(lv, (S19430C4*)(S19430C9*)(S19430C16*), ABISELECT(2320,1544), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(3072,2060), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(3152,2108), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(3072,2060), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C9*), ABISELECT(3056,2056), "S19430C2");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C13*)(S19430C3*), ABISELECT(3056,2056), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C13*), ABISELECT(3056,2056), "S19430C2");
    check_base_class_offset(lv, (S19430C10*)(S19430C9*)(S19430C16*), ABISELECT(3056,2056), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C9*), ABISELECT(2608,1736), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*), ABISELECT(2688,1792), "S19430C2");
    check_base_class_offset(lv, (S19430C9*)(S19430C3*), ABISELECT(2592,1732), "S19430C2");
    /*is_ambiguous_... S19430C3::S19430C11 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C3*), ABISELECT(3264,2184), "S19430C2");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C13*)(S19430C3*), ABISELECT(8,4), "S19430C2");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*), ABISELECT(64,48), "S19430C2");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*), ABISELECT(144,96), "S19430C2");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*), ABISELECT(64,48), "S19430C2");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C13*)(S19430C3*), 0, "S19430C2");
    check_base_class_offset(lv, (S19430C11*)(S19430C14*)(S19430C13*)(S19430C3*), ABISELECT(288,192), "S19430C2");
    /*is_ambiguous_... S19430C14::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*)(S19430C13*)(S19430C3*), ABISELECT(368,248), "S19430C2");
    check_base_class_offset(lv, (S19430C14*)(S19430C13*)(S19430C3*), ABISELECT(272,188), "S19430C2");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(3360,2244), "S19430C2");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(3440,2292), "S19430C2");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(3360,2244), "S19430C2");
    check_base_class_offset(lv, (S19430C10*)(S19430C15*), ABISELECT(3344,2240), "S19430C2");
    check_base_class_offset(lv, (S19430C15*)(S19430C13*)(S19430C3*), ABISELECT(3344,2240), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C15*)(S19430C13*), ABISELECT(3344,2240), "S19430C2");
    check_base_class_offset(lv, (S19430C15*)(S19430C16*), ABISELECT(3344,2240), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*), ABISELECT(4224,2804), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*), ABISELECT(4304,2852), "S19430C2");
    /*is_ambiguous_... S19430C13::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C13*)(S19430C3*), ABISELECT(4224,2804), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C13*), ABISELECT(4224,2804), "S19430C2");
    check_base_class_offset(lv, (S19430C13*)(S19430C3*), 0, "S19430C2");
    check_base_class_offset(lv, (S19430C3*), 0, "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C13*), ABISELECT(888,576), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C13*), ABISELECT(944,620), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C13*), ABISELECT(1024,668), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C13*), ABISELECT(944,620), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C13*), ABISELECT(880,572), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C14*)(S19430C13*), ABISELECT(1168,764), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*)(S19430C13*), ABISELECT(1248,820), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C14*)(S19430C13*), ABISELECT(1152,760), "S19430C2");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C13*), ABISELECT(880,572), "S19430C2");
    /*is_ambiguous_... S19430C16::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C16*), ABISELECT(4400,2920), "S19430C2");
    check_base_class_offset(lv, (S19430C11*)(S19430C9*)(S19430C16*), ABISELECT(1696,1096), "S19430C2");
    /*is_ambiguous_... S19430C9::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*)(S19430C16*), ABISELECT(1776,1152), "S19430C2");
    check_base_class_offset(lv, (S19430C9*)(S19430C16*), ABISELECT(1680,1092), "S19430C2");
    /*is_ambiguous_... S19430C16::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C16*), ABISELECT(4480,2968), "S19430C2");
    check_base_class_offset(lv, (S19430C16*), ABISELECT(1680,1092), "S19430C2");
    check_field_offset(lv, s19430c2f0, ABISELECT(2160,1424), "S19430C2.s19430c2f0");
    check_field_offset(lv, s19430c2f1, ABISELECT(2304,1532), "S19430C2.s19430c2f1");
    check_field_offset(lv, s19430c2f2, ABISELECT(2312,1536), "S19430C2.s19430c2f2");
    test_class_info(&lv, &cd_S19430C2);
    dp->~S19430C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C2(Test_S19430C2, "S19430C2", ABISELECT(4528,3012));

#else // __cplusplus

extern void _ZN8S19430C2C1Ev();
extern void _ZN8S19430C2D1Ev();
Name_Map name_map_S19430C2[] = {
  NSPAIR(_ZN8S19430C2C1Ev),
  NSPAIR(_ZN8S19430C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C13;
extern VTBL_ENTRY _ZTI9S19430C13[];
extern  VTBL_ENTRY _ZTV9S19430C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C13[];
extern Class_Descriptor cd_S19430C3;
extern VTBL_ENTRY _ZTI8S19430C3[];
extern  VTBL_ENTRY _ZTV8S19430C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C3[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C13;
extern VTBL_ENTRY _ZTI9S19430C13[];
extern  VTBL_ENTRY _ZTV9S19430C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C13[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C16;
extern VTBL_ENTRY _ZTI9S19430C16[];
extern  VTBL_ENTRY _ZTV9S19430C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C16[];
static Base_Class bases_S19430C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C5,    ABISELECT(2328,1548), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(2384,1592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2464,1640), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(2384,1592), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(2320,1544), //bcp->offset
    43, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(3072,2060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(3152,2108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(3072,2060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(3056,2056), //bcp->offset
    59, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(2608,1736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2688,1792), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19430C9,    ABISELECT(2592,1732), //bcp->offset
    50, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    37, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(3264,2184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S19430C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(144,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C11,    ABISELECT(288,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(368,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19430C14,    ABISELECT(272,188), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(3360,2244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(3440,2292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(3360,2244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(3344,2240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19430C15,    ABISELECT(3344,2240), //bcp->offset
    65, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(4224,2804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(4304,2852), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(4224,2804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S19430C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19430C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C5,    ABISELECT(888,576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(944,620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1024,668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(944,620), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(880,572), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19430C11,    ABISELECT(1168,764), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(1248,820), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19430C14,    ABISELECT(1152,760), //bcp->offset
    28, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19430C13,    ABISELECT(880,572), //bcp->offset
    19, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C7,    ABISELECT(4400,2920), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    45, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(1696,1096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1776,1152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19430C9,    ABISELECT(1680,1092), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(4480,2968), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    45, //immediately_derived
  0, 1},
  {&cd_S19430C16,    ABISELECT(1680,1092), //bcp->offset
    33, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S19430C2[];
extern void _ZN8S19430C2D1Ev();
extern void _ZN8S19430C2D0Ev();
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C32v4Ev();
extern void ABISELECT(_ZThn272_N8S19430C2D1Ev,_ZThn188_N8S19430C2D1Ev)();
extern void ABISELECT(_ZThn272_N8S19430C2D0Ev,_ZThn188_N8S19430C2D0Ev)();
extern void ABISELECT(_ZThn880_N8S19430C2D1Ev,_ZThn572_N8S19430C2D1Ev)();
extern void ABISELECT(_ZThn880_N8S19430C2D0Ev,_ZThn572_N8S19430C2D0Ev)();
extern void _ZN8S19430C42v1Ev();
extern void ABISELECT(_ZThn1152_N8S19430C2D1Ev,_ZThn760_N8S19430C2D1Ev)();
extern void ABISELECT(_ZThn1152_N8S19430C2D0Ev,_ZThn760_N8S19430C2D0Ev)();
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZThn1680_N8S19430C2D1Ev,_ZThn1092_N8S19430C2D1Ev)();
extern void ABISELECT(_ZThn1680_N8S19430C2D0Ev,_ZThn1092_N8S19430C2D0Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19430C2D1Ev,_ZTv0_n12_N8S19430C2D1Ev)();
extern void ABISELECT(_ZThn2320_N8S19430C2D1Ev,_ZThn1544_N8S19430C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19430C2D0Ev,_ZTv0_n12_N8S19430C2D0Ev)();
extern void ABISELECT(_ZThn2320_N8S19430C2D0Ev,_ZThn1544_N8S19430C2D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n48_N8S19430C2D1Ev,_ZTv0_n24_N8S19430C2D1Ev)();
extern void ABISELECT(_ZThn2592_N8S19430C2D1Ev,_ZThn1732_N8S19430C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19430C2D0Ev,_ZTv0_n24_N8S19430C2D0Ev)();
extern void ABISELECT(_ZThn2592_N8S19430C2D0Ev,_ZThn1732_N8S19430C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C2D1Ev,_ZTv0_n16_N8S19430C2D1Ev)();
extern void ABISELECT(_ZThn3056_N8S19430C2D1Ev,_ZThn2056_N8S19430C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C2D0Ev,_ZTv0_n16_N8S19430C2D0Ev)();
extern void ABISELECT(_ZThn3056_N8S19430C2D0Ev,_ZThn2056_N8S19430C2D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C2D1Ev,_ZTv0_n16_N8S19430C2D1Ev)();
extern void ABISELECT(_ZThn3344_N8S19430C2D1Ev,_ZThn2240_N8S19430C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C2D0Ev,_ZTv0_n16_N8S19430C2D0Ev)();
extern void ABISELECT(_ZThn3344_N8S19430C2D0Ev,_ZThn2240_N8S19430C2D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY vtc_S19430C2[] = {
  ABISELECT(4480,2968),
  ABISELECT(4400,2920),
  ABISELECT(3264,2184),
  ABISELECT(2592,1732),
  ABISELECT(3056,2056),
  ABISELECT(4224,2804),
  ABISELECT(3344,2240),
  ABISELECT(2320,1544),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C2[0]),
  (VTBL_ENTRY)&_ZN8S19430C2D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C2D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  (VTBL_ENTRY)&_ZN8S19430C32v4Ev,
  ABISELECT(2048,1356),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI8S19430C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N8S19430C2D1Ev,_ZThn188_N8S19430C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N8S19430C2D0Ev,_ZThn188_N8S19430C2D0Ev),
  ABISELECT(2176,1484),
  ABISELECT(3344,2232),
  ABISELECT(2464,1668),
  ABISELECT(1440,972),
  ABISELECT(-880,-572),
  (VTBL_ENTRY)&(_ZTI8S19430C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn880_N8S19430C2D1Ev,_ZThn572_N8S19430C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn880_N8S19430C2D0Ev,_ZThn572_N8S19430C2D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(1168,784),
  ABISELECT(-1152,-760),
  (VTBL_ENTRY)&(_ZTI8S19430C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1152_N8S19430C2D1Ev,_ZThn760_N8S19430C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1152_N8S19430C2D0Ev,_ZThn760_N8S19430C2D0Ev),
  ABISELECT(2800,1876),
  ABISELECT(1664,1148),
  ABISELECT(2720,1828),
  ABISELECT(1376,964),
  ABISELECT(640,452),
  ABISELECT(-1680,-1092),
  (VTBL_ENTRY)&(_ZTI8S19430C2[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1680_N8S19430C2D1Ev,_ZThn1092_N8S19430C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1680_N8S19430C2D0Ev,_ZThn1092_N8S19430C2D0Ev),
  0,
  ABISELECT(-2320,-1544),
  ABISELECT(-2320,-1544),
  (VTBL_ENTRY)&(_ZTI8S19430C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C2D1Ev,_ZTv0_n12_N8S19430C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C2D0Ev,_ZTv0_n12_N8S19430C2D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(-2592,-1732),
  0,
  ABISELECT(464,324),
  ABISELECT(-272,-188),
  ABISELECT(-2592,-1732),
  (VTBL_ENTRY)&(_ZTI8S19430C2[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19430C2D1Ev,_ZTv0_n24_N8S19430C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19430C2D0Ev,_ZTv0_n24_N8S19430C2D0Ev),
  ABISELECT(-3056,-2056),
  ABISELECT(-736,-512),
  ABISELECT(-3056,-2056),
  (VTBL_ENTRY)&(_ZTI8S19430C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C2D1Ev,_ZTv0_n16_N8S19430C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C2D0Ev,_ZTv0_n16_N8S19430C2D0Ev),
  0,
  ABISELECT(-3344,-2240),
  ABISELECT(-1024,-696),
  ABISELECT(-3344,-2240),
  (VTBL_ENTRY)&(_ZTI8S19430C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C2D1Ev,_ZTv0_n16_N8S19430C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C2D0Ev,_ZTv0_n16_N8S19430C2D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern VTBL_ENTRY _ZTV8S19430C2[];
extern void _ZN8S19430C3D1Ev();
extern void _ZN8S19430C3D0Ev();
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C32v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C3__8S19430C2[] = {
  ABISELECT(3264,2184),
  ABISELECT(2592,1732),
  ABISELECT(3056,2056),
  ABISELECT(4224,2804),
  ABISELECT(3344,2240),
  ABISELECT(2320,1544),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&_ZN8S19430C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  (VTBL_ENTRY)&_ZN8S19430C32v4Ev,
};
extern void _ZN9S19430C13D1Ev();
extern void _ZN9S19430C13D0Ev();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C138S19430C3__8S19430C2[] = {
  ABISELECT(3056,2056),
  ABISELECT(4224,2804),
  ABISELECT(3344,2240),
  ABISELECT(2320,1544),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&_ZN9S19430C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C13D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C14D1Ev();
extern void _ZN9S19430C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C149S19430C138S19430C3__8S19430C2[] = {
  ABISELECT(2048,1356),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&_ZN9S19430C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C14D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev)();
extern void ABISELECT(_ZThn2048_N9S19430C14D1Ev,_ZThn1356_N9S19430C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev)();
extern void ABISELECT(_ZThn2048_N9S19430C14D0Ev,_ZThn1356_N9S19430C14D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C149S19430C138S19430C3__8S19430C2[] = {
  0,
  ABISELECT(-2048,-1356),
  ABISELECT(-2048,-1356),
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19430C14__9S19430C138S19430C3__8S19430C2[] = {
  ABISELECT(2048,1356),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn2320_N9S19430C13D1Ev,_ZThn1544_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn2320_N9S19430C13D0Ev,_ZThn1544_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__A1__9S19430C138S19430C3__8S19430C2[] = {
  0,
  ABISELECT(-2320,-1544),
  ABISELECT(-2320,-1544),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn3344_N9S19430C13D1Ev,_ZThn2240_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn3344_N9S19430C13D0Ev,_ZThn2240_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C138S19430C3__8S19430C2[] = {
  0,
  ABISELECT(-3344,-2240),
  ABISELECT(-1024,-696),
  ABISELECT(-3344,-2240),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn3056_N9S19430C13D1Ev,_ZThn2056_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn3056_N9S19430C13D0Ev,_ZThn2056_N9S19430C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__A1__9S19430C138S19430C3__8S19430C2[] = {
  ABISELECT(-3056,-2056),
  ABISELECT(-736,-512),
  ABISELECT(-3056,-2056),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S19430C3D1Ev,_ZTv0_n12_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn2320_N8S19430C3D1Ev,_ZThn1544_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19430C3D0Ev,_ZTv0_n12_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn2320_N8S19430C3D0Ev,_ZThn1544_N8S19430C3D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C3__8S19430C2[] = {
  0,
  ABISELECT(-2320,-1544),
  ABISELECT(-2320,-1544),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C3D1Ev,_ZTv0_n12_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C3D0Ev,_ZTv0_n12_N8S19430C3D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n48_N8S19430C3D1Ev,_ZTv0_n24_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn2592_N8S19430C3D1Ev,_ZThn1732_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19430C3D0Ev,_ZTv0_n24_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn2592_N8S19430C3D0Ev,_ZThn1732_N8S19430C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19430C9__8S19430C3__8S19430C2[] = {
  ABISELECT(-2592,-1732),
  0,
  ABISELECT(464,324),
  ABISELECT(-272,-188),
  ABISELECT(-2592,-1732),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19430C3D1Ev,_ZTv0_n24_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19430C3D0Ev,_ZTv0_n24_N8S19430C3D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn3056_N8S19430C3D1Ev,_ZThn2056_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn3056_N8S19430C3D0Ev,_ZThn2056_N8S19430C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C3__8S19430C2[] = {
  ABISELECT(-3056,-2056),
  ABISELECT(-736,-512),
  ABISELECT(-3056,-2056),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev),
};
extern void ABISELECT(_ZThn272_N8S19430C3D1Ev,_ZThn188_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn272_N8S19430C3D0Ev,_ZThn188_N8S19430C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19430C149S19430C13__8S19430C3__8S19430C2[] = {
  ABISELECT(2048,1356),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N8S19430C3D1Ev,_ZThn188_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N8S19430C3D0Ev,_ZThn188_N8S19430C3D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn3344_N8S19430C3D1Ev,_ZThn2240_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn3344_N8S19430C3D0Ev,_ZThn2240_N8S19430C3D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__8S19430C3__8S19430C2[] = {
  0,
  ABISELECT(-3344,-2240),
  ABISELECT(-1024,-696),
  ABISELECT(-3344,-2240),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C13D1Ev();
extern void _ZN9S19430C13D0Ev();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C13__A1__8S19430C2[] = {
  ABISELECT(2176,1484),
  ABISELECT(3344,2232),
  ABISELECT(2464,1668),
  ABISELECT(1440,972),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&_ZN9S19430C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C13D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C14D1Ev();
extern void _ZN9S19430C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C149S19430C13__A1__8S19430C2[] = {
  ABISELECT(1168,784),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&_ZN9S19430C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C14D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev)();
extern void ABISELECT(_ZThn1168_N9S19430C14D1Ev,_ZThn784_N9S19430C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev)();
extern void ABISELECT(_ZThn1168_N9S19430C14D0Ev,_ZThn784_N9S19430C14D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C149S19430C13__A1__8S19430C2[] = {
  0,
  ABISELECT(-1168,-784),
  ABISELECT(-1168,-784),
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19430C14__9S19430C13__A1__8S19430C2[] = {
  ABISELECT(1168,784),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn1440_N9S19430C13D1Ev,_ZThn972_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn1440_N9S19430C13D0Ev,_ZThn972_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__A1__9S19430C13__A1__8S19430C2[] = {
  0,
  ABISELECT(-1440,-972),
  ABISELECT(-1440,-972),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn2464_N9S19430C13D1Ev,_ZThn1668_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn2464_N9S19430C13D0Ev,_ZThn1668_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C13__A1__8S19430C2[] = {
  0,
  ABISELECT(-2464,-1668),
  ABISELECT(-1024,-696),
  ABISELECT(-2464,-1668),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn2176_N9S19430C13D1Ev,_ZThn1484_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn2176_N9S19430C13D0Ev,_ZThn1484_N9S19430C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__A1__9S19430C13__A1__8S19430C2[] = {
  ABISELECT(-2176,-1484),
  ABISELECT(-736,-512),
  ABISELECT(-2176,-1484),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN9S19430C16D1Ev();
extern void _ZN9S19430C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C16__8S19430C2[] = {
  ABISELECT(2800,1876),
  ABISELECT(1664,1148),
  ABISELECT(2720,1828),
  ABISELECT(1376,964),
  ABISELECT(640,452),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D0Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN8S19430C9D1Ev();
extern void _ZN8S19430C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C99S19430C16__A1__8S19430C2[] = {
  ABISELECT(1376,964),
  ABISELECT(640,452),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn640_N8S19430C9D1Ev,_ZThn452_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn640_N8S19430C9D0Ev,_ZThn452_N8S19430C9D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C99S19430C16__A1__8S19430C2[] = {
  0,
  ABISELECT(-640,-452),
  ABISELECT(-640,-452),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn1376_N8S19430C9D1Ev,_ZThn964_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn1376_N8S19430C9D0Ev,_ZThn964_N8S19430C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C99S19430C16__A1__8S19430C2[] = {
  ABISELECT(-1376,-964),
  ABISELECT(-736,-512),
  ABISELECT(-1376,-964),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn640_N9S19430C16D1Ev,_ZThn452_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn640_N9S19430C16D0Ev,_ZThn452_N9S19430C16D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C16__8S19430C2[] = {
  0,
  ABISELECT(-640,-452),
  ABISELECT(-640,-452),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn1376_N9S19430C16D1Ev,_ZThn964_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn1376_N9S19430C16D0Ev,_ZThn964_N9S19430C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C16__8S19430C2[] = {
  ABISELECT(-1376,-964),
  ABISELECT(-736,-512),
  ABISELECT(-1376,-964),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn1664_N9S19430C16D1Ev,_ZThn1148_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn1664_N9S19430C16D0Ev,_ZThn1148_N9S19430C16D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C16__8S19430C2[] = {
  0,
  ABISELECT(-1664,-1148),
  ABISELECT(-1024,-696),
  ABISELECT(-1664,-1148),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN8S19430C9D1Ev();
extern void _ZN8S19430C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C9__8S19430C2[] = {
  ABISELECT(464,324),
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C9__8S19430C2[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn464_N8S19430C9D1Ev,_ZThn324_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn464_N8S19430C9D0Ev,_ZThn324_N8S19430C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C9__8S19430C2[] = {
  ABISELECT(-464,-324),
  ABISELECT(-736,-512),
  ABISELECT(-464,-324),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev),
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C2[] = {
  ABISELECT(-736,-512),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C10__8S19430C2[] = {
  0,
  ABISELECT(736,512),
  ABISELECT(736,512),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__8S19430C2[] = {
  ABISELECT(-1024,-696),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C109S19430C15__A1__8S19430C2[] = {
  ABISELECT(-1024,-696),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C109S19430C15__A1__8S19430C2[] = {
  0,
  ABISELECT(1024,696),
  ABISELECT(1024,696),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C15__8S19430C2[] = {
  0,
  ABISELECT(1024,696),
  ABISELECT(1024,696),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
static  VTT_ENTRY vtt_S19430C2[] = {
  {&(_ZTV8S19430C2[10]),  10,73},
  {&(_tg__ZTV8S19430C3__8S19430C2[8]),  8,12},
  {&(_tg__ZTV9S19430C138S19430C3__8S19430C2[6]),  6,9},
  {&(_tg__ZTV9S19430C149S19430C138S19430C3__8S19430C2[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C149S19430C138S19430C3__8S19430C2[4]),  4,7},
  {&(_tg__ZTV9S19430C14__9S19430C138S19430C3__8S19430C2[3]),  3,5},
  {&(_tg__ZTV8S19430C4__A1__9S19430C138S19430C3__8S19430C2[4]),  4,7},
  {&(_tg__ZTV9S19430C15__9S19430C138S19430C3__8S19430C2[5]),  5,8},
  {&(_tg__ZTV9S19430C10__A1__9S19430C138S19430C3__8S19430C2[4]),  4,6},
  {&(_tg__ZTV8S19430C4__8S19430C3__8S19430C2[4]),  4,7},
  {&(_tg__ZTV8S19430C9__8S19430C3__8S19430C2[6]),  6,9},
  {&(_tg__ZTV9S19430C10__8S19430C3__8S19430C2[4]),  4,6},
  {&(_tg__ZTV9S19430C149S19430C13__8S19430C3__8S19430C2[3]),  3,5},
  {&(_tg__ZTV9S19430C15__8S19430C3__8S19430C2[5]),  5,8},
  {&(_tg__ZTV9S19430C13__A1__8S19430C2[6]),  6,9},
  {&(_tg__ZTV9S19430C149S19430C13__A1__8S19430C2[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C149S19430C13__A1__8S19430C2[4]),  4,7},
  {&(_tg__ZTV9S19430C14__9S19430C13__A1__8S19430C2[3]),  3,5},
  {&(_tg__ZTV8S19430C4__A1__9S19430C13__A1__8S19430C2[4]),  4,7},
  {&(_tg__ZTV9S19430C15__9S19430C13__A1__8S19430C2[5]),  5,8},
  {&(_tg__ZTV9S19430C10__A1__9S19430C13__A1__8S19430C2[4]),  4,6},
  {&(_tg__ZTV9S19430C16__8S19430C2[7]),  7,10},
  {&(_tg__ZTV8S19430C99S19430C16__A1__8S19430C2[4]),  4,7},
  {&(_tg__ZTV8S19430C4__8S19430C99S19430C16__A1__8S19430C2[4]),  4,7},
  {&(_tg__ZTV9S19430C10__8S19430C99S19430C16__A1__8S19430C2[4]),  4,6},
  {&(_tg__ZTV8S19430C4__9S19430C16__8S19430C2[4]),  4,7},
  {&(_tg__ZTV9S19430C10__9S19430C16__8S19430C2[4]),  4,6},
  {&(_tg__ZTV9S19430C15__9S19430C16__8S19430C2[5]),  5,8},
  {&(_ZTV8S19430C2[47]),  47,73},
  {&(_ZTV8S19430C2[56]),  56,73},
  {&(_ZTV8S19430C2[63]),  63,73},
  {&(_ZTV8S19430C2[17]),  17,73},
  {&(_ZTV8S19430C2[70]),  70,73},
  {&(_ZTV8S19430C2[25]),  25,73},
  {&(_ZTV8S19430C2[31]),  31,73},
  {&(_ZTV8S19430C2[40]),  40,73},
  {&(_tg__ZTV8S19430C9__8S19430C2[4]),  4,7},
  {&(_tg__ZTV8S19430C4__8S19430C9__8S19430C2[4]),  4,7},
  {&(_tg__ZTV9S19430C10__8S19430C9__8S19430C2[4]),  4,6},
  {&(_tg__ZTV9S19430C10__8S19430C2[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C10__8S19430C2[4]),  4,7},
  {&(_tg__ZTV9S19430C15__8S19430C2[3]),  3,6},
  {&(_tg__ZTV9S19430C109S19430C15__A1__8S19430C2[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C109S19430C15__A1__8S19430C2[4]),  4,7},
  {&(_tg__ZTV8S19430C4__9S19430C15__8S19430C2[4]),  4,7},
};
extern VTBL_ENTRY _ZTI8S19430C2[];
extern  VTBL_ENTRY _ZTV8S19430C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C2[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1664_N9S19430C16D0Ev,_ZThn1148_N9S19430C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1376_N9S19430C16D0Ev,_ZThn964_N9S19430C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1664_N9S19430C16D1Ev,_ZThn1148_N9S19430C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1376_N9S19430C16D1Ev,_ZThn964_N9S19430C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn640_N9S19430C16D0Ev,_ZThn452_N9S19430C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn640_N9S19430C16D1Ev,_ZThn452_N9S19430C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S19430C9D0Ev,_ZThn324_N8S19430C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1376_N8S19430C9D0Ev,_ZThn964_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S19430C9D1Ev,_ZThn324_N8S19430C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1376_N8S19430C9D1Ev,_ZThn964_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn640_N8S19430C9D0Ev,_ZThn452_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn640_N8S19430C9D1Ev,_ZThn452_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3344_N8S19430C3D0Ev,_ZThn2240_N8S19430C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N8S19430C3D0Ev,_ZThn2056_N8S19430C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3344_N8S19430C3D1Ev,_ZThn2240_N8S19430C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N8S19430C3D1Ev,_ZThn2056_N8S19430C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19430C3D0Ev,_ZTv0_n24_N8S19430C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2592_N8S19430C3D0Ev,_ZThn1732_N8S19430C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19430C3D1Ev,_ZTv0_n24_N8S19430C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2592_N8S19430C3D1Ev,_ZThn1732_N8S19430C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C3D0Ev,_ZTv0_n12_N8S19430C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2320_N8S19430C3D0Ev,_ZThn1544_N8S19430C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C3D1Ev,_ZTv0_n12_N8S19430C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2320_N8S19430C3D1Ev,_ZThn1544_N8S19430C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N9S19430C13D0Ev,_ZThn1484_N9S19430C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2464_N9S19430C13D0Ev,_ZThn1668_N9S19430C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N9S19430C13D0Ev,_ZThn2056_N9S19430C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3344_N9S19430C13D0Ev,_ZThn2240_N9S19430C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N9S19430C13D1Ev,_ZThn1484_N9S19430C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2464_N9S19430C13D1Ev,_ZThn1668_N9S19430C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N9S19430C13D1Ev,_ZThn2056_N9S19430C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3344_N9S19430C13D1Ev,_ZThn2240_N9S19430C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1440_N9S19430C13D0Ev,_ZThn972_N9S19430C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2320_N9S19430C13D0Ev,_ZThn1544_N9S19430C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1440_N9S19430C13D1Ev,_ZThn972_N9S19430C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2320_N9S19430C13D1Ev,_ZThn1544_N9S19430C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1168_N9S19430C14D0Ev,_ZThn784_N9S19430C14D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2048_N9S19430C14D0Ev,_ZThn1356_N9S19430C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1168_N9S19430C14D1Ev,_ZThn784_N9S19430C14D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2048_N9S19430C14D1Ev,_ZThn1356_N9S19430C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C2D0Ev,_ZTv0_n16_N8S19430C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3344_N8S19430C2D0Ev,_ZThn2240_N8S19430C2D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N8S19430C2D0Ev,_ZThn2056_N8S19430C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C2D1Ev,_ZTv0_n16_N8S19430C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3344_N8S19430C2D1Ev,_ZThn2240_N8S19430C2D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn3056_N8S19430C2D1Ev,_ZThn2056_N8S19430C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19430C2D0Ev,_ZTv0_n24_N8S19430C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2592_N8S19430C2D0Ev,_ZThn1732_N8S19430C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19430C2D1Ev,_ZTv0_n24_N8S19430C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2592_N8S19430C2D1Ev,_ZThn1732_N8S19430C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C2D0Ev,_ZTv0_n12_N8S19430C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2320_N8S19430C2D0Ev,_ZThn1544_N8S19430C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C2D1Ev,_ZTv0_n12_N8S19430C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2320_N8S19430C2D1Ev,_ZThn1544_N8S19430C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C2 = {  "S19430C2", // class name
  bases_S19430C2, 46,
  &(vtc_S19430C2[0]), // expected_vtbl_contents
  &(vtt_S19430C2[0]), // expected_vtt_contents
  ABISELECT(4528,3012), // object size
  NSPAIRA(_ZTI8S19430C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S19430C2),73, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S19430C2),45, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C19  : virtual S19430C7 , virtual S19430C4 , virtual S19430C16 , S19430C5 {
  __tsi64 s19430c19f0;
  int s19430c19f1[6];
  void *s19430c19f2;
  int s19430c19f3;
  int s19430c19f4:12;
  void *s19430c19f5;
  int s19430c19f6;
  virtual  ~S19430C19(); // _ZN9S19430C19D2Ev
  S19430C19(); // tgen
};
//SIG(-1 S19430C19) C1{ VBC2{ m FD Fi[2] Fp[7]} VBC3{ BC4{ m FL[4] Fc[8] Fp} BC5{ BC2 BC4 FU6{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD} VBC7{ VBC2 VBC3 BC8{ VBC3 VBC9{ VBC3 BC5 Fp FU6} BC10{ m Fi Fi Fi Fi Fi[4] Fl Fc FD Fi} BC4 v2 FC11{} FC3 Fi Fc[8] Fi FD} VBC12{ BC9 vd v3 FC5 Fi FC9} VBC4 vd Fi Fi:0 Fp} BC4 vd FL Fi[6] Fp Fi Fi:12 Fp Fi}


 S19430C19 ::~S19430C19(){ note_dtor("S19430C19", this);}
S19430C19 ::S19430C19(){ note_ctor("S19430C19", this);} // tgen

static void Test_S19430C19()
{
  extern Class_Descriptor cd_S19430C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(132,352)];
    init_test(&cd_S19430C19, buf);
    S19430C19 *dp, &lv = *(dp=new (buf) S19430C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2096,1404), "sizeof(S19430C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C19)");
    /*is_ambiguous_... S19430C19::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*), ABISELECT(128,100), "S19430C19");
    /*is_ambiguous_... S19430C16::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C16*), ABISELECT(128,100), "S19430C19");
    /*is_ambiguous_... S19430C4::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(216,152), "S19430C19");
    check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(272,196), "S19430C19");
    check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(352,244), "S19430C19");
    check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(272,196), "S19430C19");
    check_base_class_offset(lv, (S19430C4*), ABISELECT(208,148), "S19430C19");
    check_base_class_offset(lv, (S19430C4*)(S19430C16*), ABISELECT(208,148), "S19430C19");
    check_base_class_offset(lv, (S19430C4*)(S19430C9*)(S19430C16*), ABISELECT(208,148), "S19430C19");
    /*is_ambiguous_... S19430C19::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(208,148), "S19430C19");
    check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*), ABISELECT(208,148), "S19430C19");
    /*is_ambiguous_... S19430C19::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(976,672), "S19430C19");
    /*is_ambiguous_... S19430C19::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(1056,720), "S19430C19");
    /*is_ambiguous_... S19430C19::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(976,672), "S19430C19");
    check_base_class_offset(lv, (S19430C10*)(S19430C9*)(S19430C16*), ABISELECT(960,668), "S19430C19");
    check_base_class_offset(lv, (S19430C11*)(S19430C9*)(S19430C16*), ABISELECT(496,340), "S19430C19");
    /*is_ambiguous_... S19430C9::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*)(S19430C16*), ABISELECT(576,396), "S19430C19");
    check_base_class_offset(lv, (S19430C9*)(S19430C16*), ABISELECT(480,336), "S19430C19");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1184,800), "S19430C19");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1264,848), "S19430C19");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(1184,800), "S19430C19");
    check_base_class_offset(lv, (S19430C10*)(S19430C15*), ABISELECT(1168,796), "S19430C19");
    check_base_class_offset(lv, (S19430C15*)(S19430C16*), ABISELECT(1168,796), "S19430C19");
    /*is_ambiguous_... S19430C16::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C16*), ABISELECT(2048,1360), "S19430C19");
    check_base_class_offset(lv, (S19430C16*), ABISELECT(480,336), "S19430C19");
    /*is_ambiguous_... S19430C19::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*), ABISELECT(8,4), "S19430C19");
    check_field_offset(lv, s19430c19f0, ABISELECT(56,48), "S19430C19.s19430c19f0");
    check_field_offset(lv, s19430c19f1, ABISELECT(64,56), "S19430C19.s19430c19f1");
    check_field_offset(lv, s19430c19f2, ABISELECT(88,80), "S19430C19.s19430c19f2");
    check_field_offset(lv, s19430c19f3, ABISELECT(96,84), "S19430C19.s19430c19f3");
    set_bf_and_test(lv, s19430c19f4, ABISELECT(100,88), 0, 12, 1, "S19430C19");
    set_bf_and_test(lv, s19430c19f4, ABISELECT(100,88), 0, 12, hide_sll(1LL<<11), "S19430C19");
    check_field_offset(lv, s19430c19f5, ABISELECT(104,92), "S19430C19.s19430c19f5");
    check_field_offset(lv, s19430c19f6, ABISELECT(112,96), "S19430C19.s19430c19f6");
    test_class_info(&lv, &cd_S19430C19);
    dp->~S19430C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C19(Test_S19430C19, "S19430C19", ABISELECT(2096,1404));

#else // __cplusplus

extern void _ZN9S19430C19C1Ev();
extern void _ZN9S19430C19D2Ev();
Name_Map name_map_S19430C19[] = {
  NSPAIR(_ZN9S19430C19C1Ev),
  NSPAIR(_ZN9S19430C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C16;
extern VTBL_ENTRY _ZTI9S19430C16[];
extern  VTBL_ENTRY _ZTV9S19430C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C16[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
static Base_Class bases_S19430C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C7,    ABISELECT(128,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C5,    ABISELECT(216,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(272,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(352,244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(272,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(208,148), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C7,    ABISELECT(976,672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1056,720), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(976,672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(960,668), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(496,340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(576,396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19430C9,    ABISELECT(480,336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(1184,800), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1264,848), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(1184,800), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(1168,796), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C15,    ABISELECT(1168,796), //bcp->offset
    35, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S19430C5,    ABISELECT(2048,1360), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S19430C16,    ABISELECT(480,336), //bcp->offset
    17, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19430C19[];
extern void _ZN9S19430C19D1Ev();
extern void _ZN9S19430C19D0Ev();
extern void ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn208_N9S19430C19D1Ev,_ZThn148_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn208_N9S19430C19D0Ev,_ZThn148_N9S19430C19D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn480_N9S19430C19D1Ev,_ZThn336_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn480_N9S19430C19D0Ev,_ZThn336_N9S19430C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn960_N9S19430C19D1Ev,_ZThn668_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn960_N9S19430C19D0Ev,_ZThn668_N9S19430C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn1168_N9S19430C19D1Ev,_ZThn796_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn1168_N9S19430C19D0Ev,_ZThn796_N9S19430C19D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY vtc_S19430C19[] = {
  ABISELECT(2048,1360),
  ABISELECT(1168,796),
  ABISELECT(960,668),
  ABISELECT(480,336),
  ABISELECT(208,148),
  ABISELECT(128,100),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&_ZN9S19430C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C19D0Ev,
  0,
  ABISELECT(-208,-148),
  ABISELECT(-208,-148),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(-480,-336),
  0,
  ABISELECT(1568,1024),
  ABISELECT(688,460),
  ABISELECT(-352,-236),
  ABISELECT(480,332),
  ABISELECT(-272,-188),
  ABISELECT(-480,-336),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev),
  ABISELECT(-960,-668),
  ABISELECT(-752,-520),
  ABISELECT(-960,-668),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev),
  0,
  ABISELECT(-1168,-796),
  ABISELECT(-960,-648),
  ABISELECT(-1168,-796),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern VTBL_ENTRY _ZTV9S19430C19[];
extern void _ZN8S19430C92v2Ev();
extern void _ZN9S19430C16D1Ev();
extern void _ZN9S19430C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C16__9S19430C19[] = {
  ABISELECT(1568,1024),
  ABISELECT(688,460),
  ABISELECT(-352,-236),
  ABISELECT(480,332),
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D0Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN8S19430C9D1Ev();
extern void _ZN8S19430C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C99S19430C16__9S19430C19[] = {
  ABISELECT(480,332),
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C99S19430C16__9S19430C19[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn480_N8S19430C9D1Ev,_ZThn332_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn480_N8S19430C9D0Ev,_ZThn332_N8S19430C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C99S19430C16__9S19430C19[] = {
  ABISELECT(-480,-332),
  ABISELECT(-752,-520),
  ABISELECT(-480,-332),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C16__9S19430C19[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn480_N9S19430C16D1Ev,_ZThn332_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn480_N9S19430C16D0Ev,_ZThn332_N9S19430C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C16__9S19430C19[] = {
  ABISELECT(-480,-332),
  ABISELECT(-752,-520),
  ABISELECT(-480,-332),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn688_N9S19430C16D1Ev,_ZThn460_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn688_N9S19430C16D0Ev,_ZThn460_N9S19430C16D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C16__9S19430C19[] = {
  0,
  ABISELECT(-688,-460),
  ABISELECT(-960,-648),
  ABISELECT(-688,-460),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C19[] = {
  ABISELECT(-752,-520),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C10__9S19430C19[] = {
  0,
  ABISELECT(752,520),
  ABISELECT(752,520),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C19[] = {
  ABISELECT(-960,-648),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C109S19430C15__A1__9S19430C19[] = {
  ABISELECT(-960,-648),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C109S19430C15__A1__9S19430C19[] = {
  0,
  ABISELECT(960,648),
  ABISELECT(960,648),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C15__9S19430C19[] = {
  0,
  ABISELECT(960,648),
  ABISELECT(960,648),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
static  VTT_ENTRY vtt_S19430C19[] = {
  {&(_ZTV9S19430C19[8]),  8,43},
  {&(_ZTV9S19430C19[14]),  14,43},
  {&(_ZTV9S19430C19[26]),  26,43},
  {&(_ZTV9S19430C19[33]),  33,43},
  {&(_ZTV9S19430C19[40]),  40,43},
  {&(_tg__ZTV9S19430C16__9S19430C19[7]),  7,10},
  {&(_tg__ZTV8S19430C99S19430C16__9S19430C19[4]),  4,7},
  {&(_tg__ZTV8S19430C4__8S19430C99S19430C16__9S19430C19[4]),  4,7},
  {&(_tg__ZTV9S19430C10__8S19430C99S19430C16__9S19430C19[4]),  4,6},
  {&(_tg__ZTV8S19430C4__9S19430C16__9S19430C19[4]),  4,7},
  {&(_tg__ZTV9S19430C10__9S19430C16__9S19430C19[4]),  4,6},
  {&(_tg__ZTV9S19430C15__9S19430C16__9S19430C19[5]),  5,8},
  {&(_tg__ZTV9S19430C10__9S19430C19[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C10__9S19430C19[4]),  4,7},
  {&(_tg__ZTV9S19430C15__9S19430C19[3]),  3,6},
  {&(_tg__ZTV9S19430C109S19430C15__A1__9S19430C19[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C109S19430C15__A1__9S19430C19[4]),  4,7},
  {&(_tg__ZTV8S19430C4__9S19430C15__9S19430C19[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S19430C19[];
extern  VTBL_ENTRY _ZTV9S19430C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C19[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn688_N9S19430C16D0Ev,_ZThn460_N9S19430C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn480_N9S19430C16D0Ev,_ZThn332_N9S19430C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn688_N9S19430C16D1Ev,_ZThn460_N9S19430C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn480_N9S19430C16D1Ev,_ZThn332_N9S19430C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S19430C9D0Ev,_ZThn332_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S19430C9D1Ev,_ZThn332_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1168_N9S19430C19D0Ev,_ZThn796_N9S19430C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn960_N9S19430C19D0Ev,_ZThn668_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1168_N9S19430C19D1Ev,_ZThn796_N9S19430C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn960_N9S19430C19D1Ev,_ZThn668_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N9S19430C19D0Ev,_ZThn336_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N9S19430C19D1Ev,_ZThn336_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19430C19D0Ev,_ZThn148_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn208_N9S19430C19D1Ev,_ZThn148_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C19 = {  "S19430C19", // class name
  bases_S19430C19, 21,
  &(vtc_S19430C19[0]), // expected_vtbl_contents
  &(vtt_S19430C19[0]), // expected_vtt_contents
  ABISELECT(2096,1404), // object size
  NSPAIRA(_ZTI9S19430C19),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S19430C19),43, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19430C19),18, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C18  : S19430C15 , virtual S19430C5 , S19430C6 , S19430C19 , S19430C4 {
  ::S19430C16 s19430c18f0[10];
  void *s19430c18f1[5];
  ~S19430C18(); // tgen
  S19430C18(); // tgen
};
//SIG(-1 S19430C18) C1{ BC2{ BC3{ VBC4{ BC5{ m FL[4] Fc[8] Fp} BC6{ BC7{ m FD Fi[2] Fp[7]} BC5 FU8{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD} BC6 Fp FU8} vd v2 FC6 Fi FC3} VBC5 BC6 BC9{ VBC7 VBC4 VBC10{ VBC7 VBC4 BC11{ VBC4 VBC3 BC12{ m Fi Fi Fi Fi Fi[4] Fl Fc FD Fi} BC5 v3 FC13{} FC4 Fi Fc[8] Fi FD} VBC2 VBC5 vd Fi Fi:0 Fp} BC5 vd FL Fi[6] Fp Fi Fi:12 Fp Fi} BC4 FC10[10] Fp[5]}


S19430C18 ::~S19430C18(){ note_dtor("S19430C18", this);} // tgen
S19430C18 ::S19430C18(){ note_ctor("S19430C18", this);} // tgen

static void Test_S19430C18()
{
  extern Class_Descriptor cd_S19430C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1448,3834)];
    init_test(&cd_S19430C18, buf);
    S19430C18 *dp, &lv = *(dp=new (buf) S19430C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(23152,15332), "sizeof(S19430C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C18)");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(21192,14032), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(21248,14076), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(21328,14124), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(21248,14076), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*), ABISELECT(21184,14028), "S19430C18");
    check_base_class_offset(lv, (S19430C4*)(S19430C19*), ABISELECT(21184,14028), "S19430C18");
    check_base_class_offset(lv, (S19430C4*)(S19430C16*), ABISELECT(21184,14028), "S19430C18");
    check_base_class_offset(lv, (S19430C4*)(S19430C9*)(S19430C16*), ABISELECT(21184,14028), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(21184,14028), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*), ABISELECT(21184,14028), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(16,4), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(96,52), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(16,4), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C15*), 0, "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C15*), 0, "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*), ABISELECT(21456,14216), "S19430C18");
    /*is_ambiguous_... S19430C16::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C16*), ABISELECT(21456,14216), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*), ABISELECT(880,564), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*), ABISELECT(960,612), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*), ABISELECT(880,564), "S19430C18");
    /*is_ambiguous_... S19430C19::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C19*), ABISELECT(21504,14260), "S19430C18");
    /*is_ambiguous_... S19430C16::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C16*), ABISELECT(21504,14260), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(22080,14644), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(22160,14692), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(22080,14644), "S19430C18");
    check_base_class_offset(lv, (S19430C10*)(S19430C9*)(S19430C16*), ABISELECT(22064,14640), "S19430C18");
    check_base_class_offset(lv, (S19430C11*)(S19430C9*)(S19430C16*), ABISELECT(21600,14312), "S19430C18");
    /*is_ambiguous_... S19430C9::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*)(S19430C16*), ABISELECT(21680,14368), "S19430C18");
    check_base_class_offset(lv, (S19430C9*)(S19430C16*), ABISELECT(21584,14308), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(22288,14772), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(22368,14820), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(22288,14772), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C15*), ABISELECT(22272,14768), "S19430C18");
    check_base_class_offset(lv, (S19430C15*)(S19430C16*), ABISELECT(22272,14768), "S19430C18");
    check_base_class_offset(lv, (S19430C16*)(S19430C19*), ABISELECT(21584,14308), "S19430C18");
    /*is_ambiguous_... S19430C19::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C19*), ABISELECT(1064,684), "S19430C18");
    check_base_class_offset(lv, (S19430C19*), ABISELECT(1056,680), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(1192,784), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(1248,828), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(1328,876), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(1248,828), "S19430C18");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*), ABISELECT(1184,780), "S19430C18");
    check_field_offset(lv, s19430c18f0, ABISELECT(1456,968), "S19430C18.s19430c18f0");
    check_field_offset(lv, s19430c18f1, ABISELECT(21136,14008), "S19430C18.s19430c18f1");
    test_class_info(&lv, &cd_S19430C18);
    dp->~S19430C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C18(Test_S19430C18, "S19430C18", ABISELECT(23152,15332));

#else // __cplusplus

extern void _ZN9S19430C18C1Ev();
extern void _ZN9S19430C18D1Ev();
Name_Map name_map_S19430C18[] = {
  NSPAIR(_ZN9S19430C18C1Ev),
  NSPAIR(_ZN9S19430C18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C16;
extern VTBL_ENTRY _ZTI9S19430C16[];
extern  VTBL_ENTRY _ZTV9S19430C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C16[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C19;
extern VTBL_ENTRY _ZTI9S19430C19[];
extern  VTBL_ENTRY _ZTV9S19430C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C19[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
static Base_Class bases_S19430C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C5,    ABISELECT(21192,14032), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(21248,14076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(21328,14124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(21248,14076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(21184,14028), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19430C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C5,    ABISELECT(21456,14216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C7,    ABISELECT(880,564), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(960,612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(880,564), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C7,    ABISELECT(21504,14260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(22080,14644), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(22160,14692), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(22080,14644), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(22064,14640), //bcp->offset
    45, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(21600,14312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(21680,14368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19430C9,    ABISELECT(21584,14308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(22288,14772), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(22368,14820), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(22288,14772), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(22272,14768), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S19430C15,    ABISELECT(22272,14768), //bcp->offset
    51, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S19430C16,    ABISELECT(21584,14308), //bcp->offset
    33, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S19430C5,    ABISELECT(1064,684), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C19,    ABISELECT(1056,680), //bcp->offset
    11, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C5,    ABISELECT(1192,784), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(1248,828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1328,876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(1248,828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(1184,780), //bcp->offset
    21, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19430C18[];
extern void _ZN9S19430C18D1Ev();
extern void _ZN9S19430C18D0Ev();
extern void _ZN9S19430C152v3Ev();
extern void ABISELECT(_ZThn1056_N9S19430C18D1Ev,_ZThn680_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn1056_N9S19430C18D0Ev,_ZThn680_N9S19430C18D0Ev)();
extern void ABISELECT(_ZThn1184_N9S19430C18D1Ev,_ZThn780_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn1184_N9S19430C18D0Ev,_ZThn780_N9S19430C18D0Ev)();
extern void _ZN8S19430C42v1Ev();
extern void ABISELECT(_ZTv0_n24_N9S19430C18D1Ev,_ZTv0_n12_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn21184_N9S19430C18D1Ev,_ZThn14028_N9S19430C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C18D0Ev,_ZTv0_n12_N9S19430C18D0Ev)();
extern void ABISELECT(_ZThn21184_N9S19430C18D0Ev,_ZThn14028_N9S19430C18D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n72_N9S19430C18D1Ev,_ZTv0_n36_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn21584_N9S19430C18D1Ev,_ZThn14308_N9S19430C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19430C18D0Ev,_ZTv0_n36_N9S19430C18D0Ev)();
extern void ABISELECT(_ZThn21584_N9S19430C18D0Ev,_ZThn14308_N9S19430C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C18D1Ev,_ZTv0_n16_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn22064_N9S19430C18D1Ev,_ZThn14640_N9S19430C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C18D0Ev,_ZTv0_n16_N9S19430C18D0Ev)();
extern void ABISELECT(_ZThn22064_N9S19430C18D0Ev,_ZThn14640_N9S19430C18D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C18D1Ev,_ZTv0_n16_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn22272_N9S19430C18D1Ev,_ZThn14768_N9S19430C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C18D0Ev,_ZTv0_n16_N9S19430C18D0Ev)();
extern void ABISELECT(_ZThn22272_N9S19430C18D0Ev,_ZThn14768_N9S19430C18D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY vtc_S19430C18[] = {
  ABISELECT(22272,14768),
  ABISELECT(22064,14640),
  ABISELECT(21584,14308),
  ABISELECT(21504,14260),
  ABISELECT(21456,14216),
  ABISELECT(21184,14028),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&_ZN9S19430C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
  ABISELECT(20400,13536),
  ABISELECT(21216,14088),
  ABISELECT(21008,13960),
  ABISELECT(20528,13628),
  ABISELECT(20128,13348),
  ABISELECT(20448,13580),
  ABISELECT(-1056,-680),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1056_N9S19430C18D1Ev,_ZThn680_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1056_N9S19430C18D0Ev,_ZThn680_N9S19430C18D0Ev),
  ABISELECT(-1184,-780),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1184_N9S19430C18D1Ev,_ZThn780_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1184_N9S19430C18D0Ev,_ZThn780_N9S19430C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  0,
  ABISELECT(-21184,-14028),
  ABISELECT(-21184,-14028),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C18D1Ev,_ZTv0_n12_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C18D0Ev,_ZTv0_n12_N9S19430C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(-21584,-14308),
  0,
  ABISELECT(-128,-92),
  ABISELECT(688,460),
  ABISELECT(-80,-48),
  ABISELECT(480,332),
  ABISELECT(-400,-280),
  ABISELECT(-21584,-14308),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C18D1Ev,_ZTv0_n36_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C18D0Ev,_ZTv0_n36_N9S19430C18D0Ev),
  ABISELECT(-22064,-14640),
  ABISELECT(-880,-612),
  ABISELECT(-22064,-14640),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C18D1Ev,_ZTv0_n16_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C18D0Ev,_ZTv0_n16_N9S19430C18D0Ev),
  0,
  ABISELECT(-22272,-14768),
  ABISELECT(-1088,-740),
  ABISELECT(-22272,-14768),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C18D1Ev,_ZTv0_n16_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C18D0Ev,_ZTv0_n16_N9S19430C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern VTBL_ENTRY _ZTV9S19430C18[];
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__A__9S19430C18[] = {
  ABISELECT(21184,14028),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C109S19430C15__9S19430C18[] = {
  ABISELECT(21184,14028),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZThn21184_N9S19430C10D1Ev,_ZThn14028_N9S19430C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void ABISELECT(_ZThn21184_N9S19430C10D0Ev,_ZThn14028_N9S19430C10D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C109S19430C15__9S19430C18[] = {
  0,
  ABISELECT(-21184,-14028),
  ABISELECT(-21184,-14028),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZThn21184_N9S19430C15D1Ev,_ZThn14028_N9S19430C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void ABISELECT(_ZThn21184_N9S19430C15D0Ev,_ZThn14028_N9S19430C15D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C15__A__9S19430C18[] = {
  0,
  ABISELECT(-21184,-14028),
  ABISELECT(-21184,-14028),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C19D1Ev();
extern void _ZN9S19430C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C19__9S19430C18[] = {
  ABISELECT(20400,13536),
  ABISELECT(21216,14088),
  ABISELECT(21008,13960),
  ABISELECT(20528,13628),
  ABISELECT(20128,13348),
  ABISELECT(20448,13580),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&_ZN9S19430C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C19D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn20128_N9S19430C19D1Ev,_ZThn13348_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn20128_N9S19430C19D0Ev,_ZThn13348_N9S19430C19D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C19__9S19430C18[] = {
  0,
  ABISELECT(-20128,-13348),
  ABISELECT(-20128,-13348),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn20528_N9S19430C19D1Ev,_ZThn13628_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn20528_N9S19430C19D0Ev,_ZThn13628_N9S19430C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C16__9S19430C19__9S19430C18[] = {
  ABISELECT(-20528,-13628),
  0,
  ABISELECT(-128,-92),
  ABISELECT(688,460),
  ABISELECT(-80,-48),
  ABISELECT(480,332),
  ABISELECT(-400,-280),
  ABISELECT(-20528,-13628),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn21008_N9S19430C19D1Ev,_ZThn13960_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn21008_N9S19430C19D0Ev,_ZThn13960_N9S19430C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C19__9S19430C18[] = {
  ABISELECT(-21008,-13960),
  ABISELECT(-880,-612),
  ABISELECT(-21008,-13960),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn21216_N9S19430C19D1Ev,_ZThn14088_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn21216_N9S19430C19D0Ev,_ZThn14088_N9S19430C19D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C19__9S19430C18[] = {
  0,
  ABISELECT(-21216,-14088),
  ABISELECT(-1088,-740),
  ABISELECT(-21216,-14088),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN9S19430C16D1Ev();
extern void _ZN9S19430C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C16__9S19430C18[] = {
  ABISELECT(-128,-92),
  ABISELECT(688,460),
  ABISELECT(-80,-48),
  ABISELECT(480,332),
  ABISELECT(-400,-280),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D0Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN8S19430C9D1Ev();
extern void _ZN8S19430C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C99S19430C16__9S19430C18[] = {
  ABISELECT(480,332),
  ABISELECT(-400,-280),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C99S19430C16__9S19430C18[] = {
  0,
  ABISELECT(400,280),
  ABISELECT(400,280),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn480_N8S19430C9D1Ev,_ZThn332_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn480_N8S19430C9D0Ev,_ZThn332_N8S19430C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C99S19430C16__9S19430C18[] = {
  ABISELECT(-480,-332),
  ABISELECT(-880,-612),
  ABISELECT(-480,-332),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C16__9S19430C18[] = {
  0,
  ABISELECT(400,280),
  ABISELECT(400,280),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn480_N9S19430C16D1Ev,_ZThn332_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn480_N9S19430C16D0Ev,_ZThn332_N9S19430C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C16__9S19430C18[] = {
  ABISELECT(-480,-332),
  ABISELECT(-880,-612),
  ABISELECT(-480,-332),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn688_N9S19430C16D1Ev,_ZThn460_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn688_N9S19430C16D0Ev,_ZThn460_N9S19430C16D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C16__9S19430C18[] = {
  0,
  ABISELECT(-688,-460),
  ABISELECT(-1088,-740),
  ABISELECT(-688,-460),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C10__A1__9S19430C18[] = {
  ABISELECT(-880,-612),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C10__A1__9S19430C18[] = {
  0,
  ABISELECT(880,612),
  ABISELECT(880,612),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__A1__9S19430C18[] = {
  ABISELECT(-1088,-740),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C109S19430C15__A2__9S19430C18[] = {
  ABISELECT(-1088,-740),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C109S19430C15__A2__9S19430C18[] = {
  0,
  ABISELECT(1088,740),
  ABISELECT(1088,740),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C15__A1__9S19430C18[] = {
  0,
  ABISELECT(1088,740),
  ABISELECT(1088,740),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
static  VTT_ENTRY vtt_S19430C18[] = {
  {&(_ZTV9S19430C18[8]),  8,59},
  {&(_tg__ZTV9S19430C15__A__9S19430C18[3]),  3,6},
  {&(_tg__ZTV9S19430C109S19430C15__9S19430C18[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C109S19430C15__9S19430C18[4]),  4,7},
  {&(_tg__ZTV8S19430C4__9S19430C15__A__9S19430C18[4]),  4,7},
  {&(_tg__ZTV9S19430C19__9S19430C18[8]),  8,10},
  {&(_tg__ZTV8S19430C4__9S19430C19__9S19430C18[4]),  4,7},
  {&(_tg__ZTV9S19430C16__9S19430C19__9S19430C18[9]),  9,12},
  {&(_tg__ZTV9S19430C10__9S19430C19__9S19430C18[4]),  4,6},
  {&(_tg__ZTV9S19430C15__9S19430C19__9S19430C18[5]),  5,8},
  {&(_ZTV9S19430C18[30]),  30,59},
  {&(_ZTV9S19430C18[19]),  19,59},
  {&(_ZTV9S19430C18[42]),  42,59},
  {&(_ZTV9S19430C18[49]),  49,59},
  {&(_ZTV9S19430C18[56]),  56,59},
  {&(_tg__ZTV9S19430C16__9S19430C18[7]),  7,10},
  {&(_tg__ZTV8S19430C99S19430C16__9S19430C18[4]),  4,7},
  {&(_tg__ZTV8S19430C4__8S19430C99S19430C16__9S19430C18[4]),  4,7},
  {&(_tg__ZTV9S19430C10__8S19430C99S19430C16__9S19430C18[4]),  4,6},
  {&(_tg__ZTV8S19430C4__9S19430C16__9S19430C18[4]),  4,7},
  {&(_tg__ZTV9S19430C10__9S19430C16__9S19430C18[4]),  4,6},
  {&(_tg__ZTV9S19430C15__9S19430C16__9S19430C18[5]),  5,8},
  {&(_tg__ZTV9S19430C10__A1__9S19430C18[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C10__A1__9S19430C18[4]),  4,7},
  {&(_tg__ZTV9S19430C15__A1__9S19430C18[3]),  3,6},
  {&(_tg__ZTV9S19430C109S19430C15__A2__9S19430C18[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C109S19430C15__A2__9S19430C18[4]),  4,7},
  {&(_tg__ZTV8S19430C4__9S19430C15__A1__9S19430C18[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S19430C18[];
extern  VTBL_ENTRY _ZTV9S19430C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C18[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn688_N9S19430C16D0Ev,_ZThn460_N9S19430C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn480_N9S19430C16D0Ev,_ZThn332_N9S19430C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn688_N9S19430C16D1Ev,_ZThn460_N9S19430C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn480_N9S19430C16D1Ev,_ZThn332_N9S19430C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S19430C9D0Ev,_ZThn332_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S19430C9D1Ev,_ZThn332_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21216_N9S19430C19D0Ev,_ZThn14088_N9S19430C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn21008_N9S19430C19D0Ev,_ZThn13960_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21216_N9S19430C19D1Ev,_ZThn14088_N9S19430C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn21008_N9S19430C19D1Ev,_ZThn13960_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20528_N9S19430C19D0Ev,_ZThn13628_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20528_N9S19430C19D1Ev,_ZThn13628_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20128_N9S19430C19D0Ev,_ZThn13348_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20128_N9S19430C19D1Ev,_ZThn13348_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21184_N9S19430C15D0Ev,_ZThn14028_N9S19430C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21184_N9S19430C15D1Ev,_ZThn14028_N9S19430C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21184_N9S19430C10D0Ev,_ZThn14028_N9S19430C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21184_N9S19430C10D1Ev,_ZThn14028_N9S19430C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C18D0Ev,_ZTv0_n16_N9S19430C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22272_N9S19430C18D0Ev,_ZThn14768_N9S19430C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22064_N9S19430C18D0Ev,_ZThn14640_N9S19430C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C18D1Ev,_ZTv0_n16_N9S19430C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22272_N9S19430C18D1Ev,_ZThn14768_N9S19430C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22064_N9S19430C18D1Ev,_ZThn14640_N9S19430C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C18D0Ev,_ZTv0_n36_N9S19430C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21584_N9S19430C18D0Ev,_ZThn14308_N9S19430C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C18D1Ev,_ZTv0_n36_N9S19430C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21584_N9S19430C18D1Ev,_ZThn14308_N9S19430C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C18D0Ev,_ZTv0_n12_N9S19430C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21184_N9S19430C18D0Ev,_ZThn14028_N9S19430C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C18D1Ev,_ZTv0_n12_N9S19430C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21184_N9S19430C18D1Ev,_ZThn14028_N9S19430C18D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C18 = {  "S19430C18", // class name
  bases_S19430C18, 35,
  &(vtc_S19430C18[0]), // expected_vtbl_contents
  &(vtt_S19430C18[0]), // expected_vtt_contents
  ABISELECT(23152,15332), // object size
  NSPAIRA(_ZTI9S19430C18),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S19430C18),59, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19430C18),28, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C17  : virtual S19430C15 , S19430C3 , S19430C18 {
  ::S19430C8 s19430c17f0;
  void *s19430c17f1;
  int s19430c17f2;
  virtual  ~S19430C17(); // _ZN9S19430C17D2Ev
  S19430C17(); // tgen
};
//SIG(-1 S19430C17) C1{ VBC2{ BC3{ VBC4{ BC5{ m FL[4] Fc[8] Fp} BC6{ BC7{ m FD Fi[2] Fp[7]} BC5 FU8{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD} BC6 Fp FU8} vd v2 FC6 Fi FC3} BC9{ VBC4 VBC10{ VBC4 VBC3 BC11{ m Fi Fi Fi Fi Fi[4] Fl Fc FD Fi} BC5 v3 FC12{} FC4 Fi Fc[8] Fi FD} VBC11 BC13{ BC4 BC14{ BC11 BC7 VBC4 vd Fi FC4 Fl Fi} VBC2 VBC6 VBC3 Fp Fi Fi Fp Fp Fi} vd v4 Fi Fi Fp[8] FL Fc} BC15{ BC2 VBC5 BC6 BC16{ VBC7 VBC4 VBC17{ VBC7 VBC4 BC10 VBC2 VBC5 vd Fi Fi:0 Fp} BC5 vd FL Fi[6] Fp Fi Fi:12 Fp Fi} BC4 FC17[10] Fp[5]} vd FU8 Fp Fi}


 S19430C17 ::~S19430C17(){ note_dtor("S19430C17", this);}
S19430C17 ::S19430C17(){ note_ctor("S19430C17", this);} // tgen

static void Test_S19430C17()
{
  extern Class_Descriptor cd_S19430C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1549,4104)];
    init_test(&cd_S19430C17, buf);
    S19430C17 *dp, &lv = *(dp=new (buf) S19430C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24768,16412), "sizeof(S19430C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C17)");
    /*is_ambiguous_... S19430C17::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(22968,15180), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(23024,15224), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(23104,15272), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(23024,15224), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*), ABISELECT(22960,15176), "S19430C17");
    /*is_ambiguous_... S19430C3::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C3*), ABISELECT(22960,15176), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C9*), ABISELECT(22960,15176), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(22960,15176), "S19430C17");
    check_base_class_offset(lv, (S19430C4*)(S19430C14*)(S19430C13*)(S19430C3*), ABISELECT(22960,15176), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*)(S19430C18*), ABISELECT(22960,15176), "S19430C17");
    check_base_class_offset(lv, (S19430C4*)(S19430C19*)(S19430C18*), ABISELECT(22960,15176), "S19430C17");
    check_base_class_offset(lv, (S19430C4*)(S19430C16*), ABISELECT(22960,15176), "S19430C17");
    check_base_class_offset(lv, (S19430C4*)(S19430C9*)(S19430C16*), ABISELECT(22960,15176), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(22096,14616), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(22176,14664), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(22096,14616), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C15*), ABISELECT(22080,14612), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C15*), ABISELECT(22080,14612), "S19430C17");
    check_base_class_offset(lv, (S19430C15*)(S19430C13*)(S19430C3*), ABISELECT(22080,14612), "S19430C17");
    check_base_class_offset(lv, (S19430C15*)(S19430C16*), ABISELECT(22080,14612), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(23712,15692), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(23792,15740), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(23712,15692), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C9*), ABISELECT(23696,15688), "S19430C17");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C13*)(S19430C3*), ABISELECT(23696,15688), "S19430C17");
    check_base_class_offset(lv, (S19430C10*)(S19430C9*)(S19430C16*), ABISELECT(23696,15688), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C9*), ABISELECT(23248,15368), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*), ABISELECT(23328,15424), "S19430C17");
    check_base_class_offset(lv, (S19430C9*)(S19430C3*), ABISELECT(23232,15364), "S19430C17");
    /*is_ambiguous_... S19430C3::S19430C11 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C3*), ABISELECT(23904,15816), "S19430C17");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C13*)(S19430C3*), ABISELECT(8,4), "S19430C17");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*), ABISELECT(64,48), "S19430C17");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*), ABISELECT(144,96), "S19430C17");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*), ABISELECT(64,48), "S19430C17");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C13*)(S19430C3*), 0, "S19430C17");
    check_base_class_offset(lv, (S19430C11*)(S19430C14*)(S19430C13*)(S19430C3*), ABISELECT(288,192), "S19430C17");
    /*is_ambiguous_... S19430C14::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*)(S19430C13*)(S19430C3*), ABISELECT(368,248), "S19430C17");
    check_base_class_offset(lv, (S19430C14*)(S19430C13*)(S19430C3*), ABISELECT(272,188), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*), ABISELECT(23984,15872), "S19430C17");
    /*is_ambiguous_... S19430C17::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*), ABISELECT(24064,15920), "S19430C17");
    /*is_ambiguous_... S19430C13::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C13*)(S19430C3*), ABISELECT(23984,15872), "S19430C17");
    check_base_class_offset(lv, (S19430C13*)(S19430C3*), 0, "S19430C17");
    check_base_class_offset(lv, (S19430C3*), 0, "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*)(S19430C18*), ABISELECT(896,576), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*)(S19430C18*), ABISELECT(976,624), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*)(S19430C18*), ABISELECT(896,576), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C15*)(S19430C18*), ABISELECT(880,572), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C15*)(S19430C18*), ABISELECT(880,572), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C18*), ABISELECT(24160,15988), "S19430C17");
    /*is_ambiguous_... S19430C16::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C16*), ABISELECT(24160,15988), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C18*), ABISELECT(1760,1136), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C18*), ABISELECT(1840,1184), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C18*), ABISELECT(1760,1136), "S19430C17");
    /*is_ambiguous_... S19430C19::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C19*)(S19430C18*), ABISELECT(24208,16032), "S19430C17");
    /*is_ambiguous_... S19430C16::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C16*), ABISELECT(24208,16032), "S19430C17");
    check_base_class_offset(lv, (S19430C11*)(S19430C9*)(S19430C16*), ABISELECT(24304,16084), "S19430C17");
    /*is_ambiguous_... S19430C9::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*)(S19430C16*), ABISELECT(24384,16140), "S19430C17");
    check_base_class_offset(lv, (S19430C9*)(S19430C16*), ABISELECT(24288,16080), "S19430C17");
    check_base_class_offset(lv, (S19430C16*)(S19430C19*)(S19430C18*), ABISELECT(24288,16080), "S19430C17");
    /*is_ambiguous_... S19430C19::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C19*)(S19430C18*), ABISELECT(1944,1256), "S19430C17");
    check_base_class_offset(lv, (S19430C19*)(S19430C18*), ABISELECT(1936,1252), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C18*), ABISELECT(2072,1356), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C18*), ABISELECT(2128,1400), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C18*), ABISELECT(2208,1448), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C18*), ABISELECT(2128,1400), "S19430C17");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C18*), ABISELECT(2064,1352), "S19430C17");
    check_base_class_offset(lv, (S19430C18*), ABISELECT(880,572), "S19430C17");
    check_field_offset(lv, s19430c17f0, ABISELECT(22056,14600), "S19430C17.s19430c17f0");
    check_field_offset(lv, s19430c17f1, ABISELECT(22064,14604), "S19430C17.s19430c17f1");
    check_field_offset(lv, s19430c17f2, ABISELECT(22072,14608), "S19430C17.s19430c17f2");
    test_class_info(&lv, &cd_S19430C17);
    dp->~S19430C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C17(Test_S19430C17, "S19430C17", ABISELECT(24768,16412));

#else // __cplusplus

extern void _ZN9S19430C17C1Ev();
extern void _ZN9S19430C17D2Ev();
Name_Map name_map_S19430C17[] = {
  NSPAIR(_ZN9S19430C17C1Ev),
  NSPAIR(_ZN9S19430C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C13;
extern VTBL_ENTRY _ZTI9S19430C13[];
extern  VTBL_ENTRY _ZTV9S19430C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C13[];
extern Class_Descriptor cd_S19430C3;
extern VTBL_ENTRY _ZTI8S19430C3[];
extern  VTBL_ENTRY _ZTV8S19430C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C3[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C16;
extern VTBL_ENTRY _ZTI9S19430C16[];
extern  VTBL_ENTRY _ZTV9S19430C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C16[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C19;
extern VTBL_ENTRY _ZTI9S19430C19[];
extern  VTBL_ENTRY _ZTV9S19430C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C19[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C18;
extern VTBL_ENTRY _ZTI9S19430C18[];
extern  VTBL_ENTRY _ZTV9S19430C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C18[];
static Base_Class bases_S19430C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C5,    ABISELECT(22968,15180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(23024,15224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(23104,15272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(23024,15224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(22960,15176), //bcp->offset
    54, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(22096,14616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(22176,14664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(22096,14616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(22080,14612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19430C15,    ABISELECT(22080,14612), //bcp->offset
    46, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S19430C7,    ABISELECT(23712,15692), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(23792,15740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(23712,15692), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(23696,15688), //bcp->offset
    70, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(23248,15368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(23328,15424), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C9,    ABISELECT(23232,15364), //bcp->offset
    61, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(23904,15816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S19430C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(144,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(64,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S19430C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C11,    ABISELECT(288,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(368,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19430C14,    ABISELECT(272,188), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(23984,15872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(24064,15920), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(23984,15872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S19430C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19430C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C7,    ABISELECT(896,576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(976,624), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(896,576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(880,572), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19430C15,    ABISELECT(880,572), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(24160,15988), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    44, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(1760,1136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1840,1184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(1760,1136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(24208,16032), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    44, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(24304,16084), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(24384,16140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S19430C9,    ABISELECT(24288,16080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S19430C16,    ABISELECT(24288,16080), //bcp->offset
    76, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    46, //immediately_derived
  0, 1},
  {&cd_S19430C5,    ABISELECT(1944,1256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S19430C19,    ABISELECT(1936,1252), //bcp->offset
    31, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2072,1356), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(2128,1400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2208,1448), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(2128,1400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    51, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(2064,1352), //bcp->offset
    41, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    52, //immediately_derived
  0, 0},
  {&cd_S19430C18,    ABISELECT(880,572), //bcp->offset
    20, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19430C17[];
extern void _ZN9S19430C17D1Ev();
extern void _ZN9S19430C17D0Ev();
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C32v4Ev();
extern void ABISELECT(_ZThn272_N9S19430C17D1Ev,_ZThn188_N9S19430C17D1Ev)();
extern void ABISELECT(_ZThn272_N9S19430C17D0Ev,_ZThn188_N9S19430C17D0Ev)();
extern void ABISELECT(_ZThn880_N9S19430C17D1Ev,_ZThn572_N9S19430C17D1Ev)();
extern void ABISELECT(_ZThn880_N9S19430C17D0Ev,_ZThn572_N9S19430C17D0Ev)();
extern void _ZN9S19430C152v3Ev();
extern void ABISELECT(_ZThn1936_N9S19430C17D1Ev,_ZThn1252_N9S19430C17D1Ev)();
extern void ABISELECT(_ZThn1936_N9S19430C17D0Ev,_ZThn1252_N9S19430C17D0Ev)();
extern void ABISELECT(_ZThn2064_N9S19430C17D1Ev,_ZThn1352_N9S19430C17D1Ev)();
extern void ABISELECT(_ZThn2064_N9S19430C17D0Ev,_ZThn1352_N9S19430C17D0Ev)();
extern void _ZN8S19430C42v1Ev();
extern void ABISELECT(_ZTv0_n32_N9S19430C17D1Ev,_ZTv0_n16_N9S19430C17D1Ev)();
extern void ABISELECT(_ZThn22080_N9S19430C17D1Ev,_ZThn14612_N9S19430C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C17D0Ev,_ZTv0_n16_N9S19430C17D0Ev)();
extern void ABISELECT(_ZThn22080_N9S19430C17D0Ev,_ZThn14612_N9S19430C17D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
extern void ABISELECT(_ZTv0_n24_N9S19430C17D1Ev,_ZTv0_n12_N9S19430C17D1Ev)();
extern void ABISELECT(_ZThn22960_N9S19430C17D1Ev,_ZThn15176_N9S19430C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C17D0Ev,_ZTv0_n12_N9S19430C17D0Ev)();
extern void ABISELECT(_ZThn22960_N9S19430C17D0Ev,_ZThn15176_N9S19430C17D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n48_N9S19430C17D1Ev,_ZTv0_n24_N9S19430C17D1Ev)();
extern void ABISELECT(_ZThn23232_N9S19430C17D1Ev,_ZThn15364_N9S19430C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N9S19430C17D0Ev,_ZTv0_n24_N9S19430C17D0Ev)();
extern void ABISELECT(_ZThn23232_N9S19430C17D0Ev,_ZThn15364_N9S19430C17D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C17D1Ev,_ZTv0_n16_N9S19430C17D1Ev)();
extern void ABISELECT(_ZThn23696_N9S19430C17D1Ev,_ZThn15688_N9S19430C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C17D0Ev,_ZTv0_n16_N9S19430C17D0Ev)();
extern void ABISELECT(_ZThn23696_N9S19430C17D0Ev,_ZThn15688_N9S19430C17D0Ev)() __attribute__((weak));
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n72_N9S19430C17D1Ev,_ZTv0_n36_N9S19430C17D1Ev)();
extern void ABISELECT(_ZThn24288_N9S19430C17D1Ev,_ZThn16080_N9S19430C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19430C17D0Ev,_ZTv0_n36_N9S19430C17D0Ev)();
extern void ABISELECT(_ZThn24288_N9S19430C17D0Ev,_ZThn16080_N9S19430C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S19430C17[] = {
  ABISELECT(24288,16080),
  ABISELECT(24208,16032),
  ABISELECT(24160,15988),
  ABISELECT(23904,15816),
  ABISELECT(23232,15364),
  ABISELECT(23696,15688),
  ABISELECT(23984,15872),
  ABISELECT(22080,14612),
  ABISELECT(22960,15176),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C17[0]),
  (VTBL_ENTRY)&_ZN9S19430C17D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C17D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  (VTBL_ENTRY)&_ZN8S19430C32v4Ev,
  ABISELECT(22688,14988),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI9S19430C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C17D1Ev,_ZThn188_N9S19430C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C17D0Ev,_ZThn188_N9S19430C17D0Ev),
  ABISELECT(21200,14040),
  ABISELECT(22816,15116),
  ABISELECT(23408,15508),
  ABISELECT(23328,15460),
  ABISELECT(23280,15416),
  ABISELECT(22080,14604),
  ABISELECT(-880,-572),
  (VTBL_ENTRY)&(_ZTI9S19430C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn880_N9S19430C17D1Ev,_ZThn572_N9S19430C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn880_N9S19430C17D0Ev,_ZThn572_N9S19430C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
  ABISELECT(22224,14736),
  ABISELECT(20144,13360),
  ABISELECT(21760,14436),
  ABISELECT(22352,14828),
  ABISELECT(21024,13924),
  ABISELECT(22272,14780),
  ABISELECT(-1936,-1252),
  (VTBL_ENTRY)&(_ZTI9S19430C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1936_N9S19430C17D1Ev,_ZThn1252_N9S19430C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1936_N9S19430C17D0Ev,_ZThn1252_N9S19430C17D0Ev),
  ABISELECT(-2064,-1352),
  (VTBL_ENTRY)&(_ZTI9S19430C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2064_N9S19430C17D1Ev,_ZThn1352_N9S19430C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2064_N9S19430C17D0Ev,_ZThn1352_N9S19430C17D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  0,
  ABISELECT(-22080,-14612),
  ABISELECT(880,564),
  ABISELECT(-22080,-14612),
  (VTBL_ENTRY)&(_ZTI9S19430C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C17D1Ev,_ZTv0_n16_N9S19430C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C17D0Ev,_ZTv0_n16_N9S19430C17D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
  0,
  ABISELECT(-22960,-15176),
  ABISELECT(-22960,-15176),
  (VTBL_ENTRY)&(_ZTI9S19430C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C17D1Ev,_ZTv0_n12_N9S19430C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C17D0Ev,_ZTv0_n12_N9S19430C17D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(-23232,-15364),
  0,
  ABISELECT(464,324),
  ABISELECT(-272,-188),
  ABISELECT(-23232,-15364),
  (VTBL_ENTRY)&(_ZTI9S19430C17[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19430C17D1Ev,_ZTv0_n24_N9S19430C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N9S19430C17D0Ev,_ZTv0_n24_N9S19430C17D0Ev),
  ABISELECT(-23696,-15688),
  ABISELECT(-736,-512),
  ABISELECT(-23696,-15688),
  (VTBL_ENTRY)&(_ZTI9S19430C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C17D1Ev,_ZTv0_n16_N9S19430C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C17D0Ev,_ZTv0_n16_N9S19430C17D0Ev),
  ABISELECT(-24288,-16080),
  0,
  ABISELECT(-128,-92),
  ABISELECT(-2208,-1468),
  ABISELECT(-80,-48),
  ABISELECT(-592,-392),
  ABISELECT(-1328,-904),
  ABISELECT(-24288,-16080),
  (VTBL_ENTRY)&(_ZTI9S19430C17[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C17D1Ev,_ZTv0_n36_N9S19430C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C17D0Ev,_ZTv0_n36_N9S19430C17D0Ev),
};
extern VTBL_ENTRY _ZTV9S19430C17[];
extern void _ZN8S19430C3D1Ev();
extern void _ZN8S19430C3D0Ev();
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C32v4Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C3__9S19430C17[] = {
  ABISELECT(23904,15816),
  ABISELECT(23232,15364),
  ABISELECT(23696,15688),
  ABISELECT(23984,15872),
  ABISELECT(22080,14612),
  ABISELECT(22960,15176),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&_ZN8S19430C3D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C3D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  (VTBL_ENTRY)&_ZN8S19430C32v4Ev,
};
extern void _ZN9S19430C13D1Ev();
extern void _ZN9S19430C13D0Ev();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C138S19430C3__9S19430C17[] = {
  ABISELECT(23696,15688),
  ABISELECT(23984,15872),
  ABISELECT(22080,14612),
  ABISELECT(22960,15176),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&_ZN9S19430C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C13D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C14D1Ev();
extern void _ZN9S19430C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C149S19430C138S19430C3__9S19430C17[] = {
  ABISELECT(22688,14988),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&_ZN9S19430C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C14D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev)();
extern void ABISELECT(_ZThn22688_N9S19430C14D1Ev,_ZThn14988_N9S19430C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev)();
extern void ABISELECT(_ZThn22688_N9S19430C14D0Ev,_ZThn14988_N9S19430C14D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C149S19430C138S19430C3__9S19430C17[] = {
  0,
  ABISELECT(-22688,-14988),
  ABISELECT(-22688,-14988),
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19430C14__9S19430C138S19430C3__9S19430C17[] = {
  ABISELECT(22688,14988),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn22960_N9S19430C13D1Ev,_ZThn15176_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn22960_N9S19430C13D0Ev,_ZThn15176_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__A1__9S19430C138S19430C3__9S19430C17[] = {
  0,
  ABISELECT(-22960,-15176),
  ABISELECT(-22960,-15176),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn22080_N9S19430C13D1Ev,_ZThn14612_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn22080_N9S19430C13D0Ev,_ZThn14612_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C138S19430C3__9S19430C17[] = {
  0,
  ABISELECT(-22080,-14612),
  ABISELECT(880,564),
  ABISELECT(-22080,-14612),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn23696_N9S19430C13D1Ev,_ZThn15688_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn23696_N9S19430C13D0Ev,_ZThn15688_N9S19430C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__A1__9S19430C138S19430C3__9S19430C17[] = {
  ABISELECT(-23696,-15688),
  ABISELECT(-736,-512),
  ABISELECT(-23696,-15688),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S19430C3D1Ev,_ZTv0_n12_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn22960_N8S19430C3D1Ev,_ZThn15176_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S19430C3D0Ev,_ZTv0_n12_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn22960_N8S19430C3D0Ev,_ZThn15176_N8S19430C3D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C3__9S19430C17[] = {
  0,
  ABISELECT(-22960,-15176),
  ABISELECT(-22960,-15176),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C3D1Ev,_ZTv0_n12_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C3D0Ev,_ZTv0_n12_N8S19430C3D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n48_N8S19430C3D1Ev,_ZTv0_n24_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn23232_N8S19430C3D1Ev,_ZThn15364_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n48_N8S19430C3D0Ev,_ZTv0_n24_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn23232_N8S19430C3D0Ev,_ZThn15364_N8S19430C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S19430C9__8S19430C3__9S19430C17[] = {
  ABISELECT(-23232,-15364),
  0,
  ABISELECT(464,324),
  ABISELECT(-272,-188),
  ABISELECT(-23232,-15364),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19430C3D1Ev,_ZTv0_n24_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n48_N8S19430C3D0Ev,_ZTv0_n24_N8S19430C3D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn23696_N8S19430C3D1Ev,_ZThn15688_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn23696_N8S19430C3D0Ev,_ZThn15688_N8S19430C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C3__9S19430C17[] = {
  ABISELECT(-23696,-15688),
  ABISELECT(-736,-512),
  ABISELECT(-23696,-15688),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev),
};
extern void ABISELECT(_ZThn272_N8S19430C3D1Ev,_ZThn188_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn272_N8S19430C3D0Ev,_ZThn188_N8S19430C3D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19430C149S19430C13__8S19430C3__9S19430C17[] = {
  ABISELECT(22688,14988),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N8S19430C3D1Ev,_ZThn188_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N8S19430C3D0Ev,_ZThn188_N8S19430C3D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev)();
extern void ABISELECT(_ZThn22080_N8S19430C3D1Ev,_ZThn14612_N8S19430C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev)();
extern void ABISELECT(_ZThn22080_N8S19430C3D0Ev,_ZThn14612_N8S19430C3D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__8S19430C3__9S19430C17[] = {
  0,
  ABISELECT(-22080,-14612),
  ABISELECT(880,564),
  ABISELECT(-22080,-14612),
  (VTBL_ENTRY)&(_ZTI8S19430C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C18D1Ev();
extern void _ZN9S19430C18D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C18__9S19430C17[] = {
  ABISELECT(21200,14040),
  ABISELECT(22816,15116),
  ABISELECT(23408,15508),
  ABISELECT(23328,15460),
  ABISELECT(23280,15416),
  ABISELECT(22080,14604),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&_ZN9S19430C18D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C18D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C159S19430C18__A1__9S19430C17[] = {
  ABISELECT(22080,14604),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C109S19430C159S19430C18__A2__9S19430C17[] = {
  ABISELECT(22080,14604),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZThn22080_N9S19430C10D1Ev,_ZThn14604_N9S19430C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void ABISELECT(_ZThn22080_N9S19430C10D0Ev,_ZThn14604_N9S19430C10D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C109S19430C159S19430C18__A2__9S19430C17[] = {
  0,
  ABISELECT(-22080,-14604),
  ABISELECT(-22080,-14604),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZThn22080_N9S19430C15D1Ev,_ZThn14604_N9S19430C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void ABISELECT(_ZThn22080_N9S19430C15D0Ev,_ZThn14604_N9S19430C15D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C159S19430C18__A1__9S19430C17[] = {
  0,
  ABISELECT(-22080,-14604),
  ABISELECT(-22080,-14604),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C19D1Ev();
extern void _ZN9S19430C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C199S19430C18__9S19430C17[] = {
  ABISELECT(22224,14736),
  ABISELECT(20144,13360),
  ABISELECT(21760,14436),
  ABISELECT(22352,14828),
  ABISELECT(21024,13924),
  ABISELECT(22272,14780),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&_ZN9S19430C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C19D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn21024_N9S19430C19D1Ev,_ZThn13924_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn21024_N9S19430C19D0Ev,_ZThn13924_N9S19430C19D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C199S19430C18__9S19430C17[] = {
  0,
  ABISELECT(-21024,-13924),
  ABISELECT(-21024,-13924),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn22352_N9S19430C19D1Ev,_ZThn14828_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn22352_N9S19430C19D0Ev,_ZThn14828_N9S19430C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C16__9S19430C199S19430C18__9S19430C17[] = {
  ABISELECT(-22352,-14828),
  0,
  ABISELECT(-128,-92),
  ABISELECT(-2208,-1468),
  ABISELECT(-80,-48),
  ABISELECT(-592,-392),
  ABISELECT(-1328,-904),
  ABISELECT(-22352,-14828),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn21760_N9S19430C19D1Ev,_ZThn14436_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn21760_N9S19430C19D0Ev,_ZThn14436_N9S19430C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C199S19430C18__9S19430C17[] = {
  ABISELECT(-21760,-14436),
  ABISELECT(-736,-512),
  ABISELECT(-21760,-14436),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn20144_N9S19430C19D1Ev,_ZThn13360_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn20144_N9S19430C19D0Ev,_ZThn13360_N9S19430C19D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C199S19430C18__9S19430C17[] = {
  0,
  ABISELECT(-20144,-13360),
  ABISELECT(880,564),
  ABISELECT(-20144,-13360),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C18D1Ev,_ZTv0_n12_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn22080_N9S19430C18D1Ev,_ZThn14604_N9S19430C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C18D0Ev,_ZTv0_n12_N9S19430C18D0Ev)();
extern void ABISELECT(_ZThn22080_N9S19430C18D0Ev,_ZThn14604_N9S19430C18D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C18__9S19430C17[] = {
  0,
  ABISELECT(-22080,-14604),
  ABISELECT(-22080,-14604),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C18D1Ev,_ZTv0_n12_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C18D0Ev,_ZTv0_n12_N9S19430C18D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZThn1056_N9S19430C18D1Ev,_ZThn680_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn1056_N9S19430C18D0Ev,_ZThn680_N9S19430C18D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19430C19__9S19430C18__9S19430C17[] = {
  ABISELECT(22224,14736),
  ABISELECT(20144,13360),
  ABISELECT(21760,14436),
  ABISELECT(22352,14828),
  ABISELECT(21024,13924),
  ABISELECT(22272,14780),
  ABISELECT(-1056,-680),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1056_N9S19430C18D1Ev,_ZThn680_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1056_N9S19430C18D0Ev,_ZThn680_N9S19430C18D0Ev),
};
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n72_N9S19430C18D1Ev,_ZTv0_n36_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn23408_N9S19430C18D1Ev,_ZThn15508_N9S19430C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19430C18D0Ev,_ZTv0_n36_N9S19430C18D0Ev)();
extern void ABISELECT(_ZThn23408_N9S19430C18D0Ev,_ZThn15508_N9S19430C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C16__9S19430C18__9S19430C17[] = {
  ABISELECT(-23408,-15508),
  0,
  ABISELECT(-128,-92),
  ABISELECT(-2208,-1468),
  ABISELECT(-80,-48),
  ABISELECT(-592,-392),
  ABISELECT(-1328,-904),
  ABISELECT(-23408,-15508),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C18D1Ev,_ZTv0_n36_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C18D0Ev,_ZTv0_n36_N9S19430C18D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C18D1Ev,_ZTv0_n16_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn22816_N9S19430C18D1Ev,_ZThn15116_N9S19430C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C18D0Ev,_ZTv0_n16_N9S19430C18D0Ev)();
extern void ABISELECT(_ZThn22816_N9S19430C18D0Ev,_ZThn15116_N9S19430C18D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__A1__9S19430C18__9S19430C17[] = {
  ABISELECT(-22816,-15116),
  ABISELECT(-736,-512),
  ABISELECT(-22816,-15116),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C18D1Ev,_ZTv0_n16_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C18D0Ev,_ZTv0_n16_N9S19430C18D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C18D1Ev,_ZTv0_n16_N9S19430C18D1Ev)();
extern void ABISELECT(_ZThn21200_N9S19430C18D1Ev,_ZThn14040_N9S19430C18D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C18D0Ev,_ZTv0_n16_N9S19430C18D0Ev)();
extern void ABISELECT(_ZThn21200_N9S19430C18D0Ev,_ZThn14040_N9S19430C18D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__A1__9S19430C18__9S19430C17[] = {
  0,
  ABISELECT(-21200,-14040),
  ABISELECT(880,564),
  ABISELECT(-21200,-14040),
  (VTBL_ENTRY)&(_ZTI9S19430C18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C18D1Ev,_ZTv0_n16_N9S19430C18D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C18D0Ev,_ZTv0_n16_N9S19430C18D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C17[] = {
  ABISELECT(880,564),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C109S19430C15__9S19430C17[] = {
  ABISELECT(880,564),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZThn880_N9S19430C10D1Ev,_ZThn564_N9S19430C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void ABISELECT(_ZThn880_N9S19430C10D0Ev,_ZThn564_N9S19430C10D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C109S19430C15__9S19430C17[] = {
  0,
  ABISELECT(-880,-564),
  ABISELECT(-880,-564),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZThn880_N9S19430C15D1Ev,_ZThn564_N9S19430C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void ABISELECT(_ZThn880_N9S19430C15D0Ev,_ZThn564_N9S19430C15D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C15__9S19430C17[] = {
  0,
  ABISELECT(-880,-564),
  ABISELECT(-880,-564),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN8S19430C9D1Ev();
extern void _ZN8S19430C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C9__9S19430C17[] = {
  ABISELECT(464,324),
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C9__9S19430C17[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn464_N8S19430C9D1Ev,_ZThn324_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn464_N8S19430C9D0Ev,_ZThn324_N8S19430C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C9__9S19430C17[] = {
  ABISELECT(-464,-324),
  ABISELECT(-736,-512),
  ABISELECT(-464,-324),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev),
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C10__A1__9S19430C17[] = {
  ABISELECT(-736,-512),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C10__A1__9S19430C17[] = {
  0,
  ABISELECT(736,512),
  ABISELECT(736,512),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN9S19430C16D1Ev();
extern void _ZN9S19430C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C16__9S19430C17[] = {
  ABISELECT(-128,-92),
  ABISELECT(-2208,-1468),
  ABISELECT(-80,-48),
  ABISELECT(-592,-392),
  ABISELECT(-1328,-904),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D0Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN8S19430C9D1Ev();
extern void _ZN8S19430C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C99S19430C16__A1__9S19430C17[] = {
  ABISELECT(-592,-392),
  ABISELECT(-1328,-904),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C99S19430C16__A1__9S19430C17[] = {
  0,
  ABISELECT(1328,904),
  ABISELECT(1328,904),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev)();
extern void ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C99S19430C16__A1__9S19430C17[] = {
  ABISELECT(592,392),
  ABISELECT(-736,-512),
  ABISELECT(592,392),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C16__9S19430C17[] = {
  0,
  ABISELECT(1328,904),
  ABISELECT(1328,904),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C16__9S19430C17[] = {
  ABISELECT(592,392),
  ABISELECT(-736,-512),
  ABISELECT(592,392),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C16__9S19430C17[] = {
  0,
  ABISELECT(2208,1468),
  ABISELECT(880,564),
  ABISELECT(2208,1468),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
static  VTT_ENTRY vtt_S19430C17[] = {
  {&(_ZTV9S19430C17[11]),  11,88},
  {&(_tg__ZTV8S19430C3__9S19430C17[8]),  8,12},
  {&(_tg__ZTV9S19430C138S19430C3__9S19430C17[6]),  6,9},
  {&(_tg__ZTV9S19430C149S19430C138S19430C3__9S19430C17[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C149S19430C138S19430C3__9S19430C17[4]),  4,7},
  {&(_tg__ZTV9S19430C14__9S19430C138S19430C3__9S19430C17[3]),  3,5},
  {&(_tg__ZTV8S19430C4__A1__9S19430C138S19430C3__9S19430C17[4]),  4,7},
  {&(_tg__ZTV9S19430C15__9S19430C138S19430C3__9S19430C17[5]),  5,8},
  {&(_tg__ZTV9S19430C10__A1__9S19430C138S19430C3__9S19430C17[4]),  4,6},
  {&(_tg__ZTV8S19430C4__8S19430C3__9S19430C17[4]),  4,7},
  {&(_tg__ZTV8S19430C9__8S19430C3__9S19430C17[6]),  6,9},
  {&(_tg__ZTV9S19430C10__8S19430C3__9S19430C17[4]),  4,6},
  {&(_tg__ZTV9S19430C149S19430C13__8S19430C3__9S19430C17[3]),  3,5},
  {&(_tg__ZTV9S19430C15__8S19430C3__9S19430C17[5]),  5,8},
  {&(_tg__ZTV9S19430C18__9S19430C17[8]),  8,11},
  {&(_tg__ZTV9S19430C159S19430C18__A1__9S19430C17[3]),  3,6},
  {&(_tg__ZTV9S19430C109S19430C159S19430C18__A2__9S19430C17[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C109S19430C159S19430C18__A2__9S19430C17[4]),  4,7},
  {&(_tg__ZTV8S19430C4__9S19430C159S19430C18__A1__9S19430C17[4]),  4,7},
  {&(_tg__ZTV9S19430C199S19430C18__9S19430C17[8]),  8,10},
  {&(_tg__ZTV8S19430C4__9S19430C199S19430C18__9S19430C17[4]),  4,7},
  {&(_tg__ZTV9S19430C16__9S19430C199S19430C18__9S19430C17[9]),  9,12},
  {&(_tg__ZTV9S19430C10__9S19430C199S19430C18__9S19430C17[4]),  4,6},
  {&(_tg__ZTV9S19430C15__9S19430C199S19430C18__9S19430C17[5]),  5,8},
  {&(_tg__ZTV8S19430C4__9S19430C18__9S19430C17[4]),  4,7},
  {&(_tg__ZTV9S19430C19__9S19430C18__9S19430C17[8]),  8,10},
  {&(_tg__ZTV9S19430C16__9S19430C18__9S19430C17[9]),  9,12},
  {&(_tg__ZTV9S19430C10__A1__9S19430C18__9S19430C17[4]),  4,6},
  {&(_tg__ZTV9S19430C15__A1__9S19430C18__9S19430C17[5]),  5,8},
  {&(_ZTV9S19430C17[51]),  51,88},
  {&(_ZTV9S19430C17[58]),  58,88},
  {&(_ZTV9S19430C17[67]),  67,88},
  {&(_ZTV9S19430C17[74]),  74,88},
  {&(_ZTV9S19430C17[18]),  18,88},
  {&(_ZTV9S19430C17[28]),  28,88},
  {&(_ZTV9S19430C17[39]),  39,88},
  {&(_ZTV9S19430C17[85]),  85,88},
  {&(_tg__ZTV9S19430C15__9S19430C17[3]),  3,6},
  {&(_tg__ZTV9S19430C109S19430C15__9S19430C17[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C109S19430C15__9S19430C17[4]),  4,7},
  {&(_tg__ZTV8S19430C4__9S19430C15__9S19430C17[4]),  4,7},
  {&(_tg__ZTV8S19430C9__9S19430C17[4]),  4,7},
  {&(_tg__ZTV8S19430C4__8S19430C9__9S19430C17[4]),  4,7},
  {&(_tg__ZTV9S19430C10__8S19430C9__9S19430C17[4]),  4,6},
  {&(_tg__ZTV9S19430C10__A1__9S19430C17[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C10__A1__9S19430C17[4]),  4,7},
  {&(_tg__ZTV9S19430C16__9S19430C17[7]),  7,10},
  {&(_tg__ZTV8S19430C99S19430C16__A1__9S19430C17[4]),  4,7},
  {&(_tg__ZTV8S19430C4__8S19430C99S19430C16__A1__9S19430C17[4]),  4,7},
  {&(_tg__ZTV9S19430C10__8S19430C99S19430C16__A1__9S19430C17[4]),  4,6},
  {&(_tg__ZTV8S19430C4__9S19430C16__9S19430C17[4]),  4,7},
  {&(_tg__ZTV9S19430C10__9S19430C16__9S19430C17[4]),  4,6},
  {&(_tg__ZTV9S19430C15__9S19430C16__9S19430C17[5]),  5,8},
};
extern VTBL_ENTRY _ZTI9S19430C17[];
extern  VTBL_ENTRY _ZTV9S19430C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C17[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S19430C9D0Ev,_ZThn324_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S19430C9D1Ev,_ZThn324_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C18D0Ev,_ZTv0_n16_N9S19430C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21200_N9S19430C18D0Ev,_ZThn14040_N9S19430C18D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22816_N9S19430C18D0Ev,_ZThn15116_N9S19430C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C18D1Ev,_ZTv0_n16_N9S19430C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21200_N9S19430C18D1Ev,_ZThn14040_N9S19430C18D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22816_N9S19430C18D1Ev,_ZThn15116_N9S19430C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C18D0Ev,_ZTv0_n36_N9S19430C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23408_N9S19430C18D0Ev,_ZThn15508_N9S19430C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C18D1Ev,_ZTv0_n36_N9S19430C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23408_N9S19430C18D1Ev,_ZThn15508_N9S19430C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C18D0Ev,_ZTv0_n12_N9S19430C18D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N9S19430C18D0Ev,_ZThn14604_N9S19430C18D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C18D1Ev,_ZTv0_n12_N9S19430C18D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N9S19430C18D1Ev,_ZThn14604_N9S19430C18D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20144_N9S19430C19D0Ev,_ZThn13360_N9S19430C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn21760_N9S19430C19D0Ev,_ZThn14436_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn20144_N9S19430C19D1Ev,_ZThn13360_N9S19430C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn21760_N9S19430C19D1Ev,_ZThn14436_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22352_N9S19430C19D0Ev,_ZThn14828_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22352_N9S19430C19D1Ev,_ZThn14828_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21024_N9S19430C19D0Ev,_ZThn13924_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn21024_N9S19430C19D1Ev,_ZThn13924_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19430C15D0Ev,_ZThn564_N9S19430C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N9S19430C15D0Ev,_ZThn14604_N9S19430C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19430C15D1Ev,_ZThn564_N9S19430C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N9S19430C15D1Ev,_ZThn14604_N9S19430C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19430C10D0Ev,_ZThn564_N9S19430C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N9S19430C10D0Ev,_ZThn14604_N9S19430C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn880_N9S19430C10D1Ev,_ZThn564_N9S19430C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N9S19430C10D1Ev,_ZThn14604_N9S19430C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C3D0Ev,_ZTv0_n16_N8S19430C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N8S19430C3D0Ev,_ZThn14612_N8S19430C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn23696_N8S19430C3D0Ev,_ZThn15688_N8S19430C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C3D1Ev,_ZTv0_n16_N8S19430C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N8S19430C3D1Ev,_ZThn14612_N8S19430C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn23696_N8S19430C3D1Ev,_ZThn15688_N8S19430C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19430C3D0Ev,_ZTv0_n24_N8S19430C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23232_N8S19430C3D0Ev,_ZThn15364_N8S19430C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N8S19430C3D1Ev,_ZTv0_n24_N8S19430C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23232_N8S19430C3D1Ev,_ZThn15364_N8S19430C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C3D0Ev,_ZTv0_n12_N8S19430C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22960_N8S19430C3D0Ev,_ZThn15176_N8S19430C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S19430C3D1Ev,_ZTv0_n12_N8S19430C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22960_N8S19430C3D1Ev,_ZThn15176_N8S19430C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23696_N9S19430C13D0Ev,_ZThn15688_N9S19430C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N9S19430C13D0Ev,_ZThn14612_N9S19430C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23696_N9S19430C13D1Ev,_ZThn15688_N9S19430C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N9S19430C13D1Ev,_ZThn14612_N9S19430C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22960_N9S19430C13D0Ev,_ZThn15176_N9S19430C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22960_N9S19430C13D1Ev,_ZThn15176_N9S19430C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22688_N9S19430C14D0Ev,_ZThn14988_N9S19430C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22688_N9S19430C14D1Ev,_ZThn14988_N9S19430C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C17D0Ev,_ZTv0_n36_N9S19430C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24288_N9S19430C17D0Ev,_ZThn16080_N9S19430C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C17D1Ev,_ZTv0_n36_N9S19430C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24288_N9S19430C17D1Ev,_ZThn16080_N9S19430C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19430C17D0Ev,_ZTv0_n24_N9S19430C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23232_N9S19430C17D0Ev,_ZThn15364_N9S19430C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n48_N9S19430C17D1Ev,_ZTv0_n24_N9S19430C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23232_N9S19430C17D1Ev,_ZThn15364_N9S19430C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C17D0Ev,_ZTv0_n12_N9S19430C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22960_N9S19430C17D0Ev,_ZThn15176_N9S19430C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C17D1Ev,_ZTv0_n12_N9S19430C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22960_N9S19430C17D1Ev,_ZThn15176_N9S19430C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C17D0Ev,_ZTv0_n16_N9S19430C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23696_N9S19430C17D0Ev,_ZThn15688_N9S19430C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N9S19430C17D0Ev,_ZThn14612_N9S19430C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C17D1Ev,_ZTv0_n16_N9S19430C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn23696_N9S19430C17D1Ev,_ZThn15688_N9S19430C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn22080_N9S19430C17D1Ev,_ZThn14612_N9S19430C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C17 = {  "S19430C17", // class name
  bases_S19430C17, 53,
  &(vtc_S19430C17[0]), // expected_vtbl_contents
  &(vtt_S19430C17[0]), // expected_vtt_contents
  ABISELECT(24768,16412), // object size
  NSPAIRA(_ZTI9S19430C17),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19430C17),88, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19430C17),53, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C20  : S19430C19 , S19430C13 , S19430C14 {
  void *s19430c20f0[9];
  void *s19430c20f1;
  ~S19430C20(); // tgen
  S19430C20(); // tgen
};
//SIG(-1 S19430C20) C1{ BC2{ VBC3{ m FD Fi[2] Fp[7]} VBC4{ BC5{ m FL[4] Fc[8] Fp} BC6{ BC3 BC5 FU7{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD} VBC8{ VBC3 VBC4 BC9{ VBC4 VBC10{ VBC4 BC6 Fp FU7} BC11{ m Fi Fi Fi Fi Fi[4] Fl Fc FD Fi} BC5 v2 FC12{} FC4 Fi Fc[8] Fi FD} VBC13{ BC10 vd v3 FC6 Fi FC10} VBC5 vd Fi Fi:0 Fp} BC5 vd FL Fi[6] Fp Fi Fi:12 Fp Fi} BC14{ BC4 BC15{ BC11 BC3 VBC4 vd Fi FC4 Fl Fi} VBC13 VBC6 VBC10 Fp Fi Fi Fp Fp Fi} BC15 Fp[9] Fp}


S19430C20 ::~S19430C20(){ note_dtor("S19430C20", this);} // tgen
S19430C20 ::S19430C20(){ note_ctor("S19430C20", this);} // tgen

static void Test_S19430C20()
{
  extern Class_Descriptor cd_S19430C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(228,598)];
    init_test(&cd_S19430C20, buf);
    S19430C20 *dp, &lv = *(dp=new (buf) S19430C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3632,2388), "sizeof(S19430C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C20)");
    /*is_ambiguous_... S19430C19::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C19*), ABISELECT(1488,968), "S19430C20");
    /*is_ambiguous_... S19430C16::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C16*), ABISELECT(1488,968), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(1576,1020), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(1632,1064), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(1712,1112), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(1632,1064), "S19430C20");
    check_base_class_offset(lv, (S19430C4*)(S19430C19*), ABISELECT(1568,1016), "S19430C20");
    check_base_class_offset(lv, (S19430C4*)(S19430C16*), ABISELECT(1568,1016), "S19430C20");
    check_base_class_offset(lv, (S19430C4*)(S19430C9*)(S19430C16*), ABISELECT(1568,1016), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(1568,1016), "S19430C20");
    check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*), ABISELECT(1568,1016), "S19430C20");
    check_base_class_offset(lv, (S19430C4*)(S19430C14*)(S19430C13*), ABISELECT(1568,1016), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C14 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C14*), ABISELECT(1568,1016), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(2336,1540), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(2416,1588), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(2336,1540), "S19430C20");
    check_base_class_offset(lv, (S19430C10*)(S19430C9*)(S19430C16*), ABISELECT(2320,1536), "S19430C20");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C13*), ABISELECT(2320,1536), "S19430C20");
    check_base_class_offset(lv, (S19430C11*)(S19430C9*)(S19430C16*), ABISELECT(1856,1208), "S19430C20");
    /*is_ambiguous_... S19430C9::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*)(S19430C16*), ABISELECT(1936,1264), "S19430C20");
    check_base_class_offset(lv, (S19430C9*)(S19430C16*), ABISELECT(1840,1204), "S19430C20");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(2544,1668), "S19430C20");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(2624,1716), "S19430C20");
    /*is_ambiguous_... S19430C10::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(2544,1668), "S19430C20");
    check_base_class_offset(lv, (S19430C10*)(S19430C15*), ABISELECT(2528,1664), "S19430C20");
    check_base_class_offset(lv, (S19430C15*)(S19430C16*), ABISELECT(2528,1664), "S19430C20");
    check_base_class_offset(lv, (S19430C15*)(S19430C13*), ABISELECT(2528,1664), "S19430C20");
    /*is_ambiguous_... S19430C16::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C16*), ABISELECT(3408,2228), "S19430C20");
    check_base_class_offset(lv, (S19430C16*)(S19430C19*), ABISELECT(1840,1204), "S19430C20");
    /*is_ambiguous_... S19430C19::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C19*), ABISELECT(8,4), "S19430C20");
    check_base_class_offset(lv, (S19430C19*), 0, "S19430C20");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C13*), ABISELECT(136,104), "S19430C20");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C13*), ABISELECT(192,148), "S19430C20");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C13*), ABISELECT(272,196), "S19430C20");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C13*), ABISELECT(192,148), "S19430C20");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C13*), ABISELECT(128,100), "S19430C20");
    check_base_class_offset(lv, (S19430C11*)(S19430C14*)(S19430C13*), ABISELECT(416,292), "S19430C20");
    /*is_ambiguous_... S19430C14::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*)(S19430C13*), ABISELECT(496,348), "S19430C20");
    check_base_class_offset(lv, (S19430C14*)(S19430C13*), ABISELECT(400,288), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*), ABISELECT(3456,2272), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*), ABISELECT(3536,2320), "S19430C20");
    /*is_ambiguous_... S19430C13::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C13*), ABISELECT(3456,2272), "S19430C20");
    check_base_class_offset(lv, (S19430C13*), ABISELECT(128,100), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C14 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C14*), ABISELECT(944,624), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C14 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*), ABISELECT(1024,680), "S19430C20");
    /*is_ambiguous_... S19430C20::S19430C14 */ AMB_check_base_class_offset(lv, (S19430C14*), ABISELECT(928,620), "S19430C20");
    check_field_offset(lv, s19430c20f0, ABISELECT(1408,928), "S19430C20.s19430c20f0");
    check_field_offset(lv, s19430c20f1, ABISELECT(1480,964), "S19430C20.s19430c20f1");
    test_class_info(&lv, &cd_S19430C20);
    dp->~S19430C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C20(Test_S19430C20, "S19430C20", ABISELECT(3632,2388));

#else // __cplusplus

extern void _ZN9S19430C20C1Ev();
extern void _ZN9S19430C20D1Ev();
Name_Map name_map_S19430C20[] = {
  NSPAIR(_ZN9S19430C20C1Ev),
  NSPAIR(_ZN9S19430C20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C16;
extern VTBL_ENTRY _ZTI9S19430C16[];
extern  VTBL_ENTRY _ZTV9S19430C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C16[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C19;
extern VTBL_ENTRY _ZTI9S19430C19[];
extern  VTBL_ENTRY _ZTV9S19430C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C19[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C13;
extern VTBL_ENTRY _ZTI9S19430C13[];
extern  VTBL_ENTRY _ZTV9S19430C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C13[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
static Base_Class bases_S19430C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C7,    ABISELECT(1488,968), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S19430C5,    ABISELECT(1576,1020), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(1632,1064), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1712,1112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(1632,1064), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(1568,1016), //bcp->offset
    30, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(2336,1540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2416,1588), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(2336,1540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(2320,1536), //bcp->offset
    49, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(1856,1208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1936,1264), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S19430C9,    ABISELECT(1840,1204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(2544,1668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2624,1716), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(2544,1668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(2528,1664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C15,    ABISELECT(2528,1664), //bcp->offset
    55, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S19430C5,    ABISELECT(3408,2228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S19430C16,    ABISELECT(1840,1204), //bcp->offset
    37, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S19430C5,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S19430C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C5,    ABISELECT(136,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(192,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(272,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(192,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(128,100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19430C11,    ABISELECT(416,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(496,348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C14,    ABISELECT(400,288), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(3456,2272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(3536,2320), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(3456,2272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 1},
  {&cd_S19430C13,    ABISELECT(128,100), //bcp->offset
    11, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S19430C11,    ABISELECT(944,624), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(1024,680), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S19430C14,    ABISELECT(928,620), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S19430C20[];
extern void _ZN9S19430C20D1Ev();
extern void _ZN9S19430C20D0Ev();
extern void ABISELECT(_ZThn128_N9S19430C20D1Ev,_ZThn100_N9S19430C20D1Ev)();
extern void ABISELECT(_ZThn128_N9S19430C20D0Ev,_ZThn100_N9S19430C20D0Ev)();
extern void _ZN8S19430C42v1Ev();
extern void ABISELECT(_ZThn400_N9S19430C20D1Ev,_ZThn288_N9S19430C20D1Ev)();
extern void ABISELECT(_ZThn400_N9S19430C20D0Ev,_ZThn288_N9S19430C20D0Ev)();
extern void ABISELECT(_ZThn928_N9S19430C20D1Ev,_ZThn620_N9S19430C20D1Ev)();
extern void ABISELECT(_ZThn928_N9S19430C20D0Ev,_ZThn620_N9S19430C20D0Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C20D1Ev,_ZTv0_n12_N9S19430C20D1Ev)();
extern void ABISELECT(_ZThn1568_N9S19430C20D1Ev,_ZThn1016_N9S19430C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C20D0Ev,_ZTv0_n12_N9S19430C20D0Ev)();
extern void ABISELECT(_ZThn1568_N9S19430C20D0Ev,_ZThn1016_N9S19430C20D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n72_N9S19430C20D1Ev,_ZTv0_n36_N9S19430C20D1Ev)();
extern void ABISELECT(_ZThn1840_N9S19430C20D1Ev,_ZThn1204_N9S19430C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19430C20D0Ev,_ZTv0_n36_N9S19430C20D0Ev)();
extern void ABISELECT(_ZThn1840_N9S19430C20D0Ev,_ZThn1204_N9S19430C20D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C20D1Ev,_ZTv0_n16_N9S19430C20D1Ev)();
extern void ABISELECT(_ZThn2320_N9S19430C20D1Ev,_ZThn1536_N9S19430C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C20D0Ev,_ZTv0_n16_N9S19430C20D0Ev)();
extern void ABISELECT(_ZThn2320_N9S19430C20D0Ev,_ZThn1536_N9S19430C20D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C20D1Ev,_ZTv0_n16_N9S19430C20D1Ev)();
extern void ABISELECT(_ZThn2528_N9S19430C20D1Ev,_ZThn1664_N9S19430C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C20D0Ev,_ZTv0_n16_N9S19430C20D0Ev)();
extern void ABISELECT(_ZThn2528_N9S19430C20D0Ev,_ZThn1664_N9S19430C20D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY vtc_S19430C20[] = {
  ABISELECT(3456,2272),
  ABISELECT(3408,2228),
  ABISELECT(2528,1664),
  ABISELECT(2320,1536),
  ABISELECT(1840,1204),
  ABISELECT(1568,1016),
  ABISELECT(1488,968),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C20[0]),
  (VTBL_ENTRY)&_ZN9S19430C20D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C20D0Ev,
  ABISELECT(2192,1436),
  ABISELECT(3328,2172),
  ABISELECT(2400,1564),
  ABISELECT(1440,916),
  ABISELECT(-128,-100),
  (VTBL_ENTRY)&(_ZTI9S19430C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N9S19430C20D1Ev,_ZThn100_N9S19430C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N9S19430C20D0Ev,_ZThn100_N9S19430C20D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(1168,728),
  ABISELECT(-400,-288),
  (VTBL_ENTRY)&(_ZTI9S19430C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn400_N9S19430C20D1Ev,_ZThn288_N9S19430C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn400_N9S19430C20D0Ev,_ZThn288_N9S19430C20D0Ev),
  ABISELECT(640,396),
  ABISELECT(-928,-620),
  (VTBL_ENTRY)&(_ZTI9S19430C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn928_N9S19430C20D1Ev,_ZThn620_N9S19430C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn928_N9S19430C20D0Ev,_ZThn620_N9S19430C20D0Ev),
  0,
  ABISELECT(-1568,-1016),
  ABISELECT(-1568,-1016),
  (VTBL_ENTRY)&(_ZTI9S19430C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C20D1Ev,_ZTv0_n12_N9S19430C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C20D0Ev,_ZTv0_n12_N9S19430C20D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
  ABISELECT(-1840,-1204),
  0,
  ABISELECT(1568,1024),
  ABISELECT(688,460),
  ABISELECT(-352,-236),
  ABISELECT(480,332),
  ABISELECT(-272,-188),
  ABISELECT(-1840,-1204),
  (VTBL_ENTRY)&(_ZTI9S19430C20[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C20D1Ev,_ZTv0_n36_N9S19430C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C20D0Ev,_ZTv0_n36_N9S19430C20D0Ev),
  ABISELECT(-2320,-1536),
  ABISELECT(-752,-520),
  ABISELECT(-2320,-1536),
  (VTBL_ENTRY)&(_ZTI9S19430C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C20D1Ev,_ZTv0_n16_N9S19430C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C20D0Ev,_ZTv0_n16_N9S19430C20D0Ev),
  0,
  ABISELECT(-2528,-1664),
  ABISELECT(-960,-648),
  ABISELECT(-2528,-1664),
  (VTBL_ENTRY)&(_ZTI9S19430C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C20D1Ev,_ZTv0_n16_N9S19430C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C20D0Ev,_ZTv0_n16_N9S19430C20D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern VTBL_ENTRY _ZTV9S19430C20[];
extern void _ZN9S19430C19D1Ev();
extern void _ZN9S19430C19D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C19__9S19430C20[] = {
  ABISELECT(3408,2228),
  ABISELECT(2528,1664),
  ABISELECT(2320,1536),
  ABISELECT(1840,1204),
  ABISELECT(1568,1016),
  ABISELECT(1488,968),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&_ZN9S19430C19D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C19D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn1568_N9S19430C19D1Ev,_ZThn1016_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn1568_N9S19430C19D0Ev,_ZThn1016_N9S19430C19D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C19__9S19430C20[] = {
  0,
  ABISELECT(-1568,-1016),
  ABISELECT(-1568,-1016),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn1840_N9S19430C19D1Ev,_ZThn1204_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn1840_N9S19430C19D0Ev,_ZThn1204_N9S19430C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C16__9S19430C19__9S19430C20[] = {
  ABISELECT(-1840,-1204),
  0,
  ABISELECT(1568,1024),
  ABISELECT(688,460),
  ABISELECT(-352,-236),
  ABISELECT(480,332),
  ABISELECT(-272,-188),
  ABISELECT(-1840,-1204),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn2320_N9S19430C19D1Ev,_ZThn1536_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn2320_N9S19430C19D0Ev,_ZThn1536_N9S19430C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C19__9S19430C20[] = {
  ABISELECT(-2320,-1536),
  ABISELECT(-752,-520),
  ABISELECT(-2320,-1536),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev)();
extern void ABISELECT(_ZThn2528_N9S19430C19D1Ev,_ZThn1664_N9S19430C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev)();
extern void ABISELECT(_ZThn2528_N9S19430C19D0Ev,_ZThn1664_N9S19430C19D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C19__9S19430C20[] = {
  0,
  ABISELECT(-2528,-1664),
  ABISELECT(-960,-648),
  ABISELECT(-2528,-1664),
  (VTBL_ENTRY)&(_ZTI9S19430C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C13D1Ev();
extern void _ZN9S19430C13D0Ev();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C13__9S19430C20[] = {
  ABISELECT(2192,1436),
  ABISELECT(3328,2172),
  ABISELECT(2400,1564),
  ABISELECT(1440,916),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&_ZN9S19430C13D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C13D0Ev,
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C14D1Ev();
extern void _ZN9S19430C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C149S19430C13__9S19430C20[] = {
  ABISELECT(1168,728),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&_ZN9S19430C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C14D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev)();
extern void ABISELECT(_ZThn1168_N9S19430C14D1Ev,_ZThn728_N9S19430C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev)();
extern void ABISELECT(_ZThn1168_N9S19430C14D0Ev,_ZThn728_N9S19430C14D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C149S19430C13__9S19430C20[] = {
  0,
  ABISELECT(-1168,-728),
  ABISELECT(-1168,-728),
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S19430C14__9S19430C13__9S19430C20[] = {
  ABISELECT(1168,728),
  ABISELECT(-272,-188),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D1Ev,_ZThn188_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn272_N9S19430C13D0Ev,_ZThn188_N9S19430C13D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn1440_N9S19430C13D1Ev,_ZThn916_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn1440_N9S19430C13D0Ev,_ZThn916_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__A1__9S19430C13__9S19430C20[] = {
  0,
  ABISELECT(-1440,-916),
  ABISELECT(-1440,-916),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn2400_N9S19430C13D1Ev,_ZThn1564_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn2400_N9S19430C13D0Ev,_ZThn1564_N9S19430C13D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C13__9S19430C20[] = {
  0,
  ABISELECT(-2400,-1564),
  ABISELECT(-960,-648),
  ABISELECT(-2400,-1564),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev)();
extern void ABISELECT(_ZThn2192_N9S19430C13D1Ev,_ZThn1436_N9S19430C13D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev)();
extern void ABISELECT(_ZThn2192_N9S19430C13D0Ev,_ZThn1436_N9S19430C13D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__A1__9S19430C13__9S19430C20[] = {
  ABISELECT(-2192,-1436),
  ABISELECT(-752,-520),
  ABISELECT(-2192,-1436),
  (VTBL_ENTRY)&(_ZTI9S19430C13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev),
};
extern void _ZN9S19430C14D1Ev();
extern void _ZN9S19430C14D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C14__A1__9S19430C20[] = {
  ABISELECT(640,396),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&_ZN9S19430C14D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C14D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev)();
extern void ABISELECT(_ZThn640_N9S19430C14D1Ev,_ZThn396_N9S19430C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev)();
extern void ABISELECT(_ZThn640_N9S19430C14D0Ev,_ZThn396_N9S19430C14D0Ev)() __attribute__((weak));
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C14__A1__9S19430C20[] = {
  0,
  ABISELECT(-640,-396),
  ABISELECT(-640,-396),
  (VTBL_ENTRY)&(_ZTI9S19430C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN9S19430C16D1Ev();
extern void _ZN9S19430C16D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C16__9S19430C20[] = {
  ABISELECT(1568,1024),
  ABISELECT(688,460),
  ABISELECT(-352,-236),
  ABISELECT(480,332),
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C16D0Ev,
};
extern void _ZN8S19430C92v2Ev();
extern void _ZN8S19430C9D1Ev();
extern void _ZN8S19430C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C99S19430C16__9S19430C20[] = {
  ABISELECT(480,332),
  ABISELECT(-272,-188),
  0,
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&_ZN8S19430C92v2Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D1Ev,
  (VTBL_ENTRY)&_ZN8S19430C9D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__8S19430C99S19430C16__9S19430C20[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D1Ev,_ZTv0_n12_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S19430C9D0Ev,_ZTv0_n12_N8S19430C9D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev)();
extern void ABISELECT(_ZThn480_N8S19430C9D1Ev,_ZThn332_N8S19430C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev)();
extern void ABISELECT(_ZThn480_N8S19430C9D0Ev,_ZThn332_N8S19430C9D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__8S19430C99S19430C16__9S19430C20[] = {
  ABISELECT(-480,-332),
  ABISELECT(-752,-520),
  ABISELECT(-480,-332),
  (VTBL_ENTRY)&(_ZTI8S19430C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C16__9S19430C20[] = {
  0,
  ABISELECT(272,188),
  ABISELECT(272,188),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D1Ev,_ZTv0_n12_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C16D0Ev,_ZTv0_n12_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn480_N9S19430C16D1Ev,_ZThn332_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn480_N9S19430C16D0Ev,_ZThn332_N9S19430C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C16__9S19430C20[] = {
  ABISELECT(-480,-332),
  ABISELECT(-752,-520),
  ABISELECT(-480,-332),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
};
extern void ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev)();
extern void ABISELECT(_ZThn688_N9S19430C16D1Ev,_ZThn460_N9S19430C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev)();
extern void ABISELECT(_ZThn688_N9S19430C16D0Ev,_ZThn460_N9S19430C16D0Ev)() __attribute__((weak));
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C16__9S19430C20[] = {
  0,
  ABISELECT(-688,-460),
  ABISELECT(-960,-648),
  ABISELECT(-688,-460),
  (VTBL_ENTRY)&(_ZTI9S19430C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev),
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C10__9S19430C20[] = {
  ABISELECT(-752,-520),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C10__9S19430C20[] = {
  0,
  ABISELECT(752,520),
  ABISELECT(752,520),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void _ZN9S19430C15D1Ev();
extern void _ZN9S19430C15D0Ev();
extern void _ZN9S19430C152v3Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C15__9S19430C20[] = {
  ABISELECT(-960,-648),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&_ZN9S19430C15D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C15D0Ev,
  (VTBL_ENTRY)&_ZN9S19430C152v3Ev,
};
extern void _ZN9S19430C10D1Ev();
extern void _ZN9S19430C10D0Ev();
static  VTBL_ENTRY _tg__ZTV9S19430C109S19430C15__A1__9S19430C20[] = {
  ABISELECT(-960,-648),
  0,
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&_ZN9S19430C10D1Ev,
  (VTBL_ENTRY)&_ZN9S19430C10D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C109S19430C15__A1__9S19430C20[] = {
  0,
  ABISELECT(960,648),
  ABISELECT(960,648),
  (VTBL_ENTRY)&(_ZTI9S19430C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D1Ev,_ZTv0_n12_N9S19430C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C10D0Ev,_ZTv0_n12_N9S19430C10D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
extern void ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev)();
extern void ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev)();
extern void _ZN8S19430C42v1Ev();
static  VTBL_ENTRY _tg__ZTV8S19430C4__9S19430C15__9S19430C20[] = {
  0,
  ABISELECT(960,648),
  ABISELECT(960,648),
  (VTBL_ENTRY)&(_ZTI9S19430C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D1Ev,_ZTv0_n12_N9S19430C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N9S19430C15D0Ev,_ZTv0_n12_N9S19430C15D0Ev),
  (VTBL_ENTRY)&_ZN8S19430C42v1Ev,
};
static  VTT_ENTRY vtt_S19430C20[] = {
  {&(_ZTV9S19430C20[9]),  9,63},
  {&(_tg__ZTV9S19430C19__9S19430C20[8]),  8,10},
  {&(_tg__ZTV8S19430C4__9S19430C19__9S19430C20[4]),  4,7},
  {&(_tg__ZTV9S19430C16__9S19430C19__9S19430C20[9]),  9,12},
  {&(_tg__ZTV9S19430C10__9S19430C19__9S19430C20[4]),  4,6},
  {&(_tg__ZTV9S19430C15__9S19430C19__9S19430C20[5]),  5,8},
  {&(_tg__ZTV9S19430C13__9S19430C20[6]),  6,9},
  {&(_tg__ZTV9S19430C149S19430C13__9S19430C20[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C149S19430C13__9S19430C20[4]),  4,7},
  {&(_tg__ZTV9S19430C14__9S19430C13__9S19430C20[3]),  3,5},
  {&(_tg__ZTV8S19430C4__A1__9S19430C13__9S19430C20[4]),  4,7},
  {&(_tg__ZTV9S19430C15__9S19430C13__9S19430C20[5]),  5,8},
  {&(_tg__ZTV9S19430C10__A1__9S19430C13__9S19430C20[4]),  4,6},
  {&(_tg__ZTV9S19430C14__A1__9S19430C20[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C14__A1__9S19430C20[4]),  4,7},
  {&(_ZTV9S19430C20[34]),  34,63},
  {&(_ZTV9S19430C20[46]),  46,63},
  {&(_ZTV9S19430C20[53]),  53,63},
  {&(_ZTV9S19430C20[60]),  60,63},
  {&(_ZTV9S19430C20[17]),  17,63},
  {&(_ZTV9S19430C20[23]),  23,63},
  {&(_ZTV9S19430C20[28]),  28,63},
  {&(_tg__ZTV9S19430C16__9S19430C20[7]),  7,10},
  {&(_tg__ZTV8S19430C99S19430C16__9S19430C20[4]),  4,7},
  {&(_tg__ZTV8S19430C4__8S19430C99S19430C16__9S19430C20[4]),  4,7},
  {&(_tg__ZTV9S19430C10__8S19430C99S19430C16__9S19430C20[4]),  4,6},
  {&(_tg__ZTV8S19430C4__9S19430C16__9S19430C20[4]),  4,7},
  {&(_tg__ZTV9S19430C10__9S19430C16__9S19430C20[4]),  4,6},
  {&(_tg__ZTV9S19430C15__9S19430C16__9S19430C20[5]),  5,8},
  {&(_tg__ZTV9S19430C10__9S19430C20[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C10__9S19430C20[4]),  4,7},
  {&(_tg__ZTV9S19430C15__9S19430C20[3]),  3,6},
  {&(_tg__ZTV9S19430C109S19430C15__A1__9S19430C20[3]),  3,5},
  {&(_tg__ZTV8S19430C4__9S19430C109S19430C15__A1__9S19430C20[4]),  4,7},
  {&(_tg__ZTV8S19430C4__9S19430C15__9S19430C20[4]),  4,7},
};
extern VTBL_ENTRY _ZTI9S19430C20[];
extern  VTBL_ENTRY _ZTV9S19430C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C20[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C16D0Ev,_ZTv0_n16_N9S19430C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn688_N9S19430C16D0Ev,_ZThn460_N9S19430C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn480_N9S19430C16D0Ev,_ZThn332_N9S19430C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C16D1Ev,_ZTv0_n16_N9S19430C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn688_N9S19430C16D1Ev,_ZThn460_N9S19430C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn480_N9S19430C16D1Ev,_ZThn332_N9S19430C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D0Ev,_ZTv0_n16_N8S19430C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S19430C9D0Ev,_ZThn332_N8S19430C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S19430C9D1Ev,_ZTv0_n16_N8S19430C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn480_N8S19430C9D1Ev,_ZThn332_N8S19430C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C13D0Ev,_ZTv0_n16_N9S19430C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2192_N9S19430C13D0Ev,_ZThn1436_N9S19430C13D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2400_N9S19430C13D0Ev,_ZThn1564_N9S19430C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C13D1Ev,_ZTv0_n16_N9S19430C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2192_N9S19430C13D1Ev,_ZThn1436_N9S19430C13D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2400_N9S19430C13D1Ev,_ZThn1564_N9S19430C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C13D0Ev,_ZTv0_n12_N9S19430C13D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1440_N9S19430C13D0Ev,_ZThn916_N9S19430C13D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C13D1Ev,_ZTv0_n12_N9S19430C13D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1440_N9S19430C13D1Ev,_ZThn916_N9S19430C13D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D0Ev,_ZTv0_n12_N9S19430C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn640_N9S19430C14D0Ev,_ZThn396_N9S19430C14D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1168_N9S19430C14D0Ev,_ZThn728_N9S19430C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C14D1Ev,_ZTv0_n12_N9S19430C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn640_N9S19430C14D1Ev,_ZThn396_N9S19430C14D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn1168_N9S19430C14D1Ev,_ZThn728_N9S19430C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C19D0Ev,_ZTv0_n16_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2528_N9S19430C19D0Ev,_ZThn1664_N9S19430C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2320_N9S19430C19D0Ev,_ZThn1536_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C19D1Ev,_ZTv0_n16_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2528_N9S19430C19D1Ev,_ZThn1664_N9S19430C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2320_N9S19430C19D1Ev,_ZThn1536_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C19D0Ev,_ZTv0_n36_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1840_N9S19430C19D0Ev,_ZThn1204_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C19D1Ev,_ZTv0_n36_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1840_N9S19430C19D1Ev,_ZThn1204_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C19D0Ev,_ZTv0_n12_N9S19430C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N9S19430C19D0Ev,_ZThn1016_N9S19430C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C19D1Ev,_ZTv0_n12_N9S19430C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N9S19430C19D1Ev,_ZThn1016_N9S19430C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C20D0Ev,_ZTv0_n16_N9S19430C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2528_N9S19430C20D0Ev,_ZThn1664_N9S19430C20D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2320_N9S19430C20D0Ev,_ZThn1536_N9S19430C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S19430C20D1Ev,_ZTv0_n16_N9S19430C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2528_N9S19430C20D1Ev,_ZThn1664_N9S19430C20D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn2320_N9S19430C20D1Ev,_ZThn1536_N9S19430C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C20D0Ev,_ZTv0_n36_N9S19430C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1840_N9S19430C20D0Ev,_ZThn1204_N9S19430C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n72_N9S19430C20D1Ev,_ZTv0_n36_N9S19430C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1840_N9S19430C20D1Ev,_ZThn1204_N9S19430C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C20D0Ev,_ZTv0_n12_N9S19430C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N9S19430C20D0Ev,_ZThn1016_N9S19430C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N9S19430C20D1Ev,_ZTv0_n12_N9S19430C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1568_N9S19430C20D1Ev,_ZThn1016_N9S19430C20D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S19430C20 = {  "S19430C20", // class name
  bases_S19430C20, 37,
  &(vtc_S19430C20[0]), // expected_vtbl_contents
  &(vtt_S19430C20[0]), // expected_vtt_contents
  ABISELECT(3632,2388), // object size
  NSPAIRA(_ZTI9S19430C20),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S19430C20),63, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S19430C20),35, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S19430C1  : virtual S19430C2 , virtual S19430C17 , S19430C11 , S19430C20 , S19430C5 {
  int s19430c1f0;
  void *s19430c1f1[4];
  ~S19430C1(); // tgen
  S19430C1(); // tgen
};
//SIG(1 S19430C1) C1{ VBC2{ BC3{ VBC4{ BC5{ m FL[4] Fc[8] Fp} BC6{ BC7{ m FD Fi[2] Fp[7]} BC5 FU8{ m Fp Fi}[4] Fi Fp} vd v1 Fp Fs:16 Fi FD} VBC9{ VBC4 VBC10{ VBC4 BC6 Fp FU8} BC11{ m Fi Fi Fi Fi Fi[4] Fl Fc FD Fi} BC5 v2 FC12{} FC4 Fi Fc[8] Fi FD} VBC11 BC13{ BC4 BC14{ BC11 BC7 VBC4 vd Fi FC4 Fl Fi} VBC15{ BC10 vd v3 FC6 Fi FC10} VBC6 VBC10 Fp Fi Fi Fp Fp Fi} vd v4 Fi Fi Fp[8] FL Fc} BC13 BC16{ VBC7 VBC4 BC9 VBC15 VBC5 vd Fi Fi:0 Fp} FD[9] Fc FL} VBC17{ VBC15 BC3 BC18{ BC15 VBC5 BC6 BC19{ VBC7 VBC4 VBC16 BC5 vd FL Fi[6] Fp Fi Fi:12 Fp Fi} BC4 FC16[10] Fp[5]} vd FU8 Fp Fi} BC11 BC20{ BC19 BC13 BC14 Fp[9] Fp} BC5 Fi Fp[4]}


S19430C1 ::~S19430C1(){ note_dtor("S19430C1", this);} // tgen
S19430C1 ::S19430C1(){ note_ctor("S19430C1", this);} // tgen

static void Test_S19430C1()
{
  extern Class_Descriptor cd_S19430C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1798,4762)];
    init_test(&cd_S19430C1, buf);
    S19430C1 *dp, &lv = *(dp=new (buf) S19430C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(28752,19044), "sizeof(S19430C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S19430C1)");
    /*is_ambiguous_... S19430C1::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*), ABISELECT(3992,2636), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*), ABISELECT(4048,2680), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*), ABISELECT(4128,2728), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*), ABISELECT(4048,2680), "S19430C1");
    /*is_ambiguous_... S19430C3::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C3*)(S19430C2*), ABISELECT(3984,2632), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C9*), ABISELECT(3984,2632), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*), ABISELECT(3984,2632), "S19430C1");
    check_base_class_offset(lv, (S19430C4*)(S19430C14*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(3984,2632), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*), ABISELECT(3984,2632), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C14*)(S19430C13*)(S19430C2*), ABISELECT(3984,2632), "S19430C1");
    check_base_class_offset(lv, (S19430C4*)(S19430C16*)(S19430C2*), ABISELECT(3984,2632), "S19430C1");
    check_base_class_offset(lv, (S19430C4*)(S19430C9*)(S19430C16*)(S19430C2*), ABISELECT(3984,2632), "S19430C1");
    /*is_ambiguous_... S19430C3::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C3*)(S19430C17*), ABISELECT(3984,2632), "S19430C1");
    check_base_class_offset(lv, (S19430C4*)(S19430C14*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(3984,2632), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C10*)(S19430C15*)(S19430C18*)(S19430C17*), ABISELECT(3984,2632), "S19430C1");
    check_base_class_offset(lv, (S19430C4*)(S19430C19*)(S19430C18*)(S19430C17*), ABISELECT(3984,2632), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C16 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C16*), ABISELECT(3984,2632), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C16 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C9*)(S19430C16*), ABISELECT(3984,2632), "S19430C1");
    check_base_class_offset(lv, (S19430C4*)(S19430C19*)(S19430C20*), ABISELECT(3984,2632), "S19430C1");
    check_base_class_offset(lv, (S19430C4*)(S19430C14*)(S19430C13*)(S19430C20*), ABISELECT(3984,2632), "S19430C1");
    /*is_ambiguous_... S19430C20::S19430C14 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C14*)(S19430C20*), ABISELECT(3984,2632), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*), ABISELECT(4736,3148), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*), ABISELECT(4816,3196), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*), ABISELECT(4736,3148), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C9*), ABISELECT(4720,3144), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(4720,3144), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C13*)(S19430C2*), ABISELECT(4720,3144), "S19430C1");
    check_base_class_offset(lv, (S19430C10*)(S19430C9*)(S19430C16*)(S19430C2*), ABISELECT(4720,3144), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(4720,3144), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C16 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C9*)(S19430C16*), ABISELECT(4720,3144), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C10 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C13*)(S19430C20*), ABISELECT(4720,3144), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C9*), ABISELECT(4272,2824), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C9 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*), ABISELECT(4352,2880), "S19430C1");
    check_base_class_offset(lv, (S19430C9*)(S19430C3*)(S19430C2*), ABISELECT(4256,2820), "S19430C1");
    check_base_class_offset(lv, (S19430C9*)(S19430C3*)(S19430C17*), ABISELECT(4256,2820), "S19430C1");
    /*is_ambiguous_... S19430C3::S19430C11 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C3*)(S19430C2*), ABISELECT(4928,3272), "S19430C1");
    /*is_ambiguous_... S19430C3::S19430C11 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C3*)(S19430C17*), ABISELECT(4928,3272), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(1672,1092), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(1728,1136), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(1808,1184), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(1728,1136), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(1664,1088), "S19430C1");
    check_base_class_offset(lv, (S19430C11*)(S19430C14*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(1952,1280), "S19430C1");
    /*is_ambiguous_... S19430C14::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(2032,1336), "S19430C1");
    check_base_class_offset(lv, (S19430C14*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(1936,1276), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(5024,3332), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(5104,3380), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*), ABISELECT(5024,3332), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C15*), ABISELECT(5008,3328), "S19430C1");
    check_base_class_offset(lv, (S19430C15*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(5008,3328), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C15*)(S19430C13*)(S19430C2*), ABISELECT(5008,3328), "S19430C1");
    check_base_class_offset(lv, (S19430C15*)(S19430C16*)(S19430C2*), ABISELECT(5008,3328), "S19430C1");
    /*is_ambiguous_... S19430C17::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C15*)(S19430C17*), ABISELECT(5008,3328), "S19430C1");
    check_base_class_offset(lv, (S19430C15*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(5008,3328), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C16 */ AMB_check_base_class_offset(lv, (S19430C15*)(S19430C16*), ABISELECT(5008,3328), "S19430C1");
    check_base_class_offset(lv, (S19430C15*)(S19430C13*)(S19430C20*), ABISELECT(5008,3328), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*), ABISELECT(5888,3892), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*), ABISELECT(5968,3940), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(5888,3892), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C13*)(S19430C2*), ABISELECT(5888,3892), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(5888,3892), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C13*)(S19430C20*), ABISELECT(5888,3892), "S19430C1");
    check_base_class_offset(lv, (S19430C13*)(S19430C3*)(S19430C2*), ABISELECT(1664,1088), "S19430C1");
    check_base_class_offset(lv, (S19430C3*)(S19430C2*), ABISELECT(1664,1088), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C13*)(S19430C2*), ABISELECT(2552,1664), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C2*), ABISELECT(2608,1708), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C2*), ABISELECT(2688,1756), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C13*)(S19430C2*), ABISELECT(2608,1708), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C13*)(S19430C2*), ABISELECT(2544,1660), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C14*)(S19430C13*)(S19430C2*), ABISELECT(2832,1852), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*)(S19430C13*)(S19430C2*), ABISELECT(2912,1908), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C14*)(S19430C13*)(S19430C2*), ABISELECT(2816,1848), "S19430C1");
    /*is_ambiguous_... S19430C2::S19430C13 */ AMB_check_base_class_offset(lv, (S19430C13*)(S19430C2*), ABISELECT(2544,1660), "S19430C1");
    /*is_ambiguous_... S19430C16::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C16*)(S19430C2*), ABISELECT(6064,4008), "S19430C1");
    /*is_ambiguous_... S19430C19::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C19*)(S19430C18*)(S19430C17*), ABISELECT(6064,4008), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C16 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C16*), ABISELECT(6064,4008), "S19430C1");
    /*is_ambiguous_... S19430C19::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C19*)(S19430C20*), ABISELECT(6064,4008), "S19430C1");
    check_base_class_offset(lv, (S19430C11*)(S19430C9*)(S19430C16*)(S19430C2*), ABISELECT(3360,2184), "S19430C1");
    /*is_ambiguous_... S19430C9::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*)(S19430C16*)(S19430C2*), ABISELECT(3440,2240), "S19430C1");
    check_base_class_offset(lv, (S19430C9*)(S19430C16*)(S19430C2*), ABISELECT(3344,2180), "S19430C1");
    /*is_ambiguous_... S19430C16::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C16*)(S19430C2*), ABISELECT(6144,4056), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C18*)(S19430C17*), ABISELECT(6144,4056), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C16 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C16*), ABISELECT(6144,4056), "S19430C1");
    check_base_class_offset(lv, (S19430C16*)(S19430C2*), ABISELECT(3344,2180), "S19430C1");
    check_base_class_offset(lv, (S19430C2*), ABISELECT(1664,1088), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(6200,4104), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(6256,4148), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(6336,4196), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(6256,4148), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(6192,4100), "S19430C1");
    check_base_class_offset(lv, (S19430C11*)(S19430C14*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(6480,4292), "S19430C1");
    /*is_ambiguous_... S19430C14::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(6560,4348), "S19430C1");
    check_base_class_offset(lv, (S19430C14*)(S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(6464,4288), "S19430C1");
    check_base_class_offset(lv, (S19430C13*)(S19430C3*)(S19430C17*), ABISELECT(6192,4100), "S19430C1");
    check_base_class_offset(lv, (S19430C3*)(S19430C17*), ABISELECT(6192,4100), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C10*)(S19430C15*)(S19430C18*)(S19430C17*), ABISELECT(7088,4676), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C10*)(S19430C15*)(S19430C18*)(S19430C17*), ABISELECT(7168,4724), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C10*)(S19430C15*)(S19430C18*)(S19430C17*), ABISELECT(7088,4676), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C10*)(S19430C15*)(S19430C18*)(S19430C17*), ABISELECT(7072,4672), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C15 */ AMB_check_base_class_offset(lv, (S19430C15*)(S19430C18*)(S19430C17*), ABISELECT(7072,4672), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C18*)(S19430C17*), ABISELECT(7952,5236), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C18*)(S19430C17*), ABISELECT(8032,5284), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C6 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C18*)(S19430C17*), ABISELECT(7952,5236), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C16 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C9*)(S19430C16*), ABISELECT(28288,18716), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C16 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C9*)(S19430C16*), ABISELECT(28368,18772), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C16 */ AMB_check_base_class_offset(lv, (S19430C9*)(S19430C16*), ABISELECT(28272,18712), "S19430C1");
    check_base_class_offset(lv, (S19430C16*)(S19430C19*)(S19430C18*)(S19430C17*), ABISELECT(28272,18712), "S19430C1");
    check_base_class_offset(lv, (S19430C16*)(S19430C19*)(S19430C20*), ABISELECT(28272,18712), "S19430C1");
    /*is_ambiguous_... S19430C19::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C19*)(S19430C18*)(S19430C17*), ABISELECT(8136,5356), "S19430C1");
    check_base_class_offset(lv, (S19430C19*)(S19430C18*)(S19430C17*), ABISELECT(8128,5352), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C18*)(S19430C17*), ABISELECT(8264,5456), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C18*)(S19430C17*), ABISELECT(8320,5500), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C18*)(S19430C17*), ABISELECT(8400,5548), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C18*)(S19430C17*), ABISELECT(8320,5500), "S19430C1");
    /*is_ambiguous_... S19430C18::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C18*)(S19430C17*), ABISELECT(8256,5452), "S19430C1");
    check_base_class_offset(lv, (S19430C18*)(S19430C17*), ABISELECT(7072,4672), "S19430C1");
    check_base_class_offset(lv, (S19430C17*), ABISELECT(6192,4100), "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C11 */ AMB_check_base_class_offset(lv, (S19430C11*), ABISELECT(1488,968), "S19430C1");
    /*is_ambiguous_... S19430C19::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C19*)(S19430C20*), ABISELECT(8,4), "S19430C1");
    check_base_class_offset(lv, (S19430C19*)(S19430C20*), 0, "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C4*)(S19430C13*)(S19430C20*), ABISELECT(136,104), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C20*), ABISELECT(192,148), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C5*)(S19430C6*)(S19430C4*)(S19430C13*)(S19430C20*), ABISELECT(272,196), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C6*)(S19430C4*)(S19430C13*)(S19430C20*), ABISELECT(192,148), "S19430C1");
    /*is_ambiguous_... S19430C13::S19430C4 */ AMB_check_base_class_offset(lv, (S19430C4*)(S19430C13*)(S19430C20*), ABISELECT(128,100), "S19430C1");
    check_base_class_offset(lv, (S19430C11*)(S19430C14*)(S19430C13*)(S19430C20*), ABISELECT(416,292), "S19430C1");
    /*is_ambiguous_... S19430C14::S19430C7 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*)(S19430C13*)(S19430C20*), ABISELECT(496,348), "S19430C1");
    check_base_class_offset(lv, (S19430C14*)(S19430C13*)(S19430C20*), ABISELECT(400,288), "S19430C1");
    check_base_class_offset(lv, (S19430C13*)(S19430C20*), ABISELECT(128,100), "S19430C1");
    /*is_ambiguous_... S19430C20::S19430C14 */ AMB_check_base_class_offset(lv, (S19430C11*)(S19430C14*)(S19430C20*), ABISELECT(944,624), "S19430C1");
    /*is_ambiguous_... S19430C20::S19430C14 */ AMB_check_base_class_offset(lv, (S19430C7*)(S19430C14*)(S19430C20*), ABISELECT(1024,680), "S19430C1");
    /*is_ambiguous_... S19430C20::S19430C14 */ AMB_check_base_class_offset(lv, (S19430C14*)(S19430C20*), ABISELECT(928,620), "S19430C1");
    check_base_class_offset(lv, (S19430C20*), 0, "S19430C1");
    /*is_ambiguous_... S19430C1::S19430C5 */ AMB_check_base_class_offset(lv, (S19430C5*), ABISELECT(1568,1024), "S19430C1");
    check_field_offset(lv, s19430c1f0, ABISELECT(1616,1068), "S19430C1.s19430c1f0");
    check_field_offset(lv, s19430c1f1, ABISELECT(1624,1072), "S19430C1.s19430c1f1");
    test_class_info(&lv, &cd_S19430C1);
    dp->~S19430C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS19430C1(Test_S19430C1, "S19430C1", ABISELECT(28752,19044));

#else // __cplusplus

extern void _ZN8S19430C1C1Ev();
extern void _ZN8S19430C1D1Ev();
Name_Map name_map_S19430C1[] = {
  NSPAIR(_ZN8S19430C1C1Ev),
  NSPAIR(_ZN8S19430C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C13;
extern VTBL_ENTRY _ZTI9S19430C13[];
extern  VTBL_ENTRY _ZTV9S19430C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C13[];
extern Class_Descriptor cd_S19430C3;
extern VTBL_ENTRY _ZTI8S19430C3[];
extern  VTBL_ENTRY _ZTV8S19430C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C3[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C13;
extern VTBL_ENTRY _ZTI9S19430C13[];
extern  VTBL_ENTRY _ZTV9S19430C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C13[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C16;
extern VTBL_ENTRY _ZTI9S19430C16[];
extern  VTBL_ENTRY _ZTV9S19430C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C16[];
extern Class_Descriptor cd_S19430C2;
extern VTBL_ENTRY _ZTI8S19430C2[];
extern  VTBL_ENTRY _ZTV8S19430C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C2[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C13;
extern VTBL_ENTRY _ZTI9S19430C13[];
extern  VTBL_ENTRY _ZTV9S19430C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C13[];
extern Class_Descriptor cd_S19430C3;
extern VTBL_ENTRY _ZTI8S19430C3[];
extern  VTBL_ENTRY _ZTV8S19430C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C3[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C10;
extern VTBL_ENTRY _ZTI9S19430C10[];
extern  VTBL_ENTRY _ZTV9S19430C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C10[];
extern Class_Descriptor cd_S19430C15;
extern VTBL_ENTRY _ZTI9S19430C15[];
extern  VTBL_ENTRY _ZTV9S19430C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C15[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C9;
extern VTBL_ENTRY _ZTI8S19430C9[];
extern  VTBL_ENTRY _ZTV8S19430C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S19430C9[];
extern Class_Descriptor cd_S19430C16;
extern VTBL_ENTRY _ZTI9S19430C16[];
extern  VTBL_ENTRY _ZTV9S19430C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C16[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C19;
extern VTBL_ENTRY _ZTI9S19430C19[];
extern  VTBL_ENTRY _ZTV9S19430C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C19[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C18;
extern VTBL_ENTRY _ZTI9S19430C18[];
extern  VTBL_ENTRY _ZTV9S19430C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C18[];
extern Class_Descriptor cd_S19430C17;
extern VTBL_ENTRY _ZTI9S19430C17[];
extern  VTBL_ENTRY _ZTV9S19430C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C17[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C19;
extern VTBL_ENTRY _ZTI9S19430C19[];
extern  VTBL_ENTRY _ZTV9S19430C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C19[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
extern Class_Descriptor cd_S19430C6;
extern VTBL_ENTRY _ZTI8S19430C6[];
extern Class_Descriptor cd_S19430C4;
extern VTBL_ENTRY _ZTI8S19430C4[];
extern  VTBL_ENTRY _ZTV8S19430C4[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C13;
extern VTBL_ENTRY _ZTI9S19430C13[];
extern  VTBL_ENTRY _ZTV9S19430C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C13[];
extern Class_Descriptor cd_S19430C11;
extern VTBL_ENTRY _ZTI9S19430C11[];
extern Class_Descriptor cd_S19430C7;
extern VTBL_ENTRY _ZTI8S19430C7[];
extern Class_Descriptor cd_S19430C14;
extern VTBL_ENTRY _ZTI9S19430C14[];
extern  VTBL_ENTRY _ZTV9S19430C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C14[];
extern Class_Descriptor cd_S19430C20;
extern VTBL_ENTRY _ZTI9S19430C20[];
extern  VTBL_ENTRY _ZTV9S19430C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S19430C20[];
extern Class_Descriptor cd_S19430C5;
extern VTBL_ENTRY _ZTI8S19430C5[];
static Base_Class bases_S19430C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S19430C5,    ABISELECT(3992,2636), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(4048,2680), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(4128,2728), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(4048,2680), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(3984,2632), //bcp->offset
    81, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(4736,3148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(4816,3196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(4736,3148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(4720,3144), //bcp->offset
    97, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(4272,2824), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(4352,2880), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S19430C9,    ABISELECT(4256,2820), //bcp->offset
    88, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    78, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S19430C11,    ABISELECT(4928,3272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S19430C5,    ABISELECT(1672,1092), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(1728,1136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(1808,1184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(1728,1136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(1664,1088), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C11,    ABISELECT(1952,1280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(2032,1336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S19430C14,    ABISELECT(1936,1276), //bcp->offset
    52, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(5024,3332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(5104,3380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(5024,3332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S19430C10,    ABISELECT(5008,3328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    84, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S19430C15,    ABISELECT(5008,3328), //bcp->offset
    103, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    83, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S19430C7,    ABISELECT(5888,3892), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(5968,3940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(5888,3892), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S19430C13,    ABISELECT(1664,1088), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S19430C3,    ABISELECT(1664,1088), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2552,1664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(2608,1708), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19430C5,    ABISELECT(2688,1756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S19430C6,    ABISELECT(2608,1708), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S19430C4,    ABISELECT(2544,1660), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19430C11,    ABISELECT(2832,1852), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19430C7,    ABISELECT(2912,1908), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S19430C14,    ABISELECT(2816,1848), //bcp->offset
    66, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S19430C13,    ABISELECT(2544,1660), //bcp->offset
    57, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_constructio