// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S4216C3_nt  {
  virtual  ~S4216C3_nt(); // _ZN10S4216C3_ntD1Ev
  virtual void  v104(); // _ZN10S4216C3_nt4v104Ev
  virtual void  v105(); // _ZN10S4216C3_nt4v105Ev
  virtual void  v106(); // _ZN10S4216C3_nt4v106Ev
  S4216C3_nt(); // tgen
};
//SIG(-1 S4216C3_nt) C1{ vd v1 v2 v3}


 S4216C3_nt ::~S4216C3_nt(){ note_dtor("S4216C3_nt", this);}
void  S4216C3_nt ::v104(){vfunc_called(this, "_ZN10S4216C3_nt4v104Ev");}
void  S4216C3_nt ::v105(){vfunc_called(this, "_ZN10S4216C3_nt4v105Ev");}
void  S4216C3_nt ::v106(){vfunc_called(this, "_ZN10S4216C3_nt4v106Ev");}
S4216C3_nt ::S4216C3_nt(){ note_ctor("S4216C3_nt", this);} // tgen

//skip512 S4216C3_nt

#else // __cplusplus

extern void _ZN10S4216C3_ntC1Ev();
extern void _ZN10S4216C3_ntD1Ev();
Name_Map name_map_S4216C3_nt[] = {
  NSPAIR(_ZN10S4216C3_ntC1Ev),
  NSPAIR(_ZN10S4216C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S4216C3_nt[];
extern void _ZN10S4216C3_ntD1Ev();
extern void _ZN10S4216C3_ntD0Ev();
extern void _ZN10S4216C3_nt4v104Ev();
extern void _ZN10S4216C3_nt4v105Ev();
extern void _ZN10S4216C3_nt4v106Ev();
static  VTBL_ENTRY vtc_S4216C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4216C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S4216C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v106Ev,
};
extern VTBL_ENTRY _ZTI10S4216C3_nt[];
VTBL_ENTRY *P__ZTI10S4216C3_nt = _ZTI10S4216C3_nt; 
extern  VTBL_ENTRY _ZTV10S4216C3_nt[];
Class_Descriptor cd_S4216C3_nt = {  "S4216C3_nt", // class name
  0,0,//no base classes
  &(vtc_S4216C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S4216C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S4216C3_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C5_nt  {
  void  mf4216c5(); // _ZN10S4216C5_nt8mf4216c5Ev
};
//SIG(-1 S4216C5_nt) C1{ m}


void  S4216C5_nt ::mf4216c5(){}

//skip512 S4216C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C4_nt  {
  void *s4216c4f0;
  int s4216c4f1[2];
  ::S4216C5_nt s4216c4f2;
  void  mf4216c4(); // _ZN10S4216C4_nt8mf4216c4Ev
};
//SIG(-1 S4216C4_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S4216C4_nt ::mf4216c4(){}

//skip512 S4216C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C7_nt  {
  long s4216c7f0[4];
};
//SIG(-1 S4216C7_nt) C1{ Fl[4]}



//skip512 S4216C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C6_nt  {
  ::S4216C7_nt s4216c6f0;
  void  mf4216c6(); // _ZN10S4216C6_nt8mf4216c6Ev
};
//SIG(-1 S4216C6_nt) C1{ m FC2{ Fl[4]}}


void  S4216C6_nt ::mf4216c6(){}

//skip512 S4216C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C2  : S4216C3_nt {
  ::S4216C4_nt s4216c2f0;
  ::S4216C6_nt s4216c2f1;
  char s4216c2f2;
  virtual  ~S4216C2(); // _ZN7S4216C2D1Ev
  virtual void  v107(); // _ZN7S4216C24v107Ev
  virtual void  v108(); // _ZN7S4216C24v108Ev
  virtual void  v109(); // _ZN7S4216C24v109Ev
  S4216C2(); // tgen
};
//SIG(-1 S4216C2) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ Fl[4]}} Fc}


 S4216C2 ::~S4216C2(){ note_dtor("S4216C2", this);}
void  S4216C2 ::v107(){vfunc_called(this, "_ZN7S4216C24v107Ev");}
void  S4216C2 ::v108(){vfunc_called(this, "_ZN7S4216C24v108Ev");}
void  S4216C2 ::v109(){vfunc_called(this, "_ZN7S4216C24v109Ev");}
S4216C2 ::S4216C2(){ note_ctor("S4216C2", this);} // tgen

static void Test_S4216C2()
{
  extern Class_Descriptor cd_S4216C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S4216C2, buf);
    S4216C2 *dp, &lv = *(dp=new (buf) S4216C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S4216C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C2)");
    check_base_class_offset(lv, (S4216C3_nt*), 0, "S4216C2");
    check_field_offset(lv, s4216c2f0, ABISELECT(8,4), "S4216C2.s4216c2f0");
    check_field_offset(lv, s4216c2f1, ABISELECT(32,20), "S4216C2.s4216c2f1");
    check_field_offset(lv, s4216c2f2, ABISELECT(64,36), "S4216C2.s4216c2f2");
    test_class_info(&lv, &cd_S4216C2);
    dp->~S4216C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C2(Test_S4216C2, "S4216C2", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S4216C2C1Ev();
extern void _ZN7S4216C2D1Ev();
Name_Map name_map_S4216C2[] = {
  NSPAIR(_ZN7S4216C2C1Ev),
  NSPAIR(_ZN7S4216C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C3_nt;
extern VTBL_ENTRY _ZTI10S4216C3_nt[];
extern  VTBL_ENTRY _ZTV10S4216C3_nt[];
static Base_Class bases_S4216C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4216C2[];
extern void _ZN7S4216C2D1Ev();
extern void _ZN7S4216C2D0Ev();
extern void _ZN10S4216C3_nt4v104Ev();
extern void _ZN10S4216C3_nt4v105Ev();
extern void _ZN10S4216C3_nt4v106Ev();
extern void _ZN7S4216C24v107Ev();
extern void _ZN7S4216C24v108Ev();
extern void _ZN7S4216C24v109Ev();
static  VTBL_ENTRY vtc_S4216C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4216C2[0]),
  (VTBL_ENTRY)&_ZN7S4216C2D1Ev,
  (VTBL_ENTRY)&_ZN7S4216C2D0Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN7S4216C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4216C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4216C24v109Ev,
};
extern VTBL_ENTRY _ZTI7S4216C2[];
extern  VTBL_ENTRY _ZTV7S4216C2[];
Class_Descriptor cd_S4216C2 = {  "S4216C2", // class name
  bases_S4216C2, 1,
  &(vtc_S4216C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S4216C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4216C2),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C8_nt  {
  virtual  ~S4216C8_nt(); // _ZN10S4216C8_ntD1Ev
  virtual void  v110(); // _ZN10S4216C8_nt4v110Ev
  virtual void  v111(); // _ZN10S4216C8_nt4v111Ev
  virtual void  v112(); // _ZN10S4216C8_nt4v112Ev
  virtual void  v113(); // _ZN10S4216C8_nt4v113Ev
  virtual void  v114(); // _ZN10S4216C8_nt4v114Ev
  virtual void  v115(); // _ZN10S4216C8_nt4v115Ev
  virtual void  v116(); // _ZN10S4216C8_nt4v116Ev
  virtual void  v117(); // _ZN10S4216C8_nt4v117Ev
  virtual void  v118(); // _ZN10S4216C8_nt4v118Ev
  virtual void  v119(); // _ZN10S4216C8_nt4v119Ev
  virtual void  v120(); // _ZN10S4216C8_nt4v120Ev
  virtual void  v121(); // _ZN10S4216C8_nt4v121Ev
  virtual void  v122(); // _ZN10S4216C8_nt4v122Ev
  virtual void  v123(); // _ZN10S4216C8_nt4v123Ev
  virtual void  v124(); // _ZN10S4216C8_nt4v124Ev
  S4216C8_nt(); // tgen
};
//SIG(-1 S4216C8_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15}


 S4216C8_nt ::~S4216C8_nt(){ note_dtor("S4216C8_nt", this);}
void  S4216C8_nt ::v110(){vfunc_called(this, "_ZN10S4216C8_nt4v110Ev");}
void  S4216C8_nt ::v111(){vfunc_called(this, "_ZN10S4216C8_nt4v111Ev");}
void  S4216C8_nt ::v112(){vfunc_called(this, "_ZN10S4216C8_nt4v112Ev");}
void  S4216C8_nt ::v113(){vfunc_called(this, "_ZN10S4216C8_nt4v113Ev");}
void  S4216C8_nt ::v114(){vfunc_called(this, "_ZN10S4216C8_nt4v114Ev");}
void  S4216C8_nt ::v115(){vfunc_called(this, "_ZN10S4216C8_nt4v115Ev");}
void  S4216C8_nt ::v116(){vfunc_called(this, "_ZN10S4216C8_nt4v116Ev");}
void  S4216C8_nt ::v117(){vfunc_called(this, "_ZN10S4216C8_nt4v117Ev");}
void  S4216C8_nt ::v118(){vfunc_called(this, "_ZN10S4216C8_nt4v118Ev");}
void  S4216C8_nt ::v119(){vfunc_called(this, "_ZN10S4216C8_nt4v119Ev");}
void  S4216C8_nt ::v120(){vfunc_called(this, "_ZN10S4216C8_nt4v120Ev");}
void  S4216C8_nt ::v121(){vfunc_called(this, "_ZN10S4216C8_nt4v121Ev");}
void  S4216C8_nt ::v122(){vfunc_called(this, "_ZN10S4216C8_nt4v122Ev");}
void  S4216C8_nt ::v123(){vfunc_called(this, "_ZN10S4216C8_nt4v123Ev");}
void  S4216C8_nt ::v124(){vfunc_called(this, "_ZN10S4216C8_nt4v124Ev");}
S4216C8_nt ::S4216C8_nt(){ note_ctor("S4216C8_nt", this);} // tgen

//skip512 S4216C8_nt

#else // __cplusplus

extern void _ZN10S4216C8_ntC1Ev();
extern void _ZN10S4216C8_ntD1Ev();
Name_Map name_map_S4216C8_nt[] = {
  NSPAIR(_ZN10S4216C8_ntC1Ev),
  NSPAIR(_ZN10S4216C8_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S4216C8_nt[];
extern void _ZN10S4216C8_ntD1Ev();
extern void _ZN10S4216C8_ntD0Ev();
extern void _ZN10S4216C8_nt4v110Ev();
extern void _ZN10S4216C8_nt4v111Ev();
extern void _ZN10S4216C8_nt4v112Ev();
extern void _ZN10S4216C8_nt4v113Ev();
extern void _ZN10S4216C8_nt4v114Ev();
extern void _ZN10S4216C8_nt4v115Ev();
extern void _ZN10S4216C8_nt4v116Ev();
extern void _ZN10S4216C8_nt4v117Ev();
extern void _ZN10S4216C8_nt4v118Ev();
extern void _ZN10S4216C8_nt4v119Ev();
extern void _ZN10S4216C8_nt4v120Ev();
extern void _ZN10S4216C8_nt4v121Ev();
extern void _ZN10S4216C8_nt4v122Ev();
extern void _ZN10S4216C8_nt4v123Ev();
extern void _ZN10S4216C8_nt4v124Ev();
static  VTBL_ENTRY vtc_S4216C8_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4216C8_nt[0]),
  (VTBL_ENTRY)&_ZN10S4216C8_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v124Ev,
};
extern VTBL_ENTRY _ZTI10S4216C8_nt[];
VTBL_ENTRY *P__ZTI10S4216C8_nt = _ZTI10S4216C8_nt; 
extern  VTBL_ENTRY _ZTV10S4216C8_nt[];
Class_Descriptor cd_S4216C8_nt = {  "S4216C8_nt", // class name
  0,0,//no base classes
  &(vtc_S4216C8_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S4216C8_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S4216C8_nt),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C9  {
  virtual  ~S4216C9(); // _ZN7S4216C9D1Ev
  virtual void  v125(); // _ZN7S4216C94v125Ev
  virtual void  v126(); // _ZN7S4216C94v126Ev
  virtual void  v127(); // _ZN7S4216C94v127Ev
  virtual void  v128(); // _ZN7S4216C94v128Ev
  virtual void  v129(); // _ZN7S4216C94v129Ev
  virtual void  v130(); // _ZN7S4216C94v130Ev
  virtual void  v131(); // _ZN7S4216C94v131Ev
  virtual void  v132(); // _ZN7S4216C94v132Ev
  virtual void  v133(); // _ZN7S4216C94v133Ev
  virtual void  v134(); // _ZN7S4216C94v134Ev
  virtual void  v135(); // _ZN7S4216C94v135Ev
  virtual void  v136(); // _ZN7S4216C94v136Ev
  virtual void  v137(); // _ZN7S4216C94v137Ev
  virtual void  v138(); // _ZN7S4216C94v138Ev
  virtual void  v139(); // _ZN7S4216C94v139Ev
  virtual void  v140(); // _ZN7S4216C94v140Ev
  virtual void  v141(); // _ZN7S4216C94v141Ev
  virtual void  v142(); // _ZN7S4216C94v142Ev
  virtual void  v143(); // _ZN7S4216C94v143Ev
  virtual void  v144(); // _ZN7S4216C94v144Ev
  virtual void  v145(); // _ZN7S4216C94v145Ev
  virtual void  v146(); // _ZN7S4216C94v146Ev
  virtual void  v147(); // _ZN7S4216C94v147Ev
  virtual void  v148(); // _ZN7S4216C94v148Ev
  virtual void  v149(); // _ZN7S4216C94v149Ev
  virtual void  v150(); // _ZN7S4216C94v150Ev
  virtual void  v151(); // _ZN7S4216C94v151Ev
  virtual void  v152(); // _ZN7S4216C94v152Ev
  virtual void  v153(); // _ZN7S4216C94v153Ev
  virtual void  v154(); // _ZN7S4216C94v154Ev
  virtual void  v155(); // _ZN7S4216C94v155Ev
  virtual void  v156(); // _ZN7S4216C94v156Ev
  virtual void  v157(); // _ZN7S4216C94v157Ev
  virtual void  v158(); // _ZN7S4216C94v158Ev
  virtual void  v159(); // _ZN7S4216C94v159Ev
  virtual void  v160(); // _ZN7S4216C94v160Ev
  virtual void  v161(); // _ZN7S4216C94v161Ev
  virtual void  v162(); // _ZN7S4216C94v162Ev
  virtual void  v163(); // _ZN7S4216C94v163Ev
  virtual void  v164(); // _ZN7S4216C94v164Ev
  virtual void  v165(); // _ZN7S4216C94v165Ev
  virtual void  v166(); // _ZN7S4216C94v166Ev
  virtual void  v167(); // _ZN7S4216C94v167Ev
  virtual void  v168(); // _ZN7S4216C94v168Ev
  virtual void  v169(); // _ZN7S4216C94v169Ev
  virtual void  v170(); // _ZN7S4216C94v170Ev
  virtual void  v171(); // _ZN7S4216C94v171Ev
  virtual void  v172(); // _ZN7S4216C94v172Ev
  virtual void  v173(); // _ZN7S4216C94v173Ev
  virtual void  v174(); // _ZN7S4216C94v174Ev
  virtual void  v175(); // _ZN7S4216C94v175Ev
  virtual void  v176(); // _ZN7S4216C94v176Ev
  virtual void  v177(); // _ZN7S4216C94v177Ev
  virtual void  v178(); // _ZN7S4216C94v178Ev
  virtual void  v179(); // _ZN7S4216C94v179Ev
  virtual void  v180(); // _ZN7S4216C94v180Ev
  virtual void  v181(); // _ZN7S4216C94v181Ev
  virtual void  v182(); // _ZN7S4216C94v182Ev
  virtual void  v183(); // _ZN7S4216C94v183Ev
  virtual void  v184(); // _ZN7S4216C94v184Ev
  virtual void  v185(); // _ZN7S4216C94v185Ev
  virtual void  v186(); // _ZN7S4216C94v186Ev
  virtual void  v187(); // _ZN7S4216C94v187Ev
  virtual void  v188(); // _ZN7S4216C94v188Ev
  virtual void  v189(); // _ZN7S4216C94v189Ev
  virtual void  v190(); // _ZN7S4216C94v190Ev
  virtual void  v191(); // _ZN7S4216C94v191Ev
  virtual void  v192(); // _ZN7S4216C94v192Ev
  virtual void  v193(); // _ZN7S4216C94v193Ev
  virtual void  v194(); // _ZN7S4216C94v194Ev
  virtual void  v195(); // _ZN7S4216C94v195Ev
  virtual void  v196(); // _ZN7S4216C94v196Ev
  virtual void  v197(); // _ZN7S4216C94v197Ev
  virtual void  v198(); // _ZN7S4216C94v198Ev
  virtual void  v199(); // _ZN7S4216C94v199Ev
  virtual void  v200(); // _ZN7S4216C94v200Ev
  virtual void  v201(); // _ZN7S4216C94v201Ev
  virtual void  v202(); // _ZN7S4216C94v202Ev
  virtual void  v203(); // _ZN7S4216C94v203Ev
  virtual void  v204(); // _ZN7S4216C94v204Ev
  S4216C9(); // tgen
};
//SIG(-1 S4216C9) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80}


 S4216C9 ::~S4216C9(){ note_dtor("S4216C9", this);}
void  S4216C9 ::v125(){vfunc_called(this, "_ZN7S4216C94v125Ev");}
void  S4216C9 ::v126(){vfunc_called(this, "_ZN7S4216C94v126Ev");}
void  S4216C9 ::v127(){vfunc_called(this, "_ZN7S4216C94v127Ev");}
void  S4216C9 ::v128(){vfunc_called(this, "_ZN7S4216C94v128Ev");}
void  S4216C9 ::v129(){vfunc_called(this, "_ZN7S4216C94v129Ev");}
void  S4216C9 ::v130(){vfunc_called(this, "_ZN7S4216C94v130Ev");}
void  S4216C9 ::v131(){vfunc_called(this, "_ZN7S4216C94v131Ev");}
void  S4216C9 ::v132(){vfunc_called(this, "_ZN7S4216C94v132Ev");}
void  S4216C9 ::v133(){vfunc_called(this, "_ZN7S4216C94v133Ev");}
void  S4216C9 ::v134(){vfunc_called(this, "_ZN7S4216C94v134Ev");}
void  S4216C9 ::v135(){vfunc_called(this, "_ZN7S4216C94v135Ev");}
void  S4216C9 ::v136(){vfunc_called(this, "_ZN7S4216C94v136Ev");}
void  S4216C9 ::v137(){vfunc_called(this, "_ZN7S4216C94v137Ev");}
void  S4216C9 ::v138(){vfunc_called(this, "_ZN7S4216C94v138Ev");}
void  S4216C9 ::v139(){vfunc_called(this, "_ZN7S4216C94v139Ev");}
void  S4216C9 ::v140(){vfunc_called(this, "_ZN7S4216C94v140Ev");}
void  S4216C9 ::v141(){vfunc_called(this, "_ZN7S4216C94v141Ev");}
void  S4216C9 ::v142(){vfunc_called(this, "_ZN7S4216C94v142Ev");}
void  S4216C9 ::v143(){vfunc_called(this, "_ZN7S4216C94v143Ev");}
void  S4216C9 ::v144(){vfunc_called(this, "_ZN7S4216C94v144Ev");}
void  S4216C9 ::v145(){vfunc_called(this, "_ZN7S4216C94v145Ev");}
void  S4216C9 ::v146(){vfunc_called(this, "_ZN7S4216C94v146Ev");}
void  S4216C9 ::v147(){vfunc_called(this, "_ZN7S4216C94v147Ev");}
void  S4216C9 ::v148(){vfunc_called(this, "_ZN7S4216C94v148Ev");}
void  S4216C9 ::v149(){vfunc_called(this, "_ZN7S4216C94v149Ev");}
void  S4216C9 ::v150(){vfunc_called(this, "_ZN7S4216C94v150Ev");}
void  S4216C9 ::v151(){vfunc_called(this, "_ZN7S4216C94v151Ev");}
void  S4216C9 ::v152(){vfunc_called(this, "_ZN7S4216C94v152Ev");}
void  S4216C9 ::v153(){vfunc_called(this, "_ZN7S4216C94v153Ev");}
void  S4216C9 ::v154(){vfunc_called(this, "_ZN7S4216C94v154Ev");}
void  S4216C9 ::v155(){vfunc_called(this, "_ZN7S4216C94v155Ev");}
void  S4216C9 ::v156(){vfunc_called(this, "_ZN7S4216C94v156Ev");}
void  S4216C9 ::v157(){vfunc_called(this, "_ZN7S4216C94v157Ev");}
void  S4216C9 ::v158(){vfunc_called(this, "_ZN7S4216C94v158Ev");}
void  S4216C9 ::v159(){vfunc_called(this, "_ZN7S4216C94v159Ev");}
void  S4216C9 ::v160(){vfunc_called(this, "_ZN7S4216C94v160Ev");}
void  S4216C9 ::v161(){vfunc_called(this, "_ZN7S4216C94v161Ev");}
void  S4216C9 ::v162(){vfunc_called(this, "_ZN7S4216C94v162Ev");}
void  S4216C9 ::v163(){vfunc_called(this, "_ZN7S4216C94v163Ev");}
void  S4216C9 ::v164(){vfunc_called(this, "_ZN7S4216C94v164Ev");}
void  S4216C9 ::v165(){vfunc_called(this, "_ZN7S4216C94v165Ev");}
void  S4216C9 ::v166(){vfunc_called(this, "_ZN7S4216C94v166Ev");}
void  S4216C9 ::v167(){vfunc_called(this, "_ZN7S4216C94v167Ev");}
void  S4216C9 ::v168(){vfunc_called(this, "_ZN7S4216C94v168Ev");}
void  S4216C9 ::v169(){vfunc_called(this, "_ZN7S4216C94v169Ev");}
void  S4216C9 ::v170(){vfunc_called(this, "_ZN7S4216C94v170Ev");}
void  S4216C9 ::v171(){vfunc_called(this, "_ZN7S4216C94v171Ev");}
void  S4216C9 ::v172(){vfunc_called(this, "_ZN7S4216C94v172Ev");}
void  S4216C9 ::v173(){vfunc_called(this, "_ZN7S4216C94v173Ev");}
void  S4216C9 ::v174(){vfunc_called(this, "_ZN7S4216C94v174Ev");}
void  S4216C9 ::v175(){vfunc_called(this, "_ZN7S4216C94v175Ev");}
void  S4216C9 ::v176(){vfunc_called(this, "_ZN7S4216C94v176Ev");}
void  S4216C9 ::v177(){vfunc_called(this, "_ZN7S4216C94v177Ev");}
void  S4216C9 ::v178(){vfunc_called(this, "_ZN7S4216C94v178Ev");}
void  S4216C9 ::v179(){vfunc_called(this, "_ZN7S4216C94v179Ev");}
void  S4216C9 ::v180(){vfunc_called(this, "_ZN7S4216C94v180Ev");}
void  S4216C9 ::v181(){vfunc_called(this, "_ZN7S4216C94v181Ev");}
void  S4216C9 ::v182(){vfunc_called(this, "_ZN7S4216C94v182Ev");}
void  S4216C9 ::v183(){vfunc_called(this, "_ZN7S4216C94v183Ev");}
void  S4216C9 ::v184(){vfunc_called(this, "_ZN7S4216C94v184Ev");}
void  S4216C9 ::v185(){vfunc_called(this, "_ZN7S4216C94v185Ev");}
void  S4216C9 ::v186(){vfunc_called(this, "_ZN7S4216C94v186Ev");}
void  S4216C9 ::v187(){vfunc_called(this, "_ZN7S4216C94v187Ev");}
void  S4216C9 ::v188(){vfunc_called(this, "_ZN7S4216C94v188Ev");}
void  S4216C9 ::v189(){vfunc_called(this, "_ZN7S4216C94v189Ev");}
void  S4216C9 ::v190(){vfunc_called(this, "_ZN7S4216C94v190Ev");}
void  S4216C9 ::v191(){vfunc_called(this, "_ZN7S4216C94v191Ev");}
void  S4216C9 ::v192(){vfunc_called(this, "_ZN7S4216C94v192Ev");}
void  S4216C9 ::v193(){vfunc_called(this, "_ZN7S4216C94v193Ev");}
void  S4216C9 ::v194(){vfunc_called(this, "_ZN7S4216C94v194Ev");}
void  S4216C9 ::v195(){vfunc_called(this, "_ZN7S4216C94v195Ev");}
void  S4216C9 ::v196(){vfunc_called(this, "_ZN7S4216C94v196Ev");}
void  S4216C9 ::v197(){vfunc_called(this, "_ZN7S4216C94v197Ev");}
void  S4216C9 ::v198(){vfunc_called(this, "_ZN7S4216C94v198Ev");}
void  S4216C9 ::v199(){vfunc_called(this, "_ZN7S4216C94v199Ev");}
void  S4216C9 ::v200(){vfunc_called(this, "_ZN7S4216C94v200Ev");}
void  S4216C9 ::v201(){vfunc_called(this, "_ZN7S4216C94v201Ev");}
void  S4216C9 ::v202(){vfunc_called(this, "_ZN7S4216C94v202Ev");}
void  S4216C9 ::v203(){vfunc_called(this, "_ZN7S4216C94v203Ev");}
void  S4216C9 ::v204(){vfunc_called(this, "_ZN7S4216C94v204Ev");}
S4216C9 ::S4216C9(){ note_ctor("S4216C9", this);} // tgen

static void Test_S4216C9()
{
  extern Class_Descriptor cd_S4216C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4216C9, buf);
    S4216C9 *dp, &lv = *(dp=new (buf) S4216C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4216C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C9)");
    test_class_info(&lv, &cd_S4216C9);
    dp->~S4216C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C9(Test_S4216C9, "S4216C9", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4216C9C1Ev();
extern void _ZN7S4216C9D1Ev();
Name_Map name_map_S4216C9[] = {
  NSPAIR(_ZN7S4216C9C1Ev),
  NSPAIR(_ZN7S4216C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4216C9[];
extern void _ZN7S4216C9D1Ev();
extern void _ZN7S4216C9D0Ev();
extern void _ZN7S4216C94v125Ev();
extern void _ZN7S4216C94v126Ev();
extern void _ZN7S4216C94v127Ev();
extern void _ZN7S4216C94v128Ev();
extern void _ZN7S4216C94v129Ev();
extern void _ZN7S4216C94v130Ev();
extern void _ZN7S4216C94v131Ev();
extern void _ZN7S4216C94v132Ev();
extern void _ZN7S4216C94v133Ev();
extern void _ZN7S4216C94v134Ev();
extern void _ZN7S4216C94v135Ev();
extern void _ZN7S4216C94v136Ev();
extern void _ZN7S4216C94v137Ev();
extern void _ZN7S4216C94v138Ev();
extern void _ZN7S4216C94v139Ev();
extern void _ZN7S4216C94v140Ev();
extern void _ZN7S4216C94v141Ev();
extern void _ZN7S4216C94v142Ev();
extern void _ZN7S4216C94v143Ev();
extern void _ZN7S4216C94v144Ev();
extern void _ZN7S4216C94v145Ev();
extern void _ZN7S4216C94v146Ev();
extern void _ZN7S4216C94v147Ev();
extern void _ZN7S4216C94v148Ev();
extern void _ZN7S4216C94v149Ev();
extern void _ZN7S4216C94v150Ev();
extern void _ZN7S4216C94v151Ev();
extern void _ZN7S4216C94v152Ev();
extern void _ZN7S4216C94v153Ev();
extern void _ZN7S4216C94v154Ev();
extern void _ZN7S4216C94v155Ev();
extern void _ZN7S4216C94v156Ev();
extern void _ZN7S4216C94v157Ev();
extern void _ZN7S4216C94v158Ev();
extern void _ZN7S4216C94v159Ev();
extern void _ZN7S4216C94v160Ev();
extern void _ZN7S4216C94v161Ev();
extern void _ZN7S4216C94v162Ev();
extern void _ZN7S4216C94v163Ev();
extern void _ZN7S4216C94v164Ev();
extern void _ZN7S4216C94v165Ev();
extern void _ZN7S4216C94v166Ev();
extern void _ZN7S4216C94v167Ev();
extern void _ZN7S4216C94v168Ev();
extern void _ZN7S4216C94v169Ev();
extern void _ZN7S4216C94v170Ev();
extern void _ZN7S4216C94v171Ev();
extern void _ZN7S4216C94v172Ev();
extern void _ZN7S4216C94v173Ev();
extern void _ZN7S4216C94v174Ev();
extern void _ZN7S4216C94v175Ev();
extern void _ZN7S4216C94v176Ev();
extern void _ZN7S4216C94v177Ev();
extern void _ZN7S4216C94v178Ev();
extern void _ZN7S4216C94v179Ev();
extern void _ZN7S4216C94v180Ev();
extern void _ZN7S4216C94v181Ev();
extern void _ZN7S4216C94v182Ev();
extern void _ZN7S4216C94v183Ev();
extern void _ZN7S4216C94v184Ev();
extern void _ZN7S4216C94v185Ev();
extern void _ZN7S4216C94v186Ev();
extern void _ZN7S4216C94v187Ev();
extern void _ZN7S4216C94v188Ev();
extern void _ZN7S4216C94v189Ev();
extern void _ZN7S4216C94v190Ev();
extern void _ZN7S4216C94v191Ev();
extern void _ZN7S4216C94v192Ev();
extern void _ZN7S4216C94v193Ev();
extern void _ZN7S4216C94v194Ev();
extern void _ZN7S4216C94v195Ev();
extern void _ZN7S4216C94v196Ev();
extern void _ZN7S4216C94v197Ev();
extern void _ZN7S4216C94v198Ev();
extern void _ZN7S4216C94v199Ev();
extern void _ZN7S4216C94v200Ev();
extern void _ZN7S4216C94v201Ev();
extern void _ZN7S4216C94v202Ev();
extern void _ZN7S4216C94v203Ev();
extern void _ZN7S4216C94v204Ev();
static  VTBL_ENTRY vtc_S4216C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4216C9[0]),
  (VTBL_ENTRY)&_ZN7S4216C9D1Ev,
  (VTBL_ENTRY)&_ZN7S4216C9D0Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v125Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v126Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v127Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v128Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v129Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v130Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v131Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v132Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v133Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v134Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v135Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v136Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v137Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v138Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v139Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v140Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v141Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v142Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v143Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v144Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v145Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v146Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v147Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v148Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v149Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v150Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v151Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v152Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v153Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v154Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v155Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v156Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v157Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v158Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v159Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v160Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v161Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v162Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v163Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v164Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v165Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v166Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v167Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v168Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v169Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v170Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v171Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v172Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v173Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v174Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v175Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v176Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v177Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v178Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v179Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v180Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v181Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v182Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v183Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v184Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v185Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v186Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v187Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v188Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v189Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v190Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v191Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v192Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v193Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v194Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v195Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v196Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v197Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v198Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v199Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v200Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v201Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v202Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v203Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v204Ev,
};
extern VTBL_ENTRY _ZTI7S4216C9[];
extern  VTBL_ENTRY _ZTV7S4216C9[];
Class_Descriptor cd_S4216C9 = {  "S4216C9", // class name
  0,0,//no base classes
  &(vtc_S4216C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4216C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4216C9),84, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C10_nt  {
  virtual  ~S4216C10_nt(); // _ZN11S4216C10_ntD1Ev
  virtual void  v205(); // _ZN11S4216C10_nt4v205Ev
  S4216C10_nt(); // tgen
};
//SIG(-1 S4216C10_nt) C1{ vd v1}


 S4216C10_nt ::~S4216C10_nt(){ note_dtor("S4216C10_nt", this);}
void  S4216C10_nt ::v205(){vfunc_called(this, "_ZN11S4216C10_nt4v205Ev");}
S4216C10_nt ::S4216C10_nt(){ note_ctor("S4216C10_nt", this);} // tgen

//skip512 S4216C10_nt

#else // __cplusplus

extern void _ZN11S4216C10_ntC1Ev();
extern void _ZN11S4216C10_ntD1Ev();
Name_Map name_map_S4216C10_nt[] = {
  NSPAIR(_ZN11S4216C10_ntC1Ev),
  NSPAIR(_ZN11S4216C10_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S4216C10_nt[];
extern void _ZN11S4216C10_ntD1Ev();
extern void _ZN11S4216C10_ntD0Ev();
extern void _ZN11S4216C10_nt4v205Ev();
static  VTBL_ENTRY vtc_S4216C10_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S4216C10_nt[0]),
  (VTBL_ENTRY)&_ZN11S4216C10_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S4216C10_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S4216C10_nt4v205Ev,
};
extern VTBL_ENTRY _ZTI11S4216C10_nt[];
VTBL_ENTRY *P__ZTI11S4216C10_nt = _ZTI11S4216C10_nt; 
extern  VTBL_ENTRY _ZTV11S4216C10_nt[];
Class_Descriptor cd_S4216C10_nt = {  "S4216C10_nt", // class name
  0,0,//no base classes
  &(vtc_S4216C10_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S4216C10_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S4216C10_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C15  {
  void  mf4216c15(); // _ZN8S4216C159mf4216c15Ev
};
//SIG(-1 S4216C15) C1{ m}


void  S4216C15 ::mf4216c15(){}

static void Test_S4216C15()
{
  {
    init_simple_test("S4216C15");
    S4216C15 lv;
    check2(sizeof(lv), 1, "sizeof(S4216C15)");
    check2(__alignof__(lv), 1, "__alignof__(S4216C15)");
  }
}
static Arrange_To_Call_Me vS4216C15(Test_S4216C15, "S4216C15", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C13_nt  {
  void *s4216c13f0;
  int s4216c13f1;
  ::S4216C5_nt s4216c13f2;
  ::S4216C15 s4216c13f3;
  void  mf4216c13(); // _ZN11S4216C13_nt9mf4216c13Ev
};
//SIG(-1 S4216C13_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S4216C13_nt ::mf4216c13(){}

//skip512 S4216C13_nt

#else // __cplusplus

Class_Descriptor cd_S4216C13_nt = {  "S4216C13_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C12_nt  : S4216C13_nt {
};
//SIG(-1 S4216C12_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S4216C12_nt

#else // __cplusplus

extern Class_Descriptor cd_S4216C13_nt;
static Base_Class bases_S4216C12_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C13_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C11  {
  ::S4216C12_nt s4216c11f0;
  void  mf4216c11(); // _ZN8S4216C119mf4216c11Ev
  virtual  ~S4216C11(); // _ZN8S4216C11D1Ev
  S4216C11(); // tgen
};
//SIG(-1 S4216C11) C1{ vd m FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}}}


void  S4216C11 ::mf4216c11(){}
 S4216C11 ::~S4216C11(){ note_dtor("S4216C11", this);}
S4216C11 ::S4216C11(){ note_ctor("S4216C11", this);} // tgen

static void Test_S4216C11()
{
  extern Class_Descriptor cd_S4216C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S4216C11, buf);
    S4216C11 *dp, &lv = *(dp=new (buf) S4216C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S4216C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C11)");
    check_field_offset(lv, s4216c11f0, ABISELECT(8,4), "S4216C11.s4216c11f0");
    test_class_info(&lv, &cd_S4216C11);
    dp->~S4216C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C11(Test_S4216C11, "S4216C11", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S4216C11C1Ev();
extern void _ZN8S4216C11D1Ev();
Name_Map name_map_S4216C11[] = {
  NSPAIR(_ZN8S4216C11C1Ev),
  NSPAIR(_ZN8S4216C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4216C11[];
extern void _ZN8S4216C11D1Ev();
extern void _ZN8S4216C11D0Ev();
static  VTBL_ENTRY vtc_S4216C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C11[0]),
  (VTBL_ENTRY)&_ZN8S4216C11D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C11D0Ev,
};
extern VTBL_ENTRY _ZTI8S4216C11[];
extern  VTBL_ENTRY _ZTV8S4216C11[];
Class_Descriptor cd_S4216C11 = {  "S4216C11", // class name
  0,0,//no base classes
  &(vtc_S4216C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S4216C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4216C11),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C18_nt  {
  int s4216c18f0;
  char s4216c18f1[3];
  virtual  ~S4216C18_nt(); // _ZN11S4216C18_ntD1Ev
  virtual void  v206(); // _ZN11S4216C18_nt4v206Ev
  S4216C18_nt(); // tgen
};
//SIG(-1 S4216C18_nt) C1{ vd v1 Fi Fc[3]}


 S4216C18_nt ::~S4216C18_nt(){ note_dtor("S4216C18_nt", this);}
void  S4216C18_nt ::v206(){vfunc_called(this, "_ZN11S4216C18_nt4v206Ev");}
S4216C18_nt ::S4216C18_nt(){ note_ctor("S4216C18_nt", this);} // tgen

//skip512 S4216C18_nt

#else // __cplusplus

extern void _ZN11S4216C18_ntC1Ev();
extern void _ZN11S4216C18_ntD1Ev();
Name_Map name_map_S4216C18_nt[] = {
  NSPAIR(_ZN11S4216C18_ntC1Ev),
  NSPAIR(_ZN11S4216C18_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S4216C18_nt[];
extern void _ZN11S4216C18_ntD1Ev();
extern void _ZN11S4216C18_ntD0Ev();
extern void _ZN11S4216C18_nt4v206Ev();
static  VTBL_ENTRY vtc_S4216C18_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S4216C18_nt[0]),
  (VTBL_ENTRY)&_ZN11S4216C18_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S4216C18_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S4216C18_nt4v206Ev,
};
extern VTBL_ENTRY _ZTI11S4216C18_nt[];
VTBL_ENTRY *P__ZTI11S4216C18_nt = _ZTI11S4216C18_nt; 
extern  VTBL_ENTRY _ZTV11S4216C18_nt[];
Class_Descriptor cd_S4216C18_nt = {  "S4216C18_nt", // class name
  0,0,//no base classes
  &(vtc_S4216C18_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI11S4216C18_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S4216C18_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C17  : S4216C18_nt {
  void *s4216c17f0[2];
  int s4216c17f1;
  virtual  ~S4216C17(); // _ZN8S4216C17D1Ev
  virtual void  v207(); // _ZN8S4216C174v207Ev
  virtual void  v208(); // _ZN8S4216C174v208Ev
  virtual void  v209(); // _ZN8S4216C174v209Ev
  virtual void  v210(); // _ZN8S4216C174v210Ev
  virtual void  v211(); // _ZN8S4216C174v211Ev
  virtual void  v212(); // _ZN8S4216C174v212Ev
  virtual void  v213(); // _ZN8S4216C174v213Ev
  S4216C17(); // tgen
};
//SIG(-1 S4216C17) C1{ BC2{ vd v8 Fi Fc[3]} vd v1 v2 v3 v4 v5 v6 v7 Fp[2] Fi}


 S4216C17 ::~S4216C17(){ note_dtor("S4216C17", this);}
void  S4216C17 ::v207(){vfunc_called(this, "_ZN8S4216C174v207Ev");}
void  S4216C17 ::v208(){vfunc_called(this, "_ZN8S4216C174v208Ev");}
void  S4216C17 ::v209(){vfunc_called(this, "_ZN8S4216C174v209Ev");}
void  S4216C17 ::v210(){vfunc_called(this, "_ZN8S4216C174v210Ev");}
void  S4216C17 ::v211(){vfunc_called(this, "_ZN8S4216C174v211Ev");}
void  S4216C17 ::v212(){vfunc_called(this, "_ZN8S4216C174v212Ev");}
void  S4216C17 ::v213(){vfunc_called(this, "_ZN8S4216C174v213Ev");}
S4216C17 ::S4216C17(){ note_ctor("S4216C17", this);} // tgen

static void Test_S4216C17()
{
  extern Class_Descriptor cd_S4216C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S4216C17, buf);
    S4216C17 *dp, &lv = *(dp=new (buf) S4216C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S4216C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C17)");
    check_base_class_offset(lv, (S4216C18_nt*), 0, "S4216C17");
    check_field_offset(lv, s4216c17f0, ABISELECT(16,12), "S4216C17.s4216c17f0");
    check_field_offset(lv, s4216c17f1, ABISELECT(32,20), "S4216C17.s4216c17f1");
    test_class_info(&lv, &cd_S4216C17);
    dp->~S4216C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C17(Test_S4216C17, "S4216C17", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN8S4216C17C1Ev();
extern void _ZN8S4216C17D1Ev();
Name_Map name_map_S4216C17[] = {
  NSPAIR(_ZN8S4216C17C1Ev),
  NSPAIR(_ZN8S4216C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C18_nt;
extern VTBL_ENTRY _ZTI11S4216C18_nt[];
extern  VTBL_ENTRY _ZTV11S4216C18_nt[];
static Base_Class bases_S4216C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C18_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C17[];
extern void _ZN8S4216C17D1Ev();
extern void _ZN8S4216C17D0Ev();
extern void _ZN11S4216C18_nt4v206Ev();
extern void _ZN8S4216C174v207Ev();
extern void _ZN8S4216C174v208Ev();
extern void _ZN8S4216C174v209Ev();
extern void _ZN8S4216C174v210Ev();
extern void _ZN8S4216C174v211Ev();
extern void _ZN8S4216C174v212Ev();
extern void _ZN8S4216C174v213Ev();
static  VTBL_ENTRY vtc_S4216C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C17[0]),
  (VTBL_ENTRY)&_ZN8S4216C17D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C17D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C18_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v207Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v208Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v209Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v210Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v211Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v212Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v213Ev,
};
extern VTBL_ENTRY _ZTI8S4216C17[];
extern  VTBL_ENTRY _ZTV8S4216C17[];
Class_Descriptor cd_S4216C17 = {  "S4216C17", // class name
  bases_S4216C17, 1,
  &(vtc_S4216C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S4216C17),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C17),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C19  {
  virtual  ~S4216C19(); // _ZN8S4216C19D1Ev
  virtual void  v214(); // _ZN8S4216C194v214Ev
  virtual void  v215(); // _ZN8S4216C194v215Ev
  virtual void  v216(); // _ZN8S4216C194v216Ev
  S4216C19(); // tgen
};
//SIG(-1 S4216C19) C1{ vd v1 v2 v3}


 S4216C19 ::~S4216C19(){ note_dtor("S4216C19", this);}
void  S4216C19 ::v214(){vfunc_called(this, "_ZN8S4216C194v214Ev");}
void  S4216C19 ::v215(){vfunc_called(this, "_ZN8S4216C194v215Ev");}
void  S4216C19 ::v216(){vfunc_called(this, "_ZN8S4216C194v216Ev");}
S4216C19 ::S4216C19(){ note_ctor("S4216C19", this);} // tgen

static void Test_S4216C19()
{
  extern Class_Descriptor cd_S4216C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4216C19, buf);
    S4216C19 *dp, &lv = *(dp=new (buf) S4216C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4216C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C19)");
    test_class_info(&lv, &cd_S4216C19);
    dp->~S4216C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C19(Test_S4216C19, "S4216C19", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S4216C19C1Ev();
extern void _ZN8S4216C19D1Ev();
Name_Map name_map_S4216C19[] = {
  NSPAIR(_ZN8S4216C19C1Ev),
  NSPAIR(_ZN8S4216C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4216C19[];
extern void _ZN8S4216C19D1Ev();
extern void _ZN8S4216C19D0Ev();
extern void _ZN8S4216C194v214Ev();
extern void _ZN8S4216C194v215Ev();
extern void _ZN8S4216C194v216Ev();
static  VTBL_ENTRY vtc_S4216C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C19[0]),
  (VTBL_ENTRY)&_ZN8S4216C19D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C19D0Ev,
  (VTBL_ENTRY)&_ZN8S4216C194v214Ev,
  (VTBL_ENTRY)&_ZN8S4216C194v215Ev,
  (VTBL_ENTRY)&_ZN8S4216C194v216Ev,
};
extern VTBL_ENTRY _ZTI8S4216C19[];
extern  VTBL_ENTRY _ZTV8S4216C19[];
Class_Descriptor cd_S4216C19 = {  "S4216C19", // class name
  0,0,//no base classes
  &(vtc_S4216C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S4216C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4216C19),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C16  : S4216C17 , S4216C19 {
  void *s4216c16f0;
  virtual  ~S4216C16(); // _ZN8S4216C16D1Ev
  virtual void  v217(); // _ZN8S4216C164v217Ev
  virtual void  v218(); // _ZN8S4216C164v218Ev
  virtual void  v219(); // _ZN8S4216C164v219Ev
  virtual void  v220(); // _ZN8S4216C164v220Ev
  virtual void  v221(); // _ZN8S4216C164v221Ev
  virtual void  v222(); // _ZN8S4216C164v222Ev
  virtual void  v223(); // _ZN8S4216C164v223Ev
  virtual void  v224(); // _ZN8S4216C164v224Ev
  virtual void  v225(); // _ZN8S4216C164v225Ev
  virtual void  v226(); // _ZN8S4216C164v226Ev
  S4216C16(); // tgen
};
//SIG(-1 S4216C16) C1{ BC2{ BC3{ vd v11 Fi Fc[3]} vd v12 v13 v14 v15 v16 v17 v18 Fp[2] Fi} BC4{ vd v19 v20 v21} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S4216C16 ::~S4216C16(){ note_dtor("S4216C16", this);}
void  S4216C16 ::v217(){vfunc_called(this, "_ZN8S4216C164v217Ev");}
void  S4216C16 ::v218(){vfunc_called(this, "_ZN8S4216C164v218Ev");}
void  S4216C16 ::v219(){vfunc_called(this, "_ZN8S4216C164v219Ev");}
void  S4216C16 ::v220(){vfunc_called(this, "_ZN8S4216C164v220Ev");}
void  S4216C16 ::v221(){vfunc_called(this, "_ZN8S4216C164v221Ev");}
void  S4216C16 ::v222(){vfunc_called(this, "_ZN8S4216C164v222Ev");}
void  S4216C16 ::v223(){vfunc_called(this, "_ZN8S4216C164v223Ev");}
void  S4216C16 ::v224(){vfunc_called(this, "_ZN8S4216C164v224Ev");}
void  S4216C16 ::v225(){vfunc_called(this, "_ZN8S4216C164v225Ev");}
void  S4216C16 ::v226(){vfunc_called(this, "_ZN8S4216C164v226Ev");}
S4216C16 ::S4216C16(){ note_ctor("S4216C16", this);} // tgen

static void Test_S4216C16()
{
  extern Class_Descriptor cd_S4216C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S4216C16, buf);
    S4216C16 *dp, &lv = *(dp=new (buf) S4216C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S4216C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C16)");
    check_base_class_offset(lv, (S4216C18_nt*)(S4216C17*), 0, "S4216C16");
    check_base_class_offset(lv, (S4216C17*), 0, "S4216C16");
    check_base_class_offset(lv, (S4216C19*), ABISELECT(40,24), "S4216C16");
    check_field_offset(lv, s4216c16f0, ABISELECT(48,28), "S4216C16.s4216c16f0");
    test_class_info(&lv, &cd_S4216C16);
    dp->~S4216C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C16(Test_S4216C16, "S4216C16", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN8S4216C16C1Ev();
extern void _ZN8S4216C16D1Ev();
Name_Map name_map_S4216C16[] = {
  NSPAIR(_ZN8S4216C16C1Ev),
  NSPAIR(_ZN8S4216C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C18_nt;
extern VTBL_ENTRY _ZTI11S4216C18_nt[];
extern  VTBL_ENTRY _ZTV11S4216C18_nt[];
extern Class_Descriptor cd_S4216C17;
extern VTBL_ENTRY _ZTI8S4216C17[];
extern  VTBL_ENTRY _ZTV8S4216C17[];
extern Class_Descriptor cd_S4216C19;
extern VTBL_ENTRY _ZTI8S4216C19[];
extern  VTBL_ENTRY _ZTV8S4216C19[];
static Base_Class bases_S4216C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C18_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4216C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C19,    ABISELECT(40,24), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C16[];
extern void _ZN8S4216C16D1Ev();
extern void _ZN8S4216C16D0Ev();
extern void _ZN11S4216C18_nt4v206Ev();
extern void _ZN8S4216C174v207Ev();
extern void _ZN8S4216C174v208Ev();
extern void _ZN8S4216C174v209Ev();
extern void _ZN8S4216C174v210Ev();
extern void _ZN8S4216C174v211Ev();
extern void _ZN8S4216C174v212Ev();
extern void _ZN8S4216C174v213Ev();
extern void _ZN8S4216C164v217Ev();
extern void _ZN8S4216C164v218Ev();
extern void _ZN8S4216C164v219Ev();
extern void _ZN8S4216C164v220Ev();
extern void _ZN8S4216C164v221Ev();
extern void _ZN8S4216C164v222Ev();
extern void _ZN8S4216C164v223Ev();
extern void _ZN8S4216C164v224Ev();
extern void _ZN8S4216C164v225Ev();
extern void _ZN8S4216C164v226Ev();
extern void ABISELECT(_ZThn40_N8S4216C16D1Ev,_ZThn24_N8S4216C16D1Ev)();
extern void ABISELECT(_ZThn40_N8S4216C16D0Ev,_ZThn24_N8S4216C16D0Ev)();
extern void _ZN8S4216C194v214Ev();
extern void _ZN8S4216C194v215Ev();
extern void _ZN8S4216C194v216Ev();
static  VTBL_ENTRY vtc_S4216C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C16[0]),
  (VTBL_ENTRY)&_ZN8S4216C16D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C16D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C18_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v207Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v208Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v209Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v210Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v211Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v212Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v213Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v217Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v218Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v219Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v220Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v221Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v222Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v223Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v224Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v225Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v226Ev,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S4216C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S4216C16D1Ev,_ZThn24_N8S4216C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S4216C16D0Ev,_ZThn24_N8S4216C16D0Ev),
  (VTBL_ENTRY)&_ZN8S4216C194v214Ev,
  (VTBL_ENTRY)&_ZN8S4216C194v215Ev,
  (VTBL_ENTRY)&_ZN8S4216C194v216Ev,
};
extern VTBL_ENTRY _ZTI8S4216C16[];
extern  VTBL_ENTRY _ZTV8S4216C16[];
Class_Descriptor cd_S4216C16 = {  "S4216C16", // class name
  bases_S4216C16, 3,
  &(vtc_S4216C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI8S4216C16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S4216C16),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C22_nt  {
  void *s4216c22f0;
  int s4216c22f1;
  ::S4216C15 s4216c22f2;
  void  mf4216c22(); // _ZN11S4216C22_nt9mf4216c22Ev
};
//SIG(-1 S4216C22_nt) C1{ m Fp Fi FC2{ m}}


void  S4216C22_nt ::mf4216c22(){}

//skip512 S4216C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C21  {
  int s4216c21f0[2];
  short s4216c21f1[2];
  int s4216c21f2[3];
  ::S4216C22_nt s4216c21f3;
  virtual  ~S4216C21(); // _ZN8S4216C21D1Ev
  virtual void  v227(); // _ZN8S4216C214v227Ev
  S4216C21(); // tgen
};
//SIG(-1 S4216C21) C1{ vd v1 Fi[2] Fs[2] Fi[3] FC2{ m Fp Fi FC3{ m}}}


 S4216C21 ::~S4216C21(){ note_dtor("S4216C21", this);}
void  S4216C21 ::v227(){vfunc_called(this, "_ZN8S4216C214v227Ev");}
S4216C21 ::S4216C21(){ note_ctor("S4216C21", this);} // tgen

static void Test_S4216C21()
{
  extern Class_Descriptor cd_S4216C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,11)];
    init_test(&cd_S4216C21, buf);
    S4216C21 *dp, &lv = *(dp=new (buf) S4216C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S4216C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C21)");
    check_field_offset(lv, s4216c21f0, ABISELECT(8,4), "S4216C21.s4216c21f0");
    check_field_offset(lv, s4216c21f1, ABISELECT(16,12), "S4216C21.s4216c21f1");
    check_field_offset(lv, s4216c21f2, ABISELECT(20,16), "S4216C21.s4216c21f2");
    check_field_offset(lv, s4216c21f3, ABISELECT(32,28), "S4216C21.s4216c21f3");
    test_class_info(&lv, &cd_S4216C21);
    dp->~S4216C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C21(Test_S4216C21, "S4216C21", ABISELECT(48,40));

#else // __cplusplus

extern void _ZN8S4216C21C1Ev();
extern void _ZN8S4216C21D1Ev();
Name_Map name_map_S4216C21[] = {
  NSPAIR(_ZN8S4216C21C1Ev),
  NSPAIR(_ZN8S4216C21D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4216C21[];
extern void _ZN8S4216C21D1Ev();
extern void _ZN8S4216C21D0Ev();
extern void _ZN8S4216C214v227Ev();
static  VTBL_ENTRY vtc_S4216C21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C21[0]),
  (VTBL_ENTRY)&_ZN8S4216C21D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C21D0Ev,
  (VTBL_ENTRY)&_ZN8S4216C214v227Ev,
};
extern VTBL_ENTRY _ZTI8S4216C21[];
extern  VTBL_ENTRY _ZTV8S4216C21[];
Class_Descriptor cd_S4216C21 = {  "S4216C21", // class name
  0,0,//no base classes
  &(vtc_S4216C21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,40), // object size
  NSPAIRA(_ZTI8S4216C21),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4216C21),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C24  {
  int s4216c24f0;
  virtual  ~S4216C24(); // _ZN8S4216C24D1Ev
  virtual void  v228(); // _ZN8S4216C244v228Ev
  S4216C24(); // tgen
};
//SIG(-1 S4216C24) C1{ vd v1 Fi}


 S4216C24 ::~S4216C24(){ note_dtor("S4216C24", this);}
void  S4216C24 ::v228(){vfunc_called(this, "_ZN8S4216C244v228Ev");}
S4216C24 ::S4216C24(){ note_ctor("S4216C24", this);} // tgen

static void Test_S4216C24()
{
  extern Class_Descriptor cd_S4216C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S4216C24, buf);
    S4216C24 *dp, &lv = *(dp=new (buf) S4216C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S4216C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C24)");
    check_field_offset(lv, s4216c24f0, ABISELECT(8,4), "S4216C24.s4216c24f0");
    test_class_info(&lv, &cd_S4216C24);
    dp->~S4216C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C24(Test_S4216C24, "S4216C24", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S4216C24C1Ev();
extern void _ZN8S4216C24D1Ev();
Name_Map name_map_S4216C24[] = {
  NSPAIR(_ZN8S4216C24C1Ev),
  NSPAIR(_ZN8S4216C24D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4216C24[];
extern void _ZN8S4216C24D1Ev();
extern void _ZN8S4216C24D0Ev();
extern void _ZN8S4216C244v228Ev();
static  VTBL_ENTRY vtc_S4216C24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C24[0]),
  (VTBL_ENTRY)&_ZN8S4216C24D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C24D0Ev,
  (VTBL_ENTRY)&_ZN8S4216C244v228Ev,
};
extern VTBL_ENTRY _ZTI8S4216C24[];
extern  VTBL_ENTRY _ZTV8S4216C24[];
Class_Descriptor cd_S4216C24 = {  "S4216C24", // class name
  0,0,//no base classes
  &(vtc_S4216C24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S4216C24),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4216C24),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C28_nt  {
  virtual  ~S4216C28_nt(); // _ZN11S4216C28_ntD1Ev
  virtual void  v232(); // _ZN11S4216C28_nt4v232Ev
  virtual void  v233(); // _ZN11S4216C28_nt4v233Ev
  S4216C28_nt(); // tgen
};
//SIG(-1 S4216C28_nt) C1{ vd v1 v2}


 S4216C28_nt ::~S4216C28_nt(){ note_dtor("S4216C28_nt", this);}
void  S4216C28_nt ::v232(){vfunc_called(this, "_ZN11S4216C28_nt4v232Ev");}
void  S4216C28_nt ::v233(){vfunc_called(this, "_ZN11S4216C28_nt4v233Ev");}
S4216C28_nt ::S4216C28_nt(){ note_ctor("S4216C28_nt", this);} // tgen

//skip512 S4216C28_nt

#else // __cplusplus

extern void _ZN11S4216C28_ntC1Ev();
extern void _ZN11S4216C28_ntD1Ev();
Name_Map name_map_S4216C28_nt[] = {
  NSPAIR(_ZN11S4216C28_ntC1Ev),
  NSPAIR(_ZN11S4216C28_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern void _ZN11S4216C28_ntD1Ev();
extern void _ZN11S4216C28_ntD0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
static  VTBL_ENTRY vtc_S4216C28_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S4216C28_nt[0]),
  (VTBL_ENTRY)&_ZN11S4216C28_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
};
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
VTBL_ENTRY *P__ZTI11S4216C28_nt = _ZTI11S4216C28_nt; 
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
Class_Descriptor cd_S4216C28_nt = {  "S4216C28_nt", // class name
  0,0,//no base classes
  &(vtc_S4216C28_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S4216C28_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S4216C28_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C27  : S4216C28_nt {
  char s4216c27f0[66];
  virtual  ~S4216C27(); // _ZN8S4216C27D1Ev
  virtual void  v229(); // _ZN8S4216C274v229Ev
  virtual void  v230(); // _ZN8S4216C274v230Ev
  virtual void  v231(); // _ZN8S4216C274v231Ev
  S4216C27(); // tgen
};
//SIG(-1 S4216C27) C1{ BC2{ vd v4 v5} vd v1 v2 v3 Fc[66]}


 S4216C27 ::~S4216C27(){ note_dtor("S4216C27", this);}
void  S4216C27 ::v229(){vfunc_called(this, "_ZN8S4216C274v229Ev");}
void  S4216C27 ::v230(){vfunc_called(this, "_ZN8S4216C274v230Ev");}
void  S4216C27 ::v231(){vfunc_called(this, "_ZN8S4216C274v231Ev");}
S4216C27 ::S4216C27(){ note_ctor("S4216C27", this);} // tgen

static void Test_S4216C27()
{
  extern Class_Descriptor cd_S4216C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,19)];
    init_test(&cd_S4216C27, buf);
    S4216C27 *dp, &lv = *(dp=new (buf) S4216C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,72), "sizeof(S4216C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C27)");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C27");
    check_field_offset(lv, s4216c27f0, ABISELECT(8,4), "S4216C27.s4216c27f0");
    test_class_info(&lv, &cd_S4216C27);
    dp->~S4216C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C27(Test_S4216C27, "S4216C27", ABISELECT(80,72));

#else // __cplusplus

extern void _ZN8S4216C27C1Ev();
extern void _ZN8S4216C27D1Ev();
Name_Map name_map_S4216C27[] = {
  NSPAIR(_ZN8S4216C27C1Ev),
  NSPAIR(_ZN8S4216C27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C27[];
extern void _ZN8S4216C27D1Ev();
extern void _ZN8S4216C27D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C274v229Ev();
extern void _ZN8S4216C274v230Ev();
extern void _ZN8S4216C274v231Ev();
static  VTBL_ENTRY vtc_S4216C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C27[0]),
  (VTBL_ENTRY)&_ZN8S4216C27D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C27D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C274v229Ev,
  (VTBL_ENTRY)&_ZN8S4216C274v230Ev,
  (VTBL_ENTRY)&_ZN8S4216C274v231Ev,
};
extern VTBL_ENTRY _ZTI8S4216C27[];
extern  VTBL_ENTRY _ZTV8S4216C27[];
Class_Descriptor cd_S4216C27 = {  "S4216C27", // class name
  bases_S4216C27, 1,
  &(vtc_S4216C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,72), // object size
  NSPAIRA(_ZTI8S4216C27),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C27),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C29  : S4216C28_nt {
  ::S4216C22_nt s4216c29f0;
  virtual  ~S4216C29(); // _ZN8S4216C29D1Ev
  virtual void  v234(); // _ZN8S4216C294v234Ev
  S4216C29(); // tgen
};
//SIG(-1 S4216C29) C1{ BC2{ vd v2 v3} vd v1 FC3{ m Fp Fi FC4{ m}}}


 S4216C29 ::~S4216C29(){ note_dtor("S4216C29", this);}
void  S4216C29 ::v234(){vfunc_called(this, "_ZN8S4216C294v234Ev");}
S4216C29 ::S4216C29(){ note_ctor("S4216C29", this);} // tgen

static void Test_S4216C29()
{
  extern Class_Descriptor cd_S4216C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S4216C29, buf);
    S4216C29 *dp, &lv = *(dp=new (buf) S4216C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S4216C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C29)");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C29");
    check_field_offset(lv, s4216c29f0, ABISELECT(8,4), "S4216C29.s4216c29f0");
    test_class_info(&lv, &cd_S4216C29);
    dp->~S4216C29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C29(Test_S4216C29, "S4216C29", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S4216C29C1Ev();
extern void _ZN8S4216C29D1Ev();
Name_Map name_map_S4216C29[] = {
  NSPAIR(_ZN8S4216C29C1Ev),
  NSPAIR(_ZN8S4216C29D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C29[];
extern void _ZN8S4216C29D1Ev();
extern void _ZN8S4216C29D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C294v234Ev();
static  VTBL_ENTRY vtc_S4216C29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C29[0]),
  (VTBL_ENTRY)&_ZN8S4216C29D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C29D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C294v234Ev,
};
extern VTBL_ENTRY _ZTI8S4216C29[];
extern  VTBL_ENTRY _ZTV8S4216C29[];
Class_Descriptor cd_S4216C29 = {  "S4216C29", // class name
  bases_S4216C29, 1,
  &(vtc_S4216C29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S4216C29),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C29),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C32  {
  int s4216c32f0;
  virtual  ~S4216C32(); // _ZN8S4216C32D1Ev
  virtual void  v237(); // _ZN8S4216C324v237Ev
  S4216C32(); // tgen
};
//SIG(-1 S4216C32) C1{ vd v1 Fi}


 S4216C32 ::~S4216C32(){ note_dtor("S4216C32", this);}
void  S4216C32 ::v237(){vfunc_called(this, "_ZN8S4216C324v237Ev");}
S4216C32 ::S4216C32(){ note_ctor("S4216C32", this);} // tgen

static void Test_S4216C32()
{
  extern Class_Descriptor cd_S4216C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S4216C32, buf);
    S4216C32 *dp, &lv = *(dp=new (buf) S4216C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S4216C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C32)");
    check_field_offset(lv, s4216c32f0, ABISELECT(8,4), "S4216C32.s4216c32f0");
    test_class_info(&lv, &cd_S4216C32);
    dp->~S4216C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C32(Test_S4216C32, "S4216C32", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S4216C32C1Ev();
extern void _ZN8S4216C32D1Ev();
Name_Map name_map_S4216C32[] = {
  NSPAIR(_ZN8S4216C32C1Ev),
  NSPAIR(_ZN8S4216C32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4216C32[];
extern void _ZN8S4216C32D1Ev();
extern void _ZN8S4216C32D0Ev();
extern void _ZN8S4216C324v237Ev();
static  VTBL_ENTRY vtc_S4216C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C32[0]),
  (VTBL_ENTRY)&_ZN8S4216C32D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C32D0Ev,
  (VTBL_ENTRY)&_ZN8S4216C324v237Ev,
};
extern VTBL_ENTRY _ZTI8S4216C32[];
extern  VTBL_ENTRY _ZTV8S4216C32[];
Class_Descriptor cd_S4216C32 = {  "S4216C32", // class name
  0,0,//no base classes
  &(vtc_S4216C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S4216C32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4216C32),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C33  {
  short s4216c33f0[2];
  char s4216c33f1[6];
  short s4216c33f2[2];
  char s4216c33f3[6];
  ::S4216C22_nt s4216c33f4;
  virtual  ~S4216C33(); // _ZN8S4216C33D1Ev
  virtual void  v238(); // _ZN8S4216C334v238Ev
  S4216C33(); // tgen
};
//SIG(-1 S4216C33) C1{ vd v1 Fs[2] Fc[6] Fs[2] Fc[6] FC2{ m Fp Fi FC3{ m}}}


 S4216C33 ::~S4216C33(){ note_dtor("S4216C33", this);}
void  S4216C33 ::v238(){vfunc_called(this, "_ZN8S4216C334v238Ev");}
S4216C33 ::S4216C33(){ note_ctor("S4216C33", this);} // tgen

static void Test_S4216C33()
{
  extern Class_Descriptor cd_S4216C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd_S4216C33, buf);
    S4216C33 *dp, &lv = *(dp=new (buf) S4216C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(S4216C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C33)");
    check_field_offset(lv, s4216c33f0, ABISELECT(8,4), "S4216C33.s4216c33f0");
    check_field_offset(lv, s4216c33f1, ABISELECT(12,8), "S4216C33.s4216c33f1");
    check_field_offset(lv, s4216c33f2, ABISELECT(18,14), "S4216C33.s4216c33f2");
    check_field_offset(lv, s4216c33f3, ABISELECT(22,18), "S4216C33.s4216c33f3");
    check_field_offset(lv, s4216c33f4, ABISELECT(32,24), "S4216C33.s4216c33f4");
    test_class_info(&lv, &cd_S4216C33);
    dp->~S4216C33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C33(Test_S4216C33, "S4216C33", ABISELECT(48,36));

#else // __cplusplus

extern void _ZN8S4216C33C1Ev();
extern void _ZN8S4216C33D1Ev();
Name_Map name_map_S4216C33[] = {
  NSPAIR(_ZN8S4216C33C1Ev),
  NSPAIR(_ZN8S4216C33D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4216C33[];
extern void _ZN8S4216C33D1Ev();
extern void _ZN8S4216C33D0Ev();
extern void _ZN8S4216C334v238Ev();
static  VTBL_ENTRY vtc_S4216C33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C33[0]),
  (VTBL_ENTRY)&_ZN8S4216C33D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C33D0Ev,
  (VTBL_ENTRY)&_ZN8S4216C334v238Ev,
};
extern VTBL_ENTRY _ZTI8S4216C33[];
extern  VTBL_ENTRY _ZTV8S4216C33[];
Class_Descriptor cd_S4216C33 = {  "S4216C33", // class name
  0,0,//no base classes
  &(vtc_S4216C33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,36), // object size
  NSPAIRA(_ZTI8S4216C33),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4216C33),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C34  : S4216C28_nt {
  ::S4216C22_nt s4216c34f0;
  ::S4216C22_nt s4216c34f1;
  ::S4216C22_nt s4216c34f2;
  virtual  ~S4216C34(); // _ZN8S4216C34D1Ev
  virtual void  v239(); // _ZN8S4216C344v239Ev
  S4216C34(); // tgen
};
//SIG(-1 S4216C34) C1{ BC2{ vd v2 v3} vd v1 FC3{ m Fp Fi FC4{ m}} FC3 FC3}


 S4216C34 ::~S4216C34(){ note_dtor("S4216C34", this);}
void  S4216C34 ::v239(){vfunc_called(this, "_ZN8S4216C344v239Ev");}
S4216C34 ::S4216C34(){ note_ctor("S4216C34", this);} // tgen

static void Test_S4216C34()
{
  extern Class_Descriptor cd_S4216C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,11)];
    init_test(&cd_S4216C34, buf);
    S4216C34 *dp, &lv = *(dp=new (buf) S4216C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(S4216C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C34)");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C34");
    check_field_offset(lv, s4216c34f0, ABISELECT(8,4), "S4216C34.s4216c34f0");
    check_field_offset(lv, s4216c34f1, ABISELECT(24,16), "S4216C34.s4216c34f1");
    check_field_offset(lv, s4216c34f2, ABISELECT(40,28), "S4216C34.s4216c34f2");
    test_class_info(&lv, &cd_S4216C34);
    dp->~S4216C34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C34(Test_S4216C34, "S4216C34", ABISELECT(56,40));

#else // __cplusplus

extern void _ZN8S4216C34C1Ev();
extern void _ZN8S4216C34D1Ev();
Name_Map name_map_S4216C34[] = {
  NSPAIR(_ZN8S4216C34C1Ev),
  NSPAIR(_ZN8S4216C34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C34[];
extern void _ZN8S4216C34D1Ev();
extern void _ZN8S4216C34D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C344v239Ev();
static  VTBL_ENTRY vtc_S4216C34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C34[0]),
  (VTBL_ENTRY)&_ZN8S4216C34D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C34D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C344v239Ev,
};
extern VTBL_ENTRY _ZTI8S4216C34[];
extern  VTBL_ENTRY _ZTV8S4216C34[];
Class_Descriptor cd_S4216C34 = {  "S4216C34", // class name
  bases_S4216C34, 1,
  &(vtc_S4216C34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,40), // object size
  NSPAIRA(_ZTI8S4216C34),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C34),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C36  {
  int s4216c36f0;
  ::S4216C34 s4216c36f1;
  int s4216c36f2;
  void  mf4216c36(); // _ZN8S4216C369mf4216c36Ev
  virtual  ~S4216C36(); // _ZN8S4216C36D1Ev
  S4216C36(); // tgen
};
//SIG(-1 S4216C36) C1{ vd m Fi FC2{ BC3{ vd v2 v3} vd v1 FC4{ m Fp Fi FC5{ m}} FC4 FC4} Fi}


void  S4216C36 ::mf4216c36(){}
 S4216C36 ::~S4216C36(){ note_dtor("S4216C36", this);}
S4216C36 ::S4216C36(){ note_ctor("S4216C36", this);} // tgen

static void Test_S4216C36()
{
  extern Class_Descriptor cd_S4216C36;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,14)];
    init_test(&cd_S4216C36, buf);
    S4216C36 *dp, &lv = *(dp=new (buf) S4216C36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,52), "sizeof(S4216C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C36)");
    check_field_offset(lv, s4216c36f0, ABISELECT(8,4), "S4216C36.s4216c36f0");
    check_field_offset(lv, s4216c36f1, ABISELECT(16,8), "S4216C36.s4216c36f1");
    check_field_offset(lv, s4216c36f2, ABISELECT(72,48), "S4216C36.s4216c36f2");
    test_class_info(&lv, &cd_S4216C36);
    dp->~S4216C36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C36(Test_S4216C36, "S4216C36", ABISELECT(80,52));

#else // __cplusplus

extern void _ZN8S4216C36C1Ev();
extern void _ZN8S4216C36D1Ev();
Name_Map name_map_S4216C36[] = {
  NSPAIR(_ZN8S4216C36C1Ev),
  NSPAIR(_ZN8S4216C36D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4216C36[];
extern void _ZN8S4216C36D1Ev();
extern void _ZN8S4216C36D0Ev();
static  VTBL_ENTRY vtc_S4216C36[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C36[0]),
  (VTBL_ENTRY)&_ZN8S4216C36D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C36D0Ev,
};
extern VTBL_ENTRY _ZTI8S4216C36[];
extern  VTBL_ENTRY _ZTV8S4216C36[];
Class_Descriptor cd_S4216C36 = {  "S4216C36", // class name
  0,0,//no base classes
  &(vtc_S4216C36[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,52), // object size
  NSPAIRA(_ZTI8S4216C36),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4216C36),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C39  {
  void  mf4216c39(); // _ZN8S4216C399mf4216c39Ev
};
//SIG(-1 S4216C39) C1{ m}


void  S4216C39 ::mf4216c39(){}

static void Test_S4216C39()
{
  {
    init_simple_test("S4216C39");
    S4216C39 lv;
    check2(sizeof(lv), 1, "sizeof(S4216C39)");
    check2(__alignof__(lv), 1, "__alignof__(S4216C39)");
  }
}
static Arrange_To_Call_Me vS4216C39(Test_S4216C39, "S4216C39", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C38  {
  void *s4216c38f0;
  int s4216c38f1[2];
  ::S4216C39 s4216c38f2;
  void  mf4216c38(); // _ZN8S4216C389mf4216c38Ev
};
//SIG(-1 S4216C38) C1{ m Fp Fi[2] FC2{ m}}


void  S4216C38 ::mf4216c38(){}

static void Test_S4216C38()
{
  {
    init_simple_test("S4216C38");
    S4216C38 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S4216C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C38)");
    check_field_offset(lv, s4216c38f0, 0, "S4216C38.s4216c38f0");
    check_field_offset(lv, s4216c38f1, ABISELECT(8,4), "S4216C38.s4216c38f1");
    check_field_offset(lv, s4216c38f2, ABISELECT(16,12), "S4216C38.s4216c38f2");
  }
}
static Arrange_To_Call_Me vS4216C38(Test_S4216C38, "S4216C38", ABISELECT(24,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S4216C38[];
VTBL_ENTRY *P__ZTI8S4216C38 = _ZTI8S4216C38; 
Class_Descriptor cd_S4216C38 = {  "S4216C38", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S4216C38),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C37  : S4216C38 , S4216C28_nt {
  virtual  ~S4216C37(); // _ZN8S4216C37D1Ev
  virtual void  v242(); // _ZN8S4216C374v242Ev
  virtual void  v243(); // _ZN8S4216C374v243Ev
  S4216C37(); // tgen
};
//SIG(-1 S4216C37) C1{ BC2{ m Fp Fi[2] FC3{ m}} BC4{ vd v3 v4} vd v1 v2}


 S4216C37 ::~S4216C37(){ note_dtor("S4216C37", this);}
void  S4216C37 ::v242(){vfunc_called(this, "_ZN8S4216C374v242Ev");}
void  S4216C37 ::v243(){vfunc_called(this, "_ZN8S4216C374v243Ev");}
S4216C37 ::S4216C37(){ note_ctor("S4216C37", this);} // tgen

static void Test_S4216C37()
{
  extern Class_Descriptor cd_S4216C37;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S4216C37, buf);
    S4216C37 *dp, &lv = *(dp=new (buf) S4216C37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S4216C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C37)");
    check_base_class_offset(lv, (S4216C38*), ABISELECT(8,4), "S4216C37");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C37");
    test_class_info(&lv, &cd_S4216C37);
    dp->~S4216C37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C37(Test_S4216C37, "S4216C37", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN8S4216C37C1Ev();
extern void _ZN8S4216C37D1Ev();
Name_Map name_map_S4216C37[] = {
  NSPAIR(_ZN8S4216C37C1Ev),
  NSPAIR(_ZN8S4216C37D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C38;
extern VTBL_ENTRY _ZTI8S4216C38[];
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C38,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C37[];
extern void _ZN8S4216C37D1Ev();
extern void _ZN8S4216C37D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C374v242Ev();
extern void _ZN8S4216C374v243Ev();
static  VTBL_ENTRY vtc_S4216C37[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C37[0]),
  (VTBL_ENTRY)&_ZN8S4216C37D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C37D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C374v242Ev,
  (VTBL_ENTRY)&_ZN8S4216C374v243Ev,
};
extern VTBL_ENTRY _ZTI8S4216C37[];
extern  VTBL_ENTRY _ZTV8S4216C37[];
Class_Descriptor cd_S4216C37 = {  "S4216C37", // class name
  bases_S4216C37, 2,
  &(vtc_S4216C37[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S4216C37),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S4216C37),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C35  : S4216C28_nt {
  ::S4216C33 s4216c35f0;
  ::S4216C22_nt s4216c35f1;
  ::S4216C22_nt s4216c35f2;
  ::S4216C22_nt s4216c35f3;
  ::S4216C36 s4216c35f4;
  char s4216c35f5;
  ::S4216C37 s4216c35f6;
  ::S4216C22_nt s4216c35f7;
  virtual  ~S4216C35(); // _ZN8S4216C35D1Ev
  virtual void  v240(); // _ZN8S4216C354v240Ev
  virtual void  v241(); // _ZN8S4216C354v241Ev
  S4216C35(); // tgen
};
//SIG(-1 S4216C35) C1{ BC2{ vd v3 v4} vd v1 v2 FC3{ vd v5 Fs[2] Fc[6] Fs[2] Fc[6] FC4{ m Fp Fi FC5{ m}}} FC4 FC4 FC4 FC6{ vd m Fi FC7{ BC2 vd v6 FC4 FC4 FC4} Fi} Fc FC8{ BC9{ m Fp Fi[2] FC10{ m}} BC2 vd v7 v8} FC4}


 S4216C35 ::~S4216C35(){ note_dtor("S4216C35", this);}
void  S4216C35 ::v240(){vfunc_called(this, "_ZN8S4216C354v240Ev");}
void  S4216C35 ::v241(){vfunc_called(this, "_ZN8S4216C354v241Ev");}
S4216C35 ::S4216C35(){ note_ctor("S4216C35", this);} // tgen

static void Test_S4216C35()
{
  extern Class_Descriptor cd_S4216C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(31,42)];
    init_test(&cd_S4216C35, buf);
    S4216C35 *dp, &lv = *(dp=new (buf) S4216C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,164), "sizeof(S4216C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C35)");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C35");
    check_field_offset(lv, s4216c35f0, ABISELECT(8,4), "S4216C35.s4216c35f0");
    check_field_offset(lv, s4216c35f1, ABISELECT(56,40), "S4216C35.s4216c35f1");
    check_field_offset(lv, s4216c35f2, ABISELECT(72,52), "S4216C35.s4216c35f2");
    check_field_offset(lv, s4216c35f3, ABISELECT(88,64), "S4216C35.s4216c35f3");
    check_field_offset(lv, s4216c35f4, ABISELECT(104,76), "S4216C35.s4216c35f4");
    check_field_offset(lv, s4216c35f5, ABISELECT(184,128), "S4216C35.s4216c35f5");
    check_field_offset(lv, s4216c35f6, ABISELECT(192,132), "S4216C35.s4216c35f6");
    check_field_offset(lv, s4216c35f7, ABISELECT(224,152), "S4216C35.s4216c35f7");
    test_class_info(&lv, &cd_S4216C35);
    dp->~S4216C35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C35(Test_S4216C35, "S4216C35", ABISELECT(240,164));

#else // __cplusplus

extern void _ZN8S4216C35C1Ev();
extern void _ZN8S4216C35D1Ev();
Name_Map name_map_S4216C35[] = {
  NSPAIR(_ZN8S4216C35C1Ev),
  NSPAIR(_ZN8S4216C35D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C35[];
extern void _ZN8S4216C35D1Ev();
extern void _ZN8S4216C35D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C354v240Ev();
extern void _ZN8S4216C354v241Ev();
static  VTBL_ENTRY vtc_S4216C35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C35[0]),
  (VTBL_ENTRY)&_ZN8S4216C35D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C35D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C354v240Ev,
  (VTBL_ENTRY)&_ZN8S4216C354v241Ev,
};
extern VTBL_ENTRY _ZTI8S4216C35[];
extern  VTBL_ENTRY _ZTV8S4216C35[];
Class_Descriptor cd_S4216C35 = {  "S4216C35", // class name
  bases_S4216C35, 1,
  &(vtc_S4216C35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(240,164), // object size
  NSPAIRA(_ZTI8S4216C35),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C35),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C40  : S4216C34 {
  ::S4216C22_nt s4216c40f0;
  int s4216c40f1;
  char s4216c40f2;
  virtual  ~S4216C40(); // _ZN8S4216C40D1Ev
  virtual void  v244(); // _ZN8S4216C404v244Ev
  virtual void  v245(); // _ZN8S4216C404v245Ev
  S4216C40(); // tgen
};
//SIG(-1 S4216C40) C1{ BC2{ BC3{ vd v3 v4} vd v5 FC4{ m Fp Fi FC5{ m}} FC4 FC4} vd v1 v2 FC4 Fi Fc}


 S4216C40 ::~S4216C40(){ note_dtor("S4216C40", this);}
void  S4216C40 ::v244(){vfunc_called(this, "_ZN8S4216C404v244Ev");}
void  S4216C40 ::v245(){vfunc_called(this, "_ZN8S4216C404v245Ev");}
S4216C40 ::S4216C40(){ note_ctor("S4216C40", this);} // tgen

static void Test_S4216C40()
{
  extern Class_Descriptor cd_S4216C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,16)];
    init_test(&cd_S4216C40, buf);
    S4216C40 *dp, &lv = *(dp=new (buf) S4216C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,60), "sizeof(S4216C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C40)");
    check_base_class_offset(lv, (S4216C28_nt*)(S4216C34*), 0, "S4216C40");
    check_base_class_offset(lv, (S4216C34*), 0, "S4216C40");
    check_field_offset(lv, s4216c40f0, ABISELECT(56,40), "S4216C40.s4216c40f0");
    check_field_offset(lv, s4216c40f1, ABISELECT(72,52), "S4216C40.s4216c40f1");
    check_field_offset(lv, s4216c40f2, ABISELECT(76,56), "S4216C40.s4216c40f2");
    test_class_info(&lv, &cd_S4216C40);
    dp->~S4216C40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C40(Test_S4216C40, "S4216C40", ABISELECT(80,60));

#else // __cplusplus

extern void _ZN8S4216C40C1Ev();
extern void _ZN8S4216C40D1Ev();
Name_Map name_map_S4216C40[] = {
  NSPAIR(_ZN8S4216C40C1Ev),
  NSPAIR(_ZN8S4216C40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
extern Class_Descriptor cd_S4216C34;
extern VTBL_ENTRY _ZTI8S4216C34[];
extern  VTBL_ENTRY _ZTV8S4216C34[];
static Base_Class bases_S4216C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4216C34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C40[];
extern void _ZN8S4216C40D1Ev();
extern void _ZN8S4216C40D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C344v239Ev();
extern void _ZN8S4216C404v244Ev();
extern void _ZN8S4216C404v245Ev();
static  VTBL_ENTRY vtc_S4216C40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C40[0]),
  (VTBL_ENTRY)&_ZN8S4216C40D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C40D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C344v239Ev,
  (VTBL_ENTRY)&_ZN8S4216C404v244Ev,
  (VTBL_ENTRY)&_ZN8S4216C404v245Ev,
};
extern VTBL_ENTRY _ZTI8S4216C40[];
extern  VTBL_ENTRY _ZTV8S4216C40[];
Class_Descriptor cd_S4216C40 = {  "S4216C40", // class name
  bases_S4216C40, 2,
  &(vtc_S4216C40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,60), // object size
  NSPAIRA(_ZTI8S4216C40),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C40),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C41  : S4216C28_nt {
  ::S4216C33 s4216c41f0;
  ::S4216C22_nt s4216c41f1;
  int s4216c41f2[2];
  ::S4216C32 s4216c41f3;
  int s4216c41f4[2];
  virtual  ~S4216C41(); // _ZN8S4216C41D1Ev
  virtual void  v246(); // _ZN8S4216C414v246Ev
  S4216C41(); // tgen
};
//SIG(-1 S4216C41) C1{ BC2{ vd v2 v3} vd v1 FC3{ vd v4 Fs[2] Fc[6] Fs[2] Fc[6] FC4{ m Fp Fi FC5{ m}}} FC4 Fi[2] FC6{ vd v5 Fi} Fi[2]}


 S4216C41 ::~S4216C41(){ note_dtor("S4216C41", this);}
void  S4216C41 ::v246(){vfunc_called(this, "_ZN8S4216C414v246Ev");}
S4216C41 ::S4216C41(){ note_ctor("S4216C41", this);} // tgen

static void Test_S4216C41()
{
  extern Class_Descriptor cd_S4216C41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(14,20)];
    init_test(&cd_S4216C41, buf);
    S4216C41 *dp, &lv = *(dp=new (buf) S4216C41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,76), "sizeof(S4216C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C41)");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C41");
    check_field_offset(lv, s4216c41f0, ABISELECT(8,4), "S4216C41.s4216c41f0");
    check_field_offset(lv, s4216c41f1, ABISELECT(56,40), "S4216C41.s4216c41f1");
    check_field_offset(lv, s4216c41f2, ABISELECT(72,52), "S4216C41.s4216c41f2");
    check_field_offset(lv, s4216c41f3, ABISELECT(80,60), "S4216C41.s4216c41f3");
    check_field_offset(lv, s4216c41f4, ABISELECT(96,68), "S4216C41.s4216c41f4");
    test_class_info(&lv, &cd_S4216C41);
    dp->~S4216C41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C41(Test_S4216C41, "S4216C41", ABISELECT(104,76));

#else // __cplusplus

extern void _ZN8S4216C41C1Ev();
extern void _ZN8S4216C41D1Ev();
Name_Map name_map_S4216C41[] = {
  NSPAIR(_ZN8S4216C41C1Ev),
  NSPAIR(_ZN8S4216C41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C41[];
extern void _ZN8S4216C41D1Ev();
extern void _ZN8S4216C41D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C414v246Ev();
static  VTBL_ENTRY vtc_S4216C41[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C41[0]),
  (VTBL_ENTRY)&_ZN8S4216C41D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C41D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C414v246Ev,
};
extern VTBL_ENTRY _ZTI8S4216C41[];
extern  VTBL_ENTRY _ZTV8S4216C41[];
Class_Descriptor cd_S4216C41 = {  "S4216C41", // class name
  bases_S4216C41, 1,
  &(vtc_S4216C41[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(104,76), // object size
  NSPAIRA(_ZTI8S4216C41),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C41),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C44_nt  {
  int s4216c44f0;
  void  mf4216c44(); // _ZN11S4216C44_nt9mf4216c44Ev
};
//SIG(-1 S4216C44_nt) C1{ m Fi}


void  S4216C44_nt ::mf4216c44(){}

//skip512 S4216C44_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S4216C44_nt[];
VTBL_ENTRY *P__ZTI11S4216C44_nt = _ZTI11S4216C44_nt; 
Class_Descriptor cd_S4216C44_nt = {  "S4216C44_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI11S4216C44_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C45  : S4216C28_nt {
  ::S4216C22_nt s4216c45f0;
  virtual  ~S4216C45(); // _ZN8S4216C45D1Ev
  virtual void  v247(); // _ZN8S4216C454v247Ev
  S4216C45(); // tgen
};
//SIG(-1 S4216C45) C1{ BC2{ vd v2 v3} vd v1 FC3{ m Fp Fi FC4{ m}}}


 S4216C45 ::~S4216C45(){ note_dtor("S4216C45", this);}
void  S4216C45 ::v247(){vfunc_called(this, "_ZN8S4216C454v247Ev");}
S4216C45 ::S4216C45(){ note_ctor("S4216C45", this);} // tgen

static void Test_S4216C45()
{
  extern Class_Descriptor cd_S4216C45;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S4216C45, buf);
    S4216C45 *dp, &lv = *(dp=new (buf) S4216C45());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S4216C45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C45)");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C45");
    check_field_offset(lv, s4216c45f0, ABISELECT(8,4), "S4216C45.s4216c45f0");
    test_class_info(&lv, &cd_S4216C45);
    dp->~S4216C45();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C45(Test_S4216C45, "S4216C45", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S4216C45C1Ev();
extern void _ZN8S4216C45D1Ev();
Name_Map name_map_S4216C45[] = {
  NSPAIR(_ZN8S4216C45C1Ev),
  NSPAIR(_ZN8S4216C45D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C45[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C45[];
extern void _ZN8S4216C45D1Ev();
extern void _ZN8S4216C45D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C454v247Ev();
static  VTBL_ENTRY vtc_S4216C45[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C45[0]),
  (VTBL_ENTRY)&_ZN8S4216C45D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C45D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C454v247Ev,
};
extern VTBL_ENTRY _ZTI8S4216C45[];
extern  VTBL_ENTRY _ZTV8S4216C45[];
Class_Descriptor cd_S4216C45 = {  "S4216C45", // class name
  bases_S4216C45, 1,
  &(vtc_S4216C45[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S4216C45),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C45),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C47  : S4216C28_nt {
  ::S4216C29 s4216c47f0;
  ::S4216C29 s4216c47f1;
  virtual  ~S4216C47(); // _ZN8S4216C47D1Ev
  virtual void  v249(); // _ZN8S4216C474v249Ev
  S4216C47(); // tgen
};
//SIG(-1 S4216C47) C1{ BC2{ vd v2 v3} vd v1 FC3{ BC2 vd v4 FC4{ m Fp Fi FC5{ m}}} FC3}


 S4216C47 ::~S4216C47(){ note_dtor("S4216C47", this);}
void  S4216C47 ::v249(){vfunc_called(this, "_ZN8S4216C474v249Ev");}
S4216C47 ::S4216C47(){ note_ctor("S4216C47", this);} // tgen

static void Test_S4216C47()
{
  extern Class_Descriptor cd_S4216C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,10)];
    init_test(&cd_S4216C47, buf);
    S4216C47 *dp, &lv = *(dp=new (buf) S4216C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,36), "sizeof(S4216C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C47)");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C47");
    check_field_offset(lv, s4216c47f0, ABISELECT(8,4), "S4216C47.s4216c47f0");
    check_field_offset(lv, s4216c47f1, ABISELECT(32,20), "S4216C47.s4216c47f1");
    test_class_info(&lv, &cd_S4216C47);
    dp->~S4216C47();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C47(Test_S4216C47, "S4216C47", ABISELECT(56,36));

#else // __cplusplus

extern void _ZN8S4216C47C1Ev();
extern void _ZN8S4216C47D1Ev();
Name_Map name_map_S4216C47[] = {
  NSPAIR(_ZN8S4216C47C1Ev),
  NSPAIR(_ZN8S4216C47D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C47[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C47[];
extern void _ZN8S4216C47D1Ev();
extern void _ZN8S4216C47D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C474v249Ev();
static  VTBL_ENTRY vtc_S4216C47[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C47[0]),
  (VTBL_ENTRY)&_ZN8S4216C47D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C47D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C474v249Ev,
};
extern VTBL_ENTRY _ZTI8S4216C47[];
extern  VTBL_ENTRY _ZTV8S4216C47[];
Class_Descriptor cd_S4216C47 = {  "S4216C47", // class name
  bases_S4216C47, 1,
  &(vtc_S4216C47[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,36), // object size
  NSPAIRA(_ZTI8S4216C47),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C47),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C26  {
  int s4216c26f0;
  char s4216c26f1[2];
  ::S4216C27 s4216c26f2;
  ::S4216C22_nt s4216c26f3;
  ::S4216C29 s4216c26f4;
  ::S4216C29 s4216c26f5;
  ::S4216C29 s4216c26f6;
  char s4216c26f7;
  ::S4216C29 s4216c26f8;
  char s4216c26f9;
  int s4216c26f10;
  short s4216c26f11;
  ::S4216C29 s4216c26f12;
  ::S4216C29 s4216c26f13;
  ::S4216C24 s4216c26f14;
  ::S4216C21 s4216c26f15;
  ::S4216C32 s4216c26f16;
  ::S4216C33 s4216c26f17;
  ::S4216C33 s4216c26f18;
  ::S4216C34 s4216c26f19;
  char s4216c26f20;
  int s4216c26f21[3];
  ::S4216C35 s4216c26f22;
  int s4216c26f23[2];
  ::S4216C40 s4216c26f24;
  int s4216c26f25[2];
  ::S4216C41 s4216c26f26;
  ::S4216C41 s4216c26f27;
  ::S4216C21 s4216c26f28;
  int s4216c26f29[2];
  char s4216c26f30[2];
  int s4216c26f31[2];
  ::S4216C44_nt s4216c26f32;
  ::S4216C45 s4216c26f33;
  ::S4216C45 s4216c26f34;
  int s4216c26f35[2];
  ::S4216C29 s4216c26f36;
  int s4216c26f37;
  ::S4216C47 s4216c26f38;
  char s4216c26f39;
  ::S4216C29 s4216c26f40;
  ::S4216C37 s4216c26f41;
  ::S4216C34 s4216c26f42;
  char s4216c26f43;
  ::S4216C40 s4216c26f44;
  char s4216c26f45;
  ::S4216C45 s4216c26f46;
  ::S4216C45 s4216c26f47;
  int s4216c26f48;
  char s4216c26f49;
  int s4216c26f50;
  ::S4216C44_nt s4216c26f51[55];
  void  mf4216c26(); // _ZN8S4216C269mf4216c26Ev
  virtual  ~S4216C26(); // _ZN8S4216C26D1Ev
  S4216C26(); // tgen
};
//SIG(-1 S4216C26) C1{ vd m Fi Fc[2] FC2{ BC3{ vd v4 v5} vd v1 v2 v3 Fc[66]} FC4{ m Fp Fi FC5{ m}} FC6{ BC3 vd v6 FC4} FC6 FC6 Fc FC6 Fc Fi Fs FC6 FC6 FC7{ vd v7 Fi} FC8{ vd v8 Fi[2] Fs[2] Fi[3] FC4} FC9{ vd v9 Fi} FC10{ vd v10 Fs[2] Fc[6] Fs[2] Fc[6] FC4} FC10 FC11{ BC3 vd v11 FC4 FC4 FC4} Fc Fi[3] FC12{ BC3 vd v12 v13 FC10 FC4 FC4 FC4 FC13{ vd m Fi FC11 Fi} Fc FC14{ BC15{ m Fp Fi[2] FC16{ m}} BC3 vd v14 v15} FC4} Fi[2] FC17{ BC11 vd v16 v17 FC4 Fi Fc} Fi[2] FC18{ BC3 vd v18 FC10 FC4 Fi[2] FC9 Fi[2]} FC18 FC8 Fi[2] Fc[2] Fi[2] FC19{ m Fi} FC20{ BC3 vd v19 FC4} FC20 Fi[2] FC6 Fi FC21{ BC3 vd v20 FC6 FC6} Fc FC6 FC14 FC11 Fc FC17 Fc FC20 FC20 Fi Fc Fi FC19[55]}


void  S4216C26 ::mf4216c26(){}
 S4216C26 ::~S4216C26(){ note_dtor("S4216C26", this);}
S4216C26 ::S4216C26(){ note_ctor("S4216C26", this);} // tgen

static void Test_S4216C26()
{
  extern Class_Descriptor cd_S4216C26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(224,340)];
    init_test(&cd_S4216C26, buf);
    S4216C26 *dp, &lv = *(dp=new (buf) S4216C26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1784,1356), "sizeof(S4216C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C26)");
    check_field_offset(lv, s4216c26f0, ABISELECT(8,4), "S4216C26.s4216c26f0");
    check_field_offset(lv, s4216c26f1, ABISELECT(12,8), "S4216C26.s4216c26f1");
    check_field_offset(lv, s4216c26f2, ABISELECT(16,12), "S4216C26.s4216c26f2");
    check_field_offset(lv, s4216c26f3, ABISELECT(96,84), "S4216C26.s4216c26f3");
    check_field_offset(lv, s4216c26f4, ABISELECT(112,96), "S4216C26.s4216c26f4");
    check_field_offset(lv, s4216c26f5, ABISELECT(136,112), "S4216C26.s4216c26f5");
    check_field_offset(lv, s4216c26f6, ABISELECT(160,128), "S4216C26.s4216c26f6");
    check_field_offset(lv, s4216c26f7, ABISELECT(184,144), "S4216C26.s4216c26f7");
    check_field_offset(lv, s4216c26f8, ABISELECT(192,148), "S4216C26.s4216c26f8");
    check_field_offset(lv, s4216c26f9, ABISELECT(216,164), "S4216C26.s4216c26f9");
    check_field_offset(lv, s4216c26f10, ABISELECT(220,168), "S4216C26.s4216c26f10");
    check_field_offset(lv, s4216c26f11, ABISELECT(224,172), "S4216C26.s4216c26f11");
    check_field_offset(lv, s4216c26f12, ABISELECT(232,176), "S4216C26.s4216c26f12");
    check_field_offset(lv, s4216c26f13, ABISELECT(256,192), "S4216C26.s4216c26f13");
    check_field_offset(lv, s4216c26f14, ABISELECT(280,208), "S4216C26.s4216c26f14");
    check_field_offset(lv, s4216c26f15, ABISELECT(296,216), "S4216C26.s4216c26f15");
    check_field_offset(lv, s4216c26f16, ABISELECT(344,256), "S4216C26.s4216c26f16");
    check_field_offset(lv, s4216c26f17, ABISELECT(360,264), "S4216C26.s4216c26f17");
    check_field_offset(lv, s4216c26f18, ABISELECT(408,300), "S4216C26.s4216c26f18");
    check_field_offset(lv, s4216c26f19, ABISELECT(456,336), "S4216C26.s4216c26f19");
    check_field_offset(lv, s4216c26f20, ABISELECT(512,376), "S4216C26.s4216c26f20");
    check_field_offset(lv, s4216c26f21, ABISELECT(516,380), "S4216C26.s4216c26f21");
    check_field_offset(lv, s4216c26f22, ABISELECT(528,392), "S4216C26.s4216c26f22");
    check_field_offset(lv, s4216c26f23, ABISELECT(768,556), "S4216C26.s4216c26f23");
    check_field_offset(lv, s4216c26f24, ABISELECT(776,564), "S4216C26.s4216c26f24");
    check_field_offset(lv, s4216c26f25, ABISELECT(856,624), "S4216C26.s4216c26f25");
    check_field_offset(lv, s4216c26f26, ABISELECT(864,632), "S4216C26.s4216c26f26");
    check_field_offset(lv, s4216c26f27, ABISELECT(968,708), "S4216C26.s4216c26f27");
    check_field_offset(lv, s4216c26f28, ABISELECT(1072,784), "S4216C26.s4216c26f28");
    check_field_offset(lv, s4216c26f29, ABISELECT(1120,824), "S4216C26.s4216c26f29");
    check_field_offset(lv, s4216c26f30, ABISELECT(1128,832), "S4216C26.s4216c26f30");
    check_field_offset(lv, s4216c26f31, ABISELECT(1132,836), "S4216C26.s4216c26f31");
    check_field_offset(lv, s4216c26f32, ABISELECT(1140,844), "S4216C26.s4216c26f32");
    check_field_offset(lv, s4216c26f33, ABISELECT(1144,848), "S4216C26.s4216c26f33");
    check_field_offset(lv, s4216c26f34, ABISELECT(1168,864), "S4216C26.s4216c26f34");
    check_field_offset(lv, s4216c26f35, ABISELECT(1192,880), "S4216C26.s4216c26f35");
    check_field_offset(lv, s4216c26f36, ABISELECT(1200,888), "S4216C26.s4216c26f36");
    check_field_offset(lv, s4216c26f37, ABISELECT(1224,904), "S4216C26.s4216c26f37");
    check_field_offset(lv, s4216c26f38, ABISELECT(1232,908), "S4216C26.s4216c26f38");
    check_field_offset(lv, s4216c26f39, ABISELECT(1288,944), "S4216C26.s4216c26f39");
    check_field_offset(lv, s4216c26f40, ABISELECT(1296,948), "S4216C26.s4216c26f40");
    check_field_offset(lv, s4216c26f41, ABISELECT(1320,964), "S4216C26.s4216c26f41");
    check_field_offset(lv, s4216c26f42, ABISELECT(1352,984), "S4216C26.s4216c26f42");
    check_field_offset(lv, s4216c26f43, ABISELECT(1408,1024), "S4216C26.s4216c26f43");
    check_field_offset(lv, s4216c26f44, ABISELECT(1416,1028), "S4216C26.s4216c26f44");
    check_field_offset(lv, s4216c26f45, ABISELECT(1496,1088), "S4216C26.s4216c26f45");
    check_field_offset(lv, s4216c26f46, ABISELECT(1504,1092), "S4216C26.s4216c26f46");
    check_field_offset(lv, s4216c26f47, ABISELECT(1528,1108), "S4216C26.s4216c26f47");
    check_field_offset(lv, s4216c26f48, ABISELECT(1552,1124), "S4216C26.s4216c26f48");
    check_field_offset(lv, s4216c26f49, ABISELECT(1556,1128), "S4216C26.s4216c26f49");
    check_field_offset(lv, s4216c26f50, ABISELECT(1560,1132), "S4216C26.s4216c26f50");
    check_field_offset(lv, s4216c26f51, ABISELECT(1564,1136), "S4216C26.s4216c26f51");
    test_class_info(&lv, &cd_S4216C26);
    dp->~S4216C26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C26(Test_S4216C26, "S4216C26", ABISELECT(1784,1356));

#else // __cplusplus

extern void _ZN8S4216C26C1Ev();
extern void _ZN8S4216C26D1Ev();
Name_Map name_map_S4216C26[] = {
  NSPAIR(_ZN8S4216C26C1Ev),
  NSPAIR(_ZN8S4216C26D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4216C26[];
extern void _ZN8S4216C26D1Ev();
extern void _ZN8S4216C26D0Ev();
static  VTBL_ENTRY vtc_S4216C26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C26[0]),
  (VTBL_ENTRY)&_ZN8S4216C26D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C26D0Ev,
};
extern VTBL_ENTRY _ZTI8S4216C26[];
extern  VTBL_ENTRY _ZTV8S4216C26[];
Class_Descriptor cd_S4216C26 = {  "S4216C26", // class name
  0,0,//no base classes
  &(vtc_S4216C26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1784,1356), // object size
  NSPAIRA(_ZTI8S4216C26),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4216C26),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C52  : S4216C28_nt {
  int s4216c52f0[4];
  virtual  ~S4216C52(); // _ZN8S4216C52D1Ev
  virtual void  v252(); // _ZN8S4216C524v252Ev
  virtual void  v253(); // _ZN8S4216C524v253Ev
  S4216C52(); // tgen
};
//SIG(-1 S4216C52) C1{ BC2{ vd v3 v4} vd v1 v2 Fi[4]}


 S4216C52 ::~S4216C52(){ note_dtor("S4216C52", this);}
void  S4216C52 ::v252(){vfunc_called(this, "_ZN8S4216C524v252Ev");}
void  S4216C52 ::v253(){vfunc_called(this, "_ZN8S4216C524v253Ev");}
S4216C52 ::S4216C52(){ note_ctor("S4216C52", this);} // tgen

static void Test_S4216C52()
{
  extern Class_Descriptor cd_S4216C52;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd_S4216C52, buf);
    S4216C52 *dp, &lv = *(dp=new (buf) S4216C52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(S4216C52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C52)");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C52");
    check_field_offset(lv, s4216c52f0, ABISELECT(8,4), "S4216C52.s4216c52f0");
    test_class_info(&lv, &cd_S4216C52);
    dp->~S4216C52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C52(Test_S4216C52, "S4216C52", ABISELECT(24,20));

#else // __cplusplus

extern void _ZN8S4216C52C1Ev();
extern void _ZN8S4216C52D1Ev();
Name_Map name_map_S4216C52[] = {
  NSPAIR(_ZN8S4216C52C1Ev),
  NSPAIR(_ZN8S4216C52D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C52[];
extern void _ZN8S4216C52D1Ev();
extern void _ZN8S4216C52D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C524v252Ev();
extern void _ZN8S4216C524v253Ev();
static  VTBL_ENTRY vtc_S4216C52[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C52[0]),
  (VTBL_ENTRY)&_ZN8S4216C52D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C52D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C524v252Ev,
  (VTBL_ENTRY)&_ZN8S4216C524v253Ev,
};
extern VTBL_ENTRY _ZTI8S4216C52[];
extern  VTBL_ENTRY _ZTV8S4216C52[];
Class_Descriptor cd_S4216C52 = {  "S4216C52", // class name
  bases_S4216C52, 1,
  &(vtc_S4216C52[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI8S4216C52),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C52),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C51  {
  ::S4216C52 s4216c51f0;
  void  mf4216c51(); // _ZN8S4216C519mf4216c51Ev
  virtual  ~S4216C51(); // _ZN8S4216C51D1Ev
  S4216C51(); // tgen
};
//SIG(-1 S4216C51) C1{ vd m FC2{ BC3{ vd v3 v4} vd v1 v2 Fi[4]}}


void  S4216C51 ::mf4216c51(){}
 S4216C51 ::~S4216C51(){ note_dtor("S4216C51", this);}
S4216C51 ::S4216C51(){ note_ctor("S4216C51", this);} // tgen

static void Test_S4216C51()
{
  extern Class_Descriptor cd_S4216C51;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd_S4216C51, buf);
    S4216C51 *dp, &lv = *(dp=new (buf) S4216C51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S4216C51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C51)");
    check_field_offset(lv, s4216c51f0, ABISELECT(8,4), "S4216C51.s4216c51f0");
    test_class_info(&lv, &cd_S4216C51);
    dp->~S4216C51();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C51(Test_S4216C51, "S4216C51", ABISELECT(32,24));

#else // __cplusplus

extern void _ZN8S4216C51C1Ev();
extern void _ZN8S4216C51D1Ev();
Name_Map name_map_S4216C51[] = {
  NSPAIR(_ZN8S4216C51C1Ev),
  NSPAIR(_ZN8S4216C51D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4216C51[];
extern void _ZN8S4216C51D1Ev();
extern void _ZN8S4216C51D0Ev();
static  VTBL_ENTRY vtc_S4216C51[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C51[0]),
  (VTBL_ENTRY)&_ZN8S4216C51D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C51D0Ev,
};
extern VTBL_ENTRY _ZTI8S4216C51[];
extern  VTBL_ENTRY _ZTV8S4216C51[];
Class_Descriptor cd_S4216C51 = {  "S4216C51", // class name
  0,0,//no base classes
  &(vtc_S4216C51[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,24), // object size
  NSPAIRA(_ZTI8S4216C51),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4216C51),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C58  {
  void *s4216c58f0;
  int s4216c58f1[2];
  ::S4216C39 s4216c58f2;
  void  mf4216c58(); // _ZN8S4216C589mf4216c58Ev
};
//SIG(-1 S4216C58) C1{ m Fp Fi[2] FC2{ m}}


void  S4216C58 ::mf4216c58(){}

static void Test_S4216C58()
{
  {
    init_simple_test("S4216C58");
    S4216C58 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S4216C58)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C58)");
    check_field_offset(lv, s4216c58f0, 0, "S4216C58.s4216c58f0");
    check_field_offset(lv, s4216c58f1, ABISELECT(8,4), "S4216C58.s4216c58f1");
    check_field_offset(lv, s4216c58f2, ABISELECT(16,12), "S4216C58.s4216c58f2");
  }
}
static Arrange_To_Call_Me vS4216C58(Test_S4216C58, "S4216C58", ABISELECT(24,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S4216C58[];
VTBL_ENTRY *P__ZTI8S4216C58 = _ZTI8S4216C58; 
Class_Descriptor cd_S4216C58 = {  "S4216C58", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S4216C58),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C57  : S4216C58 , S4216C28_nt {
  virtual  ~S4216C57(); // _ZN8S4216C57D1Ev
  virtual void  v254(); // _ZN8S4216C574v254Ev
  virtual void  v255(); // _ZN8S4216C574v255Ev
  S4216C57(); // tgen
};
//SIG(-1 S4216C57) C1{ BC2{ m Fp Fi[2] FC3{ m}} BC4{ vd v3 v4} vd v1 v2}


 S4216C57 ::~S4216C57(){ note_dtor("S4216C57", this);}
void  S4216C57 ::v254(){vfunc_called(this, "_ZN8S4216C574v254Ev");}
void  S4216C57 ::v255(){vfunc_called(this, "_ZN8S4216C574v255Ev");}
S4216C57 ::S4216C57(){ note_ctor("S4216C57", this);} // tgen

static void Test_S4216C57()
{
  extern Class_Descriptor cd_S4216C57;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S4216C57, buf);
    S4216C57 *dp, &lv = *(dp=new (buf) S4216C57());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S4216C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C57)");
    check_base_class_offset(lv, (S4216C58*), ABISELECT(8,4), "S4216C57");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C57");
    test_class_info(&lv, &cd_S4216C57);
    dp->~S4216C57();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C57(Test_S4216C57, "S4216C57", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN8S4216C57C1Ev();
extern void _ZN8S4216C57D1Ev();
Name_Map name_map_S4216C57[] = {
  NSPAIR(_ZN8S4216C57C1Ev),
  NSPAIR(_ZN8S4216C57D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C58;
extern VTBL_ENTRY _ZTI8S4216C58[];
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C57[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C58,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C57[];
extern void _ZN8S4216C57D1Ev();
extern void _ZN8S4216C57D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C574v254Ev();
extern void _ZN8S4216C574v255Ev();
static  VTBL_ENTRY vtc_S4216C57[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C57[0]),
  (VTBL_ENTRY)&_ZN8S4216C57D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C57D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C574v254Ev,
  (VTBL_ENTRY)&_ZN8S4216C574v255Ev,
};
extern VTBL_ENTRY _ZTI8S4216C57[];
extern  VTBL_ENTRY _ZTV8S4216C57[];
Class_Descriptor cd_S4216C57 = {  "S4216C57", // class name
  bases_S4216C57, 2,
  &(vtc_S4216C57[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S4216C57),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S4216C57),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C65  {
  void  mf4216c65(); // _ZN8S4216C659mf4216c65Ev
};
//SIG(-1 S4216C65) C1{ m}


void  S4216C65 ::mf4216c65(){}

static void Test_S4216C65()
{
  {
    init_simple_test("S4216C65");
    S4216C65 lv;
    check2(sizeof(lv), 1, "sizeof(S4216C65)");
    check2(__alignof__(lv), 1, "__alignof__(S4216C65)");
  }
}
static Arrange_To_Call_Me vS4216C65(Test_S4216C65, "S4216C65", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S4216C65[];
VTBL_ENTRY *P__ZTI8S4216C65 = _ZTI8S4216C65; 
Class_Descriptor cd_S4216C65 = {  "S4216C65", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S4216C65),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C64  {
  void *s4216c64f0;
  int s4216c64f1[2];
  ::S4216C65 s4216c64f2;
  void  mf4216c64(); // _ZN8S4216C649mf4216c64Ev
};
//SIG(-1 S4216C64) C1{ m Fp Fi[2] FC2{ m}}


void  S4216C64 ::mf4216c64(){}

static void Test_S4216C64()
{
  {
    init_simple_test("S4216C64");
    S4216C64 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S4216C64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C64)");
    check_field_offset(lv, s4216c64f0, 0, "S4216C64.s4216c64f0");
    check_field_offset(lv, s4216c64f1, ABISELECT(8,4), "S4216C64.s4216c64f1");
    check_field_offset(lv, s4216c64f2, ABISELECT(16,12), "S4216C64.s4216c64f2");
  }
}
static Arrange_To_Call_Me vS4216C64(Test_S4216C64, "S4216C64", ABISELECT(24,16));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S4216C64[];
VTBL_ENTRY *P__ZTI8S4216C64 = _ZTI8S4216C64; 
Class_Descriptor cd_S4216C64 = {  "S4216C64", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S4216C64),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C63  : S4216C64 , S4216C28_nt {
  virtual  ~S4216C63(); // _ZN8S4216C63D1Ev
  virtual void  v258(); // _ZN8S4216C634v258Ev
  virtual void  v259(); // _ZN8S4216C634v259Ev
  S4216C63(); // tgen
};
//SIG(-1 S4216C63) C1{ BC2{ m Fp Fi[2] FC3{ m}} BC4{ vd v3 v4} vd v1 v2}


 S4216C63 ::~S4216C63(){ note_dtor("S4216C63", this);}
void  S4216C63 ::v258(){vfunc_called(this, "_ZN8S4216C634v258Ev");}
void  S4216C63 ::v259(){vfunc_called(this, "_ZN8S4216C634v259Ev");}
S4216C63 ::S4216C63(){ note_ctor("S4216C63", this);} // tgen

static void Test_S4216C63()
{
  extern Class_Descriptor cd_S4216C63;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S4216C63, buf);
    S4216C63 *dp, &lv = *(dp=new (buf) S4216C63());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S4216C63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C63)");
    check_base_class_offset(lv, (S4216C64*), ABISELECT(8,4), "S4216C63");
    check_base_class_offset(lv, (S4216C28_nt*), 0, "S4216C63");
    test_class_info(&lv, &cd_S4216C63);
    dp->~S4216C63();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C63(Test_S4216C63, "S4216C63", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN8S4216C63C1Ev();
extern void _ZN8S4216C63D1Ev();
Name_Map name_map_S4216C63[] = {
  NSPAIR(_ZN8S4216C63C1Ev),
  NSPAIR(_ZN8S4216C63D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C64;
extern VTBL_ENTRY _ZTI8S4216C64[];
extern Class_Descriptor cd_S4216C28_nt;
extern VTBL_ENTRY _ZTI11S4216C28_nt[];
extern  VTBL_ENTRY _ZTV11S4216C28_nt[];
static Base_Class bases_S4216C63[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C64,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C28_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C63[];
extern void _ZN8S4216C63D1Ev();
extern void _ZN8S4216C63D0Ev();
extern void _ZN11S4216C28_nt4v232Ev();
extern void _ZN11S4216C28_nt4v233Ev();
extern void _ZN8S4216C634v258Ev();
extern void _ZN8S4216C634v259Ev();
static  VTBL_ENTRY vtc_S4216C63[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C63[0]),
  (VTBL_ENTRY)&_ZN8S4216C63D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C63D0Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v232Ev,
  (VTBL_ENTRY)&_ZN11S4216C28_nt4v233Ev,
  (VTBL_ENTRY)&_ZN8S4216C634v258Ev,
  (VTBL_ENTRY)&_ZN8S4216C634v259Ev,
};
extern VTBL_ENTRY _ZTI8S4216C63[];
extern  VTBL_ENTRY _ZTV8S4216C63[];
Class_Descriptor cd_S4216C63 = {  "S4216C63", // class name
  bases_S4216C63, 2,
  &(vtc_S4216C63[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S4216C63),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S4216C63),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C66  {
  __tsi64 s4216c66f0;
  int s4216c66f1;
  __tsi64 s4216c66f2;
  char s4216c66f3;
  ::S4216C4_nt s4216c66f4;
  void  mf4216c66(); // _ZN8S4216C669mf4216c66Ev
};
//SIG(-1 S4216C66) C1{ m FL Fi FL Fc FC2{ m Fp Fi[2] FC3{ m}}}


void  S4216C66 ::mf4216c66(){}

static void Test_S4216C66()
{
  {
    init_simple_test("S4216C66");
    S4216C66 lv;
    check2(sizeof(lv), ABISELECT(56,40), "sizeof(S4216C66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C66)");
    check_field_offset(lv, s4216c66f0, 0, "S4216C66.s4216c66f0");
    check_field_offset(lv, s4216c66f1, 8, "S4216C66.s4216c66f1");
    check_field_offset(lv, s4216c66f2, ABISELECT(16,12), "S4216C66.s4216c66f2");
    check_field_offset(lv, s4216c66f3, ABISELECT(24,20), "S4216C66.s4216c66f3");
    check_field_offset(lv, s4216c66f4, ABISELECT(32,24), "S4216C66.s4216c66f4");
  }
}
static Arrange_To_Call_Me vS4216C66(Test_S4216C66, "S4216C66", ABISELECT(56,40));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C72  {
  void *s4216c72f0;
  int s4216c72f1[2];
  ::S4216C65 s4216c72f2;
  void  mf4216c72(); // _ZN8S4216C729mf4216c72Ev
};
//SIG(-1 S4216C72) C1{ m Fp Fi[2] FC2{ m}}


void  S4216C72 ::mf4216c72(){}

static void Test_S4216C72()
{
  {
    init_simple_test("S4216C72");
    S4216C72 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S4216C72)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C72)");
    check_field_offset(lv, s4216c72f0, 0, "S4216C72.s4216c72f0");
    check_field_offset(lv, s4216c72f1, ABISELECT(8,4), "S4216C72.s4216c72f1");
    check_field_offset(lv, s4216c72f2, ABISELECT(16,12), "S4216C72.s4216c72f2");
  }
}
static Arrange_To_Call_Me vS4216C72(Test_S4216C72, "S4216C72", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C25  : S4216C26 , S4216C51 , S4216C2 {
  void *s4216c25f0[2];
  ::S4216C6_nt s4216c25f1;
  void *s4216c25f2[5];
  ::S4216C33 s4216c25f3;
  ::S4216C6_nt s4216c25f4;
  ::S4216C12_nt s4216c25f5;
  ::S4216C57 s4216c25f6;
  ::S4216C57 s4216c25f7;
  ::S4216C63 s4216c25f8;
  ::S4216C66 s4216c25f9;
  ::S4216C37 s4216c25f10;
  ::S4216C63 s4216c25f11;
  int s4216c25f12[2];
  void *s4216c25f13;
  ::S4216C72 s4216c25f14;
  char s4216c25f15;
  virtual  ~S4216C25(); // _ZN8S4216C25D1Ev
  S4216C25(); // tgen
};
//SIG(-1 S4216C25) C1{ BC2{ vd m Fi Fc[2] FC3{ BC4{ vd v10 v11} vd v7 v8 v9 Fc[66]} FC5{ m Fp Fi FC6{ m}} FC7{ BC4 vd v12 FC5} FC7 FC7 Fc FC7 Fc Fi Fs FC7 FC7 FC8{ vd v13 Fi} FC9{ vd v14 Fi[2] Fs[2] Fi[3] FC5} FC10{ vd v15 Fi} FC11{ vd v16 Fs[2] Fc[6] Fs[2] Fc[6] FC5} FC11 FC12{ BC4 vd v17 FC5 FC5 FC5} Fc Fi[3] FC13{ BC4 vd v18 v19 FC11 FC5 FC5 FC5 FC14{ vd m Fi FC12 Fi} Fc FC15{ BC16{ m Fp Fi[2] FC17{ m}} BC4 vd v20 v21} FC5} Fi[2] FC18{ BC12 vd v22 v23 FC5 Fi Fc} Fi[2] FC19{ BC4 vd v24 FC11 FC5 Fi[2] FC10 Fi[2]} FC19 FC9 Fi[2] Fc[2] Fi[2] FC20{ m Fi} FC21{ BC4 vd v25 FC5} FC21 Fi[2] FC7 Fi FC22{ BC4 vd v26 FC7 FC7} Fc FC7 FC15 FC12 Fc FC18 Fc FC21 FC21 Fi Fc Fi FC20[55]} BC23{ vd m FC24{ BC4 vd v27 v28 Fi[4]}} BC25{ BC26{ vd v1 v2 v3} vd v4 v5 v6 FC27{ m Fp Fi[2] FC28{ m}} FC29{ m FC30{ Fl[4]}} Fc} vd Fp[2] FC29 Fp[5] FC11 FC29 FC31{ BC32{ m Fp Fi FC28 FC6}} FC33{ BC34{ m Fp Fi[2] FC17} BC4 vd v29 v30} FC33 FC35{ BC36{ m Fp Fi[2] FC37{ m}} BC4 vd v31 v32} FC38{ m FL Fi FL Fc FC27} FC15 FC35 Fi[2] Fp FC39{ m Fp Fi[2] FC37} Fc}


 S4216C25 ::~S4216C25(){ note_dtor("S4216C25", this);}
S4216C25 ::S4216C25(){ note_ctor("S4216C25", this);} // tgen

static void Test_S4216C25()
{
  extern Class_Descriptor cd_S4216C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(293,426)];
    init_test(&cd_S4216C25, buf);
    S4216C25 *dp, &lv = *(dp=new (buf) S4216C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2336,1700), "sizeof(S4216C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C25)");
    check_base_class_offset(lv, (S4216C26*), 0, "S4216C25");
    check_base_class_offset(lv, (S4216C51*), ABISELECT(1784,1356), "S4216C25");
    check_base_class_offset(lv, (S4216C3_nt*)(S4216C2*), ABISELECT(1816,1380), "S4216C25");
    check_base_class_offset(lv, (S4216C2*), ABISELECT(1816,1380), "S4216C25");
    check_field_offset(lv, s4216c25f0, ABISELECT(1888,1420), "S4216C25.s4216c25f0");
    check_field_offset(lv, s4216c25f1, ABISELECT(1904,1428), "S4216C25.s4216c25f1");
    check_field_offset(lv, s4216c25f2, ABISELECT(1936,1444), "S4216C25.s4216c25f2");
    check_field_offset(lv, s4216c25f3, ABISELECT(1976,1464), "S4216C25.s4216c25f3");
    check_field_offset(lv, s4216c25f4, ABISELECT(2024,1500), "S4216C25.s4216c25f4");
    check_field_offset(lv, s4216c25f5, ABISELECT(2056,1516), "S4216C25.s4216c25f5");
    check_field_offset(lv, s4216c25f6, ABISELECT(2072,1528), "S4216C25.s4216c25f6");
    check_field_offset(lv, s4216c25f7, ABISELECT(2104,1548), "S4216C25.s4216c25f7");
    check_field_offset(lv, s4216c25f8, ABISELECT(2136,1568), "S4216C25.s4216c25f8");
    check_field_offset(lv, s4216c25f9, ABISELECT(2168,1588), "S4216C25.s4216c25f9");
    check_field_offset(lv, s4216c25f10, ABISELECT(2224,1628), "S4216C25.s4216c25f10");
    check_field_offset(lv, s4216c25f11, ABISELECT(2256,1648), "S4216C25.s4216c25f11");
    check_field_offset(lv, s4216c25f12, ABISELECT(2288,1668), "S4216C25.s4216c25f12");
    check_field_offset(lv, s4216c25f13, ABISELECT(2296,1676), "S4216C25.s4216c25f13");
    check_field_offset(lv, s4216c25f14, ABISELECT(2304,1680), "S4216C25.s4216c25f14");
    check_field_offset(lv, s4216c25f15, ABISELECT(2328,1696), "S4216C25.s4216c25f15");
    test_class_info(&lv, &cd_S4216C25);
    dp->~S4216C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C25(Test_S4216C25, "S4216C25", ABISELECT(2336,1700));

#else // __cplusplus

extern void _ZN8S4216C25C1Ev();
extern void _ZN8S4216C25D1Ev();
Name_Map name_map_S4216C25[] = {
  NSPAIR(_ZN8S4216C25C1Ev),
  NSPAIR(_ZN8S4216C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C26;
extern VTBL_ENTRY _ZTI8S4216C26[];
extern  VTBL_ENTRY _ZTV8S4216C26[];
extern Class_Descriptor cd_S4216C51;
extern VTBL_ENTRY _ZTI8S4216C51[];
extern  VTBL_ENTRY _ZTV8S4216C51[];
extern Class_Descriptor cd_S4216C3_nt;
extern VTBL_ENTRY _ZTI10S4216C3_nt[];
extern  VTBL_ENTRY _ZTV10S4216C3_nt[];
extern Class_Descriptor cd_S4216C2;
extern VTBL_ENTRY _ZTI7S4216C2[];
extern  VTBL_ENTRY _ZTV7S4216C2[];
static Base_Class bases_S4216C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C51,    ABISELECT(1784,1356), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C3_nt,    ABISELECT(1816,1380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S4216C2,    ABISELECT(1816,1380), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C25[];
extern void _ZN8S4216C25D1Ev();
extern void _ZN8S4216C25D0Ev();
extern void ABISELECT(_ZThn1784_N8S4216C25D1Ev,_ZThn1356_N8S4216C25D1Ev)();
extern void ABISELECT(_ZThn1784_N8S4216C25D0Ev,_ZThn1356_N8S4216C25D0Ev)();
extern void ABISELECT(_ZThn1816_N8S4216C25D1Ev,_ZThn1380_N8S4216C25D1Ev)();
extern void ABISELECT(_ZThn1816_N8S4216C25D0Ev,_ZThn1380_N8S4216C25D0Ev)();
extern void _ZN10S4216C3_nt4v104Ev();
extern void _ZN10S4216C3_nt4v105Ev();
extern void _ZN10S4216C3_nt4v106Ev();
extern void _ZN7S4216C24v107Ev();
extern void _ZN7S4216C24v108Ev();
extern void _ZN7S4216C24v109Ev();
static  VTBL_ENTRY vtc_S4216C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C25[0]),
  (VTBL_ENTRY)&_ZN8S4216C25D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C25D0Ev,
  ABISELECT(-1784,-1356),
  (VTBL_ENTRY)&(_ZTI8S4216C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1784_N8S4216C25D1Ev,_ZThn1356_N8S4216C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1784_N8S4216C25D0Ev,_ZThn1356_N8S4216C25D0Ev),
  ABISELECT(-1816,-1380),
  (VTBL_ENTRY)&(_ZTI8S4216C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1816_N8S4216C25D1Ev,_ZThn1380_N8S4216C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1816_N8S4216C25D0Ev,_ZThn1380_N8S4216C25D0Ev),
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN7S4216C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4216C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4216C24v109Ev,
};
extern VTBL_ENTRY _ZTI8S4216C25[];
extern  VTBL_ENTRY _ZTV8S4216C25[];
Class_Descriptor cd_S4216C25 = {  "S4216C25", // class name
  bases_S4216C25, 4,
  &(vtc_S4216C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2336,1700), // object size
  NSPAIRA(_ZTI8S4216C25),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S4216C25),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C78  {
  void  mf4216c78(); // _ZN8S4216C789mf4216c78Ev
};
//SIG(-1 S4216C78) C1{ m}


void  S4216C78 ::mf4216c78(){}

static void Test_S4216C78()
{
  {
    init_simple_test("S4216C78");
    S4216C78 lv;
    check2(sizeof(lv), 1, "sizeof(S4216C78)");
    check2(__alignof__(lv), 1, "__alignof__(S4216C78)");
  }
}
static Arrange_To_Call_Me vS4216C78(Test_S4216C78, "S4216C78", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S4216C78[];
VTBL_ENTRY *P__ZTI8S4216C78 = _ZTI8S4216C78; 
Class_Descriptor cd_S4216C78 = {  "S4216C78", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S4216C78),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C77  {
  void *s4216c77f0;
  int s4216c77f1;
  ::S4216C78 s4216c77f2;
  ::S4216C78 s4216c77f3;
  void  mf4216c77(); // _ZN8S4216C779mf4216c77Ev
};
//SIG(-1 S4216C77) C1{ m Fp Fi FC2{ m} FC2}


void  S4216C77 ::mf4216c77(){}

static void Test_S4216C77()
{
  {
    init_simple_test("S4216C77");
    S4216C77 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S4216C77)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C77)");
    check_field_offset(lv, s4216c77f0, 0, "S4216C77.s4216c77f0");
    check_field_offset(lv, s4216c77f1, ABISELECT(8,4), "S4216C77.s4216c77f1");
    check_field_offset(lv, s4216c77f2, ABISELECT(12,8), "S4216C77.s4216c77f2");
    check_field_offset(lv, s4216c77f3, ABISELECT(13,9), "S4216C77.s4216c77f3");
  }
}
static Arrange_To_Call_Me vS4216C77(Test_S4216C77, "S4216C77", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C76  {
  ::S4216C77 s4216c76f0;
  void  mf4216c76(); // _ZN8S4216C769mf4216c76Ev
};
//SIG(-1 S4216C76) C1{ m FC2{ m Fp Fi FC3{ m} FC3}}


void  S4216C76 ::mf4216c76(){}

static void Test_S4216C76()
{
  {
    init_simple_test("S4216C76");
    S4216C76 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S4216C76)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C76)");
    check_field_offset(lv, s4216c76f0, 0, "S4216C76.s4216c76f0");
  }
}
static Arrange_To_Call_Me vS4216C76(Test_S4216C76, "S4216C76", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C75  {
  ::S4216C76 s4216c75f0;
  void *s4216c75f1[3];
  char s4216c75f2;
  virtual  ~S4216C75(); // _ZN8S4216C75D1Ev
  virtual void  v263(); // _ZN8S4216C754v263Ev
  S4216C75(); // tgen
};
//SIG(-1 S4216C75) C1{ vd v1 FC2{ m FC3{ m Fp Fi FC4{ m} FC4}} Fp[3] Fc}


 S4216C75 ::~S4216C75(){ note_dtor("S4216C75", this);}
void  S4216C75 ::v263(){vfunc_called(this, "_ZN8S4216C754v263Ev");}
S4216C75 ::S4216C75(){ note_ctor("S4216C75", this);} // tgen

static void Test_S4216C75()
{
  extern Class_Descriptor cd_S4216C75;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S4216C75, buf);
    S4216C75 *dp, &lv = *(dp=new (buf) S4216C75());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S4216C75)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C75)");
    check_field_offset(lv, s4216c75f0, ABISELECT(8,4), "S4216C75.s4216c75f0");
    check_field_offset(lv, s4216c75f1, ABISELECT(24,16), "S4216C75.s4216c75f1");
    check_field_offset(lv, s4216c75f2, ABISELECT(48,28), "S4216C75.s4216c75f2");
    test_class_info(&lv, &cd_S4216C75);
    dp->~S4216C75();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C75(Test_S4216C75, "S4216C75", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN8S4216C75C1Ev();
extern void _ZN8S4216C75D1Ev();
Name_Map name_map_S4216C75[] = {
  NSPAIR(_ZN8S4216C75C1Ev),
  NSPAIR(_ZN8S4216C75D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4216C75[];
extern void _ZN8S4216C75D1Ev();
extern void _ZN8S4216C75D0Ev();
extern void _ZN8S4216C754v263Ev();
static  VTBL_ENTRY vtc_S4216C75[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C75[0]),
  (VTBL_ENTRY)&_ZN8S4216C75D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C75D0Ev,
  (VTBL_ENTRY)&_ZN8S4216C754v263Ev,
};
extern VTBL_ENTRY _ZTI8S4216C75[];
extern  VTBL_ENTRY _ZTV8S4216C75[];
Class_Descriptor cd_S4216C75 = {  "S4216C75", // class name
  0,0,//no base classes
  &(vtc_S4216C75[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI8S4216C75),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4216C75),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C74  : S4216C75 {
  void *s4216c74f0;
  virtual void  v262(); // _ZN8S4216C744v262Ev
  ~S4216C74(); // tgen
  S4216C74(); // tgen
};
//SIG(-1 S4216C74) C1{ BC2{ vd v2 FC3{ m FC4{ m Fp Fi FC5{ m} FC5}} Fp[3] Fc} v1 Fp}


void  S4216C74 ::v262(){vfunc_called(this, "_ZN8S4216C744v262Ev");}
S4216C74 ::~S4216C74(){ note_dtor("S4216C74", this);} // tgen
S4216C74 ::S4216C74(){ note_ctor("S4216C74", this);} // tgen

static void Test_S4216C74()
{
  extern Class_Descriptor cd_S4216C74;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,10)];
    init_test(&cd_S4216C74, buf);
    S4216C74 *dp, &lv = *(dp=new (buf) S4216C74());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S4216C74)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C74)");
    check_base_class_offset(lv, (S4216C75*), 0, "S4216C74");
    check_field_offset(lv, s4216c74f0, ABISELECT(56,32), "S4216C74.s4216c74f0");
    test_class_info(&lv, &cd_S4216C74);
    dp->~S4216C74();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C74(Test_S4216C74, "S4216C74", ABISELECT(64,36));

#else // __cplusplus

extern void _ZN8S4216C74C1Ev();
extern void _ZN8S4216C74D1Ev();
Name_Map name_map_S4216C74[] = {
  NSPAIR(_ZN8S4216C74C1Ev),
  NSPAIR(_ZN8S4216C74D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C75;
extern VTBL_ENTRY _ZTI8S4216C75[];
extern  VTBL_ENTRY _ZTV8S4216C75[];
static Base_Class bases_S4216C74[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C75,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4216C74[];
extern void _ZN8S4216C74D1Ev();
extern void _ZN8S4216C74D0Ev();
extern void _ZN8S4216C754v263Ev();
extern void _ZN8S4216C744v262Ev();
static  VTBL_ENTRY vtc_S4216C74[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4216C74[0]),
  (VTBL_ENTRY)&_ZN8S4216C74D1Ev,
  (VTBL_ENTRY)&_ZN8S4216C74D0Ev,
  (VTBL_ENTRY)&_ZN8S4216C754v263Ev,
  (VTBL_ENTRY)&_ZN8S4216C744v262Ev,
};
extern VTBL_ENTRY _ZTI8S4216C74[];
extern  VTBL_ENTRY _ZTV8S4216C74[];
Class_Descriptor cd_S4216C74 = {  "S4216C74", // class name
  bases_S4216C74, 1,
  &(vtc_S4216C74[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,36), // object size
  NSPAIRA(_ZTI8S4216C74),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4216C74),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4216C1  : S4216C2 , S4216C8_nt , S4216C9 , S4216C10_nt , S4216C11 , S4216C16 {
  ::S4216C6_nt s4216c1f0;
  ::S4216C6_nt s4216c1f1;
  void *s4216c1f2[2];
  ::S4216C21 s4216c1f3;
  ::S4216C24 s4216c1f4;
  int s4216c1f5[3];
  char s4216c1f6;
  int s4216c1f7[2];
  ::S4216C25 s4216c1f8;
  ::S4216C74 s4216c1f9;
  int s4216c1f10[2];
  char s4216c1f11;
  int s4216c1f12;
  void *s4216c1f13;
  int s4216c1f14;
  char s4216c1f15;
  virtual  ~S4216C1(); // _ZN7S4216C1D1Ev
  virtual void  v1(); // _ZN7S4216C12v1Ev
  virtual void  v2(); // _ZN7S4216C12v2Ev
  virtual void  v3(); // _ZN7S4216C12v3Ev
  virtual void  v4(); // _ZN7S4216C12v4Ev
  virtual void  v5(); // _ZN7S4216C12v5Ev
  virtual void  v6(); // _ZN7S4216C12v6Ev
  virtual void  v7(); // _ZN7S4216C12v7Ev
  virtual void  v8(); // _ZN7S4216C12v8Ev
  virtual void  v9(); // _ZN7S4216C12v9Ev
  virtual void  v10(); // _ZN7S4216C13v10Ev
  virtual void  v11(); // _ZN7S4216C13v11Ev
  virtual void  v12(); // _ZN7S4216C13v12Ev
  virtual void  v13(); // _ZN7S4216C13v13Ev
  virtual void  v14(); // _ZN7S4216C13v14Ev
  virtual void  v15(); // _ZN7S4216C13v15Ev
  virtual void  v16(); // _ZN7S4216C13v16Ev
  virtual void  v17(); // _ZN7S4216C13v17Ev
  virtual void  v18(); // _ZN7S4216C13v18Ev
  virtual void  v19(); // _ZN7S4216C13v19Ev
  virtual void  v20(); // _ZN7S4216C13v20Ev
  virtual void  v21(); // _ZN7S4216C13v21Ev
  virtual void  v22(); // _ZN7S4216C13v22Ev
  virtual void  v23(); // _ZN7S4216C13v23Ev
  virtual void  v24(); // _ZN7S4216C13v24Ev
  virtual void  v25(); // _ZN7S4216C13v25Ev
  virtual void  v26(); // _ZN7S4216C13v26Ev
  virtual void  v27(); // _ZN7S4216C13v27Ev
  virtual void  v28(); // _ZN7S4216C13v28Ev
  virtual void  v29(); // _ZN7S4216C13v29Ev
  virtual void  v30(); // _ZN7S4216C13v30Ev
  virtual void  v31(); // _ZN7S4216C13v31Ev
  virtual void  v32(); // _ZN7S4216C13v32Ev
  virtual void  v33(); // _ZN7S4216C13v33Ev
  virtual void  v34(); // _ZN7S4216C13v34Ev
  virtual void  v35(); // _ZN7S4216C13v35Ev
  virtual void  v36(); // _ZN7S4216C13v36Ev
  virtual void  v37(); // _ZN7S4216C13v37Ev
  virtual void  v38(); // _ZN7S4216C13v38Ev
  virtual void  v39(); // _ZN7S4216C13v39Ev
  virtual void  v40(); // _ZN7S4216C13v40Ev
  virtual void  v41(); // _ZN7S4216C13v41Ev
  virtual void  v42(); // _ZN7S4216C13v42Ev
  virtual void  v43(); // _ZN7S4216C13v43Ev
  virtual void  v44(); // _ZN7S4216C13v44Ev
  virtual void  v45(); // _ZN7S4216C13v45Ev
  virtual void  v46(); // _ZN7S4216C13v46Ev
  virtual void  v47(); // _ZN7S4216C13v47Ev
  virtual void  v48(); // _ZN7S4216C13v48Ev
  virtual void  v49(); // _ZN7S4216C13v49Ev
  virtual void  v50(); // _ZN7S4216C13v50Ev
  virtual void  v51(); // _ZN7S4216C13v51Ev
  virtual void  v52(); // _ZN7S4216C13v52Ev
  virtual void  v53(); // _ZN7S4216C13v53Ev
  virtual void  v54(); // _ZN7S4216C13v54Ev
  virtual void  v55(); // _ZN7S4216C13v55Ev
  virtual void  v56(); // _ZN7S4216C13v56Ev
  virtual void  v57(); // _ZN7S4216C13v57Ev
  virtual void  v58(); // _ZN7S4216C13v58Ev
  virtual void  v59(); // _ZN7S4216C13v59Ev
  virtual void  v60(); // _ZN7S4216C13v60Ev
  virtual void  v61(); // _ZN7S4216C13v61Ev
  virtual void  v62(); // _ZN7S4216C13v62Ev
  virtual void  v63(); // _ZN7S4216C13v63Ev
  virtual void  v64(); // _ZN7S4216C13v64Ev
  virtual void  v65(); // _ZN7S4216C13v65Ev
  virtual void  v66(); // _ZN7S4216C13v66Ev
  virtual void  v67(); // _ZN7S4216C13v67Ev
  virtual void  v68(); // _ZN7S4216C13v68Ev
  virtual void  v69(); // _ZN7S4216C13v69Ev
  virtual void  v70(); // _ZN7S4216C13v70Ev
  virtual void  v71(); // _ZN7S4216C13v71Ev
  virtual void  v72(); // _ZN7S4216C13v72Ev
  virtual void  v73(); // _ZN7S4216C13v73Ev
  virtual void  v74(); // _ZN7S4216C13v74Ev
  virtual void  v75(); // _ZN7S4216C13v75Ev
  virtual void  v76(); // _ZN7S4216C13v76Ev
  virtual void  v77(); // _ZN7S4216C13v77Ev
  virtual void  v78(); // _ZN7S4216C13v78Ev
  virtual void  v79(); // _ZN7S4216C13v79Ev
  virtual void  v80(); // _ZN7S4216C13v80Ev
  virtual void  v81(); // _ZN7S4216C13v81Ev
  virtual void  v82(); // _ZN7S4216C13v82Ev
  virtual void  v83(); // _ZN7S4216C13v83Ev
  virtual void  v84(); // _ZN7S4216C13v84Ev
  virtual void  v85(); // _ZN7S4216C13v85Ev
  virtual void  v86(); // _ZN7S4216C13v86Ev
  virtual void  v87(); // _ZN7S4216C13v87Ev
  virtual void  v88(); // _ZN7S4216C13v88Ev
  virtual void  v89(); // _ZN7S4216C13v89Ev
  virtual void  v90(); // _ZN7S4216C13v90Ev
  virtual void  v91(); // _ZN7S4216C13v91Ev
  virtual void  v92(); // _ZN7S4216C13v92Ev
  virtual void  v93(); // _ZN7S4216C13v93Ev
  virtual void  v94(); // _ZN7S4216C13v94Ev
  virtual void  v95(); // _ZN7S4216C13v95Ev
  virtual void  v96(); // _ZN7S4216C13v96Ev
  virtual void  v97(); // _ZN7S4216C13v97Ev
  virtual void  v98(); // _ZN7S4216C13v98Ev
  virtual void  v99(); // _ZN7S4216C13v99Ev
  virtual void  v100(); // _ZN7S4216C14v100Ev
  virtual void  v101(); // _ZN7S4216C14v101Ev
  virtual void  v102(); // _ZN7S4216C14v102Ev
  virtual void  v103(); // _ZN7S4216C14v103Ev
  S4216C1(); // tgen
};
//SIG(1 S4216C1) C1{ BC2{ BC3{ vd v104 v105 v106} vd v107 v108 v109 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc} BC8{ vd v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124} BC9{ vd v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204} BC10{ vd v205} BC11{ vd m FC12{ BC13{ m Fp Fi FC5 FC14{ m}}}} BC15{ BC16{ BC17{ vd v206 Fi Fc[3]} vd v207 v208 v209 v210 v211 v212 v213 Fp[2] Fi} BC18{ vd v214 v215 v216} vd v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 FC6 FC6 Fp[2] FC19{ vd v227 Fi[2] Fs[2] Fi[3] FC20{ m Fp Fi FC14}} FC21{ vd v228 Fi} Fi[3] Fc Fi[2] FC22{ BC23{ vd m Fi Fc[2] FC24{ BC25{ vd v232 v233} vd v229 v230 v231 Fc[66]} FC20 FC26{ BC25 vd v234 FC20} FC26 FC26 Fc FC26 Fc Fi Fs FC26 FC26 FC21 FC19 FC27{ vd v235 Fi} FC28{ vd v236 Fs[2] Fc[6] Fs[2] Fc[6] FC20} FC28 FC29{ BC25 vd v237 FC20 FC20 FC20} Fc Fi[3] FC30{ BC25 vd v238 v239 FC28 FC20 FC20 FC20 FC31{ vd m Fi FC29 Fi} Fc FC32{ BC33{ m Fp Fi[2] FC34{ m}} BC25 vd v240 v241} FC20} Fi[2] FC35{ BC29 vd v242 v243 FC20 Fi Fc} Fi[2] FC36{ BC25 vd v244 FC28 FC20 Fi[2] FC27 Fi[2]} FC36 FC19 Fi[2] Fc[2] Fi[2] FC37{ m Fi} FC38{ BC25 vd v245 FC20} FC38 Fi[2] FC26 Fi FC39{ BC25 vd v246 FC26 FC26} Fc FC26 FC32 FC29 Fc FC35 Fc FC38 FC38 Fi Fc Fi FC37[55]} BC40{ vd m FC41{ BC25 vd v247 v248 Fi[4]}} BC2 vd Fp[2] FC6 Fp[5] FC28 FC6 FC12 FC42{ BC43{ m Fp Fi[2] FC34} BC25 vd v249 v250} FC42 FC44{ BC45{ m Fp Fi[2] FC46{ m}} BC25 vd v251 v252} FC47{ m FL Fi FL Fc FC4} FC32 FC44 Fi[2] Fp FC48{ m Fp Fi[2] FC46} Fc} FC49{ BC50{ vd v254 FC51{ m FC52{ m Fp Fi FC53{ m} FC53}} Fp[3] Fc} v253 Fp} Fi[2] Fc Fi Fp Fi Fc}


 S4216C1 ::~S4216C1(){ note_dtor("S4216C1", this);}
void  S4216C1 ::v1(){vfunc_called(this, "_ZN7S4216C12v1Ev");}
void  S4216C1 ::v2(){vfunc_called(this, "_ZN7S4216C12v2Ev");}
void  S4216C1 ::v3(){vfunc_called(this, "_ZN7S4216C12v3Ev");}
void  S4216C1 ::v4(){vfunc_called(this, "_ZN7S4216C12v4Ev");}
void  S4216C1 ::v5(){vfunc_called(this, "_ZN7S4216C12v5Ev");}
void  S4216C1 ::v6(){vfunc_called(this, "_ZN7S4216C12v6Ev");}
void  S4216C1 ::v7(){vfunc_called(this, "_ZN7S4216C12v7Ev");}
void  S4216C1 ::v8(){vfunc_called(this, "_ZN7S4216C12v8Ev");}
void  S4216C1 ::v9(){vfunc_called(this, "_ZN7S4216C12v9Ev");}
void  S4216C1 ::v10(){vfunc_called(this, "_ZN7S4216C13v10Ev");}
void  S4216C1 ::v11(){vfunc_called(this, "_ZN7S4216C13v11Ev");}
void  S4216C1 ::v12(){vfunc_called(this, "_ZN7S4216C13v12Ev");}
void  S4216C1 ::v13(){vfunc_called(this, "_ZN7S4216C13v13Ev");}
void  S4216C1 ::v14(){vfunc_called(this, "_ZN7S4216C13v14Ev");}
void  S4216C1 ::v15(){vfunc_called(this, "_ZN7S4216C13v15Ev");}
void  S4216C1 ::v16(){vfunc_called(this, "_ZN7S4216C13v16Ev");}
void  S4216C1 ::v17(){vfunc_called(this, "_ZN7S4216C13v17Ev");}
void  S4216C1 ::v18(){vfunc_called(this, "_ZN7S4216C13v18Ev");}
void  S4216C1 ::v19(){vfunc_called(this, "_ZN7S4216C13v19Ev");}
void  S4216C1 ::v20(){vfunc_called(this, "_ZN7S4216C13v20Ev");}
void  S4216C1 ::v21(){vfunc_called(this, "_ZN7S4216C13v21Ev");}
void  S4216C1 ::v22(){vfunc_called(this, "_ZN7S4216C13v22Ev");}
void  S4216C1 ::v23(){vfunc_called(this, "_ZN7S4216C13v23Ev");}
void  S4216C1 ::v24(){vfunc_called(this, "_ZN7S4216C13v24Ev");}
void  S4216C1 ::v25(){vfunc_called(this, "_ZN7S4216C13v25Ev");}
void  S4216C1 ::v26(){vfunc_called(this, "_ZN7S4216C13v26Ev");}
void  S4216C1 ::v27(){vfunc_called(this, "_ZN7S4216C13v27Ev");}
void  S4216C1 ::v28(){vfunc_called(this, "_ZN7S4216C13v28Ev");}
void  S4216C1 ::v29(){vfunc_called(this, "_ZN7S4216C13v29Ev");}
void  S4216C1 ::v30(){vfunc_called(this, "_ZN7S4216C13v30Ev");}
void  S4216C1 ::v31(){vfunc_called(this, "_ZN7S4216C13v31Ev");}
void  S4216C1 ::v32(){vfunc_called(this, "_ZN7S4216C13v32Ev");}
void  S4216C1 ::v33(){vfunc_called(this, "_ZN7S4216C13v33Ev");}
void  S4216C1 ::v34(){vfunc_called(this, "_ZN7S4216C13v34Ev");}
void  S4216C1 ::v35(){vfunc_called(this, "_ZN7S4216C13v35Ev");}
void  S4216C1 ::v36(){vfunc_called(this, "_ZN7S4216C13v36Ev");}
void  S4216C1 ::v37(){vfunc_called(this, "_ZN7S4216C13v37Ev");}
void  S4216C1 ::v38(){vfunc_called(this, "_ZN7S4216C13v38Ev");}
void  S4216C1 ::v39(){vfunc_called(this, "_ZN7S4216C13v39Ev");}
void  S4216C1 ::v40(){vfunc_called(this, "_ZN7S4216C13v40Ev");}
void  S4216C1 ::v41(){vfunc_called(this, "_ZN7S4216C13v41Ev");}
void  S4216C1 ::v42(){vfunc_called(this, "_ZN7S4216C13v42Ev");}
void  S4216C1 ::v43(){vfunc_called(this, "_ZN7S4216C13v43Ev");}
void  S4216C1 ::v44(){vfunc_called(this, "_ZN7S4216C13v44Ev");}
void  S4216C1 ::v45(){vfunc_called(this, "_ZN7S4216C13v45Ev");}
void  S4216C1 ::v46(){vfunc_called(this, "_ZN7S4216C13v46Ev");}
void  S4216C1 ::v47(){vfunc_called(this, "_ZN7S4216C13v47Ev");}
void  S4216C1 ::v48(){vfunc_called(this, "_ZN7S4216C13v48Ev");}
void  S4216C1 ::v49(){vfunc_called(this, "_ZN7S4216C13v49Ev");}
void  S4216C1 ::v50(){vfunc_called(this, "_ZN7S4216C13v50Ev");}
void  S4216C1 ::v51(){vfunc_called(this, "_ZN7S4216C13v51Ev");}
void  S4216C1 ::v52(){vfunc_called(this, "_ZN7S4216C13v52Ev");}
void  S4216C1 ::v53(){vfunc_called(this, "_ZN7S4216C13v53Ev");}
void  S4216C1 ::v54(){vfunc_called(this, "_ZN7S4216C13v54Ev");}
void  S4216C1 ::v55(){vfunc_called(this, "_ZN7S4216C13v55Ev");}
void  S4216C1 ::v56(){vfunc_called(this, "_ZN7S4216C13v56Ev");}
void  S4216C1 ::v57(){vfunc_called(this, "_ZN7S4216C13v57Ev");}
void  S4216C1 ::v58(){vfunc_called(this, "_ZN7S4216C13v58Ev");}
void  S4216C1 ::v59(){vfunc_called(this, "_ZN7S4216C13v59Ev");}
void  S4216C1 ::v60(){vfunc_called(this, "_ZN7S4216C13v60Ev");}
void  S4216C1 ::v61(){vfunc_called(this, "_ZN7S4216C13v61Ev");}
void  S4216C1 ::v62(){vfunc_called(this, "_ZN7S4216C13v62Ev");}
void  S4216C1 ::v63(){vfunc_called(this, "_ZN7S4216C13v63Ev");}
void  S4216C1 ::v64(){vfunc_called(this, "_ZN7S4216C13v64Ev");}
void  S4216C1 ::v65(){vfunc_called(this, "_ZN7S4216C13v65Ev");}
void  S4216C1 ::v66(){vfunc_called(this, "_ZN7S4216C13v66Ev");}
void  S4216C1 ::v67(){vfunc_called(this, "_ZN7S4216C13v67Ev");}
void  S4216C1 ::v68(){vfunc_called(this, "_ZN7S4216C13v68Ev");}
void  S4216C1 ::v69(){vfunc_called(this, "_ZN7S4216C13v69Ev");}
void  S4216C1 ::v70(){vfunc_called(this, "_ZN7S4216C13v70Ev");}
void  S4216C1 ::v71(){vfunc_called(this, "_ZN7S4216C13v71Ev");}
void  S4216C1 ::v72(){vfunc_called(this, "_ZN7S4216C13v72Ev");}
void  S4216C1 ::v73(){vfunc_called(this, "_ZN7S4216C13v73Ev");}
void  S4216C1 ::v74(){vfunc_called(this, "_ZN7S4216C13v74Ev");}
void  S4216C1 ::v75(){vfunc_called(this, "_ZN7S4216C13v75Ev");}
void  S4216C1 ::v76(){vfunc_called(this, "_ZN7S4216C13v76Ev");}
void  S4216C1 ::v77(){vfunc_called(this, "_ZN7S4216C13v77Ev");}
void  S4216C1 ::v78(){vfunc_called(this, "_ZN7S4216C13v78Ev");}
void  S4216C1 ::v79(){vfunc_called(this, "_ZN7S4216C13v79Ev");}
void  S4216C1 ::v80(){vfunc_called(this, "_ZN7S4216C13v80Ev");}
void  S4216C1 ::v81(){vfunc_called(this, "_ZN7S4216C13v81Ev");}
void  S4216C1 ::v82(){vfunc_called(this, "_ZN7S4216C13v82Ev");}
void  S4216C1 ::v83(){vfunc_called(this, "_ZN7S4216C13v83Ev");}
void  S4216C1 ::v84(){vfunc_called(this, "_ZN7S4216C13v84Ev");}
void  S4216C1 ::v85(){vfunc_called(this, "_ZN7S4216C13v85Ev");}
void  S4216C1 ::v86(){vfunc_called(this, "_ZN7S4216C13v86Ev");}
void  S4216C1 ::v87(){vfunc_called(this, "_ZN7S4216C13v87Ev");}
void  S4216C1 ::v88(){vfunc_called(this, "_ZN7S4216C13v88Ev");}
void  S4216C1 ::v89(){vfunc_called(this, "_ZN7S4216C13v89Ev");}
void  S4216C1 ::v90(){vfunc_called(this, "_ZN7S4216C13v90Ev");}
void  S4216C1 ::v91(){vfunc_called(this, "_ZN7S4216C13v91Ev");}
void  S4216C1 ::v92(){vfunc_called(this, "_ZN7S4216C13v92Ev");}
void  S4216C1 ::v93(){vfunc_called(this, "_ZN7S4216C13v93Ev");}
void  S4216C1 ::v94(){vfunc_called(this, "_ZN7S4216C13v94Ev");}
void  S4216C1 ::v95(){vfunc_called(this, "_ZN7S4216C13v95Ev");}
void  S4216C1 ::v96(){vfunc_called(this, "_ZN7S4216C13v96Ev");}
void  S4216C1 ::v97(){vfunc_called(this, "_ZN7S4216C13v97Ev");}
void  S4216C1 ::v98(){vfunc_called(this, "_ZN7S4216C13v98Ev");}
void  S4216C1 ::v99(){vfunc_called(this, "_ZN7S4216C13v99Ev");}
void  S4216C1 ::v100(){vfunc_called(this, "_ZN7S4216C14v100Ev");}
void  S4216C1 ::v101(){vfunc_called(this, "_ZN7S4216C14v101Ev");}
void  S4216C1 ::v102(){vfunc_called(this, "_ZN7S4216C14v102Ev");}
void  S4216C1 ::v103(){vfunc_called(this, "_ZN7S4216C14v103Ev");}
S4216C1 ::S4216C1(){ note_ctor("S4216C1", this);} // tgen

static void Test_S4216C1()
{
  extern Class_Descriptor cd_S4216C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(348,495)];
    init_test(&cd_S4216C1, buf);
    S4216C1 *dp, &lv = *(dp=new (buf) S4216C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2776,1976), "sizeof(S4216C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4216C1)");
    check_base_class_offset(lv, (S4216C3_nt*)(S4216C2*), 0, "S4216C1");
    check_base_class_offset(lv, (S4216C2*), 0, "S4216C1");
    check_base_class_offset(lv, (S4216C8_nt*), ABISELECT(72,40), "S4216C1");
    check_base_class_offset(lv, (S4216C9*), ABISELECT(80,44), "S4216C1");
    check_base_class_offset(lv, (S4216C10_nt*), ABISELECT(88,48), "S4216C1");
    check_base_class_offset(lv, (S4216C11*), ABISELECT(96,52), "S4216C1");
    check_base_class_offset(lv, (S4216C18_nt*)(S4216C17*)(S4216C16*), ABISELECT(120,68), "S4216C1");
    check_base_class_offset(lv, (S4216C17*)(S4216C16*), ABISELECT(120,68), "S4216C1");
    check_base_class_offset(lv, (S4216C19*)(S4216C16*), ABISELECT(160,92), "S4216C1");
    check_base_class_offset(lv, (S4216C16*), ABISELECT(120,68), "S4216C1");
    check_field_offset(lv, s4216c1f0, ABISELECT(176,100), "S4216C1.s4216c1f0");
    check_field_offset(lv, s4216c1f1, ABISELECT(208,116), "S4216C1.s4216c1f1");
    check_field_offset(lv, s4216c1f2, ABISELECT(240,132), "S4216C1.s4216c1f2");
    check_field_offset(lv, s4216c1f3, ABISELECT(256,140), "S4216C1.s4216c1f3");
    check_field_offset(lv, s4216c1f4, ABISELECT(304,180), "S4216C1.s4216c1f4");
    check_field_offset(lv, s4216c1f5, ABISELECT(320,188), "S4216C1.s4216c1f5");
    check_field_offset(lv, s4216c1f6, ABISELECT(332,200), "S4216C1.s4216c1f6");
    check_field_offset(lv, s4216c1f7, ABISELECT(336,204), "S4216C1.s4216c1f7");
    check_field_offset(lv, s4216c1f8, ABISELECT(344,212), "S4216C1.s4216c1f8");
    check_field_offset(lv, s4216c1f9, ABISELECT(2680,1912), "S4216C1.s4216c1f9");
    check_field_offset(lv, s4216c1f10, ABISELECT(2744,1948), "S4216C1.s4216c1f10");
    check_field_offset(lv, s4216c1f11, ABISELECT(2752,1956), "S4216C1.s4216c1f11");
    check_field_offset(lv, s4216c1f12, ABISELECT(2756,1960), "S4216C1.s4216c1f12");
    check_field_offset(lv, s4216c1f13, ABISELECT(2760,1964), "S4216C1.s4216c1f13");
    check_field_offset(lv, s4216c1f14, ABISELECT(2768,1968), "S4216C1.s4216c1f14");
    check_field_offset(lv, s4216c1f15, ABISELECT(2772,1972), "S4216C1.s4216c1f15");
    test_class_info(&lv, &cd_S4216C1);
    dp->~S4216C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4216C1(Test_S4216C1, "S4216C1", ABISELECT(2776,1976));

#else // __cplusplus

extern void _ZN7S4216C1C1Ev();
extern void _ZN7S4216C1D1Ev();
Name_Map name_map_S4216C1[] = {
  NSPAIR(_ZN7S4216C1C1Ev),
  NSPAIR(_ZN7S4216C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C3_nt;
extern VTBL_ENTRY _ZTI10S4216C3_nt[];
extern  VTBL_ENTRY _ZTV10S4216C3_nt[];
extern Class_Descriptor cd_S4216C2;
extern VTBL_ENTRY _ZTI7S4216C2[];
extern  VTBL_ENTRY _ZTV7S4216C2[];
extern Class_Descriptor cd_S4216C8_nt;
extern VTBL_ENTRY _ZTI10S4216C8_nt[];
extern  VTBL_ENTRY _ZTV10S4216C8_nt[];
extern Class_Descriptor cd_S4216C9;
extern VTBL_ENTRY _ZTI7S4216C9[];
extern  VTBL_ENTRY _ZTV7S4216C9[];
extern Class_Descriptor cd_S4216C10_nt;
extern VTBL_ENTRY _ZTI11S4216C10_nt[];
extern  VTBL_ENTRY _ZTV11S4216C10_nt[];
extern Class_Descriptor cd_S4216C11;
extern VTBL_ENTRY _ZTI8S4216C11[];
extern  VTBL_ENTRY _ZTV8S4216C11[];
extern Class_Descriptor cd_S4216C18_nt;
extern VTBL_ENTRY _ZTI11S4216C18_nt[];
extern  VTBL_ENTRY _ZTV11S4216C18_nt[];
extern Class_Descriptor cd_S4216C17;
extern VTBL_ENTRY _ZTI8S4216C17[];
extern  VTBL_ENTRY _ZTV8S4216C17[];
extern Class_Descriptor cd_S4216C19;
extern VTBL_ENTRY _ZTI8S4216C19[];
extern  VTBL_ENTRY _ZTV8S4216C19[];
extern Class_Descriptor cd_S4216C16;
extern VTBL_ENTRY _ZTI8S4216C16[];
extern  VTBL_ENTRY _ZTV8S4216C16[];
static Base_Class bases_S4216C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4216C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C8_nt,    ABISELECT(72,40), //bcp->offset
    113, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C9,    ABISELECT(80,44), //bcp->offset
    132, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C10_nt,    ABISELECT(88,48), //bcp->offset
    216, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C11,    ABISELECT(96,52), //bcp->offset
    221, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C18_nt,    ABISELECT(120,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S4216C17,    ABISELECT(120,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S4216C19,    ABISELECT(160,92), //bcp->offset
    247, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S4216C16,    ABISELECT(120,68), //bcp->offset
    225, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4216C1[];
extern void _ZN7S4216C1D1Ev();
extern void _ZN7S4216C1D0Ev();
extern void _ZN10S4216C3_nt4v104Ev();
extern void _ZN10S4216C3_nt4v105Ev();
extern void _ZN10S4216C3_nt4v106Ev();
extern void _ZN7S4216C24v107Ev();
extern void _ZN7S4216C24v108Ev();
extern void _ZN7S4216C24v109Ev();
extern void _ZN7S4216C12v1Ev();
extern void _ZN7S4216C12v2Ev();
extern void _ZN7S4216C12v3Ev();
extern void _ZN7S4216C12v4Ev();
extern void _ZN7S4216C12v5Ev();
extern void _ZN7S4216C12v6Ev();
extern void _ZN7S4216C12v7Ev();
extern void _ZN7S4216C12v8Ev();
extern void _ZN7S4216C12v9Ev();
extern void _ZN7S4216C13v10Ev();
extern void _ZN7S4216C13v11Ev();
extern void _ZN7S4216C13v12Ev();
extern void _ZN7S4216C13v13Ev();
extern void _ZN7S4216C13v14Ev();
extern void _ZN7S4216C13v15Ev();
extern void _ZN7S4216C13v16Ev();
extern void _ZN7S4216C13v17Ev();
extern void _ZN7S4216C13v18Ev();
extern void _ZN7S4216C13v19Ev();
extern void _ZN7S4216C13v20Ev();
extern void _ZN7S4216C13v21Ev();
extern void _ZN7S4216C13v22Ev();
extern void _ZN7S4216C13v23Ev();
extern void _ZN7S4216C13v24Ev();
extern void _ZN7S4216C13v25Ev();
extern void _ZN7S4216C13v26Ev();
extern void _ZN7S4216C13v27Ev();
extern void _ZN7S4216C13v28Ev();
extern void _ZN7S4216C13v29Ev();
extern void _ZN7S4216C13v30Ev();
extern void _ZN7S4216C13v31Ev();
extern void _ZN7S4216C13v32Ev();
extern void _ZN7S4216C13v33Ev();
extern void _ZN7S4216C13v34Ev();
extern void _ZN7S4216C13v35Ev();
extern void _ZN7S4216C13v36Ev();
extern void _ZN7S4216C13v37Ev();
extern void _ZN7S4216C13v38Ev();
extern void _ZN7S4216C13v39Ev();
extern void _ZN7S4216C13v40Ev();
extern void _ZN7S4216C13v41Ev();
extern void _ZN7S4216C13v42Ev();
extern void _ZN7S4216C13v43Ev();
extern void _ZN7S4216C13v44Ev();
extern void _ZN7S4216C13v45Ev();
extern void _ZN7S4216C13v46Ev();
extern void _ZN7S4216C13v47Ev();
extern void _ZN7S4216C13v48Ev();
extern void _ZN7S4216C13v49Ev();
extern void _ZN7S4216C13v50Ev();
extern void _ZN7S4216C13v51Ev();
extern void _ZN7S4216C13v52Ev();
extern void _ZN7S4216C13v53Ev();
extern void _ZN7S4216C13v54Ev();
extern void _ZN7S4216C13v55Ev();
extern void _ZN7S4216C13v56Ev();
extern void _ZN7S4216C13v57Ev();
extern void _ZN7S4216C13v58Ev();
extern void _ZN7S4216C13v59Ev();
extern void _ZN7S4216C13v60Ev();
extern void _ZN7S4216C13v61Ev();
extern void _ZN7S4216C13v62Ev();
extern void _ZN7S4216C13v63Ev();
extern void _ZN7S4216C13v64Ev();
extern void _ZN7S4216C13v65Ev();
extern void _ZN7S4216C13v66Ev();
extern void _ZN7S4216C13v67Ev();
extern void _ZN7S4216C13v68Ev();
extern void _ZN7S4216C13v69Ev();
extern void _ZN7S4216C13v70Ev();
extern void _ZN7S4216C13v71Ev();
extern void _ZN7S4216C13v72Ev();
extern void _ZN7S4216C13v73Ev();
extern void _ZN7S4216C13v74Ev();
extern void _ZN7S4216C13v75Ev();
extern void _ZN7S4216C13v76Ev();
extern void _ZN7S4216C13v77Ev();
extern void _ZN7S4216C13v78Ev();
extern void _ZN7S4216C13v79Ev();
extern void _ZN7S4216C13v80Ev();
extern void _ZN7S4216C13v81Ev();
extern void _ZN7S4216C13v82Ev();
extern void _ZN7S4216C13v83Ev();
extern void _ZN7S4216C13v84Ev();
extern void _ZN7S4216C13v85Ev();
extern void _ZN7S4216C13v86Ev();
extern void _ZN7S4216C13v87Ev();
extern void _ZN7S4216C13v88Ev();
extern void _ZN7S4216C13v89Ev();
extern void _ZN7S4216C13v90Ev();
extern void _ZN7S4216C13v91Ev();
extern void _ZN7S4216C13v92Ev();
extern void _ZN7S4216C13v93Ev();
extern void _ZN7S4216C13v94Ev();
extern void _ZN7S4216C13v95Ev();
extern void _ZN7S4216C13v96Ev();
extern void _ZN7S4216C13v97Ev();
extern void _ZN7S4216C13v98Ev();
extern void _ZN7S4216C13v99Ev();
extern void _ZN7S4216C14v100Ev();
extern void _ZN7S4216C14v101Ev();
extern void _ZN7S4216C14v102Ev();
extern void _ZN7S4216C14v103Ev();
extern void ABISELECT(_ZThn72_N7S4216C1D1Ev,_ZThn40_N7S4216C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S4216C1D0Ev,_ZThn40_N7S4216C1D0Ev)();
extern void _ZN10S4216C8_nt4v110Ev();
extern void _ZN10S4216C8_nt4v111Ev();
extern void _ZN10S4216C8_nt4v112Ev();
extern void _ZN10S4216C8_nt4v113Ev();
extern void _ZN10S4216C8_nt4v114Ev();
extern void _ZN10S4216C8_nt4v115Ev();
extern void _ZN10S4216C8_nt4v116Ev();
extern void _ZN10S4216C8_nt4v117Ev();
extern void _ZN10S4216C8_nt4v118Ev();
extern void _ZN10S4216C8_nt4v119Ev();
extern void _ZN10S4216C8_nt4v120Ev();
extern void _ZN10S4216C8_nt4v121Ev();
extern void _ZN10S4216C8_nt4v122Ev();
extern void _ZN10S4216C8_nt4v123Ev();
extern void _ZN10S4216C8_nt4v124Ev();
extern void ABISELECT(_ZThn80_N7S4216C1D1Ev,_ZThn44_N7S4216C1D1Ev)();
extern void ABISELECT(_ZThn80_N7S4216C1D0Ev,_ZThn44_N7S4216C1D0Ev)();
extern void _ZN7S4216C94v125Ev();
extern void _ZN7S4216C94v126Ev();
extern void _ZN7S4216C94v127Ev();
extern void _ZN7S4216C94v128Ev();
extern void _ZN7S4216C94v129Ev();
extern void _ZN7S4216C94v130Ev();
extern void _ZN7S4216C94v131Ev();
extern void _ZN7S4216C94v132Ev();
extern void _ZN7S4216C94v133Ev();
extern void _ZN7S4216C94v134Ev();
extern void _ZN7S4216C94v135Ev();
extern void _ZN7S4216C94v136Ev();
extern void _ZN7S4216C94v137Ev();
extern void _ZN7S4216C94v138Ev();
extern void _ZN7S4216C94v139Ev();
extern void _ZN7S4216C94v140Ev();
extern void _ZN7S4216C94v141Ev();
extern void _ZN7S4216C94v142Ev();
extern void _ZN7S4216C94v143Ev();
extern void _ZN7S4216C94v144Ev();
extern void _ZN7S4216C94v145Ev();
extern void _ZN7S4216C94v146Ev();
extern void _ZN7S4216C94v147Ev();
extern void _ZN7S4216C94v148Ev();
extern void _ZN7S4216C94v149Ev();
extern void _ZN7S4216C94v150Ev();
extern void _ZN7S4216C94v151Ev();
extern void _ZN7S4216C94v152Ev();
extern void _ZN7S4216C94v153Ev();
extern void _ZN7S4216C94v154Ev();
extern void _ZN7S4216C94v155Ev();
extern void _ZN7S4216C94v156Ev();
extern void _ZN7S4216C94v157Ev();
extern void _ZN7S4216C94v158Ev();
extern void _ZN7S4216C94v159Ev();
extern void _ZN7S4216C94v160Ev();
extern void _ZN7S4216C94v161Ev();
extern void _ZN7S4216C94v162Ev();
extern void _ZN7S4216C94v163Ev();
extern void _ZN7S4216C94v164Ev();
extern void _ZN7S4216C94v165Ev();
extern void _ZN7S4216C94v166Ev();
extern void _ZN7S4216C94v167Ev();
extern void _ZN7S4216C94v168Ev();
extern void _ZN7S4216C94v169Ev();
extern void _ZN7S4216C94v170Ev();
extern void _ZN7S4216C94v171Ev();
extern void _ZN7S4216C94v172Ev();
extern void _ZN7S4216C94v173Ev();
extern void _ZN7S4216C94v174Ev();
extern void _ZN7S4216C94v175Ev();
extern void _ZN7S4216C94v176Ev();
extern void _ZN7S4216C94v177Ev();
extern void _ZN7S4216C94v178Ev();
extern void _ZN7S4216C94v179Ev();
extern void _ZN7S4216C94v180Ev();
extern void _ZN7S4216C94v181Ev();
extern void _ZN7S4216C94v182Ev();
extern void _ZN7S4216C94v183Ev();
extern void _ZN7S4216C94v184Ev();
extern void _ZN7S4216C94v185Ev();
extern void _ZN7S4216C94v186Ev();
extern void _ZN7S4216C94v187Ev();
extern void _ZN7S4216C94v188Ev();
extern void _ZN7S4216C94v189Ev();
extern void _ZN7S4216C94v190Ev();
extern void _ZN7S4216C94v191Ev();
extern void _ZN7S4216C94v192Ev();
extern void _ZN7S4216C94v193Ev();
extern void _ZN7S4216C94v194Ev();
extern void _ZN7S4216C94v195Ev();
extern void _ZN7S4216C94v196Ev();
extern void _ZN7S4216C94v197Ev();
extern void _ZN7S4216C94v198Ev();
extern void _ZN7S4216C94v199Ev();
extern void _ZN7S4216C94v200Ev();
extern void _ZN7S4216C94v201Ev();
extern void _ZN7S4216C94v202Ev();
extern void _ZN7S4216C94v203Ev();
extern void _ZN7S4216C94v204Ev();
extern void ABISELECT(_ZThn88_N7S4216C1D1Ev,_ZThn48_N7S4216C1D1Ev)();
extern void ABISELECT(_ZThn88_N7S4216C1D0Ev,_ZThn48_N7S4216C1D0Ev)();
extern void _ZN11S4216C10_nt4v205Ev();
extern void ABISELECT(_ZThn96_N7S4216C1D1Ev,_ZThn52_N7S4216C1D1Ev)();
extern void ABISELECT(_ZThn96_N7S4216C1D0Ev,_ZThn52_N7S4216C1D0Ev)();
extern void ABISELECT(_ZThn120_N7S4216C1D1Ev,_ZThn68_N7S4216C1D1Ev)();
extern void ABISELECT(_ZThn120_N7S4216C1D0Ev,_ZThn68_N7S4216C1D0Ev)();
extern void _ZN11S4216C18_nt4v206Ev();
extern void _ZN8S4216C174v207Ev();
extern void _ZN8S4216C174v208Ev();
extern void _ZN8S4216C174v209Ev();
extern void _ZN8S4216C174v210Ev();
extern void _ZN8S4216C174v211Ev();
extern void _ZN8S4216C174v212Ev();
extern void _ZN8S4216C174v213Ev();
extern void _ZN8S4216C164v217Ev();
extern void _ZN8S4216C164v218Ev();
extern void _ZN8S4216C164v219Ev();
extern void _ZN8S4216C164v220Ev();
extern void _ZN8S4216C164v221Ev();
extern void _ZN8S4216C164v222Ev();
extern void _ZN8S4216C164v223Ev();
extern void _ZN8S4216C164v224Ev();
extern void _ZN8S4216C164v225Ev();
extern void _ZN8S4216C164v226Ev();
extern void ABISELECT(_ZThn160_N7S4216C1D1Ev,_ZThn92_N7S4216C1D1Ev)();
extern void ABISELECT(_ZThn160_N7S4216C1D0Ev,_ZThn92_N7S4216C1D0Ev)();
extern void _ZN8S4216C194v214Ev();
extern void _ZN8S4216C194v215Ev();
extern void _ZN8S4216C194v216Ev();
static  VTBL_ENTRY vtc_S4216C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4216C1[0]),
  (VTBL_ENTRY)&_ZN7S4216C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4216C1D0Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S4216C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN7S4216C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4216C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4216C24v109Ev,
  (VTBL_ENTRY)&_ZN7S4216C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4216C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4216C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4216C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4216C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4216C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4216C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4216C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4216C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v12Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v13Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v14Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v15Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v16Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v17Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v18Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v19Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v20Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v21Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v22Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v23Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v24Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v25Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v26Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v27Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v28Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v29Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v30Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v31Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v32Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v33Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v34Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v35Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v36Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v37Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v38Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v39Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v40Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v41Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v42Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v43Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v44Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v45Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v46Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v47Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v48Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v49Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v50Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v51Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v52Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v53Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v54Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v55Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v56Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v57Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v58Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v59Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v60Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v61Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v62Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v63Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v64Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v65Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v66Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v67Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v68Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v69Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v70Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v71Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v72Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v73Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v74Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v75Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v76Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v77Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v78Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v79Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v80Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v81Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v82Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v83Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v84Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v85Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v86Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v87Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v88Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v89Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v90Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v91Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v92Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v93Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v94Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v95Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v96Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v97Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v98Ev,
  (VTBL_ENTRY)&_ZN7S4216C13v99Ev,
  (VTBL_ENTRY)&_ZN7S4216C14v100Ev,
  (VTBL_ENTRY)&_ZN7S4216C14v101Ev,
  (VTBL_ENTRY)&_ZN7S4216C14v102Ev,
  (VTBL_ENTRY)&_ZN7S4216C14v103Ev,
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI7S4216C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S4216C1D1Ev,_ZThn40_N7S4216C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S4216C1D0Ev,_ZThn40_N7S4216C1D0Ev),
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S4216C8_nt4v124Ev,
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI7S4216C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N7S4216C1D1Ev,_ZThn44_N7S4216C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N7S4216C1D0Ev,_ZThn44_N7S4216C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4216C94v125Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v126Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v127Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v128Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v129Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v130Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v131Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v132Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v133Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v134Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v135Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v136Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v137Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v138Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v139Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v140Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v141Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v142Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v143Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v144Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v145Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v146Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v147Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v148Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v149Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v150Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v151Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v152Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v153Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v154Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v155Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v156Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v157Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v158Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v159Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v160Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v161Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v162Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v163Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v164Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v165Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v166Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v167Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v168Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v169Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v170Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v171Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v172Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v173Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v174Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v175Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v176Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v177Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v178Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v179Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v180Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v181Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v182Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v183Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v184Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v185Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v186Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v187Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v188Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v189Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v190Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v191Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v192Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v193Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v194Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v195Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v196Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v197Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v198Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v199Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v200Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v201Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v202Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v203Ev,
  (VTBL_ENTRY)&_ZN7S4216C94v204Ev,
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI7S4216C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N7S4216C1D1Ev,_ZThn48_N7S4216C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N7S4216C1D0Ev,_ZThn48_N7S4216C1D0Ev),
  (VTBL_ENTRY)&_ZN11S4216C10_nt4v205Ev,
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI7S4216C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S4216C1D1Ev,_ZThn52_N7S4216C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S4216C1D0Ev,_ZThn52_N7S4216C1D0Ev),
  ABISELECT(-120,-68),
  (VTBL_ENTRY)&(_ZTI7S4216C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn120_N7S4216C1D1Ev,_ZThn68_N7S4216C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn120_N7S4216C1D0Ev,_ZThn68_N7S4216C1D0Ev),
  (VTBL_ENTRY)&_ZN11S4216C18_nt4v206Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v207Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v208Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v209Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v210Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v211Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v212Ev,
  (VTBL_ENTRY)&_ZN8S4216C174v213Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v217Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v218Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v219Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v220Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v221Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v222Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v223Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v224Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v225Ev,
  (VTBL_ENTRY)&_ZN8S4216C164v226Ev,
  ABISELECT(-160,-92),
  (VTBL_ENTRY)&(_ZTI7S4216C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N7S4216C1D1Ev,_ZThn92_N7S4216C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N7S4216C1D0Ev,_ZThn92_N7S4216C1D0Ev),
  (VTBL_ENTRY)&_ZN8S4216C194v214Ev,
  (VTBL_ENTRY)&_ZN8S4216C194v215Ev,
  (VTBL_ENTRY)&_ZN8S4216C194v216Ev,
};
extern VTBL_ENTRY _ZTI7S4216C1[];
extern  VTBL_ENTRY _ZTV7S4216C1[];
Class_Descriptor cd_S4216C1 = {  "S4216C1", // class name
  bases_S4216C1, 10,
  &(vtc_S4216C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2776,1976), // object size
  NSPAIRA(_ZTI7S4216C1),ABISELECT(120,64), //typeinfo_var
  NSPAIRA(_ZTV7S4216C1),254, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  10, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C3  {
  virtual  ~S4217C3(); // _ZN7S4217C3D1Ev
  virtual void  v104(); // _ZN7S4217C34v104Ev
  virtual void  v105(); // _ZN7S4217C34v105Ev
  virtual void  v106(); // _ZN7S4217C34v106Ev
  S4217C3(); // tgen
};
//SIG(-1 S4217C3) C1{ vd v1 v2 v3}


 S4217C3 ::~S4217C3(){ note_dtor("S4217C3", this);}
void  S4217C3 ::v104(){vfunc_called(this, "_ZN7S4217C34v104Ev");}
void  S4217C3 ::v105(){vfunc_called(this, "_ZN7S4217C34v105Ev");}
void  S4217C3 ::v106(){vfunc_called(this, "_ZN7S4217C34v106Ev");}
S4217C3 ::S4217C3(){ note_ctor("S4217C3", this);} // tgen

static void Test_S4217C3()
{
  extern Class_Descriptor cd_S4217C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4217C3, buf);
    S4217C3 *dp, &lv = *(dp=new (buf) S4217C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4217C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C3)");
    test_class_info(&lv, &cd_S4217C3);
    dp->~S4217C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C3(Test_S4217C3, "S4217C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4217C3C1Ev();
extern void _ZN7S4217C3D1Ev();
Name_Map name_map_S4217C3[] = {
  NSPAIR(_ZN7S4217C3C1Ev),
  NSPAIR(_ZN7S4217C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4217C3[];
extern void _ZN7S4217C3D1Ev();
extern void _ZN7S4217C3D0Ev();
extern void _ZN7S4217C34v104Ev();
extern void _ZN7S4217C34v105Ev();
extern void _ZN7S4217C34v106Ev();
static  VTBL_ENTRY vtc_S4217C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4217C3[0]),
  (VTBL_ENTRY)&_ZN7S4217C3D1Ev,
  (VTBL_ENTRY)&_ZN7S4217C3D0Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v104Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v105Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v106Ev,
};
extern VTBL_ENTRY _ZTI7S4217C3[];
extern  VTBL_ENTRY _ZTV7S4217C3[];
Class_Descriptor cd_S4217C3 = {  "S4217C3", // class name
  0,0,//no base classes
  &(vtc_S4217C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4217C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4217C3),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C7_nt  {
  __tsi64 s4217c7f0[4];
};
//SIG(-1 S4217C7_nt) C1{ FL[4]}



//skip512 S4217C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C6_nt  {
  ::S4217C7_nt s4217c6f0;
  void  mf4217c6(); // _ZN10S4217C6_nt8mf4217c6Ev
};
//SIG(-1 S4217C6_nt) C1{ m FC2{ FL[4]}}


void  S4217C6_nt ::mf4217c6(){}

//skip512 S4217C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C2  : S4217C3 {
  ::S4216C72 s4217c2f0;
  ::S4217C6_nt s4217c2f1;
  char s4217c2f2;
  virtual  ~S4217C2(); // _ZN7S4217C2D1Ev
  virtual void  v107(); // _ZN7S4217C24v107Ev
  virtual void  v108(); // _ZN7S4217C24v108Ev
  virtual void  v109(); // _ZN7S4217C24v109Ev
  S4217C2(); // tgen
};
//SIG(-1 S4217C2) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FC6{ FL[4]}} Fc}


 S4217C2 ::~S4217C2(){ note_dtor("S4217C2", this);}
void  S4217C2 ::v107(){vfunc_called(this, "_ZN7S4217C24v107Ev");}
void  S4217C2 ::v108(){vfunc_called(this, "_ZN7S4217C24v108Ev");}
void  S4217C2 ::v109(){vfunc_called(this, "_ZN7S4217C24v109Ev");}
S4217C2 ::S4217C2(){ note_ctor("S4217C2", this);} // tgen

static void Test_S4217C2()
{
  extern Class_Descriptor cd_S4217C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S4217C2, buf);
    S4217C2 *dp, &lv = *(dp=new (buf) S4217C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S4217C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C2)");
    check_base_class_offset(lv, (S4217C3*), 0, "S4217C2");
    check_field_offset(lv, s4217c2f0, ABISELECT(8,4), "S4217C2.s4217c2f0");
    check_field_offset(lv, s4217c2f1, ABISELECT(32,20), "S4217C2.s4217c2f1");
    check_field_offset(lv, s4217c2f2, ABISELECT(64,52), "S4217C2.s4217c2f2");
    test_class_info(&lv, &cd_S4217C2);
    dp->~S4217C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C2(Test_S4217C2, "S4217C2", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S4217C2C1Ev();
extern void _ZN7S4217C2D1Ev();
Name_Map name_map_S4217C2[] = {
  NSPAIR(_ZN7S4217C2C1Ev),
  NSPAIR(_ZN7S4217C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4217C3;
extern VTBL_ENTRY _ZTI7S4217C3[];
extern  VTBL_ENTRY _ZTV7S4217C3[];
static Base_Class bases_S4217C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4217C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4217C2[];
extern void _ZN7S4217C2D1Ev();
extern void _ZN7S4217C2D0Ev();
extern void _ZN7S4217C34v104Ev();
extern void _ZN7S4217C34v105Ev();
extern void _ZN7S4217C34v106Ev();
extern void _ZN7S4217C24v107Ev();
extern void _ZN7S4217C24v108Ev();
extern void _ZN7S4217C24v109Ev();
static  VTBL_ENTRY vtc_S4217C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4217C2[0]),
  (VTBL_ENTRY)&_ZN7S4217C2D1Ev,
  (VTBL_ENTRY)&_ZN7S4217C2D0Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v104Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v105Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v106Ev,
  (VTBL_ENTRY)&_ZN7S4217C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4217C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4217C24v109Ev,
};
extern VTBL_ENTRY _ZTI7S4217C2[];
extern  VTBL_ENTRY _ZTV7S4217C2[];
Class_Descriptor cd_S4217C2 = {  "S4217C2", // class name
  bases_S4217C2, 1,
  &(vtc_S4217C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S4217C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4217C2),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C8  {
  virtual  ~S4217C8(); // _ZN7S4217C8D1Ev
  virtual void  v110(); // _ZN7S4217C84v110Ev
  virtual void  v111(); // _ZN7S4217C84v111Ev
  virtual void  v112(); // _ZN7S4217C84v112Ev
  virtual void  v113(); // _ZN7S4217C84v113Ev
  virtual void  v114(); // _ZN7S4217C84v114Ev
  virtual void  v115(); // _ZN7S4217C84v115Ev
  virtual void  v116(); // _ZN7S4217C84v116Ev
  virtual void  v117(); // _ZN7S4217C84v117Ev
  virtual void  v118(); // _ZN7S4217C84v118Ev
  virtual void  v119(); // _ZN7S4217C84v119Ev
  virtual void  v120(); // _ZN7S4217C84v120Ev
  virtual void  v121(); // _ZN7S4217C84v121Ev
  virtual void  v122(); // _ZN7S4217C84v122Ev
  virtual void  v123(); // _ZN7S4217C84v123Ev
  virtual void  v124(); // _ZN7S4217C84v124Ev
  S4217C8(); // tgen
};
//SIG(-1 S4217C8) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15}


 S4217C8 ::~S4217C8(){ note_dtor("S4217C8", this);}
void  S4217C8 ::v110(){vfunc_called(this, "_ZN7S4217C84v110Ev");}
void  S4217C8 ::v111(){vfunc_called(this, "_ZN7S4217C84v111Ev");}
void  S4217C8 ::v112(){vfunc_called(this, "_ZN7S4217C84v112Ev");}
void  S4217C8 ::v113(){vfunc_called(this, "_ZN7S4217C84v113Ev");}
void  S4217C8 ::v114(){vfunc_called(this, "_ZN7S4217C84v114Ev");}
void  S4217C8 ::v115(){vfunc_called(this, "_ZN7S4217C84v115Ev");}
void  S4217C8 ::v116(){vfunc_called(this, "_ZN7S4217C84v116Ev");}
void  S4217C8 ::v117(){vfunc_called(this, "_ZN7S4217C84v117Ev");}
void  S4217C8 ::v118(){vfunc_called(this, "_ZN7S4217C84v118Ev");}
void  S4217C8 ::v119(){vfunc_called(this, "_ZN7S4217C84v119Ev");}
void  S4217C8 ::v120(){vfunc_called(this, "_ZN7S4217C84v120Ev");}
void  S4217C8 ::v121(){vfunc_called(this, "_ZN7S4217C84v121Ev");}
void  S4217C8 ::v122(){vfunc_called(this, "_ZN7S4217C84v122Ev");}
void  S4217C8 ::v123(){vfunc_called(this, "_ZN7S4217C84v123Ev");}
void  S4217C8 ::v124(){vfunc_called(this, "_ZN7S4217C84v124Ev");}
S4217C8 ::S4217C8(){ note_ctor("S4217C8", this);} // tgen

static void Test_S4217C8()
{
  extern Class_Descriptor cd_S4217C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4217C8, buf);
    S4217C8 *dp, &lv = *(dp=new (buf) S4217C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4217C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C8)");
    test_class_info(&lv, &cd_S4217C8);
    dp->~S4217C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C8(Test_S4217C8, "S4217C8", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4217C8C1Ev();
extern void _ZN7S4217C8D1Ev();
Name_Map name_map_S4217C8[] = {
  NSPAIR(_ZN7S4217C8C1Ev),
  NSPAIR(_ZN7S4217C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4217C8[];
extern void _ZN7S4217C8D1Ev();
extern void _ZN7S4217C8D0Ev();
extern void _ZN7S4217C84v110Ev();
extern void _ZN7S4217C84v111Ev();
extern void _ZN7S4217C84v112Ev();
extern void _ZN7S4217C84v113Ev();
extern void _ZN7S4217C84v114Ev();
extern void _ZN7S4217C84v115Ev();
extern void _ZN7S4217C84v116Ev();
extern void _ZN7S4217C84v117Ev();
extern void _ZN7S4217C84v118Ev();
extern void _ZN7S4217C84v119Ev();
extern void _ZN7S4217C84v120Ev();
extern void _ZN7S4217C84v121Ev();
extern void _ZN7S4217C84v122Ev();
extern void _ZN7S4217C84v123Ev();
extern void _ZN7S4217C84v124Ev();
static  VTBL_ENTRY vtc_S4217C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4217C8[0]),
  (VTBL_ENTRY)&_ZN7S4217C8D1Ev,
  (VTBL_ENTRY)&_ZN7S4217C8D0Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v110Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v111Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v112Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v113Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v114Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v115Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v116Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v117Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v118Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v119Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v120Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v121Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v122Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v123Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v124Ev,
};
extern VTBL_ENTRY _ZTI7S4217C8[];
extern  VTBL_ENTRY _ZTV7S4217C8[];
Class_Descriptor cd_S4217C8 = {  "S4217C8", // class name
  0,0,//no base classes
  &(vtc_S4217C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4217C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4217C8),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C9  {
  virtual  ~S4217C9(); // _ZN7S4217C9D1Ev
  virtual void  v125(); // _ZN7S4217C94v125Ev
  virtual void  v126(); // _ZN7S4217C94v126Ev
  virtual void  v127(); // _ZN7S4217C94v127Ev
  virtual void  v128(); // _ZN7S4217C94v128Ev
  virtual void  v129(); // _ZN7S4217C94v129Ev
  virtual void  v130(); // _ZN7S4217C94v130Ev
  virtual void  v131(); // _ZN7S4217C94v131Ev
  virtual void  v132(); // _ZN7S4217C94v132Ev
  virtual void  v133(); // _ZN7S4217C94v133Ev
  virtual void  v134(); // _ZN7S4217C94v134Ev
  virtual void  v135(); // _ZN7S4217C94v135Ev
  virtual void  v136(); // _ZN7S4217C94v136Ev
  virtual void  v137(); // _ZN7S4217C94v137Ev
  virtual void  v138(); // _ZN7S4217C94v138Ev
  virtual void  v139(); // _ZN7S4217C94v139Ev
  virtual void  v140(); // _ZN7S4217C94v140Ev
  virtual void  v141(); // _ZN7S4217C94v141Ev
  virtual void  v142(); // _ZN7S4217C94v142Ev
  virtual void  v143(); // _ZN7S4217C94v143Ev
  virtual void  v144(); // _ZN7S4217C94v144Ev
  virtual void  v145(); // _ZN7S4217C94v145Ev
  virtual void  v146(); // _ZN7S4217C94v146Ev
  virtual void  v147(); // _ZN7S4217C94v147Ev
  virtual void  v148(); // _ZN7S4217C94v148Ev
  virtual void  v149(); // _ZN7S4217C94v149Ev
  virtual void  v150(); // _ZN7S4217C94v150Ev
  virtual void  v151(); // _ZN7S4217C94v151Ev
  virtual void  v152(); // _ZN7S4217C94v152Ev
  virtual void  v153(); // _ZN7S4217C94v153Ev
  virtual void  v154(); // _ZN7S4217C94v154Ev
  virtual void  v155(); // _ZN7S4217C94v155Ev
  virtual void  v156(); // _ZN7S4217C94v156Ev
  virtual void  v157(); // _ZN7S4217C94v157Ev
  virtual void  v158(); // _ZN7S4217C94v158Ev
  virtual void  v159(); // _ZN7S4217C94v159Ev
  virtual void  v160(); // _ZN7S4217C94v160Ev
  virtual void  v161(); // _ZN7S4217C94v161Ev
  virtual void  v162(); // _ZN7S4217C94v162Ev
  virtual void  v163(); // _ZN7S4217C94v163Ev
  virtual void  v164(); // _ZN7S4217C94v164Ev
  virtual void  v165(); // _ZN7S4217C94v165Ev
  virtual void  v166(); // _ZN7S4217C94v166Ev
  virtual void  v167(); // _ZN7S4217C94v167Ev
  virtual void  v168(); // _ZN7S4217C94v168Ev
  virtual void  v169(); // _ZN7S4217C94v169Ev
  virtual void  v170(); // _ZN7S4217C94v170Ev
  virtual void  v171(); // _ZN7S4217C94v171Ev
  virtual void  v172(); // _ZN7S4217C94v172Ev
  virtual void  v173(); // _ZN7S4217C94v173Ev
  virtual void  v174(); // _ZN7S4217C94v174Ev
  virtual void  v175(); // _ZN7S4217C94v175Ev
  virtual void  v176(); // _ZN7S4217C94v176Ev
  virtual void  v177(); // _ZN7S4217C94v177Ev
  virtual void  v178(); // _ZN7S4217C94v178Ev
  virtual void  v179(); // _ZN7S4217C94v179Ev
  virtual void  v180(); // _ZN7S4217C94v180Ev
  virtual void  v181(); // _ZN7S4217C94v181Ev
  virtual void  v182(); // _ZN7S4217C94v182Ev
  virtual void  v183(); // _ZN7S4217C94v183Ev
  virtual void  v184(); // _ZN7S4217C94v184Ev
  virtual void  v185(); // _ZN7S4217C94v185Ev
  virtual void  v186(); // _ZN7S4217C94v186Ev
  virtual void  v187(); // _ZN7S4217C94v187Ev
  virtual void  v188(); // _ZN7S4217C94v188Ev
  virtual void  v189(); // _ZN7S4217C94v189Ev
  virtual void  v190(); // _ZN7S4217C94v190Ev
  virtual void  v191(); // _ZN7S4217C94v191Ev
  virtual void  v192(); // _ZN7S4217C94v192Ev
  virtual void  v193(); // _ZN7S4217C94v193Ev
  virtual void  v194(); // _ZN7S4217C94v194Ev
  virtual void  v195(); // _ZN7S4217C94v195Ev
  virtual void  v196(); // _ZN7S4217C94v196Ev
  virtual void  v197(); // _ZN7S4217C94v197Ev
  virtual void  v198(); // _ZN7S4217C94v198Ev
  virtual void  v199(); // _ZN7S4217C94v199Ev
  virtual void  v200(); // _ZN7S4217C94v200Ev
  virtual void  v201(); // _ZN7S4217C94v201Ev
  virtual void  v202(); // _ZN7S4217C94v202Ev
  virtual void  v203(); // _ZN7S4217C94v203Ev
  virtual void  v204(); // _ZN7S4217C94v204Ev
  S4217C9(); // tgen
};
//SIG(-1 S4217C9) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80}


 S4217C9 ::~S4217C9(){ note_dtor("S4217C9", this);}
void  S4217C9 ::v125(){vfunc_called(this, "_ZN7S4217C94v125Ev");}
void  S4217C9 ::v126(){vfunc_called(this, "_ZN7S4217C94v126Ev");}
void  S4217C9 ::v127(){vfunc_called(this, "_ZN7S4217C94v127Ev");}
void  S4217C9 ::v128(){vfunc_called(this, "_ZN7S4217C94v128Ev");}
void  S4217C9 ::v129(){vfunc_called(this, "_ZN7S4217C94v129Ev");}
void  S4217C9 ::v130(){vfunc_called(this, "_ZN7S4217C94v130Ev");}
void  S4217C9 ::v131(){vfunc_called(this, "_ZN7S4217C94v131Ev");}
void  S4217C9 ::v132(){vfunc_called(this, "_ZN7S4217C94v132Ev");}
void  S4217C9 ::v133(){vfunc_called(this, "_ZN7S4217C94v133Ev");}
void  S4217C9 ::v134(){vfunc_called(this, "_ZN7S4217C94v134Ev");}
void  S4217C9 ::v135(){vfunc_called(this, "_ZN7S4217C94v135Ev");}
void  S4217C9 ::v136(){vfunc_called(this, "_ZN7S4217C94v136Ev");}
void  S4217C9 ::v137(){vfunc_called(this, "_ZN7S4217C94v137Ev");}
void  S4217C9 ::v138(){vfunc_called(this, "_ZN7S4217C94v138Ev");}
void  S4217C9 ::v139(){vfunc_called(this, "_ZN7S4217C94v139Ev");}
void  S4217C9 ::v140(){vfunc_called(this, "_ZN7S4217C94v140Ev");}
void  S4217C9 ::v141(){vfunc_called(this, "_ZN7S4217C94v141Ev");}
void  S4217C9 ::v142(){vfunc_called(this, "_ZN7S4217C94v142Ev");}
void  S4217C9 ::v143(){vfunc_called(this, "_ZN7S4217C94v143Ev");}
void  S4217C9 ::v144(){vfunc_called(this, "_ZN7S4217C94v144Ev");}
void  S4217C9 ::v145(){vfunc_called(this, "_ZN7S4217C94v145Ev");}
void  S4217C9 ::v146(){vfunc_called(this, "_ZN7S4217C94v146Ev");}
void  S4217C9 ::v147(){vfunc_called(this, "_ZN7S4217C94v147Ev");}
void  S4217C9 ::v148(){vfunc_called(this, "_ZN7S4217C94v148Ev");}
void  S4217C9 ::v149(){vfunc_called(this, "_ZN7S4217C94v149Ev");}
void  S4217C9 ::v150(){vfunc_called(this, "_ZN7S4217C94v150Ev");}
void  S4217C9 ::v151(){vfunc_called(this, "_ZN7S4217C94v151Ev");}
void  S4217C9 ::v152(){vfunc_called(this, "_ZN7S4217C94v152Ev");}
void  S4217C9 ::v153(){vfunc_called(this, "_ZN7S4217C94v153Ev");}
void  S4217C9 ::v154(){vfunc_called(this, "_ZN7S4217C94v154Ev");}
void  S4217C9 ::v155(){vfunc_called(this, "_ZN7S4217C94v155Ev");}
void  S4217C9 ::v156(){vfunc_called(this, "_ZN7S4217C94v156Ev");}
void  S4217C9 ::v157(){vfunc_called(this, "_ZN7S4217C94v157Ev");}
void  S4217C9 ::v158(){vfunc_called(this, "_ZN7S4217C94v158Ev");}
void  S4217C9 ::v159(){vfunc_called(this, "_ZN7S4217C94v159Ev");}
void  S4217C9 ::v160(){vfunc_called(this, "_ZN7S4217C94v160Ev");}
void  S4217C9 ::v161(){vfunc_called(this, "_ZN7S4217C94v161Ev");}
void  S4217C9 ::v162(){vfunc_called(this, "_ZN7S4217C94v162Ev");}
void  S4217C9 ::v163(){vfunc_called(this, "_ZN7S4217C94v163Ev");}
void  S4217C9 ::v164(){vfunc_called(this, "_ZN7S4217C94v164Ev");}
void  S4217C9 ::v165(){vfunc_called(this, "_ZN7S4217C94v165Ev");}
void  S4217C9 ::v166(){vfunc_called(this, "_ZN7S4217C94v166Ev");}
void  S4217C9 ::v167(){vfunc_called(this, "_ZN7S4217C94v167Ev");}
void  S4217C9 ::v168(){vfunc_called(this, "_ZN7S4217C94v168Ev");}
void  S4217C9 ::v169(){vfunc_called(this, "_ZN7S4217C94v169Ev");}
void  S4217C9 ::v170(){vfunc_called(this, "_ZN7S4217C94v170Ev");}
void  S4217C9 ::v171(){vfunc_called(this, "_ZN7S4217C94v171Ev");}
void  S4217C9 ::v172(){vfunc_called(this, "_ZN7S4217C94v172Ev");}
void  S4217C9 ::v173(){vfunc_called(this, "_ZN7S4217C94v173Ev");}
void  S4217C9 ::v174(){vfunc_called(this, "_ZN7S4217C94v174Ev");}
void  S4217C9 ::v175(){vfunc_called(this, "_ZN7S4217C94v175Ev");}
void  S4217C9 ::v176(){vfunc_called(this, "_ZN7S4217C94v176Ev");}
void  S4217C9 ::v177(){vfunc_called(this, "_ZN7S4217C94v177Ev");}
void  S4217C9 ::v178(){vfunc_called(this, "_ZN7S4217C94v178Ev");}
void  S4217C9 ::v179(){vfunc_called(this, "_ZN7S4217C94v179Ev");}
void  S4217C9 ::v180(){vfunc_called(this, "_ZN7S4217C94v180Ev");}
void  S4217C9 ::v181(){vfunc_called(this, "_ZN7S4217C94v181Ev");}
void  S4217C9 ::v182(){vfunc_called(this, "_ZN7S4217C94v182Ev");}
void  S4217C9 ::v183(){vfunc_called(this, "_ZN7S4217C94v183Ev");}
void  S4217C9 ::v184(){vfunc_called(this, "_ZN7S4217C94v184Ev");}
void  S4217C9 ::v185(){vfunc_called(this, "_ZN7S4217C94v185Ev");}
void  S4217C9 ::v186(){vfunc_called(this, "_ZN7S4217C94v186Ev");}
void  S4217C9 ::v187(){vfunc_called(this, "_ZN7S4217C94v187Ev");}
void  S4217C9 ::v188(){vfunc_called(this, "_ZN7S4217C94v188Ev");}
void  S4217C9 ::v189(){vfunc_called(this, "_ZN7S4217C94v189Ev");}
void  S4217C9 ::v190(){vfunc_called(this, "_ZN7S4217C94v190Ev");}
void  S4217C9 ::v191(){vfunc_called(this, "_ZN7S4217C94v191Ev");}
void  S4217C9 ::v192(){vfunc_called(this, "_ZN7S4217C94v192Ev");}
void  S4217C9 ::v193(){vfunc_called(this, "_ZN7S4217C94v193Ev");}
void  S4217C9 ::v194(){vfunc_called(this, "_ZN7S4217C94v194Ev");}
void  S4217C9 ::v195(){vfunc_called(this, "_ZN7S4217C94v195Ev");}
void  S4217C9 ::v196(){vfunc_called(this, "_ZN7S4217C94v196Ev");}
void  S4217C9 ::v197(){vfunc_called(this, "_ZN7S4217C94v197Ev");}
void  S4217C9 ::v198(){vfunc_called(this, "_ZN7S4217C94v198Ev");}
void  S4217C9 ::v199(){vfunc_called(this, "_ZN7S4217C94v199Ev");}
void  S4217C9 ::v200(){vfunc_called(this, "_ZN7S4217C94v200Ev");}
void  S4217C9 ::v201(){vfunc_called(this, "_ZN7S4217C94v201Ev");}
void  S4217C9 ::v202(){vfunc_called(this, "_ZN7S4217C94v202Ev");}
void  S4217C9 ::v203(){vfunc_called(this, "_ZN7S4217C94v203Ev");}
void  S4217C9 ::v204(){vfunc_called(this, "_ZN7S4217C94v204Ev");}
S4217C9 ::S4217C9(){ note_ctor("S4217C9", this);} // tgen

static void Test_S4217C9()
{
  extern Class_Descriptor cd_S4217C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4217C9, buf);
    S4217C9 *dp, &lv = *(dp=new (buf) S4217C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4217C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C9)");
    test_class_info(&lv, &cd_S4217C9);
    dp->~S4217C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C9(Test_S4217C9, "S4217C9", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4217C9C1Ev();
extern void _ZN7S4217C9D1Ev();
Name_Map name_map_S4217C9[] = {
  NSPAIR(_ZN7S4217C9C1Ev),
  NSPAIR(_ZN7S4217C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4217C9[];
extern void _ZN7S4217C9D1Ev();
extern void _ZN7S4217C9D0Ev();
extern void _ZN7S4217C94v125Ev();
extern void _ZN7S4217C94v126Ev();
extern void _ZN7S4217C94v127Ev();
extern void _ZN7S4217C94v128Ev();
extern void _ZN7S4217C94v129Ev();
extern void _ZN7S4217C94v130Ev();
extern void _ZN7S4217C94v131Ev();
extern void _ZN7S4217C94v132Ev();
extern void _ZN7S4217C94v133Ev();
extern void _ZN7S4217C94v134Ev();
extern void _ZN7S4217C94v135Ev();
extern void _ZN7S4217C94v136Ev();
extern void _ZN7S4217C94v137Ev();
extern void _ZN7S4217C94v138Ev();
extern void _ZN7S4217C94v139Ev();
extern void _ZN7S4217C94v140Ev();
extern void _ZN7S4217C94v141Ev();
extern void _ZN7S4217C94v142Ev();
extern void _ZN7S4217C94v143Ev();
extern void _ZN7S4217C94v144Ev();
extern void _ZN7S4217C94v145Ev();
extern void _ZN7S4217C94v146Ev();
extern void _ZN7S4217C94v147Ev();
extern void _ZN7S4217C94v148Ev();
extern void _ZN7S4217C94v149Ev();
extern void _ZN7S4217C94v150Ev();
extern void _ZN7S4217C94v151Ev();
extern void _ZN7S4217C94v152Ev();
extern void _ZN7S4217C94v153Ev();
extern void _ZN7S4217C94v154Ev();
extern void _ZN7S4217C94v155Ev();
extern void _ZN7S4217C94v156Ev();
extern void _ZN7S4217C94v157Ev();
extern void _ZN7S4217C94v158Ev();
extern void _ZN7S4217C94v159Ev();
extern void _ZN7S4217C94v160Ev();
extern void _ZN7S4217C94v161Ev();
extern void _ZN7S4217C94v162Ev();
extern void _ZN7S4217C94v163Ev();
extern void _ZN7S4217C94v164Ev();
extern void _ZN7S4217C94v165Ev();
extern void _ZN7S4217C94v166Ev();
extern void _ZN7S4217C94v167Ev();
extern void _ZN7S4217C94v168Ev();
extern void _ZN7S4217C94v169Ev();
extern void _ZN7S4217C94v170Ev();
extern void _ZN7S4217C94v171Ev();
extern void _ZN7S4217C94v172Ev();
extern void _ZN7S4217C94v173Ev();
extern void _ZN7S4217C94v174Ev();
extern void _ZN7S4217C94v175Ev();
extern void _ZN7S4217C94v176Ev();
extern void _ZN7S4217C94v177Ev();
extern void _ZN7S4217C94v178Ev();
extern void _ZN7S4217C94v179Ev();
extern void _ZN7S4217C94v180Ev();
extern void _ZN7S4217C94v181Ev();
extern void _ZN7S4217C94v182Ev();
extern void _ZN7S4217C94v183Ev();
extern void _ZN7S4217C94v184Ev();
extern void _ZN7S4217C94v185Ev();
extern void _ZN7S4217C94v186Ev();
extern void _ZN7S4217C94v187Ev();
extern void _ZN7S4217C94v188Ev();
extern void _ZN7S4217C94v189Ev();
extern void _ZN7S4217C94v190Ev();
extern void _ZN7S4217C94v191Ev();
extern void _ZN7S4217C94v192Ev();
extern void _ZN7S4217C94v193Ev();
extern void _ZN7S4217C94v194Ev();
extern void _ZN7S4217C94v195Ev();
extern void _ZN7S4217C94v196Ev();
extern void _ZN7S4217C94v197Ev();
extern void _ZN7S4217C94v198Ev();
extern void _ZN7S4217C94v199Ev();
extern void _ZN7S4217C94v200Ev();
extern void _ZN7S4217C94v201Ev();
extern void _ZN7S4217C94v202Ev();
extern void _ZN7S4217C94v203Ev();
extern void _ZN7S4217C94v204Ev();
static  VTBL_ENTRY vtc_S4217C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4217C9[0]),
  (VTBL_ENTRY)&_ZN7S4217C9D1Ev,
  (VTBL_ENTRY)&_ZN7S4217C9D0Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v125Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v126Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v127Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v128Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v129Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v130Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v131Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v132Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v133Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v134Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v135Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v136Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v137Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v138Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v139Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v140Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v141Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v142Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v143Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v144Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v145Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v146Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v147Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v148Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v149Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v150Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v151Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v152Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v153Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v154Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v155Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v156Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v157Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v158Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v159Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v160Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v161Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v162Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v163Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v164Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v165Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v166Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v167Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v168Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v169Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v170Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v171Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v172Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v173Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v174Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v175Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v176Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v177Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v178Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v179Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v180Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v181Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v182Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v183Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v184Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v185Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v186Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v187Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v188Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v189Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v190Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v191Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v192Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v193Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v194Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v195Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v196Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v197Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v198Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v199Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v200Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v201Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v202Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v203Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v204Ev,
};
extern VTBL_ENTRY _ZTI7S4217C9[];
extern  VTBL_ENTRY _ZTV7S4217C9[];
Class_Descriptor cd_S4217C9 = {  "S4217C9", // class name
  0,0,//no base classes
  &(vtc_S4217C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4217C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4217C9),84, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C10  {
  virtual  ~S4217C10(); // _ZN8S4217C10D1Ev
  virtual void  v205(); // _ZN8S4217C104v205Ev
  S4217C10(); // tgen
};
//SIG(-1 S4217C10) C1{ vd v1}


 S4217C10 ::~S4217C10(){ note_dtor("S4217C10", this);}
void  S4217C10 ::v205(){vfunc_called(this, "_ZN8S4217C104v205Ev");}
S4217C10 ::S4217C10(){ note_ctor("S4217C10", this);} // tgen

static void Test_S4217C10()
{
  extern Class_Descriptor cd_S4217C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4217C10, buf);
    S4217C10 *dp, &lv = *(dp=new (buf) S4217C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4217C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C10)");
    test_class_info(&lv, &cd_S4217C10);
    dp->~S4217C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C10(Test_S4217C10, "S4217C10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S4217C10C1Ev();
extern void _ZN8S4217C10D1Ev();
Name_Map name_map_S4217C10[] = {
  NSPAIR(_ZN8S4217C10C1Ev),
  NSPAIR(_ZN8S4217C10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4217C10[];
extern void _ZN8S4217C10D1Ev();
extern void _ZN8S4217C10D0Ev();
extern void _ZN8S4217C104v205Ev();
static  VTBL_ENTRY vtc_S4217C10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4217C10[0]),
  (VTBL_ENTRY)&_ZN8S4217C10D1Ev,
  (VTBL_ENTRY)&_ZN8S4217C10D0Ev,
  (VTBL_ENTRY)&_ZN8S4217C104v205Ev,
};
extern VTBL_ENTRY _ZTI8S4217C10[];
extern  VTBL_ENTRY _ZTV8S4217C10[];
Class_Descriptor cd_S4217C10 = {  "S4217C10", // class name
  0,0,//no base classes
  &(vtc_S4217C10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S4217C10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4217C10),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C18  {
  int s4217c18f0;
  char s4217c18f1[3];
  virtual  ~S4217C18(); // _ZN8S4217C18D1Ev
  virtual void  v206(); // _ZN8S4217C184v206Ev
  S4217C18(); // tgen
};
//SIG(-1 S4217C18) C1{ vd v1 Fi Fc[3]}


 S4217C18 ::~S4217C18(){ note_dtor("S4217C18", this);}
void  S4217C18 ::v206(){vfunc_called(this, "_ZN8S4217C184v206Ev");}
S4217C18 ::S4217C18(){ note_ctor("S4217C18", this);} // tgen

static void Test_S4217C18()
{
  extern Class_Descriptor cd_S4217C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S4217C18, buf);
    S4217C18 *dp, &lv = *(dp=new (buf) S4217C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S4217C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C18)");
    check_field_offset(lv, s4217c18f0, ABISELECT(8,4), "S4217C18.s4217c18f0");
    check_field_offset(lv, s4217c18f1, ABISELECT(12,8), "S4217C18.s4217c18f1");
    test_class_info(&lv, &cd_S4217C18);
    dp->~S4217C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C18(Test_S4217C18, "S4217C18", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN8S4217C18C1Ev();
extern void _ZN8S4217C18D1Ev();
Name_Map name_map_S4217C18[] = {
  NSPAIR(_ZN8S4217C18C1Ev),
  NSPAIR(_ZN8S4217C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4217C18[];
extern void _ZN8S4217C18D1Ev();
extern void _ZN8S4217C18D0Ev();
extern void _ZN8S4217C184v206Ev();
static  VTBL_ENTRY vtc_S4217C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4217C18[0]),
  (VTBL_ENTRY)&_ZN8S4217C18D1Ev,
  (VTBL_ENTRY)&_ZN8S4217C18D0Ev,
  (VTBL_ENTRY)&_ZN8S4217C184v206Ev,
};
extern VTBL_ENTRY _ZTI8S4217C18[];
extern  VTBL_ENTRY _ZTV8S4217C18[];
Class_Descriptor cd_S4217C18 = {  "S4217C18", // class name
  0,0,//no base classes
  &(vtc_S4217C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI8S4217C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4217C18),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C17  : S4217C18 {
  void *s4217c17f0[2];
  int s4217c17f1;
  virtual  ~S4217C17(); // _ZN8S4217C17D1Ev
  virtual void  v207(); // _ZN8S4217C174v207Ev
  virtual void  v208(); // _ZN8S4217C174v208Ev
  virtual void  v209(); // _ZN8S4217C174v209Ev
  virtual void  v210(); // _ZN8S4217C174v210Ev
  virtual void  v211(); // _ZN8S4217C174v211Ev
  virtual void  v212(); // _ZN8S4217C174v212Ev
  virtual void  v213(); // _ZN8S4217C174v213Ev
  S4217C17(); // tgen
};
//SIG(-1 S4217C17) C1{ BC2{ vd v8 Fi Fc[3]} vd v1 v2 v3 v4 v5 v6 v7 Fp[2] Fi}


 S4217C17 ::~S4217C17(){ note_dtor("S4217C17", this);}
void  S4217C17 ::v207(){vfunc_called(this, "_ZN8S4217C174v207Ev");}
void  S4217C17 ::v208(){vfunc_called(this, "_ZN8S4217C174v208Ev");}
void  S4217C17 ::v209(){vfunc_called(this, "_ZN8S4217C174v209Ev");}
void  S4217C17 ::v210(){vfunc_called(this, "_ZN8S4217C174v210Ev");}
void  S4217C17 ::v211(){vfunc_called(this, "_ZN8S4217C174v211Ev");}
void  S4217C17 ::v212(){vfunc_called(this, "_ZN8S4217C174v212Ev");}
void  S4217C17 ::v213(){vfunc_called(this, "_ZN8S4217C174v213Ev");}
S4217C17 ::S4217C17(){ note_ctor("S4217C17", this);} // tgen

static void Test_S4217C17()
{
  extern Class_Descriptor cd_S4217C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S4217C17, buf);
    S4217C17 *dp, &lv = *(dp=new (buf) S4217C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S4217C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C17)");
    check_base_class_offset(lv, (S4217C18*), 0, "S4217C17");
    check_field_offset(lv, s4217c17f0, ABISELECT(16,12), "S4217C17.s4217c17f0");
    check_field_offset(lv, s4217c17f1, ABISELECT(32,20), "S4217C17.s4217c17f1");
    test_class_info(&lv, &cd_S4217C17);
    dp->~S4217C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C17(Test_S4217C17, "S4217C17", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN8S4217C17C1Ev();
extern void _ZN8S4217C17D1Ev();
Name_Map name_map_S4217C17[] = {
  NSPAIR(_ZN8S4217C17C1Ev),
  NSPAIR(_ZN8S4217C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4217C18;
extern VTBL_ENTRY _ZTI8S4217C18[];
extern  VTBL_ENTRY _ZTV8S4217C18[];
static Base_Class bases_S4217C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4217C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4217C17[];
extern void _ZN8S4217C17D1Ev();
extern void _ZN8S4217C17D0Ev();
extern void _ZN8S4217C184v206Ev();
extern void _ZN8S4217C174v207Ev();
extern void _ZN8S4217C174v208Ev();
extern void _ZN8S4217C174v209Ev();
extern void _ZN8S4217C174v210Ev();
extern void _ZN8S4217C174v211Ev();
extern void _ZN8S4217C174v212Ev();
extern void _ZN8S4217C174v213Ev();
static  VTBL_ENTRY vtc_S4217C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4217C17[0]),
  (VTBL_ENTRY)&_ZN8S4217C17D1Ev,
  (VTBL_ENTRY)&_ZN8S4217C17D0Ev,
  (VTBL_ENTRY)&_ZN8S4217C184v206Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v207Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v208Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v209Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v210Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v211Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v212Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v213Ev,
};
extern VTBL_ENTRY _ZTI8S4217C17[];
extern  VTBL_ENTRY _ZTV8S4217C17[];
Class_Descriptor cd_S4217C17 = {  "S4217C17", // class name
  bases_S4217C17, 1,
  &(vtc_S4217C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S4217C17),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4217C17),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C19  {
  virtual  ~S4217C19(); // _ZN8S4217C19D1Ev
  virtual void  v214(); // _ZN8S4217C194v214Ev
  virtual void  v215(); // _ZN8S4217C194v215Ev
  virtual void  v216(); // _ZN8S4217C194v216Ev
  S4217C19(); // tgen
};
//SIG(-1 S4217C19) C1{ vd v1 v2 v3}


 S4217C19 ::~S4217C19(){ note_dtor("S4217C19", this);}
void  S4217C19 ::v214(){vfunc_called(this, "_ZN8S4217C194v214Ev");}
void  S4217C19 ::v215(){vfunc_called(this, "_ZN8S4217C194v215Ev");}
void  S4217C19 ::v216(){vfunc_called(this, "_ZN8S4217C194v216Ev");}
S4217C19 ::S4217C19(){ note_ctor("S4217C19", this);} // tgen

static void Test_S4217C19()
{
  extern Class_Descriptor cd_S4217C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4217C19, buf);
    S4217C19 *dp, &lv = *(dp=new (buf) S4217C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4217C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C19)");
    test_class_info(&lv, &cd_S4217C19);
    dp->~S4217C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C19(Test_S4217C19, "S4217C19", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S4217C19C1Ev();
extern void _ZN8S4217C19D1Ev();
Name_Map name_map_S4217C19[] = {
  NSPAIR(_ZN8S4217C19C1Ev),
  NSPAIR(_ZN8S4217C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4217C19[];
extern void _ZN8S4217C19D1Ev();
extern void _ZN8S4217C19D0Ev();
extern void _ZN8S4217C194v214Ev();
extern void _ZN8S4217C194v215Ev();
extern void _ZN8S4217C194v216Ev();
static  VTBL_ENTRY vtc_S4217C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4217C19[0]),
  (VTBL_ENTRY)&_ZN8S4217C19D1Ev,
  (VTBL_ENTRY)&_ZN8S4217C19D0Ev,
  (VTBL_ENTRY)&_ZN8S4217C194v214Ev,
  (VTBL_ENTRY)&_ZN8S4217C194v215Ev,
  (VTBL_ENTRY)&_ZN8S4217C194v216Ev,
};
extern VTBL_ENTRY _ZTI8S4217C19[];
extern  VTBL_ENTRY _ZTV8S4217C19[];
Class_Descriptor cd_S4217C19 = {  "S4217C19", // class name
  0,0,//no base classes
  &(vtc_S4217C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S4217C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4217C19),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C16  : S4217C17 , S4217C19 {
  void *s4217c16f0;
  virtual  ~S4217C16(); // _ZN8S4217C16D1Ev
  virtual void  v217(); // _ZN8S4217C164v217Ev
  virtual void  v218(); // _ZN8S4217C164v218Ev
  virtual void  v219(); // _ZN8S4217C164v219Ev
  virtual void  v220(); // _ZN8S4217C164v220Ev
  virtual void  v221(); // _ZN8S4217C164v221Ev
  virtual void  v222(); // _ZN8S4217C164v222Ev
  virtual void  v223(); // _ZN8S4217C164v223Ev
  virtual void  v224(); // _ZN8S4217C164v224Ev
  virtual void  v225(); // _ZN8S4217C164v225Ev
  virtual void  v226(); // _ZN8S4217C164v226Ev
  S4217C16(); // tgen
};
//SIG(-1 S4217C16) C1{ BC2{ BC3{ vd v11 Fi Fc[3]} vd v12 v13 v14 v15 v16 v17 v18 Fp[2] Fi} BC4{ vd v19 v20 v21} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S4217C16 ::~S4217C16(){ note_dtor("S4217C16", this);}
void  S4217C16 ::v217(){vfunc_called(this, "_ZN8S4217C164v217Ev");}
void  S4217C16 ::v218(){vfunc_called(this, "_ZN8S4217C164v218Ev");}
void  S4217C16 ::v219(){vfunc_called(this, "_ZN8S4217C164v219Ev");}
void  S4217C16 ::v220(){vfunc_called(this, "_ZN8S4217C164v220Ev");}
void  S4217C16 ::v221(){vfunc_called(this, "_ZN8S4217C164v221Ev");}
void  S4217C16 ::v222(){vfunc_called(this, "_ZN8S4217C164v222Ev");}
void  S4217C16 ::v223(){vfunc_called(this, "_ZN8S4217C164v223Ev");}
void  S4217C16 ::v224(){vfunc_called(this, "_ZN8S4217C164v224Ev");}
void  S4217C16 ::v225(){vfunc_called(this, "_ZN8S4217C164v225Ev");}
void  S4217C16 ::v226(){vfunc_called(this, "_ZN8S4217C164v226Ev");}
S4217C16 ::S4217C16(){ note_ctor("S4217C16", this);} // tgen

static void Test_S4217C16()
{
  extern Class_Descriptor cd_S4217C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S4217C16, buf);
    S4217C16 *dp, &lv = *(dp=new (buf) S4217C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S4217C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C16)");
    check_base_class_offset(lv, (S4217C18*)(S4217C17*), 0, "S4217C16");
    check_base_class_offset(lv, (S4217C17*), 0, "S4217C16");
    check_base_class_offset(lv, (S4217C19*), ABISELECT(40,24), "S4217C16");
    check_field_offset(lv, s4217c16f0, ABISELECT(48,28), "S4217C16.s4217c16f0");
    test_class_info(&lv, &cd_S4217C16);
    dp->~S4217C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C16(Test_S4217C16, "S4217C16", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN8S4217C16C1Ev();
extern void _ZN8S4217C16D1Ev();
Name_Map name_map_S4217C16[] = {
  NSPAIR(_ZN8S4217C16C1Ev),
  NSPAIR(_ZN8S4217C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4217C18;
extern VTBL_ENTRY _ZTI8S4217C18[];
extern  VTBL_ENTRY _ZTV8S4217C18[];
extern Class_Descriptor cd_S4217C17;
extern VTBL_ENTRY _ZTI8S4217C17[];
extern  VTBL_ENTRY _ZTV8S4217C17[];
extern Class_Descriptor cd_S4217C19;
extern VTBL_ENTRY _ZTI8S4217C19[];
extern  VTBL_ENTRY _ZTV8S4217C19[];
static Base_Class bases_S4217C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4217C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4217C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4217C19,    ABISELECT(40,24), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4217C16[];
extern void _ZN8S4217C16D1Ev();
extern void _ZN8S4217C16D0Ev();
extern void _ZN8S4217C184v206Ev();
extern void _ZN8S4217C174v207Ev();
extern void _ZN8S4217C174v208Ev();
extern void _ZN8S4217C174v209Ev();
extern void _ZN8S4217C174v210Ev();
extern void _ZN8S4217C174v211Ev();
extern void _ZN8S4217C174v212Ev();
extern void _ZN8S4217C174v213Ev();
extern void _ZN8S4217C164v217Ev();
extern void _ZN8S4217C164v218Ev();
extern void _ZN8S4217C164v219Ev();
extern void _ZN8S4217C164v220Ev();
extern void _ZN8S4217C164v221Ev();
extern void _ZN8S4217C164v222Ev();
extern void _ZN8S4217C164v223Ev();
extern void _ZN8S4217C164v224Ev();
extern void _ZN8S4217C164v225Ev();
extern void _ZN8S4217C164v226Ev();
extern void ABISELECT(_ZThn40_N8S4217C16D1Ev,_ZThn24_N8S4217C16D1Ev)();
extern void ABISELECT(_ZThn40_N8S4217C16D0Ev,_ZThn24_N8S4217C16D0Ev)();
extern void _ZN8S4217C194v214Ev();
extern void _ZN8S4217C194v215Ev();
extern void _ZN8S4217C194v216Ev();
static  VTBL_ENTRY vtc_S4217C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4217C16[0]),
  (VTBL_ENTRY)&_ZN8S4217C16D1Ev,
  (VTBL_ENTRY)&_ZN8S4217C16D0Ev,
  (VTBL_ENTRY)&_ZN8S4217C184v206Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v207Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v208Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v209Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v210Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v211Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v212Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v213Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v217Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v218Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v219Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v220Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v221Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v222Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v223Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v224Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v225Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v226Ev,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S4217C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S4217C16D1Ev,_ZThn24_N8S4217C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S4217C16D0Ev,_ZThn24_N8S4217C16D0Ev),
  (VTBL_ENTRY)&_ZN8S4217C194v214Ev,
  (VTBL_ENTRY)&_ZN8S4217C194v215Ev,
  (VTBL_ENTRY)&_ZN8S4217C194v216Ev,
};
extern VTBL_ENTRY _ZTI8S4217C16[];
extern  VTBL_ENTRY _ZTV8S4217C16[];
Class_Descriptor cd_S4217C16 = {  "S4217C16", // class name
  bases_S4217C16, 3,
  &(vtc_S4217C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI8S4217C16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S4217C16),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C28  {
  virtual  ~S4217C28(); // _ZN8S4217C28D1Ev
  virtual void  v232(); // _ZN8S4217C284v232Ev
  virtual void  v233(); // _ZN8S4217C284v233Ev
  S4217C28(); // tgen
};
//SIG(-1 S4217C28) C1{ vd v1 v2}


 S4217C28 ::~S4217C28(){ note_dtor("S4217C28", this);}
void  S4217C28 ::v232(){vfunc_called(this, "_ZN8S4217C284v232Ev");}
void  S4217C28 ::v233(){vfunc_called(this, "_ZN8S4217C284v233Ev");}
S4217C28 ::S4217C28(){ note_ctor("S4217C28", this);} // tgen

static void Test_S4217C28()
{
  extern Class_Descriptor cd_S4217C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4217C28, buf);
    S4217C28 *dp, &lv = *(dp=new (buf) S4217C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4217C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C28)");
    test_class_info(&lv, &cd_S4217C28);
    dp->~S4217C28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C28(Test_S4217C28, "S4217C28", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S4217C28C1Ev();
extern void _ZN8S4217C28D1Ev();
Name_Map name_map_S4217C28[] = {
  NSPAIR(_ZN8S4217C28C1Ev),
  NSPAIR(_ZN8S4217C28D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4217C28[];
extern void _ZN8S4217C28D1Ev();
extern void _ZN8S4217C28D0Ev();
extern void _ZN8S4217C284v232Ev();
extern void _ZN8S4217C284v233Ev();
static  VTBL_ENTRY vtc_S4217C28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4217C28[0]),
  (VTBL_ENTRY)&_ZN8S4217C28D1Ev,
  (VTBL_ENTRY)&_ZN8S4217C28D0Ev,
  (VTBL_ENTRY)&_ZN8S4217C284v232Ev,
  (VTBL_ENTRY)&_ZN8S4217C284v233Ev,
};
extern VTBL_ENTRY _ZTI8S4217C28[];
extern  VTBL_ENTRY _ZTV8S4217C28[];
Class_Descriptor cd_S4217C28 = {  "S4217C28", // class name
  0,0,//no base classes
  &(vtc_S4217C28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S4217C28),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4217C28),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C37  : S4216C64 , S4217C28 {
  virtual  ~S4217C37(); // _ZN8S4217C37D1Ev
  virtual void  v242(); // _ZN8S4217C374v242Ev
  virtual void  v243(); // _ZN8S4217C374v243Ev
  S4217C37(); // tgen
};
//SIG(-1 S4217C37) C1{ BC2{ m Fp Fi[2] FC3{ m}} BC4{ vd v3 v4} vd v1 v2}


 S4217C37 ::~S4217C37(){ note_dtor("S4217C37", this);}
void  S4217C37 ::v242(){vfunc_called(this, "_ZN8S4217C374v242Ev");}
void  S4217C37 ::v243(){vfunc_called(this, "_ZN8S4217C374v243Ev");}
S4217C37 ::S4217C37(){ note_ctor("S4217C37", this);} // tgen

static void Test_S4217C37()
{
  extern Class_Descriptor cd_S4217C37;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S4217C37, buf);
    S4217C37 *dp, &lv = *(dp=new (buf) S4217C37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S4217C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C37)");
    check_base_class_offset(lv, (S4216C64*), ABISELECT(8,4), "S4217C37");
    check_base_class_offset(lv, (S4217C28*), 0, "S4217C37");
    test_class_info(&lv, &cd_S4217C37);
    dp->~S4217C37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C37(Test_S4217C37, "S4217C37", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN8S4217C37C1Ev();
extern void _ZN8S4217C37D1Ev();
Name_Map name_map_S4217C37[] = {
  NSPAIR(_ZN8S4217C37C1Ev),
  NSPAIR(_ZN8S4217C37D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C64;
extern VTBL_ENTRY _ZTI8S4216C64[];
extern Class_Descriptor cd_S4217C28;
extern VTBL_ENTRY _ZTI8S4217C28[];
extern  VTBL_ENTRY _ZTV8S4217C28[];
static Base_Class bases_S4217C37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C64,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4217C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4217C37[];
extern void _ZN8S4217C37D1Ev();
extern void _ZN8S4217C37D0Ev();
extern void _ZN8S4217C284v232Ev();
extern void _ZN8S4217C284v233Ev();
extern void _ZN8S4217C374v242Ev();
extern void _ZN8S4217C374v243Ev();
static  VTBL_ENTRY vtc_S4217C37[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4217C37[0]),
  (VTBL_ENTRY)&_ZN8S4217C37D1Ev,
  (VTBL_ENTRY)&_ZN8S4217C37D0Ev,
  (VTBL_ENTRY)&_ZN8S4217C284v232Ev,
  (VTBL_ENTRY)&_ZN8S4217C284v233Ev,
  (VTBL_ENTRY)&_ZN8S4217C374v242Ev,
  (VTBL_ENTRY)&_ZN8S4217C374v243Ev,
};
extern VTBL_ENTRY _ZTI8S4217C37[];
extern  VTBL_ENTRY _ZTV8S4217C37[];
Class_Descriptor cd_S4217C37 = {  "S4217C37", // class name
  bases_S4217C37, 2,
  &(vtc_S4217C37[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S4217C37),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S4217C37),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C25  : S4216C26 , S4216C51 , S4217C2 {
  void *s4217c25f0[2];
  ::S4217C6_nt s4217c25f1;
  void *s4217c25f2[5];
  ::S4216C33 s4217c25f3;
  ::S4217C6_nt s4217c25f4;
  ::S4216C12_nt s4217c25f5;
  ::S4216C63 s4217c25f6;
  ::S4216C57 s4217c25f7;
  ::S4216C37 s4217c25f8;
  ::S4216C66 s4217c25f9;
  ::S4217C37 s4217c25f10;
  ::S4217C37 s4217c25f11;
  int s4217c25f12[2];
  void *s4217c25f13;
  ::S4216C58 s4217c25f14;
  char s4217c25f15;
  virtual  ~S4217C25(); // _ZN8S4217C25D1Ev
  S4217C25(); // tgen
};
//SIG(-1 S4217C25) C1{ BC2{ vd m Fi Fc[2] FC3{ BC4{ vd v10 v11} vd v7 v8 v9 Fc[66]} FC5{ m Fp Fi FC6{ m}} FC7{ BC4 vd v12 FC5} FC7 FC7 Fc FC7 Fc Fi Fs FC7 FC7 FC8{ vd v13 Fi} FC9{ vd v14 Fi[2] Fs[2] Fi[3] FC5} FC10{ vd v15 Fi} FC11{ vd v16 Fs[2] Fc[6] Fs[2] Fc[6] FC5} FC11 FC12{ BC4 vd v17 FC5 FC5 FC5} Fc Fi[3] FC13{ BC4 vd v18 v19 FC11 FC5 FC5 FC5 FC14{ vd m Fi FC12 Fi} Fc FC15{ BC16{ m Fp Fi[2] FC17{ m}} BC4 vd v20 v21} FC5} Fi[2] FC18{ BC12 vd v22 v23 FC5 Fi Fc} Fi[2] FC19{ BC4 vd v24 FC11 FC5 Fi[2] FC10 Fi[2]} FC19 FC9 Fi[2] Fc[2] Fi[2] FC20{ m Fi} FC21{ BC4 vd v25 FC5} FC21 Fi[2] FC7 Fi FC22{ BC4 vd v26 FC7 FC7} Fc FC7 FC15 FC12 Fc FC18 Fc FC21 FC21 Fi Fc Fi FC20[55]} BC23{ vd m FC24{ BC4 vd v27 v28 Fi[4]}} BC25{ BC26{ vd v1 v2 v3} vd v4 v5 v6 FC27{ m Fp Fi[2] FC28{ m}} FC29{ m FC30{ FL[4]}} Fc} vd Fp[2] FC29 Fp[5] FC11 FC29 FC31{ BC32{ m Fp Fi FC33{ m} FC6}} FC34{ BC35{ m Fp Fi[2] FC28} BC4 vd v29 v30} FC36{ BC37{ m Fp Fi[2] FC17} BC4 vd v31 v32} FC15 FC38{ m FL Fi FL Fc FC39{ m Fp Fi[2] FC33}} FC40{ BC35 BC41{ vd v35 v36} vd v33 v34} FC40 Fi[2] Fp FC37 Fc}


 S4217C25 ::~S4217C25(){ note_dtor("S4217C25", this);}
S4217C25 ::S4217C25(){ note_ctor("S4217C25", this);} // tgen

static void Test_S4217C25()
{
  extern Class_Descriptor cd_S4217C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(293,438)];
    init_test(&cd_S4217C25, buf);
    S4217C25 *dp, &lv = *(dp=new (buf) S4217C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2336,1748), "sizeof(S4217C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C25)");
    check_base_class_offset(lv, (S4216C26*), 0, "S4217C25");
    check_base_class_offset(lv, (S4216C51*), ABISELECT(1784,1356), "S4217C25");
    check_base_class_offset(lv, (S4217C3*)(S4217C2*), ABISELECT(1816,1380), "S4217C25");
    check_base_class_offset(lv, (S4217C2*), ABISELECT(1816,1380), "S4217C25");
    check_field_offset(lv, s4217c25f0, ABISELECT(1888,1436), "S4217C25.s4217c25f0");
    check_field_offset(lv, s4217c25f1, ABISELECT(1904,1444), "S4217C25.s4217c25f1");
    check_field_offset(lv, s4217c25f2, ABISELECT(1936,1476), "S4217C25.s4217c25f2");
    check_field_offset(lv, s4217c25f3, ABISELECT(1976,1496), "S4217C25.s4217c25f3");
    check_field_offset(lv, s4217c25f4, ABISELECT(2024,1532), "S4217C25.s4217c25f4");
    check_field_offset(lv, s4217c25f5, ABISELECT(2056,1564), "S4217C25.s4217c25f5");
    check_field_offset(lv, s4217c25f6, ABISELECT(2072,1576), "S4217C25.s4217c25f6");
    check_field_offset(lv, s4217c25f7, ABISELECT(2104,1596), "S4217C25.s4217c25f7");
    check_field_offset(lv, s4217c25f8, ABISELECT(2136,1616), "S4217C25.s4217c25f8");
    check_field_offset(lv, s4217c25f9, ABISELECT(2168,1636), "S4217C25.s4217c25f9");
    check_field_offset(lv, s4217c25f10, ABISELECT(2224,1676), "S4217C25.s4217c25f10");
    check_field_offset(lv, s4217c25f11, ABISELECT(2256,1696), "S4217C25.s4217c25f11");
    check_field_offset(lv, s4217c25f12, ABISELECT(2288,1716), "S4217C25.s4217c25f12");
    check_field_offset(lv, s4217c25f13, ABISELECT(2296,1724), "S4217C25.s4217c25f13");
    check_field_offset(lv, s4217c25f14, ABISELECT(2304,1728), "S4217C25.s4217c25f14");
    check_field_offset(lv, s4217c25f15, ABISELECT(2328,1744), "S4217C25.s4217c25f15");
    test_class_info(&lv, &cd_S4217C25);
    dp->~S4217C25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C25(Test_S4217C25, "S4217C25", ABISELECT(2336,1748));

#else // __cplusplus

extern void _ZN8S4217C25C1Ev();
extern void _ZN8S4217C25D1Ev();
Name_Map name_map_S4217C25[] = {
  NSPAIR(_ZN8S4217C25C1Ev),
  NSPAIR(_ZN8S4217C25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C26;
extern VTBL_ENTRY _ZTI8S4216C26[];
extern  VTBL_ENTRY _ZTV8S4216C26[];
extern Class_Descriptor cd_S4216C51;
extern VTBL_ENTRY _ZTI8S4216C51[];
extern  VTBL_ENTRY _ZTV8S4216C51[];
extern Class_Descriptor cd_S4217C3;
extern VTBL_ENTRY _ZTI7S4217C3[];
extern  VTBL_ENTRY _ZTV7S4217C3[];
extern Class_Descriptor cd_S4217C2;
extern VTBL_ENTRY _ZTI7S4217C2[];
extern  VTBL_ENTRY _ZTV7S4217C2[];
static Base_Class bases_S4217C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C51,    ABISELECT(1784,1356), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4217C3,    ABISELECT(1816,1380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S4217C2,    ABISELECT(1816,1380), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4217C25[];
extern void _ZN8S4217C25D1Ev();
extern void _ZN8S4217C25D0Ev();
extern void ABISELECT(_ZThn1784_N8S4217C25D1Ev,_ZThn1356_N8S4217C25D1Ev)();
extern void ABISELECT(_ZThn1784_N8S4217C25D0Ev,_ZThn1356_N8S4217C25D0Ev)();
extern void ABISELECT(_ZThn1816_N8S4217C25D1Ev,_ZThn1380_N8S4217C25D1Ev)();
extern void ABISELECT(_ZThn1816_N8S4217C25D0Ev,_ZThn1380_N8S4217C25D0Ev)();
extern void _ZN7S4217C34v104Ev();
extern void _ZN7S4217C34v105Ev();
extern void _ZN7S4217C34v106Ev();
extern void _ZN7S4217C24v107Ev();
extern void _ZN7S4217C24v108Ev();
extern void _ZN7S4217C24v109Ev();
static  VTBL_ENTRY vtc_S4217C25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4217C25[0]),
  (VTBL_ENTRY)&_ZN8S4217C25D1Ev,
  (VTBL_ENTRY)&_ZN8S4217C25D0Ev,
  ABISELECT(-1784,-1356),
  (VTBL_ENTRY)&(_ZTI8S4217C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1784_N8S4217C25D1Ev,_ZThn1356_N8S4217C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1784_N8S4217C25D0Ev,_ZThn1356_N8S4217C25D0Ev),
  ABISELECT(-1816,-1380),
  (VTBL_ENTRY)&(_ZTI8S4217C25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1816_N8S4217C25D1Ev,_ZThn1380_N8S4217C25D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1816_N8S4217C25D0Ev,_ZThn1380_N8S4217C25D0Ev),
  (VTBL_ENTRY)&_ZN7S4217C34v104Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v105Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v106Ev,
  (VTBL_ENTRY)&_ZN7S4217C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4217C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4217C24v109Ev,
};
extern VTBL_ENTRY _ZTI8S4217C25[];
extern  VTBL_ENTRY _ZTV8S4217C25[];
Class_Descriptor cd_S4217C25 = {  "S4217C25", // class name
  bases_S4217C25, 4,
  &(vtc_S4217C25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2336,1748), // object size
  NSPAIRA(_ZTI8S4217C25),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S4217C25),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4217C1  : S4217C2 , S4217C8 , S4217C9 , S4217C10 , S4216C11 , S4217C16 {
  ::S4217C6_nt s4217c1f0;
  ::S4217C6_nt s4217c1f1;
  void *s4217c1f2[2];
  ::S4216C21 s4217c1f3;
  ::S4216C32 s4217c1f4;
  int s4217c1f5[3];
  char s4217c1f6;
  int s4217c1f7[2];
  ::S4217C25 s4217c1f8;
  ::S4216C74 s4217c1f9;
  int s4217c1f10[2];
  char s4217c1f11;
  int s4217c1f12;
  void *s4217c1f13;
  int s4217c1f14;
  char s4217c1f15;
  virtual  ~S4217C1(); // _ZN7S4217C1D1Ev
  virtual void  v1(); // _ZN7S4217C12v1Ev
  virtual void  v2(); // _ZN7S4217C12v2Ev
  virtual void  v3(); // _ZN7S4217C12v3Ev
  virtual void  v4(); // _ZN7S4217C12v4Ev
  virtual void  v5(); // _ZN7S4217C12v5Ev
  virtual void  v6(); // _ZN7S4217C12v6Ev
  virtual void  v7(); // _ZN7S4217C12v7Ev
  virtual void  v8(); // _ZN7S4217C12v8Ev
  virtual void  v9(); // _ZN7S4217C12v9Ev
  virtual void  v10(); // _ZN7S4217C13v10Ev
  virtual void  v11(); // _ZN7S4217C13v11Ev
  virtual void  v12(); // _ZN7S4217C13v12Ev
  virtual void  v13(); // _ZN7S4217C13v13Ev
  virtual void  v14(); // _ZN7S4217C13v14Ev
  virtual void  v15(); // _ZN7S4217C13v15Ev
  virtual void  v16(); // _ZN7S4217C13v16Ev
  virtual void  v17(); // _ZN7S4217C13v17Ev
  virtual void  v18(); // _ZN7S4217C13v18Ev
  virtual void  v19(); // _ZN7S4217C13v19Ev
  virtual void  v20(); // _ZN7S4217C13v20Ev
  virtual void  v21(); // _ZN7S4217C13v21Ev
  virtual void  v22(); // _ZN7S4217C13v22Ev
  virtual void  v23(); // _ZN7S4217C13v23Ev
  virtual void  v24(); // _ZN7S4217C13v24Ev
  virtual void  v25(); // _ZN7S4217C13v25Ev
  virtual void  v26(); // _ZN7S4217C13v26Ev
  virtual void  v27(); // _ZN7S4217C13v27Ev
  virtual void  v28(); // _ZN7S4217C13v28Ev
  virtual void  v29(); // _ZN7S4217C13v29Ev
  virtual void  v30(); // _ZN7S4217C13v30Ev
  virtual void  v31(); // _ZN7S4217C13v31Ev
  virtual void  v32(); // _ZN7S4217C13v32Ev
  virtual void  v33(); // _ZN7S4217C13v33Ev
  virtual void  v34(); // _ZN7S4217C13v34Ev
  virtual void  v35(); // _ZN7S4217C13v35Ev
  virtual void  v36(); // _ZN7S4217C13v36Ev
  virtual void  v37(); // _ZN7S4217C13v37Ev
  virtual void  v38(); // _ZN7S4217C13v38Ev
  virtual void  v39(); // _ZN7S4217C13v39Ev
  virtual void  v40(); // _ZN7S4217C13v40Ev
  virtual void  v41(); // _ZN7S4217C13v41Ev
  virtual void  v42(); // _ZN7S4217C13v42Ev
  virtual void  v43(); // _ZN7S4217C13v43Ev
  virtual void  v44(); // _ZN7S4217C13v44Ev
  virtual void  v45(); // _ZN7S4217C13v45Ev
  virtual void  v46(); // _ZN7S4217C13v46Ev
  virtual void  v47(); // _ZN7S4217C13v47Ev
  virtual void  v48(); // _ZN7S4217C13v48Ev
  virtual void  v49(); // _ZN7S4217C13v49Ev
  virtual void  v50(); // _ZN7S4217C13v50Ev
  virtual void  v51(); // _ZN7S4217C13v51Ev
  virtual void  v52(); // _ZN7S4217C13v52Ev
  virtual void  v53(); // _ZN7S4217C13v53Ev
  virtual void  v54(); // _ZN7S4217C13v54Ev
  virtual void  v55(); // _ZN7S4217C13v55Ev
  virtual void  v56(); // _ZN7S4217C13v56Ev
  virtual void  v57(); // _ZN7S4217C13v57Ev
  virtual void  v58(); // _ZN7S4217C13v58Ev
  virtual void  v59(); // _ZN7S4217C13v59Ev
  virtual void  v60(); // _ZN7S4217C13v60Ev
  virtual void  v61(); // _ZN7S4217C13v61Ev
  virtual void  v62(); // _ZN7S4217C13v62Ev
  virtual void  v63(); // _ZN7S4217C13v63Ev
  virtual void  v64(); // _ZN7S4217C13v64Ev
  virtual void  v65(); // _ZN7S4217C13v65Ev
  virtual void  v66(); // _ZN7S4217C13v66Ev
  virtual void  v67(); // _ZN7S4217C13v67Ev
  virtual void  v68(); // _ZN7S4217C13v68Ev
  virtual void  v69(); // _ZN7S4217C13v69Ev
  virtual void  v70(); // _ZN7S4217C13v70Ev
  virtual void  v71(); // _ZN7S4217C13v71Ev
  virtual void  v72(); // _ZN7S4217C13v72Ev
  virtual void  v73(); // _ZN7S4217C13v73Ev
  virtual void  v74(); // _ZN7S4217C13v74Ev
  virtual void  v75(); // _ZN7S4217C13v75Ev
  virtual void  v76(); // _ZN7S4217C13v76Ev
  virtual void  v77(); // _ZN7S4217C13v77Ev
  virtual void  v78(); // _ZN7S4217C13v78Ev
  virtual void  v79(); // _ZN7S4217C13v79Ev
  virtual void  v80(); // _ZN7S4217C13v80Ev
  virtual void  v81(); // _ZN7S4217C13v81Ev
  virtual void  v82(); // _ZN7S4217C13v82Ev
  virtual void  v83(); // _ZN7S4217C13v83Ev
  virtual void  v84(); // _ZN7S4217C13v84Ev
  virtual void  v85(); // _ZN7S4217C13v85Ev
  virtual void  v86(); // _ZN7S4217C13v86Ev
  virtual void  v87(); // _ZN7S4217C13v87Ev
  virtual void  v88(); // _ZN7S4217C13v88Ev
  virtual void  v89(); // _ZN7S4217C13v89Ev
  virtual void  v90(); // _ZN7S4217C13v90Ev
  virtual void  v91(); // _ZN7S4217C13v91Ev
  virtual void  v92(); // _ZN7S4217C13v92Ev
  virtual void  v93(); // _ZN7S4217C13v93Ev
  virtual void  v94(); // _ZN7S4217C13v94Ev
  virtual void  v95(); // _ZN7S4217C13v95Ev
  virtual void  v96(); // _ZN7S4217C13v96Ev
  virtual void  v97(); // _ZN7S4217C13v97Ev
  virtual void  v98(); // _ZN7S4217C13v98Ev
  virtual void  v99(); // _ZN7S4217C13v99Ev
  virtual void  v100(); // _ZN7S4217C14v100Ev
  virtual void  v101(); // _ZN7S4217C14v101Ev
  virtual void  v102(); // _ZN7S4217C14v102Ev
  virtual void  v103(); // _ZN7S4217C14v103Ev
  S4217C1(); // tgen
};
//SIG(1 S4217C1) C1{ BC2{ BC3{ vd v104 v105 v106} vd v107 v108 v109 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc} BC8{ vd v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124} BC9{ vd v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204} BC10{ vd v205} BC11{ vd m FC12{ BC13{ m Fp Fi FC14{ m} FC15{ m}}}} BC16{ BC17{ BC18{ vd v206 Fi Fc[3]} vd v207 v208 v209 v210 v211 v212 v213 Fp[2] Fi} BC19{ vd v214 v215 v216} vd v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 FC6 FC6 Fp[2] FC20{ vd v227 Fi[2] Fs[2] Fi[3] FC21{ m Fp Fi FC15}} FC22{ vd v228 Fi} Fi[3] Fc Fi[2] FC23{ BC24{ vd m Fi Fc[2] FC25{ BC26{ vd v232 v233} vd v229 v230 v231 Fc[66]} FC21 FC27{ BC26 vd v234 FC21} FC27 FC27 Fc FC27 Fc Fi Fs FC27 FC27 FC28{ vd v235 Fi} FC20 FC22 FC29{ vd v236 Fs[2] Fc[6] Fs[2] Fc[6] FC21} FC29 FC30{ BC26 vd v237 FC21 FC21 FC21} Fc Fi[3] FC31{ BC26 vd v238 v239 FC29 FC21 FC21 FC21 FC32{ vd m Fi FC30 Fi} Fc FC33{ BC34{ m Fp Fi[2] FC35{ m}} BC26 vd v240 v241} FC21} Fi[2] FC36{ BC30 vd v242 v243 FC21 Fi Fc} Fi[2] FC37{ BC26 vd v244 FC29 FC21 Fi[2] FC22 Fi[2]} FC37 FC20 Fi[2] Fc[2] Fi[2] FC38{ m Fi} FC39{ BC26 vd v245 FC21} FC39 Fi[2] FC27 Fi FC40{ BC26 vd v246 FC27 FC27} Fc FC27 FC33 FC30 Fc FC36 Fc FC39 FC39 Fi Fc Fi FC38[55]} BC41{ vd m FC42{ BC26 vd v247 v248 Fi[4]}} BC2 vd Fp[2] FC6 Fp[5] FC29 FC6 FC12 FC43{ BC44{ m Fp Fi[2] FC5} BC26 vd v249 v250} FC45{ BC46{ m Fp Fi[2] FC35} BC26 vd v251 v252} FC33 FC47{ m FL Fi FL Fc FC48{ m Fp Fi[2] FC14}} FC49{ BC44 BC50{ vd v255 v256} vd v253 v254} FC49 Fi[2] Fp FC46 Fc} FC51{ BC52{ vd v258 FC53{ m FC54{ m Fp Fi FC55{ m} FC55}} Fp[3] Fc} v257 Fp} Fi[2] Fc Fi Fp Fi Fc}


 S4217C1 ::~S4217C1(){ note_dtor("S4217C1", this);}
void  S4217C1 ::v1(){vfunc_called(this, "_ZN7S4217C12v1Ev");}
void  S4217C1 ::v2(){vfunc_called(this, "_ZN7S4217C12v2Ev");}
void  S4217C1 ::v3(){vfunc_called(this, "_ZN7S4217C12v3Ev");}
void  S4217C1 ::v4(){vfunc_called(this, "_ZN7S4217C12v4Ev");}
void  S4217C1 ::v5(){vfunc_called(this, "_ZN7S4217C12v5Ev");}
void  S4217C1 ::v6(){vfunc_called(this, "_ZN7S4217C12v6Ev");}
void  S4217C1 ::v7(){vfunc_called(this, "_ZN7S4217C12v7Ev");}
void  S4217C1 ::v8(){vfunc_called(this, "_ZN7S4217C12v8Ev");}
void  S4217C1 ::v9(){vfunc_called(this, "_ZN7S4217C12v9Ev");}
void  S4217C1 ::v10(){vfunc_called(this, "_ZN7S4217C13v10Ev");}
void  S4217C1 ::v11(){vfunc_called(this, "_ZN7S4217C13v11Ev");}
void  S4217C1 ::v12(){vfunc_called(this, "_ZN7S4217C13v12Ev");}
void  S4217C1 ::v13(){vfunc_called(this, "_ZN7S4217C13v13Ev");}
void  S4217C1 ::v14(){vfunc_called(this, "_ZN7S4217C13v14Ev");}
void  S4217C1 ::v15(){vfunc_called(this, "_ZN7S4217C13v15Ev");}
void  S4217C1 ::v16(){vfunc_called(this, "_ZN7S4217C13v16Ev");}
void  S4217C1 ::v17(){vfunc_called(this, "_ZN7S4217C13v17Ev");}
void  S4217C1 ::v18(){vfunc_called(this, "_ZN7S4217C13v18Ev");}
void  S4217C1 ::v19(){vfunc_called(this, "_ZN7S4217C13v19Ev");}
void  S4217C1 ::v20(){vfunc_called(this, "_ZN7S4217C13v20Ev");}
void  S4217C1 ::v21(){vfunc_called(this, "_ZN7S4217C13v21Ev");}
void  S4217C1 ::v22(){vfunc_called(this, "_ZN7S4217C13v22Ev");}
void  S4217C1 ::v23(){vfunc_called(this, "_ZN7S4217C13v23Ev");}
void  S4217C1 ::v24(){vfunc_called(this, "_ZN7S4217C13v24Ev");}
void  S4217C1 ::v25(){vfunc_called(this, "_ZN7S4217C13v25Ev");}
void  S4217C1 ::v26(){vfunc_called(this, "_ZN7S4217C13v26Ev");}
void  S4217C1 ::v27(){vfunc_called(this, "_ZN7S4217C13v27Ev");}
void  S4217C1 ::v28(){vfunc_called(this, "_ZN7S4217C13v28Ev");}
void  S4217C1 ::v29(){vfunc_called(this, "_ZN7S4217C13v29Ev");}
void  S4217C1 ::v30(){vfunc_called(this, "_ZN7S4217C13v30Ev");}
void  S4217C1 ::v31(){vfunc_called(this, "_ZN7S4217C13v31Ev");}
void  S4217C1 ::v32(){vfunc_called(this, "_ZN7S4217C13v32Ev");}
void  S4217C1 ::v33(){vfunc_called(this, "_ZN7S4217C13v33Ev");}
void  S4217C1 ::v34(){vfunc_called(this, "_ZN7S4217C13v34Ev");}
void  S4217C1 ::v35(){vfunc_called(this, "_ZN7S4217C13v35Ev");}
void  S4217C1 ::v36(){vfunc_called(this, "_ZN7S4217C13v36Ev");}
void  S4217C1 ::v37(){vfunc_called(this, "_ZN7S4217C13v37Ev");}
void  S4217C1 ::v38(){vfunc_called(this, "_ZN7S4217C13v38Ev");}
void  S4217C1 ::v39(){vfunc_called(this, "_ZN7S4217C13v39Ev");}
void  S4217C1 ::v40(){vfunc_called(this, "_ZN7S4217C13v40Ev");}
void  S4217C1 ::v41(){vfunc_called(this, "_ZN7S4217C13v41Ev");}
void  S4217C1 ::v42(){vfunc_called(this, "_ZN7S4217C13v42Ev");}
void  S4217C1 ::v43(){vfunc_called(this, "_ZN7S4217C13v43Ev");}
void  S4217C1 ::v44(){vfunc_called(this, "_ZN7S4217C13v44Ev");}
void  S4217C1 ::v45(){vfunc_called(this, "_ZN7S4217C13v45Ev");}
void  S4217C1 ::v46(){vfunc_called(this, "_ZN7S4217C13v46Ev");}
void  S4217C1 ::v47(){vfunc_called(this, "_ZN7S4217C13v47Ev");}
void  S4217C1 ::v48(){vfunc_called(this, "_ZN7S4217C13v48Ev");}
void  S4217C1 ::v49(){vfunc_called(this, "_ZN7S4217C13v49Ev");}
void  S4217C1 ::v50(){vfunc_called(this, "_ZN7S4217C13v50Ev");}
void  S4217C1 ::v51(){vfunc_called(this, "_ZN7S4217C13v51Ev");}
void  S4217C1 ::v52(){vfunc_called(this, "_ZN7S4217C13v52Ev");}
void  S4217C1 ::v53(){vfunc_called(this, "_ZN7S4217C13v53Ev");}
void  S4217C1 ::v54(){vfunc_called(this, "_ZN7S4217C13v54Ev");}
void  S4217C1 ::v55(){vfunc_called(this, "_ZN7S4217C13v55Ev");}
void  S4217C1 ::v56(){vfunc_called(this, "_ZN7S4217C13v56Ev");}
void  S4217C1 ::v57(){vfunc_called(this, "_ZN7S4217C13v57Ev");}
void  S4217C1 ::v58(){vfunc_called(this, "_ZN7S4217C13v58Ev");}
void  S4217C1 ::v59(){vfunc_called(this, "_ZN7S4217C13v59Ev");}
void  S4217C1 ::v60(){vfunc_called(this, "_ZN7S4217C13v60Ev");}
void  S4217C1 ::v61(){vfunc_called(this, "_ZN7S4217C13v61Ev");}
void  S4217C1 ::v62(){vfunc_called(this, "_ZN7S4217C13v62Ev");}
void  S4217C1 ::v63(){vfunc_called(this, "_ZN7S4217C13v63Ev");}
void  S4217C1 ::v64(){vfunc_called(this, "_ZN7S4217C13v64Ev");}
void  S4217C1 ::v65(){vfunc_called(this, "_ZN7S4217C13v65Ev");}
void  S4217C1 ::v66(){vfunc_called(this, "_ZN7S4217C13v66Ev");}
void  S4217C1 ::v67(){vfunc_called(this, "_ZN7S4217C13v67Ev");}
void  S4217C1 ::v68(){vfunc_called(this, "_ZN7S4217C13v68Ev");}
void  S4217C1 ::v69(){vfunc_called(this, "_ZN7S4217C13v69Ev");}
void  S4217C1 ::v70(){vfunc_called(this, "_ZN7S4217C13v70Ev");}
void  S4217C1 ::v71(){vfunc_called(this, "_ZN7S4217C13v71Ev");}
void  S4217C1 ::v72(){vfunc_called(this, "_ZN7S4217C13v72Ev");}
void  S4217C1 ::v73(){vfunc_called(this, "_ZN7S4217C13v73Ev");}
void  S4217C1 ::v74(){vfunc_called(this, "_ZN7S4217C13v74Ev");}
void  S4217C1 ::v75(){vfunc_called(this, "_ZN7S4217C13v75Ev");}
void  S4217C1 ::v76(){vfunc_called(this, "_ZN7S4217C13v76Ev");}
void  S4217C1 ::v77(){vfunc_called(this, "_ZN7S4217C13v77Ev");}
void  S4217C1 ::v78(){vfunc_called(this, "_ZN7S4217C13v78Ev");}
void  S4217C1 ::v79(){vfunc_called(this, "_ZN7S4217C13v79Ev");}
void  S4217C1 ::v80(){vfunc_called(this, "_ZN7S4217C13v80Ev");}
void  S4217C1 ::v81(){vfunc_called(this, "_ZN7S4217C13v81Ev");}
void  S4217C1 ::v82(){vfunc_called(this, "_ZN7S4217C13v82Ev");}
void  S4217C1 ::v83(){vfunc_called(this, "_ZN7S4217C13v83Ev");}
void  S4217C1 ::v84(){vfunc_called(this, "_ZN7S4217C13v84Ev");}
void  S4217C1 ::v85(){vfunc_called(this, "_ZN7S4217C13v85Ev");}
void  S4217C1 ::v86(){vfunc_called(this, "_ZN7S4217C13v86Ev");}
void  S4217C1 ::v87(){vfunc_called(this, "_ZN7S4217C13v87Ev");}
void  S4217C1 ::v88(){vfunc_called(this, "_ZN7S4217C13v88Ev");}
void  S4217C1 ::v89(){vfunc_called(this, "_ZN7S4217C13v89Ev");}
void  S4217C1 ::v90(){vfunc_called(this, "_ZN7S4217C13v90Ev");}
void  S4217C1 ::v91(){vfunc_called(this, "_ZN7S4217C13v91Ev");}
void  S4217C1 ::v92(){vfunc_called(this, "_ZN7S4217C13v92Ev");}
void  S4217C1 ::v93(){vfunc_called(this, "_ZN7S4217C13v93Ev");}
void  S4217C1 ::v94(){vfunc_called(this, "_ZN7S4217C13v94Ev");}
void  S4217C1 ::v95(){vfunc_called(this, "_ZN7S4217C13v95Ev");}
void  S4217C1 ::v96(){vfunc_called(this, "_ZN7S4217C13v96Ev");}
void  S4217C1 ::v97(){vfunc_called(this, "_ZN7S4217C13v97Ev");}
void  S4217C1 ::v98(){vfunc_called(this, "_ZN7S4217C13v98Ev");}
void  S4217C1 ::v99(){vfunc_called(this, "_ZN7S4217C13v99Ev");}
void  S4217C1 ::v100(){vfunc_called(this, "_ZN7S4217C14v100Ev");}
void  S4217C1 ::v101(){vfunc_called(this, "_ZN7S4217C14v101Ev");}
void  S4217C1 ::v102(){vfunc_called(this, "_ZN7S4217C14v102Ev");}
void  S4217C1 ::v103(){vfunc_called(this, "_ZN7S4217C14v103Ev");}
S4217C1 ::S4217C1(){ note_ctor("S4217C1", this);} // tgen

static void Test_S4217C1()
{
  extern Class_Descriptor cd_S4217C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(348,519)];
    init_test(&cd_S4217C1, buf);
    S4217C1 *dp, &lv = *(dp=new (buf) S4217C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2776,2072), "sizeof(S4217C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4217C1)");
    check_base_class_offset(lv, (S4217C3*)(S4217C2*), 0, "S4217C1");
    check_base_class_offset(lv, (S4217C2*), 0, "S4217C1");
    check_base_class_offset(lv, (S4217C8*), ABISELECT(72,56), "S4217C1");
    check_base_class_offset(lv, (S4217C9*), ABISELECT(80,60), "S4217C1");
    check_base_class_offset(lv, (S4217C10*), ABISELECT(88,64), "S4217C1");
    check_base_class_offset(lv, (S4216C11*), ABISELECT(96,68), "S4217C1");
    check_base_class_offset(lv, (S4217C18*)(S4217C17*)(S4217C16*), ABISELECT(120,84), "S4217C1");
    check_base_class_offset(lv, (S4217C17*)(S4217C16*), ABISELECT(120,84), "S4217C1");
    check_base_class_offset(lv, (S4217C19*)(S4217C16*), ABISELECT(160,108), "S4217C1");
    check_base_class_offset(lv, (S4217C16*), ABISELECT(120,84), "S4217C1");
    check_field_offset(lv, s4217c1f0, ABISELECT(176,116), "S4217C1.s4217c1f0");
    check_field_offset(lv, s4217c1f1, ABISELECT(208,148), "S4217C1.s4217c1f1");
    check_field_offset(lv, s4217c1f2, ABISELECT(240,180), "S4217C1.s4217c1f2");
    check_field_offset(lv, s4217c1f3, ABISELECT(256,188), "S4217C1.s4217c1f3");
    check_field_offset(lv, s4217c1f4, ABISELECT(304,228), "S4217C1.s4217c1f4");
    check_field_offset(lv, s4217c1f5, ABISELECT(320,236), "S4217C1.s4217c1f5");
    check_field_offset(lv, s4217c1f6, ABISELECT(332,248), "S4217C1.s4217c1f6");
    check_field_offset(lv, s4217c1f7, ABISELECT(336,252), "S4217C1.s4217c1f7");
    check_field_offset(lv, s4217c1f8, ABISELECT(344,260), "S4217C1.s4217c1f8");
    check_field_offset(lv, s4217c1f9, ABISELECT(2680,2008), "S4217C1.s4217c1f9");
    check_field_offset(lv, s4217c1f10, ABISELECT(2744,2044), "S4217C1.s4217c1f10");
    check_field_offset(lv, s4217c1f11, ABISELECT(2752,2052), "S4217C1.s4217c1f11");
    check_field_offset(lv, s4217c1f12, ABISELECT(2756,2056), "S4217C1.s4217c1f12");
    check_field_offset(lv, s4217c1f13, ABISELECT(2760,2060), "S4217C1.s4217c1f13");
    check_field_offset(lv, s4217c1f14, ABISELECT(2768,2064), "S4217C1.s4217c1f14");
    check_field_offset(lv, s4217c1f15, ABISELECT(2772,2068), "S4217C1.s4217c1f15");
    test_class_info(&lv, &cd_S4217C1);
    dp->~S4217C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4217C1(Test_S4217C1, "S4217C1", ABISELECT(2776,2072));

#else // __cplusplus

extern void _ZN7S4217C1C1Ev();
extern void _ZN7S4217C1D1Ev();
Name_Map name_map_S4217C1[] = {
  NSPAIR(_ZN7S4217C1C1Ev),
  NSPAIR(_ZN7S4217C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4217C3;
extern VTBL_ENTRY _ZTI7S4217C3[];
extern  VTBL_ENTRY _ZTV7S4217C3[];
extern Class_Descriptor cd_S4217C2;
extern VTBL_ENTRY _ZTI7S4217C2[];
extern  VTBL_ENTRY _ZTV7S4217C2[];
extern Class_Descriptor cd_S4217C8;
extern VTBL_ENTRY _ZTI7S4217C8[];
extern  VTBL_ENTRY _ZTV7S4217C8[];
extern Class_Descriptor cd_S4217C9;
extern VTBL_ENTRY _ZTI7S4217C9[];
extern  VTBL_ENTRY _ZTV7S4217C9[];
extern Class_Descriptor cd_S4217C10;
extern VTBL_ENTRY _ZTI8S4217C10[];
extern  VTBL_ENTRY _ZTV8S4217C10[];
extern Class_Descriptor cd_S4216C11;
extern VTBL_ENTRY _ZTI8S4216C11[];
extern  VTBL_ENTRY _ZTV8S4216C11[];
extern Class_Descriptor cd_S4217C18;
extern VTBL_ENTRY _ZTI8S4217C18[];
extern  VTBL_ENTRY _ZTV8S4217C18[];
extern Class_Descriptor cd_S4217C17;
extern VTBL_ENTRY _ZTI8S4217C17[];
extern  VTBL_ENTRY _ZTV8S4217C17[];
extern Class_Descriptor cd_S4217C19;
extern VTBL_ENTRY _ZTI8S4217C19[];
extern  VTBL_ENTRY _ZTV8S4217C19[];
extern Class_Descriptor cd_S4217C16;
extern VTBL_ENTRY _ZTI8S4217C16[];
extern  VTBL_ENTRY _ZTV8S4217C16[];
static Base_Class bases_S4217C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4217C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4217C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4217C8,    ABISELECT(72,56), //bcp->offset
    113, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4217C9,    ABISELECT(80,60), //bcp->offset
    132, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4217C10,    ABISELECT(88,64), //bcp->offset
    216, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C11,    ABISELECT(96,68), //bcp->offset
    221, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4217C18,    ABISELECT(120,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S4217C17,    ABISELECT(120,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S4217C19,    ABISELECT(160,108), //bcp->offset
    247, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S4217C16,    ABISELECT(120,84), //bcp->offset
    225, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4217C1[];
extern void _ZN7S4217C1D1Ev();
extern void _ZN7S4217C1D0Ev();
extern void _ZN7S4217C34v104Ev();
extern void _ZN7S4217C34v105Ev();
extern void _ZN7S4217C34v106Ev();
extern void _ZN7S4217C24v107Ev();
extern void _ZN7S4217C24v108Ev();
extern void _ZN7S4217C24v109Ev();
extern void _ZN7S4217C12v1Ev();
extern void _ZN7S4217C12v2Ev();
extern void _ZN7S4217C12v3Ev();
extern void _ZN7S4217C12v4Ev();
extern void _ZN7S4217C12v5Ev();
extern void _ZN7S4217C12v6Ev();
extern void _ZN7S4217C12v7Ev();
extern void _ZN7S4217C12v8Ev();
extern void _ZN7S4217C12v9Ev();
extern void _ZN7S4217C13v10Ev();
extern void _ZN7S4217C13v11Ev();
extern void _ZN7S4217C13v12Ev();
extern void _ZN7S4217C13v13Ev();
extern void _ZN7S4217C13v14Ev();
extern void _ZN7S4217C13v15Ev();
extern void _ZN7S4217C13v16Ev();
extern void _ZN7S4217C13v17Ev();
extern void _ZN7S4217C13v18Ev();
extern void _ZN7S4217C13v19Ev();
extern void _ZN7S4217C13v20Ev();
extern void _ZN7S4217C13v21Ev();
extern void _ZN7S4217C13v22Ev();
extern void _ZN7S4217C13v23Ev();
extern void _ZN7S4217C13v24Ev();
extern void _ZN7S4217C13v25Ev();
extern void _ZN7S4217C13v26Ev();
extern void _ZN7S4217C13v27Ev();
extern void _ZN7S4217C13v28Ev();
extern void _ZN7S4217C13v29Ev();
extern void _ZN7S4217C13v30Ev();
extern void _ZN7S4217C13v31Ev();
extern void _ZN7S4217C13v32Ev();
extern void _ZN7S4217C13v33Ev();
extern void _ZN7S4217C13v34Ev();
extern void _ZN7S4217C13v35Ev();
extern void _ZN7S4217C13v36Ev();
extern void _ZN7S4217C13v37Ev();
extern void _ZN7S4217C13v38Ev();
extern void _ZN7S4217C13v39Ev();
extern void _ZN7S4217C13v40Ev();
extern void _ZN7S4217C13v41Ev();
extern void _ZN7S4217C13v42Ev();
extern void _ZN7S4217C13v43Ev();
extern void _ZN7S4217C13v44Ev();
extern void _ZN7S4217C13v45Ev();
extern void _ZN7S4217C13v46Ev();
extern void _ZN7S4217C13v47Ev();
extern void _ZN7S4217C13v48Ev();
extern void _ZN7S4217C13v49Ev();
extern void _ZN7S4217C13v50Ev();
extern void _ZN7S4217C13v51Ev();
extern void _ZN7S4217C13v52Ev();
extern void _ZN7S4217C13v53Ev();
extern void _ZN7S4217C13v54Ev();
extern void _ZN7S4217C13v55Ev();
extern void _ZN7S4217C13v56Ev();
extern void _ZN7S4217C13v57Ev();
extern void _ZN7S4217C13v58Ev();
extern void _ZN7S4217C13v59Ev();
extern void _ZN7S4217C13v60Ev();
extern void _ZN7S4217C13v61Ev();
extern void _ZN7S4217C13v62Ev();
extern void _ZN7S4217C13v63Ev();
extern void _ZN7S4217C13v64Ev();
extern void _ZN7S4217C13v65Ev();
extern void _ZN7S4217C13v66Ev();
extern void _ZN7S4217C13v67Ev();
extern void _ZN7S4217C13v68Ev();
extern void _ZN7S4217C13v69Ev();
extern void _ZN7S4217C13v70Ev();
extern void _ZN7S4217C13v71Ev();
extern void _ZN7S4217C13v72Ev();
extern void _ZN7S4217C13v73Ev();
extern void _ZN7S4217C13v74Ev();
extern void _ZN7S4217C13v75Ev();
extern void _ZN7S4217C13v76Ev();
extern void _ZN7S4217C13v77Ev();
extern void _ZN7S4217C13v78Ev();
extern void _ZN7S4217C13v79Ev();
extern void _ZN7S4217C13v80Ev();
extern void _ZN7S4217C13v81Ev();
extern void _ZN7S4217C13v82Ev();
extern void _ZN7S4217C13v83Ev();
extern void _ZN7S4217C13v84Ev();
extern void _ZN7S4217C13v85Ev();
extern void _ZN7S4217C13v86Ev();
extern void _ZN7S4217C13v87Ev();
extern void _ZN7S4217C13v88Ev();
extern void _ZN7S4217C13v89Ev();
extern void _ZN7S4217C13v90Ev();
extern void _ZN7S4217C13v91Ev();
extern void _ZN7S4217C13v92Ev();
extern void _ZN7S4217C13v93Ev();
extern void _ZN7S4217C13v94Ev();
extern void _ZN7S4217C13v95Ev();
extern void _ZN7S4217C13v96Ev();
extern void _ZN7S4217C13v97Ev();
extern void _ZN7S4217C13v98Ev();
extern void _ZN7S4217C13v99Ev();
extern void _ZN7S4217C14v100Ev();
extern void _ZN7S4217C14v101Ev();
extern void _ZN7S4217C14v102Ev();
extern void _ZN7S4217C14v103Ev();
extern void ABISELECT(_ZThn72_N7S4217C1D1Ev,_ZThn56_N7S4217C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S4217C1D0Ev,_ZThn56_N7S4217C1D0Ev)();
extern void _ZN7S4217C84v110Ev();
extern void _ZN7S4217C84v111Ev();
extern void _ZN7S4217C84v112Ev();
extern void _ZN7S4217C84v113Ev();
extern void _ZN7S4217C84v114Ev();
extern void _ZN7S4217C84v115Ev();
extern void _ZN7S4217C84v116Ev();
extern void _ZN7S4217C84v117Ev();
extern void _ZN7S4217C84v118Ev();
extern void _ZN7S4217C84v119Ev();
extern void _ZN7S4217C84v120Ev();
extern void _ZN7S4217C84v121Ev();
extern void _ZN7S4217C84v122Ev();
extern void _ZN7S4217C84v123Ev();
extern void _ZN7S4217C84v124Ev();
extern void ABISELECT(_ZThn80_N7S4217C1D1Ev,_ZThn60_N7S4217C1D1Ev)();
extern void ABISELECT(_ZThn80_N7S4217C1D0Ev,_ZThn60_N7S4217C1D0Ev)();
extern void _ZN7S4217C94v125Ev();
extern void _ZN7S4217C94v126Ev();
extern void _ZN7S4217C94v127Ev();
extern void _ZN7S4217C94v128Ev();
extern void _ZN7S4217C94v129Ev();
extern void _ZN7S4217C94v130Ev();
extern void _ZN7S4217C94v131Ev();
extern void _ZN7S4217C94v132Ev();
extern void _ZN7S4217C94v133Ev();
extern void _ZN7S4217C94v134Ev();
extern void _ZN7S4217C94v135Ev();
extern void _ZN7S4217C94v136Ev();
extern void _ZN7S4217C94v137Ev();
extern void _ZN7S4217C94v138Ev();
extern void _ZN7S4217C94v139Ev();
extern void _ZN7S4217C94v140Ev();
extern void _ZN7S4217C94v141Ev();
extern void _ZN7S4217C94v142Ev();
extern void _ZN7S4217C94v143Ev();
extern void _ZN7S4217C94v144Ev();
extern void _ZN7S4217C94v145Ev();
extern void _ZN7S4217C94v146Ev();
extern void _ZN7S4217C94v147Ev();
extern void _ZN7S4217C94v148Ev();
extern void _ZN7S4217C94v149Ev();
extern void _ZN7S4217C94v150Ev();
extern void _ZN7S4217C94v151Ev();
extern void _ZN7S4217C94v152Ev();
extern void _ZN7S4217C94v153Ev();
extern void _ZN7S4217C94v154Ev();
extern void _ZN7S4217C94v155Ev();
extern void _ZN7S4217C94v156Ev();
extern void _ZN7S4217C94v157Ev();
extern void _ZN7S4217C94v158Ev();
extern void _ZN7S4217C94v159Ev();
extern void _ZN7S4217C94v160Ev();
extern void _ZN7S4217C94v161Ev();
extern void _ZN7S4217C94v162Ev();
extern void _ZN7S4217C94v163Ev();
extern void _ZN7S4217C94v164Ev();
extern void _ZN7S4217C94v165Ev();
extern void _ZN7S4217C94v166Ev();
extern void _ZN7S4217C94v167Ev();
extern void _ZN7S4217C94v168Ev();
extern void _ZN7S4217C94v169Ev();
extern void _ZN7S4217C94v170Ev();
extern void _ZN7S4217C94v171Ev();
extern void _ZN7S4217C94v172Ev();
extern void _ZN7S4217C94v173Ev();
extern void _ZN7S4217C94v174Ev();
extern void _ZN7S4217C94v175Ev();
extern void _ZN7S4217C94v176Ev();
extern void _ZN7S4217C94v177Ev();
extern void _ZN7S4217C94v178Ev();
extern void _ZN7S4217C94v179Ev();
extern void _ZN7S4217C94v180Ev();
extern void _ZN7S4217C94v181Ev();
extern void _ZN7S4217C94v182Ev();
extern void _ZN7S4217C94v183Ev();
extern void _ZN7S4217C94v184Ev();
extern void _ZN7S4217C94v185Ev();
extern void _ZN7S4217C94v186Ev();
extern void _ZN7S4217C94v187Ev();
extern void _ZN7S4217C94v188Ev();
extern void _ZN7S4217C94v189Ev();
extern void _ZN7S4217C94v190Ev();
extern void _ZN7S4217C94v191Ev();
extern void _ZN7S4217C94v192Ev();
extern void _ZN7S4217C94v193Ev();
extern void _ZN7S4217C94v194Ev();
extern void _ZN7S4217C94v195Ev();
extern void _ZN7S4217C94v196Ev();
extern void _ZN7S4217C94v197Ev();
extern void _ZN7S4217C94v198Ev();
extern void _ZN7S4217C94v199Ev();
extern void _ZN7S4217C94v200Ev();
extern void _ZN7S4217C94v201Ev();
extern void _ZN7S4217C94v202Ev();
extern void _ZN7S4217C94v203Ev();
extern void _ZN7S4217C94v204Ev();
extern void ABISELECT(_ZThn88_N7S4217C1D1Ev,_ZThn64_N7S4217C1D1Ev)();
extern void ABISELECT(_ZThn88_N7S4217C1D0Ev,_ZThn64_N7S4217C1D0Ev)();
extern void _ZN8S4217C104v205Ev();
extern void ABISELECT(_ZThn96_N7S4217C1D1Ev,_ZThn68_N7S4217C1D1Ev)();
extern void ABISELECT(_ZThn96_N7S4217C1D0Ev,_ZThn68_N7S4217C1D0Ev)();
extern void ABISELECT(_ZThn120_N7S4217C1D1Ev,_ZThn84_N7S4217C1D1Ev)();
extern void ABISELECT(_ZThn120_N7S4217C1D0Ev,_ZThn84_N7S4217C1D0Ev)();
extern void _ZN8S4217C184v206Ev();
extern void _ZN8S4217C174v207Ev();
extern void _ZN8S4217C174v208Ev();
extern void _ZN8S4217C174v209Ev();
extern void _ZN8S4217C174v210Ev();
extern void _ZN8S4217C174v211Ev();
extern void _ZN8S4217C174v212Ev();
extern void _ZN8S4217C174v213Ev();
extern void _ZN8S4217C164v217Ev();
extern void _ZN8S4217C164v218Ev();
extern void _ZN8S4217C164v219Ev();
extern void _ZN8S4217C164v220Ev();
extern void _ZN8S4217C164v221Ev();
extern void _ZN8S4217C164v222Ev();
extern void _ZN8S4217C164v223Ev();
extern void _ZN8S4217C164v224Ev();
extern void _ZN8S4217C164v225Ev();
extern void _ZN8S4217C164v226Ev();
extern void ABISELECT(_ZThn160_N7S4217C1D1Ev,_ZThn108_N7S4217C1D1Ev)();
extern void ABISELECT(_ZThn160_N7S4217C1D0Ev,_ZThn108_N7S4217C1D0Ev)();
extern void _ZN8S4217C194v214Ev();
extern void _ZN8S4217C194v215Ev();
extern void _ZN8S4217C194v216Ev();
static  VTBL_ENTRY vtc_S4217C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4217C1[0]),
  (VTBL_ENTRY)&_ZN7S4217C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4217C1D0Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v104Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v105Ev,
  (VTBL_ENTRY)&_ZN7S4217C34v106Ev,
  (VTBL_ENTRY)&_ZN7S4217C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4217C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4217C24v109Ev,
  (VTBL_ENTRY)&_ZN7S4217C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4217C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4217C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4217C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4217C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4217C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4217C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4217C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4217C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v12Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v13Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v14Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v15Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v16Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v17Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v18Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v19Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v20Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v21Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v22Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v23Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v24Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v25Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v26Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v27Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v28Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v29Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v30Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v31Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v32Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v33Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v34Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v35Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v36Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v37Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v38Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v39Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v40Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v41Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v42Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v43Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v44Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v45Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v46Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v47Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v48Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v49Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v50Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v51Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v52Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v53Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v54Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v55Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v56Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v57Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v58Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v59Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v60Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v61Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v62Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v63Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v64Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v65Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v66Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v67Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v68Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v69Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v70Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v71Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v72Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v73Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v74Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v75Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v76Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v77Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v78Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v79Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v80Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v81Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v82Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v83Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v84Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v85Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v86Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v87Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v88Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v89Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v90Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v91Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v92Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v93Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v94Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v95Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v96Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v97Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v98Ev,
  (VTBL_ENTRY)&_ZN7S4217C13v99Ev,
  (VTBL_ENTRY)&_ZN7S4217C14v100Ev,
  (VTBL_ENTRY)&_ZN7S4217C14v101Ev,
  (VTBL_ENTRY)&_ZN7S4217C14v102Ev,
  (VTBL_ENTRY)&_ZN7S4217C14v103Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S4217C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S4217C1D1Ev,_ZThn56_N7S4217C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S4217C1D0Ev,_ZThn56_N7S4217C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4217C84v110Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v111Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v112Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v113Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v114Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v115Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v116Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v117Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v118Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v119Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v120Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v121Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v122Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v123Ev,
  (VTBL_ENTRY)&_ZN7S4217C84v124Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI7S4217C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N7S4217C1D1Ev,_ZThn60_N7S4217C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N7S4217C1D0Ev,_ZThn60_N7S4217C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4217C94v125Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v126Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v127Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v128Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v129Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v130Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v131Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v132Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v133Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v134Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v135Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v136Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v137Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v138Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v139Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v140Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v141Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v142Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v143Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v144Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v145Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v146Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v147Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v148Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v149Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v150Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v151Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v152Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v153Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v154Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v155Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v156Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v157Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v158Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v159Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v160Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v161Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v162Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v163Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v164Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v165Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v166Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v167Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v168Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v169Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v170Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v171Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v172Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v173Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v174Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v175Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v176Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v177Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v178Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v179Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v180Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v181Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v182Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v183Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v184Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v185Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v186Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v187Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v188Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v189Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v190Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v191Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v192Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v193Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v194Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v195Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v196Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v197Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v198Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v199Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v200Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v201Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v202Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v203Ev,
  (VTBL_ENTRY)&_ZN7S4217C94v204Ev,
  ABISELECT(-88,-64),
  (VTBL_ENTRY)&(_ZTI7S4217C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N7S4217C1D1Ev,_ZThn64_N7S4217C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N7S4217C1D0Ev,_ZThn64_N7S4217C1D0Ev),
  (VTBL_ENTRY)&_ZN8S4217C104v205Ev,
  ABISELECT(-96,-68),
  (VTBL_ENTRY)&(_ZTI7S4217C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S4217C1D1Ev,_ZThn68_N7S4217C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S4217C1D0Ev,_ZThn68_N7S4217C1D0Ev),
  ABISELECT(-120,-84),
  (VTBL_ENTRY)&(_ZTI7S4217C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn120_N7S4217C1D1Ev,_ZThn84_N7S4217C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn120_N7S4217C1D0Ev,_ZThn84_N7S4217C1D0Ev),
  (VTBL_ENTRY)&_ZN8S4217C184v206Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v207Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v208Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v209Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v210Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v211Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v212Ev,
  (VTBL_ENTRY)&_ZN8S4217C174v213Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v217Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v218Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v219Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v220Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v221Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v222Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v223Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v224Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v225Ev,
  (VTBL_ENTRY)&_ZN8S4217C164v226Ev,
  ABISELECT(-160,-108),
  (VTBL_ENTRY)&(_ZTI7S4217C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N7S4217C1D1Ev,_ZThn108_N7S4217C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N7S4217C1D0Ev,_ZThn108_N7S4217C1D0Ev),
  (VTBL_ENTRY)&_ZN8S4217C194v214Ev,
  (VTBL_ENTRY)&_ZN8S4217C194v215Ev,
  (VTBL_ENTRY)&_ZN8S4217C194v216Ev,
};
extern VTBL_ENTRY _ZTI7S4217C1[];
extern  VTBL_ENTRY _ZTV7S4217C1[];
Class_Descriptor cd_S4217C1 = {  "S4217C1", // class name
  bases_S4217C1, 10,
  &(vtc_S4217C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2776,2072), // object size
  NSPAIRA(_ZTI7S4217C1),ABISELECT(120,64), //typeinfo_var
  NSPAIRA(_ZTV7S4217C1),254, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  10, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C3  {
  virtual  ~S4218C3(); // _ZN7S4218C3D1Ev
  virtual void  v104(); // _ZN7S4218C34v104Ev
  virtual void  v105(); // _ZN7S4218C34v105Ev
  virtual void  v106(); // _ZN7S4218C34v106Ev
  S4218C3(); // tgen
};
//SIG(-1 S4218C3) C1{ vd v1 v2 v3}


 S4218C3 ::~S4218C3(){ note_dtor("S4218C3", this);}
void  S4218C3 ::v104(){vfunc_called(this, "_ZN7S4218C34v104Ev");}
void  S4218C3 ::v105(){vfunc_called(this, "_ZN7S4218C34v105Ev");}
void  S4218C3 ::v106(){vfunc_called(this, "_ZN7S4218C34v106Ev");}
S4218C3 ::S4218C3(){ note_ctor("S4218C3", this);} // tgen

static void Test_S4218C3()
{
  extern Class_Descriptor cd_S4218C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4218C3, buf);
    S4218C3 *dp, &lv = *(dp=new (buf) S4218C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4218C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C3)");
    test_class_info(&lv, &cd_S4218C3);
    dp->~S4218C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C3(Test_S4218C3, "S4218C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4218C3C1Ev();
extern void _ZN7S4218C3D1Ev();
Name_Map name_map_S4218C3[] = {
  NSPAIR(_ZN7S4218C3C1Ev),
  NSPAIR(_ZN7S4218C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4218C3[];
extern void _ZN7S4218C3D1Ev();
extern void _ZN7S4218C3D0Ev();
extern void _ZN7S4218C34v104Ev();
extern void _ZN7S4218C34v105Ev();
extern void _ZN7S4218C34v106Ev();
static  VTBL_ENTRY vtc_S4218C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4218C3[0]),
  (VTBL_ENTRY)&_ZN7S4218C3D1Ev,
  (VTBL_ENTRY)&_ZN7S4218C3D0Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v104Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v105Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v106Ev,
};
extern VTBL_ENTRY _ZTI7S4218C3[];
extern  VTBL_ENTRY _ZTV7S4218C3[];
Class_Descriptor cd_S4218C3 = {  "S4218C3", // class name
  0,0,//no base classes
  &(vtc_S4218C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4218C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4218C3),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C6_nt  {
  __tsi64 s4218c6f0[4];
  void  mf4218c6(); // _ZN10S4218C6_nt8mf4218c6Ev
};
//SIG(-1 S4218C6_nt) C1{ m FL[4]}


void  S4218C6_nt ::mf4218c6(){}

//skip512 S4218C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C2  : S4218C3 {
  ::S4216C72 s4218c2f0;
  ::S4218C6_nt s4218c2f1;
  char s4218c2f2;
  virtual  ~S4218C2(); // _ZN7S4218C2D1Ev
  virtual void  v107(); // _ZN7S4218C24v107Ev
  virtual void  v108(); // _ZN7S4218C24v108Ev
  virtual void  v109(); // _ZN7S4218C24v109Ev
  S4218C2(); // tgen
};
//SIG(-1 S4218C2) C1{ BC2{ vd v4 v5 v6} vd v1 v2 v3 FC3{ m Fp Fi[2] FC4{ m}} FC5{ m FL[4]} Fc}


 S4218C2 ::~S4218C2(){ note_dtor("S4218C2", this);}
void  S4218C2 ::v107(){vfunc_called(this, "_ZN7S4218C24v107Ev");}
void  S4218C2 ::v108(){vfunc_called(this, "_ZN7S4218C24v108Ev");}
void  S4218C2 ::v109(){vfunc_called(this, "_ZN7S4218C24v109Ev");}
S4218C2 ::S4218C2(){ note_ctor("S4218C2", this);} // tgen

static void Test_S4218C2()
{
  extern Class_Descriptor cd_S4218C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S4218C2, buf);
    S4218C2 *dp, &lv = *(dp=new (buf) S4218C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S4218C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C2)");
    check_base_class_offset(lv, (S4218C3*), 0, "S4218C2");
    check_field_offset(lv, s4218c2f0, ABISELECT(8,4), "S4218C2.s4218c2f0");
    check_field_offset(lv, s4218c2f1, ABISELECT(32,20), "S4218C2.s4218c2f1");
    check_field_offset(lv, s4218c2f2, ABISELECT(64,52), "S4218C2.s4218c2f2");
    test_class_info(&lv, &cd_S4218C2);
    dp->~S4218C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C2(Test_S4218C2, "S4218C2", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S4218C2C1Ev();
extern void _ZN7S4218C2D1Ev();
Name_Map name_map_S4218C2[] = {
  NSPAIR(_ZN7S4218C2C1Ev),
  NSPAIR(_ZN7S4218C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4218C3;
extern VTBL_ENTRY _ZTI7S4218C3[];
extern  VTBL_ENTRY _ZTV7S4218C3[];
static Base_Class bases_S4218C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4218C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4218C2[];
extern void _ZN7S4218C2D1Ev();
extern void _ZN7S4218C2D0Ev();
extern void _ZN7S4218C34v104Ev();
extern void _ZN7S4218C34v105Ev();
extern void _ZN7S4218C34v106Ev();
extern void _ZN7S4218C24v107Ev();
extern void _ZN7S4218C24v108Ev();
extern void _ZN7S4218C24v109Ev();
static  VTBL_ENTRY vtc_S4218C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4218C2[0]),
  (VTBL_ENTRY)&_ZN7S4218C2D1Ev,
  (VTBL_ENTRY)&_ZN7S4218C2D0Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v104Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v105Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v106Ev,
  (VTBL_ENTRY)&_ZN7S4218C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4218C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4218C24v109Ev,
};
extern VTBL_ENTRY _ZTI7S4218C2[];
extern  VTBL_ENTRY _ZTV7S4218C2[];
Class_Descriptor cd_S4218C2 = {  "S4218C2", // class name
  bases_S4218C2, 1,
  &(vtc_S4218C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S4218C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4218C2),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C7  {
  virtual  ~S4218C7(); // _ZN7S4218C7D1Ev
  virtual void  v110(); // _ZN7S4218C74v110Ev
  virtual void  v111(); // _ZN7S4218C74v111Ev
  virtual void  v112(); // _ZN7S4218C74v112Ev
  virtual void  v113(); // _ZN7S4218C74v113Ev
  virtual void  v114(); // _ZN7S4218C74v114Ev
  virtual void  v115(); // _ZN7S4218C74v115Ev
  virtual void  v116(); // _ZN7S4218C74v116Ev
  virtual void  v117(); // _ZN7S4218C74v117Ev
  virtual void  v118(); // _ZN7S4218C74v118Ev
  virtual void  v119(); // _ZN7S4218C74v119Ev
  virtual void  v120(); // _ZN7S4218C74v120Ev
  virtual void  v121(); // _ZN7S4218C74v121Ev
  virtual void  v122(); // _ZN7S4218C74v122Ev
  virtual void  v123(); // _ZN7S4218C74v123Ev
  virtual void  v124(); // _ZN7S4218C74v124Ev
  S4218C7(); // tgen
};
//SIG(-1 S4218C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15}


 S4218C7 ::~S4218C7(){ note_dtor("S4218C7", this);}
void  S4218C7 ::v110(){vfunc_called(this, "_ZN7S4218C74v110Ev");}
void  S4218C7 ::v111(){vfunc_called(this, "_ZN7S4218C74v111Ev");}
void  S4218C7 ::v112(){vfunc_called(this, "_ZN7S4218C74v112Ev");}
void  S4218C7 ::v113(){vfunc_called(this, "_ZN7S4218C74v113Ev");}
void  S4218C7 ::v114(){vfunc_called(this, "_ZN7S4218C74v114Ev");}
void  S4218C7 ::v115(){vfunc_called(this, "_ZN7S4218C74v115Ev");}
void  S4218C7 ::v116(){vfunc_called(this, "_ZN7S4218C74v116Ev");}
void  S4218C7 ::v117(){vfunc_called(this, "_ZN7S4218C74v117Ev");}
void  S4218C7 ::v118(){vfunc_called(this, "_ZN7S4218C74v118Ev");}
void  S4218C7 ::v119(){vfunc_called(this, "_ZN7S4218C74v119Ev");}
void  S4218C7 ::v120(){vfunc_called(this, "_ZN7S4218C74v120Ev");}
void  S4218C7 ::v121(){vfunc_called(this, "_ZN7S4218C74v121Ev");}
void  S4218C7 ::v122(){vfunc_called(this, "_ZN7S4218C74v122Ev");}
void  S4218C7 ::v123(){vfunc_called(this, "_ZN7S4218C74v123Ev");}
void  S4218C7 ::v124(){vfunc_called(this, "_ZN7S4218C74v124Ev");}
S4218C7 ::S4218C7(){ note_ctor("S4218C7", this);} // tgen

static void Test_S4218C7()
{
  extern Class_Descriptor cd_S4218C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4218C7, buf);
    S4218C7 *dp, &lv = *(dp=new (buf) S4218C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4218C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C7)");
    test_class_info(&lv, &cd_S4218C7);
    dp->~S4218C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C7(Test_S4218C7, "S4218C7", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4218C7C1Ev();
extern void _ZN7S4218C7D1Ev();
Name_Map name_map_S4218C7[] = {
  NSPAIR(_ZN7S4218C7C1Ev),
  NSPAIR(_ZN7S4218C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4218C7[];
extern void _ZN7S4218C7D1Ev();
extern void _ZN7S4218C7D0Ev();
extern void _ZN7S4218C74v110Ev();
extern void _ZN7S4218C74v111Ev();
extern void _ZN7S4218C74v112Ev();
extern void _ZN7S4218C74v113Ev();
extern void _ZN7S4218C74v114Ev();
extern void _ZN7S4218C74v115Ev();
extern void _ZN7S4218C74v116Ev();
extern void _ZN7S4218C74v117Ev();
extern void _ZN7S4218C74v118Ev();
extern void _ZN7S4218C74v119Ev();
extern void _ZN7S4218C74v120Ev();
extern void _ZN7S4218C74v121Ev();
extern void _ZN7S4218C74v122Ev();
extern void _ZN7S4218C74v123Ev();
extern void _ZN7S4218C74v124Ev();
static  VTBL_ENTRY vtc_S4218C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4218C7[0]),
  (VTBL_ENTRY)&_ZN7S4218C7D1Ev,
  (VTBL_ENTRY)&_ZN7S4218C7D0Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v110Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v111Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v112Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v113Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v114Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v115Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v116Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v117Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v118Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v119Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v120Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v121Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v122Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v123Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v124Ev,
};
extern VTBL_ENTRY _ZTI7S4218C7[];
extern  VTBL_ENTRY _ZTV7S4218C7[];
Class_Descriptor cd_S4218C7 = {  "S4218C7", // class name
  0,0,//no base classes
  &(vtc_S4218C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4218C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4218C7),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C8  {
  virtual  ~S4218C8(); // _ZN7S4218C8D1Ev
  virtual void  v125(); // _ZN7S4218C84v125Ev
  virtual void  v126(); // _ZN7S4218C84v126Ev
  virtual void  v127(); // _ZN7S4218C84v127Ev
  virtual void  v128(); // _ZN7S4218C84v128Ev
  virtual void  v129(); // _ZN7S4218C84v129Ev
  virtual void  v130(); // _ZN7S4218C84v130Ev
  virtual void  v131(); // _ZN7S4218C84v131Ev
  virtual void  v132(); // _ZN7S4218C84v132Ev
  virtual void  v133(); // _ZN7S4218C84v133Ev
  virtual void  v134(); // _ZN7S4218C84v134Ev
  virtual void  v135(); // _ZN7S4218C84v135Ev
  virtual void  v136(); // _ZN7S4218C84v136Ev
  virtual void  v137(); // _ZN7S4218C84v137Ev
  virtual void  v138(); // _ZN7S4218C84v138Ev
  virtual void  v139(); // _ZN7S4218C84v139Ev
  virtual void  v140(); // _ZN7S4218C84v140Ev
  virtual void  v141(); // _ZN7S4218C84v141Ev
  virtual void  v142(); // _ZN7S4218C84v142Ev
  virtual void  v143(); // _ZN7S4218C84v143Ev
  virtual void  v144(); // _ZN7S4218C84v144Ev
  virtual void  v145(); // _ZN7S4218C84v145Ev
  virtual void  v146(); // _ZN7S4218C84v146Ev
  virtual void  v147(); // _ZN7S4218C84v147Ev
  virtual void  v148(); // _ZN7S4218C84v148Ev
  virtual void  v149(); // _ZN7S4218C84v149Ev
  virtual void  v150(); // _ZN7S4218C84v150Ev
  virtual void  v151(); // _ZN7S4218C84v151Ev
  virtual void  v152(); // _ZN7S4218C84v152Ev
  virtual void  v153(); // _ZN7S4218C84v153Ev
  virtual void  v154(); // _ZN7S4218C84v154Ev
  virtual void  v155(); // _ZN7S4218C84v155Ev
  virtual void  v156(); // _ZN7S4218C84v156Ev
  virtual void  v157(); // _ZN7S4218C84v157Ev
  virtual void  v158(); // _ZN7S4218C84v158Ev
  virtual void  v159(); // _ZN7S4218C84v159Ev
  virtual void  v160(); // _ZN7S4218C84v160Ev
  virtual void  v161(); // _ZN7S4218C84v161Ev
  virtual void  v162(); // _ZN7S4218C84v162Ev
  virtual void  v163(); // _ZN7S4218C84v163Ev
  virtual void  v164(); // _ZN7S4218C84v164Ev
  virtual void  v165(); // _ZN7S4218C84v165Ev
  virtual void  v166(); // _ZN7S4218C84v166Ev
  virtual void  v167(); // _ZN7S4218C84v167Ev
  virtual void  v168(); // _ZN7S4218C84v168Ev
  virtual void  v169(); // _ZN7S4218C84v169Ev
  virtual void  v170(); // _ZN7S4218C84v170Ev
  virtual void  v171(); // _ZN7S4218C84v171Ev
  virtual void  v172(); // _ZN7S4218C84v172Ev
  virtual void  v173(); // _ZN7S4218C84v173Ev
  virtual void  v174(); // _ZN7S4218C84v174Ev
  virtual void  v175(); // _ZN7S4218C84v175Ev
  virtual void  v176(); // _ZN7S4218C84v176Ev
  virtual void  v177(); // _ZN7S4218C84v177Ev
  virtual void  v178(); // _ZN7S4218C84v178Ev
  virtual void  v179(); // _ZN7S4218C84v179Ev
  virtual void  v180(); // _ZN7S4218C84v180Ev
  virtual void  v181(); // _ZN7S4218C84v181Ev
  virtual void  v182(); // _ZN7S4218C84v182Ev
  virtual void  v183(); // _ZN7S4218C84v183Ev
  virtual void  v184(); // _ZN7S4218C84v184Ev
  virtual void  v185(); // _ZN7S4218C84v185Ev
  virtual void  v186(); // _ZN7S4218C84v186Ev
  virtual void  v187(); // _ZN7S4218C84v187Ev
  virtual void  v188(); // _ZN7S4218C84v188Ev
  virtual void  v189(); // _ZN7S4218C84v189Ev
  virtual void  v190(); // _ZN7S4218C84v190Ev
  virtual void  v191(); // _ZN7S4218C84v191Ev
  virtual void  v192(); // _ZN7S4218C84v192Ev
  virtual void  v193(); // _ZN7S4218C84v193Ev
  virtual void  v194(); // _ZN7S4218C84v194Ev
  virtual void  v195(); // _ZN7S4218C84v195Ev
  virtual void  v196(); // _ZN7S4218C84v196Ev
  virtual void  v197(); // _ZN7S4218C84v197Ev
  virtual void  v198(); // _ZN7S4218C84v198Ev
  virtual void  v199(); // _ZN7S4218C84v199Ev
  virtual void  v200(); // _ZN7S4218C84v200Ev
  virtual void  v201(); // _ZN7S4218C84v201Ev
  virtual void  v202(); // _ZN7S4218C84v202Ev
  virtual void  v203(); // _ZN7S4218C84v203Ev
  virtual void  v204(); // _ZN7S4218C84v204Ev
  S4218C8(); // tgen
};
//SIG(-1 S4218C8) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80}


 S4218C8 ::~S4218C8(){ note_dtor("S4218C8", this);}
void  S4218C8 ::v125(){vfunc_called(this, "_ZN7S4218C84v125Ev");}
void  S4218C8 ::v126(){vfunc_called(this, "_ZN7S4218C84v126Ev");}
void  S4218C8 ::v127(){vfunc_called(this, "_ZN7S4218C84v127Ev");}
void  S4218C8 ::v128(){vfunc_called(this, "_ZN7S4218C84v128Ev");}
void  S4218C8 ::v129(){vfunc_called(this, "_ZN7S4218C84v129Ev");}
void  S4218C8 ::v130(){vfunc_called(this, "_ZN7S4218C84v130Ev");}
void  S4218C8 ::v131(){vfunc_called(this, "_ZN7S4218C84v131Ev");}
void  S4218C8 ::v132(){vfunc_called(this, "_ZN7S4218C84v132Ev");}
void  S4218C8 ::v133(){vfunc_called(this, "_ZN7S4218C84v133Ev");}
void  S4218C8 ::v134(){vfunc_called(this, "_ZN7S4218C84v134Ev");}
void  S4218C8 ::v135(){vfunc_called(this, "_ZN7S4218C84v135Ev");}
void  S4218C8 ::v136(){vfunc_called(this, "_ZN7S4218C84v136Ev");}
void  S4218C8 ::v137(){vfunc_called(this, "_ZN7S4218C84v137Ev");}
void  S4218C8 ::v138(){vfunc_called(this, "_ZN7S4218C84v138Ev");}
void  S4218C8 ::v139(){vfunc_called(this, "_ZN7S4218C84v139Ev");}
void  S4218C8 ::v140(){vfunc_called(this, "_ZN7S4218C84v140Ev");}
void  S4218C8 ::v141(){vfunc_called(this, "_ZN7S4218C84v141Ev");}
void  S4218C8 ::v142(){vfunc_called(this, "_ZN7S4218C84v142Ev");}
void  S4218C8 ::v143(){vfunc_called(this, "_ZN7S4218C84v143Ev");}
void  S4218C8 ::v144(){vfunc_called(this, "_ZN7S4218C84v144Ev");}
void  S4218C8 ::v145(){vfunc_called(this, "_ZN7S4218C84v145Ev");}
void  S4218C8 ::v146(){vfunc_called(this, "_ZN7S4218C84v146Ev");}
void  S4218C8 ::v147(){vfunc_called(this, "_ZN7S4218C84v147Ev");}
void  S4218C8 ::v148(){vfunc_called(this, "_ZN7S4218C84v148Ev");}
void  S4218C8 ::v149(){vfunc_called(this, "_ZN7S4218C84v149Ev");}
void  S4218C8 ::v150(){vfunc_called(this, "_ZN7S4218C84v150Ev");}
void  S4218C8 ::v151(){vfunc_called(this, "_ZN7S4218C84v151Ev");}
void  S4218C8 ::v152(){vfunc_called(this, "_ZN7S4218C84v152Ev");}
void  S4218C8 ::v153(){vfunc_called(this, "_ZN7S4218C84v153Ev");}
void  S4218C8 ::v154(){vfunc_called(this, "_ZN7S4218C84v154Ev");}
void  S4218C8 ::v155(){vfunc_called(this, "_ZN7S4218C84v155Ev");}
void  S4218C8 ::v156(){vfunc_called(this, "_ZN7S4218C84v156Ev");}
void  S4218C8 ::v157(){vfunc_called(this, "_ZN7S4218C84v157Ev");}
void  S4218C8 ::v158(){vfunc_called(this, "_ZN7S4218C84v158Ev");}
void  S4218C8 ::v159(){vfunc_called(this, "_ZN7S4218C84v159Ev");}
void  S4218C8 ::v160(){vfunc_called(this, "_ZN7S4218C84v160Ev");}
void  S4218C8 ::v161(){vfunc_called(this, "_ZN7S4218C84v161Ev");}
void  S4218C8 ::v162(){vfunc_called(this, "_ZN7S4218C84v162Ev");}
void  S4218C8 ::v163(){vfunc_called(this, "_ZN7S4218C84v163Ev");}
void  S4218C8 ::v164(){vfunc_called(this, "_ZN7S4218C84v164Ev");}
void  S4218C8 ::v165(){vfunc_called(this, "_ZN7S4218C84v165Ev");}
void  S4218C8 ::v166(){vfunc_called(this, "_ZN7S4218C84v166Ev");}
void  S4218C8 ::v167(){vfunc_called(this, "_ZN7S4218C84v167Ev");}
void  S4218C8 ::v168(){vfunc_called(this, "_ZN7S4218C84v168Ev");}
void  S4218C8 ::v169(){vfunc_called(this, "_ZN7S4218C84v169Ev");}
void  S4218C8 ::v170(){vfunc_called(this, "_ZN7S4218C84v170Ev");}
void  S4218C8 ::v171(){vfunc_called(this, "_ZN7S4218C84v171Ev");}
void  S4218C8 ::v172(){vfunc_called(this, "_ZN7S4218C84v172Ev");}
void  S4218C8 ::v173(){vfunc_called(this, "_ZN7S4218C84v173Ev");}
void  S4218C8 ::v174(){vfunc_called(this, "_ZN7S4218C84v174Ev");}
void  S4218C8 ::v175(){vfunc_called(this, "_ZN7S4218C84v175Ev");}
void  S4218C8 ::v176(){vfunc_called(this, "_ZN7S4218C84v176Ev");}
void  S4218C8 ::v177(){vfunc_called(this, "_ZN7S4218C84v177Ev");}
void  S4218C8 ::v178(){vfunc_called(this, "_ZN7S4218C84v178Ev");}
void  S4218C8 ::v179(){vfunc_called(this, "_ZN7S4218C84v179Ev");}
void  S4218C8 ::v180(){vfunc_called(this, "_ZN7S4218C84v180Ev");}
void  S4218C8 ::v181(){vfunc_called(this, "_ZN7S4218C84v181Ev");}
void  S4218C8 ::v182(){vfunc_called(this, "_ZN7S4218C84v182Ev");}
void  S4218C8 ::v183(){vfunc_called(this, "_ZN7S4218C84v183Ev");}
void  S4218C8 ::v184(){vfunc_called(this, "_ZN7S4218C84v184Ev");}
void  S4218C8 ::v185(){vfunc_called(this, "_ZN7S4218C84v185Ev");}
void  S4218C8 ::v186(){vfunc_called(this, "_ZN7S4218C84v186Ev");}
void  S4218C8 ::v187(){vfunc_called(this, "_ZN7S4218C84v187Ev");}
void  S4218C8 ::v188(){vfunc_called(this, "_ZN7S4218C84v188Ev");}
void  S4218C8 ::v189(){vfunc_called(this, "_ZN7S4218C84v189Ev");}
void  S4218C8 ::v190(){vfunc_called(this, "_ZN7S4218C84v190Ev");}
void  S4218C8 ::v191(){vfunc_called(this, "_ZN7S4218C84v191Ev");}
void  S4218C8 ::v192(){vfunc_called(this, "_ZN7S4218C84v192Ev");}
void  S4218C8 ::v193(){vfunc_called(this, "_ZN7S4218C84v193Ev");}
void  S4218C8 ::v194(){vfunc_called(this, "_ZN7S4218C84v194Ev");}
void  S4218C8 ::v195(){vfunc_called(this, "_ZN7S4218C84v195Ev");}
void  S4218C8 ::v196(){vfunc_called(this, "_ZN7S4218C84v196Ev");}
void  S4218C8 ::v197(){vfunc_called(this, "_ZN7S4218C84v197Ev");}
void  S4218C8 ::v198(){vfunc_called(this, "_ZN7S4218C84v198Ev");}
void  S4218C8 ::v199(){vfunc_called(this, "_ZN7S4218C84v199Ev");}
void  S4218C8 ::v200(){vfunc_called(this, "_ZN7S4218C84v200Ev");}
void  S4218C8 ::v201(){vfunc_called(this, "_ZN7S4218C84v201Ev");}
void  S4218C8 ::v202(){vfunc_called(this, "_ZN7S4218C84v202Ev");}
void  S4218C8 ::v203(){vfunc_called(this, "_ZN7S4218C84v203Ev");}
void  S4218C8 ::v204(){vfunc_called(this, "_ZN7S4218C84v204Ev");}
S4218C8 ::S4218C8(){ note_ctor("S4218C8", this);} // tgen

static void Test_S4218C8()
{
  extern Class_Descriptor cd_S4218C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4218C8, buf);
    S4218C8 *dp, &lv = *(dp=new (buf) S4218C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4218C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C8)");
    test_class_info(&lv, &cd_S4218C8);
    dp->~S4218C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C8(Test_S4218C8, "S4218C8", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4218C8C1Ev();
extern void _ZN7S4218C8D1Ev();
Name_Map name_map_S4218C8[] = {
  NSPAIR(_ZN7S4218C8C1Ev),
  NSPAIR(_ZN7S4218C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4218C8[];
extern void _ZN7S4218C8D1Ev();
extern void _ZN7S4218C8D0Ev();
extern void _ZN7S4218C84v125Ev();
extern void _ZN7S4218C84v126Ev();
extern void _ZN7S4218C84v127Ev();
extern void _ZN7S4218C84v128Ev();
extern void _ZN7S4218C84v129Ev();
extern void _ZN7S4218C84v130Ev();
extern void _ZN7S4218C84v131Ev();
extern void _ZN7S4218C84v132Ev();
extern void _ZN7S4218C84v133Ev();
extern void _ZN7S4218C84v134Ev();
extern void _ZN7S4218C84v135Ev();
extern void _ZN7S4218C84v136Ev();
extern void _ZN7S4218C84v137Ev();
extern void _ZN7S4218C84v138Ev();
extern void _ZN7S4218C84v139Ev();
extern void _ZN7S4218C84v140Ev();
extern void _ZN7S4218C84v141Ev();
extern void _ZN7S4218C84v142Ev();
extern void _ZN7S4218C84v143Ev();
extern void _ZN7S4218C84v144Ev();
extern void _ZN7S4218C84v145Ev();
extern void _ZN7S4218C84v146Ev();
extern void _ZN7S4218C84v147Ev();
extern void _ZN7S4218C84v148Ev();
extern void _ZN7S4218C84v149Ev();
extern void _ZN7S4218C84v150Ev();
extern void _ZN7S4218C84v151Ev();
extern void _ZN7S4218C84v152Ev();
extern void _ZN7S4218C84v153Ev();
extern void _ZN7S4218C84v154Ev();
extern void _ZN7S4218C84v155Ev();
extern void _ZN7S4218C84v156Ev();
extern void _ZN7S4218C84v157Ev();
extern void _ZN7S4218C84v158Ev();
extern void _ZN7S4218C84v159Ev();
extern void _ZN7S4218C84v160Ev();
extern void _ZN7S4218C84v161Ev();
extern void _ZN7S4218C84v162Ev();
extern void _ZN7S4218C84v163Ev();
extern void _ZN7S4218C84v164Ev();
extern void _ZN7S4218C84v165Ev();
extern void _ZN7S4218C84v166Ev();
extern void _ZN7S4218C84v167Ev();
extern void _ZN7S4218C84v168Ev();
extern void _ZN7S4218C84v169Ev();
extern void _ZN7S4218C84v170Ev();
extern void _ZN7S4218C84v171Ev();
extern void _ZN7S4218C84v172Ev();
extern void _ZN7S4218C84v173Ev();
extern void _ZN7S4218C84v174Ev();
extern void _ZN7S4218C84v175Ev();
extern void _ZN7S4218C84v176Ev();
extern void _ZN7S4218C84v177Ev();
extern void _ZN7S4218C84v178Ev();
extern void _ZN7S4218C84v179Ev();
extern void _ZN7S4218C84v180Ev();
extern void _ZN7S4218C84v181Ev();
extern void _ZN7S4218C84v182Ev();
extern void _ZN7S4218C84v183Ev();
extern void _ZN7S4218C84v184Ev();
extern void _ZN7S4218C84v185Ev();
extern void _ZN7S4218C84v186Ev();
extern void _ZN7S4218C84v187Ev();
extern void _ZN7S4218C84v188Ev();
extern void _ZN7S4218C84v189Ev();
extern void _ZN7S4218C84v190Ev();
extern void _ZN7S4218C84v191Ev();
extern void _ZN7S4218C84v192Ev();
extern void _ZN7S4218C84v193Ev();
extern void _ZN7S4218C84v194Ev();
extern void _ZN7S4218C84v195Ev();
extern void _ZN7S4218C84v196Ev();
extern void _ZN7S4218C84v197Ev();
extern void _ZN7S4218C84v198Ev();
extern void _ZN7S4218C84v199Ev();
extern void _ZN7S4218C84v200Ev();
extern void _ZN7S4218C84v201Ev();
extern void _ZN7S4218C84v202Ev();
extern void _ZN7S4218C84v203Ev();
extern void _ZN7S4218C84v204Ev();
static  VTBL_ENTRY vtc_S4218C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4218C8[0]),
  (VTBL_ENTRY)&_ZN7S4218C8D1Ev,
  (VTBL_ENTRY)&_ZN7S4218C8D0Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v125Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v126Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v127Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v128Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v129Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v130Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v131Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v132Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v133Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v134Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v135Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v136Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v137Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v138Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v139Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v140Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v141Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v142Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v143Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v144Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v145Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v146Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v147Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v148Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v149Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v150Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v151Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v152Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v153Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v154Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v155Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v156Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v157Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v158Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v159Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v160Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v161Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v162Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v163Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v164Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v165Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v166Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v167Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v168Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v169Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v170Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v171Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v172Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v173Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v174Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v175Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v176Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v177Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v178Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v179Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v180Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v181Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v182Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v183Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v184Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v185Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v186Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v187Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v188Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v189Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v190Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v191Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v192Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v193Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v194Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v195Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v196Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v197Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v198Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v199Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v200Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v201Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v202Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v203Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v204Ev,
};
extern VTBL_ENTRY _ZTI7S4218C8[];
extern  VTBL_ENTRY _ZTV7S4218C8[];
Class_Descriptor cd_S4218C8 = {  "S4218C8", // class name
  0,0,//no base classes
  &(vtc_S4218C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4218C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4218C8),84, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C9  {
  virtual  ~S4218C9(); // _ZN7S4218C9D1Ev
  virtual void  v205(); // _ZN7S4218C94v205Ev
  S4218C9(); // tgen
};
//SIG(-1 S4218C9) C1{ vd v1}


 S4218C9 ::~S4218C9(){ note_dtor("S4218C9", this);}
void  S4218C9 ::v205(){vfunc_called(this, "_ZN7S4218C94v205Ev");}
S4218C9 ::S4218C9(){ note_ctor("S4218C9", this);} // tgen

static void Test_S4218C9()
{
  extern Class_Descriptor cd_S4218C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4218C9, buf);
    S4218C9 *dp, &lv = *(dp=new (buf) S4218C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4218C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C9)");
    test_class_info(&lv, &cd_S4218C9);
    dp->~S4218C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C9(Test_S4218C9, "S4218C9", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S4218C9C1Ev();
extern void _ZN7S4218C9D1Ev();
Name_Map name_map_S4218C9[] = {
  NSPAIR(_ZN7S4218C9C1Ev),
  NSPAIR(_ZN7S4218C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4218C9[];
extern void _ZN7S4218C9D1Ev();
extern void _ZN7S4218C9D0Ev();
extern void _ZN7S4218C94v205Ev();
static  VTBL_ENTRY vtc_S4218C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4218C9[0]),
  (VTBL_ENTRY)&_ZN7S4218C9D1Ev,
  (VTBL_ENTRY)&_ZN7S4218C9D0Ev,
  (VTBL_ENTRY)&_ZN7S4218C94v205Ev,
};
extern VTBL_ENTRY _ZTI7S4218C9[];
extern  VTBL_ENTRY _ZTV7S4218C9[];
Class_Descriptor cd_S4218C9 = {  "S4218C9", // class name
  0,0,//no base classes
  &(vtc_S4218C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S4218C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4218C9),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C17  {
  int s4218c17f0;
  char s4218c17f1[3];
  virtual  ~S4218C17(); // _ZN8S4218C17D1Ev
  virtual void  v206(); // _ZN8S4218C174v206Ev
  S4218C17(); // tgen
};
//SIG(-1 S4218C17) C1{ vd v1 Fi Fc[3]}


 S4218C17 ::~S4218C17(){ note_dtor("S4218C17", this);}
void  S4218C17 ::v206(){vfunc_called(this, "_ZN8S4218C174v206Ev");}
S4218C17 ::S4218C17(){ note_ctor("S4218C17", this);} // tgen

static void Test_S4218C17()
{
  extern Class_Descriptor cd_S4218C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S4218C17, buf);
    S4218C17 *dp, &lv = *(dp=new (buf) S4218C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S4218C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C17)");
    check_field_offset(lv, s4218c17f0, ABISELECT(8,4), "S4218C17.s4218c17f0");
    check_field_offset(lv, s4218c17f1, ABISELECT(12,8), "S4218C17.s4218c17f1");
    test_class_info(&lv, &cd_S4218C17);
    dp->~S4218C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C17(Test_S4218C17, "S4218C17", ABISELECT(16,12));

#else // __cplusplus

extern void _ZN8S4218C17C1Ev();
extern void _ZN8S4218C17D1Ev();
Name_Map name_map_S4218C17[] = {
  NSPAIR(_ZN8S4218C17C1Ev),
  NSPAIR(_ZN8S4218C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4218C17[];
extern void _ZN8S4218C17D1Ev();
extern void _ZN8S4218C17D0Ev();
extern void _ZN8S4218C174v206Ev();
static  VTBL_ENTRY vtc_S4218C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4218C17[0]),
  (VTBL_ENTRY)&_ZN8S4218C17D1Ev,
  (VTBL_ENTRY)&_ZN8S4218C17D0Ev,
  (VTBL_ENTRY)&_ZN8S4218C174v206Ev,
};
extern VTBL_ENTRY _ZTI8S4218C17[];
extern  VTBL_ENTRY _ZTV8S4218C17[];
Class_Descriptor cd_S4218C17 = {  "S4218C17", // class name
  0,0,//no base classes
  &(vtc_S4218C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI8S4218C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4218C17),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C16  : S4218C17 {
  void *s4218c16f0[2];
  int s4218c16f1;
  virtual  ~S4218C16(); // _ZN8S4218C16D1Ev
  virtual void  v207(); // _ZN8S4218C164v207Ev
  virtual void  v208(); // _ZN8S4218C164v208Ev
  virtual void  v209(); // _ZN8S4218C164v209Ev
  virtual void  v210(); // _ZN8S4218C164v210Ev
  virtual void  v211(); // _ZN8S4218C164v211Ev
  virtual void  v212(); // _ZN8S4218C164v212Ev
  virtual void  v213(); // _ZN8S4218C164v213Ev
  S4218C16(); // tgen
};
//SIG(-1 S4218C16) C1{ BC2{ vd v8 Fi Fc[3]} vd v1 v2 v3 v4 v5 v6 v7 Fp[2] Fi}


 S4218C16 ::~S4218C16(){ note_dtor("S4218C16", this);}
void  S4218C16 ::v207(){vfunc_called(this, "_ZN8S4218C164v207Ev");}
void  S4218C16 ::v208(){vfunc_called(this, "_ZN8S4218C164v208Ev");}
void  S4218C16 ::v209(){vfunc_called(this, "_ZN8S4218C164v209Ev");}
void  S4218C16 ::v210(){vfunc_called(this, "_ZN8S4218C164v210Ev");}
void  S4218C16 ::v211(){vfunc_called(this, "_ZN8S4218C164v211Ev");}
void  S4218C16 ::v212(){vfunc_called(this, "_ZN8S4218C164v212Ev");}
void  S4218C16 ::v213(){vfunc_called(this, "_ZN8S4218C164v213Ev");}
S4218C16 ::S4218C16(){ note_ctor("S4218C16", this);} // tgen

static void Test_S4218C16()
{
  extern Class_Descriptor cd_S4218C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S4218C16, buf);
    S4218C16 *dp, &lv = *(dp=new (buf) S4218C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S4218C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C16)");
    check_base_class_offset(lv, (S4218C17*), 0, "S4218C16");
    check_field_offset(lv, s4218c16f0, ABISELECT(16,12), "S4218C16.s4218c16f0");
    check_field_offset(lv, s4218c16f1, ABISELECT(32,20), "S4218C16.s4218c16f1");
    test_class_info(&lv, &cd_S4218C16);
    dp->~S4218C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C16(Test_S4218C16, "S4218C16", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN8S4218C16C1Ev();
extern void _ZN8S4218C16D1Ev();
Name_Map name_map_S4218C16[] = {
  NSPAIR(_ZN8S4218C16C1Ev),
  NSPAIR(_ZN8S4218C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4218C17;
extern VTBL_ENTRY _ZTI8S4218C17[];
extern  VTBL_ENTRY _ZTV8S4218C17[];
static Base_Class bases_S4218C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4218C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4218C16[];
extern void _ZN8S4218C16D1Ev();
extern void _ZN8S4218C16D0Ev();
extern void _ZN8S4218C174v206Ev();
extern void _ZN8S4218C164v207Ev();
extern void _ZN8S4218C164v208Ev();
extern void _ZN8S4218C164v209Ev();
extern void _ZN8S4218C164v210Ev();
extern void _ZN8S4218C164v211Ev();
extern void _ZN8S4218C164v212Ev();
extern void _ZN8S4218C164v213Ev();
static  VTBL_ENTRY vtc_S4218C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4218C16[0]),
  (VTBL_ENTRY)&_ZN8S4218C16D1Ev,
  (VTBL_ENTRY)&_ZN8S4218C16D0Ev,
  (VTBL_ENTRY)&_ZN8S4218C174v206Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v207Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v208Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v209Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v210Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v211Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v212Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v213Ev,
};
extern VTBL_ENTRY _ZTI8S4218C16[];
extern  VTBL_ENTRY _ZTV8S4218C16[];
Class_Descriptor cd_S4218C16 = {  "S4218C16", // class name
  bases_S4218C16, 1,
  &(vtc_S4218C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S4218C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S4218C16),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C18  {
  virtual  ~S4218C18(); // _ZN8S4218C18D1Ev
  virtual void  v214(); // _ZN8S4218C184v214Ev
  virtual void  v215(); // _ZN8S4218C184v215Ev
  virtual void  v216(); // _ZN8S4218C184v216Ev
  S4218C18(); // tgen
};
//SIG(-1 S4218C18) C1{ vd v1 v2 v3}


 S4218C18 ::~S4218C18(){ note_dtor("S4218C18", this);}
void  S4218C18 ::v214(){vfunc_called(this, "_ZN8S4218C184v214Ev");}
void  S4218C18 ::v215(){vfunc_called(this, "_ZN8S4218C184v215Ev");}
void  S4218C18 ::v216(){vfunc_called(this, "_ZN8S4218C184v216Ev");}
S4218C18 ::S4218C18(){ note_ctor("S4218C18", this);} // tgen

static void Test_S4218C18()
{
  extern Class_Descriptor cd_S4218C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4218C18, buf);
    S4218C18 *dp, &lv = *(dp=new (buf) S4218C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4218C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C18)");
    test_class_info(&lv, &cd_S4218C18);
    dp->~S4218C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C18(Test_S4218C18, "S4218C18", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S4218C18C1Ev();
extern void _ZN8S4218C18D1Ev();
Name_Map name_map_S4218C18[] = {
  NSPAIR(_ZN8S4218C18C1Ev),
  NSPAIR(_ZN8S4218C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4218C18[];
extern void _ZN8S4218C18D1Ev();
extern void _ZN8S4218C18D0Ev();
extern void _ZN8S4218C184v214Ev();
extern void _ZN8S4218C184v215Ev();
extern void _ZN8S4218C184v216Ev();
static  VTBL_ENTRY vtc_S4218C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4218C18[0]),
  (VTBL_ENTRY)&_ZN8S4218C18D1Ev,
  (VTBL_ENTRY)&_ZN8S4218C18D0Ev,
  (VTBL_ENTRY)&_ZN8S4218C184v214Ev,
  (VTBL_ENTRY)&_ZN8S4218C184v215Ev,
  (VTBL_ENTRY)&_ZN8S4218C184v216Ev,
};
extern VTBL_ENTRY _ZTI8S4218C18[];
extern  VTBL_ENTRY _ZTV8S4218C18[];
Class_Descriptor cd_S4218C18 = {  "S4218C18", // class name
  0,0,//no base classes
  &(vtc_S4218C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S4218C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4218C18),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C15  : S4218C16 , S4218C18 {
  void *s4218c15f0;
  virtual  ~S4218C15(); // _ZN8S4218C15D1Ev
  virtual void  v217(); // _ZN8S4218C154v217Ev
  virtual void  v218(); // _ZN8S4218C154v218Ev
  virtual void  v219(); // _ZN8S4218C154v219Ev
  virtual void  v220(); // _ZN8S4218C154v220Ev
  virtual void  v221(); // _ZN8S4218C154v221Ev
  virtual void  v222(); // _ZN8S4218C154v222Ev
  virtual void  v223(); // _ZN8S4218C154v223Ev
  virtual void  v224(); // _ZN8S4218C154v224Ev
  virtual void  v225(); // _ZN8S4218C154v225Ev
  virtual void  v226(); // _ZN8S4218C154v226Ev
  S4218C15(); // tgen
};
//SIG(-1 S4218C15) C1{ BC2{ BC3{ vd v11 Fi Fc[3]} vd v12 v13 v14 v15 v16 v17 v18 Fp[2] Fi} BC4{ vd v19 v20 v21} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp}


 S4218C15 ::~S4218C15(){ note_dtor("S4218C15", this);}
void  S4218C15 ::v217(){vfunc_called(this, "_ZN8S4218C154v217Ev");}
void  S4218C15 ::v218(){vfunc_called(this, "_ZN8S4218C154v218Ev");}
void  S4218C15 ::v219(){vfunc_called(this, "_ZN8S4218C154v219Ev");}
void  S4218C15 ::v220(){vfunc_called(this, "_ZN8S4218C154v220Ev");}
void  S4218C15 ::v221(){vfunc_called(this, "_ZN8S4218C154v221Ev");}
void  S4218C15 ::v222(){vfunc_called(this, "_ZN8S4218C154v222Ev");}
void  S4218C15 ::v223(){vfunc_called(this, "_ZN8S4218C154v223Ev");}
void  S4218C15 ::v224(){vfunc_called(this, "_ZN8S4218C154v224Ev");}
void  S4218C15 ::v225(){vfunc_called(this, "_ZN8S4218C154v225Ev");}
void  S4218C15 ::v226(){vfunc_called(this, "_ZN8S4218C154v226Ev");}
S4218C15 ::S4218C15(){ note_ctor("S4218C15", this);} // tgen

static void Test_S4218C15()
{
  extern Class_Descriptor cd_S4218C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,9)];
    init_test(&cd_S4218C15, buf);
    S4218C15 *dp, &lv = *(dp=new (buf) S4218C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,32), "sizeof(S4218C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C15)");
    check_base_class_offset(lv, (S4218C17*)(S4218C16*), 0, "S4218C15");
    check_base_class_offset(lv, (S4218C16*), 0, "S4218C15");
    check_base_class_offset(lv, (S4218C18*), ABISELECT(40,24), "S4218C15");
    check_field_offset(lv, s4218c15f0, ABISELECT(48,28), "S4218C15.s4218c15f0");
    test_class_info(&lv, &cd_S4218C15);
    dp->~S4218C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C15(Test_S4218C15, "S4218C15", ABISELECT(56,32));

#else // __cplusplus

extern void _ZN8S4218C15C1Ev();
extern void _ZN8S4218C15D1Ev();
Name_Map name_map_S4218C15[] = {
  NSPAIR(_ZN8S4218C15C1Ev),
  NSPAIR(_ZN8S4218C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4218C17;
extern VTBL_ENTRY _ZTI8S4218C17[];
extern  VTBL_ENTRY _ZTV8S4218C17[];
extern Class_Descriptor cd_S4218C16;
extern VTBL_ENTRY _ZTI8S4218C16[];
extern  VTBL_ENTRY _ZTV8S4218C16[];
extern Class_Descriptor cd_S4218C18;
extern VTBL_ENTRY _ZTI8S4218C18[];
extern  VTBL_ENTRY _ZTV8S4218C18[];
static Base_Class bases_S4218C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4218C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4218C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4218C18,    ABISELECT(40,24), //bcp->offset
    22, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4218C15[];
extern void _ZN8S4218C15D1Ev();
extern void _ZN8S4218C15D0Ev();
extern void _ZN8S4218C174v206Ev();
extern void _ZN8S4218C164v207Ev();
extern void _ZN8S4218C164v208Ev();
extern void _ZN8S4218C164v209Ev();
extern void _ZN8S4218C164v210Ev();
extern void _ZN8S4218C164v211Ev();
extern void _ZN8S4218C164v212Ev();
extern void _ZN8S4218C164v213Ev();
extern void _ZN8S4218C154v217Ev();
extern void _ZN8S4218C154v218Ev();
extern void _ZN8S4218C154v219Ev();
extern void _ZN8S4218C154v220Ev();
extern void _ZN8S4218C154v221Ev();
extern void _ZN8S4218C154v222Ev();
extern void _ZN8S4218C154v223Ev();
extern void _ZN8S4218C154v224Ev();
extern void _ZN8S4218C154v225Ev();
extern void _ZN8S4218C154v226Ev();
extern void ABISELECT(_ZThn40_N8S4218C15D1Ev,_ZThn24_N8S4218C15D1Ev)();
extern void ABISELECT(_ZThn40_N8S4218C15D0Ev,_ZThn24_N8S4218C15D0Ev)();
extern void _ZN8S4218C184v214Ev();
extern void _ZN8S4218C184v215Ev();
extern void _ZN8S4218C184v216Ev();
static  VTBL_ENTRY vtc_S4218C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4218C15[0]),
  (VTBL_ENTRY)&_ZN8S4218C15D1Ev,
  (VTBL_ENTRY)&_ZN8S4218C15D0Ev,
  (VTBL_ENTRY)&_ZN8S4218C174v206Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v207Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v208Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v209Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v210Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v211Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v212Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v213Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v217Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v218Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v219Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v220Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v221Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v222Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v223Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v224Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v225Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v226Ev,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S4218C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S4218C15D1Ev,_ZThn24_N8S4218C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn40_N8S4218C15D0Ev,_ZThn24_N8S4218C15D0Ev),
  (VTBL_ENTRY)&_ZN8S4218C184v214Ev,
  (VTBL_ENTRY)&_ZN8S4218C184v215Ev,
  (VTBL_ENTRY)&_ZN8S4218C184v216Ev,
};
extern VTBL_ENTRY _ZTI8S4218C15[];
extern  VTBL_ENTRY _ZTV8S4218C15[];
Class_Descriptor cd_S4218C15 = {  "S4218C15", // class name
  bases_S4218C15, 3,
  &(vtc_S4218C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,32), // object size
  NSPAIRA(_ZTI8S4218C15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S4218C15),29, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C27  {
  virtual  ~S4218C27(); // _ZN8S4218C27D1Ev
  virtual void  v232(); // _ZN8S4218C274v232Ev
  virtual void  v233(); // _ZN8S4218C274v233Ev
  S4218C27(); // tgen
};
//SIG(-1 S4218C27) C1{ vd v1 v2}


 S4218C27 ::~S4218C27(){ note_dtor("S4218C27", this);}
void  S4218C27 ::v232(){vfunc_called(this, "_ZN8S4218C274v232Ev");}
void  S4218C27 ::v233(){vfunc_called(this, "_ZN8S4218C274v233Ev");}
S4218C27 ::S4218C27(){ note_ctor("S4218C27", this);} // tgen

static void Test_S4218C27()
{
  extern Class_Descriptor cd_S4218C27;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S4218C27, buf);
    S4218C27 *dp, &lv = *(dp=new (buf) S4218C27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S4218C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C27)");
    test_class_info(&lv, &cd_S4218C27);
    dp->~S4218C27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C27(Test_S4218C27, "S4218C27", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S4218C27C1Ev();
extern void _ZN8S4218C27D1Ev();
Name_Map name_map_S4218C27[] = {
  NSPAIR(_ZN8S4218C27C1Ev),
  NSPAIR(_ZN8S4218C27D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S4218C27[];
extern void _ZN8S4218C27D1Ev();
extern void _ZN8S4218C27D0Ev();
extern void _ZN8S4218C274v232Ev();
extern void _ZN8S4218C274v233Ev();
static  VTBL_ENTRY vtc_S4218C27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4218C27[0]),
  (VTBL_ENTRY)&_ZN8S4218C27D1Ev,
  (VTBL_ENTRY)&_ZN8S4218C27D0Ev,
  (VTBL_ENTRY)&_ZN8S4218C274v232Ev,
  (VTBL_ENTRY)&_ZN8S4218C274v233Ev,
};
extern VTBL_ENTRY _ZTI8S4218C27[];
extern  VTBL_ENTRY _ZTV8S4218C27[];
Class_Descriptor cd_S4218C27 = {  "S4218C27", // class name
  0,0,//no base classes
  &(vtc_S4218C27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S4218C27),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S4218C27),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C68  : S4216C64 , S4218C27 {
  virtual  ~S4218C68(); // _ZN8S4218C68D1Ev
  virtual void  v260(); // _ZN8S4218C684v260Ev
  virtual void  v261(); // _ZN8S4218C684v261Ev
  S4218C68(); // tgen
};
//SIG(-1 S4218C68) C1{ BC2{ m Fp Fi[2] FC3{ m}} BC4{ vd v3 v4} vd v1 v2}


 S4218C68 ::~S4218C68(){ note_dtor("S4218C68", this);}
void  S4218C68 ::v260(){vfunc_called(this, "_ZN8S4218C684v260Ev");}
void  S4218C68 ::v261(){vfunc_called(this, "_ZN8S4218C684v261Ev");}
S4218C68 ::S4218C68(){ note_ctor("S4218C68", this);} // tgen

static void Test_S4218C68()
{
  extern Class_Descriptor cd_S4218C68;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S4218C68, buf);
    S4218C68 *dp, &lv = *(dp=new (buf) S4218C68());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S4218C68)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C68)");
    check_base_class_offset(lv, (S4216C64*), ABISELECT(8,4), "S4218C68");
    check_base_class_offset(lv, (S4218C27*), 0, "S4218C68");
    test_class_info(&lv, &cd_S4218C68);
    dp->~S4218C68();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C68(Test_S4218C68, "S4218C68", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN8S4218C68C1Ev();
extern void _ZN8S4218C68D1Ev();
Name_Map name_map_S4218C68[] = {
  NSPAIR(_ZN8S4218C68C1Ev),
  NSPAIR(_ZN8S4218C68D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C64;
extern VTBL_ENTRY _ZTI8S4216C64[];
extern Class_Descriptor cd_S4218C27;
extern VTBL_ENTRY _ZTI8S4218C27[];
extern  VTBL_ENTRY _ZTV8S4218C27[];
static Base_Class bases_S4218C68[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C64,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4218C27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4218C68[];
extern void _ZN8S4218C68D1Ev();
extern void _ZN8S4218C68D0Ev();
extern void _ZN8S4218C274v232Ev();
extern void _ZN8S4218C274v233Ev();
extern void _ZN8S4218C684v260Ev();
extern void _ZN8S4218C684v261Ev();
static  VTBL_ENTRY vtc_S4218C68[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4218C68[0]),
  (VTBL_ENTRY)&_ZN8S4218C68D1Ev,
  (VTBL_ENTRY)&_ZN8S4218C68D0Ev,
  (VTBL_ENTRY)&_ZN8S4218C274v232Ev,
  (VTBL_ENTRY)&_ZN8S4218C274v233Ev,
  (VTBL_ENTRY)&_ZN8S4218C684v260Ev,
  (VTBL_ENTRY)&_ZN8S4218C684v261Ev,
};
extern VTBL_ENTRY _ZTI8S4218C68[];
extern  VTBL_ENTRY _ZTV8S4218C68[];
Class_Descriptor cd_S4218C68 = {  "S4218C68", // class name
  bases_S4218C68, 2,
  &(vtc_S4218C68[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S4218C68),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S4218C68),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C24  : S4216C26 , S4216C51 , S4218C2 {
  void *s4218c24f0[2];
  ::S4218C6_nt s4218c24f1;
  void *s4218c24f2[5];
  ::S4216C33 s4218c24f3;
  ::S4218C6_nt s4218c24f4;
  ::S4216C12_nt s4218c24f5;
  ::S4217C37 s4218c24f6;
  ::S4216C63 s4218c24f7;
  ::S4216C57 s4218c24f8;
  ::S4216C66 s4218c24f9;
  ::S4216C37 s4218c24f10;
  ::S4218C68 s4218c24f11;
  int s4218c24f12[2];
  void *s4218c24f13;
  ::S4216C58 s4218c24f14;
  char s4218c24f15;
  virtual  ~S4218C24(); // _ZN8S4218C24D1Ev
  S4218C24(); // tgen
};
//SIG(-1 S4218C24) C1{ BC2{ vd m Fi Fc[2] FC3{ BC4{ vd v10 v11} vd v7 v8 v9 Fc[66]} FC5{ m Fp Fi FC6{ m}} FC7{ BC4 vd v12 FC5} FC7 FC7 Fc FC7 Fc Fi Fs FC7 FC7 FC8{ vd v13 Fi} FC9{ vd v14 Fi[2] Fs[2] Fi[3] FC5} FC10{ vd v15 Fi} FC11{ vd v16 Fs[2] Fc[6] Fs[2] Fc[6] FC5} FC11 FC12{ BC4 vd v17 FC5 FC5 FC5} Fc Fi[3] FC13{ BC4 vd v18 v19 FC11 FC5 FC5 FC5 FC14{ vd m Fi FC12 Fi} Fc FC15{ BC16{ m Fp Fi[2] FC17{ m}} BC4 vd v20 v21} FC5} Fi[2] FC18{ BC12 vd v22 v23 FC5 Fi Fc} Fi[2] FC19{ BC4 vd v24 FC11 FC5 Fi[2] FC10 Fi[2]} FC19 FC9 Fi[2] Fc[2] Fi[2] FC20{ m Fi} FC21{ BC4 vd v25 FC5} FC21 Fi[2] FC7 Fi FC22{ BC4 vd v26 FC7 FC7} Fc FC7 FC15 FC12 Fc FC18 Fc FC21 FC21 Fi Fc Fi FC20[55]} BC23{ vd m FC24{ BC4 vd v27 v28 Fi[4]}} BC25{ BC26{ vd v1 v2 v3} vd v4 v5 v6 FC27{ m Fp Fi[2] FC28{ m}} FC29{ m FL[4]} Fc} vd Fp[2] FC29 Fp[5] FC11 FC29 FC30{ BC31{ m Fp Fi FC32{ m} FC6}} FC33{ BC34{ m Fp Fi[2] FC28} BC35{ vd v31 v32} vd v29 v30} FC36{ BC34 BC4 vd v33 v34} FC37{ BC38{ m Fp Fi[2] FC17} BC4 vd v35 v36} FC39{ m FL Fi FL Fc FC40{ m Fp Fi[2] FC32}} FC15 FC41{ BC34 BC42{ vd v39 v40} vd v37 v38} Fi[2] Fp FC38 Fc}


 S4218C24 ::~S4218C24(){ note_dtor("S4218C24", this);}
S4218C24 ::S4218C24(){ note_ctor("S4218C24", this);} // tgen

static void Test_S4218C24()
{
  extern Class_Descriptor cd_S4218C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(293,438)];
    init_test(&cd_S4218C24, buf);
    S4218C24 *dp, &lv = *(dp=new (buf) S4218C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2336,1748), "sizeof(S4218C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C24)");
    check_base_class_offset(lv, (S4216C26*), 0, "S4218C24");
    check_base_class_offset(lv, (S4216C51*), ABISELECT(1784,1356), "S4218C24");
    check_base_class_offset(lv, (S4218C3*)(S4218C2*), ABISELECT(1816,1380), "S4218C24");
    check_base_class_offset(lv, (S4218C2*), ABISELECT(1816,1380), "S4218C24");
    check_field_offset(lv, s4218c24f0, ABISELECT(1888,1436), "S4218C24.s4218c24f0");
    check_field_offset(lv, s4218c24f1, ABISELECT(1904,1444), "S4218C24.s4218c24f1");
    check_field_offset(lv, s4218c24f2, ABISELECT(1936,1476), "S4218C24.s4218c24f2");
    check_field_offset(lv, s4218c24f3, ABISELECT(1976,1496), "S4218C24.s4218c24f3");
    check_field_offset(lv, s4218c24f4, ABISELECT(2024,1532), "S4218C24.s4218c24f4");
    check_field_offset(lv, s4218c24f5, ABISELECT(2056,1564), "S4218C24.s4218c24f5");
    check_field_offset(lv, s4218c24f6, ABISELECT(2072,1576), "S4218C24.s4218c24f6");
    check_field_offset(lv, s4218c24f7, ABISELECT(2104,1596), "S4218C24.s4218c24f7");
    check_field_offset(lv, s4218c24f8, ABISELECT(2136,1616), "S4218C24.s4218c24f8");
    check_field_offset(lv, s4218c24f9, ABISELECT(2168,1636), "S4218C24.s4218c24f9");
    check_field_offset(lv, s4218c24f10, ABISELECT(2224,1676), "S4218C24.s4218c24f10");
    check_field_offset(lv, s4218c24f11, ABISELECT(2256,1696), "S4218C24.s4218c24f11");
    check_field_offset(lv, s4218c24f12, ABISELECT(2288,1716), "S4218C24.s4218c24f12");
    check_field_offset(lv, s4218c24f13, ABISELECT(2296,1724), "S4218C24.s4218c24f13");
    check_field_offset(lv, s4218c24f14, ABISELECT(2304,1728), "S4218C24.s4218c24f14");
    check_field_offset(lv, s4218c24f15, ABISELECT(2328,1744), "S4218C24.s4218c24f15");
    test_class_info(&lv, &cd_S4218C24);
    dp->~S4218C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C24(Test_S4218C24, "S4218C24", ABISELECT(2336,1748));

#else // __cplusplus

extern void _ZN8S4218C24C1Ev();
extern void _ZN8S4218C24D1Ev();
Name_Map name_map_S4218C24[] = {
  NSPAIR(_ZN8S4218C24C1Ev),
  NSPAIR(_ZN8S4218C24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C26;
extern VTBL_ENTRY _ZTI8S4216C26[];
extern  VTBL_ENTRY _ZTV8S4216C26[];
extern Class_Descriptor cd_S4216C51;
extern VTBL_ENTRY _ZTI8S4216C51[];
extern  VTBL_ENTRY _ZTV8S4216C51[];
extern Class_Descriptor cd_S4218C3;
extern VTBL_ENTRY _ZTI7S4218C3[];
extern  VTBL_ENTRY _ZTV7S4218C3[];
extern Class_Descriptor cd_S4218C2;
extern VTBL_ENTRY _ZTI7S4218C2[];
extern  VTBL_ENTRY _ZTV7S4218C2[];
static Base_Class bases_S4218C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C51,    ABISELECT(1784,1356), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4218C3,    ABISELECT(1816,1380), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S4218C2,    ABISELECT(1816,1380), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S4218C24[];
extern void _ZN8S4218C24D1Ev();
extern void _ZN8S4218C24D0Ev();
extern void ABISELECT(_ZThn1784_N8S4218C24D1Ev,_ZThn1356_N8S4218C24D1Ev)();
extern void ABISELECT(_ZThn1784_N8S4218C24D0Ev,_ZThn1356_N8S4218C24D0Ev)();
extern void ABISELECT(_ZThn1816_N8S4218C24D1Ev,_ZThn1380_N8S4218C24D1Ev)();
extern void ABISELECT(_ZThn1816_N8S4218C24D0Ev,_ZThn1380_N8S4218C24D0Ev)();
extern void _ZN7S4218C34v104Ev();
extern void _ZN7S4218C34v105Ev();
extern void _ZN7S4218C34v106Ev();
extern void _ZN7S4218C24v107Ev();
extern void _ZN7S4218C24v108Ev();
extern void _ZN7S4218C24v109Ev();
static  VTBL_ENTRY vtc_S4218C24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S4218C24[0]),
  (VTBL_ENTRY)&_ZN8S4218C24D1Ev,
  (VTBL_ENTRY)&_ZN8S4218C24D0Ev,
  ABISELECT(-1784,-1356),
  (VTBL_ENTRY)&(_ZTI8S4218C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1784_N8S4218C24D1Ev,_ZThn1356_N8S4218C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1784_N8S4218C24D0Ev,_ZThn1356_N8S4218C24D0Ev),
  ABISELECT(-1816,-1380),
  (VTBL_ENTRY)&(_ZTI8S4218C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn1816_N8S4218C24D1Ev,_ZThn1380_N8S4218C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1816_N8S4218C24D0Ev,_ZThn1380_N8S4218C24D0Ev),
  (VTBL_ENTRY)&_ZN7S4218C34v104Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v105Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v106Ev,
  (VTBL_ENTRY)&_ZN7S4218C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4218C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4218C24v109Ev,
};
extern VTBL_ENTRY _ZTI8S4218C24[];
extern  VTBL_ENTRY _ZTV8S4218C24[];
Class_Descriptor cd_S4218C24 = {  "S4218C24", // class name
  bases_S4218C24, 4,
  &(vtc_S4218C24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2336,1748), // object size
  NSPAIRA(_ZTI8S4218C24),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S4218C24),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4218C1  : S4218C2 , S4218C7 , S4218C8 , S4218C9 , S4216C11 , S4218C15 {
  ::S4218C6_nt s4218c1f0;
  ::S4218C6_nt s4218c1f1;
  void *s4218c1f2[2];
  ::S4216C21 s4218c1f3;
  ::S4216C32 s4218c1f4;
  int s4218c1f5[3];
  char s4218c1f6;
  int s4218c1f7[2];
  ::S4218C24 s4218c1f8;
  ::S4216C74 s4218c1f9;
  int s4218c1f10[2];
  char s4218c1f11;
  int s4218c1f12;
  void *s4218c1f13;
  int s4218c1f14;
  char s4218c1f15;
  virtual  ~S4218C1(); // _ZN7S4218C1D1Ev
  virtual void  v1(); // _ZN7S4218C12v1Ev
  virtual void  v2(); // _ZN7S4218C12v2Ev
  virtual void  v3(); // _ZN7S4218C12v3Ev
  virtual void  v4(); // _ZN7S4218C12v4Ev
  virtual void  v5(); // _ZN7S4218C12v5Ev
  virtual void  v6(); // _ZN7S4218C12v6Ev
  virtual void  v7(); // _ZN7S4218C12v7Ev
  virtual void  v8(); // _ZN7S4218C12v8Ev
  virtual void  v9(); // _ZN7S4218C12v9Ev
  virtual void  v10(); // _ZN7S4218C13v10Ev
  virtual void  v11(); // _ZN7S4218C13v11Ev
  virtual void  v12(); // _ZN7S4218C13v12Ev
  virtual void  v13(); // _ZN7S4218C13v13Ev
  virtual void  v14(); // _ZN7S4218C13v14Ev
  virtual void  v15(); // _ZN7S4218C13v15Ev
  virtual void  v16(); // _ZN7S4218C13v16Ev
  virtual void  v17(); // _ZN7S4218C13v17Ev
  virtual void  v18(); // _ZN7S4218C13v18Ev
  virtual void  v19(); // _ZN7S4218C13v19Ev
  virtual void  v20(); // _ZN7S4218C13v20Ev
  virtual void  v21(); // _ZN7S4218C13v21Ev
  virtual void  v22(); // _ZN7S4218C13v22Ev
  virtual void  v23(); // _ZN7S4218C13v23Ev
  virtual void  v24(); // _ZN7S4218C13v24Ev
  virtual void  v25(); // _ZN7S4218C13v25Ev
  virtual void  v26(); // _ZN7S4218C13v26Ev
  virtual void  v27(); // _ZN7S4218C13v27Ev
  virtual void  v28(); // _ZN7S4218C13v28Ev
  virtual void  v29(); // _ZN7S4218C13v29Ev
  virtual void  v30(); // _ZN7S4218C13v30Ev
  virtual void  v31(); // _ZN7S4218C13v31Ev
  virtual void  v32(); // _ZN7S4218C13v32Ev
  virtual void  v33(); // _ZN7S4218C13v33Ev
  virtual void  v34(); // _ZN7S4218C13v34Ev
  virtual void  v35(); // _ZN7S4218C13v35Ev
  virtual void  v36(); // _ZN7S4218C13v36Ev
  virtual void  v37(); // _ZN7S4218C13v37Ev
  virtual void  v38(); // _ZN7S4218C13v38Ev
  virtual void  v39(); // _ZN7S4218C13v39Ev
  virtual void  v40(); // _ZN7S4218C13v40Ev
  virtual void  v41(); // _ZN7S4218C13v41Ev
  virtual void  v42(); // _ZN7S4218C13v42Ev
  virtual void  v43(); // _ZN7S4218C13v43Ev
  virtual void  v44(); // _ZN7S4218C13v44Ev
  virtual void  v45(); // _ZN7S4218C13v45Ev
  virtual void  v46(); // _ZN7S4218C13v46Ev
  virtual void  v47(); // _ZN7S4218C13v47Ev
  virtual void  v48(); // _ZN7S4218C13v48Ev
  virtual void  v49(); // _ZN7S4218C13v49Ev
  virtual void  v50(); // _ZN7S4218C13v50Ev
  virtual void  v51(); // _ZN7S4218C13v51Ev
  virtual void  v52(); // _ZN7S4218C13v52Ev
  virtual void  v53(); // _ZN7S4218C13v53Ev
  virtual void  v54(); // _ZN7S4218C13v54Ev
  virtual void  v55(); // _ZN7S4218C13v55Ev
  virtual void  v56(); // _ZN7S4218C13v56Ev
  virtual void  v57(); // _ZN7S4218C13v57Ev
  virtual void  v58(); // _ZN7S4218C13v58Ev
  virtual void  v59(); // _ZN7S4218C13v59Ev
  virtual void  v60(); // _ZN7S4218C13v60Ev
  virtual void  v61(); // _ZN7S4218C13v61Ev
  virtual void  v62(); // _ZN7S4218C13v62Ev
  virtual void  v63(); // _ZN7S4218C13v63Ev
  virtual void  v64(); // _ZN7S4218C13v64Ev
  virtual void  v65(); // _ZN7S4218C13v65Ev
  virtual void  v66(); // _ZN7S4218C13v66Ev
  virtual void  v67(); // _ZN7S4218C13v67Ev
  virtual void  v68(); // _ZN7S4218C13v68Ev
  virtual void  v69(); // _ZN7S4218C13v69Ev
  virtual void  v70(); // _ZN7S4218C13v70Ev
  virtual void  v71(); // _ZN7S4218C13v71Ev
  virtual void  v72(); // _ZN7S4218C13v72Ev
  virtual void  v73(); // _ZN7S4218C13v73Ev
  virtual void  v74(); // _ZN7S4218C13v74Ev
  virtual void  v75(); // _ZN7S4218C13v75Ev
  virtual void  v76(); // _ZN7S4218C13v76Ev
  virtual void  v77(); // _ZN7S4218C13v77Ev
  virtual void  v78(); // _ZN7S4218C13v78Ev
  virtual void  v79(); // _ZN7S4218C13v79Ev
  virtual void  v80(); // _ZN7S4218C13v80Ev
  virtual void  v81(); // _ZN7S4218C13v81Ev
  virtual void  v82(); // _ZN7S4218C13v82Ev
  virtual void  v83(); // _ZN7S4218C13v83Ev
  virtual void  v84(); // _ZN7S4218C13v84Ev
  virtual void  v85(); // _ZN7S4218C13v85Ev
  virtual void  v86(); // _ZN7S4218C13v86Ev
  virtual void  v87(); // _ZN7S4218C13v87Ev
  virtual void  v88(); // _ZN7S4218C13v88Ev
  virtual void  v89(); // _ZN7S4218C13v89Ev
  virtual void  v90(); // _ZN7S4218C13v90Ev
  virtual void  v91(); // _ZN7S4218C13v91Ev
  virtual void  v92(); // _ZN7S4218C13v92Ev
  virtual void  v93(); // _ZN7S4218C13v93Ev
  virtual void  v94(); // _ZN7S4218C13v94Ev
  virtual void  v95(); // _ZN7S4218C13v95Ev
  virtual void  v96(); // _ZN7S4218C13v96Ev
  virtual void  v97(); // _ZN7S4218C13v97Ev
  virtual void  v98(); // _ZN7S4218C13v98Ev
  virtual void  v99(); // _ZN7S4218C13v99Ev
  virtual void  v100(); // _ZN7S4218C14v100Ev
  virtual void  v101(); // _ZN7S4218C14v101Ev
  virtual void  v102(); // _ZN7S4218C14v102Ev
  virtual void  v103(); // _ZN7S4218C14v103Ev
  S4218C1(); // tgen
};
//SIG(1 S4218C1) C1{ BC2{ BC3{ vd v104 v105 v106} vd v107 v108 v109 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FL[4]} Fc} BC7{ vd v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124} BC8{ vd v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204} BC9{ vd v205} BC10{ vd m FC11{ BC12{ m Fp Fi FC13{ m} FC14{ m}}}} BC15{ BC16{ BC17{ vd v206 Fi Fc[3]} vd v207 v208 v209 v210 v211 v212 v213 Fp[2] Fi} BC18{ vd v214 v215 v216} vd v217 v218 v219 v220 v221 v222 v223 v224 v225 v226 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 FC6 FC6 Fp[2] FC19{ vd v227 Fi[2] Fs[2] Fi[3] FC20{ m Fp Fi FC14}} FC21{ vd v228 Fi} Fi[3] Fc Fi[2] FC22{ BC23{ vd m Fi Fc[2] FC24{ BC25{ vd v232 v233} vd v229 v230 v231 Fc[66]} FC20 FC26{ BC25 vd v234 FC20} FC26 FC26 Fc FC26 Fc Fi Fs FC26 FC26 FC27{ vd v235 Fi} FC19 FC21 FC28{ vd v236 Fs[2] Fc[6] Fs[2] Fc[6] FC20} FC28 FC29{ BC25 vd v237 FC20 FC20 FC20} Fc Fi[3] FC30{ BC25 vd v238 v239 FC28 FC20 FC20 FC20 FC31{ vd m Fi FC29 Fi} Fc FC32{ BC33{ m Fp Fi[2] FC34{ m}} BC25 vd v240 v241} FC20} Fi[2] FC35{ BC29 vd v242 v243 FC20 Fi Fc} Fi[2] FC36{ BC25 vd v244 FC28 FC20 Fi[2] FC21 Fi[2]} FC36 FC19 Fi[2] Fc[2] Fi[2] FC37{ m Fi} FC38{ BC25 vd v245 FC20} FC38 Fi[2] FC26 Fi FC39{ BC25 vd v246 FC26 FC26} Fc FC26 FC32 FC29 Fc FC35 Fc FC38 FC38 Fi Fc Fi FC37[55]} BC40{ vd m FC41{ BC25 vd v247 v248 Fi[4]}} BC2 vd Fp[2] FC6 Fp[5] FC28 FC6 FC11 FC42{ BC43{ m Fp Fi[2] FC5} BC44{ vd v251 v252} vd v249 v250} FC45{ BC43 BC25 vd v253 v254} FC46{ BC47{ m Fp Fi[2] FC34} BC25 vd v255 v256} FC48{ m FL Fi FL Fc FC49{ m Fp Fi[2] FC13}} FC32 FC50{ BC43 BC51{ vd v259 v260} vd v257 v258} Fi[2] Fp FC47 Fc} FC52{ BC53{ vd v262 FC54{ m FC55{ m Fp Fi FC56{ m} FC56}} Fp[3] Fc} v261 Fp} Fi[2] Fc Fi Fp Fi Fc}


 S4218C1 ::~S4218C1(){ note_dtor("S4218C1", this);}
void  S4218C1 ::v1(){vfunc_called(this, "_ZN7S4218C12v1Ev");}
void  S4218C1 ::v2(){vfunc_called(this, "_ZN7S4218C12v2Ev");}
void  S4218C1 ::v3(){vfunc_called(this, "_ZN7S4218C12v3Ev");}
void  S4218C1 ::v4(){vfunc_called(this, "_ZN7S4218C12v4Ev");}
void  S4218C1 ::v5(){vfunc_called(this, "_ZN7S4218C12v5Ev");}
void  S4218C1 ::v6(){vfunc_called(this, "_ZN7S4218C12v6Ev");}
void  S4218C1 ::v7(){vfunc_called(this, "_ZN7S4218C12v7Ev");}
void  S4218C1 ::v8(){vfunc_called(this, "_ZN7S4218C12v8Ev");}
void  S4218C1 ::v9(){vfunc_called(this, "_ZN7S4218C12v9Ev");}
void  S4218C1 ::v10(){vfunc_called(this, "_ZN7S4218C13v10Ev");}
void  S4218C1 ::v11(){vfunc_called(this, "_ZN7S4218C13v11Ev");}
void  S4218C1 ::v12(){vfunc_called(this, "_ZN7S4218C13v12Ev");}
void  S4218C1 ::v13(){vfunc_called(this, "_ZN7S4218C13v13Ev");}
void  S4218C1 ::v14(){vfunc_called(this, "_ZN7S4218C13v14Ev");}
void  S4218C1 ::v15(){vfunc_called(this, "_ZN7S4218C13v15Ev");}
void  S4218C1 ::v16(){vfunc_called(this, "_ZN7S4218C13v16Ev");}
void  S4218C1 ::v17(){vfunc_called(this, "_ZN7S4218C13v17Ev");}
void  S4218C1 ::v18(){vfunc_called(this, "_ZN7S4218C13v18Ev");}
void  S4218C1 ::v19(){vfunc_called(this, "_ZN7S4218C13v19Ev");}
void  S4218C1 ::v20(){vfunc_called(this, "_ZN7S4218C13v20Ev");}
void  S4218C1 ::v21(){vfunc_called(this, "_ZN7S4218C13v21Ev");}
void  S4218C1 ::v22(){vfunc_called(this, "_ZN7S4218C13v22Ev");}
void  S4218C1 ::v23(){vfunc_called(this, "_ZN7S4218C13v23Ev");}
void  S4218C1 ::v24(){vfunc_called(this, "_ZN7S4218C13v24Ev");}
void  S4218C1 ::v25(){vfunc_called(this, "_ZN7S4218C13v25Ev");}
void  S4218C1 ::v26(){vfunc_called(this, "_ZN7S4218C13v26Ev");}
void  S4218C1 ::v27(){vfunc_called(this, "_ZN7S4218C13v27Ev");}
void  S4218C1 ::v28(){vfunc_called(this, "_ZN7S4218C13v28Ev");}
void  S4218C1 ::v29(){vfunc_called(this, "_ZN7S4218C13v29Ev");}
void  S4218C1 ::v30(){vfunc_called(this, "_ZN7S4218C13v30Ev");}
void  S4218C1 ::v31(){vfunc_called(this, "_ZN7S4218C13v31Ev");}
void  S4218C1 ::v32(){vfunc_called(this, "_ZN7S4218C13v32Ev");}
void  S4218C1 ::v33(){vfunc_called(this, "_ZN7S4218C13v33Ev");}
void  S4218C1 ::v34(){vfunc_called(this, "_ZN7S4218C13v34Ev");}
void  S4218C1 ::v35(){vfunc_called(this, "_ZN7S4218C13v35Ev");}
void  S4218C1 ::v36(){vfunc_called(this, "_ZN7S4218C13v36Ev");}
void  S4218C1 ::v37(){vfunc_called(this, "_ZN7S4218C13v37Ev");}
void  S4218C1 ::v38(){vfunc_called(this, "_ZN7S4218C13v38Ev");}
void  S4218C1 ::v39(){vfunc_called(this, "_ZN7S4218C13v39Ev");}
void  S4218C1 ::v40(){vfunc_called(this, "_ZN7S4218C13v40Ev");}
void  S4218C1 ::v41(){vfunc_called(this, "_ZN7S4218C13v41Ev");}
void  S4218C1 ::v42(){vfunc_called(this, "_ZN7S4218C13v42Ev");}
void  S4218C1 ::v43(){vfunc_called(this, "_ZN7S4218C13v43Ev");}
void  S4218C1 ::v44(){vfunc_called(this, "_ZN7S4218C13v44Ev");}
void  S4218C1 ::v45(){vfunc_called(this, "_ZN7S4218C13v45Ev");}
void  S4218C1 ::v46(){vfunc_called(this, "_ZN7S4218C13v46Ev");}
void  S4218C1 ::v47(){vfunc_called(this, "_ZN7S4218C13v47Ev");}
void  S4218C1 ::v48(){vfunc_called(this, "_ZN7S4218C13v48Ev");}
void  S4218C1 ::v49(){vfunc_called(this, "_ZN7S4218C13v49Ev");}
void  S4218C1 ::v50(){vfunc_called(this, "_ZN7S4218C13v50Ev");}
void  S4218C1 ::v51(){vfunc_called(this, "_ZN7S4218C13v51Ev");}
void  S4218C1 ::v52(){vfunc_called(this, "_ZN7S4218C13v52Ev");}
void  S4218C1 ::v53(){vfunc_called(this, "_ZN7S4218C13v53Ev");}
void  S4218C1 ::v54(){vfunc_called(this, "_ZN7S4218C13v54Ev");}
void  S4218C1 ::v55(){vfunc_called(this, "_ZN7S4218C13v55Ev");}
void  S4218C1 ::v56(){vfunc_called(this, "_ZN7S4218C13v56Ev");}
void  S4218C1 ::v57(){vfunc_called(this, "_ZN7S4218C13v57Ev");}
void  S4218C1 ::v58(){vfunc_called(this, "_ZN7S4218C13v58Ev");}
void  S4218C1 ::v59(){vfunc_called(this, "_ZN7S4218C13v59Ev");}
void  S4218C1 ::v60(){vfunc_called(this, "_ZN7S4218C13v60Ev");}
void  S4218C1 ::v61(){vfunc_called(this, "_ZN7S4218C13v61Ev");}
void  S4218C1 ::v62(){vfunc_called(this, "_ZN7S4218C13v62Ev");}
void  S4218C1 ::v63(){vfunc_called(this, "_ZN7S4218C13v63Ev");}
void  S4218C1 ::v64(){vfunc_called(this, "_ZN7S4218C13v64Ev");}
void  S4218C1 ::v65(){vfunc_called(this, "_ZN7S4218C13v65Ev");}
void  S4218C1 ::v66(){vfunc_called(this, "_ZN7S4218C13v66Ev");}
void  S4218C1 ::v67(){vfunc_called(this, "_ZN7S4218C13v67Ev");}
void  S4218C1 ::v68(){vfunc_called(this, "_ZN7S4218C13v68Ev");}
void  S4218C1 ::v69(){vfunc_called(this, "_ZN7S4218C13v69Ev");}
void  S4218C1 ::v70(){vfunc_called(this, "_ZN7S4218C13v70Ev");}
void  S4218C1 ::v71(){vfunc_called(this, "_ZN7S4218C13v71Ev");}
void  S4218C1 ::v72(){vfunc_called(this, "_ZN7S4218C13v72Ev");}
void  S4218C1 ::v73(){vfunc_called(this, "_ZN7S4218C13v73Ev");}
void  S4218C1 ::v74(){vfunc_called(this, "_ZN7S4218C13v74Ev");}
void  S4218C1 ::v75(){vfunc_called(this, "_ZN7S4218C13v75Ev");}
void  S4218C1 ::v76(){vfunc_called(this, "_ZN7S4218C13v76Ev");}
void  S4218C1 ::v77(){vfunc_called(this, "_ZN7S4218C13v77Ev");}
void  S4218C1 ::v78(){vfunc_called(this, "_ZN7S4218C13v78Ev");}
void  S4218C1 ::v79(){vfunc_called(this, "_ZN7S4218C13v79Ev");}
void  S4218C1 ::v80(){vfunc_called(this, "_ZN7S4218C13v80Ev");}
void  S4218C1 ::v81(){vfunc_called(this, "_ZN7S4218C13v81Ev");}
void  S4218C1 ::v82(){vfunc_called(this, "_ZN7S4218C13v82Ev");}
void  S4218C1 ::v83(){vfunc_called(this, "_ZN7S4218C13v83Ev");}
void  S4218C1 ::v84(){vfunc_called(this, "_ZN7S4218C13v84Ev");}
void  S4218C1 ::v85(){vfunc_called(this, "_ZN7S4218C13v85Ev");}
void  S4218C1 ::v86(){vfunc_called(this, "_ZN7S4218C13v86Ev");}
void  S4218C1 ::v87(){vfunc_called(this, "_ZN7S4218C13v87Ev");}
void  S4218C1 ::v88(){vfunc_called(this, "_ZN7S4218C13v88Ev");}
void  S4218C1 ::v89(){vfunc_called(this, "_ZN7S4218C13v89Ev");}
void  S4218C1 ::v90(){vfunc_called(this, "_ZN7S4218C13v90Ev");}
void  S4218C1 ::v91(){vfunc_called(this, "_ZN7S4218C13v91Ev");}
void  S4218C1 ::v92(){vfunc_called(this, "_ZN7S4218C13v92Ev");}
void  S4218C1 ::v93(){vfunc_called(this, "_ZN7S4218C13v93Ev");}
void  S4218C1 ::v94(){vfunc_called(this, "_ZN7S4218C13v94Ev");}
void  S4218C1 ::v95(){vfunc_called(this, "_ZN7S4218C13v95Ev");}
void  S4218C1 ::v96(){vfunc_called(this, "_ZN7S4218C13v96Ev");}
void  S4218C1 ::v97(){vfunc_called(this, "_ZN7S4218C13v97Ev");}
void  S4218C1 ::v98(){vfunc_called(this, "_ZN7S4218C13v98Ev");}
void  S4218C1 ::v99(){vfunc_called(this, "_ZN7S4218C13v99Ev");}
void  S4218C1 ::v100(){vfunc_called(this, "_ZN7S4218C14v100Ev");}
void  S4218C1 ::v101(){vfunc_called(this, "_ZN7S4218C14v101Ev");}
void  S4218C1 ::v102(){vfunc_called(this, "_ZN7S4218C14v102Ev");}
void  S4218C1 ::v103(){vfunc_called(this, "_ZN7S4218C14v103Ev");}
S4218C1 ::S4218C1(){ note_ctor("S4218C1", this);} // tgen

static void Test_S4218C1()
{
  extern Class_Descriptor cd_S4218C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(348,519)];
    init_test(&cd_S4218C1, buf);
    S4218C1 *dp, &lv = *(dp=new (buf) S4218C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2776,2072), "sizeof(S4218C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4218C1)");
    check_base_class_offset(lv, (S4218C3*)(S4218C2*), 0, "S4218C1");
    check_base_class_offset(lv, (S4218C2*), 0, "S4218C1");
    check_base_class_offset(lv, (S4218C7*), ABISELECT(72,56), "S4218C1");
    check_base_class_offset(lv, (S4218C8*), ABISELECT(80,60), "S4218C1");
    check_base_class_offset(lv, (S4218C9*), ABISELECT(88,64), "S4218C1");
    check_base_class_offset(lv, (S4216C11*), ABISELECT(96,68), "S4218C1");
    check_base_class_offset(lv, (S4218C17*)(S4218C16*)(S4218C15*), ABISELECT(120,84), "S4218C1");
    check_base_class_offset(lv, (S4218C16*)(S4218C15*), ABISELECT(120,84), "S4218C1");
    check_base_class_offset(lv, (S4218C18*)(S4218C15*), ABISELECT(160,108), "S4218C1");
    check_base_class_offset(lv, (S4218C15*), ABISELECT(120,84), "S4218C1");
    check_field_offset(lv, s4218c1f0, ABISELECT(176,116), "S4218C1.s4218c1f0");
    check_field_offset(lv, s4218c1f1, ABISELECT(208,148), "S4218C1.s4218c1f1");
    check_field_offset(lv, s4218c1f2, ABISELECT(240,180), "S4218C1.s4218c1f2");
    check_field_offset(lv, s4218c1f3, ABISELECT(256,188), "S4218C1.s4218c1f3");
    check_field_offset(lv, s4218c1f4, ABISELECT(304,228), "S4218C1.s4218c1f4");
    check_field_offset(lv, s4218c1f5, ABISELECT(320,236), "S4218C1.s4218c1f5");
    check_field_offset(lv, s4218c1f6, ABISELECT(332,248), "S4218C1.s4218c1f6");
    check_field_offset(lv, s4218c1f7, ABISELECT(336,252), "S4218C1.s4218c1f7");
    check_field_offset(lv, s4218c1f8, ABISELECT(344,260), "S4218C1.s4218c1f8");
    check_field_offset(lv, s4218c1f9, ABISELECT(2680,2008), "S4218C1.s4218c1f9");
    check_field_offset(lv, s4218c1f10, ABISELECT(2744,2044), "S4218C1.s4218c1f10");
    check_field_offset(lv, s4218c1f11, ABISELECT(2752,2052), "S4218C1.s4218c1f11");
    check_field_offset(lv, s4218c1f12, ABISELECT(2756,2056), "S4218C1.s4218c1f12");
    check_field_offset(lv, s4218c1f13, ABISELECT(2760,2060), "S4218C1.s4218c1f13");
    check_field_offset(lv, s4218c1f14, ABISELECT(2768,2064), "S4218C1.s4218c1f14");
    check_field_offset(lv, s4218c1f15, ABISELECT(2772,2068), "S4218C1.s4218c1f15");
    test_class_info(&lv, &cd_S4218C1);
    dp->~S4218C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4218C1(Test_S4218C1, "S4218C1", ABISELECT(2776,2072));

#else // __cplusplus

extern void _ZN7S4218C1C1Ev();
extern void _ZN7S4218C1D1Ev();
Name_Map name_map_S4218C1[] = {
  NSPAIR(_ZN7S4218C1C1Ev),
  NSPAIR(_ZN7S4218C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4218C3;
extern VTBL_ENTRY _ZTI7S4218C3[];
extern  VTBL_ENTRY _ZTV7S4218C3[];
extern Class_Descriptor cd_S4218C2;
extern VTBL_ENTRY _ZTI7S4218C2[];
extern  VTBL_ENTRY _ZTV7S4218C2[];
extern Class_Descriptor cd_S4218C7;
extern VTBL_ENTRY _ZTI7S4218C7[];
extern  VTBL_ENTRY _ZTV7S4218C7[];
extern Class_Descriptor cd_S4218C8;
extern VTBL_ENTRY _ZTI7S4218C8[];
extern  VTBL_ENTRY _ZTV7S4218C8[];
extern Class_Descriptor cd_S4218C9;
extern VTBL_ENTRY _ZTI7S4218C9[];
extern  VTBL_ENTRY _ZTV7S4218C9[];
extern Class_Descriptor cd_S4216C11;
extern VTBL_ENTRY _ZTI8S4216C11[];
extern  VTBL_ENTRY _ZTV8S4216C11[];
extern Class_Descriptor cd_S4218C17;
extern VTBL_ENTRY _ZTI8S4218C17[];
extern  VTBL_ENTRY _ZTV8S4218C17[];
extern Class_Descriptor cd_S4218C16;
extern VTBL_ENTRY _ZTI8S4218C16[];
extern  VTBL_ENTRY _ZTV8S4218C16[];
extern Class_Descriptor cd_S4218C18;
extern VTBL_ENTRY _ZTI8S4218C18[];
extern  VTBL_ENTRY _ZTV8S4218C18[];
extern Class_Descriptor cd_S4218C15;
extern VTBL_ENTRY _ZTI8S4218C15[];
extern  VTBL_ENTRY _ZTV8S4218C15[];
static Base_Class bases_S4218C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4218C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4218C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4218C7,    ABISELECT(72,56), //bcp->offset
    113, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4218C8,    ABISELECT(80,60), //bcp->offset
    132, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4218C9,    ABISELECT(88,64), //bcp->offset
    216, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C11,    ABISELECT(96,68), //bcp->offset
    221, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4218C17,    ABISELECT(120,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S4218C16,    ABISELECT(120,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S4218C18,    ABISELECT(160,108), //bcp->offset
    247, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S4218C15,    ABISELECT(120,84), //bcp->offset
    225, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4218C1[];
extern void _ZN7S4218C1D1Ev();
extern void _ZN7S4218C1D0Ev();
extern void _ZN7S4218C34v104Ev();
extern void _ZN7S4218C34v105Ev();
extern void _ZN7S4218C34v106Ev();
extern void _ZN7S4218C24v107Ev();
extern void _ZN7S4218C24v108Ev();
extern void _ZN7S4218C24v109Ev();
extern void _ZN7S4218C12v1Ev();
extern void _ZN7S4218C12v2Ev();
extern void _ZN7S4218C12v3Ev();
extern void _ZN7S4218C12v4Ev();
extern void _ZN7S4218C12v5Ev();
extern void _ZN7S4218C12v6Ev();
extern void _ZN7S4218C12v7Ev();
extern void _ZN7S4218C12v8Ev();
extern void _ZN7S4218C12v9Ev();
extern void _ZN7S4218C13v10Ev();
extern void _ZN7S4218C13v11Ev();
extern void _ZN7S4218C13v12Ev();
extern void _ZN7S4218C13v13Ev();
extern void _ZN7S4218C13v14Ev();
extern void _ZN7S4218C13v15Ev();
extern void _ZN7S4218C13v16Ev();
extern void _ZN7S4218C13v17Ev();
extern void _ZN7S4218C13v18Ev();
extern void _ZN7S4218C13v19Ev();
extern void _ZN7S4218C13v20Ev();
extern void _ZN7S4218C13v21Ev();
extern void _ZN7S4218C13v22Ev();
extern void _ZN7S4218C13v23Ev();
extern void _ZN7S4218C13v24Ev();
extern void _ZN7S4218C13v25Ev();
extern void _ZN7S4218C13v26Ev();
extern void _ZN7S4218C13v27Ev();
extern void _ZN7S4218C13v28Ev();
extern void _ZN7S4218C13v29Ev();
extern void _ZN7S4218C13v30Ev();
extern void _ZN7S4218C13v31Ev();
extern void _ZN7S4218C13v32Ev();
extern void _ZN7S4218C13v33Ev();
extern void _ZN7S4218C13v34Ev();
extern void _ZN7S4218C13v35Ev();
extern void _ZN7S4218C13v36Ev();
extern void _ZN7S4218C13v37Ev();
extern void _ZN7S4218C13v38Ev();
extern void _ZN7S4218C13v39Ev();
extern void _ZN7S4218C13v40Ev();
extern void _ZN7S4218C13v41Ev();
extern void _ZN7S4218C13v42Ev();
extern void _ZN7S4218C13v43Ev();
extern void _ZN7S4218C13v44Ev();
extern void _ZN7S4218C13v45Ev();
extern void _ZN7S4218C13v46Ev();
extern void _ZN7S4218C13v47Ev();
extern void _ZN7S4218C13v48Ev();
extern void _ZN7S4218C13v49Ev();
extern void _ZN7S4218C13v50Ev();
extern void _ZN7S4218C13v51Ev();
extern void _ZN7S4218C13v52Ev();
extern void _ZN7S4218C13v53Ev();
extern void _ZN7S4218C13v54Ev();
extern void _ZN7S4218C13v55Ev();
extern void _ZN7S4218C13v56Ev();
extern void _ZN7S4218C13v57Ev();
extern void _ZN7S4218C13v58Ev();
extern void _ZN7S4218C13v59Ev();
extern void _ZN7S4218C13v60Ev();
extern void _ZN7S4218C13v61Ev();
extern void _ZN7S4218C13v62Ev();
extern void _ZN7S4218C13v63Ev();
extern void _ZN7S4218C13v64Ev();
extern void _ZN7S4218C13v65Ev();
extern void _ZN7S4218C13v66Ev();
extern void _ZN7S4218C13v67Ev();
extern void _ZN7S4218C13v68Ev();
extern void _ZN7S4218C13v69Ev();
extern void _ZN7S4218C13v70Ev();
extern void _ZN7S4218C13v71Ev();
extern void _ZN7S4218C13v72Ev();
extern void _ZN7S4218C13v73Ev();
extern void _ZN7S4218C13v74Ev();
extern void _ZN7S4218C13v75Ev();
extern void _ZN7S4218C13v76Ev();
extern void _ZN7S4218C13v77Ev();
extern void _ZN7S4218C13v78Ev();
extern void _ZN7S4218C13v79Ev();
extern void _ZN7S4218C13v80Ev();
extern void _ZN7S4218C13v81Ev();
extern void _ZN7S4218C13v82Ev();
extern void _ZN7S4218C13v83Ev();
extern void _ZN7S4218C13v84Ev();
extern void _ZN7S4218C13v85Ev();
extern void _ZN7S4218C13v86Ev();
extern void _ZN7S4218C13v87Ev();
extern void _ZN7S4218C13v88Ev();
extern void _ZN7S4218C13v89Ev();
extern void _ZN7S4218C13v90Ev();
extern void _ZN7S4218C13v91Ev();
extern void _ZN7S4218C13v92Ev();
extern void _ZN7S4218C13v93Ev();
extern void _ZN7S4218C13v94Ev();
extern void _ZN7S4218C13v95Ev();
extern void _ZN7S4218C13v96Ev();
extern void _ZN7S4218C13v97Ev();
extern void _ZN7S4218C13v98Ev();
extern void _ZN7S4218C13v99Ev();
extern void _ZN7S4218C14v100Ev();
extern void _ZN7S4218C14v101Ev();
extern void _ZN7S4218C14v102Ev();
extern void _ZN7S4218C14v103Ev();
extern void ABISELECT(_ZThn72_N7S4218C1D1Ev,_ZThn56_N7S4218C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S4218C1D0Ev,_ZThn56_N7S4218C1D0Ev)();
extern void _ZN7S4218C74v110Ev();
extern void _ZN7S4218C74v111Ev();
extern void _ZN7S4218C74v112Ev();
extern void _ZN7S4218C74v113Ev();
extern void _ZN7S4218C74v114Ev();
extern void _ZN7S4218C74v115Ev();
extern void _ZN7S4218C74v116Ev();
extern void _ZN7S4218C74v117Ev();
extern void _ZN7S4218C74v118Ev();
extern void _ZN7S4218C74v119Ev();
extern void _ZN7S4218C74v120Ev();
extern void _ZN7S4218C74v121Ev();
extern void _ZN7S4218C74v122Ev();
extern void _ZN7S4218C74v123Ev();
extern void _ZN7S4218C74v124Ev();
extern void ABISELECT(_ZThn80_N7S4218C1D1Ev,_ZThn60_N7S4218C1D1Ev)();
extern void ABISELECT(_ZThn80_N7S4218C1D0Ev,_ZThn60_N7S4218C1D0Ev)();
extern void _ZN7S4218C84v125Ev();
extern void _ZN7S4218C84v126Ev();
extern void _ZN7S4218C84v127Ev();
extern void _ZN7S4218C84v128Ev();
extern void _ZN7S4218C84v129Ev();
extern void _ZN7S4218C84v130Ev();
extern void _ZN7S4218C84v131Ev();
extern void _ZN7S4218C84v132Ev();
extern void _ZN7S4218C84v133Ev();
extern void _ZN7S4218C84v134Ev();
extern void _ZN7S4218C84v135Ev();
extern void _ZN7S4218C84v136Ev();
extern void _ZN7S4218C84v137Ev();
extern void _ZN7S4218C84v138Ev();
extern void _ZN7S4218C84v139Ev();
extern void _ZN7S4218C84v140Ev();
extern void _ZN7S4218C84v141Ev();
extern void _ZN7S4218C84v142Ev();
extern void _ZN7S4218C84v143Ev();
extern void _ZN7S4218C84v144Ev();
extern void _ZN7S4218C84v145Ev();
extern void _ZN7S4218C84v146Ev();
extern void _ZN7S4218C84v147Ev();
extern void _ZN7S4218C84v148Ev();
extern void _ZN7S4218C84v149Ev();
extern void _ZN7S4218C84v150Ev();
extern void _ZN7S4218C84v151Ev();
extern void _ZN7S4218C84v152Ev();
extern void _ZN7S4218C84v153Ev();
extern void _ZN7S4218C84v154Ev();
extern void _ZN7S4218C84v155Ev();
extern void _ZN7S4218C84v156Ev();
extern void _ZN7S4218C84v157Ev();
extern void _ZN7S4218C84v158Ev();
extern void _ZN7S4218C84v159Ev();
extern void _ZN7S4218C84v160Ev();
extern void _ZN7S4218C84v161Ev();
extern void _ZN7S4218C84v162Ev();
extern void _ZN7S4218C84v163Ev();
extern void _ZN7S4218C84v164Ev();
extern void _ZN7S4218C84v165Ev();
extern void _ZN7S4218C84v166Ev();
extern void _ZN7S4218C84v167Ev();
extern void _ZN7S4218C84v168Ev();
extern void _ZN7S4218C84v169Ev();
extern void _ZN7S4218C84v170Ev();
extern void _ZN7S4218C84v171Ev();
extern void _ZN7S4218C84v172Ev();
extern void _ZN7S4218C84v173Ev();
extern void _ZN7S4218C84v174Ev();
extern void _ZN7S4218C84v175Ev();
extern void _ZN7S4218C84v176Ev();
extern void _ZN7S4218C84v177Ev();
extern void _ZN7S4218C84v178Ev();
extern void _ZN7S4218C84v179Ev();
extern void _ZN7S4218C84v180Ev();
extern void _ZN7S4218C84v181Ev();
extern void _ZN7S4218C84v182Ev();
extern void _ZN7S4218C84v183Ev();
extern void _ZN7S4218C84v184Ev();
extern void _ZN7S4218C84v185Ev();
extern void _ZN7S4218C84v186Ev();
extern void _ZN7S4218C84v187Ev();
extern void _ZN7S4218C84v188Ev();
extern void _ZN7S4218C84v189Ev();
extern void _ZN7S4218C84v190Ev();
extern void _ZN7S4218C84v191Ev();
extern void _ZN7S4218C84v192Ev();
extern void _ZN7S4218C84v193Ev();
extern void _ZN7S4218C84v194Ev();
extern void _ZN7S4218C84v195Ev();
extern void _ZN7S4218C84v196Ev();
extern void _ZN7S4218C84v197Ev();
extern void _ZN7S4218C84v198Ev();
extern void _ZN7S4218C84v199Ev();
extern void _ZN7S4218C84v200Ev();
extern void _ZN7S4218C84v201Ev();
extern void _ZN7S4218C84v202Ev();
extern void _ZN7S4218C84v203Ev();
extern void _ZN7S4218C84v204Ev();
extern void ABISELECT(_ZThn88_N7S4218C1D1Ev,_ZThn64_N7S4218C1D1Ev)();
extern void ABISELECT(_ZThn88_N7S4218C1D0Ev,_ZThn64_N7S4218C1D0Ev)();
extern void _ZN7S4218C94v205Ev();
extern void ABISELECT(_ZThn96_N7S4218C1D1Ev,_ZThn68_N7S4218C1D1Ev)();
extern void ABISELECT(_ZThn96_N7S4218C1D0Ev,_ZThn68_N7S4218C1D0Ev)();
extern void ABISELECT(_ZThn120_N7S4218C1D1Ev,_ZThn84_N7S4218C1D1Ev)();
extern void ABISELECT(_ZThn120_N7S4218C1D0Ev,_ZThn84_N7S4218C1D0Ev)();
extern void _ZN8S4218C174v206Ev();
extern void _ZN8S4218C164v207Ev();
extern void _ZN8S4218C164v208Ev();
extern void _ZN8S4218C164v209Ev();
extern void _ZN8S4218C164v210Ev();
extern void _ZN8S4218C164v211Ev();
extern void _ZN8S4218C164v212Ev();
extern void _ZN8S4218C164v213Ev();
extern void _ZN8S4218C154v217Ev();
extern void _ZN8S4218C154v218Ev();
extern void _ZN8S4218C154v219Ev();
extern void _ZN8S4218C154v220Ev();
extern void _ZN8S4218C154v221Ev();
extern void _ZN8S4218C154v222Ev();
extern void _ZN8S4218C154v223Ev();
extern void _ZN8S4218C154v224Ev();
extern void _ZN8S4218C154v225Ev();
extern void _ZN8S4218C154v226Ev();
extern void ABISELECT(_ZThn160_N7S4218C1D1Ev,_ZThn108_N7S4218C1D1Ev)();
extern void ABISELECT(_ZThn160_N7S4218C1D0Ev,_ZThn108_N7S4218C1D0Ev)();
extern void _ZN8S4218C184v214Ev();
extern void _ZN8S4218C184v215Ev();
extern void _ZN8S4218C184v216Ev();
static  VTBL_ENTRY vtc_S4218C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4218C1[0]),
  (VTBL_ENTRY)&_ZN7S4218C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4218C1D0Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v104Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v105Ev,
  (VTBL_ENTRY)&_ZN7S4218C34v106Ev,
  (VTBL_ENTRY)&_ZN7S4218C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4218C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4218C24v109Ev,
  (VTBL_ENTRY)&_ZN7S4218C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4218C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4218C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4218C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4218C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4218C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4218C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4218C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4218C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v12Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v13Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v14Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v15Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v16Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v17Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v18Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v19Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v20Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v21Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v22Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v23Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v24Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v25Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v26Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v27Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v28Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v29Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v30Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v31Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v32Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v33Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v34Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v35Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v36Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v37Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v38Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v39Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v40Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v41Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v42Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v43Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v44Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v45Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v46Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v47Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v48Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v49Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v50Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v51Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v52Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v53Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v54Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v55Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v56Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v57Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v58Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v59Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v60Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v61Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v62Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v63Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v64Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v65Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v66Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v67Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v68Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v69Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v70Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v71Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v72Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v73Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v74Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v75Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v76Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v77Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v78Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v79Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v80Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v81Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v82Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v83Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v84Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v85Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v86Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v87Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v88Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v89Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v90Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v91Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v92Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v93Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v94Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v95Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v96Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v97Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v98Ev,
  (VTBL_ENTRY)&_ZN7S4218C13v99Ev,
  (VTBL_ENTRY)&_ZN7S4218C14v100Ev,
  (VTBL_ENTRY)&_ZN7S4218C14v101Ev,
  (VTBL_ENTRY)&_ZN7S4218C14v102Ev,
  (VTBL_ENTRY)&_ZN7S4218C14v103Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S4218C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S4218C1D1Ev,_ZThn56_N7S4218C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S4218C1D0Ev,_ZThn56_N7S4218C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4218C74v110Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v111Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v112Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v113Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v114Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v115Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v116Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v117Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v118Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v119Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v120Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v121Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v122Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v123Ev,
  (VTBL_ENTRY)&_ZN7S4218C74v124Ev,
  ABISELECT(-80,-60),
  (VTBL_ENTRY)&(_ZTI7S4218C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N7S4218C1D1Ev,_ZThn60_N7S4218C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn80_N7S4218C1D0Ev,_ZThn60_N7S4218C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4218C84v125Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v126Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v127Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v128Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v129Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v130Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v131Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v132Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v133Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v134Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v135Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v136Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v137Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v138Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v139Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v140Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v141Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v142Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v143Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v144Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v145Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v146Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v147Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v148Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v149Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v150Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v151Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v152Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v153Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v154Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v155Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v156Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v157Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v158Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v159Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v160Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v161Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v162Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v163Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v164Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v165Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v166Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v167Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v168Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v169Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v170Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v171Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v172Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v173Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v174Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v175Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v176Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v177Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v178Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v179Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v180Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v181Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v182Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v183Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v184Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v185Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v186Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v187Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v188Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v189Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v190Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v191Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v192Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v193Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v194Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v195Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v196Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v197Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v198Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v199Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v200Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v201Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v202Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v203Ev,
  (VTBL_ENTRY)&_ZN7S4218C84v204Ev,
  ABISELECT(-88,-64),
  (VTBL_ENTRY)&(_ZTI7S4218C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N7S4218C1D1Ev,_ZThn64_N7S4218C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn88_N7S4218C1D0Ev,_ZThn64_N7S4218C1D0Ev),
  (VTBL_ENTRY)&_ZN7S4218C94v205Ev,
  ABISELECT(-96,-68),
  (VTBL_ENTRY)&(_ZTI7S4218C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S4218C1D1Ev,_ZThn68_N7S4218C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S4218C1D0Ev,_ZThn68_N7S4218C1D0Ev),
  ABISELECT(-120,-84),
  (VTBL_ENTRY)&(_ZTI7S4218C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn120_N7S4218C1D1Ev,_ZThn84_N7S4218C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn120_N7S4218C1D0Ev,_ZThn84_N7S4218C1D0Ev),
  (VTBL_ENTRY)&_ZN8S4218C174v206Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v207Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v208Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v209Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v210Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v211Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v212Ev,
  (VTBL_ENTRY)&_ZN8S4218C164v213Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v217Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v218Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v219Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v220Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v221Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v222Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v223Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v224Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v225Ev,
  (VTBL_ENTRY)&_ZN8S4218C154v226Ev,
  ABISELECT(-160,-108),
  (VTBL_ENTRY)&(_ZTI7S4218C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N7S4218C1D1Ev,_ZThn108_N7S4218C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn160_N7S4218C1D0Ev,_ZThn108_N7S4218C1D0Ev),
  (VTBL_ENTRY)&_ZN8S4218C184v214Ev,
  (VTBL_ENTRY)&_ZN8S4218C184v215Ev,
  (VTBL_ENTRY)&_ZN8S4218C184v216Ev,
};
extern VTBL_ENTRY _ZTI7S4218C1[];
extern  VTBL_ENTRY _ZTV7S4218C1[];
Class_Descriptor cd_S4218C1 = {  "S4218C1", // class name
  bases_S4218C1, 10,
  &(vtc_S4218C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2776,2072), // object size
  NSPAIRA(_ZTI7S4218C1),ABISELECT(120,64), //typeinfo_var
  NSPAIRA(_ZTV7S4218C1),254, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  10, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10327C2  {
  virtual  ~S10327C2(); // _ZN8S10327C2D1Ev
  virtual void  v98(); // _ZN8S10327C23v98Ev
  virtual void  v99(); // _ZN8S10327C23v99Ev
  virtual void  v100(); // _ZN8S10327C24v100Ev
  virtual void  v101(); // _ZN8S10327C24v101Ev
  virtual void  v102(); // _ZN8S10327C24v102Ev
  virtual void  v103(); // _ZN8S10327C24v103Ev
  virtual void  v104(); // _ZN8S10327C24v104Ev
  virtual void  v105(); // _ZN8S10327C24v105Ev
  virtual void  v106(); // _ZN8S10327C24v106Ev
  virtual void  v107(); // _ZN8S10327C24v107Ev
  virtual void  v108(); // _ZN8S10327C24v108Ev
  virtual void  v109(); // _ZN8S10327C24v109Ev
  virtual void  v110(); // _ZN8S10327C24v110Ev
  virtual void  v111(); // _ZN8S10327C24v111Ev
  virtual void  v112(); // _ZN8S10327C24v112Ev
  S10327C2(); // tgen
};
//SIG(-1 S10327C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15}


 S10327C2 ::~S10327C2(){ note_dtor("S10327C2", this);}
void  S10327C2 ::v98(){vfunc_called(this, "_ZN8S10327C23v98Ev");}
void  S10327C2 ::v99(){vfunc_called(this, "_ZN8S10327C23v99Ev");}
void  S10327C2 ::v100(){vfunc_called(this, "_ZN8S10327C24v100Ev");}
void  S10327C2 ::v101(){vfunc_called(this, "_ZN8S10327C24v101Ev");}
void  S10327C2 ::v102(){vfunc_called(this, "_ZN8S10327C24v102Ev");}
void  S10327C2 ::v103(){vfunc_called(this, "_ZN8S10327C24v103Ev");}
void  S10327C2 ::v104(){vfunc_called(this, "_ZN8S10327C24v104Ev");}
void  S10327C2 ::v105(){vfunc_called(this, "_ZN8S10327C24v105Ev");}
void  S10327C2 ::v106(){vfunc_called(this, "_ZN8S10327C24v106Ev");}
void  S10327C2 ::v107(){vfunc_called(this, "_ZN8S10327C24v107Ev");}
void  S10327C2 ::v108(){vfunc_called(this, "_ZN8S10327C24v108Ev");}
void  S10327C2 ::v109(){vfunc_called(this, "_ZN8S10327C24v109Ev");}
void  S10327C2 ::v110(){vfunc_called(this, "_ZN8S10327C24v110Ev");}
void  S10327C2 ::v111(){vfunc_called(this, "_ZN8S10327C24v111Ev");}
void  S10327C2 ::v112(){vfunc_called(this, "_ZN8S10327C24v112Ev");}
S10327C2 ::S10327C2(){ note_ctor("S10327C2", this);} // tgen

static void Test_S10327C2()
{
  extern Class_Descriptor cd_S10327C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10327C2, buf);
    S10327C2 *dp, &lv = *(dp=new (buf) S10327C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10327C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10327C2)");
    test_class_info(&lv, &cd_S10327C2);
    dp->~S10327C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10327C2(Test_S10327C2, "S10327C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10327C2C1Ev();
extern void _ZN8S10327C2D1Ev();
Name_Map name_map_S10327C2[] = {
  NSPAIR(_ZN8S10327C2C1Ev),
  NSPAIR(_ZN8S10327C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10327C2[];
extern void _ZN8S10327C2D1Ev();
extern void _ZN8S10327C2D0Ev();
extern void _ZN8S10327C23v98Ev();
extern void _ZN8S10327C23v99Ev();
extern void _ZN8S10327C24v100Ev();
extern void _ZN8S10327C24v101Ev();
extern void _ZN8S10327C24v102Ev();
extern void _ZN8S10327C24v103Ev();
extern void _ZN8S10327C24v104Ev();
extern void _ZN8S10327C24v105Ev();
extern void _ZN8S10327C24v106Ev();
extern void _ZN8S10327C24v107Ev();
extern void _ZN8S10327C24v108Ev();
extern void _ZN8S10327C24v109Ev();
extern void _ZN8S10327C24v110Ev();
extern void _ZN8S10327C24v111Ev();
extern void _ZN8S10327C24v112Ev();
static  VTBL_ENTRY vtc_S10327C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10327C2[0]),
  (VTBL_ENTRY)&_ZN8S10327C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10327C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10327C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10327C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v112Ev,
};
extern VTBL_ENTRY _ZTI8S10327C2[];
extern  VTBL_ENTRY _ZTV8S10327C2[];
Class_Descriptor cd_S10327C2 = {  "S10327C2", // class name
  0,0,//no base classes
  &(vtc_S10327C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10327C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10327C2),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10327C3  {
  virtual  ~S10327C3(); // _ZN8S10327C3D1Ev
  virtual void  v113(); // _ZN8S10327C34v113Ev
  virtual void  v114(); // _ZN8S10327C34v114Ev
  virtual void  v115(); // _ZN8S10327C34v115Ev
  virtual void  v116(); // _ZN8S10327C34v116Ev
  virtual void  v117(); // _ZN8S10327C34v117Ev
  virtual void  v118(); // _ZN8S10327C34v118Ev
  virtual void  v119(); // _ZN8S10327C34v119Ev
  virtual void  v120(); // _ZN8S10327C34v120Ev
  virtual void  v121(); // _ZN8S10327C34v121Ev
  virtual void  v122(); // _ZN8S10327C34v122Ev
  virtual void  v123(); // _ZN8S10327C34v123Ev
  virtual void  v124(); // _ZN8S10327C34v124Ev
  virtual void  v125(); // _ZN8S10327C34v125Ev
  virtual void  v126(); // _ZN8S10327C34v126Ev
  virtual void  v127(); // _ZN8S10327C34v127Ev
  virtual void  v128(); // _ZN8S10327C34v128Ev
  virtual void  v129(); // _ZN8S10327C34v129Ev
  virtual void  v130(); // _ZN8S10327C34v130Ev
  virtual void  v131(); // _ZN8S10327C34v131Ev
  virtual void  v132(); // _ZN8S10327C34v132Ev
  virtual void  v133(); // _ZN8S10327C34v133Ev
  virtual void  v134(); // _ZN8S10327C34v134Ev
  virtual void  v135(); // _ZN8S10327C34v135Ev
  virtual void  v136(); // _ZN8S10327C34v136Ev
  virtual void  v137(); // _ZN8S10327C34v137Ev
  virtual void  v138(); // _ZN8S10327C34v138Ev
  virtual void  v139(); // _ZN8S10327C34v139Ev
  virtual void  v140(); // _ZN8S10327C34v140Ev
  virtual void  v141(); // _ZN8S10327C34v141Ev
  virtual void  v142(); // _ZN8S10327C34v142Ev
  virtual void  v143(); // _ZN8S10327C34v143Ev
  virtual void  v144(); // _ZN8S10327C34v144Ev
  virtual void  v145(); // _ZN8S10327C34v145Ev
  virtual void  v146(); // _ZN8S10327C34v146Ev
  virtual void  v147(); // _ZN8S10327C34v147Ev
  virtual void  v148(); // _ZN8S10327C34v148Ev
  virtual void  v149(); // _ZN8S10327C34v149Ev
  virtual void  v150(); // _ZN8S10327C34v150Ev
  virtual void  v151(); // _ZN8S10327C34v151Ev
  virtual void  v152(); // _ZN8S10327C34v152Ev
  virtual void  v153(); // _ZN8S10327C34v153Ev
  virtual void  v154(); // _ZN8S10327C34v154Ev
  virtual void  v155(); // _ZN8S10327C34v155Ev
  virtual void  v156(); // _ZN8S10327C34v156Ev
  virtual void  v157(); // _ZN8S10327C34v157Ev
  virtual void  v158(); // _ZN8S10327C34v158Ev
  virtual void  v159(); // _ZN8S10327C34v159Ev
  virtual void  v160(); // _ZN8S10327C34v160Ev
  virtual void  v161(); // _ZN8S10327C34v161Ev
  virtual void  v162(); // _ZN8S10327C34v162Ev
  virtual void  v163(); // _ZN8S10327C34v163Ev
  virtual void  v164(); // _ZN8S10327C34v164Ev
  virtual void  v165(); // _ZN8S10327C34v165Ev
  virtual void  v166(); // _ZN8S10327C34v166Ev
  virtual void  v167(); // _ZN8S10327C34v167Ev
  virtual void  v168(); // _ZN8S10327C34v168Ev
  virtual void  v169(); // _ZN8S10327C34v169Ev
  virtual void  v170(); // _ZN8S10327C34v170Ev
  virtual void  v171(); // _ZN8S10327C34v171Ev
  virtual void  v172(); // _ZN8S10327C34v172Ev
  virtual void  v173(); // _ZN8S10327C34v173Ev
  virtual void  v174(); // _ZN8S10327C34v174Ev
  virtual void  v175(); // _ZN8S10327C34v175Ev
  virtual void  v176(); // _ZN8S10327C34v176Ev
  virtual void  v177(); // _ZN8S10327C34v177Ev
  virtual void  v178(); // _ZN8S10327C34v178Ev
  virtual void  v179(); // _ZN8S10327C34v179Ev
  virtual void  v180(); // _ZN8S10327C34v180Ev
  virtual void  v181(); // _ZN8S10327C34v181Ev
  virtual void  v182(); // _ZN8S10327C34v182Ev
  virtual void  v183(); // _ZN8S10327C34v183Ev
  virtual void  v184(); // _ZN8S10327C34v184Ev
  virtual void  v185(); // _ZN8S10327C34v185Ev
  virtual void  v186(); // _ZN8S10327C34v186Ev
  virtual void  v187(); // _ZN8S10327C34v187Ev
  virtual void  v188(); // _ZN8S10327C34v188Ev
  virtual void  v189(); // _ZN8S10327C34v189Ev
  virtual void  v190(); // _ZN8S10327C34v190Ev
  virtual void  v191(); // _ZN8S10327C34v191Ev
  virtual void  v192(); // _ZN8S10327C34v192Ev
  S10327C3(); // tgen
};
//SIG(-1 S10327C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80}


 S10327C3 ::~S10327C3(){ note_dtor("S10327C3", this);}
void  S10327C3 ::v113(){vfunc_called(this, "_ZN8S10327C34v113Ev");}
void  S10327C3 ::v114(){vfunc_called(this, "_ZN8S10327C34v114Ev");}
void  S10327C3 ::v115(){vfunc_called(this, "_ZN8S10327C34v115Ev");}
void  S10327C3 ::v116(){vfunc_called(this, "_ZN8S10327C34v116Ev");}
void  S10327C3 ::v117(){vfunc_called(this, "_ZN8S10327C34v117Ev");}
void  S10327C3 ::v118(){vfunc_called(this, "_ZN8S10327C34v118Ev");}
void  S10327C3 ::v119(){vfunc_called(this, "_ZN8S10327C34v119Ev");}
void  S10327C3 ::v120(){vfunc_called(this, "_ZN8S10327C34v120Ev");}
void  S10327C3 ::v121(){vfunc_called(this, "_ZN8S10327C34v121Ev");}
void  S10327C3 ::v122(){vfunc_called(this, "_ZN8S10327C34v122Ev");}
void  S10327C3 ::v123(){vfunc_called(this, "_ZN8S10327C34v123Ev");}
void  S10327C3 ::v124(){vfunc_called(this, "_ZN8S10327C34v124Ev");}
void  S10327C3 ::v125(){vfunc_called(this, "_ZN8S10327C34v125Ev");}
void  S10327C3 ::v126(){vfunc_called(this, "_ZN8S10327C34v126Ev");}
void  S10327C3 ::v127(){vfunc_called(this, "_ZN8S10327C34v127Ev");}
void  S10327C3 ::v128(){vfunc_called(this, "_ZN8S10327C34v128Ev");}
void  S10327C3 ::v129(){vfunc_called(this, "_ZN8S10327C34v129Ev");}
void  S10327C3 ::v130(){vfunc_called(this, "_ZN8S10327C34v130Ev");}
void  S10327C3 ::v131(){vfunc_called(this, "_ZN8S10327C34v131Ev");}
void  S10327C3 ::v132(){vfunc_called(this, "_ZN8S10327C34v132Ev");}
void  S10327C3 ::v133(){vfunc_called(this, "_ZN8S10327C34v133Ev");}
void  S10327C3 ::v134(){vfunc_called(this, "_ZN8S10327C34v134Ev");}
void  S10327C3 ::v135(){vfunc_called(this, "_ZN8S10327C34v135Ev");}
void  S10327C3 ::v136(){vfunc_called(this, "_ZN8S10327C34v136Ev");}
void  S10327C3 ::v137(){vfunc_called(this, "_ZN8S10327C34v137Ev");}
void  S10327C3 ::v138(){vfunc_called(this, "_ZN8S10327C34v138Ev");}
void  S10327C3 ::v139(){vfunc_called(this, "_ZN8S10327C34v139Ev");}
void  S10327C3 ::v140(){vfunc_called(this, "_ZN8S10327C34v140Ev");}
void  S10327C3 ::v141(){vfunc_called(this, "_ZN8S10327C34v141Ev");}
void  S10327C3 ::v142(){vfunc_called(this, "_ZN8S10327C34v142Ev");}
void  S10327C3 ::v143(){vfunc_called(this, "_ZN8S10327C34v143Ev");}
void  S10327C3 ::v144(){vfunc_called(this, "_ZN8S10327C34v144Ev");}
void  S10327C3 ::v145(){vfunc_called(this, "_ZN8S10327C34v145Ev");}
void  S10327C3 ::v146(){vfunc_called(this, "_ZN8S10327C34v146Ev");}
void  S10327C3 ::v147(){vfunc_called(this, "_ZN8S10327C34v147Ev");}
void  S10327C3 ::v148(){vfunc_called(this, "_ZN8S10327C34v148Ev");}
void  S10327C3 ::v149(){vfunc_called(this, "_ZN8S10327C34v149Ev");}
void  S10327C3 ::v150(){vfunc_called(this, "_ZN8S10327C34v150Ev");}
void  S10327C3 ::v151(){vfunc_called(this, "_ZN8S10327C34v151Ev");}
void  S10327C3 ::v152(){vfunc_called(this, "_ZN8S10327C34v152Ev");}
void  S10327C3 ::v153(){vfunc_called(this, "_ZN8S10327C34v153Ev");}
void  S10327C3 ::v154(){vfunc_called(this, "_ZN8S10327C34v154Ev");}
void  S10327C3 ::v155(){vfunc_called(this, "_ZN8S10327C34v155Ev");}
void  S10327C3 ::v156(){vfunc_called(this, "_ZN8S10327C34v156Ev");}
void  S10327C3 ::v157(){vfunc_called(this, "_ZN8S10327C34v157Ev");}
void  S10327C3 ::v158(){vfunc_called(this, "_ZN8S10327C34v158Ev");}
void  S10327C3 ::v159(){vfunc_called(this, "_ZN8S10327C34v159Ev");}
void  S10327C3 ::v160(){vfunc_called(this, "_ZN8S10327C34v160Ev");}
void  S10327C3 ::v161(){vfunc_called(this, "_ZN8S10327C34v161Ev");}
void  S10327C3 ::v162(){vfunc_called(this, "_ZN8S10327C34v162Ev");}
void  S10327C3 ::v163(){vfunc_called(this, "_ZN8S10327C34v163Ev");}
void  S10327C3 ::v164(){vfunc_called(this, "_ZN8S10327C34v164Ev");}
void  S10327C3 ::v165(){vfunc_called(this, "_ZN8S10327C34v165Ev");}
void  S10327C3 ::v166(){vfunc_called(this, "_ZN8S10327C34v166Ev");}
void  S10327C3 ::v167(){vfunc_called(this, "_ZN8S10327C34v167Ev");}
void  S10327C3 ::v168(){vfunc_called(this, "_ZN8S10327C34v168Ev");}
void  S10327C3 ::v169(){vfunc_called(this, "_ZN8S10327C34v169Ev");}
void  S10327C3 ::v170(){vfunc_called(this, "_ZN8S10327C34v170Ev");}
void  S10327C3 ::v171(){vfunc_called(this, "_ZN8S10327C34v171Ev");}
void  S10327C3 ::v172(){vfunc_called(this, "_ZN8S10327C34v172Ev");}
void  S10327C3 ::v173(){vfunc_called(this, "_ZN8S10327C34v173Ev");}
void  S10327C3 ::v174(){vfunc_called(this, "_ZN8S10327C34v174Ev");}
void  S10327C3 ::v175(){vfunc_called(this, "_ZN8S10327C34v175Ev");}
void  S10327C3 ::v176(){vfunc_called(this, "_ZN8S10327C34v176Ev");}
void  S10327C3 ::v177(){vfunc_called(this, "_ZN8S10327C34v177Ev");}
void  S10327C3 ::v178(){vfunc_called(this, "_ZN8S10327C34v178Ev");}
void  S10327C3 ::v179(){vfunc_called(this, "_ZN8S10327C34v179Ev");}
void  S10327C3 ::v180(){vfunc_called(this, "_ZN8S10327C34v180Ev");}
void  S10327C3 ::v181(){vfunc_called(this, "_ZN8S10327C34v181Ev");}
void  S10327C3 ::v182(){vfunc_called(this, "_ZN8S10327C34v182Ev");}
void  S10327C3 ::v183(){vfunc_called(this, "_ZN8S10327C34v183Ev");}
void  S10327C3 ::v184(){vfunc_called(this, "_ZN8S10327C34v184Ev");}
void  S10327C3 ::v185(){vfunc_called(this, "_ZN8S10327C34v185Ev");}
void  S10327C3 ::v186(){vfunc_called(this, "_ZN8S10327C34v186Ev");}
void  S10327C3 ::v187(){vfunc_called(this, "_ZN8S10327C34v187Ev");}
void  S10327C3 ::v188(){vfunc_called(this, "_ZN8S10327C34v188Ev");}
void  S10327C3 ::v189(){vfunc_called(this, "_ZN8S10327C34v189Ev");}
void  S10327C3 ::v190(){vfunc_called(this, "_ZN8S10327C34v190Ev");}
void  S10327C3 ::v191(){vfunc_called(this, "_ZN8S10327C34v191Ev");}
void  S10327C3 ::v192(){vfunc_called(this, "_ZN8S10327C34v192Ev");}
S10327C3 ::S10327C3(){ note_ctor("S10327C3", this);} // tgen

static void Test_S10327C3()
{
  extern Class_Descriptor cd_S10327C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10327C3, buf);
    S10327C3 *dp, &lv = *(dp=new (buf) S10327C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10327C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10327C3)");
    test_class_info(&lv, &cd_S10327C3);
    dp->~S10327C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10327C3(Test_S10327C3, "S10327C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10327C3C1Ev();
extern void _ZN8S10327C3D1Ev();
Name_Map name_map_S10327C3[] = {
  NSPAIR(_ZN8S10327C3C1Ev),
  NSPAIR(_ZN8S10327C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10327C3[];
extern void _ZN8S10327C3D1Ev();
extern void _ZN8S10327C3D0Ev();
extern void _ZN8S10327C34v113Ev();
extern void _ZN8S10327C34v114Ev();
extern void _ZN8S10327C34v115Ev();
extern void _ZN8S10327C34v116Ev();
extern void _ZN8S10327C34v117Ev();
extern void _ZN8S10327C34v118Ev();
extern void _ZN8S10327C34v119Ev();
extern void _ZN8S10327C34v120Ev();
extern void _ZN8S10327C34v121Ev();
extern void _ZN8S10327C34v122Ev();
extern void _ZN8S10327C34v123Ev();
extern void _ZN8S10327C34v124Ev();
extern void _ZN8S10327C34v125Ev();
extern void _ZN8S10327C34v126Ev();
extern void _ZN8S10327C34v127Ev();
extern void _ZN8S10327C34v128Ev();
extern void _ZN8S10327C34v129Ev();
extern void _ZN8S10327C34v130Ev();
extern void _ZN8S10327C34v131Ev();
extern void _ZN8S10327C34v132Ev();
extern void _ZN8S10327C34v133Ev();
extern void _ZN8S10327C34v134Ev();
extern void _ZN8S10327C34v135Ev();
extern void _ZN8S10327C34v136Ev();
extern void _ZN8S10327C34v137Ev();
extern void _ZN8S10327C34v138Ev();
extern void _ZN8S10327C34v139Ev();
extern void _ZN8S10327C34v140Ev();
extern void _ZN8S10327C34v141Ev();
extern void _ZN8S10327C34v142Ev();
extern void _ZN8S10327C34v143Ev();
extern void _ZN8S10327C34v144Ev();
extern void _ZN8S10327C34v145Ev();
extern void _ZN8S10327C34v146Ev();
extern void _ZN8S10327C34v147Ev();
extern void _ZN8S10327C34v148Ev();
extern void _ZN8S10327C34v149Ev();
extern void _ZN8S10327C34v150Ev();
extern void _ZN8S10327C34v151Ev();
extern void _ZN8S10327C34v152Ev();
extern void _ZN8S10327C34v153Ev();
extern void _ZN8S10327C34v154Ev();
extern void _ZN8S10327C34v155Ev();
extern void _ZN8S10327C34v156Ev();
extern void _ZN8S10327C34v157Ev();
extern void _ZN8S10327C34v158Ev();
extern void _ZN8S10327C34v159Ev();
extern void _ZN8S10327C34v160Ev();
extern void _ZN8S10327C34v161Ev();
extern void _ZN8S10327C34v162Ev();
extern void _ZN8S10327C34v163Ev();
extern void _ZN8S10327C34v164Ev();
extern void _ZN8S10327C34v165Ev();
extern void _ZN8S10327C34v166Ev();
extern void _ZN8S10327C34v167Ev();
extern void _ZN8S10327C34v168Ev();
extern void _ZN8S10327C34v169Ev();
extern void _ZN8S10327C34v170Ev();
extern void _ZN8S10327C34v171Ev();
extern void _ZN8S10327C34v172Ev();
extern void _ZN8S10327C34v173Ev();
extern void _ZN8S10327C34v174Ev();
extern void _ZN8S10327C34v175Ev();
extern void _ZN8S10327C34v176Ev();
extern void _ZN8S10327C34v177Ev();
extern void _ZN8S10327C34v178Ev();
extern void _ZN8S10327C34v179Ev();
extern void _ZN8S10327C34v180Ev();
extern void _ZN8S10327C34v181Ev();
extern void _ZN8S10327C34v182Ev();
extern void _ZN8S10327C34v183Ev();
extern void _ZN8S10327C34v184Ev();
extern void _ZN8S10327C34v185Ev();
extern void _ZN8S10327C34v186Ev();
extern void _ZN8S10327C34v187Ev();
extern void _ZN8S10327C34v188Ev();
extern void _ZN8S10327C34v189Ev();
extern void _ZN8S10327C34v190Ev();
extern void _ZN8S10327C34v191Ev();
extern void _ZN8S10327C34v192Ev();
static  VTBL_ENTRY vtc_S10327C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10327C3[0]),
  (VTBL_ENTRY)&_ZN8S10327C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10327C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v113Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v114Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v115Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v116Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v117Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v118Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v119Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v120Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v121Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v122Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v123Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v124Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v125Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v126Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v127Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v128Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v129Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v130Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v131Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v132Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v133Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v134Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v135Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v136Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v137Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v138Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v139Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v140Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v141Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v142Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v143Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v144Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v145Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v146Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v147Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v148Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v149Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v150Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v151Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v152Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v153Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v154Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v155Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v156Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v157Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v158Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v159Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v160Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v161Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v162Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v163Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v164Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v165Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v166Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v167Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v168Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v169Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v170Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v171Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v172Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v173Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v174Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v175Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v176Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v177Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v178Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v179Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v180Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v181Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v182Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v183Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v184Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v185Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v186Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v187Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v188Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v189Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v190Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v191Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v192Ev,
};
extern VTBL_ENTRY _ZTI8S10327C3[];
extern  VTBL_ENTRY _ZTV8S10327C3[];
Class_Descriptor cd_S10327C3 = {  "S10327C3", // class name
  0,0,//no base classes
  &(vtc_S10327C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10327C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10327C3),84, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10327C4  {
  virtual  ~S10327C4(); // _ZN8S10327C4D1Ev
  virtual void  v193(); // _ZN8S10327C44v193Ev
  S10327C4(); // tgen
};
//SIG(-1 S10327C4) C1{ vd v1}


 S10327C4 ::~S10327C4(){ note_dtor("S10327C4", this);}
void  S10327C4 ::v193(){vfunc_called(this, "_ZN8S10327C44v193Ev");}
S10327C4 ::S10327C4(){ note_ctor("S10327C4", this);} // tgen

static void Test_S10327C4()
{
  extern Class_Descriptor cd_S10327C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10327C4, buf);
    S10327C4 *dp, &lv = *(dp=new (buf) S10327C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10327C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10327C4)");
    test_class_info(&lv, &cd_S10327C4);
    dp->~S10327C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10327C4(Test_S10327C4, "S10327C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10327C4C1Ev();
extern void _ZN8S10327C4D1Ev();
Name_Map name_map_S10327C4[] = {
  NSPAIR(_ZN8S10327C4C1Ev),
  NSPAIR(_ZN8S10327C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10327C4[];
extern void _ZN8S10327C4D1Ev();
extern void _ZN8S10327C4D0Ev();
extern void _ZN8S10327C44v193Ev();
static  VTBL_ENTRY vtc_S10327C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10327C4[0]),
  (VTBL_ENTRY)&_ZN8S10327C4D1Ev,
  (VTBL_ENTRY)&_ZN8S10327C4D0Ev,
  (VTBL_ENTRY)&_ZN8S10327C44v193Ev,
};
extern VTBL_ENTRY _ZTI8S10327C4[];
extern  VTBL_ENTRY _ZTV8S10327C4[];
Class_Descriptor cd_S10327C4 = {  "S10327C4", // class name
  0,0,//no base classes
  &(vtc_S10327C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10327C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10327C4),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10327C1  : S10327C2 , S10327C3 , S10327C4 , S4216C11 {
  void *s10327c1f0[2];
  ::S4217C6_nt s10327c1f1;
  void *s10327c1f2;
  int s10327c1f3[3];
  ::S4216C22_nt s10327c1f4;
  int s10327c1f5;
  virtual  ~S10327C1(); // _ZN8S10327C1D1Ev
  virtual void  v1(); // _ZN8S10327C12v1Ev
  virtual void  v2(); // _ZN8S10327C12v2Ev
  virtual void  v3(); // _ZN8S10327C12v3Ev
  virtual void  v4(); // _ZN8S10327C12v4Ev
  virtual void  v5(); // _ZN8S10327C12v5Ev
  virtual void  v6(); // _ZN8S10327C12v6Ev
  virtual void  v7(); // _ZN8S10327C12v7Ev
  virtual void  v8(); // _ZN8S10327C12v8Ev
  virtual void  v9(); // _ZN8S10327C12v9Ev
  virtual void  v10(); // _ZN8S10327C13v10Ev
  virtual void  v11(); // _ZN8S10327C13v11Ev
  virtual void  v12(); // _ZN8S10327C13v12Ev
  virtual void  v13(); // _ZN8S10327C13v13Ev
  virtual void  v14(); // _ZN8S10327C13v14Ev
  virtual void  v15(); // _ZN8S10327C13v15Ev
  virtual void  v16(); // _ZN8S10327C13v16Ev
  virtual void  v17(); // _ZN8S10327C13v17Ev
  virtual void  v18(); // _ZN8S10327C13v18Ev
  virtual void  v19(); // _ZN8S10327C13v19Ev
  virtual void  v20(); // _ZN8S10327C13v20Ev
  virtual void  v21(); // _ZN8S10327C13v21Ev
  virtual void  v22(); // _ZN8S10327C13v22Ev
  virtual void  v23(); // _ZN8S10327C13v23Ev
  virtual void  v24(); // _ZN8S10327C13v24Ev
  virtual void  v25(); // _ZN8S10327C13v25Ev
  virtual void  v26(); // _ZN8S10327C13v26Ev
  virtual void  v27(); // _ZN8S10327C13v27Ev
  virtual void  v28(); // _ZN8S10327C13v28Ev
  virtual void  v29(); // _ZN8S10327C13v29Ev
  virtual void  v30(); // _ZN8S10327C13v30Ev
  virtual void  v31(); // _ZN8S10327C13v31Ev
  virtual void  v32(); // _ZN8S10327C13v32Ev
  virtual void  v33(); // _ZN8S10327C13v33Ev
  virtual void  v34(); // _ZN8S10327C13v34Ev
  virtual void  v35(); // _ZN8S10327C13v35Ev
  virtual void  v36(); // _ZN8S10327C13v36Ev
  virtual void  v37(); // _ZN8S10327C13v37Ev
  virtual void  v38(); // _ZN8S10327C13v38Ev
  virtual void  v39(); // _ZN8S10327C13v39Ev
  virtual void  v40(); // _ZN8S10327C13v40Ev
  virtual void  v41(); // _ZN8S10327C13v41Ev
  virtual void  v42(); // _ZN8S10327C13v42Ev
  virtual void  v43(); // _ZN8S10327C13v43Ev
  virtual void  v44(); // _ZN8S10327C13v44Ev
  virtual void  v45(); // _ZN8S10327C13v45Ev
  virtual void  v46(); // _ZN8S10327C13v46Ev
  virtual void  v47(); // _ZN8S10327C13v47Ev
  virtual void  v48(); // _ZN8S10327C13v48Ev
  virtual void  v49(); // _ZN8S10327C13v49Ev
  virtual void  v50(); // _ZN8S10327C13v50Ev
  virtual void  v51(); // _ZN8S10327C13v51Ev
  virtual void  v52(); // _ZN8S10327C13v52Ev
  virtual void  v53(); // _ZN8S10327C13v53Ev
  virtual void  v54(); // _ZN8S10327C13v54Ev
  virtual void  v55(); // _ZN8S10327C13v55Ev
  virtual void  v56(); // _ZN8S10327C13v56Ev
  virtual void  v57(); // _ZN8S10327C13v57Ev
  virtual void  v58(); // _ZN8S10327C13v58Ev
  virtual void  v59(); // _ZN8S10327C13v59Ev
  virtual void  v60(); // _ZN8S10327C13v60Ev
  virtual void  v61(); // _ZN8S10327C13v61Ev
  virtual void  v62(); // _ZN8S10327C13v62Ev
  virtual void  v63(); // _ZN8S10327C13v63Ev
  virtual void  v64(); // _ZN8S10327C13v64Ev
  virtual void  v65(); // _ZN8S10327C13v65Ev
  virtual void  v66(); // _ZN8S10327C13v66Ev
  virtual void  v67(); // _ZN8S10327C13v67Ev
  virtual void  v68(); // _ZN8S10327C13v68Ev
  virtual void  v69(); // _ZN8S10327C13v69Ev
  virtual void  v70(); // _ZN8S10327C13v70Ev
  virtual void  v71(); // _ZN8S10327C13v71Ev
  virtual void  v72(); // _ZN8S10327C13v72Ev
  virtual void  v73(); // _ZN8S10327C13v73Ev
  virtual void  v74(); // _ZN8S10327C13v74Ev
  virtual void  v75(); // _ZN8S10327C13v75Ev
  virtual void  v76(); // _ZN8S10327C13v76Ev
  virtual void  v77(); // _ZN8S10327C13v77Ev
  virtual void  v78(); // _ZN8S10327C13v78Ev
  virtual void  v79(); // _ZN8S10327C13v79Ev
  virtual void  v80(); // _ZN8S10327C13v80Ev
  virtual void  v81(); // _ZN8S10327C13v81Ev
  virtual void  v82(); // _ZN8S10327C13v82Ev
  virtual void  v83(); // _ZN8S10327C13v83Ev
  virtual void  v84(); // _ZN8S10327C13v84Ev
  virtual void  v85(); // _ZN8S10327C13v85Ev
  virtual void  v86(); // _ZN8S10327C13v86Ev
  virtual void  v87(); // _ZN8S10327C13v87Ev
  virtual void  v88(); // _ZN8S10327C13v88Ev
  virtual void  v89(); // _ZN8S10327C13v89Ev
  virtual void  v90(); // _ZN8S10327C13v90Ev
  virtual void  v91(); // _ZN8S10327C13v91Ev
  virtual void  v92(); // _ZN8S10327C13v92Ev
  virtual void  v93(); // _ZN8S10327C13v93Ev
  virtual void  v94(); // _ZN8S10327C13v94Ev
  virtual void  v95(); // _ZN8S10327C13v95Ev
  virtual void  v96(); // _ZN8S10327C13v96Ev
  virtual void  v97(); // _ZN8S10327C13v97Ev
  S10327C1(); // tgen
};
//SIG(1 S10327C1) C1{ BC2{ vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112} BC3{ vd v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192} BC4{ vd v193} BC5{ vd m FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fp[2] FC10{ m FC11{ FL[4]}} Fp Fi[3] FC12{ m Fp Fi FC9} Fi}


 S10327C1 ::~S10327C1(){ note_dtor("S10327C1", this);}
void  S10327C1 ::v1(){vfunc_called(this, "_ZN8S10327C12v1Ev");}
void  S10327C1 ::v2(){vfunc_called(this, "_ZN8S10327C12v2Ev");}
void  S10327C1 ::v3(){vfunc_called(this, "_ZN8S10327C12v3Ev");}
void  S10327C1 ::v4(){vfunc_called(this, "_ZN8S10327C12v4Ev");}
void  S10327C1 ::v5(){vfunc_called(this, "_ZN8S10327C12v5Ev");}
void  S10327C1 ::v6(){vfunc_called(this, "_ZN8S10327C12v6Ev");}
void  S10327C1 ::v7(){vfunc_called(this, "_ZN8S10327C12v7Ev");}
void  S10327C1 ::v8(){vfunc_called(this, "_ZN8S10327C12v8Ev");}
void  S10327C1 ::v9(){vfunc_called(this, "_ZN8S10327C12v9Ev");}
void  S10327C1 ::v10(){vfunc_called(this, "_ZN8S10327C13v10Ev");}
void  S10327C1 ::v11(){vfunc_called(this, "_ZN8S10327C13v11Ev");}
void  S10327C1 ::v12(){vfunc_called(this, "_ZN8S10327C13v12Ev");}
void  S10327C1 ::v13(){vfunc_called(this, "_ZN8S10327C13v13Ev");}
void  S10327C1 ::v14(){vfunc_called(this, "_ZN8S10327C13v14Ev");}
void  S10327C1 ::v15(){vfunc_called(this, "_ZN8S10327C13v15Ev");}
void  S10327C1 ::v16(){vfunc_called(this, "_ZN8S10327C13v16Ev");}
void  S10327C1 ::v17(){vfunc_called(this, "_ZN8S10327C13v17Ev");}
void  S10327C1 ::v18(){vfunc_called(this, "_ZN8S10327C13v18Ev");}
void  S10327C1 ::v19(){vfunc_called(this, "_ZN8S10327C13v19Ev");}
void  S10327C1 ::v20(){vfunc_called(this, "_ZN8S10327C13v20Ev");}
void  S10327C1 ::v21(){vfunc_called(this, "_ZN8S10327C13v21Ev");}
void  S10327C1 ::v22(){vfunc_called(this, "_ZN8S10327C13v22Ev");}
void  S10327C1 ::v23(){vfunc_called(this, "_ZN8S10327C13v23Ev");}
void  S10327C1 ::v24(){vfunc_called(this, "_ZN8S10327C13v24Ev");}
void  S10327C1 ::v25(){vfunc_called(this, "_ZN8S10327C13v25Ev");}
void  S10327C1 ::v26(){vfunc_called(this, "_ZN8S10327C13v26Ev");}
void  S10327C1 ::v27(){vfunc_called(this, "_ZN8S10327C13v27Ev");}
void  S10327C1 ::v28(){vfunc_called(this, "_ZN8S10327C13v28Ev");}
void  S10327C1 ::v29(){vfunc_called(this, "_ZN8S10327C13v29Ev");}
void  S10327C1 ::v30(){vfunc_called(this, "_ZN8S10327C13v30Ev");}
void  S10327C1 ::v31(){vfunc_called(this, "_ZN8S10327C13v31Ev");}
void  S10327C1 ::v32(){vfunc_called(this, "_ZN8S10327C13v32Ev");}
void  S10327C1 ::v33(){vfunc_called(this, "_ZN8S10327C13v33Ev");}
void  S10327C1 ::v34(){vfunc_called(this, "_ZN8S10327C13v34Ev");}
void  S10327C1 ::v35(){vfunc_called(this, "_ZN8S10327C13v35Ev");}
void  S10327C1 ::v36(){vfunc_called(this, "_ZN8S10327C13v36Ev");}
void  S10327C1 ::v37(){vfunc_called(this, "_ZN8S10327C13v37Ev");}
void  S10327C1 ::v38(){vfunc_called(this, "_ZN8S10327C13v38Ev");}
void  S10327C1 ::v39(){vfunc_called(this, "_ZN8S10327C13v39Ev");}
void  S10327C1 ::v40(){vfunc_called(this, "_ZN8S10327C13v40Ev");}
void  S10327C1 ::v41(){vfunc_called(this, "_ZN8S10327C13v41Ev");}
void  S10327C1 ::v42(){vfunc_called(this, "_ZN8S10327C13v42Ev");}
void  S10327C1 ::v43(){vfunc_called(this, "_ZN8S10327C13v43Ev");}
void  S10327C1 ::v44(){vfunc_called(this, "_ZN8S10327C13v44Ev");}
void  S10327C1 ::v45(){vfunc_called(this, "_ZN8S10327C13v45Ev");}
void  S10327C1 ::v46(){vfunc_called(this, "_ZN8S10327C13v46Ev");}
void  S10327C1 ::v47(){vfunc_called(this, "_ZN8S10327C13v47Ev");}
void  S10327C1 ::v48(){vfunc_called(this, "_ZN8S10327C13v48Ev");}
void  S10327C1 ::v49(){vfunc_called(this, "_ZN8S10327C13v49Ev");}
void  S10327C1 ::v50(){vfunc_called(this, "_ZN8S10327C13v50Ev");}
void  S10327C1 ::v51(){vfunc_called(this, "_ZN8S10327C13v51Ev");}
void  S10327C1 ::v52(){vfunc_called(this, "_ZN8S10327C13v52Ev");}
void  S10327C1 ::v53(){vfunc_called(this, "_ZN8S10327C13v53Ev");}
void  S10327C1 ::v54(){vfunc_called(this, "_ZN8S10327C13v54Ev");}
void  S10327C1 ::v55(){vfunc_called(this, "_ZN8S10327C13v55Ev");}
void  S10327C1 ::v56(){vfunc_called(this, "_ZN8S10327C13v56Ev");}
void  S10327C1 ::v57(){vfunc_called(this, "_ZN8S10327C13v57Ev");}
void  S10327C1 ::v58(){vfunc_called(this, "_ZN8S10327C13v58Ev");}
void  S10327C1 ::v59(){vfunc_called(this, "_ZN8S10327C13v59Ev");}
void  S10327C1 ::v60(){vfunc_called(this, "_ZN8S10327C13v60Ev");}
void  S10327C1 ::v61(){vfunc_called(this, "_ZN8S10327C13v61Ev");}
void  S10327C1 ::v62(){vfunc_called(this, "_ZN8S10327C13v62Ev");}
void  S10327C1 ::v63(){vfunc_called(this, "_ZN8S10327C13v63Ev");}
void  S10327C1 ::v64(){vfunc_called(this, "_ZN8S10327C13v64Ev");}
void  S10327C1 ::v65(){vfunc_called(this, "_ZN8S10327C13v65Ev");}
void  S10327C1 ::v66(){vfunc_called(this, "_ZN8S10327C13v66Ev");}
void  S10327C1 ::v67(){vfunc_called(this, "_ZN8S10327C13v67Ev");}
void  S10327C1 ::v68(){vfunc_called(this, "_ZN8S10327C13v68Ev");}
void  S10327C1 ::v69(){vfunc_called(this, "_ZN8S10327C13v69Ev");}
void  S10327C1 ::v70(){vfunc_called(this, "_ZN8S10327C13v70Ev");}
void  S10327C1 ::v71(){vfunc_called(this, "_ZN8S10327C13v71Ev");}
void  S10327C1 ::v72(){vfunc_called(this, "_ZN8S10327C13v72Ev");}
void  S10327C1 ::v73(){vfunc_called(this, "_ZN8S10327C13v73Ev");}
void  S10327C1 ::v74(){vfunc_called(this, "_ZN8S10327C13v74Ev");}
void  S10327C1 ::v75(){vfunc_called(this, "_ZN8S10327C13v75Ev");}
void  S10327C1 ::v76(){vfunc_called(this, "_ZN8S10327C13v76Ev");}
void  S10327C1 ::v77(){vfunc_called(this, "_ZN8S10327C13v77Ev");}
void  S10327C1 ::v78(){vfunc_called(this, "_ZN8S10327C13v78Ev");}
void  S10327C1 ::v79(){vfunc_called(this, "_ZN8S10327C13v79Ev");}
void  S10327C1 ::v80(){vfunc_called(this, "_ZN8S10327C13v80Ev");}
void  S10327C1 ::v81(){vfunc_called(this, "_ZN8S10327C13v81Ev");}
void  S10327C1 ::v82(){vfunc_called(this, "_ZN8S10327C13v82Ev");}
void  S10327C1 ::v83(){vfunc_called(this, "_ZN8S10327C13v83Ev");}
void  S10327C1 ::v84(){vfunc_called(this, "_ZN8S10327C13v84Ev");}
void  S10327C1 ::v85(){vfunc_called(this, "_ZN8S10327C13v85Ev");}
void  S10327C1 ::v86(){vfunc_called(this, "_ZN8S10327C13v86Ev");}
void  S10327C1 ::v87(){vfunc_called(this, "_ZN8S10327C13v87Ev");}
void  S10327C1 ::v88(){vfunc_called(this, "_ZN8S10327C13v88Ev");}
void  S10327C1 ::v89(){vfunc_called(this, "_ZN8S10327C13v89Ev");}
void  S10327C1 ::v90(){vfunc_called(this, "_ZN8S10327C13v90Ev");}
void  S10327C1 ::v91(){vfunc_called(this, "_ZN8S10327C13v91Ev");}
void  S10327C1 ::v92(){vfunc_called(this, "_ZN8S10327C13v92Ev");}
void  S10327C1 ::v93(){vfunc_called(this, "_ZN8S10327C13v93Ev");}
void  S10327C1 ::v94(){vfunc_called(this, "_ZN8S10327C13v94Ev");}
void  S10327C1 ::v95(){vfunc_called(this, "_ZN8S10327C13v95Ev");}
void  S10327C1 ::v96(){vfunc_called(this, "_ZN8S10327C13v96Ev");}
void  S10327C1 ::v97(){vfunc_called(this, "_ZN8S10327C13v97Ev");}
S10327C1 ::S10327C1(){ note_ctor("S10327C1", this);} // tgen

static void Test_S10327C1()
{
  extern Class_Descriptor cd_S10327C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,26)];
    init_test(&cd_S10327C1, buf);
    S10327C1 *dp, &lv = *(dp=new (buf) S10327C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,100), "sizeof(S10327C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10327C1)");
    check_base_class_offset(lv, (S10327C2*), 0, "S10327C1");
    check_base_class_offset(lv, (S10327C3*), ABISELECT(8,4), "S10327C1");
    check_base_class_offset(lv, (S10327C4*), ABISELECT(16,8), "S10327C1");
    check_base_class_offset(lv, (S4216C11*), ABISELECT(24,12), "S10327C1");
    check_field_offset(lv, s10327c1f0, ABISELECT(48,28), "S10327C1.s10327c1f0");
    check_field_offset(lv, s10327c1f1, ABISELECT(64,36), "S10327C1.s10327c1f1");
    check_field_offset(lv, s10327c1f2, ABISELECT(96,68), "S10327C1.s10327c1f2");
    check_field_offset(lv, s10327c1f3, ABISELECT(104,72), "S10327C1.s10327c1f3");
    check_field_offset(lv, s10327c1f4, ABISELECT(120,84), "S10327C1.s10327c1f4");
    check_field_offset(lv, s10327c1f5, ABISELECT(136,96), "S10327C1.s10327c1f5");
    test_class_info(&lv, &cd_S10327C1);
    dp->~S10327C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10327C1(Test_S10327C1, "S10327C1", ABISELECT(144,100));

#else // __cplusplus

extern void _ZN8S10327C1C1Ev();
extern void _ZN8S10327C1D1Ev();
Name_Map name_map_S10327C1[] = {
  NSPAIR(_ZN8S10327C1C1Ev),
  NSPAIR(_ZN8S10327C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10327C2;
extern VTBL_ENTRY _ZTI8S10327C2[];
extern  VTBL_ENTRY _ZTV8S10327C2[];
extern Class_Descriptor cd_S10327C3;
extern VTBL_ENTRY _ZTI8S10327C3[];
extern  VTBL_ENTRY _ZTV8S10327C3[];
extern Class_Descriptor cd_S10327C4;
extern VTBL_ENTRY _ZTI8S10327C4[];
extern  VTBL_ENTRY _ZTV8S10327C4[];
extern Class_Descriptor cd_S4216C11;
extern VTBL_ENTRY _ZTI8S4216C11[];
extern  VTBL_ENTRY _ZTV8S4216C11[];
static Base_Class bases_S10327C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10327C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10327C3,    ABISELECT(8,4), //bcp->offset
    116, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10327C4,    ABISELECT(16,8), //bcp->offset
    200, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C11,    ABISELECT(24,12), //bcp->offset
    205, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10327C1[];
extern void _ZN8S10327C1D1Ev();
extern void _ZN8S10327C1D0Ev();
extern void _ZN8S10327C23v98Ev();
extern void _ZN8S10327C23v99Ev();
extern void _ZN8S10327C24v100Ev();
extern void _ZN8S10327C24v101Ev();
extern void _ZN8S10327C24v102Ev();
extern void _ZN8S10327C24v103Ev();
extern void _ZN8S10327C24v104Ev();
extern void _ZN8S10327C24v105Ev();
extern void _ZN8S10327C24v106Ev();
extern void _ZN8S10327C24v107Ev();
extern void _ZN8S10327C24v108Ev();
extern void _ZN8S10327C24v109Ev();
extern void _ZN8S10327C24v110Ev();
extern void _ZN8S10327C24v111Ev();
extern void _ZN8S10327C24v112Ev();
extern void _ZN8S10327C12v1Ev();
extern void _ZN8S10327C12v2Ev();
extern void _ZN8S10327C12v3Ev();
extern void _ZN8S10327C12v4Ev();
extern void _ZN8S10327C12v5Ev();
extern void _ZN8S10327C12v6Ev();
extern void _ZN8S10327C12v7Ev();
extern void _ZN8S10327C12v8Ev();
extern void _ZN8S10327C12v9Ev();
extern void _ZN8S10327C13v10Ev();
extern void _ZN8S10327C13v11Ev();
extern void _ZN8S10327C13v12Ev();
extern void _ZN8S10327C13v13Ev();
extern void _ZN8S10327C13v14Ev();
extern void _ZN8S10327C13v15Ev();
extern void _ZN8S10327C13v16Ev();
extern void _ZN8S10327C13v17Ev();
extern void _ZN8S10327C13v18Ev();
extern void _ZN8S10327C13v19Ev();
extern void _ZN8S10327C13v20Ev();
extern void _ZN8S10327C13v21Ev();
extern void _ZN8S10327C13v22Ev();
extern void _ZN8S10327C13v23Ev();
extern void _ZN8S10327C13v24Ev();
extern void _ZN8S10327C13v25Ev();
extern void _ZN8S10327C13v26Ev();
extern void _ZN8S10327C13v27Ev();
extern void _ZN8S10327C13v28Ev();
extern void _ZN8S10327C13v29Ev();
extern void _ZN8S10327C13v30Ev();
extern void _ZN8S10327C13v31Ev();
extern void _ZN8S10327C13v32Ev();
extern void _ZN8S10327C13v33Ev();
extern void _ZN8S10327C13v34Ev();
extern void _ZN8S10327C13v35Ev();
extern void _ZN8S10327C13v36Ev();
extern void _ZN8S10327C13v37Ev();
extern void _ZN8S10327C13v38Ev();
extern void _ZN8S10327C13v39Ev();
extern void _ZN8S10327C13v40Ev();
extern void _ZN8S10327C13v41Ev();
extern void _ZN8S10327C13v42Ev();
extern void _ZN8S10327C13v43Ev();
extern void _ZN8S10327C13v44Ev();
extern void _ZN8S10327C13v45Ev();
extern void _ZN8S10327C13v46Ev();
extern void _ZN8S10327C13v47Ev();
extern void _ZN8S10327C13v48Ev();
extern void _ZN8S10327C13v49Ev();
extern void _ZN8S10327C13v50Ev();
extern void _ZN8S10327C13v51Ev();
extern void _ZN8S10327C13v52Ev();
extern void _ZN8S10327C13v53Ev();
extern void _ZN8S10327C13v54Ev();
extern void _ZN8S10327C13v55Ev();
extern void _ZN8S10327C13v56Ev();
extern void _ZN8S10327C13v57Ev();
extern void _ZN8S10327C13v58Ev();
extern void _ZN8S10327C13v59Ev();
extern void _ZN8S10327C13v60Ev();
extern void _ZN8S10327C13v61Ev();
extern void _ZN8S10327C13v62Ev();
extern void _ZN8S10327C13v63Ev();
extern void _ZN8S10327C13v64Ev();
extern void _ZN8S10327C13v65Ev();
extern void _ZN8S10327C13v66Ev();
extern void _ZN8S10327C13v67Ev();
extern void _ZN8S10327C13v68Ev();
extern void _ZN8S10327C13v69Ev();
extern void _ZN8S10327C13v70Ev();
extern void _ZN8S10327C13v71Ev();
extern void _ZN8S10327C13v72Ev();
extern void _ZN8S10327C13v73Ev();
extern void _ZN8S10327C13v74Ev();
extern void _ZN8S10327C13v75Ev();
extern void _ZN8S10327C13v76Ev();
extern void _ZN8S10327C13v77Ev();
extern void _ZN8S10327C13v78Ev();
extern void _ZN8S10327C13v79Ev();
extern void _ZN8S10327C13v80Ev();
extern void _ZN8S10327C13v81Ev();
extern void _ZN8S10327C13v82Ev();
extern void _ZN8S10327C13v83Ev();
extern void _ZN8S10327C13v84Ev();
extern void _ZN8S10327C13v85Ev();
extern void _ZN8S10327C13v86Ev();
extern void _ZN8S10327C13v87Ev();
extern void _ZN8S10327C13v88Ev();
extern void _ZN8S10327C13v89Ev();
extern void _ZN8S10327C13v90Ev();
extern void _ZN8S10327C13v91Ev();
extern void _ZN8S10327C13v92Ev();
extern void _ZN8S10327C13v93Ev();
extern void _ZN8S10327C13v94Ev();
extern void _ZN8S10327C13v95Ev();
extern void _ZN8S10327C13v96Ev();
extern void _ZN8S10327C13v97Ev();
extern void ABISELECT(_ZThn8_N8S10327C1D1Ev,_ZThn4_N8S10327C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10327C1D0Ev,_ZThn4_N8S10327C1D0Ev)();
extern void _ZN8S10327C34v113Ev();
extern void _ZN8S10327C34v114Ev();
extern void _ZN8S10327C34v115Ev();
extern void _ZN8S10327C34v116Ev();
extern void _ZN8S10327C34v117Ev();
extern void _ZN8S10327C34v118Ev();
extern void _ZN8S10327C34v119Ev();
extern void _ZN8S10327C34v120Ev();
extern void _ZN8S10327C34v121Ev();
extern void _ZN8S10327C34v122Ev();
extern void _ZN8S10327C34v123Ev();
extern void _ZN8S10327C34v124Ev();
extern void _ZN8S10327C34v125Ev();
extern void _ZN8S10327C34v126Ev();
extern void _ZN8S10327C34v127Ev();
extern void _ZN8S10327C34v128Ev();
extern void _ZN8S10327C34v129Ev();
extern void _ZN8S10327C34v130Ev();
extern void _ZN8S10327C34v131Ev();
extern void _ZN8S10327C34v132Ev();
extern void _ZN8S10327C34v133Ev();
extern void _ZN8S10327C34v134Ev();
extern void _ZN8S10327C34v135Ev();
extern void _ZN8S10327C34v136Ev();
extern void _ZN8S10327C34v137Ev();
extern void _ZN8S10327C34v138Ev();
extern void _ZN8S10327C34v139Ev();
extern void _ZN8S10327C34v140Ev();
extern void _ZN8S10327C34v141Ev();
extern void _ZN8S10327C34v142Ev();
extern void _ZN8S10327C34v143Ev();
extern void _ZN8S10327C34v144Ev();
extern void _ZN8S10327C34v145Ev();
extern void _ZN8S10327C34v146Ev();
extern void _ZN8S10327C34v147Ev();
extern void _ZN8S10327C34v148Ev();
extern void _ZN8S10327C34v149Ev();
extern void _ZN8S10327C34v150Ev();
extern void _ZN8S10327C34v151Ev();
extern void _ZN8S10327C34v152Ev();
extern void _ZN8S10327C34v153Ev();
extern void _ZN8S10327C34v154Ev();
extern void _ZN8S10327C34v155Ev();
extern void _ZN8S10327C34v156Ev();
extern void _ZN8S10327C34v157Ev();
extern void _ZN8S10327C34v158Ev();
extern void _ZN8S10327C34v159Ev();
extern void _ZN8S10327C34v160Ev();
extern void _ZN8S10327C34v161Ev();
extern void _ZN8S10327C34v162Ev();
extern void _ZN8S10327C34v163Ev();
extern void _ZN8S10327C34v164Ev();
extern void _ZN8S10327C34v165Ev();
extern void _ZN8S10327C34v166Ev();
extern void _ZN8S10327C34v167Ev();
extern void _ZN8S10327C34v168Ev();
extern void _ZN8S10327C34v169Ev();
extern void _ZN8S10327C34v170Ev();
extern void _ZN8S10327C34v171Ev();
extern void _ZN8S10327C34v172Ev();
extern void _ZN8S10327C34v173Ev();
extern void _ZN8S10327C34v174Ev();
extern void _ZN8S10327C34v175Ev();
extern void _ZN8S10327C34v176Ev();
extern void _ZN8S10327C34v177Ev();
extern void _ZN8S10327C34v178Ev();
extern void _ZN8S10327C34v179Ev();
extern void _ZN8S10327C34v180Ev();
extern void _ZN8S10327C34v181Ev();
extern void _ZN8S10327C34v182Ev();
extern void _ZN8S10327C34v183Ev();
extern void _ZN8S10327C34v184Ev();
extern void _ZN8S10327C34v185Ev();
extern void _ZN8S10327C34v186Ev();
extern void _ZN8S10327C34v187Ev();
extern void _ZN8S10327C34v188Ev();
extern void _ZN8S10327C34v189Ev();
extern void _ZN8S10327C34v190Ev();
extern void _ZN8S10327C34v191Ev();
extern void _ZN8S10327C34v192Ev();
extern void ABISELECT(_ZThn16_N8S10327C1D1Ev,_ZThn8_N8S10327C1D1Ev)();
extern void ABISELECT(_ZThn16_N8S10327C1D0Ev,_ZThn8_N8S10327C1D0Ev)();
extern void _ZN8S10327C44v193Ev();
extern void ABISELECT(_ZThn24_N8S10327C1D1Ev,_ZThn12_N8S10327C1D1Ev)();
extern void ABISELECT(_ZThn24_N8S10327C1D0Ev,_ZThn12_N8S10327C1D0Ev)();
static  VTBL_ENTRY vtc_S10327C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10327C1[0]),
  (VTBL_ENTRY)&_ZN8S10327C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10327C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10327C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10327C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10327C24v112Ev,
  (VTBL_ENTRY)&_ZN8S10327C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10327C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10327C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10327C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10327C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10327C12v6Ev,
  (VTBL_ENTRY)&_ZN8S10327C12v7Ev,
  (VTBL_ENTRY)&_ZN8S10327C12v8Ev,
  (VTBL_ENTRY)&_ZN8S10327C12v9Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v10Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v11Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v12Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v13Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v14Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v15Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v16Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v17Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v18Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v19Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v20Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v21Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v22Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v23Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v24Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v25Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v26Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v27Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v28Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v29Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v30Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v31Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v32Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v33Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v34Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v35Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v36Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v37Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v38Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v39Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v40Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v41Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v42Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v43Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v44Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v45Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v46Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v47Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v48Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v49Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v50Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v51Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v52Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v53Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v54Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v55Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v56Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v57Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v58Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v59Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v60Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v61Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v62Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v63Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v64Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v65Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v66Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v67Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v68Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v69Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v70Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v71Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v72Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v73Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v74Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v75Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v76Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v77Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v78Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v79Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v80Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v81Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v82Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v83Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v84Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v85Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v86Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v87Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v88Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v89Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v90Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v91Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v92Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v93Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v94Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v95Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v96Ev,
  (VTBL_ENTRY)&_ZN8S10327C13v97Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10327C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10327C1D1Ev,_ZThn4_N8S10327C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10327C1D0Ev,_ZThn4_N8S10327C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10327C34v113Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v114Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v115Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v116Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v117Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v118Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v119Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v120Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v121Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v122Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v123Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v124Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v125Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v126Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v127Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v128Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v129Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v130Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v131Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v132Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v133Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v134Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v135Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v136Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v137Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v138Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v139Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v140Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v141Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v142Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v143Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v144Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v145Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v146Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v147Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v148Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v149Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v150Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v151Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v152Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v153Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v154Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v155Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v156Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v157Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v158Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v159Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v160Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v161Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v162Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v163Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v164Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v165Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v166Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v167Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v168Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v169Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v170Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v171Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v172Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v173Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v174Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v175Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v176Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v177Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v178Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v179Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v180Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v181Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v182Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v183Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v184Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v185Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v186Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v187Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v188Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v189Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v190Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v191Ev,
  (VTBL_ENTRY)&_ZN8S10327C34v192Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S10327C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S10327C1D1Ev,_ZThn8_N8S10327C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S10327C1D0Ev,_ZThn8_N8S10327C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10327C44v193Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S10327C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S10327C1D1Ev,_ZThn12_N8S10327C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S10327C1D0Ev,_ZThn12_N8S10327C1D0Ev),
};
extern VTBL_ENTRY _ZTI8S10327C1[];
extern  VTBL_ENTRY _ZTV8S10327C1[];
Class_Descriptor cd_S10327C1 = {  "S10327C1", // class name
  bases_S10327C1, 4,
  &(vtc_S10327C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,100), // object size
  NSPAIRA(_ZTI8S10327C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S10327C1),209, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10326C2  {
  virtual  ~S10326C2(); // _ZN8S10326C2D1Ev
  virtual void  v98(); // _ZN8S10326C23v98Ev
  virtual void  v99(); // _ZN8S10326C23v99Ev
  virtual void  v100(); // _ZN8S10326C24v100Ev
  virtual void  v101(); // _ZN8S10326C24v101Ev
  virtual void  v102(); // _ZN8S10326C24v102Ev
  virtual void  v103(); // _ZN8S10326C24v103Ev
  virtual void  v104(); // _ZN8S10326C24v104Ev
  virtual void  v105(); // _ZN8S10326C24v105Ev
  virtual void  v106(); // _ZN8S10326C24v106Ev
  virtual void  v107(); // _ZN8S10326C24v107Ev
  virtual void  v108(); // _ZN8S10326C24v108Ev
  virtual void  v109(); // _ZN8S10326C24v109Ev
  virtual void  v110(); // _ZN8S10326C24v110Ev
  virtual void  v111(); // _ZN8S10326C24v111Ev
  virtual void  v112(); // _ZN8S10326C24v112Ev
  S10326C2(); // tgen
};
//SIG(-1 S10326C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15}


 S10326C2 ::~S10326C2(){ note_dtor("S10326C2", this);}
void  S10326C2 ::v98(){vfunc_called(this, "_ZN8S10326C23v98Ev");}
void  S10326C2 ::v99(){vfunc_called(this, "_ZN8S10326C23v99Ev");}
void  S10326C2 ::v100(){vfunc_called(this, "_ZN8S10326C24v100Ev");}
void  S10326C2 ::v101(){vfunc_called(this, "_ZN8S10326C24v101Ev");}
void  S10326C2 ::v102(){vfunc_called(this, "_ZN8S10326C24v102Ev");}
void  S10326C2 ::v103(){vfunc_called(this, "_ZN8S10326C24v103Ev");}
void  S10326C2 ::v104(){vfunc_called(this, "_ZN8S10326C24v104Ev");}
void  S10326C2 ::v105(){vfunc_called(this, "_ZN8S10326C24v105Ev");}
void  S10326C2 ::v106(){vfunc_called(this, "_ZN8S10326C24v106Ev");}
void  S10326C2 ::v107(){vfunc_called(this, "_ZN8S10326C24v107Ev");}
void  S10326C2 ::v108(){vfunc_called(this, "_ZN8S10326C24v108Ev");}
void  S10326C2 ::v109(){vfunc_called(this, "_ZN8S10326C24v109Ev");}
void  S10326C2 ::v110(){vfunc_called(this, "_ZN8S10326C24v110Ev");}
void  S10326C2 ::v111(){vfunc_called(this, "_ZN8S10326C24v111Ev");}
void  S10326C2 ::v112(){vfunc_called(this, "_ZN8S10326C24v112Ev");}
S10326C2 ::S10326C2(){ note_ctor("S10326C2", this);} // tgen

static void Test_S10326C2()
{
  extern Class_Descriptor cd_S10326C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10326C2, buf);
    S10326C2 *dp, &lv = *(dp=new (buf) S10326C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10326C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10326C2)");
    test_class_info(&lv, &cd_S10326C2);
    dp->~S10326C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10326C2(Test_S10326C2, "S10326C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10326C2C1Ev();
extern void _ZN8S10326C2D1Ev();
Name_Map name_map_S10326C2[] = {
  NSPAIR(_ZN8S10326C2C1Ev),
  NSPAIR(_ZN8S10326C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10326C2[];
extern void _ZN8S10326C2D1Ev();
extern void _ZN8S10326C2D0Ev();
extern void _ZN8S10326C23v98Ev();
extern void _ZN8S10326C23v99Ev();
extern void _ZN8S10326C24v100Ev();
extern void _ZN8S10326C24v101Ev();
extern void _ZN8S10326C24v102Ev();
extern void _ZN8S10326C24v103Ev();
extern void _ZN8S10326C24v104Ev();
extern void _ZN8S10326C24v105Ev();
extern void _ZN8S10326C24v106Ev();
extern void _ZN8S10326C24v107Ev();
extern void _ZN8S10326C24v108Ev();
extern void _ZN8S10326C24v109Ev();
extern void _ZN8S10326C24v110Ev();
extern void _ZN8S10326C24v111Ev();
extern void _ZN8S10326C24v112Ev();
static  VTBL_ENTRY vtc_S10326C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10326C2[0]),
  (VTBL_ENTRY)&_ZN8S10326C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10326C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10326C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10326C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v112Ev,
};
extern VTBL_ENTRY _ZTI8S10326C2[];
extern  VTBL_ENTRY _ZTV8S10326C2[];
Class_Descriptor cd_S10326C2 = {  "S10326C2", // class name
  0,0,//no base classes
  &(vtc_S10326C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10326C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10326C2),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10326C3  {
  virtual  ~S10326C3(); // _ZN8S10326C3D1Ev
  virtual void  v113(); // _ZN8S10326C34v113Ev
  virtual void  v114(); // _ZN8S10326C34v114Ev
  virtual void  v115(); // _ZN8S10326C34v115Ev
  virtual void  v116(); // _ZN8S10326C34v116Ev
  virtual void  v117(); // _ZN8S10326C34v117Ev
  virtual void  v118(); // _ZN8S10326C34v118Ev
  virtual void  v119(); // _ZN8S10326C34v119Ev
  virtual void  v120(); // _ZN8S10326C34v120Ev
  virtual void  v121(); // _ZN8S10326C34v121Ev
  virtual void  v122(); // _ZN8S10326C34v122Ev
  virtual void  v123(); // _ZN8S10326C34v123Ev
  virtual void  v124(); // _ZN8S10326C34v124Ev
  virtual void  v125(); // _ZN8S10326C34v125Ev
  virtual void  v126(); // _ZN8S10326C34v126Ev
  virtual void  v127(); // _ZN8S10326C34v127Ev
  virtual void  v128(); // _ZN8S10326C34v128Ev
  virtual void  v129(); // _ZN8S10326C34v129Ev
  virtual void  v130(); // _ZN8S10326C34v130Ev
  virtual void  v131(); // _ZN8S10326C34v131Ev
  virtual void  v132(); // _ZN8S10326C34v132Ev
  virtual void  v133(); // _ZN8S10326C34v133Ev
  virtual void  v134(); // _ZN8S10326C34v134Ev
  virtual void  v135(); // _ZN8S10326C34v135Ev
  virtual void  v136(); // _ZN8S10326C34v136Ev
  virtual void  v137(); // _ZN8S10326C34v137Ev
  virtual void  v138(); // _ZN8S10326C34v138Ev
  virtual void  v139(); // _ZN8S10326C34v139Ev
  virtual void  v140(); // _ZN8S10326C34v140Ev
  virtual void  v141(); // _ZN8S10326C34v141Ev
  virtual void  v142(); // _ZN8S10326C34v142Ev
  virtual void  v143(); // _ZN8S10326C34v143Ev
  virtual void  v144(); // _ZN8S10326C34v144Ev
  virtual void  v145(); // _ZN8S10326C34v145Ev
  virtual void  v146(); // _ZN8S10326C34v146Ev
  virtual void  v147(); // _ZN8S10326C34v147Ev
  virtual void  v148(); // _ZN8S10326C34v148Ev
  virtual void  v149(); // _ZN8S10326C34v149Ev
  virtual void  v150(); // _ZN8S10326C34v150Ev
  virtual void  v151(); // _ZN8S10326C34v151Ev
  virtual void  v152(); // _ZN8S10326C34v152Ev
  virtual void  v153(); // _ZN8S10326C34v153Ev
  virtual void  v154(); // _ZN8S10326C34v154Ev
  virtual void  v155(); // _ZN8S10326C34v155Ev
  virtual void  v156(); // _ZN8S10326C34v156Ev
  virtual void  v157(); // _ZN8S10326C34v157Ev
  virtual void  v158(); // _ZN8S10326C34v158Ev
  virtual void  v159(); // _ZN8S10326C34v159Ev
  virtual void  v160(); // _ZN8S10326C34v160Ev
  virtual void  v161(); // _ZN8S10326C34v161Ev
  virtual void  v162(); // _ZN8S10326C34v162Ev
  virtual void  v163(); // _ZN8S10326C34v163Ev
  virtual void  v164(); // _ZN8S10326C34v164Ev
  virtual void  v165(); // _ZN8S10326C34v165Ev
  virtual void  v166(); // _ZN8S10326C34v166Ev
  virtual void  v167(); // _ZN8S10326C34v167Ev
  virtual void  v168(); // _ZN8S10326C34v168Ev
  virtual void  v169(); // _ZN8S10326C34v169Ev
  virtual void  v170(); // _ZN8S10326C34v170Ev
  virtual void  v171(); // _ZN8S10326C34v171Ev
  virtual void  v172(); // _ZN8S10326C34v172Ev
  virtual void  v173(); // _ZN8S10326C34v173Ev
  virtual void  v174(); // _ZN8S10326C34v174Ev
  virtual void  v175(); // _ZN8S10326C34v175Ev
  virtual void  v176(); // _ZN8S10326C34v176Ev
  virtual void  v177(); // _ZN8S10326C34v177Ev
  virtual void  v178(); // _ZN8S10326C34v178Ev
  virtual void  v179(); // _ZN8S10326C34v179Ev
  virtual void  v180(); // _ZN8S10326C34v180Ev
  virtual void  v181(); // _ZN8S10326C34v181Ev
  virtual void  v182(); // _ZN8S10326C34v182Ev
  virtual void  v183(); // _ZN8S10326C34v183Ev
  virtual void  v184(); // _ZN8S10326C34v184Ev
  virtual void  v185(); // _ZN8S10326C34v185Ev
  virtual void  v186(); // _ZN8S10326C34v186Ev
  virtual void  v187(); // _ZN8S10326C34v187Ev
  virtual void  v188(); // _ZN8S10326C34v188Ev
  virtual void  v189(); // _ZN8S10326C34v189Ev
  virtual void  v190(); // _ZN8S10326C34v190Ev
  virtual void  v191(); // _ZN8S10326C34v191Ev
  virtual void  v192(); // _ZN8S10326C34v192Ev
  S10326C3(); // tgen
};
//SIG(-1 S10326C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80}


 S10326C3 ::~S10326C3(){ note_dtor("S10326C3", this);}
void  S10326C3 ::v113(){vfunc_called(this, "_ZN8S10326C34v113Ev");}
void  S10326C3 ::v114(){vfunc_called(this, "_ZN8S10326C34v114Ev");}
void  S10326C3 ::v115(){vfunc_called(this, "_ZN8S10326C34v115Ev");}
void  S10326C3 ::v116(){vfunc_called(this, "_ZN8S10326C34v116Ev");}
void  S10326C3 ::v117(){vfunc_called(this, "_ZN8S10326C34v117Ev");}
void  S10326C3 ::v118(){vfunc_called(this, "_ZN8S10326C34v118Ev");}
void  S10326C3 ::v119(){vfunc_called(this, "_ZN8S10326C34v119Ev");}
void  S10326C3 ::v120(){vfunc_called(this, "_ZN8S10326C34v120Ev");}
void  S10326C3 ::v121(){vfunc_called(this, "_ZN8S10326C34v121Ev");}
void  S10326C3 ::v122(){vfunc_called(this, "_ZN8S10326C34v122Ev");}
void  S10326C3 ::v123(){vfunc_called(this, "_ZN8S10326C34v123Ev");}
void  S10326C3 ::v124(){vfunc_called(this, "_ZN8S10326C34v124Ev");}
void  S10326C3 ::v125(){vfunc_called(this, "_ZN8S10326C34v125Ev");}
void  S10326C3 ::v126(){vfunc_called(this, "_ZN8S10326C34v126Ev");}
void  S10326C3 ::v127(){vfunc_called(this, "_ZN8S10326C34v127Ev");}
void  S10326C3 ::v128(){vfunc_called(this, "_ZN8S10326C34v128Ev");}
void  S10326C3 ::v129(){vfunc_called(this, "_ZN8S10326C34v129Ev");}
void  S10326C3 ::v130(){vfunc_called(this, "_ZN8S10326C34v130Ev");}
void  S10326C3 ::v131(){vfunc_called(this, "_ZN8S10326C34v131Ev");}
void  S10326C3 ::v132(){vfunc_called(this, "_ZN8S10326C34v132Ev");}
void  S10326C3 ::v133(){vfunc_called(this, "_ZN8S10326C34v133Ev");}
void  S10326C3 ::v134(){vfunc_called(this, "_ZN8S10326C34v134Ev");}
void  S10326C3 ::v135(){vfunc_called(this, "_ZN8S10326C34v135Ev");}
void  S10326C3 ::v136(){vfunc_called(this, "_ZN8S10326C34v136Ev");}
void  S10326C3 ::v137(){vfunc_called(this, "_ZN8S10326C34v137Ev");}
void  S10326C3 ::v138(){vfunc_called(this, "_ZN8S10326C34v138Ev");}
void  S10326C3 ::v139(){vfunc_called(this, "_ZN8S10326C34v139Ev");}
void  S10326C3 ::v140(){vfunc_called(this, "_ZN8S10326C34v140Ev");}
void  S10326C3 ::v141(){vfunc_called(this, "_ZN8S10326C34v141Ev");}
void  S10326C3 ::v142(){vfunc_called(this, "_ZN8S10326C34v142Ev");}
void  S10326C3 ::v143(){vfunc_called(this, "_ZN8S10326C34v143Ev");}
void  S10326C3 ::v144(){vfunc_called(this, "_ZN8S10326C34v144Ev");}
void  S10326C3 ::v145(){vfunc_called(this, "_ZN8S10326C34v145Ev");}
void  S10326C3 ::v146(){vfunc_called(this, "_ZN8S10326C34v146Ev");}
void  S10326C3 ::v147(){vfunc_called(this, "_ZN8S10326C34v147Ev");}
void  S10326C3 ::v148(){vfunc_called(this, "_ZN8S10326C34v148Ev");}
void  S10326C3 ::v149(){vfunc_called(this, "_ZN8S10326C34v149Ev");}
void  S10326C3 ::v150(){vfunc_called(this, "_ZN8S10326C34v150Ev");}
void  S10326C3 ::v151(){vfunc_called(this, "_ZN8S10326C34v151Ev");}
void  S10326C3 ::v152(){vfunc_called(this, "_ZN8S10326C34v152Ev");}
void  S10326C3 ::v153(){vfunc_called(this, "_ZN8S10326C34v153Ev");}
void  S10326C3 ::v154(){vfunc_called(this, "_ZN8S10326C34v154Ev");}
void  S10326C3 ::v155(){vfunc_called(this, "_ZN8S10326C34v155Ev");}
void  S10326C3 ::v156(){vfunc_called(this, "_ZN8S10326C34v156Ev");}
void  S10326C3 ::v157(){vfunc_called(this, "_ZN8S10326C34v157Ev");}
void  S10326C3 ::v158(){vfunc_called(this, "_ZN8S10326C34v158Ev");}
void  S10326C3 ::v159(){vfunc_called(this, "_ZN8S10326C34v159Ev");}
void  S10326C3 ::v160(){vfunc_called(this, "_ZN8S10326C34v160Ev");}
void  S10326C3 ::v161(){vfunc_called(this, "_ZN8S10326C34v161Ev");}
void  S10326C3 ::v162(){vfunc_called(this, "_ZN8S10326C34v162Ev");}
void  S10326C3 ::v163(){vfunc_called(this, "_ZN8S10326C34v163Ev");}
void  S10326C3 ::v164(){vfunc_called(this, "_ZN8S10326C34v164Ev");}
void  S10326C3 ::v165(){vfunc_called(this, "_ZN8S10326C34v165Ev");}
void  S10326C3 ::v166(){vfunc_called(this, "_ZN8S10326C34v166Ev");}
void  S10326C3 ::v167(){vfunc_called(this, "_ZN8S10326C34v167Ev");}
void  S10326C3 ::v168(){vfunc_called(this, "_ZN8S10326C34v168Ev");}
void  S10326C3 ::v169(){vfunc_called(this, "_ZN8S10326C34v169Ev");}
void  S10326C3 ::v170(){vfunc_called(this, "_ZN8S10326C34v170Ev");}
void  S10326C3 ::v171(){vfunc_called(this, "_ZN8S10326C34v171Ev");}
void  S10326C3 ::v172(){vfunc_called(this, "_ZN8S10326C34v172Ev");}
void  S10326C3 ::v173(){vfunc_called(this, "_ZN8S10326C34v173Ev");}
void  S10326C3 ::v174(){vfunc_called(this, "_ZN8S10326C34v174Ev");}
void  S10326C3 ::v175(){vfunc_called(this, "_ZN8S10326C34v175Ev");}
void  S10326C3 ::v176(){vfunc_called(this, "_ZN8S10326C34v176Ev");}
void  S10326C3 ::v177(){vfunc_called(this, "_ZN8S10326C34v177Ev");}
void  S10326C3 ::v178(){vfunc_called(this, "_ZN8S10326C34v178Ev");}
void  S10326C3 ::v179(){vfunc_called(this, "_ZN8S10326C34v179Ev");}
void  S10326C3 ::v180(){vfunc_called(this, "_ZN8S10326C34v180Ev");}
void  S10326C3 ::v181(){vfunc_called(this, "_ZN8S10326C34v181Ev");}
void  S10326C3 ::v182(){vfunc_called(this, "_ZN8S10326C34v182Ev");}
void  S10326C3 ::v183(){vfunc_called(this, "_ZN8S10326C34v183Ev");}
void  S10326C3 ::v184(){vfunc_called(this, "_ZN8S10326C34v184Ev");}
void  S10326C3 ::v185(){vfunc_called(this, "_ZN8S10326C34v185Ev");}
void  S10326C3 ::v186(){vfunc_called(this, "_ZN8S10326C34v186Ev");}
void  S10326C3 ::v187(){vfunc_called(this, "_ZN8S10326C34v187Ev");}
void  S10326C3 ::v188(){vfunc_called(this, "_ZN8S10326C34v188Ev");}
void  S10326C3 ::v189(){vfunc_called(this, "_ZN8S10326C34v189Ev");}
void  S10326C3 ::v190(){vfunc_called(this, "_ZN8S10326C34v190Ev");}
void  S10326C3 ::v191(){vfunc_called(this, "_ZN8S10326C34v191Ev");}
void  S10326C3 ::v192(){vfunc_called(this, "_ZN8S10326C34v192Ev");}
S10326C3 ::S10326C3(){ note_ctor("S10326C3", this);} // tgen

static void Test_S10326C3()
{
  extern Class_Descriptor cd_S10326C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10326C3, buf);
    S10326C3 *dp, &lv = *(dp=new (buf) S10326C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10326C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10326C3)");
    test_class_info(&lv, &cd_S10326C3);
    dp->~S10326C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10326C3(Test_S10326C3, "S10326C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10326C3C1Ev();
extern void _ZN8S10326C3D1Ev();
Name_Map name_map_S10326C3[] = {
  NSPAIR(_ZN8S10326C3C1Ev),
  NSPAIR(_ZN8S10326C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10326C3[];
extern void _ZN8S10326C3D1Ev();
extern void _ZN8S10326C3D0Ev();
extern void _ZN8S10326C34v113Ev();
extern void _ZN8S10326C34v114Ev();
extern void _ZN8S10326C34v115Ev();
extern void _ZN8S10326C34v116Ev();
extern void _ZN8S10326C34v117Ev();
extern void _ZN8S10326C34v118Ev();
extern void _ZN8S10326C34v119Ev();
extern void _ZN8S10326C34v120Ev();
extern void _ZN8S10326C34v121Ev();
extern void _ZN8S10326C34v122Ev();
extern void _ZN8S10326C34v123Ev();
extern void _ZN8S10326C34v124Ev();
extern void _ZN8S10326C34v125Ev();
extern void _ZN8S10326C34v126Ev();
extern void _ZN8S10326C34v127Ev();
extern void _ZN8S10326C34v128Ev();
extern void _ZN8S10326C34v129Ev();
extern void _ZN8S10326C34v130Ev();
extern void _ZN8S10326C34v131Ev();
extern void _ZN8S10326C34v132Ev();
extern void _ZN8S10326C34v133Ev();
extern void _ZN8S10326C34v134Ev();
extern void _ZN8S10326C34v135Ev();
extern void _ZN8S10326C34v136Ev();
extern void _ZN8S10326C34v137Ev();
extern void _ZN8S10326C34v138Ev();
extern void _ZN8S10326C34v139Ev();
extern void _ZN8S10326C34v140Ev();
extern void _ZN8S10326C34v141Ev();
extern void _ZN8S10326C34v142Ev();
extern void _ZN8S10326C34v143Ev();
extern void _ZN8S10326C34v144Ev();
extern void _ZN8S10326C34v145Ev();
extern void _ZN8S10326C34v146Ev();
extern void _ZN8S10326C34v147Ev();
extern void _ZN8S10326C34v148Ev();
extern void _ZN8S10326C34v149Ev();
extern void _ZN8S10326C34v150Ev();
extern void _ZN8S10326C34v151Ev();
extern void _ZN8S10326C34v152Ev();
extern void _ZN8S10326C34v153Ev();
extern void _ZN8S10326C34v154Ev();
extern void _ZN8S10326C34v155Ev();
extern void _ZN8S10326C34v156Ev();
extern void _ZN8S10326C34v157Ev();
extern void _ZN8S10326C34v158Ev();
extern void _ZN8S10326C34v159Ev();
extern void _ZN8S10326C34v160Ev();
extern void _ZN8S10326C34v161Ev();
extern void _ZN8S10326C34v162Ev();
extern void _ZN8S10326C34v163Ev();
extern void _ZN8S10326C34v164Ev();
extern void _ZN8S10326C34v165Ev();
extern void _ZN8S10326C34v166Ev();
extern void _ZN8S10326C34v167Ev();
extern void _ZN8S10326C34v168Ev();
extern void _ZN8S10326C34v169Ev();
extern void _ZN8S10326C34v170Ev();
extern void _ZN8S10326C34v171Ev();
extern void _ZN8S10326C34v172Ev();
extern void _ZN8S10326C34v173Ev();
extern void _ZN8S10326C34v174Ev();
extern void _ZN8S10326C34v175Ev();
extern void _ZN8S10326C34v176Ev();
extern void _ZN8S10326C34v177Ev();
extern void _ZN8S10326C34v178Ev();
extern void _ZN8S10326C34v179Ev();
extern void _ZN8S10326C34v180Ev();
extern void _ZN8S10326C34v181Ev();
extern void _ZN8S10326C34v182Ev();
extern void _ZN8S10326C34v183Ev();
extern void _ZN8S10326C34v184Ev();
extern void _ZN8S10326C34v185Ev();
extern void _ZN8S10326C34v186Ev();
extern void _ZN8S10326C34v187Ev();
extern void _ZN8S10326C34v188Ev();
extern void _ZN8S10326C34v189Ev();
extern void _ZN8S10326C34v190Ev();
extern void _ZN8S10326C34v191Ev();
extern void _ZN8S10326C34v192Ev();
static  VTBL_ENTRY vtc_S10326C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10326C3[0]),
  (VTBL_ENTRY)&_ZN8S10326C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10326C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v113Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v114Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v115Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v116Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v117Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v118Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v119Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v120Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v121Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v122Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v123Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v124Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v125Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v126Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v127Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v128Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v129Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v130Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v131Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v132Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v133Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v134Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v135Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v136Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v137Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v138Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v139Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v140Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v141Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v142Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v143Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v144Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v145Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v146Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v147Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v148Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v149Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v150Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v151Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v152Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v153Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v154Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v155Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v156Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v157Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v158Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v159Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v160Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v161Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v162Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v163Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v164Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v165Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v166Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v167Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v168Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v169Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v170Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v171Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v172Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v173Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v174Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v175Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v176Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v177Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v178Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v179Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v180Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v181Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v182Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v183Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v184Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v185Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v186Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v187Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v188Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v189Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v190Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v191Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v192Ev,
};
extern VTBL_ENTRY _ZTI8S10326C3[];
extern  VTBL_ENTRY _ZTV8S10326C3[];
Class_Descriptor cd_S10326C3 = {  "S10326C3", // class name
  0,0,//no base classes
  &(vtc_S10326C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10326C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10326C3),84, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10326C4  {
  virtual  ~S10326C4(); // _ZN8S10326C4D1Ev
  virtual void  v193(); // _ZN8S10326C44v193Ev
  S10326C4(); // tgen
};
//SIG(-1 S10326C4) C1{ vd v1}


 S10326C4 ::~S10326C4(){ note_dtor("S10326C4", this);}
void  S10326C4 ::v193(){vfunc_called(this, "_ZN8S10326C44v193Ev");}
S10326C4 ::S10326C4(){ note_ctor("S10326C4", this);} // tgen

static void Test_S10326C4()
{
  extern Class_Descriptor cd_S10326C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10326C4, buf);
    S10326C4 *dp, &lv = *(dp=new (buf) S10326C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10326C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10326C4)");
    test_class_info(&lv, &cd_S10326C4);
    dp->~S10326C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10326C4(Test_S10326C4, "S10326C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10326C4C1Ev();
extern void _ZN8S10326C4D1Ev();
Name_Map name_map_S10326C4[] = {
  NSPAIR(_ZN8S10326C4C1Ev),
  NSPAIR(_ZN8S10326C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10326C4[];
extern void _ZN8S10326C4D1Ev();
extern void _ZN8S10326C4D0Ev();
extern void _ZN8S10326C44v193Ev();
static  VTBL_ENTRY vtc_S10326C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10326C4[0]),
  (VTBL_ENTRY)&_ZN8S10326C4D1Ev,
  (VTBL_ENTRY)&_ZN8S10326C4D0Ev,
  (VTBL_ENTRY)&_ZN8S10326C44v193Ev,
};
extern VTBL_ENTRY _ZTI8S10326C4[];
extern  VTBL_ENTRY _ZTV8S10326C4[];
Class_Descriptor cd_S10326C4 = {  "S10326C4", // class name
  0,0,//no base classes
  &(vtc_S10326C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10326C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10326C4),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10326C1  : S10326C2 , S10326C3 , S10326C4 , S4216C11 {
  void *s10326c1f0[2];
  ::S4216C6_nt s10326c1f1;
  void *s10326c1f2;
  int s10326c1f3[3];
  ::S4216C22_nt s10326c1f4;
  int s10326c1f5;
  virtual  ~S10326C1(); // _ZN8S10326C1D1Ev
  virtual void  v1(); // _ZN8S10326C12v1Ev
  virtual void  v2(); // _ZN8S10326C12v2Ev
  virtual void  v3(); // _ZN8S10326C12v3Ev
  virtual void  v4(); // _ZN8S10326C12v4Ev
  virtual void  v5(); // _ZN8S10326C12v5Ev
  virtual void  v6(); // _ZN8S10326C12v6Ev
  virtual void  v7(); // _ZN8S10326C12v7Ev
  virtual void  v8(); // _ZN8S10326C12v8Ev
  virtual void  v9(); // _ZN8S10326C12v9Ev
  virtual void  v10(); // _ZN8S10326C13v10Ev
  virtual void  v11(); // _ZN8S10326C13v11Ev
  virtual void  v12(); // _ZN8S10326C13v12Ev
  virtual void  v13(); // _ZN8S10326C13v13Ev
  virtual void  v14(); // _ZN8S10326C13v14Ev
  virtual void  v15(); // _ZN8S10326C13v15Ev
  virtual void  v16(); // _ZN8S10326C13v16Ev
  virtual void  v17(); // _ZN8S10326C13v17Ev
  virtual void  v18(); // _ZN8S10326C13v18Ev
  virtual void  v19(); // _ZN8S10326C13v19Ev
  virtual void  v20(); // _ZN8S10326C13v20Ev
  virtual void  v21(); // _ZN8S10326C13v21Ev
  virtual void  v22(); // _ZN8S10326C13v22Ev
  virtual void  v23(); // _ZN8S10326C13v23Ev
  virtual void  v24(); // _ZN8S10326C13v24Ev
  virtual void  v25(); // _ZN8S10326C13v25Ev
  virtual void  v26(); // _ZN8S10326C13v26Ev
  virtual void  v27(); // _ZN8S10326C13v27Ev
  virtual void  v28(); // _ZN8S10326C13v28Ev
  virtual void  v29(); // _ZN8S10326C13v29Ev
  virtual void  v30(); // _ZN8S10326C13v30Ev
  virtual void  v31(); // _ZN8S10326C13v31Ev
  virtual void  v32(); // _ZN8S10326C13v32Ev
  virtual void  v33(); // _ZN8S10326C13v33Ev
  virtual void  v34(); // _ZN8S10326C13v34Ev
  virtual void  v35(); // _ZN8S10326C13v35Ev
  virtual void  v36(); // _ZN8S10326C13v36Ev
  virtual void  v37(); // _ZN8S10326C13v37Ev
  virtual void  v38(); // _ZN8S10326C13v38Ev
  virtual void  v39(); // _ZN8S10326C13v39Ev
  virtual void  v40(); // _ZN8S10326C13v40Ev
  virtual void  v41(); // _ZN8S10326C13v41Ev
  virtual void  v42(); // _ZN8S10326C13v42Ev
  virtual void  v43(); // _ZN8S10326C13v43Ev
  virtual void  v44(); // _ZN8S10326C13v44Ev
  virtual void  v45(); // _ZN8S10326C13v45Ev
  virtual void  v46(); // _ZN8S10326C13v46Ev
  virtual void  v47(); // _ZN8S10326C13v47Ev
  virtual void  v48(); // _ZN8S10326C13v48Ev
  virtual void  v49(); // _ZN8S10326C13v49Ev
  virtual void  v50(); // _ZN8S10326C13v50Ev
  virtual void  v51(); // _ZN8S10326C13v51Ev
  virtual void  v52(); // _ZN8S10326C13v52Ev
  virtual void  v53(); // _ZN8S10326C13v53Ev
  virtual void  v54(); // _ZN8S10326C13v54Ev
  virtual void  v55(); // _ZN8S10326C13v55Ev
  virtual void  v56(); // _ZN8S10326C13v56Ev
  virtual void  v57(); // _ZN8S10326C13v57Ev
  virtual void  v58(); // _ZN8S10326C13v58Ev
  virtual void  v59(); // _ZN8S10326C13v59Ev
  virtual void  v60(); // _ZN8S10326C13v60Ev
  virtual void  v61(); // _ZN8S10326C13v61Ev
  virtual void  v62(); // _ZN8S10326C13v62Ev
  virtual void  v63(); // _ZN8S10326C13v63Ev
  virtual void  v64(); // _ZN8S10326C13v64Ev
  virtual void  v65(); // _ZN8S10326C13v65Ev
  virtual void  v66(); // _ZN8S10326C13v66Ev
  virtual void  v67(); // _ZN8S10326C13v67Ev
  virtual void  v68(); // _ZN8S10326C13v68Ev
  virtual void  v69(); // _ZN8S10326C13v69Ev
  virtual void  v70(); // _ZN8S10326C13v70Ev
  virtual void  v71(); // _ZN8S10326C13v71Ev
  virtual void  v72(); // _ZN8S10326C13v72Ev
  virtual void  v73(); // _ZN8S10326C13v73Ev
  virtual void  v74(); // _ZN8S10326C13v74Ev
  virtual void  v75(); // _ZN8S10326C13v75Ev
  virtual void  v76(); // _ZN8S10326C13v76Ev
  virtual void  v77(); // _ZN8S10326C13v77Ev
  virtual void  v78(); // _ZN8S10326C13v78Ev
  virtual void  v79(); // _ZN8S10326C13v79Ev
  virtual void  v80(); // _ZN8S10326C13v80Ev
  virtual void  v81(); // _ZN8S10326C13v81Ev
  virtual void  v82(); // _ZN8S10326C13v82Ev
  virtual void  v83(); // _ZN8S10326C13v83Ev
  virtual void  v84(); // _ZN8S10326C13v84Ev
  virtual void  v85(); // _ZN8S10326C13v85Ev
  virtual void  v86(); // _ZN8S10326C13v86Ev
  virtual void  v87(); // _ZN8S10326C13v87Ev
  virtual void  v88(); // _ZN8S10326C13v88Ev
  virtual void  v89(); // _ZN8S10326C13v89Ev
  virtual void  v90(); // _ZN8S10326C13v90Ev
  virtual void  v91(); // _ZN8S10326C13v91Ev
  virtual void  v92(); // _ZN8S10326C13v92Ev
  virtual void  v93(); // _ZN8S10326C13v93Ev
  virtual void  v94(); // _ZN8S10326C13v94Ev
  virtual void  v95(); // _ZN8S10326C13v95Ev
  virtual void  v96(); // _ZN8S10326C13v96Ev
  virtual void  v97(); // _ZN8S10326C13v97Ev
  S10326C1(); // tgen
};
//SIG(1 S10326C1) C1{ BC2{ vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112} BC3{ vd v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192} BC4{ vd v193} BC5{ vd m FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fp[2] FC10{ m FC11{ Fl[4]}} Fp Fi[3] FC12{ m Fp Fi FC9} Fi}


 S10326C1 ::~S10326C1(){ note_dtor("S10326C1", this);}
void  S10326C1 ::v1(){vfunc_called(this, "_ZN8S10326C12v1Ev");}
void  S10326C1 ::v2(){vfunc_called(this, "_ZN8S10326C12v2Ev");}
void  S10326C1 ::v3(){vfunc_called(this, "_ZN8S10326C12v3Ev");}
void  S10326C1 ::v4(){vfunc_called(this, "_ZN8S10326C12v4Ev");}
void  S10326C1 ::v5(){vfunc_called(this, "_ZN8S10326C12v5Ev");}
void  S10326C1 ::v6(){vfunc_called(this, "_ZN8S10326C12v6Ev");}
void  S10326C1 ::v7(){vfunc_called(this, "_ZN8S10326C12v7Ev");}
void  S10326C1 ::v8(){vfunc_called(this, "_ZN8S10326C12v8Ev");}
void  S10326C1 ::v9(){vfunc_called(this, "_ZN8S10326C12v9Ev");}
void  S10326C1 ::v10(){vfunc_called(this, "_ZN8S10326C13v10Ev");}
void  S10326C1 ::v11(){vfunc_called(this, "_ZN8S10326C13v11Ev");}
void  S10326C1 ::v12(){vfunc_called(this, "_ZN8S10326C13v12Ev");}
void  S10326C1 ::v13(){vfunc_called(this, "_ZN8S10326C13v13Ev");}
void  S10326C1 ::v14(){vfunc_called(this, "_ZN8S10326C13v14Ev");}
void  S10326C1 ::v15(){vfunc_called(this, "_ZN8S10326C13v15Ev");}
void  S10326C1 ::v16(){vfunc_called(this, "_ZN8S10326C13v16Ev");}
void  S10326C1 ::v17(){vfunc_called(this, "_ZN8S10326C13v17Ev");}
void  S10326C1 ::v18(){vfunc_called(this, "_ZN8S10326C13v18Ev");}
void  S10326C1 ::v19(){vfunc_called(this, "_ZN8S10326C13v19Ev");}
void  S10326C1 ::v20(){vfunc_called(this, "_ZN8S10326C13v20Ev");}
void  S10326C1 ::v21(){vfunc_called(this, "_ZN8S10326C13v21Ev");}
void  S10326C1 ::v22(){vfunc_called(this, "_ZN8S10326C13v22Ev");}
void  S10326C1 ::v23(){vfunc_called(this, "_ZN8S10326C13v23Ev");}
void  S10326C1 ::v24(){vfunc_called(this, "_ZN8S10326C13v24Ev");}
void  S10326C1 ::v25(){vfunc_called(this, "_ZN8S10326C13v25Ev");}
void  S10326C1 ::v26(){vfunc_called(this, "_ZN8S10326C13v26Ev");}
void  S10326C1 ::v27(){vfunc_called(this, "_ZN8S10326C13v27Ev");}
void  S10326C1 ::v28(){vfunc_called(this, "_ZN8S10326C13v28Ev");}
void  S10326C1 ::v29(){vfunc_called(this, "_ZN8S10326C13v29Ev");}
void  S10326C1 ::v30(){vfunc_called(this, "_ZN8S10326C13v30Ev");}
void  S10326C1 ::v31(){vfunc_called(this, "_ZN8S10326C13v31Ev");}
void  S10326C1 ::v32(){vfunc_called(this, "_ZN8S10326C13v32Ev");}
void  S10326C1 ::v33(){vfunc_called(this, "_ZN8S10326C13v33Ev");}
void  S10326C1 ::v34(){vfunc_called(this, "_ZN8S10326C13v34Ev");}
void  S10326C1 ::v35(){vfunc_called(this, "_ZN8S10326C13v35Ev");}
void  S10326C1 ::v36(){vfunc_called(this, "_ZN8S10326C13v36Ev");}
void  S10326C1 ::v37(){vfunc_called(this, "_ZN8S10326C13v37Ev");}
void  S10326C1 ::v38(){vfunc_called(this, "_ZN8S10326C13v38Ev");}
void  S10326C1 ::v39(){vfunc_called(this, "_ZN8S10326C13v39Ev");}
void  S10326C1 ::v40(){vfunc_called(this, "_ZN8S10326C13v40Ev");}
void  S10326C1 ::v41(){vfunc_called(this, "_ZN8S10326C13v41Ev");}
void  S10326C1 ::v42(){vfunc_called(this, "_ZN8S10326C13v42Ev");}
void  S10326C1 ::v43(){vfunc_called(this, "_ZN8S10326C13v43Ev");}
void  S10326C1 ::v44(){vfunc_called(this, "_ZN8S10326C13v44Ev");}
void  S10326C1 ::v45(){vfunc_called(this, "_ZN8S10326C13v45Ev");}
void  S10326C1 ::v46(){vfunc_called(this, "_ZN8S10326C13v46Ev");}
void  S10326C1 ::v47(){vfunc_called(this, "_ZN8S10326C13v47Ev");}
void  S10326C1 ::v48(){vfunc_called(this, "_ZN8S10326C13v48Ev");}
void  S10326C1 ::v49(){vfunc_called(this, "_ZN8S10326C13v49Ev");}
void  S10326C1 ::v50(){vfunc_called(this, "_ZN8S10326C13v50Ev");}
void  S10326C1 ::v51(){vfunc_called(this, "_ZN8S10326C13v51Ev");}
void  S10326C1 ::v52(){vfunc_called(this, "_ZN8S10326C13v52Ev");}
void  S10326C1 ::v53(){vfunc_called(this, "_ZN8S10326C13v53Ev");}
void  S10326C1 ::v54(){vfunc_called(this, "_ZN8S10326C13v54Ev");}
void  S10326C1 ::v55(){vfunc_called(this, "_ZN8S10326C13v55Ev");}
void  S10326C1 ::v56(){vfunc_called(this, "_ZN8S10326C13v56Ev");}
void  S10326C1 ::v57(){vfunc_called(this, "_ZN8S10326C13v57Ev");}
void  S10326C1 ::v58(){vfunc_called(this, "_ZN8S10326C13v58Ev");}
void  S10326C1 ::v59(){vfunc_called(this, "_ZN8S10326C13v59Ev");}
void  S10326C1 ::v60(){vfunc_called(this, "_ZN8S10326C13v60Ev");}
void  S10326C1 ::v61(){vfunc_called(this, "_ZN8S10326C13v61Ev");}
void  S10326C1 ::v62(){vfunc_called(this, "_ZN8S10326C13v62Ev");}
void  S10326C1 ::v63(){vfunc_called(this, "_ZN8S10326C13v63Ev");}
void  S10326C1 ::v64(){vfunc_called(this, "_ZN8S10326C13v64Ev");}
void  S10326C1 ::v65(){vfunc_called(this, "_ZN8S10326C13v65Ev");}
void  S10326C1 ::v66(){vfunc_called(this, "_ZN8S10326C13v66Ev");}
void  S10326C1 ::v67(){vfunc_called(this, "_ZN8S10326C13v67Ev");}
void  S10326C1 ::v68(){vfunc_called(this, "_ZN8S10326C13v68Ev");}
void  S10326C1 ::v69(){vfunc_called(this, "_ZN8S10326C13v69Ev");}
void  S10326C1 ::v70(){vfunc_called(this, "_ZN8S10326C13v70Ev");}
void  S10326C1 ::v71(){vfunc_called(this, "_ZN8S10326C13v71Ev");}
void  S10326C1 ::v72(){vfunc_called(this, "_ZN8S10326C13v72Ev");}
void  S10326C1 ::v73(){vfunc_called(this, "_ZN8S10326C13v73Ev");}
void  S10326C1 ::v74(){vfunc_called(this, "_ZN8S10326C13v74Ev");}
void  S10326C1 ::v75(){vfunc_called(this, "_ZN8S10326C13v75Ev");}
void  S10326C1 ::v76(){vfunc_called(this, "_ZN8S10326C13v76Ev");}
void  S10326C1 ::v77(){vfunc_called(this, "_ZN8S10326C13v77Ev");}
void  S10326C1 ::v78(){vfunc_called(this, "_ZN8S10326C13v78Ev");}
void  S10326C1 ::v79(){vfunc_called(this, "_ZN8S10326C13v79Ev");}
void  S10326C1 ::v80(){vfunc_called(this, "_ZN8S10326C13v80Ev");}
void  S10326C1 ::v81(){vfunc_called(this, "_ZN8S10326C13v81Ev");}
void  S10326C1 ::v82(){vfunc_called(this, "_ZN8S10326C13v82Ev");}
void  S10326C1 ::v83(){vfunc_called(this, "_ZN8S10326C13v83Ev");}
void  S10326C1 ::v84(){vfunc_called(this, "_ZN8S10326C13v84Ev");}
void  S10326C1 ::v85(){vfunc_called(this, "_ZN8S10326C13v85Ev");}
void  S10326C1 ::v86(){vfunc_called(this, "_ZN8S10326C13v86Ev");}
void  S10326C1 ::v87(){vfunc_called(this, "_ZN8S10326C13v87Ev");}
void  S10326C1 ::v88(){vfunc_called(this, "_ZN8S10326C13v88Ev");}
void  S10326C1 ::v89(){vfunc_called(this, "_ZN8S10326C13v89Ev");}
void  S10326C1 ::v90(){vfunc_called(this, "_ZN8S10326C13v90Ev");}
void  S10326C1 ::v91(){vfunc_called(this, "_ZN8S10326C13v91Ev");}
void  S10326C1 ::v92(){vfunc_called(this, "_ZN8S10326C13v92Ev");}
void  S10326C1 ::v93(){vfunc_called(this, "_ZN8S10326C13v93Ev");}
void  S10326C1 ::v94(){vfunc_called(this, "_ZN8S10326C13v94Ev");}
void  S10326C1 ::v95(){vfunc_called(this, "_ZN8S10326C13v95Ev");}
void  S10326C1 ::v96(){vfunc_called(this, "_ZN8S10326C13v96Ev");}
void  S10326C1 ::v97(){vfunc_called(this, "_ZN8S10326C13v97Ev");}
S10326C1 ::S10326C1(){ note_ctor("S10326C1", this);} // tgen

static void Test_S10326C1()
{
  extern Class_Descriptor cd_S10326C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,22)];
    init_test(&cd_S10326C1, buf);
    S10326C1 *dp, &lv = *(dp=new (buf) S10326C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,84), "sizeof(S10326C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10326C1)");
    check_base_class_offset(lv, (S10326C2*), 0, "S10326C1");
    check_base_class_offset(lv, (S10326C3*), ABISELECT(8,4), "S10326C1");
    check_base_class_offset(lv, (S10326C4*), ABISELECT(16,8), "S10326C1");
    check_base_class_offset(lv, (S4216C11*), ABISELECT(24,12), "S10326C1");
    check_field_offset(lv, s10326c1f0, ABISELECT(48,28), "S10326C1.s10326c1f0");
    check_field_offset(lv, s10326c1f1, ABISELECT(64,36), "S10326C1.s10326c1f1");
    check_field_offset(lv, s10326c1f2, ABISELECT(96,52), "S10326C1.s10326c1f2");
    check_field_offset(lv, s10326c1f3, ABISELECT(104,56), "S10326C1.s10326c1f3");
    check_field_offset(lv, s10326c1f4, ABISELECT(120,68), "S10326C1.s10326c1f4");
    check_field_offset(lv, s10326c1f5, ABISELECT(136,80), "S10326C1.s10326c1f5");
    test_class_info(&lv, &cd_S10326C1);
    dp->~S10326C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10326C1(Test_S10326C1, "S10326C1", ABISELECT(144,84));

#else // __cplusplus

extern void _ZN8S10326C1C1Ev();
extern void _ZN8S10326C1D1Ev();
Name_Map name_map_S10326C1[] = {
  NSPAIR(_ZN8S10326C1C1Ev),
  NSPAIR(_ZN8S10326C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10326C2;
extern VTBL_ENTRY _ZTI8S10326C2[];
extern  VTBL_ENTRY _ZTV8S10326C2[];
extern Class_Descriptor cd_S10326C3;
extern VTBL_ENTRY _ZTI8S10326C3[];
extern  VTBL_ENTRY _ZTV8S10326C3[];
extern Class_Descriptor cd_S10326C4;
extern VTBL_ENTRY _ZTI8S10326C4[];
extern  VTBL_ENTRY _ZTV8S10326C4[];
extern Class_Descriptor cd_S4216C11;
extern VTBL_ENTRY _ZTI8S4216C11[];
extern  VTBL_ENTRY _ZTV8S4216C11[];
static Base_Class bases_S10326C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10326C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10326C3,    ABISELECT(8,4), //bcp->offset
    116, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10326C4,    ABISELECT(16,8), //bcp->offset
    200, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C11,    ABISELECT(24,12), //bcp->offset
    205, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10326C1[];
extern void _ZN8S10326C1D1Ev();
extern void _ZN8S10326C1D0Ev();
extern void _ZN8S10326C23v98Ev();
extern void _ZN8S10326C23v99Ev();
extern void _ZN8S10326C24v100Ev();
extern void _ZN8S10326C24v101Ev();
extern void _ZN8S10326C24v102Ev();
extern void _ZN8S10326C24v103Ev();
extern void _ZN8S10326C24v104Ev();
extern void _ZN8S10326C24v105Ev();
extern void _ZN8S10326C24v106Ev();
extern void _ZN8S10326C24v107Ev();
extern void _ZN8S10326C24v108Ev();
extern void _ZN8S10326C24v109Ev();
extern void _ZN8S10326C24v110Ev();
extern void _ZN8S10326C24v111Ev();
extern void _ZN8S10326C24v112Ev();
extern void _ZN8S10326C12v1Ev();
extern void _ZN8S10326C12v2Ev();
extern void _ZN8S10326C12v3Ev();
extern void _ZN8S10326C12v4Ev();
extern void _ZN8S10326C12v5Ev();
extern void _ZN8S10326C12v6Ev();
extern void _ZN8S10326C12v7Ev();
extern void _ZN8S10326C12v8Ev();
extern void _ZN8S10326C12v9Ev();
extern void _ZN8S10326C13v10Ev();
extern void _ZN8S10326C13v11Ev();
extern void _ZN8S10326C13v12Ev();
extern void _ZN8S10326C13v13Ev();
extern void _ZN8S10326C13v14Ev();
extern void _ZN8S10326C13v15Ev();
extern void _ZN8S10326C13v16Ev();
extern void _ZN8S10326C13v17Ev();
extern void _ZN8S10326C13v18Ev();
extern void _ZN8S10326C13v19Ev();
extern void _ZN8S10326C13v20Ev();
extern void _ZN8S10326C13v21Ev();
extern void _ZN8S10326C13v22Ev();
extern void _ZN8S10326C13v23Ev();
extern void _ZN8S10326C13v24Ev();
extern void _ZN8S10326C13v25Ev();
extern void _ZN8S10326C13v26Ev();
extern void _ZN8S10326C13v27Ev();
extern void _ZN8S10326C13v28Ev();
extern void _ZN8S10326C13v29Ev();
extern void _ZN8S10326C13v30Ev();
extern void _ZN8S10326C13v31Ev();
extern void _ZN8S10326C13v32Ev();
extern void _ZN8S10326C13v33Ev();
extern void _ZN8S10326C13v34Ev();
extern void _ZN8S10326C13v35Ev();
extern void _ZN8S10326C13v36Ev();
extern void _ZN8S10326C13v37Ev();
extern void _ZN8S10326C13v38Ev();
extern void _ZN8S10326C13v39Ev();
extern void _ZN8S10326C13v40Ev();
extern void _ZN8S10326C13v41Ev();
extern void _ZN8S10326C13v42Ev();
extern void _ZN8S10326C13v43Ev();
extern void _ZN8S10326C13v44Ev();
extern void _ZN8S10326C13v45Ev();
extern void _ZN8S10326C13v46Ev();
extern void _ZN8S10326C13v47Ev();
extern void _ZN8S10326C13v48Ev();
extern void _ZN8S10326C13v49Ev();
extern void _ZN8S10326C13v50Ev();
extern void _ZN8S10326C13v51Ev();
extern void _ZN8S10326C13v52Ev();
extern void _ZN8S10326C13v53Ev();
extern void _ZN8S10326C13v54Ev();
extern void _ZN8S10326C13v55Ev();
extern void _ZN8S10326C13v56Ev();
extern void _ZN8S10326C13v57Ev();
extern void _ZN8S10326C13v58Ev();
extern void _ZN8S10326C13v59Ev();
extern void _ZN8S10326C13v60Ev();
extern void _ZN8S10326C13v61Ev();
extern void _ZN8S10326C13v62Ev();
extern void _ZN8S10326C13v63Ev();
extern void _ZN8S10326C13v64Ev();
extern void _ZN8S10326C13v65Ev();
extern void _ZN8S10326C13v66Ev();
extern void _ZN8S10326C13v67Ev();
extern void _ZN8S10326C13v68Ev();
extern void _ZN8S10326C13v69Ev();
extern void _ZN8S10326C13v70Ev();
extern void _ZN8S10326C13v71Ev();
extern void _ZN8S10326C13v72Ev();
extern void _ZN8S10326C13v73Ev();
extern void _ZN8S10326C13v74Ev();
extern void _ZN8S10326C13v75Ev();
extern void _ZN8S10326C13v76Ev();
extern void _ZN8S10326C13v77Ev();
extern void _ZN8S10326C13v78Ev();
extern void _ZN8S10326C13v79Ev();
extern void _ZN8S10326C13v80Ev();
extern void _ZN8S10326C13v81Ev();
extern void _ZN8S10326C13v82Ev();
extern void _ZN8S10326C13v83Ev();
extern void _ZN8S10326C13v84Ev();
extern void _ZN8S10326C13v85Ev();
extern void _ZN8S10326C13v86Ev();
extern void _ZN8S10326C13v87Ev();
extern void _ZN8S10326C13v88Ev();
extern void _ZN8S10326C13v89Ev();
extern void _ZN8S10326C13v90Ev();
extern void _ZN8S10326C13v91Ev();
extern void _ZN8S10326C13v92Ev();
extern void _ZN8S10326C13v93Ev();
extern void _ZN8S10326C13v94Ev();
extern void _ZN8S10326C13v95Ev();
extern void _ZN8S10326C13v96Ev();
extern void _ZN8S10326C13v97Ev();
extern void ABISELECT(_ZThn8_N8S10326C1D1Ev,_ZThn4_N8S10326C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10326C1D0Ev,_ZThn4_N8S10326C1D0Ev)();
extern void _ZN8S10326C34v113Ev();
extern void _ZN8S10326C34v114Ev();
extern void _ZN8S10326C34v115Ev();
extern void _ZN8S10326C34v116Ev();
extern void _ZN8S10326C34v117Ev();
extern void _ZN8S10326C34v118Ev();
extern void _ZN8S10326C34v119Ev();
extern void _ZN8S10326C34v120Ev();
extern void _ZN8S10326C34v121Ev();
extern void _ZN8S10326C34v122Ev();
extern void _ZN8S10326C34v123Ev();
extern void _ZN8S10326C34v124Ev();
extern void _ZN8S10326C34v125Ev();
extern void _ZN8S10326C34v126Ev();
extern void _ZN8S10326C34v127Ev();
extern void _ZN8S10326C34v128Ev();
extern void _ZN8S10326C34v129Ev();
extern void _ZN8S10326C34v130Ev();
extern void _ZN8S10326C34v131Ev();
extern void _ZN8S10326C34v132Ev();
extern void _ZN8S10326C34v133Ev();
extern void _ZN8S10326C34v134Ev();
extern void _ZN8S10326C34v135Ev();
extern void _ZN8S10326C34v136Ev();
extern void _ZN8S10326C34v137Ev();
extern void _ZN8S10326C34v138Ev();
extern void _ZN8S10326C34v139Ev();
extern void _ZN8S10326C34v140Ev();
extern void _ZN8S10326C34v141Ev();
extern void _ZN8S10326C34v142Ev();
extern void _ZN8S10326C34v143Ev();
extern void _ZN8S10326C34v144Ev();
extern void _ZN8S10326C34v145Ev();
extern void _ZN8S10326C34v146Ev();
extern void _ZN8S10326C34v147Ev();
extern void _ZN8S10326C34v148Ev();
extern void _ZN8S10326C34v149Ev();
extern void _ZN8S10326C34v150Ev();
extern void _ZN8S10326C34v151Ev();
extern void _ZN8S10326C34v152Ev();
extern void _ZN8S10326C34v153Ev();
extern void _ZN8S10326C34v154Ev();
extern void _ZN8S10326C34v155Ev();
extern void _ZN8S10326C34v156Ev();
extern void _ZN8S10326C34v157Ev();
extern void _ZN8S10326C34v158Ev();
extern void _ZN8S10326C34v159Ev();
extern void _ZN8S10326C34v160Ev();
extern void _ZN8S10326C34v161Ev();
extern void _ZN8S10326C34v162Ev();
extern void _ZN8S10326C34v163Ev();
extern void _ZN8S10326C34v164Ev();
extern void _ZN8S10326C34v165Ev();
extern void _ZN8S10326C34v166Ev();
extern void _ZN8S10326C34v167Ev();
extern void _ZN8S10326C34v168Ev();
extern void _ZN8S10326C34v169Ev();
extern void _ZN8S10326C34v170Ev();
extern void _ZN8S10326C34v171Ev();
extern void _ZN8S10326C34v172Ev();
extern void _ZN8S10326C34v173Ev();
extern void _ZN8S10326C34v174Ev();
extern void _ZN8S10326C34v175Ev();
extern void _ZN8S10326C34v176Ev();
extern void _ZN8S10326C34v177Ev();
extern void _ZN8S10326C34v178Ev();
extern void _ZN8S10326C34v179Ev();
extern void _ZN8S10326C34v180Ev();
extern void _ZN8S10326C34v181Ev();
extern void _ZN8S10326C34v182Ev();
extern void _ZN8S10326C34v183Ev();
extern void _ZN8S10326C34v184Ev();
extern void _ZN8S10326C34v185Ev();
extern void _ZN8S10326C34v186Ev();
extern void _ZN8S10326C34v187Ev();
extern void _ZN8S10326C34v188Ev();
extern void _ZN8S10326C34v189Ev();
extern void _ZN8S10326C34v190Ev();
extern void _ZN8S10326C34v191Ev();
extern void _ZN8S10326C34v192Ev();
extern void ABISELECT(_ZThn16_N8S10326C1D1Ev,_ZThn8_N8S10326C1D1Ev)();
extern void ABISELECT(_ZThn16_N8S10326C1D0Ev,_ZThn8_N8S10326C1D0Ev)();
extern void _ZN8S10326C44v193Ev();
extern void ABISELECT(_ZThn24_N8S10326C1D1Ev,_ZThn12_N8S10326C1D1Ev)();
extern void ABISELECT(_ZThn24_N8S10326C1D0Ev,_ZThn12_N8S10326C1D0Ev)();
static  VTBL_ENTRY vtc_S10326C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10326C1[0]),
  (VTBL_ENTRY)&_ZN8S10326C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10326C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10326C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10326C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10326C24v112Ev,
  (VTBL_ENTRY)&_ZN8S10326C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10326C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10326C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10326C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10326C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10326C12v6Ev,
  (VTBL_ENTRY)&_ZN8S10326C12v7Ev,
  (VTBL_ENTRY)&_ZN8S10326C12v8Ev,
  (VTBL_ENTRY)&_ZN8S10326C12v9Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v10Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v11Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v12Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v13Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v14Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v15Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v16Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v17Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v18Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v19Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v20Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v21Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v22Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v23Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v24Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v25Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v26Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v27Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v28Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v29Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v30Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v31Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v32Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v33Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v34Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v35Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v36Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v37Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v38Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v39Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v40Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v41Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v42Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v43Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v44Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v45Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v46Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v47Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v48Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v49Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v50Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v51Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v52Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v53Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v54Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v55Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v56Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v57Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v58Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v59Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v60Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v61Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v62Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v63Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v64Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v65Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v66Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v67Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v68Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v69Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v70Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v71Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v72Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v73Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v74Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v75Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v76Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v77Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v78Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v79Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v80Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v81Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v82Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v83Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v84Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v85Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v86Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v87Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v88Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v89Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v90Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v91Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v92Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v93Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v94Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v95Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v96Ev,
  (VTBL_ENTRY)&_ZN8S10326C13v97Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10326C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10326C1D1Ev,_ZThn4_N8S10326C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10326C1D0Ev,_ZThn4_N8S10326C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10326C34v113Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v114Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v115Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v116Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v117Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v118Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v119Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v120Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v121Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v122Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v123Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v124Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v125Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v126Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v127Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v128Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v129Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v130Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v131Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v132Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v133Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v134Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v135Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v136Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v137Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v138Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v139Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v140Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v141Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v142Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v143Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v144Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v145Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v146Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v147Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v148Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v149Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v150Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v151Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v152Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v153Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v154Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v155Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v156Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v157Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v158Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v159Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v160Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v161Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v162Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v163Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v164Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v165Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v166Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v167Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v168Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v169Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v170Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v171Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v172Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v173Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v174Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v175Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v176Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v177Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v178Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v179Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v180Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v181Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v182Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v183Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v184Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v185Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v186Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v187Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v188Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v189Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v190Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v191Ev,
  (VTBL_ENTRY)&_ZN8S10326C34v192Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S10326C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S10326C1D1Ev,_ZThn8_N8S10326C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S10326C1D0Ev,_ZThn8_N8S10326C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10326C44v193Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S10326C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S10326C1D1Ev,_ZThn12_N8S10326C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S10326C1D0Ev,_ZThn12_N8S10326C1D0Ev),
};
extern VTBL_ENTRY _ZTI8S10326C1[];
extern  VTBL_ENTRY _ZTV8S10326C1[];
Class_Descriptor cd_S10326C1 = {  "S10326C1", // class name
  bases_S10326C1, 4,
  &(vtc_S10326C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,84), // object size
  NSPAIRA(_ZTI8S10326C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S10326C1),209, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10328C2  {
  virtual  ~S10328C2(); // _ZN8S10328C2D1Ev
  virtual void  v98(); // _ZN8S10328C23v98Ev
  virtual void  v99(); // _ZN8S10328C23v99Ev
  virtual void  v100(); // _ZN8S10328C24v100Ev
  virtual void  v101(); // _ZN8S10328C24v101Ev
  virtual void  v102(); // _ZN8S10328C24v102Ev
  virtual void  v103(); // _ZN8S10328C24v103Ev
  virtual void  v104(); // _ZN8S10328C24v104Ev
  virtual void  v105(); // _ZN8S10328C24v105Ev
  virtual void  v106(); // _ZN8S10328C24v106Ev
  virtual void  v107(); // _ZN8S10328C24v107Ev
  virtual void  v108(); // _ZN8S10328C24v108Ev
  virtual void  v109(); // _ZN8S10328C24v109Ev
  virtual void  v110(); // _ZN8S10328C24v110Ev
  virtual void  v111(); // _ZN8S10328C24v111Ev
  virtual void  v112(); // _ZN8S10328C24v112Ev
  S10328C2(); // tgen
};
//SIG(-1 S10328C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15}


 S10328C2 ::~S10328C2(){ note_dtor("S10328C2", this);}
void  S10328C2 ::v98(){vfunc_called(this, "_ZN8S10328C23v98Ev");}
void  S10328C2 ::v99(){vfunc_called(this, "_ZN8S10328C23v99Ev");}
void  S10328C2 ::v100(){vfunc_called(this, "_ZN8S10328C24v100Ev");}
void  S10328C2 ::v101(){vfunc_called(this, "_ZN8S10328C24v101Ev");}
void  S10328C2 ::v102(){vfunc_called(this, "_ZN8S10328C24v102Ev");}
void  S10328C2 ::v103(){vfunc_called(this, "_ZN8S10328C24v103Ev");}
void  S10328C2 ::v104(){vfunc_called(this, "_ZN8S10328C24v104Ev");}
void  S10328C2 ::v105(){vfunc_called(this, "_ZN8S10328C24v105Ev");}
void  S10328C2 ::v106(){vfunc_called(this, "_ZN8S10328C24v106Ev");}
void  S10328C2 ::v107(){vfunc_called(this, "_ZN8S10328C24v107Ev");}
void  S10328C2 ::v108(){vfunc_called(this, "_ZN8S10328C24v108Ev");}
void  S10328C2 ::v109(){vfunc_called(this, "_ZN8S10328C24v109Ev");}
void  S10328C2 ::v110(){vfunc_called(this, "_ZN8S10328C24v110Ev");}
void  S10328C2 ::v111(){vfunc_called(this, "_ZN8S10328C24v111Ev");}
void  S10328C2 ::v112(){vfunc_called(this, "_ZN8S10328C24v112Ev");}
S10328C2 ::S10328C2(){ note_ctor("S10328C2", this);} // tgen

static void Test_S10328C2()
{
  extern Class_Descriptor cd_S10328C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10328C2, buf);
    S10328C2 *dp, &lv = *(dp=new (buf) S10328C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10328C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10328C2)");
    test_class_info(&lv, &cd_S10328C2);
    dp->~S10328C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10328C2(Test_S10328C2, "S10328C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10328C2C1Ev();
extern void _ZN8S10328C2D1Ev();
Name_Map name_map_S10328C2[] = {
  NSPAIR(_ZN8S10328C2C1Ev),
  NSPAIR(_ZN8S10328C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10328C2[];
extern void _ZN8S10328C2D1Ev();
extern void _ZN8S10328C2D0Ev();
extern void _ZN8S10328C23v98Ev();
extern void _ZN8S10328C23v99Ev();
extern void _ZN8S10328C24v100Ev();
extern void _ZN8S10328C24v101Ev();
extern void _ZN8S10328C24v102Ev();
extern void _ZN8S10328C24v103Ev();
extern void _ZN8S10328C24v104Ev();
extern void _ZN8S10328C24v105Ev();
extern void _ZN8S10328C24v106Ev();
extern void _ZN8S10328C24v107Ev();
extern void _ZN8S10328C24v108Ev();
extern void _ZN8S10328C24v109Ev();
extern void _ZN8S10328C24v110Ev();
extern void _ZN8S10328C24v111Ev();
extern void _ZN8S10328C24v112Ev();
static  VTBL_ENTRY vtc_S10328C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10328C2[0]),
  (VTBL_ENTRY)&_ZN8S10328C2D1Ev,
  (VTBL_ENTRY)&_ZN8S10328C2D0Ev,
  (VTBL_ENTRY)&_ZN8S10328C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10328C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v112Ev,
};
extern VTBL_ENTRY _ZTI8S10328C2[];
extern  VTBL_ENTRY _ZTV8S10328C2[];
Class_Descriptor cd_S10328C2 = {  "S10328C2", // class name
  0,0,//no base classes
  &(vtc_S10328C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10328C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10328C2),19, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10328C3  {
  virtual  ~S10328C3(); // _ZN8S10328C3D1Ev
  virtual void  v113(); // _ZN8S10328C34v113Ev
  virtual void  v114(); // _ZN8S10328C34v114Ev
  virtual void  v115(); // _ZN8S10328C34v115Ev
  virtual void  v116(); // _ZN8S10328C34v116Ev
  virtual void  v117(); // _ZN8S10328C34v117Ev
  virtual void  v118(); // _ZN8S10328C34v118Ev
  virtual void  v119(); // _ZN8S10328C34v119Ev
  virtual void  v120(); // _ZN8S10328C34v120Ev
  virtual void  v121(); // _ZN8S10328C34v121Ev
  virtual void  v122(); // _ZN8S10328C34v122Ev
  virtual void  v123(); // _ZN8S10328C34v123Ev
  virtual void  v124(); // _ZN8S10328C34v124Ev
  virtual void  v125(); // _ZN8S10328C34v125Ev
  virtual void  v126(); // _ZN8S10328C34v126Ev
  virtual void  v127(); // _ZN8S10328C34v127Ev
  virtual void  v128(); // _ZN8S10328C34v128Ev
  virtual void  v129(); // _ZN8S10328C34v129Ev
  virtual void  v130(); // _ZN8S10328C34v130Ev
  virtual void  v131(); // _ZN8S10328C34v131Ev
  virtual void  v132(); // _ZN8S10328C34v132Ev
  virtual void  v133(); // _ZN8S10328C34v133Ev
  virtual void  v134(); // _ZN8S10328C34v134Ev
  virtual void  v135(); // _ZN8S10328C34v135Ev
  virtual void  v136(); // _ZN8S10328C34v136Ev
  virtual void  v137(); // _ZN8S10328C34v137Ev
  virtual void  v138(); // _ZN8S10328C34v138Ev
  virtual void  v139(); // _ZN8S10328C34v139Ev
  virtual void  v140(); // _ZN8S10328C34v140Ev
  virtual void  v141(); // _ZN8S10328C34v141Ev
  virtual void  v142(); // _ZN8S10328C34v142Ev
  virtual void  v143(); // _ZN8S10328C34v143Ev
  virtual void  v144(); // _ZN8S10328C34v144Ev
  virtual void  v145(); // _ZN8S10328C34v145Ev
  virtual void  v146(); // _ZN8S10328C34v146Ev
  virtual void  v147(); // _ZN8S10328C34v147Ev
  virtual void  v148(); // _ZN8S10328C34v148Ev
  virtual void  v149(); // _ZN8S10328C34v149Ev
  virtual void  v150(); // _ZN8S10328C34v150Ev
  virtual void  v151(); // _ZN8S10328C34v151Ev
  virtual void  v152(); // _ZN8S10328C34v152Ev
  virtual void  v153(); // _ZN8S10328C34v153Ev
  virtual void  v154(); // _ZN8S10328C34v154Ev
  virtual void  v155(); // _ZN8S10328C34v155Ev
  virtual void  v156(); // _ZN8S10328C34v156Ev
  virtual void  v157(); // _ZN8S10328C34v157Ev
  virtual void  v158(); // _ZN8S10328C34v158Ev
  virtual void  v159(); // _ZN8S10328C34v159Ev
  virtual void  v160(); // _ZN8S10328C34v160Ev
  virtual void  v161(); // _ZN8S10328C34v161Ev
  virtual void  v162(); // _ZN8S10328C34v162Ev
  virtual void  v163(); // _ZN8S10328C34v163Ev
  virtual void  v164(); // _ZN8S10328C34v164Ev
  virtual void  v165(); // _ZN8S10328C34v165Ev
  virtual void  v166(); // _ZN8S10328C34v166Ev
  virtual void  v167(); // _ZN8S10328C34v167Ev
  virtual void  v168(); // _ZN8S10328C34v168Ev
  virtual void  v169(); // _ZN8S10328C34v169Ev
  virtual void  v170(); // _ZN8S10328C34v170Ev
  virtual void  v171(); // _ZN8S10328C34v171Ev
  virtual void  v172(); // _ZN8S10328C34v172Ev
  virtual void  v173(); // _ZN8S10328C34v173Ev
  virtual void  v174(); // _ZN8S10328C34v174Ev
  virtual void  v175(); // _ZN8S10328C34v175Ev
  virtual void  v176(); // _ZN8S10328C34v176Ev
  virtual void  v177(); // _ZN8S10328C34v177Ev
  virtual void  v178(); // _ZN8S10328C34v178Ev
  virtual void  v179(); // _ZN8S10328C34v179Ev
  virtual void  v180(); // _ZN8S10328C34v180Ev
  virtual void  v181(); // _ZN8S10328C34v181Ev
  virtual void  v182(); // _ZN8S10328C34v182Ev
  virtual void  v183(); // _ZN8S10328C34v183Ev
  virtual void  v184(); // _ZN8S10328C34v184Ev
  virtual void  v185(); // _ZN8S10328C34v185Ev
  virtual void  v186(); // _ZN8S10328C34v186Ev
  virtual void  v187(); // _ZN8S10328C34v187Ev
  virtual void  v188(); // _ZN8S10328C34v188Ev
  virtual void  v189(); // _ZN8S10328C34v189Ev
  virtual void  v190(); // _ZN8S10328C34v190Ev
  virtual void  v191(); // _ZN8S10328C34v191Ev
  virtual void  v192(); // _ZN8S10328C34v192Ev
  S10328C3(); // tgen
};
//SIG(-1 S10328C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80}


 S10328C3 ::~S10328C3(){ note_dtor("S10328C3", this);}
void  S10328C3 ::v113(){vfunc_called(this, "_ZN8S10328C34v113Ev");}
void  S10328C3 ::v114(){vfunc_called(this, "_ZN8S10328C34v114Ev");}
void  S10328C3 ::v115(){vfunc_called(this, "_ZN8S10328C34v115Ev");}
void  S10328C3 ::v116(){vfunc_called(this, "_ZN8S10328C34v116Ev");}
void  S10328C3 ::v117(){vfunc_called(this, "_ZN8S10328C34v117Ev");}
void  S10328C3 ::v118(){vfunc_called(this, "_ZN8S10328C34v118Ev");}
void  S10328C3 ::v119(){vfunc_called(this, "_ZN8S10328C34v119Ev");}
void  S10328C3 ::v120(){vfunc_called(this, "_ZN8S10328C34v120Ev");}
void  S10328C3 ::v121(){vfunc_called(this, "_ZN8S10328C34v121Ev");}
void  S10328C3 ::v122(){vfunc_called(this, "_ZN8S10328C34v122Ev");}
void  S10328C3 ::v123(){vfunc_called(this, "_ZN8S10328C34v123Ev");}
void  S10328C3 ::v124(){vfunc_called(this, "_ZN8S10328C34v124Ev");}
void  S10328C3 ::v125(){vfunc_called(this, "_ZN8S10328C34v125Ev");}
void  S10328C3 ::v126(){vfunc_called(this, "_ZN8S10328C34v126Ev");}
void  S10328C3 ::v127(){vfunc_called(this, "_ZN8S10328C34v127Ev");}
void  S10328C3 ::v128(){vfunc_called(this, "_ZN8S10328C34v128Ev");}
void  S10328C3 ::v129(){vfunc_called(this, "_ZN8S10328C34v129Ev");}
void  S10328C3 ::v130(){vfunc_called(this, "_ZN8S10328C34v130Ev");}
void  S10328C3 ::v131(){vfunc_called(this, "_ZN8S10328C34v131Ev");}
void  S10328C3 ::v132(){vfunc_called(this, "_ZN8S10328C34v132Ev");}
void  S10328C3 ::v133(){vfunc_called(this, "_ZN8S10328C34v133Ev");}
void  S10328C3 ::v134(){vfunc_called(this, "_ZN8S10328C34v134Ev");}
void  S10328C3 ::v135(){vfunc_called(this, "_ZN8S10328C34v135Ev");}
void  S10328C3 ::v136(){vfunc_called(this, "_ZN8S10328C34v136Ev");}
void  S10328C3 ::v137(){vfunc_called(this, "_ZN8S10328C34v137Ev");}
void  S10328C3 ::v138(){vfunc_called(this, "_ZN8S10328C34v138Ev");}
void  S10328C3 ::v139(){vfunc_called(this, "_ZN8S10328C34v139Ev");}
void  S10328C3 ::v140(){vfunc_called(this, "_ZN8S10328C34v140Ev");}
void  S10328C3 ::v141(){vfunc_called(this, "_ZN8S10328C34v141Ev");}
void  S10328C3 ::v142(){vfunc_called(this, "_ZN8S10328C34v142Ev");}
void  S10328C3 ::v143(){vfunc_called(this, "_ZN8S10328C34v143Ev");}
void  S10328C3 ::v144(){vfunc_called(this, "_ZN8S10328C34v144Ev");}
void  S10328C3 ::v145(){vfunc_called(this, "_ZN8S10328C34v145Ev");}
void  S10328C3 ::v146(){vfunc_called(this, "_ZN8S10328C34v146Ev");}
void  S10328C3 ::v147(){vfunc_called(this, "_ZN8S10328C34v147Ev");}
void  S10328C3 ::v148(){vfunc_called(this, "_ZN8S10328C34v148Ev");}
void  S10328C3 ::v149(){vfunc_called(this, "_ZN8S10328C34v149Ev");}
void  S10328C3 ::v150(){vfunc_called(this, "_ZN8S10328C34v150Ev");}
void  S10328C3 ::v151(){vfunc_called(this, "_ZN8S10328C34v151Ev");}
void  S10328C3 ::v152(){vfunc_called(this, "_ZN8S10328C34v152Ev");}
void  S10328C3 ::v153(){vfunc_called(this, "_ZN8S10328C34v153Ev");}
void  S10328C3 ::v154(){vfunc_called(this, "_ZN8S10328C34v154Ev");}
void  S10328C3 ::v155(){vfunc_called(this, "_ZN8S10328C34v155Ev");}
void  S10328C3 ::v156(){vfunc_called(this, "_ZN8S10328C34v156Ev");}
void  S10328C3 ::v157(){vfunc_called(this, "_ZN8S10328C34v157Ev");}
void  S10328C3 ::v158(){vfunc_called(this, "_ZN8S10328C34v158Ev");}
void  S10328C3 ::v159(){vfunc_called(this, "_ZN8S10328C34v159Ev");}
void  S10328C3 ::v160(){vfunc_called(this, "_ZN8S10328C34v160Ev");}
void  S10328C3 ::v161(){vfunc_called(this, "_ZN8S10328C34v161Ev");}
void  S10328C3 ::v162(){vfunc_called(this, "_ZN8S10328C34v162Ev");}
void  S10328C3 ::v163(){vfunc_called(this, "_ZN8S10328C34v163Ev");}
void  S10328C3 ::v164(){vfunc_called(this, "_ZN8S10328C34v164Ev");}
void  S10328C3 ::v165(){vfunc_called(this, "_ZN8S10328C34v165Ev");}
void  S10328C3 ::v166(){vfunc_called(this, "_ZN8S10328C34v166Ev");}
void  S10328C3 ::v167(){vfunc_called(this, "_ZN8S10328C34v167Ev");}
void  S10328C3 ::v168(){vfunc_called(this, "_ZN8S10328C34v168Ev");}
void  S10328C3 ::v169(){vfunc_called(this, "_ZN8S10328C34v169Ev");}
void  S10328C3 ::v170(){vfunc_called(this, "_ZN8S10328C34v170Ev");}
void  S10328C3 ::v171(){vfunc_called(this, "_ZN8S10328C34v171Ev");}
void  S10328C3 ::v172(){vfunc_called(this, "_ZN8S10328C34v172Ev");}
void  S10328C3 ::v173(){vfunc_called(this, "_ZN8S10328C34v173Ev");}
void  S10328C3 ::v174(){vfunc_called(this, "_ZN8S10328C34v174Ev");}
void  S10328C3 ::v175(){vfunc_called(this, "_ZN8S10328C34v175Ev");}
void  S10328C3 ::v176(){vfunc_called(this, "_ZN8S10328C34v176Ev");}
void  S10328C3 ::v177(){vfunc_called(this, "_ZN8S10328C34v177Ev");}
void  S10328C3 ::v178(){vfunc_called(this, "_ZN8S10328C34v178Ev");}
void  S10328C3 ::v179(){vfunc_called(this, "_ZN8S10328C34v179Ev");}
void  S10328C3 ::v180(){vfunc_called(this, "_ZN8S10328C34v180Ev");}
void  S10328C3 ::v181(){vfunc_called(this, "_ZN8S10328C34v181Ev");}
void  S10328C3 ::v182(){vfunc_called(this, "_ZN8S10328C34v182Ev");}
void  S10328C3 ::v183(){vfunc_called(this, "_ZN8S10328C34v183Ev");}
void  S10328C3 ::v184(){vfunc_called(this, "_ZN8S10328C34v184Ev");}
void  S10328C3 ::v185(){vfunc_called(this, "_ZN8S10328C34v185Ev");}
void  S10328C3 ::v186(){vfunc_called(this, "_ZN8S10328C34v186Ev");}
void  S10328C3 ::v187(){vfunc_called(this, "_ZN8S10328C34v187Ev");}
void  S10328C3 ::v188(){vfunc_called(this, "_ZN8S10328C34v188Ev");}
void  S10328C3 ::v189(){vfunc_called(this, "_ZN8S10328C34v189Ev");}
void  S10328C3 ::v190(){vfunc_called(this, "_ZN8S10328C34v190Ev");}
void  S10328C3 ::v191(){vfunc_called(this, "_ZN8S10328C34v191Ev");}
void  S10328C3 ::v192(){vfunc_called(this, "_ZN8S10328C34v192Ev");}
S10328C3 ::S10328C3(){ note_ctor("S10328C3", this);} // tgen

static void Test_S10328C3()
{
  extern Class_Descriptor cd_S10328C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10328C3, buf);
    S10328C3 *dp, &lv = *(dp=new (buf) S10328C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10328C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10328C3)");
    test_class_info(&lv, &cd_S10328C3);
    dp->~S10328C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10328C3(Test_S10328C3, "S10328C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10328C3C1Ev();
extern void _ZN8S10328C3D1Ev();
Name_Map name_map_S10328C3[] = {
  NSPAIR(_ZN8S10328C3C1Ev),
  NSPAIR(_ZN8S10328C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10328C3[];
extern void _ZN8S10328C3D1Ev();
extern void _ZN8S10328C3D0Ev();
extern void _ZN8S10328C34v113Ev();
extern void _ZN8S10328C34v114Ev();
extern void _ZN8S10328C34v115Ev();
extern void _ZN8S10328C34v116Ev();
extern void _ZN8S10328C34v117Ev();
extern void _ZN8S10328C34v118Ev();
extern void _ZN8S10328C34v119Ev();
extern void _ZN8S10328C34v120Ev();
extern void _ZN8S10328C34v121Ev();
extern void _ZN8S10328C34v122Ev();
extern void _ZN8S10328C34v123Ev();
extern void _ZN8S10328C34v124Ev();
extern void _ZN8S10328C34v125Ev();
extern void _ZN8S10328C34v126Ev();
extern void _ZN8S10328C34v127Ev();
extern void _ZN8S10328C34v128Ev();
extern void _ZN8S10328C34v129Ev();
extern void _ZN8S10328C34v130Ev();
extern void _ZN8S10328C34v131Ev();
extern void _ZN8S10328C34v132Ev();
extern void _ZN8S10328C34v133Ev();
extern void _ZN8S10328C34v134Ev();
extern void _ZN8S10328C34v135Ev();
extern void _ZN8S10328C34v136Ev();
extern void _ZN8S10328C34v137Ev();
extern void _ZN8S10328C34v138Ev();
extern void _ZN8S10328C34v139Ev();
extern void _ZN8S10328C34v140Ev();
extern void _ZN8S10328C34v141Ev();
extern void _ZN8S10328C34v142Ev();
extern void _ZN8S10328C34v143Ev();
extern void _ZN8S10328C34v144Ev();
extern void _ZN8S10328C34v145Ev();
extern void _ZN8S10328C34v146Ev();
extern void _ZN8S10328C34v147Ev();
extern void _ZN8S10328C34v148Ev();
extern void _ZN8S10328C34v149Ev();
extern void _ZN8S10328C34v150Ev();
extern void _ZN8S10328C34v151Ev();
extern void _ZN8S10328C34v152Ev();
extern void _ZN8S10328C34v153Ev();
extern void _ZN8S10328C34v154Ev();
extern void _ZN8S10328C34v155Ev();
extern void _ZN8S10328C34v156Ev();
extern void _ZN8S10328C34v157Ev();
extern void _ZN8S10328C34v158Ev();
extern void _ZN8S10328C34v159Ev();
extern void _ZN8S10328C34v160Ev();
extern void _ZN8S10328C34v161Ev();
extern void _ZN8S10328C34v162Ev();
extern void _ZN8S10328C34v163Ev();
extern void _ZN8S10328C34v164Ev();
extern void _ZN8S10328C34v165Ev();
extern void _ZN8S10328C34v166Ev();
extern void _ZN8S10328C34v167Ev();
extern void _ZN8S10328C34v168Ev();
extern void _ZN8S10328C34v169Ev();
extern void _ZN8S10328C34v170Ev();
extern void _ZN8S10328C34v171Ev();
extern void _ZN8S10328C34v172Ev();
extern void _ZN8S10328C34v173Ev();
extern void _ZN8S10328C34v174Ev();
extern void _ZN8S10328C34v175Ev();
extern void _ZN8S10328C34v176Ev();
extern void _ZN8S10328C34v177Ev();
extern void _ZN8S10328C34v178Ev();
extern void _ZN8S10328C34v179Ev();
extern void _ZN8S10328C34v180Ev();
extern void _ZN8S10328C34v181Ev();
extern void _ZN8S10328C34v182Ev();
extern void _ZN8S10328C34v183Ev();
extern void _ZN8S10328C34v184Ev();
extern void _ZN8S10328C34v185Ev();
extern void _ZN8S10328C34v186Ev();
extern void _ZN8S10328C34v187Ev();
extern void _ZN8S10328C34v188Ev();
extern void _ZN8S10328C34v189Ev();
extern void _ZN8S10328C34v190Ev();
extern void _ZN8S10328C34v191Ev();
extern void _ZN8S10328C34v192Ev();
static  VTBL_ENTRY vtc_S10328C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10328C3[0]),
  (VTBL_ENTRY)&_ZN8S10328C3D1Ev,
  (VTBL_ENTRY)&_ZN8S10328C3D0Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v113Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v114Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v115Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v116Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v117Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v118Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v119Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v120Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v121Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v122Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v123Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v124Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v125Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v126Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v127Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v128Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v129Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v130Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v131Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v132Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v133Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v134Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v135Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v136Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v137Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v138Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v139Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v140Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v141Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v142Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v143Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v144Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v145Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v146Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v147Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v148Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v149Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v150Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v151Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v152Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v153Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v154Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v155Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v156Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v157Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v158Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v159Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v160Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v161Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v162Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v163Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v164Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v165Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v166Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v167Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v168Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v169Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v170Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v171Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v172Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v173Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v174Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v175Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v176Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v177Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v178Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v179Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v180Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v181Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v182Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v183Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v184Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v185Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v186Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v187Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v188Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v189Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v190Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v191Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v192Ev,
};
extern VTBL_ENTRY _ZTI8S10328C3[];
extern  VTBL_ENTRY _ZTV8S10328C3[];
Class_Descriptor cd_S10328C3 = {  "S10328C3", // class name
  0,0,//no base classes
  &(vtc_S10328C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10328C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10328C3),84, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10328C4  {
  virtual  ~S10328C4(); // _ZN8S10328C4D1Ev
  virtual void  v193(); // _ZN8S10328C44v193Ev
  S10328C4(); // tgen
};
//SIG(-1 S10328C4) C1{ vd v1}


 S10328C4 ::~S10328C4(){ note_dtor("S10328C4", this);}
void  S10328C4 ::v193(){vfunc_called(this, "_ZN8S10328C44v193Ev");}
S10328C4 ::S10328C4(){ note_ctor("S10328C4", this);} // tgen

static void Test_S10328C4()
{
  extern Class_Descriptor cd_S10328C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S10328C4, buf);
    S10328C4 *dp, &lv = *(dp=new (buf) S10328C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S10328C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10328C4)");
    test_class_info(&lv, &cd_S10328C4);
    dp->~S10328C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10328C4(Test_S10328C4, "S10328C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S10328C4C1Ev();
extern void _ZN8S10328C4D1Ev();
Name_Map name_map_S10328C4[] = {
  NSPAIR(_ZN8S10328C4C1Ev),
  NSPAIR(_ZN8S10328C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S10328C4[];
extern void _ZN8S10328C4D1Ev();
extern void _ZN8S10328C4D0Ev();
extern void _ZN8S10328C44v193Ev();
static  VTBL_ENTRY vtc_S10328C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10328C4[0]),
  (VTBL_ENTRY)&_ZN8S10328C4D1Ev,
  (VTBL_ENTRY)&_ZN8S10328C4D0Ev,
  (VTBL_ENTRY)&_ZN8S10328C44v193Ev,
};
extern VTBL_ENTRY _ZTI8S10328C4[];
extern  VTBL_ENTRY _ZTV8S10328C4[];
Class_Descriptor cd_S10328C4 = {  "S10328C4", // class name
  0,0,//no base classes
  &(vtc_S10328C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S10328C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S10328C4),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S10328C1  : S10328C2 , S10328C3 , S10328C4 , S4216C11 {
  void *s10328c1f0[2];
  ::S4218C6_nt s10328c1f1;
  void *s10328c1f2;
  int s10328c1f3[3];
  ::S4216C22_nt s10328c1f4;
  int s10328c1f5;
  virtual  ~S10328C1(); // _ZN8S10328C1D1Ev
  virtual void  v1(); // _ZN8S10328C12v1Ev
  virtual void  v2(); // _ZN8S10328C12v2Ev
  virtual void  v3(); // _ZN8S10328C12v3Ev
  virtual void  v4(); // _ZN8S10328C12v4Ev
  virtual void  v5(); // _ZN8S10328C12v5Ev
  virtual void  v6(); // _ZN8S10328C12v6Ev
  virtual void  v7(); // _ZN8S10328C12v7Ev
  virtual void  v8(); // _ZN8S10328C12v8Ev
  virtual void  v9(); // _ZN8S10328C12v9Ev
  virtual void  v10(); // _ZN8S10328C13v10Ev
  virtual void  v11(); // _ZN8S10328C13v11Ev
  virtual void  v12(); // _ZN8S10328C13v12Ev
  virtual void  v13(); // _ZN8S10328C13v13Ev
  virtual void  v14(); // _ZN8S10328C13v14Ev
  virtual void  v15(); // _ZN8S10328C13v15Ev
  virtual void  v16(); // _ZN8S10328C13v16Ev
  virtual void  v17(); // _ZN8S10328C13v17Ev
  virtual void  v18(); // _ZN8S10328C13v18Ev
  virtual void  v19(); // _ZN8S10328C13v19Ev
  virtual void  v20(); // _ZN8S10328C13v20Ev
  virtual void  v21(); // _ZN8S10328C13v21Ev
  virtual void  v22(); // _ZN8S10328C13v22Ev
  virtual void  v23(); // _ZN8S10328C13v23Ev
  virtual void  v24(); // _ZN8S10328C13v24Ev
  virtual void  v25(); // _ZN8S10328C13v25Ev
  virtual void  v26(); // _ZN8S10328C13v26Ev
  virtual void  v27(); // _ZN8S10328C13v27Ev
  virtual void  v28(); // _ZN8S10328C13v28Ev
  virtual void  v29(); // _ZN8S10328C13v29Ev
  virtual void  v30(); // _ZN8S10328C13v30Ev
  virtual void  v31(); // _ZN8S10328C13v31Ev
  virtual void  v32(); // _ZN8S10328C13v32Ev
  virtual void  v33(); // _ZN8S10328C13v33Ev
  virtual void  v34(); // _ZN8S10328C13v34Ev
  virtual void  v35(); // _ZN8S10328C13v35Ev
  virtual void  v36(); // _ZN8S10328C13v36Ev
  virtual void  v37(); // _ZN8S10328C13v37Ev
  virtual void  v38(); // _ZN8S10328C13v38Ev
  virtual void  v39(); // _ZN8S10328C13v39Ev
  virtual void  v40(); // _ZN8S10328C13v40Ev
  virtual void  v41(); // _ZN8S10328C13v41Ev
  virtual void  v42(); // _ZN8S10328C13v42Ev
  virtual void  v43(); // _ZN8S10328C13v43Ev
  virtual void  v44(); // _ZN8S10328C13v44Ev
  virtual void  v45(); // _ZN8S10328C13v45Ev
  virtual void  v46(); // _ZN8S10328C13v46Ev
  virtual void  v47(); // _ZN8S10328C13v47Ev
  virtual void  v48(); // _ZN8S10328C13v48Ev
  virtual void  v49(); // _ZN8S10328C13v49Ev
  virtual void  v50(); // _ZN8S10328C13v50Ev
  virtual void  v51(); // _ZN8S10328C13v51Ev
  virtual void  v52(); // _ZN8S10328C13v52Ev
  virtual void  v53(); // _ZN8S10328C13v53Ev
  virtual void  v54(); // _ZN8S10328C13v54Ev
  virtual void  v55(); // _ZN8S10328C13v55Ev
  virtual void  v56(); // _ZN8S10328C13v56Ev
  virtual void  v57(); // _ZN8S10328C13v57Ev
  virtual void  v58(); // _ZN8S10328C13v58Ev
  virtual void  v59(); // _ZN8S10328C13v59Ev
  virtual void  v60(); // _ZN8S10328C13v60Ev
  virtual void  v61(); // _ZN8S10328C13v61Ev
  virtual void  v62(); // _ZN8S10328C13v62Ev
  virtual void  v63(); // _ZN8S10328C13v63Ev
  virtual void  v64(); // _ZN8S10328C13v64Ev
  virtual void  v65(); // _ZN8S10328C13v65Ev
  virtual void  v66(); // _ZN8S10328C13v66Ev
  virtual void  v67(); // _ZN8S10328C13v67Ev
  virtual void  v68(); // _ZN8S10328C13v68Ev
  virtual void  v69(); // _ZN8S10328C13v69Ev
  virtual void  v70(); // _ZN8S10328C13v70Ev
  virtual void  v71(); // _ZN8S10328C13v71Ev
  virtual void  v72(); // _ZN8S10328C13v72Ev
  virtual void  v73(); // _ZN8S10328C13v73Ev
  virtual void  v74(); // _ZN8S10328C13v74Ev
  virtual void  v75(); // _ZN8S10328C13v75Ev
  virtual void  v76(); // _ZN8S10328C13v76Ev
  virtual void  v77(); // _ZN8S10328C13v77Ev
  virtual void  v78(); // _ZN8S10328C13v78Ev
  virtual void  v79(); // _ZN8S10328C13v79Ev
  virtual void  v80(); // _ZN8S10328C13v80Ev
  virtual void  v81(); // _ZN8S10328C13v81Ev
  virtual void  v82(); // _ZN8S10328C13v82Ev
  virtual void  v83(); // _ZN8S10328C13v83Ev
  virtual void  v84(); // _ZN8S10328C13v84Ev
  virtual void  v85(); // _ZN8S10328C13v85Ev
  virtual void  v86(); // _ZN8S10328C13v86Ev
  virtual void  v87(); // _ZN8S10328C13v87Ev
  virtual void  v88(); // _ZN8S10328C13v88Ev
  virtual void  v89(); // _ZN8S10328C13v89Ev
  virtual void  v90(); // _ZN8S10328C13v90Ev
  virtual void  v91(); // _ZN8S10328C13v91Ev
  virtual void  v92(); // _ZN8S10328C13v92Ev
  virtual void  v93(); // _ZN8S10328C13v93Ev
  virtual void  v94(); // _ZN8S10328C13v94Ev
  virtual void  v95(); // _ZN8S10328C13v95Ev
  virtual void  v96(); // _ZN8S10328C13v96Ev
  virtual void  v97(); // _ZN8S10328C13v97Ev
  S10328C1(); // tgen
};
//SIG(1 S10328C1) C1{ BC2{ vd v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112} BC3{ vd v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192} BC4{ vd v193} BC5{ vd m FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 Fp[2] FC10{ m FL[4]} Fp Fi[3] FC11{ m Fp Fi FC9} Fi}


 S10328C1 ::~S10328C1(){ note_dtor("S10328C1", this);}
void  S10328C1 ::v1(){vfunc_called(this, "_ZN8S10328C12v1Ev");}
void  S10328C1 ::v2(){vfunc_called(this, "_ZN8S10328C12v2Ev");}
void  S10328C1 ::v3(){vfunc_called(this, "_ZN8S10328C12v3Ev");}
void  S10328C1 ::v4(){vfunc_called(this, "_ZN8S10328C12v4Ev");}
void  S10328C1 ::v5(){vfunc_called(this, "_ZN8S10328C12v5Ev");}
void  S10328C1 ::v6(){vfunc_called(this, "_ZN8S10328C12v6Ev");}
void  S10328C1 ::v7(){vfunc_called(this, "_ZN8S10328C12v7Ev");}
void  S10328C1 ::v8(){vfunc_called(this, "_ZN8S10328C12v8Ev");}
void  S10328C1 ::v9(){vfunc_called(this, "_ZN8S10328C12v9Ev");}
void  S10328C1 ::v10(){vfunc_called(this, "_ZN8S10328C13v10Ev");}
void  S10328C1 ::v11(){vfunc_called(this, "_ZN8S10328C13v11Ev");}
void  S10328C1 ::v12(){vfunc_called(this, "_ZN8S10328C13v12Ev");}
void  S10328C1 ::v13(){vfunc_called(this, "_ZN8S10328C13v13Ev");}
void  S10328C1 ::v14(){vfunc_called(this, "_ZN8S10328C13v14Ev");}
void  S10328C1 ::v15(){vfunc_called(this, "_ZN8S10328C13v15Ev");}
void  S10328C1 ::v16(){vfunc_called(this, "_ZN8S10328C13v16Ev");}
void  S10328C1 ::v17(){vfunc_called(this, "_ZN8S10328C13v17Ev");}
void  S10328C1 ::v18(){vfunc_called(this, "_ZN8S10328C13v18Ev");}
void  S10328C1 ::v19(){vfunc_called(this, "_ZN8S10328C13v19Ev");}
void  S10328C1 ::v20(){vfunc_called(this, "_ZN8S10328C13v20Ev");}
void  S10328C1 ::v21(){vfunc_called(this, "_ZN8S10328C13v21Ev");}
void  S10328C1 ::v22(){vfunc_called(this, "_ZN8S10328C13v22Ev");}
void  S10328C1 ::v23(){vfunc_called(this, "_ZN8S10328C13v23Ev");}
void  S10328C1 ::v24(){vfunc_called(this, "_ZN8S10328C13v24Ev");}
void  S10328C1 ::v25(){vfunc_called(this, "_ZN8S10328C13v25Ev");}
void  S10328C1 ::v26(){vfunc_called(this, "_ZN8S10328C13v26Ev");}
void  S10328C1 ::v27(){vfunc_called(this, "_ZN8S10328C13v27Ev");}
void  S10328C1 ::v28(){vfunc_called(this, "_ZN8S10328C13v28Ev");}
void  S10328C1 ::v29(){vfunc_called(this, "_ZN8S10328C13v29Ev");}
void  S10328C1 ::v30(){vfunc_called(this, "_ZN8S10328C13v30Ev");}
void  S10328C1 ::v31(){vfunc_called(this, "_ZN8S10328C13v31Ev");}
void  S10328C1 ::v32(){vfunc_called(this, "_ZN8S10328C13v32Ev");}
void  S10328C1 ::v33(){vfunc_called(this, "_ZN8S10328C13v33Ev");}
void  S10328C1 ::v34(){vfunc_called(this, "_ZN8S10328C13v34Ev");}
void  S10328C1 ::v35(){vfunc_called(this, "_ZN8S10328C13v35Ev");}
void  S10328C1 ::v36(){vfunc_called(this, "_ZN8S10328C13v36Ev");}
void  S10328C1 ::v37(){vfunc_called(this, "_ZN8S10328C13v37Ev");}
void  S10328C1 ::v38(){vfunc_called(this, "_ZN8S10328C13v38Ev");}
void  S10328C1 ::v39(){vfunc_called(this, "_ZN8S10328C13v39Ev");}
void  S10328C1 ::v40(){vfunc_called(this, "_ZN8S10328C13v40Ev");}
void  S10328C1 ::v41(){vfunc_called(this, "_ZN8S10328C13v41Ev");}
void  S10328C1 ::v42(){vfunc_called(this, "_ZN8S10328C13v42Ev");}
void  S10328C1 ::v43(){vfunc_called(this, "_ZN8S10328C13v43Ev");}
void  S10328C1 ::v44(){vfunc_called(this, "_ZN8S10328C13v44Ev");}
void  S10328C1 ::v45(){vfunc_called(this, "_ZN8S10328C13v45Ev");}
void  S10328C1 ::v46(){vfunc_called(this, "_ZN8S10328C13v46Ev");}
void  S10328C1 ::v47(){vfunc_called(this, "_ZN8S10328C13v47Ev");}
void  S10328C1 ::v48(){vfunc_called(this, "_ZN8S10328C13v48Ev");}
void  S10328C1 ::v49(){vfunc_called(this, "_ZN8S10328C13v49Ev");}
void  S10328C1 ::v50(){vfunc_called(this, "_ZN8S10328C13v50Ev");}
void  S10328C1 ::v51(){vfunc_called(this, "_ZN8S10328C13v51Ev");}
void  S10328C1 ::v52(){vfunc_called(this, "_ZN8S10328C13v52Ev");}
void  S10328C1 ::v53(){vfunc_called(this, "_ZN8S10328C13v53Ev");}
void  S10328C1 ::v54(){vfunc_called(this, "_ZN8S10328C13v54Ev");}
void  S10328C1 ::v55(){vfunc_called(this, "_ZN8S10328C13v55Ev");}
void  S10328C1 ::v56(){vfunc_called(this, "_ZN8S10328C13v56Ev");}
void  S10328C1 ::v57(){vfunc_called(this, "_ZN8S10328C13v57Ev");}
void  S10328C1 ::v58(){vfunc_called(this, "_ZN8S10328C13v58Ev");}
void  S10328C1 ::v59(){vfunc_called(this, "_ZN8S10328C13v59Ev");}
void  S10328C1 ::v60(){vfunc_called(this, "_ZN8S10328C13v60Ev");}
void  S10328C1 ::v61(){vfunc_called(this, "_ZN8S10328C13v61Ev");}
void  S10328C1 ::v62(){vfunc_called(this, "_ZN8S10328C13v62Ev");}
void  S10328C1 ::v63(){vfunc_called(this, "_ZN8S10328C13v63Ev");}
void  S10328C1 ::v64(){vfunc_called(this, "_ZN8S10328C13v64Ev");}
void  S10328C1 ::v65(){vfunc_called(this, "_ZN8S10328C13v65Ev");}
void  S10328C1 ::v66(){vfunc_called(this, "_ZN8S10328C13v66Ev");}
void  S10328C1 ::v67(){vfunc_called(this, "_ZN8S10328C13v67Ev");}
void  S10328C1 ::v68(){vfunc_called(this, "_ZN8S10328C13v68Ev");}
void  S10328C1 ::v69(){vfunc_called(this, "_ZN8S10328C13v69Ev");}
void  S10328C1 ::v70(){vfunc_called(this, "_ZN8S10328C13v70Ev");}
void  S10328C1 ::v71(){vfunc_called(this, "_ZN8S10328C13v71Ev");}
void  S10328C1 ::v72(){vfunc_called(this, "_ZN8S10328C13v72Ev");}
void  S10328C1 ::v73(){vfunc_called(this, "_ZN8S10328C13v73Ev");}
void  S10328C1 ::v74(){vfunc_called(this, "_ZN8S10328C13v74Ev");}
void  S10328C1 ::v75(){vfunc_called(this, "_ZN8S10328C13v75Ev");}
void  S10328C1 ::v76(){vfunc_called(this, "_ZN8S10328C13v76Ev");}
void  S10328C1 ::v77(){vfunc_called(this, "_ZN8S10328C13v77Ev");}
void  S10328C1 ::v78(){vfunc_called(this, "_ZN8S10328C13v78Ev");}
void  S10328C1 ::v79(){vfunc_called(this, "_ZN8S10328C13v79Ev");}
void  S10328C1 ::v80(){vfunc_called(this, "_ZN8S10328C13v80Ev");}
void  S10328C1 ::v81(){vfunc_called(this, "_ZN8S10328C13v81Ev");}
void  S10328C1 ::v82(){vfunc_called(this, "_ZN8S10328C13v82Ev");}
void  S10328C1 ::v83(){vfunc_called(this, "_ZN8S10328C13v83Ev");}
void  S10328C1 ::v84(){vfunc_called(this, "_ZN8S10328C13v84Ev");}
void  S10328C1 ::v85(){vfunc_called(this, "_ZN8S10328C13v85Ev");}
void  S10328C1 ::v86(){vfunc_called(this, "_ZN8S10328C13v86Ev");}
void  S10328C1 ::v87(){vfunc_called(this, "_ZN8S10328C13v87Ev");}
void  S10328C1 ::v88(){vfunc_called(this, "_ZN8S10328C13v88Ev");}
void  S10328C1 ::v89(){vfunc_called(this, "_ZN8S10328C13v89Ev");}
void  S10328C1 ::v90(){vfunc_called(this, "_ZN8S10328C13v90Ev");}
void  S10328C1 ::v91(){vfunc_called(this, "_ZN8S10328C13v91Ev");}
void  S10328C1 ::v92(){vfunc_called(this, "_ZN8S10328C13v92Ev");}
void  S10328C1 ::v93(){vfunc_called(this, "_ZN8S10328C13v93Ev");}
void  S10328C1 ::v94(){vfunc_called(this, "_ZN8S10328C13v94Ev");}
void  S10328C1 ::v95(){vfunc_called(this, "_ZN8S10328C13v95Ev");}
void  S10328C1 ::v96(){vfunc_called(this, "_ZN8S10328C13v96Ev");}
void  S10328C1 ::v97(){vfunc_called(this, "_ZN8S10328C13v97Ev");}
S10328C1 ::S10328C1(){ note_ctor("S10328C1", this);} // tgen

static void Test_S10328C1()
{
  extern Class_Descriptor cd_S10328C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(19,26)];
    init_test(&cd_S10328C1, buf);
    S10328C1 *dp, &lv = *(dp=new (buf) S10328C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,100), "sizeof(S10328C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S10328C1)");
    check_base_class_offset(lv, (S10328C2*), 0, "S10328C1");
    check_base_class_offset(lv, (S10328C3*), ABISELECT(8,4), "S10328C1");
    check_base_class_offset(lv, (S10328C4*), ABISELECT(16,8), "S10328C1");
    check_base_class_offset(lv, (S4216C11*), ABISELECT(24,12), "S10328C1");
    check_field_offset(lv, s10328c1f0, ABISELECT(48,28), "S10328C1.s10328c1f0");
    check_field_offset(lv, s10328c1f1, ABISELECT(64,36), "S10328C1.s10328c1f1");
    check_field_offset(lv, s10328c1f2, ABISELECT(96,68), "S10328C1.s10328c1f2");
    check_field_offset(lv, s10328c1f3, ABISELECT(104,72), "S10328C1.s10328c1f3");
    check_field_offset(lv, s10328c1f4, ABISELECT(120,84), "S10328C1.s10328c1f4");
    check_field_offset(lv, s10328c1f5, ABISELECT(136,96), "S10328C1.s10328c1f5");
    test_class_info(&lv, &cd_S10328C1);
    dp->~S10328C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS10328C1(Test_S10328C1, "S10328C1", ABISELECT(144,100));

#else // __cplusplus

extern void _ZN8S10328C1C1Ev();
extern void _ZN8S10328C1D1Ev();
Name_Map name_map_S10328C1[] = {
  NSPAIR(_ZN8S10328C1C1Ev),
  NSPAIR(_ZN8S10328C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S10328C2;
extern VTBL_ENTRY _ZTI8S10328C2[];
extern  VTBL_ENTRY _ZTV8S10328C2[];
extern Class_Descriptor cd_S10328C3;
extern VTBL_ENTRY _ZTI8S10328C3[];
extern  VTBL_ENTRY _ZTV8S10328C3[];
extern Class_Descriptor cd_S10328C4;
extern VTBL_ENTRY _ZTI8S10328C4[];
extern  VTBL_ENTRY _ZTV8S10328C4[];
extern Class_Descriptor cd_S4216C11;
extern VTBL_ENTRY _ZTI8S4216C11[];
extern  VTBL_ENTRY _ZTV8S4216C11[];
static Base_Class bases_S10328C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S10328C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10328C3,    ABISELECT(8,4), //bcp->offset
    116, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S10328C4,    ABISELECT(16,8), //bcp->offset
    200, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4216C11,    ABISELECT(24,12), //bcp->offset
    205, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S10328C1[];
extern void _ZN8S10328C1D1Ev();
extern void _ZN8S10328C1D0Ev();
extern void _ZN8S10328C23v98Ev();
extern void _ZN8S10328C23v99Ev();
extern void _ZN8S10328C24v100Ev();
extern void _ZN8S10328C24v101Ev();
extern void _ZN8S10328C24v102Ev();
extern void _ZN8S10328C24v103Ev();
extern void _ZN8S10328C24v104Ev();
extern void _ZN8S10328C24v105Ev();
extern void _ZN8S10328C24v106Ev();
extern void _ZN8S10328C24v107Ev();
extern void _ZN8S10328C24v108Ev();
extern void _ZN8S10328C24v109Ev();
extern void _ZN8S10328C24v110Ev();
extern void _ZN8S10328C24v111Ev();
extern void _ZN8S10328C24v112Ev();
extern void _ZN8S10328C12v1Ev();
extern void _ZN8S10328C12v2Ev();
extern void _ZN8S10328C12v3Ev();
extern void _ZN8S10328C12v4Ev();
extern void _ZN8S10328C12v5Ev();
extern void _ZN8S10328C12v6Ev();
extern void _ZN8S10328C12v7Ev();
extern void _ZN8S10328C12v8Ev();
extern void _ZN8S10328C12v9Ev();
extern void _ZN8S10328C13v10Ev();
extern void _ZN8S10328C13v11Ev();
extern void _ZN8S10328C13v12Ev();
extern void _ZN8S10328C13v13Ev();
extern void _ZN8S10328C13v14Ev();
extern void _ZN8S10328C13v15Ev();
extern void _ZN8S10328C13v16Ev();
extern void _ZN8S10328C13v17Ev();
extern void _ZN8S10328C13v18Ev();
extern void _ZN8S10328C13v19Ev();
extern void _ZN8S10328C13v20Ev();
extern void _ZN8S10328C13v21Ev();
extern void _ZN8S10328C13v22Ev();
extern void _ZN8S10328C13v23Ev();
extern void _ZN8S10328C13v24Ev();
extern void _ZN8S10328C13v25Ev();
extern void _ZN8S10328C13v26Ev();
extern void _ZN8S10328C13v27Ev();
extern void _ZN8S10328C13v28Ev();
extern void _ZN8S10328C13v29Ev();
extern void _ZN8S10328C13v30Ev();
extern void _ZN8S10328C13v31Ev();
extern void _ZN8S10328C13v32Ev();
extern void _ZN8S10328C13v33Ev();
extern void _ZN8S10328C13v34Ev();
extern void _ZN8S10328C13v35Ev();
extern void _ZN8S10328C13v36Ev();
extern void _ZN8S10328C13v37Ev();
extern void _ZN8S10328C13v38Ev();
extern void _ZN8S10328C13v39Ev();
extern void _ZN8S10328C13v40Ev();
extern void _ZN8S10328C13v41Ev();
extern void _ZN8S10328C13v42Ev();
extern void _ZN8S10328C13v43Ev();
extern void _ZN8S10328C13v44Ev();
extern void _ZN8S10328C13v45Ev();
extern void _ZN8S10328C13v46Ev();
extern void _ZN8S10328C13v47Ev();
extern void _ZN8S10328C13v48Ev();
extern void _ZN8S10328C13v49Ev();
extern void _ZN8S10328C13v50Ev();
extern void _ZN8S10328C13v51Ev();
extern void _ZN8S10328C13v52Ev();
extern void _ZN8S10328C13v53Ev();
extern void _ZN8S10328C13v54Ev();
extern void _ZN8S10328C13v55Ev();
extern void _ZN8S10328C13v56Ev();
extern void _ZN8S10328C13v57Ev();
extern void _ZN8S10328C13v58Ev();
extern void _ZN8S10328C13v59Ev();
extern void _ZN8S10328C13v60Ev();
extern void _ZN8S10328C13v61Ev();
extern void _ZN8S10328C13v62Ev();
extern void _ZN8S10328C13v63Ev();
extern void _ZN8S10328C13v64Ev();
extern void _ZN8S10328C13v65Ev();
extern void _ZN8S10328C13v66Ev();
extern void _ZN8S10328C13v67Ev();
extern void _ZN8S10328C13v68Ev();
extern void _ZN8S10328C13v69Ev();
extern void _ZN8S10328C13v70Ev();
extern void _ZN8S10328C13v71Ev();
extern void _ZN8S10328C13v72Ev();
extern void _ZN8S10328C13v73Ev();
extern void _ZN8S10328C13v74Ev();
extern void _ZN8S10328C13v75Ev();
extern void _ZN8S10328C13v76Ev();
extern void _ZN8S10328C13v77Ev();
extern void _ZN8S10328C13v78Ev();
extern void _ZN8S10328C13v79Ev();
extern void _ZN8S10328C13v80Ev();
extern void _ZN8S10328C13v81Ev();
extern void _ZN8S10328C13v82Ev();
extern void _ZN8S10328C13v83Ev();
extern void _ZN8S10328C13v84Ev();
extern void _ZN8S10328C13v85Ev();
extern void _ZN8S10328C13v86Ev();
extern void _ZN8S10328C13v87Ev();
extern void _ZN8S10328C13v88Ev();
extern void _ZN8S10328C13v89Ev();
extern void _ZN8S10328C13v90Ev();
extern void _ZN8S10328C13v91Ev();
extern void _ZN8S10328C13v92Ev();
extern void _ZN8S10328C13v93Ev();
extern void _ZN8S10328C13v94Ev();
extern void _ZN8S10328C13v95Ev();
extern void _ZN8S10328C13v96Ev();
extern void _ZN8S10328C13v97Ev();
extern void ABISELECT(_ZThn8_N8S10328C1D1Ev,_ZThn4_N8S10328C1D1Ev)();
extern void ABISELECT(_ZThn8_N8S10328C1D0Ev,_ZThn4_N8S10328C1D0Ev)();
extern void _ZN8S10328C34v113Ev();
extern void _ZN8S10328C34v114Ev();
extern void _ZN8S10328C34v115Ev();
extern void _ZN8S10328C34v116Ev();
extern void _ZN8S10328C34v117Ev();
extern void _ZN8S10328C34v118Ev();
extern void _ZN8S10328C34v119Ev();
extern void _ZN8S10328C34v120Ev();
extern void _ZN8S10328C34v121Ev();
extern void _ZN8S10328C34v122Ev();
extern void _ZN8S10328C34v123Ev();
extern void _ZN8S10328C34v124Ev();
extern void _ZN8S10328C34v125Ev();
extern void _ZN8S10328C34v126Ev();
extern void _ZN8S10328C34v127Ev();
extern void _ZN8S10328C34v128Ev();
extern void _ZN8S10328C34v129Ev();
extern void _ZN8S10328C34v130Ev();
extern void _ZN8S10328C34v131Ev();
extern void _ZN8S10328C34v132Ev();
extern void _ZN8S10328C34v133Ev();
extern void _ZN8S10328C34v134Ev();
extern void _ZN8S10328C34v135Ev();
extern void _ZN8S10328C34v136Ev();
extern void _ZN8S10328C34v137Ev();
extern void _ZN8S10328C34v138Ev();
extern void _ZN8S10328C34v139Ev();
extern void _ZN8S10328C34v140Ev();
extern void _ZN8S10328C34v141Ev();
extern void _ZN8S10328C34v142Ev();
extern void _ZN8S10328C34v143Ev();
extern void _ZN8S10328C34v144Ev();
extern void _ZN8S10328C34v145Ev();
extern void _ZN8S10328C34v146Ev();
extern void _ZN8S10328C34v147Ev();
extern void _ZN8S10328C34v148Ev();
extern void _ZN8S10328C34v149Ev();
extern void _ZN8S10328C34v150Ev();
extern void _ZN8S10328C34v151Ev();
extern void _ZN8S10328C34v152Ev();
extern void _ZN8S10328C34v153Ev();
extern void _ZN8S10328C34v154Ev();
extern void _ZN8S10328C34v155Ev();
extern void _ZN8S10328C34v156Ev();
extern void _ZN8S10328C34v157Ev();
extern void _ZN8S10328C34v158Ev();
extern void _ZN8S10328C34v159Ev();
extern void _ZN8S10328C34v160Ev();
extern void _ZN8S10328C34v161Ev();
extern void _ZN8S10328C34v162Ev();
extern void _ZN8S10328C34v163Ev();
extern void _ZN8S10328C34v164Ev();
extern void _ZN8S10328C34v165Ev();
extern void _ZN8S10328C34v166Ev();
extern void _ZN8S10328C34v167Ev();
extern void _ZN8S10328C34v168Ev();
extern void _ZN8S10328C34v169Ev();
extern void _ZN8S10328C34v170Ev();
extern void _ZN8S10328C34v171Ev();
extern void _ZN8S10328C34v172Ev();
extern void _ZN8S10328C34v173Ev();
extern void _ZN8S10328C34v174Ev();
extern void _ZN8S10328C34v175Ev();
extern void _ZN8S10328C34v176Ev();
extern void _ZN8S10328C34v177Ev();
extern void _ZN8S10328C34v178Ev();
extern void _ZN8S10328C34v179Ev();
extern void _ZN8S10328C34v180Ev();
extern void _ZN8S10328C34v181Ev();
extern void _ZN8S10328C34v182Ev();
extern void _ZN8S10328C34v183Ev();
extern void _ZN8S10328C34v184Ev();
extern void _ZN8S10328C34v185Ev();
extern void _ZN8S10328C34v186Ev();
extern void _ZN8S10328C34v187Ev();
extern void _ZN8S10328C34v188Ev();
extern void _ZN8S10328C34v189Ev();
extern void _ZN8S10328C34v190Ev();
extern void _ZN8S10328C34v191Ev();
extern void _ZN8S10328C34v192Ev();
extern void ABISELECT(_ZThn16_N8S10328C1D1Ev,_ZThn8_N8S10328C1D1Ev)();
extern void ABISELECT(_ZThn16_N8S10328C1D0Ev,_ZThn8_N8S10328C1D0Ev)();
extern void _ZN8S10328C44v193Ev();
extern void ABISELECT(_ZThn24_N8S10328C1D1Ev,_ZThn12_N8S10328C1D1Ev)();
extern void ABISELECT(_ZThn24_N8S10328C1D0Ev,_ZThn12_N8S10328C1D0Ev)();
static  VTBL_ENTRY vtc_S10328C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S10328C1[0]),
  (VTBL_ENTRY)&_ZN8S10328C1D1Ev,
  (VTBL_ENTRY)&_ZN8S10328C1D0Ev,
  (VTBL_ENTRY)&_ZN8S10328C23v98Ev,
  (VTBL_ENTRY)&_ZN8S10328C23v99Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v100Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v101Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v102Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v103Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v104Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v105Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v106Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v107Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v108Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v109Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v110Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v111Ev,
  (VTBL_ENTRY)&_ZN8S10328C24v112Ev,
  (VTBL_ENTRY)&_ZN8S10328C12v1Ev,
  (VTBL_ENTRY)&_ZN8S10328C12v2Ev,
  (VTBL_ENTRY)&_ZN8S10328C12v3Ev,
  (VTBL_ENTRY)&_ZN8S10328C12v4Ev,
  (VTBL_ENTRY)&_ZN8S10328C12v5Ev,
  (VTBL_ENTRY)&_ZN8S10328C12v6Ev,
  (VTBL_ENTRY)&_ZN8S10328C12v7Ev,
  (VTBL_ENTRY)&_ZN8S10328C12v8Ev,
  (VTBL_ENTRY)&_ZN8S10328C12v9Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v10Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v11Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v12Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v13Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v14Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v15Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v16Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v17Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v18Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v19Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v20Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v21Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v22Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v23Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v24Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v25Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v26Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v27Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v28Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v29Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v30Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v31Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v32Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v33Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v34Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v35Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v36Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v37Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v38Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v39Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v40Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v41Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v42Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v43Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v44Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v45Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v46Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v47Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v48Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v49Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v50Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v51Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v52Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v53Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v54Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v55Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v56Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v57Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v58Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v59Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v60Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v61Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v62Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v63Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v64Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v65Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v66Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v67Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v68Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v69Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v70Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v71Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v72Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v73Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v74Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v75Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v76Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v77Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v78Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v79Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v80Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v81Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v82Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v83Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v84Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v85Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v86Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v87Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v88Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v89Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v90Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v91Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v92Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v93Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v94Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v95Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v96Ev,
  (VTBL_ENTRY)&_ZN8S10328C13v97Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S10328C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10328C1D1Ev,_ZThn4_N8S10328C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S10328C1D0Ev,_ZThn4_N8S10328C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10328C34v113Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v114Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v115Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v116Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v117Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v118Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v119Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v120Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v121Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v122Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v123Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v124Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v125Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v126Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v127Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v128Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v129Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v130Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v131Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v132Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v133Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v134Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v135Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v136Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v137Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v138Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v139Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v140Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v141Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v142Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v143Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v144Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v145Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v146Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v147Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v148Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v149Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v150Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v151Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v152Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v153Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v154Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v155Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v156Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v157Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v158Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v159Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v160Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v161Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v162Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v163Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v164Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v165Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v166Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v167Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v168Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v169Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v170Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v171Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v172Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v173Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v174Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v175Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v176Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v177Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v178Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v179Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v180Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v181Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v182Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v183Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v184Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v185Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v186Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v187Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v188Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v189Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v190Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v191Ev,
  (VTBL_ENTRY)&_ZN8S10328C34v192Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S10328C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S10328C1D1Ev,_ZThn8_N8S10328C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S10328C1D0Ev,_ZThn8_N8S10328C1D0Ev),
  (VTBL_ENTRY)&_ZN8S10328C44v193Ev,
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S10328C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S10328C1D1Ev,_ZThn12_N8S10328C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S10328C1D0Ev,_ZThn12_N8S10328C1D0Ev),
};
extern VTBL_ENTRY _ZTI8S10328C1[];
extern  VTBL_ENTRY _ZTV8S10328C1[];
Class_Descriptor cd_S10328C1 = {  "S10328C1", // class name
  bases_S10328C1, 4,
  &(vtc_S10328C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(144,100), // object size
  NSPAIRA(_ZTI8S10328C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S10328C1),209, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9982C2  {
  virtual  ~S9982C2(); // _ZN7S9982C2D1Ev
  virtual void  v58(); // _ZN7S9982C23v58Ev
  virtual void  v59(); // _ZN7S9982C23v59Ev
  virtual void  v60(); // _ZN7S9982C23v60Ev
  virtual void  v61(); // _ZN7S9982C23v61Ev
  virtual void  v62(); // _ZN7S9982C23v62Ev
  virtual void  v63(); // _ZN7S9982C23v63Ev
  virtual void  v64(); // _ZN7S9982C23v64Ev
  virtual void  v65(); // _ZN7S9982C23v65Ev
  virtual void  v66(); // _ZN7S9982C23v66Ev
  virtual void  v67(); // _ZN7S9982C23v67Ev
  virtual void  v68(); // _ZN7S9982C23v68Ev
  virtual void  v69(); // _ZN7S9982C23v69Ev
  virtual void  v70(); // _ZN7S9982C23v70Ev
  virtual void  v71(); // _ZN7S9982C23v71Ev
  virtual void  v72(); // _ZN7S9982C23v72Ev
  virtual void  v73(); // _ZN7S9982C23v73Ev
  virtual void  v74(); // _ZN7S9982C23v74Ev
  virtual void  v75(); // _ZN7S9982C23v75Ev
  virtual void  v76(); // _ZN7S9982C23v76Ev
  virtual void  v77(); // _ZN7S9982C23v77Ev
  virtual void  v78(); // _ZN7S9982C23v78Ev
  virtual void  v79(); // _ZN7S9982C23v79Ev
  virtual void  v80(); // _ZN7S9982C23v80Ev
  virtual void  v81(); // _ZN7S9982C23v81Ev
  virtual void  v82(); // _ZN7S9982C23v82Ev
  virtual void  v83(); // _ZN7S9982C23v83Ev
  virtual void  v84(); // _ZN7S9982C23v84Ev
  virtual void  v85(); // _ZN7S9982C23v85Ev
  virtual void  v86(); // _ZN7S9982C23v86Ev
  virtual void  v87(); // _ZN7S9982C23v87Ev
  virtual void  v88(); // _ZN7S9982C23v88Ev
  virtual void  v89(); // _ZN7S9982C23v89Ev
  virtual void  v90(); // _ZN7S9982C23v90Ev
  virtual void  v91(); // _ZN7S9982C23v91Ev
  virtual void  v92(); // _ZN7S9982C23v92Ev
  virtual void  v93(); // _ZN7S9982C23v93Ev
  virtual void  v94(); // _ZN7S9982C23v94Ev
  virtual void  v95(); // _ZN7S9982C23v95Ev
  virtual void  v96(); // _ZN7S9982C23v96Ev
  virtual void  v97(); // _ZN7S9982C23v97Ev
  virtual void  v98(); // _ZN7S9982C23v98Ev
  virtual void  v99(); // _ZN7S9982C23v99Ev
  virtual void  v100(); // _ZN7S9982C24v100Ev
  virtual void  v101(); // _ZN7S9982C24v101Ev
  virtual void  v102(); // _ZN7S9982C24v102Ev
  virtual void  v103(); // _ZN7S9982C24v103Ev
  virtual void  v104(); // _ZN7S9982C24v104Ev
  virtual void  v105(); // _ZN7S9982C24v105Ev
  virtual void  v106(); // _ZN7S9982C24v106Ev
  virtual void  v107(); // _ZN7S9982C24v107Ev
  virtual void  v108(); // _ZN7S9982C24v108Ev
  virtual void  v109(); // _ZN7S9982C24v109Ev
  virtual void  v110(); // _ZN7S9982C24v110Ev
  virtual void  v111(); // _ZN7S9982C24v111Ev
  virtual void  v112(); // _ZN7S9982C24v112Ev
  virtual void  v113(); // _ZN7S9982C24v113Ev
  virtual void  v114(); // _ZN7S9982C24v114Ev
  S9982C2(); // tgen
};
//SIG(-1 S9982C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57}


 S9982C2 ::~S9982C2(){ note_dtor("S9982C2", this);}
void  S9982C2 ::v58(){vfunc_called(this, "_ZN7S9982C23v58Ev");}
void  S9982C2 ::v59(){vfunc_called(this, "_ZN7S9982C23v59Ev");}
void  S9982C2 ::v60(){vfunc_called(this, "_ZN7S9982C23v60Ev");}
void  S9982C2 ::v61(){vfunc_called(this, "_ZN7S9982C23v61Ev");}
void  S9982C2 ::v62(){vfunc_called(this, "_ZN7S9982C23v62Ev");}
void  S9982C2 ::v63(){vfunc_called(this, "_ZN7S9982C23v63Ev");}
void  S9982C2 ::v64(){vfunc_called(this, "_ZN7S9982C23v64Ev");}
void  S9982C2 ::v65(){vfunc_called(this, "_ZN7S9982C23v65Ev");}
void  S9982C2 ::v66(){vfunc_called(this, "_ZN7S9982C23v66Ev");}
void  S9982C2 ::v67(){vfunc_called(this, "_ZN7S9982C23v67Ev");}
void  S9982C2 ::v68(){vfunc_called(this, "_ZN7S9982C23v68Ev");}
void  S9982C2 ::v69(){vfunc_called(this, "_ZN7S9982C23v69Ev");}
void  S9982C2 ::v70(){vfunc_called(this, "_ZN7S9982C23v70Ev");}
void  S9982C2 ::v71(){vfunc_called(this, "_ZN7S9982C23v71Ev");}
void  S9982C2 ::v72(){vfunc_called(this, "_ZN7S9982C23v72Ev");}
void  S9982C2 ::v73(){vfunc_called(this, "_ZN7S9982C23v73Ev");}
void  S9982C2 ::v74(){vfunc_called(this, "_ZN7S9982C23v74Ev");}
void  S9982C2 ::v75(){vfunc_called(this, "_ZN7S9982C23v75Ev");}
void  S9982C2 ::v76(){vfunc_called(this, "_ZN7S9982C23v76Ev");}
void  S9982C2 ::v77(){vfunc_called(this, "_ZN7S9982C23v77Ev");}
void  S9982C2 ::v78(){vfunc_called(this, "_ZN7S9982C23v78Ev");}
void  S9982C2 ::v79(){vfunc_called(this, "_ZN7S9982C23v79Ev");}
void  S9982C2 ::v80(){vfunc_called(this, "_ZN7S9982C23v80Ev");}
void  S9982C2 ::v81(){vfunc_called(this, "_ZN7S9982C23v81Ev");}
void  S9982C2 ::v82(){vfunc_called(this, "_ZN7S9982C23v82Ev");}
void  S9982C2 ::v83(){vfunc_called(this, "_ZN7S9982C23v83Ev");}
void  S9982C2 ::v84(){vfunc_called(this, "_ZN7S9982C23v84Ev");}
void  S9982C2 ::v85(){vfunc_called(this, "_ZN7S9982C23v85Ev");}
void  S9982C2 ::v86(){vfunc_called(this, "_ZN7S9982C23v86Ev");}
void  S9982C2 ::v87(){vfunc_called(this, "_ZN7S9982C23v87Ev");}
void  S9982C2 ::v88(){vfunc_called(this, "_ZN7S9982C23v88Ev");}
void  S9982C2 ::v89(){vfunc_called(this, "_ZN7S9982C23v89Ev");}
void  S9982C2 ::v90(){vfunc_called(this, "_ZN7S9982C23v90Ev");}
void  S9982C2 ::v91(){vfunc_called(this, "_ZN7S9982C23v91Ev");}
void  S9982C2 ::v92(){vfunc_called(this, "_ZN7S9982C23v92Ev");}
void  S9982C2 ::v93(){vfunc_called(this, "_ZN7S9982C23v93Ev");}
void  S9982C2 ::v94(){vfunc_called(this, "_ZN7S9982C23v94Ev");}
void  S9982C2 ::v95(){vfunc_called(this, "_ZN7S9982C23v95Ev");}
void  S9982C2 ::v96(){vfunc_called(this, "_ZN7S9982C23v96Ev");}
void  S9982C2 ::v97(){vfunc_called(this, "_ZN7S9982C23v97Ev");}
void  S9982C2 ::v98(){vfunc_called(this, "_ZN7S9982C23v98Ev");}
void  S9982C2 ::v99(){vfunc_called(this, "_ZN7S9982C23v99Ev");}
void  S9982C2 ::v100(){vfunc_called(this, "_ZN7S9982C24v100Ev");}
void  S9982C2 ::v101(){vfunc_called(this, "_ZN7S9982C24v101Ev");}
void  S9982C2 ::v102(){vfunc_called(this, "_ZN7S9982C24v102Ev");}
void  S9982C2 ::v103(){vfunc_called(this, "_ZN7S9982C24v103Ev");}
void  S9982C2 ::v104(){vfunc_called(this, "_ZN7S9982C24v104Ev");}
void  S9982C2 ::v105(){vfunc_called(this, "_ZN7S9982C24v105Ev");}
void  S9982C2 ::v106(){vfunc_called(this, "_ZN7S9982C24v106Ev");}
void  S9982C2 ::v107(){vfunc_called(this, "_ZN7S9982C24v107Ev");}
void  S9982C2 ::v108(){vfunc_called(this, "_ZN7S9982C24v108Ev");}
void  S9982C2 ::v109(){vfunc_called(this, "_ZN7S9982C24v109Ev");}
void  S9982C2 ::v110(){vfunc_called(this, "_ZN7S9982C24v110Ev");}
void  S9982C2 ::v111(){vfunc_called(this, "_ZN7S9982C24v111Ev");}
void  S9982C2 ::v112(){vfunc_called(this, "_ZN7S9982C24v112Ev");}
void  S9982C2 ::v113(){vfunc_called(this, "_ZN7S9982C24v113Ev");}
void  S9982C2 ::v114(){vfunc_called(this, "_ZN7S9982C24v114Ev");}
S9982C2 ::S9982C2(){ note_ctor("S9982C2", this);} // tgen

static void Test_S9982C2()
{
  extern Class_Descriptor cd_S9982C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9982C2, buf);
    S9982C2 *dp, &lv = *(dp=new (buf) S9982C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9982C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9982C2)");
    test_class_info(&lv, &cd_S9982C2);
    dp->~S9982C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9982C2(Test_S9982C2, "S9982C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9982C2C1Ev();
extern void _ZN7S9982C2D1Ev();
Name_Map name_map_S9982C2[] = {
  NSPAIR(_ZN7S9982C2C1Ev),
  NSPAIR(_ZN7S9982C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9982C2[];
extern void _ZN7S9982C2D1Ev();
extern void _ZN7S9982C2D0Ev();
extern void _ZN7S9982C23v58Ev();
extern void _ZN7S9982C23v59Ev();
extern void _ZN7S9982C23v60Ev();
extern void _ZN7S9982C23v61Ev();
extern void _ZN7S9982C23v62Ev();
extern void _ZN7S9982C23v63Ev();
extern void _ZN7S9982C23v64Ev();
extern void _ZN7S9982C23v65Ev();
extern void _ZN7S9982C23v66Ev();
extern void _ZN7S9982C23v67Ev();
extern void _ZN7S9982C23v68Ev();
extern void _ZN7S9982C23v69Ev();
extern void _ZN7S9982C23v70Ev();
extern void _ZN7S9982C23v71Ev();
extern void _ZN7S9982C23v72Ev();
extern void _ZN7S9982C23v73Ev();
extern void _ZN7S9982C23v74Ev();
extern void _ZN7S9982C23v75Ev();
extern void _ZN7S9982C23v76Ev();
extern void _ZN7S9982C23v77Ev();
extern void _ZN7S9982C23v78Ev();
extern void _ZN7S9982C23v79Ev();
extern void _ZN7S9982C23v80Ev();
extern void _ZN7S9982C23v81Ev();
extern void _ZN7S9982C23v82Ev();
extern void _ZN7S9982C23v83Ev();
extern void _ZN7S9982C23v84Ev();
extern void _ZN7S9982C23v85Ev();
extern void _ZN7S9982C23v86Ev();
extern void _ZN7S9982C23v87Ev();
extern void _ZN7S9982C23v88Ev();
extern void _ZN7S9982C23v89Ev();
extern void _ZN7S9982C23v90Ev();
extern void _ZN7S9982C23v91Ev();
extern void _ZN7S9982C23v92Ev();
extern void _ZN7S9982C23v93Ev();
extern void _ZN7S9982C23v94Ev();
extern void _ZN7S9982C23v95Ev();
extern void _ZN7S9982C23v96Ev();
extern void _ZN7S9982C23v97Ev();
extern void _ZN7S9982C23v98Ev();
extern void _ZN7S9982C23v99Ev();
extern void _ZN7S9982C24v100Ev();
extern void _ZN7S9982C24v101Ev();
extern void _ZN7S9982C24v102Ev();
extern void _ZN7S9982C24v103Ev();
extern void _ZN7S9982C24v104Ev();
extern void _ZN7S9982C24v105Ev();
extern void _ZN7S9982C24v106Ev();
extern void _ZN7S9982C24v107Ev();
extern void _ZN7S9982C24v108Ev();
extern void _ZN7S9982C24v109Ev();
extern void _ZN7S9982C24v110Ev();
extern void _ZN7S9982C24v111Ev();
extern void _ZN7S9982C24v112Ev();
extern void _ZN7S9982C24v113Ev();
extern void _ZN7S9982C24v114Ev();
static  VTBL_ENTRY vtc_S9982C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9982C2[0]),
  (VTBL_ENTRY)&_ZN7S9982C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9982C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v58Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v59Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v60Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v61Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v62Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v63Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v64Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v65Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v66Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v67Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v68Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v69Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v70Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v71Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v72Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v73Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v74Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v75Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v76Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v77Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v78Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v79Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v80Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v81Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v82Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v83Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v84Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v85Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v86Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v87Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v88Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v89Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v90Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v91Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v92Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v93Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v94Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v95Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v96Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v97Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v98Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v99Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v100Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v101Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v102Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v103Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v104Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v105Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v106Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v107Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v108Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v109Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v110Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v111Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v112Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v113Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v114Ev,
};
extern VTBL_ENTRY _ZTI7S9982C2[];
extern  VTBL_ENTRY _ZTV7S9982C2[];
Class_Descriptor cd_S9982C2 = {  "S9982C2", // class name
  0,0,//no base classes
  &(vtc_S9982C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9982C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9982C2),61, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9982C5_nt  {
  void *s9982c5f0;
  void  mf9982c5(); // _ZN10S9982C5_nt8mf9982c5Ev
};
//SIG(-1 S9982C5_nt) C1{ m Fp}


void  S9982C5_nt ::mf9982c5(){}

//skip512 S9982C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9982C1  : S9982C2 {
  ::S4216C6_nt s9982c1f0;
  ::S9982C5_nt s9982c1f1;
  ::S9982C5_nt s9982c1f2;
  virtual  ~S9982C1(); // _ZN7S9982C1D1Ev
  virtual void  v1(); // _ZN7S9982C12v1Ev
  virtual void  v2(); // _ZN7S9982C12v2Ev
  virtual void  v3(); // _ZN7S9982C12v3Ev
  virtual void  v4(); // _ZN7S9982C12v4Ev
  virtual void  v5(); // _ZN7S9982C12v5Ev
  virtual void  v6(); // _ZN7S9982C12v6Ev
  virtual void  v7(); // _ZN7S9982C12v7Ev
  virtual void  v8(); // _ZN7S9982C12v8Ev
  virtual void  v9(); // _ZN7S9982C12v9Ev
  virtual void  v10(); // _ZN7S9982C13v10Ev
  virtual void  v11(); // _ZN7S9982C13v11Ev
  virtual void  v12(); // _ZN7S9982C13v12Ev
  virtual void  v13(); // _ZN7S9982C13v13Ev
  virtual void  v14(); // _ZN7S9982C13v14Ev
  virtual void  v15(); // _ZN7S9982C13v15Ev
  virtual void  v16(); // _ZN7S9982C13v16Ev
  virtual void  v17(); // _ZN7S9982C13v17Ev
  virtual void  v18(); // _ZN7S9982C13v18Ev
  virtual void  v19(); // _ZN7S9982C13v19Ev
  virtual void  v20(); // _ZN7S9982C13v20Ev
  virtual void  v21(); // _ZN7S9982C13v21Ev
  virtual void  v22(); // _ZN7S9982C13v22Ev
  virtual void  v23(); // _ZN7S9982C13v23Ev
  virtual void  v24(); // _ZN7S9982C13v24Ev
  virtual void  v25(); // _ZN7S9982C13v25Ev
  virtual void  v26(); // _ZN7S9982C13v26Ev
  virtual void  v27(); // _ZN7S9982C13v27Ev
  virtual void  v28(); // _ZN7S9982C13v28Ev
  virtual void  v29(); // _ZN7S9982C13v29Ev
  virtual void  v30(); // _ZN7S9982C13v30Ev
  virtual void  v31(); // _ZN7S9982C13v31Ev
  virtual void  v32(); // _ZN7S9982C13v32Ev
  virtual void  v33(); // _ZN7S9982C13v33Ev
  virtual void  v34(); // _ZN7S9982C13v34Ev
  virtual void  v35(); // _ZN7S9982C13v35Ev
  virtual void  v36(); // _ZN7S9982C13v36Ev
  virtual void  v37(); // _ZN7S9982C13v37Ev
  virtual void  v38(); // _ZN7S9982C13v38Ev
  virtual void  v39(); // _ZN7S9982C13v39Ev
  virtual void  v40(); // _ZN7S9982C13v40Ev
  virtual void  v41(); // _ZN7S9982C13v41Ev
  virtual void  v42(); // _ZN7S9982C13v42Ev
  virtual void  v43(); // _ZN7S9982C13v43Ev
  virtual void  v44(); // _ZN7S9982C13v44Ev
  virtual void  v45(); // _ZN7S9982C13v45Ev
  virtual void  v46(); // _ZN7S9982C13v46Ev
  virtual void  v47(); // _ZN7S9982C13v47Ev
  virtual void  v48(); // _ZN7S9982C13v48Ev
  virtual void  v49(); // _ZN7S9982C13v49Ev
  virtual void  v50(); // _ZN7S9982C13v50Ev
  virtual void  v51(); // _ZN7S9982C13v51Ev
  virtual void  v52(); // _ZN7S9982C13v52Ev
  virtual void  v53(); // _ZN7S9982C13v53Ev
  virtual void  v54(); // _ZN7S9982C13v54Ev
  virtual void  v55(); // _ZN7S9982C13v55Ev
  virtual void  v56(); // _ZN7S9982C13v56Ev
  virtual void  v57(); // _ZN7S9982C13v57Ev
  S9982C1(); // tgen
};
//SIG(1 S9982C1) C1{ BC2{ vd v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 FC3{ m FC4{ Fl[4]}} FC5{ m Fp} FC5}


 S9982C1 ::~S9982C1(){ note_dtor("S9982C1", this);}
void  S9982C1 ::v1(){vfunc_called(this, "_ZN7S9982C12v1Ev");}
void  S9982C1 ::v2(){vfunc_called(this, "_ZN7S9982C12v2Ev");}
void  S9982C1 ::v3(){vfunc_called(this, "_ZN7S9982C12v3Ev");}
void  S9982C1 ::v4(){vfunc_called(this, "_ZN7S9982C12v4Ev");}
void  S9982C1 ::v5(){vfunc_called(this, "_ZN7S9982C12v5Ev");}
void  S9982C1 ::v6(){vfunc_called(this, "_ZN7S9982C12v6Ev");}
void  S9982C1 ::v7(){vfunc_called(this, "_ZN7S9982C12v7Ev");}
void  S9982C1 ::v8(){vfunc_called(this, "_ZN7S9982C12v8Ev");}
void  S9982C1 ::v9(){vfunc_called(this, "_ZN7S9982C12v9Ev");}
void  S9982C1 ::v10(){vfunc_called(this, "_ZN7S9982C13v10Ev");}
void  S9982C1 ::v11(){vfunc_called(this, "_ZN7S9982C13v11Ev");}
void  S9982C1 ::v12(){vfunc_called(this, "_ZN7S9982C13v12Ev");}
void  S9982C1 ::v13(){vfunc_called(this, "_ZN7S9982C13v13Ev");}
void  S9982C1 ::v14(){vfunc_called(this, "_ZN7S9982C13v14Ev");}
void  S9982C1 ::v15(){vfunc_called(this, "_ZN7S9982C13v15Ev");}
void  S9982C1 ::v16(){vfunc_called(this, "_ZN7S9982C13v16Ev");}
void  S9982C1 ::v17(){vfunc_called(this, "_ZN7S9982C13v17Ev");}
void  S9982C1 ::v18(){vfunc_called(this, "_ZN7S9982C13v18Ev");}
void  S9982C1 ::v19(){vfunc_called(this, "_ZN7S9982C13v19Ev");}
void  S9982C1 ::v20(){vfunc_called(this, "_ZN7S9982C13v20Ev");}
void  S9982C1 ::v21(){vfunc_called(this, "_ZN7S9982C13v21Ev");}
void  S9982C1 ::v22(){vfunc_called(this, "_ZN7S9982C13v22Ev");}
void  S9982C1 ::v23(){vfunc_called(this, "_ZN7S9982C13v23Ev");}
void  S9982C1 ::v24(){vfunc_called(this, "_ZN7S9982C13v24Ev");}
void  S9982C1 ::v25(){vfunc_called(this, "_ZN7S9982C13v25Ev");}
void  S9982C1 ::v26(){vfunc_called(this, "_ZN7S9982C13v26Ev");}
void  S9982C1 ::v27(){vfunc_called(this, "_ZN7S9982C13v27Ev");}
void  S9982C1 ::v28(){vfunc_called(this, "_ZN7S9982C13v28Ev");}
void  S9982C1 ::v29(){vfunc_called(this, "_ZN7S9982C13v29Ev");}
void  S9982C1 ::v30(){vfunc_called(this, "_ZN7S9982C13v30Ev");}
void  S9982C1 ::v31(){vfunc_called(this, "_ZN7S9982C13v31Ev");}
void  S9982C1 ::v32(){vfunc_called(this, "_ZN7S9982C13v32Ev");}
void  S9982C1 ::v33(){vfunc_called(this, "_ZN7S9982C13v33Ev");}
void  S9982C1 ::v34(){vfunc_called(this, "_ZN7S9982C13v34Ev");}
void  S9982C1 ::v35(){vfunc_called(this, "_ZN7S9982C13v35Ev");}
void  S9982C1 ::v36(){vfunc_called(this, "_ZN7S9982C13v36Ev");}
void  S9982C1 ::v37(){vfunc_called(this, "_ZN7S9982C13v37Ev");}
void  S9982C1 ::v38(){vfunc_called(this, "_ZN7S9982C13v38Ev");}
void  S9982C1 ::v39(){vfunc_called(this, "_ZN7S9982C13v39Ev");}
void  S9982C1 ::v40(){vfunc_called(this, "_ZN7S9982C13v40Ev");}
void  S9982C1 ::v41(){vfunc_called(this, "_ZN7S9982C13v41Ev");}
void  S9982C1 ::v42(){vfunc_called(this, "_ZN7S9982C13v42Ev");}
void  S9982C1 ::v43(){vfunc_called(this, "_ZN7S9982C13v43Ev");}
void  S9982C1 ::v44(){vfunc_called(this, "_ZN7S9982C13v44Ev");}
void  S9982C1 ::v45(){vfunc_called(this, "_ZN7S9982C13v45Ev");}
void  S9982C1 ::v46(){vfunc_called(this, "_ZN7S9982C13v46Ev");}
void  S9982C1 ::v47(){vfunc_called(this, "_ZN7S9982C13v47Ev");}
void  S9982C1 ::v48(){vfunc_called(this, "_ZN7S9982C13v48Ev");}
void  S9982C1 ::v49(){vfunc_called(this, "_ZN7S9982C13v49Ev");}
void  S9982C1 ::v50(){vfunc_called(this, "_ZN7S9982C13v50Ev");}
void  S9982C1 ::v51(){vfunc_called(this, "_ZN7S9982C13v51Ev");}
void  S9982C1 ::v52(){vfunc_called(this, "_ZN7S9982C13v52Ev");}
void  S9982C1 ::v53(){vfunc_called(this, "_ZN7S9982C13v53Ev");}
void  S9982C1 ::v54(){vfunc_called(this, "_ZN7S9982C13v54Ev");}
void  S9982C1 ::v55(){vfunc_called(this, "_ZN7S9982C13v55Ev");}
void  S9982C1 ::v56(){vfunc_called(this, "_ZN7S9982C13v56Ev");}
void  S9982C1 ::v57(){vfunc_called(this, "_ZN7S9982C13v57Ev");}
S9982C1 ::S9982C1(){ note_ctor("S9982C1", this);} // tgen

static void Test_S9982C1()
{
  extern Class_Descriptor cd_S9982C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[8];
    init_test(&cd_S9982C1, buf);
    S9982C1 *dp, &lv = *(dp=new (buf) S9982C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,28), "sizeof(S9982C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9982C1)");
    check_base_class_offset(lv, (S9982C2*), 0, "S9982C1");
    check_field_offset(lv, s9982c1f0, ABISELECT(8,4), "S9982C1.s9982c1f0");
    check_field_offset(lv, s9982c1f1, ABISELECT(40,20), "S9982C1.s9982c1f1");
    check_field_offset(lv, s9982c1f2, ABISELECT(48,24), "S9982C1.s9982c1f2");
    test_class_info(&lv, &cd_S9982C1);
    dp->~S9982C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9982C1(Test_S9982C1, "S9982C1", ABISELECT(56,28));

#else // __cplusplus

extern void _ZN7S9982C1C1Ev();
extern void _ZN7S9982C1D1Ev();
Name_Map name_map_S9982C1[] = {
  NSPAIR(_ZN7S9982C1C1Ev),
  NSPAIR(_ZN7S9982C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9982C2;
extern VTBL_ENTRY _ZTI7S9982C2[];
extern  VTBL_ENTRY _ZTV7S9982C2[];
static Base_Class bases_S9982C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9982C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9982C1[];
extern void _ZN7S9982C1D1Ev();
extern void _ZN7S9982C1D0Ev();
extern void _ZN7S9982C23v58Ev();
extern void _ZN7S9982C23v59Ev();
extern void _ZN7S9982C23v60Ev();
extern void _ZN7S9982C23v61Ev();
extern void _ZN7S9982C23v62Ev();
extern void _ZN7S9982C23v63Ev();
extern void _ZN7S9982C23v64Ev();
extern void _ZN7S9982C23v65Ev();
extern void _ZN7S9982C23v66Ev();
extern void _ZN7S9982C23v67Ev();
extern void _ZN7S9982C23v68Ev();
extern void _ZN7S9982C23v69Ev();
extern void _ZN7S9982C23v70Ev();
extern void _ZN7S9982C23v71Ev();
extern void _ZN7S9982C23v72Ev();
extern void _ZN7S9982C23v73Ev();
extern void _ZN7S9982C23v74Ev();
extern void _ZN7S9982C23v75Ev();
extern void _ZN7S9982C23v76Ev();
extern void _ZN7S9982C23v77Ev();
extern void _ZN7S9982C23v78Ev();
extern void _ZN7S9982C23v79Ev();
extern void _ZN7S9982C23v80Ev();
extern void _ZN7S9982C23v81Ev();
extern void _ZN7S9982C23v82Ev();
extern void _ZN7S9982C23v83Ev();
extern void _ZN7S9982C23v84Ev();
extern void _ZN7S9982C23v85Ev();
extern void _ZN7S9982C23v86Ev();
extern void _ZN7S9982C23v87Ev();
extern void _ZN7S9982C23v88Ev();
extern void _ZN7S9982C23v89Ev();
extern void _ZN7S9982C23v90Ev();
extern void _ZN7S9982C23v91Ev();
extern void _ZN7S9982C23v92Ev();
extern void _ZN7S9982C23v93Ev();
extern void _ZN7S9982C23v94Ev();
extern void _ZN7S9982C23v95Ev();
extern void _ZN7S9982C23v96Ev();
extern void _ZN7S9982C23v97Ev();
extern void _ZN7S9982C23v98Ev();
extern void _ZN7S9982C23v99Ev();
extern void _ZN7S9982C24v100Ev();
extern void _ZN7S9982C24v101Ev();
extern void _ZN7S9982C24v102Ev();
extern void _ZN7S9982C24v103Ev();
extern void _ZN7S9982C24v104Ev();
extern void _ZN7S9982C24v105Ev();
extern void _ZN7S9982C24v106Ev();
extern void _ZN7S9982C24v107Ev();
extern void _ZN7S9982C24v108Ev();
extern void _ZN7S9982C24v109Ev();
extern void _ZN7S9982C24v110Ev();
extern void _ZN7S9982C24v111Ev();
extern void _ZN7S9982C24v112Ev();
extern void _ZN7S9982C24v113Ev();
extern void _ZN7S9982C24v114Ev();
extern void _ZN7S9982C12v1Ev();
extern void _ZN7S9982C12v2Ev();
extern void _ZN7S9982C12v3Ev();
extern void _ZN7S9982C12v4Ev();
extern void _ZN7S9982C12v5Ev();
extern void _ZN7S9982C12v6Ev();
extern void _ZN7S9982C12v7Ev();
extern void _ZN7S9982C12v8Ev();
extern void _ZN7S9982C12v9Ev();
extern void _ZN7S9982C13v10Ev();
extern void _ZN7S9982C13v11Ev();
extern void _ZN7S9982C13v12Ev();
extern void _ZN7S9982C13v13Ev();
extern void _ZN7S9982C13v14Ev();
extern void _ZN7S9982C13v15Ev();
extern void _ZN7S9982C13v16Ev();
extern void _ZN7S9982C13v17Ev();
extern void _ZN7S9982C13v18Ev();
extern void _ZN7S9982C13v19Ev();
extern void _ZN7S9982C13v20Ev();
extern void _ZN7S9982C13v21Ev();
extern void _ZN7S9982C13v22Ev();
extern void _ZN7S9982C13v23Ev();
extern void _ZN7S9982C13v24Ev();
extern void _ZN7S9982C13v25Ev();
extern void _ZN7S9982C13v26Ev();
extern void _ZN7S9982C13v27Ev();
extern void _ZN7S9982C13v28Ev();
extern void _ZN7S9982C13v29Ev();
extern void _ZN7S9982C13v30Ev();
extern void _ZN7S9982C13v31Ev();
extern void _ZN7S9982C13v32Ev();
extern void _ZN7S9982C13v33Ev();
extern void _ZN7S9982C13v34Ev();
extern void _ZN7S9982C13v35Ev();
extern void _ZN7S9982C13v36Ev();
extern void _ZN7S9982C13v37Ev();
extern void _ZN7S9982C13v38Ev();
extern void _ZN7S9982C13v39Ev();
extern void _ZN7S9982C13v40Ev();
extern void _ZN7S9982C13v41Ev();
extern void _ZN7S9982C13v42Ev();
extern void _ZN7S9982C13v43Ev();
extern void _ZN7S9982C13v44Ev();
extern void _ZN7S9982C13v45Ev();
extern void _ZN7S9982C13v46Ev();
extern void _ZN7S9982C13v47Ev();
extern void _ZN7S9982C13v48Ev();
extern void _ZN7S9982C13v49Ev();
extern void _ZN7S9982C13v50Ev();
extern void _ZN7S9982C13v51Ev();
extern void _ZN7S9982C13v52Ev();
extern void _ZN7S9982C13v53Ev();
extern void _ZN7S9982C13v54Ev();
extern void _ZN7S9982C13v55Ev();
extern void _ZN7S9982C13v56Ev();
extern void _ZN7S9982C13v57Ev();
static  VTBL_ENTRY vtc_S9982C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9982C1[0]),
  (VTBL_ENTRY)&_ZN7S9982C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9982C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v58Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v59Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v60Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v61Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v62Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v63Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v64Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v65Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v66Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v67Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v68Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v69Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v70Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v71Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v72Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v73Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v74Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v75Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v76Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v77Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v78Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v79Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v80Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v81Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v82Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v83Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v84Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v85Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v86Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v87Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v88Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v89Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v90Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v91Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v92Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v93Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v94Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v95Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v96Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v97Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v98Ev,
  (VTBL_ENTRY)&_ZN7S9982C23v99Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v100Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v101Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v102Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v103Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v104Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v105Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v106Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v107Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v108Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v109Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v110Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v111Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v112Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v113Ev,
  (VTBL_ENTRY)&_ZN7S9982C24v114Ev,
  (VTBL_ENTRY)&_ZN7S9982C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9982C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9982C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9982C12v4Ev,
  (VTBL_ENTRY)&_ZN7S9982C12v5Ev,
  (VTBL_ENTRY)&_ZN7S9982C12v6Ev,
  (VTBL_ENTRY)&_ZN7S9982C12v7Ev,
  (VTBL_ENTRY)&_ZN7S9982C12v8Ev,
  (VTBL_ENTRY)&_ZN7S9982C12v9Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v10Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v11Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v12Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v13Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v14Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v15Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v16Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v17Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v18Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v19Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v20Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v21Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v22Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v23Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v24Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v25Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v26Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v27Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v28Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v29Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v30Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v31Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v32Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v33Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v34Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v35Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v36Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v37Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v38Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v39Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v40Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v41Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v42Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v43Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v44Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v45Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v46Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v47Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v48Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v49Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v50Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v51Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v52Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v53Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v54Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v55Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v56Ev,
  (VTBL_ENTRY)&_ZN7S9982C13v57Ev,
};
extern VTBL_ENTRY _ZTI7S9982C1[];
extern  VTBL_ENTRY _ZTV7S9982C1[];
Class_Descriptor cd_S9982C1 = {  "S9982C1", // class name
  bases_S9982C1, 1,
  &(vtc_S9982C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,28), // object size
  NSPAIRA(_ZTI7S9982C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9982C1),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9983C2  {
  virtual  ~S9983C2(); // _ZN7S9983C2D1Ev
  virtual void  v58(); // _ZN7S9983C23v58Ev
  virtual void  v59(); // _ZN7S9983C23v59Ev
  virtual void  v60(); // _ZN7S9983C23v60Ev
  virtual void  v61(); // _ZN7S9983C23v61Ev
  virtual void  v62(); // _ZN7S9983C23v62Ev
  virtual void  v63(); // _ZN7S9983C23v63Ev
  virtual void  v64(); // _ZN7S9983C23v64Ev
  virtual void  v65(); // _ZN7S9983C23v65Ev
  virtual void  v66(); // _ZN7S9983C23v66Ev
  virtual void  v67(); // _ZN7S9983C23v67Ev
  virtual void  v68(); // _ZN7S9983C23v68Ev
  virtual void  v69(); // _ZN7S9983C23v69Ev
  virtual void  v70(); // _ZN7S9983C23v70Ev
  virtual void  v71(); // _ZN7S9983C23v71Ev
  virtual void  v72(); // _ZN7S9983C23v72Ev
  virtual void  v73(); // _ZN7S9983C23v73Ev
  virtual void  v74(); // _ZN7S9983C23v74Ev
  virtual void  v75(); // _ZN7S9983C23v75Ev
  virtual void  v76(); // _ZN7S9983C23v76Ev
  virtual void  v77(); // _ZN7S9983C23v77Ev
  virtual void  v78(); // _ZN7S9983C23v78Ev
  virtual void  v79(); // _ZN7S9983C23v79Ev
  virtual void  v80(); // _ZN7S9983C23v80Ev
  virtual void  v81(); // _ZN7S9983C23v81Ev
  virtual void  v82(); // _ZN7S9983C23v82Ev
  virtual void  v83(); // _ZN7S9983C23v83Ev
  virtual void  v84(); // _ZN7S9983C23v84Ev
  virtual void  v85(); // _ZN7S9983C23v85Ev
  virtual void  v86(); // _ZN7S9983C23v86Ev
  virtual void  v87(); // _ZN7S9983C23v87Ev
  virtual void  v88(); // _ZN7S9983C23v88Ev
  virtual void  v89(); // _ZN7S9983C23v89Ev
  virtual void  v90(); // _ZN7S9983C23v90Ev
  virtual void  v91(); // _ZN7S9983C23v91Ev
  virtual void  v92(); // _ZN7S9983C23v92Ev
  virtual void  v93(); // _ZN7S9983C23v93Ev
  virtual void  v94(); // _ZN7S9983C23v94Ev
  virtual void  v95(); // _ZN7S9983C23v95Ev
  virtual void  v96(); // _ZN7S9983C23v96Ev
  virtual void  v97(); // _ZN7S9983C23v97Ev
  virtual void  v98(); // _ZN7S9983C23v98Ev
  virtual void  v99(); // _ZN7S9983C23v99Ev
  virtual void  v100(); // _ZN7S9983C24v100Ev
  virtual void  v101(); // _ZN7S9983C24v101Ev
  virtual void  v102(); // _ZN7S9983C24v102Ev
  virtual void  v103(); // _ZN7S9983C24v103Ev
  virtual void  v104(); // _ZN7S9983C24v104Ev
  virtual void  v105(); // _ZN7S9983C24v105Ev
  virtual void  v106(); // _ZN7S9983C24v106Ev
  virtual void  v107(); // _ZN7S9983C24v107Ev
  virtual void  v108(); // _ZN7S9983C24v108Ev
  virtual void  v109(); // _ZN7S9983C24v109Ev
  virtual void  v110(); // _ZN7S9983C24v110Ev
  virtual void  v111(); // _ZN7S9983C24v111Ev
  virtual void  v112(); // _ZN7S9983C24v112Ev
  virtual void  v113(); // _ZN7S9983C24v113Ev
  virtual void  v114(); // _ZN7S9983C24v114Ev
  S9983C2(); // tgen
};
//SIG(-1 S9983C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57}


 S9983C2 ::~S9983C2(){ note_dtor("S9983C2", this);}
void  S9983C2 ::v58(){vfunc_called(this, "_ZN7S9983C23v58Ev");}
void  S9983C2 ::v59(){vfunc_called(this, "_ZN7S9983C23v59Ev");}
void  S9983C2 ::v60(){vfunc_called(this, "_ZN7S9983C23v60Ev");}
void  S9983C2 ::v61(){vfunc_called(this, "_ZN7S9983C23v61Ev");}
void  S9983C2 ::v62(){vfunc_called(this, "_ZN7S9983C23v62Ev");}
void  S9983C2 ::v63(){vfunc_called(this, "_ZN7S9983C23v63Ev");}
void  S9983C2 ::v64(){vfunc_called(this, "_ZN7S9983C23v64Ev");}
void  S9983C2 ::v65(){vfunc_called(this, "_ZN7S9983C23v65Ev");}
void  S9983C2 ::v66(){vfunc_called(this, "_ZN7S9983C23v66Ev");}
void  S9983C2 ::v67(){vfunc_called(this, "_ZN7S9983C23v67Ev");}
void  S9983C2 ::v68(){vfunc_called(this, "_ZN7S9983C23v68Ev");}
void  S9983C2 ::v69(){vfunc_called(this, "_ZN7S9983C23v69Ev");}
void  S9983C2 ::v70(){vfunc_called(this, "_ZN7S9983C23v70Ev");}
void  S9983C2 ::v71(){vfunc_called(this, "_ZN7S9983C23v71Ev");}
void  S9983C2 ::v72(){vfunc_called(this, "_ZN7S9983C23v72Ev");}
void  S9983C2 ::v73(){vfunc_called(this, "_ZN7S9983C23v73Ev");}
void  S9983C2 ::v74(){vfunc_called(this, "_ZN7S9983C23v74Ev");}
void  S9983C2 ::v75(){vfunc_called(this, "_ZN7S9983C23v75Ev");}
void  S9983C2 ::v76(){vfunc_called(this, "_ZN7S9983C23v76Ev");}
void  S9983C2 ::v77(){vfunc_called(this, "_ZN7S9983C23v77Ev");}
void  S9983C2 ::v78(){vfunc_called(this, "_ZN7S9983C23v78Ev");}
void  S9983C2 ::v79(){vfunc_called(this, "_ZN7S9983C23v79Ev");}
void  S9983C2 ::v80(){vfunc_called(this, "_ZN7S9983C23v80Ev");}
void  S9983C2 ::v81(){vfunc_called(this, "_ZN7S9983C23v81Ev");}
void  S9983C2 ::v82(){vfunc_called(this, "_ZN7S9983C23v82Ev");}
void  S9983C2 ::v83(){vfunc_called(this, "_ZN7S9983C23v83Ev");}
void  S9983C2 ::v84(){vfunc_called(this, "_ZN7S9983C23v84Ev");}
void  S9983C2 ::v85(){vfunc_called(this, "_ZN7S9983C23v85Ev");}
void  S9983C2 ::v86(){vfunc_called(this, "_ZN7S9983C23v86Ev");}
void  S9983C2 ::v87(){vfunc_called(this, "_ZN7S9983C23v87Ev");}
void  S9983C2 ::v88(){vfunc_called(this, "_ZN7S9983C23v88Ev");}
void  S9983C2 ::v89(){vfunc_called(this, "_ZN7S9983C23v89Ev");}
void  S9983C2 ::v90(){vfunc_called(this, "_ZN7S9983C23v90Ev");}
void  S9983C2 ::v91(){vfunc_called(this, "_ZN7S9983C23v91Ev");}
void  S9983C2 ::v92(){vfunc_called(this, "_ZN7S9983C23v92Ev");}
void  S9983C2 ::v93(){vfunc_called(this, "_ZN7S9983C23v93Ev");}
void  S9983C2 ::v94(){vfunc_called(this, "_ZN7S9983C23v94Ev");}
void  S9983C2 ::v95(){vfunc_called(this, "_ZN7S9983C23v95Ev");}
void  S9983C2 ::v96(){vfunc_called(this, "_ZN7S9983C23v96Ev");}
void  S9983C2 ::v97(){vfunc_called(this, "_ZN7S9983C23v97Ev");}
void  S9983C2 ::v98(){vfunc_called(this, "_ZN7S9983C23v98Ev");}
void  S9983C2 ::v99(){vfunc_called(this, "_ZN7S9983C23v99Ev");}
void  S9983C2 ::v100(){vfunc_called(this, "_ZN7S9983C24v100Ev");}
void  S9983C2 ::v101(){vfunc_called(this, "_ZN7S9983C24v101Ev");}
void  S9983C2 ::v102(){vfunc_called(this, "_ZN7S9983C24v102Ev");}
void  S9983C2 ::v103(){vfunc_called(this, "_ZN7S9983C24v103Ev");}
void  S9983C2 ::v104(){vfunc_called(this, "_ZN7S9983C24v104Ev");}
void  S9983C2 ::v105(){vfunc_called(this, "_ZN7S9983C24v105Ev");}
void  S9983C2 ::v106(){vfunc_called(this, "_ZN7S9983C24v106Ev");}
void  S9983C2 ::v107(){vfunc_called(this, "_ZN7S9983C24v107Ev");}
void  S9983C2 ::v108(){vfunc_called(this, "_ZN7S9983C24v108Ev");}
void  S9983C2 ::v109(){vfunc_called(this, "_ZN7S9983C24v109Ev");}
void  S9983C2 ::v110(){vfunc_called(this, "_ZN7S9983C24v110Ev");}
void  S9983C2 ::v111(){vfunc_called(this, "_ZN7S9983C24v111Ev");}
void  S9983C2 ::v112(){vfunc_called(this, "_ZN7S9983C24v112Ev");}
void  S9983C2 ::v113(){vfunc_called(this, "_ZN7S9983C24v113Ev");}
void  S9983C2 ::v114(){vfunc_called(this, "_ZN7S9983C24v114Ev");}
S9983C2 ::S9983C2(){ note_ctor("S9983C2", this);} // tgen

static void Test_S9983C2()
{
  extern Class_Descriptor cd_S9983C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9983C2, buf);
    S9983C2 *dp, &lv = *(dp=new (buf) S9983C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9983C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9983C2)");
    test_class_info(&lv, &cd_S9983C2);
    dp->~S9983C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9983C2(Test_S9983C2, "S9983C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9983C2C1Ev();
extern void _ZN7S9983C2D1Ev();
Name_Map name_map_S9983C2[] = {
  NSPAIR(_ZN7S9983C2C1Ev),
  NSPAIR(_ZN7S9983C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9983C2[];
extern void _ZN7S9983C2D1Ev();
extern void _ZN7S9983C2D0Ev();
extern void _ZN7S9983C23v58Ev();
extern void _ZN7S9983C23v59Ev();
extern void _ZN7S9983C23v60Ev();
extern void _ZN7S9983C23v61Ev();
extern void _ZN7S9983C23v62Ev();
extern void _ZN7S9983C23v63Ev();
extern void _ZN7S9983C23v64Ev();
extern void _ZN7S9983C23v65Ev();
extern void _ZN7S9983C23v66Ev();
extern void _ZN7S9983C23v67Ev();
extern void _ZN7S9983C23v68Ev();
extern void _ZN7S9983C23v69Ev();
extern void _ZN7S9983C23v70Ev();
extern void _ZN7S9983C23v71Ev();
extern void _ZN7S9983C23v72Ev();
extern void _ZN7S9983C23v73Ev();
extern void _ZN7S9983C23v74Ev();
extern void _ZN7S9983C23v75Ev();
extern void _ZN7S9983C23v76Ev();
extern void _ZN7S9983C23v77Ev();
extern void _ZN7S9983C23v78Ev();
extern void _ZN7S9983C23v79Ev();
extern void _ZN7S9983C23v80Ev();
extern void _ZN7S9983C23v81Ev();
extern void _ZN7S9983C23v82Ev();
extern void _ZN7S9983C23v83Ev();
extern void _ZN7S9983C23v84Ev();
extern void _ZN7S9983C23v85Ev();
extern void _ZN7S9983C23v86Ev();
extern void _ZN7S9983C23v87Ev();
extern void _ZN7S9983C23v88Ev();
extern void _ZN7S9983C23v89Ev();
extern void _ZN7S9983C23v90Ev();
extern void _ZN7S9983C23v91Ev();
extern void _ZN7S9983C23v92Ev();
extern void _ZN7S9983C23v93Ev();
extern void _ZN7S9983C23v94Ev();
extern void _ZN7S9983C23v95Ev();
extern void _ZN7S9983C23v96Ev();
extern void _ZN7S9983C23v97Ev();
extern void _ZN7S9983C23v98Ev();
extern void _ZN7S9983C23v99Ev();
extern void _ZN7S9983C24v100Ev();
extern void _ZN7S9983C24v101Ev();
extern void _ZN7S9983C24v102Ev();
extern void _ZN7S9983C24v103Ev();
extern void _ZN7S9983C24v104Ev();
extern void _ZN7S9983C24v105Ev();
extern void _ZN7S9983C24v106Ev();
extern void _ZN7S9983C24v107Ev();
extern void _ZN7S9983C24v108Ev();
extern void _ZN7S9983C24v109Ev();
extern void _ZN7S9983C24v110Ev();
extern void _ZN7S9983C24v111Ev();
extern void _ZN7S9983C24v112Ev();
extern void _ZN7S9983C24v113Ev();
extern void _ZN7S9983C24v114Ev();
static  VTBL_ENTRY vtc_S9983C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9983C2[0]),
  (VTBL_ENTRY)&_ZN7S9983C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9983C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v58Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v59Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v60Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v61Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v62Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v63Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v64Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v65Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v66Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v67Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v68Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v69Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v70Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v71Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v72Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v73Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v74Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v75Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v76Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v77Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v78Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v79Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v80Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v81Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v82Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v83Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v84Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v85Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v86Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v87Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v88Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v89Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v90Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v91Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v92Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v93Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v94Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v95Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v96Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v97Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v98Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v99Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v100Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v101Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v102Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v103Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v104Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v105Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v106Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v107Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v108Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v109Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v110Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v111Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v112Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v113Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v114Ev,
};
extern VTBL_ENTRY _ZTI7S9983C2[];
extern  VTBL_ENTRY _ZTV7S9983C2[];
Class_Descriptor cd_S9983C2 = {  "S9983C2", // class name
  0,0,//no base classes
  &(vtc_S9983C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9983C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9983C2),61, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9983C6  {
  void *s9983c6f0;
  void  mf9983c6(); // _ZN7S9983C68mf9983c6Ev
};
//SIG(-1 S9983C6) C1{ m Fp}


void  S9983C6 ::mf9983c6(){}

static void Test_S9983C6()
{
  {
    init_simple_test("S9983C6");
    S9983C6 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9983C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9983C6)");
    check_field_offset(lv, s9983c6f0, 0, "S9983C6.s9983c6f0");
  }
}
static Arrange_To_Call_Me vS9983C6(Test_S9983C6, "S9983C6", ABISELECT(8,4));

#else // __cplusplus

Class_Descriptor cd_S9983C6 = {  "S9983C6", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9983C1  : S9983C2 {
  ::S4217C6_nt s9983c1f0;
  ::S9982C5_nt s9983c1f1;
  ::S9983C6 s9983c1f2;
  virtual  ~S9983C1(); // _ZN7S9983C1D1Ev
  virtual void  v1(); // _ZN7S9983C12v1Ev
  virtual void  v2(); // _ZN7S9983C12v2Ev
  virtual void  v3(); // _ZN7S9983C12v3Ev
  virtual void  v4(); // _ZN7S9983C12v4Ev
  virtual void  v5(); // _ZN7S9983C12v5Ev
  virtual void  v6(); // _ZN7S9983C12v6Ev
  virtual void  v7(); // _ZN7S9983C12v7Ev
  virtual void  v8(); // _ZN7S9983C12v8Ev
  virtual void  v9(); // _ZN7S9983C12v9Ev
  virtual void  v10(); // _ZN7S9983C13v10Ev
  virtual void  v11(); // _ZN7S9983C13v11Ev
  virtual void  v12(); // _ZN7S9983C13v12Ev
  virtual void  v13(); // _ZN7S9983C13v13Ev
  virtual void  v14(); // _ZN7S9983C13v14Ev
  virtual void  v15(); // _ZN7S9983C13v15Ev
  virtual void  v16(); // _ZN7S9983C13v16Ev
  virtual void  v17(); // _ZN7S9983C13v17Ev
  virtual void  v18(); // _ZN7S9983C13v18Ev
  virtual void  v19(); // _ZN7S9983C13v19Ev
  virtual void  v20(); // _ZN7S9983C13v20Ev
  virtual void  v21(); // _ZN7S9983C13v21Ev
  virtual void  v22(); // _ZN7S9983C13v22Ev
  virtual void  v23(); // _ZN7S9983C13v23Ev
  virtual void  v24(); // _ZN7S9983C13v24Ev
  virtual void  v25(); // _ZN7S9983C13v25Ev
  virtual void  v26(); // _ZN7S9983C13v26Ev
  virtual void  v27(); // _ZN7S9983C13v27Ev
  virtual void  v28(); // _ZN7S9983C13v28Ev
  virtual void  v29(); // _ZN7S9983C13v29Ev
  virtual void  v30(); // _ZN7S9983C13v30Ev
  virtual void  v31(); // _ZN7S9983C13v31Ev
  virtual void  v32(); // _ZN7S9983C13v32Ev
  virtual void  v33(); // _ZN7S9983C13v33Ev
  virtual void  v34(); // _ZN7S9983C13v34Ev
  virtual void  v35(); // _ZN7S9983C13v35Ev
  virtual void  v36(); // _ZN7S9983C13v36Ev
  virtual void  v37(); // _ZN7S9983C13v37Ev
  virtual void  v38(); // _ZN7S9983C13v38Ev
  virtual void  v39(); // _ZN7S9983C13v39Ev
  virtual void  v40(); // _ZN7S9983C13v40Ev
  virtual void  v41(); // _ZN7S9983C13v41Ev
  virtual void  v42(); // _ZN7S9983C13v42Ev
  virtual void  v43(); // _ZN7S9983C13v43Ev
  virtual void  v44(); // _ZN7S9983C13v44Ev
  virtual void  v45(); // _ZN7S9983C13v45Ev
  virtual void  v46(); // _ZN7S9983C13v46Ev
  virtual void  v47(); // _ZN7S9983C13v47Ev
  virtual void  v48(); // _ZN7S9983C13v48Ev
  virtual void  v49(); // _ZN7S9983C13v49Ev
  virtual void  v50(); // _ZN7S9983C13v50Ev
  virtual void  v51(); // _ZN7S9983C13v51Ev
  virtual void  v52(); // _ZN7S9983C13v52Ev
  virtual void  v53(); // _ZN7S9983C13v53Ev
  virtual void  v54(); // _ZN7S9983C13v54Ev
  virtual void  v55(); // _ZN7S9983C13v55Ev
  virtual void  v56(); // _ZN7S9983C13v56Ev
  virtual void  v57(); // _ZN7S9983C13v57Ev
  S9983C1(); // tgen
};
//SIG(1 S9983C1) C1{ BC2{ vd v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 FC3{ m FC4{ FL[4]}} FC5{ m Fp} FC6{ m Fp}}


 S9983C1 ::~S9983C1(){ note_dtor("S9983C1", this);}
void  S9983C1 ::v1(){vfunc_called(this, "_ZN7S9983C12v1Ev");}
void  S9983C1 ::v2(){vfunc_called(this, "_ZN7S9983C12v2Ev");}
void  S9983C1 ::v3(){vfunc_called(this, "_ZN7S9983C12v3Ev");}
void  S9983C1 ::v4(){vfunc_called(this, "_ZN7S9983C12v4Ev");}
void  S9983C1 ::v5(){vfunc_called(this, "_ZN7S9983C12v5Ev");}
void  S9983C1 ::v6(){vfunc_called(this, "_ZN7S9983C12v6Ev");}
void  S9983C1 ::v7(){vfunc_called(this, "_ZN7S9983C12v7Ev");}
void  S9983C1 ::v8(){vfunc_called(this, "_ZN7S9983C12v8Ev");}
void  S9983C1 ::v9(){vfunc_called(this, "_ZN7S9983C12v9Ev");}
void  S9983C1 ::v10(){vfunc_called(this, "_ZN7S9983C13v10Ev");}
void  S9983C1 ::v11(){vfunc_called(this, "_ZN7S9983C13v11Ev");}
void  S9983C1 ::v12(){vfunc_called(this, "_ZN7S9983C13v12Ev");}
void  S9983C1 ::v13(){vfunc_called(this, "_ZN7S9983C13v13Ev");}
void  S9983C1 ::v14(){vfunc_called(this, "_ZN7S9983C13v14Ev");}
void  S9983C1 ::v15(){vfunc_called(this, "_ZN7S9983C13v15Ev");}
void  S9983C1 ::v16(){vfunc_called(this, "_ZN7S9983C13v16Ev");}
void  S9983C1 ::v17(){vfunc_called(this, "_ZN7S9983C13v17Ev");}
void  S9983C1 ::v18(){vfunc_called(this, "_ZN7S9983C13v18Ev");}
void  S9983C1 ::v19(){vfunc_called(this, "_ZN7S9983C13v19Ev");}
void  S9983C1 ::v20(){vfunc_called(this, "_ZN7S9983C13v20Ev");}
void  S9983C1 ::v21(){vfunc_called(this, "_ZN7S9983C13v21Ev");}
void  S9983C1 ::v22(){vfunc_called(this, "_ZN7S9983C13v22Ev");}
void  S9983C1 ::v23(){vfunc_called(this, "_ZN7S9983C13v23Ev");}
void  S9983C1 ::v24(){vfunc_called(this, "_ZN7S9983C13v24Ev");}
void  S9983C1 ::v25(){vfunc_called(this, "_ZN7S9983C13v25Ev");}
void  S9983C1 ::v26(){vfunc_called(this, "_ZN7S9983C13v26Ev");}
void  S9983C1 ::v27(){vfunc_called(this, "_ZN7S9983C13v27Ev");}
void  S9983C1 ::v28(){vfunc_called(this, "_ZN7S9983C13v28Ev");}
void  S9983C1 ::v29(){vfunc_called(this, "_ZN7S9983C13v29Ev");}
void  S9983C1 ::v30(){vfunc_called(this, "_ZN7S9983C13v30Ev");}
void  S9983C1 ::v31(){vfunc_called(this, "_ZN7S9983C13v31Ev");}
void  S9983C1 ::v32(){vfunc_called(this, "_ZN7S9983C13v32Ev");}
void  S9983C1 ::v33(){vfunc_called(this, "_ZN7S9983C13v33Ev");}
void  S9983C1 ::v34(){vfunc_called(this, "_ZN7S9983C13v34Ev");}
void  S9983C1 ::v35(){vfunc_called(this, "_ZN7S9983C13v35Ev");}
void  S9983C1 ::v36(){vfunc_called(this, "_ZN7S9983C13v36Ev");}
void  S9983C1 ::v37(){vfunc_called(this, "_ZN7S9983C13v37Ev");}
void  S9983C1 ::v38(){vfunc_called(this, "_ZN7S9983C13v38Ev");}
void  S9983C1 ::v39(){vfunc_called(this, "_ZN7S9983C13v39Ev");}
void  S9983C1 ::v40(){vfunc_called(this, "_ZN7S9983C13v40Ev");}
void  S9983C1 ::v41(){vfunc_called(this, "_ZN7S9983C13v41Ev");}
void  S9983C1 ::v42(){vfunc_called(this, "_ZN7S9983C13v42Ev");}
void  S9983C1 ::v43(){vfunc_called(this, "_ZN7S9983C13v43Ev");}
void  S9983C1 ::v44(){vfunc_called(this, "_ZN7S9983C13v44Ev");}
void  S9983C1 ::v45(){vfunc_called(this, "_ZN7S9983C13v45Ev");}
void  S9983C1 ::v46(){vfunc_called(this, "_ZN7S9983C13v46Ev");}
void  S9983C1 ::v47(){vfunc_called(this, "_ZN7S9983C13v47Ev");}
void  S9983C1 ::v48(){vfunc_called(this, "_ZN7S9983C13v48Ev");}
void  S9983C1 ::v49(){vfunc_called(this, "_ZN7S9983C13v49Ev");}
void  S9983C1 ::v50(){vfunc_called(this, "_ZN7S9983C13v50Ev");}
void  S9983C1 ::v51(){vfunc_called(this, "_ZN7S9983C13v51Ev");}
void  S9983C1 ::v52(){vfunc_called(this, "_ZN7S9983C13v52Ev");}
void  S9983C1 ::v53(){vfunc_called(this, "_ZN7S9983C13v53Ev");}
void  S9983C1 ::v54(){vfunc_called(this, "_ZN7S9983C13v54Ev");}
void  S9983C1 ::v55(){vfunc_called(this, "_ZN7S9983C13v55Ev");}
void  S9983C1 ::v56(){vfunc_called(this, "_ZN7S9983C13v56Ev");}
void  S9983C1 ::v57(){vfunc_called(this, "_ZN7S9983C13v57Ev");}
S9983C1 ::S9983C1(){ note_ctor("S9983C1", this);} // tgen

static void Test_S9983C1()
{
  extern Class_Descriptor cd_S9983C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,12)];
    init_test(&cd_S9983C1, buf);
    S9983C1 *dp, &lv = *(dp=new (buf) S9983C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,44), "sizeof(S9983C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9983C1)");
    check_base_class_offset(lv, (S9983C2*), 0, "S9983C1");
    check_field_offset(lv, s9983c1f0, ABISELECT(8,4), "S9983C1.s9983c1f0");
    check_field_offset(lv, s9983c1f1, ABISELECT(40,36), "S9983C1.s9983c1f1");
    check_field_offset(lv, s9983c1f2, ABISELECT(48,40), "S9983C1.s9983c1f2");
    test_class_info(&lv, &cd_S9983C1);
    dp->~S9983C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9983C1(Test_S9983C1, "S9983C1", ABISELECT(56,44));

#else // __cplusplus

extern void _ZN7S9983C1C1Ev();
extern void _ZN7S9983C1D1Ev();
Name_Map name_map_S9983C1[] = {
  NSPAIR(_ZN7S9983C1C1Ev),
  NSPAIR(_ZN7S9983C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9983C2;
extern VTBL_ENTRY _ZTI7S9983C2[];
extern  VTBL_ENTRY _ZTV7S9983C2[];
static Base_Class bases_S9983C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9983C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9983C1[];
extern void _ZN7S9983C1D1Ev();
extern void _ZN7S9983C1D0Ev();
extern void _ZN7S9983C23v58Ev();
extern void _ZN7S9983C23v59Ev();
extern void _ZN7S9983C23v60Ev();
extern void _ZN7S9983C23v61Ev();
extern void _ZN7S9983C23v62Ev();
extern void _ZN7S9983C23v63Ev();
extern void _ZN7S9983C23v64Ev();
extern void _ZN7S9983C23v65Ev();
extern void _ZN7S9983C23v66Ev();
extern void _ZN7S9983C23v67Ev();
extern void _ZN7S9983C23v68Ev();
extern void _ZN7S9983C23v69Ev();
extern void _ZN7S9983C23v70Ev();
extern void _ZN7S9983C23v71Ev();
extern void _ZN7S9983C23v72Ev();
extern void _ZN7S9983C23v73Ev();
extern void _ZN7S9983C23v74Ev();
extern void _ZN7S9983C23v75Ev();
extern void _ZN7S9983C23v76Ev();
extern void _ZN7S9983C23v77Ev();
extern void _ZN7S9983C23v78Ev();
extern void _ZN7S9983C23v79Ev();
extern void _ZN7S9983C23v80Ev();
extern void _ZN7S9983C23v81Ev();
extern void _ZN7S9983C23v82Ev();
extern void _ZN7S9983C23v83Ev();
extern void _ZN7S9983C23v84Ev();
extern void _ZN7S9983C23v85Ev();
extern void _ZN7S9983C23v86Ev();
extern void _ZN7S9983C23v87Ev();
extern void _ZN7S9983C23v88Ev();
extern void _ZN7S9983C23v89Ev();
extern void _ZN7S9983C23v90Ev();
extern void _ZN7S9983C23v91Ev();
extern void _ZN7S9983C23v92Ev();
extern void _ZN7S9983C23v93Ev();
extern void _ZN7S9983C23v94Ev();
extern void _ZN7S9983C23v95Ev();
extern void _ZN7S9983C23v96Ev();
extern void _ZN7S9983C23v97Ev();
extern void _ZN7S9983C23v98Ev();
extern void _ZN7S9983C23v99Ev();
extern void _ZN7S9983C24v100Ev();
extern void _ZN7S9983C24v101Ev();
extern void _ZN7S9983C24v102Ev();
extern void _ZN7S9983C24v103Ev();
extern void _ZN7S9983C24v104Ev();
extern void _ZN7S9983C24v105Ev();
extern void _ZN7S9983C24v106Ev();
extern void _ZN7S9983C24v107Ev();
extern void _ZN7S9983C24v108Ev();
extern void _ZN7S9983C24v109Ev();
extern void _ZN7S9983C24v110Ev();
extern void _ZN7S9983C24v111Ev();
extern void _ZN7S9983C24v112Ev();
extern void _ZN7S9983C24v113Ev();
extern void _ZN7S9983C24v114Ev();
extern void _ZN7S9983C12v1Ev();
extern void _ZN7S9983C12v2Ev();
extern void _ZN7S9983C12v3Ev();
extern void _ZN7S9983C12v4Ev();
extern void _ZN7S9983C12v5Ev();
extern void _ZN7S9983C12v6Ev();
extern void _ZN7S9983C12v7Ev();
extern void _ZN7S9983C12v8Ev();
extern void _ZN7S9983C12v9Ev();
extern void _ZN7S9983C13v10Ev();
extern void _ZN7S9983C13v11Ev();
extern void _ZN7S9983C13v12Ev();
extern void _ZN7S9983C13v13Ev();
extern void _ZN7S9983C13v14Ev();
extern void _ZN7S9983C13v15Ev();
extern void _ZN7S9983C13v16Ev();
extern void _ZN7S9983C13v17Ev();
extern void _ZN7S9983C13v18Ev();
extern void _ZN7S9983C13v19Ev();
extern void _ZN7S9983C13v20Ev();
extern void _ZN7S9983C13v21Ev();
extern void _ZN7S9983C13v22Ev();
extern void _ZN7S9983C13v23Ev();
extern void _ZN7S9983C13v24Ev();
extern void _ZN7S9983C13v25Ev();
extern void _ZN7S9983C13v26Ev();
extern void _ZN7S9983C13v27Ev();
extern void _ZN7S9983C13v28Ev();
extern void _ZN7S9983C13v29Ev();
extern void _ZN7S9983C13v30Ev();
extern void _ZN7S9983C13v31Ev();
extern void _ZN7S9983C13v32Ev();
extern void _ZN7S9983C13v33Ev();
extern void _ZN7S9983C13v34Ev();
extern void _ZN7S9983C13v35Ev();
extern void _ZN7S9983C13v36Ev();
extern void _ZN7S9983C13v37Ev();
extern void _ZN7S9983C13v38Ev();
extern void _ZN7S9983C13v39Ev();
extern void _ZN7S9983C13v40Ev();
extern void _ZN7S9983C13v41Ev();
extern void _ZN7S9983C13v42Ev();
extern void _ZN7S9983C13v43Ev();
extern void _ZN7S9983C13v44Ev();
extern void _ZN7S9983C13v45Ev();
extern void _ZN7S9983C13v46Ev();
extern void _ZN7S9983C13v47Ev();
extern void _ZN7S9983C13v48Ev();
extern void _ZN7S9983C13v49Ev();
extern void _ZN7S9983C13v50Ev();
extern void _ZN7S9983C13v51Ev();
extern void _ZN7S9983C13v52Ev();
extern void _ZN7S9983C13v53Ev();
extern void _ZN7S9983C13v54Ev();
extern void _ZN7S9983C13v55Ev();
extern void _ZN7S9983C13v56Ev();
extern void _ZN7S9983C13v57Ev();
static  VTBL_ENTRY vtc_S9983C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9983C1[0]),
  (VTBL_ENTRY)&_ZN7S9983C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9983C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v58Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v59Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v60Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v61Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v62Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v63Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v64Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v65Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v66Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v67Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v68Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v69Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v70Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v71Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v72Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v73Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v74Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v75Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v76Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v77Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v78Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v79Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v80Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v81Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v82Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v83Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v84Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v85Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v86Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v87Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v88Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v89Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v90Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v91Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v92Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v93Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v94Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v95Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v96Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v97Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v98Ev,
  (VTBL_ENTRY)&_ZN7S9983C23v99Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v100Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v101Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v102Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v103Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v104Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v105Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v106Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v107Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v108Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v109Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v110Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v111Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v112Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v113Ev,
  (VTBL_ENTRY)&_ZN7S9983C24v114Ev,
  (VTBL_ENTRY)&_ZN7S9983C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9983C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9983C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9983C12v4Ev,
  (VTBL_ENTRY)&_ZN7S9983C12v5Ev,
  (VTBL_ENTRY)&_ZN7S9983C12v6Ev,
  (VTBL_ENTRY)&_ZN7S9983C12v7Ev,
  (VTBL_ENTRY)&_ZN7S9983C12v8Ev,
  (VTBL_ENTRY)&_ZN7S9983C12v9Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v10Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v11Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v12Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v13Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v14Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v15Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v16Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v17Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v18Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v19Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v20Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v21Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v22Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v23Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v24Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v25Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v26Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v27Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v28Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v29Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v30Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v31Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v32Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v33Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v34Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v35Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v36Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v37Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v38Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v39Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v40Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v41Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v42Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v43Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v44Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v45Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v46Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v47Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v48Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v49Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v50Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v51Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v52Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v53Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v54Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v55Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v56Ev,
  (VTBL_ENTRY)&_ZN7S9983C13v57Ev,
};
extern VTBL_ENTRY _ZTI7S9983C1[];
extern  VTBL_ENTRY _ZTV7S9983C1[];
Class_Descriptor cd_S9983C1 = {  "S9983C1", // class name
  bases_S9983C1, 1,
  &(vtc_S9983C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,44), // object size
  NSPAIRA(_ZTI7S9983C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9983C1),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9984C2  {
  virtual  ~S9984C2(); // _ZN7S9984C2D1Ev
  virtual void  v58(); // _ZN7S9984C23v58Ev
  virtual void  v59(); // _ZN7S9984C23v59Ev
  virtual void  v60(); // _ZN7S9984C23v60Ev
  virtual void  v61(); // _ZN7S9984C23v61Ev
  virtual void  v62(); // _ZN7S9984C23v62Ev
  virtual void  v63(); // _ZN7S9984C23v63Ev
  virtual void  v64(); // _ZN7S9984C23v64Ev
  virtual void  v65(); // _ZN7S9984C23v65Ev
  virtual void  v66(); // _ZN7S9984C23v66Ev
  virtual void  v67(); // _ZN7S9984C23v67Ev
  virtual void  v68(); // _ZN7S9984C23v68Ev
  virtual void  v69(); // _ZN7S9984C23v69Ev
  virtual void  v70(); // _ZN7S9984C23v70Ev
  virtual void  v71(); // _ZN7S9984C23v71Ev
  virtual void  v72(); // _ZN7S9984C23v72Ev
  virtual void  v73(); // _ZN7S9984C23v73Ev
  virtual void  v74(); // _ZN7S9984C23v74Ev
  virtual void  v75(); // _ZN7S9984C23v75Ev
  virtual void  v76(); // _ZN7S9984C23v76Ev
  virtual void  v77(); // _ZN7S9984C23v77Ev
  virtual void  v78(); // _ZN7S9984C23v78Ev
  virtual void  v79(); // _ZN7S9984C23v79Ev
  virtual void  v80(); // _ZN7S9984C23v80Ev
  virtual void  v81(); // _ZN7S9984C23v81Ev
  virtual void  v82(); // _ZN7S9984C23v82Ev
  virtual void  v83(); // _ZN7S9984C23v83Ev
  virtual void  v84(); // _ZN7S9984C23v84Ev
  virtual void  v85(); // _ZN7S9984C23v85Ev
  virtual void  v86(); // _ZN7S9984C23v86Ev
  virtual void  v87(); // _ZN7S9984C23v87Ev
  virtual void  v88(); // _ZN7S9984C23v88Ev
  virtual void  v89(); // _ZN7S9984C23v89Ev
  virtual void  v90(); // _ZN7S9984C23v90Ev
  virtual void  v91(); // _ZN7S9984C23v91Ev
  virtual void  v92(); // _ZN7S9984C23v92Ev
  virtual void  v93(); // _ZN7S9984C23v93Ev
  virtual void  v94(); // _ZN7S9984C23v94Ev
  virtual void  v95(); // _ZN7S9984C23v95Ev
  virtual void  v96(); // _ZN7S9984C23v96Ev
  virtual void  v97(); // _ZN7S9984C23v97Ev
  virtual void  v98(); // _ZN7S9984C23v98Ev
  virtual void  v99(); // _ZN7S9984C23v99Ev
  virtual void  v100(); // _ZN7S9984C24v100Ev
  virtual void  v101(); // _ZN7S9984C24v101Ev
  virtual void  v102(); // _ZN7S9984C24v102Ev
  virtual void  v103(); // _ZN7S9984C24v103Ev
  virtual void  v104(); // _ZN7S9984C24v104Ev
  virtual void  v105(); // _ZN7S9984C24v105Ev
  virtual void  v106(); // _ZN7S9984C24v106Ev
  virtual void  v107(); // _ZN7S9984C24v107Ev
  virtual void  v108(); // _ZN7S9984C24v108Ev
  virtual void  v109(); // _ZN7S9984C24v109Ev
  virtual void  v110(); // _ZN7S9984C24v110Ev
  virtual void  v111(); // _ZN7S9984C24v111Ev
  virtual void  v112(); // _ZN7S9984C24v112Ev
  virtual void  v113(); // _ZN7S9984C24v113Ev
  virtual void  v114(); // _ZN7S9984C24v114Ev
  S9984C2(); // tgen
};
//SIG(-1 S9984C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57}


 S9984C2 ::~S9984C2(){ note_dtor("S9984C2", this);}
void  S9984C2 ::v58(){vfunc_called(this, "_ZN7S9984C23v58Ev");}
void  S9984C2 ::v59(){vfunc_called(this, "_ZN7S9984C23v59Ev");}
void  S9984C2 ::v60(){vfunc_called(this, "_ZN7S9984C23v60Ev");}
void  S9984C2 ::v61(){vfunc_called(this, "_ZN7S9984C23v61Ev");}
void  S9984C2 ::v62(){vfunc_called(this, "_ZN7S9984C23v62Ev");}
void  S9984C2 ::v63(){vfunc_called(this, "_ZN7S9984C23v63Ev");}
void  S9984C2 ::v64(){vfunc_called(this, "_ZN7S9984C23v64Ev");}
void  S9984C2 ::v65(){vfunc_called(this, "_ZN7S9984C23v65Ev");}
void  S9984C2 ::v66(){vfunc_called(this, "_ZN7S9984C23v66Ev");}
void  S9984C2 ::v67(){vfunc_called(this, "_ZN7S9984C23v67Ev");}
void  S9984C2 ::v68(){vfunc_called(this, "_ZN7S9984C23v68Ev");}
void  S9984C2 ::v69(){vfunc_called(this, "_ZN7S9984C23v69Ev");}
void  S9984C2 ::v70(){vfunc_called(this, "_ZN7S9984C23v70Ev");}
void  S9984C2 ::v71(){vfunc_called(this, "_ZN7S9984C23v71Ev");}
void  S9984C2 ::v72(){vfunc_called(this, "_ZN7S9984C23v72Ev");}
void  S9984C2 ::v73(){vfunc_called(this, "_ZN7S9984C23v73Ev");}
void  S9984C2 ::v74(){vfunc_called(this, "_ZN7S9984C23v74Ev");}
void  S9984C2 ::v75(){vfunc_called(this, "_ZN7S9984C23v75Ev");}
void  S9984C2 ::v76(){vfunc_called(this, "_ZN7S9984C23v76Ev");}
void  S9984C2 ::v77(){vfunc_called(this, "_ZN7S9984C23v77Ev");}
void  S9984C2 ::v78(){vfunc_called(this, "_ZN7S9984C23v78Ev");}
void  S9984C2 ::v79(){vfunc_called(this, "_ZN7S9984C23v79Ev");}
void  S9984C2 ::v80(){vfunc_called(this, "_ZN7S9984C23v80Ev");}
void  S9984C2 ::v81(){vfunc_called(this, "_ZN7S9984C23v81Ev");}
void  S9984C2 ::v82(){vfunc_called(this, "_ZN7S9984C23v82Ev");}
void  S9984C2 ::v83(){vfunc_called(this, "_ZN7S9984C23v83Ev");}
void  S9984C2 ::v84(){vfunc_called(this, "_ZN7S9984C23v84Ev");}
void  S9984C2 ::v85(){vfunc_called(this, "_ZN7S9984C23v85Ev");}
void  S9984C2 ::v86(){vfunc_called(this, "_ZN7S9984C23v86Ev");}
void  S9984C2 ::v87(){vfunc_called(this, "_ZN7S9984C23v87Ev");}
void  S9984C2 ::v88(){vfunc_called(this, "_ZN7S9984C23v88Ev");}
void  S9984C2 ::v89(){vfunc_called(this, "_ZN7S9984C23v89Ev");}
void  S9984C2 ::v90(){vfunc_called(this, "_ZN7S9984C23v90Ev");}
void  S9984C2 ::v91(){vfunc_called(this, "_ZN7S9984C23v91Ev");}
void  S9984C2 ::v92(){vfunc_called(this, "_ZN7S9984C23v92Ev");}
void  S9984C2 ::v93(){vfunc_called(this, "_ZN7S9984C23v93Ev");}
void  S9984C2 ::v94(){vfunc_called(this, "_ZN7S9984C23v94Ev");}
void  S9984C2 ::v95(){vfunc_called(this, "_ZN7S9984C23v95Ev");}
void  S9984C2 ::v96(){vfunc_called(this, "_ZN7S9984C23v96Ev");}
void  S9984C2 ::v97(){vfunc_called(this, "_ZN7S9984C23v97Ev");}
void  S9984C2 ::v98(){vfunc_called(this, "_ZN7S9984C23v98Ev");}
void  S9984C2 ::v99(){vfunc_called(this, "_ZN7S9984C23v99Ev");}
void  S9984C2 ::v100(){vfunc_called(this, "_ZN7S9984C24v100Ev");}
void  S9984C2 ::v101(){vfunc_called(this, "_ZN7S9984C24v101Ev");}
void  S9984C2 ::v102(){vfunc_called(this, "_ZN7S9984C24v102Ev");}
void  S9984C2 ::v103(){vfunc_called(this, "_ZN7S9984C24v103Ev");}
void  S9984C2 ::v104(){vfunc_called(this, "_ZN7S9984C24v104Ev");}
void  S9984C2 ::v105(){vfunc_called(this, "_ZN7S9984C24v105Ev");}
void  S9984C2 ::v106(){vfunc_called(this, "_ZN7S9984C24v106Ev");}
void  S9984C2 ::v107(){vfunc_called(this, "_ZN7S9984C24v107Ev");}
void  S9984C2 ::v108(){vfunc_called(this, "_ZN7S9984C24v108Ev");}
void  S9984C2 ::v109(){vfunc_called(this, "_ZN7S9984C24v109Ev");}
void  S9984C2 ::v110(){vfunc_called(this, "_ZN7S9984C24v110Ev");}
void  S9984C2 ::v111(){vfunc_called(this, "_ZN7S9984C24v111Ev");}
void  S9984C2 ::v112(){vfunc_called(this, "_ZN7S9984C24v112Ev");}
void  S9984C2 ::v113(){vfunc_called(this, "_ZN7S9984C24v113Ev");}
void  S9984C2 ::v114(){vfunc_called(this, "_ZN7S9984C24v114Ev");}
S9984C2 ::S9984C2(){ note_ctor("S9984C2", this);} // tgen

static void Test_S9984C2()
{
  extern Class_Descriptor cd_S9984C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S9984C2, buf);
    S9984C2 *dp, &lv = *(dp=new (buf) S9984C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S9984C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9984C2)");
    test_class_info(&lv, &cd_S9984C2);
    dp->~S9984C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9984C2(Test_S9984C2, "S9984C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S9984C2C1Ev();
extern void _ZN7S9984C2D1Ev();
Name_Map name_map_S9984C2[] = {
  NSPAIR(_ZN7S9984C2C1Ev),
  NSPAIR(_ZN7S9984C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S9984C2[];
extern void _ZN7S9984C2D1Ev();
extern void _ZN7S9984C2D0Ev();
extern void _ZN7S9984C23v58Ev();
extern void _ZN7S9984C23v59Ev();
extern void _ZN7S9984C23v60Ev();
extern void _ZN7S9984C23v61Ev();
extern void _ZN7S9984C23v62Ev();
extern void _ZN7S9984C23v63Ev();
extern void _ZN7S9984C23v64Ev();
extern void _ZN7S9984C23v65Ev();
extern void _ZN7S9984C23v66Ev();
extern void _ZN7S9984C23v67Ev();
extern void _ZN7S9984C23v68Ev();
extern void _ZN7S9984C23v69Ev();
extern void _ZN7S9984C23v70Ev();
extern void _ZN7S9984C23v71Ev();
extern void _ZN7S9984C23v72Ev();
extern void _ZN7S9984C23v73Ev();
extern void _ZN7S9984C23v74Ev();
extern void _ZN7S9984C23v75Ev();
extern void _ZN7S9984C23v76Ev();
extern void _ZN7S9984C23v77Ev();
extern void _ZN7S9984C23v78Ev();
extern void _ZN7S9984C23v79Ev();
extern void _ZN7S9984C23v80Ev();
extern void _ZN7S9984C23v81Ev();
extern void _ZN7S9984C23v82Ev();
extern void _ZN7S9984C23v83Ev();
extern void _ZN7S9984C23v84Ev();
extern void _ZN7S9984C23v85Ev();
extern void _ZN7S9984C23v86Ev();
extern void _ZN7S9984C23v87Ev();
extern void _ZN7S9984C23v88Ev();
extern void _ZN7S9984C23v89Ev();
extern void _ZN7S9984C23v90Ev();
extern void _ZN7S9984C23v91Ev();
extern void _ZN7S9984C23v92Ev();
extern void _ZN7S9984C23v93Ev();
extern void _ZN7S9984C23v94Ev();
extern void _ZN7S9984C23v95Ev();
extern void _ZN7S9984C23v96Ev();
extern void _ZN7S9984C23v97Ev();
extern void _ZN7S9984C23v98Ev();
extern void _ZN7S9984C23v99Ev();
extern void _ZN7S9984C24v100Ev();
extern void _ZN7S9984C24v101Ev();
extern void _ZN7S9984C24v102Ev();
extern void _ZN7S9984C24v103Ev();
extern void _ZN7S9984C24v104Ev();
extern void _ZN7S9984C24v105Ev();
extern void _ZN7S9984C24v106Ev();
extern void _ZN7S9984C24v107Ev();
extern void _ZN7S9984C24v108Ev();
extern void _ZN7S9984C24v109Ev();
extern void _ZN7S9984C24v110Ev();
extern void _ZN7S9984C24v111Ev();
extern void _ZN7S9984C24v112Ev();
extern void _ZN7S9984C24v113Ev();
extern void _ZN7S9984C24v114Ev();
static  VTBL_ENTRY vtc_S9984C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9984C2[0]),
  (VTBL_ENTRY)&_ZN7S9984C2D1Ev,
  (VTBL_ENTRY)&_ZN7S9984C2D0Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v58Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v59Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v60Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v61Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v62Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v63Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v64Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v65Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v66Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v67Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v68Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v69Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v70Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v71Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v72Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v73Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v74Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v75Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v76Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v77Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v78Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v79Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v80Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v81Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v82Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v83Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v84Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v85Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v86Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v87Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v88Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v89Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v90Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v91Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v92Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v93Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v94Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v95Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v96Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v97Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v98Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v99Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v100Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v101Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v102Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v103Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v104Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v105Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v106Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v107Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v108Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v109Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v110Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v111Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v112Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v113Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v114Ev,
};
extern VTBL_ENTRY _ZTI7S9984C2[];
extern  VTBL_ENTRY _ZTV7S9984C2[];
Class_Descriptor cd_S9984C2 = {  "S9984C2", // class name
  0,0,//no base classes
  &(vtc_S9984C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S9984C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S9984C2),61, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S9984C1  : S9984C2 {
  ::S4218C6_nt s9984c1f0;
  ::S9983C6 s9984c1f1;
  ::S9982C5_nt s9984c1f2;
  virtual  ~S9984C1(); // _ZN7S9984C1D1Ev
  virtual void  v1(); // _ZN7S9984C12v1Ev
  virtual void  v2(); // _ZN7S9984C12v2Ev
  virtual void  v3(); // _ZN7S9984C12v3Ev
  virtual void  v4(); // _ZN7S9984C12v4Ev
  virtual void  v5(); // _ZN7S9984C12v5Ev
  virtual void  v6(); // _ZN7S9984C12v6Ev
  virtual void  v7(); // _ZN7S9984C12v7Ev
  virtual void  v8(); // _ZN7S9984C12v8Ev
  virtual void  v9(); // _ZN7S9984C12v9Ev
  virtual void  v10(); // _ZN7S9984C13v10Ev
  virtual void  v11(); // _ZN7S9984C13v11Ev
  virtual void  v12(); // _ZN7S9984C13v12Ev
  virtual void  v13(); // _ZN7S9984C13v13Ev
  virtual void  v14(); // _ZN7S9984C13v14Ev
  virtual void  v15(); // _ZN7S9984C13v15Ev
  virtual void  v16(); // _ZN7S9984C13v16Ev
  virtual void  v17(); // _ZN7S9984C13v17Ev
  virtual void  v18(); // _ZN7S9984C13v18Ev
  virtual void  v19(); // _ZN7S9984C13v19Ev
  virtual void  v20(); // _ZN7S9984C13v20Ev
  virtual void  v21(); // _ZN7S9984C13v21Ev
  virtual void  v22(); // _ZN7S9984C13v22Ev
  virtual void  v23(); // _ZN7S9984C13v23Ev
  virtual void  v24(); // _ZN7S9984C13v24Ev
  virtual void  v25(); // _ZN7S9984C13v25Ev
  virtual void  v26(); // _ZN7S9984C13v26Ev
  virtual void  v27(); // _ZN7S9984C13v27Ev
  virtual void  v28(); // _ZN7S9984C13v28Ev
  virtual void  v29(); // _ZN7S9984C13v29Ev
  virtual void  v30(); // _ZN7S9984C13v30Ev
  virtual void  v31(); // _ZN7S9984C13v31Ev
  virtual void  v32(); // _ZN7S9984C13v32Ev
  virtual void  v33(); // _ZN7S9984C13v33Ev
  virtual void  v34(); // _ZN7S9984C13v34Ev
  virtual void  v35(); // _ZN7S9984C13v35Ev
  virtual void  v36(); // _ZN7S9984C13v36Ev
  virtual void  v37(); // _ZN7S9984C13v37Ev
  virtual void  v38(); // _ZN7S9984C13v38Ev
  virtual void  v39(); // _ZN7S9984C13v39Ev
  virtual void  v40(); // _ZN7S9984C13v40Ev
  virtual void  v41(); // _ZN7S9984C13v41Ev
  virtual void  v42(); // _ZN7S9984C13v42Ev
  virtual void  v43(); // _ZN7S9984C13v43Ev
  virtual void  v44(); // _ZN7S9984C13v44Ev
  virtual void  v45(); // _ZN7S9984C13v45Ev
  virtual void  v46(); // _ZN7S9984C13v46Ev
  virtual void  v47(); // _ZN7S9984C13v47Ev
  virtual void  v48(); // _ZN7S9984C13v48Ev
  virtual void  v49(); // _ZN7S9984C13v49Ev
  virtual void  v50(); // _ZN7S9984C13v50Ev
  virtual void  v51(); // _ZN7S9984C13v51Ev
  virtual void  v52(); // _ZN7S9984C13v52Ev
  virtual void  v53(); // _ZN7S9984C13v53Ev
  virtual void  v54(); // _ZN7S9984C13v54Ev
  virtual void  v55(); // _ZN7S9984C13v55Ev
  virtual void  v56(); // _ZN7S9984C13v56Ev
  virtual void  v57(); // _ZN7S9984C13v57Ev
  S9984C1(); // tgen
};
//SIG(1 S9984C1) C1{ BC2{ vd v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 FC3{ m FL[4]} FC4{ m Fp} FC5{ m Fp}}


 S9984C1 ::~S9984C1(){ note_dtor("S9984C1", this);}
void  S9984C1 ::v1(){vfunc_called(this, "_ZN7S9984C12v1Ev");}
void  S9984C1 ::v2(){vfunc_called(this, "_ZN7S9984C12v2Ev");}
void  S9984C1 ::v3(){vfunc_called(this, "_ZN7S9984C12v3Ev");}
void  S9984C1 ::v4(){vfunc_called(this, "_ZN7S9984C12v4Ev");}
void  S9984C1 ::v5(){vfunc_called(this, "_ZN7S9984C12v5Ev");}
void  S9984C1 ::v6(){vfunc_called(this, "_ZN7S9984C12v6Ev");}
void  S9984C1 ::v7(){vfunc_called(this, "_ZN7S9984C12v7Ev");}
void  S9984C1 ::v8(){vfunc_called(this, "_ZN7S9984C12v8Ev");}
void  S9984C1 ::v9(){vfunc_called(this, "_ZN7S9984C12v9Ev");}
void  S9984C1 ::v10(){vfunc_called(this, "_ZN7S9984C13v10Ev");}
void  S9984C1 ::v11(){vfunc_called(this, "_ZN7S9984C13v11Ev");}
void  S9984C1 ::v12(){vfunc_called(this, "_ZN7S9984C13v12Ev");}
void  S9984C1 ::v13(){vfunc_called(this, "_ZN7S9984C13v13Ev");}
void  S9984C1 ::v14(){vfunc_called(this, "_ZN7S9984C13v14Ev");}
void  S9984C1 ::v15(){vfunc_called(this, "_ZN7S9984C13v15Ev");}
void  S9984C1 ::v16(){vfunc_called(this, "_ZN7S9984C13v16Ev");}
void  S9984C1 ::v17(){vfunc_called(this, "_ZN7S9984C13v17Ev");}
void  S9984C1 ::v18(){vfunc_called(this, "_ZN7S9984C13v18Ev");}
void  S9984C1 ::v19(){vfunc_called(this, "_ZN7S9984C13v19Ev");}
void  S9984C1 ::v20(){vfunc_called(this, "_ZN7S9984C13v20Ev");}
void  S9984C1 ::v21(){vfunc_called(this, "_ZN7S9984C13v21Ev");}
void  S9984C1 ::v22(){vfunc_called(this, "_ZN7S9984C13v22Ev");}
void  S9984C1 ::v23(){vfunc_called(this, "_ZN7S9984C13v23Ev");}
void  S9984C1 ::v24(){vfunc_called(this, "_ZN7S9984C13v24Ev");}
void  S9984C1 ::v25(){vfunc_called(this, "_ZN7S9984C13v25Ev");}
void  S9984C1 ::v26(){vfunc_called(this, "_ZN7S9984C13v26Ev");}
void  S9984C1 ::v27(){vfunc_called(this, "_ZN7S9984C13v27Ev");}
void  S9984C1 ::v28(){vfunc_called(this, "_ZN7S9984C13v28Ev");}
void  S9984C1 ::v29(){vfunc_called(this, "_ZN7S9984C13v29Ev");}
void  S9984C1 ::v30(){vfunc_called(this, "_ZN7S9984C13v30Ev");}
void  S9984C1 ::v31(){vfunc_called(this, "_ZN7S9984C13v31Ev");}
void  S9984C1 ::v32(){vfunc_called(this, "_ZN7S9984C13v32Ev");}
void  S9984C1 ::v33(){vfunc_called(this, "_ZN7S9984C13v33Ev");}
void  S9984C1 ::v34(){vfunc_called(this, "_ZN7S9984C13v34Ev");}
void  S9984C1 ::v35(){vfunc_called(this, "_ZN7S9984C13v35Ev");}
void  S9984C1 ::v36(){vfunc_called(this, "_ZN7S9984C13v36Ev");}
void  S9984C1 ::v37(){vfunc_called(this, "_ZN7S9984C13v37Ev");}
void  S9984C1 ::v38(){vfunc_called(this, "_ZN7S9984C13v38Ev");}
void  S9984C1 ::v39(){vfunc_called(this, "_ZN7S9984C13v39Ev");}
void  S9984C1 ::v40(){vfunc_called(this, "_ZN7S9984C13v40Ev");}
void  S9984C1 ::v41(){vfunc_called(this, "_ZN7S9984C13v41Ev");}
void  S9984C1 ::v42(){vfunc_called(this, "_ZN7S9984C13v42Ev");}
void  S9984C1 ::v43(){vfunc_called(this, "_ZN7S9984C13v43Ev");}
void  S9984C1 ::v44(){vfunc_called(this, "_ZN7S9984C13v44Ev");}
void  S9984C1 ::v45(){vfunc_called(this, "_ZN7S9984C13v45Ev");}
void  S9984C1 ::v46(){vfunc_called(this, "_ZN7S9984C13v46Ev");}
void  S9984C1 ::v47(){vfunc_called(this, "_ZN7S9984C13v47Ev");}
void  S9984C1 ::v48(){vfunc_called(this, "_ZN7S9984C13v48Ev");}
void  S9984C1 ::v49(){vfunc_called(this, "_ZN7S9984C13v49Ev");}
void  S9984C1 ::v50(){vfunc_called(this, "_ZN7S9984C13v50Ev");}
void  S9984C1 ::v51(){vfunc_called(this, "_ZN7S9984C13v51Ev");}
void  S9984C1 ::v52(){vfunc_called(this, "_ZN7S9984C13v52Ev");}
void  S9984C1 ::v53(){vfunc_called(this, "_ZN7S9984C13v53Ev");}
void  S9984C1 ::v54(){vfunc_called(this, "_ZN7S9984C13v54Ev");}
void  S9984C1 ::v55(){vfunc_called(this, "_ZN7S9984C13v55Ev");}
void  S9984C1 ::v56(){vfunc_called(this, "_ZN7S9984C13v56Ev");}
void  S9984C1 ::v57(){vfunc_called(this, "_ZN7S9984C13v57Ev");}
S9984C1 ::S9984C1(){ note_ctor("S9984C1", this);} // tgen

static void Test_S9984C1()
{
  extern Class_Descriptor cd_S9984C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(8,12)];
    init_test(&cd_S9984C1, buf);
    S9984C1 *dp, &lv = *(dp=new (buf) S9984C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,44), "sizeof(S9984C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S9984C1)");
    check_base_class_offset(lv, (S9984C2*), 0, "S9984C1");
    check_field_offset(lv, s9984c1f0, ABISELECT(8,4), "S9984C1.s9984c1f0");
    check_field_offset(lv, s9984c1f1, ABISELECT(40,36), "S9984C1.s9984c1f1");
    check_field_offset(lv, s9984c1f2, ABISELECT(48,40), "S9984C1.s9984c1f2");
    test_class_info(&lv, &cd_S9984C1);
    dp->~S9984C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS9984C1(Test_S9984C1, "S9984C1", ABISELECT(56,44));

#else // __cplusplus

extern void _ZN7S9984C1C1Ev();
extern void _ZN7S9984C1D1Ev();
Name_Map name_map_S9984C1[] = {
  NSPAIR(_ZN7S9984C1C1Ev),
  NSPAIR(_ZN7S9984C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S9984C2;
extern VTBL_ENTRY _ZTI7S9984C2[];
extern  VTBL_ENTRY _ZTV7S9984C2[];
static Base_Class bases_S9984C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S9984C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S9984C1[];
extern void _ZN7S9984C1D1Ev();
extern void _ZN7S9984C1D0Ev();
extern void _ZN7S9984C23v58Ev();
extern void _ZN7S9984C23v59Ev();
extern void _ZN7S9984C23v60Ev();
extern void _ZN7S9984C23v61Ev();
extern void _ZN7S9984C23v62Ev();
extern void _ZN7S9984C23v63Ev();
extern void _ZN7S9984C23v64Ev();
extern void _ZN7S9984C23v65Ev();
extern void _ZN7S9984C23v66Ev();
extern void _ZN7S9984C23v67Ev();
extern void _ZN7S9984C23v68Ev();
extern void _ZN7S9984C23v69Ev();
extern void _ZN7S9984C23v70Ev();
extern void _ZN7S9984C23v71Ev();
extern void _ZN7S9984C23v72Ev();
extern void _ZN7S9984C23v73Ev();
extern void _ZN7S9984C23v74Ev();
extern void _ZN7S9984C23v75Ev();
extern void _ZN7S9984C23v76Ev();
extern void _ZN7S9984C23v77Ev();
extern void _ZN7S9984C23v78Ev();
extern void _ZN7S9984C23v79Ev();
extern void _ZN7S9984C23v80Ev();
extern void _ZN7S9984C23v81Ev();
extern void _ZN7S9984C23v82Ev();
extern void _ZN7S9984C23v83Ev();
extern void _ZN7S9984C23v84Ev();
extern void _ZN7S9984C23v85Ev();
extern void _ZN7S9984C23v86Ev();
extern void _ZN7S9984C23v87Ev();
extern void _ZN7S9984C23v88Ev();
extern void _ZN7S9984C23v89Ev();
extern void _ZN7S9984C23v90Ev();
extern void _ZN7S9984C23v91Ev();
extern void _ZN7S9984C23v92Ev();
extern void _ZN7S9984C23v93Ev();
extern void _ZN7S9984C23v94Ev();
extern void _ZN7S9984C23v95Ev();
extern void _ZN7S9984C23v96Ev();
extern void _ZN7S9984C23v97Ev();
extern void _ZN7S9984C23v98Ev();
extern void _ZN7S9984C23v99Ev();
extern void _ZN7S9984C24v100Ev();
extern void _ZN7S9984C24v101Ev();
extern void _ZN7S9984C24v102Ev();
extern void _ZN7S9984C24v103Ev();
extern void _ZN7S9984C24v104Ev();
extern void _ZN7S9984C24v105Ev();
extern void _ZN7S9984C24v106Ev();
extern void _ZN7S9984C24v107Ev();
extern void _ZN7S9984C24v108Ev();
extern void _ZN7S9984C24v109Ev();
extern void _ZN7S9984C24v110Ev();
extern void _ZN7S9984C24v111Ev();
extern void _ZN7S9984C24v112Ev();
extern void _ZN7S9984C24v113Ev();
extern void _ZN7S9984C24v114Ev();
extern void _ZN7S9984C12v1Ev();
extern void _ZN7S9984C12v2Ev();
extern void _ZN7S9984C12v3Ev();
extern void _ZN7S9984C12v4Ev();
extern void _ZN7S9984C12v5Ev();
extern void _ZN7S9984C12v6Ev();
extern void _ZN7S9984C12v7Ev();
extern void _ZN7S9984C12v8Ev();
extern void _ZN7S9984C12v9Ev();
extern void _ZN7S9984C13v10Ev();
extern void _ZN7S9984C13v11Ev();
extern void _ZN7S9984C13v12Ev();
extern void _ZN7S9984C13v13Ev();
extern void _ZN7S9984C13v14Ev();
extern void _ZN7S9984C13v15Ev();
extern void _ZN7S9984C13v16Ev();
extern void _ZN7S9984C13v17Ev();
extern void _ZN7S9984C13v18Ev();
extern void _ZN7S9984C13v19Ev();
extern void _ZN7S9984C13v20Ev();
extern void _ZN7S9984C13v21Ev();
extern void _ZN7S9984C13v22Ev();
extern void _ZN7S9984C13v23Ev();
extern void _ZN7S9984C13v24Ev();
extern void _ZN7S9984C13v25Ev();
extern void _ZN7S9984C13v26Ev();
extern void _ZN7S9984C13v27Ev();
extern void _ZN7S9984C13v28Ev();
extern void _ZN7S9984C13v29Ev();
extern void _ZN7S9984C13v30Ev();
extern void _ZN7S9984C13v31Ev();
extern void _ZN7S9984C13v32Ev();
extern void _ZN7S9984C13v33Ev();
extern void _ZN7S9984C13v34Ev();
extern void _ZN7S9984C13v35Ev();
extern void _ZN7S9984C13v36Ev();
extern void _ZN7S9984C13v37Ev();
extern void _ZN7S9984C13v38Ev();
extern void _ZN7S9984C13v39Ev();
extern void _ZN7S9984C13v40Ev();
extern void _ZN7S9984C13v41Ev();
extern void _ZN7S9984C13v42Ev();
extern void _ZN7S9984C13v43Ev();
extern void _ZN7S9984C13v44Ev();
extern void _ZN7S9984C13v45Ev();
extern void _ZN7S9984C13v46Ev();
extern void _ZN7S9984C13v47Ev();
extern void _ZN7S9984C13v48Ev();
extern void _ZN7S9984C13v49Ev();
extern void _ZN7S9984C13v50Ev();
extern void _ZN7S9984C13v51Ev();
extern void _ZN7S9984C13v52Ev();
extern void _ZN7S9984C13v53Ev();
extern void _ZN7S9984C13v54Ev();
extern void _ZN7S9984C13v55Ev();
extern void _ZN7S9984C13v56Ev();
extern void _ZN7S9984C13v57Ev();
static  VTBL_ENTRY vtc_S9984C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S9984C1[0]),
  (VTBL_ENTRY)&_ZN7S9984C1D1Ev,
  (VTBL_ENTRY)&_ZN7S9984C1D0Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v58Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v59Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v60Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v61Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v62Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v63Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v64Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v65Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v66Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v67Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v68Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v69Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v70Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v71Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v72Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v73Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v74Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v75Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v76Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v77Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v78Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v79Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v80Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v81Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v82Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v83Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v84Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v85Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v86Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v87Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v88Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v89Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v90Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v91Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v92Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v93Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v94Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v95Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v96Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v97Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v98Ev,
  (VTBL_ENTRY)&_ZN7S9984C23v99Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v100Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v101Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v102Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v103Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v104Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v105Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v106Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v107Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v108Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v109Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v110Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v111Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v112Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v113Ev,
  (VTBL_ENTRY)&_ZN7S9984C24v114Ev,
  (VTBL_ENTRY)&_ZN7S9984C12v1Ev,
  (VTBL_ENTRY)&_ZN7S9984C12v2Ev,
  (VTBL_ENTRY)&_ZN7S9984C12v3Ev,
  (VTBL_ENTRY)&_ZN7S9984C12v4Ev,
  (VTBL_ENTRY)&_ZN7S9984C12v5Ev,
  (VTBL_ENTRY)&_ZN7S9984C12v6Ev,
  (VTBL_ENTRY)&_ZN7S9984C12v7Ev,
  (VTBL_ENTRY)&_ZN7S9984C12v8Ev,
  (VTBL_ENTRY)&_ZN7S9984C12v9Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v10Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v11Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v12Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v13Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v14Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v15Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v16Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v17Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v18Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v19Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v20Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v21Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v22Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v23Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v24Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v25Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v26Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v27Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v28Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v29Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v30Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v31Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v32Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v33Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v34Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v35Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v36Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v37Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v38Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v39Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v40Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v41Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v42Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v43Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v44Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v45Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v46Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v47Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v48Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v49Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v50Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v51Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v52Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v53Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v54Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v55Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v56Ev,
  (VTBL_ENTRY)&_ZN7S9984C13v57Ev,
};
extern VTBL_ENTRY _ZTI7S9984C1[];
extern  VTBL_ENTRY _ZTV7S9984C1[];
Class_Descriptor cd_S9984C1 = {  "S9984C1", // class name
  bases_S9984C1, 1,
  &(vtc_S9984C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(56,44), // object size
  NSPAIRA(_ZTI7S9984C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S9984C1),118, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3592C2  : S4216C11 {
  void *s3592c2f0[2];
  int s3592c2f1;
  ::S4216C72 s3592c2f2;
  int s3592c2f3[3];
  char s3592c2f4;
  virtual  ~S3592C2(); // _ZN7S3592C2D1Ev
  virtual void  v2(); // _ZN7S3592C22v2Ev
  virtual void  v3(); // _ZN7S3592C22v3Ev
  virtual void  v4(); // _ZN7S3592C22v4Ev
  S3592C2(); // tgen
};
//SIG(-1 S3592C2) C1{ BC2{ vd m FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}}} vd v1 v2 v3 Fp[2] Fi FC7{ m Fp Fi[2] FC8{ m}} Fi[3] Fc}


 S3592C2 ::~S3592C2(){ note_dtor("S3592C2", this);}
void  S3592C2 ::v2(){vfunc_called(this, "_ZN7S3592C22v2Ev");}
void  S3592C2 ::v3(){vfunc_called(this, "_ZN7S3592C22v3Ev");}
void  S3592C2 ::v4(){vfunc_called(this, "_ZN7S3592C22v4Ev");}
S3592C2 ::S3592C2(){ note_ctor("S3592C2", this);} // tgen

static void Test_S3592C2()
{
  extern Class_Descriptor cd_S3592C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,16)];
    init_test(&cd_S3592C2, buf);
    S3592C2 *dp, &lv = *(dp=new (buf) S3592C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,60), "sizeof(S3592C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3592C2)");
    check_base_class_offset(lv, (S4216C11*), 0, "S3592C2");
    check_field_offset(lv, s3592c2f0, ABISELECT(24,16), "S3592C2.s3592c2f0");
    check_field_offset(lv, s3592c2f1, ABISELECT(40,24), "S3592C2.s3592c2f1");
    check_field_offset(lv, s3592c2f2, ABISELECT(48,28), "S3592C2.s3592c2f2");
    check_field_offset(lv, s3592c2f3, ABISELECT(72,44), "S3592C2.s3592c2f3");
    check_field_offset(lv, s3592c2f4, ABISELECT(84,56), "S3592C2.s3592c2f4");
    test_class_info(&lv, &cd_S3592C2);
    dp->~S3592C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3592C2(Test_S3592C2, "S3592C2", ABISELECT(88,60));

#else // __cplusplus

extern void _ZN7S3592C2C1Ev();
extern void _ZN7S3592C2D1Ev();
Name_Map name_map_S3592C2[] = {
  NSPAIR(_ZN7S3592C2C1Ev),
  NSPAIR(_ZN7S3592C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C11;
extern VTBL_ENTRY _ZTI8S4216C11[];
extern  VTBL_ENTRY _ZTV8S4216C11[];
static Base_Class bases_S3592C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3592C2[];
extern void _ZN7S3592C2D1Ev();
extern void _ZN7S3592C2D0Ev();
extern void _ZN7S3592C22v2Ev();
extern void _ZN7S3592C22v3Ev();
extern void _ZN7S3592C22v4Ev();
static  VTBL_ENTRY vtc_S3592C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3592C2[0]),
  (VTBL_ENTRY)&_ZN7S3592C2D1Ev,
  (VTBL_ENTRY)&_ZN7S3592C2D0Ev,
  (VTBL_ENTRY)&_ZN7S3592C22v2Ev,
  (VTBL_ENTRY)&_ZN7S3592C22v3Ev,
  (VTBL_ENTRY)&_ZN7S3592C22v4Ev,
};
extern VTBL_ENTRY _ZTI7S3592C2[];
extern  VTBL_ENTRY _ZTV7S3592C2[];
Class_Descriptor cd_S3592C2 = {  "S3592C2", // class name
  bases_S3592C2, 1,
  &(vtc_S3592C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(88,60), // object size
  NSPAIRA(_ZTI7S3592C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3592C2),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3592C18  {
  int s3592c18f0[2];
  char s3592c18f1[5];
  int s3592c18f2;
  void  mf3592c18(); // _ZN8S3592C189mf3592c18Ev
};
//SIG(-1 S3592C18) C1{ m Fi[2] Fc[5] Fi}


void  S3592C18 ::mf3592c18(){}

static void Test_S3592C18()
{
  {
    init_simple_test("S3592C18");
    S3592C18 lv;
    check2(sizeof(lv), 20, "sizeof(S3592C18)");
    check2(__alignof__(lv), 4, "__alignof__(S3592C18)");
    check_field_offset(lv, s3592c18f0, 0, "S3592C18.s3592c18f0");
    check_field_offset(lv, s3592c18f1, 8, "S3592C18.s3592c18f1");
    check_field_offset(lv, s3592c18f2, 16, "S3592C18.s3592c18f2");
  }
}
static Arrange_To_Call_Me vS3592C18(Test_S3592C18, "S3592C18", 20);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3592C21_nt  {
  void *s3592c21f0[2];
  void  mf3592c21(); // _ZN11S3592C21_nt9mf3592c21Ev
};
//SIG(-1 S3592C21_nt) C1{ m Fp[2]}


void  S3592C21_nt ::mf3592c21(){}

//skip512 S3592C21_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3592C25_nt  {
  void *s3592c25f0;
  int s3592c25f1;
  ::S4216C78 s3592c25f2;
  ::S4216C65 s3592c25f3;
  void  mf3592c25(); // _ZN11S3592C25_nt9mf3592c25Ev
};
//SIG(-1 S3592C25_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S3592C25_nt ::mf3592c25(){}

//skip512 S3592C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3592C1  : S3592C2 {
  void *s3592c1f0[6];
  ::S9983C6 s3592c1f1;
  void *s3592c1f2[6];
  int s3592c1f3;
  ::S4216C64 s3592c1f4;
  int s3592c1f5;
  void *s3592c1f6[2];
  char s3592c1f7;
  void *s3592c1f8[2];
  char s3592c1f9[3];
  void *s3592c1f10;
  int s3592c1f11;
  ::S4216C77 s3592c1f12;
  int s3592c1f13;
  char s3592c1f14[3];
  int s3592c1f15[4];
  char s3592c1f16;
  void *s3592c1f17;
  int s3592c1f18[3];
  char s3592c1f19[2];
  ::S9983C6 s3592c1f20;
  int s3592c1f21[2];
  void *s3592c1f22;
  ::S9983C6 s3592c1f23;
  int s3592c1f24;
  ::S4216C22_nt s3592c1f25;
  ::S4216C22_nt s3592c1f26;
  ::S3592C18 s3592c1f27;
  int s3592c1f28;
  char s3592c1f29;
  int s3592c1f30;
  void *s3592c1f31[2];
  char s3592c1f32[2];
  ::S4216C58 s3592c1f33;
  char s3592c1f34;
  int s3592c1f35;
  char s3592c1f36[2];
  void *s3592c1f37;
  ::S3592C21_nt s3592c1f38;
  void *s3592c1f39;
  char s3592c1f40;
  int s3592c1f41;
  char s3592c1f42;
  int s3592c1f43;
  ::S4216C13_nt s3592c1f44;
  ::S3592C25_nt s3592c1f45;
  virtual  ~S3592C1(); // _ZN7S3592C1D1Ev
  virtual void  v1(); // _ZN7S3592C12v1Ev
  S3592C1(); // tgen
};
//SIG(1 S3592C1) C1{ BC2{ BC3{ vd m FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}}} vd v2 v3 v4 Fp[2] Fi FC8{ m Fp Fi[2] FC9{ m}} Fi[3] Fc} vd v1 Fp[6] FC10{ m Fp} Fp[6] Fi FC11{ m Fp Fi[2] FC9} Fi Fp[2] Fc Fp[2] Fc[3] Fp Fi FC12{ m Fp Fi FC13{ m} FC13} Fi Fc[3] Fi[4] Fc Fp Fi[3] Fc[2] FC10 Fi[2] Fp FC10 Fi FC14{ m Fp Fi FC7} FC14 FC15{ m Fi[2] Fc[5] Fi} Fi Fc Fi Fp[2] Fc[2] FC16{ m Fp Fi[2] FC17{ m}} Fc Fi Fc[2] Fp FC18{ m Fp[2]} Fp Fc Fi Fc Fi FC5 FC19{ m Fp Fi FC13 FC9}}


 S3592C1 ::~S3592C1(){ note_dtor("S3592C1", this);}
void  S3592C1 ::v1(){vfunc_called(this, "_ZN7S3592C12v1Ev");}
S3592C1 ::S3592C1(){ note_ctor("S3592C1", this);} // tgen

static void Test_S3592C1()
{
  extern Class_Descriptor cd_S3592C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(78,102)];
    init_test(&cd_S3592C1, buf);
    S3592C1 *dp, &lv = *(dp=new (buf) S3592C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(616,404), "sizeof(S3592C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3592C1)");
    check_base_class_offset(lv, (S4216C11*)(S3592C2*), 0, "S3592C1");
    check_base_class_offset(lv, (S3592C2*), 0, "S3592C1");
    check_field_offset(lv, s3592c1f0, ABISELECT(88,60), "S3592C1.s3592c1f0");
    check_field_offset(lv, s3592c1f1, ABISELECT(136,84), "S3592C1.s3592c1f1");
    check_field_offset(lv, s3592c1f2, ABISELECT(144,88), "S3592C1.s3592c1f2");
    check_field_offset(lv, s3592c1f3, ABISELECT(192,112), "S3592C1.s3592c1f3");
    check_field_offset(lv, s3592c1f4, ABISELECT(200,116), "S3592C1.s3592c1f4");
    check_field_offset(lv, s3592c1f5, ABISELECT(224,132), "S3592C1.s3592c1f5");
    check_field_offset(lv, s3592c1f6, ABISELECT(232,136), "S3592C1.s3592c1f6");
    check_field_offset(lv, s3592c1f7, ABISELECT(248,144), "S3592C1.s3592c1f7");
    check_field_offset(lv, s3592c1f8, ABISELECT(256,148), "S3592C1.s3592c1f8");
    check_field_offset(lv, s3592c1f9, ABISELECT(272,156), "S3592C1.s3592c1f9");
    check_field_offset(lv, s3592c1f10, ABISELECT(280,160), "S3592C1.s3592c1f10");
    check_field_offset(lv, s3592c1f11, ABISELECT(288,164), "S3592C1.s3592c1f11");
    check_field_offset(lv, s3592c1f12, ABISELECT(296,168), "S3592C1.s3592c1f12");
    check_field_offset(lv, s3592c1f13, ABISELECT(312,180), "S3592C1.s3592c1f13");
    check_field_offset(lv, s3592c1f14, ABISELECT(316,184), "S3592C1.s3592c1f14");
    check_field_offset(lv, s3592c1f15, ABISELECT(320,188), "S3592C1.s3592c1f15");
    check_field_offset(lv, s3592c1f16, ABISELECT(336,204), "S3592C1.s3592c1f16");
    check_field_offset(lv, s3592c1f17, ABISELECT(344,208), "S3592C1.s3592c1f17");
    check_field_offset(lv, s3592c1f18, ABISELECT(352,212), "S3592C1.s3592c1f18");
    check_field_offset(lv, s3592c1f19, ABISELECT(364,224), "S3592C1.s3592c1f19");
    check_field_offset(lv, s3592c1f20, ABISELECT(368,228), "S3592C1.s3592c1f20");
    check_field_offset(lv, s3592c1f21, ABISELECT(376,232), "S3592C1.s3592c1f21");
    check_field_offset(lv, s3592c1f22, ABISELECT(384,240), "S3592C1.s3592c1f22");
    check_field_offset(lv, s3592c1f23, ABISELECT(392,244), "S3592C1.s3592c1f23");
    check_field_offset(lv, s3592c1f24, ABISELECT(400,248), "S3592C1.s3592c1f24");
    check_field_offset(lv, s3592c1f25, ABISELECT(408,252), "S3592C1.s3592c1f25");
    check_field_offset(lv, s3592c1f26, ABISELECT(424,264), "S3592C1.s3592c1f26");
    check_field_offset(lv, s3592c1f27, ABISELECT(440,276), "S3592C1.s3592c1f27");
    check_field_offset(lv, s3592c1f28, ABISELECT(460,296), "S3592C1.s3592c1f28");
    check_field_offset(lv, s3592c1f29, ABISELECT(464,300), "S3592C1.s3592c1f29");
    check_field_offset(lv, s3592c1f30, ABISELECT(468,304), "S3592C1.s3592c1f30");
    check_field_offset(lv, s3592c1f31, ABISELECT(472,308), "S3592C1.s3592c1f31");
    check_field_offset(lv, s3592c1f32, ABISELECT(488,316), "S3592C1.s3592c1f32");
    check_field_offset(lv, s3592c1f33, ABISELECT(496,320), "S3592C1.s3592c1f33");
    check_field_offset(lv, s3592c1f34, ABISELECT(520,336), "S3592C1.s3592c1f34");
    check_field_offset(lv, s3592c1f35, ABISELECT(524,340), "S3592C1.s3592c1f35");
    check_field_offset(lv, s3592c1f36, ABISELECT(528,344), "S3592C1.s3592c1f36");
    check_field_offset(lv, s3592c1f37, ABISELECT(536,348), "S3592C1.s3592c1f37");
    check_field_offset(lv, s3592c1f38, ABISELECT(544,352), "S3592C1.s3592c1f38");
    check_field_offset(lv, s3592c1f39, ABISELECT(560,360), "S3592C1.s3592c1f39");
    check_field_offset(lv, s3592c1f40, ABISELECT(568,364), "S3592C1.s3592c1f40");
    check_field_offset(lv, s3592c1f41, ABISELECT(572,368), "S3592C1.s3592c1f41");
    check_field_offset(lv, s3592c1f42, ABISELECT(576,372), "S3592C1.s3592c1f42");
    check_field_offset(lv, s3592c1f43, ABISELECT(580,376), "S3592C1.s3592c1f43");
    check_field_offset(lv, s3592c1f44, ABISELECT(584,380), "S3592C1.s3592c1f44");
    check_field_offset(lv, s3592c1f45, ABISELECT(600,392), "S3592C1.s3592c1f45");
    test_class_info(&lv, &cd_S3592C1);
    dp->~S3592C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3592C1(Test_S3592C1, "S3592C1", ABISELECT(616,404));

#else // __cplusplus

extern void _ZN7S3592C1C1Ev();
extern void _ZN7S3592C1D1Ev();
Name_Map name_map_S3592C1[] = {
  NSPAIR(_ZN7S3592C1C1Ev),
  NSPAIR(_ZN7S3592C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4216C11;
extern VTBL_ENTRY _ZTI8S4216C11[];
extern  VTBL_ENTRY _ZTV8S4216C11[];
extern Class_Descriptor cd_S3592C2;
extern VTBL_ENTRY _ZTI7S3592C2[];
extern  VTBL_ENTRY _ZTV7S3592C2[];
static Base_Class bases_S3592C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4216C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3592C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3592C1[];
extern void _ZN7S3592C1D1Ev();
extern void _ZN7S3592C1D0Ev();
extern void _ZN7S3592C22v2Ev();
extern void _ZN7S3592C22v3Ev();
extern void _ZN7S3592C22v4Ev();
extern void _ZN7S3592C12v1Ev();
static  VTBL_ENTRY vtc_S3592C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3592C1[0]),
  (VTBL_ENTRY)&_ZN7S3592C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3592C1D0Ev,
  (VTBL_ENTRY)&_ZN7S3592C22v2Ev,
  (VTBL_ENTRY)&_ZN7S3592C22v3Ev,
  (VTBL_ENTRY)&_ZN7S3592C22v4Ev,
  (VTBL_ENTRY)&_ZN7S3592C12v1Ev,
};
extern VTBL_ENTRY _ZTI7S3592C1[];
extern  VTBL_ENTRY _ZTV7S3592C1[];
Class_Descriptor cd_S3592C1 = {  "S3592C1", // class name
  bases_S3592C1, 2,
  &(vtc_S3592C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(616,404), // object size
  NSPAIRA(_ZTI7S3592C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3592C1),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2009C4  {
  virtual  ~S2009C4(); // _ZN7S2009C4D1Ev
  virtual void  v10(); // _ZN7S2009C43v10Ev
  virtual void  v11(); // _ZN7S2009C43v11Ev
  virtual void  v12(); // _ZN7S2009C43v12Ev
  S2009C4(); // tgen
};
//SIG(-1 S2009C4) C1{ vd v1 v2 v3}


 S2009C4 ::~S2009C4(){ note_dtor("S2009C4", this);}
void  S2009C4 ::v10(){vfunc_called(this, "_ZN7S2009C43v10Ev");}
void  S2009C4 ::v11(){vfunc_called(this, "_ZN7S2009C43v11Ev");}
void  S2009C4 ::v12(){vfunc_called(this, "_ZN7S2009C43v12Ev");}
S2009C4 ::S2009C4(){ note_ctor("S2009C4", this);} // tgen

static void Test_S2009C4()
{
  extern Class_Descriptor cd_S2009C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2009C4, buf);
    S2009C4 *dp, &lv = *(dp=new (buf) S2009C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2009C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2009C4)");
    test_class_info(&lv, &cd_S2009C4);
    dp->~S2009C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2009C4(Test_S2009C4, "S2009C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2009C4C1Ev();
extern void _ZN7S2009C4D1Ev();
Name_Map name_map_S2009C4[] = {
  NSPAIR(_ZN7S2009C4C1Ev),
  NSPAIR(_ZN7S2009C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2009C4[];
extern void _ZN7S2009C4D1Ev();
extern void _ZN7S2009C4D0Ev();
extern void _ZN7S2009C43v10Ev();
extern void _ZN7S2009C43v11Ev();
extern void _ZN7S2009C43v12Ev();
static  VTBL_ENTRY vtc_S2009C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2009C4[0]),
  (VTBL_ENTRY)&_ZN7S2009C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2009C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v12Ev,
};
extern VTBL_ENTRY _ZTI7S2009C4[];
extern  VTBL_ENTRY _ZTV7S2009C4[];
Class_Descriptor cd_S2009C4 = {  "S2009C4", // class name
  0,0,//no base classes
  &(vtc_S2009C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2009C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2009C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2009C3_nt  : S2009C4 {
  virtual  ~S2009C3_nt(); // _ZN10S2009C3_ntD1Ev
  virtual void  v13(); // _ZN10S2009C3_nt3v13Ev
  virtual void  v14(); // _ZN10S2009C3_nt3v14Ev
  virtual void  v15(); // _ZN10S2009C3_nt3v15Ev
  virtual void  v16(); // _ZN10S2009C3_nt3v16Ev
  S2009C3_nt(); // tgen
};
//SIG(-1 S2009C3_nt) C1{ BC2{ vd v5 v6 v7} vd v1 v2 v3 v4}


 S2009C3_nt ::~S2009C3_nt(){ note_dtor("S2009C3_nt", this);}
void  S2009C3_nt ::v13(){vfunc_called(this, "_ZN10S2009C3_nt3v13Ev");}
void  S2009C3_nt ::v14(){vfunc_called(this, "_ZN10S2009C3_nt3v14Ev");}
void  S2009C3_nt ::v15(){vfunc_called(this, "_ZN10S2009C3_nt3v15Ev");}
void  S2009C3_nt ::v16(){vfunc_called(this, "_ZN10S2009C3_nt3v16Ev");}
S2009C3_nt ::S2009C3_nt(){ note_ctor("S2009C3_nt", this);} // tgen

//skip512 S2009C3_nt

#else // __cplusplus

extern void _ZN10S2009C3_ntC1Ev();
extern void _ZN10S2009C3_ntD1Ev();
Name_Map name_map_S2009C3_nt[] = {
  NSPAIR(_ZN10S2009C3_ntC1Ev),
  NSPAIR(_ZN10S2009C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2009C4;
extern VTBL_ENTRY _ZTI7S2009C4[];
extern  VTBL_ENTRY _ZTV7S2009C4[];
static Base_Class bases_S2009C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2009C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2009C3_nt[];
extern void _ZN10S2009C3_ntD1Ev();
extern void _ZN10S2009C3_ntD0Ev();
extern void _ZN7S2009C43v10Ev();
extern void _ZN7S2009C43v11Ev();
extern void _ZN7S2009C43v12Ev();
extern void _ZN10S2009C3_nt3v13Ev();
extern void _ZN10S2009C3_nt3v14Ev();
extern void _ZN10S2009C3_nt3v15Ev();
extern void _ZN10S2009C3_nt3v16Ev();
static  VTBL_ENTRY vtc_S2009C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2009C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2009C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v12Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v16Ev,
};
extern VTBL_ENTRY _ZTI10S2009C3_nt[];
VTBL_ENTRY *P__ZTI10S2009C3_nt = _ZTI10S2009C3_nt; 
extern  VTBL_ENTRY _ZTV10S2009C3_nt[];
Class_Descriptor cd_S2009C3_nt = {  "S2009C3_nt", // class name
  bases_S2009C3_nt, 1,
  &(vtc_S2009C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S2009C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2009C3_nt),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2009C2_nt  : S2009C3_nt {
  ::S4216C72 s2009c2f0;
  ::S4217C6_nt s2009c2f1;
  char s2009c2f2;
  virtual  ~S2009C2_nt(); // _ZN10S2009C2_ntD1Ev
  virtual void  v17(); // _ZN10S2009C2_nt3v17Ev
  virtual void  v18(); // _ZN10S2009C2_nt3v18Ev
  virtual void  v19(); // _ZN10S2009C2_nt3v19Ev
  S2009C2_nt(); // tgen
};
//SIG(-1 S2009C2_nt) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc}


 S2009C2_nt ::~S2009C2_nt(){ note_dtor("S2009C2_nt", this);}
void  S2009C2_nt ::v17(){vfunc_called(this, "_ZN10S2009C2_nt3v17Ev");}
void  S2009C2_nt ::v18(){vfunc_called(this, "_ZN10S2009C2_nt3v18Ev");}
void  S2009C2_nt ::v19(){vfunc_called(this, "_ZN10S2009C2_nt3v19Ev");}
S2009C2_nt ::S2009C2_nt(){ note_ctor("S2009C2_nt", this);} // tgen

//skip512 S2009C2_nt

#else // __cplusplus

extern void _ZN10S2009C2_ntC1Ev();
extern void _ZN10S2009C2_ntD1Ev();
Name_Map name_map_S2009C2_nt[] = {
  NSPAIR(_ZN10S2009C2_ntC1Ev),
  NSPAIR(_ZN10S2009C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2009C4;
extern VTBL_ENTRY _ZTI7S2009C4[];
extern  VTBL_ENTRY _ZTV7S2009C4[];
extern Class_Descriptor cd_S2009C3_nt;
extern VTBL_ENTRY _ZTI10S2009C3_nt[];
extern  VTBL_ENTRY _ZTV10S2009C3_nt[];
static Base_Class bases_S2009C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2009C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2009C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2009C2_nt[];
extern void _ZN10S2009C2_ntD1Ev();
extern void _ZN10S2009C2_ntD0Ev();
extern void _ZN7S2009C43v10Ev();
extern void _ZN7S2009C43v11Ev();
extern void _ZN7S2009C43v12Ev();
extern void _ZN10S2009C3_nt3v13Ev();
extern void _ZN10S2009C3_nt3v14Ev();
extern void _ZN10S2009C3_nt3v15Ev();
extern void _ZN10S2009C3_nt3v16Ev();
extern void _ZN10S2009C2_nt3v17Ev();
extern void _ZN10S2009C2_nt3v18Ev();
extern void _ZN10S2009C2_nt3v19Ev();
static  VTBL_ENTRY vtc_S2009C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2009C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2009C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2009C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v12Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2009C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2009C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2009C2_nt3v19Ev,
};
extern VTBL_ENTRY _ZTI10S2009C2_nt[];
VTBL_ENTRY *P__ZTI10S2009C2_nt = _ZTI10S2009C2_nt; 
extern  VTBL_ENTRY _ZTV10S2009C2_nt[];
Class_Descriptor cd_S2009C2_nt = {  "S2009C2_nt", // class name
  bases_S2009C2_nt, 2,
  &(vtc_S2009C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI10S2009C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2009C2_nt),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2009C15_nt  {
  ::S4217C7_nt s2009c15f0;
  void  mf2009c15(); // _ZN11S2009C15_nt9mf2009c15Ev
};
//SIG(-1 S2009C15_nt) C1{ m FC2{ FL[4]}}


void  S2009C15_nt ::mf2009c15(){}

//skip512 S2009C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2009C10_nt  {
  void *s2009c10f0;
  ::S4216C12_nt s2009c10f1;
  ::S2009C15_nt s2009c10f2;
  char s2009c10f3;
  virtual  ~S2009C10_nt(); // _ZN11S2009C10_ntD1Ev
  virtual void  v20(); // _ZN11S2009C10_nt3v20Ev
  virtual void  v21(); // _ZN11S2009C10_nt3v21Ev
  virtual void  v22(); // _ZN11S2009C10_nt3v22Ev
  virtual void  v23(); // _ZN11S2009C10_nt3v23Ev
  virtual void  v24(); // _ZN11S2009C10_nt3v24Ev
  virtual void  v25(); // _ZN11S2009C10_nt3v25Ev
  virtual void  v26(); // _ZN11S2009C10_nt3v26Ev
  virtual void  v27(); // _ZN11S2009C10_nt3v27Ev
  virtual void  v28(); // _ZN11S2009C10_nt3v28Ev
  virtual void  v29(); // _ZN11S2009C10_nt3v29Ev
  virtual void  v30(); // _ZN11S2009C10_nt3v30Ev
  virtual void  v31(); // _ZN11S2009C10_nt3v31Ev
  S2009C10_nt(); // tgen
};
//SIG(-1 S2009C10_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ m FC7{ FL[4]}} Fc}


 S2009C10_nt ::~S2009C10_nt(){ note_dtor("S2009C10_nt", this);}
void  S2009C10_nt ::v20(){vfunc_called(this, "_ZN11S2009C10_nt3v20Ev");}
void  S2009C10_nt ::v21(){vfunc_called(this, "_ZN11S2009C10_nt3v21Ev");}
void  S2009C10_nt ::v22(){vfunc_called(this, "_ZN11S2009C10_nt3v22Ev");}
void  S2009C10_nt ::v23(){vfunc_called(this, "_ZN11S2009C10_nt3v23Ev");}
void  S2009C10_nt ::v24(){vfunc_called(this, "_ZN11S2009C10_nt3v24Ev");}
void  S2009C10_nt ::v25(){vfunc_called(this, "_ZN11S2009C10_nt3v25Ev");}
void  S2009C10_nt ::v26(){vfunc_called(this, "_ZN11S2009C10_nt3v26Ev");}
void  S2009C10_nt ::v27(){vfunc_called(this, "_ZN11S2009C10_nt3v27Ev");}
void  S2009C10_nt ::v28(){vfunc_called(this, "_ZN11S2009C10_nt3v28Ev");}
void  S2009C10_nt ::v29(){vfunc_called(this, "_ZN11S2009C10_nt3v29Ev");}
void  S2009C10_nt ::v30(){vfunc_called(this, "_ZN11S2009C10_nt3v30Ev");}
void  S2009C10_nt ::v31(){vfunc_called(this, "_ZN11S2009C10_nt3v31Ev");}
S2009C10_nt ::S2009C10_nt(){ note_ctor("S2009C10_nt", this);} // tgen

//skip512 S2009C10_nt

#else // __cplusplus

extern void _ZN11S2009C10_ntC1Ev();
extern void _ZN11S2009C10_ntD1Ev();
Name_Map name_map_S2009C10_nt[] = {
  NSPAIR(_ZN11S2009C10_ntC1Ev),
  NSPAIR(_ZN11S2009C10_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S2009C10_nt[];
extern void _ZN11S2009C10_ntD1Ev();
extern void _ZN11S2009C10_ntD0Ev();
extern void _ZN11S2009C10_nt3v20Ev();
extern void _ZN11S2009C10_nt3v21Ev();
extern void _ZN11S2009C10_nt3v22Ev();
extern void _ZN11S2009C10_nt3v23Ev();
extern void _ZN11S2009C10_nt3v24Ev();
extern void _ZN11S2009C10_nt3v25Ev();
extern void _ZN11S2009C10_nt3v26Ev();
extern void _ZN11S2009C10_nt3v27Ev();
extern void _ZN11S2009C10_nt3v28Ev();
extern void _ZN11S2009C10_nt3v29Ev();
extern void _ZN11S2009C10_nt3v30Ev();
extern void _ZN11S2009C10_nt3v31Ev();
static  VTBL_ENTRY vtc_S2009C10_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S2009C10_nt[0]),
  (VTBL_ENTRY)&_ZN11S2009C10_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v20Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v21Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v22Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v23Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v24Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v25Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v26Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v27Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v28Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v29Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v30Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v31Ev,
};
extern VTBL_ENTRY _ZTI11S2009C10_nt[];
VTBL_ENTRY *P__ZTI11S2009C10_nt = _ZTI11S2009C10_nt; 
extern  VTBL_ENTRY _ZTV11S2009C10_nt[];
Class_Descriptor cd_S2009C10_nt = {  "S2009C10_nt", // class name
  0,0,//no base classes
  &(vtc_S2009C10_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI11S2009C10_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S2009C10_nt),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2009C9_nt  : S2009C10_nt {
  ::S4216C64 s2009c9f0;
  virtual  ~S2009C9_nt(); // _ZN10S2009C9_ntD1Ev
  virtual void  v32(); // _ZN10S2009C9_nt3v32Ev
  virtual void  v33(); // _ZN10S2009C9_nt3v33Ev
  virtual void  v34(); // _ZN10S2009C9_nt3v34Ev
  virtual void  v35(); // _ZN10S2009C9_nt3v35Ev
  virtual void  v36(); // _ZN10S2009C9_nt3v36Ev
  virtual void  v37(); // _ZN10S2009C9_nt3v37Ev
  virtual void  v38(); // _ZN10S2009C9_nt3v38Ev
  S2009C9_nt(); // tgen
};
//SIG(-1 S2009C9_nt) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ m FC8{ FL[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 FC9{ m Fp Fi[2] FC10{ m}}}


 S2009C9_nt ::~S2009C9_nt(){ note_dtor("S2009C9_nt", this);}
void  S2009C9_nt ::v32(){vfunc_called(this, "_ZN10S2009C9_nt3v32Ev");}
void  S2009C9_nt ::v33(){vfunc_called(this, "_ZN10S2009C9_nt3v33Ev");}
void  S2009C9_nt ::v34(){vfunc_called(this, "_ZN10S2009C9_nt3v34Ev");}
void  S2009C9_nt ::v35(){vfunc_called(this, "_ZN10S2009C9_nt3v35Ev");}
void  S2009C9_nt ::v36(){vfunc_called(this, "_ZN10S2009C9_nt3v36Ev");}
void  S2009C9_nt ::v37(){vfunc_called(this, "_ZN10S2009C9_nt3v37Ev");}
void  S2009C9_nt ::v38(){vfunc_called(this, "_ZN10S2009C9_nt3v38Ev");}
S2009C9_nt ::S2009C9_nt(){ note_ctor("S2009C9_nt", this);} // tgen

//skip512 S2009C9_nt

#else // __cplusplus

extern void _ZN10S2009C9_ntC1Ev();
extern void _ZN10S2009C9_ntD1Ev();
Name_Map name_map_S2009C9_nt[] = {
  NSPAIR(_ZN10S2009C9_ntC1Ev),
  NSPAIR(_ZN10S2009C9_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2009C10_nt;
extern VTBL_ENTRY _ZTI11S2009C10_nt[];
extern  VTBL_ENTRY _ZTV11S2009C10_nt[];
static Base_Class bases_S2009C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2009C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2009C9_nt[];
extern void _ZN10S2009C9_ntD1Ev();
extern void _ZN10S2009C9_ntD0Ev();
extern void _ZN11S2009C10_nt3v20Ev();
extern void _ZN11S2009C10_nt3v21Ev();
extern void _ZN11S2009C10_nt3v22Ev();
extern void _ZN11S2009C10_nt3v23Ev();
extern void _ZN11S2009C10_nt3v24Ev();
extern void _ZN11S2009C10_nt3v25Ev();
extern void _ZN11S2009C10_nt3v26Ev();
extern void _ZN11S2009C10_nt3v27Ev();
extern void _ZN11S2009C10_nt3v28Ev();
extern void _ZN11S2009C10_nt3v29Ev();
extern void _ZN11S2009C10_nt3v30Ev();
extern void _ZN11S2009C10_nt3v31Ev();
extern void _ZN10S2009C9_nt3v32Ev();
extern void _ZN10S2009C9_nt3v33Ev();
extern void _ZN10S2009C9_nt3v34Ev();
extern void _ZN10S2009C9_nt3v35Ev();
extern void _ZN10S2009C9_nt3v36Ev();
extern void _ZN10S2009C9_nt3v37Ev();
extern void _ZN10S2009C9_nt3v38Ev();
static  VTBL_ENTRY vtc_S2009C9_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2009C9_nt[0]),
  (VTBL_ENTRY)&_ZN10S2009C9_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v20Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v21Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v22Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v23Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v24Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v25Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v26Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v27Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v28Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v29Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v30Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v38Ev,
};
extern VTBL_ENTRY _ZTI10S2009C9_nt[];
VTBL_ENTRY *P__ZTI10S2009C9_nt = _ZTI10S2009C9_nt; 
extern  VTBL_ENTRY _ZTV10S2009C9_nt[];
Class_Descriptor cd_S2009C9_nt = {  "S2009C9_nt", // class name
  bases_S2009C9_nt, 1,
  &(vtc_S2009C9_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,72), // object size
  NSPAIRA(_ZTI10S2009C9_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2009C9_nt),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2009C18  {
  virtual  ~S2009C18(); // _ZN8S2009C18D1Ev
  virtual void  v39(); // _ZN8S2009C183v39Ev
  S2009C18(); // tgen
};
//SIG(-1 S2009C18) C1{ vd v1}


 S2009C18 ::~S2009C18(){ note_dtor("S2009C18", this);}
void  S2009C18 ::v39(){vfunc_called(this, "_ZN8S2009C183v39Ev");}
S2009C18 ::S2009C18(){ note_ctor("S2009C18", this);} // tgen

static void Test_S2009C18()
{
  extern Class_Descriptor cd_S2009C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2009C18, buf);
    S2009C18 *dp, &lv = *(dp=new (buf) S2009C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2009C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2009C18)");
    test_class_info(&lv, &cd_S2009C18);
    dp->~S2009C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2009C18(Test_S2009C18, "S2009C18", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2009C18C1Ev();
extern void _ZN8S2009C18D1Ev();
Name_Map name_map_S2009C18[] = {
  NSPAIR(_ZN8S2009C18C1Ev),
  NSPAIR(_ZN8S2009C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2009C18[];
extern void _ZN8S2009C18D1Ev();
extern void _ZN8S2009C18D0Ev();
extern void _ZN8S2009C183v39Ev();
static  VTBL_ENTRY vtc_S2009C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2009C18[0]),
  (VTBL_ENTRY)&_ZN8S2009C18D1Ev,
  (VTBL_ENTRY)&_ZN8S2009C18D0Ev,
  (VTBL_ENTRY)&_ZN8S2009C183v39Ev,
};
extern VTBL_ENTRY _ZTI8S2009C18[];
extern  VTBL_ENTRY _ZTV8S2009C18[];
Class_Descriptor cd_S2009C18 = {  "S2009C18", // class name
  0,0,//no base classes
  &(vtc_S2009C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2009C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2009C18),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2009C1  : S2009C2_nt , S2009C9_nt , S2009C18 {
  ::S4218C68 s2009c1f0;
  ::S4216C40 s2009c1f1;
  int s2009c1f2;
  virtual  ~S2009C1(); // _ZN7S2009C1D1Ev
  virtual void  v1(); // _ZN7S2009C12v1Ev
  virtual void  v2(); // _ZN7S2009C12v2Ev
  virtual void  v3(); // _ZN7S2009C12v3Ev
  virtual void  v4(); // _ZN7S2009C12v4Ev
  virtual void  v5(); // _ZN7S2009C12v5Ev
  virtual void  v6(); // _ZN7S2009C12v6Ev
  virtual void  v7(); // _ZN7S2009C12v7Ev
  virtual void  v8(); // _ZN7S2009C12v8Ev
  virtual void  v9(); // _ZN7S2009C12v9Ev
  S2009C1(); // tgen
};
//SIG(1 S2009C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12} vd v13 v14 v15 v16} vd v17 v18 v19 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FC8{ FL[4]}} Fc} BC9{ BC10{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 Fp FC11{ BC12{ m Fp Fi FC13{ m} FC14{ m}}} FC15{ m FC8} Fc} vd v32 v33 v34 v35 v36 v37 v38 FC16{ m Fp Fi[2] FC6}} BC17{ vd v39} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC18{ BC16 BC19{ vd v42 v43} vd v40 v41} FC20{ BC21{ BC22{ vd v46 v47} vd v48 FC23{ m Fp Fi FC14} FC23 FC23} vd v44 v45 FC23 Fi Fc} Fi}


 S2009C1 ::~S2009C1(){ note_dtor("S2009C1", this);}
void  S2009C1 ::v1(){vfunc_called(this, "_ZN7S2009C12v1Ev");}
void  S2009C1 ::v2(){vfunc_called(this, "_ZN7S2009C12v2Ev");}
void  S2009C1 ::v3(){vfunc_called(this, "_ZN7S2009C12v3Ev");}
void  S2009C1 ::v4(){vfunc_called(this, "_ZN7S2009C12v4Ev");}
void  S2009C1 ::v5(){vfunc_called(this, "_ZN7S2009C12v5Ev");}
void  S2009C1 ::v6(){vfunc_called(this, "_ZN7S2009C12v6Ev");}
void  S2009C1 ::v7(){vfunc_called(this, "_ZN7S2009C12v7Ev");}
void  S2009C1 ::v8(){vfunc_called(this, "_ZN7S2009C12v8Ev");}
void  S2009C1 ::v9(){vfunc_called(this, "_ZN7S2009C12v9Ev");}
S2009C1 ::S2009C1(){ note_ctor("S2009C1", this);} // tgen

static void Test_S2009C1()
{
  extern Class_Descriptor cd_S2009C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,55)];
    init_test(&cd_S2009C1, buf);
    S2009C1 *dp, &lv = *(dp=new (buf) S2009C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,216), "sizeof(S2009C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2009C1)");
    check_base_class_offset(lv, (S2009C4*)(S2009C3_nt*)(S2009C2_nt*), 0, "S2009C1");
    check_base_class_offset(lv, (S2009C3_nt*)(S2009C2_nt*), 0, "S2009C1");
    check_base_class_offset(lv, (S2009C2_nt*), 0, "S2009C1");
    check_base_class_offset(lv, (S2009C10_nt*)(S2009C9_nt*), ABISELECT(72,56), "S2009C1");
    check_base_class_offset(lv, (S2009C9_nt*), ABISELECT(72,56), "S2009C1");
    check_base_class_offset(lv, (S2009C18*), ABISELECT(168,128), "S2009C1");
    check_field_offset(lv, s2009c1f0, ABISELECT(176,132), "S2009C1.s2009c1f0");
    check_field_offset(lv, s2009c1f1, ABISELECT(208,152), "S2009C1.s2009c1f1");
    check_field_offset(lv, s2009c1f2, ABISELECT(288,212), "S2009C1.s2009c1f2");
    test_class_info(&lv, &cd_S2009C1);
    dp->~S2009C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2009C1(Test_S2009C1, "S2009C1", ABISELECT(296,216));

#else // __cplusplus

extern void _ZN7S2009C1C1Ev();
extern void _ZN7S2009C1D1Ev();
Name_Map name_map_S2009C1[] = {
  NSPAIR(_ZN7S2009C1C1Ev),
  NSPAIR(_ZN7S2009C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2009C4;
extern VTBL_ENTRY _ZTI7S2009C4[];
extern  VTBL_ENTRY _ZTV7S2009C4[];
extern Class_Descriptor cd_S2009C3_nt;
extern VTBL_ENTRY _ZTI10S2009C3_nt[];
extern  VTBL_ENTRY _ZTV10S2009C3_nt[];
extern Class_Descriptor cd_S2009C2_nt;
extern VTBL_ENTRY _ZTI10S2009C2_nt[];
extern  VTBL_ENTRY _ZTV10S2009C2_nt[];
extern Class_Descriptor cd_S2009C10_nt;
extern VTBL_ENTRY _ZTI11S2009C10_nt[];
extern  VTBL_ENTRY _ZTV11S2009C10_nt[];
extern Class_Descriptor cd_S2009C9_nt;
extern VTBL_ENTRY _ZTI10S2009C9_nt[];
extern  VTBL_ENTRY _ZTV10S2009C9_nt[];
extern Class_Descriptor cd_S2009C18;
extern VTBL_ENTRY _ZTI8S2009C18[];
extern  VTBL_ENTRY _ZTV8S2009C18[];
static Base_Class bases_S2009C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2009C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2009C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2009C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2009C10_nt,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2009C9_nt,    ABISELECT(72,56), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2009C18,    ABISELECT(168,128), //bcp->offset
    46, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2009C1[];
extern void _ZN7S2009C1D1Ev();
extern void _ZN7S2009C1D0Ev();
extern void _ZN7S2009C43v10Ev();
extern void _ZN7S2009C43v11Ev();
extern void _ZN7S2009C43v12Ev();
extern void _ZN10S2009C3_nt3v13Ev();
extern void _ZN10S2009C3_nt3v14Ev();
extern void _ZN10S2009C3_nt3v15Ev();
extern void _ZN10S2009C3_nt3v16Ev();
extern void _ZN10S2009C2_nt3v17Ev();
extern void _ZN10S2009C2_nt3v18Ev();
extern void _ZN10S2009C2_nt3v19Ev();
extern void _ZN7S2009C12v1Ev();
extern void _ZN7S2009C12v2Ev();
extern void _ZN7S2009C12v3Ev();
extern void _ZN7S2009C12v4Ev();
extern void _ZN7S2009C12v5Ev();
extern void _ZN7S2009C12v6Ev();
extern void _ZN7S2009C12v7Ev();
extern void _ZN7S2009C12v8Ev();
extern void _ZN7S2009C12v9Ev();
extern void ABISELECT(_ZThn72_N7S2009C1D1Ev,_ZThn56_N7S2009C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2009C1D0Ev,_ZThn56_N7S2009C1D0Ev)();
extern void _ZN11S2009C10_nt3v20Ev();
extern void _ZN11S2009C10_nt3v21Ev();
extern void _ZN11S2009C10_nt3v22Ev();
extern void _ZN11S2009C10_nt3v23Ev();
extern void _ZN11S2009C10_nt3v24Ev();
extern void _ZN11S2009C10_nt3v25Ev();
extern void _ZN11S2009C10_nt3v26Ev();
extern void _ZN11S2009C10_nt3v27Ev();
extern void _ZN11S2009C10_nt3v28Ev();
extern void _ZN11S2009C10_nt3v29Ev();
extern void _ZN11S2009C10_nt3v30Ev();
extern void _ZN11S2009C10_nt3v31Ev();
extern void _ZN10S2009C9_nt3v32Ev();
extern void _ZN10S2009C9_nt3v33Ev();
extern void _ZN10S2009C9_nt3v34Ev();
extern void _ZN10S2009C9_nt3v35Ev();
extern void _ZN10S2009C9_nt3v36Ev();
extern void _ZN10S2009C9_nt3v37Ev();
extern void _ZN10S2009C9_nt3v38Ev();
extern void ABISELECT(_ZThn168_N7S2009C1D1Ev,_ZThn128_N7S2009C1D1Ev)();
extern void ABISELECT(_ZThn168_N7S2009C1D0Ev,_ZThn128_N7S2009C1D0Ev)();
extern void _ZN8S2009C183v39Ev();
static  VTBL_ENTRY vtc_S2009C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2009C1[0]),
  (VTBL_ENTRY)&_ZN7S2009C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2009C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2009C43v12Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2009C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2009C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2009C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2009C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN7S2009C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2009C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2009C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2009C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2009C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2009C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2009C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2009C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2009C12v9Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S2009C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2009C1D1Ev,_ZThn56_N7S2009C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2009C1D0Ev,_ZThn56_N7S2009C1D0Ev),
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v20Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v21Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v22Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v23Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v24Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v25Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v26Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v27Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v28Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v29Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v30Ev,
  (VTBL_ENTRY)&_ZN11S2009C10_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2009C9_nt3v38Ev,
  ABISELECT(-168,-128),
  (VTBL_ENTRY)&(_ZTI7S2009C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2009C1D1Ev,_ZThn128_N7S2009C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2009C1D0Ev,_ZThn128_N7S2009C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2009C183v39Ev,
};
extern VTBL_ENTRY _ZTI7S2009C1[];
extern  VTBL_ENTRY _ZTV7S2009C1[];
Class_Descriptor cd_S2009C1 = {  "S2009C1", // class name
  bases_S2009C1, 6,
  &(vtc_S2009C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,216), // object size
  NSPAIRA(_ZTI7S2009C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S2009C1),51, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2008C4  {
  virtual  ~S2008C4(); // _ZN7S2008C4D1Ev
  virtual void  v10(); // _ZN7S2008C43v10Ev
  virtual void  v11(); // _ZN7S2008C43v11Ev
  virtual void  v12(); // _ZN7S2008C43v12Ev
  S2008C4(); // tgen
};
//SIG(-1 S2008C4) C1{ vd v1 v2 v3}


 S2008C4 ::~S2008C4(){ note_dtor("S2008C4", this);}
void  S2008C4 ::v10(){vfunc_called(this, "_ZN7S2008C43v10Ev");}
void  S2008C4 ::v11(){vfunc_called(this, "_ZN7S2008C43v11Ev");}
void  S2008C4 ::v12(){vfunc_called(this, "_ZN7S2008C43v12Ev");}
S2008C4 ::S2008C4(){ note_ctor("S2008C4", this);} // tgen

static void Test_S2008C4()
{
  extern Class_Descriptor cd_S2008C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2008C4, buf);
    S2008C4 *dp, &lv = *(dp=new (buf) S2008C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2008C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2008C4)");
    test_class_info(&lv, &cd_S2008C4);
    dp->~S2008C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2008C4(Test_S2008C4, "S2008C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2008C4C1Ev();
extern void _ZN7S2008C4D1Ev();
Name_Map name_map_S2008C4[] = {
  NSPAIR(_ZN7S2008C4C1Ev),
  NSPAIR(_ZN7S2008C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2008C4[];
extern void _ZN7S2008C4D1Ev();
extern void _ZN7S2008C4D0Ev();
extern void _ZN7S2008C43v10Ev();
extern void _ZN7S2008C43v11Ev();
extern void _ZN7S2008C43v12Ev();
static  VTBL_ENTRY vtc_S2008C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2008C4[0]),
  (VTBL_ENTRY)&_ZN7S2008C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2008C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v12Ev,
};
extern VTBL_ENTRY _ZTI7S2008C4[];
extern  VTBL_ENTRY _ZTV7S2008C4[];
Class_Descriptor cd_S2008C4 = {  "S2008C4", // class name
  0,0,//no base classes
  &(vtc_S2008C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2008C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2008C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2008C3  : S2008C4 {
  virtual  ~S2008C3(); // _ZN7S2008C3D1Ev
  virtual void  v13(); // _ZN7S2008C33v13Ev
  virtual void  v14(); // _ZN7S2008C33v14Ev
  virtual void  v15(); // _ZN7S2008C33v15Ev
  virtual void  v16(); // _ZN7S2008C33v16Ev
  S2008C3(); // tgen
};
//SIG(-1 S2008C3) C1{ BC2{ vd v5 v6 v7} vd v1 v2 v3 v4}


 S2008C3 ::~S2008C3(){ note_dtor("S2008C3", this);}
void  S2008C3 ::v13(){vfunc_called(this, "_ZN7S2008C33v13Ev");}
void  S2008C3 ::v14(){vfunc_called(this, "_ZN7S2008C33v14Ev");}
void  S2008C3 ::v15(){vfunc_called(this, "_ZN7S2008C33v15Ev");}
void  S2008C3 ::v16(){vfunc_called(this, "_ZN7S2008C33v16Ev");}
S2008C3 ::S2008C3(){ note_ctor("S2008C3", this);} // tgen

static void Test_S2008C3()
{
  extern Class_Descriptor cd_S2008C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2008C3, buf);
    S2008C3 *dp, &lv = *(dp=new (buf) S2008C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2008C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2008C3)");
    check_base_class_offset(lv, (S2008C4*), 0, "S2008C3");
    test_class_info(&lv, &cd_S2008C3);
    dp->~S2008C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2008C3(Test_S2008C3, "S2008C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2008C3C1Ev();
extern void _ZN7S2008C3D1Ev();
Name_Map name_map_S2008C3[] = {
  NSPAIR(_ZN7S2008C3C1Ev),
  NSPAIR(_ZN7S2008C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2008C4;
extern VTBL_ENTRY _ZTI7S2008C4[];
extern  VTBL_ENTRY _ZTV7S2008C4[];
static Base_Class bases_S2008C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2008C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2008C3[];
extern void _ZN7S2008C3D1Ev();
extern void _ZN7S2008C3D0Ev();
extern void _ZN7S2008C43v10Ev();
extern void _ZN7S2008C43v11Ev();
extern void _ZN7S2008C43v12Ev();
extern void _ZN7S2008C33v13Ev();
extern void _ZN7S2008C33v14Ev();
extern void _ZN7S2008C33v15Ev();
extern void _ZN7S2008C33v16Ev();
static  VTBL_ENTRY vtc_S2008C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2008C3[0]),
  (VTBL_ENTRY)&_ZN7S2008C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2008C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v16Ev,
};
extern VTBL_ENTRY _ZTI7S2008C3[];
extern  VTBL_ENTRY _ZTV7S2008C3[];
Class_Descriptor cd_S2008C3 = {  "S2008C3", // class name
  bases_S2008C3, 1,
  &(vtc_S2008C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2008C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2008C3),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2008C2_nt  : S2008C3 {
  ::S4216C72 s2008c2f0;
  ::S4216C6_nt s2008c2f1;
  char s2008c2f2;
  virtual  ~S2008C2_nt(); // _ZN10S2008C2_ntD1Ev
  virtual void  v17(); // _ZN10S2008C2_nt3v17Ev
  virtual void  v18(); // _ZN10S2008C2_nt3v18Ev
  virtual void  v19(); // _ZN10S2008C2_nt3v19Ev
  S2008C2_nt(); // tgen
};
//SIG(-1 S2008C2_nt) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc}


 S2008C2_nt ::~S2008C2_nt(){ note_dtor("S2008C2_nt", this);}
void  S2008C2_nt ::v17(){vfunc_called(this, "_ZN10S2008C2_nt3v17Ev");}
void  S2008C2_nt ::v18(){vfunc_called(this, "_ZN10S2008C2_nt3v18Ev");}
void  S2008C2_nt ::v19(){vfunc_called(this, "_ZN10S2008C2_nt3v19Ev");}
S2008C2_nt ::S2008C2_nt(){ note_ctor("S2008C2_nt", this);} // tgen

//skip512 S2008C2_nt

#else // __cplusplus

extern void _ZN10S2008C2_ntC1Ev();
extern void _ZN10S2008C2_ntD1Ev();
Name_Map name_map_S2008C2_nt[] = {
  NSPAIR(_ZN10S2008C2_ntC1Ev),
  NSPAIR(_ZN10S2008C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2008C4;
extern VTBL_ENTRY _ZTI7S2008C4[];
extern  VTBL_ENTRY _ZTV7S2008C4[];
extern Class_Descriptor cd_S2008C3;
extern VTBL_ENTRY _ZTI7S2008C3[];
extern  VTBL_ENTRY _ZTV7S2008C3[];
static Base_Class bases_S2008C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2008C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2008C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2008C2_nt[];
extern void _ZN10S2008C2_ntD1Ev();
extern void _ZN10S2008C2_ntD0Ev();
extern void _ZN7S2008C43v10Ev();
extern void _ZN7S2008C43v11Ev();
extern void _ZN7S2008C43v12Ev();
extern void _ZN7S2008C33v13Ev();
extern void _ZN7S2008C33v14Ev();
extern void _ZN7S2008C33v15Ev();
extern void _ZN7S2008C33v16Ev();
extern void _ZN10S2008C2_nt3v17Ev();
extern void _ZN10S2008C2_nt3v18Ev();
extern void _ZN10S2008C2_nt3v19Ev();
static  VTBL_ENTRY vtc_S2008C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2008C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2008C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2008C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v16Ev,
  (VTBL_ENTRY)&_ZN10S2008C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2008C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2008C2_nt3v19Ev,
};
extern VTBL_ENTRY _ZTI10S2008C2_nt[];
VTBL_ENTRY *P__ZTI10S2008C2_nt = _ZTI10S2008C2_nt; 
extern  VTBL_ENTRY _ZTV10S2008C2_nt[];
Class_Descriptor cd_S2008C2_nt = {  "S2008C2_nt", // class name
  bases_S2008C2_nt, 2,
  &(vtc_S2008C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI10S2008C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2008C2_nt),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2008C15_nt  {
  ::S4216C7_nt s2008c15f0;
  void  mf2008c15(); // _ZN11S2008C15_nt9mf2008c15Ev
};
//SIG(-1 S2008C15_nt) C1{ m FC2{ Fl[4]}}


void  S2008C15_nt ::mf2008c15(){}

//skip512 S2008C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2008C10_nt  {
  void *s2008c10f0;
  ::S4216C12_nt s2008c10f1;
  ::S2008C15_nt s2008c10f2;
  char s2008c10f3;
  virtual  ~S2008C10_nt(); // _ZN11S2008C10_ntD1Ev
  virtual void  v20(); // _ZN11S2008C10_nt3v20Ev
  virtual void  v21(); // _ZN11S2008C10_nt3v21Ev
  virtual void  v22(); // _ZN11S2008C10_nt3v22Ev
  virtual void  v23(); // _ZN11S2008C10_nt3v23Ev
  virtual void  v24(); // _ZN11S2008C10_nt3v24Ev
  virtual void  v25(); // _ZN11S2008C10_nt3v25Ev
  virtual void  v26(); // _ZN11S2008C10_nt3v26Ev
  virtual void  v27(); // _ZN11S2008C10_nt3v27Ev
  virtual void  v28(); // _ZN11S2008C10_nt3v28Ev
  virtual void  v29(); // _ZN11S2008C10_nt3v29Ev
  virtual void  v30(); // _ZN11S2008C10_nt3v30Ev
  virtual void  v31(); // _ZN11S2008C10_nt3v31Ev
  S2008C10_nt(); // tgen
};
//SIG(-1 S2008C10_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ m FC7{ Fl[4]}} Fc}


 S2008C10_nt ::~S2008C10_nt(){ note_dtor("S2008C10_nt", this);}
void  S2008C10_nt ::v20(){vfunc_called(this, "_ZN11S2008C10_nt3v20Ev");}
void  S2008C10_nt ::v21(){vfunc_called(this, "_ZN11S2008C10_nt3v21Ev");}
void  S2008C10_nt ::v22(){vfunc_called(this, "_ZN11S2008C10_nt3v22Ev");}
void  S2008C10_nt ::v23(){vfunc_called(this, "_ZN11S2008C10_nt3v23Ev");}
void  S2008C10_nt ::v24(){vfunc_called(this, "_ZN11S2008C10_nt3v24Ev");}
void  S2008C10_nt ::v25(){vfunc_called(this, "_ZN11S2008C10_nt3v25Ev");}
void  S2008C10_nt ::v26(){vfunc_called(this, "_ZN11S2008C10_nt3v26Ev");}
void  S2008C10_nt ::v27(){vfunc_called(this, "_ZN11S2008C10_nt3v27Ev");}
void  S2008C10_nt ::v28(){vfunc_called(this, "_ZN11S2008C10_nt3v28Ev");}
void  S2008C10_nt ::v29(){vfunc_called(this, "_ZN11S2008C10_nt3v29Ev");}
void  S2008C10_nt ::v30(){vfunc_called(this, "_ZN11S2008C10_nt3v30Ev");}
void  S2008C10_nt ::v31(){vfunc_called(this, "_ZN11S2008C10_nt3v31Ev");}
S2008C10_nt ::S2008C10_nt(){ note_ctor("S2008C10_nt", this);} // tgen

//skip512 S2008C10_nt

#else // __cplusplus

extern void _ZN11S2008C10_ntC1Ev();
extern void _ZN11S2008C10_ntD1Ev();
Name_Map name_map_S2008C10_nt[] = {
  NSPAIR(_ZN11S2008C10_ntC1Ev),
  NSPAIR(_ZN11S2008C10_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S2008C10_nt[];
extern void _ZN11S2008C10_ntD1Ev();
extern void _ZN11S2008C10_ntD0Ev();
extern void _ZN11S2008C10_nt3v20Ev();
extern void _ZN11S2008C10_nt3v21Ev();
extern void _ZN11S2008C10_nt3v22Ev();
extern void _ZN11S2008C10_nt3v23Ev();
extern void _ZN11S2008C10_nt3v24Ev();
extern void _ZN11S2008C10_nt3v25Ev();
extern void _ZN11S2008C10_nt3v26Ev();
extern void _ZN11S2008C10_nt3v27Ev();
extern void _ZN11S2008C10_nt3v28Ev();
extern void _ZN11S2008C10_nt3v29Ev();
extern void _ZN11S2008C10_nt3v30Ev();
extern void _ZN11S2008C10_nt3v31Ev();
static  VTBL_ENTRY vtc_S2008C10_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S2008C10_nt[0]),
  (VTBL_ENTRY)&_ZN11S2008C10_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v20Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v21Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v22Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v23Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v24Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v25Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v26Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v27Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v28Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v29Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v30Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v31Ev,
};
extern VTBL_ENTRY _ZTI11S2008C10_nt[];
VTBL_ENTRY *P__ZTI11S2008C10_nt = _ZTI11S2008C10_nt; 
extern  VTBL_ENTRY _ZTV11S2008C10_nt[];
Class_Descriptor cd_S2008C10_nt = {  "S2008C10_nt", // class name
  0,0,//no base classes
  &(vtc_S2008C10_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI11S2008C10_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S2008C10_nt),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2008C9_nt  : S2008C10_nt {
  ::S4216C64 s2008c9f0;
  virtual  ~S2008C9_nt(); // _ZN10S2008C9_ntD1Ev
  virtual void  v32(); // _ZN10S2008C9_nt3v32Ev
  virtual void  v33(); // _ZN10S2008C9_nt3v33Ev
  virtual void  v34(); // _ZN10S2008C9_nt3v34Ev
  virtual void  v35(); // _ZN10S2008C9_nt3v35Ev
  virtual void  v36(); // _ZN10S2008C9_nt3v36Ev
  virtual void  v37(); // _ZN10S2008C9_nt3v37Ev
  virtual void  v38(); // _ZN10S2008C9_nt3v38Ev
  S2008C9_nt(); // tgen
};
//SIG(-1 S2008C9_nt) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ m FC8{ Fl[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 FC9{ m Fp Fi[2] FC10{ m}}}


 S2008C9_nt ::~S2008C9_nt(){ note_dtor("S2008C9_nt", this);}
void  S2008C9_nt ::v32(){vfunc_called(this, "_ZN10S2008C9_nt3v32Ev");}
void  S2008C9_nt ::v33(){vfunc_called(this, "_ZN10S2008C9_nt3v33Ev");}
void  S2008C9_nt ::v34(){vfunc_called(this, "_ZN10S2008C9_nt3v34Ev");}
void  S2008C9_nt ::v35(){vfunc_called(this, "_ZN10S2008C9_nt3v35Ev");}
void  S2008C9_nt ::v36(){vfunc_called(this, "_ZN10S2008C9_nt3v36Ev");}
void  S2008C9_nt ::v37(){vfunc_called(this, "_ZN10S2008C9_nt3v37Ev");}
void  S2008C9_nt ::v38(){vfunc_called(this, "_ZN10S2008C9_nt3v38Ev");}
S2008C9_nt ::S2008C9_nt(){ note_ctor("S2008C9_nt", this);} // tgen

//skip512 S2008C9_nt

#else // __cplusplus

extern void _ZN10S2008C9_ntC1Ev();
extern void _ZN10S2008C9_ntD1Ev();
Name_Map name_map_S2008C9_nt[] = {
  NSPAIR(_ZN10S2008C9_ntC1Ev),
  NSPAIR(_ZN10S2008C9_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2008C10_nt;
extern VTBL_ENTRY _ZTI11S2008C10_nt[];
extern  VTBL_ENTRY _ZTV11S2008C10_nt[];
static Base_Class bases_S2008C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2008C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2008C9_nt[];
extern void _ZN10S2008C9_ntD1Ev();
extern void _ZN10S2008C9_ntD0Ev();
extern void _ZN11S2008C10_nt3v20Ev();
extern void _ZN11S2008C10_nt3v21Ev();
extern void _ZN11S2008C10_nt3v22Ev();
extern void _ZN11S2008C10_nt3v23Ev();
extern void _ZN11S2008C10_nt3v24Ev();
extern void _ZN11S2008C10_nt3v25Ev();
extern void _ZN11S2008C10_nt3v26Ev();
extern void _ZN11S2008C10_nt3v27Ev();
extern void _ZN11S2008C10_nt3v28Ev();
extern void _ZN11S2008C10_nt3v29Ev();
extern void _ZN11S2008C10_nt3v30Ev();
extern void _ZN11S2008C10_nt3v31Ev();
extern void _ZN10S2008C9_nt3v32Ev();
extern void _ZN10S2008C9_nt3v33Ev();
extern void _ZN10S2008C9_nt3v34Ev();
extern void _ZN10S2008C9_nt3v35Ev();
extern void _ZN10S2008C9_nt3v36Ev();
extern void _ZN10S2008C9_nt3v37Ev();
extern void _ZN10S2008C9_nt3v38Ev();
static  VTBL_ENTRY vtc_S2008C9_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2008C9_nt[0]),
  (VTBL_ENTRY)&_ZN10S2008C9_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v20Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v21Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v22Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v23Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v24Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v25Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v26Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v27Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v28Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v29Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v30Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v38Ev,
};
extern VTBL_ENTRY _ZTI10S2008C9_nt[];
VTBL_ENTRY *P__ZTI10S2008C9_nt = _ZTI10S2008C9_nt; 
extern  VTBL_ENTRY _ZTV10S2008C9_nt[];
Class_Descriptor cd_S2008C9_nt = {  "S2008C9_nt", // class name
  bases_S2008C9_nt, 1,
  &(vtc_S2008C9_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,56), // object size
  NSPAIRA(_ZTI10S2008C9_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2008C9_nt),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2008C18  {
  virtual  ~S2008C18(); // _ZN8S2008C18D1Ev
  virtual void  v39(); // _ZN8S2008C183v39Ev
  S2008C18(); // tgen
};
//SIG(-1 S2008C18) C1{ vd v1}


 S2008C18 ::~S2008C18(){ note_dtor("S2008C18", this);}
void  S2008C18 ::v39(){vfunc_called(this, "_ZN8S2008C183v39Ev");}
S2008C18 ::S2008C18(){ note_ctor("S2008C18", this);} // tgen

static void Test_S2008C18()
{
  extern Class_Descriptor cd_S2008C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2008C18, buf);
    S2008C18 *dp, &lv = *(dp=new (buf) S2008C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2008C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2008C18)");
    test_class_info(&lv, &cd_S2008C18);
    dp->~S2008C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2008C18(Test_S2008C18, "S2008C18", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2008C18C1Ev();
extern void _ZN8S2008C18D1Ev();
Name_Map name_map_S2008C18[] = {
  NSPAIR(_ZN8S2008C18C1Ev),
  NSPAIR(_ZN8S2008C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2008C18[];
extern void _ZN8S2008C18D1Ev();
extern void _ZN8S2008C18D0Ev();
extern void _ZN8S2008C183v39Ev();
static  VTBL_ENTRY vtc_S2008C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2008C18[0]),
  (VTBL_ENTRY)&_ZN8S2008C18D1Ev,
  (VTBL_ENTRY)&_ZN8S2008C18D0Ev,
  (VTBL_ENTRY)&_ZN8S2008C183v39Ev,
};
extern VTBL_ENTRY _ZTI8S2008C18[];
extern  VTBL_ENTRY _ZTV8S2008C18[];
Class_Descriptor cd_S2008C18 = {  "S2008C18", // class name
  0,0,//no base classes
  &(vtc_S2008C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2008C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2008C18),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2008C1  : S2008C2_nt , S2008C9_nt , S2008C18 {
  ::S4218C68 s2008c1f0;
  ::S4216C40 s2008c1f1;
  int s2008c1f2;
  virtual  ~S2008C1(); // _ZN7S2008C1D1Ev
  virtual void  v1(); // _ZN7S2008C12v1Ev
  virtual void  v2(); // _ZN7S2008C12v2Ev
  virtual void  v3(); // _ZN7S2008C12v3Ev
  virtual void  v4(); // _ZN7S2008C12v4Ev
  virtual void  v5(); // _ZN7S2008C12v5Ev
  virtual void  v6(); // _ZN7S2008C12v6Ev
  virtual void  v7(); // _ZN7S2008C12v7Ev
  virtual void  v8(); // _ZN7S2008C12v8Ev
  virtual void  v9(); // _ZN7S2008C12v9Ev
  S2008C1(); // tgen
};
//SIG(1 S2008C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12} vd v13 v14 v15 v16} vd v17 v18 v19 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FC8{ Fl[4]}} Fc} BC9{ BC10{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 Fp FC11{ BC12{ m Fp Fi FC13{ m} FC14{ m}}} FC15{ m FC8} Fc} vd v32 v33 v34 v35 v36 v37 v38 FC16{ m Fp Fi[2] FC6}} BC17{ vd v39} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC18{ BC16 BC19{ vd v42 v43} vd v40 v41} FC20{ BC21{ BC22{ vd v46 v47} vd v48 FC23{ m Fp Fi FC14} FC23 FC23} vd v44 v45 FC23 Fi Fc} Fi}


 S2008C1 ::~S2008C1(){ note_dtor("S2008C1", this);}
void  S2008C1 ::v1(){vfunc_called(this, "_ZN7S2008C12v1Ev");}
void  S2008C1 ::v2(){vfunc_called(this, "_ZN7S2008C12v2Ev");}
void  S2008C1 ::v3(){vfunc_called(this, "_ZN7S2008C12v3Ev");}
void  S2008C1 ::v4(){vfunc_called(this, "_ZN7S2008C12v4Ev");}
void  S2008C1 ::v5(){vfunc_called(this, "_ZN7S2008C12v5Ev");}
void  S2008C1 ::v6(){vfunc_called(this, "_ZN7S2008C12v6Ev");}
void  S2008C1 ::v7(){vfunc_called(this, "_ZN7S2008C12v7Ev");}
void  S2008C1 ::v8(){vfunc_called(this, "_ZN7S2008C12v8Ev");}
void  S2008C1 ::v9(){vfunc_called(this, "_ZN7S2008C12v9Ev");}
S2008C1 ::S2008C1(){ note_ctor("S2008C1", this);} // tgen

static void Test_S2008C1()
{
  extern Class_Descriptor cd_S2008C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,47)];
    init_test(&cd_S2008C1, buf);
    S2008C1 *dp, &lv = *(dp=new (buf) S2008C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,184), "sizeof(S2008C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2008C1)");
    check_base_class_offset(lv, (S2008C4*)(S2008C3*)(S2008C2_nt*), 0, "S2008C1");
    check_base_class_offset(lv, (S2008C3*)(S2008C2_nt*), 0, "S2008C1");
    check_base_class_offset(lv, (S2008C2_nt*), 0, "S2008C1");
    check_base_class_offset(lv, (S2008C10_nt*)(S2008C9_nt*), ABISELECT(72,40), "S2008C1");
    check_base_class_offset(lv, (S2008C9_nt*), ABISELECT(72,40), "S2008C1");
    check_base_class_offset(lv, (S2008C18*), ABISELECT(168,96), "S2008C1");
    check_field_offset(lv, s2008c1f0, ABISELECT(176,100), "S2008C1.s2008c1f0");
    check_field_offset(lv, s2008c1f1, ABISELECT(208,120), "S2008C1.s2008c1f1");
    check_field_offset(lv, s2008c1f2, ABISELECT(288,180), "S2008C1.s2008c1f2");
    test_class_info(&lv, &cd_S2008C1);
    dp->~S2008C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2008C1(Test_S2008C1, "S2008C1", ABISELECT(296,184));

#else // __cplusplus

extern void _ZN7S2008C1C1Ev();
extern void _ZN7S2008C1D1Ev();
Name_Map name_map_S2008C1[] = {
  NSPAIR(_ZN7S2008C1C1Ev),
  NSPAIR(_ZN7S2008C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2008C4;
extern VTBL_ENTRY _ZTI7S2008C4[];
extern  VTBL_ENTRY _ZTV7S2008C4[];
extern Class_Descriptor cd_S2008C3;
extern VTBL_ENTRY _ZTI7S2008C3[];
extern  VTBL_ENTRY _ZTV7S2008C3[];
extern Class_Descriptor cd_S2008C2_nt;
extern VTBL_ENTRY _ZTI10S2008C2_nt[];
extern  VTBL_ENTRY _ZTV10S2008C2_nt[];
extern Class_Descriptor cd_S2008C10_nt;
extern VTBL_ENTRY _ZTI11S2008C10_nt[];
extern  VTBL_ENTRY _ZTV11S2008C10_nt[];
extern Class_Descriptor cd_S2008C9_nt;
extern VTBL_ENTRY _ZTI10S2008C9_nt[];
extern  VTBL_ENTRY _ZTV10S2008C9_nt[];
extern Class_Descriptor cd_S2008C18;
extern VTBL_ENTRY _ZTI8S2008C18[];
extern  VTBL_ENTRY _ZTV8S2008C18[];
static Base_Class bases_S2008C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2008C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2008C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2008C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2008C10_nt,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2008C9_nt,    ABISELECT(72,40), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2008C18,    ABISELECT(168,96), //bcp->offset
    46, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2008C1[];
extern void _ZN7S2008C1D1Ev();
extern void _ZN7S2008C1D0Ev();
extern void _ZN7S2008C43v10Ev();
extern void _ZN7S2008C43v11Ev();
extern void _ZN7S2008C43v12Ev();
extern void _ZN7S2008C33v13Ev();
extern void _ZN7S2008C33v14Ev();
extern void _ZN7S2008C33v15Ev();
extern void _ZN7S2008C33v16Ev();
extern void _ZN10S2008C2_nt3v17Ev();
extern void _ZN10S2008C2_nt3v18Ev();
extern void _ZN10S2008C2_nt3v19Ev();
extern void _ZN7S2008C12v1Ev();
extern void _ZN7S2008C12v2Ev();
extern void _ZN7S2008C12v3Ev();
extern void _ZN7S2008C12v4Ev();
extern void _ZN7S2008C12v5Ev();
extern void _ZN7S2008C12v6Ev();
extern void _ZN7S2008C12v7Ev();
extern void _ZN7S2008C12v8Ev();
extern void _ZN7S2008C12v9Ev();
extern void ABISELECT(_ZThn72_N7S2008C1D1Ev,_ZThn40_N7S2008C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2008C1D0Ev,_ZThn40_N7S2008C1D0Ev)();
extern void _ZN11S2008C10_nt3v20Ev();
extern void _ZN11S2008C10_nt3v21Ev();
extern void _ZN11S2008C10_nt3v22Ev();
extern void _ZN11S2008C10_nt3v23Ev();
extern void _ZN11S2008C10_nt3v24Ev();
extern void _ZN11S2008C10_nt3v25Ev();
extern void _ZN11S2008C10_nt3v26Ev();
extern void _ZN11S2008C10_nt3v27Ev();
extern void _ZN11S2008C10_nt3v28Ev();
extern void _ZN11S2008C10_nt3v29Ev();
extern void _ZN11S2008C10_nt3v30Ev();
extern void _ZN11S2008C10_nt3v31Ev();
extern void _ZN10S2008C9_nt3v32Ev();
extern void _ZN10S2008C9_nt3v33Ev();
extern void _ZN10S2008C9_nt3v34Ev();
extern void _ZN10S2008C9_nt3v35Ev();
extern void _ZN10S2008C9_nt3v36Ev();
extern void _ZN10S2008C9_nt3v37Ev();
extern void _ZN10S2008C9_nt3v38Ev();
extern void ABISELECT(_ZThn168_N7S2008C1D1Ev,_ZThn96_N7S2008C1D1Ev)();
extern void ABISELECT(_ZThn168_N7S2008C1D0Ev,_ZThn96_N7S2008C1D0Ev)();
extern void _ZN8S2008C183v39Ev();
static  VTBL_ENTRY vtc_S2008C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2008C1[0]),
  (VTBL_ENTRY)&_ZN7S2008C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2008C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2008C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2008C33v16Ev,
  (VTBL_ENTRY)&_ZN10S2008C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2008C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2008C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN7S2008C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2008C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2008C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2008C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2008C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2008C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2008C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2008C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2008C12v9Ev,
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI7S2008C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2008C1D1Ev,_ZThn40_N7S2008C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2008C1D0Ev,_ZThn40_N7S2008C1D0Ev),
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v20Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v21Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v22Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v23Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v24Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v25Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v26Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v27Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v28Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v29Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v30Ev,
  (VTBL_ENTRY)&_ZN11S2008C10_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2008C9_nt3v38Ev,
  ABISELECT(-168,-96),
  (VTBL_ENTRY)&(_ZTI7S2008C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2008C1D1Ev,_ZThn96_N7S2008C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2008C1D0Ev,_ZThn96_N7S2008C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2008C183v39Ev,
};
extern VTBL_ENTRY _ZTI7S2008C1[];
extern  VTBL_ENTRY _ZTV7S2008C1[];
Class_Descriptor cd_S2008C1 = {  "S2008C1", // class name
  bases_S2008C1, 6,
  &(vtc_S2008C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,184), // object size
  NSPAIRA(_ZTI7S2008C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S2008C1),51, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2010C4  {
  virtual  ~S2010C4(); // _ZN7S2010C4D1Ev
  virtual void  v10(); // _ZN7S2010C43v10Ev
  virtual void  v11(); // _ZN7S2010C43v11Ev
  virtual void  v12(); // _ZN7S2010C43v12Ev
  S2010C4(); // tgen
};
//SIG(-1 S2010C4) C1{ vd v1 v2 v3}


 S2010C4 ::~S2010C4(){ note_dtor("S2010C4", this);}
void  S2010C4 ::v10(){vfunc_called(this, "_ZN7S2010C43v10Ev");}
void  S2010C4 ::v11(){vfunc_called(this, "_ZN7S2010C43v11Ev");}
void  S2010C4 ::v12(){vfunc_called(this, "_ZN7S2010C43v12Ev");}
S2010C4 ::S2010C4(){ note_ctor("S2010C4", this);} // tgen

static void Test_S2010C4()
{
  extern Class_Descriptor cd_S2010C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2010C4, buf);
    S2010C4 *dp, &lv = *(dp=new (buf) S2010C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2010C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2010C4)");
    test_class_info(&lv, &cd_S2010C4);
    dp->~S2010C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2010C4(Test_S2010C4, "S2010C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2010C4C1Ev();
extern void _ZN7S2010C4D1Ev();
Name_Map name_map_S2010C4[] = {
  NSPAIR(_ZN7S2010C4C1Ev),
  NSPAIR(_ZN7S2010C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2010C4[];
extern void _ZN7S2010C4D1Ev();
extern void _ZN7S2010C4D0Ev();
extern void _ZN7S2010C43v10Ev();
extern void _ZN7S2010C43v11Ev();
extern void _ZN7S2010C43v12Ev();
static  VTBL_ENTRY vtc_S2010C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2010C4[0]),
  (VTBL_ENTRY)&_ZN7S2010C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2010C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v12Ev,
};
extern VTBL_ENTRY _ZTI7S2010C4[];
extern  VTBL_ENTRY _ZTV7S2010C4[];
Class_Descriptor cd_S2010C4 = {  "S2010C4", // class name
  0,0,//no base classes
  &(vtc_S2010C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2010C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2010C4),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2010C3  : S2010C4 {
  virtual  ~S2010C3(); // _ZN7S2010C3D1Ev
  virtual void  v13(); // _ZN7S2010C33v13Ev
  virtual void  v14(); // _ZN7S2010C33v14Ev
  virtual void  v15(); // _ZN7S2010C33v15Ev
  virtual void  v16(); // _ZN7S2010C33v16Ev
  S2010C3(); // tgen
};
//SIG(-1 S2010C3) C1{ BC2{ vd v5 v6 v7} vd v1 v2 v3 v4}


 S2010C3 ::~S2010C3(){ note_dtor("S2010C3", this);}
void  S2010C3 ::v13(){vfunc_called(this, "_ZN7S2010C33v13Ev");}
void  S2010C3 ::v14(){vfunc_called(this, "_ZN7S2010C33v14Ev");}
void  S2010C3 ::v15(){vfunc_called(this, "_ZN7S2010C33v15Ev");}
void  S2010C3 ::v16(){vfunc_called(this, "_ZN7S2010C33v16Ev");}
S2010C3 ::S2010C3(){ note_ctor("S2010C3", this);} // tgen

static void Test_S2010C3()
{
  extern Class_Descriptor cd_S2010C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2010C3, buf);
    S2010C3 *dp, &lv = *(dp=new (buf) S2010C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2010C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2010C3)");
    check_base_class_offset(lv, (S2010C4*), 0, "S2010C3");
    test_class_info(&lv, &cd_S2010C3);
    dp->~S2010C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2010C3(Test_S2010C3, "S2010C3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2010C3C1Ev();
extern void _ZN7S2010C3D1Ev();
Name_Map name_map_S2010C3[] = {
  NSPAIR(_ZN7S2010C3C1Ev),
  NSPAIR(_ZN7S2010C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2010C4;
extern VTBL_ENTRY _ZTI7S2010C4[];
extern  VTBL_ENTRY _ZTV7S2010C4[];
static Base_Class bases_S2010C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2010C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2010C3[];
extern void _ZN7S2010C3D1Ev();
extern void _ZN7S2010C3D0Ev();
extern void _ZN7S2010C43v10Ev();
extern void _ZN7S2010C43v11Ev();
extern void _ZN7S2010C43v12Ev();
extern void _ZN7S2010C33v13Ev();
extern void _ZN7S2010C33v14Ev();
extern void _ZN7S2010C33v15Ev();
extern void _ZN7S2010C33v16Ev();
static  VTBL_ENTRY vtc_S2010C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2010C3[0]),
  (VTBL_ENTRY)&_ZN7S2010C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2010C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v16Ev,
};
extern VTBL_ENTRY _ZTI7S2010C3[];
extern  VTBL_ENTRY _ZTV7S2010C3[];
Class_Descriptor cd_S2010C3 = {  "S2010C3", // class name
  bases_S2010C3, 1,
  &(vtc_S2010C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2010C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2010C3),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2010C2_nt  : S2010C3 {
  ::S4216C72 s2010c2f0;
  ::S4218C6_nt s2010c2f1;
  char s2010c2f2;
  virtual  ~S2010C2_nt(); // _ZN10S2010C2_ntD1Ev
  virtual void  v17(); // _ZN10S2010C2_nt3v17Ev
  virtual void  v18(); // _ZN10S2010C2_nt3v18Ev
  virtual void  v19(); // _ZN10S2010C2_nt3v19Ev
  S2010C2_nt(); // tgen
};
//SIG(-1 S2010C2_nt) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FL[4]} Fc}


 S2010C2_nt ::~S2010C2_nt(){ note_dtor("S2010C2_nt", this);}
void  S2010C2_nt ::v17(){vfunc_called(this, "_ZN10S2010C2_nt3v17Ev");}
void  S2010C2_nt ::v18(){vfunc_called(this, "_ZN10S2010C2_nt3v18Ev");}
void  S2010C2_nt ::v19(){vfunc_called(this, "_ZN10S2010C2_nt3v19Ev");}
S2010C2_nt ::S2010C2_nt(){ note_ctor("S2010C2_nt", this);} // tgen

//skip512 S2010C2_nt

#else // __cplusplus

extern void _ZN10S2010C2_ntC1Ev();
extern void _ZN10S2010C2_ntD1Ev();
Name_Map name_map_S2010C2_nt[] = {
  NSPAIR(_ZN10S2010C2_ntC1Ev),
  NSPAIR(_ZN10S2010C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2010C4;
extern VTBL_ENTRY _ZTI7S2010C4[];
extern  VTBL_ENTRY _ZTV7S2010C4[];
extern Class_Descriptor cd_S2010C3;
extern VTBL_ENTRY _ZTI7S2010C3[];
extern  VTBL_ENTRY _ZTV7S2010C3[];
static Base_Class bases_S2010C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2010C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2010C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2010C2_nt[];
extern void _ZN10S2010C2_ntD1Ev();
extern void _ZN10S2010C2_ntD0Ev();
extern void _ZN7S2010C43v10Ev();
extern void _ZN7S2010C43v11Ev();
extern void _ZN7S2010C43v12Ev();
extern void _ZN7S2010C33v13Ev();
extern void _ZN7S2010C33v14Ev();
extern void _ZN7S2010C33v15Ev();
extern void _ZN7S2010C33v16Ev();
extern void _ZN10S2010C2_nt3v17Ev();
extern void _ZN10S2010C2_nt3v18Ev();
extern void _ZN10S2010C2_nt3v19Ev();
static  VTBL_ENTRY vtc_S2010C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2010C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2010C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2010C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v16Ev,
  (VTBL_ENTRY)&_ZN10S2010C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2010C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2010C2_nt3v19Ev,
};
extern VTBL_ENTRY _ZTI10S2010C2_nt[];
VTBL_ENTRY *P__ZTI10S2010C2_nt = _ZTI10S2010C2_nt; 
extern  VTBL_ENTRY _ZTV10S2010C2_nt[];
Class_Descriptor cd_S2010C2_nt = {  "S2010C2_nt", // class name
  bases_S2010C2_nt, 2,
  &(vtc_S2010C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI10S2010C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2010C2_nt),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2010C14_nt  {
  __tsi64 s2010c14f0[4];
  void  mf2010c14(); // _ZN11S2010C14_nt9mf2010c14Ev
};
//SIG(-1 S2010C14_nt) C1{ m FL[4]}


void  S2010C14_nt ::mf2010c14(){}

//skip512 S2010C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2010C9_nt  {
  void *s2010c9f0;
  ::S4216C12_nt s2010c9f1;
  ::S2010C14_nt s2010c9f2;
  char s2010c9f3;
  virtual  ~S2010C9_nt(); // _ZN10S2010C9_ntD1Ev
  virtual void  v20(); // _ZN10S2010C9_nt3v20Ev
  virtual void  v21(); // _ZN10S2010C9_nt3v21Ev
  virtual void  v22(); // _ZN10S2010C9_nt3v22Ev
  virtual void  v23(); // _ZN10S2010C9_nt3v23Ev
  virtual void  v24(); // _ZN10S2010C9_nt3v24Ev
  virtual void  v25(); // _ZN10S2010C9_nt3v25Ev
  virtual void  v26(); // _ZN10S2010C9_nt3v26Ev
  virtual void  v27(); // _ZN10S2010C9_nt3v27Ev
  virtual void  v28(); // _ZN10S2010C9_nt3v28Ev
  virtual void  v29(); // _ZN10S2010C9_nt3v29Ev
  virtual void  v30(); // _ZN10S2010C9_nt3v30Ev
  virtual void  v31(); // _ZN10S2010C9_nt3v31Ev
  S2010C9_nt(); // tgen
};
//SIG(-1 S2010C9_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ m FL[4]} Fc}


 S2010C9_nt ::~S2010C9_nt(){ note_dtor("S2010C9_nt", this);}
void  S2010C9_nt ::v20(){vfunc_called(this, "_ZN10S2010C9_nt3v20Ev");}
void  S2010C9_nt ::v21(){vfunc_called(this, "_ZN10S2010C9_nt3v21Ev");}
void  S2010C9_nt ::v22(){vfunc_called(this, "_ZN10S2010C9_nt3v22Ev");}
void  S2010C9_nt ::v23(){vfunc_called(this, "_ZN10S2010C9_nt3v23Ev");}
void  S2010C9_nt ::v24(){vfunc_called(this, "_ZN10S2010C9_nt3v24Ev");}
void  S2010C9_nt ::v25(){vfunc_called(this, "_ZN10S2010C9_nt3v25Ev");}
void  S2010C9_nt ::v26(){vfunc_called(this, "_ZN10S2010C9_nt3v26Ev");}
void  S2010C9_nt ::v27(){vfunc_called(this, "_ZN10S2010C9_nt3v27Ev");}
void  S2010C9_nt ::v28(){vfunc_called(this, "_ZN10S2010C9_nt3v28Ev");}
void  S2010C9_nt ::v29(){vfunc_called(this, "_ZN10S2010C9_nt3v29Ev");}
void  S2010C9_nt ::v30(){vfunc_called(this, "_ZN10S2010C9_nt3v30Ev");}
void  S2010C9_nt ::v31(){vfunc_called(this, "_ZN10S2010C9_nt3v31Ev");}
S2010C9_nt ::S2010C9_nt(){ note_ctor("S2010C9_nt", this);} // tgen

//skip512 S2010C9_nt

#else // __cplusplus

extern void _ZN10S2010C9_ntC1Ev();
extern void _ZN10S2010C9_ntD1Ev();
Name_Map name_map_S2010C9_nt[] = {
  NSPAIR(_ZN10S2010C9_ntC1Ev),
  NSPAIR(_ZN10S2010C9_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2010C9_nt[];
extern void _ZN10S2010C9_ntD1Ev();
extern void _ZN10S2010C9_ntD0Ev();
extern void _ZN10S2010C9_nt3v20Ev();
extern void _ZN10S2010C9_nt3v21Ev();
extern void _ZN10S2010C9_nt3v22Ev();
extern void _ZN10S2010C9_nt3v23Ev();
extern void _ZN10S2010C9_nt3v24Ev();
extern void _ZN10S2010C9_nt3v25Ev();
extern void _ZN10S2010C9_nt3v26Ev();
extern void _ZN10S2010C9_nt3v27Ev();
extern void _ZN10S2010C9_nt3v28Ev();
extern void _ZN10S2010C9_nt3v29Ev();
extern void _ZN10S2010C9_nt3v30Ev();
extern void _ZN10S2010C9_nt3v31Ev();
static  VTBL_ENTRY vtc_S2010C9_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2010C9_nt[0]),
  (VTBL_ENTRY)&_ZN10S2010C9_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v31Ev,
};
extern VTBL_ENTRY _ZTI10S2010C9_nt[];
VTBL_ENTRY *P__ZTI10S2010C9_nt = _ZTI10S2010C9_nt; 
extern  VTBL_ENTRY _ZTV10S2010C9_nt[];
Class_Descriptor cd_S2010C9_nt = {  "S2010C9_nt", // class name
  0,0,//no base classes
  &(vtc_S2010C9_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI10S2010C9_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2010C9_nt),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2010C8_nt  : S2010C9_nt {
  ::S4216C64 s2010c8f0;
  virtual  ~S2010C8_nt(); // _ZN10S2010C8_ntD1Ev
  virtual void  v32(); // _ZN10S2010C8_nt3v32Ev
  virtual void  v33(); // _ZN10S2010C8_nt3v33Ev
  virtual void  v34(); // _ZN10S2010C8_nt3v34Ev
  virtual void  v35(); // _ZN10S2010C8_nt3v35Ev
  virtual void  v36(); // _ZN10S2010C8_nt3v36Ev
  virtual void  v37(); // _ZN10S2010C8_nt3v37Ev
  virtual void  v38(); // _ZN10S2010C8_nt3v38Ev
  S2010C8_nt(); // tgen
};
//SIG(-1 S2010C8_nt) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ m FL[4]} Fc} vd v1 v2 v3 v4 v5 v6 v7 FC8{ m Fp Fi[2] FC9{ m}}}


 S2010C8_nt ::~S2010C8_nt(){ note_dtor("S2010C8_nt", this);}
void  S2010C8_nt ::v32(){vfunc_called(this, "_ZN10S2010C8_nt3v32Ev");}
void  S2010C8_nt ::v33(){vfunc_called(this, "_ZN10S2010C8_nt3v33Ev");}
void  S2010C8_nt ::v34(){vfunc_called(this, "_ZN10S2010C8_nt3v34Ev");}
void  S2010C8_nt ::v35(){vfunc_called(this, "_ZN10S2010C8_nt3v35Ev");}
void  S2010C8_nt ::v36(){vfunc_called(this, "_ZN10S2010C8_nt3v36Ev");}
void  S2010C8_nt ::v37(){vfunc_called(this, "_ZN10S2010C8_nt3v37Ev");}
void  S2010C8_nt ::v38(){vfunc_called(this, "_ZN10S2010C8_nt3v38Ev");}
S2010C8_nt ::S2010C8_nt(){ note_ctor("S2010C8_nt", this);} // tgen

//skip512 S2010C8_nt

#else // __cplusplus

extern void _ZN10S2010C8_ntC1Ev();
extern void _ZN10S2010C8_ntD1Ev();
Name_Map name_map_S2010C8_nt[] = {
  NSPAIR(_ZN10S2010C8_ntC1Ev),
  NSPAIR(_ZN10S2010C8_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2010C9_nt;
extern VTBL_ENTRY _ZTI10S2010C9_nt[];
extern  VTBL_ENTRY _ZTV10S2010C9_nt[];
static Base_Class bases_S2010C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2010C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2010C8_nt[];
extern void _ZN10S2010C8_ntD1Ev();
extern void _ZN10S2010C8_ntD0Ev();
extern void _ZN10S2010C9_nt3v20Ev();
extern void _ZN10S2010C9_nt3v21Ev();
extern void _ZN10S2010C9_nt3v22Ev();
extern void _ZN10S2010C9_nt3v23Ev();
extern void _ZN10S2010C9_nt3v24Ev();
extern void _ZN10S2010C9_nt3v25Ev();
extern void _ZN10S2010C9_nt3v26Ev();
extern void _ZN10S2010C9_nt3v27Ev();
extern void _ZN10S2010C9_nt3v28Ev();
extern void _ZN10S2010C9_nt3v29Ev();
extern void _ZN10S2010C9_nt3v30Ev();
extern void _ZN10S2010C9_nt3v31Ev();
extern void _ZN10S2010C8_nt3v32Ev();
extern void _ZN10S2010C8_nt3v33Ev();
extern void _ZN10S2010C8_nt3v34Ev();
extern void _ZN10S2010C8_nt3v35Ev();
extern void _ZN10S2010C8_nt3v36Ev();
extern void _ZN10S2010C8_nt3v37Ev();
extern void _ZN10S2010C8_nt3v38Ev();
static  VTBL_ENTRY vtc_S2010C8_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2010C8_nt[0]),
  (VTBL_ENTRY)&_ZN10S2010C8_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v38Ev,
};
extern VTBL_ENTRY _ZTI10S2010C8_nt[];
VTBL_ENTRY *P__ZTI10S2010C8_nt = _ZTI10S2010C8_nt; 
extern  VTBL_ENTRY _ZTV10S2010C8_nt[];
Class_Descriptor cd_S2010C8_nt = {  "S2010C8_nt", // class name
  bases_S2010C8_nt, 1,
  &(vtc_S2010C8_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,72), // object size
  NSPAIRA(_ZTI10S2010C8_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2010C8_nt),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2010C17  {
  virtual  ~S2010C17(); // _ZN8S2010C17D1Ev
  virtual void  v39(); // _ZN8S2010C173v39Ev
  S2010C17(); // tgen
};
//SIG(-1 S2010C17) C1{ vd v1}


 S2010C17 ::~S2010C17(){ note_dtor("S2010C17", this);}
void  S2010C17 ::v39(){vfunc_called(this, "_ZN8S2010C173v39Ev");}
S2010C17 ::S2010C17(){ note_ctor("S2010C17", this);} // tgen

static void Test_S2010C17()
{
  extern Class_Descriptor cd_S2010C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2010C17, buf);
    S2010C17 *dp, &lv = *(dp=new (buf) S2010C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2010C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2010C17)");
    test_class_info(&lv, &cd_S2010C17);
    dp->~S2010C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2010C17(Test_S2010C17, "S2010C17", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2010C17C1Ev();
extern void _ZN8S2010C17D1Ev();
Name_Map name_map_S2010C17[] = {
  NSPAIR(_ZN8S2010C17C1Ev),
  NSPAIR(_ZN8S2010C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2010C17[];
extern void _ZN8S2010C17D1Ev();
extern void _ZN8S2010C17D0Ev();
extern void _ZN8S2010C173v39Ev();
static  VTBL_ENTRY vtc_S2010C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2010C17[0]),
  (VTBL_ENTRY)&_ZN8S2010C17D1Ev,
  (VTBL_ENTRY)&_ZN8S2010C17D0Ev,
  (VTBL_ENTRY)&_ZN8S2010C173v39Ev,
};
extern VTBL_ENTRY _ZTI8S2010C17[];
extern  VTBL_ENTRY _ZTV8S2010C17[];
Class_Descriptor cd_S2010C17 = {  "S2010C17", // class name
  0,0,//no base classes
  &(vtc_S2010C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2010C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2010C17),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2010C1  : S2010C2_nt , S2010C8_nt , S2010C17 {
  ::S4218C68 s2010c1f0;
  ::S4216C40 s2010c1f1;
  int s2010c1f2;
  virtual  ~S2010C1(); // _ZN7S2010C1D1Ev
  virtual void  v1(); // _ZN7S2010C12v1Ev
  virtual void  v2(); // _ZN7S2010C12v2Ev
  virtual void  v3(); // _ZN7S2010C12v3Ev
  virtual void  v4(); // _ZN7S2010C12v4Ev
  virtual void  v5(); // _ZN7S2010C12v5Ev
  virtual void  v6(); // _ZN7S2010C12v6Ev
  virtual void  v7(); // _ZN7S2010C12v7Ev
  virtual void  v8(); // _ZN7S2010C12v8Ev
  virtual void  v9(); // _ZN7S2010C12v9Ev
  S2010C1(); // tgen
};
//SIG(1 S2010C1) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12} vd v13 v14 v15 v16} vd v17 v18 v19 FC5{ m Fp Fi[2] FC6{ m}} FC7{ m FL[4]} Fc} BC8{ BC9{ vd v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 Fp FC10{ BC11{ m Fp Fi FC12{ m} FC13{ m}}} FC14{ m FL[4]} Fc} vd v32 v33 v34 v35 v36 v37 v38 FC15{ m Fp Fi[2] FC6}} BC16{ vd v39} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC17{ BC15 BC18{ vd v42 v43} vd v40 v41} FC19{ BC20{ BC21{ vd v46 v47} vd v48 FC22{ m Fp Fi FC13} FC22 FC22} vd v44 v45 FC22 Fi Fc} Fi}


 S2010C1 ::~S2010C1(){ note_dtor("S2010C1", this);}
void  S2010C1 ::v1(){vfunc_called(this, "_ZN7S2010C12v1Ev");}
void  S2010C1 ::v2(){vfunc_called(this, "_ZN7S2010C12v2Ev");}
void  S2010C1 ::v3(){vfunc_called(this, "_ZN7S2010C12v3Ev");}
void  S2010C1 ::v4(){vfunc_called(this, "_ZN7S2010C12v4Ev");}
void  S2010C1 ::v5(){vfunc_called(this, "_ZN7S2010C12v5Ev");}
void  S2010C1 ::v6(){vfunc_called(this, "_ZN7S2010C12v6Ev");}
void  S2010C1 ::v7(){vfunc_called(this, "_ZN7S2010C12v7Ev");}
void  S2010C1 ::v8(){vfunc_called(this, "_ZN7S2010C12v8Ev");}
void  S2010C1 ::v9(){vfunc_called(this, "_ZN7S2010C12v9Ev");}
S2010C1 ::S2010C1(){ note_ctor("S2010C1", this);} // tgen

static void Test_S2010C1()
{
  extern Class_Descriptor cd_S2010C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,55)];
    init_test(&cd_S2010C1, buf);
    S2010C1 *dp, &lv = *(dp=new (buf) S2010C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,216), "sizeof(S2010C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2010C1)");
    check_base_class_offset(lv, (S2010C4*)(S2010C3*)(S2010C2_nt*), 0, "S2010C1");
    check_base_class_offset(lv, (S2010C3*)(S2010C2_nt*), 0, "S2010C1");
    check_base_class_offset(lv, (S2010C2_nt*), 0, "S2010C1");
    check_base_class_offset(lv, (S2010C9_nt*)(S2010C8_nt*), ABISELECT(72,56), "S2010C1");
    check_base_class_offset(lv, (S2010C8_nt*), ABISELECT(72,56), "S2010C1");
    check_base_class_offset(lv, (S2010C17*), ABISELECT(168,128), "S2010C1");
    check_field_offset(lv, s2010c1f0, ABISELECT(176,132), "S2010C1.s2010c1f0");
    check_field_offset(lv, s2010c1f1, ABISELECT(208,152), "S2010C1.s2010c1f1");
    check_field_offset(lv, s2010c1f2, ABISELECT(288,212), "S2010C1.s2010c1f2");
    test_class_info(&lv, &cd_S2010C1);
    dp->~S2010C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2010C1(Test_S2010C1, "S2010C1", ABISELECT(296,216));

#else // __cplusplus

extern void _ZN7S2010C1C1Ev();
extern void _ZN7S2010C1D1Ev();
Name_Map name_map_S2010C1[] = {
  NSPAIR(_ZN7S2010C1C1Ev),
  NSPAIR(_ZN7S2010C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2010C4;
extern VTBL_ENTRY _ZTI7S2010C4[];
extern  VTBL_ENTRY _ZTV7S2010C4[];
extern Class_Descriptor cd_S2010C3;
extern VTBL_ENTRY _ZTI7S2010C3[];
extern  VTBL_ENTRY _ZTV7S2010C3[];
extern Class_Descriptor cd_S2010C2_nt;
extern VTBL_ENTRY _ZTI10S2010C2_nt[];
extern  VTBL_ENTRY _ZTV10S2010C2_nt[];
extern Class_Descriptor cd_S2010C9_nt;
extern VTBL_ENTRY _ZTI10S2010C9_nt[];
extern  VTBL_ENTRY _ZTV10S2010C9_nt[];
extern Class_Descriptor cd_S2010C8_nt;
extern VTBL_ENTRY _ZTI10S2010C8_nt[];
extern  VTBL_ENTRY _ZTV10S2010C8_nt[];
extern Class_Descriptor cd_S2010C17;
extern VTBL_ENTRY _ZTI8S2010C17[];
extern  VTBL_ENTRY _ZTV8S2010C17[];
static Base_Class bases_S2010C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2010C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2010C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2010C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2010C9_nt,    ABISELECT(72,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2010C8_nt,    ABISELECT(72,56), //bcp->offset
    23, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2010C17,    ABISELECT(168,128), //bcp->offset
    46, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2010C1[];
extern void _ZN7S2010C1D1Ev();
extern void _ZN7S2010C1D0Ev();
extern void _ZN7S2010C43v10Ev();
extern void _ZN7S2010C43v11Ev();
extern void _ZN7S2010C43v12Ev();
extern void _ZN7S2010C33v13Ev();
extern void _ZN7S2010C33v14Ev();
extern void _ZN7S2010C33v15Ev();
extern void _ZN7S2010C33v16Ev();
extern void _ZN10S2010C2_nt3v17Ev();
extern void _ZN10S2010C2_nt3v18Ev();
extern void _ZN10S2010C2_nt3v19Ev();
extern void _ZN7S2010C12v1Ev();
extern void _ZN7S2010C12v2Ev();
extern void _ZN7S2010C12v3Ev();
extern void _ZN7S2010C12v4Ev();
extern void _ZN7S2010C12v5Ev();
extern void _ZN7S2010C12v6Ev();
extern void _ZN7S2010C12v7Ev();
extern void _ZN7S2010C12v8Ev();
extern void _ZN7S2010C12v9Ev();
extern void ABISELECT(_ZThn72_N7S2010C1D1Ev,_ZThn56_N7S2010C1D1Ev)();
extern void ABISELECT(_ZThn72_N7S2010C1D0Ev,_ZThn56_N7S2010C1D0Ev)();
extern void _ZN10S2010C9_nt3v20Ev();
extern void _ZN10S2010C9_nt3v21Ev();
extern void _ZN10S2010C9_nt3v22Ev();
extern void _ZN10S2010C9_nt3v23Ev();
extern void _ZN10S2010C9_nt3v24Ev();
extern void _ZN10S2010C9_nt3v25Ev();
extern void _ZN10S2010C9_nt3v26Ev();
extern void _ZN10S2010C9_nt3v27Ev();
extern void _ZN10S2010C9_nt3v28Ev();
extern void _ZN10S2010C9_nt3v29Ev();
extern void _ZN10S2010C9_nt3v30Ev();
extern void _ZN10S2010C9_nt3v31Ev();
extern void _ZN10S2010C8_nt3v32Ev();
extern void _ZN10S2010C8_nt3v33Ev();
extern void _ZN10S2010C8_nt3v34Ev();
extern void _ZN10S2010C8_nt3v35Ev();
extern void _ZN10S2010C8_nt3v36Ev();
extern void _ZN10S2010C8_nt3v37Ev();
extern void _ZN10S2010C8_nt3v38Ev();
extern void ABISELECT(_ZThn168_N7S2010C1D1Ev,_ZThn128_N7S2010C1D1Ev)();
extern void ABISELECT(_ZThn168_N7S2010C1D0Ev,_ZThn128_N7S2010C1D0Ev)();
extern void _ZN8S2010C173v39Ev();
static  VTBL_ENTRY vtc_S2010C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2010C1[0]),
  (VTBL_ENTRY)&_ZN7S2010C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2010C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2010C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v13Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v14Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2010C33v16Ev,
  (VTBL_ENTRY)&_ZN10S2010C2_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2010C2_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2010C2_nt3v19Ev,
  (VTBL_ENTRY)&_ZN7S2010C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2010C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2010C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2010C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2010C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2010C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2010C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2010C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2010C12v9Ev,
  ABISELECT(-72,-56),
  (VTBL_ENTRY)&(_ZTI7S2010C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2010C1D1Ev,_ZThn56_N7S2010C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn72_N7S2010C1D0Ev,_ZThn56_N7S2010C1D0Ev),
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2010C9_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2010C8_nt3v38Ev,
  ABISELECT(-168,-128),
  (VTBL_ENTRY)&(_ZTI7S2010C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2010C1D1Ev,_ZThn128_N7S2010C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2010C1D0Ev,_ZThn128_N7S2010C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2010C173v39Ev,
};
extern VTBL_ENTRY _ZTI7S2010C1[];
extern  VTBL_ENTRY _ZTV7S2010C1[];
Class_Descriptor cd_S2010C1 = {  "S2010C1", // class name
  bases_S2010C1, 6,
  &(vtc_S2010C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,216), // object size
  NSPAIRA(_ZTI7S2010C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S2010C1),51, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C3  {
  void *s7601c3f0;
  int s7601c3f1;
  virtual void  v4(); // _ZN7S7601C32v4Ev
  virtual void  v5(); // _ZN7S7601C32v5Ev
  virtual void  v6(); // _ZN7S7601C32v6Ev
  virtual void  v7(); // _ZN7S7601C32v7Ev
  ~S7601C3(); // tgen
  S7601C3(); // tgen
};
//SIG(-1 S7601C3) C1{ v1 v2 v3 v4 Fp Fi}


void  S7601C3 ::v4(){vfunc_called(this, "_ZN7S7601C32v4Ev");}
void  S7601C3 ::v5(){vfunc_called(this, "_ZN7S7601C32v5Ev");}
void  S7601C3 ::v6(){vfunc_called(this, "_ZN7S7601C32v6Ev");}
void  S7601C3 ::v7(){vfunc_called(this, "_ZN7S7601C32v7Ev");}
S7601C3 ::~S7601C3(){ note_dtor("S7601C3", this);} // tgen
S7601C3 ::S7601C3(){ note_ctor("S7601C3", this);} // tgen

static void Test_S7601C3()
{
  extern Class_Descriptor cd_S7601C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S7601C3, buf);
    S7601C3 *dp, &lv = *(dp=new (buf) S7601C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S7601C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7601C3)");
    check_field_offset(lv, s7601c3f0, ABISELECT(8,4), "S7601C3.s7601c3f0");
    check_field_offset(lv, s7601c3f1, ABISELECT(16,8), "S7601C3.s7601c3f1");
    test_class_info(&lv, &cd_S7601C3);
    dp->~S7601C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C3(Test_S7601C3, "S7601C3", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN7S7601C3C1Ev();
extern void _ZN7S7601C3D1Ev();
Name_Map name_map_S7601C3[] = {
  NSPAIR(_ZN7S7601C3C1Ev),
  NSPAIR(_ZN7S7601C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S7601C3[];
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY vtc_S7601C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C3[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
Class_Descriptor cd_S7601C3 = {  "S7601C3", // class name
  0,0,//no base classes
  &(vtc_S7601C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI7S7601C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S7601C3),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C2  : virtual S7601C3 {
  virtual void  v8(); // _ZN7S7601C22v8Ev
  ~S7601C2(); // tgen
  S7601C2(); // tgen
};
//SIG(-1 S7601C2) C1{ VBC2{ v2 v3 v4 v5 Fp Fi} v1}


void  S7601C2 ::v8(){vfunc_called(this, "_ZN7S7601C22v8Ev");}
S7601C2 ::~S7601C2(){ note_dtor("S7601C2", this);} // tgen
S7601C2 ::S7601C2(){ note_ctor("S7601C2", this);} // tgen

static void Test_S7601C2()
{
  extern Class_Descriptor cd_S7601C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S7601C2, buf);
    S7601C2 *dp, &lv = *(dp=new (buf) S7601C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S7601C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7601C2)");
    check_base_class_offset(lv, (S7601C3*), ABISELECT(8,4), "S7601C2");
    test_class_info(&lv, &cd_S7601C2);
    dp->~S7601C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C2(Test_S7601C2, "S7601C2", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN7S7601C2C1Ev();
extern void _ZN7S7601C2D1Ev();
Name_Map name_map_S7601C2[] = {
  NSPAIR(_ZN7S7601C2C1Ev),
  NSPAIR(_ZN7S7601C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
static Base_Class bases_S7601C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7601C2[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY vtc_S7601C2[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern VTBL_ENTRY _ZTV7S7601C2[];
static  VTT_ENTRY vtt_S7601C2[] = {
  {&(_ZTV7S7601C2[3]),  3,14},
  {&(_ZTV7S7601C2[10]),  10,14},
};
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
Class_Descriptor cd_S7601C2 = {  "S7601C2", // class name
  bases_S7601C2, 1,
  &(vtc_S7601C2[0]), // expected_vtbl_contents
  &(vtt_S7601C2[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI7S7601C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7601C2),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7601C2),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C7  : virtual S7601C2 {
  long double s7601c7f0[9];
  virtual void  v9(); // _ZN7S7601C72v9Ev
  virtual void  v10(); // _ZN7S7601C73v10Ev
  virtual void  v11(); // _ZN7S7601C73v11Ev
  virtual void  v12(); // _ZN7S7601C73v12Ev
  ~S7601C7(); // tgen
  S7601C7(); // tgen
};
//SIG(-1 S7601C7) C1{ VBC2{ VBC3{ v5 v6 v7 v8 Fp Fi} v9} v1 v2 v3 v4 FD[9]}


void  S7601C7 ::v9(){vfunc_called(this, "_ZN7S7601C72v9Ev");}
void  S7601C7 ::v10(){vfunc_called(this, "_ZN7S7601C73v10Ev");}
void  S7601C7 ::v11(){vfunc_called(this, "_ZN7S7601C73v11Ev");}
void  S7601C7 ::v12(){vfunc_called(this, "_ZN7S7601C73v12Ev");}
S7601C7 ::~S7601C7(){ note_dtor("S7601C7", this);} // tgen
S7601C7 ::S7601C7(){ note_ctor("S7601C7", this);} // tgen

static void Test_S7601C7()
{
  extern Class_Descriptor cd_S7601C7;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(13,32)];
    init_test(&cd_S7601C7, buf);
    S7601C7 *dp, &lv = *(dp=new (buf) S7601C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,124), "sizeof(S7601C7)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7601C7)");
    check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(160,112), "S7601C7");
    check_base_class_offset(lv, (S7601C2*), 0, "S7601C7");
    check_field_offset(lv, s7601c7f0, ABISELECT(16,4), "S7601C7.s7601c7f0");
    test_class_info(&lv, &cd_S7601C7);
    dp->~S7601C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C7(Test_S7601C7, "S7601C7", ABISELECT(192,124));

#else // __cplusplus

extern void _ZN7S7601C7C1Ev();
extern void _ZN7S7601C7D1Ev();
Name_Map name_map_S7601C7[] = {
  NSPAIR(_ZN7S7601C7C1Ev),
  NSPAIR(_ZN7S7601C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
static Base_Class bases_S7601C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(160,112), //bcp->offset
    10, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7601C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7601C7[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY vtc_S7601C7[] = {
  0,
  0,
  ABISELECT(160,112),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern VTBL_ENTRY _ZTV7S7601C7[];
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__7S7601C7[] = {
  ABISELECT(160,112),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__7S7601C7[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
static  VTT_ENTRY vtt_S7601C7[] = {
  {&(_ZTV7S7601C7[5]),  5,20},
  {&(_ZTV7S7601C7[5]),  5,20},
  {&(_ZTV7S7601C7[16]),  16,20},
  {&(_tg__ZTV7S7601C2__7S7601C7[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__7S7601C7[6]),  6,10},
};
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
Class_Descriptor cd_S7601C7 = {  "S7601C7", // class name
  bases_S7601C7, 2,
  &(vtc_S7601C7[0]), // expected_vtbl_contents
  &(vtt_S7601C7[0]), // expected_vtt_contents
  ABISELECT(192,124), // object size
  NSPAIRA(_ZTI7S7601C7),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S7601C7),20, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7601C7),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S7601C8_nt  {
  __tsi64 s7601c8f0;
  void  mf7601c8(); // _ZN10S7601C8_nt8mf7601c8Ev
};
//SIG(1 S7601C8_nt) U1{ m FL}

#endif // __cplusplus
#ifdef __cplusplus

struct  S7601C6  : S7601C2 , S7601C3 , virtual S7601C7 {
  ::S7601C8_nt s7601c6f0;
  virtual  ~S7601C6(); // _ZN7S7601C6D2Ev
  virtual void  v13(); // _ZN7S7601C63v13Ev
  S7601C6(); // tgen
};
//SIG(-1 S7601C6) C1{ BC2{ VBC3{ v2 v3 v4 v5 Fp Fi} v6} BC3 VBC4{ VBC2 v7 v8 v9 v10 FD[9]} vd v1 FU5{ m FL}}


 S7601C6 ::~S7601C6(){ note_dtor("S7601C6", this);}
void  S7601C6 ::v13(){vfunc_called(this, "_ZN7S7601C63v13Ev");}
S7601C6 ::S7601C6(){ note_ctor("S7601C6", this);} // tgen

static void Test_S7601C6()
{
  extern Class_Descriptor cd_S7601C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(15,38)];
    init_test(&cd_S7601C6, buf);
    S7601C6 *dp, &lv = *(dp=new (buf) S7601C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,148), "sizeof(S7601C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7601C6)");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(40,24), "S7601C6");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(40,24), "S7601C6");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*), 0, "S7601C6");
    /*is_ambiguous_... S7601C6::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*), ABISELECT(8,4), "S7601C6");
    check_base_class_offset(lv, (S7601C2*)(S7601C7*), ABISELECT(64,36), "S7601C6");
    check_base_class_offset(lv, (S7601C7*), ABISELECT(64,36), "S7601C6");
    check_field_offset(lv, s7601c6f0, ABISELECT(32,16), "S7601C6.s7601c6f0");
    test_class_info(&lv, &cd_S7601C6);
    dp->~S7601C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C6(Test_S7601C6, "S7601C6", ABISELECT(224,148));

#else // __cplusplus

extern void _ZN7S7601C6C1Ev();
extern void _ZN7S7601C6D2Ev();
Name_Map name_map_S7601C6[] = {
  NSPAIR(_ZN7S7601C6C1Ev),
  NSPAIR(_ZN7S7601C6D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
static Base_Class bases_S7601C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(40,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7601C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7601C3,    ABISELECT(8,4), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7601C2,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7601C7,    ABISELECT(64,36), //bcp->offset
    25, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7601C6[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY vtc_S7601C6[] = {
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-12),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern VTBL_ENTRY _ZTV7S7601C6[];
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A__7S7601C6[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__A__7S7601C6[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C6[] = {
  0,
  0,
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C7__7S7601C6[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A1__7S7601C6[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__A1__7S7601C6[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
static  VTT_ENTRY vtt_S7601C6[] = {
  {&(_ZTV7S7601C6[5]),  5,39},
  {&(_tg__ZTV7S7601C2__A__7S7601C6[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__A__7S7601C6[6]),  6,10},
  {&(_ZTV7S7601C6[21]),  21,39},
  {&(_ZTV7S7601C6[34]),  34,39},
  {&(_ZTV7S7601C6[34]),  34,39},
  {&(_tg__ZTV7S7601C7__7S7601C6[5]),  5,10},
  {&(_tg__ZTV7S7601C7__7S7601C6[5]),  5,10},
  {&(_tg__ZTV7S7601C3__7S7601C7__7S7601C6[6]),  6,10},
  {&(_tg__ZTV7S7601C2__A1__7S7601C6[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__A1__7S7601C6[6]),  6,10},
};
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
Class_Descriptor cd_S7601C6 = {  "S7601C6", // class name
  bases_S7601C6, 5,
  &(vtc_S7601C6[0]), // expected_vtbl_contents
  &(vtt_S7601C6[0]), // expected_vtt_contents
  ABISELECT(224,148), // object size
  NSPAIRA(_ZTI7S7601C6),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S7601C6),39, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7601C6),11, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C9  : virtual S7601C7 , virtual S7601C6 , S7601C3 , S7601C2 {
  int s7601c9f0[3];
  virtual void  v14(); // _ZN7S7601C93v14Ev
  virtual void  v15(); // _ZN7S7601C93v15Ev
  virtual void  v16(); // _ZN7S7601C93v16Ev
  virtual void  v17(); // _ZN7S7601C93v17Ev
  ~S7601C9(); // tgen
  S7601C9(); // tgen
};
//SIG(-1 S7601C9) C1{ VBC2{ VBC3{ VBC4{ v5 v6 v7 v8 Fp Fi} v9} v10 v11 v12 v13 FD[9]} VBC5{ BC3 BC4 VBC2 vd v14 FU6{ m FL}} BC4 BC3 v1 v2 v3 v4 Fi[3]}


void  S7601C9 ::v14(){vfunc_called(this, "_ZN7S7601C93v14Ev");}
void  S7601C9 ::v15(){vfunc_called(this, "_ZN7S7601C93v15Ev");}
void  S7601C9 ::v16(){vfunc_called(this, "_ZN7S7601C93v16Ev");}
void  S7601C9 ::v17(){vfunc_called(this, "_ZN7S7601C93v17Ev");}
S7601C9 ::~S7601C9(){ note_dtor("S7601C9", this);} // tgen
S7601C9 ::S7601C9(){ note_ctor("S7601C9", this);} // tgen

static void Test_S7601C9()
{
  extern Class_Descriptor cd_S7601C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(18,45)];
    init_test(&cd_S7601C9, buf);
    S7601C9 *dp, &lv = *(dp=new (buf) S7601C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,176), "sizeof(S7601C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7601C9)");
    /*is_ambiguous_... S7601C9::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(208,140), "S7601C9");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C6*), ABISELECT(208,140), "S7601C9");
    /*is_ambiguous_... S7601C9::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(208,140), "S7601C9");
    check_base_class_offset(lv, (S7601C2*)(S7601C7*), ABISELECT(48,28), "S7601C9");
    check_base_class_offset(lv, (S7601C7*), ABISELECT(48,28), "S7601C9");
    check_base_class_offset(lv, (S7601C7*)(S7601C6*), ABISELECT(48,28), "S7601C9");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C6*), ABISELECT(232,152), "S7601C9");
    /*is_ambiguous_... S7601C6::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C6*), ABISELECT(240,156), "S7601C9");
    check_base_class_offset(lv, (S7601C6*), ABISELECT(232,152), "S7601C9");
    /*is_ambiguous_... S7601C9::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*), 0, "S7601C9");
    /*is_ambiguous_... S7601C9::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*), ABISELECT(24,12), "S7601C9");
    check_field_offset(lv, s7601c9f0, ABISELECT(32,16), "S7601C9.s7601c9f0");
    test_class_info(&lv, &cd_S7601C9);
    dp->~S7601C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C9(Test_S7601C9, "S7601C9", ABISELECT(272,176));

#else // __cplusplus

extern void _ZN7S7601C9C1Ev();
extern void _ZN7S7601C9D1Ev();
Name_Map name_map_S7601C9[] = {
  NSPAIR(_ZN7S7601C9C1Ev),
  NSPAIR(_ZN7S7601C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C6;
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
static Base_Class bases_S7601C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(208,140), //bcp->offset
    34, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7601C2,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7601C7,    ABISELECT(48,28), //bcp->offset
    20, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7601C2,    ABISELECT(232,152), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C3,    ABISELECT(240,156), //bcp->offset
    60, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C6,    ABISELECT(232,152), //bcp->offset
    44, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7601C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7601C2,    ABISELECT(24,12), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7601C9[];
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void _ZN7S7601C9D1Ev();
extern void _ZN7S7601C9D0Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev)();
extern void ABISELECT(_ZThn232_N7S7601C9D1Ev,_ZThn152_N7S7601C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev)();
extern void ABISELECT(_ZThn232_N7S7601C9D0Ev,_ZThn152_N7S7601C9D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY vtc_S7601C9[] = {
  ABISELECT(232,152),
  ABISELECT(208,140),
  ABISELECT(48,28),
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&_ZN7S7601C9D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C9D0Ev,
  ABISELECT(184,128),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-232,-152),
  0,
  ABISELECT(-184,-124),
  ABISELECT(-184,-124),
  ABISELECT(-24,-12),
  ABISELECT(-232,-152),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  ABISELECT(-240,-156),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern VTBL_ENTRY _ZTV7S7601C9[];
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A__7S7601C9[] = {
  ABISELECT(184,128),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__A__7S7601C9[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-184,-128),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C9[] = {
  0,
  0,
  ABISELECT(160,112),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C7__7S7601C9[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__7S7601C9[] = {
  ABISELECT(160,112),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__7S7601C9[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__7S7601C9[] = {
  ABISELECT(-184,-124),
  ABISELECT(-184,-124),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C6__A1__7S7601C9[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C6__A1__7S7601C9[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C6__7S7601C9[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C6__7S7601C9[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(160,112),
  ABISELECT(184,124),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
static  VTT_ENTRY vtt_S7601C9[] = {
  {&(_ZTV7S7601C9[6]),  6,66},
  {&(_tg__ZTV7S7601C2__A__7S7601C9[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__A__7S7601C9[6]),  6,10},
  {&(_ZTV7S7601C9[29]),  29,66},
  {&(_ZTV7S7601C9[29]),  29,66},
  {&(_ZTV7S7601C9[40]),  40,66},
  {&(_ZTV7S7601C9[56]),  56,66},
  {&(_ZTV7S7601C9[62]),  62,66},
  {&(_ZTV7S7601C9[19]),  19,66},
  {&(_tg__ZTV7S7601C7__7S7601C9[5]),  5,10},
  {&(_tg__ZTV7S7601C7__7S7601C9[5]),  5,10},
  {&(_tg__ZTV7S7601C3__7S7601C7__7S7601C9[6]),  6,10},
  {&(_tg__ZTV7S7601C2__7S7601C9[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__7S7601C9[6]),  6,10},
  {&(_tg__ZTV7S7601C6__7S7601C9[5]),  5,9},
  {&(_tg__ZTV7S7601C27S7601C6__A1__7S7601C9[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C6__A1__7S7601C9[6]),  6,10},
  {&(_tg__ZTV7S7601C3__7S7601C6__7S7601C9[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C6__7S7601C9[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C6__7S7601C9[9]),  9,14},
};
extern VTBL_ENTRY _ZTI7S7601C9[];
extern  VTBL_ENTRY _ZTV7S7601C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C9[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N7S7601C9D0Ev,_ZThn152_N7S7601C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn232_N7S7601C9D1Ev,_ZThn152_N7S7601C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7601C9 = {  "S7601C9", // class name
  bases_S7601C9, 8,
  &(vtc_S7601C9[0]), // expected_vtbl_contents
  &(vtt_S7601C9[0]), // expected_vtt_contents
  ABISELECT(272,176), // object size
  NSPAIRA(_ZTI7S7601C9),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S7601C9),66, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7601C9),20, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C11  : virtual S7601C7 , virtual S7601C6 {
  ::S7601C8_nt s7601c11f0;
  virtual void  v18(); // _ZN8S7601C113v18Ev
  virtual void  v19(); // _ZN8S7601C113v19Ev
  virtual void  v20(); // _ZN8S7601C113v20Ev
  virtual void  v21(); // _ZN8S7601C113v21Ev
  virtual void  v22(); // _ZN8S7601C113v22Ev
  virtual void  v23(); // _ZN8S7601C113v23Ev
  ~S7601C11(); // tgen
  S7601C11(); // tgen
};
//SIG(-1 S7601C11) C1{ VBC2{ VBC3{ VBC4{ v7 v8 v9 v10 Fp Fi} v11} v12 v13 v14 v15 FD[9]} VBC5{ BC3 BC4 VBC2 vd v16 FU6{ m FL}} v1 v2 v3 v4 v5 v6 FU6}


void  S7601C11 ::v18(){vfunc_called(this, "_ZN8S7601C113v18Ev");}
void  S7601C11 ::v19(){vfunc_called(this, "_ZN8S7601C113v19Ev");}
void  S7601C11 ::v20(){vfunc_called(this, "_ZN8S7601C113v20Ev");}
void  S7601C11 ::v21(){vfunc_called(this, "_ZN8S7601C113v21Ev");}
void  S7601C11 ::v22(){vfunc_called(this, "_ZN8S7601C113v22Ev");}
void  S7601C11 ::v23(){vfunc_called(this, "_ZN8S7601C113v23Ev");}
S7601C11 ::~S7601C11(){ note_dtor("S7601C11", this);} // tgen
S7601C11 ::S7601C11(){ note_ctor("S7601C11", this);} // tgen

static void Test_S7601C11()
{
  extern Class_Descriptor cd_S7601C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(16,41)];
    init_test(&cd_S7601C11, buf);
    S7601C11 *dp, &lv = *(dp=new (buf) S7601C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,160), "sizeof(S7601C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7601C11)");
    /*is_ambiguous_... S7601C11::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(176,124), "S7601C11");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C6*), ABISELECT(176,124), "S7601C11");
    check_base_class_offset(lv, (S7601C2*)(S7601C7*), 0, "S7601C11");
    check_base_class_offset(lv, (S7601C7*), ABISELECT(16,12), "S7601C11");
    check_base_class_offset(lv, (S7601C7*)(S7601C6*), ABISELECT(16,12), "S7601C11");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C6*), ABISELECT(200,136), "S7601C11");
    /*is_ambiguous_... S7601C6::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C6*), ABISELECT(208,140), "S7601C11");
    check_base_class_offset(lv, (S7601C6*), ABISELECT(200,136), "S7601C11");
    check_field_offset(lv, s7601c11f0, ABISELECT(8,4), "S7601C11.s7601c11f0");
    test_class_info(&lv, &cd_S7601C11);
    dp->~S7601C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C11(Test_S7601C11, "S7601C11", ABISELECT(240,160));

#else // __cplusplus

extern void _ZN8S7601C11C1Ev();
extern void _ZN8S7601C11D1Ev();
Name_Map name_map_S7601C11[] = {
  NSPAIR(_ZN8S7601C11C1Ev),
  NSPAIR(_ZN8S7601C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C6;
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
static Base_Class bases_S7601C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(176,124), //bcp->offset
    30, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7601C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7601C7,    ABISELECT(16,12), //bcp->offset
    16, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7601C2,    ABISELECT(200,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C3,    ABISELECT(208,140), //bcp->offset
    56, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C6,    ABISELECT(200,136), //bcp->offset
    40, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7601C11[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C11D1Ev();
extern void _ZN8S7601C11D0Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev)();
extern void ABISELECT(_ZThn200_N8S7601C11D1Ev,_ZThn136_N8S7601C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev)();
extern void ABISELECT(_ZThn200_N8S7601C11D0Ev,_ZThn136_N8S7601C11D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY vtc_S7601C11[] = {
  ABISELECT(200,136),
  0,
  ABISELECT(16,12),
  0,
  ABISELECT(176,124),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D0Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(160,112),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-124),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-200,-136),
  0,
  ABISELECT(-200,-136),
  ABISELECT(-184,-124),
  ABISELECT(-24,-12),
  ABISELECT(-200,-136),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern VTBL_ENTRY _ZTV8S7601C11[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C11[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(160,112),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__7S7601C7__8S7601C11[] = {
  0,
  ABISELECT(176,124),
  ABISELECT(16,12),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C7__8S7601C11[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__8S7601C11[] = {
  ABISELECT(176,124),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__8S7601C11[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-176,-124),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C11[] = {
  ABISELECT(-200,-136),
  ABISELECT(-184,-124),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C6__A1__8S7601C11[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C6__A1__8S7601C11[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C6__8S7601C11[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C6__8S7601C11[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(160,112),
  ABISELECT(184,124),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A1__7S7601C6__8S7601C11[] = {
  0,
  ABISELECT(176,124),
  ABISELECT(200,136),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
static  VTT_ENTRY vtt_S7601C11[] = {
  {&(_ZTV8S7601C11[7]),  7,62},
  {&(_ZTV8S7601C11[25]),  25,62},
  {&(_ZTV8S7601C11[7]),  7,62},
  {&(_ZTV8S7601C11[36]),  36,62},
  {&(_ZTV8S7601C11[52]),  52,62},
  {&(_ZTV8S7601C11[58]),  58,62},
  {&(_tg__ZTV7S7601C7__8S7601C11[5]),  5,10},
  {&(_tg__ZTV7S7601C2__7S7601C7__8S7601C11[4]),  4,5},
  {&(_tg__ZTV7S7601C3__7S7601C7__8S7601C11[6]),  6,10},
  {&(_tg__ZTV7S7601C2__8S7601C11[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__8S7601C11[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C11[5]),  5,9},
  {&(_tg__ZTV7S7601C27S7601C6__A1__8S7601C11[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C6__A1__8S7601C11[6]),  6,10},
  {&(_tg__ZTV7S7601C3__7S7601C6__8S7601C11[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C6__8S7601C11[9]),  9,14},
  {&(_tg__ZTV7S7601C2__A1__7S7601C6__8S7601C11[4]),  4,5},
};
extern VTBL_ENTRY _ZTI8S7601C11[];
extern  VTBL_ENTRY _ZTV8S7601C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C11[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S7601C11D0Ev,_ZThn136_N8S7601C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S7601C11D1Ev,_ZThn136_N8S7601C11D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7601C11 = {  "S7601C11", // class name
  bases_S7601C11, 6,
  &(vtc_S7601C11[0]), // expected_vtbl_contents
  &(vtt_S7601C11[0]), // expected_vtt_contents
  ABISELECT(240,160), // object size
  NSPAIRA(_ZTI8S7601C11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S7601C11),62, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7601C11),17, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C10  : S7601C11 {
  virtual  ~S7601C10(); // _ZN8S7601C10D2Ev
  virtual void  v24(); // _ZN8S7601C103v24Ev
  virtual void  v25(); // _ZN8S7601C103v25Ev
  virtual void  v26(); // _ZN8S7601C103v26Ev
  S7601C10(); // tgen
};
//SIG(-1 S7601C10) C1{ BC2{ VBC3{ VBC4{ VBC5{ v4 v5 v6 v7 Fp Fi} v8} v9 v10 v11 v12 FD[9]} VBC6{ BC4 BC5 VBC3 vd v13 FU7{ m FL}} v14 v15 v16 v17 v18 v19 FU7} vd v1 v2 v3}


 S7601C10 ::~S7601C10(){ note_dtor("S7601C10", this);}
void  S7601C10 ::v24(){vfunc_called(this, "_ZN8S7601C103v24Ev");}
void  S7601C10 ::v25(){vfunc_called(this, "_ZN8S7601C103v25Ev");}
void  S7601C10 ::v26(){vfunc_called(this, "_ZN8S7601C103v26Ev");}
S7601C10 ::S7601C10(){ note_ctor("S7601C10", this);} // tgen

static void Test_S7601C10()
{
  extern Class_Descriptor cd_S7601C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(16,41)];
    init_test(&cd_S7601C10, buf);
    S7601C10 *dp, &lv = *(dp=new (buf) S7601C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(240,160), "sizeof(S7601C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7601C10)");
    /*is_ambiguous_... S7601C10::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(176,124), "S7601C10");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C6*), ABISELECT(176,124), "S7601C10");
    check_base_class_offset(lv, (S7601C2*)(S7601C7*), 0, "S7601C10");
    check_base_class_offset(lv, (S7601C7*)(S7601C11*), ABISELECT(16,12), "S7601C10");
    check_base_class_offset(lv, (S7601C7*)(S7601C6*), ABISELECT(16,12), "S7601C10");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C6*), ABISELECT(200,136), "S7601C10");
    /*is_ambiguous_... S7601C6::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C6*), ABISELECT(208,140), "S7601C10");
    check_base_class_offset(lv, (S7601C6*)(S7601C11*), ABISELECT(200,136), "S7601C10");
    check_base_class_offset(lv, (S7601C11*), 0, "S7601C10");
    test_class_info(&lv, &cd_S7601C10);
    dp->~S7601C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C10(Test_S7601C10, "S7601C10", ABISELECT(240,160));

#else // __cplusplus

extern void _ZN8S7601C10C1Ev();
extern void _ZN8S7601C10D2Ev();
Name_Map name_map_S7601C10[] = {
  NSPAIR(_ZN8S7601C10C1Ev),
  NSPAIR(_ZN8S7601C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C6;
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
extern Class_Descriptor cd_S7601C11;
extern VTBL_ENTRY _ZTI8S7601C11[];
extern  VTBL_ENTRY _ZTV8S7601C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C11[];
static Base_Class bases_S7601C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(176,124), //bcp->offset
    33, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7601C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S7601C7,    ABISELECT(16,12), //bcp->offset
    19, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7601C2,    ABISELECT(200,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C3,    ABISELECT(208,140), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C6,    ABISELECT(200,136), //bcp->offset
    43, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S7601C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7601C10[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C10D1Ev();
extern void _ZN8S7601C10D0Ev();
extern void _ZN8S7601C103v24Ev();
extern void _ZN8S7601C103v25Ev();
extern void _ZN8S7601C103v26Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C10D1Ev,_ZTv0_n28_N8S7601C10D1Ev)();
extern void ABISELECT(_ZThn200_N8S7601C10D1Ev,_ZThn136_N8S7601C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7601C10D0Ev,_ZTv0_n28_N8S7601C10D0Ev)();
extern void ABISELECT(_ZThn200_N8S7601C10D0Ev,_ZThn136_N8S7601C10D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY vtc_S7601C10[] = {
  ABISELECT(200,136),
  0,
  ABISELECT(16,12),
  0,
  ABISELECT(176,124),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v24Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v25Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v26Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(160,112),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-124),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-200,-136),
  0,
  ABISELECT(-200,-136),
  ABISELECT(-184,-124),
  ABISELECT(-24,-12),
  ABISELECT(-200,-136),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C10D1Ev,_ZTv0_n28_N8S7601C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C10D0Ev,_ZTv0_n28_N8S7601C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern VTBL_ENTRY _ZTV8S7601C10[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C11D1Ev();
extern void _ZN8S7601C11D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C11__8S7601C10[] = {
  ABISELECT(200,136),
  0,
  ABISELECT(16,12),
  0,
  ABISELECT(176,124),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D0Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C11__8S7601C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(160,112),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C11__8S7601C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-176,-124),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev)();
extern void ABISELECT(_ZThn200_N8S7601C11D1Ev,_ZThn136_N8S7601C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev)();
extern void ABISELECT(_ZThn200_N8S7601C11D0Ev,_ZThn136_N8S7601C11D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C11__8S7601C10[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-200,-136),
  0,
  ABISELECT(-200,-136),
  ABISELECT(-184,-124),
  ABISELECT(-24,-12),
  ABISELECT(-200,-136),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C11__8S7601C10[] = {
  ABISELECT(-208,-140),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C10[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(160,112),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__7S7601C7__8S7601C10[] = {
  0,
  ABISELECT(176,124),
  ABISELECT(16,12),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C7__8S7601C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__8S7601C10[] = {
  ABISELECT(176,124),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__8S7601C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-176,-124),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C10[] = {
  ABISELECT(-200,-136),
  ABISELECT(-184,-124),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C6__A1__8S7601C10[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C6__A1__8S7601C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C6__8S7601C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C6__8S7601C10[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  ABISELECT(160,112),
  ABISELECT(184,124),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A1__7S7601C6__8S7601C10[] = {
  0,
  ABISELECT(176,124),
  ABISELECT(200,136),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
static  VTT_ENTRY vtt_S7601C10[] = {
  {&(_ZTV8S7601C10[7]),  7,65},
  {&(_tg__ZTV8S7601C11__8S7601C10[7]),  7,16},
  {&(_tg__ZTV7S7601C7__8S7601C11__8S7601C10[9]),  9,14},
  {&(_tg__ZTV8S7601C11__8S7601C10[7]),  7,16},
  {&(_tg__ZTV7S7601C3__8S7601C11__8S7601C10[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C11__8S7601C10[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__8S7601C11__8S7601C10[2]),  2,6},
  {&(_ZTV8S7601C10[28]),  28,65},
  {&(_ZTV8S7601C10[7]),  7,65},
  {&(_ZTV8S7601C10[39]),  39,65},
  {&(_ZTV8S7601C10[55]),  55,65},
  {&(_ZTV8S7601C10[61]),  61,65},
  {&(_tg__ZTV7S7601C7__8S7601C10[5]),  5,10},
  {&(_tg__ZTV7S7601C2__7S7601C7__8S7601C10[4]),  4,5},
  {&(_tg__ZTV7S7601C3__7S7601C7__8S7601C10[6]),  6,10},
  {&(_tg__ZTV7S7601C2__8S7601C10[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__8S7601C10[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C10[5]),  5,9},
  {&(_tg__ZTV7S7601C27S7601C6__A1__8S7601C10[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C6__A1__8S7601C10[6]),  6,10},
  {&(_tg__ZTV7S7601C3__7S7601C6__8S7601C10[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C6__8S7601C10[9]),  9,14},
  {&(_tg__ZTV7S7601C2__A1__7S7601C6__8S7601C10[4]),  4,5},
};
extern VTBL_ENTRY _ZTI8S7601C10[];
extern  VTBL_ENTRY _ZTV8S7601C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C10[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S7601C11D0Ev,_ZThn136_N8S7601C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S7601C11D1Ev,_ZThn136_N8S7601C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7601C10D0Ev,_ZTv0_n28_N8S7601C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S7601C10D0Ev,_ZThn136_N8S7601C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7601C10D1Ev,_ZTv0_n28_N8S7601C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn200_N8S7601C10D1Ev,_ZThn136_N8S7601C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7601C10 = {  "S7601C10", // class name
  bases_S7601C10, 7,
  &(vtc_S7601C10[0]), // expected_vtbl_contents
  &(vtt_S7601C10[0]), // expected_vtt_contents
  ABISELECT(240,160), // object size
  NSPAIRA(_ZTI8S7601C10),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S7601C10),65, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7601C10),23, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C5  : virtual S7601C3 , virtual S7601C6 , S7601C9 , virtual S7601C10 {
  int s7601c5f0;
  int s7601c5f1;
  virtual void  v27(); // _ZN7S7601C53v27Ev
  virtual void  v28(); // _ZN7S7601C53v28Ev
  ~S7601C5(); // tgen
  S7601C5(); // tgen
};
//SIG(-1 S7601C5) C1{ VBC2{ v3 v4 v5 v6 Fp Fi} VBC3{ BC4{ VBC2 v7} BC2 VBC5{ VBC4 v8 v9 v10 v11 FD[9]} vd v12 FU6{ m FL}} BC7{ VBC5 VBC3 BC2 BC4 v13 v14 v15 v16 Fi[3]} VBC8{ BC9{ VBC5 VBC3 v17 v18 v19 v20 v21 v22 FU6} vd v23 v24 v25} v1 v2 Fi Fi}


void  S7601C5 ::v27(){vfunc_called(this, "_ZN7S7601C53v27Ev");}
void  S7601C5 ::v28(){vfunc_called(this, "_ZN7S7601C53v28Ev");}
S7601C5 ::~S7601C5(){ note_dtor("S7601C5", this);} // tgen
S7601C5 ::S7601C5(){ note_ctor("S7601C5", this);} // tgen

static void Test_S7601C5()
{
  extern Class_Descriptor cd_S7601C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(20,50)];
    init_test(&cd_S7601C5, buf);
    S7601C5 *dp, &lv = *(dp=new (buf) S7601C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,196), "sizeof(S7601C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7601C5)");
    /*is_ambiguous_... S7601C5::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*), ABISELECT(56,36), "S7601C5");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C6*), ABISELECT(56,36), "S7601C5");
    /*is_ambiguous_... S7601C5::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(56,36), "S7601C5");
    /*is_ambiguous_... S7601C9::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C9*), ABISELECT(56,36), "S7601C5");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C6*), ABISELECT(80,48), "S7601C5");
    /*is_ambiguous_... S7601C6::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C6*), ABISELECT(88,52), "S7601C5");
    check_base_class_offset(lv, (S7601C2*)(S7601C7*), ABISELECT(128,72), "S7601C5");
    check_base_class_offset(lv, (S7601C7*)(S7601C6*), ABISELECT(128,72), "S7601C5");
    check_base_class_offset(lv, (S7601C7*)(S7601C9*), ABISELECT(128,72), "S7601C5");
    check_base_class_offset(lv, (S7601C7*)(S7601C11*)(S7601C10*), ABISELECT(128,72), "S7601C5");
    check_base_class_offset(lv, (S7601C6*), ABISELECT(80,48), "S7601C5");
    check_base_class_offset(lv, (S7601C6*)(S7601C9*), ABISELECT(80,48), "S7601C5");
    check_base_class_offset(lv, (S7601C6*)(S7601C11*)(S7601C10*), ABISELECT(80,48), "S7601C5");
    /*is_ambiguous_... S7601C9::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C9*), 0, "S7601C5");
    /*is_ambiguous_... S7601C9::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C9*), ABISELECT(24,12), "S7601C5");
    check_base_class_offset(lv, (S7601C9*), 0, "S7601C5");
    check_base_class_offset(lv, (S7601C11*)(S7601C10*), ABISELECT(288,184), "S7601C5");
    check_base_class_offset(lv, (S7601C10*), ABISELECT(288,184), "S7601C5");
    check_field_offset(lv, s7601c5f0, ABISELECT(44,28), "S7601C5.s7601c5f0");
    check_field_offset(lv, s7601c5f1, ABISELECT(48,32), "S7601C5.s7601c5f1");
    test_class_info(&lv, &cd_S7601C5);
    dp->~S7601C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C5(Test_S7601C5, "S7601C5", ABISELECT(304,196));

#else // __cplusplus

extern void _ZN7S7601C5C1Ev();
extern void _ZN7S7601C5D1Ev();
Name_Map name_map_S7601C5[] = {
  NSPAIR(_ZN7S7601C5C1Ev),
  NSPAIR(_ZN7S7601C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
extern Class_Descriptor cd_S7601C6;
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C9;
extern VTBL_ENTRY _ZTI7S7601C9[];
extern  VTBL_ENTRY _ZTV7S7601C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C9[];
extern Class_Descriptor cd_S7601C11;
extern VTBL_ENTRY _ZTI8S7601C11[];
extern  VTBL_ENTRY _ZTV8S7601C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C11[];
extern Class_Descriptor cd_S7601C10;
extern VTBL_ENTRY _ZTI8S7601C10[];
extern  VTBL_ENTRY _ZTV8S7601C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C10[];
static Base_Class bases_S7601C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(56,36), //bcp->offset
    23, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7601C2,    ABISELECT(80,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C3,    ABISELECT(88,52), //bcp->offset
    49, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C2,    ABISELECT(128,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7601C7,    ABISELECT(128,72), //bcp->offset
    55, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7601C6,    ABISELECT(80,48), //bcp->offset
    33, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7601C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7601C2,    ABISELECT(24,12), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7601C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7601C11,    ABISELECT(288,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7601C10,    ABISELECT(288,184), //bcp->offset
    69, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    29, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S7601C5[];
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void _ZN7S7601C5D1Ev();
extern void _ZN7S7601C5D0Ev();
extern void _ZN7S7601C53v27Ev();
extern void _ZN7S7601C53v28Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N7S7601C5D1Ev,_ZTv0_n28_N7S7601C5D1Ev)();
extern void ABISELECT(_ZThn80_N7S7601C5D1Ev,_ZThn48_N7S7601C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7601C5D0Ev,_ZTv0_n28_N7S7601C5D0Ev)();
extern void ABISELECT(_ZThn80_N7S7601C5D0Ev,_ZThn48_N7S7601C5D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void ABISELECT(_ZTv0_n112_N7S7601C5D1Ev,_ZTv0_n56_N7S7601C5D1Ev)();
extern void ABISELECT(_ZThn288_N7S7601C5D1Ev,_ZThn184_N7S7601C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n112_N7S7601C5D0Ev,_ZTv0_n56_N7S7601C5D0Ev)();
extern void ABISELECT(_ZThn288_N7S7601C5D0Ev,_ZThn184_N7S7601C5D0Ev)() __attribute__((weak));
extern void _ZN8S7601C103v24Ev();
extern void _ZN8S7601C103v25Ev();
extern void _ZN8S7601C103v26Ev();
static  VTBL_ENTRY vtc_S7601C5[] = {
  ABISELECT(288,184),
  ABISELECT(80,48),
  ABISELECT(56,36),
  ABISELECT(128,72),
  ABISELECT(128,72),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&_ZN7S7601C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C5D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C53v27Ev,
  (VTBL_ENTRY)&_ZN7S7601C53v28Ev,
  ABISELECT(32,24),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-80,-48),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C5D1Ev,_ZTv0_n28_N7S7601C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C5D0Ev,_ZTv0_n28_N7S7601C5D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  ABISELECT(-88,-52),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(-128,-72),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  0,
  0,
  0,
  ABISELECT(-288,-184),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-232,-148),
  ABISELECT(-288,-184),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N7S7601C5D1Ev,_ZTv0_n56_N7S7601C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N7S7601C5D0Ev,_ZTv0_n56_N7S7601C5D0Ev),
  (VTBL_ENTRY)&_ZN8S7601C103v24Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v25Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v26Ev,
};
extern VTBL_ENTRY _ZTV7S7601C5[];
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void _ZN7S7601C9D1Ev();
extern void _ZN7S7601C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C9__7S7601C5[] = {
  ABISELECT(80,48),
  ABISELECT(56,36),
  ABISELECT(128,72),
  ABISELECT(128,72),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&_ZN7S7601C9D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C9D0Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C9__A2__7S7601C5[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C9__A2__7S7601C5[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C9__7S7601C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(-128,-72),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C9__7S7601C5[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev)();
extern void ABISELECT(_ZThn80_N7S7601C9D1Ev,_ZThn48_N7S7601C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev)();
extern void ABISELECT(_ZThn80_N7S7601C9D0Ev,_ZThn48_N7S7601C9D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__7S7601C9__7S7601C5[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-80,-48),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__7S7601C9__7S7601C5[] = {
  ABISELECT(-88,-52),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A__7S7601C9__7S7601C5[] = {
  ABISELECT(32,24),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__7S7601C5[] = {
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C6__7S7601C5[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C6__7S7601C5[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C6__7S7601C5[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C6__7S7601C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C5[] = {
  0,
  0,
  ABISELECT(-72,-36),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C7__7S7601C5[] = {
  0,
  0,
  0,
  0,
  ABISELECT(72,36),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A1__7S7601C5[] = {
  ABISELECT(-72,-36),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__A1__7S7601C5[] = {
  0,
  0,
  0,
  0,
  ABISELECT(72,36),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C10D1Ev();
extern void _ZN8S7601C10D0Ev();
extern void _ZN8S7601C103v24Ev();
extern void _ZN8S7601C103v25Ev();
extern void _ZN8S7601C103v26Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C10__7S7601C5[] = {
  ABISELECT(-208,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-232,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v24Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v25Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v26Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C11D1Ev();
extern void _ZN8S7601C11D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C118S7601C10__7S7601C5[] = {
  ABISELECT(-208,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-232,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D0Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C118S7601C10__7S7601C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(160,112),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C118S7601C10__7S7601C5[] = {
  0,
  0,
  0,
  0,
  ABISELECT(232,148),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev)();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C118S7601C10__7S7601C5[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(208,136),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(208,136),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C118S7601C10__7S7601C5[] = {
  ABISELECT(200,132),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C10__7S7601C5[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(160,112),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C10__7S7601C5[] = {
  0,
  0,
  0,
  0,
  ABISELECT(232,148),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C10D1Ev,_ZTv0_n28_N8S7601C10D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S7601C10D0Ev,_ZTv0_n28_N8S7601C10D0Ev)();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C10__7S7601C5[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(208,136),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(208,136),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C10D1Ev,_ZTv0_n28_N8S7601C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C10D0Ev,_ZTv0_n28_N8S7601C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C10__7S7601C5[] = {
  ABISELECT(200,132),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
static  VTT_ENTRY vtt_S7601C5[] = {
  {&(_ZTV7S7601C5[7]),  7,98},
  {&(_tg__ZTV7S7601C9__7S7601C5[6]),  6,16},
  {&(_tg__ZTV7S7601C27S7601C9__A2__7S7601C5[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C9__A2__7S7601C5[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C9__7S7601C5[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C9__7S7601C5[9]),  9,14},
  {&(_tg__ZTV7S7601C3__7S7601C9__7S7601C5[6]),  6,10},
  {&(_tg__ZTV7S7601C6__7S7601C9__7S7601C5[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__7S7601C9__7S7601C5[2]),  2,6},
  {&(_tg__ZTV7S7601C2__A__7S7601C9__7S7601C5[3]),  3,4},
  {&(_ZTV7S7601C5[29]),  29,98},
  {&(_ZTV7S7601C5[45]),  45,98},
  {&(_ZTV7S7601C5[51]),  51,98},
  {&(_ZTV7S7601C5[64]),  64,98},
  {&(_ZTV7S7601C5[64]),  64,98},
  {&(_ZTV7S7601C5[22]),  22,98},
  {&(_ZTV7S7601C5[86]),  86,98},
  {&(_tg__ZTV7S7601C6__7S7601C5[5]),  5,9},
  {&(_tg__ZTV7S7601C27S7601C6__7S7601C5[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C6__7S7601C5[6]),  6,10},
  {&(_tg__ZTV7S7601C3__7S7601C6__7S7601C5[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C6__7S7601C5[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C6__7S7601C5[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C5[5]),  5,10},
  {&(_tg__ZTV7S7601C7__7S7601C5[5]),  5,10},
  {&(_tg__ZTV7S7601C3__7S7601C7__7S7601C5[6]),  6,10},
  {&(_tg__ZTV7S7601C2__A1__7S7601C5[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__A1__7S7601C5[6]),  6,10},
  {&(_tg__ZTV8S7601C10__7S7601C5[7]),  7,19},
  {&(_tg__ZTV8S7601C118S7601C10__7S7601C5[7]),  7,16},
  {&(_tg__ZTV7S7601C7__8S7601C118S7601C10__7S7601C5[9]),  9,14},
  {&(_tg__ZTV7S7601C7__8S7601C118S7601C10__7S7601C5[9]),  9,14},
  {&(_tg__ZTV7S7601C3__8S7601C118S7601C10__7S7601C5[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C118S7601C10__7S7601C5[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__8S7601C118S7601C10__7S7601C5[2]),  2,6},
  {&(_tg__ZTV7S7601C7__8S7601C10__7S7601C5[9]),  9,14},
  {&(_tg__ZTV7S7601C7__8S7601C10__7S7601C5[9]),  9,14},
  {&(_tg__ZTV7S7601C3__8S7601C10__7S7601C5[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C10__7S7601C5[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__8S7601C10__7S7601C5[2]),  2,6},
};
extern VTBL_ENTRY _ZTI7S7601C5[];
extern  VTBL_ENTRY _ZTV7S7601C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C5[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N7S7601C9D0Ev,_ZThn48_N7S7601C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N7S7601C9D1Ev,_ZThn48_N7S7601C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n112_N7S7601C5D0Ev,_ZTv0_n56_N7S7601C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn288_N7S7601C5D0Ev,_ZThn184_N7S7601C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n112_N7S7601C5D1Ev,_ZTv0_n56_N7S7601C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn288_N7S7601C5D1Ev,_ZThn184_N7S7601C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C5D0Ev,_ZTv0_n28_N7S7601C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N7S7601C5D0Ev,_ZThn48_N7S7601C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C5D1Ev,_ZTv0_n28_N7S7601C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N7S7601C5D1Ev,_ZThn48_N7S7601C5D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7601C5 = {  "S7601C5", // class name
  bases_S7601C5, 11,
  &(vtc_S7601C5[0]), // expected_vtbl_contents
  &(vtt_S7601C5[0]), // expected_vtt_contents
  ABISELECT(304,196), // object size
  NSPAIRA(_ZTI7S7601C5),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S7601C5),98, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7601C5),40, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C4  : S7601C5 , S7601C9 , S7601C11 {
  virtual void  v29(); // _ZN7S7601C43v29Ev
  virtual void  v30(); // _ZN7S7601C43v30Ev
  virtual void  v31(); // _ZN7S7601C43v31Ev
  virtual void  v32(); // _ZN7S7601C43v32Ev
  virtual void  v33(); // _ZN7S7601C43v33Ev
  ~S7601C4(); // tgen
  S7601C4(); // tgen
};
//SIG(-1 S7601C4) C1{ BC2{ VBC3{ v6 v7 v8 v9 Fp Fi} VBC4{ BC5{ VBC3 v10} BC3 VBC6{ VBC5 v11 v12 v13 v14 FD[9]} vd v15 FU7{ m FL}} BC8{ VBC6 VBC4 BC3 BC5 v16 v17 v18 v19 Fi[3]} VBC9{ BC10{ VBC6 VBC4 v20 v21 v22 v23 v24 v25 FU7} vd v26 v27 v28} v29 v30 Fi Fi} BC8 BC10 v1 v2 v3 v4 v5}


void  S7601C4 ::v29(){vfunc_called(this, "_ZN7S7601C43v29Ev");}
void  S7601C4 ::v30(){vfunc_called(this, "_ZN7S7601C43v30Ev");}
void  S7601C4 ::v31(){vfunc_called(this, "_ZN7S7601C43v31Ev");}
void  S7601C4 ::v32(){vfunc_called(this, "_ZN7S7601C43v32Ev");}
void  S7601C4 ::v33(){vfunc_called(this, "_ZN7S7601C43v33Ev");}
S7601C4 ::~S7601C4(){ note_dtor("S7601C4", this);} // tgen
S7601C4 ::S7601C4(){ note_ctor("S7601C4", this);} // tgen

static void Test_S7601C4()
{
  extern Class_Descriptor cd_S7601C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(24,60)];
    init_test(&cd_S7601C4, buf);
    S7601C4 *dp, &lv = *(dp=new (buf) S7601C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,236), "sizeof(S7601C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7601C4)");
    /*is_ambiguous_... S7601C5::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C5*), ABISELECT(120,76), "S7601C4");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C6*), ABISELECT(120,76), "S7601C4");
    /*is_ambiguous_... S7601C4::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(120,76), "S7601C4");
    /*is_ambiguous_... S7601C9::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C9*)(S7601C5*), ABISELECT(120,76), "S7601C4");
    /*is_ambiguous_... S7601C4::S7601C9 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C9*), ABISELECT(120,76), "S7601C4");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C6*), ABISELECT(144,88), "S7601C4");
    /*is_ambiguous_... S7601C6::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C6*), ABISELECT(152,92), "S7601C4");
    check_base_class_offset(lv, (S7601C2*)(S7601C7*), ABISELECT(192,112), "S7601C4");
    check_base_class_offset(lv, (S7601C7*)(S7601C6*), ABISELECT(192,112), "S7601C4");
    check_base_class_offset(lv, (S7601C7*)(S7601C9*)(S7601C5*), ABISELECT(192,112), "S7601C4");
    check_base_class_offset(lv, (S7601C7*)(S7601C11*)(S7601C10*), ABISELECT(192,112), "S7601C4");
    /*is_ambiguous_... S7601C4::S7601C9 */ AMB_check_base_class_offset(lv, (S7601C7*)(S7601C9*), ABISELECT(192,112), "S7601C4");
    /*is_ambiguous_... S7601C4::S7601C11 */ AMB_check_base_class_offset(lv, (S7601C7*)(S7601C11*), ABISELECT(192,112), "S7601C4");
    check_base_class_offset(lv, (S7601C6*)(S7601C5*), ABISELECT(144,88), "S7601C4");
    check_base_class_offset(lv, (S7601C6*)(S7601C9*)(S7601C5*), ABISELECT(144,88), "S7601C4");
    check_base_class_offset(lv, (S7601C6*)(S7601C11*)(S7601C10*), ABISELECT(144,88), "S7601C4");
    /*is_ambiguous_... S7601C4::S7601C9 */ AMB_check_base_class_offset(lv, (S7601C6*)(S7601C9*), ABISELECT(144,88), "S7601C4");
    /*is_ambiguous_... S7601C4::S7601C11 */ AMB_check_base_class_offset(lv, (S7601C6*)(S7601C11*), ABISELECT(144,88), "S7601C4");
    /*is_ambiguous_... S7601C9::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C9*)(S7601C5*), 0, "S7601C4");
    /*is_ambiguous_... S7601C9::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C9*)(S7601C5*), ABISELECT(24,12), "S7601C4");
    check_base_class_offset(lv, (S7601C9*)(S7601C5*), 0, "S7601C4");
    check_base_class_offset(lv, (S7601C11*)(S7601C10*), ABISELECT(352,224), "S7601C4");
    check_base_class_offset(lv, (S7601C10*)(S7601C5*), ABISELECT(352,224), "S7601C4");
    check_base_class_offset(lv, (S7601C5*), 0, "S7601C4");
    /*is_ambiguous_... S7601C4::S7601C9 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C9*), ABISELECT(56,36), "S7601C4");
    /*is_ambiguous_... S7601C4::S7601C9 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C9*), ABISELECT(80,48), "S7601C4");
    /*is_ambiguous_... S7601C4::S7601C9 */ AMB_check_base_class_offset(lv, (S7601C9*), ABISELECT(56,36), "S7601C4");
    /*is_ambiguous_... S7601C4::S7601C11 */ AMB_check_base_class_offset(lv, (S7601C11*), ABISELECT(104,64), "S7601C4");
    test_class_info(&lv, &cd_S7601C4);
    dp->~S7601C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C4(Test_S7601C4, "S7601C4", ABISELECT(368,236));

#else // __cplusplus

extern void _ZN7S7601C4C1Ev();
extern void _ZN7S7601C4D1Ev();
Name_Map name_map_S7601C4[] = {
  NSPAIR(_ZN7S7601C4C1Ev),
  NSPAIR(_ZN7S7601C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
extern Class_Descriptor cd_S7601C6;
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C9;
extern VTBL_ENTRY _ZTI7S7601C9[];
extern  VTBL_ENTRY _ZTV7S7601C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C9[];
extern Class_Descriptor cd_S7601C11;
extern VTBL_ENTRY _ZTI8S7601C11[];
extern  VTBL_ENTRY _ZTV8S7601C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C11[];
extern Class_Descriptor cd_S7601C10;
extern VTBL_ENTRY _ZTI8S7601C10[];
extern  VTBL_ENTRY _ZTV8S7601C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C10[];
extern Class_Descriptor cd_S7601C5;
extern VTBL_ENTRY _ZTI7S7601C5[];
extern  VTBL_ENTRY _ZTV7S7601C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C5[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C9;
extern VTBL_ENTRY _ZTI7S7601C9[];
extern  VTBL_ENTRY _ZTV7S7601C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C9[];
extern Class_Descriptor cd_S7601C11;
extern VTBL_ENTRY _ZTI8S7601C11[];
extern  VTBL_ENTRY _ZTV8S7601C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C11[];
static Base_Class bases_S7601C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(120,76), //bcp->offset
    64, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7601C2,    ABISELECT(144,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C3,    ABISELECT(152,92), //bcp->offset
    90, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C2,    ABISELECT(192,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    53, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7601C7,    ABISELECT(192,112), //bcp->offset
    96, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7601C6,    ABISELECT(144,88), //bcp->offset
    74, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7601C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7601C2,    ABISELECT(24,12), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7601C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7601C11,    ABISELECT(352,224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7601C10,    ABISELECT(352,224), //bcp->offset
    110, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S7601C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7601C3,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7601C2,    ABISELECT(80,48), //bcp->offset
    44, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S7601C9,    ABISELECT(56,36), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7601C11,    ABISELECT(104,64), //bcp->offset
    48, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S7601C4[];
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void _ZN7S7601C4D1Ev();
extern void _ZN7S7601C4D0Ev();
extern void _ZN7S7601C53v27Ev();
extern void _ZN7S7601C53v28Ev();
extern void _ZN7S7601C43v29Ev();
extern void _ZN7S7601C43v30Ev();
extern void _ZN7S7601C43v31Ev();
extern void _ZN7S7601C43v32Ev();
extern void _ZN7S7601C43v33Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void ABISELECT(_ZThn56_N7S7601C4D1Ev,_ZThn36_N7S7601C4D1Ev)();
extern void ABISELECT(_ZThn56_N7S7601C4D0Ev,_ZThn36_N7S7601C4D0Ev)();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void ABISELECT(_ZThn104_N7S7601C4D1Ev,_ZThn64_N7S7601C4D1Ev)();
extern void ABISELECT(_ZThn104_N7S7601C4D0Ev,_ZThn64_N7S7601C4D0Ev)();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N7S7601C4D1Ev,_ZTv0_n28_N7S7601C4D1Ev)();
extern void ABISELECT(_ZThn144_N7S7601C4D1Ev,_ZThn88_N7S7601C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7601C4D0Ev,_ZTv0_n28_N7S7601C4D0Ev)();
extern void ABISELECT(_ZThn144_N7S7601C4D0Ev,_ZThn88_N7S7601C4D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void ABISELECT(_ZTv0_n112_N7S7601C4D1Ev,_ZTv0_n56_N7S7601C4D1Ev)();
extern void ABISELECT(_ZThn352_N7S7601C4D1Ev,_ZThn224_N7S7601C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n112_N7S7601C4D0Ev,_ZTv0_n56_N7S7601C4D0Ev)();
extern void ABISELECT(_ZThn352_N7S7601C4D0Ev,_ZThn224_N7S7601C4D0Ev)() __attribute__((weak));
extern void _ZN8S7601C103v24Ev();
extern void _ZN8S7601C103v25Ev();
extern void _ZN8S7601C103v26Ev();
static  VTBL_ENTRY vtc_S7601C4[] = {
  ABISELECT(352,224),
  ABISELECT(144,88),
  ABISELECT(120,76),
  ABISELECT(192,112),
  ABISELECT(192,112),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C4[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&_ZN7S7601C4D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C4D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C53v27Ev,
  (VTBL_ENTRY)&_ZN7S7601C53v28Ev,
  (VTBL_ENTRY)&_ZN7S7601C43v29Ev,
  (VTBL_ENTRY)&_ZN7S7601C43v30Ev,
  (VTBL_ENTRY)&_ZN7S7601C43v31Ev,
  (VTBL_ENTRY)&_ZN7S7601C43v32Ev,
  (VTBL_ENTRY)&_ZN7S7601C43v33Ev,
  ABISELECT(96,64),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S7601C4[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  ABISELECT(88,52),
  ABISELECT(64,40),
  ABISELECT(136,76),
  ABISELECT(136,76),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI7S7601C4[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N7S7601C4D1Ev,_ZThn36_N7S7601C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn56_N7S7601C4D0Ev,_ZThn36_N7S7601C4D0Ev),
  ABISELECT(40,28),
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI7S7601C4[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  ABISELECT(40,24),
  ABISELECT(88,48),
  ABISELECT(88,48),
  ABISELECT(88,48),
  ABISELECT(16,12),
  ABISELECT(-104,-64),
  (VTBL_ENTRY)&(_ZTI7S7601C4[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N7S7601C4D1Ev,_ZThn64_N7S7601C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn104_N7S7601C4D0Ev,_ZThn64_N7S7601C4D0Ev),
  0,
  0,
  0,
  0,
  ABISELECT(-120,-76),
  (VTBL_ENTRY)&(_ZTI7S7601C4[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-144,-88),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI7S7601C4[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C4D1Ev,_ZTv0_n28_N7S7601C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C4D0Ev,_ZTv0_n28_N7S7601C4D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  ABISELECT(-152,-92),
  (VTBL_ENTRY)&(_ZTI7S7601C4[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(-192,-112),
  (VTBL_ENTRY)&(_ZTI7S7601C4[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  0,
  0,
  0,
  ABISELECT(-352,-224),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-232,-148),
  ABISELECT(-352,-224),
  (VTBL_ENTRY)&(_ZTI7S7601C4[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N7S7601C4D1Ev,_ZTv0_n56_N7S7601C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N7S7601C4D0Ev,_ZTv0_n56_N7S7601C4D0Ev),
  (VTBL_ENTRY)&_ZN8S7601C103v24Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v25Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v26Ev,
};
extern VTBL_ENTRY _ZTV7S7601C4[];
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void _ZN7S7601C5D1Ev();
extern void _ZN7S7601C5D0Ev();
extern void _ZN7S7601C53v27Ev();
extern void _ZN7S7601C53v28Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C5__7S7601C4[] = {
  ABISELECT(352,224),
  ABISELECT(144,88),
  ABISELECT(120,76),
  ABISELECT(192,112),
  ABISELECT(192,112),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&_ZN7S7601C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C5D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C53v27Ev,
  (VTBL_ENTRY)&_ZN7S7601C53v28Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void _ZN7S7601C9D1Ev();
extern void _ZN7S7601C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C97S7601C5__7S7601C4[] = {
  ABISELECT(144,88),
  ABISELECT(120,76),
  ABISELECT(192,112),
  ABISELECT(192,112),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&_ZN7S7601C9D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C9D0Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C97S7601C5__A2__7S7601C4[] = {
  ABISELECT(96,64),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C97S7601C5__A2__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-96,-64),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C97S7601C5__7S7601C4[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(-192,-112),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C97S7601C5__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-120,-76),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev)();
extern void ABISELECT(_ZThn144_N7S7601C9D1Ev,_ZThn88_N7S7601C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev)();
extern void ABISELECT(_ZThn144_N7S7601C9D0Ev,_ZThn88_N7S7601C9D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__7S7601C97S7601C5__7S7601C4[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-144,-88),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__7S7601C97S7601C5__7S7601C4[] = {
  ABISELECT(-152,-92),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A__7S7601C97S7601C5__7S7601C4[] = {
  ABISELECT(96,64),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C5__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-120,-76),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N7S7601C5D1Ev,_ZTv0_n28_N7S7601C5D1Ev)();
extern void ABISELECT(_ZThn144_N7S7601C5D1Ev,_ZThn88_N7S7601C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7601C5D0Ev,_ZTv0_n28_N7S7601C5D0Ev)();
extern void ABISELECT(_ZThn144_N7S7601C5D0Ev,_ZThn88_N7S7601C5D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__7S7601C5__7S7601C4[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-144,-88),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C5D1Ev,_ZTv0_n28_N7S7601C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C5D0Ev,_ZTv0_n28_N7S7601C5D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__7S7601C5__7S7601C4[] = {
  ABISELECT(-152,-92),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C5__7S7601C4[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(-192,-112),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C9__A2__7S7601C5__7S7601C4[] = {
  ABISELECT(96,64),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void ABISELECT(_ZTv0_n112_N7S7601C5D1Ev,_ZTv0_n56_N7S7601C5D1Ev)();
extern void ABISELECT(_ZThn352_N7S7601C5D1Ev,_ZThn224_N7S7601C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n112_N7S7601C5D0Ev,_ZTv0_n56_N7S7601C5D0Ev)();
extern void ABISELECT(_ZThn352_N7S7601C5D0Ev,_ZThn224_N7S7601C5D0Ev)() __attribute__((weak));
extern void _ZN8S7601C103v24Ev();
extern void _ZN8S7601C103v25Ev();
extern void _ZN8S7601C103v26Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C10__7S7601C5__7S7601C4[] = {
  0,
  0,
  0,
  ABISELECT(-352,-224),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-232,-148),
  ABISELECT(-352,-224),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N7S7601C5D1Ev,_ZTv0_n56_N7S7601C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N7S7601C5D0Ev,_ZTv0_n56_N7S7601C5D0Ev),
  (VTBL_ENTRY)&_ZN8S7601C103v24Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v25Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v26Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void _ZN7S7601C9D1Ev();
extern void _ZN7S7601C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C9__A1__7S7601C4[] = {
  ABISELECT(88,52),
  ABISELECT(64,40),
  ABISELECT(136,76),
  ABISELECT(136,76),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&_ZN7S7601C9D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C9D0Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C9__A3__7S7601C4[] = {
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C9__A3__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C9__A1__7S7601C4[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(-136,-76),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C9__A1__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev)();
extern void ABISELECT(_ZThn88_N7S7601C9D1Ev,_ZThn52_N7S7601C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev)();
extern void ABISELECT(_ZThn88_N7S7601C9D0Ev,_ZThn52_N7S7601C9D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__7S7601C9__A1__7S7601C4[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-88,-52),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(-88,-52),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__7S7601C9__A1__7S7601C4[] = {
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A__7S7601C9__A1__7S7601C4[] = {
  ABISELECT(40,28),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C11D1Ev();
extern void _ZN8S7601C11D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C11__A1__7S7601C4[] = {
  ABISELECT(40,24),
  ABISELECT(88,48),
  ABISELECT(88,48),
  ABISELECT(88,48),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D0Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C11__A1__7S7601C4[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C11__A1__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev)();
extern void ABISELECT(_ZThn40_N8S7601C11D1Ev,_ZThn24_N8S7601C11D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev)();
extern void ABISELECT(_ZThn40_N8S7601C11D0Ev,_ZThn24_N8S7601C11D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C11__A1__7S7601C4[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-40,-24),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C11__A1__7S7601C4[] = {
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__7S7601C4[] = {
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C6__7S7601C4[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C6__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C6__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C6__7S7601C4[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C4[] = {
  0,
  0,
  ABISELECT(-72,-36),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C7__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(72,36),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A1__7S7601C4[] = {
  ABISELECT(-72,-36),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__A1__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(72,36),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C10D1Ev();
extern void _ZN8S7601C10D0Ev();
extern void _ZN8S7601C103v24Ev();
extern void _ZN8S7601C103v25Ev();
extern void _ZN8S7601C103v26Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C10__7S7601C4[] = {
  ABISELECT(-208,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-232,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v24Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v25Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v26Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C11D1Ev();
extern void _ZN8S7601C11D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C118S7601C10__7S7601C4[] = {
  ABISELECT(-208,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-232,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D0Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C118S7601C10__7S7601C4[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(160,112),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C118S7601C10__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(232,148),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev)();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C118S7601C10__7S7601C4[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(208,136),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(208,136),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C118S7601C10__7S7601C4[] = {
  ABISELECT(200,132),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C10__7S7601C4[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-72,-36),
  ABISELECT(160,112),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C10__7S7601C4[] = {
  0,
  0,
  0,
  0,
  ABISELECT(232,148),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C10D1Ev,_ZTv0_n28_N8S7601C10D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S7601C10D0Ev,_ZTv0_n28_N8S7601C10D0Ev)();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C10__7S7601C4[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(208,136),
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(-24,-12),
  ABISELECT(208,136),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C10D1Ev,_ZTv0_n28_N8S7601C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C10D0Ev,_ZTv0_n28_N8S7601C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C10__7S7601C4[] = {
  ABISELECT(200,132),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
static  VTT_ENTRY vtt_S7601C4[] = {
  {&(_ZTV7S7601C4[7]),  7,139},
  {&(_tg__ZTV7S7601C5__7S7601C4[7]),  7,19},
  {&(_tg__ZTV7S7601C97S7601C5__7S7601C4[6]),  6,16},
  {&(_tg__ZTV7S7601C27S7601C97S7601C5__A2__7S7601C4[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C97S7601C5__A2__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C97S7601C5__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C97S7601C5__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C3__7S7601C97S7601C5__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C6__7S7601C97S7601C5__7S7601C4[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__7S7601C97S7601C5__7S7601C4[2]),  2,6},
  {&(_tg__ZTV7S7601C2__A__7S7601C97S7601C5__7S7601C4[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C5__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C6__7S7601C5__7S7601C4[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__7S7601C5__7S7601C4[2]),  2,6},
  {&(_tg__ZTV7S7601C7__7S7601C5__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C5__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C27S7601C9__A2__7S7601C5__7S7601C4[3]),  3,4},
  {&(_tg__ZTV8S7601C10__7S7601C5__7S7601C4[17]),  17,29},
  {&(_tg__ZTV7S7601C9__A1__7S7601C4[6]),  6,16},
  {&(_tg__ZTV7S7601C27S7601C9__A3__7S7601C4[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C9__A3__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C9__A1__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C9__A1__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C3__7S7601C9__A1__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C6__7S7601C9__A1__7S7601C4[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__7S7601C9__A1__7S7601C4[2]),  2,6},
  {&(_tg__ZTV7S7601C2__A__7S7601C9__A1__7S7601C4[3]),  3,4},
  {&(_tg__ZTV8S7601C11__A1__7S7601C4[7]),  7,16},
  {&(_tg__ZTV7S7601C7__8S7601C11__A1__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C7__8S7601C11__A1__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C3__8S7601C11__A1__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C11__A1__7S7601C4[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__8S7601C11__A1__7S7601C4[2]),  2,6},
  {&(_ZTV7S7601C4[70]),  70,139},
  {&(_ZTV7S7601C4[86]),  86,139},
  {&(_ZTV7S7601C4[92]),  92,139},
  {&(_ZTV7S7601C4[105]),  105,139},
  {&(_ZTV7S7601C4[105]),  105,139},
  {&(_ZTV7S7601C4[27]),  27,139},
  {&(_ZTV7S7601C4[127]),  127,139},
  {&(_ZTV7S7601C4[34]),  34,139},
  {&(_ZTV7S7601C4[47]),  47,139},
  {&(_ZTV7S7601C4[55]),  55,139},
  {&(_tg__ZTV7S7601C6__7S7601C4[5]),  5,9},
  {&(_tg__ZTV7S7601C27S7601C6__7S7601C4[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C6__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C3__7S7601C6__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C6__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C6__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C4[5]),  5,10},
  {&(_tg__ZTV7S7601C7__7S7601C4[5]),  5,10},
  {&(_tg__ZTV7S7601C3__7S7601C7__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C2__A1__7S7601C4[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__A1__7S7601C4[6]),  6,10},
  {&(_tg__ZTV8S7601C10__7S7601C4[7]),  7,19},
  {&(_tg__ZTV8S7601C118S7601C10__7S7601C4[7]),  7,16},
  {&(_tg__ZTV7S7601C7__8S7601C118S7601C10__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C7__8S7601C118S7601C10__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C3__8S7601C118S7601C10__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C118S7601C10__7S7601C4[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__8S7601C118S7601C10__7S7601C4[2]),  2,6},
  {&(_tg__ZTV7S7601C7__8S7601C10__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C7__8S7601C10__7S7601C4[9]),  9,14},
  {&(_tg__ZTV7S7601C3__8S7601C10__7S7601C4[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C10__7S7601C4[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__8S7601C10__7S7601C4[2]),  2,6},
};
extern VTBL_ENTRY _ZTI7S7601C4[];
extern  VTBL_ENTRY _ZTV7S7601C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C4[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S7601C11D0Ev,_ZThn24_N8S7601C11D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S7601C11D1Ev,_ZThn24_N8S7601C11D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n112_N7S7601C5D0Ev,_ZTv0_n56_N7S7601C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N7S7601C5D0Ev,_ZThn224_N7S7601C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n112_N7S7601C5D1Ev,_ZTv0_n56_N7S7601C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N7S7601C5D1Ev,_ZThn224_N7S7601C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C5D0Ev,_ZTv0_n28_N7S7601C5D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N7S7601C5D0Ev,_ZThn88_N7S7601C5D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C5D1Ev,_ZTv0_n28_N7S7601C5D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N7S7601C5D1Ev,_ZThn88_N7S7601C5D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N7S7601C9D0Ev,_ZThn52_N7S7601C9D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn144_N7S7601C9D0Ev,_ZThn88_N7S7601C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N7S7601C9D1Ev,_ZThn52_N7S7601C9D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn144_N7S7601C9D1Ev,_ZThn88_N7S7601C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n112_N7S7601C4D0Ev,_ZTv0_n56_N7S7601C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N7S7601C4D0Ev,_ZThn224_N7S7601C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n112_N7S7601C4D1Ev,_ZTv0_n56_N7S7601C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn352_N7S7601C4D1Ev,_ZThn224_N7S7601C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C4D0Ev,_ZTv0_n28_N7S7601C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N7S7601C4D0Ev,_ZThn88_N7S7601C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S7601C4D1Ev,_ZTv0_n28_N7S7601C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn144_N7S7601C4D1Ev,_ZThn88_N7S7601C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7601C4 = {  "S7601C4", // class name
  bases_S7601C4, 16,
  &(vtc_S7601C4[0]), // expected_vtbl_contents
  &(vtt_S7601C4[0]), // expected_vtt_contents
  ABISELECT(368,236), // object size
  NSPAIRA(_ZTI7S7601C4),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S7601C4),139, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S7601C4),66, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C14_nt  {
  virtual void  v34(); // _ZN11S7601C14_nt3v34Ev
  virtual void  v35(); // _ZN11S7601C14_nt3v35Ev
  virtual void  v36(); // _ZN11S7601C14_nt3v36Ev
  virtual void  v37(); // _ZN11S7601C14_nt3v37Ev
  ~S7601C14_nt(); // tgen
  S7601C14_nt(); // tgen
};
//SIG(-1 S7601C14_nt) C1{ v1 v2 v3 v4}


void  S7601C14_nt ::v34(){vfunc_called(this, "_ZN11S7601C14_nt3v34Ev");}
void  S7601C14_nt ::v35(){vfunc_called(this, "_ZN11S7601C14_nt3v35Ev");}
void  S7601C14_nt ::v36(){vfunc_called(this, "_ZN11S7601C14_nt3v36Ev");}
void  S7601C14_nt ::v37(){vfunc_called(this, "_ZN11S7601C14_nt3v37Ev");}
S7601C14_nt ::~S7601C14_nt(){ note_dtor("S7601C14_nt", this);} // tgen
S7601C14_nt ::S7601C14_nt(){ note_ctor("S7601C14_nt", this);} // tgen

//skip512 S7601C14_nt

#else // __cplusplus

extern void _ZN11S7601C14_ntC1Ev();
extern void _ZN11S7601C14_ntD1Ev();
Name_Map name_map_S7601C14_nt[] = {
  NSPAIR(_ZN11S7601C14_ntC1Ev),
  NSPAIR(_ZN11S7601C14_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S7601C14_nt[];
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
static  VTBL_ENTRY vtc_S7601C14_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S7601C14_nt[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
};
extern VTBL_ENTRY _ZTI11S7601C14_nt[];
VTBL_ENTRY *P__ZTI11S7601C14_nt = _ZTI11S7601C14_nt; 
extern  VTBL_ENTRY _ZTV11S7601C14_nt[];
Class_Descriptor cd_S7601C14_nt = {  "S7601C14_nt", // class name
  0,0,//no base classes
  &(vtc_S7601C14_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S7601C14_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S7601C14_nt),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C13  : virtual S7601C14_nt {
  short s7601c13f0;
  ~S7601C13(); // tgen
  S7601C13(); // tgen
};
//SIG(-1 S7601C13) C1{ VBC2{ v1 v2 v3 v4} Fs}


S7601C13 ::~S7601C13(){ note_dtor("S7601C13", this);} // tgen
S7601C13 ::S7601C13(){ note_ctor("S7601C13", this);} // tgen

static void Test_S7601C13()
{
  extern Class_Descriptor cd_S7601C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S7601C13, buf);
    S7601C13 *dp, &lv = *(dp=new (buf) S7601C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S7601C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S7601C13)");
    check_base_class_offset(lv, (S7601C14_nt*), 0, "S7601C13");
    check_field_offset(lv, s7601c13f0, ABISELECT(8,4), "S7601C13.s7601c13f0");
    test_class_info(&lv, &cd_S7601C13);
    dp->~S7601C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C13(Test_S7601C13, "S7601C13", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S7601C13C1Ev();
extern void _ZN8S7601C13D1Ev();
Name_Map name_map_S7601C13[] = {
  NSPAIR(_ZN8S7601C13C1Ev),
  NSPAIR(_ZN8S7601C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C14_nt;
extern VTBL_ENTRY _ZTI11S7601C14_nt[];
extern  VTBL_ENTRY _ZTV11S7601C14_nt[];
static Base_Class bases_S7601C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C14_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7601C13[];
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
static  VTBL_ENTRY vtc_S7601C13[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C13[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
};
extern VTBL_ENTRY _ZTV8S7601C13[];
static  VTT_ENTRY vtt_S7601C13[] = {
  {&(_ZTV8S7601C13[7]),  7,11},
  {&(_ZTV8S7601C13[7]),  7,11},
};
extern VTBL_ENTRY _ZTI8S7601C13[];
extern  VTBL_ENTRY _ZTV8S7601C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C13[];
Class_Descriptor cd_S7601C13 = {  "S7601C13", // class name
  bases_S7601C13, 1,
  &(vtc_S7601C13[0]), // expected_vtbl_contents
  &(vtt_S7601C13[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S7601C13),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S7601C13),11, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7601C13),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C16  : virtual S7601C2 , S7601C6 , S7601C7 {
  virtual  ~S7601C16(); // _ZN8S7601C16D2Ev
  virtual void  v38(); // _ZN8S7601C163v38Ev
  S7601C16(); // tgen
};
//SIG(-1 S7601C16) C1{ VBC2{ VBC3{ v2 v3 v4 v5 Fp Fi} v6} BC4{ BC2 BC3 VBC5{ VBC2 v7 v8 v9 v10 FD[9]} vd v11 FU6{ m FL}} BC5 vd v1}


 S7601C16 ::~S7601C16(){ note_dtor("S7601C16", this);}
void  S7601C16 ::v38(){vfunc_called(this, "_ZN8S7601C163v38Ev");}
S7601C16 ::S7601C16(){ note_ctor("S7601C16", this);} // tgen

static void Test_S7601C16()
{
  extern Class_Descriptor cd_S7601C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(26,66)];
    init_test(&cd_S7601C16, buf);
    S7601C16 *dp, &lv = *(dp=new (buf) S7601C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(400,260), "sizeof(S7601C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7601C16)");
    /*is_ambiguous_... S7601C16::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(208,136), "S7601C16");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C6*), ABISELECT(208,136), "S7601C16");
    /*is_ambiguous_... S7601C16::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*), ABISELECT(240,148), "S7601C16");
    /*is_ambiguous_... S7601C16::S7601C7 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C7*), ABISELECT(240,148), "S7601C16");
    /*is_ambiguous_... S7601C16::S7601C7 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C7*), ABISELECT(240,148), "S7601C16");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C6*), 0, "S7601C16");
    /*is_ambiguous_... S7601C6::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C6*), ABISELECT(8,4), "S7601C16");
    check_base_class_offset(lv, (S7601C7*)(S7601C6*), ABISELECT(240,148), "S7601C16");
    check_base_class_offset(lv, (S7601C6*), 0, "S7601C16");
    /*is_ambiguous_... S7601C16::S7601C7 */ AMB_check_base_class_offset(lv, (S7601C7*), ABISELECT(48,24), "S7601C16");
    test_class_info(&lv, &cd_S7601C16);
    dp->~S7601C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C16(Test_S7601C16, "S7601C16", ABISELECT(400,260));

#else // __cplusplus

extern void _ZN8S7601C16C1Ev();
extern void _ZN8S7601C16D2Ev();
Name_Map name_map_S7601C16[] = {
  NSPAIR(_ZN8S7601C16C1Ev),
  NSPAIR(_ZN8S7601C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
extern Class_Descriptor cd_S7601C6;
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
static Base_Class bases_S7601C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(208,136), //bcp->offset
    26, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7601C2,    ABISELECT(240,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7601C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C3,    ABISELECT(8,4), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C7,    ABISELECT(240,148), //bcp->offset
    36, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7601C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7601C7,    ABISELECT(48,24), //bcp->offset
    16, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7601C16[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C16D1Ev();
extern void _ZN8S7601C16D0Ev();
extern void _ZN7S7601C63v13Ev();
extern void _ZN8S7601C163v38Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY vtc_S7601C16[] = {
  ABISELECT(240,148),
  ABISELECT(240,148),
  ABISELECT(208,136),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C16D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C16D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  (VTBL_ENTRY)&_ZN8S7601C163v38Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  ABISELECT(192,124),
  ABISELECT(192,124),
  ABISELECT(160,112),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-208,-136),
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  ABISELECT(-240,-148),
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern VTBL_ENTRY _ZTV8S7601C16[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C16[] = {
  ABISELECT(240,148),
  ABISELECT(240,148),
  ABISELECT(208,136),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C6__A1__8S7601C16[] = {
  ABISELECT(208,136),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C6__A1__8S7601C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-208,-136),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C6__8S7601C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-208,-136),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C6__8S7601C16[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  ABISELECT(-240,-148),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__A__8S7601C16[] = {
  ABISELECT(192,124),
  ABISELECT(192,124),
  ABISELECT(160,112),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__7S7601C7__A__8S7601C16[] = {
  0,
  ABISELECT(-32,-12),
  ABISELECT(-192,-124),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C7__A__8S7601C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-160,-112),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__8S7601C16[] = {
  ABISELECT(-32,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__8S7601C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C16[] = {
  0,
  0,
  ABISELECT(-32,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C7__8S7601C16[] = {
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
static  VTT_ENTRY vtt_S7601C16[] = {
  {&(_ZTV8S7601C16[5]),  5,50},
  {&(_tg__ZTV7S7601C6__8S7601C16[5]),  5,9},
  {&(_tg__ZTV7S7601C27S7601C6__A1__8S7601C16[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C6__A1__8S7601C16[6]),  6,10},
  {&(_tg__ZTV7S7601C3__7S7601C6__8S7601C16[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C6__8S7601C16[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C6__8S7601C16[9]),  9,14},
  {&(_tg__ZTV7S7601C7__A__8S7601C16[5]),  5,10},
  {&(_tg__ZTV7S7601C2__7S7601C7__A__8S7601C16[4]),  4,5},
  {&(_tg__ZTV7S7601C3__7S7601C7__A__8S7601C16[6]),  6,10},
  {&(_ZTV8S7601C16[45]),  45,50},
  {&(_ZTV8S7601C16[32]),  32,50},
  {&(_ZTV8S7601C16[45]),  45,50},
  {&(_ZTV8S7601C16[21]),  21,50},
  {&(_tg__ZTV7S7601C2__8S7601C16[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__8S7601C16[6]),  6,10},
  {&(_tg__ZTV7S7601C7__8S7601C16[5]),  5,10},
  {&(_tg__ZTV7S7601C7__8S7601C16[5]),  5,10},
  {&(_tg__ZTV7S7601C3__7S7601C7__8S7601C16[6]),  6,10},
};
extern VTBL_ENTRY _ZTI8S7601C16[];
extern  VTBL_ENTRY _ZTV8S7601C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C16[];
Class_Descriptor cd_S7601C16 = {  "S7601C16", // class name
  bases_S7601C16, 7,
  &(vtc_S7601C16[0]), // expected_vtbl_contents
  &(vtt_S7601C16[0]), // expected_vtt_contents
  ABISELECT(400,260), // object size
  NSPAIRA(_ZTI8S7601C16),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S7601C16),50, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7601C16),19, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C15  : virtual S7601C6 , virtual S7601C13 , S7601C16 , virtual S7601C11 {
  ::S7601C8_nt s7601c15f0;
  __tsi64  :0;
  virtual void  v39(); // _ZN8S7601C153v39Ev
  virtual void  v40(); // _ZN8S7601C153v40Ev
  ~S7601C15(); // tgen
  S7601C15(); // tgen
};
//SIG(-1 S7601C15) C1{ VBC2{ BC3{ VBC4{ v3 v4 v5 v6 Fp Fi} v7} BC4 VBC5{ VBC3 v8 v9 v10 v11 FD[9]} vd v12 FU6{ m FL}} VBC7{ VBC8{ v13 v14 v15 v16} Fs} BC9{ VBC3 BC2 BC5 vd v17} VBC10{ VBC5 VBC2 v18 v19 v20 v21 v22 v23 FU6} v1 v2 FU6 FL:0}


void  S7601C15 ::v39(){vfunc_called(this, "_ZN8S7601C153v39Ev");}
void  S7601C15 ::v40(){vfunc_called(this, "_ZN8S7601C153v40Ev");}
S7601C15 ::~S7601C15(){ note_dtor("S7601C15", this);} // tgen
S7601C15 ::S7601C15(){ note_ctor("S7601C15", this);} // tgen

static void Test_S7601C15()
{
  extern Class_Descriptor cd_S7601C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(31,79)];
    init_test(&cd_S7601C15, buf);
    S7601C15 *dp, &lv = *(dp=new (buf) S7601C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(480,312), "sizeof(S7601C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7601C15)");
    /*is_ambiguous_... S7601C15::S7601C6 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C6*), ABISELECT(256,168), "S7601C15");
    /*is_ambiguous_... S7601C15::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(256,168), "S7601C15");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C6*)(S7601C16*), ABISELECT(256,168), "S7601C15");
    /*is_ambiguous_... S7601C15::S7601C6 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C6*), ABISELECT(216,144), "S7601C15");
    /*is_ambiguous_... S7601C15::S7601C6 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C6*), ABISELECT(224,148), "S7601C15");
    /*is_ambiguous_... S7601C15::S7601C7 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C7*), ABISELECT(288,180), "S7601C15");
    /*is_ambiguous_... S7601C16::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C16*), ABISELECT(288,180), "S7601C15");
    /*is_ambiguous_... S7601C16::S7601C7 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C7*)(S7601C16*), ABISELECT(288,180), "S7601C15");
    /*is_ambiguous_... S7601C15::S7601C6 */ AMB_check_base_class_offset(lv, (S7601C7*)(S7601C6*), ABISELECT(288,180), "S7601C15");
    check_base_class_offset(lv, (S7601C7*)(S7601C6*)(S7601C16*), ABISELECT(288,180), "S7601C15");
    check_base_class_offset(lv, (S7601C7*)(S7601C11*), ABISELECT(288,180), "S7601C15");
    /*is_ambiguous_... S7601C15::S7601C6 */ AMB_check_base_class_offset(lv, (S7601C6*), ABISELECT(216,144), "S7601C15");
    check_base_class_offset(lv, (S7601C6*)(S7601C11*), ABISELECT(216,144), "S7601C15");
    check_base_class_offset(lv, (S7601C14_nt*)(S7601C13*), ABISELECT(448,292), "S7601C15");
    check_base_class_offset(lv, (S7601C13*), ABISELECT(448,292), "S7601C15");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C6*)(S7601C16*), 0, "S7601C15");
    /*is_ambiguous_... S7601C6::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C6*)(S7601C16*), ABISELECT(8,4), "S7601C15");
    check_base_class_offset(lv, (S7601C6*)(S7601C16*), 0, "S7601C15");
    /*is_ambiguous_... S7601C16::S7601C7 */ AMB_check_base_class_offset(lv, (S7601C7*)(S7601C16*), ABISELECT(48,24), "S7601C15");
    check_base_class_offset(lv, (S7601C16*), 0, "S7601C15");
    check_base_class_offset(lv, (S7601C11*), ABISELECT(464,300), "S7601C15");
    check_field_offset(lv, s7601c15f0, ABISELECT(208,136), "S7601C15.s7601c15f0");
    test_class_info(&lv, &cd_S7601C15);
    dp->~S7601C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C15(Test_S7601C15, "S7601C15", ABISELECT(480,312));

#else // __cplusplus

extern void _ZN8S7601C15C1Ev();
extern void _ZN8S7601C15D1Ev();
Name_Map name_map_S7601C15[] = {
  NSPAIR(_ZN8S7601C15C1Ev),
  NSPAIR(_ZN8S7601C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
extern Class_Descriptor cd_S7601C6;
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
extern Class_Descriptor cd_S7601C14_nt;
extern VTBL_ENTRY _ZTI11S7601C14_nt[];
extern  VTBL_ENTRY _ZTV11S7601C14_nt[];
extern Class_Descriptor cd_S7601C13;
extern VTBL_ENTRY _ZTI8S7601C13[];
extern  VTBL_ENTRY _ZTV8S7601C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C13[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C6;
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
extern Class_Descriptor cd_S7601C16;
extern VTBL_ENTRY _ZTI8S7601C16[];
extern  VTBL_ENTRY _ZTV8S7601C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C16[];
extern Class_Descriptor cd_S7601C11;
extern VTBL_ENTRY _ZTI8S7601C11[];
extern  VTBL_ENTRY _ZTV8S7601C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C11[];
static Base_Class bases_S7601C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(256,168), //bcp->offset
    54, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7601C2,    ABISELECT(216,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C3,    ABISELECT(224,148), //bcp->offset
    48, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C2,    ABISELECT(288,180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7601C7,    ABISELECT(288,180), //bcp->offset
    64, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7601C6,    ABISELECT(216,144), //bcp->offset
    32, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7601C14_nt,    ABISELECT(448,292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S7601C13,    ABISELECT(448,292), //bcp->offset
    78, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7601C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7601C3,    ABISELECT(8,4), //bcp->offset
    16, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7601C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7601C7,    ABISELECT(48,24), //bcp->offset
    22, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S7601C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7601C11,    ABISELECT(464,300), //bcp->offset
    89, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S7601C15[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C15D1Ev();
extern void _ZN8S7601C15D0Ev();
extern void _ZN7S7601C63v13Ev();
extern void _ZN8S7601C163v38Ev();
extern void _ZN8S7601C153v39Ev();
extern void _ZN8S7601C153v40Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C15D1Ev,_ZTv0_n28_N8S7601C15D1Ev)();
extern void ABISELECT(_ZThn216_N8S7601C15D1Ev,_ZThn144_N8S7601C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7601C15D0Ev,_ZTv0_n28_N8S7601C15D0Ev)();
extern void ABISELECT(_ZThn216_N8S7601C15D0Ev,_ZThn144_N8S7601C15D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void ABISELECT(_ZTv0_n112_N8S7601C15D1Ev,_ZTv0_n56_N8S7601C15D1Ev)();
extern void ABISELECT(_ZThn464_N8S7601C15D1Ev,_ZThn300_N8S7601C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n112_N8S7601C15D0Ev,_ZTv0_n56_N8S7601C15D0Ev)();
extern void ABISELECT(_ZThn464_N8S7601C15D0Ev,_ZThn300_N8S7601C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S7601C15[] = {
  ABISELECT(464,300),
  ABISELECT(448,292),
  ABISELECT(448,292),
  ABISELECT(216,144),
  ABISELECT(288,180),
  ABISELECT(288,180),
  ABISELECT(256,168),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C15D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  (VTBL_ENTRY)&_ZN8S7601C163v38Ev,
  (VTBL_ENTRY)&_ZN8S7601C153v39Ev,
  (VTBL_ENTRY)&_ZN8S7601C153v40Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  ABISELECT(240,156),
  ABISELECT(240,156),
  ABISELECT(208,144),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-216,-144),
  0,
  ABISELECT(72,36),
  ABISELECT(72,36),
  ABISELECT(40,24),
  ABISELECT(-216,-144),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C15D1Ev,_ZTv0_n28_N8S7601C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C15D0Ev,_ZTv0_n28_N8S7601C15D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  ABISELECT(-224,-148),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-256,-168),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  ABISELECT(-288,-180),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-448,-292),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
  ABISELECT(-464,-300),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-248,-156),
  ABISELECT(-176,-120),
  ABISELECT(-176,-120),
  ABISELECT(-176,-120),
  ABISELECT(-208,-132),
  ABISELECT(-464,-300),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N8S7601C15D1Ev,_ZTv0_n56_N8S7601C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N8S7601C15D0Ev,_ZTv0_n56_N8S7601C15D0Ev),
};
extern VTBL_ENTRY _ZTV8S7601C15[];
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C16D1Ev();
extern void _ZN8S7601C16D0Ev();
extern void _ZN7S7601C63v13Ev();
extern void _ZN8S7601C163v38Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C16__8S7601C15[] = {
  ABISELECT(288,180),
  ABISELECT(288,180),
  ABISELECT(256,168),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C16D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C16D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  (VTBL_ENTRY)&_ZN8S7601C163v38Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C68S7601C16__A1__8S7601C15[] = {
  ABISELECT(288,180),
  ABISELECT(288,180),
  ABISELECT(256,168),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C68S7601C16__A2__8S7601C15[] = {
  ABISELECT(256,168),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C68S7601C16__A2__8S7601C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-256,-168),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C68S7601C16__A1__8S7601C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-256,-168),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C68S7601C16__A1__8S7601C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  ABISELECT(-288,-180),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C78S7601C16__A1__8S7601C15[] = {
  ABISELECT(240,156),
  ABISELECT(240,156),
  ABISELECT(208,144),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__7S7601C78S7601C16__A1__8S7601C15[] = {
  0,
  ABISELECT(-32,-12),
  ABISELECT(-240,-156),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C78S7601C16__A1__8S7601C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-208,-144),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C16__8S7601C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  ABISELECT(-288,-180),
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C16__8S7601C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-256,-168),
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__A__8S7601C16__8S7601C15[] = {
  ABISELECT(240,156),
  ABISELECT(240,156),
  ABISELECT(208,144),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C15[] = {
  ABISELECT(72,36),
  ABISELECT(72,36),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C6__8S7601C15[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C6__8S7601C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C6__8S7601C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C6__8S7601C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  ABISELECT(-72,-36),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C15[] = {
  0,
  0,
  ABISELECT(-32,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C7__8S7601C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A1__8S7601C15[] = {
  ABISELECT(-32,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__A1__8S7601C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(32,12),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C13__8S7601C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C13[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C11D1Ev();
extern void _ZN8S7601C11D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C11__8S7601C15[] = {
  ABISELECT(-248,-156),
  ABISELECT(-176,-120),
  ABISELECT(-176,-120),
  ABISELECT(-176,-120),
  ABISELECT(-208,-132),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D0Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C11__8S7601C15[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-12),
  ABISELECT(176,120),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C11__8S7601C15[] = {
  0,
  0,
  0,
  0,
  ABISELECT(208,132),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev)();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C11__8S7601C15[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(248,156),
  0,
  ABISELECT(72,36),
  ABISELECT(72,36),
  ABISELECT(40,24),
  ABISELECT(248,156),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C11__8S7601C15[] = {
  ABISELECT(240,152),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
static  VTT_ENTRY vtt_S7601C15[] = {
  {&(_ZTV8S7601C15[9]),  9,112},
  {&(_tg__ZTV8S7601C16__8S7601C15[5]),  5,10},
  {&(_tg__ZTV7S7601C68S7601C16__A1__8S7601C15[5]),  5,9},
  {&(_tg__ZTV7S7601C27S7601C68S7601C16__A2__8S7601C15[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C68S7601C16__A2__8S7601C15[6]),  6,10},
  {&(_tg__ZTV7S7601C3__7S7601C68S7601C16__A1__8S7601C15[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C68S7601C16__A1__8S7601C15[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C68S7601C16__A1__8S7601C15[9]),  9,14},
  {&(_tg__ZTV7S7601C78S7601C16__A1__8S7601C15[5]),  5,10},
  {&(_tg__ZTV7S7601C2__7S7601C78S7601C16__A1__8S7601C15[4]),  4,5},
  {&(_tg__ZTV7S7601C3__7S7601C78S7601C16__A1__8S7601C15[6]),  6,10},
  {&(_tg__ZTV7S7601C7__8S7601C16__8S7601C15[9]),  9,14},
  {&(_tg__ZTV7S7601C3__8S7601C16__8S7601C15[6]),  6,10},
  {&(_tg__ZTV7S7601C7__8S7601C16__8S7601C15[9]),  9,14},
  {&(_tg__ZTV7S7601C7__A__8S7601C16__8S7601C15[5]),  5,10},
  {&(_ZTV8S7601C15[44]),  44,112},
  {&(_ZTV8S7601C15[60]),  60,112},
  {&(_ZTV8S7601C15[50]),  50,112},
  {&(_ZTV8S7601C15[73]),  73,112},
  {&(_ZTV8S7601C15[73]),  73,112},
  {&(_ZTV8S7601C15[85]),  85,112},
  {&(_ZTV8S7601C15[85]),  85,112},
  {&(_ZTV8S7601C15[27]),  27,112},
  {&(_ZTV8S7601C15[103]),  103,112},
  {&(_tg__ZTV7S7601C6__8S7601C15[5]),  5,9},
  {&(_tg__ZTV7S7601C27S7601C6__8S7601C15[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C6__8S7601C15[6]),  6,10},
  {&(_tg__ZTV7S7601C3__7S7601C6__8S7601C15[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C6__8S7601C15[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C6__8S7601C15[9]),  9,14},
  {&(_tg__ZTV7S7601C7__8S7601C15[5]),  5,10},
  {&(_tg__ZTV7S7601C7__8S7601C15[5]),  5,10},
  {&(_tg__ZTV7S7601C3__7S7601C7__8S7601C15[6]),  6,10},
  {&(_tg__ZTV7S7601C2__A1__8S7601C15[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__A1__8S7601C15[6]),  6,10},
  {&(_tg__ZTV8S7601C13__8S7601C15[7]),  7,11},
  {&(_tg__ZTV8S7601C13__8S7601C15[7]),  7,11},
  {&(_tg__ZTV8S7601C11__8S7601C15[7]),  7,16},
  {&(_tg__ZTV7S7601C7__8S7601C11__8S7601C15[9]),  9,14},
  {&(_tg__ZTV7S7601C7__8S7601C11__8S7601C15[9]),  9,14},
  {&(_tg__ZTV7S7601C3__8S7601C11__8S7601C15[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C11__8S7601C15[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__8S7601C11__8S7601C15[2]),  2,6},
};
extern VTBL_ENTRY _ZTI8S7601C15[];
extern  VTBL_ENTRY _ZTV8S7601C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C15[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n112_N8S7601C15D0Ev,_ZTv0_n56_N8S7601C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S7601C15D0Ev,_ZThn300_N8S7601C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n112_N8S7601C15D1Ev,_ZTv0_n56_N8S7601C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn464_N8S7601C15D1Ev,_ZThn300_N8S7601C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7601C15D0Ev,_ZTv0_n28_N8S7601C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N8S7601C15D0Ev,_ZThn144_N8S7601C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S7601C15D1Ev,_ZTv0_n28_N8S7601C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N8S7601C15D1Ev,_ZThn144_N8S7601C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S7601C15 = {  "S7601C15", // class name
  bases_S7601C15, 14,
  &(vtc_S7601C15[0]), // expected_vtbl_contents
  &(vtt_S7601C15[0]), // expected_vtt_contents
  ABISELECT(480,312), // object size
  NSPAIRA(_ZTI8S7601C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S7601C15),112, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S7601C15),43, //virtual table table var
  14, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S7601C12  : S7601C5 , S7601C13 , virtual S7601C11 , virtual S7601C15 , S7601C2 {
  virtual void  v41(); // _ZN8S7601C123v41Ev
  virtual void  v42(); // _ZN8S7601C123v42Ev
  virtual void  v43(); // _ZN8S7601C123v43Ev
  virtual void  v44(); // _ZN8S7601C123v44Ev
  virtual void  v45(); // _ZN8S7601C123v45Ev
  virtual void  v46(); // _ZN8S7601C123v46Ev
  ~S7601C12(); // tgen
  S7601C12(); // tgen
};
//SIG(-1 S7601C12) C1{ BC2{ VBC3{ v7 v8 v9 v10 Fp Fi} VBC4{ BC5{ VBC3 v11} BC3 VBC6{ VBC5 v12 v13 v14 v15 FD[9]} vd v16 FU7{ m FL}} BC8{ VBC6 VBC4 BC3 BC5 v17 v18 v19 v20 Fi[3]} VBC9{ BC10{ VBC6 VBC4 v21 v22 v23 v24 v25 v26 FU7} vd v27 v28 v29} v30 v31 Fi Fi} BC11{ VBC12{ v32 v33 v34 v35} Fs} VBC10 VBC13{ VBC4 VBC11 BC14{ VBC5 BC4 BC6 vd v36} VBC10 v37 v38 FU7 FL:0} BC5 v1 v2 v3 v4 v5 v6}


void  S7601C12 ::v41(){vfunc_called(this, "_ZN8S7601C123v41Ev");}
void  S7601C12 ::v42(){vfunc_called(this, "_ZN8S7601C123v42Ev");}
void  S7601C12 ::v43(){vfunc_called(this, "_ZN8S7601C123v43Ev");}
void  S7601C12 ::v44(){vfunc_called(this, "_ZN8S7601C123v44Ev");}
void  S7601C12 ::v45(){vfunc_called(this, "_ZN8S7601C123v45Ev");}
void  S7601C12 ::v46(){vfunc_called(this, "_ZN8S7601C123v46Ev");}
S7601C12 ::~S7601C12(){ note_dtor("S7601C12", this);} // tgen
S7601C12 ::S7601C12(){ note_ctor("S7601C12", this);} // tgen

static void Test_S7601C12()
{
  extern Class_Descriptor cd_S7601C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(37,94)];
    init_test(&cd_S7601C12, buf);
    S7601C12 *dp, &lv = *(dp=new (buf) S7601C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(576,372), "sizeof(S7601C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S7601C12)");
    /*is_ambiguous_... S7601C5::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C5*), ABISELECT(80,48), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C6 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C6*), ABISELECT(80,48), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(80,48), "S7601C12");
    /*is_ambiguous_... S7601C9::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C9*)(S7601C5*), ABISELECT(80,48), "S7601C12");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*)(S7601C6*)(S7601C16*)(S7601C15*), ABISELECT(80,48), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C2*), ABISELECT(80,48), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C6 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C6*), ABISELECT(104,60), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C6 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C6*), ABISELECT(112,64), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C7 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C7*), ABISELECT(144,84), "S7601C12");
    /*is_ambiguous_... S7601C16::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C16*)(S7601C15*), ABISELECT(144,84), "S7601C12");
    /*is_ambiguous_... S7601C16::S7601C7 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C7*)(S7601C16*)(S7601C15*), ABISELECT(144,84), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C6 */ AMB_check_base_class_offset(lv, (S7601C7*)(S7601C6*), ABISELECT(144,84), "S7601C12");
    check_base_class_offset(lv, (S7601C7*)(S7601C9*)(S7601C5*), ABISELECT(144,84), "S7601C12");
    check_base_class_offset(lv, (S7601C7*)(S7601C11*)(S7601C10*), ABISELECT(144,84), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C11 */ AMB_check_base_class_offset(lv, (S7601C7*)(S7601C11*), ABISELECT(144,84), "S7601C12");
    check_base_class_offset(lv, (S7601C7*)(S7601C6*)(S7601C16*)(S7601C15*), ABISELECT(144,84), "S7601C12");
    check_base_class_offset(lv, (S7601C6*)(S7601C5*), ABISELECT(104,60), "S7601C12");
    check_base_class_offset(lv, (S7601C6*)(S7601C9*)(S7601C5*), ABISELECT(104,60), "S7601C12");
    check_base_class_offset(lv, (S7601C6*)(S7601C11*)(S7601C10*), ABISELECT(104,60), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C11 */ AMB_check_base_class_offset(lv, (S7601C6*)(S7601C11*), ABISELECT(104,60), "S7601C12");
    /*is_ambiguous_... S7601C15::S7601C6 */ AMB_check_base_class_offset(lv, (S7601C6*)(S7601C15*), ABISELECT(104,60), "S7601C12");
    /*is_ambiguous_... S7601C9::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C9*)(S7601C5*), 0, "S7601C12");
    /*is_ambiguous_... S7601C9::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C9*)(S7601C5*), ABISELECT(24,12), "S7601C12");
    check_base_class_offset(lv, (S7601C9*)(S7601C5*), 0, "S7601C12");
    check_base_class_offset(lv, (S7601C11*)(S7601C10*), ABISELECT(304,196), "S7601C12");
    check_base_class_offset(lv, (S7601C10*)(S7601C5*), ABISELECT(304,196), "S7601C12");
    check_base_class_offset(lv, (S7601C5*), 0, "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C13 */ AMB_check_base_class_offset(lv, (S7601C14_nt*)(S7601C13*), ABISELECT(56,36), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C13 */ AMB_check_base_class_offset(lv, (S7601C14_nt*)(S7601C13*), ABISELECT(56,36), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C13 */ AMB_check_base_class_offset(lv, (S7601C13*), ABISELECT(56,36), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C11 */ AMB_check_base_class_offset(lv, (S7601C11*), ABISELECT(320,208), "S7601C12");
    check_base_class_offset(lv, (S7601C11*)(S7601C15*), ABISELECT(320,208), "S7601C12");
    check_base_class_offset(lv, (S7601C13*)(S7601C15*), ABISELECT(552,364), "S7601C12");
    /*is_ambiguous_... S7601C6::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*)(S7601C6*)(S7601C16*)(S7601C15*), ABISELECT(336,220), "S7601C12");
    /*is_ambiguous_... S7601C6::S7601C3 */ AMB_check_base_class_offset(lv, (S7601C3*)(S7601C6*)(S7601C16*)(S7601C15*), ABISELECT(344,224), "S7601C12");
    check_base_class_offset(lv, (S7601C6*)(S7601C16*)(S7601C15*), ABISELECT(336,220), "S7601C12");
    /*is_ambiguous_... S7601C16::S7601C7 */ AMB_check_base_class_offset(lv, (S7601C7*)(S7601C16*)(S7601C15*), ABISELECT(384,244), "S7601C12");
    check_base_class_offset(lv, (S7601C16*)(S7601C15*), ABISELECT(336,220), "S7601C12");
    check_base_class_offset(lv, (S7601C15*), ABISELECT(336,220), "S7601C12");
    /*is_ambiguous_... S7601C12::S7601C2 */ AMB_check_base_class_offset(lv, (S7601C2*), ABISELECT(72,44), "S7601C12");
    test_class_info(&lv, &cd_S7601C12);
    dp->~S7601C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS7601C12(Test_S7601C12, "S7601C12", ABISELECT(576,372));

#else // __cplusplus

extern void _ZN8S7601C12C1Ev();
extern void _ZN8S7601C12D1Ev();
Name_Map name_map_S7601C12[] = {
  NSPAIR(_ZN8S7601C12C1Ev),
  NSPAIR(_ZN8S7601C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
extern Class_Descriptor cd_S7601C6;
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C9;
extern VTBL_ENTRY _ZTI7S7601C9[];
extern  VTBL_ENTRY _ZTV7S7601C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C9[];
extern Class_Descriptor cd_S7601C11;
extern VTBL_ENTRY _ZTI8S7601C11[];
extern  VTBL_ENTRY _ZTV8S7601C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C11[];
extern Class_Descriptor cd_S7601C10;
extern VTBL_ENTRY _ZTI8S7601C10[];
extern  VTBL_ENTRY _ZTV8S7601C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C10[];
extern Class_Descriptor cd_S7601C5;
extern VTBL_ENTRY _ZTI7S7601C5[];
extern  VTBL_ENTRY _ZTV7S7601C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C5[];
extern Class_Descriptor cd_S7601C14_nt;
extern VTBL_ENTRY _ZTI11S7601C14_nt[];
extern  VTBL_ENTRY _ZTV11S7601C14_nt[];
extern Class_Descriptor cd_S7601C13;
extern VTBL_ENTRY _ZTI8S7601C13[];
extern  VTBL_ENTRY _ZTV8S7601C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C13[];
extern Class_Descriptor cd_S7601C11;
extern VTBL_ENTRY _ZTI8S7601C11[];
extern  VTBL_ENTRY _ZTV8S7601C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C11[];
extern Class_Descriptor cd_S7601C13;
extern VTBL_ENTRY _ZTI8S7601C13[];
extern  VTBL_ENTRY _ZTV8S7601C13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C13[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
extern Class_Descriptor cd_S7601C3;
extern VTBL_ENTRY _ZTI7S7601C3[];
extern  VTBL_ENTRY _ZTV7S7601C3[];
extern Class_Descriptor cd_S7601C6;
extern VTBL_ENTRY _ZTI7S7601C6[];
extern  VTBL_ENTRY _ZTV7S7601C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C6[];
extern Class_Descriptor cd_S7601C7;
extern VTBL_ENTRY _ZTI7S7601C7[];
extern  VTBL_ENTRY _ZTV7S7601C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C7[];
extern Class_Descriptor cd_S7601C16;
extern VTBL_ENTRY _ZTI8S7601C16[];
extern  VTBL_ENTRY _ZTV8S7601C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C16[];
extern Class_Descriptor cd_S7601C15;
extern VTBL_ENTRY _ZTI8S7601C15[];
extern  VTBL_ENTRY _ZTV8S7601C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S7601C15[];
extern Class_Descriptor cd_S7601C2;
extern VTBL_ENTRY _ZTI7S7601C2[];
extern  VTBL_ENTRY _ZTV7S7601C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S7601C2[];
static Base_Class bases_S7601C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S7601C3,    ABISELECT(80,48), //bcp->offset
    48, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S7601C2,    ABISELECT(104,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C3,    ABISELECT(112,64), //bcp->offset
    74, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S7601C2,    ABISELECT(144,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S7601C7,    ABISELECT(144,84), //bcp->offset
    80, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S7601C6,    ABISELECT(104,60), //bcp->offset
    58, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S7601C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7601C2,    ABISELECT(24,12), //bcp->offset
    29, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S7601C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S7601C11,    ABISELECT(304,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S7601C10,    ABISELECT(304,196), //bcp->offset
    94, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S7601C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7601C14_nt,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S7601C13,    ABISELECT(56,36), //bcp->offset
    33, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S7601C11,    ABISELECT(320,208), //bcp->offset
    123, //bcp->virtual_function_table_offset
    14, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7601C13,    ABISELECT(552,364), //bcp->offset
    192, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    91, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    21, //immediately_derived
  0, 1},
  {&cd_S7601C2,    ABISELECT(336,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S7601C3,    ABISELECT(344,224), //bcp->offset
    176, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S7601C6,    ABISELECT(336,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    69, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7601C7,    ABISELECT(384,244), //bcp->offset
    182, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    75, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S7601C16,    ABISELECT(336,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S7601C15,    ABISELECT(336,220), //bcp->offset
    146, //bcp->virtual_function_table_offset
    23, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S7601C2,    ABISELECT(72,44), //bcp->offset
    44, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S7601C12[];
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void _ZN8S7601C12D1Ev();
extern void _ZN8S7601C12D0Ev();
extern void _ZN7S7601C53v27Ev();
extern void _ZN7S7601C53v28Ev();
extern void _ZN8S7601C123v41Ev();
extern void _ZN8S7601C123v42Ev();
extern void _ZN8S7601C123v43Ev();
extern void _ZN8S7601C123v44Ev();
extern void _ZN8S7601C123v45Ev();
extern void _ZN8S7601C123v46Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C12D1Ev,_ZTv0_n28_N8S7601C12D1Ev)();
extern void ABISELECT(_ZThn104_N8S7601C12D1Ev,_ZThn60_N8S7601C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S7601C12D0Ev,_ZTv0_n28_N8S7601C12D0Ev)();
extern void ABISELECT(_ZThn104_N8S7601C12D0Ev,_ZThn60_N8S7601C12D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void ABISELECT(_ZTv0_n112_N8S7601C12D1Ev,_ZTv0_n56_N8S7601C12D1Ev)();
extern void ABISELECT(_ZThn304_N8S7601C12D1Ev,_ZThn196_N8S7601C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n112_N8S7601C12D0Ev,_ZTv0_n56_N8S7601C12D0Ev)();
extern void ABISELECT(_ZThn304_N8S7601C12D0Ev,_ZThn196_N8S7601C12D0Ev)() __attribute__((weak));
extern void _ZN8S7601C103v24Ev();
extern void _ZN8S7601C103v25Ev();
extern void _ZN8S7601C103v26Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void ABISELECT(_ZTv0_n112_N8S7601C12D1Ev,_ZTv0_n56_N8S7601C12D1Ev)();
extern void ABISELECT(_ZThn320_N8S7601C12D1Ev,_ZThn208_N8S7601C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n112_N8S7601C12D0Ev,_ZTv0_n56_N8S7601C12D0Ev)();
extern void ABISELECT(_ZThn320_N8S7601C12D0Ev,_ZThn208_N8S7601C12D0Ev)() __attribute__((weak));
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n88_N8S7601C12D1Ev,_ZTv0_n44_N8S7601C12D1Ev)();
extern void ABISELECT(_ZThn336_N8S7601C12D1Ev,_ZThn220_N8S7601C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S7601C12D0Ev,_ZTv0_n44_N8S7601C12D0Ev)();
extern void ABISELECT(_ZThn336_N8S7601C12D0Ev,_ZThn220_N8S7601C12D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
extern void _ZN8S7601C163v38Ev();
extern void _ZN8S7601C153v39Ev();
extern void _ZN8S7601C153v40Ev();
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
static  VTBL_ENTRY vtc_S7601C12[] = {
  ABISELECT(552,364),
  ABISELECT(336,220),
  ABISELECT(320,208),
  ABISELECT(56,36),
  ABISELECT(304,196),
  ABISELECT(104,60),
  ABISELECT(80,48),
  ABISELECT(144,84),
  ABISELECT(144,84),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&_ZN8S7601C12D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C12D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C53v27Ev,
  (VTBL_ENTRY)&_ZN7S7601C53v28Ev,
  (VTBL_ENTRY)&_ZN8S7601C123v41Ev,
  (VTBL_ENTRY)&_ZN8S7601C123v42Ev,
  (VTBL_ENTRY)&_ZN8S7601C123v43Ev,
  (VTBL_ENTRY)&_ZN8S7601C123v44Ev,
  (VTBL_ENTRY)&_ZN8S7601C123v45Ev,
  (VTBL_ENTRY)&_ZN8S7601C123v46Ev,
  ABISELECT(56,36),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
  ABISELECT(8,4),
  ABISELECT(-72,-44),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-104,-60),
  0,
  ABISELECT(40,24),
  ABISELECT(40,24),
  ABISELECT(-24,-12),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C12D1Ev,_ZTv0_n28_N8S7601C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C12D0Ev,_ZTv0_n28_N8S7601C12D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  ABISELECT(-112,-64),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(-144,-84),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  0,
  0,
  0,
  ABISELECT(-304,-196),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-200,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-224,-148),
  ABISELECT(-304,-196),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N8S7601C12D1Ev,_ZTv0_n56_N8S7601C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N8S7601C12D0Ev,_ZTv0_n56_N8S7601C12D0Ev),
  (VTBL_ENTRY)&_ZN8S7601C103v24Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v25Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v26Ev,
  ABISELECT(-320,-208),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-216,-148),
  ABISELECT(-176,-124),
  ABISELECT(-176,-124),
  ABISELECT(-176,-124),
  ABISELECT(-240,-160),
  ABISELECT(-320,-208),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N8S7601C12D1Ev,_ZTv0_n56_N8S7601C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N8S7601C12D0Ev,_ZTv0_n56_N8S7601C12D0Ev),
  0,
  0,
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(48,24),
  ABISELECT(48,24),
  0,
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-336,-220),
  0,
  ABISELECT(-16,-12),
  ABISELECT(-280,-184),
  ABISELECT(216,144),
  ABISELECT(-232,-160),
  ABISELECT(-192,-136),
  ABISELECT(-192,-136),
  ABISELECT(-256,-172),
  ABISELECT(-336,-220),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S7601C12D1Ev,_ZTv0_n44_N8S7601C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S7601C12D0Ev,_ZTv0_n44_N8S7601C12D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  (VTBL_ENTRY)&_ZN8S7601C163v38Ev,
  (VTBL_ENTRY)&_ZN8S7601C153v39Ev,
  (VTBL_ENTRY)&_ZN8S7601C153v40Ev,
  ABISELECT(-344,-224),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  ABISELECT(-240,-160),
  ABISELECT(-240,-160),
  ABISELECT(-304,-196),
  ABISELECT(-384,-244),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-552,-364),
  (VTBL_ENTRY)&(_ZTI8S7601C12[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
};
extern VTBL_ENTRY _ZTV8S7601C12[];
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void _ZN7S7601C5D1Ev();
extern void _ZN7S7601C5D0Ev();
extern void _ZN7S7601C53v27Ev();
extern void _ZN7S7601C53v28Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C5__8S7601C12[] = {
  ABISELECT(304,196),
  ABISELECT(104,60),
  ABISELECT(80,48),
  ABISELECT(144,84),
  ABISELECT(144,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&_ZN7S7601C5D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C5D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C53v27Ev,
  (VTBL_ENTRY)&_ZN7S7601C53v28Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
extern void _ZN7S7601C93v14Ev();
extern void _ZN7S7601C93v15Ev();
extern void _ZN7S7601C93v16Ev();
extern void _ZN7S7601C93v17Ev();
extern void _ZN7S7601C9D1Ev();
extern void _ZN7S7601C9D0Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C97S7601C5__8S7601C12[] = {
  ABISELECT(104,60),
  ABISELECT(80,48),
  ABISELECT(144,84),
  ABISELECT(144,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v14Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v15Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v16Ev,
  (VTBL_ENTRY)&_ZN7S7601C93v17Ev,
  (VTBL_ENTRY)&_ZN7S7601C9D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C9D0Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C97S7601C5__A2__8S7601C12[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C97S7601C5__A2__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C97S7601C5__8S7601C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(-144,-84),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C97S7601C5__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev)();
extern void ABISELECT(_ZThn104_N7S7601C9D1Ev,_ZThn60_N7S7601C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev)();
extern void ABISELECT(_ZThn104_N7S7601C9D0Ev,_ZThn60_N7S7601C9D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__7S7601C97S7601C5__8S7601C12[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-104,-60),
  0,
  ABISELECT(40,24),
  ABISELECT(40,24),
  ABISELECT(-24,-12),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C9D1Ev,_ZTv0_n28_N7S7601C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C9D0Ev,_ZTv0_n28_N7S7601C9D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__7S7601C97S7601C5__8S7601C12[] = {
  ABISELECT(-112,-64),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A__7S7601C97S7601C5__8S7601C12[] = {
  ABISELECT(56,36),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S7601C9[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C5__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N7S7601C5D1Ev,_ZTv0_n28_N7S7601C5D1Ev)();
extern void ABISELECT(_ZThn104_N7S7601C5D1Ev,_ZThn60_N7S7601C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S7601C5D0Ev,_ZTv0_n28_N7S7601C5D0Ev)();
extern void ABISELECT(_ZThn104_N7S7601C5D0Ev,_ZThn60_N7S7601C5D0Ev)() __attribute__((weak));
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__7S7601C5__8S7601C12[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(-104,-60),
  0,
  ABISELECT(40,24),
  ABISELECT(40,24),
  ABISELECT(-24,-12),
  ABISELECT(-104,-60),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C5D1Ev,_ZTv0_n28_N7S7601C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S7601C5D0Ev,_ZTv0_n28_N7S7601C5D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__7S7601C5__8S7601C12[] = {
  ABISELECT(-112,-64),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C5__8S7601C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(-144,-84),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C9__A2__7S7601C5__8S7601C12[] = {
  ABISELECT(56,36),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void ABISELECT(_ZTv0_n112_N7S7601C5D1Ev,_ZTv0_n56_N7S7601C5D1Ev)();
extern void ABISELECT(_ZThn304_N7S7601C5D1Ev,_ZThn196_N7S7601C5D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n112_N7S7601C5D0Ev,_ZTv0_n56_N7S7601C5D0Ev)();
extern void ABISELECT(_ZThn304_N7S7601C5D0Ev,_ZThn196_N7S7601C5D0Ev)() __attribute__((weak));
extern void _ZN8S7601C103v24Ev();
extern void _ZN8S7601C103v25Ev();
extern void _ZN8S7601C103v26Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C10__7S7601C5__8S7601C12[] = {
  0,
  0,
  0,
  ABISELECT(-304,-196),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-200,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-224,-148),
  ABISELECT(-304,-196),
  (VTBL_ENTRY)&(_ZTI7S7601C5[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N7S7601C5D1Ev,_ZTv0_n56_N7S7601C5D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N7S7601C5D0Ev,_ZTv0_n56_N7S7601C5D0Ev),
  (VTBL_ENTRY)&_ZN8S7601C103v24Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v25Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v26Ev,
};
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C13__A__8S7601C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C13[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A__8S7601C12[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__A__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C12[] = {
  ABISELECT(40,24),
  ABISELECT(40,24),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C6__8S7601C12[] = {
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C6__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C6__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C6__8S7601C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C12[] = {
  0,
  0,
  ABISELECT(-64,-36),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C7__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(64,36),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__A1__8S7601C12[] = {
  ABISELECT(-64,-36),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C2__A1__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(64,36),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C10D1Ev();
extern void _ZN8S7601C10D0Ev();
extern void _ZN8S7601C103v24Ev();
extern void _ZN8S7601C103v25Ev();
extern void _ZN8S7601C103v26Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C10__8S7601C12[] = {
  ABISELECT(-200,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-224,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C10D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C10D0Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v24Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v25Ev,
  (VTBL_ENTRY)&_ZN8S7601C103v26Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C11D1Ev();
extern void _ZN8S7601C11D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C118S7601C10__8S7601C12[] = {
  ABISELECT(-200,-136),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-160,-112),
  ABISELECT(-224,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D0Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C118S7601C10__8S7601C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(160,112),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C118S7601C10__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(224,148),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev)();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C118S7601C10__8S7601C12[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(200,136),
  0,
  ABISELECT(40,24),
  ABISELECT(40,24),
  ABISELECT(-24,-12),
  ABISELECT(200,136),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C118S7601C10__8S7601C12[] = {
  ABISELECT(192,132),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C10__8S7601C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(160,112),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C10__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(224,148),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C10D1Ev,_ZTv0_n28_N8S7601C10D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S7601C10D0Ev,_ZTv0_n28_N8S7601C10D0Ev)();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C10__8S7601C12[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(200,136),
  0,
  ABISELECT(40,24),
  ABISELECT(40,24),
  ABISELECT(-24,-12),
  ABISELECT(200,136),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C10D1Ev,_ZTv0_n28_N8S7601C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C10D0Ev,_ZTv0_n28_N8S7601C10D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C10__8S7601C12[] = {
  ABISELECT(192,132),
  (VTBL_ENTRY)&(_ZTI8S7601C10[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void _ZN8S7601C11D1Ev();
extern void _ZN8S7601C11D0Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C11__A1__8S7601C12[] = {
  ABISELECT(-216,-148),
  ABISELECT(-176,-124),
  ABISELECT(-176,-124),
  ABISELECT(-176,-124),
  ABISELECT(-240,-160),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C11D0Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C11__A1__8S7601C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(176,124),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C11__A1__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(240,160),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev)();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C11__A1__8S7601C12[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(216,148),
  0,
  ABISELECT(40,24),
  ABISELECT(40,24),
  ABISELECT(-24,-12),
  ABISELECT(216,148),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D1Ev,_ZTv0_n28_N8S7601C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C11D0Ev,_ZTv0_n28_N8S7601C11D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C11__A1__8S7601C12[] = {
  ABISELECT(208,144),
  (VTBL_ENTRY)&(_ZTI8S7601C11[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C15D1Ev();
extern void _ZN8S7601C15D0Ev();
extern void _ZN7S7601C63v13Ev();
extern void _ZN8S7601C163v38Ev();
extern void _ZN8S7601C153v39Ev();
extern void _ZN8S7601C153v40Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C15__8S7601C12[] = {
  ABISELECT(-16,-12),
  ABISELECT(-280,-184),
  ABISELECT(216,144),
  ABISELECT(-232,-160),
  ABISELECT(-192,-136),
  ABISELECT(-192,-136),
  ABISELECT(-256,-172),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C15D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C15D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  (VTBL_ENTRY)&_ZN8S7601C163v38Ev,
  (VTBL_ENTRY)&_ZN8S7601C153v39Ev,
  (VTBL_ENTRY)&_ZN8S7601C153v40Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C16D1Ev();
extern void _ZN8S7601C16D0Ev();
extern void _ZN7S7601C63v13Ev();
extern void _ZN8S7601C163v38Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C168S7601C15__8S7601C12[] = {
  ABISELECT(-192,-136),
  ABISELECT(-192,-136),
  ABISELECT(-256,-172),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C16D1Ev,
  (VTBL_ENTRY)&_ZN8S7601C16D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
  (VTBL_ENTRY)&_ZN8S7601C163v38Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C6D1Ev();
extern void _ZN7S7601C6D0Ev();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C68S7601C168S7601C15__A1__8S7601C12[] = {
  ABISELECT(-192,-136),
  ABISELECT(-192,-136),
  ABISELECT(-256,-172),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D1Ev,
  (VTBL_ENTRY)&_ZN7S7601C6D0Ev,
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C27S7601C68S7601C168S7601C15__A3__8S7601C12[] = {
  ABISELECT(-256,-172),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C27S7601C68S7601C168S7601C15__A3__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(256,172),
  (VTBL_ENTRY)&(_ZTI7S7601C2[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C68S7601C168S7601C15__A1__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(256,172),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__7S7601C68S7601C168S7601C15__A1__8S7601C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(192,136),
  (VTBL_ENTRY)&(_ZTI7S7601C6[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C78S7601C168S7601C15__A1__8S7601C12[] = {
  ABISELECT(-240,-160),
  ABISELECT(-240,-160),
  ABISELECT(-304,-196),
  0,
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C2__7S7601C78S7601C168S7601C15__A1__8S7601C12[] = {
  0,
  ABISELECT(-64,-36),
  ABISELECT(240,160),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__7S7601C78S7601C168S7601C15__A1__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(304,196),
  (VTBL_ENTRY)&(_ZTI7S7601C7[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C168S7601C15__8S7601C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(192,136),
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C168S7601C15__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(256,172),
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__A__8S7601C168S7601C15__8S7601C12[] = {
  ABISELECT(-240,-160),
  ABISELECT(-240,-160),
  ABISELECT(-304,-196),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7601C16[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void ABISELECT(_ZTv0_n56_N8S7601C15D1Ev,_ZTv0_n28_N8S7601C15D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S7601C15D0Ev,_ZTv0_n28_N8S7601C15D0Ev)();
extern void _ZN7S7601C63v13Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C6__8S7601C15__8S7601C12[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  ABISELECT(232,160),
  0,
  ABISELECT(40,24),
  ABISELECT(40,24),
  ABISELECT(-24,-12),
  ABISELECT(232,160),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C15D1Ev,_ZTv0_n28_N8S7601C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S7601C15D0Ev,_ZTv0_n28_N8S7601C15D0Ev),
  (VTBL_ENTRY)&_ZN7S7601C63v13Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C3__8S7601C15__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(256,172),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C32v4Ev();
extern void _ZN7S7601C32v5Ev();
extern void _ZN7S7601C32v6Ev();
extern void _ZN7S7601C32v7Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C37S7601C6__A1__8S7601C15__8S7601C12[] = {
  ABISELECT(224,156),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C32v4Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v5Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v6Ev,
  (VTBL_ENTRY)&_ZN7S7601C32v7Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C7__8S7601C15__8S7601C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-36),
  ABISELECT(192,136),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C13__8S7601C15__8S7601C12[] = {
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-216,-144),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
};
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
static  VTBL_ENTRY _tg__ZTV11S7601C14_nt__8S7601C15__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(280,184),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN7S7601C72v9Ev();
extern void _ZN7S7601C73v10Ev();
extern void _ZN7S7601C73v11Ev();
extern void _ZN7S7601C73v12Ev();
static  VTBL_ENTRY _tg__ZTV7S7601C78S7601C16__A1__8S7601C15__8S7601C12[] = {
  ABISELECT(-240,-160),
  ABISELECT(-240,-160),
  ABISELECT(-304,-196),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN7S7601C72v9Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v10Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v11Ev,
  (VTBL_ENTRY)&_ZN7S7601C73v12Ev,
};
extern void _ZN7S7601C22v8Ev();
extern void _ZN8S7601C113v18Ev();
extern void _ZN8S7601C113v19Ev();
extern void _ZN8S7601C113v20Ev();
extern void _ZN8S7601C113v21Ev();
extern void _ZN8S7601C113v22Ev();
extern void _ZN8S7601C113v23Ev();
extern void ABISELECT(_ZTv0_n112_N8S7601C15D1Ev,_ZTv0_n56_N8S7601C15D1Ev)();
extern void ABISELECT(_ZTv0_n112_N8S7601C15D0Ev,_ZTv0_n56_N8S7601C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S7601C11__8S7601C15__8S7601C12[] = {
  ABISELECT(16,12),
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-216,-148),
  ABISELECT(-176,-124),
  ABISELECT(-176,-124),
  ABISELECT(-176,-124),
  ABISELECT(-240,-160),
  ABISELECT(16,12),
  (VTBL_ENTRY)&(_ZTI8S7601C15[0]),
  (VTBL_ENTRY)&_ZN7S7601C22v8Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v18Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v19Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v20Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v21Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v22Ev,
  (VTBL_ENTRY)&_ZN8S7601C113v23Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N8S7601C15D1Ev,_ZTv0_n56_N8S7601C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n112_N8S7601C15D0Ev,_ZTv0_n56_N8S7601C15D0Ev),
};
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
static  VTBL_ENTRY _tg__ZTV8S7601C13__A1__8S7601C12[] = {
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  ABISELECT(-496,-328),
  0,
  (VTBL_ENTRY)&(_ZTI8S7601C13[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
};
extern void _ZN11S7601C14_nt3v34Ev();
extern void _ZN11S7601C14_nt3v35Ev();
extern void _ZN11S7601C14_nt3v36Ev();
extern void _ZN11S7601C14_nt3v37Ev();
static  VTBL_ENTRY _tg__ZTV11S7601C14_nt__8S7601C13__A1__8S7601C12[] = {
  0,
  0,
  0,
  0,
  ABISELECT(496,328),
  (VTBL_ENTRY)&(_ZTI8S7601C13[0]),
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v34Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v35Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v36Ev,
  (VTBL_ENTRY)&_ZN11S7601C14_nt3v37Ev,
};
static  VTT_ENTRY vtt_S7601C12[] = {
  {&(_ZTV8S7601C12[11]),  11,203},
  {&(_tg__ZTV7S7601C5__8S7601C12[7]),  7,19},
  {&(_tg__ZTV7S7601C97S7601C5__8S7601C12[6]),  6,16},
  {&(_tg__ZTV7S7601C27S7601C97S7601C5__A2__8S7601C12[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C97S7601C5__A2__8S7601C12[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C97S7601C5__8S7601C12[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C97S7601C5__8S7601C12[9]),  9,14},
  {&(_tg__ZTV7S7601C3__7S7601C97S7601C5__8S7601C12[6]),  6,10},
  {&(_tg__ZTV7S7601C6__7S7601C97S7601C5__8S7601C12[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__7S7601C97S7601C5__8S7601C12[2]),  2,6},
  {&(_tg__ZTV7S7601C2__A__7S7601C97S7601C5__8S7601C12[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C5__8S7601C12[6]),  6,10},
  {&(_tg__ZTV7S7601C6__7S7601C5__8S7601C12[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__7S7601C5__8S7601C12[2]),  2,6},
  {&(_tg__ZTV7S7601C7__7S7601C5__8S7601C12[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C5__8S7601C12[9]),  9,14},
  {&(_tg__ZTV7S7601C27S7601C9__A2__7S7601C5__8S7601C12[3]),  3,4},
  {&(_tg__ZTV8S7601C10__7S7601C5__8S7601C12[17]),  17,29},
  {&(_tg__ZTV8S7601C13__A__8S7601C12[7]),  7,11},
  {&(_tg__ZTV8S7601C13__A__8S7601C12[7]),  7,11},
  {&(_tg__ZTV7S7601C2__A__8S7601C12[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__A__8S7601C12[6]),  6,10},
  {&(_ZTV8S7601C12[54]),  54,203},
  {&(_ZTV8S7601C12[70]),  70,203},
  {&(_ZTV8S7601C12[76]),  76,203},
  {&(_ZTV8S7601C12[89]),  89,203},
  {&(_ZTV8S7601C12[89]),  89,203},
  {&(_ZTV8S7601C12[32]),  32,203},
  {&(_ZTV8S7601C12[111]),  111,203},
  {&(_ZTV8S7601C12[40]),  40,203},
  {&(_ZTV8S7601C12[40]),  40,203},
  {&(_ZTV8S7601C12[137]),  137,203},
  {&(_ZTV8S7601C12[169]),  169,203},
  {&(_ZTV8S7601C12[199]),  199,203},
  {&(_ZTV8S7601C12[178]),  178,203},
  {&(_ZTV8S7601C12[187]),  187,203},
  {&(_ZTV8S7601C12[47]),  47,203},
  {&(_tg__ZTV7S7601C6__8S7601C12[5]),  5,9},
  {&(_tg__ZTV7S7601C27S7601C6__8S7601C12[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C27S7601C6__8S7601C12[6]),  6,10},
  {&(_tg__ZTV7S7601C3__7S7601C6__8S7601C12[6]),  6,10},
  {&(_tg__ZTV7S7601C7__7S7601C6__8S7601C12[9]),  9,14},
  {&(_tg__ZTV7S7601C7__7S7601C6__8S7601C12[9]),  9,14},
  {&(_tg__ZTV7S7601C7__8S7601C12[5]),  5,10},
  {&(_tg__ZTV7S7601C7__8S7601C12[5]),  5,10},
  {&(_tg__ZTV7S7601C3__7S7601C7__8S7601C12[6]),  6,10},
  {&(_tg__ZTV7S7601C2__A1__8S7601C12[3]),  3,4},
  {&(_tg__ZTV7S7601C3__7S7601C2__A1__8S7601C12[6]),  6,10},
  {&(_tg__ZTV8S7601C10__8S7601C12[7]),  7,19},
  {&(_tg__ZTV8S7601C118S7601C10__8S7601C12[7]),  7,16},
  {&(_tg__ZTV7S7601C7__8S7601C118S7601C10__8S7601C12[9]),  9,14},
  {&(_tg__ZTV7S7601C7__8S7601C118S7601C10__8S7601C12[9]),  9,14},
  {&(_tg__ZTV7S7601C3__8S7601C118S7601C10__8S7601C12[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C118S7601C10__8S7601C12[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__8S7601C118S7601C10__8S7601C12[2]),  2,6},
  {&(_tg__ZTV7S7601C7__8S7601C10__8S7601C12[9]),  9,14},
  {&(_tg__ZTV7S7601C7__8S7601C10__8S7601C12[9]),  9,14},
  {&(_tg__ZTV7S7601C3__8S7601C10__8S7601C12[6]),  6,10},
  {&(_tg__ZTV7S7601C6__8S7601C10__8S7601C12[12]),  12,16},
  {&(_tg__ZTV7S7601C37S7601C6__A1__8S7601C10__8S7601C12[2]),  2,6},
  {&(_tg__ZTV8S76