// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S685C6_nt  {
  int s685c6f0[2];
  void  mf685c6(); // _ZN9S685C6_nt7mf685c6Ev
};
//SIG(-1 S685C6_nt) C1{ m Fi[2]}


void  S685C6_nt ::mf685c6(){}

//skip512 S685C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C5_nt  {
  int s685c5f0;
  __tsi64 s685c5f1;
  void *s685c5f2[4];
  int s685c5f3[2];
  void *s685c5f4;
  ::S685C6_nt s685c5f5;
  void *s685c5f6[2];
  virtual  ~S685C5_nt(); // _ZN9S685C5_ntD1Ev
  virtual void  v7(); // _ZN9S685C5_nt2v7Ev
  virtual void  v8(); // _ZN9S685C5_nt2v8Ev
  virtual void  v9(); // _ZN9S685C5_nt2v9Ev
  virtual void  v10(); // _ZN9S685C5_nt3v10Ev
  virtual void  v11(); // _ZN9S685C5_nt3v11Ev
  virtual void  v12(); // _ZN9S685C5_nt3v12Ev
  virtual void  v13(); // _ZN9S685C5_nt3v13Ev
  virtual void  v14(); // _ZN9S685C5_nt3v14Ev
  virtual void  v15(); // _ZN9S685C5_nt3v15Ev
  virtual void  v16(); // _ZN9S685C5_nt3v16Ev
  virtual void  v17(); // _ZN9S685C5_nt3v17Ev
  virtual void  v18(); // _ZN9S685C5_nt3v18Ev
  virtual void  v19(); // _ZN9S685C5_nt3v19Ev
  virtual void  v20(); // _ZN9S685C5_nt3v20Ev
  virtual void  v21(); // _ZN9S685C5_nt3v21Ev
  virtual void  v22(); // _ZN9S685C5_nt3v22Ev
  virtual void  v23(); // _ZN9S685C5_nt3v23Ev
  virtual void  v24(); // _ZN9S685C5_nt3v24Ev
  virtual void  v25(); // _ZN9S685C5_nt3v25Ev
  virtual void  v26(); // _ZN9S685C5_nt3v26Ev
  virtual void  v27(); // _ZN9S685C5_nt3v27Ev
  virtual void  v28(); // _ZN9S685C5_nt3v28Ev
  virtual void  v29(); // _ZN9S685C5_nt3v29Ev
  virtual void  v30(); // _ZN9S685C5_nt3v30Ev
  virtual void  v31(); // _ZN9S685C5_nt3v31Ev
  virtual void  v32(); // _ZN9S685C5_nt3v32Ev
  virtual void  v33(); // _ZN9S685C5_nt3v33Ev
  virtual void  v34(); // _ZN9S685C5_nt3v34Ev
  virtual void  v35(); // _ZN9S685C5_nt3v35Ev
  virtual void  v36(); // _ZN9S685C5_nt3v36Ev
  virtual void  v37(); // _ZN9S685C5_nt3v37Ev
  virtual void  v38(); // _ZN9S685C5_nt3v38Ev
  virtual void  v39(); // _ZN9S685C5_nt3v39Ev
  virtual void  v40(); // _ZN9S685C5_nt3v40Ev
  virtual void  v41(); // _ZN9S685C5_nt3v41Ev
  virtual void  v42(); // _ZN9S685C5_nt3v42Ev
  virtual void  v43(); // _ZN9S685C5_nt3v43Ev
  virtual void  v44(); // _ZN9S685C5_nt3v44Ev
  virtual void  v45(); // _ZN9S685C5_nt3v45Ev
  virtual void  v46(); // _ZN9S685C5_nt3v46Ev
  virtual void  v47(); // _ZN9S685C5_nt3v47Ev
  virtual void  v48(); // _ZN9S685C5_nt3v48Ev
  virtual void  v49(); // _ZN9S685C5_nt3v49Ev
  virtual void  v50(); // _ZN9S685C5_nt3v50Ev
  virtual void  v51(); // _ZN9S685C5_nt3v51Ev
  virtual void  v52(); // _ZN9S685C5_nt3v52Ev
  virtual void  v53(); // _ZN9S685C5_nt3v53Ev
  virtual void  v54(); // _ZN9S685C5_nt3v54Ev
  virtual void  v55(); // _ZN9S685C5_nt3v55Ev
  virtual void  v56(); // _ZN9S685C5_nt3v56Ev
  virtual void  v57(); // _ZN9S685C5_nt3v57Ev
  virtual void  v58(); // _ZN9S685C5_nt3v58Ev
  virtual void  v59(); // _ZN9S685C5_nt3v59Ev
  virtual void  v60(); // _ZN9S685C5_nt3v60Ev
  virtual void  v61(); // _ZN9S685C5_nt3v61Ev
  virtual void  v62(); // _ZN9S685C5_nt3v62Ev
  virtual void  v63(); // _ZN9S685C5_nt3v63Ev
  virtual void  v64(); // _ZN9S685C5_nt3v64Ev
  virtual void  v65(); // _ZN9S685C5_nt3v65Ev
  virtual void  v66(); // _ZN9S685C5_nt3v66Ev
  virtual void  v67(); // _ZN9S685C5_nt3v67Ev
  virtual void  v68(); // _ZN9S685C5_nt3v68Ev
  virtual void  v69(); // _ZN9S685C5_nt3v69Ev
  virtual void  v70(); // _ZN9S685C5_nt3v70Ev
  S685C5_nt(); // tgen
};
//SIG(-1 S685C5_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S685C5_nt ::~S685C5_nt(){ note_dtor("S685C5_nt", this);}
void  S685C5_nt ::v7(){vfunc_called(this, "_ZN9S685C5_nt2v7Ev");}
void  S685C5_nt ::v8(){vfunc_called(this, "_ZN9S685C5_nt2v8Ev");}
void  S685C5_nt ::v9(){vfunc_called(this, "_ZN9S685C5_nt2v9Ev");}
void  S685C5_nt ::v10(){vfunc_called(this, "_ZN9S685C5_nt3v10Ev");}
void  S685C5_nt ::v11(){vfunc_called(this, "_ZN9S685C5_nt3v11Ev");}
void  S685C5_nt ::v12(){vfunc_called(this, "_ZN9S685C5_nt3v12Ev");}
void  S685C5_nt ::v13(){vfunc_called(this, "_ZN9S685C5_nt3v13Ev");}
void  S685C5_nt ::v14(){vfunc_called(this, "_ZN9S685C5_nt3v14Ev");}
void  S685C5_nt ::v15(){vfunc_called(this, "_ZN9S685C5_nt3v15Ev");}
void  S685C5_nt ::v16(){vfunc_called(this, "_ZN9S685C5_nt3v16Ev");}
void  S685C5_nt ::v17(){vfunc_called(this, "_ZN9S685C5_nt3v17Ev");}
void  S685C5_nt ::v18(){vfunc_called(this, "_ZN9S685C5_nt3v18Ev");}
void  S685C5_nt ::v19(){vfunc_called(this, "_ZN9S685C5_nt3v19Ev");}
void  S685C5_nt ::v20(){vfunc_called(this, "_ZN9S685C5_nt3v20Ev");}
void  S685C5_nt ::v21(){vfunc_called(this, "_ZN9S685C5_nt3v21Ev");}
void  S685C5_nt ::v22(){vfunc_called(this, "_ZN9S685C5_nt3v22Ev");}
void  S685C5_nt ::v23(){vfunc_called(this, "_ZN9S685C5_nt3v23Ev");}
void  S685C5_nt ::v24(){vfunc_called(this, "_ZN9S685C5_nt3v24Ev");}
void  S685C5_nt ::v25(){vfunc_called(this, "_ZN9S685C5_nt3v25Ev");}
void  S685C5_nt ::v26(){vfunc_called(this, "_ZN9S685C5_nt3v26Ev");}
void  S685C5_nt ::v27(){vfunc_called(this, "_ZN9S685C5_nt3v27Ev");}
void  S685C5_nt ::v28(){vfunc_called(this, "_ZN9S685C5_nt3v28Ev");}
void  S685C5_nt ::v29(){vfunc_called(this, "_ZN9S685C5_nt3v29Ev");}
void  S685C5_nt ::v30(){vfunc_called(this, "_ZN9S685C5_nt3v30Ev");}
void  S685C5_nt ::v31(){vfunc_called(this, "_ZN9S685C5_nt3v31Ev");}
void  S685C5_nt ::v32(){vfunc_called(this, "_ZN9S685C5_nt3v32Ev");}
void  S685C5_nt ::v33(){vfunc_called(this, "_ZN9S685C5_nt3v33Ev");}
void  S685C5_nt ::v34(){vfunc_called(this, "_ZN9S685C5_nt3v34Ev");}
void  S685C5_nt ::v35(){vfunc_called(this, "_ZN9S685C5_nt3v35Ev");}
void  S685C5_nt ::v36(){vfunc_called(this, "_ZN9S685C5_nt3v36Ev");}
void  S685C5_nt ::v37(){vfunc_called(this, "_ZN9S685C5_nt3v37Ev");}
void  S685C5_nt ::v38(){vfunc_called(this, "_ZN9S685C5_nt3v38Ev");}
void  S685C5_nt ::v39(){vfunc_called(this, "_ZN9S685C5_nt3v39Ev");}
void  S685C5_nt ::v40(){vfunc_called(this, "_ZN9S685C5_nt3v40Ev");}
void  S685C5_nt ::v41(){vfunc_called(this, "_ZN9S685C5_nt3v41Ev");}
void  S685C5_nt ::v42(){vfunc_called(this, "_ZN9S685C5_nt3v42Ev");}
void  S685C5_nt ::v43(){vfunc_called(this, "_ZN9S685C5_nt3v43Ev");}
void  S685C5_nt ::v44(){vfunc_called(this, "_ZN9S685C5_nt3v44Ev");}
void  S685C5_nt ::v45(){vfunc_called(this, "_ZN9S685C5_nt3v45Ev");}
void  S685C5_nt ::v46(){vfunc_called(this, "_ZN9S685C5_nt3v46Ev");}
void  S685C5_nt ::v47(){vfunc_called(this, "_ZN9S685C5_nt3v47Ev");}
void  S685C5_nt ::v48(){vfunc_called(this, "_ZN9S685C5_nt3v48Ev");}
void  S685C5_nt ::v49(){vfunc_called(this, "_ZN9S685C5_nt3v49Ev");}
void  S685C5_nt ::v50(){vfunc_called(this, "_ZN9S685C5_nt3v50Ev");}
void  S685C5_nt ::v51(){vfunc_called(this, "_ZN9S685C5_nt3v51Ev");}
void  S685C5_nt ::v52(){vfunc_called(this, "_ZN9S685C5_nt3v52Ev");}
void  S685C5_nt ::v53(){vfunc_called(this, "_ZN9S685C5_nt3v53Ev");}
void  S685C5_nt ::v54(){vfunc_called(this, "_ZN9S685C5_nt3v54Ev");}
void  S685C5_nt ::v55(){vfunc_called(this, "_ZN9S685C5_nt3v55Ev");}
void  S685C5_nt ::v56(){vfunc_called(this, "_ZN9S685C5_nt3v56Ev");}
void  S685C5_nt ::v57(){vfunc_called(this, "_ZN9S685C5_nt3v57Ev");}
void  S685C5_nt ::v58(){vfunc_called(this, "_ZN9S685C5_nt3v58Ev");}
void  S685C5_nt ::v59(){vfunc_called(this, "_ZN9S685C5_nt3v59Ev");}
void  S685C5_nt ::v60(){vfunc_called(this, "_ZN9S685C5_nt3v60Ev");}
void  S685C5_nt ::v61(){vfunc_called(this, "_ZN9S685C5_nt3v61Ev");}
void  S685C5_nt ::v62(){vfunc_called(this, "_ZN9S685C5_nt3v62Ev");}
void  S685C5_nt ::v63(){vfunc_called(this, "_ZN9S685C5_nt3v63Ev");}
void  S685C5_nt ::v64(){vfunc_called(this, "_ZN9S685C5_nt3v64Ev");}
void  S685C5_nt ::v65(){vfunc_called(this, "_ZN9S685C5_nt3v65Ev");}
void  S685C5_nt ::v66(){vfunc_called(this, "_ZN9S685C5_nt3v66Ev");}
void  S685C5_nt ::v67(){vfunc_called(this, "_ZN9S685C5_nt3v67Ev");}
void  S685C5_nt ::v68(){vfunc_called(this, "_ZN9S685C5_nt3v68Ev");}
void  S685C5_nt ::v69(){vfunc_called(this, "_ZN9S685C5_nt3v69Ev");}
void  S685C5_nt ::v70(){vfunc_called(this, "_ZN9S685C5_nt3v70Ev");}
S685C5_nt ::S685C5_nt(){ note_ctor("S685C5_nt", this);} // tgen

//skip512 S685C5_nt

#else // __cplusplus

extern void _ZN9S685C5_ntC1Ev();
extern void _ZN9S685C5_ntD1Ev();
Name_Map name_map_S685C5_nt[] = {
  NSPAIR(_ZN9S685C5_ntC1Ev),
  NSPAIR(_ZN9S685C5_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S685C5_nt[];
extern void _ZN9S685C5_ntD1Ev();
extern void _ZN9S685C5_ntD0Ev();
extern void _ZN9S685C5_nt2v7Ev();
extern void _ZN9S685C5_nt2v8Ev();
extern void _ZN9S685C5_nt2v9Ev();
extern void _ZN9S685C5_nt3v10Ev();
extern void _ZN9S685C5_nt3v11Ev();
extern void _ZN9S685C5_nt3v12Ev();
extern void _ZN9S685C5_nt3v13Ev();
extern void _ZN9S685C5_nt3v14Ev();
extern void _ZN9S685C5_nt3v15Ev();
extern void _ZN9S685C5_nt3v16Ev();
extern void _ZN9S685C5_nt3v17Ev();
extern void _ZN9S685C5_nt3v18Ev();
extern void _ZN9S685C5_nt3v19Ev();
extern void _ZN9S685C5_nt3v20Ev();
extern void _ZN9S685C5_nt3v21Ev();
extern void _ZN9S685C5_nt3v22Ev();
extern void _ZN9S685C5_nt3v23Ev();
extern void _ZN9S685C5_nt3v24Ev();
extern void _ZN9S685C5_nt3v25Ev();
extern void _ZN9S685C5_nt3v26Ev();
extern void _ZN9S685C5_nt3v27Ev();
extern void _ZN9S685C5_nt3v28Ev();
extern void _ZN9S685C5_nt3v29Ev();
extern void _ZN9S685C5_nt3v30Ev();
extern void _ZN9S685C5_nt3v31Ev();
extern void _ZN9S685C5_nt3v32Ev();
extern void _ZN9S685C5_nt3v33Ev();
extern void _ZN9S685C5_nt3v34Ev();
extern void _ZN9S685C5_nt3v35Ev();
extern void _ZN9S685C5_nt3v36Ev();
extern void _ZN9S685C5_nt3v37Ev();
extern void _ZN9S685C5_nt3v38Ev();
extern void _ZN9S685C5_nt3v39Ev();
extern void _ZN9S685C5_nt3v40Ev();
extern void _ZN9S685C5_nt3v41Ev();
extern void _ZN9S685C5_nt3v42Ev();
extern void _ZN9S685C5_nt3v43Ev();
extern void _ZN9S685C5_nt3v44Ev();
extern void _ZN9S685C5_nt3v45Ev();
extern void _ZN9S685C5_nt3v46Ev();
extern void _ZN9S685C5_nt3v47Ev();
extern void _ZN9S685C5_nt3v48Ev();
extern void _ZN9S685C5_nt3v49Ev();
extern void _ZN9S685C5_nt3v50Ev();
extern void _ZN9S685C5_nt3v51Ev();
extern void _ZN9S685C5_nt3v52Ev();
extern void _ZN9S685C5_nt3v53Ev();
extern void _ZN9S685C5_nt3v54Ev();
extern void _ZN9S685C5_nt3v55Ev();
extern void _ZN9S685C5_nt3v56Ev();
extern void _ZN9S685C5_nt3v57Ev();
extern void _ZN9S685C5_nt3v58Ev();
extern void _ZN9S685C5_nt3v59Ev();
extern void _ZN9S685C5_nt3v60Ev();
extern void _ZN9S685C5_nt3v61Ev();
extern void _ZN9S685C5_nt3v62Ev();
extern void _ZN9S685C5_nt3v63Ev();
extern void _ZN9S685C5_nt3v64Ev();
extern void _ZN9S685C5_nt3v65Ev();
extern void _ZN9S685C5_nt3v66Ev();
extern void _ZN9S685C5_nt3v67Ev();
extern void _ZN9S685C5_nt3v68Ev();
extern void _ZN9S685C5_nt3v69Ev();
extern void _ZN9S685C5_nt3v70Ev();
static  VTBL_ENTRY vtc_S685C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S685C5_nt[0]),
  (VTBL_ENTRY)&_ZN9S685C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S685C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v70Ev,
};
extern VTBL_ENTRY _ZTI9S685C5_nt[];
VTBL_ENTRY *P__ZTI9S685C5_nt = _ZTI9S685C5_nt; 
extern  VTBL_ENTRY _ZTV9S685C5_nt[];
Class_Descriptor cd_S685C5_nt = {  "S685C5_nt", // class name
  0,0,//no base classes
  &(vtc_S685C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI9S685C5_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S685C5_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C9_nt  {
  void *s685c9f0;
  int s685c9f1[2];
  void  mf685c9(); // _ZN9S685C9_nt7mf685c9Ev
};
//SIG(-1 S685C9_nt) C1{ m Fp Fi[2]}


void  S685C9_nt ::mf685c9(){}

//skip512 S685C9_nt

#else // __cplusplus

Class_Descriptor cd_S685C9_nt = {  "S685C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C8_nt  : S685C9_nt {
};
//SIG(-1 S685C8_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S685C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
static Base_Class bases_S685C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C8_nt = {  "S685C8_nt", // class name
  bases_S685C8_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C7_nt  : S685C8_nt {
};
//SIG(-1 S685C7_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S685C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
extern Class_Descriptor cd_S685C8_nt;
static Base_Class bases_S685C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C10_nt  {
  int s685c10f0;
  void  mf685c10(); // _ZN10S685C10_nt8mf685c10Ev
};
//SIG(-1 S685C10_nt) C1{ m Fi}


void  S685C10_nt ::mf685c10(){}

//skip512 S685C10_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S685C10_nt[];
VTBL_ENTRY *P__ZTI10S685C10_nt = _ZTI10S685C10_nt; 
Class_Descriptor cd_S685C10_nt = {  "S685C10_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S685C10_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C14  : S685C9_nt {
};
//SIG(-1 S685C14) C1{ BC2{ m Fp Fi[2]}}



static void Test_S685C14()
{
  extern Class_Descriptor cd_S685C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C14, buf);
    S685C14 &lv = *(new (buf) S685C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C14)");
    check_base_class_offset(lv, (S685C9_nt*), 0, "S685C14");
    test_class_info(&lv, &cd_S685C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C14(Test_S685C14, "S685C14", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
static Base_Class bases_S685C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C14 = {  "S685C14", // class name
  bases_S685C14, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C13  : S685C14 {
};
//SIG(-1 S685C13) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S685C13()
{
  extern Class_Descriptor cd_S685C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C13, buf);
    S685C13 &lv = *(new (buf) S685C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C13)");
    check_base_class_offset(lv, (S685C9_nt*)(S685C14*), 0, "S685C13");
    check_base_class_offset(lv, (S685C14*), 0, "S685C13");
    test_class_info(&lv, &cd_S685C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C13(Test_S685C13, "S685C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
extern Class_Descriptor cd_S685C14;
static Base_Class bases_S685C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C13 = {  "S685C13", // class name
  bases_S685C13, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C15_nt  {
  int s685c15f0[3];
  void  mf685c15(); // _ZN10S685C15_nt8mf685c15Ev
};
//SIG(-1 S685C15_nt) C1{ m Fi[3]}


void  S685C15_nt ::mf685c15(){}

//skip512 S685C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C20  : S685C9_nt {
};
//SIG(-1 S685C20) C1{ BC2{ m Fp Fi[2]}}



static void Test_S685C20()
{
  extern Class_Descriptor cd_S685C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C20, buf);
    S685C20 &lv = *(new (buf) S685C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C20)");
    check_base_class_offset(lv, (S685C9_nt*), 0, "S685C20");
    test_class_info(&lv, &cd_S685C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C20(Test_S685C20, "S685C20", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
static Base_Class bases_S685C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C20 = {  "S685C20", // class name
  bases_S685C20, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C19  : S685C20 {
};
//SIG(-1 S685C19) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S685C19()
{
  extern Class_Descriptor cd_S685C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C19, buf);
    S685C19 &lv = *(new (buf) S685C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C19)");
    check_base_class_offset(lv, (S685C9_nt*)(S685C20*), 0, "S685C19");
    check_base_class_offset(lv, (S685C20*), 0, "S685C19");
    test_class_info(&lv, &cd_S685C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C19(Test_S685C19, "S685C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
extern Class_Descriptor cd_S685C20;
static Base_Class bases_S685C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C19 = {  "S685C19", // class name
  bases_S685C19, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C4_nt  : S685C5_nt {
  ::S685C7_nt s685c4f0;
  ::S685C7_nt s685c4f1;
  ::S685C10_nt s685c4f2;
  int s685c4f3;
  char s685c4f4[4];
  void *s685c4f5[2];
  ::S685C7_nt s685c4f6;
  unsigned int s685c4f7:1;
  unsigned int s685c4f8:1;
  unsigned int s685c4f9:1;
  unsigned int s685c4f10:1;
  unsigned int s685c4f11:1;
  unsigned int s685c4f12:1;
  unsigned int s685c4f13:1;
  unsigned int s685c4f14:1;
  unsigned int s685c4f15:1;
  unsigned int s685c4f16:1;
  unsigned int s685c4f17:1;
  unsigned int s685c4f18:1;
  unsigned int s685c4f19:1;
  unsigned int s685c4f20:1;
  unsigned int s685c4f21:1;
  unsigned int s685c4f22:1;
  unsigned int s685c4f23:1;
  unsigned int s685c4f24:1;
  unsigned int s685c4f25:1;
  unsigned int s685c4f26:1;
  unsigned int s685c4f27:1;
  unsigned int s685c4f28:1;
  unsigned int s685c4f29:1;
  unsigned int s685c4f30:1;
  unsigned int s685c4f31:1;
  unsigned int s685c4f32:1;
  unsigned int s685c4f33:1;
  unsigned int s685c4f34:1;
  unsigned int s685c4f35:1;
  unsigned int s685c4f36:1;
  unsigned int s685c4f37:1;
  unsigned int s685c4f38:1;
  unsigned int s685c4f39:1;
  unsigned int s685c4f40:1;
  unsigned int s685c4f41:1;
  unsigned int s685c4f42:1;
  unsigned int s685c4f43:1;
  unsigned int s685c4f44:1;
  unsigned int s685c4f45:1;
  unsigned int s685c4f46:1;
  unsigned int s685c4f47:1;
  unsigned int s685c4f48:1;
  unsigned int s685c4f49:1;
  unsigned int s685c4f50:1;
  unsigned int s685c4f51:1;
  unsigned int s685c4f52:1;
  unsigned int s685c4f53:1;
  unsigned int s685c4f54:1;
  unsigned int s685c4f55:1;
  unsigned int s685c4f56:1;
  unsigned int s685c4f57:1;
  unsigned int s685c4f58:1;
  unsigned int s685c4f59:1;
  unsigned int s685c4f60:1;
  unsigned int s685c4f61:1;
  unsigned int s685c4f62:1;
  unsigned int s685c4f63:1;
  unsigned int s685c4f64:1;
  unsigned int s685c4f65:1;
  unsigned int s685c4f66:1;
  unsigned int s685c4f67:1;
  unsigned int s685c4f68:1;
  unsigned int s685c4f69:1;
  unsigned int s685c4f70:1;
  unsigned int s685c4f71:1;
  unsigned int s685c4f72:1;
  unsigned int s685c4f73:1;
  unsigned int s685c4f74:1;
  unsigned int s685c4f75:1;
  unsigned int s685c4f76:1;
  unsigned int s685c4f77:1;
  unsigned int s685c4f78:1;
  unsigned int s685c4f79:1;
  unsigned int s685c4f80:1;
  unsigned int s685c4f81:1;
  unsigned int s685c4f82:1;
  unsigned int s685c4f83:1;
  int s685c4f84[5];
  void *s685c4f85[2];
  int s685c4f86[3];
  ::S685C6_nt s685c4f87;
  ::S685C6_nt s685c4f88;
  ::S685C6_nt s685c4f89;
  ::S685C13 s685c4f90;
  ::S685C13 s685c4f91;
  int s685c4f92;
  void *s685c4f93[2];
  ::S685C15_nt s685c4f94;
  ::S685C15_nt s685c4f95;
  ::S685C15_nt s685c4f96;
  ::S685C15_nt s685c4f97;
  void *s685c4f98;
  ::S685C6_nt s685c4f99;
  ::S685C13 s685c4f100;
  ::S685C15_nt s685c4f101;
  ::S685C15_nt s685c4f102;
  int s685c4f103;
  ::S685C15_nt s685c4f104;
  ::S685C15_nt s685c4f105;
  void *s685c4f106;
  int s685c4f107;
  char s685c4f108;
  ::S685C15_nt s685c4f109;
  ::S685C15_nt s685c4f110;
  void *s685c4f111;
  int s685c4f112;
  void *s685c4f113;
  ::S685C13 s685c4f114;
  ::S685C19 s685c4f115;
  ::S685C19 s685c4f116;
  virtual  ~S685C4_nt(); // _ZN9S685C4_ntD1Ev
  virtual void  v71(); // _ZN9S685C4_nt3v71Ev
  virtual void  v72(); // _ZN9S685C4_nt3v72Ev
  virtual void  v73(); // _ZN9S685C4_nt3v73Ev
  virtual void  v74(); // _ZN9S685C4_nt3v74Ev
  virtual void  v75(); // _ZN9S685C4_nt3v75Ev
  virtual void  v76(); // _ZN9S685C4_nt3v76Ev
  virtual void  v77(); // _ZN9S685C4_nt3v77Ev
  virtual void  v78(); // _ZN9S685C4_nt3v78Ev
  virtual void  v79(); // _ZN9S685C4_nt3v79Ev
  virtual void  v80(); // _ZN9S685C4_nt3v80Ev
  virtual void  v81(); // _ZN9S685C4_nt3v81Ev
  virtual void  v82(); // _ZN9S685C4_nt3v82Ev
  virtual void  v83(); // _ZN9S685C4_nt3v83Ev
  virtual void  v84(); // _ZN9S685C4_nt3v84Ev
  virtual void  v85(); // _ZN9S685C4_nt3v85Ev
  virtual void  v86(); // _ZN9S685C4_nt3v86Ev
  virtual void  v87(); // _ZN9S685C4_nt3v87Ev
  virtual void  v88(); // _ZN9S685C4_nt3v88Ev
  virtual void  v89(); // _ZN9S685C4_nt3v89Ev
  virtual void  v90(); // _ZN9S685C4_nt3v90Ev
  virtual void  v91(); // _ZN9S685C4_nt3v91Ev
  virtual void  v92(); // _ZN9S685C4_nt3v92Ev
  virtual void  v93(); // _ZN9S685C4_nt3v93Ev
  virtual void  v94(); // _ZN9S685C4_nt3v94Ev
  virtual void  v95(); // _ZN9S685C4_nt3v95Ev
  virtual void  v96(); // _ZN9S685C4_nt3v96Ev
  virtual void  v97(); // _ZN9S685C4_nt3v97Ev
  virtual void  v98(); // _ZN9S685C4_nt3v98Ev
  virtual void  v99(); // _ZN9S685C4_nt3v99Ev
  virtual void  v100(); // _ZN9S685C4_nt4v100Ev
  virtual void  v101(); // _ZN9S685C4_nt4v101Ev
  virtual void  v102(); // _ZN9S685C4_nt4v102Ev
  virtual void  v103(); // _ZN9S685C4_nt4v103Ev
  virtual void  v104(); // _ZN9S685C4_nt4v104Ev
  virtual void  v105(); // _ZN9S685C4_nt4v105Ev
  virtual void  v106(); // _ZN9S685C4_nt4v106Ev
  virtual void  v107(); // _ZN9S685C4_nt4v107Ev
  virtual void  v108(); // _ZN9S685C4_nt4v108Ev
  virtual void  v109(); // _ZN9S685C4_nt4v109Ev
  virtual void  v110(); // _ZN9S685C4_nt4v110Ev
  virtual void  v111(); // _ZN9S685C4_nt4v111Ev
  virtual void  v112(); // _ZN9S685C4_nt4v112Ev
  virtual void  v113(); // _ZN9S685C4_nt4v113Ev
  virtual void  v114(); // _ZN9S685C4_nt4v114Ev
  virtual void  v115(); // _ZN9S685C4_nt4v115Ev
  virtual void  v116(); // _ZN9S685C4_nt4v116Ev
  virtual void  v117(); // _ZN9S685C4_nt4v117Ev
  virtual void  v118(); // _ZN9S685C4_nt4v118Ev
  virtual void  v119(); // _ZN9S685C4_nt4v119Ev
  virtual void  v120(); // _ZN9S685C4_nt4v120Ev
  virtual void  v121(); // _ZN9S685C4_nt4v121Ev
  virtual void  v122(); // _ZN9S685C4_nt4v122Ev
  virtual void  v123(); // _ZN9S685C4_nt4v123Ev
  virtual void  v124(); // _ZN9S685C4_nt4v124Ev
  virtual void  v125(); // _ZN9S685C4_nt4v125Ev
  virtual void  v126(); // _ZN9S685C4_nt4v126Ev
  virtual void  v127(); // _ZN9S685C4_nt4v127Ev
  virtual void  v128(); // _ZN9S685C4_nt4v128Ev
  virtual void  v129(); // _ZN9S685C4_nt4v129Ev
  virtual void  v130(); // _ZN9S685C4_nt4v130Ev
  virtual void  v131(); // _ZN9S685C4_nt4v131Ev
  virtual void  v132(); // _ZN9S685C4_nt4v132Ev
  virtual void  v133(); // _ZN9S685C4_nt4v133Ev
  virtual void  v134(); // _ZN9S685C4_nt4v134Ev
  virtual void  v135(); // _ZN9S685C4_nt4v135Ev
  virtual void  v136(); // _ZN9S685C4_nt4v136Ev
  virtual void  v137(); // _ZN9S685C4_nt4v137Ev
  virtual void  v138(); // _ZN9S685C4_nt4v138Ev
  virtual void  v139(); // _ZN9S685C4_nt4v139Ev
  virtual void  v140(); // _ZN9S685C4_nt4v140Ev
  virtual void  v141(); // _ZN9S685C4_nt4v141Ev
  virtual void  v142(); // _ZN9S685C4_nt4v142Ev
  virtual void  v143(); // _ZN9S685C4_nt4v143Ev
  virtual void  v144(); // _ZN9S685C4_nt4v144Ev
  virtual void  v145(); // _ZN9S685C4_nt4v145Ev
  virtual void  v146(); // _ZN9S685C4_nt4v146Ev
  virtual void  v147(); // _ZN9S685C4_nt4v147Ev
  virtual void  v148(); // _ZN9S685C4_nt4v148Ev
  virtual void  v149(); // _ZN9S685C4_nt4v149Ev
  virtual void  v150(); // _ZN9S685C4_nt4v150Ev
  virtual void  v151(); // _ZN9S685C4_nt4v151Ev
  virtual void  v152(); // _ZN9S685C4_nt4v152Ev
  virtual void  v153(); // _ZN9S685C4_nt4v153Ev
  virtual void  v154(); // _ZN9S685C4_nt4v154Ev
  virtual void  v155(); // _ZN9S685C4_nt4v155Ev
  virtual void  v156(); // _ZN9S685C4_nt4v156Ev
  virtual void  v157(); // _ZN9S685C4_nt4v157Ev
  virtual void  v158(); // _ZN9S685C4_nt4v158Ev
  virtual void  v159(); // _ZN9S685C4_nt4v159Ev
  virtual void  v160(); // _ZN9S685C4_nt4v160Ev
  virtual void  v161(); // _ZN9S685C4_nt4v161Ev
  virtual void  v162(); // _ZN9S685C4_nt4v162Ev
  virtual void  v163(); // _ZN9S685C4_nt4v163Ev
  virtual void  v164(); // _ZN9S685C4_nt4v164Ev
  virtual void  v165(); // _ZN9S685C4_nt4v165Ev
  virtual void  v166(); // _ZN9S685C4_nt4v166Ev
  virtual void  v167(); // _ZN9S685C4_nt4v167Ev
  virtual void  v168(); // _ZN9S685C4_nt4v168Ev
  virtual void  v169(); // _ZN9S685C4_nt4v169Ev
  virtual void  v170(); // _ZN9S685C4_nt4v170Ev
  virtual void  v171(); // _ZN9S685C4_nt4v171Ev
  virtual void  v172(); // _ZN9S685C4_nt4v172Ev
  virtual void  v173(); // _ZN9S685C4_nt4v173Ev
  virtual void  v174(); // _ZN9S685C4_nt4v174Ev
  virtual void  v175(); // _ZN9S685C4_nt4v175Ev
  virtual void  v176(); // _ZN9S685C4_nt4v176Ev
  virtual void  v177(); // _ZN9S685C4_nt4v177Ev
  virtual void  v178(); // _ZN9S685C4_nt4v178Ev
  virtual void  v179(); // _ZN9S685C4_nt4v179Ev
  virtual void  v180(); // _ZN9S685C4_nt4v180Ev
  virtual void  v181(); // _ZN9S685C4_nt4v181Ev
  virtual void  v182(); // _ZN9S685C4_nt4v182Ev
  virtual void  v183(); // _ZN9S685C4_nt4v183Ev
  virtual void  v184(); // _ZN9S685C4_nt4v184Ev
  virtual void  v185(); // _ZN9S685C4_nt4v185Ev
  virtual void  v186(); // _ZN9S685C4_nt4v186Ev
  virtual void  v187(); // _ZN9S685C4_nt4v187Ev
  virtual void  v188(); // _ZN9S685C4_nt4v188Ev
  virtual void  v189(); // _ZN9S685C4_nt4v189Ev
  virtual void  v190(); // _ZN9S685C4_nt4v190Ev
  virtual void  v191(); // _ZN9S685C4_nt4v191Ev
  virtual void  v192(); // _ZN9S685C4_nt4v192Ev
  virtual void  v193(); // _ZN9S685C4_nt4v193Ev
  virtual void  v194(); // _ZN9S685C4_nt4v194Ev
  virtual void  v195(); // _ZN9S685C4_nt4v195Ev
  virtual void  v196(); // _ZN9S685C4_nt4v196Ev
  virtual void  v197(); // _ZN9S685C4_nt4v197Ev
  virtual void  v198(); // _ZN9S685C4_nt4v198Ev
  virtual void  v199(); // _ZN9S685C4_nt4v199Ev
  virtual void  v200(); // _ZN9S685C4_nt4v200Ev
  virtual void  v201(); // _ZN9S685C4_nt4v201Ev
  virtual void  v202(); // _ZN9S685C4_nt4v202Ev
  virtual void  v203(); // _ZN9S685C4_nt4v203Ev
  virtual void  v204(); // _ZN9S685C4_nt4v204Ev
  virtual void  v205(); // _ZN9S685C4_nt4v205Ev
  virtual void  v206(); // _ZN9S685C4_nt4v206Ev
  virtual void  v207(); // _ZN9S685C4_nt4v207Ev
  virtual void  v208(); // _ZN9S685C4_nt4v208Ev
  virtual void  v209(); // _ZN9S685C4_nt4v209Ev
  virtual void  v210(); // _ZN9S685C4_nt4v210Ev
  virtual void  v211(); // _ZN9S685C4_nt4v211Ev
  virtual void  v212(); // _ZN9S685C4_nt4v212Ev
  virtual void  v213(); // _ZN9S685C4_nt4v213Ev
  S685C4_nt(); // tgen
};
//SIG(-1 S685C4_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S685C4_nt ::~S685C4_nt(){ note_dtor("S685C4_nt", this);}
void  S685C4_nt ::v71(){vfunc_called(this, "_ZN9S685C4_nt3v71Ev");}
void  S685C4_nt ::v72(){vfunc_called(this, "_ZN9S685C4_nt3v72Ev");}
void  S685C4_nt ::v73(){vfunc_called(this, "_ZN9S685C4_nt3v73Ev");}
void  S685C4_nt ::v74(){vfunc_called(this, "_ZN9S685C4_nt3v74Ev");}
void  S685C4_nt ::v75(){vfunc_called(this, "_ZN9S685C4_nt3v75Ev");}
void  S685C4_nt ::v76(){vfunc_called(this, "_ZN9S685C4_nt3v76Ev");}
void  S685C4_nt ::v77(){vfunc_called(this, "_ZN9S685C4_nt3v77Ev");}
void  S685C4_nt ::v78(){vfunc_called(this, "_ZN9S685C4_nt3v78Ev");}
void  S685C4_nt ::v79(){vfunc_called(this, "_ZN9S685C4_nt3v79Ev");}
void  S685C4_nt ::v80(){vfunc_called(this, "_ZN9S685C4_nt3v80Ev");}
void  S685C4_nt ::v81(){vfunc_called(this, "_ZN9S685C4_nt3v81Ev");}
void  S685C4_nt ::v82(){vfunc_called(this, "_ZN9S685C4_nt3v82Ev");}
void  S685C4_nt ::v83(){vfunc_called(this, "_ZN9S685C4_nt3v83Ev");}
void  S685C4_nt ::v84(){vfunc_called(this, "_ZN9S685C4_nt3v84Ev");}
void  S685C4_nt ::v85(){vfunc_called(this, "_ZN9S685C4_nt3v85Ev");}
void  S685C4_nt ::v86(){vfunc_called(this, "_ZN9S685C4_nt3v86Ev");}
void  S685C4_nt ::v87(){vfunc_called(this, "_ZN9S685C4_nt3v87Ev");}
void  S685C4_nt ::v88(){vfunc_called(this, "_ZN9S685C4_nt3v88Ev");}
void  S685C4_nt ::v89(){vfunc_called(this, "_ZN9S685C4_nt3v89Ev");}
void  S685C4_nt ::v90(){vfunc_called(this, "_ZN9S685C4_nt3v90Ev");}
void  S685C4_nt ::v91(){vfunc_called(this, "_ZN9S685C4_nt3v91Ev");}
void  S685C4_nt ::v92(){vfunc_called(this, "_ZN9S685C4_nt3v92Ev");}
void  S685C4_nt ::v93(){vfunc_called(this, "_ZN9S685C4_nt3v93Ev");}
void  S685C4_nt ::v94(){vfunc_called(this, "_ZN9S685C4_nt3v94Ev");}
void  S685C4_nt ::v95(){vfunc_called(this, "_ZN9S685C4_nt3v95Ev");}
void  S685C4_nt ::v96(){vfunc_called(this, "_ZN9S685C4_nt3v96Ev");}
void  S685C4_nt ::v97(){vfunc_called(this, "_ZN9S685C4_nt3v97Ev");}
void  S685C4_nt ::v98(){vfunc_called(this, "_ZN9S685C4_nt3v98Ev");}
void  S685C4_nt ::v99(){vfunc_called(this, "_ZN9S685C4_nt3v99Ev");}
void  S685C4_nt ::v100(){vfunc_called(this, "_ZN9S685C4_nt4v100Ev");}
void  S685C4_nt ::v101(){vfunc_called(this, "_ZN9S685C4_nt4v101Ev");}
void  S685C4_nt ::v102(){vfunc_called(this, "_ZN9S685C4_nt4v102Ev");}
void  S685C4_nt ::v103(){vfunc_called(this, "_ZN9S685C4_nt4v103Ev");}
void  S685C4_nt ::v104(){vfunc_called(this, "_ZN9S685C4_nt4v104Ev");}
void  S685C4_nt ::v105(){vfunc_called(this, "_ZN9S685C4_nt4v105Ev");}
void  S685C4_nt ::v106(){vfunc_called(this, "_ZN9S685C4_nt4v106Ev");}
void  S685C4_nt ::v107(){vfunc_called(this, "_ZN9S685C4_nt4v107Ev");}
void  S685C4_nt ::v108(){vfunc_called(this, "_ZN9S685C4_nt4v108Ev");}
void  S685C4_nt ::v109(){vfunc_called(this, "_ZN9S685C4_nt4v109Ev");}
void  S685C4_nt ::v110(){vfunc_called(this, "_ZN9S685C4_nt4v110Ev");}
void  S685C4_nt ::v111(){vfunc_called(this, "_ZN9S685C4_nt4v111Ev");}
void  S685C4_nt ::v112(){vfunc_called(this, "_ZN9S685C4_nt4v112Ev");}
void  S685C4_nt ::v113(){vfunc_called(this, "_ZN9S685C4_nt4v113Ev");}
void  S685C4_nt ::v114(){vfunc_called(this, "_ZN9S685C4_nt4v114Ev");}
void  S685C4_nt ::v115(){vfunc_called(this, "_ZN9S685C4_nt4v115Ev");}
void  S685C4_nt ::v116(){vfunc_called(this, "_ZN9S685C4_nt4v116Ev");}
void  S685C4_nt ::v117(){vfunc_called(this, "_ZN9S685C4_nt4v117Ev");}
void  S685C4_nt ::v118(){vfunc_called(this, "_ZN9S685C4_nt4v118Ev");}
void  S685C4_nt ::v119(){vfunc_called(this, "_ZN9S685C4_nt4v119Ev");}
void  S685C4_nt ::v120(){vfunc_called(this, "_ZN9S685C4_nt4v120Ev");}
void  S685C4_nt ::v121(){vfunc_called(this, "_ZN9S685C4_nt4v121Ev");}
void  S685C4_nt ::v122(){vfunc_called(this, "_ZN9S685C4_nt4v122Ev");}
void  S685C4_nt ::v123(){vfunc_called(this, "_ZN9S685C4_nt4v123Ev");}
void  S685C4_nt ::v124(){vfunc_called(this, "_ZN9S685C4_nt4v124Ev");}
void  S685C4_nt ::v125(){vfunc_called(this, "_ZN9S685C4_nt4v125Ev");}
void  S685C4_nt ::v126(){vfunc_called(this, "_ZN9S685C4_nt4v126Ev");}
void  S685C4_nt ::v127(){vfunc_called(this, "_ZN9S685C4_nt4v127Ev");}
void  S685C4_nt ::v128(){vfunc_called(this, "_ZN9S685C4_nt4v128Ev");}
void  S685C4_nt ::v129(){vfunc_called(this, "_ZN9S685C4_nt4v129Ev");}
void  S685C4_nt ::v130(){vfunc_called(this, "_ZN9S685C4_nt4v130Ev");}
void  S685C4_nt ::v131(){vfunc_called(this, "_ZN9S685C4_nt4v131Ev");}
void  S685C4_nt ::v132(){vfunc_called(this, "_ZN9S685C4_nt4v132Ev");}
void  S685C4_nt ::v133(){vfunc_called(this, "_ZN9S685C4_nt4v133Ev");}
void  S685C4_nt ::v134(){vfunc_called(this, "_ZN9S685C4_nt4v134Ev");}
void  S685C4_nt ::v135(){vfunc_called(this, "_ZN9S685C4_nt4v135Ev");}
void  S685C4_nt ::v136(){vfunc_called(this, "_ZN9S685C4_nt4v136Ev");}
void  S685C4_nt ::v137(){vfunc_called(this, "_ZN9S685C4_nt4v137Ev");}
void  S685C4_nt ::v138(){vfunc_called(this, "_ZN9S685C4_nt4v138Ev");}
void  S685C4_nt ::v139(){vfunc_called(this, "_ZN9S685C4_nt4v139Ev");}
void  S685C4_nt ::v140(){vfunc_called(this, "_ZN9S685C4_nt4v140Ev");}
void  S685C4_nt ::v141(){vfunc_called(this, "_ZN9S685C4_nt4v141Ev");}
void  S685C4_nt ::v142(){vfunc_called(this, "_ZN9S685C4_nt4v142Ev");}
void  S685C4_nt ::v143(){vfunc_called(this, "_ZN9S685C4_nt4v143Ev");}
void  S685C4_nt ::v144(){vfunc_called(this, "_ZN9S685C4_nt4v144Ev");}
void  S685C4_nt ::v145(){vfunc_called(this, "_ZN9S685C4_nt4v145Ev");}
void  S685C4_nt ::v146(){vfunc_called(this, "_ZN9S685C4_nt4v146Ev");}
void  S685C4_nt ::v147(){vfunc_called(this, "_ZN9S685C4_nt4v147Ev");}
void  S685C4_nt ::v148(){vfunc_called(this, "_ZN9S685C4_nt4v148Ev");}
void  S685C4_nt ::v149(){vfunc_called(this, "_ZN9S685C4_nt4v149Ev");}
void  S685C4_nt ::v150(){vfunc_called(this, "_ZN9S685C4_nt4v150Ev");}
void  S685C4_nt ::v151(){vfunc_called(this, "_ZN9S685C4_nt4v151Ev");}
void  S685C4_nt ::v152(){vfunc_called(this, "_ZN9S685C4_nt4v152Ev");}
void  S685C4_nt ::v153(){vfunc_called(this, "_ZN9S685C4_nt4v153Ev");}
void  S685C4_nt ::v154(){vfunc_called(this, "_ZN9S685C4_nt4v154Ev");}
void  S685C4_nt ::v155(){vfunc_called(this, "_ZN9S685C4_nt4v155Ev");}
void  S685C4_nt ::v156(){vfunc_called(this, "_ZN9S685C4_nt4v156Ev");}
void  S685C4_nt ::v157(){vfunc_called(this, "_ZN9S685C4_nt4v157Ev");}
void  S685C4_nt ::v158(){vfunc_called(this, "_ZN9S685C4_nt4v158Ev");}
void  S685C4_nt ::v159(){vfunc_called(this, "_ZN9S685C4_nt4v159Ev");}
void  S685C4_nt ::v160(){vfunc_called(this, "_ZN9S685C4_nt4v160Ev");}
void  S685C4_nt ::v161(){vfunc_called(this, "_ZN9S685C4_nt4v161Ev");}
void  S685C4_nt ::v162(){vfunc_called(this, "_ZN9S685C4_nt4v162Ev");}
void  S685C4_nt ::v163(){vfunc_called(this, "_ZN9S685C4_nt4v163Ev");}
void  S685C4_nt ::v164(){vfunc_called(this, "_ZN9S685C4_nt4v164Ev");}
void  S685C4_nt ::v165(){vfunc_called(this, "_ZN9S685C4_nt4v165Ev");}
void  S685C4_nt ::v166(){vfunc_called(this, "_ZN9S685C4_nt4v166Ev");}
void  S685C4_nt ::v167(){vfunc_called(this, "_ZN9S685C4_nt4v167Ev");}
void  S685C4_nt ::v168(){vfunc_called(this, "_ZN9S685C4_nt4v168Ev");}
void  S685C4_nt ::v169(){vfunc_called(this, "_ZN9S685C4_nt4v169Ev");}
void  S685C4_nt ::v170(){vfunc_called(this, "_ZN9S685C4_nt4v170Ev");}
void  S685C4_nt ::v171(){vfunc_called(this, "_ZN9S685C4_nt4v171Ev");}
void  S685C4_nt ::v172(){vfunc_called(this, "_ZN9S685C4_nt4v172Ev");}
void  S685C4_nt ::v173(){vfunc_called(this, "_ZN9S685C4_nt4v173Ev");}
void  S685C4_nt ::v174(){vfunc_called(this, "_ZN9S685C4_nt4v174Ev");}
void  S685C4_nt ::v175(){vfunc_called(this, "_ZN9S685C4_nt4v175Ev");}
void  S685C4_nt ::v176(){vfunc_called(this, "_ZN9S685C4_nt4v176Ev");}
void  S685C4_nt ::v177(){vfunc_called(this, "_ZN9S685C4_nt4v177Ev");}
void  S685C4_nt ::v178(){vfunc_called(this, "_ZN9S685C4_nt4v178Ev");}
void  S685C4_nt ::v179(){vfunc_called(this, "_ZN9S685C4_nt4v179Ev");}
void  S685C4_nt ::v180(){vfunc_called(this, "_ZN9S685C4_nt4v180Ev");}
void  S685C4_nt ::v181(){vfunc_called(this, "_ZN9S685C4_nt4v181Ev");}
void  S685C4_nt ::v182(){vfunc_called(this, "_ZN9S685C4_nt4v182Ev");}
void  S685C4_nt ::v183(){vfunc_called(this, "_ZN9S685C4_nt4v183Ev");}
void  S685C4_nt ::v184(){vfunc_called(this, "_ZN9S685C4_nt4v184Ev");}
void  S685C4_nt ::v185(){vfunc_called(this, "_ZN9S685C4_nt4v185Ev");}
void  S685C4_nt ::v186(){vfunc_called(this, "_ZN9S685C4_nt4v186Ev");}
void  S685C4_nt ::v187(){vfunc_called(this, "_ZN9S685C4_nt4v187Ev");}
void  S685C4_nt ::v188(){vfunc_called(this, "_ZN9S685C4_nt4v188Ev");}
void  S685C4_nt ::v189(){vfunc_called(this, "_ZN9S685C4_nt4v189Ev");}
void  S685C4_nt ::v190(){vfunc_called(this, "_ZN9S685C4_nt4v190Ev");}
void  S685C4_nt ::v191(){vfunc_called(this, "_ZN9S685C4_nt4v191Ev");}
void  S685C4_nt ::v192(){vfunc_called(this, "_ZN9S685C4_nt4v192Ev");}
void  S685C4_nt ::v193(){vfunc_called(this, "_ZN9S685C4_nt4v193Ev");}
void  S685C4_nt ::v194(){vfunc_called(this, "_ZN9S685C4_nt4v194Ev");}
void  S685C4_nt ::v195(){vfunc_called(this, "_ZN9S685C4_nt4v195Ev");}
void  S685C4_nt ::v196(){vfunc_called(this, "_ZN9S685C4_nt4v196Ev");}
void  S685C4_nt ::v197(){vfunc_called(this, "_ZN9S685C4_nt4v197Ev");}
void  S685C4_nt ::v198(){vfunc_called(this, "_ZN9S685C4_nt4v198Ev");}
void  S685C4_nt ::v199(){vfunc_called(this, "_ZN9S685C4_nt4v199Ev");}
void  S685C4_nt ::v200(){vfunc_called(this, "_ZN9S685C4_nt4v200Ev");}
void  S685C4_nt ::v201(){vfunc_called(this, "_ZN9S685C4_nt4v201Ev");}
void  S685C4_nt ::v202(){vfunc_called(this, "_ZN9S685C4_nt4v202Ev");}
void  S685C4_nt ::v203(){vfunc_called(this, "_ZN9S685C4_nt4v203Ev");}
void  S685C4_nt ::v204(){vfunc_called(this, "_ZN9S685C4_nt4v204Ev");}
void  S685C4_nt ::v205(){vfunc_called(this, "_ZN9S685C4_nt4v205Ev");}
void  S685C4_nt ::v206(){vfunc_called(this, "_ZN9S685C4_nt4v206Ev");}
void  S685C4_nt ::v207(){vfunc_called(this, "_ZN9S685C4_nt4v207Ev");}
void  S685C4_nt ::v208(){vfunc_called(this, "_ZN9S685C4_nt4v208Ev");}
void  S685C4_nt ::v209(){vfunc_called(this, "_ZN9S685C4_nt4v209Ev");}
void  S685C4_nt ::v210(){vfunc_called(this, "_ZN9S685C4_nt4v210Ev");}
void  S685C4_nt ::v211(){vfunc_called(this, "_ZN9S685C4_nt4v211Ev");}
void  S685C4_nt ::v212(){vfunc_called(this, "_ZN9S685C4_nt4v212Ev");}
void  S685C4_nt ::v213(){vfunc_called(this, "_ZN9S685C4_nt4v213Ev");}
S685C4_nt ::S685C4_nt(){ note_ctor("S685C4_nt", this);} // tgen

//skip512 S685C4_nt

#else // __cplusplus

extern void _ZN9S685C4_ntC1Ev();
extern void _ZN9S685C4_ntD1Ev();
Name_Map name_map_S685C4_nt[] = {
  NSPAIR(_ZN9S685C4_ntC1Ev),
  NSPAIR(_ZN9S685C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C5_nt;
extern VTBL_ENTRY _ZTI9S685C5_nt[];
extern  VTBL_ENTRY _ZTV9S685C5_nt[];
static Base_Class bases_S685C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S685C4_nt[];
extern void _ZN9S685C4_ntD1Ev();
extern void _ZN9S685C4_ntD0Ev();
extern void _ZN9S685C5_nt2v7Ev();
extern void _ZN9S685C5_nt2v8Ev();
extern void _ZN9S685C5_nt2v9Ev();
extern void _ZN9S685C5_nt3v10Ev();
extern void _ZN9S685C5_nt3v11Ev();
extern void _ZN9S685C5_nt3v12Ev();
extern void _ZN9S685C5_nt3v13Ev();
extern void _ZN9S685C5_nt3v14Ev();
extern void _ZN9S685C5_nt3v15Ev();
extern void _ZN9S685C5_nt3v16Ev();
extern void _ZN9S685C5_nt3v17Ev();
extern void _ZN9S685C5_nt3v18Ev();
extern void _ZN9S685C5_nt3v19Ev();
extern void _ZN9S685C5_nt3v20Ev();
extern void _ZN9S685C5_nt3v21Ev();
extern void _ZN9S685C5_nt3v22Ev();
extern void _ZN9S685C5_nt3v23Ev();
extern void _ZN9S685C5_nt3v24Ev();
extern void _ZN9S685C5_nt3v25Ev();
extern void _ZN9S685C5_nt3v26Ev();
extern void _ZN9S685C5_nt3v27Ev();
extern void _ZN9S685C5_nt3v28Ev();
extern void _ZN9S685C5_nt3v29Ev();
extern void _ZN9S685C5_nt3v30Ev();
extern void _ZN9S685C5_nt3v31Ev();
extern void _ZN9S685C5_nt3v32Ev();
extern void _ZN9S685C5_nt3v33Ev();
extern void _ZN9S685C5_nt3v34Ev();
extern void _ZN9S685C5_nt3v35Ev();
extern void _ZN9S685C5_nt3v36Ev();
extern void _ZN9S685C5_nt3v37Ev();
extern void _ZN9S685C5_nt3v38Ev();
extern void _ZN9S685C5_nt3v39Ev();
extern void _ZN9S685C5_nt3v40Ev();
extern void _ZN9S685C5_nt3v41Ev();
extern void _ZN9S685C5_nt3v42Ev();
extern void _ZN9S685C5_nt3v43Ev();
extern void _ZN9S685C5_nt3v44Ev();
extern void _ZN9S685C5_nt3v45Ev();
extern void _ZN9S685C5_nt3v46Ev();
extern void _ZN9S685C5_nt3v47Ev();
extern void _ZN9S685C5_nt3v48Ev();
extern void _ZN9S685C5_nt3v49Ev();
extern void _ZN9S685C5_nt3v50Ev();
extern void _ZN9S685C5_nt3v51Ev();
extern void _ZN9S685C5_nt3v52Ev();
extern void _ZN9S685C5_nt3v53Ev();
extern void _ZN9S685C5_nt3v54Ev();
extern void _ZN9S685C5_nt3v55Ev();
extern void _ZN9S685C5_nt3v56Ev();
extern void _ZN9S685C5_nt3v57Ev();
extern void _ZN9S685C5_nt3v58Ev();
extern void _ZN9S685C5_nt3v59Ev();
extern void _ZN9S685C5_nt3v60Ev();
extern void _ZN9S685C5_nt3v61Ev();
extern void _ZN9S685C5_nt3v62Ev();
extern void _ZN9S685C5_nt3v63Ev();
extern void _ZN9S685C5_nt3v64Ev();
extern void _ZN9S685C5_nt3v65Ev();
extern void _ZN9S685C5_nt3v66Ev();
extern void _ZN9S685C5_nt3v67Ev();
extern void _ZN9S685C5_nt3v68Ev();
extern void _ZN9S685C5_nt3v69Ev();
extern void _ZN9S685C5_nt3v70Ev();
extern void _ZN9S685C4_nt3v71Ev();
extern void _ZN9S685C4_nt3v72Ev();
extern void _ZN9S685C4_nt3v73Ev();
extern void _ZN9S685C4_nt3v74Ev();
extern void _ZN9S685C4_nt3v75Ev();
extern void _ZN9S685C4_nt3v76Ev();
extern void _ZN9S685C4_nt3v77Ev();
extern void _ZN9S685C4_nt3v78Ev();
extern void _ZN9S685C4_nt3v79Ev();
extern void _ZN9S685C4_nt3v80Ev();
extern void _ZN9S685C4_nt3v81Ev();
extern void _ZN9S685C4_nt3v82Ev();
extern void _ZN9S685C4_nt3v83Ev();
extern void _ZN9S685C4_nt3v84Ev();
extern void _ZN9S685C4_nt3v85Ev();
extern void _ZN9S685C4_nt3v86Ev();
extern void _ZN9S685C4_nt3v87Ev();
extern void _ZN9S685C4_nt3v88Ev();
extern void _ZN9S685C4_nt3v89Ev();
extern void _ZN9S685C4_nt3v90Ev();
extern void _ZN9S685C4_nt3v91Ev();
extern void _ZN9S685C4_nt3v92Ev();
extern void _ZN9S685C4_nt3v93Ev();
extern void _ZN9S685C4_nt3v94Ev();
extern void _ZN9S685C4_nt3v95Ev();
extern void _ZN9S685C4_nt3v96Ev();
extern void _ZN9S685C4_nt3v97Ev();
extern void _ZN9S685C4_nt3v98Ev();
extern void _ZN9S685C4_nt3v99Ev();
extern void _ZN9S685C4_nt4v100Ev();
extern void _ZN9S685C4_nt4v101Ev();
extern void _ZN9S685C4_nt4v102Ev();
extern void _ZN9S685C4_nt4v103Ev();
extern void _ZN9S685C4_nt4v104Ev();
extern void _ZN9S685C4_nt4v105Ev();
extern void _ZN9S685C4_nt4v106Ev();
extern void _ZN9S685C4_nt4v107Ev();
extern void _ZN9S685C4_nt4v108Ev();
extern void _ZN9S685C4_nt4v109Ev();
extern void _ZN9S685C4_nt4v110Ev();
extern void _ZN9S685C4_nt4v111Ev();
extern void _ZN9S685C4_nt4v112Ev();
extern void _ZN9S685C4_nt4v113Ev();
extern void _ZN9S685C4_nt4v114Ev();
extern void _ZN9S685C4_nt4v115Ev();
extern void _ZN9S685C4_nt4v116Ev();
extern void _ZN9S685C4_nt4v117Ev();
extern void _ZN9S685C4_nt4v118Ev();
extern void _ZN9S685C4_nt4v119Ev();
extern void _ZN9S685C4_nt4v120Ev();
extern void _ZN9S685C4_nt4v121Ev();
extern void _ZN9S685C4_nt4v122Ev();
extern void _ZN9S685C4_nt4v123Ev();
extern void _ZN9S685C4_nt4v124Ev();
extern void _ZN9S685C4_nt4v125Ev();
extern void _ZN9S685C4_nt4v126Ev();
extern void _ZN9S685C4_nt4v127Ev();
extern void _ZN9S685C4_nt4v128Ev();
extern void _ZN9S685C4_nt4v129Ev();
extern void _ZN9S685C4_nt4v130Ev();
extern void _ZN9S685C4_nt4v131Ev();
extern void _ZN9S685C4_nt4v132Ev();
extern void _ZN9S685C4_nt4v133Ev();
extern void _ZN9S685C4_nt4v134Ev();
extern void _ZN9S685C4_nt4v135Ev();
extern void _ZN9S685C4_nt4v136Ev();
extern void _ZN9S685C4_nt4v137Ev();
extern void _ZN9S685C4_nt4v138Ev();
extern void _ZN9S685C4_nt4v139Ev();
extern void _ZN9S685C4_nt4v140Ev();
extern void _ZN9S685C4_nt4v141Ev();
extern void _ZN9S685C4_nt4v142Ev();
extern void _ZN9S685C4_nt4v143Ev();
extern void _ZN9S685C4_nt4v144Ev();
extern void _ZN9S685C4_nt4v145Ev();
extern void _ZN9S685C4_nt4v146Ev();
extern void _ZN9S685C4_nt4v147Ev();
extern void _ZN9S685C4_nt4v148Ev();
extern void _ZN9S685C4_nt4v149Ev();
extern void _ZN9S685C4_nt4v150Ev();
extern void _ZN9S685C4_nt4v151Ev();
extern void _ZN9S685C4_nt4v152Ev();
extern void _ZN9S685C4_nt4v153Ev();
extern void _ZN9S685C4_nt4v154Ev();
extern void _ZN9S685C4_nt4v155Ev();
extern void _ZN9S685C4_nt4v156Ev();
extern void _ZN9S685C4_nt4v157Ev();
extern void _ZN9S685C4_nt4v158Ev();
extern void _ZN9S685C4_nt4v159Ev();
extern void _ZN9S685C4_nt4v160Ev();
extern void _ZN9S685C4_nt4v161Ev();
extern void _ZN9S685C4_nt4v162Ev();
extern void _ZN9S685C4_nt4v163Ev();
extern void _ZN9S685C4_nt4v164Ev();
extern void _ZN9S685C4_nt4v165Ev();
extern void _ZN9S685C4_nt4v166Ev();
extern void _ZN9S685C4_nt4v167Ev();
extern void _ZN9S685C4_nt4v168Ev();
extern void _ZN9S685C4_nt4v169Ev();
extern void _ZN9S685C4_nt4v170Ev();
extern void _ZN9S685C4_nt4v171Ev();
extern void _ZN9S685C4_nt4v172Ev();
extern void _ZN9S685C4_nt4v173Ev();
extern void _ZN9S685C4_nt4v174Ev();
extern void _ZN9S685C4_nt4v175Ev();
extern void _ZN9S685C4_nt4v176Ev();
extern void _ZN9S685C4_nt4v177Ev();
extern void _ZN9S685C4_nt4v178Ev();
extern void _ZN9S685C4_nt4v179Ev();
extern void _ZN9S685C4_nt4v180Ev();
extern void _ZN9S685C4_nt4v181Ev();
extern void _ZN9S685C4_nt4v182Ev();
extern void _ZN9S685C4_nt4v183Ev();
extern void _ZN9S685C4_nt4v184Ev();
extern void _ZN9S685C4_nt4v185Ev();
extern void _ZN9S685C4_nt4v186Ev();
extern void _ZN9S685C4_nt4v187Ev();
extern void _ZN9S685C4_nt4v188Ev();
extern void _ZN9S685C4_nt4v189Ev();
extern void _ZN9S685C4_nt4v190Ev();
extern void _ZN9S685C4_nt4v191Ev();
extern void _ZN9S685C4_nt4v192Ev();
extern void _ZN9S685C4_nt4v193Ev();
extern void _ZN9S685C4_nt4v194Ev();
extern void _ZN9S685C4_nt4v195Ev();
extern void _ZN9S685C4_nt4v196Ev();
extern void _ZN9S685C4_nt4v197Ev();
extern void _ZN9S685C4_nt4v198Ev();
extern void _ZN9S685C4_nt4v199Ev();
extern void _ZN9S685C4_nt4v200Ev();
extern void _ZN9S685C4_nt4v201Ev();
extern void _ZN9S685C4_nt4v202Ev();
extern void _ZN9S685C4_nt4v203Ev();
extern void _ZN9S685C4_nt4v204Ev();
extern void _ZN9S685C4_nt4v205Ev();
extern void _ZN9S685C4_nt4v206Ev();
extern void _ZN9S685C4_nt4v207Ev();
extern void _ZN9S685C4_nt4v208Ev();
extern void _ZN9S685C4_nt4v209Ev();
extern void _ZN9S685C4_nt4v210Ev();
extern void _ZN9S685C4_nt4v211Ev();
extern void _ZN9S685C4_nt4v212Ev();
extern void _ZN9S685C4_nt4v213Ev();
static  VTBL_ENTRY vtc_S685C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S685C4_nt[0]),
  (VTBL_ENTRY)&_ZN9S685C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN9S685C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v213Ev,
};
extern VTBL_ENTRY _ZTI9S685C4_nt[];
VTBL_ENTRY *P__ZTI9S685C4_nt = _ZTI9S685C4_nt; 
extern  VTBL_ENTRY _ZTV9S685C4_nt[];
Class_Descriptor cd_S685C4_nt = {  "S685C4_nt", // class name
  bases_S685C4_nt, 1,
  &(vtc_S685C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI9S685C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV9S685C4_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C23_nt  {
  void  mf685c23(); // _ZN10S685C23_nt8mf685c23Ev
};
//SIG(-1 S685C23_nt) C1{ m}


void  S685C23_nt ::mf685c23(){}

//skip512 S685C23_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S685C23_nt[];
VTBL_ENTRY *P__ZTI10S685C23_nt = _ZTI10S685C23_nt; 
Class_Descriptor cd_S685C23_nt = {  "S685C23_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S685C23_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C25  : S685C9_nt {
};
//SIG(-1 S685C25) C1{ BC2{ m Fp Fi[2]}}



static void Test_S685C25()
{
  extern Class_Descriptor cd_S685C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C25, buf);
    S685C25 &lv = *(new (buf) S685C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C25)");
    check_base_class_offset(lv, (S685C9_nt*), 0, "S685C25");
    test_class_info(&lv, &cd_S685C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C25(Test_S685C25, "S685C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
static Base_Class bases_S685C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C25 = {  "S685C25", // class name
  bases_S685C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C24  : S685C25 {
};
//SIG(-1 S685C24) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S685C24()
{
  extern Class_Descriptor cd_S685C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C24, buf);
    S685C24 &lv = *(new (buf) S685C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C24)");
    check_base_class_offset(lv, (S685C9_nt*)(S685C25*), 0, "S685C24");
    check_base_class_offset(lv, (S685C25*), 0, "S685C24");
    test_class_info(&lv, &cd_S685C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C24(Test_S685C24, "S685C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
extern Class_Descriptor cd_S685C25;
static Base_Class bases_S685C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C24 = {  "S685C24", // class name
  bases_S685C24, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C29  : S685C9_nt {
};
//SIG(-1 S685C29) C1{ BC2{ m Fp Fi[2]}}



static void Test_S685C29()
{
  extern Class_Descriptor cd_S685C29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C29, buf);
    S685C29 &lv = *(new (buf) S685C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C29)");
    check_base_class_offset(lv, (S685C9_nt*), 0, "S685C29");
    test_class_info(&lv, &cd_S685C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C29(Test_S685C29, "S685C29", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
static Base_Class bases_S685C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C29 = {  "S685C29", // class name
  bases_S685C29, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C28  : S685C29 {
};
//SIG(-1 S685C28) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S685C28()
{
  extern Class_Descriptor cd_S685C28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C28, buf);
    S685C28 &lv = *(new (buf) S685C28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C28)");
    check_base_class_offset(lv, (S685C9_nt*)(S685C29*), 0, "S685C28");
    check_base_class_offset(lv, (S685C29*), 0, "S685C28");
    test_class_info(&lv, &cd_S685C28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C28(Test_S685C28, "S685C28", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
extern Class_Descriptor cd_S685C29;
static Base_Class bases_S685C28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C28 = {  "S685C28", // class name
  bases_S685C28, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C27_nt  : S685C28 {
};
//SIG(-1 S685C27_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S685C27_nt

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
extern Class_Descriptor cd_S685C29;
extern Class_Descriptor cd_S685C28;
static Base_Class bases_S685C27_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S685C28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C26  {
  void *s685c26f0;
  ::S685C27_nt s685c26f1;
  int s685c26f2[4];
  ::S685C23_nt s685c26f3;
  int s685c26f4;
  void *s685c26f5;
  int s685c26f6[2];
  unsigned int s685c26f7:1;
  int s685c26f8;
  void *s685c26f9;
  void  mf685c26(); // _ZN7S685C268mf685c26Ev
};
//SIG(1 S685C26) C1{ m Fp FC2{ BC3{ BC4{ BC5{ m Fp Fi[2]}}}} Fi[4] FC6{ m} Fi Fp Fi[2] Fi:1 Fi Fp}


void  S685C26 ::mf685c26(){}

static void Test_S685C26()
{
  {
    init_simple_test("S685C26");
    static S685C26 lv;
    check2(sizeof(lv), ABISELECT(80,64), "sizeof(S685C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C26)");
    check_field_offset(lv, s685c26f0, 0, "S685C26.s685c26f0");
    check_field_offset(lv, s685c26f1, ABISELECT(8,4), "S685C26.s685c26f1");
    check_field_offset(lv, s685c26f2, ABISELECT(24,16), "S685C26.s685c26f2");
    check_field_offset(lv, s685c26f3, ABISELECT(40,32), "S685C26.s685c26f3");
    check_field_offset(lv, s685c26f4, ABISELECT(44,36), "S685C26.s685c26f4");
    check_field_offset(lv, s685c26f5, ABISELECT(48,40), "S685C26.s685c26f5");
    check_field_offset(lv, s685c26f6, ABISELECT(56,44), "S685C26.s685c26f6");
    set_bf_and_test(lv, s685c26f7, ABISELECT(64,52), 0, 1, 1, "S685C26");
    check_field_offset(lv, s685c26f8, ABISELECT(68,56), "S685C26.s685c26f8");
    check_field_offset(lv, s685c26f9, ABISELECT(72,60), "S685C26.s685c26f9");
  }
}
static Arrange_To_Call_Me vS685C26(Test_S685C26, "S685C26", ABISELECT(80,64));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C3  : S685C4_nt {
  ::S685C23_nt s685c3f0;
  ::S685C23_nt s685c3f1;
  ::S685C23_nt s685c3f2;
  void *s685c3f3[3];
  int s685c3f4;
  ::S685C23_nt s685c3f5;
  void *s685c3f6;
  unsigned int s685c3f7:1;
  unsigned int s685c3f8:1;
  unsigned int s685c3f9:1;
  unsigned int s685c3f10:1;
  unsigned int s685c3f11:1;
  unsigned int s685c3f12:1;
  int s685c3f13;
  ::S685C24 s685c3f14;
  ::S685C23_nt s685c3f15;
  int s685c3f16[4];
  ::S685C26 s685c3f17[8];
  int s685c3f18[2];
  void *s685c3f19;
  int s685c3f20[8];
  ::S685C24 s685c3f21;
  virtual  ~S685C3(); // _ZN6S685C3D1Ev
  virtual void  v214(); // _ZN6S685C34v214Ev
  virtual void  v215(); // _ZN6S685C34v215Ev
  S685C3(); // tgen
};
//SIG(-1 S685C3) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 FC14{ m} FC14 FC14 Fp[3] Fi FC14 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC15{ BC16{ BC7}} FC14 Fi[4] FC17{ m Fp FC18{ BC19{ BC20{ BC7}}} Fi[4] FC14 Fi Fp Fi[2] Fi:1 Fi Fp}[8] Fi[2] Fp Fi[8] FC15}


 S685C3 ::~S685C3(){ note_dtor("S685C3", this);}
void  S685C3 ::v214(){vfunc_called(this, "_ZN6S685C34v214Ev");}
void  S685C3 ::v215(){vfunc_called(this, "_ZN6S685C34v215Ev");}
S685C3 ::S685C3(){ note_ctor("S685C3", this);} // tgen

static void Test_S685C3()
{
  extern Class_Descriptor cd_S685C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(172,269)];
    init_test(&cd_S685C3, buf);
    S685C3 *dp, &lv = *(dp=new (buf) S685C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1368,1072), "sizeof(S685C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C3)");
    check_base_class_offset(lv, (S685C5_nt*)(S685C4_nt*), 0, "S685C3");
    check_base_class_offset(lv, (S685C4_nt*), 0, "S685C3");
    check_field_offset(lv, s685c3f0, ABISELECT(568,436), "S685C3.s685c3f0");
    check_field_offset(lv, s685c3f1, ABISELECT(569,437), "S685C3.s685c3f1");
    check_field_offset(lv, s685c3f2, ABISELECT(570,438), "S685C3.s685c3f2");
    check_field_offset(lv, s685c3f3, ABISELECT(576,440), "S685C3.s685c3f3");
    check_field_offset(lv, s685c3f4, ABISELECT(600,452), "S685C3.s685c3f4");
    check_field_offset(lv, s685c3f5, ABISELECT(604,456), "S685C3.s685c3f5");
    check_field_offset(lv, s685c3f6, ABISELECT(608,460), "S685C3.s685c3f6");
    set_bf_and_test(lv, s685c3f7, ABISELECT(616,464), 0, 1, 1, "S685C3");
    set_bf_and_test(lv, s685c3f8, ABISELECT(616,464), 1, 1, 1, "S685C3");
    set_bf_and_test(lv, s685c3f9, ABISELECT(616,464), 2, 1, 1, "S685C3");
    set_bf_and_test(lv, s685c3f10, ABISELECT(616,464), 3, 1, 1, "S685C3");
    set_bf_and_test(lv, s685c3f11, ABISELECT(616,464), 4, 1, 1, "S685C3");
    set_bf_and_test(lv, s685c3f12, ABISELECT(616,464), 5, 1, 1, "S685C3");
    check_field_offset(lv, s685c3f13, ABISELECT(620,468), "S685C3.s685c3f13");
    check_field_offset(lv, s685c3f14, ABISELECT(624,472), "S685C3.s685c3f14");
    check_field_offset(lv, s685c3f15, ABISELECT(640,484), "S685C3.s685c3f15");
    check_field_offset(lv, s685c3f16, ABISELECT(644,488), "S685C3.s685c3f16");
    check_field_offset(lv, s685c3f17, ABISELECT(664,504), "S685C3.s685c3f17");
    check_field_offset(lv, s685c3f18, ABISELECT(1304,1016), "S685C3.s685c3f18");
    check_field_offset(lv, s685c3f19, ABISELECT(1312,1024), "S685C3.s685c3f19");
    check_field_offset(lv, s685c3f20, ABISELECT(1320,1028), "S685C3.s685c3f20");
    check_field_offset(lv, s685c3f21, ABISELECT(1352,1060), "S685C3.s685c3f21");
    test_class_info(&lv, &cd_S685C3);
    dp->~S685C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C3(Test_S685C3, "S685C3", ABISELECT(1368,1072));

#else // __cplusplus

extern void _ZN6S685C3C1Ev();
extern void _ZN6S685C3D1Ev();
Name_Map name_map_S685C3[] = {
  NSPAIR(_ZN6S685C3C1Ev),
  NSPAIR(_ZN6S685C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C5_nt;
extern VTBL_ENTRY _ZTI9S685C5_nt[];
extern  VTBL_ENTRY _ZTV9S685C5_nt[];
extern Class_Descriptor cd_S685C4_nt;
extern VTBL_ENTRY _ZTI9S685C4_nt[];
extern  VTBL_ENTRY _ZTV9S685C4_nt[];
static Base_Class bases_S685C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S685C3[];
extern void _ZN6S685C3D1Ev();
extern void _ZN6S685C3D0Ev();
extern void _ZN9S685C5_nt2v7Ev();
extern void _ZN9S685C5_nt2v8Ev();
extern void _ZN9S685C5_nt2v9Ev();
extern void _ZN9S685C5_nt3v10Ev();
extern void _ZN9S685C5_nt3v11Ev();
extern void _ZN9S685C5_nt3v12Ev();
extern void _ZN9S685C5_nt3v13Ev();
extern void _ZN9S685C5_nt3v14Ev();
extern void _ZN9S685C5_nt3v15Ev();
extern void _ZN9S685C5_nt3v16Ev();
extern void _ZN9S685C5_nt3v17Ev();
extern void _ZN9S685C5_nt3v18Ev();
extern void _ZN9S685C5_nt3v19Ev();
extern void _ZN9S685C5_nt3v20Ev();
extern void _ZN9S685C5_nt3v21Ev();
extern void _ZN9S685C5_nt3v22Ev();
extern void _ZN9S685C5_nt3v23Ev();
extern void _ZN9S685C5_nt3v24Ev();
extern void _ZN9S685C5_nt3v25Ev();
extern void _ZN9S685C5_nt3v26Ev();
extern void _ZN9S685C5_nt3v27Ev();
extern void _ZN9S685C5_nt3v28Ev();
extern void _ZN9S685C5_nt3v29Ev();
extern void _ZN9S685C5_nt3v30Ev();
extern void _ZN9S685C5_nt3v31Ev();
extern void _ZN9S685C5_nt3v32Ev();
extern void _ZN9S685C5_nt3v33Ev();
extern void _ZN9S685C5_nt3v34Ev();
extern void _ZN9S685C5_nt3v35Ev();
extern void _ZN9S685C5_nt3v36Ev();
extern void _ZN9S685C5_nt3v37Ev();
extern void _ZN9S685C5_nt3v38Ev();
extern void _ZN9S685C5_nt3v39Ev();
extern void _ZN9S685C5_nt3v40Ev();
extern void _ZN9S685C5_nt3v41Ev();
extern void _ZN9S685C5_nt3v42Ev();
extern void _ZN9S685C5_nt3v43Ev();
extern void _ZN9S685C5_nt3v44Ev();
extern void _ZN9S685C5_nt3v45Ev();
extern void _ZN9S685C5_nt3v46Ev();
extern void _ZN9S685C5_nt3v47Ev();
extern void _ZN9S685C5_nt3v48Ev();
extern void _ZN9S685C5_nt3v49Ev();
extern void _ZN9S685C5_nt3v50Ev();
extern void _ZN9S685C5_nt3v51Ev();
extern void _ZN9S685C5_nt3v52Ev();
extern void _ZN9S685C5_nt3v53Ev();
extern void _ZN9S685C5_nt3v54Ev();
extern void _ZN9S685C5_nt3v55Ev();
extern void _ZN9S685C5_nt3v56Ev();
extern void _ZN9S685C5_nt3v57Ev();
extern void _ZN9S685C5_nt3v58Ev();
extern void _ZN9S685C5_nt3v59Ev();
extern void _ZN9S685C5_nt3v60Ev();
extern void _ZN9S685C5_nt3v61Ev();
extern void _ZN9S685C5_nt3v62Ev();
extern void _ZN9S685C5_nt3v63Ev();
extern void _ZN9S685C5_nt3v64Ev();
extern void _ZN9S685C5_nt3v65Ev();
extern void _ZN9S685C5_nt3v66Ev();
extern void _ZN9S685C5_nt3v67Ev();
extern void _ZN9S685C5_nt3v68Ev();
extern void _ZN9S685C5_nt3v69Ev();
extern void _ZN9S685C5_nt3v70Ev();
extern void _ZN9S685C4_nt3v71Ev();
extern void _ZN9S685C4_nt3v72Ev();
extern void _ZN9S685C4_nt3v73Ev();
extern void _ZN9S685C4_nt3v74Ev();
extern void _ZN9S685C4_nt3v75Ev();
extern void _ZN9S685C4_nt3v76Ev();
extern void _ZN9S685C4_nt3v77Ev();
extern void _ZN9S685C4_nt3v78Ev();
extern void _ZN9S685C4_nt3v79Ev();
extern void _ZN9S685C4_nt3v80Ev();
extern void _ZN9S685C4_nt3v81Ev();
extern void _ZN9S685C4_nt3v82Ev();
extern void _ZN9S685C4_nt3v83Ev();
extern void _ZN9S685C4_nt3v84Ev();
extern void _ZN9S685C4_nt3v85Ev();
extern void _ZN9S685C4_nt3v86Ev();
extern void _ZN9S685C4_nt3v87Ev();
extern void _ZN9S685C4_nt3v88Ev();
extern void _ZN9S685C4_nt3v89Ev();
extern void _ZN9S685C4_nt3v90Ev();
extern void _ZN9S685C4_nt3v91Ev();
extern void _ZN9S685C4_nt3v92Ev();
extern void _ZN9S685C4_nt3v93Ev();
extern void _ZN9S685C4_nt3v94Ev();
extern void _ZN9S685C4_nt3v95Ev();
extern void _ZN9S685C4_nt3v96Ev();
extern void _ZN9S685C4_nt3v97Ev();
extern void _ZN9S685C4_nt3v98Ev();
extern void _ZN9S685C4_nt3v99Ev();
extern void _ZN9S685C4_nt4v100Ev();
extern void _ZN9S685C4_nt4v101Ev();
extern void _ZN9S685C4_nt4v102Ev();
extern void _ZN9S685C4_nt4v103Ev();
extern void _ZN9S685C4_nt4v104Ev();
extern void _ZN9S685C4_nt4v105Ev();
extern void _ZN9S685C4_nt4v106Ev();
extern void _ZN9S685C4_nt4v107Ev();
extern void _ZN9S685C4_nt4v108Ev();
extern void _ZN9S685C4_nt4v109Ev();
extern void _ZN9S685C4_nt4v110Ev();
extern void _ZN9S685C4_nt4v111Ev();
extern void _ZN9S685C4_nt4v112Ev();
extern void _ZN9S685C4_nt4v113Ev();
extern void _ZN9S685C4_nt4v114Ev();
extern void _ZN9S685C4_nt4v115Ev();
extern void _ZN9S685C4_nt4v116Ev();
extern void _ZN9S685C4_nt4v117Ev();
extern void _ZN9S685C4_nt4v118Ev();
extern void _ZN9S685C4_nt4v119Ev();
extern void _ZN9S685C4_nt4v120Ev();
extern void _ZN9S685C4_nt4v121Ev();
extern void _ZN9S685C4_nt4v122Ev();
extern void _ZN9S685C4_nt4v123Ev();
extern void _ZN9S685C4_nt4v124Ev();
extern void _ZN9S685C4_nt4v125Ev();
extern void _ZN9S685C4_nt4v126Ev();
extern void _ZN9S685C4_nt4v127Ev();
extern void _ZN9S685C4_nt4v128Ev();
extern void _ZN9S685C4_nt4v129Ev();
extern void _ZN9S685C4_nt4v130Ev();
extern void _ZN9S685C4_nt4v131Ev();
extern void _ZN9S685C4_nt4v132Ev();
extern void _ZN9S685C4_nt4v133Ev();
extern void _ZN9S685C4_nt4v134Ev();
extern void _ZN9S685C4_nt4v135Ev();
extern void _ZN9S685C4_nt4v136Ev();
extern void _ZN9S685C4_nt4v137Ev();
extern void _ZN9S685C4_nt4v138Ev();
extern void _ZN9S685C4_nt4v139Ev();
extern void _ZN9S685C4_nt4v140Ev();
extern void _ZN9S685C4_nt4v141Ev();
extern void _ZN9S685C4_nt4v142Ev();
extern void _ZN9S685C4_nt4v143Ev();
extern void _ZN9S685C4_nt4v144Ev();
extern void _ZN9S685C4_nt4v145Ev();
extern void _ZN9S685C4_nt4v146Ev();
extern void _ZN9S685C4_nt4v147Ev();
extern void _ZN9S685C4_nt4v148Ev();
extern void _ZN9S685C4_nt4v149Ev();
extern void _ZN9S685C4_nt4v150Ev();
extern void _ZN9S685C4_nt4v151Ev();
extern void _ZN9S685C4_nt4v152Ev();
extern void _ZN9S685C4_nt4v153Ev();
extern void _ZN9S685C4_nt4v154Ev();
extern void _ZN9S685C4_nt4v155Ev();
extern void _ZN9S685C4_nt4v156Ev();
extern void _ZN9S685C4_nt4v157Ev();
extern void _ZN9S685C4_nt4v158Ev();
extern void _ZN9S685C4_nt4v159Ev();
extern void _ZN9S685C4_nt4v160Ev();
extern void _ZN9S685C4_nt4v161Ev();
extern void _ZN9S685C4_nt4v162Ev();
extern void _ZN9S685C4_nt4v163Ev();
extern void _ZN9S685C4_nt4v164Ev();
extern void _ZN9S685C4_nt4v165Ev();
extern void _ZN9S685C4_nt4v166Ev();
extern void _ZN9S685C4_nt4v167Ev();
extern void _ZN9S685C4_nt4v168Ev();
extern void _ZN9S685C4_nt4v169Ev();
extern void _ZN9S685C4_nt4v170Ev();
extern void _ZN9S685C4_nt4v171Ev();
extern void _ZN9S685C4_nt4v172Ev();
extern void _ZN9S685C4_nt4v173Ev();
extern void _ZN9S685C4_nt4v174Ev();
extern void _ZN9S685C4_nt4v175Ev();
extern void _ZN9S685C4_nt4v176Ev();
extern void _ZN9S685C4_nt4v177Ev();
extern void _ZN9S685C4_nt4v178Ev();
extern void _ZN9S685C4_nt4v179Ev();
extern void _ZN9S685C4_nt4v180Ev();
extern void _ZN9S685C4_nt4v181Ev();
extern void _ZN9S685C4_nt4v182Ev();
extern void _ZN9S685C4_nt4v183Ev();
extern void _ZN9S685C4_nt4v184Ev();
extern void _ZN9S685C4_nt4v185Ev();
extern void _ZN9S685C4_nt4v186Ev();
extern void _ZN9S685C4_nt4v187Ev();
extern void _ZN9S685C4_nt4v188Ev();
extern void _ZN9S685C4_nt4v189Ev();
extern void _ZN9S685C4_nt4v190Ev();
extern void _ZN9S685C4_nt4v191Ev();
extern void _ZN9S685C4_nt4v192Ev();
extern void _ZN9S685C4_nt4v193Ev();
extern void _ZN9S685C4_nt4v194Ev();
extern void _ZN9S685C4_nt4v195Ev();
extern void _ZN9S685C4_nt4v196Ev();
extern void _ZN9S685C4_nt4v197Ev();
extern void _ZN9S685C4_nt4v198Ev();
extern void _ZN9S685C4_nt4v199Ev();
extern void _ZN9S685C4_nt4v200Ev();
extern void _ZN9S685C4_nt4v201Ev();
extern void _ZN9S685C4_nt4v202Ev();
extern void _ZN9S685C4_nt4v203Ev();
extern void _ZN9S685C4_nt4v204Ev();
extern void _ZN9S685C4_nt4v205Ev();
extern void _ZN9S685C4_nt4v206Ev();
extern void _ZN9S685C4_nt4v207Ev();
extern void _ZN9S685C4_nt4v208Ev();
extern void _ZN9S685C4_nt4v209Ev();
extern void _ZN9S685C4_nt4v210Ev();
extern void _ZN9S685C4_nt4v211Ev();
extern void _ZN9S685C4_nt4v212Ev();
extern void _ZN9S685C4_nt4v213Ev();
extern void _ZN6S685C34v214Ev();
extern void _ZN6S685C34v215Ev();
static  VTBL_ENTRY vtc_S685C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S685C3[0]),
  (VTBL_ENTRY)&_ZN6S685C3D1Ev,
  (VTBL_ENTRY)&_ZN6S685C3D0Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN6S685C34v214Ev,
  (VTBL_ENTRY)&_ZN6S685C34v215Ev,
};
extern VTBL_ENTRY _ZTI6S685C3[];
extern  VTBL_ENTRY _ZTV6S685C3[];
Class_Descriptor cd_S685C3 = {  "S685C3", // class name
  bases_S685C3, 2,
  &(vtc_S685C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1368,1072), // object size
  NSPAIRA(_ZTI6S685C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S685C3),213, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C2  : S685C3 {
  int s685c2f0[3];
  ::S685C27_nt s685c2f1;
  ::S685C27_nt s685c2f2;
  virtual  ~S685C2(); // _ZN6S685C2D1Ev
  virtual void  v216(); // _ZN6S685C24v216Ev
  virtual void  v217(); // _ZN6S685C24v217Ev
  S685C2(); // tgen
};
//SIG(-1 S685C2) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v210 v211 FC15{ m} FC15 FC15 Fp[3] Fi FC15 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC16{ BC17{ BC8}} FC15 Fi[4] FC18{ m Fp FC19{ BC20{ BC21{ BC8}}} Fi[4] FC15 Fi Fp Fi[2] Fi:1 Fi Fp}[8] Fi[2] Fp Fi[8] FC16} vd v1 v2 Fi[3] FC19 FC19}


 S685C2 ::~S685C2(){ note_dtor("S685C2", this);}
void  S685C2 ::v216(){vfunc_called(this, "_ZN6S685C24v216Ev");}
void  S685C2 ::v217(){vfunc_called(this, "_ZN6S685C24v217Ev");}
S685C2 ::S685C2(){ note_ctor("S685C2", this);} // tgen

static void Test_S685C2()
{
  extern Class_Descriptor cd_S685C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(178,278)];
    init_test(&cd_S685C2, buf);
    S685C2 *dp, &lv = *(dp=new (buf) S685C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1416,1108), "sizeof(S685C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C2)");
    check_base_class_offset(lv, (S685C5_nt*)(S685C4_nt*)(S685C3*), 0, "S685C2");
    check_base_class_offset(lv, (S685C4_nt*)(S685C3*), 0, "S685C2");
    check_base_class_offset(lv, (S685C3*), 0, "S685C2");
    check_field_offset(lv, s685c2f0, ABISELECT(1368,1072), "S685C2.s685c2f0");
    check_field_offset(lv, s685c2f1, ABISELECT(1384,1084), "S685C2.s685c2f1");
    check_field_offset(lv, s685c2f2, ABISELECT(1400,1096), "S685C2.s685c2f2");
    test_class_info(&lv, &cd_S685C2);
    dp->~S685C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C2(Test_S685C2, "S685C2", ABISELECT(1416,1108));

#else // __cplusplus

extern void _ZN6S685C2C1Ev();
extern void _ZN6S685C2D1Ev();
Name_Map name_map_S685C2[] = {
  NSPAIR(_ZN6S685C2C1Ev),
  NSPAIR(_ZN6S685C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C5_nt;
extern VTBL_ENTRY _ZTI9S685C5_nt[];
extern  VTBL_ENTRY _ZTV9S685C5_nt[];
extern Class_Descriptor cd_S685C4_nt;
extern VTBL_ENTRY _ZTI9S685C4_nt[];
extern  VTBL_ENTRY _ZTV9S685C4_nt[];
extern Class_Descriptor cd_S685C3;
extern VTBL_ENTRY _ZTI6S685C3[];
extern  VTBL_ENTRY _ZTV6S685C3[];
static Base_Class bases_S685C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S685C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S685C2[];
extern void _ZN6S685C2D1Ev();
extern void _ZN6S685C2D0Ev();
extern void _ZN9S685C5_nt2v7Ev();
extern void _ZN9S685C5_nt2v8Ev();
extern void _ZN9S685C5_nt2v9Ev();
extern void _ZN9S685C5_nt3v10Ev();
extern void _ZN9S685C5_nt3v11Ev();
extern void _ZN9S685C5_nt3v12Ev();
extern void _ZN9S685C5_nt3v13Ev();
extern void _ZN9S685C5_nt3v14Ev();
extern void _ZN9S685C5_nt3v15Ev();
extern void _ZN9S685C5_nt3v16Ev();
extern void _ZN9S685C5_nt3v17Ev();
extern void _ZN9S685C5_nt3v18Ev();
extern void _ZN9S685C5_nt3v19Ev();
extern void _ZN9S685C5_nt3v20Ev();
extern void _ZN9S685C5_nt3v21Ev();
extern void _ZN9S685C5_nt3v22Ev();
extern void _ZN9S685C5_nt3v23Ev();
extern void _ZN9S685C5_nt3v24Ev();
extern void _ZN9S685C5_nt3v25Ev();
extern void _ZN9S685C5_nt3v26Ev();
extern void _ZN9S685C5_nt3v27Ev();
extern void _ZN9S685C5_nt3v28Ev();
extern void _ZN9S685C5_nt3v29Ev();
extern void _ZN9S685C5_nt3v30Ev();
extern void _ZN9S685C5_nt3v31Ev();
extern void _ZN9S685C5_nt3v32Ev();
extern void _ZN9S685C5_nt3v33Ev();
extern void _ZN9S685C5_nt3v34Ev();
extern void _ZN9S685C5_nt3v35Ev();
extern void _ZN9S685C5_nt3v36Ev();
extern void _ZN9S685C5_nt3v37Ev();
extern void _ZN9S685C5_nt3v38Ev();
extern void _ZN9S685C5_nt3v39Ev();
extern void _ZN9S685C5_nt3v40Ev();
extern void _ZN9S685C5_nt3v41Ev();
extern void _ZN9S685C5_nt3v42Ev();
extern void _ZN9S685C5_nt3v43Ev();
extern void _ZN9S685C5_nt3v44Ev();
extern void _ZN9S685C5_nt3v45Ev();
extern void _ZN9S685C5_nt3v46Ev();
extern void _ZN9S685C5_nt3v47Ev();
extern void _ZN9S685C5_nt3v48Ev();
extern void _ZN9S685C5_nt3v49Ev();
extern void _ZN9S685C5_nt3v50Ev();
extern void _ZN9S685C5_nt3v51Ev();
extern void _ZN9S685C5_nt3v52Ev();
extern void _ZN9S685C5_nt3v53Ev();
extern void _ZN9S685C5_nt3v54Ev();
extern void _ZN9S685C5_nt3v55Ev();
extern void _ZN9S685C5_nt3v56Ev();
extern void _ZN9S685C5_nt3v57Ev();
extern void _ZN9S685C5_nt3v58Ev();
extern void _ZN9S685C5_nt3v59Ev();
extern void _ZN9S685C5_nt3v60Ev();
extern void _ZN9S685C5_nt3v61Ev();
extern void _ZN9S685C5_nt3v62Ev();
extern void _ZN9S685C5_nt3v63Ev();
extern void _ZN9S685C5_nt3v64Ev();
extern void _ZN9S685C5_nt3v65Ev();
extern void _ZN9S685C5_nt3v66Ev();
extern void _ZN9S685C5_nt3v67Ev();
extern void _ZN9S685C5_nt3v68Ev();
extern void _ZN9S685C5_nt3v69Ev();
extern void _ZN9S685C5_nt3v70Ev();
extern void _ZN9S685C4_nt3v71Ev();
extern void _ZN9S685C4_nt3v72Ev();
extern void _ZN9S685C4_nt3v73Ev();
extern void _ZN9S685C4_nt3v74Ev();
extern void _ZN9S685C4_nt3v75Ev();
extern void _ZN9S685C4_nt3v76Ev();
extern void _ZN9S685C4_nt3v77Ev();
extern void _ZN9S685C4_nt3v78Ev();
extern void _ZN9S685C4_nt3v79Ev();
extern void _ZN9S685C4_nt3v80Ev();
extern void _ZN9S685C4_nt3v81Ev();
extern void _ZN9S685C4_nt3v82Ev();
extern void _ZN9S685C4_nt3v83Ev();
extern void _ZN9S685C4_nt3v84Ev();
extern void _ZN9S685C4_nt3v85Ev();
extern void _ZN9S685C4_nt3v86Ev();
extern void _ZN9S685C4_nt3v87Ev();
extern void _ZN9S685C4_nt3v88Ev();
extern void _ZN9S685C4_nt3v89Ev();
extern void _ZN9S685C4_nt3v90Ev();
extern void _ZN9S685C4_nt3v91Ev();
extern void _ZN9S685C4_nt3v92Ev();
extern void _ZN9S685C4_nt3v93Ev();
extern void _ZN9S685C4_nt3v94Ev();
extern void _ZN9S685C4_nt3v95Ev();
extern void _ZN9S685C4_nt3v96Ev();
extern void _ZN9S685C4_nt3v97Ev();
extern void _ZN9S685C4_nt3v98Ev();
extern void _ZN9S685C4_nt3v99Ev();
extern void _ZN9S685C4_nt4v100Ev();
extern void _ZN9S685C4_nt4v101Ev();
extern void _ZN9S685C4_nt4v102Ev();
extern void _ZN9S685C4_nt4v103Ev();
extern void _ZN9S685C4_nt4v104Ev();
extern void _ZN9S685C4_nt4v105Ev();
extern void _ZN9S685C4_nt4v106Ev();
extern void _ZN9S685C4_nt4v107Ev();
extern void _ZN9S685C4_nt4v108Ev();
extern void _ZN9S685C4_nt4v109Ev();
extern void _ZN9S685C4_nt4v110Ev();
extern void _ZN9S685C4_nt4v111Ev();
extern void _ZN9S685C4_nt4v112Ev();
extern void _ZN9S685C4_nt4v113Ev();
extern void _ZN9S685C4_nt4v114Ev();
extern void _ZN9S685C4_nt4v115Ev();
extern void _ZN9S685C4_nt4v116Ev();
extern void _ZN9S685C4_nt4v117Ev();
extern void _ZN9S685C4_nt4v118Ev();
extern void _ZN9S685C4_nt4v119Ev();
extern void _ZN9S685C4_nt4v120Ev();
extern void _ZN9S685C4_nt4v121Ev();
extern void _ZN9S685C4_nt4v122Ev();
extern void _ZN9S685C4_nt4v123Ev();
extern void _ZN9S685C4_nt4v124Ev();
extern void _ZN9S685C4_nt4v125Ev();
extern void _ZN9S685C4_nt4v126Ev();
extern void _ZN9S685C4_nt4v127Ev();
extern void _ZN9S685C4_nt4v128Ev();
extern void _ZN9S685C4_nt4v129Ev();
extern void _ZN9S685C4_nt4v130Ev();
extern void _ZN9S685C4_nt4v131Ev();
extern void _ZN9S685C4_nt4v132Ev();
extern void _ZN9S685C4_nt4v133Ev();
extern void _ZN9S685C4_nt4v134Ev();
extern void _ZN9S685C4_nt4v135Ev();
extern void _ZN9S685C4_nt4v136Ev();
extern void _ZN9S685C4_nt4v137Ev();
extern void _ZN9S685C4_nt4v138Ev();
extern void _ZN9S685C4_nt4v139Ev();
extern void _ZN9S685C4_nt4v140Ev();
extern void _ZN9S685C4_nt4v141Ev();
extern void _ZN9S685C4_nt4v142Ev();
extern void _ZN9S685C4_nt4v143Ev();
extern void _ZN9S685C4_nt4v144Ev();
extern void _ZN9S685C4_nt4v145Ev();
extern void _ZN9S685C4_nt4v146Ev();
extern void _ZN9S685C4_nt4v147Ev();
extern void _ZN9S685C4_nt4v148Ev();
extern void _ZN9S685C4_nt4v149Ev();
extern void _ZN9S685C4_nt4v150Ev();
extern void _ZN9S685C4_nt4v151Ev();
extern void _ZN9S685C4_nt4v152Ev();
extern void _ZN9S685C4_nt4v153Ev();
extern void _ZN9S685C4_nt4v154Ev();
extern void _ZN9S685C4_nt4v155Ev();
extern void _ZN9S685C4_nt4v156Ev();
extern void _ZN9S685C4_nt4v157Ev();
extern void _ZN9S685C4_nt4v158Ev();
extern void _ZN9S685C4_nt4v159Ev();
extern void _ZN9S685C4_nt4v160Ev();
extern void _ZN9S685C4_nt4v161Ev();
extern void _ZN9S685C4_nt4v162Ev();
extern void _ZN9S685C4_nt4v163Ev();
extern void _ZN9S685C4_nt4v164Ev();
extern void _ZN9S685C4_nt4v165Ev();
extern void _ZN9S685C4_nt4v166Ev();
extern void _ZN9S685C4_nt4v167Ev();
extern void _ZN9S685C4_nt4v168Ev();
extern void _ZN9S685C4_nt4v169Ev();
extern void _ZN9S685C4_nt4v170Ev();
extern void _ZN9S685C4_nt4v171Ev();
extern void _ZN9S685C4_nt4v172Ev();
extern void _ZN9S685C4_nt4v173Ev();
extern void _ZN9S685C4_nt4v174Ev();
extern void _ZN9S685C4_nt4v175Ev();
extern void _ZN9S685C4_nt4v176Ev();
extern void _ZN9S685C4_nt4v177Ev();
extern void _ZN9S685C4_nt4v178Ev();
extern void _ZN9S685C4_nt4v179Ev();
extern void _ZN9S685C4_nt4v180Ev();
extern void _ZN9S685C4_nt4v181Ev();
extern void _ZN9S685C4_nt4v182Ev();
extern void _ZN9S685C4_nt4v183Ev();
extern void _ZN9S685C4_nt4v184Ev();
extern void _ZN9S685C4_nt4v185Ev();
extern void _ZN9S685C4_nt4v186Ev();
extern void _ZN9S685C4_nt4v187Ev();
extern void _ZN9S685C4_nt4v188Ev();
extern void _ZN9S685C4_nt4v189Ev();
extern void _ZN9S685C4_nt4v190Ev();
extern void _ZN9S685C4_nt4v191Ev();
extern void _ZN9S685C4_nt4v192Ev();
extern void _ZN9S685C4_nt4v193Ev();
extern void _ZN9S685C4_nt4v194Ev();
extern void _ZN9S685C4_nt4v195Ev();
extern void _ZN9S685C4_nt4v196Ev();
extern void _ZN9S685C4_nt4v197Ev();
extern void _ZN9S685C4_nt4v198Ev();
extern void _ZN9S685C4_nt4v199Ev();
extern void _ZN9S685C4_nt4v200Ev();
extern void _ZN9S685C4_nt4v201Ev();
extern void _ZN9S685C4_nt4v202Ev();
extern void _ZN9S685C4_nt4v203Ev();
extern void _ZN9S685C4_nt4v204Ev();
extern void _ZN9S685C4_nt4v205Ev();
extern void _ZN9S685C4_nt4v206Ev();
extern void _ZN9S685C4_nt4v207Ev();
extern void _ZN9S685C4_nt4v208Ev();
extern void _ZN9S685C4_nt4v209Ev();
extern void _ZN9S685C4_nt4v210Ev();
extern void _ZN9S685C4_nt4v211Ev();
extern void _ZN9S685C4_nt4v212Ev();
extern void _ZN9S685C4_nt4v213Ev();
extern void _ZN6S685C34v214Ev();
extern void _ZN6S685C34v215Ev();
extern void _ZN6S685C24v216Ev();
extern void _ZN6S685C24v217Ev();
static  VTBL_ENTRY vtc_S685C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S685C2[0]),
  (VTBL_ENTRY)&_ZN6S685C2D1Ev,
  (VTBL_ENTRY)&_ZN6S685C2D0Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN6S685C34v214Ev,
  (VTBL_ENTRY)&_ZN6S685C34v215Ev,
  (VTBL_ENTRY)&_ZN6S685C24v216Ev,
  (VTBL_ENTRY)&_ZN6S685C24v217Ev,
};
extern VTBL_ENTRY _ZTI6S685C2[];
extern  VTBL_ENTRY _ZTV6S685C2[];
Class_Descriptor cd_S685C2 = {  "S685C2", // class name
  bases_S685C2, 3,
  &(vtc_S685C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1416,1108), // object size
  NSPAIRA(_ZTI6S685C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S685C2),215, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C32_nt  {
  int s685c32f0[4];
  void  mf685c32(); // _ZN10S685C32_nt8mf685c32Ev
};
//SIG(-1 S685C32_nt) C1{ m Fi[4]}


void  S685C32_nt ::mf685c32(){}

//skip512 S685C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C35  : S685C9_nt {
};
//SIG(-1 S685C35) C1{ BC2{ m Fp Fi[2]}}



static void Test_S685C35()
{
  extern Class_Descriptor cd_S685C35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C35, buf);
    S685C35 &lv = *(new (buf) S685C35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C35)");
    check_base_class_offset(lv, (S685C9_nt*), 0, "S685C35");
    test_class_info(&lv, &cd_S685C35);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C35(Test_S685C35, "S685C35", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
static Base_Class bases_S685C35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C35 = {  "S685C35", // class name
  bases_S685C35, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C34  : S685C35 {
};
//SIG(-1 S685C34) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S685C34()
{
  extern Class_Descriptor cd_S685C34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C34, buf);
    S685C34 &lv = *(new (buf) S685C34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C34)");
    check_base_class_offset(lv, (S685C9_nt*)(S685C35*), 0, "S685C34");
    check_base_class_offset(lv, (S685C35*), 0, "S685C34");
    test_class_info(&lv, &cd_S685C34);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C34(Test_S685C34, "S685C34", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
extern Class_Descriptor cd_S685C35;
static Base_Class bases_S685C34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C35,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C34 = {  "S685C34", // class name
  bases_S685C34, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C40  : S685C9_nt {
};
//SIG(-1 S685C40) C1{ BC2{ m Fp Fi[2]}}



static void Test_S685C40()
{
  extern Class_Descriptor cd_S685C40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C40, buf);
    S685C40 &lv = *(new (buf) S685C40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C40)");
    check_base_class_offset(lv, (S685C9_nt*), 0, "S685C40");
    test_class_info(&lv, &cd_S685C40);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C40(Test_S685C40, "S685C40", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
static Base_Class bases_S685C40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C40 = {  "S685C40", // class name
  bases_S685C40, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C39  : S685C40 {
};
//SIG(-1 S685C39) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S685C39()
{
  extern Class_Descriptor cd_S685C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S685C39, buf);
    S685C39 &lv = *(new (buf) S685C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S685C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C39)");
    check_base_class_offset(lv, (S685C9_nt*)(S685C40*), 0, "S685C39");
    check_base_class_offset(lv, (S685C40*), 0, "S685C39");
    test_class_info(&lv, &cd_S685C39);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C39(Test_S685C39, "S685C39", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S685C9_nt;
extern Class_Descriptor cd_S685C40;
static Base_Class bases_S685C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S685C39 = {  "S685C39", // class name
  bases_S685C39, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S685C1  : S685C2 {
  void *s685c1f0;
  ::S685C13 s685c1f1;
  void *s685c1f2[2];
  ::S685C27_nt s685c1f3;
  void *s685c1f4;
  ::S685C32_nt s685c1f5;
  int s685c1f6;
  ::S685C32_nt s685c1f7;
  ::S685C23_nt s685c1f8;
  ::S685C23_nt s685c1f9;
  ::S685C23_nt s685c1f10;
  int s685c1f11[4];
  void *s685c1f12[4];
  unsigned int s685c1f13:1;
  unsigned int s685c1f14:1;
  unsigned int s685c1f15:1;
  unsigned int s685c1f16:1;
  unsigned int s685c1f17:1;
  unsigned int s685c1f18:1;
  unsigned int s685c1f19:1;
  unsigned int s685c1f20:1;
  unsigned int s685c1f21:1;
  unsigned int s685c1f22:1;
  unsigned int s685c1f23:1;
  unsigned int s685c1f24:1;
  unsigned int s685c1f25:1;
  unsigned int s685c1f26:1;
  unsigned int s685c1f27:1;
  unsigned int s685c1f28:1;
  unsigned int s685c1f29:1;
  unsigned int s685c1f30:1;
  unsigned int s685c1f31:1;
  unsigned int s685c1f32:1;
  unsigned int s685c1f33:1;
  unsigned int s685c1f34:1;
  unsigned int s685c1f35:1;
  unsigned int s685c1f36:1;
  unsigned int s685c1f37:1;
  unsigned int s685c1f38:1;
  unsigned int s685c1f39:1;
  unsigned int s685c1f40:1;
  void *s685c1f41;
  int s685c1f42[2];
  void *s685c1f43[2];
  ::S685C34 s685c1f44;
  void *s685c1f45[2];
  int s685c1f46[5];
  ::S685C6_nt s685c1f47;
  void *s685c1f48[2];
  int s685c1f49[5];
  ::S685C32_nt s685c1f50;
  ::S685C23_nt s685c1f51;
  ::S685C23_nt s685c1f52;
  int s685c1f53;
  void *s685c1f54[10];
  int s685c1f55[29];
  void *s685c1f56;
  int s685c1f57[7];
  ::S685C23_nt s685c1f58;
  ::S685C23_nt s685c1f59;
  void *s685c1f60;
  int s685c1f61;
  ::S685C27_nt s685c1f62;
  int s685c1f63;
  void *s685c1f64[3];
  int s685c1f65[4];
  ::S685C34 s685c1f66;
  void *s685c1f67;
  int s685c1f68;
  ::S685C6_nt s685c1f69;
  ::S685C6_nt s685c1f70;
  int s685c1f71;
  ::S685C32_nt s685c1f72;
  int s685c1f73;
  void *s685c1f74[2];
  ::S685C39 s685c1f75;
  void *s685c1f76;
  int s685c1f77[4];
  void *s685c1f78;
  ::S685C32_nt s685c1f79;
  void *s685c1f80;
  ::S685C32_nt s685c1f81;
  void *s685c1f82;
  ::S685C32_nt s685c1f83;
  void *s685c1f84;
  ::S685C6_nt s685c1f85;
  ::S685C6_nt s685c1f86;
  int s685c1f87[6];
  ::S685C6_nt s685c1f88;
  void *s685c1f89;
  int s685c1f90[2];
  ::S685C6_nt s685c1f91;
  ::S685C6_nt s685c1f92;
  int s685c1f93[2];
  ::S685C6_nt s685c1f94;
  int s685c1f95[2];
  ::S685C6_nt s685c1f96;
  int s685c1f97[4];
  ::S685C27_nt s685c1f98;
  ::S685C27_nt s685c1f99;
  ::S685C27_nt s685c1f100;
  ::S685C27_nt s685c1f101;
  ::S685C27_nt s685c1f102;
  ::S685C27_nt s685c1f103;
  ::S685C27_nt s685c1f104;
  ::S685C27_nt s685c1f105;
  ::S685C27_nt s685c1f106[4];
  int s685c1f107[3];
  ::S685C32_nt s685c1f108;
  ::S685C32_nt s685c1f109;
  ::S685C32_nt s685c1f110;
  ::S685C32_nt s685c1f111;
  ::S685C32_nt s685c1f112;
  ::S685C32_nt s685c1f113;
  virtual  ~S685C1(); // _ZN6S685C1D1Ev
  virtual void  v1(); // _ZN6S685C12v1Ev
  virtual void  v2(); // _ZN6S685C12v2Ev
  virtual void  v3(); // _ZN6S685C12v3Ev
  virtual void  v4(); // _ZN6S685C12v4Ev
  virtual void  v5(); // _ZN6S685C12v5Ev
  virtual void  v6(); // _ZN6S685C12v6Ev
  S685C1(); // tgen
};
//SIG(1 S685C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 v211 v212 v213 FC7{ BC8{ BC9{ m Fp Fi[2]}}} FC7 FC10{ m Fi} Fi Fc[4] Fp[2] FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC6 FC6 FC6 FC11{ BC12{ BC9}} FC11 Fi Fp[2] FC13{ m Fi[3]} FC13 FC13 FC13 Fp FC6 FC11 FC13 FC13 Fi FC13 FC13 Fp Fi Fc FC13 FC13 Fp Fi Fp FC11 FC14{ BC15{ BC9}} FC14} vd v214 v215 FC16{ m} FC16 FC16 Fp[3] Fi FC16 Fp Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC17{ BC18{ BC9}} FC16 Fi[4] FC19{ m Fp FC20{ BC21{ BC22{ BC9}}} Fi[4] FC16 Fi Fp Fi[2] Fi:1 Fi Fp}[8] Fi[2] Fp Fi[8] FC17} vd v216 v217 Fi[3] FC20 FC20} vd v1 v2 v3 v4 v5 v6 Fp FC11 Fp[2] FC20 Fp FC23{ m Fi[4]} Fi FC23 FC16 FC16 FC16 Fi[4] Fp[4] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp Fi[2] Fp[2] FC24{ BC25{ BC9}} Fp[2] Fi[5] FC6 Fp[2] Fi[5] FC23 FC16 FC16 Fi Fp[10] Fi[29] Fp Fi[7] FC16 FC16 Fp Fi FC20 Fi Fp[3] Fi[4] FC24 Fp Fi FC6 FC6 Fi FC23 Fi Fp[2] FC26{ BC27{ BC9}} Fp Fi[4] Fp FC23 Fp FC23 Fp FC23 Fp FC6 FC6 Fi[6] FC6 Fp Fi[2] FC6 FC6 Fi[2] FC6 Fi[2] FC6 Fi[4] FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20 FC20[4] Fi[3] FC23 FC23 FC23 FC23 FC23 FC23}


 S685C1 ::~S685C1(){ note_dtor("S685C1", this);}
void  S685C1 ::v1(){vfunc_called(this, "_ZN6S685C12v1Ev");}
void  S685C1 ::v2(){vfunc_called(this, "_ZN6S685C12v2Ev");}
void  S685C1 ::v3(){vfunc_called(this, "_ZN6S685C12v3Ev");}
void  S685C1 ::v4(){vfunc_called(this, "_ZN6S685C12v4Ev");}
void  S685C1 ::v5(){vfunc_called(this, "_ZN6S685C12v5Ev");}
void  S685C1 ::v6(){vfunc_called(this, "_ZN6S685C12v6Ev");}
S685C1 ::S685C1(){ note_ctor("S685C1", this);} // tgen

static void Test_S685C1()
{
  extern Class_Descriptor cd_S685C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(338,533)];
    init_test(&cd_S685C1, buf);
    S685C1 *dp, &lv = *(dp=new (buf) S685C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2696,2128), "sizeof(S685C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S685C1)");
    check_base_class_offset(lv, (S685C5_nt*)(S685C4_nt*)(S685C3*)(S685C2*), 0, "S685C1");
    check_base_class_offset(lv, (S685C4_nt*)(S685C3*)(S685C2*), 0, "S685C1");
    check_base_class_offset(lv, (S685C3*)(S685C2*), 0, "S685C1");
    check_base_class_offset(lv, (S685C2*), 0, "S685C1");
    check_field_offset(lv, s685c1f0, ABISELECT(1416,1108), "S685C1.s685c1f0");
    check_field_offset(lv, s685c1f1, ABISELECT(1424,1112), "S685C1.s685c1f1");
    check_field_offset(lv, s685c1f2, ABISELECT(1440,1124), "S685C1.s685c1f2");
    check_field_offset(lv, s685c1f3, ABISELECT(1456,1132), "S685C1.s685c1f3");
    check_field_offset(lv, s685c1f4, ABISELECT(1472,1144), "S685C1.s685c1f4");
    check_field_offset(lv, s685c1f5, ABISELECT(1480,1148), "S685C1.s685c1f5");
    check_field_offset(lv, s685c1f6, ABISELECT(1496,1164), "S685C1.s685c1f6");
    check_field_offset(lv, s685c1f7, ABISELECT(1500,1168), "S685C1.s685c1f7");
    check_field_offset(lv, s685c1f8, ABISELECT(1516,1184), "S685C1.s685c1f8");
    check_field_offset(lv, s685c1f9, ABISELECT(1517,1185), "S685C1.s685c1f9");
    check_field_offset(lv, s685c1f10, ABISELECT(1518,1186), "S685C1.s685c1f10");
    check_field_offset(lv, s685c1f11, ABISELECT(1520,1188), "S685C1.s685c1f11");
    check_field_offset(lv, s685c1f12, ABISELECT(1536,1204), "S685C1.s685c1f12");
    set_bf_and_test(lv, s685c1f13, ABISELECT(1568,1220), 0, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f14, ABISELECT(1568,1220), 1, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f15, ABISELECT(1568,1220), 2, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f16, ABISELECT(1568,1220), 3, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f17, ABISELECT(1568,1220), 4, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f18, ABISELECT(1568,1220), 5, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f19, ABISELECT(1568,1220), 6, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f20, ABISELECT(1568,1220), 7, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f21, ABISELECT(1569,1221), 0, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f22, ABISELECT(1569,1221), 1, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f23, ABISELECT(1569,1221), 2, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f24, ABISELECT(1569,1221), 3, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f25, ABISELECT(1569,1221), 4, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f26, ABISELECT(1569,1221), 5, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f27, ABISELECT(1569,1221), 6, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f28, ABISELECT(1569,1221), 7, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f29, ABISELECT(1570,1222), 0, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f30, ABISELECT(1570,1222), 1, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f31, ABISELECT(1570,1222), 2, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f32, ABISELECT(1570,1222), 3, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f33, ABISELECT(1570,1222), 4, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f34, ABISELECT(1570,1222), 5, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f35, ABISELECT(1570,1222), 6, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f36, ABISELECT(1570,1222), 7, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f37, ABISELECT(1571,1223), 0, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f38, ABISELECT(1571,1223), 1, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f39, ABISELECT(1571,1223), 2, 1, 1, "S685C1");
    set_bf_and_test(lv, s685c1f40, ABISELECT(1571,1223), 3, 1, 1, "S685C1");
    check_field_offset(lv, s685c1f41, ABISELECT(1576,1224), "S685C1.s685c1f41");
    check_field_offset(lv, s685c1f42, ABISELECT(1584,1228), "S685C1.s685c1f42");
    check_field_offset(lv, s685c1f43, ABISELECT(1592,1236), "S685C1.s685c1f43");
    check_field_offset(lv, s685c1f44, ABISELECT(1608,1244), "S685C1.s685c1f44");
    check_field_offset(lv, s685c1f45, ABISELECT(1624,1256), "S685C1.s685c1f45");
    check_field_offset(lv, s685c1f46, ABISELECT(1640,1264), "S685C1.s685c1f46");
    check_field_offset(lv, s685c1f47, ABISELECT(1660,1284), "S685C1.s685c1f47");
    check_field_offset(lv, s685c1f48, ABISELECT(1672,1292), "S685C1.s685c1f48");
    check_field_offset(lv, s685c1f49, ABISELECT(1688,1300), "S685C1.s685c1f49");
    check_field_offset(lv, s685c1f50, ABISELECT(1708,1320), "S685C1.s685c1f50");
    check_field_offset(lv, s685c1f51, ABISELECT(1724,1336), "S685C1.s685c1f51");
    check_field_offset(lv, s685c1f52, ABISELECT(1725,1337), "S685C1.s685c1f52");
    check_field_offset(lv, s685c1f53, ABISELECT(1728,1340), "S685C1.s685c1f53");
    check_field_offset(lv, s685c1f54, ABISELECT(1736,1344), "S685C1.s685c1f54");
    check_field_offset(lv, s685c1f55, ABISELECT(1816,1384), "S685C1.s685c1f55");
    check_field_offset(lv, s685c1f56, ABISELECT(1936,1500), "S685C1.s685c1f56");
    check_field_offset(lv, s685c1f57, ABISELECT(1944,1504), "S685C1.s685c1f57");
    check_field_offset(lv, s685c1f58, ABISELECT(1972,1532), "S685C1.s685c1f58");
    check_field_offset(lv, s685c1f59, ABISELECT(1973,1533), "S685C1.s685c1f59");
    check_field_offset(lv, s685c1f60, ABISELECT(1976,1536), "S685C1.s685c1f60");
    check_field_offset(lv, s685c1f61, ABISELECT(1984,1540), "S685C1.s685c1f61");
    check_field_offset(lv, s685c1f62, ABISELECT(1992,1544), "S685C1.s685c1f62");
    check_field_offset(lv, s685c1f63, ABISELECT(2008,1556), "S685C1.s685c1f63");
    check_field_offset(lv, s685c1f64, ABISELECT(2016,1560), "S685C1.s685c1f64");
    check_field_offset(lv, s685c1f65, ABISELECT(2040,1572), "S685C1.s685c1f65");
    check_field_offset(lv, s685c1f66, ABISELECT(2056,1588), "S685C1.s685c1f66");
    check_field_offset(lv, s685c1f67, ABISELECT(2072,1600), "S685C1.s685c1f67");
    check_field_offset(lv, s685c1f68, ABISELECT(2080,1604), "S685C1.s685c1f68");
    check_field_offset(lv, s685c1f69, ABISELECT(2084,1608), "S685C1.s685c1f69");
    check_field_offset(lv, s685c1f70, ABISELECT(2092,1616), "S685C1.s685c1f70");
    check_field_offset(lv, s685c1f71, ABISELECT(2100,1624), "S685C1.s685c1f71");
    check_field_offset(lv, s685c1f72, ABISELECT(2104,1628), "S685C1.s685c1f72");
    check_field_offset(lv, s685c1f73, ABISELECT(2120,1644), "S685C1.s685c1f73");
    check_field_offset(lv, s685c1f74, ABISELECT(2128,1648), "S685C1.s685c1f74");
    check_field_offset(lv, s685c1f75, ABISELECT(2144,1656), "S685C1.s685c1f75");
    check_field_offset(lv, s685c1f76, ABISELECT(2160,1668), "S685C1.s685c1f76");
    check_field_offset(lv, s685c1f77, ABISELECT(2168,1672), "S685C1.s685c1f77");
    check_field_offset(lv, s685c1f78, ABISELECT(2184,1688), "S685C1.s685c1f78");
    check_field_offset(lv, s685c1f79, ABISELECT(2192,1692), "S685C1.s685c1f79");
    check_field_offset(lv, s685c1f80, ABISELECT(2208,1708), "S685C1.s685c1f80");
    check_field_offset(lv, s685c1f81, ABISELECT(2216,1712), "S685C1.s685c1f81");
    check_field_offset(lv, s685c1f82, ABISELECT(2232,1728), "S685C1.s685c1f82");
    check_field_offset(lv, s685c1f83, ABISELECT(2240,1732), "S685C1.s685c1f83");
    check_field_offset(lv, s685c1f84, ABISELECT(2256,1748), "S685C1.s685c1f84");
    check_field_offset(lv, s685c1f85, ABISELECT(2264,1752), "S685C1.s685c1f85");
    check_field_offset(lv, s685c1f86, ABISELECT(2272,1760), "S685C1.s685c1f86");
    check_field_offset(lv, s685c1f87, ABISELECT(2280,1768), "S685C1.s685c1f87");
    check_field_offset(lv, s685c1f88, ABISELECT(2304,1792), "S685C1.s685c1f88");
    check_field_offset(lv, s685c1f89, ABISELECT(2312,1800), "S685C1.s685c1f89");
    check_field_offset(lv, s685c1f90, ABISELECT(2320,1804), "S685C1.s685c1f90");
    check_field_offset(lv, s685c1f91, ABISELECT(2328,1812), "S685C1.s685c1f91");
    check_field_offset(lv, s685c1f92, ABISELECT(2336,1820), "S685C1.s685c1f92");
    check_field_offset(lv, s685c1f93, ABISELECT(2344,1828), "S685C1.s685c1f93");
    check_field_offset(lv, s685c1f94, ABISELECT(2352,1836), "S685C1.s685c1f94");
    check_field_offset(lv, s685c1f95, ABISELECT(2360,1844), "S685C1.s685c1f95");
    check_field_offset(lv, s685c1f96, ABISELECT(2368,1852), "S685C1.s685c1f96");
    check_field_offset(lv, s685c1f97, ABISELECT(2376,1860), "S685C1.s685c1f97");
    check_field_offset(lv, s685c1f98, ABISELECT(2392,1876), "S685C1.s685c1f98");
    check_field_offset(lv, s685c1f99, ABISELECT(2408,1888), "S685C1.s685c1f99");
    check_field_offset(lv, s685c1f100, ABISELECT(2424,1900), "S685C1.s685c1f100");
    check_field_offset(lv, s685c1f101, ABISELECT(2440,1912), "S685C1.s685c1f101");
    check_field_offset(lv, s685c1f102, ABISELECT(2456,1924), "S685C1.s685c1f102");
    check_field_offset(lv, s685c1f103, ABISELECT(2472,1936), "S685C1.s685c1f103");
    check_field_offset(lv, s685c1f104, ABISELECT(2488,1948), "S685C1.s685c1f104");
    check_field_offset(lv, s685c1f105, ABISELECT(2504,1960), "S685C1.s685c1f105");
    check_field_offset(lv, s685c1f106, ABISELECT(2520,1972), "S685C1.s685c1f106");
    check_field_offset(lv, s685c1f107, ABISELECT(2584,2020), "S685C1.s685c1f107");
    check_field_offset(lv, s685c1f108, ABISELECT(2596,2032), "S685C1.s685c1f108");
    check_field_offset(lv, s685c1f109, ABISELECT(2612,2048), "S685C1.s685c1f109");
    check_field_offset(lv, s685c1f110, ABISELECT(2628,2064), "S685C1.s685c1f110");
    check_field_offset(lv, s685c1f111, ABISELECT(2644,2080), "S685C1.s685c1f111");
    check_field_offset(lv, s685c1f112, ABISELECT(2660,2096), "S685C1.s685c1f112");
    check_field_offset(lv, s685c1f113, ABISELECT(2676,2112), "S685C1.s685c1f113");
    test_class_info(&lv, &cd_S685C1);
    dp->~S685C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS685C1(Test_S685C1, "S685C1", ABISELECT(2696,2128));

#else // __cplusplus

extern void _ZN6S685C1C1Ev();
extern void _ZN6S685C1D1Ev();
Name_Map name_map_S685C1[] = {
  NSPAIR(_ZN6S685C1C1Ev),
  NSPAIR(_ZN6S685C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C5_nt;
extern VTBL_ENTRY _ZTI9S685C5_nt[];
extern  VTBL_ENTRY _ZTV9S685C5_nt[];
extern Class_Descriptor cd_S685C4_nt;
extern VTBL_ENTRY _ZTI9S685C4_nt[];
extern  VTBL_ENTRY _ZTV9S685C4_nt[];
extern Class_Descriptor cd_S685C3;
extern VTBL_ENTRY _ZTI6S685C3[];
extern  VTBL_ENTRY _ZTV6S685C3[];
extern Class_Descriptor cd_S685C2;
extern VTBL_ENTRY _ZTI6S685C2[];
extern  VTBL_ENTRY _ZTV6S685C2[];
static Base_Class bases_S685C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S685C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S685C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S685C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S685C1[];
extern void _ZN6S685C1D1Ev();
extern void _ZN6S685C1D0Ev();
extern void _ZN9S685C5_nt2v7Ev();
extern void _ZN9S685C5_nt2v8Ev();
extern void _ZN9S685C5_nt2v9Ev();
extern void _ZN9S685C5_nt3v10Ev();
extern void _ZN9S685C5_nt3v11Ev();
extern void _ZN9S685C5_nt3v12Ev();
extern void _ZN9S685C5_nt3v13Ev();
extern void _ZN9S685C5_nt3v14Ev();
extern void _ZN9S685C5_nt3v15Ev();
extern void _ZN9S685C5_nt3v16Ev();
extern void _ZN9S685C5_nt3v17Ev();
extern void _ZN9S685C5_nt3v18Ev();
extern void _ZN9S685C5_nt3v19Ev();
extern void _ZN9S685C5_nt3v20Ev();
extern void _ZN9S685C5_nt3v21Ev();
extern void _ZN9S685C5_nt3v22Ev();
extern void _ZN9S685C5_nt3v23Ev();
extern void _ZN9S685C5_nt3v24Ev();
extern void _ZN9S685C5_nt3v25Ev();
extern void _ZN9S685C5_nt3v26Ev();
extern void _ZN9S685C5_nt3v27Ev();
extern void _ZN9S685C5_nt3v28Ev();
extern void _ZN9S685C5_nt3v29Ev();
extern void _ZN9S685C5_nt3v30Ev();
extern void _ZN9S685C5_nt3v31Ev();
extern void _ZN9S685C5_nt3v32Ev();
extern void _ZN9S685C5_nt3v33Ev();
extern void _ZN9S685C5_nt3v34Ev();
extern void _ZN9S685C5_nt3v35Ev();
extern void _ZN9S685C5_nt3v36Ev();
extern void _ZN9S685C5_nt3v37Ev();
extern void _ZN9S685C5_nt3v38Ev();
extern void _ZN9S685C5_nt3v39Ev();
extern void _ZN9S685C5_nt3v40Ev();
extern void _ZN9S685C5_nt3v41Ev();
extern void _ZN9S685C5_nt3v42Ev();
extern void _ZN9S685C5_nt3v43Ev();
extern void _ZN9S685C5_nt3v44Ev();
extern void _ZN9S685C5_nt3v45Ev();
extern void _ZN9S685C5_nt3v46Ev();
extern void _ZN9S685C5_nt3v47Ev();
extern void _ZN9S685C5_nt3v48Ev();
extern void _ZN9S685C5_nt3v49Ev();
extern void _ZN9S685C5_nt3v50Ev();
extern void _ZN9S685C5_nt3v51Ev();
extern void _ZN9S685C5_nt3v52Ev();
extern void _ZN9S685C5_nt3v53Ev();
extern void _ZN9S685C5_nt3v54Ev();
extern void _ZN9S685C5_nt3v55Ev();
extern void _ZN9S685C5_nt3v56Ev();
extern void _ZN9S685C5_nt3v57Ev();
extern void _ZN9S685C5_nt3v58Ev();
extern void _ZN9S685C5_nt3v59Ev();
extern void _ZN9S685C5_nt3v60Ev();
extern void _ZN9S685C5_nt3v61Ev();
extern void _ZN9S685C5_nt3v62Ev();
extern void _ZN9S685C5_nt3v63Ev();
extern void _ZN9S685C5_nt3v64Ev();
extern void _ZN9S685C5_nt3v65Ev();
extern void _ZN9S685C5_nt3v66Ev();
extern void _ZN9S685C5_nt3v67Ev();
extern void _ZN9S685C5_nt3v68Ev();
extern void _ZN9S685C5_nt3v69Ev();
extern void _ZN9S685C5_nt3v70Ev();
extern void _ZN9S685C4_nt3v71Ev();
extern void _ZN9S685C4_nt3v72Ev();
extern void _ZN9S685C4_nt3v73Ev();
extern void _ZN9S685C4_nt3v74Ev();
extern void _ZN9S685C4_nt3v75Ev();
extern void _ZN9S685C4_nt3v76Ev();
extern void _ZN9S685C4_nt3v77Ev();
extern void _ZN9S685C4_nt3v78Ev();
extern void _ZN9S685C4_nt3v79Ev();
extern void _ZN9S685C4_nt3v80Ev();
extern void _ZN9S685C4_nt3v81Ev();
extern void _ZN9S685C4_nt3v82Ev();
extern void _ZN9S685C4_nt3v83Ev();
extern void _ZN9S685C4_nt3v84Ev();
extern void _ZN9S685C4_nt3v85Ev();
extern void _ZN9S685C4_nt3v86Ev();
extern void _ZN9S685C4_nt3v87Ev();
extern void _ZN9S685C4_nt3v88Ev();
extern void _ZN9S685C4_nt3v89Ev();
extern void _ZN9S685C4_nt3v90Ev();
extern void _ZN9S685C4_nt3v91Ev();
extern void _ZN9S685C4_nt3v92Ev();
extern void _ZN9S685C4_nt3v93Ev();
extern void _ZN9S685C4_nt3v94Ev();
extern void _ZN9S685C4_nt3v95Ev();
extern void _ZN9S685C4_nt3v96Ev();
extern void _ZN9S685C4_nt3v97Ev();
extern void _ZN9S685C4_nt3v98Ev();
extern void _ZN9S685C4_nt3v99Ev();
extern void _ZN9S685C4_nt4v100Ev();
extern void _ZN9S685C4_nt4v101Ev();
extern void _ZN9S685C4_nt4v102Ev();
extern void _ZN9S685C4_nt4v103Ev();
extern void _ZN9S685C4_nt4v104Ev();
extern void _ZN9S685C4_nt4v105Ev();
extern void _ZN9S685C4_nt4v106Ev();
extern void _ZN9S685C4_nt4v107Ev();
extern void _ZN9S685C4_nt4v108Ev();
extern void _ZN9S685C4_nt4v109Ev();
extern void _ZN9S685C4_nt4v110Ev();
extern void _ZN9S685C4_nt4v111Ev();
extern void _ZN9S685C4_nt4v112Ev();
extern void _ZN9S685C4_nt4v113Ev();
extern void _ZN9S685C4_nt4v114Ev();
extern void _ZN9S685C4_nt4v115Ev();
extern void _ZN9S685C4_nt4v116Ev();
extern void _ZN9S685C4_nt4v117Ev();
extern void _ZN9S685C4_nt4v118Ev();
extern void _ZN9S685C4_nt4v119Ev();
extern void _ZN9S685C4_nt4v120Ev();
extern void _ZN9S685C4_nt4v121Ev();
extern void _ZN9S685C4_nt4v122Ev();
extern void _ZN9S685C4_nt4v123Ev();
extern void _ZN9S685C4_nt4v124Ev();
extern void _ZN9S685C4_nt4v125Ev();
extern void _ZN9S685C4_nt4v126Ev();
extern void _ZN9S685C4_nt4v127Ev();
extern void _ZN9S685C4_nt4v128Ev();
extern void _ZN9S685C4_nt4v129Ev();
extern void _ZN9S685C4_nt4v130Ev();
extern void _ZN9S685C4_nt4v131Ev();
extern void _ZN9S685C4_nt4v132Ev();
extern void _ZN9S685C4_nt4v133Ev();
extern void _ZN9S685C4_nt4v134Ev();
extern void _ZN9S685C4_nt4v135Ev();
extern void _ZN9S685C4_nt4v136Ev();
extern void _ZN9S685C4_nt4v137Ev();
extern void _ZN9S685C4_nt4v138Ev();
extern void _ZN9S685C4_nt4v139Ev();
extern void _ZN9S685C4_nt4v140Ev();
extern void _ZN9S685C4_nt4v141Ev();
extern void _ZN9S685C4_nt4v142Ev();
extern void _ZN9S685C4_nt4v143Ev();
extern void _ZN9S685C4_nt4v144Ev();
extern void _ZN9S685C4_nt4v145Ev();
extern void _ZN9S685C4_nt4v146Ev();
extern void _ZN9S685C4_nt4v147Ev();
extern void _ZN9S685C4_nt4v148Ev();
extern void _ZN9S685C4_nt4v149Ev();
extern void _ZN9S685C4_nt4v150Ev();
extern void _ZN9S685C4_nt4v151Ev();
extern void _ZN9S685C4_nt4v152Ev();
extern void _ZN9S685C4_nt4v153Ev();
extern void _ZN9S685C4_nt4v154Ev();
extern void _ZN9S685C4_nt4v155Ev();
extern void _ZN9S685C4_nt4v156Ev();
extern void _ZN9S685C4_nt4v157Ev();
extern void _ZN9S685C4_nt4v158Ev();
extern void _ZN9S685C4_nt4v159Ev();
extern void _ZN9S685C4_nt4v160Ev();
extern void _ZN9S685C4_nt4v161Ev();
extern void _ZN9S685C4_nt4v162Ev();
extern void _ZN9S685C4_nt4v163Ev();
extern void _ZN9S685C4_nt4v164Ev();
extern void _ZN9S685C4_nt4v165Ev();
extern void _ZN9S685C4_nt4v166Ev();
extern void _ZN9S685C4_nt4v167Ev();
extern void _ZN9S685C4_nt4v168Ev();
extern void _ZN9S685C4_nt4v169Ev();
extern void _ZN9S685C4_nt4v170Ev();
extern void _ZN9S685C4_nt4v171Ev();
extern void _ZN9S685C4_nt4v172Ev();
extern void _ZN9S685C4_nt4v173Ev();
extern void _ZN9S685C4_nt4v174Ev();
extern void _ZN9S685C4_nt4v175Ev();
extern void _ZN9S685C4_nt4v176Ev();
extern void _ZN9S685C4_nt4v177Ev();
extern void _ZN9S685C4_nt4v178Ev();
extern void _ZN9S685C4_nt4v179Ev();
extern void _ZN9S685C4_nt4v180Ev();
extern void _ZN9S685C4_nt4v181Ev();
extern void _ZN9S685C4_nt4v182Ev();
extern void _ZN9S685C4_nt4v183Ev();
extern void _ZN9S685C4_nt4v184Ev();
extern void _ZN9S685C4_nt4v185Ev();
extern void _ZN9S685C4_nt4v186Ev();
extern void _ZN9S685C4_nt4v187Ev();
extern void _ZN9S685C4_nt4v188Ev();
extern void _ZN9S685C4_nt4v189Ev();
extern void _ZN9S685C4_nt4v190Ev();
extern void _ZN9S685C4_nt4v191Ev();
extern void _ZN9S685C4_nt4v192Ev();
extern void _ZN9S685C4_nt4v193Ev();
extern void _ZN9S685C4_nt4v194Ev();
extern void _ZN9S685C4_nt4v195Ev();
extern void _ZN9S685C4_nt4v196Ev();
extern void _ZN9S685C4_nt4v197Ev();
extern void _ZN9S685C4_nt4v198Ev();
extern void _ZN9S685C4_nt4v199Ev();
extern void _ZN9S685C4_nt4v200Ev();
extern void _ZN9S685C4_nt4v201Ev();
extern void _ZN9S685C4_nt4v202Ev();
extern void _ZN9S685C4_nt4v203Ev();
extern void _ZN9S685C4_nt4v204Ev();
extern void _ZN9S685C4_nt4v205Ev();
extern void _ZN9S685C4_nt4v206Ev();
extern void _ZN9S685C4_nt4v207Ev();
extern void _ZN9S685C4_nt4v208Ev();
extern void _ZN9S685C4_nt4v209Ev();
extern void _ZN9S685C4_nt4v210Ev();
extern void _ZN9S685C4_nt4v211Ev();
extern void _ZN9S685C4_nt4v212Ev();
extern void _ZN9S685C4_nt4v213Ev();
extern void _ZN6S685C34v214Ev();
extern void _ZN6S685C34v215Ev();
extern void _ZN6S685C24v216Ev();
extern void _ZN6S685C24v217Ev();
extern void _ZN6S685C12v1Ev();
extern void _ZN6S685C12v2Ev();
extern void _ZN6S685C12v3Ev();
extern void _ZN6S685C12v4Ev();
extern void _ZN6S685C12v5Ev();
extern void _ZN6S685C12v6Ev();
static  VTBL_ENTRY vtc_S685C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S685C1[0]),
  (VTBL_ENTRY)&_ZN6S685C1D1Ev,
  (VTBL_ENTRY)&_ZN6S685C1D0Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v7Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v8Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt2v9Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v10Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v11Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v12Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v13Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v14Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v15Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v16Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v17Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v18Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v19Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v20Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v21Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v22Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v23Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v24Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v25Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v26Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v27Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v28Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v29Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v30Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v31Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v32Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v33Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v34Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v35Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v36Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v37Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v38Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v39Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v40Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v41Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v42Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v43Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v44Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v45Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v46Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v47Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v48Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v49Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v50Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v51Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v52Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v53Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v54Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v55Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v56Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v57Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v58Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v59Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v60Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v61Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v62Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v63Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v64Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v65Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v66Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v67Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v68Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v69Ev,
  (VTBL_ENTRY)&_ZN9S685C5_nt3v70Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v71Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v72Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v73Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v74Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v75Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v76Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v77Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v78Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v79Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v80Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v81Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v82Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v83Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v84Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v85Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v86Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v87Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v88Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v89Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v90Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v91Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v92Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v93Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v94Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v95Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v96Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v97Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v98Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt3v99Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v100Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v101Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v102Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v103Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v104Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v105Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v106Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v107Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v108Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v109Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v114Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v115Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v116Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v117Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v118Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v119Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v120Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v121Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v122Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v123Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v124Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v125Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v126Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v127Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v128Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v129Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v130Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v131Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v132Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v133Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v134Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v135Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v136Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v137Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v138Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v139Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v140Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v141Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v142Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v143Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v144Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v145Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v146Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v147Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v148Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v149Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v150Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v151Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v152Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v153Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v154Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v155Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v156Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v157Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v158Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v159Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v160Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v161Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v162Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v163Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v164Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v165Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v166Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v167Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v168Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v169Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v170Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v171Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v172Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v173Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v174Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v175Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v176Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v177Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v178Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v179Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v180Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v181Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v182Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v183Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v184Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v185Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v186Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v187Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v188Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v189Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v190Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v191Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v192Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v193Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v194Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v195Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v196Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v197Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v198Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v199Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v200Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v201Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v202Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v203Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v204Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v205Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v206Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v207Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v208Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v209Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v210Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v211Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v212Ev,
  (VTBL_ENTRY)&_ZN9S685C4_nt4v213Ev,
  (VTBL_ENTRY)&_ZN6S685C34v214Ev,
  (VTBL_ENTRY)&_ZN6S685C34v215Ev,
  (VTBL_ENTRY)&_ZN6S685C24v216Ev,
  (VTBL_ENTRY)&_ZN6S685C24v217Ev,
  (VTBL_ENTRY)&_ZN6S685C12v1Ev,
  (VTBL_ENTRY)&_ZN6S685C12v2Ev,
  (VTBL_ENTRY)&_ZN6S685C12v3Ev,
  (VTBL_ENTRY)&_ZN6S685C12v4Ev,
  (VTBL_ENTRY)&_ZN6S685C12v5Ev,
  (VTBL_ENTRY)&_ZN6S685C12v6Ev,
};
extern VTBL_ENTRY _ZTI6S685C1[];
extern  VTBL_ENTRY _ZTV6S685C1[];
Class_Descriptor cd_S685C1 = {  "S685C1", // class name
  bases_S685C1, 4,
  &(vtc_S685C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2696,2128), // object size
  NSPAIRA(_ZTI6S685C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S685C1),221, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C5  {
  int s695c5f0;
  __tsi64 s695c5f1;
  void *s695c5f2[4];
  int s695c5f3[2];
  void *s695c5f4;
  ::S685C6_nt s695c5f5;
  void *s695c5f6[2];
  virtual  ~S695C5(); // _ZN6S695C5D1Ev
  virtual void  v7(); // _ZN6S695C52v7Ev
  virtual void  v8(); // _ZN6S695C52v8Ev
  virtual void  v9(); // _ZN6S695C52v9Ev
  virtual void  v10(); // _ZN6S695C53v10Ev
  virtual void  v11(); // _ZN6S695C53v11Ev
  virtual void  v12(); // _ZN6S695C53v12Ev
  virtual void  v13(); // _ZN6S695C53v13Ev
  virtual void  v14(); // _ZN6S695C53v14Ev
  virtual void  v15(); // _ZN6S695C53v15Ev
  virtual void  v16(); // _ZN6S695C53v16Ev
  virtual void  v17(); // _ZN6S695C53v17Ev
  virtual void  v18(); // _ZN6S695C53v18Ev
  virtual void  v19(); // _ZN6S695C53v19Ev
  virtual void  v20(); // _ZN6S695C53v20Ev
  virtual void  v21(); // _ZN6S695C53v21Ev
  virtual void  v22(); // _ZN6S695C53v22Ev
  virtual void  v23(); // _ZN6S695C53v23Ev
  virtual void  v24(); // _ZN6S695C53v24Ev
  virtual void  v25(); // _ZN6S695C53v25Ev
  virtual void  v26(); // _ZN6S695C53v26Ev
  virtual void  v27(); // _ZN6S695C53v27Ev
  virtual void  v28(); // _ZN6S695C53v28Ev
  virtual void  v29(); // _ZN6S695C53v29Ev
  virtual void  v30(); // _ZN6S695C53v30Ev
  virtual void  v31(); // _ZN6S695C53v31Ev
  virtual void  v32(); // _ZN6S695C53v32Ev
  virtual void  v33(); // _ZN6S695C53v33Ev
  virtual void  v34(); // _ZN6S695C53v34Ev
  virtual void  v35(); // _ZN6S695C53v35Ev
  virtual void  v36(); // _ZN6S695C53v36Ev
  virtual void  v37(); // _ZN6S695C53v37Ev
  virtual void  v38(); // _ZN6S695C53v38Ev
  virtual void  v39(); // _ZN6S695C53v39Ev
  virtual void  v40(); // _ZN6S695C53v40Ev
  virtual void  v41(); // _ZN6S695C53v41Ev
  virtual void  v42(); // _ZN6S695C53v42Ev
  virtual void  v43(); // _ZN6S695C53v43Ev
  virtual void  v44(); // _ZN6S695C53v44Ev
  virtual void  v45(); // _ZN6S695C53v45Ev
  virtual void  v46(); // _ZN6S695C53v46Ev
  virtual void  v47(); // _ZN6S695C53v47Ev
  virtual void  v48(); // _ZN6S695C53v48Ev
  virtual void  v49(); // _ZN6S695C53v49Ev
  virtual void  v50(); // _ZN6S695C53v50Ev
  virtual void  v51(); // _ZN6S695C53v51Ev
  virtual void  v52(); // _ZN6S695C53v52Ev
  virtual void  v53(); // _ZN6S695C53v53Ev
  virtual void  v54(); // _ZN6S695C53v54Ev
  virtual void  v55(); // _ZN6S695C53v55Ev
  virtual void  v56(); // _ZN6S695C53v56Ev
  virtual void  v57(); // _ZN6S695C53v57Ev
  virtual void  v58(); // _ZN6S695C53v58Ev
  virtual void  v59(); // _ZN6S695C53v59Ev
  virtual void  v60(); // _ZN6S695C53v60Ev
  virtual void  v61(); // _ZN6S695C53v61Ev
  virtual void  v62(); // _ZN6S695C53v62Ev
  virtual void  v63(); // _ZN6S695C53v63Ev
  virtual void  v64(); // _ZN6S695C53v64Ev
  virtual void  v65(); // _ZN6S695C53v65Ev
  virtual void  v66(); // _ZN6S695C53v66Ev
  virtual void  v67(); // _ZN6S695C53v67Ev
  virtual void  v68(); // _ZN6S695C53v68Ev
  virtual void  v69(); // _ZN6S695C53v69Ev
  virtual void  v70(); // _ZN6S695C53v70Ev
  S695C5(); // tgen
};
//SIG(-1 S695C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S695C5 ::~S695C5(){ note_dtor("S695C5", this);}
void  S695C5 ::v7(){vfunc_called(this, "_ZN6S695C52v7Ev");}
void  S695C5 ::v8(){vfunc_called(this, "_ZN6S695C52v8Ev");}
void  S695C5 ::v9(){vfunc_called(this, "_ZN6S695C52v9Ev");}
void  S695C5 ::v10(){vfunc_called(this, "_ZN6S695C53v10Ev");}
void  S695C5 ::v11(){vfunc_called(this, "_ZN6S695C53v11Ev");}
void  S695C5 ::v12(){vfunc_called(this, "_ZN6S695C53v12Ev");}
void  S695C5 ::v13(){vfunc_called(this, "_ZN6S695C53v13Ev");}
void  S695C5 ::v14(){vfunc_called(this, "_ZN6S695C53v14Ev");}
void  S695C5 ::v15(){vfunc_called(this, "_ZN6S695C53v15Ev");}
void  S695C5 ::v16(){vfunc_called(this, "_ZN6S695C53v16Ev");}
void  S695C5 ::v17(){vfunc_called(this, "_ZN6S695C53v17Ev");}
void  S695C5 ::v18(){vfunc_called(this, "_ZN6S695C53v18Ev");}
void  S695C5 ::v19(){vfunc_called(this, "_ZN6S695C53v19Ev");}
void  S695C5 ::v20(){vfunc_called(this, "_ZN6S695C53v20Ev");}
void  S695C5 ::v21(){vfunc_called(this, "_ZN6S695C53v21Ev");}
void  S695C5 ::v22(){vfunc_called(this, "_ZN6S695C53v22Ev");}
void  S695C5 ::v23(){vfunc_called(this, "_ZN6S695C53v23Ev");}
void  S695C5 ::v24(){vfunc_called(this, "_ZN6S695C53v24Ev");}
void  S695C5 ::v25(){vfunc_called(this, "_ZN6S695C53v25Ev");}
void  S695C5 ::v26(){vfunc_called(this, "_ZN6S695C53v26Ev");}
void  S695C5 ::v27(){vfunc_called(this, "_ZN6S695C53v27Ev");}
void  S695C5 ::v28(){vfunc_called(this, "_ZN6S695C53v28Ev");}
void  S695C5 ::v29(){vfunc_called(this, "_ZN6S695C53v29Ev");}
void  S695C5 ::v30(){vfunc_called(this, "_ZN6S695C53v30Ev");}
void  S695C5 ::v31(){vfunc_called(this, "_ZN6S695C53v31Ev");}
void  S695C5 ::v32(){vfunc_called(this, "_ZN6S695C53v32Ev");}
void  S695C5 ::v33(){vfunc_called(this, "_ZN6S695C53v33Ev");}
void  S695C5 ::v34(){vfunc_called(this, "_ZN6S695C53v34Ev");}
void  S695C5 ::v35(){vfunc_called(this, "_ZN6S695C53v35Ev");}
void  S695C5 ::v36(){vfunc_called(this, "_ZN6S695C53v36Ev");}
void  S695C5 ::v37(){vfunc_called(this, "_ZN6S695C53v37Ev");}
void  S695C5 ::v38(){vfunc_called(this, "_ZN6S695C53v38Ev");}
void  S695C5 ::v39(){vfunc_called(this, "_ZN6S695C53v39Ev");}
void  S695C5 ::v40(){vfunc_called(this, "_ZN6S695C53v40Ev");}
void  S695C5 ::v41(){vfunc_called(this, "_ZN6S695C53v41Ev");}
void  S695C5 ::v42(){vfunc_called(this, "_ZN6S695C53v42Ev");}
void  S695C5 ::v43(){vfunc_called(this, "_ZN6S695C53v43Ev");}
void  S695C5 ::v44(){vfunc_called(this, "_ZN6S695C53v44Ev");}
void  S695C5 ::v45(){vfunc_called(this, "_ZN6S695C53v45Ev");}
void  S695C5 ::v46(){vfunc_called(this, "_ZN6S695C53v46Ev");}
void  S695C5 ::v47(){vfunc_called(this, "_ZN6S695C53v47Ev");}
void  S695C5 ::v48(){vfunc_called(this, "_ZN6S695C53v48Ev");}
void  S695C5 ::v49(){vfunc_called(this, "_ZN6S695C53v49Ev");}
void  S695C5 ::v50(){vfunc_called(this, "_ZN6S695C53v50Ev");}
void  S695C5 ::v51(){vfunc_called(this, "_ZN6S695C53v51Ev");}
void  S695C5 ::v52(){vfunc_called(this, "_ZN6S695C53v52Ev");}
void  S695C5 ::v53(){vfunc_called(this, "_ZN6S695C53v53Ev");}
void  S695C5 ::v54(){vfunc_called(this, "_ZN6S695C53v54Ev");}
void  S695C5 ::v55(){vfunc_called(this, "_ZN6S695C53v55Ev");}
void  S695C5 ::v56(){vfunc_called(this, "_ZN6S695C53v56Ev");}
void  S695C5 ::v57(){vfunc_called(this, "_ZN6S695C53v57Ev");}
void  S695C5 ::v58(){vfunc_called(this, "_ZN6S695C53v58Ev");}
void  S695C5 ::v59(){vfunc_called(this, "_ZN6S695C53v59Ev");}
void  S695C5 ::v60(){vfunc_called(this, "_ZN6S695C53v60Ev");}
void  S695C5 ::v61(){vfunc_called(this, "_ZN6S695C53v61Ev");}
void  S695C5 ::v62(){vfunc_called(this, "_ZN6S695C53v62Ev");}
void  S695C5 ::v63(){vfunc_called(this, "_ZN6S695C53v63Ev");}
void  S695C5 ::v64(){vfunc_called(this, "_ZN6S695C53v64Ev");}
void  S695C5 ::v65(){vfunc_called(this, "_ZN6S695C53v65Ev");}
void  S695C5 ::v66(){vfunc_called(this, "_ZN6S695C53v66Ev");}
void  S695C5 ::v67(){vfunc_called(this, "_ZN6S695C53v67Ev");}
void  S695C5 ::v68(){vfunc_called(this, "_ZN6S695C53v68Ev");}
void  S695C5 ::v69(){vfunc_called(this, "_ZN6S695C53v69Ev");}
void  S695C5 ::v70(){vfunc_called(this, "_ZN6S695C53v70Ev");}
S695C5 ::S695C5(){ note_ctor("S695C5", this);} // tgen

static void Test_S695C5()
{
  extern Class_Descriptor cd_S695C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S695C5, buf);
    S695C5 *dp, &lv = *(dp=new (buf) S695C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S695C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C5)");
    check_field_offset(lv, s695c5f0, ABISELECT(8,4), "S695C5.s695c5f0");
    check_field_offset(lv, s695c5f1, ABISELECT(16,8), "S695C5.s695c5f1");
    check_field_offset(lv, s695c5f2, ABISELECT(24,16), "S695C5.s695c5f2");
    check_field_offset(lv, s695c5f3, ABISELECT(56,32), "S695C5.s695c5f3");
    check_field_offset(lv, s695c5f4, ABISELECT(64,40), "S695C5.s695c5f4");
    check_field_offset(lv, s695c5f5, ABISELECT(72,44), "S695C5.s695c5f5");
    check_field_offset(lv, s695c5f6, ABISELECT(80,52), "S695C5.s695c5f6");
    test_class_info(&lv, &cd_S695C5);
    dp->~S695C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C5(Test_S695C5, "S695C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S695C5C1Ev();
extern void _ZN6S695C5D1Ev();
Name_Map name_map_S695C5[] = {
  NSPAIR(_ZN6S695C5C1Ev),
  NSPAIR(_ZN6S695C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S695C5[];
extern void _ZN6S695C5D1Ev();
extern void _ZN6S695C5D0Ev();
extern void _ZN6S695C52v7Ev();
extern void _ZN6S695C52v8Ev();
extern void _ZN6S695C52v9Ev();
extern void _ZN6S695C53v10Ev();
extern void _ZN6S695C53v11Ev();
extern void _ZN6S695C53v12Ev();
extern void _ZN6S695C53v13Ev();
extern void _ZN6S695C53v14Ev();
extern void _ZN6S695C53v15Ev();
extern void _ZN6S695C53v16Ev();
extern void _ZN6S695C53v17Ev();
extern void _ZN6S695C53v18Ev();
extern void _ZN6S695C53v19Ev();
extern void _ZN6S695C53v20Ev();
extern void _ZN6S695C53v21Ev();
extern void _ZN6S695C53v22Ev();
extern void _ZN6S695C53v23Ev();
extern void _ZN6S695C53v24Ev();
extern void _ZN6S695C53v25Ev();
extern void _ZN6S695C53v26Ev();
extern void _ZN6S695C53v27Ev();
extern void _ZN6S695C53v28Ev();
extern void _ZN6S695C53v29Ev();
extern void _ZN6S695C53v30Ev();
extern void _ZN6S695C53v31Ev();
extern void _ZN6S695C53v32Ev();
extern void _ZN6S695C53v33Ev();
extern void _ZN6S695C53v34Ev();
extern void _ZN6S695C53v35Ev();
extern void _ZN6S695C53v36Ev();
extern void _ZN6S695C53v37Ev();
extern void _ZN6S695C53v38Ev();
extern void _ZN6S695C53v39Ev();
extern void _ZN6S695C53v40Ev();
extern void _ZN6S695C53v41Ev();
extern void _ZN6S695C53v42Ev();
extern void _ZN6S695C53v43Ev();
extern void _ZN6S695C53v44Ev();
extern void _ZN6S695C53v45Ev();
extern void _ZN6S695C53v46Ev();
extern void _ZN6S695C53v47Ev();
extern void _ZN6S695C53v48Ev();
extern void _ZN6S695C53v49Ev();
extern void _ZN6S695C53v50Ev();
extern void _ZN6S695C53v51Ev();
extern void _ZN6S695C53v52Ev();
extern void _ZN6S695C53v53Ev();
extern void _ZN6S695C53v54Ev();
extern void _ZN6S695C53v55Ev();
extern void _ZN6S695C53v56Ev();
extern void _ZN6S695C53v57Ev();
extern void _ZN6S695C53v58Ev();
extern void _ZN6S695C53v59Ev();
extern void _ZN6S695C53v60Ev();
extern void _ZN6S695C53v61Ev();
extern void _ZN6S695C53v62Ev();
extern void _ZN6S695C53v63Ev();
extern void _ZN6S695C53v64Ev();
extern void _ZN6S695C53v65Ev();
extern void _ZN6S695C53v66Ev();
extern void _ZN6S695C53v67Ev();
extern void _ZN6S695C53v68Ev();
extern void _ZN6S695C53v69Ev();
extern void _ZN6S695C53v70Ev();
static  VTBL_ENTRY vtc_S695C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S695C5[0]),
  (VTBL_ENTRY)&_ZN6S695C5D1Ev,
  (VTBL_ENTRY)&_ZN6S695C5D0Ev,
  (VTBL_ENTRY)&_ZN6S695C52v7Ev,
  (VTBL_ENTRY)&_ZN6S695C52v8Ev,
  (VTBL_ENTRY)&_ZN6S695C52v9Ev,
  (VTBL_ENTRY)&_ZN6S695C53v10Ev,
  (VTBL_ENTRY)&_ZN6S695C53v11Ev,
  (VTBL_ENTRY)&_ZN6S695C53v12Ev,
  (VTBL_ENTRY)&_ZN6S695C53v13Ev,
  (VTBL_ENTRY)&_ZN6S695C53v14Ev,
  (VTBL_ENTRY)&_ZN6S695C53v15Ev,
  (VTBL_ENTRY)&_ZN6S695C53v16Ev,
  (VTBL_ENTRY)&_ZN6S695C53v17Ev,
  (VTBL_ENTRY)&_ZN6S695C53v18Ev,
  (VTBL_ENTRY)&_ZN6S695C53v19Ev,
  (VTBL_ENTRY)&_ZN6S695C53v20Ev,
  (VTBL_ENTRY)&_ZN6S695C53v21Ev,
  (VTBL_ENTRY)&_ZN6S695C53v22Ev,
  (VTBL_ENTRY)&_ZN6S695C53v23Ev,
  (VTBL_ENTRY)&_ZN6S695C53v24Ev,
  (VTBL_ENTRY)&_ZN6S695C53v25Ev,
  (VTBL_ENTRY)&_ZN6S695C53v26Ev,
  (VTBL_ENTRY)&_ZN6S695C53v27Ev,
  (VTBL_ENTRY)&_ZN6S695C53v28Ev,
  (VTBL_ENTRY)&_ZN6S695C53v29Ev,
  (VTBL_ENTRY)&_ZN6S695C53v30Ev,
  (VTBL_ENTRY)&_ZN6S695C53v31Ev,
  (VTBL_ENTRY)&_ZN6S695C53v32Ev,
  (VTBL_ENTRY)&_ZN6S695C53v33Ev,
  (VTBL_ENTRY)&_ZN6S695C53v34Ev,
  (VTBL_ENTRY)&_ZN6S695C53v35Ev,
  (VTBL_ENTRY)&_ZN6S695C53v36Ev,
  (VTBL_ENTRY)&_ZN6S695C53v37Ev,
  (VTBL_ENTRY)&_ZN6S695C53v38Ev,
  (VTBL_ENTRY)&_ZN6S695C53v39Ev,
  (VTBL_ENTRY)&_ZN6S695C53v40Ev,
  (VTBL_ENTRY)&_ZN6S695C53v41Ev,
  (VTBL_ENTRY)&_ZN6S695C53v42Ev,
  (VTBL_ENTRY)&_ZN6S695C53v43Ev,
  (VTBL_ENTRY)&_ZN6S695C53v44Ev,
  (VTBL_ENTRY)&_ZN6S695C53v45Ev,
  (VTBL_ENTRY)&_ZN6S695C53v46Ev,
  (VTBL_ENTRY)&_ZN6S695C53v47Ev,
  (VTBL_ENTRY)&_ZN6S695C53v48Ev,
  (VTBL_ENTRY)&_ZN6S695C53v49Ev,
  (VTBL_ENTRY)&_ZN6S695C53v50Ev,
  (VTBL_ENTRY)&_ZN6S695C53v51Ev,
  (VTBL_ENTRY)&_ZN6S695C53v52Ev,
  (VTBL_ENTRY)&_ZN6S695C53v53Ev,
  (VTBL_ENTRY)&_ZN6S695C53v54Ev,
  (VTBL_ENTRY)&_ZN6S695C53v55Ev,
  (VTBL_ENTRY)&_ZN6S695C53v56Ev,
  (VTBL_ENTRY)&_ZN6S695C53v57Ev,
  (VTBL_ENTRY)&_ZN6S695C53v58Ev,
  (VTBL_ENTRY)&_ZN6S695C53v59Ev,
  (VTBL_ENTRY)&_ZN6S695C53v60Ev,
  (VTBL_ENTRY)&_ZN6S695C53v61Ev,
  (VTBL_ENTRY)&_ZN6S695C53v62Ev,
  (VTBL_ENTRY)&_ZN6S695C53v63Ev,
  (VTBL_ENTRY)&_ZN6S695C53v64Ev,
  (VTBL_ENTRY)&_ZN6S695C53v65Ev,
  (VTBL_ENTRY)&_ZN6S695C53v66Ev,
  (VTBL_ENTRY)&_ZN6S695C53v67Ev,
  (VTBL_ENTRY)&_ZN6S695C53v68Ev,
  (VTBL_ENTRY)&_ZN6S695C53v69Ev,
  (VTBL_ENTRY)&_ZN6S695C53v70Ev,
};
extern VTBL_ENTRY _ZTI6S695C5[];
extern  VTBL_ENTRY _ZTV6S695C5[];
Class_Descriptor cd_S695C5 = {  "S695C5", // class name
  0,0,//no base classes
  &(vtc_S695C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S695C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S695C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C4  : S695C5 {
  virtual  ~S695C4(); // _ZN6S695C4D1Ev
  virtual void  v71(); // _ZN6S695C43v71Ev
  virtual void  v72(); // _ZN6S695C43v72Ev
  virtual void  v73(); // _ZN6S695C43v73Ev
  virtual void  v74(); // _ZN6S695C43v74Ev
  S695C4(); // tgen
};
//SIG(-1 S695C4) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S695C4 ::~S695C4(){ note_dtor("S695C4", this);}
void  S695C4 ::v71(){vfunc_called(this, "_ZN6S695C43v71Ev");}
void  S695C4 ::v72(){vfunc_called(this, "_ZN6S695C43v72Ev");}
void  S695C4 ::v73(){vfunc_called(this, "_ZN6S695C43v73Ev");}
void  S695C4 ::v74(){vfunc_called(this, "_ZN6S695C43v74Ev");}
S695C4 ::S695C4(){ note_ctor("S695C4", this);} // tgen

static void Test_S695C4()
{
  extern Class_Descriptor cd_S695C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S695C4, buf);
    S695C4 *dp, &lv = *(dp=new (buf) S695C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S695C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C4)");
    check_base_class_offset(lv, (S695C5*), 0, "S695C4");
    test_class_info(&lv, &cd_S695C4);
    dp->~S695C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C4(Test_S695C4, "S695C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S695C4C1Ev();
extern void _ZN6S695C4D1Ev();
Name_Map name_map_S695C4[] = {
  NSPAIR(_ZN6S695C4C1Ev),
  NSPAIR(_ZN6S695C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S695C5;
extern VTBL_ENTRY _ZTI6S695C5[];
extern  VTBL_ENTRY _ZTV6S695C5[];
static Base_Class bases_S695C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S695C4[];
extern void _ZN6S695C4D1Ev();
extern void _ZN6S695C4D0Ev();
extern void _ZN6S695C52v7Ev();
extern void _ZN6S695C52v8Ev();
extern void _ZN6S695C52v9Ev();
extern void _ZN6S695C53v10Ev();
extern void _ZN6S695C53v11Ev();
extern void _ZN6S695C53v12Ev();
extern void _ZN6S695C53v13Ev();
extern void _ZN6S695C53v14Ev();
extern void _ZN6S695C53v15Ev();
extern void _ZN6S695C53v16Ev();
extern void _ZN6S695C53v17Ev();
extern void _ZN6S695C53v18Ev();
extern void _ZN6S695C53v19Ev();
extern void _ZN6S695C53v20Ev();
extern void _ZN6S695C53v21Ev();
extern void _ZN6S695C53v22Ev();
extern void _ZN6S695C53v23Ev();
extern void _ZN6S695C53v24Ev();
extern void _ZN6S695C53v25Ev();
extern void _ZN6S695C53v26Ev();
extern void _ZN6S695C53v27Ev();
extern void _ZN6S695C53v28Ev();
extern void _ZN6S695C53v29Ev();
extern void _ZN6S695C53v30Ev();
extern void _ZN6S695C53v31Ev();
extern void _ZN6S695C53v32Ev();
extern void _ZN6S695C53v33Ev();
extern void _ZN6S695C53v34Ev();
extern void _ZN6S695C53v35Ev();
extern void _ZN6S695C53v36Ev();
extern void _ZN6S695C53v37Ev();
extern void _ZN6S695C53v38Ev();
extern void _ZN6S695C53v39Ev();
extern void _ZN6S695C53v40Ev();
extern void _ZN6S695C53v41Ev();
extern void _ZN6S695C53v42Ev();
extern void _ZN6S695C53v43Ev();
extern void _ZN6S695C53v44Ev();
extern void _ZN6S695C53v45Ev();
extern void _ZN6S695C53v46Ev();
extern void _ZN6S695C53v47Ev();
extern void _ZN6S695C53v48Ev();
extern void _ZN6S695C53v49Ev();
extern void _ZN6S695C53v50Ev();
extern void _ZN6S695C53v51Ev();
extern void _ZN6S695C53v52Ev();
extern void _ZN6S695C53v53Ev();
extern void _ZN6S695C53v54Ev();
extern void _ZN6S695C53v55Ev();
extern void _ZN6S695C53v56Ev();
extern void _ZN6S695C53v57Ev();
extern void _ZN6S695C53v58Ev();
extern void _ZN6S695C53v59Ev();
extern void _ZN6S695C53v60Ev();
extern void _ZN6S695C53v61Ev();
extern void _ZN6S695C53v62Ev();
extern void _ZN6S695C53v63Ev();
extern void _ZN6S695C53v64Ev();
extern void _ZN6S695C53v65Ev();
extern void _ZN6S695C53v66Ev();
extern void _ZN6S695C53v67Ev();
extern void _ZN6S695C53v68Ev();
extern void _ZN6S695C53v69Ev();
extern void _ZN6S695C53v70Ev();
extern void _ZN6S695C43v71Ev();
extern void _ZN6S695C43v72Ev();
extern void _ZN6S695C43v73Ev();
extern void _ZN6S695C43v74Ev();
static  VTBL_ENTRY vtc_S695C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S695C4[0]),
  (VTBL_ENTRY)&_ZN6S695C4D1Ev,
  (VTBL_ENTRY)&_ZN6S695C4D0Ev,
  (VTBL_ENTRY)&_ZN6S695C52v7Ev,
  (VTBL_ENTRY)&_ZN6S695C52v8Ev,
  (VTBL_ENTRY)&_ZN6S695C52v9Ev,
  (VTBL_ENTRY)&_ZN6S695C53v10Ev,
  (VTBL_ENTRY)&_ZN6S695C53v11Ev,
  (VTBL_ENTRY)&_ZN6S695C53v12Ev,
  (VTBL_ENTRY)&_ZN6S695C53v13Ev,
  (VTBL_ENTRY)&_ZN6S695C53v14Ev,
  (VTBL_ENTRY)&_ZN6S695C53v15Ev,
  (VTBL_ENTRY)&_ZN6S695C53v16Ev,
  (VTBL_ENTRY)&_ZN6S695C53v17Ev,
  (VTBL_ENTRY)&_ZN6S695C53v18Ev,
  (VTBL_ENTRY)&_ZN6S695C53v19Ev,
  (VTBL_ENTRY)&_ZN6S695C53v20Ev,
  (VTBL_ENTRY)&_ZN6S695C53v21Ev,
  (VTBL_ENTRY)&_ZN6S695C53v22Ev,
  (VTBL_ENTRY)&_ZN6S695C53v23Ev,
  (VTBL_ENTRY)&_ZN6S695C53v24Ev,
  (VTBL_ENTRY)&_ZN6S695C53v25Ev,
  (VTBL_ENTRY)&_ZN6S695C53v26Ev,
  (VTBL_ENTRY)&_ZN6S695C53v27Ev,
  (VTBL_ENTRY)&_ZN6S695C53v28Ev,
  (VTBL_ENTRY)&_ZN6S695C53v29Ev,
  (VTBL_ENTRY)&_ZN6S695C53v30Ev,
  (VTBL_ENTRY)&_ZN6S695C53v31Ev,
  (VTBL_ENTRY)&_ZN6S695C53v32Ev,
  (VTBL_ENTRY)&_ZN6S695C53v33Ev,
  (VTBL_ENTRY)&_ZN6S695C53v34Ev,
  (VTBL_ENTRY)&_ZN6S695C53v35Ev,
  (VTBL_ENTRY)&_ZN6S695C53v36Ev,
  (VTBL_ENTRY)&_ZN6S695C53v37Ev,
  (VTBL_ENTRY)&_ZN6S695C53v38Ev,
  (VTBL_ENTRY)&_ZN6S695C53v39Ev,
  (VTBL_ENTRY)&_ZN6S695C53v40Ev,
  (VTBL_ENTRY)&_ZN6S695C53v41Ev,
  (VTBL_ENTRY)&_ZN6S695C53v42Ev,
  (VTBL_ENTRY)&_ZN6S695C53v43Ev,
  (VTBL_ENTRY)&_ZN6S695C53v44Ev,
  (VTBL_ENTRY)&_ZN6S695C53v45Ev,
  (VTBL_ENTRY)&_ZN6S695C53v46Ev,
  (VTBL_ENTRY)&_ZN6S695C53v47Ev,
  (VTBL_ENTRY)&_ZN6S695C53v48Ev,
  (VTBL_ENTRY)&_ZN6S695C53v49Ev,
  (VTBL_ENTRY)&_ZN6S695C53v50Ev,
  (VTBL_ENTRY)&_ZN6S695C53v51Ev,
  (VTBL_ENTRY)&_ZN6S695C53v52Ev,
  (VTBL_ENTRY)&_ZN6S695C53v53Ev,
  (VTBL_ENTRY)&_ZN6S695C53v54Ev,
  (VTBL_ENTRY)&_ZN6S695C53v55Ev,
  (VTBL_ENTRY)&_ZN6S695C53v56Ev,
  (VTBL_ENTRY)&_ZN6S695C53v57Ev,
  (VTBL_ENTRY)&_ZN6S695C53v58Ev,
  (VTBL_ENTRY)&_ZN6S695C53v59Ev,
  (VTBL_ENTRY)&_ZN6S695C53v60Ev,
  (VTBL_ENTRY)&_ZN6S695C53v61Ev,
  (VTBL_ENTRY)&_ZN6S695C53v62Ev,
  (VTBL_ENTRY)&_ZN6S695C53v63Ev,
  (VTBL_ENTRY)&_ZN6S695C53v64Ev,
  (VTBL_ENTRY)&_ZN6S695C53v65Ev,
  (VTBL_ENTRY)&_ZN6S695C53v66Ev,
  (VTBL_ENTRY)&_ZN6S695C53v67Ev,
  (VTBL_ENTRY)&_ZN6S695C53v68Ev,
  (VTBL_ENTRY)&_ZN6S695C53v69Ev,
  (VTBL_ENTRY)&_ZN6S695C53v70Ev,
  (VTBL_ENTRY)&_ZN6S695C43v71Ev,
  (VTBL_ENTRY)&_ZN6S695C43v72Ev,
  (VTBL_ENTRY)&_ZN6S695C43v73Ev,
  (VTBL_ENTRY)&_ZN6S695C43v74Ev,
};
extern VTBL_ENTRY _ZTI6S695C4[];
extern  VTBL_ENTRY _ZTV6S695C4[];
Class_Descriptor cd_S695C4 = {  "S695C4", // class name
  bases_S695C4, 1,
  &(vtc_S695C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S695C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S695C4),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C3  : S695C4 {
  ::S685C27_nt s695c3f0;
  virtual  ~S695C3(); // _ZN6S695C3D1Ev
  virtual void  v75(); // _ZN6S695C33v75Ev
  virtual void  v76(); // _ZN6S695C33v76Ev
  virtual void  v77(); // _ZN6S695C33v77Ev
  virtual void  v78(); // _ZN6S695C33v78Ev
  virtual void  v79(); // _ZN6S695C33v79Ev
  virtual void  v80(); // _ZN6S695C33v80Ev
  virtual void  v81(); // _ZN6S695C33v81Ev
  virtual void  v82(); // _ZN6S695C33v82Ev
  virtual void  v83(); // _ZN6S695C33v83Ev
  virtual void  v84(); // _ZN6S695C33v84Ev
  virtual void  v85(); // _ZN6S695C33v85Ev
  virtual void  v86(); // _ZN6S695C33v86Ev
  virtual void  v87(); // _ZN6S695C33v87Ev
  virtual void  v88(); // _ZN6S695C33v88Ev
  virtual void  v89(); // _ZN6S695C33v89Ev
  virtual void  v90(); // _ZN6S695C33v90Ev
  virtual void  v91(); // _ZN6S695C33v91Ev
  virtual void  v92(); // _ZN6S695C33v92Ev
  virtual void  v93(); // _ZN6S695C33v93Ev
  virtual void  v94(); // _ZN6S695C33v94Ev
  virtual void  v95(); // _ZN6S695C33v95Ev
  virtual void  v96(); // _ZN6S695C33v96Ev
  virtual void  v97(); // _ZN6S695C33v97Ev
  virtual void  v98(); // _ZN6S695C33v98Ev
  virtual void  v99(); // _ZN6S695C33v99Ev
  virtual void  v100(); // _ZN6S695C34v100Ev
  virtual void  v101(); // _ZN6S695C34v101Ev
  virtual void  v102(); // _ZN6S695C34v102Ev
  virtual void  v103(); // _ZN6S695C34v103Ev
  virtual void  v104(); // _ZN6S695C34v104Ev
  virtual void  v105(); // _ZN6S695C34v105Ev
  S695C3(); // tgen
};
//SIG(-1 S695C3) C1{ BC2{ BC3{ vd v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v96 v97 v98 v99} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}}}


 S695C3 ::~S695C3(){ note_dtor("S695C3", this);}
void  S695C3 ::v75(){vfunc_called(this, "_ZN6S695C33v75Ev");}
void  S695C3 ::v76(){vfunc_called(this, "_ZN6S695C33v76Ev");}
void  S695C3 ::v77(){vfunc_called(this, "_ZN6S695C33v77Ev");}
void  S695C3 ::v78(){vfunc_called(this, "_ZN6S695C33v78Ev");}
void  S695C3 ::v79(){vfunc_called(this, "_ZN6S695C33v79Ev");}
void  S695C3 ::v80(){vfunc_called(this, "_ZN6S695C33v80Ev");}
void  S695C3 ::v81(){vfunc_called(this, "_ZN6S695C33v81Ev");}
void  S695C3 ::v82(){vfunc_called(this, "_ZN6S695C33v82Ev");}
void  S695C3 ::v83(){vfunc_called(this, "_ZN6S695C33v83Ev");}
void  S695C3 ::v84(){vfunc_called(this, "_ZN6S695C33v84Ev");}
void  S695C3 ::v85(){vfunc_called(this, "_ZN6S695C33v85Ev");}
void  S695C3 ::v86(){vfunc_called(this, "_ZN6S695C33v86Ev");}
void  S695C3 ::v87(){vfunc_called(this, "_ZN6S695C33v87Ev");}
void  S695C3 ::v88(){vfunc_called(this, "_ZN6S695C33v88Ev");}
void  S695C3 ::v89(){vfunc_called(this, "_ZN6S695C33v89Ev");}
void  S695C3 ::v90(){vfunc_called(this, "_ZN6S695C33v90Ev");}
void  S695C3 ::v91(){vfunc_called(this, "_ZN6S695C33v91Ev");}
void  S695C3 ::v92(){vfunc_called(this, "_ZN6S695C33v92Ev");}
void  S695C3 ::v93(){vfunc_called(this, "_ZN6S695C33v93Ev");}
void  S695C3 ::v94(){vfunc_called(this, "_ZN6S695C33v94Ev");}
void  S695C3 ::v95(){vfunc_called(this, "_ZN6S695C33v95Ev");}
void  S695C3 ::v96(){vfunc_called(this, "_ZN6S695C33v96Ev");}
void  S695C3 ::v97(){vfunc_called(this, "_ZN6S695C33v97Ev");}
void  S695C3 ::v98(){vfunc_called(this, "_ZN6S695C33v98Ev");}
void  S695C3 ::v99(){vfunc_called(this, "_ZN6S695C33v99Ev");}
void  S695C3 ::v100(){vfunc_called(this, "_ZN6S695C34v100Ev");}
void  S695C3 ::v101(){vfunc_called(this, "_ZN6S695C34v101Ev");}
void  S695C3 ::v102(){vfunc_called(this, "_ZN6S695C34v102Ev");}
void  S695C3 ::v103(){vfunc_called(this, "_ZN6S695C34v103Ev");}
void  S695C3 ::v104(){vfunc_called(this, "_ZN6S695C34v104Ev");}
void  S695C3 ::v105(){vfunc_called(this, "_ZN6S695C34v105Ev");}
S695C3 ::S695C3(){ note_ctor("S695C3", this);} // tgen

static void Test_S695C3()
{
  extern Class_Descriptor cd_S695C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S695C3, buf);
    S695C3 *dp, &lv = *(dp=new (buf) S695C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S695C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C3)");
    check_base_class_offset(lv, (S695C5*)(S695C4*), 0, "S695C3");
    check_base_class_offset(lv, (S695C4*), 0, "S695C3");
    check_field_offset(lv, s695c3f0, ABISELECT(96,60), "S695C3.s695c3f0");
    test_class_info(&lv, &cd_S695C3);
    dp->~S695C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C3(Test_S695C3, "S695C3", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S695C3C1Ev();
extern void _ZN6S695C3D1Ev();
Name_Map name_map_S695C3[] = {
  NSPAIR(_ZN6S695C3C1Ev),
  NSPAIR(_ZN6S695C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S695C5;
extern VTBL_ENTRY _ZTI6S695C5[];
extern  VTBL_ENTRY _ZTV6S695C5[];
extern Class_Descriptor cd_S695C4;
extern VTBL_ENTRY _ZTI6S695C4[];
extern  VTBL_ENTRY _ZTV6S695C4[];
static Base_Class bases_S695C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S695C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S695C3[];
extern void _ZN6S695C3D1Ev();
extern void _ZN6S695C3D0Ev();
extern void _ZN6S695C52v7Ev();
extern void _ZN6S695C52v8Ev();
extern void _ZN6S695C52v9Ev();
extern void _ZN6S695C53v10Ev();
extern void _ZN6S695C53v11Ev();
extern void _ZN6S695C53v12Ev();
extern void _ZN6S695C53v13Ev();
extern void _ZN6S695C53v14Ev();
extern void _ZN6S695C53v15Ev();
extern void _ZN6S695C53v16Ev();
extern void _ZN6S695C53v17Ev();
extern void _ZN6S695C53v18Ev();
extern void _ZN6S695C53v19Ev();
extern void _ZN6S695C53v20Ev();
extern void _ZN6S695C53v21Ev();
extern void _ZN6S695C53v22Ev();
extern void _ZN6S695C53v23Ev();
extern void _ZN6S695C53v24Ev();
extern void _ZN6S695C53v25Ev();
extern void _ZN6S695C53v26Ev();
extern void _ZN6S695C53v27Ev();
extern void _ZN6S695C53v28Ev();
extern void _ZN6S695C53v29Ev();
extern void _ZN6S695C53v30Ev();
extern void _ZN6S695C53v31Ev();
extern void _ZN6S695C53v32Ev();
extern void _ZN6S695C53v33Ev();
extern void _ZN6S695C53v34Ev();
extern void _ZN6S695C53v35Ev();
extern void _ZN6S695C53v36Ev();
extern void _ZN6S695C53v37Ev();
extern void _ZN6S695C53v38Ev();
extern void _ZN6S695C53v39Ev();
extern void _ZN6S695C53v40Ev();
extern void _ZN6S695C53v41Ev();
extern void _ZN6S695C53v42Ev();
extern void _ZN6S695C53v43Ev();
extern void _ZN6S695C53v44Ev();
extern void _ZN6S695C53v45Ev();
extern void _ZN6S695C53v46Ev();
extern void _ZN6S695C53v47Ev();
extern void _ZN6S695C53v48Ev();
extern void _ZN6S695C53v49Ev();
extern void _ZN6S695C53v50Ev();
extern void _ZN6S695C53v51Ev();
extern void _ZN6S695C53v52Ev();
extern void _ZN6S695C53v53Ev();
extern void _ZN6S695C53v54Ev();
extern void _ZN6S695C53v55Ev();
extern void _ZN6S695C53v56Ev();
extern void _ZN6S695C53v57Ev();
extern void _ZN6S695C53v58Ev();
extern void _ZN6S695C53v59Ev();
extern void _ZN6S695C53v60Ev();
extern void _ZN6S695C53v61Ev();
extern void _ZN6S695C53v62Ev();
extern void _ZN6S695C53v63Ev();
extern void _ZN6S695C53v64Ev();
extern void _ZN6S695C53v65Ev();
extern void _ZN6S695C53v66Ev();
extern void _ZN6S695C53v67Ev();
extern void _ZN6S695C53v68Ev();
extern void _ZN6S695C53v69Ev();
extern void _ZN6S695C53v70Ev();
extern void _ZN6S695C43v71Ev();
extern void _ZN6S695C43v72Ev();
extern void _ZN6S695C43v73Ev();
extern void _ZN6S695C43v74Ev();
extern void _ZN6S695C33v75Ev();
extern void _ZN6S695C33v76Ev();
extern void _ZN6S695C33v77Ev();
extern void _ZN6S695C33v78Ev();
extern void _ZN6S695C33v79Ev();
extern void _ZN6S695C33v80Ev();
extern void _ZN6S695C33v81Ev();
extern void _ZN6S695C33v82Ev();
extern void _ZN6S695C33v83Ev();
extern void _ZN6S695C33v84Ev();
extern void _ZN6S695C33v85Ev();
extern void _ZN6S695C33v86Ev();
extern void _ZN6S695C33v87Ev();
extern void _ZN6S695C33v88Ev();
extern void _ZN6S695C33v89Ev();
extern void _ZN6S695C33v90Ev();
extern void _ZN6S695C33v91Ev();
extern void _ZN6S695C33v92Ev();
extern void _ZN6S695C33v93Ev();
extern void _ZN6S695C33v94Ev();
extern void _ZN6S695C33v95Ev();
extern void _ZN6S695C33v96Ev();
extern void _ZN6S695C33v97Ev();
extern void _ZN6S695C33v98Ev();
extern void _ZN6S695C33v99Ev();
extern void _ZN6S695C34v100Ev();
extern void _ZN6S695C34v101Ev();
extern void _ZN6S695C34v102Ev();
extern void _ZN6S695C34v103Ev();
extern void _ZN6S695C34v104Ev();
extern void _ZN6S695C34v105Ev();
static  VTBL_ENTRY vtc_S695C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S695C3[0]),
  (VTBL_ENTRY)&_ZN6S695C3D1Ev,
  (VTBL_ENTRY)&_ZN6S695C3D0Ev,
  (VTBL_ENTRY)&_ZN6S695C52v7Ev,
  (VTBL_ENTRY)&_ZN6S695C52v8Ev,
  (VTBL_ENTRY)&_ZN6S695C52v9Ev,
  (VTBL_ENTRY)&_ZN6S695C53v10Ev,
  (VTBL_ENTRY)&_ZN6S695C53v11Ev,
  (VTBL_ENTRY)&_ZN6S695C53v12Ev,
  (VTBL_ENTRY)&_ZN6S695C53v13Ev,
  (VTBL_ENTRY)&_ZN6S695C53v14Ev,
  (VTBL_ENTRY)&_ZN6S695C53v15Ev,
  (VTBL_ENTRY)&_ZN6S695C53v16Ev,
  (VTBL_ENTRY)&_ZN6S695C53v17Ev,
  (VTBL_ENTRY)&_ZN6S695C53v18Ev,
  (VTBL_ENTRY)&_ZN6S695C53v19Ev,
  (VTBL_ENTRY)&_ZN6S695C53v20Ev,
  (VTBL_ENTRY)&_ZN6S695C53v21Ev,
  (VTBL_ENTRY)&_ZN6S695C53v22Ev,
  (VTBL_ENTRY)&_ZN6S695C53v23Ev,
  (VTBL_ENTRY)&_ZN6S695C53v24Ev,
  (VTBL_ENTRY)&_ZN6S695C53v25Ev,
  (VTBL_ENTRY)&_ZN6S695C53v26Ev,
  (VTBL_ENTRY)&_ZN6S695C53v27Ev,
  (VTBL_ENTRY)&_ZN6S695C53v28Ev,
  (VTBL_ENTRY)&_ZN6S695C53v29Ev,
  (VTBL_ENTRY)&_ZN6S695C53v30Ev,
  (VTBL_ENTRY)&_ZN6S695C53v31Ev,
  (VTBL_ENTRY)&_ZN6S695C53v32Ev,
  (VTBL_ENTRY)&_ZN6S695C53v33Ev,
  (VTBL_ENTRY)&_ZN6S695C53v34Ev,
  (VTBL_ENTRY)&_ZN6S695C53v35Ev,
  (VTBL_ENTRY)&_ZN6S695C53v36Ev,
  (VTBL_ENTRY)&_ZN6S695C53v37Ev,
  (VTBL_ENTRY)&_ZN6S695C53v38Ev,
  (VTBL_ENTRY)&_ZN6S695C53v39Ev,
  (VTBL_ENTRY)&_ZN6S695C53v40Ev,
  (VTBL_ENTRY)&_ZN6S695C53v41Ev,
  (VTBL_ENTRY)&_ZN6S695C53v42Ev,
  (VTBL_ENTRY)&_ZN6S695C53v43Ev,
  (VTBL_ENTRY)&_ZN6S695C53v44Ev,
  (VTBL_ENTRY)&_ZN6S695C53v45Ev,
  (VTBL_ENTRY)&_ZN6S695C53v46Ev,
  (VTBL_ENTRY)&_ZN6S695C53v47Ev,
  (VTBL_ENTRY)&_ZN6S695C53v48Ev,
  (VTBL_ENTRY)&_ZN6S695C53v49Ev,
  (VTBL_ENTRY)&_ZN6S695C53v50Ev,
  (VTBL_ENTRY)&_ZN6S695C53v51Ev,
  (VTBL_ENTRY)&_ZN6S695C53v52Ev,
  (VTBL_ENTRY)&_ZN6S695C53v53Ev,
  (VTBL_ENTRY)&_ZN6S695C53v54Ev,
  (VTBL_ENTRY)&_ZN6S695C53v55Ev,
  (VTBL_ENTRY)&_ZN6S695C53v56Ev,
  (VTBL_ENTRY)&_ZN6S695C53v57Ev,
  (VTBL_ENTRY)&_ZN6S695C53v58Ev,
  (VTBL_ENTRY)&_ZN6S695C53v59Ev,
  (VTBL_ENTRY)&_ZN6S695C53v60Ev,
  (VTBL_ENTRY)&_ZN6S695C53v61Ev,
  (VTBL_ENTRY)&_ZN6S695C53v62Ev,
  (VTBL_ENTRY)&_ZN6S695C53v63Ev,
  (VTBL_ENTRY)&_ZN6S695C53v64Ev,
  (VTBL_ENTRY)&_ZN6S695C53v65Ev,
  (VTBL_ENTRY)&_ZN6S695C53v66Ev,
  (VTBL_ENTRY)&_ZN6S695C53v67Ev,
  (VTBL_ENTRY)&_ZN6S695C53v68Ev,
  (VTBL_ENTRY)&_ZN6S695C53v69Ev,
  (VTBL_ENTRY)&_ZN6S695C53v70Ev,
  (VTBL_ENTRY)&_ZN6S695C43v71Ev,
  (VTBL_ENTRY)&_ZN6S695C43v72Ev,
  (VTBL_ENTRY)&_ZN6S695C43v73Ev,
  (VTBL_ENTRY)&_ZN6S695C43v74Ev,
  (VTBL_ENTRY)&_ZN6S695C33v75Ev,
  (VTBL_ENTRY)&_ZN6S695C33v76Ev,
  (VTBL_ENTRY)&_ZN6S695C33v77Ev,
  (VTBL_ENTRY)&_ZN6S695C33v78Ev,
  (VTBL_ENTRY)&_ZN6S695C33v79Ev,
  (VTBL_ENTRY)&_ZN6S695C33v80Ev,
  (VTBL_ENTRY)&_ZN6S695C33v81Ev,
  (VTBL_ENTRY)&_ZN6S695C33v82Ev,
  (VTBL_ENTRY)&_ZN6S695C33v83Ev,
  (VTBL_ENTRY)&_ZN6S695C33v84Ev,
  (VTBL_ENTRY)&_ZN6S695C33v85Ev,
  (VTBL_ENTRY)&_ZN6S695C33v86Ev,
  (VTBL_ENTRY)&_ZN6S695C33v87Ev,
  (VTBL_ENTRY)&_ZN6S695C33v88Ev,
  (VTBL_ENTRY)&_ZN6S695C33v89Ev,
  (VTBL_ENTRY)&_ZN6S695C33v90Ev,
  (VTBL_ENTRY)&_ZN6S695C33v91Ev,
  (VTBL_ENTRY)&_ZN6S695C33v92Ev,
  (VTBL_ENTRY)&_ZN6S695C33v93Ev,
  (VTBL_ENTRY)&_ZN6S695C33v94Ev,
  (VTBL_ENTRY)&_ZN6S695C33v95Ev,
  (VTBL_ENTRY)&_ZN6S695C33v96Ev,
  (VTBL_ENTRY)&_ZN6S695C33v97Ev,
  (VTBL_ENTRY)&_ZN6S695C33v98Ev,
  (VTBL_ENTRY)&_ZN6S695C33v99Ev,
  (VTBL_ENTRY)&_ZN6S695C34v100Ev,
  (VTBL_ENTRY)&_ZN6S695C34v101Ev,
  (VTBL_ENTRY)&_ZN6S695C34v102Ev,
  (VTBL_ENTRY)&_ZN6S695C34v103Ev,
  (VTBL_ENTRY)&_ZN6S695C34v104Ev,
  (VTBL_ENTRY)&_ZN6S695C34v105Ev,
};
extern VTBL_ENTRY _ZTI6S695C3[];
extern  VTBL_ENTRY _ZTV6S695C3[];
Class_Descriptor cd_S695C3 = {  "S695C3", // class name
  bases_S695C3, 2,
  &(vtc_S695C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S695C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S695C3),103, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C13  {
  void *s695c13f0;
  int s695c13f1[6];
  void  mf695c13(); // _ZN7S695C138mf695c13Ev
};
//SIG(-1 S695C13) C1{ m Fp Fi[6]}


void  S695C13 ::mf695c13(){}

static void Test_S695C13()
{
  {
    init_simple_test("S695C13");
    S695C13 lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(S695C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C13)");
    check_field_offset(lv, s695c13f0, 0, "S695C13.s695c13f0");
    check_field_offset(lv, s695c13f1, ABISELECT(8,4), "S695C13.s695c13f1");
  }
}
static Arrange_To_Call_Me vS695C13(Test_S695C13, "S695C13", ABISELECT(32,28));

#else // __cplusplus

Class_Descriptor cd_S695C13 = {  "S695C13", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(32,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C12  : S695C13 {
  unsigned int s695c12f0:1;
  ::S685C23_nt s695c12f1;
};
//SIG(-1 S695C12) C1{ BC2{ m Fp Fi[6]} Fi:1 FC3{ m}}



static void Test_S695C12()
{
  extern Class_Descriptor cd_S695C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_S695C12, buf);
    S695C12 &lv = *(new (buf) S695C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(S695C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C12)");
    check_base_class_offset(lv, (S695C13*), 0, "S695C12");
    set_bf_and_test(lv, s695c12f0, ABISELECT(32,28), 0, 1, 1, "S695C12");
    check_field_offset(lv, s695c12f1, ABISELECT(33,29), "S695C12.s695c12f1");
    test_class_info(&lv, &cd_S695C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C12(Test_S695C12, "S695C12", ABISELECT(40,32));

#else // __cplusplus

extern Class_Descriptor cd_S695C13;
static Base_Class bases_S695C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S695C12 = {  "S695C12", // class name
  bases_S695C12, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,32), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C11  : S695C12 {
};
//SIG(-1 S695C11) C1{ BC2{ BC3{ m Fp Fi[6]} Fi:1 FC4{ m}}}



static void Test_S695C11()
{
  extern Class_Descriptor cd_S695C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_S695C11, buf);
    S695C11 &lv = *(new (buf) S695C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(S695C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C11)");
    check_base_class_offset(lv, (S695C13*)(S695C12*), 0, "S695C11");
    check_base_class_offset(lv, (S695C12*), 0, "S695C11");
    test_class_info(&lv, &cd_S695C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C11(Test_S695C11, "S695C11", ABISELECT(40,32));

#else // __cplusplus

extern Class_Descriptor cd_S695C13;
extern Class_Descriptor cd_S695C12;
static Base_Class bases_S695C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S695C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S695C11 = {  "S695C11", // class name
  bases_S695C11, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,32), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C16  : S695C13 {
  unsigned int s695c16f0:1;
  int s695c16f1;
};
//SIG(-1 S695C16) C1{ BC2{ m Fp Fi[6]} Fi:1 Fi}



static void Test_S695C16()
{
  extern Class_Descriptor cd_S695C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,10)];
    init_test(&cd_S695C16, buf);
    S695C16 &lv = *(new (buf) S695C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,36), "sizeof(S695C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C16)");
    check_base_class_offset(lv, (S695C13*), 0, "S695C16");
    set_bf_and_test(lv, s695c16f0, ABISELECT(32,28), 0, 1, 1, "S695C16");
    check_field_offset(lv, s695c16f1, ABISELECT(36,32), "S695C16.s695c16f1");
    test_class_info(&lv, &cd_S695C16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C16(Test_S695C16, "S695C16", ABISELECT(40,36));

#else // __cplusplus

extern Class_Descriptor cd_S695C13;
static Base_Class bases_S695C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S695C16 = {  "S695C16", // class name
  bases_S695C16, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,36), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C15  : S695C16 {
};
//SIG(-1 S695C15) C1{ BC2{ BC3{ m Fp Fi[6]} Fi:1 Fi}}



static void Test_S695C15()
{
  extern Class_Descriptor cd_S695C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,10)];
    init_test(&cd_S695C15, buf);
    S695C15 &lv = *(new (buf) S695C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,36), "sizeof(S695C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C15)");
    check_base_class_offset(lv, (S695C13*)(S695C16*), 0, "S695C15");
    check_base_class_offset(lv, (S695C16*), 0, "S695C15");
    test_class_info(&lv, &cd_S695C15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C15(Test_S695C15, "S695C15", ABISELECT(40,36));

#else // __cplusplus

extern Class_Descriptor cd_S695C13;
extern Class_Descriptor cd_S695C16;
static Base_Class bases_S695C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S695C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S695C15 = {  "S695C15", // class name
  bases_S695C15, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,36), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C18  : S695C13 {
  unsigned int s695c18f0:1;
  ::S685C15_nt s695c18f1;
};
//SIG(-1 S695C18) C1{ BC2{ m Fp Fi[6]} Fi:1 FC3{ m Fi[3]}}



static void Test_S695C18()
{
  extern Class_Descriptor cd_S695C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,12)];
    init_test(&cd_S695C18, buf);
    S695C18 &lv = *(new (buf) S695C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,44), "sizeof(S695C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C18)");
    check_base_class_offset(lv, (S695C13*), 0, "S695C18");
    set_bf_and_test(lv, s695c18f0, ABISELECT(32,28), 0, 1, 1, "S695C18");
    check_field_offset(lv, s695c18f1, ABISELECT(36,32), "S695C18.s695c18f1");
    test_class_info(&lv, &cd_S695C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C18(Test_S695C18, "S695C18", ABISELECT(48,44));

#else // __cplusplus

extern Class_Descriptor cd_S695C13;
static Base_Class bases_S695C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S695C18 = {  "S695C18", // class name
  bases_S695C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,44), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C17  : S695C18 {
};
//SIG(-1 S695C17) C1{ BC2{ BC3{ m Fp Fi[6]} Fi:1 FC4{ m Fi[3]}}}



static void Test_S695C17()
{
  extern Class_Descriptor cd_S695C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,12)];
    init_test(&cd_S695C17, buf);
    S695C17 &lv = *(new (buf) S695C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,44), "sizeof(S695C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C17)");
    check_base_class_offset(lv, (S695C13*)(S695C18*), 0, "S695C17");
    check_base_class_offset(lv, (S695C18*), 0, "S695C17");
    test_class_info(&lv, &cd_S695C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C17(Test_S695C17, "S695C17", ABISELECT(48,44));

#else // __cplusplus

extern Class_Descriptor cd_S695C13;
extern Class_Descriptor cd_S695C18;
static Base_Class bases_S695C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S695C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S695C17 = {  "S695C17", // class name
  bases_S695C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,44), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C22_nt  {
  int s695c22f0[2];
  void  mf695c22(); // _ZN10S695C22_nt8mf695c22Ev
};
//SIG(-1 S695C22_nt) C1{ m Fi[2]}


void  S695C22_nt ::mf695c22(){}

//skip512 S695C22_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C21  : S695C13 {
  unsigned int s695c21f0:1;
  ::S695C22_nt s695c21f1;
};
//SIG(-1 S695C21) C1{ BC2{ m Fp Fi[6]} Fi:1 FC3{ m Fi[2]}}



static void Test_S695C21()
{
  extern Class_Descriptor cd_S695C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,11)];
    init_test(&cd_S695C21, buf);
    S695C21 &lv = *(new (buf) S695C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S695C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C21)");
    check_base_class_offset(lv, (S695C13*), 0, "S695C21");
    set_bf_and_test(lv, s695c21f0, ABISELECT(32,28), 0, 1, 1, "S695C21");
    check_field_offset(lv, s695c21f1, ABISELECT(36,32), "S695C21.s695c21f1");
    test_class_info(&lv, &cd_S695C21);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C21(Test_S695C21, "S695C21", ABISELECT(48,40));

#else // __cplusplus

extern Class_Descriptor cd_S695C13;
static Base_Class bases_S695C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S695C21 = {  "S695C21", // class name
  bases_S695C21, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,40), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C20  : S695C21 {
};
//SIG(-1 S695C20) C1{ BC2{ BC3{ m Fp Fi[6]} Fi:1 FC4{ m Fi[2]}}}



static void Test_S695C20()
{
  extern Class_Descriptor cd_S695C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,11)];
    init_test(&cd_S695C20, buf);
    S695C20 &lv = *(new (buf) S695C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S695C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C20)");
    check_base_class_offset(lv, (S695C13*)(S695C21*), 0, "S695C20");
    check_base_class_offset(lv, (S695C21*), 0, "S695C20");
    test_class_info(&lv, &cd_S695C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C20(Test_S695C20, "S695C20", ABISELECT(48,40));

#else // __cplusplus

extern Class_Descriptor cd_S695C13;
extern Class_Descriptor cd_S695C21;
static Base_Class bases_S695C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S695C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S695C20 = {  "S695C20", // class name
  bases_S695C20, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,40), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C2  : S695C3 {
  void *s695c2f0[2];
  ::S695C11 s695c2f1;
  ::S695C11 s695c2f2;
  ::S695C15 s695c2f3;
  ::S695C17 s695c2f4;
  ::S695C11 s695c2f5;
  ::S695C15 s695c2f6;
  ::S695C15 s695c2f7;
  int s695c2f8;
  ::S695C20 s695c2f9;
  char s695c2f10[2];
  ::S695C11 s695c2f11;
  ::S695C15 s695c2f12;
  ::S695C11 s695c2f13;
  unsigned int s695c2f14:1;
  unsigned int s695c2f15:1;
  unsigned int s695c2f16:1;
  unsigned int s695c2f17:1;
  unsigned int s695c2f18:1;
  unsigned int s695c2f19:1;
  unsigned int s695c2f20:1;
  unsigned int s695c2f21:1;
  unsigned int s695c2f22:1;
  unsigned int s695c2f23:1;
  unsigned int s695c2f24:1;
  unsigned int s695c2f25:1;
  unsigned int s695c2f26:1;
  unsigned int s695c2f27:1;
  unsigned int s695c2f28:1;
  unsigned int s695c2f29:1;
  unsigned int s695c2f30:1;
  unsigned int s695c2f31:1;
  unsigned int s695c2f32:1;
  unsigned int s695c2f33:1;
  unsigned int s695c2f34:1;
  void *s695c2f35[5];
  int s695c2f36[4];
  ::S685C39 s695c2f37;
  ::S685C34 s695c2f38;
  ::S685C28 s695c2f39;
  unsigned int s695c2f40:1;
  ::S685C24 s695c2f41;
  virtual  ~S695C2(); // _ZN6S695C2D1Ev
  virtual void  v106(); // _ZN6S695C24v106Ev
  virtual void  v107(); // _ZN6S695C24v107Ev
  virtual void  v108(); // _ZN6S695C24v108Ev
  virtual void  v109(); // _ZN6S695C24v109Ev
  virtual void  v110(); // _ZN6S695C24v110Ev
  virtual void  v111(); // _ZN6S695C24v111Ev
  virtual void  v112(); // _ZN6S695C24v112Ev
  virtual void  v113(); // _ZN6S695C24v113Ev
  virtual void  v114(); // _ZN6S695C24v114Ev
  virtual void  v115(); // _ZN6S695C24v115Ev
  virtual void  v116(); // _ZN6S695C24v116Ev
  virtual void  v117(); // _ZN6S695C24v117Ev
  virtual void  v118(); // _ZN6S695C24v118Ev
  virtual void  v119(); // _ZN6S695C24v119Ev
  virtual void  v120(); // _ZN6S695C24v120Ev
  virtual void  v121(); // _ZN6S695C24v121Ev
  virtual void  v122(); // _ZN6S695C24v122Ev
  virtual void  v123(); // _ZN6S695C24v123Ev
  virtual void  v124(); // _ZN6S695C24v124Ev
  virtual void  v125(); // _ZN6S695C24v125Ev
  virtual void  v126(); // _ZN6S695C24v126Ev
  virtual void  v127(); // _ZN6S695C24v127Ev
  virtual void  v128(); // _ZN6S695C24v128Ev
  virtual void  v129(); // _ZN6S695C24v129Ev
  virtual void  v130(); // _ZN6S695C24v130Ev
  virtual void  v131(); // _ZN6S695C24v131Ev
  virtual void  v132(); // _ZN6S695C24v132Ev
  virtual void  v133(); // _ZN6S695C24v133Ev
  virtual void  v134(); // _ZN6S695C24v134Ev
  virtual void  v135(); // _ZN6S695C24v135Ev
  virtual void  v136(); // _ZN6S695C24v136Ev
  virtual void  v137(); // _ZN6S695C24v137Ev
  virtual void  v138(); // _ZN6S695C24v138Ev
  virtual void  v139(); // _ZN6S695C24v139Ev
  virtual void  v140(); // _ZN6S695C24v140Ev
  virtual void  v141(); // _ZN6S695C24v141Ev
  virtual void  v142(); // _ZN6S695C24v142Ev
  virtual void  v143(); // _ZN6S695C24v143Ev
  virtual void  v144(); // _ZN6S695C24v144Ev
  virtual void  v145(); // _ZN6S695C24v145Ev
  virtual void  v146(); // _ZN6S695C24v146Ev
  virtual void  v147(); // _ZN6S695C24v147Ev
  virtual void  v148(); // _ZN6S695C24v148Ev
  virtual void  v149(); // _ZN6S695C24v149Ev
  S695C2(); // tgen
};
//SIG(-1 S695C2) C1{ BC2{ BC3{ BC4{ vd v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v109 v110 v111 v112} vd v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp[2] FC10{ BC11{ BC12{ m Fp Fi[6]} Fi:1 FC13{ m}}} FC10 FC14{ BC15{ BC12 Fi:1 Fi}} FC16{ BC17{ BC12 Fi:1 FC18{ m Fi[3]}}} FC10 FC14 FC14 Fi FC19{ BC20{ BC12 Fi:1 FC21{ m Fi[2]}}} Fc[2] FC10 FC14 FC10 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[5] Fi[4] FC22{ BC23{ BC9}} FC24{ BC25{ BC9}} FC7 Fi:1 FC26{ BC27{ BC9}}}


 S695C2 ::~S695C2(){ note_dtor("S695C2", this);}
void  S695C2 ::v106(){vfunc_called(this, "_ZN6S695C24v106Ev");}
void  S695C2 ::v107(){vfunc_called(this, "_ZN6S695C24v107Ev");}
void  S695C2 ::v108(){vfunc_called(this, "_ZN6S695C24v108Ev");}
void  S695C2 ::v109(){vfunc_called(this, "_ZN6S695C24v109Ev");}
void  S695C2 ::v110(){vfunc_called(this, "_ZN6S695C24v110Ev");}
void  S695C2 ::v111(){vfunc_called(this, "_ZN6S695C24v111Ev");}
void  S695C2 ::v112(){vfunc_called(this, "_ZN6S695C24v112Ev");}
void  S695C2 ::v113(){vfunc_called(this, "_ZN6S695C24v113Ev");}
void  S695C2 ::v114(){vfunc_called(this, "_ZN6S695C24v114Ev");}
void  S695C2 ::v115(){vfunc_called(this, "_ZN6S695C24v115Ev");}
void  S695C2 ::v116(){vfunc_called(this, "_ZN6S695C24v116Ev");}
void  S695C2 ::v117(){vfunc_called(this, "_ZN6S695C24v117Ev");}
void  S695C2 ::v118(){vfunc_called(this, "_ZN6S695C24v118Ev");}
void  S695C2 ::v119(){vfunc_called(this, "_ZN6S695C24v119Ev");}
void  S695C2 ::v120(){vfunc_called(this, "_ZN6S695C24v120Ev");}
void  S695C2 ::v121(){vfunc_called(this, "_ZN6S695C24v121Ev");}
void  S695C2 ::v122(){vfunc_called(this, "_ZN6S695C24v122Ev");}
void  S695C2 ::v123(){vfunc_called(this, "_ZN6S695C24v123Ev");}
void  S695C2 ::v124(){vfunc_called(this, "_ZN6S695C24v124Ev");}
void  S695C2 ::v125(){vfunc_called(this, "_ZN6S695C24v125Ev");}
void  S695C2 ::v126(){vfunc_called(this, "_ZN6S695C24v126Ev");}
void  S695C2 ::v127(){vfunc_called(this, "_ZN6S695C24v127Ev");}
void  S695C2 ::v128(){vfunc_called(this, "_ZN6S695C24v128Ev");}
void  S695C2 ::v129(){vfunc_called(this, "_ZN6S695C24v129Ev");}
void  S695C2 ::v130(){vfunc_called(this, "_ZN6S695C24v130Ev");}
void  S695C2 ::v131(){vfunc_called(this, "_ZN6S695C24v131Ev");}
void  S695C2 ::v132(){vfunc_called(this, "_ZN6S695C24v132Ev");}
void  S695C2 ::v133(){vfunc_called(this, "_ZN6S695C24v133Ev");}
void  S695C2 ::v134(){vfunc_called(this, "_ZN6S695C24v134Ev");}
void  S695C2 ::v135(){vfunc_called(this, "_ZN6S695C24v135Ev");}
void  S695C2 ::v136(){vfunc_called(this, "_ZN6S695C24v136Ev");}
void  S695C2 ::v137(){vfunc_called(this, "_ZN6S695C24v137Ev");}
void  S695C2 ::v138(){vfunc_called(this, "_ZN6S695C24v138Ev");}
void  S695C2 ::v139(){vfunc_called(this, "_ZN6S695C24v139Ev");}
void  S695C2 ::v140(){vfunc_called(this, "_ZN6S695C24v140Ev");}
void  S695C2 ::v141(){vfunc_called(this, "_ZN6S695C24v141Ev");}
void  S695C2 ::v142(){vfunc_called(this, "_ZN6S695C24v142Ev");}
void  S695C2 ::v143(){vfunc_called(this, "_ZN6S695C24v143Ev");}
void  S695C2 ::v144(){vfunc_called(this, "_ZN6S695C24v144Ev");}
void  S695C2 ::v145(){vfunc_called(this, "_ZN6S695C24v145Ev");}
void  S695C2 ::v146(){vfunc_called(this, "_ZN6S695C24v146Ev");}
void  S695C2 ::v147(){vfunc_called(this, "_ZN6S695C24v147Ev");}
void  S695C2 ::v148(){vfunc_called(this, "_ZN6S695C24v148Ev");}
void  S695C2 ::v149(){vfunc_called(this, "_ZN6S695C24v149Ev");}
S695C2 ::S695C2(){ note_ctor("S695C2", this);} // tgen

static void Test_S695C2()
{
  extern Class_Descriptor cd_S695C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(93,143)];
    init_test(&cd_S695C2, buf);
    S695C2 *dp, &lv = *(dp=new (buf) S695C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(736,568), "sizeof(S695C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C2)");
    check_base_class_offset(lv, (S695C5*)(S695C4*)(S695C3*), 0, "S695C2");
    check_base_class_offset(lv, (S695C4*)(S695C3*), 0, "S695C2");
    check_base_class_offset(lv, (S695C3*), 0, "S695C2");
    check_field_offset(lv, s695c2f0, ABISELECT(112,72), "S695C2.s695c2f0");
    check_field_offset(lv, s695c2f1, ABISELECT(128,80), "S695C2.s695c2f1");
    check_field_offset(lv, s695c2f2, ABISELECT(168,112), "S695C2.s695c2f2");
    check_field_offset(lv, s695c2f3, ABISELECT(208,144), "S695C2.s695c2f3");
    check_field_offset(lv, s695c2f4, ABISELECT(248,180), "S695C2.s695c2f4");
    check_field_offset(lv, s695c2f5, ABISELECT(296,224), "S695C2.s695c2f5");
    check_field_offset(lv, s695c2f6, ABISELECT(336,256), "S695C2.s695c2f6");
    check_field_offset(lv, s695c2f7, ABISELECT(376,292), "S695C2.s695c2f7");
    check_field_offset(lv, s695c2f8, ABISELECT(416,328), "S695C2.s695c2f8");
    check_field_offset(lv, s695c2f9, ABISELECT(424,332), "S695C2.s695c2f9");
    check_field_offset(lv, s695c2f10, ABISELECT(472,372), "S695C2.s695c2f10");
    check_field_offset(lv, s695c2f11, ABISELECT(480,376), "S695C2.s695c2f11");
    check_field_offset(lv, s695c2f12, ABISELECT(520,408), "S695C2.s695c2f12");
    check_field_offset(lv, s695c2f13, ABISELECT(560,444), "S695C2.s695c2f13");
    set_bf_and_test(lv, s695c2f14, ABISELECT(600,476), 0, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f15, ABISELECT(600,476), 1, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f16, ABISELECT(600,476), 2, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f17, ABISELECT(600,476), 3, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f18, ABISELECT(600,476), 4, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f19, ABISELECT(600,476), 5, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f20, ABISELECT(600,476), 6, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f21, ABISELECT(600,476), 7, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f22, ABISELECT(601,477), 0, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f23, ABISELECT(601,477), 1, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f24, ABISELECT(601,477), 2, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f25, ABISELECT(601,477), 3, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f26, ABISELECT(601,477), 4, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f27, ABISELECT(601,477), 5, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f28, ABISELECT(601,477), 6, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f29, ABISELECT(601,477), 7, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f30, ABISELECT(602,478), 0, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f31, ABISELECT(602,478), 1, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f32, ABISELECT(602,478), 2, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f33, ABISELECT(602,478), 3, 1, 1, "S695C2");
    set_bf_and_test(lv, s695c2f34, ABISELECT(602,478), 4, 1, 1, "S695C2");
    check_field_offset(lv, s695c2f35, ABISELECT(608,480), "S695C2.s695c2f35");
    check_field_offset(lv, s695c2f36, ABISELECT(648,500), "S695C2.s695c2f36");
    check_field_offset(lv, s695c2f37, ABISELECT(664,516), "S695C2.s695c2f37");
    check_field_offset(lv, s695c2f38, ABISELECT(680,528), "S695C2.s695c2f38");
    check_field_offset(lv, s695c2f39, ABISELECT(696,540), "S695C2.s695c2f39");
    set_bf_and_test(lv, s695c2f40, ABISELECT(712,552), 0, 1, 1, "S695C2");
    check_field_offset(lv, s695c2f41, ABISELECT(720,556), "S695C2.s695c2f41");
    test_class_info(&lv, &cd_S695C2);
    dp->~S695C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C2(Test_S695C2, "S695C2", ABISELECT(736,568));

#else // __cplusplus

extern void _ZN6S695C2C1Ev();
extern void _ZN6S695C2D1Ev();
Name_Map name_map_S695C2[] = {
  NSPAIR(_ZN6S695C2C1Ev),
  NSPAIR(_ZN6S695C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S695C5;
extern VTBL_ENTRY _ZTI6S695C5[];
extern  VTBL_ENTRY _ZTV6S695C5[];
extern Class_Descriptor cd_S695C4;
extern VTBL_ENTRY _ZTI6S695C4[];
extern  VTBL_ENTRY _ZTV6S695C4[];
extern Class_Descriptor cd_S695C3;
extern VTBL_ENTRY _ZTI6S695C3[];
extern  VTBL_ENTRY _ZTV6S695C3[];
static Base_Class bases_S695C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S695C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S695C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S695C2[];
extern void _ZN6S695C2D1Ev();
extern void _ZN6S695C2D0Ev();
extern void _ZN6S695C52v7Ev();
extern void _ZN6S695C52v8Ev();
extern void _ZN6S695C52v9Ev();
extern void _ZN6S695C53v10Ev();
extern void _ZN6S695C53v11Ev();
extern void _ZN6S695C53v12Ev();
extern void _ZN6S695C53v13Ev();
extern void _ZN6S695C53v14Ev();
extern void _ZN6S695C53v15Ev();
extern void _ZN6S695C53v16Ev();
extern void _ZN6S695C53v17Ev();
extern void _ZN6S695C53v18Ev();
extern void _ZN6S695C53v19Ev();
extern void _ZN6S695C53v20Ev();
extern void _ZN6S695C53v21Ev();
extern void _ZN6S695C53v22Ev();
extern void _ZN6S695C53v23Ev();
extern void _ZN6S695C53v24Ev();
extern void _ZN6S695C53v25Ev();
extern void _ZN6S695C53v26Ev();
extern void _ZN6S695C53v27Ev();
extern void _ZN6S695C53v28Ev();
extern void _ZN6S695C53v29Ev();
extern void _ZN6S695C53v30Ev();
extern void _ZN6S695C53v31Ev();
extern void _ZN6S695C53v32Ev();
extern void _ZN6S695C53v33Ev();
extern void _ZN6S695C53v34Ev();
extern void _ZN6S695C53v35Ev();
extern void _ZN6S695C53v36Ev();
extern void _ZN6S695C53v37Ev();
extern void _ZN6S695C53v38Ev();
extern void _ZN6S695C53v39Ev();
extern void _ZN6S695C53v40Ev();
extern void _ZN6S695C53v41Ev();
extern void _ZN6S695C53v42Ev();
extern void _ZN6S695C53v43Ev();
extern void _ZN6S695C53v44Ev();
extern void _ZN6S695C53v45Ev();
extern void _ZN6S695C53v46Ev();
extern void _ZN6S695C53v47Ev();
extern void _ZN6S695C53v48Ev();
extern void _ZN6S695C53v49Ev();
extern void _ZN6S695C53v50Ev();
extern void _ZN6S695C53v51Ev();
extern void _ZN6S695C53v52Ev();
extern void _ZN6S695C53v53Ev();
extern void _ZN6S695C53v54Ev();
extern void _ZN6S695C53v55Ev();
extern void _ZN6S695C53v56Ev();
extern void _ZN6S695C53v57Ev();
extern void _ZN6S695C53v58Ev();
extern void _ZN6S695C53v59Ev();
extern void _ZN6S695C53v60Ev();
extern void _ZN6S695C53v61Ev();
extern void _ZN6S695C53v62Ev();
extern void _ZN6S695C53v63Ev();
extern void _ZN6S695C53v64Ev();
extern void _ZN6S695C53v65Ev();
extern void _ZN6S695C53v66Ev();
extern void _ZN6S695C53v67Ev();
extern void _ZN6S695C53v68Ev();
extern void _ZN6S695C53v69Ev();
extern void _ZN6S695C53v70Ev();
extern void _ZN6S695C43v71Ev();
extern void _ZN6S695C43v72Ev();
extern void _ZN6S695C43v73Ev();
extern void _ZN6S695C43v74Ev();
extern void _ZN6S695C33v75Ev();
extern void _ZN6S695C33v76Ev();
extern void _ZN6S695C33v77Ev();
extern void _ZN6S695C33v78Ev();
extern void _ZN6S695C33v79Ev();
extern void _ZN6S695C33v80Ev();
extern void _ZN6S695C33v81Ev();
extern void _ZN6S695C33v82Ev();
extern void _ZN6S695C33v83Ev();
extern void _ZN6S695C33v84Ev();
extern void _ZN6S695C33v85Ev();
extern void _ZN6S695C33v86Ev();
extern void _ZN6S695C33v87Ev();
extern void _ZN6S695C33v88Ev();
extern void _ZN6S695C33v89Ev();
extern void _ZN6S695C33v90Ev();
extern void _ZN6S695C33v91Ev();
extern void _ZN6S695C33v92Ev();
extern void _ZN6S695C33v93Ev();
extern void _ZN6S695C33v94Ev();
extern void _ZN6S695C33v95Ev();
extern void _ZN6S695C33v96Ev();
extern void _ZN6S695C33v97Ev();
extern void _ZN6S695C33v98Ev();
extern void _ZN6S695C33v99Ev();
extern void _ZN6S695C34v100Ev();
extern void _ZN6S695C34v101Ev();
extern void _ZN6S695C34v102Ev();
extern void _ZN6S695C34v103Ev();
extern void _ZN6S695C34v104Ev();
extern void _ZN6S695C34v105Ev();
extern void _ZN6S695C24v106Ev();
extern void _ZN6S695C24v107Ev();
extern void _ZN6S695C24v108Ev();
extern void _ZN6S695C24v109Ev();
extern void _ZN6S695C24v110Ev();
extern void _ZN6S695C24v111Ev();
extern void _ZN6S695C24v112Ev();
extern void _ZN6S695C24v113Ev();
extern void _ZN6S695C24v114Ev();
extern void _ZN6S695C24v115Ev();
extern void _ZN6S695C24v116Ev();
extern void _ZN6S695C24v117Ev();
extern void _ZN6S695C24v118Ev();
extern void _ZN6S695C24v119Ev();
extern void _ZN6S695C24v120Ev();
extern void _ZN6S695C24v121Ev();
extern void _ZN6S695C24v122Ev();
extern void _ZN6S695C24v123Ev();
extern void _ZN6S695C24v124Ev();
extern void _ZN6S695C24v125Ev();
extern void _ZN6S695C24v126Ev();
extern void _ZN6S695C24v127Ev();
extern void _ZN6S695C24v128Ev();
extern void _ZN6S695C24v129Ev();
extern void _ZN6S695C24v130Ev();
extern void _ZN6S695C24v131Ev();
extern void _ZN6S695C24v132Ev();
extern void _ZN6S695C24v133Ev();
extern void _ZN6S695C24v134Ev();
extern void _ZN6S695C24v135Ev();
extern void _ZN6S695C24v136Ev();
extern void _ZN6S695C24v137Ev();
extern void _ZN6S695C24v138Ev();
extern void _ZN6S695C24v139Ev();
extern void _ZN6S695C24v140Ev();
extern void _ZN6S695C24v141Ev();
extern void _ZN6S695C24v142Ev();
extern void _ZN6S695C24v143Ev();
extern void _ZN6S695C24v144Ev();
extern void _ZN6S695C24v145Ev();
extern void _ZN6S695C24v146Ev();
extern void _ZN6S695C24v147Ev();
extern void _ZN6S695C24v148Ev();
extern void _ZN6S695C24v149Ev();
static  VTBL_ENTRY vtc_S695C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S695C2[0]),
  (VTBL_ENTRY)&_ZN6S695C2D1Ev,
  (VTBL_ENTRY)&_ZN6S695C2D0Ev,
  (VTBL_ENTRY)&_ZN6S695C52v7Ev,
  (VTBL_ENTRY)&_ZN6S695C52v8Ev,
  (VTBL_ENTRY)&_ZN6S695C52v9Ev,
  (VTBL_ENTRY)&_ZN6S695C53v10Ev,
  (VTBL_ENTRY)&_ZN6S695C53v11Ev,
  (VTBL_ENTRY)&_ZN6S695C53v12Ev,
  (VTBL_ENTRY)&_ZN6S695C53v13Ev,
  (VTBL_ENTRY)&_ZN6S695C53v14Ev,
  (VTBL_ENTRY)&_ZN6S695C53v15Ev,
  (VTBL_ENTRY)&_ZN6S695C53v16Ev,
  (VTBL_ENTRY)&_ZN6S695C53v17Ev,
  (VTBL_ENTRY)&_ZN6S695C53v18Ev,
  (VTBL_ENTRY)&_ZN6S695C53v19Ev,
  (VTBL_ENTRY)&_ZN6S695C53v20Ev,
  (VTBL_ENTRY)&_ZN6S695C53v21Ev,
  (VTBL_ENTRY)&_ZN6S695C53v22Ev,
  (VTBL_ENTRY)&_ZN6S695C53v23Ev,
  (VTBL_ENTRY)&_ZN6S695C53v24Ev,
  (VTBL_ENTRY)&_ZN6S695C53v25Ev,
  (VTBL_ENTRY)&_ZN6S695C53v26Ev,
  (VTBL_ENTRY)&_ZN6S695C53v27Ev,
  (VTBL_ENTRY)&_ZN6S695C53v28Ev,
  (VTBL_ENTRY)&_ZN6S695C53v29Ev,
  (VTBL_ENTRY)&_ZN6S695C53v30Ev,
  (VTBL_ENTRY)&_ZN6S695C53v31Ev,
  (VTBL_ENTRY)&_ZN6S695C53v32Ev,
  (VTBL_ENTRY)&_ZN6S695C53v33Ev,
  (VTBL_ENTRY)&_ZN6S695C53v34Ev,
  (VTBL_ENTRY)&_ZN6S695C53v35Ev,
  (VTBL_ENTRY)&_ZN6S695C53v36Ev,
  (VTBL_ENTRY)&_ZN6S695C53v37Ev,
  (VTBL_ENTRY)&_ZN6S695C53v38Ev,
  (VTBL_ENTRY)&_ZN6S695C53v39Ev,
  (VTBL_ENTRY)&_ZN6S695C53v40Ev,
  (VTBL_ENTRY)&_ZN6S695C53v41Ev,
  (VTBL_ENTRY)&_ZN6S695C53v42Ev,
  (VTBL_ENTRY)&_ZN6S695C53v43Ev,
  (VTBL_ENTRY)&_ZN6S695C53v44Ev,
  (VTBL_ENTRY)&_ZN6S695C53v45Ev,
  (VTBL_ENTRY)&_ZN6S695C53v46Ev,
  (VTBL_ENTRY)&_ZN6S695C53v47Ev,
  (VTBL_ENTRY)&_ZN6S695C53v48Ev,
  (VTBL_ENTRY)&_ZN6S695C53v49Ev,
  (VTBL_ENTRY)&_ZN6S695C53v50Ev,
  (VTBL_ENTRY)&_ZN6S695C53v51Ev,
  (VTBL_ENTRY)&_ZN6S695C53v52Ev,
  (VTBL_ENTRY)&_ZN6S695C53v53Ev,
  (VTBL_ENTRY)&_ZN6S695C53v54Ev,
  (VTBL_ENTRY)&_ZN6S695C53v55Ev,
  (VTBL_ENTRY)&_ZN6S695C53v56Ev,
  (VTBL_ENTRY)&_ZN6S695C53v57Ev,
  (VTBL_ENTRY)&_ZN6S695C53v58Ev,
  (VTBL_ENTRY)&_ZN6S695C53v59Ev,
  (VTBL_ENTRY)&_ZN6S695C53v60Ev,
  (VTBL_ENTRY)&_ZN6S695C53v61Ev,
  (VTBL_ENTRY)&_ZN6S695C53v62Ev,
  (VTBL_ENTRY)&_ZN6S695C53v63Ev,
  (VTBL_ENTRY)&_ZN6S695C53v64Ev,
  (VTBL_ENTRY)&_ZN6S695C53v65Ev,
  (VTBL_ENTRY)&_ZN6S695C53v66Ev,
  (VTBL_ENTRY)&_ZN6S695C53v67Ev,
  (VTBL_ENTRY)&_ZN6S695C53v68Ev,
  (VTBL_ENTRY)&_ZN6S695C53v69Ev,
  (VTBL_ENTRY)&_ZN6S695C53v70Ev,
  (VTBL_ENTRY)&_ZN6S695C43v71Ev,
  (VTBL_ENTRY)&_ZN6S695C43v72Ev,
  (VTBL_ENTRY)&_ZN6S695C43v73Ev,
  (VTBL_ENTRY)&_ZN6S695C43v74Ev,
  (VTBL_ENTRY)&_ZN6S695C33v75Ev,
  (VTBL_ENTRY)&_ZN6S695C33v76Ev,
  (VTBL_ENTRY)&_ZN6S695C33v77Ev,
  (VTBL_ENTRY)&_ZN6S695C33v78Ev,
  (VTBL_ENTRY)&_ZN6S695C33v79Ev,
  (VTBL_ENTRY)&_ZN6S695C33v80Ev,
  (VTBL_ENTRY)&_ZN6S695C33v81Ev,
  (VTBL_ENTRY)&_ZN6S695C33v82Ev,
  (VTBL_ENTRY)&_ZN6S695C33v83Ev,
  (VTBL_ENTRY)&_ZN6S695C33v84Ev,
  (VTBL_ENTRY)&_ZN6S695C33v85Ev,
  (VTBL_ENTRY)&_ZN6S695C33v86Ev,
  (VTBL_ENTRY)&_ZN6S695C33v87Ev,
  (VTBL_ENTRY)&_ZN6S695C33v88Ev,
  (VTBL_ENTRY)&_ZN6S695C33v89Ev,
  (VTBL_ENTRY)&_ZN6S695C33v90Ev,
  (VTBL_ENTRY)&_ZN6S695C33v91Ev,
  (VTBL_ENTRY)&_ZN6S695C33v92Ev,
  (VTBL_ENTRY)&_ZN6S695C33v93Ev,
  (VTBL_ENTRY)&_ZN6S695C33v94Ev,
  (VTBL_ENTRY)&_ZN6S695C33v95Ev,
  (VTBL_ENTRY)&_ZN6S695C33v96Ev,
  (VTBL_ENTRY)&_ZN6S695C33v97Ev,
  (VTBL_ENTRY)&_ZN6S695C33v98Ev,
  (VTBL_ENTRY)&_ZN6S695C33v99Ev,
  (VTBL_ENTRY)&_ZN6S695C34v100Ev,
  (VTBL_ENTRY)&_ZN6S695C34v101Ev,
  (VTBL_ENTRY)&_ZN6S695C34v102Ev,
  (VTBL_ENTRY)&_ZN6S695C34v103Ev,
  (VTBL_ENTRY)&_ZN6S695C34v104Ev,
  (VTBL_ENTRY)&_ZN6S695C34v105Ev,
  (VTBL_ENTRY)&_ZN6S695C24v106Ev,
  (VTBL_ENTRY)&_ZN6S695C24v107Ev,
  (VTBL_ENTRY)&_ZN6S695C24v108Ev,
  (VTBL_ENTRY)&_ZN6S695C24v109Ev,
  (VTBL_ENTRY)&_ZN6S695C24v110Ev,
  (VTBL_ENTRY)&_ZN6S695C24v111Ev,
  (VTBL_ENTRY)&_ZN6S695C24v112Ev,
  (VTBL_ENTRY)&_ZN6S695C24v113Ev,
  (VTBL_ENTRY)&_ZN6S695C24v114Ev,
  (VTBL_ENTRY)&_ZN6S695C24v115Ev,
  (VTBL_ENTRY)&_ZN6S695C24v116Ev,
  (VTBL_ENTRY)&_ZN6S695C24v117Ev,
  (VTBL_ENTRY)&_ZN6S695C24v118Ev,
  (VTBL_ENTRY)&_ZN6S695C24v119Ev,
  (VTBL_ENTRY)&_ZN6S695C24v120Ev,
  (VTBL_ENTRY)&_ZN6S695C24v121Ev,
  (VTBL_ENTRY)&_ZN6S695C24v122Ev,
  (VTBL_ENTRY)&_ZN6S695C24v123Ev,
  (VTBL_ENTRY)&_ZN6S695C24v124Ev,
  (VTBL_ENTRY)&_ZN6S695C24v125Ev,
  (VTBL_ENTRY)&_ZN6S695C24v126Ev,
  (VTBL_ENTRY)&_ZN6S695C24v127Ev,
  (VTBL_ENTRY)&_ZN6S695C24v128Ev,
  (VTBL_ENTRY)&_ZN6S695C24v129Ev,
  (VTBL_ENTRY)&_ZN6S695C24v130Ev,
  (VTBL_ENTRY)&_ZN6S695C24v131Ev,
  (VTBL_ENTRY)&_ZN6S695C24v132Ev,
  (VTBL_ENTRY)&_ZN6S695C24v133Ev,
  (VTBL_ENTRY)&_ZN6S695C24v134Ev,
  (VTBL_ENTRY)&_ZN6S695C24v135Ev,
  (VTBL_ENTRY)&_ZN6S695C24v136Ev,
  (VTBL_ENTRY)&_ZN6S695C24v137Ev,
  (VTBL_ENTRY)&_ZN6S695C24v138Ev,
  (VTBL_ENTRY)&_ZN6S695C24v139Ev,
  (VTBL_ENTRY)&_ZN6S695C24v140Ev,
  (VTBL_ENTRY)&_ZN6S695C24v141Ev,
  (VTBL_ENTRY)&_ZN6S695C24v142Ev,
  (VTBL_ENTRY)&_ZN6S695C24v143Ev,
  (VTBL_ENTRY)&_ZN6S695C24v144Ev,
  (VTBL_ENTRY)&_ZN6S695C24v145Ev,
  (VTBL_ENTRY)&_ZN6S695C24v146Ev,
  (VTBL_ENTRY)&_ZN6S695C24v147Ev,
  (VTBL_ENTRY)&_ZN6S695C24v148Ev,
  (VTBL_ENTRY)&_ZN6S695C24v149Ev,
};
extern VTBL_ENTRY _ZTI6S695C2[];
extern  VTBL_ENTRY _ZTV6S695C2[];
Class_Descriptor cd_S695C2 = {  "S695C2", // class name
  bases_S695C2, 3,
  &(vtc_S695C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(736,568), // object size
  NSPAIRA(_ZTI6S695C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S695C2),147, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S695C1  : S695C2 {
  virtual  ~S695C1(); // _ZN6S695C1D1Ev
  virtual void  v1(); // _ZN6S695C12v1Ev
  virtual void  v2(); // _ZN6S695C12v2Ev
  virtual void  v3(); // _ZN6S695C12v3Ev
  virtual void  v4(); // _ZN6S695C12v4Ev
  virtual void  v5(); // _ZN6S695C12v5Ev
  virtual void  v6(); // _ZN6S695C12v6Ev
  S695C1(); // tgen
};
//SIG(1 S695C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}}} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 Fp[2] FC11{ BC12{ BC13{ m Fp Fi[6]} Fi:1 FC14{ m}}} FC11 FC15{ BC16{ BC13 Fi:1 Fi}} FC17{ BC18{ BC13 Fi:1 FC19{ m Fi[3]}}} FC11 FC15 FC15 Fi FC20{ BC21{ BC13 Fi:1 FC22{ m Fi[2]}}} Fc[2] FC11 FC15 FC11 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fp[5] Fi[4] FC23{ BC24{ BC10}} FC25{ BC26{ BC10}} FC8 Fi:1 FC27{ BC28{ BC10}}} vd v1 v2 v3 v4 v5 v6}


 S695C1 ::~S695C1(){ note_dtor("S695C1", this);}
void  S695C1 ::v1(){vfunc_called(this, "_ZN6S695C12v1Ev");}
void  S695C1 ::v2(){vfunc_called(this, "_ZN6S695C12v2Ev");}
void  S695C1 ::v3(){vfunc_called(this, "_ZN6S695C12v3Ev");}
void  S695C1 ::v4(){vfunc_called(this, "_ZN6S695C12v4Ev");}
void  S695C1 ::v5(){vfunc_called(this, "_ZN6S695C12v5Ev");}
void  S695C1 ::v6(){vfunc_called(this, "_ZN6S695C12v6Ev");}
S695C1 ::S695C1(){ note_ctor("S695C1", this);} // tgen

static void Test_S695C1()
{
  extern Class_Descriptor cd_S695C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(93,143)];
    init_test(&cd_S695C1, buf);
    S695C1 *dp, &lv = *(dp=new (buf) S695C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(736,568), "sizeof(S695C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S695C1)");
    check_base_class_offset(lv, (S695C5*)(S695C4*)(S695C3*)(S695C2*), 0, "S695C1");
    check_base_class_offset(lv, (S695C4*)(S695C3*)(S695C2*), 0, "S695C1");
    check_base_class_offset(lv, (S695C3*)(S695C2*), 0, "S695C1");
    check_base_class_offset(lv, (S695C2*), 0, "S695C1");
    test_class_info(&lv, &cd_S695C1);
    dp->~S695C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS695C1(Test_S695C1, "S695C1", ABISELECT(736,568));

#else // __cplusplus

extern void _ZN6S695C1C1Ev();
extern void _ZN6S695C1D1Ev();
Name_Map name_map_S695C1[] = {
  NSPAIR(_ZN6S695C1C1Ev),
  NSPAIR(_ZN6S695C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S695C5;
extern VTBL_ENTRY _ZTI6S695C5[];
extern  VTBL_ENTRY _ZTV6S695C5[];
extern Class_Descriptor cd_S695C4;
extern VTBL_ENTRY _ZTI6S695C4[];
extern  VTBL_ENTRY _ZTV6S695C4[];
extern Class_Descriptor cd_S695C3;
extern VTBL_ENTRY _ZTI6S695C3[];
extern  VTBL_ENTRY _ZTV6S695C3[];
extern Class_Descriptor cd_S695C2;
extern VTBL_ENTRY _ZTI6S695C2[];
extern  VTBL_ENTRY _ZTV6S695C2[];
static Base_Class bases_S695C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S695C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S695C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S695C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S695C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S695C1[];
extern void _ZN6S695C1D1Ev();
extern void _ZN6S695C1D0Ev();
extern void _ZN6S695C52v7Ev();
extern void _ZN6S695C52v8Ev();
extern void _ZN6S695C52v9Ev();
extern void _ZN6S695C53v10Ev();
extern void _ZN6S695C53v11Ev();
extern void _ZN6S695C53v12Ev();
extern void _ZN6S695C53v13Ev();
extern void _ZN6S695C53v14Ev();
extern void _ZN6S695C53v15Ev();
extern void _ZN6S695C53v16Ev();
extern void _ZN6S695C53v17Ev();
extern void _ZN6S695C53v18Ev();
extern void _ZN6S695C53v19Ev();
extern void _ZN6S695C53v20Ev();
extern void _ZN6S695C53v21Ev();
extern void _ZN6S695C53v22Ev();
extern void _ZN6S695C53v23Ev();
extern void _ZN6S695C53v24Ev();
extern void _ZN6S695C53v25Ev();
extern void _ZN6S695C53v26Ev();
extern void _ZN6S695C53v27Ev();
extern void _ZN6S695C53v28Ev();
extern void _ZN6S695C53v29Ev();
extern void _ZN6S695C53v30Ev();
extern void _ZN6S695C53v31Ev();
extern void _ZN6S695C53v32Ev();
extern void _ZN6S695C53v33Ev();
extern void _ZN6S695C53v34Ev();
extern void _ZN6S695C53v35Ev();
extern void _ZN6S695C53v36Ev();
extern void _ZN6S695C53v37Ev();
extern void _ZN6S695C53v38Ev();
extern void _ZN6S695C53v39Ev();
extern void _ZN6S695C53v40Ev();
extern void _ZN6S695C53v41Ev();
extern void _ZN6S695C53v42Ev();
extern void _ZN6S695C53v43Ev();
extern void _ZN6S695C53v44Ev();
extern void _ZN6S695C53v45Ev();
extern void _ZN6S695C53v46Ev();
extern void _ZN6S695C53v47Ev();
extern void _ZN6S695C53v48Ev();
extern void _ZN6S695C53v49Ev();
extern void _ZN6S695C53v50Ev();
extern void _ZN6S695C53v51Ev();
extern void _ZN6S695C53v52Ev();
extern void _ZN6S695C53v53Ev();
extern void _ZN6S695C53v54Ev();
extern void _ZN6S695C53v55Ev();
extern void _ZN6S695C53v56Ev();
extern void _ZN6S695C53v57Ev();
extern void _ZN6S695C53v58Ev();
extern void _ZN6S695C53v59Ev();
extern void _ZN6S695C53v60Ev();
extern void _ZN6S695C53v61Ev();
extern void _ZN6S695C53v62Ev();
extern void _ZN6S695C53v63Ev();
extern void _ZN6S695C53v64Ev();
extern void _ZN6S695C53v65Ev();
extern void _ZN6S695C53v66Ev();
extern void _ZN6S695C53v67Ev();
extern void _ZN6S695C53v68Ev();
extern void _ZN6S695C53v69Ev();
extern void _ZN6S695C53v70Ev();
extern void _ZN6S695C43v71Ev();
extern void _ZN6S695C43v72Ev();
extern void _ZN6S695C43v73Ev();
extern void _ZN6S695C43v74Ev();
extern void _ZN6S695C33v75Ev();
extern void _ZN6S695C33v76Ev();
extern void _ZN6S695C33v77Ev();
extern void _ZN6S695C33v78Ev();
extern void _ZN6S695C33v79Ev();
extern void _ZN6S695C33v80Ev();
extern void _ZN6S695C33v81Ev();
extern void _ZN6S695C33v82Ev();
extern void _ZN6S695C33v83Ev();
extern void _ZN6S695C33v84Ev();
extern void _ZN6S695C33v85Ev();
extern void _ZN6S695C33v86Ev();
extern void _ZN6S695C33v87Ev();
extern void _ZN6S695C33v88Ev();
extern void _ZN6S695C33v89Ev();
extern void _ZN6S695C33v90Ev();
extern void _ZN6S695C33v91Ev();
extern void _ZN6S695C33v92Ev();
extern void _ZN6S695C33v93Ev();
extern void _ZN6S695C33v94Ev();
extern void _ZN6S695C33v95Ev();
extern void _ZN6S695C33v96Ev();
extern void _ZN6S695C33v97Ev();
extern void _ZN6S695C33v98Ev();
extern void _ZN6S695C33v99Ev();
extern void _ZN6S695C34v100Ev();
extern void _ZN6S695C34v101Ev();
extern void _ZN6S695C34v102Ev();
extern void _ZN6S695C34v103Ev();
extern void _ZN6S695C34v104Ev();
extern void _ZN6S695C34v105Ev();
extern void _ZN6S695C24v106Ev();
extern void _ZN6S695C24v107Ev();
extern void _ZN6S695C24v108Ev();
extern void _ZN6S695C24v109Ev();
extern void _ZN6S695C24v110Ev();
extern void _ZN6S695C24v111Ev();
extern void _ZN6S695C24v112Ev();
extern void _ZN6S695C24v113Ev();
extern void _ZN6S695C24v114Ev();
extern void _ZN6S695C24v115Ev();
extern void _ZN6S695C24v116Ev();
extern void _ZN6S695C24v117Ev();
extern void _ZN6S695C24v118Ev();
extern void _ZN6S695C24v119Ev();
extern void _ZN6S695C24v120Ev();
extern void _ZN6S695C24v121Ev();
extern void _ZN6S695C24v122Ev();
extern void _ZN6S695C24v123Ev();
extern void _ZN6S695C24v124Ev();
extern void _ZN6S695C24v125Ev();
extern void _ZN6S695C24v126Ev();
extern void _ZN6S695C24v127Ev();
extern void _ZN6S695C24v128Ev();
extern void _ZN6S695C24v129Ev();
extern void _ZN6S695C24v130Ev();
extern void _ZN6S695C24v131Ev();
extern void _ZN6S695C24v132Ev();
extern void _ZN6S695C24v133Ev();
extern void _ZN6S695C24v134Ev();
extern void _ZN6S695C24v135Ev();
extern void _ZN6S695C24v136Ev();
extern void _ZN6S695C24v137Ev();
extern void _ZN6S695C24v138Ev();
extern void _ZN6S695C24v139Ev();
extern void _ZN6S695C24v140Ev();
extern void _ZN6S695C24v141Ev();
extern void _ZN6S695C24v142Ev();
extern void _ZN6S695C24v143Ev();
extern void _ZN6S695C24v144Ev();
extern void _ZN6S695C24v145Ev();
extern void _ZN6S695C24v146Ev();
extern void _ZN6S695C24v147Ev();
extern void _ZN6S695C24v148Ev();
extern void _ZN6S695C24v149Ev();
extern void _ZN6S695C12v1Ev();
extern void _ZN6S695C12v2Ev();
extern void _ZN6S695C12v3Ev();
extern void _ZN6S695C12v4Ev();
extern void _ZN6S695C12v5Ev();
extern void _ZN6S695C12v6Ev();
static  VTBL_ENTRY vtc_S695C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S695C1[0]),
  (VTBL_ENTRY)&_ZN6S695C1D1Ev,
  (VTBL_ENTRY)&_ZN6S695C1D0Ev,
  (VTBL_ENTRY)&_ZN6S695C52v7Ev,
  (VTBL_ENTRY)&_ZN6S695C52v8Ev,
  (VTBL_ENTRY)&_ZN6S695C52v9Ev,
  (VTBL_ENTRY)&_ZN6S695C53v10Ev,
  (VTBL_ENTRY)&_ZN6S695C53v11Ev,
  (VTBL_ENTRY)&_ZN6S695C53v12Ev,
  (VTBL_ENTRY)&_ZN6S695C53v13Ev,
  (VTBL_ENTRY)&_ZN6S695C53v14Ev,
  (VTBL_ENTRY)&_ZN6S695C53v15Ev,
  (VTBL_ENTRY)&_ZN6S695C53v16Ev,
  (VTBL_ENTRY)&_ZN6S695C53v17Ev,
  (VTBL_ENTRY)&_ZN6S695C53v18Ev,
  (VTBL_ENTRY)&_ZN6S695C53v19Ev,
  (VTBL_ENTRY)&_ZN6S695C53v20Ev,
  (VTBL_ENTRY)&_ZN6S695C53v21Ev,
  (VTBL_ENTRY)&_ZN6S695C53v22Ev,
  (VTBL_ENTRY)&_ZN6S695C53v23Ev,
  (VTBL_ENTRY)&_ZN6S695C53v24Ev,
  (VTBL_ENTRY)&_ZN6S695C53v25Ev,
  (VTBL_ENTRY)&_ZN6S695C53v26Ev,
  (VTBL_ENTRY)&_ZN6S695C53v27Ev,
  (VTBL_ENTRY)&_ZN6S695C53v28Ev,
  (VTBL_ENTRY)&_ZN6S695C53v29Ev,
  (VTBL_ENTRY)&_ZN6S695C53v30Ev,
  (VTBL_ENTRY)&_ZN6S695C53v31Ev,
  (VTBL_ENTRY)&_ZN6S695C53v32Ev,
  (VTBL_ENTRY)&_ZN6S695C53v33Ev,
  (VTBL_ENTRY)&_ZN6S695C53v34Ev,
  (VTBL_ENTRY)&_ZN6S695C53v35Ev,
  (VTBL_ENTRY)&_ZN6S695C53v36Ev,
  (VTBL_ENTRY)&_ZN6S695C53v37Ev,
  (VTBL_ENTRY)&_ZN6S695C53v38Ev,
  (VTBL_ENTRY)&_ZN6S695C53v39Ev,
  (VTBL_ENTRY)&_ZN6S695C53v40Ev,
  (VTBL_ENTRY)&_ZN6S695C53v41Ev,
  (VTBL_ENTRY)&_ZN6S695C53v42Ev,
  (VTBL_ENTRY)&_ZN6S695C53v43Ev,
  (VTBL_ENTRY)&_ZN6S695C53v44Ev,
  (VTBL_ENTRY)&_ZN6S695C53v45Ev,
  (VTBL_ENTRY)&_ZN6S695C53v46Ev,
  (VTBL_ENTRY)&_ZN6S695C53v47Ev,
  (VTBL_ENTRY)&_ZN6S695C53v48Ev,
  (VTBL_ENTRY)&_ZN6S695C53v49Ev,
  (VTBL_ENTRY)&_ZN6S695C53v50Ev,
  (VTBL_ENTRY)&_ZN6S695C53v51Ev,
  (VTBL_ENTRY)&_ZN6S695C53v52Ev,
  (VTBL_ENTRY)&_ZN6S695C53v53Ev,
  (VTBL_ENTRY)&_ZN6S695C53v54Ev,
  (VTBL_ENTRY)&_ZN6S695C53v55Ev,
  (VTBL_ENTRY)&_ZN6S695C53v56Ev,
  (VTBL_ENTRY)&_ZN6S695C53v57Ev,
  (VTBL_ENTRY)&_ZN6S695C53v58Ev,
  (VTBL_ENTRY)&_ZN6S695C53v59Ev,
  (VTBL_ENTRY)&_ZN6S695C53v60Ev,
  (VTBL_ENTRY)&_ZN6S695C53v61Ev,
  (VTBL_ENTRY)&_ZN6S695C53v62Ev,
  (VTBL_ENTRY)&_ZN6S695C53v63Ev,
  (VTBL_ENTRY)&_ZN6S695C53v64Ev,
  (VTBL_ENTRY)&_ZN6S695C53v65Ev,
  (VTBL_ENTRY)&_ZN6S695C53v66Ev,
  (VTBL_ENTRY)&_ZN6S695C53v67Ev,
  (VTBL_ENTRY)&_ZN6S695C53v68Ev,
  (VTBL_ENTRY)&_ZN6S695C53v69Ev,
  (VTBL_ENTRY)&_ZN6S695C53v70Ev,
  (VTBL_ENTRY)&_ZN6S695C43v71Ev,
  (VTBL_ENTRY)&_ZN6S695C43v72Ev,
  (VTBL_ENTRY)&_ZN6S695C43v73Ev,
  (VTBL_ENTRY)&_ZN6S695C43v74Ev,
  (VTBL_ENTRY)&_ZN6S695C33v75Ev,
  (VTBL_ENTRY)&_ZN6S695C33v76Ev,
  (VTBL_ENTRY)&_ZN6S695C33v77Ev,
  (VTBL_ENTRY)&_ZN6S695C33v78Ev,
  (VTBL_ENTRY)&_ZN6S695C33v79Ev,
  (VTBL_ENTRY)&_ZN6S695C33v80Ev,
  (VTBL_ENTRY)&_ZN6S695C33v81Ev,
  (VTBL_ENTRY)&_ZN6S695C33v82Ev,
  (VTBL_ENTRY)&_ZN6S695C33v83Ev,
  (VTBL_ENTRY)&_ZN6S695C33v84Ev,
  (VTBL_ENTRY)&_ZN6S695C33v85Ev,
  (VTBL_ENTRY)&_ZN6S695C33v86Ev,
  (VTBL_ENTRY)&_ZN6S695C33v87Ev,
  (VTBL_ENTRY)&_ZN6S695C33v88Ev,
  (VTBL_ENTRY)&_ZN6S695C33v89Ev,
  (VTBL_ENTRY)&_ZN6S695C33v90Ev,
  (VTBL_ENTRY)&_ZN6S695C33v91Ev,
  (VTBL_ENTRY)&_ZN6S695C33v92Ev,
  (VTBL_ENTRY)&_ZN6S695C33v93Ev,
  (VTBL_ENTRY)&_ZN6S695C33v94Ev,
  (VTBL_ENTRY)&_ZN6S695C33v95Ev,
  (VTBL_ENTRY)&_ZN6S695C33v96Ev,
  (VTBL_ENTRY)&_ZN6S695C33v97Ev,
  (VTBL_ENTRY)&_ZN6S695C33v98Ev,
  (VTBL_ENTRY)&_ZN6S695C33v99Ev,
  (VTBL_ENTRY)&_ZN6S695C34v100Ev,
  (VTBL_ENTRY)&_ZN6S695C34v101Ev,
  (VTBL_ENTRY)&_ZN6S695C34v102Ev,
  (VTBL_ENTRY)&_ZN6S695C34v103Ev,
  (VTBL_ENTRY)&_ZN6S695C34v104Ev,
  (VTBL_ENTRY)&_ZN6S695C34v105Ev,
  (VTBL_ENTRY)&_ZN6S695C24v106Ev,
  (VTBL_ENTRY)&_ZN6S695C24v107Ev,
  (VTBL_ENTRY)&_ZN6S695C24v108Ev,
  (VTBL_ENTRY)&_ZN6S695C24v109Ev,
  (VTBL_ENTRY)&_ZN6S695C24v110Ev,
  (VTBL_ENTRY)&_ZN6S695C24v111Ev,
  (VTBL_ENTRY)&_ZN6S695C24v112Ev,
  (VTBL_ENTRY)&_ZN6S695C24v113Ev,
  (VTBL_ENTRY)&_ZN6S695C24v114Ev,
  (VTBL_ENTRY)&_ZN6S695C24v115Ev,
  (VTBL_ENTRY)&_ZN6S695C24v116Ev,
  (VTBL_ENTRY)&_ZN6S695C24v117Ev,
  (VTBL_ENTRY)&_ZN6S695C24v118Ev,
  (VTBL_ENTRY)&_ZN6S695C24v119Ev,
  (VTBL_ENTRY)&_ZN6S695C24v120Ev,
  (VTBL_ENTRY)&_ZN6S695C24v121Ev,
  (VTBL_ENTRY)&_ZN6S695C24v122Ev,
  (VTBL_ENTRY)&_ZN6S695C24v123Ev,
  (VTBL_ENTRY)&_ZN6S695C24v124Ev,
  (VTBL_ENTRY)&_ZN6S695C24v125Ev,
  (VTBL_ENTRY)&_ZN6S695C24v126Ev,
  (VTBL_ENTRY)&_ZN6S695C24v127Ev,
  (VTBL_ENTRY)&_ZN6S695C24v128Ev,
  (VTBL_ENTRY)&_ZN6S695C24v129Ev,
  (VTBL_ENTRY)&_ZN6S695C24v130Ev,
  (VTBL_ENTRY)&_ZN6S695C24v131Ev,
  (VTBL_ENTRY)&_ZN6S695C24v132Ev,
  (VTBL_ENTRY)&_ZN6S695C24v133Ev,
  (VTBL_ENTRY)&_ZN6S695C24v134Ev,
  (VTBL_ENTRY)&_ZN6S695C24v135Ev,
  (VTBL_ENTRY)&_ZN6S695C24v136Ev,
  (VTBL_ENTRY)&_ZN6S695C24v137Ev,
  (VTBL_ENTRY)&_ZN6S695C24v138Ev,
  (VTBL_ENTRY)&_ZN6S695C24v139Ev,
  (VTBL_ENTRY)&_ZN6S695C24v140Ev,
  (VTBL_ENTRY)&_ZN6S695C24v141Ev,
  (VTBL_ENTRY)&_ZN6S695C24v142Ev,
  (VTBL_ENTRY)&_ZN6S695C24v143Ev,
  (VTBL_ENTRY)&_ZN6S695C24v144Ev,
  (VTBL_ENTRY)&_ZN6S695C24v145Ev,
  (VTBL_ENTRY)&_ZN6S695C24v146Ev,
  (VTBL_ENTRY)&_ZN6S695C24v147Ev,
  (VTBL_ENTRY)&_ZN6S695C24v148Ev,
  (VTBL_ENTRY)&_ZN6S695C24v149Ev,
  (VTBL_ENTRY)&_ZN6S695C12v1Ev,
  (VTBL_ENTRY)&_ZN6S695C12v2Ev,
  (VTBL_ENTRY)&_ZN6S695C12v3Ev,
  (VTBL_ENTRY)&_ZN6S695C12v4Ev,
  (VTBL_ENTRY)&_ZN6S695C12v5Ev,
  (VTBL_ENTRY)&_ZN6S695C12v6Ev,
};
extern VTBL_ENTRY _ZTI6S695C1[];
extern  VTBL_ENTRY _ZTV6S695C1[];
Class_Descriptor cd_S695C1 = {  "S695C1", // class name
  bases_S695C1, 4,
  &(vtc_S695C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(736,568), // object size
  NSPAIRA(_ZTI6S695C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S695C1),153, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S507C5  {
  int s507c5f0;
  __tsi64 s507c5f1;
  void *s507c5f2[4];
  int s507c5f3[2];
  void *s507c5f4;
  ::S695C22_nt s507c5f5;
  void *s507c5f6[2];
  virtual  ~S507C5(); // _ZN6S507C5D1Ev
  virtual void  v21(); // _ZN6S507C53v21Ev
  virtual void  v22(); // _ZN6S507C53v22Ev
  virtual void  v23(); // _ZN6S507C53v23Ev
  virtual void  v24(); // _ZN6S507C53v24Ev
  virtual void  v25(); // _ZN6S507C53v25Ev
  virtual void  v26(); // _ZN6S507C53v26Ev
  virtual void  v27(); // _ZN6S507C53v27Ev
  virtual void  v28(); // _ZN6S507C53v28Ev
  virtual void  v29(); // _ZN6S507C53v29Ev
  virtual void  v30(); // _ZN6S507C53v30Ev
  virtual void  v31(); // _ZN6S507C53v31Ev
  virtual void  v32(); // _ZN6S507C53v32Ev
  virtual void  v33(); // _ZN6S507C53v33Ev
  virtual void  v34(); // _ZN6S507C53v34Ev
  virtual void  v35(); // _ZN6S507C53v35Ev
  virtual void  v36(); // _ZN6S507C53v36Ev
  virtual void  v37(); // _ZN6S507C53v37Ev
  virtual void  v38(); // _ZN6S507C53v38Ev
  virtual void  v39(); // _ZN6S507C53v39Ev
  virtual void  v40(); // _ZN6S507C53v40Ev
  virtual void  v41(); // _ZN6S507C53v41Ev
  virtual void  v42(); // _ZN6S507C53v42Ev
  virtual void  v43(); // _ZN6S507C53v43Ev
  virtual void  v44(); // _ZN6S507C53v44Ev
  virtual void  v45(); // _ZN6S507C53v45Ev
  virtual void  v46(); // _ZN6S507C53v46Ev
  virtual void  v47(); // _ZN6S507C53v47Ev
  virtual void  v48(); // _ZN6S507C53v48Ev
  virtual void  v49(); // _ZN6S507C53v49Ev
  virtual void  v50(); // _ZN6S507C53v50Ev
  virtual void  v51(); // _ZN6S507C53v51Ev
  virtual void  v52(); // _ZN6S507C53v52Ev
  virtual void  v53(); // _ZN6S507C53v53Ev
  virtual void  v54(); // _ZN6S507C53v54Ev
  virtual void  v55(); // _ZN6S507C53v55Ev
  virtual void  v56(); // _ZN6S507C53v56Ev
  virtual void  v57(); // _ZN6S507C53v57Ev
  virtual void  v58(); // _ZN6S507C53v58Ev
  virtual void  v59(); // _ZN6S507C53v59Ev
  virtual void  v60(); // _ZN6S507C53v60Ev
  virtual void  v61(); // _ZN6S507C53v61Ev
  virtual void  v62(); // _ZN6S507C53v62Ev
  virtual void  v63(); // _ZN6S507C53v63Ev
  virtual void  v64(); // _ZN6S507C53v64Ev
  virtual void  v65(); // _ZN6S507C53v65Ev
  virtual void  v66(); // _ZN6S507C53v66Ev
  virtual void  v67(); // _ZN6S507C53v67Ev
  virtual void  v68(); // _ZN6S507C53v68Ev
  virtual void  v69(); // _ZN6S507C53v69Ev
  virtual void  v70(); // _ZN6S507C53v70Ev
  virtual void  v71(); // _ZN6S507C53v71Ev
  virtual void  v72(); // _ZN6S507C53v72Ev
  virtual void  v73(); // _ZN6S507C53v73Ev
  virtual void  v74(); // _ZN6S507C53v74Ev
  virtual void  v75(); // _ZN6S507C53v75Ev
  virtual void  v76(); // _ZN6S507C53v76Ev
  virtual void  v77(); // _ZN6S507C53v77Ev
  virtual void  v78(); // _ZN6S507C53v78Ev
  virtual void  v79(); // _ZN6S507C53v79Ev
  virtual void  v80(); // _ZN6S507C53v80Ev
  virtual void  v81(); // _ZN6S507C53v81Ev
  virtual void  v82(); // _ZN6S507C53v82Ev
  virtual void  v83(); // _ZN6S507C53v83Ev
  virtual void  v84(); // _ZN6S507C53v84Ev
  S507C5(); // tgen
};
//SIG(-1 S507C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S507C5 ::~S507C5(){ note_dtor("S507C5", this);}
void  S507C5 ::v21(){vfunc_called(this, "_ZN6S507C53v21Ev");}
void  S507C5 ::v22(){vfunc_called(this, "_ZN6S507C53v22Ev");}
void  S507C5 ::v23(){vfunc_called(this, "_ZN6S507C53v23Ev");}
void  S507C5 ::v24(){vfunc_called(this, "_ZN6S507C53v24Ev");}
void  S507C5 ::v25(){vfunc_called(this, "_ZN6S507C53v25Ev");}
void  S507C5 ::v26(){vfunc_called(this, "_ZN6S507C53v26Ev");}
void  S507C5 ::v27(){vfunc_called(this, "_ZN6S507C53v27Ev");}
void  S507C5 ::v28(){vfunc_called(this, "_ZN6S507C53v28Ev");}
void  S507C5 ::v29(){vfunc_called(this, "_ZN6S507C53v29Ev");}
void  S507C5 ::v30(){vfunc_called(this, "_ZN6S507C53v30Ev");}
void  S507C5 ::v31(){vfunc_called(this, "_ZN6S507C53v31Ev");}
void  S507C5 ::v32(){vfunc_called(this, "_ZN6S507C53v32Ev");}
void  S507C5 ::v33(){vfunc_called(this, "_ZN6S507C53v33Ev");}
void  S507C5 ::v34(){vfunc_called(this, "_ZN6S507C53v34Ev");}
void  S507C5 ::v35(){vfunc_called(this, "_ZN6S507C53v35Ev");}
void  S507C5 ::v36(){vfunc_called(this, "_ZN6S507C53v36Ev");}
void  S507C5 ::v37(){vfunc_called(this, "_ZN6S507C53v37Ev");}
void  S507C5 ::v38(){vfunc_called(this, "_ZN6S507C53v38Ev");}
void  S507C5 ::v39(){vfunc_called(this, "_ZN6S507C53v39Ev");}
void  S507C5 ::v40(){vfunc_called(this, "_ZN6S507C53v40Ev");}
void  S507C5 ::v41(){vfunc_called(this, "_ZN6S507C53v41Ev");}
void  S507C5 ::v42(){vfunc_called(this, "_ZN6S507C53v42Ev");}
void  S507C5 ::v43(){vfunc_called(this, "_ZN6S507C53v43Ev");}
void  S507C5 ::v44(){vfunc_called(this, "_ZN6S507C53v44Ev");}
void  S507C5 ::v45(){vfunc_called(this, "_ZN6S507C53v45Ev");}
void  S507C5 ::v46(){vfunc_called(this, "_ZN6S507C53v46Ev");}
void  S507C5 ::v47(){vfunc_called(this, "_ZN6S507C53v47Ev");}
void  S507C5 ::v48(){vfunc_called(this, "_ZN6S507C53v48Ev");}
void  S507C5 ::v49(){vfunc_called(this, "_ZN6S507C53v49Ev");}
void  S507C5 ::v50(){vfunc_called(this, "_ZN6S507C53v50Ev");}
void  S507C5 ::v51(){vfunc_called(this, "_ZN6S507C53v51Ev");}
void  S507C5 ::v52(){vfunc_called(this, "_ZN6S507C53v52Ev");}
void  S507C5 ::v53(){vfunc_called(this, "_ZN6S507C53v53Ev");}
void  S507C5 ::v54(){vfunc_called(this, "_ZN6S507C53v54Ev");}
void  S507C5 ::v55(){vfunc_called(this, "_ZN6S507C53v55Ev");}
void  S507C5 ::v56(){vfunc_called(this, "_ZN6S507C53v56Ev");}
void  S507C5 ::v57(){vfunc_called(this, "_ZN6S507C53v57Ev");}
void  S507C5 ::v58(){vfunc_called(this, "_ZN6S507C53v58Ev");}
void  S507C5 ::v59(){vfunc_called(this, "_ZN6S507C53v59Ev");}
void  S507C5 ::v60(){vfunc_called(this, "_ZN6S507C53v60Ev");}
void  S507C5 ::v61(){vfunc_called(this, "_ZN6S507C53v61Ev");}
void  S507C5 ::v62(){vfunc_called(this, "_ZN6S507C53v62Ev");}
void  S507C5 ::v63(){vfunc_called(this, "_ZN6S507C53v63Ev");}
void  S507C5 ::v64(){vfunc_called(this, "_ZN6S507C53v64Ev");}
void  S507C5 ::v65(){vfunc_called(this, "_ZN6S507C53v65Ev");}
void  S507C5 ::v66(){vfunc_called(this, "_ZN6S507C53v66Ev");}
void  S507C5 ::v67(){vfunc_called(this, "_ZN6S507C53v67Ev");}
void  S507C5 ::v68(){vfunc_called(this, "_ZN6S507C53v68Ev");}
void  S507C5 ::v69(){vfunc_called(this, "_ZN6S507C53v69Ev");}
void  S507C5 ::v70(){vfunc_called(this, "_ZN6S507C53v70Ev");}
void  S507C5 ::v71(){vfunc_called(this, "_ZN6S507C53v71Ev");}
void  S507C5 ::v72(){vfunc_called(this, "_ZN6S507C53v72Ev");}
void  S507C5 ::v73(){vfunc_called(this, "_ZN6S507C53v73Ev");}
void  S507C5 ::v74(){vfunc_called(this, "_ZN6S507C53v74Ev");}
void  S507C5 ::v75(){vfunc_called(this, "_ZN6S507C53v75Ev");}
void  S507C5 ::v76(){vfunc_called(this, "_ZN6S507C53v76Ev");}
void  S507C5 ::v77(){vfunc_called(this, "_ZN6S507C53v77Ev");}
void  S507C5 ::v78(){vfunc_called(this, "_ZN6S507C53v78Ev");}
void  S507C5 ::v79(){vfunc_called(this, "_ZN6S507C53v79Ev");}
void  S507C5 ::v80(){vfunc_called(this, "_ZN6S507C53v80Ev");}
void  S507C5 ::v81(){vfunc_called(this, "_ZN6S507C53v81Ev");}
void  S507C5 ::v82(){vfunc_called(this, "_ZN6S507C53v82Ev");}
void  S507C5 ::v83(){vfunc_called(this, "_ZN6S507C53v83Ev");}
void  S507C5 ::v84(){vfunc_called(this, "_ZN6S507C53v84Ev");}
S507C5 ::S507C5(){ note_ctor("S507C5", this);} // tgen

static void Test_S507C5()
{
  extern Class_Descriptor cd_S507C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S507C5, buf);
    S507C5 *dp, &lv = *(dp=new (buf) S507C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S507C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S507C5)");
    check_field_offset(lv, s507c5f0, ABISELECT(8,4), "S507C5.s507c5f0");
    check_field_offset(lv, s507c5f1, ABISELECT(16,8), "S507C5.s507c5f1");
    check_field_offset(lv, s507c5f2, ABISELECT(24,16), "S507C5.s507c5f2");
    check_field_offset(lv, s507c5f3, ABISELECT(56,32), "S507C5.s507c5f3");
    check_field_offset(lv, s507c5f4, ABISELECT(64,40), "S507C5.s507c5f4");
    check_field_offset(lv, s507c5f5, ABISELECT(72,44), "S507C5.s507c5f5");
    check_field_offset(lv, s507c5f6, ABISELECT(80,52), "S507C5.s507c5f6");
    test_class_info(&lv, &cd_S507C5);
    dp->~S507C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS507C5(Test_S507C5, "S507C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S507C5C1Ev();
extern void _ZN6S507C5D1Ev();
Name_Map name_map_S507C5[] = {
  NSPAIR(_ZN6S507C5C1Ev),
  NSPAIR(_ZN6S507C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S507C5[];
extern void _ZN6S507C5D1Ev();
extern void _ZN6S507C5D0Ev();
extern void _ZN6S507C53v21Ev();
extern void _ZN6S507C53v22Ev();
extern void _ZN6S507C53v23Ev();
extern void _ZN6S507C53v24Ev();
extern void _ZN6S507C53v25Ev();
extern void _ZN6S507C53v26Ev();
extern void _ZN6S507C53v27Ev();
extern void _ZN6S507C53v28Ev();
extern void _ZN6S507C53v29Ev();
extern void _ZN6S507C53v30Ev();
extern void _ZN6S507C53v31Ev();
extern void _ZN6S507C53v32Ev();
extern void _ZN6S507C53v33Ev();
extern void _ZN6S507C53v34Ev();
extern void _ZN6S507C53v35Ev();
extern void _ZN6S507C53v36Ev();
extern void _ZN6S507C53v37Ev();
extern void _ZN6S507C53v38Ev();
extern void _ZN6S507C53v39Ev();
extern void _ZN6S507C53v40Ev();
extern void _ZN6S507C53v41Ev();
extern void _ZN6S507C53v42Ev();
extern void _ZN6S507C53v43Ev();
extern void _ZN6S507C53v44Ev();
extern void _ZN6S507C53v45Ev();
extern void _ZN6S507C53v46Ev();
extern void _ZN6S507C53v47Ev();
extern void _ZN6S507C53v48Ev();
extern void _ZN6S507C53v49Ev();
extern void _ZN6S507C53v50Ev();
extern void _ZN6S507C53v51Ev();
extern void _ZN6S507C53v52Ev();
extern void _ZN6S507C53v53Ev();
extern void _ZN6S507C53v54Ev();
extern void _ZN6S507C53v55Ev();
extern void _ZN6S507C53v56Ev();
extern void _ZN6S507C53v57Ev();
extern void _ZN6S507C53v58Ev();
extern void _ZN6S507C53v59Ev();
extern void _ZN6S507C53v60Ev();
extern void _ZN6S507C53v61Ev();
extern void _ZN6S507C53v62Ev();
extern void _ZN6S507C53v63Ev();
extern void _ZN6S507C53v64Ev();
extern void _ZN6S507C53v65Ev();
extern void _ZN6S507C53v66Ev();
extern void _ZN6S507C53v67Ev();
extern void _ZN6S507C53v68Ev();
extern void _ZN6S507C53v69Ev();
extern void _ZN6S507C53v70Ev();
extern void _ZN6S507C53v71Ev();
extern void _ZN6S507C53v72Ev();
extern void _ZN6S507C53v73Ev();
extern void _ZN6S507C53v74Ev();
extern void _ZN6S507C53v75Ev();
extern void _ZN6S507C53v76Ev();
extern void _ZN6S507C53v77Ev();
extern void _ZN6S507C53v78Ev();
extern void _ZN6S507C53v79Ev();
extern void _ZN6S507C53v80Ev();
extern void _ZN6S507C53v81Ev();
extern void _ZN6S507C53v82Ev();
extern void _ZN6S507C53v83Ev();
extern void _ZN6S507C53v84Ev();
static  VTBL_ENTRY vtc_S507C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S507C5[0]),
  (VTBL_ENTRY)&_ZN6S507C5D1Ev,
  (VTBL_ENTRY)&_ZN6S507C5D0Ev,
  (VTBL_ENTRY)&_ZN6S507C53v21Ev,
  (VTBL_ENTRY)&_ZN6S507C53v22Ev,
  (VTBL_ENTRY)&_ZN6S507C53v23Ev,
  (VTBL_ENTRY)&_ZN6S507C53v24Ev,
  (VTBL_ENTRY)&_ZN6S507C53v25Ev,
  (VTBL_ENTRY)&_ZN6S507C53v26Ev,
  (VTBL_ENTRY)&_ZN6S507C53v27Ev,
  (VTBL_ENTRY)&_ZN6S507C53v28Ev,
  (VTBL_ENTRY)&_ZN6S507C53v29Ev,
  (VTBL_ENTRY)&_ZN6S507C53v30Ev,
  (VTBL_ENTRY)&_ZN6S507C53v31Ev,
  (VTBL_ENTRY)&_ZN6S507C53v32Ev,
  (VTBL_ENTRY)&_ZN6S507C53v33Ev,
  (VTBL_ENTRY)&_ZN6S507C53v34Ev,
  (VTBL_ENTRY)&_ZN6S507C53v35Ev,
  (VTBL_ENTRY)&_ZN6S507C53v36Ev,
  (VTBL_ENTRY)&_ZN6S507C53v37Ev,
  (VTBL_ENTRY)&_ZN6S507C53v38Ev,
  (VTBL_ENTRY)&_ZN6S507C53v39Ev,
  (VTBL_ENTRY)&_ZN6S507C53v40Ev,
  (VTBL_ENTRY)&_ZN6S507C53v41Ev,
  (VTBL_ENTRY)&_ZN6S507C53v42Ev,
  (VTBL_ENTRY)&_ZN6S507C53v43Ev,
  (VTBL_ENTRY)&_ZN6S507C53v44Ev,
  (VTBL_ENTRY)&_ZN6S507C53v45Ev,
  (VTBL_ENTRY)&_ZN6S507C53v46Ev,
  (VTBL_ENTRY)&_ZN6S507C53v47Ev,
  (VTBL_ENTRY)&_ZN6S507C53v48Ev,
  (VTBL_ENTRY)&_ZN6S507C53v49Ev,
  (VTBL_ENTRY)&_ZN6S507C53v50Ev,
  (VTBL_ENTRY)&_ZN6S507C53v51Ev,
  (VTBL_ENTRY)&_ZN6S507C53v52Ev,
  (VTBL_ENTRY)&_ZN6S507C53v53Ev,
  (VTBL_ENTRY)&_ZN6S507C53v54Ev,
  (VTBL_ENTRY)&_ZN6S507C53v55Ev,
  (VTBL_ENTRY)&_ZN6S507C53v56Ev,
  (VTBL_ENTRY)&_ZN6S507C53v57Ev,
  (VTBL_ENTRY)&_ZN6S507C53v58Ev,
  (VTBL_ENTRY)&_ZN6S507C53v59Ev,
  (VTBL_ENTRY)&_ZN6S507C53v60Ev,
  (VTBL_ENTRY)&_ZN6S507C53v61Ev,
  (VTBL_ENTRY)&_ZN6S507C53v62Ev,
  (VTBL_ENTRY)&_ZN6S507C53v63Ev,
  (VTBL_ENTRY)&_ZN6S507C53v64Ev,
  (VTBL_ENTRY)&_ZN6S507C53v65Ev,
  (VTBL_ENTRY)&_ZN6S507C53v66Ev,
  (VTBL_ENTRY)&_ZN6S507C53v67Ev,
  (VTBL_ENTRY)&_ZN6S507C53v68Ev,
  (VTBL_ENTRY)&_ZN6S507C53v69Ev,
  (VTBL_ENTRY)&_ZN6S507C53v70Ev,
  (VTBL_ENTRY)&_ZN6S507C53v71Ev,
  (VTBL_ENTRY)&_ZN6S507C53v72Ev,
  (VTBL_ENTRY)&_ZN6S507C53v73Ev,
  (VTBL_ENTRY)&_ZN6S507C53v74Ev,
  (VTBL_ENTRY)&_ZN6S507C53v75Ev,
  (VTBL_ENTRY)&_ZN6S507C53v76Ev,
  (VTBL_ENTRY)&_ZN6S507C53v77Ev,
  (VTBL_ENTRY)&_ZN6S507C53v78Ev,
  (VTBL_ENTRY)&_ZN6S507C53v79Ev,
  (VTBL_ENTRY)&_ZN6S507C53v80Ev,
  (VTBL_ENTRY)&_ZN6S507C53v81Ev,
  (VTBL_ENTRY)&_ZN6S507C53v82Ev,
  (VTBL_ENTRY)&_ZN6S507C53v83Ev,
  (VTBL_ENTRY)&_ZN6S507C53v84Ev,
};
extern VTBL_ENTRY _ZTI6S507C5[];
extern  VTBL_ENTRY _ZTV6S507C5[];
Class_Descriptor cd_S507C5 = {  "S507C5", // class name
  0,0,//no base classes
  &(vtc_S507C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S507C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S507C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S507C4  : S507C5 {
  virtual  ~S507C4(); // _ZN6S507C4D1Ev
  virtual void  v85(); // _ZN6S507C43v85Ev
  virtual void  v86(); // _ZN6S507C43v86Ev
  virtual void  v87(); // _ZN6S507C43v87Ev
  virtual void  v88(); // _ZN6S507C43v88Ev
  S507C4(); // tgen
};
//SIG(-1 S507C4) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S507C4 ::~S507C4(){ note_dtor("S507C4", this);}
void  S507C4 ::v85(){vfunc_called(this, "_ZN6S507C43v85Ev");}
void  S507C4 ::v86(){vfunc_called(this, "_ZN6S507C43v86Ev");}
void  S507C4 ::v87(){vfunc_called(this, "_ZN6S507C43v87Ev");}
void  S507C4 ::v88(){vfunc_called(this, "_ZN6S507C43v88Ev");}
S507C4 ::S507C4(){ note_ctor("S507C4", this);} // tgen

static void Test_S507C4()
{
  extern Class_Descriptor cd_S507C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S507C4, buf);
    S507C4 *dp, &lv = *(dp=new (buf) S507C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S507C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S507C4)");
    check_base_class_offset(lv, (S507C5*), 0, "S507C4");
    test_class_info(&lv, &cd_S507C4);
    dp->~S507C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS507C4(Test_S507C4, "S507C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S507C4C1Ev();
extern void _ZN6S507C4D1Ev();
Name_Map name_map_S507C4[] = {
  NSPAIR(_ZN6S507C4C1Ev),
  NSPAIR(_ZN6S507C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S507C5;
extern VTBL_ENTRY _ZTI6S507C5[];
extern  VTBL_ENTRY _ZTV6S507C5[];
static Base_Class bases_S507C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S507C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S507C4[];
extern void _ZN6S507C4D1Ev();
extern void _ZN6S507C4D0Ev();
extern void _ZN6S507C53v21Ev();
extern void _ZN6S507C53v22Ev();
extern void _ZN6S507C53v23Ev();
extern void _ZN6S507C53v24Ev();
extern void _ZN6S507C53v25Ev();
extern void _ZN6S507C53v26Ev();
extern void _ZN6S507C53v27Ev();
extern void _ZN6S507C53v28Ev();
extern void _ZN6S507C53v29Ev();
extern void _ZN6S507C53v30Ev();
extern void _ZN6S507C53v31Ev();
extern void _ZN6S507C53v32Ev();
extern void _ZN6S507C53v33Ev();
extern void _ZN6S507C53v34Ev();
extern void _ZN6S507C53v35Ev();
extern void _ZN6S507C53v36Ev();
extern void _ZN6S507C53v37Ev();
extern void _ZN6S507C53v38Ev();
extern void _ZN6S507C53v39Ev();
extern void _ZN6S507C53v40Ev();
extern void _ZN6S507C53v41Ev();
extern void _ZN6S507C53v42Ev();
extern void _ZN6S507C53v43Ev();
extern void _ZN6S507C53v44Ev();
extern void _ZN6S507C53v45Ev();
extern void _ZN6S507C53v46Ev();
extern void _ZN6S507C53v47Ev();
extern void _ZN6S507C53v48Ev();
extern void _ZN6S507C53v49Ev();
extern void _ZN6S507C53v50Ev();
extern void _ZN6S507C53v51Ev();
extern void _ZN6S507C53v52Ev();
extern void _ZN6S507C53v53Ev();
extern void _ZN6S507C53v54Ev();
extern void _ZN6S507C53v55Ev();
extern void _ZN6S507C53v56Ev();
extern void _ZN6S507C53v57Ev();
extern void _ZN6S507C53v58Ev();
extern void _ZN6S507C53v59Ev();
extern void _ZN6S507C53v60Ev();
extern void _ZN6S507C53v61Ev();
extern void _ZN6S507C53v62Ev();
extern void _ZN6S507C53v63Ev();
extern void _ZN6S507C53v64Ev();
extern void _ZN6S507C53v65Ev();
extern void _ZN6S507C53v66Ev();
extern void _ZN6S507C53v67Ev();
extern void _ZN6S507C53v68Ev();
extern void _ZN6S507C53v69Ev();
extern void _ZN6S507C53v70Ev();
extern void _ZN6S507C53v71Ev();
extern void _ZN6S507C53v72Ev();
extern void _ZN6S507C53v73Ev();
extern void _ZN6S507C53v74Ev();
extern void _ZN6S507C53v75Ev();
extern void _ZN6S507C53v76Ev();
extern void _ZN6S507C53v77Ev();
extern void _ZN6S507C53v78Ev();
extern void _ZN6S507C53v79Ev();
extern void _ZN6S507C53v80Ev();
extern void _ZN6S507C53v81Ev();
extern void _ZN6S507C53v82Ev();
extern void _ZN6S507C53v83Ev();
extern void _ZN6S507C53v84Ev();
extern void _ZN6S507C43v85Ev();
extern void _ZN6S507C43v86Ev();
extern void _ZN6S507C43v87Ev();
extern void _ZN6S507C43v88Ev();
static  VTBL_ENTRY vtc_S507C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S507C4[0]),
  (VTBL_ENTRY)&_ZN6S507C4D1Ev,
  (VTBL_ENTRY)&_ZN6S507C4D0Ev,
  (VTBL_ENTRY)&_ZN6S507C53v21Ev,
  (VTBL_ENTRY)&_ZN6S507C53v22Ev,
  (VTBL_ENTRY)&_ZN6S507C53v23Ev,
  (VTBL_ENTRY)&_ZN6S507C53v24Ev,
  (VTBL_ENTRY)&_ZN6S507C53v25Ev,
  (VTBL_ENTRY)&_ZN6S507C53v26Ev,
  (VTBL_ENTRY)&_ZN6S507C53v27Ev,
  (VTBL_ENTRY)&_ZN6S507C53v28Ev,
  (VTBL_ENTRY)&_ZN6S507C53v29Ev,
  (VTBL_ENTRY)&_ZN6S507C53v30Ev,
  (VTBL_ENTRY)&_ZN6S507C53v31Ev,
  (VTBL_ENTRY)&_ZN6S507C53v32Ev,
  (VTBL_ENTRY)&_ZN6S507C53v33Ev,
  (VTBL_ENTRY)&_ZN6S507C53v34Ev,
  (VTBL_ENTRY)&_ZN6S507C53v35Ev,
  (VTBL_ENTRY)&_ZN6S507C53v36Ev,
  (VTBL_ENTRY)&_ZN6S507C53v37Ev,
  (VTBL_ENTRY)&_ZN6S507C53v38Ev,
  (VTBL_ENTRY)&_ZN6S507C53v39Ev,
  (VTBL_ENTRY)&_ZN6S507C53v40Ev,
  (VTBL_ENTRY)&_ZN6S507C53v41Ev,
  (VTBL_ENTRY)&_ZN6S507C53v42Ev,
  (VTBL_ENTRY)&_ZN6S507C53v43Ev,
  (VTBL_ENTRY)&_ZN6S507C53v44Ev,
  (VTBL_ENTRY)&_ZN6S507C53v45Ev,
  (VTBL_ENTRY)&_ZN6S507C53v46Ev,
  (VTBL_ENTRY)&_ZN6S507C53v47Ev,
  (VTBL_ENTRY)&_ZN6S507C53v48Ev,
  (VTBL_ENTRY)&_ZN6S507C53v49Ev,
  (VTBL_ENTRY)&_ZN6S507C53v50Ev,
  (VTBL_ENTRY)&_ZN6S507C53v51Ev,
  (VTBL_ENTRY)&_ZN6S507C53v52Ev,
  (VTBL_ENTRY)&_ZN6S507C53v53Ev,
  (VTBL_ENTRY)&_ZN6S507C53v54Ev,
  (VTBL_ENTRY)&_ZN6S507C53v55Ev,
  (VTBL_ENTRY)&_ZN6S507C53v56Ev,
  (VTBL_ENTRY)&_ZN6S507C53v57Ev,
  (VTBL_ENTRY)&_ZN6S507C53v58Ev,
  (VTBL_ENTRY)&_ZN6S507C53v59Ev,
  (VTBL_ENTRY)&_ZN6S507C53v60Ev,
  (VTBL_ENTRY)&_ZN6S507C53v61Ev,
  (VTBL_ENTRY)&_ZN6S507C53v62Ev,
  (VTBL_ENTRY)&_ZN6S507C53v63Ev,
  (VTBL_ENTRY)&_ZN6S507C53v64Ev,
  (VTBL_ENTRY)&_ZN6S507C53v65Ev,
  (VTBL_ENTRY)&_ZN6S507C53v66Ev,
  (VTBL_ENTRY)&_ZN6S507C53v67Ev,
  (VTBL_ENTRY)&_ZN6S507C53v68Ev,
  (VTBL_ENTRY)&_ZN6S507C53v69Ev,
  (VTBL_ENTRY)&_ZN6S507C53v70Ev,
  (VTBL_ENTRY)&_ZN6S507C53v71Ev,
  (VTBL_ENTRY)&_ZN6S507C53v72Ev,
  (VTBL_ENTRY)&_ZN6S507C53v73Ev,
  (VTBL_ENTRY)&_ZN6S507C53v74Ev,
  (VTBL_ENTRY)&_ZN6S507C53v75Ev,
  (VTBL_ENTRY)&_ZN6S507C53v76Ev,
  (VTBL_ENTRY)&_ZN6S507C53v77Ev,
  (VTBL_ENTRY)&_ZN6S507C53v78Ev,
  (VTBL_ENTRY)&_ZN6S507C53v79Ev,
  (VTBL_ENTRY)&_ZN6S507C53v80Ev,
  (VTBL_ENTRY)&_ZN6S507C53v81Ev,
  (VTBL_ENTRY)&_ZN6S507C53v82Ev,
  (VTBL_ENTRY)&_ZN6S507C53v83Ev,
  (VTBL_ENTRY)&_ZN6S507C53v84Ev,
  (VTBL_ENTRY)&_ZN6S507C43v85Ev,
  (VTBL_ENTRY)&_ZN6S507C43v86Ev,
  (VTBL_ENTRY)&_ZN6S507C43v87Ev,
  (VTBL_ENTRY)&_ZN6S507C43v88Ev,
};
extern VTBL_ENTRY _ZTI6S507C4[];
extern  VTBL_ENTRY _ZTV6S507C4[];
Class_Descriptor cd_S507C4 = {  "S507C4", // class name
  bases_S507C4, 1,
  &(vtc_S507C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S507C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S507C4),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S507C8  {
  int s507c8f0[8];
  void *s507c8f1;
  int s507c8f2;
  void *s507c8f3;
  virtual  ~S507C8(); // _ZN6S507C8D1Ev
  virtual void  v128(); // _ZN6S507C84v128Ev
  virtual void  v129(); // _ZN6S507C84v129Ev
  virtual void  v130(); // _ZN6S507C84v130Ev
  virtual void  v131(); // _ZN6S507C84v131Ev
  virtual void  v132(); // _ZN6S507C84v132Ev
  S507C8(); // tgen
};
//SIG(-1 S507C8) C1{ vd v1 v2 v3 v4 v5 Fi[8] Fp Fi Fp}


 S507C8 ::~S507C8(){ note_dtor("S507C8", this);}
void  S507C8 ::v128(){vfunc_called(this, "_ZN6S507C84v128Ev");}
void  S507C8 ::v129(){vfunc_called(this, "_ZN6S507C84v129Ev");}
void  S507C8 ::v130(){vfunc_called(this, "_ZN6S507C84v130Ev");}
void  S507C8 ::v131(){vfunc_called(this, "_ZN6S507C84v131Ev");}
void  S507C8 ::v132(){vfunc_called(this, "_ZN6S507C84v132Ev");}
S507C8 ::S507C8(){ note_ctor("S507C8", this);} // tgen

static void Test_S507C8()
{
  extern Class_Descriptor cd_S507C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,13)];
    init_test(&cd_S507C8, buf);
    S507C8 *dp, &lv = *(dp=new (buf) S507C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,48), "sizeof(S507C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S507C8)");
    check_field_offset(lv, s507c8f0, ABISELECT(8,4), "S507C8.s507c8f0");
    check_field_offset(lv, s507c8f1, ABISELECT(40,36), "S507C8.s507c8f1");
    check_field_offset(lv, s507c8f2, ABISELECT(48,40), "S507C8.s507c8f2");
    check_field_offset(lv, s507c8f3, ABISELECT(56,44), "S507C8.s507c8f3");
    test_class_info(&lv, &cd_S507C8);
    dp->~S507C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS507C8(Test_S507C8, "S507C8", ABISELECT(64,48));

#else // __cplusplus

extern void _ZN6S507C8C1Ev();
extern void _ZN6S507C8D1Ev();
Name_Map name_map_S507C8[] = {
  NSPAIR(_ZN6S507C8C1Ev),
  NSPAIR(_ZN6S507C8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S507C8[];
extern void _ZN6S507C8D1Ev();
extern void _ZN6S507C8D0Ev();
extern void _ZN6S507C84v128Ev();
extern void _ZN6S507C84v129Ev();
extern void _ZN6S507C84v130Ev();
extern void _ZN6S507C84v131Ev();
extern void _ZN6S507C84v132Ev();
static  VTBL_ENTRY vtc_S507C8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S507C8[0]),
  (VTBL_ENTRY)&_ZN6S507C8D1Ev,
  (VTBL_ENTRY)&_ZN6S507C8D0Ev,
  (VTBL_ENTRY)&_ZN6S507C84v128Ev,
  (VTBL_ENTRY)&_ZN6S507C84v129Ev,
  (VTBL_ENTRY)&_ZN6S507C84v130Ev,
  (VTBL_ENTRY)&_ZN6S507C84v131Ev,
  (VTBL_ENTRY)&_ZN6S507C84v132Ev,
};
extern VTBL_ENTRY _ZTI6S507C8[];
extern  VTBL_ENTRY _ZTV6S507C8[];
Class_Descriptor cd_S507C8 = {  "S507C8", // class name
  0,0,//no base classes
  &(vtc_S507C8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,48), // object size
  NSPAIRA(_ZTI6S507C8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S507C8),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S507C7  : S507C8 {
  virtual void  v126(); // _ZN6S507C74v126Ev
  virtual void  v127(); // _ZN6S507C74v127Ev
  ~S507C7(); // tgen
  S507C7(); // tgen
};
//SIG(-1 S507C7) C1{ BC2{ vd v3 v4 v5 v6 v7 Fi[8] Fp Fi Fp} v1 v2}


void  S507C7 ::v126(){vfunc_called(this, "_ZN6S507C74v126Ev");}
void  S507C7 ::v127(){vfunc_called(this, "_ZN6S507C74v127Ev");}
S507C7 ::~S507C7(){ note_dtor("S507C7", this);} // tgen
S507C7 ::S507C7(){ note_ctor("S507C7", this);} // tgen

static void Test_S507C7()
{
  extern Class_Descriptor cd_S507C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,13)];
    init_test(&cd_S507C7, buf);
    S507C7 *dp, &lv = *(dp=new (buf) S507C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,48), "sizeof(S507C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S507C7)");
    check_base_class_offset(lv, (S507C8*), 0, "S507C7");
    test_class_info(&lv, &cd_S507C7);
    dp->~S507C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS507C7(Test_S507C7, "S507C7", ABISELECT(64,48));

#else // __cplusplus

extern void _ZN6S507C7C1Ev();
extern void _ZN6S507C7D1Ev();
Name_Map name_map_S507C7[] = {
  NSPAIR(_ZN6S507C7C1Ev),
  NSPAIR(_ZN6S507C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S507C8;
extern VTBL_ENTRY _ZTI6S507C8[];
extern  VTBL_ENTRY _ZTV6S507C8[];
static Base_Class bases_S507C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S507C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S507C7[];
extern void _ZN6S507C7D1Ev();
extern void _ZN6S507C7D0Ev();
extern void _ZN6S507C84v128Ev();
extern void _ZN6S507C84v129Ev();
extern void _ZN6S507C84v130Ev();
extern void _ZN6S507C84v131Ev();
extern void _ZN6S507C84v132Ev();
extern void _ZN6S507C74v126Ev();
extern void _ZN6S507C74v127Ev();
static  VTBL_ENTRY vtc_S507C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S507C7[0]),
  (VTBL_ENTRY)&_ZN6S507C7D1Ev,
  (VTBL_ENTRY)&_ZN6S507C7D0Ev,
  (VTBL_ENTRY)&_ZN6S507C84v128Ev,
  (VTBL_ENTRY)&_ZN6S507C84v129Ev,
  (VTBL_ENTRY)&_ZN6S507C84v130Ev,
  (VTBL_ENTRY)&_ZN6S507C84v131Ev,
  (VTBL_ENTRY)&_ZN6S507C84v132Ev,
  (VTBL_ENTRY)&_ZN6S507C74v126Ev,
  (VTBL_ENTRY)&_ZN6S507C74v127Ev,
};
extern VTBL_ENTRY _ZTI6S507C7[];
extern  VTBL_ENTRY _ZTV6S507C7[];
Class_Descriptor cd_S507C7 = {  "S507C7", // class name
  bases_S507C7, 1,
  &(vtc_S507C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,48), // object size
  NSPAIRA(_ZTI6S507C7),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S507C7),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S507C3  : S507C4 {
  unsigned int s507c3f0:1;
  unsigned int s507c3f1:1;
  unsigned int s507c3f2:1;
  unsigned int s507c3f3:1;
  unsigned int s507c3f4:1;
  unsigned int s507c3f5:1;
  unsigned int s507c3f6:1;
  unsigned int s507c3f7:1;
  unsigned int s507c3f8:1;
  unsigned int s507c3f9:1;
  unsigned int s507c3f10:1;
  unsigned int s507c3f11:1;
  unsigned int s507c3f12:1;
  int s507c3f13[8];
  ::S507C7 s507c3f14;
  unsigned int s507c3f15:1;
  char s507c3f16;
  char s507c3f17[2];
  int s507c3f18[2];
  ::S685C27_nt s507c3f19;
  ::S685C27_nt s507c3f20;
  void *s507c3f21;
  virtual  ~S507C3(); // _ZN6S507C3D1Ev
  virtual void  v89(); // _ZN6S507C33v89Ev
  virtual void  v90(); // _ZN6S507C33v90Ev
  virtual void  v91(); // _ZN6S507C33v91Ev
  virtual void  v92(); // _ZN6S507C33v92Ev
  virtual void  v93(); // _ZN6S507C33v93Ev
  virtual void  v94(); // _ZN6S507C33v94Ev
  virtual void  v95(); // _ZN6S507C33v95Ev
  virtual void  v96(); // _ZN6S507C33v96Ev
  virtual void  v97(); // _ZN6S507C33v97Ev
  virtual void  v98(); // _ZN6S507C33v98Ev
  virtual void  v99(); // _ZN6S507C33v99Ev
  virtual void  v100(); // _ZN6S507C34v100Ev
  virtual void  v101(); // _ZN6S507C34v101Ev
  virtual void  v102(); // _ZN6S507C34v102Ev
  virtual void  v103(); // _ZN6S507C34v103Ev
  virtual void  v104(); // _ZN6S507C34v104Ev
  S507C3(); // tgen
};
//SIG(-1 S507C3) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC5{ BC6{ vd v87 v88 v89 v90 v91 Fi[8] Fp Fi Fp} v85 v86} Fi:1 Fc[3] Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 Fp}


 S507C3 ::~S507C3(){ note_dtor("S507C3", this);}
void  S507C3 ::v89(){vfunc_called(this, "_ZN6S507C33v89Ev");}
void  S507C3 ::v90(){vfunc_called(this, "_ZN6S507C33v90Ev");}
void  S507C3 ::v91(){vfunc_called(this, "_ZN6S507C33v91Ev");}
void  S507C3 ::v92(){vfunc_called(this, "_ZN6S507C33v92Ev");}
void  S507C3 ::v93(){vfunc_called(this, "_ZN6S507C33v93Ev");}
void  S507C3 ::v94(){vfunc_called(this, "_ZN6S507C33v94Ev");}
void  S507C3 ::v95(){vfunc_called(this, "_ZN6S507C33v95Ev");}
void  S507C3 ::v96(){vfunc_called(this, "_ZN6S507C33v96Ev");}
void  S507C3 ::v97(){vfunc_called(this, "_ZN6S507C33v97Ev");}
void  S507C3 ::v98(){vfunc_called(this, "_ZN6S507C33v98Ev");}
void  S507C3 ::v99(){vfunc_called(this, "_ZN6S507C33v99Ev");}
void  S507C3 ::v100(){vfunc_called(this, "_ZN6S507C34v100Ev");}
void  S507C3 ::v101(){vfunc_called(this, "_ZN6S507C34v101Ev");}
void  S507C3 ::v102(){vfunc_called(this, "_ZN6S507C34v102Ev");}
void  S507C3 ::v103(){vfunc_called(this, "_ZN6S507C34v103Ev");}
void  S507C3 ::v104(){vfunc_called(this, "_ZN6S507C34v104Ev");}
S507C3 ::S507C3(){ note_ctor("S507C3", this);} // tgen

static void Test_S507C3()
{
  extern Class_Descriptor cd_S507C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,47)];
    init_test(&cd_S507C3, buf);
    S507C3 *dp, &lv = *(dp=new (buf) S507C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,184), "sizeof(S507C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S507C3)");
    check_base_class_offset(lv, (S507C5*)(S507C4*), 0, "S507C3");
    check_base_class_offset(lv, (S507C4*), 0, "S507C3");
    set_bf_and_test(lv, s507c3f0, ABISELECT(96,60), 0, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f1, ABISELECT(96,60), 1, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f2, ABISELECT(96,60), 2, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f3, ABISELECT(96,60), 3, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f4, ABISELECT(96,60), 4, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f5, ABISELECT(96,60), 5, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f6, ABISELECT(96,60), 6, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f7, ABISELECT(96,60), 7, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f8, ABISELECT(97,61), 0, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f9, ABISELECT(97,61), 1, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f10, ABISELECT(97,61), 2, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f11, ABISELECT(97,61), 3, 1, 1, "S507C3");
    set_bf_and_test(lv, s507c3f12, ABISELECT(97,61), 4, 1, 1, "S507C3");
    check_field_offset(lv, s507c3f13, ABISELECT(100,64), "S507C3.s507c3f13");
    check_field_offset(lv, s507c3f14, ABISELECT(136,96), "S507C3.s507c3f14");
    set_bf_and_test(lv, s507c3f15, ABISELECT(200,144), 0, 1, 1, "S507C3");
    check_field_offset(lv, s507c3f16, ABISELECT(201,145), "S507C3.s507c3f16");
    check_field_offset(lv, s507c3f17, ABISELECT(202,146), "S507C3.s507c3f17");
    check_field_offset(lv, s507c3f18, ABISELECT(204,148), "S507C3.s507c3f18");
    check_field_offset(lv, s507c3f19, ABISELECT(216,156), "S507C3.s507c3f19");
    check_field_offset(lv, s507c3f20, ABISELECT(232,168), "S507C3.s507c3f20");
    check_field_offset(lv, s507c3f21, ABISELECT(248,180), "S507C3.s507c3f21");
    test_class_info(&lv, &cd_S507C3);
    dp->~S507C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS507C3(Test_S507C3, "S507C3", ABISELECT(256,184));

#else // __cplusplus

extern void _ZN6S507C3C1Ev();
extern void _ZN6S507C3D1Ev();
Name_Map name_map_S507C3[] = {
  NSPAIR(_ZN6S507C3C1Ev),
  NSPAIR(_ZN6S507C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S507C5;
extern VTBL_ENTRY _ZTI6S507C5[];
extern  VTBL_ENTRY _ZTV6S507C5[];
extern Class_Descriptor cd_S507C4;
extern VTBL_ENTRY _ZTI6S507C4[];
extern  VTBL_ENTRY _ZTV6S507C4[];
static Base_Class bases_S507C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S507C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S507C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S507C3[];
extern void _ZN6S507C3D1Ev();
extern void _ZN6S507C3D0Ev();
extern void _ZN6S507C53v21Ev();
extern void _ZN6S507C53v22Ev();
extern void _ZN6S507C53v23Ev();
extern void _ZN6S507C53v24Ev();
extern void _ZN6S507C53v25Ev();
extern void _ZN6S507C53v26Ev();
extern void _ZN6S507C53v27Ev();
extern void _ZN6S507C53v28Ev();
extern void _ZN6S507C53v29Ev();
extern void _ZN6S507C53v30Ev();
extern void _ZN6S507C53v31Ev();
extern void _ZN6S507C53v32Ev();
extern void _ZN6S507C53v33Ev();
extern void _ZN6S507C53v34Ev();
extern void _ZN6S507C53v35Ev();
extern void _ZN6S507C53v36Ev();
extern void _ZN6S507C53v37Ev();
extern void _ZN6S507C53v38Ev();
extern void _ZN6S507C53v39Ev();
extern void _ZN6S507C53v40Ev();
extern void _ZN6S507C53v41Ev();
extern void _ZN6S507C53v42Ev();
extern void _ZN6S507C53v43Ev();
extern void _ZN6S507C53v44Ev();
extern void _ZN6S507C53v45Ev();
extern void _ZN6S507C53v46Ev();
extern void _ZN6S507C53v47Ev();
extern void _ZN6S507C53v48Ev();
extern void _ZN6S507C53v49Ev();
extern void _ZN6S507C53v50Ev();
extern void _ZN6S507C53v51Ev();
extern void _ZN6S507C53v52Ev();
extern void _ZN6S507C53v53Ev();
extern void _ZN6S507C53v54Ev();
extern void _ZN6S507C53v55Ev();
extern void _ZN6S507C53v56Ev();
extern void _ZN6S507C53v57Ev();
extern void _ZN6S507C53v58Ev();
extern void _ZN6S507C53v59Ev();
extern void _ZN6S507C53v60Ev();
extern void _ZN6S507C53v61Ev();
extern void _ZN6S507C53v62Ev();
extern void _ZN6S507C53v63Ev();
extern void _ZN6S507C53v64Ev();
extern void _ZN6S507C53v65Ev();
extern void _ZN6S507C53v66Ev();
extern void _ZN6S507C53v67Ev();
extern void _ZN6S507C53v68Ev();
extern void _ZN6S507C53v69Ev();
extern void _ZN6S507C53v70Ev();
extern void _ZN6S507C53v71Ev();
extern void _ZN6S507C53v72Ev();
extern void _ZN6S507C53v73Ev();
extern void _ZN6S507C53v74Ev();
extern void _ZN6S507C53v75Ev();
extern void _ZN6S507C53v76Ev();
extern void _ZN6S507C53v77Ev();
extern void _ZN6S507C53v78Ev();
extern void _ZN6S507C53v79Ev();
extern void _ZN6S507C53v80Ev();
extern void _ZN6S507C53v81Ev();
extern void _ZN6S507C53v82Ev();
extern void _ZN6S507C53v83Ev();
extern void _ZN6S507C53v84Ev();
extern void _ZN6S507C43v85Ev();
extern void _ZN6S507C43v86Ev();
extern void _ZN6S507C43v87Ev();
extern void _ZN6S507C43v88Ev();
extern void _ZN6S507C33v89Ev();
extern void _ZN6S507C33v90Ev();
extern void _ZN6S507C33v91Ev();
extern void _ZN6S507C33v92Ev();
extern void _ZN6S507C33v93Ev();
extern void _ZN6S507C33v94Ev();
extern void _ZN6S507C33v95Ev();
extern void _ZN6S507C33v96Ev();
extern void _ZN6S507C33v97Ev();
extern void _ZN6S507C33v98Ev();
extern void _ZN6S507C33v99Ev();
extern void _ZN6S507C34v100Ev();
extern void _ZN6S507C34v101Ev();
extern void _ZN6S507C34v102Ev();
extern void _ZN6S507C34v103Ev();
extern void _ZN6S507C34v104Ev();
static  VTBL_ENTRY vtc_S507C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S507C3[0]),
  (VTBL_ENTRY)&_ZN6S507C3D1Ev,
  (VTBL_ENTRY)&_ZN6S507C3D0Ev,
  (VTBL_ENTRY)&_ZN6S507C53v21Ev,
  (VTBL_ENTRY)&_ZN6S507C53v22Ev,
  (VTBL_ENTRY)&_ZN6S507C53v23Ev,
  (VTBL_ENTRY)&_ZN6S507C53v24Ev,
  (VTBL_ENTRY)&_ZN6S507C53v25Ev,
  (VTBL_ENTRY)&_ZN6S507C53v26Ev,
  (VTBL_ENTRY)&_ZN6S507C53v27Ev,
  (VTBL_ENTRY)&_ZN6S507C53v28Ev,
  (VTBL_ENTRY)&_ZN6S507C53v29Ev,
  (VTBL_ENTRY)&_ZN6S507C53v30Ev,
  (VTBL_ENTRY)&_ZN6S507C53v31Ev,
  (VTBL_ENTRY)&_ZN6S507C53v32Ev,
  (VTBL_ENTRY)&_ZN6S507C53v33Ev,
  (VTBL_ENTRY)&_ZN6S507C53v34Ev,
  (VTBL_ENTRY)&_ZN6S507C53v35Ev,
  (VTBL_ENTRY)&_ZN6S507C53v36Ev,
  (VTBL_ENTRY)&_ZN6S507C53v37Ev,
  (VTBL_ENTRY)&_ZN6S507C53v38Ev,
  (VTBL_ENTRY)&_ZN6S507C53v39Ev,
  (VTBL_ENTRY)&_ZN6S507C53v40Ev,
  (VTBL_ENTRY)&_ZN6S507C53v41Ev,
  (VTBL_ENTRY)&_ZN6S507C53v42Ev,
  (VTBL_ENTRY)&_ZN6S507C53v43Ev,
  (VTBL_ENTRY)&_ZN6S507C53v44Ev,
  (VTBL_ENTRY)&_ZN6S507C53v45Ev,
  (VTBL_ENTRY)&_ZN6S507C53v46Ev,
  (VTBL_ENTRY)&_ZN6S507C53v47Ev,
  (VTBL_ENTRY)&_ZN6S507C53v48Ev,
  (VTBL_ENTRY)&_ZN6S507C53v49Ev,
  (VTBL_ENTRY)&_ZN6S507C53v50Ev,
  (VTBL_ENTRY)&_ZN6S507C53v51Ev,
  (VTBL_ENTRY)&_ZN6S507C53v52Ev,
  (VTBL_ENTRY)&_ZN6S507C53v53Ev,
  (VTBL_ENTRY)&_ZN6S507C53v54Ev,
  (VTBL_ENTRY)&_ZN6S507C53v55Ev,
  (VTBL_ENTRY)&_ZN6S507C53v56Ev,
  (VTBL_ENTRY)&_ZN6S507C53v57Ev,
  (VTBL_ENTRY)&_ZN6S507C53v58Ev,
  (VTBL_ENTRY)&_ZN6S507C53v59Ev,
  (VTBL_ENTRY)&_ZN6S507C53v60Ev,
  (VTBL_ENTRY)&_ZN6S507C53v61Ev,
  (VTBL_ENTRY)&_ZN6S507C53v62Ev,
  (VTBL_ENTRY)&_ZN6S507C53v63Ev,
  (VTBL_ENTRY)&_ZN6S507C53v64Ev,
  (VTBL_ENTRY)&_ZN6S507C53v65Ev,
  (VTBL_ENTRY)&_ZN6S507C53v66Ev,
  (VTBL_ENTRY)&_ZN6S507C53v67Ev,
  (VTBL_ENTRY)&_ZN6S507C53v68Ev,
  (VTBL_ENTRY)&_ZN6S507C53v69Ev,
  (VTBL_ENTRY)&_ZN6S507C53v70Ev,
  (VTBL_ENTRY)&_ZN6S507C53v71Ev,
  (VTBL_ENTRY)&_ZN6S507C53v72Ev,
  (VTBL_ENTRY)&_ZN6S507C53v73Ev,
  (VTBL_ENTRY)&_ZN6S507C53v74Ev,
  (VTBL_ENTRY)&_ZN6S507C53v75Ev,
  (VTBL_ENTRY)&_ZN6S507C53v76Ev,
  (VTBL_ENTRY)&_ZN6S507C53v77Ev,
  (VTBL_ENTRY)&_ZN6S507C53v78Ev,
  (VTBL_ENTRY)&_ZN6S507C53v79Ev,
  (VTBL_ENTRY)&_ZN6S507C53v80Ev,
  (VTBL_ENTRY)&_ZN6S507C53v81Ev,
  (VTBL_ENTRY)&_ZN6S507C53v82Ev,
  (VTBL_ENTRY)&_ZN6S507C53v83Ev,
  (VTBL_ENTRY)&_ZN6S507C53v84Ev,
  (VTBL_ENTRY)&_ZN6S507C43v85Ev,
  (VTBL_ENTRY)&_ZN6S507C43v86Ev,
  (VTBL_ENTRY)&_ZN6S507C43v87Ev,
  (VTBL_ENTRY)&_ZN6S507C43v88Ev,
  (VTBL_ENTRY)&_ZN6S507C33v89Ev,
  (VTBL_ENTRY)&_ZN6S507C33v90Ev,
  (VTBL_ENTRY)&_ZN6S507C33v91Ev,
  (VTBL_ENTRY)&_ZN6S507C33v92Ev,
  (VTBL_ENTRY)&_ZN6S507C33v93Ev,
  (VTBL_ENTRY)&_ZN6S507C33v94Ev,
  (VTBL_ENTRY)&_ZN6S507C33v95Ev,
  (VTBL_ENTRY)&_ZN6S507C33v96Ev,
  (VTBL_ENTRY)&_ZN6S507C33v97Ev,
  (VTBL_ENTRY)&_ZN6S507C33v98Ev,
  (VTBL_ENTRY)&_ZN6S507C33v99Ev,
  (VTBL_ENTRY)&_ZN6S507C34v100Ev,
  (VTBL_ENTRY)&_ZN6S507C34v101Ev,
  (VTBL_ENTRY)&_ZN6S507C34v102Ev,
  (VTBL_ENTRY)&_ZN6S507C34v103Ev,
  (VTBL_ENTRY)&_ZN6S507C34v104Ev,
};
extern VTBL_ENTRY _ZTI6S507C3[];
extern  VTBL_ENTRY _ZTV6S507C3[];
Class_Descriptor cd_S507C3 = {  "S507C3", // class name
  bases_S507C3, 2,
  &(vtc_S507C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,184), // object size
  NSPAIRA(_ZTI6S507C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S507C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S507C15_nt  {
  void *s507c15f0[3];
  void  mf507c15(); // _ZN10S507C15_nt8mf507c15Ev
};
//SIG(-1 S507C15_nt) C1{ m Fp[3]}


void  S507C15_nt ::mf507c15(){}

//skip512 S507C15_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S507C2  : S507C3 {
  ::S685C40 s507c2f0;
  int s507c2f1[2];
  char s507c2f2[3];
  unsigned int s507c2f3:1;
  unsigned int s507c2f4:1;
  unsigned int s507c2f5:1;
  unsigned int s507c2f6:1;
  unsigned int s507c2f7:1;
  int s507c2f8;
  ::S695C22_nt s507c2f9;
  int s507c2f10[2];
  ::S685C10_nt s507c2f11;
  ::S507C15_nt s507c2f12;
  int s507c2f13;
  void *s507c2f14;
  int s507c2f15;
  virtual  ~S507C2(); // _ZN6S507C2D1Ev
  virtual void  v105(); // _ZN6S507C24v105Ev
  virtual void  v106(); // _ZN6S507C24v106Ev
  virtual void  v107(); // _ZN6S507C24v107Ev
  virtual void  v108(); // _ZN6S507C24v108Ev
  virtual void  v109(); // _ZN6S507C24v109Ev
  virtual void  v110(); // _ZN6S507C24v110Ev
  virtual void  v111(); // _ZN6S507C24v111Ev
  virtual void  v112(); // _ZN6S507C24v112Ev
  virtual void  v113(); // _ZN6S507C24v113Ev
  virtual void  v114(); // _ZN6S507C24v114Ev
  virtual void  v115(); // _ZN6S507C24v115Ev
  virtual void  v116(); // _ZN6S507C24v116Ev
  virtual void  v117(); // _ZN6S507C24v117Ev
  virtual void  v118(); // _ZN6S507C24v118Ev
  virtual void  v119(); // _ZN6S507C24v119Ev
  virtual void  v120(); // _ZN6S507C24v120Ev
  S507C2(); // tgen
};
//SIG(-1 S507C2) C1{ BC2{ BC3{ BC4{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC6{ BC7{ vd v103 v104 v105 v106 v107 Fi[8] Fp Fi Fp} v101 v102} Fi:1 Fc[3] Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 FC12{ BC11} Fi[2] Fc[3] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC5 Fi[2] FC13{ m Fi} FC14{ m Fp[3]} Fi Fp Fi}


 S507C2 ::~S507C2(){ note_dtor("S507C2", this);}
void  S507C2 ::v105(){vfunc_called(this, "_ZN6S507C24v105Ev");}
void  S507C2 ::v106(){vfunc_called(this, "_ZN6S507C24v106Ev");}
void  S507C2 ::v107(){vfunc_called(this, "_ZN6S507C24v107Ev");}
void  S507C2 ::v108(){vfunc_called(this, "_ZN6S507C24v108Ev");}
void  S507C2 ::v109(){vfunc_called(this, "_ZN6S507C24v109Ev");}
void  S507C2 ::v110(){vfunc_called(this, "_ZN6S507C24v110Ev");}
void  S507C2 ::v111(){vfunc_called(this, "_ZN6S507C24v111Ev");}
void  S507C2 ::v112(){vfunc_called(this, "_ZN6S507C24v112Ev");}
void  S507C2 ::v113(){vfunc_called(this, "_ZN6S507C24v113Ev");}
void  S507C2 ::v114(){vfunc_called(this, "_ZN6S507C24v114Ev");}
void  S507C2 ::v115(){vfunc_called(this, "_ZN6S507C24v115Ev");}
void  S507C2 ::v116(){vfunc_called(this, "_ZN6S507C24v116Ev");}
void  S507C2 ::v117(){vfunc_called(this, "_ZN6S507C24v117Ev");}
void  S507C2 ::v118(){vfunc_called(this, "_ZN6S507C24v118Ev");}
void  S507C2 ::v119(){vfunc_called(this, "_ZN6S507C24v119Ev");}
void  S507C2 ::v120(){vfunc_called(this, "_ZN6S507C24v120Ev");}
S507C2 ::S507C2(){ note_ctor("S507C2", this);} // tgen

static void Test_S507C2()
{
  extern Class_Descriptor cd_S507C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,65)];
    init_test(&cd_S507C2, buf);
    S507C2 *dp, &lv = *(dp=new (buf) S507C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,256), "sizeof(S507C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S507C2)");
    check_base_class_offset(lv, (S507C5*)(S507C4*)(S507C3*), 0, "S507C2");
    check_base_class_offset(lv, (S507C4*)(S507C3*), 0, "S507C2");
    check_base_class_offset(lv, (S507C3*), 0, "S507C2");
    check_field_offset(lv, s507c2f0, ABISELECT(256,184), "S507C2.s507c2f0");
    check_field_offset(lv, s507c2f1, ABISELECT(272,196), "S507C2.s507c2f1");
    check_field_offset(lv, s507c2f2, ABISELECT(280,204), "S507C2.s507c2f2");
    set_bf_and_test(lv, s507c2f3, ABISELECT(283,207), 0, 1, 1, "S507C2");
    set_bf_and_test(lv, s507c2f4, ABISELECT(283,207), 1, 1, 1, "S507C2");
    set_bf_and_test(lv, s507c2f5, ABISELECT(283,207), 2, 1, 1, "S507C2");
    set_bf_and_test(lv, s507c2f6, ABISELECT(283,207), 3, 1, 1, "S507C2");
    set_bf_and_test(lv, s507c2f7, ABISELECT(283,207), 4, 1, 1, "S507C2");
    check_field_offset(lv, s507c2f8, ABISELECT(284,208), "S507C2.s507c2f8");
    check_field_offset(lv, s507c2f9, ABISELECT(288,212), "S507C2.s507c2f9");
    check_field_offset(lv, s507c2f10, ABISELECT(296,220), "S507C2.s507c2f10");
    check_field_offset(lv, s507c2f11, ABISELECT(304,228), "S507C2.s507c2f11");
    check_field_offset(lv, s507c2f12, ABISELECT(312,232), "S507C2.s507c2f12");
    check_field_offset(lv, s507c2f13, ABISELECT(336,244), "S507C2.s507c2f13");
    check_field_offset(lv, s507c2f14, ABISELECT(344,248), "S507C2.s507c2f14");
    check_field_offset(lv, s507c2f15, ABISELECT(352,252), "S507C2.s507c2f15");
    test_class_info(&lv, &cd_S507C2);
    dp->~S507C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS507C2(Test_S507C2, "S507C2", ABISELECT(360,256));

#else // __cplusplus

extern void _ZN6S507C2C1Ev();
extern void _ZN6S507C2D1Ev();
Name_Map name_map_S507C2[] = {
  NSPAIR(_ZN6S507C2C1Ev),
  NSPAIR(_ZN6S507C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S507C5;
extern VTBL_ENTRY _ZTI6S507C5[];
extern  VTBL_ENTRY _ZTV6S507C5[];
extern Class_Descriptor cd_S507C4;
extern VTBL_ENTRY _ZTI6S507C4[];
extern  VTBL_ENTRY _ZTV6S507C4[];
extern Class_Descriptor cd_S507C3;
extern VTBL_ENTRY _ZTI6S507C3[];
extern  VTBL_ENTRY _ZTV6S507C3[];
static Base_Class bases_S507C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S507C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S507C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S507C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S507C2[];
extern void _ZN6S507C2D1Ev();
extern void _ZN6S507C2D0Ev();
extern void _ZN6S507C53v21Ev();
extern void _ZN6S507C53v22Ev();
extern void _ZN6S507C53v23Ev();
extern void _ZN6S507C53v24Ev();
extern void _ZN6S507C53v25Ev();
extern void _ZN6S507C53v26Ev();
extern void _ZN6S507C53v27Ev();
extern void _ZN6S507C53v28Ev();
extern void _ZN6S507C53v29Ev();
extern void _ZN6S507C53v30Ev();
extern void _ZN6S507C53v31Ev();
extern void _ZN6S507C53v32Ev();
extern void _ZN6S507C53v33Ev();
extern void _ZN6S507C53v34Ev();
extern void _ZN6S507C53v35Ev();
extern void _ZN6S507C53v36Ev();
extern void _ZN6S507C53v37Ev();
extern void _ZN6S507C53v38Ev();
extern void _ZN6S507C53v39Ev();
extern void _ZN6S507C53v40Ev();
extern void _ZN6S507C53v41Ev();
extern void _ZN6S507C53v42Ev();
extern void _ZN6S507C53v43Ev();
extern void _ZN6S507C53v44Ev();
extern void _ZN6S507C53v45Ev();
extern void _ZN6S507C53v46Ev();
extern void _ZN6S507C53v47Ev();
extern void _ZN6S507C53v48Ev();
extern void _ZN6S507C53v49Ev();
extern void _ZN6S507C53v50Ev();
extern void _ZN6S507C53v51Ev();
extern void _ZN6S507C53v52Ev();
extern void _ZN6S507C53v53Ev();
extern void _ZN6S507C53v54Ev();
extern void _ZN6S507C53v55Ev();
extern void _ZN6S507C53v56Ev();
extern void _ZN6S507C53v57Ev();
extern void _ZN6S507C53v58Ev();
extern void _ZN6S507C53v59Ev();
extern void _ZN6S507C53v60Ev();
extern void _ZN6S507C53v61Ev();
extern void _ZN6S507C53v62Ev();
extern void _ZN6S507C53v63Ev();
extern void _ZN6S507C53v64Ev();
extern void _ZN6S507C53v65Ev();
extern void _ZN6S507C53v66Ev();
extern void _ZN6S507C53v67Ev();
extern void _ZN6S507C53v68Ev();
extern void _ZN6S507C53v69Ev();
extern void _ZN6S507C53v70Ev();
extern void _ZN6S507C53v71Ev();
extern void _ZN6S507C53v72Ev();
extern void _ZN6S507C53v73Ev();
extern void _ZN6S507C53v74Ev();
extern void _ZN6S507C53v75Ev();
extern void _ZN6S507C53v76Ev();
extern void _ZN6S507C53v77Ev();
extern void _ZN6S507C53v78Ev();
extern void _ZN6S507C53v79Ev();
extern void _ZN6S507C53v80Ev();
extern void _ZN6S507C53v81Ev();
extern void _ZN6S507C53v82Ev();
extern void _ZN6S507C53v83Ev();
extern void _ZN6S507C53v84Ev();
extern void _ZN6S507C43v85Ev();
extern void _ZN6S507C43v86Ev();
extern void _ZN6S507C43v87Ev();
extern void _ZN6S507C43v88Ev();
extern void _ZN6S507C33v89Ev();
extern void _ZN6S507C33v90Ev();
extern void _ZN6S507C33v91Ev();
extern void _ZN6S507C33v92Ev();
extern void _ZN6S507C33v93Ev();
extern void _ZN6S507C33v94Ev();
extern void _ZN6S507C33v95Ev();
extern void _ZN6S507C33v96Ev();
extern void _ZN6S507C33v97Ev();
extern void _ZN6S507C33v98Ev();
extern void _ZN6S507C33v99Ev();
extern void _ZN6S507C34v100Ev();
extern void _ZN6S507C34v101Ev();
extern void _ZN6S507C34v102Ev();
extern void _ZN6S507C34v103Ev();
extern void _ZN6S507C34v104Ev();
extern void _ZN6S507C24v105Ev();
extern void _ZN6S507C24v106Ev();
extern void _ZN6S507C24v107Ev();
extern void _ZN6S507C24v108Ev();
extern void _ZN6S507C24v109Ev();
extern void _ZN6S507C24v110Ev();
extern void _ZN6S507C24v111Ev();
extern void _ZN6S507C24v112Ev();
extern void _ZN6S507C24v113Ev();
extern void _ZN6S507C24v114Ev();
extern void _ZN6S507C24v115Ev();
extern void _ZN6S507C24v116Ev();
extern void _ZN6S507C24v117Ev();
extern void _ZN6S507C24v118Ev();
extern void _ZN6S507C24v119Ev();
extern void _ZN6S507C24v120Ev();
static  VTBL_ENTRY vtc_S507C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S507C2[0]),
  (VTBL_ENTRY)&_ZN6S507C2D1Ev,
  (VTBL_ENTRY)&_ZN6S507C2D0Ev,
  (VTBL_ENTRY)&_ZN6S507C53v21Ev,
  (VTBL_ENTRY)&_ZN6S507C53v22Ev,
  (VTBL_ENTRY)&_ZN6S507C53v23Ev,
  (VTBL_ENTRY)&_ZN6S507C53v24Ev,
  (VTBL_ENTRY)&_ZN6S507C53v25Ev,
  (VTBL_ENTRY)&_ZN6S507C53v26Ev,
  (VTBL_ENTRY)&_ZN6S507C53v27Ev,
  (VTBL_ENTRY)&_ZN6S507C53v28Ev,
  (VTBL_ENTRY)&_ZN6S507C53v29Ev,
  (VTBL_ENTRY)&_ZN6S507C53v30Ev,
  (VTBL_ENTRY)&_ZN6S507C53v31Ev,
  (VTBL_ENTRY)&_ZN6S507C53v32Ev,
  (VTBL_ENTRY)&_ZN6S507C53v33Ev,
  (VTBL_ENTRY)&_ZN6S507C53v34Ev,
  (VTBL_ENTRY)&_ZN6S507C53v35Ev,
  (VTBL_ENTRY)&_ZN6S507C53v36Ev,
  (VTBL_ENTRY)&_ZN6S507C53v37Ev,
  (VTBL_ENTRY)&_ZN6S507C53v38Ev,
  (VTBL_ENTRY)&_ZN6S507C53v39Ev,
  (VTBL_ENTRY)&_ZN6S507C53v40Ev,
  (VTBL_ENTRY)&_ZN6S507C53v41Ev,
  (VTBL_ENTRY)&_ZN6S507C53v42Ev,
  (VTBL_ENTRY)&_ZN6S507C53v43Ev,
  (VTBL_ENTRY)&_ZN6S507C53v44Ev,
  (VTBL_ENTRY)&_ZN6S507C53v45Ev,
  (VTBL_ENTRY)&_ZN6S507C53v46Ev,
  (VTBL_ENTRY)&_ZN6S507C53v47Ev,
  (VTBL_ENTRY)&_ZN6S507C53v48Ev,
  (VTBL_ENTRY)&_ZN6S507C53v49Ev,
  (VTBL_ENTRY)&_ZN6S507C53v50Ev,
  (VTBL_ENTRY)&_ZN6S507C53v51Ev,
  (VTBL_ENTRY)&_ZN6S507C53v52Ev,
  (VTBL_ENTRY)&_ZN6S507C53v53Ev,
  (VTBL_ENTRY)&_ZN6S507C53v54Ev,
  (VTBL_ENTRY)&_ZN6S507C53v55Ev,
  (VTBL_ENTRY)&_ZN6S507C53v56Ev,
  (VTBL_ENTRY)&_ZN6S507C53v57Ev,
  (VTBL_ENTRY)&_ZN6S507C53v58Ev,
  (VTBL_ENTRY)&_ZN6S507C53v59Ev,
  (VTBL_ENTRY)&_ZN6S507C53v60Ev,
  (VTBL_ENTRY)&_ZN6S507C53v61Ev,
  (VTBL_ENTRY)&_ZN6S507C53v62Ev,
  (VTBL_ENTRY)&_ZN6S507C53v63Ev,
  (VTBL_ENTRY)&_ZN6S507C53v64Ev,
  (VTBL_ENTRY)&_ZN6S507C53v65Ev,
  (VTBL_ENTRY)&_ZN6S507C53v66Ev,
  (VTBL_ENTRY)&_ZN6S507C53v67Ev,
  (VTBL_ENTRY)&_ZN6S507C53v68Ev,
  (VTBL_ENTRY)&_ZN6S507C53v69Ev,
  (VTBL_ENTRY)&_ZN6S507C53v70Ev,
  (VTBL_ENTRY)&_ZN6S507C53v71Ev,
  (VTBL_ENTRY)&_ZN6S507C53v72Ev,
  (VTBL_ENTRY)&_ZN6S507C53v73Ev,
  (VTBL_ENTRY)&_ZN6S507C53v74Ev,
  (VTBL_ENTRY)&_ZN6S507C53v75Ev,
  (VTBL_ENTRY)&_ZN6S507C53v76Ev,
  (VTBL_ENTRY)&_ZN6S507C53v77Ev,
  (VTBL_ENTRY)&_ZN6S507C53v78Ev,
  (VTBL_ENTRY)&_ZN6S507C53v79Ev,
  (VTBL_ENTRY)&_ZN6S507C53v80Ev,
  (VTBL_ENTRY)&_ZN6S507C53v81Ev,
  (VTBL_ENTRY)&_ZN6S507C53v82Ev,
  (VTBL_ENTRY)&_ZN6S507C53v83Ev,
  (VTBL_ENTRY)&_ZN6S507C53v84Ev,
  (VTBL_ENTRY)&_ZN6S507C43v85Ev,
  (VTBL_ENTRY)&_ZN6S507C43v86Ev,
  (VTBL_ENTRY)&_ZN6S507C43v87Ev,
  (VTBL_ENTRY)&_ZN6S507C43v88Ev,
  (VTBL_ENTRY)&_ZN6S507C33v89Ev,
  (VTBL_ENTRY)&_ZN6S507C33v90Ev,
  (VTBL_ENTRY)&_ZN6S507C33v91Ev,
  (VTBL_ENTRY)&_ZN6S507C33v92Ev,
  (VTBL_ENTRY)&_ZN6S507C33v93Ev,
  (VTBL_ENTRY)&_ZN6S507C33v94Ev,
  (VTBL_ENTRY)&_ZN6S507C33v95Ev,
  (VTBL_ENTRY)&_ZN6S507C33v96Ev,
  (VTBL_ENTRY)&_ZN6S507C33v97Ev,
  (VTBL_ENTRY)&_ZN6S507C33v98Ev,
  (VTBL_ENTRY)&_ZN6S507C33v99Ev,
  (VTBL_ENTRY)&_ZN6S507C34v100Ev,
  (VTBL_ENTRY)&_ZN6S507C34v101Ev,
  (VTBL_ENTRY)&_ZN6S507C34v102Ev,
  (VTBL_ENTRY)&_ZN6S507C34v103Ev,
  (VTBL_ENTRY)&_ZN6S507C34v104Ev,
  (VTBL_ENTRY)&_ZN6S507C24v105Ev,
  (VTBL_ENTRY)&_ZN6S507C24v106Ev,
  (VTBL_ENTRY)&_ZN6S507C24v107Ev,
  (VTBL_ENTRY)&_ZN6S507C24v108Ev,
  (VTBL_ENTRY)&_ZN6S507C24v109Ev,
  (VTBL_ENTRY)&_ZN6S507C24v110Ev,
  (VTBL_ENTRY)&_ZN6S507C24v111Ev,
  (VTBL_ENTRY)&_ZN6S507C24v112Ev,
  (VTBL_ENTRY)&_ZN6S507C24v113Ev,
  (VTBL_ENTRY)&_ZN6S507C24v114Ev,
  (VTBL_ENTRY)&_ZN6S507C24v115Ev,
  (VTBL_ENTRY)&_ZN6S507C24v116Ev,
  (VTBL_ENTRY)&_ZN6S507C24v117Ev,
  (VTBL_ENTRY)&_ZN6S507C24v118Ev,
  (VTBL_ENTRY)&_ZN6S507C24v119Ev,
  (VTBL_ENTRY)&_ZN6S507C24v120Ev,
};
extern VTBL_ENTRY _ZTI6S507C2[];
extern  VTBL_ENTRY _ZTV6S507C2[];
Class_Descriptor cd_S507C2 = {  "S507C2", // class name
  bases_S507C2, 3,
  &(vtc_S507C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,256), // object size
  NSPAIRA(_ZTI6S507C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S507C2),104, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S507C16_nt  {
  virtual  ~S507C16_nt(); // _ZN10S507C16_ntD1Ev
  virtual void  v121(); // _ZN10S507C16_nt4v121Ev
  virtual void  v122(); // _ZN10S507C16_nt4v122Ev
  virtual void  v123(); // _ZN10S507C16_nt4v123Ev
  virtual void  v124(); // _ZN10S507C16_nt4v124Ev
  virtual void  v125(); // _ZN10S507C16_nt4v125Ev
  S507C16_nt(); // tgen
};
//SIG(-1 S507C16_nt) C1{ vd v1 v2 v3 v4 v5}


 S507C16_nt ::~S507C16_nt(){ note_dtor("S507C16_nt", this);}
void  S507C16_nt ::v121(){vfunc_called(this, "_ZN10S507C16_nt4v121Ev");}
void  S507C16_nt ::v122(){vfunc_called(this, "_ZN10S507C16_nt4v122Ev");}
void  S507C16_nt ::v123(){vfunc_called(this, "_ZN10S507C16_nt4v123Ev");}
void  S507C16_nt ::v124(){vfunc_called(this, "_ZN10S507C16_nt4v124Ev");}
void  S507C16_nt ::v125(){vfunc_called(this, "_ZN10S507C16_nt4v125Ev");}
S507C16_nt ::S507C16_nt(){ note_ctor("S507C16_nt", this);} // tgen

//skip512 S507C16_nt

#else // __cplusplus

extern void _ZN10S507C16_ntC1Ev();
extern void _ZN10S507C16_ntD1Ev();
Name_Map name_map_S507C16_nt[] = {
  NSPAIR(_ZN10S507C16_ntC1Ev),
  NSPAIR(_ZN10S507C16_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S507C16_nt[];
extern void _ZN10S507C16_ntD1Ev();
extern void _ZN10S507C16_ntD0Ev();
extern void _ZN10S507C16_nt4v121Ev();
extern void _ZN10S507C16_nt4v122Ev();
extern void _ZN10S507C16_nt4v123Ev();
extern void _ZN10S507C16_nt4v124Ev();
extern void _ZN10S507C16_nt4v125Ev();
static  VTBL_ENTRY vtc_S507C16_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S507C16_nt[0]),
  (VTBL_ENTRY)&_ZN10S507C16_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S507C16_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S507C16_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S507C16_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S507C16_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S507C16_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S507C16_nt4v125Ev,
};
extern VTBL_ENTRY _ZTI10S507C16_nt[];
VTBL_ENTRY *P__ZTI10S507C16_nt = _ZTI10S507C16_nt; 
extern  VTBL_ENTRY _ZTV10S507C16_nt[];
Class_Descriptor cd_S507C16_nt = {  "S507C16_nt", // class name
  0,0,//no base classes
  &(vtc_S507C16_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S507C16_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S507C16_nt),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S507C1  : S507C2 , S507C16_nt {
  int s507c1f0[4];
  unsigned int s507c1f1:1;
  unsigned int s507c1f2:1;
  unsigned int s507c1f3:1;
  unsigned int s507c1f4:1;
  int s507c1f5[2];
  char s507c1f6;
  int s507c1f7[6];
  void *s507c1f8;
  virtual  ~S507C1(); // _ZN6S507C1D1Ev
  virtual void  v1(); // _ZN6S507C12v1Ev
  virtual void  v2(); // _ZN6S507C12v2Ev
  virtual void  v3(); // _ZN6S507C12v3Ev
  virtual void  v4(); // _ZN6S507C12v4Ev
  virtual void  v5(); // _ZN6S507C12v5Ev
  virtual void  v6(); // _ZN6S507C12v6Ev
  virtual void  v7(); // _ZN6S507C12v7Ev
  virtual void  v8(); // _ZN6S507C12v8Ev
  virtual void  v9(); // _ZN6S507C12v9Ev
  virtual void  v10(); // _ZN6S507C13v10Ev
  virtual void  v11(); // _ZN6S507C13v11Ev
  virtual void  v12(); // _ZN6S507C13v12Ev
  virtual void  v13(); // _ZN6S507C13v13Ev
  virtual void  v14(); // _ZN6S507C13v14Ev
  virtual void  v15(); // _ZN6S507C13v15Ev
  virtual void  v16(); // _ZN6S507C13v16Ev
  virtual void  v17(); // _ZN6S507C13v17Ev
  virtual void  v18(); // _ZN6S507C13v18Ev
  virtual void  v19(); // _ZN6S507C13v19Ev
  virtual void  v20(); // _ZN6S507C13v20Ev
  S507C1(); // tgen
};
//SIG(1 S507C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC7{ BC8{ vd v128 v129 v130 v131 v132 Fi[8] Fp Fi Fp} v126 v127} Fi:1 Fc[3] Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 Fp} vd v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 FC13{ BC12} Fi[2] Fc[3] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC6 Fi[2] FC14{ m Fi} FC15{ m Fp[3]} Fi Fp Fi} BC16{ vd v121 v122 v123 v124 v125} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi[4] Fi:1 Fi:1 Fi:1 Fi:1 Fi[2] Fc Fi[6] Fp}


 S507C1 ::~S507C1(){ note_dtor("S507C1", this);}
void  S507C1 ::v1(){vfunc_called(this, "_ZN6S507C12v1Ev");}
void  S507C1 ::v2(){vfunc_called(this, "_ZN6S507C12v2Ev");}
void  S507C1 ::v3(){vfunc_called(this, "_ZN6S507C12v3Ev");}
void  S507C1 ::v4(){vfunc_called(this, "_ZN6S507C12v4Ev");}
void  S507C1 ::v5(){vfunc_called(this, "_ZN6S507C12v5Ev");}
void  S507C1 ::v6(){vfunc_called(this, "_ZN6S507C12v6Ev");}
void  S507C1 ::v7(){vfunc_called(this, "_ZN6S507C12v7Ev");}
void  S507C1 ::v8(){vfunc_called(this, "_ZN6S507C12v8Ev");}
void  S507C1 ::v9(){vfunc_called(this, "_ZN6S507C12v9Ev");}
void  S507C1 ::v10(){vfunc_called(this, "_ZN6S507C13v10Ev");}
void  S507C1 ::v11(){vfunc_called(this, "_ZN6S507C13v11Ev");}
void  S507C1 ::v12(){vfunc_called(this, "_ZN6S507C13v12Ev");}
void  S507C1 ::v13(){vfunc_called(this, "_ZN6S507C13v13Ev");}
void  S507C1 ::v14(){vfunc_called(this, "_ZN6S507C13v14Ev");}
void  S507C1 ::v15(){vfunc_called(this, "_ZN6S507C13v15Ev");}
void  S507C1 ::v16(){vfunc_called(this, "_ZN6S507C13v16Ev");}
void  S507C1 ::v17(){vfunc_called(this, "_ZN6S507C13v17Ev");}
void  S507C1 ::v18(){vfunc_called(this, "_ZN6S507C13v18Ev");}
void  S507C1 ::v19(){vfunc_called(this, "_ZN6S507C13v19Ev");}
void  S507C1 ::v20(){vfunc_called(this, "_ZN6S507C13v20Ev");}
S507C1 ::S507C1(){ note_ctor("S507C1", this);} // tgen

static void Test_S507C1()
{
  extern Class_Descriptor cd_S507C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(55,81)];
    init_test(&cd_S507C1, buf);
    S507C1 *dp, &lv = *(dp=new (buf) S507C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,320), "sizeof(S507C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S507C1)");
    check_base_class_offset(lv, (S507C5*)(S507C4*)(S507C3*)(S507C2*), 0, "S507C1");
    check_base_class_offset(lv, (S507C4*)(S507C3*)(S507C2*), 0, "S507C1");
    check_base_class_offset(lv, (S507C3*)(S507C2*), 0, "S507C1");
    check_base_class_offset(lv, (S507C2*), 0, "S507C1");
    check_base_class_offset(lv, (S507C16_nt*), ABISELECT(360,256), "S507C1");
    check_field_offset(lv, s507c1f0, ABISELECT(368,260), "S507C1.s507c1f0");
    set_bf_and_test(lv, s507c1f1, ABISELECT(384,276), 0, 1, 1, "S507C1");
    set_bf_and_test(lv, s507c1f2, ABISELECT(384,276), 1, 1, 1, "S507C1");
    set_bf_and_test(lv, s507c1f3, ABISELECT(384,276), 2, 1, 1, "S507C1");
    set_bf_and_test(lv, s507c1f4, ABISELECT(384,276), 3, 1, 1, "S507C1");
    check_field_offset(lv, s507c1f5, ABISELECT(388,280), "S507C1.s507c1f5");
    check_field_offset(lv, s507c1f6, ABISELECT(396,288), "S507C1.s507c1f6");
    check_field_offset(lv, s507c1f7, ABISELECT(400,292), "S507C1.s507c1f7");
    check_field_offset(lv, s507c1f8, ABISELECT(424,316), "S507C1.s507c1f8");
    test_class_info(&lv, &cd_S507C1);
    dp->~S507C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS507C1(Test_S507C1, "S507C1", ABISELECT(432,320));

#else // __cplusplus

extern void _ZN6S507C1C1Ev();
extern void _ZN6S507C1D1Ev();
Name_Map name_map_S507C1[] = {
  NSPAIR(_ZN6S507C1C1Ev),
  NSPAIR(_ZN6S507C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S507C5;
extern VTBL_ENTRY _ZTI6S507C5[];
extern  VTBL_ENTRY _ZTV6S507C5[];
extern Class_Descriptor cd_S507C4;
extern VTBL_ENTRY _ZTI6S507C4[];
extern  VTBL_ENTRY _ZTV6S507C4[];
extern Class_Descriptor cd_S507C3;
extern VTBL_ENTRY _ZTI6S507C3[];
extern  VTBL_ENTRY _ZTV6S507C3[];
extern Class_Descriptor cd_S507C2;
extern VTBL_ENTRY _ZTI6S507C2[];
extern  VTBL_ENTRY _ZTV6S507C2[];
extern Class_Descriptor cd_S507C16_nt;
extern VTBL_ENTRY _ZTI10S507C16_nt[];
extern  VTBL_ENTRY _ZTV10S507C16_nt[];
static Base_Class bases_S507C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S507C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S507C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S507C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S507C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S507C16_nt,    ABISELECT(360,256), //bcp->offset
    124, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S507C1[];
extern void _ZN6S507C1D1Ev();
extern void _ZN6S507C1D0Ev();
extern void _ZN6S507C53v21Ev();
extern void _ZN6S507C53v22Ev();
extern void _ZN6S507C53v23Ev();
extern void _ZN6S507C53v24Ev();
extern void _ZN6S507C53v25Ev();
extern void _ZN6S507C53v26Ev();
extern void _ZN6S507C53v27Ev();
extern void _ZN6S507C53v28Ev();
extern void _ZN6S507C53v29Ev();
extern void _ZN6S507C53v30Ev();
extern void _ZN6S507C53v31Ev();
extern void _ZN6S507C53v32Ev();
extern void _ZN6S507C53v33Ev();
extern void _ZN6S507C53v34Ev();
extern void _ZN6S507C53v35Ev();
extern void _ZN6S507C53v36Ev();
extern void _ZN6S507C53v37Ev();
extern void _ZN6S507C53v38Ev();
extern void _ZN6S507C53v39Ev();
extern void _ZN6S507C53v40Ev();
extern void _ZN6S507C53v41Ev();
extern void _ZN6S507C53v42Ev();
extern void _ZN6S507C53v43Ev();
extern void _ZN6S507C53v44Ev();
extern void _ZN6S507C53v45Ev();
extern void _ZN6S507C53v46Ev();
extern void _ZN6S507C53v47Ev();
extern void _ZN6S507C53v48Ev();
extern void _ZN6S507C53v49Ev();
extern void _ZN6S507C53v50Ev();
extern void _ZN6S507C53v51Ev();
extern void _ZN6S507C53v52Ev();
extern void _ZN6S507C53v53Ev();
extern void _ZN6S507C53v54Ev();
extern void _ZN6S507C53v55Ev();
extern void _ZN6S507C53v56Ev();
extern void _ZN6S507C53v57Ev();
extern void _ZN6S507C53v58Ev();
extern void _ZN6S507C53v59Ev();
extern void _ZN6S507C53v60Ev();
extern void _ZN6S507C53v61Ev();
extern void _ZN6S507C53v62Ev();
extern void _ZN6S507C53v63Ev();
extern void _ZN6S507C53v64Ev();
extern void _ZN6S507C53v65Ev();
extern void _ZN6S507C53v66Ev();
extern void _ZN6S507C53v67Ev();
extern void _ZN6S507C53v68Ev();
extern void _ZN6S507C53v69Ev();
extern void _ZN6S507C53v70Ev();
extern void _ZN6S507C53v71Ev();
extern void _ZN6S507C53v72Ev();
extern void _ZN6S507C53v73Ev();
extern void _ZN6S507C53v74Ev();
extern void _ZN6S507C53v75Ev();
extern void _ZN6S507C53v76Ev();
extern void _ZN6S507C53v77Ev();
extern void _ZN6S507C53v78Ev();
extern void _ZN6S507C53v79Ev();
extern void _ZN6S507C53v80Ev();
extern void _ZN6S507C53v81Ev();
extern void _ZN6S507C53v82Ev();
extern void _ZN6S507C53v83Ev();
extern void _ZN6S507C53v84Ev();
extern void _ZN6S507C43v85Ev();
extern void _ZN6S507C43v86Ev();
extern void _ZN6S507C43v87Ev();
extern void _ZN6S507C43v88Ev();
extern void _ZN6S507C33v89Ev();
extern void _ZN6S507C33v90Ev();
extern void _ZN6S507C33v91Ev();
extern void _ZN6S507C33v92Ev();
extern void _ZN6S507C33v93Ev();
extern void _ZN6S507C33v94Ev();
extern void _ZN6S507C33v95Ev();
extern void _ZN6S507C33v96Ev();
extern void _ZN6S507C33v97Ev();
extern void _ZN6S507C33v98Ev();
extern void _ZN6S507C33v99Ev();
extern void _ZN6S507C34v100Ev();
extern void _ZN6S507C34v101Ev();
extern void _ZN6S507C34v102Ev();
extern void _ZN6S507C34v103Ev();
extern void _ZN6S507C34v104Ev();
extern void _ZN6S507C24v105Ev();
extern void _ZN6S507C24v106Ev();
extern void _ZN6S507C24v107Ev();
extern void _ZN6S507C24v108Ev();
extern void _ZN6S507C24v109Ev();
extern void _ZN6S507C24v110Ev();
extern void _ZN6S507C24v111Ev();
extern void _ZN6S507C24v112Ev();
extern void _ZN6S507C24v113Ev();
extern void _ZN6S507C24v114Ev();
extern void _ZN6S507C24v115Ev();
extern void _ZN6S507C24v116Ev();
extern void _ZN6S507C24v117Ev();
extern void _ZN6S507C24v118Ev();
extern void _ZN6S507C24v119Ev();
extern void _ZN6S507C24v120Ev();
extern void _ZN6S507C12v1Ev();
extern void _ZN6S507C12v2Ev();
extern void _ZN6S507C12v3Ev();
extern void _ZN6S507C12v4Ev();
extern void _ZN6S507C12v5Ev();
extern void _ZN6S507C12v6Ev();
extern void _ZN6S507C12v7Ev();
extern void _ZN6S507C12v8Ev();
extern void _ZN6S507C12v9Ev();
extern void _ZN6S507C13v10Ev();
extern void _ZN6S507C13v11Ev();
extern void _ZN6S507C13v12Ev();
extern void _ZN6S507C13v13Ev();
extern void _ZN6S507C13v14Ev();
extern void _ZN6S507C13v15Ev();
extern void _ZN6S507C13v16Ev();
extern void _ZN6S507C13v17Ev();
extern void _ZN6S507C13v18Ev();
extern void _ZN6S507C13v19Ev();
extern void _ZN6S507C13v20Ev();
extern void ABISELECT(_ZThn360_N6S507C1D1Ev,_ZThn256_N6S507C1D1Ev)();
extern void ABISELECT(_ZThn360_N6S507C1D0Ev,_ZThn256_N6S507C1D0Ev)();
extern void _ZN10S507C16_nt4v121Ev();
extern void _ZN10S507C16_nt4v122Ev();
extern void _ZN10S507C16_nt4v123Ev();
extern void _ZN10S507C16_nt4v124Ev();
extern void _ZN10S507C16_nt4v125Ev();
static  VTBL_ENTRY vtc_S507C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S507C1[0]),
  (VTBL_ENTRY)&_ZN6S507C1D1Ev,
  (VTBL_ENTRY)&_ZN6S507C1D0Ev,
  (VTBL_ENTRY)&_ZN6S507C53v21Ev,
  (VTBL_ENTRY)&_ZN6S507C53v22Ev,
  (VTBL_ENTRY)&_ZN6S507C53v23Ev,
  (VTBL_ENTRY)&_ZN6S507C53v24Ev,
  (VTBL_ENTRY)&_ZN6S507C53v25Ev,
  (VTBL_ENTRY)&_ZN6S507C53v26Ev,
  (VTBL_ENTRY)&_ZN6S507C53v27Ev,
  (VTBL_ENTRY)&_ZN6S507C53v28Ev,
  (VTBL_ENTRY)&_ZN6S507C53v29Ev,
  (VTBL_ENTRY)&_ZN6S507C53v30Ev,
  (VTBL_ENTRY)&_ZN6S507C53v31Ev,
  (VTBL_ENTRY)&_ZN6S507C53v32Ev,
  (VTBL_ENTRY)&_ZN6S507C53v33Ev,
  (VTBL_ENTRY)&_ZN6S507C53v34Ev,
  (VTBL_ENTRY)&_ZN6S507C53v35Ev,
  (VTBL_ENTRY)&_ZN6S507C53v36Ev,
  (VTBL_ENTRY)&_ZN6S507C53v37Ev,
  (VTBL_ENTRY)&_ZN6S507C53v38Ev,
  (VTBL_ENTRY)&_ZN6S507C53v39Ev,
  (VTBL_ENTRY)&_ZN6S507C53v40Ev,
  (VTBL_ENTRY)&_ZN6S507C53v41Ev,
  (VTBL_ENTRY)&_ZN6S507C53v42Ev,
  (VTBL_ENTRY)&_ZN6S507C53v43Ev,
  (VTBL_ENTRY)&_ZN6S507C53v44Ev,
  (VTBL_ENTRY)&_ZN6S507C53v45Ev,
  (VTBL_ENTRY)&_ZN6S507C53v46Ev,
  (VTBL_ENTRY)&_ZN6S507C53v47Ev,
  (VTBL_ENTRY)&_ZN6S507C53v48Ev,
  (VTBL_ENTRY)&_ZN6S507C53v49Ev,
  (VTBL_ENTRY)&_ZN6S507C53v50Ev,
  (VTBL_ENTRY)&_ZN6S507C53v51Ev,
  (VTBL_ENTRY)&_ZN6S507C53v52Ev,
  (VTBL_ENTRY)&_ZN6S507C53v53Ev,
  (VTBL_ENTRY)&_ZN6S507C53v54Ev,
  (VTBL_ENTRY)&_ZN6S507C53v55Ev,
  (VTBL_ENTRY)&_ZN6S507C53v56Ev,
  (VTBL_ENTRY)&_ZN6S507C53v57Ev,
  (VTBL_ENTRY)&_ZN6S507C53v58Ev,
  (VTBL_ENTRY)&_ZN6S507C53v59Ev,
  (VTBL_ENTRY)&_ZN6S507C53v60Ev,
  (VTBL_ENTRY)&_ZN6S507C53v61Ev,
  (VTBL_ENTRY)&_ZN6S507C53v62Ev,
  (VTBL_ENTRY)&_ZN6S507C53v63Ev,
  (VTBL_ENTRY)&_ZN6S507C53v64Ev,
  (VTBL_ENTRY)&_ZN6S507C53v65Ev,
  (VTBL_ENTRY)&_ZN6S507C53v66Ev,
  (VTBL_ENTRY)&_ZN6S507C53v67Ev,
  (VTBL_ENTRY)&_ZN6S507C53v68Ev,
  (VTBL_ENTRY)&_ZN6S507C53v69Ev,
  (VTBL_ENTRY)&_ZN6S507C53v70Ev,
  (VTBL_ENTRY)&_ZN6S507C53v71Ev,
  (VTBL_ENTRY)&_ZN6S507C53v72Ev,
  (VTBL_ENTRY)&_ZN6S507C53v73Ev,
  (VTBL_ENTRY)&_ZN6S507C53v74Ev,
  (VTBL_ENTRY)&_ZN6S507C53v75Ev,
  (VTBL_ENTRY)&_ZN6S507C53v76Ev,
  (VTBL_ENTRY)&_ZN6S507C53v77Ev,
  (VTBL_ENTRY)&_ZN6S507C53v78Ev,
  (VTBL_ENTRY)&_ZN6S507C53v79Ev,
  (VTBL_ENTRY)&_ZN6S507C53v80Ev,
  (VTBL_ENTRY)&_ZN6S507C53v81Ev,
  (VTBL_ENTRY)&_ZN6S507C53v82Ev,
  (VTBL_ENTRY)&_ZN6S507C53v83Ev,
  (VTBL_ENTRY)&_ZN6S507C53v84Ev,
  (VTBL_ENTRY)&_ZN6S507C43v85Ev,
  (VTBL_ENTRY)&_ZN6S507C43v86Ev,
  (VTBL_ENTRY)&_ZN6S507C43v87Ev,
  (VTBL_ENTRY)&_ZN6S507C43v88Ev,
  (VTBL_ENTRY)&_ZN6S507C33v89Ev,
  (VTBL_ENTRY)&_ZN6S507C33v90Ev,
  (VTBL_ENTRY)&_ZN6S507C33v91Ev,
  (VTBL_ENTRY)&_ZN6S507C33v92Ev,
  (VTBL_ENTRY)&_ZN6S507C33v93Ev,
  (VTBL_ENTRY)&_ZN6S507C33v94Ev,
  (VTBL_ENTRY)&_ZN6S507C33v95Ev,
  (VTBL_ENTRY)&_ZN6S507C33v96Ev,
  (VTBL_ENTRY)&_ZN6S507C33v97Ev,
  (VTBL_ENTRY)&_ZN6S507C33v98Ev,
  (VTBL_ENTRY)&_ZN6S507C33v99Ev,
  (VTBL_ENTRY)&_ZN6S507C34v100Ev,
  (VTBL_ENTRY)&_ZN6S507C34v101Ev,
  (VTBL_ENTRY)&_ZN6S507C34v102Ev,
  (VTBL_ENTRY)&_ZN6S507C34v103Ev,
  (VTBL_ENTRY)&_ZN6S507C34v104Ev,
  (VTBL_ENTRY)&_ZN6S507C24v105Ev,
  (VTBL_ENTRY)&_ZN6S507C24v106Ev,
  (VTBL_ENTRY)&_ZN6S507C24v107Ev,
  (VTBL_ENTRY)&_ZN6S507C24v108Ev,
  (VTBL_ENTRY)&_ZN6S507C24v109Ev,
  (VTBL_ENTRY)&_ZN6S507C24v110Ev,
  (VTBL_ENTRY)&_ZN6S507C24v111Ev,
  (VTBL_ENTRY)&_ZN6S507C24v112Ev,
  (VTBL_ENTRY)&_ZN6S507C24v113Ev,
  (VTBL_ENTRY)&_ZN6S507C24v114Ev,
  (VTBL_ENTRY)&_ZN6S507C24v115Ev,
  (VTBL_ENTRY)&_ZN6S507C24v116Ev,
  (VTBL_ENTRY)&_ZN6S507C24v117Ev,
  (VTBL_ENTRY)&_ZN6S507C24v118Ev,
  (VTBL_ENTRY)&_ZN6S507C24v119Ev,
  (VTBL_ENTRY)&_ZN6S507C24v120Ev,
  (VTBL_ENTRY)&_ZN6S507C12v1Ev,
  (VTBL_ENTRY)&_ZN6S507C12v2Ev,
  (VTBL_ENTRY)&_ZN6S507C12v3Ev,
  (VTBL_ENTRY)&_ZN6S507C12v4Ev,
  (VTBL_ENTRY)&_ZN6S507C12v5Ev,
  (VTBL_ENTRY)&_ZN6S507C12v6Ev,
  (VTBL_ENTRY)&_ZN6S507C12v7Ev,
  (VTBL_ENTRY)&_ZN6S507C12v8Ev,
  (VTBL_ENTRY)&_ZN6S507C12v9Ev,
  (VTBL_ENTRY)&_ZN6S507C13v10Ev,
  (VTBL_ENTRY)&_ZN6S507C13v11Ev,
  (VTBL_ENTRY)&_ZN6S507C13v12Ev,
  (VTBL_ENTRY)&_ZN6S507C13v13Ev,
  (VTBL_ENTRY)&_ZN6S507C13v14Ev,
  (VTBL_ENTRY)&_ZN6S507C13v15Ev,
  (VTBL_ENTRY)&_ZN6S507C13v16Ev,
  (VTBL_ENTRY)&_ZN6S507C13v17Ev,
  (VTBL_ENTRY)&_ZN6S507C13v18Ev,
  (VTBL_ENTRY)&_ZN6S507C13v19Ev,
  (VTBL_ENTRY)&_ZN6S507C13v20Ev,
  ABISELECT(-360,-256),
  (VTBL_ENTRY)&(_ZTI6S507C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn360_N6S507C1D1Ev,_ZThn256_N6S507C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn360_N6S507C1D0Ev,_ZThn256_N6S507C1D0Ev),
  (VTBL_ENTRY)&_ZN10S507C16_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S507C16_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S507C16_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S507C16_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S507C16_nt4v125Ev,
};
extern VTBL_ENTRY _ZTI6S507C1[];
extern  VTBL_ENTRY _ZTV6S507C1[];
Class_Descriptor cd_S507C1 = {  "S507C1", // class name
  bases_S507C1, 5,
  &(vtc_S507C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(432,320), // object size
  NSPAIRA(_ZTI6S507C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV6S507C1),133, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S508C5  {
  int s508c5f0;
  __tsi64 s508c5f1;
  void *s508c5f2[4];
  int s508c5f3[2];
  void *s508c5f4;
  ::S695C22_nt s508c5f5;
  void *s508c5f6[2];
  virtual  ~S508C5(); // _ZN6S508C5D1Ev
  virtual void  v22(); // _ZN6S508C53v22Ev
  virtual void  v23(); // _ZN6S508C53v23Ev
  virtual void  v24(); // _ZN6S508C53v24Ev
  virtual void  v25(); // _ZN6S508C53v25Ev
  virtual void  v26(); // _ZN6S508C53v26Ev
  virtual void  v27(); // _ZN6S508C53v27Ev
  virtual void  v28(); // _ZN6S508C53v28Ev
  virtual void  v29(); // _ZN6S508C53v29Ev
  virtual void  v30(); // _ZN6S508C53v30Ev
  virtual void  v31(); // _ZN6S508C53v31Ev
  virtual void  v32(); // _ZN6S508C53v32Ev
  virtual void  v33(); // _ZN6S508C53v33Ev
  virtual void  v34(); // _ZN6S508C53v34Ev
  virtual void  v35(); // _ZN6S508C53v35Ev
  virtual void  v36(); // _ZN6S508C53v36Ev
  virtual void  v37(); // _ZN6S508C53v37Ev
  virtual void  v38(); // _ZN6S508C53v38Ev
  virtual void  v39(); // _ZN6S508C53v39Ev
  virtual void  v40(); // _ZN6S508C53v40Ev
  virtual void  v41(); // _ZN6S508C53v41Ev
  virtual void  v42(); // _ZN6S508C53v42Ev
  virtual void  v43(); // _ZN6S508C53v43Ev
  virtual void  v44(); // _ZN6S508C53v44Ev
  virtual void  v45(); // _ZN6S508C53v45Ev
  virtual void  v46(); // _ZN6S508C53v46Ev
  virtual void  v47(); // _ZN6S508C53v47Ev
  virtual void  v48(); // _ZN6S508C53v48Ev
  virtual void  v49(); // _ZN6S508C53v49Ev
  virtual void  v50(); // _ZN6S508C53v50Ev
  virtual void  v51(); // _ZN6S508C53v51Ev
  virtual void  v52(); // _ZN6S508C53v52Ev
  virtual void  v53(); // _ZN6S508C53v53Ev
  virtual void  v54(); // _ZN6S508C53v54Ev
  virtual void  v55(); // _ZN6S508C53v55Ev
  virtual void  v56(); // _ZN6S508C53v56Ev
  virtual void  v57(); // _ZN6S508C53v57Ev
  virtual void  v58(); // _ZN6S508C53v58Ev
  virtual void  v59(); // _ZN6S508C53v59Ev
  virtual void  v60(); // _ZN6S508C53v60Ev
  virtual void  v61(); // _ZN6S508C53v61Ev
  virtual void  v62(); // _ZN6S508C53v62Ev
  virtual void  v63(); // _ZN6S508C53v63Ev
  virtual void  v64(); // _ZN6S508C53v64Ev
  virtual void  v65(); // _ZN6S508C53v65Ev
  virtual void  v66(); // _ZN6S508C53v66Ev
  virtual void  v67(); // _ZN6S508C53v67Ev
  virtual void  v68(); // _ZN6S508C53v68Ev
  virtual void  v69(); // _ZN6S508C53v69Ev
  virtual void  v70(); // _ZN6S508C53v70Ev
  virtual void  v71(); // _ZN6S508C53v71Ev
  virtual void  v72(); // _ZN6S508C53v72Ev
  virtual void  v73(); // _ZN6S508C53v73Ev
  virtual void  v74(); // _ZN6S508C53v74Ev
  virtual void  v75(); // _ZN6S508C53v75Ev
  virtual void  v76(); // _ZN6S508C53v76Ev
  virtual void  v77(); // _ZN6S508C53v77Ev
  virtual void  v78(); // _ZN6S508C53v78Ev
  virtual void  v79(); // _ZN6S508C53v79Ev
  virtual void  v80(); // _ZN6S508C53v80Ev
  virtual void  v81(); // _ZN6S508C53v81Ev
  virtual void  v82(); // _ZN6S508C53v82Ev
  virtual void  v83(); // _ZN6S508C53v83Ev
  virtual void  v84(); // _ZN6S508C53v84Ev
  virtual void  v85(); // _ZN6S508C53v85Ev
  S508C5(); // tgen
};
//SIG(-1 S508C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S508C5 ::~S508C5(){ note_dtor("S508C5", this);}
void  S508C5 ::v22(){vfunc_called(this, "_ZN6S508C53v22Ev");}
void  S508C5 ::v23(){vfunc_called(this, "_ZN6S508C53v23Ev");}
void  S508C5 ::v24(){vfunc_called(this, "_ZN6S508C53v24Ev");}
void  S508C5 ::v25(){vfunc_called(this, "_ZN6S508C53v25Ev");}
void  S508C5 ::v26(){vfunc_called(this, "_ZN6S508C53v26Ev");}
void  S508C5 ::v27(){vfunc_called(this, "_ZN6S508C53v27Ev");}
void  S508C5 ::v28(){vfunc_called(this, "_ZN6S508C53v28Ev");}
void  S508C5 ::v29(){vfunc_called(this, "_ZN6S508C53v29Ev");}
void  S508C5 ::v30(){vfunc_called(this, "_ZN6S508C53v30Ev");}
void  S508C5 ::v31(){vfunc_called(this, "_ZN6S508C53v31Ev");}
void  S508C5 ::v32(){vfunc_called(this, "_ZN6S508C53v32Ev");}
void  S508C5 ::v33(){vfunc_called(this, "_ZN6S508C53v33Ev");}
void  S508C5 ::v34(){vfunc_called(this, "_ZN6S508C53v34Ev");}
void  S508C5 ::v35(){vfunc_called(this, "_ZN6S508C53v35Ev");}
void  S508C5 ::v36(){vfunc_called(this, "_ZN6S508C53v36Ev");}
void  S508C5 ::v37(){vfunc_called(this, "_ZN6S508C53v37Ev");}
void  S508C5 ::v38(){vfunc_called(this, "_ZN6S508C53v38Ev");}
void  S508C5 ::v39(){vfunc_called(this, "_ZN6S508C53v39Ev");}
void  S508C5 ::v40(){vfunc_called(this, "_ZN6S508C53v40Ev");}
void  S508C5 ::v41(){vfunc_called(this, "_ZN6S508C53v41Ev");}
void  S508C5 ::v42(){vfunc_called(this, "_ZN6S508C53v42Ev");}
void  S508C5 ::v43(){vfunc_called(this, "_ZN6S508C53v43Ev");}
void  S508C5 ::v44(){vfunc_called(this, "_ZN6S508C53v44Ev");}
void  S508C5 ::v45(){vfunc_called(this, "_ZN6S508C53v45Ev");}
void  S508C5 ::v46(){vfunc_called(this, "_ZN6S508C53v46Ev");}
void  S508C5 ::v47(){vfunc_called(this, "_ZN6S508C53v47Ev");}
void  S508C5 ::v48(){vfunc_called(this, "_ZN6S508C53v48Ev");}
void  S508C5 ::v49(){vfunc_called(this, "_ZN6S508C53v49Ev");}
void  S508C5 ::v50(){vfunc_called(this, "_ZN6S508C53v50Ev");}
void  S508C5 ::v51(){vfunc_called(this, "_ZN6S508C53v51Ev");}
void  S508C5 ::v52(){vfunc_called(this, "_ZN6S508C53v52Ev");}
void  S508C5 ::v53(){vfunc_called(this, "_ZN6S508C53v53Ev");}
void  S508C5 ::v54(){vfunc_called(this, "_ZN6S508C53v54Ev");}
void  S508C5 ::v55(){vfunc_called(this, "_ZN6S508C53v55Ev");}
void  S508C5 ::v56(){vfunc_called(this, "_ZN6S508C53v56Ev");}
void  S508C5 ::v57(){vfunc_called(this, "_ZN6S508C53v57Ev");}
void  S508C5 ::v58(){vfunc_called(this, "_ZN6S508C53v58Ev");}
void  S508C5 ::v59(){vfunc_called(this, "_ZN6S508C53v59Ev");}
void  S508C5 ::v60(){vfunc_called(this, "_ZN6S508C53v60Ev");}
void  S508C5 ::v61(){vfunc_called(this, "_ZN6S508C53v61Ev");}
void  S508C5 ::v62(){vfunc_called(this, "_ZN6S508C53v62Ev");}
void  S508C5 ::v63(){vfunc_called(this, "_ZN6S508C53v63Ev");}
void  S508C5 ::v64(){vfunc_called(this, "_ZN6S508C53v64Ev");}
void  S508C5 ::v65(){vfunc_called(this, "_ZN6S508C53v65Ev");}
void  S508C5 ::v66(){vfunc_called(this, "_ZN6S508C53v66Ev");}
void  S508C5 ::v67(){vfunc_called(this, "_ZN6S508C53v67Ev");}
void  S508C5 ::v68(){vfunc_called(this, "_ZN6S508C53v68Ev");}
void  S508C5 ::v69(){vfunc_called(this, "_ZN6S508C53v69Ev");}
void  S508C5 ::v70(){vfunc_called(this, "_ZN6S508C53v70Ev");}
void  S508C5 ::v71(){vfunc_called(this, "_ZN6S508C53v71Ev");}
void  S508C5 ::v72(){vfunc_called(this, "_ZN6S508C53v72Ev");}
void  S508C5 ::v73(){vfunc_called(this, "_ZN6S508C53v73Ev");}
void  S508C5 ::v74(){vfunc_called(this, "_ZN6S508C53v74Ev");}
void  S508C5 ::v75(){vfunc_called(this, "_ZN6S508C53v75Ev");}
void  S508C5 ::v76(){vfunc_called(this, "_ZN6S508C53v76Ev");}
void  S508C5 ::v77(){vfunc_called(this, "_ZN6S508C53v77Ev");}
void  S508C5 ::v78(){vfunc_called(this, "_ZN6S508C53v78Ev");}
void  S508C5 ::v79(){vfunc_called(this, "_ZN6S508C53v79Ev");}
void  S508C5 ::v80(){vfunc_called(this, "_ZN6S508C53v80Ev");}
void  S508C5 ::v81(){vfunc_called(this, "_ZN6S508C53v81Ev");}
void  S508C5 ::v82(){vfunc_called(this, "_ZN6S508C53v82Ev");}
void  S508C5 ::v83(){vfunc_called(this, "_ZN6S508C53v83Ev");}
void  S508C5 ::v84(){vfunc_called(this, "_ZN6S508C53v84Ev");}
void  S508C5 ::v85(){vfunc_called(this, "_ZN6S508C53v85Ev");}
S508C5 ::S508C5(){ note_ctor("S508C5", this);} // tgen

static void Test_S508C5()
{
  extern Class_Descriptor cd_S508C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S508C5, buf);
    S508C5 *dp, &lv = *(dp=new (buf) S508C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S508C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S508C5)");
    check_field_offset(lv, s508c5f0, ABISELECT(8,4), "S508C5.s508c5f0");
    check_field_offset(lv, s508c5f1, ABISELECT(16,8), "S508C5.s508c5f1");
    check_field_offset(lv, s508c5f2, ABISELECT(24,16), "S508C5.s508c5f2");
    check_field_offset(lv, s508c5f3, ABISELECT(56,32), "S508C5.s508c5f3");
    check_field_offset(lv, s508c5f4, ABISELECT(64,40), "S508C5.s508c5f4");
    check_field_offset(lv, s508c5f5, ABISELECT(72,44), "S508C5.s508c5f5");
    check_field_offset(lv, s508c5f6, ABISELECT(80,52), "S508C5.s508c5f6");
    test_class_info(&lv, &cd_S508C5);
    dp->~S508C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS508C5(Test_S508C5, "S508C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S508C5C1Ev();
extern void _ZN6S508C5D1Ev();
Name_Map name_map_S508C5[] = {
  NSPAIR(_ZN6S508C5C1Ev),
  NSPAIR(_ZN6S508C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S508C5[];
extern void _ZN6S508C5D1Ev();
extern void _ZN6S508C5D0Ev();
extern void _ZN6S508C53v22Ev();
extern void _ZN6S508C53v23Ev();
extern void _ZN6S508C53v24Ev();
extern void _ZN6S508C53v25Ev();
extern void _ZN6S508C53v26Ev();
extern void _ZN6S508C53v27Ev();
extern void _ZN6S508C53v28Ev();
extern void _ZN6S508C53v29Ev();
extern void _ZN6S508C53v30Ev();
extern void _ZN6S508C53v31Ev();
extern void _ZN6S508C53v32Ev();
extern void _ZN6S508C53v33Ev();
extern void _ZN6S508C53v34Ev();
extern void _ZN6S508C53v35Ev();
extern void _ZN6S508C53v36Ev();
extern void _ZN6S508C53v37Ev();
extern void _ZN6S508C53v38Ev();
extern void _ZN6S508C53v39Ev();
extern void _ZN6S508C53v40Ev();
extern void _ZN6S508C53v41Ev();
extern void _ZN6S508C53v42Ev();
extern void _ZN6S508C53v43Ev();
extern void _ZN6S508C53v44Ev();
extern void _ZN6S508C53v45Ev();
extern void _ZN6S508C53v46Ev();
extern void _ZN6S508C53v47Ev();
extern void _ZN6S508C53v48Ev();
extern void _ZN6S508C53v49Ev();
extern void _ZN6S508C53v50Ev();
extern void _ZN6S508C53v51Ev();
extern void _ZN6S508C53v52Ev();
extern void _ZN6S508C53v53Ev();
extern void _ZN6S508C53v54Ev();
extern void _ZN6S508C53v55Ev();
extern void _ZN6S508C53v56Ev();
extern void _ZN6S508C53v57Ev();
extern void _ZN6S508C53v58Ev();
extern void _ZN6S508C53v59Ev();
extern void _ZN6S508C53v60Ev();
extern void _ZN6S508C53v61Ev();
extern void _ZN6S508C53v62Ev();
extern void _ZN6S508C53v63Ev();
extern void _ZN6S508C53v64Ev();
extern void _ZN6S508C53v65Ev();
extern void _ZN6S508C53v66Ev();
extern void _ZN6S508C53v67Ev();
extern void _ZN6S508C53v68Ev();
extern void _ZN6S508C53v69Ev();
extern void _ZN6S508C53v70Ev();
extern void _ZN6S508C53v71Ev();
extern void _ZN6S508C53v72Ev();
extern void _ZN6S508C53v73Ev();
extern void _ZN6S508C53v74Ev();
extern void _ZN6S508C53v75Ev();
extern void _ZN6S508C53v76Ev();
extern void _ZN6S508C53v77Ev();
extern void _ZN6S508C53v78Ev();
extern void _ZN6S508C53v79Ev();
extern void _ZN6S508C53v80Ev();
extern void _ZN6S508C53v81Ev();
extern void _ZN6S508C53v82Ev();
extern void _ZN6S508C53v83Ev();
extern void _ZN6S508C53v84Ev();
extern void _ZN6S508C53v85Ev();
static  VTBL_ENTRY vtc_S508C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S508C5[0]),
  (VTBL_ENTRY)&_ZN6S508C5D1Ev,
  (VTBL_ENTRY)&_ZN6S508C5D0Ev,
  (VTBL_ENTRY)&_ZN6S508C53v22Ev,
  (VTBL_ENTRY)&_ZN6S508C53v23Ev,
  (VTBL_ENTRY)&_ZN6S508C53v24Ev,
  (VTBL_ENTRY)&_ZN6S508C53v25Ev,
  (VTBL_ENTRY)&_ZN6S508C53v26Ev,
  (VTBL_ENTRY)&_ZN6S508C53v27Ev,
  (VTBL_ENTRY)&_ZN6S508C53v28Ev,
  (VTBL_ENTRY)&_ZN6S508C53v29Ev,
  (VTBL_ENTRY)&_ZN6S508C53v30Ev,
  (VTBL_ENTRY)&_ZN6S508C53v31Ev,
  (VTBL_ENTRY)&_ZN6S508C53v32Ev,
  (VTBL_ENTRY)&_ZN6S508C53v33Ev,
  (VTBL_ENTRY)&_ZN6S508C53v34Ev,
  (VTBL_ENTRY)&_ZN6S508C53v35Ev,
  (VTBL_ENTRY)&_ZN6S508C53v36Ev,
  (VTBL_ENTRY)&_ZN6S508C53v37Ev,
  (VTBL_ENTRY)&_ZN6S508C53v38Ev,
  (VTBL_ENTRY)&_ZN6S508C53v39Ev,
  (VTBL_ENTRY)&_ZN6S508C53v40Ev,
  (VTBL_ENTRY)&_ZN6S508C53v41Ev,
  (VTBL_ENTRY)&_ZN6S508C53v42Ev,
  (VTBL_ENTRY)&_ZN6S508C53v43Ev,
  (VTBL_ENTRY)&_ZN6S508C53v44Ev,
  (VTBL_ENTRY)&_ZN6S508C53v45Ev,
  (VTBL_ENTRY)&_ZN6S508C53v46Ev,
  (VTBL_ENTRY)&_ZN6S508C53v47Ev,
  (VTBL_ENTRY)&_ZN6S508C53v48Ev,
  (VTBL_ENTRY)&_ZN6S508C53v49Ev,
  (VTBL_ENTRY)&_ZN6S508C53v50Ev,
  (VTBL_ENTRY)&_ZN6S508C53v51Ev,
  (VTBL_ENTRY)&_ZN6S508C53v52Ev,
  (VTBL_ENTRY)&_ZN6S508C53v53Ev,
  (VTBL_ENTRY)&_ZN6S508C53v54Ev,
  (VTBL_ENTRY)&_ZN6S508C53v55Ev,
  (VTBL_ENTRY)&_ZN6S508C53v56Ev,
  (VTBL_ENTRY)&_ZN6S508C53v57Ev,
  (VTBL_ENTRY)&_ZN6S508C53v58Ev,
  (VTBL_ENTRY)&_ZN6S508C53v59Ev,
  (VTBL_ENTRY)&_ZN6S508C53v60Ev,
  (VTBL_ENTRY)&_ZN6S508C53v61Ev,
  (VTBL_ENTRY)&_ZN6S508C53v62Ev,
  (VTBL_ENTRY)&_ZN6S508C53v63Ev,
  (VTBL_ENTRY)&_ZN6S508C53v64Ev,
  (VTBL_ENTRY)&_ZN6S508C53v65Ev,
  (VTBL_ENTRY)&_ZN6S508C53v66Ev,
  (VTBL_ENTRY)&_ZN6S508C53v67Ev,
  (VTBL_ENTRY)&_ZN6S508C53v68Ev,
  (VTBL_ENTRY)&_ZN6S508C53v69Ev,
  (VTBL_ENTRY)&_ZN6S508C53v70Ev,
  (VTBL_ENTRY)&_ZN6S508C53v71Ev,
  (VTBL_ENTRY)&_ZN6S508C53v72Ev,
  (VTBL_ENTRY)&_ZN6S508C53v73Ev,
  (VTBL_ENTRY)&_ZN6S508C53v74Ev,
  (VTBL_ENTRY)&_ZN6S508C53v75Ev,
  (VTBL_ENTRY)&_ZN6S508C53v76Ev,
  (VTBL_ENTRY)&_ZN6S508C53v77Ev,
  (VTBL_ENTRY)&_ZN6S508C53v78Ev,
  (VTBL_ENTRY)&_ZN6S508C53v79Ev,
  (VTBL_ENTRY)&_ZN6S508C53v80Ev,
  (VTBL_ENTRY)&_ZN6S508C53v81Ev,
  (VTBL_ENTRY)&_ZN6S508C53v82Ev,
  (VTBL_ENTRY)&_ZN6S508C53v83Ev,
  (VTBL_ENTRY)&_ZN6S508C53v84Ev,
  (VTBL_ENTRY)&_ZN6S508C53v85Ev,
};
extern VTBL_ENTRY _ZTI6S508C5[];
extern  VTBL_ENTRY _ZTV6S508C5[];
Class_Descriptor cd_S508C5 = {  "S508C5", // class name
  0,0,//no base classes
  &(vtc_S508C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S508C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S508C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S508C4  : S508C5 {
  virtual  ~S508C4(); // _ZN6S508C4D1Ev
  virtual void  v86(); // _ZN6S508C43v86Ev
  virtual void  v87(); // _ZN6S508C43v87Ev
  virtual void  v88(); // _ZN6S508C43v88Ev
  virtual void  v89(); // _ZN6S508C43v89Ev
  S508C4(); // tgen
};
//SIG(-1 S508C4) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S508C4 ::~S508C4(){ note_dtor("S508C4", this);}
void  S508C4 ::v86(){vfunc_called(this, "_ZN6S508C43v86Ev");}
void  S508C4 ::v87(){vfunc_called(this, "_ZN6S508C43v87Ev");}
void  S508C4 ::v88(){vfunc_called(this, "_ZN6S508C43v88Ev");}
void  S508C4 ::v89(){vfunc_called(this, "_ZN6S508C43v89Ev");}
S508C4 ::S508C4(){ note_ctor("S508C4", this);} // tgen

static void Test_S508C4()
{
  extern Class_Descriptor cd_S508C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S508C4, buf);
    S508C4 *dp, &lv = *(dp=new (buf) S508C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S508C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S508C4)");
    check_base_class_offset(lv, (S508C5*), 0, "S508C4");
    test_class_info(&lv, &cd_S508C4);
    dp->~S508C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS508C4(Test_S508C4, "S508C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S508C4C1Ev();
extern void _ZN6S508C4D1Ev();
Name_Map name_map_S508C4[] = {
  NSPAIR(_ZN6S508C4C1Ev),
  NSPAIR(_ZN6S508C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S508C5;
extern VTBL_ENTRY _ZTI6S508C5[];
extern  VTBL_ENTRY _ZTV6S508C5[];
static Base_Class bases_S508C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S508C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S508C4[];
extern void _ZN6S508C4D1Ev();
extern void _ZN6S508C4D0Ev();
extern void _ZN6S508C53v22Ev();
extern void _ZN6S508C53v23Ev();
extern void _ZN6S508C53v24Ev();
extern void _ZN6S508C53v25Ev();
extern void _ZN6S508C53v26Ev();
extern void _ZN6S508C53v27Ev();
extern void _ZN6S508C53v28Ev();
extern void _ZN6S508C53v29Ev();
extern void _ZN6S508C53v30Ev();
extern void _ZN6S508C53v31Ev();
extern void _ZN6S508C53v32Ev();
extern void _ZN6S508C53v33Ev();
extern void _ZN6S508C53v34Ev();
extern void _ZN6S508C53v35Ev();
extern void _ZN6S508C53v36Ev();
extern void _ZN6S508C53v37Ev();
extern void _ZN6S508C53v38Ev();
extern void _ZN6S508C53v39Ev();
extern void _ZN6S508C53v40Ev();
extern void _ZN6S508C53v41Ev();
extern void _ZN6S508C53v42Ev();
extern void _ZN6S508C53v43Ev();
extern void _ZN6S508C53v44Ev();
extern void _ZN6S508C53v45Ev();
extern void _ZN6S508C53v46Ev();
extern void _ZN6S508C53v47Ev();
extern void _ZN6S508C53v48Ev();
extern void _ZN6S508C53v49Ev();
extern void _ZN6S508C53v50Ev();
extern void _ZN6S508C53v51Ev();
extern void _ZN6S508C53v52Ev();
extern void _ZN6S508C53v53Ev();
extern void _ZN6S508C53v54Ev();
extern void _ZN6S508C53v55Ev();
extern void _ZN6S508C53v56Ev();
extern void _ZN6S508C53v57Ev();
extern void _ZN6S508C53v58Ev();
extern void _ZN6S508C53v59Ev();
extern void _ZN6S508C53v60Ev();
extern void _ZN6S508C53v61Ev();
extern void _ZN6S508C53v62Ev();
extern void _ZN6S508C53v63Ev();
extern void _ZN6S508C53v64Ev();
extern void _ZN6S508C53v65Ev();
extern void _ZN6S508C53v66Ev();
extern void _ZN6S508C53v67Ev();
extern void _ZN6S508C53v68Ev();
extern void _ZN6S508C53v69Ev();
extern void _ZN6S508C53v70Ev();
extern void _ZN6S508C53v71Ev();
extern void _ZN6S508C53v72Ev();
extern void _ZN6S508C53v73Ev();
extern void _ZN6S508C53v74Ev();
extern void _ZN6S508C53v75Ev();
extern void _ZN6S508C53v76Ev();
extern void _ZN6S508C53v77Ev();
extern void _ZN6S508C53v78Ev();
extern void _ZN6S508C53v79Ev();
extern void _ZN6S508C53v80Ev();
extern void _ZN6S508C53v81Ev();
extern void _ZN6S508C53v82Ev();
extern void _ZN6S508C53v83Ev();
extern void _ZN6S508C53v84Ev();
extern void _ZN6S508C53v85Ev();
extern void _ZN6S508C43v86Ev();
extern void _ZN6S508C43v87Ev();
extern void _ZN6S508C43v88Ev();
extern void _ZN6S508C43v89Ev();
static  VTBL_ENTRY vtc_S508C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S508C4[0]),
  (VTBL_ENTRY)&_ZN6S508C4D1Ev,
  (VTBL_ENTRY)&_ZN6S508C4D0Ev,
  (VTBL_ENTRY)&_ZN6S508C53v22Ev,
  (VTBL_ENTRY)&_ZN6S508C53v23Ev,
  (VTBL_ENTRY)&_ZN6S508C53v24Ev,
  (VTBL_ENTRY)&_ZN6S508C53v25Ev,
  (VTBL_ENTRY)&_ZN6S508C53v26Ev,
  (VTBL_ENTRY)&_ZN6S508C53v27Ev,
  (VTBL_ENTRY)&_ZN6S508C53v28Ev,
  (VTBL_ENTRY)&_ZN6S508C53v29Ev,
  (VTBL_ENTRY)&_ZN6S508C53v30Ev,
  (VTBL_ENTRY)&_ZN6S508C53v31Ev,
  (VTBL_ENTRY)&_ZN6S508C53v32Ev,
  (VTBL_ENTRY)&_ZN6S508C53v33Ev,
  (VTBL_ENTRY)&_ZN6S508C53v34Ev,
  (VTBL_ENTRY)&_ZN6S508C53v35Ev,
  (VTBL_ENTRY)&_ZN6S508C53v36Ev,
  (VTBL_ENTRY)&_ZN6S508C53v37Ev,
  (VTBL_ENTRY)&_ZN6S508C53v38Ev,
  (VTBL_ENTRY)&_ZN6S508C53v39Ev,
  (VTBL_ENTRY)&_ZN6S508C53v40Ev,
  (VTBL_ENTRY)&_ZN6S508C53v41Ev,
  (VTBL_ENTRY)&_ZN6S508C53v42Ev,
  (VTBL_ENTRY)&_ZN6S508C53v43Ev,
  (VTBL_ENTRY)&_ZN6S508C53v44Ev,
  (VTBL_ENTRY)&_ZN6S508C53v45Ev,
  (VTBL_ENTRY)&_ZN6S508C53v46Ev,
  (VTBL_ENTRY)&_ZN6S508C53v47Ev,
  (VTBL_ENTRY)&_ZN6S508C53v48Ev,
  (VTBL_ENTRY)&_ZN6S508C53v49Ev,
  (VTBL_ENTRY)&_ZN6S508C53v50Ev,
  (VTBL_ENTRY)&_ZN6S508C53v51Ev,
  (VTBL_ENTRY)&_ZN6S508C53v52Ev,
  (VTBL_ENTRY)&_ZN6S508C53v53Ev,
  (VTBL_ENTRY)&_ZN6S508C53v54Ev,
  (VTBL_ENTRY)&_ZN6S508C53v55Ev,
  (VTBL_ENTRY)&_ZN6S508C53v56Ev,
  (VTBL_ENTRY)&_ZN6S508C53v57Ev,
  (VTBL_ENTRY)&_ZN6S508C53v58Ev,
  (VTBL_ENTRY)&_ZN6S508C53v59Ev,
  (VTBL_ENTRY)&_ZN6S508C53v60Ev,
  (VTBL_ENTRY)&_ZN6S508C53v61Ev,
  (VTBL_ENTRY)&_ZN6S508C53v62Ev,
  (VTBL_ENTRY)&_ZN6S508C53v63Ev,
  (VTBL_ENTRY)&_ZN6S508C53v64Ev,
  (VTBL_ENTRY)&_ZN6S508C53v65Ev,
  (VTBL_ENTRY)&_ZN6S508C53v66Ev,
  (VTBL_ENTRY)&_ZN6S508C53v67Ev,
  (VTBL_ENTRY)&_ZN6S508C53v68Ev,
  (VTBL_ENTRY)&_ZN6S508C53v69Ev,
  (VTBL_ENTRY)&_ZN6S508C53v70Ev,
  (VTBL_ENTRY)&_ZN6S508C53v71Ev,
  (VTBL_ENTRY)&_ZN6S508C53v72Ev,
  (VTBL_ENTRY)&_ZN6S508C53v73Ev,
  (VTBL_ENTRY)&_ZN6S508C53v74Ev,
  (VTBL_ENTRY)&_ZN6S508C53v75Ev,
  (VTBL_ENTRY)&_ZN6S508C53v76Ev,
  (VTBL_ENTRY)&_ZN6S508C53v77Ev,
  (VTBL_ENTRY)&_ZN6S508C53v78Ev,
  (VTBL_ENTRY)&_ZN6S508C53v79Ev,
  (VTBL_ENTRY)&_ZN6S508C53v80Ev,
  (VTBL_ENTRY)&_ZN6S508C53v81Ev,
  (VTBL_ENTRY)&_ZN6S508C53v82Ev,
  (VTBL_ENTRY)&_ZN6S508C53v83Ev,
  (VTBL_ENTRY)&_ZN6S508C53v84Ev,
  (VTBL_ENTRY)&_ZN6S508C53v85Ev,
  (VTBL_ENTRY)&_ZN6S508C43v86Ev,
  (VTBL_ENTRY)&_ZN6S508C43v87Ev,
  (VTBL_ENTRY)&_ZN6S508C43v88Ev,
  (VTBL_ENTRY)&_ZN6S508C43v89Ev,
};
extern VTBL_ENTRY _ZTI6S508C4[];
extern  VTBL_ENTRY _ZTV6S508C4[];
Class_Descriptor cd_S508C4 = {  "S508C4", // class name
  bases_S508C4, 1,
  &(vtc_S508C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S508C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S508C4),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S508C3  : S508C4 {
  ::S685C27_nt s508c3f0;
  virtual  ~S508C3(); // _ZN6S508C3D1Ev
  virtual void  v90(); // _ZN6S508C33v90Ev
  virtual void  v91(); // _ZN6S508C33v91Ev
  virtual void  v92(); // _ZN6S508C33v92Ev
  virtual void  v93(); // _ZN6S508C33v93Ev
  virtual void  v94(); // _ZN6S508C33v94Ev
  virtual void  v95(); // _ZN6S508C33v95Ev
  virtual void  v96(); // _ZN6S508C33v96Ev
  virtual void  v97(); // _ZN6S508C33v97Ev
  virtual void  v98(); // _ZN6S508C33v98Ev
  virtual void  v99(); // _ZN6S508C33v99Ev
  virtual void  v100(); // _ZN6S508C34v100Ev
  virtual void  v101(); // _ZN6S508C34v101Ev
  virtual void  v102(); // _ZN6S508C34v102Ev
  virtual void  v103(); // _ZN6S508C34v103Ev
  virtual void  v104(); // _ZN6S508C34v104Ev
  virtual void  v105(); // _ZN6S508C34v105Ev
  virtual void  v106(); // _ZN6S508C34v106Ev
  virtual void  v107(); // _ZN6S508C34v107Ev
  virtual void  v108(); // _ZN6S508C34v108Ev
  virtual void  v109(); // _ZN6S508C34v109Ev
  virtual void  v110(); // _ZN6S508C34v110Ev
  virtual void  v111(); // _ZN6S508C34v111Ev
  virtual void  v112(); // _ZN6S508C34v112Ev
  virtual void  v113(); // _ZN6S508C34v113Ev
  virtual void  v114(); // _ZN6S508C34v114Ev
  virtual void  v115(); // _ZN6S508C34v115Ev
  virtual void  v116(); // _ZN6S508C34v116Ev
  virtual void  v117(); // _ZN6S508C34v117Ev
  virtual void  v118(); // _ZN6S508C34v118Ev
  virtual void  v119(); // _ZN6S508C34v119Ev
  virtual void  v120(); // _ZN6S508C34v120Ev
  S508C3(); // tgen
};
//SIG(-1 S508C3) C1{ BC2{ BC3{ vd v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v96 v97 v98 v99} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}}}


 S508C3 ::~S508C3(){ note_dtor("S508C3", this);}
void  S508C3 ::v90(){vfunc_called(this, "_ZN6S508C33v90Ev");}
void  S508C3 ::v91(){vfunc_called(this, "_ZN6S508C33v91Ev");}
void  S508C3 ::v92(){vfunc_called(this, "_ZN6S508C33v92Ev");}
void  S508C3 ::v93(){vfunc_called(this, "_ZN6S508C33v93Ev");}
void  S508C3 ::v94(){vfunc_called(this, "_ZN6S508C33v94Ev");}
void  S508C3 ::v95(){vfunc_called(this, "_ZN6S508C33v95Ev");}
void  S508C3 ::v96(){vfunc_called(this, "_ZN6S508C33v96Ev");}
void  S508C3 ::v97(){vfunc_called(this, "_ZN6S508C33v97Ev");}
void  S508C3 ::v98(){vfunc_called(this, "_ZN6S508C33v98Ev");}
void  S508C3 ::v99(){vfunc_called(this, "_ZN6S508C33v99Ev");}
void  S508C3 ::v100(){vfunc_called(this, "_ZN6S508C34v100Ev");}
void  S508C3 ::v101(){vfunc_called(this, "_ZN6S508C34v101Ev");}
void  S508C3 ::v102(){vfunc_called(this, "_ZN6S508C34v102Ev");}
void  S508C3 ::v103(){vfunc_called(this, "_ZN6S508C34v103Ev");}
void  S508C3 ::v104(){vfunc_called(this, "_ZN6S508C34v104Ev");}
void  S508C3 ::v105(){vfunc_called(this, "_ZN6S508C34v105Ev");}
void  S508C3 ::v106(){vfunc_called(this, "_ZN6S508C34v106Ev");}
void  S508C3 ::v107(){vfunc_called(this, "_ZN6S508C34v107Ev");}
void  S508C3 ::v108(){vfunc_called(this, "_ZN6S508C34v108Ev");}
void  S508C3 ::v109(){vfunc_called(this, "_ZN6S508C34v109Ev");}
void  S508C3 ::v110(){vfunc_called(this, "_ZN6S508C34v110Ev");}
void  S508C3 ::v111(){vfunc_called(this, "_ZN6S508C34v111Ev");}
void  S508C3 ::v112(){vfunc_called(this, "_ZN6S508C34v112Ev");}
void  S508C3 ::v113(){vfunc_called(this, "_ZN6S508C34v113Ev");}
void  S508C3 ::v114(){vfunc_called(this, "_ZN6S508C34v114Ev");}
void  S508C3 ::v115(){vfunc_called(this, "_ZN6S508C34v115Ev");}
void  S508C3 ::v116(){vfunc_called(this, "_ZN6S508C34v116Ev");}
void  S508C3 ::v117(){vfunc_called(this, "_ZN6S508C34v117Ev");}
void  S508C3 ::v118(){vfunc_called(this, "_ZN6S508C34v118Ev");}
void  S508C3 ::v119(){vfunc_called(this, "_ZN6S508C34v119Ev");}
void  S508C3 ::v120(){vfunc_called(this, "_ZN6S508C34v120Ev");}
S508C3 ::S508C3(){ note_ctor("S508C3", this);} // tgen

static void Test_S508C3()
{
  extern Class_Descriptor cd_S508C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S508C3, buf);
    S508C3 *dp, &lv = *(dp=new (buf) S508C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S508C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S508C3)");
    check_base_class_offset(lv, (S508C5*)(S508C4*), 0, "S508C3");
    check_base_class_offset(lv, (S508C4*), 0, "S508C3");
    check_field_offset(lv, s508c3f0, ABISELECT(96,60), "S508C3.s508c3f0");
    test_class_info(&lv, &cd_S508C3);
    dp->~S508C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS508C3(Test_S508C3, "S508C3", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S508C3C1Ev();
extern void _ZN6S508C3D1Ev();
Name_Map name_map_S508C3[] = {
  NSPAIR(_ZN6S508C3C1Ev),
  NSPAIR(_ZN6S508C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S508C5;
extern VTBL_ENTRY _ZTI6S508C5[];
extern  VTBL_ENTRY _ZTV6S508C5[];
extern Class_Descriptor cd_S508C4;
extern VTBL_ENTRY _ZTI6S508C4[];
extern  VTBL_ENTRY _ZTV6S508C4[];
static Base_Class bases_S508C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S508C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S508C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S508C3[];
extern void _ZN6S508C3D1Ev();
extern void _ZN6S508C3D0Ev();
extern void _ZN6S508C53v22Ev();
extern void _ZN6S508C53v23Ev();
extern void _ZN6S508C53v24Ev();
extern void _ZN6S508C53v25Ev();
extern void _ZN6S508C53v26Ev();
extern void _ZN6S508C53v27Ev();
extern void _ZN6S508C53v28Ev();
extern void _ZN6S508C53v29Ev();
extern void _ZN6S508C53v30Ev();
extern void _ZN6S508C53v31Ev();
extern void _ZN6S508C53v32Ev();
extern void _ZN6S508C53v33Ev();
extern void _ZN6S508C53v34Ev();
extern void _ZN6S508C53v35Ev();
extern void _ZN6S508C53v36Ev();
extern void _ZN6S508C53v37Ev();
extern void _ZN6S508C53v38Ev();
extern void _ZN6S508C53v39Ev();
extern void _ZN6S508C53v40Ev();
extern void _ZN6S508C53v41Ev();
extern void _ZN6S508C53v42Ev();
extern void _ZN6S508C53v43Ev();
extern void _ZN6S508C53v44Ev();
extern void _ZN6S508C53v45Ev();
extern void _ZN6S508C53v46Ev();
extern void _ZN6S508C53v47Ev();
extern void _ZN6S508C53v48Ev();
extern void _ZN6S508C53v49Ev();
extern void _ZN6S508C53v50Ev();
extern void _ZN6S508C53v51Ev();
extern void _ZN6S508C53v52Ev();
extern void _ZN6S508C53v53Ev();
extern void _ZN6S508C53v54Ev();
extern void _ZN6S508C53v55Ev();
extern void _ZN6S508C53v56Ev();
extern void _ZN6S508C53v57Ev();
extern void _ZN6S508C53v58Ev();
extern void _ZN6S508C53v59Ev();
extern void _ZN6S508C53v60Ev();
extern void _ZN6S508C53v61Ev();
extern void _ZN6S508C53v62Ev();
extern void _ZN6S508C53v63Ev();
extern void _ZN6S508C53v64Ev();
extern void _ZN6S508C53v65Ev();
extern void _ZN6S508C53v66Ev();
extern void _ZN6S508C53v67Ev();
extern void _ZN6S508C53v68Ev();
extern void _ZN6S508C53v69Ev();
extern void _ZN6S508C53v70Ev();
extern void _ZN6S508C53v71Ev();
extern void _ZN6S508C53v72Ev();
extern void _ZN6S508C53v73Ev();
extern void _ZN6S508C53v74Ev();
extern void _ZN6S508C53v75Ev();
extern void _ZN6S508C53v76Ev();
extern void _ZN6S508C53v77Ev();
extern void _ZN6S508C53v78Ev();
extern void _ZN6S508C53v79Ev();
extern void _ZN6S508C53v80Ev();
extern void _ZN6S508C53v81Ev();
extern void _ZN6S508C53v82Ev();
extern void _ZN6S508C53v83Ev();
extern void _ZN6S508C53v84Ev();
extern void _ZN6S508C53v85Ev();
extern void _ZN6S508C43v86Ev();
extern void _ZN6S508C43v87Ev();
extern void _ZN6S508C43v88Ev();
extern void _ZN6S508C43v89Ev();
extern void _ZN6S508C33v90Ev();
extern void _ZN6S508C33v91Ev();
extern void _ZN6S508C33v92Ev();
extern void _ZN6S508C33v93Ev();
extern void _ZN6S508C33v94Ev();
extern void _ZN6S508C33v95Ev();
extern void _ZN6S508C33v96Ev();
extern void _ZN6S508C33v97Ev();
extern void _ZN6S508C33v98Ev();
extern void _ZN6S508C33v99Ev();
extern void _ZN6S508C34v100Ev();
extern void _ZN6S508C34v101Ev();
extern void _ZN6S508C34v102Ev();
extern void _ZN6S508C34v103Ev();
extern void _ZN6S508C34v104Ev();
extern void _ZN6S508C34v105Ev();
extern void _ZN6S508C34v106Ev();
extern void _ZN6S508C34v107Ev();
extern void _ZN6S508C34v108Ev();
extern void _ZN6S508C34v109Ev();
extern void _ZN6S508C34v110Ev();
extern void _ZN6S508C34v111Ev();
extern void _ZN6S508C34v112Ev();
extern void _ZN6S508C34v113Ev();
extern void _ZN6S508C34v114Ev();
extern void _ZN6S508C34v115Ev();
extern void _ZN6S508C34v116Ev();
extern void _ZN6S508C34v117Ev();
extern void _ZN6S508C34v118Ev();
extern void _ZN6S508C34v119Ev();
extern void _ZN6S508C34v120Ev();
static  VTBL_ENTRY vtc_S508C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S508C3[0]),
  (VTBL_ENTRY)&_ZN6S508C3D1Ev,
  (VTBL_ENTRY)&_ZN6S508C3D0Ev,
  (VTBL_ENTRY)&_ZN6S508C53v22Ev,
  (VTBL_ENTRY)&_ZN6S508C53v23Ev,
  (VTBL_ENTRY)&_ZN6S508C53v24Ev,
  (VTBL_ENTRY)&_ZN6S508C53v25Ev,
  (VTBL_ENTRY)&_ZN6S508C53v26Ev,
  (VTBL_ENTRY)&_ZN6S508C53v27Ev,
  (VTBL_ENTRY)&_ZN6S508C53v28Ev,
  (VTBL_ENTRY)&_ZN6S508C53v29Ev,
  (VTBL_ENTRY)&_ZN6S508C53v30Ev,
  (VTBL_ENTRY)&_ZN6S508C53v31Ev,
  (VTBL_ENTRY)&_ZN6S508C53v32Ev,
  (VTBL_ENTRY)&_ZN6S508C53v33Ev,
  (VTBL_ENTRY)&_ZN6S508C53v34Ev,
  (VTBL_ENTRY)&_ZN6S508C53v35Ev,
  (VTBL_ENTRY)&_ZN6S508C53v36Ev,
  (VTBL_ENTRY)&_ZN6S508C53v37Ev,
  (VTBL_ENTRY)&_ZN6S508C53v38Ev,
  (VTBL_ENTRY)&_ZN6S508C53v39Ev,
  (VTBL_ENTRY)&_ZN6S508C53v40Ev,
  (VTBL_ENTRY)&_ZN6S508C53v41Ev,
  (VTBL_ENTRY)&_ZN6S508C53v42Ev,
  (VTBL_ENTRY)&_ZN6S508C53v43Ev,
  (VTBL_ENTRY)&_ZN6S508C53v44Ev,
  (VTBL_ENTRY)&_ZN6S508C53v45Ev,
  (VTBL_ENTRY)&_ZN6S508C53v46Ev,
  (VTBL_ENTRY)&_ZN6S508C53v47Ev,
  (VTBL_ENTRY)&_ZN6S508C53v48Ev,
  (VTBL_ENTRY)&_ZN6S508C53v49Ev,
  (VTBL_ENTRY)&_ZN6S508C53v50Ev,
  (VTBL_ENTRY)&_ZN6S508C53v51Ev,
  (VTBL_ENTRY)&_ZN6S508C53v52Ev,
  (VTBL_ENTRY)&_ZN6S508C53v53Ev,
  (VTBL_ENTRY)&_ZN6S508C53v54Ev,
  (VTBL_ENTRY)&_ZN6S508C53v55Ev,
  (VTBL_ENTRY)&_ZN6S508C53v56Ev,
  (VTBL_ENTRY)&_ZN6S508C53v57Ev,
  (VTBL_ENTRY)&_ZN6S508C53v58Ev,
  (VTBL_ENTRY)&_ZN6S508C53v59Ev,
  (VTBL_ENTRY)&_ZN6S508C53v60Ev,
  (VTBL_ENTRY)&_ZN6S508C53v61Ev,
  (VTBL_ENTRY)&_ZN6S508C53v62Ev,
  (VTBL_ENTRY)&_ZN6S508C53v63Ev,
  (VTBL_ENTRY)&_ZN6S508C53v64Ev,
  (VTBL_ENTRY)&_ZN6S508C53v65Ev,
  (VTBL_ENTRY)&_ZN6S508C53v66Ev,
  (VTBL_ENTRY)&_ZN6S508C53v67Ev,
  (VTBL_ENTRY)&_ZN6S508C53v68Ev,
  (VTBL_ENTRY)&_ZN6S508C53v69Ev,
  (VTBL_ENTRY)&_ZN6S508C53v70Ev,
  (VTBL_ENTRY)&_ZN6S508C53v71Ev,
  (VTBL_ENTRY)&_ZN6S508C53v72Ev,
  (VTBL_ENTRY)&_ZN6S508C53v73Ev,
  (VTBL_ENTRY)&_ZN6S508C53v74Ev,
  (VTBL_ENTRY)&_ZN6S508C53v75Ev,
  (VTBL_ENTRY)&_ZN6S508C53v76Ev,
  (VTBL_ENTRY)&_ZN6S508C53v77Ev,
  (VTBL_ENTRY)&_ZN6S508C53v78Ev,
  (VTBL_ENTRY)&_ZN6S508C53v79Ev,
  (VTBL_ENTRY)&_ZN6S508C53v80Ev,
  (VTBL_ENTRY)&_ZN6S508C53v81Ev,
  (VTBL_ENTRY)&_ZN6S508C53v82Ev,
  (VTBL_ENTRY)&_ZN6S508C53v83Ev,
  (VTBL_ENTRY)&_ZN6S508C53v84Ev,
  (VTBL_ENTRY)&_ZN6S508C53v85Ev,
  (VTBL_ENTRY)&_ZN6S508C43v86Ev,
  (VTBL_ENTRY)&_ZN6S508C43v87Ev,
  (VTBL_ENTRY)&_ZN6S508C43v88Ev,
  (VTBL_ENTRY)&_ZN6S508C43v89Ev,
  (VTBL_ENTRY)&_ZN6S508C33v90Ev,
  (VTBL_ENTRY)&_ZN6S508C33v91Ev,
  (VTBL_ENTRY)&_ZN6S508C33v92Ev,
  (VTBL_ENTRY)&_ZN6S508C33v93Ev,
  (VTBL_ENTRY)&_ZN6S508C33v94Ev,
  (VTBL_ENTRY)&_ZN6S508C33v95Ev,
  (VTBL_ENTRY)&_ZN6S508C33v96Ev,
  (VTBL_ENTRY)&_ZN6S508C33v97Ev,
  (VTBL_ENTRY)&_ZN6S508C33v98Ev,
  (VTBL_ENTRY)&_ZN6S508C33v99Ev,
  (VTBL_ENTRY)&_ZN6S508C34v100Ev,
  (VTBL_ENTRY)&_ZN6S508C34v101Ev,
  (VTBL_ENTRY)&_ZN6S508C34v102Ev,
  (VTBL_ENTRY)&_ZN6S508C34v103Ev,
  (VTBL_ENTRY)&_ZN6S508C34v104Ev,
  (VTBL_ENTRY)&_ZN6S508C34v105Ev,
  (VTBL_ENTRY)&_ZN6S508C34v106Ev,
  (VTBL_ENTRY)&_ZN6S508C34v107Ev,
  (VTBL_ENTRY)&_ZN6S508C34v108Ev,
  (VTBL_ENTRY)&_ZN6S508C34v109Ev,
  (VTBL_ENTRY)&_ZN6S508C34v110Ev,
  (VTBL_ENTRY)&_ZN6S508C34v111Ev,
  (VTBL_ENTRY)&_ZN6S508C34v112Ev,
  (VTBL_ENTRY)&_ZN6S508C34v113Ev,
  (VTBL_ENTRY)&_ZN6S508C34v114Ev,
  (VTBL_ENTRY)&_ZN6S508C34v115Ev,
  (VTBL_ENTRY)&_ZN6S508C34v116Ev,
  (VTBL_ENTRY)&_ZN6S508C34v117Ev,
  (VTBL_ENTRY)&_ZN6S508C34v118Ev,
  (VTBL_ENTRY)&_ZN6S508C34v119Ev,
  (VTBL_ENTRY)&_ZN6S508C34v120Ev,
};
extern VTBL_ENTRY _ZTI6S508C3[];
extern  VTBL_ENTRY _ZTV6S508C3[];
Class_Descriptor cd_S508C3 = {  "S508C3", // class name
  bases_S508C3, 2,
  &(vtc_S508C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S508C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S508C3),103, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S508C2  : S508C3 {
  void *s508c2f0[2];
  unsigned int s508c2f1:1;
  unsigned int s508c2f2:1;
  unsigned int s508c2f3:1;
  void *s508c2f4[6];
  ::S685C39 s508c2f5;
  virtual  ~S508C2(); // _ZN6S508C2D1Ev
  virtual void  v121(); // _ZN6S508C24v121Ev
  virtual void  v122(); // _ZN6S508C24v122Ev
  virtual void  v123(); // _ZN6S508C24v123Ev
  virtual void  v124(); // _ZN6S508C24v124Ev
  virtual void  v125(); // _ZN6S508C24v125Ev
  virtual void  v126(); // _ZN6S508C24v126Ev
  virtual void  v127(); // _ZN6S508C24v127Ev
  virtual void  v128(); // _ZN6S508C24v128Ev
  virtual void  v129(); // _ZN6S508C24v129Ev
  virtual void  v130(); // _ZN6S508C24v130Ev
  virtual void  v131(); // _ZN6S508C24v131Ev
  virtual void  v132(); // _ZN6S508C24v132Ev
  virtual void  v133(); // _ZN6S508C24v133Ev
  virtual void  v134(); // _ZN6S508C24v134Ev
  virtual void  v135(); // _ZN6S508C24v135Ev
  virtual void  v136(); // _ZN6S508C24v136Ev
  virtual void  v137(); // _ZN6S508C24v137Ev
  virtual void  v138(); // _ZN6S508C24v138Ev
  virtual void  v139(); // _ZN6S508C24v139Ev
  virtual void  v140(); // _ZN6S508C24v140Ev
  virtual void  v141(); // _ZN6S508C24v141Ev
  virtual void  v142(); // _ZN6S508C24v142Ev
  virtual void  v143(); // _ZN6S508C24v143Ev
  virtual void  v144(); // _ZN6S508C24v144Ev
  virtual void  v145(); // _ZN6S508C24v145Ev
  virtual void  v146(); // _ZN6S508C24v146Ev
  virtual void  v147(); // _ZN6S508C24v147Ev
  virtual void  v148(); // _ZN6S508C24v148Ev
  virtual void  v149(); // _ZN6S508C24v149Ev
  virtual void  v150(); // _ZN6S508C24v150Ev
  virtual void  v151(); // _ZN6S508C24v151Ev
  virtual void  v152(); // _ZN6S508C24v152Ev
  virtual void  v153(); // _ZN6S508C24v153Ev
  virtual void  v154(); // _ZN6S508C24v154Ev
  virtual void  v155(); // _ZN6S508C24v155Ev
  virtual void  v156(); // _ZN6S508C24v156Ev
  virtual void  v157(); // _ZN6S508C24v157Ev
  S508C2(); // tgen
};
//SIG(-1 S508C2) C1{ BC2{ BC3{ BC4{ vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v102 v103 v104 v105} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp[2] Fi:1 Fi:1 Fi:1 Fp[6] FC10{ BC11{ BC9}}}


 S508C2 ::~S508C2(){ note_dtor("S508C2", this);}
void  S508C2 ::v121(){vfunc_called(this, "_ZN6S508C24v121Ev");}
void  S508C2 ::v122(){vfunc_called(this, "_ZN6S508C24v122Ev");}
void  S508C2 ::v123(){vfunc_called(this, "_ZN6S508C24v123Ev");}
void  S508C2 ::v124(){vfunc_called(this, "_ZN6S508C24v124Ev");}
void  S508C2 ::v125(){vfunc_called(this, "_ZN6S508C24v125Ev");}
void  S508C2 ::v126(){vfunc_called(this, "_ZN6S508C24v126Ev");}
void  S508C2 ::v127(){vfunc_called(this, "_ZN6S508C24v127Ev");}
void  S508C2 ::v128(){vfunc_called(this, "_ZN6S508C24v128Ev");}
void  S508C2 ::v129(){vfunc_called(this, "_ZN6S508C24v129Ev");}
void  S508C2 ::v130(){vfunc_called(this, "_ZN6S508C24v130Ev");}
void  S508C2 ::v131(){vfunc_called(this, "_ZN6S508C24v131Ev");}
void  S508C2 ::v132(){vfunc_called(this, "_ZN6S508C24v132Ev");}
void  S508C2 ::v133(){vfunc_called(this, "_ZN6S508C24v133Ev");}
void  S508C2 ::v134(){vfunc_called(this, "_ZN6S508C24v134Ev");}
void  S508C2 ::v135(){vfunc_called(this, "_ZN6S508C24v135Ev");}
void  S508C2 ::v136(){vfunc_called(this, "_ZN6S508C24v136Ev");}
void  S508C2 ::v137(){vfunc_called(this, "_ZN6S508C24v137Ev");}
void  S508C2 ::v138(){vfunc_called(this, "_ZN6S508C24v138Ev");}
void  S508C2 ::v139(){vfunc_called(this, "_ZN6S508C24v139Ev");}
void  S508C2 ::v140(){vfunc_called(this, "_ZN6S508C24v140Ev");}
void  S508C2 ::v141(){vfunc_called(this, "_ZN6S508C24v141Ev");}
void  S508C2 ::v142(){vfunc_called(this, "_ZN6S508C24v142Ev");}
void  S508C2 ::v143(){vfunc_called(this, "_ZN6S508C24v143Ev");}
void  S508C2 ::v144(){vfunc_called(this, "_ZN6S508C24v144Ev");}
void  S508C2 ::v145(){vfunc_called(this, "_ZN6S508C24v145Ev");}
void  S508C2 ::v146(){vfunc_called(this, "_ZN6S508C24v146Ev");}
void  S508C2 ::v147(){vfunc_called(this, "_ZN6S508C24v147Ev");}
void  S508C2 ::v148(){vfunc_called(this, "_ZN6S508C24v148Ev");}
void  S508C2 ::v149(){vfunc_called(this, "_ZN6S508C24v149Ev");}
void  S508C2 ::v150(){vfunc_called(this, "_ZN6S508C24v150Ev");}
void  S508C2 ::v151(){vfunc_called(this, "_ZN6S508C24v151Ev");}
void  S508C2 ::v152(){vfunc_called(this, "_ZN6S508C24v152Ev");}
void  S508C2 ::v153(){vfunc_called(this, "_ZN6S508C24v153Ev");}
void  S508C2 ::v154(){vfunc_called(this, "_ZN6S508C24v154Ev");}
void  S508C2 ::v155(){vfunc_called(this, "_ZN6S508C24v155Ev");}
void  S508C2 ::v156(){vfunc_called(this, "_ZN6S508C24v156Ev");}
void  S508C2 ::v157(){vfunc_called(this, "_ZN6S508C24v157Ev");}
S508C2 ::S508C2(){ note_ctor("S508C2", this);} // tgen

static void Test_S508C2()
{
  extern Class_Descriptor cd_S508C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,31)];
    init_test(&cd_S508C2, buf);
    S508C2 *dp, &lv = *(dp=new (buf) S508C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,120), "sizeof(S508C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S508C2)");
    check_base_class_offset(lv, (S508C5*)(S508C4*)(S508C3*), 0, "S508C2");
    check_base_class_offset(lv, (S508C4*)(S508C3*), 0, "S508C2");
    check_base_class_offset(lv, (S508C3*), 0, "S508C2");
    check_field_offset(lv, s508c2f0, ABISELECT(112,72), "S508C2.s508c2f0");
    set_bf_and_test(lv, s508c2f1, ABISELECT(128,80), 0, 1, 1, "S508C2");
    set_bf_and_test(lv, s508c2f2, ABISELECT(128,80), 1, 1, 1, "S508C2");
    set_bf_and_test(lv, s508c2f3, ABISELECT(128,80), 2, 1, 1, "S508C2");
    check_field_offset(lv, s508c2f4, ABISELECT(136,84), "S508C2.s508c2f4");
    check_field_offset(lv, s508c2f5, ABISELECT(184,108), "S508C2.s508c2f5");
    test_class_info(&lv, &cd_S508C2);
    dp->~S508C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS508C2(Test_S508C2, "S508C2", ABISELECT(200,120));

#else // __cplusplus

extern void _ZN6S508C2C1Ev();
extern void _ZN6S508C2D1Ev();
Name_Map name_map_S508C2[] = {
  NSPAIR(_ZN6S508C2C1Ev),
  NSPAIR(_ZN6S508C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S508C5;
extern VTBL_ENTRY _ZTI6S508C5[];
extern  VTBL_ENTRY _ZTV6S508C5[];
extern Class_Descriptor cd_S508C4;
extern VTBL_ENTRY _ZTI6S508C4[];
extern  VTBL_ENTRY _ZTV6S508C4[];
extern Class_Descriptor cd_S508C3;
extern VTBL_ENTRY _ZTI6S508C3[];
extern  VTBL_ENTRY _ZTV6S508C3[];
static Base_Class bases_S508C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S508C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S508C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S508C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S508C2[];
extern void _ZN6S508C2D1Ev();
extern void _ZN6S508C2D0Ev();
extern void _ZN6S508C53v22Ev();
extern void _ZN6S508C53v23Ev();
extern void _ZN6S508C53v24Ev();
extern void _ZN6S508C53v25Ev();
extern void _ZN6S508C53v26Ev();
extern void _ZN6S508C53v27Ev();
extern void _ZN6S508C53v28Ev();
extern void _ZN6S508C53v29Ev();
extern void _ZN6S508C53v30Ev();
extern void _ZN6S508C53v31Ev();
extern void _ZN6S508C53v32Ev();
extern void _ZN6S508C53v33Ev();
extern void _ZN6S508C53v34Ev();
extern void _ZN6S508C53v35Ev();
extern void _ZN6S508C53v36Ev();
extern void _ZN6S508C53v37Ev();
extern void _ZN6S508C53v38Ev();
extern void _ZN6S508C53v39Ev();
extern void _ZN6S508C53v40Ev();
extern void _ZN6S508C53v41Ev();
extern void _ZN6S508C53v42Ev();
extern void _ZN6S508C53v43Ev();
extern void _ZN6S508C53v44Ev();
extern void _ZN6S508C53v45Ev();
extern void _ZN6S508C53v46Ev();
extern void _ZN6S508C53v47Ev();
extern void _ZN6S508C53v48Ev();
extern void _ZN6S508C53v49Ev();
extern void _ZN6S508C53v50Ev();
extern void _ZN6S508C53v51Ev();
extern void _ZN6S508C53v52Ev();
extern void _ZN6S508C53v53Ev();
extern void _ZN6S508C53v54Ev();
extern void _ZN6S508C53v55Ev();
extern void _ZN6S508C53v56Ev();
extern void _ZN6S508C53v57Ev();
extern void _ZN6S508C53v58Ev();
extern void _ZN6S508C53v59Ev();
extern void _ZN6S508C53v60Ev();
extern void _ZN6S508C53v61Ev();
extern void _ZN6S508C53v62Ev();
extern void _ZN6S508C53v63Ev();
extern void _ZN6S508C53v64Ev();
extern void _ZN6S508C53v65Ev();
extern void _ZN6S508C53v66Ev();
extern void _ZN6S508C53v67Ev();
extern void _ZN6S508C53v68Ev();
extern void _ZN6S508C53v69Ev();
extern void _ZN6S508C53v70Ev();
extern void _ZN6S508C53v71Ev();
extern void _ZN6S508C53v72Ev();
extern void _ZN6S508C53v73Ev();
extern void _ZN6S508C53v74Ev();
extern void _ZN6S508C53v75Ev();
extern void _ZN6S508C53v76Ev();
extern void _ZN6S508C53v77Ev();
extern void _ZN6S508C53v78Ev();
extern void _ZN6S508C53v79Ev();
extern void _ZN6S508C53v80Ev();
extern void _ZN6S508C53v81Ev();
extern void _ZN6S508C53v82Ev();
extern void _ZN6S508C53v83Ev();
extern void _ZN6S508C53v84Ev();
extern void _ZN6S508C53v85Ev();
extern void _ZN6S508C43v86Ev();
extern void _ZN6S508C43v87Ev();
extern void _ZN6S508C43v88Ev();
extern void _ZN6S508C43v89Ev();
extern void _ZN6S508C33v90Ev();
extern void _ZN6S508C33v91Ev();
extern void _ZN6S508C33v92Ev();
extern void _ZN6S508C33v93Ev();
extern void _ZN6S508C33v94Ev();
extern void _ZN6S508C33v95Ev();
extern void _ZN6S508C33v96Ev();
extern void _ZN6S508C33v97Ev();
extern void _ZN6S508C33v98Ev();
extern void _ZN6S508C33v99Ev();
extern void _ZN6S508C34v100Ev();
extern void _ZN6S508C34v101Ev();
extern void _ZN6S508C34v102Ev();
extern void _ZN6S508C34v103Ev();
extern void _ZN6S508C34v104Ev();
extern void _ZN6S508C34v105Ev();
extern void _ZN6S508C34v106Ev();
extern void _ZN6S508C34v107Ev();
extern void _ZN6S508C34v108Ev();
extern void _ZN6S508C34v109Ev();
extern void _ZN6S508C34v110Ev();
extern void _ZN6S508C34v111Ev();
extern void _ZN6S508C34v112Ev();
extern void _ZN6S508C34v113Ev();
extern void _ZN6S508C34v114Ev();
extern void _ZN6S508C34v115Ev();
extern void _ZN6S508C34v116Ev();
extern void _ZN6S508C34v117Ev();
extern void _ZN6S508C34v118Ev();
extern void _ZN6S508C34v119Ev();
extern void _ZN6S508C34v120Ev();
extern void _ZN6S508C24v121Ev();
extern void _ZN6S508C24v122Ev();
extern void _ZN6S508C24v123Ev();
extern void _ZN6S508C24v124Ev();
extern void _ZN6S508C24v125Ev();
extern void _ZN6S508C24v126Ev();
extern void _ZN6S508C24v127Ev();
extern void _ZN6S508C24v128Ev();
extern void _ZN6S508C24v129Ev();
extern void _ZN6S508C24v130Ev();
extern void _ZN6S508C24v131Ev();
extern void _ZN6S508C24v132Ev();
extern void _ZN6S508C24v133Ev();
extern void _ZN6S508C24v134Ev();
extern void _ZN6S508C24v135Ev();
extern void _ZN6S508C24v136Ev();
extern void _ZN6S508C24v137Ev();
extern void _ZN6S508C24v138Ev();
extern void _ZN6S508C24v139Ev();
extern void _ZN6S508C24v140Ev();
extern void _ZN6S508C24v141Ev();
extern void _ZN6S508C24v142Ev();
extern void _ZN6S508C24v143Ev();
extern void _ZN6S508C24v144Ev();
extern void _ZN6S508C24v145Ev();
extern void _ZN6S508C24v146Ev();
extern void _ZN6S508C24v147Ev();
extern void _ZN6S508C24v148Ev();
extern void _ZN6S508C24v149Ev();
extern void _ZN6S508C24v150Ev();
extern void _ZN6S508C24v151Ev();
extern void _ZN6S508C24v152Ev();
extern void _ZN6S508C24v153Ev();
extern void _ZN6S508C24v154Ev();
extern void _ZN6S508C24v155Ev();
extern void _ZN6S508C24v156Ev();
extern void _ZN6S508C24v157Ev();
static  VTBL_ENTRY vtc_S508C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S508C2[0]),
  (VTBL_ENTRY)&_ZN6S508C2D1Ev,
  (VTBL_ENTRY)&_ZN6S508C2D0Ev,
  (VTBL_ENTRY)&_ZN6S508C53v22Ev,
  (VTBL_ENTRY)&_ZN6S508C53v23Ev,
  (VTBL_ENTRY)&_ZN6S508C53v24Ev,
  (VTBL_ENTRY)&_ZN6S508C53v25Ev,
  (VTBL_ENTRY)&_ZN6S508C53v26Ev,
  (VTBL_ENTRY)&_ZN6S508C53v27Ev,
  (VTBL_ENTRY)&_ZN6S508C53v28Ev,
  (VTBL_ENTRY)&_ZN6S508C53v29Ev,
  (VTBL_ENTRY)&_ZN6S508C53v30Ev,
  (VTBL_ENTRY)&_ZN6S508C53v31Ev,
  (VTBL_ENTRY)&_ZN6S508C53v32Ev,
  (VTBL_ENTRY)&_ZN6S508C53v33Ev,
  (VTBL_ENTRY)&_ZN6S508C53v34Ev,
  (VTBL_ENTRY)&_ZN6S508C53v35Ev,
  (VTBL_ENTRY)&_ZN6S508C53v36Ev,
  (VTBL_ENTRY)&_ZN6S508C53v37Ev,
  (VTBL_ENTRY)&_ZN6S508C53v38Ev,
  (VTBL_ENTRY)&_ZN6S508C53v39Ev,
  (VTBL_ENTRY)&_ZN6S508C53v40Ev,
  (VTBL_ENTRY)&_ZN6S508C53v41Ev,
  (VTBL_ENTRY)&_ZN6S508C53v42Ev,
  (VTBL_ENTRY)&_ZN6S508C53v43Ev,
  (VTBL_ENTRY)&_ZN6S508C53v44Ev,
  (VTBL_ENTRY)&_ZN6S508C53v45Ev,
  (VTBL_ENTRY)&_ZN6S508C53v46Ev,
  (VTBL_ENTRY)&_ZN6S508C53v47Ev,
  (VTBL_ENTRY)&_ZN6S508C53v48Ev,
  (VTBL_ENTRY)&_ZN6S508C53v49Ev,
  (VTBL_ENTRY)&_ZN6S508C53v50Ev,
  (VTBL_ENTRY)&_ZN6S508C53v51Ev,
  (VTBL_ENTRY)&_ZN6S508C53v52Ev,
  (VTBL_ENTRY)&_ZN6S508C53v53Ev,
  (VTBL_ENTRY)&_ZN6S508C53v54Ev,
  (VTBL_ENTRY)&_ZN6S508C53v55Ev,
  (VTBL_ENTRY)&_ZN6S508C53v56Ev,
  (VTBL_ENTRY)&_ZN6S508C53v57Ev,
  (VTBL_ENTRY)&_ZN6S508C53v58Ev,
  (VTBL_ENTRY)&_ZN6S508C53v59Ev,
  (VTBL_ENTRY)&_ZN6S508C53v60Ev,
  (VTBL_ENTRY)&_ZN6S508C53v61Ev,
  (VTBL_ENTRY)&_ZN6S508C53v62Ev,
  (VTBL_ENTRY)&_ZN6S508C53v63Ev,
  (VTBL_ENTRY)&_ZN6S508C53v64Ev,
  (VTBL_ENTRY)&_ZN6S508C53v65Ev,
  (VTBL_ENTRY)&_ZN6S508C53v66Ev,
  (VTBL_ENTRY)&_ZN6S508C53v67Ev,
  (VTBL_ENTRY)&_ZN6S508C53v68Ev,
  (VTBL_ENTRY)&_ZN6S508C53v69Ev,
  (VTBL_ENTRY)&_ZN6S508C53v70Ev,
  (VTBL_ENTRY)&_ZN6S508C53v71Ev,
  (VTBL_ENTRY)&_ZN6S508C53v72Ev,
  (VTBL_ENTRY)&_ZN6S508C53v73Ev,
  (VTBL_ENTRY)&_ZN6S508C53v74Ev,
  (VTBL_ENTRY)&_ZN6S508C53v75Ev,
  (VTBL_ENTRY)&_ZN6S508C53v76Ev,
  (VTBL_ENTRY)&_ZN6S508C53v77Ev,
  (VTBL_ENTRY)&_ZN6S508C53v78Ev,
  (VTBL_ENTRY)&_ZN6S508C53v79Ev,
  (VTBL_ENTRY)&_ZN6S508C53v80Ev,
  (VTBL_ENTRY)&_ZN6S508C53v81Ev,
  (VTBL_ENTRY)&_ZN6S508C53v82Ev,
  (VTBL_ENTRY)&_ZN6S508C53v83Ev,
  (VTBL_ENTRY)&_ZN6S508C53v84Ev,
  (VTBL_ENTRY)&_ZN6S508C53v85Ev,
  (VTBL_ENTRY)&_ZN6S508C43v86Ev,
  (VTBL_ENTRY)&_ZN6S508C43v87Ev,
  (VTBL_ENTRY)&_ZN6S508C43v88Ev,
  (VTBL_ENTRY)&_ZN6S508C43v89Ev,
  (VTBL_ENTRY)&_ZN6S508C33v90Ev,
  (VTBL_ENTRY)&_ZN6S508C33v91Ev,
  (VTBL_ENTRY)&_ZN6S508C33v92Ev,
  (VTBL_ENTRY)&_ZN6S508C33v93Ev,
  (VTBL_ENTRY)&_ZN6S508C33v94Ev,
  (VTBL_ENTRY)&_ZN6S508C33v95Ev,
  (VTBL_ENTRY)&_ZN6S508C33v96Ev,
  (VTBL_ENTRY)&_ZN6S508C33v97Ev,
  (VTBL_ENTRY)&_ZN6S508C33v98Ev,
  (VTBL_ENTRY)&_ZN6S508C33v99Ev,
  (VTBL_ENTRY)&_ZN6S508C34v100Ev,
  (VTBL_ENTRY)&_ZN6S508C34v101Ev,
  (VTBL_ENTRY)&_ZN6S508C34v102Ev,
  (VTBL_ENTRY)&_ZN6S508C34v103Ev,
  (VTBL_ENTRY)&_ZN6S508C34v104Ev,
  (VTBL_ENTRY)&_ZN6S508C34v105Ev,
  (VTBL_ENTRY)&_ZN6S508C34v106Ev,
  (VTBL_ENTRY)&_ZN6S508C34v107Ev,
  (VTBL_ENTRY)&_ZN6S508C34v108Ev,
  (VTBL_ENTRY)&_ZN6S508C34v109Ev,
  (VTBL_ENTRY)&_ZN6S508C34v110Ev,
  (VTBL_ENTRY)&_ZN6S508C34v111Ev,
  (VTBL_ENTRY)&_ZN6S508C34v112Ev,
  (VTBL_ENTRY)&_ZN6S508C34v113Ev,
  (VTBL_ENTRY)&_ZN6S508C34v114Ev,
  (VTBL_ENTRY)&_ZN6S508C34v115Ev,
  (VTBL_ENTRY)&_ZN6S508C34v116Ev,
  (VTBL_ENTRY)&_ZN6S508C34v117Ev,
  (VTBL_ENTRY)&_ZN6S508C34v118Ev,
  (VTBL_ENTRY)&_ZN6S508C34v119Ev,
  (VTBL_ENTRY)&_ZN6S508C34v120Ev,
  (VTBL_ENTRY)&_ZN6S508C24v121Ev,
  (VTBL_ENTRY)&_ZN6S508C24v122Ev,
  (VTBL_ENTRY)&_ZN6S508C24v123Ev,
  (VTBL_ENTRY)&_ZN6S508C24v124Ev,
  (VTBL_ENTRY)&_ZN6S508C24v125Ev,
  (VTBL_ENTRY)&_ZN6S508C24v126Ev,
  (VTBL_ENTRY)&_ZN6S508C24v127Ev,
  (VTBL_ENTRY)&_ZN6S508C24v128Ev,
  (VTBL_ENTRY)&_ZN6S508C24v129Ev,
  (VTBL_ENTRY)&_ZN6S508C24v130Ev,
  (VTBL_ENTRY)&_ZN6S508C24v131Ev,
  (VTBL_ENTRY)&_ZN6S508C24v132Ev,
  (VTBL_ENTRY)&_ZN6S508C24v133Ev,
  (VTBL_ENTRY)&_ZN6S508C24v134Ev,
  (VTBL_ENTRY)&_ZN6S508C24v135Ev,
  (VTBL_ENTRY)&_ZN6S508C24v136Ev,
  (VTBL_ENTRY)&_ZN6S508C24v137Ev,
  (VTBL_ENTRY)&_ZN6S508C24v138Ev,
  (VTBL_ENTRY)&_ZN6S508C24v139Ev,
  (VTBL_ENTRY)&_ZN6S508C24v140Ev,
  (VTBL_ENTRY)&_ZN6S508C24v141Ev,
  (VTBL_ENTRY)&_ZN6S508C24v142Ev,
  (VTBL_ENTRY)&_ZN6S508C24v143Ev,
  (VTBL_ENTRY)&_ZN6S508C24v144Ev,
  (VTBL_ENTRY)&_ZN6S508C24v145Ev,
  (VTBL_ENTRY)&_ZN6S508C24v146Ev,
  (VTBL_ENTRY)&_ZN6S508C24v147Ev,
  (VTBL_ENTRY)&_ZN6S508C24v148Ev,
  (VTBL_ENTRY)&_ZN6S508C24v149Ev,
  (VTBL_ENTRY)&_ZN6S508C24v150Ev,
  (VTBL_ENTRY)&_ZN6S508C24v151Ev,
  (VTBL_ENTRY)&_ZN6S508C24v152Ev,
  (VTBL_ENTRY)&_ZN6S508C24v153Ev,
  (VTBL_ENTRY)&_ZN6S508C24v154Ev,
  (VTBL_ENTRY)&_ZN6S508C24v155Ev,
  (VTBL_ENTRY)&_ZN6S508C24v156Ev,
  (VTBL_ENTRY)&_ZN6S508C24v157Ev,
};
extern VTBL_ENTRY _ZTI6S508C2[];
extern  VTBL_ENTRY _ZTV6S508C2[];
Class_Descriptor cd_S508C2 = {  "S508C2", // class name
  bases_S508C2, 3,
  &(vtc_S508C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,120), // object size
  NSPAIRA(_ZTI6S508C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S508C2),140, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S508C1  : S508C2 {
  unsigned int s508c1f0:1;
  ::S685C34 s508c1f1;
  ::S685C28 s508c1f2;
  ::S685C24 s508c1f3;
  ::S685C19 s508c1f4;
  virtual  ~S508C1(); // _ZN6S508C1D1Ev
  virtual void  v1(); // _ZN6S508C12v1Ev
  virtual void  v2(); // _ZN6S508C12v2Ev
  virtual void  v3(); // _ZN6S508C12v3Ev
  virtual void  v4(); // _ZN6S508C12v4Ev
  virtual void  v5(); // _ZN6S508C12v5Ev
  virtual void  v6(); // _ZN6S508C12v6Ev
  virtual void  v7(); // _ZN6S508C12v7Ev
  virtual void  v8(); // _ZN6S508C12v8Ev
  virtual void  v9(); // _ZN6S508C12v9Ev
  virtual void  v10(); // _ZN6S508C13v10Ev
  virtual void  v11(); // _ZN6S508C13v11Ev
  virtual void  v12(); // _ZN6S508C13v12Ev
  virtual void  v13(); // _ZN6S508C13v13Ev
  virtual void  v14(); // _ZN6S508C13v14Ev
  virtual void  v15(); // _ZN6S508C13v15Ev
  virtual void  v16(); // _ZN6S508C13v16Ev
  virtual void  v17(); // _ZN6S508C13v17Ev
  virtual void  v18(); // _ZN6S508C13v18Ev
  virtual void  v19(); // _ZN6S508C13v19Ev
  virtual void  v20(); // _ZN6S508C13v20Ev
  virtual void  v21(); // _ZN6S508C13v21Ev
  S508C1(); // tgen
};
//SIG(1 S508C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v86 v87 v88 v89} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}}} vd v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 Fp[2] Fi:1 Fi:1 Fi:1 Fp[6] FC11{ BC12{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fi:1 FC13{ BC14{ BC10}} FC8 FC15{ BC16{ BC10}} FC17{ BC18{ BC10}}}


 S508C1 ::~S508C1(){ note_dtor("S508C1", this);}
void  S508C1 ::v1(){vfunc_called(this, "_ZN6S508C12v1Ev");}
void  S508C1 ::v2(){vfunc_called(this, "_ZN6S508C12v2Ev");}
void  S508C1 ::v3(){vfunc_called(this, "_ZN6S508C12v3Ev");}
void  S508C1 ::v4(){vfunc_called(this, "_ZN6S508C12v4Ev");}
void  S508C1 ::v5(){vfunc_called(this, "_ZN6S508C12v5Ev");}
void  S508C1 ::v6(){vfunc_called(this, "_ZN6S508C12v6Ev");}
void  S508C1 ::v7(){vfunc_called(this, "_ZN6S508C12v7Ev");}
void  S508C1 ::v8(){vfunc_called(this, "_ZN6S508C12v8Ev");}
void  S508C1 ::v9(){vfunc_called(this, "_ZN6S508C12v9Ev");}
void  S508C1 ::v10(){vfunc_called(this, "_ZN6S508C13v10Ev");}
void  S508C1 ::v11(){vfunc_called(this, "_ZN6S508C13v11Ev");}
void  S508C1 ::v12(){vfunc_called(this, "_ZN6S508C13v12Ev");}
void  S508C1 ::v13(){vfunc_called(this, "_ZN6S508C13v13Ev");}
void  S508C1 ::v14(){vfunc_called(this, "_ZN6S508C13v14Ev");}
void  S508C1 ::v15(){vfunc_called(this, "_ZN6S508C13v15Ev");}
void  S508C1 ::v16(){vfunc_called(this, "_ZN6S508C13v16Ev");}
void  S508C1 ::v17(){vfunc_called(this, "_ZN6S508C13v17Ev");}
void  S508C1 ::v18(){vfunc_called(this, "_ZN6S508C13v18Ev");}
void  S508C1 ::v19(){vfunc_called(this, "_ZN6S508C13v19Ev");}
void  S508C1 ::v20(){vfunc_called(this, "_ZN6S508C13v20Ev");}
void  S508C1 ::v21(){vfunc_called(this, "_ZN6S508C13v21Ev");}
S508C1 ::S508C1(){ note_ctor("S508C1", this);} // tgen

static void Test_S508C1()
{
  extern Class_Descriptor cd_S508C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,44)];
    init_test(&cd_S508C1, buf);
    S508C1 *dp, &lv = *(dp=new (buf) S508C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,172), "sizeof(S508C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S508C1)");
    check_base_class_offset(lv, (S508C5*)(S508C4*)(S508C3*)(S508C2*), 0, "S508C1");
    check_base_class_offset(lv, (S508C4*)(S508C3*)(S508C2*), 0, "S508C1");
    check_base_class_offset(lv, (S508C3*)(S508C2*), 0, "S508C1");
    check_base_class_offset(lv, (S508C2*), 0, "S508C1");
    set_bf_and_test(lv, s508c1f0, ABISELECT(200,120), 0, 1, 1, "S508C1");
    check_field_offset(lv, s508c1f1, ABISELECT(208,124), "S508C1.s508c1f1");
    check_field_offset(lv, s508c1f2, ABISELECT(224,136), "S508C1.s508c1f2");
    check_field_offset(lv, s508c1f3, ABISELECT(240,148), "S508C1.s508c1f3");
    check_field_offset(lv, s508c1f4, ABISELECT(256,160), "S508C1.s508c1f4");
    test_class_info(&lv, &cd_S508C1);
    dp->~S508C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS508C1(Test_S508C1, "S508C1", ABISELECT(272,172));

#else // __cplusplus

extern void _ZN6S508C1C1Ev();
extern void _ZN6S508C1D1Ev();
Name_Map name_map_S508C1[] = {
  NSPAIR(_ZN6S508C1C1Ev),
  NSPAIR(_ZN6S508C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S508C5;
extern VTBL_ENTRY _ZTI6S508C5[];
extern  VTBL_ENTRY _ZTV6S508C5[];
extern Class_Descriptor cd_S508C4;
extern VTBL_ENTRY _ZTI6S508C4[];
extern  VTBL_ENTRY _ZTV6S508C4[];
extern Class_Descriptor cd_S508C3;
extern VTBL_ENTRY _ZTI6S508C3[];
extern  VTBL_ENTRY _ZTV6S508C3[];
extern Class_Descriptor cd_S508C2;
extern VTBL_ENTRY _ZTI6S508C2[];
extern  VTBL_ENTRY _ZTV6S508C2[];
static Base_Class bases_S508C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S508C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S508C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S508C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S508C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S508C1[];
extern void _ZN6S508C1D1Ev();
extern void _ZN6S508C1D0Ev();
extern void _ZN6S508C53v22Ev();
extern void _ZN6S508C53v23Ev();
extern void _ZN6S508C53v24Ev();
extern void _ZN6S508C53v25Ev();
extern void _ZN6S508C53v26Ev();
extern void _ZN6S508C53v27Ev();
extern void _ZN6S508C53v28Ev();
extern void _ZN6S508C53v29Ev();
extern void _ZN6S508C53v30Ev();
extern void _ZN6S508C53v31Ev();
extern void _ZN6S508C53v32Ev();
extern void _ZN6S508C53v33Ev();
extern void _ZN6S508C53v34Ev();
extern void _ZN6S508C53v35Ev();
extern void _ZN6S508C53v36Ev();
extern void _ZN6S508C53v37Ev();
extern void _ZN6S508C53v38Ev();
extern void _ZN6S508C53v39Ev();
extern void _ZN6S508C53v40Ev();
extern void _ZN6S508C53v41Ev();
extern void _ZN6S508C53v42Ev();
extern void _ZN6S508C53v43Ev();
extern void _ZN6S508C53v44Ev();
extern void _ZN6S508C53v45Ev();
extern void _ZN6S508C53v46Ev();
extern void _ZN6S508C53v47Ev();
extern void _ZN6S508C53v48Ev();
extern void _ZN6S508C53v49Ev();
extern void _ZN6S508C53v50Ev();
extern void _ZN6S508C53v51Ev();
extern void _ZN6S508C53v52Ev();
extern void _ZN6S508C53v53Ev();
extern void _ZN6S508C53v54Ev();
extern void _ZN6S508C53v55Ev();
extern void _ZN6S508C53v56Ev();
extern void _ZN6S508C53v57Ev();
extern void _ZN6S508C53v58Ev();
extern void _ZN6S508C53v59Ev();
extern void _ZN6S508C53v60Ev();
extern void _ZN6S508C53v61Ev();
extern void _ZN6S508C53v62Ev();
extern void _ZN6S508C53v63Ev();
extern void _ZN6S508C53v64Ev();
extern void _ZN6S508C53v65Ev();
extern void _ZN6S508C53v66Ev();
extern void _ZN6S508C53v67Ev();
extern void _ZN6S508C53v68Ev();
extern void _ZN6S508C53v69Ev();
extern void _ZN6S508C53v70Ev();
extern void _ZN6S508C53v71Ev();
extern void _ZN6S508C53v72Ev();
extern void _ZN6S508C53v73Ev();
extern void _ZN6S508C53v74Ev();
extern void _ZN6S508C53v75Ev();
extern void _ZN6S508C53v76Ev();
extern void _ZN6S508C53v77Ev();
extern void _ZN6S508C53v78Ev();
extern void _ZN6S508C53v79Ev();
extern void _ZN6S508C53v80Ev();
extern void _ZN6S508C53v81Ev();
extern void _ZN6S508C53v82Ev();
extern void _ZN6S508C53v83Ev();
extern void _ZN6S508C53v84Ev();
extern void _ZN6S508C53v85Ev();
extern void _ZN6S508C43v86Ev();
extern void _ZN6S508C43v87Ev();
extern void _ZN6S508C43v88Ev();
extern void _ZN6S508C43v89Ev();
extern void _ZN6S508C33v90Ev();
extern void _ZN6S508C33v91Ev();
extern void _ZN6S508C33v92Ev();
extern void _ZN6S508C33v93Ev();
extern void _ZN6S508C33v94Ev();
extern void _ZN6S508C33v95Ev();
extern void _ZN6S508C33v96Ev();
extern void _ZN6S508C33v97Ev();
extern void _ZN6S508C33v98Ev();
extern void _ZN6S508C33v99Ev();
extern void _ZN6S508C34v100Ev();
extern void _ZN6S508C34v101Ev();
extern void _ZN6S508C34v102Ev();
extern void _ZN6S508C34v103Ev();
extern void _ZN6S508C34v104Ev();
extern void _ZN6S508C34v105Ev();
extern void _ZN6S508C34v106Ev();
extern void _ZN6S508C34v107Ev();
extern void _ZN6S508C34v108Ev();
extern void _ZN6S508C34v109Ev();
extern void _ZN6S508C34v110Ev();
extern void _ZN6S508C34v111Ev();
extern void _ZN6S508C34v112Ev();
extern void _ZN6S508C34v113Ev();
extern void _ZN6S508C34v114Ev();
extern void _ZN6S508C34v115Ev();
extern void _ZN6S508C34v116Ev();
extern void _ZN6S508C34v117Ev();
extern void _ZN6S508C34v118Ev();
extern void _ZN6S508C34v119Ev();
extern void _ZN6S508C34v120Ev();
extern void _ZN6S508C24v121Ev();
extern void _ZN6S508C24v122Ev();
extern void _ZN6S508C24v123Ev();
extern void _ZN6S508C24v124Ev();
extern void _ZN6S508C24v125Ev();
extern void _ZN6S508C24v126Ev();
extern void _ZN6S508C24v127Ev();
extern void _ZN6S508C24v128Ev();
extern void _ZN6S508C24v129Ev();
extern void _ZN6S508C24v130Ev();
extern void _ZN6S508C24v131Ev();
extern void _ZN6S508C24v132Ev();
extern void _ZN6S508C24v133Ev();
extern void _ZN6S508C24v134Ev();
extern void _ZN6S508C24v135Ev();
extern void _ZN6S508C24v136Ev();
extern void _ZN6S508C24v137Ev();
extern void _ZN6S508C24v138Ev();
extern void _ZN6S508C24v139Ev();
extern void _ZN6S508C24v140Ev();
extern void _ZN6S508C24v141Ev();
extern void _ZN6S508C24v142Ev();
extern void _ZN6S508C24v143Ev();
extern void _ZN6S508C24v144Ev();
extern void _ZN6S508C24v145Ev();
extern void _ZN6S508C24v146Ev();
extern void _ZN6S508C24v147Ev();
extern void _ZN6S508C24v148Ev();
extern void _ZN6S508C24v149Ev();
extern void _ZN6S508C24v150Ev();
extern void _ZN6S508C24v151Ev();
extern void _ZN6S508C24v152Ev();
extern void _ZN6S508C24v153Ev();
extern void _ZN6S508C24v154Ev();
extern void _ZN6S508C24v155Ev();
extern void _ZN6S508C24v156Ev();
extern void _ZN6S508C24v157Ev();
extern void _ZN6S508C12v1Ev();
extern void _ZN6S508C12v2Ev();
extern void _ZN6S508C12v3Ev();
extern void _ZN6S508C12v4Ev();
extern void _ZN6S508C12v5Ev();
extern void _ZN6S508C12v6Ev();
extern void _ZN6S508C12v7Ev();
extern void _ZN6S508C12v8Ev();
extern void _ZN6S508C12v9Ev();
extern void _ZN6S508C13v10Ev();
extern void _ZN6S508C13v11Ev();
extern void _ZN6S508C13v12Ev();
extern void _ZN6S508C13v13Ev();
extern void _ZN6S508C13v14Ev();
extern void _ZN6S508C13v15Ev();
extern void _ZN6S508C13v16Ev();
extern void _ZN6S508C13v17Ev();
extern void _ZN6S508C13v18Ev();
extern void _ZN6S508C13v19Ev();
extern void _ZN6S508C13v20Ev();
extern void _ZN6S508C13v21Ev();
static  VTBL_ENTRY vtc_S508C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S508C1[0]),
  (VTBL_ENTRY)&_ZN6S508C1D1Ev,
  (VTBL_ENTRY)&_ZN6S508C1D0Ev,
  (VTBL_ENTRY)&_ZN6S508C53v22Ev,
  (VTBL_ENTRY)&_ZN6S508C53v23Ev,
  (VTBL_ENTRY)&_ZN6S508C53v24Ev,
  (VTBL_ENTRY)&_ZN6S508C53v25Ev,
  (VTBL_ENTRY)&_ZN6S508C53v26Ev,
  (VTBL_ENTRY)&_ZN6S508C53v27Ev,
  (VTBL_ENTRY)&_ZN6S508C53v28Ev,
  (VTBL_ENTRY)&_ZN6S508C53v29Ev,
  (VTBL_ENTRY)&_ZN6S508C53v30Ev,
  (VTBL_ENTRY)&_ZN6S508C53v31Ev,
  (VTBL_ENTRY)&_ZN6S508C53v32Ev,
  (VTBL_ENTRY)&_ZN6S508C53v33Ev,
  (VTBL_ENTRY)&_ZN6S508C53v34Ev,
  (VTBL_ENTRY)&_ZN6S508C53v35Ev,
  (VTBL_ENTRY)&_ZN6S508C53v36Ev,
  (VTBL_ENTRY)&_ZN6S508C53v37Ev,
  (VTBL_ENTRY)&_ZN6S508C53v38Ev,
  (VTBL_ENTRY)&_ZN6S508C53v39Ev,
  (VTBL_ENTRY)&_ZN6S508C53v40Ev,
  (VTBL_ENTRY)&_ZN6S508C53v41Ev,
  (VTBL_ENTRY)&_ZN6S508C53v42Ev,
  (VTBL_ENTRY)&_ZN6S508C53v43Ev,
  (VTBL_ENTRY)&_ZN6S508C53v44Ev,
  (VTBL_ENTRY)&_ZN6S508C53v45Ev,
  (VTBL_ENTRY)&_ZN6S508C53v46Ev,
  (VTBL_ENTRY)&_ZN6S508C53v47Ev,
  (VTBL_ENTRY)&_ZN6S508C53v48Ev,
  (VTBL_ENTRY)&_ZN6S508C53v49Ev,
  (VTBL_ENTRY)&_ZN6S508C53v50Ev,
  (VTBL_ENTRY)&_ZN6S508C53v51Ev,
  (VTBL_ENTRY)&_ZN6S508C53v52Ev,
  (VTBL_ENTRY)&_ZN6S508C53v53Ev,
  (VTBL_ENTRY)&_ZN6S508C53v54Ev,
  (VTBL_ENTRY)&_ZN6S508C53v55Ev,
  (VTBL_ENTRY)&_ZN6S508C53v56Ev,
  (VTBL_ENTRY)&_ZN6S508C53v57Ev,
  (VTBL_ENTRY)&_ZN6S508C53v58Ev,
  (VTBL_ENTRY)&_ZN6S508C53v59Ev,
  (VTBL_ENTRY)&_ZN6S508C53v60Ev,
  (VTBL_ENTRY)&_ZN6S508C53v61Ev,
  (VTBL_ENTRY)&_ZN6S508C53v62Ev,
  (VTBL_ENTRY)&_ZN6S508C53v63Ev,
  (VTBL_ENTRY)&_ZN6S508C53v64Ev,
  (VTBL_ENTRY)&_ZN6S508C53v65Ev,
  (VTBL_ENTRY)&_ZN6S508C53v66Ev,
  (VTBL_ENTRY)&_ZN6S508C53v67Ev,
  (VTBL_ENTRY)&_ZN6S508C53v68Ev,
  (VTBL_ENTRY)&_ZN6S508C53v69Ev,
  (VTBL_ENTRY)&_ZN6S508C53v70Ev,
  (VTBL_ENTRY)&_ZN6S508C53v71Ev,
  (VTBL_ENTRY)&_ZN6S508C53v72Ev,
  (VTBL_ENTRY)&_ZN6S508C53v73Ev,
  (VTBL_ENTRY)&_ZN6S508C53v74Ev,
  (VTBL_ENTRY)&_ZN6S508C53v75Ev,
  (VTBL_ENTRY)&_ZN6S508C53v76Ev,
  (VTBL_ENTRY)&_ZN6S508C53v77Ev,
  (VTBL_ENTRY)&_ZN6S508C53v78Ev,
  (VTBL_ENTRY)&_ZN6S508C53v79Ev,
  (VTBL_ENTRY)&_ZN6S508C53v80Ev,
  (VTBL_ENTRY)&_ZN6S508C53v81Ev,
  (VTBL_ENTRY)&_ZN6S508C53v82Ev,
  (VTBL_ENTRY)&_ZN6S508C53v83Ev,
  (VTBL_ENTRY)&_ZN6S508C53v84Ev,
  (VTBL_ENTRY)&_ZN6S508C53v85Ev,
  (VTBL_ENTRY)&_ZN6S508C43v86Ev,
  (VTBL_ENTRY)&_ZN6S508C43v87Ev,
  (VTBL_ENTRY)&_ZN6S508C43v88Ev,
  (VTBL_ENTRY)&_ZN6S508C43v89Ev,
  (VTBL_ENTRY)&_ZN6S508C33v90Ev,
  (VTBL_ENTRY)&_ZN6S508C33v91Ev,
  (VTBL_ENTRY)&_ZN6S508C33v92Ev,
  (VTBL_ENTRY)&_ZN6S508C33v93Ev,
  (VTBL_ENTRY)&_ZN6S508C33v94Ev,
  (VTBL_ENTRY)&_ZN6S508C33v95Ev,
  (VTBL_ENTRY)&_ZN6S508C33v96Ev,
  (VTBL_ENTRY)&_ZN6S508C33v97Ev,
  (VTBL_ENTRY)&_ZN6S508C33v98Ev,
  (VTBL_ENTRY)&_ZN6S508C33v99Ev,
  (VTBL_ENTRY)&_ZN6S508C34v100Ev,
  (VTBL_ENTRY)&_ZN6S508C34v101Ev,
  (VTBL_ENTRY)&_ZN6S508C34v102Ev,
  (VTBL_ENTRY)&_ZN6S508C34v103Ev,
  (VTBL_ENTRY)&_ZN6S508C34v104Ev,
  (VTBL_ENTRY)&_ZN6S508C34v105Ev,
  (VTBL_ENTRY)&_ZN6S508C34v106Ev,
  (VTBL_ENTRY)&_ZN6S508C34v107Ev,
  (VTBL_ENTRY)&_ZN6S508C34v108Ev,
  (VTBL_ENTRY)&_ZN6S508C34v109Ev,
  (VTBL_ENTRY)&_ZN6S508C34v110Ev,
  (VTBL_ENTRY)&_ZN6S508C34v111Ev,
  (VTBL_ENTRY)&_ZN6S508C34v112Ev,
  (VTBL_ENTRY)&_ZN6S508C34v113Ev,
  (VTBL_ENTRY)&_ZN6S508C34v114Ev,
  (VTBL_ENTRY)&_ZN6S508C34v115Ev,
  (VTBL_ENTRY)&_ZN6S508C34v116Ev,
  (VTBL_ENTRY)&_ZN6S508C34v117Ev,
  (VTBL_ENTRY)&_ZN6S508C34v118Ev,
  (VTBL_ENTRY)&_ZN6S508C34v119Ev,
  (VTBL_ENTRY)&_ZN6S508C34v120Ev,
  (VTBL_ENTRY)&_ZN6S508C24v121Ev,
  (VTBL_ENTRY)&_ZN6S508C24v122Ev,
  (VTBL_ENTRY)&_ZN6S508C24v123Ev,
  (VTBL_ENTRY)&_ZN6S508C24v124Ev,
  (VTBL_ENTRY)&_ZN6S508C24v125Ev,
  (VTBL_ENTRY)&_ZN6S508C24v126Ev,
  (VTBL_ENTRY)&_ZN6S508C24v127Ev,
  (VTBL_ENTRY)&_ZN6S508C24v128Ev,
  (VTBL_ENTRY)&_ZN6S508C24v129Ev,
  (VTBL_ENTRY)&_ZN6S508C24v130Ev,
  (VTBL_ENTRY)&_ZN6S508C24v131Ev,
  (VTBL_ENTRY)&_ZN6S508C24v132Ev,
  (VTBL_ENTRY)&_ZN6S508C24v133Ev,
  (VTBL_ENTRY)&_ZN6S508C24v134Ev,
  (VTBL_ENTRY)&_ZN6S508C24v135Ev,
  (VTBL_ENTRY)&_ZN6S508C24v136Ev,
  (VTBL_ENTRY)&_ZN6S508C24v137Ev,
  (VTBL_ENTRY)&_ZN6S508C24v138Ev,
  (VTBL_ENTRY)&_ZN6S508C24v139Ev,
  (VTBL_ENTRY)&_ZN6S508C24v140Ev,
  (VTBL_ENTRY)&_ZN6S508C24v141Ev,
  (VTBL_ENTRY)&_ZN6S508C24v142Ev,
  (VTBL_ENTRY)&_ZN6S508C24v143Ev,
  (VTBL_ENTRY)&_ZN6S508C24v144Ev,
  (VTBL_ENTRY)&_ZN6S508C24v145Ev,
  (VTBL_ENTRY)&_ZN6S508C24v146Ev,
  (VTBL_ENTRY)&_ZN6S508C24v147Ev,
  (VTBL_ENTRY)&_ZN6S508C24v148Ev,
  (VTBL_ENTRY)&_ZN6S508C24v149Ev,
  (VTBL_ENTRY)&_ZN6S508C24v150Ev,
  (VTBL_ENTRY)&_ZN6S508C24v151Ev,
  (VTBL_ENTRY)&_ZN6S508C24v152Ev,
  (VTBL_ENTRY)&_ZN6S508C24v153Ev,
  (VTBL_ENTRY)&_ZN6S508C24v154Ev,
  (VTBL_ENTRY)&_ZN6S508C24v155Ev,
  (VTBL_ENTRY)&_ZN6S508C24v156Ev,
  (VTBL_ENTRY)&_ZN6S508C24v157Ev,
  (VTBL_ENTRY)&_ZN6S508C12v1Ev,
  (VTBL_ENTRY)&_ZN6S508C12v2Ev,
  (VTBL_ENTRY)&_ZN6S508C12v3Ev,
  (VTBL_ENTRY)&_ZN6S508C12v4Ev,
  (VTBL_ENTRY)&_ZN6S508C12v5Ev,
  (VTBL_ENTRY)&_ZN6S508C12v6Ev,
  (VTBL_ENTRY)&_ZN6S508C12v7Ev,
  (VTBL_ENTRY)&_ZN6S508C12v8Ev,
  (VTBL_ENTRY)&_ZN6S508C12v9Ev,
  (VTBL_ENTRY)&_ZN6S508C13v10Ev,
  (VTBL_ENTRY)&_ZN6S508C13v11Ev,
  (VTBL_ENTRY)&_ZN6S508C13v12Ev,
  (VTBL_ENTRY)&_ZN6S508C13v13Ev,
  (VTBL_ENTRY)&_ZN6S508C13v14Ev,
  (VTBL_ENTRY)&_ZN6S508C13v15Ev,
  (VTBL_ENTRY)&_ZN6S508C13v16Ev,
  (VTBL_ENTRY)&_ZN6S508C13v17Ev,
  (VTBL_ENTRY)&_ZN6S508C13v18Ev,
  (VTBL_ENTRY)&_ZN6S508C13v19Ev,
  (VTBL_ENTRY)&_ZN6S508C13v20Ev,
  (VTBL_ENTRY)&_ZN6S508C13v21Ev,
};
extern VTBL_ENTRY _ZTI6S508C1[];
extern  VTBL_ENTRY _ZTV6S508C1[];
Class_Descriptor cd_S508C1 = {  "S508C1", // class name
  bases_S508C1, 4,
  &(vtc_S508C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,172), // object size
  NSPAIRA(_ZTI6S508C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S508C1),161, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S492C5  {
  int s492c5f0;
  __tsi64 s492c5f1;
  void *s492c5f2[4];
  int s492c5f3[2];
  void *s492c5f4;
  ::S695C22_nt s492c5f5;
  void *s492c5f6[2];
  virtual  ~S492C5(); // _ZN6S492C5D1Ev
  virtual void  v16(); // _ZN6S492C53v16Ev
  virtual void  v17(); // _ZN6S492C53v17Ev
  virtual void  v18(); // _ZN6S492C53v18Ev
  virtual void  v19(); // _ZN6S492C53v19Ev
  virtual void  v20(); // _ZN6S492C53v20Ev
  virtual void  v21(); // _ZN6S492C53v21Ev
  virtual void  v22(); // _ZN6S492C53v22Ev
  virtual void  v23(); // _ZN6S492C53v23Ev
  virtual void  v24(); // _ZN6S492C53v24Ev
  virtual void  v25(); // _ZN6S492C53v25Ev
  virtual void  v26(); // _ZN6S492C53v26Ev
  virtual void  v27(); // _ZN6S492C53v27Ev
  virtual void  v28(); // _ZN6S492C53v28Ev
  virtual void  v29(); // _ZN6S492C53v29Ev
  virtual void  v30(); // _ZN6S492C53v30Ev
  virtual void  v31(); // _ZN6S492C53v31Ev
  virtual void  v32(); // _ZN6S492C53v32Ev
  virtual void  v33(); // _ZN6S492C53v33Ev
  virtual void  v34(); // _ZN6S492C53v34Ev
  virtual void  v35(); // _ZN6S492C53v35Ev
  virtual void  v36(); // _ZN6S492C53v36Ev
  virtual void  v37(); // _ZN6S492C53v37Ev
  virtual void  v38(); // _ZN6S492C53v38Ev
  virtual void  v39(); // _ZN6S492C53v39Ev
  virtual void  v40(); // _ZN6S492C53v40Ev
  virtual void  v41(); // _ZN6S492C53v41Ev
  virtual void  v42(); // _ZN6S492C53v42Ev
  virtual void  v43(); // _ZN6S492C53v43Ev
  virtual void  v44(); // _ZN6S492C53v44Ev
  virtual void  v45(); // _ZN6S492C53v45Ev
  virtual void  v46(); // _ZN6S492C53v46Ev
  virtual void  v47(); // _ZN6S492C53v47Ev
  virtual void  v48(); // _ZN6S492C53v48Ev
  virtual void  v49(); // _ZN6S492C53v49Ev
  virtual void  v50(); // _ZN6S492C53v50Ev
  virtual void  v51(); // _ZN6S492C53v51Ev
  virtual void  v52(); // _ZN6S492C53v52Ev
  virtual void  v53(); // _ZN6S492C53v53Ev
  virtual void  v54(); // _ZN6S492C53v54Ev
  virtual void  v55(); // _ZN6S492C53v55Ev
  virtual void  v56(); // _ZN6S492C53v56Ev
  virtual void  v57(); // _ZN6S492C53v57Ev
  virtual void  v58(); // _ZN6S492C53v58Ev
  virtual void  v59(); // _ZN6S492C53v59Ev
  virtual void  v60(); // _ZN6S492C53v60Ev
  virtual void  v61(); // _ZN6S492C53v61Ev
  virtual void  v62(); // _ZN6S492C53v62Ev
  virtual void  v63(); // _ZN6S492C53v63Ev
  virtual void  v64(); // _ZN6S492C53v64Ev
  virtual void  v65(); // _ZN6S492C53v65Ev
  virtual void  v66(); // _ZN6S492C53v66Ev
  virtual void  v67(); // _ZN6S492C53v67Ev
  virtual void  v68(); // _ZN6S492C53v68Ev
  virtual void  v69(); // _ZN6S492C53v69Ev
  virtual void  v70(); // _ZN6S492C53v70Ev
  virtual void  v71(); // _ZN6S492C53v71Ev
  virtual void  v72(); // _ZN6S492C53v72Ev
  virtual void  v73(); // _ZN6S492C53v73Ev
  virtual void  v74(); // _ZN6S492C53v74Ev
  virtual void  v75(); // _ZN6S492C53v75Ev
  virtual void  v76(); // _ZN6S492C53v76Ev
  virtual void  v77(); // _ZN6S492C53v77Ev
  virtual void  v78(); // _ZN6S492C53v78Ev
  virtual void  v79(); // _ZN6S492C53v79Ev
  S492C5(); // tgen
};
//SIG(-1 S492C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S492C5 ::~S492C5(){ note_dtor("S492C5", this);}
void  S492C5 ::v16(){vfunc_called(this, "_ZN6S492C53v16Ev");}
void  S492C5 ::v17(){vfunc_called(this, "_ZN6S492C53v17Ev");}
void  S492C5 ::v18(){vfunc_called(this, "_ZN6S492C53v18Ev");}
void  S492C5 ::v19(){vfunc_called(this, "_ZN6S492C53v19Ev");}
void  S492C5 ::v20(){vfunc_called(this, "_ZN6S492C53v20Ev");}
void  S492C5 ::v21(){vfunc_called(this, "_ZN6S492C53v21Ev");}
void  S492C5 ::v22(){vfunc_called(this, "_ZN6S492C53v22Ev");}
void  S492C5 ::v23(){vfunc_called(this, "_ZN6S492C53v23Ev");}
void  S492C5 ::v24(){vfunc_called(this, "_ZN6S492C53v24Ev");}
void  S492C5 ::v25(){vfunc_called(this, "_ZN6S492C53v25Ev");}
void  S492C5 ::v26(){vfunc_called(this, "_ZN6S492C53v26Ev");}
void  S492C5 ::v27(){vfunc_called(this, "_ZN6S492C53v27Ev");}
void  S492C5 ::v28(){vfunc_called(this, "_ZN6S492C53v28Ev");}
void  S492C5 ::v29(){vfunc_called(this, "_ZN6S492C53v29Ev");}
void  S492C5 ::v30(){vfunc_called(this, "_ZN6S492C53v30Ev");}
void  S492C5 ::v31(){vfunc_called(this, "_ZN6S492C53v31Ev");}
void  S492C5 ::v32(){vfunc_called(this, "_ZN6S492C53v32Ev");}
void  S492C5 ::v33(){vfunc_called(this, "_ZN6S492C53v33Ev");}
void  S492C5 ::v34(){vfunc_called(this, "_ZN6S492C53v34Ev");}
void  S492C5 ::v35(){vfunc_called(this, "_ZN6S492C53v35Ev");}
void  S492C5 ::v36(){vfunc_called(this, "_ZN6S492C53v36Ev");}
void  S492C5 ::v37(){vfunc_called(this, "_ZN6S492C53v37Ev");}
void  S492C5 ::v38(){vfunc_called(this, "_ZN6S492C53v38Ev");}
void  S492C5 ::v39(){vfunc_called(this, "_ZN6S492C53v39Ev");}
void  S492C5 ::v40(){vfunc_called(this, "_ZN6S492C53v40Ev");}
void  S492C5 ::v41(){vfunc_called(this, "_ZN6S492C53v41Ev");}
void  S492C5 ::v42(){vfunc_called(this, "_ZN6S492C53v42Ev");}
void  S492C5 ::v43(){vfunc_called(this, "_ZN6S492C53v43Ev");}
void  S492C5 ::v44(){vfunc_called(this, "_ZN6S492C53v44Ev");}
void  S492C5 ::v45(){vfunc_called(this, "_ZN6S492C53v45Ev");}
void  S492C5 ::v46(){vfunc_called(this, "_ZN6S492C53v46Ev");}
void  S492C5 ::v47(){vfunc_called(this, "_ZN6S492C53v47Ev");}
void  S492C5 ::v48(){vfunc_called(this, "_ZN6S492C53v48Ev");}
void  S492C5 ::v49(){vfunc_called(this, "_ZN6S492C53v49Ev");}
void  S492C5 ::v50(){vfunc_called(this, "_ZN6S492C53v50Ev");}
void  S492C5 ::v51(){vfunc_called(this, "_ZN6S492C53v51Ev");}
void  S492C5 ::v52(){vfunc_called(this, "_ZN6S492C53v52Ev");}
void  S492C5 ::v53(){vfunc_called(this, "_ZN6S492C53v53Ev");}
void  S492C5 ::v54(){vfunc_called(this, "_ZN6S492C53v54Ev");}
void  S492C5 ::v55(){vfunc_called(this, "_ZN6S492C53v55Ev");}
void  S492C5 ::v56(){vfunc_called(this, "_ZN6S492C53v56Ev");}
void  S492C5 ::v57(){vfunc_called(this, "_ZN6S492C53v57Ev");}
void  S492C5 ::v58(){vfunc_called(this, "_ZN6S492C53v58Ev");}
void  S492C5 ::v59(){vfunc_called(this, "_ZN6S492C53v59Ev");}
void  S492C5 ::v60(){vfunc_called(this, "_ZN6S492C53v60Ev");}
void  S492C5 ::v61(){vfunc_called(this, "_ZN6S492C53v61Ev");}
void  S492C5 ::v62(){vfunc_called(this, "_ZN6S492C53v62Ev");}
void  S492C5 ::v63(){vfunc_called(this, "_ZN6S492C53v63Ev");}
void  S492C5 ::v64(){vfunc_called(this, "_ZN6S492C53v64Ev");}
void  S492C5 ::v65(){vfunc_called(this, "_ZN6S492C53v65Ev");}
void  S492C5 ::v66(){vfunc_called(this, "_ZN6S492C53v66Ev");}
void  S492C5 ::v67(){vfunc_called(this, "_ZN6S492C53v67Ev");}
void  S492C5 ::v68(){vfunc_called(this, "_ZN6S492C53v68Ev");}
void  S492C5 ::v69(){vfunc_called(this, "_ZN6S492C53v69Ev");}
void  S492C5 ::v70(){vfunc_called(this, "_ZN6S492C53v70Ev");}
void  S492C5 ::v71(){vfunc_called(this, "_ZN6S492C53v71Ev");}
void  S492C5 ::v72(){vfunc_called(this, "_ZN6S492C53v72Ev");}
void  S492C5 ::v73(){vfunc_called(this, "_ZN6S492C53v73Ev");}
void  S492C5 ::v74(){vfunc_called(this, "_ZN6S492C53v74Ev");}
void  S492C5 ::v75(){vfunc_called(this, "_ZN6S492C53v75Ev");}
void  S492C5 ::v76(){vfunc_called(this, "_ZN6S492C53v76Ev");}
void  S492C5 ::v77(){vfunc_called(this, "_ZN6S492C53v77Ev");}
void  S492C5 ::v78(){vfunc_called(this, "_ZN6S492C53v78Ev");}
void  S492C5 ::v79(){vfunc_called(this, "_ZN6S492C53v79Ev");}
S492C5 ::S492C5(){ note_ctor("S492C5", this);} // tgen

static void Test_S492C5()
{
  extern Class_Descriptor cd_S492C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S492C5, buf);
    S492C5 *dp, &lv = *(dp=new (buf) S492C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S492C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S492C5)");
    check_field_offset(lv, s492c5f0, ABISELECT(8,4), "S492C5.s492c5f0");
    check_field_offset(lv, s492c5f1, ABISELECT(16,8), "S492C5.s492c5f1");
    check_field_offset(lv, s492c5f2, ABISELECT(24,16), "S492C5.s492c5f2");
    check_field_offset(lv, s492c5f3, ABISELECT(56,32), "S492C5.s492c5f3");
    check_field_offset(lv, s492c5f4, ABISELECT(64,40), "S492C5.s492c5f4");
    check_field_offset(lv, s492c5f5, ABISELECT(72,44), "S492C5.s492c5f5");
    check_field_offset(lv, s492c5f6, ABISELECT(80,52), "S492C5.s492c5f6");
    test_class_info(&lv, &cd_S492C5);
    dp->~S492C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS492C5(Test_S492C5, "S492C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S492C5C1Ev();
extern void _ZN6S492C5D1Ev();
Name_Map name_map_S492C5[] = {
  NSPAIR(_ZN6S492C5C1Ev),
  NSPAIR(_ZN6S492C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S492C5[];
extern void _ZN6S492C5D1Ev();
extern void _ZN6S492C5D0Ev();
extern void _ZN6S492C53v16Ev();
extern void _ZN6S492C53v17Ev();
extern void _ZN6S492C53v18Ev();
extern void _ZN6S492C53v19Ev();
extern void _ZN6S492C53v20Ev();
extern void _ZN6S492C53v21Ev();
extern void _ZN6S492C53v22Ev();
extern void _ZN6S492C53v23Ev();
extern void _ZN6S492C53v24Ev();
extern void _ZN6S492C53v25Ev();
extern void _ZN6S492C53v26Ev();
extern void _ZN6S492C53v27Ev();
extern void _ZN6S492C53v28Ev();
extern void _ZN6S492C53v29Ev();
extern void _ZN6S492C53v30Ev();
extern void _ZN6S492C53v31Ev();
extern void _ZN6S492C53v32Ev();
extern void _ZN6S492C53v33Ev();
extern void _ZN6S492C53v34Ev();
extern void _ZN6S492C53v35Ev();
extern void _ZN6S492C53v36Ev();
extern void _ZN6S492C53v37Ev();
extern void _ZN6S492C53v38Ev();
extern void _ZN6S492C53v39Ev();
extern void _ZN6S492C53v40Ev();
extern void _ZN6S492C53v41Ev();
extern void _ZN6S492C53v42Ev();
extern void _ZN6S492C53v43Ev();
extern void _ZN6S492C53v44Ev();
extern void _ZN6S492C53v45Ev();
extern void _ZN6S492C53v46Ev();
extern void _ZN6S492C53v47Ev();
extern void _ZN6S492C53v48Ev();
extern void _ZN6S492C53v49Ev();
extern void _ZN6S492C53v50Ev();
extern void _ZN6S492C53v51Ev();
extern void _ZN6S492C53v52Ev();
extern void _ZN6S492C53v53Ev();
extern void _ZN6S492C53v54Ev();
extern void _ZN6S492C53v55Ev();
extern void _ZN6S492C53v56Ev();
extern void _ZN6S492C53v57Ev();
extern void _ZN6S492C53v58Ev();
extern void _ZN6S492C53v59Ev();
extern void _ZN6S492C53v60Ev();
extern void _ZN6S492C53v61Ev();
extern void _ZN6S492C53v62Ev();
extern void _ZN6S492C53v63Ev();
extern void _ZN6S492C53v64Ev();
extern void _ZN6S492C53v65Ev();
extern void _ZN6S492C53v66Ev();
extern void _ZN6S492C53v67Ev();
extern void _ZN6S492C53v68Ev();
extern void _ZN6S492C53v69Ev();
extern void _ZN6S492C53v70Ev();
extern void _ZN6S492C53v71Ev();
extern void _ZN6S492C53v72Ev();
extern void _ZN6S492C53v73Ev();
extern void _ZN6S492C53v74Ev();
extern void _ZN6S492C53v75Ev();
extern void _ZN6S492C53v76Ev();
extern void _ZN6S492C53v77Ev();
extern void _ZN6S492C53v78Ev();
extern void _ZN6S492C53v79Ev();
static  VTBL_ENTRY vtc_S492C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S492C5[0]),
  (VTBL_ENTRY)&_ZN6S492C5D1Ev,
  (VTBL_ENTRY)&_ZN6S492C5D0Ev,
  (VTBL_ENTRY)&_ZN6S492C53v16Ev,
  (VTBL_ENTRY)&_ZN6S492C53v17Ev,
  (VTBL_ENTRY)&_ZN6S492C53v18Ev,
  (VTBL_ENTRY)&_ZN6S492C53v19Ev,
  (VTBL_ENTRY)&_ZN6S492C53v20Ev,
  (VTBL_ENTRY)&_ZN6S492C53v21Ev,
  (VTBL_ENTRY)&_ZN6S492C53v22Ev,
  (VTBL_ENTRY)&_ZN6S492C53v23Ev,
  (VTBL_ENTRY)&_ZN6S492C53v24Ev,
  (VTBL_ENTRY)&_ZN6S492C53v25Ev,
  (VTBL_ENTRY)&_ZN6S492C53v26Ev,
  (VTBL_ENTRY)&_ZN6S492C53v27Ev,
  (VTBL_ENTRY)&_ZN6S492C53v28Ev,
  (VTBL_ENTRY)&_ZN6S492C53v29Ev,
  (VTBL_ENTRY)&_ZN6S492C53v30Ev,
  (VTBL_ENTRY)&_ZN6S492C53v31Ev,
  (VTBL_ENTRY)&_ZN6S492C53v32Ev,
  (VTBL_ENTRY)&_ZN6S492C53v33Ev,
  (VTBL_ENTRY)&_ZN6S492C53v34Ev,
  (VTBL_ENTRY)&_ZN6S492C53v35Ev,
  (VTBL_ENTRY)&_ZN6S492C53v36Ev,
  (VTBL_ENTRY)&_ZN6S492C53v37Ev,
  (VTBL_ENTRY)&_ZN6S492C53v38Ev,
  (VTBL_ENTRY)&_ZN6S492C53v39Ev,
  (VTBL_ENTRY)&_ZN6S492C53v40Ev,
  (VTBL_ENTRY)&_ZN6S492C53v41Ev,
  (VTBL_ENTRY)&_ZN6S492C53v42Ev,
  (VTBL_ENTRY)&_ZN6S492C53v43Ev,
  (VTBL_ENTRY)&_ZN6S492C53v44Ev,
  (VTBL_ENTRY)&_ZN6S492C53v45Ev,
  (VTBL_ENTRY)&_ZN6S492C53v46Ev,
  (VTBL_ENTRY)&_ZN6S492C53v47Ev,
  (VTBL_ENTRY)&_ZN6S492C53v48Ev,
  (VTBL_ENTRY)&_ZN6S492C53v49Ev,
  (VTBL_ENTRY)&_ZN6S492C53v50Ev,
  (VTBL_ENTRY)&_ZN6S492C53v51Ev,
  (VTBL_ENTRY)&_ZN6S492C53v52Ev,
  (VTBL_ENTRY)&_ZN6S492C53v53Ev,
  (VTBL_ENTRY)&_ZN6S492C53v54Ev,
  (VTBL_ENTRY)&_ZN6S492C53v55Ev,
  (VTBL_ENTRY)&_ZN6S492C53v56Ev,
  (VTBL_ENTRY)&_ZN6S492C53v57Ev,
  (VTBL_ENTRY)&_ZN6S492C53v58Ev,
  (VTBL_ENTRY)&_ZN6S492C53v59Ev,
  (VTBL_ENTRY)&_ZN6S492C53v60Ev,
  (VTBL_ENTRY)&_ZN6S492C53v61Ev,
  (VTBL_ENTRY)&_ZN6S492C53v62Ev,
  (VTBL_ENTRY)&_ZN6S492C53v63Ev,
  (VTBL_ENTRY)&_ZN6S492C53v64Ev,
  (VTBL_ENTRY)&_ZN6S492C53v65Ev,
  (VTBL_ENTRY)&_ZN6S492C53v66Ev,
  (VTBL_ENTRY)&_ZN6S492C53v67Ev,
  (VTBL_ENTRY)&_ZN6S492C53v68Ev,
  (VTBL_ENTRY)&_ZN6S492C53v69Ev,
  (VTBL_ENTRY)&_ZN6S492C53v70Ev,
  (VTBL_ENTRY)&_ZN6S492C53v71Ev,
  (VTBL_ENTRY)&_ZN6S492C53v72Ev,
  (VTBL_ENTRY)&_ZN6S492C53v73Ev,
  (VTBL_ENTRY)&_ZN6S492C53v74Ev,
  (VTBL_ENTRY)&_ZN6S492C53v75Ev,
  (VTBL_ENTRY)&_ZN6S492C53v76Ev,
  (VTBL_ENTRY)&_ZN6S492C53v77Ev,
  (VTBL_ENTRY)&_ZN6S492C53v78Ev,
  (VTBL_ENTRY)&_ZN6S492C53v79Ev,
};
extern VTBL_ENTRY _ZTI6S492C5[];
extern  VTBL_ENTRY _ZTV6S492C5[];
Class_Descriptor cd_S492C5 = {  "S492C5", // class name
  0,0,//no base classes
  &(vtc_S492C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S492C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S492C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S492C4  : S492C5 {
  virtual  ~S492C4(); // _ZN6S492C4D1Ev
  virtual void  v80(); // _ZN6S492C43v80Ev
  virtual void  v81(); // _ZN6S492C43v81Ev
  virtual void  v82(); // _ZN6S492C43v82Ev
  virtual void  v83(); // _ZN6S492C43v83Ev
  S492C4(); // tgen
};
//SIG(-1 S492C4) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S492C4 ::~S492C4(){ note_dtor("S492C4", this);}
void  S492C4 ::v80(){vfunc_called(this, "_ZN6S492C43v80Ev");}
void  S492C4 ::v81(){vfunc_called(this, "_ZN6S492C43v81Ev");}
void  S492C4 ::v82(){vfunc_called(this, "_ZN6S492C43v82Ev");}
void  S492C4 ::v83(){vfunc_called(this, "_ZN6S492C43v83Ev");}
S492C4 ::S492C4(){ note_ctor("S492C4", this);} // tgen

static void Test_S492C4()
{
  extern Class_Descriptor cd_S492C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S492C4, buf);
    S492C4 *dp, &lv = *(dp=new (buf) S492C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S492C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S492C4)");
    check_base_class_offset(lv, (S492C5*), 0, "S492C4");
    test_class_info(&lv, &cd_S492C4);
    dp->~S492C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS492C4(Test_S492C4, "S492C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S492C4C1Ev();
extern void _ZN6S492C4D1Ev();
Name_Map name_map_S492C4[] = {
  NSPAIR(_ZN6S492C4C1Ev),
  NSPAIR(_ZN6S492C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S492C5;
extern VTBL_ENTRY _ZTI6S492C5[];
extern  VTBL_ENTRY _ZTV6S492C5[];
static Base_Class bases_S492C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S492C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S492C4[];
extern void _ZN6S492C4D1Ev();
extern void _ZN6S492C4D0Ev();
extern void _ZN6S492C53v16Ev();
extern void _ZN6S492C53v17Ev();
extern void _ZN6S492C53v18Ev();
extern void _ZN6S492C53v19Ev();
extern void _ZN6S492C53v20Ev();
extern void _ZN6S492C53v21Ev();
extern void _ZN6S492C53v22Ev();
extern void _ZN6S492C53v23Ev();
extern void _ZN6S492C53v24Ev();
extern void _ZN6S492C53v25Ev();
extern void _ZN6S492C53v26Ev();
extern void _ZN6S492C53v27Ev();
extern void _ZN6S492C53v28Ev();
extern void _ZN6S492C53v29Ev();
extern void _ZN6S492C53v30Ev();
extern void _ZN6S492C53v31Ev();
extern void _ZN6S492C53v32Ev();
extern void _ZN6S492C53v33Ev();
extern void _ZN6S492C53v34Ev();
extern void _ZN6S492C53v35Ev();
extern void _ZN6S492C53v36Ev();
extern void _ZN6S492C53v37Ev();
extern void _ZN6S492C53v38Ev();
extern void _ZN6S492C53v39Ev();
extern void _ZN6S492C53v40Ev();
extern void _ZN6S492C53v41Ev();
extern void _ZN6S492C53v42Ev();
extern void _ZN6S492C53v43Ev();
extern void _ZN6S492C53v44Ev();
extern void _ZN6S492C53v45Ev();
extern void _ZN6S492C53v46Ev();
extern void _ZN6S492C53v47Ev();
extern void _ZN6S492C53v48Ev();
extern void _ZN6S492C53v49Ev();
extern void _ZN6S492C53v50Ev();
extern void _ZN6S492C53v51Ev();
extern void _ZN6S492C53v52Ev();
extern void _ZN6S492C53v53Ev();
extern void _ZN6S492C53v54Ev();
extern void _ZN6S492C53v55Ev();
extern void _ZN6S492C53v56Ev();
extern void _ZN6S492C53v57Ev();
extern void _ZN6S492C53v58Ev();
extern void _ZN6S492C53v59Ev();
extern void _ZN6S492C53v60Ev();
extern void _ZN6S492C53v61Ev();
extern void _ZN6S492C53v62Ev();
extern void _ZN6S492C53v63Ev();
extern void _ZN6S492C53v64Ev();
extern void _ZN6S492C53v65Ev();
extern void _ZN6S492C53v66Ev();
extern void _ZN6S492C53v67Ev();
extern void _ZN6S492C53v68Ev();
extern void _ZN6S492C53v69Ev();
extern void _ZN6S492C53v70Ev();
extern void _ZN6S492C53v71Ev();
extern void _ZN6S492C53v72Ev();
extern void _ZN6S492C53v73Ev();
extern void _ZN6S492C53v74Ev();
extern void _ZN6S492C53v75Ev();
extern void _ZN6S492C53v76Ev();
extern void _ZN6S492C53v77Ev();
extern void _ZN6S492C53v78Ev();
extern void _ZN6S492C53v79Ev();
extern void _ZN6S492C43v80Ev();
extern void _ZN6S492C43v81Ev();
extern void _ZN6S492C43v82Ev();
extern void _ZN6S492C43v83Ev();
static  VTBL_ENTRY vtc_S492C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S492C4[0]),
  (VTBL_ENTRY)&_ZN6S492C4D1Ev,
  (VTBL_ENTRY)&_ZN6S492C4D0Ev,
  (VTBL_ENTRY)&_ZN6S492C53v16Ev,
  (VTBL_ENTRY)&_ZN6S492C53v17Ev,
  (VTBL_ENTRY)&_ZN6S492C53v18Ev,
  (VTBL_ENTRY)&_ZN6S492C53v19Ev,
  (VTBL_ENTRY)&_ZN6S492C53v20Ev,
  (VTBL_ENTRY)&_ZN6S492C53v21Ev,
  (VTBL_ENTRY)&_ZN6S492C53v22Ev,
  (VTBL_ENTRY)&_ZN6S492C53v23Ev,
  (VTBL_ENTRY)&_ZN6S492C53v24Ev,
  (VTBL_ENTRY)&_ZN6S492C53v25Ev,
  (VTBL_ENTRY)&_ZN6S492C53v26Ev,
  (VTBL_ENTRY)&_ZN6S492C53v27Ev,
  (VTBL_ENTRY)&_ZN6S492C53v28Ev,
  (VTBL_ENTRY)&_ZN6S492C53v29Ev,
  (VTBL_ENTRY)&_ZN6S492C53v30Ev,
  (VTBL_ENTRY)&_ZN6S492C53v31Ev,
  (VTBL_ENTRY)&_ZN6S492C53v32Ev,
  (VTBL_ENTRY)&_ZN6S492C53v33Ev,
  (VTBL_ENTRY)&_ZN6S492C53v34Ev,
  (VTBL_ENTRY)&_ZN6S492C53v35Ev,
  (VTBL_ENTRY)&_ZN6S492C53v36Ev,
  (VTBL_ENTRY)&_ZN6S492C53v37Ev,
  (VTBL_ENTRY)&_ZN6S492C53v38Ev,
  (VTBL_ENTRY)&_ZN6S492C53v39Ev,
  (VTBL_ENTRY)&_ZN6S492C53v40Ev,
  (VTBL_ENTRY)&_ZN6S492C53v41Ev,
  (VTBL_ENTRY)&_ZN6S492C53v42Ev,
  (VTBL_ENTRY)&_ZN6S492C53v43Ev,
  (VTBL_ENTRY)&_ZN6S492C53v44Ev,
  (VTBL_ENTRY)&_ZN6S492C53v45Ev,
  (VTBL_ENTRY)&_ZN6S492C53v46Ev,
  (VTBL_ENTRY)&_ZN6S492C53v47Ev,
  (VTBL_ENTRY)&_ZN6S492C53v48Ev,
  (VTBL_ENTRY)&_ZN6S492C53v49Ev,
  (VTBL_ENTRY)&_ZN6S492C53v50Ev,
  (VTBL_ENTRY)&_ZN6S492C53v51Ev,
  (VTBL_ENTRY)&_ZN6S492C53v52Ev,
  (VTBL_ENTRY)&_ZN6S492C53v53Ev,
  (VTBL_ENTRY)&_ZN6S492C53v54Ev,
  (VTBL_ENTRY)&_ZN6S492C53v55Ev,
  (VTBL_ENTRY)&_ZN6S492C53v56Ev,
  (VTBL_ENTRY)&_ZN6S492C53v57Ev,
  (VTBL_ENTRY)&_ZN6S492C53v58Ev,
  (VTBL_ENTRY)&_ZN6S492C53v59Ev,
  (VTBL_ENTRY)&_ZN6S492C53v60Ev,
  (VTBL_ENTRY)&_ZN6S492C53v61Ev,
  (VTBL_ENTRY)&_ZN6S492C53v62Ev,
  (VTBL_ENTRY)&_ZN6S492C53v63Ev,
  (VTBL_ENTRY)&_ZN6S492C53v64Ev,
  (VTBL_ENTRY)&_ZN6S492C53v65Ev,
  (VTBL_ENTRY)&_ZN6S492C53v66Ev,
  (VTBL_ENTRY)&_ZN6S492C53v67Ev,
  (VTBL_ENTRY)&_ZN6S492C53v68Ev,
  (VTBL_ENTRY)&_ZN6S492C53v69Ev,
  (VTBL_ENTRY)&_ZN6S492C53v70Ev,
  (VTBL_ENTRY)&_ZN6S492C53v71Ev,
  (VTBL_ENTRY)&_ZN6S492C53v72Ev,
  (VTBL_ENTRY)&_ZN6S492C53v73Ev,
  (VTBL_ENTRY)&_ZN6S492C53v74Ev,
  (VTBL_ENTRY)&_ZN6S492C53v75Ev,
  (VTBL_ENTRY)&_ZN6S492C53v76Ev,
  (VTBL_ENTRY)&_ZN6S492C53v77Ev,
  (VTBL_ENTRY)&_ZN6S492C53v78Ev,
  (VTBL_ENTRY)&_ZN6S492C53v79Ev,
  (VTBL_ENTRY)&_ZN6S492C43v80Ev,
  (VTBL_ENTRY)&_ZN6S492C43v81Ev,
  (VTBL_ENTRY)&_ZN6S492C43v82Ev,
  (VTBL_ENTRY)&_ZN6S492C43v83Ev,
};
extern VTBL_ENTRY _ZTI6S492C4[];
extern  VTBL_ENTRY _ZTV6S492C4[];
Class_Descriptor cd_S492C4 = {  "S492C4", // class name
  bases_S492C4, 1,
  &(vtc_S492C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S492C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S492C4),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S492C3  : S492C4 {
  ::S685C27_nt s492c3f0;
  virtual  ~S492C3(); // _ZN6S492C3D1Ev
  virtual void  v84(); // _ZN6S492C33v84Ev
  virtual void  v85(); // _ZN6S492C33v85Ev
  virtual void  v86(); // _ZN6S492C33v86Ev
  virtual void  v87(); // _ZN6S492C33v87Ev
  virtual void  v88(); // _ZN6S492C33v88Ev
  virtual void  v89(); // _ZN6S492C33v89Ev
  virtual void  v90(); // _ZN6S492C33v90Ev
  virtual void  v91(); // _ZN6S492C33v91Ev
  virtual void  v92(); // _ZN6S492C33v92Ev
  virtual void  v93(); // _ZN6S492C33v93Ev
  virtual void  v94(); // _ZN6S492C33v94Ev
  virtual void  v95(); // _ZN6S492C33v95Ev
  virtual void  v96(); // _ZN6S492C33v96Ev
  virtual void  v97(); // _ZN6S492C33v97Ev
  virtual void  v98(); // _ZN6S492C33v98Ev
  virtual void  v99(); // _ZN6S492C33v99Ev
  virtual void  v100(); // _ZN6S492C34v100Ev
  virtual void  v101(); // _ZN6S492C34v101Ev
  virtual void  v102(); // _ZN6S492C34v102Ev
  virtual void  v103(); // _ZN6S492C34v103Ev
  virtual void  v104(); // _ZN6S492C34v104Ev
  virtual void  v105(); // _ZN6S492C34v105Ev
  virtual void  v106(); // _ZN6S492C34v106Ev
  virtual void  v107(); // _ZN6S492C34v107Ev
  virtual void  v108(); // _ZN6S492C34v108Ev
  virtual void  v109(); // _ZN6S492C34v109Ev
  virtual void  v110(); // _ZN6S492C34v110Ev
  virtual void  v111(); // _ZN6S492C34v111Ev
  virtual void  v112(); // _ZN6S492C34v112Ev
  virtual void  v113(); // _ZN6S492C34v113Ev
  virtual void  v114(); // _ZN6S492C34v114Ev
  S492C3(); // tgen
};
//SIG(-1 S492C3) C1{ BC2{ BC3{ vd v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v96 v97 v98 v99} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}}}


 S492C3 ::~S492C3(){ note_dtor("S492C3", this);}
void  S492C3 ::v84(){vfunc_called(this, "_ZN6S492C33v84Ev");}
void  S492C3 ::v85(){vfunc_called(this, "_ZN6S492C33v85Ev");}
void  S492C3 ::v86(){vfunc_called(this, "_ZN6S492C33v86Ev");}
void  S492C3 ::v87(){vfunc_called(this, "_ZN6S492C33v87Ev");}
void  S492C3 ::v88(){vfunc_called(this, "_ZN6S492C33v88Ev");}
void  S492C3 ::v89(){vfunc_called(this, "_ZN6S492C33v89Ev");}
void  S492C3 ::v90(){vfunc_called(this, "_ZN6S492C33v90Ev");}
void  S492C3 ::v91(){vfunc_called(this, "_ZN6S492C33v91Ev");}
void  S492C3 ::v92(){vfunc_called(this, "_ZN6S492C33v92Ev");}
void  S492C3 ::v93(){vfunc_called(this, "_ZN6S492C33v93Ev");}
void  S492C3 ::v94(){vfunc_called(this, "_ZN6S492C33v94Ev");}
void  S492C3 ::v95(){vfunc_called(this, "_ZN6S492C33v95Ev");}
void  S492C3 ::v96(){vfunc_called(this, "_ZN6S492C33v96Ev");}
void  S492C3 ::v97(){vfunc_called(this, "_ZN6S492C33v97Ev");}
void  S492C3 ::v98(){vfunc_called(this, "_ZN6S492C33v98Ev");}
void  S492C3 ::v99(){vfunc_called(this, "_ZN6S492C33v99Ev");}
void  S492C3 ::v100(){vfunc_called(this, "_ZN6S492C34v100Ev");}
void  S492C3 ::v101(){vfunc_called(this, "_ZN6S492C34v101Ev");}
void  S492C3 ::v102(){vfunc_called(this, "_ZN6S492C34v102Ev");}
void  S492C3 ::v103(){vfunc_called(this, "_ZN6S492C34v103Ev");}
void  S492C3 ::v104(){vfunc_called(this, "_ZN6S492C34v104Ev");}
void  S492C3 ::v105(){vfunc_called(this, "_ZN6S492C34v105Ev");}
void  S492C3 ::v106(){vfunc_called(this, "_ZN6S492C34v106Ev");}
void  S492C3 ::v107(){vfunc_called(this, "_ZN6S492C34v107Ev");}
void  S492C3 ::v108(){vfunc_called(this, "_ZN6S492C34v108Ev");}
void  S492C3 ::v109(){vfunc_called(this, "_ZN6S492C34v109Ev");}
void  S492C3 ::v110(){vfunc_called(this, "_ZN6S492C34v110Ev");}
void  S492C3 ::v111(){vfunc_called(this, "_ZN6S492C34v111Ev");}
void  S492C3 ::v112(){vfunc_called(this, "_ZN6S492C34v112Ev");}
void  S492C3 ::v113(){vfunc_called(this, "_ZN6S492C34v113Ev");}
void  S492C3 ::v114(){vfunc_called(this, "_ZN6S492C34v114Ev");}
S492C3 ::S492C3(){ note_ctor("S492C3", this);} // tgen

static void Test_S492C3()
{
  extern Class_Descriptor cd_S492C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(15,19)];
    init_test(&cd_S492C3, buf);
    S492C3 *dp, &lv = *(dp=new (buf) S492C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(112,72), "sizeof(S492C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S492C3)");
    check_base_class_offset(lv, (S492C5*)(S492C4*), 0, "S492C3");
    check_base_class_offset(lv, (S492C4*), 0, "S492C3");
    check_field_offset(lv, s492c3f0, ABISELECT(96,60), "S492C3.s492c3f0");
    test_class_info(&lv, &cd_S492C3);
    dp->~S492C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS492C3(Test_S492C3, "S492C3", ABISELECT(112,72));

#else // __cplusplus

extern void _ZN6S492C3C1Ev();
extern void _ZN6S492C3D1Ev();
Name_Map name_map_S492C3[] = {
  NSPAIR(_ZN6S492C3C1Ev),
  NSPAIR(_ZN6S492C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S492C5;
extern VTBL_ENTRY _ZTI6S492C5[];
extern  VTBL_ENTRY _ZTV6S492C5[];
extern Class_Descriptor cd_S492C4;
extern VTBL_ENTRY _ZTI6S492C4[];
extern  VTBL_ENTRY _ZTV6S492C4[];
static Base_Class bases_S492C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S492C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S492C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S492C3[];
extern void _ZN6S492C3D1Ev();
extern void _ZN6S492C3D0Ev();
extern void _ZN6S492C53v16Ev();
extern void _ZN6S492C53v17Ev();
extern void _ZN6S492C53v18Ev();
extern void _ZN6S492C53v19Ev();
extern void _ZN6S492C53v20Ev();
extern void _ZN6S492C53v21Ev();
extern void _ZN6S492C53v22Ev();
extern void _ZN6S492C53v23Ev();
extern void _ZN6S492C53v24Ev();
extern void _ZN6S492C53v25Ev();
extern void _ZN6S492C53v26Ev();
extern void _ZN6S492C53v27Ev();
extern void _ZN6S492C53v28Ev();
extern void _ZN6S492C53v29Ev();
extern void _ZN6S492C53v30Ev();
extern void _ZN6S492C53v31Ev();
extern void _ZN6S492C53v32Ev();
extern void _ZN6S492C53v33Ev();
extern void _ZN6S492C53v34Ev();
extern void _ZN6S492C53v35Ev();
extern void _ZN6S492C53v36Ev();
extern void _ZN6S492C53v37Ev();
extern void _ZN6S492C53v38Ev();
extern void _ZN6S492C53v39Ev();
extern void _ZN6S492C53v40Ev();
extern void _ZN6S492C53v41Ev();
extern void _ZN6S492C53v42Ev();
extern void _ZN6S492C53v43Ev();
extern void _ZN6S492C53v44Ev();
extern void _ZN6S492C53v45Ev();
extern void _ZN6S492C53v46Ev();
extern void _ZN6S492C53v47Ev();
extern void _ZN6S492C53v48Ev();
extern void _ZN6S492C53v49Ev();
extern void _ZN6S492C53v50Ev();
extern void _ZN6S492C53v51Ev();
extern void _ZN6S492C53v52Ev();
extern void _ZN6S492C53v53Ev();
extern void _ZN6S492C53v54Ev();
extern void _ZN6S492C53v55Ev();
extern void _ZN6S492C53v56Ev();
extern void _ZN6S492C53v57Ev();
extern void _ZN6S492C53v58Ev();
extern void _ZN6S492C53v59Ev();
extern void _ZN6S492C53v60Ev();
extern void _ZN6S492C53v61Ev();
extern void _ZN6S492C53v62Ev();
extern void _ZN6S492C53v63Ev();
extern void _ZN6S492C53v64Ev();
extern void _ZN6S492C53v65Ev();
extern void _ZN6S492C53v66Ev();
extern void _ZN6S492C53v67Ev();
extern void _ZN6S492C53v68Ev();
extern void _ZN6S492C53v69Ev();
extern void _ZN6S492C53v70Ev();
extern void _ZN6S492C53v71Ev();
extern void _ZN6S492C53v72Ev();
extern void _ZN6S492C53v73Ev();
extern void _ZN6S492C53v74Ev();
extern void _ZN6S492C53v75Ev();
extern void _ZN6S492C53v76Ev();
extern void _ZN6S492C53v77Ev();
extern void _ZN6S492C53v78Ev();
extern void _ZN6S492C53v79Ev();
extern void _ZN6S492C43v80Ev();
extern void _ZN6S492C43v81Ev();
extern void _ZN6S492C43v82Ev();
extern void _ZN6S492C43v83Ev();
extern void _ZN6S492C33v84Ev();
extern void _ZN6S492C33v85Ev();
extern void _ZN6S492C33v86Ev();
extern void _ZN6S492C33v87Ev();
extern void _ZN6S492C33v88Ev();
extern void _ZN6S492C33v89Ev();
extern void _ZN6S492C33v90Ev();
extern void _ZN6S492C33v91Ev();
extern void _ZN6S492C33v92Ev();
extern void _ZN6S492C33v93Ev();
extern void _ZN6S492C33v94Ev();
extern void _ZN6S492C33v95Ev();
extern void _ZN6S492C33v96Ev();
extern void _ZN6S492C33v97Ev();
extern void _ZN6S492C33v98Ev();
extern void _ZN6S492C33v99Ev();
extern void _ZN6S492C34v100Ev();
extern void _ZN6S492C34v101Ev();
extern void _ZN6S492C34v102Ev();
extern void _ZN6S492C34v103Ev();
extern void _ZN6S492C34v104Ev();
extern void _ZN6S492C34v105Ev();
extern void _ZN6S492C34v106Ev();
extern void _ZN6S492C34v107Ev();
extern void _ZN6S492C34v108Ev();
extern void _ZN6S492C34v109Ev();
extern void _ZN6S492C34v110Ev();
extern void _ZN6S492C34v111Ev();
extern void _ZN6S492C34v112Ev();
extern void _ZN6S492C34v113Ev();
extern void _ZN6S492C34v114Ev();
static  VTBL_ENTRY vtc_S492C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S492C3[0]),
  (VTBL_ENTRY)&_ZN6S492C3D1Ev,
  (VTBL_ENTRY)&_ZN6S492C3D0Ev,
  (VTBL_ENTRY)&_ZN6S492C53v16Ev,
  (VTBL_ENTRY)&_ZN6S492C53v17Ev,
  (VTBL_ENTRY)&_ZN6S492C53v18Ev,
  (VTBL_ENTRY)&_ZN6S492C53v19Ev,
  (VTBL_ENTRY)&_ZN6S492C53v20Ev,
  (VTBL_ENTRY)&_ZN6S492C53v21Ev,
  (VTBL_ENTRY)&_ZN6S492C53v22Ev,
  (VTBL_ENTRY)&_ZN6S492C53v23Ev,
  (VTBL_ENTRY)&_ZN6S492C53v24Ev,
  (VTBL_ENTRY)&_ZN6S492C53v25Ev,
  (VTBL_ENTRY)&_ZN6S492C53v26Ev,
  (VTBL_ENTRY)&_ZN6S492C53v27Ev,
  (VTBL_ENTRY)&_ZN6S492C53v28Ev,
  (VTBL_ENTRY)&_ZN6S492C53v29Ev,
  (VTBL_ENTRY)&_ZN6S492C53v30Ev,
  (VTBL_ENTRY)&_ZN6S492C53v31Ev,
  (VTBL_ENTRY)&_ZN6S492C53v32Ev,
  (VTBL_ENTRY)&_ZN6S492C53v33Ev,
  (VTBL_ENTRY)&_ZN6S492C53v34Ev,
  (VTBL_ENTRY)&_ZN6S492C53v35Ev,
  (VTBL_ENTRY)&_ZN6S492C53v36Ev,
  (VTBL_ENTRY)&_ZN6S492C53v37Ev,
  (VTBL_ENTRY)&_ZN6S492C53v38Ev,
  (VTBL_ENTRY)&_ZN6S492C53v39Ev,
  (VTBL_ENTRY)&_ZN6S492C53v40Ev,
  (VTBL_ENTRY)&_ZN6S492C53v41Ev,
  (VTBL_ENTRY)&_ZN6S492C53v42Ev,
  (VTBL_ENTRY)&_ZN6S492C53v43Ev,
  (VTBL_ENTRY)&_ZN6S492C53v44Ev,
  (VTBL_ENTRY)&_ZN6S492C53v45Ev,
  (VTBL_ENTRY)&_ZN6S492C53v46Ev,
  (VTBL_ENTRY)&_ZN6S492C53v47Ev,
  (VTBL_ENTRY)&_ZN6S492C53v48Ev,
  (VTBL_ENTRY)&_ZN6S492C53v49Ev,
  (VTBL_ENTRY)&_ZN6S492C53v50Ev,
  (VTBL_ENTRY)&_ZN6S492C53v51Ev,
  (VTBL_ENTRY)&_ZN6S492C53v52Ev,
  (VTBL_ENTRY)&_ZN6S492C53v53Ev,
  (VTBL_ENTRY)&_ZN6S492C53v54Ev,
  (VTBL_ENTRY)&_ZN6S492C53v55Ev,
  (VTBL_ENTRY)&_ZN6S492C53v56Ev,
  (VTBL_ENTRY)&_ZN6S492C53v57Ev,
  (VTBL_ENTRY)&_ZN6S492C53v58Ev,
  (VTBL_ENTRY)&_ZN6S492C53v59Ev,
  (VTBL_ENTRY)&_ZN6S492C53v60Ev,
  (VTBL_ENTRY)&_ZN6S492C53v61Ev,
  (VTBL_ENTRY)&_ZN6S492C53v62Ev,
  (VTBL_ENTRY)&_ZN6S492C53v63Ev,
  (VTBL_ENTRY)&_ZN6S492C53v64Ev,
  (VTBL_ENTRY)&_ZN6S492C53v65Ev,
  (VTBL_ENTRY)&_ZN6S492C53v66Ev,
  (VTBL_ENTRY)&_ZN6S492C53v67Ev,
  (VTBL_ENTRY)&_ZN6S492C53v68Ev,
  (VTBL_ENTRY)&_ZN6S492C53v69Ev,
  (VTBL_ENTRY)&_ZN6S492C53v70Ev,
  (VTBL_ENTRY)&_ZN6S492C53v71Ev,
  (VTBL_ENTRY)&_ZN6S492C53v72Ev,
  (VTBL_ENTRY)&_ZN6S492C53v73Ev,
  (VTBL_ENTRY)&_ZN6S492C53v74Ev,
  (VTBL_ENTRY)&_ZN6S492C53v75Ev,
  (VTBL_ENTRY)&_ZN6S492C53v76Ev,
  (VTBL_ENTRY)&_ZN6S492C53v77Ev,
  (VTBL_ENTRY)&_ZN6S492C53v78Ev,
  (VTBL_ENTRY)&_ZN6S492C53v79Ev,
  (VTBL_ENTRY)&_ZN6S492C43v80Ev,
  (VTBL_ENTRY)&_ZN6S492C43v81Ev,
  (VTBL_ENTRY)&_ZN6S492C43v82Ev,
  (VTBL_ENTRY)&_ZN6S492C43v83Ev,
  (VTBL_ENTRY)&_ZN6S492C33v84Ev,
  (VTBL_ENTRY)&_ZN6S492C33v85Ev,
  (VTBL_ENTRY)&_ZN6S492C33v86Ev,
  (VTBL_ENTRY)&_ZN6S492C33v87Ev,
  (VTBL_ENTRY)&_ZN6S492C33v88Ev,
  (VTBL_ENTRY)&_ZN6S492C33v89Ev,
  (VTBL_ENTRY)&_ZN6S492C33v90Ev,
  (VTBL_ENTRY)&_ZN6S492C33v91Ev,
  (VTBL_ENTRY)&_ZN6S492C33v92Ev,
  (VTBL_ENTRY)&_ZN6S492C33v93Ev,
  (VTBL_ENTRY)&_ZN6S492C33v94Ev,
  (VTBL_ENTRY)&_ZN6S492C33v95Ev,
  (VTBL_ENTRY)&_ZN6S492C33v96Ev,
  (VTBL_ENTRY)&_ZN6S492C33v97Ev,
  (VTBL_ENTRY)&_ZN6S492C33v98Ev,
  (VTBL_ENTRY)&_ZN6S492C33v99Ev,
  (VTBL_ENTRY)&_ZN6S492C34v100Ev,
  (VTBL_ENTRY)&_ZN6S492C34v101Ev,
  (VTBL_ENTRY)&_ZN6S492C34v102Ev,
  (VTBL_ENTRY)&_ZN6S492C34v103Ev,
  (VTBL_ENTRY)&_ZN6S492C34v104Ev,
  (VTBL_ENTRY)&_ZN6S492C34v105Ev,
  (VTBL_ENTRY)&_ZN6S492C34v106Ev,
  (VTBL_ENTRY)&_ZN6S492C34v107Ev,
  (VTBL_ENTRY)&_ZN6S492C34v108Ev,
  (VTBL_ENTRY)&_ZN6S492C34v109Ev,
  (VTBL_ENTRY)&_ZN6S492C34v110Ev,
  (VTBL_ENTRY)&_ZN6S492C34v111Ev,
  (VTBL_ENTRY)&_ZN6S492C34v112Ev,
  (VTBL_ENTRY)&_ZN6S492C34v113Ev,
  (VTBL_ENTRY)&_ZN6S492C34v114Ev,
};
extern VTBL_ENTRY _ZTI6S492C3[];
extern  VTBL_ENTRY _ZTV6S492C3[];
Class_Descriptor cd_S492C3 = {  "S492C3", // class name
  bases_S492C3, 2,
  &(vtc_S492C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(112,72), // object size
  NSPAIRA(_ZTI6S492C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S492C3),103, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S492C2  : S492C3 {
  void *s492c2f0[2];
  unsigned int s492c2f1:1;
  unsigned int s492c2f2:1;
  unsigned int s492c2f3:1;
  void *s492c2f4[6];
  ::S685C39 s492c2f5;
  virtual  ~S492C2(); // _ZN6S492C2D1Ev
  virtual void  v115(); // _ZN6S492C24v115Ev
  virtual void  v116(); // _ZN6S492C24v116Ev
  virtual void  v117(); // _ZN6S492C24v117Ev
  virtual void  v118(); // _ZN6S492C24v118Ev
  virtual void  v119(); // _ZN6S492C24v119Ev
  virtual void  v120(); // _ZN6S492C24v120Ev
  virtual void  v121(); // _ZN6S492C24v121Ev
  virtual void  v122(); // _ZN6S492C24v122Ev
  virtual void  v123(); // _ZN6S492C24v123Ev
  virtual void  v124(); // _ZN6S492C24v124Ev
  virtual void  v125(); // _ZN6S492C24v125Ev
  virtual void  v126(); // _ZN6S492C24v126Ev
  virtual void  v127(); // _ZN6S492C24v127Ev
  virtual void  v128(); // _ZN6S492C24v128Ev
  virtual void  v129(); // _ZN6S492C24v129Ev
  virtual void  v130(); // _ZN6S492C24v130Ev
  virtual void  v131(); // _ZN6S492C24v131Ev
  virtual void  v132(); // _ZN6S492C24v132Ev
  virtual void  v133(); // _ZN6S492C24v133Ev
  virtual void  v134(); // _ZN6S492C24v134Ev
  virtual void  v135(); // _ZN6S492C24v135Ev
  virtual void  v136(); // _ZN6S492C24v136Ev
  virtual void  v137(); // _ZN6S492C24v137Ev
  virtual void  v138(); // _ZN6S492C24v138Ev
  virtual void  v139(); // _ZN6S492C24v139Ev
  virtual void  v140(); // _ZN6S492C24v140Ev
  virtual void  v141(); // _ZN6S492C24v141Ev
  virtual void  v142(); // _ZN6S492C24v142Ev
  virtual void  v143(); // _ZN6S492C24v143Ev
  virtual void  v144(); // _ZN6S492C24v144Ev
  virtual void  v145(); // _ZN6S492C24v145Ev
  virtual void  v146(); // _ZN6S492C24v146Ev
  virtual void  v147(); // _ZN6S492C24v147Ev
  virtual void  v148(); // _ZN6S492C24v148Ev
  virtual void  v149(); // _ZN6S492C24v149Ev
  virtual void  v150(); // _ZN6S492C24v150Ev
  virtual void  v151(); // _ZN6S492C24v151Ev
  S492C2(); // tgen
};
//SIG(-1 S492C2) C1{ BC2{ BC3{ BC4{ vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v102 v103 v104 v105} vd v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp[2] Fi:1 Fi:1 Fi:1 Fp[6] FC10{ BC11{ BC9}}}


 S492C2 ::~S492C2(){ note_dtor("S492C2", this);}
void  S492C2 ::v115(){vfunc_called(this, "_ZN6S492C24v115Ev");}
void  S492C2 ::v116(){vfunc_called(this, "_ZN6S492C24v116Ev");}
void  S492C2 ::v117(){vfunc_called(this, "_ZN6S492C24v117Ev");}
void  S492C2 ::v118(){vfunc_called(this, "_ZN6S492C24v118Ev");}
void  S492C2 ::v119(){vfunc_called(this, "_ZN6S492C24v119Ev");}
void  S492C2 ::v120(){vfunc_called(this, "_ZN6S492C24v120Ev");}
void  S492C2 ::v121(){vfunc_called(this, "_ZN6S492C24v121Ev");}
void  S492C2 ::v122(){vfunc_called(this, "_ZN6S492C24v122Ev");}
void  S492C2 ::v123(){vfunc_called(this, "_ZN6S492C24v123Ev");}
void  S492C2 ::v124(){vfunc_called(this, "_ZN6S492C24v124Ev");}
void  S492C2 ::v125(){vfunc_called(this, "_ZN6S492C24v125Ev");}
void  S492C2 ::v126(){vfunc_called(this, "_ZN6S492C24v126Ev");}
void  S492C2 ::v127(){vfunc_called(this, "_ZN6S492C24v127Ev");}
void  S492C2 ::v128(){vfunc_called(this, "_ZN6S492C24v128Ev");}
void  S492C2 ::v129(){vfunc_called(this, "_ZN6S492C24v129Ev");}
void  S492C2 ::v130(){vfunc_called(this, "_ZN6S492C24v130Ev");}
void  S492C2 ::v131(){vfunc_called(this, "_ZN6S492C24v131Ev");}
void  S492C2 ::v132(){vfunc_called(this, "_ZN6S492C24v132Ev");}
void  S492C2 ::v133(){vfunc_called(this, "_ZN6S492C24v133Ev");}
void  S492C2 ::v134(){vfunc_called(this, "_ZN6S492C24v134Ev");}
void  S492C2 ::v135(){vfunc_called(this, "_ZN6S492C24v135Ev");}
void  S492C2 ::v136(){vfunc_called(this, "_ZN6S492C24v136Ev");}
void  S492C2 ::v137(){vfunc_called(this, "_ZN6S492C24v137Ev");}
void  S492C2 ::v138(){vfunc_called(this, "_ZN6S492C24v138Ev");}
void  S492C2 ::v139(){vfunc_called(this, "_ZN6S492C24v139Ev");}
void  S492C2 ::v140(){vfunc_called(this, "_ZN6S492C24v140Ev");}
void  S492C2 ::v141(){vfunc_called(this, "_ZN6S492C24v141Ev");}
void  S492C2 ::v142(){vfunc_called(this, "_ZN6S492C24v142Ev");}
void  S492C2 ::v143(){vfunc_called(this, "_ZN6S492C24v143Ev");}
void  S492C2 ::v144(){vfunc_called(this, "_ZN6S492C24v144Ev");}
void  S492C2 ::v145(){vfunc_called(this, "_ZN6S492C24v145Ev");}
void  S492C2 ::v146(){vfunc_called(this, "_ZN6S492C24v146Ev");}
void  S492C2 ::v147(){vfunc_called(this, "_ZN6S492C24v147Ev");}
void  S492C2 ::v148(){vfunc_called(this, "_ZN6S492C24v148Ev");}
void  S492C2 ::v149(){vfunc_called(this, "_ZN6S492C24v149Ev");}
void  S492C2 ::v150(){vfunc_called(this, "_ZN6S492C24v150Ev");}
void  S492C2 ::v151(){vfunc_called(this, "_ZN6S492C24v151Ev");}
S492C2 ::S492C2(){ note_ctor("S492C2", this);} // tgen

static void Test_S492C2()
{
  extern Class_Descriptor cd_S492C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,31)];
    init_test(&cd_S492C2, buf);
    S492C2 *dp, &lv = *(dp=new (buf) S492C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,120), "sizeof(S492C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S492C2)");
    check_base_class_offset(lv, (S492C5*)(S492C4*)(S492C3*), 0, "S492C2");
    check_base_class_offset(lv, (S492C4*)(S492C3*), 0, "S492C2");
    check_base_class_offset(lv, (S492C3*), 0, "S492C2");
    check_field_offset(lv, s492c2f0, ABISELECT(112,72), "S492C2.s492c2f0");
    set_bf_and_test(lv, s492c2f1, ABISELECT(128,80), 0, 1, 1, "S492C2");
    set_bf_and_test(lv, s492c2f2, ABISELECT(128,80), 1, 1, 1, "S492C2");
    set_bf_and_test(lv, s492c2f3, ABISELECT(128,80), 2, 1, 1, "S492C2");
    check_field_offset(lv, s492c2f4, ABISELECT(136,84), "S492C2.s492c2f4");
    check_field_offset(lv, s492c2f5, ABISELECT(184,108), "S492C2.s492c2f5");
    test_class_info(&lv, &cd_S492C2);
    dp->~S492C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS492C2(Test_S492C2, "S492C2", ABISELECT(200,120));

#else // __cplusplus

extern void _ZN6S492C2C1Ev();
extern void _ZN6S492C2D1Ev();
Name_Map name_map_S492C2[] = {
  NSPAIR(_ZN6S492C2C1Ev),
  NSPAIR(_ZN6S492C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S492C5;
extern VTBL_ENTRY _ZTI6S492C5[];
extern  VTBL_ENTRY _ZTV6S492C5[];
extern Class_Descriptor cd_S492C4;
extern VTBL_ENTRY _ZTI6S492C4[];
extern  VTBL_ENTRY _ZTV6S492C4[];
extern Class_Descriptor cd_S492C3;
extern VTBL_ENTRY _ZTI6S492C3[];
extern  VTBL_ENTRY _ZTV6S492C3[];
static Base_Class bases_S492C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S492C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S492C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S492C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S492C2[];
extern void _ZN6S492C2D1Ev();
extern void _ZN6S492C2D0Ev();
extern void _ZN6S492C53v16Ev();
extern void _ZN6S492C53v17Ev();
extern void _ZN6S492C53v18Ev();
extern void _ZN6S492C53v19Ev();
extern void _ZN6S492C53v20Ev();
extern void _ZN6S492C53v21Ev();
extern void _ZN6S492C53v22Ev();
extern void _ZN6S492C53v23Ev();
extern void _ZN6S492C53v24Ev();
extern void _ZN6S492C53v25Ev();
extern void _ZN6S492C53v26Ev();
extern void _ZN6S492C53v27Ev();
extern void _ZN6S492C53v28Ev();
extern void _ZN6S492C53v29Ev();
extern void _ZN6S492C53v30Ev();
extern void _ZN6S492C53v31Ev();
extern void _ZN6S492C53v32Ev();
extern void _ZN6S492C53v33Ev();
extern void _ZN6S492C53v34Ev();
extern void _ZN6S492C53v35Ev();
extern void _ZN6S492C53v36Ev();
extern void _ZN6S492C53v37Ev();
extern void _ZN6S492C53v38Ev();
extern void _ZN6S492C53v39Ev();
extern void _ZN6S492C53v40Ev();
extern void _ZN6S492C53v41Ev();
extern void _ZN6S492C53v42Ev();
extern void _ZN6S492C53v43Ev();
extern void _ZN6S492C53v44Ev();
extern void _ZN6S492C53v45Ev();
extern void _ZN6S492C53v46Ev();
extern void _ZN6S492C53v47Ev();
extern void _ZN6S492C53v48Ev();
extern void _ZN6S492C53v49Ev();
extern void _ZN6S492C53v50Ev();
extern void _ZN6S492C53v51Ev();
extern void _ZN6S492C53v52Ev();
extern void _ZN6S492C53v53Ev();
extern void _ZN6S492C53v54Ev();
extern void _ZN6S492C53v55Ev();
extern void _ZN6S492C53v56Ev();
extern void _ZN6S492C53v57Ev();
extern void _ZN6S492C53v58Ev();
extern void _ZN6S492C53v59Ev();
extern void _ZN6S492C53v60Ev();
extern void _ZN6S492C53v61Ev();
extern void _ZN6S492C53v62Ev();
extern void _ZN6S492C53v63Ev();
extern void _ZN6S492C53v64Ev();
extern void _ZN6S492C53v65Ev();
extern void _ZN6S492C53v66Ev();
extern void _ZN6S492C53v67Ev();
extern void _ZN6S492C53v68Ev();
extern void _ZN6S492C53v69Ev();
extern void _ZN6S492C53v70Ev();
extern void _ZN6S492C53v71Ev();
extern void _ZN6S492C53v72Ev();
extern void _ZN6S492C53v73Ev();
extern void _ZN6S492C53v74Ev();
extern void _ZN6S492C53v75Ev();
extern void _ZN6S492C53v76Ev();
extern void _ZN6S492C53v77Ev();
extern void _ZN6S492C53v78Ev();
extern void _ZN6S492C53v79Ev();
extern void _ZN6S492C43v80Ev();
extern void _ZN6S492C43v81Ev();
extern void _ZN6S492C43v82Ev();
extern void _ZN6S492C43v83Ev();
extern void _ZN6S492C33v84Ev();
extern void _ZN6S492C33v85Ev();
extern void _ZN6S492C33v86Ev();
extern void _ZN6S492C33v87Ev();
extern void _ZN6S492C33v88Ev();
extern void _ZN6S492C33v89Ev();
extern void _ZN6S492C33v90Ev();
extern void _ZN6S492C33v91Ev();
extern void _ZN6S492C33v92Ev();
extern void _ZN6S492C33v93Ev();
extern void _ZN6S492C33v94Ev();
extern void _ZN6S492C33v95Ev();
extern void _ZN6S492C33v96Ev();
extern void _ZN6S492C33v97Ev();
extern void _ZN6S492C33v98Ev();
extern void _ZN6S492C33v99Ev();
extern void _ZN6S492C34v100Ev();
extern void _ZN6S492C34v101Ev();
extern void _ZN6S492C34v102Ev();
extern void _ZN6S492C34v103Ev();
extern void _ZN6S492C34v104Ev();
extern void _ZN6S492C34v105Ev();
extern void _ZN6S492C34v106Ev();
extern void _ZN6S492C34v107Ev();
extern void _ZN6S492C34v108Ev();
extern void _ZN6S492C34v109Ev();
extern void _ZN6S492C34v110Ev();
extern void _ZN6S492C34v111Ev();
extern void _ZN6S492C34v112Ev();
extern void _ZN6S492C34v113Ev();
extern void _ZN6S492C34v114Ev();
extern void _ZN6S492C24v115Ev();
extern void _ZN6S492C24v116Ev();
extern void _ZN6S492C24v117Ev();
extern void _ZN6S492C24v118Ev();
extern void _ZN6S492C24v119Ev();
extern void _ZN6S492C24v120Ev();
extern void _ZN6S492C24v121Ev();
extern void _ZN6S492C24v122Ev();
extern void _ZN6S492C24v123Ev();
extern void _ZN6S492C24v124Ev();
extern void _ZN6S492C24v125Ev();
extern void _ZN6S492C24v126Ev();
extern void _ZN6S492C24v127Ev();
extern void _ZN6S492C24v128Ev();
extern void _ZN6S492C24v129Ev();
extern void _ZN6S492C24v130Ev();
extern void _ZN6S492C24v131Ev();
extern void _ZN6S492C24v132Ev();
extern void _ZN6S492C24v133Ev();
extern void _ZN6S492C24v134Ev();
extern void _ZN6S492C24v135Ev();
extern void _ZN6S492C24v136Ev();
extern void _ZN6S492C24v137Ev();
extern void _ZN6S492C24v138Ev();
extern void _ZN6S492C24v139Ev();
extern void _ZN6S492C24v140Ev();
extern void _ZN6S492C24v141Ev();
extern void _ZN6S492C24v142Ev();
extern void _ZN6S492C24v143Ev();
extern void _ZN6S492C24v144Ev();
extern void _ZN6S492C24v145Ev();
extern void _ZN6S492C24v146Ev();
extern void _ZN6S492C24v147Ev();
extern void _ZN6S492C24v148Ev();
extern void _ZN6S492C24v149Ev();
extern void _ZN6S492C24v150Ev();
extern void _ZN6S492C24v151Ev();
static  VTBL_ENTRY vtc_S492C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S492C2[0]),
  (VTBL_ENTRY)&_ZN6S492C2D1Ev,
  (VTBL_ENTRY)&_ZN6S492C2D0Ev,
  (VTBL_ENTRY)&_ZN6S492C53v16Ev,
  (VTBL_ENTRY)&_ZN6S492C53v17Ev,
  (VTBL_ENTRY)&_ZN6S492C53v18Ev,
  (VTBL_ENTRY)&_ZN6S492C53v19Ev,
  (VTBL_ENTRY)&_ZN6S492C53v20Ev,
  (VTBL_ENTRY)&_ZN6S492C53v21Ev,
  (VTBL_ENTRY)&_ZN6S492C53v22Ev,
  (VTBL_ENTRY)&_ZN6S492C53v23Ev,
  (VTBL_ENTRY)&_ZN6S492C53v24Ev,
  (VTBL_ENTRY)&_ZN6S492C53v25Ev,
  (VTBL_ENTRY)&_ZN6S492C53v26Ev,
  (VTBL_ENTRY)&_ZN6S492C53v27Ev,
  (VTBL_ENTRY)&_ZN6S492C53v28Ev,
  (VTBL_ENTRY)&_ZN6S492C53v29Ev,
  (VTBL_ENTRY)&_ZN6S492C53v30Ev,
  (VTBL_ENTRY)&_ZN6S492C53v31Ev,
  (VTBL_ENTRY)&_ZN6S492C53v32Ev,
  (VTBL_ENTRY)&_ZN6S492C53v33Ev,
  (VTBL_ENTRY)&_ZN6S492C53v34Ev,
  (VTBL_ENTRY)&_ZN6S492C53v35Ev,
  (VTBL_ENTRY)&_ZN6S492C53v36Ev,
  (VTBL_ENTRY)&_ZN6S492C53v37Ev,
  (VTBL_ENTRY)&_ZN6S492C53v38Ev,
  (VTBL_ENTRY)&_ZN6S492C53v39Ev,
  (VTBL_ENTRY)&_ZN6S492C53v40Ev,
  (VTBL_ENTRY)&_ZN6S492C53v41Ev,
  (VTBL_ENTRY)&_ZN6S492C53v42Ev,
  (VTBL_ENTRY)&_ZN6S492C53v43Ev,
  (VTBL_ENTRY)&_ZN6S492C53v44Ev,
  (VTBL_ENTRY)&_ZN6S492C53v45Ev,
  (VTBL_ENTRY)&_ZN6S492C53v46Ev,
  (VTBL_ENTRY)&_ZN6S492C53v47Ev,
  (VTBL_ENTRY)&_ZN6S492C53v48Ev,
  (VTBL_ENTRY)&_ZN6S492C53v49Ev,
  (VTBL_ENTRY)&_ZN6S492C53v50Ev,
  (VTBL_ENTRY)&_ZN6S492C53v51Ev,
  (VTBL_ENTRY)&_ZN6S492C53v52Ev,
  (VTBL_ENTRY)&_ZN6S492C53v53Ev,
  (VTBL_ENTRY)&_ZN6S492C53v54Ev,
  (VTBL_ENTRY)&_ZN6S492C53v55Ev,
  (VTBL_ENTRY)&_ZN6S492C53v56Ev,
  (VTBL_ENTRY)&_ZN6S492C53v57Ev,
  (VTBL_ENTRY)&_ZN6S492C53v58Ev,
  (VTBL_ENTRY)&_ZN6S492C53v59Ev,
  (VTBL_ENTRY)&_ZN6S492C53v60Ev,
  (VTBL_ENTRY)&_ZN6S492C53v61Ev,
  (VTBL_ENTRY)&_ZN6S492C53v62Ev,
  (VTBL_ENTRY)&_ZN6S492C53v63Ev,
  (VTBL_ENTRY)&_ZN6S492C53v64Ev,
  (VTBL_ENTRY)&_ZN6S492C53v65Ev,
  (VTBL_ENTRY)&_ZN6S492C53v66Ev,
  (VTBL_ENTRY)&_ZN6S492C53v67Ev,
  (VTBL_ENTRY)&_ZN6S492C53v68Ev,
  (VTBL_ENTRY)&_ZN6S492C53v69Ev,
  (VTBL_ENTRY)&_ZN6S492C53v70Ev,
  (VTBL_ENTRY)&_ZN6S492C53v71Ev,
  (VTBL_ENTRY)&_ZN6S492C53v72Ev,
  (VTBL_ENTRY)&_ZN6S492C53v73Ev,
  (VTBL_ENTRY)&_ZN6S492C53v74Ev,
  (VTBL_ENTRY)&_ZN6S492C53v75Ev,
  (VTBL_ENTRY)&_ZN6S492C53v76Ev,
  (VTBL_ENTRY)&_ZN6S492C53v77Ev,
  (VTBL_ENTRY)&_ZN6S492C53v78Ev,
  (VTBL_ENTRY)&_ZN6S492C53v79Ev,
  (VTBL_ENTRY)&_ZN6S492C43v80Ev,
  (VTBL_ENTRY)&_ZN6S492C43v81Ev,
  (VTBL_ENTRY)&_ZN6S492C43v82Ev,
  (VTBL_ENTRY)&_ZN6S492C43v83Ev,
  (VTBL_ENTRY)&_ZN6S492C33v84Ev,
  (VTBL_ENTRY)&_ZN6S492C33v85Ev,
  (VTBL_ENTRY)&_ZN6S492C33v86Ev,
  (VTBL_ENTRY)&_ZN6S492C33v87Ev,
  (VTBL_ENTRY)&_ZN6S492C33v88Ev,
  (VTBL_ENTRY)&_ZN6S492C33v89Ev,
  (VTBL_ENTRY)&_ZN6S492C33v90Ev,
  (VTBL_ENTRY)&_ZN6S492C33v91Ev,
  (VTBL_ENTRY)&_ZN6S492C33v92Ev,
  (VTBL_ENTRY)&_ZN6S492C33v93Ev,
  (VTBL_ENTRY)&_ZN6S492C33v94Ev,
  (VTBL_ENTRY)&_ZN6S492C33v95Ev,
  (VTBL_ENTRY)&_ZN6S492C33v96Ev,
  (VTBL_ENTRY)&_ZN6S492C33v97Ev,
  (VTBL_ENTRY)&_ZN6S492C33v98Ev,
  (VTBL_ENTRY)&_ZN6S492C33v99Ev,
  (VTBL_ENTRY)&_ZN6S492C34v100Ev,
  (VTBL_ENTRY)&_ZN6S492C34v101Ev,
  (VTBL_ENTRY)&_ZN6S492C34v102Ev,
  (VTBL_ENTRY)&_ZN6S492C34v103Ev,
  (VTBL_ENTRY)&_ZN6S492C34v104Ev,
  (VTBL_ENTRY)&_ZN6S492C34v105Ev,
  (VTBL_ENTRY)&_ZN6S492C34v106Ev,
  (VTBL_ENTRY)&_ZN6S492C34v107Ev,
  (VTBL_ENTRY)&_ZN6S492C34v108Ev,
  (VTBL_ENTRY)&_ZN6S492C34v109Ev,
  (VTBL_ENTRY)&_ZN6S492C34v110Ev,
  (VTBL_ENTRY)&_ZN6S492C34v111Ev,
  (VTBL_ENTRY)&_ZN6S492C34v112Ev,
  (VTBL_ENTRY)&_ZN6S492C34v113Ev,
  (VTBL_ENTRY)&_ZN6S492C34v114Ev,
  (VTBL_ENTRY)&_ZN6S492C24v115Ev,
  (VTBL_ENTRY)&_ZN6S492C24v116Ev,
  (VTBL_ENTRY)&_ZN6S492C24v117Ev,
  (VTBL_ENTRY)&_ZN6S492C24v118Ev,
  (VTBL_ENTRY)&_ZN6S492C24v119Ev,
  (VTBL_ENTRY)&_ZN6S492C24v120Ev,
  (VTBL_ENTRY)&_ZN6S492C24v121Ev,
  (VTBL_ENTRY)&_ZN6S492C24v122Ev,
  (VTBL_ENTRY)&_ZN6S492C24v123Ev,
  (VTBL_ENTRY)&_ZN6S492C24v124Ev,
  (VTBL_ENTRY)&_ZN6S492C24v125Ev,
  (VTBL_ENTRY)&_ZN6S492C24v126Ev,
  (VTBL_ENTRY)&_ZN6S492C24v127Ev,
  (VTBL_ENTRY)&_ZN6S492C24v128Ev,
  (VTBL_ENTRY)&_ZN6S492C24v129Ev,
  (VTBL_ENTRY)&_ZN6S492C24v130Ev,
  (VTBL_ENTRY)&_ZN6S492C24v131Ev,
  (VTBL_ENTRY)&_ZN6S492C24v132Ev,
  (VTBL_ENTRY)&_ZN6S492C24v133Ev,
  (VTBL_ENTRY)&_ZN6S492C24v134Ev,
  (VTBL_ENTRY)&_ZN6S492C24v135Ev,
  (VTBL_ENTRY)&_ZN6S492C24v136Ev,
  (VTBL_ENTRY)&_ZN6S492C24v137Ev,
  (VTBL_ENTRY)&_ZN6S492C24v138Ev,
  (VTBL_ENTRY)&_ZN6S492C24v139Ev,
  (VTBL_ENTRY)&_ZN6S492C24v140Ev,
  (VTBL_ENTRY)&_ZN6S492C24v141Ev,
  (VTBL_ENTRY)&_ZN6S492C24v142Ev,
  (VTBL_ENTRY)&_ZN6S492C24v143Ev,
  (VTBL_ENTRY)&_ZN6S492C24v144Ev,
  (VTBL_ENTRY)&_ZN6S492C24v145Ev,
  (VTBL_ENTRY)&_ZN6S492C24v146Ev,
  (VTBL_ENTRY)&_ZN6S492C24v147Ev,
  (VTBL_ENTRY)&_ZN6S492C24v148Ev,
  (VTBL_ENTRY)&_ZN6S492C24v149Ev,
  (VTBL_ENTRY)&_ZN6S492C24v150Ev,
  (VTBL_ENTRY)&_ZN6S492C24v151Ev,
};
extern VTBL_ENTRY _ZTI6S492C2[];
extern  VTBL_ENTRY _ZTV6S492C2[];
Class_Descriptor cd_S492C2 = {  "S492C2", // class name
  bases_S492C2, 3,
  &(vtc_S492C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,120), // object size
  NSPAIRA(_ZTI6S492C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S492C2),140, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S492C1  : S492C2 {
  ::S685C34 s492c1f0;
  ::S685C28 s492c1f1;
  ::S685C24 s492c1f2;
  ::S685C19 s492c1f3;
  virtual  ~S492C1(); // _ZN6S492C1D1Ev
  virtual void  v1(); // _ZN6S492C12v1Ev
  virtual void  v2(); // _ZN6S492C12v2Ev
  virtual void  v3(); // _ZN6S492C12v3Ev
  virtual void  v4(); // _ZN6S492C12v4Ev
  virtual void  v5(); // _ZN6S492C12v5Ev
  virtual void  v6(); // _ZN6S492C12v6Ev
  virtual void  v7(); // _ZN6S492C12v7Ev
  virtual void  v8(); // _ZN6S492C12v8Ev
  virtual void  v9(); // _ZN6S492C12v9Ev
  virtual void  v10(); // _ZN6S492C13v10Ev
  virtual void  v11(); // _ZN6S492C13v11Ev
  virtual void  v12(); // _ZN6S492C13v12Ev
  virtual void  v13(); // _ZN6S492C13v13Ev
  virtual void  v14(); // _ZN6S492C13v14Ev
  virtual void  v15(); // _ZN6S492C13v15Ev
  S492C1(); // tgen
};
//SIG(1 S492C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v80 v81 v82 v83} vd v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}}} vd v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 Fp[2] Fi:1 Fi:1 Fi:1 Fp[6] FC11{ BC12{ BC10}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 FC13{ BC14{ BC10}} FC8 FC15{ BC16{ BC10}} FC17{ BC18{ BC10}}}


 S492C1 ::~S492C1(){ note_dtor("S492C1", this);}
void  S492C1 ::v1(){vfunc_called(this, "_ZN6S492C12v1Ev");}
void  S492C1 ::v2(){vfunc_called(this, "_ZN6S492C12v2Ev");}
void  S492C1 ::v3(){vfunc_called(this, "_ZN6S492C12v3Ev");}
void  S492C1 ::v4(){vfunc_called(this, "_ZN6S492C12v4Ev");}
void  S492C1 ::v5(){vfunc_called(this, "_ZN6S492C12v5Ev");}
void  S492C1 ::v6(){vfunc_called(this, "_ZN6S492C12v6Ev");}
void  S492C1 ::v7(){vfunc_called(this, "_ZN6S492C12v7Ev");}
void  S492C1 ::v8(){vfunc_called(this, "_ZN6S492C12v8Ev");}
void  S492C1 ::v9(){vfunc_called(this, "_ZN6S492C12v9Ev");}
void  S492C1 ::v10(){vfunc_called(this, "_ZN6S492C13v10Ev");}
void  S492C1 ::v11(){vfunc_called(this, "_ZN6S492C13v11Ev");}
void  S492C1 ::v12(){vfunc_called(this, "_ZN6S492C13v12Ev");}
void  S492C1 ::v13(){vfunc_called(this, "_ZN6S492C13v13Ev");}
void  S492C1 ::v14(){vfunc_called(this, "_ZN6S492C13v14Ev");}
void  S492C1 ::v15(){vfunc_called(this, "_ZN6S492C13v15Ev");}
S492C1 ::S492C1(){ note_ctor("S492C1", this);} // tgen

static void Test_S492C1()
{
  extern Class_Descriptor cd_S492C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,43)];
    init_test(&cd_S492C1, buf);
    S492C1 *dp, &lv = *(dp=new (buf) S492C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,168), "sizeof(S492C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S492C1)");
    check_base_class_offset(lv, (S492C5*)(S492C4*)(S492C3*)(S492C2*), 0, "S492C1");
    check_base_class_offset(lv, (S492C4*)(S492C3*)(S492C2*), 0, "S492C1");
    check_base_class_offset(lv, (S492C3*)(S492C2*), 0, "S492C1");
    check_base_class_offset(lv, (S492C2*), 0, "S492C1");
    check_field_offset(lv, s492c1f0, ABISELECT(200,120), "S492C1.s492c1f0");
    check_field_offset(lv, s492c1f1, ABISELECT(216,132), "S492C1.s492c1f1");
    check_field_offset(lv, s492c1f2, ABISELECT(232,144), "S492C1.s492c1f2");
    check_field_offset(lv, s492c1f3, ABISELECT(248,156), "S492C1.s492c1f3");
    test_class_info(&lv, &cd_S492C1);
    dp->~S492C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS492C1(Test_S492C1, "S492C1", ABISELECT(264,168));

#else // __cplusplus

extern void _ZN6S492C1C1Ev();
extern void _ZN6S492C1D1Ev();
Name_Map name_map_S492C1[] = {
  NSPAIR(_ZN6S492C1C1Ev),
  NSPAIR(_ZN6S492C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S492C5;
extern VTBL_ENTRY _ZTI6S492C5[];
extern  VTBL_ENTRY _ZTV6S492C5[];
extern Class_Descriptor cd_S492C4;
extern VTBL_ENTRY _ZTI6S492C4[];
extern  VTBL_ENTRY _ZTV6S492C4[];
extern Class_Descriptor cd_S492C3;
extern VTBL_ENTRY _ZTI6S492C3[];
extern  VTBL_ENTRY _ZTV6S492C3[];
extern Class_Descriptor cd_S492C2;
extern VTBL_ENTRY _ZTI6S492C2[];
extern  VTBL_ENTRY _ZTV6S492C2[];
static Base_Class bases_S492C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S492C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S492C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S492C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S492C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S492C1[];
extern void _ZN6S492C1D1Ev();
extern void _ZN6S492C1D0Ev();
extern void _ZN6S492C53v16Ev();
extern void _ZN6S492C53v17Ev();
extern void _ZN6S492C53v18Ev();
extern void _ZN6S492C53v19Ev();
extern void _ZN6S492C53v20Ev();
extern void _ZN6S492C53v21Ev();
extern void _ZN6S492C53v22Ev();
extern void _ZN6S492C53v23Ev();
extern void _ZN6S492C53v24Ev();
extern void _ZN6S492C53v25Ev();
extern void _ZN6S492C53v26Ev();
extern void _ZN6S492C53v27Ev();
extern void _ZN6S492C53v28Ev();
extern void _ZN6S492C53v29Ev();
extern void _ZN6S492C53v30Ev();
extern void _ZN6S492C53v31Ev();
extern void _ZN6S492C53v32Ev();
extern void _ZN6S492C53v33Ev();
extern void _ZN6S492C53v34Ev();
extern void _ZN6S492C53v35Ev();
extern void _ZN6S492C53v36Ev();
extern void _ZN6S492C53v37Ev();
extern void _ZN6S492C53v38Ev();
extern void _ZN6S492C53v39Ev();
extern void _ZN6S492C53v40Ev();
extern void _ZN6S492C53v41Ev();
extern void _ZN6S492C53v42Ev();
extern void _ZN6S492C53v43Ev();
extern void _ZN6S492C53v44Ev();
extern void _ZN6S492C53v45Ev();
extern void _ZN6S492C53v46Ev();
extern void _ZN6S492C53v47Ev();
extern void _ZN6S492C53v48Ev();
extern void _ZN6S492C53v49Ev();
extern void _ZN6S492C53v50Ev();
extern void _ZN6S492C53v51Ev();
extern void _ZN6S492C53v52Ev();
extern void _ZN6S492C53v53Ev();
extern void _ZN6S492C53v54Ev();
extern void _ZN6S492C53v55Ev();
extern void _ZN6S492C53v56Ev();
extern void _ZN6S492C53v57Ev();
extern void _ZN6S492C53v58Ev();
extern void _ZN6S492C53v59Ev();
extern void _ZN6S492C53v60Ev();
extern void _ZN6S492C53v61Ev();
extern void _ZN6S492C53v62Ev();
extern void _ZN6S492C53v63Ev();
extern void _ZN6S492C53v64Ev();
extern void _ZN6S492C53v65Ev();
extern void _ZN6S492C53v66Ev();
extern void _ZN6S492C53v67Ev();
extern void _ZN6S492C53v68Ev();
extern void _ZN6S492C53v69Ev();
extern void _ZN6S492C53v70Ev();
extern void _ZN6S492C53v71Ev();
extern void _ZN6S492C53v72Ev();
extern void _ZN6S492C53v73Ev();
extern void _ZN6S492C53v74Ev();
extern void _ZN6S492C53v75Ev();
extern void _ZN6S492C53v76Ev();
extern void _ZN6S492C53v77Ev();
extern void _ZN6S492C53v78Ev();
extern void _ZN6S492C53v79Ev();
extern void _ZN6S492C43v80Ev();
extern void _ZN6S492C43v81Ev();
extern void _ZN6S492C43v82Ev();
extern void _ZN6S492C43v83Ev();
extern void _ZN6S492C33v84Ev();
extern void _ZN6S492C33v85Ev();
extern void _ZN6S492C33v86Ev();
extern void _ZN6S492C33v87Ev();
extern void _ZN6S492C33v88Ev();
extern void _ZN6S492C33v89Ev();
extern void _ZN6S492C33v90Ev();
extern void _ZN6S492C33v91Ev();
extern void _ZN6S492C33v92Ev();
extern void _ZN6S492C33v93Ev();
extern void _ZN6S492C33v94Ev();
extern void _ZN6S492C33v95Ev();
extern void _ZN6S492C33v96Ev();
extern void _ZN6S492C33v97Ev();
extern void _ZN6S492C33v98Ev();
extern void _ZN6S492C33v99Ev();
extern void _ZN6S492C34v100Ev();
extern void _ZN6S492C34v101Ev();
extern void _ZN6S492C34v102Ev();
extern void _ZN6S492C34v103Ev();
extern void _ZN6S492C34v104Ev();
extern void _ZN6S492C34v105Ev();
extern void _ZN6S492C34v106Ev();
extern void _ZN6S492C34v107Ev();
extern void _ZN6S492C34v108Ev();
extern void _ZN6S492C34v109Ev();
extern void _ZN6S492C34v110Ev();
extern void _ZN6S492C34v111Ev();
extern void _ZN6S492C34v112Ev();
extern void _ZN6S492C34v113Ev();
extern void _ZN6S492C34v114Ev();
extern void _ZN6S492C24v115Ev();
extern void _ZN6S492C24v116Ev();
extern void _ZN6S492C24v117Ev();
extern void _ZN6S492C24v118Ev();
extern void _ZN6S492C24v119Ev();
extern void _ZN6S492C24v120Ev();
extern void _ZN6S492C24v121Ev();
extern void _ZN6S492C24v122Ev();
extern void _ZN6S492C24v123Ev();
extern void _ZN6S492C24v124Ev();
extern void _ZN6S492C24v125Ev();
extern void _ZN6S492C24v126Ev();
extern void _ZN6S492C24v127Ev();
extern void _ZN6S492C24v128Ev();
extern void _ZN6S492C24v129Ev();
extern void _ZN6S492C24v130Ev();
extern void _ZN6S492C24v131Ev();
extern void _ZN6S492C24v132Ev();
extern void _ZN6S492C24v133Ev();
extern void _ZN6S492C24v134Ev();
extern void _ZN6S492C24v135Ev();
extern void _ZN6S492C24v136Ev();
extern void _ZN6S492C24v137Ev();
extern void _ZN6S492C24v138Ev();
extern void _ZN6S492C24v139Ev();
extern void _ZN6S492C24v140Ev();
extern void _ZN6S492C24v141Ev();
extern void _ZN6S492C24v142Ev();
extern void _ZN6S492C24v143Ev();
extern void _ZN6S492C24v144Ev();
extern void _ZN6S492C24v145Ev();
extern void _ZN6S492C24v146Ev();
extern void _ZN6S492C24v147Ev();
extern void _ZN6S492C24v148Ev();
extern void _ZN6S492C24v149Ev();
extern void _ZN6S492C24v150Ev();
extern void _ZN6S492C24v151Ev();
extern void _ZN6S492C12v1Ev();
extern void _ZN6S492C12v2Ev();
extern void _ZN6S492C12v3Ev();
extern void _ZN6S492C12v4Ev();
extern void _ZN6S492C12v5Ev();
extern void _ZN6S492C12v6Ev();
extern void _ZN6S492C12v7Ev();
extern void _ZN6S492C12v8Ev();
extern void _ZN6S492C12v9Ev();
extern void _ZN6S492C13v10Ev();
extern void _ZN6S492C13v11Ev();
extern void _ZN6S492C13v12Ev();
extern void _ZN6S492C13v13Ev();
extern void _ZN6S492C13v14Ev();
extern void _ZN6S492C13v15Ev();
static  VTBL_ENTRY vtc_S492C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S492C1[0]),
  (VTBL_ENTRY)&_ZN6S492C1D1Ev,
  (VTBL_ENTRY)&_ZN6S492C1D0Ev,
  (VTBL_ENTRY)&_ZN6S492C53v16Ev,
  (VTBL_ENTRY)&_ZN6S492C53v17Ev,
  (VTBL_ENTRY)&_ZN6S492C53v18Ev,
  (VTBL_ENTRY)&_ZN6S492C53v19Ev,
  (VTBL_ENTRY)&_ZN6S492C53v20Ev,
  (VTBL_ENTRY)&_ZN6S492C53v21Ev,
  (VTBL_ENTRY)&_ZN6S492C53v22Ev,
  (VTBL_ENTRY)&_ZN6S492C53v23Ev,
  (VTBL_ENTRY)&_ZN6S492C53v24Ev,
  (VTBL_ENTRY)&_ZN6S492C53v25Ev,
  (VTBL_ENTRY)&_ZN6S492C53v26Ev,
  (VTBL_ENTRY)&_ZN6S492C53v27Ev,
  (VTBL_ENTRY)&_ZN6S492C53v28Ev,
  (VTBL_ENTRY)&_ZN6S492C53v29Ev,
  (VTBL_ENTRY)&_ZN6S492C53v30Ev,
  (VTBL_ENTRY)&_ZN6S492C53v31Ev,
  (VTBL_ENTRY)&_ZN6S492C53v32Ev,
  (VTBL_ENTRY)&_ZN6S492C53v33Ev,
  (VTBL_ENTRY)&_ZN6S492C53v34Ev,
  (VTBL_ENTRY)&_ZN6S492C53v35Ev,
  (VTBL_ENTRY)&_ZN6S492C53v36Ev,
  (VTBL_ENTRY)&_ZN6S492C53v37Ev,
  (VTBL_ENTRY)&_ZN6S492C53v38Ev,
  (VTBL_ENTRY)&_ZN6S492C53v39Ev,
  (VTBL_ENTRY)&_ZN6S492C53v40Ev,
  (VTBL_ENTRY)&_ZN6S492C53v41Ev,
  (VTBL_ENTRY)&_ZN6S492C53v42Ev,
  (VTBL_ENTRY)&_ZN6S492C53v43Ev,
  (VTBL_ENTRY)&_ZN6S492C53v44Ev,
  (VTBL_ENTRY)&_ZN6S492C53v45Ev,
  (VTBL_ENTRY)&_ZN6S492C53v46Ev,
  (VTBL_ENTRY)&_ZN6S492C53v47Ev,
  (VTBL_ENTRY)&_ZN6S492C53v48Ev,
  (VTBL_ENTRY)&_ZN6S492C53v49Ev,
  (VTBL_ENTRY)&_ZN6S492C53v50Ev,
  (VTBL_ENTRY)&_ZN6S492C53v51Ev,
  (VTBL_ENTRY)&_ZN6S492C53v52Ev,
  (VTBL_ENTRY)&_ZN6S492C53v53Ev,
  (VTBL_ENTRY)&_ZN6S492C53v54Ev,
  (VTBL_ENTRY)&_ZN6S492C53v55Ev,
  (VTBL_ENTRY)&_ZN6S492C53v56Ev,
  (VTBL_ENTRY)&_ZN6S492C53v57Ev,
  (VTBL_ENTRY)&_ZN6S492C53v58Ev,
  (VTBL_ENTRY)&_ZN6S492C53v59Ev,
  (VTBL_ENTRY)&_ZN6S492C53v60Ev,
  (VTBL_ENTRY)&_ZN6S492C53v61Ev,
  (VTBL_ENTRY)&_ZN6S492C53v62Ev,
  (VTBL_ENTRY)&_ZN6S492C53v63Ev,
  (VTBL_ENTRY)&_ZN6S492C53v64Ev,
  (VTBL_ENTRY)&_ZN6S492C53v65Ev,
  (VTBL_ENTRY)&_ZN6S492C53v66Ev,
  (VTBL_ENTRY)&_ZN6S492C53v67Ev,
  (VTBL_ENTRY)&_ZN6S492C53v68Ev,
  (VTBL_ENTRY)&_ZN6S492C53v69Ev,
  (VTBL_ENTRY)&_ZN6S492C53v70Ev,
  (VTBL_ENTRY)&_ZN6S492C53v71Ev,
  (VTBL_ENTRY)&_ZN6S492C53v72Ev,
  (VTBL_ENTRY)&_ZN6S492C53v73Ev,
  (VTBL_ENTRY)&_ZN6S492C53v74Ev,
  (VTBL_ENTRY)&_ZN6S492C53v75Ev,
  (VTBL_ENTRY)&_ZN6S492C53v76Ev,
  (VTBL_ENTRY)&_ZN6S492C53v77Ev,
  (VTBL_ENTRY)&_ZN6S492C53v78Ev,
  (VTBL_ENTRY)&_ZN6S492C53v79Ev,
  (VTBL_ENTRY)&_ZN6S492C43v80Ev,
  (VTBL_ENTRY)&_ZN6S492C43v81Ev,
  (VTBL_ENTRY)&_ZN6S492C43v82Ev,
  (VTBL_ENTRY)&_ZN6S492C43v83Ev,
  (VTBL_ENTRY)&_ZN6S492C33v84Ev,
  (VTBL_ENTRY)&_ZN6S492C33v85Ev,
  (VTBL_ENTRY)&_ZN6S492C33v86Ev,
  (VTBL_ENTRY)&_ZN6S492C33v87Ev,
  (VTBL_ENTRY)&_ZN6S492C33v88Ev,
  (VTBL_ENTRY)&_ZN6S492C33v89Ev,
  (VTBL_ENTRY)&_ZN6S492C33v90Ev,
  (VTBL_ENTRY)&_ZN6S492C33v91Ev,
  (VTBL_ENTRY)&_ZN6S492C33v92Ev,
  (VTBL_ENTRY)&_ZN6S492C33v93Ev,
  (VTBL_ENTRY)&_ZN6S492C33v94Ev,
  (VTBL_ENTRY)&_ZN6S492C33v95Ev,
  (VTBL_ENTRY)&_ZN6S492C33v96Ev,
  (VTBL_ENTRY)&_ZN6S492C33v97Ev,
  (VTBL_ENTRY)&_ZN6S492C33v98Ev,
  (VTBL_ENTRY)&_ZN6S492C33v99Ev,
  (VTBL_ENTRY)&_ZN6S492C34v100Ev,
  (VTBL_ENTRY)&_ZN6S492C34v101Ev,
  (VTBL_ENTRY)&_ZN6S492C34v102Ev,
  (VTBL_ENTRY)&_ZN6S492C34v103Ev,
  (VTBL_ENTRY)&_ZN6S492C34v104Ev,
  (VTBL_ENTRY)&_ZN6S492C34v105Ev,
  (VTBL_ENTRY)&_ZN6S492C34v106Ev,
  (VTBL_ENTRY)&_ZN6S492C34v107Ev,
  (VTBL_ENTRY)&_ZN6S492C34v108Ev,
  (VTBL_ENTRY)&_ZN6S492C34v109Ev,
  (VTBL_ENTRY)&_ZN6S492C34v110Ev,
  (VTBL_ENTRY)&_ZN6S492C34v111Ev,
  (VTBL_ENTRY)&_ZN6S492C34v112Ev,
  (VTBL_ENTRY)&_ZN6S492C34v113Ev,
  (VTBL_ENTRY)&_ZN6S492C34v114Ev,
  (VTBL_ENTRY)&_ZN6S492C24v115Ev,
  (VTBL_ENTRY)&_ZN6S492C24v116Ev,
  (VTBL_ENTRY)&_ZN6S492C24v117Ev,
  (VTBL_ENTRY)&_ZN6S492C24v118Ev,
  (VTBL_ENTRY)&_ZN6S492C24v119Ev,
  (VTBL_ENTRY)&_ZN6S492C24v120Ev,
  (VTBL_ENTRY)&_ZN6S492C24v121Ev,
  (VTBL_ENTRY)&_ZN6S492C24v122Ev,
  (VTBL_ENTRY)&_ZN6S492C24v123Ev,
  (VTBL_ENTRY)&_ZN6S492C24v124Ev,
  (VTBL_ENTRY)&_ZN6S492C24v125Ev,
  (VTBL_ENTRY)&_ZN6S492C24v126Ev,
  (VTBL_ENTRY)&_ZN6S492C24v127Ev,
  (VTBL_ENTRY)&_ZN6S492C24v128Ev,
  (VTBL_ENTRY)&_ZN6S492C24v129Ev,
  (VTBL_ENTRY)&_ZN6S492C24v130Ev,
  (VTBL_ENTRY)&_ZN6S492C24v131Ev,
  (VTBL_ENTRY)&_ZN6S492C24v132Ev,
  (VTBL_ENTRY)&_ZN6S492C24v133Ev,
  (VTBL_ENTRY)&_ZN6S492C24v134Ev,
  (VTBL_ENTRY)&_ZN6S492C24v135Ev,
  (VTBL_ENTRY)&_ZN6S492C24v136Ev,
  (VTBL_ENTRY)&_ZN6S492C24v137Ev,
  (VTBL_ENTRY)&_ZN6S492C24v138Ev,
  (VTBL_ENTRY)&_ZN6S492C24v139Ev,
  (VTBL_ENTRY)&_ZN6S492C24v140Ev,
  (VTBL_ENTRY)&_ZN6S492C24v141Ev,
  (VTBL_ENTRY)&_ZN6S492C24v142Ev,
  (VTBL_ENTRY)&_ZN6S492C24v143Ev,
  (VTBL_ENTRY)&_ZN6S492C24v144Ev,
  (VTBL_ENTRY)&_ZN6S492C24v145Ev,
  (VTBL_ENTRY)&_ZN6S492C24v146Ev,
  (VTBL_ENTRY)&_ZN6S492C24v147Ev,
  (VTBL_ENTRY)&_ZN6S492C24v148Ev,
  (VTBL_ENTRY)&_ZN6S492C24v149Ev,
  (VTBL_ENTRY)&_ZN6S492C24v150Ev,
  (VTBL_ENTRY)&_ZN6S492C24v151Ev,
  (VTBL_ENTRY)&_ZN6S492C12v1Ev,
  (VTBL_ENTRY)&_ZN6S492C12v2Ev,
  (VTBL_ENTRY)&_ZN6S492C12v3Ev,
  (VTBL_ENTRY)&_ZN6S492C12v4Ev,
  (VTBL_ENTRY)&_ZN6S492C12v5Ev,
  (VTBL_ENTRY)&_ZN6S492C12v6Ev,
  (VTBL_ENTRY)&_ZN6S492C12v7Ev,
  (VTBL_ENTRY)&_ZN6S492C12v8Ev,
  (VTBL_ENTRY)&_ZN6S492C12v9Ev,
  (VTBL_ENTRY)&_ZN6S492C13v10Ev,
  (VTBL_ENTRY)&_ZN6S492C13v11Ev,
  (VTBL_ENTRY)&_ZN6S492C13v12Ev,
  (VTBL_ENTRY)&_ZN6S492C13v13Ev,
  (VTBL_ENTRY)&_ZN6S492C13v14Ev,
  (VTBL_ENTRY)&_ZN6S492C13v15Ev,
};
extern VTBL_ENTRY _ZTI6S492C1[];
extern  VTBL_ENTRY _ZTV6S492C1[];
Class_Descriptor cd_S492C1 = {  "S492C1", // class name
  bases_S492C1, 4,
  &(vtc_S492C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,168), // object size
  NSPAIRA(_ZTI6S492C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S492C1),155, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S696C5  {
  int s696c5f0;
  __tsi64 s696c5f1;
  void *s696c5f2[4];
  int s696c5f3[2];
  void *s696c5f4;
  ::S695C22_nt s696c5f5;
  void *s696c5f6[2];
  virtual  ~S696C5(); // _ZN6S696C5D1Ev
  virtual void  v7(); // _ZN6S696C52v7Ev
  virtual void  v8(); // _ZN6S696C52v8Ev
  virtual void  v9(); // _ZN6S696C52v9Ev
  virtual void  v10(); // _ZN6S696C53v10Ev
  virtual void  v11(); // _ZN6S696C53v11Ev
  virtual void  v12(); // _ZN6S696C53v12Ev
  virtual void  v13(); // _ZN6S696C53v13Ev
  virtual void  v14(); // _ZN6S696C53v14Ev
  virtual void  v15(); // _ZN6S696C53v15Ev
  virtual void  v16(); // _ZN6S696C53v16Ev
  virtual void  v17(); // _ZN6S696C53v17Ev
  virtual void  v18(); // _ZN6S696C53v18Ev
  virtual void  v19(); // _ZN6S696C53v19Ev
  virtual void  v20(); // _ZN6S696C53v20Ev
  virtual void  v21(); // _ZN6S696C53v21Ev
  virtual void  v22(); // _ZN6S696C53v22Ev
  virtual void  v23(); // _ZN6S696C53v23Ev
  virtual void  v24(); // _ZN6S696C53v24Ev
  virtual void  v25(); // _ZN6S696C53v25Ev
  virtual void  v26(); // _ZN6S696C53v26Ev
  virtual void  v27(); // _ZN6S696C53v27Ev
  virtual void  v28(); // _ZN6S696C53v28Ev
  virtual void  v29(); // _ZN6S696C53v29Ev
  virtual void  v30(); // _ZN6S696C53v30Ev
  virtual void  v31(); // _ZN6S696C53v31Ev
  virtual void  v32(); // _ZN6S696C53v32Ev
  virtual void  v33(); // _ZN6S696C53v33Ev
  virtual void  v34(); // _ZN6S696C53v34Ev
  virtual void  v35(); // _ZN6S696C53v35Ev
  virtual void  v36(); // _ZN6S696C53v36Ev
  virtual void  v37(); // _ZN6S696C53v37Ev
  virtual void  v38(); // _ZN6S696C53v38Ev
  virtual void  v39(); // _ZN6S696C53v39Ev
  virtual void  v40(); // _ZN6S696C53v40Ev
  virtual void  v41(); // _ZN6S696C53v41Ev
  virtual void  v42(); // _ZN6S696C53v42Ev
  virtual void  v43(); // _ZN6S696C53v43Ev
  virtual void  v44(); // _ZN6S696C53v44Ev
  virtual void  v45(); // _ZN6S696C53v45Ev
  virtual void  v46(); // _ZN6S696C53v46Ev
  virtual void  v47(); // _ZN6S696C53v47Ev
  virtual void  v48(); // _ZN6S696C53v48Ev
  virtual void  v49(); // _ZN6S696C53v49Ev
  virtual void  v50(); // _ZN6S696C53v50Ev
  virtual void  v51(); // _ZN6S696C53v51Ev
  virtual void  v52(); // _ZN6S696C53v52Ev
  virtual void  v53(); // _ZN6S696C53v53Ev
  virtual void  v54(); // _ZN6S696C53v54Ev
  virtual void  v55(); // _ZN6S696C53v55Ev
  virtual void  v56(); // _ZN6S696C53v56Ev
  virtual void  v57(); // _ZN6S696C53v57Ev
  virtual void  v58(); // _ZN6S696C53v58Ev
  virtual void  v59(); // _ZN6S696C53v59Ev
  virtual void  v60(); // _ZN6S696C53v60Ev
  virtual void  v61(); // _ZN6S696C53v61Ev
  virtual void  v62(); // _ZN6S696C53v62Ev
  virtual void  v63(); // _ZN6S696C53v63Ev
  virtual void  v64(); // _ZN6S696C53v64Ev
  virtual void  v65(); // _ZN6S696C53v65Ev
  virtual void  v66(); // _ZN6S696C53v66Ev
  virtual void  v67(); // _ZN6S696C53v67Ev
  virtual void  v68(); // _ZN6S696C53v68Ev
  virtual void  v69(); // _ZN6S696C53v69Ev
  virtual void  v70(); // _ZN6S696C53v70Ev
  S696C5(); // tgen
};
//SIG(-1 S696C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S696C5 ::~S696C5(){ note_dtor("S696C5", this);}
void  S696C5 ::v7(){vfunc_called(this, "_ZN6S696C52v7Ev");}
void  S696C5 ::v8(){vfunc_called(this, "_ZN6S696C52v8Ev");}
void  S696C5 ::v9(){vfunc_called(this, "_ZN6S696C52v9Ev");}
void  S696C5 ::v10(){vfunc_called(this, "_ZN6S696C53v10Ev");}
void  S696C5 ::v11(){vfunc_called(this, "_ZN6S696C53v11Ev");}
void  S696C5 ::v12(){vfunc_called(this, "_ZN6S696C53v12Ev");}
void  S696C5 ::v13(){vfunc_called(this, "_ZN6S696C53v13Ev");}
void  S696C5 ::v14(){vfunc_called(this, "_ZN6S696C53v14Ev");}
void  S696C5 ::v15(){vfunc_called(this, "_ZN6S696C53v15Ev");}
void  S696C5 ::v16(){vfunc_called(this, "_ZN6S696C53v16Ev");}
void  S696C5 ::v17(){vfunc_called(this, "_ZN6S696C53v17Ev");}
void  S696C5 ::v18(){vfunc_called(this, "_ZN6S696C53v18Ev");}
void  S696C5 ::v19(){vfunc_called(this, "_ZN6S696C53v19Ev");}
void  S696C5 ::v20(){vfunc_called(this, "_ZN6S696C53v20Ev");}
void  S696C5 ::v21(){vfunc_called(this, "_ZN6S696C53v21Ev");}
void  S696C5 ::v22(){vfunc_called(this, "_ZN6S696C53v22Ev");}
void  S696C5 ::v23(){vfunc_called(this, "_ZN6S696C53v23Ev");}
void  S696C5 ::v24(){vfunc_called(this, "_ZN6S696C53v24Ev");}
void  S696C5 ::v25(){vfunc_called(this, "_ZN6S696C53v25Ev");}
void  S696C5 ::v26(){vfunc_called(this, "_ZN6S696C53v26Ev");}
void  S696C5 ::v27(){vfunc_called(this, "_ZN6S696C53v27Ev");}
void  S696C5 ::v28(){vfunc_called(this, "_ZN6S696C53v28Ev");}
void  S696C5 ::v29(){vfunc_called(this, "_ZN6S696C53v29Ev");}
void  S696C5 ::v30(){vfunc_called(this, "_ZN6S696C53v30Ev");}
void  S696C5 ::v31(){vfunc_called(this, "_ZN6S696C53v31Ev");}
void  S696C5 ::v32(){vfunc_called(this, "_ZN6S696C53v32Ev");}
void  S696C5 ::v33(){vfunc_called(this, "_ZN6S696C53v33Ev");}
void  S696C5 ::v34(){vfunc_called(this, "_ZN6S696C53v34Ev");}
void  S696C5 ::v35(){vfunc_called(this, "_ZN6S696C53v35Ev");}
void  S696C5 ::v36(){vfunc_called(this, "_ZN6S696C53v36Ev");}
void  S696C5 ::v37(){vfunc_called(this, "_ZN6S696C53v37Ev");}
void  S696C5 ::v38(){vfunc_called(this, "_ZN6S696C53v38Ev");}
void  S696C5 ::v39(){vfunc_called(this, "_ZN6S696C53v39Ev");}
void  S696C5 ::v40(){vfunc_called(this, "_ZN6S696C53v40Ev");}
void  S696C5 ::v41(){vfunc_called(this, "_ZN6S696C53v41Ev");}
void  S696C5 ::v42(){vfunc_called(this, "_ZN6S696C53v42Ev");}
void  S696C5 ::v43(){vfunc_called(this, "_ZN6S696C53v43Ev");}
void  S696C5 ::v44(){vfunc_called(this, "_ZN6S696C53v44Ev");}
void  S696C5 ::v45(){vfunc_called(this, "_ZN6S696C53v45Ev");}
void  S696C5 ::v46(){vfunc_called(this, "_ZN6S696C53v46Ev");}
void  S696C5 ::v47(){vfunc_called(this, "_ZN6S696C53v47Ev");}
void  S696C5 ::v48(){vfunc_called(this, "_ZN6S696C53v48Ev");}
void  S696C5 ::v49(){vfunc_called(this, "_ZN6S696C53v49Ev");}
void  S696C5 ::v50(){vfunc_called(this, "_ZN6S696C53v50Ev");}
void  S696C5 ::v51(){vfunc_called(this, "_ZN6S696C53v51Ev");}
void  S696C5 ::v52(){vfunc_called(this, "_ZN6S696C53v52Ev");}
void  S696C5 ::v53(){vfunc_called(this, "_ZN6S696C53v53Ev");}
void  S696C5 ::v54(){vfunc_called(this, "_ZN6S696C53v54Ev");}
void  S696C5 ::v55(){vfunc_called(this, "_ZN6S696C53v55Ev");}
void  S696C5 ::v56(){vfunc_called(this, "_ZN6S696C53v56Ev");}
void  S696C5 ::v57(){vfunc_called(this, "_ZN6S696C53v57Ev");}
void  S696C5 ::v58(){vfunc_called(this, "_ZN6S696C53v58Ev");}
void  S696C5 ::v59(){vfunc_called(this, "_ZN6S696C53v59Ev");}
void  S696C5 ::v60(){vfunc_called(this, "_ZN6S696C53v60Ev");}
void  S696C5 ::v61(){vfunc_called(this, "_ZN6S696C53v61Ev");}
void  S696C5 ::v62(){vfunc_called(this, "_ZN6S696C53v62Ev");}
void  S696C5 ::v63(){vfunc_called(this, "_ZN6S696C53v63Ev");}
void  S696C5 ::v64(){vfunc_called(this, "_ZN6S696C53v64Ev");}
void  S696C5 ::v65(){vfunc_called(this, "_ZN6S696C53v65Ev");}
void  S696C5 ::v66(){vfunc_called(this, "_ZN6S696C53v66Ev");}
void  S696C5 ::v67(){vfunc_called(this, "_ZN6S696C53v67Ev");}
void  S696C5 ::v68(){vfunc_called(this, "_ZN6S696C53v68Ev");}
void  S696C5 ::v69(){vfunc_called(this, "_ZN6S696C53v69Ev");}
void  S696C5 ::v70(){vfunc_called(this, "_ZN6S696C53v70Ev");}
S696C5 ::S696C5(){ note_ctor("S696C5", this);} // tgen

static void Test_S696C5()
{
  extern Class_Descriptor cd_S696C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S696C5, buf);
    S696C5 *dp, &lv = *(dp=new (buf) S696C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S696C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S696C5)");
    check_field_offset(lv, s696c5f0, ABISELECT(8,4), "S696C5.s696c5f0");
    check_field_offset(lv, s696c5f1, ABISELECT(16,8), "S696C5.s696c5f1");
    check_field_offset(lv, s696c5f2, ABISELECT(24,16), "S696C5.s696c5f2");
    check_field_offset(lv, s696c5f3, ABISELECT(56,32), "S696C5.s696c5f3");
    check_field_offset(lv, s696c5f4, ABISELECT(64,40), "S696C5.s696c5f4");
    check_field_offset(lv, s696c5f5, ABISELECT(72,44), "S696C5.s696c5f5");
    check_field_offset(lv, s696c5f6, ABISELECT(80,52), "S696C5.s696c5f6");
    test_class_info(&lv, &cd_S696C5);
    dp->~S696C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS696C5(Test_S696C5, "S696C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S696C5C1Ev();
extern void _ZN6S696C5D1Ev();
Name_Map name_map_S696C5[] = {
  NSPAIR(_ZN6S696C5C1Ev),
  NSPAIR(_ZN6S696C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S696C5[];
extern void _ZN6S696C5D1Ev();
extern void _ZN6S696C5D0Ev();
extern void _ZN6S696C52v7Ev();
extern void _ZN6S696C52v8Ev();
extern void _ZN6S696C52v9Ev();
extern void _ZN6S696C53v10Ev();
extern void _ZN6S696C53v11Ev();
extern void _ZN6S696C53v12Ev();
extern void _ZN6S696C53v13Ev();
extern void _ZN6S696C53v14Ev();
extern void _ZN6S696C53v15Ev();
extern void _ZN6S696C53v16Ev();
extern void _ZN6S696C53v17Ev();
extern void _ZN6S696C53v18Ev();
extern void _ZN6S696C53v19Ev();
extern void _ZN6S696C53v20Ev();
extern void _ZN6S696C53v21Ev();
extern void _ZN6S696C53v22Ev();
extern void _ZN6S696C53v23Ev();
extern void _ZN6S696C53v24Ev();
extern void _ZN6S696C53v25Ev();
extern void _ZN6S696C53v26Ev();
extern void _ZN6S696C53v27Ev();
extern void _ZN6S696C53v28Ev();
extern void _ZN6S696C53v29Ev();
extern void _ZN6S696C53v30Ev();
extern void _ZN6S696C53v31Ev();
extern void _ZN6S696C53v32Ev();
extern void _ZN6S696C53v33Ev();
extern void _ZN6S696C53v34Ev();
extern void _ZN6S696C53v35Ev();
extern void _ZN6S696C53v36Ev();
extern void _ZN6S696C53v37Ev();
extern void _ZN6S696C53v38Ev();
extern void _ZN6S696C53v39Ev();
extern void _ZN6S696C53v40Ev();
extern void _ZN6S696C53v41Ev();
extern void _ZN6S696C53v42Ev();
extern void _ZN6S696C53v43Ev();
extern void _ZN6S696C53v44Ev();
extern void _ZN6S696C53v45Ev();
extern void _ZN6S696C53v46Ev();
extern void _ZN6S696C53v47Ev();
extern void _ZN6S696C53v48Ev();
extern void _ZN6S696C53v49Ev();
extern void _ZN6S696C53v50Ev();
extern void _ZN6S696C53v51Ev();
extern void _ZN6S696C53v52Ev();
extern void _ZN6S696C53v53Ev();
extern void _ZN6S696C53v54Ev();
extern void _ZN6S696C53v55Ev();
extern void _ZN6S696C53v56Ev();
extern void _ZN6S696C53v57Ev();
extern void _ZN6S696C53v58Ev();
extern void _ZN6S696C53v59Ev();
extern void _ZN6S696C53v60Ev();
extern void _ZN6S696C53v61Ev();
extern void _ZN6S696C53v62Ev();
extern void _ZN6S696C53v63Ev();
extern void _ZN6S696C53v64Ev();
extern void _ZN6S696C53v65Ev();
extern void _ZN6S696C53v66Ev();
extern void _ZN6S696C53v67Ev();
extern void _ZN6S696C53v68Ev();
extern void _ZN6S696C53v69Ev();
extern void _ZN6S696C53v70Ev();
static  VTBL_ENTRY vtc_S696C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S696C5[0]),
  (VTBL_ENTRY)&_ZN6S696C5D1Ev,
  (VTBL_ENTRY)&_ZN6S696C5D0Ev,
  (VTBL_ENTRY)&_ZN6S696C52v7Ev,
  (VTBL_ENTRY)&_ZN6S696C52v8Ev,
  (VTBL_ENTRY)&_ZN6S696C52v9Ev,
  (VTBL_ENTRY)&_ZN6S696C53v10Ev,
  (VTBL_ENTRY)&_ZN6S696C53v11Ev,
  (VTBL_ENTRY)&_ZN6S696C53v12Ev,
  (VTBL_ENTRY)&_ZN6S696C53v13Ev,
  (VTBL_ENTRY)&_ZN6S696C53v14Ev,
  (VTBL_ENTRY)&_ZN6S696C53v15Ev,
  (VTBL_ENTRY)&_ZN6S696C53v16Ev,
  (VTBL_ENTRY)&_ZN6S696C53v17Ev,
  (VTBL_ENTRY)&_ZN6S696C53v18Ev,
  (VTBL_ENTRY)&_ZN6S696C53v19Ev,
  (VTBL_ENTRY)&_ZN6S696C53v20Ev,
  (VTBL_ENTRY)&_ZN6S696C53v21Ev,
  (VTBL_ENTRY)&_ZN6S696C53v22Ev,
  (VTBL_ENTRY)&_ZN6S696C53v23Ev,
  (VTBL_ENTRY)&_ZN6S696C53v24Ev,
  (VTBL_ENTRY)&_ZN6S696C53v25Ev,
  (VTBL_ENTRY)&_ZN6S696C53v26Ev,
  (VTBL_ENTRY)&_ZN6S696C53v27Ev,
  (VTBL_ENTRY)&_ZN6S696C53v28Ev,
  (VTBL_ENTRY)&_ZN6S696C53v29Ev,
  (VTBL_ENTRY)&_ZN6S696C53v30Ev,
  (VTBL_ENTRY)&_ZN6S696C53v31Ev,
  (VTBL_ENTRY)&_ZN6S696C53v32Ev,
  (VTBL_ENTRY)&_ZN6S696C53v33Ev,
  (VTBL_ENTRY)&_ZN6S696C53v34Ev,
  (VTBL_ENTRY)&_ZN6S696C53v35Ev,
  (VTBL_ENTRY)&_ZN6S696C53v36Ev,
  (VTBL_ENTRY)&_ZN6S696C53v37Ev,
  (VTBL_ENTRY)&_ZN6S696C53v38Ev,
  (VTBL_ENTRY)&_ZN6S696C53v39Ev,
  (VTBL_ENTRY)&_ZN6S696C53v40Ev,
  (VTBL_ENTRY)&_ZN6S696C53v41Ev,
  (VTBL_ENTRY)&_ZN6S696C53v42Ev,
  (VTBL_ENTRY)&_ZN6S696C53v43Ev,
  (VTBL_ENTRY)&_ZN6S696C53v44Ev,
  (VTBL_ENTRY)&_ZN6S696C53v45Ev,
  (VTBL_ENTRY)&_ZN6S696C53v46Ev,
  (VTBL_ENTRY)&_ZN6S696C53v47Ev,
  (VTBL_ENTRY)&_ZN6S696C53v48Ev,
  (VTBL_ENTRY)&_ZN6S696C53v49Ev,
  (VTBL_ENTRY)&_ZN6S696C53v50Ev,
  (VTBL_ENTRY)&_ZN6S696C53v51Ev,
  (VTBL_ENTRY)&_ZN6S696C53v52Ev,
  (VTBL_ENTRY)&_ZN6S696C53v53Ev,
  (VTBL_ENTRY)&_ZN6S696C53v54Ev,
  (VTBL_ENTRY)&_ZN6S696C53v55Ev,
  (VTBL_ENTRY)&_ZN6S696C53v56Ev,
  (VTBL_ENTRY)&_ZN6S696C53v57Ev,
  (VTBL_ENTRY)&_ZN6S696C53v58Ev,
  (VTBL_ENTRY)&_ZN6S696C53v59Ev,
  (VTBL_ENTRY)&_ZN6S696C53v60Ev,
  (VTBL_ENTRY)&_ZN6S696C53v61Ev,
  (VTBL_ENTRY)&_ZN6S696C53v62Ev,
  (VTBL_ENTRY)&_ZN6S696C53v63Ev,
  (VTBL_ENTRY)&_ZN6S696C53v64Ev,
  (VTBL_ENTRY)&_ZN6S696C53v65Ev,
  (VTBL_ENTRY)&_ZN6S696C53v66Ev,
  (VTBL_ENTRY)&_ZN6S696C53v67Ev,
  (VTBL_ENTRY)&_ZN6S696C53v68Ev,
  (VTBL_ENTRY)&_ZN6S696C53v69Ev,
  (VTBL_ENTRY)&_ZN6S696C53v70Ev,
};
extern VTBL_ENTRY _ZTI6S696C5[];
extern  VTBL_ENTRY _ZTV6S696C5[];
Class_Descriptor cd_S696C5 = {  "S696C5", // class name
  0,0,//no base classes
  &(vtc_S696C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S696C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S696C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S696C4  : S696C5 {
  virtual  ~S696C4(); // _ZN6S696C4D1Ev
  virtual void  v71(); // _ZN6S696C43v71Ev
  virtual void  v72(); // _ZN6S696C43v72Ev
  virtual void  v73(); // _ZN6S696C43v73Ev
  virtual void  v74(); // _ZN6S696C43v74Ev
  S696C4(); // tgen
};
//SIG(-1 S696C4) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S696C4 ::~S696C4(){ note_dtor("S696C4", this);}
void  S696C4 ::v71(){vfunc_called(this, "_ZN6S696C43v71Ev");}
void  S696C4 ::v72(){vfunc_called(this, "_ZN6S696C43v72Ev");}
void  S696C4 ::v73(){vfunc_called(this, "_ZN6S696C43v73Ev");}
void  S696C4 ::v74(){vfunc_called(this, "_ZN6S696C43v74Ev");}
S696C4 ::S696C4(){ note_ctor("S696C4", this);} // tgen

static void Test_S696C4()
{
  extern Class_Descriptor cd_S696C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S696C4, buf);
    S696C4 *dp, &lv = *(dp=new (buf) S696C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S696C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S696C4)");
    check_base_class_offset(lv, (S696C5*), 0, "S696C4");
    test_class_info(&lv, &cd_S696C4);
    dp->~S696C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS696C4(Test_S696C4, "S696C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S696C4C1Ev();
extern void _ZN6S696C4D1Ev();
Name_Map name_map_S696C4[] = {
  NSPAIR(_ZN6S696C4C1Ev),
  NSPAIR(_ZN6S696C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S696C5;
extern VTBL_ENTRY _ZTI6S696C5[];
extern  VTBL_ENTRY _ZTV6S696C5[];
static Base_Class bases_S696C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S696C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S696C4[];
extern void _ZN6S696C4D1Ev();
extern void _ZN6S696C4D0Ev();
extern void _ZN6S696C52v7Ev();
extern void _ZN6S696C52v8Ev();
extern void _ZN6S696C52v9Ev();
extern void _ZN6S696C53v10Ev();
extern void _ZN6S696C53v11Ev();
extern void _ZN6S696C53v12Ev();
extern void _ZN6S696C53v13Ev();
extern void _ZN6S696C53v14Ev();
extern void _ZN6S696C53v15Ev();
extern void _ZN6S696C53v16Ev();
extern void _ZN6S696C53v17Ev();
extern void _ZN6S696C53v18Ev();
extern void _ZN6S696C53v19Ev();
extern void _ZN6S696C53v20Ev();
extern void _ZN6S696C53v21Ev();
extern void _ZN6S696C53v22Ev();
extern void _ZN6S696C53v23Ev();
extern void _ZN6S696C53v24Ev();
extern void _ZN6S696C53v25Ev();
extern void _ZN6S696C53v26Ev();
extern void _ZN6S696C53v27Ev();
extern void _ZN6S696C53v28Ev();
extern void _ZN6S696C53v29Ev();
extern void _ZN6S696C53v30Ev();
extern void _ZN6S696C53v31Ev();
extern void _ZN6S696C53v32Ev();
extern void _ZN6S696C53v33Ev();
extern void _ZN6S696C53v34Ev();
extern void _ZN6S696C53v35Ev();
extern void _ZN6S696C53v36Ev();
extern void _ZN6S696C53v37Ev();
extern void _ZN6S696C53v38Ev();
extern void _ZN6S696C53v39Ev();
extern void _ZN6S696C53v40Ev();
extern void _ZN6S696C53v41Ev();
extern void _ZN6S696C53v42Ev();
extern void _ZN6S696C53v43Ev();
extern void _ZN6S696C53v44Ev();
extern void _ZN6S696C53v45Ev();
extern void _ZN6S696C53v46Ev();
extern void _ZN6S696C53v47Ev();
extern void _ZN6S696C53v48Ev();
extern void _ZN6S696C53v49Ev();
extern void _ZN6S696C53v50Ev();
extern void _ZN6S696C53v51Ev();
extern void _ZN6S696C53v52Ev();
extern void _ZN6S696C53v53Ev();
extern void _ZN6S696C53v54Ev();
extern void _ZN6S696C53v55Ev();
extern void _ZN6S696C53v56Ev();
extern void _ZN6S696C53v57Ev();
extern void _ZN6S696C53v58Ev();
extern void _ZN6S696C53v59Ev();
extern void _ZN6S696C53v60Ev();
extern void _ZN6S696C53v61Ev();
extern void _ZN6S696C53v62Ev();
extern void _ZN6S696C53v63Ev();
extern void _ZN6S696C53v64Ev();
extern void _ZN6S696C53v65Ev();
extern void _ZN6S696C53v66Ev();
extern void _ZN6S696C53v67Ev();
extern void _ZN6S696C53v68Ev();
extern void _ZN6S696C53v69Ev();
extern void _ZN6S696C53v70Ev();
extern void _ZN6S696C43v71Ev();
extern void _ZN6S696C43v72Ev();
extern void _ZN6S696C43v73Ev();
extern void _ZN6S696C43v74Ev();
static  VTBL_ENTRY vtc_S696C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S696C4[0]),
  (VTBL_ENTRY)&_ZN6S696C4D1Ev,
  (VTBL_ENTRY)&_ZN6S696C4D0Ev,
  (VTBL_ENTRY)&_ZN6S696C52v7Ev,
  (VTBL_ENTRY)&_ZN6S696C52v8Ev,
  (VTBL_ENTRY)&_ZN6S696C52v9Ev,
  (VTBL_ENTRY)&_ZN6S696C53v10Ev,
  (VTBL_ENTRY)&_ZN6S696C53v11Ev,
  (VTBL_ENTRY)&_ZN6S696C53v12Ev,
  (VTBL_ENTRY)&_ZN6S696C53v13Ev,
  (VTBL_ENTRY)&_ZN6S696C53v14Ev,
  (VTBL_ENTRY)&_ZN6S696C53v15Ev,
  (VTBL_ENTRY)&_ZN6S696C53v16Ev,
  (VTBL_ENTRY)&_ZN6S696C53v17Ev,
  (VTBL_ENTRY)&_ZN6S696C53v18Ev,
  (VTBL_ENTRY)&_ZN6S696C53v19Ev,
  (VTBL_ENTRY)&_ZN6S696C53v20Ev,
  (VTBL_ENTRY)&_ZN6S696C53v21Ev,
  (VTBL_ENTRY)&_ZN6S696C53v22Ev,
  (VTBL_ENTRY)&_ZN6S696C53v23Ev,
  (VTBL_ENTRY)&_ZN6S696C53v24Ev,
  (VTBL_ENTRY)&_ZN6S696C53v25Ev,
  (VTBL_ENTRY)&_ZN6S696C53v26Ev,
  (VTBL_ENTRY)&_ZN6S696C53v27Ev,
  (VTBL_ENTRY)&_ZN6S696C53v28Ev,
  (VTBL_ENTRY)&_ZN6S696C53v29Ev,
  (VTBL_ENTRY)&_ZN6S696C53v30Ev,
  (VTBL_ENTRY)&_ZN6S696C53v31Ev,
  (VTBL_ENTRY)&_ZN6S696C53v32Ev,
  (VTBL_ENTRY)&_ZN6S696C53v33Ev,
  (VTBL_ENTRY)&_ZN6S696C53v34Ev,
  (VTBL_ENTRY)&_ZN6S696C53v35Ev,
  (VTBL_ENTRY)&_ZN6S696C53v36Ev,
  (VTBL_ENTRY)&_ZN6S696C53v37Ev,
  (VTBL_ENTRY)&_ZN6S696C53v38Ev,
  (VTBL_ENTRY)&_ZN6S696C53v39Ev,
  (VTBL_ENTRY)&_ZN6S696C53v40Ev,
  (VTBL_ENTRY)&_ZN6S696C53v41Ev,
  (VTBL_ENTRY)&_ZN6S696C53v42Ev,
  (VTBL_ENTRY)&_ZN6S696C53v43Ev,
  (VTBL_ENTRY)&_ZN6S696C53v44Ev,
  (VTBL_ENTRY)&_ZN6S696C53v45Ev,
  (VTBL_ENTRY)&_ZN6S696C53v46Ev,
  (VTBL_ENTRY)&_ZN6S696C53v47Ev,
  (VTBL_ENTRY)&_ZN6S696C53v48Ev,
  (VTBL_ENTRY)&_ZN6S696C53v49Ev,
  (VTBL_ENTRY)&_ZN6S696C53v50Ev,
  (VTBL_ENTRY)&_ZN6S696C53v51Ev,
  (VTBL_ENTRY)&_ZN6S696C53v52Ev,
  (VTBL_ENTRY)&_ZN6S696C53v53Ev,
  (VTBL_ENTRY)&_ZN6S696C53v54Ev,
  (VTBL_ENTRY)&_ZN6S696C53v55Ev,
  (VTBL_ENTRY)&_ZN6S696C53v56Ev,
  (VTBL_ENTRY)&_ZN6S696C53v57Ev,
  (VTBL_ENTRY)&_ZN6S696C53v58Ev,
  (VTBL_ENTRY)&_ZN6S696C53v59Ev,
  (VTBL_ENTRY)&_ZN6S696C53v60Ev,
  (VTBL_ENTRY)&_ZN6S696C53v61Ev,
  (VTBL_ENTRY)&_ZN6S696C53v62Ev,
  (VTBL_ENTRY)&_ZN6S696C53v63Ev,
  (VTBL_ENTRY)&_ZN6S696C53v64Ev,
  (VTBL_ENTRY)&_ZN6S696C53v65Ev,
  (VTBL_ENTRY)&_ZN6S696C53v66Ev,
  (VTBL_ENTRY)&_ZN6S696C53v67Ev,
  (VTBL_ENTRY)&_ZN6S696C53v68Ev,
  (VTBL_ENTRY)&_ZN6S696C53v69Ev,
  (VTBL_ENTRY)&_ZN6S696C53v70Ev,
  (VTBL_ENTRY)&_ZN6S696C43v71Ev,
  (VTBL_ENTRY)&_ZN6S696C43v72Ev,
  (VTBL_ENTRY)&_ZN6S696C43v73Ev,
  (VTBL_ENTRY)&_ZN6S696C43v74Ev,
};
extern VTBL_ENTRY _ZTI6S696C4[];
extern  VTBL_ENTRY _ZTV6S696C4[];
Class_Descriptor cd_S696C4 = {  "S696C4", // class name
  bases_S696C4, 1,
  &(vtc_S696C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S696C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S696C4),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S696C3  : S696C4 {
  unsigned int s696c3f0:1;
  unsigned int s696c3f1:1;
  unsigned int s696c3f2:1;
  unsigned int s696c3f3:1;
  unsigned int s696c3f4:1;
  unsigned int s696c3f5:1;
  unsigned int s696c3f6:1;
  unsigned int s696c3f7:1;
  unsigned int s696c3f8:1;
  unsigned int s696c3f9:1;
  unsigned int s696c3f10:1;
  unsigned int s696c3f11:1;
  unsigned int s696c3f12:1;
  int s696c3f13[8];
  ::S507C7 s696c3f14;
  unsigned int s696c3f15:1;
  char s696c3f16;
  char s696c3f17[2];
  int s696c3f18[2];
  ::S685C27_nt s696c3f19;
  ::S685C27_nt s696c3f20;
  void *s696c3f21;
  virtual  ~S696C3(); // _ZN6S696C3D1Ev
  virtual void  v75(); // _ZN6S696C33v75Ev
  virtual void  v76(); // _ZN6S696C33v76Ev
  virtual void  v77(); // _ZN6S696C33v77Ev
  virtual void  v78(); // _ZN6S696C33v78Ev
  virtual void  v79(); // _ZN6S696C33v79Ev
  virtual void  v80(); // _ZN6S696C33v80Ev
  virtual void  v81(); // _ZN6S696C33v81Ev
  virtual void  v82(); // _ZN6S696C33v82Ev
  virtual void  v83(); // _ZN6S696C33v83Ev
  virtual void  v84(); // _ZN6S696C33v84Ev
  virtual void  v85(); // _ZN6S696C33v85Ev
  virtual void  v86(); // _ZN6S696C33v86Ev
  virtual void  v87(); // _ZN6S696C33v87Ev
  virtual void  v88(); // _ZN6S696C33v88Ev
  virtual void  v89(); // _ZN6S696C33v89Ev
  virtual void  v90(); // _ZN6S696C33v90Ev
  S696C3(); // tgen
};
//SIG(-1 S696C3) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC5{ BC6{ vd v87 v88 v89 v90 v91 Fi[8] Fp Fi Fp} v85 v86} Fi:1 Fc[3] Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 Fp}


 S696C3 ::~S696C3(){ note_dtor("S696C3", this);}
void  S696C3 ::v75(){vfunc_called(this, "_ZN6S696C33v75Ev");}
void  S696C3 ::v76(){vfunc_called(this, "_ZN6S696C33v76Ev");}
void  S696C3 ::v77(){vfunc_called(this, "_ZN6S696C33v77Ev");}
void  S696C3 ::v78(){vfunc_called(this, "_ZN6S696C33v78Ev");}
void  S696C3 ::v79(){vfunc_called(this, "_ZN6S696C33v79Ev");}
void  S696C3 ::v80(){vfunc_called(this, "_ZN6S696C33v80Ev");}
void  S696C3 ::v81(){vfunc_called(this, "_ZN6S696C33v81Ev");}
void  S696C3 ::v82(){vfunc_called(this, "_ZN6S696C33v82Ev");}
void  S696C3 ::v83(){vfunc_called(this, "_ZN6S696C33v83Ev");}
void  S696C3 ::v84(){vfunc_called(this, "_ZN6S696C33v84Ev");}
void  S696C3 ::v85(){vfunc_called(this, "_ZN6S696C33v85Ev");}
void  S696C3 ::v86(){vfunc_called(this, "_ZN6S696C33v86Ev");}
void  S696C3 ::v87(){vfunc_called(this, "_ZN6S696C33v87Ev");}
void  S696C3 ::v88(){vfunc_called(this, "_ZN6S696C33v88Ev");}
void  S696C3 ::v89(){vfunc_called(this, "_ZN6S696C33v89Ev");}
void  S696C3 ::v90(){vfunc_called(this, "_ZN6S696C33v90Ev");}
S696C3 ::S696C3(){ note_ctor("S696C3", this);} // tgen

static void Test_S696C3()
{
  extern Class_Descriptor cd_S696C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,47)];
    init_test(&cd_S696C3, buf);
    S696C3 *dp, &lv = *(dp=new (buf) S696C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,184), "sizeof(S696C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S696C3)");
    check_base_class_offset(lv, (S696C5*)(S696C4*), 0, "S696C3");
    check_base_class_offset(lv, (S696C4*), 0, "S696C3");
    set_bf_and_test(lv, s696c3f0, ABISELECT(96,60), 0, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f1, ABISELECT(96,60), 1, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f2, ABISELECT(96,60), 2, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f3, ABISELECT(96,60), 3, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f4, ABISELECT(96,60), 4, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f5, ABISELECT(96,60), 5, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f6, ABISELECT(96,60), 6, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f7, ABISELECT(96,60), 7, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f8, ABISELECT(97,61), 0, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f9, ABISELECT(97,61), 1, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f10, ABISELECT(97,61), 2, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f11, ABISELECT(97,61), 3, 1, 1, "S696C3");
    set_bf_and_test(lv, s696c3f12, ABISELECT(97,61), 4, 1, 1, "S696C3");
    check_field_offset(lv, s696c3f13, ABISELECT(100,64), "S696C3.s696c3f13");
    check_field_offset(lv, s696c3f14, ABISELECT(136,96), "S696C3.s696c3f14");
    set_bf_and_test(lv, s696c3f15, ABISELECT(200,144), 0, 1, 1, "S696C3");
    check_field_offset(lv, s696c3f16, ABISELECT(201,145), "S696C3.s696c3f16");
    check_field_offset(lv, s696c3f17, ABISELECT(202,146), "S696C3.s696c3f17");
    check_field_offset(lv, s696c3f18, ABISELECT(204,148), "S696C3.s696c3f18");
    check_field_offset(lv, s696c3f19, ABISELECT(216,156), "S696C3.s696c3f19");
    check_field_offset(lv, s696c3f20, ABISELECT(232,168), "S696C3.s696c3f20");
    check_field_offset(lv, s696c3f21, ABISELECT(248,180), "S696C3.s696c3f21");
    test_class_info(&lv, &cd_S696C3);
    dp->~S696C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS696C3(Test_S696C3, "S696C3", ABISELECT(256,184));

#else // __cplusplus

extern void _ZN6S696C3C1Ev();
extern void _ZN6S696C3D1Ev();
Name_Map name_map_S696C3[] = {
  NSPAIR(_ZN6S696C3C1Ev),
  NSPAIR(_ZN6S696C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S696C5;
extern VTBL_ENTRY _ZTI6S696C5[];
extern  VTBL_ENTRY _ZTV6S696C5[];
extern Class_Descriptor cd_S696C4;
extern VTBL_ENTRY _ZTI6S696C4[];
extern  VTBL_ENTRY _ZTV6S696C4[];
static Base_Class bases_S696C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S696C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S696C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S696C3[];
extern void _ZN6S696C3D1Ev();
extern void _ZN6S696C3D0Ev();
extern void _ZN6S696C52v7Ev();
extern void _ZN6S696C52v8Ev();
extern void _ZN6S696C52v9Ev();
extern void _ZN6S696C53v10Ev();
extern void _ZN6S696C53v11Ev();
extern void _ZN6S696C53v12Ev();
extern void _ZN6S696C53v13Ev();
extern void _ZN6S696C53v14Ev();
extern void _ZN6S696C53v15Ev();
extern void _ZN6S696C53v16Ev();
extern void _ZN6S696C53v17Ev();
extern void _ZN6S696C53v18Ev();
extern void _ZN6S696C53v19Ev();
extern void _ZN6S696C53v20Ev();
extern void _ZN6S696C53v21Ev();
extern void _ZN6S696C53v22Ev();
extern void _ZN6S696C53v23Ev();
extern void _ZN6S696C53v24Ev();
extern void _ZN6S696C53v25Ev();
extern void _ZN6S696C53v26Ev();
extern void _ZN6S696C53v27Ev();
extern void _ZN6S696C53v28Ev();
extern void _ZN6S696C53v29Ev();
extern void _ZN6S696C53v30Ev();
extern void _ZN6S696C53v31Ev();
extern void _ZN6S696C53v32Ev();
extern void _ZN6S696C53v33Ev();
extern void _ZN6S696C53v34Ev();
extern void _ZN6S696C53v35Ev();
extern void _ZN6S696C53v36Ev();
extern void _ZN6S696C53v37Ev();
extern void _ZN6S696C53v38Ev();
extern void _ZN6S696C53v39Ev();
extern void _ZN6S696C53v40Ev();
extern void _ZN6S696C53v41Ev();
extern void _ZN6S696C53v42Ev();
extern void _ZN6S696C53v43Ev();
extern void _ZN6S696C53v44Ev();
extern void _ZN6S696C53v45Ev();
extern void _ZN6S696C53v46Ev();
extern void _ZN6S696C53v47Ev();
extern void _ZN6S696C53v48Ev();
extern void _ZN6S696C53v49Ev();
extern void _ZN6S696C53v50Ev();
extern void _ZN6S696C53v51Ev();
extern void _ZN6S696C53v52Ev();
extern void _ZN6S696C53v53Ev();
extern void _ZN6S696C53v54Ev();
extern void _ZN6S696C53v55Ev();
extern void _ZN6S696C53v56Ev();
extern void _ZN6S696C53v57Ev();
extern void _ZN6S696C53v58Ev();
extern void _ZN6S696C53v59Ev();
extern void _ZN6S696C53v60Ev();
extern void _ZN6S696C53v61Ev();
extern void _ZN6S696C53v62Ev();
extern void _ZN6S696C53v63Ev();
extern void _ZN6S696C53v64Ev();
extern void _ZN6S696C53v65Ev();
extern void _ZN6S696C53v66Ev();
extern void _ZN6S696C53v67Ev();
extern void _ZN6S696C53v68Ev();
extern void _ZN6S696C53v69Ev();
extern void _ZN6S696C53v70Ev();
extern void _ZN6S696C43v71Ev();
extern void _ZN6S696C43v72Ev();
extern void _ZN6S696C43v73Ev();
extern void _ZN6S696C43v74Ev();
extern void _ZN6S696C33v75Ev();
extern void _ZN6S696C33v76Ev();
extern void _ZN6S696C33v77Ev();
extern void _ZN6S696C33v78Ev();
extern void _ZN6S696C33v79Ev();
extern void _ZN6S696C33v80Ev();
extern void _ZN6S696C33v81Ev();
extern void _ZN6S696C33v82Ev();
extern void _ZN6S696C33v83Ev();
extern void _ZN6S696C33v84Ev();
extern void _ZN6S696C33v85Ev();
extern void _ZN6S696C33v86Ev();
extern void _ZN6S696C33v87Ev();
extern void _ZN6S696C33v88Ev();
extern void _ZN6S696C33v89Ev();
extern void _ZN6S696C33v90Ev();
static  VTBL_ENTRY vtc_S696C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S696C3[0]),
  (VTBL_ENTRY)&_ZN6S696C3D1Ev,
  (VTBL_ENTRY)&_ZN6S696C3D0Ev,
  (VTBL_ENTRY)&_ZN6S696C52v7Ev,
  (VTBL_ENTRY)&_ZN6S696C52v8Ev,
  (VTBL_ENTRY)&_ZN6S696C52v9Ev,
  (VTBL_ENTRY)&_ZN6S696C53v10Ev,
  (VTBL_ENTRY)&_ZN6S696C53v11Ev,
  (VTBL_ENTRY)&_ZN6S696C53v12Ev,
  (VTBL_ENTRY)&_ZN6S696C53v13Ev,
  (VTBL_ENTRY)&_ZN6S696C53v14Ev,
  (VTBL_ENTRY)&_ZN6S696C53v15Ev,
  (VTBL_ENTRY)&_ZN6S696C53v16Ev,
  (VTBL_ENTRY)&_ZN6S696C53v17Ev,
  (VTBL_ENTRY)&_ZN6S696C53v18Ev,
  (VTBL_ENTRY)&_ZN6S696C53v19Ev,
  (VTBL_ENTRY)&_ZN6S696C53v20Ev,
  (VTBL_ENTRY)&_ZN6S696C53v21Ev,
  (VTBL_ENTRY)&_ZN6S696C53v22Ev,
  (VTBL_ENTRY)&_ZN6S696C53v23Ev,
  (VTBL_ENTRY)&_ZN6S696C53v24Ev,
  (VTBL_ENTRY)&_ZN6S696C53v25Ev,
  (VTBL_ENTRY)&_ZN6S696C53v26Ev,
  (VTBL_ENTRY)&_ZN6S696C53v27Ev,
  (VTBL_ENTRY)&_ZN6S696C53v28Ev,
  (VTBL_ENTRY)&_ZN6S696C53v29Ev,
  (VTBL_ENTRY)&_ZN6S696C53v30Ev,
  (VTBL_ENTRY)&_ZN6S696C53v31Ev,
  (VTBL_ENTRY)&_ZN6S696C53v32Ev,
  (VTBL_ENTRY)&_ZN6S696C53v33Ev,
  (VTBL_ENTRY)&_ZN6S696C53v34Ev,
  (VTBL_ENTRY)&_ZN6S696C53v35Ev,
  (VTBL_ENTRY)&_ZN6S696C53v36Ev,
  (VTBL_ENTRY)&_ZN6S696C53v37Ev,
  (VTBL_ENTRY)&_ZN6S696C53v38Ev,
  (VTBL_ENTRY)&_ZN6S696C53v39Ev,
  (VTBL_ENTRY)&_ZN6S696C53v40Ev,
  (VTBL_ENTRY)&_ZN6S696C53v41Ev,
  (VTBL_ENTRY)&_ZN6S696C53v42Ev,
  (VTBL_ENTRY)&_ZN6S696C53v43Ev,
  (VTBL_ENTRY)&_ZN6S696C53v44Ev,
  (VTBL_ENTRY)&_ZN6S696C53v45Ev,
  (VTBL_ENTRY)&_ZN6S696C53v46Ev,
  (VTBL_ENTRY)&_ZN6S696C53v47Ev,
  (VTBL_ENTRY)&_ZN6S696C53v48Ev,
  (VTBL_ENTRY)&_ZN6S696C53v49Ev,
  (VTBL_ENTRY)&_ZN6S696C53v50Ev,
  (VTBL_ENTRY)&_ZN6S696C53v51Ev,
  (VTBL_ENTRY)&_ZN6S696C53v52Ev,
  (VTBL_ENTRY)&_ZN6S696C53v53Ev,
  (VTBL_ENTRY)&_ZN6S696C53v54Ev,
  (VTBL_ENTRY)&_ZN6S696C53v55Ev,
  (VTBL_ENTRY)&_ZN6S696C53v56Ev,
  (VTBL_ENTRY)&_ZN6S696C53v57Ev,
  (VTBL_ENTRY)&_ZN6S696C53v58Ev,
  (VTBL_ENTRY)&_ZN6S696C53v59Ev,
  (VTBL_ENTRY)&_ZN6S696C53v60Ev,
  (VTBL_ENTRY)&_ZN6S696C53v61Ev,
  (VTBL_ENTRY)&_ZN6S696C53v62Ev,
  (VTBL_ENTRY)&_ZN6S696C53v63Ev,
  (VTBL_ENTRY)&_ZN6S696C53v64Ev,
  (VTBL_ENTRY)&_ZN6S696C53v65Ev,
  (VTBL_ENTRY)&_ZN6S696C53v66Ev,
  (VTBL_ENTRY)&_ZN6S696C53v67Ev,
  (VTBL_ENTRY)&_ZN6S696C53v68Ev,
  (VTBL_ENTRY)&_ZN6S696C53v69Ev,
  (VTBL_ENTRY)&_ZN6S696C53v70Ev,
  (VTBL_ENTRY)&_ZN6S696C43v71Ev,
  (VTBL_ENTRY)&_ZN6S696C43v72Ev,
  (VTBL_ENTRY)&_ZN6S696C43v73Ev,
  (VTBL_ENTRY)&_ZN6S696C43v74Ev,
  (VTBL_ENTRY)&_ZN6S696C33v75Ev,
  (VTBL_ENTRY)&_ZN6S696C33v76Ev,
  (VTBL_ENTRY)&_ZN6S696C33v77Ev,
  (VTBL_ENTRY)&_ZN6S696C33v78Ev,
  (VTBL_ENTRY)&_ZN6S696C33v79Ev,
  (VTBL_ENTRY)&_ZN6S696C33v80Ev,
  (VTBL_ENTRY)&_ZN6S696C33v81Ev,
  (VTBL_ENTRY)&_ZN6S696C33v82Ev,
  (VTBL_ENTRY)&_ZN6S696C33v83Ev,
  (VTBL_ENTRY)&_ZN6S696C33v84Ev,
  (VTBL_ENTRY)&_ZN6S696C33v85Ev,
  (VTBL_ENTRY)&_ZN6S696C33v86Ev,
  (VTBL_ENTRY)&_ZN6S696C33v87Ev,
  (VTBL_ENTRY)&_ZN6S696C33v88Ev,
  (VTBL_ENTRY)&_ZN6S696C33v89Ev,
  (VTBL_ENTRY)&_ZN6S696C33v90Ev,
};
extern VTBL_ENTRY _ZTI6S696C3[];
extern  VTBL_ENTRY _ZTV6S696C3[];
Class_Descriptor cd_S696C3 = {  "S696C3", // class name
  bases_S696C3, 2,
  &(vtc_S696C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,184), // object size
  NSPAIRA(_ZTI6S696C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S696C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S696C2  : S696C3 {
  ::S685C40 s696c2f0;
  int s696c2f1[2];
  char s696c2f2[3];
  unsigned int s696c2f3:1;
  unsigned int s696c2f4:1;
  unsigned int s696c2f5:1;
  unsigned int s696c2f6:1;
  unsigned int s696c2f7:1;
  int s696c2f8;
  ::S695C22_nt s696c2f9;
  int s696c2f10[2];
  ::S685C10_nt s696c2f11;
  ::S507C15_nt s696c2f12;
  int s696c2f13;
  void *s696c2f14;
  int s696c2f15;
  virtual  ~S696C2(); // _ZN6S696C2D1Ev
  virtual void  v91(); // _ZN6S696C23v91Ev
  virtual void  v92(); // _ZN6S696C23v92Ev
  virtual void  v93(); // _ZN6S696C23v93Ev
  virtual void  v94(); // _ZN6S696C23v94Ev
  virtual void  v95(); // _ZN6S696C23v95Ev
  virtual void  v96(); // _ZN6S696C23v96Ev
  virtual void  v97(); // _ZN6S696C23v97Ev
  virtual void  v98(); // _ZN6S696C23v98Ev
  virtual void  v99(); // _ZN6S696C23v99Ev
  virtual void  v100(); // _ZN6S696C24v100Ev
  virtual void  v101(); // _ZN6S696C24v101Ev
  virtual void  v102(); // _ZN6S696C24v102Ev
  virtual void  v103(); // _ZN6S696C24v103Ev
  virtual void  v104(); // _ZN6S696C24v104Ev
  virtual void  v105(); // _ZN6S696C24v105Ev
  virtual void  v106(); // _ZN6S696C24v106Ev
  S696C2(); // tgen
};
//SIG(-1 S696C2) C1{ BC2{ BC3{ BC4{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC6{ BC7{ vd v103 v104 v105 v106 v107 Fi[8] Fp Fi Fp} v101 v102} Fi:1 Fc[3] Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 FC12{ BC11} Fi[2] Fc[3] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC5 Fi[2] FC13{ m Fi} FC14{ m Fp[3]} Fi Fp Fi}


 S696C2 ::~S696C2(){ note_dtor("S696C2", this);}
void  S696C2 ::v91(){vfunc_called(this, "_ZN6S696C23v91Ev");}
void  S696C2 ::v92(){vfunc_called(this, "_ZN6S696C23v92Ev");}
void  S696C2 ::v93(){vfunc_called(this, "_ZN6S696C23v93Ev");}
void  S696C2 ::v94(){vfunc_called(this, "_ZN6S696C23v94Ev");}
void  S696C2 ::v95(){vfunc_called(this, "_ZN6S696C23v95Ev");}
void  S696C2 ::v96(){vfunc_called(this, "_ZN6S696C23v96Ev");}
void  S696C2 ::v97(){vfunc_called(this, "_ZN6S696C23v97Ev");}
void  S696C2 ::v98(){vfunc_called(this, "_ZN6S696C23v98Ev");}
void  S696C2 ::v99(){vfunc_called(this, "_ZN6S696C23v99Ev");}
void  S696C2 ::v100(){vfunc_called(this, "_ZN6S696C24v100Ev");}
void  S696C2 ::v101(){vfunc_called(this, "_ZN6S696C24v101Ev");}
void  S696C2 ::v102(){vfunc_called(this, "_ZN6S696C24v102Ev");}
void  S696C2 ::v103(){vfunc_called(this, "_ZN6S696C24v103Ev");}
void  S696C2 ::v104(){vfunc_called(this, "_ZN6S696C24v104Ev");}
void  S696C2 ::v105(){vfunc_called(this, "_ZN6S696C24v105Ev");}
void  S696C2 ::v106(){vfunc_called(this, "_ZN6S696C24v106Ev");}
S696C2 ::S696C2(){ note_ctor("S696C2", this);} // tgen

static void Test_S696C2()
{
  extern Class_Descriptor cd_S696C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,65)];
    init_test(&cd_S696C2, buf);
    S696C2 *dp, &lv = *(dp=new (buf) S696C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,256), "sizeof(S696C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S696C2)");
    check_base_class_offset(lv, (S696C5*)(S696C4*)(S696C3*), 0, "S696C2");
    check_base_class_offset(lv, (S696C4*)(S696C3*), 0, "S696C2");
    check_base_class_offset(lv, (S696C3*), 0, "S696C2");
    check_field_offset(lv, s696c2f0, ABISELECT(256,184), "S696C2.s696c2f0");
    check_field_offset(lv, s696c2f1, ABISELECT(272,196), "S696C2.s696c2f1");
    check_field_offset(lv, s696c2f2, ABISELECT(280,204), "S696C2.s696c2f2");
    set_bf_and_test(lv, s696c2f3, ABISELECT(283,207), 0, 1, 1, "S696C2");
    set_bf_and_test(lv, s696c2f4, ABISELECT(283,207), 1, 1, 1, "S696C2");
    set_bf_and_test(lv, s696c2f5, ABISELECT(283,207), 2, 1, 1, "S696C2");
    set_bf_and_test(lv, s696c2f6, ABISELECT(283,207), 3, 1, 1, "S696C2");
    set_bf_and_test(lv, s696c2f7, ABISELECT(283,207), 4, 1, 1, "S696C2");
    check_field_offset(lv, s696c2f8, ABISELECT(284,208), "S696C2.s696c2f8");
    check_field_offset(lv, s696c2f9, ABISELECT(288,212), "S696C2.s696c2f9");
    check_field_offset(lv, s696c2f10, ABISELECT(296,220), "S696C2.s696c2f10");
    check_field_offset(lv, s696c2f11, ABISELECT(304,228), "S696C2.s696c2f11");
    check_field_offset(lv, s696c2f12, ABISELECT(312,232), "S696C2.s696c2f12");
    check_field_offset(lv, s696c2f13, ABISELECT(336,244), "S696C2.s696c2f13");
    check_field_offset(lv, s696c2f14, ABISELECT(344,248), "S696C2.s696c2f14");
    check_field_offset(lv, s696c2f15, ABISELECT(352,252), "S696C2.s696c2f15");
    test_class_info(&lv, &cd_S696C2);
    dp->~S696C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS696C2(Test_S696C2, "S696C2", ABISELECT(360,256));

#else // __cplusplus

extern void _ZN6S696C2C1Ev();
extern void _ZN6S696C2D1Ev();
Name_Map name_map_S696C2[] = {
  NSPAIR(_ZN6S696C2C1Ev),
  NSPAIR(_ZN6S696C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S696C5;
extern VTBL_ENTRY _ZTI6S696C5[];
extern  VTBL_ENTRY _ZTV6S696C5[];
extern Class_Descriptor cd_S696C4;
extern VTBL_ENTRY _ZTI6S696C4[];
extern  VTBL_ENTRY _ZTV6S696C4[];
extern Class_Descriptor cd_S696C3;
extern VTBL_ENTRY _ZTI6S696C3[];
extern  VTBL_ENTRY _ZTV6S696C3[];
static Base_Class bases_S696C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S696C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S696C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S696C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S696C2[];
extern void _ZN6S696C2D1Ev();
extern void _ZN6S696C2D0Ev();
extern void _ZN6S696C52v7Ev();
extern void _ZN6S696C52v8Ev();
extern void _ZN6S696C52v9Ev();
extern void _ZN6S696C53v10Ev();
extern void _ZN6S696C53v11Ev();
extern void _ZN6S696C53v12Ev();
extern void _ZN6S696C53v13Ev();
extern void _ZN6S696C53v14Ev();
extern void _ZN6S696C53v15Ev();
extern void _ZN6S696C53v16Ev();
extern void _ZN6S696C53v17Ev();
extern void _ZN6S696C53v18Ev();
extern void _ZN6S696C53v19Ev();
extern void _ZN6S696C53v20Ev();
extern void _ZN6S696C53v21Ev();
extern void _ZN6S696C53v22Ev();
extern void _ZN6S696C53v23Ev();
extern void _ZN6S696C53v24Ev();
extern void _ZN6S696C53v25Ev();
extern void _ZN6S696C53v26Ev();
extern void _ZN6S696C53v27Ev();
extern void _ZN6S696C53v28Ev();
extern void _ZN6S696C53v29Ev();
extern void _ZN6S696C53v30Ev();
extern void _ZN6S696C53v31Ev();
extern void _ZN6S696C53v32Ev();
extern void _ZN6S696C53v33Ev();
extern void _ZN6S696C53v34Ev();
extern void _ZN6S696C53v35Ev();
extern void _ZN6S696C53v36Ev();
extern void _ZN6S696C53v37Ev();
extern void _ZN6S696C53v38Ev();
extern void _ZN6S696C53v39Ev();
extern void _ZN6S696C53v40Ev();
extern void _ZN6S696C53v41Ev();
extern void _ZN6S696C53v42Ev();
extern void _ZN6S696C53v43Ev();
extern void _ZN6S696C53v44Ev();
extern void _ZN6S696C53v45Ev();
extern void _ZN6S696C53v46Ev();
extern void _ZN6S696C53v47Ev();
extern void _ZN6S696C53v48Ev();
extern void _ZN6S696C53v49Ev();
extern void _ZN6S696C53v50Ev();
extern void _ZN6S696C53v51Ev();
extern void _ZN6S696C53v52Ev();
extern void _ZN6S696C53v53Ev();
extern void _ZN6S696C53v54Ev();
extern void _ZN6S696C53v55Ev();
extern void _ZN6S696C53v56Ev();
extern void _ZN6S696C53v57Ev();
extern void _ZN6S696C53v58Ev();
extern void _ZN6S696C53v59Ev();
extern void _ZN6S696C53v60Ev();
extern void _ZN6S696C53v61Ev();
extern void _ZN6S696C53v62Ev();
extern void _ZN6S696C53v63Ev();
extern void _ZN6S696C53v64Ev();
extern void _ZN6S696C53v65Ev();
extern void _ZN6S696C53v66Ev();
extern void _ZN6S696C53v67Ev();
extern void _ZN6S696C53v68Ev();
extern void _ZN6S696C53v69Ev();
extern void _ZN6S696C53v70Ev();
extern void _ZN6S696C43v71Ev();
extern void _ZN6S696C43v72Ev();
extern void _ZN6S696C43v73Ev();
extern void _ZN6S696C43v74Ev();
extern void _ZN6S696C33v75Ev();
extern void _ZN6S696C33v76Ev();
extern void _ZN6S696C33v77Ev();
extern void _ZN6S696C33v78Ev();
extern void _ZN6S696C33v79Ev();
extern void _ZN6S696C33v80Ev();
extern void _ZN6S696C33v81Ev();
extern void _ZN6S696C33v82Ev();
extern void _ZN6S696C33v83Ev();
extern void _ZN6S696C33v84Ev();
extern void _ZN6S696C33v85Ev();
extern void _ZN6S696C33v86Ev();
extern void _ZN6S696C33v87Ev();
extern void _ZN6S696C33v88Ev();
extern void _ZN6S696C33v89Ev();
extern void _ZN6S696C33v90Ev();
extern void _ZN6S696C23v91Ev();
extern void _ZN6S696C23v92Ev();
extern void _ZN6S696C23v93Ev();
extern void _ZN6S696C23v94Ev();
extern void _ZN6S696C23v95Ev();
extern void _ZN6S696C23v96Ev();
extern void _ZN6S696C23v97Ev();
extern void _ZN6S696C23v98Ev();
extern void _ZN6S696C23v99Ev();
extern void _ZN6S696C24v100Ev();
extern void _ZN6S696C24v101Ev();
extern void _ZN6S696C24v102Ev();
extern void _ZN6S696C24v103Ev();
extern void _ZN6S696C24v104Ev();
extern void _ZN6S696C24v105Ev();
extern void _ZN6S696C24v106Ev();
static  VTBL_ENTRY vtc_S696C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S696C2[0]),
  (VTBL_ENTRY)&_ZN6S696C2D1Ev,
  (VTBL_ENTRY)&_ZN6S696C2D0Ev,
  (VTBL_ENTRY)&_ZN6S696C52v7Ev,
  (VTBL_ENTRY)&_ZN6S696C52v8Ev,
  (VTBL_ENTRY)&_ZN6S696C52v9Ev,
  (VTBL_ENTRY)&_ZN6S696C53v10Ev,
  (VTBL_ENTRY)&_ZN6S696C53v11Ev,
  (VTBL_ENTRY)&_ZN6S696C53v12Ev,
  (VTBL_ENTRY)&_ZN6S696C53v13Ev,
  (VTBL_ENTRY)&_ZN6S696C53v14Ev,
  (VTBL_ENTRY)&_ZN6S696C53v15Ev,
  (VTBL_ENTRY)&_ZN6S696C53v16Ev,
  (VTBL_ENTRY)&_ZN6S696C53v17Ev,
  (VTBL_ENTRY)&_ZN6S696C53v18Ev,
  (VTBL_ENTRY)&_ZN6S696C53v19Ev,
  (VTBL_ENTRY)&_ZN6S696C53v20Ev,
  (VTBL_ENTRY)&_ZN6S696C53v21Ev,
  (VTBL_ENTRY)&_ZN6S696C53v22Ev,
  (VTBL_ENTRY)&_ZN6S696C53v23Ev,
  (VTBL_ENTRY)&_ZN6S696C53v24Ev,
  (VTBL_ENTRY)&_ZN6S696C53v25Ev,
  (VTBL_ENTRY)&_ZN6S696C53v26Ev,
  (VTBL_ENTRY)&_ZN6S696C53v27Ev,
  (VTBL_ENTRY)&_ZN6S696C53v28Ev,
  (VTBL_ENTRY)&_ZN6S696C53v29Ev,
  (VTBL_ENTRY)&_ZN6S696C53v30Ev,
  (VTBL_ENTRY)&_ZN6S696C53v31Ev,
  (VTBL_ENTRY)&_ZN6S696C53v32Ev,
  (VTBL_ENTRY)&_ZN6S696C53v33Ev,
  (VTBL_ENTRY)&_ZN6S696C53v34Ev,
  (VTBL_ENTRY)&_ZN6S696C53v35Ev,
  (VTBL_ENTRY)&_ZN6S696C53v36Ev,
  (VTBL_ENTRY)&_ZN6S696C53v37Ev,
  (VTBL_ENTRY)&_ZN6S696C53v38Ev,
  (VTBL_ENTRY)&_ZN6S696C53v39Ev,
  (VTBL_ENTRY)&_ZN6S696C53v40Ev,
  (VTBL_ENTRY)&_ZN6S696C53v41Ev,
  (VTBL_ENTRY)&_ZN6S696C53v42Ev,
  (VTBL_ENTRY)&_ZN6S696C53v43Ev,
  (VTBL_ENTRY)&_ZN6S696C53v44Ev,
  (VTBL_ENTRY)&_ZN6S696C53v45Ev,
  (VTBL_ENTRY)&_ZN6S696C53v46Ev,
  (VTBL_ENTRY)&_ZN6S696C53v47Ev,
  (VTBL_ENTRY)&_ZN6S696C53v48Ev,
  (VTBL_ENTRY)&_ZN6S696C53v49Ev,
  (VTBL_ENTRY)&_ZN6S696C53v50Ev,
  (VTBL_ENTRY)&_ZN6S696C53v51Ev,
  (VTBL_ENTRY)&_ZN6S696C53v52Ev,
  (VTBL_ENTRY)&_ZN6S696C53v53Ev,
  (VTBL_ENTRY)&_ZN6S696C53v54Ev,
  (VTBL_ENTRY)&_ZN6S696C53v55Ev,
  (VTBL_ENTRY)&_ZN6S696C53v56Ev,
  (VTBL_ENTRY)&_ZN6S696C53v57Ev,
  (VTBL_ENTRY)&_ZN6S696C53v58Ev,
  (VTBL_ENTRY)&_ZN6S696C53v59Ev,
  (VTBL_ENTRY)&_ZN6S696C53v60Ev,
  (VTBL_ENTRY)&_ZN6S696C53v61Ev,
  (VTBL_ENTRY)&_ZN6S696C53v62Ev,
  (VTBL_ENTRY)&_ZN6S696C53v63Ev,
  (VTBL_ENTRY)&_ZN6S696C53v64Ev,
  (VTBL_ENTRY)&_ZN6S696C53v65Ev,
  (VTBL_ENTRY)&_ZN6S696C53v66Ev,
  (VTBL_ENTRY)&_ZN6S696C53v67Ev,
  (VTBL_ENTRY)&_ZN6S696C53v68Ev,
  (VTBL_ENTRY)&_ZN6S696C53v69Ev,
  (VTBL_ENTRY)&_ZN6S696C53v70Ev,
  (VTBL_ENTRY)&_ZN6S696C43v71Ev,
  (VTBL_ENTRY)&_ZN6S696C43v72Ev,
  (VTBL_ENTRY)&_ZN6S696C43v73Ev,
  (VTBL_ENTRY)&_ZN6S696C43v74Ev,
  (VTBL_ENTRY)&_ZN6S696C33v75Ev,
  (VTBL_ENTRY)&_ZN6S696C33v76Ev,
  (VTBL_ENTRY)&_ZN6S696C33v77Ev,
  (VTBL_ENTRY)&_ZN6S696C33v78Ev,
  (VTBL_ENTRY)&_ZN6S696C33v79Ev,
  (VTBL_ENTRY)&_ZN6S696C33v80Ev,
  (VTBL_ENTRY)&_ZN6S696C33v81Ev,
  (VTBL_ENTRY)&_ZN6S696C33v82Ev,
  (VTBL_ENTRY)&_ZN6S696C33v83Ev,
  (VTBL_ENTRY)&_ZN6S696C33v84Ev,
  (VTBL_ENTRY)&_ZN6S696C33v85Ev,
  (VTBL_ENTRY)&_ZN6S696C33v86Ev,
  (VTBL_ENTRY)&_ZN6S696C33v87Ev,
  (VTBL_ENTRY)&_ZN6S696C33v88Ev,
  (VTBL_ENTRY)&_ZN6S696C33v89Ev,
  (VTBL_ENTRY)&_ZN6S696C33v90Ev,
  (VTBL_ENTRY)&_ZN6S696C23v91Ev,
  (VTBL_ENTRY)&_ZN6S696C23v92Ev,
  (VTBL_ENTRY)&_ZN6S696C23v93Ev,
  (VTBL_ENTRY)&_ZN6S696C23v94Ev,
  (VTBL_ENTRY)&_ZN6S696C23v95Ev,
  (VTBL_ENTRY)&_ZN6S696C23v96Ev,
  (VTBL_ENTRY)&_ZN6S696C23v97Ev,
  (VTBL_ENTRY)&_ZN6S696C23v98Ev,
  (VTBL_ENTRY)&_ZN6S696C23v99Ev,
  (VTBL_ENTRY)&_ZN6S696C24v100Ev,
  (VTBL_ENTRY)&_ZN6S696C24v101Ev,
  (VTBL_ENTRY)&_ZN6S696C24v102Ev,
  (VTBL_ENTRY)&_ZN6S696C24v103Ev,
  (VTBL_ENTRY)&_ZN6S696C24v104Ev,
  (VTBL_ENTRY)&_ZN6S696C24v105Ev,
  (VTBL_ENTRY)&_ZN6S696C24v106Ev,
};
extern VTBL_ENTRY _ZTI6S696C2[];
extern  VTBL_ENTRY _ZTV6S696C2[];
Class_Descriptor cd_S696C2 = {  "S696C2", // class name
  bases_S696C2, 3,
  &(vtc_S696C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,256), // object size
  NSPAIRA(_ZTI6S696C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S696C2),104, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S696C1  : S696C2 {
  void *s696c1f0;
  ::S685C39 s696c1f1;
  virtual  ~S696C1(); // _ZN6S696C1D1Ev
  virtual void  v1(); // _ZN6S696C12v1Ev
  virtual void  v2(); // _ZN6S696C12v2Ev
  virtual void  v3(); // _ZN6S696C12v3Ev
  virtual void  v4(); // _ZN6S696C12v4Ev
  virtual void  v5(); // _ZN6S696C12v5Ev
  virtual void  v6(); // _ZN6S696C12v6Ev
  S696C1(); // tgen
};
//SIG(1 S696C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v71 v72 v73 v74} vd v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC7{ BC8{ vd v109 v110 v111 v112 v113 Fi[8] Fp Fi Fp} v107 v108} Fi:1 Fc[3] Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 Fp} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 FC13{ BC12} Fi[2] Fc[3] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC6 Fi[2] FC14{ m Fi} FC15{ m Fp[3]} Fi Fp Fi} vd v1 v2 v3 v4 v5 v6 Fp FC16{ BC13}}


 S696C1 ::~S696C1(){ note_dtor("S696C1", this);}
void  S696C1 ::v1(){vfunc_called(this, "_ZN6S696C12v1Ev");}
void  S696C1 ::v2(){vfunc_called(this, "_ZN6S696C12v2Ev");}
void  S696C1 ::v3(){vfunc_called(this, "_ZN6S696C12v3Ev");}
void  S696C1 ::v4(){vfunc_called(this, "_ZN6S696C12v4Ev");}
void  S696C1 ::v5(){vfunc_called(this, "_ZN6S696C12v5Ev");}
void  S696C1 ::v6(){vfunc_called(this, "_ZN6S696C12v6Ev");}
S696C1 ::S696C1(){ note_ctor("S696C1", this);} // tgen

static void Test_S696C1()
{
  extern Class_Descriptor cd_S696C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(49,69)];
    init_test(&cd_S696C1, buf);
    S696C1 *dp, &lv = *(dp=new (buf) S696C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(384,272), "sizeof(S696C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S696C1)");
    check_base_class_offset(lv, (S696C5*)(S696C4*)(S696C3*)(S696C2*), 0, "S696C1");
    check_base_class_offset(lv, (S696C4*)(S696C3*)(S696C2*), 0, "S696C1");
    check_base_class_offset(lv, (S696C3*)(S696C2*), 0, "S696C1");
    check_base_class_offset(lv, (S696C2*), 0, "S696C1");
    check_field_offset(lv, s696c1f0, ABISELECT(360,256), "S696C1.s696c1f0");
    check_field_offset(lv, s696c1f1, ABISELECT(368,260), "S696C1.s696c1f1");
    test_class_info(&lv, &cd_S696C1);
    dp->~S696C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS696C1(Test_S696C1, "S696C1", ABISELECT(384,272));

#else // __cplusplus

extern void _ZN6S696C1C1Ev();
extern void _ZN6S696C1D1Ev();
Name_Map name_map_S696C1[] = {
  NSPAIR(_ZN6S696C1C1Ev),
  NSPAIR(_ZN6S696C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S696C5;
extern VTBL_ENTRY _ZTI6S696C5[];
extern  VTBL_ENTRY _ZTV6S696C5[];
extern Class_Descriptor cd_S696C4;
extern VTBL_ENTRY _ZTI6S696C4[];
extern  VTBL_ENTRY _ZTV6S696C4[];
extern Class_Descriptor cd_S696C3;
extern VTBL_ENTRY _ZTI6S696C3[];
extern  VTBL_ENTRY _ZTV6S696C3[];
extern Class_Descriptor cd_S696C2;
extern VTBL_ENTRY _ZTI6S696C2[];
extern  VTBL_ENTRY _ZTV6S696C2[];
static Base_Class bases_S696C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S696C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S696C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S696C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S696C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S696C1[];
extern void _ZN6S696C1D1Ev();
extern void _ZN6S696C1D0Ev();
extern void _ZN6S696C52v7Ev();
extern void _ZN6S696C52v8Ev();
extern void _ZN6S696C52v9Ev();
extern void _ZN6S696C53v10Ev();
extern void _ZN6S696C53v11Ev();
extern void _ZN6S696C53v12Ev();
extern void _ZN6S696C53v13Ev();
extern void _ZN6S696C53v14Ev();
extern void _ZN6S696C53v15Ev();
extern void _ZN6S696C53v16Ev();
extern void _ZN6S696C53v17Ev();
extern void _ZN6S696C53v18Ev();
extern void _ZN6S696C53v19Ev();
extern void _ZN6S696C53v20Ev();
extern void _ZN6S696C53v21Ev();
extern void _ZN6S696C53v22Ev();
extern void _ZN6S696C53v23Ev();
extern void _ZN6S696C53v24Ev();
extern void _ZN6S696C53v25Ev();
extern void _ZN6S696C53v26Ev();
extern void _ZN6S696C53v27Ev();
extern void _ZN6S696C53v28Ev();
extern void _ZN6S696C53v29Ev();
extern void _ZN6S696C53v30Ev();
extern void _ZN6S696C53v31Ev();
extern void _ZN6S696C53v32Ev();
extern void _ZN6S696C53v33Ev();
extern void _ZN6S696C53v34Ev();
extern void _ZN6S696C53v35Ev();
extern void _ZN6S696C53v36Ev();
extern void _ZN6S696C53v37Ev();
extern void _ZN6S696C53v38Ev();
extern void _ZN6S696C53v39Ev();
extern void _ZN6S696C53v40Ev();
extern void _ZN6S696C53v41Ev();
extern void _ZN6S696C53v42Ev();
extern void _ZN6S696C53v43Ev();
extern void _ZN6S696C53v44Ev();
extern void _ZN6S696C53v45Ev();
extern void _ZN6S696C53v46Ev();
extern void _ZN6S696C53v47Ev();
extern void _ZN6S696C53v48Ev();
extern void _ZN6S696C53v49Ev();
extern void _ZN6S696C53v50Ev();
extern void _ZN6S696C53v51Ev();
extern void _ZN6S696C53v52Ev();
extern void _ZN6S696C53v53Ev();
extern void _ZN6S696C53v54Ev();
extern void _ZN6S696C53v55Ev();
extern void _ZN6S696C53v56Ev();
extern void _ZN6S696C53v57Ev();
extern void _ZN6S696C53v58Ev();
extern void _ZN6S696C53v59Ev();
extern void _ZN6S696C53v60Ev();
extern void _ZN6S696C53v61Ev();
extern void _ZN6S696C53v62Ev();
extern void _ZN6S696C53v63Ev();
extern void _ZN6S696C53v64Ev();
extern void _ZN6S696C53v65Ev();
extern void _ZN6S696C53v66Ev();
extern void _ZN6S696C53v67Ev();
extern void _ZN6S696C53v68Ev();
extern void _ZN6S696C53v69Ev();
extern void _ZN6S696C53v70Ev();
extern void _ZN6S696C43v71Ev();
extern void _ZN6S696C43v72Ev();
extern void _ZN6S696C43v73Ev();
extern void _ZN6S696C43v74Ev();
extern void _ZN6S696C33v75Ev();
extern void _ZN6S696C33v76Ev();
extern void _ZN6S696C33v77Ev();
extern void _ZN6S696C33v78Ev();
extern void _ZN6S696C33v79Ev();
extern void _ZN6S696C33v80Ev();
extern void _ZN6S696C33v81Ev();
extern void _ZN6S696C33v82Ev();
extern void _ZN6S696C33v83Ev();
extern void _ZN6S696C33v84Ev();
extern void _ZN6S696C33v85Ev();
extern void _ZN6S696C33v86Ev();
extern void _ZN6S696C33v87Ev();
extern void _ZN6S696C33v88Ev();
extern void _ZN6S696C33v89Ev();
extern void _ZN6S696C33v90Ev();
extern void _ZN6S696C23v91Ev();
extern void _ZN6S696C23v92Ev();
extern void _ZN6S696C23v93Ev();
extern void _ZN6S696C23v94Ev();
extern void _ZN6S696C23v95Ev();
extern void _ZN6S696C23v96Ev();
extern void _ZN6S696C23v97Ev();
extern void _ZN6S696C23v98Ev();
extern void _ZN6S696C23v99Ev();
extern void _ZN6S696C24v100Ev();
extern void _ZN6S696C24v101Ev();
extern void _ZN6S696C24v102Ev();
extern void _ZN6S696C24v103Ev();
extern void _ZN6S696C24v104Ev();
extern void _ZN6S696C24v105Ev();
extern void _ZN6S696C24v106Ev();
extern void _ZN6S696C12v1Ev();
extern void _ZN6S696C12v2Ev();
extern void _ZN6S696C12v3Ev();
extern void _ZN6S696C12v4Ev();
extern void _ZN6S696C12v5Ev();
extern void _ZN6S696C12v6Ev();
static  VTBL_ENTRY vtc_S696C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S696C1[0]),
  (VTBL_ENTRY)&_ZN6S696C1D1Ev,
  (VTBL_ENTRY)&_ZN6S696C1D0Ev,
  (VTBL_ENTRY)&_ZN6S696C52v7Ev,
  (VTBL_ENTRY)&_ZN6S696C52v8Ev,
  (VTBL_ENTRY)&_ZN6S696C52v9Ev,
  (VTBL_ENTRY)&_ZN6S696C53v10Ev,
  (VTBL_ENTRY)&_ZN6S696C53v11Ev,
  (VTBL_ENTRY)&_ZN6S696C53v12Ev,
  (VTBL_ENTRY)&_ZN6S696C53v13Ev,
  (VTBL_ENTRY)&_ZN6S696C53v14Ev,
  (VTBL_ENTRY)&_ZN6S696C53v15Ev,
  (VTBL_ENTRY)&_ZN6S696C53v16Ev,
  (VTBL_ENTRY)&_ZN6S696C53v17Ev,
  (VTBL_ENTRY)&_ZN6S696C53v18Ev,
  (VTBL_ENTRY)&_ZN6S696C53v19Ev,
  (VTBL_ENTRY)&_ZN6S696C53v20Ev,
  (VTBL_ENTRY)&_ZN6S696C53v21Ev,
  (VTBL_ENTRY)&_ZN6S696C53v22Ev,
  (VTBL_ENTRY)&_ZN6S696C53v23Ev,
  (VTBL_ENTRY)&_ZN6S696C53v24Ev,
  (VTBL_ENTRY)&_ZN6S696C53v25Ev,
  (VTBL_ENTRY)&_ZN6S696C53v26Ev,
  (VTBL_ENTRY)&_ZN6S696C53v27Ev,
  (VTBL_ENTRY)&_ZN6S696C53v28Ev,
  (VTBL_ENTRY)&_ZN6S696C53v29Ev,
  (VTBL_ENTRY)&_ZN6S696C53v30Ev,
  (VTBL_ENTRY)&_ZN6S696C53v31Ev,
  (VTBL_ENTRY)&_ZN6S696C53v32Ev,
  (VTBL_ENTRY)&_ZN6S696C53v33Ev,
  (VTBL_ENTRY)&_ZN6S696C53v34Ev,
  (VTBL_ENTRY)&_ZN6S696C53v35Ev,
  (VTBL_ENTRY)&_ZN6S696C53v36Ev,
  (VTBL_ENTRY)&_ZN6S696C53v37Ev,
  (VTBL_ENTRY)&_ZN6S696C53v38Ev,
  (VTBL_ENTRY)&_ZN6S696C53v39Ev,
  (VTBL_ENTRY)&_ZN6S696C53v40Ev,
  (VTBL_ENTRY)&_ZN6S696C53v41Ev,
  (VTBL_ENTRY)&_ZN6S696C53v42Ev,
  (VTBL_ENTRY)&_ZN6S696C53v43Ev,
  (VTBL_ENTRY)&_ZN6S696C53v44Ev,
  (VTBL_ENTRY)&_ZN6S696C53v45Ev,
  (VTBL_ENTRY)&_ZN6S696C53v46Ev,
  (VTBL_ENTRY)&_ZN6S696C53v47Ev,
  (VTBL_ENTRY)&_ZN6S696C53v48Ev,
  (VTBL_ENTRY)&_ZN6S696C53v49Ev,
  (VTBL_ENTRY)&_ZN6S696C53v50Ev,
  (VTBL_ENTRY)&_ZN6S696C53v51Ev,
  (VTBL_ENTRY)&_ZN6S696C53v52Ev,
  (VTBL_ENTRY)&_ZN6S696C53v53Ev,
  (VTBL_ENTRY)&_ZN6S696C53v54Ev,
  (VTBL_ENTRY)&_ZN6S696C53v55Ev,
  (VTBL_ENTRY)&_ZN6S696C53v56Ev,
  (VTBL_ENTRY)&_ZN6S696C53v57Ev,
  (VTBL_ENTRY)&_ZN6S696C53v58Ev,
  (VTBL_ENTRY)&_ZN6S696C53v59Ev,
  (VTBL_ENTRY)&_ZN6S696C53v60Ev,
  (VTBL_ENTRY)&_ZN6S696C53v61Ev,
  (VTBL_ENTRY)&_ZN6S696C53v62Ev,
  (VTBL_ENTRY)&_ZN6S696C53v63Ev,
  (VTBL_ENTRY)&_ZN6S696C53v64Ev,
  (VTBL_ENTRY)&_ZN6S696C53v65Ev,
  (VTBL_ENTRY)&_ZN6S696C53v66Ev,
  (VTBL_ENTRY)&_ZN6S696C53v67Ev,
  (VTBL_ENTRY)&_ZN6S696C53v68Ev,
  (VTBL_ENTRY)&_ZN6S696C53v69Ev,
  (VTBL_ENTRY)&_ZN6S696C53v70Ev,
  (VTBL_ENTRY)&_ZN6S696C43v71Ev,
  (VTBL_ENTRY)&_ZN6S696C43v72Ev,
  (VTBL_ENTRY)&_ZN6S696C43v73Ev,
  (VTBL_ENTRY)&_ZN6S696C43v74Ev,
  (VTBL_ENTRY)&_ZN6S696C33v75Ev,
  (VTBL_ENTRY)&_ZN6S696C33v76Ev,
  (VTBL_ENTRY)&_ZN6S696C33v77Ev,
  (VTBL_ENTRY)&_ZN6S696C33v78Ev,
  (VTBL_ENTRY)&_ZN6S696C33v79Ev,
  (VTBL_ENTRY)&_ZN6S696C33v80Ev,
  (VTBL_ENTRY)&_ZN6S696C33v81Ev,
  (VTBL_ENTRY)&_ZN6S696C33v82Ev,
  (VTBL_ENTRY)&_ZN6S696C33v83Ev,
  (VTBL_ENTRY)&_ZN6S696C33v84Ev,
  (VTBL_ENTRY)&_ZN6S696C33v85Ev,
  (VTBL_ENTRY)&_ZN6S696C33v86Ev,
  (VTBL_ENTRY)&_ZN6S696C33v87Ev,
  (VTBL_ENTRY)&_ZN6S696C33v88Ev,
  (VTBL_ENTRY)&_ZN6S696C33v89Ev,
  (VTBL_ENTRY)&_ZN6S696C33v90Ev,
  (VTBL_ENTRY)&_ZN6S696C23v91Ev,
  (VTBL_ENTRY)&_ZN6S696C23v92Ev,
  (VTBL_ENTRY)&_ZN6S696C23v93Ev,
  (VTBL_ENTRY)&_ZN6S696C23v94Ev,
  (VTBL_ENTRY)&_ZN6S696C23v95Ev,
  (VTBL_ENTRY)&_ZN6S696C23v96Ev,
  (VTBL_ENTRY)&_ZN6S696C23v97Ev,
  (VTBL_ENTRY)&_ZN6S696C23v98Ev,
  (VTBL_ENTRY)&_ZN6S696C23v99Ev,
  (VTBL_ENTRY)&_ZN6S696C24v100Ev,
  (VTBL_ENTRY)&_ZN6S696C24v101Ev,
  (VTBL_ENTRY)&_ZN6S696C24v102Ev,
  (VTBL_ENTRY)&_ZN6S696C24v103Ev,
  (VTBL_ENTRY)&_ZN6S696C24v104Ev,
  (VTBL_ENTRY)&_ZN6S696C24v105Ev,
  (VTBL_ENTRY)&_ZN6S696C24v106Ev,
  (VTBL_ENTRY)&_ZN6S696C12v1Ev,
  (VTBL_ENTRY)&_ZN6S696C12v2Ev,
  (VTBL_ENTRY)&_ZN6S696C12v3Ev,
  (VTBL_ENTRY)&_ZN6S696C12v4Ev,
  (VTBL_ENTRY)&_ZN6S696C12v5Ev,
  (VTBL_ENTRY)&_ZN6S696C12v6Ev,
};
extern VTBL_ENTRY _ZTI6S696C1[];
extern  VTBL_ENTRY _ZTV6S696C1[];
Class_Descriptor cd_S696C1 = {  "S696C1", // class name
  bases_S696C1, 4,
  &(vtc_S696C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(384,272), // object size
  NSPAIRA(_ZTI6S696C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S696C1),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S673C5  {
  int s673c5f0;
  __tsi64 s673c5f1;
  void *s673c5f2[4];
  int s673c5f3[2];
  void *s673c5f4;
  ::S695C22_nt s673c5f5;
  void *s673c5f6[2];
  virtual  ~S673C5(); // _ZN6S673C5D1Ev
  virtual void  v6(); // _ZN6S673C52v6Ev
  virtual void  v7(); // _ZN6S673C52v7Ev
  virtual void  v8(); // _ZN6S673C52v8Ev
  virtual void  v9(); // _ZN6S673C52v9Ev
  virtual void  v10(); // _ZN6S673C53v10Ev
  virtual void  v11(); // _ZN6S673C53v11Ev
  virtual void  v12(); // _ZN6S673C53v12Ev
  virtual void  v13(); // _ZN6S673C53v13Ev
  virtual void  v14(); // _ZN6S673C53v14Ev
  virtual void  v15(); // _ZN6S673C53v15Ev
  virtual void  v16(); // _ZN6S673C53v16Ev
  virtual void  v17(); // _ZN6S673C53v17Ev
  virtual void  v18(); // _ZN6S673C53v18Ev
  virtual void  v19(); // _ZN6S673C53v19Ev
  virtual void  v20(); // _ZN6S673C53v20Ev
  virtual void  v21(); // _ZN6S673C53v21Ev
  virtual void  v22(); // _ZN6S673C53v22Ev
  virtual void  v23(); // _ZN6S673C53v23Ev
  virtual void  v24(); // _ZN6S673C53v24Ev
  virtual void  v25(); // _ZN6S673C53v25Ev
  virtual void  v26(); // _ZN6S673C53v26Ev
  virtual void  v27(); // _ZN6S673C53v27Ev
  virtual void  v28(); // _ZN6S673C53v28Ev
  virtual void  v29(); // _ZN6S673C53v29Ev
  virtual void  v30(); // _ZN6S673C53v30Ev
  virtual void  v31(); // _ZN6S673C53v31Ev
  virtual void  v32(); // _ZN6S673C53v32Ev
  virtual void  v33(); // _ZN6S673C53v33Ev
  virtual void  v34(); // _ZN6S673C53v34Ev
  virtual void  v35(); // _ZN6S673C53v35Ev
  virtual void  v36(); // _ZN6S673C53v36Ev
  virtual void  v37(); // _ZN6S673C53v37Ev
  virtual void  v38(); // _ZN6S673C53v38Ev
  virtual void  v39(); // _ZN6S673C53v39Ev
  virtual void  v40(); // _ZN6S673C53v40Ev
  virtual void  v41(); // _ZN6S673C53v41Ev
  virtual void  v42(); // _ZN6S673C53v42Ev
  virtual void  v43(); // _ZN6S673C53v43Ev
  virtual void  v44(); // _ZN6S673C53v44Ev
  virtual void  v45(); // _ZN6S673C53v45Ev
  virtual void  v46(); // _ZN6S673C53v46Ev
  virtual void  v47(); // _ZN6S673C53v47Ev
  virtual void  v48(); // _ZN6S673C53v48Ev
  virtual void  v49(); // _ZN6S673C53v49Ev
  virtual void  v50(); // _ZN6S673C53v50Ev
  virtual void  v51(); // _ZN6S673C53v51Ev
  virtual void  v52(); // _ZN6S673C53v52Ev
  virtual void  v53(); // _ZN6S673C53v53Ev
  virtual void  v54(); // _ZN6S673C53v54Ev
  virtual void  v55(); // _ZN6S673C53v55Ev
  virtual void  v56(); // _ZN6S673C53v56Ev
  virtual void  v57(); // _ZN6S673C53v57Ev
  virtual void  v58(); // _ZN6S673C53v58Ev
  virtual void  v59(); // _ZN6S673C53v59Ev
  virtual void  v60(); // _ZN6S673C53v60Ev
  virtual void  v61(); // _ZN6S673C53v61Ev
  virtual void  v62(); // _ZN6S673C53v62Ev
  virtual void  v63(); // _ZN6S673C53v63Ev
  virtual void  v64(); // _ZN6S673C53v64Ev
  virtual void  v65(); // _ZN6S673C53v65Ev
  virtual void  v66(); // _ZN6S673C53v66Ev
  virtual void  v67(); // _ZN6S673C53v67Ev
  virtual void  v68(); // _ZN6S673C53v68Ev
  virtual void  v69(); // _ZN6S673C53v69Ev
  S673C5(); // tgen
};
//SIG(-1 S673C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S673C5 ::~S673C5(){ note_dtor("S673C5", this);}
void  S673C5 ::v6(){vfunc_called(this, "_ZN6S673C52v6Ev");}
void  S673C5 ::v7(){vfunc_called(this, "_ZN6S673C52v7Ev");}
void  S673C5 ::v8(){vfunc_called(this, "_ZN6S673C52v8Ev");}
void  S673C5 ::v9(){vfunc_called(this, "_ZN6S673C52v9Ev");}
void  S673C5 ::v10(){vfunc_called(this, "_ZN6S673C53v10Ev");}
void  S673C5 ::v11(){vfunc_called(this, "_ZN6S673C53v11Ev");}
void  S673C5 ::v12(){vfunc_called(this, "_ZN6S673C53v12Ev");}
void  S673C5 ::v13(){vfunc_called(this, "_ZN6S673C53v13Ev");}
void  S673C5 ::v14(){vfunc_called(this, "_ZN6S673C53v14Ev");}
void  S673C5 ::v15(){vfunc_called(this, "_ZN6S673C53v15Ev");}
void  S673C5 ::v16(){vfunc_called(this, "_ZN6S673C53v16Ev");}
void  S673C5 ::v17(){vfunc_called(this, "_ZN6S673C53v17Ev");}
void  S673C5 ::v18(){vfunc_called(this, "_ZN6S673C53v18Ev");}
void  S673C5 ::v19(){vfunc_called(this, "_ZN6S673C53v19Ev");}
void  S673C5 ::v20(){vfunc_called(this, "_ZN6S673C53v20Ev");}
void  S673C5 ::v21(){vfunc_called(this, "_ZN6S673C53v21Ev");}
void  S673C5 ::v22(){vfunc_called(this, "_ZN6S673C53v22Ev");}
void  S673C5 ::v23(){vfunc_called(this, "_ZN6S673C53v23Ev");}
void  S673C5 ::v24(){vfunc_called(this, "_ZN6S673C53v24Ev");}
void  S673C5 ::v25(){vfunc_called(this, "_ZN6S673C53v25Ev");}
void  S673C5 ::v26(){vfunc_called(this, "_ZN6S673C53v26Ev");}
void  S673C5 ::v27(){vfunc_called(this, "_ZN6S673C53v27Ev");}
void  S673C5 ::v28(){vfunc_called(this, "_ZN6S673C53v28Ev");}
void  S673C5 ::v29(){vfunc_called(this, "_ZN6S673C53v29Ev");}
void  S673C5 ::v30(){vfunc_called(this, "_ZN6S673C53v30Ev");}
void  S673C5 ::v31(){vfunc_called(this, "_ZN6S673C53v31Ev");}
void  S673C5 ::v32(){vfunc_called(this, "_ZN6S673C53v32Ev");}
void  S673C5 ::v33(){vfunc_called(this, "_ZN6S673C53v33Ev");}
void  S673C5 ::v34(){vfunc_called(this, "_ZN6S673C53v34Ev");}
void  S673C5 ::v35(){vfunc_called(this, "_ZN6S673C53v35Ev");}
void  S673C5 ::v36(){vfunc_called(this, "_ZN6S673C53v36Ev");}
void  S673C5 ::v37(){vfunc_called(this, "_ZN6S673C53v37Ev");}
void  S673C5 ::v38(){vfunc_called(this, "_ZN6S673C53v38Ev");}
void  S673C5 ::v39(){vfunc_called(this, "_ZN6S673C53v39Ev");}
void  S673C5 ::v40(){vfunc_called(this, "_ZN6S673C53v40Ev");}
void  S673C5 ::v41(){vfunc_called(this, "_ZN6S673C53v41Ev");}
void  S673C5 ::v42(){vfunc_called(this, "_ZN6S673C53v42Ev");}
void  S673C5 ::v43(){vfunc_called(this, "_ZN6S673C53v43Ev");}
void  S673C5 ::v44(){vfunc_called(this, "_ZN6S673C53v44Ev");}
void  S673C5 ::v45(){vfunc_called(this, "_ZN6S673C53v45Ev");}
void  S673C5 ::v46(){vfunc_called(this, "_ZN6S673C53v46Ev");}
void  S673C5 ::v47(){vfunc_called(this, "_ZN6S673C53v47Ev");}
void  S673C5 ::v48(){vfunc_called(this, "_ZN6S673C53v48Ev");}
void  S673C5 ::v49(){vfunc_called(this, "_ZN6S673C53v49Ev");}
void  S673C5 ::v50(){vfunc_called(this, "_ZN6S673C53v50Ev");}
void  S673C5 ::v51(){vfunc_called(this, "_ZN6S673C53v51Ev");}
void  S673C5 ::v52(){vfunc_called(this, "_ZN6S673C53v52Ev");}
void  S673C5 ::v53(){vfunc_called(this, "_ZN6S673C53v53Ev");}
void  S673C5 ::v54(){vfunc_called(this, "_ZN6S673C53v54Ev");}
void  S673C5 ::v55(){vfunc_called(this, "_ZN6S673C53v55Ev");}
void  S673C5 ::v56(){vfunc_called(this, "_ZN6S673C53v56Ev");}
void  S673C5 ::v57(){vfunc_called(this, "_ZN6S673C53v57Ev");}
void  S673C5 ::v58(){vfunc_called(this, "_ZN6S673C53v58Ev");}
void  S673C5 ::v59(){vfunc_called(this, "_ZN6S673C53v59Ev");}
void  S673C5 ::v60(){vfunc_called(this, "_ZN6S673C53v60Ev");}
void  S673C5 ::v61(){vfunc_called(this, "_ZN6S673C53v61Ev");}
void  S673C5 ::v62(){vfunc_called(this, "_ZN6S673C53v62Ev");}
void  S673C5 ::v63(){vfunc_called(this, "_ZN6S673C53v63Ev");}
void  S673C5 ::v64(){vfunc_called(this, "_ZN6S673C53v64Ev");}
void  S673C5 ::v65(){vfunc_called(this, "_ZN6S673C53v65Ev");}
void  S673C5 ::v66(){vfunc_called(this, "_ZN6S673C53v66Ev");}
void  S673C5 ::v67(){vfunc_called(this, "_ZN6S673C53v67Ev");}
void  S673C5 ::v68(){vfunc_called(this, "_ZN6S673C53v68Ev");}
void  S673C5 ::v69(){vfunc_called(this, "_ZN6S673C53v69Ev");}
S673C5 ::S673C5(){ note_ctor("S673C5", this);} // tgen

static void Test_S673C5()
{
  extern Class_Descriptor cd_S673C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S673C5, buf);
    S673C5 *dp, &lv = *(dp=new (buf) S673C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S673C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S673C5)");
    check_field_offset(lv, s673c5f0, ABISELECT(8,4), "S673C5.s673c5f0");
    check_field_offset(lv, s673c5f1, ABISELECT(16,8), "S673C5.s673c5f1");
    check_field_offset(lv, s673c5f2, ABISELECT(24,16), "S673C5.s673c5f2");
    check_field_offset(lv, s673c5f3, ABISELECT(56,32), "S673C5.s673c5f3");
    check_field_offset(lv, s673c5f4, ABISELECT(64,40), "S673C5.s673c5f4");
    check_field_offset(lv, s673c5f5, ABISELECT(72,44), "S673C5.s673c5f5");
    check_field_offset(lv, s673c5f6, ABISELECT(80,52), "S673C5.s673c5f6");
    test_class_info(&lv, &cd_S673C5);
    dp->~S673C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS673C5(Test_S673C5, "S673C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S673C5C1Ev();
extern void _ZN6S673C5D1Ev();
Name_Map name_map_S673C5[] = {
  NSPAIR(_ZN6S673C5C1Ev),
  NSPAIR(_ZN6S673C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S673C5[];
extern void _ZN6S673C5D1Ev();
extern void _ZN6S673C5D0Ev();
extern void _ZN6S673C52v6Ev();
extern void _ZN6S673C52v7Ev();
extern void _ZN6S673C52v8Ev();
extern void _ZN6S673C52v9Ev();
extern void _ZN6S673C53v10Ev();
extern void _ZN6S673C53v11Ev();
extern void _ZN6S673C53v12Ev();
extern void _ZN6S673C53v13Ev();
extern void _ZN6S673C53v14Ev();
extern void _ZN6S673C53v15Ev();
extern void _ZN6S673C53v16Ev();
extern void _ZN6S673C53v17Ev();
extern void _ZN6S673C53v18Ev();
extern void _ZN6S673C53v19Ev();
extern void _ZN6S673C53v20Ev();
extern void _ZN6S673C53v21Ev();
extern void _ZN6S673C53v22Ev();
extern void _ZN6S673C53v23Ev();
extern void _ZN6S673C53v24Ev();
extern void _ZN6S673C53v25Ev();
extern void _ZN6S673C53v26Ev();
extern void _ZN6S673C53v27Ev();
extern void _ZN6S673C53v28Ev();
extern void _ZN6S673C53v29Ev();
extern void _ZN6S673C53v30Ev();
extern void _ZN6S673C53v31Ev();
extern void _ZN6S673C53v32Ev();
extern void _ZN6S673C53v33Ev();
extern void _ZN6S673C53v34Ev();
extern void _ZN6S673C53v35Ev();
extern void _ZN6S673C53v36Ev();
extern void _ZN6S673C53v37Ev();
extern void _ZN6S673C53v38Ev();
extern void _ZN6S673C53v39Ev();
extern void _ZN6S673C53v40Ev();
extern void _ZN6S673C53v41Ev();
extern void _ZN6S673C53v42Ev();
extern void _ZN6S673C53v43Ev();
extern void _ZN6S673C53v44Ev();
extern void _ZN6S673C53v45Ev();
extern void _ZN6S673C53v46Ev();
extern void _ZN6S673C53v47Ev();
extern void _ZN6S673C53v48Ev();
extern void _ZN6S673C53v49Ev();
extern void _ZN6S673C53v50Ev();
extern void _ZN6S673C53v51Ev();
extern void _ZN6S673C53v52Ev();
extern void _ZN6S673C53v53Ev();
extern void _ZN6S673C53v54Ev();
extern void _ZN6S673C53v55Ev();
extern void _ZN6S673C53v56Ev();
extern void _ZN6S673C53v57Ev();
extern void _ZN6S673C53v58Ev();
extern void _ZN6S673C53v59Ev();
extern void _ZN6S673C53v60Ev();
extern void _ZN6S673C53v61Ev();
extern void _ZN6S673C53v62Ev();
extern void _ZN6S673C53v63Ev();
extern void _ZN6S673C53v64Ev();
extern void _ZN6S673C53v65Ev();
extern void _ZN6S673C53v66Ev();
extern void _ZN6S673C53v67Ev();
extern void _ZN6S673C53v68Ev();
extern void _ZN6S673C53v69Ev();
static  VTBL_ENTRY vtc_S673C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S673C5[0]),
  (VTBL_ENTRY)&_ZN6S673C5D1Ev,
  (VTBL_ENTRY)&_ZN6S673C5D0Ev,
  (VTBL_ENTRY)&_ZN6S673C52v6Ev,
  (VTBL_ENTRY)&_ZN6S673C52v7Ev,
  (VTBL_ENTRY)&_ZN6S673C52v8Ev,
  (VTBL_ENTRY)&_ZN6S673C52v9Ev,
  (VTBL_ENTRY)&_ZN6S673C53v10Ev,
  (VTBL_ENTRY)&_ZN6S673C53v11Ev,
  (VTBL_ENTRY)&_ZN6S673C53v12Ev,
  (VTBL_ENTRY)&_ZN6S673C53v13Ev,
  (VTBL_ENTRY)&_ZN6S673C53v14Ev,
  (VTBL_ENTRY)&_ZN6S673C53v15Ev,
  (VTBL_ENTRY)&_ZN6S673C53v16Ev,
  (VTBL_ENTRY)&_ZN6S673C53v17Ev,
  (VTBL_ENTRY)&_ZN6S673C53v18Ev,
  (VTBL_ENTRY)&_ZN6S673C53v19Ev,
  (VTBL_ENTRY)&_ZN6S673C53v20Ev,
  (VTBL_ENTRY)&_ZN6S673C53v21Ev,
  (VTBL_ENTRY)&_ZN6S673C53v22Ev,
  (VTBL_ENTRY)&_ZN6S673C53v23Ev,
  (VTBL_ENTRY)&_ZN6S673C53v24Ev,
  (VTBL_ENTRY)&_ZN6S673C53v25Ev,
  (VTBL_ENTRY)&_ZN6S673C53v26Ev,
  (VTBL_ENTRY)&_ZN6S673C53v27Ev,
  (VTBL_ENTRY)&_ZN6S673C53v28Ev,
  (VTBL_ENTRY)&_ZN6S673C53v29Ev,
  (VTBL_ENTRY)&_ZN6S673C53v30Ev,
  (VTBL_ENTRY)&_ZN6S673C53v31Ev,
  (VTBL_ENTRY)&_ZN6S673C53v32Ev,
  (VTBL_ENTRY)&_ZN6S673C53v33Ev,
  (VTBL_ENTRY)&_ZN6S673C53v34Ev,
  (VTBL_ENTRY)&_ZN6S673C53v35Ev,
  (VTBL_ENTRY)&_ZN6S673C53v36Ev,
  (VTBL_ENTRY)&_ZN6S673C53v37Ev,
  (VTBL_ENTRY)&_ZN6S673C53v38Ev,
  (VTBL_ENTRY)&_ZN6S673C53v39Ev,
  (VTBL_ENTRY)&_ZN6S673C53v40Ev,
  (VTBL_ENTRY)&_ZN6S673C53v41Ev,
  (VTBL_ENTRY)&_ZN6S673C53v42Ev,
  (VTBL_ENTRY)&_ZN6S673C53v43Ev,
  (VTBL_ENTRY)&_ZN6S673C53v44Ev,
  (VTBL_ENTRY)&_ZN6S673C53v45Ev,
  (VTBL_ENTRY)&_ZN6S673C53v46Ev,
  (VTBL_ENTRY)&_ZN6S673C53v47Ev,
  (VTBL_ENTRY)&_ZN6S673C53v48Ev,
  (VTBL_ENTRY)&_ZN6S673C53v49Ev,
  (VTBL_ENTRY)&_ZN6S673C53v50Ev,
  (VTBL_ENTRY)&_ZN6S673C53v51Ev,
  (VTBL_ENTRY)&_ZN6S673C53v52Ev,
  (VTBL_ENTRY)&_ZN6S673C53v53Ev,
  (VTBL_ENTRY)&_ZN6S673C53v54Ev,
  (VTBL_ENTRY)&_ZN6S673C53v55Ev,
  (VTBL_ENTRY)&_ZN6S673C53v56Ev,
  (VTBL_ENTRY)&_ZN6S673C53v57Ev,
  (VTBL_ENTRY)&_ZN6S673C53v58Ev,
  (VTBL_ENTRY)&_ZN6S673C53v59Ev,
  (VTBL_ENTRY)&_ZN6S673C53v60Ev,
  (VTBL_ENTRY)&_ZN6S673C53v61Ev,
  (VTBL_ENTRY)&_ZN6S673C53v62Ev,
  (VTBL_ENTRY)&_ZN6S673C53v63Ev,
  (VTBL_ENTRY)&_ZN6S673C53v64Ev,
  (VTBL_ENTRY)&_ZN6S673C53v65Ev,
  (VTBL_ENTRY)&_ZN6S673C53v66Ev,
  (VTBL_ENTRY)&_ZN6S673C53v67Ev,
  (VTBL_ENTRY)&_ZN6S673C53v68Ev,
  (VTBL_ENTRY)&_ZN6S673C53v69Ev,
};
extern VTBL_ENTRY _ZTI6S673C5[];
extern  VTBL_ENTRY _ZTV6S673C5[];
Class_Descriptor cd_S673C5 = {  "S673C5", // class name
  0,0,//no base classes
  &(vtc_S673C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S673C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S673C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S673C4  : S673C5 {
  virtual  ~S673C4(); // _ZN6S673C4D1Ev
  virtual void  v70(); // _ZN6S673C43v70Ev
  virtual void  v71(); // _ZN6S673C43v71Ev
  virtual void  v72(); // _ZN6S673C43v72Ev
  virtual void  v73(); // _ZN6S673C43v73Ev
  S673C4(); // tgen
};
//SIG(-1 S673C4) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S673C4 ::~S673C4(){ note_dtor("S673C4", this);}
void  S673C4 ::v70(){vfunc_called(this, "_ZN6S673C43v70Ev");}
void  S673C4 ::v71(){vfunc_called(this, "_ZN6S673C43v71Ev");}
void  S673C4 ::v72(){vfunc_called(this, "_ZN6S673C43v72Ev");}
void  S673C4 ::v73(){vfunc_called(this, "_ZN6S673C43v73Ev");}
S673C4 ::S673C4(){ note_ctor("S673C4", this);} // tgen

static void Test_S673C4()
{
  extern Class_Descriptor cd_S673C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S673C4, buf);
    S673C4 *dp, &lv = *(dp=new (buf) S673C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S673C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S673C4)");
    check_base_class_offset(lv, (S673C5*), 0, "S673C4");
    test_class_info(&lv, &cd_S673C4);
    dp->~S673C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS673C4(Test_S673C4, "S673C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S673C4C1Ev();
extern void _ZN6S673C4D1Ev();
Name_Map name_map_S673C4[] = {
  NSPAIR(_ZN6S673C4C1Ev),
  NSPAIR(_ZN6S673C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S673C5;
extern VTBL_ENTRY _ZTI6S673C5[];
extern  VTBL_ENTRY _ZTV6S673C5[];
static Base_Class bases_S673C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S673C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S673C4[];
extern void _ZN6S673C4D1Ev();
extern void _ZN6S673C4D0Ev();
extern void _ZN6S673C52v6Ev();
extern void _ZN6S673C52v7Ev();
extern void _ZN6S673C52v8Ev();
extern void _ZN6S673C52v9Ev();
extern void _ZN6S673C53v10Ev();
extern void _ZN6S673C53v11Ev();
extern void _ZN6S673C53v12Ev();
extern void _ZN6S673C53v13Ev();
extern void _ZN6S673C53v14Ev();
extern void _ZN6S673C53v15Ev();
extern void _ZN6S673C53v16Ev();
extern void _ZN6S673C53v17Ev();
extern void _ZN6S673C53v18Ev();
extern void _ZN6S673C53v19Ev();
extern void _ZN6S673C53v20Ev();
extern void _ZN6S673C53v21Ev();
extern void _ZN6S673C53v22Ev();
extern void _ZN6S673C53v23Ev();
extern void _ZN6S673C53v24Ev();
extern void _ZN6S673C53v25Ev();
extern void _ZN6S673C53v26Ev();
extern void _ZN6S673C53v27Ev();
extern void _ZN6S673C53v28Ev();
extern void _ZN6S673C53v29Ev();
extern void _ZN6S673C53v30Ev();
extern void _ZN6S673C53v31Ev();
extern void _ZN6S673C53v32Ev();
extern void _ZN6S673C53v33Ev();
extern void _ZN6S673C53v34Ev();
extern void _ZN6S673C53v35Ev();
extern void _ZN6S673C53v36Ev();
extern void _ZN6S673C53v37Ev();
extern void _ZN6S673C53v38Ev();
extern void _ZN6S673C53v39Ev();
extern void _ZN6S673C53v40Ev();
extern void _ZN6S673C53v41Ev();
extern void _ZN6S673C53v42Ev();
extern void _ZN6S673C53v43Ev();
extern void _ZN6S673C53v44Ev();
extern void _ZN6S673C53v45Ev();
extern void _ZN6S673C53v46Ev();
extern void _ZN6S673C53v47Ev();
extern void _ZN6S673C53v48Ev();
extern void _ZN6S673C53v49Ev();
extern void _ZN6S673C53v50Ev();
extern void _ZN6S673C53v51Ev();
extern void _ZN6S673C53v52Ev();
extern void _ZN6S673C53v53Ev();
extern void _ZN6S673C53v54Ev();
extern void _ZN6S673C53v55Ev();
extern void _ZN6S673C53v56Ev();
extern void _ZN6S673C53v57Ev();
extern void _ZN6S673C53v58Ev();
extern void _ZN6S673C53v59Ev();
extern void _ZN6S673C53v60Ev();
extern void _ZN6S673C53v61Ev();
extern void _ZN6S673C53v62Ev();
extern void _ZN6S673C53v63Ev();
extern void _ZN6S673C53v64Ev();
extern void _ZN6S673C53v65Ev();
extern void _ZN6S673C53v66Ev();
extern void _ZN6S673C53v67Ev();
extern void _ZN6S673C53v68Ev();
extern void _ZN6S673C53v69Ev();
extern void _ZN6S673C43v70Ev();
extern void _ZN6S673C43v71Ev();
extern void _ZN6S673C43v72Ev();
extern void _ZN6S673C43v73Ev();
static  VTBL_ENTRY vtc_S673C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S673C4[0]),
  (VTBL_ENTRY)&_ZN6S673C4D1Ev,
  (VTBL_ENTRY)&_ZN6S673C4D0Ev,
  (VTBL_ENTRY)&_ZN6S673C52v6Ev,
  (VTBL_ENTRY)&_ZN6S673C52v7Ev,
  (VTBL_ENTRY)&_ZN6S673C52v8Ev,
  (VTBL_ENTRY)&_ZN6S673C52v9Ev,
  (VTBL_ENTRY)&_ZN6S673C53v10Ev,
  (VTBL_ENTRY)&_ZN6S673C53v11Ev,
  (VTBL_ENTRY)&_ZN6S673C53v12Ev,
  (VTBL_ENTRY)&_ZN6S673C53v13Ev,
  (VTBL_ENTRY)&_ZN6S673C53v14Ev,
  (VTBL_ENTRY)&_ZN6S673C53v15Ev,
  (VTBL_ENTRY)&_ZN6S673C53v16Ev,
  (VTBL_ENTRY)&_ZN6S673C53v17Ev,
  (VTBL_ENTRY)&_ZN6S673C53v18Ev,
  (VTBL_ENTRY)&_ZN6S673C53v19Ev,
  (VTBL_ENTRY)&_ZN6S673C53v20Ev,
  (VTBL_ENTRY)&_ZN6S673C53v21Ev,
  (VTBL_ENTRY)&_ZN6S673C53v22Ev,
  (VTBL_ENTRY)&_ZN6S673C53v23Ev,
  (VTBL_ENTRY)&_ZN6S673C53v24Ev,
  (VTBL_ENTRY)&_ZN6S673C53v25Ev,
  (VTBL_ENTRY)&_ZN6S673C53v26Ev,
  (VTBL_ENTRY)&_ZN6S673C53v27Ev,
  (VTBL_ENTRY)&_ZN6S673C53v28Ev,
  (VTBL_ENTRY)&_ZN6S673C53v29Ev,
  (VTBL_ENTRY)&_ZN6S673C53v30Ev,
  (VTBL_ENTRY)&_ZN6S673C53v31Ev,
  (VTBL_ENTRY)&_ZN6S673C53v32Ev,
  (VTBL_ENTRY)&_ZN6S673C53v33Ev,
  (VTBL_ENTRY)&_ZN6S673C53v34Ev,
  (VTBL_ENTRY)&_ZN6S673C53v35Ev,
  (VTBL_ENTRY)&_ZN6S673C53v36Ev,
  (VTBL_ENTRY)&_ZN6S673C53v37Ev,
  (VTBL_ENTRY)&_ZN6S673C53v38Ev,
  (VTBL_ENTRY)&_ZN6S673C53v39Ev,
  (VTBL_ENTRY)&_ZN6S673C53v40Ev,
  (VTBL_ENTRY)&_ZN6S673C53v41Ev,
  (VTBL_ENTRY)&_ZN6S673C53v42Ev,
  (VTBL_ENTRY)&_ZN6S673C53v43Ev,
  (VTBL_ENTRY)&_ZN6S673C53v44Ev,
  (VTBL_ENTRY)&_ZN6S673C53v45Ev,
  (VTBL_ENTRY)&_ZN6S673C53v46Ev,
  (VTBL_ENTRY)&_ZN6S673C53v47Ev,
  (VTBL_ENTRY)&_ZN6S673C53v48Ev,
  (VTBL_ENTRY)&_ZN6S673C53v49Ev,
  (VTBL_ENTRY)&_ZN6S673C53v50Ev,
  (VTBL_ENTRY)&_ZN6S673C53v51Ev,
  (VTBL_ENTRY)&_ZN6S673C53v52Ev,
  (VTBL_ENTRY)&_ZN6S673C53v53Ev,
  (VTBL_ENTRY)&_ZN6S673C53v54Ev,
  (VTBL_ENTRY)&_ZN6S673C53v55Ev,
  (VTBL_ENTRY)&_ZN6S673C53v56Ev,
  (VTBL_ENTRY)&_ZN6S673C53v57Ev,
  (VTBL_ENTRY)&_ZN6S673C53v58Ev,
  (VTBL_ENTRY)&_ZN6S673C53v59Ev,
  (VTBL_ENTRY)&_ZN6S673C53v60Ev,
  (VTBL_ENTRY)&_ZN6S673C53v61Ev,
  (VTBL_ENTRY)&_ZN6S673C53v62Ev,
  (VTBL_ENTRY)&_ZN6S673C53v63Ev,
  (VTBL_ENTRY)&_ZN6S673C53v64Ev,
  (VTBL_ENTRY)&_ZN6S673C53v65Ev,
  (VTBL_ENTRY)&_ZN6S673C53v66Ev,
  (VTBL_ENTRY)&_ZN6S673C53v67Ev,
  (VTBL_ENTRY)&_ZN6S673C53v68Ev,
  (VTBL_ENTRY)&_ZN6S673C53v69Ev,
  (VTBL_ENTRY)&_ZN6S673C43v70Ev,
  (VTBL_ENTRY)&_ZN6S673C43v71Ev,
  (VTBL_ENTRY)&_ZN6S673C43v72Ev,
  (VTBL_ENTRY)&_ZN6S673C43v73Ev,
};
extern VTBL_ENTRY _ZTI6S673C4[];
extern  VTBL_ENTRY _ZTV6S673C4[];
Class_Descriptor cd_S673C4 = {  "S673C4", // class name
  bases_S673C4, 1,
  &(vtc_S673C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S673C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S673C4),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S673C3  : S673C4 {
  unsigned int s673c3f0:1;
  unsigned int s673c3f1:1;
  unsigned int s673c3f2:1;
  unsigned int s673c3f3:1;
  unsigned int s673c3f4:1;
  unsigned int s673c3f5:1;
  unsigned int s673c3f6:1;
  unsigned int s673c3f7:1;
  unsigned int s673c3f8:1;
  unsigned int s673c3f9:1;
  unsigned int s673c3f10:1;
  unsigned int s673c3f11:1;
  unsigned int s673c3f12:1;
  int s673c3f13[8];
  ::S507C7 s673c3f14;
  unsigned int s673c3f15:1;
  char s673c3f16;
  char s673c3f17[2];
  int s673c3f18[2];
  ::S685C27_nt s673c3f19;
  ::S685C27_nt s673c3f20;
  void *s673c3f21;
  virtual  ~S673C3(); // _ZN6S673C3D1Ev
  virtual void  v74(); // _ZN6S673C33v74Ev
  virtual void  v75(); // _ZN6S673C33v75Ev
  virtual void  v76(); // _ZN6S673C33v76Ev
  virtual void  v77(); // _ZN6S673C33v77Ev
  virtual void  v78(); // _ZN6S673C33v78Ev
  virtual void  v79(); // _ZN6S673C33v79Ev
  virtual void  v80(); // _ZN6S673C33v80Ev
  virtual void  v81(); // _ZN6S673C33v81Ev
  virtual void  v82(); // _ZN6S673C33v82Ev
  virtual void  v83(); // _ZN6S673C33v83Ev
  virtual void  v84(); // _ZN6S673C33v84Ev
  virtual void  v85(); // _ZN6S673C33v85Ev
  virtual void  v86(); // _ZN6S673C33v86Ev
  virtual void  v87(); // _ZN6S673C33v87Ev
  virtual void  v88(); // _ZN6S673C33v88Ev
  virtual void  v89(); // _ZN6S673C33v89Ev
  S673C3(); // tgen
};
//SIG(-1 S673C3) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC5{ BC6{ vd v87 v88 v89 v90 v91 Fi[8] Fp Fi Fp} v85 v86} Fi:1 Fc[3] Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 Fp}


 S673C3 ::~S673C3(){ note_dtor("S673C3", this);}
void  S673C3 ::v74(){vfunc_called(this, "_ZN6S673C33v74Ev");}
void  S673C3 ::v75(){vfunc_called(this, "_ZN6S673C33v75Ev");}
void  S673C3 ::v76(){vfunc_called(this, "_ZN6S673C33v76Ev");}
void  S673C3 ::v77(){vfunc_called(this, "_ZN6S673C33v77Ev");}
void  S673C3 ::v78(){vfunc_called(this, "_ZN6S673C33v78Ev");}
void  S673C3 ::v79(){vfunc_called(this, "_ZN6S673C33v79Ev");}
void  S673C3 ::v80(){vfunc_called(this, "_ZN6S673C33v80Ev");}
void  S673C3 ::v81(){vfunc_called(this, "_ZN6S673C33v81Ev");}
void  S673C3 ::v82(){vfunc_called(this, "_ZN6S673C33v82Ev");}
void  S673C3 ::v83(){vfunc_called(this, "_ZN6S673C33v83Ev");}
void  S673C3 ::v84(){vfunc_called(this, "_ZN6S673C33v84Ev");}
void  S673C3 ::v85(){vfunc_called(this, "_ZN6S673C33v85Ev");}
void  S673C3 ::v86(){vfunc_called(this, "_ZN6S673C33v86Ev");}
void  S673C3 ::v87(){vfunc_called(this, "_ZN6S673C33v87Ev");}
void  S673C3 ::v88(){vfunc_called(this, "_ZN6S673C33v88Ev");}
void  S673C3 ::v89(){vfunc_called(this, "_ZN6S673C33v89Ev");}
S673C3 ::S673C3(){ note_ctor("S673C3", this);} // tgen

static void Test_S673C3()
{
  extern Class_Descriptor cd_S673C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,47)];
    init_test(&cd_S673C3, buf);
    S673C3 *dp, &lv = *(dp=new (buf) S673C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,184), "sizeof(S673C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S673C3)");
    check_base_class_offset(lv, (S673C5*)(S673C4*), 0, "S673C3");
    check_base_class_offset(lv, (S673C4*), 0, "S673C3");
    set_bf_and_test(lv, s673c3f0, ABISELECT(96,60), 0, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f1, ABISELECT(96,60), 1, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f2, ABISELECT(96,60), 2, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f3, ABISELECT(96,60), 3, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f4, ABISELECT(96,60), 4, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f5, ABISELECT(96,60), 5, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f6, ABISELECT(96,60), 6, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f7, ABISELECT(96,60), 7, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f8, ABISELECT(97,61), 0, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f9, ABISELECT(97,61), 1, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f10, ABISELECT(97,61), 2, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f11, ABISELECT(97,61), 3, 1, 1, "S673C3");
    set_bf_and_test(lv, s673c3f12, ABISELECT(97,61), 4, 1, 1, "S673C3");
    check_field_offset(lv, s673c3f13, ABISELECT(100,64), "S673C3.s673c3f13");
    check_field_offset(lv, s673c3f14, ABISELECT(136,96), "S673C3.s673c3f14");
    set_bf_and_test(lv, s673c3f15, ABISELECT(200,144), 0, 1, 1, "S673C3");
    check_field_offset(lv, s673c3f16, ABISELECT(201,145), "S673C3.s673c3f16");
    check_field_offset(lv, s673c3f17, ABISELECT(202,146), "S673C3.s673c3f17");
    check_field_offset(lv, s673c3f18, ABISELECT(204,148), "S673C3.s673c3f18");
    check_field_offset(lv, s673c3f19, ABISELECT(216,156), "S673C3.s673c3f19");
    check_field_offset(lv, s673c3f20, ABISELECT(232,168), "S673C3.s673c3f20");
    check_field_offset(lv, s673c3f21, ABISELECT(248,180), "S673C3.s673c3f21");
    test_class_info(&lv, &cd_S673C3);
    dp->~S673C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS673C3(Test_S673C3, "S673C3", ABISELECT(256,184));

#else // __cplusplus

extern void _ZN6S673C3C1Ev();
extern void _ZN6S673C3D1Ev();
Name_Map name_map_S673C3[] = {
  NSPAIR(_ZN6S673C3C1Ev),
  NSPAIR(_ZN6S673C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S673C5;
extern VTBL_ENTRY _ZTI6S673C5[];
extern  VTBL_ENTRY _ZTV6S673C5[];
extern Class_Descriptor cd_S673C4;
extern VTBL_ENTRY _ZTI6S673C4[];
extern  VTBL_ENTRY _ZTV6S673C4[];
static Base_Class bases_S673C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S673C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S673C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S673C3[];
extern void _ZN6S673C3D1Ev();
extern void _ZN6S673C3D0Ev();
extern void _ZN6S673C52v6Ev();
extern void _ZN6S673C52v7Ev();
extern void _ZN6S673C52v8Ev();
extern void _ZN6S673C52v9Ev();
extern void _ZN6S673C53v10Ev();
extern void _ZN6S673C53v11Ev();
extern void _ZN6S673C53v12Ev();
extern void _ZN6S673C53v13Ev();
extern void _ZN6S673C53v14Ev();
extern void _ZN6S673C53v15Ev();
extern void _ZN6S673C53v16Ev();
extern void _ZN6S673C53v17Ev();
extern void _ZN6S673C53v18Ev();
extern void _ZN6S673C53v19Ev();
extern void _ZN6S673C53v20Ev();
extern void _ZN6S673C53v21Ev();
extern void _ZN6S673C53v22Ev();
extern void _ZN6S673C53v23Ev();
extern void _ZN6S673C53v24Ev();
extern void _ZN6S673C53v25Ev();
extern void _ZN6S673C53v26Ev();
extern void _ZN6S673C53v27Ev();
extern void _ZN6S673C53v28Ev();
extern void _ZN6S673C53v29Ev();
extern void _ZN6S673C53v30Ev();
extern void _ZN6S673C53v31Ev();
extern void _ZN6S673C53v32Ev();
extern void _ZN6S673C53v33Ev();
extern void _ZN6S673C53v34Ev();
extern void _ZN6S673C53v35Ev();
extern void _ZN6S673C53v36Ev();
extern void _ZN6S673C53v37Ev();
extern void _ZN6S673C53v38Ev();
extern void _ZN6S673C53v39Ev();
extern void _ZN6S673C53v40Ev();
extern void _ZN6S673C53v41Ev();
extern void _ZN6S673C53v42Ev();
extern void _ZN6S673C53v43Ev();
extern void _ZN6S673C53v44Ev();
extern void _ZN6S673C53v45Ev();
extern void _ZN6S673C53v46Ev();
extern void _ZN6S673C53v47Ev();
extern void _ZN6S673C53v48Ev();
extern void _ZN6S673C53v49Ev();
extern void _ZN6S673C53v50Ev();
extern void _ZN6S673C53v51Ev();
extern void _ZN6S673C53v52Ev();
extern void _ZN6S673C53v53Ev();
extern void _ZN6S673C53v54Ev();
extern void _ZN6S673C53v55Ev();
extern void _ZN6S673C53v56Ev();
extern void _ZN6S673C53v57Ev();
extern void _ZN6S673C53v58Ev();
extern void _ZN6S673C53v59Ev();
extern void _ZN6S673C53v60Ev();
extern void _ZN6S673C53v61Ev();
extern void _ZN6S673C53v62Ev();
extern void _ZN6S673C53v63Ev();
extern void _ZN6S673C53v64Ev();
extern void _ZN6S673C53v65Ev();
extern void _ZN6S673C53v66Ev();
extern void _ZN6S673C53v67Ev();
extern void _ZN6S673C53v68Ev();
extern void _ZN6S673C53v69Ev();
extern void _ZN6S673C43v70Ev();
extern void _ZN6S673C43v71Ev();
extern void _ZN6S673C43v72Ev();
extern void _ZN6S673C43v73Ev();
extern void _ZN6S673C33v74Ev();
extern void _ZN6S673C33v75Ev();
extern void _ZN6S673C33v76Ev();
extern void _ZN6S673C33v77Ev();
extern void _ZN6S673C33v78Ev();
extern void _ZN6S673C33v79Ev();
extern void _ZN6S673C33v80Ev();
extern void _ZN6S673C33v81Ev();
extern void _ZN6S673C33v82Ev();
extern void _ZN6S673C33v83Ev();
extern void _ZN6S673C33v84Ev();
extern void _ZN6S673C33v85Ev();
extern void _ZN6S673C33v86Ev();
extern void _ZN6S673C33v87Ev();
extern void _ZN6S673C33v88Ev();
extern void _ZN6S673C33v89Ev();
static  VTBL_ENTRY vtc_S673C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S673C3[0]),
  (VTBL_ENTRY)&_ZN6S673C3D1Ev,
  (VTBL_ENTRY)&_ZN6S673C3D0Ev,
  (VTBL_ENTRY)&_ZN6S673C52v6Ev,
  (VTBL_ENTRY)&_ZN6S673C52v7Ev,
  (VTBL_ENTRY)&_ZN6S673C52v8Ev,
  (VTBL_ENTRY)&_ZN6S673C52v9Ev,
  (VTBL_ENTRY)&_ZN6S673C53v10Ev,
  (VTBL_ENTRY)&_ZN6S673C53v11Ev,
  (VTBL_ENTRY)&_ZN6S673C53v12Ev,
  (VTBL_ENTRY)&_ZN6S673C53v13Ev,
  (VTBL_ENTRY)&_ZN6S673C53v14Ev,
  (VTBL_ENTRY)&_ZN6S673C53v15Ev,
  (VTBL_ENTRY)&_ZN6S673C53v16Ev,
  (VTBL_ENTRY)&_ZN6S673C53v17Ev,
  (VTBL_ENTRY)&_ZN6S673C53v18Ev,
  (VTBL_ENTRY)&_ZN6S673C53v19Ev,
  (VTBL_ENTRY)&_ZN6S673C53v20Ev,
  (VTBL_ENTRY)&_ZN6S673C53v21Ev,
  (VTBL_ENTRY)&_ZN6S673C53v22Ev,
  (VTBL_ENTRY)&_ZN6S673C53v23Ev,
  (VTBL_ENTRY)&_ZN6S673C53v24Ev,
  (VTBL_ENTRY)&_ZN6S673C53v25Ev,
  (VTBL_ENTRY)&_ZN6S673C53v26Ev,
  (VTBL_ENTRY)&_ZN6S673C53v27Ev,
  (VTBL_ENTRY)&_ZN6S673C53v28Ev,
  (VTBL_ENTRY)&_ZN6S673C53v29Ev,
  (VTBL_ENTRY)&_ZN6S673C53v30Ev,
  (VTBL_ENTRY)&_ZN6S673C53v31Ev,
  (VTBL_ENTRY)&_ZN6S673C53v32Ev,
  (VTBL_ENTRY)&_ZN6S673C53v33Ev,
  (VTBL_ENTRY)&_ZN6S673C53v34Ev,
  (VTBL_ENTRY)&_ZN6S673C53v35Ev,
  (VTBL_ENTRY)&_ZN6S673C53v36Ev,
  (VTBL_ENTRY)&_ZN6S673C53v37Ev,
  (VTBL_ENTRY)&_ZN6S673C53v38Ev,
  (VTBL_ENTRY)&_ZN6S673C53v39Ev,
  (VTBL_ENTRY)&_ZN6S673C53v40Ev,
  (VTBL_ENTRY)&_ZN6S673C53v41Ev,
  (VTBL_ENTRY)&_ZN6S673C53v42Ev,
  (VTBL_ENTRY)&_ZN6S673C53v43Ev,
  (VTBL_ENTRY)&_ZN6S673C53v44Ev,
  (VTBL_ENTRY)&_ZN6S673C53v45Ev,
  (VTBL_ENTRY)&_ZN6S673C53v46Ev,
  (VTBL_ENTRY)&_ZN6S673C53v47Ev,
  (VTBL_ENTRY)&_ZN6S673C53v48Ev,
  (VTBL_ENTRY)&_ZN6S673C53v49Ev,
  (VTBL_ENTRY)&_ZN6S673C53v50Ev,
  (VTBL_ENTRY)&_ZN6S673C53v51Ev,
  (VTBL_ENTRY)&_ZN6S673C53v52Ev,
  (VTBL_ENTRY)&_ZN6S673C53v53Ev,
  (VTBL_ENTRY)&_ZN6S673C53v54Ev,
  (VTBL_ENTRY)&_ZN6S673C53v55Ev,
  (VTBL_ENTRY)&_ZN6S673C53v56Ev,
  (VTBL_ENTRY)&_ZN6S673C53v57Ev,
  (VTBL_ENTRY)&_ZN6S673C53v58Ev,
  (VTBL_ENTRY)&_ZN6S673C53v59Ev,
  (VTBL_ENTRY)&_ZN6S673C53v60Ev,
  (VTBL_ENTRY)&_ZN6S673C53v61Ev,
  (VTBL_ENTRY)&_ZN6S673C53v62Ev,
  (VTBL_ENTRY)&_ZN6S673C53v63Ev,
  (VTBL_ENTRY)&_ZN6S673C53v64Ev,
  (VTBL_ENTRY)&_ZN6S673C53v65Ev,
  (VTBL_ENTRY)&_ZN6S673C53v66Ev,
  (VTBL_ENTRY)&_ZN6S673C53v67Ev,
  (VTBL_ENTRY)&_ZN6S673C53v68Ev,
  (VTBL_ENTRY)&_ZN6S673C53v69Ev,
  (VTBL_ENTRY)&_ZN6S673C43v70Ev,
  (VTBL_ENTRY)&_ZN6S673C43v71Ev,
  (VTBL_ENTRY)&_ZN6S673C43v72Ev,
  (VTBL_ENTRY)&_ZN6S673C43v73Ev,
  (VTBL_ENTRY)&_ZN6S673C33v74Ev,
  (VTBL_ENTRY)&_ZN6S673C33v75Ev,
  (VTBL_ENTRY)&_ZN6S673C33v76Ev,
  (VTBL_ENTRY)&_ZN6S673C33v77Ev,
  (VTBL_ENTRY)&_ZN6S673C33v78Ev,
  (VTBL_ENTRY)&_ZN6S673C33v79Ev,
  (VTBL_ENTRY)&_ZN6S673C33v80Ev,
  (VTBL_ENTRY)&_ZN6S673C33v81Ev,
  (VTBL_ENTRY)&_ZN6S673C33v82Ev,
  (VTBL_ENTRY)&_ZN6S673C33v83Ev,
  (VTBL_ENTRY)&_ZN6S673C33v84Ev,
  (VTBL_ENTRY)&_ZN6S673C33v85Ev,
  (VTBL_ENTRY)&_ZN6S673C33v86Ev,
  (VTBL_ENTRY)&_ZN6S673C33v87Ev,
  (VTBL_ENTRY)&_ZN6S673C33v88Ev,
  (VTBL_ENTRY)&_ZN6S673C33v89Ev,
};
extern VTBL_ENTRY _ZTI6S673C3[];
extern  VTBL_ENTRY _ZTV6S673C3[];
Class_Descriptor cd_S673C3 = {  "S673C3", // class name
  bases_S673C3, 2,
  &(vtc_S673C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,184), // object size
  NSPAIRA(_ZTI6S673C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S673C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S673C2  : S673C3 {
  ::S685C40 s673c2f0;
  int s673c2f1[2];
  char s673c2f2[3];
  unsigned int s673c2f3:1;
  unsigned int s673c2f4:1;
  unsigned int s673c2f5:1;
  unsigned int s673c2f6:1;
  unsigned int s673c2f7:1;
  int s673c2f8;
  ::S695C22_nt s673c2f9;
  int s673c2f10[2];
  ::S685C10_nt s673c2f11;
  ::S507C15_nt s673c2f12;
  int s673c2f13;
  void *s673c2f14;
  int s673c2f15;
  virtual  ~S673C2(); // _ZN6S673C2D1Ev
  virtual void  v90(); // _ZN6S673C23v90Ev
  virtual void  v91(); // _ZN6S673C23v91Ev
  virtual void  v92(); // _ZN6S673C23v92Ev
  virtual void  v93(); // _ZN6S673C23v93Ev
  virtual void  v94(); // _ZN6S673C23v94Ev
  virtual void  v95(); // _ZN6S673C23v95Ev
  virtual void  v96(); // _ZN6S673C23v96Ev
  virtual void  v97(); // _ZN6S673C23v97Ev
  virtual void  v98(); // _ZN6S673C23v98Ev
  virtual void  v99(); // _ZN6S673C23v99Ev
  virtual void  v100(); // _ZN6S673C24v100Ev
  virtual void  v101(); // _ZN6S673C24v101Ev
  virtual void  v102(); // _ZN6S673C24v102Ev
  virtual void  v103(); // _ZN6S673C24v103Ev
  virtual void  v104(); // _ZN6S673C24v104Ev
  virtual void  v105(); // _ZN6S673C24v105Ev
  S673C2(); // tgen
};
//SIG(-1 S673C2) C1{ BC2{ BC3{ BC4{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC6{ BC7{ vd v103 v104 v105 v106 v107 Fi[8] Fp Fi Fp} v101 v102} Fi:1 Fc[3] Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 FC12{ BC11} Fi[2] Fc[3] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC5 Fi[2] FC13{ m Fi} FC14{ m Fp[3]} Fi Fp Fi}


 S673C2 ::~S673C2(){ note_dtor("S673C2", this);}
void  S673C2 ::v90(){vfunc_called(this, "_ZN6S673C23v90Ev");}
void  S673C2 ::v91(){vfunc_called(this, "_ZN6S673C23v91Ev");}
void  S673C2 ::v92(){vfunc_called(this, "_ZN6S673C23v92Ev");}
void  S673C2 ::v93(){vfunc_called(this, "_ZN6S673C23v93Ev");}
void  S673C2 ::v94(){vfunc_called(this, "_ZN6S673C23v94Ev");}
void  S673C2 ::v95(){vfunc_called(this, "_ZN6S673C23v95Ev");}
void  S673C2 ::v96(){vfunc_called(this, "_ZN6S673C23v96Ev");}
void  S673C2 ::v97(){vfunc_called(this, "_ZN6S673C23v97Ev");}
void  S673C2 ::v98(){vfunc_called(this, "_ZN6S673C23v98Ev");}
void  S673C2 ::v99(){vfunc_called(this, "_ZN6S673C23v99Ev");}
void  S673C2 ::v100(){vfunc_called(this, "_ZN6S673C24v100Ev");}
void  S673C2 ::v101(){vfunc_called(this, "_ZN6S673C24v101Ev");}
void  S673C2 ::v102(){vfunc_called(this, "_ZN6S673C24v102Ev");}
void  S673C2 ::v103(){vfunc_called(this, "_ZN6S673C24v103Ev");}
void  S673C2 ::v104(){vfunc_called(this, "_ZN6S673C24v104Ev");}
void  S673C2 ::v105(){vfunc_called(this, "_ZN6S673C24v105Ev");}
S673C2 ::S673C2(){ note_ctor("S673C2", this);} // tgen

static void Test_S673C2()
{
  extern Class_Descriptor cd_S673C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,65)];
    init_test(&cd_S673C2, buf);
    S673C2 *dp, &lv = *(dp=new (buf) S673C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,256), "sizeof(S673C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S673C2)");
    check_base_class_offset(lv, (S673C5*)(S673C4*)(S673C3*), 0, "S673C2");
    check_base_class_offset(lv, (S673C4*)(S673C3*), 0, "S673C2");
    check_base_class_offset(lv, (S673C3*), 0, "S673C2");
    check_field_offset(lv, s673c2f0, ABISELECT(256,184), "S673C2.s673c2f0");
    check_field_offset(lv, s673c2f1, ABISELECT(272,196), "S673C2.s673c2f1");
    check_field_offset(lv, s673c2f2, ABISELECT(280,204), "S673C2.s673c2f2");
    set_bf_and_test(lv, s673c2f3, ABISELECT(283,207), 0, 1, 1, "S673C2");
    set_bf_and_test(lv, s673c2f4, ABISELECT(283,207), 1, 1, 1, "S673C2");
    set_bf_and_test(lv, s673c2f5, ABISELECT(283,207), 2, 1, 1, "S673C2");
    set_bf_and_test(lv, s673c2f6, ABISELECT(283,207), 3, 1, 1, "S673C2");
    set_bf_and_test(lv, s673c2f7, ABISELECT(283,207), 4, 1, 1, "S673C2");
    check_field_offset(lv, s673c2f8, ABISELECT(284,208), "S673C2.s673c2f8");
    check_field_offset(lv, s673c2f9, ABISELECT(288,212), "S673C2.s673c2f9");
    check_field_offset(lv, s673c2f10, ABISELECT(296,220), "S673C2.s673c2f10");
    check_field_offset(lv, s673c2f11, ABISELECT(304,228), "S673C2.s673c2f11");
    check_field_offset(lv, s673c2f12, ABISELECT(312,232), "S673C2.s673c2f12");
    check_field_offset(lv, s673c2f13, ABISELECT(336,244), "S673C2.s673c2f13");
    check_field_offset(lv, s673c2f14, ABISELECT(344,248), "S673C2.s673c2f14");
    check_field_offset(lv, s673c2f15, ABISELECT(352,252), "S673C2.s673c2f15");
    test_class_info(&lv, &cd_S673C2);
    dp->~S673C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS673C2(Test_S673C2, "S673C2", ABISELECT(360,256));

#else // __cplusplus

extern void _ZN6S673C2C1Ev();
extern void _ZN6S673C2D1Ev();
Name_Map name_map_S673C2[] = {
  NSPAIR(_ZN6S673C2C1Ev),
  NSPAIR(_ZN6S673C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S673C5;
extern VTBL_ENTRY _ZTI6S673C5[];
extern  VTBL_ENTRY _ZTV6S673C5[];
extern Class_Descriptor cd_S673C4;
extern VTBL_ENTRY _ZTI6S673C4[];
extern  VTBL_ENTRY _ZTV6S673C4[];
extern Class_Descriptor cd_S673C3;
extern VTBL_ENTRY _ZTI6S673C3[];
extern  VTBL_ENTRY _ZTV6S673C3[];
static Base_Class bases_S673C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S673C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S673C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S673C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S673C2[];
extern void _ZN6S673C2D1Ev();
extern void _ZN6S673C2D0Ev();
extern void _ZN6S673C52v6Ev();
extern void _ZN6S673C52v7Ev();
extern void _ZN6S673C52v8Ev();
extern void _ZN6S673C52v9Ev();
extern void _ZN6S673C53v10Ev();
extern void _ZN6S673C53v11Ev();
extern void _ZN6S673C53v12Ev();
extern void _ZN6S673C53v13Ev();
extern void _ZN6S673C53v14Ev();
extern void _ZN6S673C53v15Ev();
extern void _ZN6S673C53v16Ev();
extern void _ZN6S673C53v17Ev();
extern void _ZN6S673C53v18Ev();
extern void _ZN6S673C53v19Ev();
extern void _ZN6S673C53v20Ev();
extern void _ZN6S673C53v21Ev();
extern void _ZN6S673C53v22Ev();
extern void _ZN6S673C53v23Ev();
extern void _ZN6S673C53v24Ev();
extern void _ZN6S673C53v25Ev();
extern void _ZN6S673C53v26Ev();
extern void _ZN6S673C53v27Ev();
extern void _ZN6S673C53v28Ev();
extern void _ZN6S673C53v29Ev();
extern void _ZN6S673C53v30Ev();
extern void _ZN6S673C53v31Ev();
extern void _ZN6S673C53v32Ev();
extern void _ZN6S673C53v33Ev();
extern void _ZN6S673C53v34Ev();
extern void _ZN6S673C53v35Ev();
extern void _ZN6S673C53v36Ev();
extern void _ZN6S673C53v37Ev();
extern void _ZN6S673C53v38Ev();
extern void _ZN6S673C53v39Ev();
extern void _ZN6S673C53v40Ev();
extern void _ZN6S673C53v41Ev();
extern void _ZN6S673C53v42Ev();
extern void _ZN6S673C53v43Ev();
extern void _ZN6S673C53v44Ev();
extern void _ZN6S673C53v45Ev();
extern void _ZN6S673C53v46Ev();
extern void _ZN6S673C53v47Ev();
extern void _ZN6S673C53v48Ev();
extern void _ZN6S673C53v49Ev();
extern void _ZN6S673C53v50Ev();
extern void _ZN6S673C53v51Ev();
extern void _ZN6S673C53v52Ev();
extern void _ZN6S673C53v53Ev();
extern void _ZN6S673C53v54Ev();
extern void _ZN6S673C53v55Ev();
extern void _ZN6S673C53v56Ev();
extern void _ZN6S673C53v57Ev();
extern void _ZN6S673C53v58Ev();
extern void _ZN6S673C53v59Ev();
extern void _ZN6S673C53v60Ev();
extern void _ZN6S673C53v61Ev();
extern void _ZN6S673C53v62Ev();
extern void _ZN6S673C53v63Ev();
extern void _ZN6S673C53v64Ev();
extern void _ZN6S673C53v65Ev();
extern void _ZN6S673C53v66Ev();
extern void _ZN6S673C53v67Ev();
extern void _ZN6S673C53v68Ev();
extern void _ZN6S673C53v69Ev();
extern void _ZN6S673C43v70Ev();
extern void _ZN6S673C43v71Ev();
extern void _ZN6S673C43v72Ev();
extern void _ZN6S673C43v73Ev();
extern void _ZN6S673C33v74Ev();
extern void _ZN6S673C33v75Ev();
extern void _ZN6S673C33v76Ev();
extern void _ZN6S673C33v77Ev();
extern void _ZN6S673C33v78Ev();
extern void _ZN6S673C33v79Ev();
extern void _ZN6S673C33v80Ev();
extern void _ZN6S673C33v81Ev();
extern void _ZN6S673C33v82Ev();
extern void _ZN6S673C33v83Ev();
extern void _ZN6S673C33v84Ev();
extern void _ZN6S673C33v85Ev();
extern void _ZN6S673C33v86Ev();
extern void _ZN6S673C33v87Ev();
extern void _ZN6S673C33v88Ev();
extern void _ZN6S673C33v89Ev();
extern void _ZN6S673C23v90Ev();
extern void _ZN6S673C23v91Ev();
extern void _ZN6S673C23v92Ev();
extern void _ZN6S673C23v93Ev();
extern void _ZN6S673C23v94Ev();
extern void _ZN6S673C23v95Ev();
extern void _ZN6S673C23v96Ev();
extern void _ZN6S673C23v97Ev();
extern void _ZN6S673C23v98Ev();
extern void _ZN6S673C23v99Ev();
extern void _ZN6S673C24v100Ev();
extern void _ZN6S673C24v101Ev();
extern void _ZN6S673C24v102Ev();
extern void _ZN6S673C24v103Ev();
extern void _ZN6S673C24v104Ev();
extern void _ZN6S673C24v105Ev();
static  VTBL_ENTRY vtc_S673C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S673C2[0]),
  (VTBL_ENTRY)&_ZN6S673C2D1Ev,
  (VTBL_ENTRY)&_ZN6S673C2D0Ev,
  (VTBL_ENTRY)&_ZN6S673C52v6Ev,
  (VTBL_ENTRY)&_ZN6S673C52v7Ev,
  (VTBL_ENTRY)&_ZN6S673C52v8Ev,
  (VTBL_ENTRY)&_ZN6S673C52v9Ev,
  (VTBL_ENTRY)&_ZN6S673C53v10Ev,
  (VTBL_ENTRY)&_ZN6S673C53v11Ev,
  (VTBL_ENTRY)&_ZN6S673C53v12Ev,
  (VTBL_ENTRY)&_ZN6S673C53v13Ev,
  (VTBL_ENTRY)&_ZN6S673C53v14Ev,
  (VTBL_ENTRY)&_ZN6S673C53v15Ev,
  (VTBL_ENTRY)&_ZN6S673C53v16Ev,
  (VTBL_ENTRY)&_ZN6S673C53v17Ev,
  (VTBL_ENTRY)&_ZN6S673C53v18Ev,
  (VTBL_ENTRY)&_ZN6S673C53v19Ev,
  (VTBL_ENTRY)&_ZN6S673C53v20Ev,
  (VTBL_ENTRY)&_ZN6S673C53v21Ev,
  (VTBL_ENTRY)&_ZN6S673C53v22Ev,
  (VTBL_ENTRY)&_ZN6S673C53v23Ev,
  (VTBL_ENTRY)&_ZN6S673C53v24Ev,
  (VTBL_ENTRY)&_ZN6S673C53v25Ev,
  (VTBL_ENTRY)&_ZN6S673C53v26Ev,
  (VTBL_ENTRY)&_ZN6S673C53v27Ev,
  (VTBL_ENTRY)&_ZN6S673C53v28Ev,
  (VTBL_ENTRY)&_ZN6S673C53v29Ev,
  (VTBL_ENTRY)&_ZN6S673C53v30Ev,
  (VTBL_ENTRY)&_ZN6S673C53v31Ev,
  (VTBL_ENTRY)&_ZN6S673C53v32Ev,
  (VTBL_ENTRY)&_ZN6S673C53v33Ev,
  (VTBL_ENTRY)&_ZN6S673C53v34Ev,
  (VTBL_ENTRY)&_ZN6S673C53v35Ev,
  (VTBL_ENTRY)&_ZN6S673C53v36Ev,
  (VTBL_ENTRY)&_ZN6S673C53v37Ev,
  (VTBL_ENTRY)&_ZN6S673C53v38Ev,
  (VTBL_ENTRY)&_ZN6S673C53v39Ev,
  (VTBL_ENTRY)&_ZN6S673C53v40Ev,
  (VTBL_ENTRY)&_ZN6S673C53v41Ev,
  (VTBL_ENTRY)&_ZN6S673C53v42Ev,
  (VTBL_ENTRY)&_ZN6S673C53v43Ev,
  (VTBL_ENTRY)&_ZN6S673C53v44Ev,
  (VTBL_ENTRY)&_ZN6S673C53v45Ev,
  (VTBL_ENTRY)&_ZN6S673C53v46Ev,
  (VTBL_ENTRY)&_ZN6S673C53v47Ev,
  (VTBL_ENTRY)&_ZN6S673C53v48Ev,
  (VTBL_ENTRY)&_ZN6S673C53v49Ev,
  (VTBL_ENTRY)&_ZN6S673C53v50Ev,
  (VTBL_ENTRY)&_ZN6S673C53v51Ev,
  (VTBL_ENTRY)&_ZN6S673C53v52Ev,
  (VTBL_ENTRY)&_ZN6S673C53v53Ev,
  (VTBL_ENTRY)&_ZN6S673C53v54Ev,
  (VTBL_ENTRY)&_ZN6S673C53v55Ev,
  (VTBL_ENTRY)&_ZN6S673C53v56Ev,
  (VTBL_ENTRY)&_ZN6S673C53v57Ev,
  (VTBL_ENTRY)&_ZN6S673C53v58Ev,
  (VTBL_ENTRY)&_ZN6S673C53v59Ev,
  (VTBL_ENTRY)&_ZN6S673C53v60Ev,
  (VTBL_ENTRY)&_ZN6S673C53v61Ev,
  (VTBL_ENTRY)&_ZN6S673C53v62Ev,
  (VTBL_ENTRY)&_ZN6S673C53v63Ev,
  (VTBL_ENTRY)&_ZN6S673C53v64Ev,
  (VTBL_ENTRY)&_ZN6S673C53v65Ev,
  (VTBL_ENTRY)&_ZN6S673C53v66Ev,
  (VTBL_ENTRY)&_ZN6S673C53v67Ev,
  (VTBL_ENTRY)&_ZN6S673C53v68Ev,
  (VTBL_ENTRY)&_ZN6S673C53v69Ev,
  (VTBL_ENTRY)&_ZN6S673C43v70Ev,
  (VTBL_ENTRY)&_ZN6S673C43v71Ev,
  (VTBL_ENTRY)&_ZN6S673C43v72Ev,
  (VTBL_ENTRY)&_ZN6S673C43v73Ev,
  (VTBL_ENTRY)&_ZN6S673C33v74Ev,
  (VTBL_ENTRY)&_ZN6S673C33v75Ev,
  (VTBL_ENTRY)&_ZN6S673C33v76Ev,
  (VTBL_ENTRY)&_ZN6S673C33v77Ev,
  (VTBL_ENTRY)&_ZN6S673C33v78Ev,
  (VTBL_ENTRY)&_ZN6S673C33v79Ev,
  (VTBL_ENTRY)&_ZN6S673C33v80Ev,
  (VTBL_ENTRY)&_ZN6S673C33v81Ev,
  (VTBL_ENTRY)&_ZN6S673C33v82Ev,
  (VTBL_ENTRY)&_ZN6S673C33v83Ev,
  (VTBL_ENTRY)&_ZN6S673C33v84Ev,
  (VTBL_ENTRY)&_ZN6S673C33v85Ev,
  (VTBL_ENTRY)&_ZN6S673C33v86Ev,
  (VTBL_ENTRY)&_ZN6S673C33v87Ev,
  (VTBL_ENTRY)&_ZN6S673C33v88Ev,
  (VTBL_ENTRY)&_ZN6S673C33v89Ev,
  (VTBL_ENTRY)&_ZN6S673C23v90Ev,
  (VTBL_ENTRY)&_ZN6S673C23v91Ev,
  (VTBL_ENTRY)&_ZN6S673C23v92Ev,
  (VTBL_ENTRY)&_ZN6S673C23v93Ev,
  (VTBL_ENTRY)&_ZN6S673C23v94Ev,
  (VTBL_ENTRY)&_ZN6S673C23v95Ev,
  (VTBL_ENTRY)&_ZN6S673C23v96Ev,
  (VTBL_ENTRY)&_ZN6S673C23v97Ev,
  (VTBL_ENTRY)&_ZN6S673C23v98Ev,
  (VTBL_ENTRY)&_ZN6S673C23v99Ev,
  (VTBL_ENTRY)&_ZN6S673C24v100Ev,
  (VTBL_ENTRY)&_ZN6S673C24v101Ev,
  (VTBL_ENTRY)&_ZN6S673C24v102Ev,
  (VTBL_ENTRY)&_ZN6S673C24v103Ev,
  (VTBL_ENTRY)&_ZN6S673C24v104Ev,
  (VTBL_ENTRY)&_ZN6S673C24v105Ev,
};
extern VTBL_ENTRY _ZTI6S673C2[];
extern  VTBL_ENTRY _ZTV6S673C2[];
Class_Descriptor cd_S673C2 = {  "S673C2", // class name
  bases_S673C2, 3,
  &(vtc_S673C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,256), // object size
  NSPAIRA(_ZTI6S673C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S673C2),104, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S673C1  : S673C2 {
  virtual  ~S673C1(); // _ZN6S673C1D1Ev
  virtual void  v1(); // _ZN6S673C12v1Ev
  virtual void  v2(); // _ZN6S673C12v2Ev
  virtual void  v3(); // _ZN6S673C12v3Ev
  virtual void  v4(); // _ZN6S673C12v4Ev
  virtual void  v5(); // _ZN6S673C12v5Ev
  S673C1(); // tgen
};
//SIG(1 S673C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC7{ BC8{ vd v108 v109 v110 v111 v112 Fi[8] Fp Fi Fp} v106 v107} Fi:1 Fc[3] Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 Fp} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 FC13{ BC12} Fi[2] Fc[3] Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi FC6 Fi[2] FC14{ m Fi} FC15{ m Fp[3]} Fi Fp Fi} vd v1 v2 v3 v4 v5}


 S673C1 ::~S673C1(){ note_dtor("S673C1", this);}
void  S673C1 ::v1(){vfunc_called(this, "_ZN6S673C12v1Ev");}
void  S673C1 ::v2(){vfunc_called(this, "_ZN6S673C12v2Ev");}
void  S673C1 ::v3(){vfunc_called(this, "_ZN6S673C12v3Ev");}
void  S673C1 ::v4(){vfunc_called(this, "_ZN6S673C12v4Ev");}
void  S673C1 ::v5(){vfunc_called(this, "_ZN6S673C12v5Ev");}
S673C1 ::S673C1(){ note_ctor("S673C1", this);} // tgen

static void Test_S673C1()
{
  extern Class_Descriptor cd_S673C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(46,65)];
    init_test(&cd_S673C1, buf);
    S673C1 *dp, &lv = *(dp=new (buf) S673C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(360,256), "sizeof(S673C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S673C1)");
    check_base_class_offset(lv, (S673C5*)(S673C4*)(S673C3*)(S673C2*), 0, "S673C1");
    check_base_class_offset(lv, (S673C4*)(S673C3*)(S673C2*), 0, "S673C1");
    check_base_class_offset(lv, (S673C3*)(S673C2*), 0, "S673C1");
    check_base_class_offset(lv, (S673C2*), 0, "S673C1");
    test_class_info(&lv, &cd_S673C1);
    dp->~S673C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS673C1(Test_S673C1, "S673C1", ABISELECT(360,256));

#else // __cplusplus

extern void _ZN6S673C1C1Ev();
extern void _ZN6S673C1D1Ev();
Name_Map name_map_S673C1[] = {
  NSPAIR(_ZN6S673C1C1Ev),
  NSPAIR(_ZN6S673C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S673C5;
extern VTBL_ENTRY _ZTI6S673C5[];
extern  VTBL_ENTRY _ZTV6S673C5[];
extern Class_Descriptor cd_S673C4;
extern VTBL_ENTRY _ZTI6S673C4[];
extern  VTBL_ENTRY _ZTV6S673C4[];
extern Class_Descriptor cd_S673C3;
extern VTBL_ENTRY _ZTI6S673C3[];
extern  VTBL_ENTRY _ZTV6S673C3[];
extern Class_Descriptor cd_S673C2;
extern VTBL_ENTRY _ZTI6S673C2[];
extern  VTBL_ENTRY _ZTV6S673C2[];
static Base_Class bases_S673C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S673C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S673C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S673C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S673C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S673C1[];
extern void _ZN6S673C1D1Ev();
extern void _ZN6S673C1D0Ev();
extern void _ZN6S673C52v6Ev();
extern void _ZN6S673C52v7Ev();
extern void _ZN6S673C52v8Ev();
extern void _ZN6S673C52v9Ev();
extern void _ZN6S673C53v10Ev();
extern void _ZN6S673C53v11Ev();
extern void _ZN6S673C53v12Ev();
extern void _ZN6S673C53v13Ev();
extern void _ZN6S673C53v14Ev();
extern void _ZN6S673C53v15Ev();
extern void _ZN6S673C53v16Ev();
extern void _ZN6S673C53v17Ev();
extern void _ZN6S673C53v18Ev();
extern void _ZN6S673C53v19Ev();
extern void _ZN6S673C53v20Ev();
extern void _ZN6S673C53v21Ev();
extern void _ZN6S673C53v22Ev();
extern void _ZN6S673C53v23Ev();
extern void _ZN6S673C53v24Ev();
extern void _ZN6S673C53v25Ev();
extern void _ZN6S673C53v26Ev();
extern void _ZN6S673C53v27Ev();
extern void _ZN6S673C53v28Ev();
extern void _ZN6S673C53v29Ev();
extern void _ZN6S673C53v30Ev();
extern void _ZN6S673C53v31Ev();
extern void _ZN6S673C53v32Ev();
extern void _ZN6S673C53v33Ev();
extern void _ZN6S673C53v34Ev();
extern void _ZN6S673C53v35Ev();
extern void _ZN6S673C53v36Ev();
extern void _ZN6S673C53v37Ev();
extern void _ZN6S673C53v38Ev();
extern void _ZN6S673C53v39Ev();
extern void _ZN6S673C53v40Ev();
extern void _ZN6S673C53v41Ev();
extern void _ZN6S673C53v42Ev();
extern void _ZN6S673C53v43Ev();
extern void _ZN6S673C53v44Ev();
extern void _ZN6S673C53v45Ev();
extern void _ZN6S673C53v46Ev();
extern void _ZN6S673C53v47Ev();
extern void _ZN6S673C53v48Ev();
extern void _ZN6S673C53v49Ev();
extern void _ZN6S673C53v50Ev();
extern void _ZN6S673C53v51Ev();
extern void _ZN6S673C53v52Ev();
extern void _ZN6S673C53v53Ev();
extern void _ZN6S673C53v54Ev();
extern void _ZN6S673C53v55Ev();
extern void _ZN6S673C53v56Ev();
extern void _ZN6S673C53v57Ev();
extern void _ZN6S673C53v58Ev();
extern void _ZN6S673C53v59Ev();
extern void _ZN6S673C53v60Ev();
extern void _ZN6S673C53v61Ev();
extern void _ZN6S673C53v62Ev();
extern void _ZN6S673C53v63Ev();
extern void _ZN6S673C53v64Ev();
extern void _ZN6S673C53v65Ev();
extern void _ZN6S673C53v66Ev();
extern void _ZN6S673C53v67Ev();
extern void _ZN6S673C53v68Ev();
extern void _ZN6S673C53v69Ev();
extern void _ZN6S673C43v70Ev();
extern void _ZN6S673C43v71Ev();
extern void _ZN6S673C43v72Ev();
extern void _ZN6S673C43v73Ev();
extern void _ZN6S673C33v74Ev();
extern void _ZN6S673C33v75Ev();
extern void _ZN6S673C33v76Ev();
extern void _ZN6S673C33v77Ev();
extern void _ZN6S673C33v78Ev();
extern void _ZN6S673C33v79Ev();
extern void _ZN6S673C33v80Ev();
extern void _ZN6S673C33v81Ev();
extern void _ZN6S673C33v82Ev();
extern void _ZN6S673C33v83Ev();
extern void _ZN6S673C33v84Ev();
extern void _ZN6S673C33v85Ev();
extern void _ZN6S673C33v86Ev();
extern void _ZN6S673C33v87Ev();
extern void _ZN6S673C33v88Ev();
extern void _ZN6S673C33v89Ev();
extern void _ZN6S673C23v90Ev();
extern void _ZN6S673C23v91Ev();
extern void _ZN6S673C23v92Ev();
extern void _ZN6S673C23v93Ev();
extern void _ZN6S673C23v94Ev();
extern void _ZN6S673C23v95Ev();
extern void _ZN6S673C23v96Ev();
extern void _ZN6S673C23v97Ev();
extern void _ZN6S673C23v98Ev();
extern void _ZN6S673C23v99Ev();
extern void _ZN6S673C24v100Ev();
extern void _ZN6S673C24v101Ev();
extern void _ZN6S673C24v102Ev();
extern void _ZN6S673C24v103Ev();
extern void _ZN6S673C24v104Ev();
extern void _ZN6S673C24v105Ev();
extern void _ZN6S673C12v1Ev();
extern void _ZN6S673C12v2Ev();
extern void _ZN6S673C12v3Ev();
extern void _ZN6S673C12v4Ev();
extern void _ZN6S673C12v5Ev();
static  VTBL_ENTRY vtc_S673C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S673C1[0]),
  (VTBL_ENTRY)&_ZN6S673C1D1Ev,
  (VTBL_ENTRY)&_ZN6S673C1D0Ev,
  (VTBL_ENTRY)&_ZN6S673C52v6Ev,
  (VTBL_ENTRY)&_ZN6S673C52v7Ev,
  (VTBL_ENTRY)&_ZN6S673C52v8Ev,
  (VTBL_ENTRY)&_ZN6S673C52v9Ev,
  (VTBL_ENTRY)&_ZN6S673C53v10Ev,
  (VTBL_ENTRY)&_ZN6S673C53v11Ev,
  (VTBL_ENTRY)&_ZN6S673C53v12Ev,
  (VTBL_ENTRY)&_ZN6S673C53v13Ev,
  (VTBL_ENTRY)&_ZN6S673C53v14Ev,
  (VTBL_ENTRY)&_ZN6S673C53v15Ev,
  (VTBL_ENTRY)&_ZN6S673C53v16Ev,
  (VTBL_ENTRY)&_ZN6S673C53v17Ev,
  (VTBL_ENTRY)&_ZN6S673C53v18Ev,
  (VTBL_ENTRY)&_ZN6S673C53v19Ev,
  (VTBL_ENTRY)&_ZN6S673C53v20Ev,
  (VTBL_ENTRY)&_ZN6S673C53v21Ev,
  (VTBL_ENTRY)&_ZN6S673C53v22Ev,
  (VTBL_ENTRY)&_ZN6S673C53v23Ev,
  (VTBL_ENTRY)&_ZN6S673C53v24Ev,
  (VTBL_ENTRY)&_ZN6S673C53v25Ev,
  (VTBL_ENTRY)&_ZN6S673C53v26Ev,
  (VTBL_ENTRY)&_ZN6S673C53v27Ev,
  (VTBL_ENTRY)&_ZN6S673C53v28Ev,
  (VTBL_ENTRY)&_ZN6S673C53v29Ev,
  (VTBL_ENTRY)&_ZN6S673C53v30Ev,
  (VTBL_ENTRY)&_ZN6S673C53v31Ev,
  (VTBL_ENTRY)&_ZN6S673C53v32Ev,
  (VTBL_ENTRY)&_ZN6S673C53v33Ev,
  (VTBL_ENTRY)&_ZN6S673C53v34Ev,
  (VTBL_ENTRY)&_ZN6S673C53v35Ev,
  (VTBL_ENTRY)&_ZN6S673C53v36Ev,
  (VTBL_ENTRY)&_ZN6S673C53v37Ev,
  (VTBL_ENTRY)&_ZN6S673C53v38Ev,
  (VTBL_ENTRY)&_ZN6S673C53v39Ev,
  (VTBL_ENTRY)&_ZN6S673C53v40Ev,
  (VTBL_ENTRY)&_ZN6S673C53v41Ev,
  (VTBL_ENTRY)&_ZN6S673C53v42Ev,
  (VTBL_ENTRY)&_ZN6S673C53v43Ev,
  (VTBL_ENTRY)&_ZN6S673C53v44Ev,
  (VTBL_ENTRY)&_ZN6S673C53v45Ev,
  (VTBL_ENTRY)&_ZN6S673C53v46Ev,
  (VTBL_ENTRY)&_ZN6S673C53v47Ev,
  (VTBL_ENTRY)&_ZN6S673C53v48Ev,
  (VTBL_ENTRY)&_ZN6S673C53v49Ev,
  (VTBL_ENTRY)&_ZN6S673C53v50Ev,
  (VTBL_ENTRY)&_ZN6S673C53v51Ev,
  (VTBL_ENTRY)&_ZN6S673C53v52Ev,
  (VTBL_ENTRY)&_ZN6S673C53v53Ev,
  (VTBL_ENTRY)&_ZN6S673C53v54Ev,
  (VTBL_ENTRY)&_ZN6S673C53v55Ev,
  (VTBL_ENTRY)&_ZN6S673C53v56Ev,
  (VTBL_ENTRY)&_ZN6S673C53v57Ev,
  (VTBL_ENTRY)&_ZN6S673C53v58Ev,
  (VTBL_ENTRY)&_ZN6S673C53v59Ev,
  (VTBL_ENTRY)&_ZN6S673C53v60Ev,
  (VTBL_ENTRY)&_ZN6S673C53v61Ev,
  (VTBL_ENTRY)&_ZN6S673C53v62Ev,
  (VTBL_ENTRY)&_ZN6S673C53v63Ev,
  (VTBL_ENTRY)&_ZN6S673C53v64Ev,
  (VTBL_ENTRY)&_ZN6S673C53v65Ev,
  (VTBL_ENTRY)&_ZN6S673C53v66Ev,
  (VTBL_ENTRY)&_ZN6S673C53v67Ev,
  (VTBL_ENTRY)&_ZN6S673C53v68Ev,
  (VTBL_ENTRY)&_ZN6S673C53v69Ev,
  (VTBL_ENTRY)&_ZN6S673C43v70Ev,
  (VTBL_ENTRY)&_ZN6S673C43v71Ev,
  (VTBL_ENTRY)&_ZN6S673C43v72Ev,
  (VTBL_ENTRY)&_ZN6S673C43v73Ev,
  (VTBL_ENTRY)&_ZN6S673C33v74Ev,
  (VTBL_ENTRY)&_ZN6S673C33v75Ev,
  (VTBL_ENTRY)&_ZN6S673C33v76Ev,
  (VTBL_ENTRY)&_ZN6S673C33v77Ev,
  (VTBL_ENTRY)&_ZN6S673C33v78Ev,
  (VTBL_ENTRY)&_ZN6S673C33v79Ev,
  (VTBL_ENTRY)&_ZN6S673C33v80Ev,
  (VTBL_ENTRY)&_ZN6S673C33v81Ev,
  (VTBL_ENTRY)&_ZN6S673C33v82Ev,
  (VTBL_ENTRY)&_ZN6S673C33v83Ev,
  (VTBL_ENTRY)&_ZN6S673C33v84Ev,
  (VTBL_ENTRY)&_ZN6S673C33v85Ev,
  (VTBL_ENTRY)&_ZN6S673C33v86Ev,
  (VTBL_ENTRY)&_ZN6S673C33v87Ev,
  (VTBL_ENTRY)&_ZN6S673C33v88Ev,
  (VTBL_ENTRY)&_ZN6S673C33v89Ev,
  (VTBL_ENTRY)&_ZN6S673C23v90Ev,
  (VTBL_ENTRY)&_ZN6S673C23v91Ev,
  (VTBL_ENTRY)&_ZN6S673C23v92Ev,
  (VTBL_ENTRY)&_ZN6S673C23v93Ev,
  (VTBL_ENTRY)&_ZN6S673C23v94Ev,
  (VTBL_ENTRY)&_ZN6S673C23v95Ev,
  (VTBL_ENTRY)&_ZN6S673C23v96Ev,
  (VTBL_ENTRY)&_ZN6S673C23v97Ev,
  (VTBL_ENTRY)&_ZN6S673C23v98Ev,
  (VTBL_ENTRY)&_ZN6S673C23v99Ev,
  (VTBL_ENTRY)&_ZN6S673C24v100Ev,
  (VTBL_ENTRY)&_ZN6S673C24v101Ev,
  (VTBL_ENTRY)&_ZN6S673C24v102Ev,
  (VTBL_ENTRY)&_ZN6S673C24v103Ev,
  (VTBL_ENTRY)&_ZN6S673C24v104Ev,
  (VTBL_ENTRY)&_ZN6S673C24v105Ev,
  (VTBL_ENTRY)&_ZN6S673C12v1Ev,
  (VTBL_ENTRY)&_ZN6S673C12v2Ev,
  (VTBL_ENTRY)&_ZN6S673C12v3Ev,
  (VTBL_ENTRY)&_ZN6S673C12v4Ev,
  (VTBL_ENTRY)&_ZN6S673C12v5Ev,
};
extern VTBL_ENTRY _ZTI6S673C1[];
extern  VTBL_ENTRY _ZTV6S673C1[];
Class_Descriptor cd_S673C1 = {  "S673C1", // class name
  bases_S673C1, 4,
  &(vtc_S673C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(360,256), // object size
  NSPAIRA(_ZTI6S673C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S673C1),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1333C4  {
  int s1333c4f0;
  __tsi64 s1333c4f1;
  void *s1333c4f2[4];
  int s1333c4f3[2];
  void *s1333c4f4;
  ::S695C22_nt s1333c4f5;
  void *s1333c4f6[2];
  virtual  ~S1333C4(); // _ZN7S1333C4D1Ev
  virtual void  v19(); // _ZN7S1333C43v19Ev
  virtual void  v20(); // _ZN7S1333C43v20Ev
  virtual void  v21(); // _ZN7S1333C43v21Ev
  virtual void  v22(); // _ZN7S1333C43v22Ev
  virtual void  v23(); // _ZN7S1333C43v23Ev
  virtual void  v24(); // _ZN7S1333C43v24Ev
  virtual void  v25(); // _ZN7S1333C43v25Ev
  virtual void  v26(); // _ZN7S1333C43v26Ev
  virtual void  v27(); // _ZN7S1333C43v27Ev
  virtual void  v28(); // _ZN7S1333C43v28Ev
  virtual void  v29(); // _ZN7S1333C43v29Ev
  virtual void  v30(); // _ZN7S1333C43v30Ev
  virtual void  v31(); // _ZN7S1333C43v31Ev
  virtual void  v32(); // _ZN7S1333C43v32Ev
  virtual void  v33(); // _ZN7S1333C43v33Ev
  virtual void  v34(); // _ZN7S1333C43v34Ev
  virtual void  v35(); // _ZN7S1333C43v35Ev
  virtual void  v36(); // _ZN7S1333C43v36Ev
  virtual void  v37(); // _ZN7S1333C43v37Ev
  virtual void  v38(); // _ZN7S1333C43v38Ev
  virtual void  v39(); // _ZN7S1333C43v39Ev
  virtual void  v40(); // _ZN7S1333C43v40Ev
  virtual void  v41(); // _ZN7S1333C43v41Ev
  virtual void  v42(); // _ZN7S1333C43v42Ev
  virtual void  v43(); // _ZN7S1333C43v43Ev
  virtual void  v44(); // _ZN7S1333C43v44Ev
  virtual void  v45(); // _ZN7S1333C43v45Ev
  virtual void  v46(); // _ZN7S1333C43v46Ev
  virtual void  v47(); // _ZN7S1333C43v47Ev
  virtual void  v48(); // _ZN7S1333C43v48Ev
  virtual void  v49(); // _ZN7S1333C43v49Ev
  virtual void  v50(); // _ZN7S1333C43v50Ev
  virtual void  v51(); // _ZN7S1333C43v51Ev
  virtual void  v52(); // _ZN7S1333C43v52Ev
  virtual void  v53(); // _ZN7S1333C43v53Ev
  virtual void  v54(); // _ZN7S1333C43v54Ev
  virtual void  v55(); // _ZN7S1333C43v55Ev
  virtual void  v56(); // _ZN7S1333C43v56Ev
  virtual void  v57(); // _ZN7S1333C43v57Ev
  virtual void  v58(); // _ZN7S1333C43v58Ev
  virtual void  v59(); // _ZN7S1333C43v59Ev
  virtual void  v60(); // _ZN7S1333C43v60Ev
  virtual void  v61(); // _ZN7S1333C43v61Ev
  virtual void  v62(); // _ZN7S1333C43v62Ev
  virtual void  v63(); // _ZN7S1333C43v63Ev
  virtual void  v64(); // _ZN7S1333C43v64Ev
  virtual void  v65(); // _ZN7S1333C43v65Ev
  virtual void  v66(); // _ZN7S1333C43v66Ev
  virtual void  v67(); // _ZN7S1333C43v67Ev
  virtual void  v68(); // _ZN7S1333C43v68Ev
  virtual void  v69(); // _ZN7S1333C43v69Ev
  virtual void  v70(); // _ZN7S1333C43v70Ev
  virtual void  v71(); // _ZN7S1333C43v71Ev
  virtual void  v72(); // _ZN7S1333C43v72Ev
  virtual void  v73(); // _ZN7S1333C43v73Ev
  virtual void  v74(); // _ZN7S1333C43v74Ev
  virtual void  v75(); // _ZN7S1333C43v75Ev
  virtual void  v76(); // _ZN7S1333C43v76Ev
  virtual void  v77(); // _ZN7S1333C43v77Ev
  virtual void  v78(); // _ZN7S1333C43v78Ev
  virtual void  v79(); // _ZN7S1333C43v79Ev
  virtual void  v80(); // _ZN7S1333C43v80Ev
  virtual void  v81(); // _ZN7S1333C43v81Ev
  virtual void  v82(); // _ZN7S1333C43v82Ev
  S1333C4(); // tgen
};
//SIG(-1 S1333C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1333C4 ::~S1333C4(){ note_dtor("S1333C4", this);}
void  S1333C4 ::v19(){vfunc_called(this, "_ZN7S1333C43v19Ev");}
void  S1333C4 ::v20(){vfunc_called(this, "_ZN7S1333C43v20Ev");}
void  S1333C4 ::v21(){vfunc_called(this, "_ZN7S1333C43v21Ev");}
void  S1333C4 ::v22(){vfunc_called(this, "_ZN7S1333C43v22Ev");}
void  S1333C4 ::v23(){vfunc_called(this, "_ZN7S1333C43v23Ev");}
void  S1333C4 ::v24(){vfunc_called(this, "_ZN7S1333C43v24Ev");}
void  S1333C4 ::v25(){vfunc_called(this, "_ZN7S1333C43v25Ev");}
void  S1333C4 ::v26(){vfunc_called(this, "_ZN7S1333C43v26Ev");}
void  S1333C4 ::v27(){vfunc_called(this, "_ZN7S1333C43v27Ev");}
void  S1333C4 ::v28(){vfunc_called(this, "_ZN7S1333C43v28Ev");}
void  S1333C4 ::v29(){vfunc_called(this, "_ZN7S1333C43v29Ev");}
void  S1333C4 ::v30(){vfunc_called(this, "_ZN7S1333C43v30Ev");}
void  S1333C4 ::v31(){vfunc_called(this, "_ZN7S1333C43v31Ev");}
void  S1333C4 ::v32(){vfunc_called(this, "_ZN7S1333C43v32Ev");}
void  S1333C4 ::v33(){vfunc_called(this, "_ZN7S1333C43v33Ev");}
void  S1333C4 ::v34(){vfunc_called(this, "_ZN7S1333C43v34Ev");}
void  S1333C4 ::v35(){vfunc_called(this, "_ZN7S1333C43v35Ev");}
void  S1333C4 ::v36(){vfunc_called(this, "_ZN7S1333C43v36Ev");}
void  S1333C4 ::v37(){vfunc_called(this, "_ZN7S1333C43v37Ev");}
void  S1333C4 ::v38(){vfunc_called(this, "_ZN7S1333C43v38Ev");}
void  S1333C4 ::v39(){vfunc_called(this, "_ZN7S1333C43v39Ev");}
void  S1333C4 ::v40(){vfunc_called(this, "_ZN7S1333C43v40Ev");}
void  S1333C4 ::v41(){vfunc_called(this, "_ZN7S1333C43v41Ev");}
void  S1333C4 ::v42(){vfunc_called(this, "_ZN7S1333C43v42Ev");}
void  S1333C4 ::v43(){vfunc_called(this, "_ZN7S1333C43v43Ev");}
void  S1333C4 ::v44(){vfunc_called(this, "_ZN7S1333C43v44Ev");}
void  S1333C4 ::v45(){vfunc_called(this, "_ZN7S1333C43v45Ev");}
void  S1333C4 ::v46(){vfunc_called(this, "_ZN7S1333C43v46Ev");}
void  S1333C4 ::v47(){vfunc_called(this, "_ZN7S1333C43v47Ev");}
void  S1333C4 ::v48(){vfunc_called(this, "_ZN7S1333C43v48Ev");}
void  S1333C4 ::v49(){vfunc_called(this, "_ZN7S1333C43v49Ev");}
void  S1333C4 ::v50(){vfunc_called(this, "_ZN7S1333C43v50Ev");}
void  S1333C4 ::v51(){vfunc_called(this, "_ZN7S1333C43v51Ev");}
void  S1333C4 ::v52(){vfunc_called(this, "_ZN7S1333C43v52Ev");}
void  S1333C4 ::v53(){vfunc_called(this, "_ZN7S1333C43v53Ev");}
void  S1333C4 ::v54(){vfunc_called(this, "_ZN7S1333C43v54Ev");}
void  S1333C4 ::v55(){vfunc_called(this, "_ZN7S1333C43v55Ev");}
void  S1333C4 ::v56(){vfunc_called(this, "_ZN7S1333C43v56Ev");}
void  S1333C4 ::v57(){vfunc_called(this, "_ZN7S1333C43v57Ev");}
void  S1333C4 ::v58(){vfunc_called(this, "_ZN7S1333C43v58Ev");}
void  S1333C4 ::v59(){vfunc_called(this, "_ZN7S1333C43v59Ev");}
void  S1333C4 ::v60(){vfunc_called(this, "_ZN7S1333C43v60Ev");}
void  S1333C4 ::v61(){vfunc_called(this, "_ZN7S1333C43v61Ev");}
void  S1333C4 ::v62(){vfunc_called(this, "_ZN7S1333C43v62Ev");}
void  S1333C4 ::v63(){vfunc_called(this, "_ZN7S1333C43v63Ev");}
void  S1333C4 ::v64(){vfunc_called(this, "_ZN7S1333C43v64Ev");}
void  S1333C4 ::v65(){vfunc_called(this, "_ZN7S1333C43v65Ev");}
void  S1333C4 ::v66(){vfunc_called(this, "_ZN7S1333C43v66Ev");}
void  S1333C4 ::v67(){vfunc_called(this, "_ZN7S1333C43v67Ev");}
void  S1333C4 ::v68(){vfunc_called(this, "_ZN7S1333C43v68Ev");}
void  S1333C4 ::v69(){vfunc_called(this, "_ZN7S1333C43v69Ev");}
void  S1333C4 ::v70(){vfunc_called(this, "_ZN7S1333C43v70Ev");}
void  S1333C4 ::v71(){vfunc_called(this, "_ZN7S1333C43v71Ev");}
void  S1333C4 ::v72(){vfunc_called(this, "_ZN7S1333C43v72Ev");}
void  S1333C4 ::v73(){vfunc_called(this, "_ZN7S1333C43v73Ev");}
void  S1333C4 ::v74(){vfunc_called(this, "_ZN7S1333C43v74Ev");}
void  S1333C4 ::v75(){vfunc_called(this, "_ZN7S1333C43v75Ev");}
void  S1333C4 ::v76(){vfunc_called(this, "_ZN7S1333C43v76Ev");}
void  S1333C4 ::v77(){vfunc_called(this, "_ZN7S1333C43v77Ev");}
void  S1333C4 ::v78(){vfunc_called(this, "_ZN7S1333C43v78Ev");}
void  S1333C4 ::v79(){vfunc_called(this, "_ZN7S1333C43v79Ev");}
void  S1333C4 ::v80(){vfunc_called(this, "_ZN7S1333C43v80Ev");}
void  S1333C4 ::v81(){vfunc_called(this, "_ZN7S1333C43v81Ev");}
void  S1333C4 ::v82(){vfunc_called(this, "_ZN7S1333C43v82Ev");}
S1333C4 ::S1333C4(){ note_ctor("S1333C4", this);} // tgen

static void Test_S1333C4()
{
  extern Class_Descriptor cd_S1333C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1333C4, buf);
    S1333C4 *dp, &lv = *(dp=new (buf) S1333C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1333C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1333C4)");
    check_field_offset(lv, s1333c4f0, ABISELECT(8,4), "S1333C4.s1333c4f0");
    check_field_offset(lv, s1333c4f1, ABISELECT(16,8), "S1333C4.s1333c4f1");
    check_field_offset(lv, s1333c4f2, ABISELECT(24,16), "S1333C4.s1333c4f2");
    check_field_offset(lv, s1333c4f3, ABISELECT(56,32), "S1333C4.s1333c4f3");
    check_field_offset(lv, s1333c4f4, ABISELECT(64,40), "S1333C4.s1333c4f4");
    check_field_offset(lv, s1333c4f5, ABISELECT(72,44), "S1333C4.s1333c4f5");
    check_field_offset(lv, s1333c4f6, ABISELECT(80,52), "S1333C4.s1333c4f6");
    test_class_info(&lv, &cd_S1333C4);
    dp->~S1333C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1333C4(Test_S1333C4, "S1333C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1333C4C1Ev();
extern void _ZN7S1333C4D1Ev();
Name_Map name_map_S1333C4[] = {
  NSPAIR(_ZN7S1333C4C1Ev),
  NSPAIR(_ZN7S1333C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1333C4[];
extern void _ZN7S1333C4D1Ev();
extern void _ZN7S1333C4D0Ev();
extern void _ZN7S1333C43v19Ev();
extern void _ZN7S1333C43v20Ev();
extern void _ZN7S1333C43v21Ev();
extern void _ZN7S1333C43v22Ev();
extern void _ZN7S1333C43v23Ev();
extern void _ZN7S1333C43v24Ev();
extern void _ZN7S1333C43v25Ev();
extern void _ZN7S1333C43v26Ev();
extern void _ZN7S1333C43v27Ev();
extern void _ZN7S1333C43v28Ev();
extern void _ZN7S1333C43v29Ev();
extern void _ZN7S1333C43v30Ev();
extern void _ZN7S1333C43v31Ev();
extern void _ZN7S1333C43v32Ev();
extern void _ZN7S1333C43v33Ev();
extern void _ZN7S1333C43v34Ev();
extern void _ZN7S1333C43v35Ev();
extern void _ZN7S1333C43v36Ev();
extern void _ZN7S1333C43v37Ev();
extern void _ZN7S1333C43v38Ev();
extern void _ZN7S1333C43v39Ev();
extern void _ZN7S1333C43v40Ev();
extern void _ZN7S1333C43v41Ev();
extern void _ZN7S1333C43v42Ev();
extern void _ZN7S1333C43v43Ev();
extern void _ZN7S1333C43v44Ev();
extern void _ZN7S1333C43v45Ev();
extern void _ZN7S1333C43v46Ev();
extern void _ZN7S1333C43v47Ev();
extern void _ZN7S1333C43v48Ev();
extern void _ZN7S1333C43v49Ev();
extern void _ZN7S1333C43v50Ev();
extern void _ZN7S1333C43v51Ev();
extern void _ZN7S1333C43v52Ev();
extern void _ZN7S1333C43v53Ev();
extern void _ZN7S1333C43v54Ev();
extern void _ZN7S1333C43v55Ev();
extern void _ZN7S1333C43v56Ev();
extern void _ZN7S1333C43v57Ev();
extern void _ZN7S1333C43v58Ev();
extern void _ZN7S1333C43v59Ev();
extern void _ZN7S1333C43v60Ev();
extern void _ZN7S1333C43v61Ev();
extern void _ZN7S1333C43v62Ev();
extern void _ZN7S1333C43v63Ev();
extern void _ZN7S1333C43v64Ev();
extern void _ZN7S1333C43v65Ev();
extern void _ZN7S1333C43v66Ev();
extern void _ZN7S1333C43v67Ev();
extern void _ZN7S1333C43v68Ev();
extern void _ZN7S1333C43v69Ev();
extern void _ZN7S1333C43v70Ev();
extern void _ZN7S1333C43v71Ev();
extern void _ZN7S1333C43v72Ev();
extern void _ZN7S1333C43v73Ev();
extern void _ZN7S1333C43v74Ev();
extern void _ZN7S1333C43v75Ev();
extern void _ZN7S1333C43v76Ev();
extern void _ZN7S1333C43v77Ev();
extern void _ZN7S1333C43v78Ev();
extern void _ZN7S1333C43v79Ev();
extern void _ZN7S1333C43v80Ev();
extern void _ZN7S1333C43v81Ev();
extern void _ZN7S1333C43v82Ev();
static  VTBL_ENTRY vtc_S1333C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1333C4[0]),
  (VTBL_ENTRY)&_ZN7S1333C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1333C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v82Ev,
};
extern VTBL_ENTRY _ZTI7S1333C4[];
extern  VTBL_ENTRY _ZTV7S1333C4[];
Class_Descriptor cd_S1333C4 = {  "S1333C4", // class name
  0,0,//no base classes
  &(vtc_S1333C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1333C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1333C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1333C3  : S1333C4 {
  virtual  ~S1333C3(); // _ZN7S1333C3D1Ev
  virtual void  v83(); // _ZN7S1333C33v83Ev
  virtual void  v84(); // _ZN7S1333C33v84Ev
  virtual void  v85(); // _ZN7S1333C33v85Ev
  virtual void  v86(); // _ZN7S1333C33v86Ev
  S1333C3(); // tgen
};
//SIG(-1 S1333C3) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S1333C3 ::~S1333C3(){ note_dtor("S1333C3", this);}
void  S1333C3 ::v83(){vfunc_called(this, "_ZN7S1333C33v83Ev");}
void  S1333C3 ::v84(){vfunc_called(this, "_ZN7S1333C33v84Ev");}
void  S1333C3 ::v85(){vfunc_called(this, "_ZN7S1333C33v85Ev");}
void  S1333C3 ::v86(){vfunc_called(this, "_ZN7S1333C33v86Ev");}
S1333C3 ::S1333C3(){ note_ctor("S1333C3", this);} // tgen

static void Test_S1333C3()
{
  extern Class_Descriptor cd_S1333C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1333C3, buf);
    S1333C3 *dp, &lv = *(dp=new (buf) S1333C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1333C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1333C3)");
    check_base_class_offset(lv, (S1333C4*), 0, "S1333C3");
    test_class_info(&lv, &cd_S1333C3);
    dp->~S1333C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1333C3(Test_S1333C3, "S1333C3", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1333C3C1Ev();
extern void _ZN7S1333C3D1Ev();
Name_Map name_map_S1333C3[] = {
  NSPAIR(_ZN7S1333C3C1Ev),
  NSPAIR(_ZN7S1333C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1333C4;
extern VTBL_ENTRY _ZTI7S1333C4[];
extern  VTBL_ENTRY _ZTV7S1333C4[];
static Base_Class bases_S1333C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1333C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1333C3[];
extern void _ZN7S1333C3D1Ev();
extern void _ZN7S1333C3D0Ev();
extern void _ZN7S1333C43v19Ev();
extern void _ZN7S1333C43v20Ev();
extern void _ZN7S1333C43v21Ev();
extern void _ZN7S1333C43v22Ev();
extern void _ZN7S1333C43v23Ev();
extern void _ZN7S1333C43v24Ev();
extern void _ZN7S1333C43v25Ev();
extern void _ZN7S1333C43v26Ev();
extern void _ZN7S1333C43v27Ev();
extern void _ZN7S1333C43v28Ev();
extern void _ZN7S1333C43v29Ev();
extern void _ZN7S1333C43v30Ev();
extern void _ZN7S1333C43v31Ev();
extern void _ZN7S1333C43v32Ev();
extern void _ZN7S1333C43v33Ev();
extern void _ZN7S1333C43v34Ev();
extern void _ZN7S1333C43v35Ev();
extern void _ZN7S1333C43v36Ev();
extern void _ZN7S1333C43v37Ev();
extern void _ZN7S1333C43v38Ev();
extern void _ZN7S1333C43v39Ev();
extern void _ZN7S1333C43v40Ev();
extern void _ZN7S1333C43v41Ev();
extern void _ZN7S1333C43v42Ev();
extern void _ZN7S1333C43v43Ev();
extern void _ZN7S1333C43v44Ev();
extern void _ZN7S1333C43v45Ev();
extern void _ZN7S1333C43v46Ev();
extern void _ZN7S1333C43v47Ev();
extern void _ZN7S1333C43v48Ev();
extern void _ZN7S1333C43v49Ev();
extern void _ZN7S1333C43v50Ev();
extern void _ZN7S1333C43v51Ev();
extern void _ZN7S1333C43v52Ev();
extern void _ZN7S1333C43v53Ev();
extern void _ZN7S1333C43v54Ev();
extern void _ZN7S1333C43v55Ev();
extern void _ZN7S1333C43v56Ev();
extern void _ZN7S1333C43v57Ev();
extern void _ZN7S1333C43v58Ev();
extern void _ZN7S1333C43v59Ev();
extern void _ZN7S1333C43v60Ev();
extern void _ZN7S1333C43v61Ev();
extern void _ZN7S1333C43v62Ev();
extern void _ZN7S1333C43v63Ev();
extern void _ZN7S1333C43v64Ev();
extern void _ZN7S1333C43v65Ev();
extern void _ZN7S1333C43v66Ev();
extern void _ZN7S1333C43v67Ev();
extern void _ZN7S1333C43v68Ev();
extern void _ZN7S1333C43v69Ev();
extern void _ZN7S1333C43v70Ev();
extern void _ZN7S1333C43v71Ev();
extern void _ZN7S1333C43v72Ev();
extern void _ZN7S1333C43v73Ev();
extern void _ZN7S1333C43v74Ev();
extern void _ZN7S1333C43v75Ev();
extern void _ZN7S1333C43v76Ev();
extern void _ZN7S1333C43v77Ev();
extern void _ZN7S1333C43v78Ev();
extern void _ZN7S1333C43v79Ev();
extern void _ZN7S1333C43v80Ev();
extern void _ZN7S1333C43v81Ev();
extern void _ZN7S1333C43v82Ev();
extern void _ZN7S1333C33v83Ev();
extern void _ZN7S1333C33v84Ev();
extern void _ZN7S1333C33v85Ev();
extern void _ZN7S1333C33v86Ev();
static  VTBL_ENTRY vtc_S1333C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1333C3[0]),
  (VTBL_ENTRY)&_ZN7S1333C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1333C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v86Ev,
};
extern VTBL_ENTRY _ZTI7S1333C3[];
extern  VTBL_ENTRY _ZTV7S1333C3[];
Class_Descriptor cd_S1333C3 = {  "S1333C3", // class name
  bases_S1333C3, 1,
  &(vtc_S1333C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1333C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1333C3),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1333C2  : S1333C3 {
  unsigned int s1333c2f0:1;
  unsigned int s1333c2f1:1;
  unsigned int s1333c2f2:1;
  unsigned int s1333c2f3:1;
  unsigned int s1333c2f4:1;
  unsigned int s1333c2f5:1;
  unsigned int s1333c2f6:1;
  unsigned int s1333c2f7:1;
  unsigned int s1333c2f8:1;
  unsigned int s1333c2f9:1;
  unsigned int s1333c2f10:1;
  unsigned int s1333c2f11:1;
  unsigned int s1333c2f12:1;
  int s1333c2f13[8];
  ::S507C7 s1333c2f14;
  unsigned int s1333c2f15:1;
  char s1333c2f16;
  char s1333c2f17[2];
  int s1333c2f18[2];
  ::S685C27_nt s1333c2f19;
  ::S685C27_nt s1333c2f20;
  void *s1333c2f21;
  virtual  ~S1333C2(); // _ZN7S1333C2D1Ev
  virtual void  v87(); // _ZN7S1333C23v87Ev
  virtual void  v88(); // _ZN7S1333C23v88Ev
  virtual void  v89(); // _ZN7S1333C23v89Ev
  virtual void  v90(); // _ZN7S1333C23v90Ev
  virtual void  v91(); // _ZN7S1333C23v91Ev
  virtual void  v92(); // _ZN7S1333C23v92Ev
  virtual void  v93(); // _ZN7S1333C23v93Ev
  virtual void  v94(); // _ZN7S1333C23v94Ev
  virtual void  v95(); // _ZN7S1333C23v95Ev
  virtual void  v96(); // _ZN7S1333C23v96Ev
  virtual void  v97(); // _ZN7S1333C23v97Ev
  virtual void  v98(); // _ZN7S1333C23v98Ev
  virtual void  v99(); // _ZN7S1333C23v99Ev
  virtual void  v100(); // _ZN7S1333C24v100Ev
  virtual void  v101(); // _ZN7S1333C24v101Ev
  virtual void  v102(); // _ZN7S1333C24v102Ev
  S1333C2(); // tgen
};
//SIG(-1 S1333C2) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC5{ BC6{ vd v87 v88 v89 v90 v91 Fi[8] Fp Fi Fp} v85 v86} Fi:1 Fc[3] Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 Fp}


 S1333C2 ::~S1333C2(){ note_dtor("S1333C2", this);}
void  S1333C2 ::v87(){vfunc_called(this, "_ZN7S1333C23v87Ev");}
void  S1333C2 ::v88(){vfunc_called(this, "_ZN7S1333C23v88Ev");}
void  S1333C2 ::v89(){vfunc_called(this, "_ZN7S1333C23v89Ev");}
void  S1333C2 ::v90(){vfunc_called(this, "_ZN7S1333C23v90Ev");}
void  S1333C2 ::v91(){vfunc_called(this, "_ZN7S1333C23v91Ev");}
void  S1333C2 ::v92(){vfunc_called(this, "_ZN7S1333C23v92Ev");}
void  S1333C2 ::v93(){vfunc_called(this, "_ZN7S1333C23v93Ev");}
void  S1333C2 ::v94(){vfunc_called(this, "_ZN7S1333C23v94Ev");}
void  S1333C2 ::v95(){vfunc_called(this, "_ZN7S1333C23v95Ev");}
void  S1333C2 ::v96(){vfunc_called(this, "_ZN7S1333C23v96Ev");}
void  S1333C2 ::v97(){vfunc_called(this, "_ZN7S1333C23v97Ev");}
void  S1333C2 ::v98(){vfunc_called(this, "_ZN7S1333C23v98Ev");}
void  S1333C2 ::v99(){vfunc_called(this, "_ZN7S1333C23v99Ev");}
void  S1333C2 ::v100(){vfunc_called(this, "_ZN7S1333C24v100Ev");}
void  S1333C2 ::v101(){vfunc_called(this, "_ZN7S1333C24v101Ev");}
void  S1333C2 ::v102(){vfunc_called(this, "_ZN7S1333C24v102Ev");}
S1333C2 ::S1333C2(){ note_ctor("S1333C2", this);} // tgen

static void Test_S1333C2()
{
  extern Class_Descriptor cd_S1333C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,47)];
    init_test(&cd_S1333C2, buf);
    S1333C2 *dp, &lv = *(dp=new (buf) S1333C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,184), "sizeof(S1333C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1333C2)");
    check_base_class_offset(lv, (S1333C4*)(S1333C3*), 0, "S1333C2");
    check_base_class_offset(lv, (S1333C3*), 0, "S1333C2");
    set_bf_and_test(lv, s1333c2f0, ABISELECT(96,60), 0, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f1, ABISELECT(96,60), 1, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f2, ABISELECT(96,60), 2, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f3, ABISELECT(96,60), 3, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f4, ABISELECT(96,60), 4, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f5, ABISELECT(96,60), 5, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f6, ABISELECT(96,60), 6, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f7, ABISELECT(96,60), 7, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f8, ABISELECT(97,61), 0, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f9, ABISELECT(97,61), 1, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f10, ABISELECT(97,61), 2, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f11, ABISELECT(97,61), 3, 1, 1, "S1333C2");
    set_bf_and_test(lv, s1333c2f12, ABISELECT(97,61), 4, 1, 1, "S1333C2");
    check_field_offset(lv, s1333c2f13, ABISELECT(100,64), "S1333C2.s1333c2f13");
    check_field_offset(lv, s1333c2f14, ABISELECT(136,96), "S1333C2.s1333c2f14");
    set_bf_and_test(lv, s1333c2f15, ABISELECT(200,144), 0, 1, 1, "S1333C2");
    check_field_offset(lv, s1333c2f16, ABISELECT(201,145), "S1333C2.s1333c2f16");
    check_field_offset(lv, s1333c2f17, ABISELECT(202,146), "S1333C2.s1333c2f17");
    check_field_offset(lv, s1333c2f18, ABISELECT(204,148), "S1333C2.s1333c2f18");
    check_field_offset(lv, s1333c2f19, ABISELECT(216,156), "S1333C2.s1333c2f19");
    check_field_offset(lv, s1333c2f20, ABISELECT(232,168), "S1333C2.s1333c2f20");
    check_field_offset(lv, s1333c2f21, ABISELECT(248,180), "S1333C2.s1333c2f21");
    test_class_info(&lv, &cd_S1333C2);
    dp->~S1333C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1333C2(Test_S1333C2, "S1333C2", ABISELECT(256,184));

#else // __cplusplus

extern void _ZN7S1333C2C1Ev();
extern void _ZN7S1333C2D1Ev();
Name_Map name_map_S1333C2[] = {
  NSPAIR(_ZN7S1333C2C1Ev),
  NSPAIR(_ZN7S1333C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1333C4;
extern VTBL_ENTRY _ZTI7S1333C4[];
extern  VTBL_ENTRY _ZTV7S1333C4[];
extern Class_Descriptor cd_S1333C3;
extern VTBL_ENTRY _ZTI7S1333C3[];
extern  VTBL_ENTRY _ZTV7S1333C3[];
static Base_Class bases_S1333C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1333C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1333C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1333C2[];
extern void _ZN7S1333C2D1Ev();
extern void _ZN7S1333C2D0Ev();
extern void _ZN7S1333C43v19Ev();
extern void _ZN7S1333C43v20Ev();
extern void _ZN7S1333C43v21Ev();
extern void _ZN7S1333C43v22Ev();
extern void _ZN7S1333C43v23Ev();
extern void _ZN7S1333C43v24Ev();
extern void _ZN7S1333C43v25Ev();
extern void _ZN7S1333C43v26Ev();
extern void _ZN7S1333C43v27Ev();
extern void _ZN7S1333C43v28Ev();
extern void _ZN7S1333C43v29Ev();
extern void _ZN7S1333C43v30Ev();
extern void _ZN7S1333C43v31Ev();
extern void _ZN7S1333C43v32Ev();
extern void _ZN7S1333C43v33Ev();
extern void _ZN7S1333C43v34Ev();
extern void _ZN7S1333C43v35Ev();
extern void _ZN7S1333C43v36Ev();
extern void _ZN7S1333C43v37Ev();
extern void _ZN7S1333C43v38Ev();
extern void _ZN7S1333C43v39Ev();
extern void _ZN7S1333C43v40Ev();
extern void _ZN7S1333C43v41Ev();
extern void _ZN7S1333C43v42Ev();
extern void _ZN7S1333C43v43Ev();
extern void _ZN7S1333C43v44Ev();
extern void _ZN7S1333C43v45Ev();
extern void _ZN7S1333C43v46Ev();
extern void _ZN7S1333C43v47Ev();
extern void _ZN7S1333C43v48Ev();
extern void _ZN7S1333C43v49Ev();
extern void _ZN7S1333C43v50Ev();
extern void _ZN7S1333C43v51Ev();
extern void _ZN7S1333C43v52Ev();
extern void _ZN7S1333C43v53Ev();
extern void _ZN7S1333C43v54Ev();
extern void _ZN7S1333C43v55Ev();
extern void _ZN7S1333C43v56Ev();
extern void _ZN7S1333C43v57Ev();
extern void _ZN7S1333C43v58Ev();
extern void _ZN7S1333C43v59Ev();
extern void _ZN7S1333C43v60Ev();
extern void _ZN7S1333C43v61Ev();
extern void _ZN7S1333C43v62Ev();
extern void _ZN7S1333C43v63Ev();
extern void _ZN7S1333C43v64Ev();
extern void _ZN7S1333C43v65Ev();
extern void _ZN7S1333C43v66Ev();
extern void _ZN7S1333C43v67Ev();
extern void _ZN7S1333C43v68Ev();
extern void _ZN7S1333C43v69Ev();
extern void _ZN7S1333C43v70Ev();
extern void _ZN7S1333C43v71Ev();
extern void _ZN7S1333C43v72Ev();
extern void _ZN7S1333C43v73Ev();
extern void _ZN7S1333C43v74Ev();
extern void _ZN7S1333C43v75Ev();
extern void _ZN7S1333C43v76Ev();
extern void _ZN7S1333C43v77Ev();
extern void _ZN7S1333C43v78Ev();
extern void _ZN7S1333C43v79Ev();
extern void _ZN7S1333C43v80Ev();
extern void _ZN7S1333C43v81Ev();
extern void _ZN7S1333C43v82Ev();
extern void _ZN7S1333C33v83Ev();
extern void _ZN7S1333C33v84Ev();
extern void _ZN7S1333C33v85Ev();
extern void _ZN7S1333C33v86Ev();
extern void _ZN7S1333C23v87Ev();
extern void _ZN7S1333C23v88Ev();
extern void _ZN7S1333C23v89Ev();
extern void _ZN7S1333C23v90Ev();
extern void _ZN7S1333C23v91Ev();
extern void _ZN7S1333C23v92Ev();
extern void _ZN7S1333C23v93Ev();
extern void _ZN7S1333C23v94Ev();
extern void _ZN7S1333C23v95Ev();
extern void _ZN7S1333C23v96Ev();
extern void _ZN7S1333C23v97Ev();
extern void _ZN7S1333C23v98Ev();
extern void _ZN7S1333C23v99Ev();
extern void _ZN7S1333C24v100Ev();
extern void _ZN7S1333C24v101Ev();
extern void _ZN7S1333C24v102Ev();
static  VTBL_ENTRY vtc_S1333C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1333C2[0]),
  (VTBL_ENTRY)&_ZN7S1333C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1333C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1333C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1333C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1333C24v102Ev,
};
extern VTBL_ENTRY _ZTI7S1333C2[];
extern  VTBL_ENTRY _ZTV7S1333C2[];
Class_Descriptor cd_S1333C2 = {  "S1333C2", // class name
  bases_S1333C2, 2,
  &(vtc_S1333C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,184), // object size
  NSPAIRA(_ZTI7S1333C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1333C2),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1333C1  : S1333C2 {
  int s1333c1f0[2];
  char s1333c1f1[4];
  void *s1333c1f2[2];
  unsigned int s1333c1f3:1;
  unsigned int s1333c1f4:1;
  unsigned int s1333c1f5:1;
  unsigned int s1333c1f6:1;
  ::S507C7 s1333c1f7;
  void *s1333c1f8;
  virtual  ~S1333C1(); // _ZN7S1333C1D1Ev
  virtual void  v1(); // _ZN7S1333C12v1Ev
  virtual void  v2(); // _ZN7S1333C12v2Ev
  virtual void  v3(); // _ZN7S1333C12v3Ev
  virtual void  v4(); // _ZN7S1333C12v4Ev
  virtual void  v5(); // _ZN7S1333C12v5Ev
  virtual void  v6(); // _ZN7S1333C12v6Ev
  virtual void  v7(); // _ZN7S1333C12v7Ev
  virtual void  v8(); // _ZN7S1333C12v8Ev
  virtual void  v9(); // _ZN7S1333C12v9Ev
  virtual void  v10(); // _ZN7S1333C13v10Ev
  virtual void  v11(); // _ZN7S1333C13v11Ev
  virtual void  v12(); // _ZN7S1333C13v12Ev
  virtual void  v13(); // _ZN7S1333C13v13Ev
  virtual void  v14(); // _ZN7S1333C13v14Ev
  virtual void  v15(); // _ZN7S1333C13v15Ev
  virtual void  v16(); // _ZN7S1333C13v16Ev
  virtual void  v17(); // _ZN7S1333C13v17Ev
  virtual void  v18(); // _ZN7S1333C13v18Ev
  S1333C1(); // tgen
};
//SIG(1 S1333C1) C1{ BC2{ BC3{ BC4{ vd v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v83 v84 v85 v86} vd v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC6{ BC7{ vd v105 v106 v107 v108 v109 Fi[8] Fp Fi Fp} v103 v104} Fi:1 Fc[3] Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 Fi[2] Fc[4] Fp[2] Fi:1 Fi:1 Fi:1 Fi:1 FC6 Fp}


 S1333C1 ::~S1333C1(){ note_dtor("S1333C1", this);}
void  S1333C1 ::v1(){vfunc_called(this, "_ZN7S1333C12v1Ev");}
void  S1333C1 ::v2(){vfunc_called(this, "_ZN7S1333C12v2Ev");}
void  S1333C1 ::v3(){vfunc_called(this, "_ZN7S1333C12v3Ev");}
void  S1333C1 ::v4(){vfunc_called(this, "_ZN7S1333C12v4Ev");}
void  S1333C1 ::v5(){vfunc_called(this, "_ZN7S1333C12v5Ev");}
void  S1333C1 ::v6(){vfunc_called(this, "_ZN7S1333C12v6Ev");}
void  S1333C1 ::v7(){vfunc_called(this, "_ZN7S1333C12v7Ev");}
void  S1333C1 ::v8(){vfunc_called(this, "_ZN7S1333C12v8Ev");}
void  S1333C1 ::v9(){vfunc_called(this, "_ZN7S1333C12v9Ev");}
void  S1333C1 ::v10(){vfunc_called(this, "_ZN7S1333C13v10Ev");}
void  S1333C1 ::v11(){vfunc_called(this, "_ZN7S1333C13v11Ev");}
void  S1333C1 ::v12(){vfunc_called(this, "_ZN7S1333C13v12Ev");}
void  S1333C1 ::v13(){vfunc_called(this, "_ZN7S1333C13v13Ev");}
void  S1333C1 ::v14(){vfunc_called(this, "_ZN7S1333C13v14Ev");}
void  S1333C1 ::v15(){vfunc_called(this, "_ZN7S1333C13v15Ev");}
void  S1333C1 ::v16(){vfunc_called(this, "_ZN7S1333C13v16Ev");}
void  S1333C1 ::v17(){vfunc_called(this, "_ZN7S1333C13v17Ev");}
void  S1333C1 ::v18(){vfunc_called(this, "_ZN7S1333C13v18Ev");}
S1333C1 ::S1333C1(){ note_ctor("S1333C1", this);} // tgen

static void Test_S1333C1()
{
  extern Class_Descriptor cd_S1333C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,66)];
    init_test(&cd_S1333C1, buf);
    S1333C1 *dp, &lv = *(dp=new (buf) S1333C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,260), "sizeof(S1333C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1333C1)");
    check_base_class_offset(lv, (S1333C4*)(S1333C3*)(S1333C2*), 0, "S1333C1");
    check_base_class_offset(lv, (S1333C3*)(S1333C2*), 0, "S1333C1");
    check_base_class_offset(lv, (S1333C2*), 0, "S1333C1");
    check_field_offset(lv, s1333c1f0, ABISELECT(256,184), "S1333C1.s1333c1f0");
    check_field_offset(lv, s1333c1f1, ABISELECT(264,192), "S1333C1.s1333c1f1");
    check_field_offset(lv, s1333c1f2, ABISELECT(272,196), "S1333C1.s1333c1f2");
    set_bf_and_test(lv, s1333c1f3, ABISELECT(288,204), 0, 1, 1, "S1333C1");
    set_bf_and_test(lv, s1333c1f4, ABISELECT(288,204), 1, 1, 1, "S1333C1");
    set_bf_and_test(lv, s1333c1f5, ABISELECT(288,204), 2, 1, 1, "S1333C1");
    set_bf_and_test(lv, s1333c1f6, ABISELECT(288,204), 3, 1, 1, "S1333C1");
    check_field_offset(lv, s1333c1f7, ABISELECT(296,208), "S1333C1.s1333c1f7");
    check_field_offset(lv, s1333c1f8, ABISELECT(360,256), "S1333C1.s1333c1f8");
    test_class_info(&lv, &cd_S1333C1);
    dp->~S1333C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1333C1(Test_S1333C1, "S1333C1", ABISELECT(368,260));

#else // __cplusplus

extern void _ZN7S1333C1C1Ev();
extern void _ZN7S1333C1D1Ev();
Name_Map name_map_S1333C1[] = {
  NSPAIR(_ZN7S1333C1C1Ev),
  NSPAIR(_ZN7S1333C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1333C4;
extern VTBL_ENTRY _ZTI7S1333C4[];
extern  VTBL_ENTRY _ZTV7S1333C4[];
extern Class_Descriptor cd_S1333C3;
extern VTBL_ENTRY _ZTI7S1333C3[];
extern  VTBL_ENTRY _ZTV7S1333C3[];
extern Class_Descriptor cd_S1333C2;
extern VTBL_ENTRY _ZTI7S1333C2[];
extern  VTBL_ENTRY _ZTV7S1333C2[];
static Base_Class bases_S1333C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1333C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1333C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1333C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1333C1[];
extern void _ZN7S1333C1D1Ev();
extern void _ZN7S1333C1D0Ev();
extern void _ZN7S1333C43v19Ev();
extern void _ZN7S1333C43v20Ev();
extern void _ZN7S1333C43v21Ev();
extern void _ZN7S1333C43v22Ev();
extern void _ZN7S1333C43v23Ev();
extern void _ZN7S1333C43v24Ev();
extern void _ZN7S1333C43v25Ev();
extern void _ZN7S1333C43v26Ev();
extern void _ZN7S1333C43v27Ev();
extern void _ZN7S1333C43v28Ev();
extern void _ZN7S1333C43v29Ev();
extern void _ZN7S1333C43v30Ev();
extern void _ZN7S1333C43v31Ev();
extern void _ZN7S1333C43v32Ev();
extern void _ZN7S1333C43v33Ev();
extern void _ZN7S1333C43v34Ev();
extern void _ZN7S1333C43v35Ev();
extern void _ZN7S1333C43v36Ev();
extern void _ZN7S1333C43v37Ev();
extern void _ZN7S1333C43v38Ev();
extern void _ZN7S1333C43v39Ev();
extern void _ZN7S1333C43v40Ev();
extern void _ZN7S1333C43v41Ev();
extern void _ZN7S1333C43v42Ev();
extern void _ZN7S1333C43v43Ev();
extern void _ZN7S1333C43v44Ev();
extern void _ZN7S1333C43v45Ev();
extern void _ZN7S1333C43v46Ev();
extern void _ZN7S1333C43v47Ev();
extern void _ZN7S1333C43v48Ev();
extern void _ZN7S1333C43v49Ev();
extern void _ZN7S1333C43v50Ev();
extern void _ZN7S1333C43v51Ev();
extern void _ZN7S1333C43v52Ev();
extern void _ZN7S1333C43v53Ev();
extern void _ZN7S1333C43v54Ev();
extern void _ZN7S1333C43v55Ev();
extern void _ZN7S1333C43v56Ev();
extern void _ZN7S1333C43v57Ev();
extern void _ZN7S1333C43v58Ev();
extern void _ZN7S1333C43v59Ev();
extern void _ZN7S1333C43v60Ev();
extern void _ZN7S1333C43v61Ev();
extern void _ZN7S1333C43v62Ev();
extern void _ZN7S1333C43v63Ev();
extern void _ZN7S1333C43v64Ev();
extern void _ZN7S1333C43v65Ev();
extern void _ZN7S1333C43v66Ev();
extern void _ZN7S1333C43v67Ev();
extern void _ZN7S1333C43v68Ev();
extern void _ZN7S1333C43v69Ev();
extern void _ZN7S1333C43v70Ev();
extern void _ZN7S1333C43v71Ev();
extern void _ZN7S1333C43v72Ev();
extern void _ZN7S1333C43v73Ev();
extern void _ZN7S1333C43v74Ev();
extern void _ZN7S1333C43v75Ev();
extern void _ZN7S1333C43v76Ev();
extern void _ZN7S1333C43v77Ev();
extern void _ZN7S1333C43v78Ev();
extern void _ZN7S1333C43v79Ev();
extern void _ZN7S1333C43v80Ev();
extern void _ZN7S1333C43v81Ev();
extern void _ZN7S1333C43v82Ev();
extern void _ZN7S1333C33v83Ev();
extern void _ZN7S1333C33v84Ev();
extern void _ZN7S1333C33v85Ev();
extern void _ZN7S1333C33v86Ev();
extern void _ZN7S1333C23v87Ev();
extern void _ZN7S1333C23v88Ev();
extern void _ZN7S1333C23v89Ev();
extern void _ZN7S1333C23v90Ev();
extern void _ZN7S1333C23v91Ev();
extern void _ZN7S1333C23v92Ev();
extern void _ZN7S1333C23v93Ev();
extern void _ZN7S1333C23v94Ev();
extern void _ZN7S1333C23v95Ev();
extern void _ZN7S1333C23v96Ev();
extern void _ZN7S1333C23v97Ev();
extern void _ZN7S1333C23v98Ev();
extern void _ZN7S1333C23v99Ev();
extern void _ZN7S1333C24v100Ev();
extern void _ZN7S1333C24v101Ev();
extern void _ZN7S1333C24v102Ev();
extern void _ZN7S1333C12v1Ev();
extern void _ZN7S1333C12v2Ev();
extern void _ZN7S1333C12v3Ev();
extern void _ZN7S1333C12v4Ev();
extern void _ZN7S1333C12v5Ev();
extern void _ZN7S1333C12v6Ev();
extern void _ZN7S1333C12v7Ev();
extern void _ZN7S1333C12v8Ev();
extern void _ZN7S1333C12v9Ev();
extern void _ZN7S1333C13v10Ev();
extern void _ZN7S1333C13v11Ev();
extern void _ZN7S1333C13v12Ev();
extern void _ZN7S1333C13v13Ev();
extern void _ZN7S1333C13v14Ev();
extern void _ZN7S1333C13v15Ev();
extern void _ZN7S1333C13v16Ev();
extern void _ZN7S1333C13v17Ev();
extern void _ZN7S1333C13v18Ev();
static  VTBL_ENTRY vtc_S1333C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1333C1[0]),
  (VTBL_ENTRY)&_ZN7S1333C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1333C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v76Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v77Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v78Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v79Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v80Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v81Ev,
  (VTBL_ENTRY)&_ZN7S1333C43v82Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1333C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v96Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v97Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v98Ev,
  (VTBL_ENTRY)&_ZN7S1333C23v99Ev,
  (VTBL_ENTRY)&_ZN7S1333C24v100Ev,
  (VTBL_ENTRY)&_ZN7S1333C24v101Ev,
  (VTBL_ENTRY)&_ZN7S1333C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1333C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1333C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1333C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1333C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1333C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1333C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1333C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1333C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1333C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1333C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1333C13v11Ev,
  (VTBL_ENTRY)&_ZN7S1333C13v12Ev,
  (VTBL_ENTRY)&_ZN7S1333C13v13Ev,
  (VTBL_ENTRY)&_ZN7S1333C13v14Ev,
  (VTBL_ENTRY)&_ZN7S1333C13v15Ev,
  (VTBL_ENTRY)&_ZN7S1333C13v16Ev,
  (VTBL_ENTRY)&_ZN7S1333C13v17Ev,
  (VTBL_ENTRY)&_ZN7S1333C13v18Ev,
};
extern VTBL_ENTRY _ZTI7S1333C1[];
extern  VTBL_ENTRY _ZTV7S1333C1[];
Class_Descriptor cd_S1333C1 = {  "S1333C1", // class name
  bases_S1333C1, 3,
  &(vtc_S1333C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,260), // object size
  NSPAIRA(_ZTI7S1333C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1333C1),106, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S483C5  {
  int s483c5f0;
  __tsi64 s483c5f1;
  void *s483c5f2[4];
  int s483c5f3[2];
  void *s483c5f4;
  ::S695C22_nt s483c5f5;
  void *s483c5f6[2];
  virtual  ~S483C5(); // _ZN6S483C5D1Ev
  virtual void  v12(); // _ZN6S483C53v12Ev
  virtual void  v13(); // _ZN6S483C53v13Ev
  virtual void  v14(); // _ZN6S483C53v14Ev
  virtual void  v15(); // _ZN6S483C53v15Ev
  virtual void  v16(); // _ZN6S483C53v16Ev
  virtual void  v17(); // _ZN6S483C53v17Ev
  virtual void  v18(); // _ZN6S483C53v18Ev
  virtual void  v19(); // _ZN6S483C53v19Ev
  virtual void  v20(); // _ZN6S483C53v20Ev
  virtual void  v21(); // _ZN6S483C53v21Ev
  virtual void  v22(); // _ZN6S483C53v22Ev
  virtual void  v23(); // _ZN6S483C53v23Ev
  virtual void  v24(); // _ZN6S483C53v24Ev
  virtual void  v25(); // _ZN6S483C53v25Ev
  virtual void  v26(); // _ZN6S483C53v26Ev
  virtual void  v27(); // _ZN6S483C53v27Ev
  virtual void  v28(); // _ZN6S483C53v28Ev
  virtual void  v29(); // _ZN6S483C53v29Ev
  virtual void  v30(); // _ZN6S483C53v30Ev
  virtual void  v31(); // _ZN6S483C53v31Ev
  virtual void  v32(); // _ZN6S483C53v32Ev
  virtual void  v33(); // _ZN6S483C53v33Ev
  virtual void  v34(); // _ZN6S483C53v34Ev
  virtual void  v35(); // _ZN6S483C53v35Ev
  virtual void  v36(); // _ZN6S483C53v36Ev
  virtual void  v37(); // _ZN6S483C53v37Ev
  virtual void  v38(); // _ZN6S483C53v38Ev
  virtual void  v39(); // _ZN6S483C53v39Ev
  virtual void  v40(); // _ZN6S483C53v40Ev
  virtual void  v41(); // _ZN6S483C53v41Ev
  virtual void  v42(); // _ZN6S483C53v42Ev
  virtual void  v43(); // _ZN6S483C53v43Ev
  virtual void  v44(); // _ZN6S483C53v44Ev
  virtual void  v45(); // _ZN6S483C53v45Ev
  virtual void  v46(); // _ZN6S483C53v46Ev
  virtual void  v47(); // _ZN6S483C53v47Ev
  virtual void  v48(); // _ZN6S483C53v48Ev
  virtual void  v49(); // _ZN6S483C53v49Ev
  virtual void  v50(); // _ZN6S483C53v50Ev
  virtual void  v51(); // _ZN6S483C53v51Ev
  virtual void  v52(); // _ZN6S483C53v52Ev
  virtual void  v53(); // _ZN6S483C53v53Ev
  virtual void  v54(); // _ZN6S483C53v54Ev
  virtual void  v55(); // _ZN6S483C53v55Ev
  virtual void  v56(); // _ZN6S483C53v56Ev
  virtual void  v57(); // _ZN6S483C53v57Ev
  virtual void  v58(); // _ZN6S483C53v58Ev
  virtual void  v59(); // _ZN6S483C53v59Ev
  virtual void  v60(); // _ZN6S483C53v60Ev
  virtual void  v61(); // _ZN6S483C53v61Ev
  virtual void  v62(); // _ZN6S483C53v62Ev
  virtual void  v63(); // _ZN6S483C53v63Ev
  virtual void  v64(); // _ZN6S483C53v64Ev
  virtual void  v65(); // _ZN6S483C53v65Ev
  virtual void  v66(); // _ZN6S483C53v66Ev
  virtual void  v67(); // _ZN6S483C53v67Ev
  virtual void  v68(); // _ZN6S483C53v68Ev
  virtual void  v69(); // _ZN6S483C53v69Ev
  virtual void  v70(); // _ZN6S483C53v70Ev
  virtual void  v71(); // _ZN6S483C53v71Ev
  virtual void  v72(); // _ZN6S483C53v72Ev
  virtual void  v73(); // _ZN6S483C53v73Ev
  virtual void  v74(); // _ZN6S483C53v74Ev
  virtual void  v75(); // _ZN6S483C53v75Ev
  S483C5(); // tgen
};
//SIG(-1 S483C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S483C5 ::~S483C5(){ note_dtor("S483C5", this);}
void  S483C5 ::v12(){vfunc_called(this, "_ZN6S483C53v12Ev");}
void  S483C5 ::v13(){vfunc_called(this, "_ZN6S483C53v13Ev");}
void  S483C5 ::v14(){vfunc_called(this, "_ZN6S483C53v14Ev");}
void  S483C5 ::v15(){vfunc_called(this, "_ZN6S483C53v15Ev");}
void  S483C5 ::v16(){vfunc_called(this, "_ZN6S483C53v16Ev");}
void  S483C5 ::v17(){vfunc_called(this, "_ZN6S483C53v17Ev");}
void  S483C5 ::v18(){vfunc_called(this, "_ZN6S483C53v18Ev");}
void  S483C5 ::v19(){vfunc_called(this, "_ZN6S483C53v19Ev");}
void  S483C5 ::v20(){vfunc_called(this, "_ZN6S483C53v20Ev");}
void  S483C5 ::v21(){vfunc_called(this, "_ZN6S483C53v21Ev");}
void  S483C5 ::v22(){vfunc_called(this, "_ZN6S483C53v22Ev");}
void  S483C5 ::v23(){vfunc_called(this, "_ZN6S483C53v23Ev");}
void  S483C5 ::v24(){vfunc_called(this, "_ZN6S483C53v24Ev");}
void  S483C5 ::v25(){vfunc_called(this, "_ZN6S483C53v25Ev");}
void  S483C5 ::v26(){vfunc_called(this, "_ZN6S483C53v26Ev");}
void  S483C5 ::v27(){vfunc_called(this, "_ZN6S483C53v27Ev");}
void  S483C5 ::v28(){vfunc_called(this, "_ZN6S483C53v28Ev");}
void  S483C5 ::v29(){vfunc_called(this, "_ZN6S483C53v29Ev");}
void  S483C5 ::v30(){vfunc_called(this, "_ZN6S483C53v30Ev");}
void  S483C5 ::v31(){vfunc_called(this, "_ZN6S483C53v31Ev");}
void  S483C5 ::v32(){vfunc_called(this, "_ZN6S483C53v32Ev");}
void  S483C5 ::v33(){vfunc_called(this, "_ZN6S483C53v33Ev");}
void  S483C5 ::v34(){vfunc_called(this, "_ZN6S483C53v34Ev");}
void  S483C5 ::v35(){vfunc_called(this, "_ZN6S483C53v35Ev");}
void  S483C5 ::v36(){vfunc_called(this, "_ZN6S483C53v36Ev");}
void  S483C5 ::v37(){vfunc_called(this, "_ZN6S483C53v37Ev");}
void  S483C5 ::v38(){vfunc_called(this, "_ZN6S483C53v38Ev");}
void  S483C5 ::v39(){vfunc_called(this, "_ZN6S483C53v39Ev");}
void  S483C5 ::v40(){vfunc_called(this, "_ZN6S483C53v40Ev");}
void  S483C5 ::v41(){vfunc_called(this, "_ZN6S483C53v41Ev");}
void  S483C5 ::v42(){vfunc_called(this, "_ZN6S483C53v42Ev");}
void  S483C5 ::v43(){vfunc_called(this, "_ZN6S483C53v43Ev");}
void  S483C5 ::v44(){vfunc_called(this, "_ZN6S483C53v44Ev");}
void  S483C5 ::v45(){vfunc_called(this, "_ZN6S483C53v45Ev");}
void  S483C5 ::v46(){vfunc_called(this, "_ZN6S483C53v46Ev");}
void  S483C5 ::v47(){vfunc_called(this, "_ZN6S483C53v47Ev");}
void  S483C5 ::v48(){vfunc_called(this, "_ZN6S483C53v48Ev");}
void  S483C5 ::v49(){vfunc_called(this, "_ZN6S483C53v49Ev");}
void  S483C5 ::v50(){vfunc_called(this, "_ZN6S483C53v50Ev");}
void  S483C5 ::v51(){vfunc_called(this, "_ZN6S483C53v51Ev");}
void  S483C5 ::v52(){vfunc_called(this, "_ZN6S483C53v52Ev");}
void  S483C5 ::v53(){vfunc_called(this, "_ZN6S483C53v53Ev");}
void  S483C5 ::v54(){vfunc_called(this, "_ZN6S483C53v54Ev");}
void  S483C5 ::v55(){vfunc_called(this, "_ZN6S483C53v55Ev");}
void  S483C5 ::v56(){vfunc_called(this, "_ZN6S483C53v56Ev");}
void  S483C5 ::v57(){vfunc_called(this, "_ZN6S483C53v57Ev");}
void  S483C5 ::v58(){vfunc_called(this, "_ZN6S483C53v58Ev");}
void  S483C5 ::v59(){vfunc_called(this, "_ZN6S483C53v59Ev");}
void  S483C5 ::v60(){vfunc_called(this, "_ZN6S483C53v60Ev");}
void  S483C5 ::v61(){vfunc_called(this, "_ZN6S483C53v61Ev");}
void  S483C5 ::v62(){vfunc_called(this, "_ZN6S483C53v62Ev");}
void  S483C5 ::v63(){vfunc_called(this, "_ZN6S483C53v63Ev");}
void  S483C5 ::v64(){vfunc_called(this, "_ZN6S483C53v64Ev");}
void  S483C5 ::v65(){vfunc_called(this, "_ZN6S483C53v65Ev");}
void  S483C5 ::v66(){vfunc_called(this, "_ZN6S483C53v66Ev");}
void  S483C5 ::v67(){vfunc_called(this, "_ZN6S483C53v67Ev");}
void  S483C5 ::v68(){vfunc_called(this, "_ZN6S483C53v68Ev");}
void  S483C5 ::v69(){vfunc_called(this, "_ZN6S483C53v69Ev");}
void  S483C5 ::v70(){vfunc_called(this, "_ZN6S483C53v70Ev");}
void  S483C5 ::v71(){vfunc_called(this, "_ZN6S483C53v71Ev");}
void  S483C5 ::v72(){vfunc_called(this, "_ZN6S483C53v72Ev");}
void  S483C5 ::v73(){vfunc_called(this, "_ZN6S483C53v73Ev");}
void  S483C5 ::v74(){vfunc_called(this, "_ZN6S483C53v74Ev");}
void  S483C5 ::v75(){vfunc_called(this, "_ZN6S483C53v75Ev");}
S483C5 ::S483C5(){ note_ctor("S483C5", this);} // tgen

static void Test_S483C5()
{
  extern Class_Descriptor cd_S483C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S483C5, buf);
    S483C5 *dp, &lv = *(dp=new (buf) S483C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S483C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S483C5)");
    check_field_offset(lv, s483c5f0, ABISELECT(8,4), "S483C5.s483c5f0");
    check_field_offset(lv, s483c5f1, ABISELECT(16,8), "S483C5.s483c5f1");
    check_field_offset(lv, s483c5f2, ABISELECT(24,16), "S483C5.s483c5f2");
    check_field_offset(lv, s483c5f3, ABISELECT(56,32), "S483C5.s483c5f3");
    check_field_offset(lv, s483c5f4, ABISELECT(64,40), "S483C5.s483c5f4");
    check_field_offset(lv, s483c5f5, ABISELECT(72,44), "S483C5.s483c5f5");
    check_field_offset(lv, s483c5f6, ABISELECT(80,52), "S483C5.s483c5f6");
    test_class_info(&lv, &cd_S483C5);
    dp->~S483C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS483C5(Test_S483C5, "S483C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S483C5C1Ev();
extern void _ZN6S483C5D1Ev();
Name_Map name_map_S483C5[] = {
  NSPAIR(_ZN6S483C5C1Ev),
  NSPAIR(_ZN6S483C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S483C5[];
extern void _ZN6S483C5D1Ev();
extern void _ZN6S483C5D0Ev();
extern void _ZN6S483C53v12Ev();
extern void _ZN6S483C53v13Ev();
extern void _ZN6S483C53v14Ev();
extern void _ZN6S483C53v15Ev();
extern void _ZN6S483C53v16Ev();
extern void _ZN6S483C53v17Ev();
extern void _ZN6S483C53v18Ev();
extern void _ZN6S483C53v19Ev();
extern void _ZN6S483C53v20Ev();
extern void _ZN6S483C53v21Ev();
extern void _ZN6S483C53v22Ev();
extern void _ZN6S483C53v23Ev();
extern void _ZN6S483C53v24Ev();
extern void _ZN6S483C53v25Ev();
extern void _ZN6S483C53v26Ev();
extern void _ZN6S483C53v27Ev();
extern void _ZN6S483C53v28Ev();
extern void _ZN6S483C53v29Ev();
extern void _ZN6S483C53v30Ev();
extern void _ZN6S483C53v31Ev();
extern void _ZN6S483C53v32Ev();
extern void _ZN6S483C53v33Ev();
extern void _ZN6S483C53v34Ev();
extern void _ZN6S483C53v35Ev();
extern void _ZN6S483C53v36Ev();
extern void _ZN6S483C53v37Ev();
extern void _ZN6S483C53v38Ev();
extern void _ZN6S483C53v39Ev();
extern void _ZN6S483C53v40Ev();
extern void _ZN6S483C53v41Ev();
extern void _ZN6S483C53v42Ev();
extern void _ZN6S483C53v43Ev();
extern void _ZN6S483C53v44Ev();
extern void _ZN6S483C53v45Ev();
extern void _ZN6S483C53v46Ev();
extern void _ZN6S483C53v47Ev();
extern void _ZN6S483C53v48Ev();
extern void _ZN6S483C53v49Ev();
extern void _ZN6S483C53v50Ev();
extern void _ZN6S483C53v51Ev();
extern void _ZN6S483C53v52Ev();
extern void _ZN6S483C53v53Ev();
extern void _ZN6S483C53v54Ev();
extern void _ZN6S483C53v55Ev();
extern void _ZN6S483C53v56Ev();
extern void _ZN6S483C53v57Ev();
extern void _ZN6S483C53v58Ev();
extern void _ZN6S483C53v59Ev();
extern void _ZN6S483C53v60Ev();
extern void _ZN6S483C53v61Ev();
extern void _ZN6S483C53v62Ev();
extern void _ZN6S483C53v63Ev();
extern void _ZN6S483C53v64Ev();
extern void _ZN6S483C53v65Ev();
extern void _ZN6S483C53v66Ev();
extern void _ZN6S483C53v67Ev();
extern void _ZN6S483C53v68Ev();
extern void _ZN6S483C53v69Ev();
extern void _ZN6S483C53v70Ev();
extern void _ZN6S483C53v71Ev();
extern void _ZN6S483C53v72Ev();
extern void _ZN6S483C53v73Ev();
extern void _ZN6S483C53v74Ev();
extern void _ZN6S483C53v75Ev();
static  VTBL_ENTRY vtc_S483C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S483C5[0]),
  (VTBL_ENTRY)&_ZN6S483C5D1Ev,
  (VTBL_ENTRY)&_ZN6S483C5D0Ev,
  (VTBL_ENTRY)&_ZN6S483C53v12Ev,
  (VTBL_ENTRY)&_ZN6S483C53v13Ev,
  (VTBL_ENTRY)&_ZN6S483C53v14Ev,
  (VTBL_ENTRY)&_ZN6S483C53v15Ev,
  (VTBL_ENTRY)&_ZN6S483C53v16Ev,
  (VTBL_ENTRY)&_ZN6S483C53v17Ev,
  (VTBL_ENTRY)&_ZN6S483C53v18Ev,
  (VTBL_ENTRY)&_ZN6S483C53v19Ev,
  (VTBL_ENTRY)&_ZN6S483C53v20Ev,
  (VTBL_ENTRY)&_ZN6S483C53v21Ev,
  (VTBL_ENTRY)&_ZN6S483C53v22Ev,
  (VTBL_ENTRY)&_ZN6S483C53v23Ev,
  (VTBL_ENTRY)&_ZN6S483C53v24Ev,
  (VTBL_ENTRY)&_ZN6S483C53v25Ev,
  (VTBL_ENTRY)&_ZN6S483C53v26Ev,
  (VTBL_ENTRY)&_ZN6S483C53v27Ev,
  (VTBL_ENTRY)&_ZN6S483C53v28Ev,
  (VTBL_ENTRY)&_ZN6S483C53v29Ev,
  (VTBL_ENTRY)&_ZN6S483C53v30Ev,
  (VTBL_ENTRY)&_ZN6S483C53v31Ev,
  (VTBL_ENTRY)&_ZN6S483C53v32Ev,
  (VTBL_ENTRY)&_ZN6S483C53v33Ev,
  (VTBL_ENTRY)&_ZN6S483C53v34Ev,
  (VTBL_ENTRY)&_ZN6S483C53v35Ev,
  (VTBL_ENTRY)&_ZN6S483C53v36Ev,
  (VTBL_ENTRY)&_ZN6S483C53v37Ev,
  (VTBL_ENTRY)&_ZN6S483C53v38Ev,
  (VTBL_ENTRY)&_ZN6S483C53v39Ev,
  (VTBL_ENTRY)&_ZN6S483C53v40Ev,
  (VTBL_ENTRY)&_ZN6S483C53v41Ev,
  (VTBL_ENTRY)&_ZN6S483C53v42Ev,
  (VTBL_ENTRY)&_ZN6S483C53v43Ev,
  (VTBL_ENTRY)&_ZN6S483C53v44Ev,
  (VTBL_ENTRY)&_ZN6S483C53v45Ev,
  (VTBL_ENTRY)&_ZN6S483C53v46Ev,
  (VTBL_ENTRY)&_ZN6S483C53v47Ev,
  (VTBL_ENTRY)&_ZN6S483C53v48Ev,
  (VTBL_ENTRY)&_ZN6S483C53v49Ev,
  (VTBL_ENTRY)&_ZN6S483C53v50Ev,
  (VTBL_ENTRY)&_ZN6S483C53v51Ev,
  (VTBL_ENTRY)&_ZN6S483C53v52Ev,
  (VTBL_ENTRY)&_ZN6S483C53v53Ev,
  (VTBL_ENTRY)&_ZN6S483C53v54Ev,
  (VTBL_ENTRY)&_ZN6S483C53v55Ev,
  (VTBL_ENTRY)&_ZN6S483C53v56Ev,
  (VTBL_ENTRY)&_ZN6S483C53v57Ev,
  (VTBL_ENTRY)&_ZN6S483C53v58Ev,
  (VTBL_ENTRY)&_ZN6S483C53v59Ev,
  (VTBL_ENTRY)&_ZN6S483C53v60Ev,
  (VTBL_ENTRY)&_ZN6S483C53v61Ev,
  (VTBL_ENTRY)&_ZN6S483C53v62Ev,
  (VTBL_ENTRY)&_ZN6S483C53v63Ev,
  (VTBL_ENTRY)&_ZN6S483C53v64Ev,
  (VTBL_ENTRY)&_ZN6S483C53v65Ev,
  (VTBL_ENTRY)&_ZN6S483C53v66Ev,
  (VTBL_ENTRY)&_ZN6S483C53v67Ev,
  (VTBL_ENTRY)&_ZN6S483C53v68Ev,
  (VTBL_ENTRY)&_ZN6S483C53v69Ev,
  (VTBL_ENTRY)&_ZN6S483C53v70Ev,
  (VTBL_ENTRY)&_ZN6S483C53v71Ev,
  (VTBL_ENTRY)&_ZN6S483C53v72Ev,
  (VTBL_ENTRY)&_ZN6S483C53v73Ev,
  (VTBL_ENTRY)&_ZN6S483C53v74Ev,
  (VTBL_ENTRY)&_ZN6S483C53v75Ev,
};
extern VTBL_ENTRY _ZTI6S483C5[];
extern  VTBL_ENTRY _ZTV6S483C5[];
Class_Descriptor cd_S483C5 = {  "S483C5", // class name
  0,0,//no base classes
  &(vtc_S483C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S483C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S483C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S483C4  : S483C5 {
  virtual  ~S483C4(); // _ZN6S483C4D1Ev
  virtual void  v76(); // _ZN6S483C43v76Ev
  virtual void  v77(); // _ZN6S483C43v77Ev
  virtual void  v78(); // _ZN6S483C43v78Ev
  virtual void  v79(); // _ZN6S483C43v79Ev
  S483C4(); // tgen
};
//SIG(-1 S483C4) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S483C4 ::~S483C4(){ note_dtor("S483C4", this);}
void  S483C4 ::v76(){vfunc_called(this, "_ZN6S483C43v76Ev");}
void  S483C4 ::v77(){vfunc_called(this, "_ZN6S483C43v77Ev");}
void  S483C4 ::v78(){vfunc_called(this, "_ZN6S483C43v78Ev");}
void  S483C4 ::v79(){vfunc_called(this, "_ZN6S483C43v79Ev");}
S483C4 ::S483C4(){ note_ctor("S483C4", this);} // tgen

static void Test_S483C4()
{
  extern Class_Descriptor cd_S483C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S483C4, buf);
    S483C4 *dp, &lv = *(dp=new (buf) S483C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S483C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S483C4)");
    check_base_class_offset(lv, (S483C5*), 0, "S483C4");
    test_class_info(&lv, &cd_S483C4);
    dp->~S483C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS483C4(Test_S483C4, "S483C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S483C4C1Ev();
extern void _ZN6S483C4D1Ev();
Name_Map name_map_S483C4[] = {
  NSPAIR(_ZN6S483C4C1Ev),
  NSPAIR(_ZN6S483C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S483C5;
extern VTBL_ENTRY _ZTI6S483C5[];
extern  VTBL_ENTRY _ZTV6S483C5[];
static Base_Class bases_S483C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S483C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S483C4[];
extern void _ZN6S483C4D1Ev();
extern void _ZN6S483C4D0Ev();
extern void _ZN6S483C53v12Ev();
extern void _ZN6S483C53v13Ev();
extern void _ZN6S483C53v14Ev();
extern void _ZN6S483C53v15Ev();
extern void _ZN6S483C53v16Ev();
extern void _ZN6S483C53v17Ev();
extern void _ZN6S483C53v18Ev();
extern void _ZN6S483C53v19Ev();
extern void _ZN6S483C53v20Ev();
extern void _ZN6S483C53v21Ev();
extern void _ZN6S483C53v22Ev();
extern void _ZN6S483C53v23Ev();
extern void _ZN6S483C53v24Ev();
extern void _ZN6S483C53v25Ev();
extern void _ZN6S483C53v26Ev();
extern void _ZN6S483C53v27Ev();
extern void _ZN6S483C53v28Ev();
extern void _ZN6S483C53v29Ev();
extern void _ZN6S483C53v30Ev();
extern void _ZN6S483C53v31Ev();
extern void _ZN6S483C53v32Ev();
extern void _ZN6S483C53v33Ev();
extern void _ZN6S483C53v34Ev();
extern void _ZN6S483C53v35Ev();
extern void _ZN6S483C53v36Ev();
extern void _ZN6S483C53v37Ev();
extern void _ZN6S483C53v38Ev();
extern void _ZN6S483C53v39Ev();
extern void _ZN6S483C53v40Ev();
extern void _ZN6S483C53v41Ev();
extern void _ZN6S483C53v42Ev();
extern void _ZN6S483C53v43Ev();
extern void _ZN6S483C53v44Ev();
extern void _ZN6S483C53v45Ev();
extern void _ZN6S483C53v46Ev();
extern void _ZN6S483C53v47Ev();
extern void _ZN6S483C53v48Ev();
extern void _ZN6S483C53v49Ev();
extern void _ZN6S483C53v50Ev();
extern void _ZN6S483C53v51Ev();
extern void _ZN6S483C53v52Ev();
extern void _ZN6S483C53v53Ev();
extern void _ZN6S483C53v54Ev();
extern void _ZN6S483C53v55Ev();
extern void _ZN6S483C53v56Ev();
extern void _ZN6S483C53v57Ev();
extern void _ZN6S483C53v58Ev();
extern void _ZN6S483C53v59Ev();
extern void _ZN6S483C53v60Ev();
extern void _ZN6S483C53v61Ev();
extern void _ZN6S483C53v62Ev();
extern void _ZN6S483C53v63Ev();
extern void _ZN6S483C53v64Ev();
extern void _ZN6S483C53v65Ev();
extern void _ZN6S483C53v66Ev();
extern void _ZN6S483C53v67Ev();
extern void _ZN6S483C53v68Ev();
extern void _ZN6S483C53v69Ev();
extern void _ZN6S483C53v70Ev();
extern void _ZN6S483C53v71Ev();
extern void _ZN6S483C53v72Ev();
extern void _ZN6S483C53v73Ev();
extern void _ZN6S483C53v74Ev();
extern void _ZN6S483C53v75Ev();
extern void _ZN6S483C43v76Ev();
extern void _ZN6S483C43v77Ev();
extern void _ZN6S483C43v78Ev();
extern void _ZN6S483C43v79Ev();
static  VTBL_ENTRY vtc_S483C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S483C4[0]),
  (VTBL_ENTRY)&_ZN6S483C4D1Ev,
  (VTBL_ENTRY)&_ZN6S483C4D0Ev,
  (VTBL_ENTRY)&_ZN6S483C53v12Ev,
  (VTBL_ENTRY)&_ZN6S483C53v13Ev,
  (VTBL_ENTRY)&_ZN6S483C53v14Ev,
  (VTBL_ENTRY)&_ZN6S483C53v15Ev,
  (VTBL_ENTRY)&_ZN6S483C53v16Ev,
  (VTBL_ENTRY)&_ZN6S483C53v17Ev,
  (VTBL_ENTRY)&_ZN6S483C53v18Ev,
  (VTBL_ENTRY)&_ZN6S483C53v19Ev,
  (VTBL_ENTRY)&_ZN6S483C53v20Ev,
  (VTBL_ENTRY)&_ZN6S483C53v21Ev,
  (VTBL_ENTRY)&_ZN6S483C53v22Ev,
  (VTBL_ENTRY)&_ZN6S483C53v23Ev,
  (VTBL_ENTRY)&_ZN6S483C53v24Ev,
  (VTBL_ENTRY)&_ZN6S483C53v25Ev,
  (VTBL_ENTRY)&_ZN6S483C53v26Ev,
  (VTBL_ENTRY)&_ZN6S483C53v27Ev,
  (VTBL_ENTRY)&_ZN6S483C53v28Ev,
  (VTBL_ENTRY)&_ZN6S483C53v29Ev,
  (VTBL_ENTRY)&_ZN6S483C53v30Ev,
  (VTBL_ENTRY)&_ZN6S483C53v31Ev,
  (VTBL_ENTRY)&_ZN6S483C53v32Ev,
  (VTBL_ENTRY)&_ZN6S483C53v33Ev,
  (VTBL_ENTRY)&_ZN6S483C53v34Ev,
  (VTBL_ENTRY)&_ZN6S483C53v35Ev,
  (VTBL_ENTRY)&_ZN6S483C53v36Ev,
  (VTBL_ENTRY)&_ZN6S483C53v37Ev,
  (VTBL_ENTRY)&_ZN6S483C53v38Ev,
  (VTBL_ENTRY)&_ZN6S483C53v39Ev,
  (VTBL_ENTRY)&_ZN6S483C53v40Ev,
  (VTBL_ENTRY)&_ZN6S483C53v41Ev,
  (VTBL_ENTRY)&_ZN6S483C53v42Ev,
  (VTBL_ENTRY)&_ZN6S483C53v43Ev,
  (VTBL_ENTRY)&_ZN6S483C53v44Ev,
  (VTBL_ENTRY)&_ZN6S483C53v45Ev,
  (VTBL_ENTRY)&_ZN6S483C53v46Ev,
  (VTBL_ENTRY)&_ZN6S483C53v47Ev,
  (VTBL_ENTRY)&_ZN6S483C53v48Ev,
  (VTBL_ENTRY)&_ZN6S483C53v49Ev,
  (VTBL_ENTRY)&_ZN6S483C53v50Ev,
  (VTBL_ENTRY)&_ZN6S483C53v51Ev,
  (VTBL_ENTRY)&_ZN6S483C53v52Ev,
  (VTBL_ENTRY)&_ZN6S483C53v53Ev,
  (VTBL_ENTRY)&_ZN6S483C53v54Ev,
  (VTBL_ENTRY)&_ZN6S483C53v55Ev,
  (VTBL_ENTRY)&_ZN6S483C53v56Ev,
  (VTBL_ENTRY)&_ZN6S483C53v57Ev,
  (VTBL_ENTRY)&_ZN6S483C53v58Ev,
  (VTBL_ENTRY)&_ZN6S483C53v59Ev,
  (VTBL_ENTRY)&_ZN6S483C53v60Ev,
  (VTBL_ENTRY)&_ZN6S483C53v61Ev,
  (VTBL_ENTRY)&_ZN6S483C53v62Ev,
  (VTBL_ENTRY)&_ZN6S483C53v63Ev,
  (VTBL_ENTRY)&_ZN6S483C53v64Ev,
  (VTBL_ENTRY)&_ZN6S483C53v65Ev,
  (VTBL_ENTRY)&_ZN6S483C53v66Ev,
  (VTBL_ENTRY)&_ZN6S483C53v67Ev,
  (VTBL_ENTRY)&_ZN6S483C53v68Ev,
  (VTBL_ENTRY)&_ZN6S483C53v69Ev,
  (VTBL_ENTRY)&_ZN6S483C53v70Ev,
  (VTBL_ENTRY)&_ZN6S483C53v71Ev,
  (VTBL_ENTRY)&_ZN6S483C53v72Ev,
  (VTBL_ENTRY)&_ZN6S483C53v73Ev,
  (VTBL_ENTRY)&_ZN6S483C53v74Ev,
  (VTBL_ENTRY)&_ZN6S483C53v75Ev,
  (VTBL_ENTRY)&_ZN6S483C43v76Ev,
  (VTBL_ENTRY)&_ZN6S483C43v77Ev,
  (VTBL_ENTRY)&_ZN6S483C43v78Ev,
  (VTBL_ENTRY)&_ZN6S483C43v79Ev,
};
extern VTBL_ENTRY _ZTI6S483C4[];
extern  VTBL_ENTRY _ZTV6S483C4[];
Class_Descriptor cd_S483C4 = {  "S483C4", // class name
  bases_S483C4, 1,
  &(vtc_S483C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S483C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S483C4),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S483C3  : S483C4 {
  unsigned int s483c3f0:1;
  unsigned int s483c3f1:1;
  unsigned int s483c3f2:1;
  unsigned int s483c3f3:1;
  unsigned int s483c3f4:1;
  unsigned int s483c3f5:1;
  unsigned int s483c3f6:1;
  unsigned int s483c3f7:1;
  unsigned int s483c3f8:1;
  unsigned int s483c3f9:1;
  unsigned int s483c3f10:1;
  unsigned int s483c3f11:1;
  unsigned int s483c3f12:1;
  int s483c3f13[8];
  ::S507C7 s483c3f14;
  unsigned int s483c3f15:1;
  char s483c3f16;
  char s483c3f17[2];
  int s483c3f18[2];
  ::S685C27_nt s483c3f19;
  ::S685C27_nt s483c3f20;
  void *s483c3f21;
  virtual  ~S483C3(); // _ZN6S483C3D1Ev
  virtual void  v80(); // _ZN6S483C33v80Ev
  virtual void  v81(); // _ZN6S483C33v81Ev
  virtual void  v82(); // _ZN6S483C33v82Ev
  virtual void  v83(); // _ZN6S483C33v83Ev
  virtual void  v84(); // _ZN6S483C33v84Ev
  virtual void  v85(); // _ZN6S483C33v85Ev
  virtual void  v86(); // _ZN6S483C33v86Ev
  virtual void  v87(); // _ZN6S483C33v87Ev
  virtual void  v88(); // _ZN6S483C33v88Ev
  virtual void  v89(); // _ZN6S483C33v89Ev
  virtual void  v90(); // _ZN6S483C33v90Ev
  virtual void  v91(); // _ZN6S483C33v91Ev
  virtual void  v92(); // _ZN6S483C33v92Ev
  virtual void  v93(); // _ZN6S483C33v93Ev
  virtual void  v94(); // _ZN6S483C33v94Ev
  virtual void  v95(); // _ZN6S483C33v95Ev
  S483C3(); // tgen
};
//SIG(-1 S483C3) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC5{ BC6{ vd v87 v88 v89 v90 v91 Fi[8] Fp Fi Fp} v85 v86} Fi:1 Fc[3] Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 Fp}


 S483C3 ::~S483C3(){ note_dtor("S483C3", this);}
void  S483C3 ::v80(){vfunc_called(this, "_ZN6S483C33v80Ev");}
void  S483C3 ::v81(){vfunc_called(this, "_ZN6S483C33v81Ev");}
void  S483C3 ::v82(){vfunc_called(this, "_ZN6S483C33v82Ev");}
void  S483C3 ::v83(){vfunc_called(this, "_ZN6S483C33v83Ev");}
void  S483C3 ::v84(){vfunc_called(this, "_ZN6S483C33v84Ev");}
void  S483C3 ::v85(){vfunc_called(this, "_ZN6S483C33v85Ev");}
void  S483C3 ::v86(){vfunc_called(this, "_ZN6S483C33v86Ev");}
void  S483C3 ::v87(){vfunc_called(this, "_ZN6S483C33v87Ev");}
void  S483C3 ::v88(){vfunc_called(this, "_ZN6S483C33v88Ev");}
void  S483C3 ::v89(){vfunc_called(this, "_ZN6S483C33v89Ev");}
void  S483C3 ::v90(){vfunc_called(this, "_ZN6S483C33v90Ev");}
void  S483C3 ::v91(){vfunc_called(this, "_ZN6S483C33v91Ev");}
void  S483C3 ::v92(){vfunc_called(this, "_ZN6S483C33v92Ev");}
void  S483C3 ::v93(){vfunc_called(this, "_ZN6S483C33v93Ev");}
void  S483C3 ::v94(){vfunc_called(this, "_ZN6S483C33v94Ev");}
void  S483C3 ::v95(){vfunc_called(this, "_ZN6S483C33v95Ev");}
S483C3 ::S483C3(){ note_ctor("S483C3", this);} // tgen

static void Test_S483C3()
{
  extern Class_Descriptor cd_S483C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,47)];
    init_test(&cd_S483C3, buf);
    S483C3 *dp, &lv = *(dp=new (buf) S483C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,184), "sizeof(S483C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S483C3)");
    check_base_class_offset(lv, (S483C5*)(S483C4*), 0, "S483C3");
    check_base_class_offset(lv, (S483C4*), 0, "S483C3");
    set_bf_and_test(lv, s483c3f0, ABISELECT(96,60), 0, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f1, ABISELECT(96,60), 1, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f2, ABISELECT(96,60), 2, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f3, ABISELECT(96,60), 3, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f4, ABISELECT(96,60), 4, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f5, ABISELECT(96,60), 5, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f6, ABISELECT(96,60), 6, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f7, ABISELECT(96,60), 7, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f8, ABISELECT(97,61), 0, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f9, ABISELECT(97,61), 1, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f10, ABISELECT(97,61), 2, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f11, ABISELECT(97,61), 3, 1, 1, "S483C3");
    set_bf_and_test(lv, s483c3f12, ABISELECT(97,61), 4, 1, 1, "S483C3");
    check_field_offset(lv, s483c3f13, ABISELECT(100,64), "S483C3.s483c3f13");
    check_field_offset(lv, s483c3f14, ABISELECT(136,96), "S483C3.s483c3f14");
    set_bf_and_test(lv, s483c3f15, ABISELECT(200,144), 0, 1, 1, "S483C3");
    check_field_offset(lv, s483c3f16, ABISELECT(201,145), "S483C3.s483c3f16");
    check_field_offset(lv, s483c3f17, ABISELECT(202,146), "S483C3.s483c3f17");
    check_field_offset(lv, s483c3f18, ABISELECT(204,148), "S483C3.s483c3f18");
    check_field_offset(lv, s483c3f19, ABISELECT(216,156), "S483C3.s483c3f19");
    check_field_offset(lv, s483c3f20, ABISELECT(232,168), "S483C3.s483c3f20");
    check_field_offset(lv, s483c3f21, ABISELECT(248,180), "S483C3.s483c3f21");
    test_class_info(&lv, &cd_S483C3);
    dp->~S483C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS483C3(Test_S483C3, "S483C3", ABISELECT(256,184));

#else // __cplusplus

extern void _ZN6S483C3C1Ev();
extern void _ZN6S483C3D1Ev();
Name_Map name_map_S483C3[] = {
  NSPAIR(_ZN6S483C3C1Ev),
  NSPAIR(_ZN6S483C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S483C5;
extern VTBL_ENTRY _ZTI6S483C5[];
extern  VTBL_ENTRY _ZTV6S483C5[];
extern Class_Descriptor cd_S483C4;
extern VTBL_ENTRY _ZTI6S483C4[];
extern  VTBL_ENTRY _ZTV6S483C4[];
static Base_Class bases_S483C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S483C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S483C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S483C3[];
extern void _ZN6S483C3D1Ev();
extern void _ZN6S483C3D0Ev();
extern void _ZN6S483C53v12Ev();
extern void _ZN6S483C53v13Ev();
extern void _ZN6S483C53v14Ev();
extern void _ZN6S483C53v15Ev();
extern void _ZN6S483C53v16Ev();
extern void _ZN6S483C53v17Ev();
extern void _ZN6S483C53v18Ev();
extern void _ZN6S483C53v19Ev();
extern void _ZN6S483C53v20Ev();
extern void _ZN6S483C53v21Ev();
extern void _ZN6S483C53v22Ev();
extern void _ZN6S483C53v23Ev();
extern void _ZN6S483C53v24Ev();
extern void _ZN6S483C53v25Ev();
extern void _ZN6S483C53v26Ev();
extern void _ZN6S483C53v27Ev();
extern void _ZN6S483C53v28Ev();
extern void _ZN6S483C53v29Ev();
extern void _ZN6S483C53v30Ev();
extern void _ZN6S483C53v31Ev();
extern void _ZN6S483C53v32Ev();
extern void _ZN6S483C53v33Ev();
extern void _ZN6S483C53v34Ev();
extern void _ZN6S483C53v35Ev();
extern void _ZN6S483C53v36Ev();
extern void _ZN6S483C53v37Ev();
extern void _ZN6S483C53v38Ev();
extern void _ZN6S483C53v39Ev();
extern void _ZN6S483C53v40Ev();
extern void _ZN6S483C53v41Ev();
extern void _ZN6S483C53v42Ev();
extern void _ZN6S483C53v43Ev();
extern void _ZN6S483C53v44Ev();
extern void _ZN6S483C53v45Ev();
extern void _ZN6S483C53v46Ev();
extern void _ZN6S483C53v47Ev();
extern void _ZN6S483C53v48Ev();
extern void _ZN6S483C53v49Ev();
extern void _ZN6S483C53v50Ev();
extern void _ZN6S483C53v51Ev();
extern void _ZN6S483C53v52Ev();
extern void _ZN6S483C53v53Ev();
extern void _ZN6S483C53v54Ev();
extern void _ZN6S483C53v55Ev();
extern void _ZN6S483C53v56Ev();
extern void _ZN6S483C53v57Ev();
extern void _ZN6S483C53v58Ev();
extern void _ZN6S483C53v59Ev();
extern void _ZN6S483C53v60Ev();
extern void _ZN6S483C53v61Ev();
extern void _ZN6S483C53v62Ev();
extern void _ZN6S483C53v63Ev();
extern void _ZN6S483C53v64Ev();
extern void _ZN6S483C53v65Ev();
extern void _ZN6S483C53v66Ev();
extern void _ZN6S483C53v67Ev();
extern void _ZN6S483C53v68Ev();
extern void _ZN6S483C53v69Ev();
extern void _ZN6S483C53v70Ev();
extern void _ZN6S483C53v71Ev();
extern void _ZN6S483C53v72Ev();
extern void _ZN6S483C53v73Ev();
extern void _ZN6S483C53v74Ev();
extern void _ZN6S483C53v75Ev();
extern void _ZN6S483C43v76Ev();
extern void _ZN6S483C43v77Ev();
extern void _ZN6S483C43v78Ev();
extern void _ZN6S483C43v79Ev();
extern void _ZN6S483C33v80Ev();
extern void _ZN6S483C33v81Ev();
extern void _ZN6S483C33v82Ev();
extern void _ZN6S483C33v83Ev();
extern void _ZN6S483C33v84Ev();
extern void _ZN6S483C33v85Ev();
extern void _ZN6S483C33v86Ev();
extern void _ZN6S483C33v87Ev();
extern void _ZN6S483C33v88Ev();
extern void _ZN6S483C33v89Ev();
extern void _ZN6S483C33v90Ev();
extern void _ZN6S483C33v91Ev();
extern void _ZN6S483C33v92Ev();
extern void _ZN6S483C33v93Ev();
extern void _ZN6S483C33v94Ev();
extern void _ZN6S483C33v95Ev();
static  VTBL_ENTRY vtc_S483C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S483C3[0]),
  (VTBL_ENTRY)&_ZN6S483C3D1Ev,
  (VTBL_ENTRY)&_ZN6S483C3D0Ev,
  (VTBL_ENTRY)&_ZN6S483C53v12Ev,
  (VTBL_ENTRY)&_ZN6S483C53v13Ev,
  (VTBL_ENTRY)&_ZN6S483C53v14Ev,
  (VTBL_ENTRY)&_ZN6S483C53v15Ev,
  (VTBL_ENTRY)&_ZN6S483C53v16Ev,
  (VTBL_ENTRY)&_ZN6S483C53v17Ev,
  (VTBL_ENTRY)&_ZN6S483C53v18Ev,
  (VTBL_ENTRY)&_ZN6S483C53v19Ev,
  (VTBL_ENTRY)&_ZN6S483C53v20Ev,
  (VTBL_ENTRY)&_ZN6S483C53v21Ev,
  (VTBL_ENTRY)&_ZN6S483C53v22Ev,
  (VTBL_ENTRY)&_ZN6S483C53v23Ev,
  (VTBL_ENTRY)&_ZN6S483C53v24Ev,
  (VTBL_ENTRY)&_ZN6S483C53v25Ev,
  (VTBL_ENTRY)&_ZN6S483C53v26Ev,
  (VTBL_ENTRY)&_ZN6S483C53v27Ev,
  (VTBL_ENTRY)&_ZN6S483C53v28Ev,
  (VTBL_ENTRY)&_ZN6S483C53v29Ev,
  (VTBL_ENTRY)&_ZN6S483C53v30Ev,
  (VTBL_ENTRY)&_ZN6S483C53v31Ev,
  (VTBL_ENTRY)&_ZN6S483C53v32Ev,
  (VTBL_ENTRY)&_ZN6S483C53v33Ev,
  (VTBL_ENTRY)&_ZN6S483C53v34Ev,
  (VTBL_ENTRY)&_ZN6S483C53v35Ev,
  (VTBL_ENTRY)&_ZN6S483C53v36Ev,
  (VTBL_ENTRY)&_ZN6S483C53v37Ev,
  (VTBL_ENTRY)&_ZN6S483C53v38Ev,
  (VTBL_ENTRY)&_ZN6S483C53v39Ev,
  (VTBL_ENTRY)&_ZN6S483C53v40Ev,
  (VTBL_ENTRY)&_ZN6S483C53v41Ev,
  (VTBL_ENTRY)&_ZN6S483C53v42Ev,
  (VTBL_ENTRY)&_ZN6S483C53v43Ev,
  (VTBL_ENTRY)&_ZN6S483C53v44Ev,
  (VTBL_ENTRY)&_ZN6S483C53v45Ev,
  (VTBL_ENTRY)&_ZN6S483C53v46Ev,
  (VTBL_ENTRY)&_ZN6S483C53v47Ev,
  (VTBL_ENTRY)&_ZN6S483C53v48Ev,
  (VTBL_ENTRY)&_ZN6S483C53v49Ev,
  (VTBL_ENTRY)&_ZN6S483C53v50Ev,
  (VTBL_ENTRY)&_ZN6S483C53v51Ev,
  (VTBL_ENTRY)&_ZN6S483C53v52Ev,
  (VTBL_ENTRY)&_ZN6S483C53v53Ev,
  (VTBL_ENTRY)&_ZN6S483C53v54Ev,
  (VTBL_ENTRY)&_ZN6S483C53v55Ev,
  (VTBL_ENTRY)&_ZN6S483C53v56Ev,
  (VTBL_ENTRY)&_ZN6S483C53v57Ev,
  (VTBL_ENTRY)&_ZN6S483C53v58Ev,
  (VTBL_ENTRY)&_ZN6S483C53v59Ev,
  (VTBL_ENTRY)&_ZN6S483C53v60Ev,
  (VTBL_ENTRY)&_ZN6S483C53v61Ev,
  (VTBL_ENTRY)&_ZN6S483C53v62Ev,
  (VTBL_ENTRY)&_ZN6S483C53v63Ev,
  (VTBL_ENTRY)&_ZN6S483C53v64Ev,
  (VTBL_ENTRY)&_ZN6S483C53v65Ev,
  (VTBL_ENTRY)&_ZN6S483C53v66Ev,
  (VTBL_ENTRY)&_ZN6S483C53v67Ev,
  (VTBL_ENTRY)&_ZN6S483C53v68Ev,
  (VTBL_ENTRY)&_ZN6S483C53v69Ev,
  (VTBL_ENTRY)&_ZN6S483C53v70Ev,
  (VTBL_ENTRY)&_ZN6S483C53v71Ev,
  (VTBL_ENTRY)&_ZN6S483C53v72Ev,
  (VTBL_ENTRY)&_ZN6S483C53v73Ev,
  (VTBL_ENTRY)&_ZN6S483C53v74Ev,
  (VTBL_ENTRY)&_ZN6S483C53v75Ev,
  (VTBL_ENTRY)&_ZN6S483C43v76Ev,
  (VTBL_ENTRY)&_ZN6S483C43v77Ev,
  (VTBL_ENTRY)&_ZN6S483C43v78Ev,
  (VTBL_ENTRY)&_ZN6S483C43v79Ev,
  (VTBL_ENTRY)&_ZN6S483C33v80Ev,
  (VTBL_ENTRY)&_ZN6S483C33v81Ev,
  (VTBL_ENTRY)&_ZN6S483C33v82Ev,
  (VTBL_ENTRY)&_ZN6S483C33v83Ev,
  (VTBL_ENTRY)&_ZN6S483C33v84Ev,
  (VTBL_ENTRY)&_ZN6S483C33v85Ev,
  (VTBL_ENTRY)&_ZN6S483C33v86Ev,
  (VTBL_ENTRY)&_ZN6S483C33v87Ev,
  (VTBL_ENTRY)&_ZN6S483C33v88Ev,
  (VTBL_ENTRY)&_ZN6S483C33v89Ev,
  (VTBL_ENTRY)&_ZN6S483C33v90Ev,
  (VTBL_ENTRY)&_ZN6S483C33v91Ev,
  (VTBL_ENTRY)&_ZN6S483C33v92Ev,
  (VTBL_ENTRY)&_ZN6S483C33v93Ev,
  (VTBL_ENTRY)&_ZN6S483C33v94Ev,
  (VTBL_ENTRY)&_ZN6S483C33v95Ev,
};
extern VTBL_ENTRY _ZTI6S483C3[];
extern  VTBL_ENTRY _ZTV6S483C3[];
Class_Descriptor cd_S483C3 = {  "S483C3", // class name
  bases_S483C3, 2,
  &(vtc_S483C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,184), // object size
  NSPAIRA(_ZTI6S483C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S483C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S483C2  : S483C3 {
  unsigned int s483c2f0:1;
  unsigned int s483c2f1:1;
  unsigned int s483c2f2:1;
  virtual  ~S483C2(); // _ZN6S483C2D1Ev
  virtual void  v96(); // _ZN6S483C23v96Ev
  virtual void  v97(); // _ZN6S483C23v97Ev
  virtual void  v98(); // _ZN6S483C23v98Ev
  virtual void  v99(); // _ZN6S483C23v99Ev
  virtual void  v100(); // _ZN6S483C24v100Ev
  S483C2(); // tgen
};
//SIG(-1 S483C2) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC6{ BC7{ vd v92 v93 v94 v95 v96 Fi[8] Fp Fi Fp} v90 v91} Fi:1 Fc[3] Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 Fp} vd v1 v2 v3 v4 v5 Fi:1 Fi:1 Fi:1}


 S483C2 ::~S483C2(){ note_dtor("S483C2", this);}
void  S483C2 ::v96(){vfunc_called(this, "_ZN6S483C23v96Ev");}
void  S483C2 ::v97(){vfunc_called(this, "_ZN6S483C23v97Ev");}
void  S483C2 ::v98(){vfunc_called(this, "_ZN6S483C23v98Ev");}
void  S483C2 ::v99(){vfunc_called(this, "_ZN6S483C23v99Ev");}
void  S483C2 ::v100(){vfunc_called(this, "_ZN6S483C24v100Ev");}
S483C2 ::S483C2(){ note_ctor("S483C2", this);} // tgen

static void Test_S483C2()
{
  extern Class_Descriptor cd_S483C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,48)];
    init_test(&cd_S483C2, buf);
    S483C2 *dp, &lv = *(dp=new (buf) S483C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,188), "sizeof(S483C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S483C2)");
    check_base_class_offset(lv, (S483C5*)(S483C4*)(S483C3*), 0, "S483C2");
    check_base_class_offset(lv, (S483C4*)(S483C3*), 0, "S483C2");
    check_base_class_offset(lv, (S483C3*), 0, "S483C2");
    set_bf_and_test(lv, s483c2f0, ABISELECT(256,184), 0, 1, 1, "S483C2");
    set_bf_and_test(lv, s483c2f1, ABISELECT(256,184), 1, 1, 1, "S483C2");
    set_bf_and_test(lv, s483c2f2, ABISELECT(256,184), 2, 1, 1, "S483C2");
    test_class_info(&lv, &cd_S483C2);
    dp->~S483C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS483C2(Test_S483C2, "S483C2", ABISELECT(264,188));

#else // __cplusplus

extern void _ZN6S483C2C1Ev();
extern void _ZN6S483C2D1Ev();
Name_Map name_map_S483C2[] = {
  NSPAIR(_ZN6S483C2C1Ev),
  NSPAIR(_ZN6S483C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S483C5;
extern VTBL_ENTRY _ZTI6S483C5[];
extern  VTBL_ENTRY _ZTV6S483C5[];
extern Class_Descriptor cd_S483C4;
extern VTBL_ENTRY _ZTI6S483C4[];
extern  VTBL_ENTRY _ZTV6S483C4[];
extern Class_Descriptor cd_S483C3;
extern VTBL_ENTRY _ZTI6S483C3[];
extern  VTBL_ENTRY _ZTV6S483C3[];
static Base_Class bases_S483C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S483C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S483C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S483C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S483C2[];
extern void _ZN6S483C2D1Ev();
extern void _ZN6S483C2D0Ev();
extern void _ZN6S483C53v12Ev();
extern void _ZN6S483C53v13Ev();
extern void _ZN6S483C53v14Ev();
extern void _ZN6S483C53v15Ev();
extern void _ZN6S483C53v16Ev();
extern void _ZN6S483C53v17Ev();
extern void _ZN6S483C53v18Ev();
extern void _ZN6S483C53v19Ev();
extern void _ZN6S483C53v20Ev();
extern void _ZN6S483C53v21Ev();
extern void _ZN6S483C53v22Ev();
extern void _ZN6S483C53v23Ev();
extern void _ZN6S483C53v24Ev();
extern void _ZN6S483C53v25Ev();
extern void _ZN6S483C53v26Ev();
extern void _ZN6S483C53v27Ev();
extern void _ZN6S483C53v28Ev();
extern void _ZN6S483C53v29Ev();
extern void _ZN6S483C53v30Ev();
extern void _ZN6S483C53v31Ev();
extern void _ZN6S483C53v32Ev();
extern void _ZN6S483C53v33Ev();
extern void _ZN6S483C53v34Ev();
extern void _ZN6S483C53v35Ev();
extern void _ZN6S483C53v36Ev();
extern void _ZN6S483C53v37Ev();
extern void _ZN6S483C53v38Ev();
extern void _ZN6S483C53v39Ev();
extern void _ZN6S483C53v40Ev();
extern void _ZN6S483C53v41Ev();
extern void _ZN6S483C53v42Ev();
extern void _ZN6S483C53v43Ev();
extern void _ZN6S483C53v44Ev();
extern void _ZN6S483C53v45Ev();
extern void _ZN6S483C53v46Ev();
extern void _ZN6S483C53v47Ev();
extern void _ZN6S483C53v48Ev();
extern void _ZN6S483C53v49Ev();
extern void _ZN6S483C53v50Ev();
extern void _ZN6S483C53v51Ev();
extern void _ZN6S483C53v52Ev();
extern void _ZN6S483C53v53Ev();
extern void _ZN6S483C53v54Ev();
extern void _ZN6S483C53v55Ev();
extern void _ZN6S483C53v56Ev();
extern void _ZN6S483C53v57Ev();
extern void _ZN6S483C53v58Ev();
extern void _ZN6S483C53v59Ev();
extern void _ZN6S483C53v60Ev();
extern void _ZN6S483C53v61Ev();
extern void _ZN6S483C53v62Ev();
extern void _ZN6S483C53v63Ev();
extern void _ZN6S483C53v64Ev();
extern void _ZN6S483C53v65Ev();
extern void _ZN6S483C53v66Ev();
extern void _ZN6S483C53v67Ev();
extern void _ZN6S483C53v68Ev();
extern void _ZN6S483C53v69Ev();
extern void _ZN6S483C53v70Ev();
extern void _ZN6S483C53v71Ev();
extern void _ZN6S483C53v72Ev();
extern void _ZN6S483C53v73Ev();
extern void _ZN6S483C53v74Ev();
extern void _ZN6S483C53v75Ev();
extern void _ZN6S483C43v76Ev();
extern void _ZN6S483C43v77Ev();
extern void _ZN6S483C43v78Ev();
extern void _ZN6S483C43v79Ev();
extern void _ZN6S483C33v80Ev();
extern void _ZN6S483C33v81Ev();
extern void _ZN6S483C33v82Ev();
extern void _ZN6S483C33v83Ev();
extern void _ZN6S483C33v84Ev();
extern void _ZN6S483C33v85Ev();
extern void _ZN6S483C33v86Ev();
extern void _ZN6S483C33v87Ev();
extern void _ZN6S483C33v88Ev();
extern void _ZN6S483C33v89Ev();
extern void _ZN6S483C33v90Ev();
extern void _ZN6S483C33v91Ev();
extern void _ZN6S483C33v92Ev();
extern void _ZN6S483C33v93Ev();
extern void _ZN6S483C33v94Ev();
extern void _ZN6S483C33v95Ev();
extern void _ZN6S483C23v96Ev();
extern void _ZN6S483C23v97Ev();
extern void _ZN6S483C23v98Ev();
extern void _ZN6S483C23v99Ev();
extern void _ZN6S483C24v100Ev();
static  VTBL_ENTRY vtc_S483C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S483C2[0]),
  (VTBL_ENTRY)&_ZN6S483C2D1Ev,
  (VTBL_ENTRY)&_ZN6S483C2D0Ev,
  (VTBL_ENTRY)&_ZN6S483C53v12Ev,
  (VTBL_ENTRY)&_ZN6S483C53v13Ev,
  (VTBL_ENTRY)&_ZN6S483C53v14Ev,
  (VTBL_ENTRY)&_ZN6S483C53v15Ev,
  (VTBL_ENTRY)&_ZN6S483C53v16Ev,
  (VTBL_ENTRY)&_ZN6S483C53v17Ev,
  (VTBL_ENTRY)&_ZN6S483C53v18Ev,
  (VTBL_ENTRY)&_ZN6S483C53v19Ev,
  (VTBL_ENTRY)&_ZN6S483C53v20Ev,
  (VTBL_ENTRY)&_ZN6S483C53v21Ev,
  (VTBL_ENTRY)&_ZN6S483C53v22Ev,
  (VTBL_ENTRY)&_ZN6S483C53v23Ev,
  (VTBL_ENTRY)&_ZN6S483C53v24Ev,
  (VTBL_ENTRY)&_ZN6S483C53v25Ev,
  (VTBL_ENTRY)&_ZN6S483C53v26Ev,
  (VTBL_ENTRY)&_ZN6S483C53v27Ev,
  (VTBL_ENTRY)&_ZN6S483C53v28Ev,
  (VTBL_ENTRY)&_ZN6S483C53v29Ev,
  (VTBL_ENTRY)&_ZN6S483C53v30Ev,
  (VTBL_ENTRY)&_ZN6S483C53v31Ev,
  (VTBL_ENTRY)&_ZN6S483C53v32Ev,
  (VTBL_ENTRY)&_ZN6S483C53v33Ev,
  (VTBL_ENTRY)&_ZN6S483C53v34Ev,
  (VTBL_ENTRY)&_ZN6S483C53v35Ev,
  (VTBL_ENTRY)&_ZN6S483C53v36Ev,
  (VTBL_ENTRY)&_ZN6S483C53v37Ev,
  (VTBL_ENTRY)&_ZN6S483C53v38Ev,
  (VTBL_ENTRY)&_ZN6S483C53v39Ev,
  (VTBL_ENTRY)&_ZN6S483C53v40Ev,
  (VTBL_ENTRY)&_ZN6S483C53v41Ev,
  (VTBL_ENTRY)&_ZN6S483C53v42Ev,
  (VTBL_ENTRY)&_ZN6S483C53v43Ev,
  (VTBL_ENTRY)&_ZN6S483C53v44Ev,
  (VTBL_ENTRY)&_ZN6S483C53v45Ev,
  (VTBL_ENTRY)&_ZN6S483C53v46Ev,
  (VTBL_ENTRY)&_ZN6S483C53v47Ev,
  (VTBL_ENTRY)&_ZN6S483C53v48Ev,
  (VTBL_ENTRY)&_ZN6S483C53v49Ev,
  (VTBL_ENTRY)&_ZN6S483C53v50Ev,
  (VTBL_ENTRY)&_ZN6S483C53v51Ev,
  (VTBL_ENTRY)&_ZN6S483C53v52Ev,
  (VTBL_ENTRY)&_ZN6S483C53v53Ev,
  (VTBL_ENTRY)&_ZN6S483C53v54Ev,
  (VTBL_ENTRY)&_ZN6S483C53v55Ev,
  (VTBL_ENTRY)&_ZN6S483C53v56Ev,
  (VTBL_ENTRY)&_ZN6S483C53v57Ev,
  (VTBL_ENTRY)&_ZN6S483C53v58Ev,
  (VTBL_ENTRY)&_ZN6S483C53v59Ev,
  (VTBL_ENTRY)&_ZN6S483C53v60Ev,
  (VTBL_ENTRY)&_ZN6S483C53v61Ev,
  (VTBL_ENTRY)&_ZN6S483C53v62Ev,
  (VTBL_ENTRY)&_ZN6S483C53v63Ev,
  (VTBL_ENTRY)&_ZN6S483C53v64Ev,
  (VTBL_ENTRY)&_ZN6S483C53v65Ev,
  (VTBL_ENTRY)&_ZN6S483C53v66Ev,
  (VTBL_ENTRY)&_ZN6S483C53v67Ev,
  (VTBL_ENTRY)&_ZN6S483C53v68Ev,
  (VTBL_ENTRY)&_ZN6S483C53v69Ev,
  (VTBL_ENTRY)&_ZN6S483C53v70Ev,
  (VTBL_ENTRY)&_ZN6S483C53v71Ev,
  (VTBL_ENTRY)&_ZN6S483C53v72Ev,
  (VTBL_ENTRY)&_ZN6S483C53v73Ev,
  (VTBL_ENTRY)&_ZN6S483C53v74Ev,
  (VTBL_ENTRY)&_ZN6S483C53v75Ev,
  (VTBL_ENTRY)&_ZN6S483C43v76Ev,
  (VTBL_ENTRY)&_ZN6S483C43v77Ev,
  (VTBL_ENTRY)&_ZN6S483C43v78Ev,
  (VTBL_ENTRY)&_ZN6S483C43v79Ev,
  (VTBL_ENTRY)&_ZN6S483C33v80Ev,
  (VTBL_ENTRY)&_ZN6S483C33v81Ev,
  (VTBL_ENTRY)&_ZN6S483C33v82Ev,
  (VTBL_ENTRY)&_ZN6S483C33v83Ev,
  (VTBL_ENTRY)&_ZN6S483C33v84Ev,
  (VTBL_ENTRY)&_ZN6S483C33v85Ev,
  (VTBL_ENTRY)&_ZN6S483C33v86Ev,
  (VTBL_ENTRY)&_ZN6S483C33v87Ev,
  (VTBL_ENTRY)&_ZN6S483C33v88Ev,
  (VTBL_ENTRY)&_ZN6S483C33v89Ev,
  (VTBL_ENTRY)&_ZN6S483C33v90Ev,
  (VTBL_ENTRY)&_ZN6S483C33v91Ev,
  (VTBL_ENTRY)&_ZN6S483C33v92Ev,
  (VTBL_ENTRY)&_ZN6S483C33v93Ev,
  (VTBL_ENTRY)&_ZN6S483C33v94Ev,
  (VTBL_ENTRY)&_ZN6S483C33v95Ev,
  (VTBL_ENTRY)&_ZN6S483C23v96Ev,
  (VTBL_ENTRY)&_ZN6S483C23v97Ev,
  (VTBL_ENTRY)&_ZN6S483C23v98Ev,
  (VTBL_ENTRY)&_ZN6S483C23v99Ev,
  (VTBL_ENTRY)&_ZN6S483C24v100Ev,
};
extern VTBL_ENTRY _ZTI6S483C2[];
extern  VTBL_ENTRY _ZTV6S483C2[];
Class_Descriptor cd_S483C2 = {  "S483C2", // class name
  bases_S483C2, 3,
  &(vtc_S483C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,188), // object size
  NSPAIRA(_ZTI6S483C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S483C2),93, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S483C1  : S483C2 {
  int s483c1f0[2];
  char s483c1f1[3];
  ::S685C32_nt s483c1f2;
  virtual  ~S483C1(); // _ZN6S483C1D1Ev
  virtual void  v1(); // _ZN6S483C12v1Ev
  virtual void  v2(); // _ZN6S483C12v2Ev
  virtual void  v3(); // _ZN6S483C12v3Ev
  virtual void  v4(); // _ZN6S483C12v4Ev
  virtual void  v5(); // _ZN6S483C12v5Ev
  virtual void  v6(); // _ZN6S483C12v6Ev
  virtual void  v7(); // _ZN6S483C12v7Ev
  virtual void  v8(); // _ZN6S483C12v8Ev
  virtual void  v9(); // _ZN6S483C12v9Ev
  virtual void  v10(); // _ZN6S483C13v10Ev
  virtual void  v11(); // _ZN6S483C13v11Ev
  S483C1(); // tgen
};
//SIG(1 S483C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79} vd v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC7{ BC8{ vd v103 v104 v105 v106 v107 Fi[8] Fp Fi Fp} v101 v102} Fi:1 Fc[3] Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 Fp} vd v96 v97 v98 v99 v100 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fi[2] Fc[3] FC13{ m Fi[4]}}


 S483C1 ::~S483C1(){ note_dtor("S483C1", this);}
void  S483C1 ::v1(){vfunc_called(this, "_ZN6S483C12v1Ev");}
void  S483C1 ::v2(){vfunc_called(this, "_ZN6S483C12v2Ev");}
void  S483C1 ::v3(){vfunc_called(this, "_ZN6S483C12v3Ev");}
void  S483C1 ::v4(){vfunc_called(this, "_ZN6S483C12v4Ev");}
void  S483C1 ::v5(){vfunc_called(this, "_ZN6S483C12v5Ev");}
void  S483C1 ::v6(){vfunc_called(this, "_ZN6S483C12v6Ev");}
void  S483C1 ::v7(){vfunc_called(this, "_ZN6S483C12v7Ev");}
void  S483C1 ::v8(){vfunc_called(this, "_ZN6S483C12v8Ev");}
void  S483C1 ::v9(){vfunc_called(this, "_ZN6S483C12v9Ev");}
void  S483C1 ::v10(){vfunc_called(this, "_ZN6S483C13v10Ev");}
void  S483C1 ::v11(){vfunc_called(this, "_ZN6S483C13v11Ev");}
S483C1 ::S483C1(){ note_ctor("S483C1", this);} // tgen

static void Test_S483C1()
{
  extern Class_Descriptor cd_S483C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,55)];
    init_test(&cd_S483C1, buf);
    S483C1 *dp, &lv = *(dp=new (buf) S483C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,216), "sizeof(S483C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S483C1)");
    check_base_class_offset(lv, (S483C5*)(S483C4*)(S483C3*)(S483C2*), 0, "S483C1");
    check_base_class_offset(lv, (S483C4*)(S483C3*)(S483C2*), 0, "S483C1");
    check_base_class_offset(lv, (S483C3*)(S483C2*), 0, "S483C1");
    check_base_class_offset(lv, (S483C2*), 0, "S483C1");
    check_field_offset(lv, s483c1f0, ABISELECT(260,188), "S483C1.s483c1f0");
    check_field_offset(lv, s483c1f1, ABISELECT(268,196), "S483C1.s483c1f1");
    check_field_offset(lv, s483c1f2, ABISELECT(272,200), "S483C1.s483c1f2");
    test_class_info(&lv, &cd_S483C1);
    dp->~S483C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS483C1(Test_S483C1, "S483C1", ABISELECT(288,216));

#else // __cplusplus

extern void _ZN6S483C1C1Ev();
extern void _ZN6S483C1D1Ev();
Name_Map name_map_S483C1[] = {
  NSPAIR(_ZN6S483C1C1Ev),
  NSPAIR(_ZN6S483C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S483C5;
extern VTBL_ENTRY _ZTI6S483C5[];
extern  VTBL_ENTRY _ZTV6S483C5[];
extern Class_Descriptor cd_S483C4;
extern VTBL_ENTRY _ZTI6S483C4[];
extern  VTBL_ENTRY _ZTV6S483C4[];
extern Class_Descriptor cd_S483C3;
extern VTBL_ENTRY _ZTI6S483C3[];
extern  VTBL_ENTRY _ZTV6S483C3[];
extern Class_Descriptor cd_S483C2;
extern VTBL_ENTRY _ZTI6S483C2[];
extern  VTBL_ENTRY _ZTV6S483C2[];
static Base_Class bases_S483C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S483C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S483C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S483C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S483C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S483C1[];
extern void _ZN6S483C1D1Ev();
extern void _ZN6S483C1D0Ev();
extern void _ZN6S483C53v12Ev();
extern void _ZN6S483C53v13Ev();
extern void _ZN6S483C53v14Ev();
extern void _ZN6S483C53v15Ev();
extern void _ZN6S483C53v16Ev();
extern void _ZN6S483C53v17Ev();
extern void _ZN6S483C53v18Ev();
extern void _ZN6S483C53v19Ev();
extern void _ZN6S483C53v20Ev();
extern void _ZN6S483C53v21Ev();
extern void _ZN6S483C53v22Ev();
extern void _ZN6S483C53v23Ev();
extern void _ZN6S483C53v24Ev();
extern void _ZN6S483C53v25Ev();
extern void _ZN6S483C53v26Ev();
extern void _ZN6S483C53v27Ev();
extern void _ZN6S483C53v28Ev();
extern void _ZN6S483C53v29Ev();
extern void _ZN6S483C53v30Ev();
extern void _ZN6S483C53v31Ev();
extern void _ZN6S483C53v32Ev();
extern void _ZN6S483C53v33Ev();
extern void _ZN6S483C53v34Ev();
extern void _ZN6S483C53v35Ev();
extern void _ZN6S483C53v36Ev();
extern void _ZN6S483C53v37Ev();
extern void _ZN6S483C53v38Ev();
extern void _ZN6S483C53v39Ev();
extern void _ZN6S483C53v40Ev();
extern void _ZN6S483C53v41Ev();
extern void _ZN6S483C53v42Ev();
extern void _ZN6S483C53v43Ev();
extern void _ZN6S483C53v44Ev();
extern void _ZN6S483C53v45Ev();
extern void _ZN6S483C53v46Ev();
extern void _ZN6S483C53v47Ev();
extern void _ZN6S483C53v48Ev();
extern void _ZN6S483C53v49Ev();
extern void _ZN6S483C53v50Ev();
extern void _ZN6S483C53v51Ev();
extern void _ZN6S483C53v52Ev();
extern void _ZN6S483C53v53Ev();
extern void _ZN6S483C53v54Ev();
extern void _ZN6S483C53v55Ev();
extern void _ZN6S483C53v56Ev();
extern void _ZN6S483C53v57Ev();
extern void _ZN6S483C53v58Ev();
extern void _ZN6S483C53v59Ev();
extern void _ZN6S483C53v60Ev();
extern void _ZN6S483C53v61Ev();
extern void _ZN6S483C53v62Ev();
extern void _ZN6S483C53v63Ev();
extern void _ZN6S483C53v64Ev();
extern void _ZN6S483C53v65Ev();
extern void _ZN6S483C53v66Ev();
extern void _ZN6S483C53v67Ev();
extern void _ZN6S483C53v68Ev();
extern void _ZN6S483C53v69Ev();
extern void _ZN6S483C53v70Ev();
extern void _ZN6S483C53v71Ev();
extern void _ZN6S483C53v72Ev();
extern void _ZN6S483C53v73Ev();
extern void _ZN6S483C53v74Ev();
extern void _ZN6S483C53v75Ev();
extern void _ZN6S483C43v76Ev();
extern void _ZN6S483C43v77Ev();
extern void _ZN6S483C43v78Ev();
extern void _ZN6S483C43v79Ev();
extern void _ZN6S483C33v80Ev();
extern void _ZN6S483C33v81Ev();
extern void _ZN6S483C33v82Ev();
extern void _ZN6S483C33v83Ev();
extern void _ZN6S483C33v84Ev();
extern void _ZN6S483C33v85Ev();
extern void _ZN6S483C33v86Ev();
extern void _ZN6S483C33v87Ev();
extern void _ZN6S483C33v88Ev();
extern void _ZN6S483C33v89Ev();
extern void _ZN6S483C33v90Ev();
extern void _ZN6S483C33v91Ev();
extern void _ZN6S483C33v92Ev();
extern void _ZN6S483C33v93Ev();
extern void _ZN6S483C33v94Ev();
extern void _ZN6S483C33v95Ev();
extern void _ZN6S483C23v96Ev();
extern void _ZN6S483C23v97Ev();
extern void _ZN6S483C23v98Ev();
extern void _ZN6S483C23v99Ev();
extern void _ZN6S483C24v100Ev();
extern void _ZN6S483C12v1Ev();
extern void _ZN6S483C12v2Ev();
extern void _ZN6S483C12v3Ev();
extern void _ZN6S483C12v4Ev();
extern void _ZN6S483C12v5Ev();
extern void _ZN6S483C12v6Ev();
extern void _ZN6S483C12v7Ev();
extern void _ZN6S483C12v8Ev();
extern void _ZN6S483C12v9Ev();
extern void _ZN6S483C13v10Ev();
extern void _ZN6S483C13v11Ev();
static  VTBL_ENTRY vtc_S483C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S483C1[0]),
  (VTBL_ENTRY)&_ZN6S483C1D1Ev,
  (VTBL_ENTRY)&_ZN6S483C1D0Ev,
  (VTBL_ENTRY)&_ZN6S483C53v12Ev,
  (VTBL_ENTRY)&_ZN6S483C53v13Ev,
  (VTBL_ENTRY)&_ZN6S483C53v14Ev,
  (VTBL_ENTRY)&_ZN6S483C53v15Ev,
  (VTBL_ENTRY)&_ZN6S483C53v16Ev,
  (VTBL_ENTRY)&_ZN6S483C53v17Ev,
  (VTBL_ENTRY)&_ZN6S483C53v18Ev,
  (VTBL_ENTRY)&_ZN6S483C53v19Ev,
  (VTBL_ENTRY)&_ZN6S483C53v20Ev,
  (VTBL_ENTRY)&_ZN6S483C53v21Ev,
  (VTBL_ENTRY)&_ZN6S483C53v22Ev,
  (VTBL_ENTRY)&_ZN6S483C53v23Ev,
  (VTBL_ENTRY)&_ZN6S483C53v24Ev,
  (VTBL_ENTRY)&_ZN6S483C53v25Ev,
  (VTBL_ENTRY)&_ZN6S483C53v26Ev,
  (VTBL_ENTRY)&_ZN6S483C53v27Ev,
  (VTBL_ENTRY)&_ZN6S483C53v28Ev,
  (VTBL_ENTRY)&_ZN6S483C53v29Ev,
  (VTBL_ENTRY)&_ZN6S483C53v30Ev,
  (VTBL_ENTRY)&_ZN6S483C53v31Ev,
  (VTBL_ENTRY)&_ZN6S483C53v32Ev,
  (VTBL_ENTRY)&_ZN6S483C53v33Ev,
  (VTBL_ENTRY)&_ZN6S483C53v34Ev,
  (VTBL_ENTRY)&_ZN6S483C53v35Ev,
  (VTBL_ENTRY)&_ZN6S483C53v36Ev,
  (VTBL_ENTRY)&_ZN6S483C53v37Ev,
  (VTBL_ENTRY)&_ZN6S483C53v38Ev,
  (VTBL_ENTRY)&_ZN6S483C53v39Ev,
  (VTBL_ENTRY)&_ZN6S483C53v40Ev,
  (VTBL_ENTRY)&_ZN6S483C53v41Ev,
  (VTBL_ENTRY)&_ZN6S483C53v42Ev,
  (VTBL_ENTRY)&_ZN6S483C53v43Ev,
  (VTBL_ENTRY)&_ZN6S483C53v44Ev,
  (VTBL_ENTRY)&_ZN6S483C53v45Ev,
  (VTBL_ENTRY)&_ZN6S483C53v46Ev,
  (VTBL_ENTRY)&_ZN6S483C53v47Ev,
  (VTBL_ENTRY)&_ZN6S483C53v48Ev,
  (VTBL_ENTRY)&_ZN6S483C53v49Ev,
  (VTBL_ENTRY)&_ZN6S483C53v50Ev,
  (VTBL_ENTRY)&_ZN6S483C53v51Ev,
  (VTBL_ENTRY)&_ZN6S483C53v52Ev,
  (VTBL_ENTRY)&_ZN6S483C53v53Ev,
  (VTBL_ENTRY)&_ZN6S483C53v54Ev,
  (VTBL_ENTRY)&_ZN6S483C53v55Ev,
  (VTBL_ENTRY)&_ZN6S483C53v56Ev,
  (VTBL_ENTRY)&_ZN6S483C53v57Ev,
  (VTBL_ENTRY)&_ZN6S483C53v58Ev,
  (VTBL_ENTRY)&_ZN6S483C53v59Ev,
  (VTBL_ENTRY)&_ZN6S483C53v60Ev,
  (VTBL_ENTRY)&_ZN6S483C53v61Ev,
  (VTBL_ENTRY)&_ZN6S483C53v62Ev,
  (VTBL_ENTRY)&_ZN6S483C53v63Ev,
  (VTBL_ENTRY)&_ZN6S483C53v64Ev,
  (VTBL_ENTRY)&_ZN6S483C53v65Ev,
  (VTBL_ENTRY)&_ZN6S483C53v66Ev,
  (VTBL_ENTRY)&_ZN6S483C53v67Ev,
  (VTBL_ENTRY)&_ZN6S483C53v68Ev,
  (VTBL_ENTRY)&_ZN6S483C53v69Ev,
  (VTBL_ENTRY)&_ZN6S483C53v70Ev,
  (VTBL_ENTRY)&_ZN6S483C53v71Ev,
  (VTBL_ENTRY)&_ZN6S483C53v72Ev,
  (VTBL_ENTRY)&_ZN6S483C53v73Ev,
  (VTBL_ENTRY)&_ZN6S483C53v74Ev,
  (VTBL_ENTRY)&_ZN6S483C53v75Ev,
  (VTBL_ENTRY)&_ZN6S483C43v76Ev,
  (VTBL_ENTRY)&_ZN6S483C43v77Ev,
  (VTBL_ENTRY)&_ZN6S483C43v78Ev,
  (VTBL_ENTRY)&_ZN6S483C43v79Ev,
  (VTBL_ENTRY)&_ZN6S483C33v80Ev,
  (VTBL_ENTRY)&_ZN6S483C33v81Ev,
  (VTBL_ENTRY)&_ZN6S483C33v82Ev,
  (VTBL_ENTRY)&_ZN6S483C33v83Ev,
  (VTBL_ENTRY)&_ZN6S483C33v84Ev,
  (VTBL_ENTRY)&_ZN6S483C33v85Ev,
  (VTBL_ENTRY)&_ZN6S483C33v86Ev,
  (VTBL_ENTRY)&_ZN6S483C33v87Ev,
  (VTBL_ENTRY)&_ZN6S483C33v88Ev,
  (VTBL_ENTRY)&_ZN6S483C33v89Ev,
  (VTBL_ENTRY)&_ZN6S483C33v90Ev,
  (VTBL_ENTRY)&_ZN6S483C33v91Ev,
  (VTBL_ENTRY)&_ZN6S483C33v92Ev,
  (VTBL_ENTRY)&_ZN6S483C33v93Ev,
  (VTBL_ENTRY)&_ZN6S483C33v94Ev,
  (VTBL_ENTRY)&_ZN6S483C33v95Ev,
  (VTBL_ENTRY)&_ZN6S483C23v96Ev,
  (VTBL_ENTRY)&_ZN6S483C23v97Ev,
  (VTBL_ENTRY)&_ZN6S483C23v98Ev,
  (VTBL_ENTRY)&_ZN6S483C23v99Ev,
  (VTBL_ENTRY)&_ZN6S483C24v100Ev,
  (VTBL_ENTRY)&_ZN6S483C12v1Ev,
  (VTBL_ENTRY)&_ZN6S483C12v2Ev,
  (VTBL_ENTRY)&_ZN6S483C12v3Ev,
  (VTBL_ENTRY)&_ZN6S483C12v4Ev,
  (VTBL_ENTRY)&_ZN6S483C12v5Ev,
  (VTBL_ENTRY)&_ZN6S483C12v6Ev,
  (VTBL_ENTRY)&_ZN6S483C12v7Ev,
  (VTBL_ENTRY)&_ZN6S483C12v8Ev,
  (VTBL_ENTRY)&_ZN6S483C12v9Ev,
  (VTBL_ENTRY)&_ZN6S483C13v10Ev,
  (VTBL_ENTRY)&_ZN6S483C13v11Ev,
};
extern VTBL_ENTRY _ZTI6S483C1[];
extern  VTBL_ENTRY _ZTV6S483C1[];
Class_Descriptor cd_S483C1 = {  "S483C1", // class name
  bases_S483C1, 4,
  &(vtc_S483C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(288,216), // object size
  NSPAIRA(_ZTI6S483C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S483C1),104, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S482C5  {
  int s482c5f0;
  __tsi64 s482c5f1;
  void *s482c5f2[4];
  int s482c5f3[2];
  void *s482c5f4;
  ::S695C22_nt s482c5f5;
  void *s482c5f6[2];
  virtual  ~S482C5(); // _ZN6S482C5D1Ev
  virtual void  v12(); // _ZN6S482C53v12Ev
  virtual void  v13(); // _ZN6S482C53v13Ev
  virtual void  v14(); // _ZN6S482C53v14Ev
  virtual void  v15(); // _ZN6S482C53v15Ev
  virtual void  v16(); // _ZN6S482C53v16Ev
  virtual void  v17(); // _ZN6S482C53v17Ev
  virtual void  v18(); // _ZN6S482C53v18Ev
  virtual void  v19(); // _ZN6S482C53v19Ev
  virtual void  v20(); // _ZN6S482C53v20Ev
  virtual void  v21(); // _ZN6S482C53v21Ev
  virtual void  v22(); // _ZN6S482C53v22Ev
  virtual void  v23(); // _ZN6S482C53v23Ev
  virtual void  v24(); // _ZN6S482C53v24Ev
  virtual void  v25(); // _ZN6S482C53v25Ev
  virtual void  v26(); // _ZN6S482C53v26Ev
  virtual void  v27(); // _ZN6S482C53v27Ev
  virtual void  v28(); // _ZN6S482C53v28Ev
  virtual void  v29(); // _ZN6S482C53v29Ev
  virtual void  v30(); // _ZN6S482C53v30Ev
  virtual void  v31(); // _ZN6S482C53v31Ev
  virtual void  v32(); // _ZN6S482C53v32Ev
  virtual void  v33(); // _ZN6S482C53v33Ev
  virtual void  v34(); // _ZN6S482C53v34Ev
  virtual void  v35(); // _ZN6S482C53v35Ev
  virtual void  v36(); // _ZN6S482C53v36Ev
  virtual void  v37(); // _ZN6S482C53v37Ev
  virtual void  v38(); // _ZN6S482C53v38Ev
  virtual void  v39(); // _ZN6S482C53v39Ev
  virtual void  v40(); // _ZN6S482C53v40Ev
  virtual void  v41(); // _ZN6S482C53v41Ev
  virtual void  v42(); // _ZN6S482C53v42Ev
  virtual void  v43(); // _ZN6S482C53v43Ev
  virtual void  v44(); // _ZN6S482C53v44Ev
  virtual void  v45(); // _ZN6S482C53v45Ev
  virtual void  v46(); // _ZN6S482C53v46Ev
  virtual void  v47(); // _ZN6S482C53v47Ev
  virtual void  v48(); // _ZN6S482C53v48Ev
  virtual void  v49(); // _ZN6S482C53v49Ev
  virtual void  v50(); // _ZN6S482C53v50Ev
  virtual void  v51(); // _ZN6S482C53v51Ev
  virtual void  v52(); // _ZN6S482C53v52Ev
  virtual void  v53(); // _ZN6S482C53v53Ev
  virtual void  v54(); // _ZN6S482C53v54Ev
  virtual void  v55(); // _ZN6S482C53v55Ev
  virtual void  v56(); // _ZN6S482C53v56Ev
  virtual void  v57(); // _ZN6S482C53v57Ev
  virtual void  v58(); // _ZN6S482C53v58Ev
  virtual void  v59(); // _ZN6S482C53v59Ev
  virtual void  v60(); // _ZN6S482C53v60Ev
  virtual void  v61(); // _ZN6S482C53v61Ev
  virtual void  v62(); // _ZN6S482C53v62Ev
  virtual void  v63(); // _ZN6S482C53v63Ev
  virtual void  v64(); // _ZN6S482C53v64Ev
  virtual void  v65(); // _ZN6S482C53v65Ev
  virtual void  v66(); // _ZN6S482C53v66Ev
  virtual void  v67(); // _ZN6S482C53v67Ev
  virtual void  v68(); // _ZN6S482C53v68Ev
  virtual void  v69(); // _ZN6S482C53v69Ev
  virtual void  v70(); // _ZN6S482C53v70Ev
  virtual void  v71(); // _ZN6S482C53v71Ev
  virtual void  v72(); // _ZN6S482C53v72Ev
  virtual void  v73(); // _ZN6S482C53v73Ev
  virtual void  v74(); // _ZN6S482C53v74Ev
  virtual void  v75(); // _ZN6S482C53v75Ev
  S482C5(); // tgen
};
//SIG(-1 S482C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S482C5 ::~S482C5(){ note_dtor("S482C5", this);}
void  S482C5 ::v12(){vfunc_called(this, "_ZN6S482C53v12Ev");}
void  S482C5 ::v13(){vfunc_called(this, "_ZN6S482C53v13Ev");}
void  S482C5 ::v14(){vfunc_called(this, "_ZN6S482C53v14Ev");}
void  S482C5 ::v15(){vfunc_called(this, "_ZN6S482C53v15Ev");}
void  S482C5 ::v16(){vfunc_called(this, "_ZN6S482C53v16Ev");}
void  S482C5 ::v17(){vfunc_called(this, "_ZN6S482C53v17Ev");}
void  S482C5 ::v18(){vfunc_called(this, "_ZN6S482C53v18Ev");}
void  S482C5 ::v19(){vfunc_called(this, "_ZN6S482C53v19Ev");}
void  S482C5 ::v20(){vfunc_called(this, "_ZN6S482C53v20Ev");}
void  S482C5 ::v21(){vfunc_called(this, "_ZN6S482C53v21Ev");}
void  S482C5 ::v22(){vfunc_called(this, "_ZN6S482C53v22Ev");}
void  S482C5 ::v23(){vfunc_called(this, "_ZN6S482C53v23Ev");}
void  S482C5 ::v24(){vfunc_called(this, "_ZN6S482C53v24Ev");}
void  S482C5 ::v25(){vfunc_called(this, "_ZN6S482C53v25Ev");}
void  S482C5 ::v26(){vfunc_called(this, "_ZN6S482C53v26Ev");}
void  S482C5 ::v27(){vfunc_called(this, "_ZN6S482C53v27Ev");}
void  S482C5 ::v28(){vfunc_called(this, "_ZN6S482C53v28Ev");}
void  S482C5 ::v29(){vfunc_called(this, "_ZN6S482C53v29Ev");}
void  S482C5 ::v30(){vfunc_called(this, "_ZN6S482C53v30Ev");}
void  S482C5 ::v31(){vfunc_called(this, "_ZN6S482C53v31Ev");}
void  S482C5 ::v32(){vfunc_called(this, "_ZN6S482C53v32Ev");}
void  S482C5 ::v33(){vfunc_called(this, "_ZN6S482C53v33Ev");}
void  S482C5 ::v34(){vfunc_called(this, "_ZN6S482C53v34Ev");}
void  S482C5 ::v35(){vfunc_called(this, "_ZN6S482C53v35Ev");}
void  S482C5 ::v36(){vfunc_called(this, "_ZN6S482C53v36Ev");}
void  S482C5 ::v37(){vfunc_called(this, "_ZN6S482C53v37Ev");}
void  S482C5 ::v38(){vfunc_called(this, "_ZN6S482C53v38Ev");}
void  S482C5 ::v39(){vfunc_called(this, "_ZN6S482C53v39Ev");}
void  S482C5 ::v40(){vfunc_called(this, "_ZN6S482C53v40Ev");}
void  S482C5 ::v41(){vfunc_called(this, "_ZN6S482C53v41Ev");}
void  S482C5 ::v42(){vfunc_called(this, "_ZN6S482C53v42Ev");}
void  S482C5 ::v43(){vfunc_called(this, "_ZN6S482C53v43Ev");}
void  S482C5 ::v44(){vfunc_called(this, "_ZN6S482C53v44Ev");}
void  S482C5 ::v45(){vfunc_called(this, "_ZN6S482C53v45Ev");}
void  S482C5 ::v46(){vfunc_called(this, "_ZN6S482C53v46Ev");}
void  S482C5 ::v47(){vfunc_called(this, "_ZN6S482C53v47Ev");}
void  S482C5 ::v48(){vfunc_called(this, "_ZN6S482C53v48Ev");}
void  S482C5 ::v49(){vfunc_called(this, "_ZN6S482C53v49Ev");}
void  S482C5 ::v50(){vfunc_called(this, "_ZN6S482C53v50Ev");}
void  S482C5 ::v51(){vfunc_called(this, "_ZN6S482C53v51Ev");}
void  S482C5 ::v52(){vfunc_called(this, "_ZN6S482C53v52Ev");}
void  S482C5 ::v53(){vfunc_called(this, "_ZN6S482C53v53Ev");}
void  S482C5 ::v54(){vfunc_called(this, "_ZN6S482C53v54Ev");}
void  S482C5 ::v55(){vfunc_called(this, "_ZN6S482C53v55Ev");}
void  S482C5 ::v56(){vfunc_called(this, "_ZN6S482C53v56Ev");}
void  S482C5 ::v57(){vfunc_called(this, "_ZN6S482C53v57Ev");}
void  S482C5 ::v58(){vfunc_called(this, "_ZN6S482C53v58Ev");}
void  S482C5 ::v59(){vfunc_called(this, "_ZN6S482C53v59Ev");}
void  S482C5 ::v60(){vfunc_called(this, "_ZN6S482C53v60Ev");}
void  S482C5 ::v61(){vfunc_called(this, "_ZN6S482C53v61Ev");}
void  S482C5 ::v62(){vfunc_called(this, "_ZN6S482C53v62Ev");}
void  S482C5 ::v63(){vfunc_called(this, "_ZN6S482C53v63Ev");}
void  S482C5 ::v64(){vfunc_called(this, "_ZN6S482C53v64Ev");}
void  S482C5 ::v65(){vfunc_called(this, "_ZN6S482C53v65Ev");}
void  S482C5 ::v66(){vfunc_called(this, "_ZN6S482C53v66Ev");}
void  S482C5 ::v67(){vfunc_called(this, "_ZN6S482C53v67Ev");}
void  S482C5 ::v68(){vfunc_called(this, "_ZN6S482C53v68Ev");}
void  S482C5 ::v69(){vfunc_called(this, "_ZN6S482C53v69Ev");}
void  S482C5 ::v70(){vfunc_called(this, "_ZN6S482C53v70Ev");}
void  S482C5 ::v71(){vfunc_called(this, "_ZN6S482C53v71Ev");}
void  S482C5 ::v72(){vfunc_called(this, "_ZN6S482C53v72Ev");}
void  S482C5 ::v73(){vfunc_called(this, "_ZN6S482C53v73Ev");}
void  S482C5 ::v74(){vfunc_called(this, "_ZN6S482C53v74Ev");}
void  S482C5 ::v75(){vfunc_called(this, "_ZN6S482C53v75Ev");}
S482C5 ::S482C5(){ note_ctor("S482C5", this);} // tgen

static void Test_S482C5()
{
  extern Class_Descriptor cd_S482C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S482C5, buf);
    S482C5 *dp, &lv = *(dp=new (buf) S482C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S482C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S482C5)");
    check_field_offset(lv, s482c5f0, ABISELECT(8,4), "S482C5.s482c5f0");
    check_field_offset(lv, s482c5f1, ABISELECT(16,8), "S482C5.s482c5f1");
    check_field_offset(lv, s482c5f2, ABISELECT(24,16), "S482C5.s482c5f2");
    check_field_offset(lv, s482c5f3, ABISELECT(56,32), "S482C5.s482c5f3");
    check_field_offset(lv, s482c5f4, ABISELECT(64,40), "S482C5.s482c5f4");
    check_field_offset(lv, s482c5f5, ABISELECT(72,44), "S482C5.s482c5f5");
    check_field_offset(lv, s482c5f6, ABISELECT(80,52), "S482C5.s482c5f6");
    test_class_info(&lv, &cd_S482C5);
    dp->~S482C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS482C5(Test_S482C5, "S482C5", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S482C5C1Ev();
extern void _ZN6S482C5D1Ev();
Name_Map name_map_S482C5[] = {
  NSPAIR(_ZN6S482C5C1Ev),
  NSPAIR(_ZN6S482C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S482C5[];
extern void _ZN6S482C5D1Ev();
extern void _ZN6S482C5D0Ev();
extern void _ZN6S482C53v12Ev();
extern void _ZN6S482C53v13Ev();
extern void _ZN6S482C53v14Ev();
extern void _ZN6S482C53v15Ev();
extern void _ZN6S482C53v16Ev();
extern void _ZN6S482C53v17Ev();
extern void _ZN6S482C53v18Ev();
extern void _ZN6S482C53v19Ev();
extern void _ZN6S482C53v20Ev();
extern void _ZN6S482C53v21Ev();
extern void _ZN6S482C53v22Ev();
extern void _ZN6S482C53v23Ev();
extern void _ZN6S482C53v24Ev();
extern void _ZN6S482C53v25Ev();
extern void _ZN6S482C53v26Ev();
extern void _ZN6S482C53v27Ev();
extern void _ZN6S482C53v28Ev();
extern void _ZN6S482C53v29Ev();
extern void _ZN6S482C53v30Ev();
extern void _ZN6S482C53v31Ev();
extern void _ZN6S482C53v32Ev();
extern void _ZN6S482C53v33Ev();
extern void _ZN6S482C53v34Ev();
extern void _ZN6S482C53v35Ev();
extern void _ZN6S482C53v36Ev();
extern void _ZN6S482C53v37Ev();
extern void _ZN6S482C53v38Ev();
extern void _ZN6S482C53v39Ev();
extern void _ZN6S482C53v40Ev();
extern void _ZN6S482C53v41Ev();
extern void _ZN6S482C53v42Ev();
extern void _ZN6S482C53v43Ev();
extern void _ZN6S482C53v44Ev();
extern void _ZN6S482C53v45Ev();
extern void _ZN6S482C53v46Ev();
extern void _ZN6S482C53v47Ev();
extern void _ZN6S482C53v48Ev();
extern void _ZN6S482C53v49Ev();
extern void _ZN6S482C53v50Ev();
extern void _ZN6S482C53v51Ev();
extern void _ZN6S482C53v52Ev();
extern void _ZN6S482C53v53Ev();
extern void _ZN6S482C53v54Ev();
extern void _ZN6S482C53v55Ev();
extern void _ZN6S482C53v56Ev();
extern void _ZN6S482C53v57Ev();
extern void _ZN6S482C53v58Ev();
extern void _ZN6S482C53v59Ev();
extern void _ZN6S482C53v60Ev();
extern void _ZN6S482C53v61Ev();
extern void _ZN6S482C53v62Ev();
extern void _ZN6S482C53v63Ev();
extern void _ZN6S482C53v64Ev();
extern void _ZN6S482C53v65Ev();
extern void _ZN6S482C53v66Ev();
extern void _ZN6S482C53v67Ev();
extern void _ZN6S482C53v68Ev();
extern void _ZN6S482C53v69Ev();
extern void _ZN6S482C53v70Ev();
extern void _ZN6S482C53v71Ev();
extern void _ZN6S482C53v72Ev();
extern void _ZN6S482C53v73Ev();
extern void _ZN6S482C53v74Ev();
extern void _ZN6S482C53v75Ev();
static  VTBL_ENTRY vtc_S482C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S482C5[0]),
  (VTBL_ENTRY)&_ZN6S482C5D1Ev,
  (VTBL_ENTRY)&_ZN6S482C5D0Ev,
  (VTBL_ENTRY)&_ZN6S482C53v12Ev,
  (VTBL_ENTRY)&_ZN6S482C53v13Ev,
  (VTBL_ENTRY)&_ZN6S482C53v14Ev,
  (VTBL_ENTRY)&_ZN6S482C53v15Ev,
  (VTBL_ENTRY)&_ZN6S482C53v16Ev,
  (VTBL_ENTRY)&_ZN6S482C53v17Ev,
  (VTBL_ENTRY)&_ZN6S482C53v18Ev,
  (VTBL_ENTRY)&_ZN6S482C53v19Ev,
  (VTBL_ENTRY)&_ZN6S482C53v20Ev,
  (VTBL_ENTRY)&_ZN6S482C53v21Ev,
  (VTBL_ENTRY)&_ZN6S482C53v22Ev,
  (VTBL_ENTRY)&_ZN6S482C53v23Ev,
  (VTBL_ENTRY)&_ZN6S482C53v24Ev,
  (VTBL_ENTRY)&_ZN6S482C53v25Ev,
  (VTBL_ENTRY)&_ZN6S482C53v26Ev,
  (VTBL_ENTRY)&_ZN6S482C53v27Ev,
  (VTBL_ENTRY)&_ZN6S482C53v28Ev,
  (VTBL_ENTRY)&_ZN6S482C53v29Ev,
  (VTBL_ENTRY)&_ZN6S482C53v30Ev,
  (VTBL_ENTRY)&_ZN6S482C53v31Ev,
  (VTBL_ENTRY)&_ZN6S482C53v32Ev,
  (VTBL_ENTRY)&_ZN6S482C53v33Ev,
  (VTBL_ENTRY)&_ZN6S482C53v34Ev,
  (VTBL_ENTRY)&_ZN6S482C53v35Ev,
  (VTBL_ENTRY)&_ZN6S482C53v36Ev,
  (VTBL_ENTRY)&_ZN6S482C53v37Ev,
  (VTBL_ENTRY)&_ZN6S482C53v38Ev,
  (VTBL_ENTRY)&_ZN6S482C53v39Ev,
  (VTBL_ENTRY)&_ZN6S482C53v40Ev,
  (VTBL_ENTRY)&_ZN6S482C53v41Ev,
  (VTBL_ENTRY)&_ZN6S482C53v42Ev,
  (VTBL_ENTRY)&_ZN6S482C53v43Ev,
  (VTBL_ENTRY)&_ZN6S482C53v44Ev,
  (VTBL_ENTRY)&_ZN6S482C53v45Ev,
  (VTBL_ENTRY)&_ZN6S482C53v46Ev,
  (VTBL_ENTRY)&_ZN6S482C53v47Ev,
  (VTBL_ENTRY)&_ZN6S482C53v48Ev,
  (VTBL_ENTRY)&_ZN6S482C53v49Ev,
  (VTBL_ENTRY)&_ZN6S482C53v50Ev,
  (VTBL_ENTRY)&_ZN6S482C53v51Ev,
  (VTBL_ENTRY)&_ZN6S482C53v52Ev,
  (VTBL_ENTRY)&_ZN6S482C53v53Ev,
  (VTBL_ENTRY)&_ZN6S482C53v54Ev,
  (VTBL_ENTRY)&_ZN6S482C53v55Ev,
  (VTBL_ENTRY)&_ZN6S482C53v56Ev,
  (VTBL_ENTRY)&_ZN6S482C53v57Ev,
  (VTBL_ENTRY)&_ZN6S482C53v58Ev,
  (VTBL_ENTRY)&_ZN6S482C53v59Ev,
  (VTBL_ENTRY)&_ZN6S482C53v60Ev,
  (VTBL_ENTRY)&_ZN6S482C53v61Ev,
  (VTBL_ENTRY)&_ZN6S482C53v62Ev,
  (VTBL_ENTRY)&_ZN6S482C53v63Ev,
  (VTBL_ENTRY)&_ZN6S482C53v64Ev,
  (VTBL_ENTRY)&_ZN6S482C53v65Ev,
  (VTBL_ENTRY)&_ZN6S482C53v66Ev,
  (VTBL_ENTRY)&_ZN6S482C53v67Ev,
  (VTBL_ENTRY)&_ZN6S482C53v68Ev,
  (VTBL_ENTRY)&_ZN6S482C53v69Ev,
  (VTBL_ENTRY)&_ZN6S482C53v70Ev,
  (VTBL_ENTRY)&_ZN6S482C53v71Ev,
  (VTBL_ENTRY)&_ZN6S482C53v72Ev,
  (VTBL_ENTRY)&_ZN6S482C53v73Ev,
  (VTBL_ENTRY)&_ZN6S482C53v74Ev,
  (VTBL_ENTRY)&_ZN6S482C53v75Ev,
};
extern VTBL_ENTRY _ZTI6S482C5[];
extern  VTBL_ENTRY _ZTV6S482C5[];
Class_Descriptor cd_S482C5 = {  "S482C5", // class name
  0,0,//no base classes
  &(vtc_S482C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S482C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S482C5),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S482C4  : S482C5 {
  virtual  ~S482C4(); // _ZN6S482C4D1Ev
  virtual void  v76(); // _ZN6S482C43v76Ev
  virtual void  v77(); // _ZN6S482C43v77Ev
  virtual void  v78(); // _ZN6S482C43v78Ev
  virtual void  v79(); // _ZN6S482C43v79Ev
  S482C4(); // tgen
};
//SIG(-1 S482C4) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S482C4 ::~S482C4(){ note_dtor("S482C4", this);}
void  S482C4 ::v76(){vfunc_called(this, "_ZN6S482C43v76Ev");}
void  S482C4 ::v77(){vfunc_called(this, "_ZN6S482C43v77Ev");}
void  S482C4 ::v78(){vfunc_called(this, "_ZN6S482C43v78Ev");}
void  S482C4 ::v79(){vfunc_called(this, "_ZN6S482C43v79Ev");}
S482C4 ::S482C4(){ note_ctor("S482C4", this);} // tgen

static void Test_S482C4()
{
  extern Class_Descriptor cd_S482C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S482C4, buf);
    S482C4 *dp, &lv = *(dp=new (buf) S482C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S482C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S482C4)");
    check_base_class_offset(lv, (S482C5*), 0, "S482C4");
    test_class_info(&lv, &cd_S482C4);
    dp->~S482C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS482C4(Test_S482C4, "S482C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN6S482C4C1Ev();
extern void _ZN6S482C4D1Ev();
Name_Map name_map_S482C4[] = {
  NSPAIR(_ZN6S482C4C1Ev),
  NSPAIR(_ZN6S482C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S482C5;
extern VTBL_ENTRY _ZTI6S482C5[];
extern  VTBL_ENTRY _ZTV6S482C5[];
static Base_Class bases_S482C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S482C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S482C4[];
extern void _ZN6S482C4D1Ev();
extern void _ZN6S482C4D0Ev();
extern void _ZN6S482C53v12Ev();
extern void _ZN6S482C53v13Ev();
extern void _ZN6S482C53v14Ev();
extern void _ZN6S482C53v15Ev();
extern void _ZN6S482C53v16Ev();
extern void _ZN6S482C53v17Ev();
extern void _ZN6S482C53v18Ev();
extern void _ZN6S482C53v19Ev();
extern void _ZN6S482C53v20Ev();
extern void _ZN6S482C53v21Ev();
extern void _ZN6S482C53v22Ev();
extern void _ZN6S482C53v23Ev();
extern void _ZN6S482C53v24Ev();
extern void _ZN6S482C53v25Ev();
extern void _ZN6S482C53v26Ev();
extern void _ZN6S482C53v27Ev();
extern void _ZN6S482C53v28Ev();
extern void _ZN6S482C53v29Ev();
extern void _ZN6S482C53v30Ev();
extern void _ZN6S482C53v31Ev();
extern void _ZN6S482C53v32Ev();
extern void _ZN6S482C53v33Ev();
extern void _ZN6S482C53v34Ev();
extern void _ZN6S482C53v35Ev();
extern void _ZN6S482C53v36Ev();
extern void _ZN6S482C53v37Ev();
extern void _ZN6S482C53v38Ev();
extern void _ZN6S482C53v39Ev();
extern void _ZN6S482C53v40Ev();
extern void _ZN6S482C53v41Ev();
extern void _ZN6S482C53v42Ev();
extern void _ZN6S482C53v43Ev();
extern void _ZN6S482C53v44Ev();
extern void _ZN6S482C53v45Ev();
extern void _ZN6S482C53v46Ev();
extern void _ZN6S482C53v47Ev();
extern void _ZN6S482C53v48Ev();
extern void _ZN6S482C53v49Ev();
extern void _ZN6S482C53v50Ev();
extern void _ZN6S482C53v51Ev();
extern void _ZN6S482C53v52Ev();
extern void _ZN6S482C53v53Ev();
extern void _ZN6S482C53v54Ev();
extern void _ZN6S482C53v55Ev();
extern void _ZN6S482C53v56Ev();
extern void _ZN6S482C53v57Ev();
extern void _ZN6S482C53v58Ev();
extern void _ZN6S482C53v59Ev();
extern void _ZN6S482C53v60Ev();
extern void _ZN6S482C53v61Ev();
extern void _ZN6S482C53v62Ev();
extern void _ZN6S482C53v63Ev();
extern void _ZN6S482C53v64Ev();
extern void _ZN6S482C53v65Ev();
extern void _ZN6S482C53v66Ev();
extern void _ZN6S482C53v67Ev();
extern void _ZN6S482C53v68Ev();
extern void _ZN6S482C53v69Ev();
extern void _ZN6S482C53v70Ev();
extern void _ZN6S482C53v71Ev();
extern void _ZN6S482C53v72Ev();
extern void _ZN6S482C53v73Ev();
extern void _ZN6S482C53v74Ev();
extern void _ZN6S482C53v75Ev();
extern void _ZN6S482C43v76Ev();
extern void _ZN6S482C43v77Ev();
extern void _ZN6S482C43v78Ev();
extern void _ZN6S482C43v79Ev();
static  VTBL_ENTRY vtc_S482C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S482C4[0]),
  (VTBL_ENTRY)&_ZN6S482C4D1Ev,
  (VTBL_ENTRY)&_ZN6S482C4D0Ev,
  (VTBL_ENTRY)&_ZN6S482C53v12Ev,
  (VTBL_ENTRY)&_ZN6S482C53v13Ev,
  (VTBL_ENTRY)&_ZN6S482C53v14Ev,
  (VTBL_ENTRY)&_ZN6S482C53v15Ev,
  (VTBL_ENTRY)&_ZN6S482C53v16Ev,
  (VTBL_ENTRY)&_ZN6S482C53v17Ev,
  (VTBL_ENTRY)&_ZN6S482C53v18Ev,
  (VTBL_ENTRY)&_ZN6S482C53v19Ev,
  (VTBL_ENTRY)&_ZN6S482C53v20Ev,
  (VTBL_ENTRY)&_ZN6S482C53v21Ev,
  (VTBL_ENTRY)&_ZN6S482C53v22Ev,
  (VTBL_ENTRY)&_ZN6S482C53v23Ev,
  (VTBL_ENTRY)&_ZN6S482C53v24Ev,
  (VTBL_ENTRY)&_ZN6S482C53v25Ev,
  (VTBL_ENTRY)&_ZN6S482C53v26Ev,
  (VTBL_ENTRY)&_ZN6S482C53v27Ev,
  (VTBL_ENTRY)&_ZN6S482C53v28Ev,
  (VTBL_ENTRY)&_ZN6S482C53v29Ev,
  (VTBL_ENTRY)&_ZN6S482C53v30Ev,
  (VTBL_ENTRY)&_ZN6S482C53v31Ev,
  (VTBL_ENTRY)&_ZN6S482C53v32Ev,
  (VTBL_ENTRY)&_ZN6S482C53v33Ev,
  (VTBL_ENTRY)&_ZN6S482C53v34Ev,
  (VTBL_ENTRY)&_ZN6S482C53v35Ev,
  (VTBL_ENTRY)&_ZN6S482C53v36Ev,
  (VTBL_ENTRY)&_ZN6S482C53v37Ev,
  (VTBL_ENTRY)&_ZN6S482C53v38Ev,
  (VTBL_ENTRY)&_ZN6S482C53v39Ev,
  (VTBL_ENTRY)&_ZN6S482C53v40Ev,
  (VTBL_ENTRY)&_ZN6S482C53v41Ev,
  (VTBL_ENTRY)&_ZN6S482C53v42Ev,
  (VTBL_ENTRY)&_ZN6S482C53v43Ev,
  (VTBL_ENTRY)&_ZN6S482C53v44Ev,
  (VTBL_ENTRY)&_ZN6S482C53v45Ev,
  (VTBL_ENTRY)&_ZN6S482C53v46Ev,
  (VTBL_ENTRY)&_ZN6S482C53v47Ev,
  (VTBL_ENTRY)&_ZN6S482C53v48Ev,
  (VTBL_ENTRY)&_ZN6S482C53v49Ev,
  (VTBL_ENTRY)&_ZN6S482C53v50Ev,
  (VTBL_ENTRY)&_ZN6S482C53v51Ev,
  (VTBL_ENTRY)&_ZN6S482C53v52Ev,
  (VTBL_ENTRY)&_ZN6S482C53v53Ev,
  (VTBL_ENTRY)&_ZN6S482C53v54Ev,
  (VTBL_ENTRY)&_ZN6S482C53v55Ev,
  (VTBL_ENTRY)&_ZN6S482C53v56Ev,
  (VTBL_ENTRY)&_ZN6S482C53v57Ev,
  (VTBL_ENTRY)&_ZN6S482C53v58Ev,
  (VTBL_ENTRY)&_ZN6S482C53v59Ev,
  (VTBL_ENTRY)&_ZN6S482C53v60Ev,
  (VTBL_ENTRY)&_ZN6S482C53v61Ev,
  (VTBL_ENTRY)&_ZN6S482C53v62Ev,
  (VTBL_ENTRY)&_ZN6S482C53v63Ev,
  (VTBL_ENTRY)&_ZN6S482C53v64Ev,
  (VTBL_ENTRY)&_ZN6S482C53v65Ev,
  (VTBL_ENTRY)&_ZN6S482C53v66Ev,
  (VTBL_ENTRY)&_ZN6S482C53v67Ev,
  (VTBL_ENTRY)&_ZN6S482C53v68Ev,
  (VTBL_ENTRY)&_ZN6S482C53v69Ev,
  (VTBL_ENTRY)&_ZN6S482C53v70Ev,
  (VTBL_ENTRY)&_ZN6S482C53v71Ev,
  (VTBL_ENTRY)&_ZN6S482C53v72Ev,
  (VTBL_ENTRY)&_ZN6S482C53v73Ev,
  (VTBL_ENTRY)&_ZN6S482C53v74Ev,
  (VTBL_ENTRY)&_ZN6S482C53v75Ev,
  (VTBL_ENTRY)&_ZN6S482C43v76Ev,
  (VTBL_ENTRY)&_ZN6S482C43v77Ev,
  (VTBL_ENTRY)&_ZN6S482C43v78Ev,
  (VTBL_ENTRY)&_ZN6S482C43v79Ev,
};
extern VTBL_ENTRY _ZTI6S482C4[];
extern  VTBL_ENTRY _ZTV6S482C4[];
Class_Descriptor cd_S482C4 = {  "S482C4", // class name
  bases_S482C4, 1,
  &(vtc_S482C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI6S482C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S482C4),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S482C3  : S482C4 {
  unsigned int s482c3f0:1;
  unsigned int s482c3f1:1;
  unsigned int s482c3f2:1;
  unsigned int s482c3f3:1;
  unsigned int s482c3f4:1;
  unsigned int s482c3f5:1;
  unsigned int s482c3f6:1;
  unsigned int s482c3f7:1;
  unsigned int s482c3f8:1;
  unsigned int s482c3f9:1;
  unsigned int s482c3f10:1;
  unsigned int s482c3f11:1;
  unsigned int s482c3f12:1;
  int s482c3f13[8];
  ::S507C7 s482c3f14;
  unsigned int s482c3f15:1;
  char s482c3f16;
  char s482c3f17[2];
  int s482c3f18[2];
  ::S685C27_nt s482c3f19;
  ::S685C27_nt s482c3f20;
  void *s482c3f21;
  virtual  ~S482C3(); // _ZN6S482C3D1Ev
  virtual void  v80(); // _ZN6S482C33v80Ev
  virtual void  v81(); // _ZN6S482C33v81Ev
  virtual void  v82(); // _ZN6S482C33v82Ev
  virtual void  v83(); // _ZN6S482C33v83Ev
  virtual void  v84(); // _ZN6S482C33v84Ev
  virtual void  v85(); // _ZN6S482C33v85Ev
  virtual void  v86(); // _ZN6S482C33v86Ev
  virtual void  v87(); // _ZN6S482C33v87Ev
  virtual void  v88(); // _ZN6S482C33v88Ev
  virtual void  v89(); // _ZN6S482C33v89Ev
  virtual void  v90(); // _ZN6S482C33v90Ev
  virtual void  v91(); // _ZN6S482C33v91Ev
  virtual void  v92(); // _ZN6S482C33v92Ev
  virtual void  v93(); // _ZN6S482C33v93Ev
  virtual void  v94(); // _ZN6S482C33v94Ev
  virtual void  v95(); // _ZN6S482C33v95Ev
  S482C3(); // tgen
};
//SIG(-1 S482C3) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC5{ BC6{ vd v87 v88 v89 v90 v91 Fi[8] Fp Fi Fp} v85 v86} Fi:1 Fc[3] Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 Fp}


 S482C3 ::~S482C3(){ note_dtor("S482C3", this);}
void  S482C3 ::v80(){vfunc_called(this, "_ZN6S482C33v80Ev");}
void  S482C3 ::v81(){vfunc_called(this, "_ZN6S482C33v81Ev");}
void  S482C3 ::v82(){vfunc_called(this, "_ZN6S482C33v82Ev");}
void  S482C3 ::v83(){vfunc_called(this, "_ZN6S482C33v83Ev");}
void  S482C3 ::v84(){vfunc_called(this, "_ZN6S482C33v84Ev");}
void  S482C3 ::v85(){vfunc_called(this, "_ZN6S482C33v85Ev");}
void  S482C3 ::v86(){vfunc_called(this, "_ZN6S482C33v86Ev");}
void  S482C3 ::v87(){vfunc_called(this, "_ZN6S482C33v87Ev");}
void  S482C3 ::v88(){vfunc_called(this, "_ZN6S482C33v88Ev");}
void  S482C3 ::v89(){vfunc_called(this, "_ZN6S482C33v89Ev");}
void  S482C3 ::v90(){vfunc_called(this, "_ZN6S482C33v90Ev");}
void  S482C3 ::v91(){vfunc_called(this, "_ZN6S482C33v91Ev");}
void  S482C3 ::v92(){vfunc_called(this, "_ZN6S482C33v92Ev");}
void  S482C3 ::v93(){vfunc_called(this, "_ZN6S482C33v93Ev");}
void  S482C3 ::v94(){vfunc_called(this, "_ZN6S482C33v94Ev");}
void  S482C3 ::v95(){vfunc_called(this, "_ZN6S482C33v95Ev");}
S482C3 ::S482C3(){ note_ctor("S482C3", this);} // tgen

static void Test_S482C3()
{
  extern Class_Descriptor cd_S482C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,47)];
    init_test(&cd_S482C3, buf);
    S482C3 *dp, &lv = *(dp=new (buf) S482C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,184), "sizeof(S482C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S482C3)");
    check_base_class_offset(lv, (S482C5*)(S482C4*), 0, "S482C3");
    check_base_class_offset(lv, (S482C4*), 0, "S482C3");
    set_bf_and_test(lv, s482c3f0, ABISELECT(96,60), 0, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f1, ABISELECT(96,60), 1, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f2, ABISELECT(96,60), 2, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f3, ABISELECT(96,60), 3, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f4, ABISELECT(96,60), 4, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f5, ABISELECT(96,60), 5, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f6, ABISELECT(96,60), 6, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f7, ABISELECT(96,60), 7, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f8, ABISELECT(97,61), 0, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f9, ABISELECT(97,61), 1, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f10, ABISELECT(97,61), 2, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f11, ABISELECT(97,61), 3, 1, 1, "S482C3");
    set_bf_and_test(lv, s482c3f12, ABISELECT(97,61), 4, 1, 1, "S482C3");
    check_field_offset(lv, s482c3f13, ABISELECT(100,64), "S482C3.s482c3f13");
    check_field_offset(lv, s482c3f14, ABISELECT(136,96), "S482C3.s482c3f14");
    set_bf_and_test(lv, s482c3f15, ABISELECT(200,144), 0, 1, 1, "S482C3");
    check_field_offset(lv, s482c3f16, ABISELECT(201,145), "S482C3.s482c3f16");
    check_field_offset(lv, s482c3f17, ABISELECT(202,146), "S482C3.s482c3f17");
    check_field_offset(lv, s482c3f18, ABISELECT(204,148), "S482C3.s482c3f18");
    check_field_offset(lv, s482c3f19, ABISELECT(216,156), "S482C3.s482c3f19");
    check_field_offset(lv, s482c3f20, ABISELECT(232,168), "S482C3.s482c3f20");
    check_field_offset(lv, s482c3f21, ABISELECT(248,180), "S482C3.s482c3f21");
    test_class_info(&lv, &cd_S482C3);
    dp->~S482C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS482C3(Test_S482C3, "S482C3", ABISELECT(256,184));

#else // __cplusplus

extern void _ZN6S482C3C1Ev();
extern void _ZN6S482C3D1Ev();
Name_Map name_map_S482C3[] = {
  NSPAIR(_ZN6S482C3C1Ev),
  NSPAIR(_ZN6S482C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S482C5;
extern VTBL_ENTRY _ZTI6S482C5[];
extern  VTBL_ENTRY _ZTV6S482C5[];
extern Class_Descriptor cd_S482C4;
extern VTBL_ENTRY _ZTI6S482C4[];
extern  VTBL_ENTRY _ZTV6S482C4[];
static Base_Class bases_S482C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S482C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S482C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S482C3[];
extern void _ZN6S482C3D1Ev();
extern void _ZN6S482C3D0Ev();
extern void _ZN6S482C53v12Ev();
extern void _ZN6S482C53v13Ev();
extern void _ZN6S482C53v14Ev();
extern void _ZN6S482C53v15Ev();
extern void _ZN6S482C53v16Ev();
extern void _ZN6S482C53v17Ev();
extern void _ZN6S482C53v18Ev();
extern void _ZN6S482C53v19Ev();
extern void _ZN6S482C53v20Ev();
extern void _ZN6S482C53v21Ev();
extern void _ZN6S482C53v22Ev();
extern void _ZN6S482C53v23Ev();
extern void _ZN6S482C53v24Ev();
extern void _ZN6S482C53v25Ev();
extern void _ZN6S482C53v26Ev();
extern void _ZN6S482C53v27Ev();
extern void _ZN6S482C53v28Ev();
extern void _ZN6S482C53v29Ev();
extern void _ZN6S482C53v30Ev();
extern void _ZN6S482C53v31Ev();
extern void _ZN6S482C53v32Ev();
extern void _ZN6S482C53v33Ev();
extern void _ZN6S482C53v34Ev();
extern void _ZN6S482C53v35Ev();
extern void _ZN6S482C53v36Ev();
extern void _ZN6S482C53v37Ev();
extern void _ZN6S482C53v38Ev();
extern void _ZN6S482C53v39Ev();
extern void _ZN6S482C53v40Ev();
extern void _ZN6S482C53v41Ev();
extern void _ZN6S482C53v42Ev();
extern void _ZN6S482C53v43Ev();
extern void _ZN6S482C53v44Ev();
extern void _ZN6S482C53v45Ev();
extern void _ZN6S482C53v46Ev();
extern void _ZN6S482C53v47Ev();
extern void _ZN6S482C53v48Ev();
extern void _ZN6S482C53v49Ev();
extern void _ZN6S482C53v50Ev();
extern void _ZN6S482C53v51Ev();
extern void _ZN6S482C53v52Ev();
extern void _ZN6S482C53v53Ev();
extern void _ZN6S482C53v54Ev();
extern void _ZN6S482C53v55Ev();
extern void _ZN6S482C53v56Ev();
extern void _ZN6S482C53v57Ev();
extern void _ZN6S482C53v58Ev();
extern void _ZN6S482C53v59Ev();
extern void _ZN6S482C53v60Ev();
extern void _ZN6S482C53v61Ev();
extern void _ZN6S482C53v62Ev();
extern void _ZN6S482C53v63Ev();
extern void _ZN6S482C53v64Ev();
extern void _ZN6S482C53v65Ev();
extern void _ZN6S482C53v66Ev();
extern void _ZN6S482C53v67Ev();
extern void _ZN6S482C53v68Ev();
extern void _ZN6S482C53v69Ev();
extern void _ZN6S482C53v70Ev();
extern void _ZN6S482C53v71Ev();
extern void _ZN6S482C53v72Ev();
extern void _ZN6S482C53v73Ev();
extern void _ZN6S482C53v74Ev();
extern void _ZN6S482C53v75Ev();
extern void _ZN6S482C43v76Ev();
extern void _ZN6S482C43v77Ev();
extern void _ZN6S482C43v78Ev();
extern void _ZN6S482C43v79Ev();
extern void _ZN6S482C33v80Ev();
extern void _ZN6S482C33v81Ev();
extern void _ZN6S482C33v82Ev();
extern void _ZN6S482C33v83Ev();
extern void _ZN6S482C33v84Ev();
extern void _ZN6S482C33v85Ev();
extern void _ZN6S482C33v86Ev();
extern void _ZN6S482C33v87Ev();
extern void _ZN6S482C33v88Ev();
extern void _ZN6S482C33v89Ev();
extern void _ZN6S482C33v90Ev();
extern void _ZN6S482C33v91Ev();
extern void _ZN6S482C33v92Ev();
extern void _ZN6S482C33v93Ev();
extern void _ZN6S482C33v94Ev();
extern void _ZN6S482C33v95Ev();
static  VTBL_ENTRY vtc_S482C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S482C3[0]),
  (VTBL_ENTRY)&_ZN6S482C3D1Ev,
  (VTBL_ENTRY)&_ZN6S482C3D0Ev,
  (VTBL_ENTRY)&_ZN6S482C53v12Ev,
  (VTBL_ENTRY)&_ZN6S482C53v13Ev,
  (VTBL_ENTRY)&_ZN6S482C53v14Ev,
  (VTBL_ENTRY)&_ZN6S482C53v15Ev,
  (VTBL_ENTRY)&_ZN6S482C53v16Ev,
  (VTBL_ENTRY)&_ZN6S482C53v17Ev,
  (VTBL_ENTRY)&_ZN6S482C53v18Ev,
  (VTBL_ENTRY)&_ZN6S482C53v19Ev,
  (VTBL_ENTRY)&_ZN6S482C53v20Ev,
  (VTBL_ENTRY)&_ZN6S482C53v21Ev,
  (VTBL_ENTRY)&_ZN6S482C53v22Ev,
  (VTBL_ENTRY)&_ZN6S482C53v23Ev,
  (VTBL_ENTRY)&_ZN6S482C53v24Ev,
  (VTBL_ENTRY)&_ZN6S482C53v25Ev,
  (VTBL_ENTRY)&_ZN6S482C53v26Ev,
  (VTBL_ENTRY)&_ZN6S482C53v27Ev,
  (VTBL_ENTRY)&_ZN6S482C53v28Ev,
  (VTBL_ENTRY)&_ZN6S482C53v29Ev,
  (VTBL_ENTRY)&_ZN6S482C53v30Ev,
  (VTBL_ENTRY)&_ZN6S482C53v31Ev,
  (VTBL_ENTRY)&_ZN6S482C53v32Ev,
  (VTBL_ENTRY)&_ZN6S482C53v33Ev,
  (VTBL_ENTRY)&_ZN6S482C53v34Ev,
  (VTBL_ENTRY)&_ZN6S482C53v35Ev,
  (VTBL_ENTRY)&_ZN6S482C53v36Ev,
  (VTBL_ENTRY)&_ZN6S482C53v37Ev,
  (VTBL_ENTRY)&_ZN6S482C53v38Ev,
  (VTBL_ENTRY)&_ZN6S482C53v39Ev,
  (VTBL_ENTRY)&_ZN6S482C53v40Ev,
  (VTBL_ENTRY)&_ZN6S482C53v41Ev,
  (VTBL_ENTRY)&_ZN6S482C53v42Ev,
  (VTBL_ENTRY)&_ZN6S482C53v43Ev,
  (VTBL_ENTRY)&_ZN6S482C53v44Ev,
  (VTBL_ENTRY)&_ZN6S482C53v45Ev,
  (VTBL_ENTRY)&_ZN6S482C53v46Ev,
  (VTBL_ENTRY)&_ZN6S482C53v47Ev,
  (VTBL_ENTRY)&_ZN6S482C53v48Ev,
  (VTBL_ENTRY)&_ZN6S482C53v49Ev,
  (VTBL_ENTRY)&_ZN6S482C53v50Ev,
  (VTBL_ENTRY)&_ZN6S482C53v51Ev,
  (VTBL_ENTRY)&_ZN6S482C53v52Ev,
  (VTBL_ENTRY)&_ZN6S482C53v53Ev,
  (VTBL_ENTRY)&_ZN6S482C53v54Ev,
  (VTBL_ENTRY)&_ZN6S482C53v55Ev,
  (VTBL_ENTRY)&_ZN6S482C53v56Ev,
  (VTBL_ENTRY)&_ZN6S482C53v57Ev,
  (VTBL_ENTRY)&_ZN6S482C53v58Ev,
  (VTBL_ENTRY)&_ZN6S482C53v59Ev,
  (VTBL_ENTRY)&_ZN6S482C53v60Ev,
  (VTBL_ENTRY)&_ZN6S482C53v61Ev,
  (VTBL_ENTRY)&_ZN6S482C53v62Ev,
  (VTBL_ENTRY)&_ZN6S482C53v63Ev,
  (VTBL_ENTRY)&_ZN6S482C53v64Ev,
  (VTBL_ENTRY)&_ZN6S482C53v65Ev,
  (VTBL_ENTRY)&_ZN6S482C53v66Ev,
  (VTBL_ENTRY)&_ZN6S482C53v67Ev,
  (VTBL_ENTRY)&_ZN6S482C53v68Ev,
  (VTBL_ENTRY)&_ZN6S482C53v69Ev,
  (VTBL_ENTRY)&_ZN6S482C53v70Ev,
  (VTBL_ENTRY)&_ZN6S482C53v71Ev,
  (VTBL_ENTRY)&_ZN6S482C53v72Ev,
  (VTBL_ENTRY)&_ZN6S482C53v73Ev,
  (VTBL_ENTRY)&_ZN6S482C53v74Ev,
  (VTBL_ENTRY)&_ZN6S482C53v75Ev,
  (VTBL_ENTRY)&_ZN6S482C43v76Ev,
  (VTBL_ENTRY)&_ZN6S482C43v77Ev,
  (VTBL_ENTRY)&_ZN6S482C43v78Ev,
  (VTBL_ENTRY)&_ZN6S482C43v79Ev,
  (VTBL_ENTRY)&_ZN6S482C33v80Ev,
  (VTBL_ENTRY)&_ZN6S482C33v81Ev,
  (VTBL_ENTRY)&_ZN6S482C33v82Ev,
  (VTBL_ENTRY)&_ZN6S482C33v83Ev,
  (VTBL_ENTRY)&_ZN6S482C33v84Ev,
  (VTBL_ENTRY)&_ZN6S482C33v85Ev,
  (VTBL_ENTRY)&_ZN6S482C33v86Ev,
  (VTBL_ENTRY)&_ZN6S482C33v87Ev,
  (VTBL_ENTRY)&_ZN6S482C33v88Ev,
  (VTBL_ENTRY)&_ZN6S482C33v89Ev,
  (VTBL_ENTRY)&_ZN6S482C33v90Ev,
  (VTBL_ENTRY)&_ZN6S482C33v91Ev,
  (VTBL_ENTRY)&_ZN6S482C33v92Ev,
  (VTBL_ENTRY)&_ZN6S482C33v93Ev,
  (VTBL_ENTRY)&_ZN6S482C33v94Ev,
  (VTBL_ENTRY)&_ZN6S482C33v95Ev,
};
extern VTBL_ENTRY _ZTI6S482C3[];
extern  VTBL_ENTRY _ZTV6S482C3[];
Class_Descriptor cd_S482C3 = {  "S482C3", // class name
  bases_S482C3, 2,
  &(vtc_S482C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,184), // object size
  NSPAIRA(_ZTI6S482C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S482C3),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S482C2  : S482C3 {
  unsigned int s482c2f0:1;
  unsigned int s482c2f1:1;
  unsigned int s482c2f2:1;
  virtual  ~S482C2(); // _ZN6S482C2D1Ev
  virtual void  v96(); // _ZN6S482C23v96Ev
  virtual void  v97(); // _ZN6S482C23v97Ev
  virtual void  v98(); // _ZN6S482C23v98Ev
  virtual void  v99(); // _ZN6S482C23v99Ev
  virtual void  v100(); // _ZN6S482C24v100Ev
  S482C2(); // tgen
};
//SIG(-1 S482C2) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v70 v71 v72 v73} vd v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC6{ BC7{ vd v92 v93 v94 v95 v96 Fi[8] Fp Fi Fp} v90 v91} Fi:1 Fc[3] Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 Fp} vd v1 v2 v3 v4 v5 Fi:1 Fi:1 Fi:1}


 S482C2 ::~S482C2(){ note_dtor("S482C2", this);}
void  S482C2 ::v96(){vfunc_called(this, "_ZN6S482C23v96Ev");}
void  S482C2 ::v97(){vfunc_called(this, "_ZN6S482C23v97Ev");}
void  S482C2 ::v98(){vfunc_called(this, "_ZN6S482C23v98Ev");}
void  S482C2 ::v99(){vfunc_called(this, "_ZN6S482C23v99Ev");}
void  S482C2 ::v100(){vfunc_called(this, "_ZN6S482C24v100Ev");}
S482C2 ::S482C2(){ note_ctor("S482C2", this);} // tgen

static void Test_S482C2()
{
  extern Class_Descriptor cd_S482C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(34,48)];
    init_test(&cd_S482C2, buf);
    S482C2 *dp, &lv = *(dp=new (buf) S482C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(264,188), "sizeof(S482C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S482C2)");
    check_base_class_offset(lv, (S482C5*)(S482C4*)(S482C3*), 0, "S482C2");
    check_base_class_offset(lv, (S482C4*)(S482C3*), 0, "S482C2");
    check_base_class_offset(lv, (S482C3*), 0, "S482C2");
    set_bf_and_test(lv, s482c2f0, ABISELECT(256,184), 0, 1, 1, "S482C2");
    set_bf_and_test(lv, s482c2f1, ABISELECT(256,184), 1, 1, 1, "S482C2");
    set_bf_and_test(lv, s482c2f2, ABISELECT(256,184), 2, 1, 1, "S482C2");
    test_class_info(&lv, &cd_S482C2);
    dp->~S482C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS482C2(Test_S482C2, "S482C2", ABISELECT(264,188));

#else // __cplusplus

extern void _ZN6S482C2C1Ev();
extern void _ZN6S482C2D1Ev();
Name_Map name_map_S482C2[] = {
  NSPAIR(_ZN6S482C2C1Ev),
  NSPAIR(_ZN6S482C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S482C5;
extern VTBL_ENTRY _ZTI6S482C5[];
extern  VTBL_ENTRY _ZTV6S482C5[];
extern Class_Descriptor cd_S482C4;
extern VTBL_ENTRY _ZTI6S482C4[];
extern  VTBL_ENTRY _ZTV6S482C4[];
extern Class_Descriptor cd_S482C3;
extern VTBL_ENTRY _ZTI6S482C3[];
extern  VTBL_ENTRY _ZTV6S482C3[];
static Base_Class bases_S482C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S482C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S482C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S482C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S482C2[];
extern void _ZN6S482C2D1Ev();
extern void _ZN6S482C2D0Ev();
extern void _ZN6S482C53v12Ev();
extern void _ZN6S482C53v13Ev();
extern void _ZN6S482C53v14Ev();
extern void _ZN6S482C53v15Ev();
extern void _ZN6S482C53v16Ev();
extern void _ZN6S482C53v17Ev();
extern void _ZN6S482C53v18Ev();
extern void _ZN6S482C53v19Ev();
extern void _ZN6S482C53v20Ev();
extern void _ZN6S482C53v21Ev();
extern void _ZN6S482C53v22Ev();
extern void _ZN6S482C53v23Ev();
extern void _ZN6S482C53v24Ev();
extern void _ZN6S482C53v25Ev();
extern void _ZN6S482C53v26Ev();
extern void _ZN6S482C53v27Ev();
extern void _ZN6S482C53v28Ev();
extern void _ZN6S482C53v29Ev();
extern void _ZN6S482C53v30Ev();
extern void _ZN6S482C53v31Ev();
extern void _ZN6S482C53v32Ev();
extern void _ZN6S482C53v33Ev();
extern void _ZN6S482C53v34Ev();
extern void _ZN6S482C53v35Ev();
extern void _ZN6S482C53v36Ev();
extern void _ZN6S482C53v37Ev();
extern void _ZN6S482C53v38Ev();
extern void _ZN6S482C53v39Ev();
extern void _ZN6S482C53v40Ev();
extern void _ZN6S482C53v41Ev();
extern void _ZN6S482C53v42Ev();
extern void _ZN6S482C53v43Ev();
extern void _ZN6S482C53v44Ev();
extern void _ZN6S482C53v45Ev();
extern void _ZN6S482C53v46Ev();
extern void _ZN6S482C53v47Ev();
extern void _ZN6S482C53v48Ev();
extern void _ZN6S482C53v49Ev();
extern void _ZN6S482C53v50Ev();
extern void _ZN6S482C53v51Ev();
extern void _ZN6S482C53v52Ev();
extern void _ZN6S482C53v53Ev();
extern void _ZN6S482C53v54Ev();
extern void _ZN6S482C53v55Ev();
extern void _ZN6S482C53v56Ev();
extern void _ZN6S482C53v57Ev();
extern void _ZN6S482C53v58Ev();
extern void _ZN6S482C53v59Ev();
extern void _ZN6S482C53v60Ev();
extern void _ZN6S482C53v61Ev();
extern void _ZN6S482C53v62Ev();
extern void _ZN6S482C53v63Ev();
extern void _ZN6S482C53v64Ev();
extern void _ZN6S482C53v65Ev();
extern void _ZN6S482C53v66Ev();
extern void _ZN6S482C53v67Ev();
extern void _ZN6S482C53v68Ev();
extern void _ZN6S482C53v69Ev();
extern void _ZN6S482C53v70Ev();
extern void _ZN6S482C53v71Ev();
extern void _ZN6S482C53v72Ev();
extern void _ZN6S482C53v73Ev();
extern void _ZN6S482C53v74Ev();
extern void _ZN6S482C53v75Ev();
extern void _ZN6S482C43v76Ev();
extern void _ZN6S482C43v77Ev();
extern void _ZN6S482C43v78Ev();
extern void _ZN6S482C43v79Ev();
extern void _ZN6S482C33v80Ev();
extern void _ZN6S482C33v81Ev();
extern void _ZN6S482C33v82Ev();
extern void _ZN6S482C33v83Ev();
extern void _ZN6S482C33v84Ev();
extern void _ZN6S482C33v85Ev();
extern void _ZN6S482C33v86Ev();
extern void _ZN6S482C33v87Ev();
extern void _ZN6S482C33v88Ev();
extern void _ZN6S482C33v89Ev();
extern void _ZN6S482C33v90Ev();
extern void _ZN6S482C33v91Ev();
extern void _ZN6S482C33v92Ev();
extern void _ZN6S482C33v93Ev();
extern void _ZN6S482C33v94Ev();
extern void _ZN6S482C33v95Ev();
extern void _ZN6S482C23v96Ev();
extern void _ZN6S482C23v97Ev();
extern void _ZN6S482C23v98Ev();
extern void _ZN6S482C23v99Ev();
extern void _ZN6S482C24v100Ev();
static  VTBL_ENTRY vtc_S482C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S482C2[0]),
  (VTBL_ENTRY)&_ZN6S482C2D1Ev,
  (VTBL_ENTRY)&_ZN6S482C2D0Ev,
  (VTBL_ENTRY)&_ZN6S482C53v12Ev,
  (VTBL_ENTRY)&_ZN6S482C53v13Ev,
  (VTBL_ENTRY)&_ZN6S482C53v14Ev,
  (VTBL_ENTRY)&_ZN6S482C53v15Ev,
  (VTBL_ENTRY)&_ZN6S482C53v16Ev,
  (VTBL_ENTRY)&_ZN6S482C53v17Ev,
  (VTBL_ENTRY)&_ZN6S482C53v18Ev,
  (VTBL_ENTRY)&_ZN6S482C53v19Ev,
  (VTBL_ENTRY)&_ZN6S482C53v20Ev,
  (VTBL_ENTRY)&_ZN6S482C53v21Ev,
  (VTBL_ENTRY)&_ZN6S482C53v22Ev,
  (VTBL_ENTRY)&_ZN6S482C53v23Ev,
  (VTBL_ENTRY)&_ZN6S482C53v24Ev,
  (VTBL_ENTRY)&_ZN6S482C53v25Ev,
  (VTBL_ENTRY)&_ZN6S482C53v26Ev,
  (VTBL_ENTRY)&_ZN6S482C53v27Ev,
  (VTBL_ENTRY)&_ZN6S482C53v28Ev,
  (VTBL_ENTRY)&_ZN6S482C53v29Ev,
  (VTBL_ENTRY)&_ZN6S482C53v30Ev,
  (VTBL_ENTRY)&_ZN6S482C53v31Ev,
  (VTBL_ENTRY)&_ZN6S482C53v32Ev,
  (VTBL_ENTRY)&_ZN6S482C53v33Ev,
  (VTBL_ENTRY)&_ZN6S482C53v34Ev,
  (VTBL_ENTRY)&_ZN6S482C53v35Ev,
  (VTBL_ENTRY)&_ZN6S482C53v36Ev,
  (VTBL_ENTRY)&_ZN6S482C53v37Ev,
  (VTBL_ENTRY)&_ZN6S482C53v38Ev,
  (VTBL_ENTRY)&_ZN6S482C53v39Ev,
  (VTBL_ENTRY)&_ZN6S482C53v40Ev,
  (VTBL_ENTRY)&_ZN6S482C53v41Ev,
  (VTBL_ENTRY)&_ZN6S482C53v42Ev,
  (VTBL_ENTRY)&_ZN6S482C53v43Ev,
  (VTBL_ENTRY)&_ZN6S482C53v44Ev,
  (VTBL_ENTRY)&_ZN6S482C53v45Ev,
  (VTBL_ENTRY)&_ZN6S482C53v46Ev,
  (VTBL_ENTRY)&_ZN6S482C53v47Ev,
  (VTBL_ENTRY)&_ZN6S482C53v48Ev,
  (VTBL_ENTRY)&_ZN6S482C53v49Ev,
  (VTBL_ENTRY)&_ZN6S482C53v50Ev,
  (VTBL_ENTRY)&_ZN6S482C53v51Ev,
  (VTBL_ENTRY)&_ZN6S482C53v52Ev,
  (VTBL_ENTRY)&_ZN6S482C53v53Ev,
  (VTBL_ENTRY)&_ZN6S482C53v54Ev,
  (VTBL_ENTRY)&_ZN6S482C53v55Ev,
  (VTBL_ENTRY)&_ZN6S482C53v56Ev,
  (VTBL_ENTRY)&_ZN6S482C53v57Ev,
  (VTBL_ENTRY)&_ZN6S482C53v58Ev,
  (VTBL_ENTRY)&_ZN6S482C53v59Ev,
  (VTBL_ENTRY)&_ZN6S482C53v60Ev,
  (VTBL_ENTRY)&_ZN6S482C53v61Ev,
  (VTBL_ENTRY)&_ZN6S482C53v62Ev,
  (VTBL_ENTRY)&_ZN6S482C53v63Ev,
  (VTBL_ENTRY)&_ZN6S482C53v64Ev,
  (VTBL_ENTRY)&_ZN6S482C53v65Ev,
  (VTBL_ENTRY)&_ZN6S482C53v66Ev,
  (VTBL_ENTRY)&_ZN6S482C53v67Ev,
  (VTBL_ENTRY)&_ZN6S482C53v68Ev,
  (VTBL_ENTRY)&_ZN6S482C53v69Ev,
  (VTBL_ENTRY)&_ZN6S482C53v70Ev,
  (VTBL_ENTRY)&_ZN6S482C53v71Ev,
  (VTBL_ENTRY)&_ZN6S482C53v72Ev,
  (VTBL_ENTRY)&_ZN6S482C53v73Ev,
  (VTBL_ENTRY)&_ZN6S482C53v74Ev,
  (VTBL_ENTRY)&_ZN6S482C53v75Ev,
  (VTBL_ENTRY)&_ZN6S482C43v76Ev,
  (VTBL_ENTRY)&_ZN6S482C43v77Ev,
  (VTBL_ENTRY)&_ZN6S482C43v78Ev,
  (VTBL_ENTRY)&_ZN6S482C43v79Ev,
  (VTBL_ENTRY)&_ZN6S482C33v80Ev,
  (VTBL_ENTRY)&_ZN6S482C33v81Ev,
  (VTBL_ENTRY)&_ZN6S482C33v82Ev,
  (VTBL_ENTRY)&_ZN6S482C33v83Ev,
  (VTBL_ENTRY)&_ZN6S482C33v84Ev,
  (VTBL_ENTRY)&_ZN6S482C33v85Ev,
  (VTBL_ENTRY)&_ZN6S482C33v86Ev,
  (VTBL_ENTRY)&_ZN6S482C33v87Ev,
  (VTBL_ENTRY)&_ZN6S482C33v88Ev,
  (VTBL_ENTRY)&_ZN6S482C33v89Ev,
  (VTBL_ENTRY)&_ZN6S482C33v90Ev,
  (VTBL_ENTRY)&_ZN6S482C33v91Ev,
  (VTBL_ENTRY)&_ZN6S482C33v92Ev,
  (VTBL_ENTRY)&_ZN6S482C33v93Ev,
  (VTBL_ENTRY)&_ZN6S482C33v94Ev,
  (VTBL_ENTRY)&_ZN6S482C33v95Ev,
  (VTBL_ENTRY)&_ZN6S482C23v96Ev,
  (VTBL_ENTRY)&_ZN6S482C23v97Ev,
  (VTBL_ENTRY)&_ZN6S482C23v98Ev,
  (VTBL_ENTRY)&_ZN6S482C23v99Ev,
  (VTBL_ENTRY)&_ZN6S482C24v100Ev,
};
extern VTBL_ENTRY _ZTI6S482C2[];
extern  VTBL_ENTRY _ZTV6S482C2[];
Class_Descriptor cd_S482C2 = {  "S482C2", // class name
  bases_S482C2, 3,
  &(vtc_S482C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(264,188), // object size
  NSPAIRA(_ZTI6S482C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S482C2),93, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S482C1  : S482C2 {
  int s482c1f0;
  char s482c1f1;
  virtual  ~S482C1(); // _ZN6S482C1D1Ev
  virtual void  v1(); // _ZN6S482C12v1Ev
  virtual void  v2(); // _ZN6S482C12v2Ev
  virtual void  v3(); // _ZN6S482C12v3Ev
  virtual void  v4(); // _ZN6S482C12v4Ev
  virtual void  v5(); // _ZN6S482C12v5Ev
  virtual void  v6(); // _ZN6S482C12v6Ev
  virtual void  v7(); // _ZN6S482C12v7Ev
  virtual void  v8(); // _ZN6S482C12v8Ev
  virtual void  v9(); // _ZN6S482C12v9Ev
  virtual void  v10(); // _ZN6S482C13v10Ev
  virtual void  v11(); // _ZN6S482C13v11Ev
  S482C1(); // tgen
};
//SIG(1 S482C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79} vd v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC7{ BC8{ vd v103 v104 v105 v106 v107 Fi[8] Fp Fi Fp} v101 v102} Fi:1 Fc[3] Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 Fp} vd v96 v97 v98 v99 v100 Fi:1 Fi:1 Fi:1} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fi Fc}


 S482C1 ::~S482C1(){ note_dtor("S482C1", this);}
void  S482C1 ::v1(){vfunc_called(this, "_ZN6S482C12v1Ev");}
void  S482C1 ::v2(){vfunc_called(this, "_ZN6S482C12v2Ev");}
void  S482C1 ::v3(){vfunc_called(this, "_ZN6S482C12v3Ev");}
void  S482C1 ::v4(){vfunc_called(this, "_ZN6S482C12v4Ev");}
void  S482C1 ::v5(){vfunc_called(this, "_ZN6S482C12v5Ev");}
void  S482C1 ::v6(){vfunc_called(this, "_ZN6S482C12v6Ev");}
void  S482C1 ::v7(){vfunc_called(this, "_ZN6S482C12v7Ev");}
void  S482C1 ::v8(){vfunc_called(this, "_ZN6S482C12v8Ev");}
void  S482C1 ::v9(){vfunc_called(this, "_ZN6S482C12v9Ev");}
void  S482C1 ::v10(){vfunc_called(this, "_ZN6S482C13v10Ev");}
void  S482C1 ::v11(){vfunc_called(this, "_ZN6S482C13v11Ev");}
S482C1 ::S482C1(){ note_ctor("S482C1", this);} // tgen

static void Test_S482C1()
{
  extern Class_Descriptor cd_S482C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S482C1, buf);
    S482C1 *dp, &lv = *(dp=new (buf) S482C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S482C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S482C1)");
    check_base_class_offset(lv, (S482C5*)(S482C4*)(S482C3*)(S482C2*), 0, "S482C1");
    check_base_class_offset(lv, (S482C4*)(S482C3*)(S482C2*), 0, "S482C1");
    check_base_class_offset(lv, (S482C3*)(S482C2*), 0, "S482C1");
    check_base_class_offset(lv, (S482C2*), 0, "S482C1");
    check_field_offset(lv, s482c1f0, ABISELECT(260,188), "S482C1.s482c1f0");
    check_field_offset(lv, s482c1f1, ABISELECT(264,192), "S482C1.s482c1f1");
    test_class_info(&lv, &cd_S482C1);
    dp->~S482C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS482C1(Test_S482C1, "S482C1", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN6S482C1C1Ev();
extern void _ZN6S482C1D1Ev();
Name_Map name_map_S482C1[] = {
  NSPAIR(_ZN6S482C1C1Ev),
  NSPAIR(_ZN6S482C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S482C5;
extern VTBL_ENTRY _ZTI6S482C5[];
extern  VTBL_ENTRY _ZTV6S482C5[];
extern Class_Descriptor cd_S482C4;
extern VTBL_ENTRY _ZTI6S482C4[];
extern  VTBL_ENTRY _ZTV6S482C4[];
extern Class_Descriptor cd_S482C3;
extern VTBL_ENTRY _ZTI6S482C3[];
extern  VTBL_ENTRY _ZTV6S482C3[];
extern Class_Descriptor cd_S482C2;
extern VTBL_ENTRY _ZTI6S482C2[];
extern  VTBL_ENTRY _ZTV6S482C2[];
static Base_Class bases_S482C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S482C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S482C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S482C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S482C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S482C1[];
extern void _ZN6S482C1D1Ev();
extern void _ZN6S482C1D0Ev();
extern void _ZN6S482C53v12Ev();
extern void _ZN6S482C53v13Ev();
extern void _ZN6S482C53v14Ev();
extern void _ZN6S482C53v15Ev();
extern void _ZN6S482C53v16Ev();
extern void _ZN6S482C53v17Ev();
extern void _ZN6S482C53v18Ev();
extern void _ZN6S482C53v19Ev();
extern void _ZN6S482C53v20Ev();
extern void _ZN6S482C53v21Ev();
extern void _ZN6S482C53v22Ev();
extern void _ZN6S482C53v23Ev();
extern void _ZN6S482C53v24Ev();
extern void _ZN6S482C53v25Ev();
extern void _ZN6S482C53v26Ev();
extern void _ZN6S482C53v27Ev();
extern void _ZN6S482C53v28Ev();
extern void _ZN6S482C53v29Ev();
extern void _ZN6S482C53v30Ev();
extern void _ZN6S482C53v31Ev();
extern void _ZN6S482C53v32Ev();
extern void _ZN6S482C53v33Ev();
extern void _ZN6S482C53v34Ev();
extern void _ZN6S482C53v35Ev();
extern void _ZN6S482C53v36Ev();
extern void _ZN6S482C53v37Ev();
extern void _ZN6S482C53v38Ev();
extern void _ZN6S482C53v39Ev();
extern void _ZN6S482C53v40Ev();
extern void _ZN6S482C53v41Ev();
extern void _ZN6S482C53v42Ev();
extern void _ZN6S482C53v43Ev();
extern void _ZN6S482C53v44Ev();
extern void _ZN6S482C53v45Ev();
extern void _ZN6S482C53v46Ev();
extern void _ZN6S482C53v47Ev();
extern void _ZN6S482C53v48Ev();
extern void _ZN6S482C53v49Ev();
extern void _ZN6S482C53v50Ev();
extern void _ZN6S482C53v51Ev();
extern void _ZN6S482C53v52Ev();
extern void _ZN6S482C53v53Ev();
extern void _ZN6S482C53v54Ev();
extern void _ZN6S482C53v55Ev();
extern void _ZN6S482C53v56Ev();
extern void _ZN6S482C53v57Ev();
extern void _ZN6S482C53v58Ev();
extern void _ZN6S482C53v59Ev();
extern void _ZN6S482C53v60Ev();
extern void _ZN6S482C53v61Ev();
extern void _ZN6S482C53v62Ev();
extern void _ZN6S482C53v63Ev();
extern void _ZN6S482C53v64Ev();
extern void _ZN6S482C53v65Ev();
extern void _ZN6S482C53v66Ev();
extern void _ZN6S482C53v67Ev();
extern void _ZN6S482C53v68Ev();
extern void _ZN6S482C53v69Ev();
extern void _ZN6S482C53v70Ev();
extern void _ZN6S482C53v71Ev();
extern void _ZN6S482C53v72Ev();
extern void _ZN6S482C53v73Ev();
extern void _ZN6S482C53v74Ev();
extern void _ZN6S482C53v75Ev();
extern void _ZN6S482C43v76Ev();
extern void _ZN6S482C43v77Ev();
extern void _ZN6S482C43v78Ev();
extern void _ZN6S482C43v79Ev();
extern void _ZN6S482C33v80Ev();
extern void _ZN6S482C33v81Ev();
extern void _ZN6S482C33v82Ev();
extern void _ZN6S482C33v83Ev();
extern void _ZN6S482C33v84Ev();
extern void _ZN6S482C33v85Ev();
extern void _ZN6S482C33v86Ev();
extern void _ZN6S482C33v87Ev();
extern void _ZN6S482C33v88Ev();
extern void _ZN6S482C33v89Ev();
extern void _ZN6S482C33v90Ev();
extern void _ZN6S482C33v91Ev();
extern void _ZN6S482C33v92Ev();
extern void _ZN6S482C33v93Ev();
extern void _ZN6S482C33v94Ev();
extern void _ZN6S482C33v95Ev();
extern void _ZN6S482C23v96Ev();
extern void _ZN6S482C23v97Ev();
extern void _ZN6S482C23v98Ev();
extern void _ZN6S482C23v99Ev();
extern void _ZN6S482C24v100Ev();
extern void _ZN6S482C12v1Ev();
extern void _ZN6S482C12v2Ev();
extern void _ZN6S482C12v3Ev();
extern void _ZN6S482C12v4Ev();
extern void _ZN6S482C12v5Ev();
extern void _ZN6S482C12v6Ev();
extern void _ZN6S482C12v7Ev();
extern void _ZN6S482C12v8Ev();
extern void _ZN6S482C12v9Ev();
extern void _ZN6S482C13v10Ev();
extern void _ZN6S482C13v11Ev();
static  VTBL_ENTRY vtc_S482C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S482C1[0]),
  (VTBL_ENTRY)&_ZN6S482C1D1Ev,
  (VTBL_ENTRY)&_ZN6S482C1D0Ev,
  (VTBL_ENTRY)&_ZN6S482C53v12Ev,
  (VTBL_ENTRY)&_ZN6S482C53v13Ev,
  (VTBL_ENTRY)&_ZN6S482C53v14Ev,
  (VTBL_ENTRY)&_ZN6S482C53v15Ev,
  (VTBL_ENTRY)&_ZN6S482C53v16Ev,
  (VTBL_ENTRY)&_ZN6S482C53v17Ev,
  (VTBL_ENTRY)&_ZN6S482C53v18Ev,
  (VTBL_ENTRY)&_ZN6S482C53v19Ev,
  (VTBL_ENTRY)&_ZN6S482C53v20Ev,
  (VTBL_ENTRY)&_ZN6S482C53v21Ev,
  (VTBL_ENTRY)&_ZN6S482C53v22Ev,
  (VTBL_ENTRY)&_ZN6S482C53v23Ev,
  (VTBL_ENTRY)&_ZN6S482C53v24Ev,
  (VTBL_ENTRY)&_ZN6S482C53v25Ev,
  (VTBL_ENTRY)&_ZN6S482C53v26Ev,
  (VTBL_ENTRY)&_ZN6S482C53v27Ev,
  (VTBL_ENTRY)&_ZN6S482C53v28Ev,
  (VTBL_ENTRY)&_ZN6S482C53v29Ev,
  (VTBL_ENTRY)&_ZN6S482C53v30Ev,
  (VTBL_ENTRY)&_ZN6S482C53v31Ev,
  (VTBL_ENTRY)&_ZN6S482C53v32Ev,
  (VTBL_ENTRY)&_ZN6S482C53v33Ev,
  (VTBL_ENTRY)&_ZN6S482C53v34Ev,
  (VTBL_ENTRY)&_ZN6S482C53v35Ev,
  (VTBL_ENTRY)&_ZN6S482C53v36Ev,
  (VTBL_ENTRY)&_ZN6S482C53v37Ev,
  (VTBL_ENTRY)&_ZN6S482C53v38Ev,
  (VTBL_ENTRY)&_ZN6S482C53v39Ev,
  (VTBL_ENTRY)&_ZN6S482C53v40Ev,
  (VTBL_ENTRY)&_ZN6S482C53v41Ev,
  (VTBL_ENTRY)&_ZN6S482C53v42Ev,
  (VTBL_ENTRY)&_ZN6S482C53v43Ev,
  (VTBL_ENTRY)&_ZN6S482C53v44Ev,
  (VTBL_ENTRY)&_ZN6S482C53v45Ev,
  (VTBL_ENTRY)&_ZN6S482C53v46Ev,
  (VTBL_ENTRY)&_ZN6S482C53v47Ev,
  (VTBL_ENTRY)&_ZN6S482C53v48Ev,
  (VTBL_ENTRY)&_ZN6S482C53v49Ev,
  (VTBL_ENTRY)&_ZN6S482C53v50Ev,
  (VTBL_ENTRY)&_ZN6S482C53v51Ev,
  (VTBL_ENTRY)&_ZN6S482C53v52Ev,
  (VTBL_ENTRY)&_ZN6S482C53v53Ev,
  (VTBL_ENTRY)&_ZN6S482C53v54Ev,
  (VTBL_ENTRY)&_ZN6S482C53v55Ev,
  (VTBL_ENTRY)&_ZN6S482C53v56Ev,
  (VTBL_ENTRY)&_ZN6S482C53v57Ev,
  (VTBL_ENTRY)&_ZN6S482C53v58Ev,
  (VTBL_ENTRY)&_ZN6S482C53v59Ev,
  (VTBL_ENTRY)&_ZN6S482C53v60Ev,
  (VTBL_ENTRY)&_ZN6S482C53v61Ev,
  (VTBL_ENTRY)&_ZN6S482C53v62Ev,
  (VTBL_ENTRY)&_ZN6S482C53v63Ev,
  (VTBL_ENTRY)&_ZN6S482C53v64Ev,
  (VTBL_ENTRY)&_ZN6S482C53v65Ev,
  (VTBL_ENTRY)&_ZN6S482C53v66Ev,
  (VTBL_ENTRY)&_ZN6S482C53v67Ev,
  (VTBL_ENTRY)&_ZN6S482C53v68Ev,
  (VTBL_ENTRY)&_ZN6S482C53v69Ev,
  (VTBL_ENTRY)&_ZN6S482C53v70Ev,
  (VTBL_ENTRY)&_ZN6S482C53v71Ev,
  (VTBL_ENTRY)&_ZN6S482C53v72Ev,
  (VTBL_ENTRY)&_ZN6S482C53v73Ev,
  (VTBL_ENTRY)&_ZN6S482C53v74Ev,
  (VTBL_ENTRY)&_ZN6S482C53v75Ev,
  (VTBL_ENTRY)&_ZN6S482C43v76Ev,
  (VTBL_ENTRY)&_ZN6S482C43v77Ev,
  (VTBL_ENTRY)&_ZN6S482C43v78Ev,
  (VTBL_ENTRY)&_ZN6S482C43v79Ev,
  (VTBL_ENTRY)&_ZN6S482C33v80Ev,
  (VTBL_ENTRY)&_ZN6S482C33v81Ev,
  (VTBL_ENTRY)&_ZN6S482C33v82Ev,
  (VTBL_ENTRY)&_ZN6S482C33v83Ev,
  (VTBL_ENTRY)&_ZN6S482C33v84Ev,
  (VTBL_ENTRY)&_ZN6S482C33v85Ev,
  (VTBL_ENTRY)&_ZN6S482C33v86Ev,
  (VTBL_ENTRY)&_ZN6S482C33v87Ev,
  (VTBL_ENTRY)&_ZN6S482C33v88Ev,
  (VTBL_ENTRY)&_ZN6S482C33v89Ev,
  (VTBL_ENTRY)&_ZN6S482C33v90Ev,
  (VTBL_ENTRY)&_ZN6S482C33v91Ev,
  (VTBL_ENTRY)&_ZN6S482C33v92Ev,
  (VTBL_ENTRY)&_ZN6S482C33v93Ev,
  (VTBL_ENTRY)&_ZN6S482C33v94Ev,
  (VTBL_ENTRY)&_ZN6S482C33v95Ev,
  (VTBL_ENTRY)&_ZN6S482C23v96Ev,
  (VTBL_ENTRY)&_ZN6S482C23v97Ev,
  (VTBL_ENTRY)&_ZN6S482C23v98Ev,
  (VTBL_ENTRY)&_ZN6S482C23v99Ev,
  (VTBL_ENTRY)&_ZN6S482C24v100Ev,
  (VTBL_ENTRY)&_ZN6S482C12v1Ev,
  (VTBL_ENTRY)&_ZN6S482C12v2Ev,
  (VTBL_ENTRY)&_ZN6S482C12v3Ev,
  (VTBL_ENTRY)&_ZN6S482C12v4Ev,
  (VTBL_ENTRY)&_ZN6S482C12v5Ev,
  (VTBL_ENTRY)&_ZN6S482C12v6Ev,
  (VTBL_ENTRY)&_ZN6S482C12v7Ev,
  (VTBL_ENTRY)&_ZN6S482C12v8Ev,
  (VTBL_ENTRY)&_ZN6S482C12v9Ev,
  (VTBL_ENTRY)&_ZN6S482C13v10Ev,
  (VTBL_ENTRY)&_ZN6S482C13v11Ev,
};
extern VTBL_ENTRY _ZTI6S482C1[];
extern  VTBL_ENTRY _ZTV6S482C1[];
Class_Descriptor cd_S482C1 = {  "S482C1", // class name
  bases_S482C1, 4,
  &(vtc_S482C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI6S482C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S482C1),104, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1309C4  {
  int s1309c4f0;
  __tsi64 s1309c4f1;
  void *s1309c4f2[4];
  int s1309c4f3[2];
  void *s1309c4f4;
  ::S695C22_nt s1309c4f5;
  void *s1309c4f6[2];
  virtual  ~S1309C4(); // _ZN7S1309C4D1Ev
  virtual void  v12(); // _ZN7S1309C43v12Ev
  virtual void  v13(); // _ZN7S1309C43v13Ev
  virtual void  v14(); // _ZN7S1309C43v14Ev
  virtual void  v15(); // _ZN7S1309C43v15Ev
  virtual void  v16(); // _ZN7S1309C43v16Ev
  virtual void  v17(); // _ZN7S1309C43v17Ev
  virtual void  v18(); // _ZN7S1309C43v18Ev
  virtual void  v19(); // _ZN7S1309C43v19Ev
  virtual void  v20(); // _ZN7S1309C43v20Ev
  virtual void  v21(); // _ZN7S1309C43v21Ev
  virtual void  v22(); // _ZN7S1309C43v22Ev
  virtual void  v23(); // _ZN7S1309C43v23Ev
  virtual void  v24(); // _ZN7S1309C43v24Ev
  virtual void  v25(); // _ZN7S1309C43v25Ev
  virtual void  v26(); // _ZN7S1309C43v26Ev
  virtual void  v27(); // _ZN7S1309C43v27Ev
  virtual void  v28(); // _ZN7S1309C43v28Ev
  virtual void  v29(); // _ZN7S1309C43v29Ev
  virtual void  v30(); // _ZN7S1309C43v30Ev
  virtual void  v31(); // _ZN7S1309C43v31Ev
  virtual void  v32(); // _ZN7S1309C43v32Ev
  virtual void  v33(); // _ZN7S1309C43v33Ev
  virtual void  v34(); // _ZN7S1309C43v34Ev
  virtual void  v35(); // _ZN7S1309C43v35Ev
  virtual void  v36(); // _ZN7S1309C43v36Ev
  virtual void  v37(); // _ZN7S1309C43v37Ev
  virtual void  v38(); // _ZN7S1309C43v38Ev
  virtual void  v39(); // _ZN7S1309C43v39Ev
  virtual void  v40(); // _ZN7S1309C43v40Ev
  virtual void  v41(); // _ZN7S1309C43v41Ev
  virtual void  v42(); // _ZN7S1309C43v42Ev
  virtual void  v43(); // _ZN7S1309C43v43Ev
  virtual void  v44(); // _ZN7S1309C43v44Ev
  virtual void  v45(); // _ZN7S1309C43v45Ev
  virtual void  v46(); // _ZN7S1309C43v46Ev
  virtual void  v47(); // _ZN7S1309C43v47Ev
  virtual void  v48(); // _ZN7S1309C43v48Ev
  virtual void  v49(); // _ZN7S1309C43v49Ev
  virtual void  v50(); // _ZN7S1309C43v50Ev
  virtual void  v51(); // _ZN7S1309C43v51Ev
  virtual void  v52(); // _ZN7S1309C43v52Ev
  virtual void  v53(); // _ZN7S1309C43v53Ev
  virtual void  v54(); // _ZN7S1309C43v54Ev
  virtual void  v55(); // _ZN7S1309C43v55Ev
  virtual void  v56(); // _ZN7S1309C43v56Ev
  virtual void  v57(); // _ZN7S1309C43v57Ev
  virtual void  v58(); // _ZN7S1309C43v58Ev
  virtual void  v59(); // _ZN7S1309C43v59Ev
  virtual void  v60(); // _ZN7S1309C43v60Ev
  virtual void  v61(); // _ZN7S1309C43v61Ev
  virtual void  v62(); // _ZN7S1309C43v62Ev
  virtual void  v63(); // _ZN7S1309C43v63Ev
  virtual void  v64(); // _ZN7S1309C43v64Ev
  virtual void  v65(); // _ZN7S1309C43v65Ev
  virtual void  v66(); // _ZN7S1309C43v66Ev
  virtual void  v67(); // _ZN7S1309C43v67Ev
  virtual void  v68(); // _ZN7S1309C43v68Ev
  virtual void  v69(); // _ZN7S1309C43v69Ev
  virtual void  v70(); // _ZN7S1309C43v70Ev
  virtual void  v71(); // _ZN7S1309C43v71Ev
  virtual void  v72(); // _ZN7S1309C43v72Ev
  virtual void  v73(); // _ZN7S1309C43v73Ev
  virtual void  v74(); // _ZN7S1309C43v74Ev
  virtual void  v75(); // _ZN7S1309C43v75Ev
  S1309C4(); // tgen
};
//SIG(-1 S1309C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1309C4 ::~S1309C4(){ note_dtor("S1309C4", this);}
void  S1309C4 ::v12(){vfunc_called(this, "_ZN7S1309C43v12Ev");}
void  S1309C4 ::v13(){vfunc_called(this, "_ZN7S1309C43v13Ev");}
void  S1309C4 ::v14(){vfunc_called(this, "_ZN7S1309C43v14Ev");}
void  S1309C4 ::v15(){vfunc_called(this, "_ZN7S1309C43v15Ev");}
void  S1309C4 ::v16(){vfunc_called(this, "_ZN7S1309C43v16Ev");}
void  S1309C4 ::v17(){vfunc_called(this, "_ZN7S1309C43v17Ev");}
void  S1309C4 ::v18(){vfunc_called(this, "_ZN7S1309C43v18Ev");}
void  S1309C4 ::v19(){vfunc_called(this, "_ZN7S1309C43v19Ev");}
void  S1309C4 ::v20(){vfunc_called(this, "_ZN7S1309C43v20Ev");}
void  S1309C4 ::v21(){vfunc_called(this, "_ZN7S1309C43v21Ev");}
void  S1309C4 ::v22(){vfunc_called(this, "_ZN7S1309C43v22Ev");}
void  S1309C4 ::v23(){vfunc_called(this, "_ZN7S1309C43v23Ev");}
void  S1309C4 ::v24(){vfunc_called(this, "_ZN7S1309C43v24Ev");}
void  S1309C4 ::v25(){vfunc_called(this, "_ZN7S1309C43v25Ev");}
void  S1309C4 ::v26(){vfunc_called(this, "_ZN7S1309C43v26Ev");}
void  S1309C4 ::v27(){vfunc_called(this, "_ZN7S1309C43v27Ev");}
void  S1309C4 ::v28(){vfunc_called(this, "_ZN7S1309C43v28Ev");}
void  S1309C4 ::v29(){vfunc_called(this, "_ZN7S1309C43v29Ev");}
void  S1309C4 ::v30(){vfunc_called(this, "_ZN7S1309C43v30Ev");}
void  S1309C4 ::v31(){vfunc_called(this, "_ZN7S1309C43v31Ev");}
void  S1309C4 ::v32(){vfunc_called(this, "_ZN7S1309C43v32Ev");}
void  S1309C4 ::v33(){vfunc_called(this, "_ZN7S1309C43v33Ev");}
void  S1309C4 ::v34(){vfunc_called(this, "_ZN7S1309C43v34Ev");}
void  S1309C4 ::v35(){vfunc_called(this, "_ZN7S1309C43v35Ev");}
void  S1309C4 ::v36(){vfunc_called(this, "_ZN7S1309C43v36Ev");}
void  S1309C4 ::v37(){vfunc_called(this, "_ZN7S1309C43v37Ev");}
void  S1309C4 ::v38(){vfunc_called(this, "_ZN7S1309C43v38Ev");}
void  S1309C4 ::v39(){vfunc_called(this, "_ZN7S1309C43v39Ev");}
void  S1309C4 ::v40(){vfunc_called(this, "_ZN7S1309C43v40Ev");}
void  S1309C4 ::v41(){vfunc_called(this, "_ZN7S1309C43v41Ev");}
void  S1309C4 ::v42(){vfunc_called(this, "_ZN7S1309C43v42Ev");}
void  S1309C4 ::v43(){vfunc_called(this, "_ZN7S1309C43v43Ev");}
void  S1309C4 ::v44(){vfunc_called(this, "_ZN7S1309C43v44Ev");}
void  S1309C4 ::v45(){vfunc_called(this, "_ZN7S1309C43v45Ev");}
void  S1309C4 ::v46(){vfunc_called(this, "_ZN7S1309C43v46Ev");}
void  S1309C4 ::v47(){vfunc_called(this, "_ZN7S1309C43v47Ev");}
void  S1309C4 ::v48(){vfunc_called(this, "_ZN7S1309C43v48Ev");}
void  S1309C4 ::v49(){vfunc_called(this, "_ZN7S1309C43v49Ev");}
void  S1309C4 ::v50(){vfunc_called(this, "_ZN7S1309C43v50Ev");}
void  S1309C4 ::v51(){vfunc_called(this, "_ZN7S1309C43v51Ev");}
void  S1309C4 ::v52(){vfunc_called(this, "_ZN7S1309C43v52Ev");}
void  S1309C4 ::v53(){vfunc_called(this, "_ZN7S1309C43v53Ev");}
void  S1309C4 ::v54(){vfunc_called(this, "_ZN7S1309C43v54Ev");}
void  S1309C4 ::v55(){vfunc_called(this, "_ZN7S1309C43v55Ev");}
void  S1309C4 ::v56(){vfunc_called(this, "_ZN7S1309C43v56Ev");}
void  S1309C4 ::v57(){vfunc_called(this, "_ZN7S1309C43v57Ev");}
void  S1309C4 ::v58(){vfunc_called(this, "_ZN7S1309C43v58Ev");}
void  S1309C4 ::v59(){vfunc_called(this, "_ZN7S1309C43v59Ev");}
void  S1309C4 ::v60(){vfunc_called(this, "_ZN7S1309C43v60Ev");}
void  S1309C4 ::v61(){vfunc_called(this, "_ZN7S1309C43v61Ev");}
void  S1309C4 ::v62(){vfunc_called(this, "_ZN7S1309C43v62Ev");}
void  S1309C4 ::v63(){vfunc_called(this, "_ZN7S1309C43v63Ev");}
void  S1309C4 ::v64(){vfunc_called(this, "_ZN7S1309C43v64Ev");}
void  S1309C4 ::v65(){vfunc_called(this, "_ZN7S1309C43v65Ev");}
void  S1309C4 ::v66(){vfunc_called(this, "_ZN7S1309C43v66Ev");}
void  S1309C4 ::v67(){vfunc_called(this, "_ZN7S1309C43v67Ev");}
void  S1309C4 ::v68(){vfunc_called(this, "_ZN7S1309C43v68Ev");}
void  S1309C4 ::v69(){vfunc_called(this, "_ZN7S1309C43v69Ev");}
void  S1309C4 ::v70(){vfunc_called(this, "_ZN7S1309C43v70Ev");}
void  S1309C4 ::v71(){vfunc_called(this, "_ZN7S1309C43v71Ev");}
void  S1309C4 ::v72(){vfunc_called(this, "_ZN7S1309C43v72Ev");}
void  S1309C4 ::v73(){vfunc_called(this, "_ZN7S1309C43v73Ev");}
void  S1309C4 ::v74(){vfunc_called(this, "_ZN7S1309C43v74Ev");}
void  S1309C4 ::v75(){vfunc_called(this, "_ZN7S1309C43v75Ev");}
S1309C4 ::S1309C4(){ note_ctor("S1309C4", this);} // tgen

static void Test_S1309C4()
{
  extern Class_Descriptor cd_S1309C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1309C4, buf);
    S1309C4 *dp, &lv = *(dp=new (buf) S1309C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1309C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1309C4)");
    check_field_offset(lv, s1309c4f0, ABISELECT(8,4), "S1309C4.s1309c4f0");
    check_field_offset(lv, s1309c4f1, ABISELECT(16,8), "S1309C4.s1309c4f1");
    check_field_offset(lv, s1309c4f2, ABISELECT(24,16), "S1309C4.s1309c4f2");
    check_field_offset(lv, s1309c4f3, ABISELECT(56,32), "S1309C4.s1309c4f3");
    check_field_offset(lv, s1309c4f4, ABISELECT(64,40), "S1309C4.s1309c4f4");
    check_field_offset(lv, s1309c4f5, ABISELECT(72,44), "S1309C4.s1309c4f5");
    check_field_offset(lv, s1309c4f6, ABISELECT(80,52), "S1309C4.s1309c4f6");
    test_class_info(&lv, &cd_S1309C4);
    dp->~S1309C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1309C4(Test_S1309C4, "S1309C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1309C4C1Ev();
extern void _ZN7S1309C4D1Ev();
Name_Map name_map_S1309C4[] = {
  NSPAIR(_ZN7S1309C4C1Ev),
  NSPAIR(_ZN7S1309C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1309C4[];
extern void _ZN7S1309C4D1Ev();
extern void _ZN7S1309C4D0Ev();
extern void _ZN7S1309C43v12Ev();
extern void _ZN7S1309C43v13Ev();
extern void _ZN7S1309C43v14Ev();
extern void _ZN7S1309C43v15Ev();
extern void _ZN7S1309C43v16Ev();
extern void _ZN7S1309C43v17Ev();
extern void _ZN7S1309C43v18Ev();
extern void _ZN7S1309C43v19Ev();
extern void _ZN7S1309C43v20Ev();
extern void _ZN7S1309C43v21Ev();
extern void _ZN7S1309C43v22Ev();
extern void _ZN7S1309C43v23Ev();
extern void _ZN7S1309C43v24Ev();
extern void _ZN7S1309C43v25Ev();
extern void _ZN7S1309C43v26Ev();
extern void _ZN7S1309C43v27Ev();
extern void _ZN7S1309C43v28Ev();
extern void _ZN7S1309C43v29Ev();
extern void _ZN7S1309C43v30Ev();
extern void _ZN7S1309C43v31Ev();
extern void _ZN7S1309C43v32Ev();
extern void _ZN7S1309C43v33Ev();
extern void _ZN7S1309C43v34Ev();
extern void _ZN7S1309C43v35Ev();
extern void _ZN7S1309C43v36Ev();
extern void _ZN7S1309C43v37Ev();
extern void _ZN7S1309C43v38Ev();
extern void _ZN7S1309C43v39Ev();
extern void _ZN7S1309C43v40Ev();
extern void _ZN7S1309C43v41Ev();
extern void _ZN7S1309C43v42Ev();
extern void _ZN7S1309C43v43Ev();
extern void _ZN7S1309C43v44Ev();
extern void _ZN7S1309C43v45Ev();
extern void _ZN7S1309C43v46Ev();
extern void _ZN7S1309C43v47Ev();
extern void _ZN7S1309C43v48Ev();
extern void _ZN7S1309C43v49Ev();
extern void _ZN7S1309C43v50Ev();
extern void _ZN7S1309C43v51Ev();
extern void _ZN7S1309C43v52Ev();
extern void _ZN7S1309C43v53Ev();
extern void _ZN7S1309C43v54Ev();
extern void _ZN7S1309C43v55Ev();
extern void _ZN7S1309C43v56Ev();
extern void _ZN7S1309C43v57Ev();
extern void _ZN7S1309C43v58Ev();
extern void _ZN7S1309C43v59Ev();
extern void _ZN7S1309C43v60Ev();
extern void _ZN7S1309C43v61Ev();
extern void _ZN7S1309C43v62Ev();
extern void _ZN7S1309C43v63Ev();
extern void _ZN7S1309C43v64Ev();
extern void _ZN7S1309C43v65Ev();
extern void _ZN7S1309C43v66Ev();
extern void _ZN7S1309C43v67Ev();
extern void _ZN7S1309C43v68Ev();
extern void _ZN7S1309C43v69Ev();
extern void _ZN7S1309C43v70Ev();
extern void _ZN7S1309C43v71Ev();
extern void _ZN7S1309C43v72Ev();
extern void _ZN7S1309C43v73Ev();
extern void _ZN7S1309C43v74Ev();
extern void _ZN7S1309C43v75Ev();
static  VTBL_ENTRY vtc_S1309C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1309C4[0]),
  (VTBL_ENTRY)&_ZN7S1309C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1309C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v75Ev,
};
extern VTBL_ENTRY _ZTI7S1309C4[];
extern  VTBL_ENTRY _ZTV7S1309C4[];
Class_Descriptor cd_S1309C4 = {  "S1309C4", // class name
  0,0,//no base classes
  &(vtc_S1309C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1309C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1309C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1309C3  : S1309C4 {
  virtual  ~S1309C3(); // _ZN7S1309C3D1Ev
  virtual void  v76(); // _ZN7S1309C33v76Ev
  virtual void  v77(); // _ZN7S1309C33v77Ev
  virtual void  v78(); // _ZN7S1309C33v78Ev
  virtual void  v79(); // _ZN7S1309C33v79Ev
  S1309C3(); // tgen
};
//SIG(-1 S1309C3) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S1309C3 ::~S1309C3(){ note_dtor("S1309C3", this);}
void  S1309C3 ::v76(){vfunc_called(this, "_ZN7S1309C33v76Ev");}
void  S1309C3 ::v77(){vfunc_called(this, "_ZN7S1309C33v77Ev");}
void  S1309C3 ::v78(){vfunc_called(this, "_ZN7S1309C33v78Ev");}
void  S1309C3 ::v79(){vfunc_called(this, "_ZN7S1309C33v79Ev");}
S1309C3 ::S1309C3(){ note_ctor("S1309C3", this);} // tgen

static void Test_S1309C3()
{
  extern Class_Descriptor cd_S1309C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1309C3, buf);
    S1309C3 *dp, &lv = *(dp=new (buf) S1309C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1309C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1309C3)");
    check_base_class_offset(lv, (S1309C4*), 0, "S1309C3");
    test_class_info(&lv, &cd_S1309C3);
    dp->~S1309C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1309C3(Test_S1309C3, "S1309C3", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1309C3C1Ev();
extern void _ZN7S1309C3D1Ev();
Name_Map name_map_S1309C3[] = {
  NSPAIR(_ZN7S1309C3C1Ev),
  NSPAIR(_ZN7S1309C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1309C4;
extern VTBL_ENTRY _ZTI7S1309C4[];
extern  VTBL_ENTRY _ZTV7S1309C4[];
static Base_Class bases_S1309C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1309C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1309C3[];
extern void _ZN7S1309C3D1Ev();
extern void _ZN7S1309C3D0Ev();
extern void _ZN7S1309C43v12Ev();
extern void _ZN7S1309C43v13Ev();
extern void _ZN7S1309C43v14Ev();
extern void _ZN7S1309C43v15Ev();
extern void _ZN7S1309C43v16Ev();
extern void _ZN7S1309C43v17Ev();
extern void _ZN7S1309C43v18Ev();
extern void _ZN7S1309C43v19Ev();
extern void _ZN7S1309C43v20Ev();
extern void _ZN7S1309C43v21Ev();
extern void _ZN7S1309C43v22Ev();
extern void _ZN7S1309C43v23Ev();
extern void _ZN7S1309C43v24Ev();
extern void _ZN7S1309C43v25Ev();
extern void _ZN7S1309C43v26Ev();
extern void _ZN7S1309C43v27Ev();
extern void _ZN7S1309C43v28Ev();
extern void _ZN7S1309C43v29Ev();
extern void _ZN7S1309C43v30Ev();
extern void _ZN7S1309C43v31Ev();
extern void _ZN7S1309C43v32Ev();
extern void _ZN7S1309C43v33Ev();
extern void _ZN7S1309C43v34Ev();
extern void _ZN7S1309C43v35Ev();
extern void _ZN7S1309C43v36Ev();
extern void _ZN7S1309C43v37Ev();
extern void _ZN7S1309C43v38Ev();
extern void _ZN7S1309C43v39Ev();
extern void _ZN7S1309C43v40Ev();
extern void _ZN7S1309C43v41Ev();
extern void _ZN7S1309C43v42Ev();
extern void _ZN7S1309C43v43Ev();
extern void _ZN7S1309C43v44Ev();
extern void _ZN7S1309C43v45Ev();
extern void _ZN7S1309C43v46Ev();
extern void _ZN7S1309C43v47Ev();
extern void _ZN7S1309C43v48Ev();
extern void _ZN7S1309C43v49Ev();
extern void _ZN7S1309C43v50Ev();
extern void _ZN7S1309C43v51Ev();
extern void _ZN7S1309C43v52Ev();
extern void _ZN7S1309C43v53Ev();
extern void _ZN7S1309C43v54Ev();
extern void _ZN7S1309C43v55Ev();
extern void _ZN7S1309C43v56Ev();
extern void _ZN7S1309C43v57Ev();
extern void _ZN7S1309C43v58Ev();
extern void _ZN7S1309C43v59Ev();
extern void _ZN7S1309C43v60Ev();
extern void _ZN7S1309C43v61Ev();
extern void _ZN7S1309C43v62Ev();
extern void _ZN7S1309C43v63Ev();
extern void _ZN7S1309C43v64Ev();
extern void _ZN7S1309C43v65Ev();
extern void _ZN7S1309C43v66Ev();
extern void _ZN7S1309C43v67Ev();
extern void _ZN7S1309C43v68Ev();
extern void _ZN7S1309C43v69Ev();
extern void _ZN7S1309C43v70Ev();
extern void _ZN7S1309C43v71Ev();
extern void _ZN7S1309C43v72Ev();
extern void _ZN7S1309C43v73Ev();
extern void _ZN7S1309C43v74Ev();
extern void _ZN7S1309C43v75Ev();
extern void _ZN7S1309C33v76Ev();
extern void _ZN7S1309C33v77Ev();
extern void _ZN7S1309C33v78Ev();
extern void _ZN7S1309C33v79Ev();
static  VTBL_ENTRY vtc_S1309C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1309C3[0]),
  (VTBL_ENTRY)&_ZN7S1309C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1309C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v79Ev,
};
extern VTBL_ENTRY _ZTI7S1309C3[];
extern  VTBL_ENTRY _ZTV7S1309C3[];
Class_Descriptor cd_S1309C3 = {  "S1309C3", // class name
  bases_S1309C3, 1,
  &(vtc_S1309C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1309C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1309C3),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1309C2  : S1309C3 {
  unsigned int s1309c2f0:1;
  unsigned int s1309c2f1:1;
  unsigned int s1309c2f2:1;
  unsigned int s1309c2f3:1;
  unsigned int s1309c2f4:1;
  unsigned int s1309c2f5:1;
  unsigned int s1309c2f6:1;
  unsigned int s1309c2f7:1;
  unsigned int s1309c2f8:1;
  unsigned int s1309c2f9:1;
  unsigned int s1309c2f10:1;
  unsigned int s1309c2f11:1;
  unsigned int s1309c2f12:1;
  int s1309c2f13[8];
  ::S507C7 s1309c2f14;
  unsigned int s1309c2f15:1;
  char s1309c2f16;
  char s1309c2f17[2];
  int s1309c2f18[2];
  ::S685C27_nt s1309c2f19;
  ::S685C27_nt s1309c2f20;
  void *s1309c2f21;
  virtual  ~S1309C2(); // _ZN7S1309C2D1Ev
  virtual void  v80(); // _ZN7S1309C23v80Ev
  virtual void  v81(); // _ZN7S1309C23v81Ev
  virtual void  v82(); // _ZN7S1309C23v82Ev
  virtual void  v83(); // _ZN7S1309C23v83Ev
  virtual void  v84(); // _ZN7S1309C23v84Ev
  virtual void  v85(); // _ZN7S1309C23v85Ev
  virtual void  v86(); // _ZN7S1309C23v86Ev
  virtual void  v87(); // _ZN7S1309C23v87Ev
  virtual void  v88(); // _ZN7S1309C23v88Ev
  virtual void  v89(); // _ZN7S1309C23v89Ev
  virtual void  v90(); // _ZN7S1309C23v90Ev
  virtual void  v91(); // _ZN7S1309C23v91Ev
  virtual void  v92(); // _ZN7S1309C23v92Ev
  virtual void  v93(); // _ZN7S1309C23v93Ev
  virtual void  v94(); // _ZN7S1309C23v94Ev
  virtual void  v95(); // _ZN7S1309C23v95Ev
  S1309C2(); // tgen
};
//SIG(-1 S1309C2) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC5{ BC6{ vd v87 v88 v89 v90 v91 Fi[8] Fp Fi Fp} v85 v86} Fi:1 Fc[3] Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 Fp}


 S1309C2 ::~S1309C2(){ note_dtor("S1309C2", this);}
void  S1309C2 ::v80(){vfunc_called(this, "_ZN7S1309C23v80Ev");}
void  S1309C2 ::v81(){vfunc_called(this, "_ZN7S1309C23v81Ev");}
void  S1309C2 ::v82(){vfunc_called(this, "_ZN7S1309C23v82Ev");}
void  S1309C2 ::v83(){vfunc_called(this, "_ZN7S1309C23v83Ev");}
void  S1309C2 ::v84(){vfunc_called(this, "_ZN7S1309C23v84Ev");}
void  S1309C2 ::v85(){vfunc_called(this, "_ZN7S1309C23v85Ev");}
void  S1309C2 ::v86(){vfunc_called(this, "_ZN7S1309C23v86Ev");}
void  S1309C2 ::v87(){vfunc_called(this, "_ZN7S1309C23v87Ev");}
void  S1309C2 ::v88(){vfunc_called(this, "_ZN7S1309C23v88Ev");}
void  S1309C2 ::v89(){vfunc_called(this, "_ZN7S1309C23v89Ev");}
void  S1309C2 ::v90(){vfunc_called(this, "_ZN7S1309C23v90Ev");}
void  S1309C2 ::v91(){vfunc_called(this, "_ZN7S1309C23v91Ev");}
void  S1309C2 ::v92(){vfunc_called(this, "_ZN7S1309C23v92Ev");}
void  S1309C2 ::v93(){vfunc_called(this, "_ZN7S1309C23v93Ev");}
void  S1309C2 ::v94(){vfunc_called(this, "_ZN7S1309C23v94Ev");}
void  S1309C2 ::v95(){vfunc_called(this, "_ZN7S1309C23v95Ev");}
S1309C2 ::S1309C2(){ note_ctor("S1309C2", this);} // tgen

static void Test_S1309C2()
{
  extern Class_Descriptor cd_S1309C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,47)];
    init_test(&cd_S1309C2, buf);
    S1309C2 *dp, &lv = *(dp=new (buf) S1309C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,184), "sizeof(S1309C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1309C2)");
    check_base_class_offset(lv, (S1309C4*)(S1309C3*), 0, "S1309C2");
    check_base_class_offset(lv, (S1309C3*), 0, "S1309C2");
    set_bf_and_test(lv, s1309c2f0, ABISELECT(96,60), 0, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f1, ABISELECT(96,60), 1, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f2, ABISELECT(96,60), 2, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f3, ABISELECT(96,60), 3, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f4, ABISELECT(96,60), 4, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f5, ABISELECT(96,60), 5, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f6, ABISELECT(96,60), 6, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f7, ABISELECT(96,60), 7, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f8, ABISELECT(97,61), 0, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f9, ABISELECT(97,61), 1, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f10, ABISELECT(97,61), 2, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f11, ABISELECT(97,61), 3, 1, 1, "S1309C2");
    set_bf_and_test(lv, s1309c2f12, ABISELECT(97,61), 4, 1, 1, "S1309C2");
    check_field_offset(lv, s1309c2f13, ABISELECT(100,64), "S1309C2.s1309c2f13");
    check_field_offset(lv, s1309c2f14, ABISELECT(136,96), "S1309C2.s1309c2f14");
    set_bf_and_test(lv, s1309c2f15, ABISELECT(200,144), 0, 1, 1, "S1309C2");
    check_field_offset(lv, s1309c2f16, ABISELECT(201,145), "S1309C2.s1309c2f16");
    check_field_offset(lv, s1309c2f17, ABISELECT(202,146), "S1309C2.s1309c2f17");
    check_field_offset(lv, s1309c2f18, ABISELECT(204,148), "S1309C2.s1309c2f18");
    check_field_offset(lv, s1309c2f19, ABISELECT(216,156), "S1309C2.s1309c2f19");
    check_field_offset(lv, s1309c2f20, ABISELECT(232,168), "S1309C2.s1309c2f20");
    check_field_offset(lv, s1309c2f21, ABISELECT(248,180), "S1309C2.s1309c2f21");
    test_class_info(&lv, &cd_S1309C2);
    dp->~S1309C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1309C2(Test_S1309C2, "S1309C2", ABISELECT(256,184));

#else // __cplusplus

extern void _ZN7S1309C2C1Ev();
extern void _ZN7S1309C2D1Ev();
Name_Map name_map_S1309C2[] = {
  NSPAIR(_ZN7S1309C2C1Ev),
  NSPAIR(_ZN7S1309C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1309C4;
extern VTBL_ENTRY _ZTI7S1309C4[];
extern  VTBL_ENTRY _ZTV7S1309C4[];
extern Class_Descriptor cd_S1309C3;
extern VTBL_ENTRY _ZTI7S1309C3[];
extern  VTBL_ENTRY _ZTV7S1309C3[];
static Base_Class bases_S1309C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1309C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1309C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1309C2[];
extern void _ZN7S1309C2D1Ev();
extern void _ZN7S1309C2D0Ev();
extern void _ZN7S1309C43v12Ev();
extern void _ZN7S1309C43v13Ev();
extern void _ZN7S1309C43v14Ev();
extern void _ZN7S1309C43v15Ev();
extern void _ZN7S1309C43v16Ev();
extern void _ZN7S1309C43v17Ev();
extern void _ZN7S1309C43v18Ev();
extern void _ZN7S1309C43v19Ev();
extern void _ZN7S1309C43v20Ev();
extern void _ZN7S1309C43v21Ev();
extern void _ZN7S1309C43v22Ev();
extern void _ZN7S1309C43v23Ev();
extern void _ZN7S1309C43v24Ev();
extern void _ZN7S1309C43v25Ev();
extern void _ZN7S1309C43v26Ev();
extern void _ZN7S1309C43v27Ev();
extern void _ZN7S1309C43v28Ev();
extern void _ZN7S1309C43v29Ev();
extern void _ZN7S1309C43v30Ev();
extern void _ZN7S1309C43v31Ev();
extern void _ZN7S1309C43v32Ev();
extern void _ZN7S1309C43v33Ev();
extern void _ZN7S1309C43v34Ev();
extern void _ZN7S1309C43v35Ev();
extern void _ZN7S1309C43v36Ev();
extern void _ZN7S1309C43v37Ev();
extern void _ZN7S1309C43v38Ev();
extern void _ZN7S1309C43v39Ev();
extern void _ZN7S1309C43v40Ev();
extern void _ZN7S1309C43v41Ev();
extern void _ZN7S1309C43v42Ev();
extern void _ZN7S1309C43v43Ev();
extern void _ZN7S1309C43v44Ev();
extern void _ZN7S1309C43v45Ev();
extern void _ZN7S1309C43v46Ev();
extern void _ZN7S1309C43v47Ev();
extern void _ZN7S1309C43v48Ev();
extern void _ZN7S1309C43v49Ev();
extern void _ZN7S1309C43v50Ev();
extern void _ZN7S1309C43v51Ev();
extern void _ZN7S1309C43v52Ev();
extern void _ZN7S1309C43v53Ev();
extern void _ZN7S1309C43v54Ev();
extern void _ZN7S1309C43v55Ev();
extern void _ZN7S1309C43v56Ev();
extern void _ZN7S1309C43v57Ev();
extern void _ZN7S1309C43v58Ev();
extern void _ZN7S1309C43v59Ev();
extern void _ZN7S1309C43v60Ev();
extern void _ZN7S1309C43v61Ev();
extern void _ZN7S1309C43v62Ev();
extern void _ZN7S1309C43v63Ev();
extern void _ZN7S1309C43v64Ev();
extern void _ZN7S1309C43v65Ev();
extern void _ZN7S1309C43v66Ev();
extern void _ZN7S1309C43v67Ev();
extern void _ZN7S1309C43v68Ev();
extern void _ZN7S1309C43v69Ev();
extern void _ZN7S1309C43v70Ev();
extern void _ZN7S1309C43v71Ev();
extern void _ZN7S1309C43v72Ev();
extern void _ZN7S1309C43v73Ev();
extern void _ZN7S1309C43v74Ev();
extern void _ZN7S1309C43v75Ev();
extern void _ZN7S1309C33v76Ev();
extern void _ZN7S1309C33v77Ev();
extern void _ZN7S1309C33v78Ev();
extern void _ZN7S1309C33v79Ev();
extern void _ZN7S1309C23v80Ev();
extern void _ZN7S1309C23v81Ev();
extern void _ZN7S1309C23v82Ev();
extern void _ZN7S1309C23v83Ev();
extern void _ZN7S1309C23v84Ev();
extern void _ZN7S1309C23v85Ev();
extern void _ZN7S1309C23v86Ev();
extern void _ZN7S1309C23v87Ev();
extern void _ZN7S1309C23v88Ev();
extern void _ZN7S1309C23v89Ev();
extern void _ZN7S1309C23v90Ev();
extern void _ZN7S1309C23v91Ev();
extern void _ZN7S1309C23v92Ev();
extern void _ZN7S1309C23v93Ev();
extern void _ZN7S1309C23v94Ev();
extern void _ZN7S1309C23v95Ev();
static  VTBL_ENTRY vtc_S1309C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1309C2[0]),
  (VTBL_ENTRY)&_ZN7S1309C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1309C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v80Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v95Ev,
};
extern VTBL_ENTRY _ZTI7S1309C2[];
extern  VTBL_ENTRY _ZTV7S1309C2[];
Class_Descriptor cd_S1309C2 = {  "S1309C2", // class name
  bases_S1309C2, 2,
  &(vtc_S1309C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,184), // object size
  NSPAIRA(_ZTI7S1309C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1309C2),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1309C1  : S1309C2 {
  int s1309c1f0[2];
  char s1309c1f1;
  int s1309c1f2;
  unsigned int s1309c1f3:1;
  void *s1309c1f4[6];
  virtual  ~S1309C1(); // _ZN7S1309C1D1Ev
  virtual void  v1(); // _ZN7S1309C12v1Ev
  virtual void  v2(); // _ZN7S1309C12v2Ev
  virtual void  v3(); // _ZN7S1309C12v3Ev
  virtual void  v4(); // _ZN7S1309C12v4Ev
  virtual void  v5(); // _ZN7S1309C12v5Ev
  virtual void  v6(); // _ZN7S1309C12v6Ev
  virtual void  v7(); // _ZN7S1309C12v7Ev
  virtual void  v8(); // _ZN7S1309C12v8Ev
  virtual void  v9(); // _ZN7S1309C12v9Ev
  virtual void  v10(); // _ZN7S1309C13v10Ev
  virtual void  v11(); // _ZN7S1309C13v11Ev
  S1309C1(); // tgen
};
//SIG(1 S1309C1) C1{ BC2{ BC3{ BC4{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v76 v77 v78 v79} vd v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC6{ BC7{ vd v98 v99 v100 v101 v102 Fi[8] Fp Fi Fp} v96 v97} Fi:1 Fc[3] Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fi[2] Fc Fi Fi:1 Fp[6]}


 S1309C1 ::~S1309C1(){ note_dtor("S1309C1", this);}
void  S1309C1 ::v1(){vfunc_called(this, "_ZN7S1309C12v1Ev");}
void  S1309C1 ::v2(){vfunc_called(this, "_ZN7S1309C12v2Ev");}
void  S1309C1 ::v3(){vfunc_called(this, "_ZN7S1309C12v3Ev");}
void  S1309C1 ::v4(){vfunc_called(this, "_ZN7S1309C12v4Ev");}
void  S1309C1 ::v5(){vfunc_called(this, "_ZN7S1309C12v5Ev");}
void  S1309C1 ::v6(){vfunc_called(this, "_ZN7S1309C12v6Ev");}
void  S1309C1 ::v7(){vfunc_called(this, "_ZN7S1309C12v7Ev");}
void  S1309C1 ::v8(){vfunc_called(this, "_ZN7S1309C12v8Ev");}
void  S1309C1 ::v9(){vfunc_called(this, "_ZN7S1309C12v9Ev");}
void  S1309C1 ::v10(){vfunc_called(this, "_ZN7S1309C13v10Ev");}
void  S1309C1 ::v11(){vfunc_called(this, "_ZN7S1309C13v11Ev");}
S1309C1 ::S1309C1(){ note_ctor("S1309C1", this);} // tgen

static void Test_S1309C1()
{
  extern Class_Descriptor cd_S1309C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(42,58)];
    init_test(&cd_S1309C1, buf);
    S1309C1 *dp, &lv = *(dp=new (buf) S1309C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(328,228), "sizeof(S1309C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1309C1)");
    check_base_class_offset(lv, (S1309C4*)(S1309C3*)(S1309C2*), 0, "S1309C1");
    check_base_class_offset(lv, (S1309C3*)(S1309C2*), 0, "S1309C1");
    check_base_class_offset(lv, (S1309C2*), 0, "S1309C1");
    check_field_offset(lv, s1309c1f0, ABISELECT(256,184), "S1309C1.s1309c1f0");
    check_field_offset(lv, s1309c1f1, ABISELECT(264,192), "S1309C1.s1309c1f1");
    check_field_offset(lv, s1309c1f2, ABISELECT(268,196), "S1309C1.s1309c1f2");
    set_bf_and_test(lv, s1309c1f3, ABISELECT(272,200), 0, 1, 1, "S1309C1");
    check_field_offset(lv, s1309c1f4, ABISELECT(280,204), "S1309C1.s1309c1f4");
    test_class_info(&lv, &cd_S1309C1);
    dp->~S1309C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1309C1(Test_S1309C1, "S1309C1", ABISELECT(328,228));

#else // __cplusplus

extern void _ZN7S1309C1C1Ev();
extern void _ZN7S1309C1D1Ev();
Name_Map name_map_S1309C1[] = {
  NSPAIR(_ZN7S1309C1C1Ev),
  NSPAIR(_ZN7S1309C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1309C4;
extern VTBL_ENTRY _ZTI7S1309C4[];
extern  VTBL_ENTRY _ZTV7S1309C4[];
extern Class_Descriptor cd_S1309C3;
extern VTBL_ENTRY _ZTI7S1309C3[];
extern  VTBL_ENTRY _ZTV7S1309C3[];
extern Class_Descriptor cd_S1309C2;
extern VTBL_ENTRY _ZTI7S1309C2[];
extern  VTBL_ENTRY _ZTV7S1309C2[];
static Base_Class bases_S1309C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1309C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1309C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1309C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1309C1[];
extern void _ZN7S1309C1D1Ev();
extern void _ZN7S1309C1D0Ev();
extern void _ZN7S1309C43v12Ev();
extern void _ZN7S1309C43v13Ev();
extern void _ZN7S1309C43v14Ev();
extern void _ZN7S1309C43v15Ev();
extern void _ZN7S1309C43v16Ev();
extern void _ZN7S1309C43v17Ev();
extern void _ZN7S1309C43v18Ev();
extern void _ZN7S1309C43v19Ev();
extern void _ZN7S1309C43v20Ev();
extern void _ZN7S1309C43v21Ev();
extern void _ZN7S1309C43v22Ev();
extern void _ZN7S1309C43v23Ev();
extern void _ZN7S1309C43v24Ev();
extern void _ZN7S1309C43v25Ev();
extern void _ZN7S1309C43v26Ev();
extern void _ZN7S1309C43v27Ev();
extern void _ZN7S1309C43v28Ev();
extern void _ZN7S1309C43v29Ev();
extern void _ZN7S1309C43v30Ev();
extern void _ZN7S1309C43v31Ev();
extern void _ZN7S1309C43v32Ev();
extern void _ZN7S1309C43v33Ev();
extern void _ZN7S1309C43v34Ev();
extern void _ZN7S1309C43v35Ev();
extern void _ZN7S1309C43v36Ev();
extern void _ZN7S1309C43v37Ev();
extern void _ZN7S1309C43v38Ev();
extern void _ZN7S1309C43v39Ev();
extern void _ZN7S1309C43v40Ev();
extern void _ZN7S1309C43v41Ev();
extern void _ZN7S1309C43v42Ev();
extern void _ZN7S1309C43v43Ev();
extern void _ZN7S1309C43v44Ev();
extern void _ZN7S1309C43v45Ev();
extern void _ZN7S1309C43v46Ev();
extern void _ZN7S1309C43v47Ev();
extern void _ZN7S1309C43v48Ev();
extern void _ZN7S1309C43v49Ev();
extern void _ZN7S1309C43v50Ev();
extern void _ZN7S1309C43v51Ev();
extern void _ZN7S1309C43v52Ev();
extern void _ZN7S1309C43v53Ev();
extern void _ZN7S1309C43v54Ev();
extern void _ZN7S1309C43v55Ev();
extern void _ZN7S1309C43v56Ev();
extern void _ZN7S1309C43v57Ev();
extern void _ZN7S1309C43v58Ev();
extern void _ZN7S1309C43v59Ev();
extern void _ZN7S1309C43v60Ev();
extern void _ZN7S1309C43v61Ev();
extern void _ZN7S1309C43v62Ev();
extern void _ZN7S1309C43v63Ev();
extern void _ZN7S1309C43v64Ev();
extern void _ZN7S1309C43v65Ev();
extern void _ZN7S1309C43v66Ev();
extern void _ZN7S1309C43v67Ev();
extern void _ZN7S1309C43v68Ev();
extern void _ZN7S1309C43v69Ev();
extern void _ZN7S1309C43v70Ev();
extern void _ZN7S1309C43v71Ev();
extern void _ZN7S1309C43v72Ev();
extern void _ZN7S1309C43v73Ev();
extern void _ZN7S1309C43v74Ev();
extern void _ZN7S1309C43v75Ev();
extern void _ZN7S1309C33v76Ev();
extern void _ZN7S1309C33v77Ev();
extern void _ZN7S1309C33v78Ev();
extern void _ZN7S1309C33v79Ev();
extern void _ZN7S1309C23v80Ev();
extern void _ZN7S1309C23v81Ev();
extern void _ZN7S1309C23v82Ev();
extern void _ZN7S1309C23v83Ev();
extern void _ZN7S1309C23v84Ev();
extern void _ZN7S1309C23v85Ev();
extern void _ZN7S1309C23v86Ev();
extern void _ZN7S1309C23v87Ev();
extern void _ZN7S1309C23v88Ev();
extern void _ZN7S1309C23v89Ev();
extern void _ZN7S1309C23v90Ev();
extern void _ZN7S1309C23v91Ev();
extern void _ZN7S1309C23v92Ev();
extern void _ZN7S1309C23v93Ev();
extern void _ZN7S1309C23v94Ev();
extern void _ZN7S1309C23v95Ev();
extern void _ZN7S1309C12v1Ev();
extern void _ZN7S1309C12v2Ev();
extern void _ZN7S1309C12v3Ev();
extern void _ZN7S1309C12v4Ev();
extern void _ZN7S1309C12v5Ev();
extern void _ZN7S1309C12v6Ev();
extern void _ZN7S1309C12v7Ev();
extern void _ZN7S1309C12v8Ev();
extern void _ZN7S1309C12v9Ev();
extern void _ZN7S1309C13v10Ev();
extern void _ZN7S1309C13v11Ev();
static  VTBL_ENTRY vtc_S1309C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1309C1[0]),
  (VTBL_ENTRY)&_ZN7S1309C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1309C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v72Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v73Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v74Ev,
  (VTBL_ENTRY)&_ZN7S1309C43v75Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1309C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v80Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v92Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v93Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v94Ev,
  (VTBL_ENTRY)&_ZN7S1309C23v95Ev,
  (VTBL_ENTRY)&_ZN7S1309C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1309C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1309C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1309C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1309C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1309C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1309C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1309C12v8Ev,
  (VTBL_ENTRY)&_ZN7S1309C12v9Ev,
  (VTBL_ENTRY)&_ZN7S1309C13v10Ev,
  (VTBL_ENTRY)&_ZN7S1309C13v11Ev,
};
extern VTBL_ENTRY _ZTI7S1309C1[];
extern  VTBL_ENTRY _ZTV7S1309C1[];
Class_Descriptor cd_S1309C1 = {  "S1309C1", // class name
  bases_S1309C1, 3,
  &(vtc_S1309C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(328,228), // object size
  NSPAIRA(_ZTI7S1309C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1309C1),99, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1583C4  {
  int s1583c4f0;
  __tsi64 s1583c4f1;
  void *s1583c4f2[4];
  int s1583c4f3[2];
  void *s1583c4f4;
  ::S695C22_nt s1583c4f5;
  void *s1583c4f6[2];
  virtual  ~S1583C4(); // _ZN7S1583C4D1Ev
  virtual void  v8(); // _ZN7S1583C42v8Ev
  virtual void  v9(); // _ZN7S1583C42v9Ev
  virtual void  v10(); // _ZN7S1583C43v10Ev
  virtual void  v11(); // _ZN7S1583C43v11Ev
  virtual void  v12(); // _ZN7S1583C43v12Ev
  virtual void  v13(); // _ZN7S1583C43v13Ev
  virtual void  v14(); // _ZN7S1583C43v14Ev
  virtual void  v15(); // _ZN7S1583C43v15Ev
  virtual void  v16(); // _ZN7S1583C43v16Ev
  virtual void  v17(); // _ZN7S1583C43v17Ev
  virtual void  v18(); // _ZN7S1583C43v18Ev
  virtual void  v19(); // _ZN7S1583C43v19Ev
  virtual void  v20(); // _ZN7S1583C43v20Ev
  virtual void  v21(); // _ZN7S1583C43v21Ev
  virtual void  v22(); // _ZN7S1583C43v22Ev
  virtual void  v23(); // _ZN7S1583C43v23Ev
  virtual void  v24(); // _ZN7S1583C43v24Ev
  virtual void  v25(); // _ZN7S1583C43v25Ev
  virtual void  v26(); // _ZN7S1583C43v26Ev
  virtual void  v27(); // _ZN7S1583C43v27Ev
  virtual void  v28(); // _ZN7S1583C43v28Ev
  virtual void  v29(); // _ZN7S1583C43v29Ev
  virtual void  v30(); // _ZN7S1583C43v30Ev
  virtual void  v31(); // _ZN7S1583C43v31Ev
  virtual void  v32(); // _ZN7S1583C43v32Ev
  virtual void  v33(); // _ZN7S1583C43v33Ev
  virtual void  v34(); // _ZN7S1583C43v34Ev
  virtual void  v35(); // _ZN7S1583C43v35Ev
  virtual void  v36(); // _ZN7S1583C43v36Ev
  virtual void  v37(); // _ZN7S1583C43v37Ev
  virtual void  v38(); // _ZN7S1583C43v38Ev
  virtual void  v39(); // _ZN7S1583C43v39Ev
  virtual void  v40(); // _ZN7S1583C43v40Ev
  virtual void  v41(); // _ZN7S1583C43v41Ev
  virtual void  v42(); // _ZN7S1583C43v42Ev
  virtual void  v43(); // _ZN7S1583C43v43Ev
  virtual void  v44(); // _ZN7S1583C43v44Ev
  virtual void  v45(); // _ZN7S1583C43v45Ev
  virtual void  v46(); // _ZN7S1583C43v46Ev
  virtual void  v47(); // _ZN7S1583C43v47Ev
  virtual void  v48(); // _ZN7S1583C43v48Ev
  virtual void  v49(); // _ZN7S1583C43v49Ev
  virtual void  v50(); // _ZN7S1583C43v50Ev
  virtual void  v51(); // _ZN7S1583C43v51Ev
  virtual void  v52(); // _ZN7S1583C43v52Ev
  virtual void  v53(); // _ZN7S1583C43v53Ev
  virtual void  v54(); // _ZN7S1583C43v54Ev
  virtual void  v55(); // _ZN7S1583C43v55Ev
  virtual void  v56(); // _ZN7S1583C43v56Ev
  virtual void  v57(); // _ZN7S1583C43v57Ev
  virtual void  v58(); // _ZN7S1583C43v58Ev
  virtual void  v59(); // _ZN7S1583C43v59Ev
  virtual void  v60(); // _ZN7S1583C43v60Ev
  virtual void  v61(); // _ZN7S1583C43v61Ev
  virtual void  v62(); // _ZN7S1583C43v62Ev
  virtual void  v63(); // _ZN7S1583C43v63Ev
  virtual void  v64(); // _ZN7S1583C43v64Ev
  virtual void  v65(); // _ZN7S1583C43v65Ev
  virtual void  v66(); // _ZN7S1583C43v66Ev
  virtual void  v67(); // _ZN7S1583C43v67Ev
  virtual void  v68(); // _ZN7S1583C43v68Ev
  virtual void  v69(); // _ZN7S1583C43v69Ev
  virtual void  v70(); // _ZN7S1583C43v70Ev
  virtual void  v71(); // _ZN7S1583C43v71Ev
  S1583C4(); // tgen
};
//SIG(-1 S1583C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1583C4 ::~S1583C4(){ note_dtor("S1583C4", this);}
void  S1583C4 ::v8(){vfunc_called(this, "_ZN7S1583C42v8Ev");}
void  S1583C4 ::v9(){vfunc_called(this, "_ZN7S1583C42v9Ev");}
void  S1583C4 ::v10(){vfunc_called(this, "_ZN7S1583C43v10Ev");}
void  S1583C4 ::v11(){vfunc_called(this, "_ZN7S1583C43v11Ev");}
void  S1583C4 ::v12(){vfunc_called(this, "_ZN7S1583C43v12Ev");}
void  S1583C4 ::v13(){vfunc_called(this, "_ZN7S1583C43v13Ev");}
void  S1583C4 ::v14(){vfunc_called(this, "_ZN7S1583C43v14Ev");}
void  S1583C4 ::v15(){vfunc_called(this, "_ZN7S1583C43v15Ev");}
void  S1583C4 ::v16(){vfunc_called(this, "_ZN7S1583C43v16Ev");}
void  S1583C4 ::v17(){vfunc_called(this, "_ZN7S1583C43v17Ev");}
void  S1583C4 ::v18(){vfunc_called(this, "_ZN7S1583C43v18Ev");}
void  S1583C4 ::v19(){vfunc_called(this, "_ZN7S1583C43v19Ev");}
void  S1583C4 ::v20(){vfunc_called(this, "_ZN7S1583C43v20Ev");}
void  S1583C4 ::v21(){vfunc_called(this, "_ZN7S1583C43v21Ev");}
void  S1583C4 ::v22(){vfunc_called(this, "_ZN7S1583C43v22Ev");}
void  S1583C4 ::v23(){vfunc_called(this, "_ZN7S1583C43v23Ev");}
void  S1583C4 ::v24(){vfunc_called(this, "_ZN7S1583C43v24Ev");}
void  S1583C4 ::v25(){vfunc_called(this, "_ZN7S1583C43v25Ev");}
void  S1583C4 ::v26(){vfunc_called(this, "_ZN7S1583C43v26Ev");}
void  S1583C4 ::v27(){vfunc_called(this, "_ZN7S1583C43v27Ev");}
void  S1583C4 ::v28(){vfunc_called(this, "_ZN7S1583C43v28Ev");}
void  S1583C4 ::v29(){vfunc_called(this, "_ZN7S1583C43v29Ev");}
void  S1583C4 ::v30(){vfunc_called(this, "_ZN7S1583C43v30Ev");}
void  S1583C4 ::v31(){vfunc_called(this, "_ZN7S1583C43v31Ev");}
void  S1583C4 ::v32(){vfunc_called(this, "_ZN7S1583C43v32Ev");}
void  S1583C4 ::v33(){vfunc_called(this, "_ZN7S1583C43v33Ev");}
void  S1583C4 ::v34(){vfunc_called(this, "_ZN7S1583C43v34Ev");}
void  S1583C4 ::v35(){vfunc_called(this, "_ZN7S1583C43v35Ev");}
void  S1583C4 ::v36(){vfunc_called(this, "_ZN7S1583C43v36Ev");}
void  S1583C4 ::v37(){vfunc_called(this, "_ZN7S1583C43v37Ev");}
void  S1583C4 ::v38(){vfunc_called(this, "_ZN7S1583C43v38Ev");}
void  S1583C4 ::v39(){vfunc_called(this, "_ZN7S1583C43v39Ev");}
void  S1583C4 ::v40(){vfunc_called(this, "_ZN7S1583C43v40Ev");}
void  S1583C4 ::v41(){vfunc_called(this, "_ZN7S1583C43v41Ev");}
void  S1583C4 ::v42(){vfunc_called(this, "_ZN7S1583C43v42Ev");}
void  S1583C4 ::v43(){vfunc_called(this, "_ZN7S1583C43v43Ev");}
void  S1583C4 ::v44(){vfunc_called(this, "_ZN7S1583C43v44Ev");}
void  S1583C4 ::v45(){vfunc_called(this, "_ZN7S1583C43v45Ev");}
void  S1583C4 ::v46(){vfunc_called(this, "_ZN7S1583C43v46Ev");}
void  S1583C4 ::v47(){vfunc_called(this, "_ZN7S1583C43v47Ev");}
void  S1583C4 ::v48(){vfunc_called(this, "_ZN7S1583C43v48Ev");}
void  S1583C4 ::v49(){vfunc_called(this, "_ZN7S1583C43v49Ev");}
void  S1583C4 ::v50(){vfunc_called(this, "_ZN7S1583C43v50Ev");}
void  S1583C4 ::v51(){vfunc_called(this, "_ZN7S1583C43v51Ev");}
void  S1583C4 ::v52(){vfunc_called(this, "_ZN7S1583C43v52Ev");}
void  S1583C4 ::v53(){vfunc_called(this, "_ZN7S1583C43v53Ev");}
void  S1583C4 ::v54(){vfunc_called(this, "_ZN7S1583C43v54Ev");}
void  S1583C4 ::v55(){vfunc_called(this, "_ZN7S1583C43v55Ev");}
void  S1583C4 ::v56(){vfunc_called(this, "_ZN7S1583C43v56Ev");}
void  S1583C4 ::v57(){vfunc_called(this, "_ZN7S1583C43v57Ev");}
void  S1583C4 ::v58(){vfunc_called(this, "_ZN7S1583C43v58Ev");}
void  S1583C4 ::v59(){vfunc_called(this, "_ZN7S1583C43v59Ev");}
void  S1583C4 ::v60(){vfunc_called(this, "_ZN7S1583C43v60Ev");}
void  S1583C4 ::v61(){vfunc_called(this, "_ZN7S1583C43v61Ev");}
void  S1583C4 ::v62(){vfunc_called(this, "_ZN7S1583C43v62Ev");}
void  S1583C4 ::v63(){vfunc_called(this, "_ZN7S1583C43v63Ev");}
void  S1583C4 ::v64(){vfunc_called(this, "_ZN7S1583C43v64Ev");}
void  S1583C4 ::v65(){vfunc_called(this, "_ZN7S1583C43v65Ev");}
void  S1583C4 ::v66(){vfunc_called(this, "_ZN7S1583C43v66Ev");}
void  S1583C4 ::v67(){vfunc_called(this, "_ZN7S1583C43v67Ev");}
void  S1583C4 ::v68(){vfunc_called(this, "_ZN7S1583C43v68Ev");}
void  S1583C4 ::v69(){vfunc_called(this, "_ZN7S1583C43v69Ev");}
void  S1583C4 ::v70(){vfunc_called(this, "_ZN7S1583C43v70Ev");}
void  S1583C4 ::v71(){vfunc_called(this, "_ZN7S1583C43v71Ev");}
S1583C4 ::S1583C4(){ note_ctor("S1583C4", this);} // tgen

static void Test_S1583C4()
{
  extern Class_Descriptor cd_S1583C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1583C4, buf);
    S1583C4 *dp, &lv = *(dp=new (buf) S1583C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1583C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1583C4)");
    check_field_offset(lv, s1583c4f0, ABISELECT(8,4), "S1583C4.s1583c4f0");
    check_field_offset(lv, s1583c4f1, ABISELECT(16,8), "S1583C4.s1583c4f1");
    check_field_offset(lv, s1583c4f2, ABISELECT(24,16), "S1583C4.s1583c4f2");
    check_field_offset(lv, s1583c4f3, ABISELECT(56,32), "S1583C4.s1583c4f3");
    check_field_offset(lv, s1583c4f4, ABISELECT(64,40), "S1583C4.s1583c4f4");
    check_field_offset(lv, s1583c4f5, ABISELECT(72,44), "S1583C4.s1583c4f5");
    check_field_offset(lv, s1583c4f6, ABISELECT(80,52), "S1583C4.s1583c4f6");
    test_class_info(&lv, &cd_S1583C4);
    dp->~S1583C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1583C4(Test_S1583C4, "S1583C4", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1583C4C1Ev();
extern void _ZN7S1583C4D1Ev();
Name_Map name_map_S1583C4[] = {
  NSPAIR(_ZN7S1583C4C1Ev),
  NSPAIR(_ZN7S1583C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1583C4[];
extern void _ZN7S1583C4D1Ev();
extern void _ZN7S1583C4D0Ev();
extern void _ZN7S1583C42v8Ev();
extern void _ZN7S1583C42v9Ev();
extern void _ZN7S1583C43v10Ev();
extern void _ZN7S1583C43v11Ev();
extern void _ZN7S1583C43v12Ev();
extern void _ZN7S1583C43v13Ev();
extern void _ZN7S1583C43v14Ev();
extern void _ZN7S1583C43v15Ev();
extern void _ZN7S1583C43v16Ev();
extern void _ZN7S1583C43v17Ev();
extern void _ZN7S1583C43v18Ev();
extern void _ZN7S1583C43v19Ev();
extern void _ZN7S1583C43v20Ev();
extern void _ZN7S1583C43v21Ev();
extern void _ZN7S1583C43v22Ev();
extern void _ZN7S1583C43v23Ev();
extern void _ZN7S1583C43v24Ev();
extern void _ZN7S1583C43v25Ev();
extern void _ZN7S1583C43v26Ev();
extern void _ZN7S1583C43v27Ev();
extern void _ZN7S1583C43v28Ev();
extern void _ZN7S1583C43v29Ev();
extern void _ZN7S1583C43v30Ev();
extern void _ZN7S1583C43v31Ev();
extern void _ZN7S1583C43v32Ev();
extern void _ZN7S1583C43v33Ev();
extern void _ZN7S1583C43v34Ev();
extern void _ZN7S1583C43v35Ev();
extern void _ZN7S1583C43v36Ev();
extern void _ZN7S1583C43v37Ev();
extern void _ZN7S1583C43v38Ev();
extern void _ZN7S1583C43v39Ev();
extern void _ZN7S1583C43v40Ev();
extern void _ZN7S1583C43v41Ev();
extern void _ZN7S1583C43v42Ev();
extern void _ZN7S1583C43v43Ev();
extern void _ZN7S1583C43v44Ev();
extern void _ZN7S1583C43v45Ev();
extern void _ZN7S1583C43v46Ev();
extern void _ZN7S1583C43v47Ev();
extern void _ZN7S1583C43v48Ev();
extern void _ZN7S1583C43v49Ev();
extern void _ZN7S1583C43v50Ev();
extern void _ZN7S1583C43v51Ev();
extern void _ZN7S1583C43v52Ev();
extern void _ZN7S1583C43v53Ev();
extern void _ZN7S1583C43v54Ev();
extern void _ZN7S1583C43v55Ev();
extern void _ZN7S1583C43v56Ev();
extern void _ZN7S1583C43v57Ev();
extern void _ZN7S1583C43v58Ev();
extern void _ZN7S1583C43v59Ev();
extern void _ZN7S1583C43v60Ev();
extern void _ZN7S1583C43v61Ev();
extern void _ZN7S1583C43v62Ev();
extern void _ZN7S1583C43v63Ev();
extern void _ZN7S1583C43v64Ev();
extern void _ZN7S1583C43v65Ev();
extern void _ZN7S1583C43v66Ev();
extern void _ZN7S1583C43v67Ev();
extern void _ZN7S1583C43v68Ev();
extern void _ZN7S1583C43v69Ev();
extern void _ZN7S1583C43v70Ev();
extern void _ZN7S1583C43v71Ev();
static  VTBL_ENTRY vtc_S1583C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1583C4[0]),
  (VTBL_ENTRY)&_ZN7S1583C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1583C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1583C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1583C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v71Ev,
};
extern VTBL_ENTRY _ZTI7S1583C4[];
extern  VTBL_ENTRY _ZTV7S1583C4[];
Class_Descriptor cd_S1583C4 = {  "S1583C4", // class name
  0,0,//no base classes
  &(vtc_S1583C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1583C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1583C4),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1583C3  : S1583C4 {
  virtual  ~S1583C3(); // _ZN7S1583C3D1Ev
  virtual void  v72(); // _ZN7S1583C33v72Ev
  virtual void  v73(); // _ZN7S1583C33v73Ev
  virtual void  v74(); // _ZN7S1583C33v74Ev
  virtual void  v75(); // _ZN7S1583C33v75Ev
  S1583C3(); // tgen
};
//SIG(-1 S1583C3) C1{ BC2{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4}


 S1583C3 ::~S1583C3(){ note_dtor("S1583C3", this);}
void  S1583C3 ::v72(){vfunc_called(this, "_ZN7S1583C33v72Ev");}
void  S1583C3 ::v73(){vfunc_called(this, "_ZN7S1583C33v73Ev");}
void  S1583C3 ::v74(){vfunc_called(this, "_ZN7S1583C33v74Ev");}
void  S1583C3 ::v75(){vfunc_called(this, "_ZN7S1583C33v75Ev");}
S1583C3 ::S1583C3(){ note_ctor("S1583C3", this);} // tgen

static void Test_S1583C3()
{
  extern Class_Descriptor cd_S1583C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S1583C3, buf);
    S1583C3 *dp, &lv = *(dp=new (buf) S1583C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S1583C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1583C3)");
    check_base_class_offset(lv, (S1583C4*), 0, "S1583C3");
    test_class_info(&lv, &cd_S1583C3);
    dp->~S1583C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1583C3(Test_S1583C3, "S1583C3", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN7S1583C3C1Ev();
extern void _ZN7S1583C3D1Ev();
Name_Map name_map_S1583C3[] = {
  NSPAIR(_ZN7S1583C3C1Ev),
  NSPAIR(_ZN7S1583C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1583C4;
extern VTBL_ENTRY _ZTI7S1583C4[];
extern  VTBL_ENTRY _ZTV7S1583C4[];
static Base_Class bases_S1583C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1583C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1583C3[];
extern void _ZN7S1583C3D1Ev();
extern void _ZN7S1583C3D0Ev();
extern void _ZN7S1583C42v8Ev();
extern void _ZN7S1583C42v9Ev();
extern void _ZN7S1583C43v10Ev();
extern void _ZN7S1583C43v11Ev();
extern void _ZN7S1583C43v12Ev();
extern void _ZN7S1583C43v13Ev();
extern void _ZN7S1583C43v14Ev();
extern void _ZN7S1583C43v15Ev();
extern void _ZN7S1583C43v16Ev();
extern void _ZN7S1583C43v17Ev();
extern void _ZN7S1583C43v18Ev();
extern void _ZN7S1583C43v19Ev();
extern void _ZN7S1583C43v20Ev();
extern void _ZN7S1583C43v21Ev();
extern void _ZN7S1583C43v22Ev();
extern void _ZN7S1583C43v23Ev();
extern void _ZN7S1583C43v24Ev();
extern void _ZN7S1583C43v25Ev();
extern void _ZN7S1583C43v26Ev();
extern void _ZN7S1583C43v27Ev();
extern void _ZN7S1583C43v28Ev();
extern void _ZN7S1583C43v29Ev();
extern void _ZN7S1583C43v30Ev();
extern void _ZN7S1583C43v31Ev();
extern void _ZN7S1583C43v32Ev();
extern void _ZN7S1583C43v33Ev();
extern void _ZN7S1583C43v34Ev();
extern void _ZN7S1583C43v35Ev();
extern void _ZN7S1583C43v36Ev();
extern void _ZN7S1583C43v37Ev();
extern void _ZN7S1583C43v38Ev();
extern void _ZN7S1583C43v39Ev();
extern void _ZN7S1583C43v40Ev();
extern void _ZN7S1583C43v41Ev();
extern void _ZN7S1583C43v42Ev();
extern void _ZN7S1583C43v43Ev();
extern void _ZN7S1583C43v44Ev();
extern void _ZN7S1583C43v45Ev();
extern void _ZN7S1583C43v46Ev();
extern void _ZN7S1583C43v47Ev();
extern void _ZN7S1583C43v48Ev();
extern void _ZN7S1583C43v49Ev();
extern void _ZN7S1583C43v50Ev();
extern void _ZN7S1583C43v51Ev();
extern void _ZN7S1583C43v52Ev();
extern void _ZN7S1583C43v53Ev();
extern void _ZN7S1583C43v54Ev();
extern void _ZN7S1583C43v55Ev();
extern void _ZN7S1583C43v56Ev();
extern void _ZN7S1583C43v57Ev();
extern void _ZN7S1583C43v58Ev();
extern void _ZN7S1583C43v59Ev();
extern void _ZN7S1583C43v60Ev();
extern void _ZN7S1583C43v61Ev();
extern void _ZN7S1583C43v62Ev();
extern void _ZN7S1583C43v63Ev();
extern void _ZN7S1583C43v64Ev();
extern void _ZN7S1583C43v65Ev();
extern void _ZN7S1583C43v66Ev();
extern void _ZN7S1583C43v67Ev();
extern void _ZN7S1583C43v68Ev();
extern void _ZN7S1583C43v69Ev();
extern void _ZN7S1583C43v70Ev();
extern void _ZN7S1583C43v71Ev();
extern void _ZN7S1583C33v72Ev();
extern void _ZN7S1583C33v73Ev();
extern void _ZN7S1583C33v74Ev();
extern void _ZN7S1583C33v75Ev();
static  VTBL_ENTRY vtc_S1583C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1583C3[0]),
  (VTBL_ENTRY)&_ZN7S1583C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1583C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1583C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1583C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v75Ev,
};
extern VTBL_ENTRY _ZTI7S1583C3[];
extern  VTBL_ENTRY _ZTV7S1583C3[];
Class_Descriptor cd_S1583C3 = {  "S1583C3", // class name
  bases_S1583C3, 1,
  &(vtc_S1583C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI7S1583C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1583C3),72, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1583C2  : S1583C3 {
  unsigned int s1583c2f0:1;
  unsigned int s1583c2f1:1;
  unsigned int s1583c2f2:1;
  unsigned int s1583c2f3:1;
  unsigned int s1583c2f4:1;
  unsigned int s1583c2f5:1;
  unsigned int s1583c2f6:1;
  unsigned int s1583c2f7:1;
  unsigned int s1583c2f8:1;
  unsigned int s1583c2f9:1;
  unsigned int s1583c2f10:1;
  unsigned int s1583c2f11:1;
  unsigned int s1583c2f12:1;
  int s1583c2f13[8];
  ::S507C7 s1583c2f14;
  unsigned int s1583c2f15:1;
  char s1583c2f16;
  char s1583c2f17[2];
  int s1583c2f18[2];
  ::S685C27_nt s1583c2f19;
  ::S685C27_nt s1583c2f20;
  void *s1583c2f21;
  virtual  ~S1583C2(); // _ZN7S1583C2D1Ev
  virtual void  v76(); // _ZN7S1583C23v76Ev
  virtual void  v77(); // _ZN7S1583C23v77Ev
  virtual void  v78(); // _ZN7S1583C23v78Ev
  virtual void  v79(); // _ZN7S1583C23v79Ev
  virtual void  v80(); // _ZN7S1583C23v80Ev
  virtual void  v81(); // _ZN7S1583C23v81Ev
  virtual void  v82(); // _ZN7S1583C23v82Ev
  virtual void  v83(); // _ZN7S1583C23v83Ev
  virtual void  v84(); // _ZN7S1583C23v84Ev
  virtual void  v85(); // _ZN7S1583C23v85Ev
  virtual void  v86(); // _ZN7S1583C23v86Ev
  virtual void  v87(); // _ZN7S1583C23v87Ev
  virtual void  v88(); // _ZN7S1583C23v88Ev
  virtual void  v89(); // _ZN7S1583C23v89Ev
  virtual void  v90(); // _ZN7S1583C23v90Ev
  virtual void  v91(); // _ZN7S1583C23v91Ev
  S1583C2(); // tgen
};
//SIG(-1 S1583C2) C1{ BC2{ BC3{ vd v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v81 v82 v83 v84} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC5{ BC6{ vd v87 v88 v89 v90 v91 Fi[8] Fp Fi Fp} v85 v86} Fi:1 Fc[3] Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 Fp}


 S1583C2 ::~S1583C2(){ note_dtor("S1583C2", this);}
void  S1583C2 ::v76(){vfunc_called(this, "_ZN7S1583C23v76Ev");}
void  S1583C2 ::v77(){vfunc_called(this, "_ZN7S1583C23v77Ev");}
void  S1583C2 ::v78(){vfunc_called(this, "_ZN7S1583C23v78Ev");}
void  S1583C2 ::v79(){vfunc_called(this, "_ZN7S1583C23v79Ev");}
void  S1583C2 ::v80(){vfunc_called(this, "_ZN7S1583C23v80Ev");}
void  S1583C2 ::v81(){vfunc_called(this, "_ZN7S1583C23v81Ev");}
void  S1583C2 ::v82(){vfunc_called(this, "_ZN7S1583C23v82Ev");}
void  S1583C2 ::v83(){vfunc_called(this, "_ZN7S1583C23v83Ev");}
void  S1583C2 ::v84(){vfunc_called(this, "_ZN7S1583C23v84Ev");}
void  S1583C2 ::v85(){vfunc_called(this, "_ZN7S1583C23v85Ev");}
void  S1583C2 ::v86(){vfunc_called(this, "_ZN7S1583C23v86Ev");}
void  S1583C2 ::v87(){vfunc_called(this, "_ZN7S1583C23v87Ev");}
void  S1583C2 ::v88(){vfunc_called(this, "_ZN7S1583C23v88Ev");}
void  S1583C2 ::v89(){vfunc_called(this, "_ZN7S1583C23v89Ev");}
void  S1583C2 ::v90(){vfunc_called(this, "_ZN7S1583C23v90Ev");}
void  S1583C2 ::v91(){vfunc_called(this, "_ZN7S1583C23v91Ev");}
S1583C2 ::S1583C2(){ note_ctor("S1583C2", this);} // tgen

static void Test_S1583C2()
{
  extern Class_Descriptor cd_S1583C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,47)];
    init_test(&cd_S1583C2, buf);
    S1583C2 *dp, &lv = *(dp=new (buf) S1583C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,184), "sizeof(S1583C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1583C2)");
    check_base_class_offset(lv, (S1583C4*)(S1583C3*), 0, "S1583C2");
    check_base_class_offset(lv, (S1583C3*), 0, "S1583C2");
    set_bf_and_test(lv, s1583c2f0, ABISELECT(96,60), 0, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f1, ABISELECT(96,60), 1, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f2, ABISELECT(96,60), 2, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f3, ABISELECT(96,60), 3, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f4, ABISELECT(96,60), 4, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f5, ABISELECT(96,60), 5, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f6, ABISELECT(96,60), 6, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f7, ABISELECT(96,60), 7, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f8, ABISELECT(97,61), 0, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f9, ABISELECT(97,61), 1, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f10, ABISELECT(97,61), 2, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f11, ABISELECT(97,61), 3, 1, 1, "S1583C2");
    set_bf_and_test(lv, s1583c2f12, ABISELECT(97,61), 4, 1, 1, "S1583C2");
    check_field_offset(lv, s1583c2f13, ABISELECT(100,64), "S1583C2.s1583c2f13");
    check_field_offset(lv, s1583c2f14, ABISELECT(136,96), "S1583C2.s1583c2f14");
    set_bf_and_test(lv, s1583c2f15, ABISELECT(200,144), 0, 1, 1, "S1583C2");
    check_field_offset(lv, s1583c2f16, ABISELECT(201,145), "S1583C2.s1583c2f16");
    check_field_offset(lv, s1583c2f17, ABISELECT(202,146), "S1583C2.s1583c2f17");
    check_field_offset(lv, s1583c2f18, ABISELECT(204,148), "S1583C2.s1583c2f18");
    check_field_offset(lv, s1583c2f19, ABISELECT(216,156), "S1583C2.s1583c2f19");
    check_field_offset(lv, s1583c2f20, ABISELECT(232,168), "S1583C2.s1583c2f20");
    check_field_offset(lv, s1583c2f21, ABISELECT(248,180), "S1583C2.s1583c2f21");
    test_class_info(&lv, &cd_S1583C2);
    dp->~S1583C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1583C2(Test_S1583C2, "S1583C2", ABISELECT(256,184));

#else // __cplusplus

extern void _ZN7S1583C2C1Ev();
extern void _ZN7S1583C2D1Ev();
Name_Map name_map_S1583C2[] = {
  NSPAIR(_ZN7S1583C2C1Ev),
  NSPAIR(_ZN7S1583C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1583C4;
extern VTBL_ENTRY _ZTI7S1583C4[];
extern  VTBL_ENTRY _ZTV7S1583C4[];
extern Class_Descriptor cd_S1583C3;
extern VTBL_ENTRY _ZTI7S1583C3[];
extern  VTBL_ENTRY _ZTV7S1583C3[];
static Base_Class bases_S1583C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1583C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1583C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1583C2[];
extern void _ZN7S1583C2D1Ev();
extern void _ZN7S1583C2D0Ev();
extern void _ZN7S1583C42v8Ev();
extern void _ZN7S1583C42v9Ev();
extern void _ZN7S1583C43v10Ev();
extern void _ZN7S1583C43v11Ev();
extern void _ZN7S1583C43v12Ev();
extern void _ZN7S1583C43v13Ev();
extern void _ZN7S1583C43v14Ev();
extern void _ZN7S1583C43v15Ev();
extern void _ZN7S1583C43v16Ev();
extern void _ZN7S1583C43v17Ev();
extern void _ZN7S1583C43v18Ev();
extern void _ZN7S1583C43v19Ev();
extern void _ZN7S1583C43v20Ev();
extern void _ZN7S1583C43v21Ev();
extern void _ZN7S1583C43v22Ev();
extern void _ZN7S1583C43v23Ev();
extern void _ZN7S1583C43v24Ev();
extern void _ZN7S1583C43v25Ev();
extern void _ZN7S1583C43v26Ev();
extern void _ZN7S1583C43v27Ev();
extern void _ZN7S1583C43v28Ev();
extern void _ZN7S1583C43v29Ev();
extern void _ZN7S1583C43v30Ev();
extern void _ZN7S1583C43v31Ev();
extern void _ZN7S1583C43v32Ev();
extern void _ZN7S1583C43v33Ev();
extern void _ZN7S1583C43v34Ev();
extern void _ZN7S1583C43v35Ev();
extern void _ZN7S1583C43v36Ev();
extern void _ZN7S1583C43v37Ev();
extern void _ZN7S1583C43v38Ev();
extern void _ZN7S1583C43v39Ev();
extern void _ZN7S1583C43v40Ev();
extern void _ZN7S1583C43v41Ev();
extern void _ZN7S1583C43v42Ev();
extern void _ZN7S1583C43v43Ev();
extern void _ZN7S1583C43v44Ev();
extern void _ZN7S1583C43v45Ev();
extern void _ZN7S1583C43v46Ev();
extern void _ZN7S1583C43v47Ev();
extern void _ZN7S1583C43v48Ev();
extern void _ZN7S1583C43v49Ev();
extern void _ZN7S1583C43v50Ev();
extern void _ZN7S1583C43v51Ev();
extern void _ZN7S1583C43v52Ev();
extern void _ZN7S1583C43v53Ev();
extern void _ZN7S1583C43v54Ev();
extern void _ZN7S1583C43v55Ev();
extern void _ZN7S1583C43v56Ev();
extern void _ZN7S1583C43v57Ev();
extern void _ZN7S1583C43v58Ev();
extern void _ZN7S1583C43v59Ev();
extern void _ZN7S1583C43v60Ev();
extern void _ZN7S1583C43v61Ev();
extern void _ZN7S1583C43v62Ev();
extern void _ZN7S1583C43v63Ev();
extern void _ZN7S1583C43v64Ev();
extern void _ZN7S1583C43v65Ev();
extern void _ZN7S1583C43v66Ev();
extern void _ZN7S1583C43v67Ev();
extern void _ZN7S1583C43v68Ev();
extern void _ZN7S1583C43v69Ev();
extern void _ZN7S1583C43v70Ev();
extern void _ZN7S1583C43v71Ev();
extern void _ZN7S1583C33v72Ev();
extern void _ZN7S1583C33v73Ev();
extern void _ZN7S1583C33v74Ev();
extern void _ZN7S1583C33v75Ev();
extern void _ZN7S1583C23v76Ev();
extern void _ZN7S1583C23v77Ev();
extern void _ZN7S1583C23v78Ev();
extern void _ZN7S1583C23v79Ev();
extern void _ZN7S1583C23v80Ev();
extern void _ZN7S1583C23v81Ev();
extern void _ZN7S1583C23v82Ev();
extern void _ZN7S1583C23v83Ev();
extern void _ZN7S1583C23v84Ev();
extern void _ZN7S1583C23v85Ev();
extern void _ZN7S1583C23v86Ev();
extern void _ZN7S1583C23v87Ev();
extern void _ZN7S1583C23v88Ev();
extern void _ZN7S1583C23v89Ev();
extern void _ZN7S1583C23v90Ev();
extern void _ZN7S1583C23v91Ev();
static  VTBL_ENTRY vtc_S1583C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1583C2[0]),
  (VTBL_ENTRY)&_ZN7S1583C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1583C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1583C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1583C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v76Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v77Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v78Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v79Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v80Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v91Ev,
};
extern VTBL_ENTRY _ZTI7S1583C2[];
extern  VTBL_ENTRY _ZTV7S1583C2[];
Class_Descriptor cd_S1583C2 = {  "S1583C2", // class name
  bases_S1583C2, 2,
  &(vtc_S1583C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,184), // object size
  NSPAIRA(_ZTI7S1583C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1583C2),88, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1583C1  : S1583C2 {
  ::S685C39 s1583c1f0;
  int s1583c1f1;
  virtual  ~S1583C1(); // _ZN7S1583C1D1Ev
  virtual void  v1(); // _ZN7S1583C12v1Ev
  virtual void  v2(); // _ZN7S1583C12v2Ev
  virtual void  v3(); // _ZN7S1583C12v3Ev
  virtual void  v4(); // _ZN7S1583C12v4Ev
  virtual void  v5(); // _ZN7S1583C12v5Ev
  virtual void  v6(); // _ZN7S1583C12v6Ev
  virtual void  v7(); // _ZN7S1583C12v7Ev
  S1583C1(); // tgen
};
//SIG(1 S1583C1) C1{ BC2{ BC3{ BC4{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v72 v73 v74 v75} vd v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[8] FC6{ BC7{ vd v94 v95 v96 v97 v98 Fi[8] Fp Fi Fp} v92 v93} Fi:1 Fc[3] Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 Fp} vd v1 v2 v3 v4 v5 v6 v7 FC12{ BC13{ BC11}} Fi}


 S1583C1 ::~S1583C1(){ note_dtor("S1583C1", this);}
void  S1583C1 ::v1(){vfunc_called(this, "_ZN7S1583C12v1Ev");}
void  S1583C1 ::v2(){vfunc_called(this, "_ZN7S1583C12v2Ev");}
void  S1583C1 ::v3(){vfunc_called(this, "_ZN7S1583C12v3Ev");}
void  S1583C1 ::v4(){vfunc_called(this, "_ZN7S1583C12v4Ev");}
void  S1583C1 ::v5(){vfunc_called(this, "_ZN7S1583C12v5Ev");}
void  S1583C1 ::v6(){vfunc_called(this, "_ZN7S1583C12v6Ev");}
void  S1583C1 ::v7(){vfunc_called(this, "_ZN7S1583C12v7Ev");}
S1583C1 ::S1583C1(){ note_ctor("S1583C1", this);} // tgen

static void Test_S1583C1()
{
  extern Class_Descriptor cd_S1583C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,51)];
    init_test(&cd_S1583C1, buf);
    S1583C1 *dp, &lv = *(dp=new (buf) S1583C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,200), "sizeof(S1583C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1583C1)");
    check_base_class_offset(lv, (S1583C4*)(S1583C3*)(S1583C2*), 0, "S1583C1");
    check_base_class_offset(lv, (S1583C3*)(S1583C2*), 0, "S1583C1");
    check_base_class_offset(lv, (S1583C2*), 0, "S1583C1");
    check_field_offset(lv, s1583c1f0, ABISELECT(256,184), "S1583C1.s1583c1f0");
    check_field_offset(lv, s1583c1f1, ABISELECT(272,196), "S1583C1.s1583c1f1");
    test_class_info(&lv, &cd_S1583C1);
    dp->~S1583C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1583C1(Test_S1583C1, "S1583C1", ABISELECT(280,200));

#else // __cplusplus

extern void _ZN7S1583C1C1Ev();
extern void _ZN7S1583C1D1Ev();
Name_Map name_map_S1583C1[] = {
  NSPAIR(_ZN7S1583C1C1Ev),
  NSPAIR(_ZN7S1583C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1583C4;
extern VTBL_ENTRY _ZTI7S1583C4[];
extern  VTBL_ENTRY _ZTV7S1583C4[];
extern Class_Descriptor cd_S1583C3;
extern VTBL_ENTRY _ZTI7S1583C3[];
extern  VTBL_ENTRY _ZTV7S1583C3[];
extern Class_Descriptor cd_S1583C2;
extern VTBL_ENTRY _ZTI7S1583C2[];
extern  VTBL_ENTRY _ZTV7S1583C2[];
static Base_Class bases_S1583C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1583C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1583C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1583C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1583C1[];
extern void _ZN7S1583C1D1Ev();
extern void _ZN7S1583C1D0Ev();
extern void _ZN7S1583C42v8Ev();
extern void _ZN7S1583C42v9Ev();
extern void _ZN7S1583C43v10Ev();
extern void _ZN7S1583C43v11Ev();
extern void _ZN7S1583C43v12Ev();
extern void _ZN7S1583C43v13Ev();
extern void _ZN7S1583C43v14Ev();
extern void _ZN7S1583C43v15Ev();
extern void _ZN7S1583C43v16Ev();
extern void _ZN7S1583C43v17Ev();
extern void _ZN7S1583C43v18Ev();
extern void _ZN7S1583C43v19Ev();
extern void _ZN7S1583C43v20Ev();
extern void _ZN7S1583C43v21Ev();
extern void _ZN7S1583C43v22Ev();
extern void _ZN7S1583C43v23Ev();
extern void _ZN7S1583C43v24Ev();
extern void _ZN7S1583C43v25Ev();
extern void _ZN7S1583C43v26Ev();
extern void _ZN7S1583C43v27Ev();
extern void _ZN7S1583C43v28Ev();
extern void _ZN7S1583C43v29Ev();
extern void _ZN7S1583C43v30Ev();
extern void _ZN7S1583C43v31Ev();
extern void _ZN7S1583C43v32Ev();
extern void _ZN7S1583C43v33Ev();
extern void _ZN7S1583C43v34Ev();
extern void _ZN7S1583C43v35Ev();
extern void _ZN7S1583C43v36Ev();
extern void _ZN7S1583C43v37Ev();
extern void _ZN7S1583C43v38Ev();
extern void _ZN7S1583C43v39Ev();
extern void _ZN7S1583C43v40Ev();
extern void _ZN7S1583C43v41Ev();
extern void _ZN7S1583C43v42Ev();
extern void _ZN7S1583C43v43Ev();
extern void _ZN7S1583C43v44Ev();
extern void _ZN7S1583C43v45Ev();
extern void _ZN7S1583C43v46Ev();
extern void _ZN7S1583C43v47Ev();
extern void _ZN7S1583C43v48Ev();
extern void _ZN7S1583C43v49Ev();
extern void _ZN7S1583C43v50Ev();
extern void _ZN7S1583C43v51Ev();
extern void _ZN7S1583C43v52Ev();
extern void _ZN7S1583C43v53Ev();
extern void _ZN7S1583C43v54Ev();
extern void _ZN7S1583C43v55Ev();
extern void _ZN7S1583C43v56Ev();
extern void _ZN7S1583C43v57Ev();
extern void _ZN7S1583C43v58Ev();
extern void _ZN7S1583C43v59Ev();
extern void _ZN7S1583C43v60Ev();
extern void _ZN7S1583C43v61Ev();
extern void _ZN7S1583C43v62Ev();
extern void _ZN7S1583C43v63Ev();
extern void _ZN7S1583C43v64Ev();
extern void _ZN7S1583C43v65Ev();
extern void _ZN7S1583C43v66Ev();
extern void _ZN7S1583C43v67Ev();
extern void _ZN7S1583C43v68Ev();
extern void _ZN7S1583C43v69Ev();
extern void _ZN7S1583C43v70Ev();
extern void _ZN7S1583C43v71Ev();
extern void _ZN7S1583C33v72Ev();
extern void _ZN7S1583C33v73Ev();
extern void _ZN7S1583C33v74Ev();
extern void _ZN7S1583C33v75Ev();
extern void _ZN7S1583C23v76Ev();
extern void _ZN7S1583C23v77Ev();
extern void _ZN7S1583C23v78Ev();
extern void _ZN7S1583C23v79Ev();
extern void _ZN7S1583C23v80Ev();
extern void _ZN7S1583C23v81Ev();
extern void _ZN7S1583C23v82Ev();
extern void _ZN7S1583C23v83Ev();
extern void _ZN7S1583C23v84Ev();
extern void _ZN7S1583C23v85Ev();
extern void _ZN7S1583C23v86Ev();
extern void _ZN7S1583C23v87Ev();
extern void _ZN7S1583C23v88Ev();
extern void _ZN7S1583C23v89Ev();
extern void _ZN7S1583C23v90Ev();
extern void _ZN7S1583C23v91Ev();
extern void _ZN7S1583C12v1Ev();
extern void _ZN7S1583C12v2Ev();
extern void _ZN7S1583C12v3Ev();
extern void _ZN7S1583C12v4Ev();
extern void _ZN7S1583C12v5Ev();
extern void _ZN7S1583C12v6Ev();
extern void _ZN7S1583C12v7Ev();
static  VTBL_ENTRY vtc_S1583C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1583C1[0]),
  (VTBL_ENTRY)&_ZN7S1583C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1583C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1583C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1583C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v24Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v25Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v26Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v27Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v28Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v29Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v30Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v31Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v32Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v33Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v34Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v35Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v36Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v37Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v38Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v39Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v40Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v41Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v42Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v43Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v44Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v45Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v46Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v47Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v48Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v49Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v50Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v51Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v52Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v53Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v54Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v55Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v56Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v57Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v58Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v59Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v60Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v61Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v62Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v63Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v64Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v65Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v66Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v67Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v68Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v69Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v70Ev,
  (VTBL_ENTRY)&_ZN7S1583C43v71Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1583C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v76Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v77Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v78Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v79Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v80Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v81Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v82Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v83Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v84Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v85Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v86Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v87Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v88Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v89Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v90Ev,
  (VTBL_ENTRY)&_ZN7S1583C23v91Ev,
  (VTBL_ENTRY)&_ZN7S1583C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1583C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1583C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1583C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1583C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1583C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1583C12v7Ev,
};
extern VTBL_ENTRY _ZTI7S1583C1[];
extern  VTBL_ENTRY _ZTV7S1583C1[];
Class_Descriptor cd_S1583C1 = {  "S1583C1", // class name
  bases_S1583C1, 3,
  &(vtc_S1583C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(280,200), // object size
  NSPAIRA(_ZTI7S1583C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1583C1),95, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C2_nt  : S685C10_nt {
};
//SIG(-1 S2601C2_nt) C1{ BC2{ m Fi}}



//skip512 S2601C2_nt

#else // __cplusplus

extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
static Base_Class bases_S2601C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2601C2_nt[];
VTBL_ENTRY *P__ZTI10S2601C2_nt = _ZTI10S2601C2_nt; 
Class_Descriptor cd_S2601C2_nt = {  "S2601C2_nt", // class name
  bases_S2601C2_nt, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S2601C2_nt),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C4_nt  {
  virtual  ~S2601C4_nt(); // _ZN10S2601C4_ntD1Ev
  virtual void  v13(); // _ZN10S2601C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2601C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2601C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2601C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2601C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2601C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2601C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2601C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2601C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2601C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2601C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2601C4_nt3v24Ev
  virtual void  v25(); // _ZN10S2601C4_nt3v25Ev
  S2601C4_nt(); // tgen
};
//SIG(-1 S2601C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13}


 S2601C4_nt ::~S2601C4_nt(){ note_dtor("S2601C4_nt", this);}
void  S2601C4_nt ::v13(){vfunc_called(this, "_ZN10S2601C4_nt3v13Ev");}
void  S2601C4_nt ::v14(){vfunc_called(this, "_ZN10S2601C4_nt3v14Ev");}
void  S2601C4_nt ::v15(){vfunc_called(this, "_ZN10S2601C4_nt3v15Ev");}
void  S2601C4_nt ::v16(){vfunc_called(this, "_ZN10S2601C4_nt3v16Ev");}
void  S2601C4_nt ::v17(){vfunc_called(this, "_ZN10S2601C4_nt3v17Ev");}
void  S2601C4_nt ::v18(){vfunc_called(this, "_ZN10S2601C4_nt3v18Ev");}
void  S2601C4_nt ::v19(){vfunc_called(this, "_ZN10S2601C4_nt3v19Ev");}
void  S2601C4_nt ::v20(){vfunc_called(this, "_ZN10S2601C4_nt3v20Ev");}
void  S2601C4_nt ::v21(){vfunc_called(this, "_ZN10S2601C4_nt3v21Ev");}
void  S2601C4_nt ::v22(){vfunc_called(this, "_ZN10S2601C4_nt3v22Ev");}
void  S2601C4_nt ::v23(){vfunc_called(this, "_ZN10S2601C4_nt3v23Ev");}
void  S2601C4_nt ::v24(){vfunc_called(this, "_ZN10S2601C4_nt3v24Ev");}
void  S2601C4_nt ::v25(){vfunc_called(this, "_ZN10S2601C4_nt3v25Ev");}
S2601C4_nt ::S2601C4_nt(){ note_ctor("S2601C4_nt", this);} // tgen

//skip512 S2601C4_nt

#else // __cplusplus

extern void _ZN10S2601C4_ntC1Ev();
extern void _ZN10S2601C4_ntD1Ev();
Name_Map name_map_S2601C4_nt[] = {
  NSPAIR(_ZN10S2601C4_ntC1Ev),
  NSPAIR(_ZN10S2601C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2601C4_nt[];
extern void _ZN10S2601C4_ntD1Ev();
extern void _ZN10S2601C4_ntD0Ev();
extern void _ZN10S2601C4_nt3v13Ev();
extern void _ZN10S2601C4_nt3v14Ev();
extern void _ZN10S2601C4_nt3v15Ev();
extern void _ZN10S2601C4_nt3v16Ev();
extern void _ZN10S2601C4_nt3v17Ev();
extern void _ZN10S2601C4_nt3v18Ev();
extern void _ZN10S2601C4_nt3v19Ev();
extern void _ZN10S2601C4_nt3v20Ev();
extern void _ZN10S2601C4_nt3v21Ev();
extern void _ZN10S2601C4_nt3v22Ev();
extern void _ZN10S2601C4_nt3v23Ev();
extern void _ZN10S2601C4_nt3v24Ev();
extern void _ZN10S2601C4_nt3v25Ev();
static  VTBL_ENTRY vtc_S2601C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2601C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2601C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v25Ev,
};
extern VTBL_ENTRY _ZTI10S2601C4_nt[];
VTBL_ENTRY *P__ZTI10S2601C4_nt = _ZTI10S2601C4_nt; 
extern  VTBL_ENTRY _ZTV10S2601C4_nt[];
Class_Descriptor cd_S2601C4_nt = {  "S2601C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2601C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S2601C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2601C4_nt),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C5  {
  void *s2601c5f0;
  virtual  ~S2601C5(); // _ZN7S2601C5D1Ev
  virtual void  v26(); // _ZN7S2601C53v26Ev
  virtual void  v27(); // _ZN7S2601C53v27Ev
  S2601C5(); // tgen
};
//SIG(-1 S2601C5) C1{ vd v1 v2 Fp}


 S2601C5 ::~S2601C5(){ note_dtor("S2601C5", this);}
void  S2601C5 ::v26(){vfunc_called(this, "_ZN7S2601C53v26Ev");}
void  S2601C5 ::v27(){vfunc_called(this, "_ZN7S2601C53v27Ev");}
S2601C5 ::S2601C5(){ note_ctor("S2601C5", this);} // tgen

static void Test_S2601C5()
{
  extern Class_Descriptor cd_S2601C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S2601C5, buf);
    S2601C5 *dp, &lv = *(dp=new (buf) S2601C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S2601C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C5)");
    check_field_offset(lv, s2601c5f0, ABISELECT(8,4), "S2601C5.s2601c5f0");
    test_class_info(&lv, &cd_S2601C5);
    dp->~S2601C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2601C5(Test_S2601C5, "S2601C5", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S2601C5C1Ev();
extern void _ZN7S2601C5D1Ev();
Name_Map name_map_S2601C5[] = {
  NSPAIR(_ZN7S2601C5C1Ev),
  NSPAIR(_ZN7S2601C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2601C5[];
extern void _ZN7S2601C5D1Ev();
extern void _ZN7S2601C5D0Ev();
extern void _ZN7S2601C53v26Ev();
extern void _ZN7S2601C53v27Ev();
static  VTBL_ENTRY vtc_S2601C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2601C5[0]),
  (VTBL_ENTRY)&_ZN7S2601C5D1Ev,
  (VTBL_ENTRY)&_ZN7S2601C5D0Ev,
  (VTBL_ENTRY)&_ZN7S2601C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2601C53v27Ev,
};
extern VTBL_ENTRY _ZTI7S2601C5[];
extern  VTBL_ENTRY _ZTV7S2601C5[];
Class_Descriptor cd_S2601C5 = {  "S2601C5", // class name
  0,0,//no base classes
  &(vtc_S2601C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S2601C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2601C5),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C8_nt  {
  void *s2601c8f0;
  int s2601c8f1[4];
  void  mf2601c8(); // _ZN10S2601C8_nt8mf2601c8Ev
};
//SIG(-1 S2601C8_nt) C1{ m Fp Fi[4]}


void  S2601C8_nt ::mf2601c8(){}

//skip512 S2601C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C7_nt  {
  ::S2601C8_nt s2601c7f0;
  void  mf2601c7(); // _ZN10S2601C7_nt8mf2601c7Ev
};
//SIG(-1 S2601C7_nt) C1{ m FC2{ m Fp Fi[4]}}


void  S2601C7_nt ::mf2601c7(){}

//skip512 S2601C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C6_nt  {
  ::S2601C7_nt s2601c6f0;
  void  mf2601c6(); // _ZN10S2601C6_nt8mf2601c6Ev
};
//SIG(-1 S2601C6_nt) C1{ m FC2{ m FC3{ m Fp Fi[4]}}}


void  S2601C6_nt ::mf2601c6(){}

//skip512 S2601C6_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S2601C6_nt[];
VTBL_ENTRY *P__ZTI10S2601C6_nt = _ZTI10S2601C6_nt; 
Class_Descriptor cd_S2601C6_nt = {  "S2601C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  NSPAIRA(_ZTI10S2601C6_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C9_nt  {
  void *s2601c9f0;
  void  mf2601c9(); // _ZN10S2601C9_nt8mf2601c9Ev
};
//SIG(-1 S2601C9_nt) C1{ m Fp}


void  S2601C9_nt ::mf2601c9(){}

//skip512 S2601C9_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C11_nt  {
  ::S2601C9_nt s2601c11f0;
  void  mf2601c11(); // _ZN11S2601C11_nt9mf2601c11Ev
};
//SIG(-1 S2601C11_nt) C1{ m FC2{ m Fp}}


void  S2601C11_nt ::mf2601c11(){}

//skip512 S2601C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C10_nt  {
  ::S2601C11_nt s2601c10f0;
  unsigned char s2601c10f1:1;
  unsigned char s2601c10f2:1;
  int s2601c10f3[10];
  void  mf2601c10(); // _ZN11S2601C10_nt9mf2601c10Ev
};
//SIG(-1 S2601C10_nt) C1{ m FC2{ m FC3{ m Fp}} Fc:1 Fc:1 Fi[10]}


void  S2601C10_nt ::mf2601c10(){}

//skip512 S2601C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C15  {
  void *s2601c15f0;
  void  mf2601c15(); // _ZN8S2601C159mf2601c15Ev
};
//SIG(-1 S2601C15) C1{ m Fp}


void  S2601C15 ::mf2601c15(){}

static void Test_S2601C15()
{
  {
    init_simple_test("S2601C15");
    S2601C15 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2601C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C15)");
    check_field_offset(lv, s2601c15f0, 0, "S2601C15.s2601c15f0");
  }
}
static Arrange_To_Call_Me vS2601C15(Test_S2601C15, "S2601C15", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C17  {
  void *s2601c17f0;
  void  mf2601c17(); // _ZN8S2601C179mf2601c17Ev
};
//SIG(-1 S2601C17) C1{ m Fp}


void  S2601C17 ::mf2601c17(){}

static void Test_S2601C17()
{
  {
    init_simple_test("S2601C17");
    S2601C17 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2601C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C17)");
    check_field_offset(lv, s2601c17f0, 0, "S2601C17.s2601c17f0");
  }
}
static Arrange_To_Call_Me vS2601C17(Test_S2601C17, "S2601C17", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C19  {
  void *s2601c19f0;
  void  mf2601c19(); // _ZN8S2601C199mf2601c19Ev
};
//SIG(-1 S2601C19) C1{ m Fp}


void  S2601C19 ::mf2601c19(){}

static void Test_S2601C19()
{
  {
    init_simple_test("S2601C19");
    S2601C19 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2601C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C19)");
    check_field_offset(lv, s2601c19f0, 0, "S2601C19.s2601c19f0");
  }
}
static Arrange_To_Call_Me vS2601C19(Test_S2601C19, "S2601C19", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C21  {
  void *s2601c21f0;
  void  mf2601c21(); // _ZN8S2601C219mf2601c21Ev
};
//SIG(-1 S2601C21) C1{ m Fp}


void  S2601C21 ::mf2601c21(){}

static void Test_S2601C21()
{
  {
    init_simple_test("S2601C21");
    S2601C21 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2601C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C21)");
    check_field_offset(lv, s2601c21f0, 0, "S2601C21.s2601c21f0");
  }
}
static Arrange_To_Call_Me vS2601C21(Test_S2601C21, "S2601C21", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C23  {
  void *s2601c23f0;
  void  mf2601c23(); // _ZN8S2601C239mf2601c23Ev
};
//SIG(-1 S2601C23) C1{ m Fp}


void  S2601C23 ::mf2601c23(){}

static void Test_S2601C23()
{
  {
    init_simple_test("S2601C23");
    S2601C23 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2601C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C23)");
    check_field_offset(lv, s2601c23f0, 0, "S2601C23.s2601c23f0");
  }
}
static Arrange_To_Call_Me vS2601C23(Test_S2601C23, "S2601C23", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C27_nt  {
  ::S2601C11_nt s2601c27f0;
  void  mf2601c27(); // _ZN11S2601C27_nt9mf2601c27Ev
};
//SIG(-1 S2601C27_nt) C1{ m FC2{ m FC3{ m Fp}}}


void  S2601C27_nt ::mf2601c27(){}

//skip512 S2601C27_nt

#else // __cplusplus

Class_Descriptor cd_S2601C27_nt = {  "S2601C27_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C28  {
  void *s2601c28f0;
  void  mf2601c28(); // _ZN8S2601C289mf2601c28Ev
};
//SIG(-1 S2601C28) C1{ m Fp}


void  S2601C28 ::mf2601c28(){}

static void Test_S2601C28()
{
  {
    init_simple_test("S2601C28");
    S2601C28 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2601C28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C28)");
    check_field_offset(lv, s2601c28f0, 0, "S2601C28.s2601c28f0");
  }
}
static Arrange_To_Call_Me vS2601C28(Test_S2601C28, "S2601C28", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C25  {
  ::S2601C23 s2601c25f0;
  ::S2601C27_nt s2601c25f1;
  ::S2601C28 s2601c25f2;
  void  mf2601c25(); // _ZN8S2601C259mf2601c25Ev
};
//SIG(-1 S2601C25) C1{ m FC2{ m Fp} FC3{ m FC4{ m FC5{ m Fp}}} FC6{ m Fp}}


void  S2601C25 ::mf2601c25(){}

static void Test_S2601C25()
{
  {
    init_simple_test("S2601C25");
    S2601C25 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S2601C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C25)");
    check_field_offset(lv, s2601c25f0, 0, "S2601C25.s2601c25f0");
    check_field_offset(lv, s2601c25f1, ABISELECT(8,4), "S2601C25.s2601c25f1");
    check_field_offset(lv, s2601c25f2, ABISELECT(16,8), "S2601C25.s2601c25f2");
  }
}
static Arrange_To_Call_Me vS2601C25(Test_S2601C25, "S2601C25", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C31_nt  {
  void *s2601c31f0;
  int s2601c31f1;
  void  mf2601c31(); // _ZN11S2601C31_nt9mf2601c31Ev
};
//SIG(-1 S2601C31_nt) C1{ m Fp Fi}


void  S2601C31_nt ::mf2601c31(){}

//skip512 S2601C31_nt

#else // __cplusplus

Class_Descriptor cd_S2601C31_nt = {  "S2601C31_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C32_nt  {
  int s2601c32f0[3];
};
//SIG(-1 S2601C32_nt) C1{ Fi[3]}



//skip512 S2601C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C30  : S2601C31_nt {
  ::S2601C32_nt s2601c30f0;
};
//SIG(-1 S2601C30) C1{ BC2{ m Fp Fi} FC3{ Fi[3]}}



static void Test_S2601C30()
{
  extern Class_Descriptor cd_S2601C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S2601C30, buf);
    S2601C30 &lv = *(new (buf) S2601C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S2601C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C30)");
    check_base_class_offset(lv, (S2601C31_nt*), 0, "S2601C30");
    check_field_offset(lv, s2601c30f0, ABISELECT(16,8), "S2601C30.s2601c30f0");
    test_class_info(&lv, &cd_S2601C30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2601C30(Test_S2601C30, "S2601C30", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd_S2601C31_nt;
static Base_Class bases_S2601C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2601C31_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2601C30 = {  "S2601C30", // class name
  bases_S2601C30, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C29  {
  int s2601c29f0;
  ::S2601C30 s2601c29f1;
  void  mf2601c29(); // _ZN8S2601C299mf2601c29Ev
};
//SIG(-1 S2601C29) C1{ m Fi FC2{ BC3{ m Fp Fi} FC4{ Fi[3]}}}


void  S2601C29 ::mf2601c29(){}

static void Test_S2601C29()
{
  {
    init_simple_test("S2601C29");
    S2601C29 lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S2601C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C29)");
    check_field_offset(lv, s2601c29f0, 0, "S2601C29.s2601c29f0");
    check_field_offset(lv, s2601c29f1, ABISELECT(8,4), "S2601C29.s2601c29f1");
  }
}
static Arrange_To_Call_Me vS2601C29(Test_S2601C29, "S2601C29", ABISELECT(40,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C24  {
  ::S2601C25 s2601c24f0;
  ::S2601C29 s2601c24f1;
  void  mf2601c24(); // _ZN8S2601C249mf2601c24Ev
};
//SIG(-1 S2601C24) C1{ m FC2{ m FC3{ m Fp} FC4{ m FC5{ m FC6{ m Fp}}} FC7{ m Fp}} FC8{ m Fi FC9{ BC10{ m Fp Fi} FC11{ Fi[3]}}}}


void  S2601C24 ::mf2601c24(){}

static void Test_S2601C24()
{
  {
    init_simple_test("S2601C24");
    S2601C24 lv;
    check2(sizeof(lv), ABISELECT(64,36), "sizeof(S2601C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C24)");
    check_field_offset(lv, s2601c24f0, 0, "S2601C24.s2601c24f0");
    check_field_offset(lv, s2601c24f1, ABISELECT(24,12), "S2601C24.s2601c24f1");
  }
}
static Arrange_To_Call_Me vS2601C24(Test_S2601C24, "S2601C24", ABISELECT(64,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C34  {
  void *s2601c34f0;
  void  mf2601c34(); // _ZN8S2601C349mf2601c34Ev
};
//SIG(-1 S2601C34) C1{ m Fp}


void  S2601C34 ::mf2601c34(){}

static void Test_S2601C34()
{
  {
    init_simple_test("S2601C34");
    S2601C34 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2601C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C34)");
    check_field_offset(lv, s2601c34f0, 0, "S2601C34.s2601c34f0");
  }
}
static Arrange_To_Call_Me vS2601C34(Test_S2601C34, "S2601C34", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2601C1  : S2601C2_nt , S2601C4_nt , S2601C5 , S2601C6_nt {
  ::S2601C9_nt s2601c1f0;
  ::S2601C10_nt s2601c1f1;
  char s2601c1f2[2];
  ::S2601C7_nt s2601c1f3;
  ::S2601C15 s2601c1f4;
  ::S2601C15 s2601c1f5;
  ::S2601C17 s2601c1f6;
  ::S2601C17 s2601c1f7;
  ::S2601C19 s2601c1f8;
  ::S2601C19 s2601c1f9;
  ::S2601C19 s2601c1f10;
  ::S2601C19 s2601c1f11;
  ::S2601C19 s2601c1f12;
  ::S2601C19 s2601c1f13;
  ::S2601C19 s2601c1f14;
  ::S2601C21 s2601c1f15;
  ::S2601C21 s2601c1f16;
  ::S2601C23 s2601c1f17;
  ::S2601C24 s2601c1f18;
  ::S2601C11_nt s2601c1f19;
  ::S2601C11_nt s2601c1f20;
  ::S2601C28 s2601c1f21;
  ::S2601C28 s2601c1f22;
  ::S2601C34 s2601c1f23;
  virtual  ~S2601C1(); // _ZN7S2601C1D1Ev
  virtual void  v1(); // _ZN7S2601C12v1Ev
  virtual void  v2(); // _ZN7S2601C12v2Ev
  virtual void  v3(); // _ZN7S2601C12v3Ev
  virtual void  v4(); // _ZN7S2601C12v4Ev
  virtual void  v5(); // _ZN7S2601C12v5Ev
  virtual void  v6(); // _ZN7S2601C12v6Ev
  virtual void  v7(); // _ZN7S2601C12v7Ev
  virtual void  v8(); // _ZN7S2601C12v8Ev
  virtual void  v9(); // _ZN7S2601C12v9Ev
  virtual void  v10(); // _ZN7S2601C13v10Ev
  virtual void  v11(); // _ZN7S2601C13v11Ev
  virtual void  v12(); // _ZN7S2601C13v12Ev
  S2601C1(); // tgen
};
//SIG(1 S2601C1) C1{ BC2{ BC3{ m Fi}} BC4{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25} BC5{ vd v26 v27 Fp} BC6{ m FC7{ m FC8{ m Fp Fi[4]}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 FC9{ m Fp} FC10{ m FC11{ m FC9} Fc:1 Fc:1 Fi[10]} Fc[2] FC7 FC12{ m Fp} FC12 FC13{ m Fp} FC13 FC14{ m Fp} FC14 FC14 FC14 FC14 FC14 FC14 FC15{ m Fp} FC15 FC16{ m Fp} FC17{ m FC18{ m FC16 FC19{ m FC11} FC20{ m Fp}} FC21{ m Fi FC22{ BC23{ m Fp Fi} FC24{ Fi[3]}}}} FC11 FC11 FC20 FC20 FC25{ m Fp}}


 S2601C1 ::~S2601C1(){ note_dtor("S2601C1", this);}
void  S2601C1 ::v1(){vfunc_called(this, "_ZN7S2601C12v1Ev");}
void  S2601C1 ::v2(){vfunc_called(this, "_ZN7S2601C12v2Ev");}
void  S2601C1 ::v3(){vfunc_called(this, "_ZN7S2601C12v3Ev");}
void  S2601C1 ::v4(){vfunc_called(this, "_ZN7S2601C12v4Ev");}
void  S2601C1 ::v5(){vfunc_called(this, "_ZN7S2601C12v5Ev");}
void  S2601C1 ::v6(){vfunc_called(this, "_ZN7S2601C12v6Ev");}
void  S2601C1 ::v7(){vfunc_called(this, "_ZN7S2601C12v7Ev");}
void  S2601C1 ::v8(){vfunc_called(this, "_ZN7S2601C12v8Ev");}
void  S2601C1 ::v9(){vfunc_called(this, "_ZN7S2601C12v9Ev");}
void  S2601C1 ::v10(){vfunc_called(this, "_ZN7S2601C13v10Ev");}
void  S2601C1 ::v11(){vfunc_called(this, "_ZN7S2601C13v11Ev");}
void  S2601C1 ::v12(){vfunc_called(this, "_ZN7S2601C13v12Ev");}
S2601C1 ::S2601C1(){ note_ctor("S2601C1", this);} // tgen

static void Test_S2601C1()
{
  extern Class_Descriptor cd_S2601C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(47,57)];
    init_test(&cd_S2601C1, buf);
    S2601C1 *dp, &lv = *(dp=new (buf) S2601C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(368,224), "sizeof(S2601C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2601C1)");
    check_base_class_offset(lv, (S685C10_nt*)(S2601C2_nt*), ABISELECT(8,4), "S2601C1");
    check_base_class_offset(lv, (S2601C2_nt*), ABISELECT(8,4), "S2601C1");
    check_base_class_offset(lv, (S2601C4_nt*), 0, "S2601C1");
    check_base_class_offset(lv, (S2601C5*), ABISELECT(16,8), "S2601C1");
    check_base_class_offset(lv, (S2601C6_nt*), ABISELECT(32,16), "S2601C1");
    check_field_offset(lv, s2601c1f0, ABISELECT(56,36), "S2601C1.s2601c1f0");
    check_field_offset(lv, s2601c1f1, ABISELECT(64,40), "S2601C1.s2601c1f1");
    check_field_offset(lv, s2601c1f2, ABISELECT(120,88), "S2601C1.s2601c1f2");
    check_field_offset(lv, s2601c1f3, ABISELECT(128,92), "S2601C1.s2601c1f3");
    check_field_offset(lv, s2601c1f4, ABISELECT(152,112), "S2601C1.s2601c1f4");
    check_field_offset(lv, s2601c1f5, ABISELECT(160,116), "S2601C1.s2601c1f5");
    check_field_offset(lv, s2601c1f6, ABISELECT(168,120), "S2601C1.s2601c1f6");
    check_field_offset(lv, s2601c1f7, ABISELECT(176,124), "S2601C1.s2601c1f7");
    check_field_offset(lv, s2601c1f8, ABISELECT(184,128), "S2601C1.s2601c1f8");
    check_field_offset(lv, s2601c1f9, ABISELECT(192,132), "S2601C1.s2601c1f9");
    check_field_offset(lv, s2601c1f10, ABISELECT(200,136), "S2601C1.s2601c1f10");
    check_field_offset(lv, s2601c1f11, ABISELECT(208,140), "S2601C1.s2601c1f11");
    check_field_offset(lv, s2601c1f12, ABISELECT(216,144), "S2601C1.s2601c1f12");
    check_field_offset(lv, s2601c1f13, ABISELECT(224,148), "S2601C1.s2601c1f13");
    check_field_offset(lv, s2601c1f14, ABISELECT(232,152), "S2601C1.s2601c1f14");
    check_field_offset(lv, s2601c1f15, ABISELECT(240,156), "S2601C1.s2601c1f15");
    check_field_offset(lv, s2601c1f16, ABISELECT(248,160), "S2601C1.s2601c1f16");
    check_field_offset(lv, s2601c1f17, ABISELECT(256,164), "S2601C1.s2601c1f17");
    check_field_offset(lv, s2601c1f18, ABISELECT(264,168), "S2601C1.s2601c1f18");
    check_field_offset(lv, s2601c1f19, ABISELECT(328,204), "S2601C1.s2601c1f19");
    check_field_offset(lv, s2601c1f20, ABISELECT(336,208), "S2601C1.s2601c1f20");
    check_field_offset(lv, s2601c1f21, ABISELECT(344,212), "S2601C1.s2601c1f21");
    check_field_offset(lv, s2601c1f22, ABISELECT(352,216), "S2601C1.s2601c1f22");
    check_field_offset(lv, s2601c1f23, ABISELECT(360,220), "S2601C1.s2601c1f23");
    test_class_info(&lv, &cd_S2601C1);
    dp->~S2601C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2601C1(Test_S2601C1, "S2601C1", ABISELECT(368,224));

#else // __cplusplus

extern void _ZN7S2601C1C1Ev();
extern void _ZN7S2601C1D1Ev();
Name_Map name_map_S2601C1[] = {
  NSPAIR(_ZN7S2601C1C1Ev),
  NSPAIR(_ZN7S2601C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S2601C2_nt;
extern VTBL_ENTRY _ZTI10S2601C2_nt[];
extern Class_Descriptor cd_S2601C4_nt;
extern VTBL_ENTRY _ZTI10S2601C4_nt[];
extern  VTBL_ENTRY _ZTV10S2601C4_nt[];
extern Class_Descriptor cd_S2601C5;
extern VTBL_ENTRY _ZTI7S2601C5[];
extern  VTBL_ENTRY _ZTV7S2601C5[];
extern Class_Descriptor cd_S2601C6_nt;
extern VTBL_ENTRY _ZTI10S2601C6_nt[];
static Base_Class bases_S2601C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C10_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2601C2_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2601C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2601C5,    ABISELECT(16,8), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2601C6_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2601C1[];
extern void _ZN7S2601C1D1Ev();
extern void _ZN7S2601C1D0Ev();
extern void _ZN10S2601C4_nt3v13Ev();
extern void _ZN10S2601C4_nt3v14Ev();
extern void _ZN10S2601C4_nt3v15Ev();
extern void _ZN10S2601C4_nt3v16Ev();
extern void _ZN10S2601C4_nt3v17Ev();
extern void _ZN10S2601C4_nt3v18Ev();
extern void _ZN10S2601C4_nt3v19Ev();
extern void _ZN10S2601C4_nt3v20Ev();
extern void _ZN10S2601C4_nt3v21Ev();
extern void _ZN10S2601C4_nt3v22Ev();
extern void _ZN10S2601C4_nt3v23Ev();
extern void _ZN10S2601C4_nt3v24Ev();
extern void _ZN10S2601C4_nt3v25Ev();
extern void _ZN7S2601C12v1Ev();
extern void _ZN7S2601C12v2Ev();
extern void _ZN7S2601C12v3Ev();
extern void _ZN7S2601C12v4Ev();
extern void _ZN7S2601C12v5Ev();
extern void _ZN7S2601C12v6Ev();
extern void _ZN7S2601C12v7Ev();
extern void _ZN7S2601C12v8Ev();
extern void _ZN7S2601C12v9Ev();
extern void _ZN7S2601C13v10Ev();
extern void _ZN7S2601C13v11Ev();
extern void _ZN7S2601C13v12Ev();
extern void ABISELECT(_ZThn16_N7S2601C1D1Ev,_ZThn8_N7S2601C1D1Ev)();
extern void ABISELECT(_ZThn16_N7S2601C1D0Ev,_ZThn8_N7S2601C1D0Ev)();
extern void _ZN7S2601C53v26Ev();
extern void _ZN7S2601C53v27Ev();
static  VTBL_ENTRY vtc_S2601C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2601C1[0]),
  (VTBL_ENTRY)&_ZN7S2601C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2601C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2601C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN7S2601C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2601C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2601C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2601C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2601C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2601C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2601C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2601C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2601C12v9Ev,
  (VTBL_ENTRY)&_ZN7S2601C13v10Ev,
  (VTBL_ENTRY)&_ZN7S2601C13v11Ev,
  (VTBL_ENTRY)&_ZN7S2601C13v12Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S2601C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S2601C1D1Ev,_ZThn8_N7S2601C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S2601C1D0Ev,_ZThn8_N7S2601C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2601C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2601C53v27Ev,
};
extern VTBL_ENTRY _ZTI7S2601C1[];
extern  VTBL_ENTRY _ZTV7S2601C1[];
Class_Descriptor cd_S2601C1 = {  "S2601C1", // class name
  bases_S2601C1, 5,
  &(vtc_S2601C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(368,224), // object size
  NSPAIRA(_ZTI7S2601C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S2601C1),35, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2602C2  : S685C10_nt {
};
//SIG(-1 S2602C2) C1{ BC2{ m Fi}}



static void Test_S2602C2()
{
  extern Class_Descriptor cd_S2602C2;
  void *lvp;
  {
    int buf[2];
    init_test(&cd_S2602C2, buf);
    S2602C2 &lv = *(new (buf) S2602C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(S2602C2)");
    check2(__alignof__(lv), 4, "__alignof__(S2602C2)");
    check_base_class_offset(lv, (S685C10_nt*), 0, "S2602C2");
    test_class_info(&lv, &cd_S2602C2);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2602C2(Test_S2602C2, "S2602C2", 4);

#else // __cplusplus

extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
static Base_Class bases_S2602C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2602C2[];
Class_Descriptor cd_S2602C2 = {  "S2602C2", // class name
  bases_S2602C2, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI7S2602C2),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2602C4  {
  virtual  ~S2602C4(); // _ZN7S2602C4D1Ev
  virtual void  v13(); // _ZN7S2602C43v13Ev
  virtual void  v14(); // _ZN7S2602C43v14Ev
  virtual void  v15(); // _ZN7S2602C43v15Ev
  virtual void  v16(); // _ZN7S2602C43v16Ev
  virtual void  v17(); // _ZN7S2602C43v17Ev
  virtual void  v18(); // _ZN7S2602C43v18Ev
  virtual void  v19(); // _ZN7S2602C43v19Ev
  virtual void  v20(); // _ZN7S2602C43v20Ev
  virtual void  v21(); // _ZN7S2602C43v21Ev
  virtual void  v22(); // _ZN7S2602C43v22Ev
  virtual void  v23(); // _ZN7S2602C43v23Ev
  virtual void  v24(); // _ZN7S2602C43v24Ev
  virtual void  v25(); // _ZN7S2602C43v25Ev
  S2602C4(); // tgen
};
//SIG(-1 S2602C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13}


 S2602C4 ::~S2602C4(){ note_dtor("S2602C4", this);}
void  S2602C4 ::v13(){vfunc_called(this, "_ZN7S2602C43v13Ev");}
void  S2602C4 ::v14(){vfunc_called(this, "_ZN7S2602C43v14Ev");}
void  S2602C4 ::v15(){vfunc_called(this, "_ZN7S2602C43v15Ev");}
void  S2602C4 ::v16(){vfunc_called(this, "_ZN7S2602C43v16Ev");}
void  S2602C4 ::v17(){vfunc_called(this, "_ZN7S2602C43v17Ev");}
void  S2602C4 ::v18(){vfunc_called(this, "_ZN7S2602C43v18Ev");}
void  S2602C4 ::v19(){vfunc_called(this, "_ZN7S2602C43v19Ev");}
void  S2602C4 ::v20(){vfunc_called(this, "_ZN7S2602C43v20Ev");}
void  S2602C4 ::v21(){vfunc_called(this, "_ZN7S2602C43v21Ev");}
void  S2602C4 ::v22(){vfunc_called(this, "_ZN7S2602C43v22Ev");}
void  S2602C4 ::v23(){vfunc_called(this, "_ZN7S2602C43v23Ev");}
void  S2602C4 ::v24(){vfunc_called(this, "_ZN7S2602C43v24Ev");}
void  S2602C4 ::v25(){vfunc_called(this, "_ZN7S2602C43v25Ev");}
S2602C4 ::S2602C4(){ note_ctor("S2602C4", this);} // tgen

static void Test_S2602C4()
{
  extern Class_Descriptor cd_S2602C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2602C4, buf);
    S2602C4 *dp, &lv = *(dp=new (buf) S2602C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2602C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2602C4)");
    test_class_info(&lv, &cd_S2602C4);
    dp->~S2602C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2602C4(Test_S2602C4, "S2602C4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S2602C4C1Ev();
extern void _ZN7S2602C4D1Ev();
Name_Map name_map_S2602C4[] = {
  NSPAIR(_ZN7S2602C4C1Ev),
  NSPAIR(_ZN7S2602C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2602C4[];
extern void _ZN7S2602C4D1Ev();
extern void _ZN7S2602C4D0Ev();
extern void _ZN7S2602C43v13Ev();
extern void _ZN7S2602C43v14Ev();
extern void _ZN7S2602C43v15Ev();
extern void _ZN7S2602C43v16Ev();
extern void _ZN7S2602C43v17Ev();
extern void _ZN7S2602C43v18Ev();
extern void _ZN7S2602C43v19Ev();
extern void _ZN7S2602C43v20Ev();
extern void _ZN7S2602C43v21Ev();
extern void _ZN7S2602C43v22Ev();
extern void _ZN7S2602C43v23Ev();
extern void _ZN7S2602C43v24Ev();
extern void _ZN7S2602C43v25Ev();
static  VTBL_ENTRY vtc_S2602C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2602C4[0]),
  (VTBL_ENTRY)&_ZN7S2602C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2602C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v19Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v20Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v21Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v22Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v23Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v24Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v25Ev,
};
extern VTBL_ENTRY _ZTI7S2602C4[];
extern  VTBL_ENTRY _ZTV7S2602C4[];
Class_Descriptor cd_S2602C4 = {  "S2602C4", // class name
  0,0,//no base classes
  &(vtc_S2602C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S2602C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2602C4),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2602C5  {
  void *s2602c5f0;
  virtual  ~S2602C5(); // _ZN7S2602C5D1Ev
  virtual void  v26(); // _ZN7S2602C53v26Ev
  virtual void  v27(); // _ZN7S2602C53v27Ev
  S2602C5(); // tgen
};
//SIG(-1 S2602C5) C1{ vd v1 v2 Fp}


 S2602C5 ::~S2602C5(){ note_dtor("S2602C5", this);}
void  S2602C5 ::v26(){vfunc_called(this, "_ZN7S2602C53v26Ev");}
void  S2602C5 ::v27(){vfunc_called(this, "_ZN7S2602C53v27Ev");}
S2602C5 ::S2602C5(){ note_ctor("S2602C5", this);} // tgen

static void Test_S2602C5()
{
  extern Class_Descriptor cd_S2602C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S2602C5, buf);
    S2602C5 *dp, &lv = *(dp=new (buf) S2602C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S2602C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2602C5)");
    check_field_offset(lv, s2602c5f0, ABISELECT(8,4), "S2602C5.s2602c5f0");
    test_class_info(&lv, &cd_S2602C5);
    dp->~S2602C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2602C5(Test_S2602C5, "S2602C5", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S2602C5C1Ev();
extern void _ZN7S2602C5D1Ev();
Name_Map name_map_S2602C5[] = {
  NSPAIR(_ZN7S2602C5C1Ev),
  NSPAIR(_ZN7S2602C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2602C5[];
extern void _ZN7S2602C5D1Ev();
extern void _ZN7S2602C5D0Ev();
extern void _ZN7S2602C53v26Ev();
extern void _ZN7S2602C53v27Ev();
static  VTBL_ENTRY vtc_S2602C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2602C5[0]),
  (VTBL_ENTRY)&_ZN7S2602C5D1Ev,
  (VTBL_ENTRY)&_ZN7S2602C5D0Ev,
  (VTBL_ENTRY)&_ZN7S2602C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2602C53v27Ev,
};
extern VTBL_ENTRY _ZTI7S2602C5[];
extern  VTBL_ENTRY _ZTV7S2602C5[];
Class_Descriptor cd_S2602C5 = {  "S2602C5", // class name
  0,0,//no base classes
  &(vtc_S2602C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S2602C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2602C5),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2602C22  {
  void *s2602c22f0;
  void  mf2602c22(); // _ZN8S2602C229mf2602c22Ev
};
//SIG(-1 S2602C22) C1{ m Fp}


void  S2602C22 ::mf2602c22(){}

static void Test_S2602C22()
{
  {
    init_simple_test("S2602C22");
    S2602C22 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2602C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2602C22)");
    check_field_offset(lv, s2602c22f0, 0, "S2602C22.s2602c22f0");
  }
}
static Arrange_To_Call_Me vS2602C22(Test_S2602C22, "S2602C22", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2602C32  {
  __tsi64 s2602c32f0[3];
};
//SIG(-1 S2602C32) C1{ FL[3]}



static void Test_S2602C32()
{
  {
    init_simple_test("S2602C32");
    S2602C32 lv;
    check2(sizeof(lv), 24, "sizeof(S2602C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2602C32)");
    check_field_offset(lv, s2602c32f0, 0, "S2602C32.s2602c32f0");
  }
}
static Arrange_To_Call_Me vS2602C32(Test_S2602C32, "S2602C32", 24);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2602C30  : S2601C31_nt {
  ::S2602C32 s2602c30f0;
};
//SIG(-1 S2602C30) C1{ BC2{ m Fp Fi} FC3{ FL[3]}}



static void Test_S2602C30()
{
  extern Class_Descriptor cd_S2602C30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd_S2602C30, buf);
    S2602C30 &lv = *(new (buf) S2602C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(S2602C30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2602C30)");
    check_base_class_offset(lv, (S2601C31_nt*), 0, "S2602C30");
    check_field_offset(lv, s2602c30f0, ABISELECT(16,8), "S2602C30.s2602c30f0");
    test_class_info(&lv, &cd_S2602C30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2602C30(Test_S2602C30, "S2602C30", ABISELECT(40,32));

#else // __cplusplus

extern Class_Descriptor cd_S2601C31_nt;
static Base_Class bases_S2602C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2601C31_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2602C30 = {  "S2602C30", // class name
  bases_S2602C30, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,32), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2602C29  {
  int s2602c29f0;
  ::S2602C30 s2602c29f1;
  void  mf2602c29(); // _ZN8S2602C299mf2602c29Ev
};
//SIG(-1 S2602C29) C1{ m Fi FC2{ BC3{ m Fp Fi} FC4{ FL[3]}}}


void  S2602C29 ::mf2602c29(){}

static void Test_S2602C29()
{
  {
    init_simple_test("S2602C29");
    S2602C29 lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(S2602C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2602C29)");
    check_field_offset(lv, s2602c29f0, 0, "S2602C29.s2602c29f0");
    check_field_offset(lv, s2602c29f1, ABISELECT(8,4), "S2602C29.s2602c29f1");
  }
}
static Arrange_To_Call_Me vS2602C29(Test_S2602C29, "S2602C29", ABISELECT(48,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2602C24  {
  ::S2601C25 s2602c24f0;
  ::S2602C29 s2602c24f1;
  void  mf2602c24(); // _ZN8S2602C249mf2602c24Ev
};
//SIG(-1 S2602C24) C1{ m FC2{ m FC3{ m Fp} FC4{ m FC5{ m FC6{ m Fp}}} FC7{ m Fp}} FC8{ m Fi FC9{ BC10{ m Fp Fi} FC11{ FL[3]}}}}


void  S2602C24 ::mf2602c24(){}

static void Test_S2602C24()
{
  {
    init_simple_test("S2602C24");
    S2602C24 lv;
    check2(sizeof(lv), ABISELECT(72,48), "sizeof(S2602C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2602C24)");
    check_field_offset(lv, s2602c24f0, 0, "S2602C24.s2602c24f0");
    check_field_offset(lv, s2602c24f1, ABISELECT(24,12), "S2602C24.s2602c24f1");
  }
}
static Arrange_To_Call_Me vS2602C24(Test_S2602C24, "S2602C24", ABISELECT(72,48));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2602C33  {
  void *s2602c33f0;
  void  mf2602c33(); // _ZN8S2602C339mf2602c33Ev
};
//SIG(-1 S2602C33) C1{ m Fp}


void  S2602C33 ::mf2602c33(){}

static void Test_S2602C33()
{
  {
    init_simple_test("S2602C33");
    S2602C33 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2602C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2602C33)");
    check_field_offset(lv, s2602c33f0, 0, "S2602C33.s2602c33f0");
  }
}
static Arrange_To_Call_Me vS2602C33(Test_S2602C33, "S2602C33", ABISELECT(8,4));

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S2602C33[];
VTBL_ENTRY *P__ZTI8S2602C33 = _ZTI8S2602C33; 
Class_Descriptor cd_S2602C33 = {  "S2602C33", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2602C33),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2602C1  : S2602C2 , S2602C4 , S2602C5 , S2601C6_nt {
  ::S2601C34 s2602c1f0;
  ::S2601C10_nt s2602c1f1;
  char s2602c1f2[2];
  ::S2601C7_nt s2602c1f3;
  ::S2601C28 s2602c1f4;
  ::S2601C23 s2602c1f5;
  ::S2601C21 s2602c1f6;
  ::S2601C19 s2602c1f7;
  ::S2601C17 s2602c1f8;
  ::S2601C17 s2602c1f9;
  ::S2601C17 s2602c1f10;
  ::S2601C17 s2602c1f11;
  ::S2601C17 s2602c1f12;
  ::S2601C17 s2602c1f13;
  ::S2601C15 s2602c1f14;
  ::S2601C9_nt s2602c1f15;
  ::S2602C22 s2602c1f16;
  ::S2602C22 s2602c1f17;
  ::S2602C24 s2602c1f18;
  ::S2601C11_nt s2602c1f19;
  ::S2601C11_nt s2602c1f20;
  ::S2602C33 s2602c1f21;
  ::S2602C33 s2602c1f22;
  ::S2602C33 s2602c1f23;
  virtual  ~S2602C1(); // _ZN7S2602C1D1Ev
  virtual void  v1(); // _ZN7S2602C12v1Ev
  virtual void  v2(); // _ZN7S2602C12v2Ev
  virtual void  v3(); // _ZN7S2602C12v3Ev
  virtual void  v4(); // _ZN7S2602C12v4Ev
  virtual void  v5(); // _ZN7S2602C12v5Ev
  virtual void  v6(); // _ZN7S2602C12v6Ev
  virtual void  v7(); // _ZN7S2602C12v7Ev
  virtual void  v8(); // _ZN7S2602C12v8Ev
  virtual void  v9(); // _ZN7S2602C12v9Ev
  virtual void  v10(); // _ZN7S2602C13v10Ev
  virtual void  v11(); // _ZN7S2602C13v11Ev
  virtual void  v12(); // _ZN7S2602C13v12Ev
  S2602C1(); // tgen
};
//SIG(1 S2602C1) C1{ BC2{ BC3{ m Fi}} BC4{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25} BC5{ vd v26 v27 Fp} BC6{ m FC7{ m FC8{ m Fp Fi[4]}}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 FC9{ m Fp} FC10{ m FC11{ m FC12{ m Fp}} Fc:1 Fc:1 Fi[10]} Fc[2] FC7 FC13{ m Fp} FC14{ m Fp} FC15{ m Fp} FC16{ m Fp} FC17{ m Fp} FC17 FC17 FC17 FC17 FC17 FC18{ m Fp} FC12 FC19{ m Fp} FC19 FC20{ m FC21{ m FC14 FC22{ m FC11} FC13} FC23{ m Fi FC24{ BC25{ m Fp Fi} FC26{ FL[3]}}}} FC11 FC11 FC27{ m Fp} FC27 FC27}


 S2602C1 ::~S2602C1(){ note_dtor("S2602C1", this);}
void  S2602C1 ::v1(){vfunc_called(this, "_ZN7S2602C12v1Ev");}
void  S2602C1 ::v2(){vfunc_called(this, "_ZN7S2602C12v2Ev");}
void  S2602C1 ::v3(){vfunc_called(this, "_ZN7S2602C12v3Ev");}
void  S2602C1 ::v4(){vfunc_called(this, "_ZN7S2602C12v4Ev");}
void  S2602C1 ::v5(){vfunc_called(this, "_ZN7S2602C12v5Ev");}
void  S2602C1 ::v6(){vfunc_called(this, "_ZN7S2602C12v6Ev");}
void  S2602C1 ::v7(){vfunc_called(this, "_ZN7S2602C12v7Ev");}
void  S2602C1 ::v8(){vfunc_called(this, "_ZN7S2602C12v8Ev");}
void  S2602C1 ::v9(){vfunc_called(this, "_ZN7S2602C12v9Ev");}
void  S2602C1 ::v10(){vfunc_called(this, "_ZN7S2602C13v10Ev");}
void  S2602C1 ::v11(){vfunc_called(this, "_ZN7S2602C13v11Ev");}
void  S2602C1 ::v12(){vfunc_called(this, "_ZN7S2602C13v12Ev");}
S2602C1 ::S2602C1(){ note_ctor("S2602C1", this);} // tgen

static void Test_S2602C1()
{
  extern Class_Descriptor cd_S2602C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(48,60)];
    init_test(&cd_S2602C1, buf);
    S2602C1 *dp, &lv = *(dp=new (buf) S2602C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(376,236), "sizeof(S2602C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2602C1)");
    check_base_class_offset(lv, (S685C10_nt*)(S2602C2*), ABISELECT(8,4), "S2602C1");
    check_base_class_offset(lv, (S2602C2*), ABISELECT(8,4), "S2602C1");
    check_base_class_offset(lv, (S2602C4*), 0, "S2602C1");
    check_base_class_offset(lv, (S2602C5*), ABISELECT(16,8), "S2602C1");
    check_base_class_offset(lv, (S2601C6_nt*), ABISELECT(32,16), "S2602C1");
    check_field_offset(lv, s2602c1f0, ABISELECT(56,36), "S2602C1.s2602c1f0");
    check_field_offset(lv, s2602c1f1, ABISELECT(64,40), "S2602C1.s2602c1f1");
    check_field_offset(lv, s2602c1f2, ABISELECT(120,88), "S2602C1.s2602c1f2");
    check_field_offset(lv, s2602c1f3, ABISELECT(128,92), "S2602C1.s2602c1f3");
    check_field_offset(lv, s2602c1f4, ABISELECT(152,112), "S2602C1.s2602c1f4");
    check_field_offset(lv, s2602c1f5, ABISELECT(160,116), "S2602C1.s2602c1f5");
    check_field_offset(lv, s2602c1f6, ABISELECT(168,120), "S2602C1.s2602c1f6");
    check_field_offset(lv, s2602c1f7, ABISELECT(176,124), "S2602C1.s2602c1f7");
    check_field_offset(lv, s2602c1f8, ABISELECT(184,128), "S2602C1.s2602c1f8");
    check_field_offset(lv, s2602c1f9, ABISELECT(192,132), "S2602C1.s2602c1f9");
    check_field_offset(lv, s2602c1f10, ABISELECT(200,136), "S2602C1.s2602c1f10");
    check_field_offset(lv, s2602c1f11, ABISELECT(208,140), "S2602C1.s2602c1f11");
    check_field_offset(lv, s2602c1f12, ABISELECT(216,144), "S2602C1.s2602c1f12");
    check_field_offset(lv, s2602c1f13, ABISELECT(224,148), "S2602C1.s2602c1f13");
    check_field_offset(lv, s2602c1f14, ABISELECT(232,152), "S2602C1.s2602c1f14");
    check_field_offset(lv, s2602c1f15, ABISELECT(240,156), "S2602C1.s2602c1f15");
    check_field_offset(lv, s2602c1f16, ABISELECT(248,160), "S2602C1.s2602c1f16");
    check_field_offset(lv, s2602c1f17, ABISELECT(256,164), "S2602C1.s2602c1f17");
    check_field_offset(lv, s2602c1f18, ABISELECT(264,168), "S2602C1.s2602c1f18");
    check_field_offset(lv, s2602c1f19, ABISELECT(336,216), "S2602C1.s2602c1f19");
    check_field_offset(lv, s2602c1f20, ABISELECT(344,220), "S2602C1.s2602c1f20");
    check_field_offset(lv, s2602c1f21, ABISELECT(352,224), "S2602C1.s2602c1f21");
    check_field_offset(lv, s2602c1f22, ABISELECT(360,228), "S2602C1.s2602c1f22");
    check_field_offset(lv, s2602c1f23, ABISELECT(368,232), "S2602C1.s2602c1f23");
    test_class_info(&lv, &cd_S2602C1);
    dp->~S2602C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2602C1(Test_S2602C1, "S2602C1", ABISELECT(376,236));

#else // __cplusplus

extern void _ZN7S2602C1C1Ev();
extern void _ZN7S2602C1D1Ev();
Name_Map name_map_S2602C1[] = {
  NSPAIR(_ZN7S2602C1C1Ev),
  NSPAIR(_ZN7S2602C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S2602C2;
extern VTBL_ENTRY _ZTI7S2602C2[];
extern Class_Descriptor cd_S2602C4;
extern VTBL_ENTRY _ZTI7S2602C4[];
extern  VTBL_ENTRY _ZTV7S2602C4[];
extern Class_Descriptor cd_S2602C5;
extern VTBL_ENTRY _ZTI7S2602C5[];
extern  VTBL_ENTRY _ZTV7S2602C5[];
extern Class_Descriptor cd_S2601C6_nt;
extern VTBL_ENTRY _ZTI10S2601C6_nt[];
static Base_Class bases_S2602C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C10_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2602C2,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2602C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2602C5,    ABISELECT(16,8), //bcp->offset
    29, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2601C6_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2602C1[];
extern void _ZN7S2602C1D1Ev();
extern void _ZN7S2602C1D0Ev();
extern void _ZN7S2602C43v13Ev();
extern void _ZN7S2602C43v14Ev();
extern void _ZN7S2602C43v15Ev();
extern void _ZN7S2602C43v16Ev();
extern void _ZN7S2602C43v17Ev();
extern void _ZN7S2602C43v18Ev();
extern void _ZN7S2602C43v19Ev();
extern void _ZN7S2602C43v20Ev();
extern void _ZN7S2602C43v21Ev();
extern void _ZN7S2602C43v22Ev();
extern void _ZN7S2602C43v23Ev();
extern void _ZN7S2602C43v24Ev();
extern void _ZN7S2602C43v25Ev();
extern void _ZN7S2602C12v1Ev();
extern void _ZN7S2602C12v2Ev();
extern void _ZN7S2602C12v3Ev();
extern void _ZN7S2602C12v4Ev();
extern void _ZN7S2602C12v5Ev();
extern void _ZN7S2602C12v6Ev();
extern void _ZN7S2602C12v7Ev();
extern void _ZN7S2602C12v8Ev();
extern void _ZN7S2602C12v9Ev();
extern void _ZN7S2602C13v10Ev();
extern void _ZN7S2602C13v11Ev();
extern void _ZN7S2602C13v12Ev();
extern void ABISELECT(_ZThn16_N7S2602C1D1Ev,_ZThn8_N7S2602C1D1Ev)();
extern void ABISELECT(_ZThn16_N7S2602C1D0Ev,_ZThn8_N7S2602C1D0Ev)();
extern void _ZN7S2602C53v26Ev();
extern void _ZN7S2602C53v27Ev();
static  VTBL_ENTRY vtc_S2602C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2602C1[0]),
  (VTBL_ENTRY)&_ZN7S2602C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2602C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v19Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v20Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v21Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v22Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v23Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v24Ev,
  (VTBL_ENTRY)&_ZN7S2602C43v25Ev,
  (VTBL_ENTRY)&_ZN7S2602C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2602C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2602C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2602C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2602C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2602C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2602C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2602C12v8Ev,
  (VTBL_ENTRY)&_ZN7S2602C12v9Ev,
  (VTBL_ENTRY)&_ZN7S2602C13v10Ev,
  (VTBL_ENTRY)&_ZN7S2602C13v11Ev,
  (VTBL_ENTRY)&_ZN7S2602C13v12Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S2602C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S2602C1D1Ev,_ZThn8_N7S2602C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N7S2602C1D0Ev,_ZThn8_N7S2602C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2602C53v26Ev,
  (VTBL_ENTRY)&_ZN7S2602C53v27Ev,
};
extern VTBL_ENTRY _ZTI7S2602C1[];
extern  VTBL_ENTRY _ZTV7S2602C1[];
Class_Descriptor cd_S2602C1 = {  "S2602C1", // class name
  bases_S2602C1, 5,
  &(vtc_S2602C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(376,236), // object size
  NSPAIRA(_ZTI7S2602C1),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S2602C1),35, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C5_nt  {
  __tsi64 s972c5f0;
  void  mf972c5(); // _ZN9S972C5_nt7mf972c5Ev
};
//SIG(-1 S972C5_nt) C1{ m FL}


void  S972C5_nt ::mf972c5(){}

//skip512 S972C5_nt

#else // __cplusplus

Class_Descriptor cd_S972C5_nt = {  "S972C5_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C3  : S685C10_nt {
  void *s972c3f0;
  int s972c3f1;
  ::S972C5_nt s972c3f2;
  int s972c3f3[2];
  virtual  ~S972C3(); // _ZN6S972C3D1Ev
  virtual void  v2(); // _ZN6S972C32v2Ev
  virtual void  v3(); // _ZN6S972C32v3Ev
  S972C3(); // tgen
};
//SIG(-1 S972C3) C1{ BC2{ m Fi} vd v1 v2 Fp Fi FC3{ m FL} Fi[2]}


 S972C3 ::~S972C3(){ note_dtor("S972C3", this);}
void  S972C3 ::v2(){vfunc_called(this, "_ZN6S972C32v2Ev");}
void  S972C3 ::v3(){vfunc_called(this, "_ZN6S972C32v3Ev");}
S972C3 ::S972C3(){ note_ctor("S972C3", this);} // tgen

static void Test_S972C3()
{
  extern Class_Descriptor cd_S972C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S972C3, buf);
    S972C3 *dp, &lv = *(dp=new (buf) S972C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S972C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S972C3)");
    check_base_class_offset(lv, (S685C10_nt*), ABISELECT(8,4), "S972C3");
    check_field_offset(lv, s972c3f0, ABISELECT(16,8), "S972C3.s972c3f0");
    check_field_offset(lv, s972c3f1, ABISELECT(24,12), "S972C3.s972c3f1");
    check_field_offset(lv, s972c3f2, ABISELECT(32,16), "S972C3.s972c3f2");
    check_field_offset(lv, s972c3f3, ABISELECT(40,24), "S972C3.s972c3f3");
    test_class_info(&lv, &cd_S972C3);
    dp->~S972C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C3(Test_S972C3, "S972C3", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN6S972C3C1Ev();
extern void _ZN6S972C3D1Ev();
Name_Map name_map_S972C3[] = {
  NSPAIR(_ZN6S972C3C1Ev),
  NSPAIR(_ZN6S972C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
static Base_Class bases_S972C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C10_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S972C3[];
extern void _ZN6S972C3D1Ev();
extern void _ZN6S972C3D0Ev();
extern void _ZN6S972C32v2Ev();
extern void _ZN6S972C32v3Ev();
static  VTBL_ENTRY vtc_S972C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S972C3[0]),
  (VTBL_ENTRY)&_ZN6S972C3D1Ev,
  (VTBL_ENTRY)&_ZN6S972C3D0Ev,
  (VTBL_ENTRY)&_ZN6S972C32v2Ev,
  (VTBL_ENTRY)&_ZN6S972C32v3Ev,
};
extern VTBL_ENTRY _ZTI6S972C3[];
extern  VTBL_ENTRY _ZTV6S972C3[];
Class_Descriptor cd_S972C3 = {  "S972C3", // class name
  bases_S972C3, 1,
  &(vtc_S972C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI6S972C3),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV6S972C3),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C9_nt  {
};
//SIG(-1 S972C9_nt) C1{}



//skip512 S972C9_nt

#else // __cplusplus

Class_Descriptor cd_S972C9_nt = {  "S972C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C11  {
};
//SIG(-1 S972C11) C1{}



static void Test_S972C11()
{
  {
    init_simple_test("S972C11");
    S972C11 lv;
    check2(sizeof(lv), 1, "sizeof(S972C11)");
    check2(__alignof__(lv), 1, "__alignof__(S972C11)");
  }
}
static Arrange_To_Call_Me vS972C11(Test_S972C11, "S972C11", 1);

#else // __cplusplus

Class_Descriptor cd_S972C11 = {  "S972C11", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C10_nt  : S972C11 {
};
//SIG(-1 S972C10_nt) C1{ BC2{}}



//skip512 S972C10_nt

#else // __cplusplus

extern Class_Descriptor cd_S972C11;
static Base_Class bases_S972C10_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C8_nt  : S972C9_nt {
  ::S972C10_nt s972c8f0;
};
//SIG(-1 S972C8_nt) C1{ BC2{} FC3{ BC4{}}}



//skip512 S972C8_nt

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
static Base_Class bases_S972C8_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C8_nt = {  "S972C8_nt", // class name
  bases_S972C8_nt, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C7_nt  : S972C8_nt {
  void *s972c7f0[3];
};
//SIG(-1 S972C7_nt) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



//skip512 S972C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
extern Class_Descriptor cd_S972C8_nt;
static Base_Class bases_S972C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S972C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C13  : S972C9_nt {
  ::S685C23_nt s972c13f0;
};
//SIG(-1 S972C13) C1{ BC2{} FC3{ m}}



static void Test_S972C13()
{
  extern Class_Descriptor cd_S972C13;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S972C13, buf);
    S972C13 &lv = *(new (buf) S972C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S972C13)");
    check2(__alignof__(lv), 1, "__alignof__(S972C13)");
    check_base_class_offset(lv, (S972C9_nt*), 0, "S972C13");
    check_field_offset(lv, s972c13f0, 0, "S972C13.s972c13f0");
    test_class_info(&lv, &cd_S972C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C13(Test_S972C13, "S972C13", 1);

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
static Base_Class bases_S972C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C13 = {  "S972C13", // class name
  bases_S972C13, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C12  : S972C13 {
  void *s972c12f0[3];
};
//SIG(-1 S972C12) C1{ BC2{ BC3{} FC4{ m}} Fp[3]}



static void Test_S972C12()
{
  extern Class_Descriptor cd_S972C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S972C12, buf);
    S972C12 &lv = *(new (buf) S972C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S972C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S972C12)");
    check_base_class_offset(lv, (S972C9_nt*)(S972C13*), 0, "S972C12");
    check_base_class_offset(lv, (S972C13*), 0, "S972C12");
    check_field_offset(lv, s972c12f0, ABISELECT(8,4), "S972C12.s972c12f0");
    test_class_info(&lv, &cd_S972C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C12(Test_S972C12, "S972C12", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
extern Class_Descriptor cd_S972C13;
static Base_Class bases_S972C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S972C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C12 = {  "S972C12", // class name
  bases_S972C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C2  : S972C3 {
  void *s972c2f0;
  ::S2602C33 s972c2f1;
  char s972c2f2[3];
  ::S972C7_nt s972c2f3;
  void *s972c2f4[7];
  ::S972C12 s972c2f5;
  virtual  ~S972C2(); // _ZN6S972C2D1Ev
  virtual void  v4(); // _ZN6S972C22v4Ev
  S972C2(); // tgen
};
//SIG(-1 S972C2) C1{ BC2{ BC3{ m Fi} vd v2 v3 Fp Fi FC4{ m FL} Fi[2]} vd v1 Fp FC5{ m Fp} Fc[3] FC6{ BC7{ BC8{} FC9{ BC10{}}} Fp[3]} Fp[7] FC11{ BC12{ BC8 FC13{ m}} Fp[3]}}


 S972C2 ::~S972C2(){ note_dtor("S972C2", this);}
void  S972C2 ::v4(){vfunc_called(this, "_ZN6S972C22v4Ev");}
S972C2 ::S972C2(){ note_ctor("S972C2", this);} // tgen

static void Test_S972C2()
{
  extern Class_Descriptor cd_S972C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,27)];
    init_test(&cd_S972C2, buf);
    S972C2 *dp, &lv = *(dp=new (buf) S972C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,104), "sizeof(S972C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S972C2)");
    check_base_class_offset(lv, (S685C10_nt*)(S972C3*), ABISELECT(8,4), "S972C2");
    check_base_class_offset(lv, (S972C3*), 0, "S972C2");
    check_field_offset(lv, s972c2f0, ABISELECT(48,32), "S972C2.s972c2f0");
    check_field_offset(lv, s972c2f1, ABISELECT(56,36), "S972C2.s972c2f1");
    check_field_offset(lv, s972c2f2, ABISELECT(64,40), "S972C2.s972c2f2");
    check_field_offset(lv, s972c2f3, ABISELECT(72,44), "S972C2.s972c2f3");
    check_field_offset(lv, s972c2f4, ABISELECT(104,60), "S972C2.s972c2f4");
    check_field_offset(lv, s972c2f5, ABISELECT(160,88), "S972C2.s972c2f5");
    test_class_info(&lv, &cd_S972C2);
    dp->~S972C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C2(Test_S972C2, "S972C2", ABISELECT(192,104));

#else // __cplusplus

extern void _ZN6S972C2C1Ev();
extern void _ZN6S972C2D1Ev();
Name_Map name_map_S972C2[] = {
  NSPAIR(_ZN6S972C2C1Ev),
  NSPAIR(_ZN6S972C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C3;
extern VTBL_ENTRY _ZTI6S972C3[];
extern  VTBL_ENTRY _ZTV6S972C3[];
static Base_Class bases_S972C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C10_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S972C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S972C2[];
extern void _ZN6S972C2D1Ev();
extern void _ZN6S972C2D0Ev();
extern void _ZN6S972C32v2Ev();
extern void _ZN6S972C32v3Ev();
extern void _ZN6S972C22v4Ev();
static  VTBL_ENTRY vtc_S972C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S972C2[0]),
  (VTBL_ENTRY)&_ZN6S972C2D1Ev,
  (VTBL_ENTRY)&_ZN6S972C2D0Ev,
  (VTBL_ENTRY)&_ZN6S972C32v2Ev,
  (VTBL_ENTRY)&_ZN6S972C32v3Ev,
  (VTBL_ENTRY)&_ZN6S972C22v4Ev,
};
extern VTBL_ENTRY _ZTI6S972C2[];
extern  VTBL_ENTRY _ZTV6S972C2[];
Class_Descriptor cd_S972C2 = {  "S972C2", // class name
  bases_S972C2, 2,
  &(vtc_S972C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,104), // object size
  NSPAIRA(_ZTI6S972C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S972C2),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C18  : S972C9_nt {
};
//SIG(-1 S972C18) C1{ BC2{}}



static void Test_S972C18()
{
  extern Class_Descriptor cd_S972C18;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S972C18, buf);
    S972C18 &lv = *(new (buf) S972C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S972C18)");
    check2(__alignof__(lv), 1, "__alignof__(S972C18)");
    check_base_class_offset(lv, (S972C9_nt*), 0, "S972C18");
    test_class_info(&lv, &cd_S972C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C18(Test_S972C18, "S972C18", 1);

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
static Base_Class bases_S972C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C18 = {  "S972C18", // class name
  bases_S972C18, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C17_nt  : S972C18 {
  ::S972C10_nt s972c17f0;
};
//SIG(-1 S972C17_nt) C1{ BC2{ BC3{}} FC4{ BC5{}}}



//skip512 S972C17_nt

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
extern Class_Descriptor cd_S972C18;
static Base_Class bases_S972C17_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S972C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C17_nt = {  "S972C17_nt", // class name
  bases_S972C17_nt, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S972C21_nt  {
  char s972c21f0[16];
  void *s972c21f1;
};
//SIG(1 S972C21_nt) U1{ Fc[16] Fp}

#endif // __cplusplus
#ifdef __cplusplus

struct  S972C16_nt  : S972C17_nt {
  ::S972C21_nt s972c16f0;
  int s972c16f1;
  int s972c16f2;
};
//SIG(-1 S972C16_nt) C1{ BC2{ BC3{ BC4{}} FC5{ BC6{}}} FU7{ Fc[16] Fp} Fi Fi}



//skip512 S972C16_nt

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
extern Class_Descriptor cd_S972C18;
extern Class_Descriptor cd_S972C17_nt;
static Base_Class bases_S972C16_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S972C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S972C17_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C24_nt  {
  void  mf972c24(); // _ZN10S972C24_nt8mf972c24Ev
};
//SIG(-1 S972C24_nt) C1{ m}


void  S972C24_nt ::mf972c24(){}

//skip512 S972C24_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S972C24_nt[];
VTBL_ENTRY *P__ZTI10S972C24_nt = _ZTI10S972C24_nt; 
Class_Descriptor cd_S972C24_nt = {  "S972C24_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S972C24_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C23  : S972C9_nt {
  ::S972C24_nt s972c23f0;
};
//SIG(-1 S972C23) C1{ BC2{} FC3{ m}}



static void Test_S972C23()
{
  extern Class_Descriptor cd_S972C23;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S972C23, buf);
    S972C23 &lv = *(new (buf) S972C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S972C23)");
    check2(__alignof__(lv), 1, "__alignof__(S972C23)");
    check_base_class_offset(lv, (S972C9_nt*), 0, "S972C23");
    check_field_offset(lv, s972c23f0, 0, "S972C23.s972c23f0");
    test_class_info(&lv, &cd_S972C23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C23(Test_S972C23, "S972C23", 1);

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
static Base_Class bases_S972C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C23 = {  "S972C23", // class name
  bases_S972C23, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C22  : S972C23 {
  void *s972c22f0;
  void *s972c22f1;
  void *s972c22f2;
};
//SIG(-1 S972C22) C1{ BC2{ BC3{} FC4{ m}} Fp[3]}



static void Test_S972C22()
{
  extern Class_Descriptor cd_S972C22;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S972C22, buf);
    S972C22 &lv = *(new (buf) S972C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S972C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S972C22)");
    check_base_class_offset(lv, (S972C9_nt*)(S972C23*), 0, "S972C22");
    check_base_class_offset(lv, (S972C23*), 0, "S972C22");
    check_field_offset(lv, s972c22f0, ABISELECT(8,4), "S972C22.s972c22f0");
    check_field_offset(lv, s972c22f1, ABISELECT(16,8), "S972C22.s972c22f1");
    check_field_offset(lv, s972c22f2, ABISELECT(24,12), "S972C22.s972c22f2");
    test_class_info(&lv, &cd_S972C22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C22(Test_S972C22, "S972C22", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
extern Class_Descriptor cd_S972C23;
static Base_Class bases_S972C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S972C23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C22 = {  "S972C22", // class name
  bases_S972C22, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C31  {
};
//SIG(-1 S972C31) C1{}



static void Test_S972C31()
{
  {
    init_simple_test("S972C31");
    S972C31 lv;
    check2(sizeof(lv), 1, "sizeof(S972C31)");
    check2(__alignof__(lv), 1, "__alignof__(S972C31)");
  }
}
static Arrange_To_Call_Me vS972C31(Test_S972C31, "S972C31", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S972C31[];
VTBL_ENTRY *P__ZTI7S972C31 = _ZTI7S972C31; 
Class_Descriptor cd_S972C31 = {  "S972C31", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI7S972C31),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C30  : S972C31 {
};
//SIG(-1 S972C30) C1{ BC2{}}



static void Test_S972C30()
{
  extern Class_Descriptor cd_S972C30;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S972C30, buf);
    S972C30 &lv = *(new (buf) S972C30());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S972C30)");
    check2(__alignof__(lv), 1, "__alignof__(S972C30)");
    check_base_class_offset(lv, (S972C31*), 0, "S972C30");
    test_class_info(&lv, &cd_S972C30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C30(Test_S972C30, "S972C30", 1);

#else // __cplusplus

extern Class_Descriptor cd_S972C31;
extern VTBL_ENTRY _ZTI7S972C31[];
static Base_Class bases_S972C30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C31,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C30 = {  "S972C30", // class name
  bases_S972C30, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C29  : S972C9_nt {
  ::S972C30 s972c29f0;
};
//SIG(-1 S972C29) C1{ BC2{} FC3{ BC4{}}}



static void Test_S972C29()
{
  extern Class_Descriptor cd_S972C29;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S972C29, buf);
    S972C29 &lv = *(new (buf) S972C29());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S972C29)");
    check2(__alignof__(lv), 1, "__alignof__(S972C29)");
    check_base_class_offset(lv, (S972C9_nt*), 0, "S972C29");
    check_field_offset(lv, s972c29f0, 0, "S972C29.s972c29f0");
    test_class_info(&lv, &cd_S972C29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C29(Test_S972C29, "S972C29", 1);

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
static Base_Class bases_S972C29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C29 = {  "S972C29", // class name
  bases_S972C29, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C28_nt  : S972C29 {
  void *s972c28f0;
  void *s972c28f1;
  void *s972c28f2;
};
//SIG(-1 S972C28_nt) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



//skip512 S972C28_nt

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
extern Class_Descriptor cd_S972C29;
static Base_Class bases_S972C28_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S972C29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C37  : S972C9_nt {
  ::S972C30 s972c37f0;
};
//SIG(-1 S972C37) C1{ BC2{} FC3{ BC4{}}}



static void Test_S972C37()
{
  extern Class_Descriptor cd_S972C37;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_S972C37, buf);
    S972C37 &lv = *(new (buf) S972C37());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(S972C37)");
    check2(__alignof__(lv), 1, "__alignof__(S972C37)");
    check_base_class_offset(lv, (S972C9_nt*), 0, "S972C37");
    check_field_offset(lv, s972c37f0, 0, "S972C37.s972c37f0");
    test_class_info(&lv, &cd_S972C37);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C37(Test_S972C37, "S972C37", 1);

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
static Base_Class bases_S972C37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C37 = {  "S972C37", // class name
  bases_S972C37, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C36  : S972C37 {
  void *s972c36f0;
  void *s972c36f1;
  void *s972c36f2;
};
//SIG(-1 S972C36) C1{ BC2{ BC3{} FC4{ BC5{}}} Fp[3]}



static void Test_S972C36()
{
  extern Class_Descriptor cd_S972C36;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S972C36, buf);
    S972C36 &lv = *(new (buf) S972C36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S972C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S972C36)");
    check_base_class_offset(lv, (S972C9_nt*)(S972C37*), 0, "S972C36");
    check_base_class_offset(lv, (S972C37*), 0, "S972C36");
    check_field_offset(lv, s972c36f0, ABISELECT(8,4), "S972C36.s972c36f0");
    check_field_offset(lv, s972c36f1, ABISELECT(16,8), "S972C36.s972c36f1");
    check_field_offset(lv, s972c36f2, ABISELECT(24,12), "S972C36.s972c36f2");
    test_class_info(&lv, &cd_S972C36);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C36(Test_S972C36, "S972C36", ABISELECT(32,16));

#else // __cplusplus

extern Class_Descriptor cd_S972C9_nt;
extern Class_Descriptor cd_S972C37;
static Base_Class bases_S972C36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S972C37,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S972C36 = {  "S972C36", // class name
  bases_S972C36, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S972C1  : S972C2 {
  ::S2602C22 s972c1f0;
  ::S2602C22 s972c1f1;
  ::S972C16_nt s972c1f2;
  ::S972C22 s972c1f3;
  ::S972C22 s972c1f4;
  ::S972C28_nt s972c1f5;
  ::S972C28_nt s972c1f6;
  ::S972C36 s972c1f7;
  ::S972C36 s972c1f8;
  char s972c1f9;
  char s972c1f10;
  char s972c1f11;
  void *s972c1f12;
  void *s972c1f13;
  void *s972c1f14;
  char s972c1f15;
  int s972c1f16;
  char s972c1f17;
  char s972c1f18;
  virtual  ~S972C1(); // _ZN6S972C1D1Ev
  virtual void  v1(); // _ZN6S972C12v1Ev
  S972C1(); // tgen
};
//SIG(1 S972C1) C1{ BC2{ BC3{ BC4{ m Fi} vd v2 v3 Fp Fi FC5{ m FL} Fi[2]} vd v4 Fp FC6{ m Fp} Fc[3] FC7{ BC8{ BC9{} FC10{ BC11{}}} Fp[3]} Fp[7] FC12{ BC13{ BC9 FC14{ m}} Fp[3]}} vd v1 FC15{ m Fp} FC15 FC16{ BC17{ BC18{ BC9} FC10} FU19{ Fc[16] Fp} Fi Fi} FC20{ BC21{ BC9 FC22{ m}} Fp Fp Fp} FC20 FC23{ BC24{ BC9 FC25{ BC26{}}} Fp Fp Fp} FC23 FC27{ BC28{ BC9 FC25} Fp Fp Fp} FC27 Fc Fc Fc Fp Fp Fp Fc Fi Fc Fc}


 S972C1 ::~S972C1(){ note_dtor("S972C1", this);}
void  S972C1 ::v1(){vfunc_called(this, "_ZN6S972C12v1Ev");}
S972C1 ::S972C1(){ note_ctor("S972C1", this);} // tgen

static void Test_S972C1()
{
  extern Class_Descriptor cd_S972C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(61,67)];
    init_test(&cd_S972C1, buf);
    S972C1 *dp, &lv = *(dp=new (buf) S972C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(480,264), "sizeof(S972C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S972C1)");
    check_base_class_offset(lv, (S685C10_nt*)(S972C3*)(S972C2*), ABISELECT(8,4), "S972C1");
    check_base_class_offset(lv, (S972C3*)(S972C2*), 0, "S972C1");
    check_base_class_offset(lv, (S972C2*), 0, "S972C1");
    check_field_offset(lv, s972c1f0, ABISELECT(192,104), "S972C1.s972c1f0");
    check_field_offset(lv, s972c1f1, ABISELECT(200,108), "S972C1.s972c1f1");
    check_field_offset(lv, s972c1f2, ABISELECT(208,112), "S972C1.s972c1f2");
    check_field_offset(lv, s972c1f3, ABISELECT(240,140), "S972C1.s972c1f3");
    check_field_offset(lv, s972c1f4, ABISELECT(272,156), "S972C1.s972c1f4");
    check_field_offset(lv, s972c1f5, ABISELECT(304,172), "S972C1.s972c1f5");
    check_field_offset(lv, s972c1f6, ABISELECT(336,188), "S972C1.s972c1f6");
    check_field_offset(lv, s972c1f7, ABISELECT(368,204), "S972C1.s972c1f7");
    check_field_offset(lv, s972c1f8, ABISELECT(400,220), "S972C1.s972c1f8");
    check_field_offset(lv, s972c1f9, ABISELECT(432,236), "S972C1.s972c1f9");
    check_field_offset(lv, s972c1f10, ABISELECT(433,237), "S972C1.s972c1f10");
    check_field_offset(lv, s972c1f11, ABISELECT(434,238), "S972C1.s972c1f11");
    check_field_offset(lv, s972c1f12, ABISELECT(440,240), "S972C1.s972c1f12");
    check_field_offset(lv, s972c1f13, ABISELECT(448,244), "S972C1.s972c1f13");
    check_field_offset(lv, s972c1f14, ABISELECT(456,248), "S972C1.s972c1f14");
    check_field_offset(lv, s972c1f15, ABISELECT(464,252), "S972C1.s972c1f15");
    check_field_offset(lv, s972c1f16, ABISELECT(468,256), "S972C1.s972c1f16");
    check_field_offset(lv, s972c1f17, ABISELECT(472,260), "S972C1.s972c1f17");
    check_field_offset(lv, s972c1f18, ABISELECT(473,261), "S972C1.s972c1f18");
    test_class_info(&lv, &cd_S972C1);
    dp->~S972C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS972C1(Test_S972C1, "S972C1", ABISELECT(480,264));

#else // __cplusplus

extern void _ZN6S972C1C1Ev();
extern void _ZN6S972C1D1Ev();
Name_Map name_map_S972C1[] = {
  NSPAIR(_ZN6S972C1C1Ev),
  NSPAIR(_ZN6S972C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C3;
extern VTBL_ENTRY _ZTI6S972C3[];
extern  VTBL_ENTRY _ZTV6S972C3[];
extern Class_Descriptor cd_S972C2;
extern VTBL_ENTRY _ZTI6S972C2[];
extern  VTBL_ENTRY _ZTV6S972C2[];
static Base_Class bases_S972C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C10_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S972C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S972C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S972C1[];
extern void _ZN6S972C1D1Ev();
extern void _ZN6S972C1D0Ev();
extern void _ZN6S972C32v2Ev();
extern void _ZN6S972C32v3Ev();
extern void _ZN6S972C22v4Ev();
extern void _ZN6S972C12v1Ev();
static  VTBL_ENTRY vtc_S972C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S972C1[0]),
  (VTBL_ENTRY)&_ZN6S972C1D1Ev,
  (VTBL_ENTRY)&_ZN6S972C1D0Ev,
  (VTBL_ENTRY)&_ZN6S972C32v2Ev,
  (VTBL_ENTRY)&_ZN6S972C32v3Ev,
  (VTBL_ENTRY)&_ZN6S972C22v4Ev,
  (VTBL_ENTRY)&_ZN6S972C12v1Ev,
};
extern VTBL_ENTRY _ZTI6S972C1[];
extern  VTBL_ENTRY _ZTV6S972C1[];
Class_Descriptor cd_S972C1 = {  "S972C1", // class name
  bases_S972C1, 3,
  &(vtc_S972C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(480,264), // object size
  NSPAIRA(_ZTI6S972C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S972C1),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20463C6  {
  __tsi64 s20463c6f0[8];
  void  mf20463c6(); // _ZN8S20463C69mf20463c6Ev
};
//SIG(-1 S20463C6) C1{ m FL[8]}


void  S20463C6 ::mf20463c6(){}

static void Test_S20463C6()
{
  {
    init_simple_test("S20463C6");
    S20463C6 lv;
    check2(sizeof(lv), 64, "sizeof(S20463C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20463C6)");
    check_field_offset(lv, s20463c6f0, 0, "S20463C6.s20463c6f0");
  }
}
static Arrange_To_Call_Me vS20463C6(Test_S20463C6, "S20463C6", 64);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S20463C6[];
VTBL_ENTRY *P__ZTI8S20463C6 = _ZTI8S20463C6; 
Class_Descriptor cd_S20463C6 = {  "S20463C6", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  64, // object size
  NSPAIRA(_ZTI8S20463C6),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20463C3  : S685C10_nt , S972C24_nt , S20463C6 {
};
//SIG(-1 S20463C3) C1{ BC2{ m Fi} BC3{ m} BC4{ m FL[8]}}



static void Test_S20463C3()
{
  extern Class_Descriptor cd_S20463C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,18)];
    init_test(&cd_S20463C3, buf);
    S20463C3 &lv = *(new (buf) S20463C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,68), "sizeof(S20463C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20463C3)");
    check_base_class_offset(lv, (S685C10_nt*), 0, "S20463C3");
    check_base_class_offset(lv, (S972C24_nt*), 0, "S20463C3");
    check_base_class_offset(lv, (S20463C6*), ABISELECT(8,4), "S20463C3");
    test_class_info(&lv, &cd_S20463C3);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20463C3(Test_S20463C3, "S20463C3", ABISELECT(72,68));

#else // __cplusplus

extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
static Base_Class bases_S20463C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C10_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S972C24_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20463C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20463C3[];
Class_Descriptor cd_S20463C3 = {  "S20463C3", // class name
  bases_S20463C3, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(72,68), // object size
  NSPAIRA(_ZTI8S20463C3),ABISELECT(72,40), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20463C10  : S20463C6 , virtual S972C24_nt {
  ~S20463C10(); // tgen
  S20463C10(); // tgen
};
//SIG(-1 S20463C10) C1{ BC2{ m FL[8]} VBC3{ m}}


S20463C10 ::~S20463C10(){ note_dtor("S20463C10", this);} // tgen
S20463C10 ::S20463C10(){ note_ctor("S20463C10", this);} // tgen

static void Test_S20463C10()
{
  extern Class_Descriptor cd_S20463C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,18)];
    init_test(&cd_S20463C10, buf);
    S20463C10 *dp, &lv = *(dp=new (buf) S20463C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,68), "sizeof(S20463C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20463C10)");
    check_base_class_offset(lv, (S20463C6*), ABISELECT(8,4), "S20463C10");
    check_base_class_offset(lv, (S972C24_nt*), 0, "S20463C10");
    test_class_info(&lv, &cd_S20463C10);
    dp->~S20463C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20463C10(Test_S20463C10, "S20463C10", ABISELECT(72,68));

#else // __cplusplus

extern void _ZN9S20463C10C1Ev();
extern void _ZN9S20463C10D1Ev();
Name_Map name_map_S20463C10[] = {
  NSPAIR(_ZN9S20463C10C1Ev),
  NSPAIR(_ZN9S20463C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
static Base_Class bases_S20463C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20463C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S972C24_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20463C10[];
static  VTBL_ENTRY vtc_S20463C10[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C10[0]),
};
extern VTBL_ENTRY _ZTV9S20463C10[];
static  VTT_ENTRY vtt_S20463C10[] = {
  {&(_ZTV9S20463C10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI9S20463C10[];
extern  VTBL_ENTRY _ZTV9S20463C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C10[];
Class_Descriptor cd_S20463C10 = {  "S20463C10", // class name
  bases_S20463C10, 2,
  &(vtc_S20463C10[0]), // expected_vtbl_contents
  &(vtt_S20463C10[0]), // expected_vtt_contents
  ABISELECT(72,68), // object size
  NSPAIRA(_ZTI9S20463C10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV9S20463C10),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20463C10),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20463C11  : S972C24_nt , S20463C6 , virtual S685C10_nt {
  virtual  ~S20463C11(); // _ZN9S20463C11D2Ev
  S20463C11(); // tgen
};
//SIG(-1 S20463C11) C1{ BC2{ m} BC3{ m FL[8]} VBC4{ m Fi} vd}


 S20463C11 ::~S20463C11(){ note_dtor("S20463C11", this);}
S20463C11 ::S20463C11(){ note_ctor("S20463C11", this);} // tgen

static void Test_S20463C11()
{
  extern Class_Descriptor cd_S20463C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,19)];
    init_test(&cd_S20463C11, buf);
    S20463C11 *dp, &lv = *(dp=new (buf) S20463C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,72), "sizeof(S20463C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20463C11)");
    check_base_class_offset(lv, (S972C24_nt*), 0, "S20463C11");
    check_base_class_offset(lv, (S20463C6*), ABISELECT(8,4), "S20463C11");
    check_base_class_offset(lv, (S685C10_nt*), ABISELECT(72,68), "S20463C11");
    test_class_info(&lv, &cd_S20463C11);
    dp->~S20463C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20463C11(Test_S20463C11, "S20463C11", ABISELECT(80,72));

#else // __cplusplus

extern void _ZN9S20463C11C1Ev();
extern void _ZN9S20463C11D2Ev();
Name_Map name_map_S20463C11[] = {
  NSPAIR(_ZN9S20463C11C1Ev),
  NSPAIR(_ZN9S20463C11D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
static Base_Class bases_S20463C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S972C24_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20463C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S685C10_nt,    ABISELECT(72,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20463C11[];
extern void _ZN9S20463C11D1Ev();
extern void _ZN9S20463C11D0Ev();
static  VTBL_ENTRY vtc_S20463C11[] = {
  ABISELECT(72,68),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C11[0]),
  (VTBL_ENTRY)&_ZN9S20463C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20463C11D0Ev,
};
extern VTBL_ENTRY _ZTV9S20463C11[];
static  VTT_ENTRY vtt_S20463C11[] = {
  {&(_ZTV9S20463C11[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S20463C11[];
extern  VTBL_ENTRY _ZTV9S20463C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C11[];
Class_Descriptor cd_S20463C11 = {  "S20463C11", // class name
  bases_S20463C11, 3,
  &(vtc_S20463C11[0]), // expected_vtbl_contents
  &(vtt_S20463C11[0]), // expected_vtt_contents
  ABISELECT(80,72), // object size
  NSPAIRA(_ZTI9S20463C11),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20463C11),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20463C11),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20463C9  : S20463C3 , S972C24_nt , S20463C10 , S20463C6 , S20463C11 {
  virtual  ~S20463C9(); // _ZN8S20463C9D2Ev
  S20463C9(); // tgen
};
//SIG(-1 S20463C9) C1{ BC2{ BC3{ m Fi} BC4{ m} BC5{ m FL[8]}} BC4 BC6{ BC5 VBC4} BC5 BC7{ BC4 BC5 VBC3 vd} vd}


 S20463C9 ::~S20463C9(){ note_dtor("S20463C9", this);}
S20463C9 ::S20463C9(){ note_ctor("S20463C9", this);} // tgen

static void Test_S20463C9()
{
  extern Class_Descriptor cd_S20463C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(37,69)];
    init_test(&cd_S20463C9, buf);
    S20463C9 *dp, &lv = *(dp=new (buf) S20463C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(288,272), "sizeof(S20463C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20463C9)");
    check_base_class_offset(lv, (S685C10_nt*)(S20463C3*), ABISELECT(72,68), "S20463C9");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C3*), ABISELECT(72,68), "S20463C9");
    check_base_class_offset(lv, (S20463C6*)(S20463C3*), ABISELECT(80,72), "S20463C9");
    check_base_class_offset(lv, (S20463C3*), ABISELECT(72,68), "S20463C9");
    /*is_ambiguous_... S20463C9::S972C24_nt */ AMB_check_base_class_offset(lv, (S972C24_nt*), 0, "S20463C9");
    check_base_class_offset(lv, (S20463C6*)(S20463C10*), ABISELECT(8,4), "S20463C9");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C10*), ABISELECT(280,268), "S20463C9");
    check_base_class_offset(lv, (S20463C10*), 0, "S20463C9");
    /*is_ambiguous_... S20463C9::S20463C6 */ AMB_check_base_class_offset(lv, (S20463C6*), ABISELECT(144,136), "S20463C9");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C11*), ABISELECT(208,200), "S20463C9");
    check_base_class_offset(lv, (S20463C6*)(S20463C11*), ABISELECT(216,204), "S20463C9");
    check_base_class_offset(lv, (S685C10_nt*)(S20463C11*), ABISELECT(280,268), "S20463C9");
    check_base_class_offset(lv, (S20463C11*), ABISELECT(208,200), "S20463C9");
    test_class_info(&lv, &cd_S20463C9);
    dp->~S20463C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20463C9(Test_S20463C9, "S20463C9", ABISELECT(288,272));

#else // __cplusplus

extern void _ZN8S20463C9C1Ev();
extern void _ZN8S20463C9D2Ev();
Name_Map name_map_S20463C9[] = {
  NSPAIR(_ZN8S20463C9C1Ev),
  NSPAIR(_ZN8S20463C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C3;
extern VTBL_ENTRY _ZTI8S20463C3[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C10;
extern VTBL_ENTRY _ZTI9S20463C10[];
extern  VTBL_ENTRY _ZTV9S20463C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C10[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S20463C11;
extern VTBL_ENTRY _ZTI9S20463C11[];
extern  VTBL_ENTRY _ZTV9S20463C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C11[];
static Base_Class bases_S20463C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C10_nt,    ABISELECT(72,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S972C24_nt,    ABISELECT(72,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20463C6,    ABISELECT(80,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20463C3,    ABISELECT(72,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S972C24_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20463C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S972C24_nt,    ABISELECT(280,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20463C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20463C6,    ABISELECT(144,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S972C24_nt,    ABISELECT(208,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20463C6,    ABISELECT(216,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S685C10_nt,    ABISELECT(280,268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20463C11,    ABISELECT(208,200), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20463C9[];
extern void _ZN8S20463C9D1Ev();
extern void _ZN8S20463C9D0Ev();
extern void ABISELECT(_ZThn208_N8S20463C9D1Ev,_ZThn200_N8S20463C9D1Ev)();
extern void ABISELECT(_ZThn208_N8S20463C9D0Ev,_ZThn200_N8S20463C9D0Ev)();
static  VTBL_ENTRY vtc_S20463C9[] = {
  ABISELECT(280,268),
  ABISELECT(280,268),
  0,
  (VTBL_ENTRY)&(_ZTI8S20463C9[0]),
  (VTBL_ENTRY)&_ZN8S20463C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20463C9D0Ev,
  ABISELECT(72,68),
  ABISELECT(-208,-200),
  (VTBL_ENTRY)&(_ZTI8S20463C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N8S20463C9D1Ev,_ZThn200_N8S20463C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N8S20463C9D0Ev,_ZThn200_N8S20463C9D0Ev),
};
extern VTBL_ENTRY _ZTV8S20463C9[];
static  VTBL_ENTRY _tg__ZTV9S20463C10__8S20463C9[] = {
  ABISELECT(280,268),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C10[0]),
};
extern void _ZN9S20463C11D1Ev();
extern void _ZN9S20463C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20463C11__8S20463C9[] = {
  ABISELECT(72,68),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C11[0]),
  (VTBL_ENTRY)&_ZN9S20463C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20463C11D0Ev,
};
static  VTT_ENTRY vtt_S20463C9[] = {
  {&(_ZTV8S20463C9[4]),  4,11},
  {&(_tg__ZTV9S20463C10__8S20463C9[3]),  3,3},
  {&(_tg__ZTV9S20463C11__8S20463C9[3]),  3,5},
  {&(_ZTV8S20463C9[9]),  9,11},
};
extern VTBL_ENTRY _ZTI8S20463C9[];
extern  VTBL_ENTRY _ZTV8S20463C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20463C9[];
Class_Descriptor cd_S20463C9 = {  "S20463C9", // class name
  bases_S20463C9, 13,
  &(vtc_S20463C9[0]), // expected_vtbl_contents
  &(vtt_S20463C9[0]), // expected_vtt_contents
  ABISELECT(288,272), // object size
  NSPAIRA(_ZTI8S20463C9),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S20463C9),11, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20463C9),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20463C12  : virtual S20463C10 , S20463C3 , virtual S20463C11 {
  ::S20463C6 s20463c12f0;
  ~S20463C12(); // tgen
  S20463C12(); // tgen
};
//SIG(-1 S20463C12) C1{ VBC2{ BC3{ m FL[8]} VBC4{ m}} BC5{ BC6{ m Fi} BC4 BC3} VBC7{ BC4 BC3 VBC6 vd} FC3}


S20463C12 ::~S20463C12(){ note_dtor("S20463C12", this);} // tgen
S20463C12 ::S20463C12(){ note_ctor("S20463C12", this);} // tgen

static void Test_S20463C12()
{
  extern Class_Descriptor cd_S20463C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,70)];
    init_test(&cd_S20463C12, buf);
    S20463C12 *dp, &lv = *(dp=new (buf) S20463C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,276), "sizeof(S20463C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20463C12)");
    check_base_class_offset(lv, (S20463C6*)(S20463C10*), ABISELECT(152,140), "S20463C12");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C10*), 0, "S20463C12");
    check_base_class_offset(lv, (S20463C10*), ABISELECT(144,136), "S20463C12");
    check_base_class_offset(lv, (S685C10_nt*)(S20463C3*), ABISELECT(8,4), "S20463C12");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C3*), ABISELECT(8,4), "S20463C12");
    check_base_class_offset(lv, (S20463C6*)(S20463C3*), ABISELECT(16,8), "S20463C12");
    check_base_class_offset(lv, (S20463C3*), ABISELECT(8,4), "S20463C12");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C11*), ABISELECT(216,204), "S20463C12");
    check_base_class_offset(lv, (S20463C6*)(S20463C11*), ABISELECT(224,208), "S20463C12");
    check_base_class_offset(lv, (S685C10_nt*)(S20463C11*), ABISELECT(288,272), "S20463C12");
    check_base_class_offset(lv, (S20463C11*), ABISELECT(216,204), "S20463C12");
    check_field_offset(lv, s20463c12f0, ABISELECT(80,72), "S20463C12.s20463c12f0");
    test_class_info(&lv, &cd_S20463C12);
    dp->~S20463C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20463C12(Test_S20463C12, "S20463C12", ABISELECT(296,276));

#else // __cplusplus

extern void _ZN9S20463C12C1Ev();
extern void _ZN9S20463C12D1Ev();
Name_Map name_map_S20463C12[] = {
  NSPAIR(_ZN9S20463C12C1Ev),
  NSPAIR(_ZN9S20463C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C10;
extern VTBL_ENTRY _ZTI9S20463C10[];
extern  VTBL_ENTRY _ZTV9S20463C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C10[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C3;
extern VTBL_ENTRY _ZTI8S20463C3[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S20463C11;
extern VTBL_ENTRY _ZTI9S20463C11[];
extern  VTBL_ENTRY _ZTV9S20463C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C11[];
static Base_Class bases_S20463C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20463C6,    ABISELECT(152,140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S972C24_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S20463C10,    ABISELECT(144,136), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S685C10_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S972C24_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20463C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20463C3,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S972C24_nt,    ABISELECT(216,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20463C6,    ABISELECT(224,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S685C10_nt,    ABISELECT(288,272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S20463C11,    ABISELECT(216,204), //bcp->offset
    11, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20463C12[];
extern void _ZN9S20463C12D1Ev();
extern void _ZN9S20463C12D0Ev();
extern void ABISELECT(_ZTv0_n32_N9S20463C12D1Ev,_ZTv0_n16_N9S20463C12D1Ev)();
extern void ABISELECT(_ZThn216_N9S20463C12D1Ev,_ZThn204_N9S20463C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20463C12D0Ev,_ZTv0_n16_N9S20463C12D0Ev)();
extern void ABISELECT(_ZThn216_N9S20463C12D0Ev,_ZThn204_N9S20463C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20463C12[] = {
  ABISELECT(288,272),
  ABISELECT(216,204),
  0,
  ABISELECT(144,136),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C12[0]),
  (VTBL_ENTRY)&_ZN9S20463C12D1Ev,
  (VTBL_ENTRY)&_ZN9S20463C12D0Ev,
  ABISELECT(-144,-136),
  ABISELECT(-144,-136),
  (VTBL_ENTRY)&(_ZTI9S20463C12[0]),
  ABISELECT(-216,-204),
  ABISELECT(72,68),
  ABISELECT(-216,-204),
  (VTBL_ENTRY)&(_ZTI9S20463C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20463C12D1Ev,_ZTv0_n16_N9S20463C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20463C12D0Ev,_ZTv0_n16_N9S20463C12D0Ev),
};
extern VTBL_ENTRY _ZTV9S20463C12[];
static  VTBL_ENTRY _tg__ZTV9S20463C10__9S20463C12[] = {
  ABISELECT(-144,-136),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C10[0]),
};
extern void _ZN9S20463C11D1Ev();
extern void _ZN9S20463C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20463C11__9S20463C12[] = {
  ABISELECT(72,68),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C11[0]),
  (VTBL_ENTRY)&_ZN9S20463C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20463C11D0Ev,
};
static  VTT_ENTRY vtt_S20463C12[] = {
  {&(_ZTV9S20463C12[6]),  6,17},
  {&(_ZTV9S20463C12[11]),  11,17},
  {&(_ZTV9S20463C12[15]),  15,17},
  {&(_tg__ZTV9S20463C10__9S20463C12[3]),  3,3},
  {&(_tg__ZTV9S20463C11__9S20463C12[3]),  3,5},
};
extern VTBL_ENTRY _ZTI9S20463C12[];
extern  VTBL_ENTRY _ZTV9S20463C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C12[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20463C12D0Ev,_ZTv0_n16_N9S20463C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S20463C12D0Ev,_ZThn204_N9S20463C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20463C12D1Ev,_ZTv0_n16_N9S20463C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S20463C12D1Ev,_ZThn204_N9S20463C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20463C12 = {  "S20463C12", // class name
  bases_S20463C12, 11,
  &(vtc_S20463C12[0]), // expected_vtbl_contents
  &(vtt_S20463C12[0]), // expected_vtt_contents
  ABISELECT(296,276), // object size
  NSPAIRA(_ZTI9S20463C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20463C12),17, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20463C12),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20463C8  : S20463C9 , S20463C10 , S685C10_nt , virtual S20463C12 {
  __tsi64 s20463c8f0[8];
  virtual  ~S20463C8(); // _ZN8S20463C8D2Ev
  S20463C8(); // tgen
};
//SIG(-1 S20463C8) C1{ BC2{ BC3{ BC4{ m Fi} BC5{ m} BC6{ m FL[8]}} BC5 BC7{ BC6 VBC5} BC6 BC8{ BC5 BC6 VBC4 vd} vd} BC7 BC4 VBC9{ VBC7 BC3 VBC8 FC6} vd FL[8]}


 S20463C8 ::~S20463C8(){ note_dtor("S20463C8", this);}
S20463C8 ::S20463C8(){ note_ctor("S20463C8", this);} // tgen

static void Test_S20463C8()
{
  extern Class_Descriptor cd_S20463C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(91,171)];
    init_test(&cd_S20463C8, buf);
    S20463C8 *dp, &lv = *(dp=new (buf) S20463C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(720,680), "sizeof(S20463C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20463C8)");
    check_base_class_offset(lv, (S685C10_nt*)(S20463C3*)(S20463C9*), ABISELECT(72,68), "S20463C8");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C3*)(S20463C9*), ABISELECT(72,68), "S20463C8");
    check_base_class_offset(lv, (S20463C6*)(S20463C3*)(S20463C9*), ABISELECT(80,72), "S20463C8");
    check_base_class_offset(lv, (S20463C3*)(S20463C9*), ABISELECT(72,68), "S20463C8");
    /*is_ambiguous_... S20463C9::S972C24_nt */ AMB_check_base_class_offset(lv, (S972C24_nt*)(S20463C9*), 0, "S20463C8");
    check_base_class_offset(lv, (S20463C6*)(S20463C10*)(S20463C9*), ABISELECT(8,4), "S20463C8");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C10*)(S20463C9*), ABISELECT(424,404), "S20463C8");
    /*is_ambiguous_... S20463C8::S20463C10 */ AMB_check_base_class_offset(lv, (S972C24_nt*)(S20463C10*), ABISELECT(424,404), "S20463C8");
    /*is_ambiguous_... S20463C8::S20463C10 */ AMB_check_base_class_offset(lv, (S972C24_nt*)(S20463C10*), ABISELECT(424,404), "S20463C8");
    check_base_class_offset(lv, (S20463C10*)(S20463C9*), 0, "S20463C8");
    /*is_ambiguous_... S20463C9::S20463C6 */ AMB_check_base_class_offset(lv, (S20463C6*)(S20463C9*), ABISELECT(144,136), "S20463C8");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C11*)(S20463C9*), ABISELECT(208,200), "S20463C8");
    check_base_class_offset(lv, (S20463C6*)(S20463C11*)(S20463C9*), ABISELECT(216,204), "S20463C8");
    check_base_class_offset(lv, (S685C10_nt*)(S20463C11*)(S20463C9*), ABISELECT(424,404), "S20463C8");
    /*is_ambiguous_... S20463C8::S20463C11 */ AMB_check_base_class_offset(lv, (S685C10_nt*)(S20463C11*), ABISELECT(424,404), "S20463C8");
    check_base_class_offset(lv, (S20463C11*)(S20463C9*), ABISELECT(208,200), "S20463C8");
    check_base_class_offset(lv, (S20463C9*), 0, "S20463C8");
    /*is_ambiguous_... S20463C8::S20463C10 */ AMB_check_base_class_offset(lv, (S20463C6*)(S20463C10*), ABISELECT(288,272), "S20463C8");
    /*is_ambiguous_... S20463C8::S20463C10 */ AMB_check_base_class_offset(lv, (S20463C10*), ABISELECT(280,268), "S20463C8");
    /*is_ambiguous_... S20463C8::S685C10_nt */ AMB_check_base_class_offset(lv, (S685C10_nt*), ABISELECT(352,336), "S20463C8");
    /*is_ambiguous_... S20463C8::S20463C10 */ AMB_check_base_class_offset(lv, (S20463C6*)(S20463C10*), ABISELECT(584,548), "S20463C8");
    check_base_class_offset(lv, (S20463C10*)(S20463C12*), ABISELECT(576,544), "S20463C8");
    check_base_class_offset(lv, (S685C10_nt*)(S20463C3*)(S20463C12*), ABISELECT(440,412), "S20463C8");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C3*)(S20463C12*), ABISELECT(440,412), "S20463C8");
    check_base_class_offset(lv, (S20463C6*)(S20463C3*)(S20463C12*), ABISELECT(448,416), "S20463C8");
    check_base_class_offset(lv, (S20463C3*)(S20463C12*), ABISELECT(440,412), "S20463C8");
    /*is_ambiguous_... S20463C8::S20463C11 */ AMB_check_base_class_offset(lv, (S972C24_nt*)(S20463C11*), ABISELECT(648,612), "S20463C8");
    /*is_ambiguous_... S20463C8::S20463C11 */ AMB_check_base_class_offset(lv, (S20463C6*)(S20463C11*), ABISELECT(656,616), "S20463C8");
    check_base_class_offset(lv, (S20463C11*)(S20463C12*), ABISELECT(648,612), "S20463C8");
    check_base_class_offset(lv, (S20463C12*), ABISELECT(432,408), "S20463C8");
    check_field_offset(lv, s20463c8f0, ABISELECT(360,340), "S20463C8.s20463c8f0");
    test_class_info(&lv, &cd_S20463C8);
    dp->~S20463C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20463C8(Test_S20463C8, "S20463C8", ABISELECT(720,680));

#else // __cplusplus

extern void _ZN8S20463C8C1Ev();
extern void _ZN8S20463C8D2Ev();
Name_Map name_map_S20463C8[] = {
  NSPAIR(_ZN8S20463C8C1Ev),
  NSPAIR(_ZN8S20463C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C3;
extern VTBL_ENTRY _ZTI8S20463C3[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C10;
extern VTBL_ENTRY _ZTI9S20463C10[];
extern  VTBL_ENTRY _ZTV9S20463C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C10[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S20463C11;
extern VTBL_ENTRY _ZTI9S20463C11[];
extern  VTBL_ENTRY _ZTV9S20463C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C11[];
extern Class_Descriptor cd_S20463C9;
extern VTBL_ENTRY _ZTI8S20463C9[];
extern  VTBL_ENTRY _ZTV8S20463C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20463C9[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C10;
extern VTBL_ENTRY _ZTI9S20463C10[];
extern  VTBL_ENTRY _ZTV9S20463C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C10[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C10;
extern VTBL_ENTRY _ZTI9S20463C10[];
extern  VTBL_ENTRY _ZTV9S20463C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C10[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C3;
extern VTBL_ENTRY _ZTI8S20463C3[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C11;
extern VTBL_ENTRY _ZTI9S20463C11[];
extern  VTBL_ENTRY _ZTV9S20463C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C11[];
extern Class_Descriptor cd_S20463C12;
extern VTBL_ENTRY _ZTI9S20463C12[];
extern  VTBL_ENTRY _ZTV9S20463C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C12[];
static Base_Class bases_S20463C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S685C10_nt,    ABISELECT(72,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S972C24_nt,    ABISELECT(72,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20463C6,    ABISELECT(80,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20463C3,    ABISELECT(72,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S972C24_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20463C6,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S972C24_nt,    ABISELECT(424,404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20463C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20463C6,    ABISELECT(144,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S972C24_nt,    ABISELECT(208,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20463C6,    ABISELECT(216,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S685C10_nt,    ABISELECT(424,404), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S20463C11,    ABISELECT(208,200), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20463C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20463C6,    ABISELECT(288,272), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20463C10,    ABISELECT(280,268), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S685C10_nt,    ABISELECT(352,336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20463C6,    ABISELECT(584,548), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20463C10,    ABISELECT(576,544), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S685C10_nt,    ABISELECT(440,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S972C24_nt,    ABISELECT(440,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20463C6,    ABISELECT(448,416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20463C3,    ABISELECT(440,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S972C24_nt,    ABISELECT(648,612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20463C6,    ABISELECT(656,616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20463C11,    ABISELECT(648,612), //bcp->offset
    29, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S20463C12,    ABISELECT(432,408), //bcp->offset
    17, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20463C8[];
extern void _ZN8S20463C8D1Ev();
extern void _ZN8S20463C8D0Ev();
extern void ABISELECT(_ZThn208_N8S20463C8D1Ev,_ZThn200_N8S20463C8D1Ev)();
extern void ABISELECT(_ZThn208_N8S20463C8D0Ev,_ZThn200_N8S20463C8D0Ev)();
extern void ABISELECT(_ZTv0_n56_N8S20463C8D1Ev,_ZTv0_n28_N8S20463C8D1Ev)();
extern void ABISELECT(_ZThn432_N8S20463C8D1Ev,_ZThn408_N8S20463C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S20463C8D0Ev,_ZTv0_n28_N8S20463C8D0Ev)();
extern void ABISELECT(_ZThn432_N8S20463C8D0Ev,_ZThn408_N8S20463C8D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20463C8D1Ev,_ZTv0_n16_N8S20463C8D1Ev)();
extern void ABISELECT(_ZThn648_N8S20463C8D1Ev,_ZThn612_N8S20463C8D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N8S20463C8D0Ev,_ZTv0_n16_N8S20463C8D0Ev)();
extern void ABISELECT(_ZThn648_N8S20463C8D0Ev,_ZThn612_N8S20463C8D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S20463C8[] = {
  ABISELECT(648,612),
  ABISELECT(576,544),
  ABISELECT(432,408),
  ABISELECT(424,404),
  ABISELECT(424,404),
  0,
  (VTBL_ENTRY)&(_ZTI8S20463C8[0]),
  (VTBL_ENTRY)&_ZN8S20463C8D1Ev,
  (VTBL_ENTRY)&_ZN8S20463C8D0Ev,
  ABISELECT(216,204),
  ABISELECT(-208,-200),
  (VTBL_ENTRY)&(_ZTI8S20463C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N8S20463C8D1Ev,_ZThn200_N8S20463C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N8S20463C8D0Ev,_ZThn200_N8S20463C8D0Ev),
  ABISELECT(144,136),
  ABISELECT(-280,-268),
  (VTBL_ENTRY)&(_ZTI8S20463C8[0]),
  ABISELECT(-432,-408),
  ABISELECT(-8,-4),
  ABISELECT(216,204),
  ABISELECT(-8,-4),
  ABISELECT(144,136),
  ABISELECT(-432,-408),
  (VTBL_ENTRY)&(_ZTI8S20463C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20463C8D1Ev,_ZTv0_n28_N8S20463C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20463C8D0Ev,_ZTv0_n28_N8S20463C8D0Ev),
  ABISELECT(-152,-140),
  ABISELECT(-576,-544),
  (VTBL_ENTRY)&(_ZTI8S20463C8[0]),
  ABISELECT(-648,-612),
  ABISELECT(-224,-208),
  ABISELECT(-648,-612),
  (VTBL_ENTRY)&(_ZTI8S20463C8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20463C8D1Ev,_ZTv0_n16_N8S20463C8D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N8S20463C8D0Ev,_ZTv0_n16_N8S20463C8D0Ev),
};
extern VTBL_ENTRY _ZTV8S20463C8[];
extern void _ZN8S20463C9D1Ev();
extern void _ZN8S20463C9D0Ev();
static  VTBL_ENTRY _tg__ZTV8S20463C9__8S20463C8[] = {
  ABISELECT(424,404),
  ABISELECT(424,404),
  0,
  (VTBL_ENTRY)&(_ZTI8S20463C9[0]),
  (VTBL_ENTRY)&_ZN8S20463C9D1Ev,
  (VTBL_ENTRY)&_ZN8S20463C9D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20463C108S20463C9__8S20463C8[] = {
  ABISELECT(424,404),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C10[0]),
};
extern void _ZN9S20463C11D1Ev();
extern void _ZN9S20463C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20463C118S20463C9__8S20463C8[] = {
  ABISELECT(216,204),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C11[0]),
  (VTBL_ENTRY)&_ZN9S20463C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20463C11D0Ev,
};
extern void ABISELECT(_ZThn208_N8S20463C9D1Ev,_ZThn200_N8S20463C9D1Ev)();
extern void ABISELECT(_ZThn208_N8S20463C9D0Ev,_ZThn200_N8S20463C9D0Ev)();
static  VTBL_ENTRY _tg__ZTV9S20463C11__8S20463C9__8S20463C8[] = {
  ABISELECT(216,204),
  ABISELECT(-208,-200),
  (VTBL_ENTRY)&(_ZTI8S20463C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N8S20463C9D1Ev,_ZThn200_N8S20463C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn208_N8S20463C9D0Ev,_ZThn200_N8S20463C9D0Ev),
};
static  VTBL_ENTRY _tg__ZTV9S20463C10__A__8S20463C8[] = {
  ABISELECT(144,136),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C10[0]),
};
extern void _ZN9S20463C12D1Ev();
extern void _ZN9S20463C12D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20463C12__8S20463C8[] = {
  ABISELECT(-8,-4),
  ABISELECT(216,204),
  ABISELECT(-8,-4),
  ABISELECT(144,136),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C12[0]),
  (VTBL_ENTRY)&_ZN9S20463C12D1Ev,
  (VTBL_ENTRY)&_ZN9S20463C12D0Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20463C10__9S20463C12__8S20463C8[] = {
  ABISELECT(-152,-140),
  ABISELECT(-144,-136),
  (VTBL_ENTRY)&(_ZTI9S20463C12[0]),
};
extern void ABISELECT(_ZTv0_n32_N9S20463C12D1Ev,_ZTv0_n16_N9S20463C12D1Ev)();
extern void ABISELECT(_ZThn216_N9S20463C12D1Ev,_ZThn204_N9S20463C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N9S20463C12D0Ev,_ZTv0_n16_N9S20463C12D0Ev)();
extern void ABISELECT(_ZThn216_N9S20463C12D0Ev,_ZThn204_N9S20463C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV9S20463C11__9S20463C12__8S20463C8[] = {
  ABISELECT(-216,-204),
  ABISELECT(-224,-208),
  ABISELECT(-216,-204),
  (VTBL_ENTRY)&(_ZTI9S20463C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20463C12D1Ev,_ZTv0_n16_N9S20463C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N9S20463C12D0Ev,_ZTv0_n16_N9S20463C12D0Ev),
};
static  VTBL_ENTRY _tg__ZTV9S20463C10__A2__8S20463C8[] = {
  ABISELECT(-152,-140),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C10[0]),
};
extern void _ZN9S20463C11D1Ev();
extern void _ZN9S20463C11D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20463C11__A1__8S20463C8[] = {
  ABISELECT(-224,-208),
  0,
  (VTBL_ENTRY)&(_ZTI9S20463C11[0]),
  (VTBL_ENTRY)&_ZN9S20463C11D1Ev,
  (VTBL_ENTRY)&_ZN9S20463C11D0Ev,
};
static  VTT_ENTRY vtt_S20463C8[] = {
  {&(_ZTV8S20463C8[7]),  7,35},
  {&(_tg__ZTV8S20463C9__8S20463C8[4]),  4,6},
  {&(_tg__ZTV9S20463C108S20463C9__8S20463C8[3]),  3,3},
  {&(_tg__ZTV9S20463C118S20463C9__8S20463C8[3]),  3,5},
  {&(_tg__ZTV9S20463C11__8S20463C9__8S20463C8[3]),  3,5},
  {&(_tg__ZTV9S20463C10__A__8S20463C8[3]),  3,3},
  {&(_ZTV8S20463C8[12]),  12,35},
  {&(_ZTV8S20463C8[17]),  17,35},
  {&(_ZTV8S20463C8[24]),  24,35},
  {&(_ZTV8S20463C8[29]),  29,35},
  {&(_ZTV8S20463C8[33]),  33,35},
  {&(_tg__ZTV9S20463C12__8S20463C8[6]),  6,8},
  {&(_tg__ZTV9S20463C10__9S20463C12__8S20463C8[3]),  3,3},
  {&(_tg__ZTV9S20463C11__9S20463C12__8S20463C8[4]),  4,6},
  {&(_tg__ZTV9S20463C10__A2__8S20463C8[3]),  3,3},
  {&(_tg__ZTV9S20463C11__A1__8S20463C8[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S20463C8[];
extern  VTBL_ENTRY _ZTV8S20463C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20463C8[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20463C12D0Ev,_ZTv0_n16_N9S20463C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S20463C12D0Ev,_ZThn204_N9S20463C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N9S20463C12D1Ev,_ZTv0_n16_N9S20463C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn216_N9S20463C12D1Ev,_ZThn204_N9S20463C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20463C8D0Ev,_ZTv0_n16_N8S20463C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn648_N8S20463C8D0Ev,_ZThn612_N8S20463C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N8S20463C8D1Ev,_ZTv0_n16_N8S20463C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn648_N8S20463C8D1Ev,_ZThn612_N8S20463C8D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20463C8D0Ev,_ZTv0_n28_N8S20463C8D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn432_N8S20463C8D0Ev,_ZThn408_N8S20463C8D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20463C8D1Ev,_ZTv0_n28_N8S20463C8D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn432_N8S20463C8D1Ev,_ZThn408_N8S20463C8D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20463C8 = {  "S20463C8", // class name
  bases_S20463C8, 27,
  &(vtc_S20463C8[0]), // expected_vtbl_contents
  &(vtt_S20463C8[0]), // expected_vtt_contents
  ABISELECT(720,680), // object size
  NSPAIRA(_ZTI8S20463C8),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20463C8),35, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20463C8),16, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20463C13  : S20463C6 , virtual S685C10_nt , S20463C11 , S20463C3 , S20463C8 {
  __tsi64 s20463c13f0;
  virtual  ~S20463C13(); // _ZN9S20463C13D2Ev
  S20463C13(); // tgen
};
//SIG(-1 S20463C13) C1{ BC2{ m FL[8]} VBC3{ m Fi} BC4{ BC5{ m} BC2 VBC3 vd} BC6{ BC3 BC5 BC2} BC7{ BC8{ BC6 BC5 BC9{ BC2 VBC5} BC2 BC4 vd} BC9 BC3 VBC10{ VBC9 BC6 VBC4 FC2} vd FL[8]} vd FL}


 S20463C13 ::~S20463C13(){ note_dtor("S20463C13", this);}
S20463C13 ::S20463C13(){ note_ctor("S20463C13", this);} // tgen

static void Test_S20463C13()
{
  extern Class_Descriptor cd_S20463C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(118,223)];
    init_test(&cd_S20463C13, buf);
    S20463C13 *dp, &lv = *(dp=new (buf) S20463C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(936,888), "sizeof(S20463C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20463C13)");
    /*is_ambiguous_... S20463C13::S20463C6 */ AMB_check_base_class_offset(lv, (S20463C6*), ABISELECT(72,68), "S20463C13");
    /*is_ambiguous_... S20463C13::S685C10_nt */ AMB_check_base_class_offset(lv, (S685C10_nt*), ABISELECT(640,612), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C11 */ AMB_check_base_class_offset(lv, (S685C10_nt*)(S20463C11*), ABISELECT(640,612), "S20463C13");
    check_base_class_offset(lv, (S685C10_nt*)(S20463C11*)(S20463C9*)(S20463C8*), ABISELECT(640,612), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C11 */ AMB_check_base_class_offset(lv, (S685C10_nt*)(S20463C11*), ABISELECT(640,612), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C11 */ AMB_check_base_class_offset(lv, (S972C24_nt*)(S20463C11*), 0, "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C11 */ AMB_check_base_class_offset(lv, (S20463C6*)(S20463C11*), ABISELECT(8,4), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C11 */ AMB_check_base_class_offset(lv, (S20463C11*), 0, "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C3 */ AMB_check_base_class_offset(lv, (S685C10_nt*)(S20463C3*), ABISELECT(136,132), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C3 */ AMB_check_base_class_offset(lv, (S972C24_nt*)(S20463C3*), ABISELECT(136,132), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C3 */ AMB_check_base_class_offset(lv, (S20463C6*)(S20463C3*), ABISELECT(144,136), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C3 */ AMB_check_base_class_offset(lv, (S20463C3*), ABISELECT(136,132), "S20463C13");
    check_base_class_offset(lv, (S685C10_nt*)(S20463C3*)(S20463C9*)(S20463C8*), ABISELECT(280,268), "S20463C13");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C3*)(S20463C9*)(S20463C8*), ABISELECT(280,268), "S20463C13");
    check_base_class_offset(lv, (S20463C6*)(S20463C3*)(S20463C9*)(S20463C8*), ABISELECT(288,272), "S20463C13");
    check_base_class_offset(lv, (S20463C3*)(S20463C9*)(S20463C8*), ABISELECT(280,268), "S20463C13");
    /*is_ambiguous_... S20463C9::S972C24_nt */ AMB_check_base_class_offset(lv, (S972C24_nt*)(S20463C9*)(S20463C8*), ABISELECT(208,200), "S20463C13");
    check_base_class_offset(lv, (S20463C6*)(S20463C10*)(S20463C9*)(S20463C8*), ABISELECT(216,204), "S20463C13");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C10*)(S20463C9*)(S20463C8*), ABISELECT(644,616), "S20463C13");
    /*is_ambiguous_... S20463C8::S20463C10 */ AMB_check_base_class_offset(lv, (S972C24_nt*)(S20463C10*)(S20463C8*), ABISELECT(644,616), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C10 */ AMB_check_base_class_offset(lv, (S972C24_nt*)(S20463C10*), ABISELECT(644,616), "S20463C13");
    check_base_class_offset(lv, (S20463C10*)(S20463C9*)(S20463C8*), ABISELECT(208,200), "S20463C13");
    /*is_ambiguous_... S20463C9::S20463C6 */ AMB_check_base_class_offset(lv, (S20463C6*)(S20463C9*)(S20463C8*), ABISELECT(352,336), "S20463C13");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C11*)(S20463C9*)(S20463C8*), ABISELECT(416,400), "S20463C13");
    check_base_class_offset(lv, (S20463C6*)(S20463C11*)(S20463C9*)(S20463C8*), ABISELECT(424,404), "S20463C13");
    check_base_class_offset(lv, (S20463C11*)(S20463C9*)(S20463C8*), ABISELECT(416,400), "S20463C13");
    check_base_class_offset(lv, (S20463C9*)(S20463C8*), ABISELECT(208,200), "S20463C13");
    /*is_ambiguous_... S20463C8::S20463C10 */ AMB_check_base_class_offset(lv, (S20463C6*)(S20463C10*)(S20463C8*), ABISELECT(496,472), "S20463C13");
    /*is_ambiguous_... S20463C8::S20463C10 */ AMB_check_base_class_offset(lv, (S20463C10*)(S20463C8*), ABISELECT(488,468), "S20463C13");
    /*is_ambiguous_... S20463C8::S685C10_nt */ AMB_check_base_class_offset(lv, (S685C10_nt*)(S20463C8*), ABISELECT(560,536), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C10 */ AMB_check_base_class_offset(lv, (S20463C6*)(S20463C10*), ABISELECT(800,756), "S20463C13");
    check_base_class_offset(lv, (S20463C10*)(S20463C12*), ABISELECT(792,752), "S20463C13");
    check_base_class_offset(lv, (S685C10_nt*)(S20463C3*)(S20463C12*), ABISELECT(656,620), "S20463C13");
    check_base_class_offset(lv, (S972C24_nt*)(S20463C3*)(S20463C12*), ABISELECT(656,620), "S20463C13");
    check_base_class_offset(lv, (S20463C6*)(S20463C3*)(S20463C12*), ABISELECT(664,624), "S20463C13");
    check_base_class_offset(lv, (S20463C3*)(S20463C12*), ABISELECT(656,620), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C11 */ AMB_check_base_class_offset(lv, (S972C24_nt*)(S20463C11*), ABISELECT(864,820), "S20463C13");
    /*is_ambiguous_... S20463C13::S20463C11 */ AMB_check_base_class_offset(lv, (S20463C6*)(S20463C11*), ABISELECT(872,824), "S20463C13");
    check_base_class_offset(lv, (S20463C11*)(S20463C12*), ABISELECT(864,820), "S20463C13");
    check_base_class_offset(lv, (S20463C12*)(S20463C8*), ABISELECT(648,616), "S20463C13");
    check_base_class_offset(lv, (S20463C8*), ABISELECT(208,200), "S20463C13");
    check_field_offset(lv, s20463c13f0, ABISELECT(632,604), "S20463C13.s20463c13f0");
    test_class_info(&lv, &cd_S20463C13);
    dp->~S20463C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20463C13(Test_S20463C13, "S20463C13", ABISELECT(936,888));

#else // __cplusplus

extern void _ZN9S20463C13C1Ev();
extern void _ZN9S20463C13D2Ev();
Name_Map name_map_S20463C13[] = {
  NSPAIR(_ZN9S20463C13C1Ev),
  NSPAIR(_ZN9S20463C13D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C11;
extern VTBL_ENTRY _ZTI9S20463C11[];
extern  VTBL_ENTRY _ZTV9S20463C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C11[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C3;
extern VTBL_ENTRY _ZTI8S20463C3[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C3;
extern VTBL_ENTRY _ZTI8S20463C3[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C10;
extern VTBL_ENTRY _ZTI9S20463C10[];
extern  VTBL_ENTRY _ZTV9S20463C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C10[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C11;
extern VTBL_ENTRY _ZTI9S20463C11[];
extern  VTBL_ENTRY _ZTV9S20463C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C11[];
extern Class_Descriptor cd_S20463C9;
extern VTBL_ENTRY _ZTI8S20463C9[];
extern  VTBL_ENTRY _ZTV8S20463C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20463C9[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C10;
extern VTBL_ENTRY _ZTI9S20463C10[];
extern  VTBL_ENTRY _ZTV9S20463C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C10[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C10;
extern VTBL_ENTRY _ZTI9S20463C10[];
extern  VTBL_ENTRY _ZTV9S20463C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C10[];
extern Class_Descriptor cd_S685C10_nt;
extern VTBL_ENTRY _ZTI10S685C10_nt[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C3;
extern VTBL_ENTRY _ZTI8S20463C3[];
extern Class_Descriptor cd_S972C24_nt;
extern VTBL_ENTRY _ZTI10S972C24_nt[];
extern Class_Descriptor cd_S20463C6;
extern VTBL_ENTRY _ZTI8S20463C6[];
extern Class_Descriptor cd_S20463C11;
extern VTBL_ENTRY _ZTI9S20463C11[];
extern  VTBL_ENTRY _ZTV9S20463C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C11[];
extern Class_Descriptor cd_S20463C12;
extern VTBL_ENTRY _ZTI9S20463C12[];
extern  VTBL_ENTRY _ZTV9S20463C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20463C12[];
extern Class_Descriptor cd_S20463C8;
extern VTBL_ENTRY _ZTI8S20463C8[];
extern  VTBL_ENTRY _ZTV8S20463C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20463C8[];
static Base_Class bases_S20463C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20463C6,    ABISELECT(72,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S685C10_nt,    ABISELECT(640,612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S972C24_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //nu